CDF  S   
      pressure          ,   Conventions       CF-1.6     featureType       profile    title         GRAN CTD data Ship: HMAS Melville Cruise: HI509MEL_M ProfileID: 10410012    summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule. The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.    keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $2e2f15e4-b316-4502-9a5b-26116ca1df56   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      ;Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.
 
CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.    date_created      2013-01-24T09:31:26    
date_modified         2013-02-01T09:05:23    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-19.88315      geospatial_lat_max        	-19.88315      geospatial_lon_min        	148.46443      geospatial_lon_max        	148.46443      geospatial_vertical_min       01.00      geospatial_vertical_max       1363.00    geospatial_vertical_units         decibars   time_coverage_start       2012-01-10T05:48:56Z   time_coverage_end         2012-01-10T05:48:56Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI509MEL_M     water_depth       40.5   
ship_speed        12.9   source_filename       HI509_0010.raw     data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      CTD_pressure_offset       0.0    CTD_MinRawPressure        -0.10      CTD_MaxRawPressure        1363.10    CTD_MinPressureforInterp      0.10   CTD_MaxPressureforInterp      1363.10    CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    0   position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1    temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1   temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        1   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1    salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1$   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         0@ 3Ov`@bܜM  ?      @<stj~@A5?|@       @<q&x@Ap:~@      @<h9Xb@A+@      @<KQ@AZ@      @<0bM@Ag	l@      @<0`A7@AJM@      @<E@A&IR@       @<I^5?@A=p
@"      @;-V@AXbM@$      @;KƧ@A|Q@&      @;9XbN@A~($@(      @;iB@A+@*      @;񰉠'R@A [7@,      @;H˒:@A-w1@.      @;O;dZ@A@0      @;n@A9Xb@1      @;n@Ad8@2      @;n@A
=q@3      @;n@Au%F@4      @;n@A-
@5      @;n@AYJ@6      @;n@A|@7      @;n@Ar Ĝ@8      @;n@Ahۋq@9      @;n@AbM@:      @;n@AXy=@;      @;n@ANU@<      @;n@AD*@=      @;n@A:~ @>      @;n@A1&x@?      @;n@A*0@@      @;n@A ě@@     @;n@A@A      @;n@A
qu@A     @;n@AF]d@B      @;n@ArGE9@B     @;n@A-@C      @;n@ArG@C     @;n@A;dZ@D      @;n@AfA@D     @;n@A˒:)@E      @;n@A@E     @;n@Ar@F      @;n@A[W>@F     @;n@A&@G      @;n@A-V@G     @;n@Aݗ+@H      @;n@A	@H     @;n@A4m@I      @;Y@Av_ح@I     @;Y@Ao@J      @;Y@Aeں@J     @;Y@A\(@K      @;Y@ART`e@K     @;Y@AH˒:@L      @;Y@A>6z@L     @;Y@A8}H@M      @;Y@A.H@M     @;Y@A$tS@N      @;Y@Av@N     @;Y@A)^@O      @;Y@AFt@O     @;Y@A hۋ@P      @;Y@AFs@P@     @;Y@A쿱[W@P     @;Y@AC-@P     @;Y@A+@Q      @;Y@AA@Q@     @;Y@Am\@Q     @;Y@Aߤ?@Q     @;Y@A'@R      @;Y@A6z@R@     @;Y@Aaf@R     @;Y@AO;@R     @;Y@A@S      @;Y@A+J@S@     @;Y@A}Vl@S     @;Y@As@S     @;Y@AiB@T      @;Y@A_ح@T@     @;Y@AVu@T     @;Y@AL/{J@T     @;Y@AE@U      @;Y@A;5X@U@     @;Y@A1.@U     @;Y@A($x@U     @;Y@AOv_@V      @;Y@AzG@V@     @;Y@A
(@V     @;Y@At@V     @;Y@AC\@W      @;Y@AoiDg@W@     @;Y@A,=@W     @;Y@A?@W     @;Y@A@X      @;Y@AcA @X@     @;Y@A\(@X     @;Y@A@X     @;Y@A1@Y      @;Y@Av@Y@     @;Y@A=K@Y     @;Y@AO
@Y     @;Y@AڹZ@Z      @;Y@A$/@Z@     @;Y@Aw1@Z     @;Y@Am\@Z     @;Y@Ace@[      @;Y@AY|@[@     @;Y@AS&@[     @;Y@AIQ@[     @;Y@A?|h@\      @;Y@A5Xy>@\@     @;Y@A+a@\     @;Y@A!.H@\     @;Y@Aqu"@]      @;Y@Au@]@     @;g	@AK]@]     @;g	@AE@]     @;g	@A!-w@^      @;g	@AJM@^@     @;g	@AZ@^     @;g	@A>B[@^     @;g	@A*0@_      @;g	@A?@_@     @;g	@Aj~@_     @;g	@A@_     @;g	@ATɆ@`      @;g	@A3@`      @;g	@A_@`@     @;g	@Aqj@``     @;g	@A?@`     @;g	@AzG@`     @;g	@Aq@`     @;g	@Aj~#@`     @;g	@A`d@a      @;g	@AVϪ@a      @;g	@AM:@a@     @;g	@AC,zx@a`     @;g	@A9XbN@a     @;g	@A/{J#@a     @;g	@A(\@a     @;g	@A!-w2@a     @;g	@AL_@b      @;g	@AxF@b      @;g	@An.@b@     @;g	@A@b`     @;g	@AA [@b     @;g	@AlC@b     @;g	@Aݗ+k@b     @;g	@Aa@@b     @;g	@A@c      @;g	@A6@c      @;g	@AE@c@     @;g	@A@c`     @;g	@AS@c     @;g	@Aߤ@c     @;g	@A:)z@c     @;g	@AeO@c     @;g	@A~$@d      @;g	@AxF]@d      @;g	@An.3@d@     @;g	@AdZ@d`     @;g	@AZ@d     @;g	@AP{@d     @;g	@AF]c@d     @;g	@A=K^@d     @;g	@A6z@e      @;g	@A,zxl@e      @;g	@A"`B@e@     @;g	@APH@e`     @;g	@A'/@e     @;g	@AS&@e     @;g	@Am\@e     @;g	@AD@e     @;g	@AC,@f      @;g	@AG{@f      @;g	@AsP@f@     @;g	@A͞&@f`     @;g	@A)_@f     @;g	@A<64@f     @;g	@Ag	@f     @;g	@A@f     @;g	@Avȴ@g      @;>B@Aᰊ@g      @;>B@AL_@g@     @;>B@Aݘ@g`     @;>B@A{m@g     @;>B@AqiC@g     @;>B@Ah	ԕ@g     @;>B@A^5?|@g     @;>B@AT`d@h      @;>B@AM@h      @;>B@AC\@h@     @;>B@A:)y@h`     @;>B@A0U2a|@h     @;>B@A&IR@h     @;>B@A1'@h     @;>B@As@h     @;>B@AI^5@i      @;>B@Au%F@i      @;>B@A-@i@     @;>B@A@i`     @;>B@Ae@i     @;>B@A"`@i     @;>B@Aԕ*@i     @;>B@Ao@i     @;>B@AD@j      @;>B@AX@j      @;>B@AB@j@     @;>B@An.@j`     @;>B@A@j     @;>B@A@j     @;>B@A7Kƨ@j     @;>B@Ab}@j     @;>B@Au!S@k      @;>B@Ak~(@k      @;>B@Aae@k@     @;>B@A[W>6@k`     @;>B@AQ@k     @;>B@AGz@k     @;>B@A=b@k     @;>B@A4J@k     @;>B@A*0U2a@l      @;>B@A [7@l      @;>B@A_p@l@     @;>B@ArGE@l`     @;>B@A$/@l     @;>B@APH@l     @;>B@A{@l     @;>B@A@l     @;>B@Ae+@m      @;>B@AD@m      @;>B@Ap:@m@     @;>B@AěT@m`     @;>B@A)@m     @;>B@A{@m     @;>B@Ad8@m     @;>B@A-
@m     @;>B@A@n      @;>B@A@n      @;>B@An@n@     @;>B@Ay=c@n`     @;>B@AoiDg8@n     @;>B@Ahۋq@n     @;>B@A_F@n     @;>B@AU2a|@n     @;>B@AK]c@o      @;>B@AA7K@o      @;>B@A73@o@     @;>B@A1&x@o`     @;>B@A'RT`@o     @;L/{@A}H@o     @;L/{@A*0U@o     @;L/{@A	ԕ+@o     @;L/{@A     @p      @;L/{@A+j@p     @;L/{@A-@p      @;L/{@A@p0     @;L/{@A@p@     @;L/{@A@pP     @;L/{@AK]d@p`     @;L/{@Avȴ9@pp     @;L/{@Ar@p     @;L/{@AzH@p     @;L/{@A?@p     @;L/{@AkP@p     @;L/{@A@p     @;L/{@A&@p     @;L/{@A|hs@p     @;L/{@Av_ح@p     @;L/{@AlC@q      @;L/{@Ab}V@q     @;L/{@AXe,@q      @;L/{@AO
M@q0     @;L/{@AE84@q@     @;L/{@A>6z@qP     @;L/{@A4֡a@q`     @;L/{@A+I@qp     @;L/{@A!-w1@q     @;L/{@AXe@q     @;L/{@A
M;@q     @;L/{@A@q     @;L/{@A!.I@q     @;L/{@AMj@q     @;L/{@Ax@q     @;L/{@Aߤ?@q     @;L/{@AϪ͟@r      @;L/{@At@r     @;L/{@Am\@r      @;L/{@A@r0     @;L/{@A2X@r@     @;L/{@A-@rP     @;L/{@A@r`     @;L/{@AFs@rp     @;L/{@A@r     @;L/{@A%@r     @;L/{@Az@r     @;L/{@Ap:~@r     @;L/{@Afffff@r     @;L/{@A\N<@r     @;L/{@AR<6@r     @;L/{@AL/{J@r     @;L/{@ABZc @s      @;L/{@A8YJ@s     @;L/{@A.2@s      @;L/{@A$/@s0     @;L/{@Au@s@     @;L/{@AzG@sP     @;L/{@A
L/@s`     @;L/{@A ѷY@sp     @;L/{@A!.@s     @;L/{@A(@s     @;L/{@AS@s     @;L/{@Ab@s     @;L/{@A@s     @;L/{@A@s     @;L/{@AH˒@s     @;L/{@Ash@s     @;ꟾvȴ@AU=@t      @;ꟾvȴ@A@t     @;ꟾvȴ@A=K@t      @;ꟾvȴ@Ahr!@t0     @;ꟾvȴ@Aݗ@t@     @;ꟾvȴ@A}H@tP     @;ꟾvȴ@Asg@t`     @;ꟾvȴ@AjOv@tp     @;ꟾvȴ@A`A7L@t     @;ꟾvȴ@AY|@t     @;ꟾvȴ@AO;dZ@t     @;ꟾvȴ@AF
L0@t     @;ꟾvȴ@A<64@t     @;ꟾvȴ@A2a|@t     @;ꟾvȴ@A(@t     @;ꟾvȴ@A!.H@t     @;ꟾvȴ@A*0@u      @;ꟾvȴ@AV@u     @;ꟾvȴ@Ao i@u      @;ꟾvȴ@A>@u0     @;ꟾvȴ@AD@u@     @;ꟾvȴ@A@uP     @;ꟾvȴ@Au"@u`     @;ꟾvȴ@A֡a@up     @;ꟾvȴ@A@u     @;ꟾvȴ@A7@u     @;ꟾvȴ@A#x@u     @;ꟾvȴ@AO
M@u     @;ꟾvȴ@ATɆ@u     @;ꟾvȴ@A쿱[@u     @;ꟾvȴ@A*1@u     @;ꟾvȴ@AC@u     @;ꟾvȴ@Ao h@v      @;ꟾvȴ@AwkP@v     @;ꟾvȴ@Aq@v      @;ꟾvȴ@Ag8}@v0     @;ꟾvȴ@A]ce@v@     @;ꟾvȴ@ASMj@vP     @;ꟾvȴ@AI^5?@v`     @;ꟾvȴ@A?@vp     @;ꟾvȴ@A64@v     @;ꟾvȴ@A/{J#@v     @;ꟾvȴ@A%1@v     @;ꟾvȴ@AQ@v     @;ꟾvȴ@A@v     @;ꟾvȴ@A1&y@v     @;ꟾvȴ@A\N@v     @;ꟾvȴ@A@v     @;ꟾvȴ@AC]@w      @;ꟾvȴ@A%2@w     @;ꟾvȴ@AQ@w      @;ꟾvȴ@A|@w0     @;ꟾvȴ@AƧ@w@     @;ꟾvȴ@AZ@wP     @;ꟾvȴ@AE@w`     @;ꟾvȴ@Aq@wp     @;ꟾvȴ@Awk@w     @;ꟾvȴ@AA@w     @;ꟾvȴ@AMj@w     @;ꟾvȴ@AQ@w     @;ꟾvȴ@A~$@w     @;ꟾvȴ@Atj~@w     @;ꟾvȴ@Ajf@w     @;ꟾvȴ@Aa@N@w     @;ꟾvȴ@AW>6z@x      @;ꟾvȴ@AMjO@x     @;ꟾvȴ@AC%@x      @;ꟾvȴ@A=K^@x0     @;0
@A33333@x@     @;0
@A)^	@xP     @;0
@A	@x`     @;0
@As@xp     @;0
@A҉@x     @;0
@AS&@x     @;0
@A~@x     @;0
@Am@x     @;0
@AfB@x     @;0
@A ѷ@x     @;0
@A,<@x     @;0
@AW@x     @;0
@A@y      @;0
@AY@y     @;0
@A ě@y      @;0
@AL/{@y0     @;0
@AwkQ@y@     @;0
@AS&@yP     @;0
@AL_@y`     @;0
@A@4@yp     @;0
@Axl"h
@y     @;0
@AnO@y     @;0
@Ad7@y     @;0
@AZc@y     @;0
@AT`d@y     @;0
@AJL@y     @;0
@A@4n@y     @;0
@A6C@y     @;0
@A-V@z      @;0
@A#9@z     @;0
@Ae+@z      @;0
@As@z0     @;0
@A	 @z@     @;0
@A.H@zP     @;0
@AY}@z`     @;0
@AR@zp     @;0
@Aᰉ'@z     @;0
@A"`@z     @;0
@AN;6@z     @;0
@Ay@z     @;0
@A@z     @;0
@A|@z     @;0
@Al@z     @;0
@A'RTa@z     @;0
@A@{      @;0
@Ao@{     @;0
@AoiD@{      @;0
@A|Q@{0     @;0
@ArGE8@{@     @;0
@Ahr @{P     @;0
@Aae@{`     @;0
@AXbM@{p     @;0
@AN;5@{     @;0
@ADg8~@{     @;0
@A:S@{     @;0
@A0
)@{     @;0
@A&x@{     @;0
@A [7@{     @;0
@A+@{     @;0
@A@{     @;0
@A ѷ@|      @;0
@A	k@|     @;0
@A4֡b@|      @;0
@A@|0     @;0
@A҈p@|@     @;0
@AF@|P     @;0
@A)^@|`     @;꒣S&@ATɅ@|p     @;꒣S&@A4m@|     @;꒣S&@AU@|     @;꒣S&@A@|     @;꒣S&@AIQ@|     @;꒣S&@Atj@|     @;꒣S&@A'RT@|     @;꒣S&@A˒:*@|     @;꒣S&@Au!@|     @;꒣S&@AoiDg8@}      @;꒣S&@AeO@}     @;꒣S&@A[6@}      @;꒣S&@AQ@}0     @;꒣S&@AH@}@     @;꒣S&@A>BZc@}P     @;꒣S&@A73@}`     @;꒣S&@A-
q@}p     @;꒣S&@A$xG@}     @;꒣S&@A6@}     @;꒣S&@AbM@}     @;꒣S&@A@}     @;꒣S&@A#@}     @;꒣S&@A+j@}     @;꒣S&@AVϫ@}     @;꒣S&@A@@}     @;꒣S&@AحV@~      @;꒣S&@A+@~     @;꒣S&@Ao @~      @;꒣S&@Avȴ9@~0     @;꒣S&@A3@~@     @;꒣S&@A͞@~P     @;꒣S&@A	k@~`     @;꒣S&@A$tS@~p     @;꒣S&@AO;d@~     @;꒣S&@A{J#:@~     @;꒣S&@A|hs@~     @;꒣S&@AsPH@~     @;꒣S&@AiDg8@~     @;꒣S&@A_o@~     @;꒣S&@AU=@~     @;꒣S&@AKƧ@~     @;꒣S&@AE84@      @;꒣S&@A;dZ@     @;꒣S&@A1@      @;꒣S&@A'/W@0     @;꒣S&@A,@@     @;꒣S&@A@P     @;꒣S&@A
=p@`     @;꒣S&@A@p     @;꒣S&@A"@     @;꒣S&@A@     @;꒣S&@A1@     @;꒣S&@A]cf@     @;꒣S&@A҈p;@     @;꒣S&@At@     @;꒣S&@A&I@     @;꒣S&@AQ@     @;꒣S&@A}Vl@      @;꒣S&@AT@     @;꒣S&@A,<@     @;꒣S&@A$t@     @;꒣S&@Aqi@      @;꒣S&@AIQ@(     @;꒣S&@Avȴ9X@0     @;꒣S&@Al!-@8     @;꒣S&@Ac	@@     @;꒣S&@AYJ@H     @;L_@AR<6@P     @;L_@AH@X     @;L_@A?@`     @;L_@A5?|@h     @;L_@A+jg@p     @;L_@A!R<@x     @;L_@Au@     @;L_@A4K@     @;L_@A_o @     @;L_@Aڹ@     @;L_@AE@     @;L_@Aᰉ@     @;L_@A
qv@     @;L_@Ab@     @;L_@AϪ͞@     @;L_@A8Y@     @;L_@An/@     @;L_@A-V@     @;L_@AXy=@     @;L_@A@     @;L_@A+j@     @;L_@A!R@     @;L_@AM:@      @;L_@Azxl"h@     @;L_@Ap
=@     @;L_@AfA@     @;L_@A`A7L@      @;L_@AVl!@(     @;L_@AL_@0     @;L_@AB@8     @;L_@A84֡@@     @;L_@A/w@H     @;L_@A(@P     @;L_@AQ@X     @;L_@A[@`     @;L_@A'0@h     @;L_@A:@p     @;L_@Ae@x     @;L_@Ahr@     @;L_@A@     @;L_@A/@     @;L_@AZ@     @;L_@AɅoi@     @;L_@A[W?@     @;L_@A?@     @;L_@AO
M@     @;L_@Azxl"@     @;L_@AS@     @;L_@AN;@     @;L_@A#@     @;L_@A~($x@     @;L_@AtSM@     @;L_@Am8@     @;L_@AcA \@     @;L_@AZ1@      @;L_@APH@     @;L_@AFs@     @;L_@A<쿱@     @;L_@A64@      @;L_@A,<@(     @;L_@A"h	ԕ@0     @;L_@Atj@8     @;L_@Aߤ@@@     @;L_@AJ@H     @;L_@A\N@P     @;L_@A$@X     @;L_@Ag@`     @;L_@A҈@h     @;ꅇݘ@A
=p@p     @;ꅇݘ@A5Xy@x     @;ꅇݘ@Aa@O@     @;ꅇݘ@AZ@     @;ꅇݘ@Am]@     @;ꅇݘ@A*0U2@     @;ꅇݘ@AU=@     @;ꅇݘ@A$@     @;ꅇݘ@Aq@     @;ꅇݘ@AQ@     @;ꅇݘ@A{J#9@     @;ꅇݘ@Aqu!@     @;ꅇݘ@Ag	l@     @;ꅇݘ@A]cA@     @;ꅇݘ@AS@     @;ꅇݘ@AJ#9@     @;ꅇݘ@AC%@     @;ꅇݘ@A9@     @;ꅇݘ@A/V@      @;ꅇݘ@A&@     @;ꅇݘ@AC,z@     @;ꅇݘ@AnP@     @;ꅇݘ@A҉@      @;ꅇݘ@AI^@(     @;ꅇݘ@A74@0     @;ꅇݘ@Ac	@8     @;ꅇݘ@A䎊q@@     @;ꅇݘ@AڹY@H     @;ꅇݘ@A`A@P     @;ꅇݘ@AW@X     @;ꅇݘ@An@`     @;ꅇݘ@A}Vm@h     @;ꅇݘ@A>B@p     @;ꅇݘ@AS&@x     @;ꅇݘ@A0
@     @;ꅇݘ@AS&@     @;ꅇݘ@Ap:@     @;ꅇݘ@A~"@     @;ꅇݘ@Au%F
@     @;ꅇݘ@AkP|@     @;ꅇݘ@Aa|Q@     @;ꅇݘ@AW'@     @;ꅇݘ@AQ_@     @;ꅇݘ@AGE85@     @;ꅇݘ@A=p
@     @;ꅇݘ@A3@     @;ꅇݘ@A)y@     @;ꅇݘ@A䎊@     @;ꅇݘ@Ae+@     @;ꅇݘ@A@     @;ꅇݘ@An@      @;ꅇݘ@AlD@     @;ꅇݘ@As@     @;ꅇݘ@A>BZ@     @;ꅇݘ@Aᰉ'@      @;ꅇݘ@A@(     @;ꅇݘ@A_o@0     @;ꅇݘ@A2W@8     @;ꅇݘ@A^5?}@@     @;ꅇݘ@A'R@H     @;ꅇݘ@A(@P     @;ꅇݘ@A'RTa@X     @;ꅇݘ@AR<6@`     @;ꅇݘ@A~($@h     @;ꅇݘ@A@p     @;ꅇݘ@Ax@x     @;ꅇݘ@Ao hی@     @;~"@Ahr @     @;~"@A^@     @;~"@ATɅo@     @;~"@AJE@     @;~"@AA [@     @;~"@A7KƧ@     @;~"@A-w1@     @;~"@A&x@     @;~"@A@     @;~"@A@N@     @;~"@A	k~@     @;~"@A$tT@     @;~"@A\)@     @;~"@A4֡b@     @;~"@A`A7@     @;~"@Aۋq
@      @;~"@AѷX@     @;~"@A@@     @;~"@A
(@     @;~"@A9Xb@      @;~"@AU@(     @;~"@A
=q@0     @;~"@Au%F@8     @;~"@A-
@@     @;~"@AYJ@H     @;~"@A|@P     @;~"@Au!@X     @;~"@Al"h	@`     @;~"@AbM@h     @;~"@AXy=@p     @;~"@ANU@x     @;~"@AD*@     @;~"@A:~ @     @;~"@A4m9@     @;~"@A*0@     @;~"@A ě@     @;~"@A@     @;~"@A
qu@     @;~"@AF]d@     @;~"@A#@     @;~"@A䎊r@     @;~"@ArG@     @;~"@A;dZ@     @;~"@AfA@     @;~"@A˒:)@     @;~"@Ao @     @;~"@A/V@     @;~"@A[W>@      @;~"@A&@     @;~"@A-V@     @;~"@Aݗ+@     @;~"@A	@      @;~"@A{J#:@(     @;~"@Ay@0     @;~"@Ao@8     @;~"@Aeں@@     @;~"@A\(@H     @;~"@ART`e@P     @;~"@AKƧ@X     @;~"@AAs@`     @;~"@A8}H@h     @;~"@A.H@p     @;~"@A$tS@x     @;~"@Av@     @;~"@A)^@     @;~"@A
=p@     @;~"@A hۋ@     @;xl"h
@AFs@     @;xl"h
@A쿱[W@     @;xl"h
@AC-@     @;xl"h
@A+@     @;xl"h
@A҈p;@     @;xl"h
@Aȴ9X@     @;xl"h
@Aߤ?@     @;xl"h
@A'@     @;xl"h
@A6z@     @;xl"h
@Aaf@     @;xl"h
@AO;@     @;xl"h
@A$t@     @;xl"h
@A+J@      @;xl"h
@A}Vl@     @;xl"h
@As@     @;xl"h
@AiB@     @;xl"h
@A_ح@      @;xl"h
@AYJ@(     @;xl"h
@AOv_خ@0     @;xl"h
@AE@8     @;xl"h
@A;5X@@     @;xl"h
@A1.@H     @;xl"h
@A($x@P     @;xl"h
@AOv_@X     @;xl"h
@A@`     @;xl"h
@A
(@h     @;xl"h
@At@p     @;xl"h
@AC\@x     @;xl"h
@AoiDg@     @;xl"h
@A,=@     @;xl"h
@A
qv@     @;xl"h
@A8YK@     @;xl"h
@AcA @     @;xl"h
@A\(@     @;xl"h
@A@     @;xl"h
@A1@     @;xl"h
@AXy=@     @;xl"h
@A%@     @;xl"h
@AO
@     @;xl"h
@AڹZ@     @;xl"h
@A$/@     @;xl"h
@Aw1@     @;xl"h
@Am\@     @;xl"h
@AfA@     @;xl"h
@A\@      @;xl"h
@AS&@     @;xl"h
@AIQ@     @;xl"h
@A?|h@     @;xl"h
@A5Xy>@      @;xl"h
@A/w@(     @;xl"h
@A%F
L@0     @;xl"h
@Aqu"@8     @;xl"h
@Au@@     @;xl"h
@AK]@H     @;xl"h
@AE@P     @;xl"h
@A!-w@X     @;xl"h
@Ahr@`     @;xl"h
@AZ@h     @;xl"h
@A>B[@p     @;xl"h
@A*0@x     @;xl"h
@A?@     @;xl"h
@Aj~@     @;xl"h
@A?@     @;xl"h
@A1&@     @;xl"h
@A3@     @;xl"h
@A_@     @;xl"h
@Aqj@     @;xl"h
@A?@     @;qiC@AzG@     @;qiC@AtSM@     @;qiC@Aj~#@     @;qiC@A`d@     @;qiC@AVϪ@     @;qiC@AM:@     @;qiC@AC,zx@     @;qiC@A<쿱@     @;qiC@A2W@      @;qiC@A(\@     @;qiC@A!-w2@     @;qiC@AL_@     @;qiC@AxF@      @;qiC@An.@(     @;qiC@As@0     @;qiC@AA [@8     @;qiC@AlC@@     @;qiC@Aݗ+k@H     @;qiC@Aa@@P     @;qiC@A@X     @;qiC@Aa@O@`     @;qiC@A~($@h     @;qiC@A@p     @;qiC@AS@x     @;qiC@Aߤ@     @;qiC@A:)z@     @;qiC@Aq@     @;qiC@A@     @;qiC@AxF]@     @;qiC@An.3@     @;qiC@AdZ@     @;qiC@AZ@     @;qiC@AP{@     @;qiC@AJ#9@     @;qiC@A@N@     @;qiC@A6z@     @;qiC@A,zxl@     @;qiC@A"`B@     @;qiC@APH@     @;qiC@AnP@     @;qiC@Au%@      @;qiC@Am\@     @;qiC@AD@     @;qiC@AC,@     @;qiC@AG{@      @;qiC@AsP@(     @;qiC@A`A@0     @;qiC@A)_@8     @;qiC@A<64@@     @;qiC@Ag	@H     @;qiC@A@P     @;qiC@Avȴ@X     @;qiC@A0
@`     @;qiC@A\(@h     @;qiC@Aݘ@p     @;qiC@A{m@x     @;qiC@AqiC@     @;qiC@Ah	ԕ@     @;qiC@A^5?|@     @;qiC@AW'@     @;qiC@AM@     @;qiC@AC\@     @;qiC@A:)y@     @;qiC@A0U2a|@     @;qiC@A&IR@     @;qiC@A䎊@     @;qiC@AOv`@     @;kP|@AI^5@     @;kP|@Au%F@     @;kP|@A-@     @;kP|@A@     @;kP|@Ae@     @;kP|@AiB@      @;kP|@Aԕ*@     @;kP|@Ao@     @;kP|@AD@     @;kP|@AX@      @;kP|@AB@(     @;kP|@A(@0     @;kP|@Au@8     @;kP|@A@@     @;kP|@A7Kƨ@H     @;kP|@Ab}@P     @;kP|@Au!S@X     @;kP|@Ao hی@`     @;kP|@Ae+a@h     @;kP|@A[W>6@p     @;kP|@AQ@x     @;kP|@AGz@     @;kP|@A=b@     @;kP|@A4J@     @;kP|@A-w1@     @;kP|@A#w@     @;kP|@A_p@     @;kP|@ArGE@     @;kP|@A$/@     @;kP|@APH@     @;kP|@A\)@     @;kP|@AC@     @;kP|@Ae+@     @;kP|@AD@     @;kP|@Ap:@     @;kP|@AěT@     @;kP|@A)@     @;kP|@A9Xb@      @;kP|@Ad8@     @;kP|@A-
@     @;kP|@A@     @;kP|@A@      @;kP|@An@(     @;kP|@A|@0     @;kP|@Ar Ĝ@8     @;kP|@Ahۋq@@     @;kP|@A_F@H     @;kP|@AU2a|@P     @;kP|@AK]c@X     @;kP|@AA7K@`     @;kP|@A:~ @h     @;kP|@A1&x@p     @;kP|@A'RT`@x     @;kP|@A}H@     @;kP|@A*0U@     @;kP|@A	ԕ+@     @;kP|@AF]d@     @;kP|@ArGE9@     @;kP|@A-@     @;kP|@A@     @;kP|@A@     @;kP|@A@     @;kP|@AK]d@     @;kP|@A@     @;kP|@Ar@     @;kP|@AzH@     @;kP|@A?@     @;kP|@AkP@     @;d7@A@     @;d7@A	@      @;d7@A4m@     @;d7@Av_ح@     @;d7@AlC@     @;d7@Ab}V@      @;d7@AXe,@(     @;d7@ART`e@0     @;d7@AH˒:@8     @;d7@A>6z@@     @;d7@A4֡a@H     @;d7@A+I@P     @;d7@A!-w1@X     @;d7@AXe@`     @;d7@A)^@h     @;d7@AFt@p     @;d7@A!.I@x     @;d7@AMj@     @;d7@Ax@     @;d7@Aߤ?@     @;d7@A+@     @;d7@AA@     @;d7@Am\@     @;d7@A@     @;d7@A2X@     @;d7@A-@     @;d7@A@     @;d7@AO;@     @;d7@A@     @;d7@A%@     @;d7@Az@     @;d7@Ap:~@     @;d7@Afffff@     @;d7@A_ح@      @;d7@AVu@     @;d7@AL/{J@     @;d7@ABZc @     @;d7@A8YJ@      @;d7@A.2@(     @;d7@A$/@0     @;d7@AOv_@8     @;d7@AzG@@     @;d7@A
L/@H     @;d7@A ѷY@P     @;d7@A!.@X     @;d7@A(@`     @;d7@A,=@h     @;d7@A?@p     @;d7@A@x     @;d7@A@     @;d7@AH˒@     @;d7@Ash@     @;d7@AU=@     @;d7@Av@     @;d7@A=K@     @;d7@Ahr!@     @;d7@Aݗ@     @;d7@A}H@     @;d7@Asg@     @;d7@Am\@     @;d7@Ace@     @;d7@AY|@     @;d7@AO;dZ@     @;d7@AF
L0@     @;d7@A<64@     @;d7@A5Xy>@      @;d7@A+a@     @;^5?|@A!.H@     @;^5?|@A*0@     @;^5?|@AV@      @;^5?|@Ao i@(     @;^5?|@A>@0     @;^5?|@A!-w@8     @;^5?|@AJM@@     @;^5?|@Au"@H     @;^5?|@A֡a@P     @;^5?|@A@X     @;^5?|@A7@`     @;^5?|@Aj~@h     @;^5?|@A@p     @;^5?|@ATɆ@x     @;^5?|@A쿱[@     @;^5?|@A*1@     @;^5?|@AC@     @;^5?|@Ao h@     @;^5?|@AzG@     @;^5?|@Aq@     @;^5?|@Ag8}@     @;^5?|@A]ce@     @;^5?|@ASMj@     @;^5?|@AI^5?@     @;^5?|@AC,zx@     @;^5?|@A9XbN@     @;^5?|@A/{J#@     @;^5?|@A%1@     @;^5?|@AQ@     @;^5?|@A@     @;^5?|@A1&y@      @;^5?|@An.@     @;^5?|@A@     @;^5?|@AC]@     @;^5?|@A%2@     @;^5?|@AQ@     @;^5?|@A|@     @;^5?|@A@     @;^5?|@A6@      @;^5?|@AE@$     @;^5?|@Aq@(     @;^5?|@Awk@,     @;^5?|@AA@0     @;^5?|@AMj@4     @;^5?|@AeO@8     @;^5?|@A~$@<     @;^5?|@Atj~@@     @;^5?|@Ajf@D     @;^5?|@Aa@N@H     @;^5?|@AW>6z@L     @;^5?|@AP{@P     @;^5?|@AF]c@T     @;^5?|@A=K^@X     @;^5?|@A33333@\     @;^5?|@A)^	@`     @;^5?|@A	@d     @;^5?|@APH@h     @;^5?|@A'/@l     @;^5?|@AS&@p     @;^5?|@A~@t     @;^5?|@Am@x     @;^5?|@AfB@|     @;^5?|@A ѷ@     @;^5?|@AsP@     @;^5?|@A͞&@     @;^5?|@A@     @;^5?|@AY@     @;W'@A ě@     @;W'@AL/{@     @;W'@Avȴ@     @;W'@Aᰊ@     @;W'@AL_@     @;W'@A@4@     @;W'@Axl"h
@     @;W'@AnO@     @;W'@Ad7@     @;W'@A^5?|@     @;W'@AT`d@     @;W'@AJL@     @;W'@A@4n@     @;W'@A6C@     @;W'@A-V@     @;W'@A&IR@     @;W'@A1'@     @;W'@As@     @;W'@A	 @     @;W'@A.H@     @;W'@AY}@     @;W'@AR@     @;W'@Ae@     @;W'@A"`@     @;W'@AN;6@     @;W'@Ay@     @;W'@A@     @;W'@A|@      @;W'@AB@     @;W'@An.@     @;W'@A@     @;W'@Ao@     @;W'@AoiD@     @;W'@A|Q@     @;W'@ArGE8@     @;W'@Ak~(@      @;W'@Aae@$     @;W'@AXbM@(     @;W'@AN;5@,     @;W'@ADg8~@0     @;W'@A:S@4     @;W'@A4J@8     @;W'@A*0U2a@<     @;W'@A [7@@     @;W'@A+@D     @;W'@A@H     @;W'@A ѷ@L     @;W'@APH@P     @;W'@A{@T     @;W'@A@X     @;W'@A҈p@\     @;W'@AF@`     @;W'@A)^@d     @;W'@ATɅ@h     @;W'@A)@l     @;W'@A{@p     @;W'@A@t     @;W'@AIQ@x     @;W'@Atj@|     @;W'@A'RT@     @;W'@An@     @;W'@Ay=c@     @;W'@AoiDg8@     @;W'@AeO@     @;W'@A[6@     @;W'@AQ@     @;W'@AH@     @;W'@AA7K@     @;Q_@A73@     @;Q_@A-
q@     @;Q_@A$xG@     @;Q_@A6@     @;Q_@AbM@     @;Q_@A	ԕ+@     @;Q_@A     @     @;Q_@A+j@     @;Q_@AVϫ@     @;Q_@A@@     @;Q_@AحV@     @;Q_@A+@     @;Q_@AK]d@     @;Q_@Avȴ9@     @;Q_@A3@     @;Q_@A͞@     @;Q_@A	k@     @;Q_@A$tS@     @;Q_@A@     @;Q_@A&@     @;Q_@A|hs@     @;Q_@AsPH@     @;Q_@AiDg8@     @;Q_@A_o@      @;Q_@AU=@     @;Q_@AO
M@     @;Q_@AE84@     @;Q_@A;dZ@     @;Q_@A1@     @;Q_@A'/W@     @;Q_@A,@     @;Q_@AXe@      @;Q_@A
M;@$     @;Q_@A@(     @;Q_@A"@,     @;Q_@A@0     @;Q_@A1@4     @;Q_@Aߤ?@8     @;Q_@AϪ͟@<     @;Q_@At@@     @;Q_@A&I@D     @;Q_@AQ@H     @;Q_@A}Vl@L     @;Q_@AT@P     @;Q_@A@T     @;Q_@AFs@X     @;Q_@Aqi@\     @;Q_@AIQ@`     @;Q_@Avȴ9X@d     @;Q_@Al!-@h     @;Q_@Afffff@l     @;Q_@A\N<@p     @;Q_@AR<6@t     @;Q_@AH@x     @;Q_@A?@|     @;Q_@A5?|@     @;Q_@A+jg@     @;Q_@A$/@     @;Q_@Au@     @;Q_@A4K@     @;Q_@A_o @     @;Q_@Aڹ@     @;Q_@AE@     @;Q_@A(@     @;Q_@AS@     @;Q_@Ab@     @;Q_@AϪ͞@     @;JL@A8Y@     @;JL@An/@     @;JL@A-V@     @;JL@AU=@     @;JL@A@     @;JL@A+j@     @;JL@A!R@     @;JL@AM:@     @;JL@Azxl"h@     @;JL@Asg@     @;JL@AjOv@     @;JL@A`A7L@     @;JL@AVl!@     @;JL@AL_@     @;JL@AB@     @;JL@A84֡@     @;JL@A2a|@     @;JL@A(@     @;JL@AQ@     @;JL@A[@     @;JL@A'0@      @;JL@A:@     @;JL@A>@     @;JL@AD@     @;JL@A@     @;JL@A/@     @;JL@AZ@     @;JL@AɅoi@     @;JL@A7@      @;JL@A#x@$     @;JL@AO
M@(     @;JL@Azxl"@,     @;JL@AS@0     @;JL@AN;@4     @;JL@A#@8     @;JL@Ao h@<     @;JL@AwkP@@     @;JL@Am8@D     @;JL@AcA \@H     @;JL@AZ1@L     @;JL@APH@P     @;JL@AI^5?@T     @;JL@A?@X     @;JL@A64@\     @;JL@A,<@`     @;JL@A"h	ԕ@d     @;JL@Atj@h     @;JL@Aߤ@@l     @;JL@A1&y@p     @;JL@A\N@t     @;JL@A$@x     @;JL@Ag@|     @;JL@A҈@     @;JL@A
=p@     @;JL@A|@     @;JL@AƧ@     @;JL@AZ@     @;JL@Am]@     @;JL@A*0U2@     @;JL@AU=@     @;JL@A$@     @;JL@AMj@     @;JL@AQ@     @;JL@A{J#9@     @;JL@Aqu!@     @;JL@Ag	l@     @;JL@A]cA@     @;JL@AW>6z@     @;C\@AMjO@     @;C\@AC%@     @;C\@A9@     @;C\@A/V@     @;C\@A&@     @;C\@AC,z@     @;C\@As@     @;C\@A҉@     @;C\@AI^@     @;C\@A74@     @;C\@Ac	@     @;C\@A䎊q@     @;C\@A ѷ@     @;C\@A,<@     @;C\@AW@     @;C\@An@     @;C\@A}Vm@      @;C\@A>B@     @;C\@AL/{@     @;C\@AwkQ@     @;C\@AS&@     @;C\@Ap:@     @;C\@A~"@     @;C\@Au%F
@     @;C\@AkP|@      @;C\@Ad7@$     @;C\@AZc@(     @;C\@AQ_@,     @;C\@AGE85@0     @;C\@A=p
@4     @;C\@A3@8     @;C\@A-V@<     @;C\@A#9@@     @;C\@Ae+@D     @;C\@A@H     @;C\@An@L     @;C\@AlD@P     @;C\@As@T     @;C\@AR@X     @;C\@Aᰉ'@\     @;C\@A@`     @;C\@A_o@d     @;C\@A2W@h     @;C\@A^5?}@l     @;C\@A|@p     @;C\@Al@t     @;C\@A'RTa@x     @;C\@AR<6@|     @;C\@A~($@     @;C\@A@     @;C\@Ax@     @;C\@ArGE8@     @;C\@Ahr @     @;C\@A^@     @;C\@ATɅo@     @;C\@AJE@     @;C\@AA [@     @;C\@A:S@     @;C\@A0
)@     @;C\@A&x@     @;C\@A@     @;C\@A@N@     @;C\@A	k~@     @;C\@A$tT@     @;C\@A	k@     @;C\@A4֡b@     @;C\@A`A7@     @;=p
@Aۋq
@     @;=p
@AѷX@     @;=p
@A@@     @;=p
@ATɅ@     @;=p
@A4m@     @;=p
@AU@     @;=p
@A
=q@     @;=p
@Au%F@     @;=p
@A-
@     @;=p
@A'RT@     @;=p
@A˒:*@     @;=p
@Au!@     @;=p
@Al"h	@     @;=p
@AbM@      @;=p
@AXy=@     @;=p
@ANU@     @;=p
@AH@     @;=p
@A>BZc@     @;=p
@A4m9@     @;=p
@A*0@     @;=p
@A ě@     @;=p
@A@      @;=p
@AbM@$     @;=p
@A@(     @;=p
@A#@,     @;=p
@A䎊r@0     @;=p
@ArG@4     @;=p
@A;dZ@8     @;=p
@AfA@<     @;=p
@A+@@     @;=p
@Ao @D     @;=p
@A/V@H     @;=p
@A[W>@L     @;=p
@A&