CDF   Q   
      pressure          -   Conventions       CF-1.6     featureType       profile    title         FRAN CTD data Ship: HMAS Mermaid Cruise: HI521MER_M ProfileID: 10420063     summary      This file contains a vertical profile of pressure, temperature and salinity measured by a Conductivity, Temperature and Depth (CTD) probe. This CTD is fitted with a 4 electrode platinized conductivity cell, thermistor temperature sensor and a semiconductor strain gauge pressure sensor.

The CTD sensors are calibrated at the manufacturer Applied Microsystems Limited on a 12-18 month schedule. The CTD temperature sensor is calibrated against 'Hart' temperature standards. The pressure sensor is calibrated using 'Budenburg Deadweight' standards. The conductivity sensor is calibrated using 'Hart' temperature standards and seawater samples of known conductivity.

The CTD sensors are mounted to a fish-shape probe. The probe is controlled by an electric winch (MVP200 type). For downcasts the fish is allowed to free-fall (winch is in 'free-wheel' mode) under its own weight at about 2-3 ms-1 and then is winched back. Data is recorded in downcast and usually in upcast direction at a sampling rate of 25 Hz. The downcast data is of higher quality because sensors encounter undisturbed seawater that flows through the nose of the fish. On the upcast the fish is flipped around (tail first) and the sensors in the nose encounter disturbed flow from the fish tail.

This type of CTD is prone to a phenomenon called 'salinity spiking' caused by a mismatch between the response times of the temperature and conductivity sensor. Data undergoes a salinity de-spiking routine to correct for this. See the history metadata for further details on the salinity de-spiking process.

Raw CTD pressure data is not always monotonic due to transient up/down motion of winch/ship. Raw pressure data is subsetted to give a monotonic (increasing) sequence and then linearly interpolated to 1 decibar pressure intervals. Data is then flagged with quality control flags after visual inspection and comparison to average climatology and historical CTD casts.    keywords      SOceans | Ocean Temperature | Water Temperature,Oceans | Salinity/Density | Salinity    id        $420a49a0-e9b3-41e1-add9-8c0ec47c7498   naming_authority      metoc.gov.au   keywords_vocabulary       XNASA/Global Change Master Directory (GCMD) Earth Science Keywords. Version  5.3.8 (2006)   
cdm_data_type         Profile    history      ;Initial Processing

Incoming data undergoes gross range checks and removal of any corrupted or unrealistic data. Some CTD data is subject to a pressure offset error generally less than 1 decibar. A pressure offset error occurs when the pressure sensor does not read 0 dbar in air. In cases where the pressure offset error was observed before the CTD cast the pressure readings have been corrected for the offset which is stored in the global netCDF attribute named 'CTD_pressure_offset'.

Salinity on the PSS-78 scale is computed from conductivity, temperature and pressure using the UNESCO (1983) algorithm with temperature corrected from the ITS-90 scale to the ITS-68 scale used by the algorithm.

For this CTD model the response time (time constant) of the temperature sensor (100 ms) is slower than the conductivity cell (25ms). This leads to a phenomenon called 'salinity spiking' in the salinity data. Spiking is caused by the fact that calculated salinity is a function of conductivity, temperature and pressure [S=f(C,T,z)]. The temperature response lags the conductivity response resulting an error in the calculation of salinity. This is evident as noticeable spikes in the salinity profiles especially at depths where temperature is rapidly changing e.g in the ocean thermocline. The spiking was reduced reduced by applying a 2.5 sample time shift (0.1 s) to the temperature values and using the shifted temperature value in the re-computation of the salinity. An array of raw pressure, temperature and de-spiked salinity is then passed to the next processing stage.

The raw CTD data contains a non-monotonic sequence of pressures due to up/down motion of ship/winch. A sequence of unique monotonic pressures up to the maximum value is extracted and then linearly interpolated to 1 decibar pressure levels with the corresponding interpolated temperature and salinity. Finally the interpolated files are converted to a set of netCDF files ready for QC.

Quality Control

Quality control (QC) involves viewing location of the data on a map, visual inspection of each profile of temperature and salinity and comparison with nearest neighbours and climatology. CTD profiles are checked for any density inversions i.e. density decreasing with depth by computing 'sigma-t' density. A density inversion may indicate unrealistic salinity and/or temperature values. QC flags are applied to indicate whether data is good, suspect, bad or not tested. QC flags may apply at the 'whole profile' level or individual pressure levels.
 
CTD cast positions and times undergo a land and ship speed check. Casts with position on land or unrealistic speed between casts are flagged as failed position or time. Temperature and salinity profiles are then visually compared against a 3 standard deviation envelope from the CSIRO-CARS (2009) atlas. Profiles or segments of profiles with data outside the envelope are flagged as doubtful or failed. Profiles are also checked for consistency or doubtful features by comparing with previous/next casts (buddies) and also by comparison with historical CTD casts taken in the same area and season.    date_created      2013-01-30T08:46:49    
date_modified         2013-02-01T11:36:14    	qc_status         2      creator_name      Data Management Officer    creator_url       http://www.metoc.gov.au/   
creator_email         dm@metoc.gov.au    institution       2Royal Australian Navy Hydrography and Metoc Branch     acknowledgement       XRoyal Australian Navy Hydrography and Metoc Branch,CSIRO Marine and Atmospheric Research   geospatial_lat_min        	-11.73831      geospatial_lat_max        	-11.73831      geospatial_lon_min        	129.88441      geospatial_lon_max        	129.88441      geospatial_vertical_min       01.00      geospatial_vertical_max       81.00      geospatial_vertical_units         decibars   time_coverage_start       2012-08-02T06:29:09Z   time_coverage_end         2012-08-02T06:29:09Z   standard_name_vocabulary      OCF standard names list at http://cf-pcmdi.llnl.gov/documents/cf-standard-names/    license       XCreative Commons - Attribution (CC-BY) at http://creativecommons.org/licenses/by/3.0/au/   coordinateReferenceSystem         	EPSG:4326      	cruise_id         
HI521MER_M     water_depth       91.9   
ship_speed        1.2    source_filename       svp_0271.raw   data_parameters       (sea_water_temperature,sea_water_salinity   CTD_instrument_manufacturer       Applied Microsystems Limited   CTD_instrument_model      	Micro CTD      
CTD_serial_no         7642   CTD_pressure_offset       0.0    CTD_MinRawPressure        0.35   CTD_MaxRawPressure        81.41      CTD_MinPressureforInterp      0.83   CTD_MaxPressureforInterp      81.41      CTD_cast_direction        Down   
CTD_scan_rate         25 Hz            time             
standard_name         time   units         days since 1950-01-01 00:00:00Z    axis      T      	valid_min                	valid_max          B?        0   time_qc_flag             	long_name         4quality control flag for time (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           0   latitude             
standard_name         latitude   units         
degrees_north      axis      Y      	valid_min            	valid_max            Z        0   	longitude                
standard_name         	longitude      units         degrees_east   axis      X      	valid_min         L   	valid_max                    1    position_qc_flag             	long_name         8quality control flag for position (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   pressure                
standard_name         sea_water_pressure     units         decibars   axis      Z      	valid_min                	valid_max           .   positive      down        1   temperature                 
_FillValue        X\(   
standard_name         sea_water_temperature      units         	degrees_C      	valid_min            	valid_max            (   ancillary_variables       Ftemperature_whole_profile_flag temperature_qc_flag temperature_sd_test     coordinates        time latitude longitude pressure        1    temperature_whole_profile_flag               	long_name         <qc flag for whole temperature profile (primary Level 1 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   temperature_qc_flag                 	long_name         ;quality control flag for temperature (primary Level 1 flag)    
standard_name         !sea_water_temperature status_flag      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        1(   temperature_sd_test                 	long_name         Pqc flag for monthly temperature standard deviation test (secondary Level 2 flag)   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1,   salinity                
_FillValue        X\(   
standard_name         sea_water_practical_salinity   units         psu    	valid_min                	valid_max            -   ancillary_variables       =salinity_whole_profile_flag salinity_qc_flag salinity_sd_test      coordinates        time latitude longitude pressure        10   salinity_whole_profile_flag              	long_name         9qc flag for whole salinity profile (primary Level 1 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing           1   salinity_qc_flag                	long_name         8quality control flag for salinity (primary Level 1 flag)   
standard_name         (sea_water_practical_salinity status_flag   quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min               	valid_max            	   flag_values       	      
flag_meanings         1good not_evaluated_or_unknown suspect bad missing      coordinates        time latitude longitude pressure        18   salinity_sd_test                	long_name         Mqc flag for monthly salinity standard deviation test (secondary Level 2 flag)      quality_control_convention        "Proposed IODE qc scheme March 2012     	valid_min                	valid_max               flag_values            
flag_meanings         passed failed unknown      coordinates        time latitude longitude pressure        1<   profile              	long_name         profile identifier     cf_role       
profile_id     comment       o8 digit profile identifier in format nnnncccc where nnnn=numerical cruise id, cccc=consecutive number in cruise         1@RK'zİ@`<M3H, _?      @91'@@vȴ9X@       @933333@@\N<@      @9-V@@\(@      @9\(@@84֡@      @96C@@/@      @9n@@܁o h@      @9+@@9XbN@       @9-@@ܯO
M@"      @9}Vl@@ܬ1&@$      @9$/@@u@&      @9=K@@>B[@(      @9`A7L@@V@*      @9TɆ@@/w@,      @9'0@@*0@.      @9Q@@\@0      @9?@@S&@1      @9S@@݇ݗ@2      @9xF@@b@3      @9S@@%F
L@4      @9o i@@?|h@5      @92W@@p
=@6      @9tj~@@ݔO
@7      @9
=p@@w1@8      @9@N@@ݵsh@9      @9M@@8Y@:      @9<64@@!R<@;      @9	k@@?@<      @9[6@@@=      @9oiDg8@@Ov_خ@>      @9rGE9@@ޞ@?      @9;dZ@@\N<@@      @9vȴ9@@ߤ?@@     @9}E@@s@A      @9}qu"@@Xe@A     @9|j~#@@҈p;@B      @9|j~#@@C-@B     @9|@@޵'@C      @9|j~#@@"@C     @9{dZ@@Mj@D      @9zL_@@Xe,@D     @9z1'@@As@E      @9yXbM@@>6z@E     @9yXbM@@_o@F      @9y+@@)^@F     @9xF@@U=@G      @9x˒:*@@ߍO;d@G     @9vFs@@rG@H      @9t9XbN@@bM@H     @9vx@@@I      @9uS&@@@I     @9un/@@䎊r@J      @9u?|h@@@J     @9swk@@[6@K      @9qGz@@e+@K     @9nVu@@{@L      @9mp
=@@JE@L     @9nzG@@ [7@M      @9nVu@@#w@M     @9nzG@@4֡b@N      @9nzG@@{@N     @9n($x@@_p@O      @9nVu@@4֡b@O     @9nzG@@	k@P      @9oFt@@	k~@P@     @9nO;@@e+@P     @9o\(@@҈p@P     @9mO;dZ@@[W>6@Q      @9mV@@k~(@Q@     @9m5Xy>@@rGE8@Q     @9mV@@rGE8@Q     @9l@@TɅo@R      @9lcA \@@R<6@R@     @9m/w@@n.@R     @9mO;dZ@@Gz@R     @9lVϪ@@~($@S      @9lj~#@@oiD@S@     @9kƧ@@X@S     @9kƧ@@^5?}@S     @9kC%@@R@T      @9kƧ@@@T@     @9kQ@@s                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                