CDF       
      RAW_DATA_CHAR_LENGTH 8   TIME    TIME_FOR_PRES_DETRENDED   
   LATITUDE      	LONGITUDE         DEPTH            "   Conventions        CF-1.6, OceanSITES-1.3, ACDD-1.2   format_version        1.3    
cdm_data_type         Station    featureType       
timeSeries     	data_type         OceanSITES time-series data    	site_code         MOVE1      
platform_code         MOVE1P     naming_authority      
OceanSITES     id        )OS_MOVE1P_200704_D_PIES-SEAFLOOR-PRESSURE      	data_mode         D      update_interval       void   title         2Seafloor Pressure Measurements by the MOVE Project     summary      NSeafloor pressure measured by PIES instruments in the tropical Atlantic Ocean by the MOVE project (Meridional Overturning Variability Experiment). The instrument sits on a tripod on the seafloor. The data are meant to be useful for determining the strength of the overturning circulation by providing a reference level for geostrophy.     date_created      2015-12-10T21:17:20Z   data_assembly_center      NDBC   institution       #Scripps Institution of Oceanography    publisher_name        Matthias Lankhorst     
publisher_url         $http://orcid.org/0000-0002-4166-4044   principal_investigator        Uwe Send   processing_level      Data manually reviewed     acknowledgement      /MOVE was initially funded by the Bundesministerium fuer Bildung und Forschung (BMBF) of Germany, then by the National Oceanic and Atmospheric Administration (NOAA), USA. MOVE data were produced as part of the international CLIVAR program, and made available through the international OceanSITES project.    license      Data freely available without restrictions. User assumes all risk for use of data. User is kindly asked to acknowledge the data source, project, and funding agency in publications or products using these data, e.g. as shown in the 'acknowledgement' attribute here.   project       4MOVE (Meridional Overturning Variability Experiment)   area      Tropical Atlantic Ocean    geospatial_lat_min        15.4507    geospatial_lat_max        15.4507    geospatial_lon_min        -51.527    geospatial_lon_max        -51.527    geospatial_vertical_min       4982.146   geospatial_vertical_max       4982.146   geospatial_vertical_positive      down   geospatial_vertical_units         meter      time_coverage_start       2007-04-23T18:00:00Z   time_coverage_end         2011-11-29T10:50:00Z      
   RAW_DATA                comment       }This is a verbatim copy of the P file obtained from the instrument memory card. See instrument manual for format description.       8     TIME               	long_name         Time   
standard_name         time   units         days since 1950-01-01T00:00:00Z    	valid_min         @p       	valid_max         @8   uncertainty       ?|1&y   comment       CUncertainty attribute reflects typical clock drifts in instruments.    axis      T        8x   TIME_FOR_PRES_DETRENDED                	long_name         Time   units         days since 1950-01-01T00:00:00Z    	valid_min         @qʪ   	valid_max         @J   comment       2Sub-sampled from TIME for variable PRES_DETRENDED.     axis      T      ancillary_variables       TIME     h VAH   LATITUDE            
   	long_name         Latitude   
standard_name         latitude   units         
degrees_north      	valid_min         @.v   	valid_max         @.v   uncertainty       ?n6G   comment       vUnderstood as ship position at instrument deployment. Expect some lateral uncertainty as instrument sinks to seafloor.     axis      Y      	reference         WGS84      coordinate_reference_frame        urn:ogc:def:crs:EPSG::4326         V   	LONGITUDE               
   	long_name         	Longitude      
standard_name         	longitude      units         degrees_east   	valid_min         Itj~   	valid_max         Itj~   uncertainty       ?E   comment       vUnderstood as ship position at instrument deployment. Expect some lateral uncertainty as instrument sinks to seafloor.     axis      X      	reference         WGS84      coordinate_reference_frame        urn:ogc:def:crs:EPSG::4326         V   DEPTH                  	long_name         Depth      
standard_name         depth      units         meters     positive      down   	valid_min         @v%b&   	valid_max         @v%b&   uncertainty       @$         comment       5Nominal depth derived from raw pressure measurements.      axis      Z      	reference         mean_sea_level     coordinate_reference_frame        urn:ogc:def:crs:EPSG::5715         V    PRES                        
_FillValue        X   units         dbar   
standard_name         sea_water_pressure_at_sea_floor    	long_name         Sea Water Pressure at Seafloor     	valid_min                    	valid_max         @p        accuracy      ?333333   
resolution        ?PbM   processing_level       Ranges applied, bad data flagged   ancillary_variables       PRES_QC PRES_DETRENDED     comment      LThe instrument is a PIES (pressure-sensing inverted echo sounder). The actual pressure sensor is a Paroscientific Digiquartz. Data in this variable only have factory calibrations applied; no trend or tide removal has been done. A separate variable linked under 'ancillary_variables' contains processed data without trends and tides.   sensor_manufacturer       1University of Rhode Island, Narragansett, RI, USA      sensor_model      PIES   sensor_serial_number      @f        sensor_mount      mounted_on_bottom_lander   sensor_reference      whttp://dx.doi.org/10.1175/1520-0426(1990)007%3C0296:DOBPMD%3E2.0.CO;2 http://www.po.gso.uri.edu/dynamics/IES/index.html      V   PRES_DETRENDED                          
_FillValue        X   units         dbar   	long_name         LAnomaly of Sea Water Pressure at Seafloor, After Removal of Tides and Trends   	valid_min         $         	valid_max         @$         ancillary_variables       PRES   QC_indicator      unknown    comment      Derived from PRES variable, see attributes there. Processing steps: (1) Raw data, parsed. (2) Outliers removed. (3) Removed linear trend and tidal fit based on latter 67% of data, additional outlier removal. (4) Band-pass filter  2.2 to 50.0 days, sub-sampled.     h t1   PRES_QC                         
standard_name         +sea_water_pressure_at_sea_floor status_flag    	long_name         7Quality Control Flag for Sea Water Pressure at Seafloor    flag_values       	 	      
flag_meanings         no_qc_performed good_data probably_good_data bad_data_that_are_potentially_correctable bad_data value_changed nominal_value interpolated_value missing_value     t   TEMP                        
_FillValue        X   units         degree_Celsius     
standard_name         sea_water_temperature      	long_name         Sea Water Temperature      	valid_min                   	valid_max         @D         
resolution        ?PbM   reference_scale       ITS-90     comment      )The instrument is a PIES (pressure-sensing inverted echo sounder). The actual temperature sensor is part of the Paroscientific Digiquartz pressure sensor. Data in this variable only have factory calibrations applied. No quality control was done, and the absolute accuracy of the data is not known.      sensor_manufacturer       1University of Rhode Island, Narragansett, RI, USA      sensor_model      PIES   sensor_serial_number      @f        sensor_mount      mounted_on_bottom_lander   sensor_reference      1http://www.po.gso.uri.edu/dynamics/IES/index.html      QC_indicator      unknown    processing_level      =Instrument data that has been converted to geophysical values        xK|
P 2007/04/23 17:52:38 180 97079 10 5.757508 -3942.349 -10945.40 0.00 -42985.19 -23.539 152953.30 0.036671 0.00 30.33221 1.454028 65.08241 135.8002 0.00 -0.61 1.54
327042 11920 23860  11917 23893  11920 23931  11913 23975  11913 24020  11914 24060  
327043 11905 24096  11906 24133  11901 24169  11911 24205  11905 24239  11901 24277  
327044 11899 24311  11899 24347  11895 24377  11908 24406  11905 24433  11907 24453  
327045 11906 24474  11909 24489  11905 24498  11912 24504  11912 24508  11910 24512  
327046 11911 24512  11910 24518  11914 24523  11917 24533  10617 24540  10796 24551  
327047 11342 24560  11344 24575  11343 24589  11346 24604  11352 24609  11355 24618  
327048 11354 24621  11354 24623  11363 24622  11363 24620  11367 24613  11360 24609  
327049 11362 24604  10847 24593  10836 24574  10872 24576  457261 24512  990790 21424  
327050 1518068 16372  2050302 12243  2584440 9204  3122066 7029  3656545 5511  4193553 4442  
327051 4728679 3659  4993234 3061  4993199 2638  5071285 2345  5071261 2141  5071235 1997  
327052 5071215 1895  5071203 1816  5071185 1756  5071170 1709  5071153 1677  5071146 1645  
327053 5071124 1625  5071115 1606  5071098 1590  5071086 1575  5071072 1562  5071058 1550  
327054 5071057 1539  5071043 1531  5071038 1520  5071028 1514  5071024 1506  5071017 1502  
327055 5071013 1495  5071012 1489  5071006 1485  5071011 1477  5071009 1474  5071010 1472  
327056 5071016 1464  5071019 1460  5071021 1458  5071023 1454  5071033 1448  5071035 1445  
327057 5071048 1441  5071054 1439  5071068 1433  5071079 1431  5071088 1431  5071096 1427  
327058 5071116 1425  5071124 1421  5071144 1419  5071152 1416  5071169 1412  5071176 1410  
327059 5071198 1406  5071204 1404  5071225 1402  5071234 1402  5071249 1400  5071261 1398  
327060 5071270 1398  5071280 1398  5071286 1396  5071295 1396  5071306 1395  5071311 1395  
327061 5071312 1393  5071322 1393  5071322 1393  5071324 1391  5071324 1391  5071324 1391  
327062 5071325 1389  5071325 1389  5071314 1391  5071315 1389  5071310 1389  5071301 1389  
327063 5071288 1387  5071278 1387  5071269 1387  5071250 1387  5071245 1387  5071216 1387  
327064 5071204 1385  5071188 1387  5071169 1387  5071151 1385  5071127 1385  5071113 1385  
327065 5071094 1385  5071073 1387  5071051 1385  5071035 1387  5071012 1385  5070993 1385  
327066 5070980 1383  5070960 1385  5070945 1385  5070923 1383  5070904 1383  5070890 1383  
327067 5070877 1381  5070861 1383  5070846 1383  5070837 1383  5070828 1383  5070823 1383  
327068 5070815 1381  5070805 1381  5070799 1383  5070799 1383  5070800 1381  5070801 1381  
327069 5070800 1381  5070804 1383  5070804 1383  5070813 1383  5070813 1383  5070828 1383  
327070 5070837 1383  5070846 1383  5070850 1385  5070870 1383  5070884 1385  5070898 1385  
327071 5070913 1383  5070926 1385  5070947 1383  5070969 1385  5070979 1385  5071003 1385  
327072 5071022 1385  5071035 1387  5071059 1387  5071074 1385  5071092 1387  5071113 1385  
327073 5071126 1387  5071144 1387  5071159 1387  5071173 1387  5071188 1387  5071193 1387  
327074 5071211 1387  5071215 1389  5071226 1387  5071235 1387  5071243 1389  5071248 1389  
327075 5071250 1387  5071248 1389  5071248 1389  5071248 1389  5071248 1389  5071248 1389  
327076 5071243 1388  5071232 1390  5071234 1388  5071215 1389  5071210 1389  5071200 1389  
327077 5071191 1389  5071176 1389  5071170 1390  5071157 1389  5071148 1388  5071134 1389  
327078 5071124 1389  5071110 1389  5071098 1390  5071086 1389  5071076 1389  5071067 1389  
327079 5071056 1390  5071047 1389  5071041 1390  5071033 1389  5071022 1390  5071019 1389  
327080 5071009 1389  5071000 1389  5070989 1390  5070990 1389  5070986 1389  5070987 1387  
327081 5070987 1387  5070987 1387  5070989 1385  5070987 1387  5070992 1387  5071003 1385  
327082 5071003 1385  5071012 1385  5071022 1385  5071025 1387  5071036 1385  5071046 1385  
327083 5071050 1385  5071070 1385  5071074 1385  5071090 1383  5071094 1385  5071113 1385  
327084 5071124 1383  5071137 1385  5071147 1383  5071162 1383  5071172 1383  5071181 1383  
327085 5071191 1383  5071206 1381  5071216 1381  5071221 1381  5071238 1383  5071249 1381  
327086 5071254 1381  5071264 1381  5071264 1381  5071273 1381  5071278 1381  5071278 1381  
327087 5071278 1381  5071283 1381  5071278 1381  5071278 1381  5071278 1381  5071273 1381  
327088 5071264 1381  5071254 1381  5071248 1383  5071238 1383  5071230 1381  5071214 1383  
327089 5071205 1383  5071181 1383  5071175 1385  5071161 1385  5071146 1385  5071127 1385  
327090 5071113 1385  5071089 1385  5071074 1385  5071049 1387  5071027 1385  5071011 1387  
327091 5070989 1385  5070973 1387  5070958 1387  5070934 1387  5070920 1387  5070899 1389  
327092 5070885 1389  5070871 1389  5070868 1387  5070858 1387  5070844 1387  5070834 1387  
327093 5070825 1387  5070821 1385  5070818 1389  5070810 1387  5070810 1387  5070799 1389  
327094 5070802 1385  5070802 1385  5070810 1387  5070812 1385  5070820 1387  5070821 1385  
327095 5070836 1385  5070845 1385  5070849 1387  5070868 1387  5070884 1385  5070896 1387  
327096 5070912 1385  5070925 1387  5070944 1387  5070968 1387  5070976 1388  5071000 1389  
327097 5071024 1389  5071044 1387  5071057 1388  5071078 1387  5071092 1387  5071113 1385  
327098 5071127 1385  5071147 1383  5071160 1385  5071176 1383  5071181 1383  5071197 1381  
327099 5071205 1383  5071221 1381  5071229 1383  5071240 1381  5071240 1381  5071249 1381  
327100 5071249 1381  5071249 1381  5071254 1381  5071249 1381  5071249 1381  5071240 1381  
327101 5071240 1381  5071230 1381  5071221 1381  5071216 1381  5071206 1381  5071192 1381  
327102 5071182 1381  5071173 1381  5071154 1381  5071139 1381  5071130 1381  5071116 1381  
327103 5071097 1381  5071090 1383  5071076 1383  5071062 1383  5071048 1381  5071038 1383  
327104 5071023 1383  5071012 1385  5070995 1383  5070980 1383  5070976 1383  5070971 1383  
327105 5070952 1383  5070947 1383  5070937 1383  5070928 1383  5070928 1383  5070923 1383  
327106 5070923 1383  5070923 1383  5070923 1383  5070923 1383  5070929 1381  5070929 1381  
327107 5070928 1383  5070939 1381  5070947 1383  5070953 1381  5070961 1383  5070972 1381  
327108 5070977 1381  5070991 1381  5070996 1381  5071015 1381  5071025 1381  5071039 1381  
327109 5071054 1381  5071073 1381  5071082 1381  5071097 1381  5071116 1381  5071130 1381  
327110 5071149 1381  5071154 1381  5071173 1381  5071182 1381  5071192 1381  5071206 1381  
327111 5071216 1381  5071230 1381  5071240 1381  5071249 1381  5071254 1381  5071254 1381  
327112 5071264 1381  5071264 1381  5071264 1381  5071264 1381  5071264 1381  5071254 1381  
327113 5071254 1381  5071249 1381  5071240 1381  5071230 1381  5071221 1381  5071206 1381  
327114 5071192 1381  5071182 1381  5071173 1381  5071154 1381  5071130 1381  5071116 1381  
327115 5071097 1381  5071082 1381  5071063 1381  5071049 1381  5071030 1381  5071004 1383  
327116 5070992 1381  5070976 1383  5070963 1381  5070937 1383  5070925 1381  5070906 1381  
327117 5070890 1383  5070887 1381  5070870 1383  5070852 1383  5070847 1383  5070837 1383  
327118 5070828 1383  5070812 1385  5070804 1383  5070804 1383  5070804 1383  5070804 1383  
327119 5070802 1385  5070805 1381  5070804 1383  5070813 1383  5070824 1381  5070837 1383  
327120 5070848 1381  5070853 1381  5070872 1381  5070887 1381  5070901 1381  5070915 1381  
327121 5070929 1381  5070953 1381  5070972 1381  5070992 1381  5071015 1381  5071030 1381  
327122 5071049 1381  5071073 1381  5071082 1381  5071106 1381  5071125 1381  5071149 1381  
327123 5071163 1381  5071178 1381  5071192 1381  5071206 1381  5071216 1381  5071230 1381  
327124 5071240 1381  5071254 1381  5071254 1381  5071264 1381  5071272 1383  5071273 1381  
327125 5071272 1383  5071273 1381  5071273 1381  5071264 1381  5071252 1383  5071249 1381  
327126 5071249 1381  5071240 1381  5071219 1383  5071216 1381  5071206 1381  5071192 1381  
327127 5071178 1381  5071163 1381  5071149 1381  5071128 1383  5071116 1381  5071095 1383  
327128 5071082 1381  5071063 1381  5071049 1381  5071028 1383  5071014 1383  5070995 1383  
327129 5070980 1383  5070971 1383  5070961 1383  5070947 1383  5070929 1381  5070923 1383  
327130 5070904 1383  5070899 1383  5070890 1383  5070890 1383  5070885 1383  5070885 1383  
327131 5070875 1383  5070875 1383  5070870 1383  5070877 1381  5070877 1381  5070887 1381  
327132 5070890 1383  5070891 1381  5070904 1383  5070915 1381  5070923 1383  5070928 1383  
327133 5070948 1381  5070963 1381  5070977 1381  5070992 1381  5071006 1381  5071025 1381  
327134 5071039 1381  5071054 1381  5071073 1381  5071092 1381  5071106 1381  5071125 1381  
327135 5071149 1381  5071163 1381  5071178 1381  5071192 1381  5071206 1381  5071221 1381  
327136 5071241 1379  5071251 1379  5071264 1381  5071275 1379  5071278 1381  5071284 1379  
327137 5071283 1381  5071292 1381  5071294 1379  5071293 1381  5071292 1381  5071283 1381  
327138 5071278 1381  5071273 1381  5071264 1381  5071256 1379  5071241 1379  5071221 1381  
327139 5071208 1379  5071194 1379  5071179 1379  5071163 1381  5071141 1379  5071125 1381  
327140 5071108 1379  5071082 1381  5071074 1379  5071049 1381  5071030 1381  5071006 1381  
327141 5070992 1381  5070972 1381  5070953 1381  5070939 1381  5070926 1379  5070905 1381  
327142 5070888 1379  5070878 1379  5070864 1379  5070853 1381  5070850 1379  5070840 1379  
327143 5070826 1379  5070826 1379  5070817 1379  5070817 1379  5070826 1379  5070826 1379  
327144 5070826 1379  5070834 1375  5070840 1379  5070850 1379  5070858 1375  5070874 1379  
327145 5070878 1379  5070893 1379  5070907 1379  5070929 1375  5070950 1379  5070967 1375  
327146 5070987 1375  5070998 1379  5071030 1375  5071044 1375  5071068 1375  5071087 1375  
327147 5071101 1375  5071130 1375  5071154 1375  5071165 1379  5071187 1375  5071202 1375  
327148 5071221 1375  5071235 1375  5071254 1375  5071268 1375  5071283 1375  5071284 1379  
327149 5071294 1379  5071299 1379  5071308 1379  5071308 1379  5071307 1381  5071308 1379  
327150 5071307 1381  5071308 1379  5071297 1381  5071294 1379  5071284 1379  5071279 1379  
327151 5071265 1379  5071249 1381  5071241 1379  5071221 1381  5071206 1381  5071184 1379  
327152 5071173 1381  5071156 1379  5071130 1381  5071115 1381  5071092 1381  5071074 1379  
327153 5071049 1381  5071030 1381  5071015 1381  5070992 1381  5070977 1381  5070953 1381  
327154 5070939 1381  5070926 1379  5070905 1381  5070891 1381  5070877 1381  5070872 1381  
327155 5070853 1381  5070848 1381  5070839 1381  5070839 1381  5070829 1381  5070829 1381  
327156 5070829 1381  5070829 1381  5070829 1381  5070839 1381  5070839 1381  5070848 1381  
327157 5070853 1381  5070872 1381  5070878 1379  5070891 1381  5070906 1381  5070915 1381  
327158 5070939 1381  5070953 1381  5070972 1381  5070982 1381  5071006 1381  5071030 1381  
327159 5071054 1381  5071072 1381  5071092 1381  5071106 1381  5071130 1381  5071154 1381  
327160 5071171 1383  5071192 1381  5071206 1381  5071221 1381  5071240 1381  5071253 1383  
327161 5071272 1383  5071278 1381  5071293 1381  5071297 1381  5071307 1381  5071315 1383  
327162 5071316 1381  5071316 1381  5071316 1381  5071307 1381  5071307 1381  5071297 1381  
327163 5071293 1381  5071283 1381  5071273 1381  5071254 1381  5071240 1381  5071221 1381  
327164 5071206 1381  5071183 1381  5071173 1381  5071154 1381  5071128 1383  5071105 1383  
327165 5071092 1381  5071071 1383  5071049 1381  5071027 1385  5071004 1383  5070980 1383  
327166 5070961 1383  5070947 1383  5070926 1385  5070902 1385  5070888 1385  5070874 1385  
327167 5070869 1385  5070852 1383  5070847 1383  5070836 1385  5070837 1383  5070828 1383  
327168 5070823 1383  5070823 1383  5070828 1383  5070828 1383  5070828 1383  5070837 1383  
327169 5070852 1383  5070863 1381  5070875 1383  5070885 1383  5070901 1381  5070913 1383  
327170 5070928 1383  5070947 1383  5070961 1383  5070977 1381  5070996 1381  5071025 1381  
327171 5071049 1381  5071063 1381  5071082 1381  5071106 1381  5071130 1381  5071154 1381  
327172 5071173 1381  5071192 1381  5071206 1381  5071230 1381  5071249 1381  5071264 1381  
327173 5071278 1381  5071293 1381  5071307 1381  5071316 1381  5071321 1381  5071321 1381  
327174 5071331 1381  5071329 1383  5071340 1381  5071340 1381  5071329 1383  5071329 1383  
327175 5071319 1383  5071316 1381  5071297 1381  5071293 1381  5071278 1381  5071264 1381  
327176 5071238 1383  5071219 1383  5071205 1383  5071181 1383  5071162 1383  5071139 1381  
327177 5071114 1383  5071092 1381  5071073 1381  5071047 1383  5071025 1381  5070996 1381  
327178 5070976 1383  5070953 1381  5070928 1383  5070906 1381  5070891 1381  5070877 1381  
327179 5070853 1381  5070839 1381  5070823 1383  5070805 1381  5070799 1383  5070786 1381  
327180 5070780 1383  5070770 1383  5070770 1383  5070770 1383  5070762 1381  5070772 1381  
327181 5070772 1381  5070772 1381  5070781 1381  5070786 1381  5070801 1381  5070805 1381  
327182 5070825 1381  5070839 1381  5070853 1381  5070872 1381  5070885 1383  5070905 1381  
327183 5070923 1383  5070948 1381  5070971 1383  5070992 1381  5071014 1383  5071038 1383  
327184 5071063 1381  5071081 1383  5071105 1383  5071130 1381  5071149 1381  5071171 1383  
327185 5071192 1381  5071205 1383  5071221 1381  5071249 1381  5071253 1383  5071273 1381  
327186 5071278 1381  5071293 1381  5071291 1383  5071296 1383  5071297 1381  5071297 1381  
327187 5071297 1381  5071291 1383  5071293 1381  5071281 1383  5071273 1381  5071262 1383  
327188 5071249 1381  5071229 1383  5071216 1381  5071197 1381  5071183 1381  5071164 1381  
327189 5071138 1383  5071124 1383  5071097 1381  5071077 1381  5071054 1381  5071028 1383  
327190 5071004 1383  5070982 1381  5070963 1381  5070937 1383  5070923 1383  5070904 1383  
327191 5070885 1383  5070872 1381  5070853 1381  5070837 1383  5070823 1383  5070813 1383  
327192 5070802 1385  5070799 1383  5070790 1383  5070783 1385  5070785 1383  5070785 1383  
327193 5070783 1385  5070790 1383  5070797 1385  5070804 1383  5070813 1383  5070828 1383  
327194 5070837 1383  5070852 1383  5070871 1383  5070885 1383  5070905 1381  5070925 1381  
327195 5070949 1381  5070963 1381  5070980 1383  5071004 1383  5071028 1383  5071052 1383  
327196 5071076 1383  5071095 1383  5071124 1383  5071146 1385  5071161 1385  5071179 1385  
327197 5071203 1385  5071220 1383  5071246 1385  5071261 1385  5071275 1385  5071288 1387  
327198 5071294 1385  5071302 1387  5071312 1387  5071315 1389  5071325 1389  5071325 1389  
327199 5071326 1387  5071316 1387  5071316 1387  5071310 1389  5071291 1389  5071288 1387  
327200 5071277 1389  5071269 1387  5071250 1387  5071226 1387  5071211 1387  5071188 1387  
327201 5071169 1387  5071144 1387  5071111 1387  5071087 1387  5071057 1389  5071035 1387  
327202 5071011 1387  5070977 1387  5070958 1387  5070923 1389  5070901 1387  5070871 1389  
327203 5070849 1387  5070825 1387  5070810 1387  5070782 1387  5070769 1385  5070745 1385  
327204 5070726 1385  5070711 1385  5070702 1385  5070697 1385  5070689 1383  5070685 1383  
327205 5070678 1385  5070678 1385  5070679 1383  5070680 1383  5070685 1383  5070689 1383  
327206 5070699 1383  5070702 1385  5070723 1383  5070737 1383  5070751 1383  5070770 1383  
327207 5070790 1383  5070804 1383  5070828 1383  5070852 1383  5070875 1383  5070899 1383  
327208 5070923 1383  5070947 1383  5070976 1383  5070995 1383  5071028 1383  5071052 1383  
327209 5071074 1385  5071095 1383  5071122 1385  5071147 1383  5071172 1383  5071191 1383  
327210 5071206 1381  5071219 1383  5071238 1383  5071253 1383  5071262 1383  5071272 1383  
327211 5071277 1383  5071277 1383  5071283 1381  5071278 1381  5071278 1381  5071278 1381  
327212 5071273 1381  5071264 1381  5071254 1381  5071240 1381  5071221 1381  5071206 1381  
327213 5071194 1379  5071178 1375  5071156 1374  5071139 1370  5071115 1370  5071093 1368  
327214 5071074 1368  5071050 1368  5071028 1366  5071004 1366  5070985 1366  5070966 1366  
327215 5070937 1366  5070918 1366  5070899 1366  5070885 1366  5070865 1366  5070841 1366  
327216 5070837 1366  5070816 1368  5070802 1368  5070797 1368  5070792 1368  5070792 1368  
327217 5070783 1368  5070783 1368  5070783 1368  5070783 1368  5070791 1370  5070797 1368  
327218 5070800 1370  5070811 1368  5070824 1370  5070834 1370  5070848 1370  5070861 1372  
327219 5070886 1370  5070899 1372  5070923 1372  5070947 1372  5070970 1372  5070982 1375  
327220 5071010 1375  5071036 1373  5071058 1375  5071079 1379  5071098 1379  5071132 1379  
327221 5071154 1381  5071178 1381  5071197 1381  5071221 1381  5071240 1381  5071264 1381  
327222 5071277 1383  5071291 1383  5071305 1383  5071316 1381  5071329 1383  5071339 1383  
327223 5071343 1383  5071343 1383  5071353 1383  5071343 1383  5071343 1383  5071339 1383  
327224 5071331 1381  5071321 1381  5071307 1381  5071293 1381  5071278 1381  5071256 1379  
327225 5071240 1381  5071217 1379  5071194 1379  5071175 1379  5071144 1375  5071120 1375  
327226 5071087 1375  5071065 1379  5071034 1375  5071002 1374  5070978 1373  5070945 1373  
327227 5070912 1374  5070883 1373  5070861 1372  5070832 1372  5070797 1374  5070779 1372  
327228 5070756 1372  5070738 1370  5070714 1370  5070695 1370  5070690 1370  5070670 1372  
327229 5070655 1372  5070648 1370  5070636 1372  5070631 1372  5070631 1372  5070631 1372  
327230 5070632 1372  5070636 1372  5070648 1370  5070657 1370  5070670 1372  5070689 1372  
327231 5070698 1372  5070713 1372  5070730 1374  5070756 1372  5070770 1372  5070792 1374  
327232 5070813 1372  5070846 1372  5070870 1372  5070893 1374  5070923 1372  5070947 1372  
327233 5070979 1374  5070998 1374  5071033 1372  5071055 1373  5071085 1372  5071103 1374  
327234 5071131 1373  5071155 1373  5071181 1372  5071189 1374  5071214 1372  5071229 1372  
327235 5071247 1372  5071256 1374  5071271 1372  5071279 1374  5071286 1372  5071286 1372  
327236 5071284 1374  5071284 1374  5071284 1374  5071284 1374  5071279 1373  5071261 1374  
327237 5071256 1373  5071237 1374  5071224 1372  5071205 1372  5071190 1372  5071182 1370  
327238 5071159 1370  5071134 1370  5071106 1370  5071090 1372  5071071 1372  5071047 1372  
327239 5071025 1370  5070999 1372  5070980 1372  5070958 1370  5070932 1372  5070915 1370  
327240 5070894 1372  5070880 1372  5070855 1374  5070837 1372  5070830 1373  5070811 1374  
327241 5070808 1372  5070799 1372  5070792 1374  5070788 1374  5070788 1374  5070788 1374  
327242 5070788 1374  5070792 1374  5070791 1375  5070796 1375  5070811 1373  5070821 1374  
327243 5070831 1374  5070845 1374  5070861 1372  5070881 1375  5070897 1374  5070921 1374  
327244 5070936 1374  5070960 1374  5070984 1374  5071002 1374  5071037 1372  5071060 1374  
327245 5071084 1374  5071103 1374  5071131 1374  5071155 1373  5071179 1374  5071198 1374  
327246 5071222 1374  5071245 1375  5071259 1375  5071284 1374  5071299 1374  5071313 1374  
327247 5071327 1374  5071337 1374  5071346 1374  5071353 1372  5071361 1373  5071362 1372  
327248 5071362 1372  5071362 1372  5071351 1373  5071346 1374  5071329 1372  5071324 1372  
327249 5071303 1373  5071291 1372  5071270 1374  5071257 1372  5071227 1373  5071205 1372  
327250 5071181 1372  5071157 1372  5071124 1372  5071090 1372  5071060 1374  5071031 1373  
327251 5070998 1374  5070978 1374  5070944 1375  5070912 1373  5070881 1375  5070853 1375  
327252 5070829 1375  5070796 1375  5070773 1379  5070743 1375  5070726 1379  5070702 1379  
327253 5070681 1381  5070662 1381  5070648 1381  5070640 1379  5070625 1379  5070625 1379  
327254 5070615 1381  5070606 1379  5070606 1379  5070606 1379  5070619 1375  5070625 1379  
327255 5070630 1379  5070649 1379  5070664 1379  5070681 1381  5070692 1379  5070706 1379  
327256 5070729 1381  5070750 1379  5070773 1379  5070791 1381  5070826 1379  5070853 1375  
327257 5070878 1379  5070902 1379  5070931 1379  5070955 1379  5070984 1379  5071020 1375  
327258 5071041 1379  5071068 1375  5071097 1375  5071117 1379  5071144 1375  5071168 1375  
327259 5071187 1375  5071202 1375  5071221 1375  5071235 1375  5071254 1375  5071268 1375  
327260 5071278 1375  5071280 1379  5071284 1379  5071288 1375  5071284 1379  5071288 1375  
327261 5071283 1375  5071280 1379  5071265 1379  5071259 1375  5071251 1379  5071232 1379  
327262 5071218 1379  5071199 1379  5071184 1379  5071164 1381  5071151 1379  5071127 1379  
327263 5071098 1379  5071078 1381  5071055 1379  5071032 1379  5071017 1379  5070984 1379  
327264 5070965 1379  5070950 1379  5070925 1381  5070906 1381  5070887 1381  5070874 1379  
327265 5070853 1381  5070839 1381  5070829 1381  5070825 1381  5070815 1381  5070805 1381  
327266 5070805 1381  5070801 1381  5070801 1381  5070801 1381  5070805 1381  5070805 1381  
327267 5070815 1381  5070825 1381  5070839 1381  5070848 1381  5070863 1381  5070877 1381  
327268 5070891 1381  5070915 1381  5070930 1381  5070954 1381  5070977 1381  5070992 1381  
327269 5071025 1381  5071049 1381  5071073 1381  5071092 1381  5071116 1381  5071140 1381  
327270 5071173 1381  5071183 1381  5071216 1381  5071230 1381  5071254 1381  5071273 1381  
327271 5071293 1381  5071307 1381  5071321 1381  5071340 1381  5071355 1381  5071364 1381  
327272 5071364 1381  5071374 1381  5071374 1381  5071375 1379  5071374 1381  5071364 1381  
327273 5071355 1381  5071345 1381  5071331 1381  5071321 1381  5071297 1381  5071283 1381  
327274 5071264 1381  5071240 1381  5071216 1381  5071183 1381  5071164 1381  5071125 1381  
327275 5071097 1381  5071073 1381  5071030 1381  5071006 1381  5070972 1381  5070939 1381  
327276 5070906 1381  5070877 1381  5070853 1381  5070825 1381  5070791 1381  5070772 1381  
327277 5070748 1381  5070724 1381  5070700 1381  5070681 1381  5070661 1383  5070648 1381  
327278 5070629 1381  5070624 1381  5070614 1381  5070605 1381  5070605 1381  5070605 1381  
327279 5070605 1381  5070605 1381  5070615 1381  5070627 1383  5070627 1383  5070648 1381  
327280 5070661 1383  5070681 1381  5070699 1383  5070713 1383  5070727 1383  5070753 1381  
327281 5070782 1381  5070801 1381  5070828 1383  5070852 1383  5070884 1385  5070904 1383  
327282 5070937 1383  5070961 1383  5070992 1381  5071014 1383  5071047 1383  5071071 1383  
327283 5071091 1383  5071114 1383  5071138 1383  5071162 1383  5071176 1383  5071194 1385  
327284 5071214 1383  5071229 1383  5071238 1383  5071249 1381  5071253 1383  5071264 1381  
327285 5071264 1381  5071264 1381  5071264 1381  5071262 1383  5071254 1381  5071249 1381  
327286 5071240 1381  5071230 1381  5071221 1381  5071206 1381  5071192 1381  5071178 1381  
327287 5071154 1381  5071130 1381  5071116 1381  5071092 1381  5071077 1381  5071054 1381  
327288 5071039 1381  5071014 1383  5070992 1381  5070973 1381  5070954 1381  5070930 1381  
327289 5070915 1381  5070901 1381  5070885 1383  5070872 1381  5070853 1381  5070839 1381  
327290 5070828 1383  5070823 1383  5070813 1383  5070804 1383  5070804 1383  5070799 1383  
327291 5070799 1383  5070799 1383  5070804 1383  5070815 1381  5070823 1383  5070828 1383  
327292 5070837 1383  5070852 1383  5070869 1385  5070885 1383  5070904 1383  5070923 1383  
327293 5070947 1383  5070962 1383  5070980 1383  5071004 1383  5071028 1383  5071052 1383  
327294 5071077 1381  5071095 1383  5071124 1383  5071148 1383  5071172 1383  5071191 1383  
327295 5071213 1385  5071237 1385  5071262 1383  5071277 1383  5071291 1383  5071305 1383  
327296 5071318 1385  5071328 1385  5071339 1383  5071343 1383  5071351 1385  5071351 1385  
327297 5071353 1383  5071342 1385  5071342 1385  5071329 1383  5071318 1385  5071313 1385  
327298 5071296 1383  5071277 1383  5071261 1385  5071238 1383  5071214 1383  5071192 1381  
327299 5071172 1383  5071138 1383  5071105 1383  5071081 1383  5071052 1383  5071014 1383  
327300 5070982 1381  5070952 1383  5070923 1383  5070890 1383  5070871 1383  5070837 1383  
327301 5070804 1383  5070785 1383  5070750 1385  5070726 1385  5070704 1383  5070683 1385  
327302 5070661 1383  5070646 1383  5070626 1385  5070611 1385  5070603 1383  5070588 1385  
327303 5070583 1385  5070584 1383  5070583 1385  5070584 1383  5070583 1385  5070588 1385  
327304 5070599 1383  5070602 1385  5070621 1385  5070637 1383  5070646 1383  5070659 1385  
327305 5070685 1383  5070697 1385  5070721 1385  5070746 1383  5070769 1385  5070788 1385  
327306 5070812 1385  5070837 1383  5070869 1385  5070888 1385  5070923 1383  5070945 1385  
327307 5070974 1385  5070993 1385  5071021 1387  5071047 1383  5071070 1385  5071089 1385  
327308 5071113 1385  5071127 1385  5071148 1383  5071170 1385  5071180 1385  5071191 1383  
327309 5071196 1383  5071205 1383  5071213 1385  5071219 1383  5071220 1383  5071221 1381  
327310 5071220 1383  5071220 1383  5071216 1381  5071214 1383  5071195 1383  5071191 1383  
327311 5071181 1383  5071172 1383  5071154 1381  5071138 1383  5071124 1383  5071095 1383  
327312 5071081 1383  5071071 1383  5071047 1383  5071028 1383  5071014 1383  5070990 1383  
327313 5070976 1383  5070952 1383  5070937 1383  5070922 1385  5070903 1385  5070884 1385  
327314 5070871 1383  5070852 1383  5070847 1383  5070826 1385  5070821 1385  5070823 1383  
327315 5070812 1385  5070802 1385  5070802 1385  5070802 1385  5070802 1385  5070810 1387  
327316 5070810 1387  5070822 1385  5070836 1385  5070844 1387  5070858 1387  5070872 1387  
327317 5070887 1387  5070901 1387  5070926 1385  5070944 1387  5070958 1387  5070977 1387  
327318 5071003 1385  5071027 1385  5071044 1387  5071074 1385  5071094 1385  5071122 1385  
327319 5071144 1387  5071169 1387  5071188 1387  5071213 1385  5071227 1385  5071250 1387  
327320 5071270 1385  5071278 1387  5071294 1385  5071312 1387  5071318 1385  5071336 1387  
327321 5071340 1387  5071339 1389  5071339 1389  5071341 1387  5071339 1389  5071340 1387  
327322 5071326 1387  5071318 1385  5071313 1385  5071294 1385  5071280 1385  5071261 1385  
327323 5071245 1387  5071218 1385  5071194 1385  5071175 1385  5071151 1385  5071127 1385  
327324 5071094 1385  5071070 1385  5071036 1385  5071012 1385  5070974 1385  5070947 1383  
327325 5070922 1385  5070888 1385  5070860 1385  5070825 1387  5070801 1387  5070778 1385  
327326 5070748 1387  5070726 1385  5070701 1387  5070688 1385  5070668 1385  5070653 1387  
327327 5070634 1387  5070624 1387  5070610 1387  5070610 1387  5070599 1389  5070595 1387  
327328 5070594 1389  5070595 1387  5070594 1389  5070600 1387  5070610 1387  5070618 1389  
327329 5070634 1387  5070643 1387  5070658 1387  5070677 1387  5070696 1387  5070710 1387  
327330 5070724 1387  5070749 1387  5070777 1387  5070796 1387  5070820 1387  5070849 1387  
327331 5070872 1387  5070896 1387  5070925 1387  5070949 1387  5070973 1387  5070992 1387  
327332 5071022 1385  5071044 1387  5071068 1387  5071087 1387  5071111 1387  5071126 1387  
327333 5071145 1387  5071159 1387  5071169 1387  5071178 1387  5071191 1389  5071202 1387  
327334 5071201 1389  5071211 1387  5071211 1387  5071211 1387  5071210 1389  5071211 1387  
327335 5071202 1387  5071193 1387  5071188 1387  5071178 1387  5071169 1387  5071159 1387  
327336 5071145 1387  5071127 1385  5071111 1387  5071092 1387  5071079 1385  5071070 1385  
327337 5071051 1385  5071035 1387  5071012 1385  5070992 1387  5070977 1387  5070960 1385  
327338 5070946 1385  5070925 1387  5070912 1385  5070898 1385  5070888 1385  5070874 1385  
327339 5070858 1387  5070850 1385  5070844 1387  5070834 1387  5070825 1387  5070823 1389  
327340 5070825 1387  5070823 1389  5070823 1389  5070833 1389  5070833 1389  5070842 1389  
327341 5070847 1389  5070866 1389  5070869 1390  5070885 1389  5070898 1390  5070919 1389  
327342 5070941 1390  5070957 1389  5070973 1387  5070990 1389  5071019 1389  5071044 1387  
327343 5071059 1387  5071078 1387  5071100 1389  5071126 1387  5071149 1387  5071173 1387  
327344 5071193 1387  5071211 1387  5071235 1387  5071250 1387  5071269 1387  5071278 1387  
327345 5071288 1387  5071293 1387  5071312 1387  5071317 1387  5071317 1387  5071326 1387  
327346 5071325 1389  5071317 1387  5071317 1387  5071318 1385  5071302 1387  5071294 1385  
327347 5071280 1385  5071269 1387  5071250 1387  5071237 1385  5071218 1385  5071193 1387  
327348 5071175 1385  5071151 1385  5071126 1387  5071102 1387  5071075 1385  5071046 1385  
327349 5071022 1385  5070989 1385  5070960 1385  5070927 1385  5070903 1385  5070872 1387  
327350 5070850 1385  5070822 1385  5070798 1385  5070777 1387  5070748 1387  5070724 1387  
327351 5070701 1387  5070686 1387  5070676 1387  5070656 1389  5070643 1387  5070634 1387  
327352 5070624 1387  5070620 1387  5070610 1387  5070608 1389  5070599 1389  5070608 1389  
327353 5070610 1387  5070608 1389  5070623 1389  5070632 1389  5070642 1389  5070651 1389  
327354 5070666 1389  5070680 1389  5070694 1389  5070708 1389  5070723 1389  5070747 1389  
327355 5070767 1387  5070785 1389  5070810 1387  5070823 1389  5070847 1389  5070871 1389  
327356 5070895 1389  5070919 1389  5070943 1389  5070966 1389  5070986 1389  5071009 1389  
327357 5071025 1387  5071048 1389  5071068 1387  5071076 1389  5071091 1389  5071111 1387  
327358 5071126 1387  5071134 1389  5071145 1387  5071149 1387  5071159 1387  5071169 1387  
327359 5071169 1387  5071167 1389  5071169 1387  5071169 1387  5071159 1387  5071159 1387  
327360 5071149 1387  5071145 1387  5071135 1387  5071126 1387  5071111 1387  5071102 1387  
327361 5071092 1387  5071078 1387  5071068 1387  5071049 1387  5071035 1387  5071021 1387  
327362 5071001 1387  5070989 1385  5070974 1385  5070951 1385  5070936 1385  5070922 1385  
327363 5070904 1383  5070890 1383  5070885 1383  5070874 1385  5070861 1383  5070852 1383  
327364 5070847 1383  5070847 1383  5070839 1381  5070839 1381  5070839 1381  5070839 1381  
327365 5070839 1381  5070839 1381  5070849 1381  5070853 1381  5070863 1381  5070872 1381  
327366 5070877 1381  5070892 1381  5070906 1381  5070925 1381  5070939 1381  5070954 1381  
327367 5070973 1381  5070992 1381  5071006 1381  5071030 1381  5071049 1381  5071071 1383  
327368 5071091 1383  5071114 1383  5071127 1385  5071151 1385  5071173 1387  5071189 1385  
327369 5071203 1385  5071215 1389  5071235 1387  5071248 1389  5071269 1387  5071272 1389  
327370 5071288 1387  5071286 1389  5071291 1389  5071291 1389  5071301 1389  5071302 1387  
327371 5071291 1389  5071291 1389  5071286 1389  5071277 1389  5071267 1389  5071259 1387  
327372 5071243 1389  5071224 1389  5071210 1389  5071184 1390  5071172 1389  5071148 1389  
327373 5071134 1389  5071100 1389  5071076 1389  5071057 1389  5071033 1389  5071000 1389  
327374 5070977 1387  5070949 1387  5070925 1387  5070903 1385  5070874 1385  5070852 1383  
327375 5070828 1383  5070804 1383  5070786 1381  5070772 1381  5070748 1381  5070729 1381  
327376 5070715 1381  5070700 1381  5070686 1381  5070672 1381  5070662 1381  5070657 1381  
327377 5070648 1381  5070648 1381  5070638 1381  5070638 1381  5070638 1381  5070648 1381  
327378 5070648 1381  5070657 1381  5070661 1383  5070672 1381  5070686 1381  5070691 1381  
327379 5070705 1381  5070724 1381  5070737 1383  5070753 1381  5070772 1381  5070786 1381  
327380 5070805 1381  5070825 1381  5070849 1381  5070872 1381  5070887 1381  5070906 1381  
327381 5070930 1381  5070954 1381  5070977 1381  5070992 1381  5071015 1381  5071028 1383  
327382 5071049 1381  5071062 1383  5071082 1381  5071092 1381  5071105 1383  5071124 1383  
327383 5071129 1383  5071138 1383  5071148 1383  5071154 1381  5071153 1383  5071162 1383  
327384 5071162 1383  5071162 1383  5071162 1383  5071162 1383  5071153 1383  5071153 1383  
327385 5071149 1381  5071140 1381  5071130 1381  5071116 1381  5071106 1381  5071097 1381  
327386 5071082 1381  5071073 1381  5071063 1381  5071049 1381  5071030 1381  5071015 1381  
327387 5070998 1379  5070982 1381  5070974 1379  5070955 1379  5070949 1381  5070931 1379  
327388 5070917 1379  5070907 1379  5070902 1379  5070892 1381  5070887 1381  5070877 1381  
327389 5070877 1381  5070872 1381  5070863 1381  5070863 1381  5070863 1381  5070863 1381  
327390 5070863 1381  5070874 1379  5070877 1381  5070887 1381  5070891 1381  5070901 1381  
327391 5070915 1381  5070930 1381  5070948 1381  5070954 1381  5070977 1381  5070992 1381  
327392 5071006 1381  5071025 1381  5071039 1381  5071063 1381  5071081 1383  5071095 1383  
327393 5071114 1383  5071138 1383  5071151 1385  5071172 1383  5071191 1383  5071203 1385  
327394 5071218 1385  5071227 1385  5071246 1385  5071251 1385  5071261 1385  5071270 1385  
327395 5071275 1385  5071280 1385  5071280 1385  5071281 1383  5071280 1385  5071277 1383  
327396 5071275 1385  5071270 1385  5071263 1383  5071253 1383  5071240 1381  5071221 1381  
327397 5071215 1383  5071197 1381  5071183 1381  5071164 1381  5071149 1381  5071126 1381  
327398 5071097 1381  5071078 1381  5071063 1381  5071030 1381  5071006 1381  5070982 1381  
327399 5070973 1381  5070948 1381  5070925 1381  5070901 1381  5070877 1381  5070853 1381  
327400 5070829 1381  5070817 1379  5070791 1381  5070782 1381  5070753 1381  5070738 1381  
327401 5070724 1381  5070715 1381  5070700 1381  5070691 1381  5070686 1381  5070682 1381  
327402 5070672 1381  5070672 1381  5070672 1381  5070672 1381  5070672 1381  5070681 1381  
327403 5070680 1383  5070686 1381  5070691 1381  5070700 1381  5070704 1383  5070715 1381  
327404 5070729 1381  5070737 1383  5070753 1381  5070772 1381  5070786 1381  5070805 1381  
327405 5070825 1381  5070839 1381  5070863 1381  5070877 1381  5070901 1381  5070925 1381  
327406 5070939 1381  5070963 1381  5070977 1381  5070992 1381  5071015 1381  5071030 1381  
327407 5071049 1381  5071063 1381  5071073 1381  5071082 1381  5071092 1381  5071106 1381  
327408 5071116 1381  5071126 1381  5071130 1381  5071140 1381  5071149 1381  5071149 1381  
327409 5071149 1381  5071149 1381  5071149 1381  5071149 1381  5071140 1381  5071140 1381  
327410 5071130 1381  5071126 1381  5071116 1381  5071106 1381  5071097 1381  5071082 1381  
327411 5071073 1381  5071063 1381  5071049 1381  5071030 1381  5071025 1381  5071006 1381  
327412 5070992 1381  5070982 1381  5070973 1381  5070963 1381  5070949 1381  5070939 1381  
327413 5070925 1381  5070914 1383  5070904 1383  5070901 1381  5070892 1381  5070887 1381  
327414 5070885 1383  5070877 1381  5070875 1383  5070875 1383  5070877 1381  5070875 1383  
327415 5070875 1383  5070885 1383  5070890 1383  5070899 1383  5070904 1383  5070925 1381  
327416 5070928 1383  5070938 1383  5070954 1381  5070971 1383  5070976 1383  5070990 1383  
327417 5071006 1381  5071024 1383  5071038 1383  5071063 1381  5071076 1383  5071091 1383  
327418 5071114 1383  5071129 1383  5071148 1383  5071162 1383  5071176 1383  5071191 1383  
327419 5071196 1383  5071215 1383  5071220 1383  5071239 1383  5071248 1383  5071253 1383  
327420 5071253 1383  5071263 1383  5071261 1385  5071263 1383  5071261 1385  5071262 1383  
327421 5071253 1383  5071254 1381  5071249 1381  5071240 1381  5071221 1381  5071216 1381  
327422 5071196 1383  5071183 1381  5071173 1381  5071154 1381  5071130 1381  5071116 1381  
327423 5071097 1381  5071078 1381  5071054 1381  5071039 1381  5071015 1381  5070992 1381  
327424 5070977 1381  5070954 1381  5070930 1381  5070904 1383  5070890 1383  5070871 1383  
327425 5070847 1383  5070828 1383  5070813 1383  5070799 1383  5070786 1381  5070770 1383  
327426 5070752 1383  5070746 1383  5070726 1385  5070721 1385  5070713 1383  5070713 1383  
327427 5070699 1383  5070697 1385  5070699 1383  5070697 1385  5070697 1385  5070699 1383  
327428 5070702 1385  5070702 1385  5070711 1385  5070726 1385  5070735 1385  5070745 1385  
327429 5070748 1387  5070767 1387  5070783 1385  5070798 1385  5070812 1385  5070826 1385  
327430 5070850 1385  5070869 1385  5070884 1385  5070898 1385  5070922 1385  5070936 1385  
327431 5070960 1385  5070974 1385  5070990 1383  5071004 1383  5071028 1383  5071049 1381  
327432 5071062 1383  5071076 1383  5071091 1383  5071106 1381  5071123 1385  5071129 1383  
327433 5071140 1381  5071148 1383  5071153 1383  5071162 1383  5071172 1383  5071172 1383  
327434 5071176 1383  5071176 1383  5071176 1383  5071176 1383  5071170 1385  5071170 1385  
327435 5071153 1383  5071149 1381  5071138 1383  5071127 1385  5071116 1381  5071094 1385  
327436 5071089 1385  5071076 1383  5071071 1383  5071047 1383  5071039 1381  5071024 1383  
327437 5071014 1383  5070995 1383  5070980 1383  5070973 1381  5070962 1383  5070947 1383  
327438 5070936 1385  5070923 1383  5070914 1383  5070904 1383  5070898 1385  5070888 1385  
327439 5070884 1385  5070875 1383  5070874 1385  5070874 1385  5070874 1385  5070874 1385  
327440 5070874 1385  5070884 1385  5070888 1385  5070888 1385  5070896 1387  5070901 1387  
327441 5070912 1385  5070920 1387  5070936 1385  5070944 1387  5070949 1387  5070970 1385  
327442 5070979 1385  5070993 1385  5071013 1385  5071027 1385  5071046 1385  5071060 1385  
327443 5071074 1385  5071087 1387  5071103 1385  5071121 1387  5071137 1385  5071151 1385  
327444 5071168 1387  5071175 1385  5071189 1385  5071194 1385  5071213 1385  5071218 1385  
327445 5071227 1385  5071226 1387  5071235 1387  5071235 1387  5071237 1385  5071237 1385  
327446 5071235 1387  5071237 1385  5071237 1385  5071228 1385  5071218 1385  5071213 1385  
327447 5071194 1385  5071189 1385  5071175 1385  5071161 1385  5071148 1383  5071127 1385  
327448 5071113 1385  5071094 1385  5071075 1385  5071060 1385  5071036 1385  5071014 1383  
327449 5070993 1385  5070974 1385  5070952 1383  5070936 1385  5070914 1383  5070898 1385  
327450 5070875 1383  5070850 1385  5070836 1385  5070820 1387  5070802 1385  5070786 1387  
327451 5070777 1387  5070759 1385  5070748 1387  5070734 1387  5070724 1387  5070720 1387  
327452 5070710 1387  5070710 1387  5070710 1387  5070710 1387  5070710 1387  5070710 1387  
327453 5070710 1387  5070720 1387  5070721 1385  5070724 1387  5070743 1387  5070748 1387  
327454 5070758 1387  5070777 1387  5070782 1387  5070798 1385  5070820 1387  5070836 1385  
327455 5070849 1387  5070868 1387  5070887 1387  5070901 1387  5070920 1387  5070944 1387  
327456 5070968 1387  5070987 1387  5071001 1387  5071025 1387  5071044 1387  5071068 1387  
327457 5071079 1385  5071092 1387  5071111 1387  5071127 1385  5071135 1387  5071149 1387  
327458 5071159 1387  5071175 1385  5071178 1387  5071178 1387  5071189 1385  5071194 1385  
327459 5071193 1387  5071194 1385  5071189 1385  5071188 1387  5071180 1385  5071180 1385  
327460 5071173 1387  5071161 1385  5071149 1387  5071145 1387  5071126 1387  5071121 1387  
327461 5071103 1385  5071089 1385  5071073 1387  5071070 1385  5071046 1385  5071025 1387  
327462 5071011 1387  5070992 1387  5070977 1387  5070968 1387  5070949 1387  5070933 1389  
327463 5070920 1387  5070900 1389  5070895 1389  5070880 1389  5070869 1390  5070866 1389  
327464 5070857 1389  5070847 1389  5070841 1390  5070831 1390  5070833 1389  5070833 1389  
327465 5070833 1389  5070831 1391  5070831 1390  5070841 1390  5070847 1389  5070847 1389  
327466 5070865 1390  5070869 1390  5070880 1389  5070895 1389  5070900 1389  5070919 1389  
327467 5070924 1389  5070944 1387  5070958 1387  5070973 1387  5070992 1387  5071011 1387  
327468 5071035 1387  5071049 1387  5071068 1387  5071088 1387  5071100 1389  5071119 1389  
327469 5071135 1387  5071149 1387  5071168 1387  5071180 1385  5071186 1389  5071202 1387  
327470 5071211 1387  5071226 1387  5071226 1387  5071235 1387  5071243 1389  5071243 1389  
327471 5071250 1387  5071250 1387  5071250 1387  5071242 1390  5071243 1389  5071235 1387  
327472 5071224 1389  5071215 1389  5071202 1387  5071186 1389  5071173 1387  5071167 1389  
327473 5071144 1387  5071124 1389  5071110 1389  5071086 1389  5071067 1389  5071048 1389  
327474 5071025 1387  5071001 1387  5070977 1387  5070968 1387  5070944 1387  5070920 1387  
327475 5070896 1387  5070882 1387  5070857 1389  5070834 1387  5070818 1389  5070801 1387  
327476 5070785 1389  5070777 1387  5070756 1389  5070745 1390  5070732 1389  5070723 1389  
327477 5070720 1387  5070718 1389  5070710 1387  5070708 1389  5070710 1387  5070720 1387  
327478 5070720 1387  5070723 1389  5070731 1390  5070742 1389  5070747 1389  5070764 1390  
327479 5070780 1389  5070795 1389  5070798 1390  5070822 1390  5070841 1390  5070855 1390  
327480 5070879 1390  5070898 1390  5070919 1389  5070946 1390  5070965 1390  5070984 1390  
327481 5071008 1390  5071032 1390  5071057 1389  5071075 1390  5071091 1389  5071116 1392  
327482 5071142 1390  5071156 1390  5071170 1390  5071184 1390  5071200 1389  5071213 1390  
327483 5071223 1390  5071232 1390  5071242 1390  5071248 1389  5071248 1389  5071248 1389  
327484 5071258 1389  5071248 1389  5071248 1389  5071248 1389  5071243 1389  5071234 1389  
327485 5071226 1387  5071216 1387  5071202 1387  5071188 1387  5071176 1389  5071167 1389  
327486 5071143 1389  5071124 1389  5071100 1389  5071086 1389  5071071 1389  5071047 1389  
327487 5071033 1389  5071009 1389  5070986 1389  5070971 1389  5070957 1389  5070933 1389  
327488 5070919 1389  5070900 1389  5070884 1390  5070866 1389  5070845 1390  5070830 1392  
327489 5070823 1389  5070807 1390  5070798 1391  5070791 1392  5070784 1390  5070779 1390  
327490 5070778 1390  5070779 1390  5070779 1390  5070784 1390  5070785 1389  5070793 1390  
327491 5070798 1390  5070817 1390  5070822 1390  5070841 1390  5070855 1390  5070869 1390  
327492 5070885 1389  5070898 1390  5070922 1390  5070942 1389  5070966 1389  5070986 1389  
327493 5070998 1390  5071022 1390  5071048 1389  5071071 1389  5071089 1390  5071117 1390  
327494 5071143 1389  5071158 1389  5071175 1390  5071191 1389  5071210 1389  5071232 1390  
327495 5071248 1389  5071267 1389  5071272 1389  5071277 1389  5071286 1389  5071291 1389  
327496 5071291 1389  5071291 1389  5071301 1389  5071291 1389  5071291 1389  5071288 1387  
327497 5071277 1389  5071269 1387  5071259 1387  5071245 1387  5071224 1389  5071210 1389  
327498 5071191 1389  5071172 1389  5071159 1387  5071135 1387  5071110 1389  5071086 1389  
327499 5071067 1389  5071043 1389  5071021 1387  5070990 1389  5070970 1390  5070941 1390  
327500 5070917 1390  5070893 1390  5070869 1390  5070845 1390  5070831 1390  5070817 1390  
327501 5070796 1392  5070777 1392  5070764 1390  5070755 1390  5070739 1392  5070729 1392  
327502 5070721 1390  5070717 1390  5070707 1390  5070707 1390  5070707 1390  5070707 1390  
327503 5070717 1390  5070721 1390  5070731 1390  5070740 1390  5070756 1389  5070775 1389  
327504 5070785 1389  5070798 1391  5070817 1390  5070842 1389  5070866 1389  5070884 1390  
327505 5070907 1390  5070931 1390  5070955 1390  5070986 1389  5071008 1390  5071033 1389  
327506 5071067 1389  5071084 1390  5071108 1390  5071132 1390  5071157 1389  5071170 1390  
327507 5071191 1389  5071208 1390  5071232 1390  5071247 1390  5071266 1390  5071271 1390  
327508 5071275 1390  5071285 1390  5071299 1390  5071301 1389  5071301 1389  5071301 1389  
327509 5071299 1390  5071299 1390  5071290 1390  5071286 1389  5071277 1389  5071272 1389  
327510 5071258 1389  5071243 1389  5071223 1390  5071199 1391  5071186 1389  5071167 1389  
327511 5071143 1389  5071119 1389  5071091 1389  5071067 1389  5071049 1387  5071019 1389  
327512 5070990 1389  5070971 1389  5070942 1389  5070917 1390  5070895 1389  5070865 1390  
327513 5070841 1390  5070818 1389  5070799 1389  5070778 1390  5070755 1390  5070740 1390  
327514 5070721 1390  5070707 1390  5070696 1392  5070694 1389  5070683 1390  5070678 1390  
327515 5070678 1390  5070678 1390  5070677 1392  5070678 1390  5070693 1390  5070693 1390  
327516 5070707 1390  5070717 1390  5070731 1390  5070753 1392  5070774 1390  5070793 1390  
327517 5070817 1390  5070831 1390  5070857 1389  5070885 1389  5070908 1390  5070933 1389  
327518 5070965 1390  5070990 1389  5071019 1389  5071047 1389  5071076 1389  5071108 1390  
327519 5071132 1390  5071156 1390  5071175 1390  5071199 1390  5071224 1389  5071242 1390  
327520 5071258 1389  5071274 1392  5071290 1390  5071299 1390  5071309 1390  5071312 1392  
327521 5071323 1390  5071323 1390  5071333 1390  5071322 1392  5071323 1390  5071313 1390  
327522 5071309 1390  5071301 1389  5071285 1390  5071271 1390  5071247 1390  5071231 1392  
327523 5071208 1390  5071184 1390  5071167 1389  5071142 1390  5071118 1390  5071091 1389  
327524 5071067 1389  5071043 1389  5071009 1389  5070986 1389  5070966 1389  5070942 1389  
327525 5070909 1389  5070885 1389  5070866 1389  5070842 1389  5070823 1389  5070799 1389  
327526 5070785 1389  5070766 1389  5070755 1390  5070740 1391  5070721 1391  5070721 1391  
327527 5070717 1390  5070707 1390  5070707 1390  5070707 1390  5070707 1390  5070715 1392  
327528 5070721 1390  5070740 1390  5070745 1390  5070763 1392  5070784 1390  5070798 1390  
327529 5070822 1390  5070845 1390  5070869 1390  5070893 1390  5070917 1390  5070942 1389  
327530 5070970 1390  5070998 1390  5071022 1390  5071056 1390  5071084 1390  5071108 1390  
327531 5071141 1390  5071165 1390  5071190 1390  5071213 1390  5071242 1390  5071266 1390  
327532 5071274 1392  5071298 1392  5071314 1391  5071333 1390  5071336 1392  5071357 1390  
327533 5071366 1390  5071371 1390  5071376 1390  5071374 1392  5071376 1390  5071372 1389  
327534 5071371 1390  5071366 1390  5071358 1389  5071339 1389  5071333 1390  5071315 1389  
327535 5071291 1389  5071277 1389  5071250 1387  5071234 1389  5071200 1389  5071175 1391  
327536 5071148 1389  5071118 1390  5071086 1389  5071056 1390  5071024 1389  5070989 1391  
327537 5070965 1390  5070931 1390  5070892 1392  5070869 1390  5070839 1392  5070806 1392  
327538 5070777 1392  5070744 1392  5070720 1392  5070696 1392  5070677 1392  5070662 1392  
327539 5070648 1392  5070629 1392  5070613 1394  5070605 1392  5070594 1394  5070591 1392  
327540 5070589 1394  5070591 1392  5070591 1392  5070596 1392  5070604 1394  5070620 1392  
327541 5070637 1394  5070653 1392  5070670 1394  5070691 1392  5070705 1392  5070740 1390  
327542 5070763 1392  5070793 1390  5070817 1390  5070845 1390  5070877 1392  5070906 1392  
327543 5070946 1390  5070974 1390  5071018 1390  5071046 1390  5071075 1390  5071108 1390  
327544 5071142 1390  5071164 1392  5071189 1390  5071213 1390  5071242 1390  5071266 1390  
327545 5071283 1392  5071299 1390  5071313 1390  5071323 1390  5071337 1390  5071347 1390  
327546 5071358 1389  5071358 1389  5071358 1389  5071357 1390  5071348 1389  5071337 1390  
327547 5071334 1389  5071315 1389  5071299 1390  5071285 1390  5071264 1392  5071240 1392  
327548 5071212 1392  5071189 1390  5071169 1392  5071146 1390  5071118 1390  5071088 1392  
327549 5071064 1392  5071030 1392  5071008 1390  5070974 1390  5070954 1392  5070922 1390  
327550 5070893 1390  5070869 1390  5070845 1390  5070822 1390  5070798 1390  5070780 1389  
327551 5070764 1390  5070746 1389  5070732 1389  5070718 1389  5070708 1389  5070699 1389  
327552 5070697 1390  5070699 1389  5070699 1389  5070697 1390  5070708 1389  5070718 1389  
327553 5070723 1389  5070748 1387  5070756 1389  5070782 1387  5070794 1389  5070818 1389  
327554 5070844 1387  5070868 1387  5070895 1389  5070919 1389  5070941 1390  5070971 1389  
327555 5070998 1390  5071024 1389  5071057 1389  5071086 1389  5071119 1389  5071146 1390  
327556 5071175 1390  5071199 1390  5071232 1390  5071256 1390  5071274 1392  5071299 1390  
327557 5071313 1390  5071337 1390  5071357 1390  5071371 1390  5071376 1390  5071385 1390  
327558 5071389 1392  5071390 1390  5071400 1390  5071399 1390  5071389 1392  5071384 1392  
327559 5071374 1392  5071366 1390  5071347 1390  5071333 1390  5071309 1390  5071290 1390  
327560 5071266 1390  5071242 1390  5071208 1390  5071175 1390  5071142 1390  5071108 1390  
327561 5071075 1390  5071041 1390  5071000 1389  5070970 1390  5070924 1389  5070893 1390  
327562 5070855 1390  5070817 1390  5070785 1389  5070745 1390  5070715 1392  5070677 1392  
327563 5070650 1390  5070621 1390  5070591 1392  5070572 1392  5070548 1392  5070519 1392  
327564 5070506 1390  5070495 1392  5070481 1392  5070470 1394  5070471 1392  5070462 1392  
327565 5070462 1392  5070460 1394  5070476 1392  5070481 1392  5070495 1392  5070515 1392  
327566 5070529 1392  5070553 1392  5070576 1392  5070605 1392  5070629 1392  5070662 1392  
327567 5070691 1392  5070720 1392  5070753 1392  5070793 1390  5070820 1392  5070863 1392  
327568 5070897 1392  5070930 1392  5070968 1392  5070997 1392  5071040 1392  5071068 1392  
327569 5071108 1390  5071140 1392  5071169 1392  5071188 1392  5071212 1392  5071245 1392  
327570 5071266 1390  5071285 1390  5071288 1392  5071307 1392  5071313 1390  5071323 1390  
327571 5071323 1390  5071323 1390  5071323 1390  5071323 1390  5071313 1390  5071299 1390  
327572 5071290 1390  5071275 1390  5071266 1390  5071245 1392  5071223 1390  5071197 1392  
327573 5071175 1390  5071156 1390  5071123 1390  5071099 1390  5071070 1390  5071041 1390  
327574 5071008 1390  5070984 1390  5070957 1389  5070922 1390  5070899 1389  5070869 1390  
327575 5070847 1389  5070818 1389  5070794 1389  5070782 1387  5070756 1389  5070742 1389  
327576 5070723 1389  5070708 1389  5070701 1387  5070694 1389  5070694 1389  5070686 1387  
327577 5070685 1389  5070696 1387  5070696 1387  5070700 1387  5070710 1387  5070723 1389  
327578 5070742 1389  5070756 1389  5070780 1389  5070794 1389  5070820 1387  5070849 1387  
327579 5070872 1387  5070895 1389  5070923 1389  5070957 1389  5070986 1389  5071009 1389  
327580 5071043 1389  5071075 1390  5071108 1390  5071141 1390  5071172 1389  5071199 1390  
327581 5071232 1390  5071256 1390  5071283 1392  5071309 1390  5071337 1390  5071355 1392  
327582 5071374 1392  5071390 1390  5071409 1390  5071412 1392  5071424 1390  5071433 1390  
327583 5071433 1390  5071433 1391  5071435 1389  5071434 1389  5071414 1390  5071411 1389  
327584 5071392 1389  5071377 1389  5071358 1389  5071334 1389  5071312 1387  5071277 1389  
327585 5071250 1387  5071216 1387  5071180 1385  5071149 1387  5071111 1387  5071073 1387  
327586 5071036 1385  5070989 1385  5070951 1385  5070912 1385  5070872 1387  5070826 1385  
327587 5070787 1387  5070748 1387  5070711 1385  5070683 1385  5070643 1387  5070611 1385  
327588 5070581 1387  5070554 1385  5070524 1387  5070495 1387  5070476 1387  5070458 1385  
327589 5070442 1387  5070434 1385  5070428 1387  5070419 1387  5070409 1387  5070409 1387  
327590 5070420 1385  5070428 1387  5070433 1387  5070452 1387  5070468 1385  5070486 1387  
327591 5070509 1387  5070533 1387  5070559 1385  5070586 1387  5070621 1385  5070658 1387  
327592 5070688 1385  5070724 1387  5070767 1387  5070801 1387  5070844 1387  5070880 1389  
327593 5070920 1387  5070959 1387  5070992 1387  5071033 1389  5071073 1387  5071102 1387  
327594 5071134 1389  5071168 1387  5071191 1389  5071226 1387  5071250 1387  5071274 1387  
327595 5071288 1387  5071302 1387  5071318 1385  5071326 1387  5071336 1387  5071340 1387  
327596 5071340 1387  5071342 1385  5071337 1385  5071328 1385  5071318 1385  5071302 1387  
327597 5071290 1385  5071274 1387  5071261 1385  5071237 1385  5071211 1387  5071178 1387  
327598 5071161 1385  5071138 1383  5071103 1385  5071074 1385  5071051 1385  5071022 1385  
327599 5070990 1383  5070962 1383  5070927 1385  5070904 1383  5070874 1385  5070852 1383  
327600 5070823 1383  5070804 1383  5070785 1383  5070770 1383  5070750 1385  5070735 1385  
327601 5070721 1385  5070713 1383  5070702 1385  5070702 1385  5070697 1385  5070696 1387  
327602 5070697 1385  5070702 1385  5070711 1385  5070721 1385  5070735 1385  5070750 1385  
327603 5070769 1385  5070783 1385  5070802 1385  5070826 1385  5070861 1383  5070884 1385  
327604 5070912 1385  5070946 1385  5070973 1387  5071001 1387  5071025 1387  5071070 1385  
327605 5071094 1385  5071126 1387  5071159 1387  5071189 1385  5071218 1385  5071251 1385  
327606 5071280 1385  5071312 1387  5071336 1387  5071360 1387  5071374 1387  5071393 1387  
327607 5071412 1387  5071425 1389  5071436 1387  5071441 1387  5071449 1389  5071450 1387  
327608 5071452 1385  5071450 1387  5071441 1387  5071437 1385  5071418 1385  5071404 1385  
327609 5071390 1385  5071371 1385  5071336 1387  5071313 1385  5071280 1385  5071251 1385  
327610 5071213 1385  5071181 1383  5071148 1383  5071095 1383  5071062 1383  5071022 1385  
327611 5070976 1383  5070936 1385  5070898 1385  5070850 1385  5070812 1385  5070780 1383  
327612 5070726 1385  5070699 1383  5070660 1383  5070621 1385  5070587 1385  5070560 1383  
327613 5070525 1385  5070503 1383  5070478 1385  5070454 1385  5070434 1385  5070419 1387  
327614 5070411 1385  5070401 1385  5070395 1387  5070392 1385  5070392 1385  5070395 1387  
327615 5070400 1387  5070419 1387  5070430 1385  5070444 1385  5070466 1387  5070487 1385  
327616 5070509 1387  5070535 1385  5070567 1387  5070595 1387  5070624 1387  5070668 1385  
327617 5070700 1387  5070743 1387  5070777 1387  5070812 1385  5070858 1387  5070896 1387  
327618 5070935 1387  5070973 1387  5071009 1389  5071043 1389  5071078 1387  5071111 1387  
327619 5071145 1387  5071173 1387  5071193 1387  5071216 1387  5071245 1387  5071259 1387  
327620 5071275 1385  5071288 1387  5071304 1385  5071304 1385  5071313 1385  5071318 1385  
327621 5071313 1385  5071315 1383  5071305 1383  5071297 1381  5071283 1381  5071273 1381  
327622 5071254 1381  5071231 1381  5071216 1381  5071194 1379  5071173 1381  5071151 1379  
327623 5071117 1379  5071094 1379  5071068 1375  5071044 1375  5071007 1379  5070982 1375  
327624 5070953 1375  5070929 1375  5070896 1375  5070877 1375  5070853 1375  5070831 1374  
327625 5070811 1373  5070791 1375  5070776 1375  5070757 1375  5070744 1374  5070730 1374  
327626 5070721 1374  5070710 1375  5070711 1374  5070705 1375  5070706 1374  5070710 1375  
327627 5070710 1375  5070719 1375  5070729 1375  5070734 1375  5070759 1374  5070776 1375  
327628 5070791 1375  5070810 1375  5070843 1375  5070858 1375  5070881 1375  5070910 1375  
327629 5070943 1375  5070977 1375  5070996 1375  5071034 1375  5071065 1379  5071087 1375  
327630 5071130 1375  5071159 1375  5071184 1379  5071217 1379  5071251 1379  5071278 1375  
327631 5071302 1375  5071326 1375  5071349 1375  5071369 1375  5071388 1375  5071402 1375  
327632 5071418 1379  5071426 1375  5071436 1375  5071436 1375  5071436 1375  5071426 1375  
327633 5071426 1375  5071423 1373  5071412 1375  5071397 1375  5071385 1374  5071361 1374  
327634 5071337 1374  5071313 1374  5071289 1373  5071260 1373  5071227 1374  5071189 1373  
327635 5071160 1373  5071120 1375  5071083 1373  5071047 1372  5071002 1373  5070958 1375  
327636 5070921 1374  5070883 1373  5070835 1374  5070797 1374  5070759 1374  5070721 1374  
327637 5070687 1374  5070652 1375  5070611 1374  5070586 1375  5070554 1374  5070520 1374  
327638 5070496 1374  5070477 1374  5070452 1375  5070439 1374  5070418 1375  5070404 1375  
327639 5070399 1375  5070390 1375  5070390 1375  5070390 1375  5070390 1375  5070404 1375  
327640 5070408 1375  5070428 1375  5070439 1379  5070458 1379  5070472 1379  5070492 1379  
327641 5070528 1375  5070552 1375  5070582 1379  5070609 1375  5070643 1375  5070686 1375  
327642 5070706 1379  5070743 1375  5070786 1375  5070819 1375  5070853 1375  5070891 1375  
327643 5070929 1375  5070955 1379  5070984 1379  5071027 1379  5071054 1375  5071079 1379  
327644 5071111 1375  5071135 1375  5071156 1379  5071182 1375  5071197 1375  5071211 1375  
327645 5071226 1375  5071236 1373  5071244 1375  5071254 1375  5071254 1375  5071256 1374  
327646 5071246 1374  5071244 1375  5071235 1375  5071225 1375  5071212 1373  5071197 1375  
327647 5071182 1375  5071168 1375  5071144 1375  5071127 1379  5071098 1379  5071079 1379  
327648 5071055 1379  5071034 1375  5071007 1379  5070984 1379  5070958 1375  5070939 1381  
327649 5070907 1379  5070887 1381  5070864 1379  5070840 1379  5070826 1379  5070802 1379  
327650 5070788 1379  5070772 1381  5070753 1381  5070750 1379  5070740 1379  5070730 1379  
327651 5070726 1379  5070716 1379  5070715 1381  5070705 1381  5070715 1381  5070716 1379  
327652 5070724 1381  5070730 1379  5070748 1381  5070762 1381  5070782 1381  5070792 1379  
327653 5070817 1379  5070839 1381  5070864 1379  5070888 1379  5070907 1379  5070939 1381  
327654 5070965 1379  5070992 1381  5071027 1379  5071055 1379  5071084 1379  5071117 1379  
327655 5071150 1379  5071173 1381  5071199 1379  5071230 1381  5071254 1381  5071278 1381  
327656 5071297 1381  5071321 1381  5071346 1379  5071364 1381  5071378 1381  5071383 1381  
327657 5071393 1381  5071398 1381  5071398 1381  5071407 1381  5071407 1381  5071398 1381  
327658 5071393 1381  5071385 1379  5071374 1381  5071355 1381  5071332 1379  5071318 1379  
327659 5071294 1379  5071264 1381  5071241 1379  5071208 1379  5071179 1379  5071149 1381  
327660 5071106 1381  5071079 1379  5071039 1381  5070998 1379  5070964 1379  5070925 1381  
327661 5070893 1379  5070853 1381  5070824 1381  5070786 1381  5070748 1381  5070715 1381  
327662 5070681 1381  5070648 1381  5070624 1381  5070590 1381  5070571 1381  5070548 1381  
327663 5070524 1381  5070504 1381  5070489 1383  5070481 1381  5070469 1383  5070455 1383  
327664 5070455 1383  5070446 1383  5070447 1381  5070447 1381  5070457 1381  5070461 1381  
327665 5070481 1381  5070485 1381  5070504 1381  5070522 1383  5070536 1383  5070560 1383  
327666 5070586 1381  5070603 1383  5070638 1381  5070662 1381  5070691 1381  5070724 1381  
327667 5070753 1381  5070789 1383  5070824 1381  5070852 1383  5070891 1381  5070925 1381  
327668 5070952 1383  5070980 1383  5071014 1383  5071047 1383  5071071 1383  5071095 1383  
327669 5071124 1383  5071138 1383  5071164 1381  5071178 1381  5071191 1383  5071205 1383  
327670 5071216 1381  5071221 1381  5071229 1383  5071229 1383  5071229 1383  5071229 1383  
327671 5071229 1383  5071219 1383  5071214 1383  5071205 1383  5071191 1383  5071175 1385  
327672 5071172 1383  5071146 1385  5071129 1383  5071114 1383  5071089 1385  5071070 1385  
327673 5071050 1385  5071027 1385  5071012 1385  5070989 1385  5070969 1385  5070944 1387  
327674 5070925 1387  5070901 1387  5070887 1387  5070872 1387  5070849 1387  5070834 1387  
327675 5070820 1387  5070810 1387  5070794 1389  5070787 1387  5070782 1387  5070777 1387  
327676 5070777 1387  5070766 1389  5070766 1389  5070766 1389  5070766 1388  5070782 1387  
327677 5070785 1389  5070794 1389  5070809 1389  5070823 1389  5070842 1389  5070857 1389  
327678 5070880 1389  5070899 1389  5070923 1389  5070946 1390  5070971 1389  5070990 1389  
327679 5071019 1389  5071047 1389  5071071 1389  5071100 1389  5071133 1389  5071157 1389  
327680 5071176 1389  5071210 1389  5071224 1389  5071258 1389  5071277 1389  5071291 1389  
327681 5071310 1389  5071334 1389  5071350 1387  5071360 1387  5071374 1387  5071377 1389  
327682 5071386 1389  5071388 1387  5071386 1389  5071386 1389  5071387 1389  5071377 1389  
327683 5071374 1387  5071360 1387  5071339 1389  5071334 1389  5071312 1387  5071286 1389  
327684 5071272 1389  5071248 1389  5071215 1389  5071186 1389  5071158 1389  5071134 1389  
327685 5071091 1389  5071067 1389  5071033 1389  5071000 1389  5070971 1388  5070933 1389  
327686 5070899 1389  5070871 1389  5070842 1389  5070799 1389  5070780 1389  5070747 1389  
327687 5070718 1389  5070696 1387  5070675 1389  5070642 1389  5070623 1389  5070599 1389  
327688 5070586 1387  5070575 1389  5070556 1389  5070551 1389  5070532 1389  5070522 1389  
327689 5070522 1389  5070518 1389  5070522 1389  5070522 1389  5070532 1389  5070541 1389  
327690 5070553 1387  5070567 1387  5070575 1389  5070586 1387  5070610 1387  5070624 1387  
327691 5070651 1389  5070675 1389  5070696 1387  5070724 1387  5070748 1387  5070782 1387  
327692 5070799 1389  5070833 1389  5070866 1389  5070895 1389  5070924 1389  5070959 1387  
327693 5070986 1389  5071011 1387  5071043 1389  5071067 1389  5071087 1387  5071111 1387  
327694 5071124 1389  5071145 1387  5071159 1387  5071172 1389  5071188 1387  5071202 1387  
327695 5071211 1387  5071212 1387  5071216 1387  5071216 1387  5071216 1387  5071211 1387  
327696 5071211 1387  5071202 1387  5071194 1385  5071189 1385  5071175 1385  5071159 1387  
327697 5071151 1385  5071126 1387  5071111 1387  5071092 1387  5071079 1385  5071070 1385  
327698 5071046 1385  5071027 1385  5071001 1387  5070977 1387  5070968 1387  5070949 1387  
327699 5070925 1387  5070911 1387  5070896 1387  5070882 1387  5070858 1387  5070850 1385  
327700 5070833 1389  5070825 1387  5070818 1389  5070810 1387  5070801 1387  5070801 1387  
327701 5070799 1389  5070799 1389  5070801 1387  5070799 1389  5070807 1390  5070818 1389  
327702 5070833 1389  5070842 1389  5070847 1389  5070872 1387  5070884 1390  5070900 1389  
327703 5070919 1389  5070931 1390  5070955 1390  5070976 1389  5071000 1389  5071024 1389  
327704 5071047 1389  5071071 1389  5071091 1389  5071119 1389  5071143 1389  5071167 1389  
327705 5071186 1389  5071210 1389  5071234 1389  5071248 1389  5071274 1387  5071288 1387  
327706 5071301 1389  5071310 1389  5071325 1389  5071334 1389  5071339 1389  5071350 1387  
327707 5071348 1389  5071350 1387  5071348 1389  5071348 1389  5071340 1387  5071336 1387  
327708 5071326 1387  5071316 1387  5071301 1389  5071288 1387  5071273 1387  5071248 1389  
327709 5071235 1387  5071210 1389  5071188 1387  5071168 1387  5071134 1389  5071110 1389  
327710 5071076 1389  5071047 1389  5071025 1387  5070992 1387  5070966 1389  5070944 1387  
327711 5070909 1389  5070885 1389  5070857 1389  5070833 1389  5070799 1389  5070780 1389  
327712 5070756 1389  5070732 1389  5070708 1389  5070693 1390  5070673 1390  5070656 1389  
327713 5070651 1389  5070630 1390  5070621 1390  5070616 1390  5070608 1389  5070597 1390  
327714 5070597 1390  5070597 1390  5070607 1390  5070616 1390  5070619 1392  5070631 1390  
327715 5070638 1392  5070653 1392  5070662 1392  5070677 1392  5070693 1390  5070715 1392  
327716 5070729 1392  5070753 1392  5070777 1392  5070796 1392  5070819 1394  5070844 1392  
327717 5070877 1392  5070897 1392  5070919 1394  5070954 1392  5070973 1392  5070997 1392  
327718 5071021 1392  5071044 1392  5071070 1390  5071084 1390  5071106 1392  5071121 1392  
327719 5071143 1389  5071156 1390  5071170 1390  5071175 1390  5071189 1390  5071197 1392  
327720 5071199 1390  5071207 1392  5071207 1392  5071212 1392  5071212 1392  5071207 1392  
327721 5071207 1392  5071197 1392  5071188 1392  5071183 1392  5071172 1394  5071164 1392  
327722 5071153 1394  5071138 1394  5071120 1394  5071105 1394  5071083 1392  5071068 1392  
327723 5071056 1390  5071032 1390  5071019 1389  5070989 1390  5070976 1389  5070966 1389  
327724 5070947 1389  5070931 1390  5070919 1389  5070900 1389  5070893 1390  5070885 1389  
327725 5070869 1390  5070871 1389  5070866 1389  5070857 1389  5070855 1390  5070845 1390  
327726 5070847 1389  5070845 1390  5070847 1389  5070847 1389  5070857 1389  5070865 1390  
327727 5070869 1390  5070879 1390  5070893 1390  5070899 1389  5070917 1390  5070931 1390  
327728 5070946 1390  5070966 1389  5070974 1390  5070990 1389  5071018 1390  5071033 1389  
327729 5071057 1389  5071070 1390  5071091 1389  5071108 1390  5071123 1390  5071148 1389  
327730 5071167 1389  5071175 1390  5071191 1389  5071208 1390  5071223 1390  5071242 1390  
327731 5071245 1392  5071266 1390  5071272 1389  5071275 1390  5071285 1390  5071286 1389  
327732 5071291 1389  5071291 1389  5071285 1390  5071285 1390  5071275 1390  5071277 1389  
327733 5071271 1390  5071258 1389  5071248 1389  5071234 1389  5071215 1389  5071200 1389  
327734 5071184 1390  5071170 1390  5071148 1389  5071134 1389  5071110 1389  5071088 1387  
327735 5071067 1389  5071041 1390  5071018 1390  5070990 1389  5070971 1389  5070947 1389  
327736 5070923 1389  5070900 1389  5070880 1389  5070855 1390  5070842 1389  5070818 1389  
327737 5070799 1389  5070778 1390  5070766 1389  5070747 1389  5070732 1389  5070721 1390  
327738 5070718 1389  5070697 1390  5070693 1390  5070683 1390  5070683 1390  5070680 1389  
327739 5070678 1390  5070680 1389  5070680 1389  5070685 1389  5070694 1389  5070697 1390  
327740 5070708 1389  5070717 1390  5070723 1389  5070740 1390  5070756 1389  5070775 1389  
327741 5070785 1389  5070798 1390  5070823 1389  5070847 1389  5070865 1390  5070885 1389  
327742 5070909 1389  5070922 1390  5070957 1389  5070970 1390  5070990 1389  5071008 1390  
327743 5071033 1389  5071056 1390  5071071 1389  5071084 1390  5071108 1390  5071117 1390  
327744 5071134 1389  5071148 1389  5071165 1390  5071170 1390  5071175 1390  5071186 1389  
327745 5071189 1390  5071189 1390  5071199 1390  5071199 1390  5071189 1390  5071191 1389  
327746 5071184 1390  5071184 1390  5071175 1390  5071170 1390  5071167 1389  5071148 1389  
327747 5071134 1389  5071119 1389  5071110 1389  5071086 1389  5071076 1389  5071068 1387  
327748 5071049 1387  5071033 1389  5071019 1389  5071000 1389  5070986 1389  5070973 1387  
327749 5070957 1389  5070942 1389  5070923 1389  5070920 1387  5070900 1389  5070895 1389  
327750 5070885 1389  5070880 1389  5070872 1387  5070872 1387  5070868 1387  5070866 1389  
327751 5070857 1389  5070866 1389  5070866 1389  5070866 1389  5070869 1390  5070880 1389  
327752 5070885 1389  5070895 1389  5070899 1389  5070909 1389  5070922 1390  5070933 1389  
327753 5070941 1390  5070955 1390  5070970 1390  5070984 1390  5070998 1390  5071019 1389  
327754 5071032 1390  5071047 1389  5071065 1390  5071075 1390  5071099 1390  5071108 1390  
327755 5071124 1389  5071141 1390  5071156 1390  5071170 1390  5071184 1390  5071189 1390  
327756 5071207 1392  5071215 1389  5071223 1390  5071223 1390  5071234 1389  5071232 1390  
327757 5071243 1389  5071243 1389  5071243 1389  5071234 1389  5071234 1389  5071224 1389  
327758 5071215 1389  5071215 1389  5071210 1389  5071191 1389  5071177 1389  5071173 1387  
327759 5071167 1389  5071149 1387  5071135 1387  5071111 1387  5071092 1387  5071078 1387  
327760 5071059 1387  5071044 1387  5071019 1389  5071000 1389  5070976 1389  5070968 1387  
327761 5070942 1389  5070923 1389  5070899 1389  5070885 1389  5070871 1389  5070847 1389  
327762 5070833 1389  5070818 1389  5070799 1389  5070785 1389  5070779 1390  5070766 1389  
327763 5070756 1389  5070747 1389  5070747 1389  5070732 1389  5070732 1389  5070732 1389  
327764 5070732 1389  5070732 1389  5070731 1390  5070742 1389  5070745 1390  5070745 1390  
327765 5070756 1389  5070775 1389  5070780 1389  5070785 1389  5070799 1389  5070819 1389  
327766 5070833 1389  5070847 1389  5070866 1389  5070880 1389  5070901 1387  5070919 1389  
327767 5070944 1387  5070957 1389  5070976 1389  5070990 1389  5071019 1389  5071032 1390  
327768 5071047 1389  5071070 1390  5071086 1389  5071100 1389  5071118 1390  5071134 1389  
327769 5071142 1390  5071146 1390  5071167 1389  5071170 1390  5071175 1390  5071176 1389  
327770 5071188 1387  5071186 1389  5071186 1389  5071186 1389  5071188 1387  5071184 1390  
327771 5071178 1387  5071173 1387  5071172 1389  5071158 1389  5071148 1389  5071134 1389  
327772 5071126 1387  5071110 1389  5071092 1387  5071076 1389  5071071 1389  5071059 1387  
327773 5071044 1387  5071025 1387  5071009 1389  5070992 1387  5070976 1389  5070968 1387  
327774 5070957 1389  5070944 1387  5070923 1389  5070919 1389  5070909 1389  5070899 1389  
327775 5070885 1389  5070882 1387  5070880 1389  5070871 1389  5070866 1389  5070868 1387  
327776 5070868 1387  5070866 1389  5070857 1389  5070866 1389  5070868 1387  5070872 1387  
327777 5070872 1387  5070880 1389  5070887 1387  5070887 1387  5070900 1389  5070911 1387  
327778 5070919 1389  5070925 1387  5070944 1387  5070947 1389  5070966 1389  5070973 1387  
327779 5070987 1387  5071001 1387  5071011 1387  5071025 1387  5071044 1387  5071057 1389  
327780 5071068 1387  5071078 1387  5071091 1389  5071110 1389  5071119 1389  5071134 1389  
327781 5071141 1390  5071148 1389  5071157 1389  5071165 1390  5071170 1390  5071176 1389  
327782 5071175 1390  5071186 1389  5071186 1389  5071186 1389  5071186 1389  5071175 1390  
327783 5071175 1390  5071175 1390  5071172 1389  5071166 1390  5071156 1390  5071148 1389  
327784 5071134 1389  5071124 1389  5071110 1389  5071091 1389  5071078 1387  5071067 1389  
327785 5071048 1389  5071033 1389  5071021 1387  5071000 1389  5070986 1389  5070968 1387  
327786 5070949 1387  5070933 1389  5070919 1389  5070900 1389  5070885 1389  5070872 1387  
327787 5070858 1387  5070842 1389  5070825 1387  5070818 1389  5070801 1387  5070795 1389  
327788 5070785 1389  5070780 1389  5070780 1389  5070775 1389  5070766 1389  5070766 1389  
327789 5070766 1389  5070766 1389  5070775 1389  5070775 1389  5070780 1389  5070778 1390  
327790 5070785 1389  5070799 1389  5070809 1389  5070819 1389  5070833 1389  5070847 1389  
327791 5070865 1390  5070880 1389  5070895 1389  5070907 1390  5070922 1390  5070946 1390  
327792 5070965 1390  5070974 1390  5070998 1390  5071022 1390  5071043 1389  5071057 1389  
327793 5071075 1390  5071089 1390  5071108 1390  5071123 1390  5071132 1390  5071146 1390  
327794 5071164 1392  5071170 1390  5071175 1390  5071185 1391  5071186 1389  5071191 1389  
327795 5071191 1389  5071199 1390  5071201 1389  5071199 1390  5071191 1389  5071191 1389  
327796 5071186 1389  5071175 1390  5071172 1389  5071166 1390  5071156 1390  5071141 1390  
327797 5071134 1389  5071118 1390  5071097 1392  5071084 1390  5071070 1390  5071056 1390  
327798 5071040 1392  5071022 1390  5071017 1390  5070997 1392  5070984 1390  5070970 1390  
327799 5070955 1390  5070941 1390  5070922 1390  5070908 1390  5070899 1389  5070885 1389  
327800 5070880 1389  5070871 1389  5070866 1389  5070857 1389  5070849 1387  5070844 1387  
327801 5070844 1387  5070834 1387  5070834 1387  5070836 1385  5070836 1385  5070844 1387  
327802 5070844 1387  5070844 1387  5070849 1387  5070860 1385  5070868 1387  5070872 1387  
327803 5070882 1387  5070888 1385  5070901 1387  5070911 1387  5070925 1387  5070942 1389  
327804 5070958 1387  5070973 1387  5070976 1389  5070990 1389  5071009 1389  5071024 1389  
327805 5071043 1389  5071057 1389  5071067 1389  5071075 1390  5071091 1389  5071099 1390  
327806 5071108 1390  5071124 1389  5071132 1390  5071141 1390  5071146 1390  5071156 1390  
327807 5071166 1390  5071166 1390  5071170 1391  5071170 1390  5071170 1390  5071175 1390  
327808 5071170 1390  5071170 1390  5071165 1390  5071157 1389  5071148 1389  5071143 1389  
327809 5071132 1390  5071124 1389  5071110 1389  5071100 1389  5071087 1387  5071071 1389  
327810 5071057 1389  5071044 1387  5071035 1387  5071012 1385  5070993 1385  5070977 1387  
327811 5070969 1385  5070945 1385  5070926 1385  5070912 1385  5070899 1383  5070885 1383  
327812 5070869 1385  5070852 1383  5070847 1383  5070828 1383  5070823 1383  5070815 1381  
327813 5070805 1381  5070805 1381  5070801 1381  5070791 1381  5070791 1381  5070791 1381  
327814 5070786 1381  5070791 1381  5070791 1381  5070801 1381  5070805 1381  5070805 1381  
327815 5070825 1381  5070829 1381  5070839 1381  5070853 1381  5070871 1383  5070885 1383  
327816 5070899 1383  5070912 1385  5070928 1383  5070951 1385  5070974 1385  5070989 1385  
327817 5071003 1385  5071027 1385  5071046 1385  5071059 1387  5071079 1385  5071092 1387  
327818 5071113 1385  5071127 1385  5071146 1385  5071159 1387  5071170 1385  5071179 1385  
327819 5071189 1385  5071194 1385  5071202 1387  5071204 1385  5071213 1385  5071211 1387  
327820 5071213 1385  5071211 1387  5071203 1385  5071203 1385  5071193 1387  5071189 1385  
327821 5071179 1385  5071175 1385  5071172 1383  5071151 1385  5071138 1383  5071124 1383  
327822 5071114 1383  5071095 1383  5071081 1383  5071062 1383  5071049 1381  5071028 1383  
327823 5071014 1383  5070992 1381  5070976 1383  5070962 1383  5070939 1381  5070925 1381  
327824 5070906 1381  5070891 1381  5070877 1381  5070863 1381  5070853 1381  5070839 1381  
327825 5070829 1381  5070815 1381  5070805 1381  5070801 1381  5070791 1381  5070786 1381  
327826 5070786 1381  5070782 1381  5070782 1381  5070782 1381  5070782 1381  5070782 1381  
327827 5070786 1381  5070786 1381  5070791 1381  5070801 1381  5070805 1381  5070815 1381  
327828 5070825 1381  5070839 1381  5070848 1381  5070863 1381  5070877 1381  5070891 1381  
327829 5070906 1381  5070925 1381  5070930 1381  5070953 1381  5070971 1383  5070982 1381  
327830 5070996 1381  5071015 1381  5071030 1381  5071047 1383  5071062 1383  5071071 1383  
327831 5071081 1383  5071095 1383  5071105 1383  5071113 1385  5071127 1385  5071137 1385  
327832 5071137 1385  5071145 1387  5071144 1387  5071151 1385  5071151 1385  5071151 1385  
327833 5071153 1383  5071148 1383  5071146 1385  5071137 1385  5071129 1383  5071124 1383  
327834 5071114 1383  5071094 1385  5071090 1383  5071076 1383  5071071 1383  5071052 1383  
327835 5071038 1383  5071024 1383  5071004 1383  5070990 1383  5070976 1383  5070962 1383  
327836 5070947 1383  5070928 1383  5070913 1383  5070899 1383  5070885 1383  5070869 1385  
327837 5070852 1383  5070837 1383  5070828 1383  5070823 1383  5070804 1383  5070804 1383  
327838 5070801 1381  5070790 1383  5070790 1383  5070791 1381  5070791 1381  5070791 1381  
327839 5070791 1381  5070801 1381  5070801 1381  5070805 1381  5070815 1381  5070829 1381  
327840 5070839 1381  5070852 1383  5070863 1381  5070887 1381  5070890 1383  5070915 1381  
327841 5070928 1383  5070948 1381  5070972 1381  5070980 1383  5071006 1381  5071024 1383  
327842 5071049 1381  5071062 1383  5071081 1383  5071095 1383  5071124 1383  5071137 1385  
327843 5071151 1385  5071170 1385  5071175 1385  5071180 1385  5071194 1385  5071203 1385  
327844 5071213 1385  5071218 1385  5071218 1385  5071228 1385  5071227 1385  5071227 1385  
327845 5071229 1383  5071219 1383  5071219 1383  5071219 1383  5071205 1383  5071195 1383  
327846 5071192 1381  5071178 1381  5071163 1381  5071154 1381  5071138 1383  5071125 1381  
327847 5071106 1381  5071082 1381  5071073 1381  5071052 1383  5071038 1383  5071014 1383  
327848 5070995 1383  5070977 1381  5070952 1383  5070937 1383  5070915 1381  5070890 1383  
327849 5070875 1383  5070861 1383  5070847 1383  5070828 1383  5070813 1383  5070804 1383  
327850 5070791 1381  5070785 1383  5070770 1383  5070761 1383  5070751 1383  5070751 1383  
327851 5070746 1383  5070746 1383  5070746 1383  5070746 1383  5070746 1383  5070751 1383  
327852 5070761 1383  5070772 1381  5070780 1383  5070786 1381  5070801 1381  5070805 1381  
327853 5070825 1381  5070839 1381  5070848 1381  5070863 1381  5070875 1383  5070899 1383  
327854 5070915 1381  5070928 1383  5070954 1381  5070971 1383  5070990 1383  5071014 1383  
327855 5071028 1383  5071049 1381  5071062 1383  5071079 1385  5071095 1383  5071116 1381  
327856 5071124 1383  5071136 1385  5071151 1385  5071160 1385  5071170 1385  5071176 1383  
327857 5071181 1383  5071181 1383  5071181 1383  5071189 1385  5071191 1383  5071191 1383  
327858 5071191 1383  5071181 1383  5071176 1383  5071173 1381  5071162 1383  5071152 1383  
327859 5071147 1383  5071130 1381  5071114 1383  5071095 1383  5071081 1383  5071073 1381  
327860 5071052 1383  5071038 1383  5071024 1383  5071003 1385  5070990 1383  5070971 1383  
327861 5070952 1383  5070939 1381  5070923 1383  5070904 1383  5070890 1383  5070885 1383  
327862 5070869 1385  5070861 1383  5070846 1383  5070837 1383  5070837 1383  5070825 1381  
327863 5070823 1383  5070823 1383  5070823 1383  5070823 1383  5070823 1383  5070828 1383  
327864 5070829 1381  5070847 1383  5070852 1383  5070861 1383  5070875 1383  5070885 1383  
327865 5070899 1383  5070913 1383  5070928 1383  5070945 1385  5070961 1383  5070980 1383  
327866 5070993 1385  5071014 1383  5071036 1385  5071050 1385  5071076 1383  5071089 1385  
327867 5071113 1385  5071127 1385  5071146 1385  5071159 1387  5071173 1387  5071192 1387  
327868 5071200 1389  5071216 1387  5071226 1387  5071234 1389  5071243 1389  5071248 1389  
327869 5071258 1389  5071258 1389  5071258 1389  5071256 1390  5071256 1390  5071247 1390  
327870 5071248 1389  5071242 1390  5071234 1389  5071223 1390  5071213 1390  5071200 1389  
327871 5071186 1389  5071170 1390  5071157 1388  5071143 1389  5071119 1389  5071091 1389  
327872 5071078 1387  5071059 1387  5071035 1387  5071009 1389  5070990 1389  5070973 1387  
327873 5070947 1389  5070925 1387  5070901 1387  5070880 1389  5070858 1387  5070844 1387  
327874 5070820 1387  5070801 1387  5070780 1389  5070767 1387  5070758 1387  5070743 1387  
327875 5070724 1387  5070720 1387  5070711 1385  5070699 1389  5070699 1389  5070699 1389  
327876 5070694 1389  5070696 1387  5070700 1387  5070700 1387  5070708 1389  5070718 1388  
327877 5070723 1389  5070734 1387  5070742 1389  5070756 1389  5070777 1387  5070785 1389  
327878 5070799 1389  5070818 1388  5070831 1390  5070855 1390  5070871 1389  5070895 1389  
327879 5070917 1390  5070931 1390  5070955 1390  5070974 1390  5070998 1390  5071019 1388  
327880 5071041 1390  5071054 1392  5071073 1392  5071089 1390  5071106 1392  5071123 1390  
327881 5071141 1390  5071146 1390  5071164 1392  5071169 1392  5071173 1392  5071184 1390  
327882 5071184 1390  5071184 1390  5071189 1390  5071184 1390  5071184 1390  5071184 1390  
327883 5071175 1390  5071172 1389  5071167 1389  5071157 1388  5071141 1390  5071124 1389  
327884 5071108 1390  5071089 1390  5071075 1390  5071066 1388  5071047 1389  5071032 1390  
327885 5071008 1390  5070987 1392  5070974 1390  5070955 1390  5070942 1389  5070922 1390  
327886 5070907 1390  5070884 1390  5070869 1390  5070864 1390  5070845 1390  5070840 1390  
327887 5070821 1390  5070818 1389  5070810 1387  5070809 1389  5070799 1389  5070794 1388  
327888 5070796 1387  5070796 1387  5070801 1387  5070799 1389  5070810 1387  5070818 1389  
327889 5070823 1388  5070844 1387  5070849 1387  5070866 1389  5070885 1389  5070895 1389  
327890 5070919 1389  5070933 1389  5070942 1389  5070965 1390  5070984 1390  5070998 1390  
327891 5071022 1390  5071040 1392  5071065 1390  5071073 1392  5071097 1392  5071116 1392  
327892 5071140 1392  5071156 1390  5071170 1390  5071183 1392  5071197 1392  5071207 1392  
327893 5071221 1392  5071229 1394  5071242 1390  5071246 1390  5071255 1392  5071255 1392  
327894 5071256 1390  5071256 1390  5071256 1390  5071245 1392  5071246 1390  5071242 1390  
327895 5071232 1390  5071213 1390  5071208 1390  5071188 1392  5071176 1389  5071165 1390  
327896 5071143 1389  5071123 1390  5071098 1390  5071075 1390  5071056 1390  5071033 1389  
327897 5071009 1389  5070987 1387  5070966 1389  5070933 1389  5070909 1389  5070885 1389  
327898 5070866 1389  5070842 1389  5070818 1389  5070794 1389  5070775 1389  5070746 1389  
327899 5070734 1387  5070708 1389  5070696 1387  5070686 1387  5070676 1387  5070667 1387  
327900 5070658 1387  5070654 1385  5070644 1385  5070643 1387  5070643 1387  5070643 1387  
327901 5070643 1387  5070653 1387  5070657 1387  5070657 1387  5070676 1387  5070681 1387  
327902 5070696 1387  5070710 1387  5070724 1387  5070743 1387  5070759 1385  5070782 1387  
327903 5070801 1387  5070820 1387  5070845 1385  5070868 1387  5070887 1387  5070911 1387  
327904 5070933 1389  5070958 1387  5070977 1387  5071001 1387  5071024 1388  5071047 1389  
327905 5071067 1389  5071086 1389  5071100 1389  5071119 1389  5071141 1390  5071148 1388  
327906 5071165 1390  5071170 1390  5071175 1390  5071186 1389  5071189 1390  5071191 1389  
327907 5071199 1390  5071189 1390  5071189 1390  5071189 1390  5071184 1390  5071175 1390  
327908 5071165 1390  5071156 1390  5071146 1390  5071132 1390  5071119 1389  5071100 1389  
327909 5071086 1389  5071070 1390  5071046 1390  5071033 1389  5071017 1390  5070998 1390  
327910 5070976 1389  5070965 1390  5070945 1390  5070931 1390  5070907 1390  5070895 1389  
327911 5070879 1390  5070869 1390  5070856 1389  5070845 1390  5070831 1390  5070822 1390  
327912 5070817 1390  5070818 1389  5070807 1390  5070807 1390  5070807 1390  5070807 1390  
327913 5070809 1389  5070817 1390  5070822 1390  5070831 1390  5070840 1390  5070856 1389  
327914 5070871 1389  5070879 1390  5070893 1390  5070907 1390  5070922 1390  5070941 1390  
327915 5070965 1390  5070974 1390  5070998 1390  5071017 1390  5071043 1389  5071057 1389  
327916 5071075 1390  5071099 1390  5071117 1390  5071141 1390  5071164 1392  5071175 1390  
327917 5071189 1390  5071208 1390  5071223 1390  5071242 1390  5071255 1392  5071264 1392  
327918 5071269 1392  5071285 1390  5071283 1392  5071290 1390  5071286 1394  5071288 1392  
327919 5071288 1392  5071283 1392  5071274 1392  5071269 1392  5071266 1390  5071245 1392  
327920 5071231 1392  5071213 1390  5071199 1390  5071175 1390  5071154 1392  5071132 1390  
327921 5071106 1392  5071084 1390  5071065 1390  5071032 1390  5071008 1390  5070974 1390  
327922 5070955 1390  5070931 1390  5070898 1390  5070877 1392  5070845 1390  5070822 1390  
327923 5070798 1390  5070778 1390  5070755 1390  5070729 1392  5070707 1390  5070691 1392  
327924 5070678 1390  5070662 1392  5070648 1392  5070638 1392  5070621 1390  5070616 1390  
327925 5070616 1390  5070606 1390  5070605 1392  5070606 1390  5070615 1392  5070619 1392  
327926 5070619 1392  5070638 1392  5070648 1392  5070653 1392  5070670 1394  5070683 1390  
327927 5070705 1392  5070721 1390  5070740 1390  5070764 1390  5070783 1390  5070807 1390  
327928 5070841 1390  5070855 1390  5070884 1390  5070906 1392  5070931 1390  5070965 1390  
327929 5070982 1392  5071008 1390  5071032 1390  5071056 1390  5071074 1390  5071089 1390  
327930 5071106 1392  5071132 1390  5071146 1390  5071164 1392  5071170 1390  5071175 1390  
327931 5071184 1390  5071189 1390  5071197 1392  5071199 1390  5071200 1389  5071199 1390  
327932 5071200 1389  5071189 1390  5071184 1390  5071176 1389  5071170 1390  5071167 1389  
327933 5071146 1390  5071132 1390  5071119 1389  5071100 1389  5071084 1390  5071071 1389  
327934 5071047 1389  5071033 1389  5071017 1390  5070990 1388  5070976 1389  5070965 1390  
327935 5070942 1389  5070923 1389  5070909 1389  5070895 1389  5070880 1389  5070864 1390  
327936 5070847 1389  5070841 1390  5070831 1390  5070822 1390  5070817 1390  5070817 1390  
327937 5070807 1390  5070807 1390  5070807 1390  5070807 1390  5070817 1390  5070817 1390  
327938 5070822 1390  5070842 1389  5070845 1390  5070864 1390  5070869 1390  5070884 1390  
327939 5070900 1389  5070917 1390  5070941 1390  5070957 1389  5070969 1390  5070989 1390  
327940 5071017 1390  5071033 1389  5071056 1390  5071075 1390  5071091 1389  5071119 1389  
327941 5071143 1389  5071156 1390  5071175 1390  5071189 1390  5071213 1390  5071234 1389  
327942 5071246 1390  5071264 1392  5071270 1390  5071285 1390  5071288 1392  5071299 1390  
327943 5071299 1390  5071301 1389  5071299 1390  5071301 1389  5071301 1389  5071291 1388  
327944 5071286 1389  5071270 1390  5071267 1389  5071248 1389  5071234 1388  5071213 1390  
327945 5071191 1388  5071172 1389  5071146 1390  5071124 1389  5071099 1390  5071070 1390  
327946 5071043 1389  5071019 1388  5070984 1390  5070955 1390  5070922 1390  5070893 1390  
327947 5070869 1390  5070840 1390  5070807 1390  5070783 1390  5070755 1390  5070721 1390  
327948 5070699 1389  5070678 1390  5070654 1390  5070640 1390  5070619 1392  5070606 1390  
327949 5070592 1390  5070583 1390  5070578 1390  5070573 1390  5070564 1390  5070554 1390  
327950 5070554 1390  5070554 1390  5070564 1390  5070573 1390  5070578 1390  5070592 1390  
327951 5070597 1390  5070616 1390  5070630 1390  5070654 1390  5070673 1390  5070693 1390  
327952 5070716 1390  5070742 1389  5070764 1390  5070785 1389  5070807 1390  5070832 1388  
327953 5070864 1390  5070884 1390  5070917 1390  5070941 1390  5070965 1390  5070989 1390  
327954 5071017 1390  5071041 1390  5071056 1390  5071076 1389  5071098 1390  5071117 1390  
327955 5071132 1390  5071146 1390  5071157 1388  5071165 1390  5071170 1390  5071175 1390  
327956 5071184 1390  5071184 1390  5071186 1388  5071184 1390  5071184 1390  5071175 1390  
327957 5071170 1390  5071165 1390  5071156 1390  5071141 1390  5071132 1390  5071108 1390  
327958 5071089 1390  5071074 1390  5071065 1390  5071043 1388  5071022 1390  5070998 1390  
327959 5070986 1389  5070969 1390  5070947 1388  5070933 1388  5070907 1390  5070893 1390  
327960 5070869 1390  5070855 1390  5070845 1390  5070831 1390  5070817 1390  5070807 1390  
327961 5070798 1390  5070793 1390  5070782 1392  5070782 1392  5070782 1392  5070783 1390  
327962 5070782 1392  5070793 1390  5070793 1390  5070797 1390  5070807 1390  5070817 1390  
327963 5070831 1390  5070840 1390  5070855 1390  5070869 1390  5070884 1390  5070909 1388  
327964 5070922 1390  5070944 1392  5070971 1389  5070984 1390  5071008 1390  5071033 1388  
327965 5071056 1390  5071074 1390  5071100 1389  5071122 1390  5071146 1390  5071170 1390  
327966 5071189 1390  5071208 1390  5071232 1390  5071246 1390  5071266 1390  5071275 1390  
327967 5071285 1390  5071290 1390  5071309 1390  5071312 1392  5071313 1390  5071313 1390  
327968 5071313 1390  5071313 1390  5071307 1392  5071299 1390  5071290 1390  5071283 1392  
327969 5071269 1392  5071255 1392  5071240 1392  5071221 1392  5071197 1392  5071168 1392  
327970 5071145 1392  5071119 1394  5071086 1394  5071064 1392  5071030 1392  5071006 1392  
327971 5070966 1394  5070939 1392  5070906 1392  5070880 1394  5070853 1392  5070820 1392  
327972 5070791 1392  5070763 1392  5070740 1390  5070705 1392  5070681 1392  5070662 1392  
327973 5070638 1392  5070613 1394  5070595 1392  5070581 1392  5070572 1392  5070560 1394  
327974 5070551 1394  5070548 1392  5070548 1392  5070546 1394  5070546 1394  5070546 1394  
327975 5070551 1394  5070561 1394  5070570 1394  5070581 1392  5070591 1392  5070613 1394  
327976 5070627 1394  5070647 1394  5070670 1394  5070691 1392  5070705 1392  5070739 1392  
327977 5070763 1392  5070782 1392  5070815 1392  5070839 1392  5070868 1392  5070893 1390  
327978 5070917 1390  5070944 1392  5070968 1392  5070987 1392  5071021 1392  5071041 1390  
327979 5071065 1390  5071084 1390  5071099 1390  5071123 1390  5071132 1390  5071146 1390  
327980 5071165 1390  5071170 1390  5071175 1390  5071184 1390  5071189 1390  5071189 1390  
327981 5071189 1390  5071189 1390  5071191 1389  5071184 1390  5071176 1389  5071172 1389  
327982 5071165 1390  5071146 1390  5071133 1389  5071117 1390  5071100 1388  5071084 1390  
327983 5071071 1389  5071056 1390  5071032 1390  5071019 1389  5070990 1389  5070974 1390  
327984 5070955 1390  5070941 1390  5070917 1390  5070898 1390  5070884 1390  5070869 1390  
327985 5070857 1389  5070845 1390  5070831 1390  5070821 1390  5070817 1390  5070807 1390  
327986 5070798 1390  5070798 1390  5070793 1390  5070791 1392  5070791 1392  5070796 1392  
327987 5070804 1394  5070806 1392  5070813 1394  5070828 1394  5070844 1392  5070853 1392  
327988 5070868 1392  5070882 1392  5070896 1392  5070920 1392  5070939 1392  5070965 1390  
327989 5070984 1390  5071000 1389  5071022 1390  5071046 1390  5071074 1390  5071089 1390  
327990 5071119 1388  5071141 1390  5071165 1390  5071186 1389  5071210 1388  5071232 1390  
327991 5071248 1388  5071266 1390  5071278 1387  5071290 1390  5071299 1390  5071315 1389  
327992 5071325 1389  5071334 1389  5071334 1388  5071334 1388  5071334 1388  5071332 1390  
327993 5071325 1388  5071313 1390  5071310 1388  5071291 1388  5071275 1390  5071267 1388  
327994 5071243 1388  5071214 1389  5071199 1390  5071172 1388  5071148 1388  5071119 1388  
327995 5071084 1390  5071056 1390  5071024 1389  5070989 1390  5070966 1388  5070931 1390  
327996 5070895 1389  5070866 1388  5070831 1390  5070798 1390  5070774 1390  5070740 1390  
327997 5070717 1390  5070685 1389  5070664 1390  5070641 1388  5070618 1389  5070594 1389  
327998 5070580 1389  5070573 1390  5070556 1389  5070549 1390  5070539 1390  5070530 1390  
327999 5070522 1389  5070521 1390  5070521 1390  5070530 1390  5070541 1388  5070541 1389  
328000 5070556 1389  5070565 1389  5070584 1389  5070594 1389  5070608 1388  5070630 1390  
328001 5070656 1389  5070675 1388  5070699 1389  5070723 1388  5070746 1388  5070780 1389  
328002 5070801 1387  5070832 1388  5070857 1389  5070885 1388  5070909 1389  5070942 1388  
328003 5070966 1389  5070984 1390  5071009 1389  5071033 1389  5071057 1389  5071074 1390  
328004 5071091 1389  5071109 1388  5071124 1388  5071143 1388  5071148 1388  5071156 1390  
328005 5071167 1389  5071170 1390  5071175 1390  5071176 1389  5071175 1390  5071176 1388  
328006 5071170 1390  5071165 1390  5071156 1390  5071148 1388  5071141 1390  5071133 1389  
328007 5071117 1390  5071098 1390  5071086 1389  5071070 1390  5071047 1388  5071032 1390  
328008 5071009 1388  5070986 1389  5070969 1390  5070955 1390  5070931 1390  5070917 1390  
328009 5070898 1390  5070885 1388  5070871 1389  5070845 1390  5070840 1390  5070822 1390  
328010 5070817 1390  5070798 1390  5070793 1390  5070783 1390  5070778 1390  5070777 1392  
328011 5070774 1390  5070774 1390  5070774 1390  5070774 1390  5070778 1390  5070783 1390  
328012 5070793 1390  5070798 1390  5070817 1390  5070831 1390  5070845 1390  5070864 1390  
328013 5070879 1390  5070898 1390  5070917 1390  5070941 1390  5070965 1390  5070974 1390  
328014 5070998 1390  5071032 1390  5071056 1390  5071075 1390  5071100 1389  5071123 1390  
328015 5071148 1389  5071170 1390  5071189 1390  5071211 1392  5071232 1390  5071256 1390  
328016 5071270 1390  5071285 1390  5071290 1390  5071309 1390  5071312 1392  5071322 1392  
328017 5071323 1390  5071322 1392  5071322 1392  5071312 1392  5071307 1392  5071298 1392  
328018 5071288 1392  5071274 1392  5071266 1390  5071242 1390  5071221 1392  5071199 1390  
328019 5071176 1388  5071146 1390  5071122 1390  5071089 1390  5071067 1389  5071041 1390  
328020 5071009 1389  5070974 1390  5070946 1390  5070917 1390  5070884 1390  5070856 1389  
328021 5070822 1390  5070793 1390  5070764 1390  5070740 1390  5070707 1390  5070676 1392  
328022 5070654 1390  5070630 1390  5070616 1390  5070592 1390  5070578 1390  5070572 1392  
328023 5070554 1390  5070549 1390  5070538 1392  5070530 1390  5070529 1392  5070529 1392  
328024 5070530 1390  5070530 1390  5070540 1390  5070549 1390  5070564 1390  5070573 1390  
328025 5070581 1392  5070606 1390  5070621 1390  5070638 1392  5070664 1390  5070678 1390  
328026 5070707 1390  5070731 1390  5070755 1390  5070778 1390  5070807 1390  5070831 1390  
328027 5070864 1390  5070884 1390  5070917 1390  5070941 1390  5070970 1390  5070989 1390  
328028 5071016 1392  5071041 1390  5071065 1390  5071084 1390  5071108 1390  5071123 1390  
328029 5071141 1390  5071156 1390  5071165 1390  5071173 1392  5071184 1390  5071188 1392  
328030 5071199 1390  5071197 1392  5071197 1392  5071197 1392  5071188 1392  5071189 1390  
328031 5071184 1390  5071175 1390  5071164 1392  5071156 1390  5071141 1390  5071132 1390  
328032 5071108 1390  5071088 1392  5071075 1390  5071064 1392  5071041 1390  5071022 1390  
328033 5071009 1389  5070984 1390  5070970 1390  5070957 1389  5070942 1389  5070919 1389  
328034 5070898 1390  5070885 1389  5070869 1390  5070866 1388  5070847 1389  5070833 1389  
328035 5070823 1389  5070818 1389  5070808 1388  5070809 1389  5070798 1390  5070798 1390  
328036 5070798 1390  5070807 1390  5070807 1390  5070818 1389  5070821 1390  5070831 1390  
328037 5070844 1392  5070864 1390  5070879 1390  5070898 1390  5070917 1390  5070941 1390  
328038 5070954 1392  5070974 1390  5070998 1390  5071022 1390  5071044 1392  5071070 1390  
328039 5071089 1390  5071117 1390  5071143 1389  5071165 1390  5071184 1390  5071208 1390  
328040 5071234 1389  5071255 1392  5071269 1392  5071290 1390  5071309 1390  5071313 1390  
328041 5071333 1390  5071337 1390  5071348 1389  5071357 1390  5071357 1390  5071358 1389  
328042 5071358 1389  5071350 1387  5071339 1389  5071334 1389  5071325 1388  5071310 1389  
328043 5071291 1388  5071273 1387  5071259 1387  5071234 1388  5071211 1387  5071188 1387  
328044 5071168 1387  5071133 1388  5071100 1388  5071078 1387  5071047 1389  5071021 1387  
328045 5070986 1389  5070957 1389  5070923 1389  5070893 1390  5070866 1389  5070833 1389  
328046 5070809 1389  5070780 1389  5070756 1389  5070723 1389  5070697 1390  5070679 1388  
328047 5070664 1390  5070641 1388  5070623 1389  5070606 1390  5070598 1389  5070594 1389  
328048 5070583 1390  5070578 1390  5070574 1388  5070573 1390  5070574 1388  5070579 1388  
328049 5070584 1388  5070594 1389  5070608 1388  5070618 1388  5070632 1388  5070641 1389  
328050 5070665 1388  5070679 1388  5070694 1388  5070718 1388  5070742 1388  5070764 1390  
328051 5070785 1388  5070808 1388  5070832 1388  5070855 1390  5070885 1388  5070909 1388  
328052 5070933 1389  5070957 1388  5070985 1388  5071009 1388  5071033 1388  5071057 1388  
328053 5071076 1388  5071098 1390  5071119 1388  5071133 1388  5071146 1390  5071167 1388  
328054 5071170 1390  5071175 1390  5071189 1390  5071200 1388  5071200 1388  5071210 1388  
328055 5071210 1388  5071210 1388  5071200 1388  5071200 1388  5071192 1387  5071186 1388  
328056 5071178 1387  5071167 1388  5071157 1388  5071144 1387  5071124 1388  5071111 1387  
328057 5071090 1388  5071076 1388  5071068 1387  5071044 1387  5071019 1388  5071000 1389  
328058 5070986 1389  5070972 1387  5070957 1388  5070933 1388  5070919 1388  5070901 1387  
328059 5070882 1387  5070871 1388  5070856 1388  5070843 1387  5070832 1388  5070823 1388  
328060 5070823 1388  5070818 1388  5070818 1388  5070817 1390  5070808 1388  5070818 1388  
328061 5070818 1388  5070823 1388  5070831 1390  5070842 1388  5070855 1390  5070866 1388  
328062 5070879 1390  5070898 1390  5070919 1388  5070933 1388  5070957 1388  5070969 1390  
328063 5070990 1388  5071019 1388  5071031 1390  5071056 1390  5071074 1390  5071100 1388  
328064 5071122 1390  5071146 1390  5071172 1388  5071191 1388  5071213 1390  5071243 1388  
328065 5071256 1390  5071272 1388  5071286 1389  5071301 1388  5071310 1388  5071315 1388  
328066 5071326 1387  5071334 1388  5071334 1389  5071334 1389  5071334 1388  5071334 1388  
328067 5071326 1387  5071315 1389  5071312 1387  5071302 1387  5071288 1387  5071273 1387  
328068 5071258 1388  5071234 1388  5071214 1388  5071191 1388  5071172 1388  5071148 1388  
328069 5071117 1390  5071089 1390  5071066 1388  5071044 1387  5071010 1387  5070977 1387  
328070 5070950 1385  5070922 1385  5070888 1385  5070859 1385  5070836 1385  5070804 1383  
328071 5070785 1383  5070759 1385  5070735 1385  5070711 1385  5070698 1383  5070683 1385  
328072 5070670 1383  5070654 1385  5070646 1383  5070627 1383  5070621 1385  5070613 1383  
328073 5070613 1383  5070603 1383  5070601 1385  5070601 1385  5070609 1387  5070621 1385  
328074 5070625 1385  5070636 1383  5070656 1383  5070659 1385  5070678 1385  5070689 1383  
328075 5070702 1385  5070726 1385  5070745 1385  5070769 1385  5070788 1385  5070811 1385  
328076 5070837 1383  5070859 1385  5070883 1385  5070902 1385  5070936 1385  5070961 1383  
328077 5070979 1385  5071012 1385  5071036 1385  5071060 1385  5071074 1385  5071094 1385  
328078 5071112 1385  5071127 1385  5071147 1383  5071160 1385  5071175 1385  5071181 1383  
328079 5071189 1385  5071203 1385  5071213 1385  5071213 1385  5071213 1385  5071219 1383  
328080 5071213 1385  5071214 1383  5071203 1385  5071205 1383  5071195 1383  5071189 1385  
328081 5071175 1385  5071171 1383  5071151 1385  5071136 1385  5071122 1385  5071103 1385  
328082 5071090 1383  5071074 1385  5071060 1385  5071036 1385  5071022 1385  5070993 1385  
328083 5070979 1385  5070960 1385  5070945 1385  5070926 1385  5070912 1385  5070898 1385  
328084 5070883 1385  5070874 1385  5070859 1385  5070850 1385  5070843 1387  5070845 1385  
328085 5070835 1385  5070826 1385  5070826 1385  5070826 1385  5070835 1385  5070835 1385  
328086 5070846 1383  5070852 1383  5070861 1383  5070870 1383  5070883 1385  5070898 1385  
328087 5070912 1385  5070926 1385  5070947 1383  5070958 1387  5070979 1385  5070993 1385  
328088 5071022 1385  5071044 1387  5071070 1385  5071079 1385  5071103 1385  5071136 1385  
328089 5071151 1385  5071173 1387  5071192 1387  5071216 1387  5071237 1385  5071249 1387  
328090 5071269 1387  5071279 1385  5071294 1385  5071303 1385  5071313 1385  5071318 1385  
328091 5071318 1385  5071328 1385  5071328 1385  5071329 1383  5071328 1385  5071318 1385  
328092 5071313 1385  5071304 1385  5071294 1385  5071281 1383  5071270 1385  5071252 1383  
328093 5071238 1383  5071214 1383  5071191 1383  5071171 1383  5071136 1385  5071112 1385  
328094 5071089 1385  5071071 1383  5071036 1385  5071012 1385  5070979 1385  5070960 1385  
328095 5070928 1383  5070904 1383  5070885 1383  5070852 1383  5070826 1385  5070802 1385  
328096 5070785 1383  5070759 1385  5070746 1383  5070724 1387  5070709 1387  5070697 1385  
328097 5070681 1387  5070676 1387  5070659 1385  5070654 1385  5070653 1387  5070643 1387  
328098 5070643 1387  5070643 1387  5070644 1385  5070652 1387  5070653 1387  5070657 1387  
328099 5070667 1387  5070681 1387  5070686 1387  5070699 1388  5070710 1387  5070735 1385  
328100 5070750 1385  5070767 1387  5070786 1387  5070811 1385  5070834 1387  5070848 1387  
328101 5070874 1385  5070901 1387  5070926 1385  5070948 1387  5070972 1387  5070992 1387  
328102 5071020 1387  5071045 1385  5071059 1387  5071079 1385  5071101 1387  5071122 1385  
328103 5071136 1385  5071149 1387  5071170 1385  5071175 1385  5071189 1385  5071194 1385  
328104 5071203 1385  5071211 1387  5071213 1385  5071217 1385  5071216 1387  5071217 1385  
328105 5071217 1385  5071213 1385  5071202 1387  5071202 1387  5071187 1387  5071178 1387  
328106 5071170 1385  5071149 1387  5071135 1387  5071122 1385  5071101 1387  5071087 1387  
328107 5071074 1385  5071050 1385  5071036 1385  5071010 1387  5070993 1385  5070972 1387  
328108 5070958 1387  5070944 1387  5070921 1385  5070901 1387  5070887 1387  5070872 1387  
328109 5070869 1385  5070848 1387  5070845 1385  5070834 1387  5070824 1387  5070820 1387  
328110 5070820 1387  5070811 1385  5070811 1385  5070821 1385  5070820 1387  5070826 1385  
328111 5070826 1385  5070845 1385  5070850 1385  5070859 1385  5070874 1385  5070888 1385  
328112 5070904 1383  5070922 1385  5070937 1383  5070950 1385  5070974 1385  5070990 1383  
328113 5071014 1383  5071036 1385  5071061 1383  5071074 1385  5071093 1385  5071124 1383  
328114 5071136 1385  5071160 1385  5071174 1385  5071194 1385  5071214 1383  5071229 1383  
328115 5071248 1383  5071251 1385  5071272 1383  5071276 1383  5071279 1385  5071289 1385  
328116 5071296 1383  5071296 1383  5071303 1385  5071296 1383  5071296 1383  5071291 1383  
328117 5071291 1383  5071276 1383  5071270 1385  5071251 1385  5071238 1383  5071219 1383  
328118 5071205 1383  5071181 1383  5071173 1381  5071146 1385  5071124 1383  5071095 1383  
328119 5071080 1383  5071052 1383  5071028 1383  5071004 1383  5070980 1383  5070963 1381  
328120 5070937 1383  5070904 1383  5070885 1383  5070861 1383  5070839 1381  5070823 1383  
328121 5070799 1383  5070780 1383  5070762 1381  5070746 1383  5070729 1381  5070713 1383  
328122 5070703 1383  5070689 1383  5070684 1383  5070684 1383  5070679 1383  5070679 1383  
328123 5070679 1383  5070679 1383  5070678 1385  5070684 1383  5070689 1383  5070699 1383  
328124 5070705 1381  5070724 1381  5070729 1381  5070748 1381  5070770 1383  5070785 1383  
328125 5070799 1383  5070823 1383  5070837 1383  5070861 1383  5070887 1381  5070902 1385  
328126 5070928 1383  5070952 1383  5070975 1383  5070995 1383  5071022 1385  5071047 1383  
328127 5071071 1383  5071082 1381  5071104 1383  5071124 1383  5071147 1383  5071162 1383  
328128 5071173 1381  5071181 1383  5071197 1381  5071214 1383  5071217 1385  5071229 1383  
328129 5071229 1383  5071238 1383  5071238 1383  5071238 1383  5071238 1383  5071240 1381  
328130 5071230 1381  5071229 1383  5071221 1381  5071216 1381  5071195 1383  5071181 1383  
328131 5071171 1383  5071152 1383  5071147 1383  5071125 1381  5071106 1381  5071082 1381  
328132 5071071 1383  5071054 1381  5071030 1381  5071014 1383  5070991 1381  5070977 1381  
328133 5070953 1381  5070937 1383  5070915 1381  5070901 1381  5070890 1383  5070877 1381  
328134 5070862 1381  5070848 1381  5070837 1383  5070829 1381  5070823 1383  5070814 1381  
328135 5070803 1383  5070805 1381  5070803 1383  5070804 1383  5070803 1383  5070803 1383  
328136 5070813 1383  5070824 1381  5070829 1381  5070837 1383  5070851 1383  5070862 1381  
328137 5070875 1383  5070890 1383  5070904 1383  5070923 1383  5070948 1381  5070961 1383  
328138 5070980 1383  5070996 1381  5071025 1381  5071047 1383  5071071 1383  5071080 1383  
328139 5071104 1383  5071125 1381  5071147 1383  5071163 1381  5071181 1383  5071197 1381  
328140 5071213 1385  5071219 1383  5071238 1383  5071248 1383  5071252 1383  5071262 1383  
328141 5071272 1383  5071272 1383  5071272 1383  5071272 1383  5071270 1385  5071270 1385  
328142 5071262 1383  5071251 1385  5071246 1385  5071238 1383  5071219 1383  5071206 1381  
328143 5071191 1383  5071178 1381  5071152 1383  5071139 1381  5071115 1381  5071092 1381  
328144 5071073 1381  5071054 1381  5071030 1381  5071006 1381  5070982 1381  5070963 1381  
328145 5070939 1381  5070915 1381  5070891 1381  5070877 1381  5070853 1381  5070827 1383  
328146 5070805 1381  5070789 1383  5070781 1381  5070761 1383  5070746 1383  5070738 1381  
328147 5070724 1381  5070713 1383  5070705 1381  5070699 1383  5070700 1381  5070700 1381  
328148 5070700 1381  5070699 1383  5070699 1383  5070703 1383  5070713 1383  5070723 1383  
328149 5070727 1383  5070748 1381  5070751 1383  5070770 1383  5070785 1383  5070799 1383  
328150 5070813 1383  5070837 1383  5070861 1383  5070875 1383  5070899 1383  5070925 1381  
328151 5070947 1383  5070971 1383  5070990 1383  5071014 1383  5071038 1383  5071061 1383  
328152 5071082 1381  5071095 1383  5071124 1383  5071136 1385  5071162 1383  5071176 1383  
328153 5071191 1383  5071205 1383  5071213 1385  5071217 1385  5071227 1385  5071237 1385  
328154 5071246 1385  5071246 1385  5071251 1385  5071248 1383  5071246 1385  5071237 1385  
328155 5071230 1381  5071219 1383  5071214 1383  5071195 1383  5071191 1383  5071176 1383  
328156 5071162 1383  5071138 1383  5071124 1383  5071106 1381  5071082 1381  5071062 1383  
328157 5071049 1381  5071023 1383  5070996 1381  5070977 1381  5070961 1383  5070937 1383  
328158 5070915 1381  5070890 1383  5070874 1385  5070852 1383  5070837 1383  5070823 1383  
328159 5070803 1383  5070800 1381  5070785 1383  5070781 1381  5070772 1381  5070761 1383  
328160 5070751 1383  5070753 1381  5070746 1383  5070746 1383  5070751 1383  5070751 1383  
328161 5070753 1381  5070761 1383  5070769 1385  5070778 1385  5070789 1383  5070799 1383  
328162 5070813 1383  5070827 1383  5070846 1383  5070861 1383  5070875 1383  5070899 1383  
328163 5070913 1383  5070937 1383  5070952 1383  5070974 1385  5070995 1383  5071012 1385  
328164 5071036 1385  5071062 1383  5071080 1383  5071095 1383  5071122 1385  5071136 1385  
328165 5071151 1385  5071170 1385  5071179 1385  5071189 1385  5071203 1385  5071213 1385  
328166 5071219 1383  5071229 1383  5071237 1385  5071237 1385  5071237 1385  5071238 1383  
328167 5071238 1383  5071229 1383  5071221 1381  5071219 1383  5071205 1383  5071197 1381  
328168 5071181 1383  5071173 1381  5071154 1381  5071138 1383  5071114 1383  5071090 1383  
328169 5071077 1381  5071054 1381  5071038 1383  5071014 1383  5070991 1381  5070971 1383  
328170 5070947 1383  5070928 1383  5070905 1381  5070890 1383  5070872 1381  5070846 1383  
328171 5070829 1381  5070813 1383  5070789 1383  5070784 1383  5070770 1383  5070751 1383  
328172 5070746 1383  5070737 1383  5070726 1385  5070727 1383  5070727 1383  5070727 1383  
328173 5070726 1385  5070726 1385  5070735 1385  5070735 1385  5070746 1383  5070751 1383  
328174 5070769 1385  5070780 1383  5070788 1385  5070802 1385  5070823 1383  5070846 1383  
328175 5070861 1383  5070875 1383  5070899 1383  5070923 1383  5070947 1383  5070971 1383  
328176 5070988 1385  5071012 1385  5071037 1383  5071061 1383  5071080 1383  5071104 1383  
328177 5071128 1383  5071150 1385  5071171 1383  5071181 1383  5071205 1383  5071219 1383  
328178 5071237 1385  5071252 1383  5071262 1383  5071272 1383  5071276 1383  5071281 1383  
328179 5071279 1385  5071281 1383  5071281 1383  5071279 1385  5071276 1383  5071272 1383  
328180 5071262 1383  5071252 1383  5071238 1383  5071219 1383  5071205 1383  5071191 1383  
328181 5071176 1383  5071152 1383  5071138 1383  5071114 1383  5071093 1385  5071071 1383  
328182 5071047 1383  5071028 1383  5070995 1383  5070974 1385  5070952 1383  5070928 1383  
328183 5070904 1383  5070885 1383  5070870 1383  5070846 1383  5070823 1383  5070803 1383  
328184 5070785 1383  5070770 1383  5070751 1383  5070737 1383  5070726 1385  5070722 1383  
328185 5070711 1385  5070702 1385  5070697 1385  5070697 1385  5070698 1383  5070698 1383  
328186 5070697 1385  5070702 1385  5070711 1385  5070722 1383  5070726 1385  5070746 1383  
328187 5070759 1385  5070770 1383  5070788 1385  5070802 1385  5070823 1383  5070846 1383  
328188 5070870 1383  5070885 1383  5070904 1383  5070928 1383  5070960 1385  5070980 1383  
328189 5070995 1383  5071023 1383  5071047 1383  5071069 1385  5071090 1383  5071104 1383  
328190 5071128 1383  5071152 1383  5071170 1385  5071179 1385  5071189 1385  5071203 1385  
328191 5071213 1385  5071217 1385  5071227 1385  5071238 1383  5071238 1383  5071237 1385  
328192 5071237 1385  5071238 1383  5071229 1383  5071219 1383  5071214 1383  5071203 1385  
328193 5071191 1383  5071176 1383  5071171 1383  5071152 1383  5071139 1381  5071114 1383  
328194 5071095 1383  5071076 1383  5071061 1383  5071039 1381  5071014 1383  5070990 1383  
328195 5070971 1383  5070947 1383  5070925 1381  5070904 1383  5070885 1383  5070861 1383  
328196 5070846 1383  5070827 1383  5070813 1383  5070799 1383  5070784 1383  5070779 1383  
328197 5070770 1383  5070761 1383  5070751 1383  5070746 1383  5070745 1385  5070745 1385  
328198 5070746 1383  5070745 1385  5070750 1385  5070759 1385  5070770 1383  5070778 1385  
328199 5070789 1383  5070797 1385  5070811 1385  5070826 1385  5070846 1383  5070870 1383  
328200 5070885 1383  5070904 1383  5070922 1385  5070952 1383  5070974 1385  5070993 1385  
328201 5071022 1385  5071046 1385  5071069 1385  5071095 1383  5071124 1383  5071147 1383  
328202 5071171 1383  5071179 1385  5071205 1383  5071219 1383  5071238 1383  5071251 1385  
328203 5071272 1383  5071276 1383  5071281 1383  5071294 1385  5071294 1385  5071305 1383  
328204 5071304 1385  5071303 1385  5071296 1383  5071296 1383  5071291 1383  5071281 1383  
328205 5071275 1385  5071262 1383  5071248 1383  5071229 1383  5071205 1383  5071190 1383  
328206 5071171 1383  5071147 1383  5071124 1383  5071097 1381  5071076 1383  5071052 1383  
328207 5071023 1383  5070995 1383  5070971 1383  5070947 1383  5070913 1383  5070890 1383  
328208 5070861 1383  5070837 1383  5070804 1383  5070785 1383  5070761 1383  5070737 1383  
328209 5070722 1383  5070698 1383  5070689 1383  5070670 1383  5070655 1383  5070646 1383  
328210 5070636 1383  5070622 1383  5070613 1383  5070611 1385  5070611 1385  5070611 1385  
328211 5070611 1385  5070613 1383  5070622 1383  5070627 1383  5070646 1383  5070654 1385  
328212 5070668 1385  5070689 1383  5070703 1383  5070726 1385  5070745 1385  5070770 1383  
328213 5070789 1383  5070811 1385  5070837 1383  5070870 1383  5070888 1385  5070912 1385  
328214 5070937 1383  5070969 1385  5070990 1383  5071023 1383  5071047 1383  5071071 1383  
328215 5071089 1385  5071112 1385  5071127 1385  5071150 1385  5071171 1383  5071179 1385  
328216 5071189 1385  5071203 1385  5071213 1385  5071219 1383  5071227 1385  5071227 1385  
328217 5071237 1385  5071237 1385  5071229 1383  5071219 1383  5071213 1385  5071203 1385  
328218 5071195 1383  5071181 1383  5071171 1383  5071154 1381  5071138 1383  5071114 1383  
328219 5071095 1383  5071080 1383  5071061 1383  5071038 1383  5071023 1383  5070995 1383  
328220 5070976 1383  5070950 1385  5070939 1381  5070913 1383  5070890 1383  5070870 1383  
328221 5070851 1383  5070827 1383  5070813 1383  5070804 1383  5070789 1383  5070779 1383  
328222 5070768 1385  5070759 1385  5070750 1385  5070746 1383  5070745 1385  5070746 1383  
328223 5070745 1385  5070746 1383  5070750 1385  5070761 1383  5070769 1385  5070779 1383  
328224 5070788 1385  5070802 1385  5070821 1385  5070837 1383  5070861 1383  5070875 1383  
328225 5070899 1383  5070923 1383  5070947 1383  5070975 1383  5070993 1385  5071023 1383  
328226 5071045 1385  5071076 1383  5071095 1383  5071124 1383  5071147 1383  5071170 1385  
328227 5071189 1385  5071205 1383  5071227 1385  5071247 1383  5071261 1385  5071276 1383  
328228 5071291 1383  5071296 1383  5071303 1385  5071318 1385  5071319 1383  5071327 1385  
328229 5071327 1385  5071319 1383  5071319 1383  5071314 1383  5071304 1385  5071296 1383  
328230 5071281 1383  5071276 1383  5071252 1383  5071238 1383  5071214 1383  5071191 1383  
328231 5071171 1383  5071147 1383  5071114 1383  5071089 1385  5071061 1383  5071028 1383  
328232 5070995 1383  5070971 1383  5070937 1383  5070904 1383  5070875 1383  5070853 1381  
328233 5070823 1383  5070791 1381  5070761 1383  5070736 1383  5070703 1383  5070684 1383  
328234 5070656 1383  5070625 1385  5070613 1383  5070589 1383  5070579 1383  5070560 1383  
328235 5070544 1385  5070536 1383  5070525 1385  5070523 1387  5070520 1385  5070520 1385  
328236 5070525 1385  5070524 1387  5070534 1385  5070544 1385  5070558 1385  5070579 1383  
328237 5070587 1385  5070601 1385  5070625 1385  5070655 1383  5070678 1385  5070698 1383  
328238 5070727 1383  5070751 1383  5070783 1385  5070813 1383  5070846 1383  5070875 1383  
328239 5070905 1381  5070937 1383  5070960 1385  5070990 1383  5071012 1385  5071045 1385  
328240 5071069 1385  5071090 1383  5071114 1383  5071138 1383  5071162 1383  5071176 1383  
328241 5071189 1385  5071203 1385  5071213 1385  5071217 1385  5071229 1383  5071237 1385  
328242 5071237 1385  5071237 1385  5071238 1383  5071227 1385  5071219 1383  5071205 1383  
328243 5071195 1383  5071181 1383  5071171 1383  5071154 1381  5071138 1383  5071114 1383  
328244 5071095 1383  5071074 1385  5071052 1383  5071028 1383  5071004 1383  5070980 1383  
328245 5070971 1383  5070947 1383  5070923 1383  5070897 1385  5070875 1383  5070852 1383  
328246 5070837 1383  5070811 1385  5070799 1383  5070784 1383  5070780 1383  5070759 1385  
328247 5070751 1383  5070746 1383  5070735 1385  5070726 1385  5070726 1385  5070726 1385  
328248 5070726 1385  5070735 1385  5070745 1385  5070750 1385  5070759 1385  5070778 1385  
328249 5070788 1385  5070802 1385  5070821 1385  5070845 1385  5070869 1385  5070888 1385  
328250 5070913 1383  5070936 1385  5070961 1383  5070980 1383  5071004 1383  5071028 1383  
328251 5071054 1381  5071080 1383  5071104 1383  5071128 1383  5071150 1385  5071174 1385  
328252 5071194 1385  5071217 1385  5071238 1383  5071261 1385  5071276 1383  5071291 1383  
328253 5071294 1385  5071305 1383  5071314 1383  5071318 1385  5071327 1385  5071329 1383  
328254 5071329 1383  5071327 1385  5071319 1383  5071314 1383  5071297 1381  5071291 1383  
328255 5071276 1383  5071252 1383  5071238 1383  5071214 1383  5071191 1383  5071171 1383  
328256 5071138 1383  5071104 1383  5071076 1383  5071047 1383  5071013 1383  5070980 1383  
328257 5070947 1383  5070913 1383  5070875 1383  5070846 1383  5070803 1383  5070770 1383  
328258 5070737 1383  5070703 1383  5070679 1383  5070644 1385  5070611 1385  5070582 1385  
328259 5070558 1385  5070534 1385  5070512 1383  5070498 1383  5070482 1385  5070468 1385  
328260 5070453 1385  5070444 1385  5070434 1385  5070434 1385  5070429 1385  5070429 1385  
328261 5070434 1385  5070445 1383  5070455 1383  5070468 1385  5070482 1385  5070498 1383  
328262 5070520 1385  5070534 1385  5070558 1385  5070582 1385  5070613 1383  5070635 1385  
328263 5070670 1383  5070698 1383  5070727 1383  5070761 1383  5070789 1383  5070827 1383  
328264 5070859 1385  5070890 1383  5070923 1383  5070952 1383  5070980 1383  5071014 1383  
328265 5071038 1383  5071060 1385  5071080 1383  5071104 1383  5071127 1385  5071147 1383  
328266 5071162 1383  5071171 1383  5071179 1385  5071191 1383  5071191 1383  5071197 1381  
328267 5071197 1381  5071195 1383  5071195 1383  5071191 1383  5071181 1383  5071177 1381  
328268 5071162 1383  5071152 1383  5071138 1383  5071114 1383  5071096 1381  5071080 1383  
328269 5071062 1383  5071038 1383  5071015 1381  5070990 1383  5070975 1383  5070952 1383  
328270 5070928 1383  5070904 1383  5070885 1383  5070861 1383  5070837 1383  5070813 1383  
328271 5070788 1385  5070778 1385  5070759 1385  5070745 1385  5070726 1385  5070726 1385  
328272 5070710 1387  5070710 1387  5070710 1387  5070711 1385  5070710 1387  5070710 1387  
328273 5070711 1385  5070719 1387  5070724 1387  5070745 1385  5070750 1385  5070778 1385  
328274 5070788 1385  5070802 1385  5070826 1385  5070851 1383  5070874 1385  5070888 1385  
328275 5070921 1385  5070945 1385  5070969 1385  5070993 1385  5071023 1383  5071052 1383  
328276 5071076 1383  5071104 1383  5071128 1383  5071150 1385  5071176 1383  5071195 1383  
328277 5071219 1383  5071246 1385  5071270 1385  5071279 1385  5071294 1385  5071314 1383  
328278 5071319 1383  5071338 1383  5071343 1383  5071342 1385  5071353 1383  5071342 1385  
328279 5071342 1385  5071342 1385  5071338 1383  5071318 1385  5071313 1385  5071294 1385  
328280 5071279 1385  5071261 1385  5071248 1383  5071217 1385  5071191 1383  5071173 1381  
328281 5071136 1385  5071104 1383  5071076 1383  5071038 1383  5071004 1383  5070971 1383  
328282 5070936 1385  5070897 1385  5070859 1385  5070827 1383  5070789 1383  5070750 1385  
328283 5070721 1385  5070683 1385  5070654 1385  5070621 1385  5070587 1385  5070568 1385  
328284 5070544 1385  5070510 1385  5070496 1385  5070476 1387  5070457 1387  5070444 1385  
328285 5070428 1387  5070418 1386  5070418 1387  5070409 1387  5070417 1388  5070419 1387  
328286 5070426 1388  5070433 1387  5070450 1388  5070465 1388  5070481 1387  5070499 1386  
328287 5070519 1386  5070541 1388  5070568 1385  5070586 1387  5070619 1387  5070652 1387  
328288 5070681 1387  5070710 1387  5070749 1385  5070783 1385  5070821 1385  5070848 1387  
328289 5070888 1385  5070921 1385  5070950 1385  5070979 1385  5071012 1385  5071045 1385  
328290 5071069 1385  5071093 1385  5071122 1385  5071146 1385  5071159 1387  5071174 1385  
328291 5071189 1385  5071194 1385  5071212 1385  5071217 1385  5071217 1385  5071227 1385  
328292 5071226 1387  5071217 1385  5071217 1385  5071211 1387  5071202 1387  5071192 1387  
328293 5071178 1387  5071168 1387  5071149 1387  5071135 1387  5071112 1385  5071093 1385  
328294 5071074 1385  5071050 1385  5071025 1387  5071002 1385  5070979 1385  5070961 1383  
328295 5070944 1387  5070912 1385  5070888 1385  5070874 1385  5070850 1385  5070826 1385  
328296 5070811 1385  5070796 1387  5070781 1387  5070769 1385  5070757 1386  5070748 1387  
328297 5070745 1385  5070734 1387  5070733 1386  5070734 1387  5070732 1388  5070743 1387  
328298 5070748 1387  5070756 1388  5070767 1387  5070781 1387  5070786 1387  5070810 1387  
328299 5070824 1387  5070848 1386  5070869 1385  5070888 1385  5070920 1387  5070945 1385  
328300 5070969 1385  5070988 1385  5071020 1386  5071050 1385  5071072 1386  5071093 1385  
328301 5071127 1385  5071159 1386  5071178 1387  5071213 1385  5071234 1388  5071259 1387  
328302 5071278 1387  5071300 1388  5071316 1387  5071335 1387  5071358 1388  5071374 1387  
328303 5071378 1387  5071388 1387  5071393 1387  5071393 1387  5071393 1387  5071393 1386  
328304 5071393 1386  5071388 1386  5071380 1385  5071370 1385  5071350 1387  5071337 1385  
328305 5071313 1385  5071289 1385  5071270 1385  5071237 1385  5071213 1385  5071178 1387  
328306 5071150 1385  5071112 1385  5071079 1385  5071045 1385  5071003 1385  5070969 1385  
328307 5070926 1385  5070888 1385  5070850 1385  5070810 1387  5070783 1385  5070745 1385  
328308 5070702 1385  5070678 1385  5070644 1385  5070611 1385  5070581 1387  5070558 1385  
328309 5070534 1385  5070509 1387  5070487 1385  5070477 1385  5070456 1386  5070443 1385  
328310 5070434 1385  5070428 1387  5070428 1387  5070429 1385  5070429 1385  5070431 1388  
328311 5070442 1387  5070458 1385  5070468 1385  5070482 1385  5070499 1387  5070523 1387  
328312 5070552 1387  5070576 1387  5070600 1387  5070635 1385  5070667 1387  5070694 1388  
328313 5070724 1387  5070757 1387  5070797 1385  5070824 1387  5070867 1387  5070896 1387  
328314 5070925 1387  5070968 1387  5070992 1387  5071027 1385  5071058 1387  5071079 1385  
328315 5071111 1387  5071133 1388  5071150 1385  5071173 1387  5071187 1386  5071202 1387  
328316 5071217 1385  5071227 1385  5071235 1387  5071245 1387  5071245 1387  5071245 1387  
328317 5071245 1387  5071237 1385  5071227 1385  5071217 1385  5071213 1385  5071194 1385  
328318 5071178 1387  5071170 1385  5071149 1387  5071127 1385  5071112 1385  5071087 1387  
328319 5071074 1385  5071050 1385  5071025 1387  5071003 1385  5070978 1385  5070960 1385  
328320 5070936 1385  5070912 1385  5070887 1387  5070872 1387  5070848 1386  5070834 1387  
328321 5070810 1387  5070800 1387  5070786 1387  5070781 1387  5070776 1387  5070767 1387  
328322 5070759 1385  5070757 1387  5070748 1387  5070758 1387  5070757 1387  5070758 1387  
328323 5070765 1388  5070775 1388  5070780 1388  5070796 1387  5070810 1387  5070834 1387  
328324 5070848 1386  5070872 1387  5070896 1387  5070925 1387  5070948 1387  5070972 1387  
328325 5071001 1387  5071025 1387  5071058 1387  5071077 1387  5071111 1387  5071144 1387  
328326 5071168 1387  5071194 1385  5071226 1387  5071249 1387  5071273 1387  5071292 1387  
328327 5071318 1385  5071340 1387  5071359 1387  5071375 1385  5071388 1387  5071393 1387  
328328 5071402 1387  5071413 1385  5071417 1387  5071418 1385  5071418 1385  5071413 1385  
328329 5071404 1385  5071394 1385  5071381 1383  5071372 1383  5071341 1385  5071327 1385  
328330 5071303 1385  5071281 1383  5071252 1383  5071217 1385  5071189 1385  5071160 1385  
328331 5071128 1383  5071090 1383  5071050 1385  5071012 1385  5070980 1383  5070945 1385  
328332 5070902 1385  5070869 1385  5070835 1385  5070797 1385  5070759 1385  5070727 1383  
328333 5070697 1385  5070659 1385  5070625 1385  5070601 1385  5070577 1385  5070554 1385  
328334 5070527 1383  5070512 1383  5070487 1385  5070482 1385  5070468 1385  5070457 1387  
328335 5070452 1387  5070453 1385  5070442 1387  5070453 1385  5070452 1387  5070457 1387  
328336 5070476 1387  5070479 1388  5070499 1387  5070519 1387  5070542 1387  5070557 1387  
328337 5070581 1387  5070609 1387  5070633 1387  5070665 1388  5070697 1385  5070724 1387  
328338 5070758 1387  5070796 1387  5070824 1386  5070858 1387  5070887 1387  5070925 1387  
328339 5070958 1386  5070985 1388  5071022 1385  5071050 1385  5071071 1388  5071092 1387  
328340 5071121 1387  5071144 1386  5071170 1385  5071178 1387  5071192 1387  5071211 1387  
328341 5071217 1385  5071227 1385  5071237 1385  5071237 1385  5071237 1385  5071235 1387  
328342 5071227 1385  5071216 1387  5071213 1385  5071195 1383  5071187 1387  5071174 1385  
328343 5071150 1385  5071136 1385  5071121 1387  5071092 1387  5071073 1387  5071050 1385  
328344 5071027 1385  5071001 1387  5070977 1387  5070960 1385  5070936 1385  5070910 1387  
328345 5070887 1387  5070869 1385  5070850 1385  5070826 1385  5070810 1387  5070796 1387  
328346 5070781 1387  5070776 1386  5070758 1387  5070748 1387  5070743 1387  5070743 1387  
328347 5070732 1388  5070726 1385  5070734 1387  5070732 1388  5070734 1387  5070743 1387  
328348 5070748 1387  5070767 1387  5070781 1387  5070796 1387  5070810 1387  5070824 1387  
328349 5070848 1387  5070872 1387  5070896 1387  5070923 1388  5070950 1385  5070972 1387  
328350 5071001 1387  5071034 1387  5071058 1386  5071087 1387  5071121 1387  5071144 1387  
328351 5071173 1387  5071192 1387  5071216 1387  5071245 1387  5071275 1385  5071289 1385  
328352 5071313 1385  5071326 1387  5071340 1387  5071361 1385  5071370 1385  5071380 1385  
328353 5071378 1387  5071390 1385  5071388 1387  5071380 1385  5071380 1385  5071375 1385  
328354 5071359 1387  5071351 1385  5071338 1383  5071313 1385  5071289 1385  5071275 1385  
328355 5071248 1383  5071219 1383  5071191 1383  5071162 1383  5071127 1385  5071095 1383  
328356 5071069 1385  5071036 1385  5070993 1385  5070969 1385  5070926 1385  5070890 1383  
328357 5070850 1385  5070821 1385  5070788 1385  5070750 1385  5070721 1385  5070687 1385  
328358 5070659 1385  5070624 1387  5070601 1385  5070582 1385  5070557 1387  5070544 1385  
328359 5070519 1387  5070499 1386  5070495 1387  5070482 1385  5070477 1385  5070477 1385  
328360 5070468 1385  5070468 1385  5070466 1387  5070475 1387  5070480 1386  5070485 1387  
328361 5070499 1387  5070519 1387  5070544 1385  5070557 1387  5070582 1385  5070600 1387  
328362 5070625 1385  5070653 1387  5070681 1387  5070711 1385  5070735 1385  5070767 1386  
328363 5070797 1385  5070824 1387  5070859 1385  5070888 1385  5070921 1385  5070950 1385  
328364 5070977 1387  5071012 1385  5071036 1385  5071060 1385  5071077 1387  5071103 1385  
328365 5071127 1385  5071150 1385  5071170 1385  5071174 1385  5071189 1385  5071194 1385  
328366 5071203 1385  5071214 1383  5071213 1385  5071212 1385  5071213 1385  5071205 1383  
328367 5071194 1385  5071189 1385  5071181 1383  5071170 1385  5071150 1385  5071138 1383  
328368 5071124 1383  5071103 1385  5071079 1385  5071071 1383  5071045 1385  5071022 1385  
328369 5070995 1383  5070975 1383  5070950 1385  5070937 1383  5070913 1383  5070889 1383  
328370 5070875 1383  5070853 1381  5070838 1381  5070813 1383  5070800 1381  5070786 1381  
328371 5070772 1381  5070762 1381  5070751 1383  5070746 1383  5070737 1383  5070727 1383  
328372 5070727 1383  5070729 1381  5070737 1383  5070746 1383  5070746 1383  5070761 1383  
328373 5070770 1383  5070785 1383  5070799 1383  5070821 1385  5070835 1385  5070859 1385  
328374 5070875 1383  5070897 1385  5070923 1383  5070950 1385  5070975 1383  5070995 1383  
328375 5071028 1383  5071052 1383  5071079 1385  5071103 1385  5071136 1385  5071162 1383  
328376 5071191 1383  5071214 1383  5071238 1383  5071262 1383  5071275 1385  5071291 1383  
328377 5071305 1383  5071319 1383  5071339 1383  5071343 1383  5071353 1383  5071362 1383  
328378 5071362 1383  5071364 1381  5071364 1381  5071352 1383  5071343 1383  5071338 1383  
328379 5071321 1381  5071305 1383  5071292 1381  5071278 1381  5071254 1381  5071230 1381  
328380 5071197 1381  5071177 1381  5071149 1381  5071124 1383  5071092 1381  5071061 1383  
328381 5071023 1383  5070991 1381  5070953 1381  5070925 1381  5070890 1383  5070861 1383  
328382 5070829 1381  5070800 1381  5070770 1383  5070738 1381  5070701 1385  5070684 1383  
328383 5070660 1383  5070636 1383  5070613 1383  5070598 1383  5070584 1383  5070560 1383  
328384 5070554 1385  5070536 1383  5070527 1383  5070520 1385  5070522 1383  5070522 1383  
328385 5070512 1383  5070522 1383  5070525 1385  5070536 1383  5070546 1383  5070558 1385  
328386 5070579 1383  5070589 1383  5070603 1383  5070625 1385  5070655 1383  5070679 1383  
328387 5070698 1383  5070727 1383  5070751 1383  5070784 1383  5070805 1381  5070837 1383  
328388 5070872 1381  5070899 1383  5070923 1383  5070952 1383  5070979 1385  5071013 1383  
328389 5071037 1383  5071061 1383  5071080 1383  5071106 1381  5071130 1381  5071147 1383  
328390 5071162 1383  5071176 1383  5071181 1383  5071195 1383  5071205 1383  5071206 1381  
328391 5071203 1385  5071205 1383  5071205 1383  5071205 1383  5071194 1385  5071191 1383  
328392 5071182 1381  5071171 1383  5071162 1383  5071147 1383  5071128 1383  5071115 1381  
328393 5071095 1383  5071076 1383  5071063 1381  5071038 1383  5071015 1381  5070991 1381  
328394 5070971 1383  5070953 1381  5070929 1381  5070904 1383  5070886 1381  5070870 1383  
328395 5070848 1381  5070829 1381  5070813 1383  5070805 1381  5070791 1381  5070779 1383  
328396 5070770 1383  5070751 1383  5070751 1383  5070748 1381  5070746 1383  5070746 1383  
328397 5070746 1383  5070746 1383  5070751 1383  5070761 1383  5070770 1383  5070779 1383  
328398 5070791 1381  5070803 1383  5070827 1383  5070848 1381  5070862 1381  5070886 1381  
328399 5070905 1381  5070925 1381  5070953 1381  5070971 1383  5070990 1383  5071023 1383  
328400 5071048 1381  5071071 1383  5071090 1383  5071114 1383  5071138 1383  5071162 1383  
328401 5071179 1385  5071205 1383  5071219 1383  5071238 1383  5071261 1385  5071272 1383  
328402 5071279 1385  5071289 1385  5071294 1385  5071303 1385  5071303 1385  5071303 1385  
328403 5071303 1385  5071303 1385  5071294 1385  5071289 1385  5071278 1387  5071275 1385  
328404 5071262 1383  5071246 1385  5071229 1383  5071213 1385  5071189 1385  5071171 1383  
328405 5071152 1383  5071122 1385  5071093 1385  5071074 1385  5071045 1385  5071012 1385  
328406 5070980 1383  5070960 1385  5070926 1385  5070902 1385  5070874 1385  5070845 1385  
328407 5070821 1385  5070797 1385  5070768 1385  5070746 1383  5070722 1383  5070698 1383  
328408 5070684 1383  5070670 1383  5070644 1385  5070635 1385  5070620 1385  5070613 1383  
328409 5070603 1383  5070597 1385  5070597 1385  5070597 1385  5070597 1385  5070597 1385  
328410 5070601 1385  5070613 1383  5070622 1383  5070625 1385  5070644 1385  5070654 1385  
328411 5070678 1385  5070687 1385  5070702 1385  5070726 1385  5070751 1383  5070770 1383  
328412 5070799 1383  5070821 1385  5070845 1385  5070869 1385  5070888 1385  5070923 1383  
328413 5070947 1383  5070971 1383  5070988 1385  5071022 1385  5071047 1383  5071069 1385  
328414 5071079 1385  5071103 1385  5071127 1385  5071146 1385  5071160 1385  5071168 1387  
328415 5071178 1387  5071189 1385  5071192 1387  5071203 1385  5071211 1387  5071211 1387  
328416 5071213 1385  5071213 1385  5071213 1385  5071203 1385  5071194 1385  5071189 1385  
328417 5071179 1385  5071170 1385  5071150 1385  5071136 1385  5071124 1383  5071103 1385  
328418 5071079 1385  5071071 1383  5071050 1385  5071027 1385  5071003 1385  5070979 1385  
328419 5070960 1385  5070944 1387  5070921 1385  5070902 1385  5070885 1383  5070869 1385  
328420 5070850 1385  5070834 1387  5070826 1385  5070811 1385  5070800 1387  5070797 1385  
328421 5070783 1385  5070781 1387  5070781 1387  5070776 1387  5070778 1385  5070783 1385  
328422 5070783 1385  5070783 1385  5070788 1385  5070797 1385  5070812 1385  5070821 1385  
328423 5070835 1385  5070850 1385  5070859 1385  5070874 1385  5070898 1385  5070913 1383  
328424 5070936 1385  5070948 1386  5070974 1385  5070993 1385  5071012 1385  5071038 1383  
328425 5071061 1383  5071079 1385  5071103 1385  5071122 1385  5071146 1385  5071170 1385  
328426 5071178 1387  5071194 1385  5071211 1387  5071217 1385  5071235 1387  5071245 1387  
328427 5071249 1387  5071261 1385  5071269 1387  5071269 1387  5071269 1387  5071269 1387  
328428 5071269 1387  5071261 1385  5071251 1385  5071244 1387  5071237 1385  5071226 1387  
328429 5071213 1385  5071203 1385  5071179 1385  5071170 1385  5071150 1385  5071127 1385  
328430 5071103 1385  5071079 1385  5071060 1385  5071036 1385  5071014 1383  5070988 1385  
328431 5070960 1385  5070936 1385  5070913 1383  5070888 1385  5070874 1385  5070851 1383  
328432 5070826 1385  5070802 1385  5070783 1385  5070770 1383  5070750 1385  5070736 1383  
328433 5070723 1383  5070712 1383  5070698 1383  5070687 1385  5070683 1385  5070683 1385  
328434 5070678 1385  5070678 1385  5070678 1385  5070678 1385  5070683 1385  5070683 1385  
328435 5070687 1385  5070697 1385  5070702 1385  5070721 1385  5070726 1385  5070750 1385  
328436 5070759 1385  5070778 1385  5070797 1385  5070813 1383  5070835 1385  5070851 1383  
328437 5070883 1385  5070898 1385  5070921 1385  5070944 1387  5070969 1385  5070987 1387  
328438 5071012 1385  5071036 1385  5071060 1385  5071079 1385  5071093 1385  5071121 1387  
328439 5071136 1385  5071150 1385  5071168 1387  5071179 1385  5071189 1385  5071202 1387  
328440 5071213 1385  5071216 1387  5071216 1387  5071226 1387  5071226 1387  5071226 1387  
328441 5071226 1387  5071214 1388  5071216 1387  5071213 1385  5071202 1387  5071189 1385  
328442 5071179 1385  5071168 1387  5071150 1385  5071136 1385  5071121 1387  5071095 1383  
328443 5071079 1385  5071060 1385  5071045 1385  5071022 1385  5070993 1385  5070974 1385  
328444 5070961 1383  5070945 1385  5070926 1385  5070902 1385  5070888 1385  5070874 1385  
328445 5070869 1385  5070850 1385  5070845 1385  5070826 1385  5070821 1385  5070820 1387  
328446 5070811 1385  5070812 1385  5070812 1385  5070810 1387  5070810 1387  5070811 1385  
328447 5070811 1385  5070821 1385  5070826 1385  5070835 1385  5070843 1387  5070861 1383  
328448 5070872 1387  5070888 1385  5070899 1383  5070912 1385  5070926 1385  5070945 1385  
328449 5070961 1383  5070979 1385  5070993 1385  5071012 1385  5071036 1385  5071050 1385  
328450 5071069 1385  5071089 1385  5071103 1385  5071122 1385  5071136 1385  5071151 1385  
328451 5071160 1385  5071174 1385  5071189 1385  5071192 1387  5071202 1387  5071211 1387  
328452 5071216 1387  5071216 1387  5071227 1385  5071227 1385  5071226 1387  5071227 1385  
328453 5071226 1387  5071217 1385  5071211 1387  5071203 1385  5071189 1385  5071179 1385  
328454 5071168 1387  5071162 1383  5071146 1385  5071127 1385  5071112 1385  5071089 1385  
328455 5071074 1385  5071049 1387  5071027 1385  5071012 1385  5070988 1385  5070974 1385  
328456 5070950 1385  5070937 1383  5070912 1385  5070898 1385  5070874 1385  5070861 1383  
328457 5070845 1385  5070827 1383  5070811 1385  5070797 1385  5070789 1383  5070778 1385  
328458 5070769 1385  5070759 1385  5070750 1385  5070745 1385  5070735 1385  5070735 1385  
328459 5070735 1385  5070734 1387  5070734 1387  5070743 1387  5070743 1387  5070750 1385  
328460 5070767 1387  5070778 1385  5070783 1385  5070797 1385  5070802 1385  5070820 1387  
328461 5070835 1385  5070850 1385  5070874 1385  5070887 1387  5070912 1385  5070926 1385  
328462 5070945 1385  5070969 1385  5070988 1385  5071012 1385  5071027 1385  5071052 1383  
328463 5071069 1385  5071080 1383  5071103 1385  5071121 1387  5071136 1385  5071151 1385  
328464 5071160 1385  5071175 1385  5071178 1387  5071192 1387  5071202 1387  5071211 1387  
328465 5071211 1387  5071217 1385  5071216 1387  5071217 1385  5071216 1387  5071211 1387  
328466 5071202 1387  5071203 1385  5071194 1385  5071178 1387  5071173 1387  5071160 1385  
328467 5071144 1387  5071127 1385  5071112 1385  5071093 1385  5071074 1385  5071060 1385  
328468 5071036 1385  5071023 1383  5071004 1383  5070980 1383  5070969 1385  5070945 1385  
328469 5070928 1383  5070902 1385  5070888 1385  5070874 1385  5070869 1385  5070850 1385  
328470 5070835 1385  5070826 1385  5070821 1385  5070810 1387  5070802 1385  5070796 1387  
328471 5070786 1387  5070788 1385  5070783 1385  5070783 1385  5070781 1387  5070786 1387  
328472 5070788 1385  5070797 1385  5070802 1385  5070811 1385  5070821 1385  5070835 1385  
328473 5070845 1385  5070861 1383  5070867 1387  5070883 1385  5070898 1385  5070912 1385  
328474 5070926 1385  5070945 1385  5070960 1385  5070974 1385  5070979 1385  5070993 1385  
328475 5071011 1387  5071027 1385  5071046 1385  5071060 1385  5071069 1385  5071077 1387  
328476 5071087 1387  5071093 1385  5071111 1387  5071122 1385  5071135 1387  5071135 1387  
328477 5071144 1387  5071144 1387  5071144 1387  5071144 1387  5071144 1387  5071144 1387  
328478 5071136 1385  5071135 1387  5071125 1387  5071121 1387  5071111 1387  5071100 1388  
328479 5071092 1387  5071087 1387  5071073 1387  5071058 1387  5071045 1385  5071025 1387  
328480 5071012 1385  5070992 1387  5070979 1385  5070969 1385  5070950 1385  5070936 1385  
328481 5070922 1385  5070898 1385  5070883 1385  5070869 1385  5070850 1385  5070836 1385  
328482 5070821 1385  5070802 1385  5070797 1385  5070783 1385  5070776 1387  5070767 1387  
328483 5070759 1385  5070750 1385  5070743 1387  5070743 1387  5070743 1387  5070743 1387  
328484 5070743 1387  5070743 1387  5070748 1387  5070748 1387  5070758 1387  5070778 1385  
328485 5070783 1385  5070786 1387  5070802 1385  5070810 1387  5070826 1385  5070843 1387  
328486 5070858 1387  5070874 1385  5070887 1387  5070902 1385  5070922 1385  5070936 1385  
328487 5070960 1385  5070972 1387  5070988 1385  5071003 1385  5071027 1385  5071046 1385  
328488 5071058 1387  5071074 1385  5071087 1387  5071101 1387  5071122 1385  5071136 1385  
328489 5071144 1387  5071160 1385  5071159 1387  5071170 1385  5071174 1385  5071179 1385  
328490 5071179 1385  5071179 1385  5071179 1385  5071175 1385  5071170 1385  5071160 1385  
328491 5071151 1385  5071146 1385  5071138 1383  5071122 1385  5071112 1385  5071093 1385  
328492 5071081 1383  5071069 1385  5071052 1383  5071036 1385  5071012 1385  5070993 1385  
328493 5070975 1383  5070960 1385  5070947 1383  5070926 1385  5070912 1385  5070898 1385  
328494 5070874 1385  5070859 1385  5070845 1385  5070835 1385  5070820 1387  5070802 1385  
328495 5070797 1385  5070788 1385  5070781 1387  5070767 1387  5070769 1385  5070759 1385  
328496 5070759 1385  5070750 1385  5070748 1387  5070748 1387  5070748 1387  5070759 1385  
328497 5070757 1387  5070767 1387  5070776 1387  5070781 1387  5070786 1387  5070797 1385  
328498 5070800 1387  5070820 1387  5070826 1385  5070845 1385  5070848 1387  5070869 1385  
328499 5070883 1385  5070898 1385  5070901 1387  5070922 1385  5070936 1385  5070950 1385  
328500 5070958 1387  5070974 1385  5070988 1385  5071003 1385  5071012 1385  5071025 1387  
328501 5071038 1383  5071045 1385  5071058 1387  5071069 1385  5071073 1387  5071077 1387  
328502 5071079 1385  5071089 1385  5071089 1385  5071087 1387  5071092 1387  5071087 1387  
328503 5071089 1385  5071087 1387  5071087 1387  5071077 1387  5071079 1385  5071073 1387  
328504 5071069 1385  5071060 1385  5071045 1385  5071036 1385  5071027 1385  5071012 1385  
328505 5070993 1385  5070990 1383  5070974 1385  5070960 1385  5070948 1387  5070937 1383  
328506 5070922 1385  5070902 1385  5070896 1387  5070881 1387  5070870 1383  5070850 1385  
328507 5070845 1385  5070835 1385  5070826 1385  5070811 1385  5070802 1385  5070797 1385  
328508 5070797 1385  5070788 1385  5070788 1385  5070783 1385  5070783 1385  5070789 1383  
328509 5070788 1385  5070788 1385  5070797 1385  5070803 1383  5070811 1385  5070821 1385  
328510 5070834 1387  5070846 1383  5070850 1385  5070870 1383  5070883 1385  5070898 1385  
328511 5070912 1385  5070921 1385  5070945 1385  5070960 1385  5070974 1385  5070988 1385  
328512 5071003 1385  5071022 1385  5071036 1385  5071060 1385  5071076 1383  5071089 1385  
328513 5071103 1385  5071111 1387  5071127 1385  5071146 1385  5071150 1385  5071160 1385  
328514 5071170 1385  5071174 1385  5071179 1385  5071187 1387  5071187 1387  5071189 1385  
328515 5071189 1385  5071187 1387  5071178 1387  5071178 1387  5071173 1387  5071170 1385  
328516 5071149 1386  5071146 1385  5071135 1387  5071121 1387  5071101 1386  5071087 1387  
328517 5071073 1387  5071058 1387  5071044 1386  5071025 1387  5071009 1388  5070987 1387  
328518 5070972 1387  5070958 1387  5070936 1385  5070920 1387  5070901 1386  5070888 1385  
328519 5070867 1387  5070850 1385  5070846 1383  5070827 1383  5070813 1383  5070803 1383  
328520 5070789 1383  5070784 1383  5070779 1383  5070770 1383  5070762 1381  5070753 1381  
328521 5070753 1381  5070748 1381  5070753 1381  5070748 1381  5070748 1381  5070748 1381  
328522 5070753 1381  5070753 1381  5070762 1381  5070764 1379  5070773 1379  5070786 1375  
328523 5070788 1379  5070802 1379  5070809 1375  5070819 1375  5070834 1375  5070840 1379  
328524 5070854 1379  5070873 1379  5070878 1379  5070896 1375  5070907 1379  5070926 1379  
328525 5070931 1379  5070950 1379  5070967 1375  5070978 1379  5070993 1379  5070998 1379  
328526 5071017 1379  5071025 1381  5071031 1379  5071048 1381  5071048 1381  5071055 1379  
328527 5071063 1381  5071072 1381  5071079 1379  5071077 1381  5071077 1381  5071083 1379  
328528 5071082 1381  5071082 1381  5071077 1381  5071077 1381  5071072 1381  5071063 1381  
328529 5071063 1381  5071048 1381  5071039 1381  5071030 1381  5071025 1381  5071006 1381  
328530 5070996 1381  5070982 1381  5070972 1381  5070963 1381  5070950 1379  5070929 1381  
328531 5070924 1381  5070905 1381  5070891 1381  5070886 1381  5070872 1381  5070862 1381  
328532 5070854 1379  5070848 1381  5070838 1381  5070829 1381  5070824 1381  5070824 1381  
328533 5070824 1381  5070816 1379  5070814 1381  5070814 1381  5070824 1381  5070824 1381  
328534 5070826 1379  5070826 1379  5070830 1379  5070838 1381  5070848 1381  5070864 1379  
328535 5070872 1381  5070886 1381  5070891 1381  5070907 1379  5070915 1381  5070929 1381  
328536 5070950 1379  5070964 1379  5070978 1379  5070993 1379  5071010 1375  5071026 1379  
328537 5071040 1379  5071055 1379  5071074 1379  5071084 1379  5071098 1379  5071117 1379  
328538 5071130 1375  5071141 1379  5071154 1375  5071165 1379  5071165 1379  5071174 1379  
328539 5071177 1381  5071184 1379  5071184 1379  5071184 1379  5071194 1379  5071193 1379  
328540 5071184 1379  5071184 1379  5071184 1379  5071179 1379  5071173 1381  5071163 1381  
328541 5071154 1381  5071139 1381  5071131 1379  5071117 1379  5071096 1381  5071082 1381  
328542 5071072 1381  5071053 1381  5071039 1381  5071016 1379  5070998 1379  5070981 1381  
328543 5070974 1379  5070950 1379  5070931 1379  5070916 1379  5070902 1379  5070878 1379  
328544 5070862 1381  5070850 1379  5070829 1381  5070826 1379  5070806 1379  5070792 1379  
328545 5070788 1379  5070772 1381  5070762 1381  5070754 1379  5070748 1381  5070740 1379  
328546 5070740 1379  5070730 1379  5070729 1381  5070725 1379  5070724 1381  5070729 1381  
328547 5070730 1379  5070730 1379  5070740 1379  5070748 1381  5070754 1379  5070767 1375  
328548 5070773 1379  5070786 1375  5070787 1379  5070805 1375  5070819 1375  5070833 1375  
328549 5070853 1375  5070854 1379  5070873 1379  5070891 1375  5070905 1375  5070920 1375  
328550 5070934 1375  5070950 1379  5070964 1379  5070978 1379  5070993 1379  5071010 1375  
328551 5071017 1379  5071031 1379  5071040 1379  5071050 1379  5071064 1379  5071074 1379  
328552 5071079 1379  5071083 1379  5071087 1375  5071093 1379  5071093 1379  5071093 1379  
328553 5071093 1379  5071093 1379  5071087 1375  5071082 1381  5071079 1379  5071079 1379  
328554 5071074 1379  5071055 1379  5071055 1379  5071039 1381  5071031 1379  5071016 1379  
328555 5071010 1375  5070996 1375  5070986 1375  5070974 1379  5070958 1375  5070950 1379  
328556 5070931 1379  5070917 1379  5070910 1375  5070893 1379  5070891 1375  5070881 1375  
328557 5070873 1379  5070864 1379  5070857 1375  5070850 1379  5070840 1379  5070840 1379  
328558 5070830 1379  5070833 1375  5070830 1379  5070830 1379  5070830 1379  5070830 1379  
328559 5070833 1375  5070838 1381  5070850 1379  5070853 1381  5070864 1379  5070878 1379  
328560 5070888 1379  5070893 1379  5070905 1381  5070926 1379  5070940 1379  5070955 1379  
328561 5070974 1379  5070983 1379  5070998 1379  5071016 1379  5071031 1379  5071050 1379  
328562 5071063 1381  5071083 1379  5071093 1379  5071107 1379  5071125 1381  5071139 1381  
328563 5071150 1379  5071165 1379  5071174 1379  5071177 1381  5071182 1381  5071192 1381  
328564 5071192 1381  5071192 1381  5071197 1381  5071197 1381  5071192 1381  5071192 1381  
328565 5071192 1381  5071182 1381  5071182 1381  5071177 1381  5071163 1381  5071154 1381  
328566 5071149 1381  5071130 1381  5071115 1381  5071096 1381  5071082 1381  5071072 1381  
328567 5071048 1381  5071029 1381  5071015 1381  5070991 1381  5070977 1381  5070953 1381  
328568 5070939 1381  5070915 1381  5070891 1381  5070877 1381  5070862 1381  5070838 1381  
328569 5070824 1381  5070806 1379  5070786 1381  5070771 1381  5070754 1379  5070748 1381  
328570 5070729 1381  5070725 1379  5070716 1379  5070705 1381  5070701 1379  5070690 1381  
328571 5070686 1381  5070687 1379  5070686 1381  5070686 1381  5070686 1381  5070686 1381  
328572 5070690 1381  5070690 1381  5070700 1381  5070704 1381  5070716 1379  5070728 1381  
328573 5070738 1381  5070748 1381  5070762 1381  5070771 1381  5070787 1379  5070805 1381  
328574 5070824 1381  5070838 1381  5070853 1381  5070872 1381  5070888 1379  5070900 1381  
328575 5070924 1381  5070940 1379  5070955 1379  5070974 1379  5070983 1379  5071006 1381  
328576 5071015 1381  5071031 1379  5071040 1379  5071055 1379  5071064 1379  5071072 1381  
328577 5071079 1379  5071083 1379  5071082 1381  5071093 1379  5071092 1381  5071093 1379  
328578 5071092 1381  5071093 1379  5071082 1381  5071083 1379  5071079 1379  5071072 1381  
328579 5071063 1381  5071053 1381  5071048 1381  5071029 1381  5071016 1379  5071005 1381  
328580 5070991 1381  5070983 1379  5070972 1381  5070953 1381  5070950 1379  5070926 1379  
328581 5070916 1379  5070902 1379  5070888 1379  5070878 1379  5070864 1379  5070854 1379  
328582 5070850 1379  5070830 1379  5070826 1379  5070826 1379  5070816 1379  5070816 1379  
328583 5070806 1379  5070809 1375  5070809 1375  5070816 1379  5070816 1379  5070826 1379  
328584 5070829 1375  5070843 1375  5070843 1375  5070857 1375  5070864 1379  5070881 1375  
328585 5070895 1375  5070910 1375  5070929 1375  5070943 1375  5070958 1375  5070977 1375  
328586 5070978 1379  5071001 1375  5071020 1375  5071031 1379  5071053 1375  5071067 1375  
328587 5071079 1379  5071096 1375  5071107 1379  5071120 1375  5071134 1375  5071154 1375  
328588 5071155 1379  5071177 1375  5071179 1379  5071179 1379  5071184 1379  5071193 1379  
328589 5071193 1379  5071198 1379  5071193 1379  5071198 1379  5071193 1379  5071196 1375  
328590 5071182 1381  5071179 1379  5071174 1379  5071163 1381  5071149 1381  5071139 1381  
328591 5071127 1379  5071106 1381  5071093 1379  5071077 1381  5071063 1381  5071039 1381  
328592 5071025 1381  5070996 1381  5070977 1381  5070953 1381  5070938 1381  5070915 1381  
328593 5070891 1381  5070873 1379  5070848 1381  5070830 1379  5070807 1379  5070787 1379  
328594 5070771 1381  5070752 1375  5070733 1375  5070716 1379  5070692 1379  5070687 1379  
328595 5070673 1379  5070663 1379  5070649 1379  5070639 1379  5070630 1379  5070628 1375  
328596 5070625 1379  5070628 1375  5070625 1379  5070625 1379  5070625 1379  5070630 1379  
328597 5070633 1375  5070649 1379  5070661 1375  5070676 1375  5070682 1379  5070692 1379  
328598 5070709 1375  5070728 1375  5070740 1379  5070754 1379  5070786 1375  5070795 1375  
328599 5070816 1379  5070843 1375  5070854 1379  5070878 1379  5070902 1379  5070926 1379  
328600 5070950 1379  5070964 1379  5070978 1379  5070993 1379  5071016 1379  5071031 1379  
328601 5071050 1379  5071055 1379  5071074 1379  5071079 1379  5071082 1381  5071092 1381  
328602 5071098 1379  5071106 1381  5071106 1381  5071115 1381  5071115 1381  5071115 1381  
328603 5071106 1381  5071106 1381  5071096 1381  5071092 1381  5071082 1381  5071077 1381  
328604 5071063 1381  5071053 1381  5071039 1381  5071029 1381  5071015 1381  5071007 1379  
328605 5070993 1379  5070977 1381  5070964 1379  5070948 1381  5070929 1381  5070924 1381  
328606 5070905 1381  5070891 1381  5070888 1379  5070873 1379  5070854 1379  5070848 1381  
328607 5070840 1379  5070838 1381  5070830 1379  5070824 1381  5070824 1381  5070814 1381  
328608 5070816 1379  5070826 1379  5070824 1381  5070826 1379  5070830 1379  5070840 1379  
328609 5070848 1381  5070853 1381  5070873 1379  5070878 1379  5070891 1381  5070907 1379  
328610 5070926 1379  5070948 1381  5070964 1379  5070977 1381  5070991 1381  5071007 1379  
328611 5071026 1379  5071048 1381  5071065 1379  5071079 1379  5071096 1381  5071115 1381  
328612 5071130 1381  5071149 1381  5071163 1381  5071173 1381  5071182 1381  5071197 1381  
328613 5071206 1381  5071221 1381  5071221 1381  5071230 1381  5071240 1381  5071240 1381  
328614 5071240 1381  5071238 1383  5071249 1381  5071240 1381  5071228 1383  5071219 1383  
328615 5071216 1381  5071206 1381  5071191 1383  5071176 1383  5071163 1381  5071147 1383  
328616 5071128 1383  5071104 1383  5071092 1381  5071071 1383  5071047 1383  5071025 1381  
328617 5070996 1381  5070975 1383  5070952 1383  5070923 1383  5070904 1383  5070877 1381  
328618 5070853 1381  5070827 1383  5070800 1381  5070781 1381  5070751 1383  5070729 1381  
328619 5070705 1381  5070689 1383  5070670 1383  5070656 1383  5070638 1381  5070624 1381  
328620 5070614 1381  5070600 1381  5070590 1381  5070585 1381  5070581 1381  5070581 1381  
328621 5070581 1381  5070581 1381  5070581 1381  5070585 1381  5070590 1381  5070600 1381  
328622 5070604 1381  5070624 1381  5070628 1381  5070647 1381  5070662 1381  5070681 1381  
328623 5070700 1381  5070716 1379  5070738 1381  5070762 1381  5070786 1381  5070805 1381  
328624 5070829 1381  5070853 1381  5070877 1381  5070891 1381  5070924 1381  5070939 1381  
328625 5070963 1381  5070982 1381  5070996 1381  5071025 1381  5071039 1381  5071048 1381  
328626 5071063 1381  5071077 1381  5071082 1381  5071096 1381  5071106 1381  5071115 1381  
328627 5071115 1381  5071115 1381  5071115 1381  5071115 1381  5071115 1381  5071115 1381  
328628 5071106 1381  5071096 1381  5071092 1381  5071082 1381  5071077 1381  5071063 1381  
328629 5071048 1381  5071029 1381  5071015 1381  5070996 1381  5070991 1381  5070977 1381  
328630 5070953 1381  5070948 1381  5070929 1381  5070915 1381  5070901 1381  5070886 1381  
328631 5070872 1381  5070853 1381  5070848 1381  5070829 1381  5070824 1381  5070814 1381  
328632 5070805 1381  5070800 1381  5070800 1381  5070791 1381  5070791 1381  5070792 1379  
328633 5070802 1379  5070802 1379  5070807 1379  5070814 1381  5070824 1381  5070830 1379  
328634 5070848 1381  5070864 1379  5070878 1379  5070891 1381  5070907 1379  5070924 1381  
328635 5070950 1379  5070964 1379  5070981 1381  5070998 1379  5071025 1381  5071048 1381  
328636 5071064 1379  5071082 1381  5071096 1381  5071127 1379  5071139 1381  5071163 1381  
328637 5071177 1381  5071192 1381  5071208 1379  5071221 1381  5071230 1381  5071250 1379  
328638 5071254 1381  5071273 1381  5071279 1379  5071279 1379  5071278 1381  5071282 1381  
328639 5071282 1381  5071278 1381  5071278 1381  5071263 1381  5071254 1381  5071249 1381  
328640 5071240 1381  5071221 1381  5071206 1381  5071182 1381  5071173 1381  5071149 1381  
328641 5071125 1381  5071096 1381  5071077 1381  5071053 1381  5071025 1381  5070991 1381  
328642 5070972 1381  5070939 1381  5070905 1381  5070886 1381  5070853 1381  5070829 1381  
328643 5070802 1379  5070772 1381  5070748 1381  5070724 1381  5070700 1381  5070681 1381  
328644 5070657 1381  5070638 1381  5070625 1379  5070606 1379  5070590 1381  5070587 1379  
328645 5070582 1379  5070561 1381  5070561 1381  5070561 1381  5070561 1381  5070561 1381  
328646 5070561 1381  5070571 1381  5070582 1379  5070585 1381  5070592 1379  5070614 1381  
328647 5070625 1379  5070639 1379  5070663 1379  5070681 1381  5070701 1379  5070724 1381  
328648 5070738 1381  5070762 1381  5070786 1381  5070814 1381  5070838 1381  5070862 1381  
328649 5070886 1381  5070907 1379  5070939 1381  5070963 1381  5070981 1381  5071006 1381  
328650 5071025 1381  5071048 1381  5071063 1381  5071082 1381  5071096 1381  5071115 1381  
328651 5071125 1381  5071130 1381  5071139 1381  5071149 1381  5071149 1381  5071154 1381  
328652 5071155 1379  5071154 1381  5071154 1381  5071149 1381  5071141 1379  5071130 1381  
328653 5071125 1381  5071117 1379  5071107 1379  5071092 1381  5071077 1381  5071063 1381  
328654 5071048 1381  5071030 1381  5071005 1381  5070991 1381  5070977 1381  5070963 1381  
328655 5070939 1381  5070924 1381  5070905 1381  5070891 1381  5070876 1381  5070862 1381  
328656 5070848 1381  5070838 1381  5070829 1381  5070824 1381  5070814 1381  5070805 1381  
328657 5070800 1381  5070800 1381  5070800 1381  5070802 1379  5070800 1381  5070806 1379  
328658 5070805 1381  5070816 1379  5070824 1381  5070838 1381  5070848 1381  5070862 1381  
328659 5070876 1381  5070891 1381  5070905 1381  5070929 1381  5070950 1379  5070973 1379  
328660 5070991 1381  5071015 1381  5071029 1381  5071055 1379  5071077 1381  5071098 1379  
328661 5071115 1381  5071139 1381  5071165 1379  5071182 1381  5071206 1381  5071221 1381  
328662 5071239 1381  5071263 1381  5071273 1381  5071282 1381  5071297 1381  5071306 1381  
328663 5071316 1381  5071321 1381  5071321 1381  5071321 1381  5071321 1381  5071321 1381  
328664 5071316 1381  5071316 1381  5071297 1381  5071292 1381  5071278 1381  5071263 1381  
328665 5071249 1381  5071221 1381  5071206 1381  5071182 1381  5071163 1381  5071130 1381  
328666 5071096 1381  5071072 1381  5071048 1381  5071015 1381  5070977 1381  5070948 1381  
328667 5070915 1381  5070886 1381  5070853 1381  5070824 1381  5070791 1381  5070762 1381  
328668 5070729 1381  5070700 1381  5070681 1381  5070657 1381  5070628 1381  5070604 1381  
328669 5070590 1381  5070581 1381  5070561 1381  5070547 1381  5070538 1381  5070528 1381  
328670 5070523 1381  5070523 1381  5070523 1381  5070523 1381  5070528 1381  5070537 1381  
328671 5070547 1381  5070561 1381  5070572 1379  5070585 1381  5070604 1381  5070623 1381  
328672 5070648 1381  5070662 1381  5070686 1381  5070705 1381  5070729 1381  5070762 1381  
328673 5070787 1379  5070816 1379  5070838 1381  5070872 1381  5070891 1381  5070926 1379  
328674 5070948 1381  5070977 1381  5070996 1381  5071026 1379  5071048 1381  5071063 1381  
328675 5071083 1379  5071096 1381  5071115 1381  5071130 1381  5071149 1381  5071154 1381  
328676 5071163 1381  5071173 1381  5071177 1381  5071178 1381  5071177 1381  5071177 1381  
328677 5071177 1381  5071173 1381  5071173 1381  5071154 1381  5071150 1379  5071139 1381  
328678 5071115 1381  5071107 1379  5071092 1381  5071072 1381  5071053 1381  5071039 1381  
328679 5071025 1381  5070996 1381  5070981 1381  5070963 1381  5070948 1381  5070924 1381  
328680 5070905 1381  5070891 1381  5070877 1381  5070862 1381  5070848 1381  5070838 1381  
328681 5070824 1381  5070807 1379  5070800 1381  5070800 1381  5070791 1381  5070791 1381  
328682 5070787 1379  5070786 1381  5070786 1381  5070791 1381  5070800 1381  5070805 1381  
328683 5070814 1381  5070826 1379  5070829 1381  5070850 1379  5070862 1381  5070886 1381  
328684 5070902 1379  5070925 1381  5070939 1381  5070963 1381  5070981 1381  5071005 1381  
328685 5071030 1381  5071055 1379  5071077 1381  5071098 1379  5071130 1381  5071154 1381  
328686 5071177 1381  5071197 1381  5071216 1381  5071240 1381  5071265 1379  5071278 1381  
328687 5071292 1381  5071306 1381  5071323 1379  5071331 1381  5071340 1381  5071345 1381  
328688 5071354 1381  5071354 1381  5071345 1381  5071345 1381  5071345 1381  5071341 1379  
328689 5071321 1381  5071316 1381  5071298 1379  5071278 1381  5071264 1381  5071240 1381  
328690 5071221 1381  5071192 1381  5071173 1381  5071139 1381  5071115 1381  5071077 1381  
328691 5071048 1381  5071017 1379  5070977 1381  5070948 1381  5070915 1381  5070886 1381  
328692 5070854 1379  5070814 1381  5070786 1381  5070762 1381  5070729 1381  5070700 1381  
328693 5070673 1379  5070647 1381  5070625 1379  5070604 1381  5070587 1379  5070572 1379  
328694 5070557 1381  5070537 1381  5070529 1379  5070525 1379  5070514 1381  5070515 1379  
328695 5070514 1381  5070514 1381  5070523 1381  5070528 1381  5070537 1381  5070549 1379  
328696 5070561 1381  5070585 1381  5070600 1381  5070614 1381  5070639 1379  5070662 1381  
328697 5070686 1381  5070714 1381  5070738 1381  5070771 1381  5070791 1381  5070824 1381  
328698 5070850 1379  5070876 1381  5070905 1381  5070939 1381  5070963 1381  5070981 1381  
328699 5071015 1381  5071039 1381  5071063 1381  5071082 1381  5071106 1381  5071125 1381  
328700 5071149 1381  5071154 1381  5071173 1381  5071182 1381  5071192 1381  5071197 1381  
328701 5071206 1381  5071206 1381  5071206 1381  5071206 1381  5071206 1381  5071197 1381  
328702 5071192 1381  5071182 1381  5071177 1381  5071163 1381  5071149 1381  5071130 1381  
328703 5071115 1381  5071092 1381  5071077 1381  5071054 1381  5071040 1379  5071015 1381  
328704 5070996 1381  5070977 1381  5070953 1381  5070939 1381  5070915 1381  5070891 1381  
328705 5070877 1381  5070864 1379  5070848 1381  5070829 1381  5070814 1381  5070800 1381  
328706 5070791 1381  5070786 1381  5070781 1381  5070773 1379  5070771 1381  5070762 1381  
328707 5070762 1381  5070771 1381  5070773 1379  5070781 1381  5070786 1381  5070791 1381  
328708 5070805 1381  5070824 1381  5070838 1381  5070853 1381  5070876 1381  5070901 1381  
328709 5070926 1379  5070948 1381  5070972 1381  5070991 1381  5071015 1381  5071048 1381  
328710 5071074 1379  5071092 1381  5071125 1381  5071149 1381  5071173 1381  5071197 1381  
328711 5071221 1381  5071249 1381  5071273 1381  5071282 1381  5071306 1381  5071321 1381  
328712 5071330 1381  5071345 1381  5071354 1381  5071364 1381  5071373 1381  5071373 1381  
328713 5071373 1381  5071364 1381  5071364 1381  5071345 1381  5071340 1381  5071330 1381  
328714 5071306 1381  5071292 1381  5071278 1381  5071254 1381  5071230 1381  5071197 1381  
328715 5071173 1381  5071150 1379  5071115 1381  5071083 1379  5071050 1379  5071007 1379  
328716 5070978 1379  5070950 1379  5070910 1375  5070881 1375  5070843 1375  5070809 1375  
328717 5070773 1379  5070740 1379  5070706 1379  5070687 1379  5070657 1381  5070630 1379  
328718 5070606 1379  5070587 1379  5070572 1379  5070549 1379  5070539 1379  5070525 1379  
328719 5070504 1381  5070499 1381  5070499 1381  5070499 1381  5070499 1381  5070501 1379  
328720 5070505 1379  5070514 1381  5070525 1379  5070537 1381  5070558 1379  5070572 1379  
328721 5070590 1381  5070604 1381  5070630 1379  5070657 1381  5070686 1381  5070705 1381  
328722 5070729 1381  5070762 1381  5070792 1379  5070814 1381  5070848 1381  5070878 1379  
328723 5070900 1381  5070929 1381  5070963 1381  5070981 1381  5071015 1381  5071039 1381  
328724 5071065 1379  5071083 1379  5071096 1381  5071125 1381  5071139 1381  5071155 1379  
328725 5071174 1379  5071179 1379  5071184 1379  5071193 1379  5071196 1375  5071198 1379  
328726 5071198 1379  5071196 1375  5071189 1373  5071190 1371  5071180 1372  5071172 1370  
328727 5071163 1370  5071150 1368  5071136 1368  5071116 1368  5071102 1368  5071083 1368  
328728 5071061 1366  5071042 1366  5071016 1368  5071002 1368  5070983 1368  5070959 1368  
328729 5070935 1368  5070916 1368  5070897 1368  5070871 1370  5070857 1370  5070833 1370  
328730 5070814 1370  5070800 1370  5070789 1371  5070781 1370  5070762 1370  5070757 1370  
328731 5070747 1370  5070738 1370  5070731 1371  5070733 1370  5070730 1373  5070730 1373  
328732 5070736 1371  5070744 1373  5070754 1373  5070757 1375  5070776 1375  5070792 1373  
328733 5070805 1375  5070819 1375  5070843 1375  5070857 1375  5070891 1375  5070910 1375  
328734 5070934 1375  5070967 1375  5070986 1375  5071020 1375  5071043 1375  5071074 1379  
328735 5071096 1375  5071130 1375  5071154 1375  5071179 1379  5071198 1379  5071222 1379  
328736 5071251 1379  5071274 1379  5071294 1379  5071311 1375  5071322 1379  5071344 1375  
328737 5071346 1379  5071356 1379  5071365 1379  5071365 1379  5071365 1379  5071365 1379  
328738 5071365 1379  5071356 1379  5071344 1375  5071325 1375  5071311 1375  5071298 1373  
328739 5071279 1373  5071255 1373  5071228 1371  5071199 1371  5071171 1371  5071148 1370  
328740 5071115 1370  5071087 1370  5071050 1368  5071016 1368  5070981 1370  5070950 1368  
328741 5070911 1368  5070883 1368  5070839 1368  5070811 1368  5070781 1370  5070746 1371  
328742 5070712 1372  5070690 1370  5070666 1370  5070631 1371  5070607 1371  5070594 1370  
328743 5070569 1372  5070556 1370  5070537 1370  5070524 1368  5070513 1370  5070508 1370  
328744 5070499 1370  5070499 1370  5070499 1370  5070508 1370  5070507 1371  5070513 1370  
328745 5070531 1371  5070545 1371  5070564 1372  5070577 1373  5070598 1371  5070610 1373  
328746 5070634 1373  5070663 1373  5070693 1372  5070711 1373  5070736 1371  5070770 1371  
328747 5070792 1373  5070822 1371  5070856 1371  5070879 1372  5070908 1371  5070937 1372  
328748 5070970 1372  5070991 1370  5071024 1370  5071047 1372  5071071 1372  5071090 1371  
328749 5071113 1371  5071134 1370  5071158 1370  5071172 1370  5071180 1371  5071192 1370  
328750 5071199 1371  5071201 1370  5071206 1370  5071206 1370  5071215 1370  5071206 1370  
328751 5071206 1370  5071201 1370  5071192 1370  5071187 1370  5071180 1371  5071163 1370  
328752 5071147 1371  5071123 1371  5071106 1370  5071090 1371  5071082 1370  5071056 1371  
328753 5071037 1372  5071015 1370  5070991 1370  5070972 1370  5070948 1370  5070924 1370  
328754 5070908 1371  5070886 1370  5070862 1370  5070837 1372  5070822 1372  5070808 1372  
328755 5070795 1370  5070779 1372  5070760 1371  5070747 1370  5070736 1371  5070733 1370  
328756 5070722 1372  5070722 1372  5070712 1371  5070720 1373  5070724 1370  5070731 1371  
328757 5070732 1372  5070746 1371  5070754 1373  5070770 1371  5070789 1372  5070806 1373  
328758 5070821 1373  5070845 1373  5070868 1373  5070894 1372  5070911 1373  5070943 1375  
328759 5070969 1373  5070997 1373  5071021 1373  5071055 1373  5071083 1373  5071102 1373  
328760 5071136 1373  5071160 1373  5071190 1371  5071212 1373  5071236 1373  5071262 1371  
328761 5071285 1371  5071300 1371  5071312 1373  5071327 1373  5071346 1373  5071351 1373  
328762 5071361 1373  5071370 1373  5071370 1373  5071371 1371  5071370 1373  5071360 1373  
328763 5071351 1373  5071336 1373  5071325 1375  5071303 1373  5071287 1375  5071278 1375  
328764 5071255 1373  5071225 1375  5071197 1375  5071177 1375  5071145 1373  5071110 1375  
328765 5071082 1375  5071053 1375  5071020 1375  5070986 1375  5070953 1375  5070920 1375  
328766 5070891 1375  5070854 1373  5070830 1373  5070795 1375  5070767 1375  5070735 1373  
328767 5070706 1373  5070687 1373  5070663 1373  5070636 1371  5070622 1372  5070607 1371  
328768 5070593 1371  5070588 1372  5070568 1373  5070563 1373  5070563 1373  5070563 1373  
328769 5070555 1371  5070564 1371  5070563 1373  5070568 1373  5070587 1373  5070591 1373  
328770 5070604 1375  5070620 1373  5070634 1373  5070661 1375  5070687 1373  5070697 1373  
328771 5070721 1373  5070744 1373  5070778 1373  5070806 1373  5070830 1373  5070859 1373  
328772 5070884 1371  5070913 1371  5070946 1371  5070980 1371  5070999 1371  5071032 1371  
328773 5071055 1373  5071085 1371  5071102 1373  5071131 1373  5071155 1373  5071171 1372  
328774 5071189 1373  5071203 1373  5071220 1375  5071227 1373  5071236 1373  5071255 1373  
328775 5071254 1375  5071259 1375  5071259 1375  5071259 1375  5071255 1373  5071246 1373  
328776 5071236 1373  5071227 1373  5071222 1373  5071201 1375  5071189 1373  5071177 1375  
328777 5071158 1375  5071145 1373  5071112 1373  5071096 1375  5071078 1373  5071055 1373  
328778 5071029 1375  5071001 1375  5070983 1373  5070958 1375  5070935 1373  5070911 1373  
328779 5070883 1373  5070860 1371  5070844 1373  5070821 1373  5070797 1373  5070787 1373  
328780 5070767 1375  5070754 1373  5070735 1373  5070728 1375  5070720 1373  5070711 1373  
328781 5070711 1373  5070711 1373  5070711 1373  5070721 1373  5070720 1373  5070730 1373  
328782 5070746 1371  5070759 1373  5070768 1373  5070792 1373  5070808 1371  5070822 1371  
328783 5070844 1373  5070868 1373  5070892 1373  5070911 1373  5070945 1373  5070969 1373  
328784 5070997 1373  5071023 1372  5071056 1371  5071078 1373  5071104 1371  5071131 1373  
328785 5071160 1373  5071184 1373  5071212 1373  5071227 1373  5071255 1373  5071279 1373  
328786 5071289 1373  5071301 1375  5071320 1375  5071327 1373  5071335 1375  5071344 1375  
328787 5071346 1373  5071344 1375  5071344 1375  5071344 1375  5071335 1375  5071327 1373  
328788 5071320 1375  5071303 1373  5071298 1373  5071284 1373  5071260 1373  5071246 1373  
328789 5071211 1375  5071189 1373  5071168 1375  5071134 1375  5071102 1373  5071082 1375  
328790 5071053 1375  5071020 1375  5070986 1375  5070958 1375  5070929 1375  5070896 1375  
328791 5070878 1373  5070844 1373  5070809 1375  5070791 1375  5070757 1375  5070733 1375  
328792 5070709 1375  5070695 1375  5070685 1375  5070662 1375  5070642 1375  5070633 1375  
328793 5070619 1375  5070609 1375  5070609 1375  5070604 1375  5070604 1375  5070610 1373  
328794 5070609 1375  5070609 1375  5070628 1375  5070633 1375  5070639 1379  5070662 1375  
328795 5070673 1379  5070690 1375  5070709 1375  5070730 1379  5070754 1379  5070773 1379  
328796 5070805 1375  5070826 1379  5070850 1379  5070881 1375  5070905 1375  5070934 1375  
328797 5070967 1375  5070983 1379  5071016 1379  5071040 1379  5071064 1379  5071093 1379  
328798 5071120 1375  5071144 1375  5071155 1379  5071183 1373  5071196 1375  5071211 1375  
328799 5071227 1373  5071244 1375  5071254 1375  5071259 1375  5071268 1375  5071270 1373  
328800 5071270 1373  5071270 1373  5071270 1373  5071260 1373  5071255 1373  5071247 1372  
328801 5071238 1371  5071222 1373  5071214 1371  5071200 1372  5071185 1371  5071163 1370  
328802 5071137 1371  5071123 1371  5071090 1371  5071080 1371  5071048 1370  5071024 1370  
328803 5070999 1371  5070970 1371  5070948 1370  5070924 1370  5070900 1370  5070883 1368  
328804 5070857 1370  5070833 1370  5070809 1370  5070795 1370  5070771 1370  5070757 1370  
328805 5070739 1368  5070733 1370  5070725 1368  5070716 1368  5070711 1368  5070701 1368  
328806 5070701 1368  5070701 1368  5070699 1370  5070711 1368  5070716 1368  5070725 1368  
328807 5070738 1370  5070749 1368  5070771 1370  5070790 1370  5070800 1370  5070824 1370  
328808 5070847 1370  5070873 1368  5070896 1370  5070916 1368  5070938 1370  5070972 1370  
328809 5070991 1370  5071024 1370  5071050 1368  5071072 1370  5071101 1370  5071126 1368  
328810 5071150 1368  5071174 1368  5071188 1368  5071207 1368  5071225 1370  5071242 1366  
328811 5071260 1368  5071273 1370  5071290 1366  5071294 1368  5071295 1366  5071303 1368  
328812 5071303 1368  5071304 1366  5071303 1368  5071293 1368  5071289 1368  5071284 1368  
328813 5071273 1370  5071258 1370  5071239 1370  5071225 1370  5071206 1370  5071187 1370  
328814 5071163 1370  5071137 1371  5071115 1370  5071090 1371  5071071 1371  5071048 1370  
328815 5071013 1372  5070985 1371  5070961 1371  5070932 1372  5070908 1371  5070886 1370  
328816 5070862 1370  5070832 1371  5070808 1371  5070789 1371  5070760 1372  5070746 1371  
328817 5070722 1372  5070709 1370  5070693 1371  5070687 1373  5070669 1371  5070663 1373  
328818 5070657 1370  5070655 1372  5070645 1372  5070645 1372  5070644 1373  5070654 1373  
328819 5070655 1372  5070668 1373  5070679 1371  5070692 1373  5070696 1373  5070711 1373  
328820 5070735 1373  5070756 1372  5070768 1373  5070792 1373  5070811 1373  5070830 1373  
328821 5070854 1373  5070883 1373  5070907 1373  5070931 1373  5070959 1373  5070983 1373  
328822 5071002 1373  5071036 1373  5071060 1373  5071083 1373  5071102 1373  5071131 1373  
328823 5071145 1373  5071171 1371  5071183 1373  5071200 1371  5071214 1371  5071228 1371  
328824 5071238 1371  5071246 1373  5071257 1371  5071257 1371  5071262 1371  5071262 1372  
328825 5071262 1371  5071257 1371  5071257 1371  5071247 1371  5071238 1371  5071225 1370  
328826 5071214 1371  5071200 1372  5071187 1370  5071161 1371  5071149 1370  5071123 1371  
328827 5071099 1371  5071080 1372  5071056 1372  5071023 1372  5070998 1373  5070980 1372  
328828 5070946 1372  5070923 1372  5070899 1371  5070870 1372  5070846 1372  5070822 1372  
328829 5070798 1372  5070778 1373  5070759 1373  5070746 1372  5070730 1373  5070712 1372  
328830 5070697 1373  5070692 1373  5070687 1373  5070677 1373  5070668 1373  5070668 1373  
328831 5070668 1373  5070668 1373  5070666 1375  5070677 1373  5070687 1373  5070690 1375  
328832 5070706 1373  5070711 1373  5070730 1373  5070744 1373  5070768 1373  5070786 1375  
328833 5070806 1373  5070830 1373  5070854 1373  5070876 1375  5070897 1373  5070921 1373  
328834 5070945 1373  5070969 1373  5070988 1373  5071012 1373  5071036 1373  5071060 1373  
328835 5071083 1373  5071102 1373  5071122 1373  5071145 1373  5071160 1373  5071179 1373  
328836 5071189 1373  5071198 1373  5071212 1373  5071222 1373  5071224 1371  5071227 1373  
328837 5071227 1373  5071228 1372  5071227 1373  5071230 1370  5071222 1373  5071214 1371  
328838 5071204 1372  5071190 1372  5071185 1371  5071171 1371  5071157 1371  5071137 1371  
328839 5071122 1373  5071099 1371  5071083 1373  5071061 1371  5071035 1373  5071012 1373  
328840 5070989 1371  5070970 1371  5070945 1373  5070923 1372  5070897 1373  5070876 1375  
328841 5070854 1373  5070835 1373  5070809 1375  5070797 1373  5070787 1373  5070768 1373  
328842 5070754 1373  5070735 1373  5070730 1373  5070721 1373  5070711 1373  5070706 1373  
328843 5070696 1373  5070693 1372  5070692 1373  5070692 1373  5070698 1371  5070708 1372  
328844 5070706 1373  5070711 1373  5070722 1371  5070735 1373  5070754 1373  5070770 1371  
328845 5070794 1371  5070806 1373  5070832 1372  5070845 1373  5070869 1373  5070892 1373  
328846 5070911 1373  5070937 1371  5070961 1371  5070985 1372  5071002 1373  5071032 1371  
328847 5071055 1373  5071078 1373  5071098 1373  5071122 1373  5071145 1373  5071161 1371  
328848 5071179 1373  5071198 1373  5071214 1371  5071228 1372  5071247 1372  5071256 1373  
328849 5071271 1372  5071271 1371  5071281 1371  5071285 1371  5071285 1372  5071285 1371  
328850 5071285 1372  5071281 1371  5071262 1372  5071257 1371  5071246 1373  5071228 1371  
328851 5071214 1371  5071200 1372  5071180 1371  5071161 1371  5071137 1371  5071113 1372  
328852 5071088 1373  5071071 1371  5071047 1371  5071023 1371  5070988 1373  5070970 1371  
328853 5070946 1371  5070923 1372  5070899 1371  5070870 1371  5070846 1371  5070832 1371  
328854 5070808 1371  5070789 1371  5070759 1373  5070746 1371  5070732 1372  5070712 1371  
328855 5070697 1373  5070693 1371  5070689 1371  5070677 1373  5070669 1371  5070669 1371  
328856 5070669 1371  5070668 1373  5070668 1373  5070677 1373  5070679 1371  5070692 1373  
328857 5070696 1373  5070706 1373  5070720 1373  5070735 1373  5070754 1373  5070768 1373  
328858 5070792 1373  5070808 1371  5070830 1373  5070844 1373  5070870 1371  5070892 1373  
328859 5070913 1371  5070937 1371  5070959 1373  5070983 1373  5071004 1371  5071031 1373  
328860 5071045 1373  5071069 1373  5071090 1372  5071102 1373  5071123 1371  5071136 1373  
328861 5071155 1373  5071169 1373  5071180 1372  5071184 1373  5071189 1373  5071200 1371  
328862 5071198 1373  5071204 1372  5071204 1371  5071204 1371  5071200 1372  5071200 1371  
328863 5071192 1370  5071180 1372  5071172 1370  5071163 1370  5071148 1370  5071139 1370  
328864 5071123 1371  5071104 1371  5071091 1370  5071071 1371  5071055 1373  5071031 1373  
328865 5071013 1371  5070989 1371  5070980 1371  5070956 1371  5070937 1371  5070913 1371  
328866 5070899 1371  5070883 1373  5070870 1372  5070844 1373  5070830 1373  5070822 1371  
328867 5070806 1373  5070797 1373  5070792 1373  5070787 1373  5070778 1373  5070769 1371  
328868 5070768 1373  5070759 1373  5070759 1373  5070760 1371  5070768 1373  5070779 1371  
328869 5070778 1373  5070789 1371  5070798 1371  5070812 1371  5070822 1371  5070835 1373  
328870 5070854 1373  5070868 1373  5070883 1373  5070908 1372  5070923 1371  5070946 1372  
328871 5070958 1375  5070983 1373  5071012 1373  5071036 1373  5071060 1373  5071085 1372  
328872 5071102 1373  5071122 1373  5071147 1372  5071169 1373  5071183 1373  5071204 1371  
328873 5071222 1373  5071236 1373  5071246 1373  5071260 1373  5071271 1371  5071285 1371  
328874 5071284 1373  5071289 1373  5071290 1371  5071290 1371  5071290 1371  5071290 1371  
328875 5071285 1372  5071281 1371  5071271 1371  5071255 1373  5071247 1371  5071227 1373  
328876 5071214 1371  5071190 1371  5071179 1373  5071155 1373  5071133 1371  5071104 1371  
328877 5071083 1373  5071061 1371  5071037 1371  5071013 1371  5070989 1371  5070970 1371  
328878 5070946 1371  5070913 1371  5070894 1371  5070870 1371  5070846 1371  5070822 1371  
328879 5070797 1373  5070789 1371  5070760 1371  5070736 1371  5070731 1371  5070707 1371  
328880 5070693 1372  5070688 1371  5070669 1371  5070665 1371  5070654 1373  5070655 1371  
328881 5070645 1371  5070645 1371  5070645 1371  5070644 1373  5070654 1373  5070663 1373  
328882 5070669 1371  5070679 1371  5070693 1371  5070698 1372  5070711 1373  5070722 1371  
328883 5070746 1371  5070760 1371  5070779 1371  5070797 1373  5070822 1371  5070835 1373  
328884 5070860 1371  5070883 1373  5070907 1373  5070923 1371  5070946 1371  5070970 1371  
328885 5070988 1373  5071004 1371  5071032 1371  5071047 1371  5071069 1373  5071085 1371  
328886 5071099 1371  5071115 1370  5071125 1370  5071139 1370  5071147 1371  5071157 1371  
328887 5071161 1371  5071172 1370  5071172 1370  5071171 1371  5071172 1370  5071172 1370  
328888 5071172 1370  5071163 1370  5071157 1371  5071147 1371  5071137 1371  5071133 1371  
328889 5071123 1372  5071104 1371  5071091 1370  5071080 1371  5071061 1371  5071047 1371  
328890 5071023 1371  5071004 1371  5070989 1371  5070980 1371  5070961 1372  5070946 1371  
328891 5070923 1371  5070908 1371  5070894 1372  5070880 1372  5070862 1370  5070847 1370  
328892 5070838 1370  5070825 1368  5070816 1368  5070811 1368  5070801 1368  5070797 1368  
328893 5070795 1370  5070795 1370  5070795 1370  5070797 1368  5070797 1368  5070797 1368  
328894 5070801 1368  5070811 1368  5070816 1368  5070825 1368  5070839 1368  5070859 1368  
328895 5070863 1368  5070887 1368  5070902 1368  5070916 1368  5070938 1370  5070959 1368  
328896 5070981 1370  5070991 1370  5071016 1368  5071040 1368  5071059 1368  5071083 1368  
328897 5071094 1366  5071118 1366  5071137 1366  5071163 1364  5071177 1364  5071191 1364  
328898 5071206 1364  5071220 1364  5071234 1364  5071244 1364  5071254 1364  5071266 1360  
328899 5071271 1360  5071272 1358  5071272 1358  5071282 1358  5071274 1356  5071272 1358  
328900 5071268 1358  5071258 1358  5071247 1360  5071239 1358  5071234 1358  5071216 1356  
328901 5071201 1358  5071191 1358  5071172 1358  5071148 1358  5071132 1360  5071100 1358  
328902 5071080 1360  5071056 1360  5071032 1360  5071008 1360  5070989 1360  5070956 1360  
328903 5070932 1360  5070905 1364  5070886 1364  5070855 1360  5070828 1364  5070807 1360  
328904 5070788 1360  5070765 1360  5070736 1366  5070714 1364  5070695 1364  5070675 1364  
328905 5070661 1364  5070640 1366  5070628 1364  5070617 1366  5070604 1364  5070597 1366  
328906 5070593 1366  5070583 1366  5070583 1366  5070583 1366  5070583 1366  5070582 1368  
328907 5070591 1368  5070591 1368  5070601 1368  5070610 1368  5070615 1368  5070636 1366  
328908 5070650 1366  5070669 1366  5070684 1366  5070696 1368  5070716 1368  5070739 1368  
328909 5070763 1368  5070792 1368  5070811 1368  5070835 1368  5070859 1368  5070883 1368  
328910 5070897 1368  5070916 1368  5070938 1370  5070959 1368  5070983 1368  5071002 1368  
328911 5071015 1370  5071035 1368  5071059 1368  5071072 1370  5071083 1368  5071091 1370  
328912 5071105 1370  5071115 1370  5071115 1370  5071125 1370  5071125 1370  5071134 1370  
328913 5071134 1370  5071125 1370  5071125 1370  5071126 1368  5071105 1370  5071101 1370  
328914 5071091 1370  5071087 1370  5071072 1370  5071058 1370  5071048 1370  5071034 1370  
328915 5071013 1371  5070999 1372  5070985 1371  5070961 1371  5070946 1371  5070932 1371  
328916 5070913 1371  5070899 1371  5070884 1371  5070870 1372  5070856 1372  5070837 1372  
328917 5070822 1371  5070813 1372  5070809 1370  5070794 1371  5070789 1372  5070779 1371  
328918 5070779 1371  5070768 1373  5070770 1371  5070770 1372  5070779 1371  5070778 1373  
328919 5070778 1373  5070789 1371  5070794 1372  5070798 1371  5070806 1373  5070822 1372  
328920 5070837 1372  5070856 1372  5070870 1372  5070885 1372  5070908 1372  5070923 1371  
328921 5070946 1371  5070970 1371  5070985 1371  5071004 1371  5071032 1371  5071056 1371  
328922 5071072 1370  5071090 1371  5071104 1372  5071133 1371  5071148 1370  5071161 1371  
328923 5071180 1371  5071189 1373  5071204 1371  5071223 1371  5071228 1371  5071239 1370  
328924 5071247 1371  5071247 1371  5071257 1372  5071257 1371  5071262 1371  5071262 1371  
328925 5071257 1371  5071247 1371  5071236 1373  5071227 1373  5071212 1373  5071203 1373  
328926 5071187 1375  5071179 1373  5071158 1375  5071144 1375  5071120 1375  5071096 1375  
328927 5071077 1375  5071053 1375  5071029 1375  5070996 1375  5070977 1375  5070943 1375  
328928 5070916 1379  5070891 1375  5070864 1379  5070833 1375  5070809 1375  5070786 1375  
328929 5070757 1375  5070725 1379  5070701 1379  5070682 1379  5070658 1379  5070630 1379  
328930 5070616 1379  5070592 1379  5070582 1379  5070563 1379  5070558 1379  5070537 1381  
328931 5070523 1381  5070523 1381  5070514 1381  5070515 1379  5070514 1381  5070514 1381  
328932 5070523 1381  5070523 1381  5070529 1379  5070538 1381  5070557 1381  5070561 1381  
328933 5070581 1381  5070600 1381  5070616 1379  5070638 1381  5070657 1381  5070681 1381  
328934 5070701 1379  5070725 1379  5070749 1379  5070783 1379  5070805 1375  5070830 1373  
328935 5070853 1375  5070881 1375  5070910 1375  5070931 1373  5070956 1371  5070980 1372  
328936 5070999 1371  5071024 1370  5071037 1371  5071058 1370  5071071 1371  5071086 1370  
328937 5071091 1370  5071107 1368  5071115 1370  5071126 1368  5071136 1368  5071134 1370  
328938 5071136 1368  5071136 1368  5071136 1368  5071126 1368  5071118 1366  5071109 1366  
328939 5071104 1366  5071096 1364  5071085 1366  5071066 1366  5071053 1364  5071037 1366  
328940 5071019 1364  5071004 1366  5070989 1366  5070976 1364  5070953 1364  5070938 1364  
328941 5070919 1364  5070898 1366  5070891 1364  5070870 1360  5070852 1364  5070838 1364  
328942 5070819 1364  5070817 1360  5070803 1360  5070795 1364  5070788 1360  5070776 1364  
328943 5070766 1364  5070769 1360  5070765 1360  5070765 1360  5070765 1360  5070766 1358  
328944 5070769 1360  5070769 1360  5070779 1360  5070798 1360  5070804 1364  5070822 1360  
328945 5070831 1360  5070846 1360  5070870 1360  5070886 1364  5070908 1360  5070932 1360  
328946 5070953 1364  5070970 1360  5070994 1360  5071010 1364  5071038 1364  5071056 1360  
328947 5071077 1364  5071099 1360  5071113 1360  5071142 1360  5071166 1360  5071177 1364  
328948 5071194 1360  5071209 1360  5071223 1360  5071237 1360  5071257 1360  5071266 1360  
328949 5071271 1360  5071280 1360  5071287 1364  5071290 1360  5071290 1360  5071287 1364  
328950 5071290 1360  5071280 1360  5071271 1360  5071266 1360  5071247 1360  5071233 1360  
328951 5071223 1360  5071199 1360  5071190 1360  5071167 1364  5071146 1360  5071123 1360  
328952 5071099 1360  5071067 1364  5071041 1360  5071008 1360  5070976 1364  5070953 1364  
328953 5070917 1360  5070889 1360  5070855 1360  5070831 1360  5070800 1364  5070769 1360  
328954 5070737 1364  5070714 1364  5070688 1360  5070661 1364  5070628 1364  5070604 1364  
328955 5070585 1364  5070561 1364  5070540 1366  5070527 1364  5070512 1366  5070503 1364  
328956 5070494 1364  5070485 1364  5070483 1366  5070475 1364  5070475 1364  5070473 1366  
328957 5070475 1364  5070485 1364  5070493 1366  5070499 1364  5070513 1364  5070526 1366  
328958 5070542 1364  5070559 1366  5070583 1366  5070604 1364  5070618 1364  5070652 1364  
328959 5070675 1364  5070699 1364  5070728 1364  5070762 1364  5070786 1364  5070812 1366  
328960 5070843 1364  5070866 1364  5070898 1366  5070929 1364  5070953 1364  5070975 1366  
328961 5071005 1364  5071029 1364  5071042 1366  5071067 1364  5071086 1364  5071094 1366  
328962 5071110 1364  5071120 1364  5071132 1360  5071137 1366  5071143 1364  5071143 1364  
328963 5071144 1364  5071144 1364  5071143 1364  5071139 1364  5071129 1364  5071120 1364  
328964 5071113 1360  5071096 1364  5071086 1364  5071076 1364  5071065 1360  5071043 1364  
328965 5071019 1364  5071005 1364  5070994 1360  5070967 1364  5070956 1360  5070932 1360  
328966 5070914 1364  5070900 1364  5070876 1364  5070862 1364  5070846 1360  5070831 1360  
328967 5070817 1360  5070798 1366  5070795 1364  5070776 1364  5070765 1366  5070760 1366  
328968 5070760 1366  5070752 1364  5070750 1366  5070750 1366  5070750 1366  5070760 1366  
328969 5070765 1366  5070774 1366  5070782 1368  5070792 1368  5070797 1368  5070816 1368  
328970 5070825 1368  5070849 1368  5070863 1368  5070889 1366  5070902 1368  5070927 1366  
328971 5070950 1368  5070964 1368  5070988 1368  5071007 1368  5071037 1366  5071059 1368  
328972 5071083 1368  5071102 1368  5071136 1368  5071150 1368  5071175 1366  5071195 1366  
328973 5071209 1366  5071233 1366  5071252 1366  5071268 1364  5071285 1366  5071296 1364  
328974 5071304 1366  5071311 1364  5071319 1366  5071318 1366  5071319 1366  5071319 1366  
328975 5071311 1364  5071311 1364  5071306 1364  5071290 1366  5071285 1366  5071266 1366  
328976 5071253 1364  5071229 1364  5071210 1364  5071191 1364  5071167 1364  5071139 1364  
328977 5071108 1366  5071085 1366  5071051 1366  5071018 1366  5070989 1366  5070951 1366  
328978 5070918 1366  5070884 1366  5070852 1364  5070817 1366  5070784 1366  5070750 1366  
328979 5070719 1364  5070693 1366  5070661 1364  5070628 1364  5070604 1364  5070573 1366  
328980 5070551 1364  5070527 1364  5070512 1366  5070492 1366  5070475 1364  5070468 1366  
328981 5070451 1364  5070451 1364  5070446 1364  5070437 1364  5070435 1366  5070445 1366  
328982 5070451 1364  5070461 1364  5070468 1366  5070483 1366  5070497 1366  5070512 1366  
328983 5070526 1366  5070551 1364  5070573 1366  5070597 1366  5070626 1366  5070660 1366  
328984 5070693 1366  5070714 1364  5070741 1366  5070784 1366  5070812 1366  5070841 1366  
328985 5070874 1366  5070903 1366  5070937 1366  5070965 1366  5070988 1368  5071018 1366  
328986 5071042 1366  5071064 1368  5071083 1368  5071102 1368  5071116 1368  5071136 1368  
328987 5071141 1368  5071160 1368  5071164 1368  5071164 1368  5071172 1370  5071172 1370  
328988 5071174 1368  5071163 1370  5071163 1370  5071160 1368  5071148 1370  5071134 1370  
328989 5071125 1370  5071104 1371  5071087 1370  5071071 1371  5071056 1371  5071031 1373  
328990 5071013 1371  5070989 1371  5070970 1371  5070954 1373  5070932 1371  5070908 1371  
328991 5070884 1371  5070870 1371  5070844 1373  5070830 1373  5070811 1373  5070797 1373  
328992 5070787 1373  5070770 1371  5070760 1371  5070754 1373  5070744 1373  5070735 1373  
328993 5070728 1375  5070730 1373  5070730 1373  5070730 1373  5070735 1373  5070733 1375  
328994 5070743 1375  5070752 1375  5070764 1379  5070773 1379  5070787 1379  5070805 1375  
328995 5070814 1381  5070840 1379  5070854 1379  5070878 1379  5070900 1381  5070926 1379  
328996 5070950 1379  5070974 1379  5070993 1379  5071026 1379  5071050 1379  5071079 1379  
328997 5071096 1381  5071131 1379  5071154 1381  5071177 1381  5071197 1381  5071221 1381  
328998 5071249 1381  5071263 1381  5071283 1381  5071297 1381  5071316 1381  5071319 1383  
328999 5071330 1381  5071340 1381  5071343 1383  5071343 1383  5071343 1383  5071343 1383  
329000 5071338 1383  5071329 1383  5071314 1383  5071305 1383  5071291 1383  5071278 1381  
329001 5071254 1381  5071230 1381  5071206 1381  5071177 1381  5071154 1381  5071127 1379  
329002 5071092 1381  5071063 1381  5071029 1381  5070993 1379  5070953 1381  5070926 1379  
329003 5070886 1381  5070848 1381  5070814 1381  5070787 1379  5070749 1379  5070716 1379  
329004 5070687 1379  5070658 1379  5070625 1379  5070595 1375  5070572 1379  5070552 1375  
329005 5070525 1379  5070506 1379  5070490 1375  5070472 1379  5070466 1375  5070458 1379  
329006 5070439 1379  5070442 1375  5070439 1379  5070442 1375  5070439 1379  5070448 1379  
329007 5070461 1375  5070472 1379  5070485 1375  5070504 1375  5070518 1375  5070542 1375  
329008 5070563 1379  5070587 1379  5070616 1379  5070638 1381  5070673 1379  5070701 1379  
329009 5070730 1379  5070766 1375  5070792 1379  5070826 1379  5070857 1375  5070893 1379  
329010 5070929 1375  5070958 1375  5070978 1379  5071010 1375  5071034 1375  5071058 1375  
329011 5071083 1379  5071101 1375  5071130 1375  5071134 1375  5071154 1375  5071165 1379  
329012 5071177 1375  5071182 1375  5071187 1375  5071187 1375  5071187 1375  5071187 1375  
329013 5071184 1379  5071179 1379  5071174 1379  5071155 1379  5071150 1379  5071130 1381  
329014 5071115 1381  5071098 1379  5071077 1381  5071064 1379  5071040 1379  5071016 1379  
329015 5070993 1379  5070974 1379  5070950 1379  5070926 1379  5070902 1379  5070881 1375  
329016 5070854 1379  5070840 1379  5070819 1375  5070802 1379  5070787 1379  5070773 1379  
329017 5070754 1379  5070740 1379  5070730 1379  5070725 1379  5070716 1379  5070716 1379  
329018 5070706 1379  5070709 1375  5070709 1375  5070709 1375  5070716 1379  5070725 1379  
329019 5070730 1379  5070740 1379  5070754 1379  5070771 1381  5070786 1381  5070806 1379  
329020 5070824 1381  5070850 1379  5070877 1381  5070900 1381  5070926 1379  5070948 1381  
329021 5070977 1381  5071006 1381  5071039 1381  5071063 1381  5071092 1381  5071125 1381  
329022 5071149 1381  5071177 1381  5071197 1381  5071221 1381  5071247 1383  5071278 1381  
329023 5071292 1381  5071306 1381  5071321 1381  5071340 1381  5071354 1381  5071364 1381  
329024 5071375 1379  5071375 1379  5071380 1379  5071378 1375  5071379 1373  5071368 1375  
329025 5071360 1373  5071351 1373  5071338 1371  5071324 1371  5071303 1373  5071285 1371  
329026 5071262 1371  5071228 1371  5071206 1370  5071180 1371  5071148 1370  5071105 1370  
329027 5071082 1370  5071048 1370  5071005 1370  5070972 1370  5070934 1370  5070900 1370  
329028 5070860 1371  5070824 1370  5070795 1370  5070755 1371  5070723 1370  5070696 1368  
329029 5070666 1370  5070633 1370  5070609 1370  5070590 1370  5070556 1370  5070537 1370  
329030 5070513 1370  5070497 1371  5070489 1370  5070478 1371  5070470 1370  5070465 1370  
329031 5070464 1371  5070465 1370  5070465 1370  5070470 1370  5070478 1371  5070488 1371  
329032 5070497 1371  5070512 1371  5070537 1370  5070566 1370  5070580 1370  5070609 1370  
329033 5070633 1370  5070666 1370  5070688 1371  5070712 1371  5070747 1370  5070781 1370  
329034 5070809 1370  5070836 1371  5070879 1371  5070908 1371  5070937 1371  5070970 1371  
329035 5070999 1371  5071023 1371  5071056 1371  5071080 1371  5071099 1371  5071123 1371  
329036 5071147 1371  5071161 1371  5071182 1370  5071189 1373  5071198 1373  5071203 1373  
329037 5071214 1371  5071212 1373  5071214 1371  5071214 1372  5071214 1371  5071204 1371  
329038 5071199 1371  5071185 1372  5071179 1373  5071161 1371  5071147 1371  5071123 1371  
329039 5071104 1371  5071085 1371  5071061 1371  5071037 1371  5071015 1370  5070991 1370  
329040 5070970 1371  5070946 1371  5070923 1371  5070899 1371  5070879 1371  5070856 1371  
329041 5070832 1371  5070812 1371  5070792 1373  5070779 1371  5070760 1371  5070746 1371  
329042 5070736 1371  5070733 1370  5070722 1371  5070709 1370  5070707 1371  5070707 1371  
329043 5070698 1371  5070698 1371  5070708 1372  5070707 1371  5070712 1371  5070722 1372  
329044 5070735 1373  5070760 1371  5070779 1372  5070792 1373  5070808 1372  5070832 1371  
329045 5070856 1371  5070879 1371  5070899 1371  5070931 1373  5070954 1373  5070985 1371  
329046 5071004 1371  5071035 1373  5071070 1371  5071090 1371  5071123 1371  5071157 1372  
329047 5071180 1371  5071204 1371  5071230 1370  5071257 1371  5071282 1370  5071301 1370  
329048 5071314 1371  5071329 1371  5071347 1371  5071352 1371  5071371 1371  5071373 1370  
329049 5071379 1373  5071381 1371  5071381 1371  5071371 1371  5071371 1371  5071352 1371  
329050 5071338 1371  5071324 1371  5071305 1371  5071285 1371  5071262 1372  5071239 1370  
329051 5071214 1371  5071185 1371  5071158 1370  5071123 1371  5071090 1371  5071061 1371  
329052 5071023 1371  5070985 1371  5070956 1371  5070913 1371  5070886 1370  5070846 1371  
329053 5070814 1370  5070789 1371  5070755 1371  5070720 1373  5070693 1372  5070663 1373  
329054 5070634 1373  5070612 1371  5070591 1373  5070567 1373  5070555 1371  5070534 1373  
329055 5070520 1373  5070510 1373  5070510 1373  5070507 1371  5070505 1373  5070505 1373  
329056 5070507 1372  5070510 1373  5070518 1375  5070533 1375  5070552 1375  5070566 1375  
329057 5070585 1375  5070604 1375  5070619 1375  5070649 1379  5070676 1375  5070692 1379  
329058 5070729 1375  5070757 1375  5070783 1379  5070809 1375  5070840 1379  5070876 1375  
329059 5070905 1375  5070931 1379  5070964 1379  5070993 1379  5071026 1379  5071050 1379  
329060 5071079 1379  5071096 1381  5071125 1381  5071150 1379  5071174 1379  5071184 1379  
329061 5071198 1379  5071216 1381  5071222 1379  5071235 1375  5071244 1375  5071244 1375  
329062 5071246 1373  5071246 1373  5071236 1373  5071225 1375  5071222 1373  5071212 1373  
329063 5071197 1375  5071189 1373  5071179 1373  5071160 1373  5071136 1373  5071112 1373  
329064 5071088 1373  5071077 1375  5071055 1373  5071031 1373  5070998 1373  5070983 1373  
329065 5070955 1373  5070929 1375  5070905 1375  5070883 1373  5070859 1373  5070844 1373  
329066 5070819 1375  5070795 1375  5070787 1373  5070768 1373  5070752 1375  5070743 1375  
329067 5070730 1373  5070719 1375  5070719 1375  5070711 1373  5070709 1375  5070709 1375  
329068 5070709 1375  5070719 1375  5070728 1375  5070733 1375  5070752 1375  5070763 1379  
329069 5070787 1373  5070795 1375  5070810 1375  5070835 1373  5070858 1375  5070881 1375  
329070 5070905 1375  5070929 1375  5070958 1375  5070981 1375  5071010 1375  5071034 1375  
329071 5071068 1375  5071096 1375  5071122 1373  5071155 1373  5071177 1375  5071203 1373  
329072 5071225 1375  5071254 1375  5071279 1373  5071298 1373  5071312 1373  5071326 1375  
329073 5071336 1373  5071351 1373  5071361 1373  5071360 1373  5071371 1371  5071370 1373  
329074 5071370 1373  5071370 1373  5071360 1373  5071351 1373  5071336 1373  5071324 1371  
329075 5071303 1373  5071289 1373  5071270 1373  5071246 1373  5071224 1371  5071200 1371  
329076 5071169 1373  5071137 1371  5071104 1371  5071080 1372  5071047 1371  5071013 1372  
329077 5070985 1372  5070956 1372  5070913 1371  5070885 1372  5070854 1373  5070821 1373  
329078 5070794 1372  5070770 1372  5070736 1371  5070711 1373  5070693 1372  5070669 1371  
329079 5070644 1373  5070631 1371  5070612 1372  5070598 1372  5070588 1372  5070577 1373  
329080 5070568 1373  5070567 1373  5070569 1372  5070569 1372  5070569 1371  5070577 1373  
329081 5070591 1373  5070596 1373  5070610 1373  5070630 1373  5070645 1371  5070663 1373  
329082 5070687 1373  5070706 1373  5070730 1373  5070755 1371  5070778 1373  5070806 1373  
329083 5070835 1373  5070859 1373  5070892 1373  5070921 1373  5070955 1373  5070983 1373  
329084 5071002 1373  5071034 1375  5071069 1373  5071088 1373  5071112 1373  5071134 1375  
329085 5071160 1373  5071183 1373  5071196 1375  5071212 1373  5071227 1373  5071244 1375  
329086 5071255 1373  5071259 1375  5071260 1373  5071270 1373  5071259 1375  5071259 1375  
329087 5071254 1375  5071244 1375  5071235 1375  5071225 1375  5071211 1375  5071201 1375  
329088 5071187 1375  5071168 1375  5071154 1375  5071130 1375  5071112 1373  5071088 1373  
329089 5071064 1379  5071043 1375  5071020 1375  5070983 1379  5070967 1375  5070943 1375  
329090 5070920 1375  5070896 1375  5070876 1375  5070853 1375  5070830 1379  5070809 1375  
329091 5070787 1379  5070776 1375  5070757 1375  5070749 1379  5070740 1379  5070730 1379  
329092 5070728 1375  5070719 1375  5070716 1379  5070716 1379  5070719 1375  5070716 1379  
329093 5070725 1379  5070730 1379  5070749 1379  5070754 1379  5070776 1375  5070787 1379  
329094 5070806 1379  5070824 1381  5070848 1381  5070873 1379  5070891 1381  5070905 1381  
329095 5070940 1379  5070974 1379  5070993 1379  5071026 1379  5071050 1379  5071079 1379  
329096 5071098 1379  5071127 1379  5071149 1381  5071174 1379  5071192 1381  5071217 1379  
329097 5071244 1375  5071256 1379  5071274 1379  5071284 1379  5071302 1375  5071311 1375  
329098 5071320 1375  5071325 1375  5071335 1375  5071335 1375  5071335 1375  5071325 1375  
329099 5071320 1375  5071311 1375  5071301 1375  5071297 1375  5071282 1375  5071259 1375  
329100 5071244 1375  5071220 1375  5071201 1375  5071182 1375  5071154 1375  5071130 1375  
329101 5071093 1379  5071067 1375  5071043 1375  5071010 1375  5070981 1375  5070953 1375  
329102 5070920 1375  5070891 1375  5070867 1375  5070833 1375  5070809 1375  5070787 1379  
329103 5070757 1375  5070735 1373  5070719 1375  5070692 1379  5070685 1375  5070666 1375  
329104 5070652 1375  5070642 1375  5070633 1375  5070619 1375  5070619 1375  5070619 1375  
329105 5070616 1379  5070616 1379  5070619 1375  5070625 1379  5070630 1379  5070649 1379  
329106 5070658 1379  5070676 1375  5070687 1379  5070704 1375  5070728 1375  5070740 1379  
329107 5070763 1379  5070791 1375  5070809 1375  5070834 1375  5070854 1379  5070891 1375  
329108 5070910 1375  5070940 1379  5070967 1375  5070993 1379  5071016 1379  5071050 1379  
329109 5071077 1375  5071096 1375  5071120 1375  5071131 1379  5071158 1375  5071174 1379  
329110 5071187 1375  5071198 1379  5071208 1379  5071221 1375  5071225 1375  5071235 1375  
329111 5071235 1375  5071235 1375  5071235 1375  5071232 1379  5071225 1375  5071217 1379  
329112 5071211 1375  5071201 1375  5071187 1375  5071174 1379  5071158 1375  5071141 1379  
329113 5071120 1375  5071101 1375  5071082 1375  5071058 1375  5071034 1375  5071007 1379  
329114 5070983 1379  5070964 1379  5070943 1375  5070920 1375  5070893 1379  5070876 1375  
329115 5070850 1379  5070826 1379  5070805 1375  5070788 1379  5070773 1379  5070754 1379  
329116 5070730 1379  5070725 1379  5070716 1379  5070706 1379  5070700 1381  5070690 1381  
329117 5070690 1381  5070690 1381  5070690 1381  5070690 1381  5070700 1381  5070705 1381  
329118 5070714 1381  5070724 1381  5070738 1381  5070754 1379  5070773 1379  5070786 1381  
329119 5070806 1379  5070829 1381  5070854 1379  5070873 1379  5070892 1379  5070915 1381  
329120 5070939 1381  5070963 1381  5070983 1379  5071016 1379  5071040 1379  5071055 1379  
329121 5071082 1381  5071096 1381  5071125 1381  5071149 1381  5071163 1381  5071177 1381  
329122 5071192 1381  5071206 1381  5071221 1381  5071230 1381  5071240 1381  5071249 1381  
329123 5071249 1381  5071249 1381  5071249 1381  5071249 1381  5071249 1381  5071238 1383  
329124 5071230 1381  5071216 1381  5071205 1383  5071190 1383  5071177 1381  5071163 1381  
329125 5071139 1381  5071125 1381  5071095 1383  5071076 1383  5071047 1383  5071023 1383  
329126 5070996 1381  5070971 1383  5070947 1383  5070921 1385  5070897 1385  5070872 1386  
329127 5070850 1385  5070824 1386  5070800 1387  5070784 1388  5070765 1388  5070745 1390  
329128 5070721 1390  5070708 1388  5070697 1390  5070684 1388  5070678 1390  5070664 1390  
329129 5070664 1390  5070653 1392  5070654 1390  5070649 1390  5070649 1390  5070654 1390  
329130 5070654 1390  5070662 1392  5070673 1390  5070681 1392  5070692 1390  5070706 1390  
329131 5070716 1390  5070740 1390  5070754 1390  5070773 1390  5070793 1390  5070817 1390  
329132 5070831 1390  5070855 1390  5070878 1390  5070898 1390  5070922 1390  5070955 1390  
329133 5070974 1390  5070998 1390  5071023 1388  5071041 1390  5071066 1388  5071084 1390  
329134 5071100 1388  5071124 1388  5071143 1388  5071156 1390  5071171 1388  5071176 1388  
329135 5071191 1388  5071200 1388  5071210 1388  5071209 1388  5071213 1390  5071216 1387  
329136 5071209 1388  5071209 1388  5071200 1388  5071191 1388  5071187 1386  5071173 1386  
329137 5071168 1386  5071149 1386  5071135 1386  5071121 1387  5071101 1387  5071087 1386  
329138 5071072 1386  5071049 1386  5071025 1386  5071002 1385  5070977 1386  5070958 1386  
329139 5070934 1386  5070910 1386  5070887 1387  5070869 1385  5070850 1385  5070826 1385  
329140 5070811 1385  5070796 1387  5070776 1386  5070767 1387  5070748 1387  5070735 1385  
329141 5070724 1386  5070719 1387  5070711 1385  5070700 1387  5070700 1386  5070701 1385  
329142 5070702 1385  5070702 1385  5070702 1385  5070711 1385  5070721 1385  5070724 1387  
329143 5070743 1387  5070750 1385  5070767 1387  5070788 1385  5070802 1385  5070820 1386  
329144 5070845 1385  5070858 1386  5070872 1386  5070898 1385  5070920 1387  5070934 1387  
329145 5070960 1385  5070977 1386  5071003 1385  5071022 1385  5071044 1387  5071068 1386  
329146 5071077 1387  5071093 1385  5071111 1386  5071127 1385  5071146 1385  5071150 1385  
329147 5071170 1385  5071174 1385  5071181 1383  5071179 1385  5071190 1383  5071191 1383  
329148 5071191 1383  5071189 1385  5071191 1383  5071179 1385  5071176 1383  5071171 1383  
329149 5071160 1385  5071150 1385  5071138 1383  5071122 1385  5071104 1383  5071089 1385  
329150 5071074 1385  5071052 1383  5071036 1385  5071022 1385  5070995 1383  5070975 1383  
329151 5070960 1385  5070945 1385  5070923 1383  5070898 1385  5070885 1383  5070861 1383  
329152 5070845 1385  5070826 1385  5070811 1385  5070797 1385  5070783 1385  5070769 1385  
329153 5070759 1385  5070749 1385  5070745 1385  5070735 1385  5070724 1387  5070721 1385  
329154 5070721 1385  5070721 1385  5070719 1387  5070719 1386  5070725 1385  5070734 1387  
329155 5070743 1387  5070748 1386  5070757 1386  5070778 1385  5070781 1386  5070794 1388  
329156 5070810 1387  5070834 1387  5070848 1387  5070870 1388  5070886 1386  5070910 1386  
329157 5070923 1388  5070948 1386  5070967 1386  5070987 1387  5071009 1388  5071023 1388  
329158 5071049 1387  5071066 1388  5071076 1388  5071100 1388  5071124 1388  5071143 1388  
329159 5071149 1386  5071167 1388  5071178 1387  5071186 1388  5071192 1387  5071200 1388  
329160 5071210 1388  5071209 1388  5071214 1388  5071214 1388  5071213 1390  5071210 1388  
329161 5071209 1388  5071199 1390  5071191 1388  5071184 1390  5071176 1388  5071165 1390  
329162 5071146 1390  5071132 1390  5071122 1390  5071098 1390  5071084 1390  5071066 1388  
329163 5071046 1390  5071022 1390  5070996 1392  5070972 1392  5070955 1390  5070939 1392  
329164 5070917 1390  5070893 1390  5070878 1390  5070853 1392  5070840 1390  5070821 1390  
329165 5070797 1390  5070782 1392  5070778 1390  5070764 1390  5070754 1390  5070745 1390  
329166 5070730 1390  5070729 1392  5070719 1392  5070720 1392  5070721 1390  5070720 1392  
329167 5070729 1392  5070730 1390  5070738 1392  5070745 1390  5070754 1390  5070772 1392  
329168 5070777 1392  5070793 1390  5070805 1392  5070820 1392  5070840 1390  5070842 1394  
329169 5070867 1392  5070882 1392  5070896 1392  5070915 1392  5070939 1392  5070952 1394  
329170 5070966 1394  5070987 1392  5071006 1392  5071020 1392  5071039 1392  5071054 1392  
329171 5071062 1394  5071071 1394  5071086 1394  5071095 1394  5071113 1396  5071119 1394  
329172 5071129 1394  5071129 1394  5071137 1396  5071143 1394  5071141 1396  5071143 1394  
329173 5071141 1396  5071137 1396  5071136 1396  5071129 1394  5071117 1396  5071113 1396  
329174 5071103 1396  5071084 1396  5071079 1396  5071065 1396  5071060 1396  5071039 1398  
329175 5071027 1396  5071011 1398  5070992 1398  5070977 1398  5070963 1398  5070950 1396  
329176 5070934 1398  5070910 1398  5070901 1398  5070887 1398  5070872 1398  5070857 1400  
329177 5070839 1398  5070833 1400  5070815 1398  5070809 1400  5070799 1400  5070791 1398  
329178 5070787 1398  5070777 1398  5070772 1398  5070770 1400  5070770 1400  5070770 1400  
329179 5070766 1400  5070770 1400  5070772 1398  5070777 1398  5070785 1400  5070790 1400  
329180 5070801 1398  5070809 1400  5070825 1398  5070834 1398  5070849 1398  5070863 1398  
329181 5070876 1400  5070890 1400  5070910 1398  5070935 1398  5070947 1400  5070962 1400  
329182 5070976 1400  5071000 1400  5071014 1400  5071033 1400  5071047 1400  5071062 1400  
329183 5071078 1398  5071091 1400  5071110 1400  5071126 1398  5071135 1398  5071149 1398  
329184 5071158 1400  5071164 1398  5071167 1400  5071178 1398  5071181 1400  5071181 1400  
329185 5071181 1400  5071193 1398  5071181 1400  5071178 1398  5071176 1400  5071169 1398  
329186 5071164 1398  5071158 1400  5071148 1400  5071134 1400  5071124 1400  5071110 1400  
329187 5071091 1400  5071076 1400  5071063 1398  5071038 1400  5071024 1400  5071000 1400  
329188 5070976 1400  5070963 1398  5070939 1398  5070923 1400  5070901 1398  5070885 1400  
329189 5070863 1398  5070849 1398  5070834 1398  5070815 1398  5070799 1400  5070791 1398  
329190 5070777 1398  5070766 1400  5070758 1398  5070746 1400  5070737 1400  5070732 1400  
329191 5070724 1398  5070724 1398  5070724 1398  5070724 1398  5070723 1400  5070723 1400  
329192 5070732 1400  5070734 1398  5070737 1400  5070748 1398  5070758 1398  5070766 1400  
329193 5070775 1400  5070785 1400  5070799 1400  5070809 1400  5070823 1400  5070837 1400  
329194 5070857 1400  5070861 1400  5070876 1400  5070889 1402  5070907 1402  5070922 1402  
329195 5070930 1403  5070944 1403  5070959 1403  5070973 1403  5070987 1403  5070997 1403  
329196 5071011 1403  5071021 1403  5071030 1403  5071035 1403  5071044 1403  5071056 1402  
329197 5071056 1402  5071062 1400  5071060 1402  5071067 1400  5071067 1400  5071068 1398  
329198 5071067 1400  5071062 1400  5071063 1398  5071057 1400  5071059 1398  5071049 1398  
329199 5071039 1398  5071035 1398  5071016 1398  5071011 1398  5071001 1398  5070992 1398  
329200 5070977 1398  5070965 1396  5070958 1398  5070951 1396  5070934 1398  5070915 1398  
329201 5070901 1398  5070892 1398  5070879 1396  5070874 1396  5070864 1396  5070850 1396  
329202 5070840 1396  5070836 1396  5070826 1396  5070818 1394  5070813 1394  5070804 1394  
329203 5070794 1394  5070794 1394  5070796 1392  5070791 1392  5070796 1392  5070796 1392  
329204 5070796 1392  5070805 1392  5070805 1392  5070815 1392  5070821 1390  5070829 1392  
329205 5070847 1388  5070855 1390  5070863 1392  5070878 1390  5070893 1390  5070898 1390  
329206 5070917 1390  5070931 1390  5070945 1390  5070964 1390  5070975 1388  5070990 1388  
329207 5070999 1388  5071023 1388  5071033 1388  5071047 1388  5071068 1386  5071069 1390  
329208 5071087 1387  5071101 1387  5071111 1387  5071119 1388  5071136 1385  5071136 1385  
329209 5071146 1385  5071152 1383  5071160 1385  5071162 1383  5071170 1385  5071171 1383  
329210 5071171 1383  5071162 1383  5071160 1385  5071162 1383  5071152 1383  5071147 1383  
329211 5071128 1383  5071123 1383  5071114 1383  5071095 1383  5071080 1383  5071071 1383  
329212 5071052 1383  5071037 1383  5071023 1383  5071004 1383  5070981 1381  5070971 1383  
329213 5070948 1381  5070929 1381  5070915 1381  5070900 1381  5070876 1381  5070862 1381  
329214 5070848 1381  5070829 1381  5070814 1381  5070805 1381  5070791 1381  5070786 1381  
329215 5070771 1381  5070762 1381  5070753 1381  5070748 1381  5070738 1381  5070729 1381  
329216 5070729 1381  5070724 1381  5070724 1381  5070724 1381  5070724 1381  5070724 1381  
329217 5070729 1381  5070729 1381  5070738 1381  5070738 1381  5070748 1381  5070753 1381  
329218 5070762 1381  5070771 1381  5070786 1381  5070791 1381  5070800 1381  5070814 1381  
329219 5070824 1381  5070829 1381  5070848 1381  5070853 1381  5070872 1381  5070885 1383  
329220 5070900 1381  5070904 1383  5070924 1381  5070929 1381  5070939 1381  5070948 1381  
329221 5070963 1381  5070972 1381  5070977 1381  5070991 1381  5070991 1381  5070996 1381  
329222 5071005 1381  5071015 1381  5071015 1381  5071025 1381  5071025 1381  5071025 1381  
329223 5071025 1381  5071025 1381  5071025 1381  5071015 1381  5071015 1381  5071015 1381  
329224 5071005 1381  5071005 1381  5070996 1381  5070991 1381  5070977 1381  5070972 1381  
329225 5070963 1381  5070953 1381  5070948 1381  5070929 1381  5070924 1381  5070915 1381  
329226 5070900 1381  5070891 1381  5070886 1381  5070877 1381  5070862 1381  5070853 1381  
329227 5070848 1381  5070838 1381  5070829 1381  5070823 1383  5070824 1381  5070823 1383  
329228 5070814 1381  5070813 1383  5070813 1383  5070805 1381  5070813 1383  5070813 1383  
329229 5070813 1383  5070824 1381  5070823 1383  5070827 1383  5070837 1383  5070837 1383  
329230 5070851 1383  5070859 1385  5070870 1383  5070885 1383  5070889 1383  5070897 1385  
329231 5070913 1383  5070921 1385  5070936 1385  5070952 1383  5070969 1385  5070980 1383  
329232 5070993 1385  5071002 1385  5071027 1385  5071036 1385  5071050 1385  5071069 1385  
329233 5071074 1385  5071079 1385  5071093 1385  5071103 1385  5071112 1385  5071123 1383  
329234 5071127 1385  5071136 1385  5071135 1386  5071136 1385  5071136 1385  5071136 1385  
329235 5071146 1385  5071135 1387  5071135 1387  5071125 1387  5071120 1386  5071111 1386  
329236 5071101 1387  5071090 1388  5071074 1390  5071071 1388  5071057 1388  5071045 1390  
329237 5071031 1390  5071017 1390  5070996 1392  5070984 1390  5070966 1394  5070942 1394  
329238 5070926 1396  5070912 1396  5070901 1398  5070885 1400  5070869 1402  5070853 1403  
329239 5070834 1403  5070820 1403  5070806 1403  5070795 1405  5070780 1405  5070771 1405  
329240 5070761 1405  5070752 1405  5070742 1405  5070732 1405  5070728 1405  5070718 1405  
329241 5070715 1409  5070708 1405  5070706 1409  5070705 1409  5070705 1409  5070705 1409  
329242 5070709 1405  5070709 1405  5070718 1405  5070725 1409  5070728 1405  5070732 1405  
329243 5070742 1405  5070752 1405  5070761 1405  5070767 1403  5070772 1403  5070785 1405  
329244 5070795 1405  5070806 1403  5070820 1403  5070830 1403  5070844 1403  5070858 1403  
329245 5070873 1403  5070882 1403  5070896 1403  5070911 1403  5070921 1403  5070930 1403  
329246 5070946 1402  5070954 1403  5070965 1402  5070973 1403  5070978 1403  5070987 1403  
329247 5070997 1403  5071006 1403  5071011 1403  5071021 1403  5071021 1403  5071030 1403  
329248 5071030 1403  5071030 1403  5071030 1403  5071030 1403  5071030 1403  5071030 1403  
329249 5071021 1403  5071021 1403  5071011 1403  5071011 1403  5071006 1403  5070997 1403  
329250 5070989 1402  5070978 1403  5070973 1403  5070963 1403  5070955 1402  5070944 1403  
329251 5070935 1403  5070930 1403  5070912 1402  5070906 1403  5070898 1402  5070887 1403  
329252 5070882 1403  5070872 1403  5070868 1403  5070869 1402  5070858 1403  5070860 1402  
329253 5070854 1403  5070854 1403  5070844 1403  5070844 1403  5070844 1403  5070854 1403  
329254 5070854 1403  5070854 1403  5070858 1403  5070868 1403  5070872 1403  5070882 1403  
329255 5070887 1403  5070896 1403  5070906 1403  5070911 1403  5070930 1403  5070935 1403  
329256 5070954 1403  5070963 1403  5070973 1403  5070987 1403  5071006 1403  5071021 1403  
329257 5071037 1402  5071054 1403  5071064 1403  5071073 1403  5071088 1403  5071108 1402  
329258 5071111 1403  5071130 1403  5071137 1402  5071145 1403  5071156 1402  5071156 1402  
329259 5071159 1403  5071164 1403  5071165 1402  5071164 1403  5071173 1403  5071166 1402  
329260 5071166 1402  5071166 1402  5071161 1402  5071156 1402  5071146 1402  5071137 1402  
329261 5071132 1402  5071123 1402  5071108 1402  5071088 1403  5071078 1403  5071065 1401  
329262 5071056 1402  5071036 1402  5071022 1402  5071008 1402  5070989 1402  5070965 1402  
329263 5070955 1402  5070936 1402  5070922 1402  5070898 1402  5070889 1402  5070874 1402  
329264 5070855 1402  5070836 1402  5070822 1402  5070807 1402  5070796 1403  5070782 1403  
329265 5070769 1402  5070763 1403  5070745 1402  5070736 1402  5070721 1402  5070710 1403  
329266 5070710 1403  5070705 1403  5070696 1403  5070697 1402  5070696 1403  5070696 1403  
329267 5070696 1403  5070697 1402  5070697 1402  5070707 1402  5070710 1404  5070712 1402  
329268 5070721 1402  5070729 1403  5070734 1403  5070745 1402  5070763 1403  5070769 1402  
329269 5070784 1402  5070798 1402  5070807 1402  5070822 1402  5070834 1403  5070845 1402  
329270 5070858 1403  5070872 1403  5070889 1402  5070907 1402  5070920 1403  5070936 1402  
329271 5070955 1402  5070960 1402  5070974 1402  5070979 1402  5070998 1402  5071008 1402  
329272 5071011 1403  5071022 1402  5071032 1401  5071036 1402  5071046 1402  5071046 1402  
329273 5071056 1402  5071056 1402  5071056 1402  5071060 1402  5071062 1400  5071056 1402  
329274 5071056 1402  5071056 1402  5071046 1402  5071036 1402  5071033 1400  5071024 1400  
329275 5071014 1400  5071009 1400  5070998 1402  5070989 1402  5070976 1400  5070965 1402  
329276 5070960 1402  5070955 1402  5070946 1402  5070931 1402  5070922 1402  5070912 1402  
329277 5070907 1401  5070898 1402  5070884 1402  5070876 1400  5070874 1402  5070868 1403  
329278 5070861 1400  5070860 1402  5070860 1402  5070860 1402  5070854 1403  5070853 1403  
329279 5070854 1403  5070860 1402  5070860 1402  5070869 1402  5070872 1403  5070884 1402  
329280 5070887 1403  5070898 1402  5070911 1403  5070920 1403  5070936 1402  5070946 1402  
329281 5070959 1403  5070973 1403  5070989 1402  5071006 1403  5071021 1403  5071035 1403  
329282 5071046 1402  5071059 1403  5071073 1403  5071088 1403  5071107 1403  5071111 1403  
329283 5071130 1403  5071135 1403  5071146 1402  5071159 1403  5071164 1403  5071173 1403  
329284 5071173 1403  5071178 1403  5071178 1403  5071178 1403  5071188 1403  5071178 1403  
329285 5071188 1403  5071178 1403  5071178 1403  5071174 1403  5071164 1403  5071159 1403  
329286 5071155 1403  5071145 1403  5071131 1403  5071121 1403  5071107 1403  5071088 1403  
329287 5071073 1403  5071059 1403  5071035 1403  5071021 1403  5071005 1405  5070978 1403  
329288 5070957 1405  5070944 1403  5070919 1405  5070904 1405  5070880 1405  5070868 1403  
329289 5070842 1405  5070828 1405  5070801 1409  5070782 1409  5070768 1409  5070749 1409  
329290 5070730 1409  5070715 1409  5070709 1405  5070691 1409  5070677 1409  5070667 1409  
329291 5070663 1409  5070658 1409  5070647 1411  5070648 1409  5070637 1411  5070647 1411  
329292 5070647 1411  5070648 1409  5070648 1409  5070656 1411  5070656 1411  5070667 1409  
329293 5070677 1409  5070682 1409  5070694 1405  5070704 1405  5070715 1409  5070729 1409  
329294 5070749 1409  5070766 1405  5070780 1405  5070792 1409  5070809 1405  5070825 1409  
329295 5070842 1405  5070866 1405  5070880 1405  5070897 1403  5070921 1403  5070933 1405  
329296 5070952 1405  5070963 1403  5070973 1403  5070986 1405  5071006 1403  5071021 1403  
329297 5071030 1403  5071035 1403  5071043 1405  5071054 1403  5071059 1403  5071059 1403  
329298 5071064 1403  5071064 1403  5071064 1403  5071064 1403  5071064 1403  5071064 1403  
329299 5071059 1403  5071054 1403  5071044 1403  5071035 1403  5071030 1403  5071011 1403  
329300 5071006 1403  5070997 1403  5070978 1403  5070973 1403  5070959 1403  5070944 1403  
329301 5070936 1402  5070922 1402  5070907 1402  5070900 1400  5070885 1400  5070876 1400  
329302 5070863 1398  5070858 1398  5070837 1400  5070833 1400  5070823 1400  5070815 1398  
329303 5070815 1398  5070809 1400  5070810 1398  5070810 1398  5070810 1398  5070809 1400  
329304 5070813 1400  5070815 1398  5070825 1398  5070834 1398  5070839 1398  5070850 1396  
329305 5070861 1400  5070872 1398  5070887 1398  5070901 1398  5070914 1400  5070934 1398  
329306 5070938 1400  5070962 1400  5070977 1398  5070992 1398  5071011 1398  5071024 1400  
329307 5071038 1400  5071057 1400  5071068 1398  5071082 1398  5071102 1398  5071110 1400  
329308 5071126 1398  5071140 1398  5071159 1398  5071164 1398  5071168 1398  5071178 1398  
329309 5071184 1396  5071194 1396  5071194 1396  5071194 1396  5071196 1394  5071194 1396  
329310 5071194 1396  5071184 1396  5071184 1396  5071181 1394  5071172 1394  5071161 1396  
329311 5071153 1394  5071138 1394  5071119 1394  5071105 1394  5071086 1394  5071071 1394  
329312 5071054 1392  5071030 1392  5071015 1392  5070985 1394  5070966 1394  5070944 1392  
329313 5070915 1392  5070891 1392  5070867 1392  5070843 1392  5070820 1392  5070796 1392  
329314 5070777 1392  5070753 1392  5070740 1390  5070715 1392  5070691 1392  5070676 1392  
329315 5070661 1394  5070646 1394  5070629 1392  5070614 1392  5070603 1394  5070594 1394  
329316 5070590 1392  5070579 1394  5070576 1392  5070574 1394  5070574 1394  5070574 1394  
329317 5070581 1392  5070580 1394  5070590 1392  5070595 1392  5070614 1392  5070619 1392  
329318 5070629 1392  5070648 1392  5070662 1392  5070675 1394  5070689 1394  5070703 1394  
329319 5070727 1394  5070751 1394  5070770 1394  5070794 1394  5070813 1394  5070837 1394  
329320 5070863 1392  5070880 1394  5070895 1394  5070917 1396  5070942 1394  5070966 1394  
329321 5070980 1394  5070997 1392  5071012 1396  5071030 1392  5071041 1396  5071052 1394  
329322 5071065 1396  5071071 1394  5071081 1394  5071078 1398  5071086 1394  5071084 1396  
329323 5071094 1396  5071094 1396  5071092 1398  5071082 1398  5071082 1398  5071078 1398  
329324 5071068 1398  5071062 1400  5071047 1400  5071039 1398  5071035 1398  5071014 1400  
329325 5071000 1400  5070990 1400  5070976 1400  5070962 1400  5070946 1402  5070936 1402  
329326 5070922 1402  5070908 1402  5070889 1402  5070874 1402  5070871 1400  5070855 1402  
329327 5070844 1403  5070830 1403  5070820 1403  5070810 1403  5070806 1403  5070806 1403  
329328 5070798 1402  5070796 1403  5070787 1403  5070796 1403  5070796 1403  5070806 1403  
329329 5070806 1403  5070810 1403  5070820 1403  5070834 1403  5070844 1403  5070858 1403  
329330 5070873 1403  5070887 1403  5070906 1403  5070920 1403  5070935 1403  5070959 1403  
329331 5070973 1403  5070997 1403  5071021 1403  5071035 1403  5071059 1403  5071073 1403  
329332 5071097 1403  5071111 1403  5071135 1403  5071155 1403  5071164 1403  5071188 1403  
329333 5071202 1403  5071221 1403  5071231 1403  5071245 1403  5071259 1403  5071264 1403  
329334 5071264 1403  5071274 1403  5071274 1403  5071274 1403  5071274 1403  5071274 1403  
329335 5071266 1402  5071261 1402  5071255 1403  5071237 1402  5071232 1402  5071213 1402  
329336 5071204 1402  5071180 1402  5071166 1402  5071145 1403  5071123 1402  5071099 1402  
329337 5071065 1402  5071044 1403  5071013 1402  5070989 1402  5070965 1402  5070938 1400  
329338 5070912 1402  5070884 1402  5070855 1402  5070822 1402  5070798 1402  5070774 1402  
329339 5070755 1402  5070731 1402  5070705 1403  5070683 1402  5070664 1402  5070643 1403  
329340 5070621 1402  5070611 1402  5070596 1403  5070586 1403  5070573 1402  5070568 1402  
329341 5070562 1403  5070562 1403  5070562 1403  5070562 1403  5070567 1403  5070567 1403  
329342 5070572 1403  5070583 1402  5070596 1403  5070605 1403  5070619 1403  5070638 1403  
329343 5070663 1403  5070672 1403  5070686 1403  5070710 1403  5070734 1403  5070768 1403  
329344 5070787 1403  5070810 1403  5070834 1403  5070858 1403  5070887 1403  5070911 1403  
329345 5070944 1403  5070963 1403  5070987 1403  5071006 1403  5071030 1403  5071044 1403  
329346 5071064 1403  5071078 1403  5071097 1403  5071111 1403  5071130 1403  5071135 1403  
329347 5071145 1404  5071153 1405  5071155 1403  5071159 1403  5071158 1405  5071159 1403  
329348 5071155 1403  5071154 1403  5071145 1403  5071135 1403  5071131 1403  5071120 1405  
329349 5071107 1403  5071088 1403  5071073 1403  5071059 1403  5071045 1404  5071029 1405  
329350 5071011 1403  5070986 1405  5070973 1403  5070959 1403  5070944 1403  5070919 1405  
329351 5070906 1403  5070882 1403  5070868 1403  5070858 1403  5070844 1403  5070828 1405  
329352 5070820 1403  5070806 1403  5070795 1405  5070785 1405  5070785 1405  5070780 1405  
329353 5070780 1405  5070780 1405  5070780 1405  5070782 1409  5070782 1409  5070792 1409  
329354 5070801 1409  5070806 1409  5070825 1409  5070839 1409  5070854 1409  5070868 1409  
329355 5070892 1409  5070909 1405  5070928 1405  5070950 1409  5070968 1409  5070995 1405  
329356 5071019 1405  5071043 1405  5071057 1405  5071078 1403  5071105 1405  5071130 1403  
329357 5071153 1405  5071173 1403  5071196 1405  5071210 1405  5071236 1403  5071253 1405  
329358 5071264 1403  5071278 1403  5071288 1403  5071298 1403  5071302 1403  5071312 1403  
329359 5071322 1403  5071322 1403  5071322 1403  5071322 1403  5071312 1403  5071302 1403  
329360 5071298 1403  5071279 1403  5071266 1402  5071256 1402  5071237 1402  5071213 1402  
329361 5071189 1402  5071166 1402  5071137 1402  5071116 1398  5071081 1400  5071057 1400  
329362 5071025 1398  5070990 1400  5070962 1400  5070933 1400  5070890 1400  5070863 1398  
329363 5070833 1400  5070801 1398  5070772 1398  5070737 1400  5070710 1398  5070686 1398  
329364 5070658 1398  5070634 1398  5070608 1400  5070584 1400  5070570 1400  5070554 1402  
329365 5070544 1402  5070530 1402  5070510 1403  5070506 1402  5070495 1403  5070495 1403  
329366 5070495 1403  5070495 1403  5070505 1403  5070505 1403  5070519 1403  5070529 1403  
329367 5070543 1403  5070562 1403  5070581 1403  5070597 1402  5070621 1402  5070640 1402  
329368 5070669 1402  5070688 1402  5070712 1402  5070745 1402  5070770 1400  5070788 1402  
329369 5070821 1401  5070857 1400  5070884 1402  5070907 1402  5070936 1402  5070965 1402  
329370 5070989 1402  5071012 1402  5071036 1402  5071062 1400  5071079 1402  5071099 1402  
329371 5071114 1400  5071132 1402  5071146 1402  5071158 1400  5071162 1400  5071165 1402  
329372 5071176 1400  5071175 1402  5071176 1400  5071175 1402  5071176 1400  5071166 1402  
329373 5071167 1400  5071158 1400  5071146 1402  5071138 1400  5071123 1402  5071099 1402  
329374 5071079 1402  5071065 1402  5071046 1402  5071030 1403  5071009 1400  5070987 1403  
329375 5070965 1402  5070946 1402  5070922 1402  5070898 1402  5070884 1402  5070860 1402  
329376 5070847 1400  5070822 1402  5070809 1400  5070790 1400  5070775 1400  5070769 1402  
329377 5070756 1400  5070747 1400  5070737 1400  5070731 1402  5070732 1400  5070732 1400  
329378 5070732 1400  5070734 1398  5070737 1400  5070748 1398  5070758 1398  5070767 1398  
329379 5070777 1398  5070791 1398  5070810 1398  5070825 1398  5070849 1398  5070863 1398  
329380 5070892 1398  5070915 1398  5070939 1398  5070963 1398  5070990 1400  5071016 1398  
329381 5071049 1398  5071068 1398  5071102 1398  5071135 1398  5071158 1400  5071183 1398  
329382 5071207 1398  5071235 1398  5071259 1398  5071278 1398  5071293 1398  5071315 1400  
329383 5071329 1400  5071348 1400  5071358 1400  5071364 1398  5071369 1398  5071368 1400  
329384 5071379 1398  5071369 1398  5071369 1398  5071363 1400  5071348 1400  5071340 1398  
329385 5071326 1398  5071302 1398  5071277 1400  5071258 1400  5071239 1400  5071205 1400  
329386 5071183 1398  5071159 1398  5071126 1398  5071092 1398  5071057 1400  5071024 1400  
329387 5070982 1398  5070949 1398  5070914 1400  5070877 1398  5070849 1398  5070812 1396  
329388 5070778 1396  5070748 1398  5070715 1398  5070688 1396  5070658 1398  5070624 1398  
329389 5070602 1396  5070578 1396  5070567 1398  5070548 1398  5070535 1396  5070516 1396  
329390 5070511 1396  5070500 1398  5070492 1396  5070490 1398  5070490 1398  5070490 1398  
329391 5070500 1398  5070509 1398  5070524 1398  5070533 1398  5070546 1400  5070567 1398  
329392 5070586 1398  5070608 1400  5070634 1398  5070658 1398  5070686 1398  5070710 1398  
329393 5070739 1398  5070772 1398  5070801 1398  5070834 1398  5070861 1400  5070890 1400  
329394 5070923 1400  5070957 1400  5070982 1398  5071014 1400  5071037 1402  5071062 1400  
329395 5071089 1402  5071114 1400  5071132 1402  5071156 1402  5071165 1402  5071180 1402  
329396 5071197 1403  5071202 1403  5071221 1403  5071231 1403  5071231 1403  5071236 1403  
329397 5071236 1403  5071231 1403  5071229 1405  5071220 1405  5071210 1405  5071202 1403  
329398 5071186 1405  5071172 1405  5071158 1405  5071143 1405  5071120 1405  5071095 1405  
329399 5071076 1405  5071054 1409  5071030 1409  5071005 1405  5070973 1409  5070954 1409  
329400 5070933 1405  5070906 1409  5070881 1411  5070863 1409  5070839 1409  5070824 1411  
329401 5070800 1411  5070782 1409  5070761 1411  5070757 1411  5070737 1411  5070723 1411  
329402 5070714 1411  5070704 1411  5070704 1411  5070704 1411  5070699 1411  5070699 1411  
329403 5070703 1413  5070712 1413  5070722 1413  5070737 1411  5070745 1413  5070760 1413  
329404 5070779 1413  5070804 1411  5070827 1413  5070844 1415  5070874 1413  5070898 1413  
329405 5070927 1413  5070956 1413  5070979 1413  5071013 1413  5071046 1413  5071070 1413  
329406 5071102 1415  5071136 1415  5071156 1413  5071190 1413  5071223 1413  5071250 1415  
329407 5071269 1415  5071295 1413  5071317 1415  5071336 1415  5071354 1417  5071370 1415  
329408 5071389 1415  5071394 1415  5071403 1415  5071403 1415  5071403 1415  5071403 1415  
329409 5071394 1415  5071395 1413  5071390 1413  5071371 1413  5071357 1413  5071347 1413  
329410 5071318 1413  5071295 1413  5071271 1413  5071247 1413  5071213 1413  5071179 1415  
329411 5071153 1411  5071125 1411  5071080 1413  5071048 1411  5071016 1409  5070968 1409  
329412 5070943 1405  5070901 1409  5070866 1405  5070828 1405  5070787 1404  5070763 1403  
329413 5070720 1403  5070686 1403  5070663 1403  5070629 1403  5070605 1403  5070572 1403  
329414 5070553 1403  5070538 1403  5070519 1403  5070505 1403  5070495 1403  5070487 1402  
329415 5070481 1403  5070471 1403  5070473 1402  5070481 1403  5070487 1402  5070497 1402  
329416 5070511 1402  5070530 1402  5070544 1402  5070565 1400  5070583 1402  5070607 1402  
329417 5070631 1402  5070664 1402  5070683 1402  5070712 1402  5070745 1402  5070774 1402  
329418 5070807 1402  5070836 1402  5070874 1402  5070898 1402  5070935 1403  5070963 1403  
329419 5070998 1402  5071032 1402  5071056 1402  5071078 1403  5071107 1403  5071132 1402  
329420 5071154 1403  5071174 1403  5071188 1403  5071202 1403  5071221 1403  5071237 1402  
329421 5071245 1403  5071260 1403  5071259 1403  5071260 1403  5071260 1403  5071260 1403  
329422 5071255 1403  5071236 1403  5071232 1402  5071221 1403  5071204 1402  5071188 1403  
329423 5071164 1403  5071145 1403  5071121 1403  5071097 1403  5071075 1402  5071056 1402  
329424 5071022 1402  5070998 1402  5070965 1402  5070944 1403  5070911 1403  5070887 1403  
329425 5070858 1403  5070834 1403  5070810 1403  5070785 1405  5070768 1403  5070744 1403  
329426 5070729 1403  5070705 1403  5070686 1403  5070670 1405  5070667 1403  5070663 1403  
329427 5070653 1403  5070643 1403  5070643 1403  5070643 1403  5070643 1403  5070653 1403  
329428 5070664 1402  5070667 1403  5070683 1402  5070697 1402  5070713 1400  5070736 1402  
329429 5070766 1400  5070788 1402  5070813 1400  5070847 1400  5070876 1400  5070898 1402  
329430 5070938 1400  5070965 1402  5071000 1400  5071033 1400  5071068 1398  5071100 1400  
329431 5071134 1400  5071162 1400  5071192 1398  5071226 1398  5071258 1400  5071277 1400  
329432 5071302 1398  5071326 1398  5071350 1398  5071363 1400  5071379 1398  5071383 1398  
329433 5071401 1400  5071406 1400  5071407 1398  5071407 1398  5071409 1396  5071403 1398  
329434 5071395 1396  5071380 1396  5071366 1396  5071352 1396  5071331 1398  5071307 1398  
329435 5071278 1398  5071259 1398  5071226 1398  5071192 1398  5071164 1398  5071135 1398  
329436 5071092 1398  5071059 1398  5071016 1398  5070977 1398  5070949 1398  5070910 1398  
329437 5070871 1400  5070833 1400  5070799 1400  5070766 1400  5070734 1398  5070691 1398  
329438 5070667 1398  5070643 1398  5070608 1400  5070585 1400  5070565 1400  5070546 1400  
329439 5070532 1400  5070513 1400  5070508 1400  5070498 1400  5070489 1400  5070489 1400  
329440 5070489 1400  5070498 1400  5070508 1400  5070511 1402  5070532 1400  5070544 1402  
329441 5070565 1400  5070584 1400  5070608 1400  5070632 1400  5070655 1402  5070683 1402  
329442 5070713 1400  5070736 1402  5070770 1400  5070809 1400  5070836 1402  5070871 1400  
329443 5070900 1400  5070938 1400  5070965 1402  5070998 1402  5071032 1402  5071067 1400  
329444 5071091 1400  5071124 1400  5071156 1402  5071175 1402  5071199 1402  5071224 1400  
329445 5071239 1400  5071261 1402  5071266 1402  5071280 1402  5071290 1402  5071290 1402  
329446 5071301 1400  5071304 1402  5071301 1400  5071301 1400  5071290 1402  5071282 1400  
329447 5071269 1398  5071258 1400  5071239 1400  5071223 1402  5071199 1402  5071175 1402  
329448 5071158 1400  5071132 1402  5071110 1400  5071076 1400  5071047 1400  5071024 1400  
329449 5070989 1402  5070962 1400  5070933 1400  5070899 1400  5070876 1400  5070836 1402  
329450 5070813 1400  5070788 1402  5070766 1400  5070737 1400  5070712 1402  5070699 1400  
329451 5070675 1400  5070664 1402  5070645 1402  5070642 1400  5070632 1400  5070621 1402  
329452 5070623 1400  5070611 1402  5070621 1402  5070623 1400  5070631 1402  5070640 1402  
329453 5070654 1402  5070669 1402  5070688 1402  5070707 1402  5070731 1402  5070755 1402  
329454 5070782 1403  5070812 1402  5070834 1403  5070869 1402  5070906 1403  5070936 1402  
329455 5070965 1402  5071008 1402  5071035 1403  5071064 1403  5071106 1403  5071135 1403  
329456 5071164 1403  5071202 1403  5071231 1403  5071259 1403  5071280 1402  5071303 1403  
329457 5071326 1403  5071355 1403  5071365 1403  5071379 1403  5071389 1403  5071398 1403  
329458 5071403 1403  5071403 1403  5071403 1403  5071398 1403  5071389 1403  5071379 1403  
329459 5071365 1403  5071355 1403  5071334 1405  5071310 1405  5071286 1405  5071263 1405  
329460 5071234 1405  5071210 1405  5071172 1405  5071143 1405  5071107 1409  5071069 1409  
329461 5071043 1405  5071005 1405  5070962 1405  5070933 1405  5070892 1409  5070857 1405  
329462 5070828 1405  5070795 1405  5070766 1405  5070725 1409  5070704 1405  5070670 1405  
329463 5070648 1409  5070627 1405  5070608 1405  5070594 1405  5070580 1405  5070570 1405  
329464 5070561 1405  5070551 1405  5070548 1409  5070551 1405  5070548 1409  5070548 1409  
329465 5070561 1405  5070565 1405  5070570 1405  5070591 1409  5070608 1405  5070625 1409  
329466 5070648 1409  5070667 1409  5070691 1409  5070728 1405  5070749 1409  5070780 1405  
329467 5070809 1405  5070839 1409  5070868 1409  5070901 1409  5070940 1409  5070971 1405  
329468 5071005 1405  5071030 1409  5071059 1409  5071102 1409  5071129 1405  5071158 1405  
329469 5071183 1409  5071210 1405  5071234 1405  5071253 1405  5071272 1405  5071286 1405  
329470 5071296 1405  5071312 1403  5071322 1403  5071322 1403  5071326 1403  5071326 1403  
329471 5071322 1403  5071322 1403  5071312 1403  5071298 1403  5071288 1403  5071274 1403  
329472 5071260 1403  5071245 1403  5071223 1402  5071199 1402  5071175 1402  5071146 1402  
329473 5071123 1402  5071089 1402  5071060 1402  5071032 1402  5070998 1402  5070966 1400  
329474 5070935 1403  5070909 1400  5070874 1402  5070847 1400  5070812 1402  5070788 1402  
329475 5070764 1402  5070737 1400  5070710 1403  5070688 1402  5070667 1403  5070653 1403  
329476 5070640 1402  5070621 1402  5070610 1403  5070607 1402  5070596 1403  5070597 1402  
329477 5070596 1403  5070597 1402  5070596 1403  5070605 1403  5070619 1403  5070638 1403  
329478 5070643 1403  5070667 1403  5070682 1403  5070705 1403  5070734 1403  5070763 1403  
329479 5070787 1403  5070810 1403  5070844 1403  5070882 1403  5070911 1403  5070944 1403  
329480 5070973 1403  5071006 1403  5071044 1403  5071073 1403  5071107 1403  5071135 1403  
329481 5071164 1403  5071197 1403  5071221 1403  5071245 1403  5071264 1403  5071288 1403  
329482 5071304 1402  5071323 1402  5071328 1402  5071337 1402  5071348 1400  5071347 1402  
329483 5071347 1402  5071347 1402  5071348 1400  5071339 1400  5071329 1400  5071315 1400  
329484 5071301 1400  5071281 1400  5071264 1398  5071239 1400  5071215 1400  5071191 1400  
329485 5071162 1400  5071134 1400  5071111 1398  5071078 1398  5071049 1398  5071016 1398  
329486 5070977 1398  5070949 1398  5070917 1396  5070888 1396  5070858 1398  5070826 1396  
329487 5070793 1396  5070772 1398  5070740 1396  5070716 1396  5070691 1398  5070678 1396  
329488 5070659 1396  5070645 1396  5070626 1396  5070616 1396  5070611 1396  5070602 1396  
329489 5070602 1396  5070602 1396  5070602 1396  5070602 1396  5070602 1396  5070615 1398  
329490 5070624 1398  5070643 1398  5070659 1396  5070672 1398  5070691 1398  5070715 1398  
329491 5070740 1396  5070767 1398  5070791 1398  5070815 1398  5070850 1396  5070872 1398  
329492 5070903 1396  5070934 1398  5070965 1396  5070992 1398  5071025 1398  5071063 1398  
329493 5071092 1398  5071116 1398  5071149 1398  5071178 1398  5071202 1398  5071227 1396  
329494 5071250 1398  5071264 1398  5071278 1398  5071293 1398  5071307 1398  5071316 1398  
329495 5071326 1398  5071331 1398  5071331 1398  5071329 1400  5071331 1398  5071326 1398  
329496 5071317 1398  5071307 1398  5071301 1400  5071281 1400  5071269 1398  5071248 1400  
329497 5071235 1398  5071207 1398  5071183 1398  5071164 1398  5071140 1398  5071111 1398  
329498 5071076 1400  5071047 1400  5071014 1400  5070981 1400  5070957 1400  5070922 1402  
329499 5070889 1402  5070869 1402  5070836 1402  5070807 1402  5070774 1402  5070755 1402  
329500 5070731 1402  5070697 1402  5070682 1403  5070667 1403  5070645 1402  5070629 1403  
329501 5070619 1403  5070610 1403  5070605 1403  5070597 1402  5070596 1403  5070596 1403  
329502 5070596 1403  5070605 1403  5070605 1403  5070619 1403  5070638 1403  5070653 1403  
329503 5070667 1403  5070686 1403  5070710 1403  5070734 1403  5070763 1403  5070782 1403  
329504 5070810 1403  5070834 1403  5070868 1403  5070896 1403  5070928 1405  5070959 1403  
329505 5070986 1405  5071021 1403  5071054 1403  5071073 1403  5071107 1403  5071135 1403  
329506 5071158 1405  5071178 1403  5071201 1405  5071229 1405  5071244 1405  5071258 1405  
329507 5071272 1405  5071274 1409  5071283 1409  5071296 1405  5071298 1409  5071296 1411  
329508 5071293 1409  5071293 1409  5071283 1409  5071274 1409  5071269 1409  5071258 1411  
329509 5071250 1409  5071225 1411  5071207 1409  5071183 1409  5071159 1409  5071140 1409  
329510 5071116 1409  5071083 1409  5071059 1409  5071043 1405  5071009 1405  5070986 1405  
329511 5070957 1405  5070930 1409  5070904 1405  5070881 1405  5070857 1405  5070833 1405  
329512 5070806 1403  5070780 1405  5070766 1405  5070739 1409  5070728 1405  5070710 1403  
329513 5070704 1405  5070685 1405  5070680 1405  5070670 1405  5070667 1409  5070666 1405  
329514 5070666 1405  5070670 1405  5070670 1405  5070680 1405  5070682 1409  5070694 1405  
329515 5070709 1405  5070725 1409  5070739 1409  5070761 1405  5070768 1409  5070795 1405  
329516 5070819 1405  5070839 1409  5070866 1405  5070886 1405  5070919 1405  5070940 1409  
329517 5070959 1409  5070992 1409  5071026 1409  5071049 1409  5071073 1409  5071102 1409  
329518 5071129 1405  5071153 1405  5071172 1405  5071193 1409  5071210 1405  5071234 1405  
329519 5071253 1405  5071263 1405  5071272 1405  5071286 1405  5071286 1405  5071296 1405  
329520 5071301 1405  5071301 1405  5071296 1405  5071296 1405  5071286 1405  5071286 1405  
329521 5071274 1409  5071263 1405  5071253 1405  5071231 1409  5071220 1405  5071196 1405  
329522 5071172 1405  5071153 1405  5071129 1405  5071105 1405  5071072 1405  5071043 1405  
329523 5071010 1405  5070986 1405  5070957 1405  5070925 1409  5070892 1409  5070871 1405  
329524 5070842 1405  5070806 1409  5070785 1405  5070761 1405  5070730 1409  5070709 1405  
329525 5070682 1409  5070663 1409  5070652 1405  5070637 1405  5070618 1405  5070600 1409  
329526 5070591 1409  5070581 1409  5070576 1409  5070576 1409  5070576 1409  5070577 1409  
329527 5070580 1405  5070582 1409  5070591 1409  5070605 1409  5070625 1409  5070634 1409  
329528 5070658 1409  5070667 1409  5070682 1409  5070706 1409  5070729 1409  5070749 1409  
329529 5070777 1409  5070801 1409  5070825 1409  5070854 1409  5070877 1409  5070900 1411  
329530 5070930 1409  5070959 1409  5070982 1409  5071005 1411  5071029 1411  5071054 1409  
329531 5071072 1411  5071101 1411  5071115 1411  5071131 1409  5071148 1411  5071158 1411  
329532 5071172 1411  5071182 1411  5071180 1413  5071190 1413  5071196 1411  5071196 1411  
329533 5071195 1413  5071195 1413  5071190 1413  5071180 1413  5071180 1413  5071167 1411  
329534 5071151 1413  5071148 1411  5071128 1413  5071113 1413  5071090 1413  5071072 1411  
329535 5071053 1411  5071038 1411  5071013 1413  5070991 1411  5070965 1413  5070946 1413  
329536 5070927 1413  5070905 1411  5070879 1413  5070865 1413  5070846 1413  5070827 1413  
329537 5070803 1413  5070796 1415  5070779 1413  5070774 1413  5070758 1415  5070744 1415  
329538 5070745 1413  5070736 1413  5070725 1415  5070726 1413  5070725 1415  5070720 1415  
329539 5070720 1415  5070725 1415  5070725 1415  5070735 1415  5070744 1415  5070758 1415  
329540 5070771 1417  5070789 1413  5070801 1415  5070821 1415  5070835 1415  5070859 1415  
329541 5070878 1415  5070902 1415  5070926 1415  5070948 1417  5070968 1415  5070997 1415  
329542 5071023 1413  5071050 1415  5071069 1415  5071097 1415  5071121 1415  5071136 1415  
329543 5071155 1415  5071177 1417  5071193 1415  5071212 1415  5071226 1415  5071245 1415  
329544 5071255 1415  5071263 1417  5071269 1415  5071279 1415  5071287 1417  5071289 1415  
329545 5071287 1417  5071289 1415  5071289 1415  5071277 1417  5071269 1415  5071263 1417  
329546 5071255 1415  5071244 1417  5071225 1417  5071212 1415  5071193 1415  5071179 1415  
329547 5071155 1415  5071136 1415  5071112 1415  5071088 1415  5071055 1415  5071035 1415  
329548 5071002 1415  5070978 1415  5070954 1415  5070925 1415  5070900 1417  5070873 1415  
329549 5070847 1417  5070824 1417  5070800 1417  5070776 1417  5070757 1417  5070733 1417  
329550 5070707 1418  5070695 1417  5070675 1417  5070661 1417  5070652 1417  5070642 1417  
329551 5070633 1417  5070628 1417  5070618 1417  5070618 1417  5070608 1417  5070609 1417  
329552 5070618 1417  5070617 1419  5070628 1417  5070633 1417  5070650 1418  5070657 1417  
329553 5070669 1418  5070674 1418  5070695 1417  5070707 1418  5070731 1419  5070757 1417  
329554 5070771 1417  5070793 1418  5070817 1418  5070841 1418  5070859 1420  5070884 1418  
329555 5070899 1419  5070921 1420  5070945 1420  5070965 1418  5070994 1418  5071008 1419  
329556 5071032 1418  5071045 1420  5071061 1418  5071074 1420  5071093 1420  5071107 1420  
329557 5071117 1420  5071123 1418  5071133 1418  5071142 1418  5071147 1418  5071148 1417  
329558 5071148 1417  5071150 1415  5071150 1415  5071145 1415  5071146 1413  5071136 1415  
329559 5071128 1413  5071123 1413  5071102 1415  5071099 1413  5071080 1413  5071065 1413  
329560 5071051 1413  5071037 1413  5071024 1411  5071003 1413  5070989 1413  5070970 1413  
329561 5070956 1413  5070938 1411  5070924 1411  5070905 1411  5070890 1411  5070877 1409  
329562 5070862 1411  5070854 1409  5070838 1411  5070828 1411  5070816 1409  5070804 1411  
329563 5070801 1409  5070792 1409  5070790 1411  5070780 1411  5070780 1411  5070782 1409  
329564 5070782 1409  5070782 1409  5070792 1409  5070801 1409  5070806 1409  5070816 1409  
329565 5070825 1409  5070842 1405  5070849 1409  5070863 1409  5070877 1409  5070892 1409  
329566 5070919 1405  5070933 1405  5070952 1405  5070971 1405  5070986 1405  5071005 1405  
329567 5071026 1409  5071043 1405  5071062 1405  5071076 1405  5071105 1405  5071119 1405  
329568 5071143 1405  5071155 1409  5071172 1405  5071186 1405  5071201 1405  5071221 1403  
329569 5071229 1405  5071243 1405  5071253 1405  5071255 1403  5071258 1405  5071255 1409  
329570 5071264 1403  5071263 1405  5071258 1405  5071260 1404  5071258 1405  5071244 1405  
329571 5071234 1405  5071220 1405  5071210 1405  5071196 1405  5071178 1403  5071162 1405  
329572 5071145 1403  5071131 1403  5071107 1403  5071076 1405  5071059 1403  5071035 1403  
329573 5071011 1403  5070986 1405  5070957 1405  5070933 1405  5070909 1405  5070885 1405  
329574 5070868 1403  5070842 1405  5070819 1405  5070795 1405  5070780 1405  5070763 1403  
329575 5070732 1405  5070718 1405  5070704 1405  5070680 1405  5070672 1403  5070662 1403  
329576 5070651 1405  5070643 1403  5070629 1403  5070628 1405  5070618 1405  5070620 1403  
329577 5070620 1403  5070610 1403  5070620 1403  5070627 1405  5070629 1403  5070639 1403  
329578 5070643 1403  5070663 1403  5070667 1403  5070672 1403  5070686 1403  5070705 1403  
329579 5070720 1403  5070734 1403  5070753 1403  5070772 1403  5070787 1403  5070810 1403  
329580 5070834 1403  5070858 1403  5070872 1403  5070896 1403  5070911 1403  5070935 1403  
329581 5070954 1403  5070973 1403  5070987 1403  5070997 1403  5071019 1405  5071030 1403  
329582 5071044 1403  5071054 1403  5071064 1403  5071073 1403  5071076 1405  5071088 1403  
329583 5071088 1403  5071097 1403  5071097 1403  5071097 1403  5071097 1403  5071097 1403  
329584 5071097 1403  5071088 1403  5071078 1403  5071076 1405  5071064 1403  5071059 1403  
329585 5071044 1403  5071035 1403  5071021 1403  5071011 1403  5070995 1405  5070978 1403  
329586 5070973 1403  5070959 1403  5070944 1403  5070933 1405  5070909 1405  5070904 1405  
329587 5070887 1403  5070882 1403  5070872 1403  5070866 1405  5070857 1405  5070852 1405  
329588 5070842 1405  5070833 1405  5070830 1403  5070828 1405  5070828 1405  5070819 1405  
329589 5070819 1405  5070819 1405  5070828 1405  5070834 1403  5070833 1405  5070844 1403  
329590 5070852 1405  5070857 1405  5070866 1405  5070882 1403  5070886 1405  5070904 1405  
329591 5070919 1405  5070933 1405  5070949 1409  5070962 1405  5070976 1405  5070992 1409  
329592 5071009 1405  5071033 1405  5071053 1405  5071069 1409  5071086 1405  5071107 1409  
329593 5071126 1409  5071140 1409  5071155 1409  5071169 1409  5071183 1409  5071198 1409  
329594 5071206 1411  5071225 1411  5071231 1409  5071239 1411  5071239 1411  5071248 1411  
329595 5071254 1411  5071253 1411  5071253 1411  5071248 1411  5071248 1411  5071241 1409  
329596 5071230 1411  5071225 1411  5071207 1409  5071197 1409  5071183 1409  5071169 1409  
329597 5071150 1409  5071131 1409  5071115 1411  5071091 1411  5071076 1405  5071054 1409  
329598 5071030 1409  5071006 1409  5070982 1409  5070959 1409  5070939 1409  5070916 1409  
329599 5070892 1409  5070880 1405  5070854 1409  5070828 1411  5070804 1411  5070782 1409  
329600 5070763 1409  5070749 1409  5070728 1411  5070704 1411  5070691 1409  5070675 1411  
329601 5070661 1411  5070656 1411  5070637 1411  5070632 1411  5070623 1411  5070615 1409  
329602 5070604 1411  5070604 1411  5070601 1409  5070599 1411  5070601 1409  5070604 1411  
329603 5070604 1411  5070614 1411  5070623 1411  5070632 1411  5070637 1411  5070658 1409  
329604 5070663 1409  5070677 1409  5070694 1405  5070709 1405  5070725 1409  5070749 1409  
329605 5070766 1405  5070785 1405  5070809 1405  5070828 1405  5070852 1405  5070871 1405  
329606 5070886 1405  5070909 1405  5070930 1409  5070949 1409  5070962 1405  5070973 1409  
329607 5070992 1409  5071019 1405  5071026 1409  5071040 1409  5071057 1405  5071059 1409  
329608 5071072 1405  5071076 1405  5071086 1405  5071093 1409  5071093 1409  5071096 1405  
329609 5071093 1409  5071093 1409  5071083 1409  5071083 1409  5071073 1409  5071068 1409  
329610 5071059 1409  5071054 1409  5071040 1409  5071033 1405  5071026 1409  5071006 1409  
329611 5070991 1411  5070982 1409  5070967 1411  5070954 1409  5070949 1409  5070930 1409  
329612 5070925 1409  5070906 1409  5070900 1411  5070881 1411  5070877 1409  5070868 1409  
329613 5070862 1411  5070849 1409  5070849 1409  5070839 1409  5070830 1409  5070830 1409  
329614 5070825 1409  5070825 1409  5070825 1409  5070825 1409  5070830 1409  5070833 1405  
329615 5070833 1405  5070842 1405  5070852 1405  5070854 1409  5070866 1405  5070881 1405  
329616 5070897 1403  5070904 1405  5070921 1403  5070933 1405  5070952 1405  5070973 1403  
329617 5070986 1405  5071010 1405  5071029 1405  5071044 1403  5071062 1405  5071078 1403  
329618 5071097 1403  5071121 1403  5071135 1403  5071155 1403  5071164 1403  5071178 1403  
329619 5071197 1403  5071202 1403  5071221 1403  5071231 1403  5071236 1403  5071245 1403  
329620 5071255 1403  5071260 1403  5071260 1403  5071260 1403  5071260 1403  5071255 1403  
329621 5071245 1403  5071236 1403  5071231 1403  5071223 1402  5071204 1402  5071188 1403  
329622 5071180 1402  5071166 1402  5071145 1403  5071132 1402  5071108 1402  5071089 1402  
329623 5071065 1402  5071044 1403  5071032 1402  5070998 1402  5070979 1402  5070959 1403  
329624 5070931 1402  5070907 1402  5070884 1402  5070860 1402  5070836 1402  5070812 1402  
329625 5070788 1402  5070763 1403  5070745 1402  5070723 1400  5070697 1402  5070673 1402  
329626 5070664 1402  5070645 1402  5070631 1402  5070613 1400  5070607 1402  5070597 1402  
329627 5070583 1402  5070573 1402  5070568 1402  5070568 1402  5070568 1402  5070568 1402  
329628 5070568 1402  5070573 1402  5070575 1400  5070588 1402  5070597 1402  5070607 1402  
329629 5070621 1402  5070642 1400  5070654 1402  5070667 1403  5070690 1400  5070712 1402  
329630 5070732 1400  5070755 1402  5070783 1402  5070798 1402  5070822 1402  5070845 1402  
329631 5070874 1402  5070898 1402  5070922 1402  5070946 1402  5070960 1402  5070977 1403  
329632 5070997 1403  5071011 1403  5071036 1402  5071044 1403  5071065 1402  5071075 1402  
329633 5071088 1403  5071099 1402  5071108 1402  5071113 1402  5071121 1403  5071123 1402  
329634 5071123 1402  5071121 1403  5071111 1403  5071111 1403  5071108 1402  5071099 1402  
329635 5071089 1402  5071078 1403  5071065 1402  5071060 1402  5071044 1403  5071037 1402  
329636 5071022 1402  5071008 1402  5070989 1402  5070973 1403  5070962 1400  5070955 1402  
329637 5070935 1403  5070922 1402  5070906 1403  5070889 1402  5070872 1403  5070869 1402  
329638 5070854 1403  5070834 1403  5070830 1403  5070820 1403  5070820 1403  5070812 1402  
329639 5070806 1403  5070807 1402  5070806 1403  5070807 1402  5070806 1403  5070806 1403  
329640 5070810 1403  5070810 1403  5070820 1403  5070834 1403  5070844 1403  5070858 1403  
329641 5070868 1403  5070882 1403  5070898 1402  5070921 1403  5070935 1403  5070954 1403  
329642 5070963 1403  5070987 1403  5071006 1403  5071030 1403  5071044 1403  5071064 1403  
329643 5071088 1403  5071107 1403  5071130 1403  5071145 1403  5071159 1403  5071173 1403  
329644 5071197 1403  5071202 1403  5071221 1403  5071236 1403  5071245 1403  5071255 1403  
329645 5071259 1403  5071264 1403  5071274 1403  5071277 1405  5071278 1403  5071274 1403  
329646 5071272 1405  5071274 1403  5071264 1403  5071259 1403  5071245 1403  5071231 1403  
329647 5071221 1403  5071202 1403  5071178 1403  5071164 1403  5071155 1403  5071130 1403  
329648 5071107 1403  5071078 1403  5071054 1403  5071030 1403  5071006 1403  5070973 1403  
329649 5070944 1403  5070920 1403  5070887 1403  5070858 1403  5070834 1403  5070806 1403  
329650 5070772 1403  5070753 1403  5070728 1405  5070694 1405  5070672 1403  5070652 1405  
329651 5070628 1405  5070608 1405  5070594 1405  5070580 1405  5070562 1409  5070558 1409  
329652 5070538 1409  5070534 1409  5070527 1405  5070524 1409  5070524 1409  5070523 1411  
329653 5070524 1409  5070538 1409  5070548 1409  5070556 1411  5070562 1409  5070577 1409  
329654 5070589 1411  5070604 1411  5070632 1411  5070656 1411  5070677 1409  5070691 1409  
329655 5070714 1411  5070747 1411  5070766 1411  5070800 1411  5070823 1411  5070849 1409  
329656 5070876 1411  5070900 1411  5070924 1411  5070954 1409  5070971 1411  5071000 1411  
329657 5071024 1411  5071038 1411  5071058 1411  5071070 1413  5071090 1413  5071105 1411  
329658 5071115 1411  5071125 1411  5071128 1413  5071139 1411  5071139 1411  5071139 1411  
329659 5071148 1411  5071137 1413  5071129 1411  5071129 1411  5071125 1411  5071115 1411  
329660 5071104 1413  5071091 1411  5071080 1413  5071066 1413  5071052 1413  5071038 1411  
329661 5071023 1413  5071005 1411  5070989 1413  5070965 1413  5070951 1413  5070937 1413  
329662 5070914 1411  5070898 1413  5070879 1413  5070867 1411  5070847 1411  5070828 1411  
329663 5070814 1411  5070804 1411  5070800 1411  5070780 1411  5070777 1409  5070768 1409  
329664 5070763 1409  5070761 1411  5070762 1411  5070761 1411  5070763 1409  5070761 1411  
329665 5070766 1411  5070776 1411  5070790 1411  5070800 1411  5070816 1409  5070828 1411  
329666 5070847 1411  5070862 1411  5070876 1411  5070900 1411  5070916 1409  5070938 1411  
329667 5070957 1411  5070981 1411  5071005 1411  5071024 1411  5071049 1409  5071067 1411  
329668 5071091 1411  5071115 1411  5071139 1411  5071158 1411  5071182 1411  5071196 1411  
329669 5071215 1411  5071239 1411  5071254 1411  5071268 1411  5071282 1411  5071292 1411  
329670 5071296 1411  5071306 1411  5071315 1411  5071315 1411  5071315 1411  5071315 1411  
329671 5071317 1409  5071308 1409  5071296 1411  5071292 1411  5071274 1409  5071260 1409  
329672 5071248 1411  5071230 1411  5071206 1411  5071191 1411  5071169 1409  5071140 1409  
329673 5071115 1411  5071093 1409  5071059 1409  5071030 1409  5071002 1409  5070968 1409  
329674 5070938 1411  5070905 1411  5070867 1411  5070847 1411  5070806 1409  5070780 1411  
329675 5070747 1411  5070723 1411  5070701 1409  5070675 1411  5070649 1409  5070623 1411  
329676 5070605 1409  5070582 1409  5070562 1409  5070556 1411  5070538 1409  5070534 1409  
329677 5070524 1409  5070513 1411  5070513 1411  5070512 1413  5070513 1411  5070521 1413  
329678 5070531 1413  5070535 1413  5070556 1411  5070561 1411  5070575 1411  5070599 1411  
329679 5070613 1411  5070637 1411  5070661 1411  5070690 1411  5070714 1411  5070737 1411  
329680 5070765 1413  5070800 1411  5070822 1413  5070852 1411  5070879 1413  5070903 1413  
329681 5070946 1413  5070965 1413  5071000 1411  5071024 1411  5071046 1413  5071067 1411  
329682 5071091 1411  5071105 1411  5071123 1413  5071139 1411  5071155 1409  5071169 1409  
329683 5071172 1411  5071183 1409  5071191 1411  5071198 1409  5071198 1409  5071193 1409  
329684 5071193 1409  5071183 1409  5071172 1411  5071167 1411  5071159 1409  5071150 1409  
329685 5071131 1409  5071115 1411  5071091 1411  5071073 1409  5071053 1411  5071040 1409  
329686 5071014 1411  5070992 1409  5070968 1409  5070954 1409  5070930 1409  5070914 1411  
329687 5070890 1411  5070868 1409  5070852 1411  5070828 1411  5070814 1411  5070800 1411  
329688 5070782 1409  5070768 1409  5070761 1411  5070758 1409  5070747 1411  5070739 1409  
329689 5070739 1409  5070739 1409  5070737 1411  5070737 1411  5070747 1411  5070747 1411  
329690 5070763 1409  5070766 1411  5070777 1409  5070790 1411  5070804 1411  5070828 1411  
329691 5070847 1411  5070862 1411  5070881 1411  5070905 1411  5070929 1411  5070953 1411  
329692 5070970 1413  5071003 1413  5071029 1411  5071051 1413  5071070 1413  5071105 1411  
329693 5071128 1413  5071156 1413  5071180 1413  5071204 1413  5071225 1411  5071247 1413  
329694 5071266 1413  5071280 1413  5071296 1411  5071314 1413  5071319 1413  5071339 1411  
329695 5071339 1411  5071347 1413  5071352 1413  5071353 1411  5071352 1413  5071347 1413  
329696 5071338 1413  5071328 1413  5071319 1413  5071304 1413  5071289 1415  5071271 1413  
329697 5071252 1413  5071226 1415  5071195 1413  5071171 1413  5071145 1415  5071112 1415  
329698 5071088 1415  5071055 1415  5071021 1415  5070986 1417  5070954 1415  5070926 1415  
329699 5070888 1415  5070859 1415  5070824 1417  5070795 1417  5070763 1415  5070734 1415  
329700 5070699 1417  5070671 1417  5070652 1417  5070628 1417  5070599 1417  5070585 1417  
329701 5070569 1418  5070555 1419  5070540 1418  5070531 1418  5070526 1418  5070517 1418  
329702 5070515 1420  5070517 1419  5070515 1420  5070515 1420  5070525 1420  5070539 1420  
329703 5070553 1420  5070564 1424  5070582 1420  5070596 1420  5070625 1420  5070645 1424  
329704 5070665 1424  5070689 1424  5070717 1424  5070746 1424  5070770 1424  5070803 1424  
329705 5070840 1420  5070865 1424  5070903 1424  5070928 1424  5070956 1424  5070990 1424  
329706 5071018 1424  5071042 1424  5071071 1424  5071095 1424  5071119 1424  5071142 1424  
329707 5071157 1424  5071174 1420  5071189 1420  5071198 1420  5071207 1420  5071217 1420  
329708 5071222 1420  5071222 1420  5071222 1420  5071222 1420  5071222 1420  5071217 1420  
329709 5071207 1420  5071195 1424  5071183 1420  5071157 1424  5071142 1424  5071131 1420  
329710 5071104 1424  5071083 1420  5071061 1424  5071042 1424  5071013 1424  5070990 1424  
329711 5070961 1424  5070937 1424  5070913 1424  5070892 1420  5070870 1424  5070851 1424  
329712 5070827 1424  5070803 1424  5070779 1424  5070764 1426  5070751 1424  5070736 1424  
329713 5070716 1426  5070712 1424  5070703 1424  5070693 1424  5070692 1426  5070687 1426  
329714 5070689 1424  5070689 1424  5070692 1426  5070692 1426  5070711 1426  5070718 1424  
329715 5070735 1426  5070744 1426  5070754 1426  5070778 1426  5070792 1426  5070818 1424  
329716 5070840 1426  5070854 1426  5070888 1426  5070910 1428  5070935 1426  5070956 1424  
329717 5070988 1426  5071018 1424  5071040 1426  5071069 1426  5071103 1426  5071126 1426  
329718 5071147 1424  5071180 1424  5071203 1426  5071228 1424  5071247 1424  5071262 1424  
329719 5071281 1424  5071305 1424  5071309 1424  5071329 1424  5071338 1424  5071346 1420  
329720 5071343 1424  5071348 1424  5071351 1420  5071347 1424  5071343 1424  5071338 1424  
329721 5071332 1420  5071310 1424  5071298 1420  5071274 1420  5071260 1420  5071233 1418  
329722 5071209 1418  5071174 1420  5071152 1418  5071125 1417  5071094 1419  5071055 1415  
329723 5071026 1415  5070997 1415  5070965 1413  5070927 1413  5070890 1411  5070862 1411  
329724 5070825 1409  5070792 1409  5070763 1409  5070728 1405  5070694 1405  5070670 1405  
329725 5070639 1409  5070618 1405  5070604 1405  5070580 1405  5070558 1409  5070541 1405  
329726 5070537 1405  5070524 1409  5070515 1409  5070508 1405  5070508 1405  5070508 1405  
329727 5070518 1405  5070518 1405  5070527 1405  5070538 1409  5070561 1405  5070570 1405  
329728 5070585 1405  5070605 1409  5070637 1405  5070648 1409  5070680 1405  5070709 1405  
329729 5070742 1405  5070763 1409  5070804 1405  5070828 1405  5070854 1409  5070886 1405  
329730 5070928 1405  5070957 1405  5070982 1409  5071016 1409  5071053 1405  5071069 1409  
329731 5071093 1409  5071120 1405  5071143 1405  5071163 1405  5071183 1409  5071198 1409  
329732 5071207 1409  5071226 1409  5071231 1409  5071240 1409  5071253 1405  5071250 1409  
329733 5071250 1409  5071241 1409  5071240 1409  5071230 1411  5071217 1409  5071205 1411  
329734 5071193 1409  5071172 1411  5071158 1411  5071140 1409  5071116 1409  5071090 1413  
329735 5071069 1409  5071049 1409  5071024 1411  5070991 1411  5070967 1411  5070938 1411  
329736 5070913 1413  5070890 1411  5070862 1411  5070846 1413  5070812 1413  5070800 1411  
329737 5070774 1413  5070760 1413  5070736 1413  5070722 1413  5070702 1413  5070687 1415  
329738 5070679 1413  5070674 1413  5070664 1413  5070660 1413  5070658 1415  5070660 1413  
329739 5070664 1413  5070674 1413  5070677 1415  5070688 1413  5070703 1413  5070710 1415  
329740 5070736 1413  5070760 1413  5070773 1415  5070797 1415  5070821 1415  5070846 1413  
329741 5070874 1413  5070898 1413  5070927 1413  5070954 1415  5070988 1415  5071021 1415  
329742 5071045 1415  5071069 1415  5071104 1413  5071137 1413  5071155 1415  5071190 1413  
329743 5071212 1415  5071237 1413  5071255 1415  5071280 1413  5071293 1415  5071318 1413  
329744 5071338 1413  5071346 1415  5071352 1413  5071357 1413  5071366 1413  5071365 1415  
329745 5071366 1413  5071366 1413  5071357 1413  5071352 1413  5071336 1415  5071319 1413  
329746 5071304 1413  5071289 1415  5071266 1413  5071247 1413  5071225 1411  5071190 1413  
329747 5071156 1413  5071137 1413  5071099 1413  5071067 1411  5071038 1411  5071005 1411  
329748 5070965 1413  5070937 1413  5070903 1413  5070865 1413  5070836 1413  5070804 1411  
329749 5070774 1413  5070747 1411  5070722 1413  5070690 1411  5070666 1411  5070647 1411  
329750 5070621 1413  5070602 1413  5070588 1413  5070579 1413  5070563 1415  5070559 1413  
329751 5070559 1413  5070559 1413  5070555 1413  5070559 1413  5070559 1413  5070573 1413  
329752 5070580 1411  5070598 1413  5070612 1413  5070631 1413  5070656 1411  5070675 1411  
329753 5070698 1413  5070722 1413  5070755 1413  5070779 1413  5070803 1413  5070835 1415  
329754 5070865 1413  5070898 1413  5070926 1415  5070956 1413  5070989 1413  5071023 1413  
329755 5071051 1413  5071080 1413  5071113 1413  5071136 1415  5071156 1413  5071190 1413  
329756 5071204 1413  5071228 1413  5071247 1413  5071257 1413  5071271 1413  5071280 1413  
329757 5071292 1411  5071293 1415  5071295 1413  5071295 1413  5071295 1413  5071296 1411  
329758 5071282 1411  5071271 1413  5071257 1413  5071254 1411  5071228 1413  5071213 1413  
329759 5071192 1411  5071166 1413  5071148 1411  5071124 1411  5071100 1411  5071072 1411  
329760 5071048 1411  5071024 1411  5070989 1413  5070967 1411  5070938 1411  5070905 1411  
329761 5070881 1411  5070863 1409  5070830 1409  5070816 1409  5070780 1411  5070766 1411  
329762 5070747 1411  5070730 1409  5070715 1409  5070704 1411  5070690 1411  5070680 1411  
329763 5070680 1411  5070674 1413  5070675 1411  5070682 1409  5070680 1411  5070690 1411  
329764 5070690 1411  5070702 1413  5070714 1411  5070737 1411  5070757 1411  5070776 1411  
329765 5070790 1411  5070814 1411  5070838 1411  5070866 1411  5070889 1413  5070924 1411  
329766 5070951 1413  5070970 1413  5071005 1411  5071038 1411  5071058 1411  5071090 1413  
329767 5071124 1411  5071151 1413  5071171 1413  5071204 1413  5071228 1413  5071252 1413  
329768 5071271 1413  5071290 1413  5071314 1413  5071328 1413  5071347 1413  5071353 1411  
329769 5071359 1411  5071368 1411  5071368 1411  5071370 1409  5071368 1411  5071359 1411  
329770 5071353 1411  5071350 1409  5071339 1411  5071322 1409  5071307 1409  5071292 1411  
329771 5071268 1411  5071248 1411  5071226 1409  5071196 1411  5071169 1409  5071148 1411  
329772 5071115 1411  5071083 1409  5071054 1409  5071024 1411  5070991 1411  5070953 1411  
329773 5070924 1411  5070892 1409  5070862 1411  5070838 1411  5070804 1411  5070775 1411  
329774 5070757 1411  5070729 1409  5070705 1409  5070690 1411  5070675 1411  5070661 1411  
329775 5070648 1409  5070637 1411  5070632 1411  5070623 1411  5070623 1411  5070623 1411  
329776 5070623 1411  5070634 1409  5070637 1411  5070648 1409  5070656 1411  5070666 1411  
329777 5070680 1411  5070704 1411  5070723 1411  5070747 1411  5070766 1411  5070800 1411  
329778 5070824 1411  5070847 1411  5070877 1409  5070906 1409  5070939 1409  5070957 1411  
329779 5070991 1411  5071026 1409  5071053 1405  5071072 1411  5071110 1405  5071131 1409  
329780 5071155 1409  5071186 1405  5071207 1409  5071229 1405  5071250 1409  5071260 1409  
329781 5071274 1409  5071293 1409  5071298 1409  5071307 1409  5071317 1409  5071317 1409  
329782 5071317 1409  5071317 1409  5071310 1405  5071298 1409  5071286 1405  5071277 1405  
329783 5071263 1405  5071253 1405  5071231 1409  5071207 1409  5071183 1409  5071159 1409  
329784 5071159 1409  5071102 1409  5071083 1409  5071054 1409  5071033 1405  5071006 1409  
329785 5070982 1409  5070954 1409  5070933 1405  5070904 1405  5070877 1409  5070857 1405  
329786 5070830 1409  5070804 1405  5070782 1409  5070763 1409  5070742 1405  5070729 1409  
329787 5070718 1405  5070701 1409  5070694 1405  5070685 1405  5070680 1405  5070680 1405  
329788 5070680 1405  5070680 1405  5070680 1405  5070685 1405  5070694 1405  5070705 1403  
329789 5070720 1403  5070732 1405  5070752 1405  5070766 1405  5070785 1405  5070804 1405  
329790 5070828 1405  5070857 1405  5070880 1405  5070904 1405  5070933 1405  5070959 1403  
329791 5070976 1405  5071009 1405  5071043 1405  5071062 1405  5071095 1405  5071129 1405  
329792 5071153 1405  5071172 1405  5071196 1405  5071216 1409  5071243 1405  5071258 1405  
329793 5071272 1405  5071283 1409  5071293 1409  5071310 1405  5071320 1405  5071320 1405  
329794 5071317 1409  5071322 1409  5071317 1409  5071307 1409  5071301 1405  5071296 1405  
329795 5071283 1409  5071269 1409  5071255 1409  5071241 1409  5071226 1409  5071197 1409  
329796 5071174 1409  5071155 1409  5071126 1409  5071102 1409  5071069 1409  5071049 1409  
329797 5071016 1409  5070986 1405  5070954 1409  5070933 1405  5070901 1409  5070871 1405  
329798 5070852 1405  5070816 1409  5070792 1409  5070777 1409  5070761 1405  5070730 1409  
329799 5070718 1405  5070701 1409  5070685 1405  5070680 1405  5070663 1409  5070658 1409  
329800 5070658 1409  5070652 1405  5070658 1409  5070658 1409  5070658 1409  5070661 1411  
329801 5070667 1409  5070675 1411  5070690 1411  5070704 1411  5070723 1411  5070736 1413  
329802 5070760 1413  5070779 1413  5070804 1411  5070827 1413  5070851 1413  5070879 1413  
329803 5070903 1413  5070926 1415  5070956 1413  5070988 1415  5071011 1415  5071046 1413  
329804 5071066 1413  5071088 1415  5071121 1415  5071145 1415  5071166 1413  5071190 1413  
329805 5071212 1415  5071226 1415  5071247 1413  5071255 1415  5071271 1413  5071280 1413  
329806 5071290 1413  5071290 1413  5071295 1413  5071295 1413  5071290 1413  5071290 1413  
329807 5071280 1413  5071271 1413  5071257 1413  5071248 1411  5071237 1413  5071223 1413  
329808 5071195 1413  5071179 1415  5071156 1413  5071137 1413  5071113 1413  5071090 1413  
329809 5071065 1413  5071037 1413  5071005 1411  5070979 1413  5070951 1413  5070927 1413  
329810 5070898 1413  5070874 1413  5070851 1413  5070822 1413  5070800 1411  5070780 1411  
329811 5070761 1411  5070736 1413  5070723 1411  5070704 1411  5070690 1411  5070680 1411  
329812 5070675 1411  5070664 1413  5070666 1411  5070660 1413  5070661 1411  5070660 1413  
329813 5070666 1411  5070675 1411  5070678 1413  5070688 1413  5070703 1413  5070723 1411  
329814 5070736 1413  5070755 1413  5070774 1413  5070800 1411  5070814 1411  5070838 1411  
329815 5070865 1413  5070890 1411  5070914 1411  5070938 1411  5070956 1413  5070991 1411  
329816 5071013 1413  5071046 1413  5071066 1413  5071090 1413  5071115 1411  5071147 1413  
329817 5071157 1413  5071180 1413  5071195 1413  5071213 1413  5071225 1411  5071239 1411  
329818 5071248 1411  5071252 1413  5071257 1413  5071258 1411  5071268 1411  5071258 1411  
329819 5071258 1411  5071254 1411  5071248 1411  5071239 1411  5071229 1411  5071223 1413  
329820 5071205 1411  5071191 1411  5071174 1409  5071153 1411  5071129 1411  5071116 1409  
329821 5071091 1411  5071058 1411  5071038 1411  5071026 1409  5070991 1411  5070967 1411  
329822 5070948 1411  5070914 1411  5070890 1411  5070866 1411  5070847 1411  5070824 1411  
329823 5070804 1411  5070780 1411  5070766 1411  5070758 1409  5070737 1411  5070723 1411  
329824 5070714 1411  5070704 1411  5070704 1411  5070701 1409  5070699 1411  5070690 1411  
329825 5070690 1411  5070699 1411  5070699 1411  5070704 1411  5070722 1413  5070728 1411  
329826 5070747 1411  5070761 1411  5070780 1411  5070800 1411  5070814 1411  5070838 1411  
329827 5070851 1413  5070876 1411  5070898 1413  5070924 1411  5070953 1411  5070972 1411  
329828 5071000 1411  5071024 1411  5071048 1411  5071069 1409  5071091 1411  5071116 1409  
329829 5071139 1411  5071158 1411  5071183 1409  5071196 1411  5071216 1409  5071229 1411  
329830 5071248 1411  5071255 1409  5071268 1411  5071268 1411  5071269 1409  5071274 1409  
329831 5071274 1409  5071272 1411  5071269 1409  5071260 1409  5071255 1409  5071240 1409  
329832 5071231 1409  5071226 1409  5071207 1409  5071183 1409  5071169 1409  5071150 1409  
329833 5071129 1411  5071107 1409  5071081 1411  5071058 1411  5071040 1409  5071006 1409  
329834 5070982 1409  5070954 1409  5070930 1409  5070905 1411  5070883 1409  5070862 1411  
329835 5070830 1409  5070804 1411  5070782 1409  5070766 1411  5070757 1411  5070730 1409  
329836 5070715 1409  5070706 1409  5070690 1411  5070682 1409  5070675 1411  5070667 1409  
329837 5070663 1409  5070663 1409  5070661 1411  5070663 1409  5070667 1409  5070677 1409  
329838 5070682 1409  5070691 1409  5070706 1409  5070725 1409  5070737 1411  5070758 1409  
329839 5070766 1411  5070780 1411  5070803 1413  5070828 1411  5070847 1411  5070867 1411  
329840 5070890 1411  5070914 1411  5070937 1413  5070953 1411  5070982 1409  5071006 1409  
329841 5071026 1409  5071048 1411  5071058 1411  5071081 1411  5071101 1411  5071115 1411  
329842 5071129 1411  5071147 1413  5071158 1411  5071167 1411  5071171 1413  5071180 1413  
329843 5071180 1413  5071190 1413  5071190 1413  5071190 1413  5071188 1415  5071180 1413  
329844 5071169 1415  5071166 1413  5071155 1415  5071150 1415  5071137 1413  5071123 1413  
329845 5071104 1413  5071090 1413  5071069 1415  5071056 1413  5071037 1413  5071011 1415  
329846 5070989 1413  5070970 1413  5070951 1413  5070927 1413  5070903 1413  5070889 1413  
329847 5070874 1413  5070851 1413  5070827 1413  5070812 1413  5070798 1413  5070779 1413  
329848 5070765 1413  5070760 1413  5070747 1411  5070736 1413  5070736 1413  5070727 1413  
329849 5070722 1413  5070722 1413  5070723 1411  5070728 1411  5070728 1411  5070726 1413  
329850 5070736 1413  5070745 1413  5070760 1413  5070765 1413  5070777 1415  5070797 1415  
329851 5070811 1415  5070822 1413  5070846 1413  5070860 1413  5070879 1413  5070900 1411  
329852 5070922 1413  5070946 1413  5070957 1411  5070979 1413  5071005 1411  5071027 1413  
329853 5071046 1413  5071067 1411  5071081 1411  5071105 1411  5071123 1413  5071139 1411  
329854 5071156 1413  5071166 1413  5071182 1411  5071191 1411  5071204 1413  5071206 1411  
329855 5071215 1411  5071215 1411  5071226 1409  5071225 1411  5071226 1409  5071217 1409  
329856 5071217 1409  5071207 1409  5071197 1409  5071191 1411  5071172 1411  5071159 1409  
329857 5071150 1409  5071139 1411  5071116 1409  5071102 1409  5071072 1411  5071056 1413  
329858 5071040 1409  5071016 1409  5070991 1411  5070967 1411  5070949 1409  5070924 1411  
329859 5070890 1411  5070868 1409  5070849 1409  5070825 1409  5070806 1409  5070780 1411  
329860 5070768 1409  5070757 1411  5070739 1409  5070723 1411  5070704 1411  5070701 1409  
329861 5070688 1413  5070680 1411  5070677 1409  5070666 1411  5070666 1411  5070661 1411  
329862 5070666 1411  5070661 1411  5070666 1411  5070675 1411  5070679 1413  5070690 1411  
329863 5070699 1411  5070714 1411  5070729 1409  5070747 1411  5070757 1411  5070766 1411  
329864 5070780 1411  5070804 1411  5070822 1413  5070847 1411  5070860 1413  5070879 1413  
329865 5070900 1411  5070913 1413  5070937 1413  5070950 1415  5070967 1411  5070989 1413  
329866 5071003 1413  5071023 1413  5071035 1415  5071050 1415  5071064 1415  5071080 1413  
329867 5071077 1417  5071099 1413  5071104 1413  5071112 1415  5071110 1417  5071121 1415  
329868 5071110 1417  5071112 1415  5071121 1415  5071110 1417  5071112 1415  5071102 1415  
329869 5071096 1417  5071088 1415  5071077 1417  5071063 1417  5071053 1417  5071043 1417  
329870 5071024 1417  5071020 1417  5071000 1417  5070985 1418  5070967 1417  5070946 1418  
329871 5070932 1418  5070919 1417  5070910 1417  5070895 1417  5070875 1418  5070860 1418  
329872 5070847 1417  5070833 1417  5070824 1417  5070819 1417  5070798 1418  5070795 1417  
329873 5070786 1417  5070774 1418  5070777 1415  5070771 1417  5070771 1417  5070771 1417  
329874 5070771 1417  5070771 1417  5070771 1417  5070771 1417  5070777 1415  5070787 1415  
329875 5070797 1415  5070801 1415  5070812 1413  5070827 1413  5070846 1413  5070851 1413  
329876 5070865 1413  5070881 1411  5070900 1411  5070913 1413  5070929 1411  5070951 1413  
329877 5070967 1411  5070981 1411  5071005 1411  5071023 1413  5071037 1413  5071055 1415  
329878 5071070 1413  5071088 1415  5071104 1413  5071121 1415  5071126 1415  5071145 1415  
329879 5071156 1413  5071164 1415  5071169 1415  5071180 1413  5071179 1415  5071179 1415  
329880 5071179 1415  5071179 1415  5071177 1417  5071179 1415  5071177 1417  5071168 1417  
329881 5071163 1417  5071153 1417  5071148 1417  5071134 1417  5071121 1415  5071110 1417  
329882 5071096 1417  5071078 1415  5071063 1417  5071042 1418  5071024 1417  5071002 1415  
329883 5070977 1417  5070953 1417  5070933 1417  5070919 1417  5070895 1417  5070876 1417  
329884 5070857 1417  5070843 1417  5070821 1415  5070800 1417  5070786 1417  5070773 1415  
329885 5070757 1417  5070744 1415  5070734 1415  5070720 1415  5070710 1415  5070702 1413  
329886 5070698 1413  5070688 1413  5070688 1413  5070688 1413  5070688 1413  5070679 1413  
329887 5070687 1415  5070687 1415  5070698 1413  5070703 1413  5070712 1413  5070726 1413  
329888 5070725 1415  5070744 1415  5070755 1413  5070765 1413  5070777 1415  5070789 1413  
329889 5070801 1415  5070822 1413  5070836 1413  5070851 1413  5070860 1413  5070879 1413  
329890 5070898 1413  5070913 1413  5070926 1415  5070948 1411  5070949 1415  5070967 1411  
329891 5070979 1413  5070999 1413  5071003 1413  5071023 1413  5071027 1413  5071037 1413  
329892 5071037 1413  5071046 1413  5071053 1411  5071053 1411  5071053 1411  5071053 1411  
329893 5071058 1411  5071058 1411  5071053 1411  5071053 1411  5071046 1413  5071037 1413  
329894 5071037 1413  5071027 1413  5071023 1413  5071013 1413  5071005 1411  5070989 1413  
329895 5070981 1411  5070970 1413  5070956 1413  5070951 1413  5070937 1413  5070922 1413  
329896 5070913 1413  5070898 1413  5070890 1411  5070881 1411  5070874 1413  5070866 1411  
329897 5070851 1413  5070846 1413  5070836 1413  5070827 1413  5070828 1411  5070824 1411  
329898 5070814 1411  5070814 1411  5070812 1413  5070803 1413  5070804 1411  5070804 1411  
329899 5070804 1411  5070814 1411  5070824 1411  5070824 1411  5070827 1413  5070838 1411  
329900 5070847 1411  5070852 1411  5070860 1413  5070874 1413  5070881 1411  5070900 1411  
329901 5070905 1411  5070924 1411  5070938 1411  5070948 1411  5070957 1411  5070972 1411  
329902 5070991 1411  5071005 1411  5071023 1413  5071029 1411  5071048 1411  5071056 1413  
329903 5071072 1411  5071081 1411  5071101 1411  5071104 1413  5071125 1411  5071129 1411  
329904 5071137 1413  5071148 1411  5071146 1413  5071151 1413  5071156 1413  5071151 1413  
329905 5071151 1413  5071151 1413  5071151 1413  5071146 1413  5071137 1413  5071137 1413  
329906 5071128 1413  5071113 1413  5071104 1413  5071099 1413  5071080 1413  5071064 1415  
329907 5071049 1415  5071035 1415  5071023 1413  5071000 1417  5070988 1415  5070965 1413  
329908 5070950 1415  5070934 1417  5070911 1415  5070895 1417  5070876 1417  5070863 1415  
329909 5070849 1415  5070835 1415  5070819 1417  5070803 1413  5070787 1415  5070777 1415  
329910 5070763 1415  5070758 1415  5070744 1415  5070734 1415  5070723 1417  5070725 1415  
329911 5070722 1413  5070711 1415  5070712 1413  5070710 1415  5070710 1415  5070712 1413  
329912 5070712 1413  5070723 1411  5070720 1415  5070726 1413  5070726 1413  5070736 1413  
329913 5070745 1413  5070755 1413  5070760 1413  5070765 1413  5070776 1411  5070788 1413  
329914 5070798 1413  5070812 1413  5070827 1413  5070836 1413  5070852 1411  5070862 1411  
329915 5070876 1411  5070889 1413  5070905 1411  5070913 1413  5070927 1413  5070938 1411  
329916 5070951 1413  5070956 1413  5070967 1411  5070970 1413  5070979 1413  5070991 1411  
329917 5071000 1411  5071005 1411  5071003 1413  5071014 1411  5071014 1411  5071023 1413  
329918 5071023 1413  5071023 1413  5071023 1413  5071023 1413  5071013 1413  5071013 1413  
329919 5071013 1413  5071003 1413  5070999 1413  5070991 1411  5070989 1413  5070981 1411  
329920 5070972 1411  5070965 1413  5070956 1413  5070951 1413  5070946 1413  5070938 1411  
329921 5070927 1413  5070922 1413  5070913 1413  5070903 1413  5070900 1411  5070887 1415  
329922 5070879 1413  5070874 1413  5070863 1415  5070865 1413  5070860 1413  5070860 1413  
329923 5070851 1413  5070851 1413  5070851 1413  5070846 1413  5070851 1413  5070851 1413  
329924 5070852 1411  5070852 1411  5070851 1413  5070860 1413  5070866 1411  5070876 1411  
329925 5070881 1411  5070890 1411  5070900 1411  5070905 1411  5070924 1411  5070929 1411  
329926 5070937 1413  5070954 1409  5070959 1409  5070967 1411  5070982 1409  5070992 1409  
329927 5071006 1409  5071026 1409  5071038 1411  5071053 1411  5071058 1411  5071069 1409  
329928 5071081 1411  5071091 1411  5071101 1411  5071107 1409  5071115 1411  5071129 1411  
329929 5071129 1411  5071139 1411  5071139 1411  5071148 1411  5071148 1411  5071148 1411  
329930 5071148 1411  5071148 1411  5071140 1409  5071129 1411  5071129 1411  5071125 1411  
329931 5071115 1411  5071105 1411  5071101 1411  5071081 1411  5071072 1411  5071058 1411  
329932 5071053 1411  5071037 1413  5071023 1413  5071004 1413  5070991 1411  5070972 1411  
329933 5070956 1413  5070946 1413  5070929 1411  5070914 1411  5070898 1413  5070879 1413  
329934 5070866 1411  5070851 1413  5070838 1411  5070823 1411  5070803 1413  5070800 1411  
329935 5070780 1411  5070774 1413  5070766 1411  5070761 1411  5070749 1409  5070747 1411  
329936 5070737 1411  5070728 1411  5070728 1411  5070722 1413  5070723 1411  5070723 1411  
329937 5070723 1411  5070723 1411  5070723 1411  5070728 1411  5070728 1411  5070728 1411  
329938 5070737 1411  5070747 1411  5070757 1411  5070762 1411  5070766 1411  5070776 1411  
329939 5070780 1411  5070790 1411  5070804 1411  5070816 1409  5070830 1409  5070839 1409  
329940 5070854 1409  5070863 1409  5070877 1409  5070883 1409  5070890 1411  5070905 1411  
329941 5070916 1409  5070924 1411  5070938 1411  5070948 1411  5070954 1409  5070959 1409  
329942 5070968 1409  5070973 1409  5070981 1411  5070982 1409  5070991 1411  5071000 1411  
329943 5071000 1411  5071005 1411  5071005 1411  5071005 1411  5071005 1411  5071005 1411  
329944 5071003 1413  5071005 1411  5071000 1411  5071000 1411  5070989 1413  5070991 1411  
329945 5070981 1411  5070971 1411  5070967 1411  5070957 1411  5070953 1411  5070953 1411  
329946 5070948 1411  5070938 1411  5070929 1411  5070924 1411  5070914 1411  5070906 1409  
329947 5070900 1411  5070890 1411  5070881 1411  5070883 1409  5070877 1409  5070866 1411  
329948 5070868 1409  5070866 1411  5070866 1411  5070866 1411  5070866 1411  5070868 1409  
329949 5070866 1411  5070866 1411  5070866 1411  5070876 1411  5070876 1411  5070881 1411  
329950 5070892 1409  5070901 1409  5070901 1409  5070906 1409  5070925 1409  5070930 1409  
329951 5070940 1409  5070949 1409  5070957 1411  5070968 1409  5070981 1411  5071002 1409  
329952 5071005 1411  5071024 1411  5071029 1411  5071048 1411  5071053 1411  5071059 1409  
329953 5071072 1411  5071083 1409  5071091 1411  5071101 1411  5071115 1411  5071116 1409  
329954 5071125 1411  5071131 1409  5071139 1411  5071139 1411  5071139 1411  5071148 1411  
329955 5071150 1409  5071139 1411  5071139 1411  5071139 1411  5071129 1411  5071126 1409  
329956 5071115 1411  5071105 1411  5071101 1411  5071092 1409  5071083 1409  5071073 1409  
329957 5071058 1411  5071049 1409  5071040 1409  5071026 1409  5071006 1409  5070991 1411  
329958 5070972 1411  5070959 1409  5070947 1411  5070930 1409  5070914 1411  5070900 1411  
329959 5070882 1409  5070868 1409  5070854 1409  5070838 1411  5070823 1411  5070815 1409  
329960 5070800 1411  5070782 1409  5070766 1411  5070761 1411  5070747 1411  5070737 1411  
329961 5070729 1409  5070722 1413  5070714 1411  5070704 1411  5070705 1409  5070699 1411  
329962 5070699 1411  5070699 1411  5070699 1411  5070699 1411  5070704 1411  5070703 1413  
329963 5070704 1411  5070702 1413  5070715 1409  5070723 1411  5070728 1411  5070737 1411  
329964 5070747 1411  5070761 1411  5070766 1411  5070780 1411  5070790 1411  5070804 1411  
329965 5070814 1411  5070828 1411  5070838 1411  5070852 1411  5070866 1411  5070881 1411  
329966 5070890 1411  5070903 1413  5070924 1411  5070929 1411  5070946 1413  5070951 1413  
329967 5070965 1413  5070970 1413  5070981 1411  5070991 1411  5071000 1411  5071003 1413  
329968 5071014 1411  5071024 1411  5071024 1411  5071024 1411  5071029 1411  5071029 1411  
329969 5071027 1413  5071038 1411  5071029 1411  5071029 1411  5071024 1411  5071024 1411  
329970 5071014 1411  5071003 1413  5071000 1411  5070989 1413  5070979 1413  5070979 1413  
329971 5070965 1413  5070957 1411  5070951 1413  5070946 1413  5070938 1411  5070927 1413  
329972 5070924 1411  5070914 1411  5070903 1413  5070898 1413  5070890 1411  5070881 1411  
329973 5070874 1413  5070865 1413  5070865 1413  5070860 1413  5070860 1413  5070860 1413  
329974 5070860 1413  5070851 1413  5070860 1413  5070860 1413  5070860 1413  5070865 1413  
329975 5070866 1411  5070874 1413  5070881 1411  5070889 1413  5070898 1413  5070914 1411  
329976 5070922 1413  5070927 1413  5070946 1413  5070956 1413  5070967 1411  5070981 1411  
329977 5070999 1413  5071013 1413  5071023 1413  5071037 1413  5071051 1413  5071065 1413  
329978 5071072 1411  5071091 1411  5071099 1413  5071113 1413  5071124 1411  5071129 1411  
329979 5071137 1413  5071151 1413  5071151 1413  5071156 1413  5071166 1413  5071166 1413  
329980 5071166 1413  5071166 1413  5071167 1411  5071156 1413  5071158 1411  5071153 1411  
329981 5071151 1413  5071148 1411  5071128 1413  5071123 1413  5071113 1413  5071100 1411  
329982 5071080 1413  5071067 1411  5071058 1411  5071046 1413  5071023 1413  5071005 1411  
329983 5070989 1413  5070971 1411  5070953 1411  5070936 1413  5070922 1413  5070905 1411  
329984 5070879 1413  5070866 1411  5070852 1411  5070828 1411  5070812 1413  5070798 1413  
329985 5070779 1413  5070765 1413  5070757 1411  5070737 1411  5070728 1411  5070712 1413  
329986 5070704 1411  5070698 1413  5070680 1411  5070678 1413  5070674 1413  5070674 1413  
329987 5070664 1413  5070664 1413  5070666 1411  5070664 1413  5070664 1413  5070664 1413  
329988 5070674 1413  5070674 1413  5070678 1413  5070688 1413  5070702 1413  5070714 1411  
329989 5070722 1413  5070736 1413  5070745 1413  5070761 1411  5070776 1411  5070788 1413  
329990 5070806 1409  5070824 1411  5070838 1411  5070862 1411  5070876 1411  5070890 1411  
329991 5070906 1409  5070928 1405  5070952 1405  5070962 1405  5070977 1403  5070986 1405  
329992 5071006 1403  5071021 1403  5071030 1403  5071043 1405  5071053 1405  5071057 1405  
329993 5071062 1405  5071059 1409  5071072 1405  5071076 1405  5071073 1409  5071073 1409  
329994 5071073 1409  5071076 1405  5071073 1409  5071069 1409  5071062 1405  5071057 1405  
329995 5071053 1405  5071043 1405  5071030 1409  5071026 1409  5071006 1409  5071002 1409  
329996 5070992 1409  5070981 1411  5070967 1411  5070957 1411  5070949 1409  5070938 1411  
329997 5070922 1413  5070915 1409  5070900 1411  5070890 1411  5070881 1411  5070874 1413  
329998 5070866 1411  5070862 1411  5070852 1411  5070846 1413  5070846 1413  5070838 1411  
329999 5070836 1413  5070836 1413  5070836 1413  5070836 1413  5070846 1413  5070847 1411  
330000 5070851 1413  5070860 1413  5070865 1413  5070874 1413  5070889 1413  5070898 1413  
330001 5070914 1411  5070924 1411  5070936 1413  5070953 1411  5070967 1411  5070981 1411  
330002 5070999 1413  5071014 1411  5071029 1411  5071048 1411  5071067 1411  5071073 1409  
330003 5071092 1409  5071115 1411  5071129 1411  5071147 1413  5071158 1411  5071169 1409  
330004 5071172 1411  5071191 1411  5071198 1409  5071207 1409  5071216 1409  5071215 1411  
330005 5071217 1409  5071216 1409  5071216 1409  5071217 1409  5071216 1409  5071210 1405  
330006 5071198 1409  5071193 1409  5071183 1409  5071172 1411  5071159 1409  5071150 1409  
330007 5071131 1409  5071126 1409  5071102 1409  5071083 1409  5071059 1409  5071040 1409  
330008 5071026 1409  5071002 1409  5070967 1411  5070949 1409  5070924 1411  5070901 1409  
330009 5070876 1411  5070854 1409  5070830 1409  5070806 1409  5070785 1405  5070766 1405  
330010 5070742 1405  5070728 1405  5070709 1405  5070682 1409  5070670 1405  5070661 1405  
330011 5070642 1405  5070634 1409  5070628 1405  5070618 1405  5070605 1409  5070608 1405  
330012 5070601 1409  5070605 1403  5070604 1405  5070604 1405  5070608 1405  5070618 1405  
330013 5070628 1405  5070637 1405  5070642 1405  5070662 1403  5070670 1405  5070685 1405  
330014 5070704 1405  5070715 1409  5070732 1405  5070758 1409  5070768 1409  5070795 1405  
330015 5070819 1405  5070830 1409  5070857 1405  5070880 1405  5070904 1405  5070928 1405  
330016 5070944 1403  5070962 1405  5070986 1405  5071005 1405  5071029 1405  5071033 1405  
330017 5071054 1403  5071062 1405  5071076 1405  5071086 1405  5071106 1403  5071111 1403  
330018 5071120 1405  5071120 1405  5071129 1405  5071131 1403  5071130 1403  5071129 1405  
330019 5071120 1405  5071119 1405  5071110 1405  5071105 1405  5071096 1405  5071078 1403  
330020 5071072 1405  5071062 1405  5071053 1405  5071033 1405  5071019 1405  5071005 1405  
330021 5070986 1405  5070971 1405  5070957 1405  5070944 1403  5070930 1403  5070906 1403  
330022 5070895 1405  5070882 1403  5070866 1405  5070852 1405  5070834 1403  5070828 1405  
330023 5070810 1403  5070806 1403  5070795 1405  5070785 1405  5070787 1403  5070787 1403  
330024 5070785 1405  5070796 1403  5070796 1403  5070806 1403  5070806 1403  5070810 1403  
330025 5070820 1403  5070834 1403  5070852 1405  5070857 1405  5070871 1405  5070896 1403  
330026 5070911 1403  5070928 1405  5070952 1405  5070962 1405  5070987 1403  5071011 1403  
330027 5071030 1403  5071054 1403  5071073 1403  5071097 1403  5071121 1403  5071135 1403  
330028 5071159 1403  5071173 1403  5071188 1403  5071212 1403  5071231 1403  5071245 1403  
330029 5071259 1403  5071264 1403  5071274 1403  5071278 1403  5071288 1403  5071298 1403  
330030 5071298 1403  5071298 1403  5071298 1403  5071288 1403  5071288 1403  5071278 1403  
330031 5071274 1403  5071259 1403  5071245 1403  5071236 1403  5071212 1403  5071197 1403  
330032 5071173 1403  5071154 1403  5071135 1403  5071111 1403  5071078 1403  5071059 1403  
330033 5071030 1403  5071006 1403  5070973 1403  5070954 1403  5070920 1403  5070896 1403  
330034 5070868 1403  5070834 1403  5070810 1403  5070782 1403  5070763 1403  5070734 1403  
330035 5070710 1403  5070686 1403  5070672 1403  5070662 1403  5070637 1405  5070629 1403  
330036 5070610 1403  5070596 1403  5070586 1403  5070580 1405  5070581 1403  5070581 1403  
330037 5070572 1403  5070581 1403  5070581 1403  5070585 1405  5070605 1403  5070610 1403  
330038 5070627 1405  5070643 1403  5070661 1405  5070672 1403  5070686 1403  5070710 1403  
330039 5070734 1403  5070763 1403  5070782 1403  5070806 1403  5070834 1403  5070858 1403  
330040 5070882 1403  5070906 1403  5070934 1403  5070959 1403  5070987 1403  5071011 1403  
330041 5071035 1403  5071059 1403  5071078 1403  5071097 1403  5071121 1403  5071135 1403  
330042 5071154 1403  5071161 1401  5071175 1402  5071180 1402  5071189 1402  5071199 1402  
330043 5071200 1400  5071199 1402  5071199 1402  5071191 1400  5071191 1400  5071180 1402  
330044 5071180 1402  5071165 1402  5071162 1400  5071148 1400  5071134 1400  5071114 1400  
330045 5071100 1400  5071076 1400  5071063 1398  5071039 1398  5071014 1400  5071000 1400  
330046 5070968 1398  5070957 1400  5070935 1398  5070914 1400  5070890 1400  5070869 1402  
330047 5070857 1400  5070837 1400  5070823 1400  5070807 1402  5070788 1402  5070775 1400  
330048 5070769 1402  5070766 1400  5070755 1402  5070755 1402  5070756 1400  5070755 1402  
330049 5070755 1402  5070755 1402  5070766 1400  5070770 1400  5070775 1400  5070790 1400  
330050 5070812 1396  5070825 1398  5070839 1398  5070856 1400  5070877 1398  5070903 1396  
330051 5070915 1398  5070950 1396  5070968 1398  5070993 1396  5071019 1394  5071041 1396  
330052 5071071 1394  5071095 1394  5071119 1394  5071153 1394  5071171 1394  5071197 1392  
330053 5071219 1394  5071245 1392  5071267 1394  5071281 1394  5071307 1392  5071312 1392  
330054 5071332 1390  5071345 1392  5071355 1392  5071363 1394  5071363 1394  5071367 1394  
330055 5071369 1392  5071364 1392  5071363 1394  5071353 1394  5071343 1394  5071331 1392  
330056 5071310 1394  5071296 1394  5071272 1394  5071262 1394  5071229 1394  5071205 1394  
330057 5071181 1394  5071152 1394  5071129 1394  5071087 1392  5071062 1394  5071028 1394  
330058 5070996 1392  5070968 1392  5070938 1394  5070896 1392  5070867 1392  5070837 1394  
330059 5070796 1392  5070776 1392  5070743 1392  5070713 1394  5070689 1394  5070668 1396  
330060 5070646 1394  5070616 1396  5070592 1396  5070579 1394  5070568 1396  5070560 1394  
330061 5070551 1394  5070548 1392  5070536 1394  5070536 1394  5070538 1392  5070538 1392  
330062 5070546 1394  5070551 1394  5070570 1394  5070579 1394  5070594 1394  5070613 1394  
330063 5070638 1392  5070653 1392  5070676 1392  5070703 1394  5070727 1394  5070751 1394  
330064 5070780 1394  5070815 1392  5070842 1394  5070875 1394  5070896 1392  5070937 1394  
330065 5070961 1394  5070985 1394  5071019 1394  5071052 1394  5071071 1394  5071094 1396  
330066 5071129 1394  5071151 1396  5071167 1394  5071184 1396  5071205 1394  5071210 1394  
330067 5071229 1394  5071238 1394  5071243 1394  5071252 1394  5071253 1394  5071253 1394  
330068 5071251 1396  5071251 1396  5071243 1394  5071238 1394  5071227 1396  5071208 1396  
330069 5071194 1396  5071170 1396  5071162 1394  5071141 1396  5071117 1396  5071094 1396  
330070 5071063 1398  5071041 1396  5071017 1396  5070982 1398  5070958 1398  5070934 1398  
330071 5070910 1398  5070878 1396  5070860 1396  5070836 1396  5070810 1398  5070788 1396  
330072 5070767 1398  5070750 1396  5070734 1398  5070715 1398  5070700 1398  5070691 1398  
330073 5070678 1396  5070678 1396  5070673 1396  5070673 1396  5070672 1398  5070673 1396  
330074 5070679 1394  5070688 1396  5070702 1396  5070713 1394  5070726 1396  5070751 1394  
330075 5070769 1396  5070789 1394  5070813 1394  5070837 1394  5070866 1394  5070890 1394  
330076 5070920 1392  5070953 1392  5070980 1394  5071004 1394  5071039 1392  5071071 1394  
330077 5071105 1394  5071138 1394  5071168 1392  5071195 1394  5071230 1392  5071252 1394  
330078 5071273 1392  5071296 1394  5071319 1394  5071334 1394  5071363 1394  5071372 1394  
330079 5071386 1394  5071396 1394  5071405 1394  5071405 1394  5071409 1396  5071405 1394  
330080 5071404 1396  5071396 1394  5071386 1394  5071371 1396  5071363 1394  5071342 1396  
330081 5071318 1396  5071305 1394  5071272 1394  5071253 1394  5071218 1396  5071184 1396  
330082 5071160 1396  5071117 1396  5071084 1396  5071050 1396  5071015 1398  5070979 1396  
330083 5070939 1398  5070912 1396  5070874 1396  5070836 1396  5070802 1396  5070769 1396  
330084 5070735 1396  5070702 1396  5070673 1396  5070645 1396  5070616 1396  5070602 1396  
330085 5070578 1396  5070568 1396  5070551 1394  5070535 1396  5070525 1396  5070517 1394  
330086 5070513 1394  5070513 1394  5070517 1394  5070517 1394  5070536 1394  5070536 1394  
330087 5070551 1394  5070570 1394  5070589 1394  5070603 1394  5070627 1394  5070651 1394  
330088 5070679 1394  5070713 1394  5070740 1396  5070775 1394  5070804 1394  5070837 1394  
330089 5070867 1392  5070893 1396  5070937 1394  5070966 1394  5070995 1394  5071039 1392  
330090 5071067 1394  5071095 1394  5071129 1394  5071161 1396  5071181 1394  5071205 1394  
330091 5071227 1396  5071253 1394  5071266 1396  5071280 1396  5071294 1396  5071305 1394  
330092 5071310 1394  5071318 1396  5071318 1396  5071318 1396  5071318 1396  5071308 1396  
330093 5071305 1394  5071294 1396  5071280 1396  5071266 1396  5071242 1396  5071227 1396  
330094 5071205 1394  5071179 1396  5071160 1396  5071127 1396  5071103 1396  5071068 1398  
330095 5071041 1396  5071011 1398  5070977 1398  5070949 1398  5070915 1398  5070888 1396  
330096 5070863 1398  5070834 1398  5070812 1396  5070777 1398  5070759 1396  5070735 1396  
330097 5070716 1396  5070691 1398  5070678 1396  5070668 1396  5070659 1396  5070648 1398  
330098 5070643 1398  5070635 1396  5070635 1396  5070645 1396  5070646 1394  5070650 1396  
330099 5070668 1396  5070678 1396  5070692 1396  5070718 1394  5070740 1396  5070759 1396  
330100 5070788 1396  5070812 1396  5070840 1396  5070874 1396  5070904 1394  5070942 1394  
330101 5070979 1396  5071012 1396  5071050 1396  5071079 1396  5071117 1396  5071151 1396  
330102 5071184 1396  5071218 1396  5071251 1396  5071280 1396  5071308 1396  5071342 1396  
330103 5071366 1396  5071385 1396  5071410 1394  5071434 1394  5071452 1396  5071461 1396  
330104 5071471 1396  5071480 1396  5071480 1396  5071480 1396  5071471 1396  5071471 1396  
330105 5071457 1396  5071452 1396  5071431 1398  5071418 1396  5071394 1396  5071371 1396  
330106 5071351 1396  5071316 1398  5071285 1396  5071259 1398  5071226 1398  5071183 1398  
330107 5071149 1398  5071111 1398  5071068 1398  5071036 1396  5070992 1398  5070949 1398  
330108 5070912 1396  5070878 1396  5070840 1396  5070810 1398  5070772 1398  5070740 1396  
330109 5070711 1396  5070676 1398  5070648 1398  5070626 1396  5070611 1396  5070587 1396  
330110 5070573 1396  5070567 1398  5070559 1396  5070549 1396  5070544 1396  5070544 1396  
330111 5070549 1396  5070551 1394  5070557 1398  5070573 1396  5070587 1396  5070602 1396  
330112 5070626 1396  5070651 1394  5070672 1398  5070692 1396  5070726 1396  5070758 1398  
330113 5070788 1396  5070817 1396  5070860 1396  5070888 1396  5070927 1396  5070960 1396  
330114 5070993 1396  5071036 1396  5071063 1398  5071094 1396  5071137 1396  5071165 1396  
330115 5071193 1398  5071228 1396  5071251 1396  5071270 1396  5071304 1396  5071318 1396  
330116 5071334 1394  5071351 1396  5071366 1396  5071371 1396  5071380 1396  5071383 1398  
330117 5071383 1398  5071385 1396  5071380 1396  5071369 1398  5071360 1398  5071351 1396  
330118 5071332 1396  5071304 1396  5071278 1398  5071259 1398  5071237 1396  5071202 1398  
330119 5071179 1396  5071151 1396  5071117 1396  5071079 1396  5071050 1396  5071012 1396  
330120 5070979 1396  5070941 1396  5070912 1396  5070877 1398  5070840 1396  5070802 1396  
330121 5070774 1396  5070740 1396  5070716 1396  5070688 1396  5070670 1394  5070646 1394  
330122 5070624 1398  5070611 1396  5070592 1396  5070587 1396  5070576 1398  5070578 1396  
330123 5070573 1396  5070578 1396  5070578 1396  5070587 1396  5070592 1396  5070611 1396  
330124 5070626 1396  5070650 1396  5070673 1396  5070688 1396  5070716 1396  5070750 1396  
330125 5070778 1396  5070812 1396  5070839 1398  5070879 1396  5070915 1398  5070950 1396  
330126 5070984 1396  5071027 1396  5071065 1396  5071103 1396  5071141 1396  5071179 1396  
330127 5071216 1398  5071250 1398  5071278 1398  5071308 1396  5071340 1398  5071366 1396  
330128 5071383 1398  5071409 1396  5071428 1396  5071433 1396  5071452 1396  5071455 1398  
330129 5071461 1396  5071460 1398  5071461 1396  5071455 1398  5071450 1398  5071442 1396  
330130 5071427 1398  5071407 1398  5071383 1398  5071364 1398  5071340 1398  5071307 1398  
330131 5071283 1398  5071259 1398  5071216 1398  5071184 1396  5071149 1398  5071111 1398  
330132 5071070 1396  5071035 1398  5070993 1396  5070960 1396  5070915 1398  5070877 1398  
330133 5070840 1396  5070810 1398  5070772 1398  5070737 1400  5070710 1398  5070676 1398  
330134 5070658 1398  5070634 1398  5070615 1398  5070600 1398  5070584 1400  5070571 1398  
330135 5070567 1398  5070557 1398  5070559 1396  5070559 1396  5070567 1398  5070568 1396  
330136 5070578 1396  5070588 1396  5070602 1396  5070616 1396  5070645 1396  5070675 1394  
330137 5070692 1396  5070718 1394  5070751 1394  5070780 1394  5070813 1394  5070850 1396  
330138 5070880 1394  5070917 1396  5070952 1394  5070985 1394  5071019 1394  5071062 1394  
330139 5071086 1394  5071129 1394  5071161 1396  5071196 1394  5071227 1396  5071251 1396  
330140 5071280 1396  5071304 1396  5071328 1396  5071353 1394  5071366 1396  5071380 1396  
330141 5071385 1396  5071396 1394  5071406 1394  5071404 1396  5071404 1396  5071404 1396  
330142 5071396 1394  5071386 1394  5071380 1396  5071364 1398  5071343 1394  5071328 1396  
330143 5071304 1396  5071270 1396  5071251 1396  5071218 1396  5071179 1396  5071151 1396  
330144 5071117 1396  5071086 1394  5071050 1396  5071012 1396  5070979 1396  5070941 1396  
330145 5070902 1396  5070864 1396  5070826 1396  5070793 1396  5070759 1396  5070726 1396  
330146 5070692 1396  5070673 1396  5070646 1394  5070616 1396  5070602 1396  5070578 1396  
330147 5070568 1396  5070560 1394  5070546 1394  5070546 1394  5070536 1394  5070536 1394  
330148 5070536 1394  5070544 1396  5070551 1394  5070570 1394  5070578 1396  5070594 1394  
330149 5070616 1396  5070646 1394  5070668 1396  5070692 1396  5070727 1394  5070761 1394  
330150 5070793 1396  5070826 1396  5070866 1394  5070902 1396  5070942 1394  5070971 1394  
330151 5071019 1394  5071052 1394  5071086 1394  5071137 1396  5071165 1396  5071205 1394  
330152 5071238 1394  5071266 1396  5071285 1396  5071319 1394  5071342 1396  5071367 1394  
330153 5071386 1394  5071406 1394  5071410 1394  5071428 1396  5071433 1396  5071433 1396  
330154 5071434 1394  5071433 1396  5071429 1394  5071420 1394  5071406 1394  5071396 1394  
330155 5071380 1396  5071361 1396  5071332 1396  5071304 1396  5071280 1396  5071251 1396  
330156 5071219 1394  5071186 1394  5071151 1396  5071117 1396  5071079 1396  5071052 1394  
330157 5071014 1394  5070969 1396  5070942 1394  5070902 1396  5070874 1396  5070837 1394  
330158 5070802 1396  5070774 1396  5070740 1396  5070718 1394  5070693 1396  5070675 1394  
330159 5070659 1396  5070646 1394  5070627 1394  5070618 1394  5070613 1394  5070602 1396  
330160 5070602 1396  5070602 1396  5070611 1396  5070616 1396  5070626 1396  5070645 1396  
330161 5070659 1396  5070673 1396  5070693 1396  5070713 1394  5070740 1396  5070769 1396  
330162 5070794 1394  5070826 1396  5070852 1394  5070880 1394  5070914 1394  5070952 1394  
330163 5070979 1396  5071014 1394  5071052 1394  5071079 1396  5071117 1396  5071153 1394  
330164 5071181 1394  5071208 1396  5071243 1394  5071272 1394  5071293 1398  5071318 1396  
330165 5071343 1394  5071361 1396  5071371 1396  5071386 1394  5071396 1394  5071404 1396  
330166 5071409 1396  5071410 1394  5071409 1396  5071406 1394  5071395 1396  5071385 1396  
330167 5071371 1396  5071361 1396  5071340 1398  5071318 1396  5071293 1398  5071272 1394  
330168 5071242 1396  5071218 1396  5071184 1396  5071151 1396  5071116 1398  5071078 1398  
330169 5071041 1396  5071012 1396  5070969 1396  5070936 1396  5070895 1394  5070864 1396  
330170 5070826 1396  5070788 1396  5070759 1396  5070726 1396  5070691 1398  5070668 1396  
330171 5070635 1396  5070611 1396  5070587 1396  5070568 1396  5070549 1396  5070544 1396  
330172 5070525 1396  5070514 1398  5070511 1396  5070509 1398  5070509 1398  5070509 1398  
330173 5070509 1398  5070524 1398  5070533 1398  5070548 1398  5070568 1396  5070587 1396  
330174 5070611 1396  5070634 1398  5070657 1398  5070688 1396  5070715 1398  5070748 1398  
330175 5070778 1396  5070812 1396  5070849 1398  5070888 1396  5070917 1396  5070958 1398  
330176 5070993 1396  5071027 1396  5071063 1398  5071094 1396  5071126 1398  5071159 1398  
330177 5071183 1398  5071208 1396  5071240 1398  5071264 1398  5071278 1398  5071302 1398  
330178 5071307 1398  5071326 1398  5071329 1400  5071340 1398  5071340 1398  5071340 1398  
330179 5071340 1398  5071331 1398  5071326 1398  5071307 1398  5071302 1398  5071283 1398  
330180 5071264 1398  5071250 1398  5071226 1398  5071192 1398  5071168 1398  5071140 1398  
330181 5071117 1396  5071084 1396  5071059 1398  5071027 1396  5070993 1396  5070960 1396  
330182 5070927 1396  5070892 1398  5070864 1396  5070840 1396  5070812 1396  5070786 1398  
330183 5070769 1396  5070740 1396  5070716 1396  5070700 1398  5070686 1398  5070673 1396  
330184 5070658 1398  5070648 1398  5070643 1398  5070634 1398  5070633 1398  5070634 1398  
330185 5070644 1396  5070645 1396  5070657 1398  5070668 1396  5070676 1398  5070692 1396  
330186 5070711 1396  5070726 1396  5070750 1396  5070774 1396  5070791 1398  5070825 1398  
330187 5070850 1396  5070878 1396  5070910 1398  5070936 1396  5070963 1398  5071003 1396  
330188 5071036 1396  5071063 1398  5071092 1398  5071126 1398  5071159 1398  5071178 1398  
330189 5071207 1398  5071240 1398  5071266 1396  5071283 1398  5071304 1396  5071328 1396  
330190 5071342 1396  5071353 1394  5071361 1396  5071367 1394  5071372 1394  5071372 1394  
330191 5071372 1394  5071367 1394  5071367 1394  5071363 1394  5071343 1394  5071334 1394  
330192 5071319 1394  5071294 1396  5071280 1396  5071262 1394  5071237 1396  5071205 1394  
330193 5071179 1396  5071153 1394  5071119 1394  5071081 1394  5071050 1396  5071019 1394  
330194 5070980 1394  5070952 1394  5070912 1396  5070880 1394  5070842 1394  5070813 1394  
330195 5070780 1394  5070751 1394  5070718 1394  5070689 1394  5070660 1394  5070636 1394  
330196 5070614 1392  5070594 1394  5070576 1392  5070570 1394  5070552 1392  5070538 1392  
330197 5070527 1394  5070519 1392  5070519 1392  5070519 1392  5070519 1392  5070528 1392  
330198 5070538 1392  5070552 1392  5070562 1392  5070576 1392  5070595 1392  5070619 1392  
330199 5070638 1392  5070670 1394  5070692 1390  5070716 1390  5070743 1392  5070777 1392  
330200 5070796 1392  5070829 1392  5070867 1392  5070896 1392  5070930 1392  5070961 1394  
330201 5070987 1392  5071020 1392  5071044 1392  5071071 1394  5071106 1392  5071130 1392  
330202 5071154 1392  5071173 1392  5071188 1392  5071210 1394  5071230 1392  5071240 1392  
330203 5071254 1392  5071264 1392  5071269 1392  5071269 1392  5071269 1392  5071269 1392  
330204 5071267 1394  5071264 1392  5071254 1392  5071245 1392  5071230 1392  5071210 1394  
330205 5071196 1394  5071183 1392  5071164 1392  5071140 1392  5071119 1394  5071087 1392  
330206 5071066 1394  5071042 1394  5071019 1394  5070995 1394  5070968 1392  5070944 1392  
330207 5070920 1392  5070896 1392  5070877 1392  5070853 1392  5070828 1394  5070815 1392  
330208 5070794 1394  5070782 1392  5070772 1392  5070751 1394  5070742 1394  5070737 1394  
330209 5070727 1394  5070727 1394  5070718 1394  5070718 1394  5070716 1396  5070727 1394  
330210 5070735 1396  5070740 1396  5070751 1394  5070759 1396  5070775 1394  5070793 1396  
330211 5070813 1394  5070828 1394  5070842 1394  5070866 1394  5070890 1394  5070914 1394  
330212 5070938 1394  5070961 1394  5070986 1394  5071014 1394  5071038 1394  5071066 1394  
330213 5071086 1394  5071114 1394  5071143 1394  5071167 1394  5071194 1396  5071210 1394  
330214 5071238 1394  5071262 1394  5071272 1394  5071286 1394  5071305 1394  5071308 1396  
330215 5071319 1394  5071328 1396  5071334 1394  5071335 1392  5071343 1394  5071343 1394  
330216 5071334 1394  5071329 1394  5071329 1394  5071311 1392  5071296 1394  5071281 1394  
330217 5071269 1392  5071245 1392  5071229 1394  5071207 1392  5071181 1394  5071162 1394  
330218 5071138 1394  5071105 1394  5071071 1394  5071043 1394  5071015 1392  5070980 1394  
330219 5070952 1394  5070919 1394  5070888 1396  5070861 1394  5070828 1394  5070804 1394  
330220 5070775 1394  5070742 1394  5070718 1394  5070694 1394  5070675 1394  5070661 1394  
330221 5070637 1394  5070618 1394  5070603 1394  5070589 1394  5070575 1394  5070570 1394  
330222 5070560 1394  5070560 1394  5070549 1396  5070560 1394  5070560 1394  5070570 1394  
330223 5070574 1394  5070580 1394  5070594 1394  5070603 1394  5070616 1396  5070636 1394  
330224 5070651 1394  5070673 1396  5070692 1396  5070713 1394  5070737 1394  5070761 1394  
330225 5070788 1396  5070812 1396  5070836 1396  5070864 1396  5070888 1396  5070919 1394  
330226 5070941 1396  5070969 1396  5070995 1394  5071017 1396  5071041 1396  5071067 1394  
330227 5071079 1396  5071094 1396  5071117 1396  5071127 1396  5071141 1396  5071161 1396  
330228 5071165 1396  5071170 1396  5071170 1396  5071179 1396  5071179 1396  5071179 1396  
330229 5071168 1398  5071168 1398  5071165 1396  5071161 1396  5071151 1396  5071137 1396  
330230 5071127 1396  5071103 1396  5071095 1394  5071070 1396  5071059 1398  5071041 1396  
330231 5071027 1396  5071004 1394  5070984 1396  5070969 1396  5070950 1396  5070936 1396  
330232 5070912 1396  5070893 1396  5070878 1396  5070864 1396  5070840 1396  5070836 1396  
330233 5070817 1396  5070812 1396  5070793 1396  5070788 1396  5070778 1396  5070772 1398  
330234 5070774 1396  5070770 1394  5070769 1396  5070770 1394  5070770 1394  5070775 1394  
330235 5070780 1394  5070780 1394  5070796 1392  5070807 1390  5070815 1392  5070831 1390  
330236 5070845 1390  5070864 1390  5070878 1390  5070898 1390  5070918 1388  5070931 1390  
330237 5070957 1388  5070976 1388  5070990 1388  5071017 1390  5071042 1388  5071055 1390  
330238 5071076 1388  5071098 1390  5071119 1388  5071143 1388  5071156 1390  5071176 1388  
330239 5071191 1388  5071210 1388  5071214 1388  5071233 1388  5071243 1388  5071256 1390  
330240 5071267 1388  5071270 1390  5071270 1390  5071270 1390  5071272 1388  5071270 1390  
330241 5071272 1388  5071265 1390  5071256 1390  5071246 1390  5071232 1390  5071222 1390  
330242 5071208 1390  5071189 1390  5071175 1390  5071156 1390  5071140 1392  5071116 1392  
330243 5071089 1390  5071065 1390  5071041 1390  5071007 1390  5070984 1390  5070964 1390  
330244 5070931 1390  5070907 1390  5070885 1388  5070855 1390  5070832 1388  5070807 1390  
330245 5070785 1388  5070765 1388  5070741 1388  5070718 1388  5070700 1387  5070679 1388  
330246 5070665 1388  5070651 1388  5070630 1390  5070622 1388  5070606 1390  5070597 1390  
330247 5070597 1390  5070593 1388  5070592 1390  5070592 1390  5070593 1388  5070594 1388  
330248 5070597 1390  5070597 1390  5070616 1390  5070614 1392  5070630 1390  5070641 1388  
330249 5070653 1392  5070673 1390  5070681 1392  5070697 1390  5070715 1392  5070729 1392  
330250 5070753 1392  5070777 1392  5070796 1392  5070815 1392  5070839 1392  5070863 1392  
330251 5070883 1390  5070905 1392  5070920 1392  5070945 1390  5070961 1394  5070972 1392  
330252 5070996 1392  5071015 1392  5071020 1392  5071039 1392  5071054 1392  5071063 1392  
330253 5071069 1390  5071073 1392  5071074 1390  5071084 1390  5071084 1390  5071086 1388  
330254 5071086 1388  5071084 1390  5071085 1388  5071076 1388  5071070 1390  5071071 1388  
330255 5071066 1388  5071049 1387  5071042 1388  5071033 1388  5071019 1388  5071009 1388  
330256 5070999 1388  5070987 1387  5070972 1387  5070958 1387  5070948 1386  5070934 1386  
330257 5070920 1387  5070912 1385  5070897 1385  5070888 1385  5070874 1385  5070869 1385  
330258 5070851 1383  5070845 1385  5070835 1385  5070827 1383  5070827 1383  5070823 1383  
330259 5070813 1383  5070814 1381  5070813 1383  5070813 1383  5070813 1383  5070813 1383  
330260 5070823 1383  5070823 1383  5070826 1385  5070838 1381  5070846 1383  5070861 1383  
330261 5070870 1383  5070885 1383  5070890 1383  5070904 1383  5070923 1383  5070926 1385  
330262 5070952 1383  5070969 1385  5070979 1385  5070993 1385  5071013 1383  5071037 1383  
330263 5071052 1383  5071071 1383  5071080 1383  5071095 1383  5071114 1383  5071138 1383  
330264 5071147 1383  5071162 1383  5071174 1385  5071189 1385  5071194 1385  5071205 1383  
330265 5071214 1383  5071217 1385  5071227 1385  5071229 1383  5071227 1385  5071227 1385  
330266 5071227 1385  5071227 1385  5071219 1383  5071217 1385  5071203 1385  5071194 1385  
330267 5071189 1385  5071173 1386  5071168 1387  5071149 1387  5071135 1386  5071121 1387  
330268 5071092 1386  5071077 1387  5071060 1385  5071036 1385  5071023 1383  5070991 1381  
330269 5070977 1381  5070952 1383  5070929 1381  5070905 1381  5070889 1383  5070872 1381  
330270 5070848 1381  5070824 1381  5070805 1381  5070786 1381  5070770 1383  5070748 1381  
330271 5070727 1383  5070712 1383  5070700 1381  5070689 1383  5070681 1381  5070668 1385  
330272 5070655 1383  5070646 1383  5070636 1383  5070627 1383  5070627 1383  5070622 1383  
330273 5070622 1383  5070622 1383  5070627 1383  5070625 1385  5070636 1383  5070636 1383  
330274 5070646 1383  5070660 1383  5070668 1385  5070683 1385  5070687 1385  5070703 1383  
330275 5070721 1385  5070736 1383  5070751 1383  5070779 1383  5070789 1383  5070803 1383  
330276 5070827 1383  5070845 1385  5070859 1385  5070875 1383  5070898 1385  5070912 1385  
330277 5070936 1385  5070950 1385  5070969 1385  5070974 1385  5070988 1385  5071001 1386  
330278 5071010 1386  5071022 1385  5071036 1385  5071044 1386  5071049 1387  5071060 1385  
330279 5071058 1386  5071068 1386  5071068 1387  5071068 1386  5071068 1386  5071068 1387  
330280 5071068 1387  5071057 1388  5071049 1386  5071049 1386  5071045 1385  5071034 1386  
330281 5071022 1385  5071012 1385  5071002 1385  5070988 1385  5070978 1385  5070975 1383  
330282 5070961 1383  5070952 1383  5070937 1383  5070928 1383  5070913 1383  5070905 1381  
330283 5070900 1381  5070891 1381  5070876 1381  5070872 1381  5070862 1381  5070853 1381  
330284 5070853 1381  5070848 1381  5070848 1381  5070838 1381  5070838 1381  5070838 1381  
330285 5070838 1381  5070838 1381  5070848 1381  5070848 1381  5070853 1381  5070862 1381  
330286 5070872 1381  5070876 1381  5070886 1381  5070900 1381  5070905 1381  5070924 1381  
330287 5070929 1381  5070948 1381  5070963 1381  5070977 1381  5070991 1381  5071005 1381  
330288 5071015 1381  5071030 1381  5071047 1383  5071061 1383  5071082 1381  5071092 1381  
330289 5071106 1381  5071125 1381  5071139 1381  5071149 1381  5071163 1381  5071173 1381  
330290 5071177 1381  5071182 1381  5071192 1381  5071197 1381  5071205 1383  5071206 1381  
330291 5071206 1381  5071216 1381  5071216 1381  5071206 1381  5071206 1381  5071206 1381  
330292 5071197 1381  5071192 1381  5071184 1379  5071177 1381  5071165 1379  5071155 1379  
330293 5071139 1381  5071126 1379  5071107 1379  5071093 1379  5071074 1379  5071055 1379  
330294 5071029 1381  5071015 1381  5070993 1379  5070974 1379  5070955 1379  5070931 1379  
330295 5070907 1379  5070893 1379  5070872 1381  5070848 1381  5070824 1381  5070806 1379  
330296 5070786 1381  5070771 1381  5070749 1379  5070728 1381  5070714 1381  5070700 1381  
330297 5070686 1381  5070681 1381  5070662 1381  5070658 1379  5070647 1381  5070638 1381  
330298 5070638 1381  5070638 1381  5070628 1381  5070638 1381  5070638 1381  5070638 1381  
330299 5070647 1381  5070657 1381  5070662 1381  5070671 1381  5070681 1381  5070690 1381  
330300 5070700 1381  5070714 1381  5070729 1381  5070753 1381  5070771 1381  5070786 1381  
330301 5070800 1381  5070824 1381  5070838 1381  5070853 1381  5070876 1381  5070891 1381  
330302 5070915 1381  5070929 1381  5070948 1381  5070963 1381  5070981 1381  5070996 1381  
330303 5071015 1381  5071029 1381  5071039 1381  5071053 1381  5071063 1381  5071072 1381  
330304 5071082 1381  5071082 1381  5071092 1381  5071092 1381  5071096 1381  5071098 1379  
330305 5071098 1379  5071096 1381  5071093 1379  5071093 1379  5071083 1379  5071079 1379  
330306 5071074 1379  5071063 1381  5071053 1381  5071048 1381  5071031 1379  5071025 1381  
330307 5071005 1381  5070998 1379  5070983 1379  5070978 1379  5070962 1381  5070948 1381  
330308 5070939 1381  5070929 1381  5070915 1381  5070905 1381  5070891 1381  5070886 1381  
330309 5070876 1381  5070872 1381  5070862 1381  5070853 1381  5070853 1381  5070848 1381  
330310 5070838 1381  5070838 1381  5070838 1381  5070838 1381  5070838 1381  5070848 1381  
330311 5070848 1381  5070853 1381  5070861 1383  5070870 1383  5070876 1381  5070889 1383  
330312 5070899 1383  5070913 1383  5070928 1383  5070946 1383  5070952 1383  5070971 1383  
330313 5070980 1383  5070994 1383  5071013 1383  5071028 1383  5071047 1383  5071072 1381  
330314 5071080 1383  5071095 1383  5071115 1381  5071138 1383  5071149 1381  5071162 1383  
330315 5071173 1381  5071181 1383  5071192 1381  5071197 1381  5071204 1383  5071214 1383  
330316 5071221 1381  5071221 1381  5071229 1383  5071230 1381  5071228 1383  5071229 1383  
330317 5071229 1383  5071221 1381  5071214 1383  5071197 1381  5071190 1383  5071182 1381  
330318 5071173 1381  5071154 1381  5071139 1381  5071115 1381  5071096 1381  5071082 1381  
330319 5071063 1381  5071039 1381  5071015 1381  5070991 1381  5070977 1381  5070953 1381  
330320 5070929 1381  5070905 1381  5070886 1381  5070862 1381  5070838 1381  5070814 1381  
330321 5070800 1381  5070779 1383  5070751 1383  5070729 1381  5070712 1383  5070690 1381  
330322 5070681 1381  5070660 1383  5070647 1381  5070636 1383  5070627 1383  5070623 1381  
330323 5070613 1383  5070614 1381  5070603 1383  5070603 1383  5070603 1383  5070601 1385  
330324 5070611 1385  5070622 1383  5070627 1383  5070635 1385  5070646 1383  5070654 1385  
330325 5070670 1383  5070686 1381  5070698 1383  5070714 1381  5070738 1381  5070751 1383  
330326 5070779 1383  5070799 1383  5070823 1383  5070838 1381  5070862 1381  5070886 1381  
330327 5070900 1381  5070924 1381  5070948 1381  5070963 1381  5070981 1381  5070996 1381  
330328 5071025 1381  5071039 1381  5071053 1381  5071071 1383  5071080 1383  5071092 1381  
330329 5071096 1381  5071104 1383  5071114 1383  5071125 1381  5071125 1381  5071123 1383  
330330 5071125 1381  5071125 1381  5071125 1381  5071115 1381  5071106 1381  5071096 1381  
330331 5071092 1381  5071082 1381  5071072 1381  5071053 1381  5071048 1381  5071029 1381  
330332 5071015 1381  5071005 1381  5070991 1381  5070977 1381  5070963 1381  5070947 1383  
330333 5070928 1383  5070913 1383  5070899 1383  5070885 1383  5070875 1383  5070861 1383  
330334 5070851 1383  5070837 1383  5070827 1383  5070822 1383  5070813 1383  5070802 1385  
330335 5070803 1383  5070803 1383  5070799 1383  5070797 1385  5070802 1385  5070803 1383  
330336 5070813 1383  5070823 1383  5070826 1385  5070835 1385  5070851 1383  5070859 1385  
330337 5070873 1385  5070888 1385  5070902 1385  5070923 1383  5070935 1385  5070950 1385  
330338 5070969 1385  5070988 1385  5071013 1383  5071028 1383  5071052 1383  5071069 1385  
330339 5071089 1385  5071103 1385  5071127 1385  5071146 1385  5071160 1385  5071174 1385  
330340 5071191 1383  5071203 1385  5071219 1383  5071238 1383  5071247 1383  5071251 1385  
330341 5071261 1385  5071271 1383  5071270 1385  5071270 1385  5071275 1385  5071270 1385  
330342 5071275 1385  5071270 1385  5071260 1385  5071251 1385  5071246 1385  5071237 1385  
330343 5071217 1385  5071204 1383  5071189 1385  5071171 1383  5071152 1383  5071127 1385  
330344 5071104 1383  5071076 1383  5071052 1383  5071028 1383  5070994 1383  5070975 1383  
330345 5070952 1383  5070923 1383  5070899 1383  5070875 1383  5070851 1383  5070821 1385  
330346 5070799 1383  5070778 1385  5070749 1385  5070725 1385  5070701 1385  5070689 1383  
330347 5070678 1385  5070659 1385  5070644 1385  5070625 1385  5070620 1385  5070611 1385  
330348 5070601 1385  5070603 1383  5070597 1385  5070598 1383  5070598 1383  5070601 1385  
330349 5070611 1385  5070619 1386  5070625 1385  5070644 1385  5070659 1385  5070678 1385  
330350 5070687 1385  5070701 1385  5070725 1385  5070749 1385  5070778 1385  5070797 1385  
330351 5070821 1385  5070846 1383  5070870 1383  5070888 1385  5070912 1385  5070945 1385  
330352 5070971 1383  5070988 1385  5071013 1383  5071028 1383  5071052 1383  5071076 1383  
330353 5071090 1383  5071112 1385  5071128 1383  5071138 1383  5071152 1383  5071162 1383  
330354 5071170 1385  5071171 1383  5071176 1383  5071176 1383  5071176 1383  5071171 1383  
330355 5071171 1383  5071162 1383  5071152 1383  5071149 1381  5071138 1383  5071125 1381  
330356 5071114 1383  5071095 1383  5071080 1383  5071063 1381  5071047 1383  5071028 1383  
330357 5071015 1381  5070990 1383  5070975 1383  5070953 1381  5070937 1383  5070913 1383  
330358 5070899 1383  5070875 1383  5070861 1383  5070846 1383  5070827 1383  5070811 1385  
330359 5070797 1385  5070789 1383  5070778 1385  5070768 1385  5070759 1385  5070749 1385  
330360 5070750 1385  5070751 1383  5070750 1385  5070749 1385  5070759 1385  5070759 1385  
330361 5070768 1385  5070778 1385  5070783 1385  5070797 1385  5070811 1385  5070826 1385  
330362 5070846 1383  5070859 1385  5070873 1385  5070897 1385  5070912 1385  5070936 1385  
330363 5070960 1385  5070974 1385  5070993 1385  5071026 1385  5071052 1383  5071076 1383  
330364 5071093 1385  5071122 1385  5071146 1385  5071162 1383  5071181 1383  5071194 1385  
330365 5071214 1383  5071235 1386  5071246 1385  5071261 1385  5071275 1385  5071279 1385  
330366 5071289 1385  5071294 1385  5071303 1385  5071302 1386  5071294 1385  5071294 1385  
330367 5071294 1385  5071289 1385  5071279 1385  5071270 1385  5071251 1385  5071246 1385  
330368 5071217 1385  5071203 1385  5071181 1383  5071162 1383  5071136 1385  5071112 1385  
330369 5071080 1383  5071060 1385  5071028 1383  5070993 1385  5070970 1383  5070947 1383  
330370 5070911 1385  5070889 1383  5070859 1385  5070826 1385  5070797 1385  5070779 1383  
330371 5070751 1383  5070725 1385  5070701 1385  5070683 1385  5070668 1385  5070654 1385  
330372 5070635 1385  5070621 1385  5070611 1385  5070597 1385  5070587 1385  5070587 1385  
330373 5070587 1385  5070587 1385  5070589 1383  5070596 1385  5070603 1383  5070611 1385  
330374 5070622 1383  5070635 1385  5070654 1385  5070668 1385  5070687 1385  5070711 1385  
330375 5070726 1385  5070759 1385  5070783 1385  5070802 1385  5070826 1385  5070859 1385  
330376 5070883 1385  5070912 1385  5070947 1383  5070969 1385  5070988 1385  5071023 1383  
330377 5071047 1383  5071074 1385  5071088 1385  5071112 1385  5071136 1385  5071150 1385  
330378 5071174 1385  5071189 1385  5071203 1385  5071212 1385  5071217 1385  5071216 1386  
330379 5071227 1385  5071225 1386  5071227 1385  5071217 1385  5071217 1385  5071212 1385  
330380 5071203 1385  5071193 1385  5071181 1383  5071171 1383  5071150 1385  5071138 1383  
330381 5071114 1383  5071095 1383  5071079 1385  5071061 1383  5071037 1383  5071012 1385  
330382 5070988 1385  5070969 1385  5070945 1385  5070921 1385  5070897 1385  5070873 1385  
330383 5070848 1386  5070834 1386  5070821 1385  5070797 1385  5070781 1386  5070767 1386  
330384 5070748 1386  5070743 1386  5070733 1386  5070733 1386  5070724 1386  5070718 1388  
330385 5070719 1386  5070719 1386  5070724 1386  5070724 1386  5070733 1386  5070748 1387  
330386 5070757 1387  5070776 1387  5070786 1387  5070800 1386  5070820 1387  5070843 1387  
330387 5070858 1387  5070881 1387  5070902 1385  5070926 1385  5070960 1385  5070978 1385  
330388 5071002 1385  5071026 1385  5071061 1383  5071080 1383  5071114 1383  5071136 1385  
330389 5071162 1383  5071179 1385  5071205 1383  5071228 1383  5071252 1383  5071271 1383  
330390 5071279 1385  5071294 1385  5071314 1383  5071329 1383  5071337 1385  5071341 1385  
330391 5071341 1385  5071351 1385  5071352 1383  5071351 1385  5071341 1385  5071337 1385  
330392 5071327 1385  5071313 1385  5071303 1385  5071281 1383  5071271 1383  5071252 1383  
330393 5071227 1385  5071203 1385  5071174 1385  5071152 1383  5071124 1383  5071090 1383  
330394 5071061 1383  5071037 1383  5071004 1383  5070974 1385  5070945 1385  5070913 1383  
330395 5070885 1383  5070861 1383  5070827 1383  5070803 1383  5070779 1383  5070749 1385  
330396 5070725 1385  5070701 1385  5070683 1385  5070668 1385  5070654 1385  5070635 1385  
330397 5070624 1386  5070620 1385  5070611 1385  5070611 1385  5070611 1385  5070611 1385  
330398 5070611 1385  5070620 1385  5070625 1385  5070633 1387  5070654 1385  5070668 1385  
330399 5070683 1385  5070697 1385  5070721 1385  5070743 1386  5070770 1383  5070788 1385  
330400 5070813 1383  5070845 1385  5070873 1385  5070897 1385  5070928 1383  5070950 1385  
330401 5070980 1383  5071013 1383  5071047 1383  5071069 1385  5071095 1383  5071123 1383  
330402 5071147 1383  5071171 1383  5071181 1383  5071203 1385  5071217 1385  5071237 1385  
330403 5071251 1385  5071260 1385  5071270 1385  5071275 1385  5071275 1385  5071275 1385  
330404 5071270 1385  5071270 1385  5071260 1385  5071252 1383  5071236 1385  5071227 1385  
330405 5071203 1385  5071189 1385  5071174 1385  5071150 1385  5071127 1385  5071104 1383  
330406 5071079 1385  5071049 1386  5071026 1385  5071002 1385  5070972 1387  5070950 1385  
330407 5070920 1386  5070896 1386  5070872 1386  5070848 1386  5070826 1385  5070800 1387  
330408 5070783 1385  5070758 1387  5070744 1385  5070724 1387  5070709 1386  5070700 1386  
330409 5070695 1386  5070684 1388  5070681 1386  5070676 1387  5070676 1386  5070676 1386  
330410 5070681 1386  5070679 1388  5070686 1386  5070695 1386  5070702 1385  5070719 1386  
330411 5070743 1386  5070759 1385  5070781 1386  5070797 1385  5070820 1386  5070845 1385  
330412 5070873 1385  5070897 1385  5070921 1385  5070950 1385  5070979 1385  5071001 1386  
330413 5071036 1385  5071060 1385  5071089 1385  5071122 1385  5071144 1386  5071170 1385  
330414 5071189 1385  5071217 1385  5071246 1385  5071259 1386  5071279 1385  5071292 1386  
330415 5071313 1385  5071327 1385  5071337 1385  5071341 1385  5071349 1386  5071349 1386  
330416 5071349 1386  5071350 1387  5071340 1386  5071335 1386  5071316 1386  5071311 1386  
330417 5071294 1385  5071275 1385  5071260 1385  5071236 1385  5071213 1385  5071191 1383  
330418 5071170 1385  5071136 1385  5071093 1385  5071076 1383  5071045 1385  5071012 1385  
330419 5070980 1383  5070952 1383  5070921 1385  5070889 1383  5070858 1386  5070835 1385  
330420 5070802 1385  5070778 1385  5070744 1385  5070722 1383  5070697 1385  5070678 1385  
330421 5070659 1385  5070644 1385  5070624 1386  5070620 1385  5070609 1386  5070601 1385  
330422 5070601 1385  5070601 1385  5070600 1387  5070609 1387  5070609 1386  5070619 1387  
330423 5070633 1386  5070652 1386  5070659 1385  5070683 1385  5070695 1387  5070721 1385  
330424 5070744 1385  5070768 1385  5070788 1385  5070821 1385  5070845 1385  5070875 1383  
330425 5070902 1385  5070936 1385  5070971 1383  5070993 1385  5071026 1385  5071050 1385  
330426 5071080 1383  5071112 1385  5071138 1383  5071171 1383  5071191 1383  5071214 1383  
330427 5071227 1385  5071252 1383  5071262 1383  5071275 1385  5071289 1385  5071294 1385  
330428 5071294 1385  5071303 1385  5071303 1385  5071305 1383  5071294 1385  5071291 1383  
330429 5071279 1385  5071271 1383  5071251 1385  5071237 1385  5071217 1385  5071194 1385  
330430 5071179 1385  5071150 1385  5071127 1385  5071103 1385  5071074 1385  5071045 1385  
330431 5071023 1383  5070988 1385  5070969 1385  5070936 1385  5070902 1385  5070885 1383  
330432 5070850 1385  5070826 1385  5070803 1383  5070783 1385  5070769 1385  5070744 1385  
330433 5070721 1385  5070711 1385  5070697 1385  5070683 1385  5070678 1385  5070668 1385  
330434 5070659 1385  5070652 1386  5070654 1385  5070654 1385  5070659 1385  5070668 1385  
330435 5070678 1385  5070687 1385  5070697 1385  5070711 1385  5070725 1385  5070750 1385  
330436 5070778 1385  5070799 1383  5070823 1383  5070845 1385  5070875 1383  5070899 1383  
330437 5070921 1385  5070952 1383  5070979 1385  5071014 1383  5071037 1383  5071069 1385  
330438 5071095 1383  5071122 1385  5071152 1383  5071179 1385  5071203 1385  5071227 1385  
330439 5071252 1383  5071275 1385  5071289 1385  5071313 1385  5071319 1383  5071337 1385  
330440 5071342 1385  5071342 1385  5071353 1383  5071361 1385  5071353 1383  5071351 1385  
330441 5071342 1385  5071337 1385  5071318 1385  5071313 1385  5071289 1385  5071275 1385  
330442 5071259 1387  5071236 1385  5071213 1385  5071190 1383  5071162 1383  5071138 1383  
330443 5071103 1385  5071076 1383  5071045 1385  5071012 1385  5070979 1385  5070950 1385  
330444 5070921 1385  5070888 1385  5070859 1385  5070826 1385  5070802 1385  5070778 1385  
330445 5070750 1385  5070725 1385  5070711 1385  5070687 1385  5070678 1385  5070657 1386  
330446 5070654 1385  5070644 1385  5070633 1387  5070635 1385  5070625 1385  5070624 1386  
330447 5070633 1386  5070643 1387  5070652 1387  5070657 1386  5070681 1386  5070687 1385  
330448 5070709 1386  5070724 1386  5070746 1388  5070776 1386  5070797 1385  5070820 1386  
330449 5070843 1387  5070867 1386  5070896 1387  5070925 1386  5070950 1385  5070988 1385  
330450 5071012 1385  5071045 1385  5071074 1385  5071093 1385  5071127 1385  5071149 1387  
330451 5071174 1385  5071194 1385  5071217 1385  5071246 1385  5071260 1385  5071275 1385  
330452 5071288 1387  5071294 1385  5071303 1385  5071311 1386  5071316 1386  5071316 1386  
330453 5071311 1387  5071303 1385  5071302 1386  5071287 1386  5071278 1386  5071268 1387  
330454 5071244 1386  5071227 1385  5071201 1386  5071179 1385  5071159 1386  5071127 1385  
330455 5071103 1385  5071074 1385  5071044 1386  5071022 1385  5070988 1385  5070960 1385  
330456 5070920 1386  5070898 1385  5070869 1385  5070835 1385  5070811 1385  5070783 1385  
330457 5070750 1385  5070735 1385  5070711 1385  5070687 1385  5070678 1385  5070659 1385  
330458 5070643 1386  5070625 1385  5070620 1385  5070611 1385  5070611 1385  5070601 1385  
330459 5070611 1385  5070611 1385  5070622 1383  5070625 1385  5070646 1383  5070654 1385  
330460 5070668 1385  5070684 1383  5070701 1385  5070722 1383  5070744 1385  5070768 1385  
330461 5070797 1385  5070821 1385  5070845 1385  5070870 1383  5070899 1383  5070926 1385  
330462 5070961 1383  5070988 1385  5071013 1383  5071047 1383  5071076 1383  5071104 1383  
330463 5071127 1385  5071162 1383  5071179 1385  5071205 1383  5071217 1385  5071246 1385  
330464 5071262 1383  5071275 1385  5071289 1385  5071295 1383  5071305 1383  5071314 1383  
330465 5071313 1385  5071313 1385  5071314 1383  5071303 1385  5071294 1385  5071289 1385  
330466 5071279 1385  5071271 1383  5071247 1383  5071217 1385  5071205 1383  5071179 1385  
330467 5071162 1383  5071138 1383  5071114 1383  5071080 1383  5071061 1383  5071028 1383  
330468 5070994 1383  5070971 1383  5070937 1383  5070902 1385  5070875 1383  5070851 1383  
330469 5070824 1381  5070799 1383  5070779 1383  5070751 1383  5070727 1383  5070703 1383  
330470 5070687 1385  5070678 1385  5070659 1385  5070654 1385  5070644 1385  5070636 1383  
330471 5070625 1385  5070627 1383  5070627 1383  5070636 1383  5070635 1385  5070644 1385  
330472 5070659 1385  5070679 1383  5070689 1383  5070712 1383  5070725 1385  5070746 1383  
330473 5070768 1385  5070799 1383  5070823 1383  5070846 1383  5070869 1385  5070899 1383  
330474 5070921 1385  5070950 1385  5070978 1385  5071012 1385  5071037 1383  5071071 1383  
330475 5071089 1385  5071123 1383  5071146 1385  5071170 1385  5071190 1383  5071213 1385  
330476 5071237 1385  5071246 1385  5071261 1385  5071273 1387  5071289 1385  5071289 1385  
330477 5071292 1387  5071294 1385  5071292 1387  5071288 1386  5071289 1385  5071278 1386  
330478 5071270 1385  5071259 1386  5071244 1386  5071226 1387  5071201 1386  5071179 1385  
330479 5071160 1385  5071135 1386  5071111 1386  5071079 1385  5071060 1385  5071026 1385  
330480 5070993 1385  5070971 1383  5070936 1385  5070902 1385  5070875 1383  5070851 1383  
330481 5070823 1383  5070789 1383  5070768 1385  5070746 1383  5070722 1383  5070698 1383  
330482 5070679 1383  5070660 1383  5070644 1385  5070627 1383  5070622 1383  5070613 1383  
330483 5070601 1385  5070598 1383  5070601 1385  5070596 1385  5070601 1385  5070601 1385  
330484 5070611 1385  5070625 1385  5070635 1385  5070659 1385  5070676 1386  5070683 1385  
330485 5070702 1385  5070726 1385  5070750 1385  5070778 1385  5070788 1385  5070821 1385  
330486 5070845 1385  5070873 1385  5070902 1385  5070926 1385  5070960 1385  5070988 1385  
330487 5071022 1385  5071050 1385  5071076 1383  5071093 1385  5071127 1385  5071150 1385  
330488 5071176 1383  5071189 1385  5071212 1385  5071236 1385  5071251 1385  5071260 1385  
330489 5071273 1386  5071278 1386  5071289 1385  5071289 1385  5071289 1385  5071288 1387  
330490 5071288 1387  5071279 1385  5071275 1385  5071268 1387  5071251 1385  5071235 1386  
330491 5071217 1385  5071203 1385  5071179 1385  5071160 1385  5071136 1385  5071114 1383  
330492 5071089 1385  5071069 1385  5071037 1383  5071013 1383  5070988 1385  5070961 1383  
330493 5070926 1385  5070904 1383  5070883 1385  5070859 1385  5070835 1385  5070811 1385  
330494 5070788 1385  5070778 1385  5070749 1385  5070744 1385  5070727 1383  5070711 1385  
330495 5070701 1385  5070697 1385  5070687 1385  5070686 1386  5070687 1385  5070687 1385  
330496 5070697 1385  5070697 1385  5070701 1385  5070721 1385  5070735 1385  5070749 1385  
330497 5070768 1385  5070783 1385  5070802 1385  5070821 1385  5070845 1385  5070869 1385  
330498 5070888 1385  5070921 1385  5070943 1386  5070969 1385  5070988 1385  5071022 1385  
330499 5071045 1385  5071069 1385  5071095 1383  5071123 1383  5071150 1385  5071168 1387  
330500 5071190 1383  5071211 1387  5071236 1385  5071251 1385  5071271 1383  5071279 1385  
330501 5071289 1385  5071294 1385  5071294 1385  5071303 1385  5071303 1385  5071303 1385  
330502 5071294 1385  5071292 1386  5071288 1387  5071275 1385  5071270 1385  5071249 1386  
330503 5071235 1386  5071212 1385  5071192 1386  5071168 1386  5071144 1386  5071122 1385  
330504 5071093 1385  5071069 1385  5071038 1383  5071013 1383  5070979 1385  5070961 1383  
330505 5070926 1385  5070899 1383  5070870 1383  5070845 1385  5070813 1383  5070789 1383  
330506 5070768 1385  5070735 1385  5070713 1383  5070697 1385  5070678 1385  5070659 1385  
330507 5070643 1387  5070633 1387  5070625 1385  5070611 1385  5070611 1385  5070600 1387  
330508 5070601 1385  5070600 1387  5070600 1387  5070609 1386  5070619 1387  5070625 1385  
330509 5070633 1386  5070654 1385  5070668 1385  5070683 1385  5070698 1383  5070721 1385  
330510 5070744 1385  5070769 1385  5070788 1385  5070811 1385  5070835 1385  5070869 1385  
330511 5070889 1383  5070923 1383  5070947 1383  5070975 1383  5070993 1385  5071023 1383  
330512 5071045 1385  5071074 1385  5071093 1385  5071112 1385  5071138 1383  5071150 1385  
330513 5071171 1383  5071179 1385  5071194 1385  5071201 1386  5071212 1385  5071219 1383  
330514 5071227 1385  5071227 1385  5071227 1385  5071227 1385  5071217 1385  5071214 1383  
330515 5071203 1385  5071194 1385  5071181 1383  5071170 1385  5071152 1383  5071138 1383  
330516 5071114 1383  5071095 1383  5071076 1383  5071052 1383  5071028 1383  5071004 1383  
330517 5070980 1383  5070963 1381  5070928 1383  5070905 1381  5070886 1381  5070861 1383  
330518 5070837 1383  5070823 1383  5070799 1383  5070779 1383  5070760 1383  5070746 1383  
330519 5070729 1381  5070713 1383  5070700 1381  5070698 1383  5070687 1385  5070689 1383  
330520 5070684 1383  5070684 1383  5070683 1385  5070689 1383  5070697 1385  5070701 1385  
330521 5070711 1385  5070721 1385  5070736 1383  5070751 1383  5070768 1385  5070784 1383  
330522 5070802 1385  5070827 1383  5070845 1385  5070869 1385  5070888 1385  5070911 1385  
330523 5070936 1385  5070960 1385  5070988 1385  5071012 1385  5071036 1385  5071060 1385  
330524 5071079 1385  5071095 1383  5071122 1385  5071146 1385  5071171 1383  5071181 1383  
330525 5071194 1385  5071203 1385  5071217 1385  5071229 1383  5071237 1385  5071238 1383  
330526 5071246 1385  5071246 1385  5071235 1387  5071236 1385  5071237 1385  5071217 1385  
330527 5071213 1385  5071194 1385  5071189 1385  5071174 1385  5071159 1386  5071136 1385  
330528 5071112 1385  5071089 1385  5071069 1385  5071045 1385  5071022 1385  5070988 1385  
330529 5070969 1385  5070945 1385  5070921 1385  5070888 1385  5070858 1386  5070835 1385  
330530 5070813 1383  5070783 1385  5070759 1385  5070725 1385  5070713 1383  5070689 1383  
330531 5070668 1385  5070654 1385  5070635 1385  5070621 1385  5070609 1387  5070601 1385  
330532 5070597 1385  5070587 1385  5070582 1385  5070582 1385  5070582 1385  5070582 1385  
330533 5070586 1387  5070587 1385  5070601 1385  5070611 1385  5070625 1385  5070644 1385  
330534 5070657 1386  5070676 1386  5070686 1386  5070711 1385  5070733 1386  5070759 1385  
330535 5070783 1385  5070802 1385  5070826 1385  5070850 1385  5070873 1385  5070897 1385  
330536 5070921 1385  5070945 1385  5070969 1385  5070987 1386  5071012 1385  5071026 1385  
330537 5071050 1385  5071071 1383  5071089 1385  5071103 1385  5071111 1386  5071127 1385  
330538 5071135 1386  5071146 1385  5071150 1385  5071160 1385  5071159 1386  5071159 1386  
330539 5071159 1386  5071160 1385  5071150 1385  5071150 1385  5071146 1385  5071127 1385  
330540 5071123 1383  5071103 1385  5071095 1383  5071074 1385  5071061 1383  5071047 1383  
330541 5071028 1383  5071013 1383  5070990 1383  5070975 1383  5070961 1383  5070936 1385  
330542 5070913 1383  5070899 1383  5070885 1383  5070861 1383  5070846 1383  5070827 1383  
330543 5070813 1383  5070799 1383  5070784 1383  5070779 1383  5070770 1383  5070760 1383  
330544 5070749 1385  5070751 1383  5070744 1385  5070746 1383  5070746 1383  5070746 1383  
330545 5070749 1385  5070751 1383  5070759 1385  5070768 1385  5070786 1381  5070787 1385  
330546 5070803 1383  5070821 1385  5070835 1385  5070859 1385  5070875 1383  5070888 1385  
330547 5070912 1385  5070936 1385  5070950 1385  5070972 1386  5070993 1385  5071022 1385  
330548 5071045 1385  5071060 1385  5071079 1385  5071101 1386  5071122 1385  5071135 1386  
330549 5071160 1385  5071173 1386  5071187 1386  5071203 1385  5071212 1385  5071225 1386  
330550 5071235 1386  5071244 1386  5071244 1386  5071251 1385  5071244 1386  5071246 1385  
330551 5071244 1386  5071235 1386  5071227 1385  5071217 1385  5071211 1386  5071194 1385  
330552 5071179 1385  5071170 1385  5071150 1385  5071135 1386  5071121 1387  5071092 1386  
330553 5071074 1385  5071050 1385  5071025 1386  5071012 1385  5070978 1385  5070960 1385  
330554 5070936 1385  5070912 1385  5070888 1385  5070870 1383  5070845 1385  5070821 1385  
330555 5070797 1385  5070778 1385  5070760 1383  5070736 1383  5070722 1383  5070703 1383  
330556 5070690 1381  5070684 1383  5070670 1383  5070662 1381  5070662 1381  5070657 1381  
330557 5070647 1381  5070648 1381  5070647 1381  5070655 1383  5070657 1381  5070662 1381  
330558 5070671 1381  5070686 1381  5070690 1381  5070700 1381  5070714 1381  5070729 1381  
330559 5070748 1381  5070760 1383  5070786 1381  5070800 1381  5070824 1381  5070838 1381  
330560 5070853 1381  5070876 1381  5070900 1381  5070913 1383  5070939 1381  5070952 1383  
330561 5070975 1383  5070990 1383  5071015 1381  5071028 1383  5071047 1383  5071061 1383  
330562 5071077 1381  5071082 1381  5071096 1381  5071106 1381  5071115 1381  5071123 1383  
330563 5071130 1381  5071138 1383  5071138 1383  5071139 1381  5071139 1381  5071139 1381  
330564 5071130 1381  5071125 1381  5071115 1381  5071106 1381  5071096 1381  5071092 1381  
330565 5071077 1381  5071072 1381  5071053 1381  5071039 1381  5071025 1381  5071015 1381  
330566 5070991 1381  5070977 1381  5070963 1381  5070948 1381  5070924 1381  5070905 1381  
330567 5070891 1381  5070876 1381  5070862 1381  5070853 1381  5070838 1381  5070829 1381  
330568 5070824 1381  5070805 1381  5070805 1381  5070800 1381  5070791 1381  5070791 1381  
330569 5070791 1381  5070791 1381  5070791 1381  5070791 1381  5070791 1381  5070800 1381  
330570 5070805 1381  5070814 1381  5070824 1381  5070838 1381  5070848 1381  5070862 1381  
330571 5070876 1381  5070891 1381  5070915 1381  5070929 1381  5070948 1381  5070963 1381  
330572 5070977 1381  5070991 1381  5071015 1381  5071029 1381  5071048 1381  5071063 1381  
330573 5071082 1381  5071092 1381  5071106 1381  5071125 1381  5071139 1381  5071149 1381  
330574 5071163 1381  5071173 1381  5071177 1381  5071182 1381  5071192 1381  5071192 1381  
330575 5071198 1379  5071197 1381  5071197 1381  5071198 1379  5071192 1381  5071192 1381  
330576 5071184 1379  5071177 1381  5071174 1379  5071163 1381  5071149 1381  5071139 1381  
330577 5071126 1379  5071106 1381  5071082 1381  5071072 1381  5071048 1381  5071029 1381  
330578 5071015 1381  5070991 1381  5070972 1381  5070948 1381  5070924 1381  5070900 1381  
330579 5070886 1381  5070862 1381  5070838 1381  5070824 1381  5070800 1381  5070786 1381  
330580 5070771 1381  5070748 1381  5070729 1381  5070716 1379  5070706 1379  5070690 1381  
330581 5070687 1379  5070681 1381  5070671 1381  5070662 1381  5070662 1381  5070662 1381  
330582 5070662 1381  5070662 1381  5070662 1381  5070671 1381  5070681 1381  5070686 1381  
330583 5070690 1381  5070700 1381  5070714 1381  5070724 1381  5070738 1381  5070752 1381  
330584 5070762 1381  5070781 1381  5070791 1381  5070806 1379  5070824 1381  5070840 1379  
330585 5070862 1381  5070876 1381  5070893 1379  5070905 1381  5070924 1381  5070950 1379  
330586 5070963 1381  5070972 1381  5070981 1381  5070996 1381  5071005 1381  5071015 1381  
330587 5071029 1381  5071039 1381  5071048 1381  5071053 1381  5071053 1381  5071063 1381  
330588 5071063 1381  5071063 1381  5071063 1381  5071063 1381  5071063 1381  5071053 1381  
330589 5071048 1381  5071039 1381  5071040 1379  5071031 1379  5071025 1381  5071015 1381  
330590 5070998 1379  5070991 1381  5070978 1379  5070972 1381  5070963 1381  5070950 1379  
330591 5070940 1379  5070926 1379  5070916 1379  5070905 1381  5070893 1379  5070876 1381  
330592 5070873 1379  5070864 1379  5070853 1381  5070850 1379  5070840 1379  5070830 1379  
330593 5070829 1381  5070824 1381  5070826 1379  5070824 1381  5070824 1381  5070824 1381  
330594 5070825 1379  5070824 1381  5070829 1381  5070829 1381  5070838 1381  5070848 1381  
330595 5070853 1381  5070862 1381  5070876 1381  5070886 1381  5070891 1381  5070905 1381  
330596 5070915 1381  5070929 1381  5070948 1381  5070953 1381  5070972 1381  5070977 1381  
330597 5070996 1381  5071015 1381  5071025 1381  5071040 1379  5071053 1381  5071063 1381  
330598 5071077 1381  5071092 1381  5071096 1381  5071115 1381  5071125 1381  5071130 1381  
330599 5071139 1381  5071149 1381  5071154 1381  5071163 1381  5071163 1381  5071163 1381  
330600 5071173 1381  5071163 1381  5071163 1381  5071163 1381  5071163 1381  5071154 1381  
330601 5071149 1381  5071139 1381  5071130 1381  5071115 1381  5071106 1381  5071092 1381  
330602 5071077 1381  5071063 1381  5071048 1381  5071029 1381  5071015 1381  5070991 1381  
330603 5070977 1381  5070963 1381  5070938 1381  5070924 1381  5070905 1381  5070891 1381  
330604 5070873 1379  5070854 1379  5070838 1381  5070816 1379  5070802 1379  5070786 1381  
330605 5070771 1381  5070763 1379  5070749 1379  5070738 1381  5070724 1381  5070724 1381  
330606 5070714 1381  5070705 1381  5070701 1379  5070701 1379  5070690 1381  5070692 1379  
330607 5070690 1381  5070690 1381  5070690 1381  5070700 1381  5070700 1381  5070705 1381  
330608 5070714 1381  5070724 1381  5070729 1381  5070738 1381  5070748 1381  5070762 1381  
330609 5070771 1381  5070786 1381  5070791 1381  5070805 1381  5070814 1381  5070829 1381  
330610 5070850 1379  5070862 1381  5070872 1381  5070886 1381  5070900 1381  5070905 1381  
330611 5070924 1381  5070939 1381  5070948 1381  5070953 1381  5070963 1381  5070977 1381  
330612 5070981 1381  5070991 1381  5070996 1381  5071006 1381  5071005 1381  5071005 1381  
330613 5071015 1381  5071015 1381  5071015 1381  5071015 1381  5071015 1381  5071015 1381  
330614 5071015 1381  5071005 1381  5071005 1381  5070996 1381  5070991 1381  5070991 1381  
330615 5070983 1379  5070977 1381  5070972 1381  5070963 1381  5070955 1379  5070950 1379  
330616 5070939 1381  5070929 1381  5070914 1381  5070905 1381  5070905 1381  5070891 1381  
330617 5070891 1381  5070886 1381  5070876 1381  5070872 1381  5070862 1381  5070862 1381  
330618 5070861 1383  5070853 1381  5070851 1383  5070851 1383  5070846 1383  5070845 1385  
330619 5070846 1383  5070845 1385  5070850 1385  5070851 1383  5070861 1383  5070870 1383  
330620 5070873 1385  5070873 1385  5070883 1385  5070888 1385  5070904 1383  5070912 1385  
330621 5070921 1385  5070926 1385  5070945 1385  5070952 1383  5070970 1383  5070974 1385  
330622 5070990 1383  5070994 1383  5071013 1383  5071022 1385  5071036 1385  5071045 1385  
330623 5071061 1383  5071071 1383  5071077 1381  5071079 1385  5071095 1383  5071095 1383  
330624 5071104 1383  5071114 1383  5071114 1383  5071125 1381  5071125 1381  5071130 1381  
330625 5071130 1381  5071123 1383  5071125 1381  5071114 1383  5071114 1383  5071104 1383  
330626 5071096 1381  5071090 1383  5071082 1381  5071077 1381  5071061 1383  5071052 1383  
330627 5071037 1383  5071028 1383  5071015 1381  5070996 1381  5070991 1381  5070975 1383  
330628 5070963 1381  5070947 1383  5070928 1383  5070912 1385  5070899 1383  5070883 1385  
330629 5070869 1385  5070850 1385  5070835 1385  5070821 1385  5070803 1383  5070788 1385  
330630 5070783 1385  5070778 1385  5070759 1385  5070749 1385  5070735 1385  5070725 1385  
330631 5070721 1385  5070711 1385  5070701 1385  5070701 1385  5070697 1385  5070697 1385  
330632 5070695 1386  5070697 1385  5070695 1386  5070695 1386  5070697 1385  5070701 1385  
330633 5070700 1386  5070709 1386  5070709 1386  5070719 1386  5070724 1386  5070743 1386  
330634 5070746 1388  5070757 1386  5070767 1386  5070781 1386  5070786 1386  5070799 1388  
330635 5070820 1386  5070824 1387  5070843 1387  5070858 1386  5070872 1386  5070881 1386  
330636 5070896 1387  5070901 1386  5070920 1386  5070925 1386  5070934 1386  5070943 1386  
330637 5070948 1387  5070958 1386  5070968 1387  5070974 1385  5070972 1386  5070977 1387  
330638 5070987 1387  5070988 1385  5070988 1385  5070991 1386  5070993 1385  5070991 1387  
330639 5070991 1386  5070993 1385  5070992 1387  5070993 1385  5070988 1385  5070979 1385  
330640 5070978 1385  5070974 1385  5070974 1385  5070971 1383  5070961 1383  5070960 1385  
330641 5070952 1383  5070947 1383  5070936 1385  5070928 1383  5070928 1383  5070923 1383  
330642 5070913 1383  5070904 1383  5070905 1381  5070897 1385  5070890 1383  5070885 1383  
330643 5070885 1383  5070885 1383  5070875 1383  5070875 1383  5070875 1383  5070869 1385  
330644 5070870 1383  5070870 1383  5070870 1383  5070870 1383  5070870 1383  5070875 1383  
330645 5070875 1383  5070885 1383  5070889 1383  5070899 1383  5070904 1383  5070904 1383  
330646 5070912 1385  5070923 1383  5070937 1383  5070945 1385  5070950 1385  5070971 1383  
330647 5070974 1385  5070988 1385  5070993 1385  5071004 1383  5071022 1385  5071027 1385  
330648 5071036 1385  5071050 1385  5071060 1385  5071068 1387  5071079 1385  5071089 1385  
330649 5071093 1385  5071101 1386  5071111 1386  5071112 1385  5071122 1385  5071127 1385  
330650 5071127 1385  5071127 1385  5071127 1385  5071127 1385  5071127 1385  5071127 1385  
330651 5071127 1385  5071122 1385  5071112 1385  5071103 1385  5071093 1385  5071089 1385  
330652 5071080 1383  5071071 1383  5071061 1383  5071050 1385  5071037 1383  5071023 1383  
330653 5071013 1383  5070990 1383  5070980 1383  5070971 1383  5070952 1383  5070937 1383  
330654 5070923 1383  5070904 1383  5070890 1383  5070873 1385  5070861 1383  5070846 1383  
330655 5070827 1383  5070811 1385  5070802 1385  5070789 1383  5070784 1383  5070768 1385  
330656 5070749 1385  5070746 1383  5070735 1385  5070725 1385  5070725 1385  5070721 1385  
330657 5070721 1385  5070711 1385  5070709 1386  5070709 1386  5070711 1385  5070709 1387  
330658 5070719 1386  5070721 1385  5070724 1386  5070733 1386  5070743 1386  5070748 1386  
330659 5070756 1388  5070767 1387  5070776 1386  5070781 1386  5070796 1386  5070810 1387  
330660 5070821 1385  5070834 1387  5070850 1385  5070867 1386  5070872 1387  5070885 1388  
330661 5070901 1387  5070912 1385  5070925 1387  5070943 1386  5070948 1387  5070968 1387  
330662 5070972 1386  5070987 1386  5070991 1386  5071010 1386  5071020 1386  5071025 1386  
330663 5071034 1386  5071044 1387  5071049 1387  5071049 1386  5071058 1386  5071058 1386  
330664 5071060 1385  5071060 1385  5071058 1387  5071058 1387  5071060 1385  5071060 1385  
330665 5071049 1387  5071050 1385  5071044 1387  5071045 1385  5071034 1386  5071025 1387  
330666 5071025 1386  5071020 1386  5071012 1385  5071001 1386  5070991 1386  5070987 1387  
330667 5070972 1386  5070968 1387  5070958 1386  5070948 1386  5070943 1386  5070934 1386  
330668 5070925 1387  5070920 1387  5070910 1386  5070910 1386  5070901 1387  5070901 1386  
330669 5070894 1388  5070894 1388  5070885 1388  5070885 1388  5070885 1388  5070883 1390  
330670 5070885 1388  5070894 1388  5070893 1390  5070899 1388  5070909 1388  5070917 1390  
330671 5070922 1390  5070931 1390  5070945 1390  5070956 1388  5070964 1390  5070969 1390  
330672 5070984 1390  5070989 1390  5071007 1390  5071022 1390  5071033 1388  5071046 1390  
330673 5071065 1390  5071070 1390  5071084 1390  5071089 1390  5071109 1388  5071124 1388  
330674 5071132 1390  5071141 1390  5071156 1390  5071165 1390  5071165 1390  5071170 1390  
330675 5071175 1390  5071184 1390  5071184 1390  5071186 1388  5071184 1390  5071186 1388  
330676 5071184 1390  5071176 1388  5071176 1388  5071171 1388  5071165 1390  5071157 1388  
330677 5071147 1388  5071132 1390  5071119 1388  5071108 1390  5071090 1388  5071074 1390  
330678 5071066 1388  5071047 1388  5071033 1388  5071019 1388  5070990 1388  5070976 1388  
330679 5070966 1388  5070942 1388  5070922 1390  5070909 1388  5070885 1388  5070864 1390  
330680 5070848 1387  5070832 1388  5070818 1388  5070799 1388  5070783 1390  5070780 1388  
330681 5070765 1388  5070746 1388  5070741 1388  5070723 1388  5070716 1390  5070708 1388  
330682 5070698 1388  5070692 1390  5070694 1388  5070692 1390  5070692 1390  5070694 1388  
330683 5070694 1388  5070692 1390  5070699 1388  5070708 1388  5070708 1388  5070718 1388  
330684 5070732 1388  5070741 1388  5070746 1388  5070765 1388  5070781 1386  5070785 1388  
330685 5070799 1388  5070823 1388  5070832 1388  5070856 1388  5070870 1388  5070885 1388  
330686 5070899 1388  5070922 1390  5070942 1388  5070956 1388  5070969 1390  5070985 1388  
330687 5070999 1388  5071019 1388  5071033 1388  5071041 1390  5071057 1388  5071065 1390  
330688 5071076 1388  5071084 1390  5071092 1386  5071109 1388  5071109 1388  5071109 1388  
330689 5071119 1388  5071119 1388  5071119 1388  5071121 1387  5071111 1387  5071109 1388  
330690 5071101 1387  5071093 1385  5071089 1385  5071074 1385  5071069 1385  5071061 1383  
330691 5071045 1385  5071037 1383  5071028 1383  5071013 1383  5070996 1381  5070981 1381  
330692 5070972 1381  5070963 1381  5070948 1381  5070929 1381  5070924 1381  5070905 1381  
330693 5070891 1381  5070886 1381  5070877 1381  5070862 1381  5070853 1381  5070848 1381  
330694 5070838 1381  5070829 1381  5070829 1381  5070824 1381  5070824 1381  5070824 1381  
330695 5070824 1381  5070829 1381  5070829 1381  5070838 1381  5070850 1379  5070854 1379  
330696 5070862 1381  5070876 1381  5070886 1381  5070901 1381  5070905 1381  5070924 1381  
330697 5070939 1381  5070953 1381  5070972 1381  5070981 1381  5070996 1381  5071015 1381  
330698 5071030 1381  5071053 1381  5071072 1381  5071082 1381  5071096 1381  5071115 1381  
330699 5071130 1381  5071147 1383  5071163 1381  5071173 1381  5071181 1383  5071192 1381  
330700 5071197 1381  5071206 1381  5071214 1383  5071216 1381  5071221 1381  5071221 1381  
330701 5071219 1383  5071214 1383  5071205 1383  5071205 1383  5071195 1383  5071181 1383  
330702 5071176 1383  5071162 1383  5071147 1383  5071139 1381  5071115 1381  5071096 1381  
330703 5071077 1381  5071063 1381  5071039 1381  5071015 1381  5070991 1381  5070972 1381  
330704 5070948 1381  5070924 1381  5070900 1381  5070877 1381  5070853 1381  5070829 1381  
330705 5070806 1379  5070786 1381  5070773 1379  5070748 1381  5070730 1379  5070705 1381  
330706 5070690 1381  5070681 1381  5070662 1381  5070657 1381  5070638 1381  5070628 1381  
330707 5070624 1381  5070623 1381  5070614 1381  5070614 1381  5070614 1381  5070623 1381  
330708 5070623 1381  5070628 1381  5070638 1381  5070647 1381  5070657 1381  5070671 1381  
330709 5070686 1381  5070700 1381  5070714 1381  5070729 1381  5070753 1381  5070771 1381  
330710 5070791 1381  5070805 1381  5070829 1381  5070853 1381  5070877 1381  5070901 1381  
330711 5070925 1381  5070948 1381  5070963 1381  5070982 1381  5071006 1381  5071025 1381  
330712 5071039 1381  5071063 1381  5071076 1383  5071092 1381  5071096 1381  5071115 1381  
330713 5071125 1381  5071130 1381  5071139 1381  5071149 1381  5071154 1381  5071154 1381  
330714 5071154 1381  5071154 1381  5071154 1381  5071149 1381  5071139 1381  5071131 1379  
330715 5071125 1381  5071115 1381  5071096 1381  5071082 1381  5071072 1381  5071053 1381  
330716 5071039 1381  5071025 1381  5071006 1381  5070981 1381  5070972 1381  5070948 1381  
330717 5070929 1381  5070905 1381  5070891 1381  5070872 1381  5070853 1381  5070838 1381  
330718 5070824 1381  5070805 1381  5070800 1381  5070786 1381  5070781 1381  5070771 1381  
330719 5070762 1381  5070753 1381  5070753 1381  5070748 1381  5070748 1381  5070746 1383  
330720 5070753 1381  5070751 1383  5070770 1383  5070779 1383  5070784 1383  5070799 1383  
330721 5070813 1383  5070827 1383  5070846 1383  5070861 1383  5070885 1383  5070899 1383  
330722 5070923 1383  5070947 1383  5070971 1383  5070990 1383  5071013 1383  5071037 1383  
330723 5071061 1383  5071076 1383  5071095 1383  5071123 1383  5071147 1383  5071171 1383  
330724 5071181 1383  5071206 1381  5071219 1383  5071238 1383  5071252 1383  5071262 1383  
330725 5071276 1383  5071279 1385  5071289 1385  5071291 1383  5071291 1383  5071291 1383  
330726 5071291 1383  5071283 1381  5071278 1381  5071276 1383  5071262 1383  5071247 1383  
330727 5071229 1383  5071219 1383  5071197 1381  5071181 1383  5071163 1381  5071139 1381  
330728 5071115 1381  5071082 1381  5071063 1381  5071028 1383  5071004 1383  5070975 1383  
330729 5070947 1383  5070923 1383  5070889 1383  5070870 1383  5070837 1383  5070813 1383  
330730 5070789 1383  5070770 1383  5070746 1383  5070722 1383  5070697 1385  5070683 1385  
330731 5070660 1383  5070644 1385  5070636 1383  5070620 1385  5070611 1385  5070601 1385  
330732 5070601 1385  5070596 1385  5070595 1386  5070601 1385  5070600 1386  5070609 1386  
330733 5070624 1387  5070633 1386  5070641 1388  5070657 1386  5070681 1386  5070694 1388  
330734 5070709 1386  5070733 1386  5070757 1387  5070781 1386  5070811 1385  5070834 1386  
330735 5070858 1386  5070888 1385  5070921 1385  5070945 1385  5070969 1385  5070991 1387  
330736 5071026 1385  5071050 1385  5071073 1387  5071093 1385  5071122 1385  5071147 1383  
330737 5071169 1385  5071181 1383  5071203 1385  5071214 1383  5071229 1383  5071237 1385  
330738 5071246 1385  5071260 1385  5071261 1385  5071270 1385  5071270 1385  5071260 1385  
330739 5071260 1385  5071251 1385  5071246 1385  5071235 1386  5071217 1385  5071203 1385  
330740 5071189 1385  5071174 1385  5071150 1385  5071127 1385  5071112 1385  5071079 1385  
330741 5071061 1383  5071036 1385  5071012 1385  5070979 1385  5070960 1385  5070936 1385  
330742 5070902 1385  5070890 1383  5070869 1385  5070834 1387  5070821 1385  5070797 1385  
330743 5070781 1387  5070759 1385  5070743 1387  5070735 1385  5070726 1385  5070719 1387  
330744 5070711 1385  5070710 1387  5070700 1387  5070710 1387  5070710 1387  5070709 1386  
330745 5070718 1388  5070732 1388  5070741 1388  5070756 1388  5070775 1388  5070794 1388  
330746 5070808 1388  5070834 1387  5070855 1390  5070880 1388  5070899 1388  5070933 1388  
330747 5070966 1388  5070987 1387  5071019 1388  5071049 1387  5071076 1388  5071109 1388  
330748 5071133 1388  5071167 1388  5071192 1386  5071216 1386  5071243 1388  5071268 1387  
330749 5071286 1388  5071300 1388  5071324 1388  5071338 1388  5071358 1388  5071372 1388  
330750 5071377 1388  5071386 1388  5071391 1388  5071393 1386  5071393 1387  5071391 1388  
330751 5071386 1388  5071377 1388  5071372 1388  5071356 1390  5071339 1388  5071324 1388  
330752 5071300 1388  5071276 1388  5071257 1388  5071233 1388  5071199 1390  5071170 1390  
330753 5071141 1390  5071108 1390  5071076 1388  5071045 1390  5071015 1392  5070974 1390  
330754 5070944 1392  5070917 1390  5070878 1390  5070846 1388  5070817 1390  5070783 1390  
330755 5070764 1390  5070729 1392  5070706 1390  5070691 1392  5070672 1392  5070648 1392  
330756 5070637 1394  5070618 1394  5070603 1394  5070594 1394  5070592 1396  5070587 1396  
330757 5070587 1396  5070587 1396  5070592 1396  5070602 1396  5070611 1396  5070624 1398  
330758 5070645 1396  5070658 1398  5070676 1398  5070691 1398  5070715 1398  5070748 1398  
330759 5070772 1398  5070801 1398  5070834 1398  5070861 1400  5070892 1398  5070925 1398  
330760 5070957 1400  5070981 1400  5071014 1400  5071047 1400  5071078 1398  5071111 1398  
330761 5071140 1398  5071164 1398  5071192 1398  5071218 1396  5071237 1396  5071261 1396  
330762 5071280 1396  5071294 1396  5071310 1394  5071319 1394  5071334 1394  5071334 1394  
330763 5071343 1394  5071343 1394  5071343 1394  5071334 1394  5071329 1394  5071319 1394  
330764 5071304 1396  5071286 1394  5071270 1396  5071251 1396  5071229 1394  5071203 1396  
330765 5071179 1396  5071162 1394  5071127 1396  5071092 1398  5071063 1398  5071035 1398  
330766 5071003 1396  5070968 1398  5070936 1396  5070901 1398  5070872 1398  5070839 1398  
330767 5070815 1398  5070787 1398  5070766 1400  5070739 1398  5070713 1400  5070689 1400  
330768 5070670 1400  5070656 1400  5070642 1400  5070632 1400  5070623 1400  5070613 1400  
330769 5070611 1402  5070608 1400  5070613 1400  5070613 1400  5070623 1400  5070632 1400  
330770 5070647 1400  5070667 1398  5070676 1398  5070700 1398  5070725 1398  5070758 1398  
330771 5070775 1400  5070809 1400  5070839 1398  5070872 1398  5070901 1398  5070936 1396  
330772 5070968 1398  5071001 1398  5071039 1398  5071068 1398  5071113 1396  5071141 1396  
330773 5071178 1398  5071208 1396  5071242 1396  5071270 1396  5071294 1396  5071316 1398  
330774 5071350 1398  5071364 1398  5071382 1400  5071401 1400  5071417 1398  5071425 1400  
330775 5071428 1402  5071431 1398  5071439 1400  5071438 1402  5071430 1400  5071425 1400  
330776 5071415 1400  5071400 1402  5071380 1402  5071360 1403  5071347 1402  5071323 1402  
330777 5071288 1403  5071264 1403  5071236 1403  5071202 1403  5071173 1403  5071135 1403  
330778 5071107 1403  5071064 1403  5071030 1403  5070997 1403  5070959 1403  5070928 1405  
330779 5070887 1403  5070857 1405  5070819 1405  5070787 1403  5070766 1405  5070734 1403  
330780 5070710 1403  5070680 1405  5070662 1403  5070642 1405  5070627 1405  5070608 1405  
330781 5070605 1403  5070594 1405  5070585 1405  5070585 1405  5070585 1405  5070591 1409  
330782 5070591 1409  5070601 1409  5070613 1411  5070634 1409  5070648 1409  5070666 1411  
330783 5070691 1409  5070714 1411  5070747 1411  5070766 1411  5070800 1411  5070827 1413  
330784 5070866 1411  5070898 1413  5070938 1411  5070967 1411  5071000 1411  5071037 1413  
330785 5071070 1413  5071104 1413  5071148 1411  5071171 1413  5071206 1411  5071239 1411  
330786 5071268 1411  5071292 1411  5071315 1411  5071341 1409  5071360 1409  5071374 1409  
330787 5071392 1411  5071398 1409  5071406 1411  5071417 1409  5071417 1409  5071417 1409  
330788 5071416 1411  5071408 1409  5071397 1411  5071384 1409  5071370 1409  5071355 1409  
330789 5071331 1409  5071307 1409  5071274 1409  5071255 1409  5071226 1409  5071183 1409  
330790 5071155 1409  5071120 1405  5071086 1405  5071053 1405  5071011 1403  5070973 1403  
330791 5070944 1403  5070897 1403  5070858 1403  5070830 1403  5070787 1403  5070763 1403  
330792 5070729 1404  5070696 1403  5070672 1403  5070643 1403  5070620 1403  5070605 1403  
330793 5070581 1403  5070572 1404  5070562 1403  5070553 1404  5070543 1403  5070543 1403  
330794 5070543 1403  5070553 1403  5070553 1403  5070567 1404  5070581 1403  5070596 1404  
330795 5070620 1403  5070643 1404  5070667 1403  5070696 1403  5070729 1403  5070753 1403  
330796 5070787 1404  5070820 1403  5070858 1403  5070897 1404  5070935 1404  5070973 1404  
330797 5071011 1404  5071054 1404  5071088 1403  5071131 1403  5071164 1403  5071202 1404  
330798 5071236 1403  5071274 1403  5071303 1404  5071336 1403  5071365 1403  5071389 1404  
330799 5071403 1403  5071427 1404  5071447 1402  5071452 1402  5071465 1404  5071474 1403  
330800 5071474 1403  5071476 1402  5071476 1402  5071468 1400  5071459 1400  5071449 1400  
330801 5071428 1402  5071407 1398  5071382 1400  5071364 1398  5071341 1398  5071309 1396  
330802 5071278 1398  5071240 1398  5071207 1398  5071169 1398  5071140 1398  5071102 1398  
330803 5071059 1398  5071027 1396  5070982 1398  5070951 1396  5070912 1396  5070872 1398  
330804 5070839 1398  5070810 1398  5070774 1396  5070740 1396  5070715 1398  5070688 1396  
330805 5070667 1398  5070650 1396  5070624 1398  5070611 1396  5070600 1398  5070591 1398  
330806 5070588 1396  5070578 1396  5070580 1394  5070589 1394  5070594 1394  5070602 1396  
330807 5070618 1394  5070637 1394  5070650 1396  5070673 1396  5070694 1394  5070717 1396  
330808 5070752 1394  5070780 1394  5070802 1396  5070840 1396  5070874 1396  5070914 1394  
330809 5070951 1396  5070979 1396  5071019 1394  5071051 1396  5071084 1396  5071129 1394  
330810 5071165 1396  5071196 1394  5071229 1394  5071267 1394  5071286 1394  5071323 1390  
330811 5071345 1392  5071369 1392  5071383 1392  5071398 1392  5071412 1392  5071423 1390  
330812 5071433 1390  5071437 1390  5071434 1388  5071434 1388  5071434 1388  5071415 1388  
330813 5071412 1387  5071391 1388  5071372 1388  5071359 1387  5071335 1387  5071302 1387  
330814 5071278 1387  5071251 1385  5071211 1387  5071174 1385  5071146 1385  5071104 1383  
330815 5071071 1383  5071022 1385  5070979 1385  5070947 1383  5070899 1383  5070850 1385  
330816 5070811 1385  5070780 1383  5070735 1385  5070697 1385  5070659 1385  5070627 1383  
330817 5070597 1385  5070559 1385  5070534 1385  5070512 1383  5070487 1385  5070469 1383  
330818 5070453 1385  5070444 1385  5070434 1385  5070434 1385  5070434 1385  5070434 1385  
330819 5070444 1385  5070453 1385  5070457 1387  5070482 1385  5070496 1385  5070519 1387  
330820 5070552 1387  5070576 1387  5070598 1388  5070633 1387  5070665 1388  5070699 1388  
330821 5070741 1388  5070777 1387  5070810 1387  5070848 1387  5070896 1387  5070934 1387  
330822 5070977 1387  5071020 1387  5071068 1387  5071101 1387  5071144 1387  5071179 1385  
330823 5071210 1388  5071246 1385  5071273 1387  5071302 1387  5071326 1387  5071350 1387  
330824 5071374 1387  5071378 1387  5071393 1387  5071404 1385  5071412 1387  5071412 1387  
330825 5071410 1388  5071412 1387  5071402 1387  5071390 1385  5071374 1387  5071358 1388  
330826 5071340 1387  5071316 1387  5071293 1387  5071269 1387  5071235 1387  5071202 1387  
330827 5071173 1387  5071135 1387  5071100 1388  5071068 1387  5071025 1387  5070987 1387  
330828 5070948 1387  5070919 1388  5070881 1387  5070842 1388  5070808 1388  5070780 1388  
330829 5070748 1387  5070719 1387  5070695 1387  5070667 1387  5070641 1388  5070618 1388  
330830 5070600 1387  5070594 1388  5070579 1388  5070576 1387  5070574 1388  5070574 1388  
330831 5070574 1388  5070579 1388  5070584 1388  5070594 1388  5070608 1388  5070621 1390  
330832 5070641 1388  5070664 1390  5070684 1388  5070718 1388  5070742 1388  5070773 1390  
330833 5070797 1390  5070831 1390  5070870 1388  5070907 1390  5070941 1390  5070974 1390  
330834 5071019 1388  5071055 1390  5071089 1390  5071122 1390  5071165 1390  5071199 1390  
330835 5071232 1390  5071265 1390  5071291 1388  5071315 1388  5071347 1390  5071366 1390  
330836 5071385 1390  5071399 1390  5071415 1388  5071423 1390  5071433 1390  5071434 1388  
330837 5071433 1390  5071434 1388  5071425 1388  5071415 1388  5071409 1390  5071391 1388  
330838 5071372 1388  5071347 1390  5071325 1388  5071299 1390  5071270 1390  5071243 1388  
330839 5071208 1390  5071170 1390  5071132 1390  5071089 1390  5071046 1390  5071006 1392  
330840 5070968 1392  5070922 1390  5070882 1392  5070839 1392  5070797 1390  5070763 1392  
330841 5070720 1392  5070681 1392  5070648 1392  5070605 1392  5070578 1390  5070546 1394  
330842 5070514 1392  5070490 1392  5070471 1392  5070451 1394  5070436 1394  5070422 1394  
330843 5070403 1394  5070393 1394  5070393 1394  5070393 1394  5070403 1394  5070403 1394  
330844 5070422 1394  5070436 1394  5070446 1394  5070469 1394  5070487 1396  5070511 1396  
330845 5070546 1394  5070573 1396  5070603 1394  5070647 1394  5070680 1394  5070718 1394  
330846 5070761 1394  5070794 1394  5070842 1394  5070880 1394  5070919 1394  5070966 1394  
330847 5071004 1394  5071043 1394  5071081 1394  5071119 1394  5071161 1396  5071186 1394  
330848 5071220 1394  5071253 1394  5071272 1394  5071296 1394  5071312 1392  5071334 1394  
330849 5071353 1394  5071363 1394  5071368 1394  5071372 1394  5071372 1394  5071374 1392  
330850 5071368 1394  5071363 1394  5071355 1392  5071334 1394  5071319 1394  5071305 1394  
330851 5071281 1394  5071262 1394  5071231 1392  5071205 1394  5071170 1396  5071143 1394  
330852 5071113 1396  5071081 1394  5071052 1394  5071014 1394  5070971 1394  5070941 1396  
330853 5070912 1396  5070879 1396  5070840 1396  5070812 1396  5070778 1396  5070759 1396  
330854 5070726 1396  5070702 1396  5070678 1396  5070669 1396  5070650 1396  5070634 1398  
330855 5070624 1398  5070616 1396  5070611 1396  5070611 1396  5070610 1398  5070616 1396  
330856 5070616 1396  5070634 1398  5070643 1398  5070658 1398  5070676 1398  5070691 1398  
330857 5070724 1398  5070748 1398  5070771 1400  5070801 1398  5070834 1398  5070863 1398  
330858 5070892 1398  5070925 1398  5070958 1398  5070992 1398  5071036 1396  5071065 1396  
330859 5071094 1396  5071135 1398  5071167 1394  5071194 1396  5071229 1394  5071261 1396  
330860 5071286 1394  5071309 1396  5071333 1396  5071361 1396  5071372 1394  5071396 1394  
330861 5071406 1394  5071418 1396  5071428 1396  5071428 1396  5071433 1396  5071428 1396  
330862 5071428 1396  5071409 1396  5071403 1398  5071385 1396  5071369 1398  5071351 1396  
330863 5071328 1396  5071302 1398  5071269 1398  5071242 1396  5071208 1396  5071178 1398  
330864 5071141 1396  5071103 1396  5071065 1396  5071027 1396  5070984 1396  5070950 1396  
330865 5070904 1394  5070864 1396  5070826 1396  5070788 1396  5070751 1394  5070711 1396  
330866 5070673 1396  5070635 1396  5070603 1394  5070573 1396  5070551 1394  5070516 1396  
330867 5070492 1396  5070478 1396  5070470 1394  5070449 1396  5070435 1396  5070425 1396  
330868 5070420 1396  5070420 1396  5070420 1396  5070419 1398  5070425 1396  5070434 1396  
330869 5070449 1396  5070471 1398  5070487 1396  5070511 1396  5070535 1396  5070567 1398  
330870 5070588 1396  5070616 1396  5070650 1396  5070688 1396  5070716 1396  5070759 1396  
330871 5070793 1396  5070834 1398  5070865 1396  5070901 1398  5070939 1398  5070977 1398  
330872 5071017 1396  5071059 1398  5071082 1398  5071117 1396  5071149 1398  5071170 1396  
330873 5071202 1398  5071226 1398  5071250 1398  5071264 1398  5071280 1396  5071294 1396  
330874 5071304 1396  5071309 1396  5071309 1396  5071318 1396  5071309 1396  5071309 1396  
330875 5071304 1396  5071296 1394  5071281 1394  5071267 1394  5071255 1392  5071237 1396  
330876 5071211 1392  5071186 1394  5071167 1394  5071143 1394  5071114 1394  5071086 1394  
330877 5071062 1394  5071038 1394  5071006 1392  5070971 1394  5070944 1392  5070914 1394  
330878 5070890 1394  5070861 1394  5070837 1394  5070815 1392  5070788 1396  5070770 1394  
330879 5070752 1394  5070727 1394  5070718 1394  5070704 1394  5070694 1394  5070689 1394  
330880 5070680 1394  5070681 1392  5070680 1394  5070680 1394  5070689 1394  5070694 1394  
330881 5070704 1394  5070715 1392  5070728 1394  5070753 1392  5070772 1392  5070791 1392  
330882 5070815 1392  5070839 1392  5070863 1392  5070882 1392  5070915 1392  5070945 1390  
330883 5070968 1392  5071006 1392  5071030 1392  5071070 1390  5071087 1392  5071130 1392  
330884 5071156 1390  5071183 1392  5071211 1392  5071242 1390  5071269 1392  5071284 1390  
330885 5071308 1390  5071323 1390  5071347 1390  5071356 1390  5071370 1390  5071375 1390  
330886 5071385 1390  5071390 1390  5071391 1388  5071391 1388  5071390 1390  5071385 1390  
330887 5071371 1390  5071367 1388  5071356 1390  5071334 1388  5071313 1390  5071299 1390  
330888 5071272 1388  5071246 1390  5071213 1390  5071184 1390  5071167 1388  5071132 1390  
330889 5071089 1390  5071056 1390  5071023 1388  5070990 1388  5070957 1388  5070917 1390  
330890 5070883 1390  5070847 1388  5070818 1388  5070785 1388  5070745 1390  5070716 1390  
330891 5070683 1390  5070665 1388  5070641 1388  5070606 1390  5070584 1388  5070563 1390  
330892 5070551 1388  5070532 1388  5070520 1390  5070507 1388  5070498 1388  5070493 1388  
330893 5070493 1388  5070484 1388  5070493 1388  5070494 1389  5070498 1388  5070517 1388  
330894 5070522 1388  5070541 1388  5070556 1388  5070581 1387  5070594 1388  5070616 1390  
330895 5070651 1388  5070673 1390  5070694 1388  5070723 1388  5070755 1390  5070783 1390  
330896 5070818 1388  5070845 1390  5070878 1390  5070907 1390  5070941 1390  5070969 1390  
330897 5071000 1388  5071032 1390  5071055 1390  5071084 1390  5071106 1392  5071132 1390  
330898 5071156 1390  5071168 1392  5071183 1392  5071197 1392  5071207 1392  5071221 1392  
330899 5071229 1394  5071240 1392  5071240 1392  5071240 1392  5071240 1392  5071240 1392  
330900 5071231 1392  5071220 1394  5071207 1392  5071196 1394  5071181 1394  5071167 1394  
330901 5071143 1394  5071129 1394  5071105 1394  5071086 1394  5071067 1394  5071043 1394  
330902 5071019 1394  5070995 1394  5070971 1394  5070952 1394  5070928 1394  5070904 1394  
330903 5070888 1396  5070866 1394  5070850 1396  5070836 1396  5070813 1394  5070802 1396  
330904 5070788 1396  5070774 1396  5070769 1396  5070769 1396  5070756 1400  5070756 1400  
330905 5070745 1402  5070745 1402  5070753 1403  5070753 1403  5070763 1403  5070767 1403  
330906 5070772 1403  5070787 1403  5070806 1403  5070820 1403  5070834 1403  5070860 1402  
330907 5070873 1403  5070887 1403  5070912 1402  5070936 1402  5070960 1402  5070981 1400  
330908 5071008 1402  5071033 1400  5071056 1402  5071081 1400  5071108 1402  5071132 1402  
330909 5071158 1400  5071166 1402  5071191 1400  5071213 1402  5071234 1400  5071256 1402  
330910 5071261 1402  5071277 1400  5071293 1398  5071301 1400  5071317 1398  5071317 1398  
330911 5071326 1398  5071331 1398  5071329 1400  5071325 1400  5071326 1398  5071317 1398  
330912 5071309 1396  5071293 1398  5071278 1398  5071264 1398  5071250 1398  5071235 1398  
330913 5071208 1396  5071193 1398  5071164 1398  5071140 1398  5071116 1398  5071092 1398  
330914 5071059 1398  5071035 1398  5071003 1396  5070970 1396  5070939 1398  5070912 1396  
330915 5070879 1396  5070860 1396  5070828 1394  5070793 1396  5070774 1396  5070742 1394  
330916 5070718 1394  5070694 1394  5070675 1394  5070651 1394  5070637 1394  5070618 1394  
330917 5070605 1392  5070592 1390  5070577 1390  5070573 1390  5070563 1390  5070554 1390  
330918 5070552 1392  5070556 1388  5070554 1390  5070554 1390  5070574 1388  5070579 1388  
330919 5070586 1387  5070594 1388  5070609 1387  5070624 1387  5070641 1388  5070657 1387  
330920 5070679 1388  5070695 1387  5070724 1387  5070743 1387  5070767 1387  5070797 1385  
330921 5070821 1385  5070850 1385  5070874 1385  5070902 1385  5070926 1385  5070950 1385  
330922 5070974 1385  5071003 1385  5071027 1385  5071045 1385  5071070 1385  5071079 1385  
330923 5071101 1387  5071122 1385  5071136 1385  5071146 1385  5071150 1385  5071170 1385  
330924 5071174 1385  5071178 1387  5071179 1385  5071178 1387  5071178 1387  5071179 1385  
330925 5071178 1387  5071173 1387  5071170 1385  5071160 1385  5071150 1385  5071135 1387  
330926 5071122 1385  5071103 1385  5071093 1385  5071077 1387  5071068 1387  5071049 1387  
330927 5071036 1385  5071011 1387  5070993 1385  5070977 1387  5070967 1386  5070950 1385  
330928 5070934 1387  5070920 1387  5070901 1387  5070896 1387  5070881 1387  5070872 1387  
330929 5070869 1385  5070858 1387  5070847 1388  5070843 1387  5070842 1388  5070842 1388  
330930 5070842 1388  5070840 1390  5070840 1390  5070842 1394  5070850 1396  5070858 1398  
330931 5070860 1402  5070873 1403  5070887 1403  5070906 1403  5070911 1404  5070928 1405  
330932 5070943 1405  5070957 1405  5070973 1409  5070995 1405  5071006 1409  5071030 1409  
330933 5071049 1409  5071069 1409  5071083 1409  5071107 1409  5071126 1409  5071150 1409  
330934 5071159 1409  5071182 1411  5071196 1411  5071217 1409  5071230 1411  5071248 1411  
330935 5071254 1411  5071268 1411  5071273 1411  5071282 1411  5071292 1411  5071295 1413  
330936 5071295 1413  5071296 1411  5071296 1411  5071295 1413  5071295 1413  5071290 1413  
330937 5071280 1413  5071266 1413  5071257 1413  5071249 1411  5071238 1413  5071225 1411  
330938 5071195 1413  5071182 1411  5071167 1411  5071153 1411  5071129 1411  5071107 1409  
330939 5071081 1411  5071058 1411  5071037 1413  5071013 1413  5070979 1413  5070954 1415  
330940 5070935 1415  5070913 1413  5070887 1415  5070859 1415  5070833 1417  5070819 1417  
330941 5070797 1415  5070771 1417  5070759 1415  5070734 1415  5070719 1417  5070700 1417  
330942 5070687 1415  5070672 1415  5070658 1415  5070653 1415  5070642 1417  5070633 1417  
330943 5070628 1417  5070630 1415  5070620 1415  5070619 1417  5070620 1415  5070629 1415  
330944 5070634 1415  5070633 1417  5070644 1415  5070652 1417  5070658 1415  5070672 1415  
330945 5070687 1415  5070703 1413  5070722 1413  5070735 1415  5070754 1415  5070765 1413  
330946 5070789 1413  5070812 1413  5070827 1413  5070851 1413  5070875 1413  5070889 1413  
330947 5070913 1413  5070927 1413  5070951 1413  5070965 1413  5070988 1415  5071004 1413  
330948 5071023 1413  5071035 1415  5071046 1413  5071056 1413  5071066 1413  5071070 1413  
330949 5071081 1411  5071083 1409  5071093 1409  5071096 1405  5071097 1403  5071097 1403  
330950 5071097 1403  5071097 1403  5071088 1403  5071078 1403  5071073 1403  5071065 1402  
330951 5071059 1403  5071054 1403  5071037 1402  5071032 1402  5071013 1402  5071008 1402  
330952 5070989 1402  5070974 1402  5070965 1402  5070957 1400  5070946 1402  5070932 1402  
330953 5070922 1402  5070908 1402  5070898 1402  5070889 1402  5070874 1402  5070868 1403  
330954 5070858 1403  5070858 1404  5070854 1403  5070854 1403  5070844 1403  5070844 1403  
330955 5070834 1403  5070834 1403  5070834 1403  5070833 1405  5070842 1405  5070842 1405  
330956 5070852 1405  5070852 1405  5070857 1405  5070866 1405  5070871 1405  5070886 1405  
330957 5070895 1405  5070905 1405  5070919 1405  5070935 1404  5070944 1403  5070959 1404  
330958 5070973 1403  5070987 1403  5070997 1403  5071011 1403  5071030 1403  5071046 1402  
330959 5071061 1402  5071076 1400  5071091 1400  5071102 1398  5071126 1398  5071137 1396  
330960 5071141 1396  5071161 1396  5071167 1394  5071170 1396  5071181 1394  5071184 1396  
330961 5071188 1392  5071196 1394  5071196 1394  5071197 1392  5071196 1394  5071196 1394  
330962 5071196 1394  5071188 1392  5071183 1392  5071173 1392  5071167 1394  5071162 1394  
330963 5071154 1392  5071140 1392  5071121 1392  5071106 1392  5071087 1392  5071073 1392  
330964 5071062 1394  5071038 1394  5071019 1394  5070994 1396  5070979 1396  5070961 1394  
330965 5070939 1398  5070917 1396  5070892 1398  5070877 1398  5070858 1398  5070837 1400  
330966 5070813 1400  5070791 1398  5070775 1400  5070766 1400  5070739 1398  5070726 1396  
330967 5070710 1398  5070702 1396  5070688 1396  5070678 1396  5070669 1396  5070661 1394  
330968 5070646 1394  5070637 1394  5070637 1394  5070627 1394  5070627 1394  5070629 1392  
330969 5070629 1392  5070635 1396  5070637 1394  5070646 1394  5070651 1394  5070661 1394  
330970 5070669 1396  5070678 1396  5070688 1396  5070704 1394  5070716 1396  5070726 1396  
330971 5070742 1394  5070770 1394  5070778 1396  5070793 1396  5070815 1398  5070834 1398  
330972 5070860 1396  5070872 1398  5070887 1398  5070903 1396  5070925 1398  5070939 1398  
330973 5070959 1398  5070969 1396  5070977 1398  5070993 1396  5071014 1394  5071019 1394  
330974 5071028 1394  5071036 1396  5071043 1394  5071054 1392  5071062 1394  5071067 1394  
330975 5071067 1394  5071067 1394  5071067 1394  5071068 1392  5071068 1392  5071068 1392  
330976 5071068 1392  5071063 1392  5071054 1392  5071044 1392  5071039 1392  5071032 1390  
330977 5071022 1390  5071017 1390  5071007 1390  5070989 1390  5070985 1388  5070974 1390  
330978 5070965 1390  5070955 1390  5070945 1390  5070941 1390  5070931 1390  5070917 1390  
330979 5070907 1390  5070899 1388  5070893 1390  5070883 1390  5070887 1387  5070881 1387  
330980 5070870 1388  5070871 1388  5070869 1390  5070866 1388  5070867 1387  5070867 1387  
330981 5070867 1387  5070866 1388  5070870 1388  5070872 1387  5070882 1387  5070882 1387  
330982 5070887 1387  5070901 1387  5070901 1387  5070920 1387  5070925 1387  5070944 1387  
330983 5070958 1387  5070968 1387  5070979 1385  5070993 1385  5071010 1387  5071020 1387  
330984 5071035 1387  5071049 1387  5071068 1387  5071076 1388  5071092 1387  5071109 1388  
330985 5071125 1387  5071133 1388  5071147 1388  5071159 1387  5071171 1388  5071176 1388  
330986 5071187 1387  5071192 1387  5071191 1388  5071200 1388  5071211 1387  5071209 1388  
330987 5071216 1387  5071214 1388  5071216 1387  5071211 1387  5071211 1387  5071202 1387  
330988 5071202 1387  5071192 1387  5071187 1387  5071173 1387  5071159 1387  5071148 1388  
330989 5071135 1387  5071121 1387  5071101 1387  5071089 1385  5071073 1387  5071059 1387  
330990 5071034 1387  5071020 1387  5070990 1388  5070977 1387  5070958 1387  5070944 1387  
330991 5070920 1387  5070901 1387  5070881 1387  5070866 1388  5070843 1387  5070824 1387  
330992 5070799 1388  5070785 1388  5070775 1388  5070767 1387  5070746 1388  5070732 1388  
330993 5070723 1388  5070716 1390  5070707 1390  5070707 1390  5070696 1392  5070696 1392  
330994 5070691 1392  5070691 1392  5070694 1394  5070694 1394  5070704 1394  5070702 1396  
330995 5070711 1396  5070716 1396  5070737 1394  5070740 1396  5070761 1394  5070774 1396  
330996 5070788 1396  5070802 1396  5070815 1398  5070836 1396  5070850 1396  5070874 1396  
330997 5070888 1396  5070903 1396  5070917 1396  5070936 1396  5070952 1394  5070968 1392  
330998 5070987 1392  5070998 1390  5071024 1388  5071041 1390  5071046 1390  5071065 1390  
330999 5071076 1388  5071086 1388  5071090 1388  5071100 1388  5071109 1388  5071119 1388  
331000 5071125 1387  5071133 1388  5071135 1387  5071133 1388  5071135 1387  5071125 1387  
331001 5071125 1387  5071121 1387  5071121 1387  5071111 1387  5071101 1387  5071086 1388  
331002 5071077 1387  5071073 1387  5071068 1387  5071049 1387  5071044 1387  5071025 1387  
331003 5071011 1387  5071001 1387  5070987 1387  5070974 1385  5070969 1385  5070948 1387  
331004 5070934 1387  5070921 1385  5070912 1385  5070898 1385  5070888 1385  5070883 1385  
331005 5070869 1385  5070859 1385  5070850 1385  5070845 1385  5070845 1385  5070837 1383  
331006 5070835 1385  5070835 1385  5070835 1385  5070835 1385  5070835 1385  5070845 1385  
331007 5070850 1385  5070850 1385  5070859 1385  5070874 1385  5070885 1383  5070888 1385  
331008 5070902 1385  5070913 1383  5070926 1385  5070945 1385  5070960 1385  5070971 1383  
331009 5070980 1383  5070993 1385  5071012 1385  5071038 1383  5071047 1383  5071060 1385  
331010 5071080 1383  5071089 1385  5071103 1385  5071122 1385  5071136 1385  5071150 1385  
331011 5071160 1385  5071170 1385  5071179 1385  5071189 1385  5071189 1385  5071195 1383  
331012 5071203 1385  5071203 1385  5071203 1385  5071203 1385  5071203 1385  5071203 1385  
331013 5071203 1385  5071195 1383  5071189 1385  5071179 1385  5071176 1383  5071160 1385  
331014 5071150 1385  5071136 1385  5071121 1387  5071103 1385  5071089 1385  5071068 1387  
331015 5071047 1388  5071034 1387  5071010 1387  5070987 1387  5070966 1388  5070947 1388  
331016 5070923 1388  5070899 1388  5070880 1388  5070864 1390  5070840 1390  5070818 1388  
331017 5070797 1390  5070780 1388  5070762 1392  5070745 1390  5070738 1392  5070720 1392  
331018 5070705 1392  5070696 1392  5070681 1392  5070679 1394  5070676 1392  5070672 1392  
331019 5070670 1394  5070670 1394  5070670 1394  5070670 1394  5070676 1392  5070681 1392  
331020 5070689 1394  5070696 1392  5070713 1394  5070718 1394  5070737 1394  5070753 1392  
331021 5070770 1394  5070780 1394  5070794 1394  5070820 1392  5070837 1394  5070860 1396  
331022 5070880 1394  5070893 1396  5070919 1394  5070942 1394  5070966 1394  5070981 1394  
331023 5071005 1394  5071028 1394  5071043 1394  5071060 1396  5071070 1396  5071084 1396  
331024 5071103 1396  5071113 1396  5071127 1396  5071137 1396  5071141 1396  5071151 1396  
331025 5071161 1396  5071161 1396  5071161 1396  5071161 1396  5071162 1394  5071151 1396  
331026 5071151 1396  5071141 1396  5071138 1394  5071129 1394  5071117 1396  5071105 1394  
331027 5071086 1394  5071081 1394  5071067 1394  5071052 1394  5071038 1394  5071019 1394  
331028 5071005 1394  5070984 1396  5070971 1394  5070952 1394  5070942 1394  5070919 1394  
331029 5070904 1394  5070890 1394  5070874 1396  5070861 1394  5070852 1394  5070837 1394  
331030 5070828 1394  5070813 1394  5070804 1394  5070804 1394  5070793 1396  5070793 1396  
331031 5070793 1396  5070788 1396  5070793 1396  5070791 1398  5070791 1398  5070802 1396  
331032 5070812 1396  5070815 1398  5070834 1398  5070839 1398  5070849 1398  5070863 1398  
331033 5070871 1400  5070885 1400  5070909 1400  5070925 1398  5070938 1400  5070960 1402  
331034 5070976 1400  5071000 1400  5071014 1400  5071038 1400  5071060 1402  5071075 1402  
331035 5071100 1400  5071114 1400  5071138 1400  5071158 1400  5071167 1400  5071181 1400  
331036 5071201 1400  5071216 1398  5071225 1400  5071234 1400  5071250 1398  5071259 1398  
331037 5071264 1398  5071263 1400  5071269 1398  5071269 1398  5071269 1398  5071269 1398  
331038 5071263 1400  5071258 1400  5071248 1400  5071234 1400  5071224 1400  5071205 1400  
331039 5071191 1400  5071176 1400  5071158 1400  5071138 1400  5071124 1400  5071102 1398  
331040 5071076 1400  5071057 1400  5071033 1400  5071009 1400  5070981 1400  5070962 1400  
331041 5070938 1400  5070912 1402  5070890 1400  5070871 1400  5070855 1402  5070831 1402  
331042 5070809 1400  5070790 1400  5070774 1402  5070764 1402  5070745 1402  5070731 1402  
331043 5070721 1402  5070714 1400  5070708 1400  5070699 1400  5070690 1400  5070690 1400  
331044 5070690 1400  5070688 1402  5070699 1400  5070699 1400  5070714 1400  5070723 1400  
331045 5070731 1402  5070747 1400  5070766 1400  5070771 1400  5070790 1400  5070809 1400  
331046 5070823 1400  5070845 1402  5070861 1400  5070889 1402  5070914 1400  5070938 1400  
331047 5070962 1400  5070981 1400  5071008 1402  5071033 1400  5071056 1402  5071076 1400  
331048 5071100 1400  5071114 1400  5071137 1402  5071158 1400  5071161 1402  5071176 1400  
331049 5071191 1400  5071200 1400  5071204 1402  5071215 1400  5071226 1398  5071234 1400  
331050 5071234 1400  5071234 1400  5071234 1400  5071225 1400  5071221 1403  5071213 1402  
331051 5071204 1402  5071199 1402  5071180 1402  5071175 1402  5071159 1403  5071135 1403  
331052 5071123 1402  5071108 1402  5071079 1402  5071061 1402  5071046 1402  5071022 1402  
331053 5070998 1402  5070974 1402  5070962 1400  5070938 1400  5070912 1402  5070890 1400  
331054 5070876 1400  5070861 1400  5070847 1400  5070831 1402  5070813 1400  5070799 1400  
331055 5070790 1400  5070784 1402  5070775 1400  5070769 1402  5070766 1400  5070764 1402  
331056 5070755 1402  5070763 1403  5070764 1402  5070769 1402  5070771 1400  5070774 1402  
331057 5070788 1402  5070798 1402  5070806 1403  5070822 1402  5070834 1403  5070858 1403  
331058 5070873 1403  5070887 1403  5070911 1403  5070930 1403  5070954 1403  5070973 1403  
331059 5070997 1403  5071021 1403  5071044 1403  5071064 1403  5071088 1404  5071107 1403  
331060 5071131 1403  5071155 1404  5071164 1403  5071188 1403  5071202 1403  5071222 1404  
331061 5071236 1404  5071255 1404  5071264 1403  5071274 1404  5071279 1404  5071288 1403  
331062 5071288 1403  5071298 1404  5071298 1404  5071298 1403  5071288 1404  5071288 1404  
331063 5071274 1403  5071263 1405  5071260 1403  5071245 1404  5071231 1403  5071212 1403  
331064 5071188 1403  5071172 1405  5071153 1405  5071131 1403  5071102 1409  5071076 1405  
331065 5071059 1409  5071040 1409  5071010 1405  5070986 1405  5070962 1405  5070940 1409  
331066 5070916 1409  5070883 1409  5070868 1409  5070849 1409  5070825 1409  5070801 1409  
331067 5070782 1409  5070763 1409  5070749 1409  5070730 1409  5070725 1409  5070706 1409  
331068 5070709 1405  5070704 1405  5070695 1405  5070692 1409  5070694 1405  5070694 1405  
331069 5070704 1405  5070706 1409  5070718 1405  5070728 1405  5070739 1409  5070761 1405  
331070 5070768 1409  5070785 1405  5070809 1405  5070828 1405  5070849 1409  5070868 1409  
331071 5070892 1409  5070916 1409  5070940 1409  5070967 1411  5070991 1411  5071016 1409  
331072 5071040 1409  5071067 1411  5071091 1411  5071115 1411  5071137 1413  5071156 1413  
331073 5071182 1411  5071195 1413  5071214 1413  5071238 1413  5071252 1413  5071257 1413  
331074 5071266 1413  5071271 1413  5071279 1415  5071290 1413  5071290 1413  5071289 1415  
331075 5071280 1413  5071282 1411  5071273 1411  5071266 1413  5071252 1413  5071239 1411  
331076 5071228 1413  5071204 1413  5071191 1411  5071166 1413  5071151 1413  5071129 1411  
331077 5071105 1411  5071081 1411  5071055 1409  5071031 1409  5071007 1409  5070981 1411  
331078 5070957 1411  5070938 1411  5070913 1413  5070892 1409  5070867 1411  5070852 1411  
331079 5070828 1411  5070814 1411  5070800 1411  5070774 1413  5070766 1411  5070761 1411  
331080 5070747 1411  5070736 1413  5070727 1413  5070727 1413  5070727 1413  5070727 1413  
331081 5070727 1413  5070736 1413  5070744 1415  5070755 1413  5070765 1413  5070773 1415  
331082 5070797 1415  5070812 1413  5070825 1415  5070849 1415  5070864 1415  5070888 1415  
331083 5070910 1417  5070935 1415  5070964 1415  5070988 1415  5071021 1415  5071043 1417  
331084 5071063 1417  5071096 1417  5071120 1417  5071145 1415  5071163 1417  5071193 1415  
331085 5071222 1415  5071244 1417  5071254 1417  5071277 1417  5071292 1417  5071311 1417  
331086 5071316 1417  5071337 1415  5071344 1417  5071351 1415  5071351 1415  5071349 1417  
331087 5071351 1415  5071351 1415  5071349 1417  5071348 1413  5071336 1415  5071317 1415  
331088 5071312 1415  5071293 1415  5071279 1415  5071255 1415  5071246 1415  5071223 1413  
331089 5071204 1413  5071169 1415  5071150 1415  5071126 1415  5071098 1415  5071069 1415  
331090 5071052 1413  5071021 1415  5070999 1413  5070970 1413  5070950 1415  5070923 1413  
331091 5070899 1413  5070873 1415  5070849 1415  5070835 1415  5070811 1415  5070797 1415  
331092 5070776 1417  5070762 1417  5070759 1415  5070755 1413  5070742 1417  5070744 1415  
331093 5070742 1417  5070742 1417  5070742 1417  5070744 1415  5070754 1415  5070757 1417  
331094 5070773 1415  5070786 1417  5070795 1417  5070809 1417  5070833 1417  5070847 1417  
331095 5070870 1419  5070895 1417  5070919 1417  5070943 1417  5070967 1417  5071001 1417  
331096 5071026 1415  5071048 1417  5071077 1417  5071099 1419  5071125 1417  5071148 1417  
331097 5071177 1417  5071192 1417  5071220 1417  5071244 1417  5071263 1417  5071279 1415  
331098 5071292 1417  5071311 1417  5071325 1417  5071336 1415  5071346 1415  5071351 1415  
331099 5071351 1415  5071351 1415  5071351 1415  5071351 1415  5071346 1415  5071336 1415  
331100 5071327 1415  5071314 1413  5071295 1413  5071279 1415  5071266 1413  5071247 1413  
331101 5071227 1415  5071195 1413  5071171 1413  5071147 1413  5071123 1413  5071088 1415  
331102 5071066 1413  5071037 1413  5071011 1415  5070978 1415  5070948 1417  5070926 1415  
331103 5070897 1415  5070873 1415  5070848 1417  5070824 1417  5070811 1415  5070786 1417  
331104 5070771 1417  5070757 1417  5070742 1417  5070724 1417  5070719 1417  5070707 1419  
331105 5070698 1419  5070700 1417  5070700 1417  5070700 1417  5070697 1420  5070708 1419  
331106 5070717 1419  5070732 1419  5070741 1419  5070756 1419  5070770 1419  5070794 1419  
331107 5070808 1418  5070832 1419  5070856 1419  5070875 1419  5070899 1419  5070921 1420  
331108 5070946 1419  5070973 1420  5070999 1419  5071032 1419  5071050 1420  5071083 1420  
331109 5071109 1419  5071141 1420  5071160 1420  5071184 1420  5071209 1419  5071241 1420  
331110 5071252 1419  5071276 1419  5071290 1419  5071308 1420  5071322 1420  5071333 1419  
331111 5071343 1419  5071348 1419  5071352 1419  5071346 1420  5071348 1419  5071346 1420  
331112 5071348 1419  5071343 1419  5071333 1419  5071314 1419  5071298 1420  5071287 1417  
331113 5071266 1419  5071252 1419  5071233 1419  5071209 1419  5071185 1419  5071163 1417  
331114 5071144 1417  5071110 1417  5071085 1419  5071052 1419  5071023 1419  5070994 1419  
331115 5070966 1419  5070942 1419  5070920 1417  5070894 1419  5070868 1420  5070846 1419  
331116 5070822 1419  5070808 1419  5070794 1419  5070770 1419  5070757 1417  5070751 1419  
331117 5070742 1417  5070733 1417  5070722 1419  5070722 1419  5070719 1417  5070719 1417  
331118 5070724 1417  5070722 1419  5070733 1417  5070751 1419  5070760 1419  5070770 1419  
331119 5070794 1418  5070808 1419  5070822 1419  5070846 1419  5070870 1418  5070894 1419  
331120 5070918 1419  5070945 1420  5070975 1419  5070998 1420  5071032 1419  5071052 1419  
331121 5071075 1419  5071109 1419  5071131 1420  5071152 1419  5071185 1419  5071209 1419  
331122 5071232 1420  5071250 1420  5071265 1420  5071289 1420  5071300 1419  5071312 1420  
331123 5071333 1419  5071341 1420  5071346 1420  5071348 1419  5071348 1419  5071348 1419  
331124 5071343 1419  5071333 1419  5071324 1419  5071316 1417  5071303 1415  5071277 1417  
331125 5071257 1413  5071238 1413  5071214 1413  5071190 1413  5071167 1411  5071139 1411  
331126 5071115 1411  5071080 1413  5071051 1413  5071023 1413  5070991 1411  5070957 1411  
331127 5070927 1413  5070899 1413  5070867 1411  5070846 1413  5070814 1411  5070789 1413  
331128 5070760 1413  5070735 1415  5070711 1415  5070687 1415  5070672 1415  5070660 1413  
331129 5070644 1415  5070636 1413  5070620 1415  5070620 1415  5070610 1415  5070612 1413  
331130 5070610 1415  5070620 1415  5070622 1413  5070630 1415  5070636 1413  5070653 1415  
331131 5070663 1415  5070679 1413  5070699 1411  5070722 1413  5070738 1411  5070763 1409  
331132 5070782 1409  5070819 1405  5070833 1405  5070868 1403  5070887 1404  5070921 1403  
331133 5070954 1404  5070974 1402  5071006 1404  5071030 1404  5071061 1402  5071078 1403  
331134 5071111 1404  5071146 1402  5071164 1403  5071188 1403  5071202 1403  5071232 1402  
331135 5071245 1404  5071261 1402  5071274 1404  5071279 1404  5071288 1403  5071298 1404  
331136 5071298 1403  5071298 1403  5071298 1403  5071288 1404  5071290 1402  5071280 1402  
331137 5071266 1402  5071261 1402  5071237 1402  5071225 1400  5071204 1402  5071180 1402  
331138 5071161 1402  5071148 1400  5071124 1400  5071091 1400  5071065 1402  5071046 1402  
331139 5071014 1400  5070991 1400  5070960 1402  5070933 1400  5070909 1400  5070884 1402  
331140 5070861 1400  5070838 1400  5070807 1402  5070790 1400  5070775 1400  5070756 1400  
331141 5070737 1400  5070723 1400  5070714 1400  5070699 1400  5070699 1400  5070690 1400  
331142 5070690 1400  5070688 1402  5070690 1400  5070699 1400  5070708 1400  5070712 1402  
331143 5070721 1402  5070737 1400  5070756 1400  5070769 1402  5070788 1402  5070809 1400  
331144 5070833 1400  5070857 1400  5070876 1400  5070900 1400  5070933 1400  5070957 1400  
331145 5070974 1402  5071008 1402  5071033 1400  5071062 1400  5071081 1400  5071113 1402  
331146 5071137 1402  5071167 1400  5071191 1400  5071215 1400  5071237 1402  5071258 1400  
331147 5071266 1402  5071282 1400  5071299 1402  5071306 1400  5071313 1402  5071325 1400  
331148 5071325 1400  5071325 1400  5071325 1400  5071315 1400  5071306 1400  5071301 1400  
331149 5071282 1400  5071267 1400  5071259 1398  5071234 1400  5071216 1398  5071193 1398  
331150 5071167 1400  5071138 1400  5071116 1398  5071081 1400  5071059 1398  5071033 1400  
331151 5071001 1398  5070967 1400  5070933 1400  5070909 1400  5070876 1400  5070849 1398  
331152 5070814 1400  5070790 1400  5070766 1400  5070732 1400  5070708 1400  5070683 1402  
331153 5070666 1400  5070647 1400  5070631 1402  5070611 1402  5070599 1400  5070589 1400  
331154 5070583 1402  5070573 1402  5070575 1400  5070573 1402  5070573 1402  5070583 1402  
331155 5070586 1403  5070597 1402  5070611 1402  5070631 1402  5070643 1404  5070662 1403  
331156 5070682 1404  5070696 1404  5070721 1402  5070753 1403  5070772 1404  5070798 1402  
331157 5070830 1403  5070860 1402  5070883 1404  5070906 1403  5070936 1402  5070965 1402  
331158 5070989 1402  5071022 1402  5071056 1402  5071080 1402  5071108 1402  5071132 1402  
331159 5071156 1402  5071167 1400  5071191 1400  5071204 1402  5071225 1400  5071239 1400  
331160 5071248 1400  5071258 1400  5071263 1400  5071267 1400  5071266 1402  5071267 1400  
331161 5071267 1400  5071263 1400  5071258 1400  5071248 1400  5071237 1402  5071225 1400  
331162 5071204 1402  5071191 1400  5071167 1400  5071158 1400  5071134 1400  5071110 1400  
331163 5071080 1402  5071062 1400  5071038 1400  5071009 1400  5070979 1402  5070956 1402  
331164 5070932 1402  5070908 1402  5070884 1402  5070861 1400  5070836 1402  5070813 1400  
331165 5070798 1402  5070774 1402  5070764 1402  5070745 1402  5070731 1402  5070723 1400  
331166 5070712 1402  5070707 1402  5070698 1402  5070697 1402  5070699 1400  5070698 1402  
331167 5070707 1402  5070712 1402  5070723 1400  5070731 1402  5070745 1402  5070766 1400  
331168 5070774 1402  5070788 1402  5070811 1404  5070834 1403  5070858 1403  5070884 1402  
331169 5070908 1402  5070930 1404  5070959 1404  5070978 1404  5071008 1402  5071032 1402  
331170 5071059 1404  5071078 1404  5071108 1402  5071137 1402  5071155 1404  5071175 1402  
331171 5071199 1402  5071222 1404  5071237 1402  5071256 1402  5071264 1404  5071275 1402  
331172 5071288 1404  5071288 1404  5071299 1402  5071299 1402  5071299 1402  5071301 1400  
331173 5071290 1402  5071280 1402  5071275 1402  5071260 1403  5071247 1402  5071233 1402  
331174 5071213 1402  5071190 1402  5071166 1402  5071146 1402  5071113 1402  5071089 1402  
331175 5071064 1404  5071035 1404  5071008 1402  5070973 1403  5070944 1404  5070911 1404  
331176 5070882 1404  5070854 1404  5070820 1404  5070787 1403  5070768 1404  5070734 1404  
331177 5070710 1403  5070682 1403  5070663 1404  5070639 1404  5070620 1403  5070605 1403  
331178 5070586 1404  5070572 1404  5070562 1403  5070553 1404  5070553 1404  5070543 1403  
331179 5070542 1405  5070543 1403  5070553 1403  5070562 1403  5070567 1403  5070572 1403  
331180 5070586 1403  5070605 1404  5070620 1403  5070643 1404  5070663 1404  5070682 1403  
331181 5070705 1403  5070729 1403  5070753 1403  5070784 1402  5070807 1402  5070836 1402  
331182 5070868 1403  5070887 1403  5070922 1402  5070944 1404  5070973 1403  5071008 1402  
331183 5071030 1403  5071059 1403  5071078 1404  5071107 1404  5071131 1403  5071155 1403  
331184 5071164 1403  5071178 1403  5071197 1403  5071202 1404  5071212 1403  5071222 1404  
331185 5071230 1405  5071231 1403  5071231 1404  5071231 1404  5071221 1403  5071221 1403  
331186 5071202 1403  5071197 1403  5071178 1403  5071166 1402  5071159 1403  5071135 1403  
331187 5071121 1403  5071097 1403  5071078 1403  5071061 1402  5071037 1402  5071011 1403  
331188 5070987 1403  5070965 1402  5070944 1403  5070921 1403  5070897 1403  5070873 1403  
331189 5070858 1403  5070834 1403  5070811 1404  5070796 1404  5070782 1404  5070768 1403  
331190 5070753 1403  5070744 1404  5070729 1404  5070720 1403  5070710 1403  5070710 1403  
331191 5070710 1403  5070710 1404  5070710 1404  5070720 1403  5070729 1403  5070729 1403  
331192 5070742 1405  5070761 1405  5070772 1403  5070787 1404  5070804 1405  5070828 1405  
331193 5070844 1403  5070868 1403  5070887 1403  5070911 1404  5070935 1403  5070959 1403  
331194 5070978 1403  5071006 1403  5071035 1404  5071059 1403  5071078 1403  5071108 1402  
331195 5071132 1402  5071161 1402  5071175 1402  5071199 1402  5071221 1403  5071237 1402  
331196 5071247 1402  5071261 1402  5071266 1402  5071275 1402  5071279 1403  5071280 1402  
331197 5071282 1400  5071280 1402  5071280 1402  5071275 1402  5071267 1400  5071261 1402  
331198 5071247 1402  5071233 1402  5071213 1402  5071199 1402  5071175 1402  5071156 1402  
331199 5071132 1402  5071108 1402  5071079 1402  5071056 1402  5071022 1402  5070998 1402  
331200 5070965 1402  5070938 1400  5070908 1402  5070876 1400  5070847 1400  5070815 1398  
331201 5070787 1398  5070767 1398  5070735 1396  5070702 1396  5070678 1396  5070661 1394  
331202 5070637 1394  5070619 1392  5070605 1392  5070591 1392  5070576 1392  5070573 1390  
331203 5070562 1392  5070552 1392  5070552 1392  5070554 1390  5070552 1392  5070554 1390  
331204 5070554 1390  5070573 1390  5070578 1390  5070583 1390  5070597 1390  5070616 1390  
331205 5070630 1390  5070654 1390  5070678 1390  5070691 1392  5070721 1390  5070743 1392  
331206 5070774 1390  5070797 1390  5070821 1390  5070845 1390  5070869 1390  5070896 1392  
331207 5070920 1392  5070944 1392  5070973 1392  5070997 1392  5071020 1392  5071044 1392  
331208 5071068 1392  5071082 1392  5071105 1394  5071119 1394  5071140 1392  5071153 1394  
331209 5071162 1394  5071168 1392  5071173 1392  5071183 1392  5071188 1392  5071188 1392  
331210 5071188 1392  5071183 1392  5071183 1392  5071173 1392  5071168 1392  5071165 1390  
331211 5071145 1392  5071130 1392  5071122 1390  5071097 1392  5071082 1392  5071065 1390  
331212 5071044 1392  5071030 1392  5071008 1390  5070984 1390  5070968 1392  5070945 1390  
331213 5070922 1390  5070906 1392  5070882 1392  5070863 1392  5070844 1392  5070829 1392  
331214 5070805 1392  5070791 1392  5070777 1392  5070772 1392  5070753 1392  5070743 1392  
331215 5070742 1394  5070737 1394  5070729 1392  5070729 1392  5070737 1394  5070739 1392  
331216 5070737 1394  5070742 1394  5070752 1394  5070762 1392  5070777 1392  5070790 1394  
331217 5070805 1392  5070820 1392  5070839 1392  5070863 1392  5070877 1392  5070895 1394  
331218 5070919 1394  5070942 1394  5070966 1394  5070984 1396  5071014 1394  5071038 1394  
331219 5071062 1394  5071079 1396  5071105 1394  5071129 1394  5071153 1394  5071172 1394  
331220 5071186 1394  5071204 1396  5071220 1394  5071239 1394  5071243 1394  5071263 1394  
331221 5071267 1394  5071267 1394  5071267 1394  5071272 1394  5071272 1394  5071269 1392  
331222 5071267 1394  5071263 1394  5071242 1396  5071238 1394  5071220 1394  5071205 1394  
331223 5071186 1394  5071172 1394  5071153 1394  5071129 1394  5071105 1394  5071079 1396  
331224 5071060 1396  5071036 1396  5071003 1396  5070979 1396  5070951 1396  5070919 1394  
331225 5070895 1394  5070865 1396  5070837 1394  5070812 1396  5070790 1394  5070769 1396  
331226 5070734 1398  5070712 1396  5070688 1396  5070673 1396  5070659 1396  5070645 1396  
331227 5070626 1396  5070615 1398  5070610 1398  5070602 1396  5070591 1398  5070586 1398  
331228 5070586 1398  5070586 1398  5070588 1396  5070586 1398  5070591 1398  5070602 1396  
331229 5070610 1398  5070615 1398  5070634 1398  5070648 1398  5070667 1398  5070686 1398  
331230 5070701 1398  5070725 1398  5070739 1398  5070766 1400  5070785 1400  5070807 1402  
331231 5070822 1402  5070855 1402  5070876 1400  5070898 1402  5070933 1400  5070946 1402  
331232 5070965 1402  5070990 1400  5071013 1402  5071038 1400  5071056 1402  5071065 1402  
331233 5071079 1402  5071100 1400  5071114 1400  5071123 1402  5071138 1400  5071148 1400  
331234 5071156 1402  5071158 1400  5071156 1402  5071158 1400  5071158 1400  5071156 1402  
331235 5071146 1402  5071148 1400  5071137 1402  5071123 1402  5071113 1402  5071100 1400  
331236 5071091 1400  5071075 1402  5071062 1400  5071048 1400  5071032 1402  5071013 1402  
331237 5071000 1400  5070981 1400  5070960 1402  5070947 1400  5070932 1402  5070909 1400  
331238 5070890 1400  5070876 1400  5070863 1398  5070849 1398  5070833 1400  5070825 1398  
331239 5070810 1398  5070801 1398  5070791 1398  5070791 1398  5070787 1398  5070787 1398  
331240 5070785 1400  5070787 1398  5070787 1398  5070791 1398  5070791 1398  5070801 1398  
331241 5070809 1400  5070813 1400  5070833 1400  5070837 1400  5070863 1398  5070872 1398  
331242 5070885 1400  5070911 1398  5070925 1398  5070947 1400  5070962 1400  5070981 1400  
331243 5071000 1400  5071024 1400  5071048 1400  5071065 1402  5071079 1402  5071110 1400  
331244 5071132 1402  5071148 1400  5071166 1402  5071180 1402  5071199 1402  5071205 1400  
331245 5071223 1402  5071234 1400  5071239 1400  5071248 1400  5071258 1400  5071263 1400  
331246 5071263 1400  5071261 1402  5071261 1402  5071258 1400  5071248 1400  5071239 1400  
331247 5071234 1400  5071225 1400  5071205 1400  5071190 1402  5071177 1400  5071162 1400  
331248 5071148 1400  5071124 1400  5071099 1402  5071076 1400  5071056 1402  5071032 1402  
331249 5071009 1400  5070976 1400  5070956 1402  5070933 1400  5070900 1400  5070876 1400  
331250 5070858 1398  5070833 1400  5070810 1398  5070783 1402  5070772 1398  5070746 1400  
331251 5070734 1398  5070710 1398  5070690 1400  5070677 1398  5070672 1398  5070658 1398  
331252 5070648 1398  5070642 1400  5070634 1398  5070623 1400  5070624 1398  5070623 1400  
331253 5070624 1398  5070632 1400  5070632 1400  5070643 1398  5070647 1400  5070666 1400  
331254 5070670 1400  5070685 1400  5070699 1400  5070714 1400  5070734 1398  5070748 1398  
331255 5070767 1398  5070775 1400  5070801 1398  5070815 1398  5070839 1398  5070863 1398  
331256 5070877 1398  5070903 1396  5070925 1398  5070949 1398  5070968 1398  5070992 1398  
331257 5071011 1398  5071035 1398  5071049 1398  5071064 1398  5071076 1400  5071091 1400  
331258 5071100 1400  5071110 1400  5071114 1400  5071126 1398  5071134 1400  5071135 1398  
331259 5071138 1400  5071138 1400  5071140 1398  5071134 1400  5071134 1400  5071124 1400  
331260 5071126 1398  5071114 1400  5071110 1400  5071100 1400  5071081 1400  5071078 1398  
331261 5071062 1400  5071048 1400  5071033 1400  5071014 1400  5071009 1400  5070992 1398  
331262 5070976 1400  5070960 1402  5070947 1400  5070932 1402  5070914 1400  5070909 1400  
331263 5070889 1402  5070884 1402  5070869 1402  5070860 1402  5070854 1404  5070857 1400  
331264 5070845 1402  5070836 1402  5070831 1402  5070831 1402  5070831 1402  5070831 1402  
331265 5070831 1402  5070836 1402  5070836 1402  5070845 1402  5070855 1402  5070860 1402  
331266 5070874 1402  5070884 1402  5070898 1402  5070907 1402  5070924 1400  5070936 1402  
331267 5070956 1402  5070965 1402  5070989 1402  5071008 1402  5071022 1402  5071046 1402  
331268 5071061 1402  5071079 1402  5071099 1402  5071111 1403  5071137 1402  5071155 1403  
331269 5071159 1403  5071175 1402  5071188 1403  5071202 1403  5071212 1403  5071223 1402  
331270 5071232 1402  5071237 1402  5071237 1402  5071245 1403  5071256 1402  5071256 1402  
331271 5071247 1402  5071245 1403  5071236 1403  5071237 1402  5071233 1402  5071212 1403  
331272 5071202 1403  5071188 1403  5071174 1404  5071159 1403  5071146 1402  5071131 1403  
331273 5071107 1403  5071078 1403  5071065 1402  5071044 1403  5071022 1402  5070997 1403  
331274 5070973 1403  5070954 1403  5070930 1403  5070906 1403  5070887 1403  5070868 1403  
331275 5070844 1404  5070820 1403  5070806 1403  5070787 1404  5070768 1403  5070753 1403  
331276 5070734 1404  5070731 1402  5070710 1403  5070707 1402  5070697 1402  5070686 1403  
331277 5070682 1403  5070682 1404  5070672 1403  5070674 1402  5070682 1404  5070682 1403  
331278 5070682 1404  5070686 1403  5070696 1404  5070705 1403  5070710 1403  5070720 1404  
331279 5070734 1404  5070744 1404  5070763 1404  5070772 1403  5070787 1403  5070806 1404  
331280 5070820 1404  5070844 1404  5070858 1404  5070873 1404  5070887 1404  5070911 1404  
331281 5070930 1403  5070944 1403  5070964 1404  5070978 1403  5070995 1405  5071011 1403  
331282 5071030 1404  5071045 1404  5071054 1404  5071062 1405  5071073 1403  5071078 1404  
331283 5071088 1404  5071097 1404  5071097 1403  5071107 1404  5071107 1404  5071107 1403  
331284 5071107 1404  5071110 1405  5071107 1403  5071107 1404  5071097 1403  5071097 1404  
331285 5071088 1404  5071078 1403  5071073 1404  5071064 1403  5071054 1403  5071045 1404  
331286 5071030 1403  5071021 1403  5071006 1403  5070997 1403  5070978 1403  5070963 1403  
331287 5070959 1403  5070944 1403  5070935 1403  5070930 1403  5070911 1403  5070906 1403  
331288 5070887 1403  5070887 1403  5070882 1403  5070873 1403  5070868 1403  5070868 1403  
331289 5070858 1403  5070858 1403  5070858 1403  5070858 1403  5070857 1405  5070866 1405  
331290 5070868 1403  5070873 1404  5070873 1404  5070882 1404  5070896 1403  5070906 1403  
331291 5070909 1405  5070930 1403  5070935 1404  5070954 1404  5070962 1405  5070973 1403  
331292 5070986 1405  5071006 1403  5071021 1404  5071035 1403  5071053 1405  5071062 1405  
331293 5071078 1403  5071096 1405  5071111 1403  5071129 1405  5071134 1405  5071153 1405  
331294 5071158 1405  5071163 1405  5071177 1405  5071186 1405  5071198 1404  5071202 1404  
331295 5071210 1405  5071210 1405  5071210 1405  5071212 1403  5071210 1405  5071210 1405  
331296 5071201 1405  5071201 1405  5071196 1405  5071187 1405  5071172 1405  5071164 1403  
331297 5071155 1404  5071134 1405  5071129 1405  5071111 1403  5071096 1405  5071072 1405  
331298 5071057 1405  5071035 1404  5071021 1404  5070997 1404  5070978 1403  5070963 1403  
331299 5070944 1403  5070930 1404  5070906 1404  5070886 1405  5070873 1403  5070852 1405  
331300 5070834 1403  5070820 1404  5070806 1404  5070787 1404  5070772 1403  5070761 1405  
331301 5070753 1403  5070734 1404  5070730 1404  5070718 1405  5070709 1405  5070704 1405  
331302 5070706 1404  5070695 1405  5070696 1404  5070695 1405  5070685 1405  5070694 1405  
331303 5070694 1405  5070696 1404  5070706 1404  5070710 1404  5070720 1404  5070730 1404  
331304 5070734 1404  5070744 1404  5070763 1403  5070772 1404  5070782 1404  5070796 1404  
331305 5070811 1404  5070830 1404  5070844 1403  5070858 1403  5070873 1403  5070897 1403  
331306 5070911 1403  5070930 1404  5070944 1403  5070959 1404  5070963 1403  5070978 1404  
331307 5070997 1404  5071006 1404  5071021 1403  5071030 1403  5071035 1404  5071044 1403  
331308 5071054 1403  5071059 1404  5071064 1404  5071064 1404  5071073 1404  5071073 1403  
331309 5071073 1403  5071073 1404  5071073 1403  5071064 1403  5071064 1403  5071059 1403  
331310 5071059 1403  5071054 1404  5071045 1404  5071037 1402  5071030 1404  5071021 1403  
331311 5071006 1403  5070997 1404  5070987 1404  5070978 1403  5070973 1404  5070963 1403  
331312 5070954 1403  5070944 1404  5070935 1403  5070930 1404  5070921 1403  5070911 1403  
331313 5070906 1403  5070897 1404  5070897 1404  5070887 1404  5070887 1404  5070882 1403  
331314 5070883 1404  5070882 1403  5070882 1403  5070883 1404  5070887 1404  5070887 1403  
331315 5070897 1403  5070898 1402  5070908 1402  5070911 1404  5070921 1403  5070930 1403  
331316 5070935 1403  5070954 1403  5070960 1402  5070963 1403  5070978 1403  5070988 1404  
331317 5071006 1404  5071011 1403  5071032 1402  5071044 1403  5071059 1403  5071064 1403  
331318 5071075 1402  5071089 1402  5071099 1402  5071113 1402  5071121 1404  5071135 1403  
331319 5071145 1403  5071155 1403  5071161 1402  5071166 1402  5071174 1403  5071180 1402  
331320 5071180 1402  5071190 1402  5071190 1402  5071188 1403  5071188 1403  5071190 1402  
331321 5071178 1403  5071180 1402  5071175 1402  5071166 1402  5071161 1402  5071155 1403  
331322 5071135 1403  5071131 1403  5071121 1404  5071107 1403  5071088 1403  5071075 1402  
331323 5071064 1404  5071044 1403  5071030 1404  5071011 1403  5070998 1402  5070974 1402  
331324 5070959 1403  5070944 1404  5070930 1403  5070906 1403  5070887 1404  5070873 1403  
331325 5070860 1402  5070844 1404  5070831 1402  5070810 1403  5070796 1404  5070787 1404  
331326 5070782 1404  5070768 1403  5070764 1402  5070753 1403  5070734 1404  5070734 1403  
331327 5070730 1404  5070720 1404  5070720 1403  5070720 1403  5070720 1403  5070720 1403  
331328 5070720 1403  5070729 1403  5070729 1404  5070734 1404  5070736 1402  5070745 1402  
331329 5070753 1404  5070768 1404  5070774 1402  5070788 1402  5070796 1404  5070810 1403  
331330 5070831 1402  5070844 1404  5070854 1403  5070868 1403  5070882 1404  5070897 1403  
331331 5070911 1403  5070930 1403  5070944 1403  5070954 1403  5070963 1403  5070978 1403  
331332 5070997 1404  5071011 1404  5071021 1404  5071030 1403  5071035 1404  5071054 1403  
331333 5071061 1402  5071064 1403  5071073 1404  5071075 1402  5071079 1402  5071078 1403  
331334 5071078 1404  5071089 1402  5071088 1404  5071080 1402  5071078 1403  5071079 1402  
331335 5071073 1404  5071075 1402  5071064 1404  5071065 1402  5071059 1403  5071056 1402  
331336 5071046 1402  5071035 1403  5071032 1402  5071021 1403  5071013 1402  5071008 1402  
331337 5070997 1403  5070989 1402  5070978 1404  5070974 1402  5070960 1402  5070956 1402  
331338 5070956 1402  5070947 1400  5070936 1402  5070933 1400  5070932 1402  5070924 1400  
331339 5070922 1402  5070912 1402  5070914 1400  5070912 1402  5070912 1402  5070914 1400  
331340 5070912 1402  5070911 1403  5070924 1400  5070922 1402  5070932 1402  5070930 1404  
331341 5070936 1402  5070946 1402  5070957 1400  5070960 1402  5070965 1402  5070976 1400  
331342 5070989 1402  5070998 1402  5071013 1402  5071032 1402  5071037 1402  5071048 1400  
331343 5071061 1402  5071076 1400  5071089 1402  5071100 1400  5071110 1400  5071123 1402  
331344 5071132 1402  5071137 1402  5071146 1402  5071158 1400  5071162 1400  5071167 1400  
331345 5071175 1402  5071177 1400  5071181 1400  5071180 1402  5071180 1402  5071180 1402  
331346 5071181 1400  5071181 1400  5071177 1400  5071166 1402  5071166 1402  5071162 1400  
331347 5071156 1402  5071137 1402  5071134 1400  5071124 1400  5071110 1400  5071091 1400  
331348 5071076 1400  5071062 1400  5071046 1402  5071033 1400  5071014 1400  5070998 1402  
331349 5070981 1400  5070962 1400  5070947 1400  5070932 1402  5070914 1400  5070900 1400  
331350 5070876 1400  5070861 1400  5070845 1402  5070831 1402  5070813 1400  5070798 1402  
331351 5070788 1402  5070774 1402  5070771 1400  5070766 1400  5070747 1400  5070736 1402  
331352 5070732 1400  5070732 1400  5070721 1402  5070714 1400  5070714 1400  5070714 1400  
331353 5070722 1402  5070721 1402  5070732 1400  5070731 1402  5070736 1402  5070745 1402  
331354 5070745 1402  5070764 1402  5070769 1402  5070774 1402  5070788 1402  5070798 1402  
331355 5070807 1402  5070823 1400  5070836 1402  5070855 1402  5070869 1402  5070885 1400  
331356 5070898 1402  5070912 1402  5070932 1402  5070946 1402  5070960 1402  5070963 1403  
331357 5070978 1403  5070998 1402  5071013 1402  5071021 1403  5071032 1402  5071046 1402  
331358 5071054 1403  5071059 1403  5071065 1402  5071080 1402  5071079 1402  5071089 1402  
331359 5071099 1402  5071099 1402  5071099 1402  5071097 1403  5071100 1400  5071099 1402  
331360 5071097 1403  5071089 1402  5071089 1402  5071080 1402  5071075 1402  5071067 1400  
331361 5071061 1402  5071048 1400  5071038 1400  5071032 1402  5071024 1400  5071008 1402  
331362 5070998 1402  5070981 1400  5070976 1400  5070966 1400  5070956 1402  5070946 1402  
331363 5070932 1402  5070922 1402  5070914 1400  5070898 1402  5070900 1400  5070889 1402  
331364 5070884 1402  5070874 1402  5070874 1402  5070869 1402  5070860 1402  5070862 1400  
331365 5070860 1402  5070860 1402  5070860 1402  5070860 1402  5070860 1402  5070868 1403  
331366 5070873 1403  5070883 1404  5070887 1403  5070898 1402  5070906 1403  5070922 1402  
331367 5070932 1402  5070946 1402  5070959 1403  5070965 1402  5070979 1402  5070998 1402  
331368 5071013 1402  5071032 1402  5071035 1404  5071054 1404  5071064 1403  5071078 1404  
331369 5071099 1402  5071113 1402  5071123 1402  5071137 1402  5071156 1402  5071159 1404  
331370 5071164 1403  5071175 1402  5071180 1402  5071180 1402  5071188 1403  5071188 1403  
331371 5071197 1403  5071199 1402  5071188 1403  5071188 1404  5071190 1402  5071178 1403  
331372 5071174 1403  5071164 1404  5071159 1404  5071145 1403  5071135 1403  5071123 1402  
331373 5071107 1404  5071088 1403  5071075 1402  5071061 1402  5071046 1402  5071030 1403  
331374 5071008 1402  5070981 1400  5070965 1402  5070946 1402  5070932 1402  5070908 1402  
331375 5070890 1400  5070869 1402  5070855 1402  5070833 1400  5070813 1400  5070799 1400  
331376 5070784 1402  5070769 1402  5070764 1402  5070756 1400  5070736 1402  5070736 1402  
331377 5070731 1402  5070723 1400  5070712 1402  5070707 1402  5070705 1404  5070707 1402  
331378 5070696 1403  5070698 1402  5070705 1404  5070705 1403  5070710 1403  5070720 1403  
331379 5070729 1403  5070736 1402  5070755 1402  5070763 1403  5070774 1402  5070787 1403  
331380 5070807 1402  5070820 1403  5070836 1402  5070858 1404  5070874 1402  5070889 1402  
331381 5070908 1402  5070932 1402  5070944 1403  5070963 1403  5070979 1402  5070997 1403  
331382 5071013 1402  5071032 1402  5071054 1403  5071064 1403  5071075 1402  5071088 1404  
331383 5071099 1402  5071113 1402  5071121 1403  5071131 1403  5071137 1402  5071146 1402  
331384 5071146 1402  5071155 1404  5071156 1402  5071155 1403  5071156 1402  5071156 1402  
331385 5071145 1404  5071137 1402  5071135 1403  5071131 1404  5071121 1403  5071108 1402  
331386 5071099 1402  5071080 1402  5071075 1402  5071059 1403  5071044 1403  5071035 1404  
331387 5071022 1402  5071006 1403  5070989 1402  5070973 1403  5070960 1402  5070946 1402  
331388 5070932 1402  5070912 1402  5070898 1402  5070889 1402  5070874 1402  5070860 1402  
331389 5070855 1402  5070844 1403  5070833 1400  5070822 1402  5070822 1402  5070813 1400  
331390 5070812 1402  5070807 1402  5070807 1402  5070813 1400  5070822 1402  5070831 1402  
331391 5070836 1402  5070845 1402  5070855 1402  5070860 1402  5070871 1400  5070884 1402  
331392 5070889 1402  5070912 1402  5070932 1402  5070946 1402  5070960 1402  5070974 1402  
331393 5070991 1400  5071013 1402  5071033 1400  5071056 1402  5071065 1402  5071089 1402  
331394 5071110 1400  5071123 1402  5071137 1402  5071162 1400  5071166 1402  5071181 1400  
331395 5071201 1400  5071205 1400  5071223 1402  5071234 1400  5071237 1402  5071237 1402  
331396 5071248 1400  5071247 1402  5071247 1402  5071247 1402  5071245 1403  5071237 1402  
331397 5071237 1402  5071223 1402  5071213 1402  5071197 1403  5071190 1402  5071166 1402  
331398 5071155 1403  5071137 1402  5071123 1402  5071108 1402  5071079 1402  5071061 1402  
331399 5071037 1402  5071013 1402  5070998 1402  5070976 1400  5070956 1402  5070932 1402  
331400 5070908 1402  5070884 1402  5070860 1402  5070845 1402  5070822 1402  5070807 1402  
331401 5070785 1400  5070769 1402  5070755 1402  5070736 1402  5070732 1400  5070714 1400  
331402 5070708 1400  5070697 1402  5070697 1402  5070690 1400  5070685 1400  5070683 1402  
331403 5070688 1402  5070688 1402  5070699 1400  5070708 1400  5070714 1400  5070721 1402  
331404 5070736 1402  5070755 1402  5070769 1402  5070784 1402  5070799 1400  5070822 1402  
331405 5070837 1400  5070862 1400  5070884 1402  5070898 1402  5070922 1402  5070947 1400  
331406 5070965 1402  5070981 1400  5071008 1402  5071033 1400  5071057 1400  5071075 1402  
331407 5071099 1402  5071124 1400  5071137 1402  5071156 1402  5071166 1402  5071181 1400  
331408 5071199 1402  5071215 1400  5071223 1402  5071234 1400  5071237 1402  5071237 1402  
331409 5071247 1402  5071247 1402  5071247 1402  5071247 1402  5071237 1402  5071231 1403  
331410 5071223 1402  5071213 1402  5071204 1402  5071190 1402  5071174 1404  5071161 1402  
331411 5071145 1404  5071132 1402  5071107 1404  5071088 1404  5071065 1402  5071045 1404  
331412 5071032 1402  5071006 1404  5070979 1402  5070959 1404  5070935 1403  5070911 1403  
331413 5070897 1404  5070873 1404  5070858 1403  5070834 1403  5070820 1403  5070806 1403  
331414 5070796 1404  5070782 1403  5070772 1404  5070768 1404  5070763 1404  5070763 1403  
331415 5070753 1404  5070753 1403  5070753 1404  5070763 1403  5070768 1404  5070772 1403  
331416 5070782 1403  5070796 1403  5070806 1403  5070820 1403  5070845 1402  5070858 1403  
331417 5070873 1403  5070887 1403  5070911 1403  5070935 1403  5070959 1404  5070978 1403  
331418 5071006 1403  5071030 1403  5071054 1404  5071078 1403  5071107 1403  5071131 1403  
331419 5071155 1403  5071174 1403  5071188 1403  5071212 1403  5071231 1403  5071255 1403  
331420 5071264 1403  5071274 1403  5071288 1403  5071298 1403  5071303 1403  5071312 1403  
331421 5071320 1405  5071320 1405  5071320 1405  5071320 1405  5071312 1403  5071301 1405  
331422 5071301 1405  5071287 1405  5071272 1405  5071255 1409  5071244 1405  5071229 1405  
331423 5071207 1409  5071183 1409  5071163 1405  5071140 1409  5071115 1411  5071093 1409  
331424 5071059 1409  5071040 1409  5071007 1409  5070983 1409  5070954 1409  5070930 1409  
331425 5070906 1409  5070883 1409  5070863 1409  5070839 1409  5070816 1409  5070795 1405  
331426 5070780 1405  5070766 1405  5070739 1409  5070733 1405  5070715 1409  5070704 1405  
331427 5070701 1409  5070692 1409  5070682 1409  5070682 1409  5070681 1411  5070685 1405  
331428 5070695 1405  5070692 1409  5070709 1405  5070725 1409  5070739 1409  5070749 1409  
331429 5070763 1409  5070785 1405  5070804 1405  5070828 1405  5070852 1405  5070866 1405  
331430 5070886 1405  5070921 1404  5070943 1405  5070964 1404  5070997 1403  5071021 1404  
331431 5071043 1405  5071073 1404  5071097 1404  5071129 1405  5071153 1405  5071172 1405  
331432 5071201 1405  5071220 1405  5071244 1405  5071258 1405  5071272 1405  5071287 1405  
331433 5071301 1405  5071311 1405  5071322 1404  5071320 1405  5071325 1405  5071325 1405  
331434 5071320 1405  5071320 1405  5071311 1405  5071301 1405  5071296 1405  5071287 1405  
331435 5071273 1405  5071258 1405  5071234 1405  5071220 1405  5071196 1405  5071163 1405  
331436 5071143 1405  5071120 1405  5071086 1405  5071057 1405  5071034 1405  5071002 1409  
331437 5070971 1405  5070943 1405  5070909 1405  5070881 1405  5070857 1405  5070828 1405  
331438 5070806 1403  5070780 1405  5070763 1404  5070742 1405  5070720 1404  5070705 1403  
331439 5070686 1403  5070682 1403  5070667 1403  5070663 1404  5070653 1403  5070653 1404  
331440 5070653 1403  5070653 1404  5070663 1403  5070667 1403  5070672 1403  5070682 1404  
331441 5070696 1404  5070710 1404  5070734 1404  5070763 1404  5070782 1403  5070806 1403  
331442 5070830 1404  5070854 1404  5070873 1403  5070906 1403  5070930 1403  5070959 1403  
331443 5070997 1404  5071021 1403  5071054 1403  5071078 1404  5071111 1404  5071145 1404  
331444 5071164 1404  5071198 1404  5071222 1404  5071245 1403  5071260 1403  5071279 1403  
331445 5071298 1404  5071312 1404  5071327 1404  5071336 1404  5071345 1404  5071355 1404  
331446 5071355 1404  5071360 1403  5071360 1404  5071353 1405  5071344 1405  5071334 1405  
331447 5071320 1405  5071301 1405  5071286 1405  5071272 1405  5071255 1404  5071230 1405  
331448 5071198 1409  5071177 1405  5071153 1405  5071120 1405  5071096 1405  5071062 1405  
331449 5071034 1405  5071006 1404  5070973 1404  5070953 1405  5070919 1405  5070886 1405  
331450 5070858 1403  5070833 1405  5070811 1404  5070785 1405  5070761 1405  5070734 1404  
331451 5070720 1404  5070704 1405  5070685 1405  5070680 1405  5070667 1404  5070661 1405  
331452 5070653 1403  5070653 1404  5070653 1403  5070653 1404  5070663 1404  5070667 1404  
331453 5070672 1404  5070682 1404  5070696 1404  5070710 1404  5070729 1403  5070753 1403  
331454 5070772 1403  5070796 1403  5070820 1403  5070844 1403  5070873 1403  5070908 1402  
331455 5070935 1404  5070959 1403  5070989 1402  5071022 1402  5071056 1402  5071080 1402  
331456 5071121 1404  5071146 1402  5071174 1404  5071202 1403  5071232 1402  5071256 1402  
331457 5071274 1404  5071290 1402  5071314 1402  5071328 1402  5071337 1402  5071357 1402  
331458 5071361 1402  5071366 1402  5071366 1402  5071366 1402  5071365 1404  5071366 1402  
331459 5071362 1402  5071357 1402  5071336 1403  5071328 1402  5071304 1402  5071290 1402  
331460 5071264 1403  5071237 1402  5071213 1402  5071180 1402  5071156 1402  5071113 1402  
331461 5071080 1402  5071046 1402  5071013 1402  5070973 1403  5070946 1402  5070908 1402  
331462 5070869 1402  5070836 1402  5070798 1402  5070771 1400  5070736 1402  5070705 1403  
331463 5070683 1402  5070655 1402  5070631 1402  5070607 1402  5070588 1402  5070568 1402  
331464 5070554 1402  5070545 1402  5070540 1402  5070532 1400  5070530 1402  5070530 1402  
331465 5070532 1400  5070541 1400  5070546 1400  5070567 1398  5070575 1400  5070600 1398  
331466 5070624 1398  5070648 1398  5070672 1398  5070693 1396  5070726 1396  5070759 1396  
331467 5070788 1396  5070817 1396  5070861 1394  5070890 1394  5070917 1396  5070962 1394  
331468 5070995 1394  5071039 1392  5071068 1392  5071105 1394  5071140 1392  5071168 1392  
331469 5071199 1390  5071232 1390  5071256 1390  5071284 1390  5071308 1390  5071323 1390  
331470 5071347 1390  5071366 1390  5071375 1390  5071385 1390  5071390 1390  5071391 1388  
331471 5071391 1388  5071391 1388  5071386 1388  5071377 1388  5071370 1390  5071358 1388  
331472 5071339 1388  5071313 1390  5071299 1390  5071277 1388  5071258 1388  5071224 1388  
331473 5071200 1388  5071171 1388  5071133 1388  5071098 1390  5071071 1388  5071042 1388  
331474 5071001 1387  5070972 1387  5070944 1387  5070910 1387  5070872 1387  5070848 1387  
331475 5070820 1387  5070786 1387  5070767 1387  5070734 1387  5070710 1387  5070697 1385  
331476 5070681 1387  5070668 1385  5070654 1385  5070644 1385  5070633 1387  5070636 1383  
331477 5070635 1385  5070635 1385  5070635 1385  5070644 1385  5070654 1385  5070670 1383  
331478 5070684 1383  5070698 1383  5070722 1383  5070748 1381  5070772 1381  5070791 1381  
331479 5070824 1381  5070853 1381  5070877 1381  5070905 1381  5070948 1381  5070977 1381  
331480 5071006 1381  5071050 1379  5071077 1381  5071106 1381  5071139 1381  5071173 1381  
331481 5071206 1381  5071240 1381  5071273 1381  5071292 1381  5071316 1381  5071340 1381  
331482 5071364 1381  5071378 1381  5071383 1381  5071397 1381  5071407 1381  5071416 1381  
331483 5071416 1381  5071416 1381  5071416 1381  5071407 1381  5071397 1381  5071383 1381  
331484 5071373 1381  5071354 1381  5071331 1381  5071297 1381  5071278 1381  5071240 1381  
331485 5071216 1381  5071178 1381  5071150 1379  5071108 1379  5071072 1381  5071030 1381  
331486 5070993 1379  5070953 1381  5070915 1381  5070877 1381  5070838 1381  5070800 1381  
331487 5070753 1381  5070714 1381  5070686 1381  5070648 1381  5070604 1381  5070581 1381  
331488 5070557 1381  5070523 1381  5070499 1381  5070485 1381  5070461 1381  5070456 1381  
331489 5070437 1381  5070432 1381  5070433 1381  5070425 1379  5070425 1379  5070433 1381  
331490 5070437 1381  5070449 1379  5070461 1381  5070485 1381  5070499 1381  5070528 1381  
331491 5070557 1381  5070586 1381  5070614 1381  5070648 1381  5070681 1381  5070714 1381  
331492 5070753 1381  5070792 1379  5070830 1379  5070873 1379  5070907 1379  5070950 1379  
331493 5070982 1381  5071025 1381  5071063 1381  5071096 1381  5071139 1381  5071173 1381  
331494 5071197 1381  5071240 1381  5071264 1381  5071282 1381  5071306 1381  5071331 1381  
331495 5071345 1381  5071364 1381  5071364 1381  5071378 1381  5071377 1383  5071377 1383  
331496 5071378 1381  5071372 1383  5071364 1381  5071345 1381  5071338 1383  5071321 1381  
331497 5071297 1381  5071283 1381  5071254 1381  5071230 1381  5071197 1381  5071173 1381  
331498 5071139 1381  5071106 1381  5071072 1381  5071039 1381  5070996 1381  5070972 1381  
331499 5070929 1381  5070901 1381  5070872 1381  5070838 1381  5070805 1381  5070781 1381  
331500 5070748 1381  5070724 1381  5070700 1381  5070686 1381  5070662 1381  5070648 1381  
331501 5070628 1381  5070614 1381  5070604 1381  5070604 1381  5070600 1381  5070600 1381  
331502 5070604 1381  5070604 1381  5070624 1381  5070628 1381  5070648 1381  5070671 1381  
331503 5070686 1381  5070705 1381  5070738 1381  5070762 1381  5070786 1381  5070826 1379  
331504 5070853 1381  5070887 1381  5070925 1381  5070953 1381  5070991 1381  5071025 1381  
331505 5071063 1381  5071092 1381  5071130 1381  5071163 1381  5071192 1381  5071230 1381  
331506 5071264 1381  5071292 1381  5071316 1381  5071340 1381  5071364 1381  5071383 1381  
331507 5071396 1383  5071416 1381  5071421 1381  5071429 1383  5071439 1383  5071439 1383  
331508 5071439 1383  5071429 1383  5071419 1383  5071405 1383  5071390 1385  5071375 1385  
331509 5071351 1385  5071318 1385  5071294 1385  5071261 1385  5071227 1385  5071192 1387  
331510 5071159 1387  5071121 1387  5071077 1387  5071036 1385  5070993 1385  5070950 1385  
331511 5070902 1385  5070867 1387  5070821 1385  5070783 1385  5070735 1385  5070699 1383  
331512 5070656 1383  5070621 1385  5070582 1385  5070544 1385  5070510 1385  5070484 1383  
331513 5070454 1385  5070431 1383  5070402 1383  5070391 1385  5070383 1383  5070367 1385  
331514 5070359 1383  5070355 1383  5070353 1385  5070355 1383  5070359 1383  5070370 1381  
331515 5070383 1383  5070398 1383  5070421 1383  5070445 1383  5070469 1383  5070498 1383  
331516 5070525 1385  5070558 1385  5070587 1385  5070624 1387  5070668 1385  5070710 1387  
331517 5070748 1387  5070788 1385  5070834 1387  5070872 1387  5070909 1388  5070957 1388  
331518 5070990 1388  5071033 1388  5071071 1388  5071109 1388  5071147 1388  5071176 1388  
331519 5071210 1388  5071241 1390  5071270 1390  5071283 1392  5071307 1392  5071323 1390  
331520 5071334 1394  5071353 1394  5071363 1394  5071364 1392  5071368 1394  5071361 1396  
331521 5071361 1396  5071350 1398  5071331 1398  5071328 1396  5071309 1396  5071285 1396  
331522 5071270 1396  5071240 1398  5071216 1398  5071193 1398  5071162 1400  5071135 1398  
331523 5071100 1400  5071068 1398  5071033 1400  5071000 1400  5070968 1398  5070935 1398  
331524 5070900 1400  5070872 1398  5070837 1400  5070815 1398  5070787 1398  5070758 1398  
331525 5070735 1396  5070712 1396  5070694 1394  5070673 1396  5070659 1396  5070651 1394  
331526 5070647 1394  5070637 1394  5070637 1394  5070637 1394  5070637 1394  5070638 1392  
331527 5070648 1392  5070662 1392  5070676 1392  5070691 1392  5070715 1392  5070731 1390  
331528 5070764 1390  5070783 1390  5070817 1390  5070845 1390  5070878 1390  5070917 1390  
331529 5070947 1389  5070976 1388  5071017 1390  5071047 1388  5071086 1388  5071121 1387  
331530 5071160 1385  5071188 1387  5071217 1385  5071251 1385  5071291 1383  5071313 1385  
331531 5071343 1383  5071375 1385  5071391 1383  5071413 1385  5071428 1385  5071442 1385  
331532 5071453 1383  5071466 1385  5071466 1385  5071466 1385  5071466 1385  5071461 1385  
331533 5071451 1385  5071440 1387  5071426 1387  5071402 1387  5071388 1387  5071359 1387  
331534 5071335 1387  5071313 1385  5071278 1387  5071245 1387  5071202 1387  5071175 1385  
331535 5071136 1385  5071094 1385  5071050 1385  5071012 1385  5070974 1385  5070926 1385  
331536 5070883 1385  5070834 1387  5070797 1385  5070759 1385  5070711 1385  5070679 1383  
331537 5070635 1385  5070598 1383  5070570 1383  5070536 1383  5070503 1383  5070479 1383  
331538 5070455 1383  5070431 1383  5070412 1383  5070398 1383  5070394 1381  5070383 1383  
331539 5070380 1381  5070379 1383  5070380 1381  5070385 1381  5070394 1381  5070404 1381  
331540 5070423 1381  5070437 1381  5070461 1381  5070487 1379  5070506 1379  5070539 1379  
331541 5070566 1375  5070604 1375  5070630 1379  5070673 1379  5070709 1375  5070753 1375  
331542 5070791 1375  5070830 1373  5070867 1375  5070910 1375  5070953 1375  5070988 1373  
331543 5071031 1373  5071068 1375  5071101 1375  5071136 1373  5071168 1375  5071197 1375  
331544 5071227 1373  5071256 1373  5071279 1373  5071297 1375  5071311 1375  5071326 1375  
331545 5071335 1375  5071349 1375  5071351 1373  5071351 1373  5071349 1375  5071349 1375  
331546 5071345 1375  5071326 1375  5071320 1375  5071302 1375  5071282 1375  5071268 1375  
331547 5071244 1375  5071217 1379  5071187 1375  5071168 1375  5071134 1375  5071098 1379  
331548 5071077 1375  5071041 1379  5071020 1375  5070987 1375  5070958 1375  5070929 1375  
331549 5070893 1379  5070867 1375  5070843 1375  5070810 1375  5070788 1379  5070768 1373  
331550 5070752 1375  5070729 1375  5070709 1375  5070695 1375  5070690 1375  5070686 1375  
331551 5070677 1373  5070676 1375  5070677 1373  5070687 1373  5070687 1373  5070692 1373  
331552 5070706 1373  5070711 1373  5070730 1373  5070756 1372  5070779 1372  5070792 1373  
331553 5070821 1373  5070844 1373  5070869 1373  5070899 1372  5070931 1373  5070959 1373  
331554 5070988 1373  5071032 1372  5071061 1372  5071088 1373  5071122 1373  5071157 1371  
331555 5071189 1373  5071224 1372  5071257 1372  5071284 1373  5071305 1372  5071338 1372  
331556 5071362 1372  5071384 1373  5071400 1372  5071414 1372  5071423 1373  5071438 1372  
331557 5071437 1373  5071446 1373  5071446 1373  5071437 1373  5071437 1373  5071427 1373  
331558 5071413 1373  5071397 1375  5071384 1373  5071360 1373  5071344 1375  5071311 1375  
331559 5071289 1373  5071260 1373  5071227 1373  5071189 1373  5071160 1373  5071122 1373  
331560 5071083 1373  5071044 1375  5070998 1373  5070959 1373  5070921 1373  5070883 1373  
331561 5070835 1373  5070797 1373  5070759 1373  5070721 1373  5070687 1373  5070644 1373  
331562 5070609 1375  5070585 1375  5070553 1373  5070520 1373  5070496 1373  5070477 1373  
331563 5070463 1373  5070442 1375  5070429 1373  5070410 1373  5070405 1373  5070405 1373  
331564 5070405 1373  5070405 1373  5070405 1373  5070408 1375  5070429 1373  5070439 1373  
331565 5070463 1373  5070467 1373  5070491 1373  5070509 1375  5070544 1373  5070568 1373  
331566 5070596 1373  5070628 1375  5070662 1375  5070692 1373  5070728 1375  5070767 1375  
331567 5070806 1373  5070835 1373  5070876 1375  5070910 1375  5070943 1375  5070981 1375  
331568 5071012 1373  5071050 1379  5071082 1375  5071111 1375  5071144 1375  5071169 1373  
331569 5071187 1375  5071211 1375  5071225 1375  5071255 1373  5071260 1373  5071278 1375  
331570 5071284 1373  5071284 1373  5071284 1373  5071284 1373  5071284 1373  5071279 1373  
331571 5071270 1373  5071260 1373  5071246 1373  5071236 1373  5071212 1373  5071198 1373  
331572 5071180 1372  5071160 1373  5071136 1373  5071112 1373  5071083 1373  5071060 1373  
331573 5071031 1373  5071004 1372  5070983 1373  5070954 1373  5070932 1371  5070907 1373  
331574 5070883 1373  5070859 1373  5070835 1373  5070811 1373  5070797 1373  5070787 1373  
331575 5070767 1375  5070760 1372  5070744 1373  5070735 1373  5070735 1373  5070730 1373  
331576 5070735 1373  5070735 1373  5070735 1373  5070735 1373  5070754 1373  5070759 1373  
331577 5070768 1373  5070787 1373  5070806 1373  5070821 1373  5070844 1373  5070859 1373  
331578 5070883 1373  5070911 1373  5070935 1373  5070967 1375  5070988 1373  5071031 1373  
331579 5071058 1375  5071087 1375  5071110 1375  5071144 1375  5071177 1375  5071193 1379  
331580 5071225 1375  5071254 1375  5071282 1375  5071302 1375  5071325 1375  5071344 1375  
331581 5071365 1379  5071380 1379  5071387 1375  5071402 1375  5071411 1375  5071411 1375  
331582 5071418 1379  5071418 1379  5071421 1375  5071411 1375  5071399 1379  5071394 1379  
331583 5071380 1379  5071365 1379  5071346 1379  5071326 1375  5071299 1379  5071279 1379  
331584 5071251 1379  5071217 1379  5071184 1379  5071165 1379  5071130 1375  5071093 1379  
331585 5071055 1379  5071020 1375  5070983 1379  5070958 1375  5070917 1379  5070881 1375  
331586 5070850 1379  5070807 1379  5070786 1375  5070752 1375  5070719 1375  5070687 1379  
331587 5070659 1379  5070630 1379  5070606 1379  5070587 1379  5070563 1379  5070552 1375  
331588 5070530 1379  5070515 1379  5070506 1379  5070501 1379  5070490 1381  5070487 1379  
331589 5070490 1375  5070491 1379  5070491 1379  5070501 1379  5070506 1379  5070525 1379  
331590 5070539 1379  5070558 1379  5070576 1375  5070592 1379  5070619 1375  5070633 1375  
331591 5070666 1375  5070690 1375  5070709 1375  5070743 1375  5070776 1375  5070805 1375  
331592 5070834 1375  5070864 1379  5070896 1375  5070929 1375  5070959 1373  5070987 1375  
331593 5071022 1373  5071044 1375  5071079 1373  5071098 1373  5071122 1373  5071134 1375  
331594 5071160 1373  5071177 1375  5071189 1373  5071198 1373  5071201 1375  5071212 1373  
331595 5071222 1373  5071222 1373  5071221 1375  5071222 1373  5071212 1373  5071212 1373  
331596 5071201 1375  5071197 1375  5071187 1375  5071177 1375  5071158 1375  5071144 1375  
331597 5071120 1375  5071101 1375  5071087 1375  5071068 1375  5071043 1375  5071017 1379  
331598 5071001 1375  5070978 1379  5070955 1379  5070934 1375  5070910 1375  5070896 1375  
331599 5070881 1375  5070858 1375  5070840 1379  5070829 1375  5070809 1375  5070805 1375  
331600 5070791 1375  5070786 1375  5070776 1375  5070776 1375  5070767 1375  5070767 1375  
331601 5070767 1375  5070767 1375  5070776 1375  5070776 1375  5070791 1375  5070792 1373  
331602 5070805 1375  5070821 1373  5070834 1375  5070854 1373  5070876 1375  5070891 1375  
331603 5070910 1375  5070929 1375  5070955 1373  5070978 1373  5070996 1375  5071022 1373  
331604 5071044 1375  5071068 1375  5071087 1375  5071112 1373  5071136 1373  5071160 1373  
331605 5071182 1375  5071197 1375  5071220 1375  5071235 1375  5071256 1373  5071270 1373  
331606 5071284 1373  5071299 1373  5071302 1375  5071311 1375  5071321 1375  5071321 1375  
331607 5071321 1375  5071322 1373  5071320 1375  5071311 1375  5071302 1375  5071298 1373  
331608 5071287 1375  5071278 1375  5071256 1379  5071244 1375  5071221 1375  5071201 1375  
331609 5071182 1375  5071159 1375  5071127 1379  5071101 1375  5071077 1375  5071050 1379  
331610 5071020 1375  5070987 1375  5070955 1379  5070926 1379  5070896 1375  5070873 1379  
331611 5070838 1381  5070805 1381  5070788 1379  5070753 1381  5070730 1379  5070700 1381  
331612 5070683 1379  5070659 1379  5070639 1379  5070616 1379  5070601 1379  5070587 1379  
331613 5070572 1379  5070563 1379  5070549 1379  5070542 1375  5070542 1375  5070534 1373  
331614 5070529 1373  5070531 1372  5070534 1373  5070536 1372  5070545 1371  5070555 1371  
331615 5070564 1372  5070580 1370  5070593 1372  5070609 1370  5070623 1370  5070645 1372  
331616 5070666 1370  5070689 1372  5070709 1370  5070733 1370  5070757 1370  5070789 1371  
331617 5070808 1372  5070832 1372  5070861 1372  5070886 1370  5070910 1370  5070937 1372  
331618 5070961 1372  5070986 1370  5071001 1370  5071023 1372  5071048 1370  5071061 1372  
331619 5071082 1370  5071091 1370  5071106 1370  5071115 1370  5071123 1372  5071134 1370  
331620 5071139 1370  5071139 1370  5071148 1370  5071149 1370  5071139 1370  5071139 1370  
331621 5071134 1370  5071125 1370  5071115 1370  5071106 1370  5071091 1370  5071087 1370  
331622 5071074 1368  5071059 1368  5071040 1368  5071026 1368  5071004 1366  5070988 1368  
331623 5070973 1368  5070959 1368  5070940 1368  5070918 1366  5070903 1366  5070898 1366  
331624 5070886 1364  5070867 1364  5070851 1366  5070838 1364  5070828 1364  5070819 1364  
331625 5070807 1360  5070804 1364  5070800 1364  5070798 1360  5070798 1360  5070798 1360  
331626 5070798 1360  5070800 1358  5070800 1358  5070806 1356  5070811 1356  5070819 1358  
331627 5070824 1358  5070835 1356  5070849 1356  5070858 1356  5070873 1356  5070892 1356  
331628 5070906 1356  5070921 1356  5070944 1356  5070959 1356  5070983 1357  5070997 1356  
331629 5071011 1356  5071035 1356  5071049 1356  5071073 1357  5071093 1356  5071102 1356  
331630 5071126 1356  5071146 1355  5071159 1356  5071174 1356  5071193 1356  5071202 1357  
331631 5071212 1356  5071228 1355  5071236 1356  5071240 1356  5071240 1356  5071250 1356  
331632 5071250 1357  5071250 1357  5071250 1357  5071240 1356  5071241 1357  5071237 1355  
331633 5071228 1355  5071218 1355  5071202 1356  5071193 1356  5071175 1355  5071169 1356  
331634 5071146 1355  5071126 1356  5071102 1356  5071083 1356  5071070 1355  5071045 1356  
331635 5071016 1356  5070997 1356  5070973 1356  5070951 1355  5070925 1356  5070897 1356  
331636 5070873 1356  5070849 1356  5070825 1356  5070806 1356  5070782 1356  5070758 1356  
331637 5070744 1356  5070722 1355  5070705 1356  5070691 1356  5070678 1355  5070669 1355  
331638 5070650 1355  5070645 1355  5070626 1355  5070620 1356  5070611 1355  5070605 1356  
331639 5070607 1355  5070607 1355  5070607 1355  5070607 1355  5070611 1355  5070621 1355  
331640 5070621 1355  5070635 1355  5070645 1355  5070650 1355  5070669 1355  5070683 1355  
331641 5070702 1355  5070721 1355  5070736 1355  5070750 1355  5070774 1355  5070803 1355  
331642 5070812 1355  5070836 1355  5070860 1355  5070884 1355  5070898 1355  5070922 1355  
331643 5070946 1355  5070960 1355  5070984 1355  5070998 1355  5071013 1355  5071027 1355  
331644 5071046 1355  5071061 1355  5071075 1355  5071085 1355  5071094 1355  5071104 1355  
331645 5071104 1355  5071104 1355  5071113 1355  5071113 1355  5071118 1355  5071113 1355  
331646 5071113 1355  5071104 1355  5071104 1355  5071094 1355  5071094 1355  5071075 1355  
331647 5071070 1355  5071051 1355  5071046 1355  5071027 1355  5071018 1355  5071003 1355  
331648 5070994 1355  5070975 1355  5070960 1355  5070946 1355  5070927 1355  5070922 1355  
331649 5070908 1355  5070893 1355  5070884 1355  5070874 1355  5070860 1355  5070851 1355  
331650 5070845 1355  5070836 1355  5070826 1355  5070827 1355  5070827 1355  5070822 1355  
331651 5070822 1355  5070822 1355  5070822 1355  5070822 1355  5070822 1355  5070827 1355  
331652 5070827 1355  5070836 1355  5070850 1355  5070860 1355  5070869 1355  5070874 1355  
331653 5070893 1355  5070908 1355  5070912 1355  5070927 1355  5070946 1355  5070960 1355  
331654 5070975 1355  5070994 1355  5071002 1356  5071018 1355  5071037 1355  5071051 1355  
331655 5071070 1355  5071085 1355  5071099 1355  5071113 1355  5071118 1355  5071137 1355  
331656 5071151 1355  5071161 1355  5071170 1355  5071175 1355  5071185 1355  5071196 1353  
331657 5071199 1355  5071200 1353  5071199 1355  5071199 1355  5071201 1353  5071196 1353  
331658 5071196 1353  5071186 1353  5071175 1355  5071172 1353  5071162 1353  5071148 1353  
331659 5071138 1353  5071120 1353  5071105 1353  5071096 1353  5071075 1355  5071053 1353  
331660 5071038 1353  5071014 1353  5070998 1355  5070976 1353  5070952 1353  5070939 1351  
331661 5070914 1353  5070898 1355  5070877 1351  5070852 1353  5070830 1351  5070814 1353  
331662 5070795 1353  5070777 1351  5070761 1353  5070747 1353  5070728 1353  5070715 1351  
331663 5070705 1351  5070685 1353  5070682 1351  5070672 1351  5070662 1351  5070661 1353  
331664 5070651 1353  5070653 1351  5070651 1353  5070653 1351  5070653 1351  5070661 1353  
331665 5070672 1351  5070672 1351  5070680 1353  5070686 1351  5070705 1351  5070710 1351  
331666 5070725 1351  5070737 1353  5070753 1351  5070772 1351  5070787 1351  5070809 1353  
331667 5070825 1351  5070847 1353  5070861 1353  5070886 1353  5070900 1353  5070924 1353  
331668 5070947 1353  5070963 1351  5070986 1353  5071000 1353  5071014 1353  5071030 1351  
331669 5071049 1351  5071053 1353  5071072 1353  5071076 1353  5071086 1353  5071100 1353  
331670 5071107 1351  5071115 1353  5071115 1353  5071120 1353  5071120 1353  5071120 1353  
331671 5071116 1351  5071115 1353  5071105 1353  5071106 1351  5071100 1353  5071097 1351  
331672 5071076 1353  5071072 1353  5071054 1351  5071049 1351  5071030 1351  5071014 1353  
331673 5071005 1353  5070997 1351  5070978 1351  5070973 1351  5070954 1351  5070938 1353  
331674 5070930 1351  5070914 1353  5070901 1351  5070896 1351  5070877 1351  5070877 1351  
331675 5070862 1353  5070852 1353  5070847 1353  5070847 1353  5070838 1353  5070828 1353  
331676 5070822 1355  5070823 1353  5070823 1353  5070814 1353  5070814 1353  5070814 1353  
331677 5070823 1353  5070823 1353  5070828 1353  5070838 1353  5070845 1355  5070852 1353  
331678 5070862 1353  5070871 1353  5070885 1353  5070895 1353  5070911 1351  5070915 1351  
331679 5070928 1353  5070946 1355  5070962 1353  5070976 1353  5070995 1353  5071005 1353  
331680 5071019 1353  5071038 1353  5071054 1351  5071072 1353  5071076 1353  5071096 1353  
331681 5071105 1353  5071120 1353  5071129 1353  5071148 1353  5071151 1355  5071162 1353  
331682 5071170 1355  5071177 1353  5071175 1355  5071177 1353  5071185 1355  5071185 1355  
331683 5071186 1353  5071185 1355  5071175 1355  5071172 1353  5071162 1353  5071155 1351  
331684 5071148 1353  5071127 1355  5071118 1355  5071105 1353  5071096 1353  5071086 1353  
331685 5071062 1353  5071048 1353  5071029 1353  5071014 1353  5071000 1353  5070976 1353  
331686 5070952 1353  5070938 1353  5070924 1353  5070900 1353  5070884 1355  5070861 1353  
331687 5070845 1355  5070828 1353  5070814 1353  5070795 1353  5070785 1353  5070771 1353  
331688 5070752 1353  5070747 1353  5070737 1353  5070723 1353  5070721 1355  5070713 1353  
331689 5070709 1353  5070709 1353  5070707 1355  5070707 1355  5070707 1355  5070708 1353  
331690 5070708 1353  5070714 1353  5070723 1353  5070726 1355  5070737 1353  5070747 1353  
331691 5070750 1355  5070771 1353  5070785 1353  5070803 1355  5070823 1353  5070837 1353  
331692 5070862 1353  5070876 1353  5070900 1353  5070914 1353  5070928 1353  5070952 1353  
331693 5070971 1353  5070995 1353  5071003 1355  5071030 1351  5071048 1353  5071062 1353  
331694 5071076 1353  5071086 1353  5071099 1355  5071114 1353  5071120 1353  5071129 1353  
331695 5071138 1353  5071148 1353  5071153 1353  5071151 1355  5071153 1353  5071151 1355  
331696 5071148 1353  5071148 1353  5071148 1353  5071138 1353  5071120 1353  5071113 1355  
331697 5071107 1351  5071099 1355  5071086 1353  5071076 1353  5071062 1353  5071053 1353  
331698 5071037 1355  5071030 1351  5071014 1353  5071001 1351  5070986 1353  5070971 1353  
331699 5070962 1353  5070947 1353  5070928 1353  5070912 1355  5070900 1353  5070885 1353  
331700 5070871 1353  5070860 1355  5070847 1353  5070836 1355  5070827 1355  5070823 1353  
331701 5070807 1355  5070809 1353  5070802 1355  5070793 1355  5070795 1353  5070795 1353  
331702 5070795 1353  5070793 1355  5070795 1353  5070804 1353  5070809 1353  5070814 1353  
331703 5070825 1351  5070828 1353  5070838 1353  5070846 1355  5070862 1353  5070876 1353  
331704 5070887 1351  5070900 1353  5070914 1353  5070930 1351  5070947 1353  5070971 1353  
331705 5070976 1353  5070997 1351  5071006 1351  5071019 1353  5071049 1351  5071053 1353  
331706 5071073 1351  5071088 1351  5071100 1353  5071105 1353  5071121 1351  5071129 1353  
331707 5071140 1351  5071148 1353  5071153 1353  5071162 1353  5071164 1351  5071162 1353  
331708 5071172 1353  5071173 1351  5071164 1351  5071164 1351  5071155 1351  5071149 1351  
331709 5071140 1351  5071121 1351  5071121 1351  5071107 1351  5071097 1351  5071078 1351  
331710 5071064 1351  5071049 1351  5071030 1351  5071016 1351  5071002 1351  5070977 1351  
331711 5070966 1347  5070939 1351  5070928 1347  5070904 1347  5070887 1351  5070863 1351  
331712 5070852 1347  5070830 1351  5070810 1351  5070799 1347  5070780 1347  5070766 1347  
331713 5070752 1347  5070742 1347  5070729 1351  5070715 1351  5070710 1351  5070708 1347  
331714 5070705 1351  5070699 1347  5070696 1351  5070686 1351  5070696 1351  5070696 1351  
331715 5070705 1351  5070705 1351  5070713 1353  5070725 1351  5070732 1347  5070748 1351  
331716 5070763 1351  5070777 1351  5070796 1351  5070810 1351  5070825 1351  5070839 1351  
331717 5070863 1351  5070877 1351  5070901 1351  5070925 1351  5070938 1353  5070963 1351  
331718 5070977 1351  5071002 1351  5071014 1353  5071030 1351  5071049 1351  5071062 1353  
331719 5071076 1353  5071096 1353  5071107 1351  5071115 1353  5071120 1353  5071130 1351  
331720 5071138 1353  5071138 1353  5071148 1353  5071149 1351  5071149 1351  5071148 1353  
331721 5071138 1353  5071140 1351  5071131 1351  5071121 1351  5071116 1351  5071106 1351  
331722 5071097 1351  5071088 1351  5071073 1351  5071057 1347  5071040 1351  5071021 1351  
331723 5071009 1347  5070997 1351  5070981 1347  5070954 1351  5070939 1351  5070928 1347  
331724 5070914 1347  5070900 1347  5070873 1351  5070866 1347  5070839 1351  5070825 1351  
331725 5070810 1351  5070799 1347  5070790 1347  5070780 1347  5070772 1351  5070763 1351  
331726 5070749 1351  5070749 1351  5070739 1351  5070737 1353  5070737 1353  5070737 1353  
331727 5070729 1351  5070739 1351  5070752 1347  5070753 1351  5070763 1351  5070771 1353  
331728 5070777 1351  5070796 1351  5070806 1351  5070814 1353  5070830 1351  5070849 1351  
331729 5070863 1351  5070877 1351  5070895 1353  5070911 1351  5070928 1353  5070949 1351  
331730 5070973 1351  5070987 1351  5071001 1351  5071021 1351  5071038 1353  5071064 1351  
331731 5071078 1351  5071097 1351  5071107 1351  5071120 1353  5071140 1351  5071148 1353  
331732 5071162 1353  5071172 1353  5071178 1351  5071178 1351  5071186 1353  5071188 1351  
331733 5071197 1351  5071188 1351  5071188 1351  5071188 1351  5071178 1351  5071173 1351  
331734 5071164 1351  5071155 1351  5071140 1351  5071131 1351  5071119 1347  5071102 1351  
331735 5071081 1347  5071067 1347  5071053 1347  5071030 1351  5071009 1347  5071000 1347  
331736 5070976 1347  5070954 1351  5070933 1347  5070915 1351  5070897 1351  5070877 1351  
331737 5070863 1351  5070849 1351  5070825 1351  5070810 1351  5070796 1351  5070777 1351  
331738 5070771 1353  5070753 1351  5070753 1351  5070747 1353  5070737 1353  5070728 1353  
331739 5070729 1351  5070729 1351  5070729 1351  5070729 1351  5070728 1353  5070739 1351  
331740 5070749 1351  5070753 1351  5070771 1353  5070777 1351  5070796 1351  5070810 1351  
331741 5070830 1351  5070849 1351  5070863 1351  5070880 1347  5070901 1351  5070915 1351  
331742 5070939 1351  5070954 1351  5070980 1347  5071002 1351  5071021 1351  5071040 1351  
331743 5071064 1351  5071088 1351  5071107 1351  5071121 1351  5071143 1347  5071154 1351  
331744 5071173 1351  5071188 1351  5071197 1351  5071202 1351  5071207 1351  5071216 1351  
331745 5071221 1351  5071221 1351  5071234 1347  5071234 1347  5071224 1347  5071224 1347  
331746 5071220 1347  5071207 1351  5071205 1347  5071191 1347  5071181 1347  5071167 1347  
331747 5071158 1347  5071145 1345  5071119 1347  5071105 1347  5071092 1345  5071067 1347  
331748 5071053 1347  5071025 1345  5071005 1347  5070982 1345  5070958 1345  5070933 1347  
331749 5070919 1347  5070900 1347  5070876 1347  5070858 1345  5070842 1347  5070828 1347  
331750 5070813 1347  5070801 1345  5070782 1345  5070766 1347  5070756 1347  5070753 1345  
331751 5070742 1347  5070732 1347  5070728 1347  5070728 1347  5070729 1345  5070728 1347  
331752 5070728 1347  5070732 1347  5070742 1347  5070752 1347  5070756 1347  5070775 1347  
331753 5070790 1347  5070799 1347  5070813 1347  5070825 1351  5070852 1347  5070863 1351  
331754 5070880 1347  5070901 1351  5070925 1351  5070949 1351  5070963 1351  5070987 1351  
331755 5071005 1353  5071030 1351  5071054 1351  5071078 1351  5071097 1351  5071114 1353  
331756 5071131 1351  5071149 1351  5071164 1351  5071178 1351  5071197 1351  5071207 1351  
331757 5071215 1353  5071221 1351  5071231 1351  5071231 1351  5071234 1347  5071234 1347  
331758 5071234 1347  5071231 1351  5071224 1347  5071220 1347  5071211 1345  5071205 1347  
331759 5071192 1345  5071179 1343  5071169 1345  5071156 1343  5071126 1345  5071113 1343  
331760 5071094 1343  5071079 1343  5071063 1340  5071030 1340  5071011 1340  5070996 1340  
331761 5070974 1338  5070952 1336  5070926 1338  5070907 1338  5070885 1336  5070866 1336  
331762 5070840 1338  5070826 1338  5070818 1336  5070797 1338  5070785 1336  5070773 1338  
331763 5070759 1338  5070750 1338  5070740 1338  5070740 1338  5070737 1336  5070735 1338  
331764 5070737 1336  5070741 1336  5070740 1338  5070750 1338  5070750 1338  5070764 1338  
331765 5070778 1332  5070789 1336  5070808 1336  5070823 1336  5070837 1336  5070852 1336  
331766 5070866 1336  5070888 1332  5070909 1336  5070923 1336  5070945 1332  5070964 1338  
331767 5070990 1336  5071014 1336  5071031 1332  5071052 1336  5071074 1338  5071100 1336  
331768 5071114 1336  5071133 1336  5071152 1336  5071165 1338  5071184 1338  5071200 1336  
331769 5071210 1336  5071219 1336  5071218 1338  5071227 1338  5071232 1338  5071232 1338  
331770 5071242 1338  5071241 1338  5071230 1340  5071232 1338  5071227 1338  5071213 1338  
331771 5071208 1338  5071199 1338  5071186 1336  5071167 1336  5071141 1338  5071128 1336  
331772 5071109 1336  5071086 1336  5071062 1336  5071033 1336  5071014 1336  5070990 1336  
331773 5070961 1336  5070936 1338  5070913 1336  5070890 1336  5070860 1338  5070842 1336  
331774 5070823 1336  5070799 1336  5070775 1336  5070751 1336  5070737 1336  5070723 1336  
331775 5070708 1336  5070694 1336  5070684 1336  5070665 1336  5070660 1336  5070651 1336  
331776 5070651 1336  5070651 1336  5070654 1332  5070651 1336  5070649 1338  5070660 1336  
331777 5070664 1338  5070665 1336  5070683 1338  5070697 1338  5070708 1336  5070727 1336  
331778 5070741 1336  5070759 1338  5070785 1336  5070799 1336  5070817 1338  5070840 1332  
331779 5070859 1338  5070885 1336  5070907 1338  5070926 1338  5070950 1338  5070984 1338  
331780 5071007 1338  5071027 1338  5071041 1338  5071076 1336  5071100 1336  5071112 1338  
331781 5071127 1338  5071151 1338  5071167 1336  5071186 1336  5071191 1336  5071199 1338  
331782 5071210 1336  5071214 1336  5071219 1336  5071217 1338  5071229 1336  5071219 1336  
331783 5071219 1336  5071217 1332  5071209 1336  5071200 1336  5071186 1336  5071167 1336  
331784 5071152 1336  5071133 1336  5071122 1332  5071109 1336  5071085 1336  5071069 1332  
331785 5071045 1332  5071019 1336  5070999 1336  5070979 1332  5070952 1336  5070928 1336  
331786 5070909 1336  5070890 1336  5070866 1336  5070851 1336  5070828 1336  5070818 1336  
331787 5070797 1338  5070785 1336  5070765 1336  5070761 1336  5070754 1332  5070741 1336  
331788 5070737 1336  5070727 1336  5070730 1332  5070727 1336  5070727 1336  5070727 1336  
331789 5070737 1336  5070741 1336  5070751 1336  5070759 1338  5070775 1336  5070789 1336  
331790 5070807 1338  5070821 1338  5070837 1336  5070859 1338  5070874 1338  5070898 1338  
331791 5070922 1338  5070941 1338  5070960 1338  5070988 1338  5071007 1338  5071028 1336  
331792 5071050 1338  5071074 1338  5071098 1338  5071119 1336  5071141 1338  5071160 1338  
331793 5071184 1338  5071199 1338  5071213 1338  5071229 1336  5071232 1338  5071243 1336  
331794 5071252 1336  5071257 1336  5071256 1338  5071257 1336  5071256 1338  5071256 1338  
331795 5071251 1338  5071241 1338  5071232 1338  5071217 1338  5071214 1336  5071189 1338  
331796 5071176 1336  5071152 1336  5071132 1338  5071112 1338  5071089 1338  5071065 1338  
331797 5071033 1336  5071013 1336  5070984 1338  5070961 1336  5070928 1336  5070907 1338  
331798 5070874 1338  5070850 1338  5070821 1338  5070797 1338  5070765 1336  5070751 1336  
331799 5070721 1338  5070706 1338  5070684 1336  5070664 1338  5070651 1336  5070635 1338  
331800 5070621 1338  5070616 1338  5070608 1336  5070598 1336  5070592 1338  5070592 1338  
331801 5070592 1338  5070592 1338  5070590 1340  5070595 1340  5070597 1338  5070614 1340  
331802 5070621 1338  5070633 1340  5070648 1340  5070662 1340  5070692 1338  5070706 1338  
331803 5070726 1338  5070750 1338  5070772 1340  5070796 1340  5070820 1340  5070840 1338  
331804 5070863 1340  5070888 1338  5070922 1338  5070940 1338  5070964 1338  5070998 1338  
331805 5071017 1338  5071041 1338  5071065 1338  5071089 1338  5071108 1338  5071117 1338  
331806 5071132 1338  5071151 1338  5071167 1336  5071175 1338  5071184 1338  5071191 1336  
331807 5071189 1338  5071199 1338  5071198 1338  5071191 1336  5071191 1336  5071186 1336  
331808 5071176 1336  5071162 1336  5071151 1338  5071133 1336  5071129 1336  5071109 1336  
331809 5071090 1336  5071066 1336  5071052 1336  5071028 1336  5071009 1336  5070984 1338  
331810 5070961 1336  5070936 1338  5070912 1338  5070888 1338  5070874 1338  5070850 1338  
331811 5070826 1338  5070817 1338  5070797 1338  5070775 1336  5070759 1338  5070750 1338  
331812 5070735 1338  5070727 1336  5070721 1338  5070716 1338  5070716 1338  5070706 1338  
331813 5070706 1338  5070716 1338  5070716 1338  5070718 1336  5070721 1338  5070726 1338  
331814 5070735 1338  5070751 1336  5070759 1338  5070775 1336  5070789 1336  5070818 1336  
331815 5070827 1336  5070850 1338  5070875 1336  5070890 1336  5070913 1336  5070942 1336  
331816 5070964 1338  5070988 1338  5071012 1338  5071031 1338  5071060 1338  5071084 1338  
331817 5071108 1338  5071128 1336  5071143 1336  5071165 1338  5071191 1336  5071210 1336  
331818 5071219 1336  5071232 1338  5071241 1338  5071251 1338  5071256 1338  5071267 1336  
331819 5071265 1338  5071265 1338  5071265 1338  5071256 1338  5071256 1338  5071241 1338  
331820 5071232 1338  5071217 1338  5071208 1338  5071189 1338  5071165 1338  5071141 1338  
331821 5071117 1338  5071098 1338  5071065 1338  5071041 1338  5071017 1338  5070988 1338  
331822 5070960 1338  5070926 1338  5070907 1338  5070875 1336  5070840 1338  5070817 1338  
331823 5070788 1338  5070759 1338  5070735 1338  5070716 1338  5070694 1336  5070665 1336  
331824 5070641 1336  5070624 1340  5070606 1338  5070592 1338  5070581 1340  5070563 1338  
331825 5070557 1340  5070549 1338  5070539 1338  5070539 1338  5070549 1338  5070549 1338  
331826 5070559 1338  5070559 1338  5070571 1340  5070592 1338  5070597 1338  5070614 1340  
331827 5070625 1338  5070648 1340  5070673 1338  5070692 1338  5070715 1340  5070735 1338  
331828 5070758 1340  5070782 1340  5070815 1340  5070834 1340  5070863 1340  5070886 1340  
331829 5070920 1340  5070948 1340  5070971 1341  5071006 1340  5071024 1341  5071047 1341  
331830 5071070 1343  5071094 1343  5071111 1345  5071124 1347  5071143 1347  5071158 1347  
331831 5071167 1347  5071181 1347  5071178 1351  5071197 1351  5071197 1351  5071197 1351  
331832 5071197 1351  5071200 1347  5071191 1347  5071178 1351  5071172 1353  5071164 1351  
331833 5071149 1351  5071130 1351  5071119 1347  5071102 1351  5071078 1351  5071064 1351  
331834 5071043 1347  5071019 1347  5071000 1347  5070977 1345  5070954 1345  5070930 1345  
331835 5070906 1345  5070882 1345  5070860 1343  5070836 1343  5070817 1343  5070802 1343  
331836 5070785 1341  5070769 1343  5070756 1341  5070746 1341  5070732 1341  5070723 1341  
331837 5070719 1340  5070720 1340  5070715 1340  5070713 1341  5070715 1340  5070713 1341  
331838 5070718 1341  5070718 1341  5070724 1340  5070734 1340  5070748 1340  5070762 1340  
331839 5070786 1340  5070796 1340  5070820 1340  5070834 1340  5070858 1340  5070874 1338  
331840 5070896 1340  5070919 1341  5070948 1340  5070974 1338  5070995 1341  5071015 1340  
331841 5071038 1341  5071063 1340  5071087 1340  5071109 1341  5071129 1341  5071157 1341  
331842 5071171 1341  5071194 1343  5071210 1341  5071223 1343  5071235 1345  5071250 1345  
331843 5071261 1343  5071270 1343  5071280 1343  5071280 1343  5071280 1343  5071270 1343  
331844 5071270 1343  5071261 1343  5071249 1345  5071237 1343  5071223 1343  5071205 1341  
331845 5071184 1343  5071162 1341  5071138 1341  5071113 1343  5071095 1341  5071071 1341  
331846 5071039 1340  5071009 1341  5070980 1341  5070948 1340  5070920 1340  5070887 1340  
331847 5070858 1340  5070826 1338  5070797 1338  5070762 1340  5070734 1340  5070716 1338  
331848 5070681 1340  5070657 1340  5070633 1340  5070616 1338  5070590 1340  5070573 1338  
331849 5070559 1338  5070539 1338  5070525 1338  5070520 1338  5070516 1338  5070517 1336  
331850 5070506 1338  5070507 1336  5070507 1336  5070516 1338  5070522 1336  5070525 1338  
331851 5070539 1338  5070560 1336  5070574 1336  5070593 1336  5070606 1338  5070627 1336  
331852 5070641 1336  5070664 1338  5070692 1338  5070723 1336  5070741 1336  5070764 1338  
331853 5070799 1336  5070823 1336  5070850 1338  5070874 1338  5070907 1338  5070926 1338  
331854 5070958 1340  5070984 1338  5071007 1338  5071027 1338  5071050 1338  5071065 1338  
331855 5071090 1336  5071108 1338  5071117 1338  5071127 1338  5071132 1338  5071151 1338  
331856 5071151 1338  5071162 1336  5071160 1338  5071160 1338  5071160 1338  5071160 1338  
331857 5071150 1338  5071141 1338  5071132 1338  5071127 1338  5071108 1338  5071098 1338  
331858 5071074 1338  5071062 1336  5071041 1338  5071017 1338  5070998 1338  5070985 1336  
331859 5070960 1338  5070936 1338  5070922 1338  5070890 1336  5070866 1336  5070851 1336  
331860 5070826 1338  5070818 1336  5070799 1336  5070775 1336  5070758 1340  5070750 1338  
331861 5070735 1338  5070723 1336  5070716 1338  5070706 1338  5070705 1340  5070697 1338  
331862 5070692 1338  5070695 1340  5070695 1340  5070697 1338  5070705 1340  5070716 1338  
331863 5070721 1338  5070735 1338  5070738 1340  5070758 1340  5070772 1340  5070796 1340  
331864 5070815 1340  5070824 1340  5070850 1338  5070874 1338  5070898 1338  5070925 1340  
331865 5070941 1338  5070972 1340  5070996 1340  5071015 1340  5071039 1340  5071065 1338  
331866 5071087 1340  5071111 1340  5071132 1338  5071159 1340  5071173 1340  5071189 1338  
331867 5071206 1340  5071216 1340  5071230 1340  5071240 1340  5071249 1340  5071256 1338  
331868 5071254 1340  5071254 1340  5071249 1340  5071249 1340  5071240 1340  5071230 1340  
331869 5071216 1340  5071206 1340  5071188 1340  5071173 1340  5071149 1340  5071124 1341  
331870 5071108 1338  5071073 1340  5071047 1341  5071015 1340  5070996 1340  5070961 1341  
331871 5070925 1340  5070895 1341  5070871 1341  5070839 1340  5070815 1340  5070780 1341  
331872 5070746 1341  5070718 1341  5070694 1341  5070661 1341  5070635 1343  5070618 1341  
331873 5070592 1343  5070580 1341  5070555 1341  5070536 1341  5070522 1341  5070516 1343  
331874 5070513 1341  5070503 1341  5070503 1341  5070492 1343  5070501 1343  5070501 1343  
331875 5070509 1345  5070511 1343  5070519 1345  5070530 1343  5070544 1343  5070557 1345  
331876 5070578 1343  5070600 1345  5070615 1345  5070634 1345  5070659 1343  5070686 1345  
331877 5070710 1345  5070729 1345  5070758 1345  5070782 1345  5070815 1345  5070836 1343  
331878 5070858 1345  5070892 1345  5070915 1345  5070944 1345  5070977 1345  5071003 1343  
331879 5071021 1345  5071036 1343  5071060 1343  5071079 1343  5071105 1341  5071114 1341  
331880 5071124 1341  5071137 1343  5071148 1341  5071157 1341  5071162 1341  5071170 1343  
331881 5071172 1341  5071172 1341  5071161 1343  5071161 1343  5071156 1343  5071146 1343  
331882 5071137 1343  5071122 1343  5071111 1345  5071103 1343  5071082 1345  5071060 1343  
331883 5071044 1345  5071021 1345  5071006 1345  5070984 1343  5070968 1345  5070942 1347  
331884 5070920 1345  5070901 1345  5070882 1345  5070868 1345  5070845 1343  5070829 1345  
331885 5070815 1345  5070791 1345  5070782 1345  5070767 1345  5070758 1345  5070743 1345  
331886 5070735 1343  5070729 1345  5070728 1347  5070728 1347  5070729 1345  5070728 1347  
331887 5070732 1347  5070732 1347  5070742 1347  5070752 1347  5070767 1345  5070780 1347  
331888 5070799 1347  5070813 1347  5070828 1347  5070852 1347  5070863 1351  5070890 1347  
331889 5070911 1351  5070933 1347  5070954 1351  5070981 1347  5071001 1351  5071021 1351  
331890 5071049 1351  5071073 1351  5071097 1351  5071119 1347  5071140 1351  5071164 1351  
331891 5071188 1351  5071202 1351  5071216 1351  5071234 1347  5071245 1351  5071255 1351  
331892 5071267 1347  5071274 1351  5071277 1347  5071277 1347  5071274 1351  5071274 1351  
331893 5071264 1351  5071258 1347  5071245 1351  5071231 1351  5071221 1351  5071207 1351  
331894 5071191 1347  5071176 1347  5071153 1347  5071124 1347  5071105 1347  5071078 1345  
331895 5071044 1345  5071019 1347  5070993 1343  5070958 1345  5070931 1343  5070902 1343  
331896 5070868 1345  5070836 1343  5070812 1343  5070780 1341  5070746 1341  5070721 1343  
331897 5070694 1341  5070670 1341  5070646 1341  5070624 1340  5070603 1341  5070590 1340  
331898 5070560 1341  5070557 1340  5070536 1341  5070522 1341  5070519 1340  5070514 1340  
331899 5070513 1341  5070504 1340  5070513 1341  5070513 1341  5070517 1341  5070521 1343  
331900 5070530 1343  5070544 1343  5070559 1343  5070579 1341  5070594 1341  5070613 1341  
331901 5070621 1343  5070644 1343  5070668 1343  5070692 1343  5070716 1343  5070734 1345  
331902 5070759 1343  5070782 1345  5070818 1341  5070834 1345  5070861 1341  5070893 1343  
331903 5070917 1343  5070936 1343  5070961 1341  5070985 1341  5071011 1340  5071028 1341  
331904 5071047 1341  5071062 1341  5071081 1341  5071097 1340  5071109 1341  5071114 1341  
331905 5071130 1340  5071130 1340  5071140 1340  5071140 1340  5071138 1341  5071138 1341  
331906 5071138 1341  5071130 1340  5071125 1340  5071116 1340  5071106 1340  5071097 1340  
331907 5071082 1340  5071063 1340  5071047 1341  5071030 1340  5071015 1340  5070996 1340  
331908 5070982 1340  5070958 1340  5070939 1340  5070920 1340  5070907 1338  5070880 1341  
331909 5070863 1340  5070848 1340  5070824 1340  5070813 1341  5070794 1341  5070780 1341  
331910 5070770 1341  5070756 1341  5070748 1340  5070737 1341  5070732 1341  5070732 1341  
331911 5070723 1341  5070721 1343  5070721 1343  5070731 1343  5070731 1343  5070735 1343  
331912 5070745 1343  5070758 1345  5070767 1345  5070785 1341  5070802 1343  5070815 1345  
331913 5070836 1343  5070855 1343  5070877 1345  5070893 1343  5070919 1341  5070936 1343  
331914 5070960 1343  5070984 1343  5071007 1343  5071027 1343  5071055 1343  5071079 1343  
331915 5071105 1341  5071122 1343  5071146 1343  5071161 1343  5071184 1343  5071203 1343  
331916 5071213 1343  5071223 1343  5071237 1343  5071246 1343  5071251 1343  5071253 1341  
331917 5071252 1341  5071251 1343  5071251 1343  5071248 1341  5071248 1341  5071238 1341  
331918 5071229 1341  5071214 1341  5071205 1341  5071186 1341  5071171 1341  5071147 1341  
331919 5071122 1343  5071105 1341  5071079 1343  5071056 1343  5071025 1345  5071001 1345  
331920 5070966 1347  5070933 1347  5070914 1347  5070880 1347  5070852 1347  5070815 1351  
331921 5070799 1347  5070763 1351  5070729 1351  5070713 1347  5070686 1351  5070662 1351  
331922 5070641 1347  5070615 1351  5070605 1351  5070581 1351  5070570 1353  5070553 1351  
331923 5070546 1353  5070529 1351  5070529 1351  5070524 1351  5070522 1353  5070513 1353  
331924 5070514 1351  5070524 1351  5070526 1355  5070529 1351  5070544 1355  5070551 1353  
331925 5070570 1353  5070585 1353  5070603 1353  5070611 1355  5070626 1355  5070650 1355  
331926 5070678 1355  5070694 1353  5070723 1353  5070737 1353  5070771 1353  5070795 1353  
331927 5070814 1353  5070836 1355  5070862 1353  5070895 1353  5070914 1353  5070928 1353  
331928 5070962 1353  5070978 1351  5071002 1351  5071021 1351  5071040 1351  5071054 1351  
331929 5071073 1351  5071088 1351  5071097 1351  5071105 1353  5071105 1353  5071114 1353  
331930 5071120 1353  5071121 1351  5071121 1351  5071120 1353  5071114 1353  5071115 1353  
331931 5071105 1353  5071100 1353  5071086 1353  5071078 1351  5071073 1351  5071053 1353  
331932 5071038 1353  5071019 1353  5071003 1355  5070986 1353  5070971 1353  5070952 1353  
331933 5070928 1353  5070914 1353  5070900 1353  5070885 1353  5070871 1353  5070852 1353  
331934 5070836 1355  5070823 1353  5070810 1351  5070795 1353  5070785 1353  5070775 1353  
331935 5070771 1353  5070761 1353  5070752 1353  5070750 1355  5070752 1353  5070752 1353  
331936 5070752 1353  5070752 1353  5070752 1353  5070761 1353  5070771 1353  5070785 1353  
331937 5070793 1355  5070809 1353  5070822 1355  5070837 1353  5070852 1353  5070874 1355  
331938 5070893 1355  5070909 1353  5070928 1353  5070951 1355  5070976 1353  5070995 1353  
331939 5071014 1353  5071038 1353  5071062 1353  5071086 1353  5071105 1353  5071121 1351  
331940 5071148 1353  5071162 1353  5071177 1353  5071196 1353  5071205 1353  5071216 1351  
331941 5071229 1353  5071239 1353  5071240 1351  5071245 1351  5071245 1351  5071244 1353  
331942 5071245 1351  5071245 1351  5071240 1351  5071231 1351  5071216 1351  5071202 1351  
331943 5071188 1351  5071173 1351  5071154 1351  5071140 1351  5071116 1351  5071095 1353  
331944 5071073 1351  5071040 1351  5071016 1351  5070997 1351  5070962 1353  5070933 1347  
331945 5070911 1351  5070877 1351  5070853 1351  5070825 1351  5070805 1351  5070772 1351  
331946 5070749 1351  5070724 1351  5070708 1347  5070682 1351  5070653 1351  5070638 1351  
331947 5070624 1351  5070610 1351  5070595 1351  5070580 1353  5070571 1351  5070562 1351  
331948 5070553 1351  5070548 1351  5070548 1351  5070538 1351  5070546 1353  5070548 1351  
331949 5070551 1353  5070551 1353  5070570 1353  5070580 1353  5070594 1353  5070604 1353  
331950 5070613 1353  5070626 1355  5070645 1355  5070670 1353  5070685 1353  5070707 1355  
331951 5070721 1355  5070747 1353  5070769 1355  5070794 1353  5070814 1353  5070836 1355  
331952 5070860 1355  5070885 1353  5070908 1355  5070928 1353  5070952 1353  5070971 1353  
331953 5070995 1353  5071005 1353  5071019 1353  5071038 1353  5071051 1355  5071062 1353  
331954 5071072 1353  5071076 1353  5071086 1353  5071097 1351  5071097 1351  5071096 1353  
331955 5071096 1353  5071096 1353  5071086 1353  5071086 1353  5071086 1353  5071076 1353  
331956 5071072 1353  5071062 1353  5071048 1353  5071040 1351  5071019 1353  5071005 1353  
331957 5070995 1353  5070976 1353  5070963 1351  5070949 1351  5070930 1351  5070914 1353  
331958 5070900 1353  5070886 1353  5070871 1353  5070853 1351  5070837 1353  5070823 1353  
331959 5070809 1353  5070804 1353  5070795 1353  5070784 1355  5070774 1355  5070769 1355  
331960 5070769 1355  5070760 1355  5070760 1355  5070771 1353  5070760 1355  5070769 1355  
331961 5070769 1355  5070774 1355  5070784 1355  5070793 1355  5070807 1355  5070822 1355  
331962 5070827 1355  5070845 1355  5070860 1355  5070874 1355  5070898 1355  5070912 1355  
331963 5070927 1355  5070952 1353  5070974 1355  5070995 1353  5071013 1355  5071027 1355  
331964 5071053 1353  5071070 1355  5071096 1353  5071103 1355  5071120 1353  5071137 1355  
331965 5071151 1355  5071172 1353  5071175 1355  5071194 1355  5071199 1355  5071204 1355  
331966 5071213 1355  5071213 1355  5071213 1355  5071213 1355  5071213 1355  5071204 1355  
331967 5071199 1355  5071199 1355  5071196 1353  5071177 1353  5071161 1355  5071153 1353  
331968 5071127 1355  5071115 1353  5071099 1355  5071075 1355  5071053 1353  5071027 1355  
331969 5071003 1355  5070984 1355  5070960 1355  5070938 1353  5070908 1355  5070886 1353  
331970 5070861 1353  5070836 1355  5070812 1355  5070793 1355  5070771 1353  5070745 1355  
331971 5070722 1355  5070702 1355  5070683 1355  5070669 1355  5070645 1355  5070635 1355  
331972 5070621 1355  5070607 1355  5070602 1355  5070592 1355  5070578 1355  5070578 1355  
331973 5070569 1355  5070568 1355  5070568 1355  5070568 1355  5070569 1355  5070583 1355  
331974 5070594 1353  5070603 1353  5070608 1353  5070613 1353  5070626 1355  5070647 1353  
331975 5070659 1355  5070678 1355  5070693 1355  5070707 1355  5070728 1353  5070747 1353  
331976 5070760 1355  5070785 1353  5070809 1353  5070826 1355  5070850 1355  5070874 1355  
331977 5070893 1355  5070914 1353  5070936 1355  5070951 1355  5070970 1355  5070984 1355  
331978 5070998 1355  5071013 1355  5071029 1353  5071037 1355  5071046 1355  5071051 1355  
331979 5071062 1353  5071070 1355  5071075 1355  5071075 1355  5071085 1355  5071085 1355  
331980 5071085 1355  5071075 1355  5071070 1355  5071070 1355  5071051 1355  5071051 1355  
331981 5071037 1355  5071027 1355  5071013 1355  5071005 1353  5070994 1355  5070984 1355  
331982 5070970 1355  5070951 1355  5070936 1355  5070927 1355  5070912 1355  5070898 1355  
331983 5070884 1355  5070869 1355  5070850 1355  5070845 1355  5070826 1355  5070822 1355  
331984 5070812 1355  5070807 1355  5070803 1355  5070793 1355  5070793 1355  5070784 1355  
331985 5070784 1355  5070784 1355  5070784 1355  5070784 1355  5070784 1355  5070793 1355  
331986 5070803 1355  5070807 1355  5070812 1355  5070827 1355  5070845 1355  5070850 1355  
331987 5070869 1355  5070884 1355  5070898 1355  5070912 1355  5070927 1355  5070946 1355  
331988 5070960 1355  5070984 1355  5070998 1355  5071018 1355  5071037 1355  5071049 1356  
331989 5071070 1355  5071085 1355  5071099 1355  5071113 1355  5071137 1355  5071146 1355  
331990 5071161 1355  5071170 1355  5071184 1355  5071194 1355  5071194 1355  5071199 1355  
331991 5071199 1355  5071199 1355  5071198 1356  5071199 1355  5071199 1355  5071194 1355  
331992 5071185 1355  5071175 1355  5071170 1355  5071151 1355  5071137 1355  5071118 1355  
331993 5071103 1355  5071085 1355  5071070 1355  5071051 1355  5071027 1355  5071003 1355  
331994 5070984 1355  5070960 1355  5070936 1355  5070912 1355  5070893 1355  5070869 1355  
331995 5070845 1355  5070822 1355  5070803 1355  5070774 1355  5070750 1355  5070736 1355  
331996 5070721 1355  5070702 1355  5070683 1355  5070678 1355  5070650 1355  5070645 1355  
331997 5070635 1355  5070621 1355  5070621 1355  5070611 1355  5070611 1355  5070607 1355  
331998 5070607 1355  5070607 1355  5070607 1355  5070611 1355  5070621 1355  5070626 1355  
331999 5070635 1355  5070645 1355  5070650 1355  5070659 1355  5070678 1355  5070683 1355  
332000 5070707 1355  5070721 1355  5070736 1355  5070750 1355  5070774 1355  5070793 1355  
332001 5070807 1355  5070826 1355  5070845 1355  5070869 1355  5070884 1355  5070908 1355  
332002 5070922 1355  5070936 1355  5070951 1355  5070970 1355  5070994 1355  5070998 1355  
332003 5071013 1355  5071027 1355  5071037 1355  5071046 1355  5071060 1355  5071070 1355  
332004 5071070 1355  5071075 1355  5071075 1355  5071085 1355  5071085 1355  5071085 1355  
332005 5071075 1355  5071075 1355  5071075 1355  5071070 1355  5071060 1355  5071051 1355  
332006 5071046 1355  5071037 1355  5071018 1355  5071013 1355  5070998 1355  5070994 1355  
332007 5070975 1355  5070970 1355  5070951 1355  5070936 1355  5070927 1355  5070912 1355  
332008 5070898 1355  5070893 1355  5070874 1355  5070869 1355  5070860 1355  5070850 1355  
332009 5070845 1355  5070836 1355  5070827 1355  5070822 1355  5070822 1355  5070822 1355  
332010 5070820 1356  5070822 1355  5070820 1356  5070820 1356  5070827 1355  5070825 1356  
332011 5070845 1355  5070849 1356  5070858 1356  5070868 1356  5070873 1356  5070892 1356  
332012 5070906 1356  5070911 1356  5070925 1356  5070944 1356  5070959 1356  5070973 1356  
332013 5070992 1356  5071002 1356  5071016 1356  5071037 1355  5071049 1356  5071069 1356  
332014 5071083 1356  5071097 1356  5071111 1356  5071126 1356  5071145 1356  5071150 1356  
332015 5071159 1356  5071174 1356  5071174 1356  5071183 1356  5071193 1356  5071193 1356  
332016 5071193 1356  5071193 1357  5071193 1356  5071193 1356  5071183 1356  5071183 1356  
332017 5071174 1356  5071169 1356  5071159 1356  5071145 1356  5071127 1355  5071118 1355  
332018 5071104 1355  5071085 1355  5071070 1355  5071051 1355  5071027 1355  5071013 1355  
332019 5070994 1355  5070970 1355  5070946 1355  5070927 1355  5070908 1355  5070893 1355  
332020 5070874 1355  5070850 1355  5070836 1355  5070812 1355  5070802 1355  5070784 1355  
332021 5070760 1355  5070745 1355  5070726 1355  5070721 1355  5070707 1354  5070702 1355  
332022 5070683 1355  5070678 1355  5070678 1355  5070669 1355  5070669 1355  5070669 1355  
332023 5070659 1355  5070659 1355  5070669 1355  5070669 1355  5070678 1355  5070683 1355  
332024 5070693 1355  5070702 1355  5070712 1355  5070721 1355  5070736 1355  5070745 1355  
332025 5070760 1355  5070784 1355  5070802 1355  5070812 1355  5070827 1355  5070845 1355  
332026 5070860 1355  5070884 1355  5070898 1355  5070922 1355  5070936 1355  5070951 1355  
332027 5070970 1355  5070994 1355  5071003 1355  5071018 1355  5071037 1355  5071051 1355  
332028 5071061 1355  5071075 1355  5071085 1355  5071094 1355  5071099 1355  5071103 1355  
332029 5071113 1355  5071113 1355  5071118 1355  5071118 1355  5071118 1355  5071118 1355  
332030 5071113 1355  5071113 1355  5071103 1355  5071099 1355  5071094 1355  5071084 1355  
332031 5071075 1355  5071070 1355  5071051 1355  5071046 1355  5071027 1355  5071013 1355  
332032 5070998 1355  5070984 1355  5070974 1355  5070960 1355  5070946 1355  5070927 1355  
332033 5070922 1355  5070908 1355  5070898 1355  5070884 1355  5070874 1355  5070860 1355  
332034 5070850 1355  5070845 1355  5070836 1355  5070826 1355  5070826 1355  5070826 1355  
332035 5070822 1355  5070822 1355  5070822 1355  5070822 1355  5070826 1355  5070827 1355  
332036 5070834 1356  5070845 1355  5070850 1355  5070860 1355  5070869 1355  5070874 1355  
332037 5070882 1356  5070898 1355  5070912 1355  5070921 1356  5070935 1356  5070951 1355  
332038 5070970 1355  5070984 1355  5070998 1355  5071011 1356  5071027 1355  5071037 1355  
332039 5071049 1356  5071069 1357  5071083 1356  5071094 1355  5071104 1355  5071111 1356  
332040 5071127 1355  5071137 1355  5071145 1356  5071150 1356  5071159 1356  5071159 1356  
332041 5071169 1356  5071169 1356  5071169 1356  5071169 1356  5071159 1356  5071159 1357  
332042 5071150 1356  5071145 1356  5071135 1356  5071126 1357  5071116 1356  5071100 1358  
332043 5071091 1358  5071081 1358  5071067 1358  5071049 1356  5071034 1358  5071010 1358  
332044 5070995 1358  5070979 1360  5070965 1360  5070941 1360  5070914 1364  5070903 1360  
332045 5070876 1364  5070862 1364  5070843 1364  5070819 1364  5070800 1364  5070785 1364  
332046 5070766 1364  5070751 1366  5070735 1368  5070717 1366  5070711 1368  5070703 1366  
332047 5070698 1366  5070684 1366  5070672 1368  5070668 1368  5070669 1366  5070668 1368  
332048 5070657 1370  5070657 1370  5070668 1368  5070672 1368  5070671 1370  5070682 1368  
332049 5070696 1368  5070700 1370  5070709 1370  5070724 1370  5070736 1372  5070746 1371  
332050 5070760 1372  5070779 1371  5070794 1372  5070808 1372  5070830 1373  5070846 1371  
332051 5070869 1373  5070883 1373  5070899 1372  5070923 1371  5070946 1371  5070961 1371  
332052 5070983 1373  5070999 1371  5071012 1373  5071031 1373  5071045 1373  5071060 1373  
332053 5071071 1372  5071079 1373  5071088 1373  5071098 1373  5071102 1373  5071122 1373  
332054 5071120 1375  5071127 1379  5071130 1375  5071130 1375  5071131 1379  5071127 1379  
332055 5071127 1379  5071117 1379  5071117 1379  5071107 1379  5071098 1379  5071083 1379  
332056 5071079 1379  5071063 1381  5071054 1381  5071044 1375  5071026 1379  5071015 1381  
332057 5070996 1381  5070983 1379  5070974 1379  5070955 1379  5070940 1379  5070926 1379  
332058 5070907 1379  5070893 1379  5070878 1379  5070864 1379  5070853 1381  5070838 1381  
332059 5070829 1381  5070824 1381  5070805 1381  5070805 1381  5070800 1381  5070791 1381  
332060 5070786 1381  5070786 1381  5070786 1381  5070786 1381  5070786 1381  5070786 1381  
332061 5070791 1381  5070791 1381  5070800 1381  5070815 1381  5070824 1381  5070827 1383  
332062 5070838 1381  5070851 1383  5070870 1383  5070883 1385  5070899 1383  5070913 1383  
332063 5070928 1383  5070947 1383  5070960 1385  5070979 1385  5070988 1385  5071012 1385  
332064 5071026 1385  5071045 1385  5071060 1385  5071074 1385  5071079 1385  5071095 1383  
332065 5071112 1385  5071127 1385  5071136 1385  5071147 1383  5071152 1383  5071162 1383  
332066 5071171 1383  5071170 1385  5071170 1385  5071173 1381  5071173 1381  5071171 1383  
332067 5071163 1381  5071154 1381  5071147 1383  5071147 1383  5071136 1385  5071121 1387  
332068 5071111 1387  5071092 1387  5071076 1388  5071071 1388  5071055 1390  5071030 1392  
332069 5071017 1390  5070997 1392  5070973 1392  5070961 1394  5070942 1394  5070917 1396  
332070 5070904 1394  5070879 1396  5070866 1394  5070842 1394  5070828 1394  5070804 1394  
332071 5070788 1396  5070774 1396  5070759 1396  5070740 1396  5070717 1396  5070710 1398  
332072 5070702 1396  5070691 1398  5070688 1396  5070678 1396  5070677 1398  5070672 1398  
332073 5070672 1398  5070677 1398  5070677 1398  5070677 1398  5070686 1398  5070693 1396  
332074 5070701 1398  5070712 1396  5070715 1398  5070734 1398  5070748 1398  5070766 1400  
332075 5070775 1400  5070791 1398  5070813 1400  5070834 1398  5070847 1400  5070871 1400  
332076 5070885 1400  5070909 1400  5070933 1400  5070947 1400  5070967 1400  5070981 1400  
332077 5071009 1400  5071024 1400  5071048 1400  5071062 1400  5071076 1400  5071091 1400  
332078 5071100 1400  5071114 1400  5071123 1402  5071138 1400  5071148 1400  5071158 1400  
332079 5071158 1400  5071162 1400  5071162 1400  5071162 1400  5071162 1400  5071158 1400  
332080 5071158 1400  5071148 1400  5071137 1402  5071134 1400  5071124 1400  5071111 1398  
332081 5071092 1398  5071081 1400  5071067 1400  5071057 1400  5071033 1400  5071014 1400  
332082 5071000 1400  5070977 1398  5070963 1398  5070949 1398  5070924 1400  5070909 1400  
332083 5070887 1398  5070872 1398  5070849 1398  5070833 1400  5070810 1398  5070793 1396  
332084 5070788 1396  5070775 1394  5070761 1394  5070743 1392  5070737 1394  5070729 1392  
332085 5070720 1392  5070718 1388  5070708 1388  5070700 1387  5070700 1387  5070702 1385  
332086 5070711 1385  5070711 1385  5070721 1385  5070726 1385  5070735 1385  5070750 1385  
332087 5070761 1383  5070780 1383  5070788 1385  5070802 1385  5070823 1383  5070835 1385  
332088 5070859 1385  5070872 1387  5070896 1387  5070920 1387  5070934 1387  5070958 1387  
332089 5070974 1385  5070988 1385  5071012 1385  5071028 1383  5071052 1383  5071071 1383  
332090 5071080 1383  5071095 1383  5071115 1381  5071130 1381  5071139 1381  5071154 1381  
332091 5071163 1381  5071173 1381  5071173 1381  5071178 1381  5071178 1381  5071177 1381  
332092 5071178 1381  5071173 1381  5071173 1381  5071163 1381  5071154 1381  5071149 1381  
332093 5071139 1381  5071125 1381  5071106 1381  5071090 1383  5071076 1383  5071063 1381  
332094 5071038 1383  5071014 1383  5070995 1383  5070975 1383  5070952 1383  5070928 1383  
332095 5070904 1383  5070888 1385  5070869 1385  5070845 1385  5070828 1383  5070802 1385  
332096 5070788 1385  5070778 1385  5070759 1385  5070745 1385  5070725 1385  5070711 1385  
332097 5070700 1387  5070697 1385  5070687 1385  5070681 1387  5070683 1385  5070676 1387  
332098 5070676 1387  5070676 1387  5070676 1387  5070681 1387  5070686 1387  5070695 1387  
332099 5070710 1387  5070718 1388  5070734 1387  5070748 1387  5070767 1387  5070785 1388  
332100 5070800 1387  5070823 1388  5070842 1388  5070866 1388  5070885 1388  5070909 1388  
332101 5070933 1388  5070957 1388  5070974 1390  5070999 1388  5071023 1388  5071047 1388  
332102 5071071 1388  5071090 1388  5071109 1388  5071133 1388  5071147 1388  5071167 1388  
332103 5071176 1388  5071191 1388  5071200 1388  5071210 1388  5071213 1390  5071224 1388  
332104 5071224 1388  5071232 1390  5071232 1390  5071232 1390  5071223 1390  5071213 1390  
332105 5071214 1388  5071199 1390  5071189 1390  5071175 1390  5071167 1388  5071146 1390  
332106 5071132 1390  5071117 1390  5071090 1388  5071074 1390  5071055 1390  5071031 1390  
332107 5071007 1390  5070985 1388  5070965 1390  5070939 1392  5070917 1390  5070891 1392  
332108 5070869 1390  5070845 1390  5070815 1392  5070796 1392  5070777 1392  5070762 1392  
332109 5070738 1392  5070720 1392  5070704 1394  5070689 1394  5070680 1394  5070675 1394  
332110 5070661 1394  5070662 1392  5070651 1394  5070651 1394  5070651 1394  5070651 1394  
332111 5070661 1394  5070659 1396  5070669 1396  5070675 1394  5070688 1396  5070704 1394  
332112 5070717 1396  5070742 1394  5070759 1396  5070778 1396  5070804 1394  5070818 1394  
332113 5070840 1396  5070866 1394  5070895 1394  5070919 1394  5070942 1394  5070968 1392  
332114 5070986 1394  5071021 1392  5071044 1392  5071068 1392  5071087 1392  5071116 1392  
332115 5071138 1394  5071154 1392  5071175 1390  5071188 1392  5071208 1390  5071223 1390  
332116 5071230 1392  5071242 1390  5071246 1390  5071258 1388  5071267 1388  5071265 1390  
332117 5071264 1392  5071265 1390  5071256 1390  5071246 1390  5071241 1390  5071231 1392  
332118 5071213 1390  5071197 1392  5071184 1390  5071168 1392  5071156 1390  5071130 1392  
332119 5071106 1392  5071084 1390  5071065 1390  5071039 1392  5071015 1392  5070985 1394  
332120 5070968 1392  5070952 1394  5070927 1396  5070904 1394  5070879 1396  5070860 1396  
332121 5070839 1398  5070825 1398  5070801 1398  5070787 1398  5070771 1400  5070766 1400  
332122 5070748 1398  5070737 1400  5070734 1398  5070725 1398  5070724 1398  5070717 1396  
332123 5070726 1396  5070728 1394  5070737 1394  5070743 1392  5070755 1390  5070763 1392  
332124 5070777 1392  5070793 1390  5070807 1390  5070831 1390  5070845 1390  5070869 1390  
332125 5070884 1390  5070906 1392  5070930 1392  5070955 1390  5070984 1390  5071008 1390  
332126 5071030 1392  5071054 1392  5071084 1390  5071108 1390  5071141 1390  5071164 1392  
332127 5071183 1392  5071208 1390  5071221 1392  5071246 1390  5071266 1390  5071275 1390  
332128 5071289 1390  5071307 1392  5071323 1390  5071333 1390  5071332 1390  5071337 1390  
332129 5071337 1390  5071337 1390  5071337 1390  5071332 1390  5071332 1390  5071313 1390  
332130 5071308 1390  5071289 1390  5071275 1390  5071267 1388  5071241 1390  5071223 1390  
332131 5071200 1388  5071176 1388  5071146 1390  5071122 1390  5071089 1390  5071066 1388  
332132 5071033 1388  5071000 1388  5070969 1390  5070942 1388  5070909 1388  5070880 1388  
332133 5070847 1388  5070824 1387  5070796 1387  5070767 1387  5070743 1387  5070719 1387  
332134 5070695 1387  5070681 1387  5070656 1388  5070641 1388  5070622 1388  5070618 1388  
332135 5070606 1390  5070597 1390  5070592 1390  5070592 1390  5070592 1390  5070597 1390  
332136 5070605 1392  5070615 1392  5070621 1390  5070638 1392  5070653 1392  5070676 1392  
332137 5070691 1392  5070715 1392  5070740 1390  5070762 1392  5070782 1392  5070807 1390  
332138 5070840 1390  5070869 1390  5070898 1390  5070931 1390  5070955 1390  5070989 1390  
332139 5071023 1388  5071046 1390  5071076 1388  5071109 1388  5071143 1388  5071165 1390  
332140 5071186 1388  5071208 1390  5071232 1390  5071246 1390  5071267 1388  5071275 1390  
332141 5071290 1390  5071299 1390  5071308 1390  5071312 1392  5071312 1392  5071312 1392  
332142 5071312 1392  5071312 1392  5071307 1392  5071297 1392  5071283 1392  5071267 1394  
332143 5071253 1394  5071238 1394  5071218 1396  5071194 1396  5071169 1398  5071151 1396  
332144 5071127 1396  5071103 1396  5071079 1396  5071060 1396  5071027 1396  5071003 1396  
332145 5070969 1396  5070949 1398  5070927 1396  5070903 1396  5070875 1394  5070852 1394  
332146 5070826 1396  5070812 1396  5070788 1396  5070774 1396  5070769 1396  5070748 1398  
332147 5070740 1396  5070735 1396  5070725 1398  5070726 1396  5070726 1396  5070726 1396  
332148 5070725 1398  5070734 1398  5070739 1398  5070748 1398  5070767 1398  5070787 1398  
332149 5070801 1398  5070815 1398  5070839 1398  5070863 1398  5070876 1400  5070912 1396  
332150 5070935 1398  5070959 1398  5070977 1398  5071011 1398  5071035 1398  5071065 1396  
332151 5071092 1398  5071117 1396  5071151 1396  5071170 1396  5071203 1396  5071229 1394  
332152 5071251 1396  5071272 1394  5071286 1394  5071309 1396  5071328 1396  5071342 1396  
332153 5071361 1396  5071366 1396  5071372 1394  5071380 1396  5071385 1396  5071385 1396  
332154 5071382 1394  5071380 1396  5071372 1394  5071366 1396  5071350 1398  5071332 1396  
332155 5071320 1394  5071294 1396  5071280 1396  5071262 1394  5071229 1394  5071203 1396  
332156 5071170 1396  5071137 1396  5071103 1396  5071071 1394  5071036 1396  5071005 1394  
332157 5070965 1396  5070925 1398  5070887 1398  5070860 1396  5070815 1398  5070788 1396  
332158 5070758 1398  5070714 1400  5070686 1398  5070658 1398  5070632 1400  5070600 1398  
332159 5070576 1398  5070565 1400  5070541 1400  5070522 1400  5070509 1398  5070489 1400  
332160 5070474 1400  5070474 1400  5070471 1398  5070470 1400  5070474 1400  5070484 1400  
332161 5070490 1398  5070508 1400  5070524 1398  5070543 1398  5070556 1400  5070576 1398  
332162 5070599 1400  5070623 1400  5070658 1398  5070685 1400  5070713 1400  5070748 1398  
332163 5070775 1400  5070809 1400  5070847 1400  5070885 1400  5070914 1400  5070959 1398  
332164 5070990 1400  5071025 1398  5071064 1398  5071091 1400  5071124 1400  5071158 1400  
332165 5071176 1400  5071205 1400  5071235 1398  5071248 1400  5071267 1400  5071282 1400  
332166 5071291 1400  5071301 1400  5071306 1400  5071316 1398  5071316 1398  5071325 1400  
332167 5071315 1400  5071307 1398  5071301 1400  5071293 1398  5071278 1398  5071263 1400  
332168 5071248 1400  5071226 1398  5071205 1400  5071181 1400  5071158 1400  5071134 1400  
332169 5071100 1400  5071076 1400  5071047 1400  5071024 1400  5070990 1400  5070960 1402  
332170 5070932 1402  5070906 1403  5070884 1402  5070860 1402  5070836 1402  5070810 1403  
332171 5070787 1404  5070772 1404  5070763 1403  5070744 1403  5070729 1403  5070720 1404  
332172 5070710 1404  5070705 1403  5070696 1403  5070696 1404  5070695 1405  5070704 1405  
332173 5070710 1404  5070709 1405  5070725 1409  5070742 1405  5070761 1405  5070777 1409  
332174 5070792 1409  5070816 1409  5070839 1409  5070868 1409  5070891 1411  5070924 1411  
332175 5070950 1409  5070973 1409  5071005 1411  5071038 1411  5071058 1411  5071093 1409  
332176 5071126 1409  5071155 1409  5071182 1411  5071215 1411  5071239 1411  5071268 1411  
332177 5071292 1411  5071315 1411  5071341 1409  5071353 1411  5071368 1411  5071382 1411  
332178 5071392 1411  5071398 1409  5071408 1409  5071408 1409  5071417 1409  5071408 1409  
332179 5071408 1409  5071398 1409  5071394 1409  5071370 1409  5071353 1411  5071339 1411  
332180 5071317 1409  5071293 1409  5071269 1409  5071239 1411  5071207 1409  5071172 1411  
332181 5071139 1411  5071102 1409  5071067 1411  5071024 1411  5070992 1409  5070949 1409  
332182 5070905 1411  5070868 1409  5070828 1411  5070792 1409  5070758 1409  5070714 1411  
332183 5070677 1409  5070649 1409  5070604 1411  5070580 1411  5070555 1413  5070521 1413  
332184 5070497 1413  5070478 1413  5070459 1413  5070445 1413  5070430 1413  5070430 1413  
332185 5070421 1413  5070412 1413  5070411 1413  5070411 1413  5070419 1415  5070432 1411  
332186 5070446 1411  5070459 1413  5070473 1413  5070497 1413  5070521 1413  5070555 1413  
332187 5070574 1413  5070602 1413  5070636 1413  5070674 1413  5070714 1411  5070747 1411  
332188 5070780 1411  5070822 1413  5070860 1413  5070899 1413  5070937 1413  5070970 1413  
332189 5071013 1413  5071052 1413  5071080 1413  5071123 1413  5071147 1413  5071172 1411  
332190 5071204 1413  5071228 1413  5071252 1413  5071273 1411  5071290 1413  5071306 1411  
332191 5071320 1411  5071328 1413  5071339 1411  5071338 1413  5071338 1413  5071339 1411  
332192 5071328 1413  5071319 1413  5071314 1413  5071293 1415  5071280 1413  5071265 1415  
332193 5071247 1413  5071223 1413  5071195 1413  5071171 1413  5071151 1413  5071122 1415  
332194 5071088 1415  5071064 1415  5071035 1415  5071004 1413  5070969 1415  5070946 1413  
332195 5070921 1415  5070887 1415  5070864 1415  5070844 1415  5070821 1415  5070797 1415  
332196 5070773 1415  5070758 1415  5070744 1415  5070726 1413  5070720 1415  5070712 1413  
332197 5070701 1415  5070696 1415  5070696 1415  5070701 1415  5070701 1415  5070710 1415  
332198 5070720 1415  5070725 1415  5070744 1415  5070765 1413  5070777 1415  5070801 1415  
332199 5070825 1415  5070849 1415  5070878 1415  5070900 1417  5070935 1415  5070954 1415  
332200 5070986 1417  5071021 1415  5071050 1415  5071078 1415  5071112 1415  5071148 1417  
332201 5071177 1417  5071203 1415  5071245 1415  5071270 1415  5071293 1415  5071316 1417  
332202 5071344 1417  5071365 1415  5071387 1417  5071403 1415  5071417 1415  5071427 1415  
332203 5071435 1417  5071441 1415  5071442 1415  5071441 1415  5071440 1417  5071435 1417  
332204 5071417 1415  5071413 1415  5071387 1417  5071370 1415  5071351 1415  5071328 1413  
332205 5071293 1415  5071270 1415  5071246 1415  5071214 1413  5071171 1413  5071137 1413  
332206 5071099 1413  5071056 1413  5071023 1413  5070970 1413  5070937 1413  5070889 1413  
332207 5070852 1411  5070803 1413  5070765 1413  5070727 1413  5070688 1413  5070655 1413  
332208 5070612 1413  5070580 1411  5070547 1411  5070515 1409  5070489 1411  5070465 1411  
332209 5070446 1411  5070423 1411  5070408 1411  5070388 1413  5070375 1411  5070370 1411  
332210 5070370 1411  5070370 1411  5070370 1411  5070375 1411  5070378 1413  5070389 1411  
332211 5070412 1413  5070432 1411  5070454 1413  5070473 1413  5070499 1411  5070531 1413  
332212 5070561 1411  5070588 1413  5070622 1413  5070661 1411  5070690 1411  5070728 1411  
332213 5070765 1413  5070803 1413  5070846 1413  5070879 1413  5070923 1413  5070956 1413  
332214 5070999 1413  5071039 1411  5071070 1413  5071105 1411  5071139 1411  5071166 1413  
332215 5071190 1413  5071215 1411  5071238 1413  5071254 1411  5071268 1411  5071282 1411  
332216 5071292 1411  5071297 1411  5071306 1411  5071304 1413  5071306 1411  5071296 1411  
332217 5071295 1413  5071280 1413  5071266 1413  5071254 1411  5071239 1411  5071225 1411  
332218 5071196 1411  5071172 1411  5071148 1411  5071125 1411  5071102 1409  5071066 1413  
332219 5071039 1411  5071005 1411  5070980 1413  5070953 1411  5070924 1411  5070900 1411  
332220 5070866 1411  5070847 1411  5070824 1411  5070801 1409  5070776 1411  5070757 1411  
332221 5070738 1411  5070723 1411  5070714 1411  5070704 1411  5070690 1411  5070690 1411  
332222 5070681 1411  5070679 1413  5070679 1413  5070688 1413  5070699 1411  5070703 1413  
332223 5070712 1413  5070727 1413  5070746 1413  5070760 1413  5070779 1413  5070812 1413  
332224 5070827 1413  5070860 1413  5070891 1411  5070924 1411  5070953 1411  5070980 1413  
332225 5071013 1413  5071048 1411  5071072 1411  5071113 1413  5071139 1411  5071171 1413  
332226 5071206 1411  5071237 1413  5071266 1413  5071292 1411  5071320 1411  5071349 1411  
332227 5071368 1411  5071382 1411  5071405 1413  5071420 1411  5071430 1411  5071441 1409  
332228 5071444 1411  5071446 1409  5071446 1409  5071441 1409  5071441 1409  5071420 1411  
332229 5071417 1409  5071398 1409  5071374 1409  5071354 1411  5071341 1409  5071307 1409  
332230 5071284 1409  5071258 1405  5071220 1405  5071178 1403  5071153 1405  5071105 1405  
332231 5071062 1405  5071030 1404  5070978 1403  5070944 1404  5070906 1404  5070858 1404  
332232 5070820 1404  5070772 1404  5070734 1403  5070696 1404  5070663 1403  5070629 1404  
332233 5070586 1403  5070564 1402  5070530 1402  5070495 1403  5070468 1402  5070445 1402  
332234 5070430 1402  5070406 1402  5070387 1402  5070384 1400  5070378 1402  5070369 1400  
332235 5070369 1400  5070369 1400  5070379 1400  5070384 1400  5070389 1400  5070409 1398  
332236 5070432 1400  5070446 1400  5070468 1402  5070489 1400  5070522 1400  5070546 1400  
332237 5070575 1400  5070608 1400  5070647 1400  5070677 1398  5070715 1398  5070747 1400  
332238 5070787 1398  5070825 1398  5070863 1398  5070901 1398  5070939 1398  5070979 1396  
332239 5071012 1396  5071049 1398  5071079 1396  5071113 1396  5071141 1396  5071164 1398  
332240 5071183 1398  5071208 1396  5071228 1396  5071242 1396  5071262 1394  5071267 1394  
332241 5071272 1394  5071281 1394  5071283 1392  5071283 1392  5071274 1392  5071270 1390  
332242 5071265 1390  5071246 1390  5071232 1390  5071213 1390  5071199 1390  5071184 1390  
332243 5071165 1390  5071141 1390  5071117 1390  5071090 1388  5071066 1388  5071042 1388  
332244 5071009 1388  5070985 1388  5070957 1388  5070933 1388  5070899 1388  5070882 1387  
332245 5070856 1388  5070831 1390  5070808 1388  5070785 1388  5070777 1387  5070756 1388  
332246 5070743 1387  5070734 1387  5070718 1388  5070710 1387  5070699 1388  5070694 1388  
332247 5070694 1388  5070695 1387  5070695 1387  5070700 1387  5070710 1387  5070718 1388  
332248 5070732 1388  5070748 1387  5070775 1388  5070786 1387  5070810 1387  5070834 1387  
332249 5070867 1387  5070887 1387  5070912 1385  5070945 1385  5070974 1385  5071003 1385  
332250 5071036 1385  5071068 1387  5071094 1385  5071127 1385  5071168 1387  5071189 1385  
332251 5071217 1385  5071252 1383  5071275 1385  5071305 1383  5071329 1383  5071353 1383  
332252 5071372 1383  5071380 1385  5071396 1383  5071415 1383  5071420 1383  5071419 1383  
332253 5071429 1383  5071428 1385  5071418 1385  5071421 1381  5071407 1381  5071397 1381  
332254 5071381 1383  5071373 1381  5071343 1383  5071319 1383  5071292 1381  5071264 1381  
332255 5071230 1381  5071197 1381  5071173 1381  5071130 1381  5071093 1379  5071054 1381  
332256 5071015 1381  5070978 1379  5070940 1379  5070902 1379  5070858 1375  5070826 1379  
332257 5070791 1375  5070740 1379  5070705 1375  5070666 1375  5070634 1373  5070595 1375  
332258 5070568 1373  5070539 1379  5070509 1375  5070487 1379  5070463 1379  5070442 1375  
332259 5070425 1379  5070405 1379  5070401 1379  5070394 1381  5070385 1381  5070385 1381  
332260 5070385 1381  5070385 1381  5070394 1381  5070399 1381  5070411 1385  5070431 1383  
332261 5070444 1385  5070458 1385  5070481 1387  5070499 1387  5070525 1385  5070557 1387  
332262 5070586 1387  5070619 1387  5070653 1387  5070681 1387  5070718 1388  5070746 1388  
332263 5070785 1388  5070823 1388  5070864 1390  5070895 1388  5070931 1390  5070965 1390  
332264 5070989 1390  5071024 1388  5071056 1390  5071076 1388  5071109 1388  5071124 1388  
332265 5071147 1388  5071167 1388  5071176 1388  5071191 1388  5071202 1387  5071213 1385  
332266 5071216 1387  5071217 1385  5071214 1388  5071217 1385  5071216 1387  5071213 1385  
332267 5071192 1387  5071188 1387  5071175 1385  5071160 1385  5071147 1383  5071128 1383  
332268 5071103 1385  5071079 1385  5071060 1385  5071036 1385  5071012 1385  5070988 1385  
332269 5070969 1385  5070947 1383  5070922 1385  5070898 1385  5070874 1385  5070850 1385  
332270 5070826 1385  5070801 1387  5070786 1387  5070778 1385  5070758 1387  5070743 1387  
332271 5070724 1387  5070718 1388  5070708 1388  5070699 1388  5070699 1388  5070692 1390  
332272 5070696 1392  5070696 1392  5070707 1390  5070715 1392  5070721 1390  5070731 1390  
332273 5070753 1392  5070772 1392  5070780 1394  5070805 1392  5070820 1392  5070843 1392  
332274 5070868 1392  5070891 1392  5070920 1392  5070944 1392  5070972 1392  5070995 1394  
332275 5071030 1392  5071063 1392  5071087 1392  5071119 1388  5071146 1390  5071173 1387  
332276 5071200 1388  5071226 1387  5071249 1387  5071273 1387  5071288 1387  5071302 1387  
332277 5071326 1387  5071337 1385  5071350 1387  5071359 1387  5071369 1387  5071372 1388  
332278 5071372 1388  5071374 1387  5071369 1387  5071359 1387  5071339 1388  5071334 1388  
332279 5071310 1388  5071291 1388  5071272 1388  5071258 1388  5071234 1388  5071200 1388  
332280 5071170 1390  5071147 1388  5071119 1388  5071076 1388  5071047 1388  5071020 1387  
332281 5070977 1387  5070945 1385  5070901 1387  5070869 1385  5070837 1383  5070799 1383  
332282 5070761 1383  5070724 1381  5070690 1381  5070662 1381  5070628 1381  5070600 1381  
332283 5070572 1379  5070549 1379  5070525 1379  5070505 1379  5070487 1379  5070475 1375  
332284 5070461 1375  5070442 1375  5070434 1379  5070428 1375  5070418 1375  5070420 1373  
332285 5070420 1373  5070428 1375  5070437 1375  5070443 1373  5070461 1375  5070477 1373  
332286 5070491 1373  5070510 1373  5070529 1373  5070552 1375  5070585 1375  5070604 1375  
332287 5070633 1375  5070666 1375  5070690 1375  5070719 1375  5070759 1373  5070786 1375  
332288 5070819 1375  5070853 1375  5070881 1375  5070910 1375  5070943 1375  5070977 1375  
332289 5070998 1379  5071029 1375  5071053 1375  5071082 1375  5071096 1375  5071117 1379  
332290 5071131 1379  5071154 1375  5071155 1379  5071177 1375  5071182 1375  5071187 1375  
332291 5071187 1375  5071187 1375  5071187 1375  5071189 1373  5071182 1375  5071177 1375  
332292 5071169 1373  5071155 1373  5071144 1375  5071131 1373  5071102 1373  5071088 1373  
332293 5071068 1375  5071053 1375  5071031 1373  5071004 1372  5070988 1373  5070967 1375  
332294 5070943 1375  5070921 1373  5070897 1373  5070878 1373  5070859 1373  5070835 1373  
332295 5070821 1373  5070807 1373  5070791 1375  5070776 1375  5070757 1375  5070752 1375  
332296 5070733 1375  5070728 1375  5070719 1375  5070719 1375  5070719 1375  5070719 1375  
332297 5070719 1375  5070719 1375  5070729 1375  5070733 1375  5070752 1375  5070757 1375  
332298 5070773 1379  5070791 1375  5070810 1375  5070826 1379  5070850 1379  5070876 1375  
332299 5070893 1379  5070920 1375  5070940 1379  5070964 1379  5070993 1379  5071016 1379  
332300 5071041 1379  5071077 1375  5071093 1379  5071115 1381  5071141 1379  5071163 1381  
332301 5071184 1379  5071208 1379  5071222 1379  5071241 1379  5071259 1375  5071278 1375  
332302 5071287 1375  5071297 1375  5071298 1379  5071308 1379  5071311 1375  5071321 1375  
332303 5071318 1379  5071308 1379  5071299 1379  5071297 1375  5071284 1379  5071275 1379  
332304 5071265 1379  5071241 1379  5071225 1375  5071206 1381  5071184 1379  5071165 1379  
332305 5071141 1379  5071117 1379  5071083 1379  5071055 1379  5071026 1379  5070993 1379  
332306 5070964 1379  5070931 1379  5070902 1379  5070878 1379  5070843 1375  5070806 1379  
332307 5070788 1379  5070754 1379  5070730 1379  5070706 1379  5070681 1381  5070657 1381  
332308 5070628 1381  5070616 1379  5070590 1381  5070581 1381  5070561 1381  5070547 1381  
332309 5070537 1381  5070528 1381  5070522 1383  5070514 1381  5070504 1381  5070514 1381  
332310 5070514 1381  5070523 1381  5070528 1381  5070538 1381  5070555 1383  5070560 1383  
332311 5070581 1381  5070589 1383  5070603 1383  5070628 1381  5070655 1383  5070679 1383  
332312 5070698 1383  5070729 1381  5070751 1383  5070779 1383  5070805 1381  5070837 1383  
332313 5070861 1383  5070890 1383  5070925 1381  5070947 1383  5070975 1383  5070995 1383  
332314 5071023 1383  5071047 1383  5071062 1383  5071080 1383  5071095 1383  5071114 1383  
332315 5071128 1383  5071138 1383  5071152 1383  5071162 1383  5071170 1385  5071174 1385  
332316 5071176 1383  5071176 1383  5071171 1383  5071170 1385  5071160 1385  5071160 1385  
332317 5071147 1383  5071136 1385  5071128 1383  5071112 1385  5071095 1383  5071079 1385  
332318 5071069 1385  5071052 1383  5071027 1385  5071012 1385  5070988 1385  5070969 1385  
332319 5070950 1385  5070926 1385  5070902 1385  5070890 1383  5070873 1385  5070850 1385  
332320 5070835 1385  5070827 1383  5070811 1385  5070797 1385  5070788 1385  5070783 1385  
332321 5070778 1385  5070769 1385  5070758 1387  5070759 1385  5070759 1385  5070758 1387  
332322 5070759 1385  5070767 1387  5070769 1385  5070778 1385  5070783 1385  5070797 1385  
332323 5070811 1385  5070826 1385  5070846 1383  5070869 1385  5070885 1383  5070902 1385  
332324 5070923 1383  5070945 1385  5070960 1385  5070980 1383  5071003 1385  5071027 1385  
332325 5071049 1387  5071069 1385  5071093 1385  5071112 1385  5071136 1385  5071160 1385  
332326 5071175 1385  5071189 1385  5071211 1387  5071217 1385  5071237 1385  5071251 1385  
332327 5071261 1385  5071270 1385  5071275 1385  5071275 1385  5071279 1385  5071279 1385  
332328 5071280 1385  5071275 1385  5071275 1385  5071270 1385  5071261 1385  5071246 1385  
332329 5071238 1383  5071217 1385  5071205 1383  5071189 1385  5071175 1385  5071151 1385  
332330 5071127 1385  5071103 1385  5071079 1385  5071060 1385  5071036 1385  5071003 1385  
332331 5070977 1387  5070958 1387  5070934 1387  5070902 1385  5070881 1387  5070859 1385  
332332 5070834 1387  5070811 1385  5070788 1385  5070767 1387  5070748 1387  5070724 1387  
332333 5070711 1385  5070695 1387  5070683 1385  5070667 1387  5070653 1387  5070643 1387  
332334 5070633 1387  5070625 1385  5070625 1385  5070619 1387  5070621 1385  5070619 1387  
332335 5070625 1385  5070635 1385  5070635 1385  5070652 1387  5070659 1385  5070667 1387  
332336 5070681 1387  5070695 1387  5070710 1387  5070724 1387  5070750 1385  5070767 1387  
332337 5070786 1387  5070811 1385  5070834 1387  5070858 1387  5070881 1387  5070902 1385  
332338 5070925 1387  5070950 1385  5070972 1387  5070993 1385  5071020 1387  5071044 1387  
332339 5071060 1385  5071089 1385  5071103 1385  5071122 1385  5071136 1385  5071144 1387  
332340 5071150 1385  5071170 1385  5071173 1387  5071179 1385  5071179 1385  5071179 1385  
332341 5071179 1385  5071179 1385  5071179 1385  5071176 1383  5071175 1385  5071170 1385  
332342 5071162 1383  5071147 1383  5071138 1383  5071124 1383  5071105 1383  5071090 1383  
332343 5071076 1383  5071061 1383  5071036 1385  5071022 1385  5070993 1385  5070980 1383  
332344 5070971 1383  5070950 1385  5070936 1385  5070920 1387  5070898 1385  5070883 1385  
332345 5070874 1385  5070859 1385  5070848 1387  5070834 1387  5070824 1387  5070820 1387  
332346 5070810 1387  5070801 1387  5070799 1388  5070800 1387  5070799 1388  5070799 1388  
332347 5070799 1388  5070808 1388  5070818 1388  5070823 1388  5070832 1388  5070842 1388  
332348 5070845 1390  5070866 1388  5070878 1390  5070884 1390  5070898 1390  5070917 1390  
332349 5070942 1388  5070955 1390  5070969 1390  5070984 1390  5071009 1388  5071022 1390  
332350 5071041 1390  5071065 1390  5071073 1392  5071089 1390  5071106 1392  5071132 1390  
332351 5071144 1392  5071156 1390  5071170 1390  5071175 1390  5071189 1390  5071199 1390  
332352 5071208 1390  5071211 1392  5071223 1390  5071223 1390  5071232 1390  5071231 1392  
332353 5071232 1390  5071232 1390  5071221 1392  5071223 1390  5071208 1390  5071199 1390  
332354 5071188 1392  5071184 1390  5071173 1392  5071164 1392  5071143 1394  5071130 1392  
332355 5071106 1392  5071087 1392  5071074 1390  5071063 1392  5071039 1392  5071015 1392  
332356 5070997 1392  5070973 1392  5070954 1392  5070939 1392  5070915 1392  5070895 1394  
332357 5070875 1394  5070861 1394  5070837 1394  5070820 1392  5070804 1394  5070790 1394  
332358 5070775 1394  5070761 1394  5070740 1396  5070737 1394  5070718 1394  5070711 1396  
332359 5070704 1394  5070704 1394  5070693 1396  5070703 1394  5070702 1396  5070692 1396  
332360 5070704 1394  5070710 1398  5070712 1396  5070726 1396  5070726 1396  5070740 1396  
332361 5070752 1394  5070767 1398  5070778 1396  5070794 1394  5070812 1396  5070826 1396  
332362 5070840 1396  5070865 1396  5070879 1396  5070904 1394  5070927 1396  5070941 1396  
332363 5070965 1396  5070984 1396  5071012 1396  5071027 1396  5071052 1394  5071065 1396  
332364 5071079 1396  5071105 1394  5071114 1394  5071129 1394  5071145 1392  5071153 1394  
332365 5071164 1392  5071168 1392  5071175 1390  5071183 1392  5071188 1392  5071189 1390  
332366 5071189 1390  5071184 1390  5071186 1388  5071186 1388  5071175 1390  5071170 1390  
332367 5071165 1390  5071154 1392  5071141 1390  5071132 1390  5071117 1390  5071100 1388  
332368 5071082 1392  5071068 1392  5071054 1392  5071030 1392  5071015 1392  5070997 1392  
332369 5070982 1392  5070968 1392  5070954 1392  5070939 1392  5070919 1394  5070915 1392  
332370 5070895 1394  5070882 1392  5070875 1394  5070864 1396  5070861 1394  5070840 1396  
332371 5070842 1394  5070836 1396  5070826 1396  5070826 1396  5070825 1398  5070826 1396  
332372 5070825 1398  5070817 1396  5070826 1396  5070825 1398  5070836 1396  5070841 1396  
332373 5070850 1396  5070860 1396  5070864 1396  5070877 1398  5070890 1394  5070903 1396  
332374 5070915 1398  5070927 1396  5070941 1396  5070960 1396  5070968 1398  5070979 1396  
332375 5071003 1396  5071017 1396  5071035 1398  5071051 1396  5071065 1396  5071079 1396  
332376 5071094 1396  5071113 1396  5071117 1396  5071137 1396  5071140 1398  5071159 1398  
332377 5071164 1398  5071169 1398  5071178 1398  5071183 1398  5071183 1398  5071194 1396  
332378 5071193 1398  5071194 1396  5071194 1396  5071186 1394  5071184 1396  5071180 1396  
332379 5071172 1394  5071170 1396  5071165 1396  5071151 1396  5071141 1396  5071127 1396  
332380 5071117 1396  5071103 1396  5071084 1396  5071070 1396  5071051 1396  5071041 1396  
332381 5071017 1396  5071001 1398  5070986 1394  5070970 1396  5070951 1396  5070938 1394  
332382 5070919 1394  5070896 1392  5070882 1392  5070869 1390  5070855 1390  5070845 1390  
332383 5070831 1390  5070817 1390  5070807 1390  5070797 1390  5070785 1388  5070780 1388  
332384 5070778 1390  5070775 1388  5070775 1388  5070766 1388  5070775 1388  5070775 1388  
332385 5070780 1388  5070780 1388  5070785 1388  5070794 1388  5070799 1388  5070808 1388  
332386 5070818 1388  5070831 1390  5070847 1388  5070866 1388  5070879 1390  5070898 1390  
332387 5070917 1390  5070931 1390  5070955 1390  5070969 1390  5070990 1388  5071009 1388  
332388 5071031 1390  5071046 1390  5071070 1390  5071086 1388  5071098 1390  5071119 1388  
332389 5071141 1390  5071156 1390  5071165 1390  5071175 1390  5071188 1387  5071191 1388  
332390 5071199 1390  5071210 1388  5071214 1388  5071214 1388  5071214 1388  5071214 1388  
332391 5071214 1388  5071214 1388  5071210 1388  5071202 1387  5071191 1388  5071186 1388  
332392 5071178 1387  5071168 1387  5071149 1387  5071143 1388  5071125 1387  5071109 1388  
332393 5071090 1388  5071086 1388  5071071 1388  5071047 1388  5071033 1388  5071019 1388  
332394 5070990 1388  5070976 1388  5070966 1388  5070947 1388  5070933 1388  5070917 1390  
332395 5070898 1390  5070883 1390  5070877 1392  5070864 1390  5070855 1390  5070845 1390  
332396 5070840 1390  5070831 1390  5070820 1392  5070821 1390  5070817 1390  5070817 1390  
332397 5070817 1390  5070817 1390  5070817 1390  5070817 1390  5070821 1390  5070821 1390  
332398 5070831 1390  5070840 1390  5070844 1392  5070864 1390  5070869 1390  5070878 1390  
332399 5070884 1390  5070898 1390  5070909 1388  5070922 1390  5070941 1390  5070955 1390  
332400 5070963 1392  5070974 1390  5070989 1390  5071008 1390  5071022 1390  5071041 1390  
332401 5071056 1390  5071070 1390  5071074 1390  5071090 1388  5071098 1390  5071108 1390  
332402 5071122 1390  5071132 1390  5071132 1390  5071146 1390  5071146 1390  5071146 1390  
332403 5071156 1390  5071156 1390  5071156 1390  5071156 1390  5071146 1390  5071146 1390  
332404 5071146 1390  5071141 1390  5071132 1390  5071117 1390  5071108 1390  5071097 1392  
332405 5071084 1390  5071074 1390  5071065 1390  5071046 1390  5071031 1390  5071017 1390  
332406 5070998 1390  5070974 1390  5070965 1390  5070945 1390  5070928 1394  5070917 1390  
332407 5070896 1392  5070882 1392  5070867 1392  5070853 1392  5070844 1392  5070839 1392  
332408 5070820 1392  5070805 1392  5070796 1392  5070791 1392  5070782 1392  5070777 1392  
332409 5070775 1394  5070772 1392  5070770 1394  5070770 1394  5070772 1392  5070772 1392  
332410 5070774 1396  5070774 1396  5070780 1394  5070790 1394  5070794 1394  5070804 1394  
332411 5070813 1394  5070828 1394  5070842 1394  5070861 1394  5070874 1396  5070890 1394  
332412 5070904 1394  5070928 1394  5070942 1394  5070962 1394  5070981 1394  5070995 1394  
332413 5071014 1394  5071028 1394  5071043 1394  5071060 1396  5071070 1396  5071086 1394  
332414 5071105 1394  5071113 1396  5071127 1396  5071141 1396  5071153 1394  5071161 1396  
332415 5071161 1396  5071167 1394  5071165 1396  5071167 1394  5071167 1394  5071167 1394  
332416 5071165 1396  5071162 1394  5071153 1394  5071143 1394  5071138 1394  5071129 1394  
332417 5071119 1394  5071105 1394  5071095 1394  5071081 1394  5071067 1394  5071051 1396  
332418 5071038 1394  5071019 1394  5070995 1394  5070981 1394  5070966 1394  5070941 1396  
332419 5070927 1396  5070906 1392  5070892 1392  5070877 1392  5070861 1394  5070843 1392  
332420 5070829 1392  5070815 1392  5070796 1392  5070782 1392  5070775 1394  5070762 1392  
332421 5070763 1392  5070743 1392  5070740 1390  5070739 1392  5070731 1390  5070731 1390  
332422 5070721 1390  5070720 1392  5070721 1390  5070720 1392  5070720 1392  5070731 1390  
332423 5070729 1392  5070739 1392  5070745 1390  5070763 1392  5070774 1390  5070778 1390  
332424 5070791 1392  5070796 1392  5070817 1390  5070829 1392  5070845 1390  5070863 1392  
332425 5070877 1392  5070891 1392  5070906 1392  5070920 1392  5070939 1392  5070954 1392  
332426 5070968 1392  5070982 1392  5070997 1392  5071006 1392  5071021 1392  5071038 1394  
332427 5071044 1392  5071054 1392  5071068 1392  5071073 1392  5071082 1392  5071087 1392  
332428 5071086 1394  5071097 1392  5071098 1390  5071106 1392  5071106 1392  5071095 1394  
332429 5071097 1392  5071086 1394  5071086 1394  5071081 1394  5071073 1392  5071062 1394  
332430 5071051 1396  5071038 1394  5071027 1396  5071019 1394  5071003 1396  5070980 1394  
332431 5070969 1396  5070959 1398  5070941 1396  5070927 1396  5070912 1396  5070893 1396  
332432 5070880 1394  5070864 1396  5070850 1396  5070841 1396  5070826 1396  5070812 1396  
332433 5070802 1396  5070790 1394  5070778 1396  5070774 1396  5070769 1396  5070761 1394  
332434 5070759 1396  5070758 1398  5070759 1396  5070759 1396  5070761 1394  5070769 1396  
332435 5070774 1396  5070777 1398  5070788 1396  5070791 1398  5070802 1396  5070815 1398  
332436 5070836 1396  5070839 1398  5070858 1398  5070877 1398  5070892 1398  5070911 1398  
332437 5070925 1398  5070939 1398  5070963 1398  5070977 1398  5070992 1398  5071016 1398  
332438 5071035 1398  5071049 1398  5071064 1398  5071083 1398  5071102 1398  5071111 1398  
332439 5071126 1398  5071135 1398  5071140 1398  5071149 1398  5071159 1398  5071164 1398  
332440 5071164 1398  5071164 1398  5071170 1396  5071167 1400  5071167 1400  5071164 1398  
332441 5071164 1398  5071159 1398  5071149 1398  5071140 1398  5071135 1398  5071124 1400  
332442 5071111 1398  5071092 1398  5071083 1398  5071068 1398  5071049 1398  5071033 1400  
332443 5071016 1398  5070992 1398  5070978 1398  5070963 1398  5070938 1400  5070925 1398  
332444 5070901 1398  5070877 1398  5070863 1398  5070839 1398  5070823 1400  5070810 1398  
332445 5070791 1398  5070777 1398  5070767 1398  5070748 1398  5070739 1398  5070725 1398  
332446 5070715 1398  5070708 1400  5070701 1398  5070691 1398  5070690 1400  5070685 1400  
332447 5070685 1400  5070686 1398  5070686 1398  5070685 1400  5070690 1400  5070699 1400  
332448 5070709 1400  5070715 1398  5070723 1400  5070737 1400  5070756 1400  5070771 1400  
332449 5070775 1400  5070790 1400  5070809 1400  5070833 1400  5070847 1400  5070861 1400  
332450 5070876 1400  5070890 1400  5070909 1400  5070933 1400  5070947 1400  5070960 1402  
332451 5070981 1400  5071000 1400  5071013 1402  5071032 1402  5071046 1402  5071061 1402  
332452 5071075 1402  5071078 1403  5071099 1402  5071108 1402  5071111 1403  5071123 1402  
332453 5071123 1402  5071132 1402  5071131 1403  5071131 1404  5071131 1404  5071121 1404  
332454 5071123 1402  5071111 1404  5071107 1404  5071097 1403  5071089 1402  5071075 1402  
332455 5071065 1402  5071054 1403  5071044 1403  5071032 1402  5071006 1403  5070998 1402  
332456 5070974 1402  5070960 1402  5070956 1402  5070932 1402  5070921 1403  5070908 1402  
332457 5070882 1404  5070874 1402  5070860 1402  5070845 1402  5070836 1402  5070822 1402  
332458 5070813 1400  5070807 1402  5070799 1400  5070790 1400  5070790 1400  5070790 1400  
332459 5070785 1400  5070790 1400  5070790 1400  5070790 1400  5070799 1400  5070810 1398  
332460 5070812 1396  5070825 1398  5070836 1396  5070841 1396  5070858 1398  5070874 1396  
332461 5070879 1396  5070895 1394  5070914 1394  5070928 1394  5070952 1394  5070968 1392  
332462 5070982 1392  5071006 1392  5071022 1390  5071041 1390  5071065 1390  5071073 1392  
332463 5071089 1390  5071108 1390  5071124 1388  5071141 1390  5071146 1390  5071165 1390  
332464 5071170 1390  5071186 1388  5071189 1390  5071199 1390  5071208 1390  5071213 1390  
332465 5071214 1388  5071214 1388  5071214 1388  5071214 1388  5071214 1388  5071210 1388  
332466 5071200 1388  5071191 1388  5071186 1388  5071171 1388  5071167 1388  5071147 1388  
332467 5071132 1390  5071119 1388  5071089 1390  5071074 1390  5071057 1388  5071042 1388  
332468 5071017 1390  5070998 1390  5070969 1390  5070947 1388  5070933 1388  5070898 1390  
332469 5070883 1390  5070864 1390  5070840 1390  5070818 1388  5070799 1388  5070778 1390  
332470 5070765 1388  5070746 1388  5070723 1388  5070718 1388  5070699 1388  5070694 1388  
332471 5070683 1390  5070675 1388  5070665 1388  5070665 1388  5070667 1387  5070656 1388  
332472 5070656 1388  5070664 1390  5070673 1390  5070675 1388  5070678 1390  5070683 1390  
332473 5070699 1388  5070707 1390  5070721 1390  5070740 1390  5070755 1390  5070773 1390  
332474 5070783 1390  5070797 1390  5070818 1388  5070840 1390  5070866 1388  5070883 1390  
332475 5070899 1388  5070917 1390  5070941 1390  5070965 1390  5070984 1390  5071009 1388  
332476 5071022 1390  5071041 1390  5071057 1388  5071071 1388  5071084 1390  5071098 1390  
332477 5071108 1390  5071122 1390  5071130 1392  5071141 1390  5071146 1390  5071156 1390  
332478 5071154 1392  5071165 1390  5071164 1392  5071165 1390  5071154 1392  5071146 1390  
332479 5071140 1392  5071130 1392  5071121 1392  5071116 1392  5071095 1394  5071086 1394  
332480 5071081 1394  5071065 1396  5071052 1394  5071038 1394  5071012 1396  5071004 1394  
332481 5070979 1396  5070965 1396  5070949 1398  5070934 1398  5070917 1396  5070901 1398  
332482 5070885 1400  5070872 1398  5070858 1398  5070840 1396  5070834 1398  5070825 1398  
332483 5070815 1398  5070810 1398  5070810 1398  5070802 1396  5070802 1396  5070802 1396  
332484 5070802 1396  5070802 1396  5070804 1394  5070813 1394  5070828 1394  5070828 1394  
332485 5070842 1394  5070850 1396  5070866 1394  5070880 1394  5070893 1396  5070914 1394  
332486 5070930 1392  5070954 1392  5070966 1394  5070981 1394  5071006 1392  5071021 1392  
332487 5071043 1394  5071063 1392  5071081 1394  5071095 1394  5071114 1394  5071130 1392  
332488 5071154 1392  5071164 1392  5071173 1392  5071188 1392  5071207 1392  5071211 1392  
332489 5071230 1392  5071240 1392  5071241 1390  5071245 1392  5071255 1392  5071256 1390  
332490 5071254 1392  5071246 1390  5071245 1392  5071241 1390  5071232 1390  5071221 1392  
332491 5071208 1390  5071197 1392  5071175 1390  5071170 1390  5071156 1390  5071132 1390  
332492 5071106 1392  5071084 1390  5071065 1390  5071041 1390  5071017 1390  5070984 1390  
332493 5070965 1390  5070941 1390  5070917 1390  5070891 1392  5070869 1390  5070840 1390  
332494 5070817 1390  5070797 1390  5070778 1390  5070755 1390  5070731 1390  5070716 1390  
332495 5070697 1390  5070683 1390  5070673 1390  5070654 1390  5070649 1390  5070640 1390  
332496 5070630 1390  5070621 1390  5070619 1392  5070619 1392  5070616 1390  5070621 1390  
332497 5070632 1388  5070630 1390  5070649 1390  5070654 1390  5070664 1390  5070678 1390  
332498 5070681 1392  5070697 1390  5070716 1390  5070730 1390  5070756 1388  5070772 1392  
332499 5070793 1390  5070817 1390  5070840 1390  5070864 1390  5070883 1390  5070907 1390  
332500 5070922 1390  5070954 1392  5070969 1390  5070987 1392  5071015 1392  5071030 1392  
332501 5071054 1392  5071068 1392  5071081 1394  5071106 1392  5071116 1392  5071132 1390  
332502 5071140 1392  5071145 1392  5071154 1392  5071164 1392  5071164 1392  5071164 1392  
332503 5071164 1392  5071164 1392  5071164 1392  5071144 1392  5071144 1392  5071140 1392  
332504 5071119 1394  5071114 1394  5071105 1394  5071086 1394  5071071 1394  5071062 1394  
332505 5071043 1394  5071028 1394  5071012 1396  5070993 1396  5070969 1396  5070960 1396  
332506 5070941 1396  5070917 1396  5070903 1396  5070887 1398  5070872 1398  5070864 1396  
332507 5070850 1396  5070834 1398  5070825 1398  5070810 1398  5070801 1398  5070791 1398  
332508 5070791 1398  5070791 1398  5070787 1398  5070790 1400  5070790 1400  5070791 1398  
332509 5070791 1398  5070799 1400  5070809 1400  5070825 1398  5070833 1400  5070849 1398  
332510 5070861 1400  5070871 1400  5070887 1398  5070911 1398  5070914 1400  5070938 1400  
332511 5070957 1400  5070966 1400  5070992 1398  5071009 1400  5071033 1400  5071059 1398  
332512 5071068 1398  5071092 1398  5071110 1400  5071135 1398  5071149 1398  5071164 1398  
332513 5071178 1398  5071192 1398  5071207 1398  5071216 1398  5071228 1396  5071235 1398  
332514 5071240 1398  5071250 1398  5071250 1398  5071250 1398  5071250 1398  5071240 1398  
332515 5071240 1398  5071235 1398  5071224 1400  5071207 1398  5071201 1400  5071181 1400  
332516 5071168 1398  5071158 1400  5071135 1398  5071111 1398  5071082 1398  5071062 1400  
332517 5071038 1400  5071016 1398  5070981 1400  5070963 1398  5070933 1400  5070909 1400  
332518 5070876 1400  5070858 1398  5070833 1400  5070798 1402  5070775 1400  5070756 1400  
332519 5070732 1400  5070707 1402  5070683 1402  5070664 1402  5070639 1403  5070621 1402  
332520 5070610 1403  5070596 1403  5070586 1403  5070581 1403  5070573 1402  5070567 1403  
332521 5070562 1403  5070562 1403  5070565 1400  5070565 1400  5070565 1400  5070571 1398  
332522 5070576 1398  5070586 1398  5070602 1396  5070616 1396  5070635 1396  5070650 1396  
332523 5070669 1396  5070678 1396  5070703 1394  5070726 1396  5070751 1394  5070775 1394  
332524 5070793 1396  5070818 1394  5070842 1394  5070866 1394  5070895 1394  5070919 1394  
332525 5070944 1392  5070966 1394  5070980 1394  5071006 1392  5071028 1394  5071043 1394  
332526 5071062 1394  5071073 1392  5071086 1394  5071095 1394  5071114 1394  5071121 1392  
332527 5071129 1394  5071138 1394  5071138 1394  5071138 1394  5071138 1394  5071140 1392  
332528 5071130 1392  5071129 1394  5071119 1394  5071114 1394  5071106 1392  5071087 1392  
332529 5071073 1392  5071067 1394  5071044 1392  5071038 1394  5071014 1394  5070995 1394  
332530 5070973 1392  5070962 1394  5070938 1394  5070919 1394  5070895 1394  5070882 1392  
332531 5070867 1392  5070853 1392  5070828 1394  5070818 1394  5070805 1392  5070794 1394  
332532 5070780 1394  5070775 1394  5070770 1394  5070761 1394  5070751 1394  5070751 1394  
332533 5070751 1394  5070751 1394  5070751 1394  5070761 1394  5070759 1396  5070769 1396  
332534 5070775 1394  5070790 1394  5070802 1396  5070818 1394  5070826 1396  5070842 1394  
332535 5070866 1394  5070879 1396  5070893 1396  5070919 1394  5070938 1394  5070951 1396  
332536 5070971 1394  5070985 1394  5071012 1396  5071036 1396  5071052 1394  5071070 1396  
332537 5071094 1396  5071113 1396  5071129 1394  5071153 1394  5071162 1394  5071171 1394  
332538 5071186 1394  5071196 1394  5071208 1396  5071220 1394  5071220 1394  5071229 1394  
332539 5071228 1396  5071227 1396  5071229 1394  5071229 1394  5071220 1394  5071210 1394  
332540 5071204 1396  5071184 1396  5071172 1394  5071162 1394  5071143 1394  5071117 1396  
332541 5071103 1396  5071078 1398  5071049 1398  5071025 1398  5071003 1396  5070968 1398  
332542 5070949 1398  5070915 1398  5070892 1398  5070861 1400  5070834 1398  5070801 1398  
332543 5070772 1398  5070748 1398  5070726 1396  5070691 1398  5070673 1396  5070648 1398  
332544 5070624 1398  5070610 1398  5070586 1398  5070570 1400  5070557 1398  5070546 1400  
332545 5070543 1398  5070533 1398  5070514 1398  5070513 1400  5070509 1398  5070508 1400  
332546 5070508 1400  5070513 1400  5070522 1400  5070532 1400  5070548 1398  5070556 1400  
332547 5070571 1398  5070586 1398  5070599 1400  5070613 1400  5070642 1400  5070666 1400  
332548 5070675 1400  5070708 1400  5070732 1400  5070758 1398  5070775 1400  5070809 1400  
332549 5070833 1400  5070857 1400  5070885 1400  5070909 1400  5070935 1398  5070957 1400  
332550 5070977 1398  5071001 1398  5071014 1400  5071039 1398  5071062 1400  5071078 1398  
332551 5071091 1400  5071100 1400  5071114 1400  5071124 1400  5071135 1398  5071140 1398  
332552 5071140 1398  5071140 1398  5071140 1398  5071135 1398  5071134 1400  5071126 1398  
332553 5071114 1400  5071100 1400  5071092 1398  5071083 1398  5071068 1398  5071049 1398  
332554 5071035 1398  5071016 1398  5071001 1398  5070977 1398  5070963 1398  5070949 1398  
332555 5070925 1398  5070910 1398  5070890 1400  5070871 1400  5070858 1398  5070839 1398  
332556 5070825 1398  5070810 1398  5070791 1398  5070787 1398  5070774 1396  5070769 1396  
332557 5070759 1396  5070748 1398  5070748 1398  5070740 1396  5070739 1398  5070748 1398  
332558 5070750 1396  5070759 1396  5070767 1398  5070772 1398  5070777 1398  5070787 1398  
332559 5070801 1398  5070815 1398  5070825 1398  5070839 1398  5070863 1398  5070888 1396  
332560 5070903 1396  5070925 1398  5070939 1398  5070963 1398  5070982 1398  5071011 1398  
332561 5071035 1398  5071049 1398  5071068 1398  5071092 1398  5071116 1398  5071134 1400  
332562 5071159 1398  5071176 1400  5071193 1398  5071207 1398  5071226 1398  5071235 1398  
332563 5071240 1398  5071250 1398  5071259 1398  5071259 1398  5071261 1396  5071259 1398  
332564 5071250 1398  5071251 1396  5071240 1398  5071226 1398  5071218 1396  5071194 1396  
332565 5071179 1396  5071165 1396  5071140 1398  5071116 1398  5071092 1398  5071070 1396  
332566 5071041 1396  5071016 1398  5070984 1396  5070965 1396  5070934 1398  5070892 1398  
332567 5070874 1396  5070839 1398  5070812 1396  5070788 1396  5070758 1398  5070735 1396  
332568 5070702 1396  5070676 1398  5070659 1396  5070635 1396  5070616 1396  5070592 1396  
332569 5070573 1396  5070557 1398  5070543 1398  5070533 1398  5070524 1398  5070516 1396  
332570 5070511 1396  5070501 1396  5070501 1396  5070501 1396  5070503 1394  5070513 1394  
332571 5070517 1394  5070536 1394  5070546 1394  5070562 1392  5070575 1394  5070580 1394  
332572 5070602 1396  5070627 1394  5070646 1394  5070670 1394  5070691 1392  5070718 1394  
332573 5070742 1394  5070777 1392  5070794 1394  5070818 1394  5070843 1392  5070877 1392  
332574 5070896 1392  5070930 1392  5070944 1392  5070972 1392  5070996 1392  5071020 1392  
332575 5071039 1392  5071068 1392  5071081 1394  5071097 1392  5071116 1392  5071129 1394  
332576 5071138 1394  5071144 1392  5071154 1392  5071154 1392  5071156 1390  5071154 1392  
332577 5071156 1390  5071154 1392  5071144 1392  5071140 1392  5071130 1392  5071119 1394  
332578 5071106 1392  5071097 1392  5071082 1392  5071067 1394  5071054 1392  5071039 1392  
332579 5071014 1394  5070995 1394  5070982 1392  5070962 1394  5070938 1394  5070919 1394  
332580 5070895 1394  5070880 1394  5070866 1394  5070850 1396  5070836 1396  5070818 1394  
332581 5070802 1396  5070793 1396  5070778 1396  5070774 1396  5070772 1398  5070769 1396  
332582 5070769 1396  5070759 1396  5070759 1396  5070769 1396  5070769 1396  5070774 1396  
332583 5070774 1396  5070788 1396  5070794 1394  5070804 1394  5070818 1394  5070837 1394  
332584 5070850 1396  5070866 1394  5070888 1396  5070904 1394  5070927 1396  5070951 1396  
332585 5070965 1396  5070984 1396  5071012 1396  5071036 1396  5071060 1396  5071070 1396  
332586 5071094 1396  5071127 1396  5071143 1394  5071165 1396  5071179 1396  5071194 1396  
332587 5071218 1396  5071227 1396  5071243 1394  5071253 1394  5071267 1394  5071272 1394  
332588 5071272 1394  5071280 1396  5071280 1396  5071270 1396  5071270 1396  5071267 1394  
332589 5071262 1394  5071243 1394  5071238 1394  5071218 1396  5071196 1394  5071179 1396  
332590 5071162 1394  5071138 1394  5071105 1394  5071082 1392  5071052 1394  5071020 1392  
332591 5070995 1394  5070966 1394  5070937 1394  5070904 1394  5070875 1394  5070840 1396  
332592 5070818 1394  5070790 1394  5070759 1396  5070726 1396  5070702 1396  5070678 1396  
332593 5070659 1396  5070635 1396  5070611 1396  5070586 1398  5070571 1398  5070557 1398  
332594 5070543 1398  5070524 1398  5070514 1398  5070509 1398  5070500 1398  5070500 1398  
332595 5070490 1398  5070498 1400  5070508 1400  5070508 1400  5070522 1400  5070532 1400  
332596 5070544 1402  5070565 1400  5070573 1402  5070589 1400  5070613 1400  5070632 1400  
332597 5070656 1400  5070675 1400  5070699 1400  5070731 1402  5070755 1402  5070774 1402  
332598 5070809 1400  5070836 1402  5070860 1402  5070890 1400  5070912 1402  5070946 1402  
332599 5070963 1403  5070989 1402  5071012 1402  5071036 1402  5071056 1402  5071065 1402  
332600 5071089 1402  5071108 1402  5071123 1402  5071134 1400  5071137 1402  5071146 1402  
332601 5071156 1402  5071156 1402  5071156 1402  5071161 1402  5071156 1402  5071156 1402  
332602 5071145 1403  5071137 1402  5071132 1402  5071121 1403  5071113 1402  5071097 1403  
332603 5071078 1403  5071065 1402  5071054 1403  5071036 1402  5071013 1402  5070998 1402  
332604 5070973 1403  5070955 1402  5070936 1402  5070922 1402  5070898 1402  5070885 1400  
332605 5070860 1402  5070857 1400  5070831 1402  5070822 1402  5070809 1400  5070788 1402  
332606 5070784 1402  5070775 1400  5070771 1400  5070766 1400  5070764 1402  5070756 1400  
332607 5070766 1400  5070764 1402  5070764 1402  5070772 1398  5070774 1402  5070783 1402  
332608 5070788 1402  5070807 1402  5070822 1402  5070836 1402  5070861 1400  5070876 1400  
332609 5070900 1400  5070924 1400  5070938 1400  5070963 1398  5070982 1398  5071011 1398  
332610 5071035 1398  5071059 1398  5071079 1396  5071105 1394  5071129 1394  5071153 1394  
332611 5071172 1394  5071196 1394  5071210 1394  5071227 1396  5071242 1396  5071262 1394  
332612 5071267 1394  5071281 1394  5071285 1396  5071294 1396  5071294 1396  5071294 1396  
332613 5071294 1396  5071296 1394  5071286 1394  5071281 1394  5071273 1392  5071262 1394  
332614 5071253 1394  5071239 1394  5071208 1396  5071186 1394  5071167 1394  5071143 1394  
332615 5071119 1394  5071097 1392  5071067 1394  5071038 1394  5071004 1394  5070969 1396  
332616 5070952 1394  5070919 1394  5070880 1394  5070861 1394  5070828 1394  5070794 1394  
332617 5070769 1396  5070742 1394  5070712 1396  5070688 1396  5070659 1396  5070635 1396  
332618 5070616 1396  5070591 1398  5070576 1398  5070567 1398  5070548 1398  5070543 1398  
332619 5070533 1398  5070522 1400  5070514 1398  5070513 1400  5070513 1400  5070514 1398  
332620 5070522 1400  5070532 1400  5070548 1398  5070556 1400  5070567 1398  5070576 1398  
332621 5070589 1400  5070608 1400  5070634 1398  5070648 1398  5070670 1400  5070691 1398  
332622 5070715 1398  5070737 1400  5070767 1398  5070790 1400  5070812 1402  5070837 1400  
332623 5070871 1400  5070892 1398  5070924 1400  5070949 1398  5070966 1400  5070990 1400  
332624 5071011 1398  5071033 1400  5071049 1398  5071067 1400  5071081 1400  5071100 1400  
332625 5071110 1400  5071124 1400  5071132 1402  5071137 1402  5071148 1400  5071148 1400  
332626 5071146 1402  5071148 1400  5071138 1400  5071137 1402  5071138 1400  5071132 1402  
332627 5071123 1402  5071111 1403  5071099 1402  5071078 1403  5071065 1402  5071056 1402  
332628 5071037 1402  5071021 1403  5071006 1403  5070978 1403  5070963 1403  5070956 1402  
332629 5070930 1403  5070912 1402  5070887 1403  5070873 1404  5070858 1404  5070844 1403  
332630 5070831 1402  5070810 1403  5070806 1403  5070796 1403  5070782 1403  5070772 1403  
332631 5070768 1404  5070763 1403  5070763 1403  5070763 1403  5070763 1403  5070753 1403  
332632 5070764 1402  5070768 1403  5070772 1403  5070782 1403  5070796 1403  5070810 1403  
332633 5070820 1403  5070844 1403  5070858 1403  5070873 1403  5070897 1404  5070911 1403  
332634 5070935 1403  5070959 1403  5070978 1403  5071006 1403  5071030 1403  5071054 1403  
332635 5071073 1404  5071097 1403  5071121 1403  5071135 1403  5071161 1402  5071178 1403  
332636 5071199 1402  5071212 1404  5071232 1402  5071245 1403  5071255 1404  5071266 1402  
332637 5071274 1404  5071274 1403  5071278 1403  5071279 1403  5071274 1404  5071275 1402  
332638 5071264 1403  5071260 1404  5071255 1404  5071236 1403  5071221 1403  5071202 1403  
332639 5071188 1403  5071164 1403  5071145 1404  5071121 1403  5071097 1403  5071073 1403  
332640 5071046 1402  5071021 1403  5070997 1403  5070959 1403  5070935 1403  5070908 1402  
332641 5070874 1402  5070845 1402  5070822 1402  5070788 1402  5070763 1403  5070734 1403  
332642 5070707 1402  5070683 1402  5070664 1402  5070640 1402  5070610 1404  5070597 1402  
332643 5070582 1404  5070568 1402  5070562 1404  5070543 1403  5070538 1403  5070540 1402  
332644 5070530 1402  5070530 1402  5070529 1403  5070529 1403  5070529 1403  5070540 1402  
332645 5070544 1402  5070564 1402  5070568 1402  5070581 1403  5070596 1403  5070621 1402  
332646 5070640 1402  5070664 1402  5070672 1403  5070696 1403  5070720 1404  5070753 1404  
332647 5070772 1403  5070806 1403  5070830 1403  5070855 1402  5070882 1404  5070906 1404  
332648 5070930 1403  5070959 1404  5070978 1403  5071006 1404  5071030 1403  5071054 1404  
332649 5071073 1403  5071088 1403  5071107 1404  5071111 1404  5071131 1403  5071145 1403  
332650 5071155 1403  5071155 1403  5071159 1404  5071164 1403  5071164 1403  5071164 1404  
332651 5071164 1403  5071159 1403  5071159 1403  5071156 1402  5071137 1402  5071131 1403  
332652 5071123 1402  5071107 1403  5071088 1403  5071073 1404  5071059 1403  5071044 1403  
332653 5071032 1402  5071008 1402  5070987 1403  5070964 1404  5070954 1403  5070935 1403  
332654 5070911 1403  5070897 1404  5070882 1403  5070868 1403  5070854 1403  5070834 1403  
332655 5070831 1402  5070810 1403  5070806 1404  5070796 1404  5070787 1404  5070782 1403  
332656 5070772 1403  5070772 1403  5070772 1403  5070772 1404  5070782 1403  5070787 1403  
332657 5070787 1403  5070806 1403  5070820 1403  5070828 1405  5070844 1403  5070858 1403  
332658 5070873 1404  5070897 1403  5070911 1404  5070933 1405  5070959 1404  5070973 1404  
332659 5070997 1404  5071021 1404  5071043 1405  5071064 1404  5071088 1404  5071111 1403  
332660 5071135 1404  5071159 1404  5071177 1405  5071197 1403  5071212 1403  5071231 1403  
332661 5071255 1403  5071260 1403  5071274 1404  5071288 1403  5071298 1403  5071298 1403  
332662 5071303 1403  5071303 1403  5071302 1403  5071298 1404  5071298 1404  5071278 1403  
332663 5071274 1403  5071264 1403  5071256 1402  5071236 1403  5071221 1403  5071202 1404  
332664 5071178 1404  5071159 1404  5071135 1404  5071111 1404  5071088 1403  5071065 1402  
332665 5071035 1403  5071011 1403  5070978 1403  5070956 1402  5070930 1403  5070897 1404  
332666 5070868 1404  5070844 1403  5070822 1402  5070787 1403  5070768 1403  5070744 1403  
332667 5070720 1403  5070697 1402  5070682 1403  5070663 1404  5070653 1403  5070639 1403  
332668 5070631 1402  5070611 1402  5070607 1402  5070596 1403  5070596 1403  5070586 1403  
332669 5070596 1403  5070596 1403  5070605 1404  5070611 1402  5070620 1403  5070639 1403  
332670 5070643 1403  5070664 1402  5070672 1403  5070686 1403  5070705 1403  5070729 1403  
332671 5070753 1403  5070768 1403  5070796 1403  5070820 1403  5070844 1403  5070868 1404  
332672 5070897 1404  5070921 1403  5070944 1403  5070963 1403  5070997 1403  5071021 1403  
332673 5071045 1404  5071064 1404  5071078 1403  5071107 1403  5071121 1403  5071135 1403  
332674 5071155 1403  5071159 1403  5071174 1403  5071178 1404  5071188 1404  5071197 1403  
332675 5071202 1404  5071202 1403  5071202 1403  5071202 1403  5071202 1403  5071202 1403  
332676 5071197 1403  5071188 1404  5071178 1404  5071164 1403  5071156 1402  5071145 1403  
332677 5071131 1403  5071111 1404  5071097 1403  5071078 1403  5071064 1403  5071044 1403  
332678 5071021 1404  5071006 1403  5070987 1404  5070973 1403  5070954 1403  5070932 1402  
332679 5070911 1403  5070896 1403  5070884 1402  5070860 1402  5070854 1403  5070834 1403  
332680 5070831 1402  5070812 1402  5070806 1403  5070798 1402  5070796 1403  5070788 1402  
332681 5070787 1403  5070787 1404  5070788 1402  5070796 1403  5070806 1404  5070812 1402  
332682 5070820 1403  5070834 1403  5070844 1403  5070860 1402  5070873 1403  5070896 1403  
332683 5070912 1402  5070930 1403  5070956 1402  5070963 1403  5070987 1403  5071013 1402  
332684 5071035 1403  5071054 1403  5071073 1403  5071099 1402  5071121 1403  5071135 1403  
332685 5071161 1402  5071175 1402  5071189 1402  5071212 1403  5071231 1403  5071236 1403  
332686 5071256 1402  5071260 1403  5071264 1404  5071274 1403  5071274 1404  5071275 1402  
332687 5071274 1403  5071275 1402  5071274 1404  5071266 1402  5071261 1402  5071255 1403  
332688 5071236 1403  5071223 1402  5071202 1403  5071197 1403  5071175 1402  5071161 1402  
332689 5071137 1402  5071123 1402  5071099 1402  5071075 1402  5071046 1402  5071022 1402  
332690 5070989 1402  5070960 1402  5070935 1404  5070912 1402  5070884 1402  5070860 1402  
332691 5070831 1402  5070807 1402  5070784 1402  5070764 1402  5070747 1400  5070721 1402  
332692 5070699 1400  5070683 1402  5070669 1402  5070655 1402  5070642 1400  5070631 1402  
332693 5070621 1402  5070611 1402  5070607 1402  5070607 1402  5070607 1402  5070607 1402  
332694 5070611 1402  5070610 1404  5070620 1404  5070640 1402  5070645 1402  5070664 1402  
332695 5070669 1402  5070688 1402  5070707 1402  5070720 1404  5070744 1403  5070764 1402  
332696 5070782 1403  5070806 1403  5070830 1403  5070854 1404  5070873 1403  5070898 1402  
332697 5070921 1404  5070944 1403  5070973 1403  5070987 1403  5071011 1403  5071037 1402  
332698 5071054 1404  5071073 1403  5071088 1403  5071107 1403  5071131 1403  5071146 1402  
332699 5071155 1404  5071159 1403  5071164 1403  5071174 1403  5071190 1402  5071190 1402  
332700 5071190 1402  5071188 1403  5071190 1402  5071180 1402  5071180 1402  5071175 1402  
332701 5071164 1404  5071161 1402  5071156 1402  5071137 1402  5071121 1404  5071108 1402  
332702 5071088 1404  5071073 1404  5071059 1403  5071035 1404  5071013 1402  5070999 1402  
332703 5070973 1404  5070954 1404  5070936 1402  5070922 1402  5070897 1403  5070882 1404  
332704 5070860 1402  5070846 1402  5070831 1402  5070820 1403  5070810 1403  5070796 1404  
332705 5070787 1404  5070772 1404  5070768 1403  5070768 1403  5070763 1403  5070768 1404  
332706 5070768 1403  5070768 1403  5070768 1404  5070774 1402  5070787 1403  5070796 1404  
332707 5070806 1404  5070820 1404  5070835 1404  5070859 1404  5070873 1404  5070887 1403  
332708 5070908 1402  5070932 1402  5070946 1402  5070965 1402  5070987 1404  5071008 1402  
332709 5071030 1403  5071044 1403  5071064 1403  5071078 1403  5071107 1403  5071132 1402  
332710 5071156 1402  5071159 1403  5071175 1402  5071190 1402  5071204 1402  5071212 1404  
332711 5071231 1403  5071231 1404  5071236 1403  5071237 1402  5071247 1402  5071247 1402  
332712 5071256 1402  5071247 1402  5071239 1400  5071232 1402  5071223 1402  5071213 1402  
332713 5071199 1402  5071180 1402  5071175 1402  5071158 1400  5071137 1402  5071123 1402  
332714 5071100 1400  5071076 1400  5071057 1400  5071033 1400  5071001 1398  5070982 1398  
332715 5070963 1398  5070939 1398  5070911 1398  5070887 1398  5070863 1398  5070839 1398  
332716 5070826 1396  5070793 1396  5070778 1396  5070758 1398  5070735 1396  5070717 1396  
332717 5070702 1396  5070688 1396  5070672 1398  5070669 1396  5070650 1396  5070650 1396  
332718 5070645 1396  5070645 1396  5070635 1396  5070635 1396  5070635 1396  5070645 1396  
332719 5070650 1396  5070659 1396  5070670 1394  5070680 1394  5070688 1396  5070702 1396  
332720 5070717 1396  5070737 1394  5070751 1394  5070774 1396  5070790 1394  5070813 1394  
332721 5070828 1394  5070852 1394  5070875 1394  5070895 1394  5070919 1394  5070941 1396  
332722 5070966 1394  5070984 1396  5071014 1394  5071038 1394  5071051 1396  5071071 1394  
332723 5071086 1394  5071103 1396  5071118 1396  5071141 1396  5071151 1396  5071161 1396  
332724 5071167 1394  5071170 1396  5071180 1396  5071184 1396  5071184 1396  5071184 1396  
332725 5071186 1394  5071186 1394  5071180 1396  5071181 1394  5071172 1394  5071167 1394  
332726 5071162 1394  5071143 1394  5071130 1392  5071121 1392  5071105 1394  5071086 1394  
332727 5071068 1392  5071044 1392  5071030 1392  5071004 1394  5070986 1394  5070966 1394  
332728 5070954 1392  5070930 1392  5070915 1392  5070892 1392  5070877 1392  5070861 1394  
332729 5070844 1392  5070829 1392  5070813 1394  5070796 1392  5070790 1394  5070777 1392  
332730 5070772 1392  5070761 1394  5070761 1394  5070762 1392  5070753 1392  5070753 1392  
332731 5070762 1392  5070763 1392  5070762 1392  5070772 1392  5070778 1390  5070793 1390  
332732 5070794 1394  5070815 1392  5070820 1392  5070839 1392  5070852 1394  5070866 1394  
332733 5070882 1392  5070895 1394  5070919 1394  5070939 1392  5070952 1394  5070971 1394  
332734 5070985 1394  5071006 1392  5071019 1394  5071044 1392  5071062 1394  5071071 1394  
332735 5071086 1394  5071114 1394  5071129 1394  5071141 1396  5071151 1396  5071165 1396  
332736 5071170 1396  5071180 1396  5071184 1396  5071196 1394  5071196 1394  5071196 1394  
332737 5071196 1394  5071196 1394  5071186 1394  5071186 1394  5071181 1394  5071173 1392  
332738 5071162 1394  5071144 1392  5071138 1394  5071121 1392  5071105 1394  5071086 1394  
332739 5071073 1392  5071054 1392  5071038 1394  5071014 1394  5070993 1396  5070971 1394  
332740 5070952 1394  5070928 1394  5070904 1394  5070880 1394  5070866 1394  5070841 1396  
332741 5070818 1394  5070801 1398  5070777 1398  5070767 1398  5070747 1400  5070737 1400  
332742 5070721 1402  5070707 1402  5070699 1400  5070688 1402  5070683 1402  5070674 1402  
332743 5070674 1402  5070669 1402  5070669 1402  5070669 1402  5070675 1400  5070683 1402  
332744 5070688 1402  5070697 1402  5070707 1402  5070721 1402  5070732 1400  5070746 1400  
332745 5070767 1398  5070777 1398  5070793 1396  5070812 1396  5070837 1394  5070852 1394  
332746 5070875 1394  5070895 1394  5070920 1392  5070945 1390  5070968 1392  5070987 1392  
332747 5071017 1390  5071039 1392  5071054 1392  5071073 1392  5071089 1390  5071106 1392  
332748 5071122 1390  5071140 1392  5071156 1390  5071170 1390  5071175 1390  5071184 1390  
332749 5071197 1392  5071199 1390  5071199 1390  5071207 1392  5071207 1392  5071208 1390  
332750 5071210 1388  5071199 1390  5071197 1392  5071188 1392  5071183 1392  5071170 1390  
332751 5071164 1392  5071146 1390  5071130 1392  5071116 1392  5071100 1388  5071076 1388  
332752 5071066 1388  5071042 1388  5071023 1388  5071001 1387  5070987 1387  5070969 1385  
332753 5070950 1385  5070928 1383  5070902 1385  5070890 1383  5070877 1381  5070853 1381  
332754 5070838 1381  5070829 1381  5070814 1381  5070802 1379  5070788 1379  5070783 1379  
332755 5070773 1379  5070764 1379  5070754 1379  5070757 1375  5070749 1379  5070749 1379  
332756 5070752 1375  5070754 1379  5070754 1379  5070764 1379  5070773 1379  5070786 1375  
332757 5070792 1379  5070805 1375  5070816 1379  5070834 1375  5070853 1375  5070864 1379  
332758 5070891 1375  5070902 1379  5070917 1379  5070940 1379  5070958 1375  5070978 1379  
332759 5070998 1379  5071020 1375  5071043 1375  5071055 1379  5071077 1375  5071093 1379  
332760 5071107 1379  5071127 1379  5071150 1379  5071155 1379  5071174 1379  5071184 1379  
332761 5071184 1379  5071198 1379  5071211 1375  5071221 1375  5071220 1375  5071221 1375  
332762 5071220 1375  5071221 1375  5071211 1375  5071211 1375  5071203 1373  5071196 1375  
332763 5071189 1373  5071184 1373  5071169 1373  5071157 1372  5071145 1373  5071122 1373  
332764 5071103 1373  5071088 1373  5071080 1372  5071055 1373  5071036 1373  5071013 1372  
332765 5070999 1372  5070980 1372  5070961 1372  5070937 1372  5070923 1371  5070897 1373  
332766 5070884 1372  5070861 1372  5070846 1372  5070822 1371  5070808 1371  5070798 1371  
332767 5070789 1372  5070779 1372  5070760 1372  5070757 1370  5070748 1370  5070738 1370  
332768 5070736 1371  5070738 1370  5070738 1370  5070736 1372  5070746 1372  5070756 1372  
332769 5070760 1372  5070760 1372  5070768 1373  5070789 1371  5070798 1371  5070811 1373  
332770 5070830 1373  5070836 1371  5070856 1371  5070870 1372  5070894 1372  5070913 1372  
332771 5070932 1372  5070946 1372  5070970 1372  5070990 1372  5071005 1370  5071032 1372  
332772 5071047 1372  5071071 1372  5071090 1372  5071106 1370  5071123 1371  5071147 1372  
332773 5071162 1372  5071171 1371  5071180 1372  5071190 1371  5071204 1372  5071214 1371  
332774 5071215 1370  5071224 1371  5071222 1373  5071228 1371  5071228 1372  5071224 1372  
332775 5071224 1371  5071214 1372  5071204 1372  5071200 1372  5071183 1373  5071180 1372  
332776 5071162 1372  5071145 1373  5071133 1372  5071113 1371  5071090 1372  5071071 1371  
332777 5071056 1372  5071032 1372  5071012 1373  5070989 1371  5070970 1372  5070946 1372  
332778 5070932 1372  5070908 1372  5070894 1372  5070870 1372  5070848 1370  5070832 1372  
332779 5070808 1372  5070792 1373  5070778 1373  5070759 1373  5070744 1373  5070736 1372  
332780 5070721 1373  5070709 1375  5070706 1373  5070705 1375  5070695 1375  5070696 1373  
332781 5070690 1375  5070690 1375  5070695 1375  5070697 1373  5070705 1375  5070709 1375  
332782 5070721 1373  5070733 1375  5070743 1375  5070757 1375  5070778 1373  5070791 1375  
332783 5070805 1375  5070819 1375  5070840 1379  5070858 1375  5070878 1379  5070905 1375  
332784 5070920 1375  5070943 1375  5070967 1375  5070983 1379  5071010 1375  5071026 1379  
332785 5071050 1379  5071065 1379  5071084 1379  5071098 1379  5071110 1375  5071130 1375  
332786 5071144 1375  5071154 1375  5071155 1379  5071168 1375  5071174 1379  5071179 1379  
332787 5071179 1379  5071184 1379  5071187 1375  5071187 1375  5071179 1379  5071177 1375  
332788 5071177 1375  5071168 1375  5071150 1379  5071141 1379  5071127 1379  5071107 1379  
332789 5071093 1379  5071079 1379  5071065 1379  5071050 1379  5071026 1379  5071010 1375  
332790 5070983 1379  5070972 1381  5070948 1381  5070929 1381  5070905 1381  5070891 1381  
332791 5070877 1381  5070853 1381  5070838 1381  5070826 1379  5070805 1381  5070791 1381  
332792 5070788 1379  5070771 1381  5070762 1381  5070753 1381  5070748 1381  5070748 1381  
332793 5070748 1381  5070738 1381  5070738 1381  5070748 1381  5070748 1381  5070753 1381  
332794 5070762 1381  5070772 1381  5070786 1381  5070800 1381  5070805 1381  5070824 1381  
332795 5070848 1381  5070862 1381  5070877 1381  5070891 1381  5070915 1381  5070929 1381  
332796 5070953 1381  5070977 1381  5070996 1381  5071025 1381  5071049 1381  5071063 1381  
332797 5071082 1381  5071106 1381  5071125 1381  5071149 1381  5071163 1381  5071182 1381  
332798 5071197 1381  5071206 1381  5071221 1381  5071230 1381  5071240 1381  5071249 1381  
332799 5071254 1381  5071264 1381  5071264 1381  5071264 1381  5071254 1381  5071254 1381  
332800 5071249 1381  5071240 1381  5071230 1381  5071217 1379  5071206 1381  5071192 1381  
332801 5071178 1381  5071163 1381  5071139 1381  5071125 1381  5071096 1381  5071077 1381  
332802 5071054 1381  5071031 1379  5071006 1381  5070982 1381  5070964 1379  5070940 1379  
332803 5070905 1381  5070886 1381  5070862 1381  5070838 1381  5070814 1381  5070800 1381  
332804 5070781 1381  5070753 1381  5070729 1381  5070714 1381  5070700 1381  5070686 1381  
332805 5070671 1381  5070662 1381  5070648 1381  5070648 1381  5070628 1381  5070628 1381  
332806 5070624 1381  5070624 1381  5070624 1381  5070628 1381  5070628 1381  5070638 1381  
332807 5070648 1381  5070662 1381  5070671 1381  5070686 1381  5070700 1381  5070714 1381  
332808 5070729 1381  5070753 1381  5070781 1381  5070800 1381  5070814 1381  5070838 1381  
332809 5070862 1381  5070886 1381  5070905 1381  5070939 1381  5070953 1381  5070977 1381  
332810 5070996 1381  5071025 1381  5071048 1381  5071063 1381  5071082 1381  5071096 1381  
332811 5071115 1381  5071130 1381  5071139 1381  5071154 1381  5071163 1381  5071173 1381  
332812 5071178 1381  5071178 1381  5071178 1381  5071178 1381  5071174 1379  5071173 1381  
332813 5071165 1379  5071163 1381  5071150 1379  5071144 1375  5071130 1375  5071120 1375  
332814 5071098 1379  5071083 1379  5071068 1375  5071053 1375  5071034 1375  5071007 1379  
332815 5070997 1373  5070981 1375  5070958 1375  5070934 1375  5070920 1375  5070907 1373  
332816 5070881 1375  5070867 1375  5070853 1375  5070830 1373  5070821 1373  5070805 1375  
332817 5070791 1375  5070786 1375  5070764 1379  5070757 1375  5070752 1375  5070752 1375  
332818 5070740 1379  5070743 1375  5070743 1375  5070743 1375  5070752 1375  5070749 1379  
332819 5070754 1379  5070773 1379  5070783 1379  5070792 1379  5070800 1381  5070826 1379  
332820 5070840 1379  5070854 1379  5070877 1381  5070893 1379  5070915 1381  5070931 1379  
332821 5070953 1381  5070978 1379  5070996 1381  5071025 1381  5071050 1379  5071074 1379  
332822 5071093 1379  5071117 1379  5071130 1381  5071155 1379  5071173 1381  5071184 1379  
332823 5071206 1381  5071216 1381  5071230 1381  5071240 1381  5071249 1381  5071254 1381  
332824 5071264 1381  5071264 1381  5071263 1381  5071264 1381  5071264 1381  5071254 1381  
332825 5071249 1381  5071241 1379  5071222 1379  5071216 1381  5071198 1379  5071184 1379  
332826 5071174 1379  5071154 1375  5071130 1381  5071110 1375  5071087 1375  5071058 1375  
332827 5071034 1375  5071007 1379  5070981 1375  5070950 1379  5070929 1375  5070893 1379  
332828 5070864 1379  5070830 1379  5070810 1375  5070786 1375  5070749 1379  5070728 1375  
332829 5070705 1375  5070673 1379  5070649 1379  5070633 1375  5070609 1375  5070590 1375  
332830 5070576 1375  5070561 1375  5070542 1375  5070528 1375  5070515 1379  5070506 1379  
332831 5070506 1379  5070501 1379  5070501 1379  5070509 1375  5070518 1375  5070525 1379  
332832 5070530 1379  5070549 1379  5070566 1375  5070582 1379  5070592 1379  5070606 1379  
332833 5070630 1379  5070657 1381  5070681 1381  5070701 1379  5070725 1379  5070749 1379  
332834 5070783 1379  5070800 1381  5070830 1379  5070853 1381  5070886 1381  5070907 1379  
332835 5070940 1379  5070964 1379  5070983 1379  5071007 1379  5071031 1379  5071058 1375  
332836 5071074 1379  5071083 1379  5071098 1379  5071117 1379  5071131 1379  5071144 1375  
332837 5071150 1379  5071158 1375  5071155 1379  5071168 1375  5071168 1375  5071158 1375  
332838 5071160 1373  5071154 1375  5071146 1373  5071136 1373  5071120 1375  5071110 1375  
332839 5071098 1373  5071083 1373  5071069 1373  5071055 1373  5071036 1373  5071012 1373  
332840 5070996 1375  5070977 1375  5070954 1373  5070931 1373  5070910 1375  5070892 1373  
332841 5070878 1373  5070853 1375  5070834 1375  5070811 1373  5070795 1375  5070786 1375  
332842 5070776 1375  5070757 1375  5070752 1375  5070743 1375  5070735 1373  5070733 1375  
332843 5070728 1375  5070729 1375  5070729 1375  5070733 1375  5070735 1373  5070743 1375  
332844 5070752 1375  5070757 1375  5070776 1375  5070783 1379  5070792 1379  5070819 1375  
332845 5070843 1375  5070855 1379  5070881 1375  5070902 1379  5070929 1375  5070953 1375  
332846 5070974 1379  5070996 1375  5071017 1379  5071053 1375  5071074 1379  5071096 1375  
332847 5071120 1375  5071144 1375  5071165 1379  5071189 1373  5071198 1379  5071220 1375  
332848 5071244 1375  5071259 1375  5071279 1373  5071282 1375  5071287 1375  5071297 1375  
332849 5071303 1373  5071303 1373  5071302 1375  5071311 1375  5071303 1373  5071303 1373  
332850 5071298 1373  5071289 1373  5071279 1373  5071260 1373  5071246 1373  5071222 1373  
332851 5071203 1373  5071183 1373  5071160 1373  5071136 1373  5071103 1373  5071079 1373  
332852 5071055 1373  5071012 1373  5070983 1373  5070956 1371  5070921 1373  5070892 1373  
332853 5070856 1372  5070822 1372  5070792 1373  5070756 1372  5070721 1373  5070692 1373  
332854 5070663 1373  5070630 1373  5070606 1373  5070587 1373  5070563 1373  5070534 1373  
332855 5070510 1373  5070496 1373  5070487 1373  5070477 1373  5070467 1373  5070463 1373  
332856 5070453 1373  5070452 1375  5070453 1373  5070461 1375  5070461 1375  5070467 1373  
332857 5070485 1375  5070496 1373  5070509 1375  5070528 1375  5070544 1373  5070566 1375  
332858 5070592 1373  5070620 1373  5070642 1375  5070668 1373  5070695 1375  5070728 1375  
332859 5070757 1375  5070792 1373  5070830 1373  5070859 1373  5070891 1375  5070921 1373  
332860 5070955 1373  5070977 1375  5071001 1375  5071029 1375  5071060 1373  5071083 1373  
332861 5071103 1373  5071131 1373  5071145 1373  5071160 1373  5071177 1375  5071182 1375  
332862 5071187 1375  5071198 1373  5071198 1373  5071203 1373  5071198 1373  5071198 1373  
332863 5071197 1375  5071189 1373  5071184 1373  5071179 1373  5071158 1375  5071144 1375  
332864 5071130 1375  5071112 1373  5071096 1375  5071079 1373  5071053 1375  5071034 1375  
332865 5071010 1375  5070987 1375  5070967 1375  5070945 1373  5070921 1373  5070897 1373  
332866 5070881 1375  5070859 1373  5070843 1375  5070829 1375  5070811 1373  5070792 1373  
332867 5070787 1373  5070768 1373  5070757 1375  5070752 1375  5070743 1375  5070743 1375  
332868 5070733 1375  5070733 1375  5070733 1375  5070733 1375  5070740 1379  5070749 1379  
332869 5070754 1379  5070773 1379  5070786 1381  5070800 1381  5070826 1379  5070840 1379  
332870 5070854 1379  5070877 1381  5070907 1379  5070931 1379  5070953 1381  5070978 1379  
332871 5071007 1379  5071031 1379  5071053 1381  5071083 1379  5071106 1381  5071141 1379  
332872 5071165 1379  5071184 1379  5071208 1379  5071230 1381  5071251 1379  5071275 1379  
332873 5071287 1375  5071308 1379  5071323 1379  5071332 1379  5071344 1375  5071349 1375  
332874 5071359 1375  5071356 1379  5071359 1375  5071356 1379  5071356 1379  5071349 1375  
332875 5071332 1379  5071326 1375  5071313 1373  5071298 1373  5071278 1375  5071251 1379  
332876 5071225 1375  5071201 1375  5071182 1375  5071154 1375  5071117 1379  5071088 1373  
332877 5071053 1375  5071020 1375  5070981 1375  5070953 1375  5070910 1375  5070877 1375  
332878 5070843 1375  5070805 1375  5070767 1375  5070728 1375  5070695 1375  5070663 1379  
332879 5070630 1379  5070601 1379  5070576 1375  5070549 1379  5070515 1379  5070504 1375  
332880 5070482 1379  5070463 1379  5070448 1379  5070439 1379  5070424 1379  5070414 1381  
332881 5070405 1379  5070405 1379  5070405 1379  5070415 1379  5070425 1379  5070432 1381  
332882 5070449 1379  5070461 1381  5070485 1381  5070499 1381  5070523 1381  5070547 1381  
332883 5070581 1381  5070600 1381  5070628 1381  5070662 1381  5070691 1381  5070729 1381  
332884 5070761 1383  5070789 1383  5070829 1381  5070862 1381  5070891 1381  5070923 1383  
332885 5070963 1381  5070982 1381  5071015 1381  5071049 1381  5071072 1381  5071096 1381  
332886 5071125 1381  5071141 1379  5071163 1381  5071178 1381  5071192 1381  5071197 1381  
332887 5071206 1381  5071216 1381  5071221 1381  5071221 1381  5071221 1381  5071221 1381  
332888 5071216 1381  5071206 1381  5071192 1381  5071182 1381  5071173 1381  5071154 1381  
332889 5071141 1379  5071115 1381  5071096 1381  5071077 1381  5071054 1381  5071030 1381  
332890 5071006 1381  5070982 1381  5070961 1383  5070939 1381  5070913 1383  5070890 1383  
332891 5070870 1383  5070851 1383  5070828 1383  5070812 1385  5070788 1385  5070782 1387  
332892 5070767 1387  5070748 1387  5070742 1388  5070732 1388  5070723 1388  5070723 1388  
332893 5070718 1388  5070718 1389  5070724 1387  5070723 1388  5070734 1387  5070743 1387  
332894 5070759 1385  5070769 1385  5070789 1383  5070804 1383  5070823 1383  5070848 1381  
332895 5070870 1383  5070891 1381  5070915 1381  5070939 1381  5070963 1381  5070991 1381  
332896 5071015 1381  5071048 1381  5071077 1381  5071098 1379  5071130 1381  5071154 1381  
332897 5071184 1379  5071206 1381  5071230 1381  5071254 1381  5071279 1379  5071299 1379  
332898 5071323 1379  5071342 1379  5071354 1381  5071369 1375  5071375 1379  5071383 1381  
332899 5071384 1379  5071384 1379  5071384 1379  5071384 1379  5071380 1379  5071378 1375  
332900 5071359 1375  5071341 1379  5071326 1375  5071299 1379  5071282 1375  5071259 1375  
332901 5071235 1375  5071201 1375  5071177 1375  5071145 1373  5071101 1375  5071079 1373  
332902 5071036 1373  5070996 1375  5070955 1373  5070911 1373  5070878 1373  5070837 1372  
332903 5070798 1372  5070759 1373  5070722 1372  5070689 1372  5070644 1373  5070612 1372  
332904 5070588 1372  5070555 1372  5070522 1372  5070494 1370  5070469 1372  5070445 1372  
332905 5070421 1372  5070407 1372  5070392 1372  5070380 1370  5070370 1370  5070370 1370  
332906 5070365 1370  5070365 1370  5070372 1368  5070381 1368  5070391 1368  5070405 1368  
332907 5070415 1368  5070434 1368  5070458 1368  5070482 1368  5070500 1368  5070525 1368  
332908 5070558 1368  5070593 1366  5070615 1368  5070660 1366  5070692 1368  5070725 1368  
332909 5070760 1366  5070798 1366  5070835 1368  5070865 1366  5070902 1368  5070935 1368  
332910 5070975 1366  5071002 1368  5071037 1366  5071060 1368  5071090 1366  5071107 1368  
332911 5071142 1366  5071161 1366  5071183 1368  5071190 1366  5071203 1368  5071218 1366  
332912 5071218 1366  5071228 1366  5071227 1368  5071227 1368  5071218 1366  5071217 1368  
332913 5071209 1366  5071195 1366  5071190 1366  5071176 1366  5071161 1366  5071142 1366  
332914 5071118 1366  5071096 1364  5071075 1366  5071052 1366  5071027 1366  5071004 1366  
332915 5070985 1366  5070961 1366  5070927 1366  5070903 1366  5070884 1366  5070860 1366  
332916 5070835 1368  5070812 1366  5070793 1366  5070774 1366  5070760 1366  5070741 1366  
332917 5070727 1366  5070716 1368  5070712 1366  5070703 1366  5070698 1366  5070698 1366  
332918 5070698 1366  5070703 1366  5070712 1366  5070712 1366  5070717 1366  5070727 1366  
332919 5070741 1366  5070760 1366  5070784 1366  5070798 1366  5070819 1364  5070843 1364  
332920 5070865 1366  5070891 1364  5070919 1364  5070943 1364  5070976 1364  5071005 1364  
332921 5071039 1364  5071062 1364  5071096 1364  5071129 1364  5071163 1364  5071185 1366  
332922 5071210 1364  5071234 1364  5071268 1364  5071292 1364  5071311 1364  5071335 1364  
332923 5071357 1360  5071368 1364  5071391 1360  5071397 1364  5071409 1360  5071411 1364  
332924 5071411 1364  5071411 1364  5071405 1366  5071397 1364  5071392 1364  5071391 1360  
332925 5071368 1364  5071347 1360  5071330 1364  5071309 1360  5071290 1360  5071257 1360  
332926 5071223 1360  5071195 1360  5071166 1360  5071123 1360  5071086 1364  5071046 1360  
332927 5071008 1360  5070970 1360  5070932 1360  5070894 1360  5070846 1360  5070804 1364  
332928 5070769 1360  5070728 1364  5070698 1360  5070655 1360  5070618 1364  5070588 1360  
332929 5070552 1364  5070518 1364  5070502 1360  5070470 1364  5070446 1364  5070426 1366  
332930 5070413 1364  5070397 1360  5070384 1364  5070374 1364  5070368 1366  5070370 1364  
332931 5070370 1364  5070370 1364  5070383 1366  5070394 1364  5070408 1364  5070418 1364  
332932 5070437 1364  5070451 1364  5070485 1364  5070504 1364  5070528 1364  5070561 1364  
332933 5070588 1360  5070618 1364  5070652 1364  5070688 1360  5070722 1360  5070755 1360  
332934 5070798 1360  5070832 1360  5070865 1360  5070903 1360  5070932 1360  5070970 1360  
332935 5070999 1360  5071034 1358  5071067 1358  5071091 1358  5071113 1360  5071143 1358  
332936 5071158 1358  5071171 1360  5071191 1358  5071201 1358  5071210 1358  5071213 1360  
332937 5071225 1358  5071226 1356  5071225 1358  5071225 1358  5071210 1358  5071201 1358  
332938 5071196 1358  5071182 1358  5071172 1358  5071158 1358  5071134 1358  5071110 1358  
332939 5071091 1358  5071072 1358  5071048 1358  5071014 1358  5070996 1358  5070972 1358  
332940 5070943 1358  5070919 1358  5070895 1358  5070867 1358  5070843 1358  5070817 1360  
332941 5070798 1360  5070769 1360  5070745 1360  5070733 1358  5070719 1358  5070702 1360  
332942 5070698 1360  5070688 1360  5070679 1360  5070674 1360  5070664 1360  5070664 1360  
332943 5070664 1360  5070675 1358  5070675 1358  5070678 1360  5070698 1360  5070704 1358  
332944 5070723 1358  5070742 1358  5070766 1358  5070790 1358  5070811 1357  5070833 1358  
332945 5070857 1358  5070892 1357  5070911 1357  5070944 1356  5070973 1357  5071000 1358  
332946 5071034 1358  5071069 1357  5071096 1358  5071125 1358  5071158 1358  5071191 1358  
332947 5071214 1360  5071237 1360  5071271 1360  5071292 1364  5071314 1360  5071338 1360  
332948 5071344 1364  5071371 1360  5071378 1364  5071387 1364  5071392 1364  5071391 1366  
332949 5071392 1364  5071391 1366  5071387 1364  5071376 1366  5071359 1364  5071354 1364  
332950 5071329 1366  5071305 1366  5071292 1364  5071268 1364  5071234 1364  5071209 1360  
332951 5071177 1364  5071144 1364  5071105 1364  5071067 1364  5071039 1364  5070991 1364  
332952 5070953 1364  5070918 1360  5070876 1364  5070838 1364  5070803 1360  5070765 1360  
332953 5070719 1364  5070685 1364  5070642 1364  5070614 1364  5070575 1364  5070542 1364  
332954 5070513 1364  5070494 1364  5070461 1364  5070447 1364  5070418 1364  5070408 1364  
332955 5070394 1364  5070384 1364  5070378 1360  5070370 1364  5070370 1364  5070368 1366  
332956 5070374 1364  5070384 1364  5070394 1364  5070408 1364  5070416 1366  5070447 1364  
332957 5070459 1366  5070485 1364  5070512 1366  5070537 1364  5070569 1366  5070594 1364  
332958 5070628 1364  5070661 1364  5070695 1364  5070728 1364  5070766 1364  5070800 1364  
332959 5070838 1364  5070876 1364  5070914 1364  5070943 1364  5070986 1364  5071013 1360  
332960 5071043 1364  5071067 1364  5071099 1360  5071123 1360  5071147 1360  5071166 1360  
332961 5071177 1364  5071199 1360  5071209 1360  5071223 1360  5071233 1360  5071233 1360  
332962 5071230 1364  5071237 1360  5071233 1360  5071223 1360  5071213 1360  5071209 1360  
332963 5071195 1360  5071180 1360  5071167 1358  5071148 1358  5071123 1360  5071099 1360  
332964 5071080 1360  5071058 1358  5071034 1358  5071000 1358  5070981 1358  5070956 1360  
332965 5070922 1360  5070903 1360  5070879 1360  5070857 1358  5070833 1358  5070807 1360  
332966 5070790 1358  5070771 1358  5070755 1360  5070742 1358  5070722 1360  5070717 1360  
332967 5070702 1360  5070703 1360  5070698 1360  5070688 1360  5070690 1358  5070688 1360  
332968 5070698 1360  5070704 1358  5070707 1360  5070717 1360  5070731 1360  5070745 1360  
332969 5070769 1360  5070789 1360  5070807 1360  5070832 1360  5070865 1360  5070891 1358  
332970 5070908 1360  5070943 1358  5070967 1358  5070995 1358  5071024 1358  5071058 1358  
332971 5071091 1358  5071113 1360  5071143 1358  5071172 1358  5071199 1360  5071225 1358  
332972 5071257 1360  5071280 1360  5071300 1360  5071324 1360  5071338 1360  5071357 1360  
332973 5071368 1364  5071381 1360  5071391 1366  5071392 1364  5071397 1364  5071397 1364  
332974 5071397 1364  5071395 1360  5071387 1364  5071376 1366  5071359 1364  5071344 1364  
332975 5071320 1364  5071306 1364  5071290 1360  5071263 1364  5071233 1360  5071196 1364  
332976 5071180 1360  5071144 1364  5071105 1364  5071067 1364  5071042 1360  5070996 1364  
332977 5070962 1364  5070929 1364  5070891 1364  5070852 1364  5070817 1366  5070786 1364  
332978 5070752 1364  5070714 1364  5070695 1364  5070661 1364  5070628 1364  5070604 1364  
332979 5070575 1364  5070561 1364  5070537 1364  5070518 1364  5070507 1360  5070497 1360  
332980 5070485 1364  5070478 1360  5070475 1364  5070478 1360  5070478 1360  5070475 1364  
332981 5070488 1360  5070499 1364  5070513 1364  5070521 1360  5070537 1364  5070561 1364  
332982 5070585 1364  5070607 1360  5070637 1364  5070661 1364  5070695 1364  5070717 1366  
332983 5070752 1364  5070795 1364  5070819 1364  5070852 1364  5070886 1364  5070918 1366  
332984 5070951 1366  5070986 1364  5071010 1364  5071043 1364  5071077 1364  5071105 1364  
332985 5071128 1366  5071151 1366  5071180 1360  5071191 1364  5071206 1364  5071223 1360  
332986 5071230 1364  5071244 1364  5071244 1364  5071257 1360  5071263 1364  5071263 1364  
332987 5071254 1364  5071257 1360  5071247 1360  5071234 1364  5071220 1364  5071214 1360  
332988 5071196 1364  5071180 1360  5071163 1364  5071142 1360  5071110 1364  5071094 1360  
332989 5071067 1364  5071046 1360  5071023 1360  5070996 1364  5070979 1360  5070943 1364  
332990 5070922 1360  5070900 1364  5070870 1360  5070843 1364  5070822 1360  5070800 1364  
332991 5070786 1364  5070769 1360  5070755 1360  5070738 1364  5070719 1364  5070714 1364  
332992 5070707 1360  5070700 1364  5070703 1360  5070695 1364  5070695 1364  5070695 1364  
332993 5070702 1360  5070699 1364  5070714 1364  5070728 1364  5070738 1364  5070752 1364  
332994 5070776 1364  5070793 1366  5070814 1364  5070838 1364  5070862 1364  5070886 1364  
332995 5070903 1366  5070937 1366  5070961 1366  5070991 1364  5071020 1364  5071043 1364  
332996 5071077 1364  5071094 1366  5071128 1366  5071153 1364  5071177 1364  5071196 1364  
332997 5071218 1366  5071242 1366  5071262 1366  5071276 1366  5071290 1366  5071304 1366  
332998 5071309 1366  5071319 1366  5071328 1366  5071327 1368  5071327 1368  5071317 1368  
332999 5071317 1368  5071309 1366  5071295 1366  5071292 1364  5071276 1366  5071260 1368  
333000 5071242 1366  5071217 1368  5071193 1368  5071176 1366  5071151 1366  5071107 1368  
333001 5071088 1368  5071061 1366  5071028 1366  5070988 1368  5070961 1366  5070927 1366  
333002 5070897 1368  5070865 1366  5070835 1368  5070803 1366  5070765 1366  5070741 1366  
333003 5070712 1366  5070684 1366  5070660 1366  5070634 1368  5070610 1368  5070598 1366  
333004 5070574 1366  5070560 1366  5070539 1368  5070534 1368  5070524 1368  5070515 1368  
333005 5070512 1366  5070512 1366  5070512 1366  5070512 1366  5070517 1366  5070526 1366  
333006 5070537 1364  5070551 1364  5070571 1364  5070585 1364  5070598 1366  5070618 1364  
333007 5070637 1364  5070671 1364  5070695 1364  5070722 1360  5070742 1364  5070776 1364  
333008 5070804 1364  5070841 1360  5070865 1360  5070894 1360  5070922 1360  5070953 1364  
333009 5070986 1364  5071013 1360  5071043 1364  5071067 1364  5071091 1364  5071109 1366  
333010 5071139 1364  5071153 1364  5071168 1364  5071187 1364  5071195 1366  5071204 1366  
333011 5071209 1366  5071218 1366  5071230 1364  5071228 1366  5071218 1366  5071220 1364  
333012 5071211 1364  5071209 1360  5071196 1364  5071187 1364  5071168 1364  5071153 1364  
333013 5071139 1364  5071123 1360  5071096 1364  5071087 1364  5071066 1360  5071038 1364  
333014 5071013 1360  5070991 1364  5070967 1364  5070946 1360  5070918 1360  5070894 1360  
333015 5070870 1360  5070843 1364  5070819 1364  5070807 1360  5070786 1364  5070766 1364  
333016 5070752 1364  5070741 1360  5070719 1364  5070714 1364  5070704 1364  5070702 1360  
333017 5070698 1360  5070698 1360  5070685 1364  5070695 1364  5070695 1364  5070695 1364  
333018 5070699 1364  5070714 1364  5070719 1364  5070737 1364  5070752 1364  5070766 1364  
333019 5070795 1364  5070805 1364  5070832 1360  5070852 1364  5070876 1364  5070903 1360  
333020 5070919 1364  5070943 1364  5070967 1364  5070991 1364  5071020 1364  5071043 1364  
333021 5071067 1364  5071094 1366  5071120 1364  5071144 1364  5071166 1366  5071187 1364  
333022 5071204 1366  5071218 1366  5071234 1364  5071252 1366  5071263 1364  5071268 1364  
333023 5071268 1364  5071276 1366  5071277 1364  5071287 1364  5071277 1364  5071266 1366  
333024 5071262 1366  5071254 1364  5071247 1360  5071230 1364  5071218 1366  5071206 1364  
333025 5071185 1366  5071168 1364  5071142 1366  5071120 1364  5071096 1364  5071067 1364  
333026 5071042 1366  5071008 1366  5070991 1364  5070961 1366  5070938 1364  5070913 1366  
333027 5070886 1364  5070860 1366  5070836 1366  5070805 1364  5070786 1364  5070760 1366  
333028 5070738 1364  5070712 1366  5070695 1364  5070676 1364  5070660 1366  5070642 1364  
333029 5070628 1364  5070614 1364  5070604 1364  5070599 1364  5070594 1364  5070594 1364  
333030 5070593 1366  5070594 1364  5070594 1364  5070598 1366  5070604 1364  5070614 1364  
333031 5070628 1364  5070636 1366  5070652 1364  5070674 1366  5070695 1364  5070704 1364  
333032 5070728 1364  5070752 1364  5070776 1364  5070800 1364  5070819 1364  5070843 1364  
333033 5070867 1364  5070891 1364  5070919 1364  5070953 1364  5070976 1364  5070994 1366  
333034 5071018 1366  5071042 1366  5071067 1364  5071090 1366  5071104 1366  5071120 1364  
333035 5071137 1366  5071152 1366  5071166 1366  5071175 1366  5071185 1366  5071190 1366  
333036 5071190 1366  5071190 1366  5071190 1366  5071190 1366  5071185 1366  5071185 1366  
333037 5071166 1366  5071161 1366  5071152 1366  5071137 1366  5071118 1366  5071104 1366  
333038 5071090 1366  5071066 1366  5071051 1366  5071029 1364  5071004 1366  5070985 1366  
333039 5070962 1364  5070938 1364  5070914 1364  5070891 1364  5070870 1360  5070843 1364  
333040 5070828 1364  5070807 1360  5070789 1360  5070769 1360  5070755 1360  5070741 1360  
333041 5070722 1360  5070709 1358  5070704 1358  5070699 1358  5070691 1356  5070682 1356  
333042 5070682 1356  5070680 1358  5070682 1356  5070682 1356  5070691 1356  5070701 1356  
333043 5070705 1356  5070710 1356  5070725 1357  5070734 1356  5070749 1356  5070768 1356  
333044 5070792 1356  5070806 1356  5070820 1356  5070835 1356  5070858 1356  5070882 1356  
333045 5070906 1356  5070921 1357  5070944 1357  5070968 1357  5070992 1356  5071011 1357  
333046 5071035 1356  5071049 1357  5071069 1356  5071093 1357  5071102 1357  5071116 1356  
333047 5071136 1357  5071145 1357  5071160 1357  5071169 1356  5071174 1357  5071183 1356  
333048 5071183 1356  5071193 1357  5071193 1357  5071193 1357  5071183 1356  5071174 1356  
333049 5071169 1356  5071159 1356  5071150 1357  5071145 1356  5071126 1357  5071111 1356  
333050 5071097 1356  5071083 1356  5071059 1357  5071045 1357  5071016 1357  5071002 1356  
333051 5070983 1357  5070959 1357  5070935 1357  5070911 1357  5070892 1356  5070873 1356  
333052 5070849 1356  5070825 1357  5070812 1355  5070792 1356  5070768 1357  5070749 1356  
333053 5070734 1357  5070720 1357  5070705 1356  5070701 1356  5070682 1356  5070677 1357  
333054 5070667 1357  5070658 1357  5070648 1356  5070648 1356  5070648 1357  5070648 1356  
333055 5070648 1356  5070658 1357  5070667 1356  5070677 1357  5070682 1356  5070691 1356  
333056 5070705 1356  5070720 1356  5070734 1357  5070749 1356  5070768 1356  5070782 1357  
333057 5070806 1357  5070820 1357  5070844 1356  5070858 1356  5070882 1356  5070906 1356  
333058 5070925 1356  5070949 1356  5070973 1356  5070997 1356  5071011 1356  5071035 1356  
333059 5071049 1356  5071069 1357  5071093 1356  5071102 1356  5071116 1356  5071126 1356  
333060 5071145 1356  5071148 1358  5071158 1358  5071158 1358  5071159 1356  5071169 1356  
333061 5071159 1356  5071159 1357  5071159 1356  5071150 1356  5071145 1356  5071135 1356  
333062 5071126 1357  5071111 1356  5071102 1357  5071093 1357  5071069 1357  5071049 1357  
333063 5071035 1357  5071016 1356  5070997 1357  5070973 1357  5070959 1356  5070935 1356  
333064 5070911 1357  5070892 1357  5070874 1355  5070851 1355  5070825 1356  5070812 1355  
333065 5070803 1355  5070772 1357  5070758 1357  5070744 1356  5070736 1355  5070720 1356  
333066 5070710 1356  5070705 1356  5070701 1356  5070701 1357  5070691 1356  5070691 1357  
333067 5070691 1356  5070691 1356  5070701 1356  5070701 1356  5070701 1356  5070705 1356  
333068 5070720 1356  5070725 1356  5070734 1356  5070749 1356  5070758 1356  5070772 1356  
333069 5070792 1356  5070806 1356  5070811 1357  5070835 1356  5070844 1357  5070868 1356  
333070 5070882 1356  5070906 1356  5070921 1356  5070935 1356  5070959 1356  5070968 1357  
333071 5070992 1356  5071002 1356  5071016 1357  5071035 1356  5071045 1356  5071059 1357  
333072 5071069 1356  5071083 1356  5071093 1356  5071097 1356  5071097 1356  5071102 1356  
333073 5071102 1357  5071110 1358  5071111 1356  5071111 1356  5071102 1356  5071102 1356  
333074 5071097 1357  5071097 1356  5071091 1358  5071083 1357  5071069 1357  5071058 1358  
333075 5071045 1356  5071026 1357  5071011 1357  5070997 1356  5070982 1356  5070968 1356  
333076 5070944 1356  5070925 1356  5070911 1356  5070892 1356  5070873 1357  5070858 1356  
333077 5070844 1356  5070825 1356  5070806 1356  5070801 1356  5070772 1356  5070768 1356  
333078 5070749 1356  5070744 1356  5070725 1356  5070720 1356  5070720 1357  5070710 1356  
333079 5070705 1356  5070705 1356  5070706 1357  5070705 1356  5070705 1356  5070705 1356  
333080 5070710 1357  5070710 1356  5070720 1356  5070725 1356  5070734 1356  5070744 1356  
333081 5070749 1356  5070768 1356  5070782 1356  5070792 1356  5070810 1356  5070825 1356  
333082 5070844 1356  5070868 1356  5070883 1357  5070906 1356  5070921 1356  5070935 1356  
333083 5070959 1356  5070973 1356  5070992 1356  5071011 1356  5071026 1356  5071048 1358  
333084 5071069 1356  5071073 1356  5071091 1358  5071102 1357  5071111 1356  5071116 1356  
333085 5071124 1358  5071134 1358  5071135 1356  5071145 1356  5071145 1356  5071145 1356  
333086 5071145 1356  5071145 1356  5071135 1356  5071126 1356  5071116 1356  5071111 1356  
333087 5071102 1356  5071093 1356  5071073 1356  5071059 1356  5071045 1356  5071026 1356  
333088 5071011 1356  5070992 1356  5070973 1356  5070959 1356  5070935 1356  5070921 1356  
333089 5070906 1356  5070882 1356  5070868 1356  5070849 1356  5070835 1357  5070820 1356  
333090 5070801 1356  5070792 1356  5070772 1356  5070768 1356  5070749 1356  5070744 1356  
333091 5070734 1356  5070725 1356  5070725 1356  5070725 1356  5070720 1356  5070720 1356  
333092 5070720 1356  5070720 1356  5070720 1356  5070725 1356  5070725 1356  5070734 1356  
333093 5070744 1356  5070749 1356  5070758 1356  5070772 1357  5070782 1356  5070792 1356  
333094 5070806 1356  5070820 1357  5070835 1357  5070844 1356  5070858 1356  5070871 1358  
333095 5070892 1356  5070909 1358  5070924 1358  5070944 1357  5070959 1357  5070967 1358  
333096 5070981 1358  5070997 1357  5071010 1358  5071024 1358  5071045 1357  5071048 1358  
333097 5071059 1357  5071067 1358  5071073 1356  5071081 1358  5071093 1357  5071093 1357  
333098 5071097 1357  5071097 1356  5071097 1357  5071097 1357  5071097 1356  5071097 1356  
333099 5071093 1356  5071083 1356  5071073 1357  5071069 1357  5071049 1357  5071045 1357  
333100 5071035 1356  5071016 1357  5071002 1357  5070992 1357  5070973 1356  5070959 1356  
333101 5070944 1356  5070935 1356  5070921 1356  5070906 1356  5070892 1356  5070873 1356  
333102 5070868 1356  5070849 1356  5070836 1355  5070825 1356  5070811 1356  5070806 1356  
333103 5070801 1356  5070792 1356  5070782 1356  5070772 1357  5070772 1356  5070768 1356  
333104 5070768 1357  5070768 1356  5070758 1356  5070768 1357  5070768 1356  5070772 1356  
333105 5070772 1356  5070782 1356  5070790 1358  5070801 1356  5070806 1356  5070809 1358  
333106 5070825 1356  5070835 1357  5070849 1356  5070858 1356  5070871 1358  5070890 1358  
333107 5070903 1360  5070924 1358  5070941 1360  5070957 1358  5070971 1358  5070991 1358  
333108 5071000 1358  5071014 1358  5071032 1360  5071046 1360  5071066 1360  5071081 1358  
333109 5071094 1360  5071108 1360  5071113 1360  5071123 1360  5071132 1360  5071143 1358  
333110 5071147 1360  5071158 1358  5071148 1358  5071148 1358  5071158 1358  5071148 1358  
333111 5071143 1358  5071145 1356  5071135 1357  5071126 1356  5071116 1356  5071103 1355  
333112 5071099 1355  5071085 1355  5071070 1355  5071049 1356  5071037 1355  5071018 1355  
333113 5070999 1355  5070975 1355  5070960 1355  5070946 1355  5070927 1355  5070908 1355  
333114 5070893 1355  5070874 1355  5070860 1355  5070836 1355  5070822 1355  5070807 1355  
333115 5070793 1355  5070784 1355  5070774 1355  5070760 1355  5070750 1355  5070736 1355  
333116 5070726 1355  5070722 1355  5070712 1355  5070712 1355  5070707 1355  5070707 1355  
333117 5070702 1355  5070702 1355  5070702 1355  5070702 1355  5070707 1355  5070707 1355  
333118 5070712 1355  5070712 1355  5070722 1355  5070726 1355  5070726 1355  5070745 1355  
333119 5070750 1355  5070760 1355  5070774 1355  5070784 1355  5070803 1355  5070807 1355  
333120 5070822 1355  5070836 1355  5070849 1356  5070860 1355  5070874 1355  5070893 1355  
333121 5070897 1356  5070911 1356  5070927 1355  5070936 1355  5070944 1356  5070959 1356  
333122 5070968 1356  5070973 1357  5070982 1356  5070992 1357  5070997 1356  5070997 1356  
333123 5071002 1357  5071000 1358  5071011 1357  5071011 1356  5071011 1356  5071011 1356  
333124 5071002 1357  5070997 1357  5070992 1356  5070992 1356  5070982 1356  5070973 1356  
333125 5070959 1356  5070949 1356  5070935 1356  5070927 1355  5070912 1355  5070908 1355  
333126 5070898 1355  5070887 1351  5070876 1347  5070863 1351  5070852 1347  5070842 1347  
333127 5070829 1345  5070819 1347  5070813 1347  5070801 1345  5070791 1345  5070780 1347  
333128 5070775 1347  5070767 1345  5070758 1345  5070756 1347  5070756 1347  5070753 1345  
333129 5070753 1345  5070753 1345  5070752 1347  5070756 1347  5070756 1347  5070766 1347  
333130 5070775 1347  5070780 1347  5070790 1347  5070799 1347  5070809 1347  5070815 1351  
333131 5070830 1351  5070839 1351  5070857 1347  5070876 1347  5070890 1347  5070904 1347  
333132 5070919 1347  5070933 1347  5070952 1347  5070966 1347  5070980 1347  5071000 1347  
333133 5071016 1351  5071024 1347  5071053 1347  5071057 1347  5071076 1347  5071092 1345  
333134 5071102 1345  5071110 1347  5071121 1345  5071126 1345  5071134 1347  5071145 1345  
333135 5071145 1345  5071145 1345  5071154 1345  5071153 1347  5071145 1345  5071143 1347  
333136 5071143 1347  5071134 1347  5071124 1347  5071119 1347  5071110 1347  5071100 1347  
333137 5071091 1347  5071076 1347  5071067 1347  5071049 1351  5071033 1347  5071009 1347  
333138 5071000 1347  5070981 1347  5070966 1347  5070949 1351  5070928 1347  5070915 1345  
333139 5070901 1345  5070882 1345  5070858 1345  5070853 1345  5070829 1345  5070815 1345  
333140 5070801 1345  5070782 1345  5070767 1345  5070758 1345  5070743 1345  5070729 1345  
333141 5070720 1345  5070713 1347  5070710 1345  5070700 1345  5070689 1347  5070691 1345  
333142 5070686 1345  5070685 1347  5070686 1345  5070685 1347  5070686 1345  5070686 1345  
333143 5070691 1345  5070691 1345  5070691 1345  5070700 1345  5070715 1345  5070720 1345  
333144 5070729 1345  5070743 1345  5070753 1345  5070758 1345  5070777 1345  5070782 1345  
333145 5070801 1345  5070813 1347  5070828 1347  5070842 1347  5070857 1347  5070876 1347  
333146 5070882 1345  5070900 1347  5070904 1347  5070928 1347  5070933 1347  5070952 1347  
333147 5070957 1347  5070976 1347  5070982 1345  5070992 1345  5071001 1345  5071004 1347  
333148 5071011 1345  5071009 1347  5071011 1345  5071021 1345  5071021 1345  5071011 1345  
333149 5071011 1345  5071011 1345  5071011 1345  5071004 1347  5071006 1345  5071003 1343  
333150 5070992 1345  5070982 1345  5070977 1345  5070977 1345  5070968 1345  5070954 1345  
333151 5070946 1343  5070933 1347  5070920 1345  5070915 1345  5070906 1345  5070901 1345  
333152 5070882 1345  5070877 1345  5070868 1345  5070858 1345  5070853 1345  5070844 1345  
333153 5070834 1345  5070829 1345  5070820 1345  5070820 1345  5070815 1345  5070810 1345  
333154 5070809 1347  5070812 1343  5070817 1343  5070817 1343  5070822 1343  5070822 1343  
333155 5070831 1343  5070836 1343  5070845 1343  5070856 1341  5070861 1341  5070880 1341  
333156 5070885 1341  5070904 1341  5070909 1341  5070923 1341  5070939 1340  5070960 1338  
333157 5070966 1336  5070985 1336  5071003 1332  5071017 1332  5071031 1332  5071045 1332  
333158 5071055 1332  5071069 1332  5071089 1332  5071103 1332  5071112 1332  5071122 1332  
333159 5071132 1332  5071136 1332  5071136 1332  5071146 1332  5071155 1332  5071155 1332  
333160 5071155 1332  5071156 1332  5071155 1332  5071165 1332  5071155 1332  5071146 1332  
333161 5071146 1332  5071136 1332  5071122 1332  5071117 1332  5071103 1332  5071093 1332  
333162 5071079 1332  5071069 1332  5071045 1332  5071036 1332  5071017 1332  5071002 1332  
333163 5070988 1332  5070964 1332  5070945 1332  5070926 1332  5070912 1332  5070888 1332  
333164 5070864 1332  5070845 1332  5070826 1332  5070799 1336  5070788 1332  5070765 1336  
333165 5070745 1332  5070730 1332  5070723 1336  5070702 1332  5070694 1336  5070674 1336  
333166 5070668 1332  5070651 1336  5070641 1336  5070636 1336  5070627 1336  5070630 1332  
333167 5070627 1336  5070625 1332  5070625 1332  5070625 1332  5070622 1336  5070627 1336  
333168 5070627 1336  5070641 1336  5070641 1336  5070651 1336  5070663 1332  5070678 1332  
333169 5070687 1332  5070702 1332  5070711 1332  5070726 1332  5070737 1336  5070754 1332  
333170 5070765 1336  5070789 1336  5070811 1332  5070826 1332  5070837 1336  5070855 1332  
333171 5070866 1336  5070885 1336  5070902 1332  5070913 1336  5070931 1332  5070942 1336  
333172 5070961 1336  5070966 1336  5070985 1336  5070985 1336  5070998 1338  5071007 1338  
333173 5071012 1338  5071019 1336  5071028 1336  5071033 1336  5071033 1336  5071031 1338  
333174 5071042 1336  5071033 1336  5071033 1336  5071028 1336  5071028 1336  5071028 1336  
333175 5071014 1336  5071012 1338  5071009 1336  5070993 1332  5070985 1336  5070975 1336  
333176 5070961 1336  5070945 1332  5070937 1336  5070931 1332  5070917 1332  5070902 1332  
333177 5070888 1332  5070878 1332  5070869 1332  5070864 1332  5070845 1332  5070845 1332  
333178 5070831 1332  5070826 1332  5070826 1332  5070826 1332  5070821 1332  5070821 1332  
333179 5070821 1332  5070821 1332  5070821 1332  5070821 1332  5070826 1332  5070831 1332  
333180 5070840 1332  5070845 1332  5070855 1332  5070864 1332  5070878 1332  5070888 1332  
333181 5070893 1332  5070912 1332  5070926 1332  5070940 1332  5070955 1332  5070964 1332  
333182 5070988 1332  5071002 1332  5071017 1332  5071031 1332  5071045 1332  5071065 1332  
333183 5071069 1332  5071089 1332  5071103 1332  5071112 1332  5071122 1332  5071132 1332  
333184 5071136 1332  5071146 1332  5071155 1332  5071165 1332  5071165 1332  5071162 1336  
333185 5071170 1332  5071170 1332  5071170 1332  5071165 1332  5071165 1332  5071162 1336  
333186 5071155 1332  5071136 1332  5071132 1332  5071119 1336  5071109 1336  5071090 1336  
333187 5071086 1336  5071066 1336  5071042 1336  5071031 1332  5071009 1336  5070990 1336  
333188 5070966 1336  5070941 1338  5070926 1338  5070909 1336  5070883 1338  5070859 1338  
333189 5070837 1336  5070818 1336  5070788 1338  5070773 1338  5070750 1338  5070735 1338  
333190 5070716 1338  5070697 1338  5070683 1338  5070659 1338  5070648 1340  5070633 1340  
333191 5070625 1338  5070621 1338  5070616 1338  5070606 1338  5070595 1340  5070597 1338  
333192 5070595 1340  5070595 1340  5070595 1340  5070605 1340  5070603 1341  5070613 1341  
333193 5070622 1341  5070622 1341  5070637 1341  5070648 1340  5070661 1341  5070668 1343  
333194 5070689 1341  5070702 1343  5070716 1343  5070731 1343  5070756 1341  5070770 1341  
333195 5070783 1343  5070812 1343  5070831 1343  5070847 1341  5070869 1343  5070884 1343  
333196 5070907 1343  5070922 1343  5070936 1343  5070955 1343  5070971 1341  5070984 1343  
333197 5071004 1341  5071008 1343  5071022 1343  5071028 1341  5071036 1343  5071047 1341  
333198 5071057 1341  5071062 1341  5071062 1341  5071062 1341  5071062 1341  5071062 1341  
333199 5071062 1341  5071057 1341  5071057 1341  5071047 1341  5071047 1341  5071028 1341  
333200 5071024 1341  5071014 1341  5071004 1341  5070996 1340  5070985 1341  5070971 1341  
333201 5070957 1341  5070947 1341  5070933 1341  5070919 1341  5070904 1341  5070885 1341  
333202 5070880 1341  5070861 1341  5070856 1341  5070837 1341  5070831 1343  5070823 1341  
333203 5070818 1341  5070813 1341  5070813 1341  5070805 1340  5070804 1341  5070794 1341  
333204 5070804 1341  5070804 1341  5070804 1341  5070813 1341  5070818 1341  5070823 1341  
333205 5070832 1341  5070836 1343  5070845 1343  5070860 1343  5070879 1343  5070884 1343  
333206 5070909 1341  5070922 1343  5070936 1343  5070955 1343  5070969 1343  5070984 1343  
333207 5071003 1343  5071022 1343  5071036 1343  5071056 1343  5071070 1343  5071084 1343  
333208 5071102 1345  5071113 1343  5071122 1343  5071137 1343  5071156 1343  5071162 1341  
333209 5071170 1343  5071181 1341  5071186 1341  5071186 1341  5071194 1343  5071194 1343  
333210 5071196 1341  5071194 1343  5071184 1343  5071184 1343  5071179 1343  5071170 1343  
333211 5071161 1343  5071148 1341  5071137 1343  5071122 1343  5071108 1343  5071095 1341  
333212 5071071 1341  5071047 1341  5071024 1341  5071009 1341  5070980 1341  5070957 1341  
333213 5070931 1343  5070909 1341  5070885 1341  5070861 1341  5070832 1341  5070812 1343  
333214 5070785 1341  5070761 1341  5070738 1340  5070721 1343  5070703 1341  5070679 1341  
333215 5070659 1343  5070637 1341  5070621 1343  5070611 1343  5070603 1341  5070592 1343  
333216 5070578 1343  5070568 1343  5070570 1341  5070559 1343  5070554 1343  5070554 1343  
333217 5070556 1342  5070559 1343  5070559 1343  5070570 1341  5070578 1343  5070587 1343  
333218 5070592 1343  5070613 1341  5070616 1343  5070630 1343  5070654 1343  5070669 1343  
333219 5070689 1341  5070703 1341  5070721 1343  5070746 1341  5070769 1343  5070785 1341  
333220 5070813 1341  5070832 1341  5070855 1343  5070871 1341  5070895 1341  5070917 1343  
333221 5070933 1341  5070957 1341  5070971 1341  5070985 1341  5071009 1341  5071024 1341  
333222 5071028 1341  5071047 1341  5071062 1341  5071062 1341  5071079 1343  5071079 1343  
333223 5071084 1343  5071086 1341  5071086 1341  5071084 1343  5071086 1341  5071081 1341  
333224 5071081 1341  5071071 1341  5071056 1343  5071047 1341  5071028 1341  5071024 1341  
333225 5071009 1341  5070997 1340  5070984 1343  5070971 1341  5070957 1341  5070938 1341  
333226 5070923 1341  5070909 1341  5070895 1341  5070880 1341  5070861 1341  5070847 1341  
333227 5070836 1343  5070823 1341  5070812 1343  5070804 1341  5070793 1343  5070783 1343  
333228 5070783 1343  5070778 1343  5070778 1343  5070769 1343  5070770 1341  5070767 1345  
333229 5070777 1345  5070783 1343  5070783 1343  5070793 1343  5070801 1345  5070815 1345  
333230 5070829 1345  5070844 1345  5070853 1345  5070868 1345  5070890 1347  5070906 1345  
333231 5070920 1345  5070934 1345  5070959 1345  5070977 1345  5070992 1345  5071011 1345  
333232 5071025 1345  5071044 1345  5071068 1345  5071081 1347  5071105 1347  5071121 1345  
333233 5071134 1347  5071153 1347  5071167 1347  5071181 1347  5071191 1347  5071202 1345  
333234 5071210 1347  5071211 1345  5071221 1345  5071226 1345  5071226 1345  5071226 1345  
333235 5071226 1345  5071221 1345  5071211 1345  5071211 1345  5071202 1345  5071192 1345  
333236 5071178 1345  5071159 1345  5071145 1345  5071119 1347  5071105 1347  5071081 1347  
333237 5071057 1347  5071035 1345  5071009 1347  5070992 1345  5070959 1345  5070936 1343  
333238 5070906 1345  5070882 1345  5070853 1345  5070830 1345  5070802 1343  5070778 1343  
333239 5070745 1343  5070723 1342  5070702 1343  5070680 1341  5070656 1341  5070632 1341  
333240 5070618 1341  5070602 1343  5070591 1340  5070568 1343  5070556 1341  5070556 1342  
333241 5070546 1341  5070536 1341  5070538 1340  5070532 1341  5070532 1341  5070535 1343  
333242 5070536 1341  5070544 1343  5070560 1341  5070570 1341  5070587 1343  5070603 1341  
333243 5070613 1341  5070621 1343  5070646 1341  5070661 1341  5070689 1341  5070713 1342  
333244 5070732 1341  5070758 1340  5070770 1341  5070794 1341  5070818 1341  5070847 1341  
333245 5070872 1340  5070895 1341  5070920 1340  5070938 1341  5070963 1340  5070985 1341  
333246 5071009 1341  5071024 1341  5071038 1341  5071057 1341  5071071 1341  5071086 1341  
333247 5071095 1341  5071103 1343  5071109 1341  5071114 1341  5071124 1341  5071124 1341  
333248 5071124 1341  5071124 1341  5071114 1341  5071114 1341  5071109 1341  5071095 1341  
333249 5071086 1341  5071081 1341  5071062 1341  5071047 1341  5071030 1340  5071014 1341  
333250 5071004 1341  5070985 1341  5070971 1341  5070957 1341  5070938 1341  5070922 1343  
333251 5070904 1341  5070884 1343  5070871 1342  5070856 1341  5070836 1343  5070832 1341  
333252 5070818 1341  5070812 1343  5070804 1341  5070785 1341  5070783 1343  5070778 1343  
333253 5070769 1343  5070770 1341  5070769 1343  5070769 1343  5070770 1341  5070780 1341  
333254 5070783 1343  5070793 1343  5070802 1343  5070817 1343  5070831 1343  5070836 1343  
333255 5070857 1341  5070869 1343  5070893 1343  5070907 1343  5070933 1341  5070947 1341  
333256 5070961 1341  5070984 1343  5071009 1341  5071024 1341  5071047 1341  5071071 1341  
333257 5071094 1343  5071114 1341  5071127 1343  5071146 1343  5071170 1343  5071184 1343  
333258 5071204 1343  5071213 1343  5071228 1343  5071248 1341  5071253 1341  5071261 1343  
333259 5071270 1343  5071281 1341  5071280 1343  5071280 1343  5071281 1341  5071272 1341  
333260 5071262 1341  5071253 1341  5071248 1341  5071229 1341  5071214 1341  5071195 1341  
333261 5071181 1341  5071157 1341  5071129 1341  5071109 1341  5071086 1341  5071057 1341  
333262 5071028 1341  5071004 1341  5070969 1343  5070936 1343  5070909 1341  5070880 1341  
333263 5070847 1341  5070817 1343  5070793 1343  5070761 1341  5070732 1341  5070711 1343  
333264 5070680 1341  5070656 1341  5070630 1343  5070611 1343  5070592 1343  5070578 1343  
333265 5070554 1343  5070536 1341  5070529 1345  5070521 1343  5070509 1345  5070511 1343  
333266 5070500 1345  5070500 1345  5070501 1343  5070511 1343  5070516 1343  5070519 1345  
333267 5070530 1343  5070544 1343  5070554 1343  5070567 1345  5070586 1345  5070611 1343  
333268 5070619 1345  5070645 1343  5070668 1343  5070691 1345  5070715 1345  5070734 1345  
333269 5070767 1345  5070791 1345  5070815 1345  5070844 1345  5070869 1343  5070892 1345  
333270 5070920 1345  5070945 1343  5070968 1345  5070990 1347  5071008 1343  5071025 1345  
333271 5071044 1345  5071059 1345  5071079 1343  5071084 1343  5071102 1345  5071106 1345  
333272 5071113 1343  5071122 1343  5071122 1343  5071121 1345  5071122 1343  5071122 1343  
333273 5071113 1343  5071108 1343  5071103 1343  5071094 1343  5071079 1343  5071070 1343  
333274 5071056 1343  5071036 1343  5071024 1341  5071004 1341  5070984 1343  5070969 1343  
333275 5070947 1341  5070931 1343  5070907 1343  5070893 1343  5070871 1341  5070855 1343  
333276 5070836 1343  5070817 1343  5070801 1345  5070782 1345  5070778 1343  5070759 1343  
333277 5070745 1343  5070735 1343  5070731 1343  5070721 1343  5070720 1345  5070717 1343  
333278 5070721 1343  5070720 1345  5070721 1343  5070731 1343  5070729 1345  5070734 1345  
333279 5070753 1345  5070758 1345  5070777 1345  5070802 1343  5070815 1345  5070829 1345  
333280 5070853 1345  5070868 1345  5070892 1345  5070915 1345  5070935 1345  5070958 1345  
333281 5070982 1345  5071006 1345  5071025 1345  5071054 1345  5071082 1345  5071108 1343  
333282 5071127 1343  5071144 1345  5071169 1345  5071192 1345  5071207 1345  5071221 1345  
333283 5071235 1345  5071250 1345  5071269 1345  5071278 1345  5071283 1345  5071285 1343  
333284 5071283 1345  5071283 1345  5071285 1343  5071280 1343  5071270 1343  5071251 1343  
333285 5071245 1345  5071228 1343  5071213 1343  5071194 1343  5071179 1343  5071156 1343  
333286 5071126 1345  5071103 1343  5071079 1343  5071046 1343  5071011 1345  5070982 1345  
333287 5070954 1345  5070922 1343  5070882 1345  5070853 1345  5070820 1345  5070793 1343  
333288 5070758 1345  5070731 1343  5070711 1343  5070678 1343  5070653 1345  5070621 1343  
333289 5070603 1342  5070580 1341  5070556 1342  5070538 1340  5070522 1341  5070514 1340  
333290 5070504 1340  5070492 1338  5070482 1338  5070482 1338  5070472 1338  5070473 1338  
333291 5070484 1336  5070492 1338  5070497 1338  5070507 1336  5070519 1340  5070535 1338  
333292 5070539 1338  5070559 1338  5070583 1338  5070597 1338  5070621 1338  5070640 1338  
333293 5070673 1338  5070697 1338  5070726 1338  5070750 1338  5070783 1338  5070807 1338  
333294 5070837 1336  5070866 1336  5070898 1338  5070923 1336  5070950 1338  5070974 1338  
333295 5070998 1338  5071017 1338  5071049 1340  5071066 1336  5071084 1338  5071108 1338  
333296 5071112 1338  5071125 1340  5071141 1338  5071151 1338  5071151 1338  5071160 1338  
333297 5071159 1340  5071162 1336  5071162 1336  5071153 1336  5071152 1336  5071143 1336  
333298 5071133 1336  5071119 1336  5071117 1332  5071100 1336  5071089 1332  5071069 1332  
333299 5071045 1332  5071028 1336  5071017 1332  5070990 1336  5070969 1332  5070945 1332  
333300 5070931 1332  5070912 1332  5070888 1332  5070864 1332  5070845 1332  5070826 1332  
333301 5070811 1332  5070792 1332  5070778 1332  5070764 1332  5070754 1332  5070744 1332  
333302 5070740 1332  5070730 1332  5070726 1332  5070726 1332  5070726 1332  5070726 1332  
333303 5070730 1332  5070730 1332  5070740 1332  5070744 1332  5070764 1332  5070778 1332  
333304 5070793 1332  5070811 1332  5070826 1332  5070845 1332  5070864 1332  5070885 1336  
333305 5070912 1332  5070940 1332  5070961 1336  5070993 1332  5071014 1336  5071045 1332  
333306 5071066 1336  5071100 1336  5071119 1336  5071143 1336  5071167 1336  5071203 1332  
333307 5071219 1336  5071233 1336  5071256 1338  5071276 1336  5071294 1332  5071304 1332  
333308 5071315 1336  5071323 1332  5071329 1336  5071332 1332  5071332 1332  5071332 1332  
333309 5071323 1332  5071323 1332  5071318 1332  5071304 1332  5071289 1332  5071270 1332  
333310 5071256 1332  5071232 1332  5071213 1332  5071189 1332  5071155 1332  5071132 1332  
333311 5071103 1332  5071070 1332  5071033 1336  5071003 1332  5070966 1336  5070928 1336  
333312 5070902 1332  5070866 1336  5070837 1336  5070808 1336  5070768 1332  5070737 1336  
333313 5070718 1336  5070684 1336  5070654 1332  5070627 1336  5070601 1332  5070574 1336  
333314 5070563 1332  5070539 1332  5070522 1336  5070511 1332  5070498 1336  5070496 1332  
333315 5070487 1332  5070477 1332  5070474 1336  5070487 1332  5070487 1332  5070493 1336  
333316 5070498 1336  5070516 1338  5070525 1338  5070539 1338  5070560 1336  5070573 1338  
333317 5070595 1340  5070621 1338  5070640 1338  5070662 1340  5070697 1338  5070726 1338  
333318 5070750 1338  5070783 1338  5070807 1338  5070835 1338  5070864 1338  5070896 1340  
333319 5070926 1338  5070948 1340  5070982 1340  5071006 1340  5071025 1340  5071049 1340  
333320 5071074 1338  5071098 1338  5071111 1340  5071132 1338  5071141 1338  5071159 1340  
333321 5071164 1340  5071173 1340  5071173 1340  5071182 1340  5071175 1338  5071171 1341  
333322 5071171 1341  5071162 1341  5071157 1341  5071149 1340  5071129 1341  5071124 1341  
333323 5071109 1341  5071095 1341  5071082 1340  5071062 1341  5071038 1341  5071014 1341  
333324 5071004 1341  5070980 1341  5070957 1341  5070933 1341  5070909 1341  5070885 1341  
333325 5070860 1343  5070837 1341  5070821 1343  5070804 1341  5070783 1343  5070769 1343  
333326 5070755 1343  5070735 1343  5070731 1343  5070716 1343  5070710 1345  5070711 1343  
333327 5070692 1343  5070692 1343  5070688 1343  5070691 1345  5070692 1343  5070702 1343  
333328 5070711 1343  5070716 1343  5070731 1343  5070743 1345  5070759 1343  5070778 1343  
333329 5070802 1343  5070820 1345  5070845 1343  5070869 1343  5070892 1345  5070915 1345  
333330 5070944 1345  5070969 1343  5071001 1345  5071025 1345  5071059 1345  5071082 1345  
333331 5071111 1345  5071135 1345  5071169 1345  5071191 1347  5071211 1345  5071234 1347  
333332 5071248 1347  5071277 1347  5071291 1347  5071305 1347  5071310 1347  5071321 1345  
333333 5071326 1345  5071337 1343  5071336 1345  5071326 1345  5071323 1343  5071323 1343  
333334 5071313 1343  5071309 1343  5071294 1343  5071281 1341  5071254 1340  5071229 1341  
333335 5071210 1341  5071189 1338  5071160 1338  5071130 1340  5071108 1338  5071076 1336  
333336 5071041 1338  5071009 1336  5070975 1336  5070942 1336  5070913 1336  5070878 1332  
333337 5070845 1332  5070818 1336  5070788 1332  5070751 1336  5070726 1332  5070694 1336  
333338 5070668 1332  5070636 1336  5070621 1332  5070596 1332  5070565 1336  5070551 1336  
333339 5070539 1332  5070530 1332  5070520 1332  5070507 1336  5070510 1332  5070501 1332  
333340 5070498 1336  5070498 1336  5070507 1336  5070522 1336  5070525 1338  5070536 1336  
333341 5070551 1336  5070565 1336  5070584 1336  5070608 1336  5070625 1338  5070649 1338  
333342 5070675 1336  5070699 1336  5070726 1338  5070761 1336  5070785 1336  5070818 1336  
333343 5070842 1336  5070875 1336  5070907 1338  5070936 1338  5070966 1336  5070990 1336  
333344 5071022 1332  5071042 1336  5071066 1336  5071090 1336  5071114 1336  5071128 1336  
333345 5071143 1336  5071160 1338  5071175 1338  5071189 1338  5071200 1336  5071208 1338  
333346 5071210 1336  5071214 1336  5071213 1338  5071213 1338  5071208 1338  5071210 1336  
333347 5071189 1338  5071184 1338  5071175 1338  5071160 1338  5071141 1338  5071127 1338  
333348 5071108 1338  5071084 1338  5071065 1338  5071041 1338  5071017 1338  5070998 1338  
333349 5070974 1338  5070948 1340  5070926 1338  5070907 1338  5070885 1336  5070859 1338  
333350 5070835 1338  5070817 1338  5070797 1338  5070773 1338  5070759 1338  5070740 1338  
333351 5070726 1338  5070723 1336  5070706 1338  5070697 1338  5070692 1338  5070683 1338  
333352 5070683 1338  5070684 1336  5070692 1338  5070697 1338  5070697 1338  5070716 1338  
333353 5070726 1338  5070740 1338  5070761 1336  5070783 1338  5070805 1340  5070824 1340  
333354 5070850 1338  5070872 1340  5070896 1340  5070926 1338  5070958 1340  5070982 1340  
333355 5071012 1338  5071039 1340  5071074 1338  5071108 1338  5071130 1340  5071159 1340  
333356 5071184 1338  5071211 1340  5071232 1338  5071256 1338  5071273 1340  5071288 1340  
333357 5071308 1338  5071318 1338  5071332 1338  5071342 1338  5071351 1338  5071351 1338  
333358 5071351 1338  5071353 1336  5071353 1336  5071342 1338  5071334 1336  5071318 1338  
333359 5071310 1336  5071291 1336  5071277 1336  5071252 1336  5071227 1338  5071213 1332  
333360 5071175 1338  5071151 1338  5071119 1336  5071089 1338  5071062 1336  5071027 1338  
333361 5070998 1338  5070965 1338  5070936 1338  5070898 1338  5070863 1340  5070835 1338  
333362 5070805 1340  5070772 1340  5070740 1338  5070715 1340  5070691 1340  5070657 1340  
333363 5070640 1338  5070619 1340  5070595 1340  5070591 1340  5070571 1340  5070555 1341  
333364 5070548 1340  5070538 1340  5070538 1340  5070533 1340  5070532 1341  5070538 1340  
333365 5070546 1341  5070557 1340  5070562 1340  5070581 1340  5070594 1341  5070613 1341  
333366 5070632 1341  5070646 1341  5070670 1341  5070694 1341  5070724 1340  5070746 1341  
333367 5070782 1340  5070804 1341  5070832 1341  5070861 1341  5070893 1343  5070923 1341  
333368 5070957 1341  5070979 1343  5071009 1341  5071028 1341  5071062 1341  5071084 1343  
333369 5071109 1341  5071127 1343  5071146 1343  5071172 1341  5071186 1341  5071205 1341  
333370 5071214 1341  5071214 1341  5071229 1341  5071238 1341  5071238 1341  5071238 1341  
333371 5071239 1341  5071238 1341  5071238 1341  5071226 1340  5071214 1341  5071210 1341  
333372 5071196 1341  5071183 1340  5071164 1340  5071140 1340  5071116 1340  5071105 1341  
333373 5071081 1341  5071057 1341  5071028 1341  5071004 1341  5070980 1341  5070957 1341  
333374 5070933 1341  5070909 1341  5070887 1340  5070863 1340  5070839 1340  5070818 1341  
333375 5070794 1341  5070782 1340  5070756 1342  5070737 1341  5070724 1340  5070720 1340  
333376 5070705 1340  5070694 1341  5070691 1340  5070689 1341  5070679 1341  5070681 1340  
333377 5070681 1340  5070691 1340  5070694 1341  5070715 1340  5070719 1340  5070734 1340  
333378 5070748 1340  5070772 1340  5070786 1340  5070815 1340  5070834 1340  5070858 1340  
333379 5070882 1340  5070910 1340  5070939 1340  5070963 1340  5070989 1338  5071017 1338  
333380 5071049 1340  5071073 1340  5071106 1340  5071125 1340  5071149 1340  5071182 1340  
333381 5071206 1340  5071216 1340  5071240 1340  5071254 1340  5071272 1341  5071288 1340  
333382 5071307 1340  5071310 1341  5071325 1341  5071324 1341  5071324 1341  5071329 1341  
333383 5071325 1341  5071326 1340  5071315 1341  5071310 1341  5071294 1343  5071281 1341  
333384 5071262 1341  5071239 1341  5071224 1341  5071207 1340  5071181 1341  5071148 1341  
333385 5071124 1341  5071095 1341  5071071 1341  5071038 1341  5071011 1340  5070971 1341  
333386 5070939 1340  5070910 1340  5070882 1340  5070848 1340  5070818 1341  5070796 1340  
333387 5070761 1341  5070737 1341  5070719 1340  5070691 1340  5070670 1341  5070648 1340  
333388 5070632 1341  5070618 1341  5070613 1341  5070595 1340  5070589 1341  5070579 1341  
333389 5070571 1340  5070570 1341  5070579 1341  5070579 1341  5070580 1341  5070594 1341  
333390 5070603 1341  5070618 1341  5070622 1341  5070648 1340  5070661 1341  5070679 1341  
333391 5070704 1341  5070723 1341  5070746 1341  5070772 1340  5070805 1340  5070823 1341  
333392 5070858 1340  5070883 1338  5070910 1340  5070934 1340  5070963 1340  5070987 1340  
333393 5071015 1340  5071049 1340  5071073 1340  5071097 1340  5071116 1340  5071141 1338  
333394 5071160 1338  5071182 1340  5071197 1340  5071211 1340  5071216 1340  5071230 1340  
333395 5071231 1340  5071240 1340  5071251 1338  5071249 1340  5071240 1340  5071240 1340  
333396 5071232 1338  5071227 1338  5071216 1340  5071208 1338  5071199 1338  5071184 1338  
333397 5071159 1340  5071132 1338  5071117 1338  5071098 1338  5071084 1338  5071059 1340  
333398 5071025 1340  5071011 1340  5070980 1341  5070958 1340  5070936 1338  5070910 1340  
333399 5070882 1340  5070858 1340  5070834 1340  5070815 1340  5070785 1341  5070761 1341  
333400 5070748 1340  5070734 1340  5070719 1340  5070713 1341  5070695 1340  5070691 1340  
333401 5070681 1340  5070670 1341  5070670 1341  5070670 1341  5070672 1340  5070670 1341  
333402 5070679 1341  5070691 1340  5070705 1340  5070715 1340  5070732 1341  5070746 1341  
333403 5070756 1341  5070780 1341  5070804 1341  5070823 1341  5070848 1340  5070871 1341  
333404 5070895 1341  5070920 1340  5070939 1340  5070971 1341  5070996 1340  5071025 1340  
333405 5071047 1341  5071071 1341  5071105 1341  5071126 1340  5071148 1341  5071173 1340  
333406 5071186 1341  5071211 1340  5071224 1341  5071240 1340  5071254 1340  5071264 1340  
333407 5071273 1340  5071283 1340  5071281 1341  5071288 1340  5071288 1340  5071288 1340  
333408 5071283 1340  5071273 1340  5071255 1340  5071249 1340  5071230 1340  5071216 1340  
333409 5071208 1338  5071182 1340  5071164 1340  5071140 1340  5071116 1340  5071089 1338  
333410 5071063 1340  5071041 1338  5071015 1340  5070987 1340  5070958 1340  5070934 1340  
333411 5070906 1340  5070882 1340  5070858 1340  5070825 1340  5070805 1340  5070780 1341  
333412 5070758 1340  5070734 1340  5070715 1340  5070696 1340  5070681 1340  5070662 1340  
333413 5070656 1341  5070648 1340  5070638 1340  5070638 1340  5070633 1340  5070633 1340  
333414 5070632 1341  5070633 1340  5070637 1341  5070646 1341  5070661 1341  5070670 1341  
333415 5070689 1341  5070703 1341  5070718 1341  5070738 1340  5070758 1340  5070782 1340  
333416 5070796 1340  5070820 1340  5070839 1340  5070872 1340  5070896 1340  5070920 1340  
333417 5070939 1340  5070972 1340  5070998 1338  5071027 1338  5071050 1338  5071074 1338  
333418 5071098 1338  5071117 1338  5071141 1338  5071165 1338  5071184 1338  5071200 1336  
333419 5071214 1336  5071218 1338  5071232 1338  5071241 1338  5071256 1338  5071256 1338  
333420 5071267 1336  5071256 1338  5071256 1338  5071256 1338  5071251 1338  5071241 1338  
333421 5071232 1338  5071218 1338  5071206 1340  5071199 1338  5071184 1338  5071160 1338  
333422 5071130 1340  5071117 1338  5071098 1338  5071074 1338  5071041 1338  5071019 1336  
333423 5070998 1338  5070966 1336  5070941 1338  5070913 1336  5070888 1338  5070864 1338  
333424 5070840 1338  5070821 1338  5070799 1336  5070773 1338  5070751 1336  5070735 1338  
333425 5070716 1338  5070696 1340  5070692 1338  5070683 1338  5070664 1338  5070659 1338  
333426 5070650 1338  5070648 1340  5070650 1338  5070648 1340  5070648 1340  5070664 1338  
333427 5070671 1340  5070681 1340  5070692 1338  5070695 1340  5070715 1340  5070726 1338  
333428 5070750 1338  5070762 1340  5070788 1338  5070807 1338  5070826 1338  5070842 1336  
333429 5070875 1336  5070888 1338  5070923 1336  5070942 1336  5070974 1338  5070990 1336  
333430 5071019 1336  5071041 1338  5071065 1338  5071089 1338  5071108 1338  5071117 1338  
333431 5071141 1338  5071160 1338  5071175 1338  5071184 1338  5071199 1338  5071208 1338  
333432 5071213 1338  5071217 1338  5071216 1340  5071217 1338  5071216 1340  5071213 1338  
333433 5071213 1338  5071199 1338  5071189 1338  5071184 1338  5071165 1338  5071151 1338  
333434 5071132 1338  5071119 1336  5071098 1338  5071086 1336  5071062 1336  5071031 1338  
333435 5071014 1336  5070990 1336  5070966 1336  5070942 1336  5070923 1336  5070899 1336  
333436 5070875 1336  5070850 1338  5070828 1336  5070808 1336  5070789 1336  5070765 1336  
333437 5070740 1338  5070727 1336  5070716 1338  5070706 1338  5070697 1338  5070692 1338  
333438 5070683 1338  5070675 1336  5070673 1338  5070664 1338  5070664 1338  5070662 1340  
333439 5070672 1340  5070681 1340  5070691 1340  5070707 1338  5070715 1340  5070726 1338  
333440 5070735 1338  5070748 1340  5070762 1340  5070788 1338  5070805 1340  5070826 1338  
333441 5070839 1340  5070863 1340  5070888 1338  5070910 1340  5070937 1336  5070958 1340  
333442 5070984 1338  5071012 1338  5071027 1338  5071050 1338  5071084 1338  5071098 1338  
333443 5071119 1336  5071132 1338  5071161 1338  5071175 1338  5071189 1338  5071208 1338  
333444 5071213 1338  5071218 1338  5071232 1338  5071242 1338  5071242 1338  5071240 1340  
333445 5071240 1340  5071241 1338  5071231 1340  5071226 1340  5071216 1340  5071211 1340  
333446 5071206 1340  5071189 1338  5071172 1341  5071149 1340  5071130 1340  5071113 1338  
333447 5071097 1340  5071073 1340  5071050 1338  5071015 1340  5070998 1338  5070973 1340  
333448 5070939 1340  5070922 1338  5070896 1340  5070874 1338  5070839 1340  5070821 1338  
333449 5070797 1338  5070772 1340  5070750 1338  5070726 1338  5070715 1340  5070695 1340  
333450 5070683 1338  5070662 1340  5070649 1338  5070640 1338  5070633 1340  5070624 1340  
333451 5070625 1338  5070625 1338  5070621 1338  5070625 1338  5070624 1340  5070635 1338  
333452 5070638 1340  5070648 1340  5070664 1338  5070673 1338  5070692 1338  5070705 1340  
333453 5070721 1338  5070726 1338  5070750 1338  5070773 1338  5070788 1338  5070816 1338  
333454 5070835 1338  5070858 1340  5070883 1338  5070907 1338  5070926 1338  5070941 1338  
333455 5070963 1340  5070989 1338  5071012 1338  5071027 1338  5071049 1340  5071065 1338  
333456 5071084 1338  5071098 1338  5071111 1340  5071117 1338  5071132 1338  5071141 1338  
333457 5071151 1338  5071151 1338  5071160 1338  5071160 1338  5071161 1338  5071151 1338  
333458 5071151 1338  5071141 1338  5071132 1338  5071127 1338  5071117 1338  5071106 1340  
333459 5071089 1338  5071076 1336  5071062 1336  5071033 1336  5071017 1338  5071007 1338  
333460 5070984 1338  5070964 1338  5070950 1338  5070926 1338  5070913 1336  5070888 1338  
333461 5070874 1338  5070860 1338  5070840 1338  5070821 1338  5070807 1338  5070788 1338  
333462 5070772 1340  5070762 1340  5070748 1340  5070740 1338  5070735 1338  5070724 1340  
333463 5070724 1340  5070724 1340  5070720 1340  5070720 1340  5070718 1341  5070723 1341  
333464 5070724 1340  5070734 1340  5070738 1340  5070748 1340  5070758 1340  5070773 1338  
333465 5070782 1340  5070796 1340  5070817 1338  5070826 1338  5070850 1338  5070864 1338  
333466 5070887 1340  5070907 1338  5070926 1338  5070950 1338  5070965 1338  5070989 1338  
333467 5071011 1340  5071030 1340  5071049 1340  5071073 1340  5071098 1338  5071111 1340  
333468 5071127 1338  5071149 1340  5071165 1338  5071183 1340  5071188 1340  5071197 1340  
333469 5071207 1340  5071211 1340  5071216 1340  5071216 1340  5071227 1338  5071227 1338  
333470 5071216 1340  5071216 1340  5071211 1340  5071208 1338  5071199 1338  5071184 1338  
333471 5071175 1338  5071160 1338  5071132 1338  5071117 1338  5071108 1338  5071084 1338  
333472 5071060 1338  5071031 1338  5071012 1338  5070989 1338  5070960 1338  5070937 1336  
333473 5070912 1338  5070888 1338  5070864 1338  5070840 1338  5070821 1338  5070797 1338  
333474 5070773 1338  5070750 1338  5070735 1338  5070715 1340  5070696 1340  5070683 1338  
333475 5070664 1338  5070649 1338  5070638 1340  5070635 1338  5070619 1340  5070614 1340  
333476 5070615 1340  5070605 1340  5070605 1340  5070595 1340  5070594 1341  5070605 1340  
333477 5070614 1340  5070619 1340  5070624 1340  5070635 1338  5070638 1340  5070657 1340  
333478 5070662 1340  5070683 1338  5070695 1340  5070715 1340  5070734 1340  5070748 1340  
333479 5070764 1338  5070786 1340  5070816 1338  5070836 1338  5070858 1340  5070872 1340  
333480 5070896 1340  5070920 1340  5070933 1341  5070958 1340  5070972 1340  5070987 1340  
333481 5071006 1340  5071015 1340  5071030 1340  5071049 1340  5071059 1340  5071063 1340  
333482 5071073 1340  5071081 1341  5071087 1340  5071095 1341  5071097 1340  5071095 1341  
333483 5071097 1340  5071095 1341  5071089 1338  5071082 1340  5071073 1340  5071065 1338  
333484 5071063 1340  5071049 1340  5071030 1340  5071025 1340  5071012 1338  5070998 1338  
333485 5070984 1338  5070965 1338  5070949 1340  5070936 1338  5070922 1338  5070907 1338  
333486 5070888 1338  5070874 1338  5070858 1340  5070840 1338  5070825 1340  5070817 1338  
333487 5070807 1338  5070797 1338  5070788 1338  5070773 1338  5070764 1338  5070764 1338  
333488 5070759 1338  5070759 1338  5070748 1340  5070750 1338  5070748 1340  5070758 1340  
333489 5070759 1338  5070762 1340  5070772 1340  5070783 1338  5070786 1340  5070805 1340  
333490 5070820 1340  5070824 1340  5070839 1340  5070858 1340  5070872 1340  5070887 1340  
333491 5070906 1340  5070925 1340  5070948 1340  5070963 1340  5070987 1340  5071006 1340  
333492 5071025 1340  5071039 1340  5071059 1340  5071082 1340  5071097 1340  5071115 1340  
333493 5071130 1340  5071140 1340  5071162 1341  5071173 1340  5071188 1340  5071197 1340  
333494 5071206 1340  5071211 1340  5071217 1338  5071226 1340  5071226 1340  5071231 1340  
333495 5071226 1340  5071226 1340  5071216 1340  5071216 1340  5071208 1338  5071199 1338  
333496 5071182 1340  5071175 1338  5071151 1338  5071132 1338  5071117 1338  5071098 1338  
333497 5071082 1340  5071059 1340  5071031 1338  5071012 1338  5070996 1340  5070963 1340  
333498 5070948 1340  5070920 1340  5070896 1340  5070872 1340  5070849 1340  5070824 1340  
333499 5070807 1338  5070782 1340  5070758 1340  5070734 1340  5070715 1340  5070695 1340  
333500 5070679 1341  5070662 1340  5070646 1341  5070633 1340  5070618 1341  5070614 1340  
333501 5070603 1341  5070594 1341  5070589 1341  5070589 1341  5070589 1341  5070590 1340  
333502 5070589 1341  5070589 1341  5070594 1341  5070603 1341  5070611 1343  5070618 1341  
333503 5070622 1341  5070636 1341  5070656 1341  5070670 1341  5070689 1341  5070713 1341  
333504 5070724 1340  5070748 1340  5070761 1341  5070786 1340  5070813 1341  5070834 1340  
333505 5070847 1341  5070872 1340  5070896 1340  5070919 1341  5070934 1340  5070958 1340  
333506 5070971 1341  5070996 1340  5071011 1340  5071024 1341  5071038 1341  5071059 1340  
333507 5071063 1340  5071082 1340  5071087 1340  5071097 1340  5071097 1340  5071106 1340  
333508 5071106 1340  5071111 1340  5071111 1340  5071111 1340  5071106 1340  5071097 1340  
333509 5071097 1340  5071089 1338  5071082 1340  5071073 1340  5071063 1340  5071050 1338  
333510 5071039 1340  5071025 1340  5071011 1340  5070998 1338  5070982 1340  5070974 1338  
333511 5070958 1340  5070939 1340  5070925 1340  5070910 1340  5070906 1340  5070887 1340  
333512 5070872 1340  5070863 1340  5070858 1340  5070839 1340  5070834 1340  5070824 1340  
333513 5070818 1341  5070818 1341  5070818 1341  5070813 1341  5070818 1341  5070818 1341  
333514 5070817 1343  5070818 1341  5070823 1341  5070833 1341  5070837 1341  5070847 1341  
333515 5070861 1341  5070871 1341  5070884 1343  5070893 1343  5070917 1343  5070933 1341  
333516 5070947 1341  5070962 1341  5070985 1341  5071004 1341  5071012 1343  5071036 1343  
333517 5071057 1341  5071071 1341  5071086 1341  5071109 1341  5071127 1343  5071148 1341  
333518 5071162 1341  5071184 1343  5071205 1341  5071210 1341  5071224 1341  5071238 1341  
333519 5071248 1341  5071253 1341  5071262 1341  5071261 1343  5071272 1341  5071270 1343  
333520 5071272 1341  5071272 1341  5071262 1341  5071253 1341  5071248 1341  5071238 1341  
333521 5071229 1341  5071214 1341  5071205 1341  5071186 1341  5071170 1343  5071146 1343  
333522 5071129 1341  5071108 1343  5071084 1343  5071060 1343  5071038 1341  5071012 1343  
333523 5070985 1341  5070961 1341  5070936 1343  5070919 1341  5070885 1341  5070861 1341  
333524 5070832 1341  5070815 1340  5070783 1343  5070761 1341  5070732 1341  5070713 1341  
333525 5070694 1341  5070670 1341  5070656 1341  5070637 1341  5070622 1341  5070613 1341  
333526 5070592 1343  5070588 1343  5070580 1341  5070560 1341  5070560 1341  5070555 1341  
333527 5070556 1341  5070556 1341  5070560 1341  5070560 1341  5070570 1341  5070579 1341  
333528 5070588 1343  5070592 1343  5070615 1340  5070622 1341  5070637 1341  5070656 1341  
333529 5070670 1341  5070694 1341  5070720 1340  5070737 1341  5070761 1341  5070785 1341  
333530 5070812 1343  5070821 1343  5070847 1341  5070872 1340  5070895 1341  5070919 1341  
333531 5070939 1340  5070957 1341  5070980 1341  5071003 1343  5071014 1341  5071028 1341  
333532 5071047 1341  5071062 1341  5071081 1341  5071087 1340  5071095 1341  5071105 1341  
333533 5071104 1341  5071111 1340  5071109 1341  5071109 1341  5071109 1341  5071111 1340  
333534 5071105 1341  5071095 1341  5071095 1341  5071081 1341  5071073 1340  5071063 1340  
333535 5071049 1340  5071038 1341  5071025 1340  5071009 1341  5070997 1340  5070982 1340  
333536 5070963 1340  5070949 1340  5070934 1340  5070919 1341  5070904 1341  5070887 1340  
333537 5070872 1340  5070858 1340  5070848 1340  5070839 1340  5070823 1341  5070820 1340  
333538 5070813 1341  5070805 1340  5070804 1341  5070794 1341  5070794 1341  5070786 1340  
333539 5070796 1340  5070794 1341  5070794 1341  5070804 1341  5070805 1340  5070817 1343  
333540 5070824 1340  5070837 1341  5070847 1341  5070861 1341  5070869 1343  5070895 1341  
333541 5070909 1341  5070923 1341  5070937 1341  5070961 1341  5070980 1341  5071004 1341  
333542 5071025 1340  5071038 1341  5071062 1341  5071086 1341  5071105 1341  5071125 1340  
333543 5071138 1341  5071162 1341  5071181 1341  5071195 1341  5071208 1343  5071224 1341  
333544 5071229 1341  5071238 1341  5071251 1343  5071264 1340  5071264 1340  5071262 1341  
333545 5071273 1340  5071272 1341  5071272 1341  5071262 1341  5071253 1341  5071248 1341  
333546 5071238 1341  5071231 1340  5071216 1340  5071207 1340  5071188 1340  5071173 1340  
333547 5071149 1340  5071127 1338  5071105 1341  5071082 1340  5071059 1340  5071030 1340  
333548 5071004 1341  5070973 1340  5070949 1340  5070919 1341  5070887 1340  5070858 1340  
333549 5070825 1340  5070796 1340  5070762 1340  5070737 1341  5070713 1341  5070689 1341  
333550 5070661 1341  5070633 1340  5070615 1340  5070595 1340  5070580 1341  5070555 1341  
333551 5070536 1341  5070522 1341  5070514 1340  5070503 1341  5070493 1341  5070489 1341  
333552 5070489 1341  5070487 1343  5070493 1341  5070493 1341  5070503 1341  5070513 1341  
333553 5070517 1341  5070532 1341  5070544 1343  5070556 1341  5070580 1341  5070595 1340  
333554 5070618 1342  5070637 1341  5070661 1341  5070679 1341  5070713 1341  5070734 1340  
333555 5070756 1341  5070785 1341  5070813 1341  5070837 1341  5070861 1341  5070887 1340  
333556 5070919 1341  5070938 1341  5070961 1341  5070985 1341  5071008 1343  5071024 1341  
333557 5071047 1341  5071057 1341  5071071 1341  5071094 1343  5071105 1341  5071109 1341  
333558 5071113 1343  5071124 1341  5071127 1343  5071127 1343  5071129 1341  5071127 1343  
333559 5071129 1341  5071122 1343  5071113 1343  5071109 1341  5071103 1343  5071086 1341  
333560 5071079 1343  5071060 1343  5071046 1343  5071027 1343  5071012 1343  5070993 1343  
333561 5070979 1343  5070960 1343  5070947 1341  5070933 1341  5070917 1343  5070904 1341  
333562 5070879 1343  5070861 1341  5070847 1341  5070831 1343  5070817 1343  5070812 1343  
333563 5070793 1343  5070785 1341  5070780 1341  5070770 1341  5070770 1341  5070761 1341  
333564 5070761 1341  5070762 1340  5070770 1341  5070770 1341  5070780 1341  5070785 1341  
333565 5070794 1341  5070813 1341  5070818 1341  5070833 1341  5070849 1340  5070872 1340  
333566 5070887 1340  5070906 1340  5070925 1340  5070949 1340  5070963 1340  5070996 1340  
333567 5071014 1341  5071038 1341  5071063 1340  5071086 1341  5071111 1340  5071130 1340  
333568 5071159 1340  5071182 1340  5071207 1340  5071215 1341  5071241 1338  5071255 1340  
333569 5071272 1341  5071286 1341  5071297 1340  5071310 1341  5071315 1341  5071324 1341  
333570 5071326 1340  5071329 1341  5071331 1340  5071329 1341  5071325 1341  5071315 1341  
333571 5071310 1341  5071296 1341  5071286 1341  5071272 1341  5071253 1341  5071238 1341  
333572 5071210 1341  5071186 1341  5071157 1341  5071129 1341  5071106 1340  5071071 1341  
333573 5071039 1340  5071011 1340  5070972 1340  5070939 1340  5070910 1340  5070880 1341  
333574 5070839 1340  5070815 1340  5070782 1340  5070746 1341  5070719 1340  5070691 1340  
333575 5070656 1341  5070624 1340  5070603 1341  5070579 1341  5070557 1340  5070536 1341  
333576 5070517 1341  5070503 1341  5070489 1341  5070479 1341  5070469 1341  5070463 1343  
333577 5070463 1343  5070465 1341  5070465 1341  5070469 1341  5070479 1341  5070489 1341  
333578 5070503 1341  5070513 1341  5070522 1341  5070546 1341  5070560 1341  5070589 1341  
333579 5070614 1340  5070632 1341  5070657 1340  5070691 1340  5070718 1341  5070746 1341  
333580 5070782 1340  5070815 1340  5070839 1340  5070871 1341  5070904 1341  5070923 1341  
333581 5070958 1340  5070987 1340  5071011 1340  5071038 1341  5071057 1341  5071087 1340  
333582 5071106 1340  5071124 1341  5071138 1341  5071149 1340  5071162 1341  5071173 1340  
333583 5071182 1340  5071188 1340  5071188 1340  5071197 1340  5071187 1340  5071188 1340  
333584 5071183 1340  5071173 1340  5071164 1340  5071148 1341  5071130 1340  5071116 1340  
333585 5071106 1340  5071087 1340  5071063 1340  5071039 1340  5071025 1340  5071006 1340  
333586 5070982 1340  5070962 1341  5070939 1340  5070919 1341  5070904 1341  5070882 1340  
333587 5070856 1341  5070837 1341  5070823 1341  5070813 1341  5070794 1341  5070780 1341  
333588 5070761 1341  5070756 1341  5070746 1341  5070746 1341  5070735 1343  5070732 1341  
333589 5070732 1341  5070732 1341  5070737 1341  5070746 1341  5070756 1341  5070761 1341  
333590 5070780 1341  5070785 1341  5070804 1341  5070825 1340  5070837 1341  5070863 1340  
333591 5070887 1340  5070909 1341  5070934 1340  5070958 1340  5070982 1340  5071006 1340  
333592 5071025 1340  5071059 1340  5071082 1340  5071109 1341  5071129 1341  5071159 1340  
333593 5071188 1340  5071210 1341  5071231 1340  5071253 1341  5071281 1341  5071297 1340  
333594 5071310 1341  5071329 1341  5071339 1341  5071355 1340  5071363 1341  5071363 1341  
333595 5071374 1340  5071372 1341  5071374 1340  5071372 1341  5071361 1343  5071353 1341  
333596 5071340 1340  5071325 1341  5071310 1341  5071296 1341  5071273 1340  5071248 1341  
333597 5071216 1340  5071196 1341  5071162 1341  5071129 1341  5071095 1341  5071062 1341  
333598 5071025 1340  5070985 1341  5070957 1341  5070919 1341  5070880 1341  5070836 1343  
333599 5070813 1341  5070770 1341  5070732 1341  5070703 1341  5070669 1343  5070635 1343  
333600 5070611 1343  5070578 1343  5070555 1341  5070522 1341  5070513 1341  5070486 1345  
333601 5070466 1345  5070454 1343  5070434 1343  5070430 1343  5070425 1343  5070425 1343  
333602 5070425 1343  5070431 1341  5070430 1343  5070434 1343  5070454 1343  5070468 1343  
333603 5070487 1343  5070503 1341  5070522 1341  5070546 1341  5070570 1341  5070594 1341  
333604 5070622 1341  5070656 1341  5070691 1340  5070719 1340  5070746 1341  5070780 1341  
333605 5070820 1340  5070847 1341  5070885 1341  5070919 1341  5070947 1341  5070980 1341  
333606 5071011 1340  5071039 1340  5071062 1341  5071095 1341  5071116 1340  5071138 1341  
333607 5071162 1341  5071181 1341  5071207 1340  5071210 1341  5071214 1341  5071229 1341  
333608 5071229 1341  5071238 1341  5071238 1341  5071229 1341  5071224 1341  5071214 1341  
333609 5071210 1341  5071195 1341  5071186 1341  5071162 1341  5071148 1341  5071129 1341  
333610 5071108 1343  5071084 1343  5071063 1340  5071036 1343  5071012 1343  5070995 1341  
333611 5070971 1341  5070936 1343  5070917 1343  5070893 1343  5070860 1343  5070836 1343  
333612 5070822 1343  5070802 1343  5070783 1343  5070759 1343  5070746 1341  5070735 1343  
333613 5070721 1343  5070717 1343  5070713 1341  5070713 1341  5070703 1341  5070703 1341  
333614 5070703 1341  5070713 1341  5070718 1341  5070723 1341  5070732 1341  5070746 1341  
333615 5070761 1341  5070780 1341  5070796 1340  5070820 1340  5070837 1341  5070861 1341  
333616 5070885 1341  5070910 1340  5070934 1340  5070961 1341  5070985 1341  5071015 1340  
333617 5071049 1340  5071081 1341  5071111 1340  5071130 1340  5071162 1341  5071197 1340  
333618 5071216 1340  5071248 1341  5071273 1340  5071296 1341  5071316 1340  5071329 1341  
333619 5071353 1341  5071372 1341  5071377 1341  5071386 1341  5071396 1341  5071406 1341  
333620 5071406 1341  5071406 1341  5071396 1341  5071386 1341  5071377 1341  5071363 1341  
333621 5071347 1343  5071329 1341  5071310 1341  5071286 1341  5071262 1341  5071229 1341  
333622 5071205 1341  5071172 1341  5071129 1342  5071105 1341  5071060 1343  5071022 1343  
333623 5070995 1341  5070957 1341  5070920 1340  5070880 1341  5070837 1341  5070802 1343  
333624 5070762 1340  5070724 1340  5070694 1341  5070656 1341  5070622 1341  5070592 1343  
333625 5070560 1341  5070536 1341  5070516 1343  5070493 1341  5070468 1343  5070452 1345  
333626 5070434 1343  5070430 1343  5070425 1343  5070415 1343  5070411 1343  5070417 1341  
333627 5070416 1343  5070426 1341  5070435 1343  5070444 1343  5070465 1341  5070487 1343  
333628 5070503 1341  5070522 1341  5070544 1343  5070578 1343  5070613 1341  5070635 1343  
333629 5070669 1343  5070702 1343  5070737 1341  5070770 1341  5070813 1341  5070845 1343  
333630 5070880 1341  5070917 1343  5070955 1343  5070985 1341  5071022 1343  5071057 1341  
333631 5071086 1341  5071109 1341  5071137 1343  5071161 1343  5071181 1341  5071196 1341  
333632 5071208 1343  5071224 1341  5071237 1343  5071248 1341  5071248 1341  5071251 1343  
333633 5071246 1343  5071251 1343  5071246 1343  5071237 1343  5071228 1343  5071213 1343  
333634 5071202 1345  5071184 1343  5071169 1345  5071146 1343  5071121 1345  5071103 1343  
333635 5071078 1345  5071054 1345  5071021 1345  5070992 1345  5070968 1345  5070936 1343  
333636 5070915 1345  5070882 1345  5070858 1345  5070834 1345  5070812 1343  5070783 1343  
333637 5070758 1345  5070745 1343  5070720 1345  5070711 1343  5070692 1343  5070688 1343  
333638 5070669 1343  5070669 1343  5070661 1341  5070656 1341  5070653 1345  5070656 1341  
333639 5070661 1341  5070669 1343  5070679 1341  5070692 1343  5070702 1343  5070716 1343  
333640 5070737 1341  5070759 1343  5070783 1343  5070802 1343  5070831 1343  5070860 1343  
333641 5070884 1343  5070917 1343  5070946 1343  5070979 1343  5071003 1343  5071038 1341  
333642 5071062 1341  5071103 1343  5071129 1341  5071162 1341  5071186 1341  5071215 1341  
333643 5071246 1343  5071272 1341  5071296 1341  5071315 1341  5071339 1341  5071353 1341  
333644 5071372 1341  5071377 1341  5071385 1343  5071396 1341  5071395 1343  5071404 1343  
333645 5071395 1343  5071395 1343  5071375 1343  5071371 1343  5071353 1341  5071339 1341  
333646 5071325 1341  5071294 1343  5071281 1341  5071248 1341  5071214 1341  5071195 1341  
333647 5071157 1341  5071124 1341  5071086 1341  5071047 1341  5071008 1343  5070980 1341  
333648 5070938 1341  5070903 1343  5070861 1341  5070822 1343  5070793 1343  5070755 1343  
333649 5070717 1343  5070688 1343  5070654 1343  5070618 1341  5070588 1343  5070559 1343  
333650 5070530 1343  5070511 1343  5070487 1343  5070468 1343  5070454 1343  5070436 1341  
333651 5070430 1343  5070425 1343  5070427 1341  5070425 1343  5070431 1341  5070436 1341  
333652 5070446 1341  5070455 1341  5070469 1341  5070493 1341  5070517 1341  5070532 1341  
333653 5070556 1341  5070589 1341  5070613 1341  5070646 1341  5070679 1341  5070713 1341  
333654 5070737 1341  5070770 1341  5070813 1341  5070837 1341  5070880 1341  5070919 1341  
333655 5070947 1341  5070985 1341  5071014 1341  5071047 1341  5071079 1343  5071103 1343  
333656 5071129 1341  5071157 1341  5071180 1343  5071205 1342  5071208 1343  5071224 1341  
333657 5071238 1341  5071238 1341  5071246 1343  5071253 1341  5071253 1341  5071248 1341  
333658 5071238 1341  5071238 1341  5071224 1341  5071210 1341  5071197 1340  5071183 1340  
333659 5071162 1341  5071138 1341  5071114 1341  5071095 1341  5071062 1341  5071038 1341  
333660 5071008 1343  5070986 1341  5070957 1341  5070922 1343  5070904 1341  5070871 1341  
333661 5070845 1343  5070818 1341  5070783 1343  5070759 1343  5070737 1341  5070716 1343  
333662 5070704 1341  5070678 1343  5070669 1343  5070653 1345  5070633 1345  5070630 1343  
333663 5070621 1343  5070619 1345  5070615 1345  5070619 1345  5070619 1345  5070621 1343  
333664 5070635 1343  5070645 1343  5070659 1343  5070679 1341  5070692 1343  5070718 1341  
333665 5070735 1343  5070759 1343  5070793 1343  5070818 1341  5070847 1341  5070879 1343  
333666 5070909 1341  5070936 1343  5070969 1343  5071004 1341  5071036 1343  5071071 1341  
333667 5071105 1341  5071129 1341  5071162 1341  5071194 1343  5071224 1341  5071248 1341  
333668 5071280 1343  5071304 1343  5071313 1343  5071337 1343  5071353 1341  5071361 1343  
333669 5071375 1343  5071385 1343  5071386 1341  5071396 1341  5071395 1343  5071386 1341  
333670 5071386 1341  5071372 1341  5071363 1341  5071348 1341  5071329 1341  5071308 1343  
333671 5071284 1343  5071261 1343  5071237 1343  5071208 1343  5071179 1343  5071148 1341  
333672 5071108 1343  5071079 1343  5071046 1343  5071008 1343  5070969 1343  5070936 1343  
333673 5070902 1343  5070860 1343  5070831 1343  5070793 1343  5070758 1345  5070721 1343  
333674 5070692 1343  5070659 1343  5070630 1343  5070603 1341  5070578 1343  5070554 1343  
333675 5070535 1343  5070521 1343  5070513 1341  5070501 1343  5070492 1343  5070487 1343  
333676 5070489 1341  5070487 1343  5070489 1341  5070493 1341  5070503 1341  5070517 1341  
333677 5070532 1341  5070556 1341  5070568 1343  5070594 1341  5070621 1343  5070645 1343  
333678 5070670 1341  5070704 1341  5070731 1343  5070761 1341  5070794 1341  5070831 1343  
333679 5070861 1341  5070895 1341  5070933 1341  5070960 1343  5070995 1341  5071028 1341  
333680 5071062 1341  5071095 1341  5071124 1341  5071148 1341  5071181 1341  5071194 1343  
333681 5071215 1341  5071229 1341  5071248 1342  5071262 1341  5071272 1341  5071281 1341  
333682 5071281 1341  5071286 1341  5071280 1343  5071280 1343  5071272 1341  5071262 1341  
333683 5071253 1341  5071238 1341  5071224 1341  5071210 1341  5071186 1341  5071162 1341  
333684 5071138 1341  5071114 1341  5071086 1341  5071059 1340  5071028 1341  5071004 1341  
333685 5070971 1341  5070947 1341  5070920 1340  5070885 1341  5070861 1341  5070832 1341  
333686 5070802 1343  5070780 1341  5070746 1341  5070732 1341  5070713 1341  5070694 1341  
333687 5070680 1341  5070661 1341  5070654 1343  5070646 1341  5070637 1341  5070632 1341  
333688 5070632 1341  5070632 1341  5070630 1343  5070637 1341  5070644 1343  5070654 1343  
333689 5070668 1343  5070688 1343  5070692 1343  5070718 1341  5070737 1341  5070761 1341  
333690 5070783 1343  5070820 1340  5070837 1341  5070861 1341  5070895 1341  5070923 1341  
333691 5070957 1341  5070985 1341  5071009 1341  5071039 1340  5071071 1341  5071105 1341  
333692 5071129 1341  5071161 1343  5071186 1341  5071210 1341  5071238 1341  5071261 1343  
333693 5071281 1341  5071296 1341  5071315 1341  5071324 1341  5071337 1343  5071347 1343  
333694 5071351 1343  5071353 1341  5071351 1343  5071351 1343  5071351 1343  5071347 1343  
333695 5071339 1341  5071325 1342  5071310 1341  5071288 1340  5071273 1340  5071249 1340  
333696 5071224 1341  5071196 1341  5071172 1341  5071140 1340  5071116 1340  5071081 1341  
333697 5071047 1341  5071011 1340  5070982 1340  5070947 1341  5070909 1341  5070882 1340  
333698 5070847 1341  5070818 1341  5070786 1340  5070758 1340  5070723 1341  5070705 1340  
333699 5070670 1341  5070646 1341  5070630 1343  5070613 1341  5070594 1341  5070589 1341  
333700 5070580 1341  5070560 1341  5070560 1342  5070556 1341  5070554 1343  5070556 1341  
333701 5070559 1343  5070568 1343  5070587 1343  5070591 1345  5070611 1343  5070632 1341  
333702 5070646 1341  5070661 1341  5070693 1343  5070718 1341  5070737 1341  5070761 1341  
333703 5070794 1341  5070823 1341  5070847 1341  5070885 1341  5070919 1341  5070946 1343  
333704 5070979 1343  5071009 1341  5071038 1341  5071060 1343  5071095 1341  5071122 1343  
333705 5071148 1341  5071172 1341  5071196 1341  5071213 1343  5071239 1341  5071251 1343  
333706 5071261 1343  5071270 1343  5071280 1343  5071285 1343  5071293 1345  5071294 1343  
333707 5071294 1343  5071286 1341  5071285 1343  5071272 1341  5071262 1341  5071248 1341  
333708 5071229 1341  5071215 1341  5071196 1341  5071181 1341  5071157 1341  5071125 1340  
333709 5071105 1341  5071081 1341  5071049 1340  5071025 1340  5070995 1341  5070961 1341  
333710 5070939 1340  5070909 1341  5070885 1341  5070856 1341  5070823 1341  5070805 1340  
333711 5070780 1341  5070756 1341  5070737 1341  5070718 1341  5070703 1341  5070689 1341  
333712 5070680 1341  5070670 1341  5070659 1343  5070661 1341  5070659 1343  5070661 1341  
333713 5070661 1341  5070661 1341  5070659 1343  5070678 1343  5070689 1342  5070704 1341  
333714 5070718 1341  5070731 1343  5070746 1341  5070770 1341  5070794 1341  5070818 1341  
333715 5070837 1341  5070871 1341  5070895 1341  5070919 1341  5070947 1341  5070982 1340  
333716 5071004 1341  5071028 1341  5071057 1341  5071087 1340  5071116 1340  5071138 1341  
333717 5071164 1340  5071188 1340  5071211 1340  5071229 1341  5071248 1341  5071262 1341  
333718 5071281 1341  5071296 1341  5071305 1341  5071310 1341  5071316 1340  5071315 1341  
333719 5071325 1341  5071325 1341  5071315 1341  5071310 1341  5071305 1341  5071297 1340  
333720 5071288 1340  5071273 1340  5071253 1341  5071231 1340  5071216 1340  5071195 1341  
333721 5071173 1340  5071138 1341  5071114 1341  5071095 1341  5071062 1341  5071030 1340  
333722 5071004 1341  5070980 1341  5070947 1341  5070919 1341  5070885 1341  5070861 1341  
333723 5070837 1341  5070818 1341  5070786 1340  5070761 1341  5070746 1341  5070734 1340  
333724 5070718 1341  5070694 1341  5070689 1341  5070679 1341  5070661 1341  5070661 1341  
333725 5070656 1341  5070656 1341  5070656 1341  5070656 1341  5070662 1340  5070672 1340  
333726 5070681 1340  5070695 1340  5070715 1340  5070724 1340  5070748 1340  5070762 1340  
333727 5070783 1338  5070807 1338  5070825 1340  5070848 1340  5070872 1340  5070906 1340  
333728 5070925 1340  5070948 1340  5070982 1340  5071006 1340  5071030 1340  5071065 1338  
333729 5071089 1338  5071116 1340  5071140 1340  5071164 1340  5071182 1340  5071205 1341  
333730 5071224 1341  5071240 1340  5071253 1341  5071273 1340  5071286 1341  5071296 1341  
333731 5071305 1341  5071312 1340  5071310 1341  5071310 1341  5071310 1341  5071307 1340  
333732 5071296 1341  5071286 1341  5071273 1340  5071262 1341  5071240 1340  5071226 1340  
333733 5071211 1340  5071188 1340  5071164 1340  5071140 1340  5071116 1340  5071087 1340  
333734 5071063 1340  5071030 1340  5071012 1338  5070982 1340  5070958 1340  5070926 1338  
333735 5070896 1340  5070872 1340  5070849 1340  5070825 1340  5070805 1340  5070782 1340  
333736 5070758 1340  5070737 1341  5070724 1340  5070715 1340  5070703 1341  5070695 1340  
333737 5070689 1341  5070681 1340  5070680 1341  5070672 1340  5070670 1341  5070679 1341  
333738 5070689 1341  5070695 1340  5070705 1340  5070719 1340  5070724 1340  5070737 1341  
333739 5070762 1340  5070780 1341  5070796 1340  5070818 1341  5070837 1341  5070858 1340  
333740 5070882 1340  5070906 1340  5070923 1341  5070947 1341  5070971 1341  5070995 1341  
333741 5071024 1341  5071049 1340  5071063 1340  5071086 1341  5071109 1341  5071129 1341  
333742 5071148 1341  5071173 1340  5071181 1341  5071196 1341  5071210 1341  5071224 1341  
333743 5071229 1341  5071230 1340  5071238 1341  5071239 1341  5071249 1340  5071249 1340  
333744 5071238 1341  5071230 1340  5071226 1340  5071216 1340  5071211 1340  5071197 1340  
333745 5071188 1340  5071175 1338  5071149 1340  5071130 1340  5071116 1340  5071097 1340  
333746 5071073 1340  5071049 1340  5071025 1340  5071006 1340  5070982 1340  5070957 1341  
333747 5070934 1340  5070906 1340  5070882 1340  5070863 1340  5070839 1340  5070820 1340  
333748 5070805 1340  5070782 1340  5070762 1340  5070748 1340  5070732 1341  5070723 1341  
333749 5070719 1340  5070713 1341  5070705 1340  5070703 1341  5070694 1341  5070694 1341  
333750 5070703 1341  5070703 1341  5070713 1341  5070718 1341  5070723 1341  5070738 1340  
333751 5070745 1343  5070761 1341  5070785 1341  5070804 1341  5070818 1341  5070837 1341  
333752 5070858 1340  5070871 1341  5070906 1340  5070919 1341  5070938 1341  5070961 1341  
333753 5070986 1341  5071011 1340  5071039 1340  5071063 1340  5071086 1341  5071106 1340  
333754 5071124 1341  5071149 1340  5071164 1340  5071183 1340  5071197 1340  5071214 1341  
333755 5071224 1341  5071238 1341  5071248 1341  5071254 1340  5071253 1341  5071254 1340  
333756 5071262 1341  5071264 1340  5071255 1340  5071253 1341  5071249 1340  5071240 1340  
333757 5071224 1341  5071214 1341  5071205 1341  5071181 1341  5071164 1340  5071149 1340  
333758 5071125 1340  5071106 1340  5071082 1340  5071059 1340  5071030 1340  5071011 1340  
333759 5070982 1340  5070958 1340  5070934 1340  5070910 1340  5070885 1341  5070858 1340  
333760 5070839 1340  5070820 1340  5070794 1341  5070782 1340  5070756 1341  5070738 1340  
333761 5070724 1340  5070720 1340  5070703 1341  5070694 1341  5070689 1341  5070691 1340  
333762 5070679 1341  5070680 1341  5070681 1340  5070681 1340  5070689 1341  5070696 1340  
333763 5070705 1340  5070718 1341  5070723 1341  5070734 1340  5070748 1340  5070762 1340  
333764 5070780 1341  5070794 1341  5070815 1340  5070823 1341  5070837 1341  5070863 1340  
333765 5070882 1340  5070895 1341  5070920 1340  5070934 1340  5070958 1340  5070971 1341  
333766 5070996 1340  5071011 1340  5071024 1341  5071047 1341  5071063 1340  5071081 1341  
333767 5071086 1341  5071106 1340  5071114 1341  5071124 1341  5071129 1341  5071138 1341  
333768 5071137 1343  5071148 1341  5071146 1343  5071157 1341  5071148 1342  5071146 1343  
333769 5071137 1343  5071138 1341  5071127 1343  5071124 1341  5071109 1341  5071105 1341  
333770 5071084 1343  5071071 1341  5071057 1341  5071038 1341  5071024 1341  5071009 1341  
333771 5070993 1343  5070980 1341  5070957 1341  5070938 1341  5070919 1341  5070902 1343  
333772 5070884 1343  5070861 1341  5070856 1341  5070832 1341  5070817 1343  5070804 1341  
333773 5070794 1341  5070780 1341  5070770 1341  5070761 1341  5070756 1341  5070756 1341  
333774 5070746 1341  5070746 1341  5070745 1343  5070745 1343  5070746 1341  5070746 1341  
333775 5070756 1341  5070759 1343  5070769 1343  5070778 1343  5070783 1343  5070802 1343  
333776 5070817 1343  5070831 1343  5070845 1343  5070860 1343  5070878 1343  5070893 1343  
333777 5070907 1343  5070931 1343  5070945 1343  5070971 1341  5070993 1343  5071008 1343  
333778 5071028 1341  5071046 1343  5071070 1343  5071084 1343  5071108 1343  5071122 1343  
333779 5071137 1343  5071156 1343  5071161 1343  5071179 1343  5071184 1343  5071205 1341  
333780 5071203 1343  5071208 1343  5071215 1341  5071215 1341  5071215 1341  5071214 1341  
333781 5071214 1341  5071210 1341  5071210 1341  5071205 1341  5071186 1341  5071181 1341  
333782 5071162 1341  5071148 1341  5071129 1341  5071116 1340  5071105 1341  5071082 1340  
333783 5071063 1340  5071039 1340  5071015 1340  5070996 1340  5070982 1340  5070958 1340  
333784 5070933 1341  5070909 1341  5070887 1340  5070863 1340  5070837 1341  5070824 1340  
333785 5070815 1340  5070786 1340  5070772 1340  5070758 1340  5070738 1340  5070724 1340  
333786 5070719 1340  5070715 1340  5070715 1340  5070705 1340  5070694 1341  5070696 1340  
333787 5070694 1341  5070695 1340  5070695 1340  5070695 1340  5070703 1341  5070713 1341  
333788 5070719 1340  5070723 1341  5070734 1340  5070737 1341  5070746 1341  5070761 1341  
333789 5070770 1341  5070785 1341  5070804 1341  5070820 1340  5070834 1340  5070847 1341  
333790 5070863 1340  5070880 1341  5070896 1340  5070909 1341  5070923 1341  5070937 1341  
333791 5070958 1340  5070971 1341  5070987 1340  5070996 1340  5071011 1340  5071015 1340  
333792 5071030 1340  5071039 1340  5071047 1341  5071059 1340  5071062 1341  5071062 1341  
333793 5071062 1341  5071071 1341  5071071 1341  5071071 1341  5071073 1340  5071063 1340  
333794 5071062 1341  5071058 1340  5071047 1341  5071038 1341  5071030 1340  5071024 1341  
333795 5071009 1341  5071006 1340  5070987 1340  5070980 1341  5070961 1341  5070957 1341  
333796 5070937 1341  5070923 1341  5070910 1340  5070895 1341  5070881 1340  5070872 1340  
333797 5070858 1340  5070837 1341  5070832 1341  5070823 1341  5070815 1340  5070802 1343  
333798 5070794 1341  5070794 1341  5070785 1341  5070786 1340  5070780 1341  5070780 1341  
333799 5070780 1341  5070780 1341  5070780 1341  5070785 1341  5070785 1341  5070794 1341  
333800 5070804 1341  5070813 1341  5070818 1341  5070823 1341  5070837 1341  5070848 1340  
333801 5070856 1341  5070871 1341  5070880 1341  5070895 1341  5070909 1341  5070923 1341  
333802 5070933 1341  5070947 1341  5070961 1341  5070980 1341  5070995 1341  5071009 1341  
333803 5071024 1341  5071039 1340  5071057 1341  5071062 1341  5071082 1340  5071095 1341  
333804 5071109 1341  5071114 1341  5071124 1341  5071129 1341  5071137 1343  5071148 1341  
333805 5071146 1343  5071156 1343  5071156 1343  5071156 1343  5071157 1341  5071156 1343  
333806 5071146 1343  5071148 1341  5071127 1343  5071122 1343  5071113 1343  5071108 1343  
333807 5071094 1343  5071079 1343  5071070 1343  5071046 1343  5071027 1343  5071014 1341  
333808 5071003 1343  5070984 1343  5070960 1343  5070945 1343  5070931 1343  5070907 1343  
333809 5070884 1343  5070869 1343  5070855 1343  5070832 1341  5070818 1341  5070801 1345  
333810 5070783 1343  5070769 1343  5070755 1343  5070746 1341  5070731 1343  5070721 1343  
333811 5070716 1343  5070711 1343  5070702 1343  5070704 1341  5070693 1343  5070693 1343  
333812 5070689 1341  5070688 1343  5070688 1343  5070692 1343  5070692 1343  5070692 1343  
333813 5070702 1343  5070711 1343  5070711 1343  5070716 1343  5070721 1343  5070732 1341  
333814 5070735 1343  5070756 1341  5070759 1343  5070778 1343  5070783 1343  5070802 1343  
333815 5070817 1343  5070831 1343  5070837 1341  5070845 1343  5070860 1343  5070869 1343  
333816 5070885 1341  5070904 1341  5070909 1341  5070922 1343  5070931 1343  5070936 1343  
333817 5070955 1343  5070957 1341  5070971 1341  5070969 1343  5070979 1343  5070980 1341  
333818 5070985 1341  5070995 1341  5070995 1341  5070995 1341  5070995 1341  5070995 1341  
333819 5070996 1340  5070996 1340  5070985 1341  5070985 1341  5070980 1341  5070972 1340  
333820 5070961 1341  5070957 1341  5070949 1340  5070938 1341  5070934 1340  5070923 1341  
333821 5070909 1341  5070906 1340  5070896 1340  5070885 1341  5070871 1341  5070863 1340  
333822 5070849 1340  5070839 1340  5070832 1341  5070823 1341  5070820 1340  5070815 1340  
333823 5070813 1341  5070813 1341  5070804 1341  5070805 1340  5070794 1341  5070796 1340  
333824 5070794 1341  5070796 1340  5070793 1343  5070802 1343  5070802 1343  5070812 1343  
333825 5070813 1341  5070818 1341  5070821 1343  5070832 1341  5070837 1341  5070855 1343  
333826 5070860 1343  5070871 1341  5070879 1343  5070895 1341  5070909 1341  5070918 1341  
333827 5070933 1341  5070947 1341  5070963 1340  5070980 1341  5070985 1341  5071004 1341  
333828 5071014 1341  5071028 1341  5071047 1341  5071057 1341  5071063 1340  5071079 1343  
333829 5071086 1341  5071097 1340  5071105 1341  5071108 1343  5071114 1341  5071124 1341  
333830 5071124 1341  5071124 1341  5071127 1343  5071129 1341  5071129 1341  5071124 1341  
333831 5071124 1341  5071113 1343  5071108 1343  5071103 1343  5071092 1345  5071081 1341  
333832 5071071 1341  5071060 1343  5071046 1343  5071027 1343  5071012 1343  5071003 1343  
333833 5070985 1341  5070969 1343  5070955 1343  5070937 1341  5070923 1341  5070909 1341  
333834 5070884 1343  5070871 1341  5070856 1341  5070837 1341  5070832 1341  5070818 1341  
333835 5070804 1341  5070785 1341  5070782 1340  5070761 1341  5070756 1341  5070746 1341  
333836 5070737 1341  5070734 1340  5070724 1340  5070718 1341  5070720 1340  5070715 1340  
333837 5070713 1341  5070704 1341  5070705 1340  5070705 1340  5070705 1340  5070715 1340  
333838 5070713 1341  5070715 1340  5070719 1340  5070719 1340  5070723 1341  5070734 1340  
333839 5070737 1341  5070746 1341  5070756 1341  5070772 1340  5070782 1340  5070785 1341  
333840 5070804 1341  5070818 1341  5070823 1341  5070832 1341  5070847 1341  5070861 1341  
333841 5070871 1341  5070884 1343  5070895 1341  5070907 1343  5070919 1341  5070923 1341  
333842 5070931 1343  5070937 1341  5070955 1343  5070955 1343  5070971 1341  5070969 1343  
333843 5070979 1343  5070984 1343  5070985 1341  5070995 1341  5070993 1343  5070995 1341  
333844 5070993 1343  5070993 1343  5070995 1341  5070995 1341  5070995 1341  5070985 1341  
333845 5070979 1343  5070979 1343  5070969 1343  5070969 1343  5070961 1341  5070957 1341  
333846 5070945 1343  5070936 1343  5070931 1343  5070933 1341  5070922 1343  5070917 1343  
333847 5070907 1343  5070903 1343  5070893 1343  5070893 1343  5070884 1343  5070879 1343  
333848 5070869 1343  5070869 1343  5070868 1345  5070861 1341  5070861 1341  5070860 1343  
333849 5070860 1343  5070860 1343  5070860 1343  5070860 1343  5070861 1341  5070869 1343  
333850 5070869 1343  5070879 1343  5070880 1341  5070885 1341  5070893 1343  5070902 1343  
333851 5070909 1341  5070922 1343  5070931 1343  5070937 1341  5070946 1343  5070961 1341  
333852 5070979 1343  5070984 1343  5071003 1343  5071008 1343  5071022 1343  5071027 1343  
333853 5071046 1343  5071057 1341  5071062 1341  5071071 1341  5071084 1343  5071094 1343  
333854 5071103 1343  5071108 1343  5071113 1343  5071122 1343  5071122 1343  5071122 1343  
333855 5071127 1343  5071129 1341  5071127 1343  5071127 1343  5071127 1343  5071129 1341  
333856 5071124 1341  5071124 1341  5071114 1341  5071109 1341  5071105 1341  5071097 1340  
333857 5071086 1341  5071081 1341  5071063 1340  5071047 1341  5071027 1343  5071024 1341  
333858 5071011 1340  5070995 1341  5070982 1340  5070957 1341  5070937 1341  5070923 1341  
333859 5070910 1340  5070896 1340  5070882 1340  5070861 1341  5070848 1340  5070832 1341  
333860 5070820 1340  5070804 1341  5070786 1340  5070780 1341  5070761 1341  5070746 1341  
333861 5070738 1340  5070732 1341  5070718 1341  5070715 1340  5070705 1340  5070694 1341  
333862 5070694 1341  5070689 1341  5070691 1340  5070679 1341  5070680 1341  5070679 1341  
333863 5070680 1341  5070679 1341  5070680 1341  5070679 1341  5070689 1341  5070691 1340  
333864 5070694 1341  5070703 1341  5070715 1340  5070720 1340  5070732 1341  5070737 1341  
333865 5070756 1341  5070761 1341  5070770 1341  5070783 1343  5070794 1341  5070813 1341  
333866 5070817 1343  5070831 1343  5070845 1343  5070855 1343  5070869 1343  5070880 1341  
333867 5070893 1343  5070904 1341  5070907 1343  5070923 1341  5070933 1341  5070937 1341  
333868 5070947 1341  5070949 1340  5070957 1341  5070963 1340  5070961 1341  5070972 1340  
333869 5070971 1341  5070982 1340  5070982 1340  5070980 1341  5070980 1341  5070972 1340  
333870 5070972 1340  5070961 1341  5070961 1341  5070958 1340  5070958 1340  5070947 1341  
333871 5070939 1340  5070933 1341  5070925 1340  5070920 1340  5070920 1340  5070906 1340  
333872 5070896 1340  5070887 1340  5070880 1341  5070871 1341  5070863 1340  5070858 1340  
333873 5070848 1340  5070850 1338  5070839 1340  5070839 1340  5070834 1340  5070824 1340  
333874 5070824 1340  5070826 1338  5070826 1338  5070821 1338  5070824 1340  5070824 1340  
333875 5070824 1340  5070834 1340  5070839 1340  5070839 1340  5070850 1338  5070859 1338  
333876 5070864 1338  5070882 1340  5070888 1338  5070907 1338  5070912 1338  5070920 1340  
333877 5070934 1340  5070939 1340  5070960 1338  5070963 1340  5070982 1340  5070985 1341  
333878 5071006 1340  5071011 1340  5071024 1341  5071030 1340  5071049 1340  5071057 1341  
333879 5071073 1340  5071082 1340  5071087 1340  5071097 1340  5071105 1341  5071105 1341  
333880 5071109 1341  5071114 1341  5071111 1340  5071114 1341  5071111 1340  5071109 1341  
333881 5071105 1341  5071105 1341  5071097 1340  5071086 1341  5071082 1340  5071073 1340  
333882 5071063 1340  5071047 1341  5071030 1340  5071025 1340  5071004 1341  5070995 1341  
333883 5070980 1341  5070957 1341  5070939 1340  5070923 1341  5070910 1340  5070885 1341  
333884 5070872 1340  5070856 1341  5070834 1340  5070818 1341  5070805 1340  5070782 1340  
333885 5070762 1340  5070737 1341  5070734 1340  5070715 1340  5070695 1340  5070681 1340  
333886 5070671 1340  5070656 1341  5070648 1340  5070633 1340  5070624 1340  5070618 1341  
333887 5070619 1340  5070614 1340  5070614 1340  5070603 1341  5070614 1340  5070614 1340  
333888 5070614 1340  5070618 1341  5070619 1340  5070622 1341  5070622 1341  5070633 1340  
333889 5070638 1340  5070646 1341  5070661 1341  5070679 1341  5070691 1340  5070696 1340  
333890 5070718 1341  5070723 1341  5070737 1341  5070756 1341  5070770 1341  5070785 1341  
333891 5070813 1341  5070818 1341  5070836 1343  5070855 1343  5070869 1343  5070887 1340  
333892 5070895 1341  5070909 1341  5070925 1340  5070933 1341  5070948 1340  5070958 1340  
333893 5070963 1340  5070982 1340  5070985 1341  5070996 1340  5070995 1341  5071004 1341  
333894 5071006 1340  5071011 1340  5071011 1340  5071006 1340  5071006 1340  5071004 1341  
333895 5070996 1340  5070987 1340  5070987 1340  5070982 1340  5070972 1340  5070963 1340  
333896 5070958 1340  5070948 1340  5070934 1340  5070925 1340  5070910 1340  5070906 1340  
333897 5070887 1340  5070882 1340  5070874 1338  5070864 1338  5070850 1338  5070839 1340  
333898 5070836 1338  5070825 1340  5070825 1340  5070820 1340  5070815 1340  5070815 1340  
333899 5070805 1340  5070805 1340  5070805 1340  5070805 1340  5070805 1340  5070805 1340  
333900 5070815 1340  5070820 1340  5070824 1340  5070823 1341  5070834 1340  5070839 1340  
333901 5070858 1340  5070863 1340  5070872 1340  5070885 1341  5070904 1341  5070909 1341  
333902 5070925 1340  5070933 1341  5070948 1340  5070961 1341  5070980 1341  5070997 1340  
333903 5071009 1341  5071012 1343  5071028 1341  5071047 1341  5071057 1341  5071071 1341  
333904 5071081 1341  5071095 1341  5071103 1343  5071108 1343  5071114 1341  5071114 1341  
333905 5071124 1341  5071130 1340  5071129 1341  5071129 1341  5071130 1340  5071125 1340  
333906 5071125 1340  5071116 1340  5071111 1340  5071108 1338  5071097 1340  5071082 1340  
333907 5071073 1340  5071059 1340  5071041 1338  5071027 1338  5071012 1338  5070998 1338  
333908 5070984 1338  5070960 1338  5070936 1338  5070910 1340  5070898 1338  5070874 1338  
333909 5070850 1338  5070826 1338  5070807 1338  5070783 1338  5070764 1338  5070740 1338  
333910 5070721 1338  5070708 1336  5070683 1338  5070664 1338  5070651 1336  5070627 1336  
333911 5070616 1338  5070608 1336  5070592 1338  5070582 1338  5070563 1338  5070559 1338  
333912 5070559 1338  5070549 1338  5070549 1338  5070549 1338  5070549 1338  5070549 1338  
333913 5070559 1338  5070559 1338  5070563 1338  5070583 1338  5070594 1336  5070598 1336  
333914 5070616 1338  5070626 1338  5070635 1338  5070659 1338  5070673 1338  5070691 1340  
333915 5070716 1338  5070726 1338  5070748 1340  5070773 1338  5070797 1338  5070817 1338  
333916 5070835 1338  5070858 1340  5070872 1340  5070887 1340  5070912 1338  5070926 1338  
333917 5070941 1338  5070958 1340  5070974 1338  5070987 1340  5070996 1340  5071012 1338  
333918 5071012 1338  5071025 1340  5071031 1338  5071041 1338  5071041 1338  5071050 1338  
333919 5071050 1338  5071049 1340  5071050 1338  5071042 1336  5071042 1336  5071031 1338  
333920 5071027 1338  5071017 1338  5071014 1336  5071000 1336  5070990 1336  5070975 1336  
333921 5070966 1336  5070950 1338  5070942 1336  5070926 1338  5070912 1338  5070899 1336  
333922 5070885 1336  5070874 1338  5070861 1336  5070840 1338  5070837 1336  5070826 1338  
333923 5070818 1336  5070808 1336  5070808 1336  5070799 1336  5070789 1336  5070783 1338  
333924 5070785 1336  5070785 1336  5070783 1338  5070783 1338  5070781 1340  5070788 1338  
333925 5070797 1338  5070808 1336  5070817 1338  5070821 1338  5070826 1338  5070840 1338  
333926 5070860 1338  5070864 1338  5070888 1338  5070896 1340  5070910 1340  5070925 1340  
333927 5070948 1340  5070963 1340  5070982 1340  5071006 1340  5071015 1340  5071028 1341  
333928 5071059 1340  5071073 1340  5071089 1338  5071105 1341  5071116 1340  5071130 1340  
333929 5071151 1338  5071159 1340  5071165 1338  5071175 1338  5071184 1338  5071188 1340  
333930 5071189 1338  5071199 1338  5071200 1336  5071191 1336  5071191 1336  5071186 1336  
333931 5071186 1336  5071170 1332  5071165 1332  5071155 1332  5071136 1332  5071122 1332  
333932 5071112 1332  5071089 1332  5071069 1332  5071045 1332  5071022 1332  5071003 1332  
333933 5070979 1332  5070955 1332  5070931 1332  5070902 1332  5070878 1332  5070845 1332  
333934 5070827 1330  5070792 1332  5070768 1332  5070744 1332  5070727 1330  5070702 1332  
333935 5070679 1330  5070655 1330  5070632 1330  5070620 1332  5070601 1332  5070577 1332  
333936 5070568 1332  5070555 1330  5070546 1330  5070530 1332  5070531 1330  5070526 1330  
333937 5070525 1332  5070520 1332  5070525 1332  5070525 1332  5070525 1332  5070530 1332  
333938 5070539 1332  5070544 1332  5070563 1332  5070577 1332  5070587 1332  5070611 1332  
333939 5070625 1332  5070639 1332  5070663 1332  5070687 1332  5070711 1332  5070730 1332  
333940 5070754 1332  5070778 1332  5070811 1332  5070826 1332  5070845 1332  5070878 1332  
333941 5070902 1332  5070923 1336  5070945 1332  5070969 1332  5070988 1332  5071003 1332  
333942 5071017 1332  5071031 1332  5071045 1332  5071065 1332  5071071 1330  5071079 1332  
333943 5071089 1332  5071095 1330  5071095 1330  5071104 1330  5071106 1328  5071104 1330  
333944 5071104 1330  5071096 1328  5071092 1328  5071090 1330  5071071 1330  5071066 1330  
333945 5071057 1330  5071038 1330  5071023 1330  5071015 1328  5070995 1330  5070980 1330  
333946 5070956 1330  5070943 1328  5070928 1330  5070915 1328  5070894 1330  5070872 1328  
333947 5070856 1330  5070842 1330  5070827 1330  5070823 1330  5070803 1330  5070789 1330  
333948 5070780 1330  5070770 1330  5070765 1330  5070756 1330  5070756 1330  5070746 1330  
333949 5070744 1332  5070746 1330  5070744 1332  5070754 1332  5070764 1332  5070770 1330  
333950 5070778 1332  5070794 1330  5070802 1332  5070821 1332  5070831 1332  5070846 1330  
333951 5070869 1332  5070894 1330  5070912 1332  5070931 1332  5070956 1330  5070980 1330  
333952 5070995 1330  5071017 1332  5071037 1330  5071065 1332  5071089 1332  5071114 1330  
333953 5071122 1332  5071147 1330  5071166 1330  5071179 1332  5071203 1332  5071217 1332  
333954 5071232 1332  5071237 1332  5071256 1332  5071262 1330  5071270 1332  5071272 1330  
333955 5071270 1332  5071281 1330  5071272 1330  5071272 1330  5071262 1330  5071259 1328  
333956 5071249 1328  5071235 1328  5071221 1328  5071205 1330  5071182 1328  5071159 1328  
333957 5071135 1328  5071119 1330  5071092 1328  5071068 1328  5071034 1328  5071005 1328  
333958 5070971 1330  5070948 1328  5070920 1328  5070880 1330  5070856 1330  5070829 1328  
333959 5070795 1328  5070767 1328  5070741 1330  5070713 1330  5070690 1328  5070666 1328  
333960 5070641 1330  5070622 1330  5070603 1330  5070579 1330  5070565 1330  5070546 1330  
333961 5070542 1328  5070530 1332  5070525 1332  5070522 1330  5070522 1330  5070510 1332  
333962 5070522 1330  5070522 1330  5070527 1330  5070531 1330  5070544 1332  5070554 1332  
333963 5070569 1330  5070589 1330  5070603 1330  5070625 1332  5070644 1332  5070668 1332  
333964 5070697 1332  5070726 1332  5070744 1332  5070768 1332  5070792 1332  5070826 1332  
333965 5070855 1332  5070878 1332  5070912 1332  5070940 1332  5070964 1332  5070988 1332  
333966 5071012 1332  5071031 1332  5071055 1332  5071079 1332  5071103 1332  5071117 1332  
333967 5071132 1332  5071136 1332  5071155 1332  5071165 1332  5071170 1332  5071176 1336  
333968 5071179 1332  5071179 1332  5071179 1332  5071179 1332  5071170 1332  5071167 1336  
333969 5071165 1332  5071146 1332  5071132 1332  5071122 1332  5071103 1332  5071089 1332  
333970 5071069 1332  5071045 1332  5071028 1336  5071009 1336  5070990 1336  5070969 1332  
333971 5070952 1336  5070928 1336  5070909 1336  5070885 1336  5070864 1338  5070840 1338  
333972 5070828 1336  5070817 1338  5070799 1336  5070786 1340  5070773 1338  5070764 1338  
333973 5070750 1338  5070738 1340  5070738 1340  5070734 1340  5070735 1338  5070735 1338  
333974 5070734 1340  5070740 1338  5070748 1340  5070758 1340  5070773 1338  5070788 1338  
333975 5070807 1338  5070821 1338  5070840 1338  5070860 1338  5070885 1336  5070907 1338  
333976 5070926 1338  5070952 1336  5070976 1336  5070998 1338  5071028 1336  5071050 1338  
333977 5071074 1338  5071109 1336  5071127 1338  5071151 1338  5071184 1338  5071210 1336  
333978 5071218 1338  5071243 1336  5071267 1336  5071284 1338  5071299 1338  5071313 1338  
333979 5071328 1338  5071332 1338  5071342 1338  5071351 1338  5071356 1338  5071356 1338  
333980 5071356 1338  5071351 1338  5071340 1340  5071331 1340  5071326 1340  5071312 1340  
333981 5071288 1340  5071272 1341  5071249 1340  5071224 1341  5071195 1341  5071172 1341  
333982 5071138 1341  5071111 1340  5071081 1341  5071049 1340  5071012 1338  5070982 1340  
333983 5070948 1340  5070912 1338  5070882 1340  5070848 1340  5070817 1338  5070783 1338  
333984 5070750 1338  5070719 1340  5070692 1338  5070664 1338  5070638 1340  5070621 1338  
333985 5070595 1340  5070573 1338  5070557 1340  5070538 1340  5070533 1340  5070519 1340  
333986 5070516 1338  5070514 1340  5070506 1338  5070503 1341  5070513 1341  5070519 1340  
333987 5070524 1340  5070536 1341  5070557 1340  5070562 1340  5070581 1340  5070605 1340  
333988 5070619 1340  5070640 1338  5070664 1338  5070696 1340  5070719 1340  5070750 1338  
333989 5070772 1340  5070807 1338  5070834 1340  5070863 1340  5070896 1340  5070925 1340  
333990 5070958 1340  5070987 1340  5071011 1340  5071039 1340  5071063 1340  5071087 1340  
333991 5071111 1340  5071130 1340  5071149 1340  5071164 1340  5071183 1340  5071197 1340  
333992 5071206 1340  5071211 1340  5071214 1341  5071216 1340  5071224 1341  5071216 1340  
333993 5071216 1340  5071210 1341  5071206 1340  5071188 1340  5071182 1340  5071164 1340  
333994 5071149 1340  5071130 1340  5071117 1338  5071087 1340  5071073 1340  5071038 1341  
333995 5071017 1338  5070996 1340  5070974 1338  5070941 1338  5070920 1340  5070888 1338  
333996 5070864 1338  5070840 1338  5070821 1338  5070797 1338  5070773 1338  5070759 1338  
333997 5070734 1340  5070721 1338  5070706 1338  5070692 1338  5070683 1338  5070672 1340  
333998 5070664 1338  5070662 1340  5070659 1338  5070657 1340  5070659 1338  5070664 1338  
333999 5070672 1340  5070683 1338  5070695 1340  5070719 1340  5070734 1340  5070746 1341  
334000 5070772 1340  5070796 1340  5070818 1341  5070839 1340  5070863 1340  5070896 1340  
334001 5070920 1340  5070949 1340  5070980 1341  5071011 1340  5071039 1340  5071063 1340  
334002 5071097 1340  5071126 1340  5071148 1341  5071182 1340  5071205 1341  5071226 1340  
334003 5071253 1341  5071273 1340  5071288 1340  5071310 1341  5071326 1340  5071329 1341  
334004 5071340 1340  5071350 1340  5071350 1340  5071350 1340  5071340 1340  5071340 1340  
334005 5071331 1340  5071328 1338  5071313 1338  5071299 1338  5071283 1340  5071256 1338  
334006 5071231 1340  5071208 1338  5071184 1338  5071149 1340  5071117 1338  5071089 1338  
334007 5071049 1340  5071015 1340  5070984 1338  5070948 1340  5070922 1338  5070883 1338  
334008 5070840 1338  5070815 1340  5070773 1338  5070740 1338  5070716 1338  5070683 1338  
334009 5070659 1338  5070624 1340  5070606 1338  5070571 1340  5070559 1338  5070535 1338  
334010 5070520 1338  5070504 1340  5070495 1340  5070492 1338  5070490 1340  5070481 1340  
334011 5070482 1338  5070482 1338  5070490 1340  5070495 1340  5070516 1338  5070524 1340  
334012 5070536 1341  5070563 1338  5070581 1340  5070605 1340  5070624 1340  5070657 1340  
334013 5070681 1340  5070715 1340  5070734 1340  5070762 1340  5070805 1340  5070834 1340  
334014 5070863 1340  5070896 1340  5070923 1341  5070958 1340  5070998 1338  5071025 1340  
334015 5071059 1340  5071087 1340  5071111 1340  5071130 1340  5071159 1340  5071188 1340  
334016 5071208 1338  5071216 1340  5071231 1340  5071240 1340  5071256 1338  5071256 1338  
334017 5071264 1340  5071275 1338  5071265 1338  5071265 1338  5071251 1338  5071242 1338  
334018 5071251 1338  5071218 1338  5071214 1336  5071199 1338  5071175 1338  5071151 1338  
334019 5071133 1336  5071112 1338  5071084 1338  5071062 1336  5071028 1336  5070999 1336  
334020 5070975 1336  5070942 1336  5070913 1336  5070890 1336  5070861 1336  5070837 1336  
334021 5070811 1332  5070785 1336  5070761 1336  5070741 1336  5070723 1336  5070699 1336  
334022 5070683 1338  5070665 1336  5070659 1338  5070651 1336  5070641 1336  5070640 1338  
334023 5070641 1336  5070640 1338  5070640 1338  5070649 1338  5070664 1338  5070673 1338  
334024 5070692 1338  5070706 1338  5070726 1338  5070748 1340  5070772 1340  5070796 1340  
334025 5070821 1338  5070839 1340  5070874 1338  5070905 1340  5070925 1340  5070958 1340  
334026 5070997 1340  5071027 1338  5071059 1340  5071089 1338  5071116 1340  5071151 1338  
334027 5071189 1338  5071213 1338  5071240 1340  5071265 1338  5071288 1340  5071311 1340  
334028 5071332 1338  5071351 1338  5071366 1338  5071380 1338  5071388 1340  5071399 1338  
334029 5071399 1338  5071401 1336  5071399 1338  5071390 1338  5071380 1338  5071367 1336  
334030 5071351 1338  5071332 1338  5071318 1338  5071299 1338  5071275 1338  5071241 1338  
334031 5071211 1340  5071184 1338  5071149 1340  5071111 1340  5071082 1340  5071041 1338  
334032 5071006 1340  5070963 1340  5070925 1340  5070887 1340  5070858 1340  5070825 1340  
334033 5070786 1340  5070759 1338  5070719 1340  5070691 1340  5070657 1340  5070622 1341  
334034 5070605 1340  5070581 1340  5070556 1341  5070536 1341  5070522 1341  5070514 1340  
334035 5070503 1341  5070492 1343  5070492 1343  5070489 1341  5070489 1341  5070489 1341  
334036 5070503 1341  5070513 1341  5070522 1341  5070536 1341  5070556 1341  5070570 1341  
334037 5070594 1341  5070618 1341  5070646 1341  5070670 1341  5070702 1343  5070732 1341  
334038 5070761 1341  5070794 1341  5070823 1341  5070856 1341  5070895 1341  5070923 1341  
334039 5070957 1341  5070986 1341  5071012 1343  5071047 1341  5071079 1343  5071105 1341  
334040 5071127 1343  5071161 1343  5071186 1341  5071205 1341  5071224 1341  5071238 1341  
334041 5071248 1341  5071253 1341  5071261 1343  5071272 1341  5071272 1341  5071272 1341  
334042 5071272 1341  5071262 1341  5071251 1343  5071248 1341  5071224 1341  5071213 1343  
334043 5071194 1343  5071179 1343  5071156 1343  5071127 1343  5071108 1343  5071079 1343  
334044 5071046 1343  5071022 1343  5070995 1341  5070971 1341  5070937 1341  5070907 1343  
334045 5070879 1343  5070845 1343  5070817 1343  5070793 1343  5070761 1341  5070731 1343  
334046 5070711 1343  5070692 1343  5070668 1343  5070644 1343  5070629 1345  5070615 1345  
334047 5070610 1345  5070591 1345  5070586 1345  5070586 1345  5070588 1343  5070587 1343  
334048 5070586 1345  5070591 1345  5070600 1345  5070613 1347  5070627 1347  5070653 1345  
334049 5070667 1345  5070689 1347  5070715 1345  5070734 1345  5070767 1345  5070791 1345  
334050 5070820 1345  5070853 1345  5070890 1347  5070922 1343  5070955 1343  5070992 1345  
334051 5071021 1345  5071054 1345  5071082 1345  5071121 1345  5071159 1345  5071192 1345  
334052 5071213 1343  5071245 1345  5071269 1345  5071293 1345  5071312 1345  5071326 1345  
334053 5071345 1345  5071360 1345  5071371 1343  5071375 1343  5071375 1343  5071374 1345  
334054 5071374 1345  5071374 1345  5071371 1343  5071351 1343  5071337 1343  5071323 1343  
334055 5071309 1343  5071284 1343  5071261 1343  5071237 1343  5071207 1345  5071179 1343  
334056 5071145 1345  5071111 1345  5071078 1345  5071046 1343  5071008 1343  5070979 1343  
334057 5070936 1343  5070907 1343  5070871 1341  5070837 1341  5070802 1343  5070770 1341  
334058 5070737 1341  5070713 1341  5070680 1341  5070656 1341  5070622 1341  5070605 1340  
334059 5070589 1341  5070570 1341  5070560 1341  5070546 1341  5070546 1341  5070536 1341  
334060 5070532 1341  5070536 1341  5070536 1341  5070536 1341  5070556 1341  5070570 1341  
334061 5070587 1343  5070603 1341  5070616 1343  5070637 1341  5070661 1341  5070689 1341  
334062 5070718 1341  5070735 1343  5070770 1341  5070804 1341  5070833 1341  5070861 1341  
334063 5070904 1341  5070933 1341  5070961 1341  5070993 1343  5071028 1341  5071062 1341  
334064 5071095 1341  5071124 1341  5071157 1341  5071179 1343  5071210 1341  5071229 1341  
334065 5071251 1343  5071270 1343  5071284 1343  5071304 1343  5071309 1343  5071315 1341  
334066 5071323 1343  5071323 1343  5071323 1343  5071324 1341  5071323 1343  5071315 1341  
334067 5071305 1341  5071296 1341  5071272 1341  5071253 1341  5071230 1340  5071210 1341  
334068 5071186 1341  5071162 1341  5071138 1341  5071109 1341  5071081 1341  5071047 1341  
334069 5071012 1343  5070985 1341  5070957 1341  5070923 1341  5070895 1341  5070857 1341  
334070 5070821 1343  5070793 1343  5070770 1341  5070737 1341  5070713 1341  5070688 1343  
334071 5070661 1341  5070637 1341  5070622 1341  5070613 1341  5070602 1343  5070594 1341  
334072 5070589 1341  5070578 1343  5070570 1341  5070580 1341  5070579 1341  5070589 1341  
334073 5070594 1341  5070613 1341  5070622 1341  5070637 1341  5070659 1343  5070678 1343  
334074 5070702 1343  5070731 1343  5070745 1343  5070778 1343  5070812 1343  5070836 1343  
334075 5070869 1343  5070907 1343  5070934 1345  5070977 1345  5071008 1343  5071035 1345  
334076 5071070 1343  5071108 1343  5071135 1345  5071169 1345  5071193 1345  5071213 1343  
334077 5071237 1343  5071259 1345  5071283 1345  5071302 1345  5071312 1345  5071326 1345  
334078 5071334 1347  5071345 1345  5071347 1343  5071350 1345  5071345 1345  5071345 1345  
334079 5071336 1345  5071321 1345  5071307 1345  5071302 1345  5071280 1343  5071259 1345  
334080 5071235 1345  5071213 1343  5071192 1345  5071158 1347  5071126 1345  5071102 1345  
334081 5071068 1345  5071033 1347  5071004 1347  5070977 1345  5070934 1345  5070906 1345  
334082 5070877 1345  5070834 1345  5070815 1345  5070782 1345  5070753 1345  5070720 1345  
334083 5070699 1347  5070676 1345  5070653 1345  5070632 1347  5070618 1347  5070610 1345  
334084 5070600 1345  5070586 1345  5070575 1347  5070576 1345  5070567 1345  5070567 1345  
334085 5070576 1345  5070584 1347  5070591 1345  5070610 1345  5070615 1345  5070632 1347  
334086 5070653 1345  5070677 1345  5070691 1345  5070713 1347  5070743 1345  5070767 1345  
334087 5070791 1345  5070820 1345  5070852 1347  5070882 1345  5070906 1345  5070934 1345  
334088 5070968 1345  5071001 1345  5071033 1347  5071067 1347  5071100 1347  5071119 1347  
334089 5071143 1347  5071177 1347  5071200 1347  5071220 1347  5071235 1345  5071248 1347  
334090 5071267 1347  5071281 1347  5071282 1347  5071291 1347  5071302 1345  5071301 1347  
334091 5071302 1351  5071301 1347  5071291 1347  5071281 1347  5071277 1347  5071258 1347  
334092 5071243 1347  5071224 1347  5071210 1347  5071191 1347  5071167 1347  5071134 1347  
334093 5071107 1351  5071082 1345  5071059 1345  5071019 1347  5071001 1345  5070966 1347  
334094 5070925 1351  5070901 1345  5070866 1347  5070833 1347  5070809 1347  5070775 1347  
334095 5070742 1347  5070718 1347  5070689 1347  5070666 1347  5070642 1347  5070619 1345  
334096 5070610 1345  5070591 1345  5070575 1347  5070567 1345  5070551 1347  5070543 1345  
334097 5070543 1345  5070543 1345  5070533 1345  5070543 1345  5070553 1345  5070559 1343  
334098 5070576 1345  5070592 1343  5070610 1345  5070619 1345  5070645 1343  5070668 1343  
334099 5070692 1343  5070715 1345  5070735 1343  5070769 1343  5070802 1343  5070831 1343  
334100 5070860 1343  5070893 1343  5070915 1345  5070945 1343  5070977 1345  5071008 1343  
334101 5071036 1343  5071070 1343  5071103 1343  5071122 1343  5071146 1343  5071170 1343  
334102 5071192 1345  5071208 1343  5071221 1345  5071237 1343  5071251 1343  5071261 1343  
334103 5071259 1345  5071269 1345  5071270 1343  5071270 1343  5071270 1343  5071259 1345  
334104 5071251 1343  5071237 1343  5071223 1343  5071208 1343  5071194 1343  5071179 1343  
334105 5071156 1343  5071127 1343  5071108 1343  5071084 1343  5071056 1343  5071022 1343  
334106 5071004 1341  5070969 1343  5070947 1341  5070917 1343  5070884 1343  5070860 1343  
334107 5070836 1343  5070812 1343  5070785 1341  5070759 1343  5070735 1343  5070717 1343  
334108 5070693 1343  5070678 1343  5070661 1341  5070656 1341  5070644 1343  5070635 1343  
334109 5070630 1343  5070630 1343  5070622 1341  5070630 1343  5070632 1341  5070635 1343  
334110 5070646 1341  5070659 1343  5070668 1343  5070689 1341  5070713 1341  5070723 1341  
334111 5070746 1341  5070770 1341  5070796 1340  5070818 1341  5070837 1341  5070861 1341  
334112 5070896 1340  5070919 1341  5070948 1340  5070982 1340  5071004 1341  5071028 1341  
334113 5071062 1341  5071097 1340  5071114 1341  5071138 1341  5071162 1341  5071186 1341  
334114 5071210 1341  5071224 1341  5071248 1341  5071262 1341  5071272 1341  5071285 1343  
334115 5071297 1340  5071305 1341  5071312 1340  5071309 1343  5071310 1341  5071310 1341  
334116 5071305 1341  5071294 1343  5071286 1341  5071272 1341  5071253 1341  5071238 1341  
334117 5071224 1341  5071205 1341  5071186 1341  5071162 1341  5071129 1341  5071109 1341  
334118 5071082 1340  5071047 1341  5071024 1341  5070996 1340  5070961 1341  5070933 1341  
334119 5070906 1340  5070872 1340  5070837 1341  5070813 1341  5070785 1341  5070758 1340  
334120 5070734 1340  5070703 1341  5070681 1340  5070661 1341  5070648 1340  5070624 1340  
334121 5070619 1340  5070603 1341  5070589 1341  5070579 1341  5070580 1341  5070570 1341  
334122 5070571 1340  5070570 1341  5070579 1341  5070589 1341  5070594 1341  5070603 1341  
334123 5070616 1343  5070632 1341  5070646 1341  5070670 1341  5070689 1341  5070715 1340  
334124 5070723 1341  5070746 1341  5070770 1341  5070796 1340  5070824 1340  5070847 1341  
334125 5070882 1340  5070906 1340  5070934 1340  5070958 1340  5070985 1341  5071009 1341  
334126 5071030 1340  5071063 1340  5071087 1340  5071109 1341  5071124 1341  5071138 1341  
334127 5071157 1341  5071171 1341  5071186 1341  5071195 1341  5071206 1340  5071206 1340  
334128 5071211 1340  5071216 1340  5071211 1340  5071211 1340  5071206 1340  5071197 1340  
334129 5071188 1340  5071182 1340  5071164 1340  5071149 1340  5071130 1340  5071117 1338  
334130 5071097 1340  5071082 1340  5071059 1340  5071030 1340  5071011 1340  5070987 1340  
334131 5070963 1340  5070937 1341  5070920 1340  5070906 1340  5070872 1340  5070858 1340  
334132 5070834 1340  5070805 1340  5070786 1340  5070772 1340  5070758 1340  5070738 1340  
334133 5070724 1340  5070719 1340  5070715 1340  5070705 1340  5070696 1340  5070696 1340  
334134 5070691 1340  5070696 1340  5070696 1340  5070696 1340  5070705 1340  5070720 1340  
334135 5070734 1340  5070739 1340  5070758 1340  5070762 1340  5070786 1340  5070805 1340  
334136 5070820 1340  5070839 1340  5070858 1340  5070880 1341  5070904 1341  5070923 1341  
334137 5070948 1340  5070972 1340  5070996 1340  5071017 1338  5071049 1340  5071073 1340  
334138 5071095 1341  5071116 1340  5071129 1341  5071157 1341  5071182 1340  5071195 1341  
334139 5071210 1341  5071224 1341  5071240 1340  5071254 1340  5071262 1341  5071272 1341  
334140 5071281 1341  5071281 1341  5071281 1341  5071281 1341  5071272 1341  5071272 1341  
334141 5071262 1341  5071249 1340  5071240 1340  5071224 1341  5071211 1340  5071197 1340  
334142 5071173 1340  5071149 1340  5071127 1338  5071108 1338  5071082 1340  5071059 1340  
334143 5071031 1338  5071007 1338  5070984 1338  5070950 1338  5070925 1340  5070898 1338  
334144 5070872 1340  5070840 1338  5070820 1340  5070788 1338  5070764 1338  5070740 1338  
334145 5070719 1340  5070695 1340  5070673 1338  5070657 1340  5070640 1338  5070624 1340  
334146 5070621 1338  5070614 1340  5070597 1338  5070595 1340  5070590 1340  5070581 1340  
334147 5070581 1340  5070589 1341  5070590 1340  5070595 1340  5070595 1340  5070605 1340  
334148 5070619 1340  5070624 1340  5070638 1340  5070656 1341  5070673 1338  5070691 1340  
334149 5070715 1340  5070724 1340  5070748 1340  5070770 1341  5070796 1340  5070818 1341  
334150 5070837 1341  5070858 1340  5070885 1341  5070910 1340  5070933 1341  5070958 1340  
334151 5070972 1340  5070996 1340  5071015 1340  5071030 1340  5071049 1340  5071063 1340  
334152 5071082 1340  5071097 1340  5071097 1340  5071111 1340  5071116 1340  5071116 1340  
334153 5071125 1340  5071125 1340  5071125 1340  5071125 1340  5071125 1340  5071116 1340  
334154 5071116 1340  5071105 1341  5071097 1340  5071087 1340  5071074 1338  5071063 1340  
334155 5071050 1338  5071025 1340  5071011 1340  5070998 1338  5070982 1340  5070958 1340  
334156 5070939 1340  5070925 1340  5070910 1340  5070898 1338  5070874 1338  5070859 1338  
334157 5070839 1340  5070835 1338  5070817 1338  5070805 1340  5070786 1340  5070782 1340  
334158 5070762 1340  5070762 1340  5070748 1340  5070750 1338  5070738 1340  5070738 1340  
334159 5070738 1340  5070738 1340  5070738 1340  5070748 1340  5070759 1338  5070761 1341  
334160 5070772 1340  5070782 1340  5070794 1341  5070815 1340  5070824 1340  5070837 1341  
334161 5070856 1341  5070872 1340  5070887 1340  5070910 1340  5070925 1340  5070948 1340  
334162 5070961 1341  5070985 1341  5071006 1340  5071024 1341  5071038 1341  5071063 1340  
334163 5071081 1341  5071106 1340  5071114 1341  5071130 1340  5071149 1340  5071162 1341  
334164 5071181 1341  5071186 1341  5071205 1341  5071211 1340  5071214 1341  5071215 1341  
334165 5071224 1341  5071224 1341  5071224 1342  5071224 1341  5071226 1340  5071214 1341  
334166 5071210 1341  5071207 1340  5071196 1341  5071181 1341  5071164 1340  5071149 1340  
334167 5071130 1340  5071111 1340  5071098 1338  5071074 1338  5071049 1340  5071025 1340  
334168 5071007 1338  5070984 1338  5070958 1340  5070934 1340  5070910 1340  5070882 1340  
334169 5070858 1340  5070834 1340  5070815 1340  5070786 1340  5070762 1340  5070738 1340  
334170 5070719 1340  5070705 1340  5070681 1340  5070662 1340  5070648 1340  5070633 1340  
334171 5070618 1341  5070614 1340  5070605 1340  5070590 1340  5070590 1340  5070581 1340  
334172 5070581 1340  5070581 1340  5070579 1341  5070581 1340  5070580 1341  5070589 1341  
334173 5070594 1341  5070603 1341  5070613 1341  5070619 1340  5070633 1340  5070646 1341  
334174 5070662 1340  5070680 1341  5070694 1341  5070718 1341  5070732 1341  5070748 1340  
334175 5070772 1340  5070794 1341  5070813 1341  5070823 1341  5070847 1341  5070871 1341  
334176 5070895 1341  5070907 1343  5070923 1341  5070937 1341  5070957 1341  5070971 1341  
334177 5070987 1340  5070995 1341  5071009 1341  5071014 1341  5071024 1341  5071028 1341  
334178 5071030 1340  5071038 1341  5071039 1340  5071038 1341  5071039 1340  5071039 1340  
334179 5071030 1340  5071030 1340  5071025 1340  5071015 1340  5071011 1340  5070998 1338  
334180 5070989 1338  5070982 1340  5070974 1338  5070960 1338  5070941 1338  5070936 1338  
334181 5070922 1338  5070909 1336  5070890 1336  5070878 1332  5070869 1332  5070852 1336  
334182 5070845 1332  5070831 1332  5070821 1332  5070811 1332  5070802 1332  5070792 1332  
334183 5070788 1332  5070778 1332  5070768 1332  5070768 1332  5070764 1332  5070764 1332  
334184 5070754 1332  5070754 1332  5070754 1332  5070754 1332  5070765 1330  5070770 1330  
334185 5070778 1332  5070789 1330  5070792 1332  5070811 1332  5070821 1332  5070831 1332  
334186 5070840 1332  5070855 1332  5070869 1332  5070888 1332  5070893 1332  5070912 1332  
334187 5070931 1332  5070940 1332  5070964 1332  5070979 1332  5070993 1332  5071017 1332  
334188 5071031 1332  5071045 1332  5071065 1332  5071079 1332  5071093 1332  5071112 1332  
334189 5071117 1332  5071122 1332  5071132 1332  5071136 1332  5071146 1332  5071155 1332  
334190 5071165 1332  5071165 1332  5071165 1332  5071165 1332  5071165 1332  5071165 1332  
334191 5071155 1332  5071146 1332  5071136 1332  5071132 1332  5071122 1332  5071112 1332  
334192 5071093 1332  5071079 1332  5071069 1332  5071057 1330  5071031 1332  5071017 1332  
334193 5070993 1332  5070969 1332  5070955 1332  5070926 1332  5070902 1332  5070888 1332  
334194 5070855 1332  5070840 1332  5070821 1332  5070792 1332  5070769 1332  5070744 1332  
334195 5070726 1332  5070702 1332  5070687 1332  5070663 1332  5070644 1332  5070630 1332  
334196 5070621 1332  5070601 1332  5070587 1332  5070577 1332  5070563 1332  5070554 1332  
334197 5070544 1332  5070544 1332  5070539 1332  5070530 1332  5070530 1332  5070530 1332  
334198 5070539 1332  5070539 1332  5070544 1332  5070563 1332  5070563 1332  5070577 1332  
334199 5070587 1332  5070601 1332  5070611 1332  5070625 1332  5070639 1332  5070654 1332  
334200 5070668 1332  5070697 1332  5070711 1332  5070726 1332  5070744 1332  5070768 1332  
334201 5070788 1332  5070811 1332  5070826 1332  5070845 1332  5070864 1332  5070878 1332  
334202 5070893 1332  5070912 1332  5070926 1332  5070931 1332  5070945 1332  5070955 1332  
334203 5070969 1332  5070979 1332  5070988 1332  5070993 1332  5071003 1332  5071003 1332  
334204 5071002 1332  5071003 1332  5071003 1332  5071003 1332  5071003 1332  5070993 1332  
334205 5070993 1332  5070988 1332  5070979 1332  5070969 1332  5070964 1332  5070955 1332  
334206 5070945 1332  5070931 1332  5070926 1332  5070917 1332  5070899 1336  5070890 1336  
334207 5070878 1332  5070869 1332  5070864 1332  5070842 1336  5070837 1336  5070828 1336  
334208 5070823 1336  5070817 1338  5070807 1338  5070797 1338  5070799 1336  5070788 1338  
334209 5070788 1338  5070783 1338  5070783 1338  5070783 1338  5070785 1336  5070783 1338  
334210 5070788 1338  5070789 1336  5070797 1338  5070808 1336  5070817 1338  5070821 1338  
334211 5070826 1338  5070840 1338  5070850 1338  5070864 1338  5070882 1340  5070890 1336  
334212 5070912 1338  5070926 1338  5070941 1338  5070960 1338  5070972 1340  5070996 1340  
334213 5071004 1341  5071024 1341  5071038 1341  5071057 1341  5071070 1343  5071086 1341  
334214 5071103 1343  5071113 1343  5071122 1343  5071126 1345  5071145 1345  5071153 1347  
334215 5071157 1347  5071169 1345  5071168 1345  5071178 1345  5071176 1347  5071178 1345  
334216 5071178 1345  5071176 1347  5071169 1345  5071161 1343  5071159 1345  5071154 1345  
334217 5071135 1345  5071121 1345  5071111 1345  5071102 1345  5071082 1345  5071059 1345  
334218 5071044 1345  5071019 1347  5071006 1345  5070981 1347  5070959 1345  5070934 1345  
334219 5070920 1345  5070901 1345  5070877 1345  5070855 1343  5070829 1345  5070812 1343  
334220 5070782 1345  5070755 1343  5070729 1345  5070716 1343  5070691 1345  5070667 1345  
334221 5070653 1345  5070630 1343  5070615 1345  5070600 1345  5070586 1345  5070576 1345  
334222 5070557 1345  5070553 1345  5070552 1345  5070543 1345  5070533 1345  5070532 1347  
334223 5070533 1345  5070533 1345  5070533 1345  5070532 1347  5070543 1345  5070551 1347  
334224 5070557 1345  5070567 1345  5070584 1347  5070589 1347  5070608 1347  5070627 1347  
334225 5070643 1345  5070666 1347  5070685 1347  5070710 1345  5070720 1345  5070743 1345  
334226 5070767 1345  5070791 1345  5070810 1345  5070829 1345  5070855 1343  5070869 1343  
334227 5070893 1343  5070917 1343  5070931 1343  5070945 1343  5070961 1341  5070979 1343  
334228 5070993 1343  5071009 1341  5071012 1343  5071028 1341  5071038 1341  5071049 1340  
334229 5071049 1340  5071059 1340  5071059 1340  5071060 1338  5071060 1338  5071062 1336  
334230 5071062 1336  5071050 1338  5071045 1332  5071036 1332  5071036 1332  5071019 1336  
334231 5071017 1332  5071012 1332  5070993 1332  5070979 1332  5070969 1332  5070955 1332  
334232 5070940 1332  5070931 1332  5070917 1332  5070902 1332  5070888 1332  5070878 1332  
334233 5070864 1332  5070852 1336  5070845 1332  5070828 1336  5070826 1332  5070823 1336  
334234 5070811 1332  5070808 1336  5070797 1338  5070799 1336  5070799 1336  5070799 1336  
334235 5070797 1338  5070797 1338  5070797 1338  5070807 1338  5070818 1336  5070821 1338  
334236 5070826 1338  5070836 1338  5070848 1340  5070863 1340  5070872 1340  5070887 1340  
334237 5070907 1338  5070920 1340  5070934 1340  5070949 1340  5070971 1341  5070987 1340  
334238 5071006 1340  5071024 1341  5071038 1341  5071057 1341  5071081 1341  5071097 1340  
334239 5071109 1341  5071130 1340  5071149 1340  5071164 1340  5071173 1340  5071196 1341  
334240 5071206 1340  5071210 1341  5071226 1340  5071226 1340  5071231 1340  5071240 1340  
334241 5071240 1340  5071240 1340  5071241 1338  5071232 1338  5071232 1338  5071227 1338  
334242 5071217 1338  5071213 1338  5071198 1338  5071184 1338  5071175 1338  5071160 1338  
334243 5071130 1340  5071116 1340  5071097 1340  5071073 1340  5071059 1340  5071031 1338  
334244 5071011 1340  5070987 1340  5070957 1341  5070925 1340  5070906 1340  5070872 1340  
334245 5070847 1341  5070820 1340  5070794 1341  5070761 1341  5070738 1340  5070718 1341  
334246 5070694 1341  5070672 1340  5070648 1340  5070632 1341  5070618 1341  5070595 1340  
334247 5070591 1340  5070571 1340  5070556 1341  5070548 1340  5070538 1340  5070538 1340  
334248 5070535 1338  5070533 1340  5070533 1340  5070539 1338  5070549 1338  5070559 1338  
334249 5070563 1338  5070571 1340  5070590 1340  5070606 1338  5070621 1338  5070640 1338  
334250 5070659 1338  5070683 1338  5070706 1338  5070724 1340  5070750 1338  5070773 1338  
334251 5070807 1338  5070826 1338  5070850 1338  5070882 1340  5070907 1338  5070926 1338  
334252 5070948 1340  5070974 1338  5070998 1338  5071017 1338  5071031 1338  5071052 1336  
334253 5071076 1336  5071089 1338  5071098 1338  5071112 1338  5071127 1338  5071132 1338  
334254 5071141 1338  5071141 1338  5071151 1338  5071152 1336  5071151 1338  5071151 1338  
334255 5071141 1338  5071133 1336  5071127 1338  5071117 1338  5071114 1336  5071100 1336  
334256 5071084 1338  5071076 1336  5071060 1338  5071041 1338  5071027 1338  5071012 1338  
334257 5070998 1338  5070975 1336  5070961 1336  5070941 1338  5070928 1336  5070912 1338  
334258 5070899 1336  5070885 1336  5070864 1338  5070850 1338  5070835 1338  5070821 1338  
334259 5070817 1338  5070807 1338  5070796 1340  5070786 1340  5070788 1338  5070788 1338  
334260 5070786 1340  5070788 1338  5070788 1338  5070796 1340  5070807 1338  5070807 1338  
334261 5070820 1340  5070836 1338  5070849 1340  5070863 1340  5070882 1340  5070896 1340  
334262 5070910 1340  5070925 1340  5070949 1340  5070961 1341  5070987 1340  5071011 1340  
334263 5071024 1342  5071047 1341  5071071 1341  5071095 1341  5071114 1341  5071138 1341  
334264 5071157 1341  5071180 1343  5071205 1341  5071213 1343  5071237 1343  5071251 1343  
334265 5071270 1343  5071285 1343  5071294 1343  5071304 1343  5071309 1343  5071313 1343  
334266 5071323 1343  5071323 1343  5071322 1345  5071323 1343  5071313 1343  5071312 1345  
334267 5071307 1345  5071302 1345  5071283 1345  5071269 1345  5071250 1345  5071224 1347  
334268 5071210 1347  5071191 1347  5071158 1347  5071135 1345  5071111 1345  5071081 1347  
334269 5071052 1347  5071009 1347  5070992 1345  5070952 1347  5070930 1345  5070892 1345  
334270 5070857 1347  5070828 1347  5070799 1347  5070766 1347  5070742 1347  5070713 1347  
334271 5070691 1345  5070656 1347  5070633 1345  5070613 1347  5070589 1347  5070575 1347  
334272 5070556 1347  5070541 1347  5070533 1345  5070527 1347  5070518 1347  5070518 1347  
334273 5070517 1347  5070515 1351  5070527 1347  5070527 1347  5070532 1347  5070551 1347  
334274 5070562 1351  5070572 1351  5070586 1351  5070604 1353  5070624 1351  5070648 1351  
334275 5070672 1351  5070705 1351  5070725 1351  5070753 1351  5070787 1351  5070810 1351  
334276 5070837 1353  5070873 1351  5070897 1351  5070925 1351  5070949 1351  5070977 1351  
334277 5071000 1353  5071030 1351  5071054 1351  5071078 1351  5071102 1351  5071116 1351  
334278 5071131 1351  5071155 1351  5071173 1351  5071178 1351  5071188 1351  5071197 1351  
334279 5071197 1351  5071205 1347  5071205 1347  5071205 1347  5071200 1347  5071191 1347  
334280 5071181 1347  5071178 1345  5071169 1345  5071153 1347  5071135 1345  5071121 1345  
334281 5071102 1345  5071081 1347  5071059 1345  5071044 1345  5071021 1345  5071001 1345  
334282 5070977 1345  5070954 1345  5070930 1345  5070906 1345  5070882 1345  5070860 1343  
334283 5070845 1343  5070820 1345  5070810 1345  5070793 1343  5070778 1343  5070758 1345  
334284 5070753 1345  5070734 1345  5070729 1345  5070731 1343  5070720 1345  5070720 1345  
334285 5070721 1343  5070720 1345  5070729 1345  5070734 1345  5070745 1343  5070753 1345  
334286 5070759 1343  5070777 1345  5070801 1345  5070815 1345  5070829 1345  5070855 1343  
334287 5070869 1343  5070893 1343  5070915 1345  5070934 1345  5070958 1345  5070984 1343  
334288 5071012 1343  5071035 1345  5071068 1345  5071094 1343  5071111 1345  5071146 1343  
334289 5071168 1345  5071184 1343  5071208 1343  5071227 1343  5071246 1343  5071269 1345  
334290 5071278 1345  5071294 1343  5071307 1345  5071313 1343  5071323 1343  5071328 1343  
334291 5071328 1343  5071328 1343  5071328 1343  5071328 1343  5071323 1343  5071313 1343  
334292 5071302 1345  5071284 1343  5071269 1345  5071249 1345  5071226 1345  5071205 1347  
334293 5071178 1345  5071154 1345  5071119 1347  5071091 1347  5071057 1347  5071019 1347  
334294 5070987 1351  5070957 1347  5070919 1347  5070887 1351  5070854 1351  5070825 1351  
334295 5070785 1353  5070753 1351  5070714 1353  5070694 1353  5070661 1353  5070626 1355  
334296 5070608 1353  5070583 1355  5070559 1355  5070535 1355  5070521 1355  5070506 1355  
334297 5070502 1355  5070483 1355  5070478 1355  5070468 1355  5070468 1355  5070468 1355  
334298 5070476 1356  5070483 1355  5070491 1356  5070502 1355  5070511 1355  5070526 1355  
334299 5070544 1355  5070569 1355  5070592 1355  5070607 1355  5070637 1353  5070659 1355  
334300 5070685 1353  5070713 1353  5070747 1353  5070775 1353  5070810 1351  5070842 1347  
334301 5070877 1351  5070914 1347  5070933 1347  5070966 1347  5071000 1347  5071024 1347  
334302 5071057 1347  5071078 1351  5071102 1351  5071121 1351  5071149 1351  5071167 1347  
334303 5071178 1351  5071197 1351  5071205 1347  5071207 1351  5071210 1347  5071207 1351  
334304 5071207 1351  5071207 1351  5071207 1351  5071202 1351  5071196 1353  5071177 1353  
334305 5071170 1355  5071151 1355  5071127 1355  5071103 1355  5071094 1355  5071070 1355  
334306 5071046 1355  5071018 1355  5070998 1355  5070974 1355  5070946 1355  5070922 1355  
334307 5070898 1355  5070869 1355  5070844 1356  5070820 1356  5070803 1355  5070772 1356  
334308 5070750 1355  5070734 1357  5070712 1355  5070702 1355  5070682 1356  5070677 1357  
334309 5070667 1356  5070658 1356  5070648 1356  5070648 1356  5070643 1356  5070643 1356  
334310 5070643 1356  5070648 1356  5070658 1356  5070667 1357  5070682 1356  5070701 1356  
334311 5070712 1355  5070725 1356  5070750 1355  5070774 1355  5070803 1355  5070822 1355  
334312 5070845 1355  5070869 1355  5070897 1356  5070927 1355  5070959 1356  5070984 1355  
334313 5071011 1356  5071046 1355  5071073 1357  5071097 1356  5071126 1356  5071161 1355  
334314 5071183 1357  5071202 1356  5071228 1355  5071251 1355  5071269 1357  5071283 1357  
334315 5071303 1357  5071314 1355  5071327 1356  5071336 1356  5071341 1357  5071341 1357  
334316 5071350 1356  5071341 1357  5071336 1357  5071327 1357  5071317 1357  5071303 1357  
334317 5071295 1355  5071269 1357  5071240 1356  5071217 1357  5071193 1356  5071170 1355  
334318 5071137 1355  5071102 1356  5071075 1355  5071046 1355  5071002 1356  5070970 1355  
334319 5070936 1355  5070898 1355  5070869 1355  5070827 1355  5070803 1355  5070760 1355  
334320 5070726 1355  5070693 1355  5070659 1355  5070636 1355  5070607 1355  5070583 1355  
334321 5070559 1355  5070535 1355  5070521 1355  5070506 1355  5070492 1355  5070483 1355  
334322 5070478 1355  5070468 1355  5070468 1355  5070468 1355  5070468 1355  5070478 1355  
334323 5070492 1355  5070502 1355  5070521 1355  5070535 1355  5070559 1355  5070578 1355  
334324 5070602 1355  5070621 1355  5070650 1355  5070677 1356  5070707 1355  5070736 1355  
334325 5070772 1356  5070807 1355  5070845 1355  5070874 1355  5070908 1355  5070944 1356  
334326 5070975 1355  5071003 1355  5071037 1355  5071070 1355  5071099 1355  5071118 1355  
334327 5071146 1355  5071170 1355  5071194 1355  5071204 1355  5071218 1355  5071228 1355  
334328 5071242 1355  5071251 1355  5071261 1355  5071261 1355  5071263 1353  5071251 1355  
334329 5071251 1355  5071242 1355  5071228 1355  5071213 1355  5071199 1355  5071185 1355  
334330 5071161 1355  5071137 1355  5071113 1355  5071094 1355  5071061 1355  5071037 1355  
334331 5071003 1355  5070975 1355  5070946 1355  5070922 1355  5070893 1355  5070860 1355  
334332 5070825 1356  5070806 1356  5070772 1356  5070749 1356  5070725 1356  5070705 1356  
334333 5070682 1356  5070667 1357  5070647 1358  5070634 1356  5070620 1356  5070610 1356  
334334 5070605 1356  5070600 1356  5070600 1356  5070600 1356  5070605 1356  5070605 1356  
334335 5070610 1356  5070625 1357  5070643 1357  5070658 1356  5070677 1356  5070701 1356  
334336 5070720 1356  5070744 1356  5070768 1356  5070792 1356  5070820 1356  5070849 1356  
334337 5070882 1356  5070906 1357  5070944 1356  5070971 1358  5071002 1356  5071035 1356  
334338 5071069 1356  5071097 1356  5071126 1357  5071159 1357  5071193 1356  5071212 1356  
334339 5071236 1356  5071260 1356  5071283 1356  5071303 1357  5071317 1356  5071327 1356  
334340 5071341 1356  5071350 1356  5071360 1356  5071358 1358  5071363 1358  5071357 1360  
334341 5071357 1360  5071347 1360  5071330 1364  5071320 1364  5071306 1364  5071287 1364  
334342 5071262 1366  5071233 1366  5071209 1366  5071187 1364  5071153 1364  5071120 1364  
334343 5071091 1364  5071053 1364  5071020 1364  5070991 1364  5070953 1364  5070914 1364  
334344 5070886 1364  5070843 1364  5070812 1366  5070776 1364  5070742 1364  5070714 1364  
334345 5070675 1364  5070652 1364  5070628 1364  5070602 1366  5070584 1366  5070561 1364  
334346 5070542 1364  5070528 1364  5070512 1366  5070502 1366  5070499 1364  5070497 1366  
334347 5070493 1366  5070497 1366  5070504 1364  5070512 1366  5070517 1366  5070535 1366  
334348 5070551 1364  5070569 1366  5070593 1366  5070612 1366  5070636 1366  5070660 1366  
334349 5070692 1368  5070716 1368  5070749 1368  5070784 1366  5070812 1366  5070840 1368  
334350 5070883 1368  5070913 1366  5070951 1366  5070983 1368  5071007 1368  5071042 1366  
334351 5071075 1366  5071109 1366  5071137 1366  5071165 1368  5071190 1366  5071206 1364  
334352 5071230 1364  5071254 1364  5071262 1366  5071276 1366  5071276 1366  5071285 1366  
334353 5071292 1364  5071290 1366  5071290 1366  5071285 1366  5071268 1364  5071263 1364  
334354 5071254 1364  5071228 1366  5071211 1364  5071192 1364  5071166 1366  5071144 1364  
334355 5071109 1366  5071090 1366  5071063 1364  5071028 1366  5070994 1366  5070965 1366  
334356 5070937 1366  5070903 1366  5070876 1364  5070841 1366  5070819 1364  5070794 1366  
334357 5070760 1366  5070727 1366  5070703 1366  5070685 1364  5070658 1368  5070639 1368  
334358 5070617 1366  5070601 1368  5070596 1368  5070591 1368  5070583 1366  5070572 1368  
334359 5070572 1368  5070572 1368  5070580 1370  5070582 1368  5070596 1368  5070599 1370  
334360 5070615 1368  5070633 1370  5070658 1368  5070672 1368  5070696 1368  5070724 1370  
334361 5070749 1368  5070773 1368  5070801 1368  5070827 1366  5070864 1368  5070897 1368  
334362 5070926 1368  5070959 1368  5070988 1368  5071016 1368  5071059 1368  5071088 1368  
334363 5071116 1368  5071152 1366  5071183 1368  5071204 1366  5071231 1368  5071250 1368  
334364 5071274 1368  5071294 1368  5071308 1368  5071317 1368  5071332 1368  5071332 1368  
334365 5071343 1366  5071343 1366  5071341 1368  5071341 1368  5071332 1368  5071327 1368  
334366 5071317 1368  5071303 1368  5071289 1368  5071274 1368  5071250 1368  5071225 1370  
334367 5071203 1368  5071175 1366  5071151 1366  5071117 1368  5071083 1368  5071048 1370  
334368 5071007 1368  5070986 1370  5070950 1368  5070914 1370  5070886 1370  5070848 1370  
334369 5070813 1372  5070789 1372  5070755 1372  5070722 1372  5070697 1373  5070668 1373  
334370 5070645 1372  5070620 1373  5070596 1373  5070588 1372  5070568 1373  5070563 1373  
334371 5070542 1375  5070534 1373  5070533 1375  5070533 1375  5070533 1375  5070533 1375  
334372 5070552 1375  5070563 1373  5070572 1379  5070587 1379  5070601 1379  5070628 1375  
334373 5070652 1375  5070673 1379  5070692 1379  5070716 1379  5070749 1379  5070783 1379  
334374 5070807 1379  5070840 1379  5070881 1375  5070907 1379  5070943 1375  5070974 1379  
334375 5071007 1379  5071044 1375  5071074 1379  5071098 1379  5071131 1379  5071155 1379  
334376 5071179 1379  5071208 1379  5071222 1379  5071254 1375  5071268 1375  5071279 1379  
334377 5071284 1379  5071294 1379  5071299 1379  5071299 1379  5071299 1379  5071297 1381  
334378 5071294 1379  5071282 1381  5071278 1381  5071264 1381  5071251 1379  5071232 1379  
334379 5071206 1381  5071182 1381  5071163 1381  5071139 1381  5071106 1381  5071076 1383  
334380 5071048 1381  5071015 1381  5070990 1383  5070963 1381  5070924 1381  5070890 1383  
334381 5070862 1381  5070829 1381  5070800 1381  5070772 1381  5070748 1381  5070714 1381  
334382 5070691 1381  5070671 1381  5070648 1381  5070622 1383  5070603 1383  5070590 1381  
334383 5070579 1383  5070569 1383  5070560 1383  5070559 1385  5070558 1385  5070560 1383  
334384 5070559 1385  5070577 1385  5070582 1385  5070595 1387  5070601 1385  5070621 1385  
334385 5070644 1385  5070657 1387  5070686 1387  5070702 1385  5070724 1387  5070759 1385  
334386 5070783 1385  5070810 1387  5070845 1385  5070872 1387  5070901 1387  5070933 1388  
334387 5070968 1387  5071001 1387  5071033 1388  5071068 1387  5071086 1388  5071119 1388  
334388 5071147 1388  5071172 1388  5071191 1388  5071213 1390  5071234 1388  5071256 1390  
334389 5071270 1390  5071275 1390  5071285 1390  5071288 1392  5071297 1392  5071297 1392  
334390 5071299 1390  5071288 1392  5071288 1392  5071283 1392  5071269 1392  5071256 1390  
334391 5071241 1390  5071223 1390  5071199 1390  5071176 1388  5071157 1388  5071125 1387  
334392 5071100 1388  5071071 1388  5071044 1387  5071012 1385  5070977 1387  5070950 1385  
334393 5070920 1387  5070887 1387  5070858 1387  5070836 1385  5070802 1385  5070778 1385  
334394 5070745 1385  5070721 1385  5070689 1383  5070668 1385  5070644 1385  5070625 1385  
334395 5070611 1385  5070597 1385  5070587 1385  5070583 1385  5070577 1385  5070577 1385  
334396 5070568 1385  5070568 1385  5070577 1385  5070577 1385  5070587 1385  5070603 1383  
334397 5070611 1385  5070636 1383  5070656 1383  5070670 1383  5070689 1383  5070715 1381  
334398 5070737 1383  5070762 1381  5070791 1381  5070821 1385  5070848 1381  5070875 1383  
334399 5070905 1381  5070947 1383  5070975 1383  5070995 1383  5071028 1383  5071062 1383  
334400 5071092 1381  5071114 1383  5071147 1383  5071176 1383  5071195 1383  5071214 1383  
334401 5071229 1383  5071252 1383  5071264 1381  5071276 1383  5071281 1383  5071281 1383  
334402 5071292 1381  5071291 1383  5071292 1381  5071283 1381  5071273 1381  5071264 1381  
334403 5071249 1381  5071240 1381  5071216 1381  5071192 1381  5071178 1381  5071154 1381  
334404 5071128 1383  5071096 1381  5071077 1381  5071048 1381  5071015 1381  5070982 1381  
334405 5070953 1381  5070925 1381  5070891 1381  5070863 1381  5070829 1381  5070800 1381  
334406 5070781 1381  5070748 1381  5070724 1381  5070691 1381  5070671 1381  5070648 1381  
334407 5070624 1381  5070605 1381  5070590 1381  5070585 1381  5070579 1383  5070569 1383  
334408 5070562 1381  5070560 1383  5070561 1381  5070561 1381  5070562 1381  5070571 1381  
334409 5070585 1381  5070590 1381  5070604 1381  5070624 1381  5070648 1381  5070662 1381  
334410 5070681 1381  5070700 1381  5070724 1381  5070754 1379  5070781 1381  5070805 1381  
334411 5070829 1381  5070862 1381  5070891 1381  5070925 1381  5070948 1381  5070977 1381  
334412 5071006 1381  5071039 1381  5071063 1381  5071092 1381  5071115 1381  5071139 1381  
334413 5071154 1381  5071178 1381  5071192 1381  5071206 1381  5071221 1381  5071240 1381  
334414 5071249 1381  5071249 1381  5071254 1381  5071254 1381  5071254 1381  5071254 1381  
334415 5071249 1381  5071240 1381  5071221 1381  5071216 1381  5071197 1381  5071182 1381  
334416 5071163 1381  5071149 1381  5071125 1381  5071097 1381  5071077 1381  5071049 1381  
334417 5071025 1381  5070996 1381  5070972 1381  5070948 1381  5070925 1381  5070891 1381  
334418 5070870 1383  5070848 1381  5070813 1383  5070791 1381  5070772 1381  5070753 1381  
334419 5070729 1381  5070713 1383  5070698 1383  5070686 1381  5070670 1383  5070660 1383  
334420 5070656 1383  5070646 1383  5070646 1383  5070646 1383  5070646 1383  5070646 1383  
334421 5070656 1383  5070660 1383  5070670 1383  5070684 1383  5070698 1383  5070713 1383  
334422 5070727 1383  5070751 1383  5070769 1385  5070788 1385  5070813 1383  5070846 1383  
334423 5070869 1385  5070888 1385  5070912 1385  5070945 1385  5070969 1385  5070992 1387  
334424 5071027 1385  5071060 1385  5071079 1385  5071103 1385  5071127 1385  5071160 1385  
334425 5071175 1385  5071195 1383  5071217 1385  5071237 1385  5071251 1385  5071270 1385  
334426 5071275 1385  5071280 1385  5071280 1385  5071289 1385  5071288 1387  5071289 1385  
334427 5071278 1387  5071273 1387  5071269 1387  5071248 1388  5071243 1388  5071224 1388  
334428 5071200 1388  5071186 1388  5071165 1390  5071143 1388  5071109 1388  5071084 1390  
334429 5071066 1388  5071031 1390  5071009 1388  5070976 1388  5070947 1388  5070917 1390  
334430 5070883 1390  5070856 1388  5070823 1388  5070799 1388  5070775 1388  5070742 1388  
334431 5070718 1388  5070694 1388  5070673 1390  5070651 1388  5070632 1388  5070618 1388  
334432 5070606 1390  5070592 1390  5070584 1388  5070578 1390  5070573 1390  5070573 1390  
334433 5070573 1390  5070573 1390  5070573 1390  5070583 1390  5070592 1390  5070595 1392  
334434 5070616 1390  5070630 1390  5070650 1390  5070664 1390  5070683 1390  5070697 1390  
334435 5070721 1390  5070745 1390  5070774 1390  5070793 1390  5070820 1392  5070845 1390  
334436 5070867 1392  5070898 1390  5070920 1392  5070945 1390  5070974 1390  5070997 1392  
334437 5071021 1392  5071044 1392  5071070 1390  5071082 1392  5071098 1390  5071117 1390  
334438 5071140 1392  5071146 1390  5071165 1390  5071168 1392  5071173 1392  5071175 1390  
334439 5071183 1392  5071183 1392  5071175 1390  5071173 1392  5071168 1392  5071164 1392  
334440 5071154 1392  5071145 1392  5071132 1390  5071116 1392  5071098 1390  5071074 1390  
334441 5071065 1390  5071041 1390  5071022 1390  5070998 1390  5070985 1388  5070957 1388  
334442 5070941 1390  5070919 1389  5070893 1390  5070871 1388  5070847 1388  5070821 1390  
334443 5070807 1390  5070783 1390  5070773 1390  5070754 1390  5070738 1392  5070720 1392  
334444 5070707 1390  5070692 1390  5070683 1390  5070678 1390  5070678 1390  5070679 1388  
334445 5070679 1388  5070679 1388  5070679 1388  5070678 1390  5070683 1390  5070694 1388  
334446 5070707 1390  5070721 1390  5070731 1390  5070745 1390  5070764 1390  5070778 1390  
334447 5070797 1390  5070815 1392  5070840 1390  5070864 1390  5070884 1390  5070898 1390  
334448 5070931 1390  5070957 1388  5070974 1390  5070998 1390  5071024 1389  5071046 1390  
334449 5071071 1388  5071089 1390  5071108 1390  5071130 1392  5071146 1390  5071164 1392  
334450 5071175 1390  5071188 1392  5071199 1390  5071208 1390  5071214 1388  5071223 1390  
334451 5071223 1390  5071224 1388  5071224 1388  5071226 1387  5071216 1387  5071210 1388  
334452 5071202 1387  5071188 1387  5071171 1388  5071157 1388  5071143 1388  5071124 1388  
334453 5071100 1388  5071086 1388  5071065 1390  5071033 1388  5071009 1388  5070984 1390  
334454 5070955 1390  5070931 1390  5070898 1390  5070880 1388  5070855 1390  5070823 1388  
334455 5070798 1390  5070778 1390  5070755 1390  5070731 1390  5070707 1390  5070692 1390  
334456 5070673 1390  5070654 1390  5070640 1390  5070622 1389  5070616 1390  5070608 1388  
334457 5070597 1390  5070594 1388  5070583 1390  5070586 1387  5070584 1388  5070586 1387  
334458 5070595 1387  5070600 1387  5070609 1387  5070622 1388  5070632 1388  5070653 1387  
334459 5070667 1387  5070679 1388  5070694 1388  5070708 1389  5070732 1388  5070755 1390  
334460 5070778 1390  5070797 1390  5070820 1392  5070845 1390  5070868 1392  5070892 1392  
334461 5070906 1392  5070931 1390  5070954 1392  5070973 1392  5070987 1392  5071007 1390  
334462 5071030 1392  5071044 1392  5071063 1392  5071074 1390  5071082 1392  5071097 1392  
334463 5071106 1392  5071116 1392  5071121 1392  5071122 1390  5071121 1392  5071121 1392  
334464 5071121 1392  5071121 1392  5071121 1392  5071116 1392  5071106 1392  5071087 1392  
334465 5071082 1392  5071068 1392  5071054 1392  5071044 1392  5071030 1392  5071015 1392  
334466 5070997 1392  5070973 1392  5070966 1394  5070945 1390  5070930 1392  5070915 1392  
334467 5070898 1390  5070877 1392  5070863 1392  5070840 1390  5070828 1394  5070815 1392  
334468 5070794 1394  5070782 1392  5070770 1394  5070761 1394  5070751 1394  5070752 1394  
334469 5070742 1394  5070742 1394  5070737 1394  5070742 1394  5070737 1394  5070737 1394  
334470 5070742 1394  5070750 1396  5070761 1394  5070769 1396  5070775 1394  5070790 1394  
334471 5070794 1394  5070813 1394  5070826 1396  5070841 1396  5070860 1396  5070874 1396  
334472 5070888 1396  5070912 1396  5070927 1396  5070941 1396  5070963 1398  5070979 1396  
334473 5071003 1396  5071025 1398  5071041 1396  5071067 1394  5071084 1396  5071103 1396  
334474 5071116 1398  5071137 1396  5071151 1396  5071165 1396  5071172 1394  5071184 1396  
334475 5071193 1398  5071204 1396  5071210 1394  5071208 1396  5071208 1396  5071208 1396  
334476 5071207 1398  5071208 1396  5071204 1396  5071194 1396  5071184 1396  5071180 1396  
334477 5071165 1396  5071161 1396  5071137 1396  5071117 1396  5071103 1396  5071081 1394  
334478 5071065 1396  5071041 1396  5071018 1396  5070992 1398  5070970 1396  5070951 1396  
334479 5070927 1396  5070903 1396  5070879 1396  5070858 1398  5070836 1396  5070812 1396  
334480 5070793 1396  5070777 1398  5070760 1396  5070739 1398  5070724 1398  5070712 1396  
334481 5070691 1398  5070686 1398  5070673 1396  5070672 1398  5070667 1398  5070658 1398  
334482 5070648 1398  5070648 1398  5070650 1396  5070648 1398  5070656 1400  5070658 1398  
334483 5070667 1398  5070672 1398  5070677 1398  5070686 1398  5070702 1396  5070710 1398  
334484 5070726 1396  5070735 1396  5070750 1396  5070767 1398  5070778 1396  5070791 1398  
334485 5070812 1396  5070826 1396  5070841 1396  5070858 1398  5070877 1398  5070893 1396  
334486 5070911 1398  5070925 1398  5070939 1398  5070959 1398  5070968 1398  5070982 1398  
334487 5070990 1400  5071013 1396  5071016 1398  5071035 1398  5071040 1398  5071049 1398  
334488 5071049 1398  5071059 1398  5071057 1400  5071059 1398  5071065 1396  5071060 1396  
334489 5071060 1396  5071049 1398  5071049 1398  5071041 1396  5071036 1396  5071027 1396  
334490 5071017 1396  5071003 1396  5070995 1394  5070984 1396  5070969 1396  5070960 1396  
334491 5070941 1396  5070936 1396  5070917 1396  5070904 1394  5070895 1394  5070879 1396  
334492 5070875 1394  5070860 1396  5070850 1396  5070836 1396  5070818 1394  5070813 1394  
334493 5070804 1394  5070795 1394  5070795 1394  5070790 1394  5070780 1394  5070778 1396  
334494 5070775 1394  5070774 1396  5070778 1396  5070778 1396  5070780 1394  5070790 1394  
334495 5070790 1394  5070793 1396  5070802 1396  5070813 1394  5070818 1394  5070829 1392  
334496 5070842 1394  5070852 1394  5070868 1392  5070884 1390  5070892 1392  5070915 1392  
334497 5070920 1392  5070941 1390  5070954 1392  5070968 1392  5070987 1392  5071008 1390  
334498 5071021 1392  5071039 1392  5071054 1392  5071068 1392  5071082 1392  5071097 1392  
334499 5071106 1392  5071121 1392  5071130 1392  5071130 1392  5071143 1394  5071145 1392  
334500 5071154 1392  5071164 1392  5071164 1392  5071168 1392  5071164 1392  5071164 1392  
334501 5071154 1392  5071145 1392  5071145 1392  5071130 1392  5071119 1394  5071106 1392  
334502 5071097 1392  5071073 1392  5071068 1392  5071054 1392  5071030 1392  5071015 1392  
334503 5070995 1394  5070973 1392  5070962 1394  5070942 1394  5070920 1392  5070904 1394  
334504 5070892 1392  5070868 1392  5070852 1394  5070837 1394  5070819 1394  5070794 1394  
334505 5070780 1394  5070771 1394  5070752 1394  5070742 1394  5070726 1396  5070717 1396  
334506 5070702 1396  5070693 1396  5070688 1396  5070678 1396  5070677 1398  5070672 1398  
334507 5070672 1398  5070672 1398  5070672 1398  5070672 1398  5070670 1400  5070674 1402  
334508 5070683 1402  5070688 1402  5070688 1402  5070698 1402  5070708 1400  5070714 1400  
334509 5070722 1402  5070733 1400  5070747 1400  5070757 1400  5070771 1400  5070785 1400  
334510 5070801 1398  5070809 1400  5070823 1400  5070838 1400  5070857 1400  5070872 1398  
334511 5070887 1398  5070893 1396  5070911 1398  5070925 1398  5070936 1396  5070939 1398  
334512 5070959 1398  5070963 1398  5070977 1398  5070979 1396  5070984 1396  5070992 1398  
334513 5070994 1396  5071003 1396  5071002 1398  5071003 1396  5071005 1394  5070994 1396  
334514 5071005 1394  5071003 1396  5070995 1394  5070986 1394  5070986 1394  5070982 1392  
334515 5070981 1394  5070971 1394  5070968 1392  5070952 1394  5070944 1392  5070941 1390  
334516 5070922 1390  5070915 1392  5070906 1392  5070896 1392  5070893 1390  5070884 1390  
334517 5070879 1390  5070869 1390  5070864 1390  5070855 1390  5070845 1390  5070845 1390  
334518 5070839 1392  5070831 1390  5070829 1392  5070829 1392  5070822 1390  5070823 1388  
334519 5070822 1390  5070823 1388  5070833 1389  5070831 1390  5070832 1388  5070843 1387  
334520 5070847 1388  5070848 1387  5070855 1390  5070866 1388  5070872 1387  5070885 1388  
334521 5070887 1387  5070901 1387  5070909 1388  5070923 1388  5070934 1387  5070948 1387  
334522 5070958 1387  5070973 1387  5070987 1387  5070993 1385  5071012 1385  5071022 1385  
334523 5071036 1385  5071052 1383  5071060 1385  5071076 1383  5071082 1381  5071092 1381  
334524 5071095 1383  5071106 1381  5071114 1383  5071124 1383  5071124 1383  5071124 1383  
334525 5071128 1383  5071128 1383  5071128 1383  5071128 1383  5071130 1381  5071125 1381  
334526 5071114 1383  5071116 1381  5071106 1381  5071097 1381  5071092 1381  5071082 1381  
334527 5071073 1381  5071054 1381  5071049 1381  5071030 1381  5071015 1381  5071006 1381  
334528 5070992 1381  5070977 1381  5070963 1381  5070948 1381  5070925 1381  5070905 1381  
334529 5070901 1381  5070877 1381  5070862 1381  5070848 1381  5070831 1379  5070816 1379  
334530 5070805 1381  5070792 1379  5070781 1381  5070772 1381  5070753 1381  5070749 1379  
334531 5070740 1379  5070730 1379  5070726 1379  5070716 1379  5070705 1381  5070706 1379  
334532 5070702 1379  5070700 1381  5070700 1381  5070702 1379  5070700 1381  5070702 1379  
334533 5070702 1379  5070705 1381  5070705 1381  5070715 1381  5070724 1381  5070724 1381  
334534 5070729 1381  5070740 1379  5070748 1381  5070754 1379  5070772 1381  5070781 1381  
334535 5070791 1381  5070800 1381  5070805 1381  5070824 1381  5070829 1381  5070848 1381  
334536 5070853 1381  5070872 1381  5070877 1381  5070891 1381  5070901 1381  5070905 1381  
334537 5070915 1381  5070925 1381  5070929 1381  5070939 1381  5070948 1381  5070953 1381  
334538 5070963 1381  5070963 1381  5070972 1381  5070977 1381  5070977 1381  5070977 1381  
334539 5070977 1381  5070982 1381  5070977 1381  5070977 1381  5070977 1381  5070977 1381  
334540 5070977 1381  5070972 1381  5070972 1381  5070963 1381  5070953 1381  5070947 1383  
334541 5070948 1381  5070939 1381  5070929 1381  5070925 1381  5070925 1381  5070915 1381  
334542 5070904 1383  5070899 1383  5070901 1381  5070890 1383  5070890 1383  5070885 1383  
334543 5070875 1383  5070870 1383  5070870 1383  5070861 1383  5070861 1383  5070859 1385  
334544 5070861 1383  5070859 1385  5070861 1383  5070861 1383  5070861 1383  5070862 1381  
334545 5070872 1381  5070872 1381  5070877 1381  5070875 1383  5070885 1383  5070891 1381  
334546 5070891 1381  5070901 1381  5070905 1381  5070915 1381  5070929 1381  5070939 1381  
334547 5070948 1381  5070953 1381  5070961 1383  5070977 1381  5070982 1381  5070991 1381  
334548 5071006 1381  5071015 1381  5071025 1381  5071030 1381  5071049 1381  5071049 1381  
334549 5071063 1381  5071063 1381  5071072 1381  5071077 1381  5071077 1381  5071082 1381  
334550 5071092 1381  5071082 1381  5071092 1381  5071092 1381  5071092 1381  5071082 1381  
334551 5071082 1381  5071082 1381  5071077 1381  5071072 1381  5071072 1381  5071063 1381  
334552 5071054 1381  5071048 1381  5071030 1381  5071025 1381  5071006 1381  5070992 1381  
334553 5070977 1381  5070972 1381  5070953 1381  5070939 1381  5070925 1381  5070905 1381  
334554 5070891 1381  5070876 1381  5070862 1381  5070848 1381  5070829 1381  5070814 1381  
334555 5070800 1381  5070791 1381  5070781 1381  5070762 1381  5070753 1381  5070738 1381  
334556 5070729 1381  5070724 1381  5070705 1381  5070700 1381  5070700 1381  5070691 1381  
334557 5070686 1381  5070681 1381  5070681 1381  5070671 1381  5070671 1381  5070671 1381  
334558 5070662 1381  5070671 1381  5070671 1381  5070671 1381  5070671 1381  5070681 1381  
334559 5070686 1381  5070687 1379  5070691 1381  5070705 1381  5070715 1381  5070724 1381  
334560 5070729 1381  5070740 1379  5070753 1381  5070764 1379  5070781 1381  5070788 1379  
334561 5070800 1381  5070805 1381  5070826 1379  5070829 1381  5070848 1381  5070854 1379  
334562 5070872 1381  5070887 1381  5070891 1381  5070901 1381  5070905 1381  5070925 1381  
334563 5070925 1381  5070939 1381  5070948 1381  5070948 1381  5070953 1381  5070953 1381  
334564 5070963 1381  5070963 1381  5070964 1379  5070974 1379  5070964 1379  5070964 1379  
334565 5070964 1379  5070964 1379  5070964 1379  5070964 1379  5070958 1375  5070950 1379  
334566 5070950 1379  5070940 1379  5070929 1381  5070925 1381  5070917 1379  5070905 1381  
334567 5070901 1381  5070893 1379  5070891 1381  5070888 1379  5070877 1381  5070873 1379  
334568 5070862 1381  5070853 1381  5070848 1381  5070848 1381  5070840 1379  5070838 1381  
334569 5070829 1381  5070829 1381  5070829 1381  5070829 1381  5070829 1381  5070829 1381  
334570 5070838 1381  5070838 1381  5070838 1381  5070846 1383  5070846 1383  5070853 1381  
334571 5070853 1381  5070861 1383  5070875 1383  5070885 1383  5070891 1381  5070899 1383  
334572 5070913 1383  5070923 1383  5070928 1383  5070947 1383  5070952 1383  5070971 1383  
334573 5070977 1381  5070988 1385  5070993 1385  5071003 1385  5071014 1383  5071027 1385  
334574 5071036 1385  5071044 1387  5071050 1385  5071060 1385  5071069 1385  5071074 1385  
334575 5071077 1387  5071087 1387  5071087 1387  5071092 1387  5071092 1387  5071092 1387  
334576 5071092 1387  5071092 1387  5071092 1387  5071087 1387  5071087 1387  5071079 1385  
334577 5071073 1387  5071068 1387  5071059 1387  5071045 1385  5071035 1387  5071020 1387  
334578 5071009 1388  5070990 1388  5070976 1388  5070971 1388  5070958 1387  5070944 1387  
334579 5070925 1387  5070910 1387  5070895 1388  5070882 1387  5070867 1387  5070848 1387  
334580 5070833 1389  5070820 1387  5070799 1388  5070785 1388  5070775 1388  5070755 1390  
334581 5070742 1388  5070731 1390  5070716 1390  5070708 1388  5070692 1390  5070684 1388  
334582 5070675 1388  5070667 1387  5070667 1387  5070657 1387  5070657 1387  5070653 1387  
334583 5070653 1387  5070654 1385  5070657 1387  5070659 1385  5070659 1385  5070667 1387  
334584 5070678 1385  5070683 1385  5070688 1385  5070697 1385  5070711 1385  5070721 1385  
334585 5070726 1385  5070745 1385  5070759 1385  5070778 1385  5070783 1385  5070797 1385  
334586 5070812 1385  5070826 1385  5070845 1385  5070861 1383  5070875 1383  5070887 1387  
334587 5070902 1385  5070922 1385  5070926 1385  5070947 1383  5070952 1383  5070971 1383  
334588 5070974 1385  5070980 1383  5070995 1383  5071004 1383  5071012 1385  5071014 1383  
334589 5071023 1383  5071028 1383  5071028 1383  5071038 1383  5071036 1385  5071038 1383  
334590 5071038 1383  5071036 1385  5071038 1383  5071028 1383  5071025 1387  5071022 1385  
334591 5071012 1385  5071003 1385  5070993 1385  5070988 1385  5070979 1385  5070969 1385  
334592 5070958 1387  5070948 1387  5070934 1387  5070925 1387  5070921 1385  5070910 1387  
334593 5070901 1387  5070888 1385  5070881 1387  5070874 1385  5070869 1385  5070858 1387  
334594 5070848 1387  5070843 1387  5070843 1387  5070835 1385  5070835 1385  5070834 1387  
334595 5070834 1387  5070824 1387  5070834 1387  5070834 1387  5070843 1387  5070848 1387  
334596 5070848 1387  5070858 1387  5070871 1388  5070880 1388  5070885 1388  5070896 1387  
334597 5070910 1387  5070920 1387  5070933 1388  5070947 1388  5070966 1388  5070976 1388  
334598 5070992 1387  5071011 1387  5071019 1388  5071033 1388  5071047 1388  5071057 1388  
334599 5071071 1388  5071086 1388  5071090 1388  5071108 1390  5071119 1388  5071133 1388  
334600 5071143 1388  5071148 1388  5071157 1388  5071157 1388  5071167 1388  5071167 1388  
334601 5071167 1388  5071167 1388  5071165 1390  5071165 1390  5071157 1388  5071148 1388  
334602 5071143 1388  5071133 1388  5071124 1388  5071109 1388  5071100 1388  5071086 1388  
334603 5071071 1388  5071057 1388  5071043 1388  5071024 1388  5071008 1390  5070985 1388  
334604 5070971 1388  5070947 1388  5070923 1388  5070909 1388  5070887 1387  5070866 1388  
334605 5070847 1388  5070825 1387  5070810 1387  5070786 1387  5070775 1388  5070746 1388  
334606 5070734 1387  5070718 1389  5070700 1387  5070695 1387  5070681 1387  5070667 1387  
334607 5070656 1388  5070652 1387  5070641 1388  5070640 1390  5070632 1388  5070632 1388  
334608 5070632 1388  5070630 1390  5070640 1390  5070640 1390  5070649 1390  5070654 1390  
334609 5070664 1390  5070673 1390  5070679 1388  5070694 1388  5070708 1388  5070716 1390  
334610 5070731 1390  5070745 1390  5070766 1388  5070785 1388  5070799 1388  5070823 1388  
334611 5070842 1388  5070864 1390  5070879 1390  5070899 1388  5070919 1388  5070942 1388  
334612 5070957 1388  5070971 1388  5070984 1390  5071007 1390  5071015 1392  5071030 1392  
334613 5071044 1392  5071054 1392  5071068 1392  5071073 1392  5071087 1392  5071087 1392  
334614 5071097 1392  5071106 1392  5071106 1392  5071105 1394  5071106 1392  5071105 1394  
334615 5071097 1392  5071086 1394  5071086 1394  5071081 1394  5071073 1392  5071063 1392  
334616 5071054 1392  5071043 1394  5071030 1392  5071015 1392  5070997 1392  5070981 1394  
334617 5070968 1392  5070952 1394  5070942 1394  5070927 1396  5070912 1396  5070903 1396  
334618 5070889 1396  5070874 1396  5070866 1394  5070850 1396  5070840 1396  5070828 1394  
334619 5070818 1394  5070812 1396  5070812 1396  5070802 1396  5070802 1396  5070804 1394  
334620 5070802 1396  5070802 1396  5070812 1396  5070813 1394  5070817 1396  5070826 1396  
334621 5070836 1396  5070850 1396  5070860 1396  5070874 1396  5070889 1396  5070904 1394  
334622 5070917 1396  5070936 1396  5070951 1396  5070968 1398  5070984 1396  5071003 1396  
334623 5071027 1396  5071041 1396  5071065 1396  5071079 1396  5071094 1396  5071117 1396  
334624 5071138 1394  5071161 1396  5071172 1394  5071180 1396  5071194 1396  5071205 1394  
334625 5071220 1394  5071229 1394  5071239 1394  5071237 1396  5071243 1394  5071243 1394  
334626 5071242 1396  5071239 1394  5071237 1396  5071229 1394  5071229 1394  5071210 1394  
334627 5071205 1394  5071186 1394  5071172 1394  5071162 1394  5071143 1394  5071129 1394  
334628 5071105 1394  5071086 1394  5071065 1396  5071043 1394  5071019 1394  5070995 1394  
334629 5070971 1394  5070954 1392  5070917 1396  5070895 1394  5070868 1392  5070842 1394  
334630 5070818 1394  5070795 1394  5070775 1394  5070759 1396  5070737 1394  5070717 1396  
334631 5070694 1394  5070678 1396  5070670 1394  5070651 1394  5070645 1396  5070626 1396  
334632 5070616 1396  5070618 1394  5070611 1396  5070611 1396  5070602 1396  5070611 1396  
334633 5070611 1396  5070611 1396  5070618 1394  5070626 1396  5070645 1396  5070651 1394  
334634 5070669 1396  5070678 1396  5070704 1394  5070717 1396  5070735 1396  5070759 1396  
334635 5070780 1394  5070804 1394  5070826 1396  5070852 1394  5070880 1394  5070895 1394  
334636 5070919 1394  5070951 1396  5070966 1394  5070986 1394  5071012 1396  5071038 1394  
334637 5071051 1396  5071072 1394  5071086 1394  5071105 1394  5071119 1394  5071138 1394  
334638 5071156 1390  5071164 1392  5071170 1390  5071170 1390  5071175 1390  5071175 1390  
334639 5071175 1390  5071176 1388  5071176 1388  5071176 1388  5071171 1388  5071167 1388  
334640 5071146 1390  5071143 1388  5071124 1388  5071119 1388  5071090 1388  5071074 1390  
334641 5071066 1388  5071046 1390  5071033 1388  5071017 1390  5070989 1390  5070974 1390  
334642 5070955 1390  5070939 1392  5070915 1392  5070895 1394  5070875 1394  5070866 1394  
334643 5070842 1394  5070828 1394  5070818 1394  5070802 1396  5070793 1396  5070778 1396  
334644 5070774 1396  5070769 1396  5070769 1396  5070758 1398  5070759 1396  5070769 1396  
334645 5070767 1398  5070767 1398  5070774 1396  5070777 1398  5070791 1398  5070801 1398  
334646 5070815 1398  5070825 1398  5070850 1396  5070864 1396  5070879 1396  5070903 1396  
334647 5070925 1398  5070939 1398  5070965 1396  5070984 1396  5071016 1398  5071041 1396  
334648 5071065 1396  5071084 1396  5071113 1396  5071141 1396  5071159 1398  5071178 1398  
334649 5071194 1396  5071218 1396  5071237 1396  5071250 1398  5071266 1396  5071280 1396  
334650 5071283 1398  5071293 1398  5071302 1398  5071306 1400  5071307 1398  5071307 1398  
334651 5071307 1398  5071303 1398  5071293 1398  5071283 1398  5071269 1398  5071263 1400  
334652 5071248 1400  5071234 1400  5071205 1400  5071181 1400  5071167 1400  5071138 1400  
334653 5071114 1400  5071081 1400  5071057 1400  5071033 1400  5071000 1400  5070965 1402  
334654 5070938 1400  5070909 1400  5070876 1400  5070858 1398  5070823 1400  5070791 1398  
334655 5070771 1400  5070747 1400  5070712 1402  5070688 1402  5070670 1400  5070645 1402  
334656 5070632 1400  5070613 1400  5070597 1402  5070589 1400  5070583 1402  5070575 1400  
334657 5070570 1400  5070570 1400  5070568 1402  5070570 1400  5070573 1402  5070583 1402  
334658 5070597 1402  5070607 1402  5070623 1400  5070640 1402  5070664 1402  5070675 1400  
334659 5070697 1402  5070721 1402  5070747 1400  5070769 1402  5070799 1400  5070823 1400  
334660 5070855 1402  5070876 1400  5070908 1402  5070936 1402  5070960 1402  5070998 1402  
334661 5071022 1402  5071056 1402  5071076 1400  5071100 1400  5071123 1402  5071146 1402  
334662 5071162 1400  5071180 1402  5071199 1402  5071215 1400  5071232 1402  5071237 1402  
334663 5071247 1402  5071256 1402  5071260 1403  5071256 1402  5071263 1400  5071256 1402  
334664 5071256 1402  5071237 1402  5071232 1402  5071213 1402  5071199 1402  5071180 1402  
334665 5071166 1402  5071148 1400  5071134 1400  5071108 1402  5071081 1400  5071057 1400  
334666 5071032 1402  5071009 1400  5070979 1402  5070957 1400  5070931 1402  5070898 1402  
334667 5070874 1402  5070855 1402  5070833 1400  5070809 1400  5070785 1400  5070764 1402  
334668 5070747 1400  5070731 1402  5070714 1400  5070697 1402  5070688 1402  5070683 1402  
334669 5070675 1400  5070675 1400  5070674 1402  5070674 1402  5070675 1400  5070683 1402  
334670 5070688 1402  5070697 1402  5070712 1402  5070731 1402  5070745 1402  5070769 1402  
334671 5070788 1402  5070812 1402  5070836 1402  5070860 1402  5070889 1402  5070922 1402  
334672 5070956 1402  5070974 1402  5071008 1402  5071037 1402  5071059 1403  5071088 1403  
334673 5071121 1404  5071145 1403  5071174 1404  5071199 1402  5071223 1402  5071247 1402  
334674 5071266 1402  5071280 1402  5071303 1404  5071314 1402  5071328 1402  5071347 1402  
334675 5071347 1402  5071357 1402  5071355 1403  5071357 1402  5071347 1402  5071347 1402  
334676 5071337 1402  5071323 1402  5071304 1402  5071288 1403  5071275 1402  5071256 1402  
334677 5071231 1403  5071199 1402  5071174 1403  5071145 1403  5071111 1403  5071080 1402  
334678 5071044 1403  5071011 1403  5070978 1403  5070954 1403  5070911 1404  5070882 1403  
334679 5070844 1404  5070811 1404  5070782 1404  5070753 1404  5070720 1404  5070696 1404  
334680 5070667 1404  5070642 1405  5070620 1404  5070594 1405  5070572 1403  5070561 1405  
334681 5070542 1405  5070537 1405  5070527 1405  5070518 1405  5070508 1405  5070518 1405  
334682 5070518 1405  5070524 1409  5070534 1409  5070541 1405  5070558 1409  5070570 1405  
334683 5070591 1409  5070605 1409  5070634 1409  5070658 1409  5070677 1409  5070701 1409  
334684 5070728 1411  5070763 1409  5070790 1411  5070825 1409  5070854 1409  5070886 1405  
334685 5070916 1409  5070950 1409  5070973 1409  5071007 1409  5071040 1409  5071072 1405  
334686 5071105 1405  5071129 1405  5071153 1405  5071177 1405  5071193 1409  5071210 1405  
334687 5071231 1404  5071244 1405  5071258 1405  5071263 1405  5071272 1405  5071272 1405  
334688 5071272 1405  5071274 1404  5071272 1405  5071269 1409  5071260 1409  5071250 1409  
334689 5071230 1411  5071215 1411  5071198 1409  5071182 1411  5071158 1411  5071137 1413  
334690 5071113 1413  5071081 1411  5071053 1411  5071028 1413  5070999 1413  5070967 1411  
334691 5070938 1411  5070905 1411  5070876 1411  5070847 1411  5070814 1411  5070792 1409  
334692 5070763 1409  5070739 1409  5070715 1409  5070694 1405  5070671 1405  5070661 1405  
334693 5070639 1409  5070628 1405  5070618 1405  5070601 1409  5070601 1409  5070590 1411  
334694 5070590 1411  5070590 1411  5070598 1413  5070602 1413  5070622 1413  5070631 1413  
334695 5070645 1413  5070664 1413  5070688 1413  5070712 1413  5070736 1413  5070762 1411  
334696 5070789 1413  5070824 1411  5070852 1411  5070881 1411  5070924 1411  5070953 1411  
334697 5070981 1411  5071024 1411  5071052 1413  5071080 1413  5071125 1411  5071153 1411  
334698 5071182 1411  5071215 1411  5071241 1409  5071268 1411  5071293 1409  5071315 1411  
334699 5071341 1409  5071355 1409  5071370 1409  5071384 1409  5071394 1409  5071398 1409  
334700 5071398 1409  5071398 1409  5071398 1409  5071398 1409  5071394 1409  5071377 1405  
334701 5071360 1409  5071350 1409  5071332 1409  5071297 1411  5071280 1413  5071252 1413  
334702 5071227 1415  5071192 1417  5071163 1417  5071125 1417  5071096 1417  5071053 1417  
334703 5071024 1417  5070985 1419  5070946 1419  5070918 1419  5070875 1419  5070848 1417  
334704 5070806 1420  5070774 1419  5070741 1419  5070708 1419  5070684 1419  5070655 1419  
334705 5070633 1417  5070609 1417  5070593 1419  5070571 1417  5070561 1417  5070550 1419  
334706 5070542 1417  5070531 1419  5070531 1419  5070531 1419  5070540 1419  5070550 1419  
334707 5070553 1420  5070569 1419  5070582 1420  5070598 1419  5070625 1420  5070639 1420  
334708 5070669 1419  5070692 1420  5070716 1420  5070751 1419  5070774 1419  5070808 1419  
334709 5070841 1419  5070875 1419  5070908 1419  5070946 1419  5070975 1419  5071008 1419  
334710 5071048 1417  5071077 1417  5071110 1417  5071144 1417  5071168 1417  5071203 1415  
334711 5071225 1417  5071250 1415  5071270 1415  5071289 1415  5071303 1415  5071319 1413  
334712 5071336 1415  5071338 1413  5071354 1411  5071352 1413  5071354 1411  5071354 1411  
334713 5071347 1413  5071338 1413  5071319 1413  5071314 1413  5071290 1413  5071266 1413  
334714 5071254 1411  5071228 1413  5071204 1413  5071171 1413  5071147 1413  5071115 1411  
334715 5071072 1411  5071046 1413  5071013 1413  5070969 1415  5070945 1415  5070910 1417  
334716 5070871 1417  5070843 1417  5070809 1417  5070771 1417  5070741 1419  5070709 1417  
334717 5070684 1419  5070655 1419  5070631 1419  5070617 1419  5070593 1419  5070574 1419  
334718 5070560 1419  5070555 1419  5070550 1419  5070549 1420  5070550 1419  5070550 1419  
334719 5070553 1420  5070567 1420  5070572 1420  5070592 1420  5070606 1420  5070630 1420  
334720 5070654 1420  5070673 1420  5070694 1424  5070730 1420  5070754 1420  5070783 1420  
334721 5070822 1419  5070856 1419  5070894 1419  5070932 1419  5070953 1417  5070996 1417  
334722 5071034 1417  5071063 1417  5071101 1417  5071134 1417  5071163 1417  5071203 1415  
334723 5071236 1415  5071255 1415  5071289 1415  5071313 1415  5071338 1413  5071351 1415  
334724 5071370 1415  5071389 1415  5071394 1415  5071403 1415  5071403 1415  5071402 1417  
334725 5071403 1415  5071392 1417  5071387 1417  5071378 1417  5071364 1417  5071344 1417  
334726 5071325 1417  5071301 1417  5071266 1419  5071249 1417  5071223 1418  5071187 1417  
334727 5071153 1417  5071119 1419  5071075 1419  5071047 1419  5071008 1419  5070975 1419  
334728 5070940 1420  5070897 1420  5070859 1420  5070830 1420  5070792 1420  5070756 1424  
334729 5070730 1420  5070693 1424  5070668 1420  5070649 1420  5070613 1424  5070593 1424  
334730 5070569 1424  5070564 1424  5070550 1424  5070544 1426  5070536 1424  5070534 1426  
334731 5070534 1426  5070533 1428  5070534 1426  5070546 1424  5070550 1424  5070565 1424  
334732 5070582 1420  5070596 1420  5070626 1419  5070650 1419  5070676 1417  5070700 1417  
334733 5070735 1415  5070765 1413  5070797 1415  5070825 1415  5070865 1413  5070900 1411  
334734 5070937 1413  5070967 1411  5071007 1409  5071040 1409  5071073 1409  5071120 1405  
334735 5071153 1405  5071177 1405  5071210 1405  5071234 1405  5071264 1404  5071288 1404  
334736 5071312 1403  5071327 1404  5071345 1403  5071360 1404  5071365 1404  5071374 1404  
334737 5071374 1404  5071379 1404  5071374 1403  5071374 1404  5071365 1404  5071355 1404  
334738 5071336 1404  5071322 1404  5071298 1404  5071274 1403  5071255 1404  5071221 1403  
334739 5071188 1404  5071159 1404  5071121 1404  5071088 1404  5071054 1403  5071013 1402  
334740 5070975 1402  5070944 1404  5070906 1403  5070868 1404  5070830 1404  5070787 1404  
334741 5070763 1404  5070720 1404  5070682 1409  5070661 1405  5070623 1411  5070601 1409  
334742 5070575 1411  5070555 1413  5070534 1415  5070518 1417  5070499 1417  5070493 1419  
334743 5070483 1419  5070473 1419  5070472 1420  5070472 1420  5070482 1420  5070488 1424  
334744 5070505 1420  5070525 1420  5070539 1420  5070558 1420  5070579 1424  5070603 1424  
334745 5070639 1420  5070655 1424  5070689 1424  5070721 1420  5070760 1419  5070794 1419  
334746 5070833 1417  5070871 1417  5070902 1415  5070945 1415  5070980 1413  5071023 1413  
334747 5071058 1411  5071102 1409  5071131 1409  5071172 1405  5071202 1404  5071234 1405  
334748 5071264 1404  5071279 1404  5071310 1405  5071336 1404  5071360 1403  5071363 1405  
334749 5071377 1405  5071387 1405  5071394 1409  5071394 1409  5071394 1409  5071384 1409  
334750 5071373 1411  5071370 1409  5071354 1411  5071341 1409  5071317 1409  5071298 1409  
334751 5071269 1409  5071250 1409  5071217 1409  5071183 1409  5071160 1409  5071131 1409  
334752 5071096 1405  5071055 1409  5071026 1409  5070986 1405  5070950 1409  5070909 1405  
334753 5070886 1405  5070852 1405  5070819 1405  5070785 1405  5070761 1405  5070729 1403  
334754 5070696 1404  5070680 1405  5070661 1405  5070642 1405  5070618 1405  5070608 1405  
334755 5070594 1405  5070585 1405  5070585 1405  5070580 1405  5070585 1405  5070585 1405  
334756 5070591 1409  5070604 1405  5070618 1405  5070637 1405  5070653 1404  5070670 1405  
334757 5070694 1405  5070719 1405  5070752 1405  5070780 1405  5070801 1409  5070842 1405  
334758 5070871 1405  5070905 1405  5070940 1409  5070968 1409  5071010 1405  5071040 1409  
334759 5071073 1409  5071107 1409  5071150 1409  5071174 1409  5071207 1409  5071241 1409  
334760 5071269 1409  5071293 1409  5071320 1405  5071344 1405  5071360 1404  5071377 1405  
334761 5071387 1405  5071401 1405  5071412 1404  5071412 1403  5071411 1405  5071422 1404  
334762 5071411 1405  5071412 1404  5071398 1404  5071377 1405  5071365 1404  5071355 1404  
334763 5071327 1404  5071301 1405  5071272 1405  5071255 1403  5071222 1404  5071174 1409  
334764 5071153 1405  5071110 1405  5071072 1405  5071031 1409  5071002 1409  5070959 1409  
334765 5070929 1405  5070886 1405  5070842 1405  5070801 1409  5070763 1409  5070730 1409  
334766 5070692 1409  5070663 1409  5070634 1409  5070605 1409  5070577 1409  5070556 1411  
334767 5070539 1409  5070515 1409  5070500 1409  5070491 1409  5070480 1411  5070475 1411  
334768 5070465 1411  5070465 1411  5070476 1409  5070480 1411  5070499 1411  5070504 1411  
334769 5070523 1411  5070537 1411  5070561 1411  5070582 1409  5070605 1409  5070632 1411  
334770 5070663 1409  5070695 1405  5070728 1405  5070766 1405  5070795 1405  5070833 1405  
334771 5070871 1405  5070911 1404  5070953 1405  5070988 1404  5071019 1405  5071058 1405  
334772 5071086 1405  5071129 1405  5071155 1409  5071187 1405  5071220 1405  5071241 1409  
334773 5071260 1409  5071286 1405  5071301 1405  5071320 1405  5071331 1409  5071344 1405  
334774 5071350 1409  5071358 1405  5071358 1405  5071353 1405  5071344 1405  5071335 1405  
334775 5071325 1405  5071312 1404  5071296 1405  5071279 1404  5071260 1403  5071234 1405  
334776 5071207 1409  5071183 1409  5071158 1405  5071126 1409  5071096 1405  5071059 1409  
334777 5071024 1411  5070992 1409  5070956 1413  5070929 1411  5070900 1411  5070867 1411  
334778 5070838 1411  5070803 1413  5070780 1411  5070760 1413  5070728 1411  5070704 1411  
334779 5070688 1413  5070675 1411  5070660 1413  5070647 1411  5070636 1413  5070631 1413  
334780 5070623 1411  5070620 1415  5070620 1415  5070629 1415  5070631 1413  5070634 1415  
334781 5070655 1413  5070664 1413  5070679 1413  5070698 1413  5070725 1415  5070754 1415  
334782 5070773 1415  5070797 1415  5070821 1415  5070849 1415  5070878 1415  5070921 1415  
334783 5070948 1417  5070978 1415  5071011 1415  5071045 1415  5071069 1415  5071101 1417  
334784 5071136 1415  5071168 1417  5071193 1415  5071225 1417  5071255 1415  5071279 1415  
334785 5071303 1415  5071317 1415  5071346 1415  5071356 1415  5071370 1415  5071379 1415  
334786 5071389 1415  5071392 1417  5071389 1415  5071387 1417  5071389 1415  5071389 1415  
334787 5071368 1417  5071365 1415  5071351 1415  5071336 1415  5071312 1415  5071289 1415  
334788 5071265 1415  5071235 1417  5071203 1415  5071169 1415  5071136 1415  5071101 1417  
334789 5071069 1415  5071034 1417  5070997 1415  5070953 1417  5070924 1417  5070886 1417  
334790 5070848 1417  5070818 1419  5070784 1419  5070751 1419  5070717 1419  5070682 1420  
334791 5070655 1419  5070630 1420  5070596 1420  5070569 1424  5070558 1420  5070536 1424  
334792 5070522 1424  5070502 1424  5070493 1424  5070488 1424  5070479 1424  5070482 1420  
334793 5070479 1424  5070488 1424  5070493 1424  5070505 1420  5070522 1424  5070536 1424  
334794 5070550 1424  5070564 1424  5070587 1426  5070615 1420  5070646 1424  5070668 1420  
334795 5070693 1424  5070727 1424  5070756 1424  5070794 1424  5070826 1426  5070865 1424  
334796 5070893 1426  5070931 1420  5070961 1424  5070994 1424  5071028 1424  5071060 1420  
334797 5071093 1420  5071122 1420  5071145 1420  5071165 1420  5071189 1420  5071219 1419  
334798 5071241 1420  5071250 1420  5071265 1420  5071275 1420  5071284 1420  5071289 1420  
334799 5071289 1420  5071289 1420  5071290 1419  5071290 1418  5071285 1419  5071266 1419  
334800 5071262 1419  5071247 1419  5071233 1419  5071220 1417  5071192 1417  5071166 1419  
334801 5071147 1419  5071125 1417  5071099 1419  5071066 1419  5071047 1419  5071018 1419  
334802 5070996 1417  5070962 1417  5070942 1419  5070919 1417  5070884 1419  5070861 1419  
334803 5070841 1419  5070819 1417  5070795 1417  5070774 1419  5070755 1419  5070741 1419  
334804 5070722 1419  5070719 1417  5070700 1417  5070698 1419  5070695 1417  5070693 1419  
334805 5070693 1419  5070693 1419  5070700 1417  5070709 1417  5070720 1415  5070735 1415  
334806 5070745 1413  5070765 1413  5070779 1413  5070803 1413  5070827 1413  5070852 1411  
334807 5070875 1413  5070899 1413  5070923 1413  5070951 1413  5070980 1413  5071012 1415  
334808 5071037 1413  5071066 1413  5071099 1413  5071128 1413  5071156 1413  5071190 1413  
334809 5071214 1413  5071247 1413  5071265 1415  5071289 1415  5071303 1415  5071328 1413  
334810 5071346 1415  5071356 1415  5071379 1415  5071379 1415  5071389 1415  5071394 1415  
334811 5071392 1417  5071394 1415  5071392 1417  5071387 1417  5071378 1417  5071368 1417  
334812 5071354 1417  5071344 1417  5071325 1417  5071301 1417  5071278 1417  5071263 1417  
334813 5071235 1417  5071211 1417  5071177 1417  5071148 1417  5071120 1417  5071087 1417  
334814 5071048 1417  5071018 1419  5070988 1415  5070948 1417  5070919 1417  5070886 1417  
334815 5070859 1415  5070824 1417  5070795 1417  5070760 1419  5070741 1419  5070709 1417  
334816 5070685 1417  5070660 1419  5070641 1419  5070626 1419  5070607 1419  5070584 1419  
334817 5070574 1419  5070567 1420  5070555 1419  5070552 1417  5070550 1419  5070550 1418  
334818 5070556 1417  5070555 1419  5070558 1420  5070575 1417  5070584 1419  5070599 1417  
334819 5070619 1417  5070631 1419  5070652 1417  5070669 1419  5070695 1417  5070719 1417  
334820 5070742 1417  5070771 1417  5070795 1417  5070824 1417  5070857 1417  5070884 1419  
334821 5070917 1420  5070946 1419  5070975 1419  5071001 1417  5071032 1419  5071052 1419  
334822 5071074 1420  5071107 1420  5071123 1419  5071145 1420  5071161 1419  5071174 1420  
334823 5071189 1420  5071198 1420  5071217 1420  5071222 1420  5071233 1419  5071241 1420  
334824 5071241 1420  5071242 1419  5071243 1419  5071235 1417  5071224 1419  5071219 1419  
334825 5071200 1419  5071190 1419  5071176 1419  5071161 1419  5071148 1417  5071125 1417  
334826 5071109 1419  5071087 1417  5071066 1419  5071048 1417  5071024 1417  5071001 1417  
334827 5070977 1417  5070953 1417  5070932 1419  5070919 1417  5070895 1417  5070875 1419  
334828 5070856 1419  5070841 1419  5070824 1417  5070819 1417  5070798 1419  5070784 1419  
334829 5070774 1419  5070771 1417  5070762 1417  5070760 1419  5070755 1419  5070755 1419  
334830 5070760 1419  5070771 1417  5070770 1419  5070774 1419  5070794 1419  5070806 1420  
334831 5070818 1419  5070832 1419  5070856 1419  5070870 1419  5070884 1419  5070899 1419  
334832 5070923 1419  5070948 1417  5070961 1419  5070985 1419  5071018 1419  5071043 1417  
334833 5071063 1417  5071088 1415  5071120 1417  5071136 1415  5071154 1417  5071179 1415  
334834 5071201 1417  5071225 1417  5071244 1417  5071255 1415  5071268 1417  5071277 1417  
334835 5071292 1417  5071300 1419  5071311 1417  5071316 1417  5071316 1417  5071324 1419  
334836 5071324 1419  5071316 1417  5071317 1415  5071311 1417  5071301 1417  5071287 1417  
334837 5071277 1417  5071263 1417  5071250 1415  5071227 1415  5071203 1415  5071179 1415  
334838 5071157 1413  5071136 1415  5071112 1415  5071080 1413  5071052 1413  5071024 1411  
334839 5070999 1413  5070965 1413  5070948 1411  5070913 1413  5070879 1413  5070851 1413  
334840 5070827 1413  5070798 1413  5070774 1413  5070746 1413  5070727 1413  5070698 1413  
334841 5070679 1413  5070661 1411  5070645 1413  5070631 1413  5070612 1413  5070598 1413  
334842 5070588 1413  5070574 1413  5070564 1413  5070559 1413  5070559 1413  5070560 1413  
334843 5070559 1413  5070564 1413  5070564 1413  5070573 1413  5070579 1413  5070598 1413  
334844 5070602 1413  5070623 1411  5070636 1413  5070657 1411  5070666 1411  5070690 1411  
334845 5070712 1413  5070736 1413  5070762 1411  5070780 1411  5070798 1413  5070827 1413  
334846 5070851 1413  5070875 1413  5070900 1411  5070924 1411  5070946 1413  5070967 1411  
334847 5070980 1413  5071004 1413  5071029 1411  5071037 1413  5071056 1413  5071070 1413  
334848 5071080 1413  5071099 1413  5071104 1413  5071113 1413  5071123 1413  5071128 1413  
334849 5071128 1413  5071128 1413  5071126 1415  5071126 1415  5071128 1413  5071123 1413  
334850 5071113 1413  5071102 1415  5071099 1413  5071090 1413  5071069 1415  5071056 1413  
334851 5071052 1413  5071037 1413  5071023 1413  5071002 1415  5070980 1413  5070964 1415  
334852 5070951 1413  5070935 1415  5070923 1413  5070903 1413  5070889 1413  5070879 1413  
334853 5070864 1415  5070851 1413  5070844 1415  5070836 1413  5070825 1415  5070821 1415  
334854 5070811 1415  5070800 1417  5070800 1417  5070801 1415  5070800 1417  5070801 1415  
334855 5070800 1417  5070800 1417  5070809 1417  5070819 1417  5070825 1415  5070833 1417  
334856 5070843 1417  5070857 1417  5070873 1415  5070876 1417  5070895 1417  5070910 1417  
334857 5070924 1417  5070943 1417  5070962 1417  5070986 1417  5071000 1417  5071024 1417  
334858 5071043 1417  5071053 1417  5071077 1417  5071098 1415  5071110 1417  5071126 1415  
334859 5071145 1415  5071157 1413  5071172 1411  5071191 1411  5071198 1409  5071217 1409  
334860 5071217 1409  5071226 1409  5071231 1409  5071234 1405  5071241 1409  5071244 1405  
334861 5071245 1404  5071244 1405  5071234 1405  5071234 1405  5071229 1405  5071212 1404  
334862 5071202 1404  5071198 1404  5071178 1404  5071164 1403  5071155 1403  5071135 1403  
334863 5071111 1404  5071097 1404  5071073 1403  5071054 1404  5071034 1405  5071006 1403  
334864 5070978 1403  5070959 1404  5070944 1403  5070911 1403  5070887 1404  5070871 1405  
334865 5070852 1405  5070820 1404  5070795 1405  5070772 1403  5070761 1405  5070733 1405  
334866 5070718 1405  5070694 1405  5070680 1405  5070666 1405  5070653 1403  5070639 1403  
334867 5070628 1405  5070620 1403  5070610 1404  5070604 1405  5070605 1404  5070596 1404  
334868 5070596 1404  5070594 1405  5070596 1404  5070596 1404  5070596 1403  5070605 1403  
334869 5070610 1404  5070620 1403  5070629 1404  5070643 1403  5070663 1403  5070667 1403  
334870 5070687 1404  5070705 1404  5070720 1404  5070744 1403  5070763 1404  5070780 1405  
334871 5070795 1405  5070820 1404  5070842 1405  5070857 1405  5070881 1405  5070897 1404  
334872 5070919 1405  5070933 1405  5070953 1405  5070962 1405  5070988 1404  5070997 1404  
334873 5071011 1404  5071030 1404  5071035 1404  5071045 1404  5071053 1405  5071059 1404  
334874 5071064 1404  5071073 1404  5071073 1403  5071078 1404  5071078 1404  5071078 1404  
334875 5071078 1404  5071078 1404  5071073 1404  5071064 1404  5071059 1404  5071054 1404  
334876 5071045 1404  5071035 1403  5071030 1403  5071011 1404  5071006 1403  5070987 1404  
334877 5070976 1405  5070964 1404  5070959 1404  5070944 1404  5070935 1403  5070921 1404  
334878 5070911 1404  5070906 1404  5070886 1405  5070881 1405  5070873 1403  5070868 1404  
334879 5070868 1404  5070859 1404  5070854 1404  5070844 1403  5070844 1404  5070835 1404  
334880 5070835 1404  5070844 1404  5070844 1403  5070844 1403  5070854 1403  5070858 1403  
334881 5070868 1403  5070874 1402  5070882 1403  5070887 1403  5070908 1402  5070911 1404  
334882 5070930 1404  5070944 1403  5070959 1403  5070963 1403  5070978 1403  5070997 1403  
334883 5071011 1404  5071030 1404  5071044 1403  5071059 1404  5071073 1404  5071088 1403  
334884 5071107 1404  5071121 1403  5071135 1404  5071155 1403  5071159 1404  5071174 1404  
334885 5071178 1403  5071188 1403  5071198 1404  5071202 1403  5071212 1403  5071221 1403  
334886 5071221 1403  5071221 1403  5071221 1403  5071229 1405  5071222 1404  5071221 1403  
334887 5071212 1404  5071201 1405  5071196 1405  5071187 1405  5071177 1405  5071164 1404  
334888 5071153 1405  5071143 1405  5071129 1405  5071110 1405  5071086 1405  5071073 1403  
334889 5071058 1405  5071034 1405  5071010 1405  5070995 1405  5070971 1405  5070949 1409  
334890 5070929 1405  5070904 1405  5070878 1409  5070866 1405  5070842 1405  5070819 1405  
334891 5070804 1405  5070785 1405  5070766 1405  5070752 1405  5070733 1405  5070709 1405  
334892 5070691 1409  5070685 1405  5070671 1405  5070663 1409  5070652 1405  5070639 1409  
334893 5070637 1405  5070637 1405  5070628 1405  5070625 1409  5070625 1409  5070625 1409  
334894 5070625 1409  5070634 1409  5070642 1405  5070652 1405  5070661 1405  5070671 1405  
334895 5070677 1409  5070694 1405  5070710 1403  5070728 1405  5070742 1405  5070763 1404  
334896 5070768 1409  5070792 1409  5070809 1405  5070830 1409  5070852 1405  5070871 1405  
334897 5070892 1409  5070909 1405  5070930 1409  5070953 1405  5070959 1409  5070973 1409  
334898 5070992 1409  5071010 1405  5071026 1409  5071040 1409  5071054 1409  5071059 1409  
334899 5071069 1409  5071073 1409  5071083 1409  5071093 1409  5071102 1409  5071101 1411  
334900 5071102 1409  5071102 1409  5071101 1411  5071102 1409  5071101 1411  5071093 1409  
334901 5071082 1411  5071081 1411  5071072 1411  5071069 1409  5071059 1409  5071053 1411  
334902 5071039 1411  5071031 1409  5071024 1411  5071005 1411  5071005 1411  5070991 1411  
334903 5070972 1411  5070968 1409  5070953 1411  5070948 1411  5070929 1411  5070925 1409  
334904 5070906 1409  5070902 1409  5070892 1409  5070881 1411  5070876 1411  5070868 1409  
334905 5070867 1411  5070862 1411  5070863 1409  5070857 1405  5070854 1409  5070862 1411  
334906 5070863 1409  5070866 1405  5070868 1409  5070878 1409  5070883 1409  5070892 1409  
334907 5070902 1409  5070906 1409  5070924 1411  5070930 1409  5070948 1411  5070957 1411  
334908 5070968 1409  5070991 1411  5071007 1409  5071026 1409  5071040 1409  5071058 1405  
334909 5071069 1409  5071096 1405  5071107 1409  5071126 1409  5071140 1409  5071153 1411  
334910 5071169 1409  5071172 1411  5071191 1411  5071198 1409  5071206 1411  5071217 1409  
334911 5071226 1409  5071230 1411  5071239 1411  5071239 1411  5071249 1411  5071249 1411  
334912 5071250 1409  5071249 1411  5071239 1411  5071239 1411  5071228 1413  5071225 1411  
334913 5071215 1411  5071195 1413  5071182 1411  5071168 1411  5071157 1413  5071137 1413  
334914 5071125 1411  5071104 1413  5071080 1413  5071056 1413  5071037 1413  5071013 1413  
334915 5070999 1413  5070970 1413  5070953 1411  5070927 1413  5070905 1411  5070876 1411  
334916 5070852 1411  5070828 1411  5070814 1411  5070790 1411  5070766 1411  5070757 1411  
334917 5070727 1413  5070714 1411  5070690 1411  5070679 1413  5070666 1411  5070657 1411  
334918 5070647 1411  5070637 1411  5070637 1411  5070632 1411  5070622 1413  5070623 1411  
334919 5070623 1411  5070633 1411  5070633 1411  5070637 1411  5070645 1413  5070655 1413  
334920 5070664 1413  5070675 1411  5070688 1413  5070703 1413  5070728 1411  5070747 1411  
334921 5070760 1413  5070779 1413  5070798 1413  5070814 1411  5070837 1413  5070862 1411  
334922 5070879 1413  5070899 1413  5070923 1413  5070937 1413  5070956 1413  5070970 1413  
334923 5071000 1411  5071011 1415  5071037 1413  5071046 1413  5071056 1413  5071070 1413  
334924 5071080 1413  5071090 1413  5071104 1413  5071113 1413  5071112 1415  5071122 1415  
334925 5071128 1413  5071128 1413  5071126 1415  5071126 1415  5071122 1415  5071121 1415  
334926 5071113 1413  5071104 1413  5071099 1413  5071090 1413  5071080 1413  5071066 1413  
334927 5071058 1411  5071046 1413  5071029 1411  5071014 1411  5070999 1413  5070980 1413  
334928 5070967 1411  5070953 1411  5070937 1413  5070923 1413  5070905 1411  5070899 1413  
334929 5070879 1413  5070876 1411  5070862 1411  5070851 1413  5070836 1413  5070829 1411  
334930 5070822 1413  5070814 1411  5070804 1411  5070803 1413  5070801 1409  5070800 1411  
334931 5070800 1411  5070800 1411  5070800 1411  5070803 1413  5070814 1411  5070824 1411  
334932 5070828 1411  5070847 1411  5070854 1409  5070862 1411  5070876 1411  5070891 1411  
334933 5070905 1411  5070924 1411  5070938 1411  5070953 1411  5070967 1411  5070991 1411  
334934 5071005 1411  5071031 1409  5071048 1411  5071058 1411  5071083 1409  5071101 1411  
334935 5071115 1411  5071129 1411  5071153 1411  5071169 1409  5071183 1409  5071193 1409  
334936 5071207 1409  5071217 1409  5071225 1411  5071230 1411  5071239 1411  5071249 1411  
334937 5071249 1411  5071249 1411  5071247 1413  5071239 1411  5071228 1413  5071225 1411  
334938 5071215 1411  5071204 1413  5071195 1413  5071182 1411  5071168 1411  5071147 1413  
334939 5071129 1411  5071113 1413  5071090 1413  5071067 1411  5071048 1411  5071023 1413  
334940 5071000 1411  5070970 1413  5070948 1411  5070924 1411  5070899 1413  5070865 1413  
334941 5070847 1411  5070814 1411  5070789 1413  5070765 1413  5070747 1411  5070723 1411  
334942 5070699 1411  5070675 1411  5070661 1411  5070647 1411  5070633 1411  5070614 1411  
334943 5070602 1413  5070590 1411  5070590 1411  5070579 1413  5070580 1411  5070575 1411  
334944 5070580 1411  5070580 1411  5070590 1411  5070590 1411  5070604 1411  5070604 1411  
334945 5070623 1411  5070637 1411  5070658 1409  5070666 1411  5070690 1411  5070704 1411  
334946 5070727 1413  5070757 1411  5070776 1411  5070800 1411  5070822 1413  5070852 1411  
334947 5070876 1411  5070900 1411  5070924 1411  5070946 1413  5070965 1413  5070989 1413  
334948 5071015 1411  5071035 1415  5071052 1413  5071070 1413  5071090 1413  5071104 1413  
334949 5071123 1413  5071128 1413  5071147 1413  5071151 1413  5071158 1411  5071157 1413  
334950 5071158 1411  5071168 1411  5071168 1411  5071158 1411  5071158 1411  5071155 1409  
334951 5071148 1411  5071140 1409  5071126 1409  5071115 1411  5071093 1409  5071073 1409  
334952 5071062 1405  5071053 1405  5071031 1409  5071007 1409  5070995 1405  5070968 1409  
334953 5070953 1405  5070930 1409  5070916 1409  5070895 1405  5070881 1405  5070857 1405  
334954 5070839 1409  5070825 1409  5070809 1405  5070792 1409  5070782 1409  5070771 1405  
334955 5070766 1405  5070752 1405  5070749 1409  5070742 1405  5070739 1409  5070733 1405  
334956 5070733 1405  5070730 1409  5070742 1405  5070752 1405  5070761 1405  5070766 1405  
334957 5070771 1405  5070785 1405  5070795 1405  5070806 1409  5070828 1405  5070842 1405  
334958 5070866 1405  5070881 1405  5070905 1405  5070929 1405  5070953 1405  5070968 1409  
334959 5070995 1405  5071019 1405  5071040 1409  5071062 1405  5071086 1405  5071107 1409  
334960 5071134 1405  5071158 1405  5071172 1405  5071196 1405  5071210 1405  5071229 1405  
334961 5071241 1409  5071255 1409  5071260 1409  5071269 1409  5071277 1405  5071287 1405  
334962 5071287 1405  5071286 1405  5071286 1405  5071277 1405  5071269 1409  5071263 1405  
334963 5071255 1409  5071244 1405  5071234 1405  5071210 1405  5071196 1405  5071172 1405  
334964 5071150 1409  5071126 1409  5071102 1409  5071076 1405  5071053 1405  5071029 1405  
334965 5070995 1405  5070962 1405  5070944 1404  5070909 1405  5070877 1409  5070852 1405  
334966 5070819 1405  5070796 1404  5070766 1405  5070742 1405  5070709 1405  5070694 1405  
334967 5070671 1405  5070652 1405  5070637 1405  5070618 1405  5070604 1405  5070585 1405  
334968 5070580 1405  5070570 1405  5070570 1405  5070562 1409  5070566 1405  5070562 1409  
334969 5070570 1405  5070580 1405  5070582 1409  5070591 1409  5070605 1409  5070625 1409  
334970 5070642 1405  5070666 1405  5070677 1409  5070701 1409  5070725 1409  5070758 1409  
334971 5070777 1409  5070804 1411  5070830 1409  5070863 1409  5070883 1409  5070914 1411  
334972 5070949 1409  5070968 1409  5071002 1409  5071029 1405  5071048 1411  5071067 1411  
334973 5071093 1409  5071115 1411  5071140 1409  5071153 1411  5071169 1409  5071183 1409  
334974 5071198 1409  5071207 1409  5071217 1409  5071226 1409  5071226 1409  5071226 1409  
334975 5071226 1409  5071225 1411  5071217 1409  5071206 1411  5071193 1409  5071183 1409  
334976 5071169 1409  5071153 1411  5071140 1409  5071116 1409  5071102 1409  5071073 1409  
334977 5071058 1405  5071030 1409  5071010 1405  5070986 1405  5070959 1409  5070943 1405  
334978 5070919 1405  5070886 1405  5070866 1405  5070844 1403  5070820 1403  5070796 1404  
334979 5070782 1403  5070768 1403  5070744 1403  5070736 1402  5070721 1402  5070709 1400  
334980 5070699 1400  5070690 1400  5070685 1400  5070677 1398  5070677 1398  5070677 1398  
334981 5070677 1398  5070688 1396  5070688 1396  5070702 1396  5070712 1396  5070726 1396  
334982 5070742 1394  5070761 1394  5070780 1394  5070794 1394  5070818 1394  5070842 1394  
334983 5070864 1390  5070882 1392  5070915 1392  5070939 1392  5070968 1392  5070987 1392  
334984 5071020 1392  5071043 1394  5071073 1392  5071097 1392  5071129 1394  5071154 1392  
334985 5071172 1394  5071199 1390  5071221 1392  5071240 1392  5071256 1390  5071269 1392  
334986 5071283 1392  5071297 1392  5071308 1390  5071312 1392  5071313 1390  5071313 1390  
334987 5071313 1390  5071313 1390  5071307 1392  5071299 1390  5071299 1390  5071284 1390  
334988 5071272 1388  5071256 1390  5071241 1390  5071214 1388  5071184 1390  5071167 1388  
334989 5071141 1390  5071108 1390  5071084 1390  5071055 1390  5071022 1390  5070990 1388  
334990 5070965 1390  5070933 1388  5070898 1390  5070871 1388  5070842 1388  5070808 1388  
334991 5070778 1390  5070756 1388  5070721 1390  5070699 1388  5070678 1390  5070654 1390  
334992 5070640 1390  5070621 1390  5070608 1388  5070594 1388  5070584 1388  5070574 1388  
334993 5070574 1388  5070565 1388  5070565 1388  5070565 1388  5070574 1388  5070579 1388  
334994 5070584 1388  5070598 1388  5070608 1388  5070622 1388  5070651 1389  5070665 1388  
334995 5070686 1387  5070710 1387  5070732 1388  5070756 1388  5070786 1387  5070818 1388  
334996 5070847 1388  5070871 1388  5070899 1388  5070933 1388  5070966 1388  5070990 1388  
334997 5071024 1388  5071047 1388  5071076 1388  5071100 1388  5071124 1388  5071147 1388  
334998 5071172 1388  5071186 1388  5071200 1388  5071214 1388  5071234 1388  5071243 1388  
334999 5071248 1388  5071248 1388  5071258 1388  5071248 1388  5071249 1387  5071249 1387  
335000 5071235 1387  5071235 1387  5071216 1387  5071202 1387  5071192 1387  5071173 1387  
335001 5071160 1385  5071136 1385  5071112 1385  5071079 1385  5071060 1385  5071027 1385  
335002 5071003 1385  5070974 1385  5070952 1383  5070923 1383  5070898 1385  5070869 1385  
335003 5070845 1385  5070823 1383  5070788 1385  5070770 1383  5070750 1385  5070727 1383  
335004 5070703 1383  5070689 1383  5070679 1383  5070662 1381  5070656 1383  5070646 1383  
335005 5070625 1385  5070627 1383  5070627 1383  5070627 1383  5070627 1383  5070625 1385  
335006 5070636 1383  5070656 1383  5070660 1383  5070679 1383  5070691 1381  5070703 1383  
335007 5070727 1383  5070751 1383  5070781 1381  5070799 1383  5070823 1383  5070851 1383  
335008 5070875 1383  5070905 1381  5070937 1383  5070972 1381  5070995 1383  5071028 1383  
335009 5071062 1383  5071090 1383  5071114 1383  5071149 1381  5071176 1383  5071205 1383  
335010 5071217 1385  5071246 1385  5071272 1383  5071281 1383  5071294 1385  5071315 1383  
335011 5071318 1385  5071338 1383  5071342 1385  5071342 1385  5071342 1385  5071343 1383  
335012 5071337 1385  5071337 1385  5071328 1385  5071313 1385  5071294 1385  5071279 1385  
335013 5071261 1385  5071246 1385  5071217 1385  5071195 1383  5071171 1383  5071138 1383  
335014 5071105 1383  5071080 1383  5071047 1383  5071014 1383  5070980 1383  5070952 1383  
335015 5070923 1383  5070890 1383  5070861 1383  5070827 1383  5070803 1383  5070779 1383  
335016 5070746 1383  5070722 1383  5070699 1383  5070681 1381  5070660 1383  5070646 1383  
335017 5070628 1381  5070614 1381  5070603 1383  5070600 1381  5070600 1381  5070590 1381  
335018 5070589 1383  5070590 1381  5070600 1381  5070614 1381  5070622 1383  5070636 1383  
335019 5070660 1383  5070681 1381  5070689 1383  5070713 1383  5070737 1383  5070759 1385  
335020 5070788 1385  5070821 1385  5070843 1387  5070872 1387  5070901 1387  5070933 1388  
335021 5070966 1388  5070992 1387  5071022 1390  5071055 1390  5071086 1388  5071117 1390  
335022 5071146 1390  5071170 1390  5071188 1392  5071211 1392  5071240 1392  5071266 1390  
335023 5071273 1392  5071286 1394  5071297 1392  5071305 1394  5071312 1392  5071320 1394  
335024 5071320 1394  5071321 1392  5071310 1394  5071305 1394  5071296 1394  5071281 1394  
335025 5071273 1392  5071255 1392  5071238 1394  5071211 1392  5071188 1392  5071165 1390  
335026 5071140 1392  5071106 1392  5071073 1392  5071044 1392  5071017 1390  5070982 1392  
335027 5070955 1390  5070922 1390  5070893 1390  5070864 1390  5070832 1388  5070797 1390  
335028 5070780 1388  5070746 1388  5070721 1390  5070699 1388  5070679 1388  5070654 1390  
335029 5070641 1388  5070622 1388  5070616 1390  5070597 1390  5070597 1390  5070592 1390  
335030 5070583 1390  5070583 1390  5070591 1392  5070595 1392  5070605 1392  5070619 1392  
335031 5070630 1390  5070648 1392  5070672 1392  5070681 1392  5070705 1392  5070729 1392  
335032 5070753 1392  5070777 1392  5070805 1392  5070828 1394  5070861 1394  5070890 1394  
335033 5070919 1394  5070952 1394  5070981 1394  5071014 1394  5071043 1394  5071071 1394  
335034 5071105 1394  5071138 1394  5071169 1392  5071184 1396  5071210 1394  5071239 1394  
335035 5071261 1396  5071272 1394  5071285 1396  5071304 1396  5071318 1396  5071328 1396  
335036 5071333 1396  5071342 1396  5071331 1398  5071331 1398  5071326 1398  5071328 1396  
335037 5071307 1398  5071293 1398  5071278 1398  5071264 1398  5071242 1396  5071216 1398  
335038 5071193 1398  5071169 1398  5071140 1398  5071113 1396  5071083 1398  5071049 1398  
335039 5071025 1398  5070982 1398  5070957 1400  5070927 1396  5070892 1398  5070861 1400  
335040 5070836 1396  5070810 1398  5070777 1398  5070747 1400  5070725 1398  5070701 1398  
335041 5070677 1398  5070667 1398  5070650 1396  5070635 1396  5070616 1396  5070610 1398  
335042 5070602 1396  5070592 1396  5070592 1396  5070592 1396  5070592 1396  5070602 1396  
335043 5070611 1396  5070616 1396  5070637 1394  5070651 1394  5070670 1394  5070681 1392  
335044 5070707 1390  5070731 1390  5070756 1388  5070780 1388  5070808 1388  5070832 1388  
335045 5070866 1388  5070895 1388  5070923 1388  5070957 1388  5070985 1388  5071019 1388  
335046 5071047 1388  5071077 1387  5071109 1388  5071135 1387  5071159 1387  5071188 1387  
335047 5071210 1388  5071235 1387  5071261 1385  5071275 1385  5071286 1388  5071293 1387  
335048 5071302 1387  5071311 1387  5071312 1387  5071313 1385  5071313 1385  5071305 1383  
335049 5071296 1383  5071289 1385  5071276 1383  5071262 1383  5071246 1385  5071219 1383  
335050 5071194 1385  5071175 1385  5071150 1385  5071124 1383  5071090 1383  5071060 1385  
335051 5071028 1383  5070993 1385  5070968 1387  5070936 1385  5070901 1387  5070867 1387  
335052 5070835 1385  5070802 1385  5070778 1385  5070745 1385  5070711 1385  5070686 1387  
335053 5070667 1387  5070643 1387  5070619 1387  5070594 1388  5070581 1387  5070567 1387  
335054 5070557 1387  5070552 1387  5070541 1388  5070541 1388  5070541 1388  5070541 1388  
335055 5070542 1387  5070551 1388  5070565 1388  5070574 1388  5070586 1387  5070600 1387  
335056 5070618 1388  5070643 1387  5070667 1387  5070681 1387  5070700 1387  5070735 1385  
335057 5070758 1387  5070786 1387  5070821 1385  5070850 1385  5070887 1387  5070920 1387  
335058 5070948 1387  5070977 1387  5071011 1387  5071049 1387  5071077 1387  5071101 1387  
335059 5071125 1387  5071159 1387  5071178 1387  5071211 1387  5071235 1387  5071248 1388  
335060 5071269 1387  5071278 1387  5071288 1387  5071293 1387  5071304 1385  5071313 1385  
335061 5071304 1385  5071302 1387  5071294 1385  5071288 1387  5071275 1385  5071270 1385  
335062 5071251 1385  5071226 1387  5071213 1385  5071178 1387  5071159 1387  5071136 1385  
335063 5071112 1385  5071079 1385  5071050 1385  5071025 1387  5070992 1387  5070968 1387  
335064 5070933 1388  5070899 1388  5070871 1388  5070847 1388  5070820 1387  5070796 1387  
335065 5070777 1387  5070746 1388  5070719 1387  5070700 1387  5070681 1387  5070667 1387  
335066 5070651 1388  5070643 1387  5070632 1388  5070624 1387  5070618 1388  5070619 1387  
335067 5070619 1387  5070618 1388  5070622 1388  5070622 1388  5070641 1388  5070656 1388  
335068 5070675 1388  5070686 1387  5070700 1387  5070724 1387  5070743 1387  5070767 1387  
335069 5070796 1387  5070820 1387  5070843 1387  5070872 1387  5070899 1388  5070934 1387  
335070 5070968 1387  5070992 1387  5071025 1387  5071059 1387  5071087 1387  5071112 1385  
335071 5071144 1387  5071168 1387  5071187 1387  5071216 1387  5071235 1387  5071259 1387  
335072 5071273 1387  5071286 1388  5071300 1388  5071311 1387  5071315 1388  5071315 1388  
335073 5071325 1388  5071315 1388  5071315 1388  5071310 1388  5071291 1388  5071286 1388  
335074 5071273 1387  5071249 1387  5071226 1387  5071202 1387  5071176 1388  5071149 1387  
335075 5071121 1387  5071087 1387  5071059 1387  5071025 1387  5070992 1387  5070968 1387  
335076 5070925 1387  5070896 1387  5070866 1388  5070836 1385  5070796 1387  5070767 1387  
335077 5070734 1387  5070699 1388  5070676 1387  5070653 1387  5070622 1388  5070598 1388  
335078 5070581 1387  5070565 1388  5070552 1387  5070541 1388  5070522 1388  5070517 1388  
335079 5070517 1388  5070517 1388  5070517 1388  5070517 1388  5070522 1388  5070541 1388  
335080 5070551 1388  5070565 1388  5070579 1388  5070598 1388  5070616 1390  5070640 1390  
335081 5070664 1390  5070685 1388  5070708 1388  5070740 1390  5070775 1388  5070799 1388  
335082 5070821 1390  5070864 1390  5070893 1390  5070923 1388  5070957 1388  5070985 1388  
335083 5071017 1390  5071046 1390  5071074 1390  5071098 1390  5071132 1390  5071156 1390  
335084 5071175 1390  5071188 1392  5071213 1390  5071232 1390  5071248 1388  5071258 1388  
335085 5071272 1388  5071272 1388  5071276 1388  5071277 1388  5071278 1387  5071273 1387  
335086 5071267 1388  5071259 1387  5071249 1387  5071235 1387  5071216 1387  5071202 1387  
335087 5071179 1385  5071159 1387  5071135 1387  5071111 1387  5071087 1387  5071059 1387  
335088 5071035 1387  5071000 1388  5070976 1388  5070948 1387  5070923 1388  5070895 1388  
335089 5070871 1388  5070845 1390  5070817 1390  5070794 1388  5070775 1388  5070746 1388  
335090 5070730 1390  5070707 1390  5070692 1390  5070683 1390  5070673 1390  5070664 1390  
335091 5070654 1390  5070654 1390  5070650 1390  5070649 1390  5070651 1388  5070654 1390  
335092 5070664 1390  5070673 1390  5070681 1392  5070692 1390  5070716 1390  5070729 1392  
335093 5070753 1392  5070772 1392  5070791 1392  5070815 1392  5070844 1392  5070867 1392  
335094 5070896 1392  5070920 1392  5070954 1392  5070984 1390  5071015 1392  5071039 1392  
335095 5071068 1392  5071097 1392  5071121 1392  5071154 1392  5071173 1392  5071196 1394  
335096 5071221 1392  5071240 1392  5071264 1392  5071269 1392  5071283 1392  5071297 1392  
335097 5071307 1392  5071312 1392  5071313 1390  5071313 1390  5071313 1390  5071307 1392  
335098 5071299 1390  5071288 1392  5071276 1388  5071265 1390  5071246 1390  5071234 1388  
335099 5071210 1388  5071184 1390  5071167 1388  5071141 1390  5071108 1390  5071076 1388  
335100 5071046 1390  5071017 1390  5070985 1388  5070955 1390  5070922 1390  5070893 1390  
335101 5070866 1388  5070831 1390  5070794 1388  5070775 1388  5070742 1388  5070708 1388  
335102 5070679 1388  5070656 1388  5070632 1388  5070616 1390  5070598 1388  5070579 1388  
335103 5070574 1388  5070555 1388  5070556 1388  5070551 1388  5070541 1388  5070539 1390  
335104 5070551 1388  5070551 1388  5070563 1390  5070574 1388  5070578 1390  5070594 1388  
335105 5070606 1390  5070621 1390  5070641 1388  5070664 1390  5070678 1390  5070707 1390  
335106 5070731 1390  5070764 1390  5070785 1389  5070817 1390  5070842 1388  5070869 1390  
335107 5070899 1388  5070933 1388  5070957 1388  5070985 1388  5071017 1390  5071041 1390  
335108 5071070 1390  5071090 1388  5071117 1390  5071143 1388  5071157 1388  5071176 1388  
335109 5071189 1390  5071199 1390  5071213 1390  5071224 1388  5071234 1389  5071243 1388  
335110 5071248 1388  5071248 1388  5071245 1387  5071234 1388  5071224 1388  5071214 1388  
335111 5071210 1388  5071191 1388  5071176 1388  5071167 1388  5071148 1388  5071124 1388  
335112 5071098 1390  5071086 1388  5071065 1390  5071043 1388  5071017 1390  5070990 1388  
335113 5070969 1390  5070942 1388  5070919 1388  5070893 1390  5070869 1390  5070847 1388  
335114 5070821 1390  5070807 1390  5070783 1390  5070775 1388  5070745 1390  5070729 1392  
335115 5070721 1390  5070715 1392  5070707 1390  5070696 1392  5070691 1392  5070692 1390  
335116 5070691 1392  5070691 1392  5070696 1392  5070705 1392  5070716 1390  5070720 1392  
335117 5070739 1392  5070753 1392  5070774 1390  5070791 1392  5070805 1392  5070829 1392  
335118 5070844 1392  5070866 1394  5070891 1392  5070917 1390  5070944 1392  5070968 1392  
335119 5070987 1392  5071020 1392  5071044 1392  5071073 1392  5071095 1394  5071121 1392  
335120 5071145 1392  5071168 1392  5071188 1392  5071207 1392  5071231 1392  5071245 1392  
335121 5071264 1392  5071267 1394  5071284 1390  5071288 1392  5071288 1392  5071297 1392  
335122 5071297 1392  5071288 1392  5071290 1390  5071283 1392  5071270 1390  5071266 1390  
335123 5071246 1390  5071232 1390  5071213 1390  5071191 1388  5071170 1385  5071138 1383  
335124 5071117 1379  5071087 1375  5071063 1370  5071034 1370  5071004 1366  5070976 1364  
335125 5070948 1358  5070919 1358  5070892 1357  5070857 1358  5070825 1357  5070801 1357  
335126 5070772 1356  5070744 1356  5070710 1357  5070691 1357  5070669 1355  5070645 1355  
335127 5070621 1355  5070607 1355  5070593 1355  5070578 1355  5070569 1355  5070559 1355  
335128 5070550 1355  5070547 1353  5070545 1355  5070545 1355  5070545 1355  5070550 1355  
335129 5070561 1353  5070578 1355  5070583 1355  5070602 1355  5070611 1355  5070626 1355  
335130 5070645 1355  5070659 1355  5070683 1355  5070707 1355  5070726 1355  5070750 1355  
335131 5070782 1356  5070806 1356  5070827 1355  5070849 1356  5070882 1356  5070906 1356  
335132 5070927 1355  5070959 1356  5070983 1357  5071002 1356  5071026 1356  5071049 1357  
335133 5071069 1356  5071093 1356  5071102 1356  5071116 1356  5071135 1356  5071146 1355  
335134 5071150 1356  5071161 1355  5071169 1356  5071169 1356  5071170 1355  5071170 1355  
335135 5071159 1356  5071161 1355  5071151 1355  5071145 1356  5071127 1355  5071118 1355  
335136 5071104 1355  5071094 1355  5071075 1355  5071053 1353  5071038 1353  5071018 1355  
335137 5071000 1353  5070986 1353  5070962 1353  5070938 1353  5070925 1351  5070900 1353  
335138 5070886 1353  5070863 1351  5070838 1353  5070823 1353  5070806 1351  5070787 1351  
335139 5070772 1351  5070753 1351  5070739 1351  5070729 1351  5070725 1351  5070715 1351  
335140 5070710 1351  5070710 1351  5070710 1351  5070710 1351  5070710 1351  5070710 1351  
335141 5070715 1351  5070728 1347  5070732 1347  5070742 1347  5070756 1347  5070775 1347  
335142 5070790 1347  5070809 1347  5070820 1345  5070833 1347  5070858 1345  5070876 1347  
335143 5070904 1347  5070919 1347  5070944 1345  5070968 1345  5070990 1347  5071009 1347  
335144 5071035 1345  5071057 1347  5071078 1345  5071106 1345  5071121 1345  5071135 1345  
335145 5071154 1345  5071178 1345  5071193 1345  5071202 1345  5071207 1345  5071221 1345  
335146 5071224 1347  5071226 1345  5071226 1345  5071234 1347  5071226 1345  5071224 1347  
335147 5071220 1347  5071211 1345  5071205 1347  5071202 1345  5071183 1345  5071168 1345  
335148 5071143 1347  5071121 1345  5071106 1345  5071082 1345  5071057 1347  5071025 1345  
335149 5071006 1345  5070981 1347  5070952 1347  5070930 1345  5070906 1345  5070877 1345  
335150 5070853 1345  5070818 1347  5070799 1347  5070775 1347  5070742 1347  5070718 1347  
335151 5070699 1347  5070675 1347  5070656 1347  5070632 1347  5070618 1347  5070610 1345  
335152 5070589 1347  5070584 1347  5070575 1347  5070567 1345  5070551 1347  5070553 1345  
335153 5070551 1347  5070551 1347  5070556 1347  5070556 1347  5070565 1347  5070571 1351  
335154 5070586 1351  5070596 1351  5070608 1353  5070613 1353  5070627 1353  5070647 1353  
335155 5070670 1353  5070685 1353  5070709 1353  5070723 1353  5070745 1355  5070771 1353  
335156 5070793 1355  5070812 1355  5070836 1355  5070860 1355  5070884 1355  5070908 1355  
335157 5070925 1357  5070951 1355  5070975 1355  5070994 1355  5071003 1355  5071018 1355  
335158 5071037 1355  5071046 1355  5071060 1355  5071069 1356  5071075 1355  5071083 1356  
335159 5071085 1355  5071085 1355  5071085 1355  5071085 1355  5071083 1356  5071075 1355  
335160 5071070 1355  5071061 1355  5071051 1355  5071046 1355  5071027 1355  5071018 1355  
335161 5071003 1355  5070994 1355  5070975 1355  5070970 1355  5070947 1353  5070927 1355  
335162 5070914 1353  5070898 1355  5070885 1353  5070860 1355  5070845 1355  5070830 1351  
335163 5070814 1353  5070809 1353  5070796 1351  5070775 1353  5070761 1353  5070752 1353  
335164 5070747 1353  5070737 1353  5070729 1351  5070725 1351  5070725 1351  5070714 1353  
335165 5070725 1351  5070725 1351  5070725 1351  5070725 1351  5070728 1353  5070739 1351  
335166 5070749 1351  5070763 1351  5070772 1351  5070787 1351  5070806 1351  5070810 1351  
335167 5070830 1351  5070849 1351  5070863 1351  5070877 1351  5070901 1351  5070915 1351  
335168 5070939 1351  5070954 1351  5070978 1351  5071002 1351  5071016 1351  5071040 1351  
335169 5071053 1353  5071073 1351  5071088 1351  5071105 1353  5071113 1355  5071127 1355  
335170 5071138 1353  5071153 1353  5071162 1353  5071173 1351  5071172 1353  5071173 1351  
335171 5071178 1351  5071178 1351  5071173 1351  5071173 1351  5071164 1351  5071155 1351  
335172 5071149 1351  5071129 1353  5071120 1353  5071105 1353  5071097 1351  5071072 1353  
335173 5071054 1351  5071029 1353  5071016 1351  5070997 1351  5070973 1351  5070949 1351  
335174 5070925 1351  5070901 1351  5070877 1351  5070847 1353  5070830 1351  5070810 1351  
335175 5070790 1347  5070766 1347  5070742 1347  5070720 1345  5070708 1347  5070685 1347  
335176 5070662 1351  5070648 1351  5070629 1351  5070618 1347  5070613 1347  5070608 1347  
335177 5070600 1345  5070591 1345  5070591 1345  5070586 1345  5070586 1345  5070586 1345  
335178 5070592 1343  5070591 1345  5070600 1345  5070610 1345  5070611 1343  5070615 1345  
335179 5070629 1345  5070634 1345  5070651 1347  5070666 1347  5070686 1345  5070700 1345  
335180 5070715 1345  5070729 1345  5070743 1345  5070758 1345  5070782 1345  5070802 1343  
335181 5070820 1345  5070834 1345  5070857 1347  5070876 1347  5070900 1347  5070915 1345  
335182 5070930 1345  5070935 1345  5070954 1345  5070968 1345  5070981 1347  5070992 1345  
335183 5071001 1345  5071008 1343  5071012 1343  5071022 1343  5071022 1343  5071021 1345  
335184 5071025 1345  5071025 1345  5071027 1343  5071025 1345  5071021 1345  5071021 1345  
335185 5071011 1345  5071008 1343  5071001 1345  5070992 1345  5070984 1343  5070977 1345  
335186 5070969 1343  5070954 1345  5070944 1345  5070930 1345  5070915 1345  5070906 1345  
335187 5070892 1345  5070877 1345  5070868 1345  5070853 1345  5070844 1345  5070829 1345  
335188 5070820 1345  5070810 1345  5070802 1343  5070801 1345  5070793 1343  5070782 1345  
335189 5070783 1343  5070777 1345  5070777 1345  5070777 1345  5070777 1345  5070777 1345  
335190 5070777 1345  5070777 1345  5070782 1345  5070791 1345  5070801 1345  5070810 1345  
335191 5070815 1345  5070829 1345  5070833 1347  5070853 1345  5070858 1345  5070879 1343  
335192 5070892 1345  5070906 1345  5070920 1345  5070934 1345  5070954 1345  5070968 1345  
335193 5070984 1343  5071001 1345  5071011 1345  5071027 1343  5071044 1345  5071059 1345  
335194 5071079 1343  5071084 1343  5071092 1345  5071108 1343  5071113 1343  5071121 1345  
335195 5071127 1343  5071137 1343  5071137 1343  5071137 1343  5071146 1343  5071148 1341  
335196 5071137 1343  5071137 1343  5071127 1343  5071122 1343  5071113 1343  5071108 1343  
335197 5071094 1343  5071082 1345  5071070 1343  5071056 1343  5071036 1343  5071022 1343  
335198 5071008 1343  5070993 1343  5070979 1343  5070955 1343  5070936 1343  5070917 1343  
335199 5070902 1343  5070879 1343  5070860 1343  5070837 1341  5070823 1341  5070813 1341  
335200 5070783 1343  5070769 1343  5070746 1342  5070731 1343  5070717 1343  5070713 1341  
335201 5070693 1343  5070688 1343  5070668 1343  5070659 1343  5070656 1341  5070646 1341  
335202 5070637 1341  5070637 1341  5070633 1340  5070632 1341  5070630 1343  5070635 1343  
335203 5070630 1343  5070635 1343  5070635 1343  5070646 1341  5070654 1343  5070659 1343  
335204 5070670 1341  5070680 1341  5070694 1341  5070702 1343  5070717 1343  5070731 1343  
335205 5070746 1341  5070761 1341  5070780 1341  5070793 1343  5070813 1341  5070823 1341  
335206 5070837 1341  5070857 1341  5070861 1341  5070879 1343  5070894 1341  5070909 1341  
335207 5070919 1341  5070934 1340  5070938 1341  5070955 1343  5070962 1341  5070971 1341  
335208 5070980 1341  5070986 1341  5070993 1343  5071004 1341  5071004 1341  5071004 1341  
335209 5071008 1343  5071009 1341  5071009 1341  5071009 1341  5071004 1341  5071004 1341  
335210 5070995 1341  5070995 1341  5070986 1341  5070987 1340  5070982 1340  5070972 1340  
335211 5070963 1340  5070947 1341  5070939 1340  5070933 1341  5070923 1341  5070910 1340  
335212 5070906 1340  5070895 1341  5070887 1340  5070872 1340  5070872 1340  5070858 1340  
335213 5070848 1340  5070839 1340  5070839 1340  5070834 1340  5070826 1338  5070826 1338  
335214 5070820 1340  5070820 1340  5070820 1340  5070820 1340  5070821 1338  5070820 1340  
335215 5070826 1338  5070826 1338  5070834 1340  5070835 1338  5070839 1340  5070848 1340  
335216 5070858 1340  5070864 1338  5070874 1338  5070887 1340  5070906 1340  5070912 1338  
335217 5070922 1338  5070934 1340  5070941 1338  5070958 1340  5070963 1340  5070982 1340  
335218 5070996 1340  5071012 1338  5071017 1338  5071025 1340  5071039 1340  5071049 1340  
335219 5071065 1338  5071074 1338  5071084 1338  5071089 1338  5071098 1338  5071108 1338  
335220 5071113 1338  5071112 1338  5071112 1338  5071116 1340  5071117 1338  5071117 1338  
335221 5071112 1338  5071112 1338  5071108 1338  5071098 1338  5071089 1338  5071084 1338  
335222 5071074 1338  5071065 1338  5071060 1338  5071041 1338  5071027 1338  5071012 1338  
335223 5070998 1338  5070984 1338  5070965 1338  5070960 1338  5070936 1338  5070920 1340  
335224 5070907 1338  5070887 1340  5070874 1338  5070850 1338  5070836 1338  5070821 1338  
335225 5070807 1338  5070788 1338  5070772 1340  5070764 1338  5070750 1338  5070735 1338  
335226 5070726 1338  5070716 1338  5070707 1338  5070695 1340  5070692 1338  5070683 1338  
335227 5070683 1338  5070673 1338  5070671 1340  5070671 1340  5070671 1340  5070673 1338  
335228 5070671 1340  5070673 1338  5070681 1340  5070683 1338  5070691 1340  5070692 1338  
335229 5070695 1340  5070705 1340  5070719 1340  5070724 1340  5070735 1338  5070750 1338  
335230 5070758 1340  5070762 1340  5070783 1338  5070797 1338  5070807 1338  5070820 1340  
335231 5070834 1340  5070839 1340  5070858 1340  5070864 1338  5070883 1338  5070888 1338  
335232 5070898 1338  5070912 1338  5070926 1338  5070936 1338  5070941 1338  5070948 1340  
335233 5070960 1338  5070963 1340  5070974 1338  5070984 1338  5070984 1338  5070988 1338  
335234 5070989 1338  5070989 1338  5070989 1338  5070989 1338  5070990 1336  5070989 1338  
335235 5070989 1338  5070990 1336  5070984 1338  5070974 1338  5070974 1338  5070964 1338  
335236 5070960 1338  5070961 1336  5070950 1338  5070941 1338  5070936 1338  5070926 1338  
335237 5070922 1338  5070912 1338  5070909 1336  5070907 1338  5070898 1338  5070890 1336  
335238 5070883 1338  5070884 1338  5070874 1338  5070874 1338  5070866 1336  5070861 1336  
335239 5070861 1336  5070859 1338  5070850 1338  5070852 1336  5070850 1338  5070850 1338  
335240 5070852 1336  5070861 1336  5070859 1338  5070858 1340  5070864 1338  5070864 1338  
335241 5070874 1338  5070884 1338  5070888 1338  5070896 1340  5070907 1338  5070912 1338  
335242 5070928 1336  5070936 1338  5070941 1338  5070952 1336  5070964 1338  5070976 1336  
335243 5070989 1338  5070998 1338  5071012 1338  5071017 1338  5071028 1336  5071031 1338  
335244 5071041 1338  5071050 1338  5071066 1336  5071065 1338  5071074 1338  5071089 1332  
335245 5071086 1336  5071090 1336  5071100 1336  5071100 1336  5071100 1336  5071100 1336  
335246 5071100 1336  5071100 1336  5071100 1336  5071090 1336  5071084 1338  5071086 1336  
335247 5071076 1336  5071066 1336  5071060 1338  5071052 1336  5071033 1336  5071027 1338  
335248 5071012 1338  5071007 1338  5070988 1338  5070975 1336  5070960 1338  5070950 1338  
335249 5070936 1338  5070923 1336  5070909 1336  5070890 1336  5070875 1336  5070859 1338  
335250 5070842 1336  5070837 1336  5070823 1336  5070808 1336  5070789 1336  5070785 1336  
335251 5070764 1338  5070759 1338  5070750 1338  5070740 1338  5070735 1338  5070723 1336  
335252 5070716 1338  5070716 1338  5070708 1336  5070697 1338  5070699 1336  5070697 1338  
335253 5070692 1338  5070692 1338  5070692 1338  5070699 1336  5070697 1338  5070699 1336  
335254 5070708 1336  5070716 1338  5070721 1338  5070726 1338  5070735 1338  5070750 1338  
335255 5070761 1336  5070764 1338  5070773 1338  5070790 1336  5070797 1338  5070818 1336  
335256 5070823 1336  5070837 1336  5070852 1336  5070864 1338  5070875 1336  5070890 1336  
335257 5070899 1336  5070912 1338  5070928 1336  5070936 1338  5070950 1338  5070960 1338  
335258 5070966 1336  5070975 1336  5070984 1338  5070990 1336  5070999 1336  5071009 1336  
335259 5071014 1336  5071014 1336  5071017 1338  5071019 1336  5071019 1336  5071028 1336  
335260 5071031 1332  5071028 1336  5071028 1336  5071019 1336  5071019 1336  5071019 1336  
335261 5071014 1336  5071009 1336  5070998 1338  5070990 1336  5070990 1336  5070985 1336  
335262 5070969 1332  5070964 1332  5070952 1336  5070942 1336  5070937 1336  5070928 1336  
335263 5070923 1336  5070913 1336  5070909 1336  5070902 1332  5070890 1336  5070890 1336  
335264 5070885 1336  5070875 1336  5070875 1336  5070866 1336  5070861 1336  5070861 1336  
335265 5070861 1336  5070859 1338  5070859 1338  5070861 1336  5070864 1338  5070864 1338  
335266 5070874 1338  5070878 1332  5070885 1336  5070890 1336  5070899 1336  5070909 1336  
335267 5070913 1336  5070923 1336  5070928 1336  5070942 1336  5070952 1336  5070964 1332  
335268 5070975 1336  5070985 1336  5070999 1336  5071009 1336  5071014 1336  5071028 1336  
335269 5071033 1336  5071052 1336  5071065 1332  5071069 1332  5071079 1332  5071089 1332  
335270 5071093 1332  5071103 1332  5071109 1336  5071117 1332  5071117 1332  5071117 1332  
335271 5071119 1336  5071117 1332  5071117 1332  5071117 1332  5071117 1332  5071112 1332  
335272 5071112 1332  5071103 1332  5071093 1332  5071089 1332  5071079 1332  5071069 1332  
335273 5071055 1332  5071036 1332  5071031 1332  5071017 1332  5071003 1332  5070988 1332  
335274 5070969 1332  5070955 1332  5070940 1332  5070926 1332  5070909 1336  5070893 1332  
335275 5070875 1336  5070864 1332  5070845 1332  5070831 1332  5070821 1332  5070799 1336  
335276 5070785 1336  5070768 1332  5070761 1336  5070741 1336  5070735 1338  5070727 1336  
335277 5070718 1336  5070708 1336  5070702 1332  5070694 1336  5070694 1336  5070684 1336  
335278 5070687 1332  5070687 1332  5070684 1336  5070684 1336  5070687 1332  5070684 1336  
335279 5070697 1332  5070702 1332  5070708 1336  5070721 1332  5070723 1336  5070727 1336  
335280 5070741 1336  5070751 1336  5070768 1332  5070785 1336  5070789 1336  5070808 1336  
335281 5070823 1336  5070837 1336  5070852 1336  5070866 1336  5070885 1336  5070899 1336  
335282 5070913 1336  5070928 1336  5070945 1332  5070964 1332  5070966 1336  5070985 1336  
335283 5070993 1332  5071009 1336  5071014 1336  5071019 1336  5071028 1336  5071036 1332  
335284 5071042 1336  5071052 1336  5071055 1332  5071065 1332  5071062 1336  5071062 1336  
335285 5071065 1332  5071062 1336  5071055 1332  5071052 1336  5071042 1336  5071042 1336  
335286 5071036 1332  5071031 1332  5071022 1332  5071017 1332  5071003 1332  5070990 1336  
335287 5070985 1336  5070966 1336  5070964 1332  5070945 1332  5070940 1332  5070931 1332  
335288 5070913 1336  5070909 1336  5070893 1332  5070888 1332  5070875 1336  5070864 1332  
335289 5070855 1332  5070845 1332  5070840 1332  5070830 1332  5070826 1332  5070826 1332  
335290 5070821 1332  5070821 1332  5070821 1332  5070818 1336  5070821 1332  5070821 1332  
335291 5070826 1332  5070831 1332  5070840 1332  5070845 1332  5070855 1332  5070864 1332  
335292 5070866 1336  5070888 1332  5070893 1332  5070912 1332  5070923 1336  5070931 1332  
335293 5070945 1332  5070961 1336  5070969 1332  5070988 1332  5071003 1332  5071017 1332  
335294 5071031 1332  5071045 1332  5071065 1332  5071069 1332  5071089 1332  5071093 1332  
335295 5071112 1332  5071119 1330  5071122 1332  5071131 1332  5071136 1332  5071146 1332  
335296 5071155 1332  5071155 1332  5071155 1332  5071155 1332  5071157 1330  5071155 1332  
335297 5071146 1332  5071146 1332  5071136 1332  5071132 1332  5071117 1332  5071114 1330  
335298 5071093 1332  5071090 1330  5071071 1330  5071055 1332  5071036 1332  5071017 1332  
335299 5071003 1332  5070988 1332  5070966 1330  5070945 1332  5070928 1330  5070913 1330  
335300 5070890 1330  5070864 1332  5070845 1332  5070831 1332  5070813 1330  5070792 1332  
335301 5070778 1332  5070764 1332  5070744 1332  5070730 1332  5070721 1332  5070711 1332  
335302 5070698 1330  5070689 1330  5070678 1332  5070668 1332  5070670 1330  5070663 1332  
335303 5070663 1332  5070663 1332  5070663 1332  5070663 1332  5070668 1332  5070678 1332  
335304 5070687 1332  5070687 1332  5070702 1332  5070711 1332  5070726 1332  5070741 1330  
335305 5070744 1332  5070768 1332  5070788 1332  5070802 1332  5070821 1332  5070840 1332  
335306 5070855 1332  5070869 1332  5070893 1332  5070912 1332  5070932 1330  5070947 1330  
335307 5070971 1330  5070990 1330  5071003 1332  5071019 1330  5071031 1332  5071045 1332  
335308 5071066 1330  5071071 1330  5071090 1330  5071093 1332  5071104 1330  5071114 1330  
335309 5071119 1330  5071122 1332  5071122 1332  5071123 1330  5071123 1330  5071123 1330  
335310 5071122 1332  5071117 1332  5071114 1330  5071104 1330  5071096 1328  5071090 1330  
335311 5071080 1330  5071071 1330  5071057 1330  5071036 1332  5071031 1332  5071019 1330  
335312 5071004 1330  5070988 1332  5070966 1330  5070945 1332  5070931 1332  5070917 1332  
335313 5070902 1332  5070888 1332  5070870 1330  5070855 1332  5070841 1330  5070827 1330  
335314 5070813 1330  5070803 1330  5070789 1330  5070789 1330  5070778 1332  5070770 1330  
335315 5070770 1330  5070764 1332  5070770 1330  5070771 1328  5070770 1330  5070779 1330  
335316 5070778 1332  5070789 1330  5070794 1330  5070813 1330  5070826 1332  5070830 1332  
335317 5070845 1332  5070865 1330  5070880 1330  5070893 1332  5070913 1330  5070928 1330  
335318 5070946 1330  5070964 1332  5070988 1332  5071003 1332  5071023 1330  5071036 1332  
335319 5071066 1330  5071080 1330  5071095 1330  5071119 1330  5071133 1330  5071146 1332  
335320 5071166 1330  5071171 1330  5071189 1332  5071194 1332  5071205 1330  5071214 1330  
335321 5071219 1330  5071219 1330  5071219 1330  5071217 1332  5071219 1330  5071219 1330  
335322 5071214 1330  5071205 1330  5071195 1330  5071181 1330  5071170 1332  5071157 1330  
335323 5071138 1330  5071122 1332  5071104 1330  5071090 1330  5071066 1330  5071037 1330  
335324 5071018 1330  5070993 1332  5070969 1332  5070946 1330  5070928 1330  5070904 1330  
335325 5070880 1330  5070856 1330  5070834 1328  5070813 1330  5070788 1332  5070765 1330  
335326 5070744 1332  5070725 1332  5070713 1330  5070697 1332  5070679 1330  5070670 1330  
335327 5070654 1332  5070646 1330  5070639 1332  5070630 1332  5070632 1330  5070630 1332  
335328 5070630 1332  5070630 1332  5070639 1332  5070644 1332  5070655 1330  5070663 1332  
335329 5070679 1330  5070698 1330  5070711 1332  5070725 1332  5070740 1332  5070756 1330  
335330 5070778 1332  5070792 1332  5070823 1330  5070840 1332  5070864 1332  5070889 1330  
335331 5070913 1330  5070932 1330  5070945 1332  5070980 1330  5071004 1330  5071023 1330  
335332 5071037 1330  5071066 1330  5071080 1330  5071104 1330  5071124 1330  5071138 1330  
335333 5071157 1330  5071165 1332  5071171 1330  5071179 1332  5071189 1332  5071194 1332  
335334 5071195 1330  5071205 1330  5071203 1332  5071194 1332  5071194 1332  5071190 1330  
335335 5071181 1330  5071171 1330  5071166 1330  5071146 1332  5071131 1332  5071117 1332  
335336 5071104 1330  5071090 1330  5071066 1330  5071037 1330  5071017 1332  5071004 1330  
335337 5070980 1330  5070947 1330  5070928 1330  5070902 1332  5070880 1330  5070856 1330  
335338 5070832 1330  5070811 1332  5070792 1332  5070768 1332  5070765 1330  5070744 1332  
335339 5070730 1332  5070721 1332  5070712 1330  5070701 1332  5070697 1332  5070689 1330  
335340 5070687 1332  5070678 1332  5070678 1332  5070687 1332  5070697 1332  5070702 1332  
335341 5070711 1332  5070726 1332  5070740 1332  5070744 1332  5070768 1332  5070789 1330  
335342 5070811 1332  5070830 1332  5070855 1332  5070878 1332  5070893 1332  5070918 1330  
335343 5070945 1332  5070969 1332  5071002 1332  5071022 1332  5071045 1332  5071079 1332  
335344 5071103 1332  5071122 1332  5071146 1332  5071170 1332  5071189 1332  5071203 1332  
335345 5071217 1332  5071232 1332  5071248 1330  5071256 1332  5071261 1332  5071270 1332  
335346 5071270 1332  5071271 1330  5071270 1332  5071270 1332  5071260 1332  5071256 1332  
335347 5071238 1330  5071233 1330  5071217 1332  5071203 1332  5071181 1330  5071165 1332  
335348 5071138 1330  5071119 1330  5071095 1330  5071069 1332  5071037 1330  5071018 1330  
335349 5070988 1332  5070966 1330  5070931 1332  5070904 1330  5070878 1332  5070845 1332  
335350 5070826 1332  5070802 1332  5070768 1332  5070744 1332  5070725 1332  5070701 1332  
335351 5070687 1332  5070668 1332  5070654 1332  5070639 1332  5070625 1332  5070621 1332  
335352 5070611 1332  5070601 1332  5070597 1332  5070596 1332  5070596 1332  5070596 1332  
335353 5070601 1332  5070611 1332  5070621 1332  5070630 1332  5070644 1332  5070663 1332  
335354 5070687 1332  5070702 1332  5070726 1332  5070744 1332  5070765 1336  5070792 1332  
335355 5070821 1332  5070842 1336  5070869 1332  5070890 1336  5070926 1332  5070955 1332  
335356 5070988 1332  5071012 1332  5071036 1332  5071065 1332  5071086 1336  5071112 1332  
335357 5071131 1332  5071155 1332  5071179 1332  5071194 1332  5071212 1332  5071222 1332  
335358 5071237 1332  5071246 1332  5071257 1330  5071256 1332  5071260 1332  5071260 1332  
335359 5071260 1332  5071257 1330  5071256 1332  5071246 1332  5071233 1330  5071217 1332  
335360 5071214 1330  5071190 1330  5071170 1332  5071147 1330  5071124 1330  5071104 1330  
335361 5071071 1330  5071045 1332  5071017 1332  5070988 1332  5070955 1332  5070932 1330  
335362 5070902 1332  5070870 1330  5070845 1332  5070823 1330  5070792 1332  5070764 1332  
335363 5070740 1332  5070721 1332  5070697 1332  5070668 1332  5070654 1332  5070639 1332  
335364 5070630 1332  5070620 1332  5070611 1332  5070598 1336  5070601 1332  5070601 1332  
335365 5070598 1336  5070608 1336  5070617 1336  5070622 1336  5070636 1336  5070649 1338  
335366 5070664 1338  5070683 1338  5070706 1338  5070726 1338  5070750 1338  5070773 1338  
335367 5070807 1338  5070837 1336  5070866 1336  5070888 1338  5070923 1336  5070950 1338  
335368 5070984 1338  5071014 1336  5071041 1338  5071074 1338  5071108 1338  5071132 1338  
335369 5071160 1338  5071191 1336  5071214 1336  5071232 1338  5071256 1338  5071275 1338  
335370 5071289 1338  5071310 1336  5071318 1338  5071319 1336  5071328 1338  5071332 1338  
335371 5071332 1338  5071332 1338  5071329 1336  5071328 1338  5071315 1336  5071299 1338  
335372 5071291 1336  5071267 1336  5071252 1336  5071227 1338  5071209 1336  5071175 1338  
335373 5071152 1336  5071119 1336  5071089 1338  5071066 1336  5071031 1338  5071007 1338  
335374 5070964 1338  5070936 1338  5070907 1338  5070874 1338  5070840 1338  5070817 1338  
335375 5070783 1338  5070759 1338  5070726 1338  5070706 1338  5070683 1338  5070662 1340  
335376 5070638 1340  5070625 1338  5070619 1340  5070606 1338  5070605 1340  5070595 1340  
335377 5070595 1340  5070590 1340  5070595 1340  5070595 1340  5070605 1340  5070619 1340  
335378 5070622 1341  5070638 1340  5070662 1340  5070681 1340  5070703 1341  5070719 1340  
335379 5070738 1340  5070761 1341  5070794 1341  5070824 1340  5070848 1340  5070882 1340  
335380 5070909 1341  5070939 1340  5070972 1340  5071009 1341  5071039 1340  5071073 1340  
335381 5071105 1341  5071130 1340  5071157 1341  5071186 1341  5071210 1341  5071240 1340  
335382 5071253 1341  5071283 1340  5071297 1340  5071312 1340  5071325 1341  5071331 1340  
335383 5071340 1340  5071340 1340  5071340 1340  5071350 1340  5071340 1340  5071331 1340  
335384 5071328 1338  5071316 1340  5071307 1340  5071289 1338  5071264 1340  5071251 1338  
335385 5071216 1340  5071197 1340  5071164 1340  5071132 1338  5071108 1338  5071063 1340  
335386 5071031 1338  5070996 1340  5070963 1340  5070925 1340  5070887 1340  5070858 1340  
335387 5070826 1338  5070786 1340  5070759 1338  5070724 1340  5070696 1340  5070673 1338  
335388 5070638 1340  5070619 1340  5070595 1340  5070581 1340  5070557 1340  5070536 1341  
335389 5070533 1340  5070524 1340  5070519 1340  5070519 1340  5070519 1340  5070524 1340  
335390 5070532 1341  5070536 1341  5070557 1340  5070570 1341  5070594 1341  5070618 1341  
335391 5070637 1341  5070661 1341  5070694 1341  5070723 1341  5070758 1340  5070785 1341  
335392 5070820 1340  5070847 1341  5070885 1341  5070920 1340  5070958 1340  5070987 1340  
335393 5071025 1340  5071062 1341  5071095 1341  5071130 1340  5071164 1340  5071195 1341  
335394 5071224 1341  5071248 1341  5071283 1340  5071307 1340  5071316 1340  5071339 1341  
335395 5071348 1341  5071363 1341  5071374 1340  5071377 1341  5071378 1340  5071372 1341  
335396 5071374 1340  5071363 1341  5071355 1340  5071340 1340  5071326 1340  5071311 1340  
335397 5071288 1340  5071264 1340  5071240 1340  5071211 1340  5071188 1340  5071159 1340  
335398 5071114 1341  5071087 1340  5071059 1340  5071017 1338  5070987 1340  5070948 1340  
335399 5070920 1340  5070887 1340  5070848 1340  5070820 1340  5070786 1340  5070758 1340  
335400 5070724 1340  5070695 1340  5070672 1340  5070646 1341  5070632 1341  5070618 1341  
335401 5070605 1340  5070591 1340  5070581 1340  5070581 1340  5070570 1341  5070570 1341  
335402 5070579 1341  5070579 1341  5070589 1341  5070603 1341  5070616 1343  5070630 1343  
335403 5070644 1343  5070670 1341  5070689 1341  5070716 1343  5070735 1343  5070759 1343  
335404 5070794 1341  5070823 1341  5070856 1341  5070895 1341  5070923 1341  5070961 1341  
335405 5070995 1341  5071024 1341  5071055 1343  5071095 1341  5071125 1340  5071157 1341  
335406 5071184 1343  5071214 1341  5071237 1343  5071262 1341  5071286 1341  5071308 1343  
335407 5071324 1341  5071337 1343  5071353 1341  5071361 1343  5071371 1343  5071372 1341  
335408 5071372 1341  5071372 1341  5071363 1341  5071348 1341  5071340 1340  5071325 1341  
335409 5071305 1341  5071283 1340  5071255 1340  5071231 1340  5071207 1340  5071172 1341  
335410 5071129 1341  5071105 1341  5071063 1340  5071024 1341  5070987 1340  5070948 1340  
335411 5070909 1341  5070872 1340  5070832 1341  5070796 1340  5070756 1341  5070718 1341  
335412 5070681 1340  5070648 1340  5070613 1341  5070579 1341  5070555 1341  5070522 1341  
335413 5070503 1341  5070479 1341  5070465 1341  5070446 1341  5070436 1341  5070426 1341  
335414 5070425 1343  5070417 1341  5070415 1343  5070423 1345  5070428 1345  5070434 1343  
335415 5070454 1343  5070466 1345  5070490 1345  5070516 1343  5070535 1343  5070559 1343  
335416 5070591 1345  5070619 1345  5070654 1343  5070688 1343  5070721 1343  5070761 1341  
335417 5070804 1341  5070837 1341  5070869 1343  5070919 1341  5070955 1343  5070995 1341  
335418 5071028 1341  5071062 1341  5071103 1343  5071127 1343  5071160 1343  5071203 1343  
335419 5071223 1343  5071253 1341  5071270 1343  5071294 1343  5071308 1343  5071323 1343  
335420 5071337 1343  5071347 1343  5071348 1341  5071353 1341  5071347 1343  5071348 1341  
335421 5071337 1343  5071328 1343  5071315 1341  5071305 1341  5071281 1341  5071251 1343  
335422 5071224 1341  5071205 1341  5071179 1343  5071148 1341  5071114 1341  5071081 1341  
335423 5071047 1341  5071012 1343  5070979 1343  5070946 1343  5070909 1341  5070880 1341  
335424 5070837 1341  5070812 1343  5070778 1343  5070745 1343  5070716 1343  5070692 1343  
335425 5070669 1343  5070643 1345  5070621 1343  5070611 1343  5070592 1343  5070586 1345  
335426 5070576 1345  5070567 1345  5070567 1345  5070567 1345  5070568 1343  5070576 1345  
335427 5070577 1343  5070592 1343  5070610 1345  5070621 1343  5070644 1343  5070668 1343  
335428 5070694 1341  5070716 1343  5070745 1343  5070770 1341  5070802 1343  5070832 1341  
335429 5070871 1341  5070902 1343  5070933 1341  5070971 1341  5071003 1343  5071036 1343  
335430 5071070 1343  5071109 1341  5071138 1341  5071181 1341  5071210 1341  5071237 1343  
335431 5071261 1343  5071286 1341  5071310 1341  5071329 1341  5071346 1343  5071361 1343  
335432 5071377 1341  5071377 1341  5071395 1343  5071396 1341  5071386 1341  5071386 1341  
335433 5071377 1341  5071361 1343  5071353 1341  5071337 1343  5071313 1343  5071296 1341  
335434 5071272 1341  5071237 1343  5071208 1343  5071178 1345  5071137 1343  5071103 1343  
335435 5071070 1343  5071022 1343  5070982 1345  5070945 1343  5070902 1343  5070860 1343  
335436 5070820 1345  5070782 1345  5070735 1343  5070702 1343  5070657 1345  5070619 1345  
335437 5070586 1345  5070551 1347  5070518 1347  5070484 1347  5070460 1347  5070431 1347  
335438 5070412 1347  5070398 1347  5070385 1351  5070371 1351  5070361 1351  5070361 1351  
335439 5070357 1351  5070361 1351  5070369 1353  5070379 1353  5070393 1353  5070406 1355  
335440 5070425 1355  5070446 1353  5070478 1355  5070502 1355  5070526 1355  5070550 1355  
335441 5070592 1355  5070626 1355  5070667 1356  5070707 1355  5070745 1355  5070782 1356  
335442 5070820 1356  5070858 1356  5070906 1357  5070944 1356  5070982 1356  5071016 1356  
335443 5071058 1358  5071096 1358  5071135 1356  5071167 1358  5071191 1358  5071213 1360  
335444 5071239 1358  5071268 1358  5071292 1358  5071301 1358  5071314 1360  5071324 1360  
335445 5071333 1360  5071335 1358  5071336 1356  5071335 1358  5071327 1357  5071315 1358  
335446 5071311 1358  5071296 1358  5071282 1358  5071258 1358  5071234 1358  5071209 1360  
335447 5071190 1360  5071156 1360  5071123 1360  5071094 1360  5071066 1360  5071032 1360  
335448 5070999 1360  5070962 1364  5070929 1364  5070900 1364  5070865 1366  5070836 1366  
335449 5070803 1366  5070774 1366  5070749 1368  5070724 1370  5070696 1368  5070681 1370  
335450 5070654 1373  5070636 1372  5070622 1372  5070610 1373  5070606 1373  5070596 1373  
335451 5070595 1375  5070595 1375  5070595 1375  5070595 1375  5070606 1379  5070616 1379  
335452 5070630 1379  5070649 1379  5070671 1381  5070690 1381  5070714 1381  5070740 1379  
335453 5070772 1381  5070791 1381  5070824 1381  5070853 1381  5070891 1381  5070925 1381  
335454 5070953 1381  5070991 1381  5071030 1381  5071063 1381  5071092 1381  5071130 1381  
335455 5071163 1381  5071197 1381  5071221 1381  5071254 1381  5071283 1381  5071307 1381  
335456 5071329 1383  5071355 1381  5071373 1381  5071383 1381  5071393 1381  5071397 1381  
335457 5071407 1381  5071416 1381  5071416 1381  5071407 1381  5071396 1383  5071393 1381  
335458 5071377 1383  5071362 1383  5071345 1381  5071314 1383  5071291 1383  5071272 1383  
335459 5071238 1383  5071197 1381  5071173 1381  5071131 1379  5071093 1379  5071055 1379  
335460 5071017 1379  5070974 1379  5070934 1375  5070891 1375  5070843 1375  5070805 1375  
335461 5070757 1375  5070719 1375  5070687 1373  5070645 1371  5070607 1372  5070569 1372  
335462 5070537 1370  5070507 1372  5070478 1371  5070456 1370  5070432 1370  5070413 1370  
335463 5070405 1368  5070391 1368  5070381 1368  5070373 1366  5070368 1366  5070367 1368  
335464 5070367 1368  5070383 1366  5070389 1370  5070396 1368  5070410 1368  5070424 1368  
335465 5070448 1368  5070472 1368  5070497 1366  5070525 1368  5070558 1368  5070591 1368  
335466 5070625 1368  5070658 1368  5070696 1368  5070725 1368  5070765 1366  5070801 1368  
335467 5070841 1366  5070884 1366  5070916 1368  5070961 1366  5070994 1366  5071037 1366  
335468 5071066 1366  5071094 1366  5071128 1366  5071152 1366  5071185 1366  5071204 1366  
335469 5071218 1366  5071241 1368  5071260 1368  5071265 1368  5071284 1368  5071284 1368  
335470 5071289 1368  5071289 1368  5071285 1366  5071284 1368  5071265 1368  5071262 1366  
335471 5071242 1366  5071228 1366  5071204 1366  5071191 1364  5071166 1366  5071144 1364  
335472 5071109 1366  5071088 1368  5071061 1366  5071027 1366  5071004 1366  5070975 1366  
335473 5070941 1366  5070914 1364  5070884 1366  5070851 1366  5070819 1364  5070803 1360  
335474 5070769 1360  5070742 1364  5070714 1364  5070702 1360  5070679 1360  5070661 1364  
335475 5070645 1360  5070640 1360  5070631 1360  5070621 1360  5070618 1358  5070617 1360  
335476 5070618 1358  5070617 1360  5070625 1357  5070632 1358  5070645 1360  5070666 1358  
335477 5070680 1358  5070699 1358  5070717 1360  5070742 1358  5070766 1358  5070789 1360  
335478 5070807 1360  5070842 1358  5070871 1358  5070903 1360  5070932 1360  5070965 1360  
335479 5070996 1364  5071032 1360  5071066 1360  5071099 1360  5071132 1360  5071167 1358  
335480 5071190 1360  5071214 1360  5071237 1360  5071271 1360  5071290 1360  5071309 1360  
335481 5071320 1364  5071339 1358  5071347 1360  5071362 1360  5071363 1358  5071362 1360  
335482 5071371 1360  5071371 1360  5071362 1360  5071357 1360  5071338 1360  5071320 1364  
335483 5071309 1360  5071295 1360  5071268 1364  5071247 1360  5071213 1360  5071190 1360  
335484 5071156 1360  5071120 1364  5071086 1364  5071053 1364  5071010 1364  5070976 1364  
335485 5070941 1360  5070900 1364  5070855 1360  5070814 1364  5070776 1364  5070741 1360  
335486 5070704 1364  5070671 1364  5070637 1364  5070604 1364  5070575 1364  5070542 1364  
335487 5070513 1364  5070493 1366  5070470 1364  5070451 1364  5070427 1364  5070411 1366  
335488 5070406 1366  5070397 1366  5070381 1368  5070383 1366  5070383 1366  5070381 1368  
335489 5070392 1366  5070397 1366  5070410 1368  5070426 1366  5070443 1368  5070459 1366  
335490 5070483 1366  5070500 1368  5070524 1368  5070558 1368  5070583 1366  5070610 1368  
335491 5070638 1370  5070674 1366  5070711 1368  5070738 1370  5070783 1368  5070809 1370  
335492 5070849 1368  5070883 1368  5070916 1368  5070950 1368  5070989 1366  5071015 1370  
335493 5071039 1370  5071074 1368  5071093 1368  5071126 1368  5071140 1368  5071164 1368  
335494 5071183 1368  5071188 1368  5071203 1368  5071207 1368  5071217 1368  5071227 1368  
335495 5071218 1366  5071218 1366  5071218 1366  5071209 1366  5071199 1360  5071190 1360  
335496 5071180 1360  5071167 1358  5071143 1358  5071126 1357  5071102 1357  5071083 1356  
335497 5071069 1356  5071045 1356  5071011 1357  5070992 1356  5070970 1355  5070935 1356  
335498 5070912 1355  5070893 1355  5070860 1355  5070836 1355  5070812 1355  5070793 1355  
335499 5070769 1355  5070745 1355  5070726 1355  5070712 1355  5070707 1355  5070693 1355  
335500 5070683 1355  5070680 1353  5070680 1353  5070669 1355  5070669 1355  5070670 1353  
335501 5070678 1355  5070678 1355  5070685 1353  5070702 1355  5070714 1353  5070721 1355  
335502 5070745 1355  5070761 1353  5070784 1355  5070807 1355  5070826 1355  5070850 1355  
335503 5070874 1355  5070898 1355  5070927 1355  5070960 1355  5070994 1355  5071013 1355  
335504 5071046 1355  5071075 1355  5071103 1355  5071127 1355  5071161 1355  5071185 1355  
335505 5071205 1353  5071228 1355  5071242 1355  5071271 1355  5071285 1355  5071299 1355  
335506 5071314 1355  5071320 1353  5071328 1355  5071339 1353  5071338 1355  5071338 1355  
335507 5071339 1353  5071328 1355  5071320 1353  5071314 1355  5071299 1355  5071285 1355  
335508 5071272 1353  5071242 1355  5071229 1353  5071204 1355  5071177 1353  5071151 1355  
335509 5071120 1353  5071094 1355  5071062 1353  5071029 1353  5071000 1353  5070962 1353  
335510 5070928 1353  5070898 1355  5070861 1353  5070827 1355  5070802 1355  5070760 1355  
335511 5070726 1355  5070702 1355  5070669 1355  5070635 1355  5070611 1355  5070593 1355  
335512 5070568 1355  5070545 1355  5070526 1355  5070511 1355  5070492 1355  5070483 1355  
335513 5070478 1355  5070467 1356  5070459 1355  5070454 1355  5070454 1355  5070459 1355  
335514 5070459 1355  5070478 1355  5070478 1355  5070492 1355  5070506 1355  5070521 1355  
335515 5070535 1355  5070550 1355  5070578 1355  5070602 1355  5070621 1355  5070645 1355  
335516 5070678 1355  5070702 1355  5070726 1355  5070760 1355  5070793 1355  5070820 1356  
335517 5070851 1355  5070884 1355  5070911 1356  5070936 1355  5070960 1355  5070994 1355  
335518 5071013 1355  5071037 1355  5071051 1355  5071075 1355  5071094 1355  5071103 1355  
335519 5071116 1356  5071137 1355  5071145 1356  5071151 1355  5071161 1355  5071161 1355  
335520 5071161 1355  5071161 1355  5071161 1355  5071151 1355  5071145 1356  5071137 1355  
335521 5071126 1356  5071116 1356  5071102 1356  5071093 1356  5071073 1356  5071059 1356  
335522 5071035 1356  5071016 1356  5070997 1356  5070982 1356  5070959 1356  5070935 1356  
335523 5070911 1357  5070897 1356  5070873 1356  5070859 1357  5070843 1358  5070820 1357  
335524 5070806 1357  5070801 1356  5070782 1356  5070772 1356  5070758 1356  5070749 1356  
335525 5070744 1356  5070744 1357  5070734 1356  5070734 1356  5070734 1356  5070734 1356  
335526 5070734 1356  5070744 1356  5070749 1356  5070768 1356  5070774 1355  5070793 1355  
335527 5070807 1355  5070820 1356  5070844 1356  5070858 1356  5070873 1356  5070897 1356  
335528 5070920 1356  5070944 1356  5070970 1355  5070994 1355  5071011 1356  5071035 1356  
335529 5071049 1356  5071073 1357  5071097 1356  5071118 1355  5071145 1356  5071169 1356  
335530 5071183 1356  5071198 1356  5071212 1356  5071226 1356  5071240 1356  5071260 1356  
335531 5071269 1356  5071274 1356  5071274 1357  5071283 1356  5071283 1356  5071283 1356  
335532 5071283 1356  5071283 1356  5071274 1356  5071269 1356  5071248 1358  5071240 1356  
335533 5071216 1356  5071202 1356  5071191 1358  5071172 1358  5071148 1358  5071123 1360  
335534 5071099 1360  5071081 1358  5071048 1358  5071023 1360  5070999 1360  5070970 1360  
335535 5070941 1360  5070914 1364  5070886 1364  5070862 1364  5070831 1360  5070800 1364  
335536 5070776 1364  5070742 1364  5070716 1368  5070696 1368  5070674 1366  5070649 1368  
335537 5070634 1368  5070615 1368  5070601 1368  5070591 1368  5070572 1368  5070567 1368  
335538 5070550 1366  5070539 1368  5070532 1370  5070534 1368  5070534 1368  5070524 1368  
335539 5070532 1370  5070532 1370  5070537 1370  5070547 1370  5070556 1370  5070571 1370  
335540 5070580 1370  5070596 1368  5070609 1370  5070625 1368  5070647 1370  5070671 1370  
335541 5070695 1370  5070712 1372  5070736 1371  5070762 1370  5070794 1372  5070812 1371  
335542 5070838 1370  5070861 1372  5070894 1372  5070913 1372  5070931 1373  5070955 1373  
335543 5070978 1373  5070996 1375  5071010 1375  5071031 1373  5071044 1375  5071058 1375  
335544 5071079 1373  5071082 1375  5071087 1375  5071101 1375  5071101 1375  5071110 1375  
335545 5071110 1375  5071110 1375  5071111 1375  5071107 1379  5071098 1379  5071096 1375  
335546 5071087 1375  5071082 1375  5071077 1375  5071055 1379  5071050 1379  5071031 1379  
335547 5071026 1379  5071007 1379  5070993 1379  5070978 1379  5070964 1379  5070950 1379  
335548 5070925 1381  5070917 1379  5070901 1381  5070888 1379  5070872 1381  5070862 1381  
335549 5070848 1381  5070838 1381  5070829 1381  5070814 1381  5070805 1381  5070805 1381  
335550 5070800 1381  5070789 1383  5070791 1381  5070789 1383  5070789 1383  5070789 1383  
335551 5070788 1385  5070799 1383  5070803 1383  5070821 1385  5070826 1385  5070837 1383  
335552 5070848 1387  5070859 1385  5070872 1387  5070888 1385  5070901 1387  5070920 1387  
335553 5070944 1387  5070958 1387  5070972 1387  5070992 1387  5071011 1387  5071025 1387  
335554 5071049 1387  5071073 1387  5071089 1385  5071112 1385  5071127 1385  5071146 1385  
335555 5071160 1385  5071176 1383  5071191 1383  5071197 1381  5071214 1383  5071221 1381  
335556 5071230 1381  5071240 1381  5071249 1381  5071249 1381  5071249 1381  5071249 1381  
335557 5071249 1381  5071249 1381  5071249 1381  5071240 1381  5071230 1381  5071221 1381  
335558 5071205 1383  5071195 1383  5071179 1385  5071170 1385  5071149 1387  5071144 1387  
335559 5071121 1387  5071100 1388  5071076 1388  5071056 1390  5071041 1390  5071017 1390  
335560 5070987 1392  5070968 1392  5070944 1392  5070920 1392  5070898 1390  5070878 1390  
335561 5070844 1392  5070831 1390  5070805 1392  5070780 1394  5070762 1392  5070742 1394  
335562 5070729 1392  5070713 1394  5070693 1396  5070678 1396  5070668 1396  5070650 1396  
335563 5070645 1396  5070635 1396  5070626 1396  5070615 1398  5070610 1398  5070610 1398  
335564 5070610 1398  5070610 1398  5070615 1398  5070615 1398  5070623 1400  5070632 1400  
335565 5070642 1400  5070647 1400  5070666 1400  5070675 1400  5070690 1400  5070708 1400  
335566 5070723 1400  5070747 1400  5070764 1402  5070785 1400  5070801 1398  5070823 1400  
335567 5070837 1400  5070861 1400  5070887 1398  5070909 1400  5070925 1398  5070947 1400  
335568 5070962 1400  5070981 1400  5071000 1400  5071024 1400  5071037 1402  5071056 1402  
335569 5071067 1400  5071081 1400  5071089 1402  5071099 1402  5071108 1402  5071114 1400  
335570 5071124 1400  5071123 1402  5071123 1402  5071134 1400  5071123 1402  5071123 1402  
335571 5071123 1402  5071113 1402  5071107 1403  5071097 1404  5071088 1403  5071073 1403  
335572 5071064 1404  5071053 1405  5071044 1403  5071029 1405  5071016 1409  5071002 1409  
335573 5070982 1409  5070968 1409  5070957 1411  5070948 1411  5070929 1411  5070924 1411  
335574 5070905 1411  5070900 1411  5070881 1411  5070878 1409  5070866 1411  5070862 1411  
335575 5070852 1411  5070852 1411  5070853 1411  5070847 1411  5070847 1411  5070846 1413  
335576 5070846 1413  5070846 1413  5070846 1413  5070852 1411  5070860 1413  5070865 1413  
335577 5070875 1413  5070879 1413  5070879 1413  5070897 1415  5070902 1415  5070921 1415  
335578 5070926 1415  5070946 1413  5070948 1417  5070964 1415  5070988 1415  5070997 1415  
335579 5071011 1415  5071036 1415  5071045 1415  5071055 1415  5071067 1417  5071088 1415  
335580 5071101 1417  5071120 1417  5071126 1415  5071145 1415  5071150 1415  5071155 1415  
335581 5071168 1417  5071179 1415  5071187 1417  5071193 1415  5071201 1417  5071212 1415  
335582 5071211 1417  5071211 1417  5071220 1417  5071220 1417  5071212 1415  5071211 1417  
335583 5071211 1417  5071201 1417  5071187 1417  5071177 1417  5071168 1417  5071154 1417  
335584 5071148 1417  5071133 1419  5071120 1417  5071095 1419  5071077 1417  5071061 1419  
335585 5071044 1417  5071020 1417  5071001 1417  5070985 1419  5070962 1417  5070943 1417  
335586 5070920 1417  5070899 1419  5070876 1417  5070848 1417  5070833 1417  5070808 1419  
335587 5070795 1417  5070774 1419  5070757 1417  5070741 1419  5070722 1419  5070708 1419  
335588 5070692 1420  5070682 1420  5070673 1420  5070665 1424  5070655 1424  5070651 1424  
335589 5070651 1424  5070651 1424  5070649 1426  5070649 1426  5070649 1426  5070649 1426  
335590 5070652 1428  5070662 1428  5070676 1428  5070686 1428  5070691 1428  5070709 1428  
335591 5070724 1428  5070743 1428  5070753 1428  5070767 1428  5070791 1428  5070810 1428  
335592 5070834 1428  5070853 1428  5070877 1428  5070891 1428  5070915 1428  5070934 1428  
335593 5070955 1426  5070977 1428  5070991 1428  5071012 1426  5071025 1428  5071045 1426  
335594 5071058 1428  5071068 1428  5071089 1426  5071101 1428  5071103 1426  5071114 1424  
335595 5071117 1426  5071127 1426  5071127 1426  5071138 1424  5071138 1424  5071128 1424  
335596 5071127 1426  5071127 1426  5071119 1424  5071112 1426  5071103 1426  5071093 1426  
335597 5071079 1426  5071069 1426  5071058 1428  5071055 1426  5071039 1428  5071025 1428  
335598 5071012 1426  5070991 1428  5070988 1426  5070968 1428  5070953 1428  5070944 1428  
335599 5070934 1428  5070925 1428  5070910 1428  5070901 1428  5070886 1428  5070878 1426  
335600 5070866 1424  5070855 1426  5070851 1424  5070842 1424  5070827 1424  5070827 1424  
335601 5070818 1424  5070821 1420  5070818 1424  5070821 1420  5070822 1419  5070821 1420  
335602 5070827 1424  5070830 1420  5070845 1420  5070846 1419  5070856 1419  5070859 1420  
335603 5070869 1420  5070883 1420  5070892 1420  5070907 1420  5070918 1419  5070931 1420  
335604 5070945 1420  5070959 1420  5070975 1419  5070994 1419  5071007 1420  5071021 1420  
335605 5071040 1420  5071052 1419  5071064 1420  5071083 1420  5071098 1420  5071117 1420  
335606 5071131 1420  5071138 1424  5071150 1420  5071160 1420  5071174 1420  5071184 1420  
335607 5071189 1420  5071189 1420  5071198 1420  5071198 1420  5071198 1420  5071189 1420  
335608 5071189 1420  5071189 1420  5071184 1420  5071184 1420  5071165 1420  5071160 1420  
335609 5071152 1419  5071141 1420  5071123 1419  5071107 1420  5071098 1420  5071074 1420  
335610 5071057 1424  5071045 1420  5071018 1424  5070997 1420  5070983 1420  5070956 1424  
335611 5070942 1424  5070918 1424  5070894 1424  5070870 1424  5070856 1424  5070830 1420  
335612 5070813 1424  5070789 1424  5070770 1424  5070756 1424  5070736 1424  5070718 1424  
335613 5070703 1424  5070694 1424  5070679 1424  5070670 1424  5070665 1424  5070655 1424  
335614 5070651 1424  5070651 1424  5070651 1424  5070651 1424  5070646 1424  5070646 1424  
335615 5070649 1426  5070655 1424  5070665 1424  5070668 1426  5070689 1424  5070703 1424  
335616 5070713 1424  5070735 1426  5070750 1426  5070764 1426  5070779 1424  5070803 1424  
335617 5070826 1426  5070840 1426  5070870 1424  5070888 1426  5070913 1424  5070935 1426  
335618 5070945 1426  5070969 1426  5070988 1426  5071013 1424  5071026 1426  5071042 1424  
335619 5071057 1424  5071069 1426  5071088 1426  5071093 1426  5071114 1424  5071117 1426  
335620 5071127 1426  5071138 1424  5071136 1426  5071141 1426  5071142 1424  5071142 1424  
335621 5071141 1426  5071138 1424  5071128 1424  5071127 1426  5071114 1424  5071103 1426  
335622 5071093 1426  5071089 1426  5071071 1424  5071060 1426  5071045 1426  5071036 1426  
335623 5071017 1426  5071002 1426  5070988 1426  5070969 1426  5070945 1426  5070936 1426  
335624 5070917 1426  5070902 1426  5070888 1426  5070869 1426  5070855 1426  5070838 1428  
335625 5070824 1428  5070811 1426  5070792 1426  5070786 1428  5070778 1426  5070764 1426  
335626 5070754 1426  5070748 1428  5070748 1428  5070750 1426  5070744 1426  5070750 1426  
335627 5070750 1426  5070750 1426  5070753 1428  5070754 1426  5070764 1426  5070776 1428  
335628 5070786 1428  5070791 1428  5070811 1426  5070824 1428  5070834 1428  5070848 1428  
335629 5070862 1428  5070878 1426  5070893 1426  5070917 1426  5070936 1426  5070955 1426  
335630 5070967 1428  5070987 1428  5071010 1428  5071026 1426  5071044 1428  5071058 1428  
335631 5071077 1428  5071103 1426  5071112 1426  5071125 1428  5071136 1426  5071146 1426  
335632 5071154 1428  5071159 1428  5071168 1428  5071178 1428  5071178 1428  5071182 1428  
335633 5071179 1426  5071179 1426  5071178 1428  5071170 1426  5071168 1428  5071154 1428  
335634 5071144 1428  5071139 1428  5071125 1428  5071112 1426  5071092 1428  5071077 1428  
335635 5071058 1428  5071041 1426  5071017 1426  5071002 1426  5070978 1426  5070955 1426  
335636 5070934 1428  5070910 1428  5070891 1428  5070869 1426  5070848 1428  5070824 1428  
335637 5070802 1426  5070788 1426  5070764 1426  5070744 1426  5070724 1428  5070709 1428  
335638 5070691 1428  5070676 1428  5070662 1428  5070652 1428  5070648 1428  5070643 1428  
335639 5070633 1428  5070633 1428  5070633 1428  5070633 1428  5070643 1428  5070643 1428  
335640 5070648 1428  5070662 1428  5070667 1428  5070676 1428  5070691 1428  5070715 1428  
335641 5070734 1428  5070748 1428  5070767 1428  5070786 1428  5070810 1428  5070834 1428  
335642 5070853 1428  5070877 1428  5070901 1428  5070925 1428  5070944 1428  5070977 1428  
335643 5070991 1428  5071015 1428  5071039 1428  5071054 1428  5071077 1428  5071092 1428  
335644 5071111 1428  5071135 1428  5071139 1428  5071154 1428  5071159 1428  5071178 1428  
335645 5071182 1428  5071182 1428  5071192 1428  5071192 1428  5071192 1428  5071192 1428  
335646 5071182 1428  5071178 1428  5071178 1428  5071159 1428  5071154 1428  5071139 1428  
335647 5071135 1428  5071115 1428  5071101 1428  5071077 1428  5071058 1428  5071039 1428  
335648 5071025 1428  5071001 1428  5070987 1428  5070960 1426  5070944 1428  5070925 1428  
335649 5070901 1428  5070877 1428  5070862 1428  5070838 1428  5070824 1428  5070802 1426  
335650 5070786 1428  5070776 1428  5070762 1428  5070748 1428  5070743 1428  5070733 1428  
335651 5070724 1428  5070714 1428  5070715 1428  5070715 1428  5070715 1428  5070709 1428  
335652 5070715 1428  5070715 1428  5070733 1428  5070743 1428  5070748 1428  5070753 1428  
335653 5070767 1428  5070786 1428  5070800 1428  5070815 1428  5070834 1428  5070848 1428  
335654 5070867 1428  5070891 1428  5070910 1428  5070934 1428  5070953 1428  5070977 1428  
335655 5071001 1428  5071025 1428  5071044 1428  5071068 1428  5071087 1428  5071111 1428  
335656 5071125 1428  5071139 1428  5071154 1428  5071177 1428  5071192 1428  5071202 1428  
335657 5071211 1428  5071216 1428  5071235 1428  5071235 1428  5071240 1428  5071240 1428  
335658 5071240 1428  5071240 1428  5071235 1428  5071226 1428  5071216 1428  5071211 1428  
335659 5071192 1428  5071178 1428  5071159 1428  5071144 1428  5071125 1428  5071101 1428  
335660 5071087 1428  5071057 1430  5071039 1428  5071015 1428  5070990 1430  5070966 1430  
335661 5070942 1430  5070923 1430  5070909 1430  5070877 1428  5070851 1430  5070835 1432  
335662 5070808 1430  5070789 1430  5070765 1430  5070751 1430  5070730 1432  5070721 1432  
335663 5070708 1430  5070689 1430  5070684 1430  5070675 1430  5070664 1432  5070664 1432  
335664 5070659 1432  5070664 1432  5070664 1432  5070664 1432  5070673 1432  5070688 1432  
335665 5070697 1432  5070711 1432  5070730 1432  5070745 1432  5070759 1432  5070783 1432  
335666 5070797 1432  5070821 1432  5070845 1432  5070864 1432  5070887 1434  5070912 1432  
335667 5070936 1432  5070955 1432  5070988 1432  5071007 1432  5071035 1434  5071055 1432  
335668 5071084 1432  5071108 1432  5071132 1432  5071149 1434  5071165 1432  5071179 1432  
335669 5071197 1434  5071213 1432  5071232 1432  5071237 1432  5071241 1432  5071251 1432  
335670 5071251 1432  5071249 1434  5071251 1432  5071251 1432  5071251 1432  5071241 1432  
335671 5071237 1432  5071222 1432  5071213 1432  5071198 1432  5071179 1432  5071165 1432  
335672 5071141 1432  5071132 1432  5071108 1432  5071082 1434  5071055 1432  5071035 1434  
335673 5071006 1434  5070982 1434  5070953 1434  5070934 1434  5070907 1432  5070882 1434  
335674 5070859 1432  5070834 1434  5070807 1437  5070786 1434  5070769 1437  5070745 1437  
335675 5070735 1437  5070716 1437  5070702 1437  5070681 1439  5070676 1439  5070667 1439  
335676 5070667 1439  5070657 1439  5070657 1439  5070656 1441  5070656 1441  5070656 1441  
335677 5070665 1441  5070673 1443  5070680 1441  5070691 1439  5070704 1441  5070723 1441  
335678 5070737 1441  5070756 1441  5070775 1441  5070801 1439  5070823 1441  5070844 1439  
335679 5070866 1441  5070892 1439  5070924 1441  5070944 1439  5070968 1439  5070993 1437  
335680 5071015 1439  5071044 1439  5071068 1439  5071092 1439  5071116 1439  5071130 1439  
335681 5071151 1437  5071168 1439  5071183 1439  5071203 1437  5071208 1437  5071227 1437  
335682 5071235 1434  5071240 1434  5071249 1434  5071249 1434  5071251 1432  5071251 1432  
335683 5071241 1432  5071237 1432  5071232 1432  5071213 1432  5071208 1432  5071189 1432  
335684 5071175 1432  5071156 1432  5071136 1432  5071122 1432  5071098 1432  5071073 1434  
335685 5071050 1432  5071031 1432  5071006 1434  5070984 1432  5070948 1434  5070929 1434  
335686 5070906 1434  5070879 1437  5070855 1437  5070831 1437  5070805 1439  5070783 1437  
335687 5070756 1441  5070739 1439  5070724 1439  5070705 1439  5070691 1439  5070681 1439  
335688 5070667 1439  5070667 1439  5070656 1441  5070656 1441  5070657 1439  5070657 1439  
335689 5070657 1439  5070665 1441  5070676 1439  5070680 1441  5070700 1439  5070715 1439  
335690 5070734 1439  5070743 1439  5070758 1439  5070782 1439  5070799 1441  5070823 1441  
335691 5070842 1441  5070866 1441  5070890 1441  5070923 1441  5070942 1441  5070968 1439  
335692 5071000 1441  5071025 1439  5071049 1439  5071078 1439  5071103 1437  5071127 1437  
335693 5071146 1437  5071170 1437  5071184 1437  5071206 1434  5071218 1437  5071232 1437  
335694 5071246 1437  5071254 1434  5071261 1437  5071264 1434  5071275 1432  5071273 1434  
335695 5071264 1434  5071264 1434  5071256 1432  5071251 1432  5071240 1434  5071230 1434  
335696 5071211 1434  5071197 1434  5071175 1437  5071151 1437  5071137 1437  5071108 1437  
335697 5071087 1434  5071050 1437  5071031 1437  5071003 1437  5070979 1437  5070945 1437  
335698 5070926 1437  5070893 1437  5070860 1437  5070839 1439  5070815 1439  5070791 1439  
335699 5070758 1439  5070738 1439  5070715 1439  5070700 1439  5070675 1441  5070657 1439  
335700 5070651 1441  5070637 1441  5070623 1441  5070615 1439  5070608 1441  5070597 1443  
335701 5070599 1441  5070597 1443  5070598 1441  5070606 1443  5070613 1441  5070623 1441  
335702 5070635 1443  5070650 1443  5070662 1445  5070678 1443  5070702 1443  5070729 1445  
335703 5070749 1445  5070772 1445  5070796 1445  5070820 1445  5070849 1445  5070873 1445  
335704 5070901 1445  5070927 1443  5070955 1443  5070978 1445  5071011 1445  5071032 1443  
335705 5071064 1445  5071089 1443  5071113 1443  5071132 1443  5071158 1441  5071170 1443  
335706 5071191 1441  5071204 1443  5071228 1443  5071232 1443  5071243 1441  5071246 1443  
335707 5071256 1443  5071256 1443  5071256 1443  5071256 1443  5071256 1443  5071246 1443  
335708 5071240 1445  5071232 1443  5071223 1443  5071204 1443  5071188 1445  5071169 1445  
335709 5071154 1445  5071132 1443  5071111 1445  5071097 1445  5071062 1447  5071038 1447  
335710 5071019 1447  5070995 1447  5070962 1447  5070936 1449  5070919 1447  5070893 1449  
335711 5070862 1447  5070836 1449  5070817 1449  5070793 1449  5070769 1449  5070750 1449  
335712 5070736 1449  5070723 1452  5070707 1449  5070695 1452  5070680 1452  5070680 1452  
335713 5070670 1452  5070671 1452  5070671 1452  5070670 1452  5070680 1452  5070690 1452  
335714 5070695 1452  5070704 1452  5070723 1452  5070733 1452  5070742 1452  5070766 1452  
335715 5070780 1452  5070804 1452  5070828 1452  5070847 1452  5070871 1452  5070895 1452  
335716 5070924 1452  5070947 1452  5070981 1452  5071005 1452  5071034 1452  5071058 1452  
335717 5071081 1452  5071118 1449  5071138 1447  5071161 1449  5071186 1447  5071199 1449  
335718 5071225 1447  5071239 1447  5071253 1447  5071267 1447  5071277 1447  5071285 1449  
335719 5071291 1447  5071290 1449  5071301 1447  5071299 1449  5071291 1447  5071291 1447  
335720 5071277 1447  5071266 1449  5071253 1447  5071239 1447  5071223 1449  5071201 1447  
335721 5071177 1447  5071153 1447  5071130 1445  5071100 1447  5071073 1445  5071043 1447  
335722 5071019 1447  5070987 1445  5070952 1447  5070924 1447  5070895 1447  5070861 1447  
335723 5070838 1447  5070809 1447  5070774 1449  5070752 1447  5070726 1449  5070699 1447  
335724 5070674 1449  5070650 1449  5070631 1449  5070617 1449  5070602 1449  5070583 1449  
335725 5070573 1449  5070565 1452  5070556 1452  5070556 1452  5070547 1452  5070556 1452  
335726 5070556 1452  5070565 1452  5070570 1452  5070589 1452  5070604 1452  5070623 1452  
335727 5070632 1452  5070656 1452  5070670 1452  5070695 1452  5070723 1452  5070742 1452  
335728 5070766 1452  5070795 1452  5070819 1452  5070847 1452  5070881 1452  5070907 1449  
335729 5070933 1452  5070967 1452  5070998 1449  5071019 1452  5071051 1449  5071075 1449  
335730 5071099 1449  5071127 1449  5071142 1449  5071166 1449  5071185 1449  5071201 1447  
335731 5071220 1447  5071229 1447  5071239 1447  5071243 1447  5071245 1445  5071255 1445  
335732 5071255 1445  5071255 1445  5071247 1443  5071240 1445  5071231 1445  5071228 1443  
335733 5071213 1443  5071200 1441  5071180 1443  5071165 1443  5071148 1441  5071127 1443  
335734 5071105 1441  5071079 1443  5071046 1443  5071027 1443  5071003 1443  5070974 1443  
335735 5070946 1443  5070927 1443  5070896 1445  5070872 1445  5070849 1445  5070825 1445  
335736 5070801 1445  5070787 1445  5070763 1445  5070749 1445  5070735 1443  5070720 1445  
335737 5070701 1445  5070696 1445  5070686 1445  5070675 1447  5070675 1447  5070677 1445  
335738 5070675 1447  5070675 1447  5070685 1447  5070694 1447  5070701 1445  5070718 1447  
335739 5070731 1449  5070747 1447  5070760 1449  5070785 1447  5070799 1447  5070823 1447  
335740 5070847 1447  5070876 1447  5070900 1447  5070924 1447  5070952 1447  5070976 1447  
335741 5071009 1447  5071038 1447  5071062 1447  5071096 1447  5071119 1447  5071138 1447  
335742 5071164 1445  5071188 1445  5071210 1447  5071229 1447  5071245 1445  5071263 1447  
335743 5071278 1445  5071288 1445  5071301 1447  5071312 1445  5071322 1445  5071322 1445  
335744 5071322 1445  5071312 1445  5071312 1445  5071293 1445  5071278 1445  5071269 1445  
335745 5071256 1443  5071242 1443  5071223 1443  5071197 1445  5071169 1445  5071145 1445  
335746 5071122 1443  5071088 1445  5071064 1445  5071030 1445  5070998 1443  5070963 1445  
335747 5070939 1445  5070903 1443  5070873 1445  5070839 1445  5070810 1445  5070777 1445  
335748 5070749 1445  5070729 1445  5070696 1445  5070670 1447  5070648 1445  5070629 1445  
335749 5070604 1447  5070586 1445  5070570 1447  5070553 1445  5070546 1447  5070537 1447  
335750 5070537 1447  5070537 1447  5070538 1445  5070537 1447  5070546 1447  5070551 1447  
335751 5070570 1447  5070575 1447  5070602 1449  5070607 1449  5070632 1447  5070645 1449  
335752 5070669 1449  5070694 1447  5070717 1449  5070745 1449  5070769 1449  5070795 1452  
335753 5070831 1449  5070860 1449  5070890 1452  5070922 1449  5070947 1452  5070971 1452  
335754 5071008 1449  5071034 1452  5071067 1452  5071094 1449  5071115 1452  5071134 1452  
335755 5071161 1449  5071182 1452  5071196 1452  5071215 1452  5071225 1452  5071234 1452  
335756 5071242 1449  5071248 1452  5071258 1452  5071258 1452  5071261 1449  5071261 1449  
335757 5071251 1449  5071242 1449  5071237 1449  5071228 1449  5071218 1449  5071199 1449  
335758 5071186 1447  5071161 1449  5071137 1449  5071124 1447  5071099 1449  5071075 1449  
335759 5071053 1447  5071027 1449  5071000 1447  5070976 1447  5070951 1449  5070927 1449  
335760 5070905 1452  5070881 1452  5070860 1449  5070833 1452  5070819 1452  5070798 1449  
335761 5070780 1452  5070769 1449  5070747 1452  5070742 1452  5070733 1452  5070728 1452  
335762 5070723 1452  5070714 1452  5070714 1452  5070714 1452  5070714 1452  5070723 1452  
335763 5070728 1452  5070733 1452  5070747 1452  5070757 1452  5070780 1452  5070795 1452  
335764 5070814 1452  5070833 1452  5070847 1452  5070871 1452  5070895 1452  5070919 1452  
335765 5070951 1449  5070972 1452  5070999 1449  5071029 1447  5071053 1447  5071076 1447  
335766 5071100 1447  5071127 1449  5071153 1447  5071177 1447  5071202 1445  5071225 1447  
335767 5071245 1445  5071263 1447  5071278 1445  5071291 1447  5071312 1445  5071322 1445  
335768 5071322 1445  5071326 1445  5071328 1443  5071328 1443  5071326 1445  5071322 1445  
335769 5071313 1443  5071302 1445  5071288 1445  5071270 1443  5071255 1445  5071232 1443  
335770 5071213 1443  5071188 1445  5071154 1445  5071132 1443  5071103 1443  5071073 1445  
335771 5071040 1445  5071013 1443  5070978 1445  5070944 1445  5070920 1445  5070885 1447  
335772 5070847 1447  5070819 1447  5070785 1447  5070752 1447  5070731 1449  5070697 1449  
335773 5070674 1449  5070645 1449  5070631 1449  5070607 1449  5070593 1449  5070573 1449  
335774 5070559 1449  5070550 1449  5070542 1452  5070532 1452  5070535 1449  5070532 1452  
335775 5070532 1452  5070545 1449  5070550 1449  5070559 1449  5070570 1452  5070580 1452  
335776 5070599 1452  5070623 1452  5070632 1452  5070656 1452  5070674 1449  5070695 1452  
335777 5070728 1452  5070747 1452  5070780 1452  5070814 1452  5070836 1449  5070869 1449  
335778 5070898 1449  5070927 1449  5070960 1449  5070994 1449  5071014 1452  5071041 1449  
335779 5071070 1449  5071094 1449  5071118 1449  5071127 1449  5071151 1449  5071166 1449  
335780 5071186 1447  5071201 1447  5071210 1447  5071226 1445  5071229 1447  5071240 1445  
335781 5071240 1445  5071243 1447  5071243 1447  5071240 1445  5071231 1445  5071231 1445  
335782 5071220 1447  5071201 1447  5071197 1445  5071169 1445  5071153 1447  5071140 1445  
335783 5071121 1445  5071097 1445  5071072 1447  5071054 1445  5071030 1445  5071011 1445  
335784 5070987 1445  5070962 1447  5070938 1447  5070925 1445  5070901 1445  5070877 1445  
335785 5070852 1447  5070838 1447  5070819 1447  5070799 1447  5070785 1447  5070771 1447  
335786 5070761 1447  5070752 1447  5070737 1447  5070737 1447  5070732 1447  5070733 1447  
335787 5070731 1449  5070731 1449  5070737 1447  5070736 1449  5070745 1449  5070761 1447  
335788 5070774 1449  5070784 1449  5070798 1449  5070822 1449  5070847 1447  5070861 1447  
335789 5070886 1447  5070908 1449  5070928 1447  5070952 1447  5070978 1445  5071000 1447  
335790 5071024 1447  5071043 1447  5071076 1447  5071100 1447  5071124 1447  5071153 1447  
335791 5071175 1449  5071201 1447  5071218 1449  5071239 1447  5071253 1447  5071267 1447  
335792 5071286 1447  5071291 1447  5071310 1447  5071309 1449  5071318 1449  5071320 1447  
335793 5071320 1447  5071318 1449  5071310 1447  5071299 1449  5071290 1449  5071277 1447  
335794 5071263 1447  5071243 1447  5071225 1447  5071200 1447  5071186 1447  5071154 1445  
335795 5071124 1447  5071102 1445  5071072 1447  5071040 1445  5071009 1447  5070978 1445  
335796 5070944 1445  5070919 1447  5070877 1445  5070849 1445  5070820 1445  5070787 1445  
335797 5070753 1445  5070729 1445  5070701 1445  5070672 1445  5070648 1445  5070629 1445  
335798 5070610 1445  5070586 1445  5070576 1445  5070562 1445  5070548 1445  5070538 1445  
335799 5070537 1447  5070532 1447  5070532 1447  5070532 1447  5070532 1447  5070537 1447  
335800 5070546 1447  5070560 1447  5070569 1449  5070586 1445  5070604 1447  5070618 1447  
335801 5070637 1447  5070650 1449  5070675 1447  5070697 1449  5070728 1447  5070752 1447  
335802 5070775 1447  5070799 1447  5070834 1445  5070854 1445  5070886 1447  5070909 1447  
335803 5070939 1445  5070971 1447  5070995 1447  5071019 1447  5071038 1447  5071064 1445  
335804 5071086 1447  5071102 1445  5071124 1447  5071140 1445  5071153 1447  5071162 1447  
335805 5071178 1445  5071186 1447  5071196 1447  5071196 1447  5071202 1445  5071202 1445  
335806 5071201 1447  5071201 1447  5071186 1447  5071177 1447  5071167 1447  5071153 1447  
335807 5071138 1447  5071124 1447  5071111 1445  5071097 1445  5071073 1445  5071054 1445  
335808 5071030 1445  5071021 1445  5070997 1445  5070978 1445  5070954 1445  5070930 1445  
335809 5070920 1445  5070896 1445  5070877 1445  5070854 1445  5070839 1445  5070820 1445  
335810 5070801 1445  5070787 1445  5070772 1445  5070753 1445  5070749 1445  5070739 1445  
335811 5070734 1445  5070736 1443  5070729 1445  5070729 1445  5070729 1445  5070734 1445  
335812 5070739 1445  5070748 1445  5070752 1447  5070771 1447  5070785 1447  5070801 1445  
335813 5070820 1445  5070834 1445  5070849 1445  5070873 1445  5070896 1445  5070911 1445  
335814 5070928 1447  5070954 1445  5070979 1443  5071011 1445  5071030 1445  5071056 1443  
335815 5071078 1445  5071102 1445  5071132 1443  5071155 1445  5071170 1443  5071199 1443  
335816 5071213 1443  5071228 1443  5071242 1443  5071256 1443  5071269 1445  5071270 1443  
335817 5071280 1443  5071290 1443  5071290 1443  5071291 1441  5071291 1441  5071280 1443  
335818 5071271 1443  5071267 1441  5071258 1441  5071243 1441  5071229 1441  5071205 1441  
335819 5071191 1441  5071167 1441  5071143 1441  5071124 1441  5071091 1441  5071059 1439  
335820 5071035 1439  5071005 1441  5070977 1439  5070944 1439  5070915 1439  5070880 1441  
335821 5070852 1441  5070825 1439  5070790 1441  5070758 1439  5070737 1441  5070704 1441  
335822 5070680 1441  5070657 1439  5070638 1439  5070624 1439  5070598 1441  5070580 1441  
335823 5070575 1441  5070556 1441  5070551 1441  5070541 1441  5070536 1441  5070536 1441  
335824 5070532 1441  5070535 1443  5070536 1441  5070540 1443  5070549 1443  5070564 1443  
335825 5070578 1443  5070589 1441  5070608 1441  5070621 1443  5070640 1443  5070654 1443  
335826 5070678 1443  5070702 1443  5070731 1443  5070750 1443  5070774 1443  5070798 1443  
335827 5070826 1443  5070850 1443  5070874 1443  5070898 1443  5070927 1443  5070945 1443  
335828 5070974 1443  5070998 1443  5071012 1443  5071031 1443  5071046 1443  5071075 1443  
335829 5071089 1443  5071103 1443  5071113 1443  5071127 1443  5071132 1443  5071141 1443  
335830 5071141 1443  5071146 1443  5071148 1441  5071141 1443  5071143 1441  5071141 1443  
335831 5071133 1441  5071127 1443  5071122 1443  5071103 1443  5071089 1443  5071076 1441  
335832 5071067 1441  5071047 1441  5071032 1443  5071014 1441  5071000 1441  5070980 1441  
335833 5070966 1441  5070947 1441  5070928 1441  5070914 1441  5070899 1441  5070874 1443  
335834 5070857 1441  5070842 1441  5070828 1441  5070813 1441  5070799 1441  5070780 1441  
335835 5070774 1443  5070764 1443  5070756 1441  5070750 1443  5070752 1441  5070752 1441  
335836 5070751 1441  5070750 1443  5070756 1441  5070756 1441  5070764 1443  5070774 1443  
335837 5070777 1445  5070798 1443  5070812 1443  5070826 1443  5070840 1443  5070855 1443  
335838 5070872 1445  5070888 1443  5070901 1445  5070927 1443  5070947 1441  5070974 1443  
335839 5070998 1443  5071014 1441  5071043 1441  5071067 1441  5071089 1443  5071103 1443  
335840 5071127 1443  5071146 1443  5071167 1441  5071181 1441  5071199 1443  5071213 1443  
335841 5071223 1443  5071229 1441  5071234 1441  5071243 1441  5071248 1441  5071248 1441  
335842 5071248 1441  5071247 1443  5071248 1441  5071243 1441  5071232 1443  5071228 1443  
335843 5071215 1441  5071200 1441  5071180 1443  5071167 1441  5071143 1441  5071123 1443  
335844 5071100 1441  5071076 1441  5071049 1439  5071028 1441  5071000 1441  5070968 1439  
335845 5070944 1439  5070914 1441  5070880 1441  5070858 1439  5070829 1439  5070805 1439  
335846 5070775 1441  5070752 1441  5070724 1439  5070705 1439  5070681 1439  5070659 1437  
335847 5070638 1439  5070624 1439  5070610 1439  5070591 1439  5070581 1439  5070568 1437  
335848 5070568 1437  5070557 1439  5070552 1439  5070552 1439  5070552 1439  5070552 1439  
335849 5070552 1439  5070557 1439  5070567 1439  5070581 1439  5070600 1439  5070609 1439  
335850 5070615 1439  5070632 1441  5070643 1439  5070665 1441  5070681 1439  5070699 1441  
335851 5070723 1441  5070739 1439  5070758 1439  5070782 1439  5070805 1439  5070828 1441  
335852 5070853 1439  5070878 1437  5070899 1441  5070915 1439  5070934 1439  5070958 1439  
335853 5070977 1439  5070993 1437  5071006 1439  5071030 1439  5071044 1439  5071049 1439  
335854 5071068 1439  5071078 1439  5071084 1437  5071092 1439  5071092 1439  5071094 1437  
335855 5071102 1439  5071092 1439  5071092 1439  5071084 1437  5071084 1437  5071079 1437  
335856 5071068 1439  5071049 1439  5071046 1437  5071036 1437  5071027 1437  5071017 1437  
335857 5071003 1437  5070984 1437  5070969 1437  5070950 1437  5070936 1437  5070926 1437  
335858 5070902 1437  5070884 1437  5070869 1437  5070855 1437  5070840 1437  5070826 1437  
335859 5070807 1437  5070802 1437  5070793 1437  5070778 1437  5070769 1437  5070759 1437  
335860 5070758 1439  5070755 1437  5070755 1437  5070755 1437  5070755 1437  5070755 1437  
335861 5070755 1437  5070759 1437  5070767 1439  5070778 1437  5070783 1437  5070802 1437  
335862 5070807 1437  5070826 1437  5070840 1437  5070844 1439  5070869 1437  5070884 1437  
335863 5070902 1437  5070926 1437  5070945 1437  5070969 1437  5070984 1437  5071008 1437  
335864 5071031 1437  5071046 1437  5071070 1437  5071084 1437  5071106 1439  5071126 1439  
335865 5071137 1437  5071146 1437  5071161 1437  5071173 1439  5071183 1439  5071192 1439  
335866 5071203 1437  5071202 1439  5071207 1439  5071208 1437  5071207 1439  5071207 1439  
335867 5071202 1439  5071194 1437  5071183 1439  5071173 1439  5071159 1439  5071146 1437  
335868 5071132 1437  5071116 1439  5071094 1437  5071079 1437  5071050 1437  5071035 1439  
335869 5071015 1439  5070984 1437  5070958 1439  5070936 1437  5070917 1437  5070892 1439  
335870 5070869 1437  5070839 1439  5070817 1437  5070793 1437  5070777 1439  5070755 1437  
335871 5070735 1437  5070707 1437  5070683 1437  5070668 1437  5070654 1437  5070640 1437  
335872 5070626 1437  5070614 1434  5070602 1437  5070595 1434  5070583 1437  5070578 1437  
335873 5070581 1434  5070578 1437  5070581 1434  5070578 1437  5070581 1434  5070583 1437  
335874 5070592 1437  5070602 1437  5070611 1437  5070624 1439  5070635 1437  5070638 1439  
335875 5070654 1437  5070668 1437  5070681 1439  5070700 1439  5070724 1439  5070740 1437  
335876 5070758 1439  5070777 1439  5070802 1437  5070826 1437  5070840 1437  5070858 1439  
335877 5070877 1439  5070903 1437  5070917 1437  5070931 1437  5070950 1437  5070969 1437  
335878 5070984 1437  5070993 1437  5071007 1437  5071017 1437  5071027 1437  5071032 1437  
335879 5071036 1437  5071044 1439  5071044 1439  5071051 1437  5071050 1437  5071060 1437  
335880 5071050 1437  5071051 1437  5071051 1437  5071046 1437  5071036 1437  5071036 1437  
335881 5071027 1437  5071015 1439  5071008 1437  5071003 1437  5070993 1437  5070979 1437  
335882 5070969 1437  5070950 1437  5070945 1437  5070931 1437  5070917 1437  5070901 1439  
335883 5070884 1437  5070869 1437  5070860 1437  5070848 1434  5070840 1437  5070829 1434  
335884 5070817 1437  5070807 1437  5070807 1437  5070802 1437  5070801 1439  5070791 1439  
335885 5070793 1437  5070793 1437  5070793 1437  5070791 1439  5070791 1439  5070802 1437  
335886 5070805 1439  5070815 1439  5070826 1437  5070829 1439  5070839 1439  5070853 1439  
335887 5070860 1437  5070877 1439  5070892 1439  5070907 1437  5070926 1437  5070944 1439  
335888 5070958 1439  5070979 1437  5070993 1437  5071007 1437  5071025 1439  5071036 1437  
335889 5071050 1437  5071079 1437  5071092 1439  5071106 1439  5071117 1437  5071130 1439  
335890 5071137 1437  5071149 1439  5071159 1439  5071168 1439  5071175 1437  5071175 1437  
335891 5071184 1437  5071183 1439  5071175 1437  5071175 1437  5071175 1437  5071170 1437  
335892 5071159 1439  5071151 1437  5071146 1437  5071130 1439  5071125 1439  5071108 1437  
335893 5071094 1437  5071078 1439  5071060 1437  5071035 1439  5071025 1439  5071003 1437  
335894 5070979 1437  5070951 1437  5070934 1439  5070917 1437  5070902 1437  5070879 1437  
335895 5070855 1437  5070839 1439  5070817 1437  5070793 1437  5070769 1437  5070755 1437  
335896 5070740 1437  5070715 1439  5070705 1439  5070683 1437  5070676 1439  5070667 1439  
335897 5070654 1437  5070644 1437  5070638 1439  5070638 1439  5070633 1439  5070634 1439  
335898 5070633 1439  5070634 1439  5070634 1439  5070640 1437  5070638 1439  5070644 1437  
335899 5070643 1439  5070653 1439  5070659 1437  5070667 1439  5070683 1437  5070700 1439  
335900 5070705 1439  5070724 1439  5070738 1439  5070759 1437  5070777 1439  5070793 1437  
335901 5070807 1437  5070825 1439  5070845 1437  5070858 1439  5070877 1439  5070892 1439  
335902 5070906 1439  5070925 1439  5070934 1439  5070949 1439  5070958 1439  5070977 1439  
335903 5070982 1439  5071000 1441  5071006 1439  5071015 1439  5071024 1441  5071030 1439  
335904 5071033 1441  5071044 1439  5071044 1439  5071049 1439  5071049 1439  5071043 1441  
335905 5071044 1439  5071044 1439  5071044 1439  5071033 1441  5071030 1439  5071025 1439  
335906 5071015 1439  5071006 1439  5071000 1441  5070990 1441  5070977 1439  5070968 1439  
335907 5070958 1439  5070944 1439  5070930 1439  5070925 1439  5070915 1439  5070901 1439  
335908 5070893 1437  5070884 1437  5070877 1439  5070860 1437  5070853 1439  5070844 1439  
335909 5070840 1437  5070831 1437  5070829 1439  5070825 1439  5070826 1437  5070815 1439  
335910 5070817 1437  5070815 1439  5070825 1439  5070825 1439  5070831 1437  5070829 1439  
335911 5070845 1437  5070844 1439  5070855 1437  5070868 1439  5070877 1439  5070882 1439  
335912 5070901 1439  5070907 1437  5070925 1439  5070935 1439  5070949 1439  5070966 1441  
335913 5070982 1439  5071000 1441  5071015 1439  5071028 1441  5071035 1439  5071049 1439  
335914 5071068 1439  5071081 1441  5071100 1441  5071105 1441  5071114 1441  5071124 1441  
335915 5071134 1441  5071143 1441  5071148 1441  5071158 1441  5071157 1441  5071159 1439  
335916 5071157 1441  5071157 1441  5071157 1441  5071148 1441  5071149 1439  5071143 1441  
335917 5071135 1439  5071130 1439  5071117 1437  5071108 1437  5071097 1434  5071082 1434  
335918 5071074 1432  5071055 1432  5071041 1432  5071031 1432  5071007 1432  5070988 1432  
335919 5070974 1432  5070955 1432  5070936 1432  5070922 1432  5070898 1432  5070883 1432  
335920 5070864 1432  5070850 1432  5070831 1432  5070811 1432  5070797 1432  5070782 1434  
335921 5070762 1434  5070748 1434  5070743 1434  5070738 1434  5070719 1434  5070710 1434  
335922 5070705 1434  5070695 1434  5070686 1434  5070686 1434  5070681 1434  5070681 1434  
335923 5070672 1434  5070681 1434  5070681 1434  5070678 1437  5070681 1434  5070686 1434  
335924 5070695 1434  5070696 1434  5070705 1434  5070719 1434  5070729 1434  5070743 1434  
335925 5070748 1434  5070764 1432  5070769 1437  5070786 1434  5070805 1434  5070817 1437  
335926 5070834 1434  5070849 1434  5070860 1437  5070878 1437  5070893 1437  5070905 1434  
335927 5070917 1437  5070934 1434  5070948 1434  5070954 1434  5070969 1437  5070984 1437  
335928 5070993 1437  5071003 1437  5071017 1437  5071027 1437  5071035 1434  5071036 1437  
335929 5071049 1434  5071046 1437  5071051 1437  5071050 1437  5071050 1437  5071050 1437  
335930 5071051 1437  5071046 1437  5071049 1434  5071036 1437  5071035 1439  5071032 1437  
335931 5071027 1437  5071015 1439  5071006 1439  5071001 1439  5070992 1439  5070984 1437  
335932 5070968 1439  5070958 1439  5070949 1439  5070944 1439  5070930 1439  5070925 1439  
335933 5070915 1439  5070906 1439  5070901 1439  5070882 1439  5070877 1439  5070866 1441  
335934 5070868 1439  5070857 1441  5070852 1441  5070852 1441  5070842 1441  5070844 1439  
335935 5070844 1439  5070842 1441  5070853 1439  5070853 1439  5070853 1439  5070857 1441  
335936 5070868 1439  5070868 1439  5070877 1439  5070880 1441  5070891 1439  5070899 1441  
335937 5070904 1441  5070923 1441  5070930 1439  5070944 1439  5070947 1441  5070966 1441  
335938 5070976 1441  5070990 1441  5071004 1441  5071014 1441  5071035 1439  5071044 1439  
335939 5071047 1441  5071067 1441  5071081 1441  5071091 1441  5071103 1443  5071114 1441  
335940 5071124 1441  5071129 1441  5071129 1441  5071133 1441  5071134 1441  5071141 1443  
335941 5071143 1441  5071143 1441  5071143 1441  5071143 1441  5071141 1443  5071133 1441  
335942 5071133 1441  5071129 1441  5071123 1443  5071113 1443  5071103 1443  5071089 1443  
335943 5071081 1441  5071065 1443  5071046 1443  5071041 1443  5071024 1441  5071005 1441  
335944 5070990 1441  5070976 1441  5070957 1441  5070933 1441  5070926 1437  5070910 1434  
335945 5070888 1432  5070877 1428  5070853 1428  5070838 1428  5070824 1428  5070810 1428  
335946 5070792 1426  5070779 1424  5070770 1424  5070759 1420  5070751 1424  5070737 1424  
335947 5070727 1424  5070718 1424  5070717 1424  5070713 1424  5070711 1426  5070701 1426  
335948 5070700 1428  5070700 1428  5070700 1428  5070700 1428  5070700 1428  5070709 1428  
335949 5070715 1428  5070715 1428  5070724 1428  5070733 1428  5070743 1428  5070753 1428  
335950 5070762 1428  5070776 1428  5070786 1428  5070800 1428  5070815 1428  5070824 1428  
335951 5070839 1428  5070853 1428  5070867 1428  5070886 1428  5070901 1428  5070915 1428  
335952 5070934 1428  5070944 1428  5070958 1428  5070975 1430  5070990 1430  5071009 1430  
335953 5071012 1432  5071023 1430  5071036 1432  5071042 1430  5071052 1430  5071055 1432  
335954 5071066 1430  5071077 1428  5071077 1428  5071077 1428  5071077 1428  5071077 1428  
335955 5071077 1428  5071077 1428  5071068 1428  5071069 1426  5071058 1428  5071058 1428  
335956 5071055 1426  5071045 1426  5071041 1426  5071036 1426  5071018 1424  5071012 1426  
335957 5071004 1424  5070994 1424  5070980 1424  5070961 1424  5070956 1424  5070946 1424  
335958 5070937 1424  5070928 1424  5070917 1420  5070907 1420  5070899 1419  5070892 1420  
335959 5070885 1419  5070875 1419  5070875 1419  5070868 1420  5070859 1420  5070861 1419  
335960 5070856 1419  5070854 1420  5070856 1419  5070856 1419  5070854 1420  5070854 1420  
335961 5070859 1420  5070861 1419  5070869 1420  5070873 1420  5070883 1420  5070892 1420  
335962 5070894 1424  5070904 1424  5070918 1424  5070926 1426  5070940 1426  5070945 1426  
335963 5070958 1428  5070977 1428  5070987 1428  5071001 1428  5071015 1428  5071034 1428  
335964 5071039 1428  5071054 1428  5071058 1428  5071077 1428  5071090 1430  5071101 1428  
335965 5071115 1428  5071116 1428  5071133 1430  5071138 1430  5071141 1432  5071141 1432  
335966 5071151 1432  5071156 1432  5071156 1432  5071156 1432  5071156 1432  5071156 1432  
335967 5071149 1434  5071140 1434  5071141 1432  5071136 1432  5071130 1434  5071111 1434  
335968 5071108 1432  5071097 1434  5071082 1434  5071060 1437  5071054 1434  5071036 1437  
335969 5071017 1437  5071003 1437  5070984 1437  5070969 1437  5070945 1437  5070931 1437  
335970 5070917 1437  5070902 1437  5070878 1437  5070860 1437  5070845 1437  5070829 1439  
335971 5070817 1437  5070807 1437  5070791 1439  5070777 1439  5070758 1439  5070753 1439  
335972 5070743 1439  5070734 1439  5070724 1439  5070723 1441  5070713 1441  5070715 1439  
335973 5070715 1439  5070705 1439  5070713 1441  5070715 1439  5070713 1441  5070724 1439  
335974 5070723 1441  5070732 1441  5070737 1441  5070743 1439  5070751 1441  5070766 1441  
335975 5070775 1441  5070788 1443  5070804 1441  5070813 1441  5070828 1441  5070842 1441  
335976 5070857 1441  5070875 1441  5070898 1443  5070912 1443  5070928 1441  5070942 1441  
335977 5070957 1441  5070979 1443  5071000 1441  5071004 1441  5071024 1441  5071033 1441  
335978 5071043 1441  5071057 1441  5071078 1439  5071081 1441  5071091 1441  5071100 1441  
335979 5071105 1441  5071106 1439  5071108 1437  5071111 1434  5071114 1430  5071111 1428  
335980 5071114 1424  5071107 1420  5071109 1419  5071101 1417  5071101 1417  5071096 1417  
335981 5071085 1419  5071075 1419  5071061 1419  5071050 1420  5071047 1419  5071032 1419  
335982 5071024 1417  5071001 1417  5070996 1417  5070978 1415  5070967 1411  5070953 1411  
335983 5070948 1411  5070930 1409  5070916 1409  5070902 1409  5070886 1405  5070881 1405  
335984 5070871 1405  5070857 1405  5070854 1403  5070844 1404  5070834 1404  5070820 1404  
335985 5070820 1404  5070810 1403  5070806 1403  5070806 1404  5070806 1404  5070806 1403  
335986 5070806 1404  5070811 1404  5070811 1404  5070820 1403  5070830 1403  5070834 1403  
335987 5070844 1403  5070858 1404  5070868 1404  5070873 1404  5070887 1404  5070897 1403  
335988 5070911 1404  5070930 1403  5070944 1404  5070957 1405  5070971 1405  5070983 1409  
335989 5071005 1405  5071019 1405  5071031 1409  5071049 1409  5071059 1409  5071072 1411  
335990 5071091 1411  5071101 1411  5071113 1413  5071123 1413  5071128 1413  5071147 1413  
335991 5071151 1413  5071151 1413  5071157 1413  5071158 1411  5071157 1413  5071156 1413  
335992 5071158 1411  5071153 1411  5071153 1411  5071148 1411  5071139 1411  5071129 1411  
335993 5071125 1411  5071104 1413  5071091 1411  5071072 1411  5071066 1413  5071048 1411  
335994 5071027 1413  5071014 1411  5070999 1413  5070970 1413  5070956 1413  5070946 1413  
335995 5070921 1415  5070903 1413  5070879 1413  5070865 1413  5070846 1413  5070825 1415  
335996 5070812 1413  5070797 1415  5070777 1415  5070763 1415  5070754 1415  5070735 1415  
335997 5070725 1415  5070719 1417  5070709 1417  5070701 1415  5070695 1417  5070695 1417  
335998 5070687 1415  5070685 1417  5070684 1419  5070684 1419  5070693 1419  5070693 1419  
335999 5070698 1419  5070708 1419  5070722 1419  5070732 1419  5070751 1419  5070760 1419  
336000 5070770 1419  5070784 1419  5070808 1419  5070822 1419  5070844 1420  5070870 1419  
336001 5070883 1420  5070899 1419  5070921 1420  5070946 1419  5070961 1419  5070983 1420  
336002 5071007 1420  5071019 1424  5071037 1424  5071057 1424  5071071 1424  5071088 1426  
336003 5071103 1426  5071117 1426  5071125 1428  5071139 1428  5071144 1428  5071154 1428  
336004 5071159 1428  5071168 1428  5071167 1430  5071178 1428  5071176 1430  5071176 1430  
336005 5071168 1428  5071168 1428  5071159 1428  5071154 1428  5071139 1428  5071135 1428  
336006 5071115 1428  5071103 1426  5071093 1420  5071075 1419  5071064 1415  5071045 1415  
336007 5071029 1411  5071016 1409  5070995 1405  5070978 1404  5070959 1404  5070944 1404  
336008 5070921 1404  5070908 1402  5070889 1402  5070874 1402  5070860 1402  5070836 1402  
336009 5070822 1402  5070812 1402  5070796 1403  5070788 1402  5070774 1402  5070768 1403  
336010 5070763 1404  5070753 1404  5070753 1404  5070744 1403  5070744 1403  5070744 1403  
336011 5070752 1405  5070753 1404  5070761 1405  5070766 1405  5070772 1404  5070787 1404  
336012 5070795 1405  5070809 1405  5070830 1404  5070842 1405  5070857 1405  5070871 1405  
336013 5070886 1405  5070904 1405  5070929 1405  5070950 1409  5070971 1405  5070983 1409  
336014 5071007 1409  5071026 1409  5071050 1409  5071059 1409  5071083 1409  5071110 1405  
336015 5071129 1405  5071145 1404  5071153 1405  5071163 1405  5071178 1403  5071188 1403  
336016 5071198 1404  5071202 1404  5071212 1403  5071212 1404  5071210 1405  5071221 1403  
336017 5071221 1403  5071212 1404  5071212 1404  5071202 1404  5071188 1403  5071178 1403  
336018 5071164 1403  5071155 1403  5071135 1404  5071121 1403  5071107 1403  5071078 1403  
336019 5071064 1403  5071046 1402  5071021 1404  5070998 1402  5070974 1402  5070956 1402  
336020 5070933 1400  5070909 1400  5070890 1400  5070869 1402  5070855 1402  5070833 1400  
336021 5070807 1402  5070788 1402  5070775 1400  5070764 1402  5070745 1402  5070731 1402  
336022 5070723 1400  5070707 1402  5070699 1400  5070688 1402  5070688 1402  5070685 1400  
336023 5070683 1402  5070683 1402  5070688 1402  5070688 1402  5070698 1402  5070707 1402  
336024 5070722 1402  5070736 1402  5070747 1400  5070764 1402  5070784 1402  5070798 1402  
336025 5070822 1402  5070836 1402  5070858 1404  5070884 1402  5070908 1402  5070932 1402  
336026 5070956 1402  5070965 1402  5070989 1402  5071013 1402  5071035 1404  5071065 1402  
336027 5071080 1402  5071108 1402  5071123 1402  5071146 1402  5071159 1404  5071174 1403  
336028 5071188 1404  5071202 1404  5071222 1404  5071231 1404  5071236 1404  5071245 1404  
336029 5071245 1404  5071255 1404  5071255 1404  5071255 1404  5071245 1403  5071245 1404  
336030 5071236 1404  5071231 1404  5071212 1404  5071202 1404  5071190 1402  5071177 1400  
336031 5071156 1402  5071138 1400  5071116 1398  5071092 1398  5071078 1398  5071060 1396  
336032 5071036 1396  5071013 1396  5070979 1396  5070959 1398  5070936 1396  5070912 1396  
336033 5070890 1394  5070866 1394  5070842 1394  5070829 1392  5070804 1394  5070780 1394  
336034 5070770 1394  5070752 1394  5070728 1394  5070713 1394  5070704 1394  5070689 1394  
336035 5070680 1394  5070680 1394  5070675 1394  5070670 1394  5070670 1394  5070675 1394  
336036 5070675 1394  5070680 1394  5070689 1394  5070704 1394  5070711 1396  5070726 1396  
336037 5070742 1394  5070769 1396  5070780 1394  5070804 1394  5070818 1394  5070842 1394  
336038 5070874 1396  5070893 1396  5070919 1394  5070951 1396  5070971 1394  5071003 1396  
336039 5071028 1394  5071051 1396  5071079 1396  5071103 1396  5071129 1394  5071153 1394  
336040 5071165 1396  5071186 1394  5071204 1396  5071220 1394  5071239 1394  5071243 1394  
336041 5071264 1392  5071267 1394  5071274 1392  5071272 1394  5071274 1392  5071274 1392  
336042 5071275 1390  5071270 1390  5071264 1392  5071256 1390  5071245 1392  5071223 1390  
336043 5071213 1390  5071188 1392  5071173 1392  5071156 1390  5071132 1390  5071108 1390  
336044 5071084 1390  5071066 1388  5071042 1388  5071007 1390  5070985 1388  5070965 1390  
336045 5070942 1388  5070909 1388  5070885 1388  5070866 1388  5070842 1388  5070820 1387  
336046 5070799 1388  5070780 1388  5070767 1387  5070748 1387  5070724 1387  5070718 1388  
336047 5070700 1387  5070695 1387  5070686 1387  5070686 1387  5070681 1387  5070679 1388  
336048 5070686 1387  5070694 1388  5070695 1387  5070708 1388  5070719 1387  5070732 1388  
336049 5070746 1388  5070766 1388  5070786 1387  5070799 1388  5070823 1388  5070842 1388  
336050 5070866 1388  5070885 1388  5070918 1388  5070942 1388  5070965 1390  5070990 1388  
336051 5071017 1390  5071041 1390  5071070 1390  5071089 1390  5071122 1390  5071144 1392  
336052 5071168 1392  5071188 1392  5071210 1394  5071231 1392  5071245 1392  5071267 1394  
336053 5071273 1392  5071286 1394  5071296 1394  5071308 1396  5071308 1396  5071318 1396  
336054 5071318 1396  5071318 1396  5071310 1394  5071310 1394  5071294 1396  5071286 1394  
336055 5071272 1394  5071264 1392  5071243 1394  5071231 1392  5071207 1392  5071184 1390  
336056 5071165 1390  5071132 1390  5071109 1388  5071076 1388  5071057 1388  5071025 1387  
336057 5070992 1387  5070958 1387  5070923 1388  5070895 1388  5070867 1387  5070834 1387  
336058 5070799 1388  5070781 1387  5070748 1387  5070724 1387  5070694 1388  5070679 1388  
336059 5070656 1388  5070641 1388  5070618 1388  5070598 1388  5070594 1388  5070584 1388  
336060 5070573 1390  5070574 1388  5070574 1388  5070574 1388  5070576 1387  5070579 1388  
336061 5070586 1387  5070594 1388  5070609 1387  5070624 1387  5070652 1387  5070667 1387  
336062 5070686 1387  5070710 1387  5070743 1387  5070766 1388  5070796 1387  5070824 1387  
336063 5070858 1387  5070887 1387  5070920 1387  5070948 1387  5070977 1387  5071011 1387  
336064 5071043 1388  5071076 1388  5071100 1388  5071133 1388  5071167 1388  5071176 1388  
336065 5071211 1387  5071224 1388  5071245 1387  5071269 1387  5071276 1388  5071288 1387  
336066 5071300 1388  5071302 1387  5071313 1385  5071316 1387  5071316 1387  5071311 1387  
336067 5071302 1387  5071294 1385  5071289 1385  5071275 1385  5071261 1385  5071237 1385  
336068 5071217 1385  5071194 1385  5071176 1383  5071152 1383  5071128 1383  5071095 1383  
336069 5071076 1383  5071052 1383  5071023 1383  5070990 1383  5070969 1385  5070945 1385  
336070 5070912 1385  5070887 1387  5070856 1388  5070832 1388  5070808 1388  5070783 1390  
336071 5070762 1392  5070743 1392  5070729 1392  5070715 1392  5070696 1392  5070689 1394  
336072 5070680 1394  5070675 1394  5070675 1394  5070675 1394  5070675 1394  5070675 1394  
336073 5070680 1394  5070694 1394  5070705 1392  5070720 1392  5070739 1392  5070755 1390  
336074 5070778 1390  5070793 1390  5070817 1390  5070842 1388  5070870 1388  5070894 1388  
336075 5070918 1388  5070947 1388  5070977 1387  5071007 1390  5071042 1388  5071071 1388  
336076 5071089 1390  5071122 1390  5071156 1390  5071176 1388  5071208 1390  5071234 1388  
336077 5071256 1390  5071275 1390  5071291 1388  5071313 1390  5071323 1390  5071337 1390  
336078 5071356 1390  5071367 1388  5071371 1390  5071371 1390  5071371 1390  5071371 1390  
336079 5071371 1390  5071366 1390  5071358 1388  5071337 1390  5071332 1390  5071313 1390  
336080 5071290 1390  5071269 1392  5071246 1390  5071221 1392  5071188 1392  5071164 1392  
336081 5071129 1394  5071087 1392  5071063 1392  5071021 1392  5070982 1392  5070954 1392  
336082 5070915 1392  5070879 1390  5070842 1388  5070800 1387  5070767 1387  5070735 1385  
336083 5070697 1385  5070670 1383  5070648 1381  5070614 1381  5070590 1381  5070561 1381  
336084 5070547 1381  5070523 1381  5070506 1379  5070491 1379  5070487 1379  5070485 1375  
336085 5070472 1379  5070472 1379  5070472 1379  5070472 1379  5070490 1375  5070494 1375  
336086 5070509 1375  5070528 1375  5070552 1375  5070576 1375  5070595 1375  5070619 1375  
336087 5070652 1375  5070686 1375  5070709 1375  5070743 1375  5070783 1379  5070811 1373  
336088 5070845 1373  5070881 1375  5070910 1375  5070953 1375  5070986 1375  5071020 1375  
336089 5071058 1375  5071087 1375  5071120 1375  5071150 1379  5071179 1379  5071198 1379  
336090 5071221 1381  5071251 1379  5071275 1379  5071284 1379  5071294 1379  5071308 1379  
336091 5071321 1375  5071321 1375  5071323 1379  5071323 1379  5071318 1379  5071308 1379  
336092 5071297 1381  5071284 1379  5071275 1379  5071256 1379  5071244 1375  5071221 1375  
336093 5071198 1373  5071177 1375  5071155 1373  5071122 1373  5071088 1373  5071069 1373  
336094 5071034 1375  5071002 1373  5070978 1373  5070943 1375  5070911 1373  5070883 1373  
336095 5070854 1373  5070830 1373  5070795 1375  5070778 1373  5070754 1373  5070730 1373  
336096 5070711 1373  5070692 1373  5070687 1373  5070668 1373  5070663 1373  5070654 1373  
336097 5070644 1373  5070644 1373  5070644 1373  5070654 1373  5070663 1373  5070668 1373  
336098 5070676 1375  5070692 1373  5070706 1373  5070720 1373  5070743 1375  5070768 1373  
336099 5070792 1373  5070810 1375  5070843 1375  5070869 1373  5070896 1375  5070931 1373  
336100 5070959 1373  5070987 1375  5071020 1375  5071050 1379  5071082 1375  5071107 1379  
336101 5071139 1381  5071174 1379  5071197 1381  5071221 1381  5071254 1381  5071278 1381  
336102 5071297 1381  5071321 1381  5071339 1383  5071353 1383  5071370 1385  5071377 1383  
336103 5071390 1385  5071390 1385  5071394 1385  5071388 1387  5071388 1387  5071377 1388  
336104 5071372 1388  5071359 1387  5071335 1387  5071316 1387  5071296 1383  5071272 1383  
336105 5071248 1383  5071216 1381  5071182 1381  5071154 1381  5071116 1381  5071079 1379  
336106 5071041 1379  5070998 1379  5070964 1379  5070926 1379  5070878 1379  5070843 1375  
336107 5070802 1379  5070764 1379  5070726 1379  5070687 1379  5070649 1379  5070606 1379  
336108 5070585 1375  5070552 1375  5070518 1375  5070490 1375  5070466 1375  5070442 1375  
336109 5070429 1373  5070408 1375  5070399 1375  5070391 1373  5070385 1375  5070375 1375  
336110 5070375 1375  5070375 1375  5070385 1375  5070399 1375  5070410 1373  5070428 1375  
336111 5070439 1379  5070472 1379  5070494 1375  5070528 1375  5070549 1379  5070581 1381  
336112 5070609 1375  5070648 1381  5070687 1379  5070724 1381  5070753 1381  5070791 1381  
336113 5070829 1381  5070872 1381  5070905 1381  5070948 1381  5070992 1381  5071025 1381  
336114 5071063 1381  5071092 1381  5071125 1381  5071152 1383  5071181 1383  5071206 1381  
336115 5071229 1383  5071248 1383  5071262 1383  5071278 1381  5071292 1381  5071297 1381  
336116 5071297 1381  5071297 1381  5071297 1381  5071292 1381  5071292 1381  5071278 1381  
336117 5071273 1381  5071264 1381  5071240 1381  5071222 1379  5071197 1381  5071178 1381  
336118 5071154 1381  5071125 1381  5071097 1381  5071074 1379  5071039 1381  5071006 1381  
336119 5070978 1379  5070950 1379  5070917 1379  5070888 1379  5070858 1375  5070834 1375  
336120 5070802 1379  5070783 1379  5070754 1379  5070730 1379  5070716 1379  5070692 1379  
336121 5070683 1379  5070663 1379  5070659 1379  5070648 1381  5070649 1379  5070638 1381  
336122 5070638 1381  5070638 1381  5070649 1379  5070649 1379  5070659 1379  5070671 1381  
336123 5070686 1381  5070700 1381  5070715 1381  5070740 1379  5070762 1381  5070791 1381  
336124 5070814 1381  5070840 1379  5070872 1381  5070901 1381  5070929 1381  5070963 1381  
336125 5070996 1381  5071030 1381  5071063 1381  5071092 1381  5071125 1381  5071163 1381  
336126 5071192 1381  5071221 1381  5071249 1381  5071278 1381  5071297 1381  5071321 1381  
336127 5071345 1381  5071364 1381  5071373 1381  5071383 1381  5071393 1381  5071397 1381  
336128 5071397 1381  5071397 1381  5071397 1381  5071393 1381  5071383 1381  5071378 1381  
336129 5071354 1381  5071340 1381  5071316 1381  5071292 1381  5071273 1381  5071240 1381  
336130 5071197 1381  5071173 1381  5071130 1381  5071092 1381  5071054 1381  5071015 1381  
336131 5070977 1381  5070929 1381  5070891 1381  5070853 1381  5070805 1381  5070772 1381  
336132 5070724 1381  5070686 1381  5070649 1379  5070606 1379  5070571 1381  5070539 1379  
336133 5070501 1379  5070472 1379  5070439 1379  5070418 1375  5070396 1379  5070382 1379  
336134 5070362 1379  5070348 1379  5070338 1379  5070334 1379  5070334 1379  5070324 1379  
336135 5070334 1379  5070338 1379  5070351 1375  5070362 1379  5070382 1379  5070401 1379  
336136 5070415 1379  5070439 1379  5070472 1379  5070501 1379  5070528 1381  5070563 1379  
336137 5070592 1379  5070630 1379  5070671 1381  5070705 1381  5070748 1381  5070786 1381  
336138 5070824 1381  5070862 1381  5070905 1381  5070947 1383  5070977 1381  5071015 1381  
336139 5071049 1381  5071082 1381  5071105 1383  5071138 1383  5071162 1383  5071181 1383  
336140 5071205 1383  5071218 1385  5071237 1385  5071248 1383  5071261 1385  5071261 1385  
336141 5071272 1383  5071272 1383  5071262 1383  5071252 1383  5071254 1381  5071238 1383  
336142 5071230 1381  5071216 1381  5071192 1381  5071173 1381  5071149 1381  5071125 1381  
336143 5071096 1381  5071077 1381  5071049 1381  5071025 1381  5070991 1381  5070963 1381  
336144 5070939 1381  5070905 1381  5070877 1381  5070853 1381  5070824 1381  5070800 1381  
336145 5070781 1381  5070753 1381  5070729 1381  5070715 1381  5070700 1381  5070686 1381  
336146 5070671 1381  5070662 1381  5070657 1381  5070648 1381  5070636 1383  5070638 1381  
336147 5070638 1381  5070638 1381  5070648 1381  5070657 1381  5070671 1381  5070686 1381  
336148 5070700 1381  5070724 1381  5070738 1381  5070770 1383  5070791 1381  5070814 1381  
336149 5070846 1383  5070875 1383  5070904 1383  5070937 1383  5070968 1387  5070992 1387  
336150 5071035 1387  5071066 1388  5071100 1388  5071133 1388  5071165 1390  5071200 1388  
336151 5071224 1388  5071256 1390  5071284 1390  5071307 1392  5071321 1392  5071345 1392  
336152 5071366 1390  5071375 1390  5071383 1392  5071391 1388  5071399 1390  5071401 1388  
336153 5071399 1390  5071399 1390  5071391 1388  5071377 1388  5071369 1387  5071353 1383  
336154 5071329 1383  5071307 1381  5071283 1381  5071254 1381  5071221 1381  5071192 1381  
336155 5071163 1381  5071125 1381  5071082 1381  5071049 1381  5071006 1381  5070964 1379  
336156 5070925 1381  5070886 1381  5070838 1381  5070800 1381  5070753 1381  5070716 1379  
336157 5070681 1381  5070638 1381  5070600 1381  5070561 1381  5070528 1381  5070501 1379  
336158 5070471 1381  5070439 1379  5070414 1381  5070394 1381  5070380 1381  5070361 1381  
336159 5070348 1379  5070337 1381  5070338 1379  5070332 1381  5070332 1381  5070332 1381  
336160 5070347 1381  5070347 1381  5070361 1381  5070380 1381  5070393 1383  5070414 1381  
336161 5070437 1381  5070460 1383  5070487 1385  5070522 1383  5070555 1383  5070587 1385  
336162 5070621 1385  5070659 1385  5070696 1387  5070735 1385  5070778 1385  5070800 1387  
336163 5070848 1387  5070887 1387  5070919 1388  5070957 1388  5070989 1390  5071022 1390  
336164 5071054 1392  5071082 1392  5071117 1390  5071140 1392  5071164 1392  5071173 1392  
336165 5071199 1390  5071213 1390  5071231 1392  5071242 1390  5071246 1390  5071246 1390  
336166 5071246 1390  5071240 1392  5071242 1390  5071232 1390  5071213 1390  5071207 1392  
336167 5071189 1390  5071175 1390  5071165 1390  5071140 1392  5071122 1390  5071098 1390  
336168 5071073 1392  5071054 1392  5071022 1390  5070998 1390  5070973 1392  5070945 1390  
336169 5070922 1390  5070893 1390  5070869 1390  5070845 1390  5070817 1390  5070799 1389  
336170 5070778 1390  5070755 1390  5070740 1390  5070718 1388  5070707 1390  5070692 1390  
336171 5070683 1390  5070678 1390  5070673 1390  5070672 1392  5070664 1390  5070664 1390  
336172 5070673 1390  5070678 1390  5070684 1388  5070694 1388  5070708 1388  5070723 1388  
336173 5070746 1388  5070766 1388  5070796 1387  5070810 1387  5070834 1387  5070867 1387  
336174 5070887 1387  5070920 1387  5070948 1387  5070977 1387  5071011 1387  5071050 1385  
336175 5071080 1383  5071114 1383  5071147 1383  5071176 1383  5071206 1381  5071230 1381  
336176 5071264 1381  5071283 1381  5071307 1381  5071332 1379  5071345 1381  5071364 1381  
336177 5071375 1379  5071380 1379  5071387 1375  5071397 1375  5071397 1375  5071397 1375  
336178 5071384 1379  5071383 1375  5071378 1375  5071369 1375  5071349 1375  5071326 1375  
336179 5071303 1373  5071282 1375  5071260 1373  5071225 1375  5071197 1375  5071168 1375  
336180 5071130 1375  5071098 1373  5071058 1375  5071022 1373  5070983 1373  5070943 1375  
336181 5070907 1373  5070867 1375  5070829 1375  5070792 1373  5070754 1373  5070711 1373  
336182 5070687 1373  5070644 1373  5070610 1373  5070587 1373  5070553 1373  5070518 1375  
336183 5070494 1375  5070477 1373  5070452 1375  5070439 1373  5070420 1373  5070404 1375  
336184 5070400 1373  5070391 1373  5070386 1373  5070386 1373  5070386 1373  5070391 1373  
336185 5070399 1375  5070404 1375  5070408 1375  5070429 1373  5070443 1373  5070466 1375  
336186 5070487 1373  5070504 1375  5070534 1373  5070566 1375  5070590 1375  5070619 1375  
336187 5070654 1373  5070687 1373  5070719 1375  5070752 1375  5070788 1379  5070821 1373  
336188 5070858 1375  5070888 1379  5070920 1375  5070953 1375  5070981 1375  5071010 1375  
336189 5071034 1375  5071068 1375  5071083 1379  5071101 1375  5071127 1379  5071144 1375  
336190 5071158 1375  5071168 1375  5071177 1375  5071182 1375  5071187 1375  5071184 1379  
336191 5071182 1375  5071182 1375  5071177 1375  5071179 1373  5071160 1373  5071154 1375  
336192 5071136 1373  5071122 1373  5071103 1373  5071087 1375  5071068 1375  5071044 1375  
336193 5071029 1375  5071002 1373  5070983 1373  5070959 1373  5070934 1375  5070911 1373  
336194 5070892 1373  5070868 1373  5070845 1373  5070821 1373  5070797 1373  5070787 1373  
336195 5070759 1373  5070744 1373  5070732 1372  5070711 1373  5070706 1373  5070697 1373  
336196 5070692 1373  5070693 1372  5070687 1373  5070689 1372  5070687 1373  5070687 1373  
336197 5070690 1375  5070697 1373  5070706 1373  5070721 1373  5070728 1375  5070744 1373  
336198 5070764 1379  5070783 1379  5070802 1379  5070829 1375  5070853 1375  5070873 1379  
336199 5070893 1379  5070926 1379  5070950 1379  5070978 1379  5071007 1379  5071039 1381  
336200 5071065 1379  5071092 1381  5071116 1381  5071150 1379  5071173 1381  5071192 1381  
336201 5071216 1381  5071240 1381  5071254 1381  5071273 1381  5071283 1381  5071297 1381  
336202 5071307 1381  5071316 1381  5071321 1381  5071321 1381  5071321 1381  5071316 1381  
336203 5071316 1381  5071307 1381  5071297 1381  5071283 1381  5071273 1381  5071254 1381  
336204 5071240 1381  5071216 1381  5071182 1381  5071163 1381  5071139 1381  5071106 1381  
336205 5071077 1381  5071048 1381  5071006 1381  5070977 1381  5070948 1381  5070905 1381  
336206 5070877 1381  5070838 1381  5070815 1381  5070781 1381  5070748 1381  5070714 1381  
336207 5070686 1381  5070657 1381  5070628 1381  5070600 1381  5070581 1381  5070555 1383  
336208 5070528 1381  5070504 1381  5070490 1381  5070480 1381  5070460 1383  5070457 1381  
336209 5070436 1383  5070437 1381  5070433 1381  5070432 1381  5070437 1381  5070437 1381  
336210 5070447 1381  5070457 1381  5070461 1381  5070480 1381  5070488 1383  5070504 1381  
336211 5070523 1381  5070546 1383  5070571 1381  5070589 1383  5070613 1383  5070646 1383  
336212 5070679 1383  5070700 1387  5070735 1385  5070759 1385  5070786 1387  5070820 1387  
336213 5070848 1387  5070881 1387  5070910 1387  5070942 1388  5070968 1387  5070987 1387  
336214 5071020 1387  5071044 1387  5071068 1387  5071077 1387  5071092 1387  5071111 1387  
336215 5071125 1387  5071135 1387  5071144 1387  5071149 1387  5071157 1388  5071159 1387  
336216 5071159 1387  5071160 1385  5071149 1387  5071149 1387  5071146 1385  5071135 1387  
336217 5071122 1385  5071111 1387  5071092 1387  5071079 1385  5071068 1387  5071049 1387  
336218 5071025 1387  5071012 1385  5070987 1387  5070972 1387  5070948 1387  5070925 1387  
336219 5070901 1387  5070887 1387  5070867 1387  5070843 1387  5070826 1385  5070811 1385  
336220 5070799 1383  5070785 1383  5070772 1381  5070762 1381  5070753 1381  5070738 1381  
336221 5070730 1379  5070730 1379  5070724 1381  5070725 1379  5070729 1375  5070725 1379  
336222 5070733 1375  5070733 1375  5070749 1379  5070764 1379  5070773 1379  5070791 1375  
336223 5070807 1379  5070829 1375  5070843 1375  5070864 1379  5070878 1379  5070905 1375  
336224 5070926 1379  5070955 1379  5070977 1381  5070996 1381  5071025 1381  5071048 1381  
336225 5071072 1381  5071095 1383  5071124 1383  5071147 1383  5071160 1385  5071179 1385  
336226 5071203 1385  5071217 1385  5071235 1387  5071251 1385  5071270 1385  5071275 1385  
336227 5071279 1385  5071289 1385  5071291 1383  5071288 1387  5071294 1385  5071294 1385  
336228 5071289 1385  5071288 1387  5071275 1385  5071269 1387  5071251 1385  5071235 1387  
336229 5071216 1387  5071202 1387  5071178 1387  5071170 1385  5071144 1387  5071111 1387  
336230 5071087 1387  5071070 1385  5071035 1387  5071012 1385  5070979 1385  5070950 1385  
336231 5070920 1387  5070896 1387  5070874 1385  5070845 1385  5070813 1383  5070785 1383  
336232 5070753 1381  5070729 1381  5070700 1381  5070683 1379  5070657 1381  5070639 1379  
336233 5070614 1381  5070601 1379  5070592 1379  5070582 1379  5070561 1381  5070558 1379  
336234 5070549 1379  5070538 1381  5070538 1381  5070538 1381  5070538 1381  5070538 1381  
336235 5070538 1381  5070547 1381  5070557 1381  5070562 1381  5070581 1381  5070590 1381  
336236 5070605 1381  5070624 1381  5070648 1381  5070671 1381  5070691 1381  5070705 1381  
336237 5070729 1381  5070762 1381  5070785 1383  5070803 1383  5070838 1381  5070862 1381  
336238 5070886 1381  5070905 1381  5070929 1381  5070964 1379  5070978 1379  5071002 1373  
336239 5071031 1373  5071045 1373  5071069 1373  5071085 1372  5071099 1371  5071112 1373  
336240 5071122 1373  5071138 1372  5071147 1372  5071155 1373  5071160 1373  5071160 1373  
336241 5071160 1373  5071160 1373  5071158 1375  5071155 1373  5071147 1371  5071136 1373  
336242 5071133 1372  5071114 1372  5071099 1371  5071091 1370  5071080 1372  5071058 1370  
336243 5071037 1372  5071024 1370  5071005 1370  5070986 1370  5070972 1370  5070948 1370  
336244 5070934 1370  5070913 1372  5070899 1371  5070879 1371  5070861 1372  5070856 1372  
336245 5070837 1372  5070822 1372  5070811 1373  5070806 1373  5070792 1373  5070794 1372  
336246 5070787 1373  5070778 1373  5070778 1373  5070778 1373  5070778 1373  5070776 1375  
336247 5070778 1373  5070786 1375  5070791 1375  5070806 1373  5070811 1373  5070830 1373  
336248 5070835 1373  5070853 1375  5070867 1375  5070881 1375  5070897 1373  5070910 1375  
336249 5070934 1375  5070953 1375  5070977 1375  5070987 1375  5071007 1379  5071026 1379  
336250 5071050 1379  5071065 1379  5071082 1381  5071098 1379  5071117 1379  5071141 1379  
336251 5071155 1379  5071174 1379  5071182 1381  5071192 1381  5071208 1379  5071217 1379  
336252 5071222 1379  5071232 1379  5071232 1379  5071241 1379  5071244 1375  5071235 1375  
336253 5071235 1375  5071227 1373  5071227 1373  5071224 1371  5071214 1371  5071198 1373  
336254 5071184 1373  5071179 1373  5071160 1373  5071137 1371  5071122 1373  5071104 1372  
336255 5071079 1373  5071060 1373  5071036 1373  5071012 1373  5070989 1371  5070969 1373  
336256 5070946 1372  5070923 1372  5070897 1373  5070869 1373  5070845 1373  5070821 1373  
336257 5070797 1373  5070786 1375  5070759 1373  5070735 1373  5070711 1373  5070696 1373  
336258 5070687 1373  5070668 1373  5070654 1373  5070642 1375  5070628 1375  5070620 1373  
336259 5070612 1371  5070607 1372  5070606 1373  5070596 1373  5070595 1375  5070606 1373  
336260 5070606 1373  5070606 1373  5070612 1372  5070620 1373  5070631 1372  5070647 1370  
336261 5070657 1370  5070669 1372  5070690 1370  5070707 1371  5070724 1370  5070736 1372  
336262 5070762 1370  5070781 1370  5070801 1368  5070825 1368  5070848 1370  5070873 1368  
336263 5070897 1368  5070911 1368  5070935 1368  5070961 1366  5070983 1368  5070994 1366  
336264 5071016 1368  5071036 1368  5071050 1368  5071066 1366  5071083 1368  5071094 1366  
336265 5071107 1368  5071117 1368  5071126 1368  5071137 1366  5071140 1368  5071141 1368  
336266 5071139 1370  5071141 1368  5071140 1368  5071141 1368  5071134 1370  5071126 1368  
336267 5071117 1368  5071107 1368  5071094 1366  5071088 1368  5071074 1368  5071061 1366  
336268 5071040 1368  5071026 1368  5071007 1368  5070993 1368  5070975 1366  5070962 1364  
336269 5070941 1366  5070927 1366  5070913 1366  5070900 1364  5070884 1366  5070865 1366  
336270 5070851 1366  5070836 1366  5070827 1366  5070819 1364  5070803 1366  5070800 1364  
336271 5070795 1364  5070784 1366  5070786 1364  5070784 1366  5070786 1364  5070786 1364  
336272 5070786 1364  5070784 1366  5070784 1366  5070800 1364  5070800 1364  5070808 1360  
336273 5070812 1366  5070819 1364  5070829 1364  5070843 1364  5070862 1364  5070865 1366  
336274 5070891 1364  5070905 1364  5070919 1364  5070938 1364  5070951 1366  5070965 1366  
336275 5070986 1364  5071005 1364  5071018 1366  5071038 1364  5071051 1366  5071066 1366  
336276 5071086 1364  5071094 1366  5071110 1364  5071120 1364  5071139 1364  5071151 1366  
336277 5071163 1364  5071167 1364  5071175 1366  5071175 1366  5071185 1366  5071185 1366  
336278 5071187 1364  5071187 1364  5071185 1366  5071187 1364  5071175 1366  5071177 1364  
336279 5071166 1366  5071153 1364  5071142 1366  5071129 1364  5071120 1364  5071105 1364  
336280 5071091 1364  5071075 1366  5071052 1366  5071037 1366  5071008 1366  5070994 1366  
336281 5070973 1368  5070951 1366  5070938 1364  5070913 1366  5070889 1366  5070865 1366  
336282 5070851 1366  5070827 1366  5070812 1366  5070794 1366  5070776 1364  5070751 1366  
336283 5070736 1366  5070727 1366  5070714 1364  5070700 1364  5070693 1366  5070685 1364  
336284 5070675 1364  5070671 1364  5070661 1364  5070652 1364  5070652 1364  5070652 1364  
336285 5070652 1364  5070661 1364  5070671 1364  5070676 1364  5070675 1364  5070695 1364  
336286 5070699 1364  5070714 1364  5070719 1364  5070738 1364  5070752 1364  5070776 1364  
336287 5070794 1366  5070803 1366  5070827 1366  5070852 1364  5070865 1366  5070889 1366  
336288 5070918 1366  5070937 1366  5070967 1364  5070985 1366  5071005 1364  5071018 1366  
336289 5071042 1366  5071062 1364  5071075 1366  5071090 1366  5071104 1366  5071118 1366  
336290 5071129 1364  5071137 1366  5071142 1366  5071152 1366  5071161 1366  5071160 1368  
336291 5071165 1368  5071166 1366  5071161 1366  5071160 1368  5071152 1366  5071142 1366  
336292 5071137 1366  5071128 1366  5071118 1366  5071105 1364  5071091 1364  5071075 1366  
336293 5071066 1366  5071051 1366  5071039 1364  5071018 1366  5070994 1366  5070985 1366  
336294 5070965 1366  5070941 1366  5070938 1364  5070914 1364  5070899 1366  5070891 1364  
336295 5070865 1366  5070862 1364  5070841 1366  5070838 1364  5070817 1366  5070814 1364  
336296 5070800 1364  5070800 1364  5070795 1364  5070786 1364  5070786 1364  5070776 1364  
336297 5070774 1366  5070776 1364  5070776 1364  5070786 1364  5070784 1366  5070795 1364  
336298 5070798 1366  5070800 1364  5070812 1366  5070819 1364  5070829 1364  5070841 1366  
336299 5070853 1364  5070870 1360  5070889 1360  5070900 1364  5070914 1364  5070929 1364  
336300 5070943 1364  5070962 1364  5070986 1364  5070994 1360  5071010 1364  5071029 1364  
336301 5071042 1366  5071062 1364  5071075 1366  5071091 1364  5071105 1364  5071109 1366  
336302 5071120 1364  5071137 1366  5071142 1366  5071151 1366  5071161 1366  5071166 1366  
336303 5071175 1366  5071175 1366  5071176 1366  5071176 1366  5071174 1368  5071174 1368  
336304 5071164 1368  5071161 1366  5071152 1366  5071141 1368  5071128 1366  5071107 1368  
336305 5071102 1368  5071090 1366  5071075 1366  5071061 1366  5071040 1368  5071028 1366  
336306 5071004 1366  5070985 1366  5070965 1366  5070950 1368  5070926 1368  5070911 1368  
336307 5070889 1366  5070865 1366  5070849 1368  5070835 1368  5070811 1368  5070797 1368  
336308 5070784 1366  5070765 1366  5070749 1368  5070735 1368  5070727 1366  5070717 1366  
336309 5070714 1364  5070703 1366  5070698 1366  5070698 1366  5070695 1364  5070693 1366  
336310 5070693 1366  5070698 1366  5070698 1366  5070703 1366  5070712 1366  5070727 1366  
336311 5070736 1366  5070741 1366  5070760 1366  5070774 1366  5070792 1368  5070801 1368  
336312 5070825 1368  5070841 1366  5070859 1368  5070883 1368  5070903 1366  5070916 1368  
336313 5070941 1366  5070964 1368  5070989 1366  5071005 1370  5071026 1368  5071040 1368  
336314 5071064 1368  5071083 1368  5071093 1368  5071107 1368  5071126 1368  5071136 1368  
336315 5071150 1368  5071161 1366  5071160 1368  5071165 1368  5071174 1368  5071174 1368  
336316 5071176 1366  5071165 1368  5071165 1368  5071161 1366  5071150 1368  5071141 1368  
336317 5071136 1368  5071128 1366  5071106 1370  5071093 1368  5071088 1368  5071064 1368  
336318 5071050 1368  5071034 1370  5071015 1370  5071001 1370  5070983 1368  5070964 1368  
336319 5070950 1368  5070926 1368  5070900 1370  5070888 1368  5070862 1370  5070848 1370  
336320 5070833 1370  5070814 1370  5070800 1370  5070795 1370  5070781 1370  5070762 1370  
336321 5070759 1368  5070748 1370  5070735 1368  5070724 1370  5070724 1370  5070714 1370  
336322 5070714 1370  5070714 1370  5070709 1370  5070716 1368  5070714 1370  5070722 1372  
336323 5070724 1370  5070738 1370  5070736 1372  5070758 1368  5070762 1370  5070771 1370  
336324 5070792 1368  5070795 1370  5070809 1370  5070825 1368  5070840 1368  5070864 1368  
336325 5070883 1368  5070897 1368  5070916 1368  5070935 1368  5070950 1368  5070973 1368  
336326 5070983 1368  5071002 1368  5071016 1368  5071036 1368  5071050 1368  5071064 1368  
336327 5071085 1366  5071094 1366  5071107 1368  5071117 1368  5071128 1366  5071136 1368  
336328 5071142 1366  5071150 1368  5071151 1366  5071151 1366  5071152 1366  5071152 1366  
336329 5071142 1366  5071137 1366  5071128 1366  5071118 1366  5071109 1366  5071093 1368  
336330 5071088 1368  5071075 1366  5071061 1366  5071042 1366  5071026 1368  5071002 1368  
336331 5070989 1366  5070965 1366  5070950 1368  5070926 1368  5070910 1370  5070886 1370  
336332 5070873 1368  5070848 1370  5070833 1370  5070814 1370  5070800 1370  5070792 1368  
336333 5070771 1370  5070757 1370  5070748 1370  5070734 1368  5070724 1370  5070714 1370  
336334 5070708 1372  5070700 1370  5070695 1370  5070695 1370  5070695 1370  5070695 1370  
336335 5070695 1370  5070698 1372  5070709 1370  5070714 1370  5070722 1371  5070732 1372  
336336 5070748 1370  5070762 1370  5070779 1372  5070795 1370  5070809 1370  5070824 1370  
336337 5070838 1370  5070862 1370  5070881 1370  5070902 1368  5070926 1368  5070950 1368  
336338 5070964 1368  5070988 1368  5071002 1368  5071027 1366  5071042 1366  5071064 1368  
336339 5071085 1366  5071093 1368  5071109 1366  5071126 1368  5071137 1366  5071142 1366  
336340 5071161 1366  5071166 1366  5071166 1366  5071176 1366  5071176 1366  5071175 1366  
336341 5071166 1366  5071166 1366  5071165 1368  5071160 1368  5071151 1366  5071136 1368  
336342 5071128 1366  5071109 1366  5071094 1366  5071085 1366  5071066 1366  5071052 1366  
336343 5071028 1366  5071008 1366  5070989 1366  5070975 1366  5070951 1366  5070938 1364  
336344 5070913 1366  5070891 1364  5070865 1366  5070851 1366  5070829 1364  5070812 1366  
336345 5070794 1366  5070774 1366  5070760 1366  5070741 1366  5070727 1366  5070712 1366  
336346 5070696 1368  5070692 1368  5070682 1368  5070672 1368  5070668 1368  5070658 1368  
336347 5070658 1368  5070660 1366  5070660 1366  5070660 1366  5070660 1366  5070668 1368  
336348 5070674 1366  5070682 1368  5070693 1366  5070698 1366  5070712 1366  5070727 1366  
336349 5070741 1366  5070760 1366  5070774 1366  5070792 1368  5070811 1368  5070827 1366  
336350 5070849 1368  5070864 1368  5070888 1368  5070911 1368  5070927 1366  5070950 1368  
336351 5070964 1368  5070988 1368  5071002 1368  5071026 1368  5071039 1370  5071060 1368  
336352 5071074 1368  5071087 1370  5071102 1368  5071107 1368  5071126 1368  5071136 1368  
336353 5071136 1368  5071141 1368  5071140 1368  5071141 1368  5071139 1370  5071141 1368  
336354 5071136 1368  5071128 1366  5071117 1368  5071107 1368  5071093 1368  5071090 1366  
336355 5071075 1366  5071059 1368  5071040 1368  5071026 1368  5071004 1366  5070988 1368  
336356 5070973 1368  5070950 1368  5070927 1366  5070913 1366  5070889 1366  5070873 1368  
336357 5070851 1366  5070836 1366  5070817 1366  5070803 1366  5070792 1368  5070774 1366  
336358 5070760 1366  5070741 1366  5070736 1366  5070716 1368  5070712 1366  5070712 1366  
336359 5070701 1368  5070698 1366  5070696 1368  5070696 1368  5070696 1368  5070701 1368  
336360 5070711 1368  5070716 1368  5070725 1368  5070736 1366  5070751 1366  5070763 1368  
336361 5070783 1368  5070798 1366  5070812 1366  5070825 1368  5070849 1368  5070865 1366  
336362 5070888 1368  5070902 1368  5070926 1368  5070950 1368  5070973 1368  5070988 1368  
336363 5071007 1368  5071035 1368  5071050 1368  5071066 1366  5071088 1368  5071102 1368  
336364 5071117 1368  5071136 1368  5071150 1368  5071158 1370  5071164 1368  5071174 1368  
336365 5071182 1370  5071187 1370  5071189 1368  5071189 1368  5071189 1368  5071189 1368  
336366 5071183 1368  5071174 1368  5071164 1368  5071152 1366  5071136 1368  5071128 1366  
336367 5071107 1368  5071094 1366  5071075 1366  5071061 1366  5071035 1368  5071016 1368  
336368 5070993 1368  5070973 1368  5070950 1368  5070927 1366  5070897 1368  5070875 1366  
336369 5070851 1366  5070825 1368  5070803 1366  5070784 1366  5070759 1368  5070739 1368  
336370 5070727 1366  5070703 1366  5070692 1368  5070674 1366  5070658 1368  5070639 1368  
336371 5070634 1368  5070615 1368  5070610 1368  5070601 1368  5070601 1368  5070601 1368  
336372 5070596 1368  5070601 1368  5070602 1366  5070610 1368  5070617 1366  5070625 1368  
336373 5070641 1366  5070647 1370  5070666 1370  5070682 1368  5070696 1368  5070709 1370  
336374 5070724 1370  5070748 1370  5070763 1368  5070791 1370  5070811 1368  5070833 1370  
336375 5070849 1368  5070871 1370  5070895 1370  5070916 1368  5070940 1368  5070962 1370  
336376 5070988 1368  5071007 1368  5071024 1370  5071050 1368  5071064 1368  5071083 1368  
336377 5071093 1368  5071107 1368  5071115 1370  5071126 1368  5071137 1366  5071142 1366  
336378 5071142 1366  5071151 1366  5071153 1364  5071151 1366  5071142 1366  5071137 1366  
336379 5071137 1366  5071126 1368  5071109 1366  5071102 1368  5071090 1366  5071075 1366  
336380 5071061 1366  5071042 1366  5071020 1364  5071005 1364  5070995 1358  5070971 1358  
336381 5070959 1356  5070935 1357  5070911 1356  5070897 1356  5070874 1355  5070860 1355  
336382 5070836 1355  5070812 1355  5070803 1355  5070784 1355  5070771 1353  5070750 1355  
336383 5070736 1355  5070726 1355  5070723 1353  5070712 1355  5070714 1353  5070707 1355  
336384 5070707 1355  5070707 1355  5070714 1353  5070712 1355  5070721 1355  5070728 1353  
336385 5070745 1355  5070752 1353  5070760 1355  5070774 1355  5070793 1355  5070812 1355  
336386 5070827 1355  5070852 1353  5070871 1353  5070884 1355  5070908 1355  5070928 1353  
336387 5070951 1355  5070970 1355  5070994 1355  5071014 1353  5071038 1353  5071053 1353  
336388 5071076 1353  5071094 1355  5071115 1353  5071127 1355  5071146 1355  5071162 1353  
336389 5071177 1353  5071194 1355  5071201 1353  5071204 1355  5071215 1353  5071218 1355  
336390 5071220 1353  5071218 1355  5071220 1353  5071218 1355  5071213 1355  5071204 1355  
336391 5071199 1355  5071196 1353  5071175 1355  5071161 1355  5071146 1355  5071127 1355  
336392 5071103 1355  5071085 1355  5071070 1355  5071037 1355  5071013 1355  5070994 1355  
336393 5070970 1355  5070936 1355  5070912 1355  5070884 1355  5070860 1355  5070827 1355  
336394 5070807 1355  5070784 1355  5070760 1355  5070737 1353  5070712 1355  5070702 1355  
336395 5070678 1355  5070650 1355  5070635 1355  5070621 1355  5070611 1355  5070602 1355  
336396 5070593 1355  5070585 1353  5070578 1355  5070578 1355  5070580 1353  5070578 1355  
336397 5070578 1355  5070583 1355  5070583 1355  5070602 1355  5070607 1355  5070611 1355  
336398 5070627 1353  5070645 1355  5070659 1355  5070685 1353  5070704 1353  5070723 1353  
336399 5070747 1353  5070770 1353  5070795 1353  5070812 1355  5070839 1351  5070861 1353  
336400 5070885 1353  5070914 1353  5070938 1353  5070963 1351  5070986 1353  5071005 1353  
336401 5071029 1353  5071049 1351  5071071 1353  5071086 1353  5071100 1353  5071116 1351  
336402 5071121 1351  5071140 1351  5071149 1351  5071155 1351  5071154 1351  5071164 1351  
336403 5071164 1351  5071164 1351  5071167 1347  5071158 1347  5071149 1351  5071140 1351  
336404 5071133 1347  5071121 1351  5071106 1351  5071097 1351  5071078 1351  5071064 1351  
336405 5071049 1351  5071030 1351  5071006 1351  5070987 1351  5070976 1347  5070949 1351  
336406 5070928 1347  5070914 1347  5070887 1351  5070872 1351  5070849 1351  5070833 1347  
336407 5070818 1347  5070809 1347  5070791 1345  5070775 1347  5070756 1347  5070753 1345  
336408 5070743 1345  5070732 1347  5070728 1347  5070728 1347  5070729 1345  5070732 1347  
336409 5070734 1345  5070742 1347  5070742 1347  5070752 1347  5070766 1347  5070775 1347  
336410 5070791 1345  5070809 1347  5070815 1351  5070842 1347  5070857 1347  5070875 1347  
336411 5070899 1347  5070919 1347  5070930 1351  5070954 1351  5070980 1347  5071004 1347  
336412 5071016 1351  5071040 1351  5071064 1351  5071088 1351  5071102 1351  5071124 1347  
336413 5071143 1347  5071167 1347  5071178 1351  5071197 1351  5071202 1351  5071216 1351  
336414 5071221 1351  5071234 1347  5071240 1351  5071240 1351  5071245 1351  5071248 1347  
336415 5071240 1351  5071240 1351  5071231 1351  5071221 1351  5071216 1351  5071202 1351  
336416 5071197 1351  5071173 1351  5071154 1351  5071130 1351  5071107 1351  5071088 1351  
336417 5071064 1351  5071043 1347  5071006 1351  5070987 1351  5070957 1347  5070928 1347  
336418 5070896 1351  5070872 1351  5070842 1347  5070815 1351  5070787 1351  5070753 1351  
336419 5070729 1351  5070710 1351  5070686 1351  5070662 1351  5070638 1351  5070615 1351  
336420 5070605 1351  5070586 1351  5070572 1351  5070562 1351  5070548 1351  5070551 1347  
336421 5070541 1347  5070538 1351  5070538 1351  5070541 1347  5070538 1351  5070548 1351  
336422 5070553 1351  5070572 1351  5070586 1351  5070605 1351  5070610 1351  5070624 1351  
336423 5070648 1351  5070662 1351  5070686 1351  5070708 1353  5070728 1353  5070752 1353  
336424 5070775 1353  5070810 1351  5070828 1353  5070851 1355  5070885 1353  5070909 1353  
336425 5070928 1353  5070960 1355  5070986 1353  5071005 1353  5071019 1353  5071048 1353  
336426 5071071 1353  5071086 1353  5071100 1353  5071115 1353  5071119 1353  5071129 1353  
336427 5071140 1351  5071148 1353  5071154 1351  5071155 1351  5071164 1351  5071164 1351  
336428 5071153 1353  5071155 1351  5071138 1353  5071131 1351  5071121 1351  5071116 1351  
336429 5071107 1351  5071086 1353  5071072 1353  5071053 1353  5071038 1353  5071016 1351  
336430 5071000 1353  5070976 1353  5070962 1353  5070938 1353  5070915 1351  5070900 1353  
336431 5070887 1351  5070862 1353  5070847 1353  5070828 1353  5070814 1353  5070793 1355  
336432 5070787 1351  5070772 1351  5070761 1353  5070752 1353  5070737 1353  5070737 1353  
336433 5070737 1353  5070728 1353  5070726 1355  5070728 1353  5070737 1353  5070749 1351  
336434 5070753 1351  5070761 1353  5070771 1353  5070785 1353  5070795 1353  5070810 1351  
336435 5070828 1353  5070847 1353  5070862 1353  5070886 1353  5070900 1353  5070924 1353  
336436 5070947 1353  5070971 1353  5070994 1355  5071013 1355  5071037 1355  5071062 1353  
336437 5071075 1355  5071099 1355  5071118 1355  5071137 1355  5071161 1355  5071175 1355  
336438 5071194 1355  5071204 1355  5071218 1355  5071236 1356  5071242 1355  5071251 1355  
336439 5071261 1355  5071260 1356  5071260 1356  5071261 1355  5071260 1356  5071251 1355  
336440 5071240 1356  5071236 1356  5071226 1357  5071202 1356  5071193 1356  5071175 1355  
336441 5071150 1356  5071126 1356  5071103 1355  5071083 1356  5071049 1356  5071027 1355  
336442 5070997 1356  5070970 1355  5070936 1355  5070908 1355  5070873 1356  5070844 1356  
336443 5070820 1356  5070792 1356  5070758 1357  5070734 1356  5070705 1356  5070682 1356  
336444 5070658 1356  5070634 1356  5070610 1356  5070599 1358  5070582 1356  5070567 1356  
336445 5070547 1358  5070542 1358  5070532 1358  5070523 1358  5070523 1358  5070518 1358  
336446 5070519 1356  5070524 1357  5070524 1356  5070534 1356  5070543 1357  5070548 1356  
336447 5070567 1356  5070582 1356  5070600 1356  5070610 1356  5070634 1356  5070650 1355  
336448 5070678 1355  5070701 1356  5070722 1355  5070745 1355  5070774 1355  5070803 1355  
336449 5070822 1355  5070851 1355  5070873 1356  5070908 1355  5070927 1355  5070960 1355  
336450 5070984 1355  5070998 1355  5071027 1355  5071046 1355  5071060 1355  5071085 1355  
336451 5071096 1353  5071105 1353  5071121 1351  5071129 1353  5071140 1351  5071149 1351  
336452 5071155 1351  5071158 1347  5071158 1347  5071159 1345  5071154 1345  5071153 1347  
336453 5071145 1345  5071134 1347  5071121 1345  5071110 1347  5071102 1345  5071082 1345  
336454 5071067 1347  5071054 1345  5071025 1345  5071009 1347  5070992 1345  5070977 1345  
336455 5070954 1345  5070931 1343  5070917 1343  5070892 1345  5070868 1345  5070853 1345  
336456 5070831 1343  5070815 1345  5070801 1345  5070782 1345  5070769 1343  5070758 1345  
336457 5070755 1343  5070743 1345  5070734 1345  5070729 1345  5070728 1347  5070729 1345  
336458 5070729 1345  5070729 1351  5070732 1347  5070737 1353  5070752 1353  5070761 1353  
336459 5070775 1353  5070795 1353  5070807 1355  5070822 1355  5070836 1355  5070851 1355  
336460 5070874 1355  5070893 1355  5070912 1355  5070936 1355  5070951 1355  5070974 1355  
336461 5070997 1356  5071018 1355  5071046 1355  5071070 1355  5071093 1356  5071111 1356  
336462 5071135 1356  5071150 1356  5071174 1356  5071193 1356  5071204 1355  5071216 1356  
336463 5071228 1355  5071240 1356  5071250 1356  5071261 1355  5071260 1356  5071260 1356  
336464 5071261 1355  5071261 1355  5071261 1355  5071251 1355  5071240 1356  5071228 1355  
336465 5071212 1356  5071199 1355  5071185 1355  5071161 1355  5071137 1355  5071113 1355  
336466 5071094 1355  5071061 1355  5071037 1355  5071005 1353  5070976 1353  5070947 1353  
336467 5070911 1351  5070880 1347  5070853 1345  5070818 1347  5070801 1345  5070769 1343  
336468 5070734 1345  5070711 1343  5070688 1343  5070659 1343  5070635 1343  5070616 1343  
336469 5070592 1343  5070579 1341  5070552 1345  5070535 1343  5070530 1343  5070521 1343  
336470 5070516 1343  5070513 1341  5070511 1343  5070511 1343  5070511 1343  5070509 1345  
336471 5070516 1343  5070521 1343  5070535 1343  5070544 1343  5070559 1343  5070578 1343  
336472 5070591 1345  5070611 1343  5070629 1345  5070653 1345  5070676 1345  5070700 1345  
336473 5070720 1345  5070743 1345  5070778 1343  5070802 1343  5070821 1343  5070855 1343  
336474 5070879 1343  5070907 1343  5070931 1343  5070955 1343  5070979 1343  5071003 1343  
336475 5071020 1345  5071046 1343  5071059 1345  5071079 1343  5071094 1343  5071106 1345  
336476 5071122 1343  5071125 1345  5071136 1343  5071137 1343  5071146 1343  5071146 1343  
336477 5071146 1343  5071137 1343  5071137 1343  5071126 1345  5071122 1343  5071108 1343  
336478 5071103 1343  5071094 1343  5071079 1343  5071060 1343  5071046 1343  5071022 1343  
336479 5071003 1343  5070984 1343  5070960 1343  5070945 1343  5070922 1343  5070907 1343  
336480 5070884 1343  5070869 1343  5070845 1343  5070831 1343  5070815 1345  5070802 1343  
336481 5070783 1343  5070769 1343  5070758 1345  5070743 1345  5070743 1345  5070734 1345  
336482 5070729 1345  5070729 1345  5070731 1343  5070731 1343  5070729 1345  5070731 1343  
336483 5070735 1343  5070743 1345  5070755 1343  5070758 1345  5070769 1343  5070782 1345  
336484 5070802 1343  5070817 1343  5070829 1345  5070853 1345  5070868 1345  5070892 1345  
336485 5070906 1345  5070930 1345  5070955 1343  5070977 1345  5071001 1345  5071021 1345  
336486 5071044 1345  5071068 1345  5071092 1345  5071110 1347  5071126 1345  5071153 1347  
336487 5071176 1347  5071183 1345  5071203 1343  5071211 1345  5071223 1343  5071235 1345  
336488 5071246 1343  5071250 1345  5071251 1343  5071249 1345  5071251 1343  5071246 1343  
336489 5071237 1343  5071237 1343  5071223 1343  5071213 1343  5071204 1343  5071179 1343  
336490 5071161 1343  5071137 1343  5071113 1343  5071094 1343  5071060 1343  5071025 1345  
336491 5071008 1343  5070979 1343  5070945 1343  5070915 1345  5070884 1343  5070855 1343  
336492 5070820 1345  5070791 1345  5070759 1343  5070734 1345  5070710 1345  5070676 1345  
336493 5070653 1345  5070629 1345  5070610 1345  5070586 1345  5070567 1345  5070552 1345  
336494 5070528 1345  5070517 1347  5070508 1347  5070508 1347  5070500 1345  5070489 1347  
336495 5070486 1351  5070489 1347  5070498 1347  5070498 1347  5070508 1347  5070517 1347  
336496 5070527 1347  5070541 1347  5070553 1351  5070575 1347  5070586 1351  5070610 1351  
336497 5070627 1347  5070648 1351  5070672 1351  5070696 1351  5070715 1351  5070739 1351  
336498 5070772 1351  5070799 1347  5070815 1351  5070849 1351  5070872 1351  5070904 1347  
336499 5070925 1351  5070949 1351  5070971 1353  5070987 1351  5071006 1351  5071021 1351  
336500 5071040 1351  5071064 1351  5071076 1347  5071091 1347  5071100 1347  5071105 1347  
336501 5071106 1351  5071116 1351  5071119 1347  5071121 1351  5071119 1347  5071119 1347  
336502 5071110 1347  5071105 1347  5071097 1351  5071091 1347  5071081 1347  5071067 1347  
336503 5071053 1347  5071033 1347  5071019 1347  5071006 1345  5070981 1347  5070966 1347  
336504 5070952 1347  5070928 1347  5070914 1347  5070887 1351  5070877 1345  5070857 1347  
336505 5070842 1347  5070828 1347  5070813 1347  5070799 1347  5070780 1347  5070775 1347  
336506 5070756 1347  5070752 1347  5070742 1347  5070742 1347  5070732 1347  5070732 1347  
336507 5070732 1347  5070732 1347  5070732 1347  5070742 1347  5070742 1347  5070756 1347  
336508 5070756 1347  5070777 1345  5070787 1351  5070809 1347  5070818 1347  5070832 1347  
336509 5070852 1347  5070863 1351  5070890 1347  5070914 1347  5070933 1347  5070954 1351  
336510 5070973 1351  5070997 1351  5071016 1351  5071038 1353  5071064 1351  5071088 1351  
336511 5071107 1351  5071121 1351  5071149 1351  5071162 1353  5071178 1351  5071202 1351  
336512 5071216 1351  5071221 1351  5071240 1351  5071248 1347  5071248 1347  5071248 1347  
336513 5071248 1347  5071248 1347  5071245 1351  5071243 1347  5071234 1347  5071224 1347  
336514 5071220 1347  5071205 1347  5071191 1347  5071167 1347  5071154 1345  5071124 1347  
336515 5071105 1347  5071081 1347  5071057 1347  5071033 1347  5071004 1347  5070976 1347  
336516 5070942 1347  5070914 1347  5070880 1347  5070852 1347  5070818 1347  5070801 1345  
336517 5070766 1347  5070742 1347  5070713 1347  5070689 1347  5070667 1345  5070643 1345  
336518 5070618 1347  5070599 1347  5070586 1345  5070565 1347  5070551 1347  5070532 1347  
336519 5070527 1347  5070518 1347  5070517 1347  5070509 1351  5070513 1347  5070513 1347  
336520 5070518 1347  5070527 1347  5070527 1347  5070541 1347  5070556 1347  5070565 1347  
336521 5070584 1347  5070599 1347  5070613 1347  5070627 1347  5070648 1351  5070672 1351  
336522 5070696 1351  5070715 1351  5070739 1351  5070763 1351  5070787 1351  5070810 1351  
336523 5070830 1351  5070857 1347  5070887 1351  5070909 1353  5070933 1347  5070954 1351  
336524 5070978 1351  5071002 1351  5071016 1351  5071040 1351  5071054 1351  5071071 1353  
336525 5071088 1351  5071097 1351  5071105 1353  5071116 1351  5071116 1351  5071121 1351  
336526 5071121 1351  5071121 1351  5071119 1353  5071116 1351  5071105 1353  5071106 1351  
336527 5071102 1351  5071088 1351  5071076 1353  5071073 1351  5071053 1353  5071043 1347  
336528 5071021 1351  5071006 1351  5070997 1351  5070976 1347  5070954 1351  5070942 1347  
336529 5070925 1351  5070904 1347  5070890 1347  5070873 1351  5070857 1347  5070839 1351  
336530 5070825 1351  5070810 1351  5070799 1347  5070787 1351  5070777 1351  5070766 1347  
336531 5070753 1351  5070753 1351  5070753 1351  5070756 1347  5070748 1351  5070753 1351  
336532 5070756 1347  5070763 1351  5070763 1351  5070772 1351  5070777 1351  5070796 1351  
336533 5070806 1351  5070818 1347  5070833 1347  5070849 1351  5070872 1351  5070897 1351  
336534 5070909 1353  5070933 1347  5070954 1351  5070973 1351  5070995 1353  5071016 1351  
336535 5071040 1351  5071064 1351  5071088 1351  5071102 1351  5071121 1351  5071149 1351  
336536 5071164 1351  5071188 1351  5071200 1353  5071216 1351  5071221 1351  5071240 1351  
336537 5071245 1351  5071258 1347  5071255 1351  5071255 1351  5071255 1351  5071258 1347  
336538 5071245 1351  5071248 1347  5071243 1347  5071221 1351  5071220 1347  5071205 1347  
336539 5071188 1351  5071164 1351  5071149 1351  5071124 1347  5071105 1347  5071081 1347  
336540 5071052 1347  5071021 1351  5070997 1351  5070971 1353  5070939 1351  5070915 1351  
336541 5070887 1351  5070863 1351  5070828 1353  5070809 1353  5070775 1353  5070750 1355  
336542 5070726 1355  5070708 1353  5070685 1353  5070661 1353  5070647 1353  5070626 1355  
336543 5070608 1353  5070603 1353  5070585 1353  5070580 1353  5070570 1353  5070561 1353  
336544 5070559 1355  5070551 1353  5070551 1353  5070561 1353  5070559 1355  5070570 1353  
336545 5070580 1353  5070594 1353  5070603 1353  5070608 1353  5070623 1353  5070637 1353  
336546 5070650 1355  5070680 1353  5070693 1355  5070707 1355  5070726 1355  5070750 1355  
336547 5070774 1355  5070803 1355  5070822 1355  5070845 1355  5070869 1355  5070884 1355  
336548 5070912 1355  5070927 1355  5070951 1355  5070976 1353  5071000 1353  5071013 1355  
336549 5071038 1353  5071053 1353  5071071 1353  5071086 1353  5071094 1355  5071104 1355  
336550 5071114 1353  5071119 1353  5071120 1353  5071127 1355  5071127 1355  5071129 1353  
336551 5071118 1355  5071120 1353  5071120 1353  5071105 1353  5071100 1353  5071096 1353  
336552 5071086 1353  5071076 1353  5071062 1353  5071053 1353  5071038 1353  5071019 1353  
336553 5071005 1353  5070995 1353  5070977 1351  5070952 1353  5070938 1353  5070924 1353  
336554 5070908 1355  5070895 1353  5070876 1353  5070872 1351  5070853 1351  5070837 1353  
336555 5070828 1353  5070813 1353  5070809 1353  5070804 1353  5070795 1353  5070795 1353  
336556 5070785 1353  5070785 1353  5070784 1355  5070785 1353  5070796 1351  5070795 1353  
336557 5070803 1355  5070807 1355  5070812 1355  5070828 1353  5070836 1355  5070852 1353  
336558 5070869 1355  5070885 1353  5070900 1353  5070914 1353  5070936 1355  5070951 1355  
336559 5070976 1353  5070994 1355  5071013 1355  5071027 1355  5071051 1355  5071075 1355  
336560 5071096 1353  5071103 1355  5071127 1355  5071148 1353  5071172 1353  5071177 1353  
336561 5071199 1355  5071204 1355  5071215 1353  5071229 1353  5071239 1353  5071237 1355  
336562 5071242 1355  5071242 1355  5071243 1353  5071242 1355  5071239 1353  5071229 1353  
336563 5071218 1355  5071215 1353  5071204 1355  5071196 1353  5071177 1353  5071161 1355  
336564 5071138 1353  5071119 1353  5071100 1353  5071075 1355  5071053 1353  5071019 1353  
336565 5071001 1351  5070977 1351  5070949 1351  5070928 1347  5070901 1351  5070872 1351  
336566 5070849 1351  5070815 1351  5070796 1351  5070772 1351  5070752 1347  5070728 1347  
336567 5070705 1351  5070685 1347  5070662 1351  5070648 1351  5070629 1351  5070615 1351  
336568 5070610 1351  5070605 1351  5070595 1351  5070584 1353  5070581 1351  5070581 1351  
336569 5070581 1351  5070581 1351  5070581 1351  5070586 1351  5070595 1351  5070605 1351  
336570 5070610 1351  5070623 1353  5070627 1353  5070647 1353  5070662 1351  5070682 1351  
336571 5070694 1353  5070713 1353  5070729 1351  5070752 1353  5070775 1353  5070804 1353  
336572 5070815 1351  5070847 1353  5070861 1353  5070885 1353  5070909 1353  5070930 1351  
336573 5070946 1355  5070971 1353  5070995 1353  5071005 1353  5071019 1353  5071038 1353  
336574 5071053 1353  5071071 1353  5071076 1353  5071088 1351  5071096 1353  5071100 1353  
336575 5071106 1351  5071105 1353  5071107 1351  5071116 1351  5071114 1353  5071110 1347  
336576 5071107 1351  5071110 1347  5071105 1347  5071100 1347  5071088 1351  5071076 1347  
336577 5071067 1347  5071054 1351  5071043 1347  5071024 1347  5071009 1347  5070997 1351  
336578 5070980 1347  5070966 1347  5070952 1347  5070933 1347  5070919 1347  5070906 1345  
336579 5070890 1347  5070876 1347  5070858 1345  5070844 1345  5070834 1345  5070829 1345  
336580 5070815 1345  5070809 1347  5070801 1345  5070791 1345  5070782 1345  5070782 1345  
336581 5070780 1347  5070782 1345  5070782 1345  5070791 1345  5070791 1345  5070799 1347  
336582 5070809 1347  5070820 1345  5070833 1347  5070842 1347  5070857 1347  5070875 1347  
336583 5070890 1347  5070904 1347  5070920 1345  5070935 1345  5070952 1347  5070976 1347  
336584 5071001 1345  5071011 1345  5071025 1345  5071054 1345  5071067 1347  5071091 1347  
336585 5071105 1347  5071119 1347  5071133 1347  5071153 1347  5071164 1351  5071177 1347  
336586 5071191 1347  5071197 1351  5071205 1347  5071210 1347  5071207 1351  5071207 1351  
336587 5071216 1351  5071207 1351  5071210 1347  5071202 1351  5071200 1347  5071191 1347  
336588 5071181 1347  5071167 1347  5071159 1345  5071143 1347  5071119 1347  5071105 1347  
336589 5071091 1347  5071067 1347  5071044 1345  5071021 1345  5071001 1345  5070977 1345  
336590 5070954 1345  5070928 1347  5070906 1345  5070882 1345  5070853 1345  5070829 1345  
336591 5070810 1345  5070780 1347  5070756 1347  5070742 1347  5070728 1347  5070710 1345  
336592 5070686 1345  5070667 1345  5070658 1345  5070644 1343  5070630 1343  5070621 1343  
336593 5070616 1343  5070611 1343  5070613 1341  5070602 1343  5070602 1343  5070603 1341  
336594 5070602 1343  5070611 1343  5070611 1343  5070615 1345  5070621 1343  5070635 1343  
336595 5070644 1343  5070653 1345  5070669 1343  5070688 1343  5070700 1345  5070715 1345  
336596 5070734 1345  5070755 1343  5070767 1345  5070791 1345  5070810 1345  5070829 1345  
336597 5070855 1343  5070877 1345  5070892 1345  5070915 1345  5070930 1345  5070952 1347  
336598 5070966 1347  5070992 1345  5071006 1345  5071021 1345  5071024 1347  5071044 1345  
336599 5071057 1347  5071067 1347  5071076 1347  5071081 1347  5071091 1347  5071100 1347  
336600 5071100 1347  5071105 1347  5071105 1347  5071106 1345  5071100 1347  5071100 1347  
336601 5071092 1345  5071082 1345  5071076 1347  5071067 1347  5071059 1345  5071043 1347  
336602 5071035 1345  5071021 1345  5071011 1345  5071001 1345  5070982 1345  5070968 1345  
336603 5070954 1345  5070934 1345  5070922 1343  5070907 1343  5070893 1343  5070877 1345  
336604 5070858 1345  5070844 1345  5070834 1345  5070820 1345  5070815 1345  5070810 1345  
336605 5070801 1345  5070791 1345  5070791 1345  5070782 1345  5070783 1343  5070782 1345  
336606 5070782 1345  5070782 1345  5070790 1347  5070791 1345  5070810 1345  5070813 1347  
336607 5070820 1345  5070833 1347  5070842 1347  5070857 1347  5070876 1347  5070890 1347  
336608 5070904 1347  5070919 1347  5070933 1347  5070952 1347  5070963 1351  5070987 1351  
336609 5071001 1351  5071019 1347  5071033 1347  5071052 1347  5071076 1347  5071091 1347  
336610 5071105 1347  5071109 1347  5071124 1347  5071140 1351  5071153 1347  5071157 1347  
336611 5071167 1347  5071173 1351  5071178 1351  5071181 1347  5071178 1351  5071181 1347  
336612 5071178 1351  5071181 1347  5071176 1347  5071176 1347  5071164 1351  5071157 1347  
336613 5071143 1347  5071133 1347  5071119 1347  5071109 1347  5071091 1347  5071076 1347  
336614 5071057 1347  5071030 1351  5071009 1347  5071000 1347  5070973 1351  5070952 1347  
336615 5070933 1347  5070914 1347  5070891 1345  5070866 1347  5070842 1347  5070818 1347  
336616 5070810 1345  5070780 1347  5070767 1345  5070743 1345  5070728 1347  5070715 1345  
336617 5070700 1345  5070686 1345  5070676 1345  5070657 1345  5070653 1345  5070641 1347  
336618 5070641 1347  5070633 1345  5070632 1347  5070627 1347  5070632 1347  5070632 1347  
336619 5070632 1347  5070641 1347  5070641 1347  5070656 1347  5070662 1351  5070672 1351  
336620 5070686 1351  5070696 1351  5070710 1351  5070724 1351  5070739 1351  5070753 1351  
336621 5070777 1351  5070795 1353  5070815 1351  5070830 1351  5070852 1353  5070869 1355  
336622 5070895 1353  5070909 1353  5070927 1355  5070947 1353  5070970 1355  5070984 1355  
336623 5071000 1353  5071012 1355  5071027 1355  5071037 1355  5071053 1353  5071070 1355  
336624 5071075 1355  5071086 1353  5071094 1355  5071105 1353  5071104 1355  5071113 1355  
336625 5071113 1355  5071113 1355  5071115 1353  5071113 1355  5071105 1353  5071103 1355  
336626 5071100 1353  5071096 1353  5071085 1355  5071072 1353  5071062 1353  5071048 1353  
336627 5071029 1353  5071019 1353  5071003 1355  5070995 1353  5070970 1355  5070951 1355  
336628 5070936 1355  5070924 1353  5070909 1353  5070896 1351  5070876 1353  5070863 1351  
336629 5070854 1351  5070837 1353  5070828 1353  5070823 1353  5070810 1351  5070804 1353  
336630 5070795 1353  5070796 1351  5070787 1351  5070777 1351  5070777 1351  5070777 1351  
336631 5070780 1347  5070790 1347  5070796 1351  5070799 1347  5070806 1351  5070810 1351  
336632 5070828 1347  5070833 1347  5070844 1345  5070858 1345  5070877 1345  5070880 1347  
336633 5070899 1347  5070914 1347  5070928 1347  5070952 1347  5070966 1347  5070981 1347  
336634 5071000 1347  5071019 1347  5071033 1347  5071054 1345  5071067 1347  5071081 1347  
336635 5071092 1345  5071105 1347  5071109 1347  5071124 1347  5071130 1351  5071149 1351  
336636 5071154 1351  5071164 1351  5071164 1351  5071164 1351  5071173 1351  5071173 1351  
336637 5071173 1351  5071173 1351  5071164 1351  5071154 1351  5071149 1351  5071140 1351  
336638 5071131 1351  5071116 1351  5071109 1347  5071097 1351  5071078 1351  5071064 1351  
336639 5071039 1351  5071021 1351  5071001 1351  5070987 1351  5070973 1351  5070949 1351  
336640 5070930 1351  5070909 1353  5070896 1351  5070873 1351  5070853 1351  5070828 1353  
336641 5070814 1353  5070795 1353  5070777 1351  5070761 1353  5070747 1353  5070728 1353  
336642 5070713 1353  5070707 1355  5070704 1353  5070696 1351  5070685 1353  5070680 1353  
336643 5070670 1353  5070669 1355  5070670 1353  5070659 1355  5070669 1355  5070669 1355  
336644 5070678 1355  5070685 1353  5070685 1353  5070704 1353  5070707 1355  5070712 1355  
336645 5070726 1355  5070745 1355  5070760 1355  5070774 1355  5070793 1355  5070807 1355  
336646 5070822 1355  5070845 1355  5070860 1355  5070874 1355  5070898 1355  5070912 1355  
336647 5070936 1355  5070951 1355  5070974 1355  5070994 1355  5071003 1354  5071018 1355  
336648 5071037 1355  5071051 1355  5071070 1355  5071075 1355  5071085 1355  5071099 1355  
336649 5071103 1355  5071114 1353  5071119 1353  5071127 1355  5071127 1355  5071127 1355  
336650 5071127 1355  5071127 1355  5071127 1355  5071118 1355  5071114 1353  5071113 1355  
336651 5071103 1355  5071094 1355  5071085 1355  5071070 1355  5071060 1355  5071048 1353  
336652 5071027 1355  5071013 1355  5070998 1355  5070984 1355  5070971 1353  5070947 1353  
336653 5070928 1353  5070915 1351  5070904 1347  5070887 1351  5070872 1351  5070857 1347  
336654 5070849 1351  5070830 1351  5070818 1347  5070813 1347  5070796 1351  5070799 1347  
336655 5070780 1347  5070780 1347  5070775 1347  5070772 1351  5070775 1347  5070775 1347  
336656 5070775 1347  5070775 1347  5070780 1347  5070790 1347  5070799 1347  5070809 1347  
336657 5070809 1347  5070818 1347  5070833 1347  5070844 1345  5070852 1347  5070868 1345  
336658 5070882 1345  5070899 1347  5070915 1345  5070930 1345  5070944 1345  5070957 1347  
336659 5070977 1345  5070992 1345  5071006 1345  5071020 1345  5071036 1343  5071054 1345  
336660 5071068 1345  5071082 1345  5071094 1343  5071106 1345  5071111 1345  5071121 1345  
336661 5071126 1345  5071135 1345  5071135 1345  5071144 1345  5071144 1345  5071144 1345  
336662 5071144 1345  5071146 1343  5071135 1345  5071135 1345  5071127 1343  5071121 1345  
336663 5071112 1343  5071103 1343  5071094 1343  5071079 1343  5071060 1343  5071046 1343  
336664 5071027 1343  5071012 1343  5070993 1343  5070979 1343  5070961 1341  5070947 1341  
336665 5070922 1343  5070904 1341  5070884 1343  5070871 1341  5070846 1341  5070832 1341  
336666 5070813 1341  5070794 1341  5070780 1341  5070761 1341  5070746 1341  5070732 1341  
336667 5070719 1340  5070715 1340  5070694 1341  5070691 1340  5070681 1340  5070681 1340  
336668 5070671 1340  5070670 1341  5070670 1341  5070671 1340  5070670 1341  5070681 1340  
336669 5070691 1340  5070689 1341  5070694 1341  5070705 1340  5070719 1340  5070723 1341  
336670 5070737 1341  5070756 1341  5070770 1341  5070785 1341  5070802 1343  5070818 1341  
336671 5070837 1341  5070861 1341  5070880 1341  5070904 1341  5070919 1341  5070937 1341  
336672 5070955 1343  5070980 1341  5070995 1341  5071009 1341  5071022 1343  5071038 1341  
336673 5071055 1343  5071071 1341  5071081 1341  5071095 1341  5071105 1341  5071114 1341  
336674 5071114 1341  5071125 1340  5071129 1341  5071129 1341  5071140 1340  5071140 1340  
336675 5071129 1341  5071125 1340  5071125 1340  5071125 1340  5071109 1341  5071106 1340  
336676 5071097 1340  5071082 1340  5071073 1340  5071058 1340  5071039 1340  5071026 1338  
336677 5071012 1338  5070998 1338  5070984 1338  5070960 1338  5070939 1340  5070926 1338  
336678 5070912 1338  5070898 1338  5070881 1340  5070859 1338  5070839 1340  5070824 1340  
336679 5070816 1338  5070796 1340  5070782 1340  5070770 1341  5070758 1340  5070748 1340  
336680 5070734 1340  5070734 1340  5070724 1340  5070719 1340  5070719 1340  5070713 1341  
336681 5070713 1341  5070718 1341  5070718 1341  5070723 1341  5070734 1340  5070734 1340  
336682 5070738 1340  5070758 1340  5070762 1340  5070782 1340  5070786 1340  5070805 1340  
336683 5070820 1340  5070834 1340  5070848 1340  5070863 1340  5070887 1340  5070905 1340  
336684 5070920 1340  5070939 1340  5070958 1340  5070972 1340  5070996 1340  5071010 1340  
336685 5071025 1340  5071039 1340  5071059 1340  5071073 1340  5071084 1338  5071087 1340  
336686 5071108 1338  5071112 1338  5071116 1340  5071125 1340  5071130 1340  5071130 1340  
336687 5071130 1340  5071128 1341  5071132 1338  5071132 1338  5071125 1340  5071116 1340  
336688 5071115 1340  5071108 1338  5071097 1340  5071084 1338  5071063 1340  5071049 1340  
336689 5071030 1340  5071025 1340  5071006 1340  5070987 1340  5070971 1341  5070957 1341  
336690 5070934 1340  5070919 1341  5070895 1341  5070880 1341  5070855 1343  5070837 1341  
336691 5070817 1343  5070802 1343  5070783 1343  5070769 1343  5070755 1343  5070735 1343  
336692 5070729 1345  5070715 1345  5070710 1345  5070700 1345  5070691 1345  5070691 1345  
336693 5070689 1347  5070691 1345  5070691 1345  5070689 1347  5070689 1347  5070699 1347  
336694 5070708 1347  5070713 1347  5070718 1347  5070732 1347  5070739 1351  5070756 1347  
336695 5070772 1351  5070787 1351  5070810 1351  5070825 1351  5070852 1347  5070863 1351  
336696 5070885 1353  5070911 1351  5070924 1353  5070947 1353  5070973 1351  5070995 1353  
336697 5071014 1353  5071038 1353  5071053 1353  5071071 1353  5071096 1353  5071105 1353  
336698 5071121 1351  5071138 1353  5071148 1353  5071164 1351  5071172 1353  5071177 1353  
336699 5071186 1353  5071186 1353  5071196 1353  5071197 1351  5071197 1351  5071196 1353  
336700 5071186 1353  5071178 1351  5071178 1351  5071164 1351  5071154 1351  5071140 1351  
336701 5071133 1347  5071116 1351  5071102 1351  5071088 1351  5071076 1347  5071054 1351  
336702 5071030 1351  5071016 1351  5071000 1347  5070973 1351  5070954 1351  5070930 1351  
336703 5070914 1347  5070887 1351  5070863 1351  5070852 1347  5070825 1351  5070806 1351  
336704 5070787 1351  5070762 1351  5070748 1351  5070729 1351  5070715 1351  5070710 1351  
336705 5070694 1353  5070686 1351  5070682 1351  5070675 1347  5070662 1351  5070665 1347  
336706 5070657 1345  5070656 1347  5070665 1347  5070667 1345  5070676 1345  5070686 1345  
336707 5070691 1345  5070700 1345  5070715 1345  5070729 1345  5070743 1345  5070758 1345  
336708 5070777 1345  5070801 1345  5070815 1345  5070834 1345  5070853 1345  5070877 1345  
336709 5070901 1345  5070920 1345  5070944 1345  5070958 1345  5070982 1345  5071007 1343  
336710 5071022 1343  5071035 1345  5071059 1345  5071068 1345  5071082 1345  5071102 1345  
336711 5071111 1345  5071121 1345  5071126 1345  5071146 1343  5071146 1343  5071156 1343  
336712 5071159 1345  5071159 1345  5071159 1345  5071160 1343  5071156 1343  5071144 1345  
336713 5071135 1345  5071126 1345  5071122 1343  5071106 1345  5071102 1345  5071084 1343  
336714 5071070 1343  5071055 1343  5071025 1345  5071011 1345  5071001 1345  5070979 1343  
336715 5070958 1345  5070934 1345  5070920 1345  5070902 1343  5070879 1343  5070858 1345  
336716 5070844 1345  5070820 1345  5070810 1345  5070793 1343  5070775 1347  5070758 1345  
336717 5070743 1345  5070734 1345  5070729 1345  5070715 1345  5070715 1345  5070708 1347  
336718 5070708 1347  5070708 1347  5070700 1345  5070708 1347  5070710 1345  5070713 1347  
336719 5070718 1347  5070729 1345  5070743 1345  5070756 1347  5070775 1347  5070790 1347  
336720 5070809 1347  5070828 1347  5070839 1351  5070863 1351  5070890 1347  5070911 1351  
336721 5070933 1347  5070954 1351  5070977 1351  5071004 1347  5071021 1351  5071049 1351  
336722 5071076 1347  5071088 1351  5071110 1347  5071133 1347  5071153 1347  5071167 1347  
336723 5071181 1347  5071202 1345  5071205 1347  5071210 1347  5071220 1347  5071224 1347  
336724 5071234 1347  5071243 1347  5071245 1345  5071243 1347  5071243 1347  5071234 1347  
336725 5071224 1347  5071220 1347  5071210 1347  5071200 1347  5071191 1347  5071178 1345  
336726 5071153 1347  5071133 1347  5071109 1347  5071100 1347  5071076 1347  5071052 1347  
336727 5071024 1347  5071004 1347  5070976 1347  5070952 1347  5070930 1345  5070906 1345  
336728 5070876 1347  5070853 1345  5070828 1347  5070809 1347  5070780 1347  5070752 1347  
336729 5070729 1351  5070713 1347  5070689 1347  5070672 1351  5070656 1347  5070638 1351  
336730 5070624 1351  5070615 1351  5070608 1347  5070599 1347  5070599 1347  5070589 1347  
336731 5070589 1347  5070599 1347  5070599 1347  5070608 1347  5070613 1347  5070618 1347  
336732 5070632 1347  5070641 1347  5070656 1347  5070675 1347  5070699 1347  5070713 1347  
336733 5070732 1347  5070756 1347  5070780 1347  5070809 1347  5070828 1347  5070857 1347  
336734 5070880 1347  5070904 1347  5070930 1351  5070957 1347  5070990 1347  5071009 1347  
336735 5071030 1351  5071057 1347  5071076 1347  5071097 1351  5071116 1351  5071130 1351  
336736 5071149 1351  5071154 1351  5071176 1347  5071181 1347  5071197 1351  5071200 1347  
336737 5071205 1347  5071205 1347  5071207 1345  5071205 1347  5071200 1347  5071192 1345  
336738 5071181 1347  5071176 1347  5071167 1347  5071153 1347  5071133 1347  5071119 1347  
336739 5071105 1347  5071091 1347  5071067 1347  5071043 1347  5071024 1347  5071004 1347  
336740 5070981 1347  5070957 1347  5070933 1347  5070919 1347  5070896 1351  5070877 1351  
336741 5070857 1347  5070830 1351  5070818 1347  5070809 1347  5070791 1345  5070775 1347  
336742 5070756 1347  5070752 1347  5070742 1347  5070732 1347  5070728 1347  5070728 1347  
336743 5070725 1351  5070728 1347  5070728 1347  5070728 1347  5070732 1347  5070742 1347  
336744 5070756 1347  5070766 1347  5070777 1351  5070799 1347  5070818 1347  5070833 1347  
336745 5070852 1347  5070876 1347  5070901 1345  5070920 1345  5070942 1347  5070966 1347  
336746 5071000 1347  5071019 1347  5071043 1347  5071067 1347  5071091 1347  5071111 1345  
336747 5071135 1345  5071157 1347  5071181 1347  5071207 1345  5071220 1347  5071234 1347  
336748 5071248 1347  5071269 1345  5071277 1347  5071291 1347  5071302 1345  5071307 1345  
336749 5071307 1345  5071312 1345  5071305 1347  5071307 1345  5071307 1345  5071302 1345  
336750 5071283 1345  5071278 1345  5071259 1345  5071249 1345  5071227 1343  5071207 1345  
336751 5071183 1345  5071170 1343  5071137 1343  5071108 1343  5071086 1341  5071063 1340  
336752 5071027 1343  5071004 1341  5070963 1340  5070934 1340  5070904 1341  5070872 1340  
336753 5070848 1340  5070813 1341  5070785 1341  5070758 1340  5070723 1341  5070703 1341  
336754 5070671 1340  5070648 1340  5070622 1341  5070603 1341  5070589 1341  5070570 1341  
336755 5070544 1343  5070536 1341  5070521 1343  5070521 1343  5070517 1341  5070513 1341  
336756 5070513 1341  5070511 1343  5070522 1341  5070520 1343  5070532 1341  5070546 1341  
336757 5070559 1343  5070578 1343  5070592 1343  5070618 1341  5070632 1341  5070659 1343  
336758 5070678 1343  5070713 1341  5070737 1341  5070759 1343  5070793 1343  5070821 1343  
336759 5070857 1341  5070885 1341  5070919 1341  5070945 1343  5070979 1343  5071008 1343  
336760 5071027 1343  5071060 1343  5071084 1343  5071106 1345  5071127 1343  5071146 1343  
336761 5071170 1343  5071179 1343  5071194 1343  5071208 1343  5071213 1343  5071223 1343  
336762 5071223 1343  5071223 1343  5071229 1341  5071223 1343  5071214 1341  5071214 1341  
336763 5071205 1341  5071194 1343  5071179 1343  5071162 1341  5071148 1341  5071124 1341  
336764 5071103 1343  5071086 1341  5071062 1341  5071038 1341  5071014 1341  5070996 1340  
336765 5070969 1343  5070936 1343  5070923 1341  5070904 1341  5070879 1343  5070856 1341  
336766 5070832 1341  5070813 1341  5070794 1341  5070780 1341  5070759 1343  5070746 1341  
336767 5070731 1343  5070723 1341  5070716 1343  5070711 1343  5070703 1341  5070703 1341  
336768 5070702 1343  5070702 1343  5070711 1343  5070716 1343  5070721 1343  5070732 1341  
336769 5070745 1343  5070758 1345  5070783 1343  5070801 1345  5070821 1343  5070845 1343  
336770 5070868 1345  5070892 1345  5070915 1345  5070934 1345  5070958 1345  5070992 1345  
336771 5071012 1343  5071047 1341  5071070 1343  5071103 1343  5071122 1343  5071146 1343  
336772 5071170 1343  5071203 1343  5071213 1343  5071237 1343  5071261 1343  5071280 1343  
336773 5071296 1341  5071309 1343  5071313 1343  5071325 1341  5071328 1343  5071337 1343  
336774 5071339 1341  5071347 1343  5071337 1343  5071329 1341  5071323 1343  5071315 1341  
336775 5071305 1341  5071284 1343  5071270 1343  5071252 1341  5071223 1343  5071205 1341  
336776 5071181 1341  5071148 1341  5071116 1340  5071087 1340  5071059 1340  5071014 1341  
336777 5070987 1340  5070948 1340  5070920 1340  5070881 1340  5070837 1341  5070805 1340  
336778 5070770 1341  5070732 1341  5070703 1341  5070670 1341  5070636 1341  5070613 1341  
336779 5070579 1341  5070546 1341  5070522 1341  5070503 1341  5070479 1341  5070465 1341  
336780 5070446 1341  5070431 1341  5070427 1341  5070417 1341  5070411 1343  5070412 1341  
336781 5070415 1343  5070417 1341  5070426 1341  5070430 1343  5070446 1341  5070461 1345  
336782 5070479 1341  5070503 1341  5070521 1343  5070544 1343  5070568 1343  5070592 1343  
336783 5070622 1341  5070659 1343  5070692 1343  5070723 1341  5070761 1341  5070793 1343  
336784 5070831 1343  5070860 1343  5070893 1343  5070931 1343  5070960 1343  5070992 1345  
336785 5071022 1343  5071055 1343  5071079 1343  5071108 1343  5071127 1343  5071145 1345  
336786 5071170 1343  5071179 1343  5071196 1341  5071202 1345  5071208 1343  5071213 1343  
336787 5071223 1343  5071223 1343  5071213 1343  5071211 1345  5071207 1345  5071202 1345  
336788 5071183 1345  5071178 1345  5071159 1345  5071144 1345  5071122 1343  5071106 1345  
336789 5071082 1345  5071059 1345  5071033 1347  5071009 1347  5070990 1347  5070966 1347  
336790 5070942 1347  5070911 1351  5070887 1351  5070866 1347  5070839 1351  5070815 1351  
336791 5070796 1351  5070777 1351  5070753 1351  5070739 1351  5070723 1353  5070710 1351  
336792 5070696 1351  5070685 1353  5070680 1353  5070680 1353  5070682 1351  5070678 1355  
336793 5070680 1353  5070683 1355  5070694 1353  5070704 1353  5070707 1355  5070721 1355  
336794 5070736 1355  5070750 1355  5070774 1355  5070793 1355  5070822 1355  5070845 1355  
336795 5070869 1355  5070898 1355  5070922 1355  5070951 1355  5070974 1355  5071003 1355  
336796 5071037 1355  5071070 1355  5071094 1355  5071118 1355  5071151 1355  5071175 1355  
336797 5071204 1355  5071228 1355  5071251 1355  5071271 1355  5071295 1355  5071304 1355  
336798 5071318 1355  5071337 1355  5071342 1355  5071352 1355  5071361 1355  5071361 1355  
336799 5071363 1353  5071361 1355  5071353 1353  5071342 1355  5071330 1353  5071313 1355  
336800 5071301 1353  5071285 1355  5071261 1355  5071237 1355  5071213 1355  5071186 1353  
336801 5071151 1355  5071118 1355  5071086 1353  5071051 1355  5071013 1355  5070974 1355  
336802 5070936 1355  5070898 1355  5070860 1355  5070822 1355  5070784 1355  5070745 1355  
336803 5070707 1355  5070669 1355  5070635 1355  5070602 1355  5070567 1356  5070535 1355  
336804 5070506 1355  5070478 1355  5070454 1355  5070425 1355  5070406 1355  5070392 1355  
336805 5070378 1355  5070366 1356  5070358 1355  5070352 1356  5070352 1356  5070352 1356  
336806 5070354 1355  5070357 1356  5070376 1356  5070381 1356  5070400 1356  5070414 1356  
336807 5070433 1356  5070457 1357  5070481 1356  5070511 1355  5070543 1356  5070576 1356  
336808 5070607 1355  5070643 1356  5070677 1356  5070710 1356  5070749 1356  5070791 1356  
336809 5070822 1355  5070858 1356  5070898 1355  5070925 1356  5070970 1355  5070998 1355  
336810 5071027 1355  5071051 1355  5071085 1355  5071103 1355  5071127 1355  5071151 1355  
336811 5071170 1355  5071184 1355  5071194 1355  5071204 1355  5071213 1355  5071213 1355  
336812 5071213 1355  5071213 1355  5071213 1355  5071204 1355  5071199 1355  5071194 1355  
336813 5071175 1355  5071161 1355  5071146 1355  5071127 1355  5071103 1355  5071084 1355  
336814 5071061 1355  5071037 1355  5071013 1355  5070984 1355  5070960 1355  5070936 1355  
336815 5070906 1356  5070884 1355  5070860 1355  5070826 1355  5070807 1355  5070782 1356  
336816 5070760 1355  5070736 1355  5070720 1356  5070707 1355  5070693 1355  5070683 1355  
336817 5070669 1355  5070659 1355  5070659 1355  5070650 1355  5070650 1355  5070659 1355  
336818 5070659 1355  5070669 1355  5070678 1355  5070683 1355  5070702 1355  5070712 1355  
336819 5070736 1355  5070750 1355  5070774 1355  5070803 1355  5070826 1355  5070850 1355  
336820 5070884 1355  5070908 1355  5070935 1356  5070970 1355  5070998 1355  5071027 1355  
336821 5071059 1356  5071099 1355  5071118 1355  5071151 1355  5071183 1356  5071213 1355  
336822 5071237 1355  5071271 1355  5071293 1356  5071303 1356  5071328 1355  5071342 1355  
336823 5071360 1356  5071365 1356  5071384 1356  5071395 1355  5071395 1355  5071395 1355  
336824 5071395 1355  5071395 1355  5071385 1355  5071366 1355  5071352 1355  5071338 1355  
336825 5071314 1355  5071299 1355  5071275 1355  5071242 1355  5071213 1355  5071184 1355  
336826 5071151 1355  5071113 1355  5071085 1355  5071046 1355  5070998 1355  5070960 1355  
336827 5070922 1355  5070874 1355  5070836 1355  5070793 1355  5070750 1355  5070712 1355  
336828 5070678 1355  5070635 1355  5070602 1355  5070559 1355  5070526 1355  5070502 1355  
336829 5070468 1355  5070445 1355  5070419 1356  5070401 1355  5070382 1355  5070366 1356  
336830 5070354 1355  5070333 1356  5070335 1355  5070328 1356  5070328 1356  5070333 1356  
336831 5070343 1356  5070354 1355  5070366 1356  5070381 1356  5070400 1356  5070419 1356  
336832 5070443 1356  5070467 1356  5070500 1356  5070524 1356  5070558 1356  5070591 1356  
336833 5070624 1356  5070667 1356  5070701 1356  5070734 1356  5070772 1356  5070812 1355  
336834 5070844 1356  5070884 1355  5070920 1356  5070959 1356  5070982 1356  5071016 1356  
336835 5071049 1356  5071073 1356  5071103 1355  5071126 1356  5071150 1356  5071169 1356  
336836 5071183 1356  5071198 1356  5071202 1356  5071216 1356  5071216 1356  5071226 1356  
336837 5071226 1356  5071226 1356  5071216 1356  5071212 1356  5071202 1356  5071193 1356  
336838 5071174 1357  5071159 1356  5071145 1357  5071116 1356  5071097 1356  5071075 1355  
336839 5071049 1356  5071026 1357  5070997 1356  5070975 1355  5070949 1357  5070925 1356  
336840 5070897 1357  5070868 1357  5070844 1356  5070820 1357  5070801 1356  5070772 1356  
336841 5070749 1356  5070734 1356  5070720 1356  5070705 1356  5070691 1356  5070682 1356  
336842 5070677 1356  5070667 1356  5070658 1356  5070658 1356  5070658 1356  5070658 1356  
336843 5070667 1356  5070677 1356  5070682 1356  5070701 1356  5070710 1356  5070734 1356  
336844 5070749 1356  5070772 1356  5070801 1356  5070820 1356  5070844 1356  5070873 1356  
336845 5070897 1356  5070925 1356  5070959 1356  5070992 1356  5071016 1356  5071049 1357  
336846 5071093 1356  5071116 1356  5071150 1356  5071174 1356  5071202 1356  5071236 1356  
336847 5071260 1357  5071293 1357  5071314 1355  5071328 1355  5071350 1356  5071366 1355  
336848 5071385 1355  5071395 1355  5071400 1355  5071400 1355  5071400 1355  5071400 1355  
336849 5071397 1353  5071385 1355  5071377 1353  5071363 1353  5071344 1353  5071322 1351  
336850 5071302 1351  5071278 1351  5071253 1353  5071221 1351  5071197 1351  5071162 1353  
336851 5071121 1351  5071088 1351  5071049 1351  5071005 1353  5070973 1351  5070928 1353  
336852 5070887 1351  5070847 1353  5070809 1353  5070761 1353  5070723 1353  5070685 1353  
336853 5070651 1353  5070613 1353  5070581 1351  5070546 1353  5070515 1351  5070484 1353  
336854 5070454 1355  5070427 1353  5070406 1355  5070393 1353  5070379 1353  5070360 1353  
336855 5070354 1355  5070344 1355  5070334 1355  5070336 1353  5070336 1353  5070344 1355  
336856 5070354 1355  5070358 1355  5070378 1355  5070392 1355  5070416 1355  5070425 1355  
336857 5070454 1355  5070483 1355  5070506 1355  5070535 1355  5070578 1355  5070607 1355  
336858 5070635 1355  5070678 1355  5070707 1355  5070745 1355  5070784 1355  5070822 1355  
336859 5070860 1355  5070893 1355  5070927 1355  5070960 1355  5070994 1355  5071018 1355  
336860 5071051 1355  5071086 1353  5071099 1355  5071120 1353  5071146 1355  5071170 1355  
336861 5071175 1355  5071196 1353  5071201 1353  5071204 1355  5071204 1355  5071205 1353  
336862 5071204 1355  5071204 1355  5071199 1355  5071196 1353  5071175 1355  5071161 1355  
336863 5071151 1355  5071127 1355  5071113 1355  5071094 1355  5071075 1355  5071051 1355  
336864 5071027 1355  5070999 1355  5070975 1355  5070951 1355  5070927 1355  5070908 1355  
336865 5070874 1355  5070851 1355  5070826 1355  5070807 1355  5070784 1355  5070769 1355  
336866 5070744 1356  5070726 1355  5070712 1355  5070702 1355  5070693 1355  5070677 1356  
336867 5070669 1355  5070659 1355  5070650 1355  5070648 1356  5070648 1356  5070648 1356  
336868 5070658 1356  5070667 1356  5070683 1355  5070691 1356  5070710 1356  5070725 1356  
336869 5070750 1355  5070772 1356  5070801 1356  5070820 1356  5070844 1356  5070873 1356  
336870 5070906 1356  5070925 1356  5070968 1356  5070997 1357  5071026 1356  5071059 1356  
336871 5071093 1356  5071116 1356  5071150 1356  5071174 1356  5071202 1356  5071226 1356  
336872 5071250 1356  5071274 1356  5071298 1356  5071312 1356  5071327 1356  5071341 1356  
336873 5071360 1356  5071365 1356  5071374 1356  5071374 1356  5071374 1357  5071374 1356  
336874 5071365 1356  5071360 1356  5071341 1356  5071327 1356  5071312 1356  5071293 1356  
336875 5071269 1356  5071240 1356  5071217 1357  5071193 1356  5071159 1356  5071126 1356  
336876 5071097 1357  5071059 1356  5071016 1356  5070982 1356  5070944 1356  5070906 1356  
336877 5070868 1356  5070825 1356  5070792 1356  5070749 1356  5070710 1357  5070677 1356  
336878 5070643 1356  5070610 1356  5070577 1357  5070543 1357  5070519 1356  5070491 1357  
336879 5070467 1356  5070441 1358  5070424 1356  5070414 1357  5070400 1356  5070390 1357  
336880 5070381 1356  5070376 1357  5070366 1356  5070365 1358  5070374 1358  5070379 1358  
336881 5070389 1358  5070400 1356  5070414 1356  5070424 1356  5070453 1356  5070475 1358  
336882 5070499 1358  5070523 1358  5070547 1358  5070589 1358  5070618 1358  5070645 1360  
336883 5070678 1360  5070718 1358  5070745 1360  5070780 1358  5070819 1358  5070857 1358  
336884 5070890 1358  5070918 1360  5070947 1358  5070979 1360  5071008 1360  5071041 1360  
336885 5071067 1358  5071091 1358  5071115 1358  5071132 1360  5071148 1358  5071167 1358  
336886 5071171 1360  5071180 1360  5071191 1358  5071196 1358  5071196 1358  5071196 1358  
336887 5071196 1358  5071190 1360  5071182 1358  5071172 1358  5071156 1360  5071148 1358  
336888 5071126 1356  5071110 1358  5071097 1356  5071073 1356  5071049 1356  5071035 1357  
336889 5071010 1358  5070992 1356  5070968 1356  5070944 1356  5070921 1356  5070890 1358  
336890 5070868 1356  5070842 1358  5070819 1358  5070801 1356  5070772 1356  5070747 1358  
336891 5070734 1356  5070720 1356  5070704 1358  5070701 1356  5070682 1356  5070675 1358  
336892 5070666 1358  5070656 1358  5070658 1356  5070658 1356  5070656 1358  5070667 1356  
336893 5070675 1358  5070680 1358  5070699 1358  5070710 1356  5070723 1358  5070747 1358  
336894 5070768 1356  5070790 1358  5070811 1357  5070833 1358  5070857 1358  5070891 1358  
336895 5070911 1357  5070943 1358  5070972 1358  5071002 1356  5071035 1356  5071067 1358  
336896 5071097 1356  5071116 1356  5071148 1358  5071174 1356  5071196 1358  5071225 1358  
336897 5071240 1356  5071268 1358  5071292 1358  5071303 1356  5071317 1356  5071325 1358  
336898 5071336 1356  5071341 1356  5071349 1358  5071350 1356  5071341 1356  5071341 1356  
336899 5071334 1358  5071327 1356  5071312 1356  5071298 1356  5071283 1356  5071260 1356  
336900 5071240 1356  5071216 1356  5071193 1356  5071169 1356  5071135 1356  5071102 1356  
336901 5071073 1356  5071045 1356  5071002 1356  5070973 1356  5070935 1357  5070897 1356  
336902 5070868 1356  5070835 1356  5070801 1356  5070768 1356  5070734 1357  5070701 1356  
336903 5070667 1356  5070643 1356  5070610 1356  5070591 1356  5070567 1357  5070543 1356  
336904 5070524 1356  5070505 1356  5070491 1356  5070480 1358  5070467 1357  5070456 1358  
336905 5070453 1356  5070451 1358  5070453 1356  5070453 1357  5070456 1358  5070467 1356  
336906 5070475 1358  5070491 1356  5070499 1358  5070519 1356  5070532 1358  5070548 1356  
336907 5070577 1357  5070600 1356  5070624 1356  5070647 1358  5070680 1358  5070710 1356  
336908 5070744 1356  5070772 1356  5070806 1357  5070835 1356  5070868 1356  5070897 1356  
336909 5070925 1356  5070959 1356  5070991 1358  5071011 1356  5071045 1356  5071068 1356  
336910 5071093 1356  5071102 1356  5071126 1356  5071135 1356  5071150 1356  5071159 1356  
336911 5071175 1355  5071183 1356  5071183 1356  5071193 1356  5071193 1356  5071183 1356  
336912 5071183 1356  5071174 1356  5071169 1356  5071159 1356  5071145 1356  5071126 1356  
336913 5071111 1356  5071097 1356  5071083 1356  5071068 1356  5071046 1355  5071016 1356  
336914 5070998 1355  5070975 1355  5070949 1356  5070927 1355  5070906 1356  5070884 1355  
336915 5070858 1356  5070834 1356  5070812 1355  5070792 1356  5070774 1355  5070750 1355  
336916 5070736 1355  5070721 1355  5070712 1355  5070702 1355  5070693 1355  5070683 1355  
336917 5070678 1355  5070678 1355  5070678 1355  5070678 1355  5070678 1355  5070683 1355  
336918 5070693 1355  5070702 1355  5070712 1355  5070726 1355  5070745 1355  5070760 1355  
336919 5070784 1355  5070802 1355  5070822 1355  5070845 1355  5070869 1355  5070893 1355  
336920 5070922 1355  5070946 1355  5070974 1355  5070998 1355  5071027 1355  5071051 1355  
336921 5071075 1355  5071099 1355  5071118 1355  5071146 1355  5071170 1355  5071194 1355  
336922 5071204 1355  5071228 1355  5071237 1355  5071251 1355  5071261 1355  5071275 1355  
336923 5071275 1355  5071285 1355  5071285 1355  5071285 1355  5071285 1355  5071285 1355  
336924 5071275 1355  5071261 1355  5071251 1355  5071243 1353  5071228 1355  5071204 1355  
336925 5071186 1353  5071172 1353  5071148 1353  5071120 1353  5071099 1355  5071072 1353  
336926 5071038 1353  5071013 1355  5070984 1355  5070952 1353  5070924 1353  5070895 1353  
336927 5070861 1353  5070837 1353  5070809 1353  5070775 1353  5070752 1353  5070728 1353  
336928 5070704 1353  5070680 1353  5070650 1355  5070626 1355  5070613 1353  5070603 1353  
336929 5070580 1353  5070568 1355  5070550 1355  5070544 1355  5070535 1355  5070526 1355  
336930 5070522 1353  5070521 1355  5070521 1355  5070526 1355  5070526 1355  5070544 1355  
336931 5070550 1355  5070568 1355  5070578 1355  5070593 1355  5070607 1355  5070626 1355  
336932 5070650 1355  5070669 1355  5070693 1355  5070722 1355  5070745 1355  5070774 1355  
336933 5070803 1355  5070827 1355  5070861 1353  5070884 1355  5070912 1355  5070946 1355  
336934 5070970 1355  5070998 1355  5071018 1355  5071046 1355  5071070 1355  5071094 1355  
336935 5071105 1353  5071120 1353  5071138 1353  5071153 1353  5071172 1353  5071177 1353  
336936 5071186 1353  5071196 1353  5071196 1353  5071194 1355  5071196 1353  5071196 1353  
336937 5071185 1355  5071186 1353  5071177 1353  5071164 1351  5071146 1355  5071129 1353  
336938 5071114 1353  5071100 1353  5071075 1355  5071062 1353  5071038 1353  5071014 1353  
336939 5070998 1355  5070974 1355  5070952 1353  5070928 1353  5070908 1355  5070884 1355  
336940 5070869 1355  5070847 1353  5070822 1355  5070807 1355  5070793 1355  5070774 1355  
336941 5070760 1355  5070750 1355  5070736 1355  5070726 1355  5070728 1353  5070721 1355  
336942 5070712 1355  5070707 1355  5070707 1355  5070712 1355  5070712 1355  5070722 1355  
336943 5070726 1355  5070736 1355  5070750 1355  5070760 1355  5070774 1355  5070793 1355  
336944 5070807 1355  5070827 1355  5070845 1355  5070869 1355  5070884 1355  5070908 1355  
336945 5070927 1355  5070951 1355  5070975 1355  5070998 1355  5071018 1355  5071037 1355  
336946 5071061 1355  5071085 1355  5071103 1355  5071127 1355  5071146 1355  5071162 1353  
336947 5071175 1355  5071196 1353  5071205 1353  5071215 1353  5071229 1353  5071239 1353  
336948 5071242 1355  5071244 1353  5071253 1353  5071253 1353  5071242 1355  5071243 1353  
336949 5071237 1355  5071237 1355  5071228 1355  5071213 1355  5071201 1353  5071186 1353  
336950 5071170 1355  5071151 1355  5071129 1353  5071113 1355  5071094 1355  5071070 1355  
336951 5071046 1355  5071018 1355  5070998 1355  5070974 1355  5070951 1355  5070928 1353  
336952 5070908 1355  5070874 1355  5070850 1355  5070828 1353  5070807 1355  5070793 1355  
336953 5070771 1353  5070750 1355  5070726 1355  5070714 1353  5070693 1355  5070683 1355  
336954 5070669 1355  5070650 1355  5070645 1355  5070635 1355  5070626 1355  5070626 1355  
336955 5070626 1355  5070621 1355  5070626 1355  5070626 1355  5070635 1355  5070645 1355  
336956 5070659 1355  5070669 1355  5070678 1355  5070691 1356  5070707 1355  5070726 1355  
336957 5070745 1355  5070769 1355  5070792 1356  5070812 1355  5070836 1355  5070860 1355  
336958 5070884 1355  5070908 1355  5070927 1355  5070951 1355  5070984 1355  5071003 1355  
336959 5071027 1355  5071051 1355  5071075 1355  5071094 1355  5071113 1355  5071127 1355  
336960 5071146 1355  5071161 1355  5071170 1355  5071185 1355  5071194 1355  5071199 1355  
336961 5071199 1355  5071204 1355  5071204 1355  5071204 1355  5071204 1355  5071199 1355  
336962 5071194 1355  5071194 1355  5071175 1355  5071170 1355  5071151 1355  5071137 1355  
336963 5071118 1355  5071103 1355  5071085 1355  5071070 1355  5071046 1355  5071018 1355  
336964 5070998 1355  5070984 1355  5070960 1355  5070938 1353  5070912 1355  5070898 1355  
336965 5070874 1355  5070850 1355  5070836 1355  5070822 1355  5070807 1355  5070793 1355  
336966 5070774 1355  5070760 1355  5070750 1355  5070745 1355  5070736 1355  5070726 1355  
336967 5070726 1355  5070722 1355  5070721 1355  5070721 1355  5070721 1355  5070726 1355  
336968 5070736 1355  5070745 1355  5070750 1355  5070760 1355  5070774 1355  5070793 1355  
336969 5070802 1355  5070812 1355  5070827 1355  5070845 1355  5070871 1353  5070884 1355  
336970 5070898 1355  5070922 1355  5070936 1355  5070960 1355  5070975 1355  5070998 1355  
336971 5071013 1355  5071037 1355  5071051 1355  5071075 1355  5071084 1355  5071104 1355  
336972 5071113 1355  5071127 1355  5071137 1355  5071151 1355  5071161 1355  5071170 1355  
336973 5071175 1355  5071175 1355  5071184 1355  5071194 1355  5071194 1355  5071184 1355  
336974 5071175 1355  5071175 1355  5071170 1355  5071151 1355  5071146 1355  5071127 1355  
336975 5071113 1355  5071099 1355  5071084 1355  5071070 1355  5071051 1355  5071037 1355  
336976 5071011 1356  5070997 1356  5070974 1355  5070951 1355  5070936 1355  5070912 1355  
336977 5070892 1356  5070873 1356  5070850 1355  5070825 1356  5070811 1356  5070792 1356  
336978 5070772 1356  5070758 1356  5070745 1355  5070726 1355  5070712 1355  5070705 1356  
336979 5070701 1356  5070693 1355  5070682 1356  5070677 1356  5070669 1355  5070667 1356  
336980 5070667 1356  5070667 1356  5070678 1355  5070682 1356  5070682 1356  5070691 1356  
336981 5070705 1356  5070710 1356  5070725 1356  5070734 1356  5070749 1356  5070768 1356  
336982 5070782 1356  5070806 1356  5070820 1357  5070844 1356  5070868 1356  5070892 1356  
336983 5070911 1356  5070925 1356  5070959 1356  5070973 1356  5070997 1356  5071016 1356  
336984 5071035 1356  5071049 1357  5071073 1357  5071092 1356  5071102 1356  5071116 1356  
336985 5071135 1356  5071145 1357  5071159 1356  5071169 1356  5071174 1356  5071174 1356  
336986 5071183 1357  5071183 1356  5071183 1356  5071174 1356  5071174 1356  5071169 1356  
336987 5071159 1356  5071150 1357  5071135 1356  5071116 1356  5071111 1356  5071093 1356  
336988 5071075 1355  5071059 1356  5071037 1355  5071018 1355  5070998 1355  5070984 1355  
336989 5070960 1355  5070936 1355  5070922 1355  5070898 1355  5070884 1355  5070870 1355  
336990 5070846 1355  5070827 1355  5070812 1355  5070803 1355  5070784 1355  5070774 1355  
336991 5070760 1355  5070750 1355  5070736 1355  5070726 1355  5070722 1355  5070721 1355  
336992 5070712 1355  5070712 1355  5070712 1355  5070712 1355  5070712 1355  5070722 1355  
336993 5070722 1355  5070726 1355  5070736 1355  5070745 1355  5070750 1355  5070769 1355  
336994 5070774 1355  5070793 1355  5070807 1355  5070812 1355  5070826 1355  5070845 1355  
336995 5070869 1355  5070884 1355  5070898 1355  5070912 1355  5070927 1355  5070951 1355  
336996 5070970 1355  5070984 1355  5070998 1355  5071013 1355  5071027 1355  5071046 1355  
336997 5071061 1355  5071075 1355  5071085 1355  5071094 1355  5071103 1355  5071104 1355  
336998 5071113 1355  5071118 1355  5071118 1355  5071118 1355  5071127 1355  5071126 1356  
336999 5071118 1355  5071118 1355  5071113 1355  5071104 1355  5071103 1355  5071094 1355  
337000 5071084 1355  5071070 1355  5071059 1356  5071046 1355  5071026 1356  5071011 1356  
337001 5070998 1355  5070984 1355  5070970 1355  5070946 1355  5070927 1355  5070912 1355  
337002 5070898 1355  5070874 1355  5070860 1355  5070836 1355  5070822 1355  5070807 1355  
337003 5070793 1355  5070784 1355  5070769 1355  5070750 1355  5070745 1355  5070736 1355  
337004 5070736 1355  5070726 1355  5070722 1355  5070720 1356  5070710 1356  5070710 1356  
337005 5070710 1357  5070720 1356  5070720 1356  5070725 1356  5070734 1356  5070744 1356  
337006 5070758 1356  5070772 1356  5070782 1356  5070801 1356  5070811 1356  5070825 1356  
337007 5070844 1356  5070857 1358  5070873 1357  5070892 1356  5070911 1356  5070924 1358  
337008 5070949 1356  5070973 1356  5070991 1358  5071009 1358  5071035 1356  5071048 1358  
337009 5071073 1356  5071093 1356  5071102 1356  5071115 1358  5071134 1358  5071143 1358  
337010 5071158 1358  5071167 1358  5071171 1360  5071172 1358  5071182 1358  5071191 1358  
337011 5071191 1358  5071183 1356  5071182 1358  5071174 1356  5071169 1357  5071159 1356  
337012 5071148 1358  5071143 1358  5071125 1358  5071108 1360  5071096 1358  5071080 1360  
337013 5071066 1360  5071048 1358  5071034 1358  5071010 1358  5070991 1358  5070971 1358  
337014 5070946 1360  5070933 1358  5070909 1358  5070895 1358  5070871 1358  5070857 1358  
337015 5070842 1358  5070824 1358  5070804 1358  5070789 1360  5070780 1358  5070765 1360  
337016 5070745 1360  5070738 1364  5070728 1364  5070722 1360  5070717 1360  5070704 1364  
337017 5070704 1364  5070702 1360  5070699 1364  5070699 1364  5070699 1364  5070699 1364  
337018 5070704 1364  5070714 1364  5070714 1364  5070719 1364  5070728 1364  5070738 1364  
337019 5070741 1366  5070762 1364  5070766 1364  5070786 1364  5070800 1364  5070812 1366  
337020 5070817 1366  5070836 1366  5070853 1364  5070867 1364  5070884 1366  5070905 1364  
337021 5070919 1364  5070937 1366  5070953 1364  5070970 1360  5070986 1364  5070996 1364  
337022 5071010 1364  5071020 1364  5071042 1360  5071046 1360  5071053 1364  5071066 1360  
337023 5071070 1360  5071080 1360  5071081 1358  5071089 1360  5071091 1358  5071091 1358  
337024 5071089 1360  5071089 1360  5071091 1358  5071080 1360  5071072 1358  5071067 1358  
337025 5071058 1358  5071046 1360  5071032 1360  5071024 1358  5071010 1358  5070997 1356  
337026 5070992 1356  5070971 1358  5070957 1358  5070943 1358  5070925 1356  5070911 1356  
337027 5070897 1356  5070873 1356  5070858 1356  5070844 1356  5070834 1356  5070820 1356  
337028 5070806 1356  5070801 1356  5070782 1356  5070772 1356  5070768 1356  5070758 1356  
337029 5070749 1356  5070744 1356  5070744 1356  5070744 1356  5070734 1356  5070744 1356  
337030 5070744 1356  5070744 1356  5070749 1356  5070758 1356  5070758 1356  5070772 1356  
337031 5070782 1356  5070801 1356  5070806 1356  5070820 1356  5070825 1356  5070844 1356  
337032 5070868 1356  5070882 1356  5070898 1355  5070921 1356  5070935 1356  5070959 1356  
337033 5070973 1356  5070992 1356  5071013 1355  5071027 1355  5071049 1356  5071069 1356  
337034 5071083 1357  5071097 1356  5071111 1356  5071116 1356  5071135 1356  5071145 1356  
337035 5071150 1356  5071159 1356  5071161 1355  5071159 1356  5071169 1356  5071169 1356  
337036 5071159 1356  5071159 1356  5071150 1356  5071145 1356  5071135 1356  5071126 1356  
337037 5071111 1356  5071102 1356  5071093 1356  5071073 1356  5071059 1356  5071045 1356  
337038 5071026 1356  5071011 1356  5070992 1356  5070968 1356  5070949 1356  5070925 1356  
337039 5070911 1356  5070892 1356  5070873 1356  5070849 1356  5070825 1356  5070810 1356  
337040 5070792 1356  5070772 1356  5070758 1356  5070744 1356  5070725 1357  5070720 1356  
337041 5070705 1356  5070691 1356  5070680 1358  5070677 1356  5070666 1358  5070658 1356  
337042 5070656 1358  5070645 1360  5070645 1360  5070640 1360  5070645 1360  5070645 1360  
337043 5070645 1360  5070655 1360  5070655 1360  5070664 1360  5070678 1360  5070688 1360  
337044 5070695 1364  5070699 1364  5070714 1364  5070719 1364  5070738 1364  5070752 1364  
337045 5070766 1364  5070795 1364  5070804 1364  5070817 1366  5070843 1364  5070860 1366  
337046 5070876 1364  5070900 1364  5070914 1364  5070927 1366  5070951 1366  5070961 1366  
337047 5070976 1364  5070989 1366  5071005 1364  5071010 1364  5071027 1366  5071037 1366  
337048 5071042 1366  5071042 1366  5071061 1366  5071061 1366  5071067 1364  5071067 1364  
337049 5071066 1366  5071066 1366  5071066 1366  5071062 1364  5071051 1366  5071042 1366  
337050 5071037 1366  5071027 1366  5071008 1366  5071004 1366  5070989 1366  5070976 1364  
337051 5070965 1366  5070951 1366  5070937 1366  5070918 1366  5070905 1364  5070899 1366  
337052 5070886 1364  5070865 1366  5070851 1366  5070838 1364  5070827 1366  5070812 1366  
337053 5070801 1368  5070792 1368  5070784 1366  5070765 1366  5070765 1366  5070751 1366  
337054 5070751 1366  5070741 1366  5070741 1366  5070739 1368  5070739 1368  5070739 1368  
337055 5070741 1366  5070749 1368  5070758 1368  5070765 1366  5070773 1368  5070782 1368  
337056 5070792 1368  5070801 1368  5070816 1368  5070835 1368  5070841 1366  5070864 1368  
337057 5070883 1368  5070897 1368  5070911 1368  5070926 1368  5070950 1368  5070965 1366  
337058 5070988 1368  5071004 1366  5071016 1368  5071040 1368  5071059 1368  5071064 1368  
337059 5071083 1368  5071093 1368  5071104 1366  5071109 1366  5071128 1366  5071136 1368  
337060 5071136 1368  5071142 1366  5071142 1366  5071151 1366  5071151 1366  5071142 1366  
337061 5071142 1366  5071137 1366  5071126 1368  5071128 1366  5071109 1366  5071104 1366  
337062 5071094 1366  5071085 1366  5071064 1368  5071050 1368  5071035 1368  5071016 1368  
337063 5070994 1366  5070985 1366  5070961 1366  5070941 1366  5070918 1366  5070898 1366  
337064 5070873 1368  5070860 1366  5070835 1368  5070812 1366  5070797 1368  5070774 1366  
337065 5070758 1368  5070736 1366  5070717 1366  5070701 1368  5070693 1366  5070675 1364  
337066 5070660 1366  5070641 1366  5070628 1364  5070617 1366  5070614 1364  5070602 1366  
337067 5070599 1364  5070599 1364  5070594 1364  5070594 1364  5070594 1364  5070599 1364  
337068 5070604 1364  5070604 1364  5070614 1364  5070621 1360  5070637 1364  5070645 1360  
337069 5070664 1360  5070674 1360  5070688 1360  5070704 1358  5070717 1360  5070741 1360  
337070 5070757 1358  5070769 1360  5070785 1364  5070807 1360  5070831 1360  5070847 1358  
337071 5070866 1358  5070890 1358  5070905 1358  5070924 1358  5070943 1358  5070957 1358  
337072 5070971 1358  5070991 1358  5070997 1356  5071010 1358  5071016 1356  5071026 1356  
337073 5071035 1356  5071045 1356  5071049 1356  5071049 1356  5071049 1356  5071059 1356  
337074 5071049 1356  5071049 1356  5071049 1356  5071045 1356  5071045 1356  5071026 1356  
337075 5071016 1356  5071011 1356  5071002 1356  5070998 1355  5070982 1356  5070968 1356  
337076 5070959 1356  5070935 1356  5070921 1356  5070911 1356  5070898 1355  5070884 1355  
337077 5070869 1355  5070849 1356  5070834 1356  5070825 1356  5070810 1356  5070806 1356  
337078 5070792 1356  5070774 1355  5070774 1355  5070758 1356  5070750 1355  5070745 1355  
337079 5070745 1355  5070736 1355  5070736 1355  5070736 1355  5070745 1355  5070745 1355  
337080 5070750 1355  5070749 1356  5070769 1355  5070774 1355  5070784 1355  5070801 1356  
337081 5070811 1356  5070822 1355  5070844 1356  5070858 1356  5070873 1356  5070892 1356  
337082 5070911 1356  5070925 1356  5070944 1356  5070968 1356  5070982 1356  5070997 1356  
337083 5071011 1356  5071035 1356  5071049 1356  5071069 1356  5071083 1356  5071097 1356  
337084 5071111 1356  5071126 1356  5071135 1356  5071145 1356  5071150 1356  5071159 1356  
337085 5071169 1356  5071170 1355  5071169 1356  5071169 1356  5071159 1356  5071159 1356  
337086 5071150 1356  5071149 1356  5071135 1356  5071126 1356  5071116 1356  5071103 1355  
337087 5071097 1356  5071085 1355  5071061 1355  5071051 1355  5071027 1355  5071003 1355  
337088 5070994 1355  5070970 1355  5070946 1355  5070922 1355  5070898 1355  5070874 1355  
337089 5070850 1355  5070827 1355  5070812 1355  5070793 1355  5070769 1355  5070745 1355  
337090 5070726 1355  5070707 1355  5070683 1355  5070669 1355  5070650 1355  5070635 1355  
337091 5070620 1356  5070607 1355  5070600 1356  5070591 1356  5070581 1356  5070583 1355  
337092 5070578 1355  5070576 1356  5070578 1355  5070576 1356  5070576 1356  5070582 1356  
337093 5070591 1356  5070602 1355  5070605 1357  5070620 1356  5070634 1356  5070645 1355  
337094 5070658 1356  5070677 1356  5070691 1356  5070705 1356  5070725 1356  5070744 1356  
337095 5070768 1356  5070792 1356  5070811 1356  5070825 1356  5070849 1356  5070873 1356  
337096 5070897 1356  5070911 1356  5070935 1356  5070949 1356  5070970 1355  5070982 1356  
337097 5071003 1355  5071011 1356  5071027 1355  5071037 1355  5071046 1355  5071051 1355  
337098 5071061 1355  5071068 1356  5071068 1356  5071075 1355  5071073 1356  5071073 1356  
337099 5071073 1356  5071069 1356  5071067 1358  5071059 1356  5071046 1360  5071043 1358  
337100 5071032 1360  5071023 1360  5071008 1360  5070991 1364  5070976 1364  5070970 1360  
337101 5070956 1360  5070941 1360  5070922 1360  5070908 1360  5070890 1364  5070876 1364  
337102 5070865 1360  5070843 1364  5070841 1360  5070819 1364  5070807 1360  5070800 1364  
337103 5070795 1364  5070789 1360  5070779 1360  5070766 1364  5070762 1364  5070760 1366  
337104 5070762 1364  5070762 1364  5070762 1364  5070765 1366  5070765 1366  5070774 1366  
337105 5070785 1364  5070798 1366  5070803 1366  5070817 1366  5070836 1366  5070851 1366  
337106 5070864 1368  5070884 1366  5070898 1366  5070913 1366  5070935 1368  5070950 1368  
337107 5070965 1366  5070989 1366  5071005 1364  5071029 1364  5071043 1364  5071061 1366  
337108 5071075 1366  5071094 1366  5071109 1366  5071128 1366  5071142 1366  5071151 1366  
337109 5071166 1366  5071175 1366  5071183 1368  5071190 1366  5071196 1364  5071195 1366  
337110 5071195 1366  5071195 1366  5071195 1366  5071196 1364  5071195 1366  5071190 1366  
337111 5071187 1364  5071175 1366  5071163 1364  5071142 1366  5071128 1366  5071109 1366  
337112 5071094 1366  5071085 1366  5071061 1366  5071043 1364  5071008 1366  5070994 1366  
337113 5070973 1368  5070951 1366  5070926 1368  5070898 1366  5070874 1366  5070849 1368  
337114 5070825 1368  5070797 1368  5070773 1368  5070749 1368  5070734 1368  5070711 1368  
337115 5070693 1366  5070672 1368  5070649 1368  5070636 1366  5070615 1368  5070610 1368  
337116 5070596 1368  5070591 1368  5070582 1368  5070572 1368  5070567 1368  5070567 1368  
337117 5070567 1368  5070567 1368  5070572 1368  5070571 1370  5070580 1370  5070591 1368  
337118 5070594 1370  5070609 1370  5070614 1370  5070633 1370  5070649 1368  5070671 1370  
337119 5070690 1370  5070700 1370  5070724 1370  5070747 1370  5070773 1368  5070795 1370  
337120 5070814 1370  5070832 1371  5070857 1370  5070881 1370  5070900 1370  5070924 1370  
337121 5070948 1370  5070962 1370  5070986 1370  5071001 1370  5071015 1370  5071034 1370  
337122 5071048 1370  5071058 1370  5071072 1370  5071082 1370  5071085 1371  5071091 1370  
337123 5071091 1370  5071099 1372  5071101 1370  5071101 1370  5071091 1370  5071091 1370  
337124 5071087 1370  5071082 1370  5071071 1372  5071064 1368  5071058 1370  5071039 1370  
337125 5071034 1370  5071015 1370  5071000 1370  5070986 1370  5070970 1372  5070958 1370  
337126 5070938 1370  5070913 1371  5070908 1372  5070894 1371  5070880 1372  5070861 1372  
337127 5070844 1373  5070838 1370  5070822 1371  5070812 1371  5070808 1371  5070792 1373  
337128 5070789 1371  5070781 1370  5070779 1372  5070770 1371  5070770 1371  5070768 1373  
337129 5070770 1371  5070770 1371  5070779 1371  5070789 1371  5070794 1371  5070806 1373  
337130 5070812 1371  5070832 1371  5070836 1371  5070856 1371  5070868 1373  5070884 1371  
337131 5070899 1371  5070914 1370  5070932 1371  5070956 1371  5070970 1372  5070989 1371  
337132 5071004 1371  5071023 1371  5071045 1373  5071060 1373  5071085 1372  5071098 1373  
337133 5071123 1371  5071133 1372  5071148 1370  5071161 1371  5071171 1371  5071184 1373  
337134 5071190 1372  5071200 1372  5071204 1372  5071214 1371  5071214 1371  5071224 1371  
337135 5071214 1372  5071214 1372  5071214 1371  5071206 1370  5071200 1371  5071185 1371  
337136 5071180 1371  5071163 1370  5071148 1370  5071123 1371  5071106 1370  5071087 1370  
337137 5071063 1370  5071037 1372  5071015 1370  5070991 1370  5070970 1371  5070938 1370  
337138 5070914 1370  5070886 1370  5070860 1371  5070832 1371  5070809 1370  5070781 1370  
337139 5070755 1372  5070722 1371  5070698 1372  5070681 1370  5070655 1371  5070631 1371  
337140 5070612 1371  5070599 1370  5070590 1370  5070569 1371  5070556 1370  5070545 1372  
337141 5070537 1370  5070531 1371  5070521 1371  5070523 1370  5070513 1370  5070523 1370  
337142 5070521 1371  5070531 1371  5070536 1371  5070545 1371  5070564 1371  5070569 1372  
337143 5070588 1372  5070599 1370  5070612 1372  5070636 1371  5070655 1371  5070679 1372  
337144 5070698 1372  5070724 1370  5070746 1372  5070770 1371  5070794 1371  5070811 1373  
337145 5070835 1373  5070861 1372  5070892 1373  5070911 1373  5070932 1371  5070955 1373  
337146 5070978 1373  5070990 1372  5071004 1371  5071032 1372  5071037 1371  5071056 1372  
337147 5071061 1371  5071080 1371  5071083 1373  5071091 1370  5071090 1372  5071091 1370  
337148 5071099 1372  5071091 1370  5071091 1370  5071091 1370  5071087 1370  5071074 1368  
337149 5071064 1368  5071060 1368  5071052 1366  5071035 1368  5071016 1368  5071002 1368  
337150 5070989 1366  5070973 1368  5070959 1368  5070941 1366  5070918 1366  5070911 1368  
337151 5070888 1368  5070875 1366  5070859 1368  5070840 1368  5070827 1366  5070818 1366  
337152 5070801 1368  5070792 1368  5070784 1366  5070773 1368  5070763 1368  5070758 1368  
337153 5070759 1368  5070749 1368  5070749 1368  5070749 1368  5070758 1368  5070758 1368  
337154 5070763 1368  5070773 1368  5070783 1368  5070791 1370  5070797 1368  5070811 1368  
337155 5070825 1368  5070838 1370  5070859 1368  5070873 1368  5070886 1370  5070910 1370  
337156 5070926 1368  5070950 1368  5070973 1368  5070986 1370  5071005 1370  5071034 1370  
337157 5071058 1370  5071072 1370  5071093 1368  5071106 1370  5071123 1372  5071139 1370  
337158 5071163 1370  5071172 1370  5071187 1370  5071201 1370  5071215 1370  5071225 1370  
337159 5071228 1372  5071239 1370  5071238 1372  5071239 1370  5071239 1370  5071239 1370  
337160 5071228 1372  5071225 1370  5071214 1372  5071206 1370  5071192 1370  5071180 1371  
337161 5071162 1372  5071149 1370  5071123 1371  5071099 1371  5071082 1370  5071056 1372  
337162 5071024 1370  5071000 1370  5070970 1372  5070946 1372  5070913 1372  5070885 1372  
337163 5070857 1370  5070832 1372  5070799 1372  5070770 1372  5070746 1372  5070721 1373  
337164 5070693 1372  5070669 1372  5070645 1372  5070622 1372  5070606 1373  5070588 1372  
337165 5070577 1373  5070564 1372  5070545 1372  5070536 1372  5070529 1373  5070520 1373  
337166 5070512 1371  5070510 1373  5070512 1371  5070521 1372  5070521 1371  5070531 1372  
337167 5070536 1371  5070555 1372  5070571 1370  5070579 1372  5070593 1371  5070609 1370  
337168 5070631 1372  5070645 1372  5070669 1372  5070693 1371  5070712 1371  5070738 1370  
337169 5070762 1370  5070791 1370  5070809 1370  5070838 1370  5070864 1368  5070888 1368  
337170 5070910 1370  5070935 1368  5070958 1370  5070981 1370  5070993 1368  5071016 1368  
337171 5071034 1370  5071050 1368  5071064 1368  5071083 1368  5071087 1370  5071091 1370  
337172 5071102 1368  5071107 1368  5071116 1368  5071117 1368  5071115 1370  5071116 1368  
337173 5071116 1368  5071107 1368  5071102 1368  5071093 1368  5071088 1368  5071074 1368  
337174 5071064 1368  5071050 1368  5071034 1370  5071015 1370  5071002 1368  5070986 1370  
337175 5070970 1372  5070958 1370  5070932 1372  5070913 1371  5070899 1372  5070883 1373  
337176 5070861 1372  5070856 1372  5070832 1372  5070822 1372  5070806 1373  5070792 1373  
337177 5070789 1372  5070779 1372  5070768 1373  5070759 1373  5070759 1373  5070759 1373  
337178 5070759 1373  5070759 1373  5070759 1373  5070767 1375  5070767 1375  5070776 1375  
337179 5070791 1375  5070795 1375  5070810 1375  5070829 1375  5070834 1375  5070850 1379  
337180 5070864 1379  5070881 1375  5070902 1379  5070920 1375  5070940 1379  5070967 1375  
337181 5070977 1381  5071001 1375  5071026 1379  5071053 1375  5071065 1379  5071087 1375  
337182 5071110 1375  5071134 1375  5071154 1375  5071169 1373  5071182 1375  5071197 1375  
337183 5071211 1375  5071225 1375  5071235 1375  5071244 1375  5071255 1373  5071260 1373  
337184 5071260 1373  5071259 1375  5071259 1375  5071260 1373  5071254 1375  5071246 1373  
337185 5071235 1375  5071227 1373  5071212 1373  5071197 1375  5071174 1379  5071159 1375  
337186 5071136 1373  5071101 1375  5071082 1375  5071058 1375  5071026 1379  5071001 1375  
337187 5070977 1375  5070943 1375  5070910 1375  5070881 1375  5070853 1375  5070829 1375  
337188 5070792 1379  5070764 1379  5070733 1375  5070706 1379  5070687 1379  5070663 1379  
337189 5070642 1375  5070616 1379  5070592 1379  5070582 1379  5070563 1379  5070549 1379  
337190 5070539 1379  5070525 1379  5070515 1379  5070515 1379  5070514 1381  5070515 1379  
337191 5070515 1379  5070516 1379  5070525 1379  5070530 1379  5070547 1381  5070561 1381  
337192 5070581 1381  5070592 1379  5070600 1381  5070624 1381  5070638 1381  5070663 1379  
337193 5070686 1381  5070700 1381  5070729 1381  5070754 1379  5070781 1381  5070805 1381  
337194 5070831 1379  5070853 1381  5070886 1381  5070905 1381  5070929 1381  5070955 1379  
337195 5070977 1381  5070991 1381  5071015 1381  5071031 1379  5071048 1381  5071072 1381  
337196 5071082 1381  5071092 1381  5071107 1379  5071117 1379  5071127 1379  5071127 1379  
337197 5071134 1375  5071131 1379  5071134 1375  5071131 1379  5071131 1379  5071127 1379  
337198 5071120 1375  5071098 1379  5071093 1379  5071083 1379  5071077 1375  5071058 1375  
337199 5071041 1379  5071029 1375  5071010 1375  5070993 1379  5070974 1379  5070958 1375  
337200 5070940 1379  5070926 1379  5070902 1379  5070891 1375  5070873 1379  5070854 1379  
337201 5070840 1379  5070826 1379  5070807 1379  5070805 1375  5070795 1375  5070788 1379  
337202 5070783 1379  5070773 1379  5070764 1379  5070764 1379  5070754 1379  5070754 1379  
337203 5070764 1379  5070764 1379  5070773 1379  5070783 1379  5070788 1379  5070791 1381  
337204 5070806 1379  5070824 1381  5070838 1381  5070853 1381  5070872 1381  5070891 1381  
337205 5070907 1379  5070931 1379  5070948 1381  5070974 1379  5070993 1379  5071015 1381  
337206 5071041 1379  5071065 1379  5071083 1379  5071107 1379  5071131 1379  5071155 1379  
337207 5071174 1379  5071194 1379  5071208 1379  5071222 1379  5071241 1379  5071251 1379  
337208 5071265 1379  5071275 1379  5071279 1379  5071283 1381  5071284 1379  5071284 1379  
337209 5071284 1379  5071284 1379  5071279 1379  5071275 1379  5071256 1379  5071244 1375  
337210 5071222 1379  5071211 1375  5071194 1379  5071174 1379  5071150 1379  5071117 1379  
337211 5071093 1379  5071074 1379  5071044 1375  5071010 1375  5070981 1375  5070953 1375  
337212 5070917 1379  5070888 1379  5070854 1379  5070830 1379  5070802 1379  5070773 1379  
337213 5070749 1379  5070719 1375  5070692 1379  5070673 1379  5070649 1379  5070628 1375  
337214 5070609 1375  5070587 1379  5070572 1379  5070563 1379  5070547 1381  5070542 1375  
337215 5070530 1379  5070530 1379  5070530 1379  5070530 1379  5070530 1379  5070539 1379  
337216 5070549 1379  5070558 1379  5070566 1375  5070582 1379  5070590 1381  5070606 1379  
337217 5070625 1379  5070639 1379  5070663 1379  5070686 1381  5070705 1381  5070729 1381  
337218 5070753 1381  5070781 1381  5070805 1381  5070829 1381  5070853 1381  5070886 1381  
337219 5070905 1381  5070929 1381  5070963 1381  5070982 1381  5070996 1381  5071025 1381  
337220 5071048 1381  5071063 1381  5071077 1381  5071092 1381  5071106 1381  5071125 1381  
337221 5071130 1381  5071139 1381  5071149 1381  5071154 1381  5071154 1381  5071154 1381  
337222 5071154 1381  5071149 1381  5071149 1381  5071139 1381  5071130 1381  5071115 1381  
337223 5071106 1381  5071092 1381  5071077 1381  5071072 1381  5071048 1381  5071030 1381  
337224 5071015 1381  5070991 1381  5070977 1381  5070963 1381  5070940 1379  5070926 1379  
337225 5070907 1379  5070886 1381  5070873 1379  5070853 1381  5070838 1381  5070826 1379  
337226 5070805 1381  5070791 1381  5070786 1381  5070781 1381  5070771 1381  5070763 1379  
337227 5070754 1379  5070754 1379  5070753 1381  5070754 1379  5070753 1381  5070753 1381  
337228 5070762 1381  5070772 1381  5070788 1379  5070791 1381  5070806 1379  5070826 1379  
337229 5070840 1379  5070854 1379  5070878 1379  5070893 1379  5070917 1379  5070931 1379  
337230 5070955 1379  5070978 1379  5070998 1379  5071029 1375  5071048 1381  5071082 1375  
337231 5071093 1379  5071120 1375  5071141 1379  5071165 1379  5071182 1375  5071197 1375  
337232 5071221 1375  5071235 1375  5071244 1375  5071259 1375  5071268 1375  5071279 1379  
337233 5071279 1379  5071287 1375  5071287 1375  5071287 1375  5071282 1375  5071282 1375  
337234 5071278 1375  5071256 1379  5071254 1375  5071235 1375  5071220 1375  5071197 1375  
337235 5071184 1373  5071158 1375  5071131 1373  5071102 1373  5071082 1375  5071055 1373  
337236 5071029 1375  5070997 1373  5070969 1373  5070935 1373  5070907 1373  5070876 1375  
337237 5070844 1373  5070811 1373  5070787 1373  5070757 1375  5070730 1373  5070706 1373  
337238 5070687 1373  5070654 1373  5070630 1373  5070612 1372  5070596 1373  5070587 1373  
337239 5070568 1373  5070553 1373  5070544 1373  5070534 1373  5070529 1373  5070529 1373  
337240 5070528 1375  5070529 1373  5070534 1373  5070542 1375  5070553 1373  5070561 1375  
337241 5070566 1375  5070585 1375  5070595 1375  5070609 1375  5070628 1375  5070652 1375  
337242 5070677 1373  5070690 1375  5070709 1375  5070733 1375  5070757 1375  5070791 1375  
337243 5070810 1375  5070834 1375  5070857 1375  5070878 1379  5070905 1375  5070929 1375  
337244 5070958 1375  5070981 1375  5070996 1375  5071020 1375  5071034 1375  5071058 1375  
337245 5071079 1373  5071088 1373  5071098 1373  5071112 1373  5071120 1375  5071130 1375  
337246 5071134 1375  5071134 1375  5071145 1373  5071134 1375  5071136 1373  5071134 1375  
337247 5071130 1375  5071117 1379  5071111 1375  5071101 1375  5071093 1379  5071082 1375  
337248 5071065 1379  5071053 1375  5071034 1375  5071020 1375  5070993 1379  5070979 1379  
337249 5070964 1379  5070940 1379  5070926 1379  5070907 1379  5070886 1381  5070873 1379  
337250 5070850 1379  5070829 1381  5070814 1381  5070805 1381  5070791 1381  5070781 1381  
337251 5070772 1381  5070753 1381  5070748 1381  5070746 1383  5070738 1381  5070737 1383  
337252 5070727 1383  5070738 1381  5070738 1381  5070737 1383  5070753 1381  5070751 1383  
337253 5070772 1381  5070785 1383  5070800 1381  5070815 1381  5070827 1383  5070846 1383  
337254 5070870 1383  5070890 1383  5070904 1383  5070929 1381  5070952 1383  5070975 1383  
337255 5070996 1381  5071025 1381  5071047 1383  5071071 1383  5071090 1383  5071115 1381  
337256 5071139 1381  5071152 1383  5071176 1383  5071191 1383  5071205 1383  5071219 1383  
337257 5071238 1383  5071252 1383  5071264 1381  5071272 1383  5071278 1381  5071276 1383  
337258 5071276 1383  5071278 1381  5071276 1383  5071272 1383  5071262 1383  5071254 1381  
337259 5071240 1381  5071229 1383  5071214 1383  5071195 1383  5071176 1383  5071154 1381  
337260 5071130 1381  5071105 1383  5071081 1383  5071063 1381  5071030 1381  5071006 1381  
337261 5070977 1381  5070948 1381  5070915 1381  5070887 1381  5070853 1381  5070829 1381  
337262 5070800 1381  5070772 1381  5070748 1381  5070724 1381  5070700 1381  5070671 1381  
337263 5070659 1379  5070630 1379  5070614 1381  5070600 1381  5070590 1381  5070582 1379  
337264 5070571 1381  5070571 1381  5070561 1381  5070562 1381  5070561 1381  5070562 1381  
337265 5070571 1381  5070581 1381  5070586 1381  5070590 1381  5070605 1381  5070624 1381  
337266 5070638 1381  5070657 1381  5070681 1381  5070691 1381  5070714 1381  5070729 1381  
337267 5070753 1381  5070781 1381  5070800 1381  5070826 1379  5070853 1381  5070878 1379  
337268 5070901 1381  5070925 1381  5070950 1379  5070972 1381  5070991 1381  5071015 1381  
337269 5071039 1381  5071054 1381  5071077 1381  5071092 1381  5071106 1381  5071125 1381  
337270 5071139 1381  5071149 1381  5071154 1381  5071163 1381  5071163 1381  5071173 1381  
337271 5071173 1381  5071173 1381  5071163 1381  5071163 1381  5071154 1381  5071154 1381  
337272 5071139 1381  5071130 1381  5071125 1381  5071106 1381  5071097 1381  5071077 1381  
337273 5071063 1381  5071048 1381  5071030 1381  5071015 1381  5070991 1381  5070978 1379  
337274 5070953 1381  5070939 1381  5070917 1379  5070901 1381  5070877 1381  5070862 1381  
337275 5070850 1379  5070829 1381  5070814 1381  5070800 1381  5070792 1379  5070786 1381  
337276 5070772 1381  5070762 1381  5070762 1381  5070762 1381  5070753 1381  5070753 1381  
337277 5070762 1381  5070762 1381  5070772 1381  5070781 1381  5070786 1381  5070800 1381  
337278 5070814 1381  5070829 1381  5070848 1381  5070862 1381  5070886 1381  5070901 1381  
337279 5070925 1381  5070948 1381  5070972 1381  5070982 1381  5071006 1381  5071030 1381  
337280 5071063 1381  5071082 1381  5071106 1381  5071130 1381  5071154 1381  5071173 1381  
337281 5071192 1381  5071206 1381  5071221 1381  5071240 1381  5071254 1381  5071273 1381  
337282 5071278 1381  5071283 1381  5071292 1381  5071292 1381  5071292 1381  5071292 1381  
337283 5071292 1381  5071283 1381  5071278 1381  5071273 1381  5071254 1381  5071249 1381  
337284 5071230 1381  5071216 1381  5071192 1381  5071178 1381  5071154 1381  5071125 1381  
337285 5071096 1381  5071077 1381  5071053 1381  5071025 1381  5070996 1381  5070972 1381  
337286 5070948 1381  5070915 1381  5070885 1383  5070862 1381  5070829 1381  5070803 1383  
337287 5070786 1381  5070761 1383  5070737 1383  5070714 1381  5070700 1381  5070686 1381  
337288 5070660 1383  5070656 1383  5070638 1381  5070627 1383  5070622 1383  5070622 1383  
337289 5070613 1383  5070611 1385  5070613 1383  5070613 1383  5070622 1383  5070625 1385  
337290 5070636 1383  5070646 1383  5070659 1385  5070668 1385  5070684 1383  5070698 1383  
337291 5070722 1383  5070737 1383  5070761 1383  5070785 1383  5070802 1385  5070827 1383  
337292 5070845 1385  5070874 1385  5070899 1383  5070921 1385  5070945 1385  5070969 1385  
337293 5070988 1385  5071012 1385  5071034 1387  5071060 1385  5071074 1385  5071093 1385  
337294 5071114 1383  5071127 1385  5071136 1385  5071150 1385  5071171 1383  5071171 1383  
337295 5071175 1385  5071181 1383  5071191 1383  5071194 1385  5071195 1383  5071195 1383  
337296 5071191 1383  5071191 1383  5071181 1383  5071176 1383  5071171 1383  5071152 1383  
337297 5071147 1383  5071128 1383  5071114 1383  5071095 1383  5071080 1383  5071062 1383  
337298 5071047 1383  5071028 1383  5071004 1383  5070980 1383  5070971 1383  5070947 1383  
337299 5070928 1383  5070904 1383  5070890 1383  5070870 1383  5070851 1383  5070835 1385  
337300 5070821 1385  5070811 1385  5070799 1383  5070789 1383  5070779 1383  5070769 1385  
337301 5070769 1385  5070759 1385  5070759 1385  5070761 1383  5070761 1383  5070761 1383  
337302 5070769 1385  5070778 1385  5070783 1385  5070802 1385  5070811 1385  5070821 1385  
337303 5070835 1385  5070861 1383  5070874 1385  5070888 1385  5070912 1385  5070926 1385  
337304 5070950 1385  5070974 1385  5070992 1387  5071012 1385  5071036 1385  5071060 1385  
337305 5071074 1385  5071094 1385  5071122 1385  5071136 1385  5071160 1385  5071175 1385  
337306 5071191 1383  5071203 1385  5071216 1387  5071227 1385  5071246 1385  5071251 1385  
337307 5071261 1385  5071261 1385  5071270 1385  5071270 1385  5071270 1385  5071261 1385  
337308 5071251 1385  5071246 1385  5071235 1387  5071217 1385  5071213 1385  5071194 1385  
337309 5071175 1385  5071160 1385  5071138 1383  5071112 1385  5071095 1383  5071076 1383  
337310 5071047 1383  5071022 1385  5070993 1385  5070975 1383  5070952 1383  5070923 1383  
337311 5070899 1383  5070875 1383  5070850 1385  5070827 1383  5070803 1383  5070785 1383  
337312 5070769 1385  5070751 1383  5070727 1383  5070711 1385  5070698 1383  5070688 1385  
337313 5070684 1383  5070670 1383  5070659 1385  5070660 1383  5070656 1383  5070654 1385  
337314 5070656 1383  5070656 1383  5070659 1385  5070659 1385  5070670 1383  5070679 1383  
337315 5070688 1385  5070697 1385  5070713 1383  5070727 1383  5070745 1385  5070759 1385  
337316 5070780 1383  5070799 1383  5070821 1385  5070837 1383  5070861 1383  5070883 1385  
337317 5070904 1383  5070926 1385  5070947 1383  5070969 1385  5070988 1385  5071014 1383  
337318 5071038 1383  5071052 1383  5071076 1383  5071089 1385  5071114 1383  5071127 1385  
337319 5071138 1383  5071151 1385  5071162 1383  5071176 1383  5071181 1383  5071181 1383  
337320 5071191 1383  5071195 1383  5071194 1385  5071194 1385  5071194 1385  5071189 1385  
337321 5071191 1383  5071181 1383  5071174 1385  5071171 1383  5071152 1383  5071147 1383  
337322 5071128 1383  5071105 1383  5071090 1383  5071077 1381  5071052 1383  5071038 1383  
337323 5071012 1385  5070990 1383  5070971 1383  5070952 1383  5070923 1383  5070904 1383  
337324 5070885 1383  5070870 1383  5070848 1381  5070827 1383  5070804 1383  5070799 1383  
337325 5070785 1383  5070770 1383  5070761 1383  5070751 1383  5070746 1383  5070738 1381  
337326 5070729 1381  5070729 1381  5070729 1381  5070729 1381  5070727 1383  5070737 1383  
337327 5070748 1381  5070751 1383  5070770 1383  5070779 1383  5070789 1383  5070804 1383  
337328 5070823 1383  5070835 1385  5070850 1385  5070874 1385  5070888 1385  5070912 1385  
337329 5070928 1383  5070950 1385  5070974 1385  5070988 1385  5071012 1385  5071038 1383  
337330 5071052 1383  5071074 1385  5071094 1385  5071112 1385  5071127 1385  5071147 1383  
337331 5071151 1385  5071170 1385  5071174 1385  5071191 1383  5071195 1383  5071206 1381  
337332 5071205 1383  5071205 1383  5071205 1383  5071205 1383  5071203 1385  5071206 1381  
337333 5071197 1381  5071181 1383  5071176 1383  5071170 1385  5071152 1383  5071138 1383  
337334 5071124 1383  5071105 1383  5071080 1383  5071071 1383  5071047 1383  5071023 1383  
337335 5070993 1385  5070980 1383  5070961 1383  5070937 1383  5070913 1383  5070890 1383  
337336 5070872 1381  5070851 1383  5070828 1383  5070805 1381  5070789 1383  5070770 1383  
337337 5070753 1381  5070737 1383  5070722 1383  5070703 1383  5070698 1383  5070689 1383  
337338 5070686 1381  5070679 1383  5070670 1383  5070670 1383  5070671 1381  5070670 1383  
337339 5070670 1383  5070670 1383  5070679 1383  5070684 1383  5070698 1383  5070703 1383  
337340 5070722 1383  5070737 1383  5070751 1383  5070761 1383  5070785 1383  5070799 1383  
337341 5070813 1383  5070837 1383  5070861 1383  5070885 1383  5070904 1383  5070923 1383  
337342 5070945 1385  5070972 1381  5070980 1383  5071012 1385  5071028 1383  5071052 1383  
337343 5071071 1383  5071090 1383  5071104 1383  5071122 1385  5071138 1383  5071150 1385  
337344 5071171 1383  5071176 1383  5071181 1383  5071181 1383  5071189 1385  5071195 1383  
337345 5071195 1383  5071205 1383  5071194 1385  5071195 1383  5071195 1383  5071191 1383  
337346 5071181 1383  5071171 1383  5071162 1383  5071149 1381  5071130 1381  5071115 1381  
337347 5071095 1383  5071077 1381  5071063 1381  5071038 1383  5071014 1383  5070995 1383  
337348 5070977 1381  5070952 1383  5070928 1383  5070905 1381  5070891 1381  5070870 1383  
337349 5070848 1381  5070828 1383  5070804 1383  5070789 1383  5070779 1383  5070761 1383  
337350 5070751 1383  5070737 1383  5070727 1383  5070722 1383  5070711 1385  5070711 1385  
337351 5070703 1383  5070702 1385  5070702 1385  5070711 1385  5070713 1383  5070722 1383  
337352 5070727 1383  5070737 1383  5070751 1383  5070770 1383  5070783 1385  5070788 1385  
337353 5070804 1383  5070823 1383  5070837 1383  5070861 1383  5070877 1381  5070890 1383  
337354 5070915 1381  5070937 1383  5070963 1381  5070975 1383  5070995 1383  5071014 1383  
337355 5071038 1383  5071052 1383  5071070 1385  5071090 1383  5071104 1383  5071124 1383  
337356 5071138 1383  5071147 1383  5071162 1383  5071171 1383  5071175 1385  5071181 1383  
337357 5071181 1383  5071181 1383  5071191 1383  5071192 1381  5071181 1383  5071181 1383  
337358 5071176 1383  5071171 1383  5071162 1383  5071152 1383  5071138 1383  5071125 1381  
337359 5071115 1381  5071089 1385  5071076 1383  5071061 1383  5071047 1383  5071028 1383  
337360 5071014 1383  5070990 1383  5070971 1383  5070947 1383  5070928 1383  5070904 1383  
337361 5070883 1385  5070872 1381  5070848 1381  5070827 1383  5070813 1383  5070800 1381  
337362 5070785 1383  5070770 1383  5070761 1383  5070751 1383  5070746 1383  5070737 1383  
337363 5070729 1381  5070727 1383  5070723 1383  5070722 1383  5070722 1383  5070727 1383  
337364 5070727 1383  5070738 1381  5070746 1383  5070751 1383  5070770 1383  5070779 1383  
337365 5070789 1383  5070802 1385  5070823 1383  5070845 1385  5070859 1385  5070874 1385  
337366 5070899 1383  5070913 1383  5070937 1383  5070950 1385  5070974 1385  5070993 1385  
337367 5071023 1383  5071036 1385  5071061 1383  5071076 1383  5071095 1383  5071114 1383  
337368 5071128 1383  5071147 1383  5071160 1385  5071175 1385  5071179 1385  5071194 1385  
337369 5071205 1383  5071219 1383  5071229 1383  5071229 1383  5071237 1385  5071238 1383  
337370 5071238 1383  5071240 1381  5071238 1383  5071229 1383  5071219 1383  5071216 1381  
337371 5071206 1381  5071191 1383  5071178 1381  5071163 1381  5071147 1383  5071130 1381  
337372 5071114 1383  5071092 1381  5071071 1383  5071052 1383  5071028 1383  5071004 1383  
337373 5070980 1383  5070961 1383  5070937 1383  5070913 1383  5070891 1381  5070875 1383  
337374 5070861 1383  5070837 1383  5070823 1383  5070805 1381  5070789 1383  5070780 1383  
337375 5070761 1383  5070746 1383  5070737 1383  5070727 1383  5070722 1383  5070713 1383  
337376 5070713 1383  5070713 1383  5070713 1383  5070711 1385  5070713 1383  5070721 1385  
337377 5070727 1383  5070737 1383  5070746 1383  5070759 1385  5070769 1385  5070785 1383  
337378 5070797 1385  5070811 1385  5070826 1385  5070850 1385  5070869 1385  5070890 1383  
337379 5070902 1385  5070926 1385  5070947 1383  5070969 1385  5070979 1385  5071003 1385  
337380 5071022 1385  5071046 1385  5071060 1385  5071076 1383  5071087 1387  5071103 1385  
337381 5071122 1385  5071135 1387  5071146 1385  5071151 1385  5071160 1385  5071171 1383  
337382 5071176 1383  5071179 1385  5071179 1385  5071191 1383  5071182 1381  5071181 1383  
337383 5071179 1385  5071177 1381  5071171 1383  5071162 1383  5071154 1381  5071138 1383  
337384 5071124 1383  5071114 1383  5071095 1383  5071080 1383  5071071 1383  5071047 1383  
337385 5071030 1381  5071014 1383  5070993 1385  5070974 1385  5070961 1383  5070937 1383  
337386 5070923 1383  5070904 1383  5070885 1383  5070875 1383  5070852 1383  5070835 1385  
337387 5070821 1385  5070814 1381  5070802 1385  5070789 1383  5070788 1385  5070785 1383  
337388 5070783 1385  5070778 1385  5070779 1383  5070778 1385  5070778 1385  5070778 1385  
337389 5070783 1385  5070788 1385  5070797 1385  5070802 1385  5070821 1385  5070824 1387  
337390 5070834 1387  5070848 1387  5070872 1387  5070888 1385  5070901 1387  5070925 1387  
337391 5070944 1387  5070969 1385  5070977 1387  5071001 1387  5071025 1387  5071050 1385  
337392 5071068 1387  5071087 1387  5071103 1385  5071125 1387  5071144 1387  5071168 1387  
337393 5071178 1387  5071194 1385  5071211 1387  5071227 1385  5071235 1387  5071251 1385  
337394 5071259 1387  5071270 1385  5071270 1385  5071275 1385  5071275 1385  5071275 1385  
337395 5071276 1383  5071272 1383  5071261 1385  5071251 1385  5071248 1383  5071227 1385  
337396 5071217 1385  5071205 1383  5071189 1385  5071175 1385  5071152 1383  5071138 1383  
337397 5071112 1385  5071090 1383  5071071 1383  5071046 1385  5071027 1385  5070995 1383  
337398 5070974 1385  5070950 1385  5070928 1383  5070904 1383  5070883 1385  5070861 1383  
337399 5070837 1383  5070813 1383  5070788 1385  5070780 1383  5070759 1385  5070735 1385  
337400 5070721 1385  5070711 1385  5070697 1385  5070688 1385  5070683 1385  5070668 1385  
337401 5070668 1385  5070668 1385  5070667 1387  5070659 1385  5070659 1385  5070668 1385  
337402 5070678 1385  5070681 1387  5070687 1385  5070696 1387  5070702 1385  5070719 1387  
337403 5070724 1387  5070743 1387  5070759 1385  5070782 1387  5070796 1387  5070821 1385  
337404 5070843 1387  5070858 1387  5070888 1385  5070901 1387  5070925 1387  5070948 1387  
337405 5070968 1387  5070988 1385  5071001 1387  5071027 1385  5071044 1387  5071060 1385  
337406 5071073 1387  5071092 1387  5071101 1387  5071121 1387  5071125 1387  5071136 1385  
337407 5071146 1385  5071151 1385  5071159 1387  5071160 1385  5071159 1387  5071159 1387  
337408 5071160 1385  5071151 1385  5071151 1385  5071146 1385  5071136 1385  5071125 1387  
337409 5071112 1385  5071094 1385  5071089 1385  5071073 1387  5071060 1385  5071045 1385  
337410 5071027 1385  5071014 1383  5070993 1385  5070975 1383  5070960 1385  5070945 1385  
337411 5070922 1385  5070901 1387  5070888 1385  5070874 1385  5070858 1387  5070845 1385  
337412 5070834 1387  5070820 1387  5070810 1387  5070801 1387  5070796 1387  5070786 1387  
337413 5070782 1387  5070782 1387  5070777 1387  5070777 1387  5070775 1388  5070781 1387  
337414 5070780 1388  5070785 1388  5070796 1387  5070800 1387  5070810 1387  5070820 1387  
337415 5070842 1388  5070858 1387  5070872 1387  5070882 1387  5070902 1385  5070921 1385  
337416 5070944 1387  5070960 1385  5070977 1387  5071001 1387  5071027 1385  5071045 1385  
337417 5071068 1387  5071089 1385  5071103 1385  5071125 1387  5071149 1387  5071168 1387  
337418 5071178 1387  5071192 1387  5071213 1385  5071227 1385  5071235 1387  5071246 1385  
337419 5071259 1387  5071261 1385  5071270 1385  5071270 1385  5071270 1385  5071270 1385  
337420 5071261 1385  5071261 1385  5071252 1383  5071248 1383  5071237 1385  5071219 1383  
337421 5071203 1385  5071191 1383  5071176 1383  5071159 1387  5071136 1385  5071112 1385  
337422 5071090 1383  5071070 1385  5071047 1383  5071022 1385  5070993 1385  5070974 1385  
337423 5070945 1385  5070922 1385  5070898 1385  5070869 1385  5070845 1385  5070821 1385  
337424 5070797 1385  5070769 1385  5070750 1385  5070724 1387  5070700 1387  5070688 1385  
337425 5070668 1385  5070654 1385  5070635 1385  5070625 1385  5070611 1385  5070601 1385  
337426 5070595 1387  5070587 1385  5070582 1385  5070581 1387  5070582 1385  5070582 1385  
337427 5070587 1385  5070587 1385  5070597 1385  5070601 1385  5070609 1387  5070624 1387  
337428 5070644 1385  5070657 1387  5070678 1385  5070697 1385  5070721 1385  5070734 1387  
337429 5070758 1387  5070782 1387  5070802 1385  5070834 1387  5070858 1387  5070881 1387  
337430 5070902 1385  5070925 1387  5070958 1387  5070974 1385  5070993 1385  5071020 1387  
337431 5071036 1385  5071049 1387  5071069 1385  5071089 1385  5071103 1385  5071111 1387  
337432 5071125 1387  5071135 1387  5071144 1387  5071149 1387  5071150 1385  5071151 1385  
337433 5071151 1385  5071149 1387  5071151 1385  5071146 1385  5071136 1385  5071127 1385  
337434 5071122 1385  5071103 1385  5071093 1385  5071077 1387  5071071 1383  5071045 1385  
337435 5071027 1385  5071012 1385  5070993 1385  5070974 1385  5070960 1385  5070945 1385  
337436 5070926 1385  5070902 1385  5070888 1385  5070872 1387  5070859 1385  5070843 1387  
337437 5070834 1387  5070820 1387  5070800 1387  5070796 1387  5070783 1385  5070783 1385  
337438 5070777 1387  5070767 1387  5070767 1387  5070767 1387  5070767 1387  5070767 1387  
337439 5070777 1387  5070777 1387  5070782 1387  5070786 1387  5070800 1387  5070820 1387  
337440 5070834 1387  5070848 1387  5070867 1387  5070887 1387  5070901 1387  5070920 1387  
337441 5070944 1387  5070968 1387  5070987 1387  5071010 1387  5071035 1387  5071059 1387  
337442 5071073 1387  5071092 1387  5071121 1387  5071144 1387  5071159 1387  5071179 1385  
337443 5071192 1387  5071213 1385  5071226 1387  5071245 1387  5071249 1387  5071269 1387  
337444 5071274 1387  5071273 1387  5071280 1385  5071288 1387  5071278 1387  5071280 1385  
337445 5071278 1387  5071275 1385  5071270 1385  5071259 1387  5071249 1387  5071237 1385  
337446 5071216 1387  5071203 1385  5071179 1385  5071168 1387  5071146 1385  5071124 1383  
337447 5071095 1383  5071071 1383  5071047 1383  5071023 1383  5070990 1383  5070963 1381  
337448 5070929 1381  5070901 1381  5070877 1381  5070848 1381  5070816 1379  5070786 1381  
337449 5070764 1379  5070729 1381  5070705 1381  5070683 1379  5070659 1379  5070630 1379  
337450 5070605 1381  5070595 1375  5070573 1379  5070558 1379  5070539 1379  5070525 1379  
337451 5070515 1379  5070506 1379  5070501 1379  5070501 1379  5070491 1379  5070490 1381  
337452 5070499 1381  5070504 1381  5070514 1381  5070525 1379  5070538 1381  5070547 1381  
337453 5070561 1381  5070581 1381  5070600 1381  5070624 1381  5070648 1381  5070662 1381  
337454 5070691 1381  5070714 1381  5070748 1381  5070781 1381  5070800 1381  5070824 1381  
337455 5070853 1381  5070886 1381  5070915 1381  5070939 1381  5070972 1381  5070991 1381  
337456 5071015 1381  5071030 1381  5071054 1381  5071072 1381  5071092 1381  5071106 1381  
337457 5071115 1381  5071130 1381  5071139 1381  5071150 1379  5071149 1381  5071155 1379  
337458 5071155 1379  5071155 1379  5071155 1379  5071149 1381  5071141 1379  5071130 1381  
337459 5071127 1379  5071108 1379  5071098 1379  5071082 1381  5071065 1379  5071050 1379  
337460 5071031 1379  5071006 1381  5070991 1381  5070972 1381  5070953 1381  5070939 1381  
337461 5070925 1381  5070901 1381  5070886 1381  5070863 1381  5070848 1381  5070829 1381  
337462 5070814 1381  5070800 1381  5070786 1381  5070781 1381  5070772 1381  5070753 1381  
337463 5070753 1381  5070748 1381  5070748 1381  5070738 1381  5070738 1381  5070748 1381  
337464 5070748 1381  5070753 1381  5070762 1381  5070772 1381  5070786 1381  5070800 1381  
337465 5070805 1381  5070829 1381  5070848 1381  5070872 1381  5070886 1381  5070905 1381  
337466 5070929 1381  5070955 1379  5070977 1381  5070996 1381  5071025 1381  5071048 1381  
337467 5071077 1381  5071097 1381  5071125 1381  5071149 1381  5071163 1381  5071182 1381  
337468 5071197 1381  5071221 1381  5071240 1381  5071254 1381  5071273 1381  5071278 1381  
337469 5071292 1381  5071292 1381  5071297 1381  5071307 1381  5071307 1381  5071306 1381  
337470 5071297 1381  5071297 1381  5071294 1379  5071283 1381  5071278 1381  5071264 1381  
337471 5071249 1381  5071221 1381  5071206 1381  5071182 1381  5071163 1381  5071139 1381  
337472 5071106 1381  5071077 1381  5071049 1381  5071025 1381  5070991 1381  5070963 1381  
337473 5070925 1381  5070891 1381  5070862 1381  5070829 1381  5070791 1381  5070762 1381  
337474 5070729 1381  5070700 1381  5070671 1381  5070638 1381  5070614 1381  5070590 1381  
337475 5070561 1381  5070538 1381  5070523 1381  5070499 1381  5070485 1381  5070471 1381  
337476 5070461 1381  5070455 1383  5070437 1381  5070437 1381  5070431 1383  5070437 1381  
337477 5070437 1381  5070447 1381  5070456 1381  5070461 1381  5070480 1381  5070488 1383  
337478 5070503 1383  5070527 1383  5070557 1381  5070581 1381  5070600 1381  5070628 1381  
337479 5070662 1381  5070691 1381  5070722 1383  5070751 1383  5070785 1383  5070814 1381  
337480 5070848 1381  5070877 1381  5070904 1383  5070939 1381  5070963 1381  5070991 1381  
337481 5071015 1381  5071038 1383  5071063 1381  5071082 1381  5071096 1381  5071115 1381  
337482 5071130 1381  5071149 1381  5071154 1381  5071173 1381  5071173 1381  5071178 1381  
337483 5071178 1381  5071178 1381  5071178 1381  5071173 1381  5071163 1381  5071155 1379  
337484 5071150 1379  5071131 1379  5071117 1379  5071101 1375  5071087 1375  5071068 1375  
337485 5071040 1379  5071029 1375  5071001 1375  5070988 1373  5070967 1375  5070953 1375  
337486 5070929 1375  5070907 1373  5070881 1375  5070867 1375  5070844 1373  5070830 1373  
337487 5070805 1375  5070791 1375  5070773 1379  5070767 1375  5070752 1375  5070740 1379  
337488 5070733 1375  5070725 1379  5070716 1379  5070724 1381  5070725 1379  5070726 1379  
337489 5070730 1379  5070738 1381  5070748 1381  5070764 1379  5070781 1381  5070791 1381  
337490 5070805 1381  5070824 1381  5070848 1381  5070872 1381  5070891 1381  5070915 1381  
337491 5070939 1381  5070963 1381  5070991 1381  5071014 1383  5071038 1383  5071072 1381  
337492 5071092 1381  5071125 1381  5071147 1383  5071171 1383  5071191 1383  5071216 1381  
337493 5071238 1383  5071262 1383  5071281 1383  5071294 1385  5071314 1383  5071327 1385  
337494 5071338 1383  5071345 1381  5071353 1383  5071362 1383  5071361 1385  5071362 1383  
337495 5071362 1383  5071351 1385  5071343 1383  5071338 1383  5071329 1383  5071313 1385  
337496 5071291 1383  5071275 1385  5071252 1383  5071227 1385  5071194 1385  5071176 1383  
337497 5071138 1383  5071112 1385  5071074 1385  5071047 1383  5071004 1383  5070975 1383  
337498 5070937 1383  5070890 1383  5070861 1383  5070823 1383  5070785 1383  5070751 1383  
337499 5070713 1383  5070684 1383  5070646 1383  5070613 1383  5070584 1383  5070555 1383  
337500 5070527 1383  5070503 1383  5070484 1383  5070469 1383  5070447 1381  5070432 1381  
337501 5070422 1383  5070414 1381  5070404 1381  5070404 1381  5070404 1381  5070404 1381  
337502 5070404 1381  5070423 1381  5070437 1381  5070447 1381  5070460 1383  5070484 1383  
337503 5070504 1381  5070523 1381  5070557 1381  5070581 1381  5070604 1381  5070638 1381  
337504 5070671 1381  5070699 1383  5070729 1381  5070772 1381  5070803 1383  5070838 1381  
337505 5070875 1383  5070904 1383  5070947 1383  5070975 1383  5071004 1383  5071038 1383  
337506 5071063 1381  5071080 1383  5071104 1383  5071128 1383  5071146 1385  5071170 1385  
337507 5071174 1385  5071191 1383  5071203 1385  5071213 1385  5071214 1383  5071214 1383  
337508 5071216 1381  5071214 1383  5071205 1383  5071205 1383  5071191 1383  5071182 1381  
337509 5071171 1383  5071154 1381  5071139 1381  5071114 1383  5071096 1381  5071076 1383  
337510 5071054 1381  5071039 1381  5071014 1383  5070982 1381  5070963 1381  5070937 1383  
337511 5070915 1381  5070890 1383  5070870 1383  5070846 1383  5070829 1381  5070805 1381  
337512 5070785 1383  5070770 1383  5070751 1383  5070746 1383  5070726 1385  5070722 1383  
337513 5070711 1385  5070703 1383  5070702 1385  5070703 1383  5070703 1383  5070711 1385  
337514 5070713 1383  5070722 1383  5070737 1383  5070746 1383  5070759 1385  5070779 1383  
337515 5070799 1383  5070813 1383  5070837 1383  5070870 1383  5070890 1383  5070913 1383  
337516 5070947 1383  5070976 1383  5070995 1383  5071028 1383  5071062 1383  5071089 1385  
337517 5071114 1383  5071146 1385  5071174 1385  5071194 1385  5071227 1385  5071252 1383  
337518 5071280 1385  5071294 1385  5071319 1383  5071338 1383  5071353 1383  5071372 1383  
337519 5071383 1381  5071393 1381  5071396 1383  5071405 1383  5071407 1381  5071407 1381  
337520 5071398 1381  5071396 1383  5071383 1381  5071372 1383  5071364 1381  5071345 1381  
337521 5071321 1381  5071296 1383  5071278 1381  5071254 1381  5071221 1381  5071182 1381  
337522 5071154 1381  5071125 1381  5071081 1383  5071047 1383  5071006 1381  5070972 1381  
337523 5070928 1383  5070890 1383  5070846 1383  5070804 1383  5070770 1383  5070727 1383  
337524 5070689 1383  5070660 1383  5070627 1383  5070589 1383  5070560 1383  5070536 1383  
337525 5070503 1383  5070484 1383  5070461 1381  5070444 1385  5070431 1383  5070412 1383  
337526 5070398 1383  5070393 1383  5070393 1383  5070393 1383  5070393 1383  5070398 1383  
337527 5070402 1383  5070412 1383  5070429 1385  5070457 1381  5070469 1383  5070488 1383  
337528 5070512 1383  5070546 1383  5070569 1383  5070598 1383  5070627 1383  5070659 1385  
337529 5070698 1383  5070727 1383  5070770 1383  5070799 1383  5070837 1383  5070875 1383  
337530 5070905 1381  5070947 1383  5070977 1381  5071014 1383  5071047 1383  5071077 1381  
337531 5071097 1381  5071128 1383  5071154 1381  5071171 1383  5071191 1383  5071205 1383  
337532 5071214 1383  5071219 1383  5071229 1383  5071238 1383  5071238 1383  5071237 1385  
337533 5071238 1383  5071229 1383  5071219 1383  5071214 1383  5071205 1383  5071191 1383  
337534 5071178 1381  5071163 1381  5071139 1381  5071115 1381  5071090 1383  5071071 1383  
337535 5071048 1381  5071023 1383  5070996 1381  5070971 1383  5070947 1383  5070923 1383  
337536 5070901 1381  5070877 1381  5070850 1385  5070828 1383  5070804 1383  5070789 1383  
337537 5070769 1385  5070751 1383  5070737 1383  5070727 1383  5070713 1383  5070713 1383  
337538 5070697 1385  5070697 1385  5070689 1383  5070697 1385  5070698 1383  5070699 1383  
337539 5070703 1383  5070713 1383  5070727 1383  5070737 1383  5070753 1381  5070779 1383  
337540 5070800 1381  5070824 1381  5070848 1381  5070872 1381  5070891 1381  5070925 1381  
337541 5070953 1381  5070982 1381  5071015 1381  5071048 1381  5071077 1381  5071106 1381  
337542 5071149 1381  5071171 1383  5071205 1383  5071230 1381  5071262 1383  5071291 1383  
337543 5071314 1383  5071339 1383  5071353 1383  5071375 1385  5071391 1383  5071404 1385  
337544 5071413 1385  5071418 1385  5071428 1385  5071428 1385  5071428 1385  5071428 1385  
337545 5071418 1385  5071413 1385  5071396 1383  5071380 1385  5071372 1383  5071353 1383  
337546 5071329 1383  5071305 1383  5071275 1385  5071248 1383  5071214 1383  5071178 1381  
337547 5071147 1383  5071104 1383  5071071 1383  5071030 1381  5070991 1381  5070948 1381  
337548 5070904 1383  5070870 1383  5070829 1381  5070789 1383  5070751 1383  5070713 1383  
337549 5070679 1383  5070648 1381  5070613 1383  5070584 1383  5070555 1383  5070527 1383  
337550 5070496 1385  5070477 1385  5070460 1383  5070444 1385  5070429 1385  5070421 1383  
337551 5070402 1383  5070401 1385  5070401 1385  5070401 1385  5070402 1383  5070412 1383  
337552 5070431 1383  5070444 1385  5070460 1383  5070484 1383  5070503 1383  5070527 1383  
337553 5070554 1385  5070582 1385  5070611 1385  5070646 1383  5070678 1385  5070703 1383  
337554 5070746 1383  5070785 1383  5070811 1385  5070850 1385  5070888 1385  5070926 1385  
337555 5070961 1383  5070993 1385  5071027 1385  5071060 1385  5071089 1385  5071112 1385  
337556 5071147 1383  5071171 1383  5071189 1385  5071203 1385  5071219 1383  5071238 1383  
337557 5071248 1383  5071262 1383  5071261 1385  5071262 1383  5071270 1385  5071262 1383  
337558 5071252 1383  5071251 1385  5071238 1383  5071227 1385  5071213 1385  5071195 1383  
337559 5071181 1383  5071162 1383  5071138 1383  5071114 1383  5071090 1383  5071061 1383  
337560 5071038 1383  5071012 1385  5070982 1381  5070961 1383  5070926 1385  5070904 1383  
337561 5070885 1383  5070861 1383  5070837 1383  5070813 1383  5070789 1383  5070770 1383  
337562 5070750 1385  5070735 1385  5070722 1383  5070713 1383  5070698 1383  5070687 1385  
337563 5070687 1385  5070686 1387  5070683 1385  5070683 1385  5070687 1385  5070697 1385  
337564 5070697 1385  5070711 1385  5070727 1383  5070745 1385  5070761 1383  5070783 1385  
337565 5070802 1385  5070828 1383  5070861 1383  5070890 1383  5070912 1385  5070945 1385  
337566 5070974 1385  5071004 1383  5071036 1385  5071074 1385  5071101 1387  5071138 1383  
337567 5071170 1385  5071194 1385  5071227 1385  5071259 1387  5071289 1385  5071313 1385  
337568 5071335 1387  5071361 1385  5071375 1385  5071394 1385  5071413 1385  5071418 1385  
337569 5071428 1385  5071437 1385  5071442 1385  5071439 1383  5071442 1385  5071429 1383  
337570 5071429 1383  5071413 1385  5071396 1383  5071381 1383  5071362 1383  5071341 1385  
337571 5071313 1385  5071291 1383  5071262 1383  5071229 1383  5071195 1383  5071160 1385  
337572 5071124 1383  5071080 1383  5071047 1383  5071004 1383  5070974 1385  5070928 1383  
337573 5070897 1385  5070851 1383  5070821 1385  5070785 1383  5070748 1381  5070703 1383  
337574 5070679 1383  5070646 1383  5070613 1383  5070589 1383  5070560 1383  5070536 1383  
337575 5070512 1383  5070503 1383  5070488 1383  5070477 1385  5070469 1383  5070460 1383  
337576 5070460 1383  5070453 1385  5070460 1383  5070469 1383  5070477 1385  5070484 1383  
337577 5070498 1383  5070522 1383  5070536 1383  5070560 1383  5070584 1383  5070603 1383  
337578 5070636 1383  5070670 1383  5070689 1383  5070727 1383  5070761 1383  5070797 1385  
337579 5070827 1383  5070870 1383  5070899 1383  5070937 1383  5070969 1385  5071004 1383  
337580 5071036 1385  5071070 1385  5071093 1385  5071127 1385  5071151 1385  5071175 1385  
337581 5071194 1385  5071217 1385  5071237 1385  5071251 1385  5071262 1383  5071276 1383  
337582 5071280 1385  5071279 1385  5071289 1385  5071280 1385  5071279 1385  5071276 1383  
337583 5071272 1383  5071251 1385  5071248 1383  5071227 1385  5071203 1385  5071179 1385  
337584 5071170 1385  5071147 1383  5071124 1383  5071095 1383  5071071 1383  5071047 1383  
337585 5071013 1383  5070990 1383  5070961 1383  5070936 1385  5070904 1383  5070885 1383  
337586 5070851 1383  5070828 1383  5070804 1383  5070785 1383  5070770 1383  5070746 1383  
337587 5070727 1383  5070711 1385  5070697 1385  5070689 1383  5070683 1385  5070678 1385  
337588 5070668 1385  5070668 1385  5070668 1385  5070668 1385  5070678 1385  5070683 1385  
337589 5070697 1385  5070711 1385  5070726 1385  5070745 1385  5070769 1385  5070788 1385  
337590 5070811 1385  5070835 1385  5070869 1385  5070888 1385  5070923 1383  5070950 1385  
337591 5070979 1385  5071012 1385  5071045 1385  5071074 1385  5071103 1385  5071136 1385  
337592 5071170 1385  5071189 1385  5071217 1385  5071246 1385  5071273 1387  5071288 1387  
337593 5071313 1385  5071328 1385  5071342 1385  5071359 1387  5071375 1385  5071380 1385  
337594 5071388 1387  5071390 1385  5071394 1385  5071394 1385  5071390 1385  5071380 1385  
337595 5071375 1385  5071361 1385  5071337 1385  5071318 1385  5071305 1383  5071280 1385  
337596 5071251 1385  5071227 1385  5071194 1385  5071171 1383  5071136 1385  5071095 1383  
337597 5071071 1383  5071038 1383  5070995 1383  5070969 1385  5070929 1381  5070899 1383  
337598 5070861 1383  5070827 1383  5070799 1383  5070770 1383  5070727 1383  5070697 1385  
337599 5070668 1385  5070646 1383  5070622 1383  5070598 1383  5070584 1383  5070569 1383  
337600 5070555 1383  5070536 1383  5070525 1385  5070522 1383  5070520 1385  5070522 1383  
337601 5070520 1385  5070520 1385  5070525 1385  5070534 1385  5070544 1385  5070558 1385  
337602 5070577 1385  5070595 1387  5070611 1385  5070635 1385  5070659 1385  5070688 1385  
337603 5070711 1385  5070743 1387  5070778 1385  5070802 1385  5070834 1387  5070869 1385  
337604 5070901 1387  5070934 1387  5070968 1387  5070993 1385  5071025 1387  5071058 1387  
337605 5071087 1387  5071122 1385  5071144 1387  5071173 1387  5071194 1385  5071211 1387  
337606 5071235 1387  5071246 1385  5071259 1387  5071275 1385  5071275 1385  5071278 1387  
337607 5071289 1385  5071288 1387  5071279 1385  5071279 1385  5071275 1385  5071270 1385  
337608 5071252 1383  5071237 1385  5071217 1385  5071205 1383  5071179 1385  5071170 1385  
337609 5071136 1385  5071124 1383  5071089 1385  5071069 1385  5071046 1385  5071022 1385  
337610 5070988 1385  5070969 1385  5070936 1385  5070902 1385  5070883 1385  5070848 1386  
337611 5070826 1385  5070802 1385  5070781 1387  5070769 1385  5070750 1385  5070724 1387  
337612 5070710 1387  5070700 1387  5070686 1387  5070681 1387  5070681 1387  5070676 1386  
337613 5070675 1388  5070676 1387  5070681 1387  5070681 1387  5070686 1387  5070695 1387  
337614 5070710 1387  5070724 1387  5070748 1387  5070765 1388  5070786 1387  5070808 1388  
337615 5070832 1388  5070856 1388  5070880 1388  5070901 1387  5070934 1387  5070968 1387  
337616 5070987 1387  5071020 1387  5071049 1387  5071073 1387  5071101 1387  5071135 1387  
337617 5071168 1387  5071188 1387  5071210 1388  5071235 1387  5071258 1388  5071273 1387  
337618 5071286 1388  5071302 1387  5071315 1388  5071315 1388  5071334 1388  5071334 1388  
337619 5071334 1388  5071334 1388  5071324 1388  5071325 1388  5071316 1387  5071311 1387  
337620 5071292 1387  5071288 1387  5071273 1387  5071248 1388  5071235 1387  5071211 1387  
337621 5071188 1387  5071168 1387  5071135 1387  5071111 1387  5071077 1387  5071049 1387  
337622 5071020 1387  5070987 1387  5070958 1387  5070925 1387  5070896 1387  5070867 1387  
337623 5070843 1387  5070810 1387  5070781 1387  5070758 1387  5070733 1387  5070710 1387  
337624 5070688 1385  5070667 1387  5070653 1387  5070624 1387  5070609 1387  5070598 1388  
337625 5070586 1387  5070579 1388  5070581 1387  5070579 1388  5070581 1387  5070581 1387  
337626 5070584 1388  5070584 1388  5070600 1387  5070609 1387  5070622 1388  5070643 1387  
337627 5070657 1387  5070681 1387  5070695 1387  5070718 1388  5070746 1388  5070777 1387  
337628 5070802 1385  5070825 1387  5070858 1387  5070887 1387  5070912 1385  5070945 1385  
337629 5070968 1387  5070993 1385  5071027 1385  5071049 1387  5071079 1385  5071103 1385  
337630 5071125 1387  5071151 1385  5071170 1385  5071189 1385  5071203 1385  5071217 1385  
337631 5071227 1385  5071237 1385  5071249 1387  5071251 1385  5071261 1385  5071261 1385  
337632 5071259 1387  5071249 1387  5071245 1387  5071235 1387  5071227 1385  5071217 1385  
337633 5071202 1387  5071179 1385  5071170 1385  5071151 1385  5071128 1383  5071103 1385  
337634 5071079 1385  5071059 1387  5071036 1385  5071014 1383  5070979 1385  5070961 1383  
337635 5070928 1383  5070902 1385  5070874 1385  5070851 1383  5070821 1385  5070799 1383  
337636 5070783 1385  5070759 1385  5070745 1385  5070719 1387  5070711 1385  5070697 1385  
337637 5070683 1385  5070678 1385  5070668 1385  5070657 1387  5070659 1385  5070657 1387  
337638 5070659 1385  5070667 1387  5070668 1385  5070678 1385  5070681 1387  5070697 1385  
337639 5070711 1385  5070724 1387  5070743 1387  5070768 1385  5070780 1388  5070800 1387  
337640 5070824 1387  5070843 1387  5070867 1387  5070887 1387  5070920 1387  5070944 1387  
337641 5070968 1387  5070987 1387  5071012 1385  5071045 1385  5071068 1387  5071089 1385  
337642 5071112 1385  5071125 1387  5071149 1387  5071168 1387  5071179 1385  5071194 1385  
337643 5071203 1385  5071216 1387  5071226 1387  5071235 1387  5071235 1387  5071245 1387  
337644 5071246 1385  5071245 1387  5071235 1387  5071235 1387  5071226 1387  5071211 1387  
337645 5071202 1387  5071187 1387  5071173 1387  5071159 1387  5071135 1387  5071121 1387  
337646 5071092 1387  5071073 1387  5071058 1387  5071024 1388  5071001 1387  5070977 1387  
337647 5070948 1387  5070925 1387  5070899 1388  5070881 1387  5070856 1388  5070834 1387  
337648 5070799 1388  5070786 1387  5070767 1387  5070743 1387  5070723 1388  5070710 1387  
337649 5070694 1388  5070679 1388  5070675 1388  5070656 1388  5070651 1388  5070643 1387  
337650 5070641 1388  5070632 1388  5070632 1388  5070632 1388  5070641 1388  5070651 1388  
337651 5070657 1387  5070665 1388  5070675 1388  5070683 1390  5070699 1388  5070718 1388  
337652 5070742 1388  5070756 1388  5070780 1388  5070801 1387  5070823 1388  5070847 1388  
337653 5070866 1388  5070887 1387  5070919 1388  5070942 1388  5070966 1388  5070985 1388  
337654 5071019 1388  5071042 1388  5071068 1387  5071087 1387  5071111 1387  5071133 1388  
337655 5071149 1387  5071167 1388  5071176 1388  5071191 1388  5071200 1388  5071210 1388  
337656 5071214 1388  5071216 1387  5071226 1387  5071224 1388  5071224 1388  5071224 1388  
337657 5071216 1387  5071216 1387  5071211 1387  5071202 1387  5071188 1387  5071172 1388  
337658 5071157 1388  5071133 1388  5071121 1387  5071101 1387  5071077 1387  5071057 1388  
337659 5071033 1388  5071010 1387  5070987 1387  5070968 1387  5070942 1388  5070919 1388  
337660 5070895 1388  5070871 1388  5070847 1388  5070823 1388  5070801 1387  5070780 1388  
337661 5070766 1388  5070745 1390  5070731 1390  5070718 1388  5070708 1388  5070694 1388  
337662 5070685 1388  5070679 1388  5070679 1388  5070678 1390  5070681 1387  5070679 1388  
337663 5070679 1388  5070679 1388  5070684 1388  5070696 1387  5070710 1387  5070718 1388  
337664 5070734 1387  5070742 1388  5070758 1387  5070777 1387  5070786 1387  5070810 1387  
337665 5070825 1387  5070848 1387  5070872 1387  5070894 1388  5070918 1388  5070933 1388  
337666 5070958 1387  5070977 1387  5070992 1387  5071020 1387  5071034 1387  5071059 1387  
337667 5071073 1387  5071089 1385  5071101 1387  5071121 1387  5071135 1387  5071144 1387  
337668 5071149 1387  5071170 1385  5071168 1387  5071173 1387  5071175 1385  5071178 1387  
337669 5071178 1387  5071173 1387  5071173 1387  5071168 1387  5071157 1388  5071149 1387  
337670 5071144 1387  5071124 1388  5071121 1387  5071100 1388  5071087 1387  5071068 1387  
337671 5071049 1387  5071033 1388  5071020 1387  5070990 1388  5070976 1388  5070958 1387  
337672 5070944 1387  5070920 1387  5070899 1388  5070887 1387  5070867 1387  5070848 1387  
337673 5070834 1387  5070810 1387  5070797 1385  5070782 1387  5070767 1387  5070750 1385  
337674 5070743 1387  5070734 1387  5070726 1385  5070724 1387  5070719 1387  5070710 1387  
337675 5070711 1385  5070721 1385  5070719 1387  5070721 1385  5070724 1387  5070734 1387  
337676 5070742 1388  5070758 1387  5070767 1387  5070780 1388  5070794 1388  5070800 1387  
337677 5070824 1387  5070843 1387  5070856 1388  5070882 1387  5070901 1387  5070925 1387  
337678 5070948 1387  5070972 1387  5070987 1387  5071010 1387  5071034 1387  5071059 1387  
337679 5071077 1387  5071093 1385  5071111 1387  5071135 1387  5071149 1387  5071168 1387  
337680 5071179 1385  5071189 1385  5071202 1387  5071211 1387  5071216 1387  5071226 1387  
337681 5071235 1387  5071235 1387  5071237 1385  5071237 1385  5071227 1385  5071217 1385  
337682 5071217 1385  5071213 1385  5071203 1385  5071189 1385  5071175 1385  5071160 1385  
337683 5071146 1385  5071127 1385  5071101 1387  5071079 1385  5071060 1385  5071045 1385  
337684 5071022 1385  5070993 1385  5070974 1385  5070950 1385  5070925 1387  5070902 1385  
337685 5070887 1387  5070869 1385  5070848 1387  5070824 1387  5070811 1385  5070796 1387  
337686 5070781 1387  5070767 1387  5070758 1387  5070743 1387  5070734 1387  5070724 1387  
337687 5070719 1387  5070719 1387  5070718 1388  5070719 1387  5070708 1388  5070718 1388  
337688 5070719 1387  5070724 1387  5070734 1387  5070743 1387  5070748 1387  5070758 1387  
337689 5070777 1387  5070780 1388  5070794 1388  5070800 1387  5070820 1387  5070834 1387  
337690 5070848 1387  5070867 1387  5070887 1387  5070901 1387  5070920 1387  5070934 1387  
337691 5070948 1387  5070968 1387  5070987 1387  5071001 1387  5071020 1387  5071035 1387  
337692 5071047 1388  5071068 1387  5071077 1387  5071086 1388  5071101 1387  5071111 1387  
337693 5071121 1387  5071125 1387  5071136 1385  5071136 1385  5071146 1385  5071146 1385  
337694 5071146 1385  5071144 1387  5071135 1387  5071135 1387  5071125 1387  5071125 1387  
337695 5071121 1387  5071111 1387  5071101 1387  5071092 1387  5071077 1387  5071068 1387  
337696 5071059 1387  5071044 1387  5071025 1387  5071011 1387  5070992 1387  5070976 1388  
337697 5070966 1388  5070944 1387  5070925 1387  5070910 1387  5070896 1387  5070887 1387  
337698 5070871 1388  5070867 1387  5070848 1387  5070842 1388  5070834 1387  5070823 1388  
337699 5070820 1387  5070808 1388  5070799 1388  5070799 1388  5070799 1388  5070799 1388  
337700 5070799 1388  5070797 1390  5070799 1388  5070808 1388  5070818 1388  5070823 1388  
337701 5070842 1388  5070847 1388  5070864 1390  5070870 1388  5070885 1388  5070899 1388  
337702 5070918 1388  5070933 1388  5070947 1388  5070966 1388  5070976 1388  5071001 1387  
337703 5071019 1388  5071044 1387  5071058 1387  5071073 1387  5071092 1387  5071111 1387  
337704 5071124 1388  5071143 1388  5071157 1388  5071172 1388  5071176 1388  5071191 1388  
337705 5071200 1388  5071216 1387  5071216 1387  5071235 1387  5071235 1387  5071245 1387  
337706 5071243 1388  5071243 1388  5071234 1388  5071235 1387  5071224 1388  5071216 1387  
337707 5071211 1387  5071202 1387  5071187 1387  5071178 1387  5071170 1385  5071149 1387  
337708 5071135 1387  5071111 1387  5071092 1387  5071073 1387  5071059 1387  5071035 1387  
337709 5071011 1387  5070992 1387  5070972 1387  5070958 1387  5070934 1387  5070910 1387  
337710 5070896 1387  5070881 1387  5070858 1387  5070842 1389  5070823 1388  5070808 1388  
337711 5070796 1387  5070782 1387  5070777 1387  5070767 1387  5070746 1388  5070746 1388  
337712 5070742 1388  5070732 1388  5070732 1388  5070723 1388  5070732 1388  5070732 1388  
337713 5070732 1388  5070740 1390  5070745 1390  5070756 1388  5070756 1388  5070764 1390  
337714 5070775 1388  5070780 1388  5070794 1388  5070799 1389  5070817 1390  5070823 1388  
337715 5070842 1388  5070856 1388  5070870 1388  5070879 1390  5070895 1388  5070907 1390  
337716 5070923 1388  5070942 1388  5070957 1388  5070972 1387  5070987 1387  5070992 1387  
337717 5071009 1388  5071020 1387  5071033 1388  5071044 1387  5071049 1387  5071058 1387  
337718 5071066 1388  5071073 1387  5071077 1387  5071087 1387  5071087 1387  5071092 1387  
337719 5071092 1387  5071092 1387  5071087 1387  5071087 1387  5071087 1387  5071077 1387  
337720 5071071 1388  5071068 1387  5071057 1388  5071049 1387  5071044 1387  5071033 1388  
337721 5071019 1388  5071009 1388  5070990 1388  5070987 1387  5070971 1388  5070957 1388  
337722 5070944 1387  5070933 1388  5070918 1388  5070910 1387  5070895 1388  5070885 1388  
337723 5070880 1388  5070866 1388  5070855 1390  5070847 1388  5070840 1390  5070831 1390  
337724 5070821 1390  5070823 1388  5070821 1390  5070823 1388  5070823 1388  5070823 1388  
337725 5070821 1390  5070831 1390  5070831 1390  5070840 1390  5070845 1390  5070856 1388  
337726 5070866 1388  5070871 1388  5070879 1390  5070885 1388  5070898 1390  5070917 1390  
337727 5070923 1388  5070942 1388  5070957 1388  5070971 1388  5070985 1388  5071000 1388  
337728 5071009 1388  5071033 1388  5071046 1390  5071057 1388  5071073 1387  5071086 1388  
337729 5071100 1388  5071117 1390  5071133 1388  5071143 1388  5071147 1388  5071167 1388  
337730 5071173 1387  5071176 1388  5071176 1388  5071186 1388  5071186 1388  5071186 1388  
337731 5071187 1387  5071186 1388  5071178 1387  5071178 1387  5071171 1388  5071168 1387  
337732 5071159 1387  5071144 1387  5071135 1387  5071119 1388  5071101 1387  5071087 1387  
337733 5071076 1388  5071066 1388  5071044 1387  5071025 1387  5071009 1388  5070987 1387  
337734 5070971 1388  5070957 1388  5070933 1388  5070920 1387  5070899 1388  5070880 1388  
337735 5070866 1388  5070847 1388  5070832 1388  5070808 1388  5070794 1388  5070780 1388  
337736 5070775 1388  5070756 1388  5070745 1390  5070731 1390  5070723 1388  5070716 1390  
337737 5070707 1390  5070697 1390  5070699 1388  5070699 1388  5070697 1390  5070694 1388  
337738 5070694 1388  5070697 1390  5070697 1390  5070708 1388  5070708 1388  5070717 1390  
337739 5070721 1390  5070730 1390  5070740 1390  5070745 1390  5070755 1390  5070764 1390  
337740 5070780 1388  5070793 1390  5070808 1388  5070817 1390  5070831 1390  5070845 1390  
337741 5070864 1390  5070871 1388  5070885 1388  5070898 1390  5070915 1392  5070922 1390  
337742 5070931 1390  5070945 1390  5070955 1390  5070969 1390  5070974 1390  5070985 1388  
337743 5070999 1388  5071009 1388  5071019 1388  5071023 1388  5071022 1390  5071033 1388  
337744 5071033 1388  5071035 1387  5071043 1388  5071033 1388  5071033 1388  5071033 1388  
337745 5071025 1387  5071020 1387  5071019 1388  5071009 1388  5071000 1388  5070990 1388  
337746 5070987 1387  5070971 1388  5070966 1388  5070957 1388  5070942 1388  5070933 1388  
337747 5070919 1388  5070909 1388  5070895 1388  5070885 1388  5070880 1388  5070866 1389  
337748 5070856 1388  5070845 1390  5070840 1390  5070823 1388  5070818 1388  5070818 1388  
337749 5070808 1388  5070799 1388  5070799 1388  5070799 1388  5070799 1388  5070799 1388  
337750 5070799 1388  5070799 1388  5070797 1390  5070807 1390  5070817 1390  5070823 1388  
337751 5070832 1388  5070842 1388  5070845 1390  5070864 1390  5070869 1390  5070885 1388  
337752 5070893 1390  5070909 1388  5070919 1388  5070942 1388  5070947 1388  5070965 1390  
337753 5070974 1390  5070998 1390  5071007 1390  5071022 1390  5071041 1390  5071055 1390  
337754 5071065 1390  5071074 1390  5071086 1388  5071098 1390  5071109 1388  5071119 1388  
337755 5071122 1390  5071124 1388  5071133 1388  5071143 1388  5071133 1388  5071143 1388  
337756 5071143 1388  5071143 1388  5071133 1388  5071133 1388  5071124 1388  5071121 1387  
337757 5071108 1390  5071090 1388  5071086 1388  5071071 1388  5071057 1388  5071047 1388  
337758 5071032 1390  5071019 1388  5070990 1388  5070974 1390  5070955 1390  5070941 1390  
337759 5070923 1388  5070898 1390  5070885 1388  5070871 1388  5070847 1388  5070832 1388  
337760 5070808 1388  5070794 1388  5070780 1388  5070766 1388  5070741 1388  5070723 1388  
337761 5070718 1388  5070700 1387  5070686 1387  5070679 1388  5070676 1387  5070665 1388  
337762 5070656 1388  5070651 1388  5070641 1388  5070641 1388  5070641 1388  5070632 1388  
337763 5070630 1390  5070632 1388  5070641 1388  5070641 1388  5070641 1388  5070651 1388  
337764 5070651 1388  5070656 1389  5070665 1388  5070679 1388  5070694 1388  5070700 1387  
337765 5070718 1388  5070723 1388  5070743 1387  5070756 1388  5070775 1388  5070785 1388  
337766 5070799 1388  5070818 1388  5070825 1387  5070842 1388  5070856 1388  5070880 1388  
337767 5070895 1388  5070909 1388  5070919 1388  5070934 1387  5070942 1388  5070957 1388  
337768 5070966 1388  5070971 1388  5070977 1387  5070985 1388  5070992 1387  5071001 1387  
337769 5071000 1388  5071000 1388  5071001 1387  5071000 1388  5071001 1387  5071001 1387  
337770 5070992 1387  5070992 1387  5070987 1387  5070977 1387  5070971 1388  5070968 1387  
337771 5070958 1387  5070948 1387  5070934 1387  5070925 1387  5070919 1388  5070901 1387  
337772 5070885 1388  5070880 1388  5070867 1387  5070856 1388  5070847 1388  5070842 1388  
337773 5070831 1390  5070818 1388  5070808 1388  5070799 1388  5070793 1390  5070785 1388  
337774 5070785 1388  5070780 1388  5070780 1388  5070780 1388  5070775 1388  5070775 1388  
337775 5070780 1388  5070780 1388  5070786 1387  5070785 1388  5070794 1388  5070799 1388  
337776 5070808 1388  5070818 1388  5070831 1390  5070845 1390  5070866 1388  5070880 1388  
337777 5070884 1390  5070899 1388  5070919 1388  5070933 1388  5070947 1388  5070965 1390  
337778 5070976 1388  5070989 1390  5071007 1390  5071024 1388  5071042 1388  5071046 1390  
337779 5071071 1388  5071074 1390  5071086 1388  5071089 1390  5071098 1390  5071109 1388  
337780 5071119 1388  5071124 1388  5071132 1390  5071132 1390  5071133 1388  5071132 1390  
337781 5071132 1390  5071132 1390  5071124 1388  5071124 1388  5071119 1388  5071109 1388  
337782 5071090 1388  5071086 1388  5071076 1388  5071066 1388  5071047 1388  5071033 1388  
337783 5071019 1388  5071000 1388  5070985 1388  5070972 1387  5070947 1388  5070933 1388  
337784 5070909 1388  5070895 1388  5070871 1388  5070848 1387  5070832 1388  5070810 1387  
337785 5070794 1388  5070777 1387  5070758 1387  5070742 1388  5070723 1388  5070710 1387  
337786 5070694 1388  5070679 1388  5070665 1388  5070656 1388  5070651 1388  5070641 1388  
337787 5070622 1388  5070622 1388  5070618 1388  5070608 1388  5070608 1388  5070606 1390  
337788 5070608 1388  5070608 1388  5070608 1388  5070618 1388  5070622 1388  5070622 1388  
337789 5070641 1388  5070643 1387  5070656 1388  5070676 1387  5070681 1387  5070695 1387  
337790 5070710 1387  5070724 1387  5070743 1387  5070756 1388  5070777 1387  5070796 1387  
337791 5070800 1387  5070823 1388  5070843 1387  5070858 1387  5070880 1388  5070895 1388  
337792 5070910 1387  5070925 1387  5070942 1388  5070958 1387  5070971 1388  5070987 1387  
337793 5070990 1388  5071001 1387  5071009 1388  5071019 1388  5071025 1387  5071033 1388  
337794 5071034 1387  5071035 1387  5071035 1387  5071034 1387  5071034 1387  5071025 1387  
337795 5071025 1387  5071019 1388  5071009 1388  5071001 1387  5070985 1388  5070977 1387  
337796 5070972 1387  5070957 1388  5070947 1388  5070933 1388  5070925 1387  5070910 1387  
337797 5070901 1387  5070885 1388  5070880 1388  5070866 1388  5070856 1388  5070842 1388  
337798 5070834 1387  5070825 1387  5070818 1388  5070810 1387  5070801 1387  5070794 1388  
337799 5070796 1387  5070785 1388  5070786 1387  5070786 1387  5070785 1388  5070786 1387  
337800 5070786 1387  5070796 1387  5070799 1388  5070808 1388  5070820 1387  5070823 1388  
337801 5070843 1387  5070847 1388  5070866 1388  5070882 1387  5070885 1388  5070909 1388  
337802 5070920 1387  5070934 1387  5070957 1388  5070971 1388  5070985 1388  5071001 1387  
337803 5071019 1388  5071033 1388  5071047 1389  5071066 1388  5071076 1388  5071090 1388  
337804 5071100 1388  5071119 1388  5071124 1388  5071133 1388  5071147 1388  5071157 1388  
337805 5071167 1388  5071167 1388  5071172 1388  5071172 1388  5071172 1388  5071172 1388  
337806 5071171 1388  5071167 1388  5071167 1388  5071157 1388  5071148 1388  5071143 1388  
337807 5071133 1388  5071119 1388  5071100 1388  5071086 1388  5071071 1388  5071058 1387  
337808 5071035 1387  5071020 1387  5071001 1387  5070977 1387  5070958 1387  5070944 1387  
337809 5070919 1388  5070898 1385  5070872 1387  5070848 1387  5070823 1388  5070800 1387  
337810 5070786 1387  5070767 1387  5070748 1387  5070723 1388  5070708 1388  5070686 1387  
337811 5070676 1387  5070656 1388  5070643 1387  5070633 1387  5070618 1389  5070609 1387  
337812 5070608 1388  5070600 1387  5070594 1388  5070595 1387  5070594 1388  5070594 1388  
337813 5070594 1388  5070598 1388  5070609 1387  5070609 1387  5070618 1388  5070632 1388  
337814 5070641 1388  5070656 1388  5070675 1388  5070679 1388  5070694 1388  5070719 1387  
337815 5070732 1388  5070748 1387  5070777 1387  5070785 1388  5070810 1387  5070832 1388  
337816 5070856 1388  5070871 1388  5070895 1388  5070909 1388  5070923 1388  5070947 1388  
337817 5070968 1387  5070977 1387  5070992 1387  5071009 1388  5071024 1388  5071035 1387  
337818 5071044 1387  5071049 1387  5071059 1387  5071068 1387  5071068 1387  5071073 1387  
337819 5071073 1387  5071073 1387  5071071 1388  5071068 1387  5071066 1388  5071057 1388  
337820 5071047 1388  5071044 1387  5071033 1388  5071020 1387  5071009 1388  5070990 1388  
337821 5070987 1387  5070972 1387  5070958 1387  5070942 1388  5070934 1387  5070920 1387  
337822 5070899 1388  5070885 1388  5070880 1388  5070866 1388  50