CDF       
      
timeseries        obs   _   station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2021-03-08     
date_modified         
2021-03-08     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes WQB-04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2021-07-24T03:07:04Z http://pacioos.org
2021-07-24T03:07:04Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/WQB-04.ncCFMA?&time%3E=2012-01-01T00:00:00Z&time%3C2013-01-01T00:00:00Z     id        WQB-04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/WQB-04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         WQB-04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. WQB-04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2012-12-31T23:45:00Z   time_coverage_resolution      PT15M      time_coverage_start       2012-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.WQB-04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       q   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              q   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         q   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        q   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      Aӿ   A8      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z       r    temperature                    _ChunkSizes                
_FillValue        y    actual_range      AHA㙚   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       p   salinity                   _ChunkSizes                
_FillValue        y    actual_range      @QB   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B          	turbidity                      _ChunkSizes                
_FillValue        y    actual_range          Aff   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       #Nephelometric Turbidity Units (NTU)    coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity NTU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       n   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range          CJ#   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C          oxygen                     _ChunkSizes                
_FillValue        y    actual_range      @\)A4(   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       
l   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      B33C   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C          ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       
j    temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AHA㙚   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       $   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range               h(   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     ,   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     f0   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     4   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     d8   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     <   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     b@   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     D   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     `H   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     L   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     ^P   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      T   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     "\X   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     #\   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     %Z`   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      @QB   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       &d   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range               (Xh   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     )l   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     +Vp   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     ,t   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     .Tx   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     /|   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     1R   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     2ф   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     4P   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     5ό   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     7N   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     8͔   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     :L   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     ;˜   salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     =J   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range          Aff   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       #Nephelometric Turbidity Units (NTU)    coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity NTU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       >ɤ   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity NTU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range               @H   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     AǬ   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     CF   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     DŴ   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     FD   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Gü   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     IB   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     J   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     L@   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     M   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     O>   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     P   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R<   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range          CJ#   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       S   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range               U:   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     V   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     X8   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Y   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     [6   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     \   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     ^4   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     _   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     a3    chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     b   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     d1   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     e   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     g/   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      @\)A4(   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       h   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range               j-   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     k   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     m+    
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     n$   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     p)(   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     q,   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     s'0   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     t4   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     v%8   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     w<   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     y#@   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     zD   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     |!H   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      B33C   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       }L   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range               P   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     T   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     X   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     \   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     `   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     d   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     h   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     l   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     p   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     t   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     x   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     |   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	        ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`          ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                  	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	        	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     
   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	        	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	        	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     	   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	        	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	        	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	        	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	        	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       >    instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     0 D   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    ] tAp?  WQB-04  Aӿ   Aӿa   AӿB   Aӿ#   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿi   AӿJ   Aӿ+   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿq   AӿR   Aӿ3   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿy   AӿZ   A ;   A   A   A   A   A   Ab   AC   A$   A	   A	   A
   A   A   A
j   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A    A!   A"   A#c   A$D   A%%   A&   A&   A'   A(   A)   A*k   A+L   A,-   A-   A-   A.   A/   A0   A1s   A2T   A35   A4   A4   A5   A6   A7   A8{   A9\   A:=   A;   A;   A<   A=   A>   A?   A@d   AAE   AB&   AC   AC   AD   AE   AF   AGl   AHM   AI.   AJ   AJ   AK   AL   AM   ANt   AOU   AP6   AQ   AQ   AR   AS   AT   AU|   AV]   AW>   AX   AY    AY   AZ   A[   A\   A]e   A^F   A_'   A`   A`   Aa   Ab   Ac   Adm   AeN   Af/   Ag   Ag   Ah   Ai   Aj   Aku   AlV   Am7   An   An   Ao   Ap   Aq   Ar}   As^   At?   Au    Av   Av   Aw   Ax   Ay   Azf   A{G   A|(   A}	   A}   A~   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   AǾ   Aȟ   Aɀ   Aa   AB   A#   A   A   A   Aϧ   AЈ   Ai   AJ   A+   A   A   A   A֯   Aא   Aq   AR   A3   A   A   A   Aݷ   Aޘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A    A   A   A   Ac   AD   A%   A   A   A   A	   A
   Ak   AL   A
-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A    A!d   A"E   A#&   A$   A$   A%   A&   A'   A(l   A)M   A*.   A+   A+   A,   A-   A.   A/t   A0U   A16   A2   A2   A3   A4   A5   A6|   A7]   A8>   A9   A:    A:   A;   A<   A=   A>e   A?F   A@'   AA   AA   AB   AC   AD   AEm   AFN   AG/   AH   AH   AI   AJ   AK   ALu   AMV   AN7   AO   AO   AP   AQ   AR   AS}   AT^   AU?   AV    AW   AW   AX   AY   AZ   A[f   A\G   A](   A^	   A^   A_   A`   Aa   Abn   AcO   Ad0   Ae   Ae   Af   Ag   Ah   Aiv   AjW   Ak8   Al   Al   Am   An   Ao   Ap~   Aq_   Ar@   As!   At   At   Au   Av   Aw   Axg   AyH   Az)   A{
   A{   A|   A}   A~   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   Aſ   AƠ   Aǁ   Ab   AC   A$   A   A   A   Aͨ   AΉ   Aj   AK   A,   A
   A   A   A԰   AՑ   Ar   AS   A4   A   A   A   A۸   Aܙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A    A   Ad   AE   A&   A   A   A   A   A   A	l   A
M   A.   A   A   A
   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   A F   A!'   A"   A"   A#   A$   A%   A&m   A'N   A(/   A)   A)   A*   A+   A,   A-u   A.V   A/7   A0   A0   A1   A2   A3   A4}   A5^   A6?   A7    A8   A8   A9   A:   A;   A<f   A=G   A>(   A?	   A?   A@   AA   AB   ACn   ADO   AE0   AF   AF   AG   AH   AI   AJv   AKW   AL8   AM   AM   AN   AO   AP   AQ~   AR_   AS@   AT!   AU   AU   AV   AW   AX   AYg   AZH   A[)   A\
   A\   A]   A^   A_   A`o   AaP   Ab1   Ac   Ac   Ad   Ae   Af   Agw   AhX   Ai9   Aj   Aj   Ak   Al   Am   An   Ao`   ApA   Aq"   Ar   Ar   As   At   Au   Avh   AwI   Ax*   Ay   Ay   Az   A{   A|   A}p   A~Q   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A    A¡y   A¢Z   A£;   A¤   A¤   A¥   A¦   A§   A¨   A©b   AªC   A«$   A¬   A¬   A­   A®   A¯   A°j   A±K   A²,   A³
   A³   A´   Aµ   A¶   A·r   A¸S   A¹4   Aº   Aº   A»   A¼   A½   A¾z   A¿[   A<   A   A   A   A   Aġ   Ał   Ac   AD   A%   A   A   A   A˩   Å   Ak   AL   A-   A   A   A   Aұ   AӒ   As   AT   A5   A   A   A   Aٹ   Aښ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   A e   AF   A'   A   A   A   A   A   Am   AN   A	/   A
   A
   A   A   A
   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A 	   A    A!   A"   A#   A$n   A%O   A&0   A'   A'   A(   A)   A*   A+v   A,W   A-8   A.   A.   A/   A0   A1   A2~   A3_   A4@   A5!   A6   A6   A7   A8   A9   A:g   A;H   A<)   A=
   A=   A>   A?   A@   AAo   ABP   AC1   AD   AD   AE   AF   AG   AHw   AIX   AJ9   AK   AK   AL   AM   AN   AO   AP`   AQA   AR"   AS   AS   AT   AU   AV   AWh   AXI   AY*   AZ   AZ   A[   A\   A]   A^p   A_Q   A`2   Aa   Aa   Ab   Ac   Ad   Aex   AfY   Ag:   Ah   Ah   Ai   Aj   Ak   Al   Ama   AnB   Ao#   Ap   Ap   Aq   Ar   As   Ati   AuJ   Av+   Aw   Aw   Ax   Ay   Az   A{q   A|R   A}3   A~   A~   A   AÀ   AÁ   AÂy   AÃZ   AÄ;   AÅ   AÅ   AÆ   AÇ   AÈ   AÉ   AÊb   AËC   AÌ$   AÍ   AÍ   AÎ   AÏ   AÐ   AÑj   AÒK   AÓ,   AÔ
   AÔ   AÕ   AÖ   A×   AØr   AÙS   AÚ4   AÛ   AÛ   AÜ   AÝ   AÞ   Aßz   Aà[   Aá<   Aâ   Aâ   Aã   Aä   Aå   Aæ   Açc   AèD   Aé%   Aê   Aê   Aë   Aì   Aí   Aîk   AïL   Að-   Añ   Añ   Aò   Aó   Aô   Aõs   AöT   A÷5   Aø   Aù   Aú   Aû   Aü{   Aý\   Aþ=   Aÿ   Aÿ   A   A   A¢   AÃ   Ad   AE   A&   A   A   A   Aɪ   Aʋ   Al   AM   A.   A   A   A   Aв   Aѓ   At   AU   A6   A   A   A   A׺   A؛   A|   A]   A>   A   A    A   A   Aߣ   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A (   A	   A   A   A   A   An   AO   A0   A   A   A	   A
   A   Av   A
W   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A    A!   A"o   A#P   A$1   A%   A%   A&   A'   A(   A)w   A*X   A+9   A,   A,   A-   A.   A/   A0   A1`   A2A   A3"   A4   A4   A5   A6   A7   A8h   A9I   A:*   A;   A;   A<   A=   A>   A?p   A@Q   AA2   AB   AB   AC   AD   AE   AFx   AGY   AH:   AI   AI   AJ   AK   AL   AM   ANa   AOB   AP#   AQ   AQ   AR   AS   AT   AUi   AVJ   AW+   AX   AX   AY   AZ   A[   A\q   A]R   A^3   A_   A_   A`   Aa   Ab   Acy   AdZ   Ae;   Af   Af   Ag   Ah   Ai   Aj   Akb   AlC   Am$   An   An   Ao   Ap   Aq   Arj   AsK   At,   Au
   Au   Av   Aw   Ax   Ayr   AzS   A{4   A|   A|   A}   A~   A   AĀz   Aā[   AĂ<   Aă   Aă   AĄ   Aą   AĆ   Ać   AĈc   AĉD   AĊ%   Aċ   Aċ   AČ   Ač   AĎ   Aďk   AĐL   Ađ-   AĒ   AĒ   Aē   AĔ   Aĕ   AĖs   AėT   AĘ5   Aę   Aę   AĚ   Aě   AĜ   Aĝ{   AĞ\   Ağ=   AĠ   AĠ   Aġ   AĢ   Aģ   AĤ   Aĥd   AĦE   Aħ&   AĨ   AĨ   Aĩ   AĪ   Aī   AĬl   AĭM   AĮ.   Aį   Aį   Aİ   Aı   AĲ   Aĳt   AĴU   Aĵ6   AĶ   AĶ   Aķ   Aĸ   AĹ   Aĺ|   AĻ]   Aļ>   AĽ   Aľ    Aľ   AĿ   A   A   Ae   AF   A'   A   A   A   Aǫ   AȌ   Am   AN   A/   A   A   A   Aγ   Aϔ   Au   AV   A7   A   A   A   Aջ   A֜   A}   A^   A?   A    A   A   A   Aݤ   Aޅ   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A    A   A   Ao   AP   A1   A   A   A   A   A	   A
w   AX   A9   A
   A
   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   A p   A!Q   A"2   A#   A#   A$   A%   A&   A'x   A(Y   A):   A*   A*   A+   A,   A-   A.   A/a   A0B   A1#   A2   A2   A3   A4   A5   A6i   A7J   A8+   A9   A9   A:   A;   A<   A=q   A>R   A?3   A@   A@   AA   AB   AC   ADy   AEZ   AF;   AG   AG   AH   AI   AJ   AK   ALb   AMC   AN$   AO   AO   AP   AQ   AR   ASj   ATK   AU,   AV
   AV   AW   AX   AY   AZr   A[S   A\4   A]   A]   A^   A_   A`   Aaz   Ab[   Ac<   Ad   Ad   Ae   Af   Ag   Ah   Aic   AjD   Ak%   Al   Al   Am   An   Ao   Apk   AqL   Ar-   As   As   At   Au   Av   Aws   AxT   Ay5   Az   Az   A{   A|   A}   A~{   A\   Aŀ=   AŁ   AŁ   Ał   AŃ   Ań   AŅ   Aņd   AŇE   Aň&   Aŉ   Aŉ   AŊ   Aŋ   AŌ   Aōl   AŎM   Aŏ.   AŐ   AŐ   Aő   AŒ   Aœ   AŔt   AŕU   AŖ6   Aŗ   Aŗ   AŘ   Ař   AŚ   Aś|   AŜ]   Aŝ>   AŞ   Aş    Aş   Aš   AŢ   Aţe   AŤF   Ať'   AŦ   AŦ   Aŧ   AŨ   Aũ   AŪm   AūN   AŬ/   Aŭ   Aŭ   AŮ   Aů   AŰ   Aűu   AŲV   Aų7   AŴ   AŴ   Aŵ   AŶ   Aŷ   AŸ}   AŹ^   Aź?   AŻ    Aż   Aż   AŽ   Až   Aſ   Af   AG   A(   A	   A   A   AŬ   Aƍ   An   AO   A0   A   A   A   A̴   A͕   Av   AW   A8   A   A   A   AӼ   Aԝ   A~   A_   A@   A!   A   A   A   Aۥ   A܆   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A    Ap   AQ   A2   A   A   A   A   A   Ax   A	Y   A
:   A   A   A   A
   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A 3   A!   A!   A"   A#   A$   A%y   A&Z   A';   A(   A(   A)   A*   A+   A,   A-b   A.C   A/$   A0   A0   A1   A2   A3   A4j   A5K   A6,   A7
   A7   A8   A9   A:   A;r   A<S   A=4   A>   A>   A?   A@   AA   ABz   AC[   AD<   AE   AE   AF   AG   AH   AI   AJc   AKD   AL%   AM   AM   AN   AO   AP   AQk   ARL   AS-   AT   AT   AU   AV   AW   AXs   AYT   AZ5   A[   A[   A\   A]   A^   A_{   A`\   Aa=   Ab   Ab   Ac   Ad   Ae   Af   Agd   AhE   Ai&   Aj   Aj   Ak   Al   Am   Anl   AoM   Ap.   Aq   Aq   Ar   As   At   Aut   AvU   Aw6   Ax   Ax   Ay   Az   A{   A||   A}]   A~>   A   Aƀ    Aƀ   AƁ   AƂ   Aƃ   AƄe   AƅF   AƆ'   AƇ   AƇ   Aƈ   AƉ   AƊ   AƋm   AƌN   Aƍ/   AƎ   AƎ   AƏ   AƐ   AƑ   Aƒu   AƓV   AƔ7   Aƕ   Aƕ   AƖ   AƗ   AƘ   Aƙ}   Aƚ^   Aƛ?   AƜ    AƝ   AƝ   Aƞ   AƟ   AƠ   Aơf   AƢG   Aƣ(   AƤ	   AƤ   A`   Aak   AbL   Ac-   Ad   Ad   Ae   Af   Ag   Ahs   AiT   Aj5   Ak   Ak   Al   Am   An   Ao{   Ap\   Aq=   Ar   Ar   As   At   Au   Av   Awd   AxE   Ay&   Az   Az   A{   A|   A}   A~l   AM   AԀ.   Aԁ   Aԁ   AԂ   Aԃ   AԄ   Aԅt   AԆU   Aԇ6   AԈ   AԈ   Aԉ   AԊ   Aԋ   AԌ|   Aԍ]   AԎ>   Aԏ   AԐ    AԐ   Aԑ   AԒ   Aԓ   AԔe   AԕF   AԖ'   Aԗ   Aԗ   AԘ   Aԙ   AԚ   Aԛm   AԜN   Aԝ/   AԞ   AԞ   Aԟ   AԠ   Aԡ   AԢu   AԣV   AԤ7   Aԥ   Aԥ   AԦ   Aԧ   AԨ   Aԩ}   AԪ^   Aԫ?   AԬ    Aԭ   Aԭ   AԮ   Aԯ   A԰   AԱf   AԲG   AԳ(   AԴ	   AԴ   AԵ   AԶ   AԷ   AԸn   AԹO   AԺ0   AԻ   AԻ   AԼ   AԽ   AԾ   AԿv   AW   A8   A   A   A   Aļ   Aŝ   A~   A_   A@   A!   A   A   A   Ḁ   A͆   Ag   AH   A)   A
   A   A   Aӭ   AԎ   Ao   AP   A1   A   A   A   Aڵ   Aۖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A    Aa   AB   A#   A   A   A   A   A   Ai   A	J   A
+   A   A   A   A
   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A $   A!   A!   A"   A#   A$   A%j   A&K   A',   A(
   A(   A)   A*   A+   A,r   A-S   A.4   A/   A/   A0   A1   A2   A3z   A4[   A5<   A6   A6   A7   A8   A9   A:   A;c   A<D   A=%   A>   A>   A?   A@   AA   ABk   ACL   AD-   AE   AE   AF   AG   AH   AIs   AJT   AK5   AL   AL   AM   AN   AO   AP{   AQ\   AR=   AS   AS   AT   AU   AV   AW   AXd   AYE   AZ&   A[   A[   A\   A]   A^   A_l   A`M   Aa.   Ab   Ab   Ac   Ad   Ae   Aft   AgU   Ah6   Ai   Ai   Aj   Ak   Al   Am|   An]   Ao>   Ap   Aq    Aq   Ar   As   At   Aue   AvF   Aw'   Ax   Ax   Ay   Az   A{   A|m   A}N   A~/   A   A   AՀ   AՁ   AՂ   AՃu   AՄV   AՅ7   AՆ   AՆ   AՇ   AՈ   AՉ   AՊ}   AՋ^   AՌ?   AՍ    AՎ   AՎ   AՏ   AՐ   AՑ   AՒf   AՓG   AՔ(   AՕ	   AՕ   AՖ   A՗   A՘   Aՙn   A՚O   A՛0   A՜   A՜   A՝   A՞   A՟   Aՠv   AաW   Aբ8   Aգ   Aգ   Aդ   Aե   Aզ   Aէ~   Aը_   Aթ@   Aժ!   Aի   Aի   Aլ   Aխ   Aծ   Aկg   AհH   Aձ)   Aղ
   Aղ   Aճ   Aմ   Aյ   Aնo   AշP   Aո1   Aչ   Aչ   Aպ   Aջ   Aռ   Aսw   AվX   Aտ9   A   A   A   A½   AÞ   A   A`   AA   A"   A   A   A   Aʦ   Aˇ   Ah   AI   A*   A   A   A   AѮ   Aҏ   Ap   AQ   A2   A   A   A   Aض   Aٗ   Ax   AY   A:   A   A   A   A߾   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   A C   A$   A   A   A   A   A   Aj   AK   A,   A	
   A	   A
   A   A   A
r   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A    A!   A"   A#k   A$L   A%-   A&   A&   A'   A(   A)   A*s   A+T   A,5   A-   A-   A.   A/   A0   A1{   A2\   A3=   A4   A4   A5   A6   A7   A8   A9d   A:E   A;&   A<   A<   A=   A>   A?   A@l   AAM   AB.   AC   AC   AD   AE   AF   AGt   AHU   AI6   AJ   AJ   AK   AL   AM   AN|   AO]   AP>   AQ   AR    AR   AS   AT   AU   AVe   AWF   AX'   AY   AY   AZ   A[   A\   A]m   A^N   A_/   A`   A`   Aa   Ab   Ac   Adu   AeV   Af7   Ag   Ag   Ah   Ai   Aj   Ak}   Al^   Am?   An    Ao   Ao   Ap   Aq   Ar   Asf   AtG   Au(   Av	   Av   Aw   Ax   Ay   Azn   A{O   A|0   A}   A}   A~   A   Aր   Aցv   AւW   Aփ8   Aք   Aք   Aօ   Aֆ   Aև   Aֈ~   A։_   A֊@   A֋!   A֌   A֌   A֍   A֎   A֏   A֐g   A֑H   A֒)   A֓
   A֓   A֔   A֕   A֖   A֗o   A֘P   A֙1   A֚   A֚   A֛   A֜   A֝   A֞w   A֟X   A֠9   A֡   A֡   A֢   A֣   A֤   A֥   A֦`   A֧A   A֨"   A֩   A֩   A֪   A֫   A֬   A֭h   A֮I   A֯*   Aְ   Aְ   Aֱ   Aֲ   Aֳ   Aִp   AֵQ   Aֶ2   Aַ   Aַ   Aָ   Aֹ   Aֺ   Aֻx   AּY   Aֽ:   A־   A־   Aֿ   A   A   A   Aa   AB   A#   A   A   A   Aȧ   AɈ   Ai   AJ   A+   A   A   A   Aϯ   AА   Aq   AR   A3   A   A   A   Aַ   Aט   Ay   AZ   A;   A   A   A   Aݿ   Aޠ   A߁   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A    A    A   A   A   Ak   AL   A-   A   A   A   A	   A
   As   AT   A
5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A    A!l   A"M   A#.   A$   A$   A%   A&   A'   A(t   A)U   A*6   A+   A+   A,   A-   A.   A/|   A0]   A1>   A2   A3    A3   A4   A5   A6   A7e   A8F   A9'   A:   A:   A;   A<   A=   A>m   A?N   A@/   AA   AA   AB   AC   AD   AEu   AFV   AG7   AH   AH   AI   AJ   AK   AL}   AM^   AN?   AO    AP   AP   AQ   AR   AS   ATf   AUG   AV(   AW	   AW   AX   AY   AZ   A[n   A\O   A]0   A^   A^   A_   A`   Aa   Abv   AcW   Ad8   Ae   Ae   Af   Ag   Ah   Ai~   Aj_   Ak@   Al!   Am   Am   An   Ao   Ap   Aqg   ArH   As)   At
   At   Au   Av   Aw   Axo   AyP   Az1   A{   A{   A|   A}   A~   Aw   A׀X   Aׁ9   Aׂ   Aׂ   A׃   Aׄ   Aׅ   A׆   Aׇ`   A׈A   A׉"   A׊   A׊   A׋   A׌   A׍   A׎h   A׏I   Aא*   Aב   Aב   Aג   Aד   Aה   Aוp   AזQ   Aח2   Aט   Aט   Aי   Aך   Aכ   Aלx   AםY   Aמ:   Aן   Aן   Aנ   Aס   Aע   Aף   Aפa   AץB   Aצ#   Aק   Aק   Aר   Aש   Aת   A׫i   A׬J   A׭+   A׮   A׮   Aׯ   Aװ   Aױ   Aײq   A׳R   A״3   A׵   A׵   A׶   A׷   A׸   A׹y   A׺Z   A׻;   A׼   A׼   A׽   A׾   A׿   A   Ab   AC   A$   A   A   A   Aƨ   Aǉ   Aj   AK   A,   A
   A   A   AͰ   AΑ   Ar   AS   A4   A   A   A   AԸ   Aՙ   Az   A[   A<   A   A   A   A   Aܡ   A݂   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A    A   Al   AM   A.   A   A   A   A   A   A	t   A
U   A6   A   A   A
   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   A N   A!/   A"   A"   A#   A$   A%   A&u   A'V   A(7   A)   A)   A*   A+   A,   A-}   A.^   A/?   A0    A1   A1   A2   A3   A4   A5f   A6G   A7(   A8	   A8   A9   A:   A;   A<n   A=O   A>0   A?   A?   A@   AA   AB   ACv   ADW   AE8   AF   AF   AG   AH   AI   AJ~   AK_   AL@   AM!   AN   AN   AO   AP   AQ   ARg   ASH   AT)   AU
   AU   AV   AW   AX   AYo   AZP   A[1   A\   A\   A]   A^   A_   A`w   AaX   Ab9   Ac   Ac   Ad   Ae   Af   Ag   Ah`   AiA   Aj"   Ak   Ak   Al   Am   An   Aoh   ApI   Aq*   Ar   Ar   As   At   Au   Avp   AwQ   Ax2   Ay   Ay   Az   A{   A|   A}x   A~Y   A:   A؀   A؀   A؁   A؂   A؃   A؄   A؅a   A؆B   A؇#   A؈   A؈   A؉   A؊   A؋   A،i   A؍J   A؎+   A؏   A؏   Aؐ   Aؑ   Aؒ   Aؓq   AؔR   Aؕ3   Aؖ   Aؖ   Aؗ   Aؘ   Aؙ   Aؚy   A؛Z   A؜;   A؝   A؝   A؞   A؟   Aؠ   Aء   Aآb   AأC   Aؤ$   Aإ   Aإ   Aئ   Aا   Aب   Aةj   AتK   Aث,   Aج
   Aج   Aح   Aخ   Aد   Aذr   AرS   Aز4   Aس   Aس   Aش   Aص   Aض   Aطz   Aظ[   Aع<   Aغ   Aغ   Aػ   Aؼ   Aؽ   Aؾ   Aؿc   AD   A%   A   A   A   Aĩ   AŊ   Ak   AL   A-   A   A   A   A˱   A̒   As   AT   A5   A   A   A   Aҹ   AӚ   A{   A\   A=   A   A   A   A   Aڢ   Aۃ   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   A m   AN   A/   A   A   A   A   A   Au   AV   A	7   A
   A
   A   A   A
   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A    A    A!   A"   A#   A$v   A%W   A&8   A'   A'   A(   A)   A*   A+~   A,_   A-@   A.!   A/   A/   A0   A1   A2   A3g   A4H   A5)   A6
   A6   A7   A8   A9   A:o   A;P   A<1   A=   A=   A>   A?   A@   AAw   ABX   AC9   AD   AD   AE   AF   AG   AH   AI`   AJA   AK"   AL   AL   AM   AN   AO   APh   AQI   AR*   AS   AS   AT   AU   AV   AWp   AXQ   AY2   AZ   AZ   A[   A\   A]   A^x   A_Y   A`:   Aa   Aa   Ab   Ac   Ad   Ae   Afa   AgB   Ah#   Ai   Ai   Aj   Ak   Al   Ami   AnJ   Ao+   Ap   Ap   Aq   Ar   As   Atq   AuR   Av3   Aw   Aw   Ax   Ay   Az   A{y   A|Z   A};   A~   A~   A   Aـ   Aف   Aق   Aكb   AلC   Aم$   Aن   Aن   Aه   Aو   Aى   Aيj   AًK   Aٌ,   Aٍ
   Aٍ   Aَ   Aُ   Aِ   Aّr   AْS   Aٓ4   Aٔ   Aٔ   Aٕ   Aٖ   Aٗ   A٘z   Aٙ[   Aٚ<   Aٛ   Aٛ   Aٜ   Aٝ   Aٞ   Aٟ   A٠c   A١D   A٢%   A٣   A٣   A٤   A٥   A٦   A٧k   A٨L   A٩-   A٪   A٪   A٫   A٬   A٭   Aٮs   AٯT   Aٰ5   Aٱ   Aٱ   Aٲ   Aٳ   Aٴ   Aٵ{   Aٶ\   Aٷ=   Aٸ   Aٸ   Aٹ   Aٺ   Aٻ   Aټ   Aٽd   AپE   Aٿ&   A   A   A   Aª   AË   Al   AM   A.   A   A   A   Aɲ   Aʓ   At   AU   A6   A   A   A   Aк   Aћ   A|   A]   A>   A   A    A   A   Aأ   Aل   Ae   AF   A'   A   A   A   A߫   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A 0   A   A   A   A   A   Av   AW   A8   A   A   A	   A
   A   A~   A
_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A    A!   A"w   A#X   A$9   A%   A%   A&   A'   A(   A)   A*`   A+A   A,"   A-   A-   A.   A/   A0   A1h   A2I   A3*   A4   A4   A5   A6   A7   A8p   A9Q   A:2   A;   A;   A<   A=   A>   A?x   A@Y   AA:   AB   AB   AC   AD   AE   AF   AGa   AHB   AI#   AJ   AJ   AK   AL   AM   ANi   AOJ   AP+   AQ   AQ   AR   AS   AT   AUq   AVR   AW3   AX   AX   AY   AZ   A[   A\y   A]Z   A^;   A_   A_   A`   Aa   Ab   Ac   Adb   AeC   Af$   Ag   Ag   Ah   Ai   Aj   Akj   AlK   Am,   An
   An   Ao   Ap   Aq   Arr   AsS   At4   Au   Au   Av   Aw   Ax   Ayz   Az[   A{<   A|   A|   A}   A~   A   Aڀ   Aځc   AڂD   Aڃ%   Aڄ   Aڄ   Aڅ   Aچ   Aڇ   Aڈk   AډL   Aڊ-   Aڋ   Aڋ   Aڌ   Aڍ   Aڎ   Aڏs   AڐT   Aڑ5   Aڒ   Aڒ   Aړ   Aڔ   Aڕ   Aږ{   Aڗ\   Aژ=   Aڙ   Aڙ   Aښ   Aڛ   Aڜ   Aڝ   Aڞd   AڟE   Aڠ&   Aڡ   Aڡ   Aڢ   Aڣ   Aڤ   Aڥl   AڦM   Aڧ.   Aڨ   Aڨ   Aک   Aڪ   Aګ   Aڬt   AڭU   Aڮ6   Aگ   Aگ   Aڰ   Aڱ   Aڲ   Aڳ|   Aڴ]   Aڵ>   Aڶ   Aڷ    Aڷ   Aڸ   Aڹ   Aں   Aڻe   AڼF   Aڽ'   Aھ   Aھ   Aڿ   A   A   Am   AN   A/   A   A   A   Aǳ   AȔ   Au   AV   A7   A   A   A   Aλ   AϜ   A}   A^   A?   A    A   A   A   A֤   Aׅ   Af   AG   A(   A	   A   A   Aݬ   Aލ   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A    A   A   Aw   AX   A9   A   A   A   A   A	   A
   A`   AA   A
"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   A x   A!Y   A":   A#   A#   A$   A%   A&   A'   A(a   A)B   A*#   A+   A+   A,   A-   A.   A/i   A0J   A1+   A2   A2   A3   A4   A5   A6q   A7R   A83   A9   A9   A:   A;   A<   A=y   A>Z   A?;   A@   A@   AA   AB   AC   AD   AEb   AFC   AG$   AH   AH   AI   AJ   AK   ALj   AMK   AN,   AO
   AO   AP   AQ   AR   ASr   ATS   AU4   AV   AV   AW   AX   AY   AZz   A[[   A\<   A]   A]   A^   A_   A`   Aa   Abc   AcD   Ad%   Ae   Ae   Af   Ag   Ah   Aik   AjL   Ak-   Al   Al   Am   An   Ao   Aps   AqT   Ar5   As   As   At   Au   Av   Aw{   Ax\   Ay=   Az   Az   A{   A|   A}   A~   Ad   AۀE   Aہ&   Aۂ   Aۂ   Aۃ   Aۄ   Aۅ   Aۆl   AۇM   Aۈ.   Aۉ   Aۉ   Aۊ   Aۋ   Aی   Aۍt   AێU   Aۏ6   Aې   Aې   Aۑ   Aے   Aۓ   A۔|   Aە]   Aۖ>   Aۗ   Aۘ    Aۘ   Aۙ   Aۚ   Aۛ   Aۜe   A۝F   A۞'   A۟   A۟   A۠   Aۡ   Aۢ   Aۣm   AۤN   Aۥ/   Aۦ   Aۦ   Aۧ   Aۨ   A۩   A۪u   A۫V   A۬7   Aۭ   Aۭ   Aۮ   Aۯ   A۰   A۱}   A۲^   A۳?   A۴    A۵   A۵   A۶   A۷   A۸   A۹f   AۺG   Aۻ(   Aۼ	   Aۼ   A۽   A۾   Aۿ   An   AO   A0   A   A   A   AŴ   Aƕ   Av   AW   A8   A   A   A   A̼   A͝   A~   A_   A@   A!   A   A   A   Aԥ   AՆ   Ag   AH   A)   A
   A   A   Aۭ   A܎   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A    Ax   AY   A:   A   A   A   A   A   A   A	a   A
B   A#   A   A   A
   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A ;   A!   A!   A"   A#   A$   A%   A&b   A'C   A($   A)   A)   A*   A+   A,   A-j   A.K   A/,   A0
   A0   A1   A2   A3   A4r   A5S   A64   A7   A7   A8   A9   A:   A;z   A<[   A=<   A>   A>   A?   A@   AA   AB   ACc   ADD   AE%   AF   AF   AG   AH   AI   AJk   AKL   AL-   AM   AM   AN   AO   AP   AQs   ART   AS5   AT   AT   AU   AV   AW   AX{   AY\   AZ=   A[   A[   A\   A]   A^   A_   A`d   AaE   Ab&   Ac   Ac   Ad   Ae   Af   Agl   AhM   Ai.   Aj   Aj   Ak   Al   Am   Ant   AoU   Ap6   Aq   Aq   Ar   As   At   Au|   Av]   Aw>   Ax   Ay    Ay   Az   A{   A|   A}e   A~F   A'   A܀   A܀   A܁   A܂   A܃   A܄m   A܅N   A܆/   A܇   A܇   A܈   A܉   A܊   A܋u   A܌V   A܍7   A܎   A܎   A܏   Aܐ   Aܑ   Aܒ}   Aܓ^   Aܔ?   Aܕ    Aܖ   Aܖ   Aܗ   Aܘ   Aܙ   Aܚf   AܛG   Aܜ(   Aܝ	   Aܝ   Aܞ   Aܟ   Aܠ   Aܡn   AܢO   Aܣ0   Aܤ   Aܤ   Aܥ   Aܦ   Aܧ   Aܨv   AܩW   Aܪ8   Aܫ   Aܫ   Aܬ   Aܭ   Aܮ   Aܯ~   Aܰ_   Aܱ@   Aܲ!   Aܳ   Aܳ   Aܴ   Aܵ   Aܶ   Aܷg   AܸH   Aܹ)   Aܺ
   Aܺ   Aܻ   Aܼ   Aܽ   Aܾo   AܿP   A1   A   A   A   Aõ   AĖ   Aw   AX   A9   A   A   A   Aʽ   A˞   A   A`   AA   A"   A   A   A   AҦ   AӇ   Ah   AI   A*   A   A   A   Aٮ   Aڏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   A Z   A;   A   A   A   A   A   A   Ab   AC   A	$   A
   A
   A   A   A
   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A    A!   A"   A#   A$c   A%D   A&%   A'   A'   A(   A)   A*   A+k   A,L   A--   A.   A.   A/   A0   A1   A2s   A3T   A45   A5   A5   A6   A7   A8   A9{   A:\   A;=   A<   A<   A=   A>   A?   A@   AAd   ABE   AC&   AD   AD   AE   AF   AG   AHl   AIM   AJ.   AK   AK   AL   AM   AN   AOt   APU   AQ6   AR   AR   AS   AT   AU   AV|   AW]   AX>   AY   AZ    AZ   A[   A\   A]   A^e   A_F   A`'   Aa   Aa   Ab   Ac   Ad   Aem   AfN   Ag/   Ah   Ah   Ai   Aj   Ak   Alu   AmV   An7   Ao   Ao   Ap   Aq   Ar   As}   At^   Au?   Av    Aw   Aw   Ax   Ay   Az   A{f   A|G   A}(   A~	   A~   A   A݀   A݁   A݂n   A݃O   A݄0   A݅   A݅   A݆   A݇   A݈   A݉v   A݊W   A݋8   A݌   A݌   Aݍ   Aݎ   Aݏ   Aݐ~   Aݑ_   Aݒ@   Aݓ!   Aݔ   Aݔ   Aݕ   Aݖ   Aݗ   Aݘg   AݙH   Aݚ)   Aݛ
   Aݛ   Aݜ   Aݝ   Aݞ   Aݟo   AݠP   Aݡ1   Aݢ   Aݢ   Aݣ   Aݤ   Aݥ   Aݦw   AݧX   Aݨ9   Aݩ   Aݩ   Aݪ   Aݫ   Aݬ   Aݭ   Aݮ`   AݯA   Aݰ"   Aݱ   Aݱ   Aݲ   Aݳ   Aݴ   Aݵh   AݶI   Aݷ*   Aݸ   Aݸ   Aݹ   Aݺ   Aݻ   Aݼp   AݽQ   Aݾ2   Aݿ   Aݿ   A   A   A   Ax   AY   A:   A   A   A   AȾ   Aɟ   Aʀ   Aa   AB   A#   A   A   A   AЧ   Aш   Ai   AJ   A+   A   A   A   Aׯ   Aؐ   Aq   AR   A3   A   A   A   A޷   Aߘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A    A    A   A   A   A   Ac   AD   A%   A   A   A	   A
   A   Ak   A
L   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A    A!   A"d   A#E   A$&   A%   A%   A&   A'   A(   A)l   A*M   A+.   A,   A,   A-   A.   A/   A0t   A1U   A26   A3   A3   A4   A5   A6   A7|   A8]   A9>   A:   A;    A;   A<   A=   A>   A?e   A@F   AA'   AB   AB   AC   AD   AE   AFm   AGN   AH/   AI   AI   AJ   AK   AL   AMu   ANV   AO7   AP   AP   AQ   AR   AS   AT}   AU^   AV?   AW    AX   AX   AY   AZ   A[   A\f   A]G   A^(   A_	   A_   A`   Aa   Ab   Acn   AdO   Ae0   Af   Af   Ag   Ah   Ai   Ajv   AkW   Al8   Am   Am   An   Ao   Ap   Aq~   Ar_   As@   At!   Au   Au   Av   Aw   Ax   Ayg   AzH   A{)   A|
   A|   A}   A~   A   Aހo   AށP   Aނ1   Aރ   Aރ   Aބ   Aޅ   Aކ   Aއw   AވX   Aމ9   Aފ   Aފ   Aދ   Aތ   Aލ   Aގ   Aޏ`   AސA   Aޑ"   Aޒ   Aޒ   Aޓ   Aޔ   Aޕ   Aޖh   AޗI   Aޘ*   Aޙ   Aޙ   Aޚ   Aޛ   Aޜ   Aޝp   AޞQ   Aޟ2   Aޠ   Aޠ   Aޡ   Aޢ   Aޣ   Aޤx   AޥY   Aަ:   Aާ   Aާ   Aި   Aީ   Aު   Aޫ   Aެa   AޭB   Aޮ#   Aޯ   Aޯ   Aް   Aޱ   A޲   A޳i   A޴J   A޵+   A޶   A޶   A޷   A޸   A޹   A޺q   A޻R   A޼3   A޽   A޽   A޾   A޿   A   Ay   AZ   A;   A   A   A   Aƿ   AǠ   Aȁ   Ab   AC   A$   A   A   A   AΨ   Aω   Aj   AK   A,   A
   A   A   Aհ   A֑   Ar   AS   A4   A   A   A   Aܸ   Aݙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A    A   A   Ad   AE   A&   A   A   A   A   A	   A
l   AM   A.   A
   A
   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   A e   A!F   A"'   A#   A#   A$   A%   A&   A'm   A(N   A)/   A*   A*   A+   A,   A-   A.u   A/V   A07   A1   A1   A2   A3   A4   A5}   A6^   A7?   A8    A9   A9   A:   A;   A<   A=f   A>G   A?(   A@	   A@   AA   AB   AC   ADn   AEO   AF0   AG   AG   AH   AI   AJ   AKv   ALW   AM8   AN   AN   AO   AP   AQ   AR~   AS_   AT@   AU!   AV   AV   AW   AX   AY   AZg   A[H   A\)   A]
   A]   A^   A_   A`   Aao   AbP   Ac1   Ad   Ad   Ae   Af   Ag   Ahw   AiX   Aj9   Ak   Ak   Al   Am   An   Ao   Ap`   AqA   Ar"   As   As   At   Au   Av   Awh   AxI   Ay*   Az   Az   A{   A|   A}   A~p   AQ   A߀2   A߁   A߁   A߂   A߃   A߄   A߅x   A߆Y   A߇:   A߈   A߈   A߉   Aߊ   Aߋ   Aߌ   Aߍa   AߎB   Aߏ#   Aߐ   Aߐ   Aߑ   Aߒ   Aߓ   Aߔi   AߕJ   Aߖ+   Aߗ   Aߗ   Aߘ   Aߙ   Aߚ   Aߛq   AߜR   Aߝ3   Aߞ   Aߞ   Aߟ   Aߠ   Aߡ   Aߢy   AߣZ   Aߤ;   Aߥ   Aߥ   Aߦ   Aߧ   Aߨ   Aߩ   Aߪb   A߫C   A߬$   A߭   A߭   A߮   A߯   A߰   A߱j   A߲K   A߳,   Aߴ
   Aߴ   Aߵ   A߶   A߷   A߸r   A߹S   Aߺ4   A߻   A߻   A߼   A߽   A߾   A߿z   A[   A<   A   A   A   A   Aš   AƂ   Ac   AD   A%   A   A   A   A̩   A͊   Ak   AL   A-   A   A   A   Aӱ   AԒ   As   AT   A5   A   A   A   Aڹ   Aۚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A    Ae   AF   A'   A   A   A   A   A   Am   A	N   A
/   A   A   A   A
   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A (   A!	   A!   A"   A#   A$   A%n   A&O   A'0   A(   A(   A)   A*   A+   A,v   A-W   A.8   A/   A/   A0   A1   A2   A3~   A4_   A5@   A6!   A7   A7   A8   A9   A:   A;g   A<H   A=)   A>
   A>   A?   A@   AA   ABo   ACP   AD1   AE   AE   AF   AG   AH   AIw   AJX   AK9   AL   AL   AM   AN   AO   AP   AQ`   ARA   AS"   AT   AT   AU   AV   AW   AXh   AYI   AZ*   A[   A[   A\   A]   A^   A_p   A`Q   Aa2   Ab   Ab   Ac   Ad   Ae   Afx   AgY   Ah:   Ai   Ai   Aj   Ak   Al   Am   Ana   AoB   Ap#   Aq   Aq   Ar   As   At   Aui   AvJ   Aw+   Ax   Ax   Ay   Az   A{   A|q   A}R   A~3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aড   Aূ   Ac   AD   A%   A   A   A   A୩   Aஊ   Ak   AL   A-   A   A   A   Aറ   A൒   As   AT   A5   A   A   A   A໹   A༚   A{   A\   A=   A   A   A   A   Aâ   Aă   Ad   AE   A&   A   A   A   Aʪ   Aˋ   Al   AM   A.   A   A   A   AѲ   Aғ   At   AU   A6   A   A   A   Aغ   Aٛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   A G   A(   A	   A   A   A   A   An   AO   A0   A	   A	   A
   A   A   A
v   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A    A!   A"   A#o   A$P   A%1   A&   A&   A'   A(   A)   A*w   A+X   A,9   A-   A-   A.   A/   A0   A1   A2`   A3A   A4"   A5   A5   A6   A7   A8   A9h   A:I   A;*   A<   A<   A=   A>   A?   A@p   AAQ   AB2   AC   AC   AD   AE   AF   AGx   AHY   AI:   AJ   AJ   AK   AL   AM   AN   AOa   APB   AQ#   AR   AR   AS   AT   AU   AVi   AWJ   AX+   AY   AY   AZ   A[   A\   A]q   A^R   A_3   A`   A`   Aa   Ab   Ac   Ady   AeZ   Af;   Ag   Ag   Ah   Ai   Aj   Ak   Alb   AmC   An$   Ao   Ao   Ap   Aq   Ar   Asj   AtK   Au,   Av
   Av   Aw   Ax   Ay   Azr   A{S   A|4   A}   A}   A~   A   Aမ   Az   A[   A<   A   A   A   A   Aᇡ   Aሂ   Ac   AD   A%   A   A   A   AᎩ   AᏊ   Ak   AL   A-   A   A   A   Aᕱ   Aᖒ   As   AT   A5   A   A   A   A᜹   A᝚   A{   A\   A=   A   A   A   A   Aᤢ   A᥃   Ad   AE   A&   A   A   A   A᫪   Aᬋ   Al   AM   A.   A   A   A   AᲲ   A᳓   At   AU   A6   A   A   A   AṺ   Aẛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   Aȫ   AɌ   Am   AN   A/   A   A   A   Aϳ   AД   Au   AV   A7   A   A   A   Aֻ   Aל   A}   A^   A?   A    A   A   A   Aޤ   A߅   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A 
   A    A   A   A   Ao   AP   A1   A   A   A   A	   A
   Aw   AX   A
9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A    A!p   A"Q   A#2   A$   A$   A%   A&   A'   A(x   A)Y   A*:   A+   A+   A,   A-   A.   A/   A0a   A1B   A2#   A3   A3   A4   A5   A6   A7i   A8J   A9+   A:   A:   A;   A<   A=   A>q   A?R   A@3   AA   AA   AB   AC   AD   AEy   AFZ   AG;   AH   AH   AI   AJ   AK   AL   AMb   ANC   AO$   AP   AP   AQ   AR   AS   ATj   AUK   AV,   AW
   AW   AX   AY   AZ   A[r   A\S   A]4   A^   A^   A_   A`   Aa   Abz   Ac[   Ad<   Ae   Ae   Af   Ag   Ah   Ai   Ajc   AkD   Al%   Am   Am   An   Ao   Ap   Aqk   ArL   As-   At   At   Au   Av   Aw   Axs   AyT   Az5   A{   A{   A|   A}   A~   A{   A\   A=   A   A   A   A   AⅢ   AↃ   Ad   AE   A&   A   A   A   A〉   A⍋   Al   AM   A.   A   A   A   A⓲   A┓   At   AU   A6   A   A   A   A⚺   A⛛   A|   A]   A>   A   A    A   A   A⢣   A⣄   Ae   AF   A'   A   A   A   A⩫   A⪌   Am   AN   A/   A   A   A   Aⰳ   Aⱔ   Au   AV   A7   A   A   A   Aⷻ   A⸜   A}   A^   A?   A    A   A   A   A⿤   A   Af   AG   A(   A	   A   A   AƬ   AǍ   An   AO   A0   A   A   A   Aʹ   AΕ   Av   AW   A8   A   A   A   AԼ   A՝   A~   A_   A@   A!   A   A   A   Aܥ   A݆   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A    A   Ap   AQ   A2   A   A   A   A   A   A	x   A
Y   A:   A   A   A
   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   A R   A!3   A"   A"   A#   A$   A%   A&y   A'Z   A(;   A)   A)   A*   A+   A,   A-   A.b   A/C   A0$   A1   A1   A2   A3   A4   A5j   A6K   A7,   A8
   A8   A9   A:   A;   A<r   A=S   A>4   A?   A?   A@   AA   AB   ACz   AD[   AE<   AF   AF   AG   AH   AI   AJ   AKc   ALD   AM%   AN   AN   AO   AP   AQ   ARk   ASL   AT-   AU   AU   AV   AW   AX   AYs   AZT   A[5   A\   A\   A]   A^   A_   A`{   Aa\   Ab=   Ac   Ac   Ad   Ae   Af   Ag   Ahd   AiE   Aj&   Ak   Ak   Al   Am   An   Aol   ApM   Aq.   Ar   Ar   As   At   Au   Avt   AwU   Ax6   Ay   Ay   Az   A{   A|   A}|   A~]   A>   A   A    A   A   Aャ   A㄄   Ae   AF   A'   A   A   A   A㊫   A㋌   Am   AN   A/   A   A   A   A㑳   A㒔   Au   AV   A7   A   A   A   A㘻   A㙜   A}   A^   A?   A    A   A   A   A㠤   A㡅   Af   AG   A(   A	   A   A   A㧬   A㨍   An   AO   A0   A   A   A   A㮴   A㯕   Av   AW   A8   A   A   A   A㵼   A㶝   A~   A_   A@   A!   A   A   A   A㽥   A㾆   Ag   AH   A)   A
   A   A   Aĭ   AŎ   Ao   AP   A1   A   A   A   A˵   A̖   Aw   AX   A9   A   A   A   Aҽ   AӞ   A   A`   AA   A"   A   A   A   Aڦ   Aۇ   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   A q   AR   A3   A   A   A   A   A   Ay   AZ   A	;   A
   A
   A   A   A
   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A    A    A!   A"   A#   A$z   A%[   A&<   A'   A'   A(   A)   A*   A+   A,c   A-D   A.%   A/   A/   A0   A1   A2   A3k   A4L   A5-   A6   A6   A7   A8   A9   A:s   A;T   A<5   A=   A=   A>   A?   A@   AA{   AB\   AC=   AD   AD   AE   AF   AG   AH   AId   AJE   AK&   AL   AL   AM   AN   AO   APl   AQM   AR.   AS   AS   AT   AU   AV   AWt   AXU   AY6   AZ   AZ   A[   A\   A]   A^|   A_]   A`>   Aa   Ab    Ab   Ac   Ad   Ae   Afe   AgF   Ah'   Ai   Ai   Aj   Ak   Al   Amm   AnN   Ao/   Ap   Ap   Aq   Ar   As   Atu   AuV   Av7   Aw   Aw   Ax   Ay   Az   A{}   A|^   A}?   A~    A   A   A   A䁤   A䂅   Af   AG   A(   A	   A   A   A䈬   A䉍   An   AO   A0   A   A   A   A䏴   A䐕   Av   AW   A8   A   A   A   A䖼   A䗝   A~   A_   A@   A!   A   A   A   A䞥   A䟆   Ag   AH   A)   A
   A   A   A䥭   A䦎   Ao   AP   A1   A   A   A   A䬵   A䭖   Aw   AX   A9   A   A   A   A䳽   A䴞   A   A`   AA   A"   A   A   A   A仦   A伇   Ah   AI   A*   A   A   A   A®   AÏ   Ap   AQ   A2   A   A   A   Aɶ   Aʗ   Ax   AY   A:   A   A   A   Aо   Aџ   AҀ   Aa   AB   A#   A   A   A   Aا   Aو   Ai   AJ   A+   A   A   A   A߯   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A 4   A   A   A   A   A   Az   A[   A<   A   A   A	   A
   A   A   A
c   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A    A!   A"{   A#\   A$=   A%   A%   A&   A'   A(   A)   A*d   A+E   A,&   A-   A-   A.   A/   A0   A1l   A2M   A3.   A4   A4   A5   A6   A7   A8t   A9U   A:6   A;   A;   A<   A=   A>   A?|   A@]   AA>   AB   AC    AC   AD   AE   AF   AGe   AHF   AI'   AJ   AJ   AK   AL   AM   ANm   AON   AP/   AQ   AQ   AR   AS   AT   AUu   AVV   AW7   AX   AX   AY   AZ   A[   A\}   A]^   A^?   A_    A`   A`   Aa   Ab   Ac   Adf   AeG   Af(   Ag	   Ag   Ah   Ai   Aj   Akn   AlO   Am0   An   An   Ao   Ap   Aq   Arv   AsW   At8   Au   Au   Av   Aw   Ax   Ay~   Az_   A{@   A|!   A}   A}   A~   A   A倆   Ag   AH   A)   A
   A   A   A冭   A凎   Ao   AP   A1   A   A   A   A卵   A厖   Aw   AX   A9   A   A   A   A唽   A啞   A   A`   AA   A"   A   A   A   A圦   A均   Ah   AI   A*   A   A   A   A壮   A夏   Ap   AQ   A2   A   A   A   A媶   A嫗   Ax   AY   A:   A   A   A   A屾   A岟   A峀   Aa   AB   A#   A   A   A   A幧   A庈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   AǷ   AȘ   Ay   AZ   A;   A   A   A   Aο   AϠ   AЁ   Ab   AC   A$   A   A   A   A֨   A׉   Aj   AK   A,   A
   A   A   Aݰ   Aޑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A    A   A   A{   A\   A=   A   A   A   A   A	   A
   Ad   AE   A
&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A |   A!]   A">   A#   A$    A$   A%   A&   A'   A(e   A)F   A*'   A+   A+   A,   A-   A.   A/m   A0N   A1/   A2   A2   A3   A4   A5   A6u   A7V   A87   A9   A9   A:   A;   A<   A=}   A>^   A??   A@    AA   AA   AB   AC   AD   AEf   AFG   AG(   AH	   AH   AI   AJ   AK   ALn   AMO   AN0   AO   AO   AP   AQ   AR   ASv   ATW   AU8   AV   AV   AW   AX   AY   AZ~   A[_   A\@   A]!   A^   A^   A_   A`   Aa   Abg   AcH   Ad)   Ae
   Ae   Af   Ag   Ah   Aio   AjP   Ak1   Al   Al   Am   An   Ao   Apw   AqX   Ar9   As   As   At   Au   Av   Aw   Ax`   AyA   Az"   A{   A{   A|   A}   A~   Ah   AI   A*   A   A   A   A愮   A慏   Ap   AQ   A2   A   A   A   A拶   A挗   Ax   AY   A:   A   A   A   A撾   A擟   A攀   Aa   AB   A#   A   A   A   A暧   A曈   Ai   AJ   A+   A   A   A   A桯   A梐   Aq   AR   A3   A   A   A   A樷   A橘   Ay   AZ   A;   A   A   A   A毿   A氠   A汁   Ab   AC   A$   A   A   A   A淨   A渉   Aj   AK   A,   A
   A   A   A澰   A濑   Ar   AS   A4   A   A   A   AŸ   Aƙ   Az   A[   A<   A   A   A   A   A͡   A΂   Ac   AD   A%   A   A   AՊ   Ak   AL   A-   A   A   A   A۱   Aܒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A    A|   A]   A>   A   A    A   A   A   A   A	e   A
F   A'   A   A   A
   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A ?   A!    A"   A"   A#   A$   A%   A&f   A'G   A((   A)	   A)   A*   A+   A,   A-n   A.O   A/0   A0   A0   A1   A2   A3   A4v   A5W   A68   A7   A7   A8   A9   A:   A;~   A<_   A=@   A>!   A?   A?   A@   AA   AB   ACg   ADH   AE)   AF
   AF   AG   AH   AI   AJo   AKP   AL1   AM   AM   AN   AO   AP   AQw   ARX   AS9   AT   AT   AU   AV   AW   AX   AY`   AZA   A["   A\   A\   A]   A^   A_   A`h   AaI   Ab*   Ac   Ac   Ad   Ae   Af   Agp   AhQ   Ai2   Aj   Aj   Ak   Al   Am   Anx   AoY   Ap:   Aq   Aq   Ar   As   At   Au   Ava   AwB   Ax#   Ay   Ay   Az   A{   A|   A}i   A~J   A+   A   A   A   A炯   A烐   Aq   AR   A3   A   A   A   A牷   A犘   Ay   AZ   A;   A   A   A   A琿   A瑠   A璁   Ab   AC   A$   A   A   A   A瘨   A癉   Aj   AK   A,   A
   A   A   A矰   A砑   Ar   AS   A4   A   A   A   A禸   A秙   Az   A[   A<   A   A   A   A   A管   A篂   Ac   AD   A%   A   A   A   A絩   A綊   Ak   AL   A-   A   A   A   A缱   A罒   As   AT   A5   A   A   A   Aù   AĚ   A{   A\   A=   A   A   A   A   Aˢ   Ã   Ad   AE   A&   A   A   A   AҪ   AӋ   Al   AM   A.   A   A   A   Aٲ   Aړ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A ^   A?   A    A   A   A   A   A   Af   AG   A	(   A
	   A
   A   A   A
   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A    A    A!   A"   A#   A$g   A%H   A&)   A'
   A'   A(   A)   A*   A+o   A,P   A-1   A.   A.   A/   A0   A1   A2w   A3X   A49   A5   A5   A6   A7   A8   A9   A:`   A;A   A<"   A=   A=   A>   A?   A@   AAh   ABI   AC*   AD   AD   AE   AF   AG   AHp   AIQ   AJ2   AK   AK   AL   AM   AN   AOx   APY   AQ:   AR   AR   AS   AT   AU   AV   AWa   AXB   AY#   AZ   AZ   A[   A\   A]   A^i   A_J   A`+   Aa   Aa   Ab   Ac   Ad   Aeq   AfR   Ag3   Ah   Ah   Ai   Aj   Ak   Aly   AmZ   An;   Ao   Ao   Ap   Aq   Ar   As   Atb   AuC   Av$   Aw   Aw   Ax   Ay   Az   A{j   A|K   A},   A~
   A~   A   A耰   A聑   Ar   AS   A4   A   A   A   A臸   A舙   Az   A[   A<   A   A   A   A   A菡   A萂   Ac   AD   A%   A   A   A   A薩   A藊   Ak   AL   A-   A   A   A   A蝱   A螒   As   AT   A5   A   A   A   A褹   A襚   A{   A\   A=   A   A   A   A   A謢   A譃   Ad   AE   A&   A   A   A   A質   A贋   Al   AM   A.   A   A   A   A躲   A軓   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aɣ   Aʄ   Ae   AF   A'   A   A   A   AЫ   Aь   Am   AN   A/   A   A   A   A׳   Aؔ   Au   AV   A7   A   A   A   A޻   Aߜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A !   A   A   A   A   A   Ag   AH   A)   A
   A   A	   A
   A   Ao   A
P   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A    A!   A"h   A#I   A$*   A%   A%   A&   A'   A(   A)p   A*Q   A+2   A,   A,   A-   A.   A/   A0x   A1Y   A2:   A3   A3   A4   A5   A6   A7   A8a   A9B   A:#   A;   A;   A<   A=   A>   A?i   A@J   AA+   AB   AB   AC   AD   AE   AFq   AGR   AH3   AI   AI   AJ   AK   AL   AMy   ANZ   AO;   AP   AP   AQ   AR   AS   AT   AUb   AVC   AW$   AX   AX   AY   AZ   A[   A\j   A]K   A^,   A_
   A_   A`   Aa   Ab   Acr   AdS   Ae4   Af   Af   Ag   Ah   Ai   Ajz   Ak[   Al<   Am   Am   An   Ao   Ap   Aq   Arc   AsD   At%   Au   Au   Av   Aw   Ax   Ayk   AzL   A{-   A|   A|   A}   A~   A   As   AT   A5   A   A   A   A酹   A醚   A{   A\   A=   A   A   A   A   A鍢   A鎃   Ad   AE   A&   A   A   A   A锪   A镋   Al   AM   A.   A   A   A   A雲   A霓   At   AU   A6   A   A   A   A颺   A飛   A|   A]   A>   A   A    A   A   A骣   A髄   Ae   AF   A'   A   A   A   A鱫   A鲌   Am   AN   A/   A   A   A   A鸳   A鹔   Au   AV   A7   A   A   A   A鿻   A   A}   A^   A?   A    A   A   A   AǤ   Aȅ   Af   AG   A(   A	   A   A   Aά   Aύ   An   AO   A0   A   A   A   Aմ   A֕   Av   AW   A8   A   A   A   Aܼ   Aݝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A    A   A   Ah   AI   A*   A   A   A   A   A	   A
p   AQ   A2   A
   A
   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   A i   A!J   A"+   A#   A#   A$   A%   A&   A'q   A(R   A)3   A*   A*   A+   A,   A-   A.y   A/Z   A0;   A1   A1   A2   A3   A4   A5   A6b   A7C   A8$   A9   A9   A:   A;   A<   A=j   A>K   A?,   A@
   A@   AA   AB   AC   ADr   AES   AF4   AG   AG   AH   AI   AJ   AKz   AL[   AM<   AN   AN   AO   AP   AQ   AR   ASc   ATD   AU%   AV   AV   AW   AX   AY   AZk   A[L   A\-   A]   A]   A^   A_   A`   Aas   AbT   Ac5   Ad   Ad   Ae   Af   Ag   Ah{   Ai\   Aj=   Ak   Ak   Al   Am   An   Ao   Apd   AqE   Ar&   As   As   At   Au   Av   Awl   AxM   Ay.   Az   Az   A{   A|   A}   A~t   AU   A6   A   A   A   Aꃺ   Aꄛ   A|   A]   A>   A   A    A   A   Aꋣ   Aꌄ   Ae   AF   A'   A   A   A   A꒫   A꓌   Am   AN   A/   A   A   A   A꙳   AꚔ   Au   AV   A7   A   A   A   A꠻   Aꡜ   A}   A^   A?   A    A   A   A   Aꨤ   Aꩅ   Af   AG   A(   A	   A   A   A꯬   A갍   An   AO   A0   A   A   A   A궴   A귕   Av   AW   A8   A   A   A   A꽼   A꾝   A~   A_   A@   A!   A   A   A   Ať   AƆ   Ag   AH   A)   A
   A   A   A̭   A͎   Ao   AP   A1   A   A   A   Aӵ   AԖ   Aw   AX   A9   A   A   A   Aڽ   A۞   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A    Ai   AJ   A+   A   A   A   A   A   Aq   A	R   A
3   A   A   A   A
   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A ,   A!
   A!   A"   A#   A$   A%r   A&S   A'4   A(   A(   A)   A*   A+   A,z   A-[   A.<   A/   A/   A0   A1   A2   A3   A4c   A5D   A6%   A7   A7   A8   A9   A:   A;k   A<L   A=-   A>   A>   A?   A@   AA   ABs   ACT   AD5   AE   AE   AF   AG   AH   AI{   AJ\   AK=   AL   AL   AM   AN   AO   AP   AQd   ARE   AS&   AT   AT   AU   AV   AW   AXl   AYM   AZ.   A[   A[   A\   A]   A^   A_t   A`U   Aa6   Ab   Ab   Ac   Ad   Ae   Af|   Ag]   Ah>   Ai   Aj    Aj   Ak   Al   Am   Ane   AoF   Ap'   Aq   Aq   Ar   As   At   Aum   AvN   Aw/   Ax   Ax   Ay   Az   A{   A|u   A}V   A~7   A   A   A   A끻   A난   A}   A^   A?   A    A   A   A   A뉤   A늅   Af   AG   A(   A	   A   A   A됬   A둍   An   AO   A0   A   A   A   A뗴   A똕   Av   AW   A8   A   A   A   A랼   A럝   A~   A_   A@   A!   A   A   A   A릥   A맆   Ag   AH   A)   A
   A   A   A뭭   A뮎   Ao   AP   A1   A   A   A   A봵   A뵖   Aw   AX   A9   A   A   A   A뻽   A뼞   A   A`   AA   A"   A   A   A   Aæ   Ać   Ah   AI   A*   A   A   A   Aʮ   Aˏ   Ap   AQ   A2   A   A   A   AѶ   Aҗ   Ax   AY   A:   A   A   A   Aؾ   Aٟ   Aڀ   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   A K   A,   A
   A   A   A   A   Ar   AS   A4   A	   A	   A
   A   A   A
z   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A    A!   A"   A#s   A$T   A%5   A&   A&   A'   A(   A)   A*{   A+\   A,=   A-   A-   A.   A/   A0   A1   A2d   A3E   A4&   A5   A5   A6   A7   A8   A9l   A:M   A;.   A<   A<   A=   A>   A?   A@t   AAU   AB6   AC   AC   AD   AE   AF   AG|   AH]   AI>   AJ   AK    AK   AL   AM   AN   AOe   APF   AQ'   AR   AR   AS   AT   AU   AVm   AWN   AX/   AY   AY   AZ   A[   A\   A]u   A^V   A_7   A`   A`   Aa   Ab   Ac   Ad}   Ae^   Af?   Ag    Ah   Ah   Ai   Aj   Ak   Alf   AmG   An(   Ao	   Ao   Ap   Aq   Ar   Asn   AtO   Au0   Av   Av   Aw   Ax   Ay   Azv   A{W   A|8   A}   A}   A~   A   A쀝   A~   A_   A@   A!   A   A   A   A쇥   A숆   Ag   AH   A)   A
   A   A   A쎭   A쏎   Ao   AP   A1   A   A   A   A앵   A얖   Aw   AX   A9   A   A   A   A윽   A읞   A   A`   AA   A"   A   A   A   A줦   A쥇   Ah   AI   A*   A   A   A   A쫮   A쬏   Ap   AQ   A2   A   A   A   A첶   A쳗   Ax   AY   A:   A   A   A   A칾   A캟   A컀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   Aȯ   Aɐ   Aq   AR   A3   A   A   A   AϷ   AИ   Ay   AZ   A;   A   A   A   Aֿ   Aנ   A؁   Ab   AC   A$   A   A   A   Aި   A߉   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A    A    A   A   A   As   AT   A5   A   A   A   A	   A
   A{   A\   A
=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A    A!t   A"U   A#6   A$   A$   A%   A&   A'   A(|   A)]   A*>   A+   A,    A,   A-   A.   A/   A0e   A1F   A2'   A3   A3   A4   A5   A6   A7m   A8N   A9/   A:   A:   A;   A<   A=   A>u   A?V   A@7   AA   AA   AB   AC   AD   AE}   AF^   AG?   AH    AI   AI   AJ   AK   AL   AMf   ANG   AO(   AP	   AP   AQ   AR   AS   ATn   AUO   AV0   AW   AW   AX   AY   AZ   A[v   A\W   A]8   A^   A^   A_   A`   Aa   Ab~   Ac_   Ad@   Ae!   Af   Af   Ag   Ah   Ai   Ajg   AkH   Al)   Am
   Am   An   Ao   Ap   Aqo   ArP   As1   At   At   Au   Av   Aw   Axw   AyX   Az9   A{   A{   A|   A}   A~   A   A`   AA   A"   A   A   A   A텦   A톇   Ah   AI   A*   A   A   A   A팮   A퍏   Ap   AQ   A2   A   A   A   A퓶   A픗   Ax   AY   A:   A   A   A   A횾   A훟   A휀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   Aư   AǑ   Ar   AS   A4   A   A   A   A͸   AΙ   Az   A[   A<   A   A   A   A   Aա   Aւ   Ac   AD   A%   A   A   A   Aܩ   A݊   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A    A   At   AU   A6   A   A   A   A   A   A	|   A
]   A>   A   A
    A
   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   A V   A!7   A"   A"   A#   A$   A%   A&}   A'^   A(?   A)    A*   A*   A+   A,   A-   A.f   A/G   A0(   A1	   A1   A2   A3   A4   A5n   A6O   A70   A8   A8   A9   A:   A;   A<v   A=W   A>8   A?   A?   A@   AA   AB   AC~   AD_   AE@   AF!   AG   AG   AH   AI   AJ   AKg   ALH   AM)   AN
   AN   AO   AP   AQ   ARo   ASP   AT1   AU   AU   AV   AW   AX   AYw   AZX   A[9   A\   A\   A]   A^   A_   A`   Aa`   AbA   Ac"   Ad   Ad   Ae   Af   Ag   Ahh   AiI   Aj*   Ak   Ak   Al   Am   An   Aop   ApQ   Aq2   Ar   Ar   As   At   Au   Avx   AwY   Ax:   Ay   Ay   Az   A{   A|   A}   A~a   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   Aı   AŒ   As   AT   A5   A   A   A   A˹   A̚   A{   A\   A=   A   A   A   A   AӢ   Aԃ   Ad   AE   A&   A   A   A   Aڪ   Aۋ   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   A u   AV   A7   A   A   A   A   A   A}   A^   A	?   A
    A   A   A   A
   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A    A    A!   A"   A#   A$~   A%_   A&@   A'!   A(   A(   A)   A*   A+   A,g   A-H   A.)   A/
   A/   A0   A1   A2   A3o   A4P   A51   A6   A6   A7   A8   A9   A:w   A;X   A<9   A=   A=   A>   A?   A@   AA   AB`   ACA   AD"   AE   AE   AF   AG   AH   AIh   AJI   AK*   AL   AL   AM   AN   AO   APp   AQQ   AR2   AS   AS   AT   AU   AV   AWx   AXY   AY:   AZ   AZ   A[   A\   A]   A^   A_a   A`B   Aa#   Ab   Ab   Ac   Ad   Ae   Afi   AgJ   Ah+   Ai   Ai   Aj   Ak   Al   Amq   AnR   Ao3   Ap   Ap   Aq   Ar   As   Aty   AuZ   Av;   Aw   Aw   Ax   Ay   Az   A{   A|b   A}C   A~$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A辰   A漣   As   AT   A5   A   A   A   Aיּ   Aﭚ   A{   A\   A=   A   A   A   A   Aﴢ   A﵃   Ad   AE   A&   A   A   A   Aﻪ   A＋   Al   AM   A.   A   A   A   A²   AÓ   At   AU   A6   A   A   A   Aɺ   Aʛ   A|   A]   A>   A   A    A   A   Aѣ   A҄   Ae   AF   A'   A   A   A   Aث   Aٌ   Am   AN   A/   A   A   A   A߳   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A 8   A   A   A   A   A   A~   A_   A@   A!   A	   A	   A
   A   A   A
g   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A    A!   A"   A#`   A$A   A%"   A&   A&   A'   A(   A)   A*h   A+I   A,*   A-   A-   A.   A/   A0   A1p   A2Q   A32   A4   A4   A5   A6   A7   A8x   A9Y   A::   A;   A;   A<   A=   A>   A?   A@a   AAB   AB#   AC   AC   AD   AE   AF   AGi   AHJ   AI+   AJ   AJ   AK   AL   AM   ANq   AOR   AP3   AQ   AQ   AR   AS   AT   AUy   AVZ   AW;   AX   AX   AY   AZ   A[   A\   A]b   A^C   A_$   A`   A`   Aa   Ab   Ac   Adj   AeK   Af,   Ag
   Ag   Ah   Ai   Aj   Akr   AlS   Am4   An   An   Ao   Ap   Aq   Arz   As[   At<   Au   Au   Av   Aw   Ax   Ay   Azc   A{D   A|%   A}   A}   A~   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   Aǻ   AȜ   A}   A^   A?   A    A   A   A   AϤ   AЅ   Af   AG   A(   A	   A   A   A֬   A׍   An   AO   A0   A   A   A   Aݴ   Aޕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A    A   A   A   A`   AA   A"   A   A   A   A	   A
   Ah   AI   A
*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A    A!a   A"B   A##   A$   A$   A%   A&   A'   A(i   A)J   A*+   A+   A+   A,   A-   A.   A/q   A0R   A13   A2   A2   A3   A4   A5   A6y   A7Z   A8;   A9   A9   A:   A;   A<   A=   A>b   A?C   A@$   AA   AA   AB   AC   AD   AEj   AFK   AG,   AH
   AH   AI   AJ   AK   ALr   AMS   AN4   AO   AO   AP   AQ   AR   ASz   AT[   AU<   AV   AV   AW   AX   AY   AZ   A[c   A\D   A]%   A^   A^   A_   A`   Aa   Abk   AcL   Ad-   Ae   Ae   Af   Ag   Ah   Ais   AjT   Ak5   Al   Al   Am   An   Ao   Ap{   Aq\   Ar=   As   As   At   Au   Av   Aw   Axd   AyE   Az&   A{   A{   A|   A}   A~   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   Aż   AƝ   A~   A_   A@   A!   A   A   A   Aͥ   AΆ   Ag   AH   A)   A
   A   A   Aԭ   AՎ   Ao   AP   A1   A   A   A   A۵   Aܖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A    A   Aa   AB   A#   A   A   A   A   A   A	i   A
J   A+   A   A   A
   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   A C   A!$   A"   A"   A#   A$   A%   A&j   A'K   A(,   A)
   A)   A*   A+   A,   A-r   A.S   A/4   A0   A0   A1   A2   A3   A4z   A5[   A6<   A7   A7   A8   A9   A:   A;   A<c   A=D   A>%   A?   A?   A@   AA   AB   ACk   ADL   AE-   AF   AF   AG   AH   AI   AJs   AKT   AL5   AM   AM   AN   AO   AP   AQ{   AR\   AS=   AT   AT   AU   AV   AW   AX   AYd   AZE   A[&   A\   A\   A]   A^   A_   A`l   AaM   Ab.   Ac   Ac   Ad   Ae   Af   Agt   AhU   Ai6   Aj   Aj   Ak   Al   Am   An|   Ao]   Ap>   Aq   Ar    Ar   As   At   Au   Ave   AwF   Ax'   Ay   Ay   Az   A{   A|   A}m   A~N   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   Aý   AĞ   A   A`   AA   A"   A   A   A   A˦   Ȧ   Ah   AI   A*   A   A   A   AҮ   Aӏ   Ap   AQ   A2   A   A   A   Aٶ   Aڗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   A b   AC   A$   A   A   A   A   A   Aj   AK   A	,   A

   A
   A   A   A
   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A    A    A!   A"   A#   A$k   A%L   A&-   A'   A'   A(   A)   A*   A+s   A,T   A-5   A.   A.   A/   A0   A1   A2{   A3\   A4=   A5   A5   A6   A7   A8   A9   A:d   A;E   A<&   A=   A=   A>   A?   A@   AAl   ABM   AC.   AD   AD   AE   AF   AG   AHt   AIU   AJ6   AK   AK   AL   AM   AN   AO|   AP]   AQ>   AR   AS    AS   AT   AU   AV   AWe   AXF   AY'   AZ   AZ   A[   A\   A]   A^m   A_N   A`/   Aa   Aa   Ab   Ac   Ad   Aeu   AfV   Ag7   Ah   Ah   Ai   Aj   Ak   Al}   Am^   An?   Ao    Ap   Ap   Aq   Ar   As   Atf   AuG   Av(   Aw	   Aw   Ax   Ay   Az   A{n   A|O   A}0   A~   A~   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   AÀ   Aa   AB   A#   A   A   A   Aɧ   Aʈ   Ai   AJ   A+   A   A   A   AЯ   Aѐ   Aq   AR   A3   A   A   A   A׷   Aؘ   Ay   AZ   A;   A   A   A   A޿   Aߠ   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A %   A   A   A   A   A   Ak   AL   A-   A   A   A	   A
   A   As   A
T   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A    A!   A"l   A#M   A$.   A%   A%   A&   A'   A(   A)t   A*U   A+6   A,   A,   A-   A.   A/   A0|   A1]   A2>   A3   A4    A4   A5   A6   A7   A8e   A9F   A:'   A;   A;   A<   A=   A>   A?m   A@N   AA/   AB   AB   AC   AD   AE   AFu   AGV   AH7   AI   AI   AJ   AK   AL   AM}   AN^   AO?   AP    AQ   AQ   AR   AS   AT   AUf   AVG   AW(   AX	   AX   AY   AZ   A[   A\n   A]O   A^0   A_   A_   A`   Aa   Ab   Acv   AdW   Ae8   Af   Af   Ag   Ah   Ai   Aj~   Ak_   Al@   Am!   An   An   Ao   Ap   Aq   Arg   AsH   At)   Au
   Au   Av   Aw   Ax   Ayo   AzP   A{1   A|   A|   A}   A~   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   AǨ   Aȉ   Aj   AK   A,   A
   A   A   Aΰ   Aϑ   Ar   AS   A4   A   A   A   Aո   A֙   Az   A[   A<   A   A   A   A   Aݡ   Aނ   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A    A   A   Al   AM   A.   A   A   A   A   A	   A
t   AU   A6   A
   A
   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   A m   A!N   A"/   A#   A#   A$   A%   A&   A'u   A(V   A)7   A*   A*   A+   A,   A-   A.}   A/^   A0?   A1    A2   A2   A3   A4   A5   A6f   A7G   A8(   A9	   A9   A:   A;   A<   A=n   A>O   A?0   A@   A@   AA   AB   AC   ADv   AEW   AF8   AG   AG   AH   AI   AJ   AK~   AL_   AM@   AN!   AO   AO   AP   AQ   AR   ASg   ATH   AU)   AV
   AV   AW   AX   AY   AZo   A[P   A\1   A]   A]   A^   A_   A`   Aaw   AbX   Ac9   Ad   Ad   Ae   Af   Ag   Ah   Ai`   AjA   Ak"   Al   Al   Am   An   Ao   Aph   AqI   Ar*   As   As   At   Au   Av   Awp   AxQ   Ay2   Az   Az   A{   A|   A}   A~x   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   Aũ   AƊ   Ak   AL   A-   A   A   A   A̱   A͒   As   AT   A5   A   A   A   Aӹ   AԚ   A{   A\   A=   A   A   A   A   Aۢ   A܃   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   Aȳ   Aɔ   Au   AV   A7   A   A   A   Aϻ   AМ   A}   A^   A?   A    A   A   A   Aפ   A؅   Af   AG   A(   A	   A   A   Aެ   Aߍ   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A    A    A   A   A   Aw   AX   A9   A   A   A   A	   A
   A   A`   A
A   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A    A!x   A"Y   A#:   A$   A$   A%   A&   A'   A(   A)a   A*B   A+#   A,   A,   A-   A.   A/   A0i   A1J   A2+   A3   A3   A4   A5   A6   A7q   A8R   A93   A:   A:   A;   A<   A=   A>y   A?Z   A@;   AA   AA   AB   AC   AD   AE   AFb   AGC   AH$   AI   AI   AJ   AK   AL   AMj   ANK   AO,   AP
   AP   AQ   AR   AS   ATr   AUS   AV4   AW   AW   AX   AY   AZ   A[z   A\[   A]<   A^   A^   A_   A`   Aa   Ab   Acc   AdD   Ae%   Af   Af   Ag   Ah   Ai   Ajk   AkL   Al-   Am   Am   An   Ao   Ap   Aqs   ArT   As5   At   At   Au   Av   Aw   Ax{   Ay\   Az=   A{   A{   A|   A}   A~   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   Aƴ   AǕ   Av   AW   A8   A   A   A   Aͼ   AΝ   A~   A_   A@   A!   A   A   A   Aե   Aֆ   Ag   AH   A)   A
   A   A   Aܭ   Aݎ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A    A   Ax   AY   A:   A   A   A   A   A   A	   A
a   AB   A#   A
   A
   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   A Z   A!;   A"   A"   A#   A$   A%   A&   A'b   A(C   A)$   A*   A*   A+   A,   A-   A.j   A/K   A0,   A1
   A1   A2   A3   A4   A5r   A6S   A74   A8   A8   A9   A:   A;   A<z   A=[   A><   A?   A?   A@   AA   AB   AC   ADc   AED   AF%   AG   AG   AH   AI   AJ   AKk   ALL   AM-   AN   AN   AO   AP   AQ   ARs   AST   AT5   AU   AU   AV   AW   AX   AY{   AZ\   A[=   A\   A\   A]   A^   A_   A`   Aad   AbE   Ac&   Ad   Ad   Ae   Af   Ag   Ahl   AiM   Aj.   Ak   Ak   Al   Am   An   Aot   ApU   Aq6   Ar   Ar   As   At   Au   Av|   Aw]   Ax>   Ay   Az    Az   A{   A|   A}   A~e   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   Aĵ   AŖ   Aw   AX   A9   A   A   A   A˽   A̞   A   A`   AA   A"   A   A   A   AӦ   Aԇ   Ah   AI   A*   A   A   A   Aڮ   Aۏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   A y   AZ   A;   A   A   A   A   A   A   Ab   A	C   A
$   A   A   A   A
   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A    A    A!   A"   A#   A$   A%c   A&D   A'%   A(   A(   A)   A*   A+   A,k   A-L   A.-   A/   A/   A0   A1   A2   A3s   A4T   A55   A6   A6   A7   A8   A9   A:{   A;\   A<=   A=   A=   A>   A?   A@   AA   ABd   ACE   AD&   AE   AE   AF   AG   AH   AIl   AJM   AK.   AL   AL   AM   AN   AO   APt   AQU   AR6   AS   AS   AT   AU   AV   AW|   AX]   AY>   AZ   A[    A[   A\   A]   A^   A_e   A`F   Aa'   Ab   Ab   Ac   Ad   Ae   Afm   AgN   Ah/   Ai   Ai   Aj   Ak   Al   Amu   AnV   Ao7   Ap   Ap   Aq   Ar   As   At}   Au^   Av?   Aw    Ax   Ax   Ay   Az   A{   A|f   A}G   A~(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A¶   A×   Ax   AY   A:   A   A   A   Aɾ   Aʟ   Aˀ   Aa   AB   A#   A   A   A   Aѧ   A҈   Ai   AJ   A+   A   A   A   Aد   Aِ   Aq   AR   A3   A   A   A   A߷   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A <   A   A   A   A   A   A   Ac   AD   A%   A	   A	   A
   A   A   A
k   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A    A!   A"   A#d   A$E   A%&   A&   A&   A'   A(   A)   A*l   A+M   A,.   A-   A-   A.   A/   A0   A1t   A2U   A36   A4   A4   A5   A6   A7   A8|   A9]   A:>   A;   A<    A<   A=   A>   A?   A@e   AAF   AB'   AC   AC   AD   AE   AF   AGm   AHN   AI/   AJ   AJ   AK   AL   AM   ANu   AOV   AP7   AQ   AQ   AR   AS   AT   AU}   AV^   AW?   AX    AY   AY   AZ   A[   A\   A]f   A^G   A_(   A`	   A`   Aa   Ab   Ac   Adn   AeO   Af0   Ag   Ag   Ah   Ai   Aj   Akv   AlW   Am8   An   An   Ao   Ap   Aq   Ar~   As_   At@   Au!   Av   Av   Aw   Ax   Ay   Azg   A{H   A|)   A}
   A}   A~   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   Aǿ   AȠ   AɁ   Ab   AC   A$   A   A   A   AϨ   AЉ   Aj   AK   A,   A
   A   A   Aְ   Aב   Ar   AS   A4   A   A   A   Aݸ   Aޙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A    A   A   A   Ad   AE   A&   A   A   A   A	   A
   Al   AM   A
.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A    A!e   A"F   A#'   A$   A$   A%   A&   A'   A(m   A)N   A*/   A+   A+   A,   A-   A.   A/u   A0V   A17   A2   A2   A3   A4   A5   A6}   A7^   A8?   A9    A:   A:   A;   A<   A=   A>f   A?G   A@(   AA	   AA   AB   AC   AD   AEn   AFO   AG0   AH   AH   AI   AJ   AK   ALv   AMW   AN8   AO   AO   AP   AQ   AR   AS~   AT_   AU@   AV!   AW   AW   AX   AY   AZ   A[g   A\H   A])   A^
   A^   A_   A`   Aa   Abo   AcP   Ad1   Ae   Ae   Af   Ag   Ah   Aiw   AjX   Ak9   Al   Al   Am   An   Ao   Ap   Aq`   ArA   As"   At   At   Au   Av   Aw   Axh   AyI   Az*   A{   A{   A|   A}   A~   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aơ   Aǂ   Ac   AD   A%   A   A   A   Aͩ   AΊ   Ak   AL   A-   A   A   A   AԱ   AՒ   As   AT   A5   A   A   A   A۹   Aܚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A    A   Ae   AF   A'   A   A   A   A   A   A	m   A
N   A/   A   A   A
   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   A G   A!(   A"	   A"   A#   A$   A%   A&n   A'O   A(0   A)   A)   A*   A+   A,   A-v   A.W   A/8   A0   A0   A1   A2   A3   A4~   A5_   A6@   A7!   A8   A8   A9   A:   A;   A<g   A=H   A>)   A?
   A?   A@   AA   AB   ACo   ADP   AE1   AF   AF   AG   AH   AI   AJw   AKX   AL9   AM   AM   AN   AO   AP   AQ   AR`   ASA   AT"   AU   AU   AV   AW   AX   AYh   AZI   A[*   A\   A\   A]   A^   A_   A`p   AaQ   Ab2   Ac   Ac   Ad   Ae   Af   Agx   AhY   Ai:   Aj   Aj   Ak   Al   Am   An   Aoa   ApB   Aq#   Ar   Ar   As   At   Au   Avi   AwJ   Ax+   Ay   Ay   Az   A{   A|   A}q   A~R   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AĢ   AŃ   Ad   AE   A&   A   A   A   A˪   A̋   Al   AM   A.   A   A   A   AҲ   Aӓ   At   AU   A6   A   A   A   Aٺ   Aڛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   A f   AG   A(   A	   A   A   A   A   An   AO   A	0   A
   A
   A   A   A
   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A 
   A    A!   A"   A#   A$o   A%P   A&1   A'   A'   A(   A)   A*   A+w   A,X   A-9   A.   A.   A/   A0   A1   A2   A3`   A4A   A5"   A6   A6   A7   A8   A9   A:h   A;I   A<*   A=   A=   A>   A?   A@   AAp   ABQ   AC2   AD   AD   AE   AF   AG   AHx   AIY   AJ:   AK   AK   AL   AM   AN   AO   APa   AQB   AR#   AS   AS   AT   AU   AV   AWi   AXJ   AY+   AZ   AZ   A[   A\   A]   A^q   A_R   A`3   Aa   Aa   Ab   Ac   Ad   Aey   AfZ   Ag;   Ah   Ah   Ai   Aj   Ak   Al   Amb   AnC   Ao$   Ap   Ap   Aq   Ar   As   Atj   AuK   Av,   Aw
   Aw   Ax   Ay   Az   A{r   A|S   A}4   A~   A~   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A£   AÄ   Ae   AF   A'   A   A   A   Aɫ   Aʌ   Am   AN   A/   A   A   A   Aг   Aє   Au   AV   A7   A   A   A   A׻   A؜   A}   A^   A?   A    A   A   A   Aߤ   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A )   A
   A   A   A   A   Ao   AP   A1   A   A   A	   A
   A   Aw   A
X   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A    A!   A"p   A#Q   A$2   A%   A%   A&   A'   A(   A)x   A*Y   A+:   A,   A,   A-   A.   A/   A0   A1a   A2B   A3#   A4   A4   A5   A6   A7   A8i   A9J   A:+   A;   A;   A<   A=   A>   A?q   A@R   AA3   AB   AB   AC   AD   AE   AFy   AGZ   AH;   AI   AI   AJ   AK   AL   AM   ANb   AOC   AP$   AQ   AQ   AR   AS   AT   AUj   AVK   AW,   AX
   AX   AY   AZ   A[   A\r   A]S   A^4   A_   A_   A`   Aa   Ab   Acz   Ad[   Ae<   Af   Af   Ag   Ah   Ai   Aj   Akc   AlD   Am%   An   An   Ao   Ap   Aq   Ark   AsL   At-   Au   Au   Av   Aw   Ax   Ays   AzT   A{5   A|   A|   A}   A~   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   AǬ   Aȍ   An   AO   A0   A   A   A   Aδ   Aϕ   Av   AW   A8   A   A   A   Aռ   A֝   A~   A_   A@   A!   A   A   A   Aݥ   Aކ   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A     A    A    A p   A Q   A 2   A    A    A    A    A 	   A 
x   A Y   A :   A 
   A 
   A    A    A    A    A a   A B   A #   A    A    A    A    A    A i   A J   A +   A    A    A    A    A    A  q   A !R   A "3   A #   A #   A $   A %   A &   A 'y   A (Z   A );   A *   A *   A +   A ,   A -   A .   A /b   A 0C   A 1$   A 2   A 2   A 3   A 4   A 5   A 6j   A 7K   A 8,   A 9
   A 9   A :   A ;   A <   A =r   A >S   A ?4   A @   A @   A A   A B   A C   A Dz   A E[   A F<   A G   A G   A H   A I   A J   A K   A Lc   A MD   A N%   A O   A O   A P   A Q   A R   A Sk   A TL   A U-   A V   A V   A W   A X   A Y   A Zs   A [T   A \5   A ]   A ]   A ^   A _   A `   A a{   A b\   A c=   A d   A d   A e   A f   A g   A h   A id   A jE   A k&   A l   A l   A m   A n   A o   A pl   A qM   A r.   A s   A s   A t   A u   A v   A wt   A xU   A y6   A z   A z   A {   A |   A }   A ~|   A ]   A >   A    A     A    A    A    A    A e   A F   A '   A    A    A    A    A    A m   A N   A /   A    A    A    A    A    A u   A V   A 7   A    A    A    A    A    A }   A ^   A ?   A     A    A    A    A    A    A f   A G   A (   A 	   A    A    A    A    A n   A O   A 0   A    A    A    A    A    A v   A W   A 8   A    A    A    A    A    A ~   A _   A @   A !   A    A    A    A    A    A g   A H   A )   A 
   A    A    A ŭ   A Ǝ   A o   A P   A 1   A    A    A    A ̵   A ͖   A w   A X   A 9   A    A    A    A ӽ   A Ԟ   A    A `   A A   A "   A    A    A    A ۦ   A ܇   A h   A I   A *   A    A    A    A    A    A p   A Q   A 2   A    A    A    A    A    A x   A Y   A :   A    A    A    A    A    A    A a   A B   A #   A    A    A    A    A    A i   A J   A +   A    A    A    A    A    Aq   AR   A3   A   A   A   A   A   Ay   A	Z   A
;   A   A   A   A
   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A 4   A!   A!   A"   A#   A$   A%z   A&[   A'<   A(   A(   A)   A*   A+   A,   A-c   A.D   A/%   A0   A0   A1   A2   A3   A4k   A5L   A6-   A7   A7   A8   A9   A:   A;s   A<T   A=5   A>   A>   A?   A@   AA   AB{   AC\   AD=   AE   AE   AF   AG   AH   AI   AJd   AKE   AL&   AM   AM   AN   AO   AP   AQl   ARM   AS.   AT   AT   AU   AV   AW   AXt   AYU   AZ6   A[   A[   A\   A]   A^   A_|   A`]   Aa>   Ab   Ac    Ac   Ad   Ae   Af   Age   AhF   Ai'   Aj   Aj   Ak   Al   Am   Anm   AoN   Aq   Ar   As   At   Auu   AvV   Aw7   Ax   Ax   Ay   Az   A{   A|}   A}^   A~?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   Aî   Aď   Ap   AQ   A2   A   A   A   Aʶ   A˗   Ax   AY   A:   A   A   A   AѾ   Aҟ   AӀ   Aa   AB   A#   A   A   A   A٧   Aڈ   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   A S   A4   A   A   A   A   A   Az   A[   A<   A	   A	   A
   A   A   A
   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A    A!   A"   A#{   A$\   A%=   A&   A&   A'   A(   A)   A*   A+d   A,E   A-&   A.   A.   A/   A2l   A3M   A4.   A5   A5   A6   A7   A8   A9t   A:U   A;6   A<   A<   A=   A>   A?   A@|   AA]   AB>   AC   AD    AD   AE   AF   AG   AHe   AIF   AJ'   AK   AK   AL   AM   AN   AOm   APN   AQ/   AR   AR   AS   AT   AU   AVu   AWV   AX7   AY   AY   AZ   A[   A\   A]}   A^^   A_?   A`    Aa   Aef   Ag(   Ah   Ai   Aj   Ak   Aln   AmO   An0   Ao   Ao   Ap   Aq   Ar   Asv   AtW   Au8   Av   Av   Aw   Ax   Ay   Az~   A|@   A}!   A~   A~   A   A   A   Ag   AH   A)   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   Aɘ   AZ   A;   A   A   A   AϿ   AР   Aс   Ab   AC   A$   A   A   A   Aר   A؉   Aj   AK   A,   A
   A   A   Aް   Aߑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A    A    A   A   A   A{   A\   A=   A   A   A   A	   A
   A   Ad   A
E   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A    A!|   A"]   A#>   A$   A%    A%   A&   A'   A(   A)e   A*F   A+'   A,   A,   A-   A.   A/   A0m   A1N   A2/   A3   A3   A4   A5   A6   A7u   A8V   A97   A:   A:   A;   A<   A=   A>}   A?^   A@?   AA    AB   AB   AC   AD   AE   AFf   AGG   AH(   AI	   AI   AJ   AK   AL   AMn   ANO   AO0   AP   AP   AQ   AR   AS   ATv   AUW   AV8   AW   AW   AX   AY   AZ   A[~   A\_   A]@   A^!   A_   A_   A`   Aa   Ab   Acg   AdH   Ae)   Af
   Af   Ag   Ah   Ajo   Am   An   Aqw   ArX   As9   At   At   Au   Ax   Ay`   AzA   A{"   A|   A|   A}   A~   A   Ah   AI   A*   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   AƸ   AǙ   Az   A[   A<   A   A   A   A   AΡ   Aς   Ac   AD   A%   A   A   A   Aթ   A֊   Ak   AL   A-   A   A   A   Aܱ   Aݒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A    A   A|   A]   A>   A   A    A   A   A   A	   A
e   AF   A'   A
   A
   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A ^   A!?   A"    A#   A#   A$   A%   A&   A'f   A(G   A)(   A*	   A*   A+   A,   A-   A.n   A/O   A00   A1   A1   A2   A3   A4   A5v   A6W   A78   A8   A8   A9   A:   A;   A<~   A=_   A>@   A?!   A@   A@   AA   AB   AC   ADg   AEH   AF)   AG
   AG   AH   AI   AJ   AKo   ALP   AM1   AN   AN   AO   AP   AQ   ARw   ASX   AT9   AU   AU   AV   AW   AX   AY   AZ`   A[A   A\"   A]   A]   A^   A_   A`   Aah   AbI   Ac*   Ad   Ad   Ae   Af   Ag   Ahp   AiQ   Aj2   Ak   Ak   Aox   ApY   Aq:   Ar   Ar   As   At   Au   Av   Awa   AxB   Ay#   Az   Az   A{   A|   A}   A~i   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A5   A   A   A   AĹ   AŚ   A{   A\   A=   A   A   A   A   A̢   A̓   Ad   AE   A&   A   A   A   AӪ   Aԋ   Al   AM   A.   A   A   A   Aڲ   Aۓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   Au   AV   A7   A   A   A   A   A   A }   A^   A?   A    A   A   A   A   A   Af   A	G   A
(   A	   A   A   A
   A   An   AO   A   A   A   A   A   AW   A8   A   A   A   A   A   A~   A@   A !   A!   A!   A"   A#   A$   A%g   A&H   A')   A(
   A(   A)   A*   A+   A,o   A-P   A.1   A/   A/   A0   A1   A2   A3w   A4X   A59   A6   A6   A7   A8   A9   A:   A;`   A<A   A="   A>   A>   A?   A@   AA   ABh   ACI   AD*   AE   AE   AF   AG   AH   AIp   AJQ   AK2   AL   AL   AM   AN   AO   APx   AQY   AR:   AS   AS   AT   AU   AV   AW   AXa   AYB   AZ#   A[   A[   A\   A]   A^   A_i   A`J   Aa+   Ab   Ab   Ac   Ad   Ae   Afq   AgR   Ah3   Ai   Ai   Aj   Ak   Al   Amy   AnZ   Ao;   Ap   Ap   Aq   Ar   As   At   Aub   AvC   Aw$   Ax   Ax   Ay   Az   A{   A|j   A}K   A~,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   Aº   AÛ   A|   A]   A>   A   A    A   A   Aʣ   A˄   Ae   AF   A'   A   A   Am   AN   A/   A   A   A   Aس   Au   AV   A   A   A߻   A   A}   A^   A?   A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A @   A!   A   A   A   A   A   AH   A)   A   A   A
o   A   A   A   Aw   AX   A9   A   A   A   A   A   A`   AA   A"   A   A   A    A!   A"   A#h   A$I   A%*   A&   A&   A'   A(   A)   A*p   A+Q   A,2   A-   A-   A.   A/   A0   A1x   A2Y   A3:   A4   A4   A5   A6   A7   A8   A9a   A:B   A;#   A<   A<   A=   A>   A?   A@i   AAJ   AB+   AC   AC   AD   AE   AF   AGq   AHR   AI3   AJ   AJ   AK   AL   AM   ANy   AOZ   AP;   AQ   AQ   AR   AS   AT   AU   AVb   AWC   AX$   AY   AY   AZ   A[   A\   A]j   A^K   A_,   A`
   Aa   An   Asc   AtD   Au%   Av   Av   Aw   Ax   Azk   A{L   A|-   A}   A}   A~   A   A   As   AT   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A   A   A   A   A   AV   A   A   AɅ   Af   AG   AϬ   A9   A   A   A:   A   A.   A1;   A9$   A:   A;   A@,   AA   AB   AC   AD   AEr   AG4   AN<   AO   AO   AP   A^   A_   A`   Aa   Abs   Ak=   Ao   Ap   As&   AyM   A/   AO   A1   A   Aw   AX   A9   A   A   A   A۽   Aܞ   A   A`   AA   A"   A   A   A   A   Ah   AI   A*   A   A   A   A   A   AQ   A2   A   A   A   A   A   Ax   AY   A   A   A   A   Aa   AB   A#   A+   A   A   A   A3   A   Ac   Ak   Al   Am   A   A   A   Al   AM   A.   A   A   A   Aò   Aē   At   AU   A6   A   A   A   Aʺ   A˛   A|   A]   A>   A   A    A   A   Aң   Aӄ   Ae   AF   A'   A   A   A   A٫   Aڌ   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   Af   A(   A	   A   A   A   A   An   AO   A0   A   A   A   Av   A
 W   A
8   A
   A
   A
   A
   A
   A
_   A
@   A
	!   A
   A
   A
   A
   A

   A
g   A
H   A
)   A

   A
   A
   A
   A
   A
o   A
P   A
1   A
   A
   A
   A
   A
   A
w   A
X   A
9   A
   A
   A
    A
!   A
"   A
#   A
$`   A
%A   A
&"   A
'   A
'   A
(   A
)   A
*   A
+h   A
,I   A
-*   A
.   A
.   A
/   A
0   A
1   A
2p   A
3Q   A
42   A
5   A
5   A
6   A
7   A
8   A
9x   A
:Y   A
;:   A
<   A
<   A
=   A
>   A
?   A
@   A
Aa   A
BB   A
C#   A
D   A
E   A
F   A
G   A
Hi   A
IJ   A
J+   A
K   A
K   A
L   A
N   A
Oq   A
R   A
S   A
T   A
WZ   A
X;   A
Y   A
Y   A
Z   A
[   A
\   A
]   A
^b   A
_C   A
`$   A
a   A
a   A
b   A
c   A
d   A
ej   A
fK   A
g,   A
h
   A
h   A
i   A
j   A
k   A
lr   A
mS   A
n4   A
o   A
o   A
p   A
q   A
r   A
sz   A
t[   A
u<   A
v   A
v   A
w   A
x   A
y   A
z   A
{c   A
|D   A
}%   A
~   A
~   A
   A
   A
   A
k   A
L   A
-   A
   A
   A
   A
   A
   A
s   A
T   A
5   A
   A
   A
   A
   A
   A
{   A
\   A
=   A
   A
   A
   A
   A
   A
   A
d   A
E   A
&   A
   A
   A
   A
   A
   A
l   A
M   A
.   A
   A
   A
   A
t   A
U   A
6   A
   A
   A
   A
|   A
]   A
>   A
   A
   A
   A
   A
   A
e   A
F   A
'   A
   A
   A
   A
   A
m   A
N   A
/   A
   A
   A
   A
   A
   A
u   A
V   A
7   A
   A
   A
   A
Ȼ   A
ɜ   A
}   A
^   A
?   A
    A
   A
   A
   A
Ф   A
х   A
f   A
G   A
(   A
	   A
   A
   A
׬   A
؍   A
n   A
O   A
0   A
   A
   A
   A
޴   A
ߕ   A
v   A
W   A
8   A
   A
   A
   A
   A
   A
~   A
_   A
@   A
!   A
   A
   A
   A
   A
   A
g   A
H   A
   A
   A
   A
   A
   A
o   A
P   A
1   A
   A
   A
X   A    A    A   A   A   A   A	   A
   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A    A!   A"a   A#B   A$#   A%   A%   A&   A'   A(   A)i   A*J   A++   A,   A,   A-   A.   A/   A0q   A1R   A23   A3   A3   A4   A5   A6   A7y   A8Z   A9;   A:   A:   A;   A<   A=   A>   A?b   A@C   AA$   AB   AB   AC   AD   AFj   AGK   AH,   AI
   AI   AJ   AK   AL   AMr   ANS   AO4   AP   AP   AQ   AR   AS   ATz   AU[   AV<   AW   AW   AX   AY   AdL   Ae-   Af   Af   Ag   Ah   Ai   Ajs   AkT   Al5   Am   Am   An   Ao   Ap   Aq{   Ar\   As=   At   At   Au   Av   Aw   Ax   Ayd   AzE   A{&   A|   A|   A}   A~   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   Au   AV   A7   A   A   A	   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   AƼ   Aǝ   A~   A_   A@   A!   A   A   A   AΥ   Aφ   Ag   AH   A)   A
   A   A   Aխ   A֎   Ao   AP   A1   A   A   A   Aܵ   Aݖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   Ap   AQ   A2   A   A   A   Ax   AY   A:   A   A   A   A    A   A   AJ   A+   A
   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   A b   A!C   A"$   A#   A#   A$   A%   A&   A'j   A(K   A),   A*
   A*   A+   A,   A-   A.r   A/S   A04   A1   A1   A2   A3   A4   A5z   A6[   A7<   A8   A8   A9   A:   A;   A<   A=c   A>D   A?%   A@   A@   AA   AB   AC   AEL   AF-   AG   AG   AI   AKs   ALT   AO   AP   AQ   AV   AW   AX   AZd   A[E   A\&   A]   A]   A^   A_   A`   Aal   AbM   Ac.   Ad   Ad   Ae   Af   Ag   Aht   AiU   Aj6   Ak   Ak   Al   Am   An   Ao|   Ap]   Aq>   Ar   As    As   At   Au   Av   Awe   AxF   Ay'   Az   Az   A{   A|   A}   A~m   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   AĽ   AŞ   A   A`   AA   A"   A   A   A   A̦   A͇   Ah   AI   A*   A   A   A   AӮ   Aԏ   Ap   AQ   A2   A   A   A   Aڶ   Aۗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A    Ab   AC   A$   A   A   A   A   A   Aj   A	K   A
,   A
   A   A   A
   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A %   A!   A!   A"   A#   A$   A%k   A&L   A'-   A(   A(   A)   A*   A+   A,s   A-T   A.5   A/   A/   A0   A1   A2   A3{   A4\   A5=   A6   A6   A7   A8   A9   A:   A;d   A<E   A=&   A>   A>   A?   A@   AA   ABl   ACM   AD.   AE   AE   AF   AG   AH   AIt   AJU   AK6   AL   AL   AM   AN   AO   AP|   AQ]   AR>   AS   AT    AT   AU   AV   AW   AXe   AYF   AZ'   A[   A[   A\   A]   A^   A_m   A`N   Aa/   Ab   Ab   Ac   Ad   Ae   Afu   AgV   Ah7   Ai   Ai   Aj   Ak   Al   Am}   An^   Ao?   Ap    Aq   Aq   Ar   As   At   Auf   AvG   Aw(   Ax	   Ax   Ay   Az   A{   A|n   A}O   A~0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A¾   Aß   AĀ   Aa   AB   A#   A   A   A   Aʧ   Aˈ   Ai   AJ   A+   A   A   A   Aѯ   AҐ   Aq   AR   A3   A   A   A   Aط   A٘   Ay   AZ   A;   A   A   A   A߿   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   A4   A   A   Az   A[   A<   A   A   Ac   A D   A   A   A   A   A   Ak   AL   A-   A	   A	   A
   A   A   A
s   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A    A!   A"   A#l   A$M   A%.   A&   A&   A'   A(   A)   A*t   A+U   A,6   A-   A-   A.   A/   A0   A1|   A2]   A3>   A4   A5    A5   A6   A7   A8   A9e   A:F   A;'   A<   A<   A=   A>   A?   A@m   AAN   AB/   AC   AJ   AK   AL   AP?   AS   AT   AWG   AX(   AY	   AY   AZ   A[   A\   A]n   A^O   A_0   A`   A`   Aa   Ab   Ac   Adv   AeW   Af8   Ag   Ag   Ah   Ai   Aj   Ak~   Al_   Am@   An!   Ao   Ao   Ap   Aq   Ar   Asg   AtH   Au)   Av
   Av   Aw   Ax   Ay   Azo   A{P   A|1   A}   A}   A~   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   Ah   AI   A*   A   A   A   A   A   A2   A   A   Ax   AY   A:   A   A   A   A   A   Aa   AB   A   A   Ai   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A   A   A   A   A   A   Ab   AC   A$   A   A   A   AȨ   Aɉ   Aj   AK   A,   A
   A   A   Aϰ   AБ   Ar   AS   A4   A   A   A   Aָ   Aי   Az   A[   A<   A   A   A   A   Aޡ   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   AT   A   A   A   A{   A\   A=   A   A   A   A   A   Ad   AE   A&   A    A    A   A   A   Al   AM   A.   A   A   A   A	   A
   At   AU   A
6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A    A!m   A"N   A#/   A$   A$   A%   A&   A'   A(u   A)V   A*7   A+   A+   A,   A-   A.   A/}   A0^   A1?   A2    A3   A3   A:   A<   A=   A?O   A@0   AH   AJ   AM_   AO!   AP   AR   AS   AUH   AV)   AW
   AW   AX   AY   AZ   A[o   A\P   A]1   A^   A^   A_   A`   Aa   Abw   AcX   Ad9   Ae   Ae   Af   Ag   Ah   Ai   Aj`   AkA   Al"   Am   Am   An   Ao   Ap   Aqh   ArI   As*   At   At   Au   Av   Aw   Axp   AyQ   Az2   A{   A{   A|   A}   A~   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A    Ay   AZ   A;   A   A   A   A   A   A   A	b   A
C   A$   A   A   A
   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A <   A!   A!   A"   A#   A$   A%   A&c   A'D   A(%   A)   A)   A*   A+   A,   A-k   A.L   A/-   A0   A0   A1   A2   A3   A4s   A5T   A65   A8   A9   A:   A==   A>   A>   A?   ADE   AE&   AF   AG   AH   AI   AJl   AKM   AL.   AM   AM   AN   AO   AP   AQt   ARU   AS6   AT   AT   AU   AV   AW   AX|   AY]   AZ>   A[   A\    A\   A]   A^   A_   A`e   AaF   Ab'   Ac   Ac   Ad   Ae   Af   Agm   AhN   Ai/   Aj   Aj   Ak   Al   Am   Anu   AoV   Ap7   Aq   Aq   Ar   As   At   Au}   Av^   Aw?   Ax    Ay   Ay   Az   A{   A~G   A(   A   A   A   A   A   A   A   AW   A8   A   A   A   A   A   A~   A_   A!   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   Aö   Aė   Ax   AY   A:   A   A   A   Aʾ   A˟   A̀   Aa   AB   A#   A   A   A   Aӈ   AJ   A+   A   A   A   A   A   A   A   A$   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A [   A<   A   A   A   A   A   A   Ac   AD   A	%   A
   A
   A   A   A
   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A    A!   A"   A#   A$d   A%E   A&&   A'   A'   A(   A)   A*   A+l   A,M   A.   A.   A/   A0   A5   A6   A7   A8   A;>   A=    A=   A>   A?   A@   AAe   ABF   AD   AD   AG   AHm   AIN   AJ/   AK   AK   AL   AM   AN   AOu   APV   AQ7   AR   AR   AS   AT   AU   AV}   AW^   AX?   AY    AZ   AZ   A[   A\   A]   A^f   A_G   A`(   Aa	   Aa   Ab   Ac   Ad   Aen   AfO   Ag0   Ah   Ah   Ai   Aj   Ak   Alv   AmW   An8   Ao   Ao   Ap   Aq   Ar   As~   At_   Au@   Av!   Aw   Aw   Ax   Ay   Az   A{g   A|H   A})   A~
   A~   A   A   AP   A   A   A   A   Aw   AX   A   A   A   A   A   A   A`   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   Aȿ   Aɠ   Aʁ   Ab   AC   A$   A   A   A   AШ   Aщ   Aj   A,   A   A4   A   A   A   A[   A<   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A    A    A   A   A   A   Ad   AE   A&   A   A   A	   A
   A   Al   A
M   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A    A!   A"e   A#F   A$'   A%   A%   A&   A'   A(   A)m   A*N   A-   A.   A/   A0u   A27   A3   A4   A5   A6   A7}   A9?   A:    A;   A>   A?f   AB	   AB   AC   AE   AFn   AGO   AH0   AI   AI   AJ   AK   AL   AMv   ANW   AO8   AP   AP   AQ   AR   AS   AT~   AU_   AV@   AW!   AX   AX   AY   AZ   A[   A\g   A]H   A^)   A_
   A_   A`   Aa   Ab   Aco   AdP   Ae1   Af   Af   Ag   Ah   Ai   Ajw   AkX   Al9   Am   Am   An   Ao   Ap   Aq   Ar`   AsA   At"   Au   Av   Aw   Ax   Ayh   AzI   A{*   A|   A}   A~   A   Ap   AQ   A2   A   A   A   A   A   A   A   Ai   A+   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aǡ   AȂ   Ac   AD   A%   A   A   A   AΩ   Aϊ   Ak   A   A   Aձ   A֒   As   AT   A   A   A\   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A    A   A   Ae   AF   A'   A   A   A   A   A	   A
m   AN   A/   A
   A
   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   A f   A!G   A"(   A#	   A#   A$   A%   A)0   A.v   A/W   A08   A2   A3   A4   A5~   A6_   A7@   A8!   A9   A9   A:   A;   A<   A=g   A>H   A?)   A@
   A@   AA   AB   AC   ADo   AEP   AF1   AG   AG   AH   AI   AJ   AKw   ALX   AM9   AN   AN   AO   AP   AQ   AR   AS`   ATA   AU"   AV   AV   AW   AX   AY   AZh   A[I   A\*   A]   A]   A^   A_   A`   Aap   AbQ   Ac2   Ad   Ad   Ae   Af   Ag   Ahx   AiY   Aj:   Ak   Ak   Al   Am   An   Ao   Apa   AqB   Ar#   As   As   At   Au   Av   Awi   Ay+   Az   A{   A}   A   A   AZ   A;   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AŢ   Aƃ   Ad   AE   A&   A   A   A   A̪   A͋   Al   AM   A.   A   A   A   AӲ   Aԓ   At   AU   A   Aۛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A    Af   AG   A(   A	   A   A   A   A   An   A	O   A
0   A   A   A   A
   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A )   A!
   A!   A"   A#   A$   A%o   A&P   A'1   A(   A)   A-X   A.9   A/   A/   A0   A1   A2   A3   A4`   A5A   A6"   A7   A7   A8   A9   A:   A;h   A<I   A=*   A>   A>   A?   A@   AA   ABp   ACQ   AD2   AE   AE   AF   AG   AH   AIx   AJY   AK:   AL   AL   AM   AN   AO   AP   AQa   ARB   AS#   AT   AT   AU   AV   AW   AXi   AYJ   AZ+   A[   A[   A\   A]   A^   A_q   A`R   Aa3   Ab   Ab   Ac   Ad   Ae   Afy   AgZ   Ah;   Ai   Ai   Aj   Ak   Al   Am   Anb   AoC   Ap$   Aq   Aq   Ar   As   At   Auj   AvK   Aw,   Ax
   Ax   Ay   Az   A{   A|r   A}S   A~4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aã   AĄ   Ae   AF   A'   A   A   A   Aʫ   Aˌ   Am   AN   Aػ   Aٜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   A H   A)   A
   A   A   A   A   Ao   AP   A1   A	   A	   A
   A   A   A
w   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   A    A"   A#p   A-   A.   A/   A0   A1   A2a   A3B   A4#   A5   A5   A6   A7   A8   A9i   A:J   A;+   A<   A<   A=   A>   A?   A@q   AAR   AB3   AC   AC   AD   AE   AF   AGy   AHZ   AI;   AJ   AJ   AK   AL   AM   AN   AOb   APC   AQ$   AR   AR   AS   AT   AU   AVj   AWK   AX,   AY
   AY   AZ   A[   A\   A]r   A^S   A_4   A`   A`   Aa   Ab   Ac   Adz   Ae[   Af<   Ag   Ag   Ah   Ai   Aj   Ak   Alc   AmD   An%   Ao   Ar   Aw   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   An   AO   A0   A   A!   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A    A    A   A   A   Ap   AQ   A2   A   A   A   A	   A
   Ax   AY   A
:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   Ai   A+   A   A"R   A$   A&   A'   A+   A+   A,   A.   A/   A0b   A1C   A2$   A3   A3   A4   A5   A6   A7j   A8K   A9,   A:
   A:   A;   A<   A=   A>r   A?S   A@4   AA   AA   AB   AC   AD   AEz   AF[   AG<   AH   AH   AI   AJ   AK   AL   AMc   AND   AO%   AP   AP   AQ   AR   AS   ATk   AUL   AV-   AW   AW   AX   AY   AZ   A[s   A\T   A]5   A^   A^   A_   A`   Aa   Ab{   Ac\   Ad=   Ae   Ae   Af   Ag   Ah   Ai   Ajd   Am   An   Ao   Ap   Aql   At   Au   Axt   A|   A]   A   A   A   Ae   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   Aƭ   Aǎ   Ao   AP   A1   A   A   AX   A   AԽ   A   A`   AA   A"   A   A   A   Aܦ   A݇   Ah   AI   A*   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A    A   Aq   AR   A3   A   A   A   A   A	y   A;   A   A   A
   A   A   A   Ab   AC   A$   A   A   A,   A   A#   A$   A%   A&z   A(<   A)   A)   A*   A+   A,   A-   A.c   A/D   A0%   A1   A2   A4   A6L   A7-   A8   A9   A:   A;   A=T   A>5   A?   A@   AA   AB   AC{   AD\   AE=   AF   AF   AG   AH   AI   AJ   AKd   ALE   AM&   AN   AN   AO   AP   AQ   ARl   ASM   AT.   AU   AU   AV   AX   AYt   AZU   A[6   A\   A\   A]   A^   A_   A`|   Aa]   Ab>   Ac   Ad    Ad   Ae   Af   Ag   Ahe   AiF   Aj'   Ak   Ak   Al   Am   An   Aom   ApN   Aq/   Ar   Ay   Ay   Az   A{   A|   A    A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A!   A   A   A   A   A   Ag   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A   A   A   A˶   A̗   A   Aӟ   AԀ   Aa   Aۈ   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   A r   AS   A4   A   A   A   A   A   Az   A[   A	<   A
   A
   A   A   A
   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   A*   A.&   A/   A/   A0   A1   A2   A3l   A4M   A5.   A6   A6   A7   A8   A9   A:t   A;U   A<6   A=   A=   A>   A?   A@   AA|   AB]   AC>   AD   AE    AE   AF   AG   AH   AIe   AJF   AK'   AL   AL   AM   AN   AO   APm   AQN   AR/   AS   AS   AT   AU   AV   AWu   AXV   AY7   AZ   AZ   A[   A\   A]   A^}   A_^   A`?   Aa    Ab   Ab   Ac   Ad   Ae   Aff   AgG   Ah(   Ai	   Ai   Aj   Ak   Al   AnO   Ao0   Ap   Aq   As   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A¯   AÐ   Aq   AR   A3   A   A   A   Aɷ   Aʘ   A;   A   A   A   Aп   AѠ   Aҁ   Ab   AC   A$   A   A   A   Aب   Aى   Aj   AK   A,   A
   A   A   A߰   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A  5   A    A    A    A    A    A {   A \   A =   A    A    A 	   A 
   A    A    A 
d   A E   A &   A    A    A    A    A    A    A t   A 6   A    A    A "|   A %   A &    A &   A '   A (   A )   A *e   A +F   A ,'   A -   A -   A .   A /   A 0   A 1m   A 2N   A 3/   A 4   A 4   A 5   A 6   A 7   A 8u   A 9V   A :7   A ;   A ;   A <   A =   A >   A ?}   A @^   A A?   A B    A C   A C   A D   A E   A F   A Gf   A HG   A I(   A J	   A J   A K   A L   A M   A Nn   A OO   A P0   A Q   A Q   A R   A S   A T   A Uv   A VW   A W8   A X   A X   A Y   A Z   A [   A \~   A ]_   A ^@   A _!   A `   A `   A a   A b   A c   A dg   A eH   A f)   A g
   A g   A h   A i   A j   A ko   A lP   A m1   A n   A v   A z`   A {A   A }   A }   A ~   A    A h   A I   A *   A    A    A    A    A p   A Q   A 2   A    A    A    A    A    A x   A Y   A :   A    A    A    A    A    A    A a   A B   A #   A    A    A    A    A    A i   A J   A +   A    A    A    A    A    A q   A R   A 3   A    A    A    A    A    A y   A Z   A ;   A    A    A    A    A    A    A b   A C   A $   A    A ,   A S   A 4   A    A z   A    A ϡ   A Ђ   A c   A D   A %   A    A    A    A ֩   A ׊   A k   A L   A -   A    A    A    A ݱ   A ޒ   A s   A T   A 5   A    A    A    A    A    A {   A \   A =   A    A    A    A    A    A    A d   A E   A &   A    A    A    A    A    A l   A M   A .   A    A    A    A    A    A t   A U   A 6   A    A    A!    A!   A!   A!|   A!]   A!>   A!   A!    A!   A!   A!	   A!
   A!e   A!F   A!
'   A!   A!   A!   A!   A!   A!m   A!   A!   A!   A!   A!   A! }   A!!^   A!"?   A!#    A!$   A!$   A!%   A!&   A!'   A!(f   A!*(   A!+	   A!+   A!,   A!-   A!.   A!/n   A!0O   A!10   A!2   A!2   A!3   A!4   A!5   A!6v   A!7W   A!88   A!9   A!9   A!:   A!;   A!<   A!=~   A!>_   A!?@   A!@!   A!A   A!A   A!B   A!C   A!D   A!Eg   A!FH   A!G)   A!H
   A!H   A!I   A!J   A!K   A!Lo   A!MP   A!N1   A!O   A!O   A!P   A!Q   A!R   A!Sw   A!TX   A!U9   A!V   A!V   A!W   A!X   A!Y   A!Z   A![`   A!\A   A!]"   A!^   A!^   A!_   A!`   A!a   A!bh   A!cI   A!d*   A!e   A!e   A!f   A!g   A!h   A!ip   A!jQ   A!k2   A!l   A!l   A!o   A!u   A!w   A!xa   A!yB   A!z#   A!{   A!{   A!|   A!}   A!~   A!i   A!J   A!+   A!   A!   A!   A!   A!   A!q   A!R   A!3   A!   A!   A!   A!   A!   A!y   A!Z   A!;   A!   A!   A!   A!   A!   A!   A!b   A!C   A!$   A!   A!   A!   A!   A!   A!j   A!K   A!,   A!
   A!   A!   A!   A!   A!r   A!S   A!4   A!   A!   A!   A!   A!   A!z   A![   A!<   A!   A!   A!   A!   A!   A!   A!c   A!D   A!%   A!   A!   A!   A!   A!   A!k   A!L   A!-   A!   A!   A!   A!   A!   A!s   A!T   A!5   A!   A!   A!   A!Ź   A!ƚ   A!{   A!\   A!=   A!   A!   A!   A!   A!͢   A!΃   A!d   A!E   A!&   A!   A!   A!   A!Ԫ   A!Ջ   A!l   A!M   A!.   A!   A!   A!   A!۲   A!ܓ   A!t   A!U   A!6   A!   A!   A!   A!   A!   A!|   A!]   A!>   A!   A!    A!   A!   A!   A!   A!e   A!F   A!'   A!   A!   A!   A!   A!   A!m   A!N   A!/   A!   A!   A!   A!   A!   A!u   A!V   A!7   A!   A!   A!   A!   A"    A"}   A"^   A"?   A"    A"   A"   A"   A"   A"   A"	f   A"
G   A"(   A"	   A"   A"
   A"   A"   A"n   A"O   A"0   A"   A"   A"   A"   A"   A"v   A"W   A"8   A"   A"   A"   A"~   A"_   A" @   A"!!   A""   A""   A"#   A"$   A"%   A"&g   A"'H   A"()   A")
   A")   A"*   A"+   A",   A"-o   A".P   A"/1   A"0   A"0   A"1   A"2   A"3   A"4w   A"5X   A"69   A"7   A"7   A"8   A"9   A":   A";   A"<`   A"=A   A">"   A"?   A"?   A"@   A"A   A"B   A"Ch   A"DI   A"E*   A"F   A"F   A"G   A"H   A"I   A"Jp   A"KQ   A"L2   A"M   A"M   A"N   A"O   A"P   A"Qx   A"RY   A"S:   A"T   A"T   A"U   A"V   A"W   A"X   A"Ya   A"ZB   A"[#   A"\   A"\   A"]   A"^   A"_   A"`i   A"aJ   A"b+   A"c   A"c   A"d   A"f   A"gq   A"i3   A"j   A"m   A"ny   A"oZ   A"q   A"r   A"t   A"vb   A"y   A"y   A"z   A"{   A"|   A"}j   A"~K   A",   A"
   A"   A"   A"   A"   A"r   A"S   A"4   A"   A"   A"   A"   A"   A"k   A"L   A"-   A"   A"   A"   A"   A"s   A"   A"   A"   A"   A"d   A"E   A"&   A"   A"   A"   A"   A"   A"l   A"M   A".   A"   A"   A"   A"t   A"U   A"   A"ú   A"ě   A"|   A"]   A">   A"    A"   A"   A"ˣ   A"̄   A"e   A"F   A"'   A"   A"   A"   A"ҫ   A"ӌ   A"m   A"N   A"/   A"   A"   A"   A"ڔ   A"u   A"V   A"7   A"   A"   A"}   A"^   A"?   A"    A"   A"   A"n   A"v   A"   A#@   A#!   A#   A#   A#   A#   A#   A#g   A#H   A#	)   A#

   A#
   A#   A#   A#
   A#o   A#   A#w   A#X   A#   A#   A#A   A#    A#    A#!   A#"   A##   A#$h   A#%I   A#&*   A#'   A#(   A#)   A#*   A#+p   A#,Q   A#-2   A#.   A#.   A#/   A#0   A#1   A#2x   A#5   A#\   A#]   A#^j   A#_K   A#`,   A#a
   A#a   A#b   A#c   A#er   A#g4   A#j   A#k   A#lz   A#m[   A#o   A#p   A#tc   A#v%   A#w   A#x   A#y   A#z   A#{k   A#|L   A#}-   A#~   A#~   A#   A#   A#   A#s   A#T   A#5   A#   A#   A#   A#   A#   A#   A#   A#ɤ   A#   A#Ь   A#э   A#n   A#O   A#0   A#   A#   A#   A#״   A#ؕ   A#v   A#W   A#8   A#   A#   A#   A#޼   A#ߝ   A#~   A#_   A$   A$   A$   A$h   A$I   A$*   A$   A$j{   A$sE   A$t&   A$x   A$yl   A$zM   A${.   A$|   A$|   A$}   A$~   A$   A$t   A$U   A$6   A$   A$   A$   A$|   A$]   A$   A$    A$   A$   A$   A$e   A$F   A$'   A$   A$   A$   A$   A$   A$m   A$N   A$   A$   A$u   A$V   A$7   A$   A$   A$   A$   A$   A$}   A$^   A$?   A$    A$   A$   A$   A$(   A$   A$W   A$έ   A$ώ   A$o   A$P   A$1   A$   A$   A$յ   A$X   A$9   A$   A$   A$   A$ܽ   A$ݞ   A$   A$`   A$A   A$"   A$   A$   A$   A$   A$   A$   A$   A$   A$B   A$#   A%    A%   A%   A%i   A'd   A'E   A'&   A'   A'   A'   A'   A'   A'l   A'M   A'.   A'   A'   A'    A'!   A'"   A'#t   A'$U   A'%6   A'&   A'&   A''   A'(   A')   A'*|   A'+]   A',>   A'-   A'.    A'.   A'/   A'0   A'1   A'2e   A'3F   A'4'   A'5   A'5   A'6   A'7   A'8   A'9m   A':N   A';/   A'<   A'<   A'=   A'>   A'?   A'@u   A'AV   A'B7   A'C   A'C   A'D   A'E   A'F   A'G}   A'H^   A'I?   A'J    A'K   A'K   A'L   A'M   A'N   A'Of   A'PG   A'Q(   A'R	   A'R   A'S   A'T   A'U   A'Vn   A'WO   A'X0   A'Y   A'Y   A'Z   A'[   A'\   A']v   A'^W   A'_8   A'`   A'`   A'a   A'b   A'c   A'd~   A'e_   A'f@   A'g!   A'h   A'h   A'i   A'j   A'k   A'lg   A'mH   A'n)   A'o
   A'o   A'p   A'q   A'r   A'so   A'tP   A'u1   A'v   A'v   A'w   A'x   A'y   A'zw   A'{X   A'|9   A'}   A'}   A'~   A'   A'   A'   A'`   A'A   A'"   A'   A'   A'   A'   A'   A'h   A'I   A'*   A'   A'   A'   A'   A'   A'p   A'Q   A'2   A'   A'   A'   A'   A'   A'x   A'Y   A':   A'   A'   A'   A'   A'   A'   A'a   A'B   A'#   A'   A'   A'   A'   A'   A'i   A'J   A'+   A'   A'   A'   A'   A'   A'q   A'R   A'3   A'   A'   A'   A'   A'   A'y   A'Z   A';   A'   A'   A'   A'   A'   A'   A'b   A'C   A'$   A'   A'   A'   A'   A'   A'j   A'K   A',   A'
   A'   A'   A'Ȱ   A'ɑ   A'r   A'S   A'4   A'   A'   A'   A'ϸ   A'Й   A'z   A'[   A'<   A'   A'   A'   A'   A'ס   A'؂   A'c   A'D   A'%   A'   A'   A'   A'ީ   A'ߊ   A'k   A'L   A'-   A'   A'   A'   A'   A'   A's   A'T   A'5   A'   A'   A'   A'   A'   A'{   A'\   A'=   A'   A'   A'   A'   A'   A'   A'd   A'E   A'&   A'   A'   A'   A'   A'   A'l   A'M   A'.   A(    A(    A(   A(   A(   A(t   A(U   A(6   A(   A(   A(   A(	   A(
   A(|   A(]   A(
>   A(   A(    A(   A(   A(   A(   A(e   A(F   A('   A(   A(   A(   A(   A(   A(m   A(N   A(/   A(   A(   A(   A(   A(    A(!u   A("V   A(#7   A($   A($   A(%   A(&   A('   A((}   A()^   A(*?   A(+    A(,   A(,   A(-   A(.   A(/   A(0f   A(1G   A(2(   A(3	   A(3   A(4   A(5   A(6   A(7n   A(8O   A(90   A(:   A(:   A(;   A(<   A(=   A(>v   A(?W   A(@8   A(A   A(A   A(B   A(C   A(D   A(E~   A(F_   A(G@   A(H!   A(I   A(I   A(J   A(K   A(L   A(Mg   A(NH   A(O)   A(P
   A(P   A(Q   A(R   A(S   A(To   A(UP   A(V1   A(W   A(W   A(X   A(Y   A(Z   A([w   A(\X   A(]9   A(^   A(^   A(_   A(`   A(a   A(b   A(c`   A(dA   A(e"   A(f   A(f   A(g   A(h   A(i   A(jh   A(kI   A(l*   A(m   A(m   A(n   A(o   A(p   A(qp   A(rQ   A(s2   A(t   A(t   A(u   A(v   A(w   A(xx   A(yY   A(z:   A({   A({   A(|   A(}   A(~   A(   A(a   A(B   A(#   A(   A(   A(   A(   A(   A(i   A(J   A(+   A(   A(   A(   A(   A(   A(q   A(R   A(3   A(   A(   A(   A(   A(   A(y   A(Z   A(;   A(   A(   A(   A(   A(   A(   A(b   A(C   A($   A(   A(   A(   A(   A(   A(j   A(K   A(,   A(
   A(   A(   A(   A(   A(r   A(S   A(4   A(   A(   A(   A(   A(   A(z   A([   A(<   A(   A(   A(   A(   A(   A(   A(c   A(D   A(%   A(   A(   A(   A(   A(   A(k   A(L   A(-   A(   A(   A(   A(Ʊ   A(ǒ   A(s   A(T   A(5   A(   A(   A(   A(͹   A(Κ   A({   A(\   A(=   A(   A(   A(   A(   A(բ   A(փ   A(d   A(E   A(&   A(   A(   A(   A(ܪ   A(݋   A(l   A(M   A(.   A(   A(   A(   A(   A(   A(t   A(U   A(6   A(   A(   A(   A(   A(   A(|   A(]   A(>   A(   A(    A(   A(   A(   A(   A(e   A(F   A('   A(   A(   A(   A(   A(   A(m   A(N   A(/   A(   A(   A(   A)    A)   A)u   A)V   A)7   A)   A)   A)   A)   A)   A)	}   A)
^   A)?   A)    A)
   A)
   A)   A)   A)   A)f   A)G   A)(   A)	   A)   A)   A)   A)   A)n   A)O   A)0   A)   A)   A)   A)   A)   A)v   A) W   A)!8   A)"   A)"   A)#   A)$   A)%   A)&~   A)'_   A)(@   A))!   A)*   A)*   A)+   A),   A)-   A).g   A)/H   A)0)   A)1
   A)1   A)2   A)3   A)4   A)5o   A)6P   A)71   A)8   A)8   A)9   A):   A);   A)<w   A)=X   A)>9   A)?   A)?   A)@   A)A   A)B   A)C   A)D`   A)EA   A)F"   A)G   A)G   A)H   A)I   A)J   A)Kh   A)LI   A)M*   A)N   A)N   A)O   A)P   A)Q   A)Rp   A)SQ   A)T2   A)U   A)U   A)V   A)W   A)X   A)Yx   A)ZY   A)[:   A)\   A)\   A)]   A)^   A)_   A)`   A)aa   A)bB   A)c#   A)d   A)d   A)e   A)f   A)g   A)hi   A)iJ   A)j+   A)k   A)k   A)l   A)m   A)n   A)oq   A)pR   A)q3   A)r   A)r   A)s   A)t   A)u   A)vy   A)wZ   A)x;   A)y   A)y   A)z   A){   A)|   A)}   A)~b   A)C   A)$   A)   A)   A)   A)   A)   A)j   A)K   A),   A)
   A)   A)   A)   A)   A)r   A)S   A)4   A)   A)   A)   A)   A)   A)z   A)[   A)<   A)   A)   A)   A)   A)   A)   A)c   A)D   A)%   A)   A)   A)   A)   A)   A)k   A)L   A)-   A)   A)   A)   A)   A)   A)s   A)T   A)5   A)   A)   A)   A)   A)   A){   A)\   A)=   A)   A)   A)   A)   A)   A)   A)d   A)E   A)&   A)   A)   A)   A)   A)   A)l   A)M   A).   A)   A)   A)   A)Ĳ   A)œ   A)t   A)U   A)6   A)   A)   A)   A)˺   A)̛   A)|   A)]   A)>   A)   A)    A)   A)   A)ӣ   A)Ԅ   A)e   A)F   A)'   A)   A)   A)   A)ګ   A)ی   A)m   A)N   A)/   A)   A)   A)   A)   A)   A)u   A)V   A)7   A)   A)   A)   A)   A)   A)}   A)^   A)?   A)    A)   A)   A)   A)   A)   A)f   A)G   A)(   A)	   A)   A)   A)   A)   A)n   A)O   A)0   A)   A)   A)   A)   A)   A* v   A*W   A*8   A*   A*   A*   A*   A*   A*~   A*_   A*	@   A*
!   A*   A*   A*   A*
   A*   A*g   A*H   A*)   A*
   A*   A*   A*   A*   A*o   A*P   A*1   A*   A*   A*   A*   A*   A*w   A*X   A*9   A*    A*    A*!   A*"   A*#   A*$   A*%`   A*&A   A*'"   A*(   A*(   A*)   A**   A*+   A*,h   A*-I   A*.*   A*/   A*/   A*0   A*1   A*2   A*3p   A*4Q   A*52   A*6   A*6   A*7   A*8   A*9   A*:x   A*;Y   A*<:   A*=   A*=   A*>   A*?   A*@   A*A   A*Ba   A*CB   A*D#   A*E   A*E   A*F   A*G   A*H   A*Ii   A*JJ   A*K+   A*L   A*L   A*M   A*N   A*O   A*Pq   A*QR   A*R3   A*S   A*S   A*T   A*U   A*V   A*Wy   A*XZ   A*Y;   A*Z   A*Z   A*[   A*\   A*]   A*^   A*_b   A*`C   A*a$   A*b   A*b   A*c   A*d   A*e   A*fj   A*gK   A*h,   A*i
   A*i   A*j   A*k   A*l   A*mr   A*nS   A*o4   A*p   A*p   A*q   A*r   A*s   A*tz   A*u[   A*v<   A*w   A*w   A*x   A*y   A*z   A*{   A*|c   A*}D   A*~%   A*   A*   A*   A*   A*   A*k   A*L   A*-   A*   A*   A*   A*   A*   A*s   A*T   A*5   A*   A*   A*   A*   A*   A*{   A*\   A*=   A*   A*   A*   A*   A*   A*   A*d   A*E   A*&   A*   A*   A*   A*   A*   A*l   A*M   A*.   A*   A*   A*   A*   A*   A*t   A*U   A*6   A*   A*   A*   A*   A*   A*|   A*]   A*>   A*   A*    A*   A*   A*   A*   A*e   A*F   A*'   A*   A*   A*   A*   A*   A*m   A*N   A*/   A*   A*   A*   A*³   A*Ô   A*u   A*V   A*7   A*   A*   A*   A*ɻ   A*ʜ   A*}   A*^   A*?   A*    A*   A*   A*   A*Ѥ   A*҅   A*f   A*G   A*(   A*	   A*   A*   A*ج   A*ٍ   A*n   A*O   A*0   A*   A*   A*   A*ߴ   A*   A*v   A*W   A*8   A*   A*   A*   A*   A*   A*~   A*_   A*@   A*!   A*   A*   A*   A*   A*   A*g   A*H   A*)   A*
   A*   A*   A*   A*   A*o   A*P   A*1   A*   A*   A*   A*   A*   A*w   A*X   A+ 9   A+   A+   A+   A+   A+   A+   A+`   A+A   A+"   A+	   A+	   A+
   A+   A+   A+
h   A+I   A+*   A+   A+   A+   A+   A+   A+p   A+Q   A+2   A+   A+   A+   A+   A+   A+x   A+Y   A+:   A+   A+   A+   A+    A+!   A+"   A+#a   A+$B   A+%#   A+&   A+&   A+'   A+(   A+)   A+*i   A++J   A+,+   A+-   A+-   A+.   A+/   A+0   A+1q   A+2R   A+33   A+4   A+4   A+5   A+6   A+7   A+8y   A+9Z   A+:;   A+;   A+;   A+<   A+=   A+>   A+?   A+@b   A+AC   A+B$   A+C   A+C   A+D   A+E   A+F   A+Gj   A+HK   A+I,   A+J
   A+J   A+K   A+L   A+M   A+Nr   A+OS   A+P4   A+Q   A+Q   A+R   A+S   A+T   A+Uz   A+V[   A+W<   A+X   A+X   A+Y   A+Z   A+[   A+\   A+]c   A+^D   A+_%   A+`   A+`   A+a   A+b   A+c   A+dk   A+eL   A+f-   A+g   A+g   A+h   A+i   A+j   A+ks   A+lT   A+m5   A+n   A+n   A+o   A+p   A+q   A+r{   A+s\   A+t=   A+u   A+u   A+v   A+w   A+x   A+y   A+zd   A+{E   A+|&   A+}   A+}   A+~   A+   A+   A+l   A+M   A+.   A+   A+   A+   A+   A+   A+t   A+U   A+6   A+   A+   A+   A+   A+   A+|   A+]   A+>   A+   A+    A+   A+   A+   A+   A+e   A+F   A+'   A+   A+   A+   A+   A+   A+m   A+N   A+/   A+   A+   A+   A+   A+   A+u   A+V   A+7   A+   A+   A+   A+   A+   A+}   A+^   A+?   A+    A+   A+   A+   A+   A+   A+f   A+G   A+(   A+	   A+   A+   A+   A+   A+n   A+O   A+0   A+   A+   A+   A+   A+   A+v   A+W   A+8   A+   A+   A+   A+Ǽ   A+ȝ   A+~   A+_   A+@   A+!   A+   A+   A+   A+ϥ   A+І   A+g   A+H   A+)   A+
   A+   A+   A+֭   A+׎   A+o   A+P   A+1   A+   A+   A+   A+ݵ   A+ޖ   A+w   A+X   A+9   A+   A+   A+   A+   A+   A+   A+`   A+A   A+"   A+   A+   A+   A+   A+   A+h   A+I   A+*   A+   A+   A+   A+   A+   A+p   A+Q   A+2   A+   A+   A+   A+   A+   A+x   A+Y   A+:   A+   A+   A,    A,   A,   A,   A,a   A,B   A,#   A,   A,   A,   A,	   A,
   A,i   A,J   A,
+   A,   A,   A,   A,   A,   A,q   A,R   A,3   A,   A,   A,   A,   A,   A,y   A,Z   A,;   A,   A,   A,   A,   A,   A,    A,!b   A,"C   A,#$   A,$   A,$   A,%   A,&   A,'   A,(j   A,)K   A,*,   A,+
   A,+   A,,   A,-   A,.   A,/r   A,0S   A,14   A,2   A,2   A,3   A,4   A,5   A,6z   A,7[   A,8<   A,9   A,9   A,:   A,;   A,<   A,=   A,>c   A,?D   A,@%   A,A   A,A   A,B   A,C   A,D   A,Ek   A,FL   A,G-   A,H   A,H   A,I   A,J   A,K   A,Ls   A,MT   A,N5   A,O   A,O   A,P   A,Q   A,R   A,S{   A,T\   A,U=   A,V   A,V   A,W   A,X   A,Y   A,Z   A,[d   A,\E   A,]&   A,^   A,^   A,_   A,`   A,a   A,bl   A,cM   A,d.   A,e   A,e   A,f   A,g   A,h   A,it   A,jU   A,k6   A,l   A,l   A,m   A,n   A,o   A,p|   A,q]   A,r>   A,s   A,t    A,t   A,u   A,v   A,w   A,xe   A,yF   A,z'   A,{   A,{   A,|   A,}   A,~   A,m   A,N   A,/   A,   A,   A,   A,   A,   A,u   A,V   A,7   A,   A,   A,   A,   A,   A,}   A,^   A,?   A,    A,   A,   A,   A,   A,   A,f   A,G   A,(   A,	   A,   A,   A,   A,   A,n   A,O   A,0   A,   A,   A,   A,   A,   A,v   A,W   A,8   A,   A,   A,   A,   A,   A,~   A,_   A,@   A,!   A,   A,   A,   A,   A,   A,g   A,H   A,)   A,
   A,   A,   A,   A,   A,o   A,P   A,1   A,   A,   A,   A,   A,   A,w   A,X   A,9   A,   A,   A,   A,Ž   A,ƞ   A,   A,`   A,A   A,"   A,   A,   A,   A,ͦ   A,·   A,h   A,I   A,*   A,   A,   A,   A,Ԯ   A,Տ   A,p   A,Q   A,2   A,   A,   A,   A,۶   A,ܗ   A,x   A,Y   A,:   A,   A,   A,   A,   A,   A,   A,a   A,B   A,#   A,   A,   A,   A,   A,   A,i   A,J   A,+   A,   A,   A,   A,   A,   A,q   A,R   A,3   A,   A,   A,   A,   A,   A,y   A,Z   A,;   A,   A,   A,   A,   A-    A-   A-b   A-C   A-$   A-   A-   A-   A-   A-   A-	j   A-
K   A-,   A-
   A-   A-
   A-   A-   A-r   A-S   A-4   A-   A-   A-   A-   A-   A-z   A-[   A-<   A-   A-   A-   A-   A-   A-   A-c   A- D   A-!%   A-"   A-"   A-#   A-$   A-%   A-&k   A-'L   A-(-   A-)   A-)   A-*   A-+   A-,   A--s   A-.T   A-/5   A-0   A-0   A-1   A-2   A-3   A-4{   A-5\   A-6=   A-7   A-7   A-8   A-9   A-:   A-;   A-<d   A-=E   A->&   A-?   A-?   A-@   A-A   A-B   A-Cl   A-DM   A-E.   A-F   A-F   A-G   A-H   A-I   A-Jt   A-KU   A-L6   A-M   A-M   A-N   A-O   A-P   A-Q|   A-R]   A-S>   A-T   A-U    A-U   A-V   A-W   A-X   A-Ye   A-ZF   A-['   A-\   A-\   A-]   A-^   A-_   A-`m   A-aN   A-b/   A-c   A-c   A-d   A-e   A-f   A-gu   A-hV   A-i7   A-j   A-j   A-k   A-l   A-m   A-n}   A-o^   A-p?   A-q    A-r   A-r   A-s   A-t   A-u   A-vf   A-wG   A-x(   A-y	   A-y   A-z   A-{   A-|   A-}n   A-~O   A-0   A-   A-   A-   A-   A-   A-v   A-W   A-8   A-   A-   A-   A-   A-   A-~   A-_   A-@   A-!   A-   A-   A-   A-   A-   A-g   A-H   A-)   A-
   A-   A-   A-   A-   A-o   A-P   A-1   A-   A-   A-   A-   A-   A-w   A-X   A-9   A-   A-   A-   A-   A-   A-   A-`   A-A   A-"   A-   A-   A-   A-   A-   A-h   A-I   A-*   A-   A-   A-   A-   A-   A-p   A-Q   A-2   A-   A-   A-   A-   A-   A-x   A-Y   A-:   A-   A-   A-   A-þ   A-ğ   A-ŀ   A-a   A-B   A-#   A-   A-   A-   A-˧   A-̈   A-i   A-J   A-+   A-   A-   A-   A-ү   A-Ӑ   A-q   A-R   A-3   A-   A-   A-   A-ٷ   A-ژ   A-y   A-Z   A-;   A-   A-   A-   A-   A-   A-   A-b   A-C   A-$   A-   A-   A-   A-   A-   A-j   A-K   A-,   A-
   A-   A-   A-   A-   A-r   A-S   A-4   A-   A-   A-   A-   A-   A-z   A-[   A-<   A-   A-   A-   A-   A-   A-   A. c   A.D   A.%   A.   A.   A.   A.   A.   A.k   A.L   A.	-   A.
   A.
   A.   A.   A.
   A.s   A.T   A.5   A.   A.   A.   A.   A.   A.{   A.\   A.=   A.   A.   A.   A.   A.   A.   A.d   A.E   A.&   A.    A.    A.!   A."   A.#   A.$l   A.%M   A.&.   A.'   A.'   A.(   A.)   A.*   A.+t   A.,U   A.-6   A..   A..   A./   A.0   A.1   A.2|   A.3]   A.4>   A.5   A.6    A.6   A.7   A.8   A.9   A.:e   A.;F   A.<'   A.=   A.=   A.>   A.?   A.@   A.Am   A.BN   A.C/   A.D   A.D   A.E   A.F   A.G   A.Hu   A.IV   A.J7   A.K   A.K   A.L   A.M   A.N   A.O}   A.P^   A.Q?   A.R    A.S   A.S   A.T   A.U   A.V   A.Wf   A.XG   A.Y(   A.Z	   A.Z   A.[   A.\   A.]   A.^n   A._O   A.`0   A.a   A.a   A.b   A.c   A.d   A.ev   A.fW   A.g8   A.h   A.h   A.i   A.j   A.k   A.l~   A.m_   A.n@   A.o!   A.p   A.p   A.q   A.r   A.s   A.tg   A.uH   A.v)   A.w
   A.w   A.x   A.y   A.z   A.{o   A.|P   A.}1   A.~   A.~   A.   A.   A.   A.w   A.X   A.9   A.   A.   A.   A.   A.   A.   A.`   A.A   A."   A.   A.   A.   A.   A.   A.h   A.I   A.*   A.   A.   A.   A.   A.   A.p   A.Q   A.2   A.   A.   A.   A.   A.   A.x   A.Y   A.:   A.   A.   A.   A.   A.   A.   A.a   A.B   A.#   A.   A.   A.   A.   A.   A.i   A.J   A.+   A.   A.   A.   A.   A.   A.q   A.R   A.3   A.   A.   A.   A.   A.   A.y   A.Z   A.;   A.   A.   A.   A.   A.    A.Á   A.b   A.C   A.$   A.   A.   A.   A.ɨ   A.ʉ   A.j   A.K   A.,   A.
   A.   A.   A.а   A.ё   A.r   A.S   A.4   A.   A.   A.   A.ؙ   A.z   A.<   A.   A.   A.   A.   A.D   A3p   A3Q   A32   A3   A3   A3   A3   A3   A3x   A3Y   A3:   A3   A3   A3   A3   A3   A3   A3a   A3B   A3#   A3   A3   A3   A3   A3   A3i   A3J   A3+   A3   A3   A3   A3   A3   A3q   A3R   A33   A3   A3   A3   A4    A4   A4y   A4Z   A4;   A4   A4   A4   A4   A4   A4	   A4
b   A4C   A4$   A4
   A4
   A4   A4   A4   A4j   A4K   A4,   A4
   A4   A4   A4   A4   A4r   A4S   A44   A4   A4   A4   A4   A4   A4z   A4 [   A4!<   A4"   A4"   A4#   A4$   A4%   A4&   A4'c   A4(D   A4)%   A4*   A4*   A4+   A4,   A4-   A4.k   A4/L   A40-   A41   A41   A42   A43   A44   A45s   A46T   A475   A48   A48   A49   A4:   A4;   A4<{   A4=\   A4>=   A4?   A4?   A4@   A4A   A4B   A4C   A4Dd   A4EE   A4F&   A4G   A4G   A4H   A4I   A4J   A4Kl   A4LM   A4M.   A4N   A4N   A4O   A4P   A4Q   A4Rt   A4SU   A4T6   A4U   A4U   A4V   A4W   A4X   A4Y|   A4Z]   A4[>   A4\   A4]    A4]   A4^   A4_   A4`   A4ae   A4bF   A4c'   A4d   A4d   A4e   A4f   A4g   A4hm   A4iN   A4j/   A4k   A4k   A4l   A4m   A4n   A4ou   A4pV   A4q7   A4r   A4r   A4s   A4t   A4u   A4v}   A4w^   A4x?   A4y    A4z   A4z   A4{   A4|   A4}   A4~f   A4G   A4(   A4	   A4   A4   A4   A4   A4n   A4O   A40   A4   A4   A4   A4   A4   A4v   A4W   A48   A4   A4   A4   A4   A4   A4~   A4_   A4@   A4!   A4   A4   A4   A4   A4   A4g   A4H   A4)   A4
   A4   A4   A4   A4   A4o   A4P   A41   A4   A4   A4   A4   A4   A4w   A4X   A49   A4   A4   A4   A4   A4   A4   A4`   A4A   A4"   A4   A4   A4   A4   A4   A4h   A4I   A4*   A4   A4   A4   A4   A4   A4p   A4Q   A42   A4   A4   A4   A4Ķ   A4ŗ   A4x   A4Y   A4:   A4   A4   A4   A4˾   A4̟   A4̀   A4a   A4B   A4#   A4   A4   A4   A4ӧ   A4Ԉ   A4i   A4J   A4+   A4   A4   A4   A4گ   A4ې   A4q   A4R   A43   A4   A4   A4   A4   A4   A4y   A4Z   A4;   A4   A4   A4   A4   A4   A4   A4b   A4C   A4$   A4   A4   A4   A4   A4   A4j   A4K   A4,   A4
   A4   A4   A4   A4   A4r   A4S   A44   A4   A4   A4   A4   A4   A5 z   A5[   A5<   A5   A5   A5   A5   A5   A5   A5c   A5	D   A5
%   A5   A5   A5   A5
   A5   A5k   A5L   A5-   A5   A5   A5   A5   A5   A5s   A5T   A55   A5   A5   A5   A5   A5   A5{   A5\   A5=   A5    A5    A5!   A5"   A5#   A5$   A5%d   A5&E   A5'&   A5(   A5(   A5)   A5*   A5+   A5,l   A5-M   A5..   A5/   A5/   A50   A51   A52   A53t   A54U   A556   A56   A56   A57   A58   A59   A5:|   A5;]   A5<>   A5=   A5>    A5>   A5?   A5@   A5A   A5Be   A5CF   A5D'   A5E   A5E   A5F   A5G   A5H   A5Im   A5JN   A5K/   A5L   A5L   A5M   A5N   A5O   A5Pu   A5QV   A5R7   A5S   A5S   A5T   A5U   A5V   A5W}   A5X^   A5Y?   A5Z    A5[   A5[   A5\   A5]   A5^   A5_f   A5`G   A5a(   A5b	   A5b   A5c   A5d   A5e   A5fn   A5gO   A5h0   A5i   A5i   A5j   A5k   A5l   A5mv   A5nW   A5o8   A5p   A5p   A5q   A5r   A5s   A5t~   A5u_   A5v@   A5w!   A5x   A5x   A5y   A5z   A5{   A5|g   A5}H   A5~)   A5
   A5   A5   A5   A5   A5o   A5P   A51   A5   A5   A5   A5   A5   A5w   A5X   A59   A5   A5   A5   A5   A5   A5   A5`   A5A   A5"   A5   A5   A5   A5   A5   A5h   A5I   A5*   A5   A5   A5   A5   A5   A5p   A5Q   A52   A5   A5   A5   A5   A5   A5x   A5Y   A5:   A5   A5   A5   A5   A5   A5   A5a   A5B   A5#   A5   A5   A5   A5   A5   A5i   A5J   A5+   A5   A5   A5   A5   A5   A5q   A5R   A53   A5   A5   A5   A5·   A5Ø   A5y   A5Z   A5;   A5   A5   A5   A5ɿ   A5ʠ   A5ˁ   A5b   A5C   A5$   A5   A5   A5   A5Ѩ   A5҉   A5j   A5K   A5,   A5
   A5   A5   A5ذ   A5ّ   A5r   A5S   A54   A5   A5   A5   A5߸   A5   A5z   A5[   A5<   A5   A5   A5   A5   A5   A5   A5c   A5D   A5%   A5   A5   A5   A5   A5   A5k   A5L   A5-   A5   A5   A5   A5   A5   A5s   A5T   A55   A5   A5   A5   A5   A5   A5{   A5\   A6 =   A6   A6   A6   A6   A6   A6   A6d   A6E   A6&   A6	   A6	   A6
   A6   A6   A6
l   A6M   A6.   A6   A6   A6   A6   A6   A6t   A6U   A66   A6   A6   A6   A6   A6   A6|   A6]   A6>   A6   A6    A6   A6    A6!   A6"   A6#e   A6$F   A6%'   A6&   A6&   A6'   A6(   A6)   A6*m   A6+N   A6,/   A6-   A6-   A6.   A6/   A60   A61u   A62V   A637   A64   A64   A65   A66   A67   A68}   A69^   A6:?   A6;    A6<   A6<   A6=   A6>   A6?   A6@f   A6AG   A6B(   A6C	   A6C   A6D   A6E   A6F   A6Gn   A6HO   A6I0   A6J   A6J   A6K   A6L   A6M   A6Nv   A6OW   A6P8   A6Q   A6Q   A6R   A6S   A6T   A6U~   A6V_   A6W@   A6X!   A6Y   A6Y   A6Z   A6[   A6\   A6]g   A6^H   A6_)   A6`
   A6`   A6a   A6b   A6c   A6do   A6eP   A6f1   A6g   A6g   A6h   A6i   A6j   A6kw   A6lX   A6m9   A6n   A6n   A6o   A6p   A6q   A6r   A6s`   A6tA   A6u"   A6v   A6v   A6w   A6x   A6y   A6zh   A6{I   A6|*   A6}   A6}   A6~   A6   A6   A6p   A6Q   A62   A6   A6   A6   A6   A6   A6x   A6Y   A6:   A6   A6   A6   A6   A6   A6   A6a   A6B   A6#   A6   A6   A6   A6   A6   A6i   A6J   A6+   A6   A6   A6   A6   A6   A6q   A6R   A63   A6   A6   A6   A6   A6   A6y   A6Z   A6;   A6   A6   A6   A6   A6   A6   A6b   A6C   A6$   A6   A6   A6   A6   A6   A6j   A6K   A6,   A6
   A6   A6   A6   A6   A6r   A6S   A64   A6   A6   A6   A6   A6   A6z   A6[   A6<   A6   A6   A6   A6   A6ȡ   A6ɂ   A6c   A6D   A6%   A6   A6   A6   A6ϩ   A6Њ   A6k   A6L   A6-   A6   A6   A6   A6ֱ   A6ג   A6s   A6T   A65   A6   A6   A6   A6ݹ   A6ޚ   A6{   A6\   A6=   A6   A6   A6   A6   A6   A6   A6d   A6E   A6&   A6   A6   A6   A6   A6   A6l   A6M   A6.   A6   A6   A6   A6   A6   A6t   A6U   A66   A6   A6   A6   A6   A6   A6|   A6]   A6>   A6   A7     A7    A7   A7   A7   A7e   A7F   A7'   A7   A7   A7   A7	   A7
   A7m   A7N   A7
/   A7   A7   A7   A7   A7   A7u   A7V   A77   A7   A7   A7   A7   A7   A7}   A7^   A7?   A7    A7   A7   A7   A7   A7    A7!f   A7"G   A7#(   A7$	   A7$   A7%   A7&   A7'   A7(n   A7)O   A7*0   A7+   A7+   A7,   A7-   A7.   A7/v   A70W   A718   A72   A72   A73   A74   A75   A76~   A77_   A78@   A79!   A7:   A7:   A7;   A7<   A7=   A7>g   A7?H   A7@)   A7A
   A7A   A7B   A7C   A7D   A7Eo   A7FP   A7G1   A7H   A7H   A7I   A7J   A7K   A7Lw   A7MX   A7N9   A7O   A7O   A7P   A7Q   A7R   A7S   A7T`   A7UA   A7V"   A7W   A7W   A7X   A7Y   A7Z   A7[h   A7\I   A7]*   A7^   A7^   A7_   A7`   A7a   A7bp   A7cQ   A7d2   A7e   A7e   A7f   A7g   A7h   A7ix   A7jY   A7k:   A7l   A7l   A7m   A7n   A7o   A7p   A7qa   A7rB   A7s#   A7t   A7t   A7u   A7v   A7w   A7xi   A7yJ   A7z+   A7{   A7{   A7|   A7}   A7~   A7q   A7R   A73   A7   A7   A7   A7   A7   A7y   A7Z   A7;   A7   A7   A7   A7   A7   A7   A7b   A7C   A7$   A7   A7   A7   A7   A7   A7j   A7K   A7,   A7
   A7   A7   A7   A7   A7r   A7S   A74   A7   A7   A7   A7   A7   A7z   A7[   A7<   A7   A7   A7   A7   A7   A7   A7c   A7D   A7%   A7   A7   A7   A7   A7   A7k   A7L   A7-   A7   A7   A7   A7   A7   A7s   A7T   A75   A7   A7   A7   A7   A7   A7{   A7\   A7=   A7   A7   A7   A7   A7Ƣ   A7ǃ   A7d   A7E   A7&   A7   A7   A7   A7ͪ   A7΋   A7l   A7M   A7.   A7   A7   A7   A7Բ   A7Փ   A7t   A7U   A76   A7   A7   A7   A7ۺ   A7ܛ   A7|   A7]   A7>   A7   A7    A7   A7   A7   A7   A7e   A7F   A7'   A7   A7   A7   A7   A7   A7m   A7N   A7/   A7   A7   A7   A7   A7   A7u   A7V   A77   A7   A7   A7   A7   A7   A7}   A7^   A7?   A7    A7   A7   A7   A8    A8   A8f   A8G   A8(   A8	   A8   A8   A8   A8   A8	n   A8
O   A80   A8   A8   A8
   A8   A8   A8v   A8W   A88   A8   A8   A8   A8   A8   A8~   A8_   A8@   A8!   A8   A8   A8   A8   A8   A8g   A8 H   A8!)   A8"
   A8"   A8#   A8$   A8%   A8&o   A8'P   A8(1   A8)   A8)   A8*   A8+   A8,   A8-w   A8.X   A8/9   A80   A80   A81   A82   A83   A84   A85`   A86A   A87"   A88   A88   A89   A8:   A8;   A8<h   A8=I   A8>*   A8?   A8?   A8@   A8A   A8B   A8Cp   A8DQ   A8E2   A8F   A8F   A8G   A8H   A8I   A8Jx   A8KY   A8L:   A8M   A8M   A8N   A8O   A8P   A8Q   A8Ra   A8SB   A8T#   A8U   A8U   A8V   A8W   A8X   A8Yi   A8ZJ   A8[+   A8\   A8\   A8]   A8^   A8_   A8`q   A8aR   A8b3   A8c   A8c   A8d   A8e   A8f   A8gy   A8hZ   A8i;   A8j   A8j   A8k   A8l   A8m   A8n   A8ob   A8pC   A8q$   A8r   A8r   A8s   A8t   A8u   A8vj   A8wK   A8x,   A8y
   A8y   A8z   A8{   A8|   A8}r   A8~S   A84   A8   A8   A8   A8   A8   A8z   A8[   A8<   A8   A8   A8   AA  A=qAHAGA=qAA  AGA{A\)A33AA=qAQAARA33AGAQAAA(A
=AzA(AHAGAA(AQAHAAGAAAA{AA{ApAzAGAA(AA
=A(A
A33AAGAQAAA  AARA\)AQAA
AAAA{AAHA  AA=qAAAGA  A{AAAAzARARAA
=AHA33AGAA  AAApARAA  AA\)A\)A33A(AA
AA\AzAQAzA
ARAA
A(AAA{ARAApA\AAAffA=qA33A=qA=qAAA  AAHAHAAAAzA=qA
=AQAAA\AA
AAzA
=AAAA
AA=qAzA\AAzA(AAQA\ARAQAA
AAAQApAQAGAGAA  A\ARA(A
AffARAffAAA  A=qA
=A=qAA\A
=AA=qAffA\A\A{A=qA{AAApAAQAAAA\)ApApA
A{A(A\A=qA{AAAAA\)A
AA
A
AAAApAAAAGA
=AHA{AA{AA
=A\)AGARARAAQA(AQA=qAAA
A{AAA(ApAQA
=A
=ApAQAA
=AQA{A  AAAAApA  AAHAAA  AAffAAA(A  A(AA
=AA
=A\AQA\)AzAA  A
A
=AAQAAzA\)A
=ApAApAGAAGApAAzAAAQA=qAA
A{A
AA
=ARAAGAA\)AAAGAARARA
=A\)AAAA33A  ARARAA
=ARA(A  AQAHAAA\)A33AAA\A33AA\)A
=AAzA\AQAHAAAzA{A  AA
AA
A
ARAHA(A
AzAApApA\AA\)AA  A=qARAGAA33A
=A33ARAAffARAA
=AA\A\AzA\A\A(AffAAzAffA\AHA{A\)AAAGAAffA  A=qA
AAAAzAAAAA\)AAAA(AA\)ApAAAA{AHA
=AAffAA\)AGA  A\)AA
=ARAAA
=AA
ApA
AffAQA\AAzAA\ARAHAGAAA  A\)A\AA(AAA33AAAffAzARAAA{AA=qAQAA(AAA
=ApARAAffA
=AARAA{A=qA  AAAAA33AHA=qAA{A  A  AAHAA
=A=qA33AA{A(A\A\A=qAAA
A(AzAffA
AAGAQAAAA{AA=qARAAA{A=qAQAA
AHAHA33AA
=A\)A{AQAAAAAHA33ApAA\A{AHAA  AAAA  A\AGAAAHA
=AHA(AffA=qA\AzAA\)A33AzAAzA{A
=AA
=AGARAAAAffA
=A\A=qAAHAARAGA
=AA\AA(AAAGA  AQAA33AHAARAA=qAAAHAAA=qA\AGA(A
=AA{AAAHAAA{AAQAGAGA\)AGAApA33A\AQAAAA  AAHAAGAGAAHAA(AAAAQA\ARA\)AGAAQA(AQAffAA  AA\A  AQAA33AAHAA\AzA
=A
=AA
=A33A\)A33AGApAHA
AAHA  AA  AA
=AAHA33ARAAffAA{AAA=qA33A33ApAAGAAAzARAHA\)ApAAAGAQAHA
=A  A\)ARA
=A
=A33AAA
A=qAffAGA(A\AGAA\)AAA
A{AzARAAAAA{AA  AApAAAA(A  A{AzAAA
AA
AA
AGA(A  A
=A{AAA(AHA
AA=qAAHAAAzAzAffAQApAA33AA=qA
AAGAA\A\AA\)AffAzAAA33AA33A\)AzAAAAHAzAAGA\)AAGAA=qA(A
=ApAA  AAQA  A33AA  AAQAAA
A\)AA(A\)A
A(A=qARA  AA\)AA{AA
=AA\)AzAAď\A=qAAQAzA(AHARAffAA=qARAAA{AAzAA33A
A
AGAAAARA(AffAAAAA33A  AA{AHAA=qA
=AAAA\)AAzAAGAAA\AAHAApA
=AA(AHAAAAGAffAHAApAAA{AARA{AARA\A{AAAARAGA\AGA
AA\)A33AAAffA
=AAA{A  AffAAA
=AAA\)A33AA=qAQAAAzARAAHAARAzAAzA
AA(AffAA33AHAA\ARA{AAGApAGA\)ARA{AAffAARA\AAA(ARAffAAQA
=AHA33AA(AQAHA33ApAA  AA\AAffA{AA33AAAA=qAffA33A33AGAHAQA  AAQAHAAApA=qA33AHA
AGAA{A\AAAA  AA{AA  AGAAAAA
=A
=A
=AffAzA
AAA=qAGA33A  A\AHARAAQAAAAAAAGAAAGA{AQAAffA\)AA\A(AHA33A\AAffAAAffAHAARAffAA\)A=qA=qA=qAAffARA33AA(AzAffA
=AGAA=qA\)AAA{A  A  AzA\AA  A33AAAGAA=qAAHA33A  AAAAAAGAAAzA\)AzAA=qAQAffA33AGAA33AAAGAAA{AQAHARAzAAA
AGA
A(AffAAzA\)AA{AAAQAAARAHAAGAQARA{AAzAHA33AffAAAAAîAAA  A{A(AffAAAAAQA\AA\)AHAARAAQA(AA
=ARAAQA(AAGAGAApA\)AGA
=AAAQAzA33ARA{A{AA33A\AApA\ApAAAGA\A\AAAAAA\AA33ApA33AAffApA
AAApAAAffAGAApAzARAA{A=qA  A  A\)A\AQAzAAAAHA\)AzA(AA
AAAAARAHA
=A33AA\)AAAHA33AHAARARAAAGAHAAAzAA=qAffAA
AHAffAAQAAGAAHA
AA\AAA
=AzA33AA33AffAAAAAQA(AAAAHApA
ApAA\)AAGA  A(A{AAAQA(AAAAAQA=qA
AApAAA  A\)AAGAARAA\A=qAGAAQA(A=qA{A
A  AffA\AA
=AHAA
=A\)AÅAîA  A=qA=qA(AA
AîAÙAÙAÙAÅApAAAAAAAGAHA33AAHA
=A
=A33A33ApAÅApAÅApA\)A33AAHAA¸RA¸RA\AQA=qAQA
=AHA£AîAÙA£AffAHA\A
=AffA  AffAA=qAAAffA
=ApA\)AGApA{A33A33AA\)A33A(A
AQARAA\ARAA{A=qA\A33A=qAApAÅA  A{A  AîAGAA£AzAQAQAAAA33AA  AAA  AA33A
=A33AQA\)AA\AA
ApAffAA33ARA\AAffAffAQARAAAHAA
A\AA(AA=qA
=ApA=qAAGA
=A(ARA{AzARA{AzAA
AAA\)A\A(A(AAffAffARApAA33A\)AAAAAARAAQAAA
A{A  AAA=qAAAA  A\)AĸRAzAAģAQAQA(A33A\A¸RA¸RAA\)A\)A
=AA£A
A33AQA\AA
=AGAGAAAAQA£A¸RAQA£A(AffA(AQA\AzAA£A=qA£A¸RA£AAQA¸RAAffAAAA(AAHAGAAAA\)AA\AzARAHA33AAzA
=AA  AQA{AffA
=AzAAA{AAApAzA33AApA33AA
=A33A
AAzARAAAARA
AAA
AQAA\AAAAffA\AAA(AQA{AAAA\)A  A=qA
A
A
A  A  A
AA\)AAHAQA\AQA=qA=qA=qAffAzAA
=ApAAA
=AGA\)AA33AAGA\A\A\)AAA=qAAA{AHAHA
AA
A  A(AAQAAAAffAAA
A  A  A
AAGARApAA\AAARARAA  AA  A(A  A(A¸RA(AzA  A{A(A  A{AA
ApA(AAAAAA(A{A
AA
=AGAGAA\)A
=AGA
AARAAGAApAGApAAAA{A=qA
AHAAAzA{AA{AA  AA  AAQAAA\ApApAA\AzAAGARA(A\)AAAA
AAAA  A  AAAA  AA  A  AAAģAzAĸRA
=AHAA{AHA33AǅAGA\)AƣAzAAď\AA{A\)AAQAAApA(AĸRAAÙA
AHA
=A
=ApA33AA
=A
=A£AHAzAAHAzAAQA\A33AA
=AAzA=qAGAAA=qARA{AARA
=AGApAHAA=qA=qA
A
AA
=ARA  A  AAAHA\)A\)A\)A{AQAzAAAQAAA\)AAAApARAffAGAA=qA  A{AQAAA\)A  A33A(ARAA=qA33AHAA\A  A(A(A\A33AA=qAAGARA{A  AHAGAAApA{AA(AAGAzA  AQAA
=AAzAA\)ApA{A
=AffAAffAAAGA=qA33AzAffAApA
=AA{AAAAAAAAAA=qAAA=qAQApAAHA{AHAA  AAAAAGARAQAARAAAAffApAAAffAA
A  AA
=A{A\)AA
=A
=A=qAARA
=AAA\)A{ApAA33AA
=AHAA  AAHAAAAAA\AQAQAAA  AHAffA{AAAHAAAAGAGAHApAAA\)AQAA(AA
A33A
=AAzAAGAAAffAzA(AAzAHA{AGA(AAAAAQAQA=qAAffAA
=A{A{AApAA33A33A=qAA
AffA
AGAQAAA(A
AzAA{A33A{AAAARAA
=ApA(A=qA{AA33A
AGA
=A
=AzA  A
=AAAA  ARA(AGAQA{AAAA33A(AAA
=A(AA\AQA
AQApAARA  AAHA
AA  AAffA{A=qA=qAAA\)AA
=A\)AGAzAHAGA33A\ARAAHAAA  A=qAAA{AAffA{A{AHAAAGAzA=qAffApAA
A{ARAARAAAAAApA
A33ARApAHARA=qA
AHA(AHAApA
AzA=qAzAA\A{A(AAAGARAffAHAzAQA\AAA
=AAAGAGAA\)A33AAA\)AApAAGAA33AAGAQApA\)A\)AAApAGA\)A
=AAzAA
AAAA(A\AAA{AHAAHARARA\AQApAApA
AAAAA\AzAA
=AA  A  AGA33ARAA33A\)A  A{AffA=qAQAQA33AHApA  A  A
AAAA{AAAAzAAA33AQA\AA
A  AffA
AAAAApAA=qA(A
A=qAQARARAApAAffAzAAAAAzAAzA\)AAA  AA33A
=AA
=A
=A=qAAA  A  A(AA(A
=AAAAQAAHAffARARAARAQAzAffARAzAA=qA33AGAApA(AGA
=A\)ApAA33A33A
=A\)A33AGAA33AAA  ARAAA
AAARA33A\AGARAGAA\A=qAAA33ARA=qAzA
AQAApA(AffAA33AA(A{AffA  AA\)A33A33ARAffAQA=qA
=A{A
=A
AA=qAffAzAAAA(A(A{AGA33A(AffA\AAAAAAGARA
AAAffA(AffAffAQA\AA
=A=qAzAA¸RApAQAAAzAAzAQAzA  A(AAHAGA=qAGAARAHA\A
A  AA  A\AA
ARAHA\)A33AAAzAffA
A(AAAAAHA(A\)ARA{AAHA{AGAGA
A{AAGAAAAffAA
=AApAGAAAGA(A=qA\AAAA{A{AAA(A{A{AzARAARARARAA33A\)A  AGA{AA\)A\A(A(AGAQA\)AAAGA\)AAHA\AzA\ARAARAARA=qAQAffAAA\A=qAAGAAAGAA
A{AzAAAHAQA  AffAA\)A
ApAzApA33A
=AAA33AAffARApA\)A\)AA{A(AAAA=qAAAHA33AA{AAAApAffARA33AQAQA33ApAA
AQA\)A
ARAQAGAAAAffARAAARAzAGAAGA(AARA  A\)A\)AARAAAHA\A\)A=qA{A  A{AAAA{AffA\AGAAAA=qA\A
A(A\)ApAA  A\A(AAA=qA{A{A\)A(AffA{AGA\)ApAAARAAGAAA33ARAffA{ARA
A
=AffAAA=qA  A
ApAAAffA  AAAHAzA  AAGA
AAAAAQAHAAAAAAffA=qA=qA(AA  A
=AAAzA  A\)AA=qA(A\)A33ARARAHA(AAHA{A  AAA
AA
=AQARAAAAAHA\)A\)AAGAHAA{A(AzAAAAAAA=qA(A=qA{A  A  A(A
A(A{AffAAGARA
=AAAARA{AAAHAAQAzA=qAzA\AAAA
=AAA(A=qAAA=qAzAA=qA
AApA
A{A(A
AA
A
AzARAAA=qA
=A{AGAAAGA
AA=qApA\A33A
ApAffAAA=qAffAQAAA\)AA
=A
A
=A\A33AzAAAAAA
=AzAAQAA\ApA\AffAAApAA(A33ApA
AAHAA  A
A\AAGAHAA{AA
=ARA\A
=AGAAApAAHA
=AA  A(AQAAA
=A33ApA\)A\)A
A  ARA  A
AAHAGAAHAA
AAffAQAAAHAAAzA33A\AHA=qAAAAQA=qAA\)A
=AAAGAA=qAAAAQAAAHAAAffAA33AA
=A  A
=AHAA{A=qAARAAGA{AA33AAAAzAAApA
ARAAffA
=A{A(AAAHAHAzAAAGA(ARAAzAAA\)A
=AA
ARApA
A=qAHA
=AApAAzA(AAAGAHApA(AA=qAffA
=A(AA
AAA\)A(A
AARA=qAA\A{AzAzAAffAzAA\ApA  AzAAAARAAAAA\)AQAARA=qAAffA{ARAQA  AHA\AA\)AA\)A
AA  A\A\A\)AAGAGARAGAzA=qA{A  AAA(AAHAAA{A\AA  AA
=ApA
=ARAQARARAffA(A(A\A\A(AARAA{AARAAAHAARAAA
A(AA33A(AzAA  AA=qAA\A\)AA{AQA(AzAA
A{AzA33AA  ARAAA(A  A  A  AGA
AffA
=AffA{AA{A(AffAAAA=qA(AA  A
=AApA\)ApA33AAAA  AzAHAAzAQAA(ApAGAAA\)ApA
=AAzAA\)AAA\)ApAApApAAAAzAGAGAGA=qAA(AQAAAGA\)ARAApA
AAA\AApA{AA=qA{AHA(A
AGA
=AHAffAHAzAA\AQA(A\AzAGAQARAAA\A
=AAA\)AAA\AApA(A
=AAAAHAA
=A\)A{AA
=AAQAGAQAAAGAHAAA33A(AA33A\)AApAAA\AAGAffAAzAAzARAAA\AAAffA\A(ARAAA=qA  AAAA{A\)ApA\)A=qAA\)AGA\)ARA\AAA
A{ApAAQA=qAGAAAAAAAA(AAA
=A=qARAQA(ARARAApAQAzAffApARA
=AAQAAAGA{AAAA
AGAA33AA\AQAHAAQA  ApAGAffAAAGAAAGA
=AA\)AAAAAA
A
AAAA33AA
=AAAHA\A=qA=qAGAQA\AApAARAA{AAHAHA\AQAAAffAGA33A33AA
=A  A{AA(AHAQAAA
=AAHA
=AQApAA
=ARAA=qA(A=qARA\)AHA\)AA33AA
=AzA  ApAAzAApAHAffAAzA33AQAAAffAAQAAffA  AAAAffAAApAA33AA\A\)AAAA33AQAA
=AARA=qAAA\)AAHApAAAAAGAA\A{AA\)AAA
=A\A  AAzApAA
AAA33ARAA(AQAffA  AAAA\)A{AA33AAQAAA  AAA
=AHA
=A=qAA  AA{AAARAAHA33AA
=AGAApA\)ApA
=ARAQAQA  A
AAAQApA  ApApAGA
AAAAGA
=AAA  AA
AffAzAARA\A  AA{AAzA\AA(A\AffA
AAHAAHA{AA=qA\A\)ApA33AAA\AQAAA33A
=A=qAAA\)AARA\)AA
AAzAzA=qAA\)AAAAAQA
=A{A(ApApAA(AHAGAHAzA{AA\AAAGAffA(AffA
=AApAAARApAQA\)A
=AARA{A\AGAHA(AQApARAAGA  A\AzAA=qAAQAHAAA(A
=A\AA
AA(AA\)AzA
A
=A
AGAzA=qA
A\)AHA=qA  ApARAQAA\ApA  AAApAAAAA\A{A  A
AHAAA{AA=qAHA\)AQAAARAffARA
AGAHAQAA{AA\)A{AAAAApAA(A33AA\)A
=AffAQAffAAA\)A
A=qAAHA\AAAHAffA\)ARA  AzAAA\AA33AAA33AAzA  AzAGAAA  AffA  AAARAAAApAffAApAA{A(AA{ARAARA
ARA
=AARAA\)AGAHA  AzAHA\AA\)A\A  A\AAA  AAGAA33AGAQAA=qAHA\AAGA33AAzAGAQA33AAzAAAAAGAAAAAffAAGAAAHAAA
AAQAffA{AffAAAAAQA  AApAAAAARAAA33AAAAGA\)AA(AA=qAAHAffAAGA\)AffAA  AApAAA
AA
=AHAAzA=qA(A\)A{A
AGAQA\AA  AA
A{AQA(A
=A33AAzAffAHA\)AQA=qApAA
A(A
=AffAA33A33AQA=qAAApAffA  A=qAQAGA  AA\)ApA(AGA(A{A{ApA=qAAAARA=qARA{AA
A\)AAA  AARAA33AffAAAA  AHA(AAAA
=AAARA=qAGA
A33AzAAA=qA(A33A(AQARAAAAA\)AAHA{AA\A  AQAAAA
AGARAAA  AAApA\A
A33AA  A\AAAAffA
=AA\AA
AAA=qAAAQA{AAzAzAAffARAzARAAffApA\AAA33A(AA\)A  A
=AA33AGA
ApAAAQAA=qAAA
=AAHAAA\)A33ApAAAQA  A
=AAA=qAA{AAffAAA33AQARA(A=qAffAHAA(AzAAA
AHA33AA=qAARA
A(A\)AA
=AAQA33AHARA  A\)A\A(A
AAARAGApAAHAAAAGA{AHAA\)AA
=AA\A33A\)A(AQA  A(AAHA33ARA
=ARARAA\AGAA=qAffA
AA(AAAQAApAzAA  AARARA33A=qAA=qA{AAGAffA  AAAApAAA
A(AAAAAAA  A\A
=AGA33A
=A\)AQAApAffA(A=qAA\AA{A33AAAA(AA
=AffAAA33AAzAzAAA
AffA=qA
=A
=A=qA  AA
A
=AAGAAAARA
AA=qARA  AGAARA\AA(AQA=qA\)A
=AA\)A
=ARA33A\)AQAA\A
=ApAA
=AA\AAAffA{AzA¸RAzAffA{A\)AAA  AA\)AGA(AAAAAGAzAA
=A
AA
AA  A\AA=qAffAAApAA
A
=AffARAAQA33AA  ARAA(AHA  AGAAQAA=qA
=AffA{AffAAQA
=AAAHA
A
=AA
A=qAAA
AApA{A=qAQAGAAAA\A33AA=qA\AA=qAQA
=A
AAA
=AA33ApAAAAffAffAffAAA\A  A{AA\)AHA33A{A{AGA  ARA=qA\)ARA
AAQAA(AAzAQA{AAAAQAA=qAzA  AzA  AAAQAffAA=qARA(AAA(AffAHA
AzAAA
=A
=AGAA
=AGA
AAzAA  ApA(AAApAzAA\A\)ARA
=AGAQA
AzAffAGA
AAGAAHA\)ARA
=A{A{A\)A\)A(ApAAA
=A
AA=qAAApA
=A=qApAA33A=qA{AAA(AQApAQA
AApA
=AA  A
A=qApAHA=qA33AAAAA
=A\AQA(A(A(AAzAAAARAAAQA
=A\)ApAAAAQAAA(A\)AGA\)AAAA=qApAAA\)A(AHARAffA(A\)ApA\AA\)AQA
=A(A\)AQApAHARA=qAzA{A\A\AAGAAHAGAGA\)AAHA
=AA
=AHARARAzAQAQA33AffAA\)AApAARAQAHAA{AzAHA33AffA33A  A
=AAGA\)ApA  A33AQAQA
AAzAffAAffAAA(AA=qAA
AA=qAAzAzApA  AAzAzAAQA\)AA\AAAGA(AzARAHAA\AAQA{A(AQA{AHAQA  ApApAA
A\AffAAApA\AHAQA\)A(AA(A{A\A
=AAAQARAQAQApA{A\)AAAA\A{AAAAAAAHAzAA33ARAffApAApAAA(A=qAA  AApA  A\)AQAA=qA\A{AApA
A
=ApApA{ApA\A\A\)ApAA{AA  A£A\A\A{AA¸RA  AGAA=qAAAAffARAAA(AA(ARARA
=AGA\)A\)A\)A\)A(A
=ARAA\A  A=qAHApAA33A(A(A\AA33AAGAAGAAA\)A\A33AAApAAQAGAARA  A  A
=AA
=AAARA
AARA
=A  AA{AAAA33A(AHAA{AA\AAApAApA  AAQAA
A{A33AAAQAA(A(A\AAAAffAQAA{A\)AGA\)AAffA\AGA\ARAGAGAAAA\)A33AffA\AA=qAffAA=qAA33A{A{ARARAAA33A{AAAQA
=A
=A=qA
=AAApAQAAApAGAzAAA  AA
=AGAARA\)AAAAAA=qAQAHAQA\)AGA
=AA\AA
AARAAAAGAAHAGAA{AzAAApA
A(AApAA=qA¸RAA  AQA(A{ApAA\)AAAA33A  AffAA\)AA33AA\ARAAA=qAA  AQAAHA
=AA{AAAAAHAA=qAA  A{A  AA{A  AzAARAHA33AzA
A33AA{A{ApAA{A  AAA33A\)A=qAA=qA\A\AA
=AApA{AQA{AA
A(AffA
AAAAA(A=qA{A=qAQAAARARAHAAAA(AA33A
=A33AA\AAGA\)AA
=A(A\AffAAffAAA33A{AAQAAffA  AA
=AHAGAffAARA  A
=AA\A  AA
=A
=A
=A
=ARAAA\A{A  A
AAAQA=qAAAA  ARA\)A{AHA\)A\AQA\A  AA(A\A\A
=AA{AAffAGA
=ApAffAQAAA\)AApA\)A\AA33A33A\)AApA\)AAAAA\)AGA
=A\AA
=A{AAAAGAffAAAAGAAA=qAQApApAAA{AA\)ApAzA  A  AQAAffAQA33AffARAA=qAARAzA\A{AAAzAQAzA=qA{AAzAHAA{AGA\)AAA  A(A(AffAffAQAQAAffA33AAAGAHA\)AA(ARApA
AffAAGAffA\)A\)AffA=qAA33A=qAAAAAAAQA(ApA33AAGAA
=ARAAA(AAQA33AA\A\)AHAAGAAAAApApAARA\AzAzA\AffA\AA\AHAAHA\AApAAApAAA=qA  AHA
AAA
=AA{A=qAffAA{AGAA33AAAAAAAAA
=AAzA{AHA  A\)A\A{A33ARA=qAffAGApA33AffA{A33AAAQAAAffA=qAGAARAGAAA
AA\AAA
AARAQA(AAA(AAAHAA
A\)AAHARAA  AzAA  ApA33A\)A
=A
=AA\)A=qARA(AAHA\)A33AA{AARA
=ApAA\)AAA\A
AAHApAA(A{A
=ARAA{A\AAffAA
A
=AA=qAAzAffAAAffA
AARAAAzAAA
=ApAAGA\AA
=A
AAzAA
=AA\AAHARAAAA\)ARAAAA
=A
=A(A\A=qAffAzAAAA33A(ApAAARA33AAARApA
=A=qAAzAQA{AA(AGAHAAAA
A33AffA{AAApAzAGAA  AA=qAAHAGA\)AAAAHA(A
AAAApApAA  A33AffAAAzAAHARAA33A
ARAzA
=ARAARAGA\)AQAAGAzAzA{AARApApA{AA=qA  AAAAzAA{A33AAAA\)A
=A{AQAGAAApAQAffAA=qAHApAAGA33AA\AAGAHA33AffA{AAAzAQA  A
AA33AA
=ApA=qA{AAAHAAzAAAAzA(AAAHA  AA33A33AA(A=qA=qA  ApA\)A33AAGAQA33AffA  AHAzAAAGAAA(A  AGAAHA33A\A=qA
=A  A{A(AQA=qAA{AGAHApA(AffA\)ARA{A
=A(A\A33AAARAA33ApAAA\)AA{A{AAGAQA(A\)AApAAAAQAAAA
A
A=qAGA  AGA33AHAAApApAA\)ARA(AAA
=AHAAGApA
=ARAAHAA\)AAAA  AA\)AAAAAAHA\)AARAAA\)AAAAAAA
=A33AAAA
A
=AAAAAAApAAGA(A\)A\A{A
=AGApAQAA33ARAAGApA{AAAzA(A\)AA(AAGAGA
AAA
AQAHA  AAGAHA=qAA33AA=qARA
=ARA\ApAApAA  A\AAAHAGA\)A\AAAAzAAAAQARARAGA
=A\AQAApA
ARAAAA=qAA33AA
AA
A
=AAAAAAA
A33ARAA\A{AzARAA
=AA
=AzARA=qA
A{A  AHARAAzARAAA\)AQA(ApAAAAQA  A\)AffA\AAAAQApAAAA\)ApAQApA{A33AAGA
ApAAARAHAHApAzAGA=qAAA
=AAffAGAAAAA=qAzAAQA
AAGAAAGA
=AffAAzAA33A(AAzA
=AAGAzA=qAAzAAAAApAA{AA33AA\A(A  AHAGAzAGA\)AffAAAAAffA=qA(AA  AAA
=A
A33AAA=qA\AAGAA{A  AAA33AA\)A\)AAAAAAAQAA  AA(AHA
ARA\)A33AAzAzA(A33AA
=A=qA\AHA\)AAQA\AAzAQAAQARAzAA\A{AQA
=AAA=qAAAAApAAApAHAQA33AAAAAA\A33A\A\A
A33A(A
=AGAzA\AAAA33AARAGAA(A(ARAA\ARAA\AAAAQAA33A  AffAffA\A
A
AAQAA33AAHAffAAA{A=qAAAAA
AGA\)AA
=AAffAAAAAffAQA(A
=AAAA{AA(A=qAAGAARA\A
AQAA33AAAAAAAQA{A\AA33AzA\A\AAA  AA
=AAA33A=qAAzAAAGAA\AARAAzAAAGAAHAHAA
AQAffAA
AGA\)ApApA=qAGA\)AAAQAAAAAA
ApA
=AA
AA
=ApA  AAGA
AA
=ApA  AAAA{AAAAAA=qA  AHAARARAAA\)AAAQA33AAAGA(A\AAA=qA\A{A
=AGA(AffA\A\)AzA\)A\)AzAQAffA\)ApAzA33A{A  AAHAAHAAA(AHAA\)AA
A(A{AQAA33A
AA(AA{AAARA(AQA  AHAA33A(AA\AA  A\A  AzAzA{AA{AzAA(AA
=AAAA
=ARAAHARAzAARA=qAA
AAARAQAA  A\)AAA33AzAffA=qA
AGAAffA\A\)A
AQAA{A{A=qAA
A=qAAzA(ARA=qA(ARAAAGAA33A(AHA  AA33ApA\)AApA(A{AffAĸRA(AHAHA
=AHA33AAîAAA
=A=qA\A¸RA(A  ApAAA\A
=AffAzAQAA=qAA\A\AAA\)AApAzA
=AGAQARAA
AAHAzAA  AAGApAzAGA(AzARA(AAA\)A(A\)AA33AA\AA
=A
=AQAAA\)A33ApAHAHApApA  AAA\A
=AAffAQAAA  A
=AQAAA(AQAffA£AA33AÅAA(AQA\AApA33A\)A=qA{AA=qA(AAARA=qAAffA  AA\A=qAAAA\AAGAQA\A\)AAQA
=AAAA  A(AQAGA\)A33AAQA
A
=AGA33AAffApA(AGAffAHA\AGAA
AAAA
AA  AAHA  AA\AA\AA=qAAA
ARA  AA=qAAzAffA{A(A¸RA\)AAHAGAAHA\A
=A\)AAA{A  AffA(A{AA  AGAHARAffA\AA33AAA
AA
AQAzAAQA£A  AGA
=AAAA=qAGAAGA
AQApAAffA(A=qAAA\)ARA\)AAQA
=A=qA{A=qARA(AA=qA{A=qAQAHARA=qAA  AQAAAzAzAHAffAzA=qA\A33AA
=A33AAQAAQAA{A{A  A
A=qAffA\AAAffAHAAQA\)AHA\ApAAAQAzAffAARAAzA{A\AffAAAA{AA
=AA=qAAAA\A  AGAAffA\)A33A33AGA  AQA  AAA=qAA(AHAA\A(A
ApAHAA\)A  ApAzARAGApAARA\A
ARA
=A
AApA\AAA  A{AQAGAQAA
AAAAA(A
AAA  AAAApAApAAAA
AAA(AHAzA  AQApA\)AAGAApApAAA\)A
=AHApAAHA{AA{AA  A\A\)AA
=A
AzA=qAAA33AGA\)AHAA33AAzAARAQAApAA
=AAGAGA
=A(AAHAAffA{AARAzAAAzA33AAAQAA\AQAQA
=A\ARAA\A33AAAA(AQAQA{AGAAAA33A
=A
A\AAAA\)AAA
=ApA\)AARAAARAHAzAQA\ARA
=AA  ARAGA=qA{AHA
=AA(A
=A
AAAGA{AffAAzAApAGAffA\)A=qAA{AAHA
=ARA\A33ApARAA\)AAGA\)AQAA33AA
AffAAAzAARAffAA
A
=AAGA33AAřAģAAzA
AHApAQAGAŮAA{AřAŮApAřAffA
=AAîApAAA
=AAď\A(A{A
AAGAffA33A33A33A
=A  A
A  AffAA\A{AzAAA33AA  ARAA
A(AA\AA(AAAHAAQA\AHAAzA
AA(A(AAGAA{A
A\)AGA\)AARAzAAARAA
=AAGAAA=qAGA=qAzAA33AA
AApA  AzAAzA\)A\AHAA\AA
A=qA  AA  A
A
AQAGA\AQA{AAAAApA{AAHAA{AApA
AA
A\)AffA\AffAA  A(AAAAAAA
=A
=AHAzA  A\)AQAAApAA\AAAA\)AApARAHAffAAAA
=AAQAAzAAzAAGAAQA  AAA33ApA¸RA£AzA
A  A(AffAA33AzA£A
=A\)A(AA  A  A=qAGAzA
=A\)AA
=AAGA33AApAApAA
AA\)AHApAA33AAGAGAQAQAAGA  AA\)AA  AApAQAAzA=qA=qAffAzARARA
A  A33AAA
AAAA=qAA\)AAAQA
A\ApA\)AQAAAHAAAQApAGAAApAGApAQAzAHAA\)AAA  A{A
A  AffA  ApA\)AAAA{AQAAffAzAzAzAA
=AAAAAHARA33A  ARAAAARAzAA(AAAA\)A{A
A=qA  AffA33ApAAGAGAA\)A\)AAAHA(ApAA(AGA\)AGAzAA  A33AzAAA  A  A\AApA(AA
AA
=AA
=A
=AAAQApA=qA33AA33A  AAzAA  AzAAA  AzAHAAAA
AA33AzAAA\A
AffA(ApA(AQAA
=A\)A
=AHAHA33AAA
AAA\AAHAAQAAAAffAARAA{AAAAA=qAA{AAHAHA{A33ApAAzAGA(AAARA{AffAAQAAA\A(AA{ApARAAffAAAHA33A{ApA  AAGAA\)AAffAQA  AQA¸RApA{AHA
A=qAzA{AA¸RAAA
=AAffA33AQAA{ApAA
=AzARARAAGAzAA
AAA33ARAQA\)A{AQApAGA=qARA\AffA\)A\AHAffA
=ApA  AA\)AHA\)AGAGA=qAHAHApA  AAzAA\)AAA\)AAARAzA
=A
=A(A(AzA\A  A
=AAzA(A  A
AÙA\)AģA(A33A
AŮA(AŮAffAAAA33AA\)AQAÅA\)A\AffA£AGApAHA=qAzAHA¸RA¸RAA(A33AGApAAAA\A\AQARAApAHA
=A{AA
AHAARAAffARAzA=qARAzARARA\)AAAAAAAAQA(AHApA(AA\AHA  A\ARAGAAAAAzA\)A
AAffA\ARA
AAQApA=qAAA(AffAffA\)A
AApAHAA(AA=qAQAzARAQA
A
A
=AAApA=qAGAARApA=qAîAA
=ARA33AzA¸RAffAAARA\)AHAA
=A\)AGAARAHAA=qAAA{A{AAA\AA
AA33A  AffA=qApA
AQAAARApAA=qAAAHAHAA=qA(A{A\AGAAzA¸RA  AîA
=AA£AAHAÅA\)A  A{AApAffAƏ\A
AǅAA
=AHAƸRAAAƣAffAQAffAAA\)AŅAzAģAŮAAřA\)AffAAŅA(AffA=qAAîAA  AÙA(A=qAzAHAHAHAzAApARA  Aď\AA(A
AA\)A
=AAffA(AffAffAzARAA{AAA
AQAA33A33AffA{AzAA  AQAzAA£A(AGAAA\)A\A{AA\A\)AA
AQAzA\AAAA33A\)A\)AzAAHA33A\)ApAGA33AA\)AGAQAA
=A{A
AA
=A(AAA{AzAA\AQA
=A(A(AAAARA{A(A(A\AAAAAAzAGAAAzA(AAAHAARARAzA=qAzAAA
A\AA(A33AffA=qAzA{A(AffA
AzAAA\)A33AA(A
=A\)AARAA\AAÅA(Aď\A  AQAHAAHAA{A\)AǅAǮAGA
=AAA
AQAzA
AAAȏ\AHApA33A
AŅAGAŮAŅA=qAHAģA\)AAAzA\)A33AA=qAģA\)AGAîA(A
=AřAAÙAAŅAŅA=qAŅAAffA¸RApAÙAHAzA
=AQApA  AřAA(AAGAA  AGAA
A
=A=qAffAAA=qA
=AQAzAQA¸RApA=qAď\A
=A  AAȣAHAffAȸRA
=AGAffA˅AAHAAQAQAGApAHAA{A
ApAA\)AA
A
=A˅A33AʣAʏ\Aʏ\AʣAzAHA  AQA˙Aʏ\AAHAAɅAƸRAAQA(AA
AzAǮAƸRAAzAQAŮA¸RA\AzAffAƸRAŮAƣAƸRAǮA=qA33AƏ\A33AAAHAAzAÅA=qA\)A  A\)AŅA
=A=qAA33AA\AAzA=qA33A£A¸RAAHApAÅAAQAQAîAA  AffA(AĸRA\AQA=qAGAÅA\AAAffAAA33A(A\)AzAĸRAď\AģAA33AGAGAA=qA\)AAzAzAzAGAffAffA=qApAA  AffAAffAŅAGA(A
=ARA{AAA{A{AGA33AA33A
=A\)AHAAARA33ApAHAGA(A
A=qAHA
=A  AAHAHAARAAQAA  A\)ARA
AAAAAGA{ARAGA  A(A33A33A33AGA
=AGAApARAA=qA=qAAzA
=AGA=qAzAffAzApAQApA33A\ApA=qAGAAA33AAA
=ARAAAA
A
=A\)A=qARA=qA
AAAzA\A
=AA\AA33AA
AQA
=AA=qA{A{AA=qA{AGAA(A
AAAA=qAApAAHAA33A\AA\AA  A  A{ApA\A=qA(AHA
=AQA33AGAA
=AAzApA
AffAHAřAA
=AřAŅA
=AffAƸRA
=AǅAAQAzAGAA
=AĸRAĸRAď\AîA{A=qA(AGA  AÙAÙAÅAA=qAzA=qAHA
=A  AApAAAA  AîA33AA\AA33AA(A\)AA\AAffAA\)ApAAzAHA\)ApAAA\A
AHAAA33AffA\)AffARAA
=AzAA  A\)ApAAGA=qA(AA
A  A  A{AffApAď\AAģA(A=qA=qApA
AAffA{AƏ\A33A33A\)AGAŅAzAAAîAAA
=A(AƣA
=A  A
A33A(A  ApA  AA\A
AA\)ApAAHAAA(AA(AA(A
=A\)AAAAffA
=A\)AA=qA=qAAQA(A
=AAAîA=qAAAAƸRAA
=AA£A  A  AAffAAAAHA\AGAAAAGA{A  ARAA\)ApAGAApAHAAffApA
=AAzA
=A=qAA=qAAGAzA
=AzAřA\)A  ApAÅAAffAffAÙAAŅApApA33AA\AAAAQA33AzAHApAffA33A33AzAAAzAAAffA\)A\AAffA=qA33AHAA(AA\)A
=AAA\)A\AffAAA\AAzA=qAA
AA33AApAA
=A=qAA  A{A\AAAGA(AAAQAÅA  AffA(A=qA=qAÙA
A
=A\)AGAAzA\)A(AffA(AĸRAĸRA=qAQAAHA(AŮA33AffA  AA(A=qA{AŅA{AA\)A
=AGAffA\)AA  A=qAAAAzA
A\)AAAGA33A33AA
A
=A  AzA  AAAAAHAHAAzAAGAAA{AAHA(AģA33A{AffAA  AA\A33A
=A{AzAA£A\)AÙAzAĸRA
=AřA  AQAQAzAA33AǅA
AǙAǙAAǙAǅAǅAǅAƏ\A
AǮAǮAQAAŅA
A{A
AAA
=A\)AA=qAȸRAA{A33AGA  Aȏ\AHAAffAÙAffA
A
AHA33A
=ApA\AQAQA33AA(AîAģAAAŅA
=A\)AzA(A
A\)A\)AHA(AGA
AQA  AîAA=qA=qAHAAAffA33AAA=qAîA
AA33AŅAQA\)A  AffA
=AɮA{A(AHA
=AGAA
AAffẠAAffAAQAHA\)AHAffA\)AA˙A
=A(AA˅AAHAʏ\A{AɅA=qAʣAHAʏ\A
=A
A
AͮAAffApA
A=qAffApAAGAAƏ\AŅAģAAffA\AAGAHA
=AHAffA{AA\)AA(A¸RAA
=AǅAA  AHAA{A\)AHAȏ\A
=A
=AAA{A
=ApA͙AGA
Aʏ\AHA=qAHAHAƸRAAGAǮA(AȣA33A\)AɮAQAAA˙A
A{A(AQA̸RAHA{AͮAzApAAͅA33A33AHAA{AA
AA{A
=AAGAAƏ\A{AGAĸRAřAŮA33A=qAAÅAzA  AAHApA{A(A
Aď\AAŅAřAƏ\AŅA  A=qA33AîAģAGAAǅAAƸRAAÙA
=AŮAƸRAǅAAAGApAƸRAǅAǅAəA
A{AffA  AŮA{AQAɅAA\)AA(AHAHAGApAͮA͙AͅAGAAͮAQAAΣAHA=qA=qA  A͙AͅA̸RAGA\)A
=AA͙AAͅApAAAȀ\Ȁ\A(A=qA\)AffAʸRAzAAAʏ\A(AɮAɮA(AʸRA{ApA=qAAAəAəAGAAȸRAAGA  A
=A33AAAǅA  A
AQA{AȣAȣA  AȣAGAHAffAɅAAɮA˅Aʏ\AɮAAAAHAAA˙A=qAHAAͅA
A(A{A
=AAAzAУA33AѮA  AѮA  A=qA33AӅA33AңAzA(AHAQAAҸRAҏ\AffAҏ\AzAA
=AQAQAffAAGAAΏ\A\)AΏ\A
=A  A
=AAAQAAGA=qA
=AzA
AЏ\AУAϮAA{A  A˅AəAQA  AθRAAAA˙AAɅApAʏ\AʣA=qAŅAƸRA=qAGAHAʣA˅A
A{A{AəA
AAAHAAQAΣAffA
Aʏ\A˅A{A
AffAA\)AAУAHAхA
A=qAҏ\Aҏ\AffA{AхAѮAAѮAљA\)A{AA{A
AѮAљApA\)A\)A33AУAffA{A  AϮApAAAAffApAҏ\AѮAAңA  AAѮA(A  AQAиRAAυA\)A
=A(AAǅAHA\)A
=AGAͅA=qA{AΣAA=qAffApA=qA
A\)AA{A͙AA͙AϮAϮApAΣA{AAɅAͅAΏ\AGAAAGA
=A
=AzAϙAЏ\A
=A{A\)AGA33A\)AA
AѮAA
AљA
AУA=qA33A33AGA=qAυAиRA33A
AAA33AAGAЏ\AЏ\AAA{AQA33AA(AAHA{AHA
=AA\)A{ApAAAHAͅAAΏ\A33AA{AApA\)AQAɮAAAA33AřAQAřAHAzAƏ\A(AHAAǮA(AAǙA
=A
=AHA{A(A(AAAȸRAȣA  AəA
AzA(AffAGAɅAA
AffAHA33AGA33A33AAʣAʸRAʏ\AQA\)A  A
AA
AA˅A˅A
=AAAAHAffAffAAʣAQAzAHAʸRAʣAQAɅAA(AAʸRA33ApAHA(AHA
AQA{AAQAǙA(AǙA
AAɅA=qAAAA=qA=qAAAffAHAffAǮAA\)AřAQA  A
AGAAAA=qA
ApAAAffAAAQA(AAApAApA{AHApAAA  A=qAʣAHA
=A˙A
A  A=qȀ\AHA
=AͮA
A=qAAGAHA(A
AAA˅A˅A
=ApAAʣA=qAɅAɅAzAAQAǮAA33AHAzAffAHAA  AQAQAŅAřA
AAƣAffA
AA  AffAQAAAffAHA
=A
=AAƸRA{AƏ\AAǅAɅAɅA\)AGAGA
AAzAffAQAQApAffAƣAffA=qA
=AGAffA(AAGAƏ\AƏ\ApA=qA  AɅAɮA  AȸRAAHAAA33AA{AA\)AAHA(Aȏ\AffAȣAzA=qA  AA\)AAǅAGAȏ\A{AƸRAA
=AAAA33AǮA(AzA
A=qAAǙAAAǅAAGAģA
AƏ\A
A=qA\)A\)AAzAǮAȏ\A(AHAA=qAzAAQAÙAA33AAîA=qAģAGAAA  A  A(AffAHAHA
AHA(A{A(A  A33AGA(A£A\)AÙA{AģA
A  AffA33AA
AAA
A  AffA
=AA
=AAGAHAA
=A33AȣAHAQAȏ\AɅA\)ApA  ApAŅA33AGAřAAřA(AAA  AǅAHA\)A33AGA
AîAĸRA
A\AHAAAHAA¸RAAzApAA
=A
AA  AȸRAffAApAAAApARAAARA
AAAA
=A\AAHAA
=A33AAffAzAApAAQAŮApA=qAHA
A(AʸRA˙A
=AʸRAGA=qAAˮAffAGA  ApA  A  A33AǅAəAAAȣA
=AHAzAǮAffA33A  AQAzAQAŅAffAŅAAAAřAǮAǮAƏ\AGAA{AAzAAffAAAǅAǅAAƸRA\)A
AAǙAǮApA
AA
=A(AA\)AĸRA
A
AÅAÙAHAAA{AzAŮAîAÅA{AA(A=qAQAzA
=AAAǅAAzAȸRAA  A=qAQAʣAʏ\AA=qA
A{AA{AиRAЏ\AHAAHAAϙA33A{A{AAA\)A33AA33AGAffAffAQAAffAAAAˮA˙AʸRAQA=qA{A  AGAHAȏ\A
A=qA  AɅAAǙAAQAzAȸRAȸRAA(AǙAȏ\AA
=AʣAʏ\AAffAȣA\)AAǙAHAAǅA{AAA  AA33AffAAď\AĸRAAA
=AAGA33AAGAGA
=A
=AApAĸRAHAřAÙAHAAAîA33AA=qAîAGAAA33AffAA  AHA\A£A¸RAzAAď\AřA  AffAApA33AAA  A
=AAAAzA=qAAffA
AAAAAAApAffAAAA
AffARAA\ApARAQA
A33A
=A{A{AA\)AAAA\)A=qAzARARAHA\)ApAAAA(AARAffA{A\)AĸRA\)AAHAGAffA{AzAHAAA
=AAGAƸRAǙA=qAGApA33AȸRAApA  A
AAAQAAA  A(ApAA=qAHAAAA(A\)AAAAAffAAA\)A{AAHA
=AAA
ARAQA=qA=qA{AzAA33AAAffAHA{A33AzAffAA=qAQA{A\)AAAAffAA  AÙApAŮAƣAƏ\A
=A
A\)AA{A
=AAA33AA  AHA33AÙA{AA
A=qAʣA{A\)A
=AУAffA(A
A=qAҏ\AAѮA{AϮẠAffA
=AHAʣA
AəA=qAA(A(AAƣA\)AAAHAA£AAģAƸRAQAA
=A
AffA{A(AA(AHAGAQAAQAŮAƣAzA=qA
AA  AA(AzAGA=qAA{A(AîAÅAA33AA33AQA(A33AĸRAď\AAÙAAAffAA\)A33AîAĸRA
=AApAƣA  A(AGApAəAAAɮAA  AzAʏ\AʸRA
=AAA33AA
=A
=A
=A
=AA
=A33AAGAffAAɅAɅAAǮA
AAA(A\)AQA=qAffA  AGA(A=qA=qA{AzAHA33AƣAƸRAŅAQA
=A¸RA=qAA  AŮAǙA=qA
=AAApA\A(AGAAffAƏ\AA
AzAəAHAȣA  AƣA  A\)AAAzA
=A33A  A{AƏ\AQA
=AAȏ\AffAzApAAAǮAAA\)AAɮAAGAɅAA=qAGAȣA  AɅAQAQAAAʸRAȸRAȏ\AA\)ApAffAA33AA{AîA
=A
=AQA{A(AAǙAƏ\A
AzAÅAAHAƣA(A  A\AffApA¸RAAzAzAAQAAffA  AA
AzA=qAǅAƏ\A33AAřAffAGApA
=A\)ApAHAzA\)AA{AQAAHA¸RA33A
=A
=AGAAffAǮA\)AAǮAȸRAAffAHA\)AƣAAAƸRA
AAǮA
AffA=qAHAHAȏ\AzA
=AGAAHAəAGApAffAȏ\AHA{A(AA
AˮA  A\)Aʏ\A=qA33AʸRA33AGA33A=qAǙAA\)AGAƣA
=AģAffApAQAffAGAĸRA£A\AQA
AA33ARAA=qAQAGA  AA(AffApAAAA  A{AAAApAA{AAAAARAAHAA33AGAzAAAA\AA\AA\)A  A¸RAAîAGAA¸RAAGA33A\)AHA\A£AzAQAAA(AzA=qAAA(A\AAQAGAAA(AzA
=AAGA\)A=qAAffA33AAA
AzAAAAAAApAAQAAA33AA(A  AA  AA
=AQAAQA{AAAGA  AGAAA\)AAA=qAAA{A\ApAHAAAA
A(A
=AA\AQAApAffAHA£A(A£AGA\)AHA33AGAAGAGAA(AffA(AAA
AAÅA{AffAAÙAîA=qA\)A{A=qAÙAHAA
AAAA=qA
=AQAzA{A{AƣAAAA{AGAģA33A=qAAAQAA(AzAAAffA{A33AzAAffAAAAA
=A
=AHARA{AAAîA¸RAHARAA  AAA
=AGAA(AAîAAHAGAAQAQAǅAƣA33AHAQAǅAƸRAzA33AŅAŮAď\AģAģAffAffA
=AAAA  A
A=qA(AƏ\A  AAAffAzA  AƣAƣApAAAffAQA
AřA  A
ApA
AƸRAAGApAAGAGAffAĸRApAQAAAA33AAA£ApApA(AQA
=AGA33AzAAŮAA¸RApA\A  A=qA\)AGA
A
AAHA33A  A\A
=AÙAA=qA=qA\)ApAǙAffAȣAAffAȸRAA\)A
A=qAʸRAHA33A\)AʣA\)AʸRA\)AA˅AAəA\)AffAAA\)A
AʣAA˙A\)AʣA(AʣAAAʸRA(A33Aʏ\AQA=qA{AɮA=qA
AȸRA(AɮAəA\)A33A(A  AȣA  AffAɅAAəA=qA33AffA=qAAGA  AzApA{AAAȣA
A(A
A(AHAĸRA33A\)A  AƣA\)AAƏ\AHAAƣA
=A\)AA  AŮA(AHAffA{AGA
A  AffAQAQA=qA=qAǮAǙAA  AAǙA\)AǅAAHAHA
=A33AƏ\AzAA
=AAA\)AǅAǙAǙAǙAǮA{A=qA
=AzApAA=qA(A
=A  A\)A
=AAHA
A
AŅAǮAQAA¸RAAGAģAQAA=qA=qA=qA=qAAffA¸RA
AA
AGAffA=qAAHAffAAîAGAAA¸RAAGAAÅA  AHAřAƸRApAA33AɮA
AAʣAQAɅAHAHAGAɮA
AˮAA(AffA{AQAzAzAɅAAAA33A
=A33AAȏ\AȸRAȸRAȏ\A
AffAQAȣA(AAGAƣA
=AAAApAǅAA
AzA\)A\)A=qA
AAřA\)A33AģAď\AîApAAîA\)AAzAĸRA\)AGAÙAÙA  AQAzAA  ApA  A(AffAQAAAŅA\)AAApAApAAģAAAƏ\AffAffAA  AAGAŮA
=AǙAApAŅAAřA  AzAƏ\AGA  AřAA=qA  AHAAA=qAƸRAffA{A  AGAŅAřAřAzAA{A£AA
=AAA
AffA\)AAzA
=AGAA(A
=A
=A  A
=A¸RAAřApAAģAffA{ApA(AffAAffA\)AGAAQApAAHAÅAffAď\AA\AŅA
=AģAHAAîA  AAHAzAģAA
=AGAŅAŮA=qAA33A(A{A(A=qAffA(AAGAƸRAA33A{AffAA
ApA33AƣA
=AǙAA
AǙAǅAǙA\)A\)AHAĸRAƏ\A33AřAAAAHAď\A
=A=qAffA  AzAŅA33A33AÅAAAzA{A
=Aď\A{AÙAîAģAAÙAAřA
AŅAGAGAGAGAŅA\)A=qAAGA
A33A=qAQA  AǮAGAAǮAȣAQAAAffAHA\)A
=ApAffApA  A(AΣA33A33AGAGAAA
=AA33AϙAAQAAЏ\AȀ\A(A\)AQA33AͅAΣAAAA=qA(AQA\)A33A33AɅA  A(AəAȣAffA(ApAGA  AzAʸRA{ApAzAA
=AȸRA33A33AǙAHAʣAʸRAA=qA˙A33AA=qAAA˙A˅ApAȸRAApAffA  A=qAA(AAɅAzA
=AGA33AHAzA=qA(AffA{ẠAA
=AGA  A=qAAϙA  AQA33AљA{AQAҸRA{AңAffAЏ\A  Aҏ\A\)AҸRA{AffA=qA(AAA\)AzAApA
=A  A(AQȀ\AHAQAA\)AȀ\AͮAθRAQAzApAAffAΏ\AHAffA=qA=qA˙A33A=qA=qAA˙AAGA
=AʸRAffȀ\AQA33Aʏ\AəA
=AHA
AA\)AřAApA{AAzA
A
=A
=AǮA=qA
=AAəAffAʸRAʸRAHAA˅ẠAˮA˙A(A=qA  A(AЏ\AA33AAУA{A㙚ARA33A\)AAיAA˅AˮA(A(A(A  A(A=qAffAˮAA  A  A33ApA33A{A=qAɮAȣAffAA
AǮAAGAA=qAffAŅAffAĸRAAzA33A
=A{AApARA
=A33A=qAzAffA33AGA\)AƏ\A\)AHAA  AȣAǮA=qAA  AȣAAQAAHAffAÅA=qA
AÙAA\AQA
=AA  AAAAA(A
=ApAAď\AAAƏ\A\)A  ApAɮAA(AQA
AHA˙A\)AGA33AA˅AˮAGAAHAzAHApAAǅAffA˙AʣAʸRA{A  ApA
=A  AîA=qApAHA
=AƣA  AzA  A=qAAAAģAzAGApAQAQAQAQA=qAď\AÙAA£A£AQA£AA
=A£AGA¸RAAGAÅA{AA\A\AA£A(AîAď\AAGAÙAƏ\AŮAA\)AffAAƏ\AzAzA=qAzAAǮA\)ApAʸRAʏ\A33AHAzA  AAQAQAHA
=AA˅A̸RA˙AQAzA33AˮA˅AAAˮA˅A33AHA{AGAAǙAGAA
=A{A
A
=AGAAAGAǮAAǅA\)AǮAAǮAAAAzAQAffA=qAffA(A=qAƏ\ApAffAzAƏ\AffAffAQAQAzAA33AǅAAHAǅAGAA\)AƸRA(AAffAGA
AQAřApAřAA33AŅAĸRAĸRAHA
=A33AHA\)A33A
=A33Aď\Aď\AŅAQAŅAģAŮAzAAĸRAŮA
=ApA(AGA(AA33AQAzA\AÅAffA
A\AÅAzA
A
=AA33AA¸RAA¸RAHAA\)AA  A{AzA\)AģAAAÙA=qA(AA\)A(AAAAzARAApAzA£AGAAzAA¸RA
=AGAAzAffAAA
A33ARAffA\AzAAAHAAffAApA  ApAffA£A33AAǮA
AƣAA{AŅAƣAǅAǮAǅAGAǅApAǅAǙAA{A{AǅAǙA  A  AǅAǙAǅA\)AAzAAŮAA33AîAzAĸRAĸRAQAĸRAģAQAzAA{A33A33A(ApAA{AA
=AA\)AA{AAAAffA¸RAAGAAAffA\AffA  ARA
A{ARAGAA  AAzApAA\)AzA
=A
=A
=A\)AQApAAAÅAGA{AĸRAŅA33AAHAffAQAƣAGAƸRA\)A33AGAAAQA
Ȁ\AHA̸RAA˙ApAGAAʣAHAAʏ\A=qAəApAȸRAA
=AHA  AɅAAȣAǮA{A33A  AÙA  AAA\A{AApAAQA(A{AQApAAŅA\)AzAA{AHAzAzAÙApA33AA  AAAAģA33AAŅAAƸRAAA=qAģApAAAƸRAHAzAQAA33A¸RAA\)ApA33AĸRAAQA{A=qAffApAAǙAAAǙAzAȏ\AAAzA33A
AƣAAA\A=qAǅAGA=qAƏ\AzA
=AzA33AA\AA¸RA\AGAQAzAGA\ARA=qAA{A
=AîAGAA
=A  AAA(ARAA{A=qAffAA  AAA(AAzAAAA\A(AAA=qAGARA¸RA£AApAÅA33A=qAA\ARA33AAA£AHA  AAzAHA33AzAŅAzAʏ\AAzAA(AʸRAffAAəA
=A(ApApA
=AA\)AƸRAAAAGAʏ\AʸRAHA˅AAA33A
AGAƸRA{AApA
=AA
=A\AGAHAA{A33ARARARAAAAHAApAAA\)A=qAA(AGAAAHA33AGA{AGAAď\AHA\)A
A=qAA£A=qAHA{A=qAzAHAQAAHAîA
A(AzA=qAzAApAA33AA  A=qAĸRAģAAA
A(A(AƣAƣAƸRAƸRAzAffAA(AffAƸRAAA(A=qAQAŮA
AřApAŅA\)AAģAģA  A
A\)AA  AGAAffApA{AzA{A£AÙA
=ApA\)AAApAîA\AAA  AAAQA33AAApAffAA=qA=qA\)AAAHAQAAAApA
AGA=qA  A(AA  AHAA\A(AA  AzAģA(AQA(A{AA(AQA33AHA\)A\)AřA
AA  AƣAHAA{A  A  ApA{A{AŮA  AģAģA
AAAA{AGA{AAA=qA=qAHAzAAzAA{AApA
AAAA=qA33AGA33A33A\AQA\A{A\)A{AA33A\)A33AGA
=AGAHAHA\ARAHAAAGAAGAAA  A
A{AzAAA\)AAA
=AQAAAAzAHAAA  A  AAAA¸RAA33A
=AA£AQAAÙA  AA  AQAAApA\AAzA{A£AAGAAÙAAzAAA=qA
=A(A{AAAffAA
A\)AGA33A{AA{AAAAA\AA\)A
=ApAzA=qAA(A\AA33AA\A=qA(ApA{A(A33AARA
=AAffA=qARAQAA(AA(AAAAQAAzAAffAA
AA33ARAApApAA
=A
=A=qAGAHAA
A{AApAAA
=AA  AA\A
=A\)ARA
=ApAffAHAAAQAAA=qAAAAAffA  AzA=qA(AA
=AzAA\AAzAQA
A=qA
=A
=AA  AQA=qA
ARAzAffAAGA\AAHA33AAA33AAA  AA\)AzAA\AffA
AzAHAAA33AAA33AA
A{ARAQA
=A\)A
AQA
=A33A\)Aȏ\AHAQA(A\)AHAApA
AîA
AHAAAAzAffA33AAA
A
=A
A\)A  AAAHAGAApA  AQARA  AAGAHAA=qAQA  A\)AGApAGAAAQAffA
=A  A=qAffAAAA
=AA
=AA\A=qARA33AQA(AzA33AQAffA
AAzAA{A  A\AffAA
ARA(AA  A=qAA33A  AîAAAffA
AHAŮAA
=A
=A
AAAģAģAģAď\Aď\A˙AÅAƏ\A
=A
=A̸RAAAAHAGA=qA{AffA
=AA
AA{A(AAApA  A
AzAffA
A
=AffAƸRAA=qAřAŮAAGAA{A33A=qAHAffA33AffAGAffAGARAAA
AffA\AAAGAAzAÅA  A\AAGAzA\)A(A=qAƣA\)A
=ApAƸRApAQAApA  AQA33A˅AˮA
A=qAA(ApAHA
AffAģA
=A  A(A\)AzAA33A  A{A\)ApAQApAA(AAHAzA
=ApA  A
A33AəAȏ\AƏ\AzAəAA
=AAAAÙAA(A\)A=qApAGAA\)A\AffA
=AÅAA33AHAAA33AAAAApA\)A
AAA\)A=qAHAA=qA
=AA=qAHA\)AffA
A=qARAAGA£AzAAQAQA33A\)A
A  A{AA=qAˮAA  AAGA
A33AɅA  A=qAApAGA  A  ApAAA=qApAəA33AHAAɮAAHAȣAffAAApAffAʏ\AəAʏ\A(AApAA=qAGA
A(AŅAAAHA\AAGApA  AA(AA(AGA
=A\AAHAAA=qAA33AAHAzAîAA33A{A(A{A  AApAAAzA
A(AA{A
A33A¸RAÅA=qA\)AffA
A=qAƸRAQAzA(A33AəAQAʣA
=AAȏ\A33A
=AAAʸRA=qAɮA  A  AʣAQAəA  A£ApA
A  A{AAAÙAAŮAGA\A33AzApAAǮA{AƏ\A{AƸRAƣA
=AQAŮAA£A  A
AA\)AApAAAA33AGA\)ApA\)AAHAzAA{AA33AŅA
=A33A=qAŅAȸRA\)AAGA33AAĸRA{AHAGAzA{AHAŅA=qAǮAȸRAGA˙AHAAAA  AѮAAѮAҏ\AУA{A
A33A
=A33A
=AGA{A(AΏ\AΣAffAffA(A{A
=AGA˅A  A˙A˅A  AAApA=qAzAGAQAA
=AA=qAGA(A33AAƸRAǙAAAA33AA
=AAîA(A\)AǙAřAQAGA=qAAffA(ApAAGAGAAA\)AzAAGAǙAǅApAƸRAǅAAȸRAȏ\AAAŮA
Aȏ\A  AffAȸRA(A{AǮA{ApA{A=qAǙAHAzAƣAAffA=qA
=AQA33AGAzAHA33A
=ApAƏ\AzAƏ\AQAƏ\A33A=qAƏ\AƣAƏ\ApA  AģAřAA
A=qA(AzAAzA=qApAÙAAQAAĸRAA
AA{A{AA=qAAAA\)AƣAƣA  A
=AAŮAA\)AHAffA\AzAA{AzAGAQA33A\)AAÅAHA
A\)AAǮAƏ\A=qA(AffA(A(AQAAHAzAA
=A\)AAHAĸRA  A
AzA=qAGAǙAAzA
AǅA(AzAA(A{AƣAHAffAQApAHAQAƸRAƸRAƸRAA  AÙA£A{A\)AÅAAAAď\A33AzAŮA\)A(AGAGAGAA
=AƏ\A(AffAA
=AffApA\)AzA
AQAQAď\ApA  A(AƣA\)A
=Aď\AA=qA¸RA=qA{A33AGAA\)A33AƏ\A
A\)AřAffAAA\)A(AffA
=AAAGA{A33AȣAffAƏ\A{A\)AAA33AřAŅApAǅAAHAQA(A{AQA(A\)A\AAffAAARAA(AîA  A(AA=qA=qA  AAAzA=qAARAAAffAAď\AAAA=qA33A
=A
AQAƸRA  ApAzA  A
AGA\AĸRAffAîAAQAÙAAAQARAA\AA\)AAAAAffAA
AGA
AģAģAHAAGA  AƣAHAQAƸRA\)AA{AzAHAʣAʸRAʣA
=A33A
=AǙAŮApAÙAÙAQAĸRA
AAHAffAAzA(AA
A33A\)A\)AzAzAŮAzAŮAA
AAÅAAÅAA
=A(AAAǅAAzA=qA(AHAA(AǅAƣA
=AǙA\)AȣAzAď\AîAzA(A(AA\)AAA¸RAÙAQApAHAffA\)A(A=qAHAAA(AQA(AAHA33AģAzAÅAģAŮApAŮAHA(AzAQAAzAA
=A
=A  ẠAA
=A̸RA
=AʣAzApAAÙA(A
=AřA
AŮAGAApA
A33AHAÙAď\AģAApA33AȸRAǅA
=AÙA(A(AA
A=qApAģAAA  AŮAHAQAQA
AAƏ\AA33A  AQA
=A
=AŮA
=A\AA=qA\)AAƸRAʣAA{A\)A
=A=qAHA
A33AA  AzAQAAA=qAAHAAffA
=A
=AǮAA
AƸRA{A
=AGA\)AA=qA{A˙AAA(AffA  A
=AǙAŮAȏ\AAəAAGAAʣAǮA\)A33AHA\)AAǅA{ApA
A{AŅAAǅAǅAzA(AǮAŮAƣAffAApAAģA{A
AǅAAA
=AA
=AAA(AA(AƣAƣA33AQA=qAŅAƸRA33A33A33AHAGAŅAƸRAGAƸRAƣAApAŅAHAHA=qAffA33AQA=qAƸRApAzAȸRAAQAʏ\AA˅A=qAA͙ApAAAA=qAAˮAA{A
A(AAɮAAȣAzApAȸRAzApAGA\)A\)A
A(A\)A
=AƸRAzAHA\)A  AAA
AGAGA\)AřA(AffAʸRAA
A=qAffAɅAQA\)AA(AGAȣAǙAřAŮAHAAAGA\)AǅA
A(AǅA\)AA=qAzAƸRAzAƣAƏ\A{AîAffAƣA{A
=A\)AƏ\AǙAAHApAɅA
=A\)AɅAɮA(AffAʸRA33AHAA˅AʣAA̸RAAA
=AffAGAA{AzAApAAˮA{AɮAȣAQAGAȏ\AHA{A
AAȣA=qA  AȣAŮApAȏ\AAffAA\)A33A  AHAƣAzA=qAGAQA˙A  A33AˮA=qAA{A33A\)AģAzAA
=AƸRA
=AAȸRA  A33AQAʏ\A(AƸRA33AzA
=AA
AA
AȣA
=AɅAǅAzA
A\)A\)AHA
=AAď\AģAGAƏ\A  AǮAffAAHAÙA33A(A=qAHAA
=AA
A
AAAQAģAAAAřApA  AəA=qAɅA{A˙AA
=A˙A{A\)AzAAffA=qAAffA  A33AȣAffAzAQAApAŮAffA=qAGA  AQAȏ\A33A(A{AřA=qAQAA¸RAAA33AHA\)AAA(AģA
AQAzAzAffAHA{AzA\)A
AƏ\AȣAHAAAQAəAQAQAA
=AGA
A{A(AzAAAGA˙A
A  AQẠẠAA̸RA̸RAHAHAHAHA\)A\)A\)ApA
=AffA33Aʏ\Aȏ\AffAAQA{AQAA\)A
AƏ\A{AQA33AApȀ\AAɅAƣAAAŮAGAAǮA(A{AA  AffAɮAGA=qAAffAGApA=qAřA  A
AffAəAAəA
AAɮAʣAAƸRAzAǅAəẠA
AffAzAzAAA33A  AffA33AəAAʣA
=AAˮApA
A  AȀ\AAͮAͮAA{A{A  A{AAͮAAA(A
=A=qAQAAAˮA˙A{A(A(A=qA(A˅AGA˅AA(Ȁ\AA̸RȀ\Aʏ\AǮAAƸRAƣA33AAƏ\AAˮA=qAAAĸRApAəAHA33AAʏ\AAˮAAAƣA(A
Aȏ\AAA͙AAffAΏ\AΏ\AA=qAQȀ\AffAAffAQA
AA\)AɮAɮA  AʣAzAGA
=AAGAffAA
=AʸRA\)ApA33A˅A\)AGAGAˮAGAˮApA˙A33AHAʸRAʏ\A=qAAAAȸRA33AAəAGA
A\)A
AAîA  A33AƏ\A=qAHAAQA
=A=qAAAA=qAAǮAƣA
=AQA{AQA  A
A{AƏ\AA
AzA
=AA
=AAŮA
A=qAAGAzAģA{AzA33A\)AHAřAGA{AHAɮA{AQAɮAɅAHA\)A
AʣA˅A{AHA=qAAЏ\AffAAzAңA(AAԣAAA\)AQAffA{AQAA
AЏ\AQAQAͮA(Ȁ\AzA  AA\)AAAʏ\AHA33A  A˙A{ẠA{A(A  A
Ȁ\A{ApAˮA
=A˅A
AẠAffA{A˅AzA(ẠȀ\A33AAHA\)A=qAǙAHApA=qA  AĸRAŮAď\AAffAffAffAǙAǅAHAA(AǙAď\A{A£A
=AHA
=A{AŅAHAĸRAGAzAď\AHA\)A  AƏ\A=qAzAQAAřAAAGAǅAAAAAAHAHAƸRAƣAAǙApAAGApA{A=qA¸RAA\)AzAAÅA\)AGARAQAQARA\)AAHA
=AA(AĸRAQAGAƣA(AŅAAA£AHA{AApAAARAAAAA(A{AHA¸RAÅAîAHA
=A=qAA(AAAAApAA(AAŅA=qAAɅA
A˅AͅAzAzAffAͅAͅApAHAA
=A  AzA(A  AθRAAA\)AQAA
AA
AffAffAQA(AθRA
A\)A33A
=AA(A  AGA(AApAffAffAzAAǮAGA  AəAApA˅Aȏ\A(ApAȣAA=qAAGA
AΏ\A=qAzAApAQAAǅA
A\)AʸRAAď\A
AzA=qAɮApAˮAAHA
=AɮAQA˙AȀ\AQA{AAA
AzA{AЏ\AA(AA
=A
=AA
AA(AAApA
=AԣAAAzAәA
AffA  A33AυAAхAGA
=AffẠApẠApApAzA
A͙AͅA͙AA{AzAGA(ApA˅AAHA=qA\)AGA  AzAAQAʏ\AAHAAʣA  A\)A
AQA33AAƏ\AƣAAəA=qAʣA33A˅A˅A(Aʏ\A{AA˅ApA33AA{AʣAApA˙A˙A
AA{A{A=qA=qAA
A˅A˙AAAʏ\Aʏ\A˅AAAA{A(AA
A
AAA
AˮA˙AHAffA
=A
=ApA\)AȸRAʣAAɅApAffȀ\AA\)A(A  AA33A=qAAA
A(A{AəA{AAAQA(AŮA(AîA=qA{AÅA\)A\)A
=A\)AƸRAA33A33AGA=qAAA\)AȸRAAHAzAA33A(A(A\)AAƣAHAʸRAAA\)AffAɮAɅAəApA\)A33AGApA{A=qA  AʣA
=A33A33ApAGAʸRAAzA{AəAAAA33AA{Aʏ\AHAHAʏ\Aʏ\AʣAʣAzAGAQA
AɮAȏ\AAzAɅAɅAzA
=AffA
A
AffAHA{AƣAřA  A(AȣA{A=qApApAAAA(AA{AƸRAƸRAA\)A
AAɮAȣAAȣAAffAQAƸRAƸRAAA
=AffAAȸRAzAHA˙AAGA(AAA=qA  AHAHAυAϙAA
AAffAЏ\AЏ\AϮApA(A\)AAϮA
A(AQA
AϮAA\)AΣAzA̸RA
A̸RA˅AA
AHAəAGApA{AQAHAəAɅAAHA
=A\)AHAQAǮApAAGA{A(A
=A=qAApA
=A(A
A\)A
AGA{AAǅAGAA\)AʸRA\)A(AzA  A=qAA33A
AzAzAA{A\)A33AAGAȏ\ApA{AQAAA(AApA\)ApAA(A=qAGAA(AA\)A(AģAŅAŮAQA(ApA  AƣAǮA  AȸRAzAzA
=AȸRAəAGAffAɅAzAŅA=qAAAHA  AzA\)AA(A(AHAA=qAAQAA=qAŅApAzA{AzA  A  AGAGAA{AAGAƏ\AǮAAzA=qA
=AǮAǅA\)Aʏ\A
A33AA
=A33ApAA(A{A(AApA{AHAGAffAzA(AQAAQȀ\AA\)A͙A
AAffA
=AA{A33AGAəAAAHAffAGA{AA
AA\)A  A\)A  A(AHA33AA=qA
A(AA33A33AŮAffAĸRAGAAřAHAƸRA{AřAzApAď\AģAGAQAƸRAHA
A  ApA33AřA\)AAffAAƣAĸRA{AɅAɅApA\)ApAAQAȏ\AAAHAAQA=qApAŮAAǅAQAAHA{A\)AzAzA
=A(AAA{A=qAzA  AəAzApAȣAzAɮAffAAGAʸRAHA\)AGApAGAƸRAHA=qA˙AɅAffA˅A
AɅA  AɅA(A=qA(AƏ\AffAƣA{AA33A(A{A
AAǅAA
=AȣApAffAQAAHA=qA(AApAəAʸRAəA(AGA{AA͙A(A
=AAAffApAģAGApAffAQAAʸRAQAHAGA33AɮAəAȣAffA
AHAHAAȣAHAA(AʣAAʣA33AQAAAƣAzA
=AǮA
=AŅA
A(A
A  AA
A33AAA
AŅA
=A\)AzAĸRAǅA{A
AAAŮA  AĸRA  AHA{ApApAƏ\AƣAĸRApA{A33AAHAA\)AAǙAǅAAɮAA{A
=AzAĸRA
=A
=AAA
AƣAHAApAGA\)A
=AẠApA˙AʣAA33A{A\)A\)AAǅA{A=qAʣA33A  Ȁ\AA33A͙A  A=qAzAΏ\AΏ\AθRAHAΣAQA  AA(AffẠAffA
A{AHA  AA\)ApẠAAϮA{AϮApAHA
=AAϮAͮA  AθRA
=A33A(AffApAAzA(A{AGA  AffA˅AQA(A̸RAA33A
=AGẠAˮAAȀ\A  AAAHAzAQAGAȀ\AA͙AAGA33AϮA=qAQA
AθRApAHAAAAˮA{AʣAəAẠA  AHAυAυA=qAzA
=AzAʣAθRA  A(AzAA{ApAθRA  AHAʸRA{AHAAApA  A  AθRA{AzAϙAΏ\AΏ\A͙A33A̸RAAˮAA(AAHAApAHA=qAQAffA˙A33AˮAAˮA33A{AɮAȣA
=AȣA
=AQA{AHA
=AAA{AQA\)AA33A
A(AQAGAẠA=qAʣAApAAͮAA
=A\)AA33A˙AAA{A{A  AͮAAA(AA33AffA̸RA=qAǮA
Aʏ\AffAAǅA33AQA˙AAGAΏ\AẠAffAAAHAA(A\)AAffAffAA{AzAHAHAŮAAffA\)AǙAzAȸRApAƏ\AAģAGA(A
AģAffAřAzApApAAGA  A
=AHAƏ\A  AAǅAƸRA  AA=qAHA
A\)AA  AAzA
A
=AA\AAQApAApA{A£A(A  AGA
=AȸRA
=AA=qApA=qAəA33A{ApAzAzA
=A33Aď\AřAǅAAȸRAffAAffAəA{AQA
AHA\)A33ApA  AA£AÅA¸RA
AÅAGA
AHA  AÅAA{A{A33A{AǅAǅAAǅAǅA
A  A
=AffA{A  AAAA
=A33AǅA\)A(A33A˅A\)AAˮAA˙AAAAAAA{A{A  A  A  ApAGAzA
AɮApAAQApA
=AɮAʣAAAǙAǮA
=A\)AřAffAQAřAHA(A
AA=qAQA
=A(A{A£A˅A˅A{AθRAϮAzA=qA{AQAʣAffAA
A=qA{A
AиRA  AУA33A{AzAGApAљA(AΏ\ẠẠAAɮA  AAGAAffAAͮA̸RAQAAʸRA(AzAA=qA{A
A\)ApAəAzAAAffAʣAAAď\A
AîAzAƏ\AQAƸRAƸRAzAɮA\)A=qA{A=qAzAzAȸRAGAA  AƏ\A  ApAGAA  A(AȸRAAQAƣA{A33AAzȀ\A  AͅA=qAAQA
=AAA
Aʏ\AAA
=AQAAGAQAřAQAAʸRAʣA\)AffA  A33ApAA=qAȸRAAzAˮAAʏ\A(AzAȏ\AƣAGAŮAĸRA\)A\)AffA
=A{Aď\A
=AA=qA
A\)AAApA\AQAQA\)AzAĸRAffA33A
AzAAA\)AƣAAʏ\ApAffAAʸRAffAAzAHAAAAAУAffA
=AAA
AϮAGAҸRAҸRA\)A\)AAՅAԸRA
=A\)AծA(AApAЏ\AAHAffAffAAQA  Aȏ\AAΣA  A\)AĸRAAAHA33Aʏ\AQAA
=A(A{AffAθRA(AA33A33A{AǮAA
=A{AA
=AAAQA
=A  A=qAQAʣAHAθRAA(A
=Aʏ\AGA=qAAΏ\AхA  AGA͙AA(AzAA33ApAA{A=qAAAffAθRAA33AA=qAzA  A͙AHAɅAQAffA  Aʏ\AA=qA(A
A  AЏ\AУA
=A33A
A33AHAəAGAˮAHA=qA=qA
A̸RA33A{AQAΏ\A=qA=qA
AɮAA\)A=qA{AQAHAGA(A{A(A=qA=qAA{AHA(AəA(AA  A\)AQAGAQA\)AffȀ\AˮA{Aȏ\AApAθRA
AHAApAzAzAAˮAAzAΏ\A˅A33A͙AΣApAzAQAffAQAA33AGApA͙AA{A(AzAυA(AQAffAAAУA=qA(AA
A33AAAAQAͮA(AffA\)A˙A\)A˙A33A33AffAQAəAʏ\AəAɮAɮAʸRA(AʸRAʏ\A  AɮAʏ\AʣAQA  A
A(AAȣAGAȸRAɅA=qA=qAA  Aď\AAȣAƏ\A33AǅA  AGA{AHAzA
A
=A
AAAAљAӅAGAAGAGAAAzAGAAzA{AzApAȀ\AQAGAAңAңAQAAңAУAApAAAΣA(AΣAA
AθRA\)AAffA{AA33ApA{A
AHAHAffAˮA̸RA̸RAA33AA
=AHȀ\A(AA
AA
AǮAɮA{AHAřAAÙAŮApApA\)AɮAzAHA33AAzAHApAAAϮA  AffAAиRAAQAAAAA\)A
A
=AӅA33AffAAffA(AAA  AѮAѮAхAхAAffAQAAGAAϙAϙAzAA
AQAQAffA(AϮAAͮAΏ\AΏ\AAA
=AϮAAA͙AA
=AΏ\AQAQAQA˙AˮAzAͮAAAQA(AAffA33ApAΣA\)A
=AGA(A=qAΣA{A=qA{A{A
AхA
=A(AzA{AυAΏ\AΏ\AA=qA\)AʣȀ\AAffAAHAAхAzA
=A\)AA
ApApAHAA˅A˅AAGA
AHAəAA˙AApA33AA=qAΏ\AA(A=qA\)A{AA33AʸRAHA  A\)AAAʣApAAυAҸRA33AңAAA
=A  AHAzAәAffAAAffAӅAffAHAGA33A(A(AծAA\)Aԏ\AGAA
AѮAHAѮA{AzA33A33A
AӅAхAиRA
AGAϙAУAA\)AAҏ\AA\)A33A֣AGAA
=AQApA(AУAљA
AAHA
AHAQAυAA{AAиRAQAУAQAиRA
A=qA֣A
=A֣A33AԸRA33AA\)AffA\)A{AzAA=qAffAԸRAԣA\)A
=AծAQA֣AA  A(AHAA\)AzA֣AHA{A  AיA׮AAיAՙAѮAHA{AׅAҸRApA{A(AGA=qAԏ\AAQAzAffA33AQẠAҸRAQAHApAAԏ\A\)AծAծAՙAA
AffA  AGAͮA  A  A{AAffAУApA
=AAzAGA{A
=A{AAAAAиRAљA33AA=qA
=AffA  AA33A=qAAQAAAѮAҏ\A
=A  A{A33AA33AAծA=qA
=A֣AAҸRA{A(AA=qA=qAGAGAΣAQA{AУA{A(AхAffA\)AAQAffApAͅAљAA\)AͅAA
=Ȁ\A
AA\)AQAϮAHAQAGAΏ\AzA\)AϮAυAϮA
AAA(AQAA(A33A{A˙A͙A
=AͮApA33A33AʣAȸRAɮA(AȸRAȣA
AQA=qApA
=AHAAɮAzA
AQA{AA˙A(A
A33A
A{A
AΣAϮAzA
AffAͮA
ApAиRA33AA
A  AAУA  A=qA=qAAΏ\AzA33AA̸RȀ\A͙AzA  AHAA(AffAHAAzAApAzAA33AAzAAAAǅA
A\AAARAÅAŮAGAAHApAAQAHAʏ\AA  A(AɅAAzA
=AAffA
A{A
=AGA˅AzAA  AzAGAzA
A{AffAHA˅AQA
=A
=A\)AA
A(AAΣA33AУAẠA˙AAˮȀ\A33A\)AzAQAQA\)AffA\)AиRAυAϙAHAQAGA͙AAȀ\AˮAA  A̸RAzAAΏ\ẠȀ\A\)AA̸RAffApAQAHAAAGA=qA=qA͙A33AˮA
A(AffA\)AʸRA
=A
=AHA33ApAHA  A33AǮAAA  AƣApA
AAzA\)AQA\)AˮAGA˅A
A̸RA
=A
AQAHAAHApA(AϙApA=qA(AͅAA  A\)A\)A
AθRA˅AУAAУAHAхAA=qAәApApAҸRA{AA\)A  AffAљAffAHA33AAApAAffA=qAA=qAԏ\AA\)A(AѮAAAGA{AzAffA{AA\)AAHAzAA
A(AȣA{A\)A=qAA=qAȏ\AQA=qAA
AQA  AQA  A
=AAA(AffA  AɅA  AəApAAA  AA˙A(A33AA
=A=qAHA33AυA
=A
=AHAQAGA\)AffAHA\)AυApAGAAϙA  AϮAAϮAυAϮApA(A̸RA
=A{AˮA
=AAQA
=AͅA  AAA
=A
=AA(AΏ\A  A{A
=AẠAəAʸRAHAHAA
=AхAffA
AffAAA\)A̸RA(AA{A=qAA{AAGA
=AGAA
A\)A=qȀ\A=qAʸRAɮAAzAGAAzAΣA̸RAA
A  A=qA  ApAA
Aҏ\AzA=qA{ApA  Aҏ\AѮAHAzAQAңAA=qA
=AͅAQAQA  A  A(ẠA=qA\)AzA
AffApAQA
A(A
AA
=A(A˅AˮAA(AQAͅAA33AffA=qAA\)AAA  AȸRAzAA\)A
=A33A\)A  A{AGA
=A33A=qA
=A33A
A33A\)ẠA33AͅAͮAθRAHA33A\)ApAAHAGA
=AzAAGAAAAzA
A
A
=AHA\)A  AffA
A\)A
A
=A=qAAAA33A33ApAffA̸RA=qA˙A33A=qA\)AʣA(AA=qA
AA{AzAA{A\)AȸRAȸRAGAȣA\)AQAAHAHAzA
A=qA(AAQAzApAHAA  A(AAAQA{AͮAffAGAAAʏ\AQA=qA
=AzA˙A{A33AʣAffA\)A
A˙AɮApAəAɮA  A=qA{A
A  AQA(AQA=qAQAA
AAA(A=qAˮAɮȀ\A
=AθRAGA
A\)AffA  AQAzA{A=qAApAAAA33AQAəA
A  AHAǅA
AģA
=A\)A\)A=qAHAQAzAƏ\AɮA{AQAA(AɅA\)AQAA
A=qAQAA33AGAQAΏ\ApA33A
AΏ\AAHA
=AϙAA=qA=qA
=AQAθRAθRAffA=qAffA{AGAzA\)A
AɅAʏ\AAA˅AGAͅAHA  AQA  A=qA{AGA
A
A33AHAȸRAȣAAǮA  AǮAǙAAA(A
=AAAffAɮAQAA33AHAffAϙA  A(A
A(A  A{AApAυAGA
=AzAͮApApAzAzAQA=qA̸RAQAAΣAΣAΣA\)A=qA=qA  A(A(A{AA{AͮA33A͙AͅAAAA=qAHA33AQAzAffA  Ȁ\AffAQAQA  AAA˙AA
AɅA{A  A˅A33AAGA\)AA
A
AGAGAGAzAAˮAřAĸRA(A˅AɅA\)A
=AzAAA  A33AˮȀ\AA̸RA(ApAA\)AхAхAA(AQAQA\)AHA=qAΏ\AAAzAA
A(A\)AffAffAA
=AHAAˮA˙A̸RAυAGAA  AA͙A
=AHA\)AͮAGA
=A˅AGAHAA{AHAHAA(AǅAAffAAHAƏ\AAHAǙA33AȣApAGAȣAffAA=qA
=A{AȸRAAAȏ\AzAɮA\)A\)AəAQAA̸RApAΣA\)A{AQAffAAGAAzAңA{AApAAA\)AHAӮAQA(AҸRA  A(A
A  AAffA  AУAApAљAffAA{AffAϮAQAЏ\A
A(AAQA(AңAQAA\)ẠAA\)A33A\)AHAAzA33A
=AHAA=qAϙA  A  A{AA
AΏ\AAzAffAA33A\)AәA\)AӮAՙAAQAԏ\ApA=qA
A{A
=AHAA{A(AGAָRA֣A{AAӅAңA
=AAӮA
AәAAӮAAAAGAA{AAҏ\AA{AӅAӅApA33AGAAAAAѮAυA
AGAAAиRA
=AzAzȀ\A=qA
AffA33AzAzẠA33A͙AͮAAυA  A(AA=qAΣApAzAAҏ\ApAAхAA(A(A=qAHAGA  A(AQA{Aԏ\AffA(AQAиRAA{A(A(AϙAGA(A
AѮA{AAҏ\AApA{AA\)A33AHAA=qAͮA  AӮAGA
=A33ApAՅA{AA\)A
AA  AθRAAffAͅAͅAA\)Aʏ\A\)A
=A  A33AƏ\A  AA=qAzAzAGA  AGA(A  A\)A
ApȀ\A
A
=Aҏ\AA  A=qA{AQA
A33AGA{A
=AffAQAzA(AԣAzApAA{AAAGAѮAAzAGAzA=qȀ\AAЏ\A  AϮAиRAAAυAΣApApAУAA
AA{AHAA{A  AHA
Aʏ\ApAAAApA\)AQAA  AffAA{A=qAAffAȣAQA
AƣAQAzAAAGApAʣAA=qA\)AA̸RAȀ\AQAQA=qA
=AffA{AͮAϙA
AGAzAҸRAA33AAAA{AA\)AӅA33A
=AAңAzAӅAzA
A  A(AәA  AzA(AA=qA(AQAHAHAAQA{AQAAȀ\AAffAzA\)AAzAzAffAHAͮAͮAˮAʏ\AzAzAʣAʣA33A
=AˮAA
=AAɅA
A\)AɮAȀ\A{A{AffA
=AϮAЏ\AУA33AffAA(A{A(A
AAʏ\AA\)AˮAHAHAGAApAzAΣA\)AA\)A
=AAHȀ\A͙A(ẠAzAQAA\)AAzAHA{AθRAAͮAzA=qA{AffA33AAffA\)A\)A
A  AA{ẠA{AffA˙AzAzA(AAffAΏ\A=qA͙ApAAȀ\AυAυA\)AυAA(AAAυAGA
=Ȁ\A\)ApA\)A(ApAAGAˮAʸRAʣA(AA33A33ApAHA33ApApA
AA  AAAθRAffAA
AAͮA(AΏ\A
AͮAAΣA{A(A{AͮAA  AͮA\)ẠȀ\A\)AAAA
A  AɮAȏ\AəA
AǅAA
A33AzAʸRApApA=qA{AzA{A{AAΏ\A͙AA\)A  AυA{AAQAУAQAЏ\AУAЏ\AGAHAQAѮA(AHAApA{AAGA
=AυA
=AAAQAϙAϮA{A
AA  AAϮAGAAхAHA  A=qA{AHAәAӮAHA33AӅA
=AA(A(AϙA\)AљA
=AAУAffAЏ\AAAҸRAЏ\AHAAA  A=qAA
=Aʏ\AAQẠAȀ\AͅApApAffAzȀ\AffA=qẠAˮAAʏ\A33A
AʸRA
=A33AA{A\)AAA=qAȏ\AA  AȸRAʏ\A
AffAͅAGAffA
A{AAɅAHAQAA(Aʏ\A{AGAHA(AffAAGAQA  A
AA(A
AGA=qAQAAȣA=qAȣAAAAffAffA=qAzA
=AA
A
AA  A  A{AHAAGApAA˅AHAɅA  A{AʸRA
=AzA{A
AʸRAQA(A(A
A  AAGAʣAHAAAGA\)A{AGAȣA33AɮA  A=qA=qA{A  AAAA  AA
A
AɮAA
=AA33AʸRAHApA˅A{A
A˙AʸRAA
=A  A33AGAQA\)A=qAʣA\)AAGAAA˙AffA˙A˙A33A
=AˮAʸRA33A(AAAAʣA=qAAȣAffA=qA{A  A  AApAffA˅A
AAA=qA(AA(A=qA33AŮAǮAȏ\AzA(AHA{AƸRA
=AA  AzAȸRAȏ\AGA=qAəAA\)AǙAǮAƸRApAAAA{A33AQAzAȣAAʣAA\)AAApAHAʏ\AffAA
AǮAA\)A33A33AǮAA\)AǙAAȏ\A
AȸRAA
=AAǅAGA
AȸRAAʏ\A=qAQA{A{A{AAGAʏ\A{A{AGA
=AQA=qAAǙAAǙAHAAģAQA(AŅAAA{A  AA(AzAAÙAHAHAQAA
ApAA=qAȏ\Aȏ\Aȏ\AȣAQAQAȸRAA
=AA\)AAəA=qAzA=qA˙A
=Aȏ\A\)A
A=qA
=AAAGAA\)AGAGAəAGA  A(A
A  AəAɮA\)AAȏ\AȸRAzAȣA=qA{AzAƣAƸRAǙAǙAzA
=A(AîAƣAAAƸRA\)A
=AA
=AƏ\AƸRAǮAHApAA33A\)A33AA
AHA=qA
=AʸRA(AAǙA=qAzAȣA\)A\)AɮAAAQApAQAHA33A˅AˮAˮAˮAA  AzAA=qA{ApAA\)A  ApAAɅAA\)AAA\)A
A=qAA=qAzA
=AA(A(A{A=qAAHAǙAQAHApA
AQA{A\)ApA33A
=A{AǙAzAffApA  AGAAȏ\AǮAA{AAǅA  A(AzA33A33AȸRA=qAAʏ\AɮAA33AAAzApApA\)AẠAAA33Ȁ\A̸RA
=A=qAAA
=AʣAʏ\AA{A
A˙A\)A33AAQAAAQAffAAAzA͙Ȁ\AͅAzA(A(AͮAA\)A͙A
=AA
A
AA  A33AAzAQA\)AApAȸRA=qA=qA33AA  A33A(AffAAəAAȣAffAffA\)A
=AȣA  ApA
AʣA  AQAffAzAʸRAʸRAʣA{ApAAHA
AˮAzAA  A33AͮApAͅA{A
A͙AͅA͙A\)AGA̸RAA(AAͅA͙AAApẠAAͮAAA
AAͮA͙ApApA\)AzA{AAAA
A˙AGA˙A˙AGAˮAA
=AAAʣAHAʣAʣAAʣAzAAȏ\AA̸RA(A
AθRA33A(A33Aʏ\A  A{AA=qA
=AApApAffAΣAAAGA33AϙAҸRAхAQAУA  A(A33AffA(ApAϙAA  AQAυAυAApA
A(AQA
AzAffA{A
A
A
A33A\)AΏ\AθRA\)A{AQA(A{A
A  AA\)AAυApA
A  AAAQAQAиRAЏ\AQAA{ApA˙AApAAffȀ\ẠA
A͙AA͙A33AA̸RAͅAGAәAAA{AffAԏ\AԣA(AԣAAzAAA  AA=qA=qAzAҸRAҸRAҸRAѮA
A
ApAѮAљAѮA
AхAAA33ApA
=A  ApA\)A
=AЏ\A{AAGAAϮA
AA  A(A  AQAAQAиRAυA33AљA\)AQAϙA
AAAУA͙AAAθRAffA(AɮAApAzA˙AA
=AхAQAУAЏ\AzAzAQAffAAQAAϙA\)A(A͙A\)A{A
A{AAAApApAиRAAAffAQA  A
=A\)A33A33AΏ\AzAΏ\AΏ\AΏ\AΏ\AAHAΏ\AΣAΏ\AΣA=qAzAffAffA(A(A=qA=qA(ApAAȀ\AȀ\A˅A
=AʣA\)A  AəAȣAʏ\A(AHAAAAAA
=A33A
AffAzA
=AҸRA\)AAAGA
=A=qAQA=qAffAffAAAGAθRA  A  AGAzAиRAHAЏ\AЏ\AAzA\)A
A33A(AffA  AϙA\)AAAAϙAϙAAGAzAffAzAA
A  AAzA=qAHA
=A  AzȀ\A
=AAAzȀ\AzAffA˅A\)ApAAHAQAəA̸RẠA
=AAəAA
=A˅A
A˅A˅AQAAͅAϮAиRAУA  AQAAAQAЏ\AffAQAzAЏ\A
=AA(AAHAHAAzAУAApApA
=A33A{A
=A33A
A
=AA{AffAЏ\A{AAAυAυA{A(AAΣAQAAQAΏ\A=qAffA  AAA
=AQAȸRA\)AGAʏ\AHAzA=qA
=AˮA  A  A  A̸RAGA  A=qAAffAA33AϙApAAυA{A{AffAAЏ\A(AHA33AAHA
=AGAхA\)A\)AAAffAQAΣAυA  AA
AAA33AAA=qA(AAΏ\ApAυA
ApAHAHAzAиRAЏ\AQAA{A˅A\)AAʏ\AApAAAʣAȏ\A
=AHA\)AzApAʏ\AApA\)AzAQAΣA  A  A  AͮA{A33AѮAљA
AA
AԣA=qAAffAԸRAՙAA\)AHAHAԣAԏ\AAԸRAQA  A{A
AA
A
=ApAՅAffAzA\)ApAAGAAAAAAAϙAA33AzAzAϙA  AѮAAA
AGAѮA(A
=A{A
AхAQAQAQAˮA˙A33AHAͮA\)AϙAzA  ApAΣAA  AGAA
AAљAхAzAffA
=A{AϙAAApAϮAУAHA
AAAAԣAzAԣAAԣAԣA{AffA  A\)A=qAAGA
AAυAΏ\AAA˙AffAAHAͮAzAAA\)AϮAQA\)AffAHAAffAиRAиRAzAУAAA\)AͮAA{AəA  AA=qAθRA{A
A{AffAGApA=qAQAQA  A  AA{AңAAAQAQAzAQAQAffAffA=qA
AAˮAA
A
AA
A\)AA=qAϮAиRAAӅA  A(A{AAzAԸRA{A=qAхAљA  AЏ\AAυAхApAffAA33AAΏ\AΏ\AΣAˮAAϮAиRAHA  AУA\)AHAңAԣAљAхA  AљAѮAAңApAAzAAAA33AGAAHAAҸRAхAљAљAѮAѮA
AAљAӅA=qA33AхA\)AиRAA(A
A{AQA
=AAAAGA
AAϮA=qA  AAϮA
AУAffAA(AAΏ\A{A(AGAHA͙AθRA  AzA{AzAAA\)Ȁ\AA
=A˅AˮA33AHAAˮẠA=qAAGAHAffA33AˮA=qAAzApA
=AHAA{A{AA{AϙAHA
A{AɮAȸRAȏ\AAzAɮAɅAzA33Aȏ\AQApAA  AͅAͮA\)A
A\)A{AAҸRA
=AQAθRẠA{A\)A=qA
=AͅA  AΣAA
=A̸RA\)Aʏ\AzA33AA˙ApAGAAAAHA{AəAɮAɅAʣAȣAɅAAA  A=qA˅AGAʣAzA(ApAAʣAApA˅AA˙A˙A33ApAď\AA=qA=qA(A=qAAǙA
AzAȸRAA
=Aȏ\AAǮAȣAAȸRAAAQAȏ\A=qAȏ\A
A
AffA˙AAʣAAzA
=AʣAffAzAA\)AHAQAAʣAɮAȣAȏ\A
=Aȏ\AȸRA33AA
=AȸRA{AȣA
=A=qAʏ\ApAAȣAffAAGA(AŮAHAřA{AƣA  A{A
=AffApAAɅAffA{A\)A(AAʸRA˅AAHA(A(Aʏ\A\)A{A  A=qAQAQA̸RA\)A  AAzA{AQA\)AA
=AA̸RAAAAAͮA͙A(A
AApA  AffAAΏ\A=qA=qAQẠA{AA\)AGA˙A
=AzA(A{AffA(A˙AQA{AffAɮAAA=qAApApAAƏ\A(A\)AA(AAGA˙A
AˮA
=A˅AˮAAθRAA
=AHAAA
=A
=AAAAHAΣAΏ\A(AA͙A˙A=qAˮA˅A\)A{A=qA  AzA\)A\)AzAQȀ\ẠAQAA  ApAzAɅAAʏ\A  AQA=qA̸RAAAAAffA
=AQA˅A\)AA{AHA(AzAAəAGAzAʣA˙A
Ȁ\AAǮAA\)AǙAAffA=qAɅAHAffA
A33ApAAAʸRAAAAʸRA=qA(A  AffAQAA  A
AQAzAffA  AʣAGAʏ\AʸRA33A
=AAA˅AHAGA33AəA
A
=A
=AɅA
=AHAẠA{Ȁ\ApA=qA
=A  AəA\)A
=AffAffA(Aȏ\A{AǮAHAffA33AzA(AGAAAǙA  AQA
=AQA
A33AAApA(AɅAzAA33A(AȣAHAApA33A˙A˅AəAAɅAA{ApAQẠAAHAHAAHA
=A̸RAHA̸RAȀ\Ȁ\ẠAHAHȀ\AHAAHẠA̸RAHA
A  A
AffAAzAHA\)AʣA  A=qAzAAffAAAAQA(A˙A33AAʣAAAʏ\A  AǅAzAQAʏ\A
A33A
AɅA=qAǮA  AzAAApA
=AHAffAQAAffA=qA{AAzA33A(AɮAQA͙A\)AͅA
=AGAȸRAȣAGA33AzAǮAA\)AƸRAɮA
=AzAAQAͅAffAˮA
AApA33A˅A
A
=AffAȣAHA
=AApAHAAʸRAHAAQAȀ\A=qAffAAAǮAzAǮA{AƸRA\)A33AAApApAzA
A\)AA
A=qAAƣAǙAǅAQAQAȸRAA\)A33AȸRApA
A(AffAffA=qAAQAQAzA
AQAAffA{AɮAffApApAAAȸRA
=A(A(A=qA33AffA(A(AA{AQA̸RAHA
=AAGA
=AA
=AA33A͙AͮAͮAGAͮA
AͅAGAGAȀ\AffAA{A
A˅A˅A\)A33A\)AHAHA
=AzA{AAʸRAʸRA
=AʸRAHA
=AAQA33A  AŮA(A(AǙAȣAɮAAHAȏ\AGAA
AŮA33AGAAApA(AffA\)A=qAÅApA\)A(AQAHAA{A  AəA  ApAƣAA  A  AƸRA
=AɮAzAA{A
=ApAzAHA
=AAθRAͮAͅAȀ\A˅AAAAȸRAffAA  A33A\)A(AAʏ\AzAzAȣAAGAȣAȸRAɅAAƣAffAHApA(AAAǙAȣAȏ\AAɅAɅAQApA
=AřAGAHAGAǅA
AQAȣAɮAəApA\)A\)A(A
=AzA˅AʸRA(AQȀ\AAʣA{ApA\)AʸRAHAʏ\AzAAʣAffApAʏ\A˅AAʏ\A  A(A33Aʏ\AA
=AA\)A
=AɅAřAA  AGAffAAɅA=qA(AAǅAQA
ApȀ\AApAGAAHAAzA=qAQA  A  A  AA(A=qA{AAApA\)AʣAAAAȣA\)A
=A
=AHAȏ\AǅA33A
AzA
AAAGAʏ\AAA(AQAffAͮAQAθRAΏ\A=qA(AͅAAA̸RAffA=qAAAA  AAAAffA\)A33AAQApAΏ\AA=qAΏ\AzAΏ\AzAΣAAzAQA33A\)AffAzAGAAHApAAAAHA\)A{AAHA  AQAzAΏ\A
=AAAΏ\AAffAQAΣA{AzAAѮAGApAљAAHAzAffAAиRAAљAQAAΣA(A  A33AHA
=AAQA{AGAApA{A
=AGȀ\AzA
=ApA{AẠAʏ\AQA  AAQAHẠẠAΣAAͅAθRA
=AA
AAQAffAУApA=qA33AAGAAHAHAʸRA\)A\)AAA33A{AzAQAzAzA=qApAҏ\A
A
AAљA33AA
=AAЏ\A=qAA{A
AffA  A\)A\)AHAθRA\)AϙAGAA{A\)AˮAA\)AA˅AˮAʣAHAəAəA  AGAʣAȸRAA33AA{AAȸRAAGA(AAHAɮA{AȣAȣA  AAƸRA\)AA
AGAffAA  AAA(A(Aȏ\A(AA{AffAzA\)AɮA˙AA̸RA=qA
A33AAHAQAA
AffAffA(Ȁ\Ȁ\AQAQA
AˮA\)AAʸRAQAHAʸRA˙AAGAHAzAA=qA33AˮA  A˙AAəAʏ\A  A{Aʏ\A{AzAʸRAʸRA=qApAzAAAAAAAffAHAǅA33A33AȣAzA
=AAAAQAAQA{AApAA=qAAAApA
AƸRA
AffA
A˅A{A
AAȏ\AɮAȸRA(A33AȸRAɮA{A33A˅ApA˅A˙ApA(A˅A(AAGApAˮA{A
A  A
A
AˮA˅ApAGAGAɮA  A\)A  AʸRAApA
=Ȁ\A(A33AGAʸRA
A˙A33A
A\)AA=qA
=AHAffA=qA\)AGAAȏ\AƸRAAA33AGAzAA\)AAʣApẠẠA(AGAǅAəA33AəAȏ\AzAAɮA
A  AAzA=qAHAAA33AffAͮAzAAQAA=qAffAͅAQA=qAHAΣAHAAΏ\AͮAΣAΏ\AQAA33A  Ȁ\A˅A(AffAHAQAGAȣAQA=qA{AǙAffAAA(AHAAHA\)AQA\)AffAͅẠA
=A\)A  A
A
=A
A
=AzA\)A(AA
Ȁ\AA  AͅA\)A\)AApAθRA˙AHA(AzA33A\)A(A
A
A  A=qAƸRAGA{A(Aȏ\AffAffȀ\A͙AHA33AϮAffAAffApAϙAA=qAGA
=A{ApAϮA  A̸RAApAAQA
AΏ\AA  AAzAA
AffAA˅AA˙AAA(A=qAQAAA˙A˅AA33AHApAɅAAGAɮAɅAA
AffA˅A\)AA
AA
=AAA̸RA{AffApAəAAzA
=ApAGA
=AApA˅AʸRA\)AGAəAɅAȣAAƏ\A33AȣAGAHA33AƸRAzAAQA
=AffAA{AîAAApAȀ\A=qA{AGAA˙A\)AGAHAffAzAAzA(ApAA{AAAɅAAHA{AzAAA̸RAHAAA
=A\)AQA(A͙A\)A\)A
=ẠẠA(A{AHApA˙AffAHAʣAzAA  A\)A͙AAAΣAA(AQAAGApA  AǅA{A(A  AA
=A(AHAffAGAͅA
AˮApAɅAQAȸRAɮAʏ\AAȏ\AʸRA
=Aʏ\A  AGAˮAʏ\A{ApA(AƸRAAƸRA
=AA\)A=qApAAGA\)AA
=AAAƏ\A=qAǅA(ApAʣAʏ\A{AʣAʸRApAɮApAA
AGAǅA33A(AȣA  A  AȣAǙA33AƣAƏ\AAGAƸRA33AĸRAAAȸRAzAȏ\AǮA=qAʣAGA33AAAɅAAffAzA  A
=A33AƸRAAŅAQA
AA=qAHAAA  A£A(A{A¸RA
A=qA=qAA
A{A
=AzAAA33AAA
AAAQAAAÙAAQAAǮAffAzAApAzAAAAřAzAQAȏ\A(AǅAzAŅAA\)AřA\)A
AģA{AÙA\)A
AGAGA
=AAApAAAHAAzAARA\)AA
A
=AA\)A  AHAzAzAHAffAAQA  A{A=qAHAzA33A(AA=qARAQA\)A
=A(AGApAA=qAAAA\)A\)AAÅAA¸RAAAA
=A¸RAzA  ApARAffAQAAHAA¸RA=qA{A=qA33AAzAQA=qAAA
=ApAA{AA\A{AffA
=AŮAAAAAƏ\AffAHAffAAřAA\)A{AAǅAĸRAĸRA{AGA  A
AŅA{AAAď\AÙAÅAAď\A=qAGAAîA  A{A(AzAffAA=qAffAA  AAQARA=qA(A\)AAA
A=qA=qA33ApAGAHAzA¸RA
AAzA\)AQAGA33AARAřAApARAA(AA
AA  ApA\)A£AAffAffAAÙAAGA(A£ApA=qAA  A(Aď\AA  AffAzAAîAÙAA\)ApA  A\)AGAzAAģAApAA33AQA
=A{A{A{AGAǮAHAzA
AA33A  AA33AA\)A  AřAAAHAA=qAAAAApA  A(AA{AîAģAHAAffA  A{A(A33AAAGA¸RAAQA
=AAřApA
=A
AffAffA=qAGA\)A
=AHAǮA
AŅAQAŮA
A33A=qAAŅA(AA\)AA
=A33AǮAǅAHAA(AǅA{AQA(A
A\)A
AAAǙAǮA\)AǅAA
=AffA\)AȸRAGA\)AGAA
=AAA=qA\)AȣAǙAŅAAď\AHA  AffAQAHAzAApA
=AAffA  AAAzAď\A33A\)AAGA=qAȏ\AHAɮAHA\)AǙA(AǅAǙAffAəAGAHA˅AAA̸RAHA  ApAəAəA{A(A{A33AəA  AHA
=AÅA£A{AAģA
A(A£AAA(AAQA(AÙA(AĸRA33AAGA\)AAGA33AHA(AȣA
=AAǅAA33A
AffAHA(AɮApAǙAHAřAQA=qAffA
=AApA£A(ApAA=qAGAHAAHAA(A33AǙAǙA
A(A=qAǙA\)AAGAGAŮAĸRA=qAzAQAƣAAQAffA33AîA=qAAzA=qAAA
=A
=A¸RAffAGA33AApAffAGAA{AffAGAffA(A(AŮAAƏ\ApAffAffAAHAHAAQAAGAA33AGAGApA  A33AA(AA{A33A
=AŅAŅAzAîAA  A
=AAAAffA  A
=AffA  AǅA
A
AȣA{AQAzA{A(AAGAGAAAAQAGAffAAGAAAQAA
=A\)A\)A33AQA(AA{AQA(AffA  A{AGAffA(AA¸RAffAA33A  A  AÅAîA33AģAGAîA
AAď\AA
A\)A33ApAffAQA(A{AAŅAAŮA  A
A33AģAHAGAAŅA33AAAHAzA=qAA  AGApAAGApAGAď\AffAQAA\ApAĸRA=qAĸRA  A=qAřA
A\)AģAģAApAA  ApA=qAHA  AAGAffA(A
=AƏ\A33A  A
=AHA{ApAHAƸRAƸRApA{A
AQAQAAAƏ\AQAzA\)AƸRA
A=qAƸRA33AAAA\)AQA  AǙA{A  Aȏ\AQA
AQAffAȣAffAffAǮAA
AQAApAAǮAA=qAȏ\AAzAQAȏ\A(AQAȸRAȸRAȣAȣAA33AQA=qAQA(A{A  AA{AǅA  AA  AAǮAAƸRAǙApAzA33A(AƏ\AA{A(A
=AřA=qAƏ\AzAffA
A(A  AAƸRAƸRAffAƸRAAƣA\)AǅAffAAď\A
=AAGAAzAApA=qA(A{A=qA{A  AA\)A
=A33Aȏ\AȸRAɅAəA33A33AɮAApAGAAzAGA\)A
=AzAffAAȏ\ApA33AA
=AAȣAȏ\A
A\)AA  A
=AǙAəAAǅAAAA=qAQA  A33AƣAAAAAƸRAA33A{AƏ\A(AAřApA33AAƣAHAřApAGAAA(AÅAGAA{AA
=AffAffAAffAÙA\)ApAAA\)A  Aď\AffAAGApAŮAA  A(AƏ\AƣAA
=AAHA
=A(A=qA(ApAƏ\A
AA(A
=AHAQA=qA{AȸRAzAAHAAAA{ApAHAQAHAffAȏ\A33AAQAɅAAȸRAGApAAGA\)AǮAHAffA  AGA33AA\A¸RAîA=qA33A  AQA33AƸRAǅA\)AǮAŮAȸRAHA{AAƏ\AGAǮAAffAȏ\AǮAffAzAAĸRAA
=AAÅA
AQAffAģAApA  A  AA(AffAƏ\AƏ\A{AAŅAřAŅAŮAŮAA{AAAŅA33A33A  AîA
=AAQAĸRAîAģAzAģAffAĸRApAÅA  A(AA£AA¸RA33A
=ARAAAGApAA33AQAA(AA33A33AffAAAGAAA\)A(AHAHA  AApApA\)AAA\)AzA=qAAGAffA
A\)A\)A
A{A\AAHAffAA33AAAQA\ARA33A\)AA  AzA=qAAAGAGA\)ApAAAAAAGAQA
=AHARAQAA
A=qA£A¸RAA¸RAzAA\AffAAƏ\A
=A  A
=AAģAÅAHAAAGA  AGA\)A=qA
=A
=AA{A{A=qA
AAA  AAA=qA
=AAHAAHARAApApA
=AHA=qAǮAQA(A=qA(A{A\)AÙAA  ApA\)AAzA=qA  A\A£A¸RAQAAA  A33ARAAzAAffA\A
AAA(A  AAA{ApA  A33AAAAGAApAAApAA
=AAARAAAA
A
A£A33A33A
=A33A=qAAzAAA  A33AA  AÅAffA  AAAA(A=qAAAAAA33AffAîAŮAARAGA\)AzAHAGAGAģA33A£A
=A  AA
=A\)AA(A33ApAGAAzAAGAffAAA\)A=qAA(AAAA=qA(A\AffAA(AGAAGAÙA
=A=qA\AHAQAřAAA33AřAAď\A33AA
=Aď\AHA
=A{A  A=qAŮAHAƣApAA
=A33AA\)A
=AA  A(AA  A
=AAQAzAA\AAîAAffA\)AAHA  A{AAGA\AzAA=qA{AAARA=qA¸RAGA=qA  AffA  A=qAHAAQAGAHAAHAAzAAA
AƸRAAAǮAǮAǅAAǅA33AƸRAƸRAƣA(A{A  A(AAA33A\)A{AA(AAŅAAHA
=A\)A
AAA(A(A=qAƣAApAAřAAGAĸRA(AAîApAAHAA  AřA{AAA{A(AǙAAHAA
A
AHA
A
=AAGAAzAAAA\)AGA
=AHAHA=qA33AÙAď\A
=AzAĸRAAA
=A
=A\)AģAffA33AAzA(A=qAzA(AƸRA
=A33AƏ\AAAGAA=qAzAQA33A
=A
=AǅA=qA{AǅAffA
AAǅAzAƏ\AA  AGAģAģA
=AA
=AAAģAřApA  A  A(A\)AAHA
=AzA(AAÙA\)A\)AzAAffAffA
A
AA£AQAA
=AQAQAAƸRA
=AApA¸RA  AîAffA(AGAƣA(AffAģAA
=AffAŮAGAAřA=qAQAzAŅA=qA
=A33ApA  AffAAAɅApAA{AA  AAAA=qA  A  A(AɅA(AAzAʣAffA=qAffAɮA33AȸRAffA=qA=qA(A  AǮAAHAƣAƸRAApAǙA{A  ApA  AAQAHA{A\)AǙAǅAǮA
=AAA(A
=AĸRA
AGAŮAŮAA=qA\)A
=AAAAffAA
=AAAAHA
=AA
ARAAApA(AAA
=AzAzAQA(AA\)AA\)AffAAA\AHAQA
AAA{AzA(AAA\)ARAGApAAffAzA  AA
A33AA33A\AzAzAAAzA(AA{A{AAAAA(AGAAApAHA33AGA{AAAQAA(A33A(AAGAGAzAffA\)A
=ApARAAA33A
=AGApAA33AAA(AAAAQA(A33ARA\AffAAGA
AAA\)AAzA{ApA=qAAAA(AGAA(AAQA{AAHAAAA{AAA33AzAzA
=ApAHAffA=qAAA
=AA\A33A
=A  A(A  AQA  ApA\A\AGAffA\A  AA
AAAA
AGAHA
=AHAAffA(A
ARA{A(AffA
=AA{ARA
=ApAAGA  A
=A\)A\)AGAAAA\AAAGA
A  AGAA33A\)AAA\A  A
=A33AA
=AA{AffA33A
=AAA(A
A  ARApAAAA=qAAAGAA\AAQAA\)AQApAAffApAA
AAA=qA\)AGAffAHA33A33AA
AQAffAAAA  AQA{A
AAQAGA=qAAffAGAA\ApAA
=AA\AffAAzA
A\)A\)AQA
=A  A{AAQAApAA33A33A
=AA  ARAAHAAAGAAAA
=A\)AAA{A
A  AAA\AQAAA  AA
=ApA\AQAQA\AzAzA
AAA
=A  ARAA=qA=qA  AA  AHA
A=qA
=A=qA\AQAAHA{A\A33A
=AA  AAAQARA\)AffAzA
AQAAGAARA
AAHAA(A\AARAAAAGA  AHA\A=qARA\)AAAAGA{A(AzA(AzAA
=AzA\AGAARAAHAQA\)AA\AA(AzA\AApA{A{A  AAAAAAGA=qAGApA\ARARA{A=qA(AGA
A
=AzAAAAAHA
AAQAAA  AAAA\AAQAffAAGAzA\)ApAAGAA\AAHAQAA
=ARApA  AQA=qAffARA\)A  AA\)A{A
A  A=qAAQA(AA
=AzA\ARA(ARA\)AQAzAffAAQA  AzAAAAQAffARA  AAA\AAHARA  ApA
ApAARAA(AA(A{AA\A(AApAA
=AA
=AAHA\A(A(A(AAA\AA\AzAQAAffAAAA\)A\A\)A(A  AzAA33ApA  A33AARAApAARA
=AGAzAAA\AAAzA=qA\AzAffAA{AzAAAA\AAGAzAARAAAffA(AA{ARA\AffAGAGApA
AzA=qAQAffAAAA\)ApA33AAAAAA=qAGAGA(A33AAGApA\)AA33A33AffAffAA
A
=AzApAApA\ARA(AAAQAAAAGAAQAffA\ARA\A
A33A{A\AGAA=qAAAAAAQAA\AARA
=A\A=qA
=AQAApA
=AA=qA  AffA{ApAHAA33ApA(AAA=qA  A{A=qA=qA{A\)AHA
AAGA\A33A\AApAHAGA(A\A  AAAAA33ApA
=AffA=qAAARA\AAzAAQA
=AAffAApA33A\)AA\AAAQAGAAA\)AzA  AAAAHA  A\AAA\AQAAAQAzA33AQARAQAA\)ApAGAA
=AzA  AA=qA33A{AAA{AAGA
ARAApAGAHAA  AQAAffA(AAAffAHAQA  A(A=qAA
=A
AffAAA=qA{AA  A\A\)ApApAApAAA(AA{AAAHAA
AHAAA  AAAGARAA\)AffA33AQApAARA\)ARA(AAffA
A{AA{A(AA
=AGA(AAffAAAGAAHAGA\)AGA\)AffA  A=qA\)AA=qA\AAA
=AQAAAA
AA{A
AQA\A(A=qApAA{A\AA33A=qA  A
A{A33AAA
=AA  AAffA
=AA33AHAHApARAAAGAAGApA=qAAzA\)AffAHAA  AzAQAA\)A
=AAAA
=ARAzAGAAAAAA\AGA33AAQA
A
A(AzA\AAffAHA=qAHAA  A33AAAAAA=qAzAA
=AHA
=AAAAAAARA33A\)AAAAAAGAffAffARAHAHAA
AAAAAffAA\A
=A=qAAQAAA
=ARAAAAA=qAARA=qA=qA\AzA33ApA  AA  AGAAA(A\)AAQAAAARA{AAzAA
AAffAQAA=qA\AA\AApA\)AApAA  A33A33AA33ApA
=AGAAHApApAHAApA
=AAAQA{AHAzAAffA=qA(AA\AQA{A\AAGA  ApAHA
A\AA(A=qAzA  A
A33AARA\)A33AAHA  AAAffAHAA(A33AAAARAGA{ApA{AAGAARA{AQA=qA
=ARA\)AQAHAA=qAA  A=qAAzAApApAAQA  AffAA\A  ApA
=A=qA
=ARA{A\)A=qAHAA(AAAA
AAHAAAQAAA  AA{AARAGA\)A
=AHAffA(AAA{AQAHA
A{AAAARAffA{AAApARA
=AQA
=A
=A
=AAARAffAQA  AAzAHAffAAA\A\A
=AAAAAGA=qA(AHAGAAAzAA\A\ApA{AQA\)AAA  AHA
A
=A
=A\A
=A\)A=qApA=qA(AAAzAA=qA33A\AARA
=ARAAAARAQAAAApA
=AGAffA{A{A=qA=qAffAQA{A
AAGAA33A\AffAffAQAffAQA  AA\)ApA{A\A
A33ApA\)AHAAAAAQAA\AAAAAAAQAAA(AffAHA
=AA(AffA\AA
=A
=AGAЏ\AHAzA=qAɅAAA
AA  AəAA\)A  AAڸRA֣AәA
AA{AAAΏ\AAA  A\)AAGA
=A
A  AA(AzAAAApAۮA{AǙA33AA
A\)A؏\AA
A33A\)AAAA=qAA\A(A
=ARAABBffA\A33AA  A{AApApAGA
=ARA癚AA(AHAffAA\)AA噚AAARAAAGA  AAAffA{A\)AծAzA=qA  A{A33A{AAAA  AQABRA=qAޣB AB(B{B\)B33B\)B
=BQB
BBpABAHApAAA
AHA\)A
=A\)AAQA{A
ApAHA
AAARAApAAAzA=qA\A(B  B33B BB(BRA
=AAQAzAHARAAAHA=qAAffB 
=B QBffBAAQA{A\)A=qA(A33ARAAAzB  B zBB{BB{BffB=qB\)B
BB
BBQBB\)BRBQB\B B\)B BBB\)BBBHB\B33BB	
BHB
(B  BBffB
B
B
  B(B
=qB	zBHB
\B
  B
\B  B\)B	B	HB\B	HB	BzBB	=qB	  BBBQBffBB\)BBB	zBGA\BQBBBA\)B
BGB(B
RB\)AB=qBQBzAzAGAAffAGBB=qBB\A  B HB
B=qBBA33AGAAB
BGBffBBAA  A\)B
=BpABQB	{B(BBABBffB(B\BffBRB  BpBB	(B
B	zBBA
=B{BB(B
=BBB=qB\B\)BB
BzB33B=qBBB HBffBGB HA  AAAARA
=A=qAHAQB{BApAAAA=qApAAGA{AzB	GBB	=qAA{BHABRAB\B  ARAAA\)AAffB 33BBBBQBBBB(BpB\)BQBBB\)A=qBpBB\)BB33BzBzBBBABHA
=BB	ffB
B
GB	33B  BzBBB
=qB33BRB	zB  BBBB
pB	B	zBffBBzBRBGBBpBBARAB B BAA
=BBBpB=qB BRB BB33B\A{ABBzB
B  B  BzBB zBB   AApAzA{AA(AGA33AA\)A\A\)ARAffAHAzAAA=qARAQA(A33A{A(AAAzAQA{ABB33AzB 33BB pB AQA(AB{B HB BRB
=B 
BB BQB=qB{BB(BBBBQBBzB(BBBB  BB{BRBffBB\BBB ffA33AA
=AAA
=A\AAffAAQAAB 
=B 
=A{A33A\)AQA
AA
=AGAA\A=qARA
=A=qA
A33A  AA=qA\ARAzA
=AHAGA\)AAGARAA=qA
=A33A陚AA\)B (AB\AA
=AB A
=B(A\BffBRB
BHBRBffBQB{BBQAB (AffBApApA\)AA{A\AA\A{AAAHAAAAB QB   B \BQBB\)B HAB GB B{B(BGBRB RAzAA
=A\)A
ApAA=qAAzA\)AAA(A\ApAA=qAA
=AA=qA
=AzAAffA\)A  AAAGAA=qAGA
AffAffAAQA
=AAܣAQAӮAѮAЏ\AHAGA33AA(AffAA(ARB\)BBB ffBBffAA{B 33AB
B=qB(A33AffA
A
A  A
=AAAAAA
=ApB GBBBA  B HAAGAAAffB
=B{B AA\A
ARA  AAB 
BzBHBB33BRB\)BHBB 
A
=A(A
=AAAARA뙚ARAffAA\A  A33AzA(A\AAQA{AGA
=AA=qA\)A=qAAAGA=qA\)B {ABHB AHAApAARAAQBQBHB  BBHBpB33BQBzB  BHB\BHBBpBBB
BBBB\)BBGBRB=qB\)B
=BBB	  BBBzB=qBQAA
=AffARBGBAHBB
=B	\B(B
=B(BBHARA33ABB33AzAAzAzAGA33AHA{AAffAAAQARARA=qA  AzAzAffARA{AzA=qA\)AB\BB=qA(A=qAAAB  B  AHA{AA(BGBGB{A(A  A(AHB(B=qBBBRBBzB
=AHA\AAA{BB33BA\A33A=qA
=BpA{A33A
=AHA=qAzA  A{A
=AA(A
=A
BBA33AzB HB\B(B B
=BB\AA\)AQA=qA
=AAAA33AQAQAGA=qAffAAQA\A  AA{A
=ARA
=AAޣAAAAHA=qB
=BA
=A{AAAAffAApAAA33A\A(AARB RB{B{B  B
B\AB{B33B{B A\)AzA  AA=qAzAffAAAAAQAQA
A33AA{A
B \BGBBBB
=BffBB\BzB(B(AGB QB BB{BAAQAAffApA\AAQA
AffAzAQA\A
AGAHA؏\AzAAٮAAA
=A33AA
=ARARBHB33BQAӅAAA{B (BGBBzBRA  AB BffBzB=qB33ABB
B BBB(AAGB zBB\)BzBBQB(BGBffBpB
B
BHBB	B
=B	B
(BzBB	33BBHBHBHB(AAAA=qAA
=ApAAB 
AA  B zB BRBABzB33A\ApAffAAAA=qA33A\AAHAAGAzA(A\)ApA=qBA\)A  AGAA\)A
=AGB	B
BBB
\B
RB=qBQBQBHBGB BB \BQB  B\)B	
=B
  ABB\BB
B{BBRBB\)BGB	
=BGBB  B
=B\A\AApA33ABpBpBB\BHB
BHB
{B

B
{B\B\)BpBB

B
(B
QB
B	  BffBB
=qBB
B
{B
zB	=qB(B ffBGAB B zBRBB(BRBAARA\B=qB=qB(B(B33BffB\BGBBGB B \B B HB zB 
BBffB(BBBBzBpBBpB(A
=ABGB\B\BA
=AAA=qABBzBGB RAA33B pB33AGBAB \B(B
BHBBB(BHB{BB
BRBBpB33BBB\)B  B(BGBB  BBB
=BBHBBB{B B
=B(BBBA\)AffAARA  AAA(AAffApAA\A{AAffAA33AAApAAGA{A  A  B  AAGAAGAAzAAGARAAAA  AQB{B
=ARAzAB
B
B
\B	ffB(B
=B(A33A{AHAA{AffAAA  AQB BRB(BB	  B\)BAHB   B   B
=AAApAA=qA
=A=qAQA\)AA(AB33BGB  BzBB	B	BHBpBpB	=qB
pB	  BB	zB	B
ffB

B	zBBB\B33B33B
B	QB	B	GB	B	ffB	33BBBffBB{B
BQBBpBRBB\)BQBBffBRB
B\B\)B\B=qBpB\)B=qB(B\B{B\)B  B=qBpB33BRBB
BffB	{B33B
=qB  B=qBBzB
BB\B
=AB
=B B 
A33B
BB{B{BBB	
B	  BB
(B  B  B(B  B(BBBBffBpB\B{BHBBB
zB	\)B

B	B	B
B

B
pBQB
=BzB

BzB\)BB{B	HB
B
GB	(BBB
=qB
  B	B	
BB\BHBzB
{B
\)B
33B
B\)B33B(B\B
=BQB
(BB{B	pB
B
\B
B(B{B
\B=qBffB=qBpB
QBBBHBRB
GBB
QB33BB\)BBB
B
BBpBBB
B
GB
BBAffB ffBffB BB{B=qBBB=qB
B
B

B
33B	QB
=B  BB	(B
B	
B
RBB  BB
BzB=qBzAB B B33BRBGB33BB=qBAB	=qB	{B
B(BB{BffBBffB	HBffB{B
BB
B
zB
HB
BBpB  B
BB
GB
B
BBB{B
(B
33B

B	B\BB{BBpBB=qB BffB	pB	33BAB	\)BBRB
RBB33BAQABBB	\B

=BB=qBHBBBBBzBpAApAAA
AAAA
=AA\AffA
AGA33AffAA\)AQA33A\AQA\AA=qA
=BBB\)BRB{BB
=BHBB
B
  B
BpBGB(B
=B
zB
BB
\B
\)B=qB=qB
=BzB=qB
=B
B
B(BB
(B
\BzB
{B
  BBQBBBB  BpBBRBpBGB33BB
=B	B	
=B
{BBBBB	ffBRBHBB\)BGBA{B\BB B 
=B BQBBffB \B{BHBBB
=BBffBB=qB  BB(BffBB
BB(AA
=AQAA{AA{BRBB=qBB
=BBBBBBffBBB
=BBBQBBpBB
=B
B33B
B  B
\)B
(B

B
B{B
HB\B\)BQB
\B
B\)B
GB{B	RB	B	B(BzB33B B(BGBBzBBRBB\)BB\BGBARB\B{AA=qA\AQAAQA33A
ABBHBGBB  BB=qBGBffBQBzBB33BBB
BQBzB
BGBffBBRBAB B  BBRBzB{B	B	  BB
  B\B
=B
zB
B	\B	(B	
BB	\)B	
BB	\)AA\)Aʏ\AGA
A\)A=qA=qAƣAAA{A{AՙA(ApA¸RA=qA
AA  ARA33A\)AA\)A{AAƏ\A
=A
=A{AӮAQA
A\)AzAAAAzAA
ARA
AAGA  AA}pAxAj\Ao
=A{AvRAqAvHA|(A
=AHA
A
A  AAAtAmAkAr{Ah  AdzAcAb{AfHAn\Av=qA{A
A{AAGA\)AypA\AaAmGAAzAA33AA|QA\ApAApApAAAQA(AAzA\AA(A{AA
AAA(ARAA=qAAHAAAffAAARAQAA
A(AAAA  AGAQA33AAA
ApAHA؏\AޣAAGApAQAA  A
AхA
A
AAθRA\)A
=AAAQA
A
A(AffAAAޏ\AffAAffAHAA(AAARA{ARAA
ApAAAA
=ApA
=A(A{AAAA{A\)AGAffAA33AA
A=qApAffA=qA
=AffAffAAʏ\AۙA33ApAAܣAܸRA\B\B
=BffB BBQA\)A  A33AQAAAA뙚ApA33AffA
=ARApAA{AffAAAApAҏ\AծA{A
A{AGAA{A  A㙚A\)A͙A
A
A(AQAQAʸRA{BffAzAffA뙚A޸RAAɮAffAڣApAA{AApAۮAѮAA
AQAңAA\)A\AAGAARB A(B\BzBHB ApAA
ApA=qA(AA\A  BApARAAAAzAGBB{B
B	=qBBAHB GB BGBffB{BBQBGBBzABGB\)BBB=qBBBBAzA{ABQB=qB33BRBHAᙚA{A؏\AAGBBffA
=AHB  B  AB  ApAAB  BzB33B	=qBffAB(B zB GB ffAB pAA=qBA=qBQB =qAffAApAAzA\AARA
=AA  A\AAARAABA
AB\)BBGBffB33BBBffBHB33BB	ffB	B	33B
33B
(B	HB=qB	  BBBpB{B
=BHB
=BffBpBBRBHBBBAHA\)A=qAzA{AzA\AAA  AB\)BzA\B A  ApBHBBB
=A
=BBBBHBzB  AAΏ\AA
=AܣApAHAARARA
AzAQA\AAGAzA33A{AHAA  AQA{A=qAGAAHAAGB{A
=AQAAQAQAQAHB
=B
=B\BpB\)B(B{BA
ApAAAAAAAAGAHAHAAHA\A\)AA
=AAAA{AAAARAGA(AARA
=A
=A߅AQA{B {BRA33AB
=B{AffA(BAB zB
B RA\AAAAA=qA
=AQAffAA=qAA{A\AGA33A
A{A\)ApAA  AAA  AA33A
=AA\)A=qA
=A(AHAQApA  AA=qAAAAzAHA=qAHAGApAGAA{AffARA噚AAAQAGAzApA\AA  A  AGA
A\)Aڏ\AٙAمA
=AA{AԣA(AAARApA(A
A{AApA
=A  AHAAzA(AAΣAAAffAHAAABzB
=BB
=BHB	=qBBB (A  AAGB{BffB HBRA\)B BB\BRA=qA33AQBHAA33BB 33B\BB\BAHBGBB\)BBGBRBpBBHB
=B(BB
BGB  AA
BpBQB\)B  B{BQBQB{B33B
=B BA\)BBB =qB(B=qAzB  A  BB=qB(B(BQBBBQB ffB\)AQBQB=qB33B 
BAzAGBB 
BGA33ARB zAB 
=AB ffB   A  B A{BffB\)BQB\B(AQAzBRBB\)BBffBQBBBffB(B\BzB{BBBBB=qBzBQBBRB\)BB
=BBB(B {AARBGB(ABA\AB   B
AB {A\B pA=qAGA\)AAAAffApA33A33AzAAA\AAffAzAApBA
=AA(A  AzAAA=qA33AܸRAQA=qA=qA\)A\A
AGAAѮAffA\)ApAݮAظRA=qA
A33ARAA  A\AzAA
AAAHA33A{AA=qApAAAޏ\B GB\BB {BffBB(BAAB  AB \AffAA=qB B=qAAAAA  A\A
A\)A33AAA
=A33AffA=qAAAAGA\)AA
AAGAQA\)ApA(A
AA\B{A  B
=AA\AAA  AAGAA\)A=qAHAAڣA(AffABB
=A
=AڸRA{A\)A
AAffA{A
AAAffAAGAԸRAܣAA=qAԏ\A  AQAAQAAAzAA
AGA=qA{AzA
=A
=A
=AGA33AAAA{AAA(A=qAAA\)AQAظRA{AzA
=A33AA=qAӅAϙAAAzAHA
=AۅA(AQAAAQAzA=qAڣApA{AܸRAܣAAA{AߙAAffAA\)AHA
=AAĸRAAApAGA\A(A
AA  A\A{AHAQA=qAGARA(AA33AAA
A(A=qAAApA33AAA  A
=AA{AAzAA(A{A
A  AAA  A\)A\AΣA  A֏\AzA(A{A
AAAffAAGAAĸRA=qAAAGAΏ\A\)AffAzA  A͙A(A(A
=AHA{AHAARAA{ARA
AQA(AGA  AA\)A\)AAAAGAAAAHAۙAAAȣA
ApA\)A(A
=AAхA33AffAǮAA{AǅAA  A(AAŅA(A\)A=qA{AȣAQA\)A\)AԣA\)A
AGA{AӮA33AAΏ\A˅A׮AHAffAAA
A\)AA\)A
=AzA  A\AA33AQA\A(AAHARAQA\A݅AAffAAzA(AffAAARA=qA噚A
AffAAAQAApAzAzA
=AAzApB=qAARAA=qAAۅAA33AAA
=A\)A
ApAHB A
AAAGAA{AA\)ApAHAHApAzAՅApAAApA  A33AA
A
AAQARAA(AA
=AzA(AAffA
=A33A
AGBABzAAHAQAAAAAARAAHAA
AA33A
A
AQBAA
ApB AB  ARA{B ARA  AA  AAQApAAAQAAA
A
=AA{AA\A33A=qA
=A33A  A{A
A
=A癚AApA(AAQA=qARAAA
AA{ARApAffAAAAzA
A\AA(AGApA=qAAAffAffA=qB\)BBB33BB
=qBB
=B  BffB  BHB\)BHBzBBBBHBGBQB
BRB B =qA
=AzAQAAA=qAA\ARAB 
=A{A=qB(BB33ARARAA
AAffAzApABAQA\)A
A
=AA\)A
=AB zAQAzARAA33A\)ARAAffAA33A33A(AHAAApAffAGA=qAGAGAAffA(AAA  AQA\AffB
A
=ABB  B=qB(BffBB QBRB B (BBBB	33B  B
B  B\)B\B33A{AAAGA
=B B  BzBB zBRAHA33ApAzA\A=qB ffAHA33AHA\B BB  BBGBBzBB{BQA=qAffARB HBAGA\)AAAffAGAQARAGAAAA=qAA\)AA=qA\)AA  A{AA  A{A
A  AA\AffAQAARAQB zA{AHBQBHB BRB ABB\)B
B\BB{BB=qBBB(BBBffBB\BBGB=qB	33B	\BGB HAABB pAGA33A
AffAzAA
AA  AAB B  B HA
=B BB HB\B	BB\BBGB
ffB
B
=B	BffAARAffA\AAffAA33AGAAAGAffA
AA
AAAAAQA
=A
AA{A
AA33A{AAzAQA\AABBBQB  B\BB\)BBB\BB33BffBRB=qBBzB33BBffB	RBGB=qB	{BzBBBB
=BGB
B pAA  AApAAHB ABA\)B =qApA\)AA(AzAApBHBpB\)BBAGB
AARAAQAA=qAB   AAA  AAA=qAA
AA
AA
AA
AA
AA
B  B B=qAHAQA33AAAGAHAA陚A=qBGBRBBBRBBffB  B
=BBBB	BzB
ffB=qBBffB
BHBB	\BpB
=BBRB
{BHBpB33B
zB	BffBBBBB=qBQAA\AzAAffB(BzBBpB	
A{ABQARAGB 
=BB
B
=AGAAHA33B33BzBGB{BAffAHAffAAAAA33A
AzARB A  ABQA33A\AzApBffAQAAGAAHA
A
=A
A\)A\)AܣAA
=A33AAzAƸRAۙAA(A  A
AA{AGAA\)AzA\)A
BBzBHBAAARA(A\)A{B =qAGA
=AA33AQAARAGAA
AzAA33AzAأApA
=AAǙAHAA  AAAQA(AA(AAQA
=AAƏ\AƏ\AAA\A=qAA\ApAApAAAA{ApARAAAAǙAA\)AAAHAAAk
AA33Ar{Aj=qAlzAffA(A
=AA33A
=AAQA\)ARAAٙA
AɅA=qAApAQAAAA
=A{AzAQA\)AA  A  AAApA
=A{AffA؏\AۮA33A  AzAHAAAAQAAޏ\A  A  AŮA=qAAAǅAٮA
=A(AA֏\A(AܸRAGA=qAAAܸRAAٙAQAAAA\AzAAApAA  AA33A(AAApB AAAARApA33A=qAAAA\)ApAzAGA  A\)AAQB 
=ARAGAQA
A\)A
=A{AAzA=qA\)A=qAQAۅA33A33AߙA\)ARA\)A=qA=qAA
AAA33AGA
AHA33AAٮAffAAɮA  A33AAAӮAA\)A33A33AQAȏ\A=qA{AHAיAծAHA
A
=A(A͙AۅAzAʣAA33AAQA\)AzAA33A\)AǅAGAA{AGA33AɅAAȸRAARAA\)A=qAA33AAQA=qApAAAffA(A
AAhAUAfHATA_
Ah  A[\)AAAS
AbHAN{A<AAGA?
=AOAIA_AbHAjRANffA@A-GA7
A,  A?
=A4QA7
A-GA6RA9AG33ADzA2ffA1A5GA3A#A
@@ə@{AA @R@(@z@@Q@p@\@p@(@
=@33@33A33@@(@
@
=@ָRAA.R@pAzA>RAA&\A0QA]GAAALQAUA[
AeA]AaAdQAhzAd(ApAp(AzA\AGAAzAA=qARA33AGAGA(AAApAA33AAAAAHAzAAAAAffARARA33AQA\AA
=AzARApA
AAHAA=qAHA{AffAA\)AHAAA33AzAAAA(AθRAA\)AA\)AAA\)AܸRA=qA{A{AA33ARAAffAGAAffAzAQA\AAzAυAAzAA(A  AHA
=AApA33AffAAģA  AAAGAQAÅA=qA
AGA
A\)AA\)A  AQA\)AQA\)AAA(ApAAA
=ApA=qA  A=qAA{AA߮AA\)A(A\)A{A\AGAGA  A(AffAAGA\AA{A  A(A=qAQAA
=AA{A
AA{AQAҸRAA(A㙚A
=AٙA˅AGAHAA  AAǙA  AAA(A
=A33AHA\)A(AQAAA{Aԏ\AיA33AzA
=A33AA܏\AA{A\)AffA\)AApA{A(AǙAAA(AͅA\)AǙARAAA\)AQAHAHA\AzAA=qAA
=AffAîA
A\AA
=A
AAGAApAzAA
AQA=qAA{AAՅAGA=qAA33AA(AAAхA
=AA(A  AAzA\)A(AGAAϮA
ARAÙAA33A\)A\)A\AHA
AAAGAAHA(AAQA=qAAA(AA{AAApA  A
AARAA\AAzAzAAGA(ApApApAAQA{A=qAffAA(AA  ARA  A\ARAÅAGA\)AApAGAA
=AffAGAAHAAA  ApA(AGAA=qẠAzA(AA  AA{AAAzA\)A{AQAARA  AA\)A\)AffAHA  AAHAffAAٙAGAGA{A=qAQA\)AffAA\AGAQAzA=qA(A
AÅA£AAAAAAA  AA
=A
=AA(AzA
=AQApA
=A\)ApAAARAAAA܏\AffAzAA=qA
AHA{AGA  A
=A˅AffA
=AA
=AzAzAzAQA{A  AA
=A33AffApA33AGAϙAA33A(Aԏ\AA{A\)AApAffAA=qA=qAA
AA(AffAAŅAHA{A  AzA33AHAAA(AApAA=qA{AHA33AApApA(AHA\)AAAHAAȣAA
=AHAzAA  A
=A\)A\AA
A¸RA\)AzAHAAffAA=qA=qA
=ApAA
=A{A=qAAA
=AHAAffA
ApA
A\)AHAA=qAA֏\AGAAAGAHA{AAHARAᙚA(A
AzAffAA뙚AA=qA=qAA(A\)A{A=qA33AA{A=qApAԣẠAəA(A=qA\)AApA33AߙA33AӮAAAAٮAQApApAAQAAAffAzAGAzA\)AAA
=AffA=qAAHAGB
B 
AzApARAAA\)AA
=AQA33A33AA33ApB RAAHAAA
AA  A=qAAffA
AA
=ABGAAA=qB A
A\B GAHAB
=A\BpA
ARAB GB   ARB BBHBApBB
=BB =qAGB\BzBffB 
=A{B  B33B=qAB \)AA(AAAAA(A33A33AffAAAGA
A\)A33A33AffB GBB=qBzB  B=qBAzBB
=ABB\BB
B{AHA(A33A
AGA\)BffBpAB=qBHABBGAzAAHA
=BpAAB (BQA
AzB \ApAzBQBHBpBzB pB(BB\BzBffBAAHBAAAARA{AAAHAA
=ApA\)AGA(AffA\)A{AAQAAzAAA33AAA\A{Aڏ\AApApAA33A\)A
=AQAҸRAA33AٙA
=A\B \)B BpA\)AAB \)A
AA
B 33AHA(AffAAApAffAffA
AAARAHAA
AApA{A33A(AA\)A
ARA(AzA\AQAA(AAffA=qApAHA{A=qAGA{AA\AHAB  BBBB(BBpBpB33B(A\)A33AQA33AGA  ARAAA
AQAA{A  A
=A\AA33A(A33A
AffA\AHA\AۮAffA33AA33AA
=A33A
A33A  A(ARAApB ffA=qA
A\A  AGApA
ApAAApApAAAA33A=qAGA
=A홚AA홚ARAAAAAAffBffBzA  BpA\)B B  BB  BAA
AHA
=A(A
B 
=AA{AzA홚AARA=qARAAAAzAAGARA
=AAAzB AAARAA
AffAzAAQA33AA  A\A\)A33A{ARA\)ApAB \A\)ABpBB HBffB
=B	B

BGB	RB
HB
RB	\B	\)B	B	{B
B
GBB\BB AAGA33A  ApAGAAHAApA\)ApAQAۙA  AzA{A
=A{AۮA\)A{AQARB ARAGB \)A(ApA
=B(B\)B{B \AA  AAGAzAzAApAA  AQAAHA33ApA  A
=A(AAA33A
A뙚A=qAffAzAGA33A
=AAzAffAA
=AA=qAA\)AAB\)ARAAA(AzABBRB33A
BB 
BB pA  AHA\)A
=AA\)AAAHAAA=qAAAGAHAzAAffAAffAHA
=AARAA(A\AAAffA{AAGAA(ApA{ApAAAA\)ApAHAAA
=AAAA33ApAAzAAHAApAffAAffAQA{AAA=qAAARAQAzAQAA=qAA\)AARAQAffARA{A33AAGARAHAAffApAzAA(ApAAQAQAAA뙚A
=AAAAA{AA噚AzAAAA\AA  A\)A(A33A  AۅAQAHAGAA
=A\AQAAA\)A33ApA
AzAGAAA(AARAA陚AAQARAGAAA\)AA뙚AHAA뙚AAHAۙA(A߅AA\A33A
=A޸RA{AAAQAQA܏\A=qAAAffAzA\)AȣA\A33A\A
=AffA  A33A{A
AA{AAzAffAGA=qAظRAffAAAzA33AAffA\A\A
AHA{A\A{AAA=qA{A
=ARAAۅA=qA  AA؏\ApA֏\AЏ\AхAzA
=A33A=qAAffA{AzApAQAAAəAzAA\)A\AAApAffA{AA  A=qA
AA
=AA
AAQAAA
=A=qApAAGApAGAƸRAffAGARAAď\A  A33A(AәAAҸRApAzAƏ\A(AGA=qAA
AA  A֏\AAׅAA  AAȀ\AAA33AzAHAQA(AAGA\)AAA(AAHAQAAAzAA  AGA
AAQA
=AAA}AAffAHA=qAARAA  A=qApAGA\)AHAQA\)A=qA{A  A\)AGAGAzA=qA\)A=qA{AAGAA(A(AAzRA  AAQA(AAA\)AAAQAA
ARARA¸RAAAHAQAHAAAffAQA(A
=A{AHARAAAHA{A  ApAAHA
=AA33A
A=qAAA
=A
=AzA{AQAAA33AȣAȏ\A
=AA߅AzAffAffAAApA  AAAAȸRA(Ȁ\AApApAGA33AAARA33AA=qAA  AAA=qAA뙚A癚AAAAAA\AAApAA\AA\)A߮A֏\A  AQAGA(AٙAAAߙAA  AA
=AԣAߙA݅AzAAzA33A33A=qA{A\)AAAAA\)AQA{A=qARA=qAAffAffAQAAApARAAzAA33A\AAzApA33A
AffAA33AzAQA
=AzAAAޣAԣAAffAʏ\AAA=qA33A\)AQAAA{A
AQA
=AAA=qAGAAAQA33A\A\)A\AQA߅ARAAAA33AAzA  AAApAAffAABA{AGA{AffA\AAARARA
=AQAzAԣAA(A
=AAA  AAApA=qA\AGA{AA
=AApAAGAHAGAQAAAՅA(AGAHAAAA׮A=qAA\)AGAڏ\A(AHAAffAA=qA(AHA{A
AHA(A  AQAA\A
=AzAffA
=AGAARA=qAA
=A\)ApAffAAGB =qAAHAzA\)A(A33AAAHA\AAA{A(A\)AffBBBGBAzA  ApAAمAffAAApA\)A=qAAGAAApA\)A
AA
=AffAGAA  A
A
=A(A
=A
AGAHA=qAzA  A=qA\AA33A  A\)A  AAA33A{AGA  AARAGA{ARAGAQAHAA\)ARAAAffA(A(AAARApAAAAڸRA
=A33AAffAAAA
=AA33A
=AARAAAB ARA{AA=qB \BpA33B 33B QAffAGAHA\A{A(B 
=ApB zAB BQB ffB BAGAAAЏ\A
=A\)A33ApAQAApAAGAzAA  AA=qA陚A
=AAAׅAAAzAߙA=qAָRA\)A  AQAA
AzA\AQAA(AAQApA33AծAAУAA\)ARA
A\A  AQAߙAA33A
=AffAA\AAA\)A
=A  AGAzAAAAܸRA=qA\)AzAᙚA\A\)AAHAGA33A{AffAA33ApARAA=qA\)AAA(AGA=qApAHAA\)A33A
AHA(AffA=qARA  AQAGA\)AApA
=AҸRA\)AڣAA33A(AAAGB AHB
=B\A\AAAffAAGAHAAAHA
=A֣AffAffAڏ\AzAA͙AffAffAУA(AA=qAυAřA  AAA
AԣAυAAHAApAAApApAQApAffAHA\A\AA=qA\)A=qAHA33A  AzAAAApAA
=A=qA
AA陚AA\)A癚AHAAA{A(A(A\)AɮAQAÅAA
AQAzAQA֣AθRA̸RAQAAAzAAݮA
=A\)A=qA\)A
=AffA
=A\)A=qAAzA{AGAQA{AAA
=A͙AΣA=qAиRAAͮAQAzAA
AAУAAď\AAQA{AӅA˙AAAAȸRA33A  AAAQAӅA  A݅A=qAAzAzA  Aڏ\A
=A33A؏\AAA߅AffA(A
=A߅AܣAApAݮAGAծAAQA(AA\)A\A  A{ApA\AA  AAGAzAԸRApA{A{A{AffAA33AHAڣApAƣARA\AîAAGAGA  AA(A
=A(AAffAυA\)AAŮAGAHAΏ\AzAAθRAAGAߙAA{AGA  AͮA˅A{AffAȣAAAˮAzAϙApA\)AQA\)AGA˙A
=A33AA߅AޣAzAHA㙚A\)AA\AHAzAAApAAAGAA  A
=AA\AffAGAHAGAzApAAA  A{A\)A33ApAzA
A
=AA33A{A
AAAAAA{A
=AHAHA
=A33A\)AAA㙚AffAHA(ApAQA
AͅAA\)AGAљA{Aԏ\AGA=qA=qA
AApA=qAzA
=A
AzAAAAHA
A33AծAA{ApAA{ARA{AA홚AAGAAHA{A
=AAzAffAQAGA
=A
=A{AAA{AHA33A\AffAGAA  AGAGAA\)AA
AQA{AQA33A  AffA(A33AA=qA
=AAApA\)AzAHA  A=qAQAzAAHA=qA
AGA
=A(A(A{A33A33AAңA(A33AAA{ApAGAzAApAffA\)AGAHAҸRA(AAQA
=A=qAAՙA݅A33AᙚAGApAᙚA
=A
=A=qAffAHAA
=A݅AمAGA
=AffAzA(AffAQA(A33A؏\A33Aԏ\AҸRA=qAzAA(Aď\A\)A
AAzAÅAAAA\AAA
AУA{AzAA=qA
=AϙA(AHA33A=qAQA
=A
=AQAљAHA=qA  ApAA
=A\AzAAHAzAQAA(AzA33A{AA
A\)ApA(AA
=AffAAQA\A{A£A(AA
ARA=qA\)AHAŅA£A\A  AA  A{AA33AAGẠAͅAGAAAzAGAָRAQAzAHAQAApAffAAzAƸRA33AA
AAGAGA
AAɅAĸRAAʣA
AA
AAAAAԏ\A=qAQAřA(AAAGA{AQAA  AA{A\AA(AARA=qA=qAAHA  A{AHAAA33AAGAAzAffARARA
=AAAA
=AffA\AGAA  AAffAAAA
=ApAARAЏ\AAAA
=ApA=qAGAʏ\A˅AHAƏ\AʣA{ApA(A˙A̸RAA=qA\AAAQAA=qAzAGApAAAA{A\AzAQAAA=qAHAGAA33AAA\)A\AAA{AA\)AzAGA{A\AzARAAA
A  AGAzA  A33ARAAAAA
AA  AARAA
=ARA
=AAAGA
AAHAzA\)AA=qA33AAHA\A\)A(AA{AA  A
=A=qAHAأA  AHAԸRAffAAGA33AϙAͮAAA(A33ApAәA=qApA\)AAңAәA{A{AAAAA  AAۙAޏ\AٙA33A  AA33A
=AHAQAA=qAQAAȸRAA  AA  A33AHAGAУAAAڣAzAřAAŅAA\)AQA33AQA(AA
AӮA  AA(AA33AřAǅAAzAQȀ\AAA
A(AAУAzAA
=AÅAA
=AffA
=AQA
=Aď\AəAHAϙAAQAGA{AθRA\)A\)AAGA33A=qAӮAӅA{A=qAAA=qA(A33ApAzAA\AffAңA\)AA=qȀ\AУA=qAQA  AHA
ARARAzAGApAAƸRA  AȸRApA
A(A33A\AGA  AzAA33A  AAA=qAffAAA
ApAffAA\)A
AzAGAA\)AAˮAAA׮A=qAffA\)ApA
AڣAîA=qAAffA
=AHA  AA33AأA\)AffAϮAQA  A͙AˮA\)AAzAAÅAHAʏ\AҸRAՅAծAffAzA{A=qAϙAҏ\AffAAAAA
Aʏ\Aҏ\A{AQA\)A  A\)A
=A(AHAÅAffAGARAffAHA
AffAA33ARAA\A=qAzAAHAGA{AGAzAA\)AzAHAQAAîAzA(A
AHApAA֣AAHAAϮA
A
=AffA  AA噚AffApA
=A{AHA\)A=qA=qA
=AΣA(A
A  A\A\)AA
=AAңAAЏ\Aҏ\AԣAиRA͙AA{Aȏ\AAîAA˙A  AGAGAQAzAAQAA\)AڣAGA  ApAGAظRAָRA=qA(AřA
=Aʏ\AQAAQAAGA  AܸRA
=A{A33A\)AAApAхAA£AARAƣA˅A(Aҏ\A
=AԣA\)AAGAׅAA(AzA
AApApA\AHA
AGA33ARAHA=qAAffAAA{A(A뙚A\AA=qAA(AAA\A
ApAAAApA33AHAAQAApA{A{A\ARAA=qA\AAzA܏\AAA  AAGAGAzAA33AAHAΏ\A  A
AzAיAQAGA\)ApAQA  AAQA33ARAffAǙAAA
=AGApAGA33A
=A(A
=ARAAffBBQBzBB
BB
BB  B\B
=BBQBBQBQBpB=qB
=B33B BBB  BpB
(B{B  BHBBzB{AAAAHABB
=B33B B
=B AAA33A=qAQAQAQBRARA=qA(BRBBffBB(A
=AA(AGAA=qAQAHAGAAHA
=AQA\A\A=qAzA33AA\)A  AQAAA\)A{A
A  A
ApA33A33AAA\A홚A\)AAAGARAB (AA=qAB{BQBB{BB\)BB
BB33B
B=qB=qB	BGBpB\)B
=BHBHBBRB
BB
B33BHBQB
B RB\BBBBzBARB (A\A
AB=qAB {A33ApB {BGAAA\AAAAAB\AzApA
=AffA\)ApAA(A=qAzARA  AA
AA  A
AQAAzAzA=qAGAׅAٮAzA\)A33AA{AQA(A
AHA\ARA=qA(AAAA\AffAzA  AޣA\A(AA\AA  AA\A33AA(ARAzAA
AҸRA(A\AA=qA(A33AAHA
=A{A  AAAHAA  A޸RA  AA  AffA{A=qAAAffA(A=qAQApAHA=qA=qA\)A=qAA
=A
A=qAHAAGAAAGA\AA\)A
=AA
AA\AA  AQAHAzAA  ApA=qA  AHAAȸRAA
A=qAݙA(A33A\)ARApAHAAAߙA=qA33A{AAA=qA\)AAHA\A{AAمA33AхAA33AѮAA=qAAA\)ApAޣA{A  A
=A=qA޸RAARAA  A
=ARAGAAzAAApApA{A\)AGA33A\)AHA=qAzAA(AHA=qA33A\)AA  A陚AAA33AA߮AA{A
AAA(AzA=qAϙA(A֣AGAϮAУAHA33AAAA噚AGA\)AظRApAԣA݅A
A33AAAA  A(AAQAA{ApA
=AHARApAAARA{AAAQAA33AA
AأAApAAA  A
=AAAQA
=AA  A{AAApApA
A
A(AA֏\AA
=AQAffA  AAA  A
=AQA  AA(AGAȸRAGAQA33AHAAAAʣAQA=qA
AAHAAУAQA{AAGAřA\)A{AffAA
AzA{Aҏ\AA=qApAܸRAߙA
=A\A33AAHA(AAApA
AzA
AA33A33A  AA  A  A{AAAAGAAHApA=qAAظRAA(AAAAARAA\AAA  AGA\)A  AޣAHA
AA(AGAffA\AAҏ\AAA  A
AˮAA
AAУAA
A33AAәAGA  A\)A
=A(AӅA=qAHAڣApA
A˅A{AəA=qAAʏ\A33A
=A  ApAQA=qAAA
=AQAA  AAHARA  AffARAGAA  A؏\AݮAۙA
AA  ApA
=AHApAGAA֏\A؏\A
AzAAffAAApAA(A(AHAHAHA{A=qA\)ARA
ẠA33ARAۅAAAA(AA\)AzAAA  AAAApAGAA  AffA
=AAAAHARAffAޣA{AGA
A  AۅAAzA33AA33A\A
AGAQAָRA{AAA  A(AAQA
=AzAA33B GB (A=qAAGAGA
AA{AQAAHA  AAzARAffAzA
=ApAzAQA
=AA
AGA{A陚AARA(A33ARAffAAA(AAGAAAAAA
=AAA33AAHA  AffA{A
A  AQAA
AAAQA
AA\)AAAffA33A(ApAAAA̸RAՙAARAffAQA\)AffA\)A
=A{AݙAAA
=A
=A  ApAGAָRA(AQA\A噚A\A=qA33AA{AAAGA(AffAAHA\)AA㙚A(A\)ARA噚AAGAzAA\A
AzAۙAzA33AمAڸRAAAHA=qAQAAمA{Aڏ\ApAA\A㙚A
AffAAGA
A֏\Aԏ\AAԸRA{AӮA  A33AڣA  Aڏ\AzA
=A\)A(A{AޣA
=AHApA  ARAQAأAAۙAQAA
AAAAAӅA͙AAAљAԸRAzA{ApAڸRAHARA{A\)A\)A
=AQA{A
=AAA
=A
=AAAAzAHAA\A{A\AGAA\AA\)AA{A=qA\AA\)AGApAzA\)AAAAAA  AAAAHA33AAՙAQA
A(A=qA\)AՙAָRAffAԏ\AՙA(ApAңA33ApAәA\)A
=AAzA
AAGA\)AffA\)AAHAAAA{AÅAA  AQAхA
=A=qAAAzA{AAAA=qAGA\)ARA\)AHA
=AGA=qA\)AAAAA
=AA  AA=qAAzA(ApA=qAAffAAAGA\)A=qA홚AQAAݮApAzAHA  A{AzA(A
=A\AA
AAAApAApAA(A
=ApA=qA{AApAHAAHA  Aď\AřAȣAzAȸRA
=A  A\A{A
AA33A{A33AHA\)AָRAA\)AAAݙApAᙚApAAA֏\A  AGA=qAQA˙AHA33A=qA33AffAARAffAzAHA
=A뙚AAA
AzAHAA{A=qAɅAAȣApAQA
A
=ApAυA\)AӮA{A(A=qA(AAQA(AAߙAQA  AGA
A  A  A33AHAAA  AGA
AGA33AAzAA{A֣A33A
AzA
=A  A
=AA
AʸRA˅AA33AHAĸRAAÅApAAAA\)AA33AApAAǮAϙAffAA\)AHAAʸRA(AAǮA
=AAAA=qA
AAď\A¸RAȏ\A\)A\AffA  ApAffAԣAHARAGAzAApAʸRA˅A  AGA\)A=qAffAϮAA
=AAAAHARAA{AA
=A\A\ARAAA
=AޣAAߙA
=A
=AHAffAQAA{A=qAA(A͙A33AffAȏ\AAHAAAGAApA
=AzAAÅȀ\ApA  AzAHAAzAθRA
AGAAQAƏ\ApApAAAGAAA33A33ApAڣAՅAәAA{AffAGAQAA{A܏\A
=AA݅Aڏ\A
AۮAۅAۙAAA=qA޸RA
=Aڏ\AיA(AQA33A  A(A
=A(AGA
AzAApAHA
AHA\)A
A33A(AAAA  AzAffA߅AAGAffAHA=qA
AA{A(AGAQA
A33A{AA(AA(A=qA
=A{ARAAAHAA=qA
=AAGAHAA
AHA=qA\ARA
=AQA
=A
=AAAQAffAAHAA{A  AzApA  AAHAAAApAAARAHAۙAApAAQA޸RAA  AAAAAGBGB BRBzBB33B	33BB 
=AAAA\A
=A  A33A\AAAA\AA\)A(A(AA\)AܸRA=qAHA(AָRA{ẠAAׅA޸RAA߅AAAffA=qAAffBpA\)A(A{BBQARBB BGBQBHB
=ARB\)B
=AAAA{ApAAGA{AARA
A
=AAGAڸRAڏ\A  AHAffAAϙA33A
ARA{A\)ApAA(ApA
AzAA(A\)A{AAARAzA{A\A  AffAAHAQA  AAAA(A  A
ApAA{A=qApApAυA{AAzAffApA
A
=AHAAA
=AAffA(A\)AA\)A(AzAͅA  AA(AиRAffApA\)AQA
A\)A
=AGA(AQApA{AA33A
=A\)AAApA
=AGAzA癚AAAAAffAQA\A\A(AQAAAAAAzAzAAARAAGAA\A
AA\A
=A  AA(A
AzApA
AApAffAGAA߮A{A
=AٮAڏ\AߙAA\A\)AAAA癚A癚AA=qAA\)ApA33AffAA
=A
AffA  AHA
AA33AARA
A33AAA\)A=qA\AffA  A(AQAAB=qB AARB \AAHAAAAA  AAAAHA\)A\AA
=AA
=A33A33A
=AffA\A=qAA=qAQA
=AffARAzAAAAffAAffAAAAGAHAQAGApAA\AHARAQA33A{A\AA(AAzAzAAzARA\)AzA
A
AAffA
=A\A33AffA{AzA
=ApAffA33A\)AAAۅA
=AAAAۙAAA\A\A뙚AzA33AB GABBpAB ffABAA
AffAA
=AzAAAAAAA
A
A(AGAA(AHAQAAAA\AAAffAA\AAAB   A\AAAAGBRBffB\BzB=qB\)B
=ApA\AAAA  A
=A㙚AzAA\)AA(AA  AHAzAAAHApAQAHA  A=qAAAGA
=AAAAA噚AGAAAQAARA߅A  AAAAۮA{AzA{A  AӮAAGApAffAď\A{A{AمARAARA=qA(ARAHAA{A\)A=qAAAAzAAAQAHA33AffA
=AzA\A
AA(A
A=qAA(AAA߮AffAQAzA33AظRAHA33ApA(AHA  AׅA
=A33AAHApAHA=qA=qAA\AA\)AHAApAۮAڣA
AQA޸RAڣAARA{AffAAAQAA  AzA\)A=qA
=A\B HBBRB=qBHBffBffBBQBRBBBB\)A=qAAA33B GAApAApAAQA33ApA\)AGAzA{A  A33A33AA{AAAA(AQAApAQA
AA
A\)A\A(AzAHA\)AᙚAAA=qA噚A
=AA=qAA
A=qAA
=AA=qAA
=AAAGAAGA
ARA\)A\)A=qA\)AAHA=qA{A(A{AAA
A33ARAAHABBzB BAHB HAB B B BBB{B(B  AAAzA33AAAApBHAAAApA=qA
AA
=AQAffAGA\)AA
=BBBB 
AB 
=AzAA\)AA\AB  A\AGAQA\AAAApAA  AApAQARAffARA\AzARAAAAAAHApA(AAAAAA  ApAA
AQAzAzAApAAffBB  B
B	pBHBzB
B
{B  B
=B

B
pBHBBBB
=AAGA=qA
A{A
=A
=A33ApA33AffARAA(A
AQAzA\)AA{A
=BB	\B{BB
B{B
RB=qBzAffBQBBzB\)B 33A\B33B{B BBB(AGAA{AA{A(AAGAffAB 
=B ABffApA  B QAQABB(AQAB\)BpBHBHB\BB{BBB
BpB
=B\BBzBBRB\BB	zBABB\)B	pB
=B
HB
BRBGBBB	\B
BB	BBB
BRB
BBB  BQBBBBGBpBB
RAHB QB	HBB
B
\BGB=qB
BBBA\)A
=AQA\ApAGA33ARAA(A{B 33AA\)ApAAA
AQAffA=qA{A33B A{A(B33B(B\BHBBpB\B(BGB\BzB(BB	\)B	B
B
B	(B(B33BB
\)BB{BBBBzB  B  B(BBB	
BHBBQB\)BRBffBQB(BHB{B
B33B
B
33BBBBB{B
\)B
zB	  BGBB=qB
BB33B
=B{B

=BQBffB
=B\AGA(A  ApA=qAA33AAAAGAQAAGApA\)A
=A
A  A  AAzAffAA
AAGA
A33AzAA
AAAHA=qAAffAAA(AA=qAARA33AA׮AGA\)AA
=A  AAQABBBB\B
(B	BB  B=qB	(B
B33BB(B\)BBBpB	B=qB	B	B
GBGB{B  BB{B
33B33BBB\)BffB 33B  BB\)AB(B
B
B(B
B
=BRBB(B
BB	{B

=B33BHAGAQA\BzAAA=qBGB\)BRBzB=qBB\BBQB(BBpBBB
B  B	pB(B
=B{B(B
B\BffBBBB
  B
BBBBRBBBA
ABB  B BBBzB(B	RBHB
BBBGBGBB33BGBzBRB33AB\)BB
=B   AA{A
A
=A{ARB (B \BHBB(BBA
=B  A\)AA{B ApA{A(AA(A
=A(A=qA=qAAAzA
=ARAA33A\AA\)AAA\)AA{A\)B
=BRBpAzA(AffAHApAA=qAffAGAA(AAA\)A\AQA=qA\)B B  B=qBBpBB33BQARBB33BBB
BRB\BB
B{BBAA홚AAAQApAA\)AQApA{AAGA
=AzARAA홚AAffAA݅A
=AAGA=qAA\)A{A33AۮAApA  AAӅAffAȸRApA(A=qA\)AzAᙚA{AͮA
=AיAʣAߙAAQAAQAffARA33A\)A=qAۙAA33AHAA陚AffAA\)AffAA
A=qB\BffAHA
B GBHB QAB B pB  BzB{B(B\)BpBB\BB(B  B
=BBB=qB zAAzAARAA33AAA
=B33BB(BAQAHB\B\)B33B
BBHAGB\B
=BBpA33A(A
B  AAzAAA
A
A(A=qAA{ApApAA\)A  AAAAA\A=qA癚A\A{AQAAAAQA噚AHApAAHAAB 
=BpBpBQBB{B\AA\)AB B AA\)AHAB QBBB BAAAGA  AA
=AApA\)AzAzAzAffAAHAAA33AQAՙA33AA=qA33AQAHAzApAGAGA  AHA߮ApAzA\)AAAQAQA{A{AzApA  A̸RApAÙAzAẠAA\A{AAAQAÅAApA=qA
AzAÅAffA=qApAA{AHApAAffAAۙAA{AAGApAHAAffA=qA33ApA(A=qAA
AHA=qApA{AAA{AGA  AAGAAȸRAͮA{AɮAAzA(A
A
A
AҸRA\)AA33AA
=AA{A  A  AA
=AA
AA
AzAA{A=qAȏ\A{AAHAGAʸRApA33AAA
=A
AHAzA33AHAAAAAУAхA  ApAA
=AA\A(A33AA33A33AθRAApAA߅A(AQAGA
AffA(AAAzAQAAffAffAGA㙚A(A\A{AApAӅA(A{AAƏ\AffAGAGAzAޏ\AGA
A=qA߅A{AAAAHA
AAzA(A(A=qA\A\AAAAAAA=qAAHA=qAzAffAzAGA  A\)AAA  A=qAA
AA¸RAHAzAAffA{A{AAHAQAƏ\A(AǅAA  AGAHA{AzAAApAzAzA=qA  A=qApAظRAffAHAQA\A33AA
A\AzA
=A\AQAffApA=qAARAzAAAHAA  AHAffAffA{A33A(AAHAzAߙAA
=AߙA  AۮA
=A\)A  A
=A陚A33AQAҸRA  AA(AƣAAAHA{AͅȀ\Aʏ\AA
=A
=A(AʸRAˮAA{AAϮAHA
=AυAϙA(AA\)A
=AȀ\AAͅAffA33AAAffAzA\)A{ẠAQAAHAHAңA{AAzAҏ\AAffAzApA(A=qAᙚAQA=qAA\)AԣAQA  AиRAAͮAAAׅA
=AzA=qAѮAffẠA=qAQAAQAAzA{AܣA33A
=AARA㙚AAzAծApA(A=qAڸRAA  A33AA(AǮAffA
=AAHAGA=qAGA
=AȸRAǅAHAzA\)A{A\)A
=ARAA33A=qA{A=qARAAzAffA{A33AA(ARA
=AA͙AGAƸRA=qAA\)Aď\AHAA
=AمA=qAffAHAΏ\A33AأA33ApAAHAApA
=ApAffAA{AޣAGA(AzA{AͅAיAGA
=A33A  AǅAffA
=AzA=qAHAQA
AA
=AAA
=AGA
A\)AA
AA͙AƸRAGA33A  A33AffA(AQA=qAA\)AʸRA=qA33A
=A
=A
=AAA%AffA  Aȏ\AHAĸRA33A
=A
=AA£A33AA
ApA=qAיA(AQAڏ\A33AAA
AAA߮AGAݙAHAQA(AAApAQAAQA
AGAQAԸRAA=qAGAAGA33AəAƣAHAA  AffAAGAA33AzA\)AAffAA{AAA=qA
=AGAA(AA\AffA
=AQA{A
=A  ARA(AAAHAHAAQAA
AQARAGA{AQA  A
=AA\AHAAAAA(A=qA(AApA(AAzA\)A
=AffAAzAA{ApAARA(ApAAA{A(A
=AA\)AffA\A
=AA{A\)AAHAAHAA
AA{A\A=qA33A  AHAQAAGAAA  A\A=qAA
=ARAA(AAAzA\)AffA
AGAA  AAAAGAAffA(AQA
=AARA33AGAAAAARA  A\AGApAAA  AAA\A{AQAffAA
=AARAAAffA
=ApA33AAGAAAffA\)ApAA=qA(AzA33AHA\AzA  AzAAAAAƸRAARAQAA
=A
=AHA{AGA
A\AA\)AA=qA=qAHAA  AA\AA33AQAARA
=AAA=qA{AGAAAApAffAA
AAA\AA(AQA̸RAGAA33A(AGAAAQAHAGAApA
AAARAA\AAzA
=A\AAAQARA
AAQAAA
AHAA
A  AHAAHAřApAApAŅA(A
=AAQAHA
=A
=AGA33AAəAAAAzAAAHA\)AHA
AzAAffA\)ARA  ARAHAAzAAAffA(A{AA  A\AAApA(AAAzAQA(AzAARAzA
=AAAAAAGAAQAAAQAA=qApA{A\AAffAApARAA(AA33A33ARA
=AAHAAA{AAA{ApA  AffAAQAzA=qA33AGA
=AAGAAGA\)AƸRA
AŅA(A=qA=qAA\AGA
=A=qA\A  AAHA33A\A¸RAA{AApA
AQAGAQAAAGApAQAHAQAHAAAzA33A
AAQARApAAA\A\)AHAApAA\AAffA=qA(AA
=AAAAA
AzA\)ApARA(A(A  AAHAffA\AAAAApA\AA{AzAAAHAA33AAzAAď\AA=qA{AAAA(AQAzAzAA(A\)AǮAzAĸRAǅA{AǙA(ApA33A=qApAA
=AģApAAGA  AAAffAAAAAAAAAffAffAAARAARAAffAA\ApAHAGAAAAA(AQA  AzAAARAAQA{A=qA(AAA\AA
=A33AGA33AAď\A  A  AəAɮA\)AHAQAǙAA
A
A
=A£A\AAřAzAAA\AAffA
A  AAAA
AGAA=qApAA\A(A  A33A{A33ApAQAffA(A
=A33AA{AA
=AAA\)A(AHA  AzA
A  AzAQAAAHAA  AffA
=A
=AߙAHA(AޣA=qA  AffA\)A
=AHAQA
=A\)A{AffApAݙAGA33AzAQA(AffA(AAQAARA
A  AA\AGA\A33A33AGAGB33A\)AHAA(A=qAAffAzA(A(A\B 33BHBB
=B   AARAAمApA33AApAA
=AAQA
=AAA
A
AA
=AGAARAٙAAA(A
=AٮAQAApAAzAGAA(AGAHA33ApA(AAڏ\ApAGAAzApAHA{ApAA㙚AQAA(ARAAAAA
A\)A陚AA33AAHA\)AAA
AAAA{AffAA(AGA  AGAA=qA\A{AAAAAHAzA(A\AGA(A\AAA
AAAffApAQA(A33A=qAAAHAAffAA33A\A{AGA  A\AzAQAAGAA=qA\)A
A=qAQA33AGAܣAQApA݅A(A{AHAAA\A  A߮A=qAQA{A\)A
AAAA  AAAAAAAA=qARARA
AAffAA\ARA\)AApAAAB ApBQA
=AAQAA
ARA{A33AHA=qA=qAHA(AAAA=qAA\)A=qAAA
A㙚A
=AffA\AA(AGB pBAzBQAA
A\)ApA{A؏\A33A33ARAAA=qAA(AAHAQAffAݙA=qA
AHAGApAиRA(A
AۙAQA(A(AffAAԸRA
=Aҏ\AGAӅAffA\)A\)A{A33A܏\AA
AQA=qAzAA33AA  A33AQA\)AGA  AA\A33AARA=qA33AHAA
=AQAAA  A(AA{AAAA=qAA
=A33A  A=qAGApApAHApBB
A  AffAzA
A홚A\)AA{A\)AAHAᙚA\AQAAAA=qA
=AGAzA  ApA(AA  AAAffA
=A陚A{AAzAAA\)A홚AAzAA  A
A
=AAGARAAzA\)A\AA\)A(AAA(A
A33AffAHA=qA\A
ApA
A\)AAAAAAA
A\AffA{A33A(ApAAHAQAAAA
=AffA
AQA(AAARA  ARAAAAAA33AAA
=A˅A
AzA=qAzAQA  AѮAAҏ\AA=qAA{AQA\)A\)AڸRAzAߙA33AAۅAۅAAA=qA\)A
AA\AzA{ApAA=qAAAAA  A
=A
=AHARApAGAA(AׅAA\AffA\)AA֣AיAAAA33A{ApA33AA\)AHA
=A(A(AHA33AQAAָRA\)AڸRAHA33ApAA  AApAمA33ApA
=AHAA
AGA=qA
AAA
AAAzAHAA\)AAA܏\AAGA33AۅAApA33ApAAޣA{ARA  AGA\)AAzAAAGAffAA\AHAAffAAAA\)AA
A
AHAAͅAʸRA
=AffA߮AQA噚A
=A
AAHA
ARA\)AAA(AA=qARAzARA  A=qAAAzAAAARAffARAAAA\)AQA\)B \)AHBzAQABQA{A=qAAGARA\)A=qA33A\AAAApA
A
AA33AGAA陚A
AGA33A=qAQAAQA33AffA{A33A
=AGAA{AHAA  A\)ARAQAAA(AHApA\)A\AApAAARAA{AA(A뙚AHA  A33A{AA{AQAAAAARAA㙚AA33ApA{A33A=qA
=AffA{AffA=qAzAޏ\AAA\)ApA  AAHA  AQAGARARAAڏ\A\A\ARAAGAA  AA
=AGAGAA33AAGAAAffAzA  A=qAϮA=qAQAՙAA  AمA֣A33AљAffAHA(AzA
=ARAzApAᙚA=qA(A
ApA{AAҸRA
AAA(A33AׅA
=AffAffA33A\)A\)A߮A
AHAAAA
AA33AAffAA
ApAA
A=qA\AA{AAAzAAAAAHA\A\AAA=qA  AAAٮAۅA޸RARA\AA\ApARAzAۙA33AAA33AAAA=qA33AAAA
=ARA{AA{AڸRA޸RA׮A{AQA  AQAظRA=qAA
A
=A
=AظRAأAQApAAHAAA
=AA
=AGA
=A33AGAHAAA
=AAA{A߅AAQA{A\AAA(A
AAQA{A
=ApAGAAA=qAAzAAݮA
AzAzAA\)AAHAA
=AA(A\AA݅AAAAARAB RA(A{AA{A=qAAAGA׮AA㙚A=qAAApAAAޏ\AffA  A33AAzAA\A\)AAAGA33AAAffAHAzA\)A{AffA
=A
=A33A(A  A  A  A=qAAffAAGA(AљAAffA陚A
=AAͅA=qAQAA=qAGA
A͙AA˅AɮAǅAAəAǅAHAA(AQAARAHAÙA
AGA  AA=qA
AzA=qA=qAхAffA\AAffAA  A\)ApA\)A=qA\)AAA\A\)AQAffAA33AA  A\AGA33AApA(A
=A(AzA(AzAQAAffAAAď\A\AHA͙AffA33A{AzAԸRA֣AHẠAffAzAυAQA
=ApAAHAzA\)A  A33A(A\A\)AÅARApAAQApA\AARAAGAzApAʏ\A؏\AиRA
=AA
=A{AA
=A癚A33AA(AHAAHA=qApA  A\AAAٙA  A\)A33AAQAApA  A
AAzA(A\)AՙAA  AңA\)Aԏ\AڣAծAۮA=qAAA{A(A\)AA؏\AffAAAAA{AA33AA=qA(AAGAAޣAAAQA
AAυA\)A{A{AAQA{AAA{A  A  AA33AAAffAGA  A  A\A33AA
A
=AzAۙAQA
=AzAՅAۮA{A\)A\)A{AApA\A
=A  AθRA33A
AzA
=AzAAAיAAQA=qAAAA
AA\)A܏\AzApA  A؏\AQAffA׮AA33AzAQA
=AA(A=qA=qAAAAAA(ApA{A33A{AzAGA
=A\)AծAARAAAQA{AAAѮAAAAHA{A  AУAffA\)A  A33Aď\A
A  AAffA£AAGAAîAřAď\AHAzA¸RAÙAAAA\)AAǅAzAQApAAAAA{AHAffApAʏ\A33AHAǙA=qA  A
=AƸRAHA(AGAGAAGAA{A33A
AAQA(AAA˅AAQAƣA33AĸRAA\AģAA(AzAA
AGA
AA\)AAĸRAAAAAAzAAAAQA(AGApApAARAAȸRA{A
=A֣A=qAAAAAAAzAAffAQA
=A  AAAƸRẠA{A
AA  AAՅA
=A=qA\AA{AA{A=qAљAA=qAApA33AݮA(A  AθRAAQAQAAffAAAAߙAAәA{AՅAљA
A=qA\)AGA  A33A
=AظRAHAffA
=A33A(AQA{AȣAffAAA=qA{AA֣AzAиRA(A\)AGAÙAAA
AGAQA  A\)ARA
AQApA\)AA33AA=qAŅA33AHAffAܸRAʣAƣAÅAǅAffAˮAAHAAApAA
AA
=A\)AGARAzAA  A\AHAffA܏\AۮAمA\)AQAzA
=A\AѮAzAΏ\AARAA=qAAGAAzAA\)AffAzAApAQA
A33ARAA  A\)A¸RAA\AHA
=AAA{AAģAA\AAAAAApAA
=A33AQAAQA\)AAəAHAA
A
AffAхAͮAʏ\A˙A=qApAzAffA{A  A
=AGARA
=A\AffAzAA
=A
A߅A{A\)AQAAzAA
=AAAA
=A{A(A33AGA(AA{A33AУA  AQApA
=AGAA
AGA(AHA
A
AǙA{AȣAAəAɮA\)AA\)A˙AGA  AAQAA\AA33AAAA{A\)AəAzA
A\)AzA\)A߅AřAď\A\AHAQA
=AGA{A\A
A
=A=qAAAA  A
ApAGA  ApAA\ApAAffApA33AAA\A
A=qAAffA\A(A  A=qApAAAď\AAARA\)ARAAGAA\A
=AGAffAAAAAGA
A\)AGA=qAA  AAA{A\)AzAQAA  A{AA\)A
AAA  AHApApA=qAHA=qAAQAAAAAA\AAzA(ApAffA=qAAAHAQAQAQA  AAHAA{AAA\AAQA
A{A  AA(AɅA{AڣAGA؏\AمA{AzA{A33AA
A\)ApA=qAQAA  ARA(AAAA\)AA  AAAAɅA
=A(A=qAffA33AA\A£A=qAzAApA\A\)A(AQA33AAApA33A\)AAAQAңAѮAffAGApA(A{A  A
AAHAA33AA33AAHAzAGA{AAԸRAAzAиRAAÙAAřA
=AAGAÙA\A
=A33A
AAA\)A\A=qA{A{AffA\AAAHApA33AQAzAzA
A33AAA{AAffA(AAAʸRAʏ\A
Aď\AffAͅA  AAϮA
=ApAAffA33A(AQAzARAQA  A=qA\)AffARAAAGAA
=AQAA\)AA\ARA\ARA{AGAffAHAA
AAHAAHAQA\)AzA  ApAA\)AARA33AAQAGAffAGAA{A=qAA
A{A\A(A33ApẠARA
=AA(A
A(AA(AApAQA
A\)A=qA\)AƏ\A\)A33A{A=qAAAA=qA=qApA\A\A{AApAzA{A{A\ApAzA\AA33A\)AAApAApA  AA(AA  AAQAffAAAAHARAARAQAGAɮA\)A\AAGA
A=qAǙAHA\)A33AzA  AAQAQARAzA
=AffAA
=AAAAA(A  Aȏ\AHA
AARARAA˙ApAHAGA33AApA\)AAAzA  A\)A(ApApA(AGAzAQAGAGA(A
A(A
=A\)AA{A33A\A\)A33A
=AQAGAQA33AAA
ARAARApAGA=qAAffAQA(A=qA  AA(A\)A(AGA{Aď\AA\)ARAQAA33AƸRAffAƸRAAA33AHAffAA\AzAAAGAA
A
A  ApAGA\A\AQAAAAApAffA
=AA33AA33AA\AA\AA  AzA\AAApA\)AAzAA
=A=qAA
=AAQA{AA{AHAAAAHA  ARAA33A\)A\A33AHA  AA
=A
=ARA{A(A  ARA(ARAA
AAHAģAƏ\AA
=AARAA33ApA
AAGAHAA{AA\)AA
AAAHAAffAzAAGA33A{AAQA
AA(AffAAA33AA(AAA{A{AA
A
AAAffAA{ARAAffAzApAA\A=qAAQAA  A\ApA33AA\)A\A(AGAQA=qA=qA(AAffAAAAARARAA\A
=AHA(AHA{A  AA  A{AARAAA\)A
AAAQAAzAGA
=A33A
=AAQAAAHA
A
=A  AGAA
=AAAzAffAHA(AQA\)AA\)AAAAGApAAA=qApAA\AAffApAAAA33A  A\AApAzAQAAA=qA=qAAAffAAGA  AA  AGAA(AApAAzAA\)A\A=qAHA\)AAzAAffARAAA\A\)AA\AffAAQAAHAGAAAzAAARA33AAGA\AGAAA=qA{AAAAzAA{AA
=AAA  AAAAAA
=AQARAzAA=qA  A\AAApAAA  AzARA\A{ARAGAA\A33ApA
AzAAAAQA\A33AHA  AA=qApA{AQA
=AAGAA  A33A{AGAAAAffAHA\)A=qAA(A\A
=AffA\A
=AA
A\A  A=qAAGAARAA{AA  A\AAHA{AAAzAzA  ApA  AAAARA(A\A\)AffAA(A33AAAAAAHA\A{AQApAAHAGAƸRAAARA\AAȏ\AAAAAAGA33AA  AAApAAAGAAA33AA
ARA33AA{A=qAAHA
AAAAzA
=AApAGA\A33AAAA  AA=qAAAAǅA33A{ApA  A\A(A\)AAHAA\)AƏ\AHAHAAGAģA\)A˙A
=A\)A\)AǙA{AQAAAAAzAAA(A\)AHAď\AQAʸRA
AA
A33AHAĸRA{AAffA\)AApA\AAffAA=qAAGA\AAQAzA=qAA
AA{A
=AzAGAHA33AA  A\AzAffAHAzAAA
=A
A=qAA=qAHAAA{A
=A33ARAA
AQA\AApAAAAAzA=qA(AzAGA=qAA{AA33AApAA=qApAQA=qAȏ\AAAzAGAƣA33AAʣAʣA=qA\)A{AQA=qAʸRAHA33AzA=qAď\AA  A33AAQAHAAAA  A33AAA33AGAQAA\AAQA\)ApAAHApAAAAAzAzA\A33AHA\)AA  AA  A{AA\AzA\AAAAAHAA=qAA\)A{A{AHAǙAAffAAzAGAA=qA\AAzAAəA  AzAzAA(AîAQARA\)A  A
=AQAAAAAAAAAA(AzAzA
AHApAAQAAHAď\A\)A\AAGAAARA\)A(A\AARAAAHAGA\)AAA
=A
=AAzAApAQAzA(A\A\ApARAAHAA{AHAǅAɅAQApA(AљAGAәAAzAAȏ\A  A\)AиRA\)AAңApA=qA(AʸRAɅAəAîAA
AƣA(AAAQA(AHA
=AA=qAApA=qA=qAѮAиRAGA  AGA=qAď\AǮA¸RA  AffAA¸RAA{AffAƏ\A
=AͅAQAzAQAÅAApAAAAAA33A{AAGAA(A=qARAQA=qA  AAGAzAzApAA  ApAAARAHA\AHA
=A
ARAA{AQA\AAzAAARAAzAzAAGAA¸RARAffAQAAA
AHA(A
AGAAAAAffA
A=qA(A(AffAÅAzA
A=qA
AAHA{AAA  Ȁ\AA(A33A¸RA
=AA33A
=AA\AzA
ApAAQA(A
AApARA
=A(ApA=qA33AAQA=qAAAHA
AAA=qAAffAAAGAAGARAA  AA{AɅAQAAΏ\A
AA33A{A33AffAAQAGA33AHAA=qAA{A\)AffA{A
=A͙A33A\)A  A\AffAAGA33A  AA
AAzAA33AAřA
=AAQAՙA֣A
=A33A֣Aҏ\A
=AиRAA
AA=qAHAQA=qAAAzAƏ\A{AGA33AȣAA
AAGA\AřA=qA
=AAGAAAAԸRAA\)A
=AffAģA=qAGAAGAAA  A33ARAHAÙAffAAffAHAHAHAAAAAAQAA£A=qA
A(AAAǅAHAA  A
AʣAGA
AAHA  AQAffAffAAzA
=A
AAHA33AʣAA{AƏ\AQAǙAȣAffApAǙA
=A
AGA{Ȁ\AffAAĸRAQAAA
=AAɮA33AAA
=AAAA
=A\AzAzA=qAAA¸RAÙAffAGAAQAƣA  AA{AffAAA
=A
=A{A
=AϮA
=AQApA\)A(A{ApAQA{AAHAӅAffAffAzAQAffAAGAffAAA=qAAљA{A{AϮAиRAУAϮA{A  A\)A
AəAAA=qAA
A(A˅A
=AzAʏ\A\)AɮA̸RAAAAA  ApAffA
=ARA\AHAA=qA\A\AA  AffA
AA=qAAffAHAQAARA\AAHAA  AAAAAAA  A(AAAAA
AA  A=qAAAHA  ApAAAQA  A
AAzARAƏ\A{AAˮA(A
=AϙA
=AA
A
Aď\A\AAAGAAzAHAA(AQAA=qApAƏ\A  A33AGAffA=qAHARAffAA  A33AzAAzA=qA(A
=A
A\)AQA
A{A  ApAA\)A
AAHA  AAAA(A=qA\AA33A\)AAAA{AQAHAA33A
A33AQAA
=AQA\A
=AŮAAAAffAřA(AffA\AAĸRA{AGA˅ApA  AAA
AʣAffA\)A33AΣA(AffA  AHAQAHAЏ\AA{AͮAHAAǅAʸRAQApA  AGAffA  AA  A\)A33Aď\AffAHA\)A=qA¸RA(A=qAzA\AGAffAA33AHApA{A33A\)AA
AȣAȣAȏ\A33A=qAAƏ\ApAzA˙AzA(AͅAӅA  A{AAA
AAۅA33AAzAHAAHA=qAGApAA噚A\A{AᙚARApAQA(AمA
=AzAGAA=qA=qA
=A
=ApA33A  A=qAݙA=qA=qAAڏ\A=qAAffAA33A߅A{AzA؏\A{AAffAߙA
=AA=qA؏\AAAA{A֏\AָRA  ApAAHAffAأAAAHA\)AzAffA
AAA
AQAQA(AHA
=AAظRAׅAffA{AApA(AHApAڏ\AۙAzA=qAAAAA\)A噚AApA\)AzA
=AffAA=qAQAffA\)A
AA\)AHAA  AQAHA{AAۙA(AQA\)AA݅AGAHAAzA33A
ApA33A=qAA
=AAA  A
=A{AGA=qAAGA  AAApAA33A
=ApAA\)AzAffAAAAA֏\AAڣAA\)AzA
=AA\)A33A޸RAHAݙAA߮A{A  AAA=qAHA\)A  A
=A(A
A\AHA\A  A  ApAA33ARAAAQAzAffAA  A  AHAAA33AApA
A{AzAQAzAGAᙚA\AzAA{A  ApA
=AzA
ARAHARAffAzA㙚A33A\)AApAA  A=qAAAA  A׮A׮A\)AA(AA֣AffAAAQAָRA֣AA  A  A=qA
AׅAAAQAۅA{AffA  AAA\)AAA  A
=A\ARAGAA
A㙚A
=AQA(A  AA=qA噚AA㙚AAHA{ApAAAARAApAA33AApA=qA{AzA
A
AߙAA  AApA  AzAAAAAA噚AzAQAAGAQA㙚ApAA
=AۮAمApAݮAA\)AۅAApAAA\)AϙAHAϙApA
=AϙAQAϙAzA̸RAУA\)A33AHApA\)A\)A  A{AffAzA
=AAzAzAA홚A=qAHAA\AffA
=AzA޸RA噚A{A\)A
=AAA33A߮A\ApA\)AAA\AA\AQA\)AAݮAGA(AᙚA\)A33AffA陚ApA
A(A(A
=AAzA\)AGA\)A33A
=AARAzAzA
=AApApA
A߅AAAA
=Aڏ\AGAיA\)AffA=qAA(A=qA\)A{AӅAAA{A{AԣA
=A
AܣAAAAzAڏ\AffAAffA\)A
A{A=qAzAApAAHAA33AHA
=AA33AA\)AAzApA
=A
ARA=qAA\AffA{AAHA=qAffA=qA{AGApAA=qAQAHA\)A癚A陚AzAQAAAAA
=AAA(A  A=qA噚AHAAGA33AA癚AAA\ARA{A\)AAHAA\AApARA
AAQA\A{AA=qA
=AApA33A
=AAzA=qAAHAA(ApAAffAffA33AA\AA
=AAAGA\A\A
A=qAAA(A{A(AAGAHApA  AzAAGAA{AAAQA{A  A33AAAAAAAzAHAAAffA=qAHAffAAAGAAGA
=ApAAA33A(AA(A(A\AAGApAAQB{A33B HA\)A
A33AA33BAAAAA\AAAQAAAzA  AGA33A=qA
AQA\)AApAAA=qA(AAAGAARAA33AffAffA=qAAHA(A\A
=ARAAB AB(BB
BffAA\)A(AffA
=AAAA
=ARBAB B BBQBQB  B\BQA\ARAzA  A\)AHAAHA\)AAQAAARAAAGAAA=qA(AQA\AA\)A=qA{AAA33A  A߮A33A=qAzA
A\)ARA\)B \AQBzB=qBffBBAB =qA\B BB (B\)B
B\)BAARA{AAAffAGA\AzA  ARAAA(A=qAA33A33B\BHAA{AA{AB33B 33B
=BB  B\)B
BB\)B{B
=BHB{AA
=A
AA(AAffARAHAAHAיAԸRAٙAAAAApAA33AffAݮA=qAׅAffA{AAzAAHAAzAA=qAAffA  AڣA=qAzAAA癚A  AA{AzAHA33AAHAA
=AARApAA=qAzA\)AApA33AAARA\)AۅAA޸RAGAAAAGAA=qAAHA
=AAHAzAGAffAffA(AffA33A\)AAA\)A=qA
A=qAA陚A33ApA33AHA33AAB HA
AAAAApA홚AffA  AHApAHAffAQAHA
=AffAffB zAAA\)AA(AA{AA
=A{AA
A
AAHA{A\)AAAAA33A=qApAA
AHA33AиRAǅA33ApAA{A{ApA\A33AA  A{AԸRAAQAAHAHAQApA
=AA(AffAۙAApA
AffAУAGAffAGARA\)A\)A33AzARAHA(A(A33AGAApAA{A陚AzAA(A33AzAAޏ\A{AׅA
AA  AHApA\AAAAAAAڸRAGAGA=qA
=A(A
AAЏ\AAԏ\A33A(A
AffAAAڏ\AAA
AQAA33AQA\)A  AzA=qAQAHA{A  A33A(AAA\)A
A̸RAzA\)A{AHAљAzA33AˮAθRA
=AљAA(AA=qAA\)A
=AծAϮAΣAיAGAAA߮AۅAffAٮA޸RA(A܏\AGAԣAAəȀ\AЏ\AGA33AљA33A  A
=A33AffA=qAәAQAARAA=qAԣAхAУAAHB(B   ApBB \)AAB=qBB=qBBffBpBpB
BBHB33BBBBBARA\AGAHA
AAGAffBARBpB
B{B
pB  B
BB
B
B
B=qBBBBAA
=A\)A  AA{A\AA
=A
=AB	\BB
BpBQBBzB

=BHBBBRA  B B \BpB
BB33B33BRA=qA
AApAA=qA{A{AA\)AAA{A  AA
AA  A
AA\A  AAGA  A
ApAzAzAA  AAHAzAffAzApAQA
=AHAQA˅AffAӮAA  A\)AzA{A
=AA(A33AzAîAQA{AAƸRA=qAA=qA=qAHAAAAʏ\AzA
=AAApAAAA
=A=qAظRAAAAʸRAA\A{A=qAAA\AQA
=AffA{A{A=qA\)AA
=AAAzAffA{AAA\)A{AffAAŮAA{AAA=qAHAA  AAÙA33AHAzAHAAѮA\)A(A=qAA{AA
AAAҏ\ApA(AApA
A{AAA
AĸRApAffAAGAͅAHAffAԸRAۅAA  ARAffA\)AA(ARAQA޸RAA
AzA
AAAģAƏ\AAȸRAHA(A\)AA33AͮA(AѮA\)ApAȏ\AAAQARAHA\)AǅAGA  AffA33A
=A
=AffAQAApAA33A
AAՙAمA\)AA
AffA{ARAGAAAA{A\)A֣ApA
=A  AAQAAA\AHAA{A(AAGA(AAAA=qAHAݮA33A33AAffAA\A
A33AA
AQA33A\)A\)A
=A\)A33AAGA\AA  AA
=AۙA
=A  AQA33A{AA{AHA33ARApAA33AᙚAAGAѮAA=qAAAGA{AHBHB{BzB\)B{BB\)BHBBpA
=B AB B B B33B
=B QB{B   B\A
B 
=B BBBBB{BBpBzB  B33B
=BpA{A  A33AB B B (AHA  A{AAA=qAGAA\)AAAA33A{AA\)A\A\)A
B ffA{AHAAAHAA\)A  AffA\AAA\)AffAQA
=A{A(AHBRBpB=qBGB
A
=AB \AA33A{AzAB A
=AffBA{B
=A{A{A{AAApAAQA(A\)ApAAAAAA(A
AAAAA{AGAHARAAA
A׮AAHA
=AQA33AQAAAA
AAzAGA\AffA  AAAffAA  A=qARAAAхA(A=qAHAQApAۮA
=A\)A陚AGA(AA\)A{A33A\)AָRAAGAAݮAAQAGAHA=qAA
=AHAzA  AGAzAffAARAAQAAApA\)ABHAQAQAQAGA33AHAHA=qA
=B BRBGAA
=AAAA(A
=ARA{AڣAəAGAQA֏\A{ApAA{AиRA\)AŅAHA33AɮA=qApA=qA{AAA
=A=qAHA{AffA\)AA  A  AQAGAHA
AܣAۅAQA\)A33A33AHA
A
=A؏\A  AGAHA\)AAAޏ\ApAzAԏ\AffAAAHA
=A\)ApAAzAٙAffApAA
=AAAGA(ARAGA33AHAAA=qA
=A
A
=AՙA
=AA  AffAAΣAAHAHAΏ\AΣAA  AϮAzAA
A
A(ApAzAAƸRA(A(A
A33AQAffA׮AٙAڣAQA{AAffAHAzA\)A  AGA(A
=A{AAffAGAA=qA֣A\)AApAQA޸RA\)AޣA\)AA33BBpB GA\ApApA\AAA{AffA
=AԣAA{AHAңAָRAGAQA
A(A
AAzAGA
A
=AHAҏ\ApAzAΏ\AARAA  A33AffA\)AzAA
A{A=qA33A\)AARAAA\AA(AA  A{A33A\)AAffA33AGA  A33A=qAGA(AAA
=A(AzAA
A(AAAAAA
AQAGARA(AA癚A
=AA
=AA\)A
ARAAffAAA\A癚A(AQAGAQAAA
A  AABRB=qBQABQBGBBAAA{A
=AzA{A(A\AAA(A  AHAGB QAARA
AffAHAGA\BBAA\)AAQAAA陚A\)AA{A33AA{A\)A
=A
=A{B  AAB HB (AA
=AHAAAAA  AB \B(AAAGAAffA
=A
A{Aޏ\AzApA33AHApAHAA{AAA
=A\)AzAA
=AApAHAAQA{AAQAAA33B33AApA\A=qAAzB  BBQBA{AAAQA33AAB (B  BQB33B33BA\AGAGAA(AApAGAGA\AߙAzAA
=A{AQA{AӅA=qAԏ\AA噚AAQBQBBzABRA33A\)B{AAA(AA
=AffAAAAAzAARAAA\AffA{ARApAAA\AApAffB QB AAHAA
AAAAܣAAA{ApA
=AՙAAՅAHAۅAޣAA  A  AGAߙAޏ\AA=qA
AAzA
=AڸRAA(A(ApA33A(A{A{A
A
=AA33AARA=qA㙚AAAA\AARA\AHAQApAHAApApA33AAzA{AA33A  A33A\A  ApARAQA{AHAAffAzA\AGA\)B B
ARB RBzBA\AffAffAܣApA߅A{A
=A޸RA\)ApAޣA{AGA
=AAGA߮A
AffAAHA33AAA
=AA  AHAHAffA
AӮA\)A=qA  AЏ\AQAУAffA\)AA\)BBQB \AQAA\)AzA홚A߅AA
=A33AffA\)A{ApA=qAAAGAGAApA  AffApAAffAAAAޏ\AApA
=AGAHA=qA\AGAzA\)AGAAAᙚAGA
=AQAffAffA=qA
AAGA33AQAA\)AAңAGApAƣA\)AffA  AәAffApA\)AzAAAffA=qA\AA\)A(AA33AAAGAУAڣAHAGAzAA  AхA߮ApAGAA{A33A  A(ApA33AzAܣAzA  AAA  A=qAGA  A
=AHA\)A  AA=qAQA\A
AA噚A㙚A=qA(A33A33AzAA{AffApAffAAԣAA
=AHA癚A\)AHAHA  AȣAǅA33AzAAGA\)A㙚A
A  A(A\AQA(AA
=AA33A(AAHApA{AٙAA{A  AљAAA\)AffA\AApAGAApAzAAAQA\AᙚA33A  A݅A
AݙAڣAAٙA(AQAAHAAffAAAQA(AzAAQA\AAGA=qA\A=qA\)ApA  AAGA
A
Aޏ\A=qAA֣Ȁ\AɮAHAAHA
A{AzA\)AAɅA(AGAzA\)A\AffAиRAQAޣA݅AٮA\)AffAHA  AGAAHAApAA(ApAzA{A33AA{A  AA\)AAA\)AGAٮA
A
=A(AGA܏\A߅AAAAA݅AAA  AAHAQAA  A(A33AA33AzAzAQAڣA
A33AHAҏ\A  AͮAA(AQA{A(A  A
=A߅A\)AݙA  ApA
AzA܏\AAAA33AAQAA=qAzAQAHA=qA؏\A\)A
A=qAAAߙAAAA(AGAAAٙA\)A\)AиRAGApA=qA{AAGAυAϮAA(ApAffAzA
=AffAͮAΏ\AAHAGAAڸRApAڸRA
AHAAQAAAHAǅA  AHAɅAzAzA
A
=AA
A\AAA¸RAĸRApAAɮAAzA(AzA֣AA
=A  A(A
=A
AAAAȀ\AA  AHAffAzAЏ\Aڏ\AʸRA=qAȏ\AA33AGAQA  AAAGApAAƏ\AģAQAQA
AAΏ\A
AQAՅAҏ\AՅAΏ\AzApApAA=qAAARAHA(AzA  AARA  AGAA
AA\A(AffAA
B
=BQAffBBGBBffBB	{B
zBB	33B(B
B	QAGB33B\)BB\)B
BffB
=qB	BpB{B
{B
BB
BB
B	BBRBBGBGBGBB
B
BHBQB
B	B
=B	
B	BHB(B\)BQB ABB\BffB
B  B
{BpB
=BBBBffBHB
B
B
BHBBApAzA  A
AQA  A(A
ARAQA\AA\AAzB GAQB	B33B
BBB
ffB	B
B
=B \)BGB33BBzBGB
BHBB\)BBffBBRB=qB =qAA33AApA  A(BHBABHBBBBBpB	  B\B{BBB
{B
\BBBffB(AGB  A
=A\A=qA
AAAA
AAA
A
=AffA  AA\AA噚A=qAAGA33AGA
=A\)A\)AA܏\A33AAffAA\)B BpBGB  B 
=A
BBBBzBBBBBBBB AB AB ffA{A33AzBAAAGAQA
AA\ARB AA
B
B B   B A\B
=BzBB(BBAzA33AffAAQAGAAA{A\A
AA\A{ARAHA\)AzA
AGAzA=qAHA(A\AAA(AA33A{AzA33A(AQAA  A
B  AB33B\B  B AABBBQApAffB RAA\)A\AGAA(AA\)AAffAzAAAQA  ARApAA\)B BRAAGA
AAApAGBA
=AAB GA㙚AAzA33AA  A  ApAAAApA  A
ARA
AA33AAzAA\)AAA
=A(AGA\)A\)A  A\AzApAЏ\AQAffAޣAffAA{AAGB   A
A(AGA{ApAA33A\AA\)AA\)AA\AՅA{AzAAA33AAGA
A\B \BHBB\)BB\)BBffAARBRBB
AHAAAGAAA33AA\)AAzA\ARAQApAGAAۙAHAffA\)A
A  A=qAAݮAAQA=qAzAAApAAHAGApABGB33A33ApBHBzB	QA
BA33ARAzAAAB   B   B=qBB\BRB A33A\AARAHA(AA(A
=A\)AAAA\AAA33AA
=B A\AGBHAB\ApAGAGAAAA  AAApA  A
=AffAA{AffAAAzAzApA33AzAAAA{AQA
A
=AAARAA  AB BpBffB
=B=qB=qBHB
=BAAA
=AA=qA(AffAAAGA\)BpB\B \)ApA(A(AA\AA33AA33AA  AA홚AApA
A(A
A\AAHAffA\)AzAAARAA=qAAffAA\)A33AߙAAARAAffAHA\)A߅AffAGA{AAAAхAApAAѮAzA
A=qA(AA(A33ApAA
=A
=AffA33AܸRAzAA癚AA
A=qAA\A
=AAzAA\)AA  AAAHAA\ApA
=AAARAApAGAffAQB 
=ARAzAGA(ARAGAA
=AzAHA
AAAA  AffAARAAA{A뙚AAGAAzAHAGAAA=qAAAffAzA{AQApAA
AAA=qA
=AAAAzA\)A33AHA33AA33AQAA\AAAGAffAA
A33AAA\)A
=AAAAGA=qA(ABzB A33BAB BB33BB  B\BB\B(B=qBA33B  A\)A\)AHAAHAAA33AzAGA\A{A(AAzAA{A
AQA(AA  A  A\)A33B(BQA  B	B
QB
BpBB
=B(B

BQB	BffB\)B
33B\)BQBBzBHB=qBHB	GBBHB(B{B
B33BRB	HB	(B\)BB
=BpB
=B(BffB{BpB33B 
BB{BGB{B  B\)B\)BQB (B QB
BHBRBBAA\)A{ABGBAGBBBBARBRAAB 33A33B 33AAApA{B BAA(ARA\A\)B B B A  A=qAAAAAzApAApB AGA33AAHAffBQARB
AGAHB\A\B(BB 
=B 33B\BBBpB{BGBBGBB	B\)B
=BBHBBpBHBBRB{B
RBGB B \B  AA  A=qA33AHAAGA=qAApAA\)A
=ApAA(A\)A=qAzARB 
=A33BBBB\BB	B
=qBRB
AB\BQAAB  BBBffBQB(B{BB	
=B
{BzBB
BBBGBzBpB
BffB33BpB=qBBRA{B B{B\BGBB\)BRB	B\B
ffBpB{B
pB=qBB
HBRB  BABB  BGB
=A\)BA33A33B 33AB B(BB(AB33B =qA
A{AGA33ApAffAHAAA
=AGA\BffBGB{BBB=qBHB{B\BGBB AA
=AA
=A
=A=qAQApAAGAHBA=qBzB  AB \A\)AQB B\B BzB 
AAHB B (BB{B{B	ffB	33BRBpBffBBBGB\B=qB {AAA
=AA(AzA\AHA  AA(AQAAB   A㙚A{AApA\)A(AApA  A33AApA
=AAAA\AzA\)B zBRBBB
=BABB RBAB=qB33BHB  BGB HAB 
ABB=qBGBBB\)ABB(B HB 
=AAffAAA  AAffAA\)A(AffA
A(AAA33A=qAA\AARAzA\)A{AQA{BAQBBBRB	QBB  B\AHAA=qAAA  A=qB {BRB =qBBRAA\A{A
BAffA
=A\AAApAGAHAAGApAA
ApApA33A\)AffAA
=B QAAARA=qAAzBB\)B{BB{AA{AAAGA\)A=qApAGAAHA  AAApA33AA  BzBB AA=qAAffA33AGA
=A(AzAA{AAGAB(B ffB {ABGB
=BB
=B=qB=qBRBB  BA\AA
=AQAAzA{AzAHA
AAA
A
=AAzAA{ARApAAAGABQAA
AAAA(AAB33B\B BpBzB\BQBGB  B
=B 33AHA
A{AGARA(AA(BHBBB AAAAAAA33AB RAB\)B
=BB{BB\BpB
=B\)BzBffBB
=B(BpAA33A{AGAAARAAQA33A(AAApAffA(AAA\A
=A
=AA=qAA  A=qAAARAARAA
=B HB(BRBffB
BpB{B \A\)B B QA33B \B \AQB 
A\AA33AARA
A\)AzAA=qB QAA33AffB 
=BpBBBB33B   A
=ARAA=qA
B ffBA\AAAARAA
=AHAAHAA  ARAAGAffA  ApAQAQA=qAA(A\)AGAQA
AAAzA\AApApAzARAHA  A
AA  A{ARB 33A33AAHA\AffAGAA33AARAHA=qAHA33AA  AAAQAA\A  A\A\AAA\A  AA33AA33AGAApA
A33AHApAzAzA  A
AA\)A
=A=qAAGAARAA  A
A\AffA
AA
=ApA
AQApAA(AB {B zB pB B 
=B GAffA33A{A33AzAAHA\)AA(AA{A=qAAAA
ApAAA
=AA\)AQARAA=qA\)AAHA
A33AAA33ARAA33AApAAA33AQA{A
=A\)A
A\)AAGAzAzA
=A=qA
=AHA
AA\A߅A
AHA\A\)A
A
ApAA
=A{AGAAARAAAA
=A
ApA  AGARAzAAffAQAQAffAA\)A\)AAAAA홚A\A  A\)ApA\)A\)A
=A\AAAQAHA
=A(A
=AzAAzA癚AHA
AzA  AQAffA
A
A㙚AAffAHA
AzAA\A=qA޸RAApA{AAA\)A
AA
AAAGA{AQA33A{A\AQA\A뙚AAAAHAAffA=qAAA(ApAA(AQAAAARAA
=AApA33A癚A=qAGAHAGAۅA(ApARAQA{AQAᙚAA(A  ApAQA33AzA
=AQAzAQAAHAQA\)AzAGAٙAHA
AڸRA=qAQA{AיA
A
=AHApAAAffAzAՙAffAGAAՅAAA(A=qA
AA(AQA޸RA=qA  AA\)A=qAffAAA  AGAzA癚ApAAA
=AQA
A
=AAAA
=A
=AA33AQA
AڸRAA=qA  A=qA{A\)A㙚A\)AAᙚAٮA=qApAHA  AApA(AʣA{AʸRAzAA{AA  AHȀ\AAAQA
=AAGA
AAQAÙAAffAHAǙA  AA(A׮AApAٙAٮAٮAA\)AA(AݙAQAHA(AݮAݙAzAzAϮAAȣA{AApAυA{AAzA
=AAffAQA
=AAffAՅA
AQAHA{A
=AGAQAׅAծAQAA(A=qA
=AAĸRAAGAA\)A33AffA
A
AHA{A
=AǮAҸRA=qAəA\)A(A=qAď\A  AQA\)A(AԸRAAAA{A\A\)AHAA  AAA{AA33AzApA͙AθRAffAQA  A  AљAՅAQAA
AԸRAHAzA33ApȀ\Ȁ\A=qA{AApA33AAAAHAQAAffAGAAffAυA  A̸RẠAϙAA\)A=qAAzAA\)AHAA
AA癚A  AGAffARA\A\AzA{AAǙAGAܸRA֏\AAA
=AzAffAAģA  AQAAA33AA=qAApAAA\)A
=AA33A  AׅAAمAHAθRAAυApA
A
=A
=AǅA  AУAA{AAzAʸRARA\A(AA
A
=A
AffAʣA\)AApAAAޏ\A
AGA33AffA(Aڏ\AHAǙAAͮA  AAԣAHAA33A˙AAAffAAQAAA  A\)A
=AٮA=qA(AffA33Aڏ\AzAՙAHAAA\)AAHA\AQAQA=qA=qAAGA噚AA
=A
=A
AzAA33A
AA\)AA\)AAәAffAAffA=qAA33ApAAffAΏ\A܏\AAHAffA؏\A
=AٮA33A(AAAAݙAA\)A  AHARAGAAQA
A  A
AA(AA\)AA
=AzAGAAzA\A  A\A  AAGA(AApAHAAA\)AApAApAzA(AAߙA33A\)A\)Aޏ\A=qAיAQAzAHAϮAՅA\)AzAffAGA݅AQApA  A  AzAzA33A\)ApA{AAA\)AHA(A33AffAzApA{A  AAQȀ\AA\)AA  AA\AAGAzA\A33AޣA(A֣AHA؏\AׅA(AA  A  AffA
A\)A  AͅAffA  A33A  AAЏ\AA\)AУAA{AAڸRAAA
AݙApAAAzAA  A{AffARAA=qAA=qA陚ApA{AߙAHAAQA
=AQAzA33A
AȸRA  A  AQAAϮAУA
=AffAffA\)AѮA{A(AGAхAӮAA=qA
AAAGARA߅AAARAA  AAمAAA\)AHARAGA
AAA\AAA  AGAffA  A뙚A
=AzA{A(AA  A陚AffAAAׅAQA  AffA=qA(AQAA{A
A33A33AA\AHA
AAHA=qAHA\)AA{AAأAGAQA  A=qAzA33A
A˙AˮA(AffA(A\)AzAA
A{A{AGA{A\ARA{A
=A{A  AAA
=A\)AA\AAzARAzApAAۅA  AָRA  A{AٮAApA{A
AAݮAAApA
=ApAHAAA=qA(AיA؏\A
ApA\AAAA(A33AAffA
A33ApA݅A
A
=ApA\)A33A{AHApAAA33AA  AݙAߙA(A  A33AQAAGA\)AAAAڣA܏\AAzA֣AHA=qAԣAAffA
=AzA㙚AzA{AAzAHAQAGA  AхA  AٮAӅAHA
A
AיAAڏ\AzAHA߮AAAQAHAA  AzA(A
=AGAޣApAzA\AAApA=qAۅAA\)AAffAHAѮAQAAҸRAӅAԣAGAzAAAAυAӅA(A  Aҏ\AӮA\)A33AGAՙAޣAGAAAAffA  AAأAffAzA
=AA{AGARAffAGAffA(ARAHA{A\)AA\AHA=qAzAApA(ApA
AApAA  A
AAffA(A
A33A33AHAA޸RAAzA(ApA\AHA
=AA
AHAAQAA=qAAffA=qAApAAQAޣA
=AߙA\)AzA
ApA݅A{ApAңAAAQAGAծAAAzAARAQA\AAA\AHAHApAAffAAAAAAAHAAAffAAzAAA(AzA
A\AQAA(A(AAQA{AGA\AAAAARAA=qA{A33AA\A\)A陚A
A\AAA33AAffA  AApA(AיAA{AA\)AAAߙApAA  A
AGA\A噚ApA{AQAQAHAARA\AA\)A  A{AAAAA\AAA  ApA=qAAA噚A
AٙAGAAHAAApAzAA
=A{AA
AAzA  AAAA(AAffAA  AffA\)A  ApAAAffA=qAzA
=A
AAGAAAGA=qAffAAGA33AGApAAffARAA33AARAARA\AzAzAApApAAApAQAHAA  A{A=qAzA
A
=AARA
AA\)AzAA{AAzAHAAAA=qARAA33ARApAHAA33AA(A33A\A\)AAffA\A
AAA\A{A33AA\A
=AAAAAA{A
=A=qA=qARAffAA{A  AHAA33ApARAAGA33A
A
A33A=qA\A(A  AAۮAA=qAAzAHApApAAQAAAA
=A\A=qAA=qAGA뙚A
A=qA\)A33A
AAzAA{A\)ApA\)AAA
A33ApA\A=qAAAA(AAAQAAA(AQAAA
AffA{AAAQAARAAAA\AApA(ApAA{AffAGA
=A
=A\)A{A33AA
A(A33AAQA=qA33AQAA=qAHA
=A{AA  AA
AAARA33AGA33A
AA\)A  ARApA\A\)A  A陚A  ARAzAzAӮApAzA=qAAՅA
=AQA
AۮAڣAAڏ\AA݅A݅AٮAAԣAA  AGAA\)AQA\)A噚AAAA(AGA33AQAA
=A33A(AǮA33AʸRA33ApAAQAffAͅAHAAͮAA  A=qAͮAA
=A͙A
=AͅA͙AAAٙA\)A(AHAAzA
AffA
=AAQAA(ApAQAAAA\)AffAAAҏ\AA33A
A{ApApA{ApAHAzA
AAffAAA
=A=qAApAApA  A\AQARABffBBB\BBHB
=B(ABB HB 33B{BB
BBBzBRBBBBB  BB\)BQBzB
B	B	zB	B	HB
=qB	B
GB
\BQAAzAAAAzAHAQABB\)B
=BBQBQBHBpBzBB\BB\)BQB	{B	B	\B{BB\BB
BB=qB\B	GA33AAApA\)AAQA33A\A(ARA=qAzA\)A
ApAGBA\AAAzB  A{AGAARAA{A{AA=qA(A  B33BQBBBzBffBffBffBffB
BAA  AA  A{AA  A\)A(B \AAAAA{A\)AA
AAAA
AA\AAGAB ApAzA
=AGA\)ARA{AAzAAAQA
=B RB \)A  A  A\)A
=AA
AffAAAffA=qAA33ApAA
AA(A33AAAAA(A
AHA
=A\)A
=A\A(A\)A{A\A{AHB AAB 
=B ffAGA
=AApAAA
A33A
=A  AHA=qAA  AAQA33ApAA(AGAAA\)AAQA
=AA\A33A\)ABBAB
B\)BBB {AQAAARA
=A33AGAAHAzAQA\AA=qA=qAA
AA\)A
A
=A{ApAA=qA33AA
=AAHAAA
=A33AQAA(AAHA{AA33AffAARAA\)B 33B BBBBffB
=B=qB{BBRBBGB  B A
=A{AA  A
AHA=qB GAHBpB (AAA=qA
=AAAAA
AAB pAB{AGA33A\A\)AAABGBHB=qB
=BffB\BzBB
{BBBGB\BzB AzB (AAHA
=AA{A  ApA  AzApAHAAQA\ARA33AGAA噚A  A(A\)AA33A
=A\AAffA=qAzAAAQAAB B=qBzBB33AAzAzA(AA\)B B  BQB
B A
A
BpApB 
=A
AA=qAAAAA  A  A=qAA\)AB\BBBB(BBAA(B	33BBzB\BQBpB\BpBBB(B(ApB \)AHABA
=A  A=qApA
AA(AffAAffA  A{AGAA\A{A  AzA\)AA
AGAAzAAAA(A陚AGA홚A  A33AAA=qAA\)AffB 33AB 33A
AffB zB33B  BzBBBB
BAB HB RA(A
=AAffA=qA\AApAzAzA  AffAAHA33AHAAAA  ABBBA\)AHARB {B HA  A\)ApAAAA{AffAGAAAffAHAffAA\)ARA=qA  A(A{AAAGAApA{AAffAAAA陚AAAAA噚A
AAffA
AARAzA  A
=A{ApB =qB BffB33AAAAHAAQAAGAARA{AA{A(AAA
=AARAGApAA
A(AGA
AzAGB =qBffB B ffBB(A(A\)AA
B AA(AzA
=AHAffA(AzAA33A\AA{A癚A=qAffA  A噚ARA癚AA  A(A
=AzAHAأAGA33AGARA
=AA\A\)AA(AA
A\A(A
=A{A(A
A
ApAHAAffA{AGABB\)AAHAA(AApAARAQAzA뙚ApAAffARARA
A\)A=qAGARAHAAA{ARAA(AHAAzAAAffAA
AAAAGA=qA33AAA(AA\)A\)AzApA  A=qA{AA(AA33AA\A\AHA\)A
AAAݮApA{AA=qAHAzAᙚAA\AffAA{A\)AA\)AAGA33A{ApAHA  AǮAAzA=qA=qAGApAffAAQA(Aȏ\A
AɮA{AzA
AGA\)AAAGȀ\A=qA=qAHA=qAffApA\A=qA{AGA  B \AA\AB \AARA
A{A=qA(AQA=qAAA33AffAAGAAA{AAzAffAffA(AHA  ApAGAQAAGAA{AA  ApA\AAQAA{A=qAA(AffA\A(A
AApAAAAAffAA
AB zAB 33B   A
=A\A
B 
=AApAA33A\)A
AA\AA{AAHA  AA  AGA(AffARAffAHAzAffAGApAAHAAApAAAA
AAzAQA\)AAA33AAA33A\)AAAHAAA
=AAAHA=qAAGAGAA
=A(AffA\AAzA
=AAGA\ApA
=AA  AffA=qAGApA\)AARA
=A{AffA(ApA{B 
=B=qB B\)BB ffAB{B RApA
=A=qAAAAQB  ARAAHAHAAAAAA33AA  A=qAA{A
A
=A=qA\AAAffAAAGA
AffAAzA33ApBA=qB \AAA  AB GB B pB 
B (A
AHAffAAAGAAAGAGA(AHA\)A33A
=A\)AAzAzAzAHAAHAAffAffB ffA  A(ApAQAHB QApB A
B   AARApAB zBHBB
BQB\BBRB  B\)B\)B RA{ApA(AAGAAA=qA\)B {A\A(AAAAA33AAffABBffBHB
=BQB\)BffBRBBBzBB
=BBBpB	=qB	B
B	BBB33BQBBBBBB
=BRAA33A{AA\A\A\)AARA\)A(AAA\)AA
=A\AzAAzAHApABHBzBzB  B(BQBB\)BGBzBABGBBBBHB{BQBAA{B {AAA\A(A{AA(A(ARB GA
=BffBffB B
=BzB33B(BBB
B
=BBRBzBpB
=B {AGBffBB
=BffBzB{B GBQB\)BBQB\AQAAzAAAzA  AARA{AHAAQAA\AA
A\AAA
B (A(AAAApA
AQAAARAffB 33B BzB\B
=BpAGAffAA{AAAHA33AAAHA{AB AQAARAAffBBBBB{BB\)BB 
=A
=AA\AA(AAA=qAA\)A
=AAHAzA{AzAA  A\AGA
AA33A{AQA\)AffAHApAffAA{A33AA\ARA\A  AAQA
=ARAA\)AAA\)AAzA홚AAޏ\AAGARA=qA
=AAAzA\)ARA
=AAARAzA
A
AzB QB ffB 
B(B \B \AB A(A{AAGAQA
A  AA(A33A=qA33AA33AB pB  B \)B AGAAzA33AAHA(A{B B{B A
=A
B BffBBzBAAApB ABzB  BBB=qA\AHAHB33AffAA(AB=qAffAGA(A33A=qA
=A\)AAQAAffA(A33ARAA\AAHAB HB =qAzB QB B AA{AzARBffB  BGB33B=qB33B
B=qAzB=qB  B\)BpBBpBBffB  BpB=qB{BB\)B
=ApAzB 
B 
B RAAAffAAAQAAzA\AApAA{A(AzAApA33AAAzA  AAAzAffApA  AAQA{AQARA  AffAAA
=AGAzBB AB B \)BB B 33ApA=qA
AApAQAAAHAGAffA  AAAA\)AAQAAGB{A  A\)AGAA33B  B ffA=qAHApABA
BzB(B BB\)B  BBffBB B pB(B(B=qBB  BBBB B\)BRB RB
B A\)BffA33B B 
AA  AA=qA=qAAAA
=A=qAAzAA  A\A
=AAHAHAzA{A\AQApAzAAzA\)A{AzA\)A=qAGA\)A  A
A\ApAAzAAQAHA(ARA=qA33AQA
=A
=AHA=qA
=AA{A  AHAAA\AAzA=qApAAHAGAA  AAARA=qA(AAA(A뙚AzAAAffAQAGAGAzA33ApApAQA{A
AA33AA33AAQA\AA
AAAA  A{A\)AA  AA=qA  AGA{A=qARAGAGAffAAA  A\)AAAGAA
=AQAGAAA(A  AAA(AHAffA홚AA33A33A  A
A{AAAzA{A33AݙAQA{AAA=qAHA33A(AQAffAڣApAA=qAHA=qA(AHAᙚAHA=qARA
=AGA
A(AAffAܣA
=AAAAzA
=AܣA=qAݮAݮAٙA{AٮA33AA\)A  AA߅AݮAzA(AA(A
AffAzAA33AffAAA33AAHAՙAHAA
=AڣAA֣AA(A؏\AٙAAAAffA֣AAA=qA  A  A33A{AߙA
=AA{AffAzAAHAHAAffA=qAGAzAHA{A
=A=qAAGA噚AQAA{AAffA33AAzAHA=qA֏\AAA
AQAҸRAzA  A  AGA\)AzAAA
=AzA
=AAApAAAۅAHA33AAAA(AffAffA\A{AA=qA  A
A\)A=qAAAAARA=qAәAAAA33AA=qAA=qAAܣAQAӅA(AҸRAHAѮAffAϙAHAA\)A  AAAυA=qAAۮAA
=AAA{AGAffAAffA=qApAHAHAAAA֏\A
=AQARAAAHA  AzAAڏ\AAAffA{AߙA݅A\A
AGAGAQA33AQAGAApA=qA
ApA=qAAA
A  AGA\)AHARARA\A
=AA(AHAٮAQA\)A܏\AQA=qA=qA(AGAܣA=qA33AffAAGAA\)AAAzARAzApA{AAAAARAAzAA  AGAHA  AAAGAzA
AAAA33AHAARAAApA  ApAAQAQAAAA33A
=AAGA{A\A\)AApAA
AA\AQA=qA(AzAAAAHAzAGA  A\)A  A(A  ARA=qAAHA{AAAHA陚A(AAAA\)AHAGAAAAAA
A(A{A\ARAAAQARAA=qAARAA  AA  A(ARAAzAAAAAA33AAGA
=AApA=qA\AAHA
=AffAQAGAA  A{AzAARAGAAAQAGAAARAAQAffA\A
=A\AAAAHA
=A(AHAGAARAAGAQA\AApA=qApA\ARA\AAAA(A(AffAAA{ARARAAffA\A  A\)AzARA
A
A
AAA뙚A\)A
ARAA\A
AzA(AAAARAApAAAAA
=AffA\AzAQAzA
=A
AffAA=qA=qAAAAQARAAAAARAA  AAAQAffAffA
ARA
=AffA=qA\)AA\AAApA33AAA
=A
AQAA=qB 
BffBB (AAzAB{B 
A
=AAzARARA\AffAzAffAAAAzApAAffAGARARA  A\AffA
=AGARA\)ApAGA{AQAzAAzB =qB RB BB33B{BB=qB (AB ffAA33BpB QB{BRB{B\BB 
BB=qBBGBB  B33BGBAHAB B =qB 33B AARA
=A33AA\A{AzA
=AA(AApAA33AɅAAAޣAޏ\AAGAڣA(AA=qA=qAڸRA33ApAۮA{A{A=qApA
=AGAܸRAۙAٙAzA=qA
A
AA\)ApA  A\)AARAffAffAApApAHA=qAA  A\)A{AAGA뙚AffAAA\A(A
=AA  A陚AA33AAzAAA\)A=qAGAQAA33A(A{AffA  A\B33B
=B
=A=qA{A{AAffA  A{AA
=A\AApARAAAHAzAQA  AAA33A(AAᙚA{A
=AGA\A33A\ApAGAAHAQAA\)AA
A\)A
=B A(A\)AQA=qAAQB zARA  AGA
=ApARAAHAA33A33AQARBpAB33AAGA
=B
=A  AB B33AAHA=qAGAApA\AGAAzAAA  A(A
ARA\)A
A\)AA\)AQAARA  AAzA
=AffAA  AA
AAHAA{A\)AHAA\AAffA(AAQAARAffApAAA(AzAQBGB\BB\)B AAA(A=qAA
A
=AݙAzAA\A(A\AAA  AA33A33AA\)AGAHA33AAHA8AQAvRAqA\AA|  AwA_AZ\AffAA*HAH  AAA[\)AXQAG33A?
=A4A
=AzA,zA,A8(ADA8AGA>RA5A=pARA1pA$QA'A33@A#
=AC
A1AA QA)GA	A
A#AAGAAA(QA8A+
=A$A#\)AH@Q@@@@=q@@
=A A{A
@zA\)A
AGAA{A%A=A(A6{A@ADAQpA:HAFffA@A>ffAk33ATzAo
=AgAQAf{AlzA`(A]Aj{Ak33AdzAZRA\AiAfHAdAmAfRAo33AAffAAzffA
=A  AAAARA\)AAffAQAGAuA{AsAw
=ApQAn{A|A|Ao
=AmGA[
=Aj\AxAl  AAAv{AxAAQA{
Ar{Ak33Aj\AtzAs
A}AAQAAAypAA
A{
=AHAGA=qA\AApA(AAHApAGA(A33AzAA
=A  AͅA  AθRA
A(AHAHA\)ApAՅAָRAQAzAHA
=AAAۮAңA{AzA֣AݮAݙAHAԏ\AA=qA(A33A(AHAGAGA\AAAAzAA\)A  AGAHA
AAA\)A癚AAA\A
AQAHARAQA  AARA\AAA
=AQAA
AAHAAAQAAQA=qAffA=qA33AA=qA=qA{AAA{ApA=qARAAffAA=qA\)AAffAAAffA(A\)AzAGAAAzA
A
=AHARAzAAAHAA33B 33B zB AQA=qA\AA\)AffA=qA\A  AGAAGApAAAAAAQA=qA
=AAAA\A
=AAAzAAAzAAAA=qA33A=qAAAAARAQA
AQA
AQAA  AGAA\AARARA(AA  A\AzAAAA\A
=AA=qA33AA  AAA=qA(AA
BQB  B\)A33A\)AzApAB\B  B\)BBffBBzBB(B  B 33BpAA=qBABQA=qABBA\)AHAzAQB {ApAHA33AA\A(ApAAA
AB\)BBBB33B
=AA33B AAAzB HBAA{AQAffB  BBApAAAGAA뙚AAARA(A  AAGAAARAٙAݙAٙA=qAAAHAAAHA\BffBBpB
BB
B
B
=A=qB
=AAB
BBQAHA
A33AA޸RAQA  A33A(AAGA{ApAHA\AAHA33A\)A  A=qAAGAA噚AA=qA  AGA33A  AzAffA\)AffAȣAA¸RA\)AÅAApAA  A
=AGAAAA\)AҸRAzApAGA¸RAřAAAAA(A=qAA(AAAA\)AʣAHA=qAGA\A(A\)A=qA홚AA(AAљAڸRAQAGAffAA\AA(ApA
AAAAB  AffAAGAAAAA㙚A\A=qAA=qA
A
AA\)AQApApAAGA(AAAA33AA{A  AAHA33A
AA癚AGB =qA(ARA=qA뙚A  A33A33AA=qAѮA\AAQA=qAAυAʣAAzAffAAQAAzAffAAAӮAffA
=A  AA
=A
AzAAApARAAHA(AAffA\)AzAA(A{ARAAzA=qAAA{ApA\)A\)BBHB BpA{AQAAzAAAzAAQA{A\)A噚A(A
AQA{AAޏ\AQAA߮A\)AARAA
=A
=AHAAzA
=AAA\A\)AzAHA33AzAQAHAAffAAAQAAAAHAAHAffAzA
AᙚAffAffA{A\AAAAQAA  ApAAHAHAzAzAAQAGAA
=AAA  ARA
=AAAzARAGAHAffAGAzA
=A\)AA\)A{AAA
=AHA
AAA(AAQA\)AAA  AA  A(AAHAAffA33AAzAAzA\A陚AHAAGApAAB\ABBffB{BRB ffBffAGA
AAA
AzAAffAA33AޣAAGAAAҏ\AAA
=Aԏ\AظRAݙAGAzAA
AffAAA\)A
=AAA
=A\A  A\AzA
AAB \)AB=qB{ApARA{AAffAAzApAApB{B pB \B(B  A\)AAHA(A33AA33AzA\A  ARA\)A  AHA  A\)AAzAzAffAA  A33AA=qA
A\)A\AApAAAGA\)A\A
=AAHAGA33AHAGA  A{A=qAAzARA㙚ARAQA\AApAHA
=A
=A=qAAA
=AApAGAAA33AB GAB QA
=B ffB ABA\A(A33AA
=AAABpA
A\BzAHAAzBGB{BpA
AAAARAzA{A=qAAHAAQA\)A
=AHBB33BpA  B{AzB ffB=qB\)BHB \A\)B\B  B 33B \AA\)AAA33A(AffA{AHA{A33ARA\)AHA\AzA홚AzAA
=A33A33A
=AAARAA߮A{A33AAffA
=ApAA(A(AABA33B33ApB GB \)AAA  B
BGAAffB QA\)A
A
BpBRBBHB{B\BBBzBBB33B\BB\B RB   B   AARABRBBQBQBAB
=BB B HBffB BHApAA33A(A  A\)A\)A=qAޏ\AQAHA{AAzAAA  A홚A{A\)A33AA?   ?333?fff>?333?333??   ??   >>>>>L==>L>L>L>L>>?>>?   ??L??  ??ٙ?fff??>>>>?   >>?   ????>L>L>L        ======>L>L>L>L=====>L>L>>?>?   ?   ?   ?   ?   >>>L>L>>>>>=>L=>L>L>>?   ??333?   >?   ???   >>>>L>L>>>>>>>>>>>L=>L==>>>?   ?   ?   ???fff?L?L?L?333??L??   >>>>>L>>L>>>>>>>>>>L>L>>?   ?   ?L??333?333?   ?>>>?   >L>L=======    >L>L>L>L>L>L>>>>>>L>L>L>L=>L>L>L=>>>>?333??L?>>?L??   ?   >?   >>>L>>>>>>>>>?   ??   ??333???   ???fff??  ?333??333?333???   >>>=>>>?   ?   ??L?333?L?   ?   ?   ???333?   ?L>?fff?333?333?333?   ??fff??>???  ?  @`  ?33?333?   ?  ?   ?   ?   ?  ?L?L>>?333?   >?  >?  ?L>>L?   >??   >>>>>>?   ?333?333?333?333?   ??   ?333??L?fff?fff?  ?L?333?fff?33?L??33?   ??L?333?fff?fff?fff?fff?fff?fff?fff@33??L?fff?L?fff?L?L@333???  ?>>?  ?  ?333?fff??333?L?333?333?333?>>?fff?  ?fff?????????ff?ff?ff????fff??fff?  ?  ?  ?  ?L?L?L?333?fff?L?L?L?fff?L?fff?L?  ?L?L?fff?333?333?333?333?333?333???????????????ff????  ?fff?fff?L?fff?L?fff?fff?fff?fff?L?fff?fff??L?L?L?fff?fff?L?L?333?   ?ff?   ??L?L?333??333?333??333??333?L?L?  ?  ?  ?fff?fff?fff?L?fff?L?333?L?fff?  ?  ?fff?fff?fff?L?333????L?333?333?L?L?333?333?333????333?333?L?L?L?333?333?333?333?333?333?333????333????333??   ???333??333???333?L?  ?L?fff?fff?fff??33??  ??fff?  ??fff?fff?fff?fff?333?L?333?333?333?333?333?L?333??333??fff?fff?fff?  ?L?fff?fff?fff??  ?ff???????  ?fff?  ?L?fff??  ?  ?33??  ?ff?33?  ?  ??ٙ??  ?ff?33?ff?33?ٙ?ٙ?ٙ?  ??ff?ٙ?33?ff?33?  ?  ?33?ff?  ?@?33@  ?ff?ff@@@@&ff?ff?ff?ٙ?ff?33?33@,@9@&ff@?ٙ?ٙ?  ?@9@9?ٙ?33?33?33?  ?  ?  ?ٙ?                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                =                =>L=>L>=        >L=>L=>>                        >>L>>>>L                                                                                                                                                                                            >==                                                                                    =    =                                                        >L==                                                                =>L>>        >L=        =                                                            =>=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ===>>L>L>>>>?fff?33?33?@@33@&ff@@  @333@33@`  @y@??  ?fff??ff@?33y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                         =        =                        ?>L                                                    ?L>L====    >L=>L>>L>L>=>?L???@Fff@  @AdA  AAA|As33AYA1AAffA@@33@33@ff@33@33@@AA33@@ff@@ff@ffAAaAAAffA33AAA33A33A  AAffAAtAfffATAH  A6ffA,AffAff@33@陚@@@  @33@  @  @ff@  @@@33@@  @y@y@33@y@l@33@s33@l@fff@s33@  @Y@y@fff@fff@Y@@  @Fff@Fff@L@&ff@@  @L@Fff@9@9@@  @y@,@333@S33@9@@@@33@   @   @&ff@,@@@@ff@@ff?33?ٙ?ff?ff?ff?33?ff?33?ٙ@@&ff@&ff@   @Fff@fff@L@9@&ff@&ff@`  @L@Y@&ff@   @   @33@ff@   ?ff?ff??33?   ???ff?  @   @   ?ff?33>>>L=>L=>L>L>>L>>>L>L>L?333?fff??33??ٙ?ff?ff?ٙ@   ?ff?ff?ff?L?L?333?L?L???  ?333?   ?fff?L?>>>L>>L>?   ?333??333?333?L?333?333?L?L?333?L?   ?L?L?fff?L?L?fff?L?fff?fff?  ?  ?ff??ٙ?ff?33?  >L=?333??fff?ff?  ?ff?>L>?  ?333?L??333@   ?33?  ?????  ?  ?ff?33@333?ff>    >L>L?L?  ?fff?   >>?   >L?   ?L?ٙ?33?  ?ff?ٙ????   >>>?L??   ?333??   >>L>>>??fff?333>?333?   ??  ?L?   >>>>=>L    ==>L    ?333>==>L>>=??L?>>>L=>?   >>>L>L>L>L?   >L=?   >?   ?fff??  ???ff?ff?  @ff??  ????????33??ff?33????ff??ff??  ?L?fff?fff?fff?fff?L?fff?L?L??333?333?>??   ?   >???   ?   ?   ?   ???   ?>?   ?   ?   ?   ?   ?   ?333?333?  ?  ?L?L?L?333???   >>>>?333>??   ??   ?333??   ??   >>>?   ??33?  ?fff???   ?   ???333?L?  ????fff?  ?fff?  ??  ?  ?  ?L?333?  ?fff?L?333>?   ?>?   ?   >>>>>=>L>>>>?   ?   ??333??333?L?333?333?L?333?333?333>???333?   ?333???333?   ?333?333?333?333???   ?   >>>>>>>L>?   ?   ?>>>==?   >>?   ?333?fff?L?                >L>L>L>L=>>>?   ?   ?   ????   ?>>>L>>>L>L>>>>>>>L>L=            =        >        =        =====>>L=>>L>L>L>>>>>?333??>?   ?L?333????   ??   ??   ?  ??  ?  ?33?L?ٙ@   ??ff??  ?L?fff????ٙ?  ?ff???   ?   ?>>L>>>>>>>?   >>?   ?   >?   >>L>>?   ?   >>>???   ?   ?fff?333??L?   ??333?333????333?L?fff?ff?  ?333??   ?333?L?333?L?fff?333?fff?fff?333?L?333?L?L????fff??  ?fff?fff?333?L?fff?fff?333?  ??L?  ?fff???  ?????33?ff???  ??  ?L??ٙ?ff?@   ?33?ٙ?  ?  ?  ?ff?33?33?33?  ?  ?33?  ?  ?ٙ?33?  ?  ?  ?  ?33?ff???  ?33????fff?  ?  ?  ??????L???  ??fff?L????333?333?L?fff?fff?  ?33?33??fff?  ?  ?L?ff??  ?33??33?33?33?33?ff?????ff?33?  ???@33@   @   @ff@33@   @ff@@@ff@ff@33@   @   ?ٙ?ff?ff?33?33???33?ٙ?ٙ?33?  ??  ?ff??ff?????ff??  ???ff?  ????ff?ff????ff??ff?ff?ff??33?ff?  ?ff?ff????ff?33?ff???33?33?ff?33?ٙ????ff??ff?33?ff?33@   ?@&ff?@ff@   ?33@   ??ٙ??ff?@   ?33@?ff?33??33?ff?  ??33?33?ٙ?  ?  ?  ?  ?  ?  ???ff?ff??????????????ff?  ?fff?fff?fff??fff?  ?  ?fff?  ????  ?  ?  ?fff?L?fff?  ?  ?  ?L?fff?fff?L?L?L?L?fff?L?L?L?L?fff?ff??ff??ff????  ??  ??  ?33?33?33??  ?  ?  ?  ????????????ٙ?  ?  ?ٙ????ٙ?33?ff???ff?33?  ??  ??33???ٙ?ٙ?ٙ??33?ٙ??33???ff??  ?L?  ?L?L?fff?fff??ff?  ?  ?  ?ff?????  ?  ?  ??fff??fff?fff??33????fff?fff?fff??  ?33?33?  ???  ??  ?  ?  ?  ?fff?fff?L?  ?  ?fff?  ?  ?fff?fff?fff??  ?  ?fff?  ?  ?fff?fff?fff?fff?fff?fff?fff?fff?  ?  ??ff?33?ff??  ??ٙ?33?33??  ?ff?ff??fff??ff?L?L?L?333?333?333?L?333?333?L?L?L?L?  ?fff?L?L?L?L?fff?L?L?L?L?L?  ?L?fff?fff?fff?  ?fff??fff??fff?  ???fff?  ??  ?  ?  ??fff??  ???  ???  ???????ff?ff?  ?  ?  ?33?  ?33??ff?????  ?  ?ff?33?  ???  ?fff?  ?  ?  ?  ?  ?fff?33?  ?33?33?33?ff?33??ff??ff?ff?????fff?fff?fff????  ?  ?  ?  ??  ?  ??ff??ff????  ????????  ?33?  @@ff?ff?@   ?ff?  ?ff?  ?ff?ff?ff?ff?  ?  ?ff@   @ff?ٙ@&ff?  ?????  ???????33?33?33?ff????33?ff?ff?ff???  ?33?33?33?33?33?ff?33?ff?33??????33??ff??ff??ff?ff?ff?ff?ff??ff?ff?ff??????????  ??L?fff?L?L?333?  ????  @9?  ?fff??L??  ?L?L?L?L?333?L?fff?L@333@&ff?  ?ff??fff?L?L?fff?ff@??L?fff?L?L?333?  ?  ??  ?  ?  ?  ?fff?L?L?333?L?333?333????333?   ?   ?   ?   ??   ??   ?   ?   ?   >>>>>>>>??333?   ??L?L?  ?fff?333?L?L?fff?L?333?333?333?>?   ?   ?   ?   >>>>?   ???333?333?333?L?333?L???   ?   >>?   ?   ?   >>>>>>??   ?fff??  ?L?333?   ?333?33????33@,@@  ?@&ff?L???  ?ff?>?@   @,@33?33?@L@   @fff?ٙ@fff@  @@  @9@9@9@?33?L@  ?ff@ff@33@333@?  ?fff??33?333?fff?  @ff@   @?   @  AA33?L?ff@y?fff>@S33@@  @9?ff@,@fff@ff?  ?33?33@ff?33@  @Fff?@33@333@33@S33@ff@@33?333>=>L>>>>?   ?   ?   >>?   ?   ?333?333?333?   ?333?   ?33?333?333??333?   @fff??L?333>>>>>>?   ?   >>?   ?   ?   ?  ?333?   ?   >?   ?   ?   ?   ?   ??   ??   ??L??333?L?L?L?333?333?333?   ?   ?   ?   ?   ?   ?   ?   ??333?   ?>>>??   ?333?L?fff?fff?L>>=>==>L>L>L>L>>>?   ??333?333?L?fff?fff        >>                                >>    >>                        >>>    >>    >    =    ==>>>>>L>L>>L        ==>L=>L=>L===    >L=>L    =>L        =>>>>>L>>=>    >>    >    >=        >>>L        >    =            ==>            >=>L>L>L>L==>L>>L>>>>>>>L>L>L===>L>L>>L>L>L>L=>>L>L>L>>>>>    >        >                =>?   ?  ?ff?ff?33@&ff@l@,@`  @l@  @ff@  ?L??   @@s33A@@9@@  @L@y@ə@@ff@@  @33AA  @  @ff@33@@`  @@s33@Y@ff@l@  @@ff@@ff@  @@@ff@y@  @33@@  @  @33@y@@  @9@@  @9@&ff@,?ٙ?  ?ff?  ?ff??  ???  ?33?ٙ?ٙ?ff?ٙ?  ?  ?33?ff??  ???  ?  ?  ??  ?33?ff?ff?33@ff?ff?33?33??ff?L??L???ff?fff?L?33?33??ff?ff@33?ff??ff??fff???L?333?fff?>?  ?33?33??  ?33?33?ff?  ?  ?33?L?  ?ff?  ?ff??ff?33??33?33??ff?????ff?33???ff??33?????ff?33??fff??ff?ff?ٙ?ff?  ??fff?  ?ٙ?????  ?ٙ?L@   ?ff?L@ff?33@&ff@,@@   ?33@Fff@333?ٙ?fff?fff?ff@@,?33@   ?  @ff@@@  ?ff@33@33@ff??33@ff@   @@ff?ٙ?  @@333@&ff@33@@,@Fff@,@333@333@33@@  @&ff@@  @  @@  @@@  @ٙAAA(  AA9A)Ax  Ap  A  AA33AAAA  A  AffA  AffAffAx  AlAX  ADA8  A&ffAAffAAffAffA1AFffANffAYAYA^ffAVffAQAQAH  A@  AK33A@  A;33A1A,A!A  AffAffAAffAA!A  AffAAffAA33Ac33A^ffAIAlA!AA33AAff@ff@  A   @33@ff@ff@  @@  @ff@ff@@@33@  @  @@33@33@ff@@33@  @  @y@  @33@l@s33@`  @L@Fff@L@@  @Fff@@  @333@,@333@9@,@Fff@S33@L@S33@9@@  @L@S33@L@@  @9@333@S33@Fff@L@9@L?ff@Fff@L@   @9@,@   @   @@@33@ff@ff@   ?33@   @,?ff@33@ff?33@ff?33@@   @,@9@L@9@9@33@ff@ff@?33@   @   @ff@@   ?ff@   @@   @@   @@   @   @@   @ff@ff@@33@@@ff?ff?ff?33?ff?33?ٙ?ff?ff?33?33?ٙ?ٙ?33@ff@@333@   ?  ?33?  ?ff?  ?ٙ?ٙ@&ff@ff@33?ٙ?33@   ?33@   ?ff?ٙ?ff?ff?ٙ?ٙ?33?  ??ٙ?33???fff?fff???33?ff?ff?fff?L???33?33?  ?  ?ٙ?ٙ?33@@   ?ff@   ?33????ff?  ?33?ff?  ?ٙ?33??33?  ?ff?33?33?ff?ff@ff@ff?33?33?33?  ?  ??  ?  ??L?????fff?L?fff?fff?L?fff?L?  ?fff?  ?L?333?333?333?  ??  ?33????33??fff?L?333?333?L?333?333?L?L?L?333?L?L?L?L?fff?fff????L?fff?333??   ?>>>>>>?   ?333?  ?L?fff?fff??33?333???L?333?333?   ?   ???L???   ?>>>?   ?   ????333?333?????   ??   ?fff??   >>>>>>>L>>>>>>=>>L>>>>>>>>>>?   >?333?>>>>>>>>>>>>>>>>L=>L>?  ???fff?L?fff?L?fff?  ?fff??ff>>?   ??L??>>>>?   ?   >?   >>>>>>>>>>>>>>L>L>L>>>>>>L>>L>>>L>L>L>L>>>>>>>>>>>>L>>L=    =>L>>L>L>>>?   ?   ??333?fff?fff?L?333?L?  ?333>>L=>L>L    >>L>>L>>L>L=>L>L>L>L>L>L>L>L===>L>L>L>L>>L>>>L>L>>>L>>?   ?   >>>>?   >L>>>?333?   ?L?L>L>>>=>L>L>L>L>>L>L>L>L>L=    >L>>L>L>>L>L>L>L>L>L>L>L=>L>L>L>L=>L>L>L>>>L>>L>L>L>L>L>>L????   ?   >>>>>>L=>>L?   ?   >?   =>>L>?   >>?   ?   >>>>==>L>L>>>>>>>?   ???   ??   >>L>L>L=>L=    ==>L>L>>>?333?333?L?  ?333?   >>>>?   ?L?fff???   ???   ??   >?       >=?333?  ?fff?L?fff?33??333>L=>=>?  ?ٙ?ٙ?  ?L?  ??>?333?  ??33?L?  ?ff?33?33?ff??ff???ff?ff???ff?33?  ?ff?ff??fff??  ?fff??  ?333??>?   >???fff?L?  ?  ?  ?fff?fff?  ??  ?  ???  ?????L??  ?L?L?L?333?   ?333?333>>>>>>>>>?   ??   >?   ?   ???333?L?L??   >>?   >?   >>?   ?   ???333?333?333?333?L???fff????33???fff?L??  ??fff?fff?L?333?L?333?????333???   ??   >?333??L?L???33?  ?fff?  ??  ??  ?L?fff?fff?L??   >>>>>?   >>>>??   ??>?   ?   ?   ??   ??   ?   ?   ?   ?   ?333?   ????L?333?   ?   >>>>>>>>>>>>>>>>>>>>>>>>L>L>>>L>>?   >>>>>>>>>>>>>>>>>>>>>>?   >>>>>>>>>>>>>>>>L    >L=>=>L>?fff?fff?L??333?333?   >L=>L>L>>>L>L=====>L>L>L>L>L>L>>>>>>>?>>>>>???   ?   ??fff??   >>?   ?   ?????333?333?333?333?L??L?L?   ??fff?L?L?333?   ?fff?fff??  ????   >>>??L?333?>>L>L>>L>>>L>>>>>>L>>>>>L>>?  ?   ?   ?L?L?  ?333?333?333?333?333?333>>L>L>L>L        ==>==        =        >>>=>L=    >L            >>    =    >>L=    =>=>L>>L>L>>L>>L>L>L>L>L>L>=>L>>L>L>>>>>?L>>>L=    =>L>    =    =>>L>L>>>L>>        >>L>>L>L>L>L>L>>L>>>=    =>L    >    >    >>>L>    >>>>L    >>>>>        ==>L==>L>==>L=        >L=        >L>>L>L>=    >>>>>L>L>L=>===>L    >>    >L>L>L>==>L>L>L==    =        ====>>L>>>L>L>L>L>L=>L>L>L>>>    >>L>L>>L>>L>>>>>>>    =>L====    ==        ==>>L>>>>=>        >    =>>>>>        >        =                >    >>>>    >L>L>>L>L>>L>L=>L==>L?fff?L>>>>>>>>>>>>>??ff?ff?ff?ff?33??333?333?   ?L??333?   >>L?333>?   ?   >>    >=    >L>>=>L>>L>>L==>L>L>L=>L=>??333?ٙ@33@,@@333@333@,@@   ?33?33??fff?ff?fff?fff?L@   @Y@@ff@  @33@33@33Aff@33AffA  A33A33@陚@  @  @陚@ff@  A@ff@ə@33@@  @  @33@ə@@33@@@ff@@ff@  @33@@  @33@  @@  @  @@ff@l@&ff@,@S33@9@333@&ff@@@  @&ff@333@@@  @&ff@   @33@33@ff@   @33@ff@ff??  ?ٙ@ff@9@&ff@333@&ff@@   @ff@ff@@   @@   @@@&ff@@&ff@&ff@   @&ff@&ff@33@9@?33?  ?ff?@ff@@&ff@   @33@@,@@ff?ff?33?33?ٙ?ff?  ?  ?L??L?fff?fff?L???  ??  ??ٙ?  ???ff?33?ٙ?33?33?33?ff?ٙ??33?  ??33?ff?33?33?  ?  ?  ?  ?  ?  ?ff?ff?ff???33??ff???  ?  ?  ?fff?L?L?fff?L?333?L?L??333?333?333??333???  ?  ???  ?  ?333?   ?   ?   ?>>?   ?L?????333??ff?fff??  ?ff?33????>??333???ff?  ?  ?33???ٙ?33????fff?  ?ff????????  ?  ?  ?fff?fff?333?  ?L?fff?333?fff?333?   ???  ?ff?fff?  ?fff?fff?  ?  ?L?fff?fff?L?L?   ?   ?333?333?L?L?L?fff?333?333?L?333?333?   ?   >?   ?>>>?   ?  ????   ?   ??L?333?   >>>>?fff??  ?  ?fff?  ?  ?ff??  ?fff?  ??fff?fff?L?ff?33?33??  ?  ?????  ??L?L?L?????   ?   ?   ??   ??333????   ?   ???333?@   ?ٙ?L?fff?  ?333?333?  ?333?L??333>?>L>>>>L>>?   >L>L=    ===>L>>?   >>>L>L>L>>L>?   ?L?fff???  ?33?33?   ?   >>L>L>L=>L>>>>>        ?L??   >>>L>L=    >=    >>>>>        >>>>>    >>    >>>>>L>>L                >    >        >L>>L=>L?  ?fff?333>=        >L>>>>L>L>        =>L        >L>=>==    >L?L>?333=>L    ====>L=>L>L>L>L>>>L>    >        >=>L>=        >L>L===>L>>L    >L>L>>>>L?   >>L>>>>>L>L=>>L>>>>>>?   >    =                >                    =>L    >=>>>>>L>>>    =>>L    =>?   >??   ?   ?   ???333??>>L    =>    >L>>>>>>>>>>>>L>>        =>>=>        >        >>>        >>L>>>>>>>>>L>>>L>L>L>L>>    >L>==>L>L        ==>L=>L>>L===    >            =    >>>>>>L>L=>L>L===>L>L>L>L>L>L>L>L>L>L>L>L>>>>L>>L>L>L>L>L>L>L=>L>L>L>L=>L====>L======>L=============>L>L>L>L>L>>>>L>>>>L=>L>L>L=>L>L>L>>>L        >=>L>L=======>L>L>    >L>>L>>L>L>L>L>>    >>            >>>L>    >L>L>>>>>L>>L>>    >>>L>L>>L>L>L>>>>L>L>L>L>L>L>>L>L>L>L    =>L>>>>?   >=    >>>>>L>>L>L>L>L>L==>L>>>>L>    >            ====        >L>L=>L>L>L>>>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L==>L    >L        >>L===>L=>L=>L>L>L>L>L====>L======>L>L>L=>L>=>=    >?    =    >=>    >L    >L>        >L>L>L==    ======>L=>L>L>L>L>L>L>L>>L>L>L>L>L>L>L>>L>L>>L>L>L>L>L>L=====>    ==    =>=>L==>L==>>>L>L>L>L>L=    =>>>>?333?   >>=        ===    >>>    =>    >L?fff??ff?  ?L??333==    =?   ?333?L?   ??L??fff??  ?fff?   ?   >>>>L>>>>>L        >                =>L=        >    =>L==>L=    =        >L>=>L==>    >?   ?   ?fff?ff?  ?fff?L?333?   ?333?   >?   ?333?fff???   ?=    >>L    =>    >>L>>?   >>>>>>L>>L===========>L=>L>L====>L====>L>L>>>>L>    >L>?   ?333?fff?L?333>>L>L>>L=>L>L===>L===>L==        >L=?   ???   ??   >>>L>>L>L>L>L>L>>>>>L    >?   >>?333?L?L?L??fff??   ?   ?   ?   ?   >>>>>>>>>>>>>?fff?L???>>?333???   ?   >?   >??   ?333????333??   ?   ??fff>L>L>L    =    =    =>L>>L>L>>>>>>>>>>>L>?   ?333??fff?fff?  ?L?333?   ??   ?   >??>?   ?333>?333??  ?ff?  ?ff?ff?fff?L?333?fff>>>????fff>>?   ?fff?fff?  ?????  ?fff?fff?  ??  ?ff?ff?33??33?33?ٙ?  ?ff@   @@ff?33??ٙ?33??33?ff???ff??????  ?L?L?L?fff?L????  ????ff?  ???ff?  ?  ?  ???????L?  ??ff?  ??  ??33???????  ?????333?L?   ?   ?L?????ff??33?ff?ff?ff?ff?ff???fff?ff??333?333?fff?333?  ?fff?L?L?333?333???fff???   ?   ??fff?  ?  ??333?L?L??   ??333?333????333??L?fff?fff?fff?333?333>>>?333??333?333???L?333??L?fff?333?L??333?333??L???   ??L?333?333?L?L?333?333?   ???L?   >??   ??   ?   ??333?333?fff?L?fff?L?333?L???333>?   ??>L?>?   ?   ?   >>>>>?   >?   ?333>???333?fff?  ?fff?333?333?333?L?333?L?L?333?fff?L?fff?L?L?L?333?fff?L?fff?333???333?   ?fff?   ??   ?   ?   ?   ?333??L?333?L?L?fff?fff?ff?ٙ?33??333?333>>>>L>>>>>>?   ?   >?   ??  ?L?L?L?L?333?333?333?333?L?L??  ??????  ?L?fff??  ?fff?fff??  ??????33???ff?ff?33?  ?33?  ?33??ٙ?@   ?ٙ?ff@   @ff@ff@   @33@33@33@@,@33@,@@33@@9@@  @l@y@  @@ff@AffA9@@ə@ff@@@@  @  @`  @Fff@@  @   @9@33@@  @9@@@  @,@@  @9@   @&ff@333@333@S33?33>>L??   ?   ==>L    >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>    =>>L>>>L>>>L>>L>L>L>L?333?L>L===>L>>L?>??333>>?   ?   ?   >>>>L            =>=>?   ==>L==            ===>L>=>L?   >?   ?L>>L=>L>>>>>>?   ??  ?fff?      ?  =?L??333?333??   ????   ?333?333?  ?   ?   =    ?fff?L?L?L?fff?  ?L?  ?   =>?   ?333??33@333?ff@9@l@@ff@?33@  @@   @@@@33@33@@ff@33@  @陚@@  AffAA@陚@ff@  @33@陚@@ff@  @9@Fff@@fff@fff@333?33?@Y@fff@fff@l@fff@S33@9@?33@33?ff?33?ff?33?33??ff?ff?33?33?fff?333?  ??  ?333?   ?L?333?fff?fff?L?fff?fff?L??333?fff??ff??ff?fff?   ?   ==>==    >>>L    ==>?   >L>L>L?   ??L?ff?  ??fff>==>>L>L        >L==>>L=>L=    =>L>L            >>>?ff?  @?ff@,>>    >L=>=    >>?   ?>?   >L?>>?333>L>L    =    >>L>>L>>>=    >L>L>    >>L>L=    =>L>??333?   =>>L>L==>>L=>L=>L>>L>>L?   >>>?   >?  ?  ???????  ??ff?ff?ff??  ??33?ff?????ff?  ???33?33?33@   @@   @@33@ff@@33@ff@ff@@ff?33@ff?33?ٙ?33??ff?ff?ٙ?@ff?ff?33?  ?33?ff@@@ff@@ff@33@33@ff@@   ?ٙ?ٙ?33?  ?33??fff??333?L?fff?fff??ff??ff?ٙ?  ?ٙ?33??  ?  ?33?ff@ff?333??L??fff?333?333?L?333?ff??L?333?fff?fff?ff?  ?  @   ?33?33?ff?ff?33?  ??ٙ?33?ff?33?  ?ٙ@@ff@33@33@@@33@33@   @@@   @   ?33?ٙ?ff?33@   @ff@   @33@&ff@,@9@333@,@   @@@,@@33@   @   @33@33@@&ff@333@@  @333@@  @Fff@S33@S33@S33@Fff@`  @l@fff@y@fff@  @fff@  @@33@@@ff@ff@  @33@@@  @@ff@@ff@@33@  @`  @`  @ff@33y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 ==>>L>=    >L>>>L>>L>L>L>>>?   >>>>L>>=>L>>L>>    >>L=        ==>>                    =====>>>L>=>L=>L    >L    >L>>>L>L=>L=>L>>    =    ===>>>>>>L>L>L=============>L>    >L=>L==>=>>L>>>    >L>>>L>L>L>>L>L=>L>L>L>L>L>>    =    =            ===    ==        =====>L=>L====>L>>>L>L======>>>>    >>>L==    >===                            =                        >L=>==            ==>L>L>L>L>L>L>L>L>L=>L===                    ====>L>L>L>L>L>L=                =====        =    ?  ?33?33?  ?  ?33?      >>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>                                                    =    =    =>L>    >>L=>L==    >L=====>L=>L>L>L>L=======>L>L>L>L==    >>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>        =>L=>L==    ==>L>L==>L>L>L>L=>L>L>>    >    >>>>>L>=>>L>>L>>L>L>L>L>L>L>L>L>>>L>L>L>L>>L>>>>>>>>>>>>>>>>>L>L>L>L>L=>L>L    >>L>L====>L==>L==>L===>        >        >>>>L>L>>>        >>>>>>L    >>    >=    >>L>L>L>L>L    ====>L>>    >>L>>L>>>>>    >    >>                                >>>>>L>L>    >>>>L>L=                                                            =>>>    >>L>L>>>>L>L>L>L>L>L>L>L>L>>>>L>L==        =>    >L    =>>L>>>>>L=======>L>L=>L==>L====>L=>L====>L===                                        ==>L=    =>L==>L    ===============                                ====>L    >L>L>L>L>L==    >>    >>L>L=======>L=========    ============        =                                            =    ==    ==    ===>L>L>L>L=========>L>L>L>L>>L>L>L>L>>L>L==>>L    ===>>L>>    >>L=>L======    ==    ======>L=>L===================>L>L===>L=>L>L===                            ===    =>L>L=>L>L>>>L>L=>L===>>>>>L>>>L>>=>L=>L=====>L>L>L>L>L>>>L>L>>>>>L>L>L>>>>L>>>>        >>L>>>L==>>                        >=    >            =        >L>>L>L===    >=>L        >=>>L=>>>L>=    >L>        >L>?   >>>L=>>=>L>L>L>L    >>L>L===>L>L>L=>L=>L>L>L>L>    >>>L>L>>>                            =>>L>>>>>L=>L>L>L        >>    >>>>L>                                >>            >            >>L                                    >>>>>    >>>>>    >    ==>L>>>>>>>>>>L>>L?fff?   ??333?L?L?L?L?L?333??   ??   >?   ?>>>?   >?   ?   ?   >>>L>>>>====        =========    >    ==    =    =    =>L>>L>L>>>>L>L>L=        >=    >>        >    ===>L?   >L>L    >    ==>>?   ?   ?   >>L=>L===                                                =    >L>?   >L==>L>L=>L>>L?333?   >>>L=>>?   >??333?333??   >>?   >===    =                            ===>L>L>L        =>>?   >>>>?   >>>>>?   ?333?fff??333?fff??fff?  ??  ?33?33?33?ff?ٙ??ٙ?ٙ?  ?ٙ??ff?ff?33?ff?ff?L?fff?fff?333?fff?L?L?333?L?fff??L??fff?L?333??  ?  ?ff@ff?  ?33?33?33??ff@   @   ?33?ٙ??ٙ@?33??ff?33?33????33?ff??33?ٙ?ff?33???  ??ff?ff???  ?ff?  ?ff?  ?33?ff?ff?ٙ?ff?33?ff??ff?33?  ?33?  ?ٙ?ٙ?ff@   @   ?ff?ff?  ??  ???33?33?ff?33@   @   @@@   ?33?  ??ٙ@   @   @   @   ?ff?ٙ?ٙ?ٙ?ٙ??  ?ff?ff?ff?33?ff?33?ٙ@ff@ff?@ff??ٙ??ٙ???ff????ff??ff?????ff??ff???  ??ff???  ?ff?  ?  ?33?33?ٙ?  ??33??  ?ff??ff?  ?ff?ff?ff?ff?33@   @   @&ff?  ??ff?ff?ff?ff?ff?????ff?33?33?33?33?33?33?33?  ?  ????  ?  ?33?  ?ff?33??  ?  ??33????33?ff??ff??ff?33?ff?33?33?ff?ff?ff?ff???  ?33?  ?  ?  ?33??ff?33?  ?  ?  ?  ?  ?  ?  ??  ?  ?ff??33?ٙ????  ?ff?ff?????33??ff???????????33?ff?ff??ff?33?ff?ff?  ?33?  ?33?33?  ?33?ff?33?33?  ?33?  ?  ?ٙ?ff?33@ff@   @   @   ?33???  ?  ?  ?ٙ?33?ff?33??ff?ff?33@   @@ff@   ?33?33?33@   ?33?33@   @ff?33?33@33@@   @@@@   @   @   @@   @   @ff@33@ff@@@&ff@   @@33@`  @Y@333@L@333@9@   @&ff@   @   @,@,@,@333@Y@S33@Y@@  @L@Y@L@`  @fff@Fff@@  @l@`  @@33@@@y@s33@s33@ff@s33@33@y@ff@  @@`  @  @@@@  @ff@@33@@33@@33@33@33@@  @ffA  @  @@ff@  @@@@  @@  @  @  @33@33@@  @ff@33@33@ff@ff@@  @@33@@@  @@@  @ff@33@ff@  @ff@ٙ@@@33@33A  @陚@陚A   A@ff@陚AA	A33@AAAVff>==            ==            >L>L===    ==>L>L>L>L==>>    >>        ==        =        >>L    >>>>>L>L>L=>    =>>    ==    >>>>L>L>L>L>L>L>L        >>    >>L>L>>>>=>>L>>>L>L>L=    =>>=?   >?   >>>>L>L>L>>L>L=    =====>>?>>L>L>L>L?   ==>>>L>>    >??   >?   >    >>>    ?   ?   ?   ?   >=?333>??  ?333?333??fff?>?   >>L                        >L>>>L>>L>>>>>>=>L>L>L>L>?   ?   ?>??333?L?fff?  ??ff?  ??  ?L?333?L?L>>>?   >>>>?333?fff?333?   >>L    >    >L=?   >>>L>L>L>=>L==            =>L=        =>>>>>?   ?   >>>>>L    >>>L>L>    =>>L>>=>L    >>>    =>L=    >>>L>L=>L>=>===>>L>L>>L>L>L>L>L==    >    >>>>L>L>L>>L>L>L>L=>L==>L=>>L=>L>L>L>>L>L>    >L=>>        =            >>    ==?   >>>>L>>>>>?   >?333>>L=                                =        >>L>>        ==>L>L>L>L>L>>>?   ?>L>>>>>>?   >>>>?   >>>>>>>>>>>>>?>>>>>>>>>>>?   >?  ??fff??333???333??33?LAL??L??L?L?fff??  ???  ?33?33?33@Fff@&ff??  @ff?33?  ??ٙ?ٙ?ٙ??ٙ?ٙ@?ff@   @ff@ff?ff?L?fff?L?L?fff??fff??ff@?  @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   ?fff??ٙ@@33?333@&ff@   ?33?33?  ?33?ٙ@ff@@ff@33@&ff        @   @   ?ٙ?ff@ff?33?ff?  ?33?33?  ?ff?ٙ?ٙ?ٙ?33@ff@   @ff@   @   ?ff@33?33?ff??  ?????  ?ٙ?  ?  ??33?  ?  ?33?33?ff?ff?ٙ?33?ff?ff?33?33@ff?33?ff?33???ٙ?@?ff@   @@ff@   @@ff?ٙ?  ?  ?  ??  ??ff?ff?ff?ff?ff?  @ff?33?33?ff@33@?33@33@33@==>@@    @&ff>??33?ff?ff?ff?ff????33??33?  @   ?ff????33??ff????  ?33?33?ff??  ?ff?  ?ff?ff?ff???33?ٙ?33?  ?ff????ff@   ?  ?33??33?ff?ff?ff?  ?33?ٙ??ff?33@@   @   @   @33@   @?33?ff?ٙ?ٙ?  ?ff?  ?ff?ff?????ff?ff?33?ff?ff?ff?ff?  ?  ?ٙ?33?33@   @   @@@@@33@@   ?33??  ??33????33?ff??ff??ff?33??fff?  ????  ?  ?  ?fff?L?ff?ff>?L?  ?  ?333>L?>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>                                                                                                                                                                                                                    >L>L>L>L>L>L>L>>L>L>>>>>>>>>>L>L>L>=>L>L>>>>>?   ?   ?   >>>=>>L>>>>?   ???   ?fff?   ?   ?   ?   ?   >>>>>?   ?   ?333?   ?   ?333?L?333?L?333?  ???   ???333?  ?L???   ??333?333??333?333??333?333?333?333?L?fff?  ?fff?fff?fff?fff?fff?fff?fff?fff?fff?fff?fff?L?fff?fff?  ?fff?L?fff??  ?fff?  ?ff@   ?L?fff?fff?  ?  ?ff????  ??  ???33?  ?ٙ???fff?  ?333?  ?  ?fff?L?L?L?L?L?L?  ?ff?ٙ?ٙ?ff?ff?33?33?  ?33??33?  ?33??ٙ?  ?ٙ?ff@   ?ٙ?ٙ@ff??33???fff?L?  ?L?333??fff?L?fff?L?L?fff??fff??ff?33??  ??ٙ??ff@ff???  ???33?33?L@@   ?ff???????33?ٙ??33?ff?33@   @@@   ??ٙ?33?  ?33??fff?ff?ff?33???  ?  ?  ?  ?ff??ff?33?ff????33?ff???  ?fff?  ??ff?ff??  ?  ??L?L?  ?333?333?  ?333?333??  ?fff?fff?  ?fff??ff??ٙ?@33?@?33?ٙ?ff?ٙ?@   @,@33@L@y@33@33@ff@l@fff@ff?  @`  @S33@@,@Fff@@33@@`  @33@ff@ff?  ?  @?ٙ@@ff?  ?ff?ٙ?ff@ff@?ٙ@33?33?  @ff?ٙ?33@33@ff@333@ff@ff@?ff@,@   @ff??33?33?ff?ٙ@   @@@@@  @@  @,@&ff?33@@   @,?  ??33??ff??ٙ?ff?33??ٙ@ff@@???  ??  ?  ?  ????????ff@   @ff@   ??ff?ff??  ?  ?ٙ@ff?ٙ?33?33??ff???  ???fff?  ??ff?  ?fff?ff?L?   ?   ?333??  ??33?33??L?fff??  ??L?fff???  ?  ???  ?????ff?ٙ?ff?33?ff@ff@ff@   ?ٙ??  ?fff???33?ff?  ????ff?33??ff?33?33??ff?33?33?  ??  ?33?  ??fff?fff?  ?  ??  ?fff?  ?  ?  ?  ?fff???ff???33??ff??  ?  ?L??33?33???33?33?ff?33???ff??  ?  ?  ?fff?fff?  ?L?  ?fff?L?L?333?   >>>?L?  ?fff?fff?333?  ?333?  ?L?fff?L?fff?L?33??  ??  ?  ??  ?L?ff?  ?33??ff???L?L?L??333?   ?????L?  ?ff????  ?fff?L??ٙ?ff?ff?ff???33?ff?33???  ?  ???ff?ff??  ???  ?fff???  ?fff?L?  ?L?L?L?????333?L?L?  ?fff??fff?fff?fff?  ?ٙ?ff?L@?  ?L@@   ?33?33?33???ff??  ????33?33?33?ff?33?33???  ??33?ff?  ?  ?  ?ff?33?ff?33?33?  ?ff??33?33?  ?33?33?33?33??  ?33?  ?33??33???  ?fff?fff?  ??33?ff?ff??ٙ?ٙ?ٙ@   @ff@ff@33@?ٙ?ٙ?ff???fff?L?L?333?   ?ff?333?  ?33?ff??fff??fff???fff???   >>>?   >?   ??>    >L>>?   ?>>>?   ?333?L?333?   >>L>>L>>>>L>L>L>L>L>L>>>?   ??   >?L?   ?   ??333????   >>L>L>L>L====>>????333??   >>>L>L>L>>>>?L?333>?   ????   >>>???L??fff?L?L?L?333?333??333?fff?fff?  ?  ??L?   >>>>L>>>L>>>L>L>L>L>L>L=>L=>L?   ?   >>>>>>L>>>L>L>>>L>L>L=>L>L==>L>L>L>L>>>>>=>>?   ?   >?   >>>>>>>>>>?   ?   ?   ?   ?   ??   ?   ?   ?   ?   ?   ?   >?   >?   ??333??????fff?L??33?33?ff?33?????   ?   ?   ?   >???333??333?333?333?333?L?L?  ?  ??ff??  ?  ?fff?L?L?333?  ??  ?33?ff?33?ff?  ??fff?  ?  ?L??fff?  ?  ?L?fff?fff?fff?  ????  ?  ?  ?  ?333?  ?ff?ff???  ?L?L?333?fff??333>?fff?fff???fff?fff?333?L?ff???  ?L?fff?  ?fff?333?  ?fff?ff?ff?33@@@&ff@,@9@Fff@@  @  @@  @`  @y@33@ff@  @33@  @  @ff@@ff@@@@@ff@@  @ff@  @33@@@ff@@ff@ff@  @  @33@@ff@ff@@  @  @33@@@@@ff@@@ff@33@@ff@ff@  @ff@33@  @  @@y@`  @`  @`  @fff@y@y@`  @y@333@,?33@??@   @ff@   @   ?  @ff@   @&ff@&ff@9@,@   @@,@@Fff@S33@L@9@l@Y@,@,@33@,@   @@@&ff@   ?fff@&ff@33?ff?ff?  ?33?ff????@   ?ٙ@   ?33@   ?ff?ff?33?ٙ?33?  ?ٙ?  ?  ?33?????L?L?333?333?fff?  ????ff?ff??  ?333?fff?fff?  ??L?  ??fff?fff?  ??  ?  ??  ??fff?  ?fff?fff?fff?fff?L?333?  ?L?333?333??   ?   >??333?  ???  ???ff?  ?ٙ??33?  ?  ???  ?ff?fff?333?L??>?   ????ٙ?L?fff?   >>>L=>L>L?   >>L>L>L=>>>?   ?   ?   >>?>>L>>L>>>>=>=>L>>L>L>>L>>>>>?   >>>>>>>L>>>>>>L>>L>L>>L>>?   >>>?>?333?ff?>>L==                =                ===?   >>>>?   >?   >>>L>>>>L>L>>>L==            =?  ?33?33?33?   ?33?  ?   ?  ?  ?   =>?>>L>>>>L>>>L=>L==    =        =>L>>>L>>L>>>>>>>>>>>>>>        >L>L>L>?   >L    >>>>>>>>>>>>>>>>>>>>>>>>>    >>>>>>>>>>>>>>>?   =>>>>>>>>?L?333?fff?L?L?fff?L?fff?  ?333?>??L?33@   ?33?33?  ??  ?33@@33@   ?33?>?fff?>>L            >>>>>>>>>>>>>???fff?  @?  ?ff?33?ff??   ??333?L??  ?  ?333????  ??  ?  ?????33?@   ?ff??ff?333?fff?L?333?333?  ???L>??333?ff?33@   ?@   ?  ?ff?33??ff?ff?ff?ff?33?  ?ٙ?  ?ff?33?33?  ?ff?@33?ٙ?ff?33?fff??L?L?  ?fff??L?   >?L?333??fff?  ?  ????ff?  ?  ?33??fff?fff?   ?fff?>?   ?   ?   ?   ??>?   ?   >>?   ?   >??   >L>L>>L>>>L>>>>>>>L>>?>?   >??>?   >>>>>>>L>L>>?   ?   >>>>?   >>>>?   ?   ?       >>?   >L?       >>>>>>?   >?   ?   ?   ?   ?   ?   >>>L=>?   >?   ?   ??   ??333?   >?333??   >>??333?>?333?333?   ?   >>L?333>>?333?   ==>L=>L?   ?   >L>    >>L    >?   ?333??   >??   >?   ?   ?333?   ?   ?  >???fff?>?333??fff>?   >?L?  ?ٙ?33?ff?fff=>>>?   ?=>>L>>>=>L??>>?fff??33?333?@   @ff?33@33@   @ff@ff@   @?33??  ?ff??ff?ff?33?ff?  ?33?fff?fff?   ?fff?>>L=>L>>>>>>>>>>>?=>>?   ??   >>L>L>>L>L=====        >>L>?>>L>>???  ??ff??33?ٙ?ff?  ??33??>?fff?L?  ?fff>?   ?333??fff?333?333?L?L?333?   ???L??33?  ?  ?L?  ?333?  ??L?  >L?333?   ?333?   ?333?  ?fff?fff?fff?fff?fff?  ?fff?   ?L?L?fff?  ?fff?fff?fff?333?333?333?L?L?fff?  ?fff?  ?333??333?333?L?L?fff?L?ff????ٙ?33?ff?33?  ?  ????33?ٙ?33?@33@   @ff@ff@   @ff?ff?ff??ff?ff?L?   ?L?   ?333>>>>>?   >>?fff?   ??ff?  ??  ?fff??ff?ff?ff?33?ff?  ?fff?L?L?  ?fff?ff?333?  ?ٙ???  ?33??333?   ???L?L?   ?333?  ??333?L?fff?333??fff???   ?   ??333?L??L?333?L??   ?   ?333?333???ff?ff?ff?ٙ?  @333@ff@33?ٙ?  ?@   ??33?L?333??L???fff?????  ?fff??ff?ٙ?@ff@Fff?fff?ff?fff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?   ?   >@33>@33?ٙ>L@,=    =?33>L=    ==>L>L>L>L?   >L>L@&ff>L>L>L=>L=>L>L?   >>@陚>L=@==>L=>L>L@      >L>>L>??   >>>L>>L>L            ==>>L>>L>L    =    =    ==    ?   ?   >>>>>>>>>>>>>>>>>>>?   >>>>>>        ==    =>L>>L>>L>>>L>>>        >            >L>>?   >>?   >L==??fff?fff?  ?  >?fff??L?L?333??fff?333?fff?L?fff?333??333?   ?333?333?L>??   >>>=>L>=>L>L>?   ?333>==>L>L>=        ===>L>L>=>L=>>?   >>>>>>L>L>L=>L>>>L>L>>>>>>L>>>L=        =    ====>L>L>L>L?   >>>?   >?   ?   >>>L>>>>>>>>>>>>>>L>>>>>L>L>L>L>>>=>=>L>L?333?   ?   ??L?  ?  ?fff?fff?ff?  ?333?>>???333??L?L?fff?fff?  ?ff?L?L>?   ?fff?   ?fff??ff?33??  ??L???   ?L?   ?   ???fff?333??33??   ?   ?33?  @ff@   ?ٙ@   ?  ?33?ٙ?33??33??33??33?33?ٙ?33??L?L@?333???fff??fff?@ff@@ff??L?fff?L?fff?333?L?333?@&ff@   ?ff?ٙ?ff?ٙ?33?ff?33??  ??ff?ff?fff???  ?  ?ٙ?  ??fff?L?333?333?L?333?33?ff?33?ff?33?ff?  @ff@   ?ٙ?ff?33?33?33?ff????ٙ?ff@   ?33?ff?33?@ff@ff@   @ff@@ff@@ff@@@@ff@ff?33??fff?  ?  ?  ?  ?fff?fff?fff?fff?fff?  ??  ?  ?fff???????  ??????  ?ff???ff?33??ff?33??33?ٙ?33?ff?ff?ff?ff@ff?33@   @ff?33@ff@ff?33?ff@   ??33?33?33??  >>>?333?fff=??L??L?333?fff?  ?fff?L?fff?L?L?333?333?L?333?fff?333???>?  ?  ?   ?fff@33?33?33@   @&ff@333@   @   @   @33@33@@   @   @@   @S33@L@L@   @Y@9@L@L@L@Y@Fff@9@333@333@`  @Y@9@@  @@  @Fff@&ff@   @333@&ff@33@   @&ff@333@@  @Fff@333@,@9@Fff@`  @Y@Fff@S33y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y ?   ?   ???   ?   ?   ?   ??   ?   ?   >??   ???L?L?333?L?333?333?333>>?L??   ?   ?333?   ?   >?>?333>>??333?L?>>?   >?   ??   ?   ?   >??333?   ?   >?333?333??333>>?   >?   ?   >>>>>>>>>?   ?   >>>>>>>>>>>>>>?333?   ?>>>>>>>>>>>>>>>>>>L>>L>>L>?   ?   ?   >>>>>>L>L>L>>L>?   >>>>?   >>>?   >>>>>>>>>>>>>>>>>>>L>L>>>>>>>>?>>>>>>>>>?   >>>?   ?   ?   ?   ?   ?   >L>??   ??   >>>>>L=>L>L>L>===    >L>L>L>L>L=>L>>?   >?   ?   >?   >?L?   ???333>?   >>L?   >>L?   >>?   ?   >>?   >??   >?   >?   ?   ?   ?   >?   ?   ?   ?   ?   ?   ??   >?   ?   >?   >>?   ?   >??   >?   ?????   ?   ??   ?   >?   ????   >????fff?   ??fff?333?333??fff?L?333?L????333?   ?   ?   >??   ?   ?   ?   >?   ?   ?>>?   ?L?  ??ff?L?333?   ???   ?   ?   ?   ?L???   ???????333?   ??   ?   ?333??L?L?fff?333?L?333?L?L??333???L?L?fff??333?L??  ?L?fff?fff?  ?fff?  ?L?fff?fff?L?L?L?333?333?L?L?333?L?333?L?fff?   ?   ??333>>>>?fff?L?   ??333?fff?fff??fff?L?333???L?fff?333?333?L??L?   ?333?333?L?  ?333?333?333?333?333?L?L?L?333?L?333?333?333?333????   >L>??   ?   >>?333>?   ?   ?   >>>>>>>>>>>>>>>>?   ?   ?   ?333?L?L?   ???333?????   ?   >>?   >?   ?   ?   ??>>??L?L?L?L?L?333?L?333?L?333?333?333?fff?333?333?333?333?333?333?333?L??fff?fff?333???   >?   ??L?   >>>>>>?   ?333>>>L>L==>L>L>>?   ??   ?   ?   >>>?   ?   ?333?333?L??   ?333?333?   ?333?   ?333?L?L?333?333>?   ?   >?   ?   ??   ??   ??333???333??333?333??333?333?333?L?  ?L?333?L?  ?fff?  ?fff??fff?fff?  ?333?333?333?333??333?  ?L?L?fff?ff??  ???333?fff?L?333?fff?fff?  ?333?333??333?333?333?333?333?333?L>?   ?fff??   ?   >?>?   ?333?fff?>?>?333?  ?L?L?  ?333?333>>?   ????   ?fff??   ?   ??   ???333??333?333?333??L?333?L??333?333??L????L?333?333?L?L?fff?L?fff?L?L?ff?  ?  ?fff?L?fff?fff???L??333?L??333??   ????   ??>>?   >?>>?   ?333?fff??L??333?333?333?333?333?333?333???333?fff?333?333?333??333?L?333?333?L?333?333??   ??L?   >>>?   >?   ?   ??   ?   ?   >????>?>>>>?>>>>>?   >?   ?   ?   ?   ?>?   >?L?fff?L?fff?L???L?333?333?L?L?   ?   ?   ?>>>?   >@>?   >>?   ?   ?333?   ?   ?   >?   ???333?????L?333?333?L?L?333?L?333?fff?fff?L?L??fff?333?L?fff?L?L?fff?L?  ?L?333?333?333?   ?   ?   ?   >>>??333?L?fff?fff?333?fff?  ?fff?fff?L?L?L??L?fff?fff?fff?333??fff??L??333?333?333????   ???333????333?333?333?????333??333??333??333??   ?   ?   ?   ?fff?333?L?   ?L?fff?fff?333?333??333?333?333?L?L???333???L?333?L??333?333??333??333?333?333?333?333?333??333??   ????333?>>???L???L?333?333?333?333?333?L?L?333?333??L?L?333?L?L?333?333?L?  ?fff?  ?L?fff?333?L?333?333?333?fff?fff?  ?333?L??333?ff???333?L?fff?L?333?L?L?fff?L?fff?L?fff?L??L??L??L?333?L?L?L?L?L?  ?L?fff?fff?  ?fff?fff?  ?fff?  ?L?L?fff?fff?fff?fff?  ?  ?  ?  ?L?L?L?333?L?333?333?333?333?333?L?333??333??L??333?333?333?333?333?333?333?333?333?L?fff?fff?L?L?L?L?L?L?L?333?L?L?333?L?  ?333?333?333?333?333?L?333?333?L?L?  ??  ?  ?fff?L?L?L?fff?  ?L??  ?fff?fff?fff?fff?  ?fff?ff?fff?L??333?fff??L?fff?  ?L?L?L?L?fff?fff?fff?fff?  ??  ?L?fff?333?333?L?333?333?333?L???ff?ff??ff?ff??L?fff?L?fff??fff?33?  ?fff???ff?33?ff?ff??33?33???  ???????33?  ??33??ff?ٙ?ٙ@   ??  ??33?  ??  @   ?33?ٙ?33?33?  ??33?  ?33?  ?  ?ff?  ?????  ?  ?  ?33?ff?ff????  ?  ?fff?  ?  ?  ?fff?fff?fff?  ?  ?  ?  ????  ?  ?fff?  ??  ?  ??  ?  ?  ??ff??  ????????ff?  ?  ?ff?ff??@?33?33?????????????33????  ?ٙ?ff?ff?  ?  ?  ?  ??  ??????????  ?????33????ff????ff?ff?ٙ?ٙ?ٙ?????ff??ff?ff?ff?  ?ٙ???33?  ????33?  ??  ?ٙ?ff?ff?ff?ff???  ??  ?  ?  ??  ?33?ff?ff??33?33?  ?ff??ff?33?33?ff?  ?33??33?ff?33?  ??33?  ?  ?33?  ?  ?  ?  ?  ?  ?33?33?  ?33?33?33?33?ff?ff?  ?  ?ff?ff??33?ff?33?  ?33@@ff@   ?33@   @ff@   @ff?ff?ff?ٙ?33?ٙ?33?ff?33?33?ff?33?ٙ?ٙ?ff?33@   ?ٙ?ٙ?ٙ?ٙ?ff?33?33?ٙ?ٙ?ff?  ?ff???ٙ???ٙ????ٙ?ٙ?ٙ?????  ??  ?33?ٙ?  ??  ??33?33?  ?33?33?33?  ?33?33?  ?  ?33???ٙ?  ??ٙ?ff?ff?ٙ?ٙ?ٙ?????ٙ?33@?33?ff?33?ff??ff?ٙ??ٙ?ٙ?ff@   ?ٙ?ٙ?ff?ff??33?ff?ٙ@   @ff@33@ff@@?ff?ff?ff?ٙ?ff@&ff@   @&ff@@@33@?ٙ@   @   ????  ?  ?  ??  ?  ?ٙ?ٙ?  ????  ??  ????????ٙ?ٙ?33@ff@   @?33@   @   ?ff?ٙ?ff@   ?ff?ff?33?33@   @?ff@   @@   @33@   @ff@   @@ff@,@333?33@33@ff?ٙ?ff?33?33@@33@@,@33@@   ?33@   @@@@33@?33?33@?ff@33?ff?ff?ff?ff?ff@ff?ff?ff?ٙ?ٙ?ٙ@`  @   ?ff?ff?ff?33?ٙ?ٙ?ff?ٙ?ff?ff?ff?ff?ff?ff?33?33@   @   @&ff@33@33@&ff@   @@   @   ?33@   @33@@   @@   @   @ff@@@@33@@&ff@33@@ff@33@@   @@@   @@,?33?33@@   @   @   @33@   @@ff@   @   ?ff?33@33?33?33?ff?ٙ?ٙ?ٙ????33?ff?ff?ٙ?ff?ff?ٙ?ٙ?   ????   ??   ?333?   ??   ????   ??333??   ?   ?   ?????   ?   ??   ?   ??   ??   ??   ?   >>?   >?   >?   >?   ?   ?333?   ??L??333?   ??????????333?333?333?333??   ?   ???   ??L?fff?   ?   ?   ?   ?   ?   ?????333???????333??   ?   ?   ?   ?   ??   ?   ????   ?   ?   ?   ?   ?   ?   ?   ?   >?   ?   ?   ?   ?   ?   ??   ?333?????   ?   ?   ?   ?   ?   ?   ??   ??   ?   ?   ??   ?   ?   ?   ?   ?   ?   ?????   ?   ??   ?333?   ?   ????333??   ?   ??   ???   ?   ??   >?   ?>>>?   ?   >>?   ??fff?   ?   >?   >>>>>>>>>>>>>>>>>?   ?   ?   ?   ?333??333?????   >?L?L?333?   >?   ??   ????333??   ?   ?   ?   ?   ???333?   ????   >>>@?   >?   ?   ?L>?333?   >>??   ??333?333??333????   ?   ?   >>?   ?   >?   ?   ?   ?   ?   ?   >?   ????   ?   ?   ?   ????   ?   ???333?L??333?333??  ?  @,?L?L?333?333??   ?   ?   >?   ?   ?   ??   ?L?L?333?L?333?333??333?   ?L?333??   ?????   ?   ??333??333?L?L?333?L?333?333???333?L?333?L?333??333?333?333?L?L?L?333?L?333??L?fff?L?L?333?333?333??L?L?333?333?333?333????333?333?333??333?333??333?333?333?333?L?333?333??333??333??????   ?   ??   ??????   ???333?333?333?333?L?L?333?L?fff?L?fff?  ?  ?fff?fff?fff?L?L?L?fff?L?L?L?333?333?L?333?333?333????333?333?333?333?333?333?333?333?333?333?L?L?L?L?L?L?333?L?333?L?L?L?L?333?L?333?L?333?333?L??fff?333?333?fff?  ?  ?fff?  ?fff?fff?L?fff?L?333?333?L?L?L?L?L?L?fff?L?L?L?L?fff?L?L?L?fff?fff?fff?fff?  ?  ?fff?fff?fff?L?333?L?333?333?333?L?L?333?L?fff?L?L?L?333?333?333?333?333?L?fff?fff?fff?L?fff?L?333?L?333?333?333?L?333?333?L?L?L?fff?   ?   >>>>>>>>>>>>>>>>>?333>>>>>>?   >>>>>>>>>?   >>>>>>>>>>>>?   ?   ?   ?   >?   ?   >>>>A>>>>>>>>>>>>>>>>>>>>?   ?   >>??   >?   >>?   >>>>?>L>L>>>>>>L>>>L>L>L>L>L>L>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>>>>>L?333?333?   ?   >>>>>>?   >>>>>>>L>L>L>L>L>L>>L=>L>L>L>>>L>L>>?   ?   >>?L>>>>>>>?   >>>>???   >?   ?333?333?333?   ??333??333?   ?fff?fff?333?333?333?????333????fff??>>>>?   >>>>>?   ?L?   ?>?   ?   ?   ?   ?   ?   ?   ?   >?   ?   >>>?   ?   ??   ?   ???   >>>>>>>>>>>?   >?>>?   ?   >>??333?>>?>?   ?   >L>>>>>>?   >>>>?   ?   ??   ????   ??333?L>>>?   ?   ?   ?   ?   ???   ??   ?   ?L?   ??333?   ????   ??   ??????333???L?333?333?333?333?L?333???   ??333???   ??????   >>?   ?   ???333?333????   ???   ?   ?   >L>?L>?>?   ?   ?   >?   >>?   ?   ?   ?   ?   ?   ?   ?333?   >??   ?   ???333?L?L?333?L?333?L?L?fff?L?L?L?L?L?L?333?333??333?L?333?333?333?   ??   ?333?333?>?   >>>>>>?   ?   >>>>>>>>>>>?   ?   ?   ????333???????   ?   ?   >?   ?   ?   ?   ?   ?   ??   ?   ??   ???   ?   ?   ?   ?   ???L?333?L?L?L?L?fff??L?L?333?L?L?L?L?fff?L?fff?333?333?333?333?333?L?L?fff?L?L?fff?LA33?333???   ?   ?   ??   ?   ?   ?   ??   ?L?  ?ff?  ???33??  ?ff?L?333?333??333?333?333???333???????333?333?L??L?333???   >>?   >?   ?   ?   ?   >>>?   ?   >?   ?   ?L??ff?ff?L?   ?333?L?L?fff?L??  ??ff??  ?L??L?   >>>>?   >?   >>>>>>>>>>>>??   ??L?333?L?>?   ?   ?   ?   ?   ?   ?   ?   ?   ???>?   ??   ?   ?333?   ?   ?   ?   ?   ?   ?   ?   >?   ?   ?   ?   ?   ????   ?333>>>?   ?333??333?L?L?333?333?333??   ??   ?   ?   ??   ?>>?   >?   >?   >>>>>?   >>>>>>>>>>>>>?   ?L?fff?fff?  ?L?fff?  ?  ?  ?L?fff?333?333?333??333??   ??333????333????   ??????333?   ????fff?fff?L?L?333?333?333??333??333??   >>?   ?   ?   ??333?   ?   ?   ???   ?   ?   ?   ?   ?   ?>=>L>L>L>L>L>L=>>>L=>L======>L>===>L>=>L===>L>L====        ===    =    =                        ?   >>L=>=>L>>L>L>L>>>?ff?>>L>>>L>L                ?   ?   >L>L>>>L>>??   ???L?  ?  ?fff?  ?L?L??L?   ?   ?   ?>?fff?   >?   ?   ?333?   >>?333?   ???   ?   ?>>?   ?333?  >??   >>>?   ?   ??   ?   >>>>??   >?   >>?   ?   ?   >?   >>>>?   ?   ?   ?   ?   ??333?333?L?fff?L@   @   ?  ???@&ff?33?33?ٙ?33??  ?33????L?L??fff?fff?fff?L?L?  ?fff?L?fff??L?fff?  ?L?L?>>?>>?   ??L>?333?   >>>>>?   >>?   ?333>?   ?   ?   ?   >?   >?   >>>>>>>>>>>>>>?   >>>L=>L>L>>>>>>>L>L>L>L>>?   ?L??  ?L?333?333?   ?333?   >?   ?   ?   ?   >>?   >>>>>>>L>>>??333??   >?   ?   ?33?ff?  ?ff?ff?33?fff?333?   ?   ?   >?   >?   ?   ?   ??   ?   >>>>>L>>>>>>=>>L>L>>L>L>>>>    >>?   ?   >?   >>>>>>>>>>>>>>>>>>>?   ?   ?333>>>>>>L>L>L>L====>L>>L>L>L>>>>>>>>?   >>?>L>L>L>L>L>>>L>>>>>L====    =            ======>L?   ?   ?   ??333?   >L=>L>L>L>L>>>L>L>L=>L>L>L>>?   >??   >>>?   >>L>L    ==================        ===>L>>>?   ?   ??L?333?   >>>>L>L>>L>L>L====    ======    =>L=>L>L==========>L>L=======>>L>L===>L>>L>L>=>L==    ===    =    ======>L>L>>=>L=====>L>>>L>L>L=>=>L>L>==            ==>>L>L>L?>L==>L=======>L>L===    =========>L==>L>L    =========>L>L>>==>L>L==                                                            =            =>>>L=>==?   ==>L=    >>=>?333>>>L>>    >>L========    ==                ==        ==>L>L>L>L>L>L>L==>L=>L>>>>L>>>>>>>>>>>>>?   ?   ?   >>?333>>?   >>>>>>>>>L>>>>>>>??   ??333?333?333??L?333?L?L?333?333?333?333?333?333?333??333>??   ?fff?  ?fff?fff?L?333?L?L?L?L?  ?333?333?L??333?333?333????333?  ??L???fff?ٙ?  ??333?  ?33?  ?ff?fff?ٙ????  ?fff?  ?ff?33?33???  ?ff?33?33?33?????33???  ??  ?ff?ff???33?  ?L?333??   >>>>>??L>>?ff?fff?  ?333?333?fff?333??333?  ?L?L?333?   ?   ?   >?   ?   ?   ?>>>>>?   ?   ?fff?333??333????  ?  ?  ??  ?  ?  ?  ??  ?ff?L?  ?fff?33?L?L??L?33??  ??fff?L?L?333?L?  ?L?fff?L?fff?fff?fff?fff?fff?  ?fff?fff?333?L?333?333?L?fff?ff?L?  ?  ????  ?L?fff?  ?ٙ???ff??ff?ff??33@   ?ff?  ?ff???fff???fff?33?33?ٙ???fff?L???fff?  ?L?  ??ff??33?ff@33@@   @@  @@  @   @@ff@ff@   @ff?ٙ?ff?ff???ٙ@   @333@  @33?33??ff?L??   ????333?L?fff?L?L?L???ff?fff?  ?  ?  ?L?fff?ff???ff?fff?  ??  ?  ?ff?33??ff?ff??ff???ff?ff???33??ff@   ?ff@ff?ff@??ٙ??33??ٙ?33?ff?ff?ff@ff@@@33@   ?  ???  ?ff?  ?fff???ff??ff?ff?  ?  ??  ?  ?  ?L?L?  ??ff???ff?fff?  ??  ?L?333?333?333?   ??333?L?   ?333?L??  ?ff??  ??ff?L?  ?fff?L?fff?  ?  ??L?333?333??333?333?333?  ???ff?  ?33?33??ff?L?fff?ff?333??333?333?L?333>>>L>==>?333>>>???   ??>>>>??L?L?333?333?   ?L??   ??   >L>>>>L=>L>>>>?   >?fff?333?333???fff??333?fff?333?333?  ?L?  ?L?333?333?fff?fff?fff?  ?L?  ?ff?  ?  ??fff?fff?L?333?ff?ff?33?  ?L>?333?333?333??L?333>>>?L?   ?L>>L>=>L>>L>?   ?333?fff??33?  ?33?33??  ??33???  >>L>L                        =                                                            >L>>?   ?333?L?L?L?333?L?L?333?fff?333?L?333??   >>>?   =    >L    >>>L>>L>>=                >L        >L?>>>L>L=?   ===>=    >>L=>>L=>==?   >L>L>L>>L>>>>>L>>>???   ?   >>???   ?   ?fff?fff?   ??fff?L?333?333?333?fff???L?333??333?333?L?fff?333?333?fff?L?L?333?fff?L?333?333?333????333?333?333?333?L?333?   >>>?   >?>>>>?   >>?   ?   ?   ?   ?   ?   ?333??L?L???   ??   ?   >>>?   >?   >L>?   >>>>>>>>L>>>>=>>L>L>>>>L>L>L>>?333?fff?L??   ?   ?>>>>>>?   ?   ?   ?????   ?>>?   >>L>L>L>L>>L>L>>>?   ?   >>>?   >>>L>>>L>==>L?   >L>L>>>L=====    =>L    >L>L=>L>L=>>>L>=>L>L>L>L>>>>>>>>>>>>>L>L==>L>L>L=>L>L>L=>L>L=>L>L>L>L====>L>L==>L>L>L>L=>L>L====>L>L>L>L>L>>L>L>L>L===>L>L>L=        >L>?333>?   ?>>?   ?   ?333?   ???333?>L>>>>L>L>L?   >>>?>???   ?   ??   ?333>>L>>>>>>L>L>>L>>L===>L>L>L>L>L>L>L>>L>L=>L>L>L>?   ?fff??   >?   ?   ?   ?   ??>?333?333??333?fff?fff??fff????  ??  ?L?   ????   ?   >?   >??   ?333???333?L??fff?L?333?333?333?fff?L??L>>>>?   ??   ?   ??L?333?   ??333?????   ???   ????333???????   ?   ?333???333?ff?L???  ??333??333?333?L?L?  ?  ??33???ff?33?ff???ff?ff?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?L?fff?L?  ?333?fff??L?  ??  ?  ?fff?L?L?fff?L?fff?  ?fff?fff?  ?fff?fff?fff?fff?fff?L?L?333?L?fff?L?L?L?L?fff?333?333?333??333?333?333??fff??   ?L?L?fff?????   ?   ?   ?>??   ?   ?   ??   ?   ?   ?   ?>?333?   ??   >>@   @33???L@33@33?ff@ff?@@@@  ?ff?  ?  ?ٙ@ff@   @@ff???  ?fff?fff?L?L?L?L?L?  ?fff??ٙ?ff??  ???  ?  ????ff??33?  ?33?????ff??  ?   ?   ?333??  ?  ?L?L?  ??  ?  ?fff?fff?fff?L?L?333???  ???fff?L?ff??ٙ?  ???33?  ??  ??333?33?33?ٙ?ٙ?  ?ٙ@33@ff?ff?ٙ??  ??ff?ff?33?33?ff?fff???   ??333??333?L?fff?  ?333?L?fff?ff?  ?ff????33?ٙ?ٙ??  ?  ?ff?33?ٙ?ٙ?33?33?33??ٙ?ٙ?ff?ff??  ?33?33?ff?  ?33?33?33???  ?  ?33?33?ff?ff?ff?ff?33?33?33?33?ff?33?ff?  ?ٙ?33?ff?  ???  ?fff?fff??333??   ??   ?   >?   ?333?L?fff?   >>>>>>>?   ?   ?333??333?  @ff@   ?ff?ff?33@333@S33@  @&ff@   @Fff@?33?ٙ@9@   @ff?ff?ٙ?ٙ??33?@@YA\ATA,AnffAffy Ay y y A33AAffA  AffAyAs33AffAx  A33AlAAQA4A>ffAIATAA`  AffA  AffAffAFffA   A33A&ffAffAp  ANffAC33ALA;33A9AFffAC33ADAS33A\A\AFffAIA<AVffATA\A0  A33A   A33A4A0  A,A333A,AffA33AffA	A  A33A@AA!A   A0  A<A^ffAc33AH  AP  AP  AnffAA[33AAvffA|AA33AtA  A  As33As33A`  Ak33AYAYA>ffA(  A+33A!A  A   AA!AA33AffAffAffAA33@陚AAffA33AffAff@ff@@@ff@@ff@ff@ff@  @@ə@@ə@ə@ٙ@33@ff@@  @ff@  @  @ffAffA@33@ff@  @@ٙ@@33@@@  @@  @@@  @@ff@  @33@@33@@33@s33@@  @ff@l@fff@Y@@  @9@,@9@333@,@fff@9@333@33@,@&ff@@   @@   @@333@&ff@L@@?33@9@33?ff@   @@@@@@@@ff@   @@ff?ff?ff?ٙ?33?ff?ff@,@ff@ff@@33@ff@@   @   @   ?33?33?ff?ٙ?ٙ?  ??  ??@ff@@  @@  @@  @33@@@   @@&ff@&ff@33?ff?ٙ?33@   @ff@33@333@333@333@333@&ff@@  @@  @9@Fff@`  @S33@  @`  @@  @@  @L@9@Fff@@  @@  @9@@  @Y@S33@Y@L@9@333@@  @,@,@,@   @&ff@333@9@Fff@9@9@9@@  @Y@Y@L@L@Y@L@Fff@S33@`  @Y@Y@`  @`  @fff@l@`  @L@S33@@  @Fff@@  @333@L@@  @@  @L@`  @Fff@@  @S33@9@@  @9@9@@  @9@9@333@9@333@333@,@   @33@9@333@333@   @333@333@&ff@Fff@9@Fff@S33@s33@y@s33@y@`  @s33@s33@s33@fff@`  @y@33@Fff@9@9@9@Fff@`  @L@L@`  @`  @L@S33@Y@S33@Fff@L@@  @9@@  @,@333@9@,@&ff@&ff@&ff@&ff@&ff@,@333@@@,@   @333@ff@&ff@   @?ٙ@ff@?33@@@@@&ff@@@ff@ff@   @   ?33@ff?33@@@33?33@?33@33@@   @@   @33?33?33@   @@ff@33@9@ff@ff@@@@33@@   @,@&ff@&ff@&ff@Fff@S33@S33@S33@333@9@,@@33@@33@@,@33@   @@,@9@,@   @333@,@&ff@@33@ff@33@33@33@@   @333@S33@`  @@@9@9@fff@`  @Y@Y@Y@l@`  @33@@33@S33@fff@fff@  @l@l@S33@333@fff@s33@33@fff@l@@S33@33@@  @  @ff@ff@33@s33@fff@ə@ff@33@  @y@@  @s33@@fff@l@Y@ff@   @333?ff@@ff@@ff@333@9@`  @fff@Fff@?  ?ff??ff??ff?ff??  ?ff?33?  ?33@   ?33?ff?ff?ٙ?ٙ?ff@?33?ff??  ?33???  ?  ?33??ff?ff?  ?33?33@   @   ?ff?ff@   ?33@   @   @   ?33?ff@ff?ٙ?ff?ٙ?ff?ff??  ?ff?  ?33?  ?ٙ?ff?ٙ??33?ff?33?33?33?33?33??ff??ff?  ??33@33@33????L??L?fff??ff?fff?333??   ???333?333?L?L?L?L?  ??  ?  ???fff??L?  ?fff?fff?  ?ff??  ?L?L?  ?fff?L?L???333?333?L?L?   ?   >>?   >>?   ???   ?  ??L?333?L?L?L?fff??fff?fff?  ????fff??L?L?L??????   ???333?333?L?L?fff?333?   ?333?   ??fff??  ??L?333??   ?333?L?L?  ????ff????33???  ???L??fff?fff????ff?????  ?  ?  ??ff??  ?  ??33?ff???ff???fff?fff??  ????  ??33??33?  ?ff???????ff?333?fff?333>>?   ?   ??333?333?fff??ff?33?????  ?333?  ?33?33?ٙ?ff?  ??ff?fff?  ?  ?   ?   ?   >L>>??fff?   >>>>>>?   ??>L?   >>>?   ??333?   ?L?333?L?ff?fff?  ?  ?  ?fff?fff?L?  ?fff?ff?L?fff????   ??fff??333?L?L?fff?fff?L??333?L?L????ff?ff?  ???  ?fff?fff?fff?L?fff?fff?  ?333?   >?>?   ??333??   ?   >>>>>>>?   >>???   ?   ?   >?   ?   ?   >>>?>?   >??   ?   ?   >>???   ?333>?   ??   >????   ?333?   ?   >??   ?   ?333?333??   ?333>?   ??333???333?333?  ?fff?fff?fff?  ?fff?  ?   >>>>>????   ?333?L?fff?L?L?L?????fff???   >>>L>L=>L>L>>>>>>>??   ??   >?   ???   ?L?   ??   ?   ?   ?333??>?   >??   ?   ?333?333?333??fff?333?333??333?fff?333?L?fff?333?333?L?333?333?L?333?333?333?????   ?333?L?   ??   >>?   ???333???333?L?333?333??L?  ?L?L?333?fff@l?333?333?   ?   ?   ?33???   ?   ??????L    ?=q@Y?=q            @
=@Y@
=@
=@Y?=q@
=@Y@G@G@
=@Y@YA@Y    ?=q?=q?=q        ?=q?=q?=q    ?=q                                    ?=q    ?=q                                                                ?=q                                ?=q    ?=q?=q    @
=?=q    ?=q                            ?=q                    ?=q@Y?=q?=q@Y@Y?=q@Y@Y@
=@
=@
=?=q?=q@Y                @G        @Y@Y@
=@
=@G@
=?=q@Y?=q?=q    @Y@Y?=q?=q    ?=q?=q?=q?=q?=q    ?=q                                        ?=q                                        ?=q    ?=q                    ?=q    ?=q@Y?=q                ?=q                                                                    ?=q?=q    ?=q                                                ?=q    ?=q    @Y        ?=q                                ?=q            ?=q                                            ?=q                    ?=q                                        ?=q?=q@Y@Y@Y@Y?=q?=q?=q@
=@Y@Y            ?=q                ?=q?=q                ?=q?=q?=q?=q@
=@Y    ?=q?=q    ?=q@Y    ?=q@
=?=q        ?=q                ?=q?=q    @Y?=q                    ?=q                                                                                                                                        ?=q                    ?=q@Y@Y?=q?=q?=q        ?=q                                                                                                        @Y        ?=q                        @Y                    ?=q                        @Y    ?=q@Y                        ?=q?=q            ?=q    ?=q    ?=q            ?=q?=q        @Y                                        ?=q    ?=q?=q                                                                                                                    ?=q?=q?=q?=q@Y@Y@Y?=q?=q@Y?=q@Y@
=@
=?=q@Y@Y@
=?=q@Y@Y?=q?=q?=q    ?=q        ?=q?=q    ?=q?=q    ?=q    ?=q?=q                                        ?=q    @
=@Y    @Y?=q@Y?=q        ?=q        ?=q?=q?=q?=q@Y?=q?=q                ?=q        @Y        ?=q                                                    ?=q        ?=q?=q?=q@Y@
=?=q@
=@
=@
=A@YA@Y?=q?=q@Y@Y@Y@
=@G@
=@
=@Y@G?=q@Y@
=@Y@Y@Y@G@
=@G@
=@G@
=?=q@Y@Y    @Y@Y@
=@
=@Y?=q?=q@Y?=q@
=@
=@Y@
=@
=@GA@
=AA:HAAA:HA:HA\  A\  A}@
=@G@G    @
=@Y?=q    ?=q?=q    ?=q?=q?=q@
=y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y     @G@Y@YA@Y@
=@Y@G    @YAA\  @G@G@G@YA:H@Y@G@Y@
=@GAAA\  @
=        A@G@G@
=?=q@G    @Y?=q@Y@
=    @
=@G?=q    ?=q@Y?=q?=q@
=@
=@Y?=q@G    ?=qA@Y?=q@GA@
=@G@Y@YA@G@Y@
=@
=    @Y@
=@Y?=q@
=?=q@
=@Y?=q?=q@
=A@Y@Y@Y@YA@
=@G?=q?=q?=q        ?=q@G@G@G@G@G@
=@G@
=@
=@
=@
=A:H@G@Y@G@YA\  A\  @G@
=A?=q@G@G@
=@
=@
=A\  A=qAAAAA\  ?=qA:HA=qAA=qA\  @GA\  A}@GA@
=    @
=@
=@G@
=AA}A=qA\  AAAA}A:HA}A@Y@Y@Y@
=@
=@Y        @Y        ?=q@G@GA@Y    ?=q                @
=                                                            @
=?=q@YAA\  @
=A:H@
=@
=@YA\  A:H@YA:HA:H@GA:HA@Y@G@
=@GAA:H@
=@GA@GA@GA@YA:H@
=@
=@
=A@GA@GA@
=AA\  @
=AAA\  A:HA:H@GA:H@G@G@G@
=@Y@Y@G@G@
=@G?=q@
=@G@Y@GA@Y@Y@
=@G?=q@Y    @Y@Y    ?=q?=q                        @Y?=q?=q@Y                                ?=q@Y                                                        ?=q                            ?=q            @
=    ?=q@
=@Y                ?=q                ?=q            ?=q            ?=q                                                                                                                                                                        ?=q    ?=q    ?=q?=q    ?=q?=q            ?=q                ?=q        ?=q                    ?=q        @Y                                            @Y        ?=q?=q    ?=q?=q?=q?=q        ?=q?=q?=q@
=?=q    @Y    @G?=q@Y@
=@Y@Y                ?=q    ?=q                    ?=q                ?=q            @Y?=q@
=@G@Y?=q@
=A@Y@Y@Y@Y@YA@G@
=?=q@Y?=q        ?=q@Y    ?=q    @Y?=q?=q@Y@Y?=q@Y@Y?=q@
=A@
=@Y@
=@Y@Y    ?=q@Y@Y?=q    @Y?=q?=q@Y    ?=q@Y?=q@
=@G@Y@Y@
=@
=@
=?=q?=q?=q@
=@G@Y@Y?=q?=qA:H@YA?=q?=q?=q@
=?=q@
=        ?=q                    y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y                     ?=q        @
=    @Y?=q?=q?=q            @Y@Y?=q?=q@Y@
=    @Y?=q?=q?=q@Y        ?=q    @Y@
=@Y@
=@
=@Y@
=                                                                                        ?=q@Y@
=@
=@
=@Y@Y@Y?=q@Y@
=@Y@G@Y@
=    @
=?=q@
=@G@
=@G@Y?=q@
=@G@
=@G@GAA:HAAA@G@G@
=@G@G@G@
=A@GA@G@G@
=@G@
=?=q@G@G@G@GAA@GA:HAA\)A:H@GA:H@
=@G@G@GA:H@G@
=@
=@
=?=q@Y?=q@
=?=q@Y@Y@Y@Y?=q?=q?=q?=q?=q?=q    ?=q    ?=q    ?=q                    ?=q@Y        ?=q?=q    ?=q    @Y                        ?=q?=q    ?=q        ?=q?=q        @Y?=q?=q?=q    ?=q    @Y    @Y    ?=q@Y@
=@Y?=q                                                                                                                ?=q                                                                                                                                                                                                                                                                ?=q    ?=q                                    ?=q                ?=q                                @
=?=q?=q@
=@
=@Y    ?=q?=q@G@G@Y                ?=q        ?=q                                            ?=q                                                                                                                                                            ?=q    ?=q?=q                                ?=q    @Y?=q            ?=q    @Y@Y@
=A@
=@
=A:HA@G@G@
=    ?=q?=q                            ?=q@Y?=q@Y    ?=q        ?=q                ?=q    ?=q        ?=q                                                                                                                                                                                                                                                        ?=q?=q@G@G@
=?=q                                    ?=q                    ?=q                                                    ?=q?=q                                            ?=q                                                                    ?=q    @Y@G?=qA\  AA@
=?=q                                @Y        ?=q                                    ?=q@Y@Y@
=@G@G@
=@Y@Y                                    ?=q?=q                                                        ?=q                ?=q                    ?=q                                                                        ?=q?=q@Y@Y?=q@Y?=q@Y?=q?=q                                ?=q                                @Y?=q@Y                        ?=q@Y    ?=q@
=?=q?=q?=q?=q    ?=q@
=@
=@Y?=q?=q?=q        ?=q?=q?=q?=q@Y?=q                ?=q    ?=q    ?=q            ?=q    ?=q    ?=q                                                                            ?=q                        ?=q                            @Y?=q@
=?=q?=q@Y@G@GA@GA\  A}A}AA}A=qA:HAA:HA\  @G@G@
=@Y?=q?=q?=q?=q?=q?=q?=q?=q?=q@Y?=q?=q    ?=q?=q?=q?=q                                                                                                                                                                                                                                                    ?=q                ?=q?=q?=q@
=?=q                                                                ?=q?=q    ?=q        ?=q?=q?=q?=q            ?=q@
=            @Y@Y    ?=q                                                    ?=q                                                    @Y@
=?=q@Y?=q    ?=q    ?=q@Y@Y        ?=q@G?=q@Y                        ?=q    ?=q?=q@
=@G@
=@Y@Y@Y@G@G@G@Y@YA@G@
=A@G?=q@YAA@G@
=@Y@Y@
=?=q?=q?=q?=q@Y@
=@Y@
=@Y?=q?=q@Y?=q?=q?=q?=q?=q    ?=q        ?=q?=q    @Y@Y?=q?=q?=q        ?=q                        @Y            ?=q?=q?=q@Y?=q?=q?=q?=q@Y?=q@
=?=q@Y                ?=q                        ?=q@Y?=q@G@
=@
=@
=@Y@G@Y@Y?=q?=q@
=@
=@Y@Y?=q@Y    ?=q@Y?=q    ?=q@Y?=q    ?=q?=q@Y    @
=?=q?=q?=q?=q?=q@G@Y?=q@
=@GAA:H@
=@Y@Y@
=@
=@G@
=@Y@Y@G@Y?=q@Y@
=?=q@Y@Y@
=@G@Y@
=@G@Y@G@
=@Y@
=    @
=@
=@Y@GAA:HA@
=@
=@
=@Y@Y@G    @Y@Y@Y                    @Y@Y?=q    ?=q?=q    ?=q?=q@Y@GA@GA\  A:HA:H@G@
=@
=@Y@Y    ?=q    A:H@
=?=qA}?=q?=q@Y@
=@Y@Y    ?=q@G    @Y?=qA@GAA}A}A\  @GA\  AA\  @Y?=q    ?=q    ?=q@Y?=q@GA:HA@G@G@G@Y@Y?=q?=q?=q@Y?=q    ?=q    ?=q@Y@
=@Y@
=@Y?=q@Y    @Y?=q@Y@Y?=q        @
=@
=@Y@
=@Y@GAA@
=@GAA}A:HA:HAA}A}A:H@GA}A\  A}A\  AA\  AA\  AA:H@G@GA\  A:H@GA}A}AAA}A}A\  A}AA\  A\  A\  AA@
=@
=@
=?=q    ?=q?=q@
=@G@Y?=q?=q    @Y    @Y?=q@Y?=q@Y@Y?=q@
=@Y?=q@Y        @
=@
=A:HA}A\  A\  A:HA@G?=q?=q?=q?=q    ?=q?=q                                @Y                    ?=q?=q@
=            ?=q@G@GA:HA:HAA}@GA\  AA:HA:HAA}A}A}A@GA\  @
=@
=@
=@Y@
=    ?=q@Y@
=@
=@
=@
=?=q?=q@Y?=q@Y@Y    @Y@
=?=q@
=@GA:H@
=    ?=q?=q?=q    ?=q?=q        ?=q        ?=q            @Y@Y@Y@Y?=q@Y?=q                @Y?=q    ?=q@Y?=q@Y@Y?=q@Y                @Y                        ?=q    ?=q    ?=q@
=?=q@
=@GAAAAAA}AAA}AA\  A\  A:HA:H@GA@G@GA@
=@G?=q@Y    @Y    ?=q        @G                    @Y@Y?=q@Y@G@
=@Y@Y@Y@
=?=q?=q        @Y?=q    @
=@
=@Y?=q@
=@
=A:HA:H@GAAAA}A}A}AA=qA=qA@G@
=@Y@
=A:HAA:HA\  A\  @
=@GA\  AAA=qA\)A=qA\  A\  A}AA}AAAAA}AA}A:HA\  @
=A:HA@
=A@Y@Y@
=@GA@Y@Y@
=?=q    @
=@Y?=q@G@Y?=q?=q@Y@Y?=q@Y?=q        ?=q@Y@Y        @Y                    ?=q    @Y?=q                            ?=q    ?=q        @
=    @Y@
=                            ?=q                                                @Y@Y@
=@G@
=@YAA:H@Y@G@GA:HAA}A@G@GAAA?=q@
=A@GAA@G@G@Y?=q?=q?=q@Y    @Y@Y@Y?=q?=q        ?=q?=q        @Y@Y@Y@Y?=q?=q    @Y    @Y            ?=q?=q?=q            ?=q?=q?=q?=q                    ?=q        ?=q@G@Y                                                                                                @YA}A\  A\  AA\  @GAA:H@G@G@
=@
=@
=@G@
=@Y@
=@Y@Y@G@Y@Y    ?=q?=q@Y                                    ?=q                                    ?=q?=q?=q                                                        ?=q    @Y    ?=q@Y@Y                ?=q?=q?=q?=q@
=?=q                                    @YA    @Y    ?=q?=q    @Y?=q@
=@GAA:H@
=@
=?=q?=qAA:HAA@
=A@G@GA@Y@G@
=@
=AA}A\  A\  A:HA:H@
=@G@G@G@
=@
=@Y@Y?=q?=q            @Y?=q?=q@Y@Y@Y?=q?=q    @Y?=q    ?=q@Y        ?=q@Y?=q    A?=q@
=?=q?=q                    ?=q@Y?=q    ?=q?=q@Y@Y@
=?=q@
=@G@G@Y@Y@GAABB{AAAA}A\  AA@
=@G@G@Y@Y@G@
=@
=@G@GA@G@
=@YA@
=@
=?=q@
=@Y@YA@
=@G@YAAAA@GAA@Y@
=@
=@
=@Y?=q@G@Y@Y@
=@Y    @Y?=q    @Y@Y@
=?=q@G@
=?=q?=q@Y@Y@
=@
=@
=?=q@Y@
=@
=A@
=@G@
=@
=@Y@YAAAA:HA:HA}A}AAAA\)A=qA\)A}AzB*BL
=BAzBAA\)A=qAA\  @
=A@G@G@Y    ?=q@
=@Y@Y@G?=q?=qA?=q?=q?=q                ?=q@Y    ?=q    ?=q        ?=q                @Y?=q?=q    ?=q                    ?=q        @
=                            @Y?=q@Y@Y?=q@Y?=q?=q    @
=@Y@Y@
=?=q@Y@G@
=AA@GA@GAA:HA:HA:HA\)B}RB  B;zB  B\A\  A:HAA:HAA:H@GA@G@
=@
=@G@Y@Y@Y@Y?=q@Y@
=@Y@G@G@GA}AAA:H@GA\  A:HA\  A:HA\  A:HA:HA\  AA:HAA:HAAA:HA:HA:HAAA:HA:HAA:HA:HA:HAAAAA:HA\  A:HAAA\  A:HA\  A:HAA:HAA:H@G@G@GA:HA:HA\  AA:HA:HAA:HA:HA:HA:HA:HA@G@GA@G@GAA:H@G@G@
=@GA}A:H@G@GAA\  A\  A:HA\  A:HAA@G@
=@Y@Y@
=?=q@Y?=q@
=@Y?=q@
=?=q?=q@Y?=q?=q?=q    ?=q?=q            @Y?=q    @Y        ?=q?=q?=q?=q@Y@Y    ?=q?=q?=q    ?=q                ?=q?=q                        ?=q                        @Y    ?=q    @Y@G@Y?=q?=q?=q                                            @
=@Y?=q    @Y    ?=q?=q            ?=q                                ?=q    @Y    ?=q        @Y@Y        ?=q?=q                                                                                                                                            @G?=q?=q?=q    @Y?=qA        @Y@
=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            @Y?=q?=q@Y                                                                                                                                                                                                            @Y?=q?=q            ?=q                    @Y?=q                    ?=q?=q                        ?=q@Y?=q@G@
=A:H@
=AA}AA\  A:H@G@
=AA@G@
=@GA@G@Y@
=@
=A:HA:HA@G@GAA@
=A@G@G@G@GA@G@
=@
=@
=@GA@G@G@
=?=q    @Y?=q    @
=@Y@
=A:H@
=    ?=q@
=@
=@
=@G@
=?=q?=q?=q?=q@
=@
=@G@Y@Y    A@
=@G    ?=q    @
=A@Y    @Y?=q?=q            @
=?=q@Y@Y@
=@
=A@G@
=AA\  AA\  A}A=qAAAA}A=qAA\  AA:HA\  A\  A@Y@GA:H@GAA}A:HAA\  A}A:HA}A}A}AA}AA:HA\  A\  A\  A:HA@GA:HA:HA}A}A\  A}A}@
=A\  A}A:HA@GA:HAAA:HA:HA}AA@YA\  A:H@GAAA\  @
=A@G@YA}AA:HA\  @
=@YA@G@
=A\)AAA\  A:HA}A:HA\  A=qAAzAAA\)AA\)B*A}AAB"B	AzAAAA=qAA=qA=qAAA}AA@
=AAA:HA\  A:HA:H@GA@G@
=@
=@GA@Y@
=@Y?=q    ?=q?=q@Y?=q?=q?=q?=q@Y?=q@Y@
=?=q?=q?=q@
=    @Y@Y    ?=q?=q    @Y@Y    ?=q?=q        @Y@
=@GA\  A\)BAzAA?=q@Y    ?=qAA:HAA=qA\)AA\  A\  A:HA\)B	A\)AAA:HAA}A\  AA\  A\  A}A\  @G@
=?=q?=q@
=@Y@
=@
=@
=?=q@Y@
=@Y@
=@Y?=q?=q    @
=            @Y@Y?=q?=q?=q    ?=q@
=@Y@Y@Y@Y@
=@Y@Y@
=    ?=q@Y@
=@Y@Y        ?=q                                                                                                                                                                ?=q@
=@G@
=@GA:HA}A@G@G@G@GAAAAAA\  @
=@G?=q@
=@
=@Y@
=A@Y@Y@
=@Y@Y?=q?=q@
=@Y    ?=q    ?=q    @Y@Y@
=?=q@
=@Y    ?=q    ?=q?=q?=q@
=@
=@Y@G@
=@G@
=@GA@G@
=@
=@
=@G@Y@G@Y?=q@Y?=q?=q        ?=q?=q?=q    ?=q@Y@
=@
=@G@
=@Y@
=?=q@YA\  @
=@
=A@GA:HA@GAA\  A:H@
=A}@Y@GAA}A=qA\)A\)ABAAA\  AA}A}AAAAA@GA}A\  A:HAA:H@
=@G@G@G@
=@G@
=?=q@Y@
=@
=?=q@Y@Y@
=@G    @
=@Y@Y@
=AA@
=@
=?=q@Y@Y?=q            ?=q    ?=q    @Y?=q@
=A@G?=q    @
=@G@Y@
=@Y@YA@
=A\  A\  AA@GA:HA=qBA\)AB\)B\)BdHB\)B*B{B\B\B333B	AzA\)B\)B{ABBBTQAABBL
=BBAA=qA@GA}A=q@GA:HA:H@
=@
=AAA@G@G@G@Y@
=@
=@G@
=@G@
=A@
=A@GA@
=@
=@
=@
=A:H@
=?=q@Y@
=?=q@Y@Y@
=@
=A@
=A@Y@
=@G@YA:HA:HAB*A}@GA}@
=@Y@GAzA@GA@YAAAAAAAA?=q?=q@G@
=AA}A\  A\  AA=qAAAA=qAAA}A}A\  AAA}AA}A@
=@
=@
=@G@
=@G@Y@Y@
=@Y@Y?=q?=q?=q@Y@
=?=q@Y        @Y@Y@Y?=q@Y?=q?=q?=q?=q    ?=q@Y?=q    ?=q            ?=q@Y@Y@Y?=q?=q@Y                                        ?=q                                ?=q    ?=q        @Y@Y    @
=@GA@G@GAAA@
=@G@G@Y@
=@Y@Y@YA@
=@
=    ?=q@Y?=q@Y?=q?=q        ?=q?=q@Y    ?=q?=q?=q?=q?=q    ?=q?=q                            ?=q    ?=q    @Y?=q    ?=q?=q    ?=q                                            ?=q@Y?=q?=q            ?=q                                            @Y?=q@Y?=q@Y?=q@
=@Y@Y?=q@Y@
=@
=@G@G@
=@Y@Y@
=@Y@
=@G@G@Y@Y@G@G@Y?=q@Y@Y                        ?=q        ?=q                            ?=q?=q                                            ?=q                    ?=q    ?=q                            ?=q                                                                                                                ?=q?=q@Y?=q?=q    ?=q        ?=q@Y    @Y    ?=q@Y@
=@Y?=q@Y@Y@Y@YA@Y@
=@Y@
=@Y@Y?=q?=q    @G@Y?=q@
=@Y@Y@
=?=q@Y@Y    ?=q?=q                            @Y?=q@Y?=q?=q@Y    ?=q                    @Y    ?=q@Y@Y@Y@Y?=q    @
=@Y?=q        ?=q?=q@Y@
=@Y    @Y?=q@G@
=@
=A@G@G@G@
=@Y@G@
=?=q?=q@Y?=q@Y@Y?=q?=q@Y?=q        ?=q@Y@
=@Y?=q@
=@Y@G@Y@G@Y?=q@Y@G@Y@
=@G@
=    @
=@G@
=?=q@Y?=q@Y@
=@Y@Y@Y@Y        ?=q@Y@Y@
=@
=?=q@G@
=    ?=q?=q    ?=q        ?=q?=q@Y?=q?=q@
=@Y@Y    @G?=q@Y@G@
=@G@
=AAA:H@GA@
=@GAAAAzB{B;zB;zB*BB\)B\)BTQBAzAA}A:H@Y    @G@
=@Y@
=    @
=@Y?=q?=q?=q?=q?=q?=q?=q@Y?=q            ?=q?=q?=q?=q?=q@Y    ?=q?=q                    ?=q?=q                                                                                                        @Y    ?=q                            A:HA\  A}@
=    @Y                    ?=q@Y@G@GA:HAA\  AA}AA:HA@
=        ?=q            ?=q                                                                        ?=q?=q?=q    ?=q                                                                                                                                                                                                        @Y?=q?=q    @YA:H@Y@
=A@G@G@G@G@
=@GA@Y@Y@
=@G?=q@
=?=q?=q?=q                                ?=q                ?=q            ?=q    @Y@Y                    ?=q    @Y?=q?=q                                                                                            A@G@
=                    @Y@G@
=A\  AA}@G@
=@Y@Y?=q                @
=A@
=@YA@
=@GAA@G@
=?=q?=q    ?=q                                        ?=q    ?=q    ?=q                                                                                                ?=q@Y@G                                                                    ?=qA@
=@G?=q@YA:H@
=?=qA:HA\  A\  ?=q                        ?=q    ?=q?=q@Y@G@G@
=A@
=@
=@
=?=q    @Y            ?=q    ?=q                                                            ?=q                                                                                                                                ?=q?=q    @YA:HAA=qAzAA@Y?=q@Y?=q@GA}AA\  A=qA\  AzB{A:HB	BTQBL
=Bm(B*AA=qA=qAAA}A:HA\  A\  A@GAAAA@G@
=@G@
=A:HA:HAA@G@
=@Y@Y@Y@G@
=@
=@G?=q@
=@GA:H@Y@Y@Y@Y@
=?=q    ?=q?=q                                                                                            @Y@
=@
=@G                @
=@Y?=q@Y?=q    ?=q    @Y?=q        ?=q@Y        ?=q                    ?=q?=q@Y?=q@Y@GAA:HAA}A}A=qAA\  AA:H@G@Y@GA:HA:HA}A\  A:HAAA@Y@GAA@G@GA@YA@
=@Y@G@G@
=@Y    @G@
=@
=?=q?=q            ?=q?=q@Y    ?=q                                                ?=q            ?=q@
=@Y@G@GA\  A:HA:HA                @Y@Y@Y    @Y@Y@
=@GA:HA:HA\  AA\  A\  A}B	AzBB333B*B333BTQBCAzA\)AA}A=qBB	AAA=qAAAA\  AA:HA\  A\  AAB*B*B\)AzAABABB{B*BTQBCB333B{B*B	A\)A\)AA}AA=qAA=qB"AzB{AzB"B"AzAA\)BB*B{B	B{BB	B{AA=qA}A\  @G@GA:HAAA}A}AABB{B{B{B"B"B"B{AzAzB	B*B\)B*B	B"BB\)B	B"B"A\)A\)BB{BAB	B{BB{B{AA=qA}A:H?=q        ?=q@Y?=q?=q@
=@Y@Y        @G            ?=q?=q?=q@Y?=q@Y@Y@
=A?=q@
=@Y@
=@Y@Y@Y    @Y    ?=q    ?=q@Y@GA:HA@
=@
=@
=A@
=@
=@
=@YA:HA}A\  A}A\  @GA:HAA@G@GA}AA:HAAA=qAAA=qAA=qAB	AB;zBL
=B\Bm(Bm(B#BGBupBdHBdHB\BCBTQBm(BdHBTQB\B*AB*AA:HA\)A}A:H@
=AAA}A}AAA\  A:HA\  A:HAA\  A=qAA:HA@GA=qA\  A@
=A:HA\  AA\  AA}A}AAA}A\  A\  AA=qA=qA\)AAAA\)B"AB{B333A=q?=q@
=AA}AA}AAAA}A}A:HA}AA\  A\)AAAA\  A}A\)B	B{B*B;zB;zB*B*BL
=BL
=BpBdHB  B}RBdHB#BRBdHB333B;zBm(Bm(BRBpBTQB;zB;zBCB"B\)B"B\)B{BAA\)A=qA=qA\)AA\)AA=qAAA\  A:HAAA=qAB\)AzB"B*B{B	AAAA\)AB	AzAzB{AB	AzAA\  B	Az@GA:HAA\  A\  A}A}AAB333A\)BTQB\BdHB}RBRBupB}RBupBm(BupB  B}RB  BGB\BBBBBffB\BRB#BpBkBB\B
B
BGB  B3B{Bm(BCAzAAAB	BL
=B}RBTQBTQBTQBm(B}RBm(BTQBdHB  B#B  BupBm(BdHBTQB\B;zB\)B	B*AAA=qA:H@GAAB\)B333B{B{B"BCB\BupB*BTQB\)B\)BABB	B	BL
=B\B\)B"B*A\)A@G@GA}A=qBAA}AzBB\)B	Bm(B\BCA\)B"B"ABAzA\)B333B	B{B*B\)B"BTQB333BCB\B}RBGBGBGBGB#BpBRB)BpBm(B\BTQBCA\)A\)AAzA\)AzBB{B{B\)BCBTQBCB333B"B*B"B*B"B\)B\)B	B*B"B	B"B\)B{B\)BAA\)AA\)A\)B	B	AAzAAA=qB{A\)AA=qAAAzBB	B*B;zB;zBCBTQB*B\)B	B{B\)B{B{B{B{BCBm(B  B  BGB#B}RBupBTQBTQBCBm(BL
=B"B\)BCB333BL
=B{B"B\)B*B*B\)B	B{B333B"B"B333B"B\)B\)B"B\)B"B\)B\)B"B"B\)B{B"B\)B"B"B\)B{B"B333B*B"B\)BB	B{B	BABA\)A=qAA=qA=qA=qAA\)AA\)A=qAAAAA:HA=qA=qAA}A:HA\  @GAA\  A\  AAA=qA=qA\  AA}AAzB	AzBB"B	B*B*B*B333B333B333BL
=BTQBTQBm(BCBL
=B;zAB	A}A}AAA:H@GA}A:HA}AAA\  @GAA:HA:HAA=qAA\  AAAzAA\  AA\  A}A}A\)AAAAA=qAA}A\  A}A\  A\  A}AA:H@
=AA:HA\  AA\  @G@GAAA}A@GA:HAA\  AA=qA}A\  A\  AAAAAA=qA:HA=qB*@
=B{AA=qB333AA=qAA=qBA\)BB{B*B\)B{B\)A\)ABBCA=qB333B;zB;zB{B{AAAA}A}A}A}A}A:HA\  A}A\  A}AA@
=AA:HA@G@GA:HAAA:HA\  A:HA}A\  A}A\  AA\  A:HAA\  A@
=@G@
=AA\  @GA@
=@
=@Y@
=@Y@Y    ?=q?=q@
=@
=@
=?=q@Y@
=@Y?=q@YA@
=@Y@Y@G@GAA=qA\  A\  A\  @G@GAA\  A=qABB\)BB	B\)B\)B{AAAAAzB	AAAAAAA\  A\  A\  A:H@
=@
=@G?=q    @Y    ?=q                            ?=q?=q?=q    ?=q?=q            @Y                                        ?=q?=q        ?=q?=q?=q@YA@G@G@
=    ?=q@GAA\  A}@GA\  AA\  A:HA\  A?=qA@YAA:HA@
=A@G@
=A}A=qAAzAzAAAA\  AAA:HA:HA\  A\  A\  A\  AA:HA\  A:HA:H@
=@
=@
=@YA@G@Y?=q@Y@Y?=q@
=?=q@Y?=q@Y@Y?=q@Y@Y@Y@
=@Y@
=@
=@G@
=@G?=q@
=@GA@G@G?=q@
=@G@G@GA@G@GA@
=A@Y@G@
=@Y?=q@
=A@G@
=@
=@GA:HA:HA:H@
=A:H@G@Y@
=@GAA=qA}AAA=qA\)B{B*BCBCBdHBTQB\B{BCB\)BCBCB"B{BAB\)BAA=qAAAA\  A}A}A\  @G@G@GA:H@G?=q@Y@G@G@Y@
=@
=@Y@
=@
=@Y@
=@Y@G@
=?=q@Y@Y@
=@Y@
=A:HA@
=@G@G?=q@Y@Y@
=A@
=A@G@
=@G@GA:HA@GA:HA@
=A:HA:HA:HA}@GAA\  A\  AA}A}A\  AAA\)B\)BCB*ABABB"B*BdHB\BdHB}RB#BdHBm(B}RBdHBTQBCB"B333AA=qAAA}A\  A:HA\  A\  A:HA}AAAAA\  A=qA=qAAAA}A}AA}A\  A@
=@
=A@G@
=@G@G@Y@
=@GA\  A}AA}A\  A\  A\  @GAAA}A}A\  A=qA\)AAABL
=B#B333B	AA\  AA\  A\  A=qAAA}A\  A\  A:HA\  A}A:HA}AAAzB*BupB333B\B}RB}RBupBTQB*AzAzA@GAA}AA\  A:H@
=AA\  AAA\  A:HA}A}A\  AA\)A\)A\)A\)AA\)AzAAAzB\)BB	BBB\)B{B	AzAAzBB{A\)AzA\  A=qBB	B{B\)BAzAAAA\)AA=qAAAzAAAAAA\  AAA\)AAAA=qAAAAAA=qABBB\)AAAzB333B"B\B  B}RBm(B}RB  B}RB  BdHBL
=BTQB;zB*A\  AzBAB{B{B\)B{AA\)AAAAA}AAA\  A}A@G@GA:HA\  A}A}A}A:HA:HAAAA}A\  A\  A=qA\)B\)BBA\)AA\  AAAzAzAzAAzAA\)A=qAA\  AA\  A\  AA:HA\  A:HA:HAAA:HA:HA:HA@
=@GA:HA\  AAzAAzAzA=qB*AB333B"BTQB}RBm(B}RBdHBdHB"B"BCB*B333BupB#BTQBL
=B;zB	B333A\)BCB	AA\)AAAA}A:HAA}A\  AA:H@GA:HAAA\  A\  A\  AAAAA\  A:HA:HA:HAA:HA:HAA=qAAAAAA=qAAAAA\  A}AA:HA\  AAAA:HAA:HAA\  A@
=A=qAAA\)A=qA=qA}AA:HAA}AA:HAA=qA\  A\  A}A}AA}A:HA:HA}A\  B	A\)A}AA:H@GAA}AA:HA@GA}AAA}A\  A\  A\  A:HA:HA@GA\  @GAA@
=AA=qAA\  A\  AAB333B\AAABA=qAAA=qA=qA=qAzAA=qAA@
=AA\  A:HAAA\)AB	BBCB\)AB{BBAA\  AAA\)AB\BL
=B\)B{AzACJ#B\BѮB{AAA\  A}B	B{B;zBCB\BupB\BTQB	Bm(BCB333B;zB;zBCBCB	B\)B333BCB{BTQA=qAA=qAA}A=qA\)AAB"B*B333B;zB{B{B\)B	A\)B\)AA\)AAAAABBA\)AA=qAA\)A\)A=qAAAAA=qAzB{B	B	AzB*B	B\)B\)ABAAA\)A\)B{BB*B\A\)B"BL
=B;zBCB333BCB"B;zy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y B"BL
=AzBB	B\)AAA=qA=qA\  A:HA\  @G@
=@
=@
=@Y@Y?=q?=q@Y?=q@Y?=q                                    ?=q@Y?=qA@
=AA@Y?=q@Y?=q        @
=@
=@G@Y@YAA:H@
=@Y@
=@Y@YAA@
=@G@
=@
=@
=A@G    @Y    ?=q@
=AAA}@
=A}@GAA?=q?=q        ?=q    @Y@Y                            ?=q    @Y@Y@
=AAB\)A@
=A}A\  A:H@
=@GA:H@
=@G@G?=q    ?=q?=q    ?=q                                                ?=q                ?=q?=q?=q    @G@Y@
=@Y@Y@Y@
=@Y?=q@
=?=q?=q@
=@
=@
=@
=?=q?=q@Y@Y@
=AAA@
=            @Y@Y@GA:H@
=AA@Y@
=?=q@Y            ?=q@Y@Y                            @Y    @Y@
=@GAA}B{BBm(B	B	AA\  A}@GA@
=    ?=q        @Y?=q            @Y@Y    ?=q        ?=q@
=A:HA:H    ?=qA:HAAB*B333BAzA    @YA\  A:HA\  A}A:HA@
=@
=@Y?=q@Y?=q@Y@Y?=q?=q@
=?=q@Y@G@
=@G@
=?=q@G?=q@GA@
=A@
=AAA\  @GA@YA@Y@
=@
=@Y    @Y@G@
=@G@GA:HA:HA\  A\  BB	B	AB	A=qA=qA=qAA\  AA}AA}A\  @
=@
=@G@G@G@G@Y@Y@
=?=q?=q    @Y            ?=q?=q                    ?=q@Y@Y@Y@Y@Y@Y?=q    ?=q?=q@Y@
=@G@Y    ?=q@Y        ?=q?=q    @GA@
=@Y?=q@Y@Y?=q?=q                    ?=q?=q        ?=q                ?=q    ?=q    ?=q            @Y@Y@G@GAAA:HA}AAAAA\)A\)ABA\)AAAAAA=qAzAAA=q@G@
=?=q@
=@
=@Y?=q@Y?=q    ?=q@Y@G@G?=q        ?=q@Y@Y@
=@Y@
=@Y@G@
=A:HAA:HA:HAAAAB	AAAAA=qA}A}A:HA:HA:H@GA:HA:HA:H@G@GA:H@G@
=@
=    A:H@
=AA\  AA\  A\  AAA\  AAA:HA:HA\  AAAAAB{B{B	B;zBTQB333BTQBL
=B\B;zB;zBCBCBCBL
=BL
=BCB;zB333B*B"B\)B\)B"B*B333B;zB333B*B333B\)B\)B\)B{AzAzA\)A=qAzAAA\  AA}A}A}AAA\  A\  @G@GA:HAA:HAA:HA:HAAA\  A:HA}A:H@GA@G@GA@G@
=@
=@G@GAAA}AAA}AAAA\)AA\)BAzB\)BdHBupBdHB333B  B)B\B}RB3B͊=BkBkBGB3BkB\B#BGB}RBTQBupB\B333B{B	AzAA=qA=qA=qA=qAA}AA:H@GA:H@
=AAAA:H@G@
=@
=A@
=@GA@GAAA:HA=qA}AAA=qA\)AA}AAA=qAA=qBB333B333B	B333AAB{AA:HAAA:HAA:HA\  A:HA\  A}A\  A}A:HA:HA:HA}AA=qA=qAAA\)AzBB\)BzB"B;zBCBCBTQB;zB*B*B*B*B{B	BBAzBAAA\)AAAzAAAAA\  A}AA:HAA}A}AA}A:HAAA}A\)AB	B;zB{B*BB333B;zB333B	B	B{B	AAA:HA\  A}A\  @
=@
=A:HA@GA\  AAA:H@GAA:HA\  AzA=qA\  A\)AzAA=qAA=qAA=qB	AzAA\)A\)B*B	B\)B"B*B\B}RBRB)BGBBB
B
B
B)BGBpB#Bm(Bm(B\Bm(B\Bm(B}RB\BTQB;zB  B\AAAA@
=@
=?=q    @G@
=@
=@Y@
=@
=@YAAA=qAA\  A}AA}B"B	B;zB\B\B;zAAB{B	AA\)A\)AA@G@
=@Y?=q?=q?=q    ?=q?=qA:H@G?=q@
=    @Y?=qA:HA\  AAA=qA@G@
=@
=@GAAA\)A\)AzB	BAzBAB{BB	B\)B{B\)B"B{BB{B	AAAA=qA\)AAA=qAA}AAA}AAAAAA:HA\  A}A:HA\)AAAA=qAAzAzAA=qBB	AAzBAAAAAA}@GA:HA\  A\  A}A}A=qAA:H?=q@Y@
=?=q@Y?=q@
=@
=@
=@Y?=q?=q@
=@
=@Y@
=@G@G@
=@GAA\  A=qAAA}A=qA=qA=qA\)B\)B"B333BTQBdHB*BTQBL
=AzAAzAA\)A\)AAAA\)AAAAAA\  A}A:HA@Y@Y@Y@G@
=@
=@
=@
=@
=?=q@G    @
=@Y@GA:HA\  AA@G@Y@Y@
=@Y@
=@GA}A}A}AAAAA}AAA}A\  @
=    ?=q?=q@Y    @Y@G?=q?=q?=q@
=@
=@
=AAA@GAA:H@G@GA:HA\  A:H@GA:HA}AA=qAAABBB\)B;zBL
=BTQBm(Bm(B  BTQBCB333B*BCBL
=BL
=B333BL
=B333B;zBL
=BCB;zB;zB333B"B{AzB{A\)A\)A\  A:H@
=A:H@G@
=@Y@
=?=q        @Y@
=?=q?=q    ?=q@Y    @Y@Y@
=@Y@
=@
=@G@G@Y@
=@
=A:H@
=A:H@Y@
=?=q    @
=A\  AA\  AAAA\)AA\  AA:HA:HA}AAAAA:HAAAzAAB{BBB;zB*B*B	AAAB	AA\)AB\)B{B"BBAB	AzBAzBA\)AAA\)A\)A=qAAAA}A\  A:HAA:HA\  A}AAA\  A:HAA\  AA}A\  AA:HAAA}A\  A:H@GA@GA@G@G@G@G@
=A:H@GA:H@GA@GAA:HA}A\  A\  AA\  A:HA}AA:HA:HAAAA\  A:HAA}AA\  A=qA}A=qAAzBBAzAB{B333BCB\BTQB333B\BCB"B	AzBB;zAA}AA}AA\)AzA}A\  AB	B{B\)B{BB{B	AzAA\  AA@GAA:HA\  @
=A:H@
=@Y@
=@YA@G@
=A:HA:HAA:HA}A}AAAAAAAAAA}AAA}AA:H@GAA:H@GA:HA}A\  A:HAA\  AA@G@
=@
=@G@
=@YA:HAA:H@GAA:HA:HA:HA@YA@Y@G@GAA:HA@GAAAA:HA@
=@
=?=q@Y@
=@G@
=A@G@G@
=AA:HAAAA\)AAAA}A:HA\  A:HA:HAAA}AA=qAA}AAAAA=qAAAA:HA\  A\  A:HA:HA@G@GAA:HAAA}A@Y@G@Y@Y?=q@
=@
=?=q@Y?=q    @
=@Y@
=@
=@GAA@
=@Y@Y@
=@Y@GAABBB"B*BCBpBpB  B)B)B{BpBupBupBpB#B#BpB{BRBm(BTQB\)BAzAAAA:HA}A\  A:HA:HAA\)A\)AAA}A}@G@
=@
=AA\  A=qAAA}B*B{B"B	B\)B"B"B\)B	AB	B{B\)B	A\)AAA=qAA=qA}AA:HAA:HA=qA=qAAAA=qAB	B"B*B"B	A\)B	B	AAzA=qA\  AAA\)AAzA:HA=q@G@GA\  @
=A\  AA:HAA=qAB{B"AAA\  A\  A:HA}A:HAA:H@G@
=@GA:HAA@G@
=@
=@
=@Y@Y?=q?=q@Y?=q@
=@Y?=q@Y@Y@
=@Y@Y@Y@G@Y@Y@Y@
=@
=@Y?=q@Y    @
=@
=@Y?=q            ?=q?=q            ?=q    ?=q?=q?=q@Y@Y?=q@Y@
=@
=?=q@Y@Y@
=@Y@Y@Y@G@Y@
=@Y@
=@Y?=q@G@G?=q@Y    ?=q@Y@Y@Y?=q?=q?=q?=q?=q@Y@Y?=q@Y?=q    ?=q    ?=q    ?=q?=q            ?=q@Y        ?=q    ?=q                                                                    @Y                                    ?=q?=q@Y@
=@Y?=q?=q                ?=q                                ?=q        ?=q?=q    ?=q?=q    @Y@GA@G@
=A@GAA@
=@G@
=@
=@G@
=@
=@
=@G@
=?=q?=q?=q@G@Y            ?=q@Y@Y@
=@Y@YA@
=@
=@Y@
=@G@GA@G@Y@G@
=AA@G@GAA@G@Y@G@GA:HAAA\  A@Y@G@GAA@
=A:HAA@GA:HA\  A:H@
=@
=@Y@Y?=q@Y@Y@Y@
=@Y@
=@Y@G@
=@Y@Y@GAAA:HA:HAAA}AAA=qAAzB	B{B\)B*B*B;zB*B"B333B"B333B333B"B"B\)B\)B{AAzA=qAA\  AA}A}AAA}AAAA}A}AAA\)AA:HA}A}@GA\  A}A=qAA=qA}A=qAA=qA\  AAA:HA\  A:HA}AAAA\  AAA=qA=qAA:HAA@GA:HA:HAA\  AA:HA\  A\  A\  AA=qAA\)AAA}AAA\)AAzAB	AzA\)A=qABAAAB	B	AAA\)A\)A\)AA\)AAA\  A:HA:HA@GA:HA:HA\  A:HA:HA:HA@GAAA:H@G@G@G@
=A@
=A\  A\  AAAA=qAA}A}AAAAAA=qAAAA}A}AA\  AAAAAAAA=qA=qAAAAAA\  A}A\  AAAA}AA@G@GA:HA:HA\  AA:HA}A}@
=@GA}AAA=qA=qAAAA=qA}AA}AA\  A\  A\  A:HA:HA\  A}A:HA}A}A=qAAAAAA\  AA:H@G@GA@
=A@GAA:H@
=@G@G@G@
=@G@Y@
=@G@Y?=q        @Y@G@Y@
=@Y@
=?=q?=q    @Y?=q@
=@Y    ?=q?=q@Y@
=?=q    @
=@GA:HA:HA:HAA\  AAA:HA\  AAA:H@G@GAA}A:HA}AAA}A:HAAzBA\)AA\)A\)A\)AA\)AA\)AA=qAAAAAAAA=qA}A}A}A}AAA\)A\)AAAAAA}A:HA:HAA=qA\)AAAA:HA}A:HA\  A}A\)A}A:HA@
=?=q@Y@Y@Y@
=@GAA:H@GA:H@
=A@
=@GAA:HA:H@G@Y@GA@
=@
=@G@
=A\  A}AAAA@G@
=AAA@
=@G@
=@G@
=A\  A:H@
=A@
=A:HA\  A:HA\  AAzAzAAABBA\)AAAzBB	BBAAAzA\)A\  AAzA=qA}AA:HA\  A}AAAA\  A}A}AA:HA}A\  A}A\  A\  @Y@
=@G@Y@G@
=A:HA:HA\  AAAAA=qA\)AA}A}@GA:HA}AB"BCAA=qAAAAzAA}@GA@
=@G@G@GA:HAA}AA\)B	B\)B"B333B{B"B"AA\)A\)A=qA=qAB	B{BBABB	AA\)AzAA=qA=qAA}A}AAAA}@
=A@
=@
=@Y@GA:HA:HA}AAAA=qAAA:HA:HA@
=@G@GA@G@
=@
=@YAAA}A\  AAA}A\  @GA\  A=qA=qB\)AA=qB	A\)A\)A=qAA=qAA}AA\)AA=qAAAAA}A}AA=qAAAAAAAAAA=q@GA\  AA}AA=qAAzAzB{B{B\)AAA=qAAA}A}A\  AAA\  A@G@GA@G@Y@GA}A:HA:HA:HA}AA:HA:HA\  A\  A:HA\  A:HA\  AA}A\  A:HA:HA:HA\  A\  A}@GA\  A\  A}A}AA:HA\  A\  A\  A}A:HAAAAA\  A\  AA\  A\  AA\  AA\  A:HA}A:HA\  A\  A=qAB{AB	B	BAzBB{B333BTQB}RB#B  y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AAA\)A\)B	B"B\BdHBCB\B\B}RB#B333AB"AzAAA\)BTQB333BTQB;zB"B	AAAA}AA}AA:HA:HAA@
=@G@G@
=@GA\  A@GAA@GA}A}A}A}A}A}AA\)AA\)AA}A@G@
=@GA:HAA\)AAAA=qAAzAAAAAA\  A}A}A:HA:HA:HAAAAA:HAAzB	B{AzAA\)A\)A=qB333BCBTQBGBRBm(BdHB  BupBupBupBupBTQBTQBCB333B*B"BTQBm(A\)AAABAA=qAA\)A=qAA:HAA:HA@
=A:H@
=A@Y@GAA}A:HA:HA@G@GA:HA\  A}A=qAA=qAABB	AAAA}A\  A:HA}AAA:HA=qAA\  A}A\  AA\  A\  A}A@G@
=A@G@G@
=@
=A@Y@GAA:HAAABBB{B\)BB"B*B{B333B*B;zB\B\BL
=BB\)BTQBdHB;zB;zBL
=BdHB\)B{A\)ABAAAAAAA}A}AA\  AAA:HAA@GA@GA:HA}AA\)A\)A\  AA:HA=qA\)A\)BAzAzB{A=qAAAA\  AA\)A\)AAA}AA}A@GAA:H@
=A\  @G@GA}AAAAA}AA\  A}Ay y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y B"B;zBm(Bm(BGBpB#BpBGBGBkB)B#BGB  B\B
B3BGBBBBBGB
BpBdHB\B  B  Bm(B#BupBdHB\B{BdHBpBAAzA\)A\)B\)B	AB\)A=qABTQA\)Bm(B#B  BGB}RB  B  B}RB}RB\BTQB\B{BTQB333B\)A:HAA@
=A:HAAAA=qA\  AA\  AA=qA\)AAzAzBB	B	B{B\)B"BB	AzAA=qB;zB;zB\BupB}RBL
=BGBRBRBpB\BkBBB3BffBkB#BpBpBTQB;zBL
=B"AzB#BGBB  BTQABGB*B\)BRBTQB{B  BGB}RBCB333BupBCBpBm(B\B  B{B\BBBkBB
B#BRB  AAAA\  A\  A\  A\  A}A\  A:HA\  A}A@G@G@GA@YA:HA:HA\  A:HA=qA\  A=qAB*B333B{A\)ABBdHB	BL
=Bm(B  B}RBCB;zAzAB	BCB{B#B*BCB"AB*B{B{B\BupBupBL
=BB\)B"B}RBupBupBm(BGBm(BL
=A=qAAAAzBBA\)AB{B	B{B{B	B	AzAzAAAAAAAAA=qAAA=qA=qA=qAA\  A}AAAA\)A}@GA}A\  A}A}A}A}AAA=qAA\)AA=qB{A=qA\)A=qAzB"B\)BCBTQBCBL
=BCBupBm(BCBTQBTQBL
=B333BTQB;zBTQBTQBdHB#B;zB	AzBB	B"BB;zB\B*B;zBupB\B333B;zBCAzB{A\)AAzB*B\)B"BB{B*B333BL
=B\B333B*B{B;zB*B;zB*BCB333B*B"B{BB{B\)B	BAzBB{AzA\)AAAAAA\)AAAA\)A\)AA=qA=qA}AAABAzAAzB{B{BAAAAB{B;zBm(B#B{B)BGB{B)BGBkB#B3B  BGBm(B\BupB3BpBRBRBpBupBL
=B;zB{BupB#BupBm(BupBupB}RB#B#BL
=BL
=B  B\BCBCBCA@GA\  ABAAAAA=qBAA=qB{B	B*B;zB*BL
=B"B"B{A\)AAAAAAA}A:HA:HA}@
=@G@GAAA=qAAAA\  AAB	BAAA:HA\  A\  AAA=qAA\)BAA=qA\)BCB	B\BRBRBupB}RB}RB#B)BpB{B#B  B#B;zBCB{B"B;zB\)B;zB*AB	AB	A\)A=qA=qAAzAAAA:HA}A\)A}A\  A}A=qAA\  AA:HA\  AAAA}A=qAAAA=qAA:HA\  AA=qA=qAAA=qAAAAA:HA:H@YAAA:HA:HA}A}A:H@GA?=q@
=@GAB	B333BCB\)B"BTQB*B;zBL
=B\BdHB}RB#B)BpB{BupBm(BdHB*AABupBupBdHBTQB}RB\B\BCAzA=qAB{B;zB\)BB\)B{B{B"B333B;zBL
=B;zBCBCB\Bm(BL
=B	AABB"B\)B"B"B"B\)B"BB*B	BB	AAAA}AA}AB{AAB	AzAzB\)AzA\)AB\)A}ABAAA\)AA=qA\)AA=qAAAAA=qA}AA}A=qAAAAB{B\)B{B;zBm(BL
=BL
=B{B"BCBdHBdHB\BTQB}RBdHBCB;zB333B333A\)AAA:HA:HAAA@G@GA@GA@G@
=@
=A@G@
=@
=A\  AA:HAAA@G@
=@
=@G@G@
=@YAAA@G@GA:HA\  @GA:HA\  AA\  AA\  A\  A}AA}A}A=q@G@GA\  A\  AAA=qA=qAAA\)AB{B	B*B333B;zBCBTQBdHB}RBTQBm(BCB*BA=qB\B\)BupB)Bm(AA=qB{B	BdHBm(B\BCB*B"BL
=B\B\BTQBL
=BdHB\)B{B\)B	B333B;zB{B*B	B{B"AA=qAA=qAA}A\)A}AA\  A\  A}A:HA=qAB"B333A\)AA=q@
=@
=A@
=@GA@G@GA@G@
=A:HA@G@GAAA:HAAAAA=qAzAB*B{B	AAAAzBB"BdHB  B}RBL
=B}RB{BkB#BpB{B{BRB#Bm(B
BRBdHB#BkB  BGBB#BTQBm(B\B{B"AzAzAAA\)A\)AAAAAAAzBB	B{BBAAAAAA}AA=qAA=qAAA=qAA=qAA}AA\  AAA\  A:HAAAAA}AAA=qA=qAA=qA=qAA}AA}A\  AAAzB	B\)B333BCBdHBm(BL
=BCB}RBm(B}RB  B)B\BupB}RBGB#B}RBTQB;zB{B{BAB{B	B*B"B*B333B*B	B"B"B	BAB	BAAAzB	B	B	B"B\)B"BAAAzB{B"B{BCB333B*B"B\)B{B	B"B{B\)B"B"B\)B{AA=qAzAzAAA=qAA}AAA=qA=qAAAA=qAAA=qA\)ABAA}AA=qA\)A=qAA=qA\  A}A}AA=qAAAAA}A}A:HAA\  A}A}A\  AA:HAA}A}A=qA\)B"A\)AzAzAAAA}A\  AAA\  A\  A:HA\  A:HA\  A}AAA}A\  A}A\  A:HAA}A}A:HA}A\  A\  A:HA}A\  A=qAAA=qA}A:HA\  AA}A:HA=qA:HA\  AA}A\  A}A}A}A:HA:HAA}A=qA:H@
=@
=A@
=AA:HA:HA}A=qAzA:HA:HAAA:HA:HAAzBA\)B"@
=@
=AA@GB;zB}RBTQA\)A:HA:H@GA\  A@G@
=@
=A:HA@
=A:HA\  A}A\  A@
=@GA:HAA}AAA:HAA\  A=qAAB	A\)AA\)AAB	B	AzAzA\)AA\)AAAAAA}AAAAAAAAABAAAAA:HA:HA:HAAA=qA@Y?=q    ?=q@Y@YA:HA:HA}A=qBCBdHB  B	AzB)?=q        A\  B	BRBBBBCA=qB*BL
=B\BdHBTQB  BupB\B"AzA\  @G@G@
=@GAAA:H@G@
=@
=AA:HAAAAAABAA=qAA:HA}A\  A=qAA\)A\)B	B	B	A\)AA=qA\)A\  A\  A\)A@GA@
=A}@GAA\)A\  @Y?=q    @
=@G@
=A:HA}ABB{BB{B{B	B	B"B;zB*B*BTQB\B\BTQB*B@YA\  A@
=AAB;zAzB*B{B*B\)AB\BCB;zB{B\)    ?=q@Y@Y?=q@Y@Y@
=    @Y?=q    ?=q?=q    ?=q?=q?=q                                                                        ?=q            ?=q    @
=AA}A:HAA\)A}AA\)AAB*B\)AB\)A=q@
=@G@
=@
=@G@
=A@GA:HABL
=B;zB{B"AzA\)BCB*A\)B{A\)AzB"B{B"BTQB\)A\)A\)AB*B\BdHB\BL
=B\B333AAzAzB\)AA\)A=qAA\  A\  A}AA}A\  A:HA\  A:H@
=@G@GA\  A\  A:HA=qAA\  A}A\  @
=@
=A}AAzAzAzA=qAAA=qA=qAAAA}AA:HAA:HA}AAABB{B{B;zB;zBdHB\BL
=Bm(ABTQAAA\)AA}AA\  A}A}A\)BB{AzAAA\  @YAB	A\)AAzAAAA\)AAzA\)A\)AzBB	B\)B	A=qA=qA:HAAAB{ABB	AzAAA\)A\)AA\)AAzAzAzAAAAAAAA}AAAAAAAAAAAAA}A\  AA:HAA\  A}A}A}A:HA:HA:HA\  A:HAA}A:H@
=A:HA:HA\  A}A\  A\  A\  A\  A\  A\  A}A:H@
=A}A\)ABTQB	BdHB  B#BGB)BGB#B3B\B}R?=qA:HA:HB  BpBRBpB{B{B{B\B	BL
=BTQB\B"B333AB"B{B{B	B	AzAAAA=qAA:HAA\  A}A\  A:HA\  AA=qAzA=qAA\  A}AA}AAAA\  A\  A:HA}A\  AA=qAA=qA=qAAA\  A@G@GAA\  A}AA\  AAA}A:HAAB333A=qAzAzA}AA\  A\  A\  AA=qA=qA=qA=qA@
=?=q@Y@YA\  AA:HAAA}AAAA:HA\  A\  A=qB\)BL
=BTQBCBdHB	AAAzB	AAzAzAzAzA=qA}AzBA\  AzAB{AzAzA}@GAA}A\  AA:HAA\  AA}AAA\)A\)AB	AA}A:H@
=@G@Y@YA\  A:HA}AzA=qAA\  A\  A\  AA\)A=qAAzB*B;zBB*B	B\)B{A\  @GA:HAA:HA\  A:HA:HA:HA:HA}A}AA}A:H@GAA@Y@G@
=@Y@
=@G@GA\  A}AAA\  A}AA\  @
=AA@GA:H@GAA\  @GAA}A\)AB"BTQB\B\BGBL
=B;zB	B{AAzAAAABAAA}A}A\  A:HAAA\)AAAAA}AAA}AA@GA:HA:HA:HA\  @G@
=@G@
=A:HAA:HAA\  A\  AA\  A}y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AAAzBCBm(A=qAA}AA\  A:HA}@
=?=q@Y@G@
=@Y@Y    ?=q@
=A?=q@G@G?=q?=q@G@
=    ?=q?=q?=qAAB	BCBdHB"BCBm(BL
=AB\B*B*B"B333B	A:HA@YA:HA:H    @Y@YAAB	AAAA=qA=q@
=A\)@GB	BAA=qAAA:H@G@Y@G        @
=A:HAAAB	B{B*B{B{B*BL
=BdHB\)B\)B*BL
=B{Bm(B}RBGB)B)BB
B\BkB{BRBGBGB{B{B  B\BupB*BL
=B333B"B*AzA\)A:H@
=A@
=AA@G@GAA\  AA\  A:H@
=@YA:HA:HAAA:H@G    @GAAzAzB"B	A\)AA=qAA@
=@
=@G@GA@
=@G@
=?=q@
=    ?=q                                @
=@G@YA}AA=qB{AA\)B\)B333BTQABBBm(B	B#B#B
B)BA\  AzBL
=B{B\A\)Bm(B*BL
=Bm(B\)B;zBB333AB}RBGBm(BGB  B*B333B\)AzAA}A}AA\  A\)ABAB	B\)AAAAA:HA}AB	AzA\)AA}AB	AAzAAA}A\  AzAA=qA:HA:HA=qA}AAAAAAAA=qA:HA:HAA\  AA:HA:HAB	AAB	A=qAAAABL
=B"B333B	A}A:HA=qA\  @YAA\  A}@
=AA\)AAAzA\)A\)BABBB333AzB	AzBTQBCB\)B  B}RBdHBTQB\B{B;zB;zBpAzAB;zB\BdHB#AA@GA\  AA}A:HA}A\  A:HAAA=qAAAAA=qA\)A=qB{BB\BupB\BpB#Bm(B#B{BupB}RBѮCBB{C	CCC&3BaHBCAAB*B{B;zB  BRBdHBpB  B  BGB*B}RBupB*Bm(B333BCAzB*B*B	B"B*BA\)B333BCBB\)B{B*BTQBAzB{B333B{B  B#Bm(BpB3BpB}RBupA\)B\)B\BCBupB	AzB*BAzB333B\AA}AAAAB	B\)B
BaHBCC	BCBaHBC BBB{BBBCB{BB͊=BffB{B3BRB#B\BBGCB=qBCB=qBB8RBffBGBRB  BdHB}RB  BGBdHB)BBm(BupB{Bm(B}RB;zB\BCBB  B\B
BBBBBBB\ABTQ@YBL
=B\BdHAA=qA\  A:HA}A\  A}A}@GA:HA\  A}AA\  @GA\  AAA\)BTQAAzA\  B#@
=AAAA}A:HAA@G@
=@YA@
=@
=@
=@GA\  @GAAA\  A\  BBBL
=B{B\)B"AA}A=qAAzA}A\  A}A\  AA=qAAA:HA\  A\  @GA@
=@G@YBupBB#B#BGy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AABA\)AA\)AABB\)B	B*ABB	BA\)B{B\)B"B	B333B	B*B	AA\)B	A=qAAA:HA\  @G@
=@
=@
=@G@
=@
=?=q@
=@
=@Y@
=@Y@Y?=q@Y@Y?=q?=q?=q@Y?=q?=q@
=    ?=q@
=@Y@Y@Y    ?=q@
=@
=@
=@
=?=q@Y@
=@YA@GAA\  A}AAA:HA:H@
=@G@Y?=q                    ?=q                @
=@YA}BB\)B333B;zB"BL
=BB;zB{BCBB{BL
=B	A\  A@
=@Y?=q@G@Y@
=@G@
=A:HAA\  @G@Y@Y        @G@
=@G@G@
=?=q@GAA:HA\  AA:HA:H@
=@GA:H@
=@G@G@GA@G@
=A:H@Y?=q@YAA?=q        @Y?=q?=q@
=?=q@GA@G@
=?=qA\  AAA=qBB	BB*BpB  BpBGB{BpB{B#B  B  A=qB}RBpBpB#BRB\BL
=B{AzAA\  @
=@YAA    ?=q    ?=q@Y@
=@Y    ?=q?=q@
=@GABBBB*B{B	ABpB333B#B#B}RB"B;zAzABA\)A:HAzA\)A}AA:H@YAA@G@YAA=qAA=qBA\)BB	BB333B*B;zB;zB333B333B"B*B*B333B*B\)BAzBB{B{B\)B{B{B	B\)B{B	B\)B	AzA\)AAAA\  AA}AAzA=qA}A}AAAAA}A=qAAA\)AzBA\)AAAAA=qAA=qAAA=qA\  A}A}AA}AAAAA:HA\  @YA}AA\  AzAB333BCB\B;zBdHB}RBGBGBRB  B\B\B#B#B{B{B)B  B  B{B)BpB  B\B  BL
=BCB*B\)AzAzA\)A@
=@YA}A\)A=qAAA=qAAA@GA\  A}AAAAA=qBAzAB{B	B\)B"B\)B\)BAzAzBA:HA@Y@
=AA@
=A:HA\  @Y@
=@GA}AA=qAzABB{AzABA\)AAAAAAzB;zB{B333BL
=B#B333B\B)B\BGB)B)B)B"B  BCBCB"Bm(B"B}RB{@G@
=A:HA@Y@YAAAAA}AA\)A=qA=qA=qAAA}A}A}A=qA@YA:H@
=AA:HAA}A}AA:HA:HAA}A}A=qA}A\  A:HAA:HA:H@
=A@Y@GA}A:HABA\  AzAAB*B333BCBL
=B;zBm(Bm(BdHBGB}RBTQBm(BTQBdHBdHB#BL
=B"BL
=BTQBupBTQBm(B}RB\)B	BAA\  AAAA@G@
=@
=A}A}A}A=qBA\  A:H@
=@
=?=q            ?=q@Y@
=@G@GA@GA@YAA=qAAAA}A=qA=qBB\)AA=qA}B	AA\)A:HA\)BAzA\)A=qAB	BB"B\)A\)BL
=BTQB;zBm(BTQB  B}RB  B)BRBpBpB}RB}RB}RBGB{B#B	B"B333AzBB{AA=qA=qA=qAA}A}BA\)B333A\)B  BGBTQB{B#B*B;zB333B{B;zB*B;zB*B;zB\)B{B"B;zB333B{B;zB;zAA\)B*AA=qAA}A}A}A:HA}A\  A:HAA\  A:HA\)A\)AzB;zB"B\)B{B333BCBTQBGB{Bm(B}RB  BdHB;zBCBL
=B333B\)B"BBAAAAzB{B"B\)A\)BB	AB\)AA}AAAAA=qAA}A}A:HA}@GAA}A=qA\)AAAABAzBB	B{AAA=qA\  AAA}A\  A}A}A\  @
=@GA:H@
=@GA:HA\  A@G@GABA=qA\)AA=qA\)AA\)AA\)AzB\)B333B;zB;zB\)B{BBdHBdHBdHAA\)A=qAAB	A@Y@Y@Y@Y@
=@G@GA\  @GA:HA@Y@
=@GA@G@Y@
=@Y@
=?=q@
=@
=?=q@Y?=q    @Y                    ?=q    ?=q            @Y@Y@
=@G@G@
=A\  AA:H@Y@G@GA@
=A:HA}A}AB{AzAzAzB;zBA\)AA}B  BCB*B\ABTQB\BL
=BdHBupB\B*A\)AAAAA\  AA}AA\  @GA:HA@G@G@G@
=@Y@G@
=A:HA:HA:HAA\  A}A:HA\  A\  A@YA:H@GA}AA}A\  A:HA:H@G@G@Y@Y?=q@Y@Y            ?=q    ?=q        @Y    @Y    @G@GA\  AAAzB	B"B\)B\)B"B{B;zB;zBCBdHBupBdHBGBupB"B"BupBB\)B;zB333AzBA\)AA=qAzB	BCBB	AAzA=qA\)AA:HA\  A\  AA:HA\  @
=AAA:HA\  AA\  A:HA\  A}A}A}A}A=qA=qAAAA\  A\  A:HA\  @G@G@Y?=q?=q            @Y    ?=q?=q    ?=q        @Y    @Y@G?=qA}A}@GA:HA\  AAAAAB{B333B;zB\B#BRBkBupB\BkB;zBCBCBCAAA\  A:HAA\  AA}AA\)A}@G@G@Y@Y@Y@Y?=q@Y?=q?=q?=qA@
=@
=A:H@
=@G@G@G@G@G@
=A@G@G@
=?=q@
=@
=@G@
=@G@G@GA@
=@
=@Y    ?=q?=q    @YA@G@
=@Y@YAA:HA:HA    @G@
=A?=qABB{BAzAzB	AzABB"BTQB}RB#B  B  B#B}RBdHA\)AB{B{A}ABpA=qB\)AB"A\)A=qA=qA=qAA\)AAAA}A}AA:HA\  A}A:HAAAA\)A=qAzAAA=qB	BAA=qAA\)A}A\  AA\  AA:HA:HAA@G@GA@G@
=@G@G@G@YA:H@
=@Y@Y@
=A@
=@Y?=q?=q@
=@Y@
=@GAAA@
=A:HA:HA}A}A}A\  AAA=qA=qAAzB;zBL
=BupB}RB}RBm(Bm(B#BupBdHBm(B{B{B"BCB\)B333B*BBB	AAA=qAA}@Y@Y@
=@GA@
=@
=A:HA@YA@Y@Y@Y@G?=qB\)A}AzBBL
=B*B\)A}BAB	B\)B\)BCB\)AzAzA=qAA\  AAzA}A=qA}A:H@G@G@GA@
=@GAAAB333B333B\)B	B\)A\)AB"B{B}RB\B\BdHBL
=B*B"BkB\)B\BRBCAzB=qB͊=BupB333BL
=B"B\)A\)AAAAA}AAAAAAAA}AA\  A:HA}A:HA:HA}A\  A}A:HA}A\  AAA\  A=qAAAA\  AA:HA@
=@
=@Y@Y@GA@Y@
=@G@
=@
=?=qABAzB	AzBB"BCBTQBTQB\B\BupB}RB{B{BpB{B333B"B;zBTQB\BCBCBCB*B"B\)B	B"B	AzAAA=qA=qAA:HAAA}A:H@GA}A\  A}AA\  A}A\  AA}AA:HAA=qAA\  A\  A:HA\  A\  AAA}A}A\  AA}A\  A@
=A@Y@
=@YA}@GAAA:HA}AA}B	B\)BCB\BL
=B}RB#B}RB#BupB;zB333B;zB;zBCB;zB333B\B{B{AzAzBBB	AzAzA\)AAAAAAA}A\  A}AA=qAA:HAAAAAAA=qA\)AAAAAA\)AAA\)AA=qA\)A}A\  A:HAAA}A\  @G@Y@
=@
=@
=@Y@GA@G@
=A:HA:HA=qAzAAzAAzAAAA\)A=qA=qA=qAA}A\  A\  @G@GAA@G@
=@
=@Y@G@GA@G@G@
=@YAA:HAA:H@GA:HA@
=@G@G@G@
=@
=@
=@Y@GA:H@
=A@
=@Y@G@G@
=@
=@
=@
=@
=@Y?=q?=q@Y@
=A:HAA@Y@
=@G@
=@G@G@GA:HAA\  A:HA\  AAAAAA=qAA=qBB{BA\)A\)A=qA}AA\  A=qAA:H@GAAA\  @
=@G@GA@GAA@G@
=AA@G@
=@G@GA@
=@G@G@
=@Y@G@G@Y@Y@
=@G@Y@Y@
=@Y@
=?=q@Y@
=@
=?=q@
=?=q@
=@
=@GA@GA:HA:HAA\  A@
=A:HAAA:HAA}A}A\  A\  A}AAAA}A\)AAAA}AA:HA:HAA\  @
=A\  @YA@YAAA\  AAAAA@
=A@
=@Y@Y@G@G@G@Y@
=@
=@Y?=q@
=?=q@
=@
=@
=@
=@
=@
=@Y@
=@Y@
=?=q@
=@Y@Y?=q            @Y    ?=q?=q@
=?=q@Y@
=A:H@
=@G@
=AAAA}AA=qBA\)AB\)B{B333B\)B\)A=qB*B*BL
=B\)B*B333B*A=qB;zB{B	A}AzAAAA}A\  @G@GA:HAAAAA@GA\  A}A}A}A:HA\  A\  A}A:HA\  A:HA@
=@
=@Y?=q@Y@Y?=q@Y@Y@
=@
=A@Y@Y@GA:HA\  A}@
=AAAA\  AA}A:HA:HA:HAAA\)B{BB{B"B{B333B"B"B"B	B\)AAAAAA\)AA=qAAA\  AA}A}AA:HAAA\  AAAAA}A}AA=qA=qA=qAAAA=qA=qAAAA\  A}A:HA:HA\  A:HAAA:H@
=@
=AAA:HA\  A\  A@Y@GA@G@GAA\)AA\)BAB	B\)B	B{A\)A=qA\)AA}A\  @G@Y@
=AA}@GA@GAAA}A}A\  A\  A:HAA=qAAA:HA\  A:HA\  A:HA\  A\  A\  A\  A\  AAA}AA\  @GA:HA:HA}A\  @GA\  AA@
=@Y?=q@
=@
=@
=@GA:HA@GA\  A\  B"B"BCBTQB\BTQBL
=BCB;zBCBCBTQBL
=BL
=B#BupAzAA:HA\  AA@GA@G@GA:HA\  A}A\)AAAAAA=qA}AAA}BAA=qA\)A\)AzB	A:HA:HAA=qA=qAA}A}A\  AA\  A\  AA=qA=qAA\)AA\)AzA\)A=qAA\)A\  AAABTQBupBTQBCBdHBupBupBdHB;zB	BAzA=qA=qA\)A=qAA=qA}AA=qAA\)BABB"B\)B	BB;zBL
=B{B{B{BB	B{A\)A=qAB{AAzAAzAAAB{BAA\)A=qAA=qAAA=qAA}A}AAAA=qAAA}AAAA:H@
=@G@
=@GA:HAAAAA}A=qAzB{A\)AzA=qBAB{B{B	AA}A\  A\  A\)AzB{AzAAA=qA\)AAA}A\  A}@
=A\  @G@
=@
=?=q@Y@
=@Y@
=?=q?=q@Y@Y?=q@
=@
=@
=@YAA:H@GA\  @GA:HAA}A}A}A:HA\  A@GA\  A:HA:HAAAA}AA}A:HAA@
=A\  A@G@Y@G@GA:HA}AAAzB{B;zBGB}RB)B{BRBRB#B)BpB  B)B  Bm(BdHB\BdHBAB	AA\)AAAAzA\)AA=qA=qAA\  AAA}A=qAABB\)BAzB\)AB{AA\)AAAA:HA@
=@G@
=@Y@
=    @GA@G@
=?=q@G@
=@G?=q@
=@
=@Y@Y@Y@GAA:HA}A=qAA=qB	B\)B	B"B	AzBCB;zBCBCB\B  BL
=BupB\BdHBTQB333B;zBCBdHB  B\BL
=BCB333A\)B"BB"B	B333BL
=B333B*B"AB	AA\)AA=qAAA\  A}A\  A:HA@
=@
=@GAA:HAAA@G@
=A\  A}A\  A\  AA=qAAAA=qAAA}@GA:HA}AA\  A:HA:HA}@
=A:HAA\  AAAA}A\  A\)AB\)B333BGB\Bm(BupBm(BdHB}RB  BpBpBGB  BupBupBdHBL
=BTQBCB*B"B"B\)A\)AA=qA=qA\)AzAAA\)AAA\)A\)B*B333B\BTQB;zB{B*B333B"A\)AzA\)AzAzB{B{B\)B{B\)B	B	A\)A\)A\)AAA:HA\  A:HA@
=B	B	B{B{BB	B\)B\)B"B"B333B"B\)B\)B*B"B333B\)B*B"B"B\)B{B\)B	A=qA=qA=qAAAA\)AAAA}A}AAAA\)A\)A\)ABAzB{BBBB	BBBAzBAAA=qAAAA\)AzAA=qAA}AA\  A:HA}A\  A\  AAAA=qAA}A:HAA}AAA\)AzAzBBB{B\)B*B333B*B333B\)B{B*B*B\B"BCBdHBTQBTQB*BTQBCB"B	BTQB"B;zB\)BL
=B*B"B"BABAAAA=qAAA}A}AAA\  AA\  A=qA=qAzAzABBAAAAA\)A=qA:H@Y@
=AA:HAA:HA:HA:HA\  A\  A}A@GA\  @
=A@GA\  AA\  AA:H@GA:HA}AA\)BBB\)B*B*BCBCB\B\B\Bm(BTQB}RB#B}RBdHB}RB  BupBm(B;zB333B\)B{B{BAzAA=qA}AA\  A:HAA:H@
=@
=@G?=q@Y@Y@Y@YA:HA\  A}AA@
=@Y@GA\  AA:H@GA\  A}AAAA=qAA}AAA@GA@GA:HA}AA\  AA=qAA\  A}A}AA=qAAzB{B;zB;zB;zB"B"BL
=B\)BB{B\)B	B\)BTQBL
=B*BL
=B\B;zBdHB\B\Bm(Bm(B\B\BdHBL
=B\B333A=qA=qB*AzA:HAAA\)BCB	AB	AABBBAAzAAA=qA\)B\)B	AzABAA\)AA\)AAA=qA\  AAAA:HA\  A:HA\  A\  A}A:HAA}AA:HA:HAAA\  A=qAA\  AA=qAAAA\)A}A:HA:HA}A\  A}A:HAA\  A}A\  A}A=qA}A}A:HA}A\  AAAAA=qAAAAA}AA:HA:HA\  A\  A@GAA?=q@
=@
=?=q    @
=@Y@Y@Y?=q@
=@Y@
=A@G@
=@
=    @Y@
=@Y@
=@Y@
=@Y@
=@
=@
=@Y@Y@Y@
=@
=@
=@Y@
=@G?=q@
=@Y@Y@Y@
=@
=@
=@
=@Y?=q@
=@Y@Y?=q?=q?=q                @YA@Y@GAA\  AAAA=q@GAAA@
=@GAAA\  A:HAA\)A=qAAA@
=@G@
=@Y@
=@
=@Y@
=?=q                    ?=q?=q?=q                        ?=q?=q                        ?=q@Y    A@GA:HAAA}A}AAA\)AAAAAAAAA\)A\)AAAAAA\)AAA}A\  A@Y@Y?=qA:HAA@G@
=@GA@GA}@
=A@Y@G?=q?=q    ?=q@Y@Y@
=@Y@G@GAA:HA}AAAA\)B\)B\)AzABB"B\)B\)BA\)AzA\)AzA@
=AA:HAAAA:HAA@
=?=q@Y@YA@Y@GAAA=qA\)AzB	B{BB{B{B	BB	B"B{B	B{B	B	A@
=@
=@
=@GA=qAA\)AABB{BBB	A=qA=qA\)AA=qA=qAAAAA\  A:HA\  @GA@G@
=@Y@
=@Y@
=AAA=qA\)AAA\)A\)AzA\)AzAA=qA=qA}A}A}AAA:HAA@GAA:HA@G@G@G@Y    @
=@G@G@Y@Y@Y    @Y    ?=q@Y?=q                ?=q                @GAB"BAAB	B"B\)B"B	B\)AzBB;zAAA=qA=qA=qAA=q@
=@Y@
=?=q        ?=q    @
=@
=@
=@Y?=qAA}AA\)ABAzAzBAAzAzAzAAAA=qAAAAA=qA=qAAA=qAA=qAA@
=AAAA\)AA\  A:HA:HA:HA}A:HA\  AAA:H@G@GA\  A\  A}@GAA}A\)AA=qAA}A}A}A}A\  AA:H@G@GA}A:HA}AAA=qAA=qA}A\  AA=qAA=qA}AAAA=qA\)B	A\)B\)AABB\)B\)B*B333BL
=BL
=BCB;zBL
=B;zBL
=B"B;zB{B*B	B*B\)B{B"B"B;zB*B*B	B{AA=qA\)A\)AAzAAzB\)B333B"B"BAzBAzBL
=BB	BBAA\)A=qAAAAAA=qAAA=qA=qA}AAA=qA}A:HA}A}A}A}AAAAA}AAAA\  AAAA:HAAAA:HAA\  A}A:HA}AA:HA\  A:HA\  AA\  A=qA=qAA=qAA\)AAzBB\)A\)A=qAAABAA\)AA=qAA}A}AA\  A:HA\  AA:HA:H@GA@
=@
=@
=A:H@Y@
=@Y@GA@GA\  AA\  AA}AA\  AA=qA=qA=q@GA:HA\  A}A}AAAAAA:H?=q@
=A}AA:HA:HA}@G@
=@Y@Y@Y?=q@G@Y    ?=q?=q@
=@Y@G@GA:H@
=@GA}A:HAA:HA\  A}AA}AA}A=qAA}A}A=qAAAAA=qA=qAA=qAA=qAAA=qAA=qAAAA:HAA}AA\  AAA\)AA}A}AAA}A=qA}A:HAAAAA\  A=qAAAAA\)A}A\  A:HA}A:HA@
=A\  A}A\  A:HAAA}A:HA:H@Y?=q@G?=q?=q?=q?=q@Y?=q@
=@Y@
=@G@GA:H?=q?=q@G@Y@
=@G@
=@GAA:HA:HA\  A\  A}A}AA=qA}A}AA=qAA=qA=qAAAA\)AA\)AAAAA}AA\  A:HA}A=qAA=qAA}A}A}A@G@GA:HA:HA}A\  A\  A\  A}A\  A\  A}AAAAAA}AAA}A\  A}A}A}A}A:HA:HAA}A\  A\  @GA:H@YA@GAA@
=@GA}A:HA}AA:HA:HAAA:H@G@G@
=@GA\  A@GA@GAAAAA\)A\)B	AzBBB{AzAzB{B	B	B{A\)B{BA\)AAzBAzB	AzAAAAA=qA}A}AA=qA=qA\  @GA:HA=qA}AAAAA}A\  A}A}A}A}AA:HA}A\  A}A:HA}A:HA\  A\  A@Y@
=@G@GA@GA\  A:HA:H@
=A}A}@
=@
=@
=A}@G@G@G@
=A:HAA=qAA:HA:HA\  A:HA\)A}A}AA=qAAzAzAB{B	B\)B	B{B	B\)B"B	B\)B{B*A\)AzBABB{AzB{B{AAzA=qA}A:H@G@
=A:H@G@GAA}A\  A\  A=qAA=qAA=qAAAAA}A}A}AA}A}AA}AA}A}A\  A\  A}A\  A\  A:HA:HA:HAAA\  A}AA\  AAA\  AAA=qAAA}AAAA=qAzAAzAzA=qB;zBL
=BTQB;zB{B*BB333BL
=B333B;zB*B*B333B;zBL
=BL
=BL
=BdHBL
=BTQBTQBL
=BTQB*B{AzAAzAAAzA\)A\)A\)A\)A=qAAAA\)AAAAA=qBAzAzA\)A\)AA=qAAAA}AA\  @
=@G@Y@
=@G@Y@
=@G@
=@G@G@GAAAA}A}AAAA=qA=qA}A:HA\  A}A@
=A}AAAAA}A\)A\)AAzBA\)A\)B{B{AA=qA=qA=qA=qAAA\)AAA:HA}A\  A}A@G@
=A:HAA=qA\)A\)A\)AAAA=qAAA\)A:HAAA\  AAA\  AAAAAA}AA\)AzA\)A\)AA\)AAA}A@G@GA:HAA\  A\  A\  AAAA:HAA:HA:HA:HAAAAA}AA}AA:HAA:HA:HA:HAA\  @GA=qA=qA\  AAAAzB	BAAAAAA\)A\)A\)B	AzB*B*AzB	B333B\)B{AB\)B\)B	B"B\)B{B{AzBB	A\)AAAzA\)AAAA=qAAAAAAA}AAAAAA}A:HA\  A\  AAA:HAA:H@G@GA:H@
=AAAA@G@G@
=AA\  A:HAA=qA}AAA\  A}A\)A:HA}A=qAAA}A}A\  AA:HA\  A\  AA:HAAA\  AABB\)B"B*B;zB;zB"B"B	BB{BAAAAB	AA\)A\)AAzAAAA=qA}AAAA=qA\  A}AA=qA\  A}A:HA:HA\  A:HAAA:HA:HAA:HA:H@GAAA:HA\  A\  A\  @GA:H@G@G@
=@GA:HA@
=@
=@
=@
=@Y@Y@
=@GAA@G@Y    @
=?=q?=q@
=@Y?=q@
=AA\  A:HAA:HA}A\)AAzAAzB	BB\)B	BAAzBBAA\)A\)AAzBAAAAAAzAzAzAAA\)AAzBAzA\)A\)BAzAA=qAAAAA=qAA=qAA=qA\  A\  AA:HA:HA:HA}A}AA:HA:HAA}A}A:HA:HA:HAAA:HA@G@
=A@
=@G@Y@
=@
=@
=@
=@G@GA\  @G@G@
=AA:HA@GA\  AA=qAA}A=qA:HA\)AA\)BAzA\)B{B{AzAzAAAA\)A=qAAA\)AAA\)A\)AA\)AAAAAA\)AA=qA\)AAA}AA\  AA:HA\  A:HA\  A\  A\  A:HA:HAA:HA:HA\  A\  AA}A}A:H@GA:H@GA:HA:HA}A:H@GA@GA@
=@Y@Y?=q?=q?=q@
=@G@Y?=q@G@
=A\  AAA:H@GAAA:HA:HA:HA\  A:HA\  A\  A=qAzAzAzBBAzA\)B	A\)AAAAA\)AzAzA\)AB	BBA\)AA=qAA\)A=qA:HA}A=qA}A\  A:H@Y?=q    ?=q@Y@Y    A:H?=qA    @
=    @G@Y?=q@Y    ?=q            ?=q?=q?=q    @Y?=q    @Y?=q?=q?=q?=q    @Y                ?=q    ?=q                @Y?=q?=q?=q    ?=q@Y?=q    @Y@Y        ?=q?=q@Y?=q@Y@G@Y@Y@GA\  A}A\  A}A}AA}A}AA\  @G@GAAAA@
=AA:H@G@G@G@G?=q@YA@
=@
=@
=@G@Y@Y@Y@Y@Y@
=@
=@Y@Y?=q@Y@
=@Y@
=@GA:HA@G@Y@Y@
=@
=A@Y@Y@Y?=q@G@Y    @
=@Y@
=?=q@G@G@G@Y?=q    @Y?=q?=q                @Y    ?=q                        @
=A@
=@GAA\  AAAA=qA}A\  A}A:HA\  A:HA\  A:HAA:H@Y@
=A:HA}A}A@
=@Y?=q?=q@G@Y?=q@YA@Y?=q@Y@
=?=q@
=@
=@Y@
=@Y@GA:H@
=@
=?=q@
=@G@
=@G@G@
=@
=@Y@Y@Y?=q@Y@Y    ?=q?=q@
=?=q?=q    @Y@Y?=q?=q?=q?=q@Y?=q@Y    ?=q?=q?=q?=q    ?=q@Y                                                    ?=q?=q    @Y@Y?=q?=q@G@
=@G@GA@GAA@GA@G@
=@G@G@GAA:HA}A\  @GAA@G@G@
=AAAA:H@GA:HAA:HA:H@GA:HAAA@GA:HAA\  AA@G@G@G@
=@
=@
=@Y@Y@Y?=q@
=@G?=q?=q@Y@Y@Y@
=@Y?=q@
=@Y@G@
=@
=@G@Y@Y@
=@Y@Y?=q@Y?=q@Y?=q@Y        ?=q@Y?=q@Y@G@YA@G@
=AAA:HAA=qAB{AAAAA=qAAA\)A\)ABAzA\)AzAAzAAAAA}AA}AAAA}A}AA}A}y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @Y?=q                                            ?=q                @Y@
=@GA:HA:HA:HA\  A}A\  A\  A:HA\  A:HA\  A}A\  A:HAA}A\  A\  @G@GA:HA@G@GAA:H@G@GA:H@G@Y?=q?=q?=q@Y@
=@
=@G@
=?=q?=q                @Y        @Y@
=@Y@Y    @Y@Y    @Y@
=@
=A:H@G@
=@Y?=q@Y?=q?=q?=q    @Y            ?=q@G@
=@
=@Y@G@
=A@G@
=AAAA:HA@G@
=@Y@Y@
=@
=A@G@Y@Y@
=@
=@
=@Y?=q        ?=q    ?=q                    ?=q?=q@
=@Y@Y@G?=q@
=?=q?=q    @Y    @Y        ?=q        ?=q@Y?=q?=q    @Y?=q@Y@Y@Y@Y?=q@Y@Y@Y?=q?=q    @Y?=q@
=@Y    ?=q                            ?=q            @Y    ?=q@G    ?=q        @Y@Y@G@GAAAA@Y@
=@Y@GA:HA:HA@GA\  @
=A\  AA}A:HA\  A\  A}A\  A\  A:HAA@
=@GA:H?=q@G@
=A@GAAA@
=@G@Y@
=@
=@G@
=@
=@G@Y@Y@G@G?=q@Y@Y@
=@Y    ?=q?=q        @Y    ?=q?=qA                                                ?=q                @Y?=q?=q?=q?=q@Y@G@G?=q?=q@GA?=q@
=@
=@
=    ?=q    @Y    @Y    ?=q?=q?=q@Y@Y@
=@
=@
=@
=A?=q@GA@
=@GA\  @GA:HA:HA\  @
=A\  A@GAA:HA:HA\  AA\  A\  A\  A\  A:HA:HA\  A\  AAA}AAAA}AA:HA:HA:HA}AA}A}A:HA\  A}A}A\  A\  A}A}A\  A}A}A:HA}A}A\  AA\  A\  A:HA:HA\  A\  A\  AA@G@GA:HA\  A\  A@GA\  A\  A:HA\  A\  A\  A\  A\  A}AA}AA\  A\  A\  AA\  A:HA:HA\  AA\  A:HA}A\  A\  AAA:HA@GA:HAAAAA@G@G@GA@G@GA@GA:H@G@
=@
=@G@
=@
=@G@
=@GA:H@
=@
=@G?=q@Y@
=@Y@
=@
=@
=@
=@G@G@G@G@
=@
=@
=@G@YA@G@Y@YA@Y@G@Y@Y@Y?=q?=q@Y?=q?=q    @Y?=q?=q@Y@Y@Y@Y?=q?=q?=q        ?=q        ?=q@Y?=q?=q        ?=q@Y        ?=q@Y@
=?=q?=q    ?=q@Y?=q        ?=q?=q?=q?=q?=q?=q@Y?=q        @Y?=q                                                                                                    @
=?=q?=q@Y                                                                                ?=q?=q?=q?=q@Y                        ?=q        ?=q    ?=q                ?=q                        ?=q                ?=q                        ?=q                                                                                                                                                                                                                            ?=q    ?=q        ?=q        ?=q                                                                                                                                ?=q                                                                                                                                                            ?=q@Y    ?=q@Y@
=AA\  AAA:H@
=    @
=?=q    ?=q@Y    @Y                                                                        ?=q    ?=q    ?=q?=q                    ?=q                    ?=q                                                                                                    ?=q    ?=q        ?=q?=q                        ?=q                                    ?=q    ?=q    @Y    ?=q                                                            @Y                                        ?=q                                                                                                                                                                                                                                                                                                                                        ?=q                    ?=q            ?=q                                                                                                                                                                                                                                                ?=q?=q                                ?=q?=q@Y@Y@Y?=q?=q    ?=q    ?=q    @Y@
=?=q?=q@
=    ?=q@Y?=q@G@Y@
=?=q@
=@Y?=q?=q@Y@Y@
=@
=A@
=@
=@
=@Y@Y@
=    @
=@
=@Y@G@
=@G@
=@G@Y@Y?=q@Y@
=?=q@
=@G?=q?=q@Y?=q        @Y                    @Y    ?=q@G@Y    @Y@
=?=q    ?=q@
=@Y    A@YAAA\  @G@Y@
=    @Y@Y    @Y@Y@Y@
=@G@GA:HA:HA}@GA}A:HA@G@GAA:HAAA:H@G@
=A@GA\  A}A\  A:HA\  A:HAAA\  A\  A:HA:HA:H@GAA\  @GA@
=@
=A\  A:HAA}AA:HAA@G@G@G@
=@
=@
=@G@Y@Y@
=@Y@G@
=@G@
=@G?=q@G?=q@Y    @G?=q@Y@
=?=q                    ?=q    ?=q                                                ?=q?=q?=q?=q?=q@Y@
=@
=@Y@Y@Y@
=@Y@
=@GA@Y@
=@
=A:HA:HA}A:HA\  AAA@
=A@
=@
=@
=@Y?=q@
=@
=@Y@Y@
=@GA@
=@G@G@Y@G@Y@Y@Y@Y@Y@
=?=q?=q@Y                ?=q        ?=q            ?=q?=q        @Y@
=@Y?=q@
=?=q@Y            ?=q?=q                ?=q                            ?=q?=q        ?=q    ?=q?=q                ?=q                        ?=q        @Y@Y        ?=q@Y    @Y    @Y?=q    ?=q@Y@Y    ?=q    @Y?=q@Y        ?=q@
=?=q?=q?=q?=q                ?=q            ?=q    ?=q@
=?=q    ?=q    ?=q@Y?=q@Y    ?=q                ?=q                                                        ?=q        @{@=q@
=@{@@@ff@Q@  @@G@@@@Q@@@Q@Q@@  @Q@\)@
=@Q@\)@@z@z@@߮@=q@  @p@  @p@(@H@z@33@@=q@@
@@ᙚ@ᙚ@@ff@@G@=q@33@Q@ff@G@陚@陚@=q@
@\@z@@@{@p@@@\)@33@33@H@z@
@\@33@33@\@33@@@@@z@p@p@ff@R@z@{@33@@H@@@@z@@p@ff@(@{@@  @@@@@=q@@\@@@@@ff@@  @陚@z@@@(@  @@\@(@@=q@z@z@@@G@H@G@陚@陚@G@  @{@@ff@Q@
@߮@
=@{@@@z@ff@߮@߮@p@@\)@z@
=@@@p@
=@ff@\)@߮@  @G@\)@p@p@@Q@(@ۅ@\)@ڏ\@p@{@{@
=@@@
@G@@G@H@ۅ@@@ff@
=@߮@  @=q@H@
@z@(@z@z@@(@(@@@
@33@@(@(@H@G@{@@@ff@@Q@@@p@׮@Q@@ۅ@G@p@\)@߮@\)@(@z@G@
=@@(@
@G@
=@p@  @׮@@@ff@ff@
=@Q@
=@ָR@Q@@{@\)@(@{@@33@=q@ᙚ@z@ff@׮@׮@{@=q@@H@ۅ@(@@߮@@
=@
@ڏ\@@H@\)@@=q@z@33@Q@z@  @ᙚ@߮@{@{@p@ff@
=@@ff@  @  @@@ۅ@
@ڏ\@ڏ\@Ӆ@@@@  @@(@p@z@ff@ۅ@z@ڏ\@z@{@޸R@޸R@H@
@@
@H@ۅ@@أ@G@Q@׮@أ@@@@@ۅ@أ@\)@{@
=@G@ٙ@@ٙ@@ڏ\@@@{@Ӆ@@H@(@@H@@H@
=@ָR@G@@33@@G@@ڏ\@ڏ\@  @ٙ@ٙ@=q@@أ@ۅ@@޸R@@  @\)@\)@\)@׮@أ@أ@أ@@Q@@ٙ@=q@H@(@
=@(@ڏ\@@ۅ@ۅ@H@ۅ@ۅ@
@(@{@H@@H@ڏ\@ٙ@H@@ۅ@ٙ@ٙ@33@@33@
@33@
@(@@
@H@(@H@
@
@
@@{@@{@\)@@ٙ@ۅ@ۅ@ۅ@ڏ\@@p@(@ۅ@
@(@z@H@
@33@(@@@@33@
@@{@{@{@@@@ff@\)@@\)@\)@\)@Q@@@  @@@\@\@@@H@\@H@33@33@
@@@p@z@\)@\@@@@@ᙚ@\@p@
@\@@@  @@
@H@@H@=q@=q@=q@33@\@ᙚ@\@=q@=q@H@
@=q@H@z@33@@@H@33@=q@=q@ᙚ@Q@@\@H@z@\)@=q@
@p@p@ff@p@z@(@@\@\@ᙚ@ᙚ@@H@G@@33@@\@33@H@33@(@@@R@{@  @
=@ff@
=@ff@ff@ff@p@33@@ff@
=@ff@\)@ff@{@R@ff@\)@Q@G@G@H@
@@=q@p@@@33@@p@
=@{@R@H@
@
@\@\@H@H@33@H@H@@@p@=q@p@@p@33@\@@ᙚ@@Q@@\)@ᙚ@@Q@޸R@Q@@ff@33@Ӆ@z@H@\)@ָR@@(@H@Q@=q@G@˅@
=@ff@G@@H@\)@
=@
=@޸R@@Q@@߮@  @ᙚ@ᙚ@33@@@@(@z@@@z@p@R@p@p@@{@ff@ff@
=@\)@Q@Q@@Q@Q@G@G@=q@=q@(@@@33@
=@ff@z@@@陚@  @
@@@p@
@@@ff@@(@G@  @  @=q@@p@z@H@@z@(@z@@
@H@H@@Q@@ۅ@@߮@
@޸R@@\)@{@(@߮@߮@  @
=@@@ᙚ@@Q@޸R@p@  @  @{@  @
=@@ᙚ@{@@Q@=q@H@33@\@=q@@@H@H@H@33@@33@@z@
=@@ff@\)@@@陚@G@Q@陚@陚@G@@ff@{@
=@z@R@@\@@H@  @  @z@ᙚ@  @  @߮@޸R@ᙚ@\@H@@
=@@z@ۅ@@
@
@@z@(@@z@@@p@{@@ۅ@@z@33@@@ۅ@ٙ@ָR@{@=q@H@@H@@ָR@(@p@ۅ@H@\)@{@{@@ff@߮@\)@@@\@@=q@\@
@(@@@p@ff@Q@@@@@\)@{@\)@\)@@\)@\)@Q@Q@Q@\)@
=@߮@p@@陚@z@z@R@H@Q@Q@\)@z@@@@G@޸R@@@z@\)@@@޸R@@޸R@@
=@@@@=q@33@\@@=q@G@G@@Q@߮@߮@ᙚ@ᙚ@=q@G@
=@p@z@Q@(@G@@\)@=q@33@
@߮@ᙚ@(@  @
=@(@@G@@p@@\)@{@{@R@R@R@ff@ff@陚@  @33@陚@33@=q@\@
@陚@陚@@@@H@R@@p@
=@
@  @@33@\@Q@R@@\)@@@ff@Q@ff@@@ᙚ@@@@@@޸R@ٙ@(@ff@H@޸R@H@@
=@@\@߮@@p@ff@ᙚ@@Q@@߮@ᙚ@R@ff@R@@Q@  @{@@  @
@
=@(@H@=q@@{@  @Q@H@z@p@\)@R@{@@(@{@ff@\)@ff@Q@  @R@@@@@陚@陚@33@=q@@@z@{@@@H@=q@=q@p@@@R@=q@z@@  @ff@@=q@@ᙚ@33@\)@ff@ٙ@@ff@أ@
=@أ@׮@ڏ\@أ@@@ۅ@33@@߮@@{@޸R@@  @=q@@@@\)@@@
@33@
@G@׮@p@ff@أ@33@{@ڏ\@=q@@
@(@p@
=@@\)@z@
=@
=@33@  @@Q@\)@{@=q@љ@@@=q@@
@@\)@@{@H@z@33@33@
@(@@@G@@Q@=q@H@@33@G@  @R@@\)@@@޸R@
@@z@
=@@{@@Q@{@(@(@z@=q@@G@߮@
=@@ۅ@H@@@H@ᙚ@@@=q@ۅ@޸R@G@(@{@߮@=q@33@G@
=@p@ff@\)@޸R@@z@@@ff@@H@z@(@@G@H@{@@@@  @{@
=@
@@z@ۅ@@@p@
=@\)@@@G@\@33@
@\@33@
@{@
=@@
=@\)@  @@  @Q@@Q@  @
=@
=@{@z@
@
@(@p@{@@\)@@@@=q@@z@p@{@R@ff@@(@@
@\@33@H@
@@@ff@@G@ff@\@ff@p@ff@R@
=@{@R@@@p@{@=q@H@
@@
@
@ᙚ@33@ᙚ@\@G@(@p@R@  @@@@@
@@@
=@@=q@@{@\)@G@p@
@H@=q@@G@\@H@@ff@ff@@(@{@z@@z@p@@ff@@@R@Q@G@@\@@R@@=q@{@@@A @(@\)@@A @
=@@33@@@H@@\)@Q@z@@R@R@
=@@{@z@  @{@H@H@z@@@=q@H@@G@  @p@@@ᙚ@@H@p@@@ff@=q@陚@p@{@陚@
@33@\@G@R@@p@@
@(@ᙚ@@=q@=q@H@@z@@{@\)@  @@陚@=q@@(@z@{@\)@H@@@@@Q@@@@@@R@ff@R@ff@@33@=q@=q@Q@@p@{@\)@@  @
@
@(@@
@p@  @@\)@@@\)@{@@z@33@p@{@Q@@@33@@@p@@ᙚ@=q@@@p@@\)@H@@  @@H@33@H@z@33@z@@@
@(@@p@p@@@@@z@(@@=q@\@@G@ᙚ@@G@@33@H@ᙚ@=q@@@@@  @\)@߮@\)@߮@Q@@Q@  @Q@߮@߮@޸R@ff@p@@
@p@ff@@@@p@@@
@@(@ۅ@ۅ@z@
@33@H@@G@33@z@@ٙ@ٙ@  @ff@p@z@@@\)@Q@أ@Q@G@
@{@
=@\)@@G@=q@ۅ@
@33@33@
@@@@@z@=q@ٙ@33@@@أ@Q@=q@ٙ@33@G@ٙ@@H@@@z@(@z@z@@z@R@(@ᙚ@ᙚ@z@߮@
=@ff@@@@@z@(@@z@
@ۅ@@(@(@H@33@H@ۅ@p@@z@
@(@
@@z@
@@z@@
@
@(@ڏ\@=q@@
@33@
=@ڏ\@ۅ@@Q@@\)@أ@p@{@ۅ@أ@33@{@\@
=@@H@\@  @  @߮@Q@\@z@\@z@@@陚@=q@@=q@@
=@R@G@@@
@z@z@p@p@R@p@@(@@@{@ff@
=@@p@p@ff@{@{@@@G@@@=q@ᙚ@ᙚ@G@G@@@Q@߮@
=@  @
=@
=@޸R@
=@\)@{@@@@@p@@(@p@@p@p@z@@ff@G@ۅ@{@z@{@׮@أ@G@H@H@z@@p@@ۅ@ۅ@p@{@@@{@ᙚ@  @\@=q@H@G@@(@@@33@H@33@H@
@
@z@{@\)@  @陚@G@=q@=q@\@=q@\@=q@=q@H@H@
@z@
@H@ff@  @Q@@z@ff@@H@z@z@{@@
@z@z@@@@@G@ᙚ@G@@@@ᙚ@@ᙚ@@G@
=@G@G@@Q@@@  @@޸R@߮@@{@@Q@޸R@ff@@@ᙚ@Q@\)@@ff@޸R@p@@33@33@{@p@ff@(@{@\)@@
=@@
@=q@ᙚ@  @޸R@\)@@p@R@
=ApA	@\)@Q@@陚@@=q@H@陚@\@\@\@H@=q@@z@Q@  @
=@z@@@33@G@  @@
=@@@@@ᙚ@@@@@@@@=q@@@@33@\@{@p@@@p@(@z@=q@  @A (A\AAAQA
pA
\AAzAffA
=AzAA
AQAA
=AApAApA QAffAA	GA(ApA
{A{AQA\)A\)AAA
=A{ARA(AQAAffA  AARAGAzAA33AzA\)AAHA33A\)AA33AA  A33A=qApAQARA  A
GA
A
A
=A{AA
AHA
=A=qAHAffA
GAA
pA  A  A
RA
HA(AA  @A A
=@@
AH@A=qAARA\A (@A
AA=qA  AffA
AHAA=q@@A   A Q@\)@ff@@ff@R@@@H@@ff@Q@Q@p@Q@@{@@\)@@G@{@\@H@@
=@@33@z@@@@{@@@Q@
=@@33@33@H@z@@@=q@@\)@@陚@  @{@z@p@ff@\)@@(@@G@=q@陚@p@@z@
=@  @Q@@=q@@{@
=@\@G@
@G@@Q@33@33@@@@H@@@@H@
=@p@@׮@Q@@@@@@=q@=q@
@p@@陚@33@\)@@  @  @{@@{@ff@@ff@@33@@Q@R@@@陚@@@@R@
@\)@
=@z@G@޸R@
@  @@
@
=@p@@@33@\@\@@@p@
=@G@@
=@@R@=q@Q@=q@@G@=q@=q@@{@{@
=@\)@33@G@p@
@@(@\)@{@33@@@33@=q@@=q@陚@33@@R@p@=q@ᙚ@G@@@ff@z@=q@{@ff@{@\@@\@@ff@33@\@@=q@G@  @
=@z@߮@@@@
@\)@@@33@@@33@@@@=q@޸R@@ָR@ff@p@޸R@@@H@\@p@p@Q@޸R@@\@@
=@@p@߮@߮@ff@@(@{@z@Q@=q@ff@@ff@33@\)@陚@
@ff@z@=q@\@@  @@=q@(@p@ff@陚@33@@
@z@
=@\)@p@Q@R@  @p@@(@(@@@@@ᙚ@\)@Q@@@@{@ڏ\@ָR@@ڏ\@H@ڏ\@@@  @@H@@ᙚ@@ᙚ@@33@{@@ۅ@@Ӆ@@p@=q@\)@{@p@ٙ@޸R@@ڏ\@=q@@\)@߮@H@
@\@z@=q@@@H@\@ff@\@陚@@\@
@@@\)@@@@@@@H@@R@(@{@Q@
=@  @\)@@33@z@@=q@
=@@\)@G@@@{@@@@@@\@G@(@R@R@@R@@Q@R@{@z@ff@@{@  @R@  @{@@陚@@@=q@R@\)@H@33@@p@@(@@@@=q@{@33A Q@@z@
@Q@Q@G@
=@{@@\)@\)@{@@H@
=@@Q@陚@陚@@@33@  @H@
=@=q@  @G@=q@@
@R@@@R@@
=@@Q@@33@ff@p@@@{@{@R@@@@
=@@@\@G@=q@ff@(@@33@=q@p@@G@\@@=q@
@z@@@z@z@@@@
@{@@(@@33@@@
@(@z@p@@@@(@@
=@\@\@\@(@@z@  @@@33@Q@\@@R@@  @p@@Q@R@@  @Q@=q@z@\)@p@z@\)@@@R@33@(@@@  @H@@\)@
=@G@@{@@33@@H@z@33@p@@@@(@
@@ff@  @@\@@H@@R@{@
@z@z@{@
=@H@\)@z@=q@
@@\@\@Q@
@H@@@\@@\)@ᙚ@G@@\@@p@z@z@ff@\)@
=@@@ff@ff@R@Q@陚@(@\@(@@@p@{@R@=q@\@@@@@@
=@@@\)@@@H@=q@\@33@33@G@@@@@G@@\)@@{@z@@@=q@=q@=q@@(@@p@
@H@@@=q@=q@=q@G@(@z@陚@\)@@(@\@=q@{@\@@z@=q@(@H@\@
@  @  @޸R@\@޸R@\)@\@ff@Q@z@\@G@陚@@33@@z@H@=q@@z@@@{@G@=q@G@(@ff@p@ff@ff@R@@@@@
@{@@@\)@G@p@\)@\)@\)@33@=q@=q@
@(@  @H@p@\@Q@R@Q@Q@ff@G@Q@\@@p@R@ff@@
=@@\@Q@@  @Q@(@@z@@AG@R@@A=q@\)@z@(@G@=q@=q@  @@{@\)@@@p@
=@R@G@@
@
=@@@{@\@陚@@@@=q@@\@p@@(@p@z@
@
@H@=q@  @@
=@
=@ff@\)@R@@@@  @@@\@=q@33@33@
@@
@@33@=q@=q@@\@@@@G@@@@@@@H@Q@  @@@  @@@ff@@\@Q@R@
=@@@z@@Q@\)@\)@R@R@ff@{@{@{@R@H@@ff@ff@
=@@@p@ff@{@@@@@R@ff@ff@@@@  @@  @G@@@G@@@G@@\@H@z@@@@ff@@\)A (A zA A QA zA   A   A   @R@R@
=@R@RA Q@R@@@@(A zA (A zA @pA Q@
=@H@\)@p@33@33@@\@z@@R@@(@
@pA z@@@
@
@z@@@Q@  @@ff@\@{@@{@
=@R@\)@Q@Q@@@H@G@@Q@Q@p@@(@ff@@\@@@\)@\)@@Q@\)@33@z@G@Q@=q@
@@
=@Q@@@R@\)@\)@R@Q@=q@
@p@A zA A   @
=A (@\@
@@H@
@A
=qA@Aff@
=@=q@z@
=@\)@
=@ff@@H@p@@{@\@G@AA A @33A   A (@
@=q@@@{@@ff@{@R@ff@@@H@(@(@@=q@@G@@@ff@R@=q@@{@@@33@陚@@R@@
=@Q@{@Q@@@\)@\@@H@@@=q@(@R@@ARAzA=qA	A	A(AHA  AAQApA
AzA\A A A @{@A @RA (A A   @RAHA\)A
=A
A AAAffAzAAQA@{@33@R@ff@@  @Q@@\@R@  @@=q@\@@G@H@@@
=@{@@{@(@p@G@  @
@@p@@R@\@G@陚@ᙚ@
=@
@33@
@@z@
@(@{@p@@(@@p@R@@G@(@@\@@ff@p@z@@  @  @ff@{@@@Q@=q@H@(@(@H@A z@ff@{A Q@{A (@ff@@@@@
=@G@@z@
=@R@@@@@@@p@(@@=q@{@z@@(@R@@{@@@@ff@
@\@=q@\@33@
@z@33@@陚@=q@@
=@@@@R@ff@{@  @@@H@@R@
@(@(@
@@ff@Q@@@H@\)@z@(@33@@H@z@=q@@  @@G@=q@{@@G@=q@H@
@@{@@@G@@@@@@=q@@@@(@z@(@33@33@@z@=q@@p@ff@@@\@33@33@@H@@(@  @(@33@H@\@陚@H@33@z@(@@z@
@\@@=q@陚@R@陚@z@33@\@\)@
=@@@=q@@@G@@
@\)@
@@
@  @(@(@R@R@Q@G@G@\@@  @\@
@@AGApAA{A (@@{A   A QA z@
=@A Q@@\@ffA QA Q@@{@
=@\)A (@{@ff@RA @z@33@(@H@p@{@H@@@\)@
@ff@33@@@R@  @G@33@H@@@
=@R@@@H@\@(@33@
@p@
@Q@@G@(@G@=q@33@Q@@Q@@@@
@@@@Q@@\)@ff@R@Q@@=q@R@{@@\@
@
@\@  @ff@陚@(@
@p@@  @  @@@ff@\)@Q@H@@33@=q@
=@H@
@p@H@G@\)@@@
=@  @@Q@@\)@R@R@ff@ff@ff@{@p@@p@
@z@p@(@p@z@{@@@z@{@@@@G@=q@
@z@\@陚@陚@G@@Q@@p@{@p@\)@p@{@@@@Q@H@z@\@
=@\)@  @
=@@@@@G@@33@(@@=q@@R@  @\)@Q@@=q@\@H@@
@z@@p@@ff@@{@@  @@p@  @@=q@(@@@@@{@@p@z@(@@@@@{@=q@@@@@=q@@=q@ff@@=q@ff@{@p@@
@ᙚ@=q@ᙚ@@Q@@Q@@@=q@ff@@@  @@{@(@H@@G@@@@33@
@H@
@R@@H@@
=@@G@  @\@H@\@(@p@  @@@\)@H@\)@@  @
=@G@p@@@@@\@@33@\@H@p@\@@H@@@
@@p@@
=@ff@R@Q@{@@G@@@{@@=q@Q@
@33@\@@
@
@@@@{@=q@G@@p@
@@{@z@p@\)@@  @G@  @Q@\@\@=q@{@@@R@
=@@@R@\@A (A=qA{A\)@@
=@{A @zA@\@33@@@A (A A=qAAHAAAHAAA=qAA33ApA33A (@\)@ffAAA
AA
=qA\)A33A  A
ffAHAA
AAAQApA=qA
GARAffA(AQAHAz@@@{@GAp@\)@@Q@  A (A{A   A zA@
=@ff@\)@@@@(@@@@@@@@{@p@A zA A @{@
@\@@H@Q@ff@G@@(@G@H@  @Q@R@p@A@33@
@{@@ff@AA   AA A\AA
=qA{A  AAAQAA
=A   AHA
=@RAGA
=AAA z@(@(@G@@@
@H@33@@@@z@@=q@H@R@33@Q@  @
@\@@(@@@
=@R@\@{@
@\@@Q@@H@(@z@@@R@\@@=q@p@@\@\@G@=q@G@@@z@Q@z@@@ff@33@@(@@ff@@G@@@@  @R@
=@{@@\)AAA@
=A\AAAA A A\AA\A{@{A@A\ApAA	AA33A(A(A\)A(AAAAA
pA33AAA33ARAA
A\A33AA=qA  ARAA\A\)AAAffAA=qA\)A"ffA%GA$zA%GA!GA zA"=qA#\)A!pA!pA zAA"ffA#
=A A!A$A(A.=qA.ffA&HA#A A (A A"{A%A1A.ffA/A.HA.\A,(A'
=A$(A!A)A zA"ffA!GA!pAAA\)A!pA
A=qA
=AHAA\ApAQA
AA{AAA33AQAQAffA\)A
A	GA	A
A
ffA	AAAA=qAQAAzAGA\AA(A A @GA@QA  A=qAz@@R@\@33AzA zAAAQA @@=q@ᙚ@@(@@p@\@H@@@@H@  @
@Q@@@@=q@\)@@@
=@@@  @@@ᙚ@ff@=q@(@@@=q@@z@  @@ApAR@33@
=@
@@@@@  @
=@Q@\@
=@
=@R@@R@=q@33@\)@z@33@@@
=@\)@@@@=q@{@
=@z@@  @
@\)@
=@
=@=q@R@z@  @=q@ff@@R@@33@Q@׮@33@(@  @@@  @p@  @
@@@@G@@H@Q@@޸R@p@(@H@R@{@33@
@Q@@\)@H@(@@@\)@p@R@\)@@@@
=@ff@ff@@ff@@@
=@p@R@
=@陚@G@R@@@
=@
=@33@@\@33@
@H@
=@\@{@z@@z@R@R@@(@@G@@
@@{@A   @@p@@H@=q@
=@@z@@@\@p@(@\@@@@
@  @@p@\@
=@{@@@G@=q@{@@@ff@@@@R@ff@@
@H@@R@H@=q@@@@p@@
@=q@Q@33@\@\@@
@陚@@@\@@@@@
@H@@
@@p@ff@{@
=@\)@\)@\)@R@ff@
=@Q@@@\@(@@\)A
=AA\ApAA@\)@@=q@@@@@ff@ff@33@@
=@@@ff@@@@@
=@\@@@
@@@\@z@\)@@H@@p@z@H@(@
=@陚@\@@G@@@@ff@G@@=q@@@H@@\@\@\)@\)@  @z@\@=q@{@ff@@@G@
@p@@G@@33@33@@@\)A   A{A zA (A zA A QA   @z@ff@
AG@
@RA z@{@p@
@p@@z@@@33@@p@Q@@G@\)@@=q@(@@@{@Q@p@33@
@  @\@  @\)@@@@  @33@H@  @G@@@@H@@ff@H@@@=q@G@޸R@
=@Q@G@@@@@R@@@
=@
=@\)@@=q@33@H@G@@=q@A (A AGA{AHAGAA
A
=A
AQAAA
ARA\)AA@\)A{AGAA\ARAA QAGA (ApAQAzA(AffAA A@@R@@ff@@\)A Q@\@@=q@zA Q@ffA A Q@(@z@(@  @@@H@=q@\@\@@H@=q@G@G@@{@ff@@
=@{@ff@@z@R@{@z@(@Q@z@33@H@G@Q@{@
@
@
@
=@{A AARAAQAA  AARAAARA
{AQAQA33ARA(A
\A
AHAQA{AA  A
=AA
A\)@
=A{A
=A
=@
=@
@
@@Q@H@R@
@@@@@(@  @(@{@=q@@
@@H@@
@(@=q@߮@ff@@@߮@33@=q@ۅ@p@  @@=q@(@@ff@@@\@Q@@(@=q@
=@@  @@=q@  @
@
@@@@@\@@z@H@Q@@@=q@\@@@@@G@z@33@Q@@\@@33@\)@
=@{@@\@@{@\)@p@p@
@=q@\@@@@G@@@@(@Q@\@@p@=q@@z@
=@@p@G@H@@@G@陚@@
=@R@Q@@@33@G@ff@޸R@޸R@޸R@
@Q@  @Q@ff@=q@
=@@=q@\)@
@{@@@Q@33@  @@@p@@G@Q@33@z@@ᙚ@  @Q@ᙚ@ᙚ@@G@G@=q@33@\@@@Q@H@\)@{@ff@  @@{@p@
@G@@ff@\@{@@z@
=@R@Q@
@@z@@  @@\@H@(@@
@\)@G@@ff@\)@ff@޸R@߮@G@@H@  @(@\@ᙚ@
@\@=q@
@@H@\@ff@{@z@@R@H@\@@@33@p@@\@p@
@Q@
=@R@z@\@@p@@@\)@@=q@R@z@(@@{@@p@
@@Q@@
=@R@Q@Q@G@@@@Q@@{@@@H@@@\@z@\)A @@p@@ff@p@\)@{@G@{@@@p@\@@@z@@@
=@@@
=@Q@ff@{@33@=q@@@@@  @@R@  @  @@R@@ff@
=@R@
@\@H@G@@Q@@@  @\@G@G@33@  @=q@R@@{@@G@
@\)@Q@G@ff@H@p@\)@Q@p@@  @Q@=q@@@@R@A33A\AAARA zA\)AAAARA  A{@
=A\@ff@{@33@R@  @33@p@\)@\@=q@H@  @@@Q@@@@@\@H@@@z@{@ᙚ@(@@
@@(@@@p@{@ff@{@@R@  @@@z@\@33@\@@陚@=q@@
@@
@ff@G@=q@ᙚ@{@@\@\@@@{@{@(@(@@ff@ff@z@H@陚@  @ff@@@@@R@R@\)@=q@R@@
=@@\)@R@ff@@@G@\)@  @@@@@GA   @@G@@=q@@
=@R@z@@@G@@@33@@G@G@@(@(@@@@R@@R@@Q@R@{@@p@@@@p@z@z@@ff@@{@@@=q@33@陚@\@\@33@33@
@@@
=@R@
=@Q@@=q@
@@{@
=@R@ff@R@@Q@ff@\)@33@{@ff@{@ff@Q@@@
=@@H@  @H@@ff@R@  @ff@\)@(@@@{@@H@=q@@@(@(@@z@
=@@@@z@{@=q@@\)@@{@p@@(@@ff@@{@@@@ff@\)@@@陚@33@33@z@H@@ff@ff@\)@@R@R@p@@@陚@@z@
=@  @R@@  @Q@
=@
=@\@@@ff@(@@ff@@\)@z@p@@@@z@p@@p@p@{@\)@G@{@{@R@{@@Q@@@@\)@ff@@{@{@@(@
=@@  @\)@@G@@@
@@z@@
@@@G@@33@@\@H@H@\@@@@\@G@33@@@\@(@@
@33@(@G@  @  @@@@@Q@Q@Q@@@33@@  @Q@  @ff@
=@@z@
=@ff@@(@p@@@\@@33@@@
=@ff@p@p@Q@@
=@=q@H@(@H@@z@\@@@  @\)@@Q@@H@@(@Q@z@
@H@Q@@G@@@\)@{@R@Q@
=@{@z@@@=q@33@\@=q@@@G@G@33@H@(@
=A @
@@Q@H@{@@33@p@p@@
@\)@z@p@(@H@
@{@AA\A A{AAAAQA
A  AG@\)@
=ApA\A{A
=A
AAAA(AQAAAAAAAAA  AA
A(AAHA\)A\)AA
=A33A
=Aff@\)@RA@p@R@@
=A@33@@\@(A @\)@z@z@@@ff@{@{@G@G@
=@\)AGAA
A\)A @
@@(@ff@@@=q@\)@\)AAA zApA Q@\)@  @\)@=q@@{@
=@p@z@=q@Q@p@\)@@ff@@33@z@
=@@
@(@@
=@@(@R@@ff@@A AA zA @RAA\@Q@R@H@@@\)@
=@
@=q@@{@@@(@  @@@@{@{@p@p@@
@z@@@{@\)@ff@@@@@߮@@
=@\@G@@H@陚@@@  @@(@H@H@33@
@@\@@Q@@@޸R@{@@@ff@@@Q@z@@
=@R@@@@@
@  @=q@@33@@33@@@p@p@p@G@@@ff@
@@\@
@33@
=@33@@  @@@\)A@\)@\@z@p@@@陚@{@H@\@=q@@H@\@(@33@ff@Q@ff@R@ff@33@@@\)@陚@\)@=q@@\)@@R@@(@\)@Q@\)@陚@=q@@=q@p@@=q@G@=q@@\@
=@
@=q@p@  @Q@ff@@@@\@G@\)@
=@\)@@陚@陚@@\)@  @ff@p@@(@{@@@@@@H@@@H@\@@
@@=q@G@(@@
@  @G@
=@@\)@\)@R@p@ff@Q@
=@
=@ff@@(@  @p@
@{@@@  @=q@H@ff@Q@H@
@@@@z@  @z@(@R@p@@
=@z@{@{@@@@@\@@@
=@Q@陚@ff@ff@@G@޸R@@
=@
=@p@@G@@z@p@\@@H@  @
@\)@  @@G@(@@@{@33@@ff@Q@
@Q@ff@ff@p@@p@=qA AApAA@zApA=qAARApA@@@@
=@\@Q@@H@Q@@R@
=@\)@R@@@G@@
@{@\@H@@@\)@@=q@33@=q@\)@
=@\@z@
=@@G@R@@R@@33@z@@@@@H@@z@
=@@@33@陚@@p@@  @\)@陚@=q@H@ff@@
@\@z@p@ff@\@@A   @33@@33@@@@\@(@@@{@@\)@{@
@G@  @
=@  @
@z@@
=@p@
=@@@@=q@@
@@G@{@@QA A=qA   A (AGAHA @
@33@ff@
@(@@@  @
=@
=@@G@@@H@@@@G@@H@@@=q@p@@\)@{@R@@  @\)@G@G@R@p@=q@@
AAHAffAG@@(A AG@ffA @@pAQAAHAAAA  AHAA\@\)AA=qAA%pAA
ApAzAA
=A33AAA
AAAA\)AA{AHAA
{AA$  ApAGA
\AA
HAHAGAAA
HAA=q@@=q@
@
=@{A\A(AzA
HAzApAA=qA QARApA A zAARAffA33@=q@R@@33A @G@R@Q@@=q@Q@@
A (@{AAA QA\A=qAA=qA   A Q@{@@Q@@@\)@
@@@@  @@@@@@=q@@
=@@ffA QAA A=qAAA
=A{A
=A @R@@RA AAffA
=AA A{A@\)@ff@\)@G@@@G@(@(@G@H@=q@33@@H@@\)@@(@R@p@p@p@z@p@@\)@
=@R@@  @@Q@=q@33@\@@G@{@\@@@{@\@p@=q@(@H@@@@@
@{@  @@@@pA   A   A AAA=qAAffAAA\)AHAffA\)A
AQA
AApAAzAA=qAAA(AA{A33A\AffAA=qA
\A\A
=A	A
AffAzA	GA	pA
\AA	GAA	A33AGAAGAAGA
A@ffAAA AHA (A A33A(A33A\)@\)@A AAAAffA\A (@Q@=q@ff@\@@(@A Q@@p@@@Q@33@
@AAQA (AAffAA	AzARA
AAQA(A\)AA{AAA
A
AffA
A=qARA\)A
AffA\)A  A  AffA
A\)A
AAA@\)A@G@33@
=@H@@@@@@Q@@@@@@@=q@@@@@G@G@H@@
@p@@{@ff@@@(@
@@
@H@33@  @33@(@p@
@@z@@=q@z@@@(@\)AGAQAQA
A33AzAAHAA	AA(A	A\)AzA
A
pA	A
=AzA\)AAA
AAffAQAAAAAQAHAAAA
ARAA
A33AA@33A@@@@33@ff@@@=q@H@
@G@=q@@@=q@@G@@R@G@=q@  @\@@=q@Q@@@@@@H@  @G@G@ffA A AApAHA (A\)A\AffA   @33AGAHAA\)A
A  AzA
A	AzA\AffA(AA
A33AA{AA=qAQAffA(A
ffAAzA\AHARA{AAzA\)A33AHA  AQA
=AA=qA
AHAA(A33A
AAAAAA(A
A
=A	AA33AA	GAzAAzA  AAA\AffA{AzAHAA\AGAAffAHA
\A
ffA	AffAAAffA	AzA
ffAA	A33AAzAAA\)A
=A
ffAA	A	A	pA	AA
A  AAHAAAAQA
ApApAffAA"\A QA A!GA33AA"ffA#
A%pA&ffA(  A*\A)pA'A#
A"HA!A'
=A*RA)A(A)A'
=A"=qA'
=A
=A33AA  AA
RA
AAHA\A(AAA{A  AA\A(AzA33AzAAAzA
=A33A  AAzAA33A
\A	pAAA
\A
=A
A(A
AA
AzAAAA(A  A	A\)A33AQA\AHAHA=qA
=AQA
AGAA A33A  AAzA
=qAA=qAQAA\)A (AzAAAA\)AAHAAffA\A\)A{A
A33A33AAA  A33AAA\ApAffAGAA QA{AA33AAQApAA
AQAAHAGA(ARAffAffApAzAAAffAA
AA33A
=A
A
A
A
{AQA(AA\)A=qA(AAA  AzA33ApAAA	GA\A
=A33A	pA33A
A	A	AAA  A
AA
HA
ARA
A
=qAHA\)A	A	AAAA33AA
=A33AAzAAAzA(A\)A=qA(AA
ARAAA33A A\ApAAAHA(A=qAA(A(A	GAAA	A  A
A33A=qA
=A(A  AzAQAAHA{A33AffA(A33AA{A\A{AA
A33AAA33A@
=A @A ApAffAAAA\A
=AA(A
AQAA  AAA	A33A	A
=A\)A  AAAA	A
=qAAA
AzA
RA
pA
HA\)A
AzAzAzAA
=A
AA=qAA\)A(AA\)AA33Az@@RA@R@
@H@=q@=q@R@(@33@@@H@
=A=qA33AAHA{AA	AA\)AffAHAHA{A33AA Q@\)A
=@A
=A @@  @@p@
=@
=@{@  @ff@(@
=@@@@@  AARAA
=A
A=qA33AA	A
{A
=qA	GA	A	GA\)A
AHA	A	A	A(AffA\)A  AAHAAA	pAzAffAA=qA33A	GA
\A\A
=AffA\A{AAHA  A
pAHA
RAA	pApAAAA(AzAAzA=qA=qA
=A33AA   @pApAffA  A(AAA=q@\)ApAHA  AApA@\)@@z@@33@33@@@p@{@@@@G@=q@@z@  @{@\@H@@@(@\)@@@33@@=q@(@33@AA @@\)A AA
AGA\)AAAA{ARA=qAffA A(AQA QAARAffA@A\A@\)@zAA  A\@\)@=q@@R@@R@@\@\@G@@  @@@ff@@  @@@@@=q@\@@@R@\@@G@\)@@(@G@ᙚ@޸R@@(@@{@@
=@@Q@@\)@z@ff@ff@p@p@ff@\)@p@Q@p@@=q@p@Q@
=@@  @(@\)A QA A   A\@ff@R@RA QAAff@(A@\@GA z@33@p@{@@z@@z@=q@@\)@=q@\@
@z@@@R@{@p@{@ff@\@33@@=q@Q@Q@޸R@߮@  @ff@@ۅ@p@@ff@ff@p@@33@@@أ@@z@33@
@ڏ\@ٙ@G@ָR@@z@z@{@@޸R@33@޸R@\)@{@@@{@
=@\)@G@@@=q@=q@p@@陚@陚@@ff@@@R@@R@@{@(@=q@RA\)@@\@@@zA QA A\AHAAAAARA=qAffA(A z@ff@33@@  @  @@
@@@33@@@@z@\@@@=q@G@߮@@R@p@@z@@ff@\)@p@@@(@@
@
=@@p@R@陚@ff@p@@G@33@ڏ\@  @=q@
@@{@@@(@
@@{@@z@\)@=q@陚@(@@  @z@R@@@
@@(@  @@pA\A A{A  A	GAAAAffA33A\)A\)AA\)A	AAA
A
HAAA
=AQA\A@\)@p@@{@\@@
@@
=@
=@p@
=@\)@  @  @=q@  @Q@  @
=@Q@(@H@\@@@33@p@@\@\@=q@\@=q@G@G@  @p@@@33@Q@{@ff@@@@
@@@\@@{@(@@A (@
=A zA   @
=A (AA (A=qAffA=qAHA\AAAAAA\)A z@RAAA	A
A	A
AzAQA
A@
=@33@{@ff@@(@
@=q@@@@33@{@@ff@  @(@H@QA A
=A=qAA  AAAAAAA
A(A  A\)A
=AA\ApAAAffA{A@@Q@
=@A\AffAffAHA
AGApA33A\)AA{A A (ARAAQA=qA A@@@A\AAHA
ffAA
{AARAA  AzA	AAffAQAAAAAAffAAHA
=ApA\)A33AHA=qAA\)AAzA@=q@
=AAApAA
HA=q@@@{@(@  @@
=@
=@H@@p@ff@@
=@@  @\@\@=q@
=@@
@@\@@z@A QA A\AA @ff@{@\@RAA33AA=qA
A Q@H@H@@(@@{AHA  A\A A
AA33A
A\AAA\)AH@pA zA  AA33AAGAHA
HAAzA(AA
ARAApAA
=AA=qAARAA
AA  AA
AHAAG@A@\)@H@\)@H@Q@{@p@{@(@@@@(@@@@@  @@(@
=@{@@@ff@Q@z@(@G@@G@@H@
@z@@@@  @=q@z@@=q@@@A@@@G@ARA
=A@p@
@@AffARAA
{AzA	pA
H@z@RAQAzA  AA  A\)A
A@@\)A @p@\@@A A  AAApAQA (A z@ffA
=@
@@(@@\)@\@G@@  @\)@(@@@{@@ff@@@GA
ffA=qA\A   @@@AAA
AAzAA=qAA z@{A Q@A (AffA  A z@\)@ff@@@p@@
@  @@AGA(AAffA{A\)AQAzAAAA	A(AA
HA
AffA(AAAA0zAQAzAApA\A
ARA
ARA  A\)AHA=qA
RA=qA33AA
=A
HA(A=qApAA  A
A
{A
A Ap@Q@@G@
=@Q@@z@\@{@G@p@{@=q@(@Q@A
A   A
=AA z@@A@@G@{A{A @@
=@@@=q@=q@
=@\)@Q@ff@p@G@{@\@=q@  @z@@@ffAA
A  @
=AHAzAzA33@RApA
HAzA
A  AQAGAHA
=ARA\)A
=A33A
=AffApAA{AffAAAAA=qAHA{A\)AGA\A
A\)A
\AAA
AQA@@@z@G@
@@Q@@@
=@p@\@@@=q@陚@@
=@@@G@@\@z@(@
@z@@@@p@@{@p@@{@@@@ff@Q@@@{A   AA zAQAApAAAA
GA33A
=qA	GA	A
ffAAAA
A33A
A
{AAAA{A(AA\AQAHAffA\A A!pAAAAA!pA\AGA
A\)@RAffAA\AHA@@@z@H@@@33@@@R@@p@=q@@z@@@陚@Q@{@@=q@{@
=@p@H@@G@\@ff@R@Q@@{@@G@R@  @33@@p@@@G@33@G@=q@@  @33@@\@{A QA{A
A(AA{A\)AQAAAA{A33A(AAA  A	pAAA
ffA
RA	A
=qA	GA	A
\A\)AAHApA33ApA33ARAH@p@p@@=q@G@(@@\)@@33@  @Q@Q@@  @\@@p@@H@  @\A QA Q@
=@@{@(@@  @
=@33@@33@R@@Q@R@  @@
@@\)@{@\)@@33@(@{@H@z@z@33@=q@z@@@
=@\)@@33@H@@G@@ff@@@@33@\)@\)AGA33ApAA\)ARAff@H@\@z@@AHA  AA@@z@p@
@\)A z@zA   @p@H@@@  @\)@@ff@G@p@=q@33@p@A Q@RA@@33@@Q@A   @
@@G@z@@p@@
@z@@z@33@@@{@
@33@陚@ff@Q@
=@@陚@@R@{@ᙚ@33@@@@ff@z@\)@@G@H@@@p@@@@ff@
=@@A@ff@GA33A\)ARAA
=AHAAAAAHA  A
pAHA
A\)A\)A	A
=A Q@H@@
=@@@@=q@
=@  @@G@=q@\)@@@G@\)@  @@\@ff@@R@{@@  @z@R@
@@HA @A Q@p@R@=q@@p@
=@Q@R@@(@33@@@@  @@@=q@@=q@@
=@@\@
@\@  @
=@p@\)@@@pA\A(A AHAzAGAAA	AA  AA
\AAGA
AGApA	A A
\AA{ApAffAHARA  A
A  AAARA  AAGARApA  AAffAAA
AG@@=q@\@A
=@H@Q@@@=q@@  @p@@G@33@@=q@@H@(@@
@\)@@=q@ᙚ@@
=@H@z@@@H@@@@{@@@G@@@@@@R@陚@H@@z@G@H@@@H@z@@陚@Q@A(AzA!A\AQA33A\A
=AA  A=qAHAAAzAff@p@@(@@@H@Q@陚@G@
=@\@@@@z@p@  @@z@@R@@
=@\)@@@@@@@
@@@z@߮@H@@@@G@R@H@Q@=q@Q@H@@@@
=@p@@33@\)@{@R@{@ff@@H@(@@@@Q@@=q@=q@@@(@G@@@\@@z@R@@@
=@  @@{@\@
@@\)A@\)@@@@@=q@zA (@pAA	pA
=qA\AAffAA Q@@=q@\@
=A\)A@\@@p@p@=q@33@
=@@{@G@
=@@@@ff@
=@\)@@@\)@
=@@z@G@ff@p@p@(@@@H@ۅ@G@ff@=q@Q@
@@@޸R@@@ۅ@@@
=@33@@(@@@\)@G@H@p@
@@ff@\)@  @
=@  @G@=q@@G@G@{@z@@\)@
=@  @(@
=@ff@p@Q@@
=@@@
@@(@\)@ff@@@{@z@
=@R@@(@H@@(@z@@R@33@@Q@@\@陚@@
=@R@
=@@@H@@@@R@\@@Q@G@@R@H@@G@@ᙚ@ff@@=q@H@@@ڏ\@  @  @R@p@@@p@Q@33@H@@R@Q@\)@@@\)@@@(@ff@p@R@@=q@H@@@p@{@ff@\)A A (AA{AAA{A
=A ApAA{AGA\)@G@(@(@@33AA
{A
\A@@(@ffA@\@陚@z@
=@=q@ᙚ@@\@@ff@@Q@\@@33@@z@@\)@@\)@z@A A AffA\)AARAAA A   @p@Q@
=@z@\@
@
=@
@@33@z@@@@@=q@@
@@@@
=@Q@@\@\@=q@=q@\@(@z@pA AAA A zA{AffApA\AffAAA AA(AHARA (AARAA\@AAGA@R@(ApAAApAA
=AA33@A A
Az@ff@=q@@@@G@@{@
@G@@@ff@ff@@@@H@@Q@@(@  @@AH@@{@AAA(ARAAQAAAAAA
=A(A
=A@\A\A33A AA{AA
AAGAA\)AA(A	A	A
=A\)A  AzAAQA  A\)A(A
=qA	AQA  A
AQAQAAzA
AA  A
ffA33A	AQApA A   AA A AffA @
=@@@z@@ff@(@@@@\)@
=@H@=q@@@@  @p@@R@@
=@R@ff@{@\@p@ff@(@{@Q@@33@
@
=@@
=@(@\)@@(AAAAA
ffA  AA
HA
HAQA
A=qA
A33ARA
=A
=A\)AHAA	GA  A
A33A	AARA  A  AApAGAAAAA33A(A33A
{A
=qA	pA=qAAGAzA
A\@R@
=@\@@Q@@@@R@  @G@@(@R@p@ff@p@{@@@\)@33@@@H@{@
@ff@ff@G@@@  @Q@
@R@
=A A A33A=qAAAzAzAA(A
=@A AAA  AQA(AA{AAAHARA  A  A(A
{A
=AQA
A\AHA33AAzA\AA\AzA33A\)AQAGA  AA\)A
A
A
A  AA AApAGA@@ff@@z@@G@@G@=q@z@ff@@@@ff@H@RA{Ap@@R@QA AAA\)@@
@ff@@z@@  @@{@ff@@
@
@A   A{@(@@=q@p@ff@
@
@\)A A{AGA   @
=A
=A
=A\A	AA
=A
AAGA\A\A
AzA\AARA\)AffAAAffARA
=AA{A
=AAAA
=AAA  AA{A(A
=qA33A
@R@Q@\@@ff@Q@\@
@
=@@ff@33@(@(@@@z@z@@H@
=@@ᙚ@Q@
@RA{A@@(@A QA   @
=AffA z@@@(@@R@@@R@R@R@\)@ff@G@(@@@\)AAAA\)AA   AGApA=qAAAAAA
ApAzAzAA  AA	pAAzAA  A
\A
RA	A
AAQAzAHAffA (ARA
=A=qA\A   @pA z@=qA (@@ff@(A Q@@@\@R@33@p@33AG@A   @p@(@{@
=@=q@z@@@(@@33@
=@  @
=@  @{@޸R@\)@  @@=q@(@R@@G@@޸R@ҏ\@
=@
@Ϯ@33@G@@(@{@ᙚ@ff@@=q@
=@Q@R@@{@ff@@@R@z@
=@=q@
@H@
@33@@
=AAff@A\)A@@R@\)@R@Q@R@@{@33@z@@\)@Q@\)@ff@z@H@=q@@@\)@陚@z@H@@H@޸R@@@33@(@p@ff@{@H@љ@p@33@@Q@H@p@G@\)@@
=@Ϯ@
=@˅@p@G@ə@Ǯ@=q@  @=q@ə@33@@  @z@ȣ@˅@@{@ff@H@ff@@@z@Q@R@H@
=@z@@z@@(@{@@@ff@33@=q@33@p@R@@Q@33@ffA
=AHA
=A  A  A
A@H@@zA (@
=@(@G@@
=@@p@z@
A   @p@
@
=@
=@R@33@\@ᙚ@z@أ@ٙ@Q@׮@׮@׮@ff@{@ָR@ָR@ff@Ӆ@
@=q@@(@ҏ\@=q@@G@@
@@@p@@@@33@Ӆ@Ӆ@33@=q@G@33@@ۅ@  @  @߮@G@@{@\@@{@
@z@\)@@@陚@\)@Q@
@QApA33AQAAAAAA@\)@
=@\)@\)@H@  @=q@=q@@33@R@p@@(@  @@G@@33@@G@Q@@G@R@(@ff@(@ᙚ@\)@@z@@H@@޸R@@(@
=@ff@@޸R@@p@p@ڏ\@33@ٙ@G@ڏ\@  @
=@{@{@أ@\)@@p@@{@׮@أ@@@׮@ٙ@Q@G@
@ff@(@  @ᙚ@\@
@ᙚ@@{@\@\@@p@@p@=q@(@G@33@(@@@@pA   @\)@R@A QA   A33A{AAA\AA @@pA{@H@=q@@R@Q@@z@@@z@@p@ff@@Q@=q@
@  @=q@p@Q@ff@Q@ᙚ@33@(@
=@Q@@ۅ@@@z@=q@ٙ@ۅ@{@@@33@33@@@R@(@
@(@@z@@@ff@R@\)@@  @陚@@@@\)@\@@H@
@G@33@@{@@  @
=@@R@\@=q@@p@  @Q@{@
@p@@G@@@
@@@H@@  @
=@陚@@Q@陚@@H@p@@
@@@@(@z@33@ff@G@@A zA   A Q@
@ff@@Q@@@@@@\@H@@@@Q@@(@
=@(@Q@@ff@\)@33@=q@@H@陚@陚@\@@
=@@{@@@p@@@@=q@@\@@z@H@z@33@ff@RAA Q@{@
=@33@z@\@
@Q@H@{A zAA\)AA
=AQAAQA  AHAAQAGAARA
=A AQARAz@ff@=q@=q@@\)@R@陚@33@\)@
@߮@
=@޸R@@@@\@ᙚ@@\)@
=@ָR@  @\)@G@@G@
@أ@@z@@p@R@@@@Q@
@@@ff@=q@
=@z@(@33@@@@@z@{@\)@@33@
@@@
@R@33@RA (A A QAGA A
=AAR@H@G@{@{@@@H@p@  @\)@
=@H@@  @
=@ff@H@
=@G@@Q@@@@33@@{@H@
=@@
=@\)@(@@
=@陚@@
=@陚@@R@陚@@(@@{@\)@\)@@  @\)@z@{@p@H@
=@@@@R@@@\@G@陚@@@G@Q@
=@
=@@
=@ff@R@@{@{@R@
=@33@p@R@=q@@  @
=@@{@p@{@R@R@{@
=@
=@
=@p@@  @\)@\)@\)@Q@R@ff@@  @R@@@ff@  @  @@  @
@@H@p@@@陚@(@\@{@p@@@R@R@{@p@p@陚@H@33@  @@33@33@@@@G@
=@R@陚@  @@p@p@ff@p@@p@{@p@z@@
@33@(@z@@R@@
=@@G@@33@{@@{@{@R@ff@陚@=q@\)@\)@@  @@@{@{@{@@
=@33@@33@Q@
@@33@H@(@33@p@p@@陚@=q@@陚@G@  @  @Q@@陚@@@H@=q@陚@陚@(@Q@  @ᙚ@33@޸R@  @33@\@33@{@\@ᙚ@@  @(@\@陚@
@33@
@
@=q@=q@33@=q@(@ff@@@@  @@33@ᙚ@=q@33@
=@@@߮@@޸R@33@ff@H@@@R@ff@R@@(@R@Q@@G@ff@Q@H@
@(@ff@@G@@@Q@@@@
@R@@H@z@@RA (A A zAA=qA\)AzAA=qAAGA z@\)A   @@33@Q@@H@@@\)@@G@@Q@33@  @@@G@(@(@@R@@
@@=q@@R@@@=q@@{@@Q@Q@R@(@Q@G@ff@@
@(@H@G@R@\@G@@@@@@z@Q@@z@@
@H@@@@33@ffA   A @@33@R@AAHA
=AAAAAAA (A\A @@
=AAQ@@  @=q@@R@{@@
=@@\@=q@G@@R@R@\)@@{@z@G@\@@Q@G@\)@
=@\)@\)@陚@33@@@p@@Q@{@\@@@33@@@@33@@=q@R@G@Q@@@Q@G@(@Q@@G@  @@ff@z@ff@ff@\)@
=@33@@@@@=q@@@G@G@
@p@@@@G@=q@Q@\@A{@{@@@HA   A (@@
@@ff@\@@=q@  @@G@@\@@H@
@H@\@(@G@Q@@\)@ff@R@@@R@33@\@@H@=q@=q@p@@@陚@z@@\@=q@\@
@@(@@
@(@33@H@
=@\)@@\)@  @\@@陚@陚@=q@33@@
@(@z@@@@ff@
=@@@\@\@@z@@@33@{@{@@
@z@p@{A QA @R@@ff@AAAA(A\)A(ARA
=AzA(A=qA A A A AApA z@@pA zA (@  @{@  @@p@  A\A @(@@p@
@@@@@Q@A (A A @(@@=q@@@@@z@R@p@@33@(@ff@(@@=q@G@Q@H@ff@ff@R@ff@ff@@=q@\@
@z@p@H@@@@AA(AAAA\A(A @\)A Q@@A z@@33@p@ff@\)@33@p@{A (A zA QA A A
A
A@zA  AA
AR@A
=A{AzAHAA
HA
A
pA33AR@AHAff@R@(@33@@@  @A\@\)@(A @@@z@p@p@33@@@
=@R@@p@z@
@@ff@@(@R@33@ff@R@=q@@\@@ff@@zA   Aff@R@RA A  AA{A	A
A @ff@=q@@H@z@ffA z@(@@@AApA
=AzAAAApAA=qAAA
ffAHARA  AAA	ApAzA\)AAA33A   A\)@z@G@  @=q@Q@@@ff@@@@(@(@H@=q@G@@33@=q@H@@
@@\)@  @@@@R@R@z@H@޸R@ᙚ@陚@@33@(@G@R@\)@\)@R@H@@\)@=q@\)@A A33A=qA\A  AGAA
AA	A	GA	A	A
=qA	A
=A	AA	pA
GA\)A
A@@@(@@33@  @@@@@
=ApA@{A  A
{Ap@p@\)@Q@
@H@@R@=q@(@@33@@G@@@@G@\)@z@陚@@G@H@(@@(@陚@@{@(@@\)@33@Q@  @@@\@@{@p@G@@@R@G@@z@@Q@33@@
=@ff@޸R@@  @Q@@=q@
=@\)@{@(@@R@H@@33@@(AAHA@@@@G@Q@@@RAGA{AAzAAQA{@@{@  @
=@@R@R@=q@33@@G@@陚@@  @@(@ff@R@@z@
=@\)@
=@@޸R@G@G@G@G@G@H@߮@ᙚ@Q@@  @@{@{@(@@޸R@@@@ۅ@z@z@
@ff@p@@@@\@33@{@@@@G@33@  @H@
=@Q@R@\)@H@\)@@R@@Q@@Q@@@33@G@p@z@=q@\@\@@pAA\)AA @A AzA{A@\)@@ff@@@@陚@H@陚@G@\)@ff@
=@p@z@(@\@33@ᙚ@@@Q@ᙚ@ᙚ@H@\@@@z@\@33@(@@@
=@\)@R@\)@\)@R@
=@@@@G@@H@\@@Q@ff@ff@@
=@p@33@ۅ@@@@ff@\@
=@z@H@@  @ff@{@@p@@{@=q@\@ff@R@H@
@@
=@
@\)A   @\@z@
=AffA33@H@@{@@@\@R@p@@@@(@Q@߮@@ff@z@(@
@{@@33@(@z@33@ۅ@H@=q@H@@޸R@@(@H@p@p@ᙚ@
=@\)@  @Q@޸R@߮@G@z@\@(@33@@33@@\)@ᙚ@߮@@ff@G@@z@
@@ff@@p@@@Q@@R@33@H@\@  @\@{@\)@
=A (A   A   @\)@A   A Q@{AA33AzA
=A{A
ffAGA{A  ARAHAffA
=AzA
=qAAApA=qA
=q@G@\)@ff@G@\)@\@  @@@@@@\)@@@{@@߮@@
=@߮@Q@G@@@{@@޸R@@  @G@@G@H@@33@@R@@Q@
@@
@@G@߮@@=q@@H@=q@
=@33@z@@(@33@ff@@陚@
@=q@
@@\@p@
=@@{@(A A{AA
{A  AQA
pA
AQAAAA
A
=AAAGA\AA
A
GAA
A	A  A(AG@\@z@@p@@ff@ff@ff@@Q@H@=q@Q@@z@@@p@(@
@33@(@ff@H@z@@
=@G@@@@H@Q@z@
=@@  @G@33@=q@ff@@@=q@33@=q@R@p@p@@
@  @Q@Q@@33@
=A A33ARA AARAAHA
A=qA33A33AA(AA	AAAA
A\)A\A
A
=AA33AAAAA(A
RAA{AGA{A{AA
@
@@p@Q@\)@
@Q@@@
=@@R@@@@
=@@
=@@z@=q@
=@  @ff@@Q@  @{@\@p@
=@=q@@H@33@33@@@@=q@=q@G@
=@
@G@@
@\@z@@@@H@@@{@ff@  @@@AA @@\)@@
@pA AApAARA=qA33@@
=@R@@@@@A	A
ffAAA
ARA=qA=qAGA(AAffAA
=AA=qA{AGA\ARAffA	GA\)A (@@33@\)A\@ffA@R@@33@33@=q@@G@@33@@陚@(@@Q@{@G@G@H@ڏ\@G@(A@ff@A zA   @ff@A   @@
=@@
=@@33@Q@ff@p@{@
@
=@
=@
=A (@ff@@@ffA (A33AA
=A
=AA  A
A\AAAAQA	AAQAHA\AQAffA
AAA\A
A\AGAA!A A"HA"{A!GA
AA  AAA\)A@QAHAA  @@@=qA=q@\)@
A@
=A@
=@@=q@\)@@
@QAG@
=AQ@R@
A QAA A@@@{@@G@ff@(@(@p@޸R@߮@ff@p@ff@@@Q@ff@G@@\@@G@{@@ff@ff@  @HA zA\AA{A
=qA(AA
pAApAQAffA(A
AGA\)A{@\)A@AQA (@ff@ff@R@@=qA
A  AffA	AA
=@p@(A	pA\AGAAGA@@33@Q@(@@p@(@@ᙚ@@z@@@H@@@@ff@z@@@  @\)@\)@Q@
=@޸R@\)@߮@
=@޸R@
=@\)@  @G@@\)@{@ff@@p@\@@(@@
@Q@@@R@{@
@z@@=q@\)@@G@@
=@ffA{AzA=qA=qA  A  A	A@ffA33@
@\)@@@AAAAGA33AAGAA  @
@H@{@
@AAzA@\)@@H@@@{@@@@@@Q@@ff@A=qA=qA@  A @
A@A  @33@@=q@@
@R@=q@@
=@=q@
=@@@{@(@\@\)@\)@\)@R@  @(@p@z@G@(@@=q@\@R@@(@  @G@G@zA AA @ff@\@z@A=qAHA33A=qARAHAAAAA=qAffAQAAGAA
ARAR@(AQAA{A@33@(@HA A\ARA zA Q@RA A @\)@@
=@@@R@@@@@@\@  @@H@  @@ff@=q@
=@33@@@z@@=q@{@@@\@@{@
=@z@\@\@p@@H@\)@@
@H@\@H@z@ff@
=@33@@p@@@  @  @=q@@G@G@RA A
=AAA{A(AAAA	p@A(A
=A(A
AAA33AAA\A(A
AARA@@@@G@\@{@@@=q@33@\@RA A   AG@@@Q@R@\@@\)@@@p@G@\)@{@@Q@\)@33@@@@\)@@\@\@Q@@@@@
@p@p@@@@@=q@@@@@Q@\@@@@H@\)@z@H@H@@AQARAQAQA
=A(ARAffA
=A(AA
GA
AGAAzAA
AAp@@A	GA
RA
{A
ffA\)AAA
=@R@=q@  @AAffAA AAA=qA33A
AQARA33AA A{A33@R@33@Q@=q@33@{@z@p@p@@z@\@33@@@z@\@@陚@z@=q@  @Q@R@H@R@@@G@pA Q@pA zAQ@@@
=A QA zAGApAAffA\)A=qA A  AQAA
AA  A@
=@@z@
=@@@@{A{A{AA@
@AffAAARA=qA
@
=@Q@@  @@@H@H@G@@@@=q@(@33@\@@  @@\)@@\@
=@(@@
@z@z@@ff@{@@  @@H@@=q@{@
@R@@Q@
@@H@@@@\)@{@=q@G@z@{@R@@  @@@  @Q@G@\@\@
@\)@A (A{A
=A(A  A
AA\)AA	A
=AA	A
A\@@@A@HAffA
A@@=q@@AQAzAffAzA @A  AAQA  AA@(@@@
=A   A @H@
=@
=@@@Q@z@z@{@p@{@\@@@
=@\@H@\@\@\@ffA=qA@
=@G@  @\@33@G@=q@@@@@陚@@@@陚@@@@@  @G@@
@@
=@A
ARAA@@RA (A\)A33AA
AzA	A\)A
pARA=qAA\A(AAffA  AAA
=qAA\A(AzA
A
AQA33AHA\)AQ@(@p@{@@H@  @Q@R@z@@Q@
=@Q@@  @@@
@@ff@@z@p@@33@(@
@
@@33@H@\@=q@@\@=q@\@\@@@z@ff@@  @@H@@\)@Q@@@33@(@
@pA   AA
=A(A(AGAHA
AA	GA
HA	A	A(AA\)ARAA33A
A\)AAGAGAA
\A	A=qAAAAA	A
=qA(A(A	A(A{A  AQAApAA A   @p@\@G@@{@pA zA   @R@@\@z@A Q@@ff@(@\@
@A@
=AG@ff@z@@H@@@@ff@@@\@  @\)@@ff@陚@p@@@@{@RA A A A
=A (AzARA
\AAA  A
@R@=q@@@(@Q@33@@A\AAA@(@
=@z@@@G@@ff@@A   @AffA  A\A
RA
AA@R@@\)@@p@@
@
@陚@(@ᙚ@@@{@
@=q@
@HA z@{@z@\@@@z@@33@@p@@G@\)@\@@Q@@陚@G@@33@33@(@Q@@\@@H@H@(@33@@\@ff@
=@  @
=@H@\)@ff@G@33@Q@@33@@@=q@G@
=@33@@R@A A@(AR@@@=q@\@ApA\)AAff@@
=@H@@Q@{@\@\@@@@@@@@ff@p@@33@\)@  @@R@
=@@Q@p@(@\)A @@p@@33@=q@p@HA @\)@\)@@
@
@@R@@z@@@@@
=@@@@z@p@@{A @@
@=q@A Q@(@33A
=A33@(@
=@  @{@(@H@z@A (A{AAzAAARA"H@33@@{@ffA{AffA\AHA
=AzAffA33A{ARAA
=A$A"\AAAQA z@@@@33@\@\@=q@\)@ff@{@{@@@H@@\)A   ApARA A@(@G@@G@
@@GA\)@@33@G@{@
=@
=@ff@
@A\)@z@@33@{@H@\)@(@ff@\)@@ff@@H@z@@
A33A33AQARA
AAAAApAA\)AAHA33A"ffA%pA
A\@A
A@HAA	A{A
AA{AA\AAA\)AGAzA@@G@p@p@\@ff@@Q@@Q@@ff@(@(@@G@  @
=@@Q@ᙚ@=q@G@@@@߮@߮@ff@
=@@@@p@@@ff@p@ٙ@G@ۅ@@z@\)@G@R@@
@
@  @@@ffAA33AA=qA@@(@=q@
@@p@@ff@ARARAA
pA
A\)A  ARAA
ApAA  A	AA
ffAAQA   A AffAARAHARA
AAAApA QA@
=@R@\@G@@@(@Q@  @
=@ff@Q@{@@{@@
@@@z@z@G@R@@
@@{@\@  @@(@@
=@@G@@ff@{@@@
=@Q@
=@@@  @@@Q@@  @RA zAAA(AR@ffAH@@A@(@ff@ff@  @@@AA@{@  @@@H@
=AARA33AR@ff@GA\ARA33AA(AGA\A\A  AA	A\ApA zAAGAAAHA zAARAAffAffA AA=qA AA AAGA33A Q@H@\)@
@(@H@@@@=q@@@=q@\)@z@\@@@@@R@
@  @H@@@@@Q@z@@
@\)@p@{@(@(@  @@ff@33@=q@{@
=A zA (AG@\)@ffA\)A
AAAA!GA"ffAA!A"=qA A#\)A#
A#
=A@zA z@=qA=qA  AARA  AA\AAAQA	pAQAAzA
AA
=AffA  A{Ap@RAAGAGA @
=A z@\)@ff@\)@z@@=q@ff@33@33@{@@z@@R@ff@@
=@
=@@R@@\@\@@z@H@@G@@@@H@(@ff@
@(@Q@@@=q@ff@H@  A A	A (A\)A@  @R@@@\@\)@@(@@@33@
=@ff@R@{@@R@A{A@Q@@@=q@@@
=@
=AAffA33AA@\)@33@{@ff@\)@(@
@
@ff@H@{@
=@@@
@@{AA{A@33@{@\@@Q@\)@  @
@@H@@\)@Q@33@@z@z@z@\)@Q@ff@p@(@G@@@@@R@  @(@
@
=@pA
AAARA\)A
A(A33AARA@A@AH@{@33@@@z@
@@ff@A (@H@R@A@@z@@  @33@@A\A
=AA
A=qA{AA @33AAAGAG@ff@R@ApAAAGA=qAA	GAzAQA	GAzAHA33AffA
=AHA (A @A (Ap@@(@@33@@G@
=@R@z@@Q@@@@
@@@H@@p@QA @@{@p@@@@\@H@@\)@\@@@@H@=q@=q@G@@@@@@=q@33@@@(@\)@@G@@z@@@@z@\)@
@G@@H@ff@@@R@@@@=q@@p@@@(A\A{A	A  Az@=q@
=@(@G@@AAAp@\@
@{@R@G@{@\@Q@p@R@Q@@  @  @Q@@\@=q@H@
@R@=q@\@{A (A33A	A	GA
{A	A	A33AARAA33AGAAHAAA!AA
A\A	AzA
A33AAHA
=A
A
=qA
=qA(A33AA\)A\)AA{A
=A  A
=A{A33A @A zA  @
@  @=q@ff@p@@z@G@=q@
=@@Q@@@z@@\@{@@@@Q@A33A  A33AzAA
\AARAAGA   A A A z@(@z@\)AGA zAAAzAGAA(AA=q@R@(A   AQA
H@{AAA
=@\)@@Q@@\)@RARA@A   @RA zAAAA  A	A	AAA\)@R@\)A (A (A   A   A zA Q@p@(@=qA@H@@@(@
=@H@{A
=qAffA
pA  AAp@AAA
RARA	AAAAA@
AA @
A@
@=q@@=q@=q@@Q@@@@@G@Q@{@H@{@@p@߮@\@Q@  @@陚@
@@
=@33@Q@@
=@H@Aff@{AARA(A
GAA33@@
=A AffAAp@A zA @
=@@@@  @Ap@33@H@A @ffA
@\)AApAAAAAffAAQAffA(AQA
HA	A	pAAAHAA=qA@
=AA z@@
@ff@@@@=q@@  @G@p@G@@@p@@@@=q@@z@@@z@@\)@Q@@=q@
=@\@A
=qAA(A{A\)AA{AApAA\)A\)AAA A$zA$zA'A)pA,zA-A1A$zAffA zAGA\A
=A  ARA
HAA
AA33A\A(AA{A\AApA
HAA @@G@  @33@(@p@
=@@@p@@@z@p@G@p@33AzA	G@RA
@@@@G@@33@H@@z@@(@@陚@@G@@  @(@p@
@=q@Q@@@@G@
=@@Q@=q@@@@@(@@=qAAzAA
=A
AQA=qAA{AA  AQAAAHA33A=qA)A'AAA(A,zA{AQAR@@A (@\)A\)A@
=@@Q@H@\@{@{@@ff@@=q@@=q@@H@33@R@  @@@p@
=@@@R@RAA (AHA
\A
pA
=A
pAQ@H@R@@@R@AGA@ARAG@33AAQA(@=q@ff@ApAA{A(A	A
A
\A
pA\)A(A
A
RA@@
@@pA
A33ARAQ@A	GA@(@@33A
=AApA  @z@H@{@pAAAHA QA (@A AHAA
A\A
A  ARA  AzAHAA
pAAAAzAHA
\A
GAzA
ffAAA
GA	GA  AA z@
=A (@RA@A@@=q@=q@Q@@@@=q@@
=@@@@Q@z@(@ff@p@33@\@Q@\@\)A=qAA zA
=A=qAGA
=qAA(AA
RA\)A"HA"RA!A'A)A)A*RA,QA+\)A,A/33A.=qA/33A0zA1A3
A2=qA+
=A/
=A,A1pA,(A+\)A((A!pAAGA  AAA&{A3
=A   A(AHAA{A{A
=A=qA@p@@@\)AAzA  A
RA{@HAA\)@@@G@\@@  @GAA	A
ffAHAAA\AHApA=qAAHA QAff@\)A z@(@(@{AA	@
=@{@@HA
A\)AAGARA
AQA  A  AAAA=qAA (A A#ARAffAA-GA+
A1A%A"ffAApA\AQA\)AA!A)A!A-p@RA{AHA(ARAHA\)A  A QA (@@G@@=q@
@\)@  AAG@ffA\ApA@@H@R@
A (@{@
A\ApAQ@@\@AA	A
A
=A	A
\AHAA
=@A @\)@  @AA (@{A33AzA
AA\)A(A{A(A@RA
A\)A@RAGA@R@@@GAA QA AAzA
=A
=A  A(A@ff@@p@(@
@@GAp@
A
AQAA
A zAAzAQAAAHA(A33AzAA(A\)AA
=A\)A
A
A  A33AA33A33A	AAAff@
=@Q@\@33@
=@G@ff@z@@@
=@{@@\)@33@陚@p@p@G@@
=@\)@
@  @HApAGA\)A Q@@@ARAzA
RAA
=qAA  AA  @ffA Q@\)A=qA @@R@RAQA	pA  A(AAAGAA
AA33AA\AA{AffAA=qA
A
HA\AffA  AA Q@@@G@@p@z@@pA=qAHA	A	GA
A
A	A	A	A	AAA
AAp@  @p@=qA AffA   @\@RA\@@@33@33@(@@{@(@Q@\@@33@@@Q@@{@  @@p@z@
=@@@
@
=@A AApA
A33A  AffAAAARAQA33A{AAA QARA!A A QA"=qARA(QA(  A
A/\)A0zA.=qA.\A*\A#
A"{AAGA (A\)@ffA{A\)A(AH@\)@p@ffA@
@@
@33@@R@
=@@@@@@@@{@G@@{@\@G@@z@@H@\@G@33@=q@@\@@
=@\)@(@@@\AHARA\)A(A(A
=AA33A\)A=qAHAffAQA	pA	AzA{A
A{AA\A
AzAA	AA
AQA\AA4(A,(A"ffA%AA\A33A(AAAHA{AzAA
AARAffAA
ApAApA33A\)AAHA	A	GA=qAA	A	AA\)A
A(A
ffA	A  A(A{A  AA
=AQAApA33A(AA33AHA33AAAHA	GA=qA	A#A QAARAAAAAA QA!A!pA"RA!A{A
=A A A A"ffA"ffA#33A"RA!pA (A$  A  A%A,  A((A!A AAA(AAA
=A   A&HA*RA-GAHAAHA
A\)AAHARA=q@A   @p@=q@@  @
@33@陚@z@@@=q@z@@ff@
=@R@p@ff@(@\@
@@@@H@  @  @{@H@
@ff@ff@\)@@(@G@@@=q@@R@p@@H@\)@G@@\)@ff@A A A AAffA\A=qA\A33A(A	pA
{A33A
A
GAAAzA  A\A
\A(AAAA\)AffA\)AffA{AHAQA=qAH@\)A Q@{@H@(@(@p@p@{@@\)@
=@@H@\@H@z@@@@陚@
=@@z@
=@p@@@@=q@ᙚ@@\)@p@H@G@{@@R@p@Q@ff@
@z@R@\@@@
=@(@@33@@
@(@33@@p@@Q@@@33A
ARAAA AA\AAAAApAA
pARAA\)A\)AQA\AGAA=qAHAA
=@ARA
=A @@R@\)@H@33@Q@\)@R@@z@@\@G@\@@\@
@陚@ff@@z@\)@@H@ᙚ@@33@G@z@
@ff@=q@p@33@  @(@33@
@\@
@G@陚@{@z@33@@@p@
@@@G@@@@@@Q@G@(@
=@33@\)@@@H@z@@
A A\)AA  A33AAAAAGAzA=qAAA!A#A!GAffAAHA\)A
A=qAAA
=A33AQA33AA @@p@ffA   A Ap@33@
=@(@(@p@ff@G@@H@G@@{@=q@=q@@R@
@\)@p@R@(@p@@  @Q@@33@@{@  @{@p@z@@=q@z@@陚@=q@@z@R@@
@GAAA\)A
RAA
AAA=qAA	A	pAA
=AzA
AAzA!pA(AGA
AA	AzAzA
A
=AAA
RAR@{@Q@{@@@=q@
@G@
=@G@
=A   @H@pA{@R@p@p@@@A
@{@H@AffAAGA @@(@\@p@G@ff@\)@@
@@G@{@Q@@
@@33@@
@z@H@p@@\@\)@\)@@(@@@@p@
=@H@(@@  @  @Q@@  @ff@A
\AAzA{A\)A!A#
A%A'\)A(QA*HA*{A zA%AffA
=A33A33ARApA33A Q@\)AzApA=qA
=AHA@Q@@@ff@@Q@
=@
=@@
=@p@33@@Q@33@=q@Q@@@\@(@=q@=q@@\@@@A Q@@zAHA@z@Q@@ff@
=@@ff@p@ff@AzA@@=q@Q@RA\A  A AA\)ApAQA
=A=qAA A
=A
G@HA@ffA\A QAA @@z@H@z@
=A (AQA=qA (AA
@Q@33A   @@\)@
@ff@
=@z@@@@@z@@ff@\A @@A   A (@H@@33@@@=q@A QA33@  @{@QA A zA  A  AAAGApA\A A
@ff@@@@@R@@R@@p@@
@Q@@{@G@@@(@@@
=A (A33A
=@H@Q@(@z@=qAA  @{@  @  @\A\A
=q@
=@@33@@33@z@ff@\)@Q@@
@@33@@
=@p@R@@@(@@z@@ᙚ@\)@
=@\)@(@ڏ\@  @@
A(A
=AA A(A\@33AA33@@\)@@H@z@
@@  @p@  @@ָR@=q@Q@@@33@=q@޸R@߮@׮@Q@
=@@G@@@ff@ff@陚@{@@G@=q@33@
@@G@@
AffAAA
{A  A\A33ApAA{AA\AAAA\A33AffA=qA\)AA\)A
=A!A"{A"{A   A\AAA\)A(AA	AA\)@{@{@@ff@߮@@@
=@@
@{@G@{@{@Q@\@@33@@@@@p@G@H@@@zAG@G@
=@z@  @@G@޸R@Q@H@Q@G@=q@ۅ@p@\)@@
=@
@=q@ָR@
=@Q@@@@Q@p@  @\@pA   @
=@@ApAAffAz@AGApA{AQA
A"=qA*ffAz@ff@zAA
=qAA@A
=AQ@A
{ApA
=@ffAA{AA{AGAffA=qA QAff@@
@G@ff@@ᙚ@߮@=q@@@@
@(@33@@33@p@H@@\)@AHA   @ff@
=@ff@@@@@=q@z@@G@@(@H@p@
=@\)@@@@@@p@R@{@p@@{@z@@@H@@33@@Az@@\)@
@
@pA
@{@@@p@p@{@33@
@
=A@@33@ffAHAz@33Ap@@{@\)@{@z@p@@p@\)@
@GA A (A\)A
=A A{A   A{@=q@@=q@@@G@@=qA @{@@Q@@@H@ff@
=@  @@{@=q@@H@Q@=q@@\)@p@ff@@33A\)A=q@pAA\)@ffA A Q@p@33A
AA{AAGA#A!A%A(@@@@@@(A
A@R@\)AffA@33@
=@@Q@=q@{@(@\@@@\@  @
@\@@@(@\)@ᙚ@  @@
=@H@=q@p@R@\)@A Q@@
=@
=A(A zA @Q@@@@Q@G@ff@G@ᙚ@
@@޸R@\)@\@ᙚ@{@=q@p@@
=@  A(A
A((A)pA*=qA*RA(A*HA,A-GA/33A%A+33A'
=AA!A)A!AAA	pAAAQAAA@(ApAA	A33A
pA  AQAH@=qA(AQ@@ff@\@=q@@{A z@(A A@@\@\)A
ffA	pAAA33AAHA#A,QA @(A@A	A
A33@
=@ff@@߮@{@p@@@
=@  @߮@߮@{@@z@  @p@=q@\)A
p@R@=q@GA@@ۅ@ڏ\@(@G@@Q@=q@  @љ@z@Q@z@˅@@p@@G@H@@ҏ\@p@{@@z@  @ff@@@
=@
@أ@ָR@Ǯ@{@ʏ\@
@Q@\)@\)@
=@ff@θR@(@ƸR@{@@z@A@\A	A\A  @ff@\)@  @@@G@=q@@Q@R@@\)@G@陚@ff@(@(@\@ff@R@@@=q@@33@33@  @(@
@33@@陚@(@\@Q@  @@@\)@@p@\@\@@陚@  @R@{@(@=q@@
@@
@\@p@@G@p@p@p@\)@z@@H@ٙ@أ@@{@߮@ff@
@
@ff@Q@33@@{@  @H@H@G@@H@\)@Q@\)@
@33@{A   Ap@H@H@@z@{@@A z@@\)@@R@pAAp@@@\@@@@ff@@\)@
@@
@ff@@@@@\)@@@@@33@陚@@=q@H@\)@H@{@
@@
@ff@ᙚ@Q@@ff@=q@(@ۅ@Ӆ@33@ff@p@{@{@(@H@
@Q@  @33@ff@@  @AA	A
=AzAA\A{A
AAAAHA{A\AQA
AzA\A"HA'\)A zA\A
AzA
ffA  AAAAGAA @@pA (@ff@@\@G@Q@p@
@@G@(@@ff@{@@@p@@\@ᙚ@@@ff@
@@G@Q@\)@@(@G@G@G@\)@z@ff@@z@
=@(@H@z@
=@Ӆ@G@Ϯ@@  @33@@33@@@H@H@=q@Q@\)@@\@@{ARA@AzAAA
HA
\A  AzAAp@@R@
=@(@p@{@ᙚ@ff@@  @@
=@{@@ᙚ@@z@{@p@Q@@\@
@@H@@@@ᙚ@  @
=@p@@ۅ@
@33@ۅ@=q@33@ڏ\@@  @  @\)@׮@@@\)@\)@
=@
=@@(@H@ҏ\@@Q@{@{@
=@\)@@@33@
@@
@Ӆ@
@׮@=q@{@@z@@ᙚ@@@ᙚ@ᙚ@=q@@ff@A AA	A
{A
A
A33AzAA
A
@R@
=@@@@
@33@@@\@{@  @  @=q@޸R@
=@أ@ָR@@ff@ۅ@@=q@Q@@أ@@ۅ@أ@ָR@
=@G@=q@ٙ@@G@@@H@@@=q@ڏ\@p@
@@@ۅ@@(@@
=@陚@Q@{@33@@ff@陚@p@  @\@33@{@@@(@
=A @QA%A&HA&\A#A A!A A{A
=A33A\ApAA"=qA
A
=A33AQAHA=qA
=A
AHAAAARA
GAHAzA  A
=A(ARA(AQAHAAzA{A	A
{AffAGA A AAG@p@(@@Q@\)@{@@  @{@H@Q@
=@\)@@߮@Q@z@Q@߮@@G@
@  @
@@GA AA  A
AAARA
=A
=A (A33AffA
=A (A\)A\)A=qA(A  A(AHAAApA\@ff@=q@@  @@{@\@@@@@  @
=@@@@
@Q@(@
=@p@@z@@
=@R@R@@@H@Q@@z@{@@@=q@  @p@{@(@G@
@z@\)@H@\)@@=q@@@\@=q@ָR@\)@߮@@
A\)ApA\AAffA\)AAA33AQAHAA(AffAAAApA=qAHAAzA
AAA33A   @
=@@@@@p@@\)@Q@@@@R@33@
@ff@
=@(A QAA   @p@
@=q@Q@@(@@z@ff@{@(@R@\)@33@׮@ڏ\@  @\)@@@=q@@\AzAQA(AGA{AARA
A33AffA(AA33A  AAApA(A
AHAffAAA@@pA QAA (@\@A   @
=@ff@@@Q@  @=q@{@@Q@
@\)@R@R@p@{@QA QA QA   A z@  @\@ff@
=@@@@@@@ᙚ@Q@33@@\)@\@@  @  @p@(@=q@@\)@@ff@@@33@@=q@
@ᙚ@R@@޸R@@\)@
=A Q@AA  A=qAA z@(@@@{@@@{@\@@@ff@@z@
=@@=q@@@z@ٙ@ۅ@@@\)@@  @@H@@ҏ\@Ӆ@@33@p@ָR@@Q@@@ff@˅@θR@33@  @ٙ@@Q@Q@@@{@(@  @33@
@  @Q@Q@G@  @@@G@
=@
@ʏ\@  @H@ȣ@z@
@@\@Q@G@G@@G@z@Ϯ@@=q@@@@Ϯ@H@G@ٙ@{@(@Q@p@\)@@(@33@=q@@߮@(@أ@ڏ\@{@
@
@ۅ@@@  @Q@  @33@{@@޸R@
=@
=@\)@@z@=q@Ӆ@Ӆ@ҏ\@@G@ٙ@׮@أ@ָR@ۅ@{@ָR@ff@@@
@(@
=@G@H@G@\@  @33@@޸R@z@@z@(@
=@@@H@(@ٙ@=q@@@(@H@=q@@ڏ\@ڏ\@ٙ@@ٙ@أ@
=@@ۅ@z@ڏ\@=q@@
=@=q@ʏ\@p@  @Q@33@@ٙ@G@@ff@G@\A(AAQA33ARAA33AAA (AzAA(A=qA{A
pA\A
=AAA
A  A	A(A	AA
{ARA@@@\)@\)@ۅ@أ@\)@z@Q@У@Ϯ@@@(@\)@@@=q@
=@陚@@@33@Q@\)@@@(@@@@Q@\)@\)@H@@@@@
@\)@У@@=q@Ǯ@@H@Q@
=@@G@@H@H@{@Ϯ@θR@У@H@ۅ@33@\@@p@H@A QA
A\AHAAAAAHAA\A\A  A
A#
=A A=qARA
=A=qAzA	A
AAA\AA	@z@33@=q@@p@HA (AAA QA@(@@p@
@R@@  @\)@@z@\@=q@@@@\@@z@33@
@@@\)@@أ@
=@޸R@@  @@@33@ff@@33@(@@ff@@
@@  @(@
@RAGA	AHA AzA  A
GAA
{A
=ApARAQAGA{AA
A{A\)A@
=A AA\)@{@p@\)@\@@@@@@@@{@  @\)@@
=@\)@AA  A	AA	A33A
=@@@@=q@R@
=@@@p@@
@33@G@Q@@H@@@33@=q@G@G@@33@ff@(@@ff@@R@R@{@ff@=q@(@
=A=qAA\A@{A
{AA{AQA{A=q@=q@=q@
=@@p@A=q@A@AAff@\)@@@{@H@33@Q@=q@33@\)@ڏ\@G@{@(@  @G@@{@@z@ָR@G@p@G@(@{@RAA  A{@@  @@@ۅ@H@ff@@@ff@@љ@{@\)@׮@33@H@׮@\)@p@z@
@@  @Q@߮@(@޸R@޸R@޸R@@G@@H@z@AA
=AQAARA\)A(A{AzAA\A\)A\AAA
@@
=@\@Q@
@  @{@=qA@ff@p@@{@@@\@
=@H@{@{@G@Q@\@H@\@@Q@
@@z@  @=q@޸R@H@@p@Q@@(@\)@@@
=@(@\)@@\@޸R@ff@@@{@\)@H@@@@AAHAA	A	A
=AzA  A33ARAA33AGAAAQA33AAGAARA
A
ARAQA33A\A
AA\A   @R@33@ff@\@@H@
=A@\)@@@(@@陚@@
@\)@R@p@ff@{@z@@G@33@@@H@{@ff@ff@@
@H@G@G@\)@\)@\)@ᙚ@߮@@@أA zA=qAHA	A
AA=qA(ApA=qA
=AHA	A(AGA{AG@ARA\A\)AQA
GA@G@H@\)@{@R@(@@@@\@\@
=@H@A (@ARAGAffAAGA@AR@@@@p@p@@p@@\@ᙚ@@@H@@(@z@
@޸R@@\@33@@AAz@@@@@
=@@H@@H@ff@
=@R@@\)@@  @Q@@@
=@@H@RA (Ap@(@@ff@  @Q@z@@ff@陚@p@=q@{@@H@G@
@p@
=@Q@\)@@\@\@@G@@\)@p@p@G@׮@{@ָR@\)@33@Ϯ@Q@
@@أ@׮@\)@=q@@Q@ff@
=@߮@Q@ָR@׮@=q@ҏ\@@
=@p@{@޸R@z@@ۅ@H@ٙ@׮@33@p@љ@@33@p@=q@@H@@@A zA\@=qA@{A (@pAG@@@@@@G@ۅ@@ڏ\@p@Q@
=@@p@@p@ff@޸R@@@ff@{@  @=q@33@
@=q@z@H@@\)@
=@
@@ᙚ@ᙚ@33@@@@@@޸R@{@@@p@ff@޸R@@ff@ff@ڏ\@
@ۅ@@(@ff@@@@(@  @@
A   A{A zA  AAAAQAQA{AAAA33AAA\)@AAAGA
=AQA=qA	A@
=@@@@ff@陚@(@@@߮@{@@@  @߮@ff@
=@@@\@@@(@=q@\)@@\)Aff@A zA A@
=@=q@p@(@ff@
@ᙚ@z@33@@Q@Q@
@@33@\)@AQAA  A\)A@A A33AA	GA\)AAffA33ARA  AA33A
A
\AAp@@z@pAA A (AGApAAA   @@
@
=@@@=q@H@Q@H@
=@H@
=@
@R@@{@R@R@@
=@  @R@@H@@z@  @  @@\)@@p@\@@ᙚ@@ff@G@Q@G@ff@@@@\)@\)@@@@\@33@{ARA	A
HAA\A
HA
AA\AzA  A\AGAzA\)AA(A
GAffAA=qAA
=AAA\)AGA\A
=AA
{A(@@@R@\@R@z@@@=q@AR@A@@ff@=q@
@@
@  @@  @@
=@{@\@
@@@G@H@33@@@@\)@
=@
=@\@R@ff@@33@(@\)@Q@@@H@=qA Q@\)AAA   A\AA	AffA
RA	A
A(AAAffA(ApA"HA=qA=qA  A
ARAGA
A  A  AA33AAzA
A
RAQA=q@ff@(@Q@@{@@@@H@@
@p@@{@@@陚@  @@@
@R@p@@
=@{@ff@@p@H@33@޸R@ff@
=@ff@ff@33@@@R@ٙ@@@z@
@@=q@\@@@A(A z@zA (AA
RA  A
A
AA
AA=qA\AffApAffA\A=qA(A{A(A\AA\A=qA
AAz@z@@@@
=@z@@z@  @(@@  @Q@  @@@@\@  @@ۅ@ٙ@
=@@{@׮@@
@z@(@
=@Q@z@ۅ@
@@\@=q@@@@p@p@z@
@p@A (A@R@\A
@@G@\)@H@ffAffA{A\)AzA
{AAA=qAHAA{A33AA
A   A\)AffAA  AGAAA@
=A	GA
\A
=@A@@@@z@=q@@@(@A{@\)A33A{AA{A{A	pA
A33AffA(AAAQA{ARAffAA\)A33AHAGA@@z@@
@@ff@@=qA zA AG@@AAGA  AAA	A
pAA	A	pA	A
A
AAffAA  AHAAA33AffA  A
RAAAAA
=AAffAAA@
A(AG@A@
@{@@G@33@
@
=@@@Q@ff@@ᙚ@\@33@{@H@@{@Q@33@33@@@p@@@\)@@G@@陚@陚@{@(@
=@{@33@ff@@@H@
=@@\)@R@ff@AA	AAA{A @ff@\)@33@
@33@@RAA@zA (@AAAQ@@@p@@  A@
@{@=q@ff@@{@{@Q@=q@33@߮@޸R@@ᙚ@(@H@
@\@G@ff@
@H@@
@33@G@G@أ@׮@  @@
=@Q@@أ@ָR@  @\)@\)@Ӆ@ҏ\@Ӆ@У@(@p@p@p@  @G@G@أ@ڏ\@@
@
=@Q@G@@
=@@@33@  @޸R@  @\)@33@33@z@{@Q@33@Q@@(@33@33@p@(@@G@߮@ۅ@  @p@@ҏ\@(@p@@θR@  @
=@@@33@33@ʏ\@ʏ\@33@ʏ\@H@ə@@˅@{@@ҏ\@љ@G@Ϯ@@{@p@Q@z@H@@G@@Q@=q@@@{@@@=q@
=@ff@@  @z@=q@\)@@G@ȣ@=q@H@@
@H@R@R@
=@  @R@\@Q@33@z@@p@
@H@H@p@\@@\@z@H@p@@(@ff@z@  @=q@33@=q@@ᙚ@z@@ff@@θR@ʏ\@
=@@
@(@z@@z@@{@p@\)@Ǯ@p@@33@Ϯ@θR@(@(@
@@@Ϯ@(@ə@@Q@Q@Q@H@=q@R@@@  @@(@
@(@@@p@
@@H@ff@ff@ƸR@33@G@{@ٙ@G@@޸R@G@(@\@ff@{@@(@@{A@\A(A@\@ff@@@ff@أ@G@  @@Ϯ@
=@@@
@@(@H@@У@\)@z@z@(@
@θR@ʏ\@ff@˅@θR@
@
@z@{@ff@@˅@
@ȣ@=q@=q@G@\)@p@@Å@(@H@Å@@@ƸR@  @ƸR@ƸR@@33@\@H@
=@
=@  @Ϯ@љ@@@  @(@@@ָR@(@أ@@H@@@z@G@@\)@33@H@ff@z@H@@
=@@H@Q@@@ۅ@߮@{@z@@z@{@߮@@33@H@ڏ\@@  @@أ@  @@p@Ӆ@H@Q@{@
@p@z@љ@\)@
=@  @@@G@
=@Q@(@ۅ@@
=@@׮@
=@ҏ\@Ϯ@p@p@˅@˅@z@33@33@
=@@Ǯ@H@@@@ȣ@
@
=@  @G@ə@@@θR@@@{@ff@  @G@
@p@  @G@߮@߮@Q@  @Q@@
@@Q@\@\@
@pA33A\)AA{A	AAAzAzARA@@
=A33@33@z@  @@@z@{@@
=@(@@33@z@G@Q@G@ҏ\@У@@Ϯ@ff@=q@
=@ff@\)@Q@@p@ᙚ@ff@@@R@=q@\)@(@@z@ff@ڏ\@@
=@׮@33@(@
@@H@  @G@@=q@Ϯ@ȣ@G@ҏ\@Ϯ@@
=@z@@\A@\)@z@@p@H@H@GAGA=q@  @@p@p@(@\)A
AA\A\)A=q@
=AA	@  @@  @\@  @
=@z@ۅ@  @Q@Q@@
@33@33@{@\)@
@@@
@ҏ\@=q@=q@Q@
=@=q@p@=q@@G@@θR@  @=q@p@=q@ҏ\@z@{@{@@@\@@33@\@33@@\)@ƸR@z@z@ff@@R@\)@@@@\)@Q@
=@A (A QA{AA(AGAAff@H@(@G@
@\)@
=@=q@
@@p@Q@\)@@ff@@@{@@{@@@z@p@G@\)@@
=@׮@
=@{@ff@@أ@H@׮@@@ٙ@ڏ\@
=@Q@{@ff@Q@{@أ@33@(@p@G@ff@
=@Q@p@
@(@@У@
@@(@ff@@ᙚ@\@p@H@ff@R@R@
=@A QA
=AAA
@\@H@z@\@Q@R@
=@ff@
=@@{@
@G@  @@33@{@陚@@=q@
=@Q@@{@\)@
@@\@{@ff@p@ff@
=@33@z@
@H@@߮@
=@(@(@@
=@Q@p@@R@\)@@
=@z@ҏ\@ҏ\@ָR@H@
=@33@θR@Q@(@@z@@@
@(@߮@ᙚ@G@@
=@\@ff@@@z@G@G@@z@\)@{@p@H@p@p@@ڏ\@=q@ٙ@@  @׮@
=@
=@׮@{@=q@׮@p@Ӆ@θR@ȣ@G@ȣ@
@=q@33@@
@˅@H@{@(@{@љ@(@
=@ff@(@ff@=q@(@@
@=q@@Ӆ@(@@\)@ҏ\@z@Q@@
@@ff@
@
=@=q@
@޸R@G@\@@z@33@z@@
=@=q@G@\)@@\@H@p@Q@z@Q@33@ff@߮@\)@=q@@H@=q@G@
=@ٙ@ָR@{@Q@ָR@
=@{@@Ӆ@33@H@33@Ӆ@
@z@ҏ\@H@(@љ@@@G@ҏ\@@љ@=q@@G@G@=q@љ@=q@љ@љ@G@H@љ@У@љ@G@ҏ\@H@@@޸R@  @Q@ڏ\@@H@@  @33@=q@@z@
=@\@
=@@@@@Q@@R@R@@Q@@@ff@33@@ᙚ@\)@ڏ\@@أ@@=q@H@z@@ۅ@G@H@ڏ\@Q@ff@=q@  @أ@{@  @ָR@\)@ff@p@\)@\)@
=@\)@
=@
=@p@
@G@(@@ff@
=@\)@{@@33@H@H@z@@@\)@p@p@\)@θR@z@ff@ff@ff@ff@G@@{@G@R@@H@
@@@{@R@G@33@R@{@p@\)@@p@{@R@@@33@@
@
=@  @33@Q@@@Q@{@@Q@
=@@\)@p@@@@ff@@ᙚ@
=@\@߮@޸R@33@@
=@\)@߮@p@
@ٙ@@@ٙ@Q@{@
@ָR@׮@G@@ff@ff@R@p@=q@H@  @(@ff@
=@\)@(@@@@\@@p@RAAffAA{A\AAAA(@@
=@@
@G@(@@
=@@@
@z@@G@@@@@33@@
@@ᙚ@33@ff@{@z@
=@
=@@G@@R@@p@@@R@(@p@  @@R@
@@ff@@G@@@@\)@@G@Q@@ff@@@\)AA{A33A\AHAA\AQApAA@@(@@
@{@ff@  @(@\)@p@p@ff@@@@@(@33@@@@33@@@@@{@@G@@@@ff@\)@(@33@\)@@=q@p@33@
=@@R@
=@Q@(@33@Q@G@=q@@R@@
=@{@\)@@ff@@HA{A\A33AA	GA
AAzAAGAGAAGAAAff@@@R@\)@@@
=@p@@\)@
=@ff@  @{@p@z@@33@33@=q@@(@G@z@G@\)@\@
=@(@(@@߮@ᙚ@H@G@G@(@p@
@@33@@߮@@{@@R@@@  @=q@33@p@@  @@@
@GA
=AffAA\)AA"=qA#
A"RAA(AQA@\)@ffA33@{@=qA@AA z@Q@@\)@ApA	pA
ffAA{AA
HA33A@@ff@A   @@\)@\)@@@@Q@@@\@(@@
=@@(@G@@H@߮@\@z@\@H@H@@޸R@@ᙚ@@޸R@  @H@@@@Q@H@@G@33@@@@@
@@@  @p@  @@=q@@H@@@@z@R@@
=@@Q@@@  @R@  @ff@@߮@p@@ۅ@=q@أ@׮@ָR@@@@@z@@
@33@33@ҏ\@@Ӆ@=q@H@(@ҏ\@@H@Ӆ@{@\)@Q@أ@@@׮@p@(@ٙ@
=@
=@@p@@@  @@=q@Q@@G@
=@@@ۅ@(@ff@@\@  @@G@@AAA
AQAAAAHAA
AA\A (@
@Q@p@ff@R@@p@H@@
=@\@33@=q@ff@@ff@Q@33@H@߮@{@޸R@z@
=@  @@@z@p@\@{@z@@ٙ@{@=q@@@33@z@
@(@p@ff@@p@{@θR@  @p@{@θR@
=@θR@Ϯ@\)@G@  @@G@ٙ@\)@\)@@G@(@{@@p@{@\)@ff@R@A   @A Q@{@z@
=@p@\)@=q@Q@G@@
@33@=q@@R@(@
@߮@@z@(@p@\)@@@ٙ@ۅ@
=@
@33@У@\)@z@@z@
@H@G@G@ə@  @Q@G@  @@Q@ȣ@ȣ@H@
@z@@@У@љ@Q@p@
@@@ff@ƸR@ƸR@ƸR@ʏ\@
@33@@(@(@\)@@  @ٙ@@z@@p@G@
@{@A{ApA33AAA(A\A=qA{A@@  @ff@G@@(@=q@G@R@\)@@Q@@@  @\)@@=q@ff@\)@
=@@=q@(@
=@@@@
@@p@  @ᙚ@G@  @
=@
@@׮@޸R@z@޸R@
=@@@
@Q@ٙ@G@Q@Q@\@G@{@p@33@A (@@@ff@{@\)@@
=@@R@{@@(@\@@@@H@@@@=q@@p@@
=@\)@(@
@@@=q@H@Q@
@@Q@@=q@  @
=@
=@@陚@\@(@ff@
=@R@@@@ff@=q@(@@z@G@\@@{@@z@ᙚ@߮@@أ@ff@ff@  @  @@H@p@
@=q@H@H@ᙚ@陚@\@@33@@{@\)@@(@\@z@33@p@H@@@\)@@@=q@=q@{@\)@ff@(@33@@@@@@R@@@\@R@\)@R@R@ff@(@ff@=q@  @ָR@ָR@
@{@Ӆ@33@H@Ӆ@@33@H@  @@=q@G@
=@޸R@
=@@  @H@33@@p@{@ə@z@@  @θR@Ϯ@@љ@
@z@@(@ҏ\@@љ@G@ۅ@  @@33@33@\@@@@\)@
=@@陚@@33@@
=@33@@Q@@@z@ff@  @ff@ff@@33@G@  @\)@
=@z@=q@߮@p@@
=@z@Ӆ@ҏ\@У@Q@θR@@@˅@
@33@@=q@ʏ\@G@ff@  @\)@ҏ\@@(@
@
@θR@=q@˅@@@ff@  @G@@У@љ@@H@p@33@G@@=q@33@@@z@G@@@Ӆ@@@33@{@ff@ᙚ@@R@@H@@
@@Q@@@\)@{@@{@z@@陚@@@Q@
@@Q@\)@
=@ff@(@G@z@޸R@{@p@ڏ\@G@Q@=q@33@ff@(@  @{@G@(@@
=@(@p@ҏ\@Ӆ@=q@z@@H@p@z@ҏ\@p@(@\)@=q@z@=q@G@ƸR@{@H@33@p@
@Å@33@33@@  @@{@@
=@33@H@(@Ǯ@p@\)@33@@H@z@ff@Ϯ@33@H@ҏ\@ҏ\@33@=q@H@ff@@ָR@@@ff@
=@׮@
=@@  @Q@33@׮@
@ٙ@=q@ָR@=q@\)@
=@G@@
=@@ə@(@˅@(@˅@ʏ\@=q@@@ə@@H@˅@ə@ʏ\@˅@ʏ\@{@
@(@Ǯ@  @@p@H@@(@\)@@@\@@@@{@=q@Q@p@\)@\)@@@@=q@@=q@Q@@\)@{@@\)@@@@@=q@@H@Å@@@@@=q@@
@@ff@@
@=q@Ӆ@ָR@@ff@=q@ҏ\@ҏ\@ҏ\@љ@G@У@Q@Ϯ@p@  @@p@ָR@@(@(@(@z@z@z@@ff@ff@ʏ\@@@\)@ff@p@@ƸR@p@ff@ff@z@ƸR@ƸR@z@@Q@Q@=q@@θR@У@G@@@33@(@@\)@أ@@G@أ@ۅ@ڏ\@p@33@=q@ڏ\@޸R@@@z@{@\)@z@޸R@{@33@@{@أ@  @@  @
=@˅@@@33@H@Ǯ@z@@(@Ǯ@z@@@G@У@θR@@ff@@ə@G@G@G@ڏ\@33@{@ff@޸R@@\)@߮@Q@z@@@@@@R@33@@@ff@@@@33@߮@@  @
@z@Ӆ@(@p@
@
=@G@H@z@ff@  @@p@@@@
=@@z@@(@@@33@=q@@G@Q@  @
=@ff@Q@R@@ᙚ@H@
=@\@@R@@  @\)AHAA @@\@33@@  @@\@  @  @@ff@{@Q@
=@33@\)@׮@ָR@z@z@(@pAA@
@
=@\)A AGAA\AA@ff@33@\)@33@@{@Q@G@(@(@@
@{@@@R@陚@(@p@@
@(@(@  @\)@߮@߮@  @߮@\)@޸R@z@@@@  @ff@ҏ\@=q@љ@@  @HA   @\)@@p@ff@Q@@  @@=q@\@p@R@
=@(@@\@@@
=@
@=q@@=q@G@@33@
@Ϯ@@G@Q@\)@@=q@=q@z@@Q@@{@H@@\)@33@33@ff@\)@R@  @@@@R@p@@
=@ff@{@@@
@(@
=@ᙚ@@(@@p@@(@߮@G@  @@=q@@{@\@p@H@߮@Q@H@=q@33@\@=q@G@p@  @߮@p@@@{@{@{@޸R@߮@z@(@{@z@=q@׮@޸R@=q@Q@߮@
=@@  @ٙ@@H@љ@ᙚ@љ@ə@@p@@33@\)@\@(@p@@z@ffA QAA
=A33A\)A\)A
=AAAAA(AzAAGAAAQA33A=qA=qA   @R@(@@@33@@z@
@@A @Q@R@
=@H@@H@{@@@@@{@(@
@
=@{@ff@\)@@33@(@@{@@(@z@(@(@
@p@  @@@@@H@R@陚@33@{@G@
@@z@@p@@\@@ff@@\)@@{@p@ff@
=@33@H@@H@33@G@@@@@z@@ff@
=@=q@33@zA@@G@\)@R@
=A z@
@z@  @=q@\)@@H@@@33@
@ᙚ@@ff@
=@\)@{@޸R@@@G@G@@
@{@z@@R@@R@@\@
@=q@z@{@z@\)@
@  @\)@ff@33@@@(@G@\)@\)@ᙚ@33@=q@
@ff@޸R@  @ff@޸R@p@z@@@R@@G@z@R@
@A A   @\)@zA Q@{A QA zA AA @A   @A (@@R@\)A (A   @R@{@@33@=q@p@{@@\@@(@@H@33@
@\)@p@@@G@Q@@@Q@@33@=q@\)@\)@\@G@{@陚@\)@R@@{@G@@ff@p@=q@@Q@\)@ۅ@ᙚ@Q@@@{@@@  @@{@33@z@H@陚@޸R@=q@@\@G@G@@=q@z@\@p@H@z@H@\)@Q@@@33@H@@R@@@{@R@@{@R@@33@z@33@(@(@
@ff@p@@\@@  @z@@@=q@33@@  @z@@@@{@@z@
=@@@
@H@=q@@
@
@@޸R@\@\@(@p@@ff@@@z@=q@@  @\)@(@R@p@
@(@@@@@33@Q@{@{@ۅ@33@  @z@\@@ff@=q@@
=@{@\)@p@A A@33@@(@@ff@@\)@@@(@{@ffA QAAAH@A{AA(A33A  A  A(AAzAA
=A{@33@@p@@@A (@ff@@33@@
@@@\@@p@@أ@p@\)@@@G@  @R@R@p@p@\)@@(@33@G@@G@陚@@@{@R@@  @@@p@@  @p@ff@Q@@p@33@@@p@=q@(@z@@33@G@@@@
@@@pA   A=qARARA\A(A  AAzAAGAAHA
=A\AHAAAA  A\)A@=q@\@{@(@{AH@A A z@p@
@p@G@@=q@R@@\)@G@(@@H@Q@33@\@33@@@@
@H@33@@R@z@ff@{@
=@ff@R@@@@{@p@p@{@R@\)@@R@
=@  @Q@=q@陚@(@陚@ᙚ@
@@\)@@@H@\@33@(@z@陚@H@\)@\@  @A AHA
A{AQA@RA
A
RA
A
HAA(A  AAA
HAAAHA33A\ApAAR@R@{@@
@33@@p@@z@(@H@=q@@@G@@=q@@=q@=q@G@z@@@ff@R@
=@R@@@@@
=@
@@33@@G@\)@z@ڏ\@ۅ@Q@G@G@=q@߮@@H@\)@@\@ff@@p@@@G@H@
@p@
@
=@=q@@
=@@H@@z@\@p@@(@33A=qAff@@@@R@A AGA\)A(A@{@@\)@@(@{@
@p@@
@ff@\)@{@@p@(@R@@@\@33@@p@=q@G@ff@@z@z@\)@@@33@@\@33@@@Q@@@陚@@@z@
@  @=q@@@\@@ۅ@@ڏ\@أ@Q@
@ff@p@ۅ@p@@@z@@У@p@33@z@@ڏ\@z@@z@33@R@@@33@\@H@@{@33@@@\)@Q@R@Q@@\@@@@\@H@
=@@ff@=q@
=@@p@z@H@@p@  @z@G@ff@陚@
=@@陚@@@@
@
@@@\@G@33@ۅ@ۅ@@
=@@@@{@@z@Q@ڏ\@Ӆ@ff@θR@ƸR@{@z@
@{@У@z@p@@@{@
@˅@љ@ə@˅@H@
@G@@  @(@33@@z@  @\@\)@\)@\)@@ff@{@@@(@\@\)@p@@R@@@@Q@@H@{@R@@  @
@  @=q@{@33@33@(@陚@@\@H@陚@  @\)@R@G@ٙ@{@޸R@(@ᙚ@
@\@\)@@{@@{@p@@z@H@33@
@(@@ڏ\@H@=q@=q@ٙ@@ָR@{@
=@@׮@ָR@z@(@У@  @θR@ff@Q@Ϯ@
=@\)@θR@p@@p@@(@z@p@  @@  @ҏ\@33@@ָR@@׮@ۅ@H@Q@@{@
@R@@@@  @=q@=q@@@z@@R@ff@@@
@@G@=q@p@ָR@  @
@
=@=q@@{@R@G@G@@(@{@@@Ӆ@=q@  @@z@G@@33@ff@@=q@(@@G@=q@߮@޸R@޸R@@@ۅ@ۅ@׮@p@
@
@33@ҏ\@z@z@
@Ӆ@=q@z@ff@׮@Ӆ@
=@ҏ\@\)@׮@
=@G@G@ٙ@G@H@
@@p@{@޸R@  @  @  @G@@@@ff@ff@@33@z@@@@\@33@@=q@@@33@@G@@@33@@@=q@=q@@@ff@@\)@
=@
=@@@(@@@@{@z@޸R@@@(@@@@33@
=@\)@@(@z@ҏ\@33@33@@Q@\)@ə@
@  @@@ff@33@љ@љ@33@
@@ָR@{@  @ٙ@Q@ڏ\@(@@=q@@z@p@@p@\)@=q@߮@ᙚ@G@߮@(@ڏ\@z@(@أ@
=@z@\)@Q@{@z@  @@ff@@R@@@(@  @@@\@@=q@  @=q@@@G@=q@  @@@p@ۅ@@H@33@@=q@Å@
@@z@@
=@ə@
@=q@ȣ@@(@  @@\)@@ff@@G@
=@p@ƸR@Ǯ@z@θR@@˅@ȣ@\)@Ǯ@
@33@H@
=@z@p@{@\@@@@=q@ə@{@ƸR@@=q@(@\@G@H@ҏ\@G@@Q@
@G@
=@33@\)@׮@H@Ӆ@@ff@@
=@أ@@p@޸R@p@  @ۅ@ff@p@أ@H@
@H@Ӆ@33@ҏ\@=q@@=q@(@=q@@@  @@=q@љ@У@@Ӆ@
@33@z@(@=q@33@H@љ@љ@G@љ@Q@Q@У@Q@Q@p@Q@  @љ@  @У@@G@=q@(@@Ϯ@Q@@ə@\)@ff@33@=q@
@33@˅@33@z@z@@ff@z@@p@@ff@
=@{@@@@У@G@@H@@=q@  @33@33@
@  @ff@@{@ᙚ@ۅ@G@=q@أ@ff@{@
=@ff@@ڏ\@ٙ@@z@@θR@ə@Ǯ@@
=@@=q@ff@θR@ff@ff@@ҏ\@Q@Q@\)@H@{@ff@=q@@G@ff@Q@G@@ָR@\)@p@p@z@(@  @{@z@@z@H@(@z@Ӆ@Ӆ@Ӆ@z@H@љ@=q@ff@\)@G@У@33@z@33@z@{@\)@ff@@Q@θR@ff@  @љ@Ϯ@У@Q@G@ҏ\@
=@أ@ٙ@\)@=q@33@33@33@33@ۅ@
@z@@{@
=@߮@  @@G@G@@@@\)@@Q@G@@=q@=q@=q@@z@
@H@=q@ᙚ@ᙚ@=q@{@
=@߮@(@{@@=q@Q@׮@ٙ@  @Q@G@z@@33@ۅ@ۅ@H@G@ڏ\@H@@@@(@H@ڏ\@=q@H@p@{@G@@(@33@(@33@\)@\)@=q@أ@  @\)@  @
@G@Q@ڏ\@@p@ڏ\@=q@p@ff@ff@
=@߮@@ᙚ@\@33@(@p@\)@@G@@G@
@@@
=@@\)@
=@{@@@H@H@33@@{@@=q@  @
=@ff@
=@ff@R@R@{@(@陚@(@z@@@z@(@\)@陚@G@@=q@p@{@@=q@@  @陚@@p@z@
@{@=q@{@@@{@
@{@(@H@33@\@H@\@H@H@z@@@G@(@G@=q@p@R@R@p@
=@\)@R@@@@G@@H@z@@R@Q@@33@@@@R@R@
=@
=@  @@Q@Q@@{@@ff@H@\)@p@z@\@=q@\)@(@(@(@@33@33@\@
=@
@@@\@\)@ᙚ@=q@33@@  @@Q@@\)@@p@@Q@z@@G@@@ff@\@H@@G@ff@  @p@H@
@@@
@@H@@@=q@  @
@(@ᙚ@@Q@ff@޸R@@p@@ff@\)@߮@@\@(@(@
@@
=@@H@33@@@{@H@
=@Q@@H@@33@@G@@=q@  @
@
=@=q@33@
=@Q@p@@\)@ff@{@=q@33@ff@R@
=@R@ff@@G@陚@\)@{@(@@
=@@G@@@\@
@p@z@@ff@  @\)@{@ff@@z@33@  @{@  @ᙚ@{@H@ҏ\@\)@@=q@ff@
@z@@Q@H@ڏ\@أ@ۅ@=q@ۅ@޸R@
@޸R@\@@H@p@Q@\@ff@  @
=@@@  @33@
@H@=q@Q@@ff@@@\@H@H@z@p@R@p@
@ff@H@(@@=q@@@@޸R@(@33@ڏ\@
=@
=@\)@׮@
=@׮@Q@\)@G@
=@ָR@׮@Q@أ@@@@@H@=q@@=q@Ӆ@ff@θR@H@
@Ӆ@@
@p@Ӆ@=q@G@33@ҏ\@
@
@33@
=@(@z@33@p@{@ff@{@
=@ָR@\)@
=@
=@H@(@ָR@أ@\)@أ@(@
@H@@ٙ@
@33@z@
=@
=@ۅ@ڏ\@ٙ@\)@@\)@33@33@\)@Q@G@  @=q@@@p@@(@
@߮@Q@@z@z@޸R@@  @߮@p@@z@޸R@{@@z@
@ڏ\@ٙ@أ@
=@ָR@
=@ff@ָR@
=@ff@ff@p@p@{@@\)@  @أ@@@H@p@  @ָR@@ָR@@@G@
=@׮@z@\)@p@@@p@z@ָR@p@z@@{@\)@Q@أ@׮@Ӆ@@Ӆ@@\)@  @ٙ@G@=q@@(@ff@޸R@Q@@{@R@@\@
@@@H@@@\)@
=@@ff@@@@@z@@z@p@@\@33@=q@@ڏ\@@ָR@ָR@  @G@@@=q@@ڏ\@׮@@ڏ\@ٙ@@  @{@ָR@Ӆ@{@@@{@@@@
=@(@@p@{@ff@ff@z@@{@ָR@
=@ָR@ff@@  @H@ҏ\@Q@Ӆ@љ@\)@
=@@\)@@\@@ڏ\@z@Ϯ@ҏ\@p@ff@@أ@=q@z@p@@
@ٙ@=q@Q@@@G@@  @
@\)@@{@(@@ff@p@@@\@ۅ@=q@p@
=@@ff@@@H@ڏ\@  @ָR@ff@ff@@(@ff@ff@  @\)@{@\)@
=@
@{@љ@ҏ\@=q@33@H@z@У@ҏ\@љ@@љ@ҏ\@ҏ\@z@p@{@ָR@@
@  @Ϯ@  @\)@޸R@  @\)@ff@@@@z@H@@p@(@\)@=q@\@@p@@\@
@@\)@{@@@R@R@
=@R@R@R@@{@@\)@@p@ff@{@
@33@@(@33@H@
@(@Q@@ff@ff@{@{@R@@Q@@\@H@\@=q@陚@  @@G@G@Q@@G@@  @p@@@@G@\@p@@
=@@p@p@\@\@@@  @@\)@z@p@@H@H@33@H@陚@Q@G@G@  @=q@(@(@z@(@p@{@  @(@@@Q@  @@Q@(@@\)@
=@R@R@
=@@\@@33@z@@G@z@  @R@@\)@@{@陚@=q@=q@@(@\@33@@@@@@33@33@@陚@@33@\@{@H@ᙚ@@@@@޸R@p@޸R@޸R@@(@
@@(@(@@
@z@(@(@z@{@޸R@@H@@33@\@{@@{@
=@@z@=q@@G@陚@\@H@H@\@陚@陚@H@@33@z@@
@@@@@陚@
=@@@{@p@@(@\@H@@=q@33@z@@=q@H@@p@@@A@RA QAAAApA(A33A	A\)A	AffA	pAAGAA{AAA=qAAA
ffA\)A(ARA\AzAHAA33A"\AHA\)AApA
A\AGAffA
=AGAffA  A  AA33AffAA33AAzA zA"HA{AA  A
=AA(A
A\)AAA
=A
AA(A33A\)A{A
A
AAApARA\AARAA{A (A$zAA!pA QA\)A\)A(AAApARA
=AAA33A  AzAGAA  AAAAzAAGAA
=AA=qAffA\)ARA\)A=qA\)A
AQA
{A
HA
GAA{AGA\A
=A
{A33ARAA\)A33A	AHA
HA	AA
\A(AAAGA	GA	AQA
RAA(AA	GApAA=qAA @
=@=q@  @
@\@=q@@33AzAH@(AffA   @R@
@p@@(@@@@
=@p@R@R@=q@@@
=@@@@陚@Q@ff@  @
=@@Q@ᙚ@@  @@\@@Q@@@@@ᙚ@@@z@{@@H@H@߮@{@(@G@\)@\)@  @@ᙚ@\)@ff@ff@@@@H@ۅ@p@޸R@߮@(@G@H@  @33@G@Ϯ@Q@H@@p@ff@@  @ff@{@޸R@\)@
=@\)@p@z@߮@
@33@ۅ@\@أ@p@@@@\)@@z@G@(@@@@=q@(@
@(@߮@Q@
@ٙ@׮@  @@=q@\)@ۅ@Q@z@ʏ\@θR@@(@Ӆ@=q@
=@
=@@\)@θR@{@  @(@׮@H@=q@ҏ\@@@@p@@p@ff@ָR@@Ӆ@љ@H@
@G@(@@{@\)@\)@ָR@{@\)@ۅ@Q@׮@G@أ@@  @أ@أ@H@أ@  @׮@Q@@Q@G@Q@ָR@ָR@{@H@ٙ@ڏ\@  @H@ڏ\@ۅ@ۅ@p@@ۅ@@
@ۅ@@ڏ\@ۅ@@ڏ\@(@@Q@Q@ҏ\@=q@љ@Q@\)@љ@{@z@{@
@љ@@\)@θR@{@@θR@(@z@@@@@33@
=@z@ff@  @H@G@=q@@z@\)@
@(@G@љ@Ϯ@У@H@{@{@
@Ӆ@G@љ@У@θR@  @
=@ƸR@
=@  @
@@Ϯ@ff@Ϯ@θR@  @У@z@G@@@@@  @˅@G@Q@z@  @ʏ\@љ@z@@љ@θR@
@
@33@{@(@G@ڏ\@أ@z@@@@θR@G@  @z@
=@H@@@G@\)@ҏ\@@z@
@=q@H@@z@{@љ@\)@\)@@@@(@׮@{@\)@@@@@{@@Ӆ@{@z@@@ȣ@H@z@@@@љ@
=@\)@@@\)@@{@
@ff@ڏ\@@\)@@@G@G@@陚@@\@@33@z@@ۅ@(@(@ۅ@\)@ff@{@@
=@ff@H@@@@@z@{@(@@ᙚ@  @z@@=q@33@@{@
@
@ff@ڏ\@p@@ڏ\@{@
=@@@  @љ@Q@=q@33@z@33@θR@p@H@z@
@
=@Ӆ@ff@ָR@أ@@H@޸R@z@ff@33@ٙ@H@(@(@Ӆ@H@(@љ@љ@θR@Ϯ@@@  @=q@Ӆ@@
@أ@ڏ\@H@@(@\)@
@{@ȣ@Q@@(@׮@p@  @z@˅@ڏ\@ٙ@G@=q@  @33@޸R@߮@\)@
=@z@H@Q@33@@@p@Q@ᙚ@@޸R@@33@G@@ָR@p@(@p@  @{@׮@  @\)@{@\)@p@(@z@
@33@ָR@@@
@@{@أ@33@@߮@\)@޸R@
=@p@@
=@@p@\)@޸R@p@@@ۅ@ڏ\@p@(@@z@33@p@33@p@@H@@޸R@ڏ\@ff@@θR@У@=q@=q@(@أ@߮@H@Q@(@p@@R@@Q@@(@{@ڏ\@Q@G@G@G@ff@@߮@
=@@޸R@@@p@@ᙚ@33@@@@=q@
@@@@߮@@@p@  @߮@ᙚ@\@z@H@=q@@@  @Q@ff@=q@\)@z@H@@@
@  @
@ᙚ@@  @߮@(@=q@H@
@=q@{@أ@ָR@أ@H@
@p@@{@G@z@z@@33@
=@(@ٙ@{@  @z@(@@
=@@@z@\)@  @@Q@p@߮@H@@ڏ\@=q@=q@ڏ\@z@ff@  @@@R@z@R@  @=q@@z@@@@(@陚@陚@p@@R@{@{@@\@G@G@ۅ@33@@@@R@33@\@G@ff@@33@{@
@@(@  @G@(@{@=q@@H@33@@H@@{@Q@޸R@
=@
=@ᙚ@\)@@G@
@33@(@{@ڏ\@@@33@
=@ۅ@ٙ@
=@G@ᙚ@ᙚ@ff@ٙ@Q@=q@ڏ\@
@@@p@{@p@޸R@@
@H@
@
@
@H@ۅ@߮@z@ff@G@@=q@\@=q@ᙚ@=q@
@H@\@@@R@@  @p@z@G@ᙚ@@@@\@G@  @@ᙚ@@޸R@@ff@޸R@z@
@@(@
@ff@@33@@@{@p@(@p@
=@  @@\@(@@H@
=@(@ڏ\@ٙ@@Q@=q@33@@33@33@
@(@߮@@@Q@@(@ff@@@33@@p@  @  @޸R@@޸R@
@(@ۅ@@{@(@z@H@׮@ٙ@
@p@{@
=@\)@H@33@\@@H@33@@  @ff@ff@
@@ᙚ@=q@@@
@@G@(@@ᙚ@߮@{@޸R@߮@@H@H@@ۅ@@G@H@\)@ָR@@p@p@
@
=@p@@=q@ҏ\@H@Ӆ@@p@ָR@׮@׮@\)@  @@أ@@p@Ӆ@H@p@
=@׮@{@p@H@{@{@p@G@
@{@
=@p@@  @ٙ@@{@@Ӆ@ָR@z@z@Ӆ@H@Ӆ@
@
@z@{@{B33B33BřBřBffBB33BBffB͙B  B33B33BffB33B  BB  BffB33BffB͙B33B  B33B  B  BƙBffBBBBffBřB33BʙB33BffB33BϙBffB  BΙBBffB33B33B  B33BffBƙBBffBffB  B33B  B  B  B  BffB33B  B33B  B  BffBffBB˙BʙBBffB˙B33BffB˙BffBB˙BBffB̙B  BffB̙B͙B33B33B33BB  B  BBBBʙB˙B33B33B͙BffBBffB  BffBBBәB33BffBBәB33B  B33BՙBB33BffB33BϙB33BffB̙BB  BϙBB33B33BffB  B͙BB33BffB  B  B33BǙBffBBffBBBffB33B33BÙB  B  BffBB  BffB33B  BffBBBB  BBB  B33BB33BffB  B  BffBBB  BBBffBffBffB33BBBffB  BBBffBBBǙBșBBffB  B̙BffBB͙B͙B͙B  B33BBB33B  BB  B33B  BffB  BəBșBffBffB  BffBffBffBBffB  BffBǙB33BșB  B  BffBB  BB  BęBƙBffB  B33BB  B33BBB33B  B33B  B  B33B  BB  BffB33B  B33BffB  BffB  B33BBffBffBffBBB33BffBřB  B  B  BBffB  BffB  BffBffB  B  BBffBřBffBřBęBffBBBřBBBffBBffB33BffBffBffB33B  BB33BffB  BBÙBBffB  B33BffB  BffBBřB  B  B  B  BęB  B  B33BB  B  BB  BffB33B33B  B33B  B33BffBffBBB  BBB  B33BffBffB33BBBBffB  B33B33B33BBBBBBB  BBffB  B  B  B  B  B33B  BB  BffBBB  B33B  B  BffBB33B  B33BffBffB  BffBffB  BBBBřBffB33B  B33BffBB  B  B  BBffB  B33B33B  B33B  B  B  B  BffB  BffBřB33BffB  BB33BffBffBffB  BB  BffBB33BBffBffB33B  BB33B  BB  B33B33BffBB  BBffBffBffBffB  BBB33BBB  B  BÙBęB  B  B  BffBB33BffB  BffBB33B33BƙBffBB33BǙBBǙBffBBǙB33B33B  B  B  B˙B33BəB  B˙BffBffB  B  B33B33BffBBBffB  BșBBəBșB  BffBB  B33BBffB33BBəB  B  B  BffBBșBșB  B33BB  BffB33B33BffBșBffBBffB33B  BB33B33BB33B33BB  B  B  BffBBffBffBƙBB  BǙBșB  BB  BǙB  BB33BșBǙB33B33B33B33B  BB33B  BșBffBffB33BBBffB͙B͙B33BffB͙BΙBffB̙B33BffBffB33B  BffB˙BʙBʙB  BʙBffBffB  B33BffB  BBBB33BƙBřBęB33BęBÙBBBB33BBB  B  BBB33BBB  BffB33B33BBBffB33B33BBBffBB  BB  BęB33BřBřB  BęB  B  B  B  B33BffBǙBffBffBBffB  B33BșB  BffB  BffB  B  B  BșBəBB  BBșBBffBșBșBBB33B  BBffBffB  BffB33BB  BffB˙B33B33B33B  B̙B33B  BffB33B  BB  B  B33BƙB  B  BffBffB33B33B  BBǙBB33BBBBșBffBęB  BÙBffBffBBBęBB  BffB  BB33B33B  BəBffBffB33BǙBBřBBęB  B33BffBęB  B33B  B33BƙBBffB  BffBșBffB33B33B  B33B  B˙B˙B33B33B33BB33BBB33BB  BffB  B  B  B̙BffB  B33BffB33BəB  BəB  B  BB33BƙB33BęB  B  BBBffBBęB  BęB  BęBB  B33BęB33B  BęB33B33BÙBBBB  B  BffBffB33B  B33B33BęBřBBBřB33B33BęBffBffBBB  B  B  BǙBBǙBB  B  B  BəBʙB  BB33BffBBffB33BffBffBBffB  B  B˙B33BB  B  BffBffBBəBəB33BffBffB˙B  B̙B  B  B33B˙B33BřB33BffBBʙBB  BșBřB  B33BBșBffB  BBffB33BffB  BB  BffB  B33BB33BffB33BBřB33BęBB  BffBÙBB33BffBB  BB͙B  BffBffB  B33BƙBffBB33BffB  B33BBǙBffBffB33BffB33B  BffB33BffBffB33B33B  BԙBffBB  B  B33B33BBffB  BffBffBB˙BB  B  B33BffB33BffB  B33B33BffBffBffB33BffBÙB33B33B  BřBffB33B33B  B  BÙB33BęB33BBBřB  B33BffBffBęBffBffBB  B33BffB33B  BffBB  BB33B  BffB33B  B33BffBffBƙBffBǙBffB  B  BBffBffBffB33B  BșBBǙB  BffB  B  B  BBffBBЙB33BffBB33BBBЙB33BB̙B˙BəB33BffB33B  BffBB  B  B33B33BB  B33BffB  BffBB33BffBBBffB  B33B  BBʙB  B33B̙BʙBBB  BBęBffBffBBBB  BBffBffBBBffB33BB  B  B33BffBffB33B33BBB  B33BB33B33B33BBffB33B  BBBǙBșB  B33B  BəB  BffB  B33B33BB33BϙBffBffB͙B̙BB33BffB  B33BǙB  BffB33B  BBBffBffB33BBffBB33B33B˙B  BffBǙBBəBʙBʙB  BffBǙBƙBǙBB  BB  BffB33B33BǙBșB  B  BB33B33BșB  B33B  BBffB̙BB  BBffBffBffBffB33B  BBffB33BșB33B33BffB  B  BBBBffB  BʙB  B33BʙB  B33BΙBffB  B33B33B  BϙBffBffBffB  B  B  BB33B33B˙BffBffBBB33BffBffBљBBBffBBB  BB33BffB  BffBBffB33BBB33BffB33B33B͙BffB͙BffB33B  B33B33B  B33B͙B  BffB͙B  B̙BffBffBB̙BʙB33B˙BB  BB33B33B33BffBBffB33B33BיBBՙB33B33BؙB  B33BBЙB  B33BBBBBffB  BϙB33BΙB  B  BffB33BB33B  B  BB  BљB33B  B33B  BϙB33BBBϙBBffBffB  BߙBffB♚BffB33BffBBBBBffBffBffBffBffB33BffBΙBϙBffBB33B  B33BB  B  B33BffB  BffBffBffB33B  BBffBBęB33BffBBffBB33BffB  B33BҙBBffBBBљBBϙBϙB  B  B  B33BB  B  B  B  BffBffBҙB  BBBffBffB33BffBBB33B  BffBffB33B33BffB33B33BffBٙBBؙB  BؙBffBՙB33B  B33BיBB33BffBיBҙB  BՙBB֙BffBffB  BB33B33BBBљB  B33BffB  B33BffB33BffBB͙B33B̙B33B  BffBBffBffB  BʙBffBffBffBffB  BffBB  B  B  BB  B33BBBBffBЙB  BBB33BϙB33B33B  B  BBffB33BB  BBffB  B  B33B  BBʙBBBBffB  B33BffBB33BʙBBəBffBB  BffBBB  BBffBǙBBǙB  B33BffB  BBffBffB33B  BffBffB  B  B  B33B33BffBBffBBB33BB  BffBBBBffBB  BffBBB  B  BBÙBęBffB33BƙB  B33BBffBffBffBBB  BęBǙB  BffB33BffBBșBB  BBB  BffB͙BBЙB  BB˙B  B  BBʙB33B  BBffBffB  BB  BșBB  B  BffB33BǙBǙB33BffB  BBBffB33B33B33B33B33BffB  BǙBBBffB  BBB33B  B33BƙB33BffBffB  B  B  B33B  B33BǙBffB33BBB33B͙B  BșBffBB  BffBBBʙB33BB33B  B33B  BB33B  B33B  BffB  BBffB33BffBBffBљBB  BffBBBB33BBϙBBBffB  BffB  BffBffB  BffB  BB33BffB˙B33B  BB33B33B  B33BʙBəBffB  BffBBəBffBBəB  BəBffB  BffB33B  B33B  BBB33BffBB33B  BBǙB33B33BffBęBǙBəB33BșBB  BffBB33BB33B33B33BffB33BʙB  B  BffB̙B̙B͙BΙB  BЙBBB  BffB33BffBҙB33B  BBЙB33BљB33B33BԙB  BB  BΙB33B  B  B  B  BffBΙBffBffBΙB  B  BΙBB33B33B33BffB͙BBB33B33BB  BffBffBB  BʙBffBBBB  BffBffB33B33B33B33BÙBBffBBBBÙBřBB33BęBʙBBffBffBBBBffB  BffBffB33B  BǙB33BBʙB  B33BffB  B  B33BәBԙBBB33BffBffBffBBԙBԙBԙBәBffBffB֙BיBffBffBffBBΙBffB˙BffB33B˙BffB͙B͙BffB33B̙BΙB͙B33B33BffBffBBffBBřB  B33BB33BB  B33BffB33B͙BffBҙBffBffB  BBᙚB  BffBޙBffB  B  B  BB33BffB  B33BBٙB֙BffBיB33BBffB33BffBљB33B֙B33B33B33BBB33BBffB33BBBffBBBܙBBݙB  BB33BܙBݙBB33B33BBBffB33BܙB33B  B33B  BBB  BBffB33BffBڙBٙB  BؙBB33BffB33B  B  BיBB  B33B  BΙBљBΙBffBffBřBffB33BՙB  B33BʙB33BҙB  BҙB  BffBәB  B33B  B  BffBffB33BffB33BΙB  B  BB̙B33B33BșB  B  B33BffBffB  B  B33B33B  B33B33BB33BffBB33BBB  B33B33BffBffBffBffBffB33BBBffBffBffB  BB33BBBffB  BB33BffBB  BBffBÙBBBffBffBffB33B33B  BƙB  BșB33B33BBffB33B33BB33B33BffB  B33B33BęBBffB33B33B  BBB  BBBffBÙBBBffBBBƙBƙB  B  BB  B  BƙB33B  B  B  BǙBřBffBffBffBșBǙB  BffBffB  B33BřBBBBBffBB33BÙBffB33BffBęBBB33B  BffBB  BB  BBB  BBffBB  B  B  B  BffBB33B  B33BԙB  BffB33BΙBB33BffB  B  B  BffB  B͙BffBBffB33B˙BffB  BffBəBffB  B  BB  BǙBșB  B  B  B  BB33BffBffBƙBƙB  BffBffBffBÙBBB  BřB33B33B  B  B  B33B  BffB  B  B  BBBB33BB  BBB  BęB33BęBșB  B  BffBBffB  BșB33B33BBB  B33BBBBB33BffBљB33BffBЙBffB  B  BBffB33BffB33B  BB  B33BBffB33BB33B  B˙BBBBffB͙B˙B  B33BB33BBBffBffBB33BB33BBęB33B33B  BffBBBffB  BB33BffB33BBęBÙBBffBęBffBB  BBB33BÙBBffBBffBBBffBffBffB33B  BÙBBffBBBB  BBBffBffBB33B͙BΙBffB33BЙBBBəBffB33B̙B  BffBљBB  BΙBB  BffBBffB  BәB  B33BәBBՙBՙBffBڙBBffB  BffBB  BffB  B33BBffBBffB  BffBB  BǙB  BffBșBBffB33B  BB  BǙBffBB  BřBęBřBřBffBB͙B33BB͙BB  BffB33B  B33BB  BʙBBBffB33B33B33B  BffB33BBʙB˙B˙B33BffB33BffBffB  B  BBffBԙBffBffBffBәBљBϙBffBΙB͙B  BffBffBϙBffB  B33B33BϙBffBBffBBЙB33BffB  BҙBBffBffBB  BB  BB33B33B  BЙBffBљBBBBЙB  B33BB  BffB  B33BBffB33B̙BBB33B33B̙BffB33BB33B33B33BBΙBBB˙B  B  BҙBffBffB  B33BffBؙBؙBՙBәB֙BԙBffBЙB33B33B  BB  B  BffBffBffB  B  BffBܙBBיB33BߙBffBޙB  BݙBܙB  BffB33BٙBBߙB  B  B  BB  B33BB33B33B33B33B33BffB33B33B  B  B33BffBәBBBљBЙBBffB33BffB͙B33BΙBϙB33BffB33BǙB33BffBǙBBffB33BəB33BșB33BffB  B  BB33B33BffBB33B  B  B33B  B  B  B  B33BBՙB33BBB33BBffB˙B33B͙B33BffBBffB33BB33BΙBΙBffB  BB33BffB  BBffBʙBBffBffB  BB33B33BBB33BB  B33B33BB͙BffBffB33B˙B33B33B33B̙B  B33B  BffBffB33B  BBB  BB33BBffBBB33B33B  BřBB  BffBBƙBffBffBffB  BffBffB33BəB33BBffB  B33B33BBffBՙBffB33B33B33B  BBיBffB  BԙBB  BB  BәBB  B  BffBљBBffBәB33BffBԙB  BBffBBffBffBffBBBBB  B  BBәB33BB  BffBBffBffB  BBBܙB33B왚B33B33BBٙB33B33B33B  BBBBffBΙBBB  B  B33BB33BBЙB33B33BϙBBԙBffBffB  BffB33B  B33BffB33B  BϙBΙBB̙BBffBffBffBffBB͙BB͙BBffBЙBffB33BBBBB  B  BB  B33BϙB33B͙BB33B̙B33B33BffB˙B33BffB  BffB33BB  BffBffBBΙB33B  BB˙BʙBBffBBəB33BffBffBəBəBəBBBB33BffBffBffB33B33B  B  BBBʙB33B33BB33B33B33B33BffB33B33BB33B33B̙B  B  B  BB33B̙B  BffBΙB  BffBљBffBљB33BљB33B33B  B33BBЙB33BB  BffBBϙBB33B  BϙB33BB33B  BϙBϙBffBffB  B33BΙBBBB  B  B33BB  B33BBffBәB33B33BffB  BffB33BљBBB33BffBffB  BBffBffBffB33BBffBB  BffBBffBffBљBϙB͙BffB֙B33B  B33BΙBB33BffBB33BffBffB33BBƙB33BBB33B33BBBffB33BffBBffBB33BԙB33B  B֙B33B֙BffB  BBՙB  BffB33B  B  BҙB  BBffBffB  BљBffBB  BBԙB33BBffB33B  BffB33BBBݙB  BB  B33BffBΙB  BffB  BffBffBڙB  BיBffBffBBәB  BBBҙB33BBϙB  BBBBB̙BB̙BB  B̙BΙBBBffB33B͙B  B  B33B33BBBffBBB  BffBꙚBBB왚B33B33B33B♚B33BBffB33BBffBffBffBffB33BBBB  B  B噚B33B33B  BB33BBB  B33B33B33B  BffBؙB  B33B33B  BљB33B  BffBffBB  BffB  BЙB33BffBffBB̙BffB33B  BəB  BB33B̙B  B  B33BB  BB33BffBBBBBřBřBǙB  BffBffB33BffBBB  BBBB33BffBBffBffBffBffB33B33B  B33B33B  B33B33B  BffBBBffBffB33BBffB33BffBٙBיBB33B  BffB33BB  B  BffBәBBәBB33BBB  B  B  BBљB  BBffBՙB  B  B33B͙BB  BBffBffB  B33BBffB˙BffBffBșBB33BșBffB33B  BʙB  BffB33BffB  BBBBB33BљB33BҙB  B  BB33BffBffB33B33B33B  BBBәBBffB  B  B33BB33B33BBffB33BffB33B  BB  BffBffB  BۙBffBffBffBٙB33B  BٙBؙB  BՙBBBәBәB33BffBB  BљB  BffBҙBffB33B33B͙BffBBϙB33B  B  BϙB33B33B  B  BffBʙBffBB  B͙B  B  B33B͙B  B33B33B  B  B  BϙBBBffBBՙB33B֙BBB  B33BffBۙBffBBۙBBܙBffBBߙBffBߙB33B  BffB33BBB  B  B  B  B  BᙚBᙚBffBffBBBffBᙚBffB  B♚B  B33B33BޙBB  BЙB  B  BB  BB33BՙB֙B33B  BffBיBיBB  BffBљB33B33BB33BffBBffBBffBB33BBBffBffB33B  B33BB  BBBB33BB33B̙B̙BBBffBϙB33BffB  B33BffB  B  B  B˙B  BʙB  B  BB  B33B  BB33B33BљBԙBB  BffB33B֙B33B33BיBיB֙B֙B33BBffBәBffB33BffBB33BBBԙBB  BBffB  BBB  B  BBәBffBәBBffB33BәB  BBffB  BBBffBB  BB33B  BB33BəB  BBBǙB  B  B  BǙB  BffBǙBBffB  BʙBffB˙BB33BBB͙B33B33B33BʙB33B33B  B33BәB33BffBffBՙBՙBՙBBB  B33B33BffBBffB  BffB33BffBۙB  B33BBBڙBۙB33BffB33BffB  BffBۙB33B33BٙB  BBڙBؙBיBؙBBәBBffBB  BffB33B  B  BBffBBϙB  B  BBffBB  BffB  B33BəB33BffB  B33BffB33BǙB  BffBșB  BB33B33B33B  BBffBB  BBЙBЙBffBBffBљB  B33BBBffB  BљBљB  BffBffB33BיBؙB  B33BB  BؙBיBffB33BBffB  BffB  BB33BBәB33BBԙB33BffB  B  BffBffBffBB  B  BffBҙB33BffB  BԙBԙBffB  BffBffB33BffBB33BB  BљBҙB33BB  B  B33BB33B  B33B33BffB33B  BffB  B33BffB  BB33BљBřBƙB  B  BB33B̙B33B  BΙB̙BљBB33BffBB  BffBڙBؙB  B  BB  BBffBffB  BיB  BffBB33BffBB33B33B  B33BٙBffBffB֙BffBЙBәBܙB33BBBיBיB  BffBffB33B  BffBBffBBBB33BԙBҙB  BffBffB  BљBBәB33B  BB33B33BљBBϙB33BϙBЙB  BЙBffBϙB33B  BΙB  B33BҙBffB33BffB33BЙBBљB33B33BB  B  B֙BffBЙBBՙBB  B33BB㙚B33BB  B晚B  B虚B33BBBBB  BffBffBffBffBB33B  BB  B  B33BBۙBffB  B֙BBΙBffB33B  BBffB33BBЙBәB  BBB  B  B33B  BBϙB33B33BΙB33BffBffBϙBљBffBffBBffBљB  BffB  B33BffBffBffBffBffB33BΙB33B˙BffBəBB33B33B33B  BșBB33BʙB  B͙B33BϙB33B  BffBәB  B  BffBۙBffB  B33BffBffBffB  BBffBB  BBffBffB33BBBBffBՙBՙBB  B  BB33BB33BߙBffB晚B33BffB  BffBB晚B33B  B33BffB  BffBB33B33B癚B33B33BffB  BffBBB虚B33B33B陚B33BBBffB33B虚B33BB33B33BffBB33B33B33BᙚBBffB  B33BBBB왚BB晚BffBffBBffB33BBffBB  BBBB  BffBיBBܙBBBffBٙBٙB֙B֙BBffBffB  BffB  BәBffBBәBB33BffBBљB33B  BffB33BЙB  BffBBffBB33BffB33B33BffBB33B  BffBffB33B  B  B  BBřBB  BffB  BffB33BBBB  BffBffB  B  BffB  B33BffBBB33BBB  BB  B  BBffBB33BffB33BB  B  BBB  BЙBffB  B33BÙBBęBșBBęBB33BBBBffBBęBB  BffBffBB33BB  BffBffB  BBB  B33B  B33BffB33B33B  B  BBǙB33BffBBffBB33B33BB33B33B  B  B  BB33B  B  B33BffB33BB33BBBBB  B33BffBBffBBffBęBęBffBBffB33BęBřBBBffBƙBB33BƙBəBffB˙BBB  B  B  B33BBBB33BșB  B  BB˙BffB33BBʙB  BʙBffB  B  B  BffB  B  B  B˙BB  BBʙBffB33BffBffBB33BffB̙BffBB33BʙBBǙBBřBBBB  BffB  BBffB  BřBBBB33BBBffB  B33BBǙBffB33BBffB33B33BřBffBB  B33B  B  B33B33BB33BBřB  B33B33B33B33B  B33B  BBffBffB̙B33BffB33BffBffBffB33BffBBB  B  BBffBљBљB  B33BBϙB  BB  B33B33BffB33BffB33B33B33BϙB33B33B̙B  BBffB  BffB33B33B  BffBffBB͙B  BBBB33B  B33BΙB33BffBBB  B  B33BB33B33B33B  B˙B33B33BBffBffB͙BϙBffBЙBffBffBϙBffBϙBffBBBffB33BB  BffB  BffBffB  B33B  B  B  BffBffB33BBB33BB  B33B  BڙBٙBffBffBؙB  BB  BBיBיBffBB33BB33B  BB  BԙBB33B33BBBBffBәBffB  BљBBBBffB  BϙB  B  BffBBϙB33B33B  BϙB  BffBB̙B  BB̙B̙B  B  BƙB  BffBBffBffBřBǙB33BffBǙB33BffBBB͙B  BBBB33B  B33B33B33BBBffBBB  BBᙚBBBܙBܙBܙBffB33B33B33B  BB  BBBBffBB33B  BBBҙBBޙB33BٙB  BBB  B֙B  BҙBB33BB  B  B33B33BB  BffBffBۙB  BffB33BՙBffBBBBffBBffB  B  BffBBffBffBәB33B  BffBffB֙B  B33BBB  BBffB33BBљBffBffBB֙B  BffBffB33B  B  BffB33B33BffB  B  B  B陚B  B33BCCB  BBB33BBB33B33BB癚B  B33B晚B33B33BBffB  BBޙBՙBٙBffB  B  BBffB  B33B  BϙB  B33BЙB33B˙B˙B33B̙BB33BęBB  B33B33BffBƙBB33B  B33B33BBB  BffB33B  BffB̙BƙBBffB  BffBęBƙB  B  B  BffBԙB33B  BffBΙB  BffBיBffBffB  BBffB33BBB  BԙB֙BffBffBBәB33BffBffB˙B  BBffBffB˙B̙BffB˙BB33BBffB  BB33BBffBřB33BffBffB  B33B33BB33B  B33B͙BffB  B  B  B33BBB  BəB33BəB  BřBęBBęB  B  B33BęBÙB  BBƙBffB  BƙB  B  B  BBffB33BffB33B33BB33BBB  BBB33B  BęB33BƙBffB33B33BBB  B  B33BBB33B  B  BffBԙBBB33BϙBBBffBB33B  BffB  BffBBffB̙B33BB  BffB˙BffB  BBǙB  BƙBBffB  BÙB33BffBffBșBəBƙBəBffB  BffBBBffB  BB33B  BffB  B  B33BffBBʙB33B  BB  BǙBffBʙBʙBBB33BșBffBffB33BƙB33B33BffBB  BBffB  B  BffBB33BBB33B33BәBәBәB33BәBffB  BәBffBЙBffBffB  BٙBB  B  BffBffBffB  BffB33B33BffBffBٙBיB33B  BB  BffBffBffB33BBBffBәB  B  BffB  B  B33BffB  BffBBəBB33BBəBffB33BЙBB  BBΙB  BffB̙B33B  B  BB  BϙBϙBBffB33B͙B33BB33B  BffBBB33B  B  BԙB33B33BffBҙBB  BffB  B  BB33BB33BBBffB33B  BBffBB䙚B  B噚BBܙBBBffB  BBBBؙBٙB33B33BBB33B  BBәB  B֙B33B33B  B  BffBffBǙBəBffB33B33BșBffBƙB33B  BffB  BffBBBșBffB  B  BřBBffB33BBBffBffB33B  B  BBB  BBBffBșB  BffB˙BB33BBBϙB  B  B33BffB˙BB  B33BffB33BffB  B33BB33BBB33B33B  BffBffBffBۙB33BڙBffB  B  BڙBڙB  B֙B33BBffB  B33BffBBBЙBBϙBffB  B  B  BBЙBffBB  BffB33BBBЙBҙB33BffB33BΙBB33BΙB33BBffB  B33BBffB̙BBB33B  B˙B  B33B  BffBffB  BʙBBffBB33BffB33BBffB  BΙBffB33BBBB  BffB  BBBB  BؙBffBB33BؙBٙB33B  BۙB  B  B  BBڙB33B33BB  BffBffBffBffBffBԙB  BՙBffBBәBffB33B  BԙBәBљBB  BffB33BB͙BffB  B  B̙BBffBBffB33BffB̙BffBB  BBʙBffB33BffBʙB33BB33BB̙B33BʙB̙B33BBBffBffBʙB33B  B33BBBffB33B  B33BΙB33B  BBBB  BffB  B33BBBՙB  BՙB33B  BffBBԙBՙB33B  BBBffBffBffBBҙBљB33BB  BϙBBBffBϙB  BffBffBϙBB  BffB33BΙB  BϙBЙBϙBBϙBffB33B33BΙBffBffBffBffBBffB  BB33B  BBBΙBffB  B˙B  BB  BffBffB33BffB  B  BffBBffBffBB  B  BB˙BʙB33B33B33B33B33BffBBBffBϙBffB33BBffB33B33BBffB33B33B  BҙB  BљB33B  BҙBBffBffBffBBәB  BffB33BԙBB33BffBB33BffB  BҙB33BBffBBffBϙB33B  BϙB33BB  BΙBΙB͙BffB  B33B33B  B̙BBΙBffB  B  B33B33BʙBBBffBʙB  BffBBffBffB  BϙBffB33B33BΙBffB  BffBffBBffB͙B33BBffBΙB  B  BϙB33BB33BBffBffBҙBBBљBBffBB  BffB33B  BffBBBffB33B33BΙBBB  BffBЙBffBffBffB  BBffBϙBffBB33B33B  B33BffB33B  B33B˙B33BffBBBffB33B  BffBB33B33B33BffBB33B͙BϙBBΙB33BΙB  BBffBffBB33BffBB33B  B33BffB33BffB  BffB  B  BƙB33BBB  B  BffBB̙B33BBBBffBݙB  B33B33BBޙB  B  BffB  BffB  B33B  BϙBffBB33BB  B͙BffB33B  BffBffB33B  BBffB33BəBBBffBffBB33BǙB33B  B  BBffB  B33BBBffB33B33B33B  B33B33B33BBƙBșBBBffB33BB  BBB33B33BÙB  BffB  B  B  BřBffB  B33BffBBBffBBƙBffB33B  B  BǙB  BřBffBBBB  BffB͙BB33B  BЙB  B  B33B  BB  B  B33B  BffB  B33B33BʙBffBffB33BffB  BǙBB33BB  B  BșBffB  BffBBB͙BϙB  B33B33BBffB  B33B  BʙBBBșBB  B  B  BffBB  B  B  B  B  BffBÙB33B33B33B  BBÙBęB33BęBffBffB  BřBęBBB33B33B33B33B̙BB33B͙B̙B33B  B  B33BffBәB  BffBffB  B  BBՙBffB33B33B  B  B33B33BffB33B  BڙBۙB33BٙB33B33BB33BЙBffBљBЙB̙BǙBffB33B33BffBЙBҙBffB֙BBffB  B̙B33BB  B  BBB33B  B  B  BB33B33B33B33BffB  BBBęBęBB  B  BÙBB  BÙBB33BffB33BBǙB  BșBffBffBffB33B  B  BBffBffB33BBffBBffBBϙB  BB֙BffBB♚B  BBBffBffBffB33B  BۙB  BffB  BۙB  BffBڙBBffBffB  BB33B33BffB  B  B  B33BB33BffBffB33BٙBffBۙBBܙBۙBؙBBffBؙBڙB  BڙB  BBB33B  B  BBffBffBffB  BəBʙBșBBșB33BəBBffBffBșB  B33BffB  B  B  BffBЙB  B  B33BՙB33B  BؙB  BЙBʙBffBBԙB  BffBәB33BٙB  B33BBיB  B֙BBיBB  B  BffBיB33B֙B  BffBЙBffB33B33BәB  BљB  BޙBBۙB33B33BᙚB  BBBݙBffB33B  BffB  BffBؙBffBB33B  B33BffBBffBBBffBיB33BB33BffB͙B33BffBBB  B  B̙B  BBffBϙB  BۙBߙB  BffBBؙB33B33BB33B  B  B33BffBffB  B晚BC ffB33BffBffBffB33BffBC
BBBB晚B  B33B噚BffBffB33BؙBffB33BBffB33B䙚BBffBC  CBBC33B  B33BBB  BBᙚBffB֙BB  BB  B33B  BBB33B33B  B  B  B  BBBffB  BB  B33BffBBffB  B  BϙBBffBBљB33B֙BB֙BԙBffB33B֙B33BffBBܙBBBיBBљBBҙBB33BԙBԙB  B  BҙBәBԙBffB  B33BffBڙB33BBۙB33BܙB  B  B33BBB33B33B  BڙB33BB  BffB33B33B  B33BffB  BffBB33BؙBؙB  B33B33BיBffBיBיB33BffBB33BffBәB33B  B33BBB  B33B  BffB˙B  B  B͙BffBffBffB  BffB  BϙBBB33B33BB  B  BЙBffBffBffBffBB  BBffB33BffB33B33BڙBffBffBB33B  B33BB33B33BBB33B33BBffBBC CfCC  BC  BffBffC CC  B33BB  B  BffB  B陚B晚BffB33B33B陚B33BBB  B晚BffB33BꙚBB晚B33BBffB33BffBBffBޙB  B  BޙBBB㙚BffB  BؙBB  BBffB  B  B33B  BיB33B33BffB  B  BBffB֙B  B33B33B  B  BB33B33B  B33BffB  BB33BB  B  B33BB33B33BBB33BBBB33BBBBB  BffBBBB  BB33C  CLCLB  B  BffB  BיBffB33B33B  BՙBBffB  B33B  B  BҙBffB33B  B33B  BffBBB  BB  B33BәB33BәBffB33BBљB  BҙB  B  B  BBffBBffBffBffBffB  B33B  BB33BffB33B晚BffB  B  B33B噚BBB뙚B䙚B  B  B  BffB33B  BB33BBffB33BB  B33BffC fCC33CLC LB33B  BffB  B  B  BffBB33B33BB  BBffB֙B33B33B33BffB33B  B33B33BffBBљBB33BЙBffB  BffBBBB33B  BffBffB  BBҙB33B33BffB33BffB  BffBՙB  B33B  B  B  BffB33B  BffBۙB33BffBffB33B  B♚BؙBBffB  BB  B  BB33BBffBffBffB33BBBB홚B33B  B33B33BffBffBBB33BffBffB  BC CfCCB  CC33B  B  B  B33B33BffB33BBBBffB陚B33BBffBꙚB33BffBffB33B33B33BB33BffBB  B33BffB33BffBffBB  BffB虚BBffBBB33B33B  BffB  BB33BffB  BBBB33B뙚B  BꙚBffB33BffBB  BffBB  B  BCfC3CLCCfCfCC3CCfC3C33C	 C
fCffC
33CCfC33C  C  CffC
3C
fC33CLCLC C
3CC
 CffC  CBBffBB  BffBffC C  CfC CCC C fC3C C CLCC33CCCBB33B33BB33BB33B  BBffB  B33B  B晚BffB뙚BffB癚B虚B33BBB  BCffBB  B33BB33BffB33B33BB뙚B33BBB  BffB  BB33C3CfC3C CC33BCLCffB  BffBB  B33B왚BBBB왚BB33B33C3CffCfCC33C3CffCfCfC33BffBffB33BBBB33BffBB  B33CLC  C BCC C C33B  CB  B  BBffBB33BB홚B  B33B33B33BffB㙚B  BffB33B  BB33B33B噚BffB  B33B陚B  B陚B33B陚B33B  BffB  BB홚B33BB  BB33BB33B  B뙚B  B33B  BBffC   C B  B  B  B  B  B  BffBffB  B  B晚BffBffBB  BؙBۙBB33BffBffB33B㙚BffB33B癚BBBffB䙚B33B33BffB㙚B  B33B  B33B  B  B  BBffB䙚B晚B33B33B33BffB33BffBB  B33BB33B  BљB33BffB  B33B33BBؙBBݙBBffBBޙBffB33B33BBBB33B  BB  B  BffBffBffBꙚBffBBffBB  BffB33BffB왚BffBffBB33BffB33BffB33B  B  B33BffBB  BB33B  BՙBٙBffBBB33BBBBB33BؙBՙBBיBBffB  BffB33B홚B33BB癚B33BBݙBBBᙚBffB  B33B  B33B33BffBffBffBҙBB  B33B  BB33BЙB  B̙BB33B33BffB33BffB왚BffB  B晚B33BffB  B33B噚B噚B  B  BffB33BBB  B33BBBB  BBBBB33B  BB  BBB33B33BBB33BB  BB33B33B33BBffBBffBffB虚B  BB  BB33B晚B  BffB33B晚BBBffB33B晚BB  B♚B33BڙBffBޙB  BffB  BB  BؙBffBffB33BffBffBB33B33BffBBЙB  BϙB  B  B  B33B33BffB33BәBٙBܙB  B33B  BffB33BٙBBٙB♚B33B  B33BffB  BffB  BffB  B癚B  B  BBߙBffB33BBffBBffBffBffB㙚B33B  BBޙB33B  B33BBB33BBffBBBՙB  B  B33B  BәBffB33BffBffB33BffB33B͙BB  B͙B̙B33B˙BșBșBffBƙB  BBffBffBÙBffBB  BffB33BBBșBffBffBBB33BBB33B33BBffB33BB  B  B  BәB33BԙBffB  BBB  BffB33B33B  B  B  B  B33BBיBB33BBәBffBؙBffB33BB33BBBB  B33B  BBffB33B33B͙B33BffB33BffB33B  BǙB  B  BB  BffB  BƙB  BƙBffBƙBB33BffBBBBffB33B  BffBB33BBB33B33B  BBBffB33BB33BBB  BffBB33BBřB33B  BBB̙BffB33BΙB33BљBәBҙBBBffBB͙B33B33BffBߙBffB33BB33B  B㙚BffB33B  B晚BBffBffB  B33BffB  BBffBBܙBB  BffB33BBffB  BffBBܙBffBffBBBffB33BffBBffBB33B  BBЙBB33B̙BffBffBB  BffB33BB33BBBffBBəBBffB33B  B33B33B33BBʙB  BffBB  BffBʙBffBffB  B  B33B  BB  BB֙BٙBffBBffBffB  B33BߙBꙚB홚BffB33B  B  BffB왚B  B䙚B33BBBBꙚB  BBBBB33BffBҙBBəB33B̙B  BffBffB33BB33BB͙B33B33BffBΙBΙB͙BffB͙BffB33B  BffB33BǙBřBřBęBffBřB33B33BBęBffBəB33B̙B33B͙BffB33BʙB  B33BB33B  BBffB  BЙBffB33BB  B33BBffBBB  BәB  B  B  BҙB33B33B  BB33BBBЙBB33BBBBB陚B33BBBffB33BB  B33BB33B  BB  B33BB  BffB33BϙB  BffB33BffBffB  B  B  B  B晚BffBffBBffBffB虚BffB33B䙚B  B䙚BB33B33B33B  BffBԙB  B33BB33BB33B33B33BffBᙚBB33B  BᙚB♚BB33BBffBffB  B33B֙B֙B  B噚B虚B33BffBB33BBffC33CLCfB  BffBC  C C fC  CLCfC3C C	LC	C	33C	3C	C	3CfC	C33CffCffBBB  B33BB33B33BB33BB33B33B  BffBB  BיBffB֙BffBB33B  B33BBBBffB  B  BffBffBffBffBffB33BffBߙB33B33B  B  B33B33BffB  B  B  B33B  BffB  BffBffBBffBBBffBB33BffB  B33BffBBB33BffB  BٙBffBffB䙚BffB33B33B33B  BB  B33BB  BffC C33C33BC 33BBffB33BB  BffBffBffBBB  B33B33BBffBBҙB  B  BffB˙B33BffBffB33BʙBffBB33BffB˙BffB  B33BҙB  BB33BffBffB33B33BB  BΙBffBffBffB  B͙BљBffBffBBؙBBffB33B33BffBffB33BٙBB  BB  B  BBB33BBBffBffB  BB33BB33B33BB  B  BffB뙚B  B  B33BffBffBB  BәBԙBffB33B虚BB왚BB  BBffB33B33BٙBffBՙBffBB  BB  B  BB  B  B33BffBәBB  BffBB33B  B33B33BB  BffB䙚B33B33B  BB噚BꙚBBBffBffBffBBffBffBᙚB33B33BҙBBffBԙB33B33BB  BffB  B晚B33BffB  B  BffBBBBffBBBffBffBC   C fC	33C
CC  CBBB  B33C C  CffC	3C	ffC CfBffCC  B  B  B33BB  BB33B  B33BBffBBB  BffB33B  B  B  B33BB  BB♚BffB33BB33BڙB뙚B33B33B33BBB33BB33BݙBffBBBٙBBڙB33BffBffBffBЙBBЙBҙBؙBB֙B33B  B33BޙBᙚB♚BffB  BBB  B33B33BffBffB噚B  BffB33BffBBffCCffCLCfCCC  C LBB33BffC3CCffCLCCCC3CC33CfB  B  B33B  BBB  BffBffBB  B33BܙB33BB33B  BҙBBBffBƙBffBB33B33B  B33BBB33B  B͙B͙BB  BBB  BB  BBB33BؙB33BB33B33BϙB33B33B  BᙚBBB33B33B  B  B33B  BBffBffBBB33BB33BB33BB33B33B  BB33BB33CCffC3C CC
fCLC  C
 C
LB33CCCLB  BBffB  BBB噚BffB  BBB  B33B33B  BؙBffBffBBffB33B  B  B33BəBЙBffBffBřBffBB33BB33BۙBffBՙB33B  BB33B33B  BߙBBffB33BffBۙB  B33BB33BffBؙB33BǙBBBffBܙBB♚BffB  B  BBffBBB33B癚B  B  BBB33BffBBffBffB33BB33BBBBffB  BB䙚BffBB癚B왚B  B33BffBՙBՙB33BBBBBBٙB  BB33BיBffBB  B֙B33B33BBffB䙚BB33BB33B  BffBB33BB  BBffB33BBܙB33B  BBәBљBBffBBffB33BffB33BBBB33B33B33BЙBΙBffB  BBҙBffBBffBܙBBBB33BffBܙBBffB  BBffB  BBffBB  B  BffBffB33BݙB33BBffBBݙBBBޙBBBffBؙBؙBB  BB33B33B  B33BBҙBBߙBB㙚BffBBBBݙBffB  BB֙BҙBBљBB33B33B33BffBffB33BffB˙B33BB  BBffBʙB  BșBƙBffB  BffB  BffBB33BBB  BB33BΙBB33BϙB33B  BՙBffB  BB33BBffB33BB  B33B33BffB癚B33BffBBB  BBffB33BBffBB33B33B33B33BffBffBffB33BҙBffBBffB  BffB˙BBffBșBffB33B33B  BșB  BffBҙBffBBB  BBB  B  B33BB33B֙BBffBB  B33B33BBBϙBffB  B  B  B33B33B33B33BffB  BЙB33BB̙BΙB  B  BBۙB֙B33B33BffB33BffBޙBffBB  BꙚB뙚B33BffB33BBBB晚BffB晚B33B  BffBffB  BBBB33BBB33BBB33BffBffB33BB  BB33B뙚BꙚB噚BBB33BffBffBBffB  B  B  B  BffBԙBBBB33BB  B  B  BffB˙B33BBB33BB˙B33BB  BB33BǙBBffB33B  BǙB  B33BBffB  BffB  BΙBffB33B  BB33B33BB֙BәB33BәB33B33BBB  BCfCCBC 33C 33C BB  BB33B33BffB홚BffBB  B  BB33BB͙B33BBB̙B  BBB33B͙B33BBBffBffB˙B33BB33BffBB  BԙBЙBffB33BBBB  B33BƙB33B33BșBəB33B33BffBffB  BffB  BB33BҙBB  BB  BٙBڙBffB  BffB33BBffB  BB33B˙B33BљBffB33BЙB  BљBBљBB33BՙBffB  B33BB  BffBffB  BBޙBBBBffBٙB33B33BޙBB33B  BffBBffB陚B33BB33BᙚBܙB  B33BBߙBڙBҙB  B  B  B33B  B  BffBBB  B33B  BffBffBϙB˙BffBffB  BÙBffB33B  BB  B  BBBffBB33BffBffBBB33B33B33BBB  B33B  B33BBBB33BffBffB33BBƙB  B33B  BffB33BffBB33BffBB33B͙BΙB  B33B  B33BՙBԙBffBיB  B֙B33B33B33BҙBffBBffB  BΙB  BʙB͙B  BffBљBB33BBҙBݙB33BB33B  BffBB̙B  B  BffB˙B33BəB33B33B  BffBB  BB  B  BffB  B̙B̙BB33BffBBB  B33BBBBΙBBffBΙBٙB  B33B֙B  BffBffB  BҙB  BϙBB  B33B  B  B33B  B33BffB  BBffBߙBᙚB33BB  BB33BB癚B  BffB33BffB㙚BffB  BffBB33B  BBBffBߙBB  BB  B33B  B  BB  B33BB  B33B  BəBffBəB33B  B  BffB͙BffB  BffB33BB33BffBB33BffB  BB  B  BffB  B癚B33B33BffBܙBffB33B33B  B33BffB33BBϙB  B͙BffBB33B  BB  BffBffBffBܙBffBߙB33B  BffBffB  BffB䙚BffBffB33BB  B  B뙚BffBffBffB홚B33B  BBB뙚B  BffB왚B陚B33B33BBB癚B  B♚B33BBffB33BB33BBBB33B  B  BffB  BffB  B33B㙚B33B  BۙB  B33BB  BBBBԙBffBBBffBffBB33BB  B33BffB䙚B  B  BBB뙚BB  BꙚBffB33BB  BffBffBffBBB  B  BffBB晚B  B  B33BBffBBffB  B  B  BffB33B  BBB33B  BffB  BB33BB  BB  B33BffBB33B33B  B33B33B33BꙚB33B  B  B33B♚BffBB33BBBܙBۙB33BԙB33B33BffBffBffB  BBffBBԙBffBՙB  BЙBffB33B  BffBԙB33BBBԙB33BBffB33BڙB33B  B  BܙBB33BffB  B33B  BffBffB  B33BBffBBBffBffBffB33BBffB33C LC   B  BffB  BffB33B33CLC CC3C  CCfC33CLC3CCLC3C fBBB33B  BBffB  B  BB癚B33B  B  BffB㙚BffBBffBBffB33BBBffBffB33BB33BޙBffBffB  BBffBffBٙBffBffB33B33B33B33BߙBffB晚B  BffB33B  B뙚BB33BB33B33B왚B33BffB  BffBffBB  BffBB33BBBBB33B  BB33B  BCLCfCfC  C CC  C	C
 CLC  CLCLC	C C3CLCfCfCfC BffB  B  BBffBB  B陚B33BᙚBffBBffB33B33B33BffB͙BffBꙚBffB33B33BBffBޙBffB33BBffBBB  B  BffBיB33B  B33BffBBB  B֙B  BҙB33BffB  B33BܙB  B  BffBffB33B33BffBffB33B33B33BB33BB33C33CfCLCCC  CffCfC	C33C	C	3C3C	CCLC CC
 CC
  CC
  CCLC C  C3CffCfBBCBB  BffB33BffBffB  BB33B  BffB33B33B33B  B  B33B  B♚B  B33BffB˙B  BߙBffB  BBBffBBffB33BffB陚B  B33BB  B33BffBffB33B  BؙB  BB  BffBB  B33B֙BB  BffB33BBffBBffBB33B  B  B33BB33BffB홚BB  BBB33B  BffB  BBB33B33B33BffB33BB  BffBffB  BBB33B  BffB  BB晚B33B晚B  B33BBffBBB  B  B  BffB33BBffB왚B♚BffB33B  B33B  BBBffBЙB33B33B  B33BffB  B  B̙B  BBffB33B  BffB  BəB33B  BBBffB33BșB33BffBffBљB33BәBffBؙB33BؙBיB  B33BؙB33BBٙB33BޙBffBݙB  BBBꙚB33B陚BBBffB㙚B㙚BffB33B33BBBffBBBBBffBܙB  BٙB  B33B  BB33B33BB33BffB33B33B  BffBBffBffBBffB  BB33B33B33BB33BB33B  BB33BB  BBB  B33BBB  B33B33BB33B  B33BBB  B  BBB  B33B33B33BB33B  BB  B33BՙB  B  BBBؙBffBBBBffBffBffB33B  BBffB  B33B33BBB  BᙚB33BBB  B  B♚BB33B  B♚BB  B  BffBؙBBffB  B  BB33B33BÙB  BęB  B33BB33B33B33B  BBffBffB  BBBB33BBffBB33BffBffB  BBffB  B33BB33B  BBffB  B33B  B  B  BB  B  B  BϙBB  BB  BffBffBffB33B֙BB♚BffBBB33BBBBffB  B33BffBBәB33BڙBB33BffB  BffBffB33B  B33BBBffB33BB  B  BәBՙBB  B  BffB  B̙BʙBffB  BƙB  B  B  BșBB̙B̙BBBB33BB  B33BffBęB33BBBBB  BffBB  BBB33BffB33BB33BffB  BřBǙB33B  BʙB33B33B  BffB̙BBҙBB33B33B  B  B33BBۙBffBffB33BB  BBffBBffB33BBB뙚B뙚B33B  BꙚBffBB  B  BffB  BffB  BԙBؙB  BffBffBҙBffBBffBffBB33BBٙB33B33B33B33BʙBBffBBəB  BBffB  BffBffBB  BB  BffB  BB33B33BB33BffBffB  BəBəBB33BBB̙BffB̙B͙BBϙBffB  B  B33BB33BffBؙB33B33B  BffBffB  B  BffBBBffB33BffBBffBBљB  BЙBffBBBffB33BffB33B33B  BB  B  B33BB  B33BB  BBϙB̙BBffBffB♚B  B33BBBffB  BיB֙BffBB33B33B  BffB  BB  B  B  BffB33BB33BݙBffBBffB֙B  BffBB33BBЙB  B̙B˙BЙBՙBB33BBffB  B  BBffB  BיB  B  BۙBB33BB  B陚BffB  BBԙBBffBB㙚B33B  B왚BBB33BffB33BffBB33B33B  B33B虚B33BffBBffB  B  B33B  B33B  B33B  BffBBffBЙB̙BffBffB˙BҙBffBΙB33B33B  BB  BęBffBřB  B33B  B  B33BBffBBיB֙BffB  B  BB33B  BffBיB  B33B  B33BBљB  B33BB  B  BBffBBffB  B33BٙBffB  B  BB  BޙBffB  B  B噚BffBBәBB33BԙBBB33BffBB33B  B  BffB33B33B33BՙBffBڙB  B  BffB33BffB33BBʙBB  B33BʙB̙B  B  BffB˙BʙB33BʙBBffB  B  B  B33B  BʙBʙBffBffB˙B33BffB  BffB33B  BBBBBBřB33BǙB33B  BB33B  BBʙBʙBffBffBʙB  BffBffB  BffBffB͙B͙BffBB33B  B33B  B  B  BЙBBB  B33BB33B33B33BϙBffBBffB33B33B33B33BBffBșB  BəBșBǙBBƙBffB  BBffBBřBffBƙBffBBƙBBB  B  B  BřBffBffBffBřBB  B33BffBBřB  BBBffB33BBffB  BBBƙBffBffB33B33B33B33B  BəB  B33B33BffBffBBffBffBƙB  B33BffBșBBșB33BB33B˙B33BB33BB33BffBʙB33BΙB  BffB33BЙB33BffBBffBffB33B  B  BB  B̙B  B  B33B  B33BB33B˙B33BffBffB33B  BBB33BBB  BBBffBffB33BBffBәBBBʙBffB33BBҙBBʙBșB  BffBřB  BΙB33BBffB  B33BffBffB33B33BęBęBffBffB  BffB  B33B33B33BBffBřB  BșB  BB  B  B  B  BBB33BәBB33BҙB33B  B33BBffBffBffBBߙBffBB  B33B䙚BffB33B  B  BffB䙚B33BᙚBBffBBۙB33BB͙BB̙BffBʙB  BffBBؙBffBٙB  B  B33BB  BBΙB̙BBffB͙BϙBٙBݙBffBBߙBBffBϙBffBffBffB33B  B33B  B33BB  B33B33BBՙBԙB˙BffB  BϙB  B  B  BؙBՙBffBЙBϙBҙBffBޙBߙBffB  B33BBߙB33BB䙚B䙚B虚BᙚB䙚B  BBB♚BB  B  B  BBڙBffBؙBffBB33BffB  B֙BffBffB  BBB  BՙBҙB33B33BBffBBBffBB  BǙB33BəBffBBffBB  B33B  B33BޙBԙBB  BB  B33BBB  B33B  BəBffB  B33B  BƙB33BffBffB͙B  B33BՙBB33BffBffB33B֙B33B33BBBҙB33B33B̙BffB33BϙB  BЙBBffBffBffBB33BffBffBB  BffBۙB33BBffBB33B33B  BB  BBffBٙBffB33BBBB33BՙBBffBB  BBffBffB33B̙B  BB  B˙B  BϙBB33BBffBʙB33B  BʙB  BǙBB  BBșBǙBǙB33BBB  B  BffBffBffBB33BƙBffBffBB33B  B  B  BʙB33B̙B̙BffBBљBҙBԙBBיBBB  B33BBffBffB  B33B33B֙B33BffB33B♚B  B33BffB♚B33B33B33BۙB  BffB  B  B33B  BיBBԙB33B  BB33B33BBљB33BB  B  B33B33B  BBΙBʙBB  B33BיB  BB  B33BB33B33BB33B  BffB  B33B  B33B33B  BB33BffBƙBBffB  BəB  BʙB̙B33BΙB  B  B  BffBB  B̙BffBڙBBיB33B  BؙBۙB  BәBffBB33BBB  BBҙBffBffBϙBffBBBBffBffB뙚BBffB  B33BBB  B33BBߙB  BBffBB33BB33B  BB  BBffBڙB33B33BיBffBBBۙBBBיBԙBB33BڙBffBBffBB  BffBƙBB33BffB  BBBBBffBBәB33BffB33BffBԙBיB  BB  B  B33BݙB33BffBffBB33BBB  BB33BޙBBBB  B33B33B噚B33B  BBBffB  BffBffBۙBB33BffBB  B  B33BffB  B  BB  BBffB  BB  B  B  B  BיB  BBBșBffB33BB33B33BB  B  BffB  BәBffBB33BřBffB  B33BřB33B33B  B33B33B33B33BǙBəBBęB  B  B33BʙBBffBҙBffBBffB  BffB  B33BBffBB33BffB  B33BꙚB  B  B33B  BffBffBBffBB33BffB  BBffB  BffBffBBB33BٙB33BffB33BB33BffB33B33BffBffBffBBB33B̙B33BB33B33B33BəBBffB  B  B33B  B  BffB͙BΙB33BffB  B33BǙB33BəB  B33B33B  B33BƙBÙBBBB  BB  BșBffBB33BB  B33BBB  BffBffBBB33B33B  BffBBʙB33BffBB33B33B  B33BBޙB  BffB  BffB33BffBffBBBffB  BᙚB33BffB♚BffBٙBBffB33BЙB  BBB  B  BəB33B33BBBʙBBǙB  B  BBffBBffB33B  B  BffBffB33B  B33B33BBșB33BșBffB33B  BBBB33B  B33B  B  BB33BBBB  B  BB33B33BB33BBBB  BffBffBęBBÙBB  B˙B̙B͙BBffB  B33B  BffB33B  BffBBffBҙB  BۙB  B33B33BݙBڙB33BffB33B33BBffBՙBB  B  BffB33B33BBBșB33B  BffB  B  B  B  BBffBBB33BęBB33BřB  B33B33BęBBBƙB  BffB33BBffBęBBffB  BBffBffBBffBffB33B  BBffBB  B33BB33B33B33B  BřBșBffB33BʙBșBffB  B33BffBЙB33BB  BffB֙BיBBffB  B33B♚BffBߙBBB33BffBffBBיBҙB33BיB  B33B33B  BBffB33BffBƙBřBřBřBB  BBB33BB33BBffBBB  B33BęBBB33B  B33BBBBșBB˙BB  B  BffB  BBBffBBffBB  BffBB  BBՙBՙB33B33BBffB33BffBffB33BffB33B  BۙB33B33B33BᙚB  B33B  BB㙚BB  B  B33BffBBBffB陚BB33BffCB  BC LBffBffB33B왚BBffBؙBffBffBЙBffBљB  B33BϙB  B33BșBǙB33B33B  B  BǙBƙB  BffBəB  BƙBffBęB  B33B  BffBB33BB  BBBffBԙB  B33BB33BBÙB33BB33B  B33BB33BB  BB  B  BڙBffBffBәBԙB  B33BΙB  BffB  B33BffBۙBBffB  B  BBffBffBBBBBBC33C33CfCB33B  BffB33BffBffBB33BBꙚB䙚BBffB  BffB33B֙B  BؙBיBffB  BؙBffBffBffB  B33BffBB֙BؙBΙB33BBffBBϙBBיBffBB  BB  BB33BBffBB  B33BBffBBffBB  BffB֙B  BBffB  B  B  BffB陚B홚BB癚BffBBBꙚBffB33B  BB  BBffB33BBB  BB  C LB33BffC CCC CLB33BB33BffBB癚B  BBB33B  BffBffBBB  BffBBffBffBؙBffB33B  BffB  B֙BB33B  BBffBߙBBBBffBBBB♚BәBffB33BBffBҙBB˙BffBBBffBBffB33B  B  BffB33BffB33B  BffBBB֙BؙBffBffBffBffB  B33BffB33BB晚B陚B33BffB33B33BB  BBB  B  B  BB33BffBffBB33B33BC fC  C 3C33C C  C  CCLCffC CCLB33BB  B33B  B  BffB33B  BB33BB33BBߙB33B  BffBЙB33BffB  BB  BffBB  BB33BBęBffB33B33BffBffB  B  B  B䙚B晚BBffBBffBffBיBffB  B˙BffBffBB33BڙB33B  BՙBʙB  B33BBffBB뙚BB  B33BBffBBffBBB33BꙚBBB  B33BBffC ffB33C B33CC3CfC  CLC3CffCC	C BBB33B  BיBffB  BBBB33BBB  BB33B  BB33BffBBffBB  B䙚BffB癚BؙBܙBffB  BB33BޙBffB  BffB33B  BB  B33BÙBB33B  B  BƙB33BffBǙBʙB  B  BB33BB˙B͙BffB33BBffB왚BffB홚B33B33C 3BC CCCCfBffC  B33B33B33BBC33B33BBB  B  B33C3BBBB33C
BffBיB33B33BBBffB㙚B33B  BΙB  BљBffBB̙B  BffB  BљB33B  B33B  B  BffB͙B  BʙB33BBəBșBB33B  B  BșBșBffBəBffBB33B  BBffB33B  B  BܙBיB  BЙB  BBBܙBffB  BffB  BffB33B33BffB  B  BB  BffB  BBBffB33BBffB33BffBܙB33B  BB  BBffB  BBޙB  BffB  B33BB  BB  B33BBffBBB33BffB33B  B33BB  BffBBՙB33BBffB33B虚B噚BffBB  B33B33BB33B33B33BffB  BBffB  BBҙBB33B33B  B  BљB  B  B  BBffB  BəB̙BΙBЙBBffBffBBB33BBۙBffB33BffB33B  BffBޙB  BffB♚BBBffCCLBffBB33BC  C ffC33C33B33BB33BBB33BBffB홚B33BBffB  B33B  B33BB  B  BᙚB♚BBؙB  BޙBܙBיBB33BffBB33BffB  BǙBB  B˙BəB  BB33B  BڙBffB  B33BffBBffBffB  B  B33BBƙB33B33BBBffBÙB33B33BřBƙBffB̙BΙB33B33BΙBB33BBffB33BޙB33B  BٙBB陚BffB  B33BBB33BffB33BffBffBC 33B33BB33BffC BffB33B  B33BBffB33B33BffBffBܙB  BB  BffBffBB  BffBffBffBBffBۙBffBB33B  BۙBB33BB  BՙBΙBϙBffBB33BڙB33B  B̙BBșBffB  BffBffBffB  B33BڙBB  B  B  BᙚB  BԙBBB  B  B  B33BՙBיBԙBffB֙B33BffBffBB虚BB  BffBꙚBBB33BB33BffBBC LC   B33B  BBBffBBB  BffBffB  B  B  B  BB33BffBҙBBBBffBB  B33B33B  B㙚BBffB33BB  B癚B33B33B33BffBBЙBB  BffBҙBffBЙB  B33BffBffBΙBB33B33BBffBffBBBəB  BԙBffB  BffBBBBB  B  BffBBBBffBܙBffB33B33BۙBBBffB33BBB33BBffBڙB33BBڙB33BffBBݙBffBB33BBffBꙚB홚B뙚BffB33BB33BB  B33BBffBΙB33B˙BBəB  BffBϙBffBЙBffBffB33BB33BBęBƙBffB  BęBBffB  B͙BBffBffB33BffBʙB  B33B̙B33B  B33B  BffB33B33B33BffBBԙBBڙB33BܙB33BffB33BљBffB  B33BffBffBffBۙB  BffB㙚B噚BB33B陚B33B33BB  B  BBB왚B  B  B33B  BۙBC BBffB  B33B  BBffB33B  B33BߙB33B  B虚BffB  BBB33BffBBB  BffBB33BBffBԙBBљB  BffBffBB33B  BffBƙBʙBBΙB  B33B♚BBB33BffB33B33BffBffBB33BęBBB  BffB33B  B  B  B33B  B33B33BffBffB33BB  BBB  BffBߙB33BBBffBB33BB33B  BffBC CC CB33C LBCffCB33B33C 33BB홚BB33B  B뙚BffBB33BיBڙBBәB  BϙBffB33B  BffB33B33B  BΙBϙBffB  BBB  B33BffBƙBffBffBffBęBffBffB  BBffBffB  BffBB  B33B  B33BęB  BffBșBB  B  B  BffB  B33BffBәB  BՙBؙBۙBBߙBߙBᙚBBB33B  B33B뙚B33BBB33B  B  BB  BBBBB  BBffB㙚BBffBB  BffB33BffBffB癚B  BᙚB㙚B  BBٙB33B  BffB33B  B33B33B33BՙBffBffB  BәBB  B33B֙BB֙BBՙB33BffB33BBB  BffBffBffB֙BBffB33BffBԙBffBffB33BΙBBÙB  BřBBB̙BffBBBBٙBffB  B晚B  BBffBffB33BBBffB33BϙB33B  BffB33BffB33BBBٙB33BBB  BffBיB֙BffBffBBffB  B  B33B癚BB33B33BffB  B33B33BʙBffB͙BffB33BffB33B33B̙BffB͙BB˙BʙB  B  BƙBB33BB33BșB33B  BB33BB33BǙBǙBffB  B  BBB  B33BB  BBBBBB33B  B33B  B  B  BffBB  BBBffBBffB  BffB33BڙB33B͙BffBB͙B  B33BB33BBffBʙBBB͙BffBB33BffB33BB̙BBΙBffB˙BǙB  B  BffBBffB  BffBffBBffBffB  B  BřBB  BB͙B33B33BB  BffBffBBәBffBЙB  BB  BffB  BffB33BffB33B˙BB  B33BBșBB33BǙB  B33B  BffB33B  B33B33BəB  B  BffB  B  BBڙB33BffBB͙BBәB֙B33B  B  BCLCffBᙚBݙC B͙B33BBB  BB33BBffBB33B  CfB  BBC  C
 CLBffBffBBBBϙB33B33BffBBffB  B33BϙB  B33B33B33BݙBffBffB  BffBߙBffB  B33BffB֙BBB♚B  BBB33BffBBffB˙BB33B  B33BffBϙBB33BϙBB̙BǙB33BșBљBBffB  B  B  B33BBB  C   C 33C ffCC  C33C C33C	CC  CfC 3B33BB  BB  BC33B  BBC 3C C fC
33C
ffC  CB33BffBBϙB33BBΙB33BЙBffBBB33B33B͙B̙B33B  BffBB33BǙBǙBƙBB  B33BBęB  BffBffB  BffBřB  BffB33BB33B  BB33BffB  B33B33B33BB33BԙBBBffBޙBffB  B  B33B33B  BffB  BΙB  B  BffBәB  C33BffBB33BffB33BBB33B噚BB33B33BB  BffB  BffBڙB33BffC C ffC ffBffBBffBffBffBffB虚BޙBffB  B33B  BffBffBؙBffBԙBәBϙB͙BB  B  B33B  B  BԙBBB  B33BB33BffBffB33B33BϙBBϙBΙB  B  B̙B͙B̙B͙B33B33BBffBffB33BəBBffBffBffB  BBffBB  B33BffBBffBffBBffB33B33B̙B  B33BB33B33B33B  B  B  B33B  BffBBffB  BffB֙BffB33BBffBBB  B  B  B  B뙚BffB  BffBffB  B  B  BܙBffBB  B  B  BB  B33BܙBܙB33B  BܙBffBffBۙB֙BٙB  B  BҙBљBffB33BB33B33B33BBԙBffBB  B  B  B33BffBffB33B33B33BBʙB33B͙B  B33B͙BҙBffB  B  B33B33B33BҙBB33BՙBיBB  BffB33BffB  B33CLC ffC
C3C3CCfC
 CfC
  C33CBffBؙB33BBffBffBBffBBB33BڙBB  B  BB  B  B  BffB33BB33B  B  B  B33BB33BޙB33B  BBٙBؙB33B  B  BBffBəBʙB  BffBB̙BB33B  BB  B33B33BǙB  BșBǙB33BƙB̙BəB  B  BBęB̙B33B  B33BԙBՙBЙB  B  BB晚B  BܙB  BљB֙B  B33BB  BffB33B  B  BffBffBBB33BffBffB33B  B33B  B33BәB  BffB̙BʙB33BffBBffBffBffBؙBffB33B  B  B֙BffB33BB  BffB͙B  B  BԙBBffBߙB  B33BffBffBffBffB  B33BBB  B33BBffBffBәBBՙBB33BffBęB  BBB33BB33B  B  B  BffBBՙBBיBffBffBڙBBffB噚BߙBB♚B33B♚BffBBЙBB33B  BffBffBffB  BљBҙB33BffBЙB33BBՙBB33B  B  B33BԙBBݙBޙB33B33B䙚B33BBffBffB  BBՙB33BҙBBЙBBB  B  B  B33B33B噚BBBBBݙBB  BB  B33BBffBٙBәB33BBBәB33B  BB  B  BљB  B  B33BBΙB33BșB  BffB33BԙBBΙB˙BęBffBB33BffBffB  BΙBBffB33BffBffBBffB33B  B33B˙BB  B  BB  B33BffBBffBBffBBəB  BB33B  B33B  BƙBffBƙBBęBęB  B33BřB33B33B33BЙBΙB  B33BB33BBB˙BffB  B  B  BB33B  B33B33B  B  B33BffBffB  BBBBBBBřB33BBęB  B  BB͙B  B33BffBۙB  BBBᙚB㙚BffBffBB뙚BBffBffB  BC C33B33B왚BݙBB33BBB  BffB  BݙBffB33B  BBיB33BffBיBڙBffB  BBffB  B33BBffB֙B33B̙BffB33B33BffB33B̙BB  B  B33BffBffB  B  B˙BΙBffB͙B33BBffBBB33BB  B  B33B33BՙBBffBәBB33BB  BffBԙB  B33B33BؙBBffBBBBB33B33BB㙚BB33BffB33B  B˙BBffBϙB33BB33BffBffBffBffBBؙBݙB  BffB33B33B♚BB33B33BBBB  B  B33BffBљB  BיB33BffB33BffB33B33BBffB33BffCLBffBffBəB33BBBB㙚BؙB  B33BݙB33BB  BffBљBיBffBBffBBB  B  BBBBB  BffBҙBffB33BřB  BBffB33B  B33B33BB33BffB33B  BB33BB33B33B  B  B  BBBBffB33B  BיB33B33B33BffBB33BffB  BЙB33BffBffB33BffBBBffB33BB33B䙚BffB  B33B  BBB  BBffB33B虚BB噚B噚B虚B  B33B33BBٙBB33B  B  BBBB33B  BffBBffB  B33B  BBffBB  BffB  B33BBffBffB33B͙BB  B33BB33BB33BffBBBB  BBBffBBB  B33C CCLCffCffC3CLC
C3C  C33C3BBәB  BffB33BܙB33BffBffBBB33B33B♚BBffBffB  B33B陚B33B33B  B͙BBBBB33B͙B˙B̙B33BffBffB  BǙBBffBޙBB33BBՙB33BB33B  B  B  B̙B  BB33BÙB33B  BÙBffBB33BǙBB33BʙBffB  BBB33B33BBB  BBffB  BB33B33B33BᙚB  B33B  B  B  BBffB  BBB33BffB33B  B  C
CB  BBC33BffBꙚB33B33B  B33BΙB  BffBB33BBЙB33BϙBffB  BƙB33B33B  B  BBffB  B  B  BffB  BBffB33B33BB  BffB33BffB  B  BꙚB홚BffB  BffB  BffB33B  BffBffB  B  BffBffB  B  BBB  B̙B33BݙBBBB虚B33BffB癚BBB33BBϙBBϙBffBB33BB  B  BBffBΙBffB  BBݙBBB33B  BϙBB  BۙBffBffBԙBљB  BיBB33B33B33BꙚB33BBffBffBB  B33B  B  B  BffB33B33BffB  B  B33BffB33BBffB33B  BBBffB  B33B33BffBϙB͙B˙B33B  BffBB  BęBB  B  B33BB  B  BΙB  B33B33B˙BffBffB33BٙBיBffB  BB33B癚B  C 33CffC  CffC
33CfC C
LC3C33C33C CC3CC CCffCLC CfCC33CCLCC  C B  BC33C	 CfC33CffC fC BB33BffB  BB  BB33B  B33BBffBffBיBB  B  BBffB33B  BffBǙBB  B  BBffBB♚BߙBBB33BۙBB  BffB  B֙BB33BffBffBffB  BB  BffBᙚBB  BݙB33BffB33B뙚BffBB  B33B33C CLC  C33B33BffC3CC CfC	LCC BCLC CC3CC3CCLBffBffB33BBffBffB33BffBB33BәBffB  BffB  BΙBB33B33BՙBۙBBۙB  B  B33BffB33BљBϙBؙBffB33BBffBffB33BB33B  B  B晚BߙBBffBԙBB  B˙B  BؙB33BB  B33BffBBB䙚B33B䙚BB33BܙBffBffBBՙBffB33BffB  B33BBՙBՙB  BffB33BB  B  BB  BљBffB  B  B  B33B33B  BꙚBffBB33C3B33BffB33BB33BffB33BBffB33B㙚B  B♚BffBffB33B  BBۙB  BBffB  BܙB33B33BЙB33BffB33B  BffB  BB  BBBffB  BffB  BBBB33BəB33B˙B  BffBffBffBBיB33B  B  B˙B33B  B33BffBffB33B33BBffBffB  BB33B33BffB͙BB  B33B♚BB  C  C  CffC   BffBC BBB  CLC  BBB33BBB  B33BB  BffBϙBϙB33B33BΙBBBffBB噚BB  BB晚B33BBB33BB33B  B33B  BЙBB  BBB33B33B  BϙBffBB  B33B33B33B33BB33B  B33B  BffB  BffBBffB33B  B33BB33BB  B33BB  B  B33BB33B噚BB뙚BB홚BB33B  BCffCB  C33CC33CfBCC3BC CC
 C
C
3CffC3B  BϙBBffBB  B33B  B33B33BB̙B33BșBffBffBffB33BBřBBB33BB33BB33BəBffB33B33BffBffBřBffBffB  BB33B  BBBBBB33B  BBffBffBBҙBҙB  B33B  B֙BffBٙBיB  B33B33BffB33BB晚BffBffBBffB  BB홚BffB  B  B  CC3C C
  CLCB33B  B33BBꙚBffB33BffB  B33BffB  BffBBB33BffBffBffBBݙBݙBffBB  CfB33B  BߙBffBffBBBffBffBffB33BffB  B33BBBBBffB  BB33BB33B33BffB33B♚B  BC33CfBB33BffBB33C CLCfCCffC C  CC33CfC  CffCC33C33C  C33C C3C3C
CfCfC  C3C C3C  C 33C ffC  CfCffC  CffC  CB33B홚BBffBܙB33B  BBffB  B33BϙBffB  BřBffBB  BəB˙BBffB͙B  BB33BffBBffB  B  B33BBϙB͙B͙B  B  B  BffBBffB  BșB33BęB33B33BffB33BffBffB  B̙B33BBffBBҙB  BffBBBffBޙB  B  BBBB33B  B  B33B  BffB虚B癚B  B33B33B33BffBffBffBffBBffBBB33BffB33B  BffBB  B33BffBffB33B  B33BffB  B33BęB  B  BBBffBffBffBBffBB  BB33B  B  BffBffBB33BBB  B33BffBB  BBB  B33B  B33B33B33BffBșBəBffB˙BffBBffBffB  B  B33BΙB˙BBBffB  BB  BB33B  BffBB33BڙB  B33B  B33B33C BffB33B33B  BBffB晚B33B33BB  BBǙB  B33BЙB  BBB͙B  BBB33BB33B  B  BffBffBffB33B  BffB33B33B33BffB  BBBffB33B33BffBBffBBBB  BBffBB  B33B33B33BBffBffB  BBBB33BffBffB33BBB33BBffB33BBffB  BffBffB  B33BBffB33BffBffBBBffB33B  BBffCCffC3CC LBBffBffBB33BBffB  B  BݙBffBݙBffBffB  BB  BB֙B33B˙BffB  BffBffB͙BffB  B33B  BffBǙB33B33BB  B˙BffBffBǙBffBƙBffBřBBffBəB  B33B  BBBƙBB33BffB  B  B  BBBffBB  BffBBޙB33B  B33BffBؙBffBBffB  BC  B33B噚BB33CB  BBffBffBffBffB33B  B  BBיBB33BffBffBffB  B33B33B33BffBBB  B  BϙB  B33B  B33BBB33B33B33BBřB  BffB33B  BffB  BBB  B˙B33BffBB  BǙB  B  BffB  B33B33B33B  B33BffB33BBffBB  BBB33B33BffB  BB33BƙBB  B33B33BęBřB33B33B  BB33BffBCLC33C  C C	C
  C33C33CffCB  B33CffB33C B33B  B  BљB33B  B33B  B홚B  BB33B˙B33BffB  BffB  B  BǙBƙB33B  B33B  B33B  BffBęBB33B33BBB  B33B  B33B33BffBffB  BԙB33BBffB  BB33BffB33BB33BٙB  B  B˙BB33BffBؙBBffBffBٙB33B虚BB  CfB33BB  B33B  BܙC  B33B  BffBffBB33BBffBؙBffB33B33BffBffBffBҙB  BffB33B33BBBřBÙBșB  B  BB  BBffB33BBBәB33BΙB33B33BЙBB  BҙBBBffBʙB  BBB33B33BBB33BBՙBڙB  BffB33B  BB  BҙBBffBffBBffBBB  B  B  BB33BBB  BBB  BffBƙBffB  BB  B33B  BBB33BffB  BЙB͙B33B͙BffB  BffBB͙BBϙB33BҙB  B  B  BԙBffB33B  BBÙBBBffBffBƙBBBffB  BBffB  B虚B33B  B癚B33B33BB  BBٙBffB˙B˙BęBB  B33BffB33B  BҙBffB33B33B33BffBB  B33BB  BBԙBffB  BיBffB33BؙBۙBٙB33BڙB  BB  B噚BffB33BffBBffCC ffC CCC3CLCC	C
CC33CfCC33CLCLC  CCCffC3C
CC33CffC  BBffBffBBB  BB33B  BffBҙBBffB33BffBՙBԙB  B  B  B̙BBәB33B  B33BљBB  B33B  B  B  B  B  BBәBffBB  B33B  B  BBffBB33B33BBB33BBB  B33BBB33BffBffB֙B  B  BffBffB33B33B33B  B33C3BBffB  BBffCCC3C3B33BB  B33B  BffB  B33BꙚB  BB  BffBffB䙚B晚C33C
33CCCffB虚B  B33BܙBڙBffB˙BBʙB33B͙B33BffBffB  BۙBffB33B  B  BB  BffBBffB33BBBҙBЙB  BffBBffB  BϙBB  BffBB33BBffBffB33BffBBB33B33BffBffBBٙB33B  BǙB33B  B  BffBffB  B33B33B33B  BB33B33B33BBϙBffB33BffB33BBffB33BBBB  B33BffBBB33BffB  BܙB㙚B晚B㙚B  B33BB33B  BBBffB  BۙBۙB33BBB33BڙBB33B33BffBffB33BBBB  BBBBBffB33B  BffB33B˙BffBffBffBffBffB33B  B33B  B䙚BffBBffB33C C CC  CfC  C
 C
B33BffB˙BB33B  B33B虚B33B  BBBffB33BffBBۙBB33B  BB33BʙBʙBЙB  BffBffBffBB33BB˙BffBBB  BBBЙBBffBffBᙚB  BBBffB33BffB  BΙB33B33BffBəB33B  B  BB  BffB  BffBB33B  B33BřCCCCCC CffC33CfC33CCC C CffCCLC
fCffBBBffB33B33BB33BB  BB뙚BBB33B33B33B33BB33B噚BBffBffB33BՙBޙBBffBffB33BBffBB  B33CCffC
 C  C
LCCB  BffB  B33BffC  BB33B33BffBffBșBffB33BB  BԙBffBffB  B̙BBřBffBffB  BffB  BݙBffB癚B  B  B33BBB  BffB33BBffB33BffBBffBB  B33B33B  B  B  BffB  BÙBǙB  BǙBəBBBffBB  B  BBBffB  B33BBB33BBB  BBBB33C  B33B  BBB  BB  B˙B  BffBffB͙BBBffB33B  BffB  B33BBB  BؙBڙBBffBB̙BΙBЙBffBffBB  B33B  BffBB33BffB33BBffB33BffB  B33BffB  B33BřBęB33BffBffB33BffBBffBBffBB  B  BB33B  BB  BBBB33B33BBəBBÙBBffBBB33BBBB͙BBʙBffBffB33BffB  BB33BșB  B  BՙBۙBffBffBB噚BBBB虚B䙚BBBBffBݙBBBʙBəB˙BƙBffBB  B  BəB  BʙB  BffB33BϙB33B33B33BffBәBffBBBffB  B33B33B  BB33B33BB  B  BffB  BffB  B  B  BB33B33BBffB  BBffBԙB33B  BB  BB33B33B  B33C C CC C3C33C  C CfC	33C33CC
33C33BffBBB虚B虚BffBffB  BBB33BffB  B33BBffB  B33B33B33BBffBffBΙBBffB33BffB  BЙB33BƙBB  B33BB  BffB  B  B  BffBB33BffB  B  B  BBęB  BBBBBBBB  BBBffBffBBBffB  B  B33B33BBٙB33BB  BB  B  BB33B  B  BffB  BffBBBߙBBՙB33BϙBBBBҙB33BBҙBBffB̙B  BB  BffB  B  BffBљBBffB33B33B33B  B  BʙB  BBșB33BBffBǙB  BƙBBřBřBřBffB33BřBffBB33B  BB33BffBBffBBBBB  BBBffBBBffBB33BB33BffB͙BffB̙B33B  B  B  BffBB33B㙚B왚B  B33BC 3C LBBffBB홚BffB33B  BBޙBܙBffBB  B33B33BԙBffB33BffBffB̙B33BB  BffB  BffBBffBffB33BffBffB  BffB33BřB  BB  BffBffBffB  B33BffBffBffBřBBÙBBB33B33B33BB  B33BBB˙BffBB33BBffB33B  BBᙚBffBffB  B33CfCfCC  CfC3CLC  C
C
  CfCCC CC3C
3C  CffCCLC33CC  CC3CC LC3CfBffBB33BBBffBBffBffB33B  B33BBꙚB  BB虚B33B  BB33B33B33B  B  BffB33B  BB  BffB33B  BffB33B  B͙B33BϙBffBҙB  BffB33B噚BCLCLC
  C
CCCC  CfC3C
LC
 C
CfC33C  C33CffC LC  B  B  BffBB33BB33BBffB33BBffBڙBיBՙB33B  B33BۙB33BܙB33B33BffBBffBffB33BB  BB33B  BffBB  BB  B33BffBΙBB33B  BBٙBB33B33B  BBffB33BBB  BřB33B33BؙBC
CLCC
fC  CCC  CffCffC  C	fC33CffCfC CffCCfCC3C ffBffB  BffB  BffB33B  BBffB֙BffBBffB֙BffB33BҙBB  B33BיB33B  B33BBffB  BᙚBffB33BݙBffBܙBܙB  BffBۙBffBffB͙B  B̙B33B33BϙB33BB33BᙚBffB  BCCCC3BBC33CfBC C  CffC33CffC33CC	  C fC  B33BffB  B33BBꙚB33BB33B33BffBߙB33B♚B晚B䙚BڙBB  B33BffB33BffBٙBffB  BB33B홚B33BBffB33B33B  BBffB֙B͙B33BffBffB  BffB33BffB˙B  BBۙB33BB̙BB33BșBʙBΙBffBBݙB33BB  BљB  B33BffBؙBBBB33BB33BffBBffB33B33BffB  BffBffB  B33BffBB33BffB  B  BffBęB  B  B33B  BffB  BB͙BffBffBffBBBBffB33BęB33BBffB  B33BffB33BffB  B33BBffBffBffB  B  BffB33BBffBB  BřB  BffBBffBffBffB  BffB33B33BBffBBBBB  B33BffB  B33BB33BB  BB  B33BB  BffBB33B  BffBB33BBffB˙BB˙B  BBəB  BʙB33B33B33B  B  BffBffBffBBBB33BffBęBęB33BBffBBB33B  B33B33BęBB33BffB33BffB  BB  BřBřBffBffBBffBəB  B  B33BƙBBffB33B  BęBffBffBřB  BffBBffB  BBřBffBBřB33B  B  BffB33BBffBB  BřBřBffB33B  BBBffB33B  BBBƙBffBB33BܙB33B왚C LCC	CLC
33C
fC
C C  C	CC fC LB  C LC ffCC C  BB  BffBBffB  BB  BߙBffB33BBffBÙBBB  BB  B  BBffB  BffBffBʙBffBљBffB33BB33B  B  BҙB33B33BיBٙBffBffBBB͙B33BffBB  BBBB33B  BBBffBB  B  B33BB  BBffBBBB33B33BBљBԙBBBB33C  C33C  C
C
3CCfCCCC
LCLCCCfCfCLCfC  BBffC33CfC BffB  B33BBBffBB  B33B  BBꙚB33BffBۙBBffB♚BߙB33BffBؙBB33B  B  BޙB33B  BffBB  BffBffBffB33BffBęB33BBffB33BB33B  B33BffBB˙B˙B  BBЙBޙB33BۙB͙B  BffBBꙚB  B홚CffBBBffC33CBC CC3C3CCfCB왚BffBffB  BB癚B  B33BޙB䙚B33BB33BffB33B33B33BB  BffB䙚BݙBܙBB홚B33BffB33BBffB  B  BBיBBB33B虚BBB  BBٙBB33BBәB  BffBffBffBBBљBffBffBB  BBffB͙B̙BљBB33B33B  B虚BffBffB䙚BCLBCC33CfB33B33BffB晚BBBBffB  B陚B33B  B33BffBffBՙB33B˙BșB33B33B͙BB  BB  BڙB33BffB  B33BffB33B33BBϙBᙚBffB33B癚B  BB  BffBBB33B  B  B  BB33BffBBffBB33BffB33BBBB  BB33BB33B33BęBffBǙBǙBBBffB33BәB  BB33C33CfC	  C	C
 CCfCfCB  B  C C33BBffB  BffBBB  B33B33BffB  B噚BBffB  B33BB  B33BBffBffB  BBffB  BBΙBʙB33BB  BffBB  BڙBBBB33B33BBffB  BffB  BffB  BffBBBBffBB  B33BffBҙBffB  BBBffBBBBC C  CffCCCCCCCCC33C BBBffB33BBBB33BffB  BffBffB33B  B  BBۙB33B䙚BBffBۙB֙B  BffB  B  B  BBffB  BЙB  BffBBffBϙBBBϙB  BBB  BęBBffBÙBBBƙB33BB33BffB  B홚B  B  B33CC  C CLCCLB  C C33CC3B  BBBCBffBffB  BߙB33B  B  BffBffBB  BffB33BəB  BffB  BffB癚B왚B  B  B왚B뙚BޙB晚B  BB  BϙB33B33BffB33B33BęBB33B  B33B  BBBBǙBB  BǙBșBffB  BB33BffB  BffBBB33B33BffB陚B33B  BᙚB♚BffBB33BffBBBBffB뙚B  BffB  BB噚BffBffB33B  BB  BBffB  BڙBBBҙBffBיBffBBffB33BҙBљBBϙB33B͙BBșBƙB33B  B33BffBffB33BřBșB  B  B  BǙBșB33BϙB33BffB  BffBBBBB33BBffBffB33BffB  BBșBffBB33B33B33BϙB33BffBBB㙚BffB  BB  B  BffB33B33BꙚBffB33B♚B  B33BffB33B  BffBBffBB  BBBffB33BΙBљB33BיB33B33BљB33BљB  B33BffB  B33BffB33BBffB  BʙBB  B  B33B˙B33B  B33B  B  B  BB  BBB  BffBBBϙBBԙBBffBBffB  B  B  BffB33BB  BBCffCffC	33CC33CC33CC33C
33B虚C	  C
LCC3C
3C33BffBffBBޙB33BffBB33BffBB33B33B  B  BЙBffBBΙB  B33BBB晚B  B  BBᙚB33BB  B33BB  B33BffB33BᙚB33B33BٙB  BffBB  BB33B  BЙBffBޙBB  BffB  BBffB  BBB33BffC33C  C33CfCBffBCffCC LB  BffBffB33B33BBffB  B홚BB  B33B왚BB  B㙚BffB  B33B33BBffB  B  B  BffBޙB33B33BB  B33BffBәBBffBffB  BB  BљBffB33BffBϙB33B  B  BffB  B  BffBB  B33B33BݙB  B  B晚BffB33BBffBBffB33B33BCB33C CLC	33CLC CCLCLC3C BC 33C  C3C CLCffCCCfCffCCfC  BBB㙚BۙB33B  B33BᙚBB33BffB33B  B  BB  BЙBԙBffBՙBffBffB  BBᙚBBۙB33B  BBBڙBffBB  B  BB  BBB33BBffBffBffB33BљB33BffBBB  BB  BB33BB33BB  CC 3B  BB33CffC  C
fC
33C
fCLCffCLCffC
C
LC	C  CLB  CLB33B  B  BBC3B  BffBffBB  B  BffB  BffBBffBޙBߙBڙB33B33BԙBffBffBffBBffBffB  BǙB  B  BffBBB33B  B33BƙB33BBBBBәB33B  B33B33B33B  BԙB33B  BBB33B  B33BffB  BB33C CLCC CC3CfCfCC C33CLCfCCffC  CCCfC C33C LC fBB晚B  BڙBB33BBB33BffBffB  B33BљB  BffB  B  B˙BBǙB  B33BęBřBffBřB  BffBffBB  B  B  B33B  BB  BљBʙBffB  B33B33B33BffB̙B33BffBB  BB䙚BᙚBޙBBffB  B  BBBBB33C   C CLC
 C C  C  CfCLC
ffCLCC	LC	ffCfCB  B33BB33BܙBBffB  B33BݙBffBffBڙB33B33B33BBffC BffB33B  BffB33B  B33B  B  B33BBB33B  BB33B  B  BB33BBB  B33BffBffB䙚B  B왚B33B  BffB33B홚BffBB  B  B33B  BB33BBB  C  C
3CCLC
LCC CffC
ffCLCffBffC 3BB  BffBBB  B  B33BffB晚BffB33B  B뙚B  BffB33B㙚BBޙBffBЙBԙB33BBЙBffB  BΙB33BffB33BޙB  B33BffBBޙB  B  B33B33B  BB  BffBיBB33BݙBݙBB33BՙBB  BffB  B  BffB  B  C LB33B33BB33BffB虚BB  BB33BffB33BffB왚BffB33BꙚBBB33B  BffB33B  B晚B  BffB33B䙚BffBB  BB  BffBՙBffB  BffBffB  B33BԙBffBҙBffBffBBB̙B  BB33BəBffBBęB  B  BșBșB  BB  B  BffB33B33BB  BęBÙBBffBǙBBBəBffBʙB  B͙BBffBB  BffB  B  B  B33BffBffBܙBffBߙBffB33BffBB  B♚B  BBffBffB33B33BBffBB  B  B  BB33B33B  B33B33B33BB33B33BBffBBB  BffB33B  BBB  B  B33B33BBBffBffBB  B33BBffBffBBffB  B  BffB  BffBffBBB33B33B33B33B  BBBffBffBΙBәB֙BBؙBؙBffB  BB33BffBffB33B  BBڙBBffB33BBffB33B33B  B33BB  BBBffBՙBB  BffBffBffBB33B33BBffBBffB  BBBffB33BB  B33BBB33B33BffBBffB  B33BB  B  B  B33BB33BBB33BBffBffBB  BffB33BffBffBBB  BffB33BffBB  B  B  BffBffBřBB  B͙B  B  B  B  B֙B  B  B  B33B  BB33BBffBffBЙBB  BffBBęB  B33BBffBBBBBB33BB33BBB  B33BB  BffBffB33BBBBB  BB  BBBBBB33BBBBB33BB  BffBffBBB33BB33B33BBffB33B33BBBBBB  B  B33BffBB33B  BٙBffBBffBffB  BffBffB33BffBٙB33B  B33BۙB33B33B  BBB33BffBǙB33BffB  B33B  B33B  B33B33BƙB33B33BBB33B33BffBffBB  BB  B  BB33B33BęBffB  BBřBřBffB33B33B  BBBB  BBffBB33B  BB  BBffBffB33BffBBBB  B  B33B  BBffB33BBB  BB  BBBffBřBƙBʙB˙B  B̙BB33BϙB  BB33B33BffBffBBBB33BC fC33C CfBffCB33B33BB  B㙚B33B  B  B  B33BffB͙B  B33BffB33B33B33BffB  B33BBBB33B  BB  BBB  B  B  BffBB33BљBBB  BffBffB33BffB  B  BffBBBBB33B  BffB33BB33B33BBBffBB㙚BffBᙚB陚B  BBffBffB33B  BB  B虚BBۙB  B  BffB  B  B  BBB  BܙBffBBffB  B  BffBԙB33BB  BffBǙB  B33BBffBffBBffB  B  BffB33BBBB  BB  B33BBffBffBffB  BBffB33BffBB33B  BffB  B33BBB  BffB33BffBB  BB  BffBBߙB33BޙBffBٙBffBB33B晚BffBffBBꙚB33BB  B  BBffBB33B33BڙBB33B  BffBffBԙBՙBәBBffB33BffB33BffB33BBffBB33BBBffBęB  BffBřBřB  BffB33B  BBƙBÙBBBÙB33B  BffBB33B  BBffB33B  B  BffBB33BBBB  B˙B33B  B  BB  BיB  BB33B33B  BBB33BBB33B  B  BBڙB  BᙚB33B33B  B  B33BffB  B  B33BffB֙B  B33B̙B  BҙBԙB33B  BffB33B  B33B  BffBffB33BffBəB33B͙B͙BљB33BҙBB  B33BΙB33B33B33BB  BBBBffB  B  B33BƙBB  B  BB33BB33BϙB33B  B33B  BffBB33B33B33B  B33B33B  BB  B  B  B33BffB33B  BBffBB  BffB  B33BB  BBǙB33BffBffBB33BB  B  B  B33B  BBBffB  BffBBB  B  BÙBBBBBBB  BBffBffBBBBffBBffBBffBBBBBffBB  BffBffB33BffBΙBffB  BؙB33B33BB  B33B33BBәB33B33B̙B  BǙBffBffBBƙBBƙBffB33BBffBBB33BffB33BB33B33BBBffBffBffBffBBB  B  B33B33BB33BBffBffBffBBBffB  BB  B33B33BBBffBBffBBBffB33BƙBB  B  BΙB  B33BBЙB  BffB33B33B  B  BЙBffBffBffBBffB33B  BffBΙBffBBffBffBffB33B  BffBBǙB  BBęB33B  B  B33BffB  BffBBffBB  BBB  B33B33BBBBffB  BffBBBBBBBB  B  BffBBffBB  B  B33BffB33B  B33BBBϙBҙBffBBB֙BffBffBBBB  BffBߙB33B33BBBffB♚BffB33B  BffB㙚B  B33BffB  B33B  BߙBffB  BffBЙB  B33B33B˙B  B33BffB˙B33B33BffB  BB  BəBșB  B  B  BB  B33BffBB  BffBBBBBBBęB33BffBBߙBBffBffB33B  B  BffBۙBB  B  BٙB33BffBffBBB虚B  B  BffB  B  B왚BffB  BffB  BB  BffBBffB֙B  B33B33B33BB  BB˙BffBffB˙B  B˙BffB33BBffBBҙBffB33B  B  B  B33BљBBљBffBΙB̙B33BffB̙BəBffBB33B33B33BřBBəB33B33B  B  B33BB33BBB  BBBBffBffB  BffBB虚B♚BBBffB33BBffBB33B♚BffBBB  B33BffB  B䙚BۙB33BffBۙB  BB33BҙBB  BϙBBffBffBffBB33B  B  BЙBffBffB33BB  BffB  B  BffB33BBęBřB  BffB  B  BԙBffBBٙB  B33B  B  B33BffB33B  BBBffBB뙚B  B33BBB  BٙB  B33B33BԙB33B  B  BffB33BҙB  BBBffB33BffB33BB  BʙBffBB33BffBٙBՙB  B33BBڙBffBBB33BffBљBffB̙BffB33BʙB33B  BәBffBB  BϙBљBәB33BB  BffBffBB33B  C3C3CfC  CCffCCffCfCB  BBB33BBB33BBffB陚BB  B33BᙚB  BffB  BffB  BffBffB33B  BBffBBᙚB33B  BڙBBffB  BffBיB  B33BffBΙBBffB33B̙B  BffB˙B33BəB  BB33B̙BffB33BffBffBΙB33B  BffBԙBffB  BB  B33BffBffBB  B33B֙BffBՙB33B  B  B֙B֙BB33B  BۙB  B  BB  BB  B  BB33B33B  BffBffBЙBffBəB  BffB  BB33B  B  B33BBffBB  B33BffBBBB33BffBBffB33B33B  BBB  BffBffB  B  BffB  BB  B33B  B  B  B  B  B33B  B33BșB  BBșB  BffB  B  BǙBffB33BffB  BҙBؙBffBffB  B  BB33BffBffBffB33BBffB  B  B  BffBBڙB33B  B̙BffB  BB33B33B33B  BęB33B  BBÙBBffB33BƙBęBffB̙BffBBʙB  B  B33BBřB  B33BB33BffB33B  BBffBB33B  BffBBB  BB33BBB33B  B33B33BBB  BffB33BϙBϙBffBffB33B33BffBݙB33B  BffBffB  BBffBffBffBۙB♚BۙBBBffBB33BB  B33BffBϙBffBffB33B33BffB  BBB33B33BffBffBƙBřBBBB33BBffBBB  BBBffBB  B33B  BBBBBB  B  BffBB  BB33B33BB  BBB33BffBffB  BB  BffBÙBffBffBffB33B  BBffB33B♚B䙚B  B33B  B33BB  BffBBffBffBBBB33B  B  B33B33BBBڙBڙBBffB33B  BffBBBffB  B33BљBʙB33B  BBBݙB33B  B33B  B  BB33BșB  BǙBffBffBəB  B̙B  B˙BBB˙BB33BffBBffB  B֙BffB  BBBffB  BffB陚BffB33B  BBffB  B33BB  BBBffBBBBBBffBB33BffBݙB  B33BffBۙBffBB  B33B33BؙBBٙB  BffBffBۙB  BݙBBffBݙB33B  BܙBB  B33BיBBffBffB33BffBBB  BBЙB33BƙBƙB  B33BffB33BffB̙BәBәB  B33B33B33B33B33BᙚB33B33B  BffBB  BBffBߙB33BB33BۙB  B33B  BffB䙚B뙚B陚B  BffB33B噚B  BffB  BߙBBB  B33BffB  B33BffB  B33B  B  BffBƙBBffBffB  B  BÙBffBÙBəB͙BB33B33BffBffB33BBffB  BBffB33BB  B33B33B  B  B  BffBB33BǙBB33B33BǙB  B  BffBB33B33BԙBB33BؙBBffB  BB33BffBffBBBffBB  BB  BffB  BffB  B  BffBffB33BBffBB֙BԙBҙBB  BǙBffB33B33B33BBB  BBB  BB  BBffB  BffBffB  B33BffB33BffBBB  B  BffB  BBBÙB33BBffB33BffBB33BBBffBBffB  BBƙB33BffBffBffB  BB33B33BҙBԙB  BBffB33B33BffB  B  B  BڙBffB  B  B  B  B33B  BffBBffBBBBffBՙBBՙB33BffBffB  BB  BǙB  B33BB33BffB  BřB  BffBffBƙBffBęB  B  BB  BƙB33BęB  BBB  B  BBffB33B  BBB  BBBBBBBffB33B33BBffBBffB33BB33BffB33B33BffB  B  B33BffB33BB33B33BBBB  B  BəBʙB˙B  B33B33B̙BffBBffBЙBffBBffBffBřB  B  BBffBffB33BffBffB  B33BB33BBBffB  B33BffBBB  BffB33B33B  B  B  B  B  BffBBBBB33BBB33B33B  BB33B33B33B33BffBBBffB33BBBffB  B33BB33BffB33BB33B  B33BB33B33BffBffB  BB33BBBBB33B  B33BB  BBffBșBffBB33BffBęB33BffBffB  BffBșBB  BffBffBffBBBBBBBffBBBBffB33BB33B33BBBBffBB  BffBffBffBB33BBB  BB  BffBƙB33BffBʙB33B˙BffB͙B  BffB  B33B33BЙBffBҙBffB33B33BffB  BϙB33BΙBϙB  BffB  BęBffBB  BffB  BB  BB33B33B  BffBBffB  BffBBffBB  BB  B33BəBʙBBB  BϙB33BffBBffB33BffB  BB33B  B  BڙBffBffB  BB33BB33B  B  BBB  B  BřBffBffBBƙBffBʙBffB  B  BҙB33B33B  B33B  B  BBBB  BBffBߙB33B33B  B  B33B  B33BffBϙBffBB䙚BBޙB  B噚B뙚BBB왚BffB33BB  B  BԙB33BffB33B  BffBffB33BBBffBffBBǙB33B33B  BB  B33BBBffBffB  B홚B뙚B  B  BffBffB  BffBffBffBB㙚BB33B  BffBffBffBݙB33B33BffB33BBB  BffBBffBϙBffBBffBB  B  BffBBșB33B  BBBÙB33BΙB  BB33B䙚BffBB䙚BBBBBۙB  B33BffB  BәBffB  BΙBBffB33BffB  BffBffB33BB33B33BBffBffBBݙBߙBffBffB  BffBB㙚BffBffBߙB  BBB33BB  BٙB  BBBBBB33BBB  BșB͙BәB  BB  BBљB33B͙B  BffB͙BBffB͙BșBřBffB33BffB̙BΙB  BBffB33BBffB  BșBBffB33BǙB  BffB  BǙB  BffB  B  B33B  B33BffBəBB˙B  B33B  B33B̙B  BBB  BffBՙBB33BBffB♚BffBffBffB뙚BBffBBffBB  BBffBB  BffBBffBB33B홚BB33B  BffB  BffB33BB33B♚BffBޙBߙBBffBBܙB33BЙB33BԙBffB֙BffBBffB  B33BΙB  B  BB33BffBB33BffB33B33B̙B  B33BffBșBșB  BBffB33B33BBәBBBBB  BffBffBBffB33B  BޙB33BffB  BBffBffBޙBffB33B  BB33B33B33B  B  B33B33B  B  BB33BBᙚBffBBffB♚BBffBᙚB虚BffB33BҙBBffB  B  B  BffBB33B  B33BBBffBB33B  BșB  BffB33B33BffB33B  B33BffBffB33B  BՙBBϙBffBBffBՙB33BffB  BΙBffBBřBBffB  B  B  BBffBB33BB͙BBBffBffB33BB33BB33BffBB33B뙚BffB33BffB陚B  B33BB  B  BBffBffB  BffBffB  B  BffBffBB33B  B33B  B33BB  B♚BffBߙB33B噚B33B33BffBBffB33BBffB  BffBۙB33BffBߙBݙB33BߙB  B33B33B  B33BB33B㙚B33BB33BffBB33B  BřBșBB  B33BBԙB33BBљB33BBB  B  BffBffB33BB  B33BBؙB  B33BffBיB  BBٙBffBBffB  BڙBffBffBB33B33BBBߙBffBڙBܙB  BBffBB  BB  BܙBᙚB33BB  BB33BBffBBҙBffB33BBיBffBؙBffBB  BB33BB  B  BЙBЙBB33BBffBB33BB33BBB͙B̙BBΙB33BBffB33B  B  B͙B33BʙB33B̙B  BBBffBffB˙B33BffBffB33BՙBffBݙBBffBffBB33BBffB  B  BB  B䙚B  BᙚBBffB晚B晚BffBBffB33B  BB  B  B왚B  B  BffBffBffB虚B33BBffB㙚B  B噚B  B  B33B33BffB33BffBBB33B33BffB  B  BffBffBəB  BBڙBڙBffB  BٙBBBBffBԙB  B33BffBffBffB33BљBffB33BffBffBffBffBBBϙB33B  BBBәB33B  B  BؙBBٙBBٙBיBBBۙBffBffB  B♚B33B  BffBB33BffBꙚB  B陚B陚B  BBBffBBffB왚B33BB33B  B33BݙBffBffBffBBffBB噚B噚BffBffB  BBؙB33B33BffBBffB  BffBәBB33BffB33B  BڙB33BffB  BffB  BffB33B̙BffB  BʙB  BffBffBffBʙB  BʙB33BffBffB33BffBBffBBffBBBBB33BffB  BϙBB  BffB͙BBϙBffBؙB33BBffB33B33B뙚B  BffB  BB  BffBBB33B33BB33BBBBB  B33B왚BffB陚BB33B  BҙB  BffB  BϙB33BљB  BffB33B  BffB33BffBffB  BffBffBΙBBәBљB  B͙BBffBʙB˙B33B33BffBșBǙBÙBffBffB33BffB  BÙBffBÙB33B  B  B  B33BB̙BffBəBffB33BBBBΙBϙBBәBЙBәB33BؙB  B  B33B  BffBݙBBffB33B  BB33BߙB  BBffBB  B癚BB33BffBB33B  BݙB  BәB  B  B33BffB噚BffBBB䙚B33BffBffB33BᙚBffBffBB  B33B33BB  BffB33BԙBffBљBҙB  B  B33B  BBәB33BЙB  B  B33B33BB  B33BBəBffB33B  BffB  B  BB33BÙB33BBǙBBBBB  BBBÙB  B33B33B  BBffBϙBB͙BffBBәBԙBffB  BB  BffB  B33BϙB33BҙB  B  B֙BffBۙB  B  BffBffB33B  BBffBԙB֙BBЙBB33BBљBәBffBB  B33BffBffB33BB33BBffBB  B33B33B  B33BffBffB33BffBB  B33BBBBBffBBB  BBBffBB  B33BBBBBBB33B33B  BBB  BffB  BʙBBffB͙BffBffBәBҙBffBBҙB33BB33B  B  B33B33BffB33B  B33BޙBܙB  BBؙBffBB33BffB  BB  BffBffB  B33BљBљB  BffB33B  BffBffBffBB33B͙BəBBB33BffB33B  B33B33BBffB  B  BBffBffBBBBBB  BffB  B33BffB  BffBffB33BBBB33BffBffBBffB33BBB33B33B33B33BffBffBBB  B  BffBəB͙B  B  BԙBB  B33B֙BBffBB  BљB  BԙBBљBffBҙB͙B  B33BffB  B33B33B  B33BәBffB  BB33B  B33BffBffB33BBǙBҙBЙBB33BϙBffB33B33BəBʙB33BB33B33B  BșB  BBffBB  BBB33BB33BBB  BffBffB33B33B  B  BBBffBBB33BÙBęBęBřB33B33BB  BffB33BBffBffB33B33BBffB33B33BљBBՙBffBB33BBٙBٙBffBB33B  BffBffBB33BffB33BffBۙBffBffBB  BؙBffB֙BB33B33BBB33B33BBǙBffBB33BffB33BB33BffB33B  BB33BB  B  BBffBB  BB33B33BBffB33BffBffBffBffB33B  B33B33B33BBBBB  BBB  BBB  B33B  B  BƙBB  B33BffBBB33B  BBƙB33B̙BBB  B33B33BB33BΙB  B  B  B  B  BffBϙBffB͙B33BBBBB33B33B33BBB33B33BBBBffB  B  B33B  BBBBB33BffBB  B  B  BffB  B33BffBB  BBB  B33BffBffBffB  B33BffBffB33B  B33BBBffBBB33B  BBBBB33B33B  BffBBffB  BffB33BBffBffBffB  BBBBffBB  BǙB33BB  BəBffBffBBÙBffBBBBBffBB33BffBffBBB  BffBBffBBBBB  B  B  BB33B33B  B33B33BBBBffBB33BBffB33BB33BBffB33B33B  B33B33B33BB  BffBBBBffB33BffBBBffB33B  BffBBBffB33B  BffBB  BffBffBB  B  BBBffBBϙB  BϙBffB  B  BљBffB33B33BBB  BșBffB33BffBffB33BffB33BffBB  B33BBB33B33B  B33B  B33B33BBffBBffB  B33B33BB33BřBB33BƙB  BÙB33B33BBffBffB33BB  BB  B  BffBffBBB  BffBBBB  BffB  B  BBBBffBB33BB33B33BBffBffB  BB33B33BB33BffB  B  BffB  BBB33BffBBffB  BBBBffBBəB33BffB  BșBBřBffBB33BB  B  BəBBʙBB33B  BBBffBBffB33B  BffBB  B33BBB  B  BffB33B  BffBBBÙBBB33BffB33BBBffB33BffBBffBBB33BřBB  BřBB33BBffB33B  BB33B  BBÙB  BB  B  B33B  BęB  B  B  B33B33BffB˙B̙B33BB33B33BЙB33B33B33BffBB33BԙB  B33B  BffBffB33BҙB  BB33B33B33BffBҙB33B33B33B33B33BB  BBffB33BϙB֙BB˙BBəBffB  B33BffBBBffBffBəBBB33BB  B  BřBƙBffB33BffB33B  BęB33B33B  B33BffBBffBBBBǙBǙB  BffBB  BBffBBB33B  BBffB33BffB̙BBϙBBffB33BBffB33BffBffBՙB֙BיBיBיBBՙBԙBԙBffBffB33B  B33B33BffBffB  B  BB  B  BB33B33B˙B33BBB  BșB  B  B  B̙B  B  BəBffBƙB  BÙBB33BB33BÙBBęBęB  B33B  BffB  B33BęB  BffBęB33BBÙB  BBBBBffBBBB  B  BBęBřBffBffB33BffBffB  BșBB˙B̙B33B  B33B33B͙BәBBB  BffBB33BؙBB  BB33BљBffBϙBBB  B33BB͙B33BBșB  BB33B33BBffBB33BBffB33B33B˙B  B  B33BffB͙B33BBB  B͙B33B  B  B33B33BBBB33BffBBBB  BB33BęBffBffB33BB33BffB  BffBffB  B  B33B33BÙB  BB  B33B˙BBffBffBҙBBffBBBffBB  BÙBBǙB  B33B˙BffBB  B  BϙBBffBB33B  BffB͙BffBB33BffB  BB33B  BffBffB33BffBB33BBffB  BBBBffBB  BBBBBBffB33BffBBB33BffBB  BBffB33BffBBBffB  B  BffBffBBBB33BBBffBBB  BBffBB  BBBBffB  BffBB  BBBB33B  BBBB33B  BB33B33BęB33BșB33B33BB  BBBffB  B˙BșBffBB33BBBșBǙBffBB33B  BffBffB33BB  BBBffBffBffBB  BffBffBB33B  BBBBB  BBB  BffBffBBB  BBB33B  B  B33BB  BffBBB33BffBB33BBffBBBBBBB  B33B33BffB33BffBffBffBBÙBffB33BffB33B  BffBB  BffBB33B  B  BB  B33B  B  B˙B33BΙBB33B  B  B͙B  B˙B  BffB33B33B  BB  BB33BffB  BB33BB33B33BffB  BB  B  BBBBffB  B  BBffB  BB  BBB  B  B  B  B  BB33B  BBB  BB  BBBffBffBBffB33B  B  B  BffB  B33BB33BffB  B33BffBęB  BBffBřB33B33B33B  BÙB33BęBB  B33BffB33BΙBBffB33BϙB33BffBB33B  BʙB33B  BșBffBƙB33BffB  BB  B  BffB  BÙBffBB  B  BB  BBBB33BBffBB33BBBBffBB  BB33BBffB  BBBBʙB  BęBffBB33B  BϙB33BЙB͙B33BϙB33B̙BffB  BB33B33BBәBљBЙB33B  BΙBffBϙBffB33BffB33B  BBffBΙB33B͙BBffB33B33B̙B͙BffB33B̙BffB˙BB33BBBffBB33BffB  BffBʙBffB33B  B  BB  BșB33BBffB33B33B33BB33BffBB33B33BʙB  BBffB33B͙B̙B̙BBB  B33BffBffBB  BΙB33BffB33BB˙B33B33B33BBBffB  BffB  BBffBʙBƙB  BffB  B33BB  BffB  B  B33BΙB  BffB  B33BBffBffB33BffB  BB33B  B33B33BBffBϙB33B33BB  BBBЙBB͙BffB  B33BəBʙBșB  BffBB  B  BffB33B33B  BffBB  B  B  B  B33B  BBB  B33B33BffB  BBÙB33B33B33BffBǙB  B33B33BffBffBBffBffBșB  BəB33B  BBB  B  B  BffBBB33BffB  B33B33B  BB  B˙B  BffBBffBBB33BB33BBBffBǙBBƙBƙB33BΙB33BffB  BҙBB33BffB  B33B  B֙BffBffBBffB33BffB  B  BBޙB  B33B  B  B33B㙚B  B  B晚B  BffB  BۙBיBffB33BffBB  B  BߙBffB33B  B33B33B33B  BBB♚BB噚BBffB33B33B  BffBB33BBffBffB  BBffBffBffB33B33B  BBB33B33B  BffB33B㙚BB33B癚B㙚BB33BffB䙚B  BߙB♚B33BޙBffB33BBߙB33BffBۙB33BڙBffBB33B  B33BٙBؙB  BffB33BB  BBffB  BיBffBffBBB33B  BffB  B  BffBffBffBBBffB  BB  BffBBB33BffBffBffBəB͙B33BffB33BBB  B33B33BffB33BƙB  BffBB33BB  BÙB33BəB33B33B  BΙB  B33B33B33B  B33B  B  B  BffBBffB33B  BʙBșB33BƙBffBB  B33BęBBffB  BBBBffB  BffBB  BffB  B33B33B33B33B  B  BBBffBBffB33B33BB  BffBffBBBB  BB33BBffB33BB33B  B33B  BB  BB  B33BBBffBB  BffB33BBB  BB33BffBBffB  BBBffB33BęB33BB33BB  BBB  B33BřBffBB33B33B  B  BBffBBBffB  BBBB33B  BBB  B  B  BB  B33B33BB  B33B33BB  BffB  B33BB  BffBBffBBBB33B33BffBB33BBB33BB33BBffBBB33BB  B33BffBffBBBBB33B  B  B  B33BB33BffBffBffB33BffB33BffB  B33BB33BffBBBBBffB33BffB33BffBBBBffB  BB33BB  BBffB33B33B33B  BBffBB33BffB33BB  BffBffBB33BffBBBB  BB33B  B33BffB  B  BBB33BffB  BBBB  B  B  BBBffB33B33BBB33BB33B33BffBBB  BBBffB33BffB33B  BBffBB  B  B  B33BBBffBBffB33B33BffBffBBffBBBBBB33B  B33BBBffBB  B  BBB33B  BB33B  BB  BffBffB33BffBB  B33B  BB  BB  B33BB  BffBffBBffBBBBffB  BffB33BB33B  B33B33BBBBB33BBBB33BBffBB33B33B  B  BffBB  BBB33BffB  BffBBB  B33BffBBBBBB33BB  B33BBBB33BffB33BBBBB33BBBBBBffB  BBffB33BB33B  BB33B33B33B  BBffBffB  BBB33BB  BB33BffB  BffB33B  BB33BBBB33B33BffB33B  BBBBBB  B  BffBBffBBffB  BB  B  B33B  BB33B  B  BffB  BBBB33B33B33BBBBffB33BffB33B33BB  B33B  BBffBffBB  B33B33B  B  BBBB33B33BBBBBB  BBB  BB33B  B33BB  BB33BB  BBB33BffB33B  B  B  B  B  BB33B  BB  B33B33B33B  BB33BB  BB33BffB  BffBB33BffBffBffBB  B33B  B33B  BB33B  B33BffB  BBBffBB  BffBBB  B33BBBBffBB  BffB  B33BffBBffB  BBBBBffBB33BffB  B  B33BB  B33B  BB33B  BÙBffBBBffB  BB33BffB33BffBffBB33BffB  B33B  BBB33BB33BB  B33BB33BBB33B  BffBffBBBBBBffB  B  BB33BBBffB  B33B  B33BBƙB33BB  B  B  BB  BffBBB33BBffB  BffBffBffB  BÙBÙBęBffB  B33B  B33BBffB  B33B  BșBffBffBB  B33BffB  BBffBffB  B33B33BBB33BffBBB33B  BB  BęBBBffBBB  BffBB  BB33BffB  BffBffB33B33BÙBffB33B  BBBB  BffB33BBB33BffBBBffBBB33B33BB  B  B33BB  BB33BffB  B33BBB33B  B  B33BBBffBffBřBffB33B  BƙB  BffB  BǙB33BB33B33BșB  BB33BBffB  B33B  B33BffBffB  BffBBB  BB  BB33BÙB33BffB33B  B33BffB33B33BřBƙBǙBBșB33BBffBB33BBB33B33BB  BB33BffBffB33B33BffB33BffB  B33BffB  BBBffBffBffB  B33BÙBBB33B  BffB33B33B  B  BBffBffB  B33B  BęBB33B  B  BƙBƙBǙB  B33B  BșBșB33BBBBffBBB33B  BBffB  B  BffBffBÙBęB33B33BB33BBffB33B  BffB33BBffBffBB  BBffB  B33BffB  BBffBB33BffBffBBBffBffBBBffB  B  BBffBffBBB33B  B  BBffB33BffBBB33B33B33BBBB  BBB  BB  y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AA  A=qAHAGA=qAA  AGA{A\)A33AA=qAQAARA33AGAQAAA(A
=AzA(AHAGAA(AQAHAAGAAAA{AA{ApAzAGAA(AA
=A(A
A33AAGAQAAA  AARA\)AQAA
AAAA{AAHA  AA=qAAAGA  A{AAAAzARARAA
=AHA33AGAA  AAApARAA  AA\)A\)A33A(AA
AA\AzAQAzA
ARAA
A(AAA{ARAApA\AAAffA=qA33A=qA=qAAA  AAHAHAAAAzA=qA
=AQAAA\AA
AAzA
=AAAA
AA=qAzA\AAzA(AAQA\ARAQAA
AAAQApAQAGAGAA  A\ARA(A
AffARAffAAA  A=qA
=A=qAA\A
=AA=qAffA\A\A{A=qA{AAApAAQAAAA\)ApApA
A{A(A\A=qA{AAAAA\)A
AA
A
AAAApAAAAGA
=AHA{AA{AA
=A\)AGARARAAQA(AQA=qAAA
A{AAA(ApAQA
=A
=ApAQAA
=AQA{A  AAAAApA  AAHAAA  AAffAAA(A  A(AA
=AA
=A\AQA\)AzAA  A
A
=AAQAAzA\)A
=ApAApAGAAGApAAzAAAQA=qAA
A{A
AA
=ARAAGAA\)AAAGAARARA
=A\)AAAA33A  ARARAA
=ARA(A  AQAHAAA\)A33AAA\A33AA\)A
=AAzA\AQAHAAAzA{A  AA
AA
A
ARAHA(A
AzAApApA\AA\)AA  A=qARAGAA33A
=A33ARAAffARAA
=AA\A\AzA\A\A(AffAAzAffA\AHA{A\)AAAGAAffA  A=qA
AAAAzAAAAA\)AAAA(AA\)ApAAAA{AHA
=AAffAA\)AGA  A\)AA
=ARAAA
=AA
ApA
AffAQA\AAzAA\ARAHAGAAA  A\)A\AA(AAA33AAAffAzARAAA{AA=qAQAA(AAA
=ApARAAffA
=AARAA{A=qA  AAAAA33AHA=qAA{A  A  AAHAA
=A=qA33AA{A(A\A\A=qAAA
A(AzAffA
AAGAQAAAA{AA=qARAAA{A=qAQAA
AHAHA33AA
=A\)A{AQAAAAAHA33ApAA\A{AHAA  AAAA  A\AGAAAHA
=AHA(AffA=qA\AzAA\)A33AzAAzA{A
=AA
=AGARAAAAffA
=A\A=qAAHAARAGA
=AA\AA(AAAGA  AQAA33AHAARAA=qAAAHAAA=qA\AGA(A
=AA{AAAHAAA{AAQAGAGA\)AGAApA33A\AQAAAA  AAHAAGAGAAHAA(AAAAQA\ARA\)AGAAQA(AQAffAA  AA\A  AQAA33AAHAA\AzA
=A
=AA
=A33A\)A33AGApAHA
AAHA  AA  AA
=AAHA33ARAAffAA{AAA=qA33A33ApAAGAAAzARAHA\)ApAAAGAQAHA
=A  A\)ARA
=A
=A33AAA
A=qAffAGA(A\AGAA\)AAA
A{AzARAAAAA{AA  AApAAAA(A  A{AzAAA
AA
AA
AGA(A  A
=A{AAA(AHA
AA=qAAHAAAzAzAffAQApAA33AA=qA
AAGAA\A\AA\)AffAzAAA33AA33A\)AzAAAAHAzAAGA\)AAGAA=qA(A
=ApAA  AAQA  A33AA  AAQAAA
A\)AA(A\)A
A(A=qARA  AA\)AA{AA
=AA\)AzAAď\A=qAAQAzA(AHARAffAA=qARAAA{AAzAA33A
A
AGAAAARA(AffAAAAA33A  AA{AHAA=qA
=AAAA\)AAzAAGAAA\AAHAApA
=AA(AHAAAAGAffAHAApAAA{AARA{AARA\A{AAAARAGA\AGA
AA\)A33AAAffA
=AAA{A  AffAAA
=AAA\)A33AA=qAQAAAzARAAHAARAzAAzA
AA(AffAA33AHAA\ARA{AAGApAGA\)ARA{AAffAARA\AAA(ARAffAAQA
=AHA33AA(AQAHA33ApAA  AA\AAffA{AA33AAAA=qAffA33A33AGAHAQA  AAQAHAAApA=qA33AHA
AGAA{A\AAAA  AA{AA  AGAAAAA
=A
=A
=AffAzA
AAA=qAGA33A  A\AHARAAQAAAAAAAGAAAGA{AQAAffA\)AA\A(AHA33A\AAffAAAffAHAARAffAA\)A=qA=qA=qAAffARA33AA(AzAffA
=AGAA=qA\)AAA{A  A  AzA\AA  A33AAAGAA=qAAHA33A  AAAAAAGAAAzA\)AzAA=qAQAffA33AGAA33AAAGAAA{AQAHARAzAAA
AGA
A(AffAAzA\)AA{AAAQAAARAHAAGAQARA{AAzAHA33AffAAAAAîAAA  A{A(AffAAAAAQA\AA\)AHAARAAQA(AA
=ARAAQA(AAGAGAApA\)AGA
=AAAQAzA33ARA{A{AA33A\AApA\ApAAAGA\A\AAAAAA\AA33ApA33AAffApA
AAApAAAffAGAApAzARAA{A=qA  A  A\)A\AQAzAAAAHA\)AzA(AA
AAAAARAHA
=A33AA\)AAAHA33AHAARARAAAGAHAAAzAA=qAffAA
AHAffAAQAAGAAHA
AA\AAA
=AzA33AA33AffAAAAAQA(AAAAHApA
ApAA\)AAGA  A(A{AAAQA(AAAAAQA=qA
AApAAA  A\)AAGAARAA\A=qAGAAQA(A=qA{A
A  AffA\AA
=AHAA
=A\)AÅAîA  A=qA=qA(AA
AîAÙAÙAÙAÅApAAAAAAAGAHA33AAHA
=A
=A33A33ApAÅApAÅApA\)A33AAHAA¸RA¸RA\AQA=qAQA
=AHA£AîAÙA£AffAHA\A
=AffA  AffAA=qAAAffA
=ApA\)AGApA{A33A33AA\)A33A(A
AQARAA\ARAA{A=qA\A33A=qAApAÅA  A{A  AîAGAA£AzAQAQAAAA33AA  AAA  AA33A
=A33AQA\)AA\AA
ApAffAA33ARA\AAffAffAQARAAAHAA
A\AA(AA=qA
=ApA=qAAGA
=A(ARA{AzARA{AzAA
AAA\)A\A(A(AAffAffARApAA33A\)AAAAAARAAQAAA
A{A  AAA=qAAAA  A\)AĸRAzAAģAQAQA(A33A\A¸RA¸RAA\)A\)A
=AA£A
A33AQA\AA
=AGAGAAAAQA£A¸RAQA£A(AffA(AQA\AzAA£A=qA£A¸RA£AAQA¸RAAffAAAA(AAHAGAAAA\)AA\AzARAHA33AAzA
=AA  AQA{AffA
=AzAAA{AAApAzA33AApA33AA
=A33A
AAzARAAAARA
AAA
AQAA\AAAAffA\AAA(AQA{AAAA\)A  A=qA
A
A
A  A  A
AA\)AAHAQA\AQA=qA=qA=qAffAzAA
=ApAAA
=AGA\)AA33AAGA\A\A\)AAA=qAAA{AHAHA
AA
A  A(AAQAAAAffAAA
A  A  A
AAGARApAA\AAARARAA  AA  A(A  A(A¸RA(AzA  A{A(A  A{AA
ApA(AAAAAA(A{A
AA
=AGAGAA\)A
=AGA
AARAAGAApAGApAAAA{A=qA
AHAAAzA{AA{AA  AA  AAQAAA\ApApAA\AzAAGARA(A\)AAAA
AAAA  A  AAAA  AA  A  AAAģAzAĸRA
=AHAA{AHA33AǅAGA\)AƣAzAAď\AA{A\)AAQAAApA(AĸRAAÙA
AHA
=A
=ApA33AA
=A
=A£AHAzAAHAzAAQA\A33AA
=AAzA=qAGAAA=qARA{AARA
=AGApAHAA=qA=qA
A
AA
=ARA  A  AAAHA\)A\)A\)A{AQAzAAAQAAA\)AAAApARAffAGAA=qA  A{AQAAA\)A  A33A(ARAA=qA33AHAA\A  A(A(A\A33AA=qAAGARA{A  AHAGAAApA{AA(AAGAzA  AQAA
=AAzAA\)ApA{A
=AffAAffAAAGA=qA33AzAffAApA
=AA{AAAAAAAAAA=qAAA=qAQApAAHA{AHAA  AAAAAGARAQAARAAAAffApAAAffAA
A  AA
=A{A\)AA
=A
=A=qAARA
=AAA\)A{ApAA33AA
=AHAA  AAHAAAAAA\AQAQAAA  AHAffA{AAAHAAAAGAGAHApAAA\)AQAA(AA
A33A
=AAzAAGAAAffAzA(AAzAHA{AGA(AAAAAQAQA=qAAffAA
=A{A{AApAA33A33A=qAA
AffA
AGAQAAA(A
AzAA{A33A{AAAARAA
=ApA(A=qA{AA33A
AGA
=A
=AzA  A
=AAAA  ARA(AGAQA{AAAA33A(AAA
=A(AA\AQA
AQApAARA  AAHA
AA  AAffA{A=qA=qAAA\)AA
=A\)AGAzAHAGA33A\ARAAHAAA  A=qAAA{AAffA{A{AHAAAGAzA=qAffApAA
A{ARAARAAAAAApA
A33ARApAHARA=qA
AHA(AHAApA
AzA=qAzAA\A{A(AAAGARAffAHAzAQA\AAA
=AAAGAGAA\)A33AAA\)AApAAGAA33AAGAQApA\)A\)AAApAGA\)A
=AAzAA
AAAA(A\AAA{AHAAHARARA\AQApAApA
AAAAA\AzAA
=AA  A  AGA33ARAA33A\)A  A{AffA=qAQAQA33AHApA  A  A
AAAA{AAAAzAAA33AQA\AA
A  AffA
AAAAApAA=qA(A
A=qAQARARAApAAffAzAAAAAzAAzA\)AAA  AA33A
=AA
=A
=A=qAAA  A  A(AA(A
=AAAAQAAHAffARARAARAQAzAffARAzAA=qA33AGAApA(AGA
=A\)ApAA33A33A
=A\)A33AGAA33AAA  ARAAA
AAARA33A\AGARAGAA\A=qAAA33ARA=qAzA
AQAApA(AffAA33AA(A{AffA  AA\)A33A33ARAffAQA=qA
=A{A
=A
AA=qAffAzAAAA(A(A{AGA33A(AffA\AAAAAAGARA
AAAffA(AffAffAQA\AA
=A=qAzAA¸RApAQAAAzAAzAQAzA  A(AAHAGA=qAGAARAHA\A
A  AA  A\AA
ARAHA\)A33AAAzAffA
A(AAAAAHA(A\)ARA{AAHA{AGAGA
A{AAGAAAAffAA
=AApAGAAAGA(A=qA\AAAA{A{AAA(A{A{AzARAARARARAA33A\)A  AGA{AA\)A\A(A(AGAQA\)AAAGA\)AAHA\AzA\ARAARAARA=qAQAffAAA\A=qAAGAAAGAA
A{AzAAAHAQA  AffAA\)A
ApAzApA33A
=AAA33AAffARApA\)A\)AA{A(AAAA=qAAAHA33AA{AAAApAffARA33AQAQA33ApAA
AQA\)A
ARAQAGAAAAffARAAARAzAGAAGA(AARA  A\)A\)AARAAAHA\A\)A=qA{A  A{AAAA{AffA\AGAAAA=qA\A
A(A\)ApAA  A\A(AAA=qA{A{A\)A(AffA{AGA\)ApAAARAAGAAA33ARAffA{ARA
A
=AffAAA=qA  A
ApAAAffA  AAAHAzA  AAGA
AAAAAQAHAAAAAAffA=qA=qA(AA  A
=AAAzA  A\)AA=qA(A\)A33ARARAHA(AAHA{A  AAA
AA
=AQARAAAAAHA\)A\)AAGAHAA{A(AzAAAAAAA=qA(A=qA{A  A  A(A
A(A{AffAAGARA
=AAAARA{AAAHAAQAzA=qAzA\AAAA
=AAA(A=qAAA=qAzAA=qA
AApA
A{A(A
AA
A
AzARAAA=qA
=A{AGAAAGA
AA=qApA\A33A
ApAffAAA=qAffAQAAA\)AA
=A
A
=A\A33AzAAAAAA
=AzAAQAA\ApA\AffAAApAA(A33ApA
AAHAA  A
A\AAGAHAA{AA
=ARA\A
=AGAAApAAHA
=AA  A(AQAAA
=A33ApA\)A\)A
A  ARA  A
AAHAGAAHAA
AAffAQAAAHAAAzA33A\AHA=qAAAAQA=qAA\)A
=AAAGAA=qAAAAQAAAHAAAffAA33AA
=A  A
=AHAA{A=qAARAAGA{AA33AAAAzAAApA
ARAAffA
=A{A(AAAHAHAzAAAGA(ARAAzAAA\)A
=AA
ARApA
A=qAHA
=AApAAzA(AAAGAHApA(AA=qAffA
=A(AA
AAA\)A(A
AARA=qAA\A{AzAzAAffAzAA\ApA  AzAAAARAAAAA\)AQAARA=qAAffA{ARAQA  AHA\AA\)AA\)A
AA  A\A\A\)AAGAGARAGAzA=qA{A  AAA(AAHAAA{A\AA  AA
=ApA
=ARAQARARAffA(A(A\A\A(AARAA{AARAAAHAARAAA
A(AA33A(AzAA  AA=qAA\A\)AA{AQA(AzAA
A{AzA33AA  ARAAA(A  A  A  AGA
AffA
=AffA{AA{A(AffAAAA=qA(AA  A
=AApA\)ApA33AAAA  AzAHAAzAQAA(ApAGAAA\)ApA
=AAzAA\)AAA\)ApAApApAAAAzAGAGAGA=qAA(AQAAAGA\)ARAApA
AAA\AApA{AA=qA{AHA(A
AGA
=AHAffAHAzAA\AQA(A\AzAGAQARAAA\A
=AAA\)AAA\AApA(A
=AAAAHAA
=A\)A{AA
=AAQAGAQAAAGAHAAA33A(AA33A\)AApAAA\AAGAffAAzAAzARAAA\AAAffA\A(ARAAA=qA  AAAA{A\)ApA\)A=qAA\)AGA\)ARA\AAA
A{ApAAQA=qAGAAAAAAAA(AAA
=A=qARAQA(ARARAApAQAzAffApARA
=AAQAAAGA{AAAA
AGAA33AA\AQAHAAQA  ApAGAffAAAGAAAGA
=AA\)AAAAAA
A
AAAA33AA
=AAAHA\A=qA=qAGAQA\AApAARAA{AAHAHA\AQAAAffAGA33A33AA
=A  A{AA(AHAQAAA
=AAHA
=AQApAA
=ARAA=qA(A=qARA\)AHA\)AA33AA
=AzA  ApAAzAApAHAffAAzA33AQAAAffAAQAAffA  AAAAffAAApAA33AA\A\)AAAA33AQAA
=AARA=qAAA\)AAHApAAAAAGAA\A{AA\)AAA
=A\A  AAzApAA
AAA33ARAA(AQAffA  AAAA\)A{AA33AAQAAA  AAA
=AHA
=A=qAA  AA{AAARAAHA33AA
=AGAApA\)ApA
=ARAQAQA  A
AAAQApA  ApApAGA
AAAAGA
=AAA  AA
AffAzAARA\A  AA{AAzA\AA(A\AffA
AAHAAHA{AA=qA\A\)ApA33AAA\AQAAA33A
=A=qAAA\)AARA\)AA
AAzAzA=qAA\)AAAAAQA
=A{A(ApApAA(AHAGAHAzA{AA\AAAGAffA(AffA
=AApAAARApAQA\)A
=AARA{A\AGAHA(AQApARAAGA  A\AzAA=qAAQAHAAA(A
=A\AA
AA(AA\)AzA
A
=A
AGAzA=qA
A\)AHA=qA  ApARAQAA\ApA  AAApAAAAA\A{A  A
AHAAA{AA=qAHA\)AQAAARAffARA
AGAHAQAA{AA\)A{AAAAApAA(A33AA\)A
=AffAQAffAAA\)A
A=qAAHA\AAAHAffA\)ARA  AzAAA\AA33AAA33AAzA  AzAGAAA  AffA  AAARAAAApAffAApAA{A(AA{ARAARA
ARA
=AARAA\)AGAHA  AzAHA\AA\)A\A  A\AAA  AAGAA33AGAQAA=qAHA\AAGA33AAzAGAQA33AAzAAAAAGAAAAAffAAGAAAHAAA
AAQAffA{AffAAAAAQA  AApAAAAARAAA33AAAAGA\)AA(AA=qAAHAffAAGA\)AffAA  AApAAA
AA
=AHAAzA=qA(A\)A{A
AGAQA\AA  AA
A{AQA(A
=A33AAzAffAHA\)AQA=qApAA
A(A
=AffAA33A33AQA=qAAApAffA  A=qAQAGA  AA\)ApA(AGA(A{A{ApA=qAAAARA=qARA{AA
A\)AAA  AARAA33AffAAAA  AHA(AAAA
=AAARA=qAGA
A33AzAAA=qA(A33A(AQARAAAAA\)AAHA{AA\A  AQAAAA
AGARAAA  AAApA\A
A33AA  A\AAAAffA
=AA\AA
AAA=qAAAQA{AAzAzAAffARAzARAAffApA\AAA33A(AA\)A  A
=AA33AGA
ApAAAQAA=qAAA
=AAHAAA\)A33ApAAAQA  A
=AAA=qAA{AAffAAA33AQARA(A=qAffAHAA(AzAAA
AHA33AA=qAARA
A(A\)AA
=AAQA33AHARA  A\)A\A(A
AAARAGApAAHAAAAGA{AHAA\)AA
=AA\A33A\)A(AQA  A(AAHA33ARA
=ARARAA\AGAA=qAffA
AA(AAAQAApAzAA  AARARA33A=qAA=qA{AAGAffA  AAAApAAA
A(AAAAAAA  A\A
=AGA33A
=A\)AQAApAffA(A=qAA\AA{A33AAAA(AA
=AffAAA33AAzAzAAA
AffA=qA
=A
=A=qA  AA
A
=AAGAAAARA
AA=qARA  AGAARA\AA(AQA=qA\)A
=AA\)A
=ARA33A\)AQAA\A
=ApAA
=AA\AAAffA{AzA¸RAzAffA{A\)AAA  AA\)AGA(AAAAAGAzAA
=A
AA
AA  A\AA=qAffAAApAA
A
=AffARAAQA33AA  ARAA(AHA  AGAAQAA=qA
=AffA{AffAAQA
=AAAHA
A
=AA
A=qAAA
AApA{A=qAQAGAAAA\A33AA=qA\AA=qAQA
=A
AAA
=AA33ApAAAAffAffAffAAA\A  A{AA\)AHA33A{A{AGA  ARA=qA\)ARA
AAQAA(AAzAQA{AAAAQAA=qAzA  AzA  AAAQAffAA=qARA(AAA(AffAHA
AzAAA
=A
=AGAA
=AGA
AAzAA  ApA(AAApAzAA\A\)ARA
=AGAQA
AzAffAGA
AAGAAHA\)ARA
=A{A{A\)A\)A(ApAAA
=A
AA=qAAApA
=A=qApAA33A=qA{AAA(AQApAQA
AApA
=AA  A
A=qApAHA=qA33AAAAA
=A\AQA(A(A(AAzAAAARAAAQA
=A\)ApAAAAQAAA(A\)AGA\)AAAA=qApAAA\)A(AHARAffA(A\)ApA\AA\)AQA
=A(A\)AQApAHARA=qAzA{A\A\AAGAAHAGAGA\)AAHA
=AA
=AHARARAzAQAQA33AffAA\)AApAARAQAHAA{AzAHA33AffA33A  A
=AAGA\)ApA  A33AQAQA
AAzAffAAffAAA(AA=qAA
AA=qAAzAzApA  AAzAzAAQA\)AA\AAAGA(AzARAHAA\AAQA{A(AQA{AHAQA  ApApAA
A\AffAAApA\AHAQA\)A(AA(A{A\A
=AAAQARAQAQApA{A\)AAAA\A{AAAAAAAHAzAA33ARAffApAApAAA(A=qAA  AApA  A\)AQAA=qA\A{AApA
A
=ApApA{ApA\A\A\)ApAA{AA  A£A\A\A{AA¸RA  AGAA=qAAAAffARAAA(AA(ARARA
=AGA\)A\)A\)A\)A(A
=ARAA\A  A=qAHApAA33A(A(A\AA33AAGAAGAAA\)A\A33AAApAAQAGAARA  A  A
=AA
=AAARA
AARA
=A  AA{AAAA33A(AHAA{AA\AAApAApA  AAQAA
A{A33AAAQAA(A(A\AAAAffAQAA{A\)AGA\)AAffA\AGA\ARAGAGAAAA\)A33AffA\AA=qAffAA=qAA33A{A{ARARAAA33A{AAAQA
=A
=A=qA
=AAApAQAAApAGAzAAA  AA
=AGAARA\)AAAAAA=qAQAHAQA\)AGA
=AA\AA
AARAAAAGAAHAGAA{AzAAApA
A(AApAA=qA¸RAA  AQA(A{ApAA\)AAAA33A  AffAA\)AA33AA\ARAAA=qAA  AQAAHA
=AA{AAAAAHAA=qAA  A{A  AA{A  AzAARAHA33AzA
A33AA{A{ApAA{A  AAA33A\)A=qAA=qA\A\AA
=AApA{AQA{AA
A(AffA
AAAAA(A=qA{A=qAQAAARARAHAAAA(AA33A
=A33AA\AAGA\)AA
=A(A\AffAAffAAA33A{AAQAAffA  AA
=AHAGAffAARA  A
=AA\A  AA
=A
=A
=A
=ARAAA\A{A  A
AAAQA=qAAAA  ARA\)A{AHA\)A\AQA\A  AA(A\A\A
=AA{AAffAGA
=ApAffAQAAA\)AApA\)A\AA33A33A\)AApA\)AAAAA\)AGA
=A\AA
=A{AAAAGAffAAAAGAAA=qAQApApAAA{AA\)ApAzA  A  AQAAffAQA33AffARAA=qAARAzA\A{AAAzAQAzA=qA{AAzAHAA{AGA\)AAA  A(A(AffAffAQAQAAffA33AAAGAHA\)AA(ARApA
AffAAGAffA\)A\)AffA=qAA33A=qAAAAAAAQA(ApA33AAGAA
=ARAAA(AAQA33AA\A\)AHAAGAAAAApApAARA\AzAzA\AffA\AA\AHAAHA\AApAAApAAA=qA  AHA
AAA
=AA{A=qAffAA{AGAA33AAAAAAAAA
=AAzA{AHA  A\)A\A{A33ARA=qAffAGApA33AffA{A33AAAQAAAffA=qAGAARAGAAA
AA\AAA
AARAQA(AAA(AAAHAA
A\)AAHARAA  AzAA  ApA33A\)A
=A
=AA\)A=qARA(AAHA\)A33AA{AARA
=ApAA\)AAA\A
AAHApAA(A{A
=ARAA{A\AAffAA
A
=AA=qAAzAffAAAffA
AARAAAzAAA
=ApAAGA\AA
=A
AAzAA
=AA\AAHARAAAA\)ARAAAA
=A
=A(A\A=qAffAzAAAA33A(ApAAARA33AAARApA
=A=qAAzAQA{AA(AGAHAAAA
A33AffA{AAApAzAGAA  AA=qAAHAGA\)AAAAHA(A
AAAApApAA  A33AffAAAzAAHARAA33A
ARAzA
=ARAARAGA\)AQAAGAzAzA{AARApApA{AA=qA  AAAAzAA{A33AAAA\)A
=A{AQAGAAApAQAffAA=qAHApAAGA33AA\AAGAHA33AffA{AAAzAQA  A
AA33AA
=ApA=qA{AAAHAAzAAAAzA(AAAHA  AA33A33AA(A=qA=qA  ApA\)A33AAGAQA33AffA  AHAzAAAGAAA(A  AGAAHA33A\A=qA
=A  A{A(AQA=qAA{AGAHApA(AffA\)ARA{A
=A(A\A33AAARAA33ApAAA\)AA{A{AAGAQA(A\)AApAAAAQAAAA
A
A=qAGA  AGA33AHAAApApAA\)ARA(AAA
=AHAAGApA
=ARAAHAA\)AAAA  AA\)AAAAAAHA\)AARAAA\)AAAAAAA
=A33AAAA
A
=AAAAAAApAAGA(A\)A\A{A
=AGApAQAA33ARAAGApA{AAAzA(A\)AA(AAGAGA
AAA
AQAHA  AAGAHA=qAA33AA=qARA
=ARA\ApAApAA  A\AAAHAGA\)A\AAAAzAAAAQARARAGA
=A\AQAApA
ARAAAA=qAA33AA
AA
A
=AAAAAAA
A33ARAA\A{AzARAA
=AA
=AzARA=qA
A{A  AHARAAzARAAA\)AQA(ApAAAAQA  A\)AffA\AAAAQApAAAA\)ApAQApA{A33AAGA
ApAAARAHAHApAzAGA=qAAA
=AAffAGAAAAA=qAzAAQA
AAGAAAGA
=AffAAzAA33A(AAzA
=AAGAzA=qAAzAAAAApAA{AA33AA\A(A  AHAGAzAGA\)AffAAAAAffA=qA(AA  AAA
=A
A33AAA=qA\AAGAA{A  AAA33AA\)A\)AAAAAAAQAA  AA(AHA
ARA\)A33AAzAzA(A33AA
=A=qA\AHA\)AAQA\AAzAQAAQARAzAA\A{AQA
=AAA=qAAAAApAAApAHAQA33AAAAAA\A33A\A\A
A33A(A
=AGAzA\AAAA33AARAGAA(A(ARAA\ARAA\AAAAQAA33A  AffAffA\A
A
AAQAA33AAHAffAAA{A=qAAAAA
AGA\)AA
=AAffAAAAAffAQA(A
=AAAA{AA(A=qAAGAARA\A
AQAA33AAAAAAAQA{A\AA33AzA\A\AAA  AA
=AAA33A=qAAzAAAGAA\AARAAzAAAGAAHAHAA
AQAffAA
AGA\)ApApA=qAGA\)AAAQAAAAAA
ApA
=AA
AA
=ApA  AAGA
AA
=ApA  AAAA{AAAAAA=qA  AHAARARAAA\)AAAQA33AAAGA(A\AAA=qA\A{A
=AGA(AffA\A\)AzA\)A\)AzAQAffA\)ApAzA33A{A  AAHAAHAAA(AHAA\)AA
A(A{AQAA33A
AA(AA{AAARA(AQA  AHAA33A(AA\AA  A\A  AzAzA{AA{AzAA(AA
=AAAA
=ARAAHARAzAARA=qAA
AAARAQAA  A\)AAA33AzAffA=qA
AGAAffA\A\)A
AQAA{A{A=qAA
A=qAAzA(ARA=qA(ARAAAGAA33A(AHA  AA33ApA\)AApA(A{AffAĸRA(AHAHA
=AHA33AAîAAA
=A=qA\A¸RA(A  ApAAA\A
=AffAzAQAA=qAA\A\AAA\)AApAzA
=AGAQARAA
AAHAzAA  AAGApAzAGA(AzARA(AAA\)A(A\)AA33AA\AA
=A
=AQAAA\)A33ApAHAHApApA  AAA\A
=AAffAQAAA  A
=AQAAA(AQAffA£AA33AÅAA(AQA\AApA33A\)A=qA{AA=qA(AAARA=qAAffA  AA\A=qAAAA\AAGAQA\A\)AAQA
=AAAA  A(AQAGA\)A33AAQA
A
=AGA33AAffApA(AGAffAHA\AGAA
AAAA
AA  AAHA  AA\AA\AA=qAAA
ARA  AA=qAAzAffA{A(A¸RA\)AAHAGAAHA\A
=A\)AAA{A  AffA(A{AA  AGAHARAffA\AA33AAA
AA
AQAzAAQA£A  AGA
=AAAA=qAGAAGA
AQApAAffA(A=qAAA\)ARA\)AAQA
=A=qA{A=qARA(AA=qA{A=qAQAHARA=qAA  AQAAAzAzAHAffAzA=qA\A33AA
=A33AAQAAQAA{A{A  A
A=qAffA\AAAffAHAAQA\)AHA\ApAAAQAzAffAARAAzA{A\AffAAAA{AA
=AA=qAAAA\A  AGAAffA\)A33A33AGA  AQA  AAA=qAA(AHAA\A(A
ApAHAA\)A  ApAzARAGApAARA\A
ARA
=A
AApA\AAA  A{AQAGAQAA
AAAAA(A
AAA  AAAApAApAAAA
AAA(AHAzA  AQApA\)AAGAApApAAA\)A
=AHApAAHA{AA{AA  A\A\)AA
=A
AzA=qAAA33AGA\)AHAA33AAzAARAQAApAA
=AAGAGA
=A(AAHAAffA{AARAzAAAzA33AAAQAA\AQAQA
=A\ARAA\A33AAAA(AQAQA{AGAAAA33A
=A
A\AAAA\)AAA
=ApA\)AARAAARAHAzAQA\ARA
=AA  ARAGA=qA{AHA
=AA(A
=A
AAAGA{AffAAzAApAGAffA\)A=qAA{AAHA
=ARA\A33ApARAA\)AAGA\)AQAA33AA
AffAAAzAARAffAA
A
=AAGA33AAřAģAAzA
AHApAQAGAŮAA{AřAŮApAřAffA
=AAîApAAA
=AAď\A(A{A
AAGAffA33A33A33A
=A  A
A  AffAA\A{AzAAA33AA  ARAA
A(AA\AA(AAAHAAQA\AHAAzA
AA(A(AAGAA{A
A\)AGA\)AARAzAAARAA
=AAGAAA=qAGA=qAzAA33AA
AApA  AzAAzA\)A\AHAA\AA
A=qA  AA  A
A
AQAGA\AQA{AAAAApA{AAHAA{AApA
AA
A\)AffA\AffAA  A(AAAAAAA
=A
=AHAzA  A\)AQAAApAA\AAAA\)AApARAHAffAAAA
=AAQAAzAAzAAGAAQA  AAA33ApA¸RA£AzA
A  A(AffAA33AzA£A
=A\)A(AA  A  A=qAGAzA
=A\)AA
=AAGA33AApAApAA
AA\)AHApAA33AAGAGAQAQAAGA  AA\)AA  AApAQAAzA=qA=qAffAzARARA
A  A33AAA
AAAA=qAA\)AAAQA
A\ApA\)AQAAAHAAAQApAGAAApAGApAQAzAHAA\)AAA  A{A
A  AffA  ApA\)AAAA{AQAAffAzAzAzAA
=AAAAAHARA33A  ARAAAARAzAA(AAAA\)A{A
A=qA  AffA33ApAAGAGAA\)A\)AAAHA(ApAA(AGA\)AGAzAA  A33AzAAA  A  A\AApA(AA
AA
=AA
=A
=AAAQApA=qA33AA33A  AAzAA  AzAAA  AzAHAAAA
AA33AzAAA\A
AffA(ApA(AQAA
=A\)A
=AHAHA33AAA
AAA\AAHAAQAAAAffAARAA{AAAAA=qAA{AAHAHA{A33ApAAzAGA(AAARA{AffAAQAAA\A(AA{ApARAAffAAAHA33A{ApA  AAGAA\)AAffAQA  AQA¸RApA{AHA
A=qAzA{AA¸RAAA
=AAffA33AQAA{ApAA
=AzARARAAGAzAA
AAA33ARAQA\)A{AQApAGA=qARA\AffA\)A\AHAffA
=ApA  AA\)AHA\)AGAGA=qAHAHApA  AAzAA\)AAA\)AAARAzA
=A
=A(A(AzA\A  A
=AAzA(A  A
AÙA\)AģA(A33A
AŮA(AŮAffAAAA33AA\)AQAÅA\)A\AffA£AGApAHA=qAzAHA¸RA¸RAA(A33AGApAAAA\A\AQARAApAHA
=A{AA
AHAARAAffARAzA=qARAzARARA\)AAAAAAAAQA(AHApA(AA\AHA  A\ARAGAAAAAzA\)A
AAffA\ARA
AAQApA=qAAA(AffAffA\)A
AApAHAA(AA=qAQAzARAQA
A
A
=AAApA=qAGAARApA=qAîAA
=ARA33AzA¸RAffAAARA\)AHAA
=A\)AGAARAHAA=qAAA{A{AAA\AA
AA33A  AffA=qApA
AQAAARApAA=qAAAHAHAA=qA(A{A\AGAAzA¸RA  AîA
=AA£AAHAÅA\)A  A{AApAffAƏ\A
AǅAA
=AHAƸRAAAƣAffAQAffAAA\)AŅAzAģAŮAAřA\)AffAAŅA(AffA=qAAîAA  AÙA(A=qAzAHAHAHAzAApARA  Aď\AA(A
AA\)A
=AAffA(AffAffAzARAA{AAA
AQAA33A33AffA{AzAA  AQAzAA£A(AGAAA\)A\A{AA\A\)AA
AQAzA\AAAA33A\)A\)AzAAHA33A\)ApAGA33AA\)AGAQAA
=A{A
AA
=A(AAA{AzAA\AQA
=A(A(AAAARA{A(A(A\AAAAAAzAGAAAzA(AAAHAARARAzA=qAzAAA
A\AA(A33AffA=qAzA{A(AffA
AzAAA\)A33AA(A
=A\)AARAA\AAÅA(Aď\A  AQAHAAHAA{A\)AǅAǮAGA
=AAA
AQAzA
AAAȏ\AHApA33A
AŅAGAŮAŅA=qAHAģA\)AAAzA\)A33AA=qAģA\)AGAîA(A
=AřAAÙAAŅAŅA=qAŅAAffA¸RApAÙAHAzA
=AQApA  AřAA(AAGAA  AGAA
A
=A=qAffAAA=qA
=AQAzAQA¸RApA=qAď\A
=A  AAȣAHAffAȸRA
=AGAffA˅AAHAAQAQAGApAHAA{A
ApAA\)AA
A
=A˅A33AʣAʏ\Aʏ\AʣAzAHA  AQA˙Aʏ\AAHAAɅAƸRAAQA(AA
AzAǮAƸRAAzAQAŮA¸RA\AzAffAƸRAŮAƣAƸRAǮA=qA33AƏ\A33AAAHAAzAÅA=qA\)A  A\)AŅA
=A=qAA33AA\AAzA=qA33A£A¸RAAHApAÅAAQAQAîAA  AffA(AĸRA\AQA=qAGAÅA\AAAffAAA33A(A\)AzAĸRAď\AģAA33AGAGAA=qA\)AAzAzAzAGAffAffA=qApAA  AffAAffAŅAGA(A
=ARA{AAA{A{AGA33AA33A
=A\)AHAAARA33ApAHAGA(A
A=qAHA
=A  AAHAHAARAAQAA  A\)ARA
AAAAAGA{ARAGA  A(A33A33A33AGA
=AGAApARAA=qA=qAAzA
=AGA=qAzAffAzApAQApA33A\ApA=qAGAAA33AAA
=ARAAAA
A
=A\)A=qARA=qA
AAAzA\A
=AA\AA33AA
AQA
=AA=qA{A{AA=qA{AGAA(A
AAAA=qAApAAHAA33A\AA\AA  A  A{ApA\A=qA(AHA
=AQA33AGAA
=AAzApA
AffAHAřAA
=AřAŅA
=AffAƸRA
=AǅAAQAzAGAA
=AĸRAĸRAď\AîA{A=qA(AGA  AÙAÙAÅAA=qAzA=qAHA
=A  AApAAAA  AîA33AA\AA33AA(A\)AA\AAffAA\)ApAAzAHA\)ApAAA\A
AHAAA33AffA\)AffARAA
=AzAA  A\)ApAAGA=qA(AA
A  A  A{AffApAď\AAģA(A=qA=qApA
AAffA{AƏ\A33A33A\)AGAŅAzAAAîAAA
=A(AƣA
=A  A
A33A(A  ApA  AA\A
AA\)ApAAHAAA(AA(AA(A
=A\)AAAAffA
=A\)AA=qA=qAAQA(A
=AAAîA=qAAAAƸRAA
=AA£A  A  AAffAAAAHA\AGAAAAGA{A  ARAA\)ApAGAApAHAAffApA
=AAzA
=A=qAA=qAAGAzA
=AzAřA\)A  ApAÅAAffAffAÙAAŅApApA33AA\AAAAQA33AzAHApAffA33A33AzAAAzAAAffA\)A\AAffA=qA33AHAA(AA\)A
=AAA\)A\AffAAA\AAzA=qAA
AA33AApAA
=A=qAA  A{A\AAAGA(AAAQAÅA  AffA(A=qA=qAÙA
A
=A\)AGAAzA\)A(AffA(AĸRAĸRA=qAQAAHA(AŮA33AffA  AA(A=qA{AŅA{AA\)A
=AGAffA\)AA  A=qAAAAzA
A\)AAAGA33A33AA
A
=A  AzA  AAAAAHAHAAzAAGAAA{AAHA(AģA33A{AffAA  AA\A33A
=A{AzAA£A\)AÙAzAĸRA
=AřA  AQAQAzAA33AǅA
AǙAǙAAǙAǅAǅAǅAƏ\A
AǮAǮAQAAŅA
A{A
AAA
=A\)AA=qAȸRAA{A33AGA  Aȏ\AHAAffAÙAffA
A
AHA33A
=ApA\AQAQA33AA(AîAģAAAŅA
=A\)AzA(A
A\)A\)AHA(AGA
AQA  AîAA=qA=qAHAAAffA33AAA=qAîA
AA33AŅAQA\)A  AffA
=AɮA{A(AHA
=AGAA
AAffẠAAffAAQAHA\)AHAffA\)AA˙A
=A(AA˅AAHAʏ\A{AɅA=qAʣAHAʏ\A
=A
A
AͮAAffApA
A=qAffApAAGAAƏ\AŅAģAAffA\AAGAHA
=AHAffA{AA\)AA(A¸RAA
=AǅAA  AHAA{A\)AHAȏ\A
=A
=AAA{A
=ApA͙AGA
Aʏ\AHA=qAHAHAƸRAAGAǮA(AȣA33A\)AɮAQAAA˙A
A{A(AQA̸RAHA{AͮAzApAAͅA33A33AHAA{AA
AA{A
=AAGAAƏ\A{AGAĸRAřAŮA33A=qAAÅAzA  AAHApA{A(A
Aď\AAŅAřAƏ\AŅA  A=qA33AîAģAGAAǅAAƸRAAÙA
=AŮAƸRAǅAAAGApAƸRAǅAǅAəA
A{AffA  AŮA{AQAɅAA\)AA(AHAHAGApAͮA͙AͅAGAAͮAQAAΣAHA=qA=qA  A͙AͅA̸RAGA\)A
=AA͙AAͅApAAAȀ\Ȁ\A(A=qA\)AffAʸRAzAAAʏ\A(AɮAɮA(AʸRA{ApA=qAAAəAəAGAAȸRAAGA  A
=A33AAAǅA  A
AQA{AȣAȣA  AȣAGAHAffAɅAAɮA˅Aʏ\AɮAAAAHAAA˙A=qAHAAͅA
A(A{A
=AAAzAУA33AѮA  AѮA  A=qA33AӅA33AңAzA(AHAQAAҸRAҏ\AffAҏ\AzAA
=AQAQAffAAGAAΏ\A\)AΏ\A
=A  A
=AAAQAAGA=qA
=AzA
AЏ\AУAϮAA{A  A˅AəAQA  AθRAAAA˙AAɅApAʏ\AʣA=qAŅAƸRA=qAGAHAʣA˅A
A{A{AəA
AAAHAAQAΣAffA
Aʏ\A˅A{A
AffAA\)AAУAHAхA
A=qAҏ\Aҏ\AffA{AхAѮAAѮAљA\)A{AA{A
AѮAљApA\)A\)A33AУAffA{A  AϮApAAAAffApAҏ\AѮAAңA  AAѮA(A  AQAиRAAυA\)A
=A(AAǅAHA\)A
=AGAͅA=qA{AΣAA=qAffApA=qA
A\)AA{A͙AA͙AϮAϮApAΣA{AAɅAͅAΏ\AGAAAGA
=A
=AzAϙAЏ\A
=A{A\)AGA33A\)AA
AѮAA
AљA
AУA=qA33A33AGA=qAυAиRA33A
AAA33AAGAЏ\AЏ\AAA{AQA33AA(AAHA{AHA
=AA\)A{ApAAAHAͅAAΏ\A33AA{AApA\)AQAɮAAAA33AřAQAřAHAzAƏ\A(AHAAǮA(AAǙA
=A
=AHA{A(A(AAAȸRAȣA  AəA
AzA(AffAGAɅAA
AffAHA33AGA33A33AAʣAʸRAʏ\AQA\)A  A
AA
AA˅A˅A
=AAAAHAffAffAAʣAQAzAHAʸRAʣAQAɅAA(AAʸRA33ApAHA(AHA
AQA{AAQAǙA(AǙA
AAɅA=qAAAA=qA=qAAAffAHAffAǮAA\)AřAQA  A
AGAAAA=qA
ApAAAffAAAQA(AAApAApA{AHApAAA  A=qAʣAHA
=A˙A
A  A=qȀ\AHA
=AͮA
A=qAAGAHA(A
AAA˅A˅A
=ApAAʣA=qAɅAɅAzAAQAǮAA33AHAzAffAHAA  AQAQAŅAřA
AAƣAffA
AA  AffAQAAAffAHA
=A
=AAƸRA{AƏ\AAǅAɅAɅA\)AGAGA
AAzAffAQAQApAffAƣAffA=qA
=AGAffA(AAGAƏ\AƏ\ApA=qA  AɅAɮA  AȸRAAHAAA33AA{AA\)AAHA(Aȏ\AffAȣAzA=qA  AA\)AAǅAGAȏ\A{AƸRAA
=AAAA33AǮA(AzA
A=qAAǙAAAǅAAGAģA
AƏ\A
A=qA\)A\)AAzAǮAȏ\A(AHAA=qAzAAQAÙAA33AAîA=qAģAGAAA  A  A(AffAHAHA
AHA(A{A(A  A33AGA(A£A\)AÙA{AģA
A  AffA33AA
AAA
A  AffA
=AA
=AAGAHAA
=A33AȣAHAQAȏ\AɅA\)ApA  ApAŅA33AGAřAAřA(AAA  AǅAHA\)A33AGA
AîAĸRA
A\AHAAAHAA¸RAAzApAA
=A
AA  AȸRAffAApAAAApARAAARA
AAAA
=A\AAHAA
=A33AAffAzAApAAQAŮApA=qAHA
A(AʸRA˙A
=AʸRAGA=qAAˮAffAGA  ApA  A  A33AǅAəAAAȣA
=AHAzAǮAffA33A  AQAzAQAŅAffAŅAAAAřAǮAǮAƏ\AGAA{AAzAAffAAAǅAǅAAƸRA\)A
AAǙAǮApA
AA
=A(AA\)AĸRA
A
AÅAÙAHAAA{AzAŮAîAÅA{AA(A=qAQAzA
=AAAǅAAzAȸRAA  A=qAQAʣAʏ\AA=qA
A{AA{AиRAЏ\AHAAHAAϙA33A{A{AAA\)A33AA33AGAffAffAQAAffAAAAˮA˙AʸRAQA=qA{A  AGAHAȏ\A
A=qA  AɅAAǙAAQAzAȸRAȸRAA(AǙAȏ\AA
=AʣAʏ\AAffAȣA\)AAǙAHAAǅA{AAA  AA33AffAAď\AĸRAAA
=AAGA33AAGAGA
=A
=AApAĸRAHAřAÙAHAAAîA33AA=qAîAGAAA33AffAA  AHA\A£A¸RAzAAď\AřA  AffAApA33AAA  A
=AAAAzA=qAAffA
AAAAAAApAffAAAA
AffARAA\ApARAQA
A33A
=A{A{AA\)AAAA\)A=qAzARARAHA\)ApAAAA(AARAffA{A\)AĸRA\)AAHAGAffA{AzAHAAA
=AAGAƸRAǙA=qAGApA33AȸRAApA  A
AAAQAAA  A(ApAA=qAHAAAA(A\)AAAAAffAAA\)A{AAHA
=AAA
ARAQA=qA=qA{AzAA33AAAffAHA{A33AzAffAA=qAQA{A\)AAAAffAA  AÙApAŮAƣAƏ\A
=A
A\)AA{A
=AAA33AA  AHA33AÙA{AA
A=qAʣA{A\)A
=AУAffA(A
A=qAҏ\AAѮA{AϮẠAffA
=AHAʣA
AəA=qAA(A(AAƣA\)AAAHAA£AAģAƸRAQAA
=A
AffA{A(AA(AHAGAQAAQAŮAƣAzA=qA
AA  AA(AzAGA=qAA{A(AîAÅAA33AA33AQA(A33AĸRAď\AAÙAAAffAA\)A33AîAĸRA
=AApAƣA  A(AGApAəAAAɮAA  AzAʏ\AʸRA
=AAA33AA
=A
=A
=A
=AA
=A33AAGAffAAɅAɅAAǮA
AAA(A\)AQA=qAffA  AGA(A=qA=qA{AzAHA33AƣAƸRAŅAQA
=A¸RA=qAA  AŮAǙA=qA
=AAApA\A(AGAAffAƏ\AA
AzAəAHAȣA  AƣA  A\)AAAzA
=A33A  A{AƏ\AQA
=AAȏ\AffAzApAAAǮAAA\)AAɮAAGAɅAA=qAGAȣA  AɅAQAQAAAʸRAȸRAȏ\AA\)ApAffAA33AA{AîA
=A
=AQA{A(AAǙAƏ\A
AzAÅAAHAƣA(A  A\AffApA¸RAAzAzAAQAAffA  AA
AzA=qAǅAƏ\A33AAřAffAGApA
=A\)ApAHAzA\)AA{AQAAHA¸RA33A
=A
=AGAAffAǮA\)AAǮAȸRAAffAHA\)AƣAAAƸRA
AAǮA
AffA=qAHAHAȏ\AzA
=AGAAHAəAGApAffAȏ\AHA{A(AA
AˮA  A\)Aʏ\A=qA33AʸRA33AGA33A=qAǙAA\)AGAƣA
=AģAffApAQAffAGAĸRA£A\AQA
AA33ARAA=qAQAGA  AA(AffApAAAA  A{AAAApAA{AAAAARAAHAA33AGAzAAAA\AA\AA\)A  A¸RAAîAGAA¸RAAGA33A\)AHA\A£AzAQAAA(AzA=qAAA(A\AAQAGAAA(AzA
=AAGA\)A=qAAffA33AAA
AzAAAAAAApAAQAAA33AA(A  AA  AA
=AQAAQA{AAAGA  AGAAA\)AAA=qAAA{A\ApAHAAAA
A(A
=AA\AQAApAffAHA£A(A£AGA\)AHA33AGAAGAGAA(AffA(AAA
AAÅA{AffAAÙAîA=qA\)A{A=qAÙAHAA
AAAA=qA
=AQAzA{A{AƣAAAA{AGAģA33A=qAAAQAA(AzAAAffA{A33AzAAffAAAAA
=A
=AHARA{AAAîA¸RAHARAA  AAA
=AGAA(AAîAAHAGAAQAQAǅAƣA33AHAQAǅAƸRAzA33AŅAŮAď\AģAģAffAffA
=AAAA  A
A=qA(AƏ\A  AAAffAzA  AƣAƣApAAAffAQA
AřA  A
ApA
AƸRAAGApAAGAGAffAĸRApAQAAAA33AAA£ApApA(AQA
=AGA33AzAAŮAA¸RApA\A  A=qA\)AGA
A
AAHA33A  A\A
=AÙAA=qA=qA\)ApAǙAffAȣAAffAȸRAA\)A
A=qAʸRAHA33A\)AʣA\)AʸRA\)AA˅AAəA\)AffAAA\)A
AʣAA˙A\)AʣA(AʣAAAʸRA(A33Aʏ\AQA=qA{AɮA=qA
AȸRA(AɮAəA\)A33A(A  AȣA  AffAɅAAəA=qA33AffA=qAAGA  AzApA{AAAȣA
A(A
A(AHAĸRA33A\)A  AƣA\)AAƏ\AHAAƣA
=A\)AA  AŮA(AHAffA{AGA
A  AffAQAQA=qA=qAǮAǙAA  AAǙA\)AǅAAHAHA
=A33AƏ\AzAA
=AAA\)AǅAǙAǙAǙAǮA{A=qA
=AzApAA=qA(A
=A  A\)A
=AAHA
A
AŅAǮAQAA¸RAAGAģAQAA=qA=qA=qA=qAAffA¸RA
AA
AGAffA=qAAHAffAAîAGAAA¸RAAGAAÅA  AHAřAƸRApAA33AɮA
AAʣAQAɅAHAHAGAɮA
AˮAA(AffA{AQAzAzAɅAAAA33A
=A33AAȏ\AȸRAȸRAȏ\A
AffAQAȣA(AAGAƣA
=AAAApAǅAA
AzA\)A\)A=qA
AAřA\)A33AģAď\AîApAAîA\)AAzAĸRA\)AGAÙAÙA  AQAzAA  ApA  A(AffAQAAAŅA\)AAApAApAAģAAAƏ\AffAffAA  AAGAŮA
=AǙAApAŅAAřA  AzAƏ\AGA  AřAA=qA  AHAAA=qAƸRAffA{A  AGAŅAřAřAzAA{A£AA
=AAA
AffA\)AAzA
=AGAA(A
=A
=A  A
=A¸RAAřApAAģAffA{ApA(AffAAffA\)AGAAQApAAHAÅAffAď\AA\AŅA
=AģAHAAîA  AAHAzAģAA
=AGAŅAŮA=qAA33A(A{A(A=qAffA(AAGAƸRAA33A{AffAA
ApA33AƣA
=AǙAA
AǙAǅAǙA\)A\)AHAĸRAƏ\A33AřAAAAHAď\A
=A=qAffA  AzAŅA33A33AÅAAAzA{A
=Aď\A{AÙAîAģAAÙAAřA
AŅAGAGAGAGAŅA\)A=qAAGA
A33A=qAQA  AǮAGAAǮAȣAQAAAffAHA\)A
=ApAffApA  A(AΣA33A33AGAGAAA
=AA33AϙAAQAAЏ\AȀ\A(A\)AQA33AͅAΣAAAA=qA(AQA\)A33A33AɅA  A(AəAȣAffA(ApAGA  AzAʸRA{ApAzAA
=AȸRA33A33AǙAHAʣAʸRAA=qA˙A33AA=qAAA˙A˅ApAȸRAApAffA  A=qAA(AAɅAzA
=AGA33AHAzA=qA(AffA{ẠAA
=AGA  A=qAAϙA  AQA33AљA{AQAҸRA{AңAffAЏ\A  Aҏ\A\)AҸRA{AffA=qA(AAA\)AzAApA
=A  A(AQȀ\AHAQAA\)AȀ\AͮAθRAQAzApAAffAΏ\AHAffA=qA=qA˙A33A=qA=qAA˙AAGA
=AʸRAffȀ\AQA33Aʏ\AəA
=AHA
AA\)AřAApA{AAzA
A
=A
=AǮA=qA
=AAəAffAʸRAʸRAHAA˅ẠAˮA˙A(A=qA  A(AЏ\AA33AAУA{A㙚ARA33A\)AAיAA˅AˮA(A(A(A  A(A=qAffAˮAA  A  A33ApA33A{A=qAɮAȣAffAA
AǮAAGAA=qAffAŅAffAĸRAAzA33A
=A{AApARA
=A33A=qAzAffA33AGA\)AƏ\A\)AHAA  AȣAǮA=qAA  AȣAAQAAHAffAÅA=qA
AÙAA\AQA
=AA  AAAAA(A
=ApAAď\AAAƏ\A\)A  ApAɮAA(AQA
AHA˙A\)AGA33AA˅AˮAGAAHAzAHApAAǅAffA˙AʣAʸRA{A  ApA
=A  AîA=qApAHA
=AƣA  AzA  A=qAAAAģAzAGApAQAQAQAQA=qAď\AÙAA£A£AQA£AA
=A£AGA¸RAAGAÅA{AA\A\AA£A(AîAď\AAGAÙAƏ\AŮAA\)AffAAƏ\AzAzA=qAzAAǮA\)ApAʸRAʏ\A33AHAzA  AAQAQAHA
=AA˅A̸RA˙AQAzA33AˮA˅AAAˮA˅A33AHA{AGAAǙAGAA
=A{A
A
=AGAAAGAǮAAǅA\)AǮAAǮAAAAzAQAffA=qAffA(A=qAƏ\ApAffAzAƏ\AffAffAQAQAzAA33AǅAAHAǅAGAA\)AƸRA(AAffAGA
AQAřApAřAA33AŅAĸRAĸRAHA
=A33AHA\)A33A
=A33Aď\Aď\AŅAQAŅAģAŮAzAAĸRAŮA
=ApA(AGA(AA33AQAzA\AÅAffA
A\AÅAzA
A
=AA33AA¸RAA¸RAHAA\)AA  A{AzA\)AģAAAÙA=qA(AA\)A(AAAAzARAApAzA£AGAAzAA¸RA
=AGAAzAffAAA
A33ARAffA\AzAAAHAAffAApA  ApAffA£A33AAǮA
AƣAA{AŅAƣAǅAǮAǅAGAǅApAǅAǙAA{A{AǅAǙA  A  AǅAǙAǅA\)AAzAAŮAA33AîAzAĸRAĸRAQAĸRAģAQAzAA{A33A33A(ApAA{AA
=AA\)AA{AAAAffA¸RAAGAAAffA\AffA  ARA
A{ARAGAA  AAzApAA\)AzA
=A
=A
=A\)AQApAAAÅAGA{AĸRAŅA33AAHAffAQAƣAGAƸRA\)A33AGAAAQA
Ȁ\AHA̸RAA˙ApAGAAʣAHAAʏ\A=qAəApAȸRAA
=AHA  AɅAAȣAǮA{A33A  AÙA  AAA\A{AApAAQA(A{AQApAAŅA\)AzAA{AHAzAzAÙApA33AA  AAAAģA33AAŅAAƸRAAA=qAģApAAAƸRAHAzAQAA33A¸RAA\)ApA33AĸRAAQA{A=qAffApAAǙAAAǙAzAȏ\AAAzA33A
AƣAAA\A=qAǅAGA=qAƏ\AzA
=AzA33AA\AA¸RA\AGAQAzAGA\ARA=qAA{A
=AîAGAA
=A  AAA(ARAA{A=qAffAA  AAA(AAzAAAA\A(AAA=qAGARA¸RA£AApAÅA33A=qAA\ARA33AAA£AHA  AAzAHA33AzAŅAzAʏ\AAzAA(AʸRAffAAəA
=A(ApApA
=AA\)AƸRAAAAGAʏ\AʸRAHA˅AAA33A
AGAƸRA{AApA
=AA
=A\AGAHAA{A33ARARARAAAAHAApAAA\)A=qAA(AGAAAHA33AGA{AGAAď\AHA\)A
A=qAA£A=qAHA{A=qAzAHAQAAHAîA
A(AzA=qAzAApAA33AA  A=qAĸRAģAAA
A(A(AƣAƣAƸRAƸRAzAffAA(AffAƸRAAA(A=qAQAŮA
AřApAŅA\)AAģAģA  A
A\)AA  AGAAffApA{AzA{A£AÙA
=ApA\)AAApAîA\AAA  AAAQA33AAApAffAA=qA=qA\)AAAHAQAAAApA
AGA=qA  A(AA  AHAA\A(AA  AzAģA(AQA(A{AA(AQA33AHA\)A\)AřA
AA  AƣAHAA{A  A  ApA{A{AŮA  AģAģA
AAAA{AGA{AAA=qA=qAHAzAAzAA{AApA
AAAA=qA33AGA33A33A\AQA\A{A\)A{AA33A\)A33AGA
=AGAHAHA\ARAHAAAGAAGAAA  A
A{AzAAA\)AAA
=AQAAAAzAHAAA  A  AAAA¸RAA33A
=AA£AQAAÙA  AA  AQAAApA\AAzA{A£AAGAAÙAAzAAA=qA
=A(A{AAAffAA
A\)AGA33A{AA{AAAAA\AA\)A
=ApAzA=qAA(A\AA33AA\A=qA(ApA{A(A33AARA
=AAffA=qARAQAA(AA(AAAAQAAzAAffAA
AA33ARAApApAA
=A
=A=qAGAHAA
A{AApAAA
=AA  AA\A
=A\)ARA
=ApAffAHAAAQAAA=qAAAAAffA  AzA=qA(AA
=AzAA\AAzAQA
A=qA
=A
=AA  AQA=qA
ARAzAffAAGA\AAHA33AAA33AAA  AA\)AzAA\AffA
AzAHAAA33AAA33AA
A{ARAQA
=A\)A
AQA
=A33A\)Aȏ\AHAQA(A\)AHAApA
AîA
AHAAAAzAffA33AAA
A
=A
A\)A  AAAHAGAApA  AQARA  AAGAHAA=qAQA  A\)AGApAGAAAQAffA
=A  A=qAffAAAA
=AA
=AA\A=qARA33AQA(AzA33AQAffA
AAzAA{A  A\AffAA
ARA(AA  A=qAA33A  AîAAAffA
AHAŮAA
=A
=A
AAAģAģAģAď\Aď\A˙AÅAƏ\A
=A
=A̸RAAAAHAGA=qA{AffA
=AA
AA{A(AAApA  A
AzAffA
A
=AffAƸRAA=qAřAŮAAGAA{A33A=qAHAffA33AffAGAffAGARAAA
AffA\AAAGAAzAÅA  A\AAGAzA\)A(A=qAƣA\)A
=ApAƸRApAQAApA  AQA33A˅AˮA
A=qAA(ApAHA
AffAģA
=A  A(A\)AzAA33A  A{A\)ApAQApAA(AAHAzA
=ApA  A
A33AəAȏ\AƏ\AzAəAA
=AAAAÙAA(A\)A=qApAGAA\)A\AffA
=AÅAA33AHAAA33AAAAApA\)A
AAA\)A=qAHAA=qA
=AA=qAHA\)AffA
A=qARAAGA£AzAAQAQA33A\)A
A  A{AA=qAˮAA  AAGA
A33AɅA  A=qAApAGA  A  ApAAA=qApAəA33AHAAɮAAHAȣAffAAApAffAʏ\AəAʏ\A(AApAA=qAGA
A(AŅAAAHA\AAGApA  AA(AA(AGA
=A\AAHAAA=qAA33AAHAzAîAA33A{A(A{A  AApAAAzA
A(AA{A
A33A¸RAÅA=qA\)AffA
A=qAƸRAQAzA(A33AəAQAʣA
=AAȏ\A33A
=AAAʸRA=qAɮA  A  AʣAQAəA  A£ApA
A  A{AAAÙAAŮAGA\A33AzApAAǮA{AƏ\A{AƸRAƣA
=AQAŮAA£A  A
AA\)AApAAAA33AGA\)ApA\)AAHAzAA{AA33AŅA
=A33A=qAŅAȸRA\)AAGA33AAĸRA{AHAGAzA{AHAŅA=qAǮAȸRAGA˙AHAAAA  AѮAAѮAҏ\AУA{A
A33A
=A33A
=AGA{A(AΏ\AΣAffAffA(A{A
=AGA˅A  A˙A˅A  AAApA=qAzAGAQAA
=AA=qAGA(A33AAƸRAǙAAAA33AA
=AAîA(A\)AǙAřAQAGA=qAAffA(ApAAGAGAAA\)AzAAGAǙAǅApAƸRAǅAAȸRAȏ\AAAŮA
Aȏ\A  AffAȸRA(A{AǮA{ApA{A=qAǙAHAzAƣAAffA=qA
=AQA33AGAzAHA33A
=ApAƏ\AzAƏ\AQAƏ\A33A=qAƏ\AƣAƏ\ApA  AģAřAA
A=qA(AzAAzA=qApAÙAAQAAĸRAA
AA{A{AA=qAAAA\)AƣAƣA  A
=AAŮAA\)AHAffA\AzAA{AzAGAQA33A\)AAÅAHA
A\)AAǮAƏ\A=qA(AffA(A(AQAAHAzAA
=A\)AAHAĸRA  A
AzA=qAGAǙAAzA
AǅA(AzAA(A{AƣAHAffAQApAHAQAƸRAƸRAƸRAA  AÙA£A{A\)AÅAAAAď\A33AzAŮA\)A(AGAGAGAA
=AƏ\A(AffAA
=AffApA\)AzA
AQAQAď\ApA  A(AƣA\)A
=Aď\AA=qA¸RA=qA{A33AGAA\)A33AƏ\A
A\)AřAffAAA\)A(AffA
=AAAGA{A33AȣAffAƏ\A{A\)AAA33AřAŅApAǅAAHAQA(A{AQA(A\)A\AAffAAARAA(AîA  A(AA=qA=qA  AAAzA=qAARAAAffAAď\AAAA=qA33A
=A
AQAƸRA  ApAzA  A
AGA\AĸRAffAîAAQAÙAAAQARAA\AA\)AAAAAffAA
AGA
AģAģAHAAGA  AƣAHAQAƸRA\)AA{AzAHAʣAʸRAʣA
=A33A
=AǙAŮApAÙAÙAQAĸRA
AAHAffAAzA(AA
A33A\)A\)AzAzAŮAzAŮAA
AAÅAAÅAA
=A(AAAǅAAzA=qA(AHAA(AǅAƣA
=AǙA\)AȣAzAď\AîAzA(A(AA\)AAA¸RAÙAQApAHAffA\)A(A=qAHAAA(AQA(AAHA33AģAzAÅAģAŮApAŮAHA(AzAQAAzAA
=A
=A  ẠAA
=A̸RA
=AʣAzApAAÙA(A
=AřA
AŮAGAApA
A33AHAÙAď\AģAApA33AȸRAǅA
=AÙA(A(AA
A=qApAģAAA  AŮAHAQAQA
AAƏ\AA33A  AQA
=A
=AŮA
=A\AA=qA\)AAƸRAʣAA{A\)A
=A=qAHA
A33AA  AzAQAAA=qAAHAAffA
=A
=AǮAA
AƸRA{A
=AGA\)AA=qA{A˙AAA(AffA  A
=AǙAŮAȏ\AAəAAGAAʣAǮA\)A33AHA\)AAǅA{ApA
A{AŅAAǅAǅAzA(AǮAŮAƣAffAApAAģA{A
AǅAAA
=AA
=AAA(AA(AƣAƣA33AQA=qAŅAƸRA33A33A33AHAGAŅAƸRAGAƸRAƣAApAŅAHAHA=qAffA33AQA=qAƸRApAzAȸRAAQAʏ\AA˅A=qAA͙ApAAAA=qAAˮAA{A
A(AAɮAAȣAzApAȸRAzApAGA\)A\)A
A(A\)A
=AƸRAzAHA\)A  AAA
AGAGA\)AřA(AffAʸRAA
A=qAffAɅAQA\)AA(AGAȣAǙAřAŮAHAAAGA\)AǅA
A(AǅA\)AA=qAzAƸRAzAƣAƏ\A{AîAffAƣA{A
=A\)AƏ\AǙAAHApAɅA
=A\)AɅAɮA(AffAʸRA33AHAA˅AʣAA̸RAAA
=AffAGAA{AzAApAAˮA{AɮAȣAQAGAȏ\AHA{A
AAȣA=qA  AȣAŮApAȏ\AAffAA\)A33A  AHAƣAzA=qAGAQA˙A  A33AˮA=qAA{A33A\)AģAzAA
=AƸRA
=AAȸRA  A33AQAʏ\A(AƸRA33AzA
=AA
AA
AȣA
=AɅAǅAzA
A\)A\)AHA
=AAď\AģAGAƏ\A  AǮAffAAHAÙA33A(A=qAHAA
=AA
A
AAAQAģAAAAřApA  AəA=qAɅA{A˙AA
=A˙A{A\)AzAAffA=qAAffA  A33AȣAffAzAQAApAŮAffA=qAGA  AQAȏ\A33A(A{AřA=qAQAA¸RAAA33AHA\)AAA(AģA
AQAzAzAffAHA{AzA\)A
AƏ\AȣAHAAAQAəAQAQAA
=AGA
A{A(AzAAAGA˙A
A  AQẠẠAA̸RA̸RAHAHAHAHA\)A\)A\)ApA
=AffA33Aʏ\Aȏ\AffAAQA{AQAA\)A
AƏ\A{AQA33AApȀ\AAɅAƣAAAŮAGAAǮA(A{AA  AffAɮAGA=qAAffAGApA=qAřA  A
AffAəAAəA
AAɮAʣAAƸRAzAǅAəẠA
AffAzAzAAA33A  AffA33AəAAʣA
=AAˮApA
A  AȀ\AAͮAͮAA{A{A  A{AAͮAAA(A
=A=qAQAAAˮA˙A{A(A(A=qA(A˅AGA˅AA(Ȁ\AA̸RȀ\Aʏ\AǮAAƸRAƣA33AAƏ\AAˮA=qAAAĸRApAəAHA33AAʏ\AAˮAAAƣA(A
Aȏ\AAA͙AAffAΏ\AΏ\AA=qAQȀ\AffAAffAQA
AA\)AɮAɮA  AʣAzAGA
=AAGAffAA
=AʸRA\)ApA33A˅A\)AGAGAˮAGAˮApA˙A33AHAʸRAʏ\A=qAAAAȸRA33AAəAGA
A\)A
AAîA  A33AƏ\A=qAHAAQA
=A=qAAAA=qAAǮAƣA
=AQA{AQA  A
A{AƏ\AA
AzA
=AA
=AAŮA
A=qAAGAzAģA{AzA33A\)AHAřAGA{AHAɮA{AQAɮAɅAHA\)A
AʣA˅A{AHA=qAAЏ\AffAAzAңA(AAԣAAA\)AQAffA{AQAA
AЏ\AQAQAͮA(Ȁ\AzA  AA\)AAAʏ\AHA33A  A˙A{ẠA{A(A  A
Ȁ\A{ApAˮA
=A˅A
AẠAffA{A˅AzA(ẠȀ\A33AAHA\)A=qAǙAHApA=qA  AĸRAŮAď\AAffAffAffAǙAǅAHAA(AǙAď\A{A£A
=AHA
=A{AŅAHAĸRAGAzAď\AHA\)A  AƏ\A=qAzAQAAřAAAGAǅAAAAAAHAHAƸRAƣAAǙApAAGApA{A=qA¸RAA\)AzAAÅA\)AGARAQAQARA\)AAHA
=AA(AĸRAQAGAƣA(AŅAAA£AHA{AApAAARAAAAA(A{AHA¸RAÅAîAHA
=A=qAA(AAAAApAA(AAŅA=qAAɅA
A˅AͅAzAzAffAͅAͅApAHAA
=A  AzA(A  AθRAAA\)AQAA
AA
AffAffAQA(AθRA
A\)A33A
=AA(A  AGA(AApAffAffAzAAǮAGA  AəAApA˅Aȏ\A(ApAȣAA=qAAGA
AΏ\A=qAzAApAQAAǅA
A\)AʸRAAď\A
AzA=qAɮApAˮAAHA
=AɮAQA˙AȀ\AQA{AAA
AzA{AЏ\AA(AA
=A
=AA
AA(AAApA
=AԣAAAzAәA
AffA  A33AυAAхAGA
=AffẠApẠApApAzA
A͙AͅA͙AA{AzAGA(ApA˅AAHA=qA\)AGA  AzAAQAʏ\AAHAAʣA  A\)A
AQA33AAƏ\AƣAAəA=qAʣA33A˅A˅A(Aʏ\A{AA˅ApA33AA{AʣAApA˙A˙A
AA{A{A=qA=qAA
A˅A˙AAAʏ\Aʏ\A˅AAAA{A(AA
A
AAA
AˮA˙AHAffA
=A
=ApA\)AȸRAʣAAɅApAffȀ\AA\)A(A  AA33A=qAAA
A(A{AəA{AAAQA(AŮA(AîA=qA{AÅA\)A\)A
=A\)AƸRAA33A33AGA=qAAA\)AȸRAAHAzAA33A(A(A\)AAƣAHAʸRAAA\)AffAɮAɅAəApA\)A33AGApA{A=qA  AʣA
=A33A33ApAGAʸRAAzA{AəAAAA33AA{Aʏ\AHAHAʏ\Aʏ\AʣAʣAzAGAQA
AɮAȏ\AAzAɅAɅAzA
=AffA
A
AffAHA{AƣAřA  A(AȣA{A=qApApAAAA(AA{AƸRAƸRAA\)A
AAɮAȣAAȣAAffAQAƸRAƸRAAA
=AffAAȸRAzAHA˙AAGA(AAA=qA  AHAHAυAϙAA
AAffAЏ\AЏ\AϮApA(A\)AAϮA
A(AQA
AϮAA\)AΣAzA̸RA
A̸RA˅AA
AHAəAGApA{AQAHAəAɅAAHA
=A\)AHAQAǮApAAGA{A(A
=A=qAApA
=A(A
A\)A
AGA{AAǅAGAA\)AʸRA\)A(AzA  A=qAA33A
AzAzAA{A\)A33AAGAȏ\ApA{AQAAA(AApA\)ApAA(A=qAGAA(AA\)A(AģAŅAŮAQA(ApA  AƣAǮA  AȸRAzAzA
=AȸRAəAGAffAɅAzAŅA=qAAAHA  AzA\)AA(A(AHAA=qAAQAA=qAŅApAzA{AzA  A  AGAGAA{AAGAƏ\AǮAAzA=qA
=AǮAǅA\)Aʏ\A
A33AA
=A33ApAA(A{A(AApA{AHAGAffAzA(AQAAQȀ\AA\)A͙A
AAffA
=AA{A33AGAəAAAHAffAGA{AA
AA\)A  A\)A  A(AHA33AA=qA
A(AA33A33AŮAffAĸRAGAAřAHAƸRA{AřAzApAď\AģAGAQAƸRAHA
A  ApA33AřA\)AAffAAƣAĸRA{AɅAɅApA\)ApAAQAȏ\AAAHAAQA=qApAŮAAǅAQAAHA{A\)AzAzA
=A(AAA{A=qAzA  AəAzApAȣAzAɮAffAAGAʸRAHA\)AGApAGAƸRAHA=qA˙AɅAffA˅A
AɅA  AɅA(A=qA(AƏ\AffAƣA{AA33A(A{A
AAǅAA
=AȣApAffAQAAHA=qA(AApAəAʸRAəA(AGA{AA͙A(A
=AAAffApAģAGApAffAQAAʸRAQAHAGA33AɮAəAȣAffA
AHAHAAȣAHAA(AʣAAʣA33AQAAAƣAzA
=AǮA
=AŅA
A(A
A  AA
A33AAA
AŅA
=A\)AzAĸRAǅA{A
AAAŮA  AĸRA  AHA{ApApAƏ\AƣAĸRApA{A33AAHAA\)AAǙAǅAAɮAA{A
=AzAĸRA
=A
=AAA
AƣAHAApAGA\)A
=AẠApA˙AʣAA33A{A\)A\)AAǅA{A=qAʣA33A  Ȁ\AA33A͙A  A=qAzAΏ\AΏ\AθRAHAΣAQA  AA(AffẠAffA
A{AHA  AA\)ApẠAAϮA{AϮApAHA
=AAϮAͮA  AθRA
=A33A(AffApAAzA(A{AGA  AffA˅AQA(A̸RAA33A
=AGẠAˮAAȀ\A  AAAHAzAQAGAȀ\AA͙AAGA33AϮA=qAQA
AθRApAHAAAAˮA{AʣAəAẠA  AHAυAυA=qAzA
=AzAʣAθRA  A(AzAA{ApAθRA  AHAʸRA{AHAAApA  A  AθRA{AzAϙAΏ\AΏ\A͙A33A̸RAAˮAA(AAHAApAHA=qAQAffA˙A33AˮAAˮA33A{AɮAȣA
=AȣA
=AQA{AHA
=AAA{AQA\)AA33A
A(AQAGAẠA=qAʣAApAAͮAA
=A\)AA33A˙AAA{A{A  AͮAAA(AA33AffA̸RA=qAǮA
Aʏ\AffAAǅA33AQA˙AAGAΏ\AẠAffAAAHAA(A\)AAffAffAA{AzAHAHAŮAAffA\)AǙAzAȸRApAƏ\AAģAGA(A
AģAffAřAzApApAAGA  A
=AHAƏ\A  AAǅAƸRA  AA=qAHA
A\)AA  AAzA
A
=AA\AAQApAApA{A£A(A  AGA
=AȸRA
=AA=qApA=qAəA33A{ApAzAzA
=A33Aď\AřAǅAAȸRAffAAffAəA{AQA
AHA\)A33ApA  AA£AÅA¸RA
AÅAGA
AHA  AÅAA{A{A33A{AǅAǅAAǅAǅA
A  A
=AffA{A  AAAA
=A33AǅA\)A(A33A˅A\)AAˮAA˙AAAAAAA{A{A  A  A  ApAGAzA
AɮApAAQApA
=AɮAʣAAAǙAǮA
=A\)AřAffAQAřAHA(A
AA=qAQA
=A(A{A£A˅A˅A{AθRAϮAzA=qA{AQAʣAffAA
A=qA{A
AиRA  AУA33A{AzAGApAљA(AΏ\ẠẠAAɮA  AAGAAffAAͮA̸RAQAAʸRA(AzAA=qA{A
A\)ApAəAzAAAffAʣAAAď\A
AîAzAƏ\AQAƸRAƸRAzAɮA\)A=qA{A=qAzAzAȸRAGAA  AƏ\A  ApAGAA  A(AȸRAAQAƣA{A33AAzȀ\A  AͅA=qAAQA
=AAA
Aʏ\AAA
=AQAAGAQAřAQAAʸRAʣA\)AffA  A33ApAA=qAȸRAAzAˮAAʏ\A(AzAȏ\AƣAGAŮAĸRA\)A\)AffA
=A{Aď\A
=AA=qA
A\)AAApA\AQAQA\)AzAĸRAffA33A
AzAAA\)AƣAAʏ\ApAffAAʸRAffAAzAHAAAAAУAffA
=AAA
AϮAGAҸRAҸRA\)A\)AAՅAԸRA
=A\)AծA(AApAЏ\AAHAffAffAAQA  Aȏ\AAΣA  A\)AĸRAAAHA33Aʏ\AQAA
=A(A{AffAθRA(AA33A33A{AǮAA
=A{AA
=AAAQA
=A  A=qAQAʣAHAθRAA(A
=Aʏ\AGA=qAAΏ\AхA  AGA͙AA(AzAA33ApAA{A=qAAAffAθRAA33AA=qAzA  A͙AHAɅAQAffA  Aʏ\AA=qA(A
A  AЏ\AУA
=A33A
A33AHAəAGAˮAHA=qA=qA
A̸RA33A{AQAΏ\A=qA=qA
AɮAA\)A=qA{AQAHAGA(A{A(A=qA=qAA{AHA(AəA(AA  A\)AQAGAQA\)AffȀ\AˮA{Aȏ\AApAθRA
AHAApAzAzAAˮAAzAΏ\A˅A33A͙AΣApAzAQAffAQAA33AGApA͙AA{A(AzAυA(AQAffAAAУA=qA(AA
A33AAAAQAͮA(AffA\)A˙A\)A˙A33A33AffAQAəAʏ\AəAɮAɮAʸRA(AʸRAʏ\A  AɮAʏ\AʣAQA  A
A(AAȣAGAȸRAɅA=qA=qAA  Aď\AAȣAƏ\A33AǅA  AGA{AHAzA
A
=A
AAAAљAӅAGAAGAGAAAzAGAAzA{AzApAȀ\AQAGAAңAңAQAAңAУAApAAAΣA(AΣAA
AθRA\)AAffA{AA33ApA{A
AHAHAffAˮA̸RA̸RAA33AA
=AHȀ\A(AA
AA
AǮAɮA{AHAřAAÙAŮApApA\)AɮAzAHA33AAzAHApAAAϮA  AffAAиRAAQAAAAA\)A
A
=AӅA33AffAAffA(AAA  AѮAѮAхAхAAffAQAAGAAϙAϙAzAA
AQAQAffA(AϮAAͮAΏ\AΏ\AAA
=AϮAAA͙AA
=AΏ\AQAQAQA˙AˮAzAͮAAAQA(AAffA33ApAΣA\)A
=AGA(A=qAΣA{A=qA{A{A
AхA
=A(AzA{AυAΏ\AΏ\AA=qA\)AʣȀ\AAffAAHAAхAzA
=A\)AA
ApApAHAA˅A˅AAGA
AHAəAA˙AApA33AA=qAΏ\AA(A=qA\)A{AA33AʸRAHA  A\)AAAʣApAAυAҸRA33AңAAA
=A  AHAzAәAffAAAffAӅAffAHAGA33A(A(AծAA\)Aԏ\AGAA
AѮAHAѮA{AzA33A33A
AӅAхAиRA
AGAϙAУAA\)AAҏ\AA\)A33A֣AGAA
=AQApA(AУAљA
AAHA
AHAQAυAA{AAиRAQAУAQAиRA
A=qA֣A
=A֣A33AԸRA33AA\)AffA\)A{AzAA=qAffAԸRAԣA\)A
=AծAQA֣AA  A(AHAA\)AzA֣AHA{A  AיA׮AAיAՙAѮAHA{AׅAҸRApA{A(AGA=qAԏ\AAQAzAffA33AQẠAҸRAQAHApAAԏ\A\)AծAծAՙAA
AffA  AGAͮA  A  A{AAffAУApA
=AAzAGA{A
=A{AAAAAиRAљA33AA=qA
=AffA  AA33A=qAAQAAAѮAҏ\A
=A  A{A33AA33AAծA=qA
=A֣AAҸRA{A(AA=qA=qAGAGAΣAQA{AУA{A(AхAffA\)AAQAffApAͅAљAA\)AͅAA
=Ȁ\A
AA\)AQAϮAHAQAGAΏ\AzA\)AϮAυAϮA
AAA(AQAA(A33A{A˙A͙A
=AͮApA33A33AʣAȸRAɮA(AȸRAȣA
AQA=qApA
=AHAAɮAzA
AQA{AA˙A(A
A33A
A{A
AΣAϮAzA
AffAͮA
ApAиRA33AA
A  AAУA  A=qA=qAAΏ\AzA33AA̸RȀ\A͙AzA  AHAA(AffAHAAzAApAzAA33AAzAAAAǅA
A\AAARAÅAŮAGAAHApAAQAHAʏ\AA  A(AɅAAzA
=AAffA
A{A
=AGA˅AzAA  AzAGAzA
A{AffAHA˅AQA
=A
=A\)AA
A(AAΣA33AУAẠA˙AAˮȀ\A33A\)AzAQAQA\)AffA\)AиRAυAϙAHAQAGA͙AAȀ\AˮAA  A̸RAzAAΏ\ẠȀ\A\)AA̸RAffApAQAHAAAGA=qA=qA͙A33AˮA
A(AffA\)AʸRA
=A
=AHA33ApAHA  A33AǮAAA  AƣApA
AAzA\)AQA\)AˮAGA˅A
A̸RA
=A
AQAHAAHApA(AϙApA=qA(AͅAA  A\)A\)A
AθRA˅AУAAУAHAхAA=qAәApApAҸRA{AA\)A  AffAљAffAHA33AAApAAffA=qAA=qAԏ\AA\)A(AѮAAAGA{AzAffA{AA\)AAHAzAA
A(AȣA{A\)A=qAA=qAȏ\AQA=qAA
AQA  AQA  A
=AAA(AffA  AɅA  AəApAAA  AA˙A(A33AA
=A=qAHA33AυA
=A
=AHAQAGA\)AffAHA\)AυApAGAAϙA  AϮAAϮAυAϮApA(A̸RA
=A{AˮA
=AAQA
=AͅA  AAA
=A
=AA(AΏ\A  A{A
=AẠAəAʸRAHAHAA
=AхAffA
AffAAA\)A̸RA(AA{A=qAA{AAGA
=AGAA
A\)A=qȀ\A=qAʸRAɮAAzAGAAzAΣA̸RAA
A  A=qA  ApAA
Aҏ\AzA=qA{ApA  Aҏ\AѮAHAzAQAңAA=qA
=AͅAQAQA  A  A(ẠA=qA\)AzA
AffApAQA
A(A
AA
=A(A˅AˮAA(AQAͅAA33AffA=qAA\)AAA  AȸRAzAA\)A
=A33A\)A  A{AGA
=A33A=qA
=A33A
A33A\)ẠA33AͅAͮAθRAHA33A\)ApAAHAGA
=AzAAGAAAAzA
A
A
=AHA\)A  AffA
A\)A
A
=A=qAAAA33A33ApAffA̸RA=qA˙A33A=qA\)AʣA(AA=qA
AA{AzAA{A\)AȸRAȸRAGAȣA\)AQAAHAHAzA
A=qA(AAQAzApAHAA  A(AAAQA{AͮAffAGAAAʏ\AQA=qA
=AzA˙A{A33AʣAffA\)A
A˙AɮApAəAɮA  A=qA{A
A  AQA(AQA=qAQAA
AAA(A=qAˮAɮȀ\A
=AθRAGA
A\)AffA  AQAzA{A=qAApAAAA33AQAəA
A  AHAǅA
AģA
=A\)A\)A=qAHAQAzAƏ\AɮA{AQAA(AɅA\)AQAA
A=qAQAA33AGAQAΏ\ApA33A
AΏ\AAHA
=AϙAA=qA=qA
=AQAθRAθRAffA=qAffA{AGAzA\)A
AɅAʏ\AAA˅AGAͅAHA  AQA  A=qA{AGA
A
A33AHAȸRAȣAAǮA  AǮAǙAAA(A
=AAAffAɮAQAA33AHAffAϙA  A(A
A(A  A{AApAυAGA
=AzAͮApApAzAzAQA=qA̸RAQAAΣAΣAΣA\)A=qA=qA  A(A(A{AA{AͮA33A͙AͅAAAA=qAHA33AQAzAffA  Ȁ\AffAQAQA  AAA˙AA
AɅA{A  A˅A33AAGA\)AA
A
AGAGAGAzAAˮAřAĸRA(A˅AɅA\)A
=AzAAA  A33AˮȀ\AA̸RA(ApAA\)AхAхAA(AQAQA\)AHA=qAΏ\AAAzAA
A(A\)AffAffAA
=AHAAˮA˙A̸RAυAGAA  AA͙A
=AHA\)AͮAGA
=A˅AGAHAA{AHAHAA(AǅAAffAAHAƏ\AAHAǙA33AȣApAGAȣAffAA=qA
=A{AȸRAAAȏ\AzAɮA\)A\)AəAQAA̸RApAΣA\)A{AQAffAAGAAzAңA{AApAAA\)AHAӮAQA(AҸRA  A(A
A  AAffA  AУAApAљAffAA{AffAϮAQAЏ\A
A(AAQA(AңAQAA\)ẠAA\)A33A\)AHAAzA33A
=AHAA=qAϙA  A  A{AA
AΏ\AAzAffAA33A\)AәA\)AӮAՙAAQAԏ\ApA=qA
A{A
=AHAA{A(AGAָRA֣A{AAӅAңA
=AAӮA
AәAAӮAAAAGAA{AAҏ\AA{AӅAӅApA33AGAAAAAѮAυA
AGAAAиRA
=AzAzȀ\A=qA
AffA33AzAzẠA33A͙AͮAAυA  A(AA=qAΣApAzAAҏ\ApAAхAA(A(A=qAHAGA  A(AQA{Aԏ\AffA(AQAиRAA{A(A(AϙAGA(A
AѮA{AAҏ\AApA{AA\)A33AHAA=qAͮA  AӮAGA
=A33ApAՅA{AA\)A
AA  AθRAAffAͅAͅAA\)Aʏ\A\)A
=A  A33AƏ\A  AA=qAzAzAGA  AGA(A  A\)A
ApȀ\A
A
=Aҏ\AA  A=qA{AQA
A33AGA{A
=AffAQAzA(AԣAzApAA{AAAGAѮAAzAGAzA=qȀ\AAЏ\A  AϮAиRAAAυAΣApApAУAA
AA{AHAA{A  AHA
Aʏ\ApAAAApA\)AQAA  AffAA{A=qAAffAȣAQA
AƣAQAzAAAGApAʣAA=qA\)AA̸RAȀ\AQAQA=qA
=AffA{AͮAϙA
AGAzAҸRAA33AAAA{AA\)AӅA33A
=AAңAzAӅAzA
A  A(AәA  AzA(AA=qA(AQAHAHAAQA{AQAAȀ\AAffAzA\)AAzAzAffAHAͮAͮAˮAʏ\AzAzAʣAʣA33A
=AˮAA
=AAɅA
A\)AɮAȀ\A{A{AffA
=AϮAЏ\AУA33AffAA(A{A(A
AAʏ\AA\)AˮAHAHAGAApAzAΣA\)AA\)A
=AAHȀ\A͙A(ẠAzAQAA\)AAzAHA{AθRAAͮAzA=qA{AffA33AAffA\)A\)A
A  AA{ẠA{AffA˙AzAzA(AAffAΏ\A=qA͙ApAAȀ\AυAυA\)AυAA(AAAυAGA
=Ȁ\A\)ApA\)A(ApAAGAˮAʸRAʣA(AA33A33ApAHA33ApApA
AA  AAAθRAffAA
AAͮA(AΏ\A
AͮAAΣA{A(A{AͮAA  AͮA\)ẠȀ\A\)AAAA
A  AɮAȏ\AəA
AǅAA
A33AzAʸRApApA=qA{AzA{A{AAΏ\A͙AA\)A  AυA{AAQAУAQAЏ\AУAЏ\AGAHAQAѮA(AHAApA{AAGA
=AυA
=AAAQAϙAϮA{A
AA  AAϮAGAAхAHA  A=qA{AHAәAӮAHA33AӅA
=AA(A(AϙA\)AљA
=AAУAffAЏ\AAAҸRAЏ\AHAAA  A=qAA
=Aʏ\AAQẠAȀ\AͅApApAffAzȀ\AffA=qẠAˮAAʏ\A33A
AʸRA
=A33AA{A\)AAA=qAȏ\AA  AȸRAʏ\A
AffAͅAGAffA
A{AAɅAHAQAA(Aʏ\A{AGAHA(AffAAGAQA  A
AA(A
AGA=qAQAAȣA=qAȣAAAAffAffA=qAzA
=AA
A
AA  A  A{AHAAGApAA˅AHAɅA  A{AʸRA
=AzA{A
AʸRAQA(A(A
A  AAGAʣAHAAAGA\)A{AGAȣA33AɮA  A=qA=qA{A  AAAA  AA
A
AɮAA
=AA33AʸRAHApA˅A{A
A˙AʸRAA
=A  A33AGAQA\)A=qAʣA\)AAGAAA˙AffA˙A˙A33A
=AˮAʸRA33A(AAAAʣA=qAAȣAffA=qA{A  A  AApAffA˅A
AAA=qA(AA(A=qA33AŮAǮAȏ\AzA(AHA{AƸRA
=AA  AzAȸRAȏ\AGA=qAəAA\)AǙAǮAƸRApAAAA{A33AQAzAȣAAʣAA\)AAApAHAʏ\AffAA
AǮAA\)A33A33AǮAA\)AǙAAȏ\A
AȸRAA
=AAǅAGA
AȸRAAʏ\A=qAQA{A{A{AAGAʏ\A{A{AGA
=AQA=qAAǙAAǙAHAAģAQA(AŅAAA{A  AA(AzAAÙAHAHAQAA
ApAA=qAȏ\Aȏ\Aȏ\AȣAQAQAȸRAA
=AA\)AAəA=qAzA=qA˙A
=Aȏ\A\)A
A=qA
=AAAGAA\)AGAGAəAGA  A(A
A  AəAɮA\)AAȏ\AȸRAzAȣA=qA{AzAƣAƸRAǙAǙAzA
=A(AîAƣAAAƸRA\)A
=AA
=AƏ\AƸRAǮAHApAA33A\)A33AA
AHA=qA
=AʸRA(AAǙA=qAzAȣA\)A\)AɮAAAQApAQAHA33A˅AˮAˮAˮAA  AzAA=qA{ApAA\)A  ApAAɅAA\)AAA\)A
A=qAA=qAzA
=AA(A(A{A=qAAHAǙAQAHApA
AQA{A\)ApA33A
=A{AǙAzAffApA  AGAAȏ\AǮAA{AAǅA  A(AzA33A33AȸRA=qAAʏ\AɮAA33AAAzApApA\)AẠAAA33Ȁ\A̸RA
=A=qAAA
=AʣAʏ\AA{A
A˙A\)A33AAQAAAQAffAAAzA͙Ȁ\AͅAzA(A(AͮAA\)A͙A
=AA
A
AA  A33AAzAQA\)AApAȸRA=qA=qA33AA  A33A(AffAAəAAȣAffAffA\)A
=AȣA  ApA
AʣA  AQAffAzAʸRAʸRAʣA{ApAAHA
AˮAzAA  A33AͮApAͅA{A
A͙AͅA͙A\)AGA̸RAA(AAͅA͙AAApẠAAͮAAA
AAͮA͙ApApA\)AzA{AAAA
A˙AGA˙A˙AGAˮAA
=AAAʣAHAʣAʣAAʣAzAAȏ\AA̸RA(A
AθRA33A(A33Aʏ\A  A{AA=qA
=AApApAffAΣAAAGA33AϙAҸRAхAQAУA  A(A33AffA(ApAϙAA  AQAυAυAApA
A(AQA
AzAffA{A
A
A
A33A\)AΏ\AθRA\)A{AQA(A{A
A  AA\)AAυApA
A  AAAQAQAиRAЏ\AQAA{ApA˙AApAAffȀ\ẠA
A͙AA͙A33AA̸RAͅAGAәAAA{AffAԏ\AԣA(AԣAAzAAA  AA=qA=qAzAҸRAҸRAҸRAѮA
A
ApAѮAљAѮA
AхAAA33ApA
=A  ApA\)A
=AЏ\A{AAGAAϮA
AA  A(A  AQAAQAиRAυA33AљA\)AQAϙA
AAAУA͙AAAθRAffA(AɮAApAzA˙AA
=AхAQAУAЏ\AzAzAQAffAAQAAϙA\)A(A͙A\)A{A
A{AAAApApAиRAAAffAQA  A
=A\)A33A33AΏ\AzAΏ\AΏ\AΏ\AΏ\AAHAΏ\AΣAΏ\AΣA=qAzAffAffA(A(A=qA=qA(ApAAȀ\AȀ\A˅A
=AʣA\)A  AəAȣAʏ\A(AHAAAAAA
=A33A
AffAzA
=AҸRA\)AAAGA
=A=qAQA=qAffAffAAAGAθRA  A  AGAzAиRAHAЏ\AЏ\AAzA\)A
A33A(AffA  AϙA\)AAAAϙAϙAAGAzAffAzAA
A  AAzA=qAHA
=A  AzȀ\A
=AAAzȀ\AzAffA˅A\)ApAAHAQAəA̸RẠA
=AAəAA
=A˅A
A˅A˅AQAAͅAϮAиRAУA  AQAAAQAЏ\AffAQAzAЏ\A
=AA(AAHAHAAzAУAApApA
=A33A{A
=A33A
A
=AA{AffAЏ\A{AAAυAυA{A(AAΣAQAAQAΏ\A=qAffA  AAA
=AQAȸRA\)AGAʏ\AHAzA=qA
=AˮA  A  A  A̸RAGA  A=qAAffAA33AϙApAAυA{A{AffAAЏ\A(AHA33AAHA
=AGAхA\)A\)AAAffAQAΣAυA  AA
AAA33AAA=qA(AAΏ\ApAυA
ApAHAHAzAиRAЏ\AQAA{A˅A\)AAʏ\AApAAAʣAȏ\A
=AHA\)AzApAʏ\AApA\)AzAQAΣA  A  A  AͮA{A33AѮAљA
AA
AԣA=qAAffAԸRAՙAA\)AHAHAԣAԏ\AAԸRAQA  A{A
AA
A
=ApAՅAffAzA\)ApAAGAAAAAAAϙAA33AzAzAϙA  AѮAAA
AGAѮA(A
=A{A
AхAQAQAQAˮA˙A33AHAͮA\)AϙAzA  ApAΣAA  AGAA
AAљAхAzAffA
=A{AϙAAApAϮAУAHA
AAAAԣAzAԣAAԣAԣA{AffA  A\)A=qAAGA
AAυAΏ\AAA˙AffAAHAͮAzAAA\)AϮAQA\)AffAHAAffAиRAиRAzAУAAA\)AͮAA{AəA  AA=qAθRA{A
A{AffAGApA=qAQAQA  A  AA{AңAAAQAQAzAQAQAffAffA=qA
AAˮAA
A
AA
A\)AA=qAϮAиRAAӅA  A(A{AAzAԸRA{A=qAхAљA  AЏ\AAυAхApAffAA33AAΏ\AΏ\AΣAˮAAϮAиRAHA  AУA\)AHAңAԣAљAхA  AљAѮAAңApAAzAAAA33AGAAHAAҸRAхAљAљAѮAѮA
AAљAӅA=qA33AхA\)AиRAA(A
A{AQA
=AAAAGA
AAϮA=qA  AAϮA
AУAffAA(AAΏ\A{A(AGAHA͙AθRA  AzA{AzAAA\)Ȁ\AA
=A˅AˮA33AHAAˮẠA=qAAGAHAffA33AˮA=qAAzApA
=AHAA{A{AA{AϙAHA
A{AɮAȸRAȏ\AAzAɮAɅAzA33Aȏ\AQApAA  AͅAͮA\)A
A\)A{AAҸRA
=AQAθRẠA{A\)A=qA
=AͅA  AΣAA
=A̸RA\)Aʏ\AzA33AA˙ApAGAAAAHA{AəAɮAɅAʣAȣAɅAAA  A=qA˅AGAʣAzA(ApAAʣAApA˅AA˙A˙A33ApAď\AA=qA=qA(A=qAAǙA
AzAȸRAA
=Aȏ\AAǮAȣAAȸRAAAQAȏ\A=qAȏ\A
A
AffA˙AAʣAAzA
=AʣAffAzAA\)AHAQAAʣAɮAȣAȏ\A
=Aȏ\AȸRA33AA
=AȸRA{AȣA
=A=qAʏ\ApAAȣAffAAGA(AŮAHAřA{AƣA  A{A
=AffApAAɅAffA{A\)A(AAʸRA˅AAHA(A(Aʏ\A\)A{A  A=qAQAQA̸RA\)A  AAzA{AQA\)AA
=AA̸RAAAAAͮA͙A(A
AApA  AffAAΏ\A=qA=qAQẠA{AA\)AGA˙A
=AzA(A{AffA(A˙AQA{AffAɮAAA=qAApApAAƏ\A(A\)AA(AAGA˙A
AˮA
=A˅AˮAAθRAA
=AHAAA
=A
=AAAAHAΣAΏ\A(AA͙A˙A=qAˮA˅A\)A{A=qA  AzA\)A\)AzAQȀ\ẠAQAA  ApAzAɅAAʏ\A  AQA=qA̸RAAAAAffA
=AQA˅A\)AA{AHA(AzAAəAGAzAʣA˙A
Ȁ\AAǮAA\)AǙAAffA=qAɅAHAffA
A33ApAAAʸRAAAAʸRA=qA(A  AffAQAA  A
AQAzAffA  AʣAGAʏ\AʸRA33A
=AAA˅AHAGA33AəA
A
=A
=AɅA
=AHAẠA{Ȁ\ApA=qA
=A  AəA\)A
=AffAffA(Aȏ\A{AǮAHAffA33AzA(AGAAAǙA  AQA
=AQA
A33AAApA(AɅAzAA33A(AȣAHAApA33A˙A˅AəAAɅAA{ApAQẠAAHAHAAHA
=A̸RAHA̸RAȀ\Ȁ\ẠAHAHȀ\AHAAHẠA̸RAHA
A  A
AffAAzAHA\)AʣA  A=qAzAAffAAAAQA(A˙A33AAʣAAAʏ\A  AǅAzAQAʏ\A
A33A
AɅA=qAǮA  AzAAApA
=AHAffAQAAffA=qA{AAzA33A(AɮAQA͙A\)AͅA
=AGAȸRAȣAGA33AzAǮAA\)AƸRAɮA
=AzAAQAͅAffAˮA
AApA33A˅A
A
=AffAȣAHA
=AApAHAAʸRAHAAQAȀ\A=qAffAAAǮAzAǮA{AƸRA\)A33AAApApAzA
A\)AA
A=qAAƣAǙAǅAQAQAȸRAA\)A33AȸRApA
A(AffAffA=qAAQAQAzA
AQAAffA{AɮAffApApAAAȸRA
=A(A(A=qA33AffA(A(AA{AQA̸RAHA
=AAGA
=AA
=AA33A͙AͮAͮAGAͮA
AͅAGAGAȀ\AffAA{A
A˅A˅A\)A33A\)AHAHA
=AzA{AAʸRAʸRA
=AʸRAHA
=AAQA33A  AŮA(A(AǙAȣAɮAAHAȏ\AGAA
AŮA33AGAAApA(AffA\)A=qAÅApA\)A(AQAHAA{A  AəA  ApAƣAA  A  AƸRA
=AɮAzAA{A
=ApAzAHA
=AAθRAͮAͅAȀ\A˅AAAAȸRAffAA  A33A\)A(AAʏ\AzAzAȣAAGAȣAȸRAɅAAƣAffAHApA(AAAǙAȣAȏ\AAɅAɅAQApA
=AřAGAHAGAǅA
AQAȣAɮAəApA\)A\)A(A
=AzA˅AʸRA(AQȀ\AAʣA{ApA\)AʸRAHAʏ\AzAAʣAffApAʏ\A˅AAʏ\A  A(A33Aʏ\AA
=AA\)A
=AɅAřAA  AGAffAAɅA=qA(AAǅAQA
ApȀ\AApAGAAHAAzA=qAQA  A  A  AA(A=qA{AAApA\)AʣAAAAȣA\)A
=A
=AHAȏ\AǅA33A
AzA
AAAGAʏ\AAA(AQAffAͮAQAθRAΏ\A=qA(AͅAAA̸RAffA=qAAAA  AAAAffA\)A33AAQApAΏ\AA=qAΏ\AzAΏ\AzAΣAAzAQA33A\)AffAzAGAAHApAAAAHA\)A{AAHA  AQAzAΏ\A
=AAAΏ\AAffAQAΣA{AzAAѮAGApAљAAHAzAffAAиRAAљAQAAΣA(A  A33AHA
=AAQA{AGAApA{A
=AGȀ\AzA
=ApA{AẠAʏ\AQA  AAQAHẠẠAΣAAͅAθRA
=AA
AAQAffAУApA=qA33AAGAAHAHAʸRA\)A\)AAA33A{AzAQAzAzA=qApAҏ\A
A
AAљA33AA
=AAЏ\A=qAA{A
AffA  A\)A\)AHAθRA\)AϙAGAA{A\)AˮAA\)AA˅AˮAʣAHAəAəA  AGAʣAȸRAA33AA{AAȸRAAGA(AAHAɮA{AȣAȣA  AAƸRA\)AA
AGAffAA  AAA(A(Aȏ\A(AA{AffAzA\)AɮA˙AA̸RA=qA
A33AAHAQAA
AffAffA(Ȁ\Ȁ\AQAQA
AˮA\)AAʸRAQAHAʸRA˙AAGAHAzAA=qA33AˮA  A˙AAəAʏ\A  A{Aʏ\A{AzAʸRAʸRA=qApAzAAAAAAAffAHAǅA33A33AȣAzA
=AAAAQAAQA{AApAA=qAAAApA
AƸRA
AffA
A˅A{A
AAȏ\AɮAȸRA(A33AȸRAɮA{A33A˅ApA˅A˙ApA(A˅A(AAGApAˮA{A
A  A
A
AˮA˅ApAGAGAɮA  A\)A  AʸRAApA
=Ȁ\A(A33AGAʸRA
A˙A33A
A\)AA=qA
=AHAffA=qA\)AGAAȏ\AƸRAAA33AGAzAA\)AAʣApẠẠA(AGAǅAəA33AəAȏ\AzAAɮA
A  AAzA=qAHAAA33AffAͮAzAAQAA=qAffAͅAQA=qAHAΣAHAAΏ\AͮAΣAΏ\AQAA33A  Ȁ\A˅A(AffAHAQAGAȣAQA=qA{AǙAffAAA(AHAAHA\)AQA\)AffAͅẠA
=A\)A  A
A
=A
A
=AzA\)A(AA
Ȁ\AA  AͅA\)A\)AApAθRA˙AHA(AzA33A\)A(A
A
A  A=qAƸRAGA{A(Aȏ\AffAffȀ\A͙AHA33AϮAffAAffApAϙAA=qAGA
=A{ApAϮA  A̸RAApAAQA
AΏ\AA  AAzAA
AffAA˅AA˙AAA(A=qAQAAA˙A˅AA33AHApAɅAAGAɮAɅAA
AffA˅A\)AA
AA
=AAA̸RA{AffApAəAAzA
=ApAGA
=AApA˅AʸRA\)AGAəAɅAȣAAƏ\A33AȣAGAHA33AƸRAzAAQA
=AffAA{AîAAApAȀ\A=qA{AGAA˙A\)AGAHAffAzAAzA(ApAA{AAAɅAAHA{AzAAA̸RAHAAA
=A\)AQA(A͙A\)A\)A
=ẠẠA(A{AHApA˙AffAHAʣAzAA  A\)A͙AAAΣAA(AQAAGApA  AǅA{A(A  AA
=A(AHAffAGAͅA
AˮApAɅAQAȸRAɮAʏ\AAȏ\AʸRA
=Aʏ\A  AGAˮAʏ\A{ApA(AƸRAAƸRA
=AA\)A=qApAAGA\)AA
=AAAƏ\A=qAǅA(ApAʣAʏ\A{AʣAʸRApAɮApAA
AGAǅA33A(AȣA  A  AȣAǙA33AƣAƏ\AAGAƸRA33AĸRAAAȸRAzAȏ\AǮA=qAʣAGA33AAAɅAAffAzA  A
=A33AƸRAAŅAQA
AA=qAHAAA  A£A(A{A¸RA
A=qA=qAA
A{A
=AzAAA33AAA
AAAQAAAÙAAQAAǮAffAzAApAzAAAAřAzAQAȏ\A(AǅAzAŅAA\)AřA\)A
AģA{AÙA\)A
AGAGA
=AAApAAAHAAzAARA\)AA
A
=AA\)A  AHAzAzAHAffAAQA  A{A=qAHAzA33A(AA=qARAQA\)A
=A(AGApAA=qAAAA\)A\)AAÅAA¸RAAAA
=A¸RAzA  ApARAffAQAAHAA¸RA=qA{A=qA33AAzAQA=qAAA
=ApAA{AA\A{AffA
=AŮAAAAAƏ\AffAHAffAAřAA\)A{AAǅAĸRAĸRA{AGA  A
AŅA{AAAď\AÙAÅAAď\A=qAGAAîA  A{A(AzAffAA=qAffAA  AAQARA=qA(A\)AAA
A=qA=qA33ApAGAHAzA¸RA
AAzA\)AQAGA33AARAřAApARAA(AA
AA  ApA\)A£AAffAffAAÙAAGA(A£ApA=qAA  A(Aď\AA  AffAzAAîAÙAA\)ApA  A\)AGAzAAģAApAA33AQA
=A{A{A{AGAǮAHAzA
AA33A  AA33AA\)A  AřAAAHAA=qAAAAApA  A(AA{AîAģAHAAffA  A{A(A33AAAGA¸RAAQA
=AAřApA
=A
AffAffA=qAGA\)A
=AHAǮA
AŅAQAŮA
A33A=qAAŅA(AA\)AA
=A33AǮAǅAHAA(AǅA{AQA(A
A\)A
AAAǙAǮA\)AǅAA
=AffA\)AȸRAGA\)AGAA
=AAA=qA\)AȣAǙAŅAAď\AHA  AffAQAHAzAApA
=AAffA  AAAzAď\A33A\)AAGA=qAȏ\AHAɮAHA\)AǙA(AǅAǙAffAəAGAHA˅AAA̸RAHA  ApAəAəA{A(A{A33AəA  AHA
=AÅA£A{AAģA
A(A£AAA(AAQA(AÙA(AĸRA33AAGA\)AAGA33AHA(AȣA
=AAǅAA33A
AffAHA(AɮApAǙAHAřAQA=qAffA
=AApA£A(ApAA=qAGAHAAHAA(A33AǙAǙA
A(A=qAǙA\)AAGAGAŮAĸRA=qAzAQAƣAAQAffA33AîA=qAAzA=qAAA
=A
=A¸RAffAGA33AApAffAGAA{AffAGAffA(A(AŮAAƏ\ApAffAffAAHAHAAQAAGAA33AGAGApA  A33AA(AA{A33A
=AŅAŅAzAîAA  A
=AAAAffA  A
=AffA  AǅA
A
AȣA{AQAzA{A(AAGAGAAAAQAGAffAAGAAAQAA
=A\)A\)A33AQA(AA{AQA(AffA  A{AGAffA(AA¸RAffAA33A  A  AÅAîA33AģAGAîA
AAď\AA
A\)A33ApAffAQA(A{AAŅAAŮA  A
A33AģAHAGAAŅA33AAAHAzA=qAA  AGApAAGApAGAď\AffAQAA\ApAĸRA=qAĸRA  A=qAřA
A\)AģAģAApAA  ApA=qAHA  AAGAffA(A
=AƏ\A33A  A
=AHA{ApAHAƸRAƸRApA{A
AQAQAAAƏ\AQAzA\)AƸRA
A=qAƸRA33AAAA\)AQA  AǙA{A  Aȏ\AQA
AQAffAȣAffAffAǮAA
AQAApAAǮAA=qAȏ\AAzAQAȏ\A(AQAȸRAȸRAȣAȣAA33AQA=qAQA(A{A  AA{AǅA  AA  AAǮAAƸRAǙApAzA33A(AƏ\AA{A(A
=AřA=qAƏ\AzAffA
A(A  AAƸRAƸRAffAƸRAAƣA\)AǅAffAAď\A
=AAGAAzAApA=qA(A{A=qA{A  AA\)A
=A33Aȏ\AȸRAɅAəA33A33AɮAApAGAAzAGA\)A
=AzAffAAȏ\ApA33AA
=AAȣAȏ\A
A\)AA  A
=AǙAəAAǅAAAA=qAQA  A33AƣAAAAAƸRAA33A{AƏ\A(AAřApA33AAƣAHAřApAGAAA(AÅAGAA{AA
=AffAffAAffAÙA\)ApAAA\)A  Aď\AffAAGApAŮAA  A(AƏ\AƣAA
=AAHA
=A(A=qA(ApAƏ\A
AA(A
=AHAQA=qA{AȸRAzAAHAAAA{ApAHAQAHAffAȏ\A33AAQAɅAAȸRAGApAAGA\)AǮAHAffA  AGA33AA\A¸RAîA=qA33A  AQA33AƸRAǅA\)AǮAŮAȸRAHA{AAƏ\AGAǮAAffAȏ\AǮAffAzAAĸRAA
=AAÅA
AQAffAģAApA  A  AA(AffAƏ\AƏ\A{AAŅAřAŅAŮAŮAA{AAAŅA33A33A  AîA
=AAQAĸRAîAģAzAģAffAĸRApAÅA  A(AA£AA¸RA33A
=ARAAAGApAA33AQAA(AA33A33AffAAAGAAA\)A(AHAHA  AApApA\)AAA\)AzA=qAAGAffA
A\)A\)A
A{A\AAHAffAA33AAAQA\ARA33A\)AA  AzA=qAAAGAGA\)ApAAAAAAGAQA
=AHARAQAA
A=qA£A¸RAA¸RAzAA\AffAAƏ\A
=A  A
=AAģAÅAHAAAGA  AGA\)A=qA
=A
=AA{A{A=qA
AAA  AAA=qA
=AAHAAHARAApApA
=AHA=qAǮAQA(A=qA(A{A\)AÙAA  ApA\)AAzA=qA  A\A£A¸RAQAAA  A33ARAAzAAffA\A
AAA(A  AAA{ApA  A33AAAAGAApAAApAA
=AAARAAAA
A
A£A33A33A
=A33A=qAAzAAA  A33AA  AÅAffA  AAAA(A=qAAAAAA33AffAîAŮAARAGA\)AzAHAGAGAģA33A£A
=A  AA
=A\)AA(A33ApAGAAzAAGAffAAA\)A=qAA(AAAA=qA(A\AffAA(AGAAGAÙA
=A=qA\AHAQAřAAA33AřAAď\A33AA
=Aď\AHA
=A{A  A=qAŮAHAƣApAA
=A33AA\)A
=AA  A(AA  A
=AAQAzAA\AAîAAffA\)AAHA  A{AAGA\AzAA=qA{AAARA=qA¸RAGA=qA  AffA  A=qAHAAQAGAHAAHAAzAAA
AƸRAAAǮAǮAǅAAǅA33AƸRAƸRAƣA(A{A  A(AAA33A\)A{AA(AAŅAAHA
=A\)A
AAA(A(A=qAƣAApAAřAAGAĸRA(AAîApAAHAA  AřA{AAA{A(AǙAAHAA
A
AHA
A
=AAGAAzAAAA\)AGA
=AHAHA=qA33AÙAď\A
=AzAĸRAAA
=A
=A\)AģAffA33AAzA(A=qAzA(AƸRA
=A33AƏ\AAAGAA=qAzAQA33A
=A
=AǅA=qA{AǅAffA
AAǅAzAƏ\AA  AGAģAģA
=AA
=AAAģAřApA  A  A(A\)AAHA
=AzA(AAÙA\)A\)AzAAffAffA
A
AA£AQAA
=AQAQAAƸRA
=AApA¸RA  AîAffA(AGAƣA(AffAģAA
=AffAŮAGAAřA=qAQAzAŅA=qA
=A33ApA  AffAAAɅApAA{AA  AAAA=qA  A  A(AɅA(AAzAʣAffA=qAffAɮA33AȸRAffA=qA=qA(A  AǮAAHAƣAƸRAApAǙA{A  ApA  AAQAHA{A\)AǙAǅAǮA
=AAA(A
=AĸRA
AGAŮAŮAA=qA\)A
=AAAAffAA
=AAAAHA
=AA
ARAAApA(AAA
=AzAzAQA(AA\)AA\)AffAAA\AHAQA
AAA{AzA(AAA\)ARAGApAAffAzA  AA
A33AA33A\AzAzAAAzA(AA{A{AAAAA(AGAAApAHA33AGA{AAAQAA(A33A(AAGAGAzAffA\)A
=ApARAAA33A
=AGApAA33AAA(AAAAQA(A33ARA\AffAAGA
AAA\)AAzA{ApA=qAAAA(AGAA(AAQA{AAHAAAA{AAA33AzAzA
=ApAHAffA=qAAA
=AA\A33A
=A  A(A  AQA  ApA\A\AGAffA\A  AA
AAAA
AGAHA
=AHAAffA(A
ARA{A(AffA
=AA{ARA
=ApAAGA  A
=A\)A\)AGAAAA\AAAGA
A  AGAA33A\)AAA\A  A
=A33AA
=AA{AffA33A
=AAA(A
A  ARApAAAA=qAAAGAA\AAQAA\)AQApAAffApAA
AAA=qA\)AGAffAHA33A33AA
AQAffAAAA  AQA{A
AAQAGA=qAAffAGAA\ApAA
=AA\AffAAzA
A\)A\)AQA
=A  A{AAQAApAA33A33A
=AA  ARAAHAAAGAAAA
=A\)AAA{A
A  AAA\AQAAA  AA
=ApA\AQAQA\AzAzA
AAA
=A  ARAA=qA=qA  AA  AHA
A=qA
=A=qA\AQAAHA{A\A33A
=AA  AAAQARA\)AffAzA
AQAAGAARA
AAHAA(A\AARAAAAGA  AHA\A=qARA\)AAAAGA{A(AzA(AzAA
=AzA\AGAARAAHAQA\)AA\AA(AzA\AApA{A{A  AAAAAAGA=qAGApA\ARARA{A=qA(AGA
A
=AzAAAAAHA
AAQAAA  AAAA\AAQAffAAGAzA\)ApAAGAA\AAHAQAA
=ARApA  AQA=qAffARA\)A  AA\)A{A
A  A=qAAQA(AA
=AzA\ARA(ARA\)AQAzAffAAQA  AzAAAAQAffARA  AAA\AAHARA  ApA
ApAARAA(AA(A{AA\A(AApAA
=AA
=AAHA\A(A(A(AAA\AA\AzAQAAffAAAA\)A\A\)A(A  AzAA33ApA  A33AARAApAARA
=AGAzAAA\AAAzA=qA\AzAffAA{AzAAAA\AAGAzAARAAAffA(AA{ARA\AffAGAGApA
AzA=qAQAffAAAA\)ApA33AAAAAA=qAGAGA(A33AAGApA\)AA33A33AffAffAA
A
=AzApAApA\ARA(AAAQAAAAGAAQAffA\ARA\A
A33A{A\AGAA=qAAAAAAQAA\AARA
=A\A=qA
=AQAApA
=AA=qA  AffA{ApAHAA33ApA(AAA=qA  A{A=qA=qA{A\)AHA
AAGA\A33A\AApAHAGA(A\A  AAAAA33ApA
=AffA=qAAARA\AAzAAQA
=AAffAApA33A\)AA\AAAQAGAAA\)AzA  AAAAHA  A\AAA\AQAAAQAzA33AQARAQAA\)ApAGAA
=AzA  AA=qA33A{AAA{AAGA
ARAApAGAHAA  AQAAffA(AAAffAHAQA  A(A=qAA
=A
AffAAA=qA{AA  A\A\)ApApAApAAA(AA{AAAHAA
AHAAA  AAAGARAA\)AffA33AQApAARA\)ARA(AAffA
A{AA{A(AA
=AGA(AAffAAAGAAHAGA\)AGA\)AffA  A=qA\)AA=qA\AAA
=AQAAAA
AA{A
AQA\A(A=qApAA{A\AA33A=qA  A
A{A33AAA
=AA  AAffA
=AA33AHAHApARAAAGAAGApA=qAAzA\)AffAHAA  AzAQAA\)A
=AAAA
=ARAzAGAAAAAA\AGA33AAQA
A
A(AzA\AAffAHA=qAHAA  A33AAAAAA=qAzAA
=AHA
=AAAAAAARA33A\)AAAAAAGAffAffARAHAHAA
AAAAAffAA\A
=A=qAAQAAA
=ARAAAAA=qAARA=qA=qA\AzA33ApA  AA  AGAAA(A\)AAQAAAARA{AAzAA
AAffAQAA=qA\AA\AApA\)AApAA  A33A33AA33ApA
=AGAAHApApAHAApA
=AAAQA{AHAzAAffA=qA(AA\AQA{A\AAGA  ApAHA
A\AA(A=qAzA  A
A33AARA\)A33AAHA  AAAffAHAA(A33AAAARAGA{ApA{AAGAARA{AQA=qA
=ARA\)AQAHAA=qAA  A=qAAzAApApAAQA  AffAA\A  ApA
=A=qA
=ARA{A\)A=qAHAA(AAAA
AAHAAAQAAA  AA{AARAGA\)A
=AHAffA(AAA{AQAHA
A{AAAARAffA{AAApARA
=AQA
=A
=A
=AAARAffAQA  AAzAHAffAAA\A\A
=AAAAAGA=qA(AHAGAAAzAA\A\ApA{AQA\)AAA  AHA
A
=A
=A\A
=A\)A=qApA=qA(AAAzAA=qA33A\AARA
=ARAAAARAQAAAApA
=AGAffA{A{A=qA=qAffAQA{A
AAGAA33A\AffAffAQAffAQA  AA\)ApA{A\A
A33ApA\)AHAAAAAQAA\AAAAAAAQAAA(AffAHA
=AA(AffA\AA
=A
=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        