CDF       
      
timeseries        obs      station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2021-03-08     
date_modified         
2021-03-08     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes WQB-04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2021-07-24T03:08:47Z http://pacioos.org
2021-07-24T03:08:47Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/WQB-04.ncCFMA?&time%3E=2018-01-01T00:00:00Z&time%3C2019-01-01T00:00:00Z     id        WQB-04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/WQB-04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         WQB-04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. WQB-04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2018-03-06T18:00:00Z   time_coverage_resolution      PT15M      time_coverage_start       2018-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.WQB-04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       q   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              q   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         q   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        q   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      A֒^   A֧      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z        r    temperature                    _ChunkSizes                
_FillValue        y    actual_range      AAH   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       R    salinity                   _ChunkSizes                
_FillValue        y    actual_range      ?
B	   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       R jp   	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      yD    ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       #Nephelometric Turbidity Units (NTU)    coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity NTU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       R @   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range                 ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       R    oxygen                     _ChunkSizes                
_FillValue        y    actual_range          A"{   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       R b   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range          B   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       R    ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       R    temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AAH   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       R [P   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range               R     temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R     temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R S   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R    temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R `   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R L0   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R     temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R    temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R D   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R p   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R @   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R =   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R    temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     R    temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     R 	5   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      ?
B	   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       R 	P   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range               R 	    salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R 
-   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R 
   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R 
Ӑ   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R &`   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R y0   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R     salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R    salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R q   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R p   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R 
@   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R 
j   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R 
   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     R    salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     R b   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      yD    ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       #Nephelometric Turbidity Units (NTU)    coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity NTU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       R P   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity NTU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range               R     turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R Z   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R    turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R     turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R S`   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R 0   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R     turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R K   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R    turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R p   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R D@   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R    turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R    chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range                 ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       R <   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range               R    chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R P   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R 5    chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R    chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R    chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R -   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R `   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R 0   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R &    chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R x   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R ˠ   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R p   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R q@   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range          A"{   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       R    oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range               R    
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R i   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R    
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R P   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R b    
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R    
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R    
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R Z   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R `   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R  0   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R S    
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R    
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R    oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range          B   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       R Kp   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range               R @   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R    oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R C   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R    oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R    oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R <P   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R     oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R    oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R 4   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R    oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R `   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R  -0   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R      ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       R     ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range               R !%   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R !xp   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     R !@   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     R "   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     R "p   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     R "ð   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     R #   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     R #iP   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     R #    	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     R $   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     R $a   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     R $   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     R %`   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045        |8 %Z0   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde      %h   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2     T )(Ap?  WQB-04  A֒^   A֒_a   A֒`B   A֒a#   A֒b   A֒b   A֒c   A֒d   A֒e   A֒fi   A֒gJ   A֒h+   A֒i   A֒i   A֒j   A֒k   A֒l   A֒mq   A֒nR   A֒o3   A֒p   A֒p   A֒q   A֒r   A֒s   A֒ty   A֒uZ   A֒v;   A֒w   A֒w   A֒x   A֒y   A֒z   A֒{   A֒|b   A֒}C   A֒~$   A֒   A֒   A֒   A֒   A֒   A֒j   A֒K   A֒,   A֒
   A֒   A֒   A֒   A֒   A֒r   A֒S   A֒4   A֒   A֒   A֒   A֒   A֒   A֒z   A֒[   A֒<   A֒   A֒   A֒   A֒   A֒   A֒   A֒c   A֒D   A֒%   A֒   A֒   A֒   A֒   A֒   A֒k   A֒L   A֒-   A֒   A֒   A֒   A֒   A֒   A֒s   A֒T   A֒5   A֒   A֒   A֒   A֒   A֒   A֒{   A֒\   A֒=   A֒   A֒   A֒   A֒   A֒   A֒   A֒d   A֒E   A֒&   A֒   A֒   A֒   A֒   A֒   A֒l   A֒M   A֒.   A֒   A֒   A֒   A֒²   A֒Ó   A֒t   A֒U   A֒6   A֒   A֒   A֒   A֒ɺ   A֒ʛ   A֒|   A֒]   A֒>   A֒   A֒    A֒   A֒   A֒ѣ   A֒҄   A֒e   A֒F   A֒'   A֒   A֒   A֒   A֒ث   Aٌ֒   A֒m   A֒N   A֒/   A֒   A֒   A֒   A֒߳   A֒   A֒u   A֒V   A֒7   A֒   A֒   A֒   A֒   A֒   A֒}   A֒^   A֒?   A֒    A֒   A֒   A֒   A֒   A֒   A֒n   A֒O   A֒0   A֒   A֒   A֒   A֒   A֒   A֒v   A֒W   A֓ 8   A֓   A֓   A֓   A֓   A֓   A֓~   A֓_   A֓@   A֓!   A֓	   A֓	   A֓
   A֓   A֓   A֓
g   A֓H   A֓)   A֓
   A֓   A֓   A֓   A֓   A֓o   A֓P   A֓1   A֓   A֓   A֓   A֓   A֓   A֓w   A֓X   A֓9   A֓   A֓   A֓   A֓    A֓!   A֓"   A֓#`   A֓$A   A֓%"   A֓&   A֓&   A֓'   A֓(   A֓)   A֓*h   A֓+I   A֓,*   A֓-   A֓-   A֓.   A֓/   A֓0   A֓1p   A֓2Q   A֓32   A֓4   A֓4   A֓5   A֓6   A֓7   A֓8x   A֓9Y   A֓::   A֓;   A֓;   A֓<   A֓=   A֓>   A֓?   A֓@a   A֓AB   A֓B#   A֓C   A֓C   A֓D   A֓E   A֓F   A֓J   A֓K   A֓L   A֓M   A֓Nq   A֓OR   A֓P3   A֓Q   A֓Q   A֓R   A֓S   A֓T   A֓Uy   A֓VZ   A֓W;   A֓X   A֓X   A֓Y   A֓Z   A֓[   A֓\   A֓]b   A֓^C   A֓_$   A֓`   A֓`   A֓a   A֓b   A֓c   A֓dj   A֓eK   A֓f,   A֓g
   A֓g   A֓h   A֓i   A֓j   A֓kr   A֓lS   A֓m4   A֓n   A֓n   A֓o   A֓p   A֓q   A֓rz   A֓s[   A֓t<   A֓u   A֓u   A֓v   A֓w   A֓x   A֓y   A֓zc   A֓{D   A֓|%   A֓}   A֓}   A֓~   A֓   A֓   A֓k   A֓L   A֓-   A֓   A֓   A֓   A֓   A֓   A֓s   A֓T   A֓5   A֓   A֓   A֓   A֓   A֓   A֓{   A֓\   A֓=   A֓   A֓   A֓   A֓   A֓   A֓   A֓d   A֓E   A֓&   A֓   A֓   A֓   A֓   A֓   A֓l   A֓   A֓   A֓   A֓t   A֓U   A֓6   A֓   A֓   A֓   A֓   A֓   A֓|   A֓]   A֓>   A֓   A֓    A֓   A֓   A֓   A֓   A֓   A֓   A֓   A֓   A֓m   A֓N   A֓/   A֓   A֓   A֓   A֓   A֓   A֓u   A֓V   A֓7   A֓   A֓Ѕ   A֓f   A֓G   A֓(   A֓	   A֓   A֓   A֓֬   A֓׍   A֓n   A֓O   A֓0   A֓   A֓   A֓   A֓ݴ   A֓   A֓~   A֓_   A֓@   A֓!   A֓   A֓   A֓   A֓   A֓   A֓g   A֓H   A֓)   A֓
   A֓   A֓   A֓   A֓o   A֓P   A֓   A֓   A֓w   A֓X   A֓9   A֓   A֓   A֔    A֔   A֔   A֔   A֔`   A֔A   A֔"   A֔   A֔   A֔   A֔	   A֔
   A֔h   A֔I   A֔
*   A֔   A֔   A֔   A֔   A֔   A֔p   A֔Q   A֔2   A֔   A֔   A֔   A֔   A֔   A֔x   A֔Y   A֔:   A֔   A֔   A֔   A֔   A֔   A֔    A֔!a   A֔"B   A֔##   A֔$   A֔$   A֔%   A֔&   A֔'   A֔(i   A֔)J   A֔*+   A֔+   A֔+   A֔,   A֔-   A֔.   A֔/q   A֔0R   A֔13   A֔2   A֔2   A֔3   A֔4   A֔5   A֔6y   A֔7Z   A֔8;   A֔9   A֔9   A֔:   A֔;   A֔<   A֔=   A֔>b   A֔?C   A֔@$   A֔A   A֔A   A֔B   A֔C   A֔D   A֔Ej   A֔FK   A֔G,   A֔H
   A֔H   A֔I   A֔J   A֔R   A֔Sz   A֔T[   A֔U<   A֔V   A֔V   A֔W   A֔X   A֔Y   A֔Z   A֔[c   A֔\D   A֔]%   A֔^   A֔^   A֔_   A֔`   A֔a   A֔bk   A֔cL   A֔d-   A֔e   A֔e   A֔f   A֔g   A֔h   A֔is   A֔jT   A֔k5   A֔l   A֔l   A֔m   A֔n   A֔o   A֔p{   A֔q\   A֔r=   A֔s   A֔s   A֔t   A֔u   A֔v   A֔w   A֔xd   A֔yE   A֔z&   A֔{   A֔{   A֔|   A֔}   A֔~   A֔l   A֔M   A֔.   A֔   A֔   A֔   A֔   A֔   A֔t   A֔U   A֔6   A֔   A֔   A֔   A֔   A֔   A֔|   A֔]   A֔>   A֔   A֔    A֔   A֔   A֔   A֔   A֔e   A֔F   A֔'   A֔   A֔   A֔   A֔   A֔   A֔m   A֔N   A֔/   A֔   A֔   A֔   A֔   A֔   A֔u   A֔V   A֔7   A֔   A֔}   A֔^   A֔?   A֔    A֔   A֔   A֔   A֔   A֔   A֔f   A֔G   A֔(   A֔	   A֔   A֔   A֔   A֔   A֔n   A֔O   A֔0   A֔   A֔   A֔   A֔   A֔   A֔v   A֔W   A֔8   A֔   A֔   A֔   A֔ż   A֔Ɲ   A֔~   A֔_   A֔@   A֔!   A֔   A֔   A֔   A֔ͥ   A֔Ά   A֔g   A֔H   A֔)   A֔
   A֔   A֔   A֔ԭ   A֔Վ   A֔o   A֔P   A֔1   A֔   A֔   A֔   A֔۵   A֔ܖ   A֔w   A֔X   A֔9   A֔   A֔   A֔   A֔   A֔   A֔   A֔`   A֔A   A֔"   A֔   A֔   A֔   A֔   A֔   A֔h   A֔I   A֔*   A֔   A֔   A֔   A֔   A֔   A֔p   A֔Q   A֔2   A֔   A֔   A֔   A֔   A֔   A֔x   A֕a   A֕B   A֕#   A֕   A֕   A֕   A֕   A֕   A֕	i   A֕
J   A֕+   A֕   A֕   A֕
   A֕   A֕   A֕   A֕   A֕   A֕   A֕y   A֕Z   A֕;   A֕   A֕b   A֕ C   A֕!$   A֕"   A֕"   A֕#   A֕$   A֕%   A֕&j   A֕'K   A֕(,   A֕,   A֕-r   A֕.S   A֕/4   A֕0   A֕0   A֕1   A֕2   A֕:   A֕;   A֕<c   A֕=D   A֕>%   A֕?   A֕?   A֕@   A֕A   A֕B   A֕Ck   A֕DL   A֕E-   A֕F   A֕F   A֕G   A֕H   A֕I   A֕Js   A֕KT   A֕L5   A֕M   A֕M   A֕N   A֕O   A֕P   A֕Q{   A֕R\   A֕ZE   A֕[&   A֕\   A֕\   A֕]   A֕^   A֕_   A֕`l   A֕aM   A֕b.   A֕c   A֕c   A֕d   A֕e   A֕f   A֕gt   A֕hU   A֕i6   A֕j   A֕j   A֕k   A֕l   A֕m   A֕n|   A֕o]   A֕p>   A֕q   A֕r    A֕r   A֕s   A֕t   A֕u   A֕ve   A֕wF   A֕x'   A֕y   A֕y   A֕z   A֕{   A֕|   A֕}m   A֕~N   A֕/   A֕   A֕   A֕   A֕   A֕   A֕u   A֕V   A֕7   A֕   A֕   A֕   A֕   A֕   A֕}   A֕^   A֕?   A֕    A֕   A֕   A֕   A֕   A֕   A֕f   A֕G   A֕(   A֕	   A֕   A֕   A֕   A֕   A֕n   A֕O   A֕0   A֕   A֕   A֕   A֕   A֕   A֕v   A֕W   A֕8   A֕   A֕   A֕   A֕   A֕   A֕~   A֕_   A֕@   A֕!   A֕   A֕   A֕   A֕)   A֕
   A֕   A֕   A֕   A֕   A֕o   A֕P   A֕1   A֕   A֕   A֕   A֕   A֕   A֕w   A֕X   A֕9   A֕   A֕   A֕   A֕ý   A֕Ğ   A֕   A֕`   A֕A   A֕"   A֕   A֕   A֕   A֕˦   A֕̇   A֕h   A֕I   A֕*   A֕   A֕   A֕   A֕Ү   A֕ӏ   A֕p   A֕Q   A֕2   A֕   A֕   A֕   A֕ٶ   A֕ڗ   A֕x   A֕i   A֕J   A֕+   A֕   A֕   A֕   A֕   A֕   A֕q   A֕R   A֕3   A֕   A֕   A֕   A֕   A֕   A֕y   A֕Z   A֕;   A֕   A֕   A֕   A֕   A֕   A֕   A֖ b   A֖C   A֖$   A֖   A֖   A֖   A֖   A֖

   A֖
   A֖   A֖   A֖
   A֖r   A֖S   A֖4   A֖   A֖   A֖   A֖   A֖   A֖z   A֖[   A֖<   A֖   A֖   A֖   A֖   A֖   A֖   A֖c   A֖D   A֖%   A֖    A֖    A֖!   A֖"   A֖#   A֖$k   A֖%L   A֖&-   A֖'   A֖'   A֖(   A֖)   A֖*   A֖+s   A֖,T   A֖-5   A֖.   A֖.   A֖/   A֖0   A֖1   A֖2{   A֖3\   A֖4=   A֖5   A֖5   A֖6   A֖7   A֖8   A֖9   A֖:d   A֖;E   A֖<&   A֖=   A֖=   A֖>   A֖?   A֖@   A֖Al   A֖BM   A֖C.   A֖D   A֖D   A֖E   A֖F   A֖G   A֖Ht   A֖IU   A֖J6   A֖K   A֖K   A֖L   A֖M   A֖N   A֖O|   A֖P]   A֖Q>   A֖R   A֖S    A֖S   A֖T   A֖U   A֖V   A֖We   A֖XF   A֖Y'   A֖Z   A֖Z   A֖[   A֖\   A֖]   A֖a   A֖b   A֖c   A֖d   A֖eu   A֖fV   A֖g7   A֖h   A֖h   A֖i   A֖j   A֖k   A֖l}   A֖m^   A֖n?   A֖o    A֖p   A֖p   A֖q   A֖r   A֖s   A֖tf   A֖uG   A֖v(   A֖w	   A֖w   A֖x   A֖y   A֖z   A֖{n   A֖|O   A֖}0   A֖~   A֖~   A֖   A֖   A֖   A֖v   A֖W   A֖8   A֖   A֖   A֖   A֖   A֖
   A֖   A֖   A֖   A֖   A֖r   A֖S   A֖4   A֖   A֖   A֖   A֖   A֖   A֖z   A֖[   A֖<   A֖   A֖   A֖   A֖   A֖   A֖   A֖c   A֖D   A֗ %   A֗   A֗   A֗   A֗   A֗   A֗k   A֗L   A֗-   A֗   A֗   A֗	   A֗
   A֗   A֗s   A֗
T   A֗   A֗   A֗{   A֗\   A֗=   A֗   A֗   A֗   A֗   A֗   A֗   A֗d   A֗E   A֗&   A֗   A֗   A֗   A֗    A֗!   A֗"l   A֗#M   A֗$.   A֗%   A֗%   A֗&   A֗'   A֗   A֗   A֗   A֗   A֗   A֗q   A֗R   A֗3   A֗   A֗   A֗   A֗   A֗   A֗   A֗b   A֗C   A֗$   A֗   A֗   A֗   A֗Ǩ   A֗ȉ   A֗j   A֗K   A֗,   A֗
   A֗   A֗   A֗ΰ   A֗ϑ   A֗r   A֗S   A֗4   A֗   A֗   A֗   A֗ո   A֗֙   A֗z   A֗[   A֗<   A֗   A֗   A֗   A֗   A֗ݡ   A֗ނ   A֗c   A֗D   A֗%   A֗   A֗   A֗   A֗   A֗   A֗k   A֗L   A֗-   A֗   A֗   A֗   A֗   A֗   A֗s   A֗T   A֗5   A֗   A֗   A֗   A֗=   A֗   A֗   A֗   A֗   A֗   A֗   A֗d   A֗E   A֗&   A֗   A֗   A֘    A֘   A֘   A֘l   A֘M   A֘.   A֘   A֘   A֘   A֘   A֘	   A֘
t   A֘U   A֘6   A֘
   A֘
   A֘   A֘   A֘   A֘|   A֘]   A֘>   A֘   A֘    A֘e   A֘F   A֘'   A֘   A֘   A֘   A֘   A֘   A֘ m   A֘!N   A֘"/   A֘#   A֘#   A֘$   A֘%   A֘&   A֘'u   A֘(V   A֘)7   A֘*   A֘*   A֘+   A֘,   A֘-   A֘.}   A֘/^   A֘0?   A֘1    A֘2   A֘2   A֘3   A֘4   A֘5   A֘6f   A֘7G   A֘8(   A֘9	   A֘9   A֘:   A֘;   A֘<   A֘=n   A֘>O   A֘?0   A֘@   A֘@   A֘A   A֘B   A֘C   A֘Dv   A֘EW   A֘F8   A֘G   A֘G   A֘H   A֘I   A֘J   A֘K~   A֘L_   A֘M@   A֘N!   A֘O   A֘O   A֘P   A֘Q   A֘R   A֘Sg   A֘TH   A֘U)   A֘V
   A֘V   A֘W   A֘X   A֘Y   A֘Zo   A֘[P   A֘\1   A֘]   A֘]   A֘^   A֘_   A֘`   A֘aw   A֘bX   A֘c9   A֘d   A֘d   A֘e   A֘f   A֘g   A֘h   A֘i`   A֘qI   A֘r*   A֘s   A֘s   A֘t   A֘u   A֘v   A֘wp   A֘xQ   A֘y2   A֘z   A֘z   A֘{   A֘|   A֘}   A֘~x   A֘Y   A֘:   A֘   A֘   A֘   A֘   A֘   A֘   A֘a   A֘B   A֘#   A֘   A֘   A֘   A֘   A֘   A֘i   A֘J   A֘+   A֘   A֘   A֘   A֘   A֘   A֘q   A֘R   A֘3   A֘   A֘   A֘   A֘   A֘   A֘y   A֘Z   A֘;   A֘   A֘   A֘   A֘   A֘   A֘   A֘b   A֘C   A֘$   A֘   A֘   A֘   A֘   A֘   A֘j   A֘K   A֘,   A֙m   A֙N   A֙/   A֙   A֙u   A֙V   A֙7   A֙   A֙   A֙   A֙   A֙   A֙}   A֙^   A֙?   A֙    A֙   A֙   A֙   A֙   A֙   A֙f   A֙G   A֙(   A֙	   A֙   A֙   A֙   A֙   A֙n   A֚ O   A֚0   A֚   A֚   A֚   A֚   A֚   A֚v   A֚W   A֚8   A֚	   A֚	   A֚
   A֚   A֚   A֚
~   A֚_   A֚@   A֚!   A֚   A֚   A֚   A֚   A֚   A֚g   A֚H   A֚)   A֚
   A֚   A֚   A֚   A֚   A֚o   A֚P   A֚1   A֚   A֚   A֚    A֚!   A֚"   A֚#w   A֚$X   A֚(   A֚)   A֚*   A֚+`   A֚,A   A֚-"   A֚.   A֚.   A֚/   A֚0   A֚1   A֚2h   A֚3I   A֚4*   A֚5   A֚5   A֚6   A֚7   A֚8   A֚9p   A֚:Q   A֚;2   A֚<   A֚<   A֚=   A֚>   A֚?   A֚@x   A֚AY   A֚B:   A֚C   A֚C   A֚D   A֚E   A֚F   A֚G   A֚Ha   A֚IB   A֚J#   A֚K   A֚K   A֚L   A֚M   A֚N   A֚Oi   A֚PJ   A֚Q+   A֚R   A֚R   A֚S   A֚T   A֚U   A֚Vq   A֚WR   A֚X3   A֚Y   A֚Y   A֚Z   A֚[   A֚\   A֚]y   A֚^Z   A֚_;   A֚`   A֚`   A֚a   A֚b   A֚c   A֚d   A֚eb   A֚fC   A֚g$   A֚h   A֚h   A֚i   A֚j   A֚k   A֚lj   A֚mK   A֚n,   A֚o
   A֚o   A֚p   A֚q   A֚r   A֚sr   A֚tS   A֚u4   A֚v   A֚v   A֚w   A֚x   A֚y   A֚zz   A֚{[   A֚|<   A֚   A֚   A֚c   A֚D   A֚%   A֚   A֚   A֚   A֚   A֚   A֚k   A֚L   A֚-   A֚   A֚   A֚   A֚   A֚   A֚s   A֚T   A֚5   A֚   A֚   A֚   A֚   A֚   A֚{   A֚\   A֚=   A֚   A֚   A֚   A֚   A֚   A֚   A֚d   A֚E   A֚&   A֚   A֚   A֚   A֚   A֚   A֚l   A֚M   A֚.   A֚   A֚   A֚   A֚   A֚   A֚t   A֚U   A֚6   A֚   A֚   A֚   A֚   A֚   A֚|   A֚]   A֚>   A֚   A֚    A֚   A֚   A֚   A֚   A֚e   A֚F   A֚'   A֚   A֚   A֚   A֚   A֚   A֚m   A֚N   A֚/   A֚   A֚   A֚   A֚ȳ   A֚ɔ   A֚u   A֚V   A֚7   A֚   A֚   A֚   A֚ϻ   A֚М   A֚}   A֚^   A֚?   A֚    A֚؅   A֚f   A֚G   A֚(   A֚	   A֚   A֚   A֚ެ   A֚ߍ   A֚n   A֚O   A֚0   A֚   A֚   A֚   A֚   A֚   A֚v   A֚W   A֚8   A֚   A֚   A֚   A֚   A֚   A֚~   A֚_   A֚@   A֚!   A֚   A֚   A֚   A֚   A֚   A֚g   A֚H   A֚)   A֚
   A֚   A֚   A֚   A֚   A֚o   A֚P   A֚1   A֛    A֛    A֛   A֛   A֛   A֛w   A֛X   A֛9   A֛   A֛   A֛   A֛	   A֛
   A֛   A֛`   A֛
A   A֛"   A֛   A֛   A֛   A֛   A֛   A֛h   A֛   A֛   A֛   A֛   A֛   A֛p   A֛Q   A֛2   A֛   A֛   A֛   A֛   A֛    A֛!x   A֛"Y   A֛#:   A֛$   A֛$   A֛%   A֛&   A֛'   A֛(   A֛)a   A֛*B   A֛+#   A֛,   A֛0i   A֛1J   A֛2+   A֛3   A֛3   A֛4   A֛5   A֛6   A֛7q   A֛8R   A֛93   A֛:   A֛:   A֛;   A֛<   A֛=   A֛>y   A֛?Z   A֛@;   A֛A   A֛A   A֛B   A֛C   A֛D   A֛E   A֛Fb   A֛GC   A֛H$   A֛I   A֛I   A֛J   A֛K   A֛L   A֛Mj   A֛NK   A֛O,   A֛P
   A֛P   A֛Q   A֛R   A֛S   A֛Tr   A֛US   A֛V4   A֛W   A֛W   A֛X   A֛Y   A֛Z   A֛[z   A֛\[   A֛]<   A֛^   A֛^   A֛_   A֛`   A֛a   A֛b   A֛cc   A֛dD   A֛e%   A֛f   A֛f   A֛g   A֛h   A֛i   A֛jk   A֛kL   A֛l-   A֛m   A֛m   A֛n   A֛o   A֛p   A֛qs   A֛rT   A֛s5   A֛t   A֛t   A֛u   A֛v   A֛w   A֛x{   A֛y\   A֛z=   A֛{   A֛{   A֛|   A֛}   A֛~   A֛   A֛d   A֛E   A֛&   A֛   A֛   A֛M   A֛.   A֛   A֛   A֛   A֛   A֛   A֛t   A֛U   A֛6   A֛   A֛   A֛   A֛   A֛   A֛|   A֛]   A֛>   A֛   A֛    A֛   A֛   A֛   A֛   A֛e   A֛F   A֛'   A֛   A֛   A֛   A֛   A֛   A֛m   A֛N   A֛/   A֛   A֛   A֛   A֛   A֛   A֛u   A֛V   A֛7   A֛   A֛   A֛   A֛   A֛   A֛}   A֛^   A֛?   A֛    A֛   A֛   A֛   A֛   A֛   A֛f   A֛G   A֛(   A֛	   A֛   A֛   A֛   A֛   A֛n   A֛O   A֛0   A֛   A֛   A֛   A֛ƴ   A֛Ǖ   A֛v   A֛W   A֛8   A֛   A֛   A֛   A֛ͼ   A֛Ν   A֛~   A֛_   A֛@   A֛!   A֛   A֛   A֛   A֛ե   A֛ֆ   A֛g   A֛H   A֛)   A֛
   A֛   A֛   A֛   A֛   A֛   A֛h   A֛I   A֛*   A֛   A֛   A֛   A֛   A֛   A֛p   A֛Q   A֛2   A֛   A֛   A֛   A֜    A֜   A֜x   A֜Y   A֜:   A֜   A֜   A֜   A֜   A֜   A֜	   A֜
a   A֜B   A֜#   A֜
   A֜
   A֜   A֜   A֜   A֜i   A֜J   A֜+   A֜   A֜   A֜   A֜   A֜   A֜q   A֜R   A֜3   A֜   A֜   A֜   A֜   A֜   A֜y   A֜ Z   A֜!;   A֜"   A֜"   A֜#   A֜$   A֜%   A֜&   A֜'b   A֜(C   A֜)$   A֜*   A֜*   A֜+   A֜,   A֜-   A֜.j   A֜/K   A֜0,   A֜1
   A֜1   A֜2   A֜3   A֜8   A֜8   A֜9   A֜:   A֜;   A֜<z   A֜=[   A֜><   A֜?   A֜?   A֜@   A֜A   A֜B   A֜C   A֜Dc   A֜ED   A֜F%   A֜G   A֜G   A֜H   A֜I   A֜J   A֜Kk   A֜LL   A֜M-   A֜N   A֜N   A֜O   A֜P   A֜Q   A֜Rs   A֜ST   A֜T5   A֜U   A֜U   A֜V   A֜W   A֜X   A֜Y{   A֜Z\   A֜[=   A֜\   A֜\   A֜]   A֜^   A֜_   A֜`   A֜ad   A֜bE   A֜c&   A֜d   A֜d   A֜e   A֜f   A֜g   A֜hl   A֜iM   A֜j.   A֜k   A֜k   A֜l   A֜m   A֜n   A֜ot   A֜pU   A֜q6   A֜r   A֜r   A֜s   A֜t   A֜u   A֜v|   A֜w]   A֜x>   A֜y   A֜z    A֜z   A֜{   A֜|   A֜}   A֜~e   A֜F   A֜'   A֜   A֜   A֜   A֜   A֜   A֜m   A֜N   A֜/   A֜   A֜   A֜   A֜   A֜   A֜}   A֜^   A֜?   A֜    A֜   A֜   A֜   A֜   A֜   A֜f   A֜G   A֜(   A֜	   A֜   A֜   A֜   A֜   A֜n   A֜O   A֜0   A֜   A֜   A֜   A֜   A֜   A֜v   A֜W   A֜8   A֜   A֜   A֜   A֜   A֜   A֜~   A֜_   A֜@   A֜!   A֜   A֜   A֜   A֜   A֜   A֜g   A֜H   A֜)   A֜
   A֜   A֜   A֜   A֜   A֜o   A֜P   A֜1   A֜   A֜   A֜   A֜ĵ   A֜Ŗ   A֜w   A֜X   A֜9   A֜   A֜   A֜   A֜˽   A̞֜   A֜   A֜`   A֜A   A֜"   A֜   A֜   A֜   A֜Ӧ   A֜ԇ   A֜h   A֜I   A֜*   A֜   A֜   A֜   A֜ڮ   A֜ۏ   A֜p   A֜Q   A֜2   A֜   A֜   A֜   A֜   A֜   A֜x   A֜   A֜   A֜   A֜   A֜a   A֜B   A֜#   A֜   A֜   A֜   A֜   A֜   A֜i   A֜J   A֜+   A֜   A֜   A֜   A֜   A֜   A֜q   A֜R   A֜3   A֜   A֜   A֜   A֜   A֜   A֝ y   A֝Z   A֝;   A֝   A֝   A֝   A֝   A֝   A֝   A֝b   A֝	C   A֝
$   A֝   A֝   A֝   A֝
   A֝   A֝j   A֝K   A֝,   A֝
   A֝   A֝   A֝   A֝   A֝r   A֝S   A֝4   A֝   A֝   A֝   A֝   A֝   A֝z   A֝[   A֝<   A֝    A֝    A֝!   A֝"   A֝#   A֝$   A֝%c   A֝&D   A֝'%   A֝(   A֝(   A֝)   A֝*   A֝+   A֝,k   A֝-L   A֝.-   A֝/   A֝/   A֝0   A֝1   A֝2   A֝3s   A֝4T   A֝55   A֝6   A֝6   A֝7   A֝8   A֝9   A֝:{   A֝;\   A֝?   A֝@   A֝A   A֝Bd   A֝CE   A֝D&   A֝E   A֝E   A֝F   A֝G   A֝H   A֝Il   A֝JM   A֝K.   A֝L   A֝L   A֝M   A֝N   A֝O   A֝Pt   A֝QU   A֝R6   A֝S   A֝S   A֝T   A֝U   A֝V   A֝W|   A֝X]   A֝Y>   A֝Z   A֝[    A֝[   A֝\   A֝]   A֝^   A֝_e   A֝`F   A֝a'   A֝b   A֝b   A֝c   A֝d   A֝e   A֝fm   A֝gN   A֝h/   A֝i   A֝i   A֝j   A֝k   A֝l   A֝mu   A֝nV   A֝o7   A֝p   A֝p   A֝q   A֝r   A֝s   A֝t}   A֝u^   A֝v?   A֝w    A֝x   A֝x   A֝y   A֝z   A֝{   A֝|f   A֝}G   A֝~(   A֝	   A֝   A֝   A֝   A֝   A֝n   A֝O   A֝0   A֝   A֝   A֝   A֝   A֝   A֝v   A֝W   A֝8   A֝   A֝   A֝   A֝   A֝   A֝~   A֝_   A֝@   A֝   A֝   A֝g   A֝H   A֝)   A֝
   A֝   A֝   A֝   A֝   A֝o   A֝P   A֝1   A֝   A֝   A֝   A֝   A֝   A֝w   A֝X   A֝9   A֝   A֝   A֝   A֝   A֝   A֝   A֝`   A֝A   A֝"   A֝   A֝   A֝   A֝   A֝   A֝h   A֝I   A֝*   A֝   A֝   A֝   A֝   A֝   A֝p   A֝Q   A֝2   A֝   A֝   A֝   A֝¶   A֝×   A֝x   A֝Y   A֝:   A֝   A֝   A֝   A֝ɾ   A֝ʟ   A֝ˀ   A֝a   A֝B   A֝#   A֝   A֝   A֝   A֝ѧ   A֝҈   A֝i   A֝J   A֝+   A֝   A֝   A֝   A֝د   Aِ֝   A֝q   A֝R   A֝3   A֝   A֝   A֝   A֝߷   A֝   A֝y   A֝Z   A֝;   A֝   A֝   A֝   A֝   A֝   A֝   A֝b   A֝C   A֝$   A֝   A֝j   A֝K   A֝,   A֝
   A֝   A֝   A֝   A֝   A֝r   A֝S   A֝4   A֝   A֝   A֝   A֝   A֝   A֝z   A֝[   A֞ <   A֞   A֞   A֞   A֞   A֞   A֞   A֞c   A֞D   A֞%   A֞	   A֞	   A֞
   A֞   A֞   A֞
k   A֞L   A֞-   A֞   A֞   A֞   A֞   A֞   A֞s   A֞T   A֞5   A֞   A֞   A֞   A֞   A֞   A֞{   A֞\   A֞=   A֞   A֞   A֞   A֞    A֞!   A֞"   A֞#d   A֞$E   A֞%&   A֞&   A֞&   A֞'   A֞(   A֞)   A֞*l   A֞+M   A֞,.   A֞-   A֞-   A֞.   A֞/   A֞0   A֞1t   A֞2U   A֞36   A֞4   A֞4   A֞5   A֞6   A֞7   A֞8|   A֞9]   A֞:>   A֞;   A֞<    A֞<   A֞=   A֞>   A֞?   A֞@e   A֞AF   A֞B'   A֞C   A֞Gm   A֞HN   A֞I/   A֞J   A֞J   A֞K   A֞L   A֞M   A֞Nu   A֞OV   A֞P7   A֞Q   A֞Q   A֞R   A֞S   A֞T   A֞U}   A֞V^   A֞W?   A֞X    A֞Y   A֞Y   A֞Z   A֞[   A֞\   A֞]f   A֞^G   A֞_(   A֞`	   A֞`   A֞a   A֞b   A֞c   A֞dn   A֞eO   A֞f0   A֞g   A֞g   A֞h   A֞i   A֞j   A֞kv   A֞lW   A֞m8   A֞n   A֞n   A֞o   A֞p   A֞q   A֞r~   A֞s_   A֞t@   A֞u!   A֞v   A֞v   A֞w   A֞x   A֞y   A֞zg   A֞{H   A֞|)   A֞}
   A֞}   A֞~   A֞   A֞   A֞o   A֞P   A֞1   A֞   A֞   A֞   A֞   A֞   A֞w   A֞X   A֞9   A֞   A֞   A֞   A֞   A֞   A֞   A֞`   A֞A   A֞"   A֞   A֞   A֞   A֞   A֞   A֞h   A֞I   A֞*   A֞   A֞   A֞Q   A֞2   A֞   A֞   A֞   A֞   A֞   A֞x   A֞Y   A֞:   A֞   A֞   A֞   A֞   A֞   A֞   A֞a   A֞B   A֞#   A֞   A֞   A֞   A֞   A֞   A֞i   A֞J   A֞+   A֞   A֞   A֞   A֞   A֞   A֞q   A֞R   A֞3   A֞   A֞   A֞   A֞   A֞   A֞y   A֞Z   A֞;   A֞   A֞   A֞   A֞ǿ   A֞Ƞ   A֞Ɂ   A֞b   A֞C   A֞$   A֞   A֞   A֞   A֞Ϩ   A֞Љ   A֞j   A֞K   A֞,   A֞
   A֞   A֞   Aְ֞   A֞ב   A֞r   A֞S   A֞4   A֞   A֞   A֞   A֞ݸ   A֞ޙ   A֞z   A֞[   A֞<   A֞   A֞   A֞   A֞   A֞   A֞   A֞c   A֞D   A֞%   A֞   A֞   A֞   A֞   A֞   A֞k   A֞L   A֞-   A֞   A֞   A֞   A֞5   A֞   A֞   A֞   A֞   A֞   A֞{   A֞\   A֞=   A֞   A֞   A֟    A֟   A֟   A֟   A֟d   A֟E   A֟&   A֟   A֟   A֟   A֟	   A֟
   A֟l   A֟M   A֟
.   A֟   A֟   A֟   A֟   A֟   A֟t   A֟U   A֟6   A֟   A֟   A֟   A֟   A֟   A֟|   A֟]   A֟>   A֟   A֟    A֟   A֟   A֟   A֟    A֟!e   A֟"F   A֟#'   A֟$   A֟$   A֟%   A֟&   A֟'   A֟(m   A֟)N   A֟*/   A֟+   A֟+   A֟,   A֟-   A֟.   A֟/u   A֟0V   A֟17   A֟2   A֟2   A֟3   A֟4   A֟5   A֟6}   A֟7^   A֟8?   A֟9    A֟:   A֟:   A֟;   A֟<   A֟=   A֟>f   A֟?G   A֟@(   A֟A	   A֟A   A֟B   A֟C   A֟D   A֟En   A֟FO   A֟G0   A֟H   A֟H   A֟I   A֟J   A֟O   A֟O   A֟P   A֟Q   A֟R   A֟S~   A֟T_   A֟U@   A֟V!   A֟W   A֟W   A֟X   A֟Y   A֟Z   A֟[g   A֟\H   A֟])   A֟^
   A֟^   A֟_   A֟`   A֟a   A֟bo   A֟cP   A֟d1   A֟e   A֟e   A֟f   A֟g   A֟h   A֟iw   A֟jX   A֟k9   A֟l   A֟l   A֟m   A֟n   A֟o   A֟p   A֟q`   A֟rA   A֟s"   A֟t   A֟t   A֟u   A֟v   A֟w   A֟xh   A֟yI   A֟z*   A֟{   A֟{   A֟|   A֟}   A֟~   A֟p   A֟Q   A֟2   A֟   A֟   A֟   A֟   A֟   A֟x   A֟Y   A֟:   A֟   A֟   A֟   A֟   A֟   A֟   A֟a   A֟B   A֟#   A֟   A֟   A֟   A֟   A֟   A֟i   A֟J   A֟+   A֟   A֟   A֟   A֟   A֟   A֟q   A֟R   A֟3   A֟   A֟   A֟   A֟   A֟   A֟   A֟   A֟   A֟   A֟   A֟b   A֟C   A֟$   A֟   A֟   A֟   A֟   A֟   A֟j   A֟K   A֟,   A֟
   A֟   A֟   A֟   A֟   A֟r   A֟S   A֟4   A֟   A֟   A֟   A֟   A֟   A֟z   A֟[   A֟<   A֟   A֟   A֟   A֟   A֟ơ   A֟ǂ   A֟c   A֟D   A֟%   A֟   A֟   A֟   A֟ͩ   A֟Ί   A֟k   A֟L   A֟-   A֟   A֟   A֟   A֟Ա   A֟Ւ   A֟s   A֟T   A֟5   A֟   A֟   A֟   A֟۹   A֟ܚ   A֟{   A֟\   A֟=   A֟   A֟   A֟   A֟   A֟   A֟   A֟d   A֟E   A֟&   A֟   A֟   A֟   A֟   A֟   A֟l   A֟M   A֟.   A֟   A֟   A֟   A֟   A֟   A֟t   A֟U   A֟6   A֟   A֟   A֟   A֟   A֟   A֟|   A֟   A֟   A֠    A֠   A֠e   A֠F   A֠'   A֠   A֠   A֠   A֠   A֠   A֠	m   A֠
N   A֠/   A֠   A֠   A֠
   A֠   A֠   A֠u   A֠V   A֠7   A֠   A֠   A֠   A֠   A֠   A֠}   A֠^   A֠?   A֠    A֠   A֠   A֠   A֠   A֠   A֠f   A֠ G   A֠!(   A֠"	   A֠"   A֠#   A֠$   A֠%   A֠&n   A֠'O   A֠(0   A֠)   A֠)   A֠*   A֠+   A֠,   A֠-v   A֠.W   A֠/8   A֠0   A֠0   A֠1   A֠2   A֠3   A֠4~   A֠5_   A֠6@   A֠7!   A֠8   A֠8   A֠9   A֠:   A֠;   A֠<g   A֠=H   A֠>)   A֠?
   A֠?   A֠@   A֠A   A֠B   A֠Co   A֠DP   A֠E1   A֠F   A֠F   A֠G   A֠H   A֠I   A֠Jw   A֠KX   A֠L9   A֠M   A֠M   A֠N   A֠O   A֠P   A֠Q   A֠R`   A֠V   A֠W   A֠X   A֠Yh   A֠ZI   A֠[*   A֠\   A֠\   A֠]   A֠^   A֠_   A֠`p   A֠aQ   A֠b2   A֠c   A֠c   A֠d   A֠e   A֠f   A֠gx   A֠hY   A֠i:   A֠j   A֠j   A֠k   A֠l   A֠m   A֠n   A֠oa   A֠pB   A֠q#   A֠r   A֠r   A֠s   A֠t   A֠u   A֠vi   A֠wJ   A֠x+   A֠y   A֠y   A֠z   A֠{   A֠|   A֠}q   A֠~R   A֠3   A֠   A֠   A֠   A֠   A֠   A֠y   A֠Z   A֠;   A֠   A֠   A֠   A֠   A֠   A֠   A֠b   A֠C   A֠$   A֠   A֠   A֠   A֠   A֠   A֠j   A֠K   A֠,   A֠
   A֠   A֠   A֠   A֠   A֠r   A֠S   A֠4   A֠   A֠   A֠   A֠   A֠   A֠z   A֠[   A֠<   A֠   A֠   A֠   A֠   A֠   A֠   A֠c   A֠D   A֠   A֠   A֠k   A֠L   A֠5   A֠   A֠   A֠   A֠   A֠   A֠{   A֠\   A֠=   A֠   A֠   A֠   A֠   A֠Ģ   A֠Ń   A֠d   A֠E   A֠&   A֠   A֠   A֠   A֠˪   A֠̋   A֠l   A֠M   A֠.   A֠   A֠   A֠   A֠Ҳ   A֠ӓ   A֠t   A֠U   A֠6   A֠   A֠   A֠   A֠ٺ   A֠ڛ   A֠|   A֠]   A֠>   A֠   A֠    A֠   A֠   A֠   A֠   A֠e   A֠F   A֠'   A֠   A֠   A֠   A֠   A֠   A֠m   A֠N   A֠/   A֠   A֠   A֠   A֠   A֠   A֠u   A֠V   A֠7   A֠   A֠   A֠   A֠   A֠   A֠}   A֠^   A֠?   A֠    A֠   A֠   A֠   A֠   A֠   A֡ f   A֡G   A֡(   A֡   A֡n   A֡O   A֡	0   A֡
   A֡
   A֡   A֡   A֡
   A֡v   A֡W   A֡8   A֡   A֡   A֡   A֡   A֡   A֡~   A֡_   A֡@   A֡!   A֡   A֡   A֡   A֡   A֡   A֡g   A֡H   A֡)   A֡ 
   A֡    A֡!   A֡"   A֡#   A֡$o   A֡%P   A֡&1   A֡'   A֡'   A֡(   A֡)   A֡*   A֡+w   A֡,X   A֡-9   A֡.   A֡.   A֡/   A֡0   A֡1   A֡2   A֡3`   A֡4A   A֡5"   A֡6   A֡6   A֡7   A֡8   A֡9   A֡:h   A֡;I   A֡<*   A֡=   A֡=   A֡>   A֡?   A֡@   A֡Ap   A֡BQ   A֡C2   A֡D   A֡D   A֡E   A֡F   A֡G   A֡Hx   A֡IY   A֡J:   A֡K   A֡K   A֡L   A֡M   A֡N   A֡O   A֡Pa   A֡QB   A֡R#   A֡S   A֡S   A֡T   A֡U   A֡V   A֡Wi   A֡XJ   A֡Y+   A֡Z   A֡^q   A֡_R   A֡`3   A֡a   A֡a   A֡b   A֡c   A֡d   A֡ey   A֡fZ   A֡g;   A֡h   A֡h   A֡i   A֡j   A֡k   A֡l   A֡mb   A֡nC   A֡o$   A֡p   A֡p   A֡q   A֡r   A֡s   A֡tj   A֡uK   A֡v,   A֡w
   A֡w   A֡x   A֡y   A֡z   A֡{r   A֡|S   A֡}4   A֡~   A֡~   A֡   A֡   A֡   A֡z   A֡[   A֡<   A֡   A֡   A֡   A֡   A֡   A֡   A֡c   A֡D   A֡%   A֡   A֡   A֡   A֡   A֡   A֡k   A֡L   A֡-   A֡   A֡   A֡   A֡   A֡   A֡s   A֡T   A֡5   A֡   A֡   A֡   A֡   A֡   A֡{   A֡\   A֡=   A֡   A֡   A֡   A֡   A֡   A֡   A֡d   A֡E   A֡&   A֡   A֡   A֡   A֡   A֡   A֡l   A֡M   A֡.   A֡   A֡   A֡U   A֡6   A֡   A֡   A֡   A֡   A֡   A֡|   A֡]   A֡>   A֡   A֡    A֡   A֡   A֡£   A֡Ä   A֡e   A֡F   A֡'   A֡   A֡   A֡   A֡ɫ   A֡ʌ   A֡m   A֡N   A֡/   A֡   A֡   A֡   A֡г   A֡є   A֡u   A֡V   A֡7   A֡   A֡   A֡   A֡׻   A֡؜   A֡}   A֡^   A֡?   A֡    A֡   A֡   A֡   A֡ߤ   A֡   A֡f   A֡G   A֡(   A֡	   A֡   A֡   A֡   A֡   A֡n   A֡O   A֡0   A֡   A֡   A֡   A֡   A֡   A֡v   A֡W   A֡8   A֡   A֡   A֡   A֡   A֡   A֡~   A֡_   A֡@   A֡!   A֡   A֡   A֡   A֡   A֡   A֡g   A֡H   A֢ )   A֢
   A֢   A֢   A֢   A֢   A֢o   A֢P   A֢1   A֢   A֢   A֢	   A֢9   A֢   A֢   A֢   A֢   A֢   A֢   A֢`   A֢A   A֢"   A֢   A֢   A֢   A֢   A֢   A֢h   A֢I   A֢*   A֢   A֢   A֢   A֢    A֢!   A֢"p   A֢#Q   A֢$2   A֢%   A֢%   A֢&   A֢'   A֢(   A֢)x   A֢*Y   A֢+:   A֢,   A֢,   A֢-   A֢.   A֢/   A֢0   A֢1a   A֢2B   A֢3#   A֢4   A֢4   A֢5   A֢6   A֢7   A֢8i   A֢9J   A֢:+   A֢;   A֢;   A֢<   A֢=   A֢>   A֢?q   A֢@R   A֢A3   A֢B   A֢Fy   A֢GZ   A֢H;   A֢I   A֢I   A֢J   A֢K   A֢L   A֢M   A֢Nb   A֢OC   A֢P$   A֢Q   A֢Q   A֢R   A֢S   A֢T   A֢Uj   A֢VK   A֢W,   A֢X
   A֢X   A֢Y   A֢Z   A֢[   A֢\r   A֢]S   A֢^4   A֢_   A֢_   A֢`   A֢a   A֢b   A֢cz   A֢d[   A֢e<   A֢f   A֢f   A֢g   A֢h   A֢i   A֢j   A֢kc   A֢lD   A֢m%   A֢n   A֢n   A֢o   A֢p   A֢q   A֢rk   A֢sL   A֢t-   A֢u   A֢u   A֢v   A֢w   A֢x   A֢ys   A֢zT   A֢{5   A֢|   A֢|   A֢}   A֢~   A֢   A֢{   A֢\   A֢=   A֢   A֢   A֢   A֢   A֢   A֢   A֢d   A֢E   A֢&   A֢   A֢   A֢   A֢   A֢   A֢l   A֢M   A֢.   A֢   A֢   A֢   A֢   A֢   A֢t   A֢U   A֢6   A֢   A֢   A֢   A֢   A֢   A֢|   A֢]   A֢>   A֢   A֢    A֢   A֢   A֢   A֢   A֢e   A֢F   A֢'   A֢   A֢   A֢   A֢   A֢   A֢m   A֢N   A֢/   A֢   A֢   A֢   A֢   A֢   A֢u   A֢V   A֢7   A֢   A֢   A֢   A֢   A֢   A֢   A֢   A֢   A֢   A֢   A֢f   A֢G   A֢(   A֢	   A֢   A֢   A֢Ǭ   A֢ȍ   A֢n   A֢O   A֢0   A֢   A֢   A֢   A֢δ   A֢ϕ   A֢v   A֢W   A֢8   A֢   A֢   A֢   A֢ռ   A֢֝   A֢~   A֢_   A֢@   A֢!   A֢   A֢   A֢   A֢ݥ   A֢ކ   A֢g   A֢H   A֢)   A֢
   A֢   A֢   A֢   A֢   A֢o   A֢P   A֢1   A֢   A֢   A֢   A֢   A֢   A֢w   A֢X   A֢9   A֢   A֢   A֢   A֢   A֢   A֢   A֢`   A֢A   A֢"   A֢   A֢   A֢   A֢   A֢   A֢h   A֢I   A֢*   A֢   A֢   A֣    A֣   A֣   A֣p   A֣Q   A֣2   A֣   A֣   A֣   A֣   A֣	   A֣
x   A֣Y   A֣:   A֣
   A֣
   A֣   A֣   A֣   A֣   A֣a   A֣B   A֣#   A֣   A֣   A֣   A֣   A֣   A֣i   A֣J   A֣+   A֣   A֣   A֣   A֣   A֣   A֣ q   A֣!R   A֣"3   A֣#   A֣#   A֣$   A֣%   A֣&   A֣'y   A֣(Z   A֣);   A֣*   A֣*   A֣+   A֣,   A֣-   A֣.   A֣/b   A֣0C   A֣1$   A֣2   A֣2   A֣3   A֣4   A֣5   A֣6j   A֣7K   A֣8,   A֣9
   A֣9   A֣:   A֣;   A֣<   A֣=r   A֣>S   A֣?4   A֣@   A֣@   A֣A   A֣B   A֣C   A֣Dz   A֣E[   A֣F<   A֣G   A֣G   A֣H   A֣I   A֣J   A֣K   A֣Lc   A֣MD   A֣N%   A֣O   A֣O   A֣P   A֣Q   A֣R   A֣Sk   A֣TL   A֣U-   A֣V   A֣V   A֣W   A֣X   A֣Y   A֣Zs   A֣[T   A֣\5   A֣]   A֣]   A֣^   A֣_   A֣`   A֣a{   A֣b\   A֣c=   A֣d   A֣d   A֣e   A֣f   A֣g   A֣h   A֣id   A֣jE   A֣k&   A֣l   A֣l   A֣m   A֣n   A֣o   A֣pl   A֣qM   A֣r.   A֣s   A֣s   A֣t   A֣u   A֣v   A֣wt   A֣xU   A֣y6   A֣z   A֣z   A֣{   A֣|   A֣}   A֣~|   A֣]   A֣>   A֣   A֣    A֣   A֣   A֣   A֣   A֣e   A֣F   A֣'   A֣   A֣   A֣   A֣   A֣   A֣m   A֣N   A֣/   A֣   A֣   A֣   A֣   A֣   A֣u   A֣V   A֣7   A֣   A֣   A֣   A֣   A֣   A֣}   A֣^   A֣?   A֣    A֣   A֣   A֣   A֣   A֣   A֣f   A֣G   A֣(   A֣	   A֣   A֣   A֣   A֣   A֣n   A֣O   A֣0   A֣   A֣   A֣   A֣   A֣   A֣v   A֣W   A֣8   A֣   A֣   A֣   A֣   A֣   A֣~   A֣_   A֣@   A֣!   A֣   A֣   A֣   A֣   A֣   A֣g   A֣H   A֣)   A֣
   A֣   A֣   A֣ŭ   A֣Ǝ   A֣o   A֣P   A֣1   A֣   A֣   A֣   A̵֣   A֣͖   A֣w   A֣X   A֣9   A֣   A֣   A֣   A֣ӽ   A֣Ԟ   A֣   A֣`   A֣A   A֣"   A֣   A֣   A֣   A֣ۦ   A֣܇   A֣h   A֣I   A֣*   A֣   A֣   A֣   A֣   A֣   A֣p   A֣Q   A֣2   A֣   A֣   A֣   A֣   A֣   A֣x   A֣Y   A֣:   A֣   A֣   A֣   A֣   A֣   A֣   A֣a   A֣B   A֣#   A֣   A֣   A֣   A֣   A֣   A֣i   A֣J   A֣+   A֣   A֣   A֣   A֣   A֤    A֤q   A֤R   A֤3   A֤   A֤   A֤   A֤   A֤   A֤y   A֤	Z   A֤
;   A֤   A֤   A֤   A֤
   A֤   A֤   A֤b   A֤C   A֤$   A֤   A֤   A֤   A֤   A֤   A֤j   A֤K   A֤,   A֤
   A֤   A֤   A֤   A֤   A֤r   A֤S   A֤ 4   A֤!   A֤!   A֤"   A֤#   A֤$   A֤%z   A֤&[   A֤'<   A֤(   A֤(   A֤)   A֤*   A֤+   A֤,   A֤-c   A֤.D   A֤/%   A֤0   A֤0   A֤1   A֤2   A֤3   A֤4k   A֤5L   A֤6-   A֤7   A֤7   A֤8   A֤9   A֤:   A֤;s   A֤<T   A֤=5   A֤>   A֤>   A֤?   A֤@   A֤A   A֤B{   A֤C\   A֤D=   A֤E   A֤E   A֤F   A֤G   A֤H   A֤I   A֤Jd   A֤KE   A֤L&   A֤M   A֤M   A֤N   A֤O   A֤P   A֤Ql   A֤RM   A֤S.   A֤T   A֤T   A֤U   A֤V   A֤W   A֤Xt   A֤YU   A֤Z6   A֤[   A֤[   A֤\   A֤]   A֤^   A֤_|   A֤`]   A֤a>   A֤b   A֤c    A֤c   A֤d   A֤e   A֤f   A֤ge   A֤hF   A֤i'   A֤j   A֤j   A֤k   A֤l   A֤m   A֤nm   A֤oN   A֤p/   A֤q   A֤q   A֤r   A֤s   A֤t   A֤uu   A֤vV   A֤w7   A֤x   A֤x   A֤y   A֤z   A֤{   A֤|}   A֤}^   A֤~?   A֤    A֤   A֤   A֤   A֤   A֤   A֤f   A֤G   A֤(   A֤	   A֤   A֤   A֤   A֤   A֤n   A֤O   A֤0   A֤   A֤   A֤   A֤   A֤   A֤v   A֤W   A֤8   A֤   A֤   A֤   A֤   A֤   A֤~   A֤_   A֤@   A֤!   A֤   A֤   A֤   A֤   A֤   A֤g   A֤H   A֤)   A֤
   A֤   A֤   A֤   A֤   A֤o   A֤P   A֤1   A֤   A֤   A֤   A֤   A֤   A֤w   A֤X   A֤9   A֤   A֤   A֤   A֤   A֤   A֤   A֤`   A֤A   A֤"   A֤   A֤   A֤   A֤   A֤   A֤h   A֤I   A֤*   A֤   A֤   A֤   A֤î   A֤ď   A֤p   A֤Q   A֤2   A֤   A֤   A֤   A֤ʶ   A֤˗   A֤x   A֤Y   A֤:   A֤   A֤   A֤   A֤Ѿ   A֤ҟ   A֤Ӏ   A֤a   A֤B   A֤#   A֤   A֤   A֤   A֤٧   A֤ڈ   A֤i   A֤J   A֤+   A֤   A֤   A֤   A֤   A֤   A֤q   A֤R   A֤3   A֤   A֤   A֤   A֤   A֤   A֤y   A֤Z   A֤;   A֤   A֤   A֤   A֤   A֤   A֤   A֤b   A֤C   A֤$   A֤   A֤   A֤   A֤   A֤   A֤j   A֤K   A֤,   A֤
   A֤   A֤   A֤   A֤   A֤r   A֥ S   A֥4   A֥   A֥   A֥   A֥   A֥   A֥z   A֥[   A֥<   A֥	   A֥	   A֥
   A֥   A֥   A֥
   A֥c   A֥D   A֥%   A֥   A֥   A֥   A֥   A֥   A֥k   A֥L   A֥-   A֥   A֥   A֥   A֥   A֥   A֥s   A֥T   A֥5   A֥   A֥   A֥    A֥!   A֥"   A֥#{   A֥$\   A֥%=   A֥&   A֥&   A֥'   A֥(   A֥)   A֥*   A֥+d   A֥,E   A֥-&   A֥.   A֥.   A֥/   A֥0   A֥1   A֥2l   A֥3M   A֥4.   A֥5   A֥5   A֥6   A֥7   A֥8   A֥9t   A֥:U   A֥;6   A֥<   A֥<   A֥=   A֥>   A֥?   A֥@|   A֥A]   A֥B>   A֥C   A֥D    A֥D   A֥E   A֥F   A֥G   A֥He   A֥IF   A֥J'   A֥K   A֥K   A֥L   A֥M   A֥N   A֥Om   A֥PN   A֥Q/   A֥R   A֥R   A֥S   A֥T   A֥U   A֥Vu   A֥WV   A֥X7   A֥Y   A֥Y   A֥Z   A֥[   A֥\   A֥]}   A֥^^   A֥_?   A֥`    A֥a   A֥a   A֥b   A֥c   A֥d   A֥ef   A֥fG   A֥g(   A֥h	   A֥h   A֥i   A֥j   A֥k   A֥ln   A֥mO   A֥n0   A֥o   A֥o   A֥p   A֥q   A֥r   A֥sv   A֥tW   A֥u8   A֥v   A֥v   A֥w   A֥x   A֥y   A֥z~   A֥{_   A֥|@   A֥}!   A֥~   A֥~   A֥   A֥   A֥   A֥g   A֥H   A֥)   A֥
   A֥   A֥   A֥   A֥   A֥o   A֥P   A֥1   A֥   A֥   A֥   A֥   A֥   A֥w   A֥X   A֥9   A֥   A֥   A֥   A֥   A֥   A֥   A֥`   A֥A   A֥"   A֥   A֥   A֥   A֥   A֥   A֥h   A֥I   A֥*   A֥   A֥   A֥   A֥   A֥   A֥p   A֥Q   A֥2   A֥   A֥   A֥   A֥   A֥   A֥x   A֥Y   A֥:   A֥   A֥   A֥   A֥   A֥   A֥   A֥a   A֥B   A֥#   A֥   A֥   A֥   A֥   A֥   A֥i   A֥J   A֥+   A֥   A֥   A֥   A֥   A֥   A֥q   A֥R   A֥3   A֥   A֥   A֥   A֥ȷ   A֥ɘ   A֥y   A֥Z   A֥;   A֥   A֥   A֥   A֥Ͽ   A֥Р   A֥с   A֥b   A֥C   A֥$   A֥   A֥   A֥   A֥ר   A֥؉   A֥j   A֥K   A֥,   A֥
   A֥   A֥   A֥ް   A֥ߑ   A֥r   A֥S   A֥4   A֥   A֥   A֥   A֥   A֥   A֥z   A֥[   A֥<   A֥   A֥   A֥   A֥   A֥   A֥   A֥c   A֥D   A֥%   A֥   A֥   A֥   A֥   A֥   A֥k   A֥L   A֥-   A֥   A֥   A֥   A֥   A֥   A֥s   A֥T   A֥5   A֦    A֦    A֦   A֦   A֦   A֦{   A֦\   A֦=   A֦   A֦   A֦   A֦	   A֦
   A֦   A֦d   A֦
E   A֦&   A֦   A֦   A֦   A֦   A֦   A֦l   A֦M   A֦.   A֦   A֦   A֦   A֦   A֦   A֦t   A֦U   A֦6   A֦   A֦   A֦   A֦   A֦    A֦!|   A֦"]   A֦#>   A֦$   A֦%    A֦%   A֦&   A֦'   A֦(   A֦)e   A֦*F   A֦+'   A֦,   A֦,   A֦-   A֦.   A֦/   A֦0m   A֦1N   A֦2/   A֦3   A֦3   A֦4   A֦5   A֦6   A֦7u   A֦8V   A֦97   A֦:   A֦:   A֦;   A֦<   A֦=   A֦>}   A֦?^   A֦@?   A֦A    A֦B   A֦B   A֦C   A֦D   A֦E   A֦Ff   A֦GG   A֦H(   A֦I	   A֦I   A֦J   A֦K   A֦L   A֦Mn   A֦NO   A֦O0   A֦P   A֦P   A֦Q   A֦R   A֦S   A֦Tv   A֦UW   A֦V8   A֦W   A֦W   A֦X   A֦Y   A֦Z   A֦[~   A֦\_   A֦]@   A֦^!   A֦_   A֦_   A֦`   A֦a   A֦b   A֦cg   A֦dH   A֦e)   A֦f
   A֦f   A֦g   A֦h   A֦i   A֦jo   A֦kP   A֦l1   A֦m   A֦m   A֦n   A֦o   A֦p   A֦qw   A֦rX   A֦s9   A֦t   A֦t   A֦u   A֦v   A֦w   A֦x   A֦y`   A֦zA   A֦{"   A֦|   A֦|   A֦}   A֦~   A֦   A֦h   A֦I   A֦*   A֦   A֦   A֦   A֦   A֦   A֦p   A֦Q   A֦2   A֦   A֦   A֦   A֦   A֦   A֦x   A֦Y   A֦:   A֦   A֦   A֦   A֦   A֦   A֦   A֦a   A֦B   A֦#   A֦   A֦   A֦   A֦   A֦   A֦i   A֦J   A֦+   A֦   A֦   A֦   A֦   A֦   A֦q   A֦R   A֦3   A֦   A֦   A֦   A֦   A֦   A֦y   A֦Z   A֦;   A֦   A֦   A֦   A֦   A֦   A֦   A֦b   A֦C   A֦$   A֦   A֦   A֦   A֦   A֦   A֦j   A֦K   A֦,   A֦
   A֦   A֦   A֦   A֦   A֦r   A֦S   A֦4   A֦   A֦   A֦   A֦Ƹ   A֦Ǚ   A֦z   A֦[   A֦<   A֦   A֦   A֦   A֦   A֦Ρ   A֦ς   A֦c   A֦D   A֦%   A֦   A֦   A֦   A֦թ   A֦֊   A֦k   A֦L   A֦-   A֦   A֦   A֦   A֦ܱ   A֦ݒ   A֦s   A֦T   A֦5   A֦   A֦   A֦   A֦   A֦   A֦{   A֦\   A֦=   A֦   A֦   A֦   A֦   A֦   A֦   A֦d   A֦E   A֦&   A֦   A֦   A֦   A֦   A֦   A֦l   A֦M   A֦.   A֦   A֦   A֦   A֦   A֦   A֦t   A֦U   A֦6   A֦   A֦   A֦   A֧    A֧   A֧|   A֧]   A֧>   A֧   A֧    A֧   A֧   A֧   A֧	   A֧
e   A֧F   A֧'   A֧
   A֧
   A֧   A֧   A֧   A֧m   A֧N   A֧/   A֧   A֧   A֧   A֧   A֧   A֧u   A֧V   A֧7   A֧   A֧   A֧   A֧   A֧   A֧}   A֧ ^   A֧!?   A֧"    A֧#   A֧#   A֧$   A֧%   A֧&   A֧'f   A֧(G   A֧)(   A֧*	   A֧*   A֧+   A֧,   A֧-   A֧.n   A֧/O   A֧00   A֧1   A֧1   A֧2   A֧3   A֧4   A֧5v   A֧6W   A֧78   A֧8   A֧8   A֧9   A֧:   A֧;   A֧<~   A֧=_   A֧>@   A֧?!   A֧@   A֧@   A֧A   A֧B   A֧C   A֧Dg   A֧EH   A֧F)   A֧G
   A֧G   A֧H   A֧I   A֧J   A֧Ko   A֧LP   A֧M1   A֧N   A֧N   A֧O   A֧P   A֧Q   A֧Rw   A֧SX   A֧T9   A֧U   A֧U   A֧V   A֧W   A֧X   A֧Y   A֧Z`   A֧[A   A֧\"   A֧]   A֧]   A֧^   A֧_   A֧`   A֧ah   A֧bI   A֧c*   A֧d   A֧d   A֧iQ   A֧j2   A֧k   A֧k   A֧l   A֧m   A֧n   A֧ox   A֧pY   A֧q:   A֧r   A֧r   A֧s   A֧t   A֧u   A֧v   A֧wa   A֧xB   A֧y#   A֧z   A֧z   A֧{   A֧|   A֧}   A֧~i   A֧J   A֧+   A֧   A֧   A֧   A֧   A֧   A֧q   A֧R   A֧3   A֧   A֧y   A֧Z   A֧;   A֧   A֧   A֧   A֧   A֧   A֧   A֧b   A֧C   A֧$   A֧   A֧   A֧   A֧   A֧   A֧j   A֧K   A֧,   A֧
   A֧   A֧   A֧   A֧   A֧r   A֧S   A֧4   A֧   A֧   A֧   A֧   A֧   A֧z   A֧[   A֧<   A֧   A֧   A֧   A֧   A֧   A֧   A֧c   A֧D   A֧%   A֧   A֧   A֧   A33AŅAǅAA=qA
=AĸRApAA{AA
A=qAəA33ApAA33AîAÙAGAGAzAApAȏ\AffAA  ẠAAHA̸RẠAffAffA  A\)A33A33AƸRAĸRA=qAHAAA
=ApAQA\AA  A£AAAA33A(AǙAHAAAAHAȸRAzA33AAAffAGARA{A\)AApAffA{A(AÙA
A33AA{AA
=AGAÙAAHA£A  ApARAA£A\AApAHA33AzAffApAA
=A{AA
=A\AAHAAHARA{AAA  A  A33AAîAHAA=qAzAHAîAAÙAŮAffAAAƏ\AA\)ApAƸRAAHAQAzA(A  A\)A
A£ApAîAAA{A
AƏ\AA  A{AǮApAffApAAHAA\AGA\)ApAHA=qApAffA
AHAAQAQA\AGARAAGAAQAHA\)AGA
A=qAzAAGA\)AAA=qA=qA(A{A=qA  A  A(ApAAAA33A{A\)ARAA
=AîA  A¸RA(A{ARAAAQA(AQA{AQA(AģA£AA  A=qAA=qA=qAffAA
ARARAffA  ARAA33AA=qA\A{AQApAzARA
=AAQA33AHA  AA\)A33AQA
=AA\A\AQA\AGAA\A
=A
=AA
A(AAAAffAHAA\A=qA{A(AQAzAA\)ARAffAffA{AA(A\)A  AAApA
AAffAA  AA\)AAHAA=qAffA  AzA  A(AA
=AAAAAAA(AA
=A33AA33A33AAQARAARAHA\)AzAA{AHAA£AAGAQA
=AAAGApAApApAGAAAHA\)ApAAAAAHAzAApAffAzA=qAzAAAzAAA(A(A33A
=ApAffAA\)AģAď\A\)AAGAQAÅA(A=qA(A\A\)AHApA
A  A(A
=A\AA33AffAAAzAA  ARA=qARAzARAA
=AQAAQA{AA  AAGAARAA\)AAAzA33AffAÙAÅA{AAAzAzAAAAGA
=AƣA=qA(AƣA=qAffAřAAŮAAAřA
=A
AA=qA
AƣAAAƸRAffA  AĸRA\)AA\)A{AzA33AÙA
AA¸RAAAffAHAffAA\AAAAAzA\)AAQAA{AHAGA
=AAAAAAffAHAA=qAŮA
A
=AHA{AA\AA\AGA
A33ApAAAGAGAA
=AGApA
A(AffAģA£A
=AAzAAAǙAAǮA\)A{AA=qAƣAA
=A
A  AHAA=qA\)A33A\)AGAAAA\)AAA{A
A  AzAzA\AGAzAzAQA
=A\AAGA£A33AA33A(AA{AffAA\)AHAAQA  AApAQA¸RAzA\A\ApAffAAQA=qAA\A
ApA33AÅA\)AÙAAÙA
AģAGAHAA{AAřApAGAŮAŮAřAA  AA  A
A33AA
AŅA\)AŅAŅAA
AGAGAřAŮA\)AffAAĸRAGAzAA(AA¸RAGAGA(A
AAAHAAřAAA
AÅAGA  AHAŅAAzA
=AQAzAHA=qAzA{ApAĸRA
=AffA
=AffA
=ApA
=AzAHA=qAAAHA¸RAffAzA\A\A¸RAAA
=A
=AÅAÅAA
AAĸRA
=AA
=AApAffAǙAAƸRAGA33A  ApAffA¸RA
=AAģAA\)A(A{A(AffAAAQAzAzAAîAzAzA33AQAģAHAÅAAŮA=qAAŅApAAApA=qA\)AAffAGAzA=qAffA
=AHA
=AffAď\AģA
=AģA=qA=qA{AA=qAAAAA
=AAQA  A
=AAzA
=A\A¸RApAÅAAģAHA=qAŮA(AffAAzA33AzAQAffAffAģAŅAď\AŮAQA
=AHAîAģAAQAAAAGAA(A\)A(ARA
AffApA{A
=A=qApA
A¸RAA\)A=qAÅAQA
=AAGApA(AAAHAAffAzA
=AAAA\)AA\A\AAAQAÅA
=AAAHAffAď\A{A(AîA(A\)AAAzApAAA=qA(A33A33AÙA33AHAzAAAřA
AQAÅA33AApAzAAîA=qAHAHA33AÅAîA
AÅA¸RA33AA33AAAffA\AAzAffA(A33AQAApAGA(A\)AAAA(AAAA{A  AAAHAzA\A33A\A  AA¸RA\)A¸RAAA{A=qAď\AA=qA
=A=qAAď\AQAffA  AÅAřAffAHAřA{ApAGAA
=A
A\)Aď\AAHA=qAA\)A  AApA
AzAA  A
=AApA\)A
=AA(AQA\A\)A
=AAîAffA{A  AHAQA
A
=AAģAHAĸRA33AřAQAƸRAGAǅAAzAHAGA33AAȣA  AǅA
A
A  AǮA
AAAAAA
=A{AģAHAA  A=qAAHA
AAQAHAƏ\A{AƏ\AGAA
=AA
=AƸRAHAď\AŅAģAA(A33AGAÅA{AÙA33A
=A
=AzA33A\)A\A{A¸RAA£AA¸RA
=AGApAîAA  AĸRAA  A
AGAĸRAAŮA
A(AQApAA
A
AŮAA
=AGA
=AAAQAĸRA
A=qAAAÅA33AQA  AAAAAffA33AAA{AAAGA(A\A\)AQAA\A£A¸RAA{A(A
AffAƏ\AQAzAHAƸRAffA(AzA(A
AffAAAzAQA=qA  A{A{A  A(AŮAĸRAď\A\)AAď\AÙA=qAÅAQAŮAîApA
=A\AAQAAffA  AffARAA(A33ApAA=qAffA\)AA  A  A(A
=A
A
=ApAAAQAGA{AHAAzAAQAAffAA\AffA\A=qAAAAA
AAA  A{AQAQA  A{AA\)AApA\AAA
=A=qAAAA\AzAAApApAffAA  AA
AAAGApAA{A=qAAffAAAGAAGApApAAAGAA=qA{ApA
A  A33A33A
A=qA(A\)AHAAHA\)AAGA
=AAAAApAAAA33A33AGAA=qA(AA=qAAAAAGA\)A¸RAAAA33A33A\AGA33A  AAGAHAď\AĸRAGAHA(A33AÙA£AÙApAGAARA
AAÙAAÅAQA¸RAQA
=A£AA
AAģAGAîAHA=qAHAzA=qAÙAA\)AAA33AGA33A\AAAAA=qA{A  A=qA¸RAffAAzAAAÅAģAAGAAŮA33AA
=AAA\A33A=qAzA=qAffA
=AAǮApAǅAGAAzA=qAAQA  AA  AAAzA  AApAAffA
AA{AA\)A  ARAAHAAARAAGAAA
=AAHA\)A{A
AHAARAA\)AA33A  A
=AApA  AQARAAffAAHAA\AzARAA\A{A=qAAGAHA\)ARAQAQAffAAAQA(AA
AAA=qAHARARAHA\)AAAApAzAffAAA(AApA{AAARA(A=qAAQAARAQAAAA
A33A33AAAzAGA\A\)ARAA
=A\A(AAGAQAAAAA33A{A  AAzAA(AGAzA=qAAzA(AAA  ARA{AffA\AAApAA{AQA
=ARA{AffA=qAA=qAA\AAARAAAffAffARA  A
=A\AA
AGAA\A
AffA  AGA  A{ARAApA\)A
A=qA(AA(A
=AA  A33A
AQA{AAzAGAQAzA
A
=A(AApAA\AAAA33A\)AAzAAffA=qAA
=A(AzA
=AAA
=A
=A{A(AARAffA\A{ApAA
ApAffAA=qAAffA33A  AAGA\)AA{AA
=A{AAAzA{AAARAA  AA33AAA(A=qA\)AA(AAAAHAAA
A
A
=A
=A
=A33AGAAAA  AAAA  A(AAApAAQAHAA  AGA(A
=A
=ApAAAAA\)A
=AAAAffA  A\A(A
AAAHA(AA(ARApA=qA{AAAA(AAApA
=A
AAGAA\A=qA\AffAARA\AQA
=A{AffAA\AAAQAAA33AffAzA\)AA
=AAA=qAA{AAA{AAGA{A\)AAGAAGAA=qAAzA33AARAA
=AAGAHAGAQA
=AGA(AApAzAARARA
A\)A
AAffAzA\)AzAzA\ApAHAARAzAGAAA
=AAHAAAA
AA{AAA  AApA33ARAQAA33ApA\)AAAA  A
=ApAA
=A(AHA  A{AffA(AA33AA(AAAffA33AA\A\AA(A(A\)AAA
=AGA
=AffAQAzAHAAzAAffAAAGA
=ARA{AGA=qA(AHApAzA{AHA
=A\AAA\)AAffA
AQApApA
=AGA33A
=AAAARAAGAffAHAAApA\)AGA
A
=ARA(AAHA  AA33AzAAHAARA\)A
A=qAARAAzAAA(A  AAARAAA
=A(AAAAffAffAAAAA33A(A33AAAGAA
=AApAAffAHAGA=qAzAAAHA\AAzAA\)AzA
=AAAAzA{AffA  AApAAffAAA{AAA=qA=qA
A\)A  AAA{A{A
=AGAAzA{AffA\)A=qA¸RA
=AGA33ApAÅA\)A¸RAA33A\)AA=qA33AAzAģApAzAAA
AA33A33AAAĸRA
=A  A=qA  A{AGA\)A
=AA
=ARAAffA=qAA  AAAAA=qAffA\)A\ARA{AGAAAHA33AzA
=A
AAzA  AApAHAHA  AA=qAA\A\AARAzAzAAHARAAApA\AÙA(AffA\)AzAĸRAĸRAĸRAffA(AQA(AÅAHAA¸RA£A
=AQAffA\ApApA(AAA(A
=AA(A\)AAAGA(A¸RAffAAzA
=AffAApAAApAAAApAHApAA
=AffA\)AzAAffA¸RA\)AAffAApAA(AAAzAGA(AAGAA
AAAzA=qA33A\)AA{AHAA
AAAAHAGAǅA\)AǅA\)A\)ApAǮAǙA
ApAƏ\AzAzAzAƣAzA33A\)AGAA
=A\AApAAAAAA=qA=qA\)AAAAAAAA=qAAQAQAGAřAAA\)AĸRAGAHAAÅAApA  A(AÙA33AA  A£A\)A¸RApA\)AzA  AffAGAffAAHAÙA=qAAzAAA\)ARA  AffAA(A
=ApA  AffAApA
A(AffAzAGAGAA
=A33A33AAffA{AřA=qA(A{A(AƸRAAAGAHAǙAzAQA
A¸RAffAAA
=A
=AHA
=ApA33AA=qAîAAA33AAQAAAzAAÙA
A(AîA=qAÙAÙAAAA=qAA(AAHA£AQA£ApA
A\)AAzAAffAA=qA  AAzA{AffApAQAAAAAffA
=A
=ApA33ApA  A£AAď\A33AA  AƏ\AffAzAƏ\AA33AzAQA(A  A33AAřA(A
AA
=A33AAď\AģAď\AffAģAAģAď\AÅA33A\AApAffA=qA£AA\)AÅAzA{AAAQA
=AHA=qA
A{A(A
AÅAÙA
=AAAA£A(A{A{ApA\)AAzAAA=qAAAA=qARA
=A{AzA
AGApAAzAzAHApAAAHAÅA
AQAffAģAĸRAAAď\Aď\A
A£A  AAApApAGAAffAffA{AA(AHAAGApA£AA33AHAzAzAffA=qA{AAGApAGA{A\AA\)AA=qAA\AffA{A(A=qAA=qA£AffAAHAzAzA\A£AA£AA£A¸RAAzA  AQAAAQAGAAHAA33AHAzAA{AffA\)A33A33ApAA\AGA(A¸RAÙAîAÅAÅA  A\)A  AAQA  AAA
=AĸRA{AGAGAÅA\)AzAzA\AzAÙA{AffAîA(A
AÙAQA{A
A=qA  AQAffA  A
=AAGARA
=ApAffA\)A{AAGA
A(A\AAApAGAAA=qAA  A  A(AA(A=qAA(AGAQA\A33AGAA
AzAAA¸RAHARAAAGAzA
A=qAA
AzA  AAzAÅA  AApAGAAA=qApA{A{A=qAA=qA=qAzA  A
=AAAAAGAAzAQAHA  AGApAA  A
AAA\)AA  A  ARAHAzA{AA  AA{AffA\)AHAAAAzA
A\)AGA=qApA
=A=qA=qA\)ARAA(ApA33AARA{A\A
A{AGA\)AzAA\AAffAffA(AAQAAzA33AAA(A=qA=qAQAffAzA\AzAHA33A\)A
ARARAARARAA\A  A
A\A\AQA=qAffA=qA
=ApA(AffA\)AA¸RAHApAAzA\)A\A{AAHAAAA33AQApA(AffAHAHA33A{A(AA\AAA\A(A(AGAA
A\)A33A\AQAffAHAARA\)A33AzAffAAHA  A=qAAAAzAQAffA{A
A\AAHAAAAAA
=A(A  A33A
=A
=AGAA
A=qA(A{A{AA
A{A
AA=qAAAGAA  A{AzAAA\)AAAzAGAzAA\)AzAAA
AQAAAzAAA
=AA\ApAA=qAAffAA  A
A(AAA
=A{AAHA=qA
=ARAzA  AffAA
AHAffAApA{A\)ApAAA\)A\)AAHARAAzAA\AzA\AAA33A\)A\)AGA
=ARAzA{A
AA
AA
AA33A{A(AAA33A\AAQA{A{AA
=AffA  AA  AGA
AA33AAA\)AzAGAAA(AA(A(AA33AAA\AHAARAA=qA\)AffApARAApAAAAAA{AAAA33A33A  AAA33ApAAHAffA\)A(A=qA  A
=A=qAAAAApAAAAAApApApAA33AHA=qAQAQAARAA  AA
=AHAAApAA{A  A(A{A=qAffA(AzAQAzAAHAAAA=qA{ApA(AffA  AA
AA\)A
=A
AGAApAQAAAHA=qA{AA\AAAA33A{A33AA{AQA
=A{AAARAAffA\AffA33AzAA
=AQAAA\)AA  AQAffAffAffAQA{AAQA
=A33AAzAAQA(AAAAAAAAAAA33A\)AGAHApA{A
ApAAA{A  AAAzApAAA
A\AApARAAA
AGAAAA=qA\)A=qAGA=qAHAApAAA
=AA33AAzAA  A{AAffAffA33AAA
AGAApA=qAAAA=qApA{AA\)ARAAA  A{A(A\A\AQAA=qAffAffAAAQA33A\A(AA
AHAQA33A\AQAzAffA¸RAA£A£AffA(AAAGAzAAAAAAffAAAA  ARA
A
=AAA33A\AzApAAGAAzA  A
AAzA(AAApA
AA(AAAAHAAHApAA
AřAřAřAŅApAAA{A
A
AŮA\)AHA=qAîAAÙA33AHAAA(A
A33A
AHAď\A{Aď\AAAApAŮA=qAffAHAffA=qA(A\)AAģAffAď\AAď\Aď\AAď\AzAď\Aď\AģAĸRAĸRAffAîAA  AAA
AffA{A\)AApAAzAAQAffA33AAA=qAAHAGAÙAAQAffAĸRAHAHAď\AģAĸRAĸRAAģAĸRA
=AAAHA
=AAzAffA(AÙAÅA
=A
=A
=A=qA(AA  AAA{AA\A\)AÅA{AGA\)AA£AzApA\)A\)AGA¸RAAzA£A{ApA33A\)A=qA  A(A£A\)AQAffA  AQAGAÅAA
AAA
AAffAffA¸RA  AA=qAAHAGApA
=AAA\)AQAA
=AAQA¸RAA33AîAffAAGAAHA=qAQAAQA(A
ApA
=A£AA
AAAAAzA¸RA¸RA¸RA£A¸RA£AA¸RA¸RA\AA{AAA
AARAA  AAA\)AAAA
A  A
AzAffAAAAAAGApApApAA=qAffAzAQA
=AAzAA{AHAA
AA
ApAffA(AA\)AA(A
ApAAHA{AQAA
AAffApAzAGAGAffAGAQAzA
=A
=AA\)A
=A
=A\)A33A
=AAffAAffAA
=AGA
=A
=AAA  AAzAAAAAffA  A
AGAAA=qA  AGA(AA=qAAA  A(AGAA\)A
=AAA\AzA{A
=ARAA
A  A
=A{A(AA=qA\)A{AffAA(A=qAQAA(AAffAAA
=ARARA  A(AQAGAHAApAA33ApAA33AAAAA\)AAAA
=AAA33AAAAHA33A
=AAA
AApAAAA
A  A{AAffARA\ARAAHARAAAAzA\AHAAGApA\)AAARA
=A\A(AGA  AAAAQAzAApAGAAARAAA33ApA33A(AAGA  AA
=AA
=AAA(AGA\AzAAHA33AAGAA
=AAffAARAHAA
=AHAA{AAGA  A{AA=qARAAA\)ARAGAA\AHAAA(A(ApAAAA  A
=AAAzAAQAA\)AApAGA(A=qA\AA=qA{AApAAffAA33A  AAA{A\)AAA=qA
AAA  A\AQAA=qA{A=qA
=ARA=qA(A\AAAQA\A
=ApAffAHA
=A33AGA\)A(ARAA
AGA
=AAAA=qA=qAzA
=A33AApA33A33AzAA\AQAAA
=A\)A33AAAAffAAAAAAA(A\AA  AA
=AAA
AA\ARAQAA  A33AffA\A\)AA(AA=qAA  ApAHAHAAAzApAAzA{ARAzAA(A
=A(AA=qAzA(AAA  AA  AAAffA=qAffAGAAARAzA
=AAAA
=AAAzAHA33AA33AAAA\AA(AQA£A\)AA=qA\)A(AA
=AAApAAA  A
=AzAQA(A=qAA33AA{AAA33AA  ApA33AffA{AzA\)AQAA\A\)AAA
AApA\AA¸RAHARAAQAHA{AHA
=AAAQAzAAHAzA(A=qA{AA33A
AA33AA{AHA  AGA  A
A
=A  A
AQAAAGApAA  AQAAAAAAAGAAAAffA(AAA(A(AAAAA
A33AA
A{A
AAQAA\)AA
AAA=qAAffA¸RAAHA\)AAAffA
=AffARAA
=A
=A33AA  AGAAffARA
A  A\)AAAGA33A{AAAGA\)A=qA\AffAAAA\)AAAHAQARAAffAAQApAA  A=qAffARARAAQAA33A\)AHAApAAffA
=AA\A\)AA  ApAA
=A33AAQAAAAA{A(AzAzAHAHA  A\)A=qAAA33AQA\ARAzAA  A
AAA\)A33AGA\)A
A=qAA
=AAAAA\)A
=ARApApAAzAzARA\A  A
AARAARA\)AA\ARAQA=qAAA\)A=qAA(A\)AAAA
AAAHAA(A33AffA
ApA{A\ApAQAA
AA\)AA\A  AffAzAHA33AAA
=A
AApAA33ApAA\AA(AARA  ApAzARAA
=AQA
=A
AAffAA{AzAAAApApA\)AA{A(AApAAGA\ApAzAA=qAAAAzAAARA(AQAAAAA
=A{A=qARAAA(A{A  A33AA\AA(A33A
=AAffA  AAA33AzA(AAGAA\A
=AffAAAAARAAA\)AAzAGAA
=A  AApA(AAffAQAAQA
AAA
=AA=qAAffA=qAAAzA\)AffAzAApAffA\)AGA
AAAAAA\)AAA  AHAGA\)A(AAHAA(A\)AAHA=qAHAQAAAAA
=A{AA=qAA=qAQA{A=qAA\)AAA33AAA\ApAA33AffA\A
A33AQAA
AzApAApA  AAAffA33AQAA=qAAGA=qA33AA  A33AAAffA(AA
=AzA(AAAAAAAA=qAA\)A33AAAAAQA=qA
AARA\ApApAAARA(A
AffA=qAzA(AA
=AAA=qA{AAzAAHAQAA  A\)AAQA\)AAA(A  AHAAGAzApAAHA
AAA(AApA{AAQAAA  AAGA33A33AHAA\)AAA33AAAA(ARAAQAAA=qAGAGA
AAAA(AAAHARAARA  A
=A  AQAA=qAA
=A(A33A=qAAAA=qA{AAA
=AffA  AHApAAQA
AGAA(AAHApAHAffApApAQA
AAAAAA=qARAAQA\)A\AAA\)AAAA=qAAAQAzAAAGAAA{A=qAAAAQAAA\)A
AGA
A
=AARAQAffA{AGA=qA\)AA\AHA\)AAA
AHA\A  AHAApA  A  AAGAA\)A
AAzARA\)ApAAApAAGAAAQA  AAApAA  AGA{AA\)AAA\)ApAAAA  AAHA  AAA=qApAAAApA\)A(A33A{AA{AAGA33AA\)AA=qAHAHA\AAAA33A\)AAAAAA
=A\A33A  AzA=qA  AffAApAffA
A33A=qA=qAAGAHAffA\)AHAzA\AAQAzAAA=qA
A33A
=AAARA=qA
=AAAAAGAA\)A
=AzARAQAAARAAA
=A
=AA
=A
=AA
A  A33AApA(A  A  A{AApAAA
=AAA33AzAHAAAGAzA(AA{AA=qApAAHA=qAAffApA
=A\)AA=qAAA\)AA33ApA(AA33AGA33AGAHA
AzA\AAA(AAA(AAA
A33AQAAAA33A
=ApAzA
A{AzApAffA
ARAA33A\A(AHA\AAQAffA33AA\ApA{A
=ARAAAA
=A{A
=A
=A33AAAGAffApAAzARAA33ApAHA\)A  AzA33AHA
=AzAGAAGApAAHAQAAA
AAffAGAzA  AAzA
=A(AzAHA\A
=ApAAzA{A\AQAQAAA  AAAA  AGA  A=qAffAffAARA(ApAAHA33AAARAA\AffAAA33AAGAApA(AA\A\)A
=AAzAA{AQApAAAAAAAA33ApA{AA33A
=AAAAARAzAGAQA{AAAzAA33AA
=AAAAAHAAAApA{AAAHAGAQAAQAAAHAAARAA33A\A(AzARA\AAAffA
=AA
=AAA
AAAA33A(AzA=qAHAARAAAAA{ARApAAA33AA(AA{AAHA  A33AGAAzA
=AA\A(A33A=qAffAGA\A\AAHAA
A
=AAffAAA  AARA\)A{A33AGAzAA{A33AzA\AffAA
AA\)AQAA
AAAA\AzA{AAAAQA\)AAAffAAAHAAAAAQAA=qApARAAApAA(A=qAAzAApAAAA{A=qAAHAAHA\AApAA{AAGAHA33AA
=AHAHAAGAGApAA\A
=AAHAffAffA(A
=AHA  AGApAAARA\)A  AQAAffA(A{A  AffAAQAHARA\A
=AAQA\)AA(AffA{A  A
=AAAAAApAA\)A33ApAHAHA
AۮA޸RAAAA噚A=qA{AA\)A\)AۮA=qAȏ\AzAA¸RAɅAA\)AA33A=qAAARBB\BzB{BzB\BzBBzB
A\)A  AffA
=AzAQAHAᙚAGAAAHAAAA
A
A
A33B  BBBffBpB\BpBzB=qBRABffAGA  A=qAA
A\A33AA{A(A{AA33AGAA\)AARA
A\AAAAzA
AHAQA{A\)ApAAAA݅A
=A\)A=qAffAAܣA=qA
A
AHA
AzAzAיA߅AffAA=qAHAA{AAzAGAAGAB{B 
B   B \BB33BQB\)B{AB=qBRBB
BBzBAHB (B
=ABQB B{BBBzB\)B\AGApAA
AzB
=B  B \)AAAAffA
A=qAAffA\)ApA
A{AzA{A\)A{AA\)ApAAHA
AzA陚AA  AA뙚AApA\AAQA33AffAAܸRAGAzAHAAۮA܏\A33ApAGA
AffAA\AA\AAHAA\A  A
AAHA  AAAA  AA33ARA=qAQAAGAAQAA  AA
A홚AA
ApARA
A
=A
=A  A=qAHAAA  AAAA=qA
=A33AQA
A\)A\)AQAzA\)AA
A{AAAAAAA
=AGAApAAAA\)A
AffA{AA=qA\)AGA
A
ApAܣAGAיAzA
=A܏\AzA
AHA޸RA\AAA33AAGAGAGApAAAA(AA=qAAA33AA
A(A  A33A(A癚AHAA33AQAGA=qAHA\ApA\AA33A(AQAHA=qAzAAHAGAAA(AA(ARAA33AA
AQAQApA
=AGAAAAA㙚AA  A=qA\A
=AߙA噚AA=qA㙚AQAApB  AHAAGAAAAA=qAA33AAA\)AAARAAAAARAGA\AAQAHAGA{ARAA  AAA홚A\AzAAAGAzA33A\)AߙA  AGA=qAA
=AA(AAAffAffA
AGAQA=qA\A
AA(AAAA33AffA\)AA33A33AA33ApAA(AAAAAApAA{AffA  AGAHARA{AA(AGAzAffAGA33ApAGAAffA
A33A  AApA\AAARAAA=qAzB (B zAGA\A33A(AAffAAQAA  A
=AA\AAzA\AGAzAffA
=ApAHAzApAHA\)AAָRA\)A(A(AA
AAAApA=qA(A
=B
=AHAAAffAzA  AA=qA
=A\)B ffA
=AAzAAzA\A
=AGA
ARAAAAHA
AA
=AA33AAGA(A  A33AAAAQAzApA
=A\)AAAA  AzAQA=qA
=A=qAAA  ApAAA33AAA  A\A\AHAA{A=qA{A(A(AљApA=qA
AӮAA(A\AGAAQAffApAzAGA=qAzA
AAHAzA
AHAffAffAAA\AAA\AA  AAA  A\)A\)A
=A
AzAQA{AA\AA癚AAffA\)A
AAQAAzAHAAA=qA{AA  A  AA  AA
=AGAA\A
A\)AGAzA(A
=AAGAAQAzAQAzA
=A  AGAمApApApA(AA\AffAA\)A\)AAHARA  A
AffBBpBBB(B BGB B (B AzAAA\ApAQA33AffARAAAB HB\)A33AQAAGB pBBBRBHB\BGBB{B
=BB  BBB33BARA{AA(AAAApA{AApAzA홚A  A
=A=qAA=qARAAHAGAQAAA\AGAA=qB AA33AAffAApA33A\B BBB=qBBB(B  B
BpB(BBBBGB(B(B\BffB\BQBBBffBQA\A
=AGApB(A33B 
B\B  B
B zBpA33B B \A{A{A  ABpA
=B=qBGBAffB B zAffAzAAAAAARA(A\)AAQAAAA
AApA\A=qAA
=AQAAHA=qA\)A{AAffAHA=qAA=qAApAzAAA뙚AffAA
=ApAA
=A
=B B AA\)A  AA\)AAAffB pBzB  B\)BB\)BBB AAAzA\A
=AzA\)A  A=qA
=ApA{AQA  A
=ARAAApApAA
=A33AA33AffAA\A33A{AAAHA\)A(AA(A(AHAA
=AzA{AGAGAAB ffBzB AB B AA\BB {B 
BBpBB(B  BBB B \)AAApAB {B   ApAA\)AQA
=A  A\)A=qA=qAAA\)A\A
AA33AAB HABBRB33BBHBB B \A=qAAAGAffA\)B B 
BpB\B
BpBHB
=B
=BBpBBBBB(BHBB(B=qB(B\)A
B   B A{AB   A33B 
B B A
AB \)BffBBpBRB
BB
=BffBHB BBGBRBB(B  B(BzB33BB33B=qB
=B  BBGB(B
=BAB   AGA=qAzB zA\AA
=A33AA\A{AApAQAHARA\AAAQAzA\AA  AAA  AA(AAA
=A
=ARAAAffAQA
A=qAARAARAGA33A\AAA{A33A{A  AffAHA
=AAA\A33AGAA
A=qAAARAQA߅A\)A
AAGAzAA\A{A(AAA
=AHAzA\)A
AQA33A  AA\)AAARAA  AAA\AffApA33A\)AᙚAAApAA\)A
A{AAffARAzAzA(A(ARA33A
=AAA
=A(A=qA(A=qAAGARA\)AQA33AA\AA癚AHA{AAۅAHAHA܏\AAQAAAۅAۮAHAָRA{AӮA
A֏\A
AAGA(AzAA˅AʸRA33A(AzA
=AQAQAܣAffApAߙAAA
A33AޣA癚A߅A
=AHAA\A֏\A  AQA
A{AApAAAAHA
AA\)AAHAAffA\A
AA
AᙚA
A33AA
AzA\)AQAAA33AQAffAAAAأAA֣A
=AA
=A33A33AAGAAA  A33A{AHAظRA  AAAAGAHARA=qARAQAA=qAA  AAA\)AHAA\A\)A\)A(AAHAA=qAA\)AA(A
AAA(ApAA\AAAAA
AARAAGA33AzAGARA  AAHAARAAzApAA\)A{ARApAAzA=qA33AGAQA{AQAzApA(ARAA\AB QB BpAB =qAzApAAB =qAARARAAQA\)AffA=qAA
AHARAA\AA=qA=qAAjRA]AAHAffAAA(AzA\AA33AAA
=A=qA(AAA(AHA  AHA  AzA\)A=qARAzA\A(AGAARAAAARAAzAAAA\)A
=AARAffAzAAAApA{A{A=qAAGA\A33A33AAHAHA\)AʣAʣA  AGAA  AA֣A
=AGAzAУA=qAQAA͙AzAAA33AAAGAAAAAAAGAARAARA33AAAAffAAHAAAAA  A
=A=qAA\AŅA(ApAAGAHAϮApAffAA=qA̸RAˮA33ẠAGA=qA\)AffA
AA
=A
=ApAA{AGA=qA
AGA33AA(A
A\)AA
AApAAAA(A  AA¸RAffA
A(AٙA\)AᙚAAAQApA{AHA(AffA{A  AGAθRAAAAQAAGA{AA
=AGAAHAffA  AA33A
AAAQAA(AzAzAA=qAAQAzAřAƏ\AHAzA\)A
=ApAAffApA{AAĸRAGAHA\A  A\AffAzAəAυA  AυAzAAAAQAQA(AGAffAzAAAffAffAA33AAHAA(AAA
=ApAAAzAAAAAA=qAAͅA\AAAAAAffA\)AzA
=ARARAApA(AzAA
AAAQAzAHA
=A  AGA33A  A  AARAGA=qARAHAA
=AAA
AffAzAAA{ApAA
=AA\)A
=A  AQAA
A33AAA=qA\A
AffAQAAffA\AffAQA\)AAAA\)A(AAA33AAGAffAA
=AAARAAA33AAAAQAAAAAAzA\)A(AHARA\)ApApAA  A  AARAffApAAzAQA{A؏\AAA(A  AՅAѮAAHA{A=qAzAָRA
=AHAAHA(AAzA33A̸RAffApA
=A  A33A  AɮAˮAǙAA\)AHA
AͅAڏ\AΏ\A  AffA{AƸRA׮A{AA(AQA\)AA\A
=A  AAAA\)ApA=qAHAAAAHAA(A܏\AϙAA33AƏ\AAAzAAGAAAApARAARA(AzA{AAAGA\)A\A33AA{AzARAA{AA
=AAQAAʣA\)AApA
AGA{AAۙApAAQAffAzAAҸRAQAGA(AѮA
=AAGA\)AϙApAA33AA
=AApAzAͮA̸RA(AQAA͙A=qAޣA܏\AffAA{A֣ApAAGAffAA{AzA33AA֏\AA  AQAzAAAAQA33A\A
=AAAGAA33AQAHAHAzA(AHA
=AApA33A܏\A=qA
=Aԏ\AA݅AffAAffAAAڏ\AApApAA  A(AAHAA\)AzA  AA
=AAAAأAA\)AHAA=qAAffA{AAAQAHAQA
=A\)AQAᙚAA
A\AGA\AAGAHAAAGA\AA\AAffA33AA(A=qA
AAAA
ARAGAB 
=AAA=qAAQA33A\)AAGApApAAGA
=A
AHA(AHA33A{A=qAޏ\AQApA  A陚AA33AffAffAA\)AGAA{AffAHAAA  AA  AA
=A
AܣA  A{AA(A
=A
A(A
AGAΏ\ApAGA(A{ARAffA(AA\ARAGAA\A33A=qAAzA
AAQA
=AAA=qA噚AGAAA=qAAAGAApAGAHA33AׅA=qAHA(A{AffA=qA33A
=AA{AAAGAA
=ApA=qA\AHA{AAAARA
A(A=qAApA(A(AAA  AAGAffAGA33ARARA
=AffAA  A33A{A
A噚AA{AA33AAAHAAHA(AAA\)B 
=B33B33BBB{BBB
=BffBGBQAA{B 
=A(B RAffAA=qAA\)AffAffAA
=A33AffARA\AAAQA
=A{ApA{A
=AAffABB=qABHBB  A\AffA33AGB RA{BGBB HB33B \A33B(BBGB  B\BpBBAffBA(BpBffB=qB zAzA(AHA噚AARA33AApA{AAAzAAB GB RAB=qB\BB
=B
=BBHB{BB33B=qBB=qB33BBpB\A\AAAffBARAGAA  A=qAAQA
=AAQAAAAzApAA  AAA
A\AA  A{AHARBB =qBzB BB B B(B B  BB RBffBGBBQBzB\B 
AB   B
=AzAApAAHA\A=qA=qA{AApAHAAA  A  AAzAAAQA\AB ffB(BBRB{BB=qBB{BB\BBHB  B(BffB 
=B   B ApA  B HB  B B\B33BzBpBpB=qB=qAAAA\)A  AA(AAAffAA{AGA\)A\)ABBBBQBpB(B  BBBBB=qB\)B=qBGBBBQBGB(A\)B\A
=AHAB
=A  AzA\)B
=AQAAA\)AAA\)AffA{A{AA  AA{AA\AA
=A(B (B B 
B\)BGBffB   AA
AA{AA=qAAffA
A  A\B
=B
BB\B =qB   B  A(AARA
AA=qAQA\)AHAA\)AA=qAffA33A(AzA33AA
=B   B AB  B33B=qBB\BB=qBHBBBffB=qBBB\)B(BGB
=BQAQBB  BBzBRBpB BA
=A
=AA=qAHAApAGA{AAAARA  A
=AGAffAA{AA\)AA\)AAAA\AAA
=AA
A  AA\)ARB\ABzB\)BBAHBffB\BB(BpB33B33A=qAA{AQA  AAB(BA(AGAA=qARA
=AA=qAAAA
=AffA뙚AAAffA\AAGB\)B   AAQB{B(AB A  B GAffB(AARA=qA(AAڸRA=qA
AffAzA(ApAAHB BAffARB zB\BffBzAB(B=qA{B pA(AzA
AQA
B B33B\A
=AzAB {B \B \AB 
B HB=qB\)B=qBffB ApApApA  A{ApB AGAB  B33BBBBBBBB{A{AApARApAAAHAA\)ApB
=A
=AB ABRB\B=qA
=AQA{B HApAQA\)ARAAzAA\)AA(AA=qAQA{AAAAzAARARApAAQA=qA=qA݅AAޏ\AGAAӮAAzAQAۙAzA\)ApA33AffAAA{A
AB 
=B HAA{AAAzA33AQA  AzApAQAAAA
AGAAGAGAA\)AARAA33ApA{A=qAB
=A{AAAA{A  AQAA
BpA  AHAA33A  A
=AffApAAGAAAAAffAAzAAAGAA
=AAAApA
=AA{ApA  A
AAHAB =qB ffB 
B \B HB {AA陚ARA\)A33AQA\)AAAAQAzAӮAָRA33AA=qAAA{AAA݅A
=A
A陚AAAAޣA\AGAA(A߅A=qAAA癚A\A\)ARA=qApAffAAAA\)A
=AARAAAA{AABBBBGB
=B33BBBpBB33B33BGB B HB B  BpBHB{B{B
BBRB{B B B A(AA
=A33AffAA(A㙚A
=A
Aޏ\AA
=A33AA\AffA
=AHA{A{A  AAأAGAAָRAffAԏ\A{A֏\AхAQAAA߮AۙA=qA33AGAzAAAGARAQAAAHA޸RAA߮AAAAzA
=AAA
AGAzAQA\)AAHA{A\)A{A33B B33BGB33BQAAHAAA(AA
A  AApAA\A
=AA=qA
=AA(ARAAAA  AGA
AA
A噚AAAffA33A{A\)A\)AffA=qAAHA{AAzA
AA  A  AA\AGA
A{AARARA{AffAAA\AAHA  AA  AffAffAA=qAAApA\AB (AAzA(A
=AQAAAGAGA\)AGAGAAAA{A(A{AffA\)AAAQAAHApApAA  A
=ApAA  AAA33AᙚAA
A=qAQA噚AzAzAAA
AAAAGAA33AAA(A(AAGA\AQA=qA{AAHA{AzA(AA陚AA=qAAAAA{AA㙚A33A\AA\)AGA{A{A33AAHAQA\AAAAffAQAARA
=A\)AApAAA\)A
A  A33AAGAffApAޣA{AޣAffApA(AAA=qAffAA  AGAGA
ApA홚A홚ARA(A
A{A{A߮AA{A(AQB(AB {A33BBGBGBBB\)A{B
=BB QBB=qBHBBBB\)B\)A33AA
A{AffB\B B RAA\ARAGAGAA(B?
B=qB pB(BGABAHAAA
=A\)B  BB
=BzB=qB\BB{B\)BB\B\BpBBBB
BB\B(BzBQBpB33B{BBBzBffBRBBpB\)BHBBzBBzB\)BffBB\BBffB  B\)B\)BBB{B  B
=B  B  BBBHBBBBHBBRBBBQB=qBBRB  BQBB\BBBBffApB AB{AzB B
=B\)BBpB=qB\BBB  BBB=qB\)BB	{B	=qB	B	B	\B	B	
B	
BB	(B=qBBBRBB33BHBB
=BBHB  BB\B\)BApBGBBBRB  BBBBQBQB(B{B\)B  B
=B\)BBBzB33BRBpB=qB{B
=B	\)B	\B
B	=qBGBB	(B	\)BBB(BBB=qB	  BGBB
B(A(B 33BBGBBQB=qB\BBBQBB  BB
=B
=B{BRB=qBBB	ffB	B	{B	B	=qB	{BffBHBBB\)B\)B
=BzB\B33BQBRBGBB=qBBBBBBRB  B
BB
BQB\B
=B pB B pBGBffBRB\BzB
=BQBBHB(BzBB=qBBB\BBpB{BQB33B\)BffBBBB
A\)BffBQBBQB{BBBA癚A(ApAQAQAA(A  AAAQAA{AQA\)AAHA
AAAHA  A
AAHAAAzAAQA
AAA\A\)AAB=qA(BzBA
=AA\)AABAA\B AA\BHB(A=qB B\)BBBA{BBB  B
BB=qB(BB\)BB\BBB QB{AA\)B BGB\B pB   BB\BB=qBpBpB
BBB\BBGBBBQBBBBBGB QB  BffB\)B=qBB(BB(B GBAAA=qA=qAA\)AAffA
=ApAHB HBRB\)BRB{B 33A
=A
AAA  AAzAAAA33A=qA=qB =qBzBB
BAQBAffBGB
=BHBGBBBB{BHBpBQB
=BApAA
=AHAA\AffAffA33A33A{A(B AQB
AB B=qB\B=qA{BBRB AAA=qA  ARAA{AzApAGAAAA\)AAAAAHA\)B=qAAQARBQBffB{BffB  B33BA=qB B BB A=qA
B
BB
=B\)BRB{BzBpB	GB	\BzBQBRB
=BBffBBBHBGBGB33B
B
=B\)BB(BAzBBBBGBBGBGBQB
=BRB=qBRB\BffBRBBBBBQBBB
A(BGB
=B{AA\)B AQA
=A=qAffAAQA33AB pB A33A(A(A=qAAA{A
=AA\)AARARAA
A\)ARARB RAGA\AAHAAffA\)AAAB B  B=qAA
=B AQAAAB 
B\)B GAA
=AAAGAAA{AzAAffAAA{AApA\ApAGA
ApAAHAzAAA
AA33AA(AAApA(BGA\B 
=B B 33A\AAQAA\A33AAA{AffAA\)AffAQAA=qAffA
ARAA{AA(AQAAffAA{AAAB
=BpB=qAA{ARAAB {B33B{B\)AApA
=AAAA\AA  A
AARARAA
=AB AB AA33A33AA\)B \ABAApAffARA(B BB B BB\)B BB B\)ABBzBQB(B =qB B QB =qA=qA\A
A
AB {A\)A
A(AHB AApA  A\)AA
A\AA\)A\)AA33AARAzAAA
B HAAzA
=AGAA33AHA=qA\)AA(AQARA
A\)A\A=qBGA
A  B GB HApAAB 
B \)B(B\)B B=qBB
=BB(BAGApB BBpB ffA
AB pBffBBRBHB {AARApB \)AABAA\A\)B ABA=qA\AzAGAHAAffAA
AA(AzA
=AAA=qA=qAAARA
=A{ApAffApA  A  AAAzAQAzAA{A\AzA33AA(AHB ApB{B zA33A
=AzAA\)AGA(AA(ARA
AA(AHAAHA33ApAHARA=qAARA\)A  AffA{AAGA  AA
AAA(ARAHA  AGAAGAAA33AA=qAA\)AAARAAAHA=qBRAAAA\ApAffAAAA
AA܏\A  AAA{AQAB  A
A
=A{ABAzAAA
=AGA{AAGA=qB 
BffAffAA(AAA\)AQAAAGAHAzAAffAAәA\)AAݮAHA
=A\AGA
AA\)AffAAĸRA
=AυȀ\AQAAAA\)AHA\AA
ApAQA\)AAAffA{A
=A(A
=A{A{AHAAffAQAzAAQA33AA؏\AAffAQAՙAԏ\Aȏ\AAGA\AA{A
=A  A
AA\)AAA
A\AA{A=qAAffAzA\AHApARA=qA{AyGARAHAA\)A
=AGAA\AffA=qA{AApA\)A(AA
=AAApAAAAQA
=ApAAzA
=AffA  AApAA33AzA{AAAQA\AAGAA33AGAzAAAffA
A  ApA{AA=qAHAA\)A
AA
=A\)AAAARA{A{AffAzA\AAzA=qA
AA{A
AAAGAzAÅAffA
AAA{AA\)A
=A
A33A
ApA
=AA
AԸRA{A׮AAGA=qAffAיAAAHAffARAAAAzAHA\A33AAQAA
A{A
=A(A33AAA(AAAA{AAAQAAffA\)AzAAAA\)A(AAA{
=A
=AAAAAApA\)A\A{ApA\AGAQA33A(A(AHAAQA\)AA\AAA
AAAAA
A
=A33A  AA
=AARAAAAnHA
=AAyGAg33AsAQA|  AyAlzA
AAQAAAAAzA{AGAffAzRA  AuGAl  AiAg
A`AaAnHAAApAAAQA{AA\AAA{A~=qAlQAS\)A@AIADzA9pA>ffA4A4QA#A\A*=qA.\A5A8A7
A.HA%AA&\A=pA9AEA"ffA
=A@ffA*=qA>RAP(A[\)AZ=qAd(AYAd  AlAb=qAmAAmARHAiGAaAlAw33A(AO\)A=pA6\A]AAmGApApAA
A\)A=qA
=ApA33AAzA  A  A33AHAQAARAAzAA=qAA\AA\ARAHAQAA
=AA=qApA{A(AHAA\)A\AAA(A\AAAQA=qAAAAGA\)A=qAAARAQA\A  AGAHA33AQA\A\)AAA
=A(AffAA(A\ApAAAzAGA
=AAɮA\)AzAffAAͮAA  AA=qAQAA=qAffAA33AAQAARAzA=qA(A(AAA=qA{AA(AA\)A=qA=qAAԸRA{AffAAAAQAAAAAɅA˅A\)AAAУA
AיAAHA(A{A
=AͮA{A\AޣAffAAA
AAәAQAAHA\AAzAAAGAzAAAzAՙAУA33A(AHAHA{AAGA=qAffAϮA=qAHAQA\)A
A=qAAď\A\AAAA=qA
=ApA  AAQA\AzAŅAAAA{AApApAGAAA癚AffA(A\)AffAAApA\)AffAGA홚AAAAAѮA{AQAGA{AGAzA
=AȀ\AɮAǅAǅAʣAAApApA  A(A
A=qAAQAA
A\)AQAAApAA
=A\ARApAģAAA
AAAA(A\AAQA(AGAѮA33ARAzAQApAAAυAAGA\)AǙA33ApAA33A33AŮA\)AQA=qA  AңAׅAGAApAĸRAAQA\A33A33A
=A33AHAAHAHA˙A
A
=A33AzAGAəAAA33AͮA
AܣAAA
=AffA(A
=AˮA˅AGAGA(A{AA{A=qApA
AQAGAģA̸RA\)AA{AA\)AAAA33AA{AAAAA33AAՙAAA  AAA
=AA\AHA\)AAAA(AA  A\)AQAA=qA\AQAA
=A͙AәA
=AQA(AAA  AApAڸRAAAAA
AAzAzA\A\)A
A׮AAڸRA
=A噚AzA\)A
AЏ\AAԣAApAA
AУAHA̸RA33AՅAAQAAՙA(AٙAARA
=AיAzAApA
A\)A{AHA
=AAA  AˮAA\)AAARA\AffAAAQAA33ARAQA{AAA£A  AAAAAA
=ApAAAHA{AA
A=qAAffAzAAA
AQAA
ApAHAۮAA\AAHAϙAAޏ\AA33AffAffAHA  AٮAҏ\AA33A܏\A޸RA=qAAGA33AAA
A
=A=qA
A̸RAˮAAA(A\)AƸRApAHApAٮAɮAA(AA
A\AzAGA\)A(A33A=qAA(A=qAHA\AffAA{AQA\AA33ApAzAAA\)AA33AA{AAffARAA|A
=AzAzARAAAARAA=qA{AGA(A(AzAzA{A=qAAAApAzA{AAAHA{AQAAAAAGA\)AAAHA\AHAAA
A  AHAA\A33A(A
A??33?ff?ff??ff>?333?>?33>>?333?   ?fff??333?333?  ?L?333?333?L?fff??333?  ?@>?  ?333?   >?  ?   >??333?   ?333>>>>?   ?>=>?   ?   ??   ?333?   ?333??333>?   ??   ??   ????fff??33?ff??333?L?333?   >?   >>??L?333?fff?333??333?L?ff?L?fff?33?333?L?333?333?   ?333???   ??   >???>?333??   ??L?  ?333?L?>?L?   ??   ??fff>>>>>>L>L>>@333==ͽͽ>L>=>>>L====ͽͽ            ͽ        >=>Ϳ333L    ==?>L=>>>?   ff>>?   >?   >>?>>>>L>??L?>?333?   >?   ?   ??L?  ?333?333?333?L?   ????L    =?   ?333?333?ff?333?fff?  ?fff?  ???ff???ff?L?333??333?L????333??333???   ?333??333?   ?fff?L?L?L?   ???333?L?333?L?333??L??L?333?333?   ?fff?fff?333?  ?333?333?   ?   ????333?333?333??333?>??   ??333??L?333?L?333?333??fff?  ??ff?ff??33?ff???  ?  ?fff??L?  ?L?fff??L@ٙ?fff?  ?fff?fff??L?333?fff?fff?L?fff?fff?  ?  ??????  ?fff?fff?fff?  ?fff?  ?  ?333????  ??L?L?333?  ?L?fff?  ?  ?fff?fff?L?  ?fff??ff?fff?L?fff?fff?fff?333?333>L?  ?fff?333??L?fff?fff??L?fff?fff?fff?L?L?fff?  ????ff?  ??ff??ff???ff?  ??L??fff?L?fff?L?L?fff?fff?  ?  ?333??333?fff?  ?L?L?L?L?L?fff?L?  ??  ?  ?  ?fff?fff?ٙ?L?fff?L?L?L?  ??  ?  ??  ???33??33?ff??ff?  ?ٙ?ٙ?33?ff?ٙ?33?ٙ?ٙ??ٙ?  ?ff??  ??  ?  ??33?ff?33?ff??????fff?  ????fff?L?fff?L?fff?fff?L?L?fff?fff?fff???  ?  ?L?L???L?  ?L?fff??fff?  ?L?fff?L?  ?  ??ٙ?ff@   ??  ?fff??  ?333?   ?   >??333?L??333?333?333?L?L?333??ff?fff??ff?33?L?ff?  ?33?  ?33?  ??ff?fff?  ??  ?fff?ff?33?33?  ???fff?fff?fff?  ?L?L?  ?333?fff?L?L?fff?L?L???  ???  ?  ?fff?333??333?fff?fff?333?333?fff?333?333??  ?L?333?333?L?333??   ?33??   ?   >?   ???fff?fff?@   ??ff?  ??  ??ff?ٙ?ٙ?  ?ٙ@   ?ٙ??ٙ?ٙ??  ??ٙ?ٙ?  ?33?  ??  ?33?  ?  ?  ?ff?ٙ?33??  ?ff?ff??33??ff??ff?  ?33?33?33?  ?ٙ?  @   ??33??33?  ?ff?fff?  ??33?ٙ?  ?  ??33?ٙ?ٙ?ٙ?ٙ?@   ?  ?ٙ??ٙ?ff?ٙ??33?  ?ff?  ?ff??ٙ?ff?ٙ?33@@@,@,@9@9@&ff@,@L@9@9@Y@&ff@L@y@S33@Y@L@s33@s33@ff@@@33@ٙ@@ffAffA  @陚@ff@ff@ffAffAffAffA33A1A>ffAK33@33AA  A#33A	AA33A<A.ffA4ALAlAffA  A  AffAA33A33AffA|AVffAlAqAyA\ADA6ffAP  A0  AvffAdAx  AffAAA33AffA33AAA33AffAffA  AffAffA  A33A  AٙBBB	33B$AB   B
A  B`  BC33BffBffB33B33B  BՙBBS33BffB  AB33BBA  AB[B:  B33ABpBhffB#Bh  B_33BB  BB"  B*  B733B1B4ffB(ffBJB%BBB33Bs33BYBffB  Bl  BcB@S33ABn  B33B  BLffBffB-AffB>B  BAəAA  A  AB#B*B/AC33B33B\Bq33B  ?333BB33BD  B~BؙB  BgBBBffBBY33B  BffB33BffB33BBB  B33BBffB33B  BB  B  BffBBBB33A33B  B  B  B  A33BcC&LBffBB  B5CB  B33B`BVffBDB0ffB!33BDBB33B  B@  BBffB33BC
ffC"3C	C33ABz  @333CLC	B{33B{33B  BffBBpffB  C:A33CQffCOCAffAC CjfCvCALB  C	DhC33C A@  BÙC$CC& CCNBCBCB33C33CB33C533C33Cn33C@ffCIC
CN  C]C
ffC?fB  CA B  B\ffB  BffC-C?ffCKBCQ33BffB♚CU  C3BffCfB  C3CO33B  C8LC^ffBC B  CBK33BffA  B33BB33@&ffB  BBߙB陚BC+  AC	BAffBj  BřB33C$3C>fBffBffC CCxC C  CBC  CYC CCCRAC33CjC C33C`C4C)  CC  C<CLB.  C1LCGC@ C3C333C CCYCC33BݙB33BC
ffCRfCC/ BA[33AffC?3BffCBCLC1LC7 CN33CL@C3 @s33C C
fCffC^ C533C COCٚCfC3C CfC33C33C&fD	3C|CCyLCfB  CkC C#CULCLCRfBffC33C@ CWffCLCC33CCC  CoCsf@ffCL3CffCfC&fCC@ BC9LCCCLCLCfCLC(3CCCCffC*ffC2  C1C.3C33CCfCLC3CfC33C3CffC-33CC5CffC%fC'ffC)ffC,3C-C
33C/ C%3C)3C4fC7 C% CHCfC=  C6C1C9  C+fC2C 3C0C[ CO33CZCA C~Cx3CCdC C(33C#33BffB33C| CnfC~3CICD33C1C!3C!ffC#fBffC
C33C3CC1  CLBffC 33C:ffC!3CBBC=  C9fC*fC#  C'C:LC  C?3CIfCJ33Cx  Cp ChLClCLChfCNCffC&fCx  CfCnCf33CQffCLCٚCaCfCYC  CCffC3CfCfCfC[CSC33Cb3C@`  @fff@ff@@@ff@  @@@@33@  @@33@@@ə@33@@@&ff@&ff@@9@Y@Fff@L@l@@  @Y@Y@Fff@,@   @,@,@@  @9@S33@@  @S33@Y@Fff@l@l@33@s33@  @ff@@33@@@33@  @@@  @33@33@33@,@&ff@33?ff@   @@   @33@ff@ff@@9@L@L@&ff@@&ff@Fff@9@Y@`  @l@`  @9@L@Fff@9@&ff@9@   @,@@333@@&ff@&ff@,@&ff@@  @9@,@,@Fff@@  @L@Y@333@,@333@@  @L@Y@Y@fff@l@ff@@33@@33@@@@@@33@?ٙ?ٙ@ff?33@33@9@Y@s33@L@l@@  @Fff@9@S33@@33@@  @fff@333@Fff@s33@,@Y@33@L@ff@fff@y@@@Fff@ff@  @33A33Ax  AffAAA;33AffAA33@  @@@  @  @@  @ff@@@ff@ff@33@@ff@  @33@@@@ff@33@@@@ff@33@ff@@33@@@@ff@ff@@@  @l@S33@Y@S33@&ff@333@S33@  @9@@ff@Y@@ff@  @s33@ff@  @33@@@fff@33@y@L@fff@fff@`  @l@fff@Fff@L@Y@@ff@@ff@@33@33@&ff@333@,@,@&ff@L@,@333@Fff@L@Fff@333@y@33@@ff@33@@@  @33@y@  @y@y@l@33@fff@Y@s33@`  @@  @S33@fff@`  @L@S33@`  @fff@S33@Fff@Y@Fff@@  @l@L@fff@Y@Fff@s33@l@fff@Y@Fff@&ff@333@9@9@   @   @@&ff@33@&ff@@,@&ff@Fff@9@333@9@,@333@9@@   @@33@   @33@,@   @,@ff@,@   @9@Y@`  @s33@s33@33@`  @L@ff@  @33@ff@@ff@33@ٙ@@@ff@@@@ff@ff@@@@33@@@@33@@33@@@@  @  @  @33@33@  @33@33@l@33@@  @@  @@33@Y@Y@Y@l@`  @`  @l@`  @s33@y@l@ff@s33@l@fff@y@@@  @33@ə@  @33@ff@s33@y@L@9@   @333@9@33@,@@  @  @,@333@333@333@Fff@Y@y@  @  @s33@`  @Fff@333@,@333@&ff@@&ff@,@333@@  @,@   @,@   @Fff@@  AAA>ffAs33AAA33AffAAaAffAs33AAAAALAC33A!A$A!AffALAX  A<A333A1A9A6ffA,AffAffAffAffAA33A   @ff@ٙ@ٙ@33@A   A   AA   Aff@ff@@@@@ff@ə@  @ff@  @@  @@  @33@33@  @  @@@ə@33AffAff@33@33@33@@  @@ff@33@@y@33@l@Fff@S33@@L@33@33@@@  @s33@@@ff@  @ff@y@ff@@33@fff@fff@  @33@y@fff@fff@9@9@9@S33@S33@S33@y@y@s33@@ff@L@  @s33@y@y@  @  @Y@s33@s33@Fff@s33@9@@@@@  @@Y@L@fff@  @@  @&ff@@  @fff@Y@s33@fff@`  @333@,@,@&ff@Fff@S33@@  @33@S33@  @y@s33@  @  @s33@Y@9@,@L@S33@@  @9@333@9@&ff@Fff@Fff@@  @L@l@   @Fff@&ff@&ff@&ff@,@   @33@,@333@333@&ff@&ff@333@ff@   @ff@   @@,@ff?33@33@   @@ff@33@@@@   @@@   @@9@&ff@,@@  @   @33@33@&ff@ff@@   @33@@@33?ff@?ff??ٙ??  ?  ???ٙ?ff??ٙ?33?  ?ٙ?ff?33?ff@@33@33@ff@@@@   ?ff??33@33?33@ff?ff@   ?ٙ?ٙ???ff?ٙ?33?ff@??  ?ff?ff?ٙ?ٙ@ff?33?  ?ff?  ?33?ٙ??33?  ??33?33?ٙ?ٙ?ff@   ?33??  ?ff?ff@@33@,@@333@@ff?ٙ??@ff??ٙ?ff?33?33?ff?ٙ?  @,@&ff????  ?33?  ?33???  ???33?33?ff?ff?ff@@   @ff@   @@ff@@   @@,@33@   ?ff@ff@ff@ff@33?ff@33@   @33@   ?ff?33??ٙ@L@   ?ff@&ff@   @   ?ff?33?ff?33?33?  ?  ?ٙ?33?@   ??ff??ٙ?  ?ff???ff?33???33?33@&ff@?ff?ff??ff?33?  ?ff?  ???ff?ff?????33??  ?  ?ff?33?ٙ?ff?  ??????33@,@&ff@   @333@ff@ff@ff@ff@,@&ff@   @&ff@,@?33@33@Fff?ff@33@   @@33@ff?ٙ?ff?  ?ff?  ?  ?33?  ?ٙ?  ???33?ff?ff?33?????33??33??ff?ٙ?33??ff?  ?33?ٙ@33@@&ff@@  @   @   @@&ff@@&ff?ff@??ff??ff?33?  ??33??33?33?ff????  ?ff?33????ٙ@y@33@s33@S33@L@   @@,@@   ?ff?ff@ff?ff?ٙ?ٙ?ٙ?  @   @?ff?33?  @33?ff?ٙ?ff?  ?33?ff??ٙ??  ?ff?ٙ?33?33?33?ff?ٙ??ff?ٙDd?33?33?@@@@333@@  @?33?ff?  @ff?ff?ff?ff?33@   @ff@9@,@?33?  ?33?33?  ?ff?ff????????333?L?  >?fff?333?L?L??33?L?333?fff?  ?ff?33?ff?ff?ff?  ?  ??ٙ?@33?  ??ff??  ?33???ff?33?ff?ff??ff?ff??  ?  ?  ?ff?  ?ff?L?33???  ?  ???  ??  ?  ??ff?>??  ?  ??ff@   ?  ??33?33?ٙ??  ??ff?  ?33???fff?33?ff?ff?ff??fff?fff?  ?L?  ?L?  ???L?  ?  ??  ?33???33?  ?ff????33?  ?  ???L?fff?L?333??ff?  ???ff@???????ff???  ??33??L=??333?????ff??333?fff?fff?  ?L??  ?ff???333?fff?fff?L?  ??  ?  ?  ??  ?  ?ff????  ??  ?333??33?   ?ff??  ?ff?333?fff??33?L?  ?L?33??ff?  ?  ??  ?  ?33??ff?33??ff?fff?fff?  ?  ??  ??ff?ff????  ?ff???ff?ff????ff??ff?  ?ff?  ?ff?  ?ff?ٙ???ff??ff?  ?ff?  ??  @333?  ?ff??ff?  ??33??ff?ff?33?ff?ff?ff?ff?ff?33@ff?ff?  ?ff@??  ?33?ff?ff?ff?ff??33???33?  ?ff?33?33?  ?@?ff?  ?33?ff?33?33?33?33?33?ٙ?33??ff?ٙ@   ???ff?ff?ff??  ?  ?33?33???33?ff?  ???33?  ?  ??  ?33?ٙ?33??33?33?ٙ?33?  ?ff??33@   @9@ff@9@L@ff@33@333@@&ff?ٙ?ٙ@   @ff?33@   @@ff@ff@   @33@ff@ff@ff@   @   @   @33@@?  ??  ?33?33?33?ff?  ?33?  ?33?  ?  L??333?fff?  ?   ?333??L?333???  ?fff?fff??fff???  ?333??ff???ff????????>?????ff??  ?33?33????ff?  ??33?33?  ?333???33?33?33?  ?33?33?33?33?>?fff??ff?ff??33?33?33???33??L?   ?33?  ?33>?33?33?L?  ?  ?33?  ?ٙ?ff?33?33?ff?ff?ff??ff?  ?ff??33???33???ff??ٙ??33?33?ff??ff?33@ff?ٙ?ٙ??ٙ?ٙ?  ?ff?33?33?  ?  ?33?33?ٙ?  ?ٙ@333?33@ff?33?ٙ?ff??ff?33?  ?ff?ff?33?33?33?33?33?33?33?33?  ??ff@33?33?ٙ??  ?ff?ff?????????33?33?ff?  ?33?ff?33?33?ff?A	?33?ff?33??ff?@@33?ff@@@@ff?ff@&ff@@9@333@&ff@L@   ?ٙ??33?33@@33@@@@33@@ff@@33@33@33@ff@   @33@33@ff@&ff@   @   @33@ff@33@ff?  @@ff@   ?33@333@   ?ff?ff?33?  L??33?ff?ff??33?33???333??@33?ff?ff?  ??33?L?  ?33?ٙ?ff?33?33@?ٙ?ff?Ϳfff?L;ff@   ?@ff@?33?ff?33@   ?33??ff?  >?  ?@33@@  ?  ?@@33@ff@@  @  @@@@33@@@  @l@@  @S33@9@,@L@@  @Fff@`  @@  @,@333@&ff@@  @333@@  @333@L@333@&ff@   @@,@333@@@   @&ff@333@   @?ff???ff@@33@333@9@9@9@&ff@,@@,@@@?33@ff@ff@33@   @ff@@   @,@9@333@9@Fff@L@@  @L@S33@@  @@  @Y@L@@  @   @,@9@&ff@33@&ff@&ff@@&ff@333@   @9@@  @l@@  @`  @  @s33@`  @@  @y@33@s33@`  @9@333@&ff@333@   @333@9@ff@@ff?ff@?ff@@33@@@@   @33@,@`  @33@ff?  @?  ?33???  ?ٙ?ٙ?ff?  ?  ?@   @   ?ٙ?ff??ff?  ?ff?ff@   ?ff@   @@&ff@&ff@&ff@@  @   @333@,@  @`  @ff@ff@@   @ff@   ?ٙ?ٙ?ٙ@ff?33?ٙ??33?ٙ?ٙ?ٙ@@@   @   @ff@33@   @@33@33@@ff@@   @   @33@   @ff?33@33@ff?33@33@ff?33@?33?ff@@ff?ff@ff@@   @ff@   @   @L@9@9@   @@   ?33@ff@ff@ff?ff?ٙ@   ?  @   @   @ff@ff@   ?ff?33?33@@@@  @   @,@@L@   @9@@  @L@Fff@S33@@  @9@Fff@,@L@9@&ff@@?  ?ٙ@   ?ٙ?ٙ??33??  ?33?ٙ@?ff?  ?ff??ٙ?33?33?33?ff@   ??ff@33@&ff@   ?ٙ@33?@,@,@   @333@9?33@,@33y@ff?33@   ?33?ٙ?ff??33?ff?ٙ?ٙ?  ?  ??ٙ?  @   ?ff?33?33?ff?  ?33?ٙ?ٙ@   @   ?33@   ?ٙ?33?ٙ?ٙ????ff?ff?ٙ@   ?ٙ@   ?ٙ?ff@   @ff@   ?  @,?ff?ٙ@ff@Fff?33@?33@9@33@   ?33?ٙ?  ??ff?  ?ff?  ?ff?ff?  ?  ??33?ٙ?  ?33?ff?  ?33?  ?ff?ff?@ff?33@   ?33?33@   ?ٙ?  ?ff?  ?ٙ?ff?ٙ?ٙ??33??33?  ?33??33?33??ff?ff?  ?33?  ??ٙ?ٙ???33?ٙ?33??33?  ??  ?33?ff?33?ff?ff?33?33?ff?  ?33?ff?33?33???33?ٙ??ٙ??33?  ??  @??ٙ?ٙ@   ?33?ff?ff?ٙ?ٙ?ff?  ?  ??  ??ff?33?ff?ff@   @@ff@   @ff@ff@,@&ff@   ?  ??33??33??  ??ٙ??  ????33?33Aff?ٙ?ٙ?ٙ??ٙ?ٙ?ٙ?ٙ?ٙ??  ???  ???  ?  ?  ?33?  ????  ?ٙ??ٙ?  ?ff?  ??  ?  ?ٙ?33?ff?ٙ@@   @33@@@ff@?33@?ff?ff?33?ff?ٙ?ff?ff?ٙ?@   ?33@ff@   ?ff?33@   ?ff?ٙ@@@   @ff@   @   ?33?33@   ?ff?33@   @   @ff@@@   @@@?33@?33?33?ff?33?33?33?33@@   @?33?33@@33@   @ff?33?  ?33?33@   @   ?ٙ??  ???ٙ??ٙ?ٙ?ٙ?ff@   ?@   @@ff@   @33@@@?33@   @33?33?33?33@   @   @@   ?33?ff?33?ff?33?ff@   @   ??????33??33?ff?ٙ?  ?  ???  ?  ?33?33??  ?ٙ?33?ff@?ff???ٙ?33?ff?ٙ?33?33@33@33@ff@33@@   @   @?ff?ٙ?  ?  ??  ?  ?ٙ?  ?  ?  ????ٙ??ٙ?  ?  ?  ?  ???ff@   ?ٙ??ff??ٙ?ٙ?ff@ff?ff?ٙ?33@   @ff@@   @ff@   @   @   ?ff?ff?33?????ٙ??ٙ?ٙ?ff?ff?ff?ٙA#33@ff?ff?ٙ??ٙ?ٙ?ٙ???ff?ٙ??@  ?ٙ?ٙ@&ff?ff?ff????  ??ٙ?ٙ??ٙ?ٙ??ٙ?ff?ff@   ?ff?ٙ??ٙ?ff?33@ff?33?33?ٙ??33?33?ٙ?ff@   ?33@ff@ff@   @33@   @   @&ff@33@   ?ff?33?  @   ?ff@   @333@   @ff@33@@@   ??33??  ?ff?ff?ff?ff?ٙ??ff@&ff@@  @fff@L@  @Y@l@Y@@  @L@L@L@fff@Fff@9@333@333@333@,@,@,@333@333@9@&ff@9@,@   @,@L@@  @33@33@33@33@33@@33@33@33@33@   @   @,@@  @&ff@@33@@&ff@,@&ff@&ff@333@,@   @,@   @&ff@33@   @&ff@@,@9@,?33@@@&ff@9@333@9@333@33@333@&ff@&ff@   @@&ff@&ff@@   @@   @&ff@   @&ff@,@&ff@&ff@@ff@   @ff@@   @ff@   @33?33?ٙ@ff@@ff@ff@ff@ff@   @@@@@   @&ff@ff@&ff?33@?33?33?ٙ?33?ff?33?ٙ?ff??ff?  ?33??33??ٙ?ٙ??ٙ?ff?ٙ?33?33@@ff@ff@@ff@@@@33@@@ff?33@ff@@   @@  @   @S33@9@33@&ff@333@9@S33@Y@Y@L@@l@@  @L?ff@l@S33@Fff@Fff@,@333@&ff@33@   @33@ff@33@ff@ff@   ?ٙ@   ?33@   ?ٙ@   ?33?ٙ?  ?ff?ff?33@   ?33?33@ff@   @@ff@ff?33?ff@?33@   ?33?33@   ?33?ٙ???  ?@   ??ٙ?ff???ٙ??ٙ?ٙ?  ??ٙ?ٙ???ٙ?  ???ٙ?ٙ?  ?ff???ٙ???  ?ٙ?  ?ٙ??ٙ?ff?ff?ff?ff?33?33?33?33??  ?33?ff?ٙ?33@   ?ٙ@   ?33@   @@?ff@ff?33?33@ff?33?ff?  ?  ?  ?  ?ٙ?  ?ٙ?  ?33@   @ff@   @ff@&ff@   @LA+33@ٙ@@@@9@@ff@`  @Y@ff@fff@@  @33@l@ff@fff@Y@@  @   @&ff@9@  @l@@   ?ٙ@   ?33?33?ff?33?ff@   ??33?33@   @33@@   @   @@   @33?ff@&ff@   @@,@@  @&ff@L@Y@@  @9@Fff@Y@S33@33@y@y@s33@  @@L@y@33@ff@@y@s33@s33@y@  @33@y@  @33@  @ff@y@33@@L@@  @`  @S33@Y@33@33@33@@ff@   @33?33@9@@ff@   @@  @&ff@L@333@S33@&ff@,@  @@Fff@9@ff@@  @9@@  @@&ff@ff@@   @?33?ٙ@9@L@Y@,@9@y@s33@9@y@9@fff@@  @@L@S33@l@@ə@  @@@33@33@@@ff@ff@33AAffAffA	A9A@@陚@@@@33@@  @ff@33@  @33@@ٙ@@  @S33@S33@@33@fff@  @9@ff@@33@  @  @Fff@y@ff@33@@S33@Y@@  @ff@Fff@fff@ff@@  @Fff@Fff@S33@fff@33@&ff@Y@Y@S33@S33@y@@@  AA1AtAAAffAffAAffA~ffAp  AIANffA9A4A,AH  A0  A+33A,A4A(  A&ffA   A33A   A   AAA  A33@ff@@ٙ@ff@  @  @33@@ٙ@@@@@  @@ff@  @33@  @ff@@@33@ff@33@  @  @ff@  @@  @ff@33@33@ff@ff@@  @@33@@ff@33@ff@  @@ff@@  @@ff@@  @@ff@s33@33@  @l@Y@L@@  @S33@Fff@,@&ff@,@9@  @ff@ff@@  @ff@y@s33@l@`  @Fff@fff@33@fff@33@y@  @y@`  @`  @fff@33@ff@  @  @@ff@@33@ff@ff@@@33@  @  @  @@  @@ff@@@  @@@ff@ff@33@ff@@@@33@33@33@@33@ff@陚@  @33@33@33@33    @ff@@  @  @ff@33@ff@y@ff@s33@y@fff@  @l@fff@s33@fff@  @S33@fff@  @@fff@@y@  @  @fff@  @`  @y@ff@l@y@ff@s33@@  @33@fff@  @33@@ff@  @ff@@@ff@@@33@@L@@@ff@33@@@@@  @陚AA>ffA1A0  A.ffAA!A#33AffA33A  A33A33@ff@ff@ff@ff@ff@  @33@  @ff@  @ə@ff@33@33@33@33@33@@ٙ@33@ٙ@  @33@ə@33@ٙ@@ٙ@@  @  @  @ə@33@A@@33@33@@ff@33@ff@ff@33@@  @@@@ff@  @@@@33@ff@@ff@ff@@@  @@33@ff@@33@ff@  @ff@@@ff@  @@@  @  @y@  @y@s33@y@`  @Y@`  @S33@Fff@fff@`  @l@s33@Y@33@l@S33@l@s33@l@s33@l@s33@y@fff@l@y@y@l@l@fff@fff@S33@fff@Y@S33@s33@y@s33@s33@s33@l@fff@`  @`  @fff@l@l@s33@  @  @@s33@s33@s33@s33@S33@Y@33@s33@s33@  @ff@s33@  @@ff@33@s33@l@fff@`  @Y@S33@S33@S33@fff@`  @y@fff@Y@fff@S33@`  @Y@Fff@@  @L@@  @@  @S33@fff@`  @L@fff@`  @33@9@@  @333@@333@,@@  @L@`  @S33@Fff@`  @Y@fff@Y@Y@l@9@S33@Fff@S33@S33@@  @L@S33@Y@`  @`  @fff@`  @fff@`  @`  @s33@l@`  @Y@Y@@  @Fff@L@@  @@  @9@Y@l@33@fff@&ff@&ff@@@@   @,@33@@   @@333@333@9@333@9@9@@  @S33@Fff@,@L@@  @Y@Y@`  @   @33@33@33@ff@   @&ff@   @@Fff@S33@Fff@L@Y@S33@Y?333@Y@L@Y@Y@9@333@@  @@  @S33@333@333@@  @9@333@   @,@333@@@L@L@L@L@Y@`  @S33@L@`  @S33@Y@s33@S33@Y?@@  @y@y@Y?  @fff@`  @fff@L@@  @333A33@33@,@&ff@&ff@   @333@@  @   @&ff@&ff@&ff@,@@  @,@s33@fff@@  @333@Fff@9@&ff@,@@  @333@Y@L@&ff@333@  ?@@&ff@,@   @9@9@333@9@   @9@9@&ff@   @@  @Fff@@   @,@9@9@,@,@333@@  @,@,@33?33@   @@33@@@ff@@   @@&ff@33@33@   @,@@  @9@fff@L@S33@Y@L@S33@`  @L@`  @S33@Fff@9@L@9@9@ff@,@,@333@33@@&ff@,@&ff@9@9@@  @@  @L@@33@   @ff@ff@   @   @   ?33@   @   ?ٙ?33@&ff@@@@9@333@@ff?33?ff?ٙ?  @?33?  ?ٙL@&ff@333@333@,@ff?33@   ?ff@   ?33@   @&ff@9@&ff@33@@9@@  @@33@@ff@?33??ff?ff@@   ?ff?33@   @ff@?ff@?ٙ@@ff@@ff@@33@ff@?33@@33?33@ff@33@@   @9@33@,@@  @ff@ff@ff@@,@33@   @   @ff?ٙ?ff?ff?ff?ff?  ?33?ٙ?33@&ff@   @ff??ٙ?ٙ?33?ٙ?33@@   ?33@,@33@,@   @33@@  @@  @S33@&ff@&ff@@  @,@&ff@fff@Y@Y@S33@9@@   @333@ff@33@ff@ff@   @33@@ff@,@@   @&ff@   @D @@@@&ff@   @&ff@33@@ff@ff@ff@@@33@33@33@@@?33@   @   @@ff@@@   @@L@@33@   ?ff@@ff@@?33?33@@@   ?33@@   @ff@   ?33@ff@ff?33@   @@@  @s33@S33@@@   @L@@  @9@333@9@&ff@&ff@,@Fff@9@,@   @&ff@L@Y@9@&ff@9@9@9@,@L@9@S33@Fff@9@@  @Fff@@  @,@@  @@  @9@9@9@9@333@9@&ff@&ff@@  @,@&ff@,@&ff@33@   @ff@&ff@@333@,@,@   @&ff@@   @   @&ff@333@                                                                                                                                                   y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @@
=@@@@H@Q@G@p@@@H@@@@33@@z@z@@@=q@\@33@Q@@\)@@G@ff@@陚@G@G@@G@(@  @(@@Q@@@陚@陚@陚@=q@G@@@=q@R@  @ٙ@@33@Q@ff@z@
@\)@ٙ@G@H@=q@z@@@أ@
=@@p@޸R@߮@{@z@@陚@G@@@\)@H@@ᙚ@@p@@\@@@=q@\@z@(@ff@@\)@  @R@
=@\)@\)@
=@  @\)@\)@  @\)@  @@R@R@  @{@
=@
=@@ff@@@  @ff@@=q@@߮@p@\@@=q@ᙚ@߮@߮@@
=@޸R@ᙚ@z@33@p@@߮@߮@  @ᙚ@\)@߮@  @
=@{@@
=@\)@@
@
@@{@z@
@
@33@\@ᙚ@\@=q@@z@p@@
=@\)@R@@
=@(@@\@\)@\)@@G@@@
@(@@@p@{@
=@\)@@Q@@@=q@@=q@@G@Q@@\@@@@@H@@H@@
@{@@
=@33@@@
=@ff@ff@\)@@@@
@@  @
=@(@p@
@@(@@@H@@@33@@33@\)@Q@G@
@@Ӆ@У@=q@@{@  @
=@33@ff@
=@Q@33@33@@@R@@陚@@
@z@@R@\@\@\@(@@ff@@@\@H@@33@@  @
=@@{@ff@  @@p@p@
@=q@z@=q@  @G@@{@@R@
=@p@ff@(@33@@Q@\)@ff@ff@R@@@@@@
@(@@z@@{@{@
@p@@33@z@33@33@=q@G@@  @  @  @@  @  @{@@ff@
=@p@G@@(@@Q@
@@
=@@@@\)@G@\)@R@@z@@R@@p@Q@@\)@=qA zA A AGA{A=qA{A QA Q@
@
A @{@Q@@(@p@@Q@@@@@  @  @@
@H@@@33@R@\)@
=@\)@  @G@@G@\@G@G@33@
=@
@@@R@
=@Q@@ff@\)@Q@33@ff@
=@RA QA AAffARAAff@
=@Ap@{@\)@
@33@H@@p@@33@G@@
=@ff@R@
=@@z@H@\)@@ᙚ@  @  @
=@@@Q@@
=@@ᙚ@H@  @
=@
=@
=@RA33A (A  A   @\@=q@
=@{@\@@
@@
@z@@@  @
@\)@
=@33@33@
@陚@Q@@@
=@@@{@@=q@{@\)@H@=q@@
=@@33@@{@@33@=q@@@@@@{A zA=qA zAAzA  AzAQA\)A @
=AA   @=q@=q@Q@33@陚@
@z@{@p@=q@{@R@\)@@(@33@\@@@R@p@ff@@p@z@@@@@z@(@(@陚@@=q@
@p@
@@z@Q@(@@(@33@@G@@
=@
@p@@=q@Q@
=@
=@  @G@@@{@@@=q@\@=q@@\@@@@A@@@  @\@@
@@\)A Q@=q@\)@(@
=@p@@
=@@ff@=q@@@@(@@@ᙚ@ᙚ@@R@ff@z@@33@  @@H@@@ff@
=@@  @G@  @G@H@@R@@@R@
@Q@=q@@=q@Q@Q@@33@@\)@Q@@{@@@@H@(@G@
=@G@@@@(@H@33@{@@@@G@@33@{@  @Q@33@p@{@@G@@@=q@\@=q@@@(@
@@@{@@\@@H@
@@@@z@  @Q@@@@陚@@
@@ff@\)@(@33@\)@@߮@  @z@@أ@
=@@(@@@G@أ@  @\)@ff@p@H@ָR@G@@  @=q@G@33@33@@ff@R@@R@\)@  @@@G@@\@\@\@=q@H@@ff@H@G@{@{@
@\)@߮@@  @
=@@@(@ۅ@ڏ\@ٙ@G@G@أ@
=@أ@@
=@  @׮@
=@
=@ff@@{@{@{@@Q@(@H@@p@Ӆ@  @ff@\)@أ@(@ڏ\@أ@H@Q@
=@@{@ۅ@أ@ڏ\@@p@(@׮@ۅ@׮@
@H@Q@޸R@{@Q@(@@@@\@@@p@@z@@
@
@H@33@@@@Q@\)@Q@@(@
@@33@@@\)@ᙚ@\@=q@\)@ff@p@{@@z@@@ff@G@߮@@@\@H@G@(@=q@ᙚ@@@p@ff@ff@޸R@@33@ڏ\@ڏ\@@@G@ff@ff@=q@ۅ@H@ۅ@33@33@\)@Q@  @z@ᙚ@(@(@@@{@(@@@\)@\@@z@{@ff@@@=q@H@=q@p@(@@H@\@@@(@33@33@
@z@(@@ff@=q@R@Q@\@{@G@@\@=q@\)@@@G@߮@ff@33@ڏ\@33@
=@{@Q@
@G@Q@  @ָR@أ@G@  @@  @Q@ٙ@  @@Q@أ@ٙ@Q@z@(@@
=@@p@@{@ۅ@@
=@@@ۅ@ff@@33@33@ۅ@
@
@z@@z@(@33@H@(@(@z@@p@p@z@(@(@
@
=@\)@
=@
=@\)@޸R@ff@Q@߮@
=@p@ۅ@@@@ۅ@H@ə@  @33@@@ڏ\@(@33@@@@33@ۅ@@@@@z@(@(@ۅ@(@(@33@ۅ@33@33@ۅ@H@33@H@33@H@=q@@@H@H@(@(@ۅ@ۅ@@z@
@
@(@@@{@z@ۅ@p@@@p@{@@(@p@ff@\)@G@Q@ᙚ@@@@ᙚ@޸R@
=@@@@@@@Q@Q@@\)@ff@@{@߮@Q@  @޸R@p@z@(@
@(@@@{@{@@@33@p@{@{@{@{@@p@p@H@@Q@@@陚@  @\@@  @{@H@  @  @  @@{@
=@@@@p@(@z@z@Q@G@H@Q@p@߮@G@=q@@޸R@@@ۅ@z@أ@=q@ڏ\@ٙ@p@߮@33@\)@H@@޸R@G@@H@(@(@z@p@@{@@@G@Q@陚@\@\@@
@@{@
=@@@@@=q@H@33@33@H@33@@33@
@@@
@@H@33@@H@=q@@@R@R@ff@{@@  @ff@Q@{@{@ff@ff@@33@@
@ff@@Q@
@
@G@
=@
=@@߮@33@z@@z@
@33@@\@H@(@@\)@@H@
@H@\)@R@ff@G@@\@(@@@ff@
=@ff@\@@H@  @G@@@@@Q@@@@@@@@=q@=q@@  @33@\)@\)@@@@\@33@33@@@Q@@p@
@
@@@33@H@G@{@@33@޸R@޸R@@@@@z@H@p@@@R@@  @{@Q@
=@ff@H@
@
@@  @=q@{@p@H@߮@޸R@
=@ff@@@@@33@@@@@(@(@@@@  @=q@z@@@@ff@G@H@@@z@33@(@(@
@@G@@=q@@@@G@
=@Q@@@@@z@\)@
@pA (AA	GA@
=@@@z@@ff@@{@33@
=@@@G@\)@@@\)AAA (@ffA\@AH@\@(@@@@z@R@@\)@G@@@@@z@
=@R@
@33@R@Q@@@  @@  @G@G@@@G@@߮@ᙚ@\@
@{@
=@
=@\@@
@=q@
=@33@@
@@z@33@@@陚@
@{@@H@@  @pA
=@߮@@  @Q@(@@=q@R@R@  @
@=q@z@@  @Q@R@@@
@
@z@p@=q@@p@@G@\)@p@  @33@G@@=q@
=@@
=@p@ff@R@@@R@\@p@\)@{@{@G@(@@@=q@(@
@@H@Q@(@(@@@Q@H@ff@(@{@@H@@Q@
@33@Q@ff@@  @@@z@33@@߮@@ۅ@  @@@@
@H@@
=@G@\)@H@Q@@@{Ap@@@ff@G@z@@{@
=@H@(@H@  @@@Q@Q@\@(@\@(@ff@@R@@@z@33@Q@z@  @(@33@@@@  @\@\)@R@@H@ff@{@
@@=q@@\@R@  @=q@(@G@\@\)@@陚@@Q@G@@R@@G@(@z@
=@@@R@z@@@Q@  @
=@Q@@@ff@z@\)@@
=@
@\)@{@(@@޸R@@=q@
@@޸R@
=@޸R@
=@
=@@GApA
=A@@=qAHA Q@@@@@@@{@33@@
@z@@AA=qA QA zA=qA\)AzAAA(@AAA
A @@@\@33@
@33@R@AA@@
@ff@z@=q@{@\@@\)@@\@{@G@@33@@{@p@@@H@@Q@H@p@H@@@(@\)@Q@  @Q@Q@ff@R@p@
@\@33@@ff@R@ٙ@ڏ\@@@@
@@=q@@H@H@\)@=q@@ᙚ@ff@33@\)@Q@  @ָR@H@@(@Q@p@ᙚ@@߮@@H@p@
=@G@  @@\@=q@z@  @\)@G@@z@=q@Ӆ@@ᙚ@\@ff@33@p@Q@@@Q@
=@@@@Q@߮@H@أ@@p@  @@ۅ@H@
@  @{@@陚@H@\)@R@Q@G@  @@@\)@@@R@
@
@@
@\@@@33@\@
=@@\)@@@@\)@@{@@R@@@z@Q@ff@@R@Q@
=@(@z@Q@߮@\)@@(@H@33@H@H@@@@陚@@  @\)@(@R@  @G@33@G@{@p@@ff@ڏ\@@
=@@
=@Q@@@@@G@陚@=q@=q@33@@{@@@z@{@R@\)@@@\)@@陚@  @H@@ff@(@z@@z@ff@@Q@p@@Q@@@
=@=q@\)@\)@Q@Q@@\)@\)@@
=@
@\@@
@@R@  @R@R@{@\@(@z@@@(@z@\@p@ff@ff@ᙚ@\@ᙚ@{@@@@@  @@@@\@Q@\)@@ff@@@Q@@  @@@=q@=q@G@@H@33@@{@
=@p@{@{@Q@=q@  @p@\)@  @=q@@ff@@\@=q@
@z@
@@z@@陚@@@ᙚ@@ff@@@z@@@
=@z@p@
@@H@\@@@陚@\@@@@G@@\)@ff@Q@  @@Q@@  @@(@@@z@\@@33@{@@
=@  @@G@@@\)@\)@\)@R@G@H@33@@@33@
@@@Q@  @  @R@@{@@=q@\)@33@@
=@
=@  @R@z@R@@Q@z@
=@@@@@
=@@  @
@@
@(@G@(@@Q@@@z@@Q@@\)@{@R@{@p@@@@  @p@G@
=@@{@Q@ff@=q@  @@{@(@@ᙚ@z@
@@  @߮@\)@\)@޸R@{@@
=@@(@z@@޸R@޸R@޸R@ff@ff@޸R@޸R@޸R@޸R@\)@  @߮@߮@@޸R@ۅ@ۅ@ڏ\@
@@(@ۅ@ۅ@(@(@
@(@33@޸R@޸R@Q@@ۅ@G@@=q@(@p@=q@p@
=@@ٙ@ٙ@@=q@ڏ\@
@z@
@z@(@ۅ@@
@33@@@z@@=q@أ@׮@
=@{@ff@  @  @@
=@׮@{@z@ָR@  @G@ٙ@G@@33@أ@أ@@ָR@ָR@ff@  @G@أ@@ڏ\@33@@@@@p@@@@@p@@ff@{@{@@@z@(@@@
=@@=q@
@z@Q@\@߮@=q@@  @@=q@@G@ᙚ@@  @  @@޸R@G@  @޸R@ff@p@33@@ۅ@ڏ\@H@H@H@H@H@ۅ@
@(@z@z@@(@z@(@H@  @=q@ڏ\@@أ@@\)@@@ٙ@ڏ\@p@߮@ۅ@{@@@33@  @=q@أ@  @
=@׮@@G@(@H@33@H@ڏ\@=q@=q@@p@p@@@@@@@@{@@@(@
@33@\)@@@{@@ff@ff@
=@\)@\)@@޸R@߮@G@H@\@=q@=q@@@  @
=@@Q@@޸R@@
@(@@{@p@z@z@
@
@ۅ@
@z@(@(@@p@@z@ۅ@
@@z@
@ۅ@z@\)@  @{@@@Q@@G@@\)@H@ڏ\@H@ڏ\@ۅ@ۅ@ۅ@
@@p@@@{@ff@
=@߮@  @  @@@@@@@@޸R@Q@Q@H@33@@\@\@@ᙚ@G@@ᙚ@  @@Q@߮@@߮@@=q@@
@  @33@H@@@@@Q@  @߮@Q@޸R@޸R@\)@޸R@{@@p@@@@z@@(@@(@@@@z@@@p@\)@޸R@  @
=@߮@\)@  @@ff@
@33@{@@Q@  @\@\@@\@H@
@
=@߮@@G@ᙚ@@
=@Q@
=@
=@
=@
=@\)@
=@߮@\)@\)@޸R@޸R@{@{@ff@ff@޸R@߮@
=@{@@\)@  @\)@  @@߮@@Q@  @  @ff@Q@@\)@@{@@  @@@@@
=@p@@ff@{@  @H@@@@޸R@Q@(@@  @ff@
@p@\)@
=@p@p@@\)@
=@Q@  @ᙚ@@ᙚ@@p@z@@R@z@\@@z@
=@޸R@߮@@ff@
=@
=@\)@@@ᙚ@@H@@G@z@@
@(@33@
@33@=q@@@@@\@@Q@  @@  @߮@߮@
=@߮@߮@@
@H@=q@ᙚ@  @Q@  @ᙚ@Q@@
=@@
=@ff@ff@@ff@޸R@߮@33@  @@ᙚ@Q@G@@G@H@{@G@@
=@޸R@@@@p@\)@@@  @\)@@@@Q@Q@@޸R@޸R@Q@@  @ᙚ@
@@(@(@@p@{@@ff@{@@
=@  @  @  @Q@@@=q@H@@G@@
=@  @Q@@@{@@
@Q@Q@@H@@p@R@@ff@p@@@p@@z@
@
@(@(@
@R@@z@@\)@R@@z@@33@@Q@@\@Q@߮@@\)@@@@߮@Q@@G@@@=q@@ᙚ@H@33@H@33@@陚@  @ff@z@H@33@
@33@33@33@@33@@@p@@G@陚@G@@G@@
=@
=@R@R@@@p@@p@ff@{@{@ff@G@\@=q@  @@
@33@z@\@G@H@@ff@R@ff@G@\@@G@  @R@@R@@G@@@G@G@@@\)@ff@
@ff@p@@z@ff@@@33@H@@(@z@@@@{@@@@33@=q@{@߮@@@@@=q@\@H@33@@
@(@z@@@@@@p@@{@R@\)@@@@G@G@@Q@@{@陚@@@H@@\)@\)@@\)@
=@R@R@
=@@@=q@\)@@
=@@(@@@@(@@z@{@@@
=@@@@  @  @@  @@  @\)@H@@@陚@H@陚@@  @@@Q@
=@{@p@ff@@G@z@H@@\)@  @ff@@z@33@H@
@z@p@ff@\)@  @@陚@=q@\@33@33@
@
@(@(@@@
@(@
@z@ff@@@z@@@p@@@33@H@@=q@=q@@陚@陚@Q@@陚@@
=@
=@p@p@\)@@@@\@@p@33@߮@\@@p@@@@R@{@p@\)@Q@Q@@{@@G@=q@(@H@H@
=@(@
@ᙚ@@@@{@@p@@@(@@
@H@\@=q@=q@33@@(@@z@H@H@p@ff@R@
=@\)@Q@@=q@G@\@33@=q@H@@G@@@
=@@@@@@@
@@z@@\)@ff@{@ff@\)@
=@G@  @@@(@@Q@=q@ff@
=@
=@ff@@ff@@(@@{@@p@@z@33@@Q@\)@@G@Q@\)@\)@
=@  @=q@\)@\@ff@G@陚@(@H@G@p@@@H@(@H@{@
=@
@\@H@z@Q@@{@33@G@33@@{@\)@\)@@@
=@陚@p@\@
@@\)@@33@@G@@@\@(@
@@ᙚ@ff@p@p@ff@ff@ff@@@޸R@@@p@ff@ff@Q@
=@p@@  @ڏ\@G@ff@p@@
=@@Ӆ@(@@Ӆ@  @@\)A33@׮@ڏ\@@(@@ٙ@@p@޸R@  @\)@
=@{@p@H@@Q@G@@@
@@@@z@@@p@@@{@
=@\)@
=@\)@  @
=@  @\)@ff@ff@Q@
=@@ff@޸R@@@@@@(@ۅ@(@@H@=q@ڏ\@H@ۅ@ۅ@(@33@ۅ@
@ۅ@
@
@ۅ@
@33@
@
@
@ۅ@33@33@
@(@ۅ@p@Q@ָR@p@@@@{@  @ٙ@(@@@{@޸R@ff@@p@p@p@@p@p@@{@{@@@@@p@p@{@ff@ff@޸R@߮@  @@ᙚ@@@
@(@@H@33@H@=q@@@ᙚ@G@@(@߮@  @@
=@
=@޸R@ff@@@ff@޸R@\)@
=@ff@{@@p@p@z@
@
@(@@(@@(@@ff@{@{@p@@@z@
@ڏ\@ڏ\@=q@  @@@ff@H@ff@߮@\)@ff@ff@ff@޸R@ff@@p@ff@ff@{@{@{@ff@޸R@
=@ff@@p@p@@@p@p@@{@
=@޸R@
=@\)@
=@޸R@޸R@޸R@޸R@ff@ff@{@޸R@{@{@@p@p@@p@ff@ff@ff@ff@ff@
=@
=@
=@
=@\)@\)@@@z@z@@33@@ff@޸R@ff@{@{@@p@@@p@p@p@@@@@@z@z@33@ۅ@ۅ@H@ڏ\@=q@H@=q@G@Q@(@@@z@ڏ\@(@
@@ۅ@@
=@\)@  @@\)@@{@
=@
=@\)@ff@޸R@  @  @Q@G@  @  @
=@
=@\)@=q@Q@߮@G@@
=@G@Q@@@
=@Q@G@@@@@Q@\)@@G@@@@Q@Q@@G@  @Q@߮@Q@  @߮@Q@  @@Q@Q@G@@  @@ff@\)@p@޸R@z@@
@p@z@H@ٙ@ٙ@@\)@z@
=@G@Q@@@@ڏ\@
@@z@@
@
@
@H@@@=q@@@ڏ\@@Q@@G@@@\)@G@\@\@H@H@H@H@\@ᙚ@@@@@ᙚ@=q@G@@@ᙚ@ᙚ@@G@G@@@ᙚ@@  @Q@޸R@  @Q@߮@\)@  @\)@߮@޸R@p@޸R@{@{@޸R@ff@޸R@33@ff@\)@\)@\)@
=@
=@Q@߮@
=@޸R@߮@\)@  @\)@p@ff@33@{@(@H@@
@߮@ff@޸R@
=@޸R@@@@{@{@@{@@@{@޸R@޸R@޸R@޸R@\)@\)@޸R@޸R@{@@{@
=@\)@{@p@
@޸R@޸R@@ff@  @ff@p@@z@z@(@ڏ\@H@ۅ@ۅ@H@33@ڏ\@ڏ\@=q@H@ڏ\@أ@Q@G@=q@
@
@@z@(@
@ۅ@33@33@=q@@@@@׮@ָR@ff@ff@׮@
=@ff@׮@ָR@׮@@Ӆ@33@\)@
=@ָR@@أ@Q@G@Q@׮@أ@@׮@=q@ۅ@ff@@p@  @
=@ff@{@{@޸R@޸R@޸R@޸R@ff@Q@@\@H@\@@߮@@=q@(@\@@ᙚ@
@
@33@33@@Q@=q@=q@@@@G@@@Q@@@@@@=q@@=q@@ᙚ@z@=q@G@Q@\@33@
@\@\@=q@@@G@ᙚ@(@@33@H@H@\@
@33@33@33@\@ᙚ@@\)@޸R@p@ff@޸R@
=@\)@  @@Q@\)@
=@@Q@@\)@ff@ᙚ@=q@@33@H@@\)@Q@ff@H@\@@G@G@@\@H@@@@p@p@@@(@z@@
@\@33@@\)@=q@@
@
@@@z@=q@@=q@@ᙚ@@Q@  @޸R@H@=q@=q@@@@=q@G@G@߮@
=@Q@Q@ff@G@@=q@@@޸R@Q@@{@G@Q@\)@p@@z@@z@
@ۅ@@@@@p@@z@33@@{@ff@@@\)@G@@=q@@{@G@
=@=q@߮@H@@(@z@(@33@z@@\@33@z@ff@
@@(@@@R@ff@@33@33@@R@=q@\@@R@\)@@@z@{@Q@
=@
@@(@33@@z@
@@@H@G@33@Q@@@Q@޸R@(@z@@(@@
@\@@Q@  @޸R@@p@ۅ@(@(@ۅ@=q@@@
@\)@@@@@H@=q@@ᙚ@@@@G@ᙚ@@@@@޸R@\@Q@33@@@H@
@@@@H@H@@(@@@z@p@(@@33@
@(@z@p@@p@
@z@@
@G@=q@  @  @  @H@  @@\@\@߮@=q@@  @\)@
=@\)@\)@@@Q@@@@@޸R@@@p@p@{@p@{@޸R@޸R@@p@z@{@ff@ff@
=@߮@߮@\@
@=q@\@=q@z@=q@@@Q@@  @  @@
=@H@ff@  @=q@=q@
@Q@߮@p@@@(@@33@
@(@z@33@z@H@߮@Q@Q@޸R@
@G@@\)@@@@
=@G@
=@ff@33@@=q@@@߮@\@  @@
@
=@Q@{@陚@@{@p@\)@G@G@@@H@H@@z@=q@G@Q@@@ff@\)@G@  @Q@߮@@{@@\)@
=@@@H@33@@ᙚ@@
@G@\)@ff@{@(@ff@{@\@@
=@@@=q@\@{@@\@
@=q@{@=q@
=@Q@\)@A\)AAAAA
=A
RAHA
RA
ffA	A33A{AAA33AAA(AA\)AAA
=A\A\)AAzAQAA(A(AAA
{A	GA
ffA	A
\AAffA  A{AAzAA=qA{AA
=A  A(AHA33A=qAAHA
=ApAA
=A  AH@{@{A @@p@z@{@@RA @ff@z@z@H@(@\)@@@\@A (A Q@\@@
@
@ff@R@@
=@ff@@G@Q@\@A   @
A @\)@@33@@@@@@@\)@\)@G@陚@z@{@(@@p@
=@=q@=q@@@G@  @33@Q@=q@@@@HA QA{A  A zApARARA
AAApA33A33AA
=A  A  A\)AA\)AffAAzAA\A{AA(AA
    A(AAAA	pAAApA\)AARA{A AG@ffA QAHA@@pA A z@RA z@33@
=@z@R@\@ff@
@@HA QAAA @
=@=q@GA   AAARA\)AAQA
H@ff@pAA@R@A (AA33AA\AQAzA33A	AAQAA
=AAzAAAAAA\A{AzAzAA(A\)A
A
GAA
A\AAHA(AA(A(A
=AA=qAA=qAffAA33AAARA{A
AApA(A  A  AAzA33A
=A A"{A!A{A33AA33AAAAA
=A\)AA
A=qAA33AQAHAAApA33AQA
GA
HA{A
\AHAffA	A\)AffAQA{AAA z@Q@@p@{@HA A AzA A(A A (A (A=qA  A@\)ARA{@@@(A{AA{AAA@AffA(AffAffA   @pA @Q@ff@ffAGA=qAffAGAHAA A A Q@@G@z@AHA@{A   @\)AAQA@A A
=A\A
A\)@pA   A@AG@A@@H@(@
@@A (A (AAAGA zA\)A=qAA (A AGA @(@@p@@G@@@H@33@\@@
=@H@
=@33@
=@=q@=q@{@@@\@(@@R@ff@p@H@H@G@G@R@@(@33@@
@
=@(@(@p@@@@ff@=q@ff@@@@H@{@@{@@z@\@(@@p@@G@@
@@
=@(@\)@(@(@ff@=q@H@=q@=q@  @\)@R@@\)@=q@33A @{@Q@@@\@@R@\)@p@G@Q@
=@Q@\)@p@z@@@\)@  @@{@33@@
=@R@\)@@@\)@H@@@@
=@R@@\)@@H@@@ff@z@R@G@\@@G@@@@=q@@\@G@@Q@(@=q@
@
=@z@
=@z@@\@z@
=@R@p@R@ff@\)@H@\@HAA@H@p@@
=@H@  @p@Q@
=@@
=@@@\)@z@{@@@Q@@ff@@\@\@
@
=@@@33@@@  @@@@
@@\@33@@\)@ff@p@\@@@
@R@\@@\@33@  @@G@{@@@R@@@R@Q@(@@\@@H@@Q@{@@  @Q@=q@H@=q@@Q@@{@p@33@33@33A@ff@\@\)@=q@
=@Q@
=@\)@@G@陚@@{@Q@@{@Q@H@@@
@33@@G@H@33@
@@@\)A   A (AA zA   @33@33@\@@@\@(@33@@=q@@@
=@z@p@{@@G@@
=@Q@@@@R@@@
=@R@  @R@\)@@z@\)@@G@@@=q@@
@p@R@@@=q@\)@
=@@G@
=@
@33@
=@{@{@@
=@G@\)@@@p@  @@
@(@p@{@@ff@H@@@@@@@G@@@@H@\)@G@@QA   @@@33@@@@
=@\)@
@\)A (@@\)@G@ff@p@
@@Q@\)@@\)@@@
=@{@  @@{@@  @@R@@@@@p@@p@p@p@
=@R@=q@@@\@@@(@H@@Q@
=@\)@@@G@陚@{@
=@G@{@p@@z@@33@@p@@{@R@
=@@@@@@=q@@@@33@\@@33@A
=A
A\@\)@
@@
=@  A\AA  ARA @G@
=@\)@QA@RA A AA A (@ff@p@@A Q@\@
@@33@33@\@G@@R@
=@  @@@p@@G@@G@\)@@GA z@@R@(@\@
@p@
@@@(BffBffBffBBBffBffBڙBffBffBffBffB  BڙB  BB  BљBBB  BҙB33BffB  BBffB33BBۙBffBBBffB33BBffB  BffB33BЙBB33B  BffB̙BBffB˙BffB̙BBB33BB33BBffBBB  BBffBffBffBffBBBBffBBBffBffBB  BBB  B33BBffB  BəBǙB  BƙBϙBffBBB33BffBffBЙB33B33B33BљB  BЙB33BBB33B33BffB33B33B  B33B  BBB33B͙B  BBϙB33B33B  BәBBBBșB̙B33B  B33BffBəB33BʙBʙBʙB33BΙB33B  BffBBB33BffB33B  BBffB  B  B  BffB33BffBB  BBəBșBB  BƙBƙB  BəBBffBffBBffBʙB  BffBffB  B  BffB33B33BəBʙB  BB  B͙BffBΙB33B  B  BffB  BB  BԙB33BBBBffBBffB  BљBBљBҙBҙB  BϙB  BЙBffB  B  BBffB  B  BB˙B̙BffB  B33BBB33B33B33B33B͙B͙B͙B  B  BffBB  B͙B͙BB  B  B  BB33B33B33B33BffBffBffBB33BB  BffB  BB33BffBffBffBffBЙBЙB͙B33BB  B̙B  B33BBB  BԙB  B33BffBBיB33B33B  BљB  BffBBBffB  BffBffBԙB33BљBffB33B  B  BB  B33BBBffBB  B  B  BBB33BB33BffBBBҙBϙB33BffBffB33BB  B33BBffB33B33BBBBB  B33BffB33B33B33BBBffB33B˙B˙B  BffB33B  BיBљBB33B33B33BffB33B33BB33B  BffBB  B  BffBffBBᙚB33BBffBB㙚BBffBBݙBBB33BϙB33BBffB33B33BffBΙBB  B33BffBBՙB  BffBffB  B  B  B˙B˙BB33BBffB̙BؙB͙B33B͙BffB33BB  B33B  BBffB  B  B  B33B33BffBBᙚB  B33B33BffBBݙB  B  B  BݙB  BܙBљB33B33B  BЙBffBB  BBB˙B  BʙBffB33BəBBffBffBffBffB33BffB33BBffB33BəB33B  B33BיBB  BB  BffBBԙBBљBffBffBBљBBffB33B33BיBffBffBBffB  B33B  BBϙBffB  BffBffBB  B  B  BBBffB  BffB  BBۙBBBBBޙBffB33B33BݙB33B33B  BBffBB虚B33B  B  BBBffB  B33BᙚBBffB33B33BBffBffBՙB33BߙB33BffBB33B  BBffB33B33BBBffBffB33BҙBљB  BBBffB  BΙBB33B  BffBBљB33B  BBЙB33B  B  BB33B  B  B̙B˙BffB  B33BB33B33BBffBЙBffB33B33B  B33B33B  BffBݙB  BffBBיBۙBܙB33BffBffB㙚BBffBBffBҙB33BffBBffBBϙB33BffBBffB  B33B33B33B  B33B˙B  B  BffBB  BBBB33BB33BffBٙBBB  BٙBBBBffBؙBffBB  B33BBBBۙBB͙BڙBܙBٙB֙BҙBffBffBBB  BffBיBffB  B33B  BBәB33BљBffBffBffBBϙBBffB33BיB33BڙBffB  BBۙBBۙBBffB33BffBٙB33B33BffBBBݙB  B  BBffBיBffBڙBffB33BBffB  B  BBffB  BffB  B33BǙBBBęBÙBBBB33BffBBÙB  BB33BB33BB  BƙBBəBəB33BffB˙B  B  BB  BBB33B  BB  B  BϙB  BffB  BΙBB̙BBBBB33B  BșBǙBBffBB33BffBBffBffBffBÙB33BffBBB33BffBBffBffBB  BB  BffBffBB33B33BBB33B  BB  B  BęBBffBÙBffBffB  BęB33BBÙBBffB  B  BBffBffBB  BƙB33B  BB33BəBffBBșB33B  B  B33BffBșB  BșBffBffB33B33BffBffB  B33B̙B˙BffB  B33B33BffBǙBB33B  B33B33B  B33BffB33B  BffB  BB  BB̙B˙BBșBəBffB  B33BƙB33BffB  B33BffBęBffBÙB  BBffBB  B33B33BBęBęBB33BǙB33BBB  B33B  B33BBșB  BffBəB33BffBBBʙB˙B  BffB33BB  B33B  B33B  BffB  BffBʙBB33B  B33B  B33BffBffBB  B  B˙BB  BʙB  B˙BBffBffB33B33B  BffB  B33BBB33B  BB33BBB  BBffB33BBB  BffB33B33BęBÙB33BffBřBƙBB  B33BșB  BffBřB33BffBffB  BffBřBƙB33B  B  B  BǙBBB  BffBffBffB  BBBBffBffBffBffBffBʙBəBffBffBffBffB  B33BffB  BffBffBB  BffBffBșBșBffBBBffBBșB  B  B  B33B33BffBƙB33BƙB  BffB  BffBřB  BffBBęBęBBęBBBffBffB33BęBffBřB33B  BffB33B33B33B33B33BǙB  B  BffBffB  BffBB33BǙB  B33BffB33BBəBəB  B  BffB33BffB33BǙBffBffBəB  B  BB  BffB  B33B33B33B  BBffBBffB  BBBęBffBffBBęB33BffB  B  BBffBffBffBffBљB33BffBBΙBҙBҙBљBЙB̙BB  B  BBffBffB33BBBffB  B  BffBffB33BffBB33B33B  BffB  BffBęB33BęBB33BB33B33BffBBBBffBffB  BffB33BÙB33BB33B  B33B33BBffB  B  B  B  BBB̙B33BffBffBB33BBBЙBЙBBffBҙB  BffBҙBљBљB33BffB33B33BЙBffB33BBBBffB33B33BffBffB33B  BffBBЙBϙB33B  B  BљB33B  B33B  BffBffBffBffBΙB  B33B  B  BʙB  BffB  B33BffB  B33B˙B  BB33BBffBB˙B33BB  B  BʙB˙B  B33BB  B  B33BffBffB33B  BBBBffBB  BϙBљB33BB  BffBәBҙBffB  B  BffB  BBәBBffBՙBBיBffB33BיBffBՙBҙBәB33B  BffBBB33BϙB̙BffBșBffB33B  BʙBBʙBBB̙B  BBffBBffB33BϙBffB33BəB33B  BffBƙB33B33BB33BffBǙBB  B  BșB33B  BB˙B  B  B33BffBB̙B33B33B  BΙBB  BԙBffB33BffBԙBBffBՙB  BՙBՙBՙB  BǙBBffB33BB  BBffBffBBBBffB  BffBÙB33BB33BB33B  BffB  BB  BffB˙BB33BB33B33B33B33BBB33B˙B  BffB33BB33B33BƙBÙBffBBșBƙBBB33BffB  BffBffBřBffBffB33B33BffBęBBB33BBB  B  BB33BBÙB33B  BBB33B33B33BB33BB33BBBBBBffBBB33BęBffBB  B  B33BBB33B33BBffB  B  BBBffBffB  B33B  BffB33B  B33BB  BǙBřBǙB  BB33BB33B  BffBBffBəB  B  BBffBffB33B33B33B33B33BșBșB33B  BffBBBBǙBBBǙBřB  B  BffBB  BB  BBffBBffBB  B33BB  BffB  B33BffB  BęBÙBB33BBffBffBBffBffB  BBBffBB33BffBB  BffBB33BB33B33BB  BϙB33B33BBƙB  B33BBBəB33BffBB  B  BB33BffBffBB33B  BʙB  BʙB33BffBffB33B  BǙB  B  B33BșBʙBBǙBǙBffBffB  BƙBəB33B33BřBBBB33B  BBB  B33BBB33BffB  BB33BBBBB  BBƙBƙBffBƙBB  B  B  B33BffB  BffBB33BB  BBffB33B33B33BffBffB  B  B  BffBBB  BffB  BB33B33BҙB33BBљBB33BffB33BB33B  BBBʙB  B33BB̙BϙBϙB33B  BBBBљBЙBB33BffB  B33BffB  BBřBřBBBffBffB  BЙBǙB33BffB33BffB33BʙB33B33B33BBffB33BffBffB33BBBBffB33B  BB33BffBffBB33B  BBffBB33BBffBBffB33BBB  B33B  BffBffBffBBBBBffB33BffB  B  BB  B  BffB33BffBBffBBB  B33B33BffB33BffB33BB  B  BBB  BffB  B  BBBBffB  B  B  BB33B33BffB  B33BBffBBBBffBffB33BffBffBBB  B33B  BBBffBB  B33BffBffBffBřB  B  B33B  B  B33BBǙBƙB33B33BB  B  B33BffBřBB  B33BffBB33B  B33B33B  B  B33BB33BffBǙB33B  B33BffB  B33B  B33BB  BB  B33BǙBB33B33BffBffBęBęBffB33BBB  BBÙBÙBęBffBB33B33B  BBB  BffB33B33B  BffBBffB33BB͙BBΙBffB͙BffBΙB  BBЙBΙB  BffB̙B˙B˙BʙBBffB  BʙBBəBșBʙBffB  B  B33B  B33B  B33BBBffBșBșBffBffBșBřB33B  BB  B  B33BffB33BB33B33B33B  BBBB33BəBBʙB33BBșBffB  BəBBB33BffBB˙BB˙BffBffB  B  BffBB33B33BBB33B33BљB33B  B  BB  BffBәBBB33BB  BffBffB33BљB  B33BBffBBB33BBB  BffBffBϙB  BBBB  BB33BǙBBBB  BB  B  BB  B33BffBffBffB33BB33BBBffB̙B  BffB33B33BffB33B  BBB33BB33B  B  BffB  BB33BəBB  B̙B  B͙B33BΙB33B33BљBB33B33BљB33BљBҙB  B33B  BffBBffBЙBΙBBBBffBΙBffBBffBǙB33B  B33B  BəB33BffB33BBB33BB  BB  BB33B33B33BB  BB  BBffB33BB33BffB  BB33B͙BB  BffB33B  BΙBBBǙBřBřB33B  BÙBB  BBB33B  BffBB33BBffB  B  BBǙB  BBB33BB33BʙBB33B  BffB  BB  BǙBB  BřB33BBBBBffBBffBB33B33BBffB33B33BBBBB33BffBffBB  BƙBB33BřB  BBBBBffBBB33B33B  BƙBƙB  B33B33BBBBB  BBffBBffBffB  BB33BffBffB33BffBBBffBBffB33B  B33BBBBffB33B33BffB33BB33BəBffBəBBB33BffBffBffBffB  BffB33B33BǙBB33B33BƙBƙBffBB  BffBǙB  B  BffBǙBBffB33BBB  BffBBffBǙBffBffBBffBƙB33BBB  B  B33BB33BřBffB33BBB33B  BB  B  B  BÙBBffBffB  B  BB  B33B33B33B33B  BBÙBB  B  BB  B  BffBB  B33B  BęB  BB33B33BB  B33BffBffBB33B  B33B  B33B  B33BǙBǙB  BffBffB33B33B33BBBBəBəB33B  B33BffBǙB33B33BB33BBBffB33BB33BBffBffBBǙB  B33B33BB  B33B33B33B33B33B33B33B  B  B33BffBęB  BffBffBÙBB  B33BřBffBřB33B33B  B  BffBBffBB33B33B  BffBBffBřBB  BB33B  BəBB33B  B33BffBșBBșBffBffBșBșBBffBffB33BB33B  BBʙBffBBəB33B33BșBB33B  B33BBƙBB  BșBǙB  B33B  B33B33BffBǙBǙBǙBBffB  B  B33BBBǙB33BǙB33BǙBǙBB  B33B33BBBBffBșBffB33BB  B  B  BffB  B  BƙB33B  BffBB  B33B  B33BǙBffBBBffBǙBffBƙB33BBBřB  BƙB  BƙB  BƙB33BffB  BBBB  B33BșB  BəBB33BʙBffBBBBBffBffBffBęB33BB33BBB33BffBffB  B33BřB  BffBBffBǙBffBęB33B  BBǙBBƙBffBffBBBǙBffB33BffBffB  BǙBffBffBffBffB33BʙBBBBffB33B  BffBffBffB33B33B  B  B33B33BBB33BBʙBB  BffB  BB  BB  BffBəB  BșBffBffBffBșBffB33B  BșBffBffB33BffBʙB33BffBBffBǙBBffB33B  BǙBB33BffBB  BffB33B33BBB  B33BB33BBǙBƙBƙB33B33BffBBƙB  B  BBffBB33B33BffBřBǙBǙBffBffBBęBBBffBB33B  BffB  B  B  B33BB33BșBffB  B33B33BB33BffB33BʙB  BB  B33BB  B  B  BBʙBʙBʙBʙBBʙBB  B33B˙BffB˙BffBffB  B33B33BBəB33B  B33BffBB33BƙBffBffB33BB33BʙBBBəB33B33BřB33BBffBǙBBB  BB  B  BBB33BffBB  BʙBșBB33BffB33B  B  BBffB33BffBəBffBBəB33B33B  BffBffBffB33BBB͙BBBΙBΙB  BΙBΙB  B͙B͙B  B33BBB33BffB33B  BBffBffBB  BBBƙB33BffBffBffBșB  BƙBffBřB33BB  B  BffBřB  BBffB33BffBęB  B33BBffBBřBřBffB  B33B  BBęB  B33B33BřBřB33B  BǙBǙBșB33BffBBffBffB  B  BB  B33BffBʙBB  B33B˙B  B  B33BffB  B33B33B͙BBB  B͙BB͙BffB33B  B  B  BffB33BșBșB33BșBBșB33B33BƙBB33BęBffBBffBƙB33B  BƙB  BB33BBffBffBffB33BffB33BffB33BB33BƙBřB  BřB  B33BffB33BffB33B33B  B  BęB33B33B  B33BffBBęB  BÙB  B  BřB33BʙB  B33BʙBffBB33B  BʙB˙B33BBffBB33BB33BBB  B33BBϙBϙBϙBB  BffBB͙B  B33BffBffBB̙B33B33B˙B33B33BffB˙B  BffB˙B̙BșB33BffB  BBBBƙBBřB  BffBffB33BřB33BǙBșB  BBəBBǙBBffB  BșB  BəB33BffB  B33B  BBəB  BƙBffBffB  BffB33B33BffBBʙB˙BffBffB  B̙B  B33BΙB33B  B33BffBffBBffBffB  B33BBffBәB  BffB  BәBffBffB  BBBBB  BffBљBffBЙBЙBBffB33BBffBҙB  BЙB  BљBЙB  B  B  B  BBffB  BљB33B33B  BB  BffB˙B33BBBffB33B  BffB  BB33B  B33BB  B  B33B  B  BșBBffBffBffBB  BffBffB33B  BB  BffB  B  B  BffBәBffB  B  B  BffB33BffBؙBٙB33BB33BҙBBB33BƙB  BəBÙBBffBBB33BҙBәBffB  BffBșBBffBB  B33BƙB  B  BƙBBffB33B33BB  BBB33BB33B33BBBƙBffBBffB  B33B  BBB  B33B33B  BffB33B33B33B  BffBffBffBBBǙBƙB33B33B33BƙBBffB33B33BffB  BffB33B  B  B  BB33B  B  B  B  B  BffB33BffB33BBffB  BəBffB  BșB  BBșBB33B  BffBB33BǙBǙB  B  BffBB  B33B  B33B33BB33BǙBffB33BffBǙBB33BBBffBBÙBB33BBB33BBffBffB33BB  B  BB33BǙB  B  BșBB  B33BəB  B33B33BffBffBffBffBffBB33B33B˙B33BffB͙BffB͙BffBBΙB33B  B33BB33B  B  B˙BffBBBffB˙B  BffBʙBB  BffB33BB  BBBffBBffBBǙBffB  BƙBB33B33BffBBBʙBffBəBəB33BffBffBB  BƙBBÙB  BffBBffB33BffB33B  BBșB33BșBBƙBBB33B33BffB33B  BBʙB33B  B33BBffB33B33B33B33BffB33B33B  BBffBəB33BəBəBəBffBBffBəBffB33B33B  B33B  BffB33B33B  BBșBșB  BffBffB  B  BBƙB  BffBB  BffB33B33BffBffBffB  B33BB  BffB33B33B  B33BƙBffBffBffBBB33B33B  BřB33BBB33BBBBBffB33BÙBffBB33B33B33B33BffB  B33B  BBffBffBřBǙBffBșBffBǙBǙBffB33BǙB33B33B  B  B  BffB  BB33BffB33B  B33BșBșBffBBffBffBffB33BffBBBșBffB33B33BB33BșBəB33BBəBB33BəB33BʙB33BBB  B  B  BffB  B  BBBffB  BffB  B33BBBBBBBffBB  B  B33BffBBffBffBffB  B33B33B  B  BffBffBffB  B  B33B  B  B33B33B33B33BB33BșBșBBBșBșBșB  B33B33BB33B  BBBffBBBBffBBřB33BBB  B33B33BǙBƙB  BffB  BƙBffBBB  BBƙB  BffBƙB  BB33BffB33B33B33BBęBęBęBęB33B  BÙBffBffBBB  BffB33BBBęBBffBffBęBffB33BęB33B33B  BffB33BřBB33BBBBffBffBffB  BƙBBBffB33BffBffB33BB  BffB  B  B33BffBBÙBBB  B  BřBřBffB  BffBBB  BBBęB  B33B  BBffBřBB33B33BBęBÙB  B33BB33BBBB33BB33BB  B33BffB  BffBB  BBffBffBBB33B  BBBffBBęB  BęB33BffB  B  B  B33BffB33BffBffB33B33BƙB33BBșB33BBffB33B33BBʙBBʙBBșBBBffBBB  BǙBǙBB33B  B33BəBffB  B  BșBffB33B  BBffBB33BǙBƙB33B33B  B  BęBffBřBșBǙBBBřBB  BƙBBǙBB33BffB  BffB33B33B33B33BBÙBffBÙBB  B33BÙBBƙBffB  B  B33BBBBBəBB33BffB  BřBffBřBffBffBƙB33BșB  B  BəBəBffB  BəBBBB  B  BBffBffBʙB33B  BffBʙBBBʙB  B  B  B  B33BřBffBffB  BffBƙB33B33BǙBBBəBBffBșBffBșBBBffBǙBB  B  BBƙB33B33BřB33B  BƙBęBBffBffBřBřB33BB33BBffBB  BBBǙB33BșB33BBffBƙBƙBƙBffB  B33BəB33BBBffB33BșBB33BffBffB  B  B̙B͙B  B33B33BffBffB33B33B33BBffB͙B˙BffBB33BǙBřBffBffBB  B33BffB33BʙBBəB  BffB  BffBƙB33B33BB33BʙBB  B˙B  B33BB33BBffB  BffB33BffBBBBB33BffBǙB33BBBffBșB33B  BffBffB  BǙBșBBffB  B  BB33BřBffB33BffBBřB33B  BffBffB33BffBBBB33B  B33BffBBffBffB  BBBəB33B33BBffBəBBșBffB33B  BǙBǙB  BffB33BBffBƙBƙBffBB33B33BB33BƙBB33BffB  BB33B  B33BffB  B33BBffBBB33B33B33B  BffBB  BÙBB33BřB  B  B33B  BffB  B33BffBřB  BffBffBřB  BffBffBB  BffB  B  BƙBBÙBffB33B  B33BffBęBffBřBB33B  BB33BƙBB33B  B33BƙBffBffBB  BBB33BffBƙBB33BB33BBƙBB33B  BffB33B  B  BffB33B33B  B  BffB  BəBffBșBffB33BəB  B33BffBffBffB  BəB33BƙBșB  B  BǙB  BffB  B  BB  BffB  B33B33B  B33BșBƙBBBƙBǙB  B  B33BffB33BƙBǙBBffB33B33BffB  BؙBיB  BBffBܙBffB  B33BffBB33BؙB  B33BB33BffBffBBBޙBߙBBffBBffB  B  B  BffBB33BۙBffBڙBٙB  B33B33B33B  BB  B  BҙBљB33B33BBBffBBBBҙBBҙBәBffBB33BBB33B͙B  BffBϙB33B  BЙBffB  BffB̙BBʙB33B  B33BffB  BffBBBffBffBffBffBʙB33BęBBB  BB33B  BəBffBB33BBffB33B33B  BffB33BffBBB33B33BșBBęBffBBffBșBffB  B  BЙBΙB33B͙BffBBffBffBffBB  BЙB33B33BffBB33BB  B  B  B  B  BҙB33BљB33BBљBffB  BԙB33B33BBffBB33    B  B33B33BB33BיBҙBffBBBffB  B33B33BffBBffBBBffBΙB33BʙBϙB  B͙B  B33B  B33BffBffB  BffBffBB33B  BffBBBB33BҙB33B  B  B33B33BB  BBffBBB33BܙB33B  BffB33BffBffBܙBBffBffBB噚B♚BffBBffB䙚BB33B33B  BffBBffBBBffBffBݙB33BޙB33B  BᙚB33B  B噚B噚B33B33B  B33BBffB33B  B33BB㙚BffBffB㙚BB  B癚BB  B33B  BB  B晚B33BB33BB33B  B33BffBffBݙB33B33B33BᙚBBB33BBffB  BؙB  B33BffBBB  B33B33BB  BBBBҙBB33B33B  BԙBԙBBB֙BB33B  BҙB  BffBҙBԙB  B33BԙBԙB  BؙB33B33BיBՙBԙB33BיB  BՙB33B  BffBffBҙBffB33BffBB֙BיB  B  BԙB  B33BffB33BϙB33BԙBΙBϙBBәBՙB33BffBffB33BB  B  BәB  B33BffBB  B  B33BәBffB33BәB  B  BҙB  B33B  BљBffBҙBBffB  BԙB  B33B  BffBB  BBffB33B33BffBB33B33BB̙B33BBBffB  BffB͙BΙB  BΙBBΙB̙BBffB  B  B33BB  B  B̙B  BffBB  BffBB  BљB  BBBffBffB  B  BBșBffBəB33BB  B33BffBB33B  B  BffB  BffB33B33B  B  BB˙B  BʙBřB33B  BffBB͙B33BffBB33BÙB  BB  BffBffBϙB  B  BffB33BB  B  BffBBBBBΙBљBљB  B  BB33B  BB͙B  B  B33B  BΙB  BffB  B33B33B  B33BffB33B  B33B  B33BffBșB33B33B33B  BffBB  BB33BffBB  BffB33B33BffBffBBBBB̙B33B  B33B33B33B33B˙BB33B̙B  B  BB  B33BB  BffBffBffB33BB33BB33BffB33B33BB33B33BЙBљB  B33BffBffBB33BffBffB33B33B  BʙBBəBBșBB  BB33BΙBBffBЙBffBB˙BBffB  BffBʙB33BB33BB  B  B˙BBffB  BffBBffB  BffB33B33BəB33B33BffBffBΙBffB33BBffB  B33BBBBBB33BB  BBBʙBffBBBffBffBBffB͙B33BffB  BB33BffBBffB  BB33BffBffB  B33B͙B33B33B33B33BffB33B33B  BB33BffBBB33B33B33B͙B33BBffB  BBBB33BΙBffBffBЙB͙BB33B  B  BљBљBљBffBffB  BffBBB33B33B˙B33BffBBffBffB33B33B33B˙BffB33BBffBÙB33BffBBffBBffBffB  BffBB33BÙBǙB33BBffB  B  BffBBșB33B33BffBBBϙBffBB33BffBffBffBљB33BffBԙBBffBBЙBB  BΙBΙBB33B  BffBB͙B33B33BffB33B  B33B͙B  BΙBBffBB͙B͙B˙BffB  BBBB˙BffBBffB  B̙B33B33B͙B  BffBffBBBřB  BB33BǙB33B  BB33B33B  BÙB33BBřBBffB33BǙB  BffBB33B  BffB  BB  BffB  BB  B33BBffBB33BϙBϙBЙBBBffBBBffBBffB33BffB33BffBffB  B˙B  BB33B33B̙B33B33B  BB  BǙB  B  B  B33BǙBffBBB33BffB33BB  B33BffB  B33BəBșBffB33BB  BB  y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y A33AŅAǅAA=qA
=AĸRApAA{AA
A=qAəA33ApAA33AîAÙAGAGAzAApAȏ\AffAA  ẠAAHA̸RẠAffAffA  A\)A33A33AƸRAĸRA=qAHAAA
=ApAQA\AA  A£AAAA33A(AǙAHAAAAHAȸRAzA33AAAffAGARA{A\)AApAffA{A(AÙA
A33AA{AA
=AGAÙAAHA£A  ApARAA£A\AApAHA33AzAffApAA
=A{AA
=A\AAHAAHARA{AAA  A  A33AAîAHAA=qAzAHAîAAÙAŮAffAAAƏ\AA\)ApAƸRAAHAQAzA(A  A\)A
A£ApAîAAA{A
AƏ\AA  A{AǮApAffApAAHAA\AGA\)ApAHA=qApAffA
AHAAQAQA\AGARAAGAAQAHA\)AGA
A=qAzAAGA\)AAA=qA=qA(A{A=qA  A  A(ApAAAA33A{A\)ARAA
=AîA  A¸RA(A{ARAAAQA(AQA{AQA(AģA£AA  A=qAA=qA=qAffAA
ARARAffA  ARAA33AA=qA\A{AQApAzARA
=AAQA33AHA  AA\)A33AQA
=AA\A\AQA\AGAA\A
=A
=AA
A(AAAAffAHAA\A=qA{A(AQAzAA\)ARAffAffA{AA(A\)A  AAApA
AAffAA  AA\)AAHAA=qAffA  AzA  A(AA
=AAAAAAA(AA
=A33AA33A33AAQARAARAHA\)AzAA{AHAA£AAGAQA
=AAAGApAApApAGAAAHA\)ApAAAAAHAzAApAffAzA=qAzAAAzAAA(A(A33A
=ApAffAA\)AģAď\A\)AAGAQAÅA(A=qA(A\A\)AHApA
A  A(A
=A\AA33AffAAAzAA  ARA=qARAzARAA
=AQAAQA{AA  AAGAARAA\)AAAzA33AffAÙAÅA{AAAzAzAAAAGA
=AƣA=qA(AƣA=qAffAřAAŮAAAřA
=A
AA=qA
AƣAAAƸRAffA  AĸRA\)AA\)A{AzA33AÙA
AA¸RAAAffAHAffAA\AAAAAzA\)AAQAA{AHAGA
=AAAAAAffAHAA=qAŮA
A
=AHA{AA\AA\AGA
A33ApAAAGAGAA
=AGApA
A(AffAģA£A
=AAzAAAǙAAǮA\)A{AA=qAƣAA
=A
A  AHAA=qA\)A33A\)AGAAAA\)AAA{A
A  AzAzA\AGAzAzAQA
=A\AAGA£A33AA33A(AA{AffAA\)AHAAQA  AApAQA¸RAzA\A\ApAffAAQA=qAA\A
ApA33AÅA\)AÙAAÙA
AģAGAHAA{AAřApAGAŮAŮAřAA  AA  A
A33AA
AŅA\)AŅAŅAA
AGAGAřAŮA\)AffAAĸRAGAzAA(AA¸RAGAGA(A
AAAHAAřAAA
AÅAGA  AHAŅAAzA
=AQAzAHA=qAzA{ApAĸRA
=AffA
=AffA
=ApA
=AzAHA=qAAAHA¸RAffAzA\A\A¸RAAA
=A
=AÅAÅAA
AAĸRA
=AA
=AApAffAǙAAƸRAGA33A  ApAffA¸RA
=AAģAA\)A(A{A(AffAAAQAzAzAAîAzAzA33AQAģAHAÅAAŮA=qAAŅApAAApA=qA\)AAffAGAzA=qAffA
=AHA
=AffAď\AģA
=AģA=qA=qA{AA=qAAAAA
=AAQA  A
=AAzA
=A\A¸RApAÅAAģAHA=qAŮA(AffAAzA33AzAQAffAffAģAŅAď\AŮAQA
=AHAîAģAAQAAAAGAA(A\)A(ARA
AffApA{A
=A=qApA
A¸RAA\)A=qAÅAQA
=AAGApA(AAAHAAffAzA
=AAAA\)AA\A\AAAQAÅA
=AAAHAffAď\A{A(AîA(A\)AAAzApAAA=qA(A33A33AÙA33AHAzAAAřA
AQAÅA33AApAzAAîA=qAHAHA33AÅAîA
AÅA¸RA33AA33AAAffA\AAzAffA(A33AQAApAGA(A\)AAAA(AAAA{A  AAAHAzA\A33A\A  AA¸RA\)A¸RAAA{A=qAď\AA=qA
=A=qAAď\AQAffA  AÅAřAffAHAřA{ApAGAA
=A
A\)Aď\AAHA=qAA\)A  AApA
AzAA  A
=AApA\)A
=AA(AQA\A\)A
=AAîAffA{A  AHAQA
A
=AAģAHAĸRA33AřAQAƸRAGAǅAAzAHAGA33AAȣA  AǅA
A
A  AǮA
AAAAAA
=A{AģAHAA  A=qAAHA
AAQAHAƏ\A{AƏ\AGAA
=AA
=AƸRAHAď\AŅAģAA(A33AGAÅA{AÙA33A
=A
=AzA33A\)A\A{A¸RAA£AA¸RA
=AGApAîAA  AĸRAA  A
AGAĸRAAŮA
A(AQApAA
A
AŮAA
=AGA
=AAAQAĸRA
A=qAAAÅA33AQA  AAAAAffA33AAA{AAAGA(A\A\)AQAA\A£A¸RAA{A(A
AffAƏ\AQAzAHAƸRAffA(AzA(A
AffAAAzAQA=qA  A{A{A  A(AŮAĸRAď\A\)AAď\AÙA=qAÅAQAŮAîApA
=A\AAQAAffA  AffARAA(A33ApAA=qAffA\)AA  A  A(A
=A
A
=ApAAAQAGA{AHAAzAAQAAffAA\AffA\A=qAAAAA
AAA  A{AQAQA  A{AA\)AApA\AAA
=A=qAAAA\AzAAApApAffAA  AA
AAAGApAA{A=qAAffAAAGAAGApApAAAGAA=qA{ApA
A  A33A33A
A=qA(A\)AHAAHA\)AAGA
=AAAAApAAAA33A33AGAA=qA(AA=qAAAAAGA\)A¸RAAAA33A33A\AGA33A  AAGAHAď\AĸRAGAHA(A33AÙA£AÙApAGAARA
AAÙAAÅAQA¸RAQA
=A£AA
AAģAGAîAHA=qAHAzA=qAÙAA\)AAA33AGA33A\AAAAA=qA{A  A=qA¸RAffAAzAAAÅAģAAGAAŮA33AA
=AAA\A33A=qAzA=qAffA
=AAǮApAǅAGAAzA=qAAQA  AA  AAAzA  AApAAffA
AA{AA\)A  ARAAHAAARAAGAAA
=AAHA\)A{A
AHAARAA\)AA33A  A
=AApA  AQARAAffAAHAA\AzARAA\A{A=qAAGAHA\)ARAQAQAffAAAQA(AA
AAA=qAHARARAHA\)AAAApAzAffAAA(AApA{AAARA(A=qAAQAARAQAAAA
A33A33AAAzAGA\A\)ARAA
=A\A(AAGAQAAAAA33A{A  AAzAA(AGAzA=qAAzA(AAA  ARA{AffA\AAApAA{AQA
=ARA{AffA=qAA=qAA\AAARAAAffAffARA  A
=A\AA
AGAA\A
AffA  AGA  A{ARAApA\)A
A=qA(AA(A
=AA  A33A
AQA{AAzAGAQAzA
A
=A(AApAA\AAAA33A\)AAzAAffA=qAA
=A(AzA
=AAA
=A
=A{A(AARAffA\A{ApAA
ApAffAA=qAAffA33A  AAGA\)AA{AA
=A{AAAzA{AAARAA  AA33AAA(A=qA\)AA(AAAAHAAA
A
A
=A
=A
=A33AGAAAA  AAAA  A(AAApAAQAHAA  AGA(A
=A
=ApAAAAA\)A
=AAAAffA  A\A(A
AAAHA(AA(ARApA=qA{AAAA(AAApA
=A
AAGAA\A=qA\AffAARA\AQA
=A{AffAA\AAAQAAA33AffAzA\)AA
=AAA=qAA{AAA{AAGA{A\)AAGAAGAA=qAAzA33AARAA
=AAGAHAGAQA
=AGA(AApAzAARARA
A\)A
AAffAzA\)AzAzA\ApAHAARAzAGAAA
=AAHAAAA
AA{AAA  AApA33ARAQAA33ApA\)AAAA  A
=ApAA
=A(AHA  A{AffA(AA33AA(AAAffA33AA\A\AA(A(A\)AAA
=AGA
=AffAQAzAHAAzAAffAAAGA
=ARA{AGA=qA(AHApAzA{AHA
=A\AAA\)AAffA
AQApApA
=AGA33A
=AAAARAAGAffAHAAApA\)AGA
A
=ARA(AAHA  AA33AzAAHAARA\)A
A=qAARAAzAAA(A  AAARAAA
=A(AAAAffAffAAAAA33A(A33AAAGAA
=AApAAffAHAGA=qAzAAAHA\AAzAA\)AzA
=AAAAzA{AffA  AApAAffAAA{AAA=qA=qA
A\)A  AAA{A{A
=AGAAzA{AffA\)A=qA¸RA
=AGA33ApAÅA\)A¸RAA33A\)AA=qA33AAzAģApAzAAA
AA33A33AAAĸRA
=A  A=qA  A{AGA\)A
=AA
=ARAAffA=qAA  AAAAA=qAffA\)A\ARA{AGAAAHA33AzA
=A
AAzA  AApAHAHA  AA=qAA\A\AARAzAzAAHARAAApA\AÙA(AffA\)AzAĸRAĸRAĸRAffA(AQA(AÅAHAA¸RA£A
=AQAffA\ApApA(AAA(A
=AA(A\)AAAGA(A¸RAffAAzA
=AffAApAAApAAAApAHApAA
=AffA\)AzAAffA¸RA\)AAffAApAA(AAAzAGA(AAGAA
AAAzA=qA33A\)AA{AHAA
AAAAHAGAǅA\)AǅA\)A\)ApAǮAǙA
ApAƏ\AzAzAzAƣAzA33A\)AGAA
=A\AApAAAAAA=qA=qA\)AAAAAAAA=qAAQAQAGAřAAA\)AĸRAGAHAAÅAApA  A(AÙA33AA  A£A\)A¸RApA\)AzA  AffAGAffAAHAÙA=qAAzAAA\)ARA  AffAA(A
=ApA  AffAApA
A(AffAzAGAGAA
=A33A33AAffA{AřA=qA(A{A(AƸRAAAGAHAǙAzAQA
A¸RAffAAA
=A
=AHA
=ApA33AA=qAîAAA33AAQAAAzAAÙA
A(AîA=qAÙAÙAAAA=qAA(AAHA£AQA£ApA
A\)AAzAAffAA=qA  AAzA{AffApAQAAAAAffA
=A
=ApA33ApA  A£AAď\A33AA  AƏ\AffAzAƏ\AA33AzAQA(A  A33AAřA(A
AA
=A33AAď\AģAď\AffAģAAģAď\AÅA33A\AApAffA=qA£AA\)AÅAzA{AAAQA
=AHA=qA
A{A(A
AÅAÙA
=AAAA£A(A{A{ApA\)AAzAAA=qAAAA=qARA
=A{AzA
AGApAAzAzAHApAAAHAÅA
AQAffAģAĸRAAAď\Aď\A
A£A  AAApApAGAAffAffA{AA(AHAAGApA£AA33AHAzAzAffA=qA{AAGApAGA{A\AA\)AA=qAA\AffA{A(A=qAA=qA£AffAAHAzAzA\A£AA£AA£A¸RAAzA  AQAAAQAGAAHAA33AHAzAA{AffA\)A33A33ApAA\AGA(A¸RAÙAîAÅAÅA  A\)A  AAQA  AAA
=AĸRA{AGAGAÅA\)AzAzA\AzAÙA{AffAîA(A
AÙAQA{A
A=qA  AQAffA  A
=AAGARA
=ApAffA\)A{AAGA
A(A\AAApAGAAA=qAA  A  A(AA(A=qAA(AGAQA\A33AGAA
AzAAA¸RAHARAAAGAzA
A=qAA
AzA  AAzAÅA  AApAGAAA=qApA{A{A=qAA=qA=qAzA  A
=AAAAAGAAzAQAHA  AGApAA  A
AAA\)AA  A  ARAHAzA{AA  AA{AffA\)AHAAAAzA
A\)AGA=qApA
=A=qA=qA\)ARAA(ApA33AARA{A\A
A{AGA\)AzAA\AAffAffA(AAQAAzA33AAA(A=qA=qAQAffAzA\AzAHA33A\)A
ARARAARARAA\A  A
A\A\AQA=qAffA=qA
=ApA(AffA\)AA¸RAHApAAzA\)A\A{AAHAAAA33AQApA(AffAHAHA33A{A(AA\AAA\A(A(AGAA
A\)A33A\AQAffAHAARA\)A33AzAffAAHA  A=qAAAAzAQAffA{A
A\AAHAAAAAA
=A(A  A33A
=A
=AGAA
A=qA(A{A{AA
A{A
AA=qAAAGAA  A{AzAAA\)AAAzAGAzAA\)AzAAA
AQAAAzAAA
=AA\ApAA=qAAffAA  A
A(AAA
=A{AAHA=qA
=ARAzA  AffAA
AHAffAApA{A\)ApAAA\)A\)AAHARAAzAA\AzA\AAA33A\)A\)AGA
=ARAzA{A
AA
AA
AA33A{A(AAA33A\AAQA{A{AA
=AffA  AA  AGA
AA33AAA\)AzAGAAA(AA(A(AA33AAA\AHAARAA=qA\)AffApARAApAAAAAA{AAAA33A33A  AAA33ApAAHAffA\)A(A=qA  A
=A=qAAAAApAAAAAApApApAA33AHA=qAQAQAARAA  AA
=AHAAApAA{A  A(A{A=qAffA(AzAQAzAAHAAAA=qA{ApA(AffA  AA
AA\)A
=A
AGAApAQAAAHA=qA{AA\AAAA33A{A33AA{AQA
=A{AAARAAffA\AffA33AzAA
=AQAAA\)AA  AQAffAffAffAQA{AAQA
=A33AAzAAQA(AAAAAAAAAAA33A\)AGAHApA{A
ApAAA{A  AAAzApAAA
A\AApARAAA
AGAAAA=qA\)A=qAGA=qAHAApAAA
=AA33AAzAA  A{AAffAffA33AAA
AGAApA=qAAAA=qApA{AA\)ARAAA  A{A(A\A\AQAA=qAffAffAAAQA33A\A(AA
AHAQA33A\AQAzAffA¸RAA£A£AffA(AAAGAzAAAAAAffAAAA  ARA
A
=AAA33A\AzApAAGAAzA  A
AAzA(AAApA
AA(AAAAHAAHApAA
AřAřAřAŅApAAA{A
A
AŮA\)AHA=qAîAAÙA33AHAAA(A
A33A
AHAď\A{Aď\AAAApAŮA=qAffAHAffA=qA(A\)AAģAffAď\AAď\Aď\AAď\AzAď\Aď\AģAĸRAĸRAffAîAA  AAA
AffA{A\)AApAAzAAQAffA33AAA=qAAHAGAÙAAQAffAĸRAHAHAď\AģAĸRAĸRAAģAĸRA
=AAAHA
=AAzAffA(AÙAÅA
=A
=A
=A=qA(AA  AAA{AA\A\)AÅA{AGA\)AA£AzApA\)A\)AGA¸RAAzA£A{ApA33A\)A=qA  A(A£A\)AQAffA  AQAGAÅAA
AAA
AAffAffA¸RA  AA=qAAHAGApA
=AAA\)AQAA
=AAQA¸RAA33AîAffAAGAAHA=qAQAAQA(A
ApA
=A£AA
AAAAAzA¸RA¸RA¸RA£A¸RA£AA¸RA¸RA\AA{AAA
AARAA  AAA\)AAAA
A  A
AzAffAAAAAAGApApApAA=qAffAzAQA
=AAzAA{AHAA
AA
ApAffA(AA\)AA(A
ApAAHA{AQAA
AAffApAzAGAGAffAGAQAzA
=A
=AA\)A
=A
=A\)A33A
=AAffAAffAA
=AGA
=A
=AAA  AAzAAAAAffA  A
AGAAA=qA  AGA(AA=qAAA  A(AGAA\)A
=AAA\AzA{A
=ARAA
A  A
=A{A(AA=qA\)A{AffAA(A=qAQAA(AAffAAA
=ARARA  A(AQAGAHAApAA33ApAA33AAAAA\)AAAA
=AAA33AAAAHA33A
=AAA
AApAAAA
A  A{AAffARA\ARAAHARAAAAzA\AHAAGApA\)AAARA
=A\A(AGA  AAAAQAzAApAGAAARAAA33ApA33A(AAGA  AA
=AA
=AAA(AGA\AzAAHA33AAGAA
=AAffAARAHAA
=AHAA{AAGA  A{AA=qARAAA\)ARAGAA\AHAAA(A(ApAAAA  A
=AAAzAAQAA\)AApAGA(A=qA\AA=qA{AApAAffAA33A  AAA{A\)AAA=qA
AAA  A\AQAA=qA{A=qA
=ARA=qA(A\AAAQA\A
=ApAffAHA
=A33AGA\)A(ARAA
AGA
=AAAA=qA=qAzA
=A33AApA33A33AzAA\AQAAA
=A\)A33AAAAffAAAAAAA(A\AA  AA
=AAA
AA\ARAQAA  A33AffA\A\)AA(AA=qAA  ApAHAHAAAzApAAzA{ARAzAA(A
=A(AA=qAzA(AAA  AA  AAAffA=qAffAGAAARAzA
=AAAA
=AAAzAHA33AA33AAAA\AA(AQA£A\)AA=qA\)A(AA
=AAApAAA  A
=AzAQA(A=qAA33AA{AAA33AA  ApA33AffA{AzA\)AQAA\A\)AAA
AApA\AA¸RAHARAAQAHA{AHA
=AAAQAzAAHAzA(A=qA{AA33A
AA33AA{AHA  AGA  A
A
=A  A
AQAAAGApAA  AQAAAAAAAGAAAAffA(AAA(A(AAAAA
A33AA
A{A
AAQAA\)AA
AAA=qAAffA¸RAAHA\)AAAffA
=AffARAA
=A
=A33AA  AGAAffARA
A  A\)AAAGA33A{AAAGA\)A=qA\AffAAAA\)AAAHAQARAAffAAQApAA  A=qAffARARAAQAA33A\)AHAApAAffA
=AA\A\)AA  ApAA
=A33AAQAAAAA{A(AzAzAHAHA  A\)A=qAAA33AQA\ARAzAA  A
AAA\)A33AGA\)A
A=qAA
=AAAAA\)A
=ARApApAAzAzARA\A  A
AARAARA\)AA\ARAQA=qAAA\)A=qAA(A\)AAAA
AAAHAA(A33AffA
ApA{A\ApAQAA
AA\)AA\A  AffAzAHA33AAA
=A
AApAA33ApAA\AA(AARA  ApAzARAA
=AQA
=A
AAffAA{AzAAAApApA\)AA{A(AApAAGA\ApAzAA=qAAAAzAAARA(AQAAAAA
=A{A=qARAAA(A{A  A33AA\AA(A33A
=AAffA  AAA33AzA(AAGAA\A
=AffAAAAARAAA\)AAzAGAA
=A  AApA(AAffAQAAQA
AAA
=AA=qAAffA=qAAAzA\)AffAzAApAffA\)AGA
AAAAAA\)AAA  AHAGA\)A(AAHAA(A\)AAHA=qAHAQAAAAA
=A{AA=qAA=qAQA{A=qAA\)AAA33AAA\ApAA33AffA\A
A33AQAA
AzApAApA  AAAffA33AQAA=qAAGA=qA33AA  A33AAAffA(AA
=AzA(AAAAAAAA=qAA\)A33AAAAAQA=qA
AARA\ApApAAARA(A
AffA=qAzA(AA
=AAA=qA{AAzAAHAQAA  A\)AAQA\)AAA(A  AHAAGAzApAAHA
AAA(AApA{AAQAAA  AAGA33A33AHAA\)AAA33AAAA(ARAAQAAA=qAGAGA
AAAA(AAAHARAARA  A
=A  AQAA=qAA
=A(A33A=qAAAA=qA{AAA
=AffA  AHApAAQA
AGAA(AAHApAHAffApApAQA
AAAAAA=qARAAQA\)A\AAA\)AAAA=qAAAQAzAAAGAAA{A=qAAAAQAAA\)A
AGA
A
=AARAQAffA{AGA=qA\)AA\AHA\)AAA
AHA\A  AHAApA  A  AAGAA\)A
AAzARA\)ApAAApAAGAAAQA  AAApAA  AGA{AA\)AAA\)ApAAAA  AAHA  AAA=qApAAAApA\)A(A33A{AA{AAGA33AA\)AA=qAHAHA\AAAA33A\)AAAAAA
=A\A33A  AzA=qA  AffAApAffA
A33A=qA=qAAGAHAffA\)AHAzA\AAQAzAAA=qA
A33A
=AAARA=qA
=AAAAAGAA\)A
=AzARAQAAARAAA
=A
=AA
=A
=AA
A  A33AApA(A  A  A{AApAAA
=AAA33AzAHAAAGAzA(AA{AA=qApAAHA=qAAffApA
=A\)AA=qAAA\)AA33ApA(AA33AGA33AGAHA
AzA\AAA(AAA(AAA
A33AQAAAA33A
=ApAzA
A{AzApAffA
ARAA33A\A(AHA\AAQAffA33AA\ApA{A
=ARAAAA
=A{A
=A
=A33AAAGAffApAAzARAA33ApAHA\)A  AzA33AHA
=AzAGAAGApAAHAQAAA
AAffAGAzA  AAzA
=A(AzAHA\A
=ApAAzA{A\AQAQAAA  AAAA  AGA  A=qAffAffAARA(ApAAHA33AAARAA\AffAAA33AAGAApA(AA\A\)A
=AAzAA{AQApAAAAAAAA33ApA{AA33A
=AAAAARAzAGAQA{AAAzAA33AA
=AAAAAHAAAApA{AAAHAGAQAAQAAAHAAARAA33A\A(AzARA\AAAffA
=AA
=AAA
AAAA33A(AzA=qAHAARAAAAA{ARApAAA33AA(AA{AAHA  A33AGAAzA
=AA\A(A33A=qAffAGA\A\AAHAA
A
=AAffAAA  AARA\)A{A33AGAzAA{A33AzA\AffAA
AA\)AQAA
AAAA\AzA{AAAAQA\)AAAffAAAHAAAAAQAA=qApARAAApAA(A=qAAzAApAAAA{A=qAAHAAHA\AApAA{AAGAHA33AA
=AHAHAAGAGApAA\A
=AAHAffAffA(A
=AHA  AGApAAARA\)A  AQAAffA(A{A  AffAAQAHARA\A
=AAQA\)AA(AffA{A  A
=AAAAAApAA\)A33Ap                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        AHAHA
AۮA޸RAAAA噚A=qA{AA\)A\)AۮA=qAȏ\AzAA¸RAɅAA\)AA33A=qAAARBB\BzB{BzB\BzBBzB
A\)A  AffA
=AzAQAHAᙚAGAAAHAAAA
A
A
A33B  BBBffBpB\BpBzB=qBRABffAGA  A=qAA
A\A33AA{A(A{AA33AGAA\)AARA
A\AAAAzA
AHAQA{A\)ApAAAA݅A
=A\)A=qAffAAܣA=qA
A
AHA
AzAzAיA߅AffAA=qAHAA{AAzAGAAGAB{B 
B   B \BB33BQB\)B{AB=qBRBB
BBzBAHB (B
=ABQB B{BBBzB\)B\AGApAA
AzB
=B  B \)AAAAffA
A=qAAffA\)ApA
A{AzA{A\)A{AA\)ApAAHA
AzA陚AA  AA뙚AApA\AAQA33AffAAܸRAGAzAHAAۮA܏\A33ApAGA
AffAA\AA\AAHAA\A  A
AAHA  AAAA  AA33ARA=qAQAAGAAQAA  AA
A홚AA
ApARA
A
=A
=A  A=qAHAAA  AAAA=qA
=A33AQA
A\)A\)AQAzA\)AA
A{AAAAAAA
=AGAApAAAA\)A
AffA{AA=qA\)AGA
A
ApAܣAGAיAzA
=A܏\AzA
AHA޸RA\AAA33AAGAGAGApAAAA(AA=qAAA33AA
A(A  A33A(A癚AHAA33AQAGA=qAHA\ApA\AA33A(AQAHA=qAzAAHAGAAA(AA(ARAA33AA
AQAQApA
=AGAAAAA㙚AA  A=qA\A
=AߙA噚AA=qA㙚AQAApB  AHAAGAAAAA=qAA33AAA\)AAARAAAAARAGA\AAQAHAGA{ARAA  AAA홚A\AzAAAGAzA33A\)AߙA  AGA=qAA
=AA(AAAffAffA
AGAQA=qA\A
AA(AAAA33AffA\)AA33A33AA33ApAA(AAAAAApAA{AffA  AGAHARA{AA(AGAzAffAGA33ApAGAAffA
A33A  AApA\AAARAAA=qAzB (B zAGA\A33A(AAffAAQAA  A
=AA\AAzA\AGAzAffA
=ApAHAzApAHA\)AAָRA\)A(A(AA
AAAApA=qA(A
=B
=AHAAAffAzA  AA=qA
=A\)B ffA
=AAzAAzA\A
=AGA
ARAAAAHA
AA
=AA33AAGA(A  A33AAAAQAzApA
=A\)AAAA  AzAQA=qA
=A=qAAA  ApAAA33AAA  A\A\AHAA{A=qA{A(A(AљApA=qA
AӮAA(A\AGAAQAffApAzAGA=qAzA
AAHAzA
AHAffAffAAA\AAA\AA  AAA  A\)A\)A
=A
AzAQA{AA\AA癚AAffA\)A
AAQAAzAHAAA=qA{AA  A  AA  AA
=AGAA\A
A\)AGAzA(A
=AAGAAQAzAQAzA
=A  AGAمApApApA(AA\AffAA\)A\)AAHARA  A
AffBBpBBB(B BGB B (B AzAAA\ApAQA33AffARAAAB HB\)A33AQAAGB pBBBRBHB\BGBB{B
=BB  BBB33BARA{AA(AAAApA{AApAzA홚A  A
=A=qAA=qARAAHAGAQAAA\AGAA=qB AA33AAffAApA33A\B BBB=qBBB(B  B
BpB(BBBBGB(B(B\BffB\BQBBBffBQA\A
=AGApB(A33B 
B\B  B
B zBpA33B B \A{A{A  ABpA
=B=qBGBAffB B zAffAzAAAAAARA(A\)AAQAAAA
AApA\A=qAA
=AQAAHA=qA\)A{AAffAHA=qAA=qAApAzAAA뙚AffAA
=ApAA
=A
=B B AA\)A  AA\)AAAffB pBzB  B\)BB\)BBB AAAzA\A
=AzA\)A  A=qA
=ApA{AQA  A
=ARAAApApAA
=A33AA33AffAA\A33A{AAAHA\)A(AA(A(AHAA
=AzA{AGAGAAB ffBzB AB B AA\BB {B 
BBpBB(B  BBB B \)AAApAB {B   ApAA\)AQA
=A  A\)A=qA=qAAA\)A\A
AA33AAB HABBRB33BBHBB B \A=qAAAGAffA\)B B 
BpB\B
BpBHB
=B
=BBpBBBBB(BHBB(B=qB(B\)A
B   B A{AB   A33B 
B B A
AB \)BffBBpBRB
BB
=BffBHB BBGBRBB(B  B(BzB33BB33B=qB
=B  BBGB(B
=BAB   AGA=qAzB zA\AA
=A33AA\A{AApAQAHARA\AAAQAzA\AA  AAA  AA(AAA
=A
=ARAAAffAQA
A=qAARAARAGA33A\AAA{A33A{A  AffAHA
=AAA\A33AGAA
A=qAAARAQA߅A\)A
AAGAzAA\A{A(AAA
=AHAzA\)A
AQA33A  AA\)AAARAA  AAA\AffApA33A\)AᙚAAApAA\)A
A{AAffARAzAzA(A(ARA33A
=AAA
=A(A=qA(A=qAAGARA\)AQA33AA\AA癚AHA{AAۅAHAHA܏\AAQAAAۅAۮAHAָRA{AӮA
A֏\A
AAGA(AzAA˅AʸRA33A(AzA
=AQAQAܣAffApAߙAAA
A33AޣA癚A߅A
=AHAA\A֏\A  AQA
A{AApAAAAHA
AA\)AAHAAffA\A
AA
AᙚA
A33AA
AzA\)AQAAA33AQAffAAAAأAA֣A
=AA
=A33A33AAGAAA  A33A{AHAظRA  AAAAGAHARA=qARAQAA=qAA  AAA\)AHAA\A\)A\)A(AAHAA=qAA\)AA(A
AAA(ApAA\AAAAA
AARAAGA33AzAGARA  AAHAARAAzApAA\)A{ARApAAzA=qA33AGAQA{AQAzApA(ARAA\AB QB BpAB =qAzApAAB =qAARARAAQA\)AffA=qAA
AHARAA\AA=qA=qAAjRA]AAHAffAAA(AzA\AA33AAA
=A=qA(AAA(AHA  AHA  AzA\)A=qARAzA\A(AGAARAAAARAAzAAAA\)A
=AARAffAzAAAApA{A{A=qAAGA\A33A33AAHAHA\)AʣAʣA  AGAA  AA֣A
=AGAzAУA=qAQAA͙AzAAA33AAAGAAAAAAAGAARAARA33AAAAffAAHAAAAA  A
=A=qAA\AŅA(ApAAGAHAϮApAffAA=qA̸RAˮA33ẠAGA=qA\)AffA
AA
=A
=ApAA{AGA=qA
AGA33AA(A
A\)AA
AApAAAA(A  AA¸RAffA
A(AٙA\)AᙚAAAQApA{AHA(AffA{A  AGAθRAAAAQAAGA{AA
=AGAAHAffA  AA33A
AAAQAA(AzAzAA=qAAQAzAřAƏ\AHAzA\)A
=ApAAffApA{AAĸRAGAHA\A  A\AffAzAəAυA  AυAzAAAAQAQA(AGAffAzAAAffAffAA33AAHAA(AAA
=ApAAAzAAAAAA=qAAͅA\AAAAAAffA\)AzA
=ARARAApA(AzAA
AAAQAzAHA
=A  AGA33A  A  AARAGA=qARAHAA
=AAA
AffAzAAA{ApAA
=AA\)A
=A  AQAA
A33AAA=qA\A
AffAQAAffA\AffAQA\)AAAA\)A(AAA33AAGAffAA
=AAARAAA33AAAAQAAAAAAzA\)A(AHARA\)ApApAA  A  AARAffApAAzAQA{A؏\AAA(A  AՅAѮAAHA{A=qAzAָRA
=AHAAHA(AAzA33A̸RAffApA
=A  A33A  AɮAˮAǙAA\)AHA
AͅAڏ\AΏ\A  AffA{AƸRA׮A{AA(AQA\)AA\A
=A  AAAA\)ApA=qAHAAAAHAA(A܏\AϙAA33AƏ\AAAzAAGAAAApARAARA(AzA{AAAGA\)A\A33AA{AzARAA{AA
=AAQAAʣA\)AApA
AGA{AAۙApAAQAffAzAAҸRAQAGA(AѮA
=AAGA\)AϙApAA33AA
=AApAzAͮA̸RA(AQAA͙A=qAޣA܏\AffAA{A֣ApAAGAffAA{AzA33AA֏\AA  AQAzAAAAQA33A\A
=AAAGAA33AQAHAHAzA(AHA
=AApA33A܏\A=qA
=Aԏ\AA݅AffAAffAAAڏ\AApApAA  A(AAHAA\)AzA  AA
=AAAAأAA\)AHAA=qAAffA{AAAQAHAQA
=A\)AQAᙚAA
A\AGA\AAGAHAAAGA\AA\AAffA33AA(A=qA
AAAA
ARAGAB 
=AAA=qAAQA33A\)AAGApApAAGA
=A
AHA(AHA33A{A=qAޏ\AQApA  A陚AA33AffAffAA\)AGAA{AffAHAAA  AA  AA
=A
AܣA  A{AA(A
=A
A(A
AGAΏ\ApAGA(A{ARAffA(AA\ARAGAA\A33A=qAAzA
AAQA
=AAA=qA噚AGAAA=qAAAGAApAGAHA33AׅA=qAHA(A{AffA=qA33A
=AA{AAAGAA
=ApA=qA\AHA{AAAARA
A(A=qAApA(A(AAA  AAGAffAGA33ARARA
=AffAA  A33A{A
A噚AA{AA33AAAHAAHA(AAA\)B 
=B33B33BBB{BBB
=BffBGBQAA{B 
=A(B RAffAA=qAA\)AffAffAA
=A33AffARA\AAAQA
=A{ApA{A
=AAffABB=qABHBB  A\AffA33AGB RA{BGBB HB33B \A33B(BBGB  B\BpBBAffBA(BpBffB=qB zAzA(AHA噚AARA33AApA{AAAzAAB GB RAB=qB\BB
=B
=BBHB{BB33B=qBB=qB33BBpB\A\AAAffBARAGAA  A=qAAQA
=AAQAAAAzApAA  AAA
A\AA  A{AHARBB =qBzB BB B B(B B  BB RBffBGBBQBzB\B 
AB   B
=AzAApAAHA\A=qA=qA{AApAHAAA  A  AAzAAAQA\AB ffB(BBRB{BB=qBB{BB\BBHB  B(BffB 
=B   B ApA  B HB  B B\B33BzBpBpB=qB=qAAAA\)A  AA(AAAffAA{AGA\)A\)ABBBBQBpB(B  BBBBB=qB\)B=qBGBBBQBGB(A\)B\A
=AHAB
=A  AzA\)B
=AQAAA\)AAA\)AffA{A{AA  AA{AA\AA
=A(B (B B 
B\)BGBffB   AA
AA{AA=qAAffA
A  A\B
=B
BB\B =qB   B  A(AARA
AA=qAQA\)AHAA\)AA=qAffA33A(AzA33AA
=B   B AB  B33B=qBB\BB=qBHBBBffB=qBBB\)B(BGB
=BQAQBB  BBzBRBpB BA
=A
=AA=qAHAApAGA{AAAARA  A
=AGAffAA{AA\)AA\)AAAA\AAA
=AA
A  AA\)ARB\ABzB\)BBAHBffB\BB(BpB33B33A=qAA{AQA  AAB(BA(AGAA=qARA
=AA=qAAAA
=AffA뙚AAAffA\AAGB\)B   AAQB{B(AB A  B GAffB(AARA=qA(AAڸRA=qA
AffAzA(ApAAHB BAffARB zB\BffBzAB(B=qA{B pA(AzA
AQA
B B33B\A
=AzAB {B \B \AB 
B HB=qB\)B=qBffB ApApApA  A{ApB AGAB  B33BBBBBBBB{A{AApARApAAAHAA\)ApB
=A
=AB ABRB\B=qA
=AQA{B HApAQA\)ARAAzAA\)AA(AA=qAQA{AAAAzAARARApAAQA=qA=qA݅AAޏ\AGAAӮAAzAQAۙAzA\)ApA33AffAAA{A
AB 
=B HAA{AAAzA33AQA  AzApAQAAAA
AGAAGAGAA\)AARAA33ApA{A=qAB
=A{AAAA{A  AQAA
BpA  AHAA33A  A
=AffApAAGAAAAAffAAzAAAGAA
=AAAApA
=AA{ApA  A
AAHAB =qB ffB 
B \B HB {AA陚ARA\)A33AQA\)AAAAQAzAӮAָRA33AA=qAAA{AAA݅A
=A
A陚AAAAޣA\AGAA(A߅A=qAAA癚A\A\)ARA=qApAffAAAA\)A
=AARAAAA{AABBBBGB
=B33BBBpBB33B33BGB B HB B  BpBHB{B{B
BBRB{B B B A(AA
=A33AffAA(A㙚A
=A
Aޏ\AA
=A33AA\AffA
=AHA{A{A  AAأAGAAָRAffAԏ\A{A֏\AхAQAAA߮AۙA=qA33AGAzAAAGARAQAAAHA޸RAA߮AAAAzA
=AAA
AGAzAQA\)AAHA{A\)A{A33B B33BGB33BQAAHAAA(AA
A  AApAA\A
=AA=qA
=AA(ARAAAA  AGA
AA
A噚AAAffA33A{A\)A\)AffA=qAAHA{AAzA
AA  A  AA\AGA
A{AARARA{AffAAA\AAHA  AA  AffAffAA=qAAApA\AB (AAzA(A
=AQAAAGAGA\)AGAGAAAA{A(A{AffA\)AAAQAAHApApAA  A
=ApAA  AAA33AᙚAA
A=qAQA噚AzAzAAA
AAAAGAA33AAA(A(AAGA\AQA=qA{AAHA{AzA(AA陚AA=qAAAAA{AA㙚A33A\AA\)AGA{A{A33AAHAQA\AAAAffAQAARA
=A\)AApAAA\)A
A  A33AAGAffApAޣA{AޣAffApA(AAA=qAffAA  AGAGA
ApA홚A홚ARA(A
A{A{A߮AA{A(AQB(AB {A33BBGBGBBB\)A{B
=BB QBB=qBHBBBB\)B\)A33AA
A{AffB\B B RAA\ARAGAGAA(B?
B=qB pB(BGABAHAAA
=A\)B  BB
=BzB=qB\BB{B\)BB\B\BpBBBB
BB\B(BzBQBpB33B{BBBzBffBRBBpB\)BHBBzBBzB\)BffBB\BBffB  B\)B\)BBB{B  B
=B  B  BBBHBBBBHBBRBBBQB=qBBRB  BQBB\BBBBffApB AB{AzB B
=B\)BBpB=qB\BBB  BBB=qB\)BB	{B	=qB	B	B	\B	B	
B	
BB	(B=qBBBRBB33BHBB
=BBHB  BB\B\)BApBGBBBRB  BBBBQBQB(B{B\)B  B
=B\)BBBzB33BRBpB=qB{B
=B	\)B	\B
B	=qBGBB	(B	\)BBB(BBB=qB	  BGBB
B(A(B 33BBGBBQB=qB\BBBQBB  BB
=B
=B{BRB=qBBB	ffB	B	{B	B	=qB	{BffBHBBB\)B\)B
=BzB\B33BQBRBGBB=qBBBBBBRB  B
BB
BQB\B
=B pB B pBGBffBRB\BzB
=BQBBHB(BzBB=qBBB\BBpB{BQB33B\)BffBBBB
A\)BffBQBBQB{BBBA癚A(ApAQAQAA(A  AAAQAA{AQA\)AAHA
AAAHA  A
AAHAAAzAAQA
AAA\A\)AAB=qA(BzBA
=AA\)AABAA\B AA\BHB(A=qB B\)BBBA{BBB  B
BB=qB(BB\)BB\BBB QB{AA\)B BGB\B pB   BB\BB=qBpBpB
BBB\BBGBBBQBBBBBGB QB  BffB\)B=qBB(BB(B GBAAA=qA=qAA\)AAffA
=ApAHB HBRB\)BRB{B 33A
=A
AAA  AAzAAAA33A=qA=qB =qBzBB
BAQBAffBGB
=BHBGBBBB{BHBpBQB
=BApAA
=AHAA\AffAffA33A33A{A(B AQB
AB B=qB\B=qA{BBRB AAA=qA  ARAA{AzApAGAAAA\)AAAAAHA\)B=qAAQARBQBffB{BffB  B33BA=qB B BB A=qA
B
BB
=B\)BRB{BzBpB	GB	\BzBQBRB
=BBffBBBHBGBGB33B
B
=B\)BB(BAzBBBBGBBGBGBQB
=BRB=qBRB\BffBRBBBBBQBBB
A(BGB
=B{AA\)B AQA
=A=qAffAAQA33AB pB A33A(A(A=qAAA{A
=AA\)AARARAA
A\)ARARB RAGA\AAHAAffA\)AAAB B  B=qAA
=B AQAAAB 
B\)B GAA
=AAAGAAA{AzAAffAAA{AApA\ApAGA
ApAAHAzAAA
AA33AA(AAApA(BGA\B 
=B B 33A\AAQAA\A33AAA{AffAA\)AffAQAA=qAffA
ARAA{AA(AQAAffAA{AAAB
=BpB=qAA{ARAAB {B33B{B\)AApA
=AAAA\AA  A
AARARAA
=AB AB AA33A33AA\)B \ABAApAffARA(B BB B BB\)B BB B\)ABBzBQB(B =qB B QB =qA=qA\A
A
AB {A\)A
A(AHB AApA  A\)AA
A\AA\)A\)AA33AARAzAAA
B HAAzA
=AGAA33AHA=qA\)AA(AQARA
A\)A\A=qBGA
A  B GB HApAAB 
B \)B(B\)B B=qBB
=BB(BAGApB BBpB ffA
AB pBffBBRBHB {AARApB \)AABAA\A\)B ABA=qA\AzAGAHAAffAA
AA(AzA
=AAA=qA=qAAARA
=A{ApAffApA  A  AAAzAQAzAA{A\AzA33AA(AHB ApB{B zA33A
=AzAA\)AGA(AA(ARA
AA(AHAAHA33ApAHARA=qAARA\)A  AffA{AAGA  AA
AAA(ARAHA  AGAAGAAA33AA=qAA\)AAARAAAHA=qBRAAAA\ApAffAAAA
AA܏\A  AAA{AQAB  A
A
=A{ABAzAAA
=AGA{AAGA=qB 
BffAffAA(AAA\)AQAAAGAHAzAAffAAәA\)AAݮAHA
=A\AGA
AA\)AffAAĸRA
=AυȀ\AQAAAA\)AHA\AA
ApAQA\)AAAffA{A
=A(A
=A{A{AHAAffAQAzAAQA33AA؏\AAffAQAՙAԏ\Aȏ\AAGA\AA{A
=A  A
AA\)AAA
A\AA{A=qAAffAzA\AHApARA=qA{AyGARAHAA\)A
=AGAA\AffA=qA{AApA\)A(AA
=AAApAAAAQA
=ApAAzA
=AffA  AApAA33AzA{AAAQA\AAGAA33AGAzAAAffA
A  ApA{AA=qAHAA\)A
AA
=A\)AAAARA{A{AffAzA\AAzA=qA
AA{A
AAAGAzAÅAffA
AAA{AA\)A
=A
A33A
ApA
=AA
AԸRA{A׮AAGA=qAffAיAAAHAffARAAAAzAHA\A33AAQAA
A{A
=A(A33AAA(AAAA{AAAQAAffA\)AzAAAA\)A(AAA{
=A
=AAAAAApA\)A\A{ApA\AGAQA33A(A(AHAAQA\)AA\AAA
AAAAA
A
=A33A  AA
=AARAAAAnHA
=AAyGAg33AsAQA|  AyAlzA
AAQAAAAAzA{AGAffAzRA  AuGAl  AiAg
A`AaAnHAAApAAAQA{AA\AAA{A~=qAlQAS\)A@AIADzA9pA>ffA4A4QA#A\A*=qA.\A5A8A7
A.HA%AA&\A=pA9AEA"ffA
=A@ffA*=qA>RAP(A[\)AZ=qAd(AYAd  AlAb=qAmAAmARHAiGAaAlAw33A(AO\)A=pA6\A]AAmGApApAA
A\)A=qA
=ApA33AAzA  A  A33AHAQAARAAzAA=qAA\AA\ARAHAQAA
=AA=qApA{A(AHAA\)A\AAA(A\AAAQA=qAAAAGA\)A=qAAARAQA\A  AGAHA33AQA\A\)AAA
=A(AffAA(A\ApAAAzAGA
=AAɮA\)AzAffAAͮAA  AA=qAQAA=qAffAA33AAQAARAzA=qA(A(AAA=qA{AA(AA\)A=qA=qAAԸRA{AffAAAAQAAAAAɅA˅A\)AAAУA
AיAAHA(A{A
=AͮA{A\AޣAffAAA
AAәAQAAHA\AAzAAAGAzAAAzAՙAУA33A(AHAHA{AAGA=qAffAϮA=qAHAQA\)A
A=qAAď\A\AAAA=qA
=ApA  AAQA\AzAŅAAAA{AApApAGAAA癚AffA(A\)AffAAApA\)AffAGA홚AAAAAѮA{AQAGA{AGAzA
=AȀ\AɮAǅAǅAʣAAApApA  A(A
A=qAAQAA
A\)AQAAApAA
=A\ARApAģAAA
AAAA(A\AAQA(AGAѮA33ARAzAQApAAAυAAGA\)AǙA33ApAA33A33AŮA\)AQA=qA  AңAׅAGAApAĸRAAQA\A33A33A
=A33AHAAHAHA˙A
A
=A33AzAGAəAAA33AͮA
AܣAAA
=AffA(A
=AˮA˅AGAGA(A{AA{A=qApA
AQAGAģA̸RA\)AA{AA\)AAAA33AA{AAAAA33AAՙAAA  AAA
=AA\AHA\)AAAA(AA  A\)AQAA=qA\AQAA
=A͙AәA
=AQA(AAA  AApAڸRAAAAA
AAzAzA\A\)A
A׮AAڸRA
=A噚AzA\)A
AЏ\AAԣAApAA
AУAHA̸RA33AՅAAQAAՙA(AٙAARA
=AיAzAApA
A\)A{AHA
=AAA  AˮAA\)AAARA\AffAAAQAA33ARAQA{AAA£A  AAAAAA
=ApAAAHA{AA
A=qAAffAzAAA
AQAA
ApAHAۮAA\AAHAϙAAޏ\AA33AffAffAHA  AٮAҏ\AA33A܏\A޸RA=qAAGA33AAA
A
=A=qA
A̸RAˮAAA(A\)AƸRApAHApAٮAɮAA(AA
A\AzAGA\)A(A33A=qAA(A=qAHA\AffAA{AQA\AA33ApAzAAA\)AA33AA{AAffARAA|A
=AzAzARAAAARAA=qA{AGA(A(AzAzA{A=qAAAApAzA{AAAHA{AQAAAAAGA\)AAAHA\AHAAA
A  AHAA\A33A(A
A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ??33?ff?ff??ff>?333?>?33>>?333?   ?fff??333?333?  ?L?333?333?L?fff??333?  ?@>?  ?333?   >?  ?   >??333?   ?333>>>>?   ?>=>?   ?   ??   ?333?   ?333??333>?   ??   ??   ????fff??33?ff??333?L?333?   >?   >>??L?333?fff?333??333?L?ff?L?fff?33?333?L?333?333?   ?333???   ??   >???>?333??   ??L?  ?333?L?>?L?   ??   ??fff>>>>>>L>L>>@333==ͽͽ>L>=>>>L====ͽͽ            ͽ        >=>Ϳ333L    ==?>L=>>>?   ff>>?   >?   >>?>>>>L>??L?>?333?   >?   ?   ??L?  ?333?333?333?L?   ????L    =?   ?333?333?ff?333?fff?  ?fff?  ???ff???ff?L?333??333?L????333??333???   ?333??333?   ?fff?L?L?L?   ???333?L?333?L?333??L??L?333?333?   ?fff?fff?333?  ?333?333?   ?   ????333?333?333??333?>??   ??333??L?333?L?333?333??fff?  ??ff?ff??33?ff???  ?  ?fff??L?  ?L?fff??L@ٙ?fff?  ?fff?fff??L?333?fff?fff?L?fff?fff?  ?  ??????  ?fff?fff?fff?  ?fff?  ?  ?333????  ??L?L?333?  ?L?fff?  ?  ?fff?fff?L?  ?fff??ff?fff?L?fff?fff?fff?333?333>L?  ?fff?333??L?fff?fff??L?fff?fff?fff?L?L?fff?  ????ff?  ??ff??ff???ff?  ??L??fff?L?fff?L?L?fff?fff?  ?  ?333??333?fff?  ?L?L?L?L?L?fff?L?  ??  ?  ?  ?fff?fff?ٙ?L?fff?L?L?L?  ??  ?  ??  ???33??33?ff??ff?  ?ٙ?ٙ?33?ff?ٙ?33?ٙ?ٙ??ٙ?  ?ff??  ??  ?  ??33?ff?33?ff??????fff?  ????fff?L?fff?L?fff?fff?L?L?fff?fff?fff???  ?  ?L?L???L?  ?L?fff??fff?  ?L?fff?L?  ?  ??ٙ?ff@   ??  ?fff??  ?333?   ?   >??333?L??333?333?333?L?L?333??ff?fff??ff?33?L?ff?  ?33?  ?33?  ??ff?fff?  ??  ?fff?ff?33?33?  ???fff?fff?fff?  ?L?L?  ?333?fff?L?L?fff?L?L???  ???  ?  ?fff?333??333?fff?fff?333?333?fff?333?333??  ?L?333?333?L?333??   ?33??   ?   >?   ???fff?fff?@   ??ff?  ??  ??ff?ٙ?ٙ?  ?ٙ@   ?ٙ??ٙ?ٙ??  ??ٙ?ٙ?  ?33?  ??  ?33?  ?  ?  ?ff?ٙ?33??  ?ff?ff??33??ff??ff?  ?33?33?33?  ?ٙ?  @   ??33??33?  ?ff?fff?  ??33?ٙ?  ?  ??33?ٙ?ٙ?ٙ?ٙ?@   ?  ?ٙ??ٙ?ff?ٙ??33?  ?ff?  ?ff??ٙ?ff?ٙ?33@@@,@,@9@9@&ff@,@L@9@9@Y@&ff@L@y@S33@Y@L@s33@s33@ff@@@33@ٙ@@ffAffA  @陚@ff@ff@ffAffAffAffA33A1A>ffAK33@33AA  A#33A	AA33A<A.ffA4ALAlAffA  A  AffAA33A33AffA|AVffAlAqAyA\ADA6ffAP  A0  AvffAdAx  AffAAA33AffA33AAA33AffAffA  AffAffA  A33A  AٙBBB	33B$AB   B
A  B`  BC33BffBffB33B33B  BՙBBS33BffB  AB33BBA  AB[B:  B33ABpBhffB#Bh  B_33BB  BB"  B*  B733B1B4ffB(ffBJB%BBB33Bs33BYBffB  Bl  BcB@S33ABn  B33B  BLffBffB-AffB>B  BAəAA  A  AB#B*B/AC33B33B\Bq33B  ?333BB33BD  B~BؙB  BgBBBffBBY33B  BffB33BffB33BBB  B33BBffB33B  BB  B  BffBBBB33A33B  B  B  B  A33BcC&LBffBB  B5CB  B33B`BVffBDB0ffB!33BDBB33B  B@  BBffB33BC
ffC"3C	C33ABz  @333CLC	B{33B{33B  BffBBpffB  C:A33CQffCOCAffAC CjfCvCALB  C	DhC33C A@  BÙC$CC& CCNBCBCB33C33CB33C533C33Cn33C@ffCIC
CN  C]C
ffC?fB  CA B  B\ffB  BffC-C?ffCKBCQ33BffB♚CU  C3BffCfB  C3CO33B  C8LC^ffBC B  CBK33BffA  B33BB33@&ffB  BBߙB陚BC+  AC	BAffBj  BřB33C$3C>fBffBffC CCxC C  CBC  CYC CCCRAC33CjC C33C`C4C)  CC  C<CLB.  C1LCGC@ C3C333C CCYCC33BݙB33BC
ffCRfCC/ BA[33AffC?3BffCBCLC1LC7 CN33CL@C3 @s33C C
fCffC^ C533C COCٚCfC3C CfC33C33C&fD	3C|CCyLCfB  CkC C#CULCLCRfBffC33C@ CWffCLCC33CCC  CoCsf@ffCL3CffCfC&fCC@ BC9LCCCLCLCfCLC(3CCCCffC*ffC2  C1C.3C33CCfCLC3CfC33C3CffC-33CC5CffC%fC'ffC)ffC,3C-C
33C/ C%3C)3C4fC7 C% CHCfC=  C6C1C9  C+fC2C 3C0C[ CO33CZCA C~Cx3CCdC C(33C#33BffB33C| CnfC~3CICD33C1C!3C!ffC#fBffC
C33C3CC1  CLBffC 33C:ffC!3CBBC=  C9fC*fC#  C'C:LC  C?3CIfCJ33Cx  Cp ChLClCLChfCNCffC&fCx  CfCnCf33CQffCLCٚCaCfCYC  CCffC3CfCfCfC[CSC33Cb3C@`  @fff@ff@@@ff@  @@@@33@  @@33@@@ə@33@@@&ff@&ff@@9@Y@Fff@L@l@@  @Y@Y@Fff@,@   @,@,@@  @9@S33@@  @S33@Y@Fff@l@l@33@s33@  @ff@@33@@@33@  @@@  @33@33@33@,@&ff@33?ff@   @@   @33@ff@ff@@9@L@L@&ff@@&ff@Fff@9@Y@`  @l@`  @9@L@Fff@9@&ff@9@   @,@@333@@&ff@&ff@,@&ff@@  @9@,@,@Fff@@  @L@Y@333@,@333@@  @L@Y@Y@fff@l@ff@@33@@33@@@@@@33@?ٙ?ٙ@ff?33@33@9@Y@s33@L@l@@  @Fff@9@S33@@33@@  @fff@333@Fff@s33@,@Y@33@L@ff@fff@y@@@Fff@ff@  @33A33Ax  AffAAA;33AffAA33@  @@@  @  @@  @ff@@@ff@ff@33@@ff@  @33@@@@ff@33@@@@ff@33@ff@@33@@@@ff@ff@@@  @l@S33@Y@S33@&ff@333@S33@  @9@@ff@Y@@ff@  @s33@ff@  @33@@@fff@33@y@L@fff@fff@`  @l@fff@Fff@L@Y@@ff@@ff@@33@33@&ff@333@,@,@&ff@L@,@333@Fff@L@Fff@333@y@33@@ff@33@@@  @33@y@  @y@y@l@33@fff@Y@s33@`  @@  @S33@fff@`  @L@S33@`  @fff@S33@Fff@Y@Fff@@  @l@L@fff@Y@Fff@s33@l@fff@Y@Fff@&ff@333@9@9@   @   @@&ff@33@&ff@@,@&ff@Fff@9@333@9@,@333@9@@   @@33@   @33@,@   @,@ff@,@   @9@Y@`  @s33@s33@33@`  @L@ff@  @33@ff@@ff@33@ٙ@@@ff@@@@ff@ff@@@@33@@@@33@@33@@@@  @  @  @33@33@  @33@33@l@33@@  @@  @@33@Y@Y@Y@l@`  @`  @l@`  @s33@y@l@ff@s33@l@fff@y@@@  @33@ə@  @33@ff@s33@y@L@9@   @333@9@33@,@@  @  @,@333@333@333@Fff@Y@y@  @  @s33@`  @Fff@333@,@333@&ff@@&ff@,@333@@  @,@   @,@   @Fff@@  AAA>ffAs33AAA33AffAAaAffAs33AAAAALAC33A!A$A!AffALAX  A<A333A1A9A6ffA,AffAffAffAffAA33A   @ff@ٙ@ٙ@33@A   A   AA   Aff@ff@@@@@ff@ə@  @ff@  @@  @@  @33@33@  @  @@@ə@33AffAff@33@33@33@@  @@ff@33@@y@33@l@Fff@S33@@L@33@33@@@  @s33@@@ff@  @ff@y@ff@@33@fff@fff@  @33@y@fff@fff@9@9@9@S33@S33@S33@y@y@s33@@ff@L@  @s33@y@y@  @  @Y@s33@s33@Fff@s33@9@@@@@  @@Y@L@fff@  @@  @&ff@@  @fff@Y@s33@fff@`  @333@,@,@&ff@Fff@S33@@  @33@S33@  @y@s33@  @  @s33@Y@9@,@L@S33@@  @9@333@9@&ff@Fff@Fff@@  @L@l@   @Fff@&ff@&ff@&ff@,@   @33@,@333@333@&ff@&ff@333@ff@   @ff@   @@,@ff?33@33@   @@ff@33@@@@   @@@   @@9@&ff@,@@  @   @33@33@&ff@ff@@   @33@@@33?ff@?ff??ٙ??  ?  ???ٙ?ff??ٙ?33?  ?ٙ?ff?33?ff@@33@33@ff@@@@   ?ff??33@33?33@ff?ff@   ?ٙ?ٙ???ff?ٙ?33?ff@??  ?ff?ff?ٙ?ٙ@ff?33?  ?ff?  ?33?ٙ??33?  ??33?33?ٙ?ٙ?ff@   ?33??  ?ff?ff@@33@,@@333@@ff?ٙ??@ff??ٙ?ff?33?33?ff?ٙ?  @,@&ff????  ?33?  ?33???  ???33?33?ff?ff?ff@@   @ff@   @@ff@@   @@,@33@   ?ff@ff@ff@ff@33?ff@33@   @33@   ?ff?33??ٙ@L@   ?ff@&ff@   @   ?ff?33?ff?33?33?  ?  ?ٙ?33?@   ??ff??ٙ?  ?ff???ff?33???33?33@&ff@?ff?ff??ff?33?  ?ff?  ???ff?ff?????33??  ?  ?ff?33?ٙ?ff?  ??????33@,@&ff@   @333@ff@ff@ff@ff@,@&ff@   @&ff@,@?33@33@Fff?ff@33@   @@33@ff?ٙ?ff?  ?ff?  ?  ?33?  ?ٙ?  ???33?ff?ff?33?????33??33??ff?ٙ?33??ff?  ?33?ٙ@33@@&ff@@  @   @   @@&ff@@&ff?ff@??ff??ff?33?  ??33??33?33?ff????  ?ff?33????ٙ@y@33@s33@S33@L@   @@,@@   ?ff?ff@ff?ff?ٙ?ٙ?ٙ?  @   @?ff?33?  @33?ff?ٙ?ff?  ?33?ff??ٙ??  ?ff?ٙ?33?33?33?ff?ٙ??ff?ٙDd?33?33?@@@@333@@  @?33?ff?  @ff?ff?ff?ff?33@   @ff@9@,@?33?  ?33?33?  ?ff?ff????????333?L?  >?fff?333?L?L??33?L?333?fff?  ?ff?33?ff?ff?ff?  ?  ??ٙ?@33?  ??ff??  ?33???ff?33?ff?ff??ff?ff??  ?  ?  ?ff?  ?ff?L?33???  ?  ???  ??  ?  ??ff?>??  ?  ??ff@   ?  ??33?33?ٙ??  ??ff?  ?33???fff?33?ff?ff?ff??fff?fff?  ?L?  ?L?  ???L?  ?  ??  ?33???33?  ?ff????33?  ?  ???L?fff?L?333??ff?  ???ff@???????ff???  ??33??L=??333?????ff??333?fff?fff?  ?L??  ?ff???333?fff?fff?L?  ??  ?  ?  ??  ?  ?ff????  ??  ?333??33?   ?ff??  ?ff?333?fff??33?L?  ?L?33??ff?  ?  ??  ?  ?33??ff?33??ff?fff?fff?  ?  ??  ??ff?ff????  ?ff???ff?ff????ff??ff?  ?ff?  ?ff?  ?ff?ٙ???ff??ff?  ?ff?  ??  @333?  ?ff??ff?  ??33??ff?ff?33?ff?ff?ff?ff?ff?33@ff?ff?  ?ff@??  ?33?ff?ff?ff?ff??33???33?  ?ff?33?33?  ?@?ff?  ?33?ff?33?33?33?33?33?ٙ?33??ff?ٙ@   ???ff?ff?ff??  ?  ?33?33???33?ff?  ???33?  ?  ??  ?33?ٙ?33??33?33?ٙ?33?  ?ff??33@   @9@ff@9@L@ff@33@333@@&ff?ٙ?ٙ@   @ff?33@   @@ff@ff@   @33@ff@ff@ff@   @   @   @33@@?  ??  ?33?33?33?ff?  ?33?  ?33?  ?  L??333?fff?  ?   ?333??L?333???  ?fff?fff??fff???  ?333??ff???ff????????>?????ff??  ?33?33????ff?  ??33?33?  ?333???33?33?33?  ?33?33?33?33?>?fff??ff?ff??33?33?33???33??L?   ?33?  ?33>?33?33?L?  ?  ?33?  ?ٙ?ff?33?33?ff?ff?ff??ff?  ?ff??33???33???ff??ٙ??33?33?ff??ff?33@ff?ٙ?ٙ??ٙ?ٙ?  ?ff?33?33?  ?  ?33?33?ٙ?  ?ٙ@333?33@ff?33?ٙ?ff??ff?33?  ?ff?ff?33?33?33?33?33?33?33?33?  ??ff@33?33?ٙ??  ?ff?ff?????????33?33?ff?  ?33?ff?33?33?ff?A	?33?ff?33??ff?@@33?ff@@@@ff?ff@&ff@@9@333@&ff@L@   ?ٙ??33?33@@33@@@@33@@ff@@33@33@33@ff@   @33@33@ff@&ff@   @   @33@ff@33@ff?  @@ff@   ?33@333@   ?ff?ff?33?  L??33?ff?ff??33?33???333??@33?ff?ff?  ??33?L?  ?33?ٙ?ff?33?33@?ٙ?ff?Ϳfff?L;ff@   ?@ff@?33?ff?33@   ?33??ff?  >?  ?@33@@  ?  ?@@33@ff@@  @  @@@@33@@@  @l@@  @S33@9@,@L@@  @Fff@`  @@  @,@333@&ff@@  @333@@  @333@L@333@&ff@   @@,@333@@@   @&ff@333@   @?ff???ff@@33@333@9@9@9@&ff@,@@,@@@?33@ff@ff@33@   @ff@@   @,@9@333@9@Fff@L@@  @L@S33@@  @@  @Y@L@@  @   @,@9@&ff@33@&ff@&ff@@&ff@333@   @9@@  @l@@  @`  @  @s33@`  @@  @y@33@s33@`  @9@333@&ff@333@   @333@9@ff@@ff?ff@?ff@@33@@@@   @33@,@`  @33@ff?  @?  ?33???  ?ٙ?ٙ?ff?  ?  ?@   @   ?ٙ?ff??ff?  ?ff?ff@   ?ff@   @@&ff@&ff@&ff@@  @   @333@,@  @`  @ff@ff@@   @ff@   ?ٙ?ٙ?ٙ@ff?33?ٙ??33?ٙ?ٙ?ٙ@@@   @   @ff@33@   @@33@33@@ff@@   @   @33@   @ff?33@33@ff?33@33@ff?33@?33?ff@@ff?ff@ff@@   @ff@   @   @L@9@9@   @@   ?33@ff@ff@ff?ff?ٙ@   ?  @   @   @ff@ff@   ?ff?33?33@@@@  @   @,@@L@   @9@@  @L@Fff@S33@@  @9@Fff@,@L@9@&ff@@?  ?ٙ@   ?ٙ?ٙ??33??  ?33?ٙ@?ff?  ?ff??ٙ?33?33?33?ff@   ??ff@33@&ff@   ?ٙ@33?@,@,@   @333@9?33@,@33y@ff?33@   ?33?ٙ?ff??33?ff?ٙ?ٙ?  ?  ??ٙ?  @   ?ff?33?33?ff?  ?33?ٙ?ٙ@   @   ?33@   ?ٙ?33?ٙ?ٙ????ff?ff?ٙ@   ?ٙ@   ?ٙ?ff@   @ff@   ?  @,?ff?ٙ@ff@Fff?33@?33@9@33@   ?33?ٙ?  ??ff?  ?ff?  ?ff?ff?  ?  ??33?ٙ?  ?33?ff?  ?33?  ?ff?ff?@ff?33@   ?33?33@   ?ٙ?  ?ff?  ?ٙ?ff?ٙ?ٙ??33??33?  ?33??33?33??ff?ff?  ?33?  ??ٙ?ٙ???33?ٙ?33??33?  ??  ?33?ff?33?ff?ff?33?33?ff?  ?33?ff?33?33???33?ٙ??ٙ??33?  ??  @??ٙ?ٙ@   ?33?ff?ff?ٙ?ٙ?ff?  ?  ??  ??ff?33?ff?ff@   @@ff@   @ff@ff@,@&ff@   ?  ??33??33??  ??ٙ??  ????33?33Aff?ٙ?ٙ?ٙ??ٙ?ٙ?ٙ?ٙ?ٙ??  ???  ???  ?  ?  ?33?  ????  ?ٙ??ٙ?  ?ff?  ??  ?  ?ٙ?33?ff?ٙ@@   @33@@@ff@?33@?ff?ff?33?ff?ٙ?ff?ff?ٙ?@   ?33@ff@   ?ff?33@   ?ff?ٙ@@@   @ff@   @   ?33?33@   ?ff?33@   @   @ff@@@   @@@?33@?33?33?ff?33?33?33?33@@   @?33?33@@33@   @ff?33?  ?33?33@   @   ?ٙ??  ???ٙ??ٙ?ٙ?ٙ?ff@   ?@   @@ff@   @33@@@?33@   @33?33?33?33@   @   @@   ?33?ff?33?ff?33?ff@   @   ??????33??33?ff?ٙ?  ?  ???  ?  ?33?33??  ?ٙ?33?ff@?ff???ٙ?33?ff?ٙ?33?33@33@33@ff@33@@   @   @?ff?ٙ?  ?  ??  ?  ?ٙ?  ?  ?  ????ٙ??ٙ?  ?  ?  ?  ???ff@   ?ٙ??ff??ٙ?ٙ?ff@ff?ff?ٙ?33@   @ff@@   @ff@   @   @   ?ff?ff?33?????ٙ??ٙ?ٙ?ff?ff?ff?ٙA#33@ff?ff?ٙ??ٙ?ٙ?ٙ???ff?ٙ??@  ?ٙ?ٙ@&ff?ff?ff????  ??ٙ?ٙ??ٙ?ٙ??ٙ?ff?ff@   ?ff?ٙ??ٙ?ff?33@ff?33?33?ٙ??33?33?ٙ?ff@   ?33@ff@ff@   @33@   @   @&ff@33@   ?ff?33?  @   ?ff@   @333@   @ff@33@@@   ??33??  ?ff?ff?ff?ff?ٙ??ff@&ff@@  @fff@L@  @Y@l@Y@@  @L@L@L@fff@Fff@9@333@333@333@,@,@,@333@333@9@&ff@9@,@   @,@L@@  @33@33@33@33@33@@33@33@33@33@   @   @,@@  @&ff@@33@@&ff@,@&ff@&ff@333@,@   @,@   @&ff@33@   @&ff@@,@9@,?33@@@&ff@9@333@9@333@33@333@&ff@&ff@   @@&ff@&ff@@   @@   @&ff@   @&ff@,@&ff@&ff@@ff@   @ff@@   @ff@   @33?33?ٙ@ff@@ff@ff@ff@ff@   @@@@@   @&ff@ff@&ff?33@?33?33?ٙ?33?ff?33?ٙ?ff??ff?  ?33??33??ٙ?ٙ??ٙ?ff?ٙ?33?33@@ff@ff@@ff@@@@33@@@ff?33@ff@@   @@  @   @S33@9@33@&ff@333@9@S33@Y@Y@L@@l@@  @L?ff@l@S33@Fff@Fff@,@333@&ff@33@   @33@ff@33@ff@ff@   ?ٙ@   ?33@   ?ٙ@   ?33?ٙ?  ?ff?ff?33@   ?33?33@ff@   @@ff@ff?33?ff@?33@   ?33?33@   ?33?ٙ???  ?@   ??ٙ?ff???ٙ??ٙ?ٙ?  ??ٙ?ٙ???ٙ?  ???ٙ?ٙ?  ?ff???ٙ???  ?ٙ?  ?ٙ??ٙ?ff?ff?ff?ff?33?33?33?33??  ?33?ff?ٙ?33@   ?ٙ@   ?33@   @@?ff@ff?33?33@ff?33?ff?  ?  ?  ?  ?ٙ?  ?ٙ?  ?33@   @ff@   @ff@&ff@   @LA+33@ٙ@@@@9@@ff@`  @Y@ff@fff@@  @33@l@ff@fff@Y@@  @   @&ff@9@  @l@@   ?ٙ@   ?33?33?ff?33?ff@   ??33?33@   @33@@   @   @@   @33?ff@&ff@   @@,@@  @&ff@L@Y@@  @9@Fff@Y@S33@33@y@y@s33@  @@L@y@33@ff@@y@s33@s33@y@  @33@y@  @33@  @ff@y@33@@L@@  @`  @S33@Y@33@33@33@@ff@   @33?33@9@@ff@   @@  @&ff@L@333@S33@&ff@,@  @@Fff@9@ff@@  @9@@  @@&ff@ff@@   @?33?ٙ@9@L@Y@,@9@y@s33@9@y@9@fff@@  @@L@S33@l@@ə@  @@@33@33@@@ff@ff@33AAffAffA	A9A@@陚@@@@33@@  @ff@33@  @33@@ٙ@@  @S33@S33@@33@fff@  @9@ff@@33@  @  @Fff@y@ff@33@@S33@Y@@  @ff@Fff@fff@ff@@  @Fff@Fff@S33@fff@33@&ff@Y@Y@S33@S33@y@@@  AA1AtAAAffAffAAffA~ffAp  AIANffA9A4A,AH  A0  A+33A,A4A(  A&ffA   A33A   A   AAA  A33@ff@@ٙ@ff@  @  @33@@ٙ@@@@@  @@ff@  @33@  @ff@@@33@ff@33@  @  @ff@  @@  @ff@33@33@ff@ff@@  @@33@@ff@33@ff@  @@ff@@  @@ff@@  @@ff@s33@33@  @l@Y@L@@  @S33@Fff@,@&ff@,@9@  @ff@ff@@  @ff@y@s33@l@`  @Fff@fff@33@fff@33@y@  @y@`  @`  @fff@33@ff@  @  @@ff@@33@ff@ff@@@33@  @  @  @@  @@ff@@@  @@@ff@ff@33@ff@@@@33@33@33@@33@ff@陚@  @33@33@33@33    @ff@@  @  @ff@33@ff@y@ff@s33@y@fff@  @l@fff@s33@fff@  @S33@fff@  @@fff@@y@  @  @fff@  @`  @y@ff@l@y@ff@s33@@  @33@fff@  @33@@ff@  @ff@@@ff@@@33@@L@@@ff@33@@@@@  @陚AA>ffA1A0  A.ffAA!A#33AffA33A  A33A33@ff@ff@ff@ff@ff@  @33@  @ff@  @ə@ff@33@33@33@33@33@@ٙ@33@ٙ@  @33@ə@33@ٙ@@ٙ@@  @  @  @ə@33@A@@33@33@@ff@33@ff@ff@33@@  @@@@ff@  @@@@33@ff@@ff@ff@@@  @@33@ff@@33@ff@  @ff@@@ff@  @@@  @  @y@  @y@s33@y@`  @Y@`  @S33@Fff@fff@`  @l@s33@Y@33@l@S33@l@s33@l@s33@l@s33@y@fff@l@y@y@l@l@fff@fff@S33@fff@Y@S33@s33@y@s33@s33@s33@l@fff@`  @`  @fff@l@l@s33@  @  @@s33@s33@s33@s33@S33@Y@33@s33@s33@  @ff@s33@  @@ff@33@s33@l@fff@`  @Y@S33@S33@S33@fff@`  @y@fff@Y@fff@S33@`  @Y@Fff@@  @L@@  @@  @S33@fff@`  @L@fff@`  @33@9@@  @333@@333@,@@  @L@`  @S33@Fff@`  @Y@fff@Y@Y@l@9@S33@Fff@S33@S33@@  @L@S33@Y@`  @`  @fff@`  @fff@`  @`  @s33@l@`  @Y@Y@@  @Fff@L@@  @@  @9@Y@l@33@fff@&ff@&ff@@@@   @,@33@@   @@333@333@9@333@9@9@@  @S33@Fff@,@L@@  @Y@Y@`  @   @33@33@33@ff@   @&ff@   @@Fff@S33@Fff@L@Y@S33@Y?333@Y@L@Y@Y@9@333@@  @@  @S33@333@333@@  @9@333@   @,@333@@@L@L@L@L@Y@`  @S33@L@`  @S33@Y@s33@S33@Y?@@  @y@y@Y?  @fff@`  @fff@L@@  @333A33@33@,@&ff@&ff@   @333@@  @   @&ff@&ff@&ff@,@@  @,@s33@fff@@  @333@Fff@9@&ff@,@@  @333@Y@L@&ff@333@  ?@@&ff@,@   @9@9@333@9@   @9@9@&ff@   @@  @Fff@@   @,@9@9@,@,@333@@  @,@,@33?33@   @@33@@@ff@@   @@&ff@33@33@   @,@@  @9@fff@L@S33@Y@L@S33@`  @L@`  @S33@Fff@9@L@9@9@ff@,@,@333@33@@&ff@,@&ff@9@9@@  @@  @L@@33@   @ff@ff@   @   @   ?33@   @   ?ٙ?33@&ff@@@@9@333@@ff?33?ff?ٙ?  @?33?  ?ٙL@&ff@333@333@,@ff?33@   ?ff@   ?33@   @&ff@9@&ff@33@@9@@  @@33@@ff@?33??ff?ff@@   ?ff?33@   @ff@?ff@?ٙ@@ff@@ff@@33@ff@?33@@33?33@ff@33@@   @9@33@,@@  @ff@ff@ff@@,@33@   @   @ff?ٙ?ff?ff?ff?ff?  ?33?ٙ?33@&ff@   @ff??ٙ?ٙ?33?ٙ?33@@   ?33@,@33@,@   @33@@  @@  @S33@&ff@&ff@@  @,@&ff@fff@Y@Y@S33@9@@   @333@ff@33@ff@ff@   @33@@ff@,@@   @&ff@   @D @@@@&ff@   @&ff@33@@ff@ff@ff@@@33@33@33@@@?33@   @   @@ff@@@   @@L@@33@   ?ff@@ff@@?33?33@@@   ?33@@   @ff@   ?33@ff@ff?33@   @@@  @s33@S33@@@   @L@@  @9@333@9@&ff@&ff@,@Fff@9@,@   @&ff@L@Y@9@&ff@9@9@9@,@L@9@S33@Fff@9@@  @Fff@@  @,@@  @@  @9@9@9@9@333@9@&ff@&ff@@  @,@&ff@,@&ff@33@   @ff@&ff@@333@,@,@   @&ff@@   @   @&ff@333@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 