CDF       
      
timeseries        obs   }>   station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:15:04Z http://pacioos.org
2022-11-15T19:15:04Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2014-01-01T00:00:00Z&time%3C2015-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2014-12-31T23:45:00Z   time_coverage_resolution      PT30M      time_coverage_start       2014-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      A԰֠   A)"      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z       r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      A=qA
   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       \   salinity                   _ChunkSizes                
_FillValue        y    actual_range      @=qBR   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       Q   	turbidity                      _ChunkSizes                
_FillValue        y    actual_range          B33   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       	F   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range          CF     ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       ;   oxygen                     _ChunkSizes                
_FillValue        y    actual_range          ADQ   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       
0   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      BC2     ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       %   ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`          temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      A=qA
   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH          temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range                  temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	        temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     |   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     t   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     l   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      d   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     "\   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     $T   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     &L   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     (D   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     *<   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     ,4   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     .u,   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     0j$   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      @=qBR   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       2_   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range               4T   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     6I   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     8>   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     :2   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     <'   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     >   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     @   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     B   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     C   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     E   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     G   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Iڼ   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Kϴ   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     MĬ   salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     O   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range          B33   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       Q   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range               S   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     U   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     W   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Y|   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     [wt   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     ]ll   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     _ad   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     aV\   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     cKT   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     e@L   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     g5D   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     i*<   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     k4   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range          CF     ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       m,   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range               o	$   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     p   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     r   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     t   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     v   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     x   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     z   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     |   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     ~   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	        chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	        chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	        chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	        
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range          ADQ   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       y   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range               n   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     c   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     X   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     M   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     B   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     7   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     ,   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     !|   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     t   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     l   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      d   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     \   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     T   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      BC2     ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       L   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range               D   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     <   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     4   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     ,   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     $   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	        oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	        oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     |   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     p   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     e   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Z   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     O   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       D   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range               9   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     .   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     #   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     
   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	        	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	        	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	        	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     ֌   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     ˄   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     |   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     صt   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       t ڪl   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     { ݙ   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    g0 Ap?  wqb_04  A԰֠   A԰ׁ   A԰b   A԰C   A԰$   A԰   A԰   A԰   A԰ݨ   A԰މ   A԰j   A԰K   A԰,   A԰
   A԰   A԰   A԰   A԰   A԰r   A԰S   A԰4   A԰   A԰   A԰   A԰   A԰   A԰z   A԰[   A԰<   A԰   A԰   A԰   A԰   A԰   A԰   A԰c   A԰D   A԰%   A԰   A԰   A԰   A԰   A԰   A԰k   A԰L   A԰-   A԰   A԰   AԱ    AԱ   AԱ   AԱs   AԱT   AԱ5   AԱ   AԱ   AԱ   AԱ   AԱ	   AԱ
{   AԱ\   AԱ=   AԱ
   AԱ
   AԱ   AԱ   AԱ   AԱ   AԱd   AԱE   AԱ&   AԱ   AԱ   AԱ   AԱ   AԱ   AԱl   AԱM   AԱ.   AԱ   AԱ   AԱ   AԱ   AԱ   AԱ t   AԱ!U   AԱ"6   AԱ#   AԱ#   AԱ$   AԱ%   AԱ&   AԱ'|   AԱ(]   AԱ)>   AԱ*   AԱ+    AԱ+   AԱ,   AԱ-   AԱ.   AԱ/e   AԱ0F   AԱ1'   AԱ2   AԱ2   AԱ3   AԱ4   AԱ5   AԱ6m   AԱ7N   AԱ8/   AԱ9   AԱ9   AԱ:   AԱ;   AԱ<   AԱ=u   AԱ>V   AԱ?7   AԱ@   AԱ@   AԱA   AԱB   AԱC   AԱD}   AԱE^   AԱF?   AԱG    AԱH   AԱH   AԱI   AԱJ   AԱK   AԱLf   AԱMG   AԱN(   AԱO	   AԱO   AԱP   AԱQ   AԱR   AԱSn   AԱTO   AԱU0   AԱV   AԱV   AԱW   AԱX   AԱY   AԱZv   AԱ[W   AԱ\8   AԱ]   AԱ]   AԱ^   AԱ_   AԱ`   AԱa~   AԱb_   AԱc@   AԱd!   AԱe   AԱe   AԱf   AԱg   AԱh   AԱig   AԱjH   AԱk)   AԱl
   AԱl   AԱm   AԱn   AԱo   AԱpo   AԱqP   AԱr1   AԱs   AԱs   AԱt   AԱu   AԱv   AԱww   AԱxX   AԱy9   AԱz   AԱz   AԱ{   AԱ|   AԱ}   AԱ~   AԱ`   AԱA   AԱ"   AԱ   AԱ   AԱ   AԱ   AԱ   AԱh   AԱI   AԱ*   AԱ   AԱ   AԱ   AԱ   AԱ   AԱp   AԱQ   AԱ2   AԱ   AԱ   AԱ   AԱ   AԱ   AԱx   AԱY   AԱ:   AԱ   AԱ   AԱ   AԱ   AԱ   AԱ   AԱa   AԱB   AԱ#   AԱ   AԱ   AԱ   AԱ   AԱ   AԱi   AԱJ   AԱ+   AԱ   AԱ   AԱ   AԱ   AԱ   AԱq   AԱR   AԱ3   AԱ   AԱ   AԱ   AԱ   AԱ   AԱy   AԱZ   AԱ;   AԱ   AԱ   AԱ   AԱ   AԱ   AԱ   AԱb   AԱC   AԱ$   AԱ   AԱ   AԱ   AԱ   AԱ   AԱj   AԱK   AԱ,   AԱ
   AԱ   AԱ   AԱŰ   AԱƑ   AԱr   AԱS   AԱ4   AԱ   AԱ   AԱ   AԱ̸   AԱ͙   AԱz   AԱ[   AԱ<   AԱ   AԱ   AԱ   AԱ   AԱԡ   AԱՂ   AԱc   AԱD   AԱ%   AԱ   AԱ   AԱ   AԱ۩   AԱ܊   AԱk   AԱL   AԱ-   AԱ   AԱ   AԱ   AԱ   AԱ   AԱs   AԱT   AԱ5   AԱ   AԱ   AԱ   AԱ   AԱ   AԱ{   AԱ\   AԱ=   AԱ   AԱ   AԱ   AԱ   AԱ   AԱ   AԱd   AԱE   AԱ&   AԱ   AԱ   AԱ   AԱ   AԱ   AԱl   AԱM   AԱ.   AԱ   AԱ   AԱ   AԱ   AԲ    AԲt   AԲU   AԲ6   AԲ   AԲ   AԲ   AԲ   AԲ   AԲ|   AԲ	]   AԲ
>   AԲ   AԲ    AԲ   AԲ
   AԲ   AԲ   AԲe   AԲF   AԲ'   AԲ   AԲ   AԲ   AԲ   AԲ   AԲm   AԲN   AԲ/   AԲ   AԲ   AԲ   AԲ   AԲ   AԲu   AԲV   AԲ 7   AԲ!   AԲ!   AԲ"   AԲ#   AԲ$   AԲ%}   AԲ&^   AԲ'?   AԲ(    AԲ)   AԲ)   AԲ*   AԲ+   AԲ,   AԲ-f   AԲ.G   AԲ/(   AԲ0	   AԲ0   AԲ1   AԲ2   AԲ3   AԲ4n   AԲ5O   AԲ60   AԲ7   AԲ7   AԲ8   AԲ9   AԲ:   AԲ;v   AԲ<W   AԲ=8   AԲ>   AԲ>   AԲ?   AԲ@   AԲA   AԲB~   AԲC_   AԲD@   AԲE!   AԲF   AԲF   AԲG   AԲH   AԲI   AԲJg   AԲKH   AԲL)   AԲM
   AԲM   AԲN   AԲO   AԲP   AԲQo   AԲRP   AԲS1   AԲT   AԲT   AԲU   AԲV   AԲW   AԲXw   AԲYX   AԲZ9   AԲ[   AԲ[   AԲ\   AԲ]   AԲ^   AԲ_   AԲ``   AԲaA   AԲb"   AԲc   AԲc   AԲd   AԲe   AԲf   AԲgh   AԲhI   AԲi*   AԲj   AԲj   AԲk   AԲl   AԲm   AԲnp   AԲoQ   AԲp2   AԲq   AԲq   AԲr   AԲs   AԲt   AԲux   AԲvY   AԲw:   AԲx   AԲx   AԲy   AԲz   AԲ{   AԲ|   AԲ}a   AԲ~B   AԲ#   AԲ   AԲ   AԲ   AԲ   AԲ   AԲi   AԲJ   AԲ+   AԲ   AԲ   AԲ   AԲ   AԲ   AԲq   AԲR   AԲ3   AԲ   AԲ   AԲ   AԲ   AԲ   AԲy   AԲZ   AԲ;   AԲ   AԲ   AԲ   AԲ   AԲ   AԲ   AԲb   AԲC   AԲ$   AԲ   AԲ   AԲ   AԲ   AԲ   AԲj   AԲK   AԲ,   AԲ
   AԲ   AԲ   AԲ   AԲ   AԲr   AԲS   AԲ4   AԲ   AԲ   AԲ   AԲ   AԲ   AԲz   AԲ[   AԲ<   AԲ   AԲ   AԲ   AԲ   AԲ   AԲ   AԲc   AԲD   AԲ%   AԲ   AԲ   AԲ   AԲ   AԲ   AԲk   AԲL   AԲ-   AԲ   AԲ   AԲ   AԲñ   AԲĒ   AԲs   AԲT   AԲ5   AԲ   AԲ   AԲ   AԲʹ   AԲ˚   AԲ{   AԲ\   AԲ=   AԲ   AԲ   AԲ   AԲ   AԲҢ   AԲӃ   AԲd   AԲE   AԲ&   AԲ   AԲ   AԲ   AԲ٪   AԲڋ   AԲl   AԲM   AԲ.   AԲ   AԲ   AԲ   AԲ   AԲ   AԲt   AԲU   AԲ6   AԲ   AԲ   AԲ   AԲ   AԲ   AԲ|   AԲ]   AԲ>   AԲ   AԲ    AԲ   AԲ   AԲ   AԲ   AԲe   AԲF   AԲ'   AԲ   AԲ   AԲ   AԲ   AԲ   AԲm   AԲN   AԲ/   AԲ   AԲ   AԲ   AԲ   AԲ   AԲu   AԳ V   AԳ7   AԳ   AԳ   AԳ   AԳ   AԳ   AԳ}   AԳ^   AԳ?   AԳ	    AԳ
   AԳ
   AԳ   AԳ   AԳ
   AԳf   AԳG   AԳ(   AԳ	   AԳ   AԳ   AԳ   AԳ   AԳn   AԳO   AԳ0   AԳ   AԳ   AԳ   AԳ   AԳ   AԳv   AԳW   AԳ8   AԳ   AԳ   AԳ    AԳ!   AԳ"   AԳ#~   AԳ$_   AԳ%@   AԳ&!   AԳ'   AԳ'   AԳ(   AԳ)   AԳ*   AԳ+g   AԳ,H   AԳ-)   AԳ.
   AԳ.   AԳ/   AԳ0   AԳ1   AԳ2o   AԳ3P   AԳ41   AԳ5   AԳ5   AԳ6   AԳ7   AԳ8   AԳ9w   AԳ:X   AԳ;9   AԳ<   AԳ<   AԳ=   AԳ>   AԳ?   AԳ@   AԳA`   AԳBA   AԳC"   AԳD   AԳD   AԳE   AԳF   AԳG   AԳHh   AԳII   AԳJ*   AԳK   AԳK   AԳL   AԳM   AԳN   AԳOp   AԳPQ   AԳQ2   AԳR   AԳR   AԳS   AԳT   AԳU   AԳVx   AԳWY   AԳX:   AԳY   AԳY   AԳZ   AԳ[   AԳ\   AԳ]   AԳ^a   AԳ_B   AԳ`#   AԳa   AԳa   AԳb   AԳc   AԳd   AԳei   AԳfJ   AԳg+   AԳh   AԳh   AԳi   AԳj   AԳk   AԳlq   AԳmR   AԳn3   AԳo   AԳo   AԳp   AԳq   AԳr   AԳsy   AԳtZ   AԳu;   AԳv   AԳv   AԳw   AԳx   AԳy   AԳz   AԳ{b   AԳ|C   AԳ}$   AԳ~   AԳ~   AԳ   AԳ   AԳ   AԳj   AԳK   AԳ,   AԳ
   AԳ   AԳ   AԳ   AԳ   AԳr   AԳS   AԳ4   AԳ   AԳ   AԳ   AԳ   AԳ   AԳz   AԳ[   AԳ<   AԳ   AԳ   AԳ   AԳ   AԳ   AԳ   AԳc   AԳD   AԳ%   AԳ   AԳ   AԳ   AԳ   AԳ   AԳk   AԳL   AԳ-   AԳ   AԳ   AԳ   AԳ   AԳ   AԳs   AԳT   AԳ5   AԳ   AԳ   AԳ   AԳ   AԳ   AԳ{   AԳ\   AԳ=   AԳ   AԳ   AԳ   AԳ   AԳ   AԳ   AԳd   AԳE   AԳ&   AԳ   AԳ   AԳ   AԳ   AԳ   AԳl   AԳM   AԳ.   AԳ   AԳ   AԳ   AԳ   AԳ   AԳt   AԳU   AԳ6   AԳ   AԳ   AԳ   AԳȺ   AԳɛ   AԳ|   AԳ]   AԳ>   AԳ   AԳ    AԳ   AԳ   AԳУ   AԳф   AԳe   AԳF   AԳ'   AԳ   AԳ   AԳ   AԳ׫   AԳ،   AԳm   AԳN   AԳ/   AԳ   AԳ   AԳ   AԳ޳   AԳߔ   AԳu   AԳV   AԳ7   AԳ   AԳ   AԳ   AԳ   AԳ   AԳ}   AԳ^   AԳ?   AԳ    AԳ   AԳ   AԳ   AԳ   AԳ   AԳf   AԳG   AԳ(   AԳ	   AԳ   AԳ   AԳ   AԳ   AԳn   AԳO   AԳ0   AԳ   AԳ   AԳ   AԳ   AԳ   AԳv   AԳW   AԳ8   AԴ    AԴ    AԴ   AԴ   AԴ   AԴ~   AԴ_   AԴ@   AԴ!   AԴ   AԴ   AԴ	   AԴ
   AԴ   AԴg   AԴ
H   AԴ)   AԴ
   AԴ   AԴ   AԴ   AԴ   AԴo   AԴP   AԴ1   AԴ   AԴ   AԴ   AԴ   AԴ   AԴw   AԴX   AԴ9   AԴ   AԴ   AԴ   AԴ   AԴ    AԴ!   AԴ"`   AԴ#A   AԴ$"   AԴ%   AԴ%   AԴ&   AԴ'   AԴ(   AԴ)h   AԴ*I   AԴ+*   AԴ,   AԴ,   AԴ-   AԴ.   AԴ/   AԴ0p   AԴ1Q   AԴ22   AԴ3   AԴ3   AԴ4   AԴ5   AԴ6   AԴ7x   AԴ8Y   AԴ9:   AԴ:   AԴ:   AԴ;   AԴ<   AԴ=   AԴ>   AԴ?a   AԴ@B   AԴA#   AԴB   AԴB   AԴC   AԴD   AԴE   AԴFi   AԴGJ   AԴH+   AԴI   AԴI   AԴJ   AԴK   AԴL   AԴMq   AԴNR   AԴO3   AԴP   AԴP   AԴQ   AԴR   AԴS   AԴTy   AԴUZ   AԴV;   AԴW   AԴW   AԴX   AԴY   AԴZ   AԴ[   AԴ\b   AԴ]C   AԴ^$   AԴ_   AԴ_   AԴ`   AԴa   AԴb   AԴcj   AԴdK   AԴe,   AԴf
   AԴf   AԴg   AԴh   AԴi   AԴjr   AԴkS   AԴl4   AԴm   AԴm   AԴn   AԴo   AԴp   AԴqz   AԴr[   AԴs<   AԴt   AԴt   AԴu   AԴv   AԴw   AԴx   AԴyc   AԴzD   AԴ{%   AԴ|   AԴ|   AԴ}   AԴ~   AԴ   AԴk   AԴL   AԴ-   AԴ   AԴ   AԴ   AԴ   AԴ   AԴs   AԴT   AԴ5   AԴ   AԴ   AԴ   AԴ   AԴ   AԴ{   AԴ\   AԴ=   AԴ   AԴ   AԴ   AԴ   AԴ   AԴ   AԴd   AԴE   AԴ&   AԴ   AԴ   AԴ   AԴ   AԴ   AԴl   AԴM   AԴ.   AԴ   AԴ   AԴ   AԴ   AԴ   AԴt   AԴU   AԴ6   AԴ   AԴ   AԴ   AԴ   AԴ   AԴ|   AԴ]   AԴ>   AԴ   AԴ    AԴ   AԴ   AԴ   AԴ   AԴe   AԴF   AԴ'   AԴ   AԴ   AԴ   AԴ   AԴ   AԴm   AԴN   AԴ/   AԴ   AԴ   AԴ   AԴ   AԴ   AԴu   AԴV   AԴ7   AԴ   AԴ   AԴ   AԴƻ   AԴǜ   AԴ}   AԴ^   AԴ?   AԴ    AԴ   AԴ   AԴ   AԴΤ   AԴυ   AԴf   AԴG   AԴ(   AԴ	   AԴ   AԴ   AԴլ   AԴ֍   AԴn   AԴO   AԴ0   AԴ   AԴ   AԴ   AԴܴ   AԴݕ   AԴv   AԴW   AԴ8   AԴ   AԴ   AԴ   AԴ   AԴ   AԴ~   AԴ_   AԴ@   AԴ!   AԴ   AԴ   AԴ   AԴ   AԴ   AԴg   AԴH   AԴ)   AԴ
   AԴ   AԴ   AԴ   AԴ   AԴo   AԴP   AԴ1   AԴ   AԴ   AԴ   AԴ   AԴ   AԴw   AԴX   AԴ9   AԴ   AԴ   AԴ   AԵ    AԵ   AԵ   AԵ`   AԵA   AԵ"   AԵ   AԵ   AԵ   AԵ   AԵ	   AԵ
h   AԵI   AԵ*   AԵ
   AԵ
   AԵ   AԵ   AԵ   AԵp   AԵQ   AԵ2   AԵ   AԵ   AԵ   AԵ   AԵ   AԵx   AԵY   AԵ:   AԵ   AԵ   AԵ   AԵ   AԵ   AԵ   AԵ a   AԵ!B   AԵ"#   AԵ#   AԵ#   AԵ$   AԵ%   AԵ&   AԵ'i   AԵ(J   AԵ)+   AԵ*   AԵ*   AԵ+   AԵ,   AԵ-   AԵ.q   AԵ/R   AԵ03   AԵ1   AԵ1   AԵ2   AԵ3   AԵ4   AԵ5y   AԵ6Z   AԵ7;   AԵ8   AԵ8   AԵ9   AԵ:   AԵ;   AԵ<   AԵ=b   AԵ>C   AԵ?$   AԵ@   AԵ@   AԵA   AԵB   AԵC   AԵDj   AԵEK   AԵF,   AԵG
   AԵG   AԵH   AԵI   AԵJ   AԵKr   AԵLS   AԵM4   AԵN   AԵN   AԵO   AԵP   AԵQ   AԵRz   AԵS[   AԵT<   AԵU   AԵU   AԵV   AԵW   AԵX   AԵY   AԵZc   AԵ[D   AԵ\%   AԵ]   AԵ]   AԵ^   AԵ_   AԵ`   AԵak   AԵbL   AԵc-   AԵd   AԵd   AԵe   AԵf   AԵg   AԵhs   AԵiT   AԵj5   AԵk   AԵk   AԵl   AԵm   AԵn   AԵo{   AԵp\   AԵq=   AԵr   AԵr   AԵs   AԵt   AԵu   AԵv   AԵwd   AԵxE   AԵy&   AԵz   AԵz   AԵ{   AԵ|   AԵ}   AԵ~l   AԵM   AԵ.   AԵ   AԵ   AԵ   AԵ   AԵ   AԵt   AԵU   AԵ6   AԵ   AԵ   AԵ   AԵ   AԵ   AԵ|   AԵ]   AԵ>   AԵ   AԵ    AԵ   AԵ   AԵ   AԵ   AԵe   AԵF   AԵ'   AԵ   AԵ   AԵ   AԵ   AԵ   AԵm   AԵN   AԵ/   AԵ   AԵ   AԵ   AԵ   AԵ   AԵu   AԵV   AԵ7   AԵ   AԵ   AԵ   AԵ   AԵ   AԵ}   AԵ^   AԵ?   AԵ    AԵ   AԵ   AԵ   AԵ   AԵ   AԵf   AԵG   AԵ(   AԵ	   AԵ   AԵ   AԵ   AԵ   AԵn   AԵO   AԵ0   AԵ   AԵ   AԵ   AԵ   AԵ   AԵv   AԵW   AԵ8   AԵ   AԵ   AԵ   AԵļ   AԵŝ   AԵ~   AԵ_   AԵ@   AԵ!   AԵ   AԵ   AԵ   AԵ̥   AԵ͆   AԵg   AԵH   AԵ)   AԵ
   AԵ   AԵ   AԵӭ   AԵԎ   AԵo   AԵP   AԵ1   AԵ   AԵ   AԵ   AԵڵ   AԵۖ   AԵw   AԵX   AԵ9   AԵ   AԵ   AԵ   AԵ   AԵ   AԵ   AԵ`   AԵA   AԵ"   AԵ   AԵ   AԵ   AԵ   AԵ   AԵh   AԵI   AԵ*   AԵ   AԵ   AԵ   AԵ   AԵ   AԵp   AԵQ   AԵ2   AԵ   AԵ   AԵ   AԵ   AԵ   AԵx   AԵY   AԵ:   AԵ   AԵ   AԵ   AԵ   AԵ   AԶ    AԶa   AԶB   AԶ#   AԶ   AԶ   AԶ   AԶ   AԶ   AԶi   AԶ	J   AԶ
+   AԶ   AԶ   AԶ   AԶ
   AԶ   AԶq   AԶR   AԶ3   AԶ   AԶ   AԶ   AԶ   AԶ   AԶy   AԶZ   AԶ;   AԶ   AԶ   AԶ   AԶ   AԶ   AԶ   AԶb   AԶC   AԶ $   AԶ!   AԶ!   AԶ"   AԶ#   AԶ$   AԶ%j   AԶ&K   AԶ',   AԶ(
   AԶ(   AԶ)   AԶ*   AԶ+   AԶ,r   AԶ-S   AԶ.4   AԶ/   AԶ/   AԶ0   AԶ1   AԶ2   AԶ3z   AԶ4[   AԶ5<   AԶ6   AԶ6   AԶ7   AԶ8   AԶ9   AԶ:   AԶ;c   AԶ<D   AԶ=%   AԶ>   AԶ>   AԶ?   AԶ@   AԶA   AԶBk   AԶCL   AԶD-   AԶE   AԶE   AԶF   AԶG   AԶH   AԶIs   AԶJT   AԶK5   AԶL   AԶL   AԶM   AԶN   AԶO   AԶP{   AԶQ\   AԶR=   AԶS   AԶS   AԶT   AԶU   AԶV   AԶW   AԶXd   AԶYE   AԶZ&   AԶ[   AԶ[   AԶ\   AԶ]   AԶ^   AԶ_l   AԶ`M   AԶa.   AԶb   AԶb   AԶc   AԶd   AԶe   AԶft   AԶgU   AԶh6   AԶi   AԶi   AԶj   AԶk   AԶl   AԶm|   AԶn]   AԶo>   AԶp   AԶq    AԶq   AԶr   AԶs   AԶt   AԶue   AԶvF   AԶw'   AԶx   AԶx   AԶy   AԶz   AԶ{   AԶ|m   AԶ}N   AԶ~/   AԶ   AԶ   AԶ   AԶ   AԶ   AԶu   AԶV   AԶ7   AԶ   AԶ   AԶ   AԶ   AԶ   AԶ}   AԶ^   AԶ?   AԶ    AԶ   AԶ   AԶ   AԶ   AԶ   AԶf   AԶG   AԶ(   AԶ	   AԶ   AԶ   AԶ   AԶ   AԶn   AԶO   AԶ0   AԶ   AԶ   AԶ   AԶ   AԶ   AԶv   AԶW   AԶ8   AԶ   AԶ   AԶ   AԶ   AԶ   AԶ~   AԶ_   AԶ@   AԶ!   AԶ   AԶ   AԶ   AԶ   AԶ   AԶg   AԶH   AԶ)   AԶ
   AԶ   AԶ   AԶ   AԶ   AԶo   AԶP   AԶ1   AԶ   AԶ   AԶ   AԶ   AԶ   AԶw   AԶX   AԶ9   AԶ   AԶ   AԶ   AԶ½   AԶÞ   AԶ   AԶ`   AԶA   AԶ"   AԶ   AԶ   AԶ   AԶʦ   AԶˇ   AԶh   AԶI   AԶ*   AԶ   AԶ   AԶ   AԶѮ   AԶҏ   AԶp   AԶQ   AԶ2   AԶ   AԶ   AԶ   AԶض   AԶٗ   AԶx   AԶY   AԶ:   AԶ   AԶ   AԶ   AԶ߾   AԶ   AԶ   AԶa   AԶB   AԶ#   AԶ   AԶ   AԶ   AԶ   AԶ   AԶi   AԶJ   AԶ+   AԶ   AԶ   AԶ   AԶ   AԶ   AԶq   AԶR   AԶ3   AԶ   AԶ   AԶ   AԶ   AԶ   AԶy   AԶZ   AԶ;   AԶ   AԶ   AԶ   AԶ   AԶ   AԶ   AԶb   AԷ C   AԷ$   AԷ   AԷ   AԷ   AԷ   AԷ   AԷj   AԷK   AԷ,   AԷ	
   AԷ	   AԷ
   AԷ   AԷ   AԷ
r   AԷS   AԷ4   AԷ   AԷ   AԷ   AԷ   AԷ   AԷz   AԷ[   AԷ<   AԷ   AԷ   AԷ   AԷ   AԷ   AԷ   AԷc   AԷD   AԷ%   AԷ   AԷ   AԷ    AԷ!   AԷ"   AԷ#k   AԷ$L   AԷ%-   AԷ&   AԷ&   AԷ'   AԷ(   AԷ)   AԷ*s   AԷ+T   AԷ,5   AԷ-   AԷ-   AԷ.   AԷ/   AԷ0   AԷ1{   AԷ2\   AԷ3=   AԷ4   AԷ4   AԷ5   AԷ6   AԷ7   AԷ8   AԷ9d   AԷ:E   AԷ;&   AԷ<   AԷ<   AԷ=   AԷ>   AԷ?   AԷ@l   AԷAM   AԷB.   AԷC   AԷC   AԷD   AԷE   AԷF   AԷGt   AԷHU   AԷI6   AԷJ   AԷJ   AԷK   AԷL   AԷM   AԷN|   AԷO]   AԷP>   AԷQ   AԷR    AԷR   AԷS   AԷT   AԷU   AԷVe   AԷWF   AԷX'   AԷY   AԷY   AԷZ   AԷ[   AԷ\   AԷ]m   AԷ^N   AԷ_/   AԷ`   AԷ`   AԷa   AԷb   AԷc   AԷdu   AԷeV   AԷf7   AԷg   AԷg   AԷh   AԷi   AԷj   AԷk}   AԷl^   AԷm?   AԷn    AԷo   AԷo   AԷp   AԷq   AԷr   AԷsf   AԷtG   AԷu(   AԷv	   AԷv   AԷw   AԷx   AԷy   AԷzn   AԷ{O   AԷ|0   AԷ}   AԷ}   AԷ~   AԷ   AԷ   AԷv   AԷW   AԷ8   AԷ   AԷ   AԷ   AԷ   AԷ   AԷ~   AԷ_   AԷ@   AԷ!   AԷ   AԷ   AԷ   AԷ   AԷ   AԷg   AԷH   AԷ)   AԷ
   AԷ   AԷ   AԷ   AԷ   AԷo   AԷP   AԷ1   AԷ   AԷ   AԷ   AԷ   AԷ   AԷw   AԷX   AԷ9   AԷ   AԷ   AԷ   AԷ   AԷ   AԷ   AԷ`   AԷA   AԷ"   AԷ   AԷ   AԷ   AԷ   AԷ   AԷh   AԷI   AԷ*   AԷ   AԷ   AԷ   AԷ   AԷ   AԷp   AԷQ   AԷ2   AԷ   AԷ   AԷ   AԷ   AԷ   AԷx   AԷY   AԷ:   AԷ   AԷ   AԷ   AԷ   AԷ   AԷ   AԷa   AԷB   AԷ#   AԷ   AԷ   AԷ   AԷȧ   AԷɈ   AԷi   AԷJ   AԷ+   AԷ   AԷ   AԷ   AԷϯ   AԷА   AԷq   AԷR   AԷ3   AԷ   AԷ   AԷ   AԷַ   AԷט   AԷy   AԷZ   AԷ;   AԷ   AԷ   AԷ   AԷݿ   AԷޠ   AԷ߁   AԷb   AԷC   AԷ$   AԷ   AԷ   AԷ   AԷ   AԷ   AԷj   AԷK   AԷ,   AԷ
   AԷ   AԷ   AԷ   AԷ   AԷr   AԷS   AԷ4   AԷ   AԷ   AԷ   AԷ   AԷ   AԷz   AԷ[   AԷ<   AԷ   AԷ   AԷ   AԷ   AԷ   AԷ   AԷc   AԷD   AԷ%   AԸ    AԸ    AԸ   AԸ   AԸ   AԸk   AԸL   AԸ-   AԸ   AԸ   AԸ   AԸ	   AԸ
   AԸs   AԸT   AԸ
5   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ{   AԸ\   AԸ=   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ   AԸd   AԸE   AԸ&   AԸ   AԸ   AԸ   AԸ   AԸ    AԸ!l   AԸ"M   AԸ#.   AԸ$   AԸ$   AԸ%   AԸ&   AԸ'   AԸ(t   AԸ)U   AԸ*6   AԸ+   AԸ+   AԸ,   AԸ-   AԸ.   AԸ/|   AԸ0]   AԸ1>   AԸ2   AԸ3    AԸ3   AԸ4   AԸ5   AԸ6   AԸ7e   AԸ8F   AԸ9'   AԸ:   AԸ:   AԸ;   AԸ<   AԸ=   AԸ>m   AԸ?N   AԸ@/   AԸA   AԸA   AԸB   AԸC   AԸD   AԸEu   AԸFV   AԸG7   AԸH   AԸH   AԸI   AԸJ   AԸK   AԸL}   AԸM^   AԸN?   AԸO    AԸP   AԸP   AԸQ   AԸR   AԸS   AԸTf   AԸUG   AԸV(   AԸW	   AԸW   AԸX   AԸY   AԸZ   AԸ[n   AԸ\O   AԸ]0   AԸ^   AԸ^   AԸ_   AԸ`   AԸa   AԸbv   AԸcW   AԸd8   AԸe   AԸe   AԸf   AԸg   AԸh   AԸi~   AԸj_   AԸk@   AԸl!   AԸm   AԸm   AԸn   AԸo   AԸp   AԸqg   AԸrH   AԸs)   AԸt
   AԸt   AԸu   AԸv   AԸw   AԸxo   AԸyP   AԸz1   AԸ{   AԸ{   AԸ|   AԸ}   AԸ~   AԸw   AԸX   AԸ9   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ`   AԸA   AԸ"   AԸ   AԸ   AԸ   AԸ   AԸ   AԸh   AԸI   AԸ*   AԸ   AԸ   AԸ   AԸ   AԸ   AԸp   AԸQ   AԸ2   AԸ   AԸ   AԸ   AԸ   AԸ   AԸx   AԸY   AԸ:   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ   AԸa   AԸB   AԸ#   AԸ   AԸ   AԸ   AԸ   AԸ   AԸi   AԸJ   AԸ+   AԸ   AԸ   AԸ   AԸ   AԸ   AԸq   AԸR   AԸ3   AԸ   AԸ   AԸ   AԸ   AԸ   AԸy   AԸZ   AԸ;   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ   AԸb   AԸC   AԸ$   AԸ   AԸ   AԸ   AԸƨ   AԸǉ   AԸj   AԸK   AԸ,   AԸ
   AԸ   AԸ   AԸͰ   AԸΑ   AԸr   AԸS   AԸ4   AԸ   AԸ   AԸ   AԸԸ   AԸՙ   AԸz   AԸ[   AԸ<   AԸ   AԸ   AԸ   AԸ   AԸܡ   AԸ݂   AԸc   AԸD   AԸ%   AԸ   AԸ   AԸ   AԸ   AԸ   AԸk   AԸL   AԸ-   AԸ   AԸ   AԸ   AԸ   AԸ   AԸs   AԸT   AԸ5   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ{   AԸ\   AԸ=   AԸ   AԸ   AԸ   AԸ   AԸ   AԸ   AԸd   AԸE   AԸ&   AԸ   AԸ   AԸ   AԹ    AԹ   AԹl   AԹM   AԹ.   AԹ   AԹ   AԹ   AԹ   AԹ   AԹ	t   AԹ
U   AԹ6   AԹ   AԹ   AԹ
   AԹ   AԹ   AԹ|   AԹ]   AԹ>   AԹ   AԹ    AԹ   AԹ   AԹ   AԹ   AԹe   AԹF   AԹ'   AԹ   AԹ   AԹ   AԹ   AԹ   AԹm   AԹ N   AԹ!/   AԹ"   AԹ"   AԹ#   AԹ$   AԹ%   AԹ&u   AԹ'V   AԹ(7   AԹ)   AԹ)   AԹ*   AԹ+   AԹ,   AԹ-}   AԹ.^   AԹ/?   AԹ0    AԹ1   AԹ1   AԹ2   AԹ3   AԹ4   AԹ5f   AԹ6G   AԹ7(   AԹ8	   AԹ8   AԹ9   AԹ:   AԹ;   AԹ<n   AԹ=O   AԹ>0   AԹ?   AԹ?   AԹ@   AԹA   AԹB   AԹCv   AԹDW   AԹE8   AԹF   AԹF   AԹG   AԹH   AԹI   AԹJ~   AԹK_   AԹL@   AԹM!   AԹN   AԹN   AԹO   AԹP   AԹQ   AԹRg   AԹSH   AԹT)   AԹU
   AԹU   AԹV   AԹW   AԹX   AԹYo   AԹZP   AԹ[1   AԹ\   AԹ\   AԹ]   AԹ^   AԹ_   AԹ`w   AԹaX   AԹb9   AԹc   AԹc   AԹd   AԹe   AԹf   AԹg   AԹh`   AԹiA   AԹj"   AԹk   AԹk   AԹl   AԹm   AԹn   AԹoh   AԹpI   AԹq*   AԹr   AԹr   AԹs   AԹt   AԹu   AԹvp   AԹwQ   AԹx2   AԹy   AԹy   AԹz   AԹ{   AԹ|   AԹ}x   AԹ~Y   AԹ:   AԹ   AԹ   AԹ   AԹ   AԹ   AԹ   AԹa   AԹB   AԹ#   AԹ   AԹ   AԹ   AԹ   AԹ   AԹi   AԹJ   AԹ+   AԹ   AԹ   AԹ   AԹ   AԹ   AԹq   AԹR   AԹ3   AԹ   AԹ   AԹ   AԹ   AԹ   AԹy   AԹZ   AԹ;   AԹ   AԹ   AԹ   AԹ   AԹ   AԹ   AԹb   AԹC   AԹ$   AԹ   AԹ   AԹ   AԹ   AԹ   AԹj   AԹK   AԹ,   AԹ
   AԹ   AԹ   AԹ   AԹ   AԹr   AԹS   AԹ4   AԹ   AԹ   AԹ   AԹ   AԹ   AԹz   AԹ[   AԹ<   AԹ   AԹ   AԹ   AԹ   AԹ   AԹ   AԹc   AԹD   AԹ%   AԹ   AԹ   AԹ   AԹĩ   AԹŊ   AԹk   AԹL   AԹ-   AԹ   AԹ   AԹ   AԹ˱   AԹ̒   AԹs   AԹT   AԹ5   AԹ   AԹ   AԹ   AԹҹ   AԹӚ   AԹ{   AԹ\   AԹ=   AԹ   AԹ   AԹ   AԹ   AԹڢ   AԹۃ   AԹd   AԹE   AԹ&   AԹ   AԹ   AԹ   AԹ   AԹ   AԹl   AԹM   AԹ.   AԹ   AԹ   AԹ   AԹ   AԹ   AԹt   AԹU   AԹ6   AԹ   AԹ   AԹ   AԹ   AԹ   AԹ|   AԹ]   AԹ>   AԹ   AԹ    AԹ   AԹ   AԹ   AԹ   AԹe   AԹF   AԹ'   AԹ   AԹ   AԹ   AԹ   AԹ   AԺ m   AԺN   AԺ/   AԺ   AԺ   AԺ   AԺ   AԺ   AԺu   AԺV   AԺ	7   AԺ
   AԺ
   AԺ   AԺ   AԺ
   AԺ}   AԺ^   AԺ?   AԺ    AԺ   AԺ   AԺ   AԺ   AԺ   AԺf   AԺG   AԺ(   AԺ	   AԺ   AԺ   AԺ   AԺ   AԺn   AԺO   AԺ0   AԺ    AԺ    AԺ!   AԺ"   AԺ#   AԺ$v   AԺ%W   AԺ&8   AԺ'   AԺ'   AԺ(   AԺ)   AԺ*   AԺ+~   AԺ,_   AԺ-@   AԺ.!   AԺ/   AԺ/   AԺ0   AԺ1   AԺ2   AԺ3g   AԺ4H   AԺ5)   AԺ6
   AԺ6   AԺ7   AԺ8   AԺ9   AԺ:o   AԺ;P   AԺ<1   AԺ=   AԺ=   AԺ>   AԺ?   AԺ@   AԺAw   AԺBX   AԺC9   AԺD   AԺD   AԺE   AԺF   AԺG   AԺH   AԺI`   AԺJA   AԺK"   AԺL   AԺL   AԺM   AԺN   AԺO   AԺPh   AԺQI   AԺR*   AԺS   AԺS   AԺT   AԺU   AԺV   AԺWp   AԺXQ   AԺY2   AԺZ   AԺZ   AԺ[   AԺ\   AԺ]   AԺ^x   AԺ_Y   AԺ`:   AԺa   AԺa   AԺb   AԺc   AԺd   AԺe   AԺfa   AԺgB   AԺh#   AԺi   AԺi   AԺj   AԺk   AԺl   AԺmi   AԺnJ   AԺo+   AԺp   AԺp   AԺq   AԺr   AԺs   AԺtq   AԺuR   AԺv3   AԺw   AԺw   AԺx   AԺy   AԺz   AԺ{y   AԺ|Z   AԺ};   AԺ~   AԺ~   AԺ   AԺ   AԺ   AԺ   AԺb   AԺC   AԺ$   AԺ   AԺ   AԺ   AԺ   AԺ   AԺj   AԺK   AԺ,   AԺ
   AԺ   AԺ   AԺ   AԺ   AԺr   AԺS   AԺ4   AԺ   AԺ   AԺ   AԺ   AԺ   AԺz   AԺ[   AԺ<   AԺ   AԺ   AԺ   AԺ   AԺ   AԺ   AԺc   AԺD   AԺ%   AԺ   AԺ   AԺ   AԺ   AԺ   AԺk   AԺL   AԺ-   AԺ   AԺ   AԺ   AԺ   AԺ   AԺs   AԺT   AԺ5   AԺ   AԺ   AԺ   AԺ   AԺ   AԺ{   AԺ\   AԺ=   AԺ   AԺ   AԺ   AԺ   AԺ   AԺ   AԺd   AԺE   AԺ&   AԺ   AԺ   AԺ   AԺª   AԺË   AԺl   AԺM   AԺ.   AԺ   AԺ   AԺ   AԺɲ   AԺʓ   AԺt   AԺU   AԺ6   AԺ   AԺ   AԺ   AԺк   AԺћ   AԺ|   AԺ]   AԺ>   AԺ   AԺ    AԺ   AԺ   AԺأ   AԺل   AԺe   AԺF   AԺ'   AԺ   AԺ   AԺ   AԺ߫   AԺ   AԺm   AԺN   AԺ/   AԺ   AԺ   AԺ   AԺ   AԺ   AԺu   AԺV   AԺ7   AԺ   AԺ   AԺ   AԺ   AԺ   AԺ}   AԺ^   AԺ?   AԺ    AԺ   AԺ   AԺ   AԺ   AԺ   AԺf   AԺG   AԺ(   AԺ	   AԺ   AԺ   AԺ   AԺ   AԺn   AԺO   AԻ 0   AԻ   AԻ   AԻ   AԻ   AԻ   AԻv   AԻW   AԻ8   AԻ   AԻ   AԻ	   AԻ
   AԻ   AԻ~   AԻ
_   AԻ@   AԻ!   AԻ   AԻ   AԻ   AԻ   AԻ   AԻg   AԻH   AԻ)   AԻ
   AԻ   AԻ   AԻ   AԻ   AԻo   AԻP   AԻ1   AԻ   AԻ   AԻ   AԻ    AԻ!   AԻ"w   AԻ#X   AԻ$9   AԻ%   AԻ%   AԻ&   AԻ'   AԻ(   AԻ)   AԻ*`   AԻ+A   AԻ,"   AԻ-   AԻ-   AԻ.   AԻ/   AԻ0   AԻ1h   AԻ2I   AԻ3*   AԻ4   AԻ4   AԻ5   AԻ6   AԻ7   AԻ8p   AԻ9Q   AԻ:2   AԻ;   AԻ;   AԻ<   AԻ=   AԻ>   AԻ?x   AԻ@Y   AԻA:   AԻB   AԻB   AԻC   AԻD   AԻE   AԻF   AԻGa   AԻHB   AԻI#   AԻJ   AԻJ   AԻK   AԻL   AԻM   AԻNi   AԻOJ   AԻP+   AԻQ   AԻQ   AԻR   AԻS   AԻT   AԻUq   AԻVR   AԻW3   AԻX   AԻX   AԻY   AԻZ   AԻ[   AԻ\y   AԻ]Z   AԻ^;   AԻ_   AԻ_   AԻ`   AԻa   AԻb   AԻc   AԻdb   AԻeC   AԻf$   AԻg   AԻg   AԻh   AԻi   AԻj   AԻkj   AԻlK   AԻm,   AԻn
   AԻn   AԻo   AԻp   AԻq   AԻrr   AԻsS   AԻt4   AԻu   AԻu   AԻv   AԻw   AԻx   AԻyz   AԻz[   AԻ{<   AԻ|   AԻ|   AԻ}   AԻ~   AԻ   AԻ   AԻc   AԻD   AԻ%   AԻ   AԻ   AԻ   AԻ   AԻ   AԻk   AԻL   AԻ-   AԻ   AԻ   AԻ   AԻ   AԻ   AԻs   AԻT   AԻ5   AԻ   AԻ   AԻ   AԻ   AԻ   AԻ{   AԻ\   AԻ=   AԻ   AԻ   AԻ   AԻ   AԻ   AԻ   AԻd   AԻE   AԻ&   AԻ   AԻ   AԻ   AԻ   AԻ   AԻl   AԻM   AԻ.   AԻ   AԻ   AԻ   AԻ   AԻ   AԻt   AԻU   AԻ6   AԻ   AԻ   AԻ   AԻ   AԻ   AԻ|   AԻ]   AԻ>   AԻ   AԻ    AԻ   AԻ   AԻ   AԻ   AԻe   AԻF   AԻ'   AԻ   AԻ   AԻ   AԻ   AԻ   AԻm   AԻN   AԻ/   AԻ   AԻ   AԻ   AԻǳ   AԻȔ   AԻu   AԻV   AԻ7   AԻ   AԻ   AԻ   AԻλ   AԻϜ   AԻ}   AԻ^   AԻ?   AԻ    AԻ   AԻ   AԻ   AԻ֤   AԻׅ   AԻf   AԻG   AԻ(   AԻ	   AԻ   AԻ   AԻݬ   AԻލ   AԻn   AԻO   AԻ0   AԻ   AԻ   AԻ   AԻ   AԻ   AԻv   AԻW   AԻ8   AԻ   AԻ   AԻ   AԻ   AԻ   AԻ~   AԻ_   AԻ@   AԻ!   AԻ   AԻ   AԻ   AԻ   AԻ   AԻg   AԻH   AԻ)   AԻ
   AԻ   AԻ   AԻ   AԻ   AԻo   AԻP   AԻ1   AԻ   AԻ   AԼ    AԼ   AԼ   AԼw   AԼX   AԼ9   AԼ   AԼ   AԼ   AԼ   AԼ	   AԼ
   AԼ`   AԼA   AԼ
"   AԼ   AԼ   AԼ   AԼ   AԼ   AԼh   AԼI   AԼ*   AԼ   AԼ   AԼ   AԼ   AԼ   AԼp   AԼQ   AԼ2   AԼ   AԼ   AԼ   AԼ   AԼ   AԼ x   AԼ!Y   AԼ":   AԼ#   AԼ#   AԼ$   AԼ%   AԼ&   AԼ'   AԼ(a   AԼ)B   AԼ*#   AԼ+   AԼ+   AԼ,   AԼ-   AԼ.   AԼ/i   AԼ0J   AԼ1+   AԼ2   AԼ2   AԼ3   AԼ4   AԼ5   AԼ6q   AԼ7R   AԼ83   AԼ9   AԼ9   AԼ:   AԼ;   AԼ<   AԼ=y   AԼ>Z   AԼ?;   AԼ@   AԼ@   AԼA   AԼB   AԼC   AԼD   AԼEb   AԼFC   AԼG$   AԼH   AԼH   AԼI   AԼJ   AԼK   AԼLj   AԼMK   AԼN,   AԼO
   AԼO   AԼP   AԼQ   AԼR   AԼSr   AԼTS   AԼU4   AԼV   AԼV   AԼW   AԼX   AԼY   AԼZz   AԼ[[   AԼ\<   AԼ]   AԼ]   AԼ^   AԼ_   AԼ`   AԼa   AԼbc   AԼcD   AԼd%   AԼe   AԼe   AԼf   AԼg   AԼh   AԼik   AԼjL   AԼk-   AԼl   AԼl   AԼm   AԼn   AԼo   AԼps   AԼqT   AԼr5   AԼs   AԼs   AԼt   AԼu   AԼv   AԼw{   AԼx\   AԼy=   AԼz   AԼz   AԼ{   AԼ|   AԼ}   AԼ~   AԼd   AԼE   AԼ&   AԼ   AԼ   AԼ   AԼ   AԼ   AԼl   AԼM   AԼ.   AԼ   AԼ   AԼ   AԼ   AԼ   AԼt   AԼU   AԼ6   AԼ   AԼ   AԼ   AԼ   AԼ   AԼ|   AԼ]   AԼ>   AԼ   AԼ    AԼ   AԼ   AԼ   AԼ   AԼe   AԼF   AԼ'   AԼ   AԼ   AԼ   AԼ   AԼ   AԼm   AԼN   AԼ/   AԼ   AԼ   AԼ   AԼ   AԼ   AԼu   AԼV   AԼ7   AԼ   AԼ   AԼ   AԼ   AԼ   AԼ}   AԼ^   AԼ?   AԼ    AԼ   AԼ   AԼ   AԼ   AԼ   AԼf   AԼG   AԼ(   AԼ	   AԼ   AԼ   AԼ   AԼ   AԼn   AԼO   AԼ0   AԼ   AԼ   AԼ   AԼŴ   AԼƕ   AԼv   AԼW   AԼ8   AԼ   AԼ   AԼ   AԼ̼   AԼ͝   AԼ~   AԼ_   AԼ@   AԼ!   AԼ   AԼ   AԼ   AԼԥ   AԼՆ   AԼg   AԼH   AԼ)   AԼ
   AԼ   AԼ   AԼۭ   AԼ܎   AԼo   AԼP   AԼ1   AԼ   AԼ   AԼ   AԼ   AԼ   AԼw   AԼX   AԼ9   AԼ   AԼ   AԼ   AԼ   AԼ   AԼ   AԼ`   AԼA   AԼ"   AԼ   AԼ   AԼ   AԼ   AԼ   AԼh   AԼI   AԼ*   AԼ   AԼ   AԼ   AԼ   AԼ   AԼp   AԼQ   AԼ2   AԼ   AԼ   AԼ   AԼ   AԽ    AԽx   AԽY   AԽ:   AԽ   AԽ   AԽ   AԽ   AԽ   AԽ   AԽ	a   AԽ
B   AԽ#   AԽ   AԽ   AԽ
   AԽ   AԽ   AԽi   AԽJ   AԽ+   AԽ   AԽ   AԽ   AԽ   AԽ   AԽq   AԽR   AԽ3   AԽ   AԽ   AԽ   AԽ   AԽ   AԽy   AԽZ   AԽ ;   AԽ!   AԽ!   AԽ"   AԽ#   AԽ$   AԽ%   AԽ&b   AԽ'C   AԽ($   AԽ)   AԽ)   AԽ*   AԽ+   AԽ,   AԽ-j   AԽ.K   AԽ/,   AԽ0
   AԽ0   AԽ1   AԽ2   AԽ3   AԽ4r   AԽ5S   AԽ64   AԽ7   AԽ7   AԽ8   AԽ9   AԽ:   AԽ;z   AԽ<[   AԽ=<   AԽ>   AԽ>   AԽ?   AԽ@   AԽA   AԽB   AԽCc   AԽDD   AԽE%   AԽF   AԽF   AԽG   AԽH   AԽI   AԽJk   AԽKL   AԽL-   AԽM   AԽM   AԽN   AԽO   AԽP   AԽQs   AԽRT   AԽS5   AԽT   AԽT   AԽU   AԽV   AԽW   AԽX{   AԽY\   AԽZ=   AԽ[   AԽ[   AԽ\   AԽ]   AԽ^   AԽ_   AԽ`d   AԽaE   AԽb&   AԽc   AԽc   AԽd   AԽe   AԽf   AԽgl   AԽhM   AԽi.   AԽj   AԽj   AԽk   AԽl   AԽm   AԽnt   AԽoU   AԽp6   AԽq   AԽq   AԽr   AԽs   AԽt   AԽu|   AԽv]   AԽw>   AԽx   AԽy    AԽy   AԽz   AԽ{   AԽ|   AԽ}e   AԽ~F   AԽ'   AԽ   AԽ   AԽ   AԽ   AԽ   AԽm   AԽN   AԽ/   AԽ   AԽ   AԽ   AԽ   AԽ   AԽu   AԽV   AԽ7   AԽ   AԽ   AԽ   AԽ   AԽ   AԽ}   AԽ^   AԽ?   AԽ    AԽ   AԽ   AԽ   AԽ   AԽ   AԽf   AԽG   AԽ(   AԽ	   AԽ   AԽ   AԽ   AԽ   AԽn   AԽO   AԽ0   AԽ   AԽ   AԽ   AԽ   AԽ   AԽv   AԽW   AԽ8   AԽ   AԽ   AԽ   AԽ   AԽ   AԽ~   AԽ_   AԽ@   AԽ!   AԽ   AԽ   AԽ   AԽ   AԽ   AԽg   AԽH   AԽ)   AԽ
   AԽ   AԽ   AԽ   AԽ   AԽo   AԽP   AԽ1   AԽ   AԽ   AԽ   AԽõ   AԽĖ   AԽw   AԽX   AԽ9   AԽ   AԽ   AԽ   AԽʽ   AԽ˞   AԽ   AԽ`   AԽA   AԽ"   AԽ   AԽ   AԽ   AԽҦ   AԽӇ   AԽh   AԽI   AԽ*   AԽ   AԽ   AԽ   AԽٮ   AԽڏ   AԽp   AԽQ   AԽ2   AԽ   AԽ   AԽ   AԽ   AԽ   AԽx   AԽY   AԽ:   AԽ   AԽ   AԽ   AԽ   AԽ   AԽ   AԽa   AԽB   AԽ#   AԽ   AԽ   AԽ   AԽ   AԽ   AԽi   AԽJ   AԽ+   AԽ   AԽ   AԽ   AԽ   AԽ   AԽq   AԽR   AԽ3   AԽ   AԽ   AԽ   AԽ   AԽ   AԽy   AԾ Z   AԾ;   AԾ   AԾ   AԾ   AԾ   AԾ   AԾ   AԾb   AԾC   AԾ	$   AԾ
   AԾ
   AԾ   AԾ   AԾ
   AԾj   AԾK   AԾ,   AԾ
   AԾ   AԾ   AԾ   AԾ   AԾr   AԾS   AԾ4   AԾ   AԾ   AԾ   AԾ   AԾ   AԾz   AԾ[   AԾ<   AԾ   AԾ   AԾ    AԾ!   AԾ"   AԾ#   AԾ$c   AԾ%D   AԾ&%   AԾ'   AԾ'   AԾ(   AԾ)   AԾ*   AԾ+k   AԾ,L   AԾ--   AԾ.   AԾ.   AԾ/   AԾ0   AԾ1   AԾ2s   AԾ3T   AԾ45   AԾ5   AԾ5   AԾ6   AԾ7   AԾ8   AԾ9{   AԾ:\   AԾ;=   AԾ<   AԾ<   AԾ=   AԾ>   AԾ?   AԾ@   AԾAd   AԾBE   AԾC&   AԾD   AԾD   AԾE   AԾF   AԾG   AԾHl   AԾIM   AԾJ.   AԾK   AԾK   AԾL   AԾM   AԾN   AԾOt   AԾPU   AԾQ6   AԾR   AԾR   AԾS   AԾT   AԾU   AԾV|   AԾW]   AԾX>   AԾY   AԾZ    AԾZ   AԾ[   AԾ\   AԾ]   AԾ^e   AԾ_F   AԾ`'   AԾa   AԾa   AԾb   AԾc   AԾd   AԾem   AԾfN   AԾg/   AԾh   AԾh   AԾi   AԾj   AԾk   AԾlu   AԾmV   AԾn7   AԾo   AԾo   AԾp   AԾq   AԾr   AԾs}   AԾt^   AԾu?   AԾv    AԾw   AԾw   AԾx   AԾy   AԾz   AԾ{f   AԾ|G   AԾ}(   AԾ~	   AԾ~   AԾ   AԾ   AԾ   AԾn   AԾO   AԾ0   AԾ   AԾ   AԾ   AԾ   AԾ   AԾv   AԾW   AԾ8   AԾ   AԾ   AԾ   AԾ   AԾ   AԾ~   AԾ_   AԾ@   AԾ!   AԾ   AԾ   AԾ   AԾ   AԾ   AԾg   AԾH   AԾ)   AԾ
   AԾ   AԾ   AԾ   AԾ   AԾo   AԾP   AԾ1   AԾ   AԾ   AԾ   AԾ   AԾ   AԾw   AԾX   AԾ9   AԾ   AԾ   AԾ   AԾ   AԾ   AԾ   AԾ`   AԾA   AԾ"   AԾ   AԾ   AԾ   AԾ   AԾ   AԾh   AԾI   AԾ*   AԾ   AԾ   AԾ   AԾ   AԾ   AԾp   AԾQ   AԾ2   AԾ   AԾ   AԾ   AԾ   AԾ   AԾx   AԾY   AԾ:   AԾ   AԾ   AԾ   AԾȾ   AԾɟ   AԾʀ   AԾa   AԾB   AԾ#   AԾ   AԾ   AԾ   AԾЧ   AԾш   AԾi   AԾJ   AԾ+   AԾ   AԾ   AԾ   AԾׯ   AԾؐ   AԾq   AԾR   AԾ3   AԾ   AԾ   AԾ   AԾ޷   AԾߘ   AԾy   AԾZ   AԾ;   AԾ   AԾ   AԾ   AԾ   AԾ   AԾ   AԾb   AԾC   AԾ$   AԾ   AԾ   AԾ   AԾ   AԾ   AԾj   AԾK   AԾ,   AԾ
   AԾ   AԾ   AԾ   AԾ   AԾr   AԾS   AԾ4   AԾ   AԾ   AԾ   AԾ   AԾ   AԾz   AԾ[   AԾ<   AԿ    AԿ    AԿ   AԿ   AԿ   AԿ   AԿc   AԿD   AԿ%   AԿ   AԿ   AԿ	   AԿ
   AԿ   AԿk   AԿ
L   AԿ-   AԿ   AԿ   AԿ   AԿ   AԿ   AԿs   AԿT   AԿ5   AԿ   AԿ   AԿ   AԿ   AԿ   AԿ{   AԿ\   AԿ=   AԿ   AԿ   AԿ   AԿ   AԿ    AԿ!   AԿ"d   AԿ#E   AԿ$&   AԿ%   AԿ%   AԿ&   AԿ'   AԿ(   AԿ)l   AԿ*M   AԿ+.   AԿ,   AԿ,   AԿ-   AԿ.   AԿ/   AԿ0t   AԿ1U   AԿ26   AԿ3   AԿ3   AԿ4   AԿ5   AԿ6   AԿ7|   AԿ8]   AԿ9>   AԿ:   AԿ;    AԿ;   AԿ<   AԿ=   AԿ>   AԿ?e   AԿ@F   AԿA'   AԿB   AԿB   AԿC   AԿD   AԿE   AԿFm   AԿGN   AԿH/   AԿI   AԿI   AԿJ   AԿK   AԿL   AԿMu   AԿNV   AԿO7   AԿP   AԿP   AԿQ   AԿR   AԿS   AԿT}   AԿU^   AԿV?   AԿW    AԿX   AԿX   AԿY   AԿZ   AԿ[   AԿ\f   AԿ]G   AԿ^(   AԿ_	   AԿ_   AԿ`   AԿa   AԿb   AԿcn   AԿdO   AԿe0   AԿf   AԿf   AԿg   AԿh   AԿi   AԿjv   AԿkW   AԿl8   AԿm   AԿm   AԿn   AԿo   AԿp   AԿq~   AԿr_   AԿs@   AԿt!   AԿu   AԿu   AԿv   AԿw   AԿx   AԿyg   AԿzH   AԿ{)   AԿ|
   AԿ|   AԿ}   AԿ~   AԿ   AԿo   AԿP   AԿ1   AԿ   AԿ   AԿ   AԿ   AԿ   AԿw   AԿX   AԿ9   AԿ   AԿ   AԿ   AԿ   AԿ   AԿ   AԿ`   AԿA   AԿ"   AԿ   AԿ   AԿ   AԿ   AԿ   AԿh   AԿI   AԿ*   AԿ   AԿ   AԿ   AԿ   AԿ   AԿp   AԿQ   AԿ2   AԿ   AԿ   AԿ   AԿ   AԿ   AԿx   AԿY   AԿ:   AԿ   AԿ   AԿ   AԿ   AԿ   AԿ   AԿa   AԿB   AԿ#   AԿ   AԿ   AԿ   AԿ   AԿ   AԿi   AԿJ   AԿ+   AԿ   AԿ   AԿ   AԿ   AԿ   AԿq   AԿR   AԿ3   AԿ   AԿ   AԿ   AԿ   AԿ   AԿy   AԿZ   AԿ;   AԿ   AԿ   AԿ   AԿƿ   AԿǠ   AԿȁ   AԿb   AԿC   AԿ$   AԿ   AԿ   AԿ   AԿΨ   AԿω   AԿj   AԿK   AԿ,   AԿ
   AԿ   AԿ   AԿհ   AԿ֑   AԿr   AԿS   AԿ4   AԿ   AԿ   AԿ   AԿܸ   AԿݙ   AԿz   AԿ[   AԿ<   AԿ   AԿ   AԿ   AԿ   AԿ   AԿ   AԿc   AԿD   AԿ%   AԿ   AԿ   AԿ   AԿ   AԿ   AԿk   AԿL   AԿ-   AԿ   AԿ   AԿ   AԿ   AԿ   AԿs   AԿT   AԿ5   AԿ   AԿ   AԿ   AԿ   AԿ   AԿ{   AԿ\   AԿ=   AԿ   AԿ   AԿ   A    A   A   Ad   AE   A&   A   A   A   A   A	   A
l   AM   A.   A
   A
   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   A e   A!F   A"'   A#   A#   A$   A%   A&   A'm   A(N   A)/   A*   A*   A+   A,   A-   A.u   A/V   A07   A1   A1   A2   A3   A4   A5}   A6^   A7?   A8    A9   A9   A:   A;   A<   A=f   A>G   A?(   A@	   A@   AA   AB   AC   ADn   AEO   AF0   AG   AG   AH   AI   AJ   AKv   ALW   AM8   AN   AN   AO   AP   AQ   AR~   AS_   AT@   AU!   AV   AV   AW   AX   AY   AZg   A[H   A\)   A]
   A]   A^   A_   A`   Aao   AbP   Ac1   Ad   Ad   Ae   Af   Ag   Ahw   AiX   Aj9   Ak   Ak   Al   Am   An   Ao   Ap`   AqA   Ar"   As   As   At   Au   Av   Awh   AxI   Ay*   Az   Az   A{   A|   A}   A~p   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aš   AƂ   Ac   AD   A%   A   A   A   A̩   A͊   Ak   AL   A-   A   A   A   Aӱ   AԒ   As   AT   A5   A   A   A   Aڹ   Aۚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A    Ae   AF   A'   A   A   A   A   A   Am   A	N   A
/   A   A   A   A
   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A (   A!	   A!   A"   A#   A$   A%n   A&O   A'0   A(   A(   A)   A*   A+   A,v   A-W   A.8   A/   A/   A0   A1   A2   A3~   A4_   A5@   A6!   A7   A7   A8   A9   A:   A;g   A<H   A=)   A>
   A>   A?   A@   AA   ABo   ACP   AD1   AE   AE   AF   AG   AH   AIw   AJX   AK9   AL   AL   AM   AN   AO   AP   AQ`   ARA   AS"   AT   AT   AU   AV   AW   AXh   AYI   AZ*   A[   A[   A\   A]   A^   A_p   A`Q   Aa2   Ab   Ab   Ac   Ad   Ae   Afx   AgY   Ah:   Ai   Ai   Aj   Ak   Al   Am   Ana   AoB   Ap#   Aq   Aq   Ar   As   At   Aui   AvJ   Aw+   Ax   Ax   Ay   Az   A{   A|q   A}R   A~3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   Aâ   Aă   Ad   AE   A&   A   A   A   Aʪ   Aˋ   Al   AM   A.   A   A   A   AѲ   Aғ   At   AU   A6   A   A   A   Aغ   Aٛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   A G   A(   A	   A   A   A   A   An   AO   A0   A	   A	   A
   A   A   A
v   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A    A!   A"   A#o   A$P   A%1   A&   A&   A'   A(   A)   A*w   A+X   A,9   A-   A-   A.   A/   A0   A1   A2`   A3A   A4"   A5   A5   A6   A7   A8   A9h   A:I   A;*   A<   A<   A=   A>   A?   A@p   AAQ   AB2   AC   AC   AD   AE   AF   AGx   AHY   AI:   AJ   AJ   AK   AL   AM   AN   AOa   APB   AQ#   AR   AR   AS   AT   AU   AVi   AWJ   AX+   AY   AY   AZ   A[   A\   A]q   A^R   A_3   A`   A`   Aa   Ab   Ac   Ady   AeZ   Af;   Ag   Ag   Ah   Ai   Aj   Ak   Alb   AmC   An$   Ao   Ao   Ap   Aq   Ar   Asj   AtK   Au,   Av
   Av   Aw   Ax   Ay   Azr   A{S   A|4   A}   A}   A~   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A =   A¡   A¡   A¢   A£   A¤   A¥   A¦d   A§E   A¨&   A©   A©   Aª   A«   A¬   A­l   A®M   A¯.   A°   A°   A±   A²   A³   A´t   AµU   A¶6   A·   A·   A¸   A¹   Aº   A»|   A¼]   A½>   A¾   A¿    A¿   A   A   A   Ae   AF   A'   Ai   Ai   Aj   Ak   Al   Amm   AnN   Ao/   Ap   Ap   Aq   Ar   As   Atu   AuV   Av7   Aw   Aw   Ax   Ay   Az   A{}   A|^   A}?   A~    A   A   Aŀ   AŁ   Ał   AŃf   AńG   AŅ(   Aņ	   Aņ   AŇ   Aň   Aŉ   AŊn   AŋO   AŌ0   Aō   Aō   AŎ   Aŏ   AŐ   Aőv   AŒW   Aœ8   AŔ   AŔ   Aŕ   AŖ   Aŗ   AŘ~   Ař_   AŚ@   Aś!   AŜ   AŜ   Aŝ   AŞ   Aş   AŠg   AšH   AŢ)   Aţ
   Aţ   AŤ   Ať   AŦ   Aŧo   AŨP   Aũ1   AŪ   AŪ   Aū   AŬ   Aŭ   AŮw   AůX   AŰ9   Aű   Aű   AŲ   Aų   AŴ   Aŵ   AŶ`   AŷA   AŸ"   AŹ   AŹ   Aź   AŻ   Aż   AŽh   AžI   Aſ*   A   A   A   A®   AÏ   Ap   AQ   A2   A   A   A   Aɶ   Aʗ   Ax   AY   A:   A   A   A   Aо   Aџ   AҀ   Aa   AB   A#   A   A   A   Aا   Aو   Ai   AJ   A+   A   A   A   A߯   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A 4   A   A   A   A   A   Az   A[   A<   A   A   A	   A
   A   A   A
c   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A    A!   A"{   A#\   A$=   A%   A%   A&   A'   A(   A)   A*d   A+E   A,&   A-   A-   A.   A/   A0   A1l   A2M   A3.   A4   A4   A5   A6   A7   A8t   A9U   A:6   A;   A;   A<   A=   A>   A?|   A@]   AA>   AB   AC    AC   AD   AE   AF   AGe   AHF   AI'   AJ   AJ   AK   AL   AM   ANm   AON   AP/   AQ   AQ   AR   AS   AT   AUu   AVV   AW7   AX   AX   AY   AZ   A[   A\}   A]^   A^?   A_    A`   A`   Aa   Ab   Ac   Adf   AeG   Af(   Ag	   Ag   Ah   Ai   Aj   Akn   AlO   Am0   An   An   Ao   Ap   Aq   Arv   AsW   At8   Au   Au   Av   Aw   Ax   Ay~   Az_   A{@   A|!   A}   A}   A~   A   Aƀ   AƁg   AƂH   Aƃ)   AƄ
   AƄ   Aƅ   AƆ   AƇ   Aƈo   AƉP   AƊ1   AƋ   AƋ   Aƌ   Aƍ   AƎ   AƏw   AƐX   AƑ9   Aƒ   Aƒ   AƓ   AƔ   Aƕ   AƖ   AƗ`   AƘA   Aƙ"   Aƚ   Aƚ   Aƛ   AƜ   AƝ   Aƞh   AƟI   AƠ*   Aơ   Aơ   AƢ   Aƣ   AƤ   Aƥp   AƦQ   AƧ2   Aƨ   Aƨ   AƩ   Aƪ   Aƫ   AƬx   AƭY   AƮ:   AƯ   AƯ   Aư   AƱ   AƲ   AƳ   Aƴa   AƵB   Aƶ#   AƷ   AƷ   AƸ   Aƹ   Aƺ   Aƻi   AƼJ   Aƽ+   Aƾ   Aƾ   Aƿ   A   A   Aq   AR   A3   A   A   A   AǷ   AȘ   Ay   AZ   A;   A   A   A   Aο   AϠ   AЁ   Ab   AC   A$   A   A   A   A֨   A׉   Aj   AK   A,   A
   A   A   Aݰ   Aޑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A    A   A   A{   A\   A=   A   A   A   A   A	   A
   Ad   AE   A
&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A |   A!]   A">   A#   A$    A$   A%   A&   A'   A(e   A)F   A*'   A+   A+   A,   A-   A.   A/m   A0N   A1/   A2   A2   A3   A4   A5   A6u   A7V   A87   A9   A9   A:   A;   A<   A=}   A>^   A??   A@    AA   AA   AB   AC   AD   AEf   AFG   AG(   AH	   AH   AI   AJ   AK   ALn   AMO   AN0   AO   AO   AP   AQ   AR   ASv   ATW   AU8   AV   AV   AW   AX   AY   AZ~   A[_   A\@   A]!   A^   A^   A_   A`   Aa   Abg   AcH   Ad)   Ae
   Ae   Af   Ag   Ah   Aio   AjP   Ak1   Al   Al   Am   An   Ao   Apw   AqX   Ar9   As   As   At   Au   Av   Aw   Ax`   AyA   Az"   A{   A{   A|   A}   A~   Ah   AǀI   Aǁ*   Aǂ   Aǂ   Aǃ   AǄ   Aǅ   Aǆp   AǇQ   Aǈ2   Aǉ   Aǉ   AǊ   Aǋ   Aǌ   AǍx   AǎY   AǏ:   Aǐ   Aǐ   AǑ   Aǒ   AǓ   Aǔ   AǕa   AǖB   AǗ#   Aǘ   Aǘ   AǙ   Aǚ   AǛ   Aǜi   AǝJ   AǞ+   Aǟ   Aǟ   AǠ   Aǡ   AǢ   Aǣq   AǤR   Aǥ3   AǦ   AǦ   Aǧ   AǨ   Aǩ   AǪy   AǫZ   AǬ;   Aǭ   Aǭ   AǮ   Aǯ   Aǰ   AǱ   Aǲb   AǳC   AǴ$   Aǵ   Aǵ   AǶ   AǷ   AǸ   Aǹj   AǺK   Aǻ,   AǼ
   AǼ   Aǽ   AǾ   Aǿ   Ar   AS   A4   A   A   A   AŸ   Aƙ   Az   A[   A<   A   A   A   A   A͡   A΂   Ac   AD   A%   A   A   A   Aԩ   AՊ   Ak   AL   A-   A   A   A   A۱   Aܒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A    A|   A]   A>   A   A    A   A   A   A   A	e   A
F   A'   A   A   A
   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A ?   A!    A"   A"   A#   A$   A%   A&f   A'G   A((   A)	   A)   A*   A+   A,   A-n   A.O   A/0   A0   A0   A1   A2   A3   A4v   A5W   A68   A7   A7   A8   A9   A:   A;~   A<_   A=@   A>!   A?   A?   A@   AA   AB   ACg   ADH   AE)   AF
   AF   AG   AH   AI   AJo   AKP   AL1   AM   AM   AN   AO   AP   AQw   ARX   AS9   AT   AT   AU   AV   AW   AX   AY`   AZA   A["   A\   A\   A]   A^   A_   A`h   AaI   Ab*   Ac   Ac   Ad   Ae   Af   Agp   AhQ   Ai2   Aj   Aj   Ak   Al   Am   Anx   AoY   Ap:   Aq   Aq   Ar   As   At   Au   Ava   AwB   Ax#   Ay   Ay   Az   A{   A|   A}i   A~J   A+   AȀ   AȀ   Aȁ   AȂ   Aȃ   AȄq   AȅR   AȆ3   Aȇ   Aȇ   AȈ   Aȉ   AȊ   Aȋy   AȌZ   Aȍ;   AȎ   AȎ   Aȏ   AȐ   Aȑ   AȒ   Aȓb   AȔC   Aȕ$   AȖ   AȖ   Aȗ   AȘ   Aș   AȚj   AțK   AȜ,   Aȝ
   Aȝ   AȞ   Aȟ   AȠ   Aȡr   AȢS   Aȣ4   AȤ   AȤ   Aȥ   AȦ   Aȧ   AȨz   Aȩ[   AȪ<   Aȫ   Aȫ   AȬ   Aȭ   AȮ   Aȯ   AȰc   AȱD   AȲ%   Aȳ   Aȳ   Aȴ   Aȵ   Aȶ   Aȷk   AȸL   Aȹ-   AȺ   AȺ   AȻ   Aȼ   AȽ   AȾs   AȿT   A5   A   A   A   Aù   AĚ   A{   A\   A=   A   A   A   A   Aˢ   Ã   Ad   AE   A&   A   A   A   AҪ   AӋ   Al   AM   A.   A   A   A   Aٲ   Aړ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A ^   A?   A    A   A   A   A   A   Af   AG   A	(   A
	   A
   A   A   A
   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A    A    A!   A"   A#   A$g   A%H   A&)   A'
   A'   A(   A)   A*   A+o   A,P   A-1   A.   A.   A/   A0   A1   A2w   A3X   A49   A5   A5   A6   A7   A8   A9   A:`   A;A   A<"   A=   A=   A>   A?   A@   AAh   ABI   AC*   AD   AD   AE   AF   AG   AHp   AIQ   AJ2   AK   AK   AL   AM   AN   AOx   APY   AQ:   AR   AR   AS   AT   AU   AV   AWa   AXB   AY#   AZ   AZ   A[   A\   A]   A^i   A_J   A`+   Aa   Aa   Ab   Ac   Ad   Aeq   AfR   Ag3   Ah   Ah   Ai   Aj   Ak   Aly   AmZ   An;   Ao   Ao   Ap   Aq   Ar   As   Atb   AuC   Av$   Aw   Aw   Ax   Ay   Az   A{j   A|K   A},   A~
   A~   A   Aɀ   AɁ   Aɂr   AɃS   AɄ4   AɅ   AɅ   AɆ   Aɇ   AɈ   Aɉz   AɊ[   Aɋ<   AɌ   AɌ   Aɍ   AɎ   Aɏ   Aɐ   Aɑc   AɒD   Aɓ%   Aɔ   Aɔ   Aɕ   Aɖ   Aɗ   Aɘk   AəL   Aɚ-   Aɛ   Aɛ   Aɜ   Aɝ   Aɞ   Aɟs   AɠT   Aɡ5   Aɢ   Aɢ   Aɣ   Aɤ   Aɥ   Aɦ{   Aɧ\   Aɨ=   Aɩ   Aɩ   Aɪ   Aɫ   Aɬ   Aɭ   Aɮd   AɯE   Aɰ&   Aɱ   Aɱ   Aɲ   Aɳ   Aɴ   Aɵl   AɶM   Aɷ.   Aɸ   Aɸ   Aɹ   Aɺ   Aɻ   Aɼt   AɽU   Aɾ6   Aɿ   Aɿ   A   A   A   A|   A]   A>   A   A    A   A   Aɣ   Aʄ   Ae   AF   A'   A   A   A   AЫ   Aь   Am   AN   A/   A   A   A   A׳   Aؔ   Au   AV   A7   A   A   A   A޻   Aߜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A !   A   A   A   A   A   Ag   AH   A)   A
   A   A	   A
   A   Ao   A
P   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A    A!   A"h   A#I   A$*   A%   A%   A&   A'   A(   A)p   A*Q   A+2   A,   A,   A-   A.   A/   A0x   A1Y   A2:   A3   A3   A4   A5   A6   A7   A8a   A9B   A:#   A;   A;   A<   A=   A>   A?i   A@J   AA+   AB   AB   AC   AD   AE   AFq   AGR   AH3   AI   AI   AJ   AK   AL   AMy   ANZ   AO;   AP   AP   AQ   AR   AS   AT   AUb   AVC   AW$   AX   AX   AY   AZ   A[   A\j   A]K   A^,   A_
   A_   A`   Aa   Ab   Acr   AdS   Ae4   Af   Af   Ag   Ah   Ai   Ajz   Ak[   Al<   Am   Am   An   Ao   Ap   Aq   Arc   AsD   At%   Au   Au   Av   Aw   Ax   Ayk   AzL   A{-   A|   A|   A}   A~   A   Aʀs   AʁT   Aʂ5   Aʃ   Aʃ   Aʄ   Aʅ   Aʆ   Aʇ{   Aʈ\   Aʉ=   Aʊ   Aʊ   Aʋ   Aʌ   Aʍ   Aʎ   Aʏd   AʐE   Aʑ&   Aʒ   Aʒ   Aʓ   Aʔ   Aʕ   Aʖl   AʗM   Aʘ.   Aʙ   Aʙ   Aʚ   Aʛ   Aʜ   Aʝt   AʞU   Aʟ6   Aʠ   Aʠ   Aʡ   Aʢ   Aʣ   Aʤ|   Aʥ]   Aʦ>   Aʧ   Aʨ    Aʨ   Aʩ   Aʪ   Aʫ   Aʬe   AʭF   Aʮ'   Aʯ   Aʯ   Aʰ   Aʱ   Aʲ   Aʳm   AʴN   Aʵ/   Aʶ   Aʶ   Aʷ   Aʸ   Aʹ   Aʺu   AʻV   Aʼ7   Aʽ   Aʽ   Aʾ   Aʿ   A   A}   A^   A?   A    A   A   A   AǤ   Aȅ   Af   AG   A(   A	   A   A   Aά   Aύ   An   AO   A0   A   A   A   Aմ   A֕   Av   AW   A8   A   A   A   Aܼ   Aݝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A    A   A   Ah   AI   A*   A   A   A   A   A	   A
p   AQ   A2   A
   A
   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   A i   A!J   A"+   A#   A#   A$   A%   A&   A'q   A(R   A)3   A*   A*   A+   A,   A-   A.y   A/Z   A0;   A1   A1   A2   A3   A4   A5   A6b   A7C   A8$   A9   A9   A:   A;   A<   A=j   A>K   A?,   A@
   A@   AA   AB   AC   ADr   AES   AF4   AG   AG   AH   AI   AJ   AKz   AL[   AM<   AN   AN   AO   AP   AQ   AR   ASc   ATD   AU%   AV   AV   AW   AX   AY   AZk   A[L   A\-   A]   A]   A^   A_   A`   Aas   AbT   Ac5   Ad   Ad   Ae   Af   Ag   Ah{   Ai\   Aj=   Ak   Ak   Al   Am   An   Ao   Apd   AqE   Ar&   As   As   At   Au   Av   Awl   AxM   Ay.   Az   Az   A{   A|   A}   A~t   AU   Aˀ6   Aˁ   Aˁ   A˂   A˃   A˄   A˅|   Aˆ]   Aˇ>   Aˈ   Aˉ    Aˉ   Aˊ   Aˋ   Aˌ   Aˍe   AˎF   Aˏ'   Aː   Aː   Aˑ   A˒   A˓   A˔m   A˕N   A˖/   A˗   A˗   A˘   A˙   A˚   A˛u   A˜V   A˝7   A˞   A˞   A˟   Aˠ   Aˡ   Aˢ}   Aˣ^   Aˤ?   A˥    A˦   A˦   A˧   A˨   A˩   A˪f   A˫G   Aˬ(   A˭	   A˭   Aˮ   A˯   A˰   A˱n   A˲O   A˳0   A˴   A˴   A˵   A˶   A˷   A˸v   A˹W   A˺8   A˻   A˻   A˼   A˽   A˾   A˿~   A_   A@   A!   A   A   A   Ať   AƆ   Ag   AH   A)   A
   A   A   A̭   A͎   Ao   AP   A1   A   A   A   Aӵ   AԖ   Aw   AX   A9   A   A   A   Aڽ   A۞   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A    Ai   AJ   A+   A   A   A   A   A   Aq   A	R   A
3   A   A   A   A
   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A ,   A!
   A!   A"   A#   A$   A%r   A&S   A'4   A(   A(   A)   A*   A+   A,z   A-[   A.<   A/   A/   A0   A1   A2   A3   A4c   A5D   A6%   A7   A7   A8   A9   A:   A;k   A<L   A=-   A>   A>   A?   A@   AA   ABs   ACT   AD5   AE   AE   AF   AG   AH   AI{   AJ\   AK=   AL   AL   AM   AN   AO   AP   AQd   ARE   AS&   AT   AT   AU   AV   AW   AXl   AYM   AZ.   A[   A[   A\   A]   A^   A_t   A`U   Aa6   Ab   Ab   Ac   Ad   Ae   Af|   Ag]   Ah>   Ai   Aj    Aj   Ak   Al   Am   Ane   AoF   Ap'   Aq   Aq   Ar   As   At   Aum   AvN   Aw/   Ax   Ax   Ay   Az   A{   A|u   A}V   A~7   A   A   À   Á   Â   Ã}   Ā^   A̅?   Ă    Ȧ   Ȧ   Ä   Ả   Å   A̋f   ǍG   A̍(   A̎	   A̎   Ȁ   A̐   Ȃ   A̒n   A̓O   A̔0   A̕   A̕   A̖   A̗   A̘   A̙v   A̚W   A̛8   A̜   A̜   A̝   A̞   A̟   A̠~   A̡_   A̢@   Ạ!   A̤   A̤   Ḁ   A̦   A̧   Ąg   A̩H   A̪)   A̫
   A̫   A̬   A̭   A̮   A̯o   A̰P   A̱1   A̲   A̲   A̳   A̴   A̵   A̶w   A̷X   A̸9   A̹   A̹   A̺   A̻   A̼   A̽   A̾`   A̿A   A"   A   A   A   Aæ   Ać   Ah   AI   A*   A   A   A   Aʮ   Aˏ   Ap   AQ   A2   A   A   A   AѶ   Aҗ   Ax   AY   A:   A   A   A   Aؾ   Aٟ   Aڀ   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   A K   A,   A
   A   A   A   A   Ar   AS   A4   A	   A	   A
   A   A   A
z   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A    A!   A"   A#s   A$T   A%5   A&   A&   A'   A(   A)   A*{   A+\   A,=   A-   A-   A.   A/   A0   A1   A2d   A3E   A4&   A5   A5   A6   A7   A8   A9l   A:M   A;.   A<   A<   A=   A>   A?   A@t   AAU   AB6   AC   AC   AD   AE   AF   AG|   AH]   AI>   AJ   AK    AK   AL   AM   AN   AOe   APF   AQ'   AR   AR   AS   AT   AU   AVm   AWN   AX/   AY   AY   AZ   A[   A\   A]u   A^V   A_7   A`   A`   Aa   Ab   Ac   Ad}   Ae^   Af?   Ag    Ah   Ah   Ai   Aj   Ak   Alf   AmG   An(   Ao	   Ao   Ap   Aq   Ar   Asn   AtO   Au0   Av   Av   Aw   Ax   Ay   Azv   A{W   A|8   A}   A}   A~   A   À   Á~   A͂_   A̓@   Ä́!   Aͅ   Aͅ   A͆   A͇   A͈   A͉g   A͊H   A͋)   A͌
   A͌   A͍   A͎   A͏   A͐o   A͑P   A͒1   A͓   A͓   A͔   A͕   A͖   A͗w   A͘X   A͙9   A͚   A͚   A͛   A͜   A͝   A͞   A͟`   A͠A   A͡"   A͢   A͢   Aͣ   Aͤ   Aͥ   Aͦh   AͧI   Aͨ*   Aͩ   Aͩ   Aͪ   Aͫ   Aͬ   Aͭp   AͮQ   Aͯ2   AͰ   AͰ   Aͱ   AͲ   Aͳ   Aʹx   A͵Y   AͶ:   Aͷ   Aͷ   A͸   A͹   Aͺ   Aͻ   Aͼa   AͽB   A;#   AͿ   AͿ   A   A   A   Ai   AJ   A+   A   A   A   Aȯ   Aɐ   Aq   AR   A3   A   A   A   AϷ   AИ   Ay   AZ   A;   A   A   A   Aֿ   Aנ   A؁   Ab   AC   A$   A   A   A   Aި   A߉   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A    A    A   A   A   As   AT   A5   A   A   A   A	   A
   A{   A\   A
=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A    A!t   A"U   A#6   A$   A$   A%   A&   A'   A(|   A)]   A*>   A+   A,    A,   A-   A.   A/   A0e   A1F   A2'   A3   A3   A4   A5   A6   A7m   A8N   A9/   A:   A:   A;   A<   A=   A>u   A?V   A@7   AA   AA   AB   AC   AD   AE}   AF^   AG?   AH    AI   AI   AJ   AK   AL   AMf   ANG   AO(   AP	   AP   AQ   AR   AS   ATn   AUO   AV0   AW   AW   AX   AY   AZ   A[v   A\W   A]8   A^   A^   A_   A`   Aa   Ab~   Ac_   Ad@   Ae!   Af   Af   Ag   Ah   Ai   Ajg   AkH   Al)   Am
   Am   An   Ao   Ap   Aqo   ArP   As1   At   At   Au   Av   Aw   Axw   AyX   Az9   A{   A{   A|   A}   A~   A   A΀`   A΁A   A΂"   A΃   A΃   A΄   A΅   AΆ   A·h   AΈI   AΉ*   AΊ   AΊ   A΋   AΌ   A΍   AΎp   AΏQ   Aΐ2   AΑ   AΑ   AΒ   AΓ   AΔ   AΕx   AΖY   AΗ:   AΘ   AΘ   AΙ   AΚ   AΛ   AΜ   AΝa   AΞB   AΟ#   AΠ   AΠ   AΡ   A΢   AΣ   AΤi   AΥJ   AΦ+   AΧ   AΧ   AΨ   AΩ   AΪ   AΫq   AάR   Aέ3   Aή   Aή   Aί   Aΰ   Aα   Aβy   AγZ   Aδ;   Aε   Aε   Aζ   Aη   Aθ   Aι   Aκb   AλC   Aμ$   Aν   Aν   Aξ   Aο   A   Aj   AK   A,   A
   A   A   Aư   AǑ   Ar   AS   A4   A   A   A   A͸   AΙ   Az   A[   A<   A   A   A   A   Aա   Aւ   Ac   AD   A%   A   A   A   Aܩ   A݊   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A    A   At   AU   A6   A   A   A   A   A   A	|   A
]   A>   A   A
    A
   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   A V   A!7   A"   A"   A#   A$   A%   A&}   A'^   A(?   A)    A*   A*   A+   A,   A-   A.f   A/G   A0(   A1	   A1   A2   A3   A4   A5n   A6O   A70   A8   A8   A9   A:   A;   A<v   A=W   A>8   A?   A?   A@   AA   AB   AC~   AD_   AE@   AF!   AG   AG   AH   AI   AJ   AKg   ALH   AM)   AN
   AN   AO   AP   AQ   ARo   ASP   AT1   AU   AU   AV   AW   AX   AYw   AZX   A[9   A\   A\   A]   A^   A_   A`   Aa`   AbA   Ac"   Ad   Ad   Ae   Af   Ag   Ahh   AiI   Aj*   Ak   Ak   Al   Am   An   Aop   ApQ   Aq2   Ar   Ar   As   At   Au   Avx   AwY   Ax:   Ay   Ay   Az   A{   A|   A}   A~a   AB   Aπ#   Aρ   Aρ   Aς   Aσ   Aτ   Aυi   AφJ   Aχ+   Aψ   Aψ   Aω   Aϊ   Aϋ   Aόq   AύR   Aώ3   AϏ   AϏ   Aϐ   Aϑ   Aϒ   Aϓy   AϔZ   Aϕ;   Aϖ   Aϖ   Aϗ   AϘ   Aϙ   AϚ   Aϛb   AϜC   Aϝ$   AϞ   AϞ   Aϟ   AϠ   Aϡ   AϢj   AϣK   AϤ,   Aϥ
   Aϥ   AϦ   Aϧ   AϨ   Aϩr   AϪS   Aϫ4   AϬ   AϬ   Aϭ   AϮ   Aϯ   Aϰz   Aϱ[   Aϲ<   Aϳ   Aϳ   Aϴ   Aϵ   A϶   AϷ   Aϸc   AϹD   AϺ%   Aϻ   Aϻ   Aϼ   AϽ   AϾ   AϿk   AL   A-   A   A   A   Aı   AŒ   As   AT   A5   A   A   A   A˹   A̚   A{   A\   A=   A   A   A   A   AӢ   Aԃ   Ad   AE   A&   A   A   A   Aڪ   Aۋ   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   A u   AV   A7   A   A   A   A   A   A}   A^   A	?   A
    A   A   A   A
   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A    A    A!   A"   A#   A$~   A%_   A&@   A'!   A(   A(   A)   A*   A+   A,g   A-H   A.)   A/
   A/   A0   A1   A2   A3o   A4P   A51   A6   A6   A7   A8   A9   A:w   A;X   A<9   A=   A=   A>   A?   A@   AA   AB`   ACA   AD"   AE   AE   AF   AG   AH   AIh   AJI   AK*   AL   AL   AM   AN   AO   APp   AQQ   AR2   AS   AS   AT   AU   AV   AWx   AXY   AY:   AZ   AZ   A[   A\   A]   A^   A_a   A`B   Aa#   Ab   Ab   Ac   Ad   Ae   Afi   AgJ   Ah+   Ai   Ai   Aj   Ak   Al   Amq   AnR   Ao3   Ap   Ap   Aq   Ar   As   Aty   AuZ   Av;   Aw   Aw   Ax   Ay   Az   A{   A|b   A}C   A~$   A   A   AЀ   AЁ   AЂ   AЃj   AЄK   AЅ,   AІ
   AІ   AЇ   AЈ   AЉ   AЊr   AЋS   AЌ4   AЍ   AЍ   AЎ   AЏ   AА   AБz   AВ[   AГ<   AД   AД   AЕ   AЖ   AЗ   AИ   AЙc   AКD   AЛ%   AМ   AМ   AН   AО   AП   AРk   AСL   AТ-   AУ   AУ   AФ   AХ   AЦ   AЧs   AШT   AЩ5   AЪ   AЪ   AЫ   AЬ   AЭ   AЮ{   AЯ\   Aа=   Aб   Aб   Aв   Aг   Aд   Aе   Aжd   AзE   Aи&   Aй   Aй   Aк   Aл   Aм   Aнl   AоM   Aп.   A   A   A   A²   AÓ   At   AU   A6   A   A   A   Aɺ   Aʛ   A|   A]   A>   A   A    A   A   Aѣ   A҄   Ae   AF   A'   A   A   A   Aث   Aٌ   Am   AN   A/   A   A   A   A߳   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A 8   A   A   A   A   A   A~   A_   A@   A!   A	   A	   A
   A   A   A
g   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A    A!   A"   A#`   A$A   A%"   A&   A&   A'   A(   A)   A*h   A+I   A,*   A-   A-   A.   A/   A0   A1p   A2Q   A32   A4   A4   A5   A6   A7   A8x   A9Y   A::   A;   A;   A<   A=   A>   A?   A@a   AAB   AB#   AC   AC   AD   AE   AF   AGi   AHJ   AI+   AJ   AJ   AK   AL   AM   ANq   AOR   AP3   AQ   AQ   AR   AS   AT   AUy   AVZ   AW;   AX   AX   AY   AZ   A[   A\   A]b   A^C   A_$   A`   A`   Aa   Ab   Ac   Adj   AeK   Af,   Ag
   Ag   Ah   Ai   Aj   Akr   AlS   Am4   An   An   Ao   Ap   Aq   Arz   As[   At<   Au   Au   Av   Aw   Ax   Ay   Azc   A{D   A|%   A}   A}   A~   A   Aр   Aсk   AтL   Aу-   Aф   Aф   Aх   Aц   Aч   Aшs   AщT   Aъ5   Aы   Aы   Aь   Aэ   Aю   Aя{   Aѐ\   Aё=   Aђ   Aђ   Aѓ   Aє   Aѕ   Aі   Aїd   AјE   Aљ&   Aњ   Aњ   Aћ   Aќ   Aѝ   Aўl   AџM   AѠ.   Aѡ   Aѡ   AѢ   Aѣ   AѤ   Aѥt   AѦU   Aѧ6   AѨ   AѨ   Aѩ   AѪ   Aѫ   AѬ|   Aѭ]   AѮ>   Aѯ   AѰ    AѰ   Aѱ   AѲ   Aѳ   AѴe   AѵF   AѶ'   Aѷ   Aѷ   AѸ   Aѹ   AѺ   Aѻm   AѼN   Aѽ/   AѾ   AѾ   Aѿ   A   A   Au   AV   A7   A   A   A   Aǻ   AȜ   A}   A^   A?   A    A   A   A   AϤ   AЅ   Af   AG   A(   A	   A   A   A֬   A׍   An   AO   A0   A   A   A   Aݴ   Aޕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A    A   A   A   A`   AA   A"   A   A   A   A	   A
   Ah   AI   A
*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A    A!a   A"B   A##   A$   A$   A%   A&   A'   A(i   A)J   A*+   A+   A+   A,   A-   A.   A/q   A0R   A13   A2   A2   A3   A4   A5   A6y   A7Z   A8;   A9   A9   A:   A;   A<   A=   A>b   A?C   A@$   AA   AA   AB   AC   AD   AEj   AFK   AG,   AH
   AH   AI   AJ   AK   ALr   AMS   AN4   AO   AO   AP   AQ   AR   ASz   AT[   AU<   AV   AV   AW   AX   AY   AZ   A[c   A\D   A]%   A^   A^   A_   A`   Aa   Abk   AcL   Ad-   Ae   Ae   Af   Ag   Ah   Ais   AjT   Ak5   Al   Al   Am   An   Ao   Ap{   Aq\   Ar=   As   As   At   Au   Av   Aw   Axd   AyE   Az&   A{   A{   A|   A}   A~   Al   AҀM   Aҁ.   A҂   A҂   A҃   A҄   A҅   A҆t   A҇U   A҈6   A҉   A҉   AҊ   Aҋ   AҌ   Aҍ|   AҎ]   Aҏ>   AҐ   Aґ    Aґ   AҒ   Aғ   AҔ   Aҕe   AҖF   Aҗ'   AҘ   AҘ   Aҙ   AҚ   Aқ   AҜm   AҝN   AҞ/   Aҟ   Aҟ   AҠ   Aҡ   AҢ   Aңu   AҤV   Aҥ7   AҦ   AҦ   Aҧ   AҨ   Aҩ   AҪ}   Aҫ^   AҬ?   Aҭ    AҮ   AҮ   Aү   AҰ   Aұ   AҲf   AҳG   AҴ(   Aҵ	   Aҵ   AҶ   Aҷ   AҸ   Aҹn   AҺO   Aһ0   AҼ   AҼ   Aҽ   AҾ   Aҿ   Av   AW   A8   A   A   A   Aż   AƝ   A~   A_   A@   A!   A   A   A   Aͥ   AΆ   Ag   AH   A)   A
   A   A   Aԭ   AՎ   Ao   AP   A1   A   A   A   A۵   Aܖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A    A   Aa   AB   A#   A   A   A   A   A   A	i   A
J   A+   A   A   A
   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   A C   A!$   A"   A"   A#   A$   A%   A&j   A'K   A(,   A)
   A)   A*   A+   A,   A-r   A.S   A/4   A0   A0   A1   A2   A3   A4z   A5[   A6<   A7   A7   A8   A9   A:   A;   A<c   A=D   A>%   A?   A?   A@   AA   AB   ACk   ADL   AE-   AF   AF   AG   AH   AI   AJs   AKT   AL5   AM   AM   AN   AO   AP   AQ{   AR\   AS=   AT   AT   AU   AV   AW   AX   AYd   AZE   A[&   A\   A\   A]   A^   A_   A`l   AaM   Ab.   Ac   Ac   Ad   Ae   Af   Agt   AhU   Ai6   Aj   Aj   Ak   Al   Am   An|   Ao]   Ap>   Aq   Ar    Ar   As   At   Au   Ave   AwF   Ax'   Ay   Ay   Az   A{   A|   A}m   A~N   A/   AӀ   AӀ   AӁ   Aӂ   AӃ   Aӄu   AӅV   Aӆ7   AӇ   AӇ   Aӈ   AӉ   Aӊ   AӋ}   Aӌ^   AӍ?   Aӎ    Aӏ   Aӏ   AӐ   Aӑ   AӒ   Aӓf   AӔG   Aӕ(   AӖ	   AӖ   Aӗ   AӘ   Aә   AӚn   AӛO   AӜ0   Aӝ   Aӝ   AӞ   Aӟ   AӠ   Aӡv   AӢW   Aӣ8   AӤ   AӤ   Aӥ   AӦ   Aӧ   AӨ~   Aө_   AӪ@   Aӫ!   AӬ   AӬ   Aӭ   AӮ   Aӯ   AӰg   AӱH   AӲ)   Aӳ
   Aӳ   AӴ   Aӵ   AӶ   Aӷo   AӸP   Aӹ1   AӺ   AӺ   Aӻ   AӼ   Aӽ   AӾw   AӿX   A9   A   A   A   Aý   AĞ   A   A`   AA   A"   A   A   A   A˦   Ȧ   Ah   AI   A*   A   A   A   AҮ   Aӏ   Ap   AQ   A2   A   A   A   Aٶ   Aڗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   A b   AC   A$   A   A   A   A   A   Aj   AK   A	,   A

   A
   A   A   A
   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A    A    A!   A"   A#   A$k   A%L   A&-   A'   A'   A(   A)   A*   A+s   A,T   A-5   A.   A.   A/   A0   A1   A2{   A3\   A4=   A5   A5   A6   A7   A8   A9   A:d   A;E   A<&   A=   A=   A>   A?   A@   AAl   ABM   AC.   AD   AD   AE   AF   AG   AHt   AIU   AJ6   AK   AK   AL   AM   AN   AO|   AP]   AQ>   AR   AS    AS   AT   AU   AV   AWe   AXF   AY'   AZ   AZ   A[   A\   A]   A^m   A_N   A`/   Aa   Aa   Ab   Ac   Ad   Aeu   AfV   Ag7   Ah   Ah   Ai   Aj   Ak   Al}   Am^   An?   Ao    Ap   Ap   Aq   Ar   As   Atf   AuG   Av(   Aw	   Aw   Ax   Ay   Az   A{n   A|O   A}0   A~   A~   A   AԀ   Aԁ   AԂv   AԃW   AԄ8   Aԅ   Aԅ   AԆ   Aԇ   AԈ   Aԉ~   AԊ_   Aԋ@   AԌ!   Aԍ   Aԍ   AԎ   Aԏ   AԐ   Aԑg   AԒH   Aԓ)   AԔ
   AԔ   Aԕ   AԖ   Aԗ   AԘo   AԙP   AԚ1   Aԛ   Aԛ   AԜ   Aԝ   AԞ   Aԟw   AԠX   Aԡ9   AԢ   AԢ   Aԣ   AԤ   Aԥ   AԦ   Aԧ`   AԨA   Aԩ"   AԪ   AԪ   Aԫ   AԬ   Aԭ   AԮh   AԯI   A԰*   AԱ   AԱ   AԲ   AԳ   AԴ   AԵp   AԶQ   AԷ2   AԸ   AԸ   AԹ   AԺ   AԻ   AԼx   AԽY   AԾ:   AԿ   AԿ   A   A   A   AÀ   Aa   AB   A#   A   A   A   Aɧ   Aʈ   Ai   AJ   A+   A   A   A   AЯ   Aѐ   Aq   AR   A3   A   A   A   A׷   Aؘ   Ay   AZ   A;   A   A   A   A޿   Aߠ   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A %   A   A   A   A   A   Ak   AL   A-   A   A   A	   A
   A   As   A
T   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A    A!   A"l   A#M   A$.   A%   A%   A&   A'   A(   A)t   A*U   A+6   A,   A,   A-   A.   A/   A0|   A1]   A2>   A3   A4    A4   A5   A6   A7   A8e   A9F   A:'   A;   A;   A<   A=   A>   A?m   A@N   AA/   AB   AB   AC   AD   AE   AFu   AGV   AH7   AI   AI   AJ   AK   AL   AM}   AN^   AO?   AP    AQ   AQ   AR   AS   AT   AUf   AVG   AW(   AX	   AX   AY   AZ   A[   A\n   A]O   A^0   A_   A_   A`   Aa   Ab   Acv   AdW   Ae8   Af   Af   Ag   Ah   Ai   Aj~   Ak_   Al@   Am!   An   An   Ao   Ap   Aq   Arg   AsH   At)   Au
   Au   Av   Aw   Ax   Ayo   AzP   A{1   A|   A|   A}   A~   A   AՀw   AՁX   AՂ9   AՃ   AՃ   AՄ   AՅ   AՆ   AՇ   AՈ`   AՉA   AՊ"   AՋ   AՋ   AՌ   AՍ   AՎ   AՏh   AՐI   AՑ*   AՒ   AՒ   AՓ   AՔ   AՕ   AՖp   A՗Q   A՘2   Aՙ   Aՙ   A՚   A՛   A՜   A՝x   A՞Y   A՟:   Aՠ   Aՠ   Aա   Aբ   Aգ   Aդ   Aեa   AզB   Aէ#   Aը   Aը   Aթ   Aժ   Aի   Aլi   AխJ   Aծ+   Aկ   Aկ   Aհ   Aձ   Aղ   Aճq   AմR   Aյ3   Aն   Aն   Aշ   Aո   Aչ   Aպy   AջZ   Aռ;   Aս   Aս   Aվ   Aտ   A   A   Ab   AC   A$   A   A   A   AǨ   Aȉ   Aj   AK   A,   A
   A   A   Aΰ   Aϑ   Ar   AS   A4   A   A   A   Aո   A֙   Az   A[   A<   A   A   A   A   Aݡ   Aނ   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A    A   A   Al   AM   A.   A   A   A   A   A	   A
t   AU   A6   A
   A
   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   A m   A!N   A"/   A#   A#   A$   A%   A&   A'u   A(V   A)7   A*   A*   A+   A,   A-   A.}   A/^   A0?   A1    A2   A2   A3   A4   A5   A6f   A7G   A8(   A9	   A9   A:   A;   A<   A=n   A>O   A?0   A@   A@   AA   AB   AC   ADv   AEW   AF8   AG   AG   AH   AI   AJ   AK~   AL_   AM@   AN!   AO   AO   AP   AQ   AR   ASg   ATH   AU)   AV
   AV   AW   AX   AY   AZo   A[P   A\1   A]   A]   A^   A_   A`   Aaw   AbX   Ac9   Ad   Ad   Ae   Af   Ag   Ah   Ai`   AjA   Ak"   Al   Al   Am   An   Ao   Aph   AqI   Ar*   As   As   At   Au   Av   Awp   AxQ   Ay2   Az   Az   A{   A|   A}   A~x   AY   Aր:   Aց   Aց   Aւ   Aփ   Aք   Aօ   Aֆa   AևB   Aֈ#   A։   A։   A֊   A֋   A֌   A֍i   A֎J   A֏+   A֐   A֐   A֑   A֒   A֓   A֔q   A֕R   A֖3   A֗   A֗   A֘   A֙   A֚   A֛y   A֜Z   A֝;   A֞   A֞   A֟   A֠   A֡   A֢   A֣b   A֤C   A֥$   A֦   A֦   A֧   A֨   A֩   A֪j   A֫K   A֬,   A֭
   A֭   A֮   A֯   Aְ   Aֱr   AֲS   Aֳ4   Aִ   Aִ   Aֵ   Aֶ   Aַ   Aָz   Aֹ[   Aֺ<   Aֻ   Aֻ   Aּ   Aֽ   A־   Aֿ   Ac   AD   A%   A   A   A   Aũ   AƊ   Ak   AL   A-   A   A   A   A̱   A͒   As   AT   A5   A   A   A   Aӹ   AԚ   A{   A\   A=   A   A   A   A   Aۢ   A܃   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A    Am   AN   A/   A   A   A   A   A   Au   A	V   A
7   A   A   A   A
   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A 0   A!   A!   A"   A#   A$   A%v   A&W   A'8   A(   A(   A)   A*   A+   A,~   A-_   A.@   A/!   A0   A0   A1   A2   A3   A4g   A5H   A6)   A7
   A7   A8   A9   A:   A;o   A<P   A=1   A>   A>   A?   A@   AA   ABw   ACX   AD9   AE   AE   AF   AG   AH   AI   AJ`   AKA   AL"   AM   AM   AN   AO   AP   AQh   ARI   AS*   AT   AT   AU   AV   AW   AXp   AYQ   AZ2   A[   A^   A_x   A`Y   Aa:   Ai#   At   Aץ   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   A O   A0   A   A   A   Av   AW   A8   A	   A	   A
   A   A   A
~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A    A!   A"   A#w   A$X   A%9   A&   A&   A'   A(   A)   A*   A+`   A,A   A-"   A.   A.   A/   A0   A1   A2h   A3I   A4*   A5   A5   A6   A7   A8   A9p   A:Q   A;2   A<   A<   A=   A>   A?   A@x   AAY   AB:   AC   AC   AD   AE   AF   AG   AHa   AIB   AJ#   AK   AK   AL   AM   AN   AOi   APJ   AQ+   AR   AR   AS   AT   AU   AVq   AWR   AX3   AY   AY   AZ   A[   A\   A]y   A^Z   A_;   A`   A`   Aa   Ab   Ac   Ad   Aeb   AfC   Ag$   Ah   Ah   Ai   Aj   Ak   Alj   AmK   An,   Ao
   Ao   Ap   Aq   Ar   Asr   AtS   Au4   Av   Av   Aw   Ax   Ay   Azz   A{[   A|<   A}   A}   A~   A   A؀   A؁   A؂c   A؃D   A؄%   A؅   A؅   A؆   A؇   A؈   A؉k   A؊L   A؋-   A،   A،   A؍   A؎   A؏   Aؐs   AؑT   Aؒ5   Aؓ   Aؓ   Aؔ   Aؕ   Aؖ   Aؗ{   Aؘ\   Aؙ=   Aؚ   Aؚ   A؛   A؜   A؝   A؞   A؟d   AؠE   Aء&   Aآ   Aآ   Aأ   Aؤ   Aإ   Aئl   AاM   Aب.   Aة   Aة   Aت   Aث   Aج   Aحt   AخU   Aد6   Aذ   Aذ   Aر   Aز   Aس   Aش|   Aص]   Aض>   Aط   Aظ    Aظ   Aع   Aغ   Aػ   Aؼe   AؽF   Aؾ'   Aؿ   Aؿ   A   A   A   Am   AN   A/   A   A   A   Aȳ   Aɔ   Au   AV   A7   A   A   A   Aϻ   AМ   A}   A^   A?   A    A   A   A   Aפ   A؅   Af   AG   A(   A	   A   A   Aެ   Aߍ   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A    A    A   A   A   Aw   AX   A9   A   A   A   A	   A
   A   A`   A
A   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A    A!x   A"Y   A#:   A$   A$   A%   A&   A'   A(   A)a   A*B   A,   A,   A-   A.   A/   A0i   A1J   AL   AMj   ANK   AO,   AP
   AQ   AR   AZ   A\[   A]<   A`   Aa   Ab   Acc   An   AُU   Aٶ   Aٶ   AO   A   A   A   A   A   A   A   A   A`   A   A   A
   Ay   A'b   A<z   A?   AA   AG   AH   Az    Aکv   AڪW   Aګ8   Aڬ   Aڬ   Aڭ   Aڮ   Aگ   Aڰ~   Aڱ_   Aڲ@   Aڳ!   Aڴ   Aڴ   Aڵ   Aڶ   Aڷ   Aڸg   AڹH   Aں)   Aڻ
   Aڻ   Aڼ   Aڽ   Aھ   Aڿo   AP   A1   A   A   A   Aĵ   AŖ   Aw   AX   A9   A   A   A   A˽   A̞   A   A`   AA   A"   A   A   A   AӦ   Aԇ   Ah   AI   A*   A   A   A   Aڮ   Aۏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   A y   AZ   A;   A   A   A   A   A   A   Ab   A	C   A
$   A   A   A   A
   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A    A    A!   A"   A#   A$   A%c   A&D   A'%   A(   A(   A)   A*   A+   A,k   A-L   A.-   A/   A/   A0   A1   A2   A3s   A4T   A55   A6   A6   A7   A8   A9   A:{   A;\   A<=   A=   A=   A>   A?   A@   AA   ABd   ACE   AD&   AE   AE   AF   AG   AH   AIl   AJM   AK.   AL   AL   AM   AN   AO   APt   AQU   AR6   AS   AS   AT   AU   AV   AW|   AX]   AY>   AZ   A[    A[   A\   A]   A^   A_e   A`F   Aa'   Ab   Ab   Ac   Ad   Ae   Afm   AgN   Ah/   Ai   Ai   Aj   Ak   Al   Amu   AnV   Ao7   Ap   Ap   Aq   Ar   As   At}   Au^   Av?   Aw    Ax   Ax   Ay   Az   A{   A|f   A}G   A~(   A	   A   Aۀ   Aہ   Aۂ   Aۃn   AۄO   Aۅ0   Aۆ   Aۆ   Aۇ   Aۈ   Aۉ   Aۊv   AۋW   Aی8   Aۍ   Aۍ   Aێ   Aۏ   Aې   Aۑ~   Aے_   Aۓ@   A۔!   Aە   Aە   Aۖ   Aۗ   Aۘ   Aۙg   AۚH   Aۛ)   Aۜ
   Aۜ   A۝   A۞   A۟   A۠o   AۡP   Aۢ1   Aۣ   Aۣ   Aۤ   Aۥ   Aۦ   Aۧw   AۨX   A۩9   A۪   A۪   A۫   A۬   Aۭ   Aۮ   Aۯ`   A۰A   A۱"   A۲   A۲   A۳   A۴   A۵   A۶h   A۷I   A۸*   A۹   A۹   Aۺ   Aۻ   Aۼ   A۽p   A۾Q   Aۿ2   A   A   A   A¶   A×   Ax   AY   A:   A   A   A   Aɾ   Aʟ   Aˀ   Aa   AB   A#   A   A   A   Aѧ   A҈   Ai   AJ   A+   A   A   A   Aد   Aِ   Aq   AR   A3   A   A   A   A߷   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A <   A   A   A   A   A   A   Ac   AD   A%   A	   A	   A
   A   A   A
k   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A    A!   A"   A#d   A$E   A%&   A&   A&   A'   A(   A)   A*l   A+M   A,.   A-   A-   A.   A/   A0   A1t   A2U   A36   A4   A4   A5   A6   A7   A8|   A9]   A:>   A;   A<    A<   A=   A>   A?   A@e   AAF   AB'   AC   AC   AD   AE   AF   AGm   AHN   AI/   AJ   AJ   AK   AL   AM   ANu   AOV   AP7   AQ   AQ   AR   AS   AT   AU}   AV^   AW?   AX    AY   AY   AZ   A[   A\   A]f   A^G   A_(   A`	   A`   Aa   Ab   Ac   Adn   AeO   Af0   Ag   Ag   Ah   Ai   Aj   Akv   AlW   Am8   An   An   Ao   Ap   Aq   Ar~   As_   At@   Au!   Av   Av   Aw   Ax   Ay   Azg   A{H   A|)   A}
   A}   A~   A   A܀   A܁o   A܂P   A܃1   A܄   A܄   A܅   A܆   A܇   A܈w   A܉X   A܊9   A܋   A܋   A܌   A܍   A܎   A܏   Aܐ`   AܑA   Aܒ"   Aܓ   Aܓ   Aܔ   Aܕ   Aܖ   Aܗh   AܘI   Aܙ*   Aܚ   Aܚ   Aܛ   Aܜ   Aܝ   Aܞp   AܟQ   Aܠ2   Aܡ   Aܡ   Aܢ   Aܣ   Aܤ   Aܥx   AܦY   Aܧ:   Aܨ   Aܨ   Aܩ   Aܪ   Aܫ   Aܬ   Aܭa   AܮB   Aܯ#   Aܰ   Aܰ   Aܱ   Aܲ   Aܳ   Aܴi   AܵJ   Aܶ+   Aܷ   Aܷ   Aܸ   Aܹ   Aܺ   Aܻq   AܼR   Aܽ3   Aܾ   Aܾ   Aܿ   A   A   Ay   AZ   A;   A   A   A   Aǿ   AȠ   AɁ   Ab   AC   A$   A   A   A   AϨ   AЉ   Aj   AK   A,   A
   A   A   Aְ   Aב   Ar   AS   A4   A   A   A   Aݸ   Aޙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A    A   A   A   Ad   AE   A&   A   A   A   A	   A
   Al   AM   A
.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A    A!e   A"F   A#'   A$   A$   A%   A&   A'   A(m   A)N   A*/   A+   A+   A,   A-   A.   A/u   A0V   A17   A2   A2   A3   A4   A5   A6}   A7^   A8?   A9    A:   A:   A;   A<   A=   A>f   A?G   A@(   AA	   AA   AB   AC   AD   AEn   AFO   AG0   AH   AH   AI   AJ   AK   ALv   AMW   AN8   AO   AO   AP   AQ   AR   AS~   AT_   AU@   AV!   AW   AW   AX   AY   AZ   A[g   A\H   A])   A^
   A^   A_   A`   Aa   Abo   AcP   Ad1   Ae   Ae   Af   Ag   Ah   Aiw   AjX   Ak9   Al   Al   Am   An   Ao   Ap   Aq`   ArA   As"   At   At   Au   Av   Aw   Axh   AyI   Az*   A{   A{   A|   A}   A~   Ap   A݀Q   A݁2   A݂   A݂   A݃   A݄   A݅   A݆x   A݇Y   A݈:   A݉   A݉   A݊   A݋   A݌   Aݍ   Aݎa   AݏB   Aݐ#   Aݑ   Aݑ   Aݒ   Aݓ   Aݔ   Aݕi   AݖJ   Aݗ+   Aݘ   Aݘ   Aݙ   Aݚ   Aݛ   Aݜq   AݝR   Aݞ3   Aݟ   Aݟ   Aݠ   Aݡ   Aݢ   Aݣy   AݤZ   Aݥ;   Aݦ   Aݦ   Aݧ   Aݨ   Aݩ   Aݪ   Aݫb   AݬC   Aݭ$   Aݮ   Aݮ   Aݯ   Aݰ   Aݱ   Aݲj   AݳK   Aݴ,   Aݵ
   Aݵ   Aݶ   Aݷ   Aݸ   Aݹr   AݺS   Aݻ4   Aݼ   Aݼ   Aݽ   Aݾ   Aݿ   Az   A[   A<   A   A   A   A   Aơ   Aǂ   Ac   AD   A%   A   A   A   Aͩ   AΊ   Ak   AL   A-   A   A   A   AԱ   AՒ   As   AT   A5   A   A   A   A۹   Aܚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A    A   Ae   AF   A'   A   A   A   A   A   A	m   A
N   A/   A   A   A
   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   A G   A!(   A"	   A"   A#   A$   A%   A&n   A'O   A(0   A)   A)   A*   A+   A,   A-v   A.W   A/8   A0   A0   A1   A2   A3   A4~   A5_   A6@   A7!   A8   A8   A9   A:   A;   A<g   A=H   A>)   A?
   A?   A@   AA   AB   ACo   ADP   AE1   AF   AF   AG   AH   AI   AJw   AKX   AL9   AM   AM   AN   AO   AP   AQ   AR`   ASA   AT"   AU   AU   AV   AW   AX   AYh   AZI   A[*   A\   A\   A]   A^   A_   A`p   AaQ   Ab2   Ac   Ac   Ad   Ae   Af   Agx   AhY   Ai:   Aj   Aj   Ak   Al   Am   An   Aoa   ApB   Aq#   Ar   Ar   As   At   Au   Avi   AwJ   Ax+   Ay   Ay   Az   A{   A|   A}q   A~R   A3   Aހ   Aހ   Aށ   Aނ   Aރ   Aބy   AޅZ   Aކ;   Aއ   Aއ   Aވ   Aމ   Aފ   Aދ   Aތb   AލC   Aގ$   Aޏ   Aޏ   Aސ   Aޑ   Aޒ   Aޓj   AޔK   Aޕ,   Aޖ
   Aޖ   Aޗ   Aޘ   Aޙ   Aޚr   AޛS   Aޜ4   Aޝ   Aޝ   Aޞ   Aޟ   Aޠ   Aޡz   Aޢ[   Aޣ<   Aޤ   Aޤ   Aޥ   Aަ   Aާ   Aި   Aީc   AުD   Aޫ%   Aެ   Aެ   Aޭ   Aޮ   Aޯ   Aްk   AޱL   A޲-   A޳   A޳   A޴   A޵   A޶   A޷s   A޸T   A޹5   A޺   A޺   A޻   A޼   A޽   A޾{   A޿\   A=   A   A   A   A   AĢ   AŃ   Ad   AE   A&   A   A   A   A˪   A̋   Al   AM   A.   A   A   A   AҲ   Aӓ   At   AU   A6   A   A   A   Aٺ   Aڛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   A f   AG   A(   A	   A   A   A   A   An   AO   A	0   A
   A
   A   A   A
   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A 
   A    A!   A"   A#   A$o   A%P   A&1   A'   A'   A(   A)   A*   A+w   A,X   A-9   A.   A.   A/   A0   A1   A2   A3`   A4A   A5"   A6   A6   A7   A8   A9   A:h   A;I   A<*   A=   A=   A>   A?   A@   AAp   ABQ   AC2   AD   AD   AE   AF   AG   AHx   AIY   AJ:   AK   AK   AL   AM   AN   AO   APa   AQB   AR#   AS   AS   AT   AU   AV   AWi   AXJ   AY+   AZ   AZ   A[   A\   A]   A^q   A_R   A`3   Aa   Aa   Ab   Ac   Ad   Aey   AfZ   Ag;   Ah   Ah   Ai   Aj   Ak   Al   Amb   AnC   Ao$   Ap   Ap   Aq   Ar   As   Atj   AuK   Av,   Aw
   Aw   Ax   Ay   Az   A{r   A|S   A}4   A~   A~   A   A߀   A߁   A߂z   A߃[   A߄<   A߅   A߅   A߆   A߇   A߈   A߉   Aߊc   AߋD   Aߌ%   Aߍ   Aߍ   Aߎ   Aߏ   Aߐ   Aߑk   AߒL   Aߓ-   Aߔ   Aߔ   Aߕ   Aߖ   Aߗ   Aߘs   AߙT   Aߚ5   Aߛ   Aߛ   Aߜ   Aߝ   Aߞ   Aߟ{   Aߠ\   Aߡ=   Aߢ   Aߢ   Aߣ   Aߤ   Aߥ   Aߦ   Aߧd   AߨE   Aߩ&   Aߪ   Aߪ   A߫   A߬   A߭   A߮l   A߯M   A߰.   A߱   A߱   A߲   A߳   Aߴ   Aߵt   A߶U   A߷6   A߸   A߸   A߹   Aߺ   A߻   A߼|   A߽]   A߾>   A߿   A    A   A   A£   AÄ   Ae   AF   A'   A   A   A   Aɫ   Aʌ   Am   AN   A/   A   A   A   Aг   Aє   Au   AV   A7   A   A   A   A׻   A؜   A}   A^   A?   A    A   A   A   Aߤ   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A )   A
   A   A   A   A   Ao   AP   A1   A   A   A	   A
   A   Aw   A
X   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A    A!   A"p   A#Q   A$2   A%   A%   A&   A'   A(   A)x   A*Y   A+:   A,   A,   A-   A.   A/   A0   A1a   A2B   A3#   A4   A4   A5   A6   A7   A8i   A9J   A:+   A;   A;   A<   A=   A>   A?q   A@R   AA3   AB   AB   AC   AD   AE   AFy   AGZ   AH;   AI   AI   AJ   AK   AL   AM   ANb   AOC   AP$   AQ   AQ   AR   AS   AT   AUj   AVK   AW,   AX
   AX   AY   AZ   A[   A\r   A]S   A^4   A_   A_   A`   Aa   Ab   Acz   Ad[   Ae<   Af   Af   Ag   Ah   Ai   Aj   Akc   AlD   Am%   An   An   Ao   Ap   Aq   Ark   AsL   At-   Au   Au   Av   Aw   Ax   Ays   AzT   A{5   A|   A|   A}   A~   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aࣣ   Aऄ   Ae   AF   A'   A   A   A   Aફ   Aૌ   Am   AN   A/   A   A   A   A౳   Aಔ   Au   AV   A7   A   A   A   A฻   A๜   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   AǬ   Aȍ   An   AO   A0   A   A   A   Aδ   Aϕ   Av   AW   A8   A   A   A   Aռ   A֝   A~   A_   A@   A!   A   A   A   Aݥ   Aކ   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A    A   A   Ap   AQ   A2   A   A   A   A   A	   A
x   AY   A:   A
   A
   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   A q   A!R   A"3   A#   A#   A$   A%   A&   A'y   A(Z   A);   A*   A*   A+   A,   A-   A.   A/b   A0C   A1$   A2   A2   A3   A4   A5   A6j   A7K   A8,   A9
   A9   A:   A;   A<   A=r   A>S   A?4   A@   A@   AA   AB   AC   ADz   AE[   AF<   AG   AG   AH   AI   AJ   AK   ALc   AMD   AN%   AO   AO   AP   AQ   AR   ASk   ATL   AU-   AV   AV   AW   AX   AY   AZs   A[T   A\5   A]   A]   A^   A_   A`   Aa{   Ab\   Ac=   Ad   Ad   Ae   Af   Ag   Ah   Aid   AjE   Ak&   Al   Al   Am   An   Ao   Apl   AqM   Ar.   As   As   At   Au   Av   Awt   AxU   Ay6   Az   Az   A{   A|   A}   A~|   A]   A>   A   A    A   A   Aᄣ   Aᅄ   Ae   AF   A'   A   A   A   Aያ   Aጌ   Am   AN   A/   A   A   A   Aᒳ   Aᓔ   Au   AV   A7   A   A   A   Aᙻ   A᚜   A}   A^   A?   A    A   A   A   Aᡤ   Aᢅ   Af   AG   A(   A	   A   A   Aᨬ   Aᩍ   An   AO   A0   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   A S   A4   A   A   A   A   A   Az   A[   A<   A	   A	   A
   A   A   A
   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A    A!   A"   A#{   A$\   A%=   A&   A&   A'   A(   A)   A*   A+d   A,E   A-&   A.   A.   A/   A0   A1   A2l   A3M   A4.   A5   A5   A6   A7   A8   A9t   A:U   A;6   A<   A<   A=   A>   A?   A@|   AA]   AB>   AC   AD    AD   AE   AF   AG   AHe   AIF   AJ'   AK   AK   AL   AM   AN   AOm   APN   AQ/   AR   AR   AS   AT   AU   AVu   AWV   AX7   AY   AY   AZ   A[   A\   A]}   A^^   A_?   A`    Aa   Aa   Ab   Ac   Ad   Aef   AfG   Ag(   Ah	   Ah   Ai   Aj   Ak   Aln   AmO   An0   Ao   Ao   Ap   Aq   Ar   Asv   AtW   Au8   Av   Av   Aw   Ax   Ay   Az~   A{_   A|@   A}!   A~   A~   A   A〥   Aう   Ag   AH   A)   A
   A   A   A㇭   A㈎   Ao   AP   A1   A   A   A   A㎵   A㏖   Aw   AX   A9   A   A   A   A㕽   A㖞   A   A`   AA   A"   A   A   A   A㝦   A㞇   Ah   AI   A*   A   A   A   A㤮   A㥏   Ap   AQ   A2   A   A   A   A㫶   A㬗   Ax   AY   A:   A   A   A   A㲾   A㳟   A㴀   Aa   AB   A#   A   A   A   A㺧   A㻈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   Aȷ   Aɘ   Ay   AZ   A;   A   A   A   AϿ   AР   Aс   Ab   AC   A$   A   A   A   Aר   A؉   Aj   AK   A,   A
   A   A   Aް   Aߑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A    A    A   A   A   A{   A\   A=   A   A   A   A	   A
   A   Ad   A
E   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A    A!|   A"]   A#>   A$   A%    A%   A&   A'   A(   A)e   A*F   A+'   A,   A,   A-   A.   A/   A0m   A1N   A2/   A3   A3   A4   A5   A6   A7u   A8V   A97   A:   A:   A;   A<   A=   A>}   A?^   A@?   AA    AB   AB   AC   AD   AE   AFf   AGG   AH(   AI	   AI   AJ   AK   AL   AMn   ANO   AO0   AP   AP   AQ   AR   AS   ATv   AUW   AV8   AW   AW   AX   AY   AZ   A[~   A\_   A]@   A^!   A_   A_   A`   Aa   Ab   Acg   AdH   Ae)   Af
   Af   Ag   Ah   Ai   Ajo   AkP   Al1   Am   Am   An   Ao   Ap   Aqw   ArX   As9   At   At   Au   Av   Aw   Ax   Ay`   AzA   A{"   A|   A|   A}   A~   A   Ah   AI   A*   A   A   A   A䅮   A䆏   Ap   AQ   A2   A   A   A   A䌶   A䍗   Ax   AY   A:   A   A   A   A䓾   A䔟   A䕀   Aa   AB   A#   A   A   A   A䛧   A䜈   Ai   AJ   A+   A   A   A   A䢯   A䣐   Aq   AR   A3   A   A   A   A䩷   A䪘   Ay   AZ   A;   A   A   A   A䰿   A䱠   A䲁   Ab   AC   A$   A   A   A   A丨   A义   Aj   AK   A,   A
   A   A   A俰   A   Ar   AS   A4   A   A   A   AƸ   AǙ   Az   A[   A<   A   A   A   A   AΡ   Aς   Ac   AD   A%   A   A   A   Aթ   A֊   Ak   AL   A-   A   A   A   Aܱ   Aݒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A    A   A|   A]   A>   A   A    A   A   A   A	   A
e   AF   A'   A
   A
   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A ^   A!?   A"    A#   A#   A$   A%   A&   A'f   A(G   A)(   A*	   A*   A+   A,   A-   A.n   A/O   A00   A1   A1   A2   A3   A4   A5v   A6W   A78   A8   A8   A9   A:   A;   A<~   A=_   A>@   A?!   A@   A@   AA   AB   AC   ADg   AEH   AF)   AG
   AG   AH   AI   AJ   AKo   ALP   AM1   AN   AN   AO   AP   AQ   ARw   ASX   AT9   AU   AU   AV   AW   AX   AY   AZ`   A[A   A\"   A]   A]   A^   A_   A`   Aah   AbI   Ac*   Ad   Ad   Ae   Af   Ag   Ahp   AiQ   Aj2   Ak   Ak   Al   Am   An   Aox   ApY   Aq:   Ar   Ar   As   At   Au   Av   Awa   AxB   Ay#   Az   Az   A{   A|   A}   A~i   AJ   A+   A   A   A   A僯   A儐   Aq   AR   A3   A   A   A   A劷   A勘   Ay   AZ   A;   A   A   A   A呿   A咠   A品   Ab   AC   A$   A   A   A   A器   A嚉   Aj   AK   A,   A
   A   A   A堰   A塑   Ar   AS   A4   A   A   A   A姸   A娙   Az   A[   A<   A   A   A   A   A寡   A専   Ac   AD   A%   A   A   A   A嶩   A巊   Ak   AL   A-   A   A   A   A影   A徒   As   AT   A5   A   A   A   AĹ   AŚ   A{   A\   A=   A   A   A   A   A̢   A̓   Ad   AE   A&   A   A   A   AӪ   Aԋ   Al   AM   A.   A   A   A   Aڲ   Aۓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A }   A^   A?   A    A   A   A   A   A   Af   A	G   A
(   A	   A   A   A
   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A !   A!   A!   A"   A#   A$   A%g   A&H   A')   A(
   A(   A)   A*   A+   A,o   A-P   A.1   A/   A/   A0   A1   A2   A3w   A4X   A59   A6   A6   A7   A8   A9   A:   A;`   A<A   A="   A>   A>   A?   A@   AA   ABh   ACI   AD*   AE   AE   AF   AG   AH   AIp   AJQ   AK2   AL   AL   AM   AN   AO   APx   AQY   AR:   AS   AS   AT   AU   AV   AW   AXa   AYB   AZ#   A[   A[   A\   A]   A^   A_i   A`J   Aa+   Ab   Ab   Ac   Ad   Ae   Afq   AgR   Ah3   Ai   Ai   Aj   Ak   Al   Amy   AnZ   Ao;   Ap   Ap   Aq   Ar   As   At   Aub   AvC   Aw$   Ax   Ax   Ay   Az   A{   A|j   A}K   A~,   A
   A   A   A恰   A悑   Ar   AS   A4   A   A   A   A戸   A扙   Az   A[   A<   A   A   A   A   A搡   A摂   Ac   AD   A%   A   A   A   A早   A昊   Ak   AL   A-   A   A   A   A枱   A柒   As   AT   A5   A   A   A   A楹   A榚   A{   A\   A=   A   A   A   A   A止   A殃   Ad   AE   A&   A   A   A   A洪   A测   Al   AM   A.   A   A   A   A滲   A漓   At   AU   A6   A   A   A   Aº   AÛ   A|   A]   A>   A   A    A   A   Aʣ   A˄   Ae   AF   A'   A   A   A   Aѫ   AҌ   Am   AN   A/   A   A   A   Aس   Aٔ   Au   AV   A7   A   A   A   A߻   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A @   A!   A   A   A   A   A   Ag   AH   A)   A	
   A	   A
   A   A   A
o   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A    A!   A"   A#h   A$I   A%*   A&   A&   A'   A(   A)   A*p   A+Q   A,2   A-   A-   A.   A/   A0   A1x   A2Y   A3:   A4   A4   A5   A6   A7   A8   A9a   A:B   A;#   A<   A<   A=   A>   A?   A@i   AAJ   AB+   AC   AC   AD   AE   AF   AGq   AHR   AI3   AJ   AJ   AK   AL   AM   ANy   AOZ   AP;   AQ   AQ   AR   AS   AT   AU   AVb   AWC   AX$   AY   AY   AZ   A[   A\   A]j   A^K   A_,   A`
   A`   Aa   Ab   Ac   Adr   AeS   Af4   Ag   Ag   Ah   Ai   Aj   Akz   Al[   Am<   An   An   Ao   Ap   Aq   Ar   Asc   AtD   Au%   Av   Av   Aw   Ax   Ay   Azk   A{L   A|-   A}   A}   A~   A   A瀒   As   AT   A5   A   A   A   A熹   A燚   A{   A\   A=   A   A   A   A   A玢   A珃   Ad   AE   A&   A   A   A   A番   A疋   Al   AM   A.   A   A   A   A眲   A睓   At   AU   A6   A   A   A   A磺   A礛   A|   A]   A>   A   A    A   A   A竣   A笄   Ae   AF   A'   A   A   A   A粫   A糌   Am   AN   A/   A   A   A   A繳   A纔   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   AȤ   AɅ   Af   AG   A(   A	   A   A   AϬ   AЍ   An   AO   A0   A   A   A   Aִ   Aו   Av   AW   A8   A   A   A   Aݼ   Aޝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A    A    A   A   A   Ah   AI   A*   A   A   A   A	   A
   Ap   AQ   A
2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A    A!i   A"J   A#+   A$   A$   A%   A&   A'   A(q   A)R   A*3   A+   A+   A,   A-   A.   A/y   A0Z   A1;   A2   A2   A3   A4   A5   A6   A7b   A8C   A9$   A:   A:   A;   A<   A=   A>j   A?K   A@,   AA
   AA   AB   AC   AD   AEr   AFS   AG4   AH   AH   AI   AJ   AK   ALz   AM[   AN<   AO   AO   AP   AQ   AR   AS   ATc   AUD   AV%   AW   AW   AX   AY   AZ   A[k   A\L   A]-   A^   A^   A_   A`   Aa   Abs   AcT   Ad5   Ae   Ae   Af   Ag   Ah   Ai{   Aj\   Ak=   Al   Al   Am   An   Ao   Ap   Aqd   ArE   As&   At   At   Au   Av   Aw   Axl   AyM   Az.   A{   A{   A|   A}   A~   At   AU   A6   A   A   A   A脺   A腛   A|   A]   A>   A   A    A   A   A茣   A荄   Ae   AF   A'   A   A   A   A蓫   A蔌   Am   AN   A/   A   A   A   A蚳   A蛔   Au   AV   A7   A   A   A   A衻   A袜   A}   A^   A?   A    A   A   A   A詤   A誅   Af   AG   A(   A	   A   A   A谬   A豍   An   AO   A0   A   A   A   A跴   A踕   Av   AW   A8   A   A   A   A込   A违   A~   A_   A@   A!   A   A   A   Aƥ   Aǆ   Ag   AH   A)   A
   A   A   Aͭ   AΎ   Ao   AP   A1   A   A   A   AԵ   AՖ   Aw   AX   A9   A   A   A   A۽   Aܞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A    A   Ai   AJ   A+   A   A   A   A   A   A	q   A
R   A3   A   A   A
   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   A K   A!,   A"
   A"   A#   A$   A%   A&r   A'S   A(4   A)   A)   A*   A+   A,   A-z   A.[   A/<   A0   A0   A1   A2   A3   A4   A5c   A6D   A7%   A8   A8   A9   A:   A;   A<k   A=L   A>-   A?   A?   A@   AA   AB   ACs   ADT   AE5   AF   AF   AG   AH   AI   AJ{   AK\   AL=   AM   AM   AN   AO   AP   AQ   ARd   ASE   AT&   AU   AU   AV   AW   AX   AYl   AZM   A[.   A\   A\   A]   A^   A_   A`t   AaU   Ab6   Ac   Ac   Ad   Ae   Af   Ag|   Ah]   Ai>   Aj   Ak    Ak   Al   Am   An   Aoe   ApF   Aq'   Ar   Ar   As   At   Au   Avm   AwN   Ax/   Ay   Ay   Az   A{   A|   A}u   A~V   A7   A   A   A   A邻   A郜   A}   A^   A?   A    A   A   A   A銤   A鋅   Af   AG   A(   A	   A   A   A鑬   A钍   An   AO   A0   A   A   A   A阴   A陕   Av   AW   A8   A   A   A   A韼   A頝   A~   A_   A@   A!   A   A   A   A駥   A騆   Ag   AH   A)   A
   A   A   A鮭   A鯎   Ao   AP   A1   A   A   A   A鵵   A鶖   Aw   AX   A9   A   A   A   A鼽   A齞   A   A`   AA   A"   A   A   A   AĦ   AŇ   Ah   AI   A*   A   A   A   Aˮ   Ȁ   Ap   AQ   A2   A   A   A   AҶ   Aӗ   Ax   AY   A:   A   A   A   Aپ   Aڟ   Aۀ   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   A j   AK   A,   A
   A   A   A   A   Ar   AS   A	4   A
   A
   A   A   A
   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A    A    A!   A"   A#   A$s   A%T   A&5   A'   A'   A(   A)   A*   A+{   A,\   A-=   A.   A.   A/   A0   A1   A2   A3d   A4E   A5&   A6   A6   A7   A8   A9   A:l   A;M   A<.   A=   A=   A>   A?   A@   AAt   ABU   AC6   AD   AD   AE   AF   AG   AH|   AI]   AJ>   AK   AL    AL   AM   AN   AO   APe   AQF   AR'   AS   AS   AT   AU   AV   AWm   AXN   AY/   AZ   AZ   A[   A\   A]   A^u   A_V   A`7   Aa   Aa   Ab   Ac   Ad   Ae}   Af^   Ag?   Ah    Ai   Ai   Aj   Ak   Al   Amf   AnG   Ao(   Ap	   Ap   Aq   Ar   As   Atn   AuO   Av0   Aw   Aw   Ax   Ay   Az   A{v   A|W   A}8   A~   A~   A   Aꀼ   Aꁝ   A~   A_   A@   A!   A   A   A   Aꈥ   Aꉆ   Ag   AH   A)   A
   A   A   Aꏭ   Aꐎ   Ao   AP   A1   A   A   A   Aꖵ   Aꗖ   Aw   AX   A9   A   A   A   AꝽ   AꞞ   A   A`   AA   A"   A   A   A   Aꥦ   Aꦇ   Ah   AI   A*   A   A   A   Aꬮ   Aꭏ   Ap   AQ   A2   A   A   A   A곶   A괗   Ax   AY   A:   A   A   A   A꺾   A껟   A꼀   Aa   AB   A#   A   A   A   A§   AÈ   Ai   AJ   A+   A   A   A   Aɯ   Aʐ   Aq   AR   A3   A   A   A   Aз   Aј   Ay   AZ   A;   A   A   A   A׿   Aؠ   Aف   Ab   AC   A$   A   A   A   Aߨ   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A -   A   A   A   A   A   As   AT   A5   A   A   A	   A
   A   A{   A
\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A    A!   A"t   A#U   A$6   A%   A%   A&   A'   A(   A)|   A*]   A+>   A,   A-    A-   A.   A/   A0   A1e   A2F   A3'   A4   A4   A5   A6   A7   A8m   A9N   A:/   A;   A;   A<   A=   A>   A?u   A@V   AA7   AB   AB   AC   AD   AE   AF}   AG^   AH?   AI    AJ   AJ   AK   AL   AM   ANf   AOG   AP(   AQ	   AQ   AR   AS   AT   AUn   AVO   AW0   AX   AX   AY   AZ   A[   A\v   A]W   A^8   A_   A_   A`   Aa   Ab   Ac~   Ad_   Ae@   Af!   Ag   Ag   Ah   Ai   Aj   Akg   AlH   Am)   An
   An   Ao   Ap   Aq   Aro   AsP   At1   Au   Au   Av   Aw   Ax   Ayw   AzX   A{9   A|   A|   A}   A~   A   A   A`   AA   A"   A   A   A   A놦   A뇇   Ah   AI   A*   A   A   A   A덮   A뎏   Ap   AQ   A2   A   A   A   A딶   A땗   Ax   AY   A:   A   A   A   A뛾   A뜟   A띀   Aa   AB   A#   A   A   A   A룧   A뤈   Ai   AJ   A+   A   A   A   A몯   A뫐   Aq   AR   A3   A   A   A   A뱷   A벘   Ay   AZ   A;   A   A   A   A븿   A빠   A뺁   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   Aǰ   Aȑ   Ar   AS   A4   A   A   A   Aθ   Aϙ   Az   A[   A<   A   A   A   A   A֡   Aׂ   Ac   AD   A%   A   A   A   Aݩ   Aފ   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A    A   A   At   AU   A6   A   A   A   A   A	   A
|   A]   A>   A
   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   A u   A!V   A"7   A#   A#   A$   A%   A&   A'}   A(^   A)?   A*    A+   A+   A,   A-   A.   A/f   A0G   A2	   A2   A3   A4   A5   A6n   A7O   A80   A9   A9   A:   A;   A<   A=v   A>W   A?8   A@   A@   AA   AB   AC   AD~   AE_   AF@   AG!   AH   AH   AI   AJ   AK   ALg   AMH   AN)   AO
   AO   AP   AQ   AR   ASo   ATP   AU1   AV   AV   AW   AX   AY   AZw   A[X   A\9   A]   A]   A^   A_   A`   Aa   Ab`   AcA   Ad"   Ae   Ae   Af   Ag   Ah   Aih   AjI   Ak*   Al   Al   Am   An   Ao   App   AqQ   Ar2   As   As   At   Au   Av   Awx   AxY   Ay:   Az   Az   A{   A|   A}   A~   Aa   AB   A#   A   A   A   A섧   A셈   Ai   AJ   A+   A   A   A   A싯   A쌐   Aq   AR   A3   A   A   A   A쒷   A쓘   Ay   AZ   A;   A   A   A   A왿   A욠   A웁   Ab   AC   A$   A   A   A   A졨   A좉   Aj   AK   A,   A
   A   A   A쨰   A쩑   Ar   AS   A4   A   A   A   A쯸   A찙   Az   A[   A<   A   A   A   A   A췡   A츂   Ac   AD   A%   A   A   A   A쾩   A쿊   Ak   AL   A-   A   A   A   Aű   Aƒ   As   AT   A5   A   A   A   A̹   A͚   A{   A\   A=   A   A   A   A   AԢ   AՃ   Ad   AE   A&   A   A   A   A۪   A܋   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A    Au   AV   A7   A   A   A   A   A   A}   A	^   A
?   A    A   A   A
   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A 8   A!   A!   A"   A#   A$   A%~   A&_   A'@   A(!   A)   A)   A*   A+   A,   A-g   A.H   A/)   A0
   A0   A1   A2   A3   A4o   A5P   A61   A7   A7   A8   A9   A:   A;w   A<X   A=9   A>   A>   A?   A@   AA   AB   AC`   ADA   AE"   AF   AF   AG   AH   AI   AJh   AKI   AL*   AM   AM   AN   AO   AP   AQp   ARQ   AS2   AT   AT   AU   AV   AW   AXx   AYY   AZ:   A[   A[   A\   A]   A^   A_   A`a   AaB   Ab#   Ac   Ac   Ad   Ae   Af   Agi   AhJ   Ai+   Aj   Aj   Ak   Al   Am   Anq   AoR   Ap3   Aq   Aq   Ar   As   At   Auy   AvZ   Aw;   Ax   Ax   Ay   Az   A{   A|   A}b   A~C   A$   A   A   A   A킨   A탉   Aj   AK   A,   A
   A   A   A퉰   A튑   Ar   AS   A4   A   A   A   A퐸   A푙   Az   A[   A<   A   A   A   A   A혡   A홂   Ac   AD   A%   A   A   A   Aퟩ   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   Aò   Aē   At   AU   A6   A   A   A   Aʺ   A˛   A|   A]   A>   A   A    A   A   Aң   Aӄ   Ae   AF   A'   A   A   A   A٫   Aڌ   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   A W   A8   A   A   A   A   A   A~   A_   A@   A	!   A
   A
   A   A   A
   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A    A!   A"   A#   A$`   A%A   A&"   A'   A'   A(   A)   A*   A+h   A,I   A-*   A.   A.   A/   A0   A1   A2p   A3Q   A42   A5   A5   A6   A7   A8   A9x   A:Y   A;:   A<   A<   A=   A>   A?   A@   AAa   ABB   AC#   AD   AD   AE   AF   AG   AHi   AIJ   AJ+   AK   AK   AL   AM   AN   AOq   APR   AQ3   AR   AR   AS   AT   AU   AVy   AWZ   AX;   AY   AY   AZ   A[   A\   A]   A^b   A_C   A`$   Aa   Aa   Ab   Ac   Ad   Aej   AfK   Ag,   Ah
   Ah   Ai   Aj   Ak   Alr   AmS   An4   Ao   Ao   Ap   Aq   Ar   Asz   At[   Au<   Av   Av   Aw   Ax   Ay   Az   A{c   A|D   A}%   A~   A~   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   AȻ   Aɜ   A}   A^   A?   A    A   A   A   AФ   Aх   Af   AG   A(   A	   A   A   A׬   A؍   An   AO   A0   A   A   A   A޴   Aߕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A    A    A   A   A   A   A`   AA   A"   A   A   A	   A
   A   Ah   A
I   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A    A!   A"a   A#B   A$#   A%   A%   A&   A'   A(   A)i   A*J   A++   A,   A,   A-   A.   A/   A0q   A1R   A23   A3   A3   A4   A5   A6   A7y   A8Z   A9;   A:   A:   A;   A<   A=   A>   A?b   A@C   AA$   AB   AB   AC   AD   AE   AFj   AGK   AH,   AI
   AI   AJ   AK   AL   AMr   ANS   AO4   AP   AP   AQ   AR   AS   ATz   AU[   AV<   AW   AW   AX   AY   AZ   A[   A\c   A]D   A^%   A_   A_   A`   Aa   Ab   Ack   AdL   Ae-   Af   Af   Ag   Ah   Ai   Ajs   AkT   Al5   Am   Am   An   Ao   Ap   Aq{   Ar\   As=   At   At   Au   Av   Aw   Ax   Ayd   AzE   A{&   A|   A|   A}   A~   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A嗢   A煮   A}   A^   A?   A    A   A   A   Aﱤ   Aﲅ   Af   AG   A(   A	   A   A   A︬   A﹍   An   AO   A0   A   A   A   A￴   A   Av   AW   A8   A   A   A   AƼ   Aǝ   A~   A_   A@   A!   A   A   A   AΥ   Aφ   Ag   AH   A)   A
   A   A   Aխ   A֎   Ao   AP   A1   A   A   A   Aܵ   Aݖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A    A   A   Aa   AB   A#   A   A   A   A   A	   A
i   AJ   A+   A
   A
   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   A b   A!C   A"$   A#   A#   A$   A%   A&   A'j   A(K   A),   A*
   A*   A+   A,   A-   A.r   A/S   A04   A1   A1   A2   A3   A4   A5z   A6[   A7<   A8   A8   A9   A:   A;   A<   A=c   A>D   A?%   A@   A@   AA   AB   AC   ADk   AEL   AF-   AG   AG   AH   AI   AJ   AKs   ALT   AM5   AN   AN   AO   AP   AQ   AR{   AS\   AT=   AU   AU   AV   AW   AX   AY   AZd   A[E   A\&   A]   A]   A^   A_   A`   Aal   AbM   Ac.   Ad   Ad   Ae   Af   Ag   Aht   AiU   Aj6   Ak   Ak   Al   Am   An   Ao|   Ap]   Aq>   Ar   As    As   At   Au   Av   Awe   AxF   Ay'   Az   Az   A{   A|   A}   A~m   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   AĽ   AŞ   A   A`   AA   A"   A   A   A   A̦   A͇   Ah   AI   A*   A   A   A   AӮ   Aԏ   Ap   AQ   A2   A   A   A   Aڶ   Aۗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A    Ab   AC   A$   A   A   A   A   A   Aj   A	K   A
,   A
   A   A   A
   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A %   A!   A!   A"   A#   A$   A%k   A&L   A'-   A(   A(   A)   A*   A+   A,s   A-T   A.5   A/   A/   A0   A1   A2   A3{   A4\   A5=   A6   A6   A7   A8   A9   A:   A;d   A<E   A=&   A>   A>   A?   A@   AA   ABl   ACM   AD.   AE   AE   AF   AG   AH   AIt   AJU   AK6   AL   AL   AM   AN   AO   AP|   AQ]   AR>   AS   AT    AT   AU   AV   AW   AXe   AYF   AZ'   A[   A[   A\   A]   A^   A_m   A`N   Aa/   Ab   Ab   Ac   Ad   Ae   Afu   AgV   Ah7   Ai   Ai   Aj   Ak   Al   Am}   An^   Ao?   Ap    Aq   Aq   Ar   As   At   Auf   AvG   Aw(   Ax	   Ax   Ay   Az   A{   A|n   A}O   A~0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A¾   Aß   AĀ   Aa   AB   A#   A   A   A   Aʧ   Aˈ   Ai   AJ   A+   A   A   A   Aѯ   AҐ   Aq   AR   A3   A   A   A   Aط   A٘   Ay   AZ   A;   A   A   A   A߿   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   A D   A%   A   A   A   A   A   Ak   AL   A-   A	   A	   A
   A   A   A
s   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A    A!   A"   A#l   A$M   A%.   A&   A&   A'   A(   A)   A*t   A+U   A,6   A-   A-   A.   A/   A0   A1|   A2]   A3>   A4   A5    A5   A6   A7   A8   A9e   A:F   A;'   A<   A<   A=   A>   A?   A@m   AAN   AB/   AC   AC   AD   AE   AF   AGu   AHV   AI7   AJ   AJ   AK   AL   AM   AN}   AO^   AP?   AQ    AR   AR   AS   AT   AU   AVf   AWG   AX(   AY	   AY   AZ   A[   A\   A]n   A^O   A_0   A`   A`   Aa   Ab   Ac   Adv   AeW   Af8   Ag   Ag   Ah   Ai   Aj   Ak~   Al_   Am@   An!   Ao   Ao   Ap   Aq   Ar   Asg   AtH   Au)   Av
   Av   Aw   Ax   Ay   Azo   A{P   A|1   A}   A}   A~   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   AȨ   Aɉ   Aj   AK   A,   A
   A   A   Aϰ   AБ   Ar   AS   A4   A   A   A   Aָ   Aי   Az   A[   A<   A   A   A   A   Aޡ   A߂   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A    A    A   A   A   Al   AM   A.   A   A   A   A	   A
   At   AU   A
6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A    A!m   A"N   A#/   A$   A$   A%   A&   A'   A(u   A)V   A*7   A+   A+   A,   A-   A.   A/}   A0^   A1?   A2    A3   A3   A4   A5   A6   A7f   A8G   A9(   A:	   A:   A;   A<   A=   A>n   A?O   A@0   AA   AA   AB   AC   AD   AEv   AFW   AG8   AH   AH   AI   AJ   AK   AL~   AM_   AN@   AO!   AP   AP   AQ   AR   AS   ATg   AUH   AV)   AW
   AW   AX   AY   AZ   A[o   A\P   A]1   A^   A^   A_   A`   Aa   Abw   AcX   Ad9   Ae   Ae   Af   Ag   Ah   Ai   Aj`   AkA   Al"   Am   Am   An   Ao   Ap   Aqh   ArI   As*   At   At   Au   Av   Aw   Axp   AyQ   Az2   A{   A{   A|   A}   A~   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   AƩ   AǊ   Ak   AL   A-   A   A   A   Aͱ   AΒ   As   AT   A5   A   A   A   AԹ   A՚   A{   A\   A=   A   A   A   A   Aܢ   A݃   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A    A   Am   AN   A/   A   A   A   A   A   A	u   A
V   A7   A   A   A
   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   A O   A!0   A"   A"   A#   A$   A%   A&v   A'W   A(8   A)   A)   A*   A+   A,   A-~   A._   A/@   A0!   A1   A1   A2   A3   A4   A5g   A6H   A7)   A8
   A8   A9   A:   A;   A<o   A=P   A>1   A?   A?   A@   AA   AB   ACw   ADX   AE9   AF   AF   AG   AH   AI   AJ   AK`   ALA   AM"   AN   AN   AO   AP   AQ   ARh   ASI   AT*   AU   AU   AV   AW   AX   AYp   AZQ   A[2   A\   A\   A]   A^   A_   A`x   AaY   Ab:   Ac   Ac   Ad   Ae   Af   Ag   Aha   AiB   Aj#   Ak   Ak   Al   Am   An   Aoi   ApJ   Aq+   Ar   Ar   As   At   Au   Avq   AwR   Ax3   Ay   Ay   Az   A{   A|   A}y   A~Z   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   AĪ   Aŋ   Al   AM   A.   A   A   A   A˲   A̓   At   AU   A6   A   A   A   AҺ   Aӛ   A|   A]   A>   A   A    A   A   Aڣ   Aۄ   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   A n   AO   A0   A   A   A   A   A   Av   AW   A	8   A
   A
   A   A   A
   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A    A    A!   A"   A#   A$w   A%X   A&9   A'   A'   A(   A)   A*   A+   A,`   A-A   A."   A/   A/   A0   A1   A2   A3h   A4I   A5*   A6   A6   A7   A8   A9   A:p   A;Q   A<2   A=   A=   A>   A?   A@   AAx   ABY   AC:   AD   AD   AE   AF   AG   AH   AIa   AJB   AK#   AL   AL   AM   AN   AO   APi   AQJ   AR+   AS   AS   AT   AU   AV   AWq   AXR   AY3   AZ   AZ   A[   A\   A]   A^y   A_Z   A`;   Aa   Aa   Ab   Ac   Ad   Ae   Afb   AgC   Ah$   Ai   Ai   Aj   Ak   Al   Amj   AnK   Ao,   Ap
   Ap   Aq   Ar   As   Atr   AuS   Av4   Aw   Aw   Ax   Ay   Az   A{z   A|[   A}<   A~   A~   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A«   AÌ   Am   AN   A/   A   A   A   Aɳ   Aʔ   Au   AV   A7   A   A   A   Aл   Aќ   A}   A^   A?   A    A   A   A   Aؤ   Aم   Af   AG   A(   A	   A   A   A߬   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A 1   A   A   A   A   A   Aw   AX   A9   A   A   A	   A
   A   A   A
`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A    A!   A"x   A#Y   A$:   A%   A%   A&   A'   A(   A)   A*a   A+B   A,#   A-   A-   A.   A/   A0   A1i   A2J   A3+   A4   A4   A5   A6   A7   A8q   A9R   A:3   A;   A;   A<   A=   A>   A?y   A@Z   AA;   AB   AB   AC   AD   AE   AF   AGb   AHC   AI$   AJ   AJ   AK   AL   AM   ANj   AOK   AP,   AQ
   AQ   AR   AS   AT   AUr   AVS   AW4   AX   AX   AY   AZ   A[   A\z   A][   A^<   A_   A_   A`   Aa   Ab   Ac   Adc   AeD   Af%   Ag   Ag   Ah   Ai   Aj   Akk   AlL   Am-   An   An   Ao   Ap   Aq   Ars   AsT   At5   Au   Au   Av   Aw   Ax   Ay{   Az\   A{=   A|   A|   A}   A~   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   AǴ   Aȕ   Av   AW   A8   A   A   A   Aμ   Aϝ   A~   A_   A@   A!   A   A   A   A֥   A׆   Ag   AH   A)   A
   A   A   Aݭ   Aގ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A    A   A   Ax   AY   A:   A   A   A   A   A	   A
   Aa   AB   A
#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   A y   A!Z   A";   A#   A#   A$   A%   A&   A'   A(b   A)C   A*$   A+   A+   A,   A-   A.   A/j   A0K   A1,   A2
   A2   A3   A4   A5   A6r   A7S   A84   A9   A9   A:   A;   A<   A=z   A>[   A?<   A@   A@   AA   AB   AC   AD   AEc   AFD   AG%   AH   AH   AI   AJ   AK   ALk   AML   AN-   AO   AO   AP   AQ   AR   ASs   ATT   AU5   AV   AV   AW   AX   AY   AZ{   A[\   A\=   A]   A]   A^   A_   A`   Aa   Abd   AcE   Ad&   Ae   Ae   Af   Ag   Ah   Ail   AjM   Ak.   Al   Al   Am   An   Ao   Apt   AqU   Ar6   As   As   At   Au   Av   Aw|   Ax]   Ay>   Az   A{    A{   A|   A}   A~   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   Aŵ   AƖ   Aw   AX   A9   A   A   A   A̽   A͞   A   A`   AA   A"   A   A   A   AԦ   AՇ   Ah   AI   A*   A   A   A   Aۮ   A܏   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A    Ay   AZ   A;   A   A   A   A   A   A   A	b   A
C   A$   A   A   A
   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A <   A!   A!   A"   A#   A$   A%   A&c   A'D   A(%   A)   A)   A*   A+   A,   A-k   A.L   A/-   A0   A0   A1   A2   A3   A4s   A5T   A65   A7   A7   A8   A9   A:   A;{   A<\   A==   A>   A>   A?   A@   AA   AB   ACd   ADE   AE&   AF   AF   AG   AH   AI   AJl   AKM   AL.   AM   AM   AN   AO   AP   AQt   ARU   AS6   AT   AT   AU   AV   AW   AX|   AY]   AZ>   A[   A\    A\   A]   A^   A_   A`e   AaF   Ab'   Ac   Ac   Ad   Ae   Af   Agm   AhN   Ai/   Aj   Aj   Ak   Al   Am   Anu   AoV   Ap7   Aq   Aq   Ar   As   At   Au}   Av^   Aw?   Ax    Ay   Ay   Az   A{   A|   A}f   A~G   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   Aö   Aė   Ax   AY   A:   A   A   A   Aʾ   A˟   À   Aa   AB   A#   A   A   A   Aҧ   Aӈ   Ai   AJ   A+   A   A   A   Aٯ   Aڐ   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A [   A<   A   A   A   A   A   A   Ac   AD   A	%   A
   A
   A   A   A
   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A    A!   A"   A#   A$d   A&&   A'   A'   A(   A)   A*   A+l   A,M   A-.   A.   A.   A/   A0   A1   A2t   A3U   A46   A5   A5   A6   A7   A8   A9|   A:]   A;>   A<   A=    A=   A>   A?   A@   AAe   ABF   AC'   AD   AD   AE   AF   AG   AHm   AIN   AJ/   AK   AK   AL   AM   AN   AOu   APV   AQ7   AR   AR   AS   AT   AU   AV}   AW^   AX?   AY    AZ   AZ   A[   A\   A]   A^f   A_G   A`(   Aa	   Aa   Ab   Ac   Ad   Aen   AfO   Ag0   Ah   Ah   Ai   Aj   Ak   Alv   AmW   An8   Ao   Ao   Ap   Aq   Ar   As~   At_   Au@   Av!   Aw   Aw   Ax   Ay   Az   A{g   A|H   A})   A~
   A~   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   Aȿ   Aɠ   Aʁ   Ab   AC   A$   A   A   A   AШ   Aщ   Aj   AK   A,   A
   A   A   Aװ   Aؑ   Ar   AS   A4   A   A   A   A޸   Aߙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A    A    A   A   A   A   Ad   AE   A&   A   A   A	   A
   A   Al   A
M   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A    A!   A"e   A#F   A$'   A%   A%   A&   A'   A(   A)m   A*N   A+/   A,   A,   A-   A.   A/   A0u   A1V   A27   A3   A3   A4   A5   A6   A7}   A8^   A9?   A:    A;   A;   A<   A=   A>   A?f   A@G   AA(   AB	   AB   AC   AD   AE   AFn   AGO   AH0   AI   AI   AJ   AK   AL   AMv   ANW   AO8   AP   AP   AQ   AR   AS   AT~   AU_   AV@   AW!   AX   AX   AY   AZ   A[   A\g   A]H   A^)   A_
   A_   A`   Aa   Ab   Aco   AdP   Ae1   Af   Af   Ag   Ah   Ai   Ajw   AkX   Al9   Am   Am   An   Ao   Ap   Aq   Ar`   AsA   At"   Au   Au   Av   Aw   Ax   Ayh   AzI   A{*   A|   A|   A}   A~   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aǡ   AȂ   Ac   AD   A%   A   A   A   AΩ   Aϊ   Ak   AL   A-   A   A   A   Aձ   A֒   As   AT   A5   A   A   A   Aܹ   Aݚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A    A   A   Ae   AF   A'   A   A   A   A   A	   A
m   AN   A/   A
   A
   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   A f   A!G   A"(   A#	   A#   A$   A%   A&   A'n   A(O   A)0   A*   A*   A+   A,   A-   A.v   A/W   A08   A1   A1   A2   A3   A4   A5~   A6_   A7@   A8!   A9   A9   A:   A;   A<   A=g   A>H   A?)   A@
   A@   AA   AB   AC   ADo   AEP   AF1   AG   AG   AH   AI   AJ   AKw   ALX   AM9   AN   AN   AO   AP   AQ   AR   AS`   ATA   AU"   AV   AV   AW   AX   AY   AZh   A[I   A\*   A]   A]   A^   A_   A`   Aap   AbQ   Ac2   Ad   Ad   Ae   Af   Ag   Ahx   AiY   Aj:   Ak   Ak   Al   Am   An   Ao   Apa   AqB   Ar#   As   As   At   Au   Av   Awi   AxJ   Ay+   Az   Az   A{   A|   A}   A~q   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AŢ   Aƃ   Ad   AE   A&   A   A   A   A̪   A͋   Al   AM   A.   A   A   A   AӲ   Aԓ   At   AU   A6   A   A   A   Aں   Aۛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A    Af   AG   A(   A	   A   A   A   A   An   A	O   A
0   A   A   A   A
   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A )   A!
   A!   A"   A#   A$   A%o   A&P   A'1   A(   A(   A)   A*   A+   A,w   A-X   A.9   A/   A/   A0   A1   A2   A3   A4`   A5A   A6"   A7   A7   A8   A9   A:   A;h   A<I   A=*   A>   A>   A?   A@   AA   ABp   ACQ   AD2   AE   AE   AF   AG   AH   AIx   AJY   AK:   AL   AL   AM   AN   AO   AP   AQa   ARB   AS#   AT   AT   AU   AV   AW   AXi   AYJ   AZ+   A[   A[   A\   A]   A^   A_q   A`R   Aa3   Ab   Ab   Ac   Ad   Ae   Afy   AgZ   Ah;   Ai   Ai   Aj   Ak   Al   Am   Anb   AoC   Ap$   Aq   Aq   Ar   As   At   Auj   AvK   Aw,   Ax
   Ax   Ay   Az   A{   A|r   A}S   A~4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aã   AĄ   Ae   AF   A'   A   A   A   Aʫ   Aˌ   Am   AN   A/   A   A   A   Aѳ   AҔ   Au   AV   A7   A   A   A   Aػ   Aٜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   A    A    A h   A    A    A    A a   A B   A    A    A    A    A п   A $   A    A    A    A   A-   AA?   AC   AD   AE   AF   AGf   AHG   AI(   AJ	   AJ   AK   AL   AM   ANn   AOO   AP0   AQ   AQ   AY   Arw   Aw   Ax   Ay   Az`   A{A   A|"   A   A   A   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   AǸ   Aș   Az   A[   A<   A   A   A   A   Aϡ   AЂ   Ac   AD   A%   A   A   A   A֩   A׊   Ak   AL   A-   A   A   A   Aݱ   Aޒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A    A   A   A|   A]   A>   A   A    A   A   A	   A
   Ae   AF   A
'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A }   A!^   A"?   A#    A$   A$   A%   A&   A'   A(f   A)G   A*(   A+	   A+   A,   A-   A.   A/n   A0O   A10   A2   A2   A3   A4   A5   A6v   A7W   A88   A9   A9   A:   A;   A<   A=~   A>_   A?@   A@!   AA   AA   AB   AC   AD   AEg   AFH   AG)   AH
   AH   AI   AJ   AK   ALo   AMP   AN1   AO   AO   AP   AQ   AR   ASw   ATX   AU9   AV   AV   AW   AX   AY   AZ   A[`   A\A   A]"   A^   A^   A_   A`   Aa   Abh   AcI   Ad*   Ae   Ae   Af   Ag   Ah   Aip   AjQ   Ak2   Al   Al   Am   An   Ao   Apx   AqY   Ar:   As   As   At   Au   Av   Aw   Axa   AyB   Az#   A{   A{   A|   A}   A~   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   AŹ   Aƚ   A{   A\   A=   A   A   A   A   A͢   A΃   Ad   AE   A&   A   A   A   AԪ   AՋ   Al   AM   A.   A   A   A   A۲   Aܓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A    A}   A^   A?   A    A   A   A   A   A   A	f   A
G   A(   A	   A   A
   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A @   A!!   A"   A"   A#   A$   A%   A&g   A'H   A()   A)
   A)   A*   A+   A,   A-o   A.P   A/1   A0   A0   A1   A2   A3   A4w   A5X   A69   A7   A7   A8   A9   A:   A;   A<`   A=A   A>"   A?   A?   A@   AA   AB   ACh   ADI   AE*   AF   AF   AG   AH   AI   AJp   AKQ   AL2   AM   AM   AN   AO   AP   AQx   ARY   AS:   AT   AT   AU   AV   AW   AX   AYa   AZB   A[#   A\   A\   A]   A^   A_   A`i   AaJ   Ab+   Ac   Ac   Ad   Ae   Af   Agq   AhR   Ai3   Aj   Aj   Ak   Al   Am   Any   AoZ   Ap;   Aq   Aq   Ar   As   At   Au   Avb   AwC   Ax$   Ay   Ay   Az   A{   A|   A}j   A~K   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   Aú   Aě   A|   A]   A>   A   A    A   A   Aˣ   A̄   Ae   AF   A'   A   A   A   Aҫ   Aӌ   Am   AN   A/   A   A   A   Aٳ   Aڔ   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A _   A@   A!   A   A   A   A   A   Ag   AH   A	)   A

   A
   A   A   A
   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A    A    A!   A"   A#   A$h   A%I   A&*   A'   A'   A(   A)   A*   A+p   A,Q   A-2   A.   A.   A/   A0   A1   A2x   A3Y   A4:   A5   A5   A6   A7   A8   A9   A:a   A;B   A<#   A=   A=   A>   A?   A@   AAi   ABJ   AC+   AD   AD   AE   AF   AG   AHq   AIR   AJ3   AK   AK   AL   AM   AN   AOy   APZ   AQ;   AR   AR   AS   AT   AU   AV   AWb   AXC   AY$   AZ   AZ   A[   A\   A]   A^j   A_K   A`,   Aa
   Aa   Ab   Ac   Ad   Aer   AfS   Ag4   Ah   Ah   Ai   Aj   Ak   Alz   Am[   An<   Ao   Ao   Ap   Aq   Ar   As   Atc   AuD   Av%   Aw   Aw   Ax   Ay   Az   A{k   A|L   A}-   A~   A~   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   Aɤ   Aʅ   Af   AG   A(   A	   A   A   AЬ   Aэ   An   AO   A0   A   A   A   A״   Aؕ   Av   AW   A8   A   A   A   A޼   Aߝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A "   A   A   A   A   A   Ah   AI   A*   A   A   A	   A
   A   Ap   A
Q   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A    A!   A"i   A#J   A$+   A%   A%   A&   A'   A(   A)q   A*R   A+3   A,   A,   A-   A.   A/   A0y   A1Z   A2;   A3   A3   A4   A5   A6   A7   A8b   A9C   A:$   A;   A;   A<   A=   A>   A?j   A@K   AA,   AB
   AB   AC   AD   AE   AFr   AGS   AH4   AI   AI   AJ   AK   AL   AMz   AN[   AO<   AP   AP   AQ   AR   AS   AT   AUc   AVD   AW%   AX   AX   AY   AZ   A[   A\k   A]L   A^-   A_   A_   A`   Aa   Ab   Acs   AdT   Ae5   Af   Af   Ag   Ah   Ai   Aj{   Ak\   Al=   Am   Am   An   Ao   Ap   Aq   Ard   AsE   At&   Au   Au   Av   Aw   Ax   Ayl   AzM   A{.   A|   A|   A}   A~   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   Aǥ   AȆ   Ag   AH   A)   A
   A   A   Aέ   Aώ   Ao   AP   A1   A   A   A   Aյ   A֖   Aw   AX   A9   A   A   A   Aܽ   Aݞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A    A   A   Ai   AJ   A+   A   A   A   A   A	   A
q   AR   A3   A
   A
   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   A j   A!K   A",   A#
   A#   A$   A%   A&   A'r   A(S   A)4   A*   A*   A+   A,   A-   A.z   A/[   A0<   A1   A1   A2   A3   A4   A5   A6c   A7D   A8%   A9   A9   A:   A;   A<   A=k   A>L   A?-   A@   A@   AA   AB   AC   ADs   AET   AF5   AG   AG   AH   AI   AJ   AK{   AL\   AM=   AN   AN   AO   AP   AQ   AR   ASd   ATE   AU&   AV   AV   AW   AX   AY   AZl   A[M   A\.   A]   A]   A^   A_   A`   Aat   AbU   Ac6   Ad   Ad   Ae   Af   Ag   Ah|   Ai]   Aj>   Ak   Al    Al   Am   An   Ao   Ape   AqF   Ar'   As   As   At   Au   Av   Awm   AxN   Ay/   Az   Az   A{   A|   A}   A~u   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   AŦ   AƇ   Ah   AI   A*   A   A   A   A̮   A͏   Ap   AQ   A2   A   A   A   AӶ   Aԗ   Ax   AY   A:   A   A   A   Aھ   A۟   A܀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A    Aj   AK   A,   A
   A   A   A   A   Ar   A	S   A
4   A   A   A   A
   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A -   A!   A!   A"   A#   A$   A%s   A&T   A'5   A(   A(   A)   A*   A+   A,{   A-\   A.=   A/   A/   A0   A1   A2   A3   A4d   A5E   A6&   A7   A7   A8   A9   A:   A;l   A<M   A=.   A>   A>   A?   A@   AA   ABt   ACU   AD6   AE   AE   AF   AG   AH   AI|   AJ]   AK>   AL   AM    AM   AN   AO   AP   AQe   ARF   AS'   AT   AT   AU   AV   AW   AXm   AYN   AZ/   A[   A[   A\   A]   A^   A_u   A`V   Aa7   Ab   Ab   Ac   Ad   Ae   Af}   Ag^   Ah?   Ai    Aj   Aj   Ak   Al   Am   Anf   AoG   Ap(   Aq	   Aq   Ar   As   At   Aun   AvO   Aw0   Ax   Ax   Ay   Az   A{   A|v   A}W   A~8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   Aç   AĈ   Ai   AJ   A+   A   A   A   Aʯ   Aː   Aq   AR   A3   A   A   A   Aѷ   AҘ   Ay   AZ   A;   A   A   A   Aؿ   A٠   Aځ   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   A L   A-   A   A   A   A   A   As   AT   A5   A	   A	   A
   A   A   A
{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A    A!   A"   A#t   A$U   A%6   A&   A&   A'   A(   A)   A*|   A+]   A,>   A-   A.    A.   A/   A0   A1   A2e   A3F   A4'   A5   A5   A6   A7   A8   A9m   A:N   A;/   A<   A<   A=   A>   A?   A@u   AAV   AB7   AC   AC   AD   AE   AF   AG}   AH^   AI?   AJ    AK   AK   AL   AM   AN   AOf   APG   AQ(   AR	   AR   AS   AT   AU   AVn   AWO   AX0   AY   AY   AZ   A[   A\   A]v   A^W   A_8   A`   A`   Aa   Ab   Ac   Ad~   Ae_   Af@   Ag!   Ah   Ah   Ai   Aj   Ak   Alg   AmH   An)   Ao
   Ao   Ap   Aq   Ar   Aso   AtP   Au1   Av   Av   Aw   Ax   Ay   Azw   A{X   A|9   A}   A}   A~   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   AȰ   Aɑ   Ar   AS   A4   A   A   A   Aϸ   AЙ   Az   A[   A<   A   A   A   A   Aס   A؂   Ac   AD   A%   A   A   A   Aީ   Aߊ   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A	    A	    A	   A	   A	   A	t   A	U   A	6   A	   A	   A	   A		   A	
   A	|   A	]   A	
>   A	   A	    A	   A	   A	   A	   A	e   A	F   A	'   A	   A	   A	   A	   A	   A	m   A	N   A	/   A	   A	   A	   A	   A	    A	!u   A	"V   A	#7   A	$   A	$   A	%   A	&   A	'   A	(}   A	)^   A	*?   A	+    A	,   A	,   A	-   A	.   A	/   A	0f   A	1G   A	2(   A	3	   A	3   A	4   A	5   A	6   A	7n   A	8O   A	90   A	:   A	:   A	;   A	<   A	=   A	>v   A	?W   A	@8   A	A   A	A   A	B   A	C   A	D   A	E~   A	F_   A	G@   A	H!   A	I   A	I   A	J   A	K   A	L   A	Mg   A	NH   A	O)   A	P
   A	P   A	Q   A	R   A	S   A	To   A	UP   A	V1   A	W   A	W   A	X   A	Y   A	Z   A	[w   A	\X   A	]9   A	^   A	^   A	_   A	`   A	a   A	b   A	c`   A	dA   A	e"   A	f   A	f   A	g   A	h   A	i   A	jh   A	kI   A	l*   A	m   A	m   A	n   A	o   A	p   A	qp   A	rQ   A	s2   A	t   A	t   A	u   A	v   A	w   A	xx   A	yY   A	z:   A	{   A	{   A	|   A	}   A	~   A	   A	a   A	B   A	#   A	   A	   A	   A	   A	   A	i   A	J   A	+   A	   A	   A	   A	   A	   A	q   A	R   A	3   A	   A	   A	   A	   A	   A	y   A	Z   A	;   A	   A	   A	   A	   A	   A	   A	b   A	C   A	$   A	   A	   A	   A	   A	   A	j   A	K   A	,   A	
   A	   A	   A	   A	   A	r   A	S   A	4   A	   A	   A	   A	   A	   A	z   A	[   A	<   A	   A	   A	   A	   A	   A	   A	c   A	D   A	%   A	   A	   A	   A	   A	   A	k   A	L   A	-   A	   A	   A	   A	Ʊ   A	ǒ   A	s   A	T   A	5   A	   A	   A	   A	͹   A	Κ   A	{   A	\   A	=   A	   A	   A	   A	   A	բ   A	փ   A	d   A	E   A	&   A	   A	   A	   A	ܪ   A	݋   A	l   A	M   A	.   A	   A	   A	   A	   A	   A	t   A	U   A	6   A	   A	   A	   A	   A	   A	|   A	]   A	>   A	   A	    A	   A	   A	   A	   A	e   A	F   A	'   A	   A	   A	   A	   A	   A	m   A	N   A	/   A	   A	   A	   A
    A
   A
u   A
V   A
7   A
   A
   A
   A
   A
   A
	}   A

^   A
?   A
    A

   A

   A
   A
   A
   A
f   A
G   A
(   A
	   A
   A
   A
   A
   A
n   A
O   A
0   A
   A
   A
   A
   A
   A
v   A
 W   A
!8   A
"   A
"   A
#   A
$   A
%   A
&~   A
'_   A
(@   A
)!   A
*   A
*   A
+   A
,   A
-   A
.g   A
/H   A
0)   A
1
   A
1   A
2   A
3   A
4   A
5o   A
6P   A
71   A
8   A
8   A
9   A
:   A
;   A
<w   A
=X   A
>9   A
?   A
?   A
@   A
A   A
B   A
C   A
D`   A
EA   A
F"   A
G   A
G   A
H   A
I   A
J   A
Kh   A
LI   A
M*   A
N   A
N   A
O   A
P   A
Q   A
Rp   A
SQ   A
T2   A
U   A
U   A
V   A
W   A
X   A
Yx   A
ZY   A
[:   A
\   A
\   A
]   A
^   A
_   A
`   A
aa   A
bB   A
c#   A
d   A
d   A
e   A
f   A
g   A
hi   A
iJ   A
j+   A
k   A
k   A
l   A
m   A
n   A
oq   A
pR   A
q3   A
r   A
r   A
s   A
t   A
u   A
vy   A
wZ   A
x;   A
y   A
y   A
z   A
{   A
|   A
}   A
~b   A
C   A
$   A
   A
   A
   A
   A
   A
j   A
K   A
,   A

   A
   A
   A
   A
   A
r   A
S   A
4   A
   A
   A
   A
   A
   A
z   A
[   A
<   A
   A
   A
   A
   A
   A
   A
c   A
D   A
%   A
   A
   A
   A
   A
   A
k   A
L   A
-   A
   A
   A
   A
   A
   A
s   A
T   A
5   A
   A
   A
   A
   A
   A
{   A
\   A
=   A
   A
   A
   A
   A
   A
   A
d   A
E   A
&   A
   A
   A
   A
   A
   A
l   A
M   A
.   A
   A
   A
   A
Ĳ   A
œ   A
t   A
U   A
6   A
   A
   A
   A
˺   A
̛   A
|   A
]   A
>   A
   A
    A
   A
   A
ӣ   A
Ԅ   A
e   A
F   A
'   A
   A
   A
   A
ګ   A
ی   A
m   A
N   A
/   A
   A
   A
   A
   A
   A
u   A
V   A
7   A
   A
   A
   A
   A
   A
}   A
^   A
?   A
    A
   A
   A
   A
   A
   A
f   A
G   A
(   A
	   A
   A
   A
   A
   A
n   A
O   A
0   A
   A
   A
   A
   A
   A v   AW   A8   A   A   A   A   A   A~   A_   A	@   A
!   A   A   A   A
   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A    A    A!   A"   A#   A$   A%`   A&A   A'"   A(   A(   A)   A*   A+   A,h   A-I   A.*   A/   A/   A0   A1   A2   A3p   A4Q   A52   A6   A6   A7   A8   A9   A:x   A;Y   A<:   A=   A=   A>   A?   A@   AA   ABa   ACB   AD#   AE   AE   AF   AG   AH   AIi   AJJ   AK+   AL   AL   AM   AN   AO   APq   AQR   AR3   AS   AS   AT   AU   AV   AWy   AXZ   AY;   AZ   AZ   A[   A\   A]   A^   A_b   A`C   Aa$   Ab   Ab   Ac   Ad   Ae   Afj   AgK   Ah,   Ai
   Ai   Aj   Ak   Al   Amr   AnS   Ao4   Ap   Ap   Aq   Ar   As   Atz   Au[   Av<   Aw   Aw   Ax   Ay   Az   A{   A|c   A}D   A~%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A³   AÔ   Au   AV   A7   A   A   A   Aɻ   Aʜ   A}   A^   A?   A    A   A   A   AѤ   A҅   Af   AG   A(   A	   A   A   Aج   Aٍ   An   AO   A0   A   A   A   Aߴ   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A 9   A   A   A   A   A   A   A`   AA   A"   A	   A	   A
   A   A   A
h   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A    A!   A"   A#a   A$B   A%#   A&   A&   A'   A(   A)   A*i   A+J   A,+   A-   A-   A.   A/   A0   A1q   A2R   A33   A4   A4   A5   A6   A7   A8y   A9Z   A:;   A;   A;   A<   A=   A>   A?   A@b   AAC   AB$   AC   AC   AD   AE   AF   AGj   AHK   AI,   AJ
   AJ   AK   AL   AM   ANr   AOS   AP4   AQ   AQ   AR   AS   AT   AUz   AV[   AW<   AX   AX   AY   AZ   A[   A\   A]c   A^D   A_%   A`   A`   Aa   Ab   Ac   Adk   AeL   Af-   Ag   Ag   Ah   Ai   Aj   Aks   AlT   Am5   An   An   Ao   Ap   Aq   Ar{   As\   At=   Au   Au   Av   Aw   Ax   Ay   Azd   A{E   A|&   A}   A}   A~   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   AǼ   Aȝ   A~   A_   A@   A!   A   A   A   Aϥ   AІ   Ag   AH   A)   A
   A   A   A֭   A׎   Ao   AP   A1   A   A   A   Aݵ   Aޖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A
    A
   A
   A
   A
a   A
B   A
#   A
   A
   A
   A
	   A
   A
i   A
J   A

+   A
   A
   A
   A
   A
   A
q   A
R   A
3   A
   A
   A
   A
   A
   A
y   A
Z   A
;   A
   A
   A
   A
   A
   A
    A
!b   A
"C   A
#$   A
$   A
$   A
%   A
&   A
'   A
(j   A
)K   A
*,   A
+
   A
+   A
,   A
-   A
.   A
/r   A
0S   A
14   A
2   A
2   A
3   A
4   A
5   A
6z   A
7[   A
8<   A
9   A
9   A
:   A
;   A
<   A
=   A
>c   A
?D   A
@%   A
A   A
A   A
B   A
C   A
D   A
Ek   A
FL   A
G-   A
H   A
H   A
I   A
J   A
K   A
Ls   A
MT   A
N5   A
O   A
O   A
P   A
Q   A
R   A
S{   A
T\   A
U=   A
V   A
V   A
W   A
X   A
Y   A
Z   A
[d   A
\E   A
]&   A
^   A
^   A
_   A
`   A
a   A
bl   A
cM   A
d.   A
e   A
e   A
f   A
g   A
h   A
it   A
jU   A
k6   A
l   A
l   A
m   A
n   A
o   A
p|   A
q]   A
r>   A
s   A
t    A
t   A
u   A
v   A
w   A
xe   A
yF   A
z'   A
{   A
{   A
|   A
}   A
~   A
m   A
N   A
/   A
   A
   A
   A
   A
   A
u   A
V   A
7   A
   A
   A
   A
   A
   A
}   A
^   A
?   A
    A
   A
   A
   A
   A
   A
f   A
G   A
(   A
	   A
   A
   A
   A
   A
n   A
O   A
0   A
   A
   A
   A
   A
   A
v   A
W   A
8   A
   A
   A
   A
   A
   A
~   A
_   A
@   A
!   A
   A
   A
   A
   A
   A
g   A
H   A
)   A
   A
   A
   A
   A
   A
o   A
P   A
1   A
   A
   A
   A
   A
   A
w   A
X   A
9   A
   A
   A
   A
Ž   A
ƞ   A
   A
`   A
A   A
"   A
   A
   A
   A
ͦ   A
·   A
h   A
I   A
*   A
   A
   A
   A
Ԯ   A
Տ   A
p   A
Q   A
2   A
   A
   A
   A
۶   A
ܗ   A
x   A
Y   A
:   A
   A
   A
   A
   A
   A
   A
a   A
B   A
#   A
   A
   A
   A
   A
   A
i   A
J   A
+   A
   A
   A
   A
   A
   A
q   A
R   A
3   A
   A
   A
   A
   A
   A
y   A
Z   A
;   A
   A
   A
   A
   A    A   Ab   AC   A$   A   A   A   A   A   A	j   A
K   A,   A
   A   A
   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   A D   A!%   A"   A"   A#   A$   A%   A&k   A'L   A(-   A)   A)   A*   A+   A,   A-s   A.T   A/5   A0   A0   A1   A2   A3   A4{   A5\   A6=   A7   A7   A8   A9   A:   A;   A<d   A=E   A>&   A?   A?   A@   AA   AB   ACl   ADM   AE.   AF   AF   AG   AH   AI   AJt   AKU   AL6   AM   AM   AN   AO   AP   AQ|   AR]   AS>   AT   AU    AU   AV   AW   AX   AYe   AZF   A['   A\   A\   A]   A^   A_   A`m   AaN   Ab/   Ac   Ac   Ad   Ae   Af   Agu   AhV   Ai7   Aj   Aj   Ak   Al   Am   An}   Ao^   Ap?   Aq    Ar   Ar   As   At   Au   Avf   AwG   Ax(   Ay	   Ay   Az   A{   A|   A}n   A~O   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   Aþ   Ağ   Aŀ   Aa   AB   A#   A   A   A   A˧   A̈   Ai   AJ   A+   A   A   A   Aү   AӐ   Aq   AR   A3   A   A   A   Aٷ   Aژ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   A c   AD   A%   A   A   A   A   A   Ak   AL   A	-   A
   A
   A   A   A
   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A    A    A!   A"   A#   A$l   A%M   A&.   A'   A'   A(   A)   A*   A+t   A,U   A-6   A.   A.   A/   A0   A1   A2|   A3]   A4>   A5   A6    A6   A7   A8   A9   A:e   A;F   A<'   A=   A=   A>   A?   A@   AAm   ABN   AC/   AD   AD   AE   AF   AG   AHu   AIV   AJ7   AK   AK   AL   AM   AN   AO}   AP^   AQ?   AR    AS   AS   AT   AU   AV   AWf   AXG   AY(   AZ	   AZ   A[   A\   A]   A^n   A_O   A`0   Aa   Aa   Ab   Ac   Ad   Aev   AfW   Ag8   Ah   Ah   Ai   Aj   Ak   Al~   Am_   An@   Ao!   Ap   Ap   Aq   Ar   As   Atg   AuH   Av)   Aw
   Aw   Ax   Ay   Az   A{o   A|P   A}1   A~   A~   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A    AÁ   Ab   AC   A$   A   A   A   Aɨ   Aʉ   Aj   AK   A,   A
   A   A   Aа   Aё   Ar   AS   A4   A   A   A   A׸   Aؙ   Az   A[   A<   A   A   A   A   Aߡ   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A &   A   A   A   A   A   Al   AM   A.   A   A   A	   A
   A   At   A
U   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A    A!   A"m   A#N   A$/   A%   A%   A&   A'   A(   A)u   A*V   A+7   A,   A,   A-   A.   A/   A0}   A1^   A2?   A3    A4   A4   A5   A6   A7   A8f   A9G   A:(   A;	   A;   A<   A=   A>   A?n   A@O   AA0   AB   AB   AC   AD   AE   AFv   AGW   AH8   AI   AI   AJ   AK   AL   AM~   AN_   AO@   AP!   AQ   AQ   AR   AS   AT   AUg   AVH   AW)   AX
   AX   AY   AZ   A[   A\o   A]P   A^1   A_   A_   A`   Aa   Ab   Acw   AdX   Ae9   Af   Af   Ag   Ah   Ai   Aj   Ak`   AlA   Am"   An   An   Ao   Ap   Aq   Arh   AsI   At*   Au   Au   Av   Aw   Ax   Ayp   AzQ   A{2   A|   A|   A}   A~   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   Aǩ   AȊ   Ak   AL   A-   A   A   A   Aα   Aϒ   As   AT   A5   A   A   A   Aչ   A֚   A{   A\   A=   A   A   A   A   Aݢ   Aރ   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A    A   A   Am   AN   A/   A   A   A   A   A	   A
u   AV   A7   A
   A
   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   A n   A!O   A"0   A#   A#   A$   A%   A&   A'v   A(W   A)8   A*   A*   A+   A,   A-   A.~   A/_   A0@   A1!   A2   A2   A3   A4   A5   A6g   A7H   A8)   A9
   A9   A:   A;   A<   A=o   A>P   A?1   A@   A@   AA   AB   AC   ADw   AEX   AF9   AG   AG   AH   AI   AJ   AK   AL`   AMA   AN"   AO   AO   AP   AQ   AR   ASh   ATI   AU*   AV   AV   AW   AX   AY   AZp   A[Q   A\2   A]   A]   A^   A_   A`   Aax   AbY   Ac:   Ad   Ad   Ae   Af   Ag   Ah   Aia   AjB   Ak#   Al   Al   Am   An   Ao   Api   AqJ   Ar+   As   As   At   Au   Av   Awq   AxR   Ay3   Az   Az   A{   A|   A}   A~y   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   AŪ   AƋ   Al   AM   A.   A   A   A   A̲   A͓   At   AU   A6   A   A   A   AӺ   Aԛ   A|   A]   A>   A   A    A   A   Aۣ   A܄   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A    An   AO   A0   A   A   A   A   A   Av   A	W   A
8   A   A   A   A
   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A 1   A!   A!   A"   A#   A$   A%w   A&X   A'9   A(   A(   A)   A*   A+   A,   A-`   A.A   A/"   A0   A0   A1   A2   A3   A4h   A5I   A6*   A7   A7   A8   A9   A:   A;p   A<Q   A=2   A>   A>   A?   A@   AA   ABx   ACY   AD:   AE   AE   AF   AG   AH   AI   AJa   AKB   AL#   AM   AM   AN   AO   AP   AQi   ARJ   AS+   AT   AT   AU   AV   AW   AXq   AYR   AZ3   A[   A[   A\   A]   A^   A_y   A`Z   Aa;   Ab   Ab   Ac   Ad   Ae   Af   Agb   AhC   Ai$   Aj   Aj   Ak   Al   Am   Anj   AoK   Ap,   Aq
   Aq   Ar   As   At   Aur   AvS   Aw4   Ax   Ax   Ay   Az   A{   A|z   A}[   A~<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   Aë   AČ   Am   AN   A/   A   A   A   Aʳ   A˔   Au   AV   A7   A   A   A   Aѻ   AҜ   A}   A^   A?   A    A   A   A   A٤   Aڅ   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   A P   A1   A   A   A   A   A   Aw   AX   A9   A	   A	   A
   A   A   A
   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A    A!   A"   A#x   A$Y   A%:   A&   A&   A'   A(   A)   A*   A+a   A,B   A-#   A.   A.   A/   A0   A1   A2i   A3J   A4+   A5   A5   A6   A7   A8   A9q   A:R   A;3   A<   A<   A=   A>   A?   A@y   AAZ   AB;   AC   AC   AD   AE   AF   AG   AHb   AIC   AJ$   AK   AK   AL   AM   AN   AOj   APK   AQ,   AR
   AR   AS   AT   AU   AVr   AWS   AX4   AY   AY   AZ   A[   A\   A]z   A^[   A_<   A`   A`   Aa   Ab   Ac   Ad   Aec   AfD   Ag%   Ah   Ah   Ai   Aj   Ak   Alk   AmL   An-   Ao   Ao   Ap   Aq   Ar   Ass   AtT   Au5   Av   Av   Aw   Ax   Ay   Az{   A{\   A|=   A}   A}   A~   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   Aȴ   Aɕ   Av   AW   A8   A   A   A   Aϼ   AН   A~   A_   A@   A!   A   A   A   Aץ   A؆   Ag   AH   A)   A
   A   A   Aޭ   Aߎ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A    A    A   A   A   Ax   AY   A:   A   A   A   A	   A
   A   Aa   A
B   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A    A!y   A"Z   A#;   A$   A$   A%   A&   A'   A(   A)b   A*C   A+$   A,   A,   A-   A.   A/   A0j   A1K   A2,   A3
   A3   A4   A5   A6   A7r   A8S   A94   A:   A:   A;   A<   A=   A>z   A?[   A@<   AA   AA   AB   AC   AD   AE   AFc   AGD   AH%   AI   AI   AJ   AK   AL   AMk   ANL   AO-   AP   AP   AQ   AR   AS   ATs   AUT   AV5   AW   AW   AX   AY   AZ   A[{   A\\   A]=   A^   A^   A_   A`   Aa   Ab   Acd   AdE   Ae&   Af   Af   Ag   Ah   Ai   Ajl   AkM   Al.   Am   Am   An   Ao   Ap   Aqt   ArU   As6   At   At   Au   Av   Aw   Ax|   Ay]   Az>   A{   A|    A|   A}   A~   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   AƵ   Aǖ   Aw   AX   A9   A   A   A   Aͽ   AΞ   A   A`   AA   A"   A   A   A   Aզ   Aև   Ah   AI   A*   A   A   A   Aܮ   Aݏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A    A   Ay   AZ   A;   A   A   A   A   A   A	   A
b   AC   A$   A
   A
   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A [   A!<   A"   A"   A#   A$   A%   A&   A'c   A(D   A)%   A*   A*   A+   A,   A-   A.k   A/L   A0-   A1   A1   A2   A3   A4   A5s   A6T   A75   A8   A8   A9   A:   A;   A<{   A=\   A>=   A?   A?   A@   AA   AB   AC   ADd   AEE   AF&   AG   AG   AH   AI   AJ   AKl   ALM   AM.   AN   AN   AO   AP   AQ   ARt   ASU   AT6   AU   AU   AV   AW   AX   AY|   AZ]   A[>   A\   A]    A]   A^   A_   A`   Aae   AbF   Ac'   Ad   Ad   Ae   Af   Ag   Ahm   AiN   Aj/   Ak   Ak   Al   Am   An   Aou   ApV   Aq7   Ar   Ar   As   At   Au   Av}   Aw^   Ax?   Ay    Az   Az   A{   A|   A}   A~f   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   AĶ   Aŗ   Ax   AY   A:   A   A   A   A˾   A̟   A̀   Aa   AB   A#   A   A   A   Aӧ   AԈ   Ai   AJ   A+   A   A   A   Aگ   Aې   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   A z   A[   A<   A   A   A   A   A   A   Ac   A	D   A
%   A   A   A   A
   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A    A    A!   A"   A#   A$   A%d   A&E   A'&   A(   A(   A)   A*   A+   A,l   A-M   A..   A/   A/   A0   A1   A2   A3t   A4U   A56   A6   A6   A7   A8   A9   A:|   A;]   A<>   A=   A>    A>   A?   A@   AA   ABe   ACF   AD'   AE   AE   AF   AG   AH   AIm   AJN   AK/   AL   AL   AM   AN   AO   APu   AQV   AR7   AS   AS   AT   AU   AV   AW}   AX^   AY?   AZ    A[   A[   A\   A]   A^   A_f   A`G   Aa(   Ab	   Ab   Ac   Ad   Ae   Afn   AgO   Ah0   Ai   Ai   Aj   Ak   Al   Amv   AnW   Ao8   Ap   Ap   Aq   Ar   As   At~   Au_   Av@   Aw!   Ax   Ax   Ay   Az   A{   A|g   A}H   A~)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A·   AØ   Ay   AZ   A;   A   A   A   Aɿ   Aʠ   Aˁ   Ab   AC   A$   A   A   A   AѨ   A҉   Aj   AK   A,   A
   A   A   Aذ   Aّ   Ar   AS   A4   A   A   A   A߸   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A =   A   A   A   A   A   A   Ad   AE   A&   A	   A	   A
   A   A   A
l   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A    A!   A"   A#e   A$F   A%'   A&   A&   A'   A(   A)   A*m   A+N   A,/   A-   A-   A.   A/   A0   A1u   A2V   A37   A4   A4   A5   A6   A7   A8}   A9^   A:?   A;    A<   A<   A=   A>   A?   A@f   AAG   AB(   AC	   AC   AD   AE   AF   AGn   AHO   AI0   AJ   AJ   AK   AL   AM   ANv   AOW   AP8   AQ   AQ   AR   AS   AT   AU~   AV_   AW@   AX!   AY   AY   AZ   A[   A\   A]g   A^H   A_)   A`
   A`   Aa   Ab   Ac   Ado   AeP   Af1   Ag   Ag   Ah   Ai   Aj   Akw   AlX   Am9   An   An   Ao   Ap   Aq   Ar   As`   AtA   Au"   Av   Av   Aw   Ax   Ay   Azh   A{I   A|*   A}   A}   A~   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aȡ   Aɂ   Ac   AD   A%   A   A   A   Aϩ   AЊ   Ak   AL   A-   A   A   A   Aֱ   Aג   As   AT   A5   A   A   A   Aݹ   Aޚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A     A    A   A   A   Ae   AF   A'   A   A   A   A	   A
   Am   AN   A
/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A    A!f   A"G   A#(   A$	   A$   A%   A&   A'   A(n   A)O   A*0   A+   A+   A,   A-   A.   A/v   A0W   A18   A2   A2   A3   A4   A5   A6~   A7_   A8@   A9!   A:   A:   A;   A<   A=   A>g   A?H   A@)   AA
   AA   AB   AC   AD   AEo   AFP   AG1   AH   AH   AI   AJ   AK   ALw   AMX   AN9   AO   AO   AP   AQ   AR   AS   AT`   AUA   AV"   AW   AW   AX   AY   AZ   A[h   A\I   A]*   A^   A^   A_   A`   Aa   Abp   AcQ   Ad2   Ae   Ae   Af   Ag   Ah   Aix   AjY   Ak:   Al   Al   Am   An   Ao   Ap   Aqa   ArB   As#   At   At   Au   Av   Aw   Axi   AyJ   Az+   A{   A{   A|   A}   A~   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AƢ   Aǃ   Ad   AE   A&   A   A   A   Aͪ   A΋   Al   AM   A.   A   A   A   AԲ   AՓ   At   AU   A6   A   A   A   Aۺ   Aܛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A    A   Af   AG   A(   A	   A   A   A   A   A	n   A
O   A0   A   A   A
   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   A H   A!)   A"
   A"   A#   A$   A%   A&o   A'P   A(1   A)   A)   A*   A+   A,   A-w   A.X   A/9   A0   A0   A1   A2   A3   A4   A5`   A6A   A7"   A8   A8   A9   A:   A;   A<h   A=I   A>*   A?   A?   A@   AA   AB   ACp   ADQ   AE2   AF   AF   AG   AH   AI   AJx   AKY   AL:   AM   AM   AN   AO   AP   AQ   ARa   ASB   AT#   AU   AU   AV   AW   AX   AYi   AZJ   A[+   A\   A\   A]   A^   A_   A`q   AaR   Ab3   Ac   Ac   Ad   Ae   Af   Agy   AhZ   Ai;   Aj   Aj   Ak   Al   Am   An   Aob   ApC   Aq$   Ar   Ar   As   At   Au   Avj   AwK   Ax,   Ay
   Ay   Az   A{   A|   A}r   A~S   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aģ   Ań   Ae   AF   A'   A   A   A   A˫   A̌   Am   AN   A/   A   A   A   Aҳ   AӔ   Au   AV   A7   A   A   A   Aٻ   Aڜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   A g   AH   A)   A
   A   A   A   A   Ao   AP   A	1   A
   A
   A   A   A
   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A    A    A!   A"   A#   A$p   A%Q   A&2   A'   A'   A(   A)   A*   A+x   A,Y   A-:   A.   A.   A/   A0   A1   A2   A3a   A4B   A5#   A6   A6   A7   A8   A9   A:i   A;J   A<+   A=   A=   A>   A?   A@   AAq   ABR   AC3   AD   AD   AE   AF   AG   AHy   AIZ   AJ;   AK   AK   AL   AM   AN   AO   APb   AQC   AR$   AS   AS   AT   AU   AV   AWj   AXK   AY,   AZ
   AZ   A[   A\   A]   A^r   A_S   A`4   Aa   Aa   Ab   Ac   Ad   Aez   Af[   Ag<   Ah   Ah   Ai   Aj   Ak   Al   Amc   AnD   Ao%   Ap   Ap   Aq   Ar   As   Atk   AuL   Av-   Aw   Aw   Ax   Ay   Az   A{s   A|T   A}5   A~   A~   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A¤   AÅ   Af   AG   A(   A	   A   A   Aɬ   Aʍ   An   AO   A0   A   A   A   Aд   Aѕ   Av   AW   A8   A   A   A   A׼   A؝   A~   A_   A@   A!   A   A   A   Aߥ   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A *   A   A   A   A   A   Ap   AQ   A2   A   A   A	   A
   A   Ax   A
Y   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A    A!   A"q   A#R   A$3   A%   A%   A&   A'   A(   A)y   A*Z   A+;   A,   A,   A-   A.   A/   A0   A1b   A2C   A3$   A4   A4   A5   A6   A7   A8j   A9K   A:,   A;
   A;   A<   A=   A>   A?r   A@S   AA4   AB   AB   AC   AD   AE   AFz   AG[   AH<   AI   AI   AJ   AK   AL   AM   ANc   AOD   AP%   AQ   AQ   AR   AS   AT   AUk   AVL   AW-   AX   AX   AY   AZ   A[   A\s   A]T   A^5   A_   A_   A`   Aa   Ab   Ac{   Ad\   Ae=   Af   Af   Ag   Ah   Ai   Aj   Akd   AlE   Am&   An   An   Ao   Ap   Aq   Arl   AsM   At.   Au   Au   Av   Aw   Ax   Ayt   AzU   A{6   A|   A|   A}   A~   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   Aǭ   AȎ   Ao   AP   A1   A   A   A   Aε   Aϖ   Aw   AX   A9   A   A   A   Aս   A֞   A   A`   AA   A"   A   A   A   Aݦ   Aއ   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A    A   A   Aq   AR   A3   A   A   A   A   A	   A
y   AZ   A;   A
   A
   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   A r   A!S   A"4   A#   A#   A$   A%   A&   A'z   A([   A)<   A*   A*   A+   A,   A-   A.   A/c   A0D   A1%   A2   A2   A3   A4   A5   A6k   A7L   A8-   A9   A9   A:   A;   A<   A=s   A>T   A?5   A@   A@   AA   AB   AC   AD{   AE\   AF=   AG   AG   AH   AI   AJ   AK   ALd   AME   AN&   AO   AO   AP   AQ   AR   ASl   ATM   AU.   AV   AV   AW   AX   AY   AZt   A[U   A\6   A]   A]   A^   A_   A`   Aa|   Ab]   Ac>   Ad   Ae    Ae   Af   Ag   Ah   Aie   AjF   Ak'   Al   Al   Am   An   Ao   Apm   AqN   Ar/   As   As   At   Au   Av   Awu   AxV   Ay7   Az   Az   A{   A|   A}   A~}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   AŮ   AƏ   Ap   AQ   A2   A   A   A   A̶   A͗   Ax   AY   A:   A   A   A   AӾ   Aԟ   AՀ   Aa   AB   A#   A   A   A   Aۧ   A܈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A    Ar   AS   A4   A   A   A   A   A   Az   A	[   A
<   A   A   A   A
   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A 5   A!   A!   A"   A#   A$   A%{   A&\   A'=   A(   A(   A)   A*   A+   A,   A-d   A.E   A/&   A0   A0   A1   A2   A3   A4l   A5M   A6.   A7   A7   A8   A9   A:   A;t   A<U   A=6   A>   A>   A?   A@   AA   AB|   AC]   AD>   AE   AF    AF   AG   AH   AI   AJe   AKF   AL'   AM   AM   AN   AO   AP   AQm   ARN   AS/   AT   AT   AU   AV   AW   AXu   AYV   AZ7   A[   A[   A\   A]   A^   A_}   A`^   Aa?   Ab    Ac   Ac   Ad   Ae   Af   Agf   AhG   Ai(   Aj	   Aj   Ak   Al   Am   Ann   AoO   Ap0   Aq   Aq   Ar   As   At   Auv   AvW   Aw8   Ax   Ax   Ay   Az   A{   A|~   A}_   A~@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   Aï   AĐ   Aq   AR   A3   A   A   A   Aʷ   A˘   Ay   AZ   A;   A   A   A   Aѿ   AҠ   AӁ   Ab   AC   A$   A   A   A   A٨   Aډ   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   A T   A5   A   A   A   A   A   A{   A\   A=   A	   A	   A
   A   A   A
   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A    A!   A"   A#|   A$]   A%>   A&   A'    A'   A(   A)   A*   A+e   A,F   A-'   A.   A.   A/   A0   A1   A2m   A3N   A4/   A5   A5   A6   A7   A8   A9u   A:V   A;7   A<   A<   A=   A>   A?   A@}   AA^   AB?   AC    AD   AD   AE   AF   AG   AHf   AIG   AJ(   AK	   AK   AL   AM   AN   AOn   APO   AQ0   AR   AR   AS   AT   AU   AVv   AWW   AX8   AY   AY   AZ   A[   A\   A]~   A^_   A_@   A`!   Aa   Aa   Ab   Ac   Ad   Aeg   AfH   Ag)   Ah
   Ah   Ai   Aj   Ak   Alo   AmP   An1   Ao   Ao   Ap   Aq   Ar   Asw   AtX   Au9   Av   Av   Aw   Ax   Ay   Az   A{`   A|A   A}"   A~   A~   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   Aȸ   Aə   Az   A[   A<   A   A   A   A   AС   Aт   Ac   AD   A%   A   A   A   Aש   A؊   Ak   AL   A-   A   A   A   Aޱ   Aߒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A    A    A   A   A   A|   A]   A>   A   A    A   A	   A
   A   Ae   A
F   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A    A!}   A"^   A#?   A$    A%   A%   A&   A'   A(   A)f   A*G   A+(   A,	   A,   A-   A.   A/   A0n   A1O   A20   A3   A3   A4   A5   A6   A7v   A8W   A98   A:   A:   A;   A<   A=   A>~   A?_   A@@   AA!   AB   AB   AC   AD   AE   AFg   AGH   AH)   AI
   AI   AJ   AK   AL   AMo   ANP   AO1   AP   AP   AQ   AR   AS   ATw   AUX   AV9   AW   AW   AX   AY   AZ   A[   A\`   A]A   A^"   A_   A_   A`   Aa   Ab   Ach   AdI   Ae*   Af   Af   Ag   Ah   Ai   Ajp   AkQ   Al2   Am   Am   An   Ao   Ap   Aqx   ArY   As:   At   At   Au   Av   Aw   Ax   Aya   AzB   A{#   A|   A|   A}   A~   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   Aƹ   Aǚ   A{   A\   A=   A   A   A   A   A΢   Aσ   Ad   AE   A&   A   A   A   Aժ   A֋   Al   AM   A.   A   A   A   Aܲ   Aݓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A     A    A }   A ^   A ?   A     A    A    A    A    A 	   A 
f   A G   A (   A 
	   A 
   A    A    A    A n   A O   A 0   A    A    A    A    A    A v   A W   A 8   A    A    A    A    A    A ~   A  _   A !@   A "!   A #   A #   A $   A %   A &   A 'g   A (H   A ))   A *
   A *   A +   A ,   A -   A .o   A /P   A 01   A 1   A 1   A 2   A 3   A 4   A 5w   A 6X   A 79   A 8   A 8   A 9   A :   A ;   A <   A =`   A >A   A ?"   A @   A @   A A   A B   A C   A Dh   A EI   A F*   A G   A G   A H   A I   A J   A Kp   A LQ   A M2   A N   A N   A O   A P   A Q   A Rx   A SY   A T:   A U   A U   A V   A W   A X   A Y   A Za   A [B   A \#   A ]   A ]   A ^   A _   A `   A ai   A bJ   A c+   A d   A d   A e   A f   A g   A hq   A iR   A j3   A k   A k   A l   A m   A n   A oy   A pZ   A q;   A r   A r   A s   A t   A u   A v   A wb   A xC   A y$   A z   A z   A {   A |   A }   A ~j   A K   A ,   A 
   A    A    A    A    A r   A S   A 4   A    A    A    A    A    A z   A [   A <   A    A    A    A    A    A    A c   A D   A %   A    A    A    A    A    A k   A L   A -   A    A    A    A    A    A s   A T   A 5   A    A    A    A    A    A {   A \   A =   A    A    A    A    A    A    A d   A E   A &   A    A    A    A    A    A l   A M   A .   A    A    A    A    A    A t   A U   A 6   A    A    A    A ĺ   A ś   A |   A ]   A >   A    A     A    A    A ̣   A ̈́   A e   A F   A '   A    A    A    A ӫ   A Ԍ   A m   A N   A /   A    A    A    A ڳ   A ۔   A u   A V   A 7   A    A    A    A    A    A }   A ^   A ?   A     A    A    A    A    A    A f   A G   A (   A 	   A    A    A    A    A n   A O   A 0   A    A    A    A    A    A v   A W   A 8   A    A    A    A    A    A! ~   A!_   A!@   A!!   A!   A!   A!   A!   A!   A!g   A!	H   A!
)   A!
   A!   A!   A!
   A!   A!o   A!P   A!1   A!   A!   A!   A!   A!   A!w   A!X   A!9   A!   A!   A!   A!   A!   A!   A!`   A!A   A! "   A!!   A!!   A!"   A!#   A!$   A!%h   A!&I   A!'*   A!(   A!(   A!)   A!*   A!+   A!,p   A!-Q   A!.2   A!/   A!/   A!0   A!1   A!2   A!3x   A!4Y   A!5:   A!6   A!6   A!7   A!8   A!9   A!:   A!;a   A!<B   A!=#   A!>   A!>   A!?   A!@   A!A   A!Bi   A!CJ   A!D+   A!E   A!E   A!F   A!G   A!H   A!Iq   A!JR   A!K3   A!L   A!L   A!M   A!N   A!O   A!Py   A!QZ   A!R;   A!S   A!S   A!T   A!U   A!V   A!W   A!Xb   A!YC   A!Z$   A![   A![   A!\   A!]   A!^   A!_j   A!`K   A!a,   A!b
   A!b   A!c   A!d   A!e   A!fr   A!gS   A!h4   A!i   A!i   A!j   A!k   A!l   A!mz   A!n[   A!o<   A!p   A!p   A!q   A!r   A!s   A!t   A!uc   A!vD   A!w%   A!x   A!x   A!y   A!z   A!{   A!|k   A!}L   A!~-   A!   A!   A!   A!   A!   A!s   A!T   A!5   A!   A!   A!   A!   A!   A!{   A!\   A!=   A!   A!   A!   A!   A!   A!   A!d   A!E   A!&   A!   A!   A!   A!   A!   A!l   A!M   A!.   A!   A!   A!   A!   A!   A!t   A!U   A!6   A!   A!   A!   A!   A!   A!|   A!]   A!>   A!   A!    A!   A!   A!   A!   A!e   A!F   A!'   A!   A!   A!   A!   A!   A!m   A!N   A!/   A!   A!   A!   A!   A!   A!u   A!V   A!7   A!   A!   A!   A!»   A!Ü   A!}   A!^   A!?   A!    A!   A!   A!   A!ʤ   A!˅   A!f   A!G   A!(   A!	   A!   A!   A!Ѭ   A!ҍ   A!n   A!O   A!0   A!   A!   A!   A!ش   A!ٕ   A!v   A!W   A!8   A!   A!   A!   A!߼   A!   A!~   A!_   A!@   A!!   A!   A!   A!   A!   A!   A!g   A!H   A!)   A!
   A!   A!   A!   A!   A!o   A!P   A!1   A!   A!   A!   A!   A!   A!w   A!X   A!9   A!   A!   A!   A!   A!   A!   A!`   A" A   A""   A"   A"   A"   A"   A"   A"h   A"I   A"*   A"	   A"	   A"
   A"   A"   A"
p   A"Q   A"2   A"   A"   A"   A"   A"   A"x   A"Y   A":   A"   A"   A"   A"   A"   A"   A"a   A"B   A"#   A"   A"   A"    A"!   A""   A"#i   A"$J   A"%+   A"&   A"&   A"'   A"(   A")   A"*q   A"+R   A",3   A"-   A"-   A".   A"/   A"0   A"1y   A"2Z   A"3;   A"4   A"4   A"5   A"6   A"7   A"8   A"9b   A":C   A";$   A"<   A"<   A"=   A">   A"?   A"@j   A"AK   A"B,   A"C
   A"C   A"D   A"E   A"F   A"Gr   A"HS   A"I4   A"J   A"J   A"K   A"L   A"M   A"Nz   A"O[   A"P<   A"Q   A"Q   A"R   A"S   A"T   A"U   A"Vc   A"WD   A"X%   A"Y   A"Y   A"Z   A"[   A"\   A"]k   A"^L   A"_-   A"`   A"`   A"a   A"b   A"c   A"ds   A"eT   A"f5   A"g   A"g   A"h   A"i   A"j   A"k{   A"l\   A"m=   A"n   A"n   A"o   A"p   A"q   A"r   A"sd   A"tE   A"u&   A"v   A"v   A"w   A"x   A"y   A"zl   A"{M   A"|.   A"}   A"}   A"~   A"   A"   A"t   A"U   A"6   A"   A"   A"   A"   A"   A"|   A"]   A">   A"   A"    A"   A"   A"   A"   A"e   A"F   A"'   A"   A"   A"   A"   A"   A"m   A"N   A"/   A"   A"   A"   A"   A"   A"u   A"V   A"7   A"   A"   A"   A"   A"   A"}   A"^   A"?   A"    A"   A"   A"   A"   A"   A"f   A"G   A"(   A"	   A"   A"   A"   A"   A"n   A"O   A"0   A"   A"   A"   A"   A"   A"v   A"W   A"8   A"   A"   A"   A"   A"   A"~   A"_   A"@   A"!   A"   A"   A"   A"ȥ   A"Ɇ   A"g   A"H   A")   A"
   A"   A"   A"ϭ   A"Ў   A"o   A"P   A"1   A"   A"   A"   A"ֵ   A"ז   A"w   A"X   A"9   A"   A"   A"   A"ݽ   A"ޞ   A"   A"`   A"A   A""   A"   A"   A"   A"   A"   A"h   A"I   A"*   A"   A"   A"   A"   A"   A"p   A"Q   A"2   A"   A"   A"   A"   A"   A"x   A"Y   A":   A"   A"   A"   A"   A"   A"   A"a   A"B   A"#   A#    A#    A#   A#   A#   A#i   A#J   A#+   A#   A#   A#   A#	   A#
   A#q   A#R   A#
3   A#   A#   A#   A#   A#   A#y   A#Z   A#;   A#   A#   A#   A#   A#   A#   A#b   A#C   A#$   A#   A#   A#   A#   A#    A#!j   A#"K   A##,   A#$
   A#$   A#%   A#&   A#'   A#(r   A#)S   A#*4   A#+   A#+   A#,   A#-   A#.   A#/z   A#0[   A#1<   A#2   A#2   A#3   A#4   A#5   A#6   A#7c   A#8D   A#9%   A#:   A#:   A#;   A#<   A#=   A#>k   A#?L   A#@-   A#A   A#A   A#B   A#C   A#D   A#Es   A#FT   A#G5   A#H   A#H   A#I   A#J   A#K   A#L{   A#M\   A#N=   A#O   A#O   A#P   A#Q   A#R   A#S   A#Td   A#UE   A#V&   A#W   A#W   A#X   A#Y   A#Z   A#[l   A#\M   A#].   A#^   A#^   A#_   A#`   A#a   A#bt   A#cU   A#d6   A#e   A#e   A#f   A#g   A#h   A#i|   A#j]   A#k>   A#l   A#m    A#m   A#n   A#o   A#p   A#qe   A#rF   A#s'   A#t   A#t   A#u   A#v   A#w   A#xm   A#yN   A#z/   A#{   A#{   A#|   A#}   A#~   A#u   A#V   A#7   A#   A#   A#   A#   A#   A#}   A#^   A#?   A#    A#   A#   A#   A#   A#   A#f   A#G   A#(   A#	   A#   A#   A#   A#   A#n   A#O   A#0   A#   A#   A#   A#   A#   A#v   A#W   A#8   A#   A#   A#   A#   A#   A#~   A#_   A#@   A#!   A#   A#   A#   A#   A#   A#g   A#H   A#)   A#
   A#   A#   A#   A#   A#o   A#P   A#1   A#   A#   A#   A#   A#   A#w   A#X   A#9   A#   A#   A#   A#   A#   A#   A#`   A#A   A#"   A#   A#   A#   A#Ʀ   A#Ǉ   A#h   A#I   A#*   A#   A#   A#   A#ͮ   A#Ώ   A#p   A#Q   A#2   A#   A#   A#   A#Զ   A#՗   A#x   A#Y   A#:   A#   A#   A#   A#۾   A#ܟ   A#݀   A#a   A#B   A##   A#   A#   A#   A#   A#   A#i   A#J   A#+   A#   A#   A#   A#   A#   A#q   A#R   A#3   A#   A#   A#   A#   A#   A#y   A#Z   A#;   A#   A#   A#   A#   A#   A#   A#b   A#C   A#$   A#   A#   A#   A$    A$   A$j   A$K   A$,   A$
   A$   A$   A$   A$   A$	r   A$
S   A$4   A$   A$   A$
   A$   A$   A$z   A$[   A$<   A$   A$   A$   A$   A$   A$   A$c   A$D   A$%   A$   A$   A$   A$   A$   A$k   A$ L   A$!-   A$"   A$"   A$#   A$$   A$%   A$&s   A$'T   A$(5   A$)   A$)   A$*   A$+   A$,   A$-{   A$.\   A$/=   A$0   A$0   A$1   A$2   A$3   A$4   A$5d   A$6E   A$7&   A$8   A$8   A$9   A$:   A$;   A$<l   A$=M   A$>.   A$?   A$?   A$@   A$A   A$B   A$Ct   A$DU   A$E6   A$F   A$F   A$G   A$H   A$I   A$J|   A$K]   A$L>   A$M   A$N    A$N   A$O   A$P   A$Q   A$Re   A$SF   A$T'   A$U   A$U   A$V   A$W   A$X   A$Ym   A$ZN   A$[/   A$\   A$\   A$]   A$^   A$_   A$`u   A$aV   A$b7   A$c   A$c   A$d   A$e   A$f   A$g}   A$h^   A$i?   A$j    A$k   A$k   A$l   A$m   A$n   A$of   A$pG   A$q(   A$r	   A$r   A$s   A$t   A$u   A$vn   A$wO   A$x0   A$y   A$y   A$z   A${   A$|   A$}v   A$~W   A$8   A$   A$   A$   A$   A$   A$~   A$_   A$@   A$!   A$   A$   A$   A$   A$   A$g   A$H   A$)   A$
   A$   A$   A$   A$   A$o   A$P   A$1   A$   A$   A$   A$   A$   A$w   A$X   A$9   A$   A$   A$   A$   A$   A$   A$`   A$A   A$"   A$   A$   A$   A$   A$   A$h   A$I   A$*   A$   A$   A$   A$   A$   A$p   A$Q   A$2   A$   A$   A$   A$   A$   A$x   A$Y   A$:   A$   A$   A$   A$   A$   A$   A$a   A$B   A$#   A$   A$   A$   A$ħ   A$ň   A$i   A$J   A$+   A$   A$   A$   A$˯   A$̐   A$q   A$R   A$3   A$   A$   A$   A$ҷ   A$Ә   A$y   A$Z   A$;   A$   A$   A$   A$ٿ   A$ڠ   A$ہ   A$b   A$C   A$$   A$   A$   A$   A$   A$   A$j   A$K   A$,   A$
   A$   A$   A$   A$   A$r   A$S   A$4   A$   A$   A$   A$   A$   A$z   A$[   A$<   A$   A$   A$   A$   A$   A$   A$c   A$D   A$%   A$   A$   A$   A$   A$   A% k   A%L   A%-   A%   A%   A%   A%   A%   A%s   A%T   A%	5   A%
   A%
   A%   A%   A%
   A%{   A%\   A%=   A%   A%   A%   A%   A%   A%   A%d   A%E   A%&   A%   A%   A%   A%   A%   A%l   A%M   A%.   A%    A%    A%!   A%"   A%#   A%$t   A%%U   A%&6   A%'   A%'   A%(   A%)   A%*   A%+|   A%,]   A%->   A%.   A%/    A%/   A%0   A%1   A%2   A%3e   A%4F   A%5'   A%6   A%6   A%7   A%8   A%9   A%:m   A%;N   A%</   A%=   A%=   A%>   A%?   A%@   A%Au   A%BV   A%C7   A%D   A%D   A%E   A%F   A%G   A%H}   A%I^   A%J?   A%K    A%L   A%L   A%M   A%N   A%O   A%Pf   A%QG   A%R(   A%S	   A%S   A%T   A%U   A%V   A%Wn   A%XO   A%Y0   A%Z   A%Z   A%[   A%\   A%]   A%^v   A%_W   A%`8   A%a   A%a   A%b   A%c   A%d   A%e~   A%f_   A%g@   A%h!   A%i   A%i   A%j   A%k   A%l   A%mg   A%nH   A%o)   A%p
   A%p   A%q   A%r   A%s   A%to   A%uP   A%v1   A%w   A%w   A%x   A%y   A%z   A%{w   A%|X   A%}9   A%~   A%~   A%   A%   A%   A%   A%`   A%A   A%"   A%   A%   A%   A%   A%   A%h   A%I   A%*   A%   A%   A%   A%   A%   A%p   A%Q   A%2   A%   A%   A%   A%   A%   A%x   A%Y   A%:   A%   A%   A%   A%   A%   A%   A%a   A%B   A%#   A%   A%   A%   A%   A%   A%i   A%J   A%+   A%   A%   A%   A%   A%   A%q   A%R   A%3   A%   A%   A%   A%   A%   A%y   A%Z   A%;   A%   A%   A%   A%   A%   A%   A%b   A%C   A%$   A%   A%   A%   A%¨   A%É   A%j   A%K   A%,   A%
   A%   A%   A%ɰ   A%ʑ   A%r   A%S   A%4   A%   A%   A%   A%и   A%љ   A%z   A%[   A%<   A%   A%   A%   A%   A%ء   A%ق   A%c   A%D   A%%   A%   A%   A%   A%ߩ   A%   A%k   A%L   A%-   A%   A%   A%   A%   A%   A%s   A%T   A%5   A%   A%   A%   A%   A%   A%{   A%\   A%=   A%   A%   A%   A%   A%   A%   A%d   A%E   A%&   A%   A%   A%   A%   A%   A%l   A%M   A& .   A&   A&   A&   A&   A&   A&t   A&U   A&6   A&   A&   A&	   A&
   A&   A&|   A&
]   A&>   A&   A&    A&   A&   A&   A&   A&e   A&F   A&'   A&   A&   A&   A&   A&   A&m   A&N   A&/   A&   A&   A&   A&    A&!   A&"u   A&#V   A&$7   A&%   A&%   A&&   A&'   A&(   A&)}   A&*^   A&+?   A&,    A&-   A&-   A&.   A&/   A&0   A&1f   A&2G   A&3(   A&4	   A&4   A&5   A&6   A&7   A&8n   A&9O   A&:0   A&;   A&;   A&<   A&=   A&>   A&?v   A&@W   A&A8   A&B   A&B   A&C   A&D   A&E   A&F~   A&G_   A&H@   A&I!   A&J   A&J   A&K   A&L   A&M   A&Ng   A&OH   A&P)   A&Q
   A&Q   A&R   A&S   A&T   A&Uo   A&VP   A&W1   A&X   A&X   A&Y   A&Z   A&[   A&\w   A&]X   A&^9   A&_   A&_   A&`   A&a   A&b   A&c   A&d`   A&eA   A&f"   A&g   A&g   A&h   A&i   A&j   A&kh   A&lI   A&m*   A&n   A&n   A&o   A&p   A&q   A&rp   A&sQ   A&t2   A&u   A&u   A&v   A&w   A&x   A&yx   A&zY   A&{:   A&|   A&|   A&}   A&~   A&   A&   A&a   A&B   A&#   A&   A&   A&   A&   A&   A&i   A&J   A&+   A&   A&   A&   A&   A&   A&q   A&R   A&3   A&   A&   A&   A&   A&   A&y   A&Z   A&;   A&   A&   A&   A&   A&   A&   A&b   A&C   A&$   A&   A&   A&   A&   A&   A&j   A&K   A&,   A&
   A&   A&   A&   A&   A&r   A&S   A&4   A&   A&   A&   A&   A&   A&z   A&[   A&<   A&   A&   A&   A&   A&   A&   A&c   A&D   A&%   A&   A&   A&   A&   A&   A&k   A&L   A&-   A&   A&   A&   A&Ǳ   A&Ȓ   A&s   A&T   A&5   A&   A&   A&   A&ι   A&Ϛ   A&{   A&\   A&=   A&   A&   A&   A&   A&֢   A&׃   A&d   A&E   A&&   A&   A&   A&   A&ݪ   A&ދ   A&l   A&M   A&.   A&   A&   A&   A&   A&   A&t   A&U   A&6   A&   A&   A&   A&   A&   A&|   A&]   A&>   A&   A&    A&   A&   A&   A&   A&e   A&F   A&'   A&   A&   A&   A&   A&   A&m   A&N   A&/   A&   A&   A'    A'   A'   A'u   A'V   A'7   A'   A'   A'   A'   A'	   A'
}   A'^   A'?   A'
    A'   A'   A'   A'   A'   A'f   A'G   A'(   A'	   A'   A'   A'   A'   A'n   A'O   A'0   A'   A'   A'   A'   A'   A' v   A'!W   A'"8   A'#   A'#   A'$   A'%   A'&   A''~   A'(_   A')@   A'*!   A'+   A'+   A',   A'-   A'.   A'/g   A'0H   A'1)   A'2
   A'2   A'3   A'4   A'5   A'6o   A'7P   A'81   A'9   A'9   A':   A';   A'<   A'=w   A'>X   A'?9   A'@   A'@   A'A   A'B   A'C   A'D   A'E`   A'FA   A'G"   A'H   A'H   A'I   A'J   A'K   A'Lh   A'MI   A'N*   A'O   A'O   A'P   A'Q   A'R   A'Sp   A'TQ   A'U2   A'V   A'V   A'W   A'X   A'Y   A'Zx   A'[Y   A'\:   A']   A']   A'^   A'_   A'`   A'a   A'ba   A'cB   A'd#   A'e   A'e   A'f   A'g   A'h   A'ii   A'jJ   A'k+   A'l   A'l   A'm   A'n   A'o   A'pq   A'qR   A'r3   A's   A's   A't   A'u   A'v   A'wy   A'xZ   A'y;   A'z   A'z   A'{   A'|   A'}   A'~   A'b   A'C   A'$   A'   A'   A'   A'   A'   A'j   A'K   A',   A'
   A'   A'   A'   A'   A'r   A'S   A'4   A'   A'   A'   A'   A'   A'z   A'[   A'<   A'   A'   A'   A'   A'   A'   A'c   A'D   A'%   A'   A'   A'   A'   A'   A'k   A'L   A'-   A'   A'   A'   A'   A'   A's   A'T   A'5   A'   A'   A'   A'   A'   A'{   A'\   A'=   A'   A'   A'   A'   A'   A'   A'd   A'E   A'&   A'   A'   A'   A'   A'   A'l   A'M   A'.   A'   A'   A'   A'Ų   A'Ɠ   A't   A'U   A'6   A'   A'   A'   A'̺   A'͛   A'|   A']   A'>   A'   A'    A'   A'   A'ԣ   A'Մ   A'e   A'F   A''   A'   A'   A'   A'۫   A'܌   A'm   A'N   A'/   A'   A'   A'   A'   A'   A'u   A'V   A'7   A'   A'   A'   A'   A'   A'}   A'^   A'?   A'    A'   A'   A'   A'   A'   A'f   A'G   A'(   A'	   A'   A'   A'   A'   A'n   A'O   A'0   A'   A'   A'   A'   A(    A(v   A(W   A(8   A(   A(   A(   A(   A(   A(~   A(	_   A(
@   A(!   A(   A(   A(
   A(   A(   A(g   A(H   A()   A(
   A(   A(   A(   A(   A(o   A(P   A(1   A(   A(   A(   A(   A(   A(w   A(X   A( 9   A(!   A(!   A("   A(#   A($   A(%   A(&`   A('A   A(("   A()   A()   A(*   A(+   A(,   A(-h   A(.I   A(/*   A(0   A(0   A(1   A(2   A(3   A(4p   A(5Q   A(62   A(7   A(7   A(8   A(9   A(:   A(;x   A(<Y   A(=:   A(>   A(>   A(?   A(@   A(A   A(B   A(Ca   A(DB   A(E#   A(F   A(F   A(G   A(H   A(I   A(Ji   A(KJ   A(L+   A(M   A(M   A(N   A(O   A(P   A(Qq   A(RR   A(S3   A(T   A(T   A(U   A(V   A(W   A(Xy   A(YZ   A(Z;   A([   A([   A(\   A(]   A(^   A(_   A(`b   A(aC   A(b$   A(c   A(c   A(d   A(e   A(f   A(gj   A(hK   A(i,   A(j
   A(j   A(k   A(l   A(m   A(nr   A(oS   A(p4   A(q   A(q   A(r   A(s   A(t   A(uz   A(v[   A(w<   A(x   A(x   A(y   A(z   A({   A(|   A(}c   A(~D   A(%   A(   A(   A(   A(   A(   A(k   A(L   A(-   A(   A(   A(   A(   A(   A(s   A(T   A(5   A(   A(   A(   A(   A(   A({   A(\   A(=   A(   A(   A(   A(   A(   A(   A(d   A(E   A(&   A(   A(   A(   A(   A(   A(l   A(M   A(.   A(   A(   A(   A(   A(   A(t   A(U   A(6   A(   A(   A(   A(   A(   A(|   A(]   A(>   A(   A(    A(   A(   A(   A(   A(e   A(F   A('   A(   A(   A(   A(   A(   A(m   A(N   A(/   A(   A(   A(   A(ó   A(Ĕ   A(u   A(V   A(7   A(   A(   A(   A(ʻ   A(˜   A(}   A(^   A(?   A(    A(   A(   A(   A(Ҥ   A(Ӆ   A(f   A(G   A((   A(	   A(   A(   A(٬   A(ڍ   A(n   A(O   A(0   A(   A(   A(   A(   A(   A(v   A(W   A(8   A(   A(   A(   A(   A(   A(~   A(_   A(@   A(!   A(   A(   A(   A(   A(   A(g   A(H   A()   A(
   A(   A(   A(   A(   A(o   A(P   A(1   A(   A(   A(   A(   A(   A(w   A) X   A)9   A)   A)   A)   A)   A)   A)   A)`   A)A   A)	"   A)
   A)
   A)   A)   A)
   A)h   A)I   A)*   A)   A)   A)   A)   A)   A)p   A)Q   A)2   A)   A)   A)   A)   A)   A)x   A)Y   A):   A)   A)   A)    A)!   A)"   ARAAffA=qA(ApA=qA\A(A(AAAAAAAA(AAA33AAzAAffAffAA\AA\A
AA
AARAAAQAA{ARA\AAAA{AGA\)A
AAAHA
AffA(AAQA(AffA(A\A\AQAA(AzA\A
=A33AffA\)AA=qA(A\)AAA  A{AQA
=ARAA33AAA=qAA(AAA=qAzA\AAAA
=ARA(A{AAAAA  A  A{AƏ\AQAƏ\AÙA(AA
ARAzA(AAAApA(AAAǮA
=A33A  AȸRAȣA  AAɮAGA
=AAffA\)AzAQAAɮA  A(AQAȏ\AǙAƣAŅA33ApA(AA\AAAApA  A{A  AA{ApAQAŮApAQA\AQAGA33AAAHARAAAHA=qA  AŮAA\AAffA\AA(AAzAzAAˮAA(AQAȏ\AQAHA˅AʣA(A  AQA=qAzA=qA  AəAApAA  AzAzAQApApApAǅAƸRAGA
=AGAzApAƏ\AAAA\)A\)A{A\)AQA
A
=AzAɮAAƣAĸRAAAAAAA
AřAA
=AAA  AAffAƸRA(A\)AÅAffA  AzAģAAAffAApAA  A(AHAAA  A
=A33ApA{A33A33A
AffAřA(AzAƣA33AǙAHAffAģA(AŮAģAAAzAQAAAģAzApAGAQAQAA=qAzAAGAffAffA
A
=AHA  AffApA{AA\AA=qAAAAzAAAARAAQAAA\)AAAGAA33A33A\A{AA
=ApAA
AA33A
=AApA\)AA
=A
AHA\AA=qA33ARA\)A
A=qA\)AAA=qAQA{AAAAAAAGAAA\A\)AAGAHA\)AHA  A
=AAA{A\)A  A  AGA\)ApAzAAAA33A
AGAQA33A{A\AA  AAzAA
A  ApAAAAAAzAffARARARA33AA{AApAAQAzAAQAQAGA  A=qAA\AzAA33AAGAAzARAAHAA\)A(AA  AzAA
=AAzA\)AAzARA33A33A\)AAAGAA
A
AAA(AA
=AAA33ARAAAHAGAffAHAAApA{AAHAffA=qA=qAAHAAffAffA=qA\AffAAAAAApAAGARA
=AAAGA
=A33ApA=qA(AzA{AAGA{A(A\)AzAffA  AAAAA=qA(A  A{A
ARA\AAA{A  AApAffA\AA
=AA\AA(AAGA
=AAQA{AQAHAGAAA
A  A{A(A(A(AA33AAA\AAAAA  A
AA\AA\AQAA33AQAHAAARAGARAARAAAAAA33ARA33A  A(AAAAQAAQA\)AHA{A
=A=qAQAHAQAARAGAHAAzA{A33AGA
AGA
=AGAAAAA33ARA  AAA33A{AApAAffAHARApAAHA33AQA{A{A=qARAAApAA
=AA{AA  AAAAAA\AA\)AHAApA
=AA
=AAA33AAGAffAA{A\)A33A(ARA\A
A{AGA33ARAA
=AAQAzAGAzAHAzAA  A33AAQA
A
=A\AffA(AAQAffA
A
A
=AffA\A\AAAzAzAARA
=AA(ApAA\)A
=AGAAQA
=AAA{AA33AA33A
AQA(A\)ApApAAAA
AAAAzAAAAAffA
ARAQA33ARAA=qAAAAAGA33AA\A  AAAAAffAAffAQAAAzAA=qAAQAApA\)ARA=qA33A
A=qA\AA  AA=qApAGAzAAA\A\A(AzAAARAAAAA  AGAAA(A{AGAAApAffAQAHAA33A  AA33A
=AGAAA{A(AAAAAAAAA33AA
=AHA33AzA£A  AQAffAď\A
A
=AǅAAɮAAȣAA
=AAffA\)AQAƏ\A\)AQA(AAHAAÙA\)AƏ\AAffAÙAÅAĸRAAffA33AA\AApAA
A=qAA£AzA{A£AGA\)AÙAffA{AffAA  A\)AǙAřAffAA
=AAQA\AAAAAAAAÙAAď\A
=AAƏ\AHAzA\)AA{AˮA  ApAɅA{Aȏ\AAȏ\AɅAQAAAAƏ\A
=AAAAǮAzA(AHAAAAHAA(AGAAQA  A\)AHAAȏ\AGAApAAȣAAGAffAɅAQAAA{AzA=qApARAAĸRA\)AĸRAƏ\A
AŮAģA\)A(A33AAAGA\)AA\A33A{A
=AA=qA
=AɅA  Aʏ\A
=AA\)A
AHAA(A  AAˮAGApAAQA(A(A=qAɅAʣAHAǮAGAəAAɅA(AĸRA{AAGAAřAď\A
AAffAAȣA
=AAɮA  A=qAffAʣAʸRA=qAʏ\AɅA{AAAAzAAHA{AzAAɮAGAɮAȏ\A{AAQA(A33A
AəAȏ\AzAQA
=A
=AîA=qAAîAAAffA33Aď\A
AA\)AHApA33AAď\AHAģA  AîA=qA¸RA33AQAƣApApApAGAAApA(AǅAǅA33A
=AAAffAȏ\A(AffA
=AǅAǙApApAǮAǙAǅAǅA
=AHAAffAQA  AffA(AAŮA(AAŮA33AA=qApAAA\)A  AA  A
=ApA=qAĸRAŮAA
AAffA
AffA{A
AA=qA  A\)AA\)ARAQA  A\)AQAA\AGA
A  A\AHAîAAÙA(A
AA
AQA33AA
AGAAÙA  Aď\AGAŅA=qA
=AǅApApA\)A  A{AQA33AGAAzAffAffA{AƏ\AAƣAƸRAřAAGA
AAGAA(AA
A(A{AQA(A(A  A(A{AAA
AAǙAǙAǙApA33AA
=A
=AA
=AHAƸRAAǙA{AŮAGA
=AAffAzAzAƸRAQAAQAGAģAA=qA\)AƣA\)AƏ\A=qAAģAGAAGA33AAAffAA¸RA(A
=AHAď\AîA=qAQA
=Aď\A
=AA33AřAŅApApAGA\)AApA33AAĸRAA\)ApApA\)A33AA(AĸRA(AŅAGA\)AŅApAřAŮAA
A{AffAHAAGAApAA\)AGA=qAGAǅAHApAŮA\)A=qAffAAď\AAÅAAApAARAAGAGAAAAApA
=AQAffAQAA{A33AîA
=Aď\AŅAA\)AHA{AffAA=qA{AAA{A33A33AAAAQAA=qA(AzA
=AQAAŅApAřAřAAA{A  A  A{A
A  AA  A  A{AǙA33AAA
=AA=qAzA(AɮAAȸRAȣAffApAǙAA33A33A(A{A33AĸRA
A\)A\AzAď\AA=qA{AQAAÅAĸRAA=qAffAHAA  ApAQAHAQAApAA
AȸRAȣA(AAAHA\)AHAAƣAApAřA(AȣA=qA
AHAA(AGA  AHA\)A{AģAĸRAAŮAA{A{A
A
AɮAQA=qAHA
=A\)AƏ\A  AzAHAƣA33AǅApA\)AǙA{A(AA(AȣAHA33AȣAɅA\)A33A
=A
=Aȏ\AȣAǮAǅA
AHAƸRAApA=qA(A  A
A
=AzAȣAHA
=AȸRAzAA33AAɅAɅAɅA\)AGAAȣAHA
=A(A33AɅApAʣAƸRAAQAǙA=qAAHAəAHAȣAƣAHAQAAƣAřAffA(AƸRA33AǅAAȣAȸRAHAAȏ\AȣA=qAA
=A{A=qA  A  AA
A
AAAGApAǮA
A
AA  A(AQAQAȸRAA
AGAAQAffA  AAGAəAA\)AAGAHA
AQA=qAAɅAA
AƣAÙA
=AAÅA\AQAHAA¸RA
=AGAģA33AAHAHA  AģA
AǙAQAǙApAƸRAƏ\AAffAAAəAzA
=AQAAA=qA
=A(A(AǮA(AGA
AǮA=qA{A{A=qAȣA=qA(A(A=qA=qAAɮAGA=qAʏ\A{A33A33AffAəAA
AɅAɅAffA˙A˅ApAAzAʣAAffAɅAA{AQA  AA
=AHAffAʏ\AəAffA
AffAŮAŅApAApAAHAApA\)A33A
A\)AAA{A
=A
=AƏ\AA33A(ApA¸RAffA\ApA33AAAAǙA33AA
A33AA33ApAApAď\AĸRAzAĸRAAAHAA
=AQAffAď\A(AQA  A  A(A(AA  AAģAA33A33A\)A\)AĸRAAAAGApApAAAffAA
=AǮA
A=qAǙAzA=qAQA
A=qApA33A
=AQApA(AƏ\AŮAŮA{AřA  AAA(AAAA\)A  AAffAGA
=AǮAA
A  AAA
=A\)AA33AAQAǙA33AHA\)AGAAzA
=AA
A{AHAGA
AÅA{AzAAQAzA=qA{A{A{A(A(AĸRA33A33AAA
AAřAffA=qAƣA(AHAffApAA˅AʣA
=AAȏ\A  AAGA  AAffAA\)A\)A\)AAA{AǅAA
AəAA(A{AHAȣApAA\)A=qAA=qAQAƸRAAAȣAffAzAʏ\AGA˙ApA33A{AȣA˙ApAAApApA=qAA33A(AffA˙Ȁ\AA  ApAA
A=qAAGAHA\)A{AffAʸRA
=AAA
=AAzAQAQA{A=qAAAHAAʸRAʣApA
ApAAAzAA
A˙AʸRA33AAA33AȣAQAzAʣA=qAɮAffAAAzAQAA\)AA(A  A  AəAAGA  AȣAA  A
AɮA
AəAGAÅA(ApAQAřAƸRA
=AHApAQAAƸRAƸRAǅAƣAAAA
A\A33A=qA
=AHAffA=qApAzApAɮA  A=qAzAʸRAAzAHAȏ\AA
=AAGAA33ApAʸRAGAA=qAAA
=AA
=AȸRAȏ\AffA33A
=AîA\)A
=AŅAģAAffA=qA{A(AzAĸRAřAŮAŅA33A\AGAA(A
A¸RAA=qA  AAîAAA{A
ApAApAAAQA{AApAAA=qAApAAzAzAAQA\AzAA
=AARAAA=qAA{AA=qAGAffAA
=A\ARAA(AHApAGAAA=qA=qA  A=qAQAARARApA
=A33A
=AzAffA\AAffARA{A{A=qA=qA(AQA
=AA  A
AAQAA\A{AA{A{AA\AHAffA
=A
=A=qA33A
=AAA=qAHARA\)AA\)AA33AAA33A(A
A\)AGAA33A\)AA
A
=AQAA
AA=qA
=AGAHAAAAA  AAAAQA
=A{AQA33A  A(A\)A
=AQA(AzApAAA  AQAA  A=qAzAzA=qAzAAAAHAQA(AAA=qA
=AffAQAA¸RA  AA  AA{AQAzA\)ApA\)ApA
AřAŅA
=A  AAAŮAzAA=qAAHAHAAAzA¸RA¸RAAAApApAA\)AHAHAAGAGA=qA
=AǅA33A33A(AffAA33AÙAffA(A  AAGAAA  AAA
=AAffAA33A\)ApApAŅAŅAŅA\)AApA
=AĸRAA33A33A33A\)ApApA33AĸRAffAffAA\)AřAřAAŮA
A=qAffAQAffAffAHAƣAAGApAGAAApA\)ApAŮA\)A
=AARAAAAAffAHAĸRAHAģA{AA  AAQAA  AAAA
=AzAzAAAîAGAĸRA{AAǙAzAzA33A\)AŮAAAA=qA  AA
=AřAŅAŅA  AQAA
A
AȣA
A(Aȏ\A{AȸRAȸRAAHAAQA{A  A  AȣA\)A
=AAŮA
AƸRAƣA
AGApAzAƏ\A
A33AQAȸRAHAGAGAɮAA  A(A(AAA  AAzAA33AAffAA¸RA=qAAHAĸRAA(AHA33AĸRA(AÙAA  AA{ApA
=AîAƣAAƸRAAŅA\)AĸRAzAď\AQAQA(AffAAApA{AzA{A  AAAŮAƸRA(AzAƸRAAHAA33AGAGApApApApA
AA
=AAƣAƸRAƣAƏ\AƏ\AzAƏ\AƣAffAřAď\AGAA\)AŅAƏ\AŮAŮAřAA  AAAQAƏ\AƸRAƸRAƸRAƏ\AffAffAAAffAA33AA(A=qAAAAAAAQAAAzA\)AAHAAAAGApAAA\AzA\AAffAAA(A(A
A  AAGAA33AffAA
=A
AAAAAA\AQAApAAzA\AAAApAA33A{A{A\A(A
=A  AAGA33AAA\)AA
AzAzA=qAffA{AAA(AAAA\A\)A(AAÙAA33A
=AARA
A
=A{A\A{A
=A  AA=qA33AzA\)A\)AGAAA
=AAAAAGA33AAzAA\AAApAzAAA
A{ApAAAAApA\AAA(AAQAA33AHAAA=qAzA(A\A
=A\ARA33AHA
A=qAAffAGA{A{AA
AzAAA\A\)AffAA\)A(AA\)AzAGAď\A  AÅAA33AA\A(AAQA
AAAffA  A
=AQAQAQAAAAGApAAGA
=AQA\A(AA
=A
AApA
A
A
=AÙAGA33A£ApAîAAQAĸRA=qAzA33A
=ApAŮA{AA33AǙA=qAHApA\)AəAəAəApA\)AɅAQAzA{Aȏ\AQAAA
A33A\)AɮA\)A  AA(A
AHAAHA=qAGA{A\)AffAAAǙAAŅAAQAAAzAď\AģAƏ\AǮAffA\)AA=qAAffA\)AAA  A(AAffAffAQA(A  AAAffAA=qAAHA  ApA\)AffAGAď\AGAA{AHA\)A33AŮA\)AzA=qAHApAQAQAffAȏ\AHAGAɅAQAA\)ApApA\)A˙A˅AQA̸RẠAffA
A{ApA˙A˙AA\)A
=A  AǅAʏ\AAzA{AAAHA33AǮAAƏ\AřAHAŮAÙAA{AŮAQAzAffAAA  A33AǙAǮAƣA(AəAGAəAɮA33Aȏ\A33A\)AɮAɮAA
AɅAȸRAQAŅAAÅA\)A\)A(A=qAƣAAA(A  AA
=AHAAHA
AAA\)A{AAA=qAAɮA  AQAQA(A
AAAHAȸRAAAAɅA
=AȣAȏ\AAȸRAzAA(AffApA(A
=AƣAHA{AA=qAA  AzA33AģAHAƏ\ApA{AzA
=AGA\)ApApAGA33AɅA33AGAA33AAAȏ\AǮA
AAzAÙAģAzAƸRAƸRApAǮAAzAffA(AA(AŮAA33A  AGAŮAřA
=AŅAǮAřAffAAHAAŅAffAģA
AɮAA{AQAzA(A(A  AA  A
A{A{A(A{A(A
AGAȣAȏ\AǅAAQAffAȏ\AHA33A
=AzA(AǙAȣAAHAAAAQAffAzAʏ\AA
=AAʏ\AAGAȣAGAAHAɅA\)A=qA  A=qAřApAQAApA  A{AGAQAHAÙAAģAA  AĸRAƏ\Aď\A\)AǙAAHApApAƣAGAAffAzA  AAƸRAffA
A  AzAAÅAÙAQA33A{AQAAffAAAA\)AǅAǅAǙAGA
A
AǮA\)A
=A
=A
=A33A{A\)A(A{AA{AǙAAAzAzAQA(A  A{AHAA  AAAGApApAGAA=qAȣA(A=qA{AǮAAĸRAÙAGA{AHAřAzA{AffAGAÅAffAQAA33AAAřApAŮA{AAAŮA=qA
AŅAGAQAffAAAŮAA(AffApApAffAAffAGA(AzAAAHA33AAA\)AAHAffAQA  AîApA
=A¸RAAAAAÅAģAHA
A(AŮA
A(AffAffAAƏ\A
=A{AƏ\AƏ\AƏ\AQAƣAA
=AAHAAGAǙAAAzAGAřA(A=qAǅA
A\)A  AQAAǮAGA33AřAÅA{A
=AAÙA\)AAƏ\AŮAzAƣA{ApAǮAǙA{A{A=qAQAHA33AQAAǮAA  AQA{A=qA{A{A{AAAA
A
AǮAǙAǙA
A  A{A=qAQA=qAAA
ApAAƸRAffAQAAAƸRA=qAǮAQA
AƏ\AzAŮAA  A(A=qAAǅAǮApAGApApAǅAGAGA  AǙAAAǅA\)A\)ApApAǙA
AA\)A33AƏ\AAffAQA{A  A=qAƏ\AHAHAzAƣA=qAƸRAQAAřA  AƣA
=ApA\)ApA\)AǅA\)A\)AǅAǙAǙAAA  AǅAzAHAÅA\A£AQA\AQA
=AîA{AQAffAHAĸRA  A
=AAA\)AAAřAřA=qAAĸRA(A
=A\)AAAAzAAĸRAď\AģAĸRA=qAîAĸRA
AAģAŅAAQA
=AGAffAď\AffApAApAA\)AGA33A\)ApA\)AAGAAģAģAģAzAzAAA\)A{AAQAîAHAGA\)AApAAAAHA33AĸRAHAAď\AHA=qAģA(A\)AAGA{AzAAA{A
=AGAÅAîAîAÙAÙAîAÅAÅAîAîAÙAApAAA  AQAÙAÅA¸RA33AA33A33AŮAGAřApA{A=qA
=A
=AǮAAǙA
=A
=AƣA{A
A=qA=qA=qAƣA=qAGA
AA33AGAAAA33AĸRAď\AzA=qA\)AGA
=AHA=qAÙAĸRAAAffA  ApA=qAGAîA
AzAA
=AffAAAŅAřAŅA
AřA=qAŮA  A  AƸRAQA(A{A=qAƸRAHA33AǙA
A  AA  A  AAAA{A
AHAȏ\AAzAffAffAHAQA  A
A  A{A{A
A  A
A
A(AQAAffAHA(A{AǙAAHAHAƣA(AřAAAA  AAď\AQAAAzAzAQAAAAzA£A{A=qAA
AQAzAApAHAAffApA33ApAHAzAĸRAÙAÙAÅA\)AAîA{AQAAřA(AƣAGA  AzAȣAHAȣAȣAAGAəAA(AQAʣA
=AHAffA  AA(A33Aȏ\AzA  A  AHA{A
A
A(A
AAHAGA(ApAAQAffAffAffA  AA
A\)A\)AǅA
AAǅA
=AAQAffAzAzAAŮAA(AQAQA
AƏ\AřAŅAAGAŅA\)AQAHAĸRAģA£AAAAAQA
=AŅAAzA{AzAApA(A{A
=AǮAAffA
=AGA\)AA
A=qAʣAHA
=AGAʏ\AHAzA  AʣAGA\)AGA33A
=AAAʣAʏ\AffAGAGAQAȏ\A{A  AA{A
=AʣAʏ\AʸRAʣAʸRAzAzA=qA{A
AəAHAAȸRAzA33AzAAQAƏ\A=qAQA=qA{A  A{A
AřAřAřAŮAŮAřA
=AA{AAQAď\AQAA  A(AA=qA=qA  A=qA
=AřA33AHApAřAAHA\AHAA\A
=AîA(A{AƣAƸRA33A(AA  ApAHAffA{AffAAA
=A33AA33AȸRAzAȣAȸRAffA\)A
=AQAffA(A  AǅAǙAApAǙApAGAGAGA33AA33AA
=A
=A
=A
=AAAƸRAAAƏ\A=qAA{AŅA(AřAŮA
AŅA
=AA
=AģAHAAĸRA  AĸRAģA
AîAA
=AA
=A33A
=AzA=qAA
A33AGA33A
=A
=AHApA33AA
=AAģA\)AŅAQAAAȏ\AHAAAA
AQAQA{A{AQAQAQA(A  A  A
A=qAAəAɅAȏ\AƸRA
AzA33AQAQAA  AQAəAAAAApAǮAAǮAQA{A
ApAGAď\AAřAAA(A=qAAģAď\AřAƸRAA=qAffAGA=qAîAA=qA{A£AAAÙAGAA¸RA£A£A33AzA\)AÅApA\)AÅApAA33AQAQAHA(AffAAzAď\AzAď\AģAģA
=AGA33A\)A
=A{AffAAƸRAǅAǙAǙAǙAǙAApAAGA
=AGApAAAAAƏ\AAģAŅAŅApA  A  AAŅA{AřAŮA33AffAGAA  A
=A
=AA£AzAzA\AzA{A\)AîAAHAAzA\)AAA¸RA
=A\A
=AGAÅAÙAzA
=A33A=qA£AAffAAA33AAÙAAffA\)ApA=qAQA\A\)AÙA
A=qAAzAA  A(AQAAAA{AA\)A
A33A33A(A
AAA£A  AzARA33A=qA  AA
A=qAA
=A  A
A
AAA(A33A33AAA(AAÙAÅAGAHAA
=A=qAAffAQA{AAA\A\ApA{AA\A£AA
=AAAAGAA
=A33AHAzApAQAzA(A
AA\AHAAA
=AA
A33AAÅA\)AGA£A£AAAģApAQAHApAAȏ\AHAAGAAHAAȏ\Aȏ\AffA=qA{A  A  AAAƣA33A=qAApAGA\)AƏ\AƏ\AƸRAAǅAƏ\A(A{A(AffAAǙAǅAǙAƏ\A  AǙAǮAHAAƏ\AzAQAƏ\AAAƸRAƸRAAAHA(AŮA=qA  A=qAƣAAzAQAƏ\AHAAAřAAģAď\AA
=Aď\A
=AA  AzA\)AzAAÅAAA
=AîApAîA
A(AHAģAAGAAŮA(AHAApA\)AǅAA
AzAQAffAzAQA{A(A  A  AAQAAGAA
=AQAƏ\A(AA{A
=A33AƸRA{A{A
ApA\)AřAŮA
A{AƏ\A33A33A\)AAƏ\AǙAƏ\A\)ApAƣAƣAQA(A{A
AAAŮAŮApAAffA{A  A=qA
=A  AzA
=A33A33A  A33A  AQA
=AA(AffAA33A\)AģA
AģAģA=qAzAřAAHAAǙAǮAHA{A(AzAQAȸRAȣAzAAȣAƏ\AģAģAHAAffAŮAƸRA
=AHAAĸRAģAģAřA\)AQA  Aď\ApA\)ApApAŅAřA33Aď\A
=AĸRAĸRAzAģAA(AA
AA  AA
=AģA£A£AAAGAA
=AAA  AAA=qA£AAA33ApAffA(AffA33A{A\)A{AA=qAAA33AA\AQA\)AzA=qA33AAGARAAzAA  A(ApAA  AffA
=AQAAAQA33AHAA(AzAHAAAGA33AHA\AApAHARA
=A\)A\)AAA{A  A  A
AA(A  A=qA=qA33AAA  AAApA{AffAA¸RA33AA\)AApAHAAzA\)A=qARAAGAQA(AA=qAzAHAAA33A
=AAffA(A  AQA{AAApA¸RA=qAÅAîA33AGA33A
=A  A=qAřAHA\)A
=A\)A
AAzA
A  AʣAA
=A33AGA33A\)AA
A  A{A˙AA
AGAAȏ\A=qA=qAQAQAzAzAffAzAǅAA\)AǅAHAA  AHAǅA
=A33A
A33AHAƸRAffAƸRAQA(AQAzA(AA
AŅApA
=AAGAHA=qA¸RAģAQA
=AŮAģApAAffA(AffApAzA33A  AzA{AĸRAŅAAQA
A{AApAAĸRA\)A
=A33A
=AŮAǙApAǙAGA\)AǙAQAffA  A  A  A=qA{AA=qA{AǙA{A
A
=A33Aȏ\AA33AGAȣAȸRA=qAQAQAȏ\AQAzAǮAAǙAƣA
A
A33AŮAGA\)AGA(AƣAƣAAAƏ\AAAƣAzAQAQAffAƏ\AQAƣAAď\A
A
AQAffA£A  AÅAAA\)A  A
AA
AGAA=qAGAA33AAQAzAAAŮAA{AAzAA\)A{AffAîAQAAGA(A  ApAHAÅAA  A{A{A{A(A=qA=qAƣAffA(AƸRAƸRA{A=qA
=A\)A
=A33A{A{A
AA
=A=qAHAA\)A\)AŅA\)AAQAŮAGAA{A  A33A\)A\)A
=A\)A\)AGAHAAGAAA  A
=AA=qA=qAřA
=AQA
ApAA£A£A£AAQA\)AHAA=qAǙAŮAzAŮAAǅAǮAŮAƏ\AAAAAGAA  AA(A  AffAzAAA
=AA
=ApA33A=qAAQAAApA=qAA=qAȏ\A  A(AzAȏ\A{A  AǅAǮA  A{A(AffAȸRAA33AA
=AffAzA  ApA33A{AQA
Aȏ\A=qApAAAǅAGAǅA=qA(A  AAGA\)AA\)A=qAffAA\)AAAA(AAAAA\)A33AAA  A
=AƏ\A33AAģAAffAĸRAQA33AA  AHApA=qA
=AA\)A  A=qAȸRAAəA=qA33AAAʣAffAffAffAffA=qAA
AAȸRA\)AGAzAʸRAzAHA\)AA\)AHA˙AGA
=A\)A33A\)A˅AˮApApA
=A
=AA{A(ApAÙAA\)A\)A\)A\)AHA33ApA\)AîA  AîAA
AAAQApA
AA
A
AA\)AA  A
=AA\)AAHA\)AQAA  ApAA=qApAA£AGA{AAHAGA=qA{AzA£AHAAHAA¸RARAA
=ApA
=A\)A=qAA\)AGAAA
AQAzAzA£AAA
=A33AA\)AGA\)AGAAAAAA
AAAHAGAA\)AAGApAffAA=qA
=A  AQAAAA
A33ARAGAGAQARA
=ApAHAA33AA  AffA33A
=A\)AQAApA{AA\AAffAA\)A\AAHAGAA  A=qAzAHAÙAAƣAffA=qA
AŅAHAAģAŅAHAď\A=qAAA{A{ApA
AGA¸RA\)A  ApA33AGAA¸RAAAHAA(ApAzA(A  AA(A\)A
=AffA(A33AAffAA=qAA
ApAA(A=qAQAffA\A
=AGAHA33AzAGA
A=qAffAģAAĸRAď\A  A
A{AffApAffAAHAĸRAQAAƏ\AƸRAGAǮAQAffAQAQAȣAȣAȸRAəAɮAAŮAQAHAA33AQA=qAɅA  AAA33A\)AɅAAɮA
A
AɅAAHAAAȣAȏ\AȣAzAzAffAAHA
=AGAəA
A  AQA  A
A
AɮAəApAGAGAGA\)AGAAAzAGA  A{A(AA\)AGA{A  AɅAAzAȏ\AŅAAAƸRA
=AřAǅAƣAA
=ARAAÅAzAƏ\AƣAĸRA(AAA(AGA=qAƣA
=A{AAɅA  AQAʏ\AA˅A
=AA\)AHA{AɅAAǅAǮAAGAǙA
AǮA{Aȏ\AAHA  AəA
=AGAəAAAAAA  A=qA=qA(A{A=qA(A  A  Aȏ\A
AAHA(AAɮAȏ\AɅAəAA
=AřAAAQAzA\)ApAA
A(AAA  AAzAģAQA=qAGAA\)A
=AîAŮAGAGAAĸRA(A(A¸RAÅA  A
=AģA
AffA\)AzAAA
AHA
AƸRAAǅA\)AAAA(AA=qAAffAzAȏ\A=qAȏ\AǮA33AŮA=qAŅA  AA=qA  AffAƏ\AŮAGA
=AĸRAzAGAÙAAÙA(Aď\Aď\A
A
AzApAHAQAď\AŅAřA
AŅA33AA33AřAřAA\)AffAÅAĸRAģA
A\)AGAHAAA{AÙAď\AĸRA{AffAřApAQA33AffA\)AA\)A  A
=ApA
=A\)AřA(AA=qA{AffApAÅAzAAGA\)AA\)AÙA{AHAŅAHA(AȸRAAȸRAƸRA
=AƣAHAA
AĸRApAď\AAĸRA{AQAAAAHAA\)A\)A=qAApAAAA
AAA\)ApA33AHA
=ARAA{A=qAA\A\A\)AHAARA
=ApAARA\)AHA=qApAzAffA{AGApAARA(AAAGAARAAGA(AA33A
AAQA33A(A\)A=qAQAA{AAA=qAA33A=qAQAAAHA(AHARA  AzA\)AHA(AQAGA33AffA(AA33A
=A\)ApAÅAzAGAAîAAGAAGA
=A  ApAA\ApAzAAA\)AQA\ApA\)A  AGA33AffAQA  A\AGA(AHAA{AffA  A
=A\A  A\)AAAARAAA
=A(AA\AA\)A
A\AAA\)AA  A
A
=AHA\)ApAGAQA\)AA\)AAA(A\AAQAApA=qAAAGAƣA  AAŅApAŅA{AƏ\AzAzAffAffA(A  A  AAA33AAffA=qAřAQAffA{A(A
A(AřA
A  A  A=qA{A\)AÙAAAA33A
=AAAzA=qA\AAApAAA
AAAAAHAQA
AA
ApA
=AAGA=qAA(AffA(AAGAAAffA  AAA
A=qApAzAîAQAAŮA
A(A=qA33A33AGA33A
AzAȸRAHA33A
AA
A  A
A  AHA
=AAGAȣAǮAƣApAAAzAA{AǮAzA33A33AAÅAHA{AA{AƸRA\)AAAGAffA
AŅA(AƏ\AƸRAA{A(AģAzAffAA
=AAQA\)A\)AHA
=AQA33A33A\)AzA  A
A  A{AAď\AHAģA  AHAAAHAffA
=A33A{AQAzAA=qAzAǙAəA\)AA(AzA(A=qAAGA(A̸RAHAͅAͮApAͅApA{AΏ\AffA{A(AΣAA33A
=AHAθRAzA{A
AͮAͅAͅA\)AAGẠA
=AGAAAA  AQAAQAˮAAA{A
AGAǮA
=AQAAAAǅA{AAÙAzA=qAAHA(AffA{AzAŅA
=A  AƸRAA(AA\)AHAƏ\A
A{A(A=qAǙA=qA\)AȸRAȸRAzA=qAA33A  AGAA˅AAQAzAHAͮAQAAAA
=A
=A33AυApAGAυAϙAυAAAЏ\AHAzAzAϙA33AʸRAAffAffAQAAʣA{Ȁ\A˅AA͙A  A=qAffA
=AA  A(A
=AA
ApAHAAAAA
=A˙AˮA\)A33A  AͮAAGApAɮAQAǙAA(A\)AGAAHApAAffAA{A
=A
AApAGAA\)AȣAAA=qAA=qApA  AA{ẠA
=AA=qAAzAΣAθRA(A{A
AͮAGẠAA(A̸RȀ\AQAAAGA=qAA\)ApAˮA˙AA˅A˅AGA33A
=AAʏ\AʣAQAA{AA
=A{A{A{A  A
A{A33AAƣA{A
=AffA\)AGAAAffAA(ApAGAAAA{A(A¸RA(AƏ\AzAA  A\)A
=AA
AAA(AA(A=qAAffA{ApAAA\)AQAGAîA  AQAAŮA(AƏ\AffA{A
AAA33AA
AHAApA(A=qAAA\AQApAA{AzAffAAAQA  A\AHAQA  AAHAzAGA33ApAARAA
=ARA{AA\)AA(A\AA33AA{AA\)A33AAGApAAffAA\A=qAAApA\AARAAffAAQAzA\AzA  AHA33AA
=AA  AARAApAA
A(ARAAGA=qAffA\A
=AAAAzAAGA\)ApAA\)AAAAAHA(AAAA\A
AAAA\)A\)AzA
=AA{A\A33A
=AAHAQAAHAA
AQAAAA\)AA(A33AAAA(A=qApA£AAHA=qApAHAA\A\A  A33AHAAHAAAARAAA{A\AzAA  AAAAAAAAHAAApAHAA=qA¸RAAÅAAA{AA
A
AA=qAQA(AQAQA(A(AA\)A33A¸RAA\)AA(A=qA33A  AAAAzAARAA\)AA(ARAA33A
=ApA33AAAAGAA{AAAAAAAAQAHA\)A\)A33A33AAQA(AA\)AA=qApA\AffARA=qA\AQA\)AAAA  A\)AffAA£A33AAA{A£A33AAApAAHAHAHA=qA{AA=qA=qA(A  AAAAAAAAAAA33AA
AAzAffAÙAîAÅA
=AAffAzAzAQA\A=qAA¸RA£A
=AHA
AHA  AAAHAffA  AzA(AAA\)ApARAHAzAGA33AAAzA  AzAAHA=qA(AGAAHAAzARA
=A33A
AA33AAffA(AAAzA
=AA
A  A\AA\)AîA  A{A(A  A{A=qAĸRA
=A  AQAƸRAGAǙA  A{AAA33AHAƸRAAHAApAŮA
AzAA
=AGAGA\)AAAHAAĸRA=qAƏ\AŮA(AÅAzAA£A¸RA\)A¸RA  A33ApAA=qAA
=A
=AApA=qAGApA(AffA{AzAÙAģAQAAƣAQAîAAAHAAA=qA33AAffAHAAApAGA
=A\)A
=ApAAffA(ARAQAzAGAQA{AAGAģAQAAÅAQAģAAAGA33AAGAA33AAAƸRA\)AǮAA
A\)A(A\)AA\AÙA(A¸RA
=AAAzAģAď\A(A{AzAģA(A=qA
=AffAGAzAƏ\A33AffApA\)A  AƸRA\)AƏ\A
=AzA£ApA33AzAQA=qAGA{AQAAA(A33A=qAAA
AHA\A\AA{AA33AA33A(AHAAQAGAA£AA33AHAA
=AGAGAAřAŅAŅAřApAřA
A
AŮAŮA
A=qA
A  A
A  AAA\)AŅAŮAřApAAŅA{A
=AřAA{AAHAHAîApA
=A(AģAHA  A£AGAA=qA
=A=qAA£A=qA33AŅAAA\)AA
AAHA33AQAA\AA
=AA=qA\)AzAď\AHAAffA  A33AŮAQAƣA
AǅAǮA{AȸRAAď\Aď\AQAHAAAGAĸRA33ApAŅA
A{AA
=ApAAzA(A
=A(A(AzA
=AffAHA{AQA
A  AŅA33AzA\)A{A(A
A33AÙAApAQAHAǮA  AǮAGAAzA¸RAA{A33AAA(AGAA{A33ARAAffA
A
=AA  AGAAHAAA
=A\A
A
A  A=qA33AApA33A33AGAA\A33A\)AzA(A{A
=ApA\A\AAA33AAAAAAAHAQAHA
=AffA
=AA
=AGA=qAApA
=AAffAzAQA\AAA=qA\A\AzA
=A(A=qA33AA\AAQAGAAApA=qA33AGAAGA{A=qAGA33A\)AA\A  A\A\AA  AAffAA\)A(A  AzAGAARA\)AA33A(AzAGA(AAA\ARA  AAHAQAHAAA  AAAffA(AAHAAffAQAAARAA\AffA\AAGAQA\)AA\)AGAŅA=qA
=AǮAǅAAGA\)ApAApA(A  AHAGAģAzAƣAA\)A=qAzAffAApAAGAffA  AAǙA
=AŅAffA\)A\)AHA33AAGAA33ARAHAzA{A
AA=qA=qA33AzAA{ARAQAAzAAAAA
A
=A£AA=qA  AffAHAÙAÙAHA=qAAzAffAA{A{A  A(AQAģAď\AAA\)A  AAffAAƸRAHAAAA
=AǮAAǙApA
=AǮA=qA=qA\)AGA\)A\)A33AǙAŅAƏ\AAƣAAAQAȣAA
=AǮAQA(AǅAffAffAƸRAƣAÙApA\)AGAȏ\AQAzA33AQA=qApAƏ\A=qA{AƸRA=qA\)AGAA£AQARA  A=qARAApA\A{AAA(A(ApAffA  AA\A(AHA33AřA  A33A=qAA  AĸRAAGA  A\)AAA\)A˅AA
=AAffAAGA{AffAzAffAHAΏ\AAˮAAͅA
Ȁ\A(ApAA{AͮȀ\A=qȀ\A{AɅAQA˙AGA33AʣAffA
AəA33AȸRAAǮAAQA(A=qA
ApA33AAAzA(AzA  AŮAģAƣAAGAǮAƣAAAA(AQA  ApApA33AîA33AffApA{A
AHA{AA(A=qAď\AGAAQAAÅAAA{AģA\)AAřAřAQAffAGAȏ\A\)AQA˙A\)A33Aȏ\AAA33AǮAAƸRAzAƏ\AffAzA  Aȏ\AHAď\AffA(AQAGAÙA  Aď\AffAAģAAAQAQA=qA{A
=AQAA33Aď\AģA\AGAA(ApA
AffAffAAAAAAAQARA\)AAAffAA
AA\A(ApA=qAffAA
A{AzAQAffAHAAAAAA{A
AffApAAAA
ARAAA\AA
=A\)AA{A\A33A\AA
A33AA{AAA{AQA{AAA=qAAA
=ApAA{A33AAA=qA  AAAAA\AA{A{AAGAHAffA  AA\)AA
=AffAAzAApAGAAAA\)AA{A=qAffA
AAAzAA\AAffApA\ARAA
=A(AAAA¸RAAď\AA33A  AGAAzAƏ\A=qAřA33AA=qAAA  A  ApAA  AAffAzAzAA
=A33AAHAAGAGAA
=A
=ApAGA{AzA{AÙA
=AAAzAffAA\)A\)AÙAGAAď\A(A{A
A(AARAQA=qA£AQAAA=qA{ApAzAAA(AQA
AHA\)AHAA=qAA=qA{AAA\AffAQARA(A(AA33A\AAffAA=qA
=AA\)A
=AA{A
A\AA
=AA\)AA33A¸RAA¸RAAAQA(A=qA=qA
AAA  A33A(AA\AffApAAHAAA33A33ARAzA\A
AGA\ARAA\A33A33AzARA\)ApAARAAA(AA33AAA{AAA
A(AQA
AAAA\)A\)AA
AAzA(ARAAzAffAAffAAAQA=qAGA\)AHA33AHA=qAAA  AA
A(A=qA\)A=qA  AA  AAARA  A\)AAAAffA
=AAA
=AzAAA\A\)AQAQApA{A
=AHA(A=qAA(ApAAAzAA\)AHAA  AHAzAQAQARAAA
=A\)A{A=qAAQAffApAAzAHA33AA\AA=qA(ARAHAzAA  A
=A  A
=A=qA
=A
AHA=qA{AQAA33ApAHA(A
=A
=AffAA33AA=qAffA
A\AA(A  A  A
AQA=qAA
A(A{AAAAAAA\AHAîAA=qA(AAGAAHAAAGA{A=qAA
AAHA  AAGAAARA
=A  A(AffAHAA\)AA33AAA33A  AHAAAAARApA{AARAffAQA{AApARAffA  ApA(A  A
ARARAA\AAAA33A
=AffApAffAAGA(A
AHA(AA\AA  AGAAffAzARAGAffAA\AA(A\AffAzA\)ApApA
AffAAQApA=qA(A\AHA
=AA
A  A=qAAAA(AA\)AA=qA  AAAAApA
A{ARA\AA
=AARAAA=qA  AGAzAAA  A  ApAQAAA
AHA
AAA  AzA{AA(AHAAA
=AQARAA
AHA33AQAAA
=ApA33ARAQAAARA
A(A  AAARAAHA{A\A33AGA  AAA33A=qAA
ARAAQA
ARA
A
ApAGA
=A\)AHApAA{AQAzA
=A(AA\)AAAQAA  A  AAHApA(A
=A  A  A33AA  A=qA33A\)A  ARAAHA\AGAA=qApAA\)ARAAAAGA
AHA(A=qAA33AQAffAAA  AAA(AApA=qAA(AzAA=qA\)A{A=qA\)AA=qA=qA{AA\AAffAQAA  A(ARAffAA=qAAAA
=AffAAzAģAAApA
=A\)AĸRApA
AÙAAAA
=AffAA
AGA{AA
=AARA{A  A(AAHA33AHA\)AAAGAGAA  AHAffAAHA  AHAAGAffAAÙAzAAAQA33A£AAHA¸RAAAAA{AA\AHAARAHAA¸RAGA\)A
A\)A{AzA33A\)A
=AffA=qA=qAA¸RAA
A  AAîAzAAAffAAAARA{AHA
=AAA
=AGAA
AQAA\AAAHA=qAffAAAAAARAGA
A{AAA33A\AA(AAzA=qA
AHA
=AAffA33A\)AAAAAzAAAHAA(A{A33AAzA(AAAHAA=qAGA{A{A\AHA
=A33ApAAA\AA\)ApA33A33AAA=qA\A\A(A{AA{A
ApA
=AHA=qA
=AAQAA\)AAAAAA33A\)A33A{ARAAHA=qA{AQAA
A
A(AHAAA33AzAA\)AAffAAGA\A33A
=A33A  AGA
=A  AHA
=AAA
=AA
=AAGAA
A
=AA33A
=A
AQAffAGAAAzAffAAA
=A(A
=AAA
AffA\A(AA(AQARA33AA=qAAGAAA
=A\A{AA\AARA=qA33A=qAAAAffAzA=qAA33AARAGARAA  A  A{A\A  A33A33AffAA  AAAHA\)A  AAAAGAAAGA  AAAHA
=AAHAA
=AA\)A\A\)AHAHAA  ApA=qAA{A=qAAHAA
A
ARA\)AffA{AHA\AAAHAzA\)AffAAAAA  AQAzAAffA(A(A\AffA\A(AA{A
=A(AAA33AAA{AHA
=AHAGAA\AAAA
=AAARA33A{A\AAAApAAAAGAA=qA{AA{A{A{AA{AAAGAAGARAAA(AAGA=qAAHARA(AAzA
=AHAAffAAA{A
=AHAAzAzAAA
=AAffAAzARAA(AffA{AAGAAApAAffAîAzAzAŅAA
=AAQAGA
AHA\)AQAAAGA(A\)AAAAA=qAAA  A=qAAA{AffA
=AAAQAGAzA  A{AQAApAA
AffARA\AGAAA=qAAHAA=qApAA{AA
=AHAQA33AAA(AA33AA(A
AA=qAAQAApAAA\A
=A33A
A(A\AzAA£Aď\AģAffA
ApAAGAGAGA33AAHAHAzAApAApA
=AHA\AAAAHAGAAA
=AHA33AzA
=A{A  AAffARAzA  A\)AAAApAA{AA(ApAQAzAAAA
=AHA\)AffAARARA\A\AA=qAAGARAffA
AA  A
=A
=ARApApAHAA\AAffAApA{A\A33AîAAzAA
=AAřA=qAzAA
=AAGApA33AAƣA(A(AAŅA\)ApAGAA=qA(AîAď\AGAA  A=qAAzAAGAÅA=qAģA=qAAŅA\)AAǅAHAAGA\ARAAAAA(AAAHAA
=AA\)AGA
=AA{AA33A=qAGA  AAzAAQA\)A\AA
AA\)AAHAAAAAAAQA\AHAARAAAARAAA\)ApA
A  AA
=AHAHAARAA=qAAA33AHAA(AAffAHAA=qA  ApAGA33A  A33AAA{A{A{AA\AAAAAzAA  A33AGA33AA
=A\)A{AAHAAA\A\AzAAA=qAA=qA\AAHA  A\)A  ApA33AAA33A33AzA(AApA{AA\)AAA  AHApA
AHA33A  AffA
=AGAÅAA=qAĸRA
=ApA
A{A=qAffAffA
AAA
=AGAGAHAîA33AA
AA33A\)AHA{AAAA
=AffA  AAzA=qA  ARAA\ApA(AA(AAA
A{AAHAzAGAA33A=qA  AA{AAA33A
=AAAGA(AA\AHARAAAA{AffAA=qA(A
=AAAAA33AA\)AHA33A  ARApAGAAA  A(A
=AÙApA¸RA{A\)AÙA(A=qAzAģAzA
=AAAŮA33AAQAA
=A
A33A=qA(A
A\A£A(A
=AARAA  A
A£AÙA£AffA{A\)A
=A
AAģA{AAÅAARAAAAAffAAQA(A
=AGA{A{AA(AAÙA{AA=qAĸRA33ApA{A(AÅAApA  AA{A(ApAzA\)Aď\AA(AǮAA
AGA=qAQA=qAʣAHAHA(AAA\)AA͙AA(A  A{A  A{AθRAffA
A  A(AAzAQA  AQAQAʸRAApAǅA  AffA
A
=A  AQAA(AQA{A\)A(AzAA  AɅAɅAA=qAȣAffAǮA
=AzA  AQAzAĸRA=qA\)ApAģAÅA  AA33AffApAApAÙA£A{A
=AAîA=qA=qAQAHA
=A(AAzAAAAA{A=qAHAÅAĸRAģAAffAAApAA=qA=qAHAǅA33AǙAǮAAAA  A(ApA{AQA
AffAřA
AAHApA\)AA33AǅAA
=AAA
=AA=qAAffA
=AffAȣAHA
=A
=AzAApA=qAQAA(AAQA{AAQAȸRA
=AȣA\)AǮA{AŅA\)AAîAAAHAffA33A33A
=AAzA(AA
AQAîAģAHA
=AŮA=qA
=ApAA{A(A(AHAffA  AAzAʸRA  A{A(AQAGAAƏ\A\)AǅA\)A(AȸRAA(AGA{AGAGAA˅A
=A
=AA{AQAGApApAA{A
ApApA£A(A\)AA
AAGA\)AA(AQAHAA33AA\)A¸RA£AAA\)AQAHAGAA
=AAŮAAA(AffA£AApA\A  AƏ\A¸RAQAA=qARARA  AA(AAÅApAƸRAQA(A
=AʣA
ApAǅAȣAGAGA\)A
=A
A33A
=A{AQA  A˙A˙A˙A˅A
=A
A
=AA{AHAQAQAzA{AAA\)A{A=qAQAʣA(A=qA{A{A  A=qApAzAffA{A{A{AƏ\A{A=qA{A{AƣAAGAAHApAQAģA  AGAA£A
=AA\)AÅAAA(A=qARA33AAÅAAA\)A33AAAA  A(A
=AApAzAÅA(AAAŅA\ApA\A
A
=AAĸRAřApAQA
A=qA
=AAȣAǮAGA
AQA33AHAĸRAAģA33A
=AĸRAA\)AffA
AǮAȸRA33A{A  AAƏ\ApA(A33AAÙAď\AGAGApA33A(A£A
AÙA{A
=AAHA  ARAA
=A\)A\)AffAAffAA\)AARApA{A\)AA  AÙAQAHAÙA(AÙAffA
AAA\)AGAQAAzA=qARAQAAQAîAîAApAîAQA33AŅAAAŅApApAď\AApAAǙA
AHAȸRAAzAGA
=AQA  AGAQA\)A(AGAAÙA33AîA=qA(A\)A=qAAQAffAAGAAzA  A  A  A
AǅAǙAHAǮAGAA
=AHAǅApAƸRAQA33ApAģA
=AGAA(A
AÅA\)AA  AîA
AAAHAHAzA{AAA
A\)A
=AÅAAƣAffA(AƸRAffA¸RAA=qA\)AA=qAAA33A\)A33AA(Aȏ\AAɅA{AA˅A
=AGAͮAffAAApAϙAffAHA=qAA  A{AʣApAGAƣAǮApA{AffAAɅAHA˅A(A=qAQAAAAzA=qA(A
=AʸRA
=A\)ApA˙AHAʸRAəA{AHAƣAzAŮAA\)ApAHA  Aʏ\AAȏ\A{AffA(Aȏ\AzA{AHA\)AzAɮA33AƸRAAŮAřA=qAŮA33AA=qAA
AǮA  AffA\)A=qAAQA
=AQA33A{A̸RAGA{A=qA  AΏ\AΏ\AΣAθRAHAHA
=AHAApA  AAAAffAͅAzA{AffAͅA
A\)AAͅA
AAGAGAȀ\AffA  A
A˅A(AQA
=AAGAAzA
A
=AəAQAAQAffAQAffA
=A{AAA(A33AffA=qA=qAʏ\AŅA{AffA
=A
A
AƸRAəAəAɅA=qA
A=qAzA{AffA{A̸RAffAffẠAˮAGAΏ\AQAʸRAApAAA
=AAGAͮA
=A
=AHAͮAHAͮAzA(AHA{AͅA(AΣAΏ\AAυAAAϮAA{AzAGA{AAͮA33A
=AAʏ\A  AffAA
A=qA˅AˮAGA(AˮAGAzA33A=qApA{A=qA33AHAɅAAɅAAȏ\AĸRAÙAzAQAÅA  AA{A
=AAARA=qAAď\AģA=qA¸RA\)A{A{ARA33A  A{AAAffA£A¸RAzAHA33AîAQAĸRAA
A
=AĸRA
=A(AffA33A\)AGAGAA\)Aď\AÙA\)AŮA
A
A  A  AAƸRAA  A=qAŮAGA\)A
AƣA
AŮAŮAQAzA{AAƸRA(AAffAHAAA=qA
=A
=A  A33A
AQA\)AGA(A\A
A\)A\AAA
A
=AApA
=A
AHAQAApAA\ARAA  ApAAAHA{AAAAAGAAzAAGAAAď\AQAřAA  AǮAQAA{AA(AAzAȣAȸRAȣAzAQA{A(AƏ\AHAAA=qA  AzAŅAffA=qA  AQA
A(A
AQA
ApAHAA33AzA  AAAQAȸRAGAǅAGA
AQAzAǙAȏ\A\)AəAɅAffAȣA(A{A=qA  AģAHA{AAzAQA£A
AGA  AAAAHAA
=AQApA(AHAGARA(AAƏ\AAÙA  AģAƣAA
AͅAAzAˮApAAAHA33ARA33AAGAAGA˅A33AA\)AƏ\AAAffAAQA
AAA
=AAQA
AAAQAGA=qAAAAAApA33AzAď\A\)AA{AƸRA{A
=A=qA(A\)A33AHA£AAffAHAÅAAĸRAffA\)AffAzAŮA  ApAGAA\)ApA
=AGA£A(AGA  AA
=AAGA\)A  A\A
AffAffA
=A33A33AGA\)A
A
AA
=AQA£AŮAÅA
=AQAQAAAA=qA
A
AA{A  A=qA\)ARA\)AAzAÅA{AA{A\)AA=qAA=qAA\)A\)AzApA33AAA\)A=qAAffAA
AAffA\)ApA  A=qA
=A33AffAffA33A
=AA  A(A(AQAAHAzAzAzA=qA
AÙApA\)ApA¸RA¸RAffA(AAzA  A\)AGARA(ApAA  AA  AAAAAzAHAA33AAA
=AGAAAARA
=AHA(A\)AAzAzAA33AA\)AAA
AA
=ARAA33AAA\)AffAHAARAAffA  A33AGAApA
=AAGA\A(A
=ApAA=qApA  AAGAA(AGAzAARA
A{AAA=qA
=A
=AffA=qA
AApAARAAGAAAffAzAAAAA(AzAAffAARAQARAffA(A(AAAAA
=AA\)ApAQAAA
=A33AA
=AGAAA
A33AA\AA
=AA\)A
A\)A(AHAAA{A=qAffAzA{AA  AA
=ApA{AApA\)AŮA  A
=AAAzAȣA
=AAzAɮA{AAGA(A
AARAHAAHARAAzA
=A{AffA\)AAffAHAAəAȣAȣAAGA{AHA
A
=AǮA(AffAȏ\AGAǅAGA=qA\AAzAA
AAAzAHAɮA{ApAǅA=qA˅A͙AzA͙AAǮAA
A=qApA
AģAffA=qAʸRApA\)AzA\)AřA{A{AȸRA{AGA(A
=AĸRAȣAȣAAȸRA  ApA33AffAzA33A\)A  A33A{AApAʏ\A=qA(A˅AffAAΣApAzA
AΣAθRAHAθRAΣA(AQA  A
AͅA
=AAA33A33AQAzAffA  A˅AˮA  AAAAAHAAAʸRAAAffAɅA33AQA{AA\)AQAŅA33AGAAƏ\A{AȸRAA\)Aď\AGAHA  A\ApAAAAAHA(AA(A{AĸRAƸRApAGAʏ\A(A
ApAHA
=AͮApAAẠA̸RA̸RAẠA̸RAffA{AʸRAHA  AA33A(A˙AQA=qAA
AGA  AQA
=A
AAA  A
ApApAˮAA\)A\)AGA\)A33AGApA33AAA=qAzAzAzAʏ\AʸRAAQAɮA  A33A33AAʣAQAzA\)Aȏ\AƣA33AGA33ApAAQA=qA33A
AɅAAA  AAGAAA=qAǙAȣAɅAffAʸRAGAẠAAΏ\AHAθRA
=AθRAzA(A=qA=qA\)A\)AͅAͅA͙AͅA
AAHAQA(AA˅A  AffȀ\A
ẠAAzAzAθRAͅA{AA{AQAApA33AzA  AzAA  A  A  AGAGApAAA33AHAʏ\AʸRAʏ\AQAʏ\A{AAɮAəAɮA33AAɮA{A  A
=A
A=qA
=AAHAAGAAQAApAAffAǮAǅAGA
AAGA
=AHA͙A=qA{A=qA
=A
=A(AУA  A\)A
ApA{ẠAͅA(AΣAGAHAAAУAAϮA33ApAGA\)AΏ\AϮA33AffAffA\)A=qApA͙AA͙AͅAAAzAQA{A
ApA͙A  A͙ApA
=ẠAAHȀ\ẠAzȀ\AAˮA{A
A{AAˮAA33AʸRAɅAA(A\)A=qA(AzA{AGAA33AQA33ApAAQA
AA\)AQAAGApAA  Aȏ\AQAzAGAɮAffAA
AffAHAA33A\)A͙A͙AGAAυAΣAA33A33A
=A
=A\)AGAϮAљAAӅAffAңAѮAGAиRAffAAAυAQAGAGAA33AAʏ\AəAA{A=qAQA  AʣAʣAzAzAʣA
A33A=qA{A  A
AA(AAffAŮAƣAA
AAA=qȀ\AQA  A33AA{A=qẠA
=AHAzAffAffAGAAAQAɅAəA=qAʏ\A33AȸRAȸRA
A{AApA(ẠA(AffAAA{AApAzA  Aԏ\AAәA=qA  A(AffA=qA  ApAApAҏ\A
A  A\)A\)AA  AѮA=qAѮAAAҸRA33AУA  A\)AGAffApAAffAAәAzAzAzAУAҏ\A33AӅApAAHAffAљAθRA(A̸RA͙A
A\)AAAGA
AGA
A\)AЏ\AzAAA33AAHAzA=qAхAϙA=qAͅAQAGAffAЏ\A
=AӅAA{Aҏ\Aҏ\A
=AәAHA
A֣AGAGAQAA\)A  AffA{AAأAQAA  AGA֏\AָRAzAָRAQA{A=qA  A
AՅAA33AGAAָRA
=AׅAׅA
=AHAHAzAָRAHAׅA֣AA33ApAθRAApAAHAGAGApAӮAApAAA=qA(A=qA
AϙAϙAGAЏ\AЏ\A  A33AGAљAAQA
=AffA33A=qApAzAzAңA(AzAәA\)A
=AA
AӮAAHAHA(A
=AAHA{AQAAAAQAffA
=AأAQAQA33AA
A=qAAAיAָRAAׅA֏\AA
=A֣A=qA  A
=AAAHAԏ\AAGA=qAffA(A(AHAӮAA\)AӅAӮApAӮAӅA
=A33AGAA=qAңAҸRAҸRAHAҸRAңA
=AA
A33AAHAծAHAffAAHA
AffAA33AzA  A
=AQAA
=A
=A̸RA̸RA
AϙAGApA
ApAffAGA33AAA33AՙA{A  AՙAՅA33AGApAGA\)ApAHAA
AՙAHAffAAA֣AՙA{A(AQA{A  AAGAzApAAAУAAѮAA=qAQAAѮAffA
=ApA  A=qAffAAA
AљAAA33A(AУAУAУAQA=qA(A33AzAApAffA=qAΏ\AGAϮAHAzA
=A
=AA
=AA(AθRAHAHAAHAθRAA33AHAAΏ\A\)A\)AA˙AA33A\)A̸RȀ\AͅA(A33A\)AA  AffAApAхAA(AffAAAAQA(AQAffAQAffA  A
A(AGAәA=qAAҏ\AAиRA(A
A\)AHAҸRAѮApAиRAA
=A
=AЏ\AQA{AHAAЏ\A
AAAυAQAЏ\ApAAυAA{AA33AΣAͮAGAAAHȀ\AzA=qAA\)AGAHAGA˙AHAGAA
Aʏ\A
A\)A
AA̸RA  A=qAQAɅAHAəA=qAA=qAffAAHAA
=A33AHA
=AzApAͮA=qA
=A(A=qA
=AAУAA33AAHAAAϙAGAθRAΏ\AAHA\)ApAGAϮApAGAΏ\ẠAAHAzA
AˮA
AϮAA=qAиRAGAУAиRA  A(AzAυAA\)AGAGA33AϮAϙAθRAA  A\)ẠȀ\AA  AHA
ẠAAffA˅ApA
=AzApAAAHAǙAGA
AGAHAAȏ\AǅA{AȸRAAzA
A(AθRAAϮAAυA{AAQAУAиRAzAHAQAQAϙAУAЏ\A=qA\)ApAA=qA͙A͙A33AAGA
=AͅAͅAͮA=qAΏ\AAzAΏ\AAQA33AͮAA=qAffA
=AA  A
A\)A˅A\)AHAɅAHAAA
=A=qA˙AAQA  AQAʣAApAGAəAQA  A(AͅAͮAʣAʏ\A=qA=qA̸RAffAAGAHAGAǙA(AffAǅA=qAAA  A33AÙAAQAGA=qAǅAƏ\AǮAA
A{A=qAAˮA˅A˙A
=A
=AAʣAʸRAʸRAʣAA
=AʸRAAʸRAA
=A
=A
=AA\)ApA˙AQAHAA
=ApA͙A\)A\)A\)AffA(A  ApAA\)AQA(AHAȣAɅA
=AəA(AA(A(A=qAffA{A  A  AQAʸRAAHAAA33A=qA˙A(A\)A\)A\)AA(AzA
=AAGAA\)AͮA  ApAHAGAGAHA
=A\)A
=AAAQAAGA{AˮA(ẠAAAQAΣAHA
=AΣAΣAΏ\AΣA
=A
=AAHAθRAΏ\A=qA33AAA33AͅAGA  A͙AQAAGAͅAA
A{A=qA
AAApA̸RAHAffAzA{A˙AA=qAAʣA33Aʏ\A  A(AHAʣAzAffAȸRA  A=qAɮA  A  ApAGAA˙AẠAA{A  A  AA33AəAQAʸRAAʣA\)AɮAzAGApAAQApAHAGAAGAθRAzAθRAA
A(A(AЏ\AffAzAυAAAGAиRAиRAAϙAϙAGAGAAQA(ApAA̸RAθRAAQAθRAGAA(AffAЏ\AA=qAA  A(AA  AA33AΏ\AQAͮAHApA͙A
AGA\)A\)AA33A33A33AGAA33ẠA
=A˙AQA̸RȀ\AGApApA\)AGAAGAͮAffAA\)A
A=qAQA  AzAffȀ\AͮApAA
A͙AA
A=qAAAAGAυAхAљAA
=A˅A  A˅A˅A{AQA˅AQẠẠAffA
AGA
=AQAʣA  AA
=A33A˙A
AẠA(AAffAGA  AAˮA˅AzAQA{AA\)AˮAAˮAAA˅A˙A
A\)AQAAA=qA  A  A{AɮAAHAzAʸRAffA(AQAAHAQAˮAGAAQAAffAQAA{A˅AffAHA̸RA̸RApA̸RA33A\)A
=AAA\)AAɮA  A
=A{ApA33AυAυApAυAυAυA{AQA(AGAυAAϮAϮAϙAϙA33A33AHAΏ\A(A{A=qA(AAQAəAAHẠA{A=qAθRAAAGAϮA\)A{AGA
=ẠA̸RA(AzAHẠA=qA(A{A˙A
A˅AʸRA
=AA{AzAGAGAA
=AɅA  ẠAA
A
AQA(AffAGA
Ȁ\A\)AQA˅AA=qAffAA
=AA̸RAȀ\AAApA͙A  AzAQAθRAAHAA
=AGApAυAυAϙAυA\)AGAGA
=AAAA\)A\)A\)A\)AA
=AAHA  A\)AAGA̸RAApA=qAA
=A\)A\)A\)AApAAAffApA33AAHAA̸RAAGA\)A
=A
A  ẠA=qAAˮAʏ\AzAzA\)A(AAʏ\AʸRAzAQAQA{A(A
AA(AA{A{AzAzA
=AA
=Aʏ\ApA(AAʏ\A{AA  Aʏ\A{A33AAΏ\A
=AAGA
A=qAzAЏ\AQAQAQAzAAиRAУAУAA  A
AυApAGAAΏ\AΣAzAffȀ\AΣAAzA33AθRAΏ\A=qA(A  AffApA  AAGAGA͙A\)A
AAA(A{A(A{AAAA˅ApA33AAAzA˙Aȏ\A  AAʏ\A=qA
=AAApA˙AA\)AʸRAʸRAHAHAHAʸRAʸRA
=AA33A˅A˙AffA˙A˙AA  AGAzAθRA(A˅A
=Ȁ\A
=AA̸RAAzAzApA33A
A33A
AəA{AffAAAAA
=AʸRAɅAəA
A\)AȸRAA33AffAQAzAffA
=AAffAȸRAȣA33AzAAȸRAȸRAApApAɅApAɅAəA
AA{AffAGAAffA
=AHAAHAGAGA33A˙A˅A˅A\)AAɮAffAȸRA  A=qA33AAHAĸRAGA
A=qAȸRAA33AAǅAǮAA  AɮAffAȸRAʣAAəAəAɮAAffA˙AA=qA  AAˮA  A˅AͮAffAffA33AAA
A  AυAA\)A(A
=AΏ\AQA=qA
A(AΏ\AzAQAΣAΣAffAQAHAffAQAΏ\AΏ\AAAHA
AAzAGAzA̸RAAAȀ\A͙ApA{AHA=qA(AəAGAA
A=qAQAǙAGAAřA=qAA
=AzAȏ\AǅA{AffAƣAʣAQAÅAAȣAȣAQA
=AffA
A33A˙A  A(AˮA=qA̸RA
=A=qAA
A(AAθRA
=A\)Aԏ\Aԏ\AffAՙA\)AծA{AA=qA  AҸRAQAQA  AAQAA{A
AApAQA\)AQA
=ApAѮA
A
A{A  A{AQA  A(AffAQAѮAљAA
=AЏ\A=qAQAAGApAҸRAЏ\AAAңA  A(AAϙAϮA(AffAA  AУAϙA33ApA\)AGA
A33AAΣA(AHAHAzAzApAGAͮAQA33AQAffA\)AȣA
A\)A33A(A
=A  AQA
=A
=A{AA
=AHAA{A\)A(A˅ApAHA=qAυAQAΏ\AzAͅẠAυAzA33A  AA=qAGAͮAͅAAʣAʸRA˅AApAHA  A=qAʣA˅A(AAA
A\)A33A=qA\)AʣAffAʸRAHAQAHAHAffAffAəAAAGA=qA=qA
A{AAAA  AA\)AAʏ\AʸRA
=A(AAʏ\AA=qAəAɮA  AɮAȣAGAɮA
AAA33ApAAŅAzA
=AzAƏ\A{AAAHA
=A{AAA  A=qA  A\)Aď\A33AA(A33AɮAGAəA=qAA  AzAAGA33A
AΣAΣA
=AAGApAυAAυAA=qAQA\)AA  AzA\)AGAA
=AAΣAzAHAͮAͅAͅA
AApAzAˮA=qA(A
=A=qAAA
=AQA=qAA  AHA(A
A(A(AHAȸRA=qA
=AAA  AǙA  AHA\)AΣAAHA(AAʸRAAffA=qAʣAAAQA33AȣAɮA33A=qA\)AHA{AAAΣȀ\A(AHAHAGA  AQAQAffA{AA33A33A33ApA͙AA  A{A=qAzAΏ\AΏ\AΣAzAΏ\AzAQAzAΏ\AΏ\AͅAHA{A\)A  AGApA
AϮA\)A
=A
=AθRA\)AAHAAApAϮAϮAGA
ApAϙAAAϮAA
=A33A̸RA
=AʸRAAA˙A(AɅA  AAA  AHAQAAɅAɅAɮA{ApAAzAΣApA  A{AzA(Ȁ\AHAA=qA(AHAυA{AУAHAљAGA
A  AA(AAAAA  AAApAծAՙAA33A  A{A
A=qA=qA=qA33A33AHAffAA\)A\)AAAQAӮA
AAQA\)A33A33AHAAffAңAQAA{AΣA͙A͙AA͙AA  AθRA(AA33AA
=AΣAzAЏ\AAGA  AffAA33Ȁ\ApAA{AAGAAHAAʏ\AˮAʏ\AʸRAʣAQAA
AA  AA(A̸RẠA=qA\)ApAΏ\AzA
ApAQAˮAffA{AAA  AA  A˅AAHẠA(A\)AAAAAQA33AɅAGAHA(AGA=qAǮApA
AffA
AQA  AAəAHAAAQAAA\)AzApApAȸRAɅA\)AɮAəAGApA\)AɮApAɮA33A
=AəAAGAɅAȣAzA\)AAffAHAAAzA
AQAģA(ApAffAřAŅA(AƏ\A=qApAA  AʸRApAQA33AʸRAAAA͙A
A
=AϙA{AHAAzApAӅA(AQA(A
AzA(A(A
A  A
A{A\)AAʣA̸RAAHAʣAəAzAQA(AQA̸RAGAzAGA33A͙ApAAA33A33AəAɮA
AzA  A(A  A˙ẠA˅A33AəAA\)A
A
=A\)AA(AǅA\)AzAAA(AǮA
=AAA̸RA
A
A(AAAGAΣAffAͅA
AA=qAHAAQA(AAͮA(AzAAϙAЏ\AхAAӮAӅA  A  A  A
AHA=qAAϮAA
AӅApApA
=AHAHAA
=AәA{AGA  AϮAΣAQA=qAffAffAԏ\AԸRAӮAA
AAQAAAQA{A{A(AͮApAẠAͅAzA  AQAA\)A(ApAzAɮAʸRAʣAɅAɮAȸRA{AGAAΣA(A=qAAA
AffAA
=A=qAffAzAGApA{A{A=qA
AHAffAA{AAQAffAA  A
A33A=qAɅAɮA
AʣA
=A{A  A  AzAA
=A͙ApAΏ\AΏ\A͙AϙApA=qA  AΏ\AȀ\ApA33AAͅA  AQAҏ\A
=AЏ\A͙ApAЏ\AӅAHAHApA\)A(AAAAϮAGAzA33A=qAHA=qA  AGAHAGAGA
=A(A\)A\)A33A˅A\)AAʏ\AˮAʏ\AʸRA\)AHAHA{AQAAԏ\Aҏ\AAA
AУAӅAApAzAffAљApA=qAΏ\AͮAHAΏ\AΏ\AθRAθRAAzA(A\)AffẠAApA\)A{AffAzAθRAffA33AA͙A\)A͙AΏ\AAHAQA˅AffAθRAQA͙AffApAzA
=A
AυA
A\)AzA\)AиRA\)A
=AHAиRAѮApAffAQA  Aҏ\AffAυAA\)AAẠAffA
A{AˮA33ApA  AffȀ\A  AQA=qAzAAffAAA\)A=qA
AHAA
=A˙A\)A̸RAAAffAAͅA
=A{A
=AɮAGA{AGAAAA(AQA{AхA33AA=qAAѮA
AљA
=AΣApAAAHẠAAʣAəA
=AffAzA{A\)AAəAʸRAAzA{AA=qA  AȀ\AffAA  ApAʸRAɮAʣA\)AHAGAɮApAzAAAʸRA̸RA͙A\)Ȁ\A{AAͅA  AffAzAȣAHApA
=A
=AA
AAA\)A  AŅAHAřAAHA˙AAffAȣAȸRAȏ\A
AAȣAA
A{AȣAəAɅAAɮAǙAƸRA{AAGA33AA=qAA33ApAɮA  A
AAA
A
AɮAɅApAAHAAȸRAHA
=A
=AʣAʣA
A˙A
=AHAzAQAHA33AffA=qA{AQAAǮAA
=AA33AzAƏ\AɮAȏ\A  AǅAAAƏ\AffA(AzA{AAA
A=qAȏ\A  AGA33AzA
=A  A\)AHA
AʸRA  AAɮA33AQA
=A̸RA  AʣAAA\)AzA33A33AͅȀ\AAA=qA=qAθRAAAЏ\AHApAA
AAңAҏ\AҸRA{AzAffAAљAAAAѮA
AA
AЏ\AAffAϮAѮAAA33AϙAQAʣA  AϙAA\)AGA˅AAͅA{ApA\)A(AAA
=A  AA  ApAˮA  AˮAGA33AΏ\A
AffAA
=A  AΣAQA  AAAzAʣA=qA(ApAHAA\)AʸRAQApAAAA{A{AˮA  ẠAAͮAͮA(A33AAAA(AHAљApAңAңAHAҏ\AzAҏ\AzAңAA
=AGAGA
=AAҏ\ApA(A=qAϮAHA\)AA
AϮA\)AGA(AθRAAͅȀ\AA33A{A\)AApAAHAAAA
=A=qAAQA(A˅AA
=AHApAθRA=qAHAQAAffAA=qAʏ\AHA  A(AʸRAˮA  A{AʣAɮA33A(AȣAGAGAɮA=qAA(AAQAGAͮA̸RA=qAzAϮAAAиRAGAQA
=AAzAA֏\AָRA
=A33ApA
=AHAA
=AָRA֏\A=qAAՙAQA=qAHAծAAԏ\AffAԣAԸRAffAӅAAҏ\AAQA(AHAffAϮA{A  AAԏ\AӮA  AҸRAͮAϙAGA˙AAffAffAHAApApApA
=AHAAA{AApAffAθRA(AzAGA͙A\)AApA  AQA=qAҏ\A33AЏ\A̸RA̸RAGAʏ\AAHA=qA(AQAиRAиRAљA  A=qAQA=qAHAGAәAәA  AQAԏ\AAApAՙAծAծAAA
AAՙAGA\)AA
=AQA=qAӅAAҏ\Aҏ\A  A33A\)AϙA\)AA=qA33A\)A˅AA˙A{AAυA33AAffAΣApAΣAϙAzAHAGA\)AA
=AиRAAGAA{A͙AzA
=A=qA͙A\)A
=A(A{AΣA\)AAAиRAЏ\AzAхAAQAхAAAGA
A  AQAAAGAGAУAA=qA{A33AHA33AAAҸRApAzA
=AAӮAAzAAAԣAԸRA33AHA  A{AA(AA{AGAAffA{AAAGA33AхAиRAHA33AљAHAApAԏ\AѮA(AApApAҸRAAԸRAAAAA=qAffAzAAAAGAAAffAGAθRAA33A{AffA=qA{AA(A=qAQAA{AHA
AApA
A\)AffAAHAAAәAAӅA=qAAԣAԸRAHAAApA
A
A
AA{A{AzAָRA{A(AAAGA\)AׅAׅAׅA׮A{A{A֣AHA֏\AָRAָRAָRA  A
AՙAA(A=qAQA{A
AAA33AffA(A(AffAffA
=A33AffA33A=qAzA(A=qApAԏ\AGAAAҸRAGAGA  A
=A
=AQAAHAAGAͮAΏ\AHAиRApAffA=qAGA  A=qA=qAԏ\AzA(ApAхA=qAҸRAGAHAҏ\A{A=qAffA{Aҏ\AzAzAHAGApAәA  AԣA
AәAffA{AԣA
A
A
AӮA(AGAA33A33AA=qAzAHA(AHA
AzAA{AָRAԸRAA{AffAԸRAHAQAAHApAA֣A\)ApAHA{AQAϙAAGA
=ApAHAGAAAQȀ\AϮA(AӮAәA33AиRAAGAffAQAffA
AA  A
AAGApAԸRAׅAҏ\A\)AAˮAQAљAAAAQAҏ\AAAA
=A\)AGAәAzAԣAAHAHAQAAA  A
AӮAAQA
A33AҸRAzAHAѮAAffA  AA  A33A\)A(A
AHA֏\AAHAAծAծAӅA{A=qA\)AAHA
=A\)AffAӅA(A  AGAAGA\)AffAՅAυAAA  AˮAHAHAApAAхA
A{AљA
A33A33AA
=AffA{A{AGAAиRAHA
AAAAHAљAQA(AffAУA33AAAffAzAиRAхAzA  AхAхAѮAѮAѮAљApAѮAѮAzA(AffAffA=qAAAAQA
=AәAA(A
=A\)AAA=qAGAA(A{A
=AGAAΣAHA=qAA  AffA{AљAхA
=AQAA=qAЏ\Aҏ\AA=qA
A
=A
=A=qAΣAffA  AиRAAAAAA  A
=ApAиRAA=qAAHA{AAיApAAٮAAAAHAffA
A
=AӅAָRA֣A  AzAffAffA=qAzAAffA
A{AGA֏\AGA\)AQAׅAׅAָRAQA(A
AծAՙAGA  A=qA{A  A
AәA33AGA=qAffAAәAQA=qAzA{A
=AHAHA  ApAA  AأA֏\AAӮA\)A
=AffAA\)A  AңAA(A  A=qA
A{A=qA
AЏ\AHAиRA33AͅA33AAffAApA  AAHA33AzA=qAQA=qAԏ\A=qAA
=AA(A  AУAAA(AAffA{Aҏ\AӅA{A  A  A(A  A=qA(A  AA(AәAԏ\A  A=qAԣA\)AծAծA\)A=qAA\)A=qApAGAHAԣAAՙA  AAAGAffAA
=A  A=qAԣA
=AGAхApAAԏ\A{A(AAGA
=A
AAzA
=AΏ\A\)AffA
A=qAQA=qA  Aʏ\AzAA(AHAAGAˮAffA
AθRAAAQAffAffAϮAzA
=AGAQAGAѮAљAA=qA
AиRAθRAffAQAΏ\A
=AϙAУAѮA(AAAQAծA  AzA֣AGA׮A(AffA  AffA\)A׮A֏\ApA=qAՅAGAA{AGAAQAffAQAffA֣A
A֏\AffAиRA(AHA
A\)A\)A{A  AңA{A
AAQAңA
=Aҏ\AAzAЏ\AffẠAGApAЏ\AHAΏ\AиRAGApA˙AffAAθRA  A
=ApAzAѮAAԣApA{AzAGA\)AffAzAA33A׮A
=A33A(AծA  AAAAA\)AA33A33AՙA
AAՅA(AQAA(A=qA
=A֏\AzA֏\AffA{A{A؏\ApAٙA؏\AffA֣AffAA{AGAיApAHA(AA33AA\)AיAAӮA
=AיAGAՙAQA
ApA=qA
=A  ẠA  A{AHApAzA̸RA=qAAҏ\AGAHAzAffA  A(Ȁ\AAA{AGAzApAAQAAA
A
A=qAzA{AϙAΣAGAA
AΏ\AA˅AA33A
=A\)AA33AҸRAңA33AGAӅAApAA{AffAzAffAA
=ApAA
=AHAԸRAzAA
=AҸRAңA\)AәA  AԸRAA
=AAҸRAԸRApApA(A(A{AA(A33A  AиRAAA{AHA33AzA=qA=qAҸRAA
=AHAҏ\AA33A
=AљA\)A
=AңA
=AңA\)AУA{ApAQAυA(AzAͅAzAffAңAAffA
=AGA
AՅA(AAծAՅA{AQAՅA=qAHA
=AՅAՙAHA\)ApAA׮AA(A(A{AQA=qA=qAظRA\)ApA33AzAffAQAQA=qAAAָRAAzA؏\AظRAA
=AzAzAأA
=AAAHAأAffA  AיAAA(A{AAأA\)AffAA׮AGAAQAA=qAApAԏ\AAffAQA(AA
AffA(A=qAԸRA(AӅAffAAQAәAzA  AffA
=A
=A
AՙA
AA(AA  A{AәAffAQA
=AծAffA֣ApApAAffAzA=qA=qAQA{A
A(A{AHAHAHA
=A
=AA؏\A(AGAAHA=qA؏\A
=A׮AAGA
A(A  AQAffAA\)AׅAAיAA
A{AA
AAA  AA  AԣA
AHAיA
=A  AGA֏\A
A֏\AzAA\)A\)A33AHA
=AQAffA33ApA\)AAGAGAA  A͙A33A=qA
=A33A{AӮAA  AHAиRA33AѮAA(AAGAGA=qA33AA  A{AHAAA{A{A{A׮A=qAffAzAzA
=AAGA\)AAظRAA{A33AظRAA  A؏\AHA\)AffAHA\)A
A{AHA33AAGAՙApA33AA{A\)AAAAҏ\AAzAzAQAԏ\AffA
AA\)AA\)AAQAԏ\AԣAԏ\AHAхAffAѮA33A=qA  AHAGA33A{AӅA\)A33AffAHAHAAffAAA(A
=AׅA
=AAיA  A=qA\)A33AffA
AمA
=AٙA
=A\)AمA=qAffAApAGAۅA
A  AڸRA\)A\)ApA(A33AA(AٮAAffAA
ApAA֏\A  AffAzA=qA
AأA(AzA=qAGA
=A=qApA
AAA33A{AA
A
AffA֏\AffA(AAՙAffAԏ\AzAHAffA  A
A  A
A33AA\)A\)A=qAиRAѮA\)AffAQAffAҸRAffAQA  AӮA=qA
AAGApA
=AӮAәAAәAffAԸRAA\)AGAՙAAGApAA(A
=AGAffA\)AHAzA=qA{A  A=qAffAA{A{AA
A
=AظRA\)A\)AHAAׅAظRAAAzAzA؏\AAAQA(ApAQAHAAӅA=qAՙAAzA؏\A֣A  AffA؏\AׅAA֣AA(A(A׮A֏\AGAffA=qA
=A=qA\)A֣AA33AffA֣AՙA=qAHA
=AQA  ApAָRAHA33A(A{AAGAAA{ApA(A{A\)AծApA33AAA{AQA{AzA(A(A֏\AָRAzApAGAGAHAAffAAA؏\AGAA{AׅA
=A\)AיAׅA׮AׅAHAA֣AՅAՅAGA
=A(A{A=qA\)A
=AHAHAAHAAҏ\AָRAzA
Aҏ\AGA{AҸRA  AAхA  AzA{AЏ\AѮAхAHAΣAGA33AAGA{AAA
=A33AϮAϙAA{AQA=qA33A
AѮA
AиRA(A\)A=qAAңAA33A33AәAAԣA33AAA33A
AծA{AzAHAHAzAיAHAHAzA  AA33A(AApAAAHA\)AA33A33A֣A(A=qA{A
AGAffApA  AQAffAzAzAAхAGA(A(AApA\)AAAA33A(AzAхA  A=qA33AУAAУAAffAA\)AGA{A(AиRAffA=qA{A  AGAAυApAυAϮA
AAHAGApAGAAffAHA\)A=qAԏ\AծAՙA
AQA֣AָRA
=AיAAA=qA=qA  A  A
AAAAAAׅAׅAA
A
AAׅAׅAApAA  A\)AHA\)AAA(A{A{A
A  AffAA=qApA=qA\)AAAAGA\)A  ApAAҏ\ApA
=AхAљAffȀ\AAAѮAѮA
=A(AQAzA33A{AHA\)AՅA(A{AzA֣AQAQApA(AAzAGAQA{AzA؏\A{A
=ApAHAAA
=AAAԸRA=qA
A{AAיAzAzAAA
=A33AAAAHAQA{AٮAمAA(A؏\AAA{AHAԏ\A
AՅA
=AծAծAAA
AffAA=qAָRAAAA֏\A=qA׮AظRAzA  A33A33A
=AظRAffAծAңAAzApAҏ\A33A
=A
AAԸRAHAԣA(AAQA(A
=AHA
AzA
A
A  AңA
=A\)AzApAԣAGAՙA  AԸRAffAAAffA
=AٙApAڏ\AGApA{AzAHAAHA܏\AzA  A  A=qAA\)A=qAAAzAAHAzA܏\A{AHA
=AAAۮA\)AۙAQA
=AA33AA{A=qAڸRApA
=AffA֏\AHAQAffAAHA33AأAAQAffAיA
=AAffA\)AظRAA{AQA(A
A{A=qA33AAظRAAA(A(A{A=qAzA{AzA  AffAA(AHAzA
=AHA\)AأA׮AHA\)AיA  AzAأAأAzAظRAAظRAأAAHA؏\A33AGAAHAAzAAHAمA\)A\)AGAA
AٮApA\)AGA33AGAٙAظRA  AAAffAأAAՅA33AA
=AԣAffAHA{ApAffAAzAHA{AAҏ\A
AApA{ApA  A{AA33AQAΏ\AAAA33Aҏ\A{A  AՅA33AAAׅAHAծAAQAA  A(AHA33AיAA=qAffAzAA{A=qA؏\A\)AA33AٮA  AAffA(AՙAծAԣAԸRAԸRAA{A{AӅAA\)A33AGAՙA\)AծAAԸRA33A=qAzAHAԸRAA\)AծA֏\A֣AԣA(A֏\AzAָRApA
AٙA(AA׮AיA{A׮A  Aҏ\A(A
=A  A(AЏ\AQAAУAffAԏ\ApA33ApApA
A33A͙A\)A
A
=AӅA
AA\)A
=AA
=A33A
=AQAԸRAՙAAHA{AָRA=qAA
AAA33AңAHAҏ\AGAAAQA{AApAAAQAHAAffAffAA  A(AՅAՙApA\)A\)AA
=AHAGAAԸRAԸRA33A
=AHA
=AGA\)A33AzAAffA  A(A
=AAQA=qA(AҸRA\)AәAәAQAQAzAAGAffAAAzA=qAGAffAAGAΣA
=AУAA̸RAGAAθRA=qAHAffAӮAӅAҏ\AHApAffAA{ApA  AϮAffA33AAυApAυAυApA
AzAAApAAAAA\)A\)ApApAӮA\)AәAӮAӅAAӅAAәAGAApAљAffAzAAHAGAA
=A33AиRAAЏ\A{AθRAΣAAzA=qA
=AAAzAA=qAAffAApA
A\)AθRAΏ\A  AQAA  A=qAϙA
AAиRA\)AAAΣAffA
=A  AA=qA  A33AffAffAυAAzAGAGAиRAA{AAAffAAA{AAAzA\)A
A  ApA  AAffA֏\AHA33A\)AׅAיA\)AׅApAׅA  AGAՅAAzAHA
AAAA(AA=qApAGAQAzA
=AGAAׅAиRA  AzA=qA֣AA  A(ApAׅAAAApA{AԣApAA=qAәAQA33AGAAffA=qAffAffAAffAzAAAHA(A
=AGA\)ApA33AA{A{A(AzAѮA{AAAQAҸRAҸRA33A\)AApA(AffA
=AA\)A
=AAffAHAA
=A33AGAՅAA=qAQAAffA֏\AQA
=A{A
=AAHAAAA\)A
=AGApAGAGA
=A33AGAGApA
AיAAAHAAA(AѮAzAAHAAzAGA
=AHAӅA
=AAӮA{AAHAӅAЏ\AAָRA=qApAхA\)AzA\)A33A(A
A=qA
AA
A
=AzA\)AAԏ\AzAծAGA
AHA\)A  AQAиRAAGAApApApAϮAϮApA̸RA˙A=qAA
AAGA=qAƏ\AA(AŮA33AģApA
=AAffA\)AGARAA
AAHAAAAAQAA=qAA=qAA\AzAAAAAffA(AAAGAAA33A
=AARAApAARAGA  A33AzAAAHA33A=qAzA
AAGA\A(AA
=AAA\A=qAGAA\A
=A  A(A\)AĸRApA=qA=qAApA\)AA\)AȸRAAͮAApAAϙAA33AA\)AGAͅAA33A\)AAиRApAAǮAGAHA\)AAGAиRAQAA{A  A˅AA=qAǮA=qAAzAAQAƸRAȣAAQA˅AAəAA(Aȏ\AQAGA(AGA{AffAɮAəApAAffA\)ApA33A=qAA33A\)A˙A˙A=qAɅA=qAиRAAAΏ\AffAəAAQAʸRAAAəAzAAAģAȀ\A  AHAHAHAA33AA
=AǙAAɅAAA{A(A  ApA=qA=qA
AAQA=qAHAϮȀ\ApA(A
AAAAAυAHAɅAÙA
A(A(AffA\Aď\AŅA{AA
AzAffAȣAQAAřAȏ\AzAȣAHA
ApAzA33AffAARA33A{AAApARAA\)AGApAAzA33A\)AAA
AApAApA=qAffA{AAQAA  A  AGA
=AffA\AAQAzA\A=qAzAAA
A
ARA(AGApAƏ\A=qA  AAAÅAA  A
AffAA
=AA33A  AHA{AARA
=A33AÅAAA¸RAGA{AAA33AAQAffAzA=qAffA{A\AAGApA(AAA\)AŅAHA
AAA=qAA\)AA33A  A\)AAAAAA\A=qAAHA  A(A(AAHA33A
ApARA
=A=qA£AAGAQAÅA=qA
AA{ARA
AA=qAzA
A=qAAffA{AzApApAA
=A33A\ApAffAĸRA33A=qAffA
Ȁ\A\)A33ApA
AAÙA=qA=qA
=A\AGAAGA¸RA=qA{A\)A\AAAzAAAAAzAffAA{A
AAHAA33AŮAffAzAffAzA
=AAA33AffA\AzAGAAffAAA  AGAA  AŅAď\AAAÙA
=AģA33AzAAÙA
AəAʣA33AAA(A(AAQAzAȣAȣAHA\)AAɅAəAQAƸRAffApA{AQAAGA
=A\AAQA
A˅A  A  A33AHAA˅AA
=A=qẠAͅAffAffApA{AffA
AzA{A
=A  AƸRAǙA
A
=AzAɅA˅AɮẠAzA̸RApAͮA33AŅAÙAzA
=AȸRA˅AA
=AQApAQAffA
=AΣAffAHAAA
=AŮAŅA  Aď\AA
=ApAAřAAŮAAA{ApAA=qA
=A(A=qA(AA
AQAffAAҸRA  AхAУAAϮAυA33A33A
=A͙AȀ\AAʏ\AAGA
AA͙AAA
=AA(ApA
=A\)A{A
AʣAAȏ\A{ApAGAģAŅAAzAAGARAGA£A33AAA\)A33AHA  AGAÙAzAffA
AzAAîA\)A33AA{AîAÅAAQA  AA\)A{A
AřAHA\)A
=AGAApAzAƸRA
A\)AAzAA\)A\AzAĸRAzA(A
A
=AA=qAQA̸RA
A
=A\)AzAA(A(A
=AAA
AAAQA
=AQA¸RA=qAAřAƏ\AffA=qAAA  AA(A\)AAAAQARAA(AAAA
AAA
AHAGA\)AA33ApAAzA(AAAGAAA\)AA33AGA{A=qA(ARAHA
ApA{A(AzAAAAAA\)AA¸RA
A
=AAĸRAȸRAȣAAQAȏ\A
=AQAGAAzA
A  A\)A\)AȸRAȣA
A\)A33A
Aʏ\AAA  A̸RAAA\)AAQA33AAAHA33AA
=Aʏ\AʸRA=qA
=AHA(AQAzAŮA  A33ApAA¸RAA
=A(A=qA\A(AAA
=A\AA
=AAApA
AA{AQA\AHA=qAA˙AA=qA{A33AȸRAəA  A\)AƸRAffA(ApApAƏ\A\)AAʣAHAͮA=qApA
A{AAAAAHApAzAAQAA  A  AAHA£A(AAA33AAƏ\AQAʏ\AHAA  A
=Aʏ\AzAAApAA=qAA
AθRAAAQAQAAAA=qA{AŅAAAAGAApAGA\AAA\A  AŅA=qApA
=AApAAzA=qAĸRA  AzA=qAAɅA
AffAAA33AAƏ\AŮAGA{AA\)A{A33AA\)AAŅA  A{AAA{A(AzAA33AAͮAA=qAffȀ\A  AzAQAHAӅA
=AAхA\)AϙA\)AQA{AGA
ApAǅAAGAQAɅAA(AHAƣAA33AA  AA(A˅A  AŮA
=AA(AGA
=A33AƣAzA
AGA\)A(A
=AApAɮAffAGAʸRAQAAˮAəAzA\)AɮAffAAȣA
=AəAffAȣApApA\)AƸRA=qAƏ\AA\)A{AģAAzApAA(ApA\)AHAAAzAGAʸRA
=AA
A(ẠAffẠẠApAGA=qAA  AǮAA{AAAHA\)AzAǙA\)A33AƏ\A=qAHAȣA\)AA
ApAAzA  AǅApAAAzA\)A  A(AɅAGAA33AȣA
AǅAAAȏ\A
=AApAA\)AîA£A=qARA(A
A
=AǙA
=A̸RAAəAAˮAGA(A=qA(A33AGAGAȣAAzA33A
=A{A(AǙAzAA  Aʏ\ẠAA  Aȏ\ApAAGA(AͮA͙AͅA
=AQAA\)AQA
=AAԣAGAffApAzAԸRAAQAAA\)AzA  A=qA{AAffAУAAffAHAAθRAA͙AɅA  AAǙA\)AQAGAQA=qAΏ\AHAHAzȀ\A̸RAffAApAƣAǙA
=A
ApA33AAffAAAȏ\A\)AGAAAAͅAGAHAAǮAǙA33A\)Aȏ\AA33AAGAAAHAzA{AffAθRAHA\)AӅA33AԣAQApAԸRAՅA
A\)AәAGA(AӮAGAA
=A33A
A
AAA  Aԏ\A
Aԏ\AҸRAԸRA
=A
=A(A(Aԏ\AQA{AAGA
AңAQAңAңAAҏ\AхA  AAAffA
=AAzA33A͙AQAΣAzA=qAθRA(A=qA(AA  AʣAȏ\AAẠAAȀ\AA33AHApAA\)AңA33AA͙AHẠẠAQA
=AΏ\AffAffAHA
AA  AQA{Aҏ\A  ApA33AԸRAHAAӅA\)AQAУA
AHAУA
A=qAzA\)AA
=A{Aҏ\Aҏ\AA
=AхAҏ\AHAУAQApAQAAҏ\AӮA{AA{AAәAAӅAffAәAңAӅAA(AѮAЏ\AGAQApAљAzAffAA  AυAAΣApA{AͮAApAHA33AQAřAAzAzAəA  AǮAzAΣA(A=qAGAͮApA=qA  A33A33A  AQAҸRA(AzAңAAAҏ\AHA33A\)ApAәAA
A
AAӮA
AA(A=qAffA(AffAЏ\AЏ\AAљA  AϮAAA=qAAGAѮA33AӅAAA33AхAAѮAAHAHAzAхApAQAθRAGApApAΣA
AЏ\AAȀ\A33AA̸RẠA=qAəA(AθRȀ\A33AͮA=qApA͙A33AAͅAθRAA  AʸRAAA
=A\)AHApAϙA
AQAHAGAA(Aҏ\Aҏ\AQAffAQAGA=qAQAzA{AQAQA(A(A
AՅAՙA33AAԸRAGAծAՙA33AԸRAԸRA33Aҏ\AApA
=AAAA=qAQApẠAA{AɅAHA
AхAAΏ\A=qAϙAffA{AхAAѮAϙAAHA
=A
=ApAAљẠAA
=AA
AиRA
AA̸RAͮA\)A
=A33AA=qA{AAʏ\AHAAΣA{A
=AAAͅA=qAΏ\ApA33A{AQApAAAffAңA{A=qAҏ\AAGApA\)AffAAҸRAңA
=ApApAHAHA(AAϙAGAA=qA  AGAAA  AՅAA  AzAA
=AHApAHA{AzAA
=AHA=qAυA  A
=A=qAA33Ȁ\A33AͮA͙A͙AffAͮAAHA{ApA
AͅA33A(AAGAHA  A  ApApApAͅAA
A{A
=ApAHA(AAљAхA
=A  AHAffAAхA\)AAӅAHAA33AׅAAA
A=qAQAzA؏\A؏\AffAffAQA=qAQAzA  A{AָRA\)A׮AAffAAAAAffAԏ\AffAQA(AӅA{AAzApAApAzAՅAՅA
=AzA
AGApAҸRAҸRA
=A  ApAхA  Aԏ\A
AGAӅApApAGAzAHA
=A(A33AzAѮAУA
A33AAHAΣA
A͙AˮA
AffA
=AУA
=AϮAQAAиRAљA
=AA=qAA
A
=AиRA
A=qAffA\)AAAУAffAA{AA=qA{A33AиRAGA{Ȁ\AυAAA33A  AQAAA\)AA(AAGAHAAAɮAQA
A(AffAzAAffA\A\A33A
AQARAAzAQAA=qA\)AQA{AzA(AAA  A=qApApA\)A(AffAAffA\)AA{A\AffAffApA  A
=A
A=qA(A(A
AAzA33A
=A33A{A{A33AA{A=qAAÙAQAģA
=A(AŮAGAHAƸRA33A33AA  AA
AQA\)A  AˮAGA¸RAA\)AQAȣA{AA\)Aʏ\AQA\)AHAffAͅA  AAzAAAA=qAA  AңAхAAљAHAGA33A=qAυA\)AAȀ\Ȁ\AzApAA=qAAAffA˙A33AȀ\AGA33AzA˙A(AA̸RA=qA33AA̸RA\)A̸RAͮAAAffAθRAͮA
=AͮApA33AУAϮApAHA(AQAGAGApA
A  A=qAQAzAAәAQApA
AA
=A͙A{A\)ApAӅAzApA33AAAA\)AӮAGAApA\)AAAҏ\AAAиRAAУAGAAϙAθRAAHAffAHA=qApAQAθRAθRA͙A  A
AQA33AиRA
A͙ẠA͙AHA(AͮA(A  AиRA{AAQA\)A33A͙AGAQA͙AΏ\A{AθRAAA\)AA{A  A͙AẠA
=A\)A{AQAAңAϙA{A=qAA
ApAͮAυApA=qAzA\)AzAHAA\)A  A(A
AљAAΏ\AQAθRA{AAA33AҸRA=qA
A  AAffA(AѮAA(A(AHA33AϙAQAAffA{AхAA
AѮAQAΣAQAA\)AHAУA=qAAˮAAffẠAGA
=AAЏ\AHA33AHAϮA(A\)A  AA  A(A
=AA=qAGAGAәAӮA
A{A
A֣A
AAA\)AHA33AAGAQAأAGAGAzAAظRAffAAAAۮAQAffAzAܣApA33AA
=AA33ApAAۙApAAHA=qAA33A(AApA
AAAAAAA{AAApA{AA=qAffApAиRA{A\)A{AϙAAAGA
AϙA
A{AffAApAA(A˅AQAͮA  AzAQAHAA
AAQAיA{AAңAՙA(A\)AAυA33AHAΣA{A
A
=AGA=qA  A{AzA  AzA\)A  AAٮA  AzAQA33A\)AA{A
=AAQAApA(AA33A\)AAمAمAمAA؏\A
A  AיA(A֣AAzAՙA\)A=qAԸRAծA
AՙA
=AAffAAӮA=qApAA
=AңAHAѮAAљAAA
AиRA
A
=AHA\)AУAzAHAffA33A
=AzAAϮAA  A=qAGAA(AAGA  AffAΣAΣAGAυAA  AЏ\AA
=AHAA33A\)A\)A33AHAУAУAA  AGAA\)ApA33AAθRAΏ\AQAΣAυA{AHA(AAΏ\A
ApȀ\AQẠAzAzA̸RA{A  A=qAA  A
AGA\)AA=qAQAAA\)AA(AAffAQApAHA=qAA
=AAA\)A=qA
A=qA(A\)A
A
A33AA(AA
A
ARA\)AGAAApAAHAHA(AA33AAffAzAApA  AAQA\)A(A  AQAA33AffA\AAApAGA
AAA=qAAǙA(AʸRA̸RA=qAffA\AAA\AAzAQAAGAA{AffAǅA
AAAAffAHARA
AAAQA  AApAď\A  AA=qAAAAAAffA\ApAAAA
A=qAAAGAHA\AzA\)AGA̸RAQAA33A{AzA\)Ȁ\A(ẠA{AAzA£AˮAǙAÅAÅA
AɮAGAAυAAɮAʏ\Ȁ\AffAHA{A
AffAΣA
=ApA(AQAGAУAA(ApAffAA
AңAٙAzAAA֏\AGA33A(A33AAQA
Aԏ\AAӅAӮAӅA\)A  AAAυAHA\)AͅȀ\A  AA˅AʣA  Ȁ\AθRAAQAAffA\)AӮAGAHAAHAиRA(AGAGA
=A
=AͮAљAҏ\AA
AHA
=AΣA{AAAԸRA(AA\)A  A(AApA
=ApApA  A  A(AA  AzA֣A
AAHAAۙAGA
ARA
=AA߮A\AAߙAޣAGApA
AݙA(ApA
A݅A=qAAHAzAA
ApA  A{ApAAzA33AA
=AхAϙA\)AͮẠAљAٙAAHAAApA(AAGA
=AڣA
Aڏ\AAffA  AծAAAңApAظRAA{AA\)A\)AA{AA
=A
A֏\AQAffA؏\AA33AңAA{AA  A
AGA(A{AAffAApAffA\)A\A\A{ApA(A=qAQA  ApA
=A  AGA\AA\A{AQAGA33AAA
=AAA
AA{ARAzAAܸRA\)AڣA
A=qAffA  AϮA33ApA͙AzA\)AУA{AQAΣAәAQAAׅA֏\AٮAffAQAHAA{AAљAљApAApAУAẠA{AApA
=AθRAԸRAGA(AHAAQAՙAҏ\AffA  AA33AzAA{AׅAمA؏\Aڏ\A=qAHA\)AA{A(A޸RAA(AffAzA=qA{AzAffAzA=qA܏\AzA{AGApAܣApAffAAAٮA  AA=qAңAՙApA
=AA33AGAAQAӮAHA(A{A\)AffAәA(A֏\A{A؏\AQAA=qAУAиRAHAAHA\)ApAAzAͮAGAAΏ\A(AzA33A
A
A33AGA33AQAzA
AHAzAУAA
=AѮA\)Aҏ\AQA  A=qAA(A
=AQAۅA\)AA
=A
=A33ApAGAHA
=A33AڣAGA33A
=AܣAHAHAA݅ApA\)AzAffAAffA\)AӅA(AAA
=AHAA  AңAGAA  A33AиRA33AGA{ApA{A=qAQA\)A  AAQAA\)AQA{AHAGAHA{AθRA{A
=A\)AˮAA(AӅA33A=qAAHA
=AхAzA{A(AffAffA̸RAffA
AиRA{AՅApAAGAA(AA\)AQA33AӮAAAՅAQA\)A{AHAAAffAA  A33AיAA  A  A(AA
=AffAQA(AffApA\)AظRAծAzAAҸRA33A{AۮAffAAHAffAAڏ\AAQA{A  A33AA
A{A{A33AQAGA  AљAQAAΏ\AA\)A=qAHẠA
=AʸRẠAzA
=A˙A˅ApẠA֣AԣA33AظRAָRA=qAGAAAA\)AAA(ApAՅApAGAA֏\AAָRAأAAڏ\AAzAڏ\A(AܣAAA
=A33AۮA
=A׮A֏\A(AHA֣AA޸RApAA=qAAA  AAظRA  AׅAAQAGA\)AAיAծAA
Aҏ\AffAӅAЏ\AzApAиRA\)AQA  A{AθRAAHA
=A(AυA
A33A33AAzAϙAΏ\AQA
AAϮAffA\)AϮAУA
=AθRA{A{A\)AǅA(AAAȸRAAŮAď\A
=A
=A{AQAȏ\AAңA=qAffA\)A  AAffA
=A
AAHApA  A{ApA33AAיAٮAA{AۅAGAGA33AA  AۅA(A
AAA
AQAA  A  A
A\)A
=A33AA
=A=qAՙA֣A33Aԏ\AA=qAQAGAGAQAиRAQAѮAиRA33A\)AA\)A
AA{AHAҏ\AQAЏ\AzAхA
=AGAΏ\A33AΣAAΣA
=AAHA
=AffAGȀ\AGA=qA̸RAffAΣAffAΏ\AυApAffA
AЏ\AHA
AApAԸRAׅA{AzAA{A{AffA{AأApAٮAQAڸRA
=AA{A  A=qAAݮAAAAHAܸRA\)ApA33AHAAGA
=A\)AffA
=A
=A33A(A
=AיAיAGAՙAָRAAA
=A=qApAՅAHAA
=AAA֣AՙApA
=A=qAͅAQAAAHAAͅA=qAGA33AυA\)AGApA(A=qAA͙AGAͅAAУAΣApAAхAΏ\AΏ\AΣA{AA
AAA׮A{AأAمA  A
=AمA{AGAٙA܏\ApAQA
AܸRAGAGAޣA
=A
=A߮ApApAARA
A(AޣApA  AݮAAݙA(AAA=qAAAA(AHA33AAHAA׮AA
=AٙAApAAzAAQAAԏ\AҸRAҸRAzAAѮAңAָRAԣAAzA  A33AԸRAAQAʸRA(AAڣA33AA(A(AA33AQApAffA
AffA\)AۅA܏\AمA
=A  Aޏ\AA
=AQAApAHA=qAApAظRAمA
Aԏ\AՅAQAApAڣApAۙAA  A(A
AAA  A{A(A{AQAQAܣA\)A  A(AAۙA
=AHA  AGAA(ApAڸRAA  AGA
AGAظRAԸRAGAAٙA
A(A
=ApA  AۮA{AٮAGAAzAAׅAAAHA33A؏\A׮AQA  AHAAzAׅA؏\AQAGA{AׅAQAHA\)AHAՙAA
=AיAHAՅAԣAՅApAӮAHAzA{AԣAffA(AApA\)A  AA(AϮA(AHAӅAQAA(AӮAApA33A֣A
AAHApApA  AGA{ApAAAӮA
AAѮA  AAGAәA33AApAQA=qAzAA֣A=qAGAA
=AA=qA  AzAQAGAՙAԸRA\)AA֣AAAHAA  AAAA=qAQA
A
=A(AA{A{A֣AAGA(AҸRA33AљA33A=qA=qAAԸRA
A
=AϙAQA=qAϮAΏ\AQAAAGA  AиRAAQAAA  A
=AffAAGAGAЏ\AQAAHAٙA(AAיAծAGAӮAәAQA=qA(A=qAAՙAAffA֣A֏\AGAAA=qAڏ\AHApA{A  AۅA{A
=AffAAۮAAAٮAAיAAڸRA
AHAAAHA{A
AffA{AQAGA{AAAAAمAڣA=qAAٙAA
=ApAQA(A
=A
=A(AڸRA(AApAzAA(AA
=A
AңAәA(AQAffApA
=A=qA  AHA  A֣AٙAڸRA{A
AGAzA{AAAA33A׮ApAAՅAָRA׮A(A33A33A(AAQAffA33AݮAffApA߮A33A  AA=qAAᙚAAzA{AAA(AAAݮA  AᙚAAQAA\AzAQA
=Aޏ\AARAHA
A  A߅A߮A
=AzAݙAHAffAA
A(AHA(AA֣A\)ApAzAA=qAffAAAAGAޏ\A\)AAGApA
=AHAHA\)AGA{AzAAHAAffAGA\)A\)A  AGA33ApA{A
A؏\A
AHA  A33A{AޣA\)AA{A  AzAzAARARAffAA
A(A=qAAGAAAQAQAA(AQAHAHAAAARAzA\AffA=qAzA=qA(A(AA\)A޸RAGAffAQA=qAQAܣA܏\AAAۙAQAQAޏ\AAzAQAAA{Aڏ\AGA33AGA
=A
AA=qAԣAAәA(A
AظRAQAzA\)A
AՅA
=ApA(AHAGAۙAQA܏\A
=A܏\A܏\AffA=qAzA\)AA{AzAHApA߮A߮A߮A߅A߮AAHApA{AA  AzA33AA  AQAۮA33AffA
A\)A
=AAA޸RAAAQAHAAzA݅A33AGAGAHA݅A݅AܸRAܸRA
=A33AA33AGAAA\)AݮAHA֏\AGAׅAAٮAAGA߅ApAAՅA
=AA{AQAzAQA
=AAԸRAAܸRA=qApA(AffA
=ApAzAffAڏ\AzA(AQA33AffA֣AAHA33AffA
A  AأApA{A
AAffAzA=qA=qA
=AzAffA33A33A
=AAظRAAA  A؏\A
=AڣAڏ\AAٙA
AۙAA
=AAۙA  A=qAQAAffA(A(AzAٮAHA\)AQAzAظRA=qA؏\AظRApA33AffA{A{A
AԣAԏ\AAQA
=AծA֣AיAׅA׮AׅA(ApAAffAGA(A
ApAAAAظRAA33AAԣAAA33A؏\AzAۮAQAڏ\AA=qAQA  A{AA\)A33AApAAzAAָRAApAA\)A׮A  A  A=qAQAffA33AظRAGAAڣAۮAAڣAA=qAzAQAأAA33A{AٙAٮAمAAA\)ApAAۮA
A(A33AA\)AGA
=A{AA
A
=AzA=qAA׮A
A{A
Aڏ\A
=A
Aԏ\AzA(AA\)AzAиRAffAAAA=qA
AӮAӮAAAzAAGA=qAЏ\AңA
A\)AңA  AA  AՅAQAمA  A=qA(AٙA33AQA33AָRApAԸRAAAQA\)AA(AAA
=AָRA֣A֣A  AAA
=A  AQAAHAAQAA
=A
A׮A
=A{AٮApAٙA\)A  AQAAGA\)AAAHAمA{AzA(A(AՙA(A
=A
AծA(ApA=qAظRAظRA{AA׮A֣AָRAAAffAA\)AApA
=AA33ApA  A
=A33A֏\AzA\)AA׮ApAzA{AGAAA֣AApA  A(AأAٙAأAA
=AffAٙAAGA33AAA  A(A
=AzAڏ\AڸRAA
=A  AGA{AGAzAڣAQA{AGA\)AمApA33A؏\AGA{A
=AAظRA
AzAׅAA֏\A=qAAծAHAAAA֏\AՅAAAхA  AҸRAӅAffAAGAָRA\)AمAffAffAׅAӅAffApAQAA
=A(AzAQAׅAffAHA֏\AA\)AQAӮAAGAHA׮AzAAٮAٙA
AڸRAۅAۙA  A{AffA݅A(A{AݙAGAA33AܸRAHA(AۙA\)AA{A=qAffAۙA  AAA{AApAGAܸRAܣAܸRA܏\AܣAzAAݮAQA
=A
=AAffApAffA߅AzAHAAAAAۮAܸRAAݮAۅAHA33A؏\AAHAAAܣAA  A  A\)A݅A\)A=qAAffAAޏ\A؏\A(A
=AٙA(A33ApA33A(A(A׮A
=AApAٮAٙA
AܣA
AA{A\)AܸRAGA\)A
AAQAA  A=qAGAffA  A߮AAAߙAA
AAߙAffApAHA33ApAA{A  AQAzAA\)A33A
=AHAARARAQA\)ApA33ApA\)AᙚA
=AQAܣAݙAA(AffAAffAzAA߅ApA  AAffAQAQAAffARARAQAQAޣA(A
AffAA
=AGAzA33A(AffA  A  AᙚAᙚA(A{A
A  AAA߮A  AA  A=qARA
=AAA  ARA
=ApA
AA
A噚AAzA33AA
=AAHApAQApA
=ApAAA
=A\A\)AffA(AA\)A  AHAޏ\AzA݅AAzA
=AzARAAA\)AAAzA߮AAApA(AA33AAGAA  ApA{A=qA{AA\AzA
A\)AݙA=qA\)AffApAA33A(AᙚARAA
A
A
A
AzA(AffA{AA݅A(A(A\)AޣAAHA  AQAGAApAzAzAffAQAAffAAA
=AAARAQA{A\A
AAA
A
AA33ApA\ARA{A
AARAA\A33AAA\AAffAQA߅AAAffAAA
=A=qA  A\A33A\)ARA\AAAApApA\)AA(AffA\ARA{A
=AAHA33AQA(A33AHAQA܏\AHAzAAAA  AݙAAA(AzAߙA߮ARAAAAzAA
=A
=ApAHARA{A{AQAffA
AAQAA\)A\)A㙚AAHAARAAzA  A
A=qAApA33A\AHAAAAAAffA(A(AAᙚAGAHAAzAzA
=A=qAAᙚAffAA{AAzAAAA
=A=qAffA
=AA
=A噚AffA=qAAffA33A噚AA
=A\)ApA=qAۙA޸RA  A
A  AGA\)AA33AA݅A(A  A݅A\)A
A޸RAA
A33A{AHAᙚAzAHAAAAAAAAAGApA33AGAAᙚAᙚAHAGApA33A\A  AzAQAA  A=qAffAAᙚAARA
=A(A㙚AAGA33AA33AأA
AGA\)A(A
=AߙAAzA݅AQA(AGAffAAܸRAޏ\A=qAڸRAzA
=A33ApAݮAHAffA  AܣAA(A(AܣAܣAݮAݮA(A߅A޸RA{ApA߮AA33A\)A33A߅A=qAA
=AAAA
=A33AA\A
A
=A  A{AzAAAA㙚A
=A(A\)AAAA33AAA=qA  AA\AAᙚAAApAGAGAAzA{AݙAݙAffAAzAGAAAAAA  A33AzA\)AHA=qAHAۮA{Aڏ\AڸRAAAڸRAۅAA\)A33A
=ApAQAQAHAA݅AzAGAA(A\A33AAA
AAAݮAݙA(AzAݙA
A{AHAHAޣA޸RApAAAA߮A33AGAA
=AHA
=A33A
=AAAAAHAHAޣAޣA݅AݙAAAAHAܸRAzAܣAݙAAA{AA݅A=qA\)A=qAGAQA
AzAAAzAffAܣAGAffAQAڣAAAQAظRA=qAظRAApA\)A
=AAۙAۅAffAڣAٮA(A=qA{AQAAݮA(AQA{A(AۮApAۙA{AApA\)AA{A
A(AڣA33A  AzAApA݅A  AzA޸RAHAޏ\Aޏ\AApApApAAzAzA{A޸RA
AAAHAffAܣAAHAHAܸRA(AHAGA\)A݅A݅A݅A݅A݅AݙAݙA݅A݅A݅AݙAݙAAݙAݮA33A33AQAAA
A݅AܸRAHAHAzAܸRA
=A
=AAڣA݅AۙAzAׅA(AAA33AHAՙA(A{AHA(A33Aڏ\A
=A\)AAzA33AA
AٙAGAA
=AzAQA؏\AGApAffAAA
AHAٙA(AAۅAffAܣAܣA{AQAzAAGA  AڸRA  AQA(A
A
=AAܣAHAHAܣAܸRAHAA
=A33AzAA(AۙAA
=A{A  A=qA׮ApAAffA
=AۅA  AHA\)A=qAffA33A\)A(A\)AٮA  AAأAGAԏ\AԸRA
AAA֣AffAHApAQAQA33A\)AAAڣApAffAQAٙA  A(A(A(AA(A  AAzA33ApA=qA
=A
=ApAAffA=qAA(Aޏ\AޣAAAA߅AA=qAHAGA33AQA(A\A=qA=qA33A33AAAHAA݅A
AzA
=A\)AۅAA33AAAHA{AۮA
AQAAܸRAzAAܸRA33AٮAظRAAA{A  AݮAAܸRA{AQAمApAٙAA
=AA
=AGA\)AAAGA33AzAffAAA
AGA݅AffA=qApAffA
AAAHAffAQAGA33AQAA\)AA=qA
=AffAzA޸RAHA33A߅A{A{AA߮A{ARARA
=ARA\)AQA
A{A\)A߅A߅A߅A߅AGApA߮A߮AGAHAޏ\AAA߅A
=AA
=AAݮApAAGA{AܣA33AffAQA  A
A
AzAۅAٙA(AAAGA
AڣAffA(AQAQA(AffAڣAzAffApAAGA33ApA\)A\)AAA֣AԣAA\)AA  ApAA
ApAA  A
AHApAA(AܣAAA{AffAffAffAzAޏ\A޸RA޸RA=qA߅AHA߮AffAGAQAݮA
AA݅A{AޣA{AAA  AGAA
A  AݮA\)AAGA\)AHA\)A{A(AA33A=qA߅A߅ApAߙA\)AߙA߅AA\)A\)AffA\)A{A33A33A݅AݮAܣAA\)AHAظRAAAGAޣA33A=qA{A  AffAQA=qAQA=qAGAGAՅAׅA(AQA(A(AAGAٮAQAHAAۙAAGAGA  AAQAGA{AA
=ApA\)AGAA\A
=A\AQAA=qAAA\A(AApAHA޸RA߮A߅AGAGAޣA
AffAQAAA
A=qAzA(A\)A܏\AQAܣAQAQAApApAڣAڣAۅAA{AٙAڸRAGApA\)AۙAGAڣAAA
=AAA
ApA33ApApAAA\)A  AGAۅA33AڣAڏ\AܸRAAޏ\AQAGAHAzA݅A݅A\)A݅Aڏ\A
=AAA޸RAffAHAߙAffAApA
=A=qAAA
ARA=qAᙚA
=A33A
=AHAffAAffA\AffAQAGA{AGAzA߮A{ApAApAܣA=qAڸRA=qAٙA  A{A=qAAۙA=qAffAzAڣAڣAڏ\AA=qAٮA
A
AQAzAٙAAأAיAGAAAٙAٮAٙAAAAQA
=ApAA  A(AAQA(Aڏ\AffAffAڸRA33AۙAAAffAAۮAڣApAAAffAمA
AQAAffAffAڏ\AڣAڏ\Aڏ\AڣAHA33A33AۅAAGA=qA
Aڏ\AQA\)AffAAQAAۅAGA\)AAGAGAffAA  AAffAHA
AA
=AأAHAAffAA33A  Aڏ\A33AمA(AمA(AAAA(AAffA{AمApA  A
=AQAzAڸRAAzA  AHAzA֏\A33AA33AHAأAAzA{AzA
AHAAAAA{A\)AzAAQAAAAQA  AA{AA
=A  AA  AAܸRAܸRAAۙAܸRA=qAA=qAAQA33A33A(AڸRA\)A
A
=Aڏ\Aڏ\AڸRAڣA(AڣAظRAQA\)A\)AA33AzApAمAٙAٙA33AzAAA׮A  A33AAA33AAԏ\AՙA  AQAծA  AәAҏ\AԣAGA{AԣA
AzAљA֣AQAAA{A33AԸRAAA33A=qAGA=qAAՅA(A
=A=qA  AAAffAٮAۙAAA\)AڸRAAzAAGA
=AݙAޣAޣAffAA
A
AGAA{AffA
AApAAڸRA
=A  AٙAAA
AٙAمAٙAمAمAGAGAHA
=AأAHAAأA؏\AzAׅA{A(A؏\AGAAAffApA=qA
=A33A  AA֣A֏\AָRA\)A{A  A֏\A׮A  ApAGA33AffA
AՅAأA
AظRAAA33AGAAA=qAQAӅAԣA{AәAAGAGAAHAQAՙAӮA{Aԏ\AAAAծAAzAffA
=AA=qA\)AffAԸRA=qAffAָRAA\)AzA\)AAGApAAծAՙA׮AQA(A׮AׅA=qA33A
=AAzA\)AAA  A\)A
A
=AA׮A׮A  A=qAzA
AffAҏ\A{AGAAA  AA\)AQApAA=qAA33AGA  AׅAA֏\A\)A33A
AffAGAأAGAGA\)A{AQAHAӮA
=AA֣AzAָRAAAGA=qAָRA
A33A
=A(A{AظRAAAٙA{A{A=qA
=AQAׅA
AApAָRAA(AڸRAٮAQA\)AAApAأAHAHAQAGA33ApAA؏\AٮApAAٙAApAٙAAمA\)AHAzA{AA֏\A\)A֏\ApAffA׮A  AQApAA
=A{A=qAڣAHAA\)AAՅAA33ApAApA{AQAA33A{A(A
=AظRA33AffA(A
=A33ApAۙAAQA  AA؏\AffAQA֣A
A33A33ApAAԣAA33A
=A=qA
AQA{A
=AffA{A\)A
=A  A֣AzA(AA
=Aԏ\A33ApA33AAAA=qA{A
=AمA(AAمA؏\AGAׅA33A֏\AzAAffA
A\)AָRA֏\A\)AAQA(A
AӅAAҏ\ApA=qA
=AәAA{A33AzA\)ApApAAA  A
=AA{AffA{AHA֏\A  AׅAAA׮AAָRAA{A\)A33A
=A=qA֏\AՙA
A  AAzAָRAAA33A
=A
=A
=AHA  AA
AA  A\)AHAQAAҸRAQAԏ\AffApAzA\)A
A
ApAٮAA؏\AQApAٮAGAApAAAA33AAAָRA=qA{A{A  AׅA֏\A
=AA\)ApAA  AApAңA=qAzA33AиRAϙA\)A\)A
AəAA(AAHAQAӅAHAzAzAAٙA(AQAffAڏ\AڣAڣAڏ\AQAGAAׅA\)A{AׅA
A
=AQAApAQA֏\ApA33AA׮A  A  A
AAٙAzA  AAGApAۅA=qAzA(AיA׮A׮A=qAAأAأAAA\)A\)AGAأAׅAHA
=Aԏ\AA(AԸRAAHAA(A33AAAHAЏ\Aҏ\AA(A33AffAQAffAGAϙA(AԣAՅAAGAљA
A=qAΣAәA=qAQA  AՅA{AָRA
A(AظRAAGAمApA{A\)A(AңA
=ApApA
=ApA=qAAGA\)A׮A=qAأAAHAAffAQAAHA(AأAAGAظRA
A=qAA=qA  A
=A33A\)A\)A  AzAffAڣAHAAHAمA  AٮA=qAڸRAffAHAڣA(AffA=qAffAA(A
AQA(AGAHAGAzA
A{A
A׮AAمAمAHA=qAԏ\A׮A  A\)AׅAAffAHA\)AffAA=qAA֣AzA
A
=A
=AGApAAA؏\A=qAzA֣AAԸRA֏\A׮A؏\AHA\)AAA  AQAzA(A  A(AظRAffAffAHA  A{A׮AQA=qAzAظRA؏\A׮AzApApA\)AGAGAAָRAAAAAQA(A(AAAzAծA{AAՙA(A=qA֣AָRAָRA
=A33AApAיA\)AGA\)ApAGAGAծAffA  AffApAGAzAGAAAA{AffAϮAQA
AAApApA33AAυA  A=qAҸRAA(A=qApA\)AHA֣AffAffAA33ApA{A=qAأAHAA{A{A33A=qA33AA
=AAQAffA=qAٮA  A  A=qAٙAGAAمAٮAיA=qAأAՙAffA֏\AӮA=qAHA
A(A؏\A{AGAHAHAHA33A֣AAAAA֏\A\)AzAָRAAQA(AظRA=qAQA
A
=AA33AA(AHAAA33AAA33A33A=qAAQAA(AθRAϮAAA
A(A(AӅAAffA
=AQA
A=qA
AѮA
A=qAҸRAңA
=AA33AәAԸRAAAA33A  AՙAָRAָRA=qA׮AظRA؏\AzA33AQAA33A(AffAAӅAҏ\AAffAAffAQA\)AA  Aԏ\AffAԣAAӅAԸRAffAӮAӮAӮAӅA  AҸRAAHAzAHAӮAzAAQAAzA
AՅApAAQAϙAңA
=A  A͙AHA  A33AΣA(AAffA
AzẠAAffAиRA(AzAЏ\AzA33AAzAӅAԏ\AӅAԸRAAAA{AAڣA=qAڣA
=A(AAܣAffA{AzAAAQAܸRAܣA{A  AAיAA
=AGA=qAA\)AAԣAAڏ\AAڏ\AڸRA
AQAzAمApAGA  AٮAأAApAGApA(A{AAA{AՙAԣA
AәAAA
Aҏ\AffAffA{A  AAиRA\)AGA=qAAAzA̸RA=qAәAAA
=A֏\A  AA{AAHAA{A  AA(A
=ApAԸRAԸRApApA{A{A  AA(A(A(A{A{A  A  AA{AApA  AzAծA  A=qAAԣA{AԸRAՅAAѮAԸRA\)A=qAυAQAA{AHAхAAУAQAA(AA33A
AՅAffA
A{AԣAAHA  A=qA  AHAzAffApAQAHAHA  A  AAA
A  AApAA=qAAGApAA{AGAGAΏ\A׮A
=AAA=qAңAAffAAffA
=A
=A  A{A؏\A  A{A{AA
=A33AA=qAzAAAAظRAظRAAظRA
=ApAAظRAAzAGAAԏ\ApAҏ\A{AzAиRAAAA
=AѮAffA\)AGApA{AϙA{AA33AҸRAAԏ\AA֣A=qAA\)A{AٮAHAzAA׮A؏\AծAAzAAՙAԸRAңAAAQApAҏ\AAAAҸRA\)AA
=A
=AAծAAQAAңA֏\AAԸRA
A(A؏\AأAQA{AAٮAzApA
=A
A׮AffA\)AA33AיAأAAAGA\)AQA
=AQA=qApA33AׅA33A֣AA\)AAAffA
A\)AzA{A֏\A(A
A=qA֣AAffAՙAӮA33AԣAzAQAAҏ\AA  ApA=qA(AAAGA
AffAzAzA=qAAӅAzAHAQAΣA\)AA33A=qA=qA  ApAΣAffA  AA͙A
=A  A(AиRAЏ\AυAѮA=qA  AѮAffAQAҸRAӮAA(AѮAУA33AzA=qAAAHApAAУAzAAУApA\)AAA\)AffAиRApAԸRAHA
A˙A  A͙AAAffA33AffAɮAA
=A33AʸRA\)AǙAǙAffAˮAffA(A̸RA
=AAHA̸RAA(AθRAA
=AAΏ\AAAAϙApAHAzA=qA{A=qA{A=qA(AHAzAϙAA  Aҏ\AGAHA33AׅAظRA(AA
=AffAzA{AA
=A\)AAәA33Aԏ\AѮAA=qAA{Aҏ\AA=qAУA{AθRA33AApA{ApAAѮAӮAzA
A׮AzAQA؏\AffAծAHAָRA(A{A
AHAAApAHA(Aԏ\A(A
AAAծAAGAәAzA33AzA͙AAQAApA֏\A
A{A
=A33A33AA
=A=qAAffAԣAGA33AHAffAAAffA33A
=A  A(AHAAAzA=qAAиRAAGAAHAٙAظRA
=A
AծAAAҸRA33AAGA33ApA33A
A=qAA  A(AQA33AA  AA=qA{AHAzAAApA
=AffA=qAAӅAA=qAAA(A=qAθRAϙA=qAA=qAAәAԣAѮA(A(A=qAхAAљAGA  A{AѮA
=A
ApAzA\)Aԏ\ApAA33ApAHA\)A(AAԣA\)A33A  A
=AHA
AQAׅAHA\)AffA{AԣApAҏ\AzAљA
=AУAA
AzA33AQAӮAҏ\ApA(AУAzAffA
AQA=qAAѮA{A=qAApA\)AGA\)AGApApA\)AӮAӅAA
A{AA{A  A(AԣAԸRAAAԸRAHAAAAQAzAQA\)A
=A֣A֏\AzAA33AA=qA(AAAzA(A\)AA=qA(AAAffApAԸRAzA  AA{A33A33AָRA=qA{AA  A  A{AָRAzAAA{A  A{AffAхAQAA
=A
=AAGAԣA
=AAԣAՅAAHAAAzA  AzAA=qAHAA=qAQAיA33AׅAׅAGAAAQAծAԏ\AGA\)A(AՙA֏\ApAיAzA(AGAzA33A\)AffAׅA=qA؏\A
=AHA
AظRA33AAمAمAGA
=AHAApAGAGApAՅAѮAҏ\AzAҏ\AυA\)AхAAAӅAҸRA
=AẠA
AGAAϙAGA
AљAA
AQA(AA33A  A\)AzA\)AQAGAAȏ\A=qAzA
=AAA{A
=ARAAzAAAA\)AGAAAA
ApAAApA33A{ApA33A(AAAAzA  AA
=AzA
=AQA
AGA  AAffAGA(A(A¸RAď\AŅAAŮAƏ\AAɮAAɅApAHAffA
AHA33AȸRAȏ\A  A{A{Aȏ\A
AGApA  A33A\)A=qAƏ\A=qAHA
=A33ẠA\)AȸRAȏ\A33AӅAҸRAApAAљA{AGAυAGA33AQAzAиRAAA  AffA(A
=A=qAA֣AffAΣAͮA{A{A
A  AffAAAGAAQAA=qAAҏ\A=qA33AQAԸRA{A33AQAҏ\A{AzA  AңA
A
=AхApA  A33A\)A
AиRAHAffAA̸RAA=qẠA  A\)AȀ\A  A33A(A\)A(AHA˅A̸RAͅA{A=qA\)AͅAͮAυApA
AffAffAՅAQAAHAffA(AA=qA(A=qAӮAԏ\A
A(AϙApA33A
=AAGA33ApA=qAQAAAָRAGAԣAQAzA\)ApA(A
A=qA  A=qAHA
ApA׮AHAHA{A  AffA(AծAAAծA
AՙAAՙAՙApAA=qA(AGApAHAAAAՅAңA  A  AzAAѮAHAиRA\)AӮAҏ\A\)AУAЏ\AA(A{AA=qA
AAAУA(AQAffA  AzAхAA(AΏ\AHApA(AGA
=AθRAθRA=qAHAGAAzAԸRA33A\)AzA33A{AGAAffAڏ\AAQA܏\A\)AAA
AA
=AzApA33AzAٙA  A=qAA  A{A
AAffA
=AAQAQA  A(A{A{A{A{A
AٮA
AٮAGAGA\)AHAHAظRA(AA
=A֣AA33AzAQAGAA
=AAәA
=AAQAffAHAҏ\AA
=A
A
=AAQApAffA  ApAAAAՙA\)AHAA33AծA  AA
A(AծAәAAҸRAәAzAAԏ\AHA33AGAGApAծA{AHAAA33A33AAԸRAHAAӅAԸRAԸRAA33AՙAA\)AAׅAAzAAA\)AGAGAָRA(AHAA=qAffA֏\A֏\AAAHAAԏ\AGAzA
AϙAңAӮApAA\)A=qA\)AGAzAAAzAffA\)AApA
AGAGAHApAGA
=AGAQA=qAAҸRA=qAzA  AffA33AӅA
=A
=A=qAՙAGAAAffAffAHAGA  A֣AיA(A=qA
=ApAۅA(AAمA(A=qA
=AHAQA(AAAٙAمApAٙAGAAٙAAٮAA؏\A؏\AAA33AA
AمAQA(A  AңAՙAA  AzAffAӮAAәAzAAAzA
A
AffAЏ\AHAQA33AGA=qAffApAԏ\AA\)AA{AAәAԸRAA
AApA֣AHA(A\)AzApAAAЏ\AAA{ApA=qAәAՙA  ApAAәA=qAAQAzAApAQA֏\A
=A\)A׮A  AffAظRAAAHA33AGAAظRAHAHAHA
=A33AظRAAA؏\A  AAA׮AffApAڣAAٮAڏ\AڸRAA=qAGA\)AمAHA
=AAzAٙA33AQA{AGA\)AңAҸRAԣAңA=qAQAѮAAәA
AGAԣAAAңAAAAA\)A
AҸRAApAϮA{A33A
AA
=ApA
A33A
=ApA{AAAٙA(AAAAffAGAHAAQA
AԸRAԣA{AQAGA
=A
A=qAApApA  A33A33AQA{AAՙA\)AծA
=AAQAԣAAծAQA(A(AffA{A(AAAծApAA33AѮA=qA\)AGAӅAQAAHA  AՅA\)AA  AAGA33AA  A{A{AA{AHAҸRAңAAծAAGAAԣA{AAA
=AAҏ\AAA{A(AӅAңAA
=A{AAԏ\AԸRA
A33AՅA{AA\)ApAQAיA  A{A{A(AׅA\)AHAffAAՙAՅAԸRAGAAAQAAQA{Aԏ\AzA\)AGAԣA33A
=A33AAAңAҏ\AѮAGAծAѮAApAzAӮA33AzA
AңAHAAAQA{ApAҸRAzAָRA  A
A\)AA33AхAңAQAA=qA
AAѮAA{A
=AңAAAAHAffAиRAQAGAԏ\A(AAӅAңAAѮA  A\)AхAApA33AӮAzAGA
=AffAA=qAHA\)A{AffAAAԸRA
AGApAGA=qA
=A=qApAGAծAzA֏\A33A33A
=AzAQA
=AA{A  AzApAAA
AՅAHA{AAAAхA{A֏\A֏\A{ApA֏\A֣AGAיAָRAAA{AGAzAApAQAAԸRA  AA\)A33AңA=qAA  A\)A
=AAGAЏ\AzAQA33A33A(AA̸RA\)AQAHApAAApAQAA33AӮAffA{AQA  AԣApAQAAՙAיAffA\)A33AظRAzAQAأAأA(AיA(A
AمAظRAAθRA(AЏ\A
AA33A33AQA
A
AҸRAffA\)A=qA
A  AHAAQAHA
A
AAҏ\A
=A(AңAHAӮAA33A\)AffAAAЏ\A{AGA
A\)A
AffA
=AAQAffAAՙAӅAQA
Aҏ\AԸRA\)A  AffApA
=AAAѮAGAHAAԸRA{AA=qAΏ\AAGA(ApA(AҸRA\)A(AzAAzA  A˅AAʸRAʸRA{AAAAǅAǅAȸRAәA\)A  AzApAffAHAHAǙA\)AffA\)A˅A\)AͅA(A
=A
=A33AAA\)A{AAffAͅApA͙A
AQA˅A33AʣApA{A{A{A{AAȣA
A33Aȏ\AzA(AAǅAAHA33AƏ\ApA33AAHAȸRAɅAGAA\)A{AǮA
A(AAffAzAzAͅA
=A
=AGAA  Ȁ\Ȁ\AA\)A\)A
AΣAGApAA˙AzAHAΣA͙A
=AffA  AʸRAffA\)A  AzAHApAAHApAȏ\AA
Aʏ\A˅A˙AʣAʸRA\)AzAΏ\AAУAA(A\)A
=AGAΣAA  A\)A=qAAϮAGAAQApAAffA͙AΏ\A
ẠAˮAͮA
=A
A(AA33A=qAϙAϮAAθRAzA
=A=qAHA͙AAffA33AҸRAAzAGAQAAQA\)AAAA
=A׮AAׅAظRAׅAיA{A{A
A  AAظRAׅAffAA\)AHAָRAA(AיAGA  AA=qAAAGApAәAAzAAA  AѮApA  ApAУA33A=qAʣApAzAA  AAQAGA
A{A=qA(AA£A\AAAAAAHAzAAAffAAAAzA\)AHAA33AAAApA\)AzAAQAAzA
=A\A
AAAzAA£AAA(A(A£A  AAA=qAAApAƏ\AAAAzA\)AffAəA(A\)AA£AA\)AAAʣA\)ApAHAϙA̸RAQA˙AHAʏ\A33AffA
=A{A=qA=qAGA
AA=qAAȣA33A
A=qAffAHAAAAǙAʣA(AHA33AAHA
=A=qA£A33A
=A\)AA  AAQApAHAA\AQAQAA33ApA{A\)AAŮA\)A\)A(A
=AƣAHAHAĸRAffAģAAAAď\AAzA  AGA
=AAA¸RA  AîAGARAAHA
=AGAÙA\)AGAʏ\A=qAffAA{ApAȣApAAAHA
AffAAȀ\A{A\)AυAGAGAA33A\)AAffAɮA(AɅA{AȣA\)A=qA=qAAȏ\AƣAAHA(A\)A(AQAzAÅAAřA  A\)AA
=AffAzAĸRAAĸRApAřAǅA{A\)AHAǮApAƣA=qA  AAģA(A=qA{AQA33AHA
A=qAA
=A
AAĸRAď\AAAffAQAƣAAAƣAzA{A(A=qAGAAŮAzA(AffAHA\)AQAA{A
AffA
AA=qAA\)A33A\)A(AAA¸RAÅAHAĸRA  Aď\AAAƣAzAAď\AffA33A(AģAHAAA{AGA33A
AQAȏ\AzAA33AA(AAîAAA\)AffAAAAAA{A\)AffAAȏ\A(AzAA\)AʣA(Aʏ\Aʏ\AAA(ẠA33AͮA\)AA{A{Aď\ApAA{A{AAHAŮAřAzARA\A(ARAffA{A  AApAʸRA
A
AУApẠA(AGAA
=ApA\)A  A  A\)AυAHAAΣAAA{AzAA͙AϙAGAA
=A  AffA33A=qAAzAGAA
A  ApAAƣAA=qAA\)A{AəAHAA
=A=qAƏ\A
=AAQA=qA  A(A  A\)ApA\)AŮAŮAǅAGA  A˙A{A{A{AffAzAGAGAA\)A33AAθRA33AǮAƸRA  A=qAƸRAA\)A33AAAAGA(A33AиRApAΣA=qAAA  A=qAzA=qA
AΣAffAљAHAA{A=qAA\)A=qAAQAzAGA
=AQAθRA\)AAθRAffAͮA
AAʣAȣAGA
A(AHAAzAHA
=A\)A=qAңAAQA˙AGA\)A
=AʣA  AffApAŮAA  AǙAGAffAffAȏ\A
=AGApA
AʣAA˙A˙A33AAApAQA(A̸RAAυAθRAΏ\AA  A
AA33A\)AθRAffApAHAHAHAAAffAffAA33AA
=AθRAGAθRAΣAΏ\AͅA33AͅAffAQA
A
=AHApAffAʏ\A=qAʸRAHAQAʸRAˮA  A=qAA  A
A
=AGA˙A
=AA33A{AQA=qA
=AʣAɅA\)AAʣẠAApA(AͮA{A
=A{A=qAAA=qA
=ApApApAA  A=qAzAΏ\AA
=AAGAυApAAAA  A
AϮẠAAAzA  AAA(AAAљA
AAAУA{AffAӅAAҸRA(AffA˅A33A(AA(A  A͙A{A
=A=qA
Aʏ\AʸRApAA33AA
=AHA{A˅AˮA
AA33ApA
A͙AΏ\AzA33A  A\)AљA
=A˅A
AHA  A
A(AGAQȀ\A=qAʸRAAffAͅAΏ\AΏ\AHAHA33A
A̸RAAffAzA͙A\)AљAHAͮA=qAApApAЏ\AAGAAQAzAffApA͙AffA
=A̸RA(AAA̸RAzA̸RA\)A=qA(A(AAǙAɮAGAʸRAHApAzA  AQA=qAAQA(AȸRAA{AGA
AʸRȀ\A\)A(A
=AffA
AGA\)AAQA\)A(A\)AAAȏ\AȣA
=AA\)AHA33AAA=qA  AffȀ\A{AffAffAˮAApA
AAQAA{AQAzA\)A˅A33Aʏ\AɅA=qA
A  AApAɅAAʣAA{AˮAAɅAffA\)AͅAΣA=qAAAAA  Aʏ\AffA33AA  AͅApA=qAQAGAffAɮAȣAQAHA{AɮAHAǮAǙAHA33AGAȸRAǙA33AGAǅA=qAAA
AQA
=A͙A\)AAAQAɅAʣAɅAAʣAGAˮA̸RAAͅAA  A
=AApAA=qAͅAAffAHA33A͙AΏ\A͙ẠAA
=AHAAffAA(A{A\)AəAAΏ\A\)A\)AQAGAAA\)A
A=qAzAԣA
Aԏ\AԣA
AAңAҏ\A=qAzA\)A=qAHAHAA\)A(A{A33AA33AA33AϮAAΏ\AθRA\)AθRA\)AA
=AHAzAљA\)AffAљA
A\)A\)AQAffAffAAAңAffAzAиRAA  AQAQAAAzAЏ\AθRAϮAϮA=qAЏ\AУAQAυAͅAAHAA
=AхAGA
=AffAAHAҏ\AApA
=AAGAAҸRAffAԣAffAAӮA{A  AЏ\AѮA  AѮAA(AхAAAҏ\AGAA\)AAAҏ\AAхA  AffApAхA  A=qAυAхAAѮAЏ\A=qAffAA\)AQA=qAΏ\AzAΏ\ApAϮApA{AApA=qAAҸRA  A{AA
AA=qAGAA  AӅAԣAQApA{AA=qAzA33AAͅA  AAHApAQA
AzAHA(AHA
=AAAzAQAA=qAAffA33A(A\)AAA\)AAA\)AHAAAԏ\AApAffAAQAA{AӮA
AAҸRA{A
A
AхAхA33AGA
=AAAHA
AAҸRAҏ\AQAУAAϮAzA=qAApAA(AͮAzA33A
=A{AA  A
AAҸRA
=AHAAҏ\AAGApAAӮAzAхA\)A  A\)A=qAУA(AQA=qAљA=qAAљAHA
AHAffAAA33AA=qA{A=qAָRAQAzAָRA
=A\)AGA
=AA׮ApA֣A(A(A(A=qA(A  AծAA
AՙAAAAHA
AffAHApApAHA
A  A\)A(AQAAԏ\AՙAAzA=qA{ApAAApA{A
=AՙA(ApAGAAA  AԸRAHAQAAӅA33A
=A{AAHAffAQAѮAҏ\AQA
AѮA(AA  AңAHApAAA(AffAQAQA{A(AәAA33AGApAAA=qAHA
=AՅA
A\)AծA  A  AffA֣A
=AיA׮A\)AأAHAAQA(A
AQAָRAׅA
A׮A(AffAzA؏\AظRAAAAAAأAffAA֣AQA(A֏\AffA
AՙAQAAAAңAӅA
A=qAAffAԏ\Aԏ\A33A33AA{AHA33ApAՅA
A{AQA֣AAA33A=qAՙA{AԸRAAQA{AAԣAffA=qAҸRA(ApAӅAQA33A33A
AQAffAzAzAHAHAA33A
=A=qA(A׮AAAAׅAffA(A=qAٮAָRA
AGAՅA{AHAָRA
AHAԸRA{AՅAGA33A{AA
A=qA  A׮AיAׅAיA׮AA׮A\)ApAAGA33A֣AՅAхAAAGA׮AAAQA33AظRA(A؏\AHAظRAHAAApA  AHAzA
AA{A(AظRA33AQA{AأA  AHA=qAApA
=AHAԸRAA33A
=A֣AA
=A33A׮AQAQA=qA
AHAمA
=AQAQA
A
AיApAׅAAיAׅAAffAffA=qAffAA(AυA=qA\)AApAAHAAffAљApAffAAѮA
=AAffAυAApA33AϮA(AΏ\A\)AA\)AθRApAAυA(A  AˮAΣAzA  AffAA˙AʸRAHAApA  A̸RAApAˮAHA33A˅A˅A
AA
AˮApA\)A  A˙A\)A\)A\)A  A(A
A=qAQAffAA  AA
A=qAУAУAЏ\A(A\)AHAθRAΣAzA  A̸RAAHAAˮAzA{A
=A=qAAAAәAҏ\A33AӅAHAA33AԣA
=A  AҸRA33ApAљAQAAA  A  AAAϮAȣApAAǅA\)A
AGA
AA(A  AͮAA\)AAˮA  AΣA{AHA
ApAA̸RA
=AυA=qAљApAΏ\A33A{AffA˅A=qAffA33AA\)AzAQApAǙAGAʏ\AAӅAGAffA
=AѮAAQA  AAȸRA{AȣA(A
A
ApAAHAʸRAʣAˮAΏ\A\)AGA\)A
=AApAQAAQAљAҸRA=qA  ApA{AиRAHAA{A\)AAʣAAA  A
A33A(AAAÅAffApAAǮA(A(AGAA\)AĸRAHAģA  AffA
=A=qAȏ\AGAəẠAAʣA=qAŅAA  AA\)A£A  A(AŮA{AGA
AAAǮAǅAA
A33AA33A
=AAQAɮAHAA
A=qAHAAGAͮAAHAQA33AzAA
=A{AAẠA\)AHApA
=Aʏ\Aʏ\AQAQA̸RAA͙AzAAAHAУAAA=qA=qA(AAˮA\)AffA=qAGAΣA{A  ẠAˮAAA33AAʸRAHAAA(AAQAAQA=qAGAGA\)AHAAЏ\AAzAȀ\A33AͮAffAΣA  AΣAAAAA33AΣAA(AGAУAAΣA  A
A{AͮA\)AͅA(A
AAAͅAA̸RA\)A=qAȣAǙAǙAApApA  AGA˅Aʏ\AGAQA˅AGA  ApAAθRAУAGA  A
AУAAHAAѮA\)AAљAAHA{A=qA33AЏ\AAA(AGAθRAхA
=AzAQAA=qA  ẠAGAA33A\)A(A=qAΏ\A{AHAͮAˮAA\)A  A{AAAHAΣAHA=qApAAхA(A33A  AGAΏ\AͮA͙AͅAHA(AĸRAAřAŮA
AǮAQAAəAQA
ApAȸRAA33AA33A  AA  A\)Aʏ\AɮA̸RAAzA=qAGA
AffA{AAͅAAθRAQAAAffAЏ\A
AApA(Aʏ\AɅAɅA=qAffAGAAHA=qA\)AffApAzA
A=qAʸRAAHAˮAHAA  A33A{AA
=Aʏ\AGAAzA
AAиRAУAΏ\A\)AGAAͅAAͅAϙA
=A=qAGAzAA˅AffAA˙AAGAQA
Aʏ\AA\)AA  A
AAA  A=qAͅAApAЏ\AA33A
=AңAхA  AHAffA(A(AAGAA
AAHA(AϮAQAхAхAAGAљAAzAffA\)AңA
AA
=AθRAA=qApAAA{AθRAQAϙA=qAљApA  ApAAGApA33AQAAȸRAAffA͙AHAAQAAΣAʏ\AȀ\AAffA(A\)A˙A{AGAAʏ\A˅AA  AA\)AA\)AzAA
AffAzAׅAA33A33AQA33AzApA
AӅApAA(AHAAAAA\)A(AָRA\)AAָRAAQAԸRApA
=A  A=qA\)AծAծAՙApA\)ApA33AGAA(A{A
ApAHA{AA{AAzA33AA
A33AAAA
A{AиRA=qAAУAffAȀ\A
=A˙A33AffA{A\)AffAGA{A
=AѮAҸRAAΏ\AAHA
AAffAϙA33AA=qAA{A
AҸRAA
=A
AAҸRA(A(AzAAҸRAzAzAңAffA{A  AA
AϮAϙAAиRAиRAυA(A˙AQAAəA
Ȁ\A=qAzAΏ\ApAzAȣẠA˙AAθRA(AAA{A
=A
Aʏ\A=qAʏ\AHAzA
AȣA33AHAAffA33AɅAzAAA\)AAƸRAAˮAAAzA=qAA=qAĸRAĸRAŅApAHAÙAîAģAA\)A  AA33AǅAGA33AǙAffAƸRAAǅAA\)A{AzApAƣA
Aȏ\AAQAGA  A(AzAʸRAAAȸRAA33A
A  AffA\)AffA  AQAA(AƸRAȏ\A
A(AffA(A\)A(A  AAAˮA̸RAGAA
AAƸRAƣAQAA
AƣA33A(A\)A\)AAʣA33AɅA
=A
=AAȣAzAƸRA(AƏ\AƸRA\)A{AA{AzAffApAȸRA(AAAAffAA  AAzAǙAAAQAAAǅAA{A
AA(A\)AəAQAɅAȣA\)AƸRA33AA(A
=A{AÅAď\A\)A=qAQAǅA
AzAAĸRAAɅA  A
=AǮA
AzAAzApAGA
AApA=qAApAřAffA
AǅAAƣA33AŮA\)ApAQAģAÙAffAApA\AAQA{A33AGA{AAAzAffAGAAAffA  A(ApAÅA\)AƣAzA  ARA=qAÙA  A=qA
=AQAAHApA\)AA(AffAQAƣA33AƣAǅAǙA{AǮA(A=qAȣAzAȣA(AA
=AzAA33A=qAǙA33AAAƣAzAAAffAQA\)A\)ApA\)A33AA33Aȏ\AffA
=A33A
=AQAȏ\AAɅAA
A  A˙AʣAɮAGA=qA{Aď\AĸRAAQAffAHA=qApAffAģA  AzAzAA\)AGApApAÅA\)A=qAffAffA¸RAA33AA33A33AGA\)AGAGAGAÙAAAÅA
=A£AA=qA\)AAAA33A33AA
A
AAHARA
=ApA
=A=qAAģAQAď\AA
=AAĸRAA  AHA
=AffAA\)AQA  AAA{AzA\)AAGA
ApAzA
ARA{AAA(AîAHA\)AÙA\)AA  A
AARA=qARAAAAA{A(AA(AffA{AA\AHA  A  AAAAQA33A{AAzAAA
A(AAzA
=AAARAAQAAA
AAzAzA\AGAAffA\)AAA(AAAAA  AAAQA
AApAA33ApA  ARAA  AA  AÅAÅAHARA  AffApAAAHAA
=A(A{AQA{A  AffA33A
=AA{A33AQAGAQA  A\A=qAARAGA(ApARAA{AA\)A33A  A{ARAGAffAffAAQA33AA
=A33ApAA  A{A{AQARAARA\AffA{AA\AA{AffA(A(A{AGAAAAA\)AzARApA=qA\AA{A=qAzAQAQA\)AAA(AAffAA\)AHA  AAA  AzAAAQApAzA
=AzAffA¸RAzA
AA(AzA(AAAHAA(AAA\A33A=qAAAAA33A\)AQA  AA{A  AffAGA=qAA
A  AAQAA
=AA\)A  AzA
=ARAA  A
A  AffARARAzAzA=qAAAzAffA=qAzAffAffA\)A{AAA33AA£A
A¸RAAAHA\A(AApAA{AGAGAGARAAffA\AHA\AHAA
A
=Aď\AÙAGA\)AzA{AffAffA\AAîAAģAAģAHAAģA(A=qAffAĸRA  A
A  A=qA=qAffAAAffAzA\)A{AAAƏ\AA(AȸRA
=AA  AAGA
=ApAzAHApAˮAAAAAHAzAAAA(A
A
A
AɮAzAQAA
=AȸRAAȣA  AAA{A{AQAAˮA˅AffA=qA  AzAGAəAApA  A\)Aʏ\A\)A˙ApAA˙AzAȏ\AHA33A  AAA\)ApAffAQAƸRApAffA=qAHAQAffAAǮApAQA(AǮAǮA
A  A33AAŮA\)AAQA\)AȸRAA
=AAAʏ\A=qAəAʸRAA
AẠA̸RA
Ȁ\A(A=qẠA(AQA˅A˙A  AˮAAAAʏ\AffAzAʏ\Aʏ\AzAʸRAʸRAAA33AzAʣAzA=qA(AʸRAGA
AɅAȸRAAǙẠȀ\A(A  A\)AHAŮA=qA{A
AAQAʣAƣAAȣAɅAȸRA\)AɮA
ApA\)AəAGApApA\)AGAəAȸRAA
=AAAAȸRAAApA  AffAA33A
=AA
Ȁ\AHAϮAAA=qAzAGA(AA  AffA͙AAA  AAͅẠAAQAAͅȀ\AAA˅AzApA\)A˅AGA{AffA{AzAʣAQAAffA{AGA
AA  Aʏ\AʣA\)AGAGA{AzẠAffA  A˙AzȀ\ApAɮAQA(AQAGAQA
A{AŅA\)AǙA(AGAffAA=qAGAƏ\ApA
AĸRAŅA
AffAApAƏ\AApA\)A(AȣAffA\)AǙAAǙA(A
A  AƣAǅAGAzAAA  AzAŅAA\)A¸RA¸RAzA  AApAƣA  AQAzA\)AǅA33AAǮAGAGA
A
=A33AzAȏ\A{AGAA(Aʏ\A{AGAɮA\)A=qA=qA33A
AǮAzA\)A{ApAřAHAffAHAîAÙA(A
AƸRA
A
AQA
AɅA\)AAQAQAŅA\)A{A(A\)ApAAA=qA\)AˮA33AAAGA
=A
AřA\)AAzA(A{AAA  A
AģA
A
=A£A£AGApA
=AAffAQAAĸRAHAģAA33AAHAHAAQAApA33A
AîAA
=ApAAAA(AA33AÅAA{AQA=qAA{AAQAĸRA=qA33AHAîAÙAHAA  A{AA=qAzApAHAHA
=AA=qA{ARAAGAzAA\)AzAAApAAGApAffAAAAQAzARA\AzAď\AA=qA\)ApA  A(A{A(AA£A¸RA(ApA(AzAA
=A{A
A
AƏ\AƸRA
=AAA
=AGAA
=AAAzA  A  AAHA33A
=A(AA¸RA=qAA(A{A\)AAAǅA
A(AƏ\AǙAAGA=qAAzAAA\)A(AGAA  A  AîA33AģAÙAffA(AAA33AĸRAA(AffAģA(AQAA  A
ARA  AÙAÙA
A(A{AAAÅApAffAffA  AAAAARAHARA=qAĸRAŅAřA  A
A{A  AŮAA\)A(AA
AAAˮAA{A{ApAɮA=qApAAA̸RẠAGAəA(AzA̸RAʏ\ApAǮAAQA
=ApAɅAʸRAGAQAAȏ\AȣA
A
=A  AAAAffA33AΏ\AAA
=AAzA(AAAA  A(AǅA\)Aď\AŮA
AA
=AǙAAȏ\AApAQAA33AzAGA33ApAHApAAAď\A(AzA(A33AA
AA{AffA
=AAA
=AA{A=qA  AȀ\AQApAAzAHA=qA  AAA˅AAQA̸RAA̸RAA
=AffAHAA{AA33AʸRAʣAA(AHAɮAffA\)AA͙A\)A\)A\)AAƏ\AĸRAQAHAA=qAGA33A
=AɅA\)A33AÙAAHA\)A͙AAAA\)A\)AzAffA
=A
A\)AA=qA
=Aȏ\A˙A(A(AAffAɮAAəA
AffAəAƣA33AǮA
AA
AAHA33AGA˅AˮA
A(A=qAA
A
A\)A˅A33AAA=qAA
AHAAȀ\AẠAzAA  A33A=qA  AAffAAϮA{ApAɮAAzA
=AA  A\)AŮAģAAƸRA{A  AAȏ\AǅAŅAApA=qA{AǮA{AzAGA(AffA̸RA
=A
=AGẠAHAAƏ\AffAQAQAzA{AɮAȣAřAQA
=AAA=qA\)AAffA{A=qA=qAGA
A¸RA33A\)AǅAȏ\AGApA{AəAHA(A{A{AAAAɮApAApA\)A  AAGAAAffA33A=qẠApA{AzAAAA˙A
=AA
=ApAAAffAHAẠẠȀ\A(ApA˙A33AȣAʣA  AAA33A˅AAA͙AʣAAzAȏ\AHAHA˙AǙAAffA(AƏ\Aȏ\A33AAȣAA=qAȏ\AA=qA
=AGA(AzA
AAQAAəA
A
=A=qA=qA(Aȏ\A  A=qA{Aȏ\Aȏ\AȸRApAQAAAHA\)AHA{AffApAGApAˮAˮA{A  AQAQAǮAǮAffA\)AǅAAA33AAȣAGAQA33AffA{A
AAˮA˙A(AǮAAQA
=A33AƸRA
=AƸRAAGAAA  A
AəAGAzA(AQAƏ\AQA\)A=qAď\AÅA=qA\)A\)A33AģAzAQAffAƣAŮA  AAAGAřApAƸRA33A(AÙAA\AzA¸RAA¸RAQA
AA
=AAAGA
A\)AHAA\)AGA{AA  A
AApAzA{ARA  AA(A{A\)A
A\)AA33AA=qA(A\)AA{AQAHA33AřA33A
A
ApAApAA\)AAAA=qA
A(A
AffAzAffAAA\A=qA{AffA{A
=AAAzA\)AÅAģAřAď\AARA
=AApA
A(AAA(AzAGAQA\)AGAA=qAA(A(AAAA{AAAAffA=qA33A\AAA33AAAAGAAA(AAGARA  AQAAARA\AHAAA33AAAAzAA=qApA
=AQA\AGA
=ARA\)A  A(AA33A{AAA  AA
AAApAA
=AAA{ARA{A\)ApAA
=AAGAA33AA\A\)A=qAAHAAAzAA=qAQAA\)A33A\)A(AA33AQAA
AA\)AA
A(A\A\AAAAA33A  A(AffAHAA\A\)AffAGA
A(A\)A
=AA33ARAAA{AQAA\A33AAAQAAA£AffAQAîA\A
A  A£A(AQAAzAAAffA  A{AAAAffAA\)AzApA¸RA{AffAGAAA\AAAQAGA
=AHAA£A£AAQAƣAģAA(AģAA(AŮAAffAƏ\A=qApAƣAƏ\A33AǅAǙAǮA
A
AȸRAffA=qA
=A
A=qAȸRAȏ\AQAffA=qAȸRAA33AȸRAGApAAHAəAAǅAAGAzAǅAǙAŮAA  AGAȏ\A(A=qA
=AHAģAAHAŅA(A
A(AzAffA{AA33A=qAAAAHAA¸RARA
AGA  AQA=qAQA\)AHA=qAA33AQA{A=qApAəAŮAAď\AGApAAA=qAAAAA
A\AA
=AGAîAA{ApAffAÙAAAGAffA£AQAA
A{AAffA\)AÙAAŅA  A
AƸRA{AzAAzA  AffAQAffAƏ\A{AƣAHAffAƸRA
AǅAGAHAHAAHAA
A¸RA{AGA\)AÅA
ApA£A¸RAffA¸RAA
=A
=AAA33ApAAHA{A
AŅAA\A{A  A¸RA¸RAAģA\)AffAîA
A=qAď\AzAď\AHA\)AŮAQAƸRAAǙA
=A  A(AQAHAApA33AAzAGApAʣA=qA{A  AȸRA
=AǙApAƣA
=AzAAQApAAɮAʏ\AAʸRAffAffAffA{AɮAA(AAɅAȣAȏ\AGAǮA
A  A  A\)AAĸRAAĸRAQAÅA
A{A  A{A(AHAƣAHA\)A
=AA{A{A\)AAAǮAŮA33A  A\)AAȣAGA{AɅAAGA33AǮAApAAƏ\AA{A  A\)AHAQAffAffAîAzAŅAA
=AA  A  AƸRAǅA(Aȏ\AȣAzAzAȸRA  A(A=qA
=A\)AAzAAHAffAGAʏ\A(AA˙A˅AzA{A  A=qAAͅAzAAʸRA(AA  AAʏ\A(AAȣAʏ\AAɮAApAAAHAA  AzA{AffA{AǙAGAƸRAffAffA
=AffAƏ\AffA
AƣAƏ\A(AzA
A\)AAAʣA(AzAzAʣAffAəAAzA\)AȣAǮAffAA\)A\)A  A33AģA(AGA{AAɅAɅA33A\)A
=AHAȣAȏ\AAAHAA
=A  A
AǮAA
=AHAɅAA
=A(AffAGAAʣA(A
A=qAA  AzAffAQAAAɮApA  AɮAAHAəA=qA˅AffA
AzAQA
=AAffA  AGAHA  AƣAƸRA  AAď\AffAAHA{AGA=qAAAffAA\)ApA33AƏ\AAŅAŅAÅAHAÙA
ApAAAGAîA{Aď\AAAģAA
=AHAHAA33AŮAAŅAGAŮA{AƣA(AffAƏ\AƣAŮA
=AAǮAŮAəAɮA
=AAʸRApAffA
=AffA
=AģA¸RAHAĸRAffAzAAffAǅAAAGAAGAǮAǅAƣA\)AǮAzAHA
=ApAHAAzA(AAQAffA{A\)AřA33A(A\A
=AA=qAA\)AffA
=A(AîAQA{AA
=AHAĸRAAA=qAGA
=AA  A33A
AQAHA33AA{AƣAƣA{AGAřAffAQAAȏ\AǅAHA
=AGA33AHA\)AGAGAɮAʏ\AɮA  A{ApAQA=qA{AAffAA{AȣAAɅAzAʏ\ApAffAAǮA  AAʏ\AffAɮAɅAA
A\)Aȏ\AA(A=qAQAģAQA=qAAHAA{AǙAAʸRAHAʏ\AAGAGA  A=qAApAQA
=A  AģAʣAffAƏ\AAƸRAǙAAHAHA{AAƏ\AQAŅAQAƏ\AƣAzA(A33AHAAffAQA\)A{A(AAQAřA\)AQA{A  A
AŮAģAA(AGAď\A=qAîAApAQAAAA
ApA{A33A
=AAQAəAȣA=qA  AřAÅA(A(AAzA33A=qAA
A(A=qAģAģAAŅApA  AAGAAGAģA\)AQA
=AA\AAƏ\AƸRAGAÅA
AQA\)AHA{A  A=qA¸RAAzAAȸRAQA
AA  A=qAǅAAŮApAŮAGAGAQAzAffA(A(A{A(AffA  AA(AA\)A{AGAAQA{A{AffA=qA33A=qAřAřA{ApA  AȣAAȣAffAȣAHAAzAAffAǅAHA
=A33AApAA
=AzAƏ\ApAHA
=AAŮA\)AŅA
AA=qAQA  A(AQAQA=qAQAffA  A=qAzAA=qAHAGAAApApA(AA  A33A{A33A
A(A(AzA{AQA\A\AffAA\)A=qAAď\A{AGAffAHAGAGAřAŮA\)AŮApAAřA\)A\)A\)AA\)AGAǅA
=A
=AGAǅAA
A\)AǮA
=A{A\AȸRAAQAȣAȸRAA\)A(A33Aď\AA
AƏ\AffA
A=qA\)A
AAAA
=AŅA\)AAď\AAAď\AAǙAA
A33AHAA\)A¸RApA  A£Aď\AAA{ApAÅAAď\A{ApA\)AHAĸRAApA=qAffAzA{A=qAffAzAQAQAÙAAA33A
=AffA\)AHAʸRAQAffAA{AAzA{AɅAffAzAʏ\A{A\)A
=A\)Aȏ\Aȏ\AGAAɅAȸRAřAHAQA  AƣA\)A{A{AAɅAɮAȏ\AzA
A{A£AŮA\)AzAǮA\)A=qAAȸRAA(AApA{A
=A  AGAA
=AəA\)Aʏ\AǮAAɅAAA
=AzA{AəAʣAAʣAɮAA
=A\A\AAîAAffA\)AHAAffA£A\A
=A{AAzA
=A
=A
A
AzAAzA(AQAffA
=A(A  AA{A\A\AApA{A
AA\)A(AAA{A\AffAAAřAģAģA
=A{AƣA\)AHA  A
A=qAAAQARA(AA(ARAA\)AGA
=A\)AAA\)A\)AA33AA\)A33AffA33A\)A33AA=qA(A  AA
=A
AAzAAGAffAzA  A\)A\AzAA\)AAA
A{ApAAAzA  AARAAGAffAAAffAffAA\AA(A
AA\)AGAAQA  AA  AffAzA(A33AA\)A
AQA
=A(AGAffA  AffA\A\)AA\)ApA\)AAAzAAA33A  A\)A\)AQA33AA{A
=ARAA
=AAAAAA(A
=A=qARAQA
=A33ApA\AAGA(AffAHA\AAAA\ARA(A
A\AARAA
AA(AAAA  AAHAzAAzAAAAQA£AA
=ApAffAǮApApAǙAzA  AřA\)AAGAAAHAAAQA  AÅA£AA\AAHA\AGA¸RAAîAÅAÅA£A\)A
AzAÅAAQAAQA\)A£A
=A  AA{AAAAAAAA  AA\A33A{AAHAzAHA=qAA\A
=ApAAzAffAHA{AA(A
=AAď\AGAŮA=qAAǮA(AffAA33A\)AGAAGAA\)AƣA(AŮAAĸRAŅA=qAƣAAzApAAAGAAģA\)A
A
AǮAǙAGApAǅAǙAAzA  AřAAAŅAGAffAQA=qA
A\)AřA\)A
A\)AA=qAîAGA  A
AîA33A\AîAAď\A=qApA  AŅA33A\)AřA=qAÅA
=AA33A{AApA\)A(AA
=ARA(ARA\AA-GA8zAA8(A  @AG@A1GA#A%A
GARA\)AHA,QAo
=A}GAbHARAA\AS\)AdArRAA\)AHA=qAA{AAAQAffA  A=qA=qA\A
A  A=qAAAQAA\AARAHAA33AA(A(AffA
A\)AA{ApAzA(AAHA
=A
A\A(AffARAAAApA(AA(AzA(A{A
A\)ApAAzAQAARA  AAffAARAA=qAA(AA
=A{Aʏ\Aʏ\AƣApApA\)AffA(AәAA  A{A\)AͅA  A  A(AGAQAA
A=qAA  AGAA33AAzAAffAΏ\A\)BffBQAAQAAB zBB  B{BffB  AHAAARAApA  A
AܣA
A=qA  AffAAA
AHAA{AAzA  AHAffAGAڸRA
=A33AHAA\)AAffAřApA\)AzAA\)AGAGAҏ\A{AQAܣAzAA33AffA33A=qA  AHAQA{A߅A\)A{AA\)AQA(A(AAQAAA(AA33AA
=A33AAA{AڣAٮA=qA\ApA(A  A=qARAzAQAQB 
=A\)AڣAffAAAAA\)AQA\)AA
AڸRA(AGAAAAzA
=AffApAA
AAA{A{AQAA33AAAAAיA
A(AAGAA=qAGAǙAΏ\AQẠA=qAיAAApAA
AAAA(A\A܏\AՙA{AA
=A{ARA
=A{AAQA=qA(AAApA
A{AA=qAA\)A(A33AAzA
=A
A33AffAzAQAHAȏ\AθRAA{A(AљA  A
=A˙A
=A\AQA(ApAA\AA\AAGAģAAAGA  AA(A33AAƸRApA
A
AǮA  A
AɅA
AzA{A\A
=A(A{A\)AARA
=A33A(A{A\)A\)AQAAîAAAȏ\A
AA
=AGAAAHAA33AAA33A\)A33AQApAQA{A\A{A
AQA{AGAffAٙAA\)AGA֏\A33AHA\)AAAAHA=qA{A  AGA33ARAAA\)AAffAffA  AffAָRAffAHA(A
AAݙAAŅA
A33AQAA{AGA\)AAAAAAřAApAffAQAӅA=qAHAzAңA؏\AΏ\A噚AA  AAӅAA  AAݮA33AݮA(A(A(AA
=A{A݅A݅AܣAۙAAA=qA{AAGAHA(AљAӅAGAffAAAAA=qA
=AۅA33A
=A{A(AAHAAAQAAffA  A\)AA\)AA=qAָRAۮA33A  AzAzAQAAffA{AA=qApApAB HA{AA=qAGApAAAHA㙚A{A  AAAAAA{AB QB \)B RBB HA(AAAHA{A(AAA{A=qApAzAAAQAApA=qAHAGAAAQA(AAApAݙAA
=A\)AA  AAA=qAˮA
A
AA=qAѮAңAGA33AAAҸRA(AΣAθRAϙA
=AHA=qAAffAAGAzAGA33AAQAԸRA߮A=qARA
AQAA=qA{AAHAHAۅAA֏\AׅA
=A֏\AAAHA=qAA\)AGA\)A33A33AAхA
=AHAHAمAܣA=qA
=A\)AԣA
=AԣAApAzAЏ\A
A\)AzAϙApA=qAAQAǙAŮAA
AzAݮAڣAGAA
AA(AQAљA  AAHAݮAA=qA
=AHA
A(AȣAA
=AʸRA=qA  A͙AzA33AzAAAHAA
=A=qAzAǙAŮA=qAA33ApA33A˙A  AA=qA33AAHAffAAңAffAAQA  AAQAA
A(AϮAQAυA{AQA33AHAǙAGA(AǙA
AA{AΏ\AͅAA33AQAAHAAɮAGA
AƏ\A
=ApAîA33AȣA33A(AQApAͅAϙAAҸRAՙAffA(A(AأA
ARA
=A{A  A(A\AA\)A\AAAA  ARAGB   AAAHAA
=AAQAzAA33A{A(AGA
=AHAGAB33AGApBGA\)B BA{B 
=BBBB=qBBffB=qBBBBpB33BB B zAB 
BzBffAffA33ARA\)AAA홚A  AHA
A33A
AAAAAA=qA\)Aڏ\AAzA
AffAQAA33AAzAAffA
A=qAABpB
=qB	B
B
{BBBB=qB(BB\)B
=BQB
zB  B
ffBB	B	BBRBQB=qB33BGBBHB\)ABB B
=BHBHB	BQB
B
BBBRBBBBzBBHB	BBzB
ffBBBRBHB(B\)B
=AA\A{A  AGAA  AA
=AAAQAAARAAAHA  A33AA(AARAA{AAAA\AGB\B=qBBzBzB\)BB
BBBffB
=BzBBB\)BzBBffBBRB	(BB	GBBBBB	BffBpB{B
QB	(B
=BB
B	GAAQB \)BRBBB\)B(B  BRBGBGB  B 
BpB=qBBB BB\BpBpBGBBpB
=B{BRB=qBBQBBGB	\B	B
B\)BQB
\B{BB

=B
pB	B
=B	(B\B  B
=BzB	RBB
(BAB
BQB=qB=qB(BBBBRBHBGB	\B	B{BB
B
GBGB\B
zBGBHB(B
\B	BBGB
B
=qB{BB
BB\B
=B
\)BBB
ffBBQBRBB  BBBzB\BRB{B\BBBpBffBB\)BGBpBQBB	B
pB33BBB\B
=BBB=qBRB	B(BB
B
B	B
=BB(BGBffB(BBffB=qBB{BBB=qB33B(BBBzB	QB	B	(B  B
{B	pBHBpB	pB33BB	BpBB	HB	QB	\)B  BffBB
GB	{B	zB=qB33B{B	(BB(B
=B
33BQB
ffB	
=BQB
RB	zB
B
=qB
HBpBBBBBBB RB\)ABpBRB(BRBHBB	pB
GB
BB	BzBRB(B{BffBQB \)BffB
=AAHB\)BB{B\BB(B33BzBB(B(BB33BffB=qBRBB{BQBQB B B B HABBffBBBGB\)BB
33B
B	
=B	
BBRB	ffB	
=B	B
  B

=B
RB
B
B

B
=BRB{B
B

B
B

B
HBB
B
B
\)BB	zB	
=B=qBBB{B\)BBffB=qB	
B	{B=qB	zApB	ffB
=B
BGBB
B
BB	pB
(B	BBGB(B=qB\)BBffBBBBBzB zBB\)BBQBB  BBB  BBHB33BffBB\B{BpB\)B
=B
BRBBGB ffA\)AB
B(A\BBB{B33BBBBffBGB	B	QBB
RB	(B
GB
ffB\)B
ffB
B	B
BffBB\B(BB
=B  B
BGBB33B
B{B{BB(BBB\)BffAGB33B\)BB33A
=BB33BB   B\B  B=qBB
BBzAB\A(A뙚AAAzA=qAAAQAHAAzA
AAGAAGAHAAARAAA33AAAGAHAA33A
=AAzA{BpB
B\)BGBBBB GBBHBB=qBRBGB  B
B	HB(BB
=BHB 
AHA(AHB(BAHAHABAAB BB 
B HB
A
BBBRB

=B	RB
BRBB	33B
\B
=qBBBB{BRB{BzBBpBBzB B\A{ApA33AAGAHA\A
=AQA(A(A
=AffAQARA홚AA
A
B(A{AAAARA
=A\)AQA{AAHAA  AA{B GB 
=BA\)BBQB  BHB33BHBBB
=BB=qBzB AB  AQBB=qB
=BBpBRB BBGBRBGBB
BpBBffBQB=qBzB\)B(B\B33BBRB=qB\B	zB	BB33BBBB
B(BGB33BB\)B pA
AAA{A=qARAzAAHARA33AGA\AA\)A\)AA
AHAAzAA\)AA\AAzA
AQAA\AA\AAAzAB AGB
=B\)B
BzB
B{BzBffBzBzBBRB{BpB  B B{AzARBHBpAHB HAA{AA
B {AAARB GAAzB
BpBBRBBQBHB
=B
B	ffB33B	33BQB\BBQB\BpB	\BBApB
=B  B\BA{A  AA{A  A(AAzAAGA\)AAGA
=AA
A=qAApA{A{AA=qAGB HAA
ApAzAffA\A\)AAABpB33B33B(BBGBBB(B33B=qB(BB\)B
=BB33BzBB {AB 33B BB
=B (B AA
A=qAQA33AGAB RAQB   B 33B=qBBBQBAB A(ApA\)A33A(B =qB A  AA\A(AAARA
=ApA\A
=A
AA{A
AA
A{A\)AA  AAffA(A\AA=qA  AA\A(AHA\)A  A{A\A{A
=AA(AA=qAAGA\AAB
=B {A33B GA=qAA\BB
=BQB 
=B {AHAHA{A
AAGA33AGAAHAAHB{B  AB RAAGAAB {ApBzB33BBBBBRBBBAAzB BRB  B HB\)B B BGB AAGApA{A
A
AAGA뙚AA
A=qAAAAA癚AAAAA
=A  AQA\)A{A
AA33B  A33AB
BB
=BA\A\AAGA
AAA  B (B HBBBBBpBBHB=qBB  B33B(B{BB{BHB
=BA
=AzA=qARBB
=B33B{B=qBffBBzB33BB=qBRBB
BB\)B  BzBBB\BBGB
BzBBRBBBB33B 33AAHAAB 
=B \)B  B(BBB=qB  B33BBB
=BBffB A
A\)A=qAAGB
B(BBBBBBBHB\)BBAAA(BBBRBBB	  BffBBBBBzBBBB\)ABB\)BffB33BBBBQB 
=AB BB HB (BQBBBRB	ffBpBBB(BBQBzBzB\)BBBBAzBzB {B\)BBpB	=qB	B
B
=BffBB
ffBQBBBB33BQB  BB{BABA(B=qBBRB	HB
B
BQBGB(AA33ApARAQAAAHA33AB BBffBzBzBzBBHAffAB   B
=BGB  BRBHBB
=BGBHAAAHA{ARAAzA{B AffB GBzB\BBRBBRB{BBBHB
B\)BB
=BBGB{BB  BpAA33BA\)A  A  A{AQAffAA{A
=AAA33AHAGA
AHA\A\)AzAzAAA{AzAAA(AA=qA=qAA\)AAA\)A
=A=qAAB A\)AHA  B (B(BB AAB BffBB{BB B ABARB BAAHAzAAA\)B 
=B B
=B
=BBpBB
BpBB{B{BBRB\B\)B{B\)BBGB\BBHBB(ARApApA
=AGA{A{A33A  ApAARAHA{ARAAzA
=A=qAAffAAGA=qA\AAAGAQA{A33AffB AAAA33AB B B=qBRBpAAAABB=qB(B
=B(BBBQBB(B(BpB BBB\B33B\)B{BB ffBBBBGBBpB(BBBB\)BBBBGB	B	
=B	B  B

B
pB
33BBffB=qB
BHBGB  BRBBAAHARBBB  BHB\B33B{B{B
=B  BBBBBBB=qB{BffBpBffBQBffBQBGBA(ApAB
=B(BBBBB33BBB
B(BBBBHBQBB{B
=B=qB  B=qB33BBB  B\ApA=qA
=B
AB BBGBBzB \)AGB (BB HBAAB  B(BQBAHB=qB HBB=qBBB
BffB
=B
BpBGA\)A\)B AQAAffAAB AA\ARAffA
AA
ARA{AzA  AAAHA
A=qApAGB ffB =qB A{A33A
=AAA{AAQB {AA\)AAA
AB B{B\)B{BHB\)BpBzBGBB
=BB\B {B 
=A  A(A
A=qAzA  A=qAQAA
B B HB  B
BzBQBB  BB
=B33B(B{B{B{B{B\BRBpBGBRBB(BB
=AApAAA
AHA{AGA  A  A{A
AA\B 
=B =qB AB {B B BffB33BpBRB  BB\B=qB ARAQAAAGAAARAA
AAA
=AA=qAAAA=qAA\A  AAB BB(BffBB  BHBffA
=A=qA\)AGAffA
=A=qA\AA  A  AA  A33AA\AAA33A(AARAQAQAA{AAffA\)A׮AAAA
=A(ARA=qA
=AffA(AAA=qA
=A\)AHAffA
=A{A߅A{AA\)A=qAApA(AHApA33AA
=AApA  A  AzAڣAAAAA{AۙA(ABzBzAAA\)AAHA
=A  A\AHApA(A\)ARA  AGB HAAA=qAAGA33A=qAAAGAA
AHAAA\)A{A
AA
=AAAAAzAAAffA\)AzA  ApARAAA
=AGA\A=qAAHARAA
=AA(AzA\)AHAAAAAA{AHAAAAzApAAzA{A\)A{A뙚A\A
AAAAGAAHA{AAQA\)A=qA
AAA(AAAA
ApA(A=qAGA\)AA{A{A
=AAA(AAAGAQA33AA\A\AQB \)AA\)ARApAAA\)A=qAA\)A
A\)A{AGAzABffB(BHB B{B\BBBAA\)AA
A(B \AAB B  BBHBQBBBBBA\AGA\AA\)ApBBQBQB\BQBffBB BBBBRBpA
=B
=AB ffB =qB (A{B B B(BffB B  B RB\BzBBB33BpB
BBBBzBB\BB(BQB (AB {AffAB B B(B \B ffB   A
B{AB {ApABQB (A
=BzAHAAAffA\A\A
=ARApARAAHA
=ABffBBzBBB{BBRBB(B(BB(B\BBBHBBB(B=qBHB  B\)B{BAB33B=qBB  BHAApAB pAA
=AAAAAA
=A=qB QA{AHA\AAQB BRBGB B  B	  B(BB	(B33BB(BHB	HB
B

=B

=B	\B	B\BGBQB\B
=BBQB
B(BBB\BBBRBzBGAAB BpBGB
=BffBGBGB{B(BBffBB=qBRBB33BBBB(B
B(B\BpBBRB\BffAzA
A\)AA(AA  AQAA\)AAAB{AGA
A=qA(ApB QB
=BB
BBB  B  BzBBQBRBBBzBB
=BABAA\)AB HBBQBpB33BBBBB
A
=BB {B{A  B B  B{B(BpB\BB
BB
=AA  AAQB\)B\)B(BzBBB  BQBBGB \)B zB (B 33B BB(BBBpB=qBGB{B BpBBffB=qBB AffAAzAzA{AffB GA\B
=B (ABB\BQBHB=qAAzAAQAAHB
BGB BBHAApAHAARA\)AQB AARA(AHAAApA\)B pAGBRB33BffAzAAB GBB  B\)BpB33B33AA
=A\)AGA\AA
AAAAAzA33AA\)ApAffA\)AffA뙚AzAffAAzAzA
=AHAAAAA
AzAAARAAA\A(AA
AAApA\AHA
=B AA
A33AGAAABffA
B HB ffB =qAAA33A\A(AB
B\BA\AQA\)AAAApA\A\A
=ApAzA\)AA\AzA
=ApARAB B zB\)BB AffAB33BpB{AHAB \)B
=BBBAARA\AA\)A
=AA{A\A  AzAGA\)AA=qAAAHAGAAAA{A=qAABpBGBB33AAffApA(BBpB\)B
=AA
AGB AzBzBB{B{AHA33ARBB(BpBBA
=BBBBBGBB ffBGBA33ABBzBffB{ABHAffB\)BHBffBB	B
=BHBB BQB33BB=qBHB(BHBB  B\)BB	GBB33B
=B
=BHB\)B{B{BHBB33BGBzB(B(BGB  BHBB\)BBBBpBBGB\)B
=BHB
B
=BHBBB\)BBRB	\)B	=qBHBB	QB	B	(BBzB	{B	{BffB	B	B	HB	B
  B	B	B	pBB	B	(B	\BHB
=BQB
=BB	B
pB

B	B
  B	=qB
  BBB  BQB
33B
BffB
HB
B\)B
B
=qB	pB	B

=B	B	
B{BGB\BffB B AAHAA  AA{AA\)AGAAAGAA\AA{AAA
=AHAB 
=A\A\)A=qB BQBffBB33B\B{BBQBBffB\)BB33B
B\)B(B\BQBBBB=qB=qB33B33B  BB\)BB	
=B	B	
=B	
=B	pB{B\)BBB{B\)BBzBRB{B
=BBffBBRB
=B\)BBB=qB{BRB=qA
B	ffBzBpB=qB  B  BQBBQB33B
BB \AA\)AA
=AB 33BB
=BB
BBB   B zBB\)B B\)A{B {AAB
=AHA
AARBBBB  B\BBBHBBzB=qB	
B	pB	BB{BGB
=BffBzB\B
BBBRBBBpB	BB
B
=B(BB\BBpBB
BB  B33B\BBffB
BffBB\)BRBBAAAB BQBBQBBHBHB\)BQBAGARA
AQAA\)AA{AA{B B HBB{B
=B33B B pB \B AA
A33AffAAQA
AAHA33AAAAAB
=B 
BB
BB
=B\)BB(BBpB\)BBzBBBB
=BBBpBBB\BzB33B=qB=qBBBBzBpBpBB
=AffB
=A\)A(A{AB zB GB \)ABGB
=B{BHB
BHAAAA  ApAAAApARApAzA\)B B  BGBBBBBBffBffBpBRBBBBBBBHB(BGBGBBzBBzBA  AB GAB
=BB{B
BzBB
=BB(BBGBBBB\)BBBBB
=BB  B	GB	BHBB33B
BB
B	  B	
=BBB(B	zB
pB	BB	{BBQBGA
=B 33B =qBGB{BzB	\BBpBB
=B\BBQB33B{BB=qBBB\BBB  B=qB\BHB(BB	RB\B	QBGB
=BpBB\)B33B
=BHBBBB  B{B33BBRB B33B\)B 
BBffBBQBB
=BGB(B33B=qB(BQB\)B=qB
B
=B{BBpBHBGB\)B\BBB	(B	\)B	B	=qB	
=BB	\)B
  B
\)B

=B	RBzB	pB	\)B	zB	{B	
B\BBBBpB{BB(BffBBHBBGB 33BGB 
BBpAB {B\)B 
=AApABGBQBpB  BBB
BzBBBzBBBGB 33B ffB33B B BB 
=A33AARB BQBzBGBzB
=BffB\B  B(BB  BpBpBpBpB  BBpB{BBB(B\)B
=BBRB  BBBzBBB\)BQBBBffB	{BB\BQBGBzBBpBQB  BffBRBBBB\)BzBQB
AA(AHAAAAB(AA\AAAQB QBBBB
BBB
BBBQB
=BzBBBRBB\BffBGBpB\BRB{B =qAzAAAA
=A(A  B B pBGB
=BB\)BGBzB
=B\BB{B\BBB  BBHBRB
=B\)B	BBGBBpBB	B
(BHB	BBBBHBpB33BB(B=qBGB  B{BBHBGB33B\B{BRBHBzBB33BGB{AB=qB\)BQB{AB =qB B (B   AHB  BQBQBGBBffBB\)BHBBHB33BB	
=BzB	\)BBBBBBGBBQB  B
=B\BHBB33B=qBRBzB
BGBBBBB=qB\B
B=qBBpB33BBzBBGBBRBB=qBBBBpBB  B{BBffBBBQBBpBpB(B=qBBRB\)B 
=BQBB\)B33ABpB
=BpBGBHBB33BRB\)B33BB33BBQBffBB
=BB pA
AAAAA  ABBHB
=BzBBAGAA
=A
=AAAQAGA{BB RAB
=BBB33B{BHBAQBzBpBBB(B33B\B\BB{BAA(A{AGAB(AA(AB (BBB B RBGB RBBRB 33B B ffAApB HAA(AB 33ApA
AQA\B 
=BpB(B\)AAAA\)ARAAAAAAA  BBHBBB  B
BBGBBBffBQB33BQBGB=qB33BGB  B\)B  B=qBB
B33BBBB  BHB=qBRB  BBBQBzB=qB  B
=B BBRB
B33B33BB\)B\B{B  BGBBB	
=B	zB	B	{BRBBBBBRB\BB{B\)B(BQBBB\)BzB33B(B\A33B(BRBB\)B33BpB
B zB zARAffAQA\)A33AAA
AQA\A
=B 
=B B=qB
B(BzBffB33B=qBHBBGB=qBHB
BBB
BBBBRB
=B  BpB  BBzB\)BHBBffB{BBBRB{BBBBBB\BBzB(B  B	GB33B
BRBRBRB(B(BQB33B33B33B=qB  BBB=qBGBBGBBpB
BBB
BAA
A=qAffApA\ABBBzAAB =qB \)AABB\B33BpBBffB\BffB
=B	B	  B
=qB	33BRBzB\BB{BGBzB=qB GB33BBBBBBGBzB{BBBpB=qB\B33BzBBQBBB  B{B33B	  BBBB	B
B\)BBzB	B	zB\BBRB=qBBpA{B ffAGAB   AB(BpBGAARBBQBBBBzB33B\)BBpBBzBB=qA
=A\)AAAHAzA\ARA=qA
BBGB B B  BpBQBB=qA
ARAffAQAA
=AQAARA\AzAAA\AA33A\A
=A{AAzApA(AzAAAA
AAApA{AA(AB ffB\AAARApB ffBpB B BQARB B B=qBBB pB\B   AA\)B B QBGAAzB{A\)ApA{B pB33BzBBBpAAA  ApAHAB{A  BBAQA=qAA{AHA
AHAAB\)B\B  BAAAGA
=AAARAA{AAARAAzAQAzAGAABffBB
B{BffB\)BBB(B{BQBBBBHBHB   AB \B QBB 
=AB GB RBGBHBffBQBpBffBBQBB
BBRBBffBBRB(B	  B
BB=qBB=qBBBB33BB\BpBBBB=qBB BpABffB AAApAGAAAGAA=qAAAzA{AAGA33A\)AAA
AA(AGAffAA
AA33AAB HA\AzB  AQA(B 33B
B33BHBRB=qBQB{B{BffBGBBBB\BBRB\BBGB{BBB\BHBzB QBGBGBBB(BpB{BBQB  BBpB\)BpB B pB\)B B  B  B A=qB AA\)B\B{B\)B33B
=BBA33A(AAAHAAAA\AA  AA{A  AA
=A  AARAAGAA
ARA33A  AQAAAAA{AQAAffAQAGA\AQAAGA(B A\B \)BGBBpB\)BBBBHB33B  B(BHB=qB
B\B{B{B  B\B(BHB=qBBBBBpBAAB 33BB 
B\BffBHBBBHBHBffB\BGBBBBBffBAHAffB 33B
=B
B \)ARA33A{A
=B B RB B RB B B
=B B{AzAGAHA홚AAA
AzAffAAApA\)AGA\ARAA
=AGA(AAAAA
=AAA=qAA(ApAAA\)AAAGAAffA=qAAB ffB GB B{BzBQB QA
A
=A(A\)A\A33AARA\A{A(AARAGAA
A=qBQB BBBBHB 
=A
A\)A\)AHAGA=qA  AA
=A\)A=qA
AA=qAA{AA(A=qAQAA
A=qA
=AAA홚AApAARA뙚A\AAARAAAAAAQAA(AQAQAA
=ARA  AGAffA{AAAB33BB
BB
=BRBBBBGB(B=qB	=qBB	B	B	QB	\)B	RB	B	BzB	
=B
=qB
QB
QB
33BB33BBffBB\)BzBBB	QB\)B\)BB	33BQBRBBB{BzBBBGB{BGBB
B{B=qBBHB
=B
BAGBQAAzAzB \B\BB=qB BRBBBffBBzBpBBQB=qBB(BB33BGA\A
=AB
=B\BQBB=qB(B33BQBBB 
BzB{B\BGB
=B
=BAffAHAGA=qAHB33A33AAB pB
=BBBBB  B33BHBB(BHBzBGBBHBBpBBpBBB  B
=B  B=qB B\)B \B   A\AffAffAA(ARAAARA(ApA{AA\)ApA\AffAzARB(AAAGAB AHAAAB GB
=B B B A(AABRB B \)B B \AApBB B(B\B\)BRBffB33B \AA
A33ARAB{B
=BzB33B=qB =qBRBBBBGBGBffB
=BBB  BffBBRBBBGBpB
B=qBBBQB{B{BzB\)BB  BGBBARAAB(B(B\)A\)A{AHA{AQA  AAA  AAARAApA{AB BB\BBQBB\B 
AAHAAAAAA{AHB pB B B=qBGBGBBBB
=BB  BBffB33B
=BB
BRB{B  B	
=BpB	BBQBB
=BzB
B\)BB  B\BzBAA
=B   B  BffBB33BB{BzBA\ABzBQB  BB	zB	
B

=B	B	GBpBB  BQB=qB  BHBBBQB
BffB\B ApB ffBB\)BBHBB BBB
B33B\)BffB
BBQBBBBQBQBBB
BQB
=BpBBBpBB
=BBHBGApAAffA
ABBB
B
=B
BBAAA
AAzAAHA\)AAzB \)BGBGB  B=qB=qBB(A
B  BBBHBBffBApB zBRBffABBHBBB B  BQB pBABAB RBBpB 33BGAAzBpBGBGBffBBB{BB  B33BHBQBB
=B B B 33AAQAA
BBB=qBB\)B\)B(B\BBB\B
=BBRBBGBBpB
=B BB{B B 33B 33AzB BRB 
B zB{BQBffBHBHB B\BBABB 
=BB \)B BBQBpBB
AGAQB\)B\BA
AHA
AGA
A{A  A=qAA{ABQBB  B ARAHApA{A  A(AARA{AA{A
=ApA=qB ARAAA\A\)A(A{AA\)A홚ApAA
AA  AA\AAQAA=qAGAzA
=ApAAffAA\A\)A\AA\)AÙA(A{A(AQAAAQAAA\AffAAGAGAffA33A\)A(A
AA
=AAAHA  AA{AA=qAAffA(A33A{AQApA=qAA{A33ARA\)A\)AHAzAzA\)AAA\)AÙAۅAAQA\)AAA=qA
=A(A33ApAAffAffAzAA\)A=qAAAGAۅAzA  A(A{A֏\ApAʏ\AAϮAQAGAA
=AAAAAAzAHAGApA(A\)A{AQA{A{AGAffAffAAAffAхA\)AffAAA
Aď\AGAA
=A{AA  AՅA=qAA{AAQAAAȸRAAAA{A¸RAAffApAAAA{AQA33A\ApAA=qA(A\)AAAHAA33A  A
=A\)AA£A33AÙAGAAAƏ\Aȏ\A
=AAA{AA{A  AffA\)AHAՙA33AzA=qAHAAAAAGA{AA\AAAzAARAApAA  AGA  A
AîA=qA=qA
=A\AA=qA\)AffA(A33AffAffA\)AƸRAAA{AQAۅAAޏ\A߮AAffARAHAAAA
=A{A\AA=qA  AGAAAGA
AQAA܏\AAAQA=qAڏ\AՙA{A\)AA˙A33A
=AAffAffAٙAQA
A=qA  AzAAQA
=AGAۙAAA(A  A\)AA{AQAGAA\)A{AAޏ\AܸRA
=A33AۙAQAڏ\AA=qA陚AA\A  A  A(AQA
=ApA  A{AQA  A33AQAAA(AQAffAffA\A{A{AGAA\AAAAHAzAAGAޣA
=A
=A{AߙAޏ\A
AAGA  A\)AQA\)A{AApAљAՅA  AHAApAGA(A  AAA(AAAAA  AAGA{AApA33AHAzAAGAA=qApAQA
=A\AffAffA(AAGAAApA  A
A\AGA
=A  AAAA  A
=AAQA  AA\AA
=A
A33A{AAA33AAAA=qAAAA
AAHAA
AzAAAA
=ApA噚AAHAApA
A
AAQAzAAApARA=qAffAA噚AAљAظRAAzA߅A
=AHA  A
A33AQAۙAᙚA33ARAHA=qA\A\)AAAzA\)AHAffA(A
=AQA\)AAffAApApB A=qAQAAQAA
ARApAAAHARAQAHAAAمAHA\)ApAGAApAHAϮARAQA(AA33AGA{AQAAAAAAA
=AAHAzApAHA\A(AAzA(AAA{ARA33A{ApApARAAAAAffA\AzA(AApAGAAA=qAGAAAHA  AA\AffAAA{AA\A(AAAzAzAA
A
AAAAA
A33AQAzAGAApA
AA¸RAARA=qA  A{AAAA=qAQA{AՅAAAQApAzAӅAzAۅA\)A(ApAAA  AAA=qAAAA=qAA£AGAHA{AAA{AzAAzAA\)ApApA{AAAAQAAHARA
AzA33A  AA  AApA\AAAApA\)A33AӮAӅAAHAAzApA
A
=AA
=A\)AAAA=qAAܸRAۙAA  A33AHA{A=qAAЏ\AӅA
=AzA33ApAƸRAʸRAǮA=qA=qA
A
AGA(A
AAͅAAΏ\AУAffA\)A׮A
=AAAAޣA=qA=qAظRA=qA\)A33Ȁ\A(AA33AffA=qAQA33AQAzAGAffAAzAHAA33A
=A
AARA=qAQAzAAHA33AՙAQA(A\)A{AA=qApA{A\ApA  A
=AA=qA=qAA
=AA(AHAAA33AA{AAzA(A33A(A
A
=AAffAApA陚AQAAzA=qAffA  AA{A(A(AApAAzA
A33A݅A{A33AA  A߮ARAQARAAAGAARAzAzA
A
A
AQAA߅A\)AޣAA=qA33AQAAA{A33A{AApApAA=qAzAzAAAAQAAܸRAۅAۙAA33AzAޣA33A{A\)ApAGAAHApAA癚AAAAA=qAApAAAAQAA{ApAA\A㙚A=qAAffAAQA\)AHA  AᙚA  AzA  AA
ApAffA  AA
AәA=qAzAӅAѮA\)A=qAGAHA{AAЏ\ApApA\)AϙAHAGA  A
A  A=qAQApA
AAffA33A(AA
AأA(AGAAمAȸRAAAAQA33A(A
A֣A
=A֣A33AAAffAQAffAAzAָRA֣A
=A33AQA(AԣAA(AffAQA
AəAHAͅA=qAθRA=qAA\)A33AA=qA=qAʸRAʏ\AӅAA
=A  Aޏ\A\)A
AQAA
A(AGAŮA  A  A=qAHAAQAȏ\AA{AǮAAAǮA
A  AA
=AAffAՅA  A{ApAHAəAAȸRAA{ApAǅAHApAHAHAGApA\)A=qA(A33AHApAͮAA=qAA  AAA
AǙAɮA̸RAGAzAHAHAAAʏ\ẠA{A33A{AAffA  AңApAzA
AA
AAAȸRA(AQAA=qAHAA{A
=A\A
=A
=AA{AAQAAzAHAGARAHA
=AGAA
=AAAAAAAAHAA(A{A{A  A\AHA
AHAHAAQAGA\)AAQA{A
A{A\)A\AApA33AA\)AA
=AzA
=A  AAAHA
=A\)A{A33AzAQARAApARAzAzAA\)AAApAAAzAAAAAzAzA\)A33AAffAQAAHA  AzAzAA{A\A
=AffAffApA{A=qA{AzAAA  A\A{A33AAHA33A
A
AA=qARA\)A\AffAzAA
ApA\)AAffA
A(AARAARA{AAAA
AAAAAARA
A(A{AA=qAffAzA=qAARAGA33AzAAAA\A
=A(A\)AAAHAffAAA33AA
AA  A
=A
AA(AAAAARAAAA33AAQA{ApAffAAAAARAAA{ARA  A(AA=qAAAA=qAA  AAA33A(A33AQAffA{AGA(AA\A\A{A33AAAA
AAApAAA  A\)AARA\A
A
AAA
=AAAAA33A  AA(AAAA  AffAAAQA(AAAA
A\AQApAA
AffAAHAw
=AmAk
=Ap  ApzARHA[
Ak33APzAG33AX  AXAYAR\AYA[
AbffAh(A`zAhQAGAHAuAhQAYpAV{AR=qAH(A`A^RA\AV\AUAYA8A;A4A;
=A (A!A0QA;
AX(AmApA[\)A;\)A0zA!A5A:=qABHAV=qAR\A[33A`  A[
AK33AAGAJ\ATAIA1GA+A[33ArHAf\ApAsA{AQA  AApzApA~{AAA\A{A(AA33A33A(AA\AA(AQA  A\)AAGAAzA\A
=A
AA
AApAffAAAA{ARAA33AQAA33AzA\AAAAA
ARAAAHA(A(A\AA=qAA
AAffA\)AQA\AARA
A
=ApAHAAA(A33AAA
=AHA=qAA
AGA  AHAzAzAAAA  AAA{AAAAzA33AA  ARA33AAA33AAAA33AAAApA=qA
=A  AzARAAQAA{A
AQAffA=qA\A  AGAGA\AAQAA{AARA(AARAAQARA=qA  AA
=AHA=qAA(A
AAffAAA(AAGAA=qAAQA  A{A\)ApApA\)A
A=qA  AffA=qAA  AA\)AHA33A=qAAzApAAAAHAAAAA
=ARAA{A\ARAA  A\)AAGAGA33AAAGAAA=qAAAQAARA=qA
AAAAA\ApA\AAzA\A33AzA{AAAGARAAAA
AzA=qA=qAA(AGAAffA=qAA(AAHA33AAA
=A
AA  AA(A
AAGA  AAA{A̸RAApApAHAQA
=A
AңAA=qAϙAҏ\AzAиRẠAʏ\A
=A
=ApA33AApApAffAAHAЏ\A̸RAңA
A֏\AA{A=qA  AAffAHApAәApA=qAĸRApA\AA{A=qA33A\)AʣA33AAQAA{A(AAGAGA=qAAGAAHAAGAffAzAApAAQAGAHAA
A
=AA噚A{AAAAAڣA\)ApA=qA癚A\AHApA{AA\A\AA
A  A{AQA  AA\B\)B ApBAB AAffAGAHAGAAAA߅AܣAAA
A{AQA
=AAA߅A\AffAzA뙚A
=AAffA(AzAAGApAffAHA33AAAAA\AAA(AARAffAHAA  AGAA33AAGA33AޣA33A{AAA\AAAޏ\AQAAA{A{AGA\)AApAffA\AHA\)AQAAAAAHA(B BA=qA
AA\AA=qAAAB\AAffA
A  AzAffAAQARA=qA  AA33AAApA\AAA(AGA\AARAffAA(A(AAA\)AAHA  ARA\AHAB A
=B\BB=qA
ABpAAQAGA=qAA  A
=A33AA\AAAffAffA
AAAA
=ApA=qAA(A33AGA\)AAHAA{AA  A\AQAAQAAARAGAGA=qAA
=ApA  AAHARAAAHApAApAAA
AAAGA{A
=AGA\)A(ApAAApARA33AAAAA  AA=qA\A=qAA{A\)A
AA癚A߮AGApA  AAAУAAڏ\AָRA֣AAӮAУAڣA=qApARA  AAAAAAAHA  A噚AGA噚AffAA{AڸRApA33AAAݙAAݙAׅAQA(A
AHAzA
=AAՅA{A(A
AARAzAAAAAAQAzAAA33A\AffA=qAzA33A(AAAz{A|As33AGAs
=A_33AYpAPQA6ffA.RA<A4A8  AL  A=A733A3A*HA#
=A QA-A#33A"HA   A QA
=AQAA'
=A&ffA0QA.\A:RAD(A.HA7
AJ=qAIGAHA?33ATAPAK
AB=qAV\AUA\  AaAcAg33Ap  A  AwA{
=AhATzAHzAS\)A`QAaGAdAXAk
=AdzAcAqAyA=qA  A(A=qA=qA
=AxAxzAffAk
=AAHAHAAApA{A33A\)AHA=qA  AA\AQApA=qAHA\A\)ApAffApA(A=qAffAzAA33A
AA(AA{ApA33A\A\AAARA(A{A(A\AGA\AHA=qAAffAA
=AffAQA
ARA(AңAA33A  AffA(AGA\A
=AA
A(A(AAffAzAAAA
=AGA\)AA33A  A33A{AAGAA  A\)ApA
A  AAƣA
AARAHA33ApA  AGAffA33A33AAApA
=AffAQAzA~=qApAr\ApzAX(A:=qADQAJ=qA_AtAuAffA~{A=qA
A}pAA=qApA33AA{AQAHA\)AAAAAAHA33AffAGA:HAiA  AeAYAJHALQAYGAG\)AK\)AFRAh  AhAj\Ah  AhAC\)AW33At(AA  A
AvRAj=qAhA
=AzApA  AAGAAAHAApAAHAAAAAA{AAAzApAffA
A33AA
=AAQAA\)A  AAzAA
=A
A͙A
Aď\A
=A
AffAAzApA
ApAAģAA  AzAAQAGAAAHA\A
=A
=AAHAAAA
AA\)AAffAQAAA(A33A(A33A(A  AzAQApAA=qAffAAAA{AzAA
AGA  AA{AAzAAAA\AA
=AAzAQA܏\AȀ\A  Aԏ\A
=A=qAٮAGAzA㙚ApAAA33AAA
A  AAARA{A{A(AA=qAA(A=qA{A
=AˮAzAA(A{AHAHA\)A\A\)AA33AAApAzAA
A  AzAzA(AAAQARAʸRAzA33AzA(AŮA  AÙAGAA
=AARAzA{A
=AA
=A  AAʣAA=qA=qApA{AAA\AGARAGAAffAA  A\)AARAA(AARAffB   AAAffAzA=qA=qA\A33AQAܣAAљAӮA˅A=qA{AڣAQAQApAAܣA߮A33A  AᙚA
A
=ApAzA
=AARA陚AA㙚BffA
=A(A\)A\)A\)A(AGA(A(AHA33A
A  A
=AARA뙚AAGAͅAʸRAffA˙AAzA33A33A33A  AљAAAAA
=A׮A=qAAׅAAAApAAA=qA(A=qAffA{A33AGA{AzAAzAAffA
=AɅAAָRA\)ApAƏ\AffAAAΏ\AAυAA
A{AHAffA
=AHAHApAAAA{AAA=qAA\)AܣAܸRA(AܣAAӅAAAAA
AAϮAQAAzA
A33AA\AݮApA
=AŅA33AA\)A  A  AθRApApAffAָRA  A{AA
=AHApAA{A
=AzAϮAA{A
=AA{A(A(AHA
=ARAۙApAAA33A\A{A=qA
AzAٙARAA
=A(A(AAA{A=qAծA  A33AQAAQA(AQAAʏ\AǮA=qAAQAA  AGA\)AffAffAA\AGAҸRAA
A  AAAQAAA\)A(AAApAQA\)ARAA33A{AffA(AAA
=AHAGA{AARAffAffAAAHA33A=qA
=AARAGA
=AQAAApA
=AAQAAAffA\AA
AA33AAffA
=AA
AzA(AAAA\)AAzAAA
AHAHAzAARAffA{AzA  A\AA\)A\)A
A
=AGA\ARA=qA=qA
=AGAQA
A  AģA\)AAA=qAңAHA{A=qAAA=qAApA33AAA(A(A=qA=qARAA
=ApA  ARA  AApAA\)AAAHAHA{ApAAffAGAGAApA\)AAAAA\AARAA\)AAGA
=A  AAAɮAffA
=A£AAGAAQA{AQAffAۅAA\)A(AA\)A{A
AQAɮAʏ\AϮA
AɅAHAۙAQApA݅A͙AHAA݅A߅AGApA噚AAAҏ\AAͮAA=qA
A
=AծA  AzAffA޸RA{AҸRAAA  AA\AA£A\A
A  AQA  AGAAˮA{AAQA(AAQARA
=AA(ApA
=A\A33AzAڏ\AA=qA(A{A(A33AHAffA噚ApAمAA\)AAΏ\AA(AffAәAGA{AffA
A\A(AAApAݮAAυA  AAzAAAffApAA=qAׅAޏ\AܸRA(A{AzA
AԸRA
=ApAffAGA(A(AAHAA33A(AAأA\)AAAA=qAA\)AԣAAԏ\A{AAApA33AA\)A=qAϮA  AQA\)AA
AQA=qAAљAљAљA
=AϙApAхA
=AхA  ApAʸRA͙AѮAffAAAѮA
AHA{AApA{AQAHAA=qAQA(AӅApAиRAУAӅAzAׅA\)A\)AծA{AffAGAхAAAAffAԣA
AҸRAQA
A
A(A
=AffAApAۙAA33A֏\AGA
AAHAAA
AхAAAAΣA
AϙA{AϮAA{AHAzAQA{AAAϮAAAϙAAΏ\A
A{A33ApAAQA\)Ȁ\AAQAHAAQAAA{AA33A
=A{AA  ApA33A\)AϮAA\)AAAѮApAHAAAAA33AQAAHA=qAA
=AffAAQA=qARA33ARA=qAA=qAAffAAzAA=qAAAɅAffAzA
=A  A  ApAffAAA{A(AQAAA(A
=AGA
ApAAA(AQA  AAHAHAARAHAAA=qA=qA=qAffA{A
AAA(AA(AA\)AGA33AAAGA
=AffA
AAA  A\A=qA=qAHAAzApAHAA
=AA\)AHAAA33A=qAHA=qAA33AAHAAAQA
AzAA\ARAA33AApAA\)A(A=qA\)A
AARAAHApARAA(AffAGAffA=qAQAffA\)A\AQA
AA\)AA{AAQAHARAApA
AGAAA
AARAAQAffA\A
=AQAGAAA33AAA33AHA33A  AA=qA=qA(A
=AA
=A{AAAAA{AA
=AQA\A{AAApAGA
=A{A{A
A33AAAAzApAA{AzAAAffA=qAGAffA33AA(A
A(A33AHAGAAHA(AQA\AAAAAA\)AffAA{AA  A{AffA{AQAAAQA
=AAAA\)AAAAAAA
=AGAA=qAApARA
A
=AHAAffA=qAAHAA{A{AAA  AAAAARA\AA{AGA\)AffA33AAGAffAAAAAA{AA  AHAA  A=qAAA\)AHA{AHA
A33AA
A{A=qA33AGAA(AAAAA
=A(AAHAAA{AzA{AA=qA\A
=A
ARAAAzAAHA\)AAAA\)AzAA(A  AA  AzAA\A33A(AffA
=AAA
ApA(AA\)A  A  AQAffA
=AAHA  ARApAAA(A  ARAAA(AAffAAA33ARApA33A\AAHAAARA
=AAAA{AA33AHA
AQA
=AAAAHA\)A
=AzAAHA\)AA\)AA\AA=qAzARAARA33A
AGAA
AA=qAHA\)AAAAAzAAffAAHAffAA\AAA
A=qA{AA=qA\)A\A\)AAGAAA
=AAAApA33A\AARAAAApAAA  A  A=qA\A=qAARA33A
AAA\AAAAGAAA
=AAARAHAAHAApA(AAA
AzA(AA33A\)AAzAA{AzAAffAAAARAA  AA
AQA\AQAQAAAAQAA33AA{AzA
A{AzAA{AA  A(AAQAA
AA33A{AA33A
AAAAAA=qA\)ApAAAAA
A\)AAAzAffAffAAA(AAA\AAGA33AAzAffA
=ApAAARA{ARAGAAA
=AAAQAzAAQA=qA=qA\)AAA(A(A
A(AAQAAHARAAA(ApAQAA33A{A{AAffA33AA\)AHAA{AffApA=qA
=A\AAAQAAAzAA
AHAzAA  A(AA\AA(A{AQAAHA{A
=AA\)AffAGA33AAQAffAGAGA
A
=AAzApA=qAAffA\)A
=A\AAHAAAA(ARAffApA\)AA{A  AA=qAA33AAAzAGAA\A\)AAAAA(AGAApARAAHAQA33AzA  AA=qA{AA=qA\)AAAA\)A
AAAGAA(AHApAAAAAAHA{A
=AGA\A=qAAAHAAHAAA
A(AAHAAAHA\)AAAzA{AA\)AA  A33AffAHA
AAA\)ARAA=qApAApA
AA\AA\)ARAA\)AAHA\)AAA\AAAffA{AAAApAA  A=qAAAzAA
=AAAA\AA
AA{AzA=qAA=qAHAAGA=qApAQAHA\AffAARAA\)ARAzAARAAffAA\)A=qA
=A
=A=qAAA
=ARAAffAA(AAQAGA  A
=ARA=qAA{AARApA=qAGA=qAAAHA\AA{A
=AQAGA  A33AA33AAA\)A{AAffA33A\AA\AzA{AA(AAA\A
ApAHA33A\A\)AA
=AApA\)ARAA{AAAQA(A33AffA(AA\)AAApA=qAAffAAAzA
AHAAAA{AA=qA=qA\)AA(A=qAAAAAApAApAAA(A  AAApAAQARA  AHAAA{ARAAA\AA
=AQAAAAHAffA
=AAGAA{AffA(A  A=qAA33AzAAGAAAAAAAARAA{AAA
AAffApA\)AAA
=A\AAA(AApAAA=qAA33AAApA=qA
A\AAA=qAAAAzA{AQAA
=AGApA(AQAAffA=qA(A33ARAffA(AQAAA\)AffAAffAGARApAAAA33A{AA{AAA\)AffAffAAAAA  AAHAA\A
=AA(AA33A
=AGA(AAA\A
A\)A\AQA33AzAA(A
=A  A\)AAAAQA\)A33AA
A
A=qAQA  AHARAAffA{AA=qApAHA=qA
=A
AA
=AAA(AA=qAGA
=A33AzA\AA(AHAAHAffA\)AA\A=qAA33AzAzAAAQApAAAAAGAAQAA(A\)AAA
A33ARAAGAAHA
=AAzAGA=qA\)ApAA\AA
AzA(A  ApA{A
AGApAA33AA{A(AA{A=qAAAAAGAAA\ARAAAA(AAAAAAApAzAAQAGAAzAAA\AHAAA
=AffA{A=qAA\AA
=AA(AAAA\)A(A{AA(AAAAARA=qAARA
A\)AA=qApAA(AAAAA
=A33AA(AApAAffA
ApAAA\)A
ApAA33A(A
AAHAGA(A=qAzAzApAffAA
AAA
=A\AA
A{A=qAGAffApAQA=qAA
=AApAAzA(AzARApA33A(A(AGAAA  AAA\)AAA{AA(A=qAzAA\AzAAA33A\AApAAHAAAAzAAظRA  A\AAAA
A{AGA33A
AzA{AzAQAzAQAQB ffB HAGA\)A{AA߮A33A(A\)A(A
=ApApA\)AظRA\)A\)AAϙA֣AA֏\AA{A\)AGAAՅA  A(AGAԸRA
A=qA
=AHAzAΣA̸RAAHA
AGAQA33A(A\)AHA
=A
=AAɅA(A\)AәAGAA=qAA=qA\)AAȏ\A\)AA\)A(A{Aҏ\A  AHAQAAffA  A{AzAA
AHAffA\AARA{AAQA܏\AGA=qAمAAGA=qAHA=qAԏ\AA  Aԏ\A\)AAAA֣AAڣA癚A{A
AA˙A\)A陚AAA
Ȁ\A33AAЏ\A
=AQA
A£AȀ\AzA
A(AAʸRAzA˙Aʏ\AHAHAAA\)A\)AA\)A33A˙AAA\)AңAңAңApAzAGAzAAиRA{A
AGAͮAHAffAƏ\A
A
AAHAAA
=AARA\)AA
=AA
AڸRA
AApAffA33A{AzA33A(AQA
=A\)AzAffA
A
=A33AA  AAAϙA˅A
=A\AffAA33AHAzAHA(AA
=AffAAffAAHAAzA\)AAGA
=Az{A(A  AGA=qA(AIA^{Ac
A\ApzALAxA9AAB=qA,  A!pA7
AAA.\AB{ACA\AO
=APQAV{AbRApQAr\A=qA  AGAAQAb=qAiAkArffAzA33A(AeA(A4  A3
=A:{AC\)ATAH(AIAO
=ANRATzAeAhQAnffA{AHA  A{A33AAAApA\A
A33AAA{AAQA=qAAHAAA\AA
=A=qA{AAHAA
A
A
AA
AAAHApAQA33AHApAAA  ApApA{AffA
=A  AAffAA
AApApA(A33AAAA\)AϙAܣAA(AHA  BBffBAQA
=B(AAA
=A{AA=qAB GB B AAzAAA\)AApAAҸRAǙAQA{AAӅAA{AHA
AHA
=AzApA
A
=AzAGAA\)A{A  AzAծAAA(A=qA  AݙA33A뙚A\)AGAQA  AzAAA\A陚AAA
=A\AQAHA
A\AA
AA=qAzApAۅAAA
AAA
AA  B(B  B(BBGB=qBHB	GB{B
  B	(B 
=B\B	B
zB
(BBHBpB33BBB\)BBzBBGBBB
=B33B	QBHBRBB(BpBQBBGA
AAB (ABB
BpAAAA\A33AAzA=qA\)A=qA\AffAAffA  AAAABB B
=BBBzB
B
BRBHBQB=qBBHB(BGBBBB33BffBffBBpBpBB BBBBB B
=B(BBffBB
BBBB	B	HBB
HB
ffB	pB
=qBBQB	(B	pB	BRB\)B
=B	RB	B
B
BpBQB{B
B
\B
  BBBBBGAGB{AzB=qBB{B33BHBRAQBBRB(AA33AAAzAB(BBzB\)B=qB33BB\BB  B=qB\)B(B(BffBBB	GBBBBB=qBB	B
ffB	pBRBBHBBBBBHB\B
B	GB\)BB{B
=BBffBB	(B	(B	33BzBB	{B33B	BB
ffB
RB	\)B	zB
33B
pB
B	HB33BB
=BzBRB
BBBBB	  B
  B	=qB	
B	=qB
BB	pB\B33BffB{BBBHBB
=BQB\BB(BBHB
=B
BzBffB33B
=BQBBBpB(BRBGBA{AB33B\BHB
=BBB\)BQBRBBBBB AAffAGB B AHA33AAA\)ABBHB	QBGB\)BB
=BBGB	zB(B
=BzB  BBB	33B
B
=B(B
=BffBBB=qB
BpB\B  BBQB\B pBB	BB  A\)B=qB   AA(B33BBQBGB{BffBB{B{AAQARAAffARA(AAAA  A=qAGB {ApAAHAHAAAAA
ApA{AA33ARAAAA\AGAARA\AzA(AA\AAQAA{A
=AARAA33AAQAHAAA\)AAA{A(AQAQA(AB=qA{B pA
B \)AAAAzAAzAA{AAA\)AAAA(ApAGA(ARAAQA
A(A(ARA{A{AA=qA\ApA㙚AAA=qAffAQApAzA(AAAA\)AڸRAA
=A\)A{AAGApA㙚AzA{AظRAمAAمAظRA
AA=qAظRAzAڏ\A
=AAәA
A\)AffA  AffAAA  AѮA\)A  AظRAQA
AAzA  AAA
AA
AAffAARA{A\)A  AAApA؏\A݅AAQAA\ApAA(A
A=qAAffA(AQAAARAB zAARAzA޸RAAA  A  ApARAAffAGAGAAՅA
=A{ApA{AۮA\)AAHA{AA㙚AᙚA
Aޏ\AffAA{A=qA߮AAߙAAAAA=qAA33A
=A  AٙAA
=AApA(AARAApAAHAHAAAAAQAAQAA
=A  A(A  A(AHAAApAGA\)A
=A
=AQAApAffA\AA
AA  AHAAA(A\)A
AzApAGAA  AAGAffAzAAA{A  A㙚A\)A  AzA{AGAAA
=A\)AAA=qA
=AzA(AzA
A\)AA
AAffAzAAHAA癚A{AAffAAA\A\)A=qARAGA{AB QB \B
=AB\BBBB=qBBBQBB\)B(BQBRBpB\)BBBBB\B\)AAApAffB ApApA\)AA(AAAAAAA
A=qAB RAAAA33A=qA=qA{AQA33A  AffAffAARABpB  BffB33B(B
B(B\)BB
BBRBBGBGBRBBB  B
BpB33BBB	GBBGBA\AQB BzBBBBB	33B
=BGB\B
=B
=BBB(BBffB	pB	=qB
{B	BB\B\BB
GB
=BBRB  BBB(BBRBB	RB
B	
BB
zB
QB{B
pB
ffB	
=B
33B
33B
33B	QB
BB\B
B	\)B	RBAHB
=B  B  B BQB B  BB33B\BpBBQBHBBBBpBRB
=BQB\)BBB\B33BpB(B
=BB(B  B
B{BBGBBBGBB{BBB	B33B
33B=qB
B  B
=BB
B
\)B
33B
B	BB	B	B=qBB	\BB
ffB	RBB
(B33B{B{BRB	(B	33B	BQBB{B	  B	BB\B\B\BzB  B
\B33B
B
=qB	33BB  BffB(B	BB\B{ApBAzB \B
B
33B	(B
B
33B  B
B  BApAB
=B=qBffBB
(B33B	
B	B	QBpBB\)BB33BBQB
=BQBGB
=B
BB	ffB	\)B
HB	BB	=qB\BBffBB33BHBHB	ffBB	B	AB
B33BHBQBBB  BRBBBffB	HBB(BHBB
=B=qBBBBHB	
=BpB\B(B  B{BffB

=B(B
{BB\)AQB{B
B\)BB 
A33AAzAAHB(BpB
=B
B
=BzBBRBRBffB\BHB\B  B
BBBBB{BBB
=BQB
=BGBzB\)BB
=B\B33B{B
=BBBzB
BzBB\BBHBB  B\)BffBBBGBBB\BBB
=BpB=qBpBBBBHBRB=qBBffBBBBBB
B	
B
\)B
BBBB\BzB	B	QB	B=qBB AHBBGB
=ApAGA\)AB 
=BffBzBA  AB AffA
AAA\)AAA
=B GAB {A
B   AB 33AB   AAAARAAzARARB B B{BBRBBBBRBBHBzBB(B33B=qBffB=qBQB\)BBB
=BpB{BQB
B(B=qBpBzBBB
BHBB\)BGBQB\)BHB  B\)B\)BHBHB  B  B{BHBB\)BBBQB RBGBRB\AA\)AAffA33A\)A=qABBBQAHAA\)AARAA  AA=qApB 
=B AA33B BQB   AffAQA
AA
=A33AA(A\)AB(A=qBffBAHA\)B BBzBBzBffB=qB33BBBQBQB=qB(BRBpB\)B\B\)BBB{B
BB33B  B\B33BBRBQBB33BQBRB(BB\)BHBB33B\B\B 
=B (BpBffB  B
=BB {AA{AGAAB QB AAzA33AA{ApAA
AA\)A\A=qA{AARAGAAA
AAA
A\)A
AAAHA(AAAAHA\)A(B B  BBB=qBpBBRB{BzBBBpB(B33BHBBBQBQB\BHBGBHBBpBBpBffB{BQB  BzBBBB  B  B
=BBBBBHB{B{BBBpBBBffBffBQB  BBzBB=qBffB
BBHBpBHB\B33BpB BpB{AQA  AARA\)AAAHAAAA{AA\)A\AffAAAA  ARAQB {A33A
=A(BB  B\BA(B(B\)BB\)BBB33BBBBpBBBffBB\)B  B pBAAGA\)ApAHAAABzB   AB HB{AQBBB
=BB\AQBzBBBGB\)B  B
B=qBBpB=qBGB(BBRB RA\)A33AQAA\)AAB \)B BB(B=qBzBBBBzBBB
BB{BBRBpB(B\)B
B\)B
=B
=A
AA{ApA
AABRB33B33BQB
=BHBBBBBRB  B\)B
=BRB\B{BBBpB GB B=qB zB 
B B 33A  BffBffBB(B \BpBHB
BBHBB33BB  BBffBHB
=B
=AzBB B   AAB 
=B GB B
=BRB
=BHBHB
B\)BzBB\BB33BBB\)BffBB  BffB33BzBHB=qBQB  B\)BB
=BBffBBBffB 33ARAAB\B BBQB\)BB
=BB\B=qB  B{BBQBzB33BB  BB\B
BBRBBBGB\BBBB
=BQBB  BB  B\BQB{BffB33BB\)BBBBpBQB
=BGBBpB\BHB QAAB B(B (A\AQAA
BQB  BB33B33B33BBBB=qBB{BffB=qB(BQB{BpB{B B 33A33ApAB {AffB   B {B (B ffBffB \BB zB\)B{B
B(BBffB\B{BB\BQBBBBBffBGBBQBBBzBGBBBBHBffBBB GBBzB
=BffBzBB(BBzB
=B33B\)B
=B\B\)BB\BBRBpBRBpB=qB  B{BRB
B(BpA
A
BQB BBGB\)BQBffB AHAAzAA33A33AAAAA=qAAffApAzAAAAHA{ApAA
=AGAzA(AAGAAzARAHAA
=A\)AffA(AQAGA{B \)B \)B B BQB\)AQA
=B BffBzBBBffBHB
=BQBBBBpB=qBpB=qB33AffAB\A\)AGA\AA  AA
A  AAAAAA{A
AA
=A=qAAzA=qAAAHAzAzARAA  AQA\A\AA=qAAApA  B{BffB{BBBB{BAAHAGAHAAA홚AAAzA
=AffAAA
BzB BHB
BffB
=B{BBB AB B 
=BpB \B33B RB pAA
=AzAQA(AAHApAffAAAA\A
=ARAA(AGA(AAAAAAHA  AAA\)A33AAA
=AQA
AA
AGAGA{AA33AzA33AffAffA\AQA
AQAAAA=qA\AzA  A\)AGAzARApA\)A\)AffA癚AA\)ARA홚AHA  AApA(AzApAARAA
=A33AAA(AA(AzAAAzAHAAA{AHAQB B \B   B AA\AHB   BGBBffBzBffBB{BzBB \)BRB{BB=qBBRBQBBHBpBBB\B\)B
B\BpAQAAHB{ABRB BBA{A\)A
=AzAGAzA=qA\AAA
=ABBB	
B
BB RB B33B  AffA{AzAzA\A=qA33AHAffAAQAA{A뙚AQAA
=ARAffA33AAAAA33AA(AzA33A33AA=qAApApA(A33A33AAzAA=qA{AAAAHAzAARB GB pB  B{B\BBBB RBQBzBA33B \)B 
=B 
=B QA
=A\)A=qApAGA33AHAzAA=qAA
=AAA=qAAA=qA{AAffAA陚AAAzAffAA\)A=qAGAAzA33AAAAffA\A\A\AffApA\)AA(AA\AAA{AGAApBAA
A
=B BAA{AAAAAAHARAApAAffA\)A
=AQAApA33A  AffAzA
=AA\A
A
AAAAA=qAA뙚A  A33BGAA  AA33AAAzAA(AffAQAAA=qApA=qAHA
=A(AARAAAA=qAHA\A=qAAzARAGA
=A{AAHAQAA
A㙚AAAAA
AA
A  AzAA  AzA(AGA33AׅA33A  A܏\A癚A33AAAQAAAzA(AAHA
=A
=AA  A=qAffAAAA
=AARAHAAHAA33A\)AzA\A(AAA
Aޏ\ARAAHA=qA(A
=A(A=qA(A=qA{AQA(A33A\)AA\A\)AGA
=A33AAA\A癚A\AAzARAAQAA޸RAA{AA߮A(A
AA(AffAAޏ\ARA\A߅A=qAA{AA{AzAQAA
AAzA\)A33A{AAzAAAffAAHAAGAA  AAAA(AAA\)AzA33ARApAARAAA{A
AAQA
A33A  A陚A
=AA33AAAAQAzA\A{A
AAޣAQA  A33AApApAڏ\AۮAHAA뙚A\AzA\)A\A܏\AAAAA(A(AAGAA33A(A(A(A߮AQAAA33AծA
=AffA  AffApAA
A\)AA(AAͮA
=AffApAGA
AޣA33ARAAzAA陚AffARA33AA\)AA
=ApA
=ARA\AzAAAffAA  AzA33AA
AffA噚A
A
=A{AAAGAAAGA\AzA=qAA33A{A(AQAffAAAAA\A  A(AAHA\ApAڏ\AzAA\)AHAA  A33AAݙA
AڣAffAGA\)AA  AڸRA
=AQAHA͙AƸRApAAHAQAA{AẠA=qA͙A
AzA\)AffAA
=AA{A\)AAAzAffAzARA\AffA=qA\)AA
=A=qAQAQAAAA
AAAA
=AAQA\)A33AGA33AffA=qAAGApAA=qA33AAHAAzA
AAAQA=qA=qAffA{A\)AԣAיA=qAA33AߙAQA(ARAzA噚AGAQA֏\A=qAHAۙAHA\)AzAîAA=qAAQAApAffAA
=AzAΣA
=AA33AffA33AABBzB  B=qB   AzAARA33A
A\A33AA=qAA{AAA\)A
=AAffAA{A  AA
=AQAAAAAAA\)AAffAHA{AAAԣA=qA  AA
AffAAAA
=AAzAA  A(AAzAAݙAQAA  AA  A{AAAA  AA(A33AA  A
ApA{ARAAAA  ApA
AA˙A\)AA
ARA=qAAָRAAAAGAQAAA
AffA\)AAHAAAHAAAHA\)AAAAzA  AHAQAffAA(A\)AׅA˅AA(A
=AHAԸRA=qAԏ\ApA\)A\)A33AA{AB HAAApAA=qB (BA=qAffAA
=AAQAAAA(A\AAHA{A  AzApA
A
=A=qAʸRAͅApA{A  A(AffAA(AУAיAЏ\AA
=A(A33A\)AA33AQA\)A\)A
=A{AQA  AQAAAffAGAA\A(AA{AAAGAAzB AAffA  AffApAAA{A33A
ApA33AәAHAA
A33AGAA{A=qAARAHA홚A
=A33AA\)AA\)AAA
A
AzAAAQAzAQAHA
Aȏ\ApAHAffAAHABB=qB(B\B\B pB\BQB AAQA  AAffA33A(AAAޣAGAAA
=A33A
A33A߮A癚AApAA
A33AAAHAApAGAzA癚AQA\)A噚AAzAffAA  AAAB =qBAAHAAAAA\ApAHA{A(AAAAݙAAۙA
AAAAAAAGAHAHAAAGA\)A  AAAAffAHAzApA33AA{A  AAQAA33A
=AA
AQAHA\AApAzAQAAA\)AAA33AGA߅A{AApA\A
A33AA(A  A\AAAGA홚A(AAA(AzAA  A
=AGApA(A{A{AA
=AAApAffA
=AzA{A\AGARAA\A\)A{AffAGA
=A(AA
=AA
=AzAAA\)A33AHA\A(AffA  AffAGA㙚AHA{AApA\AA{AQAffAAGA\)ApApA33AGA{AAHAAQApA
=AzAAAApAAA
=A(A  AHAGAHA{AAffAffA  AڣA(A߮ARAQApA
A(A
=AGAHA
AQAAAAGAA\)A  AGA\)A=qAAHA{AAA(AARAAGAzA
AAA
A{AffA(AHAA
=A
=AQA{AQA
=A  AAAA
A\)AظRAܣA{A  AAA33A  A
AffARAAGA=qA(A  AAAApAA
A(AAAAA33AA(A݅AApA\)A(AGAQAᙚA{AA33A{AA=qAۮAAQA
=AA\)A\AHA33A(AzB GA33AA
A\)A
ARAffBGBBzB AA(A=qAzAAA33ARAffARAAHAAAQA33A{ARAQA
=A
=AzA{A\AHAffA陚AzAHA\)AޣARA(AffAAQAAٙA\)AQAA\)AGAA(A
A
A
=AܸRAzAܸRA(AܸRAۮAޏ\AۮA33AA\A  AAAQAAAzAAAܸRA33AAHAGA  AAQB\A\)B A
=AAAA=qAzARA\)AA\)A{AQABA
=BHBffBBAffAGARB =qAAQAAzA{A{ABpARAHAA
AAAzA\)AApAAzA\)AA  ARAzARA
AzAHAڣAۙAAzAA{AA{ApAAAٮA\)AApAA=qAAQAA
=A\)AHAAAHA؏\AzA=qAAA{AA(AAA(A˅A\)A{AA
AA
AzAָRA
=A=qAGAAAHAHAA
AA\B   AAAA陚AffA㙚A33A  A
AAffA  AffAA=qA
A\ARAA(AzAAffA(A
AQA
=ApA
=A\ApA뙚AffAA\)A{AAٙAQA33AQAָRAzApAGA(AAQAHA
AAۅAAܣAAAҏ\A{A33AԸRAzA(A
=AGAޣAA  AA(AAffAHApA{A
=A33A\)BB\)BAzAzAGAAQBBzBHB
=B=qApB \B ffBQB
33B
GB
  BQAABB\)B {AHAA(AA  AAA=qA  AzAAAAQA
=AA(B pAB(A
=AzAGApA{A33AGAAHA=qAApAAA\)A
AA33AAAAHAA  AHAA  A33AzA  AAHA  A\)ARAAffA  AzAAffARApAA33AQApA=qA=qARAAQA{AHAA33AzAAA  A
A33AAA  AGARAAA  A  A  AApAAߙAڏ\A(AAAQAA陚A홚A
A  A\AGAAAA=qB  AGB\)AAAAA{AA\)AA33AA\)AA{A癚AAGA癚A\)AA=qA\)A
=A݅AA߅AA݅AAAAHA=qAffAA\)AA
A
AA=qAޣA(AGAAGA=qAAAAzA=qAA{AffA33A\A\)A
=ARA\AHAAAzAAAzA݅A{A\)AAHAA=qAAApAA陚AA  A  A\)A\)AzAHAAAAAHB GABGA=qAffAAA(A(AffA
=AAHAAffAffAGARA  AffA=qA33AA\AGApAA33AAAA
=A{A\)AQA\A\AAڸRAGAzAHAAHAAAGAB \B AGAAGAGAB ABGB
AGA\)A\AQAA\)A
=AAAAzBBA
=ARA  AAA癚AAGAGA\)AA(A{ApA33AffBQBBQApAHAAApAAAAQB   A33B
=B{BA
=AA=qA
AݙA\)AA33A܏\AQA  AffAGA(AHA=qAAHAHA\)AAA{AٙAڏ\A33AffA(AA(A  A33A  A{A\A\)B BA(AzAHAޣA\AمA  A\A\)AGAAAA33AGA(A(A(AffAA{A
AAHAAAAzA(A  AQAGAAAAHA=qA{A\AGA=qA
AGA
=A
A{A(AzApAzBB\)BzB{BBAA=qA
AA߅AQAAAffARApA=qA  A
AAۅA=qAڸRApAمAQAA  AzAzAAܸRAߙAffA{AQAܸRA
=AQA33A33AAظRAGA֣A{A(AAAAڸRA  A  AQA33A
A\)AAAAffA\AGAA噚ApARA
=AA  ApA{AGAAAA  AAffAAAAGA
=AA{AᙚA33A33A
=BRB  BQB {A33A=qAA\A\)AzAAA뙚AAAffA
A
A=qAA  AڸRAߙA{A33A܏\AݮAAffA33A(AAAffA
A
=AGAAffA=qA
=AAzAAA=qAzA
A33AzAA(AAHA\A陚AA=qA
=AA
AAHApA=qAA\A
A
=A{AAAA
A\AAAARB
=BzBA\A{AApAApA뙚BRA33AzA=qAQA(ARB
B	{BA  A=qAAA
=AAA
AGAA{AAA  AAAA(AHA33AHAHAzAffAApA
A
=A=qA33ApA=qA
=AAAzA\AA\)A
=A
=AAHAAzA\AA33A
=BBB=qA
=B B AB=qA{AABBzBApBRA
BGBB pBRAB(B ffB BA{AAB 
AQAAApAA\)A\AzAffB zB BBA\B 
=BA(AAAzBBGBB=qB  BB 
A(AHAAB{AAGAAA33A\ApA(A뙚AAA  ApA
AA
A  A
AARARAAGA(AA33A\AHA噚AffAHAAQAHApA
=AA
AGAAGA(A\)ApABA  ABzBAQA\)B33A=qA\)AAGA{AAffAGA\ABGAAGAAAA
AHA33AGAffA\A=qAA(AܸRA홚A\A  BB  BA
=A  AGAA{A
AHA{A\)AՙA֏\A{ApA
=AAA׮AظRA׮ApA{A\)AA\)A
AzAA(AQA(AأAffA{A{AAzA׮A\)A
=A33AظRAHA
=A=qAQA  AޣARAAAQA\)AQAffAzA
=A\)A(AAAA\AzA؏\A(A\)A  ARAA=qA  AQAGAA
A\)AzAGA
AARAAAzAAHA(AٙApAAAAA
=ApA=qAAAA(B=qB
=BB  B
=AAzA(AHA(A
AGA33AARAA(A
=AA33A  AHAA{A
A(AAffAQA
AAffA噚A=qA{AA  A
=AffApA
B33BB{BffBB
=BHBBB 
=BHBB33BHB=qB	\BB
\B
B

B
B
B(B
=qBHB RBBffAA(ABGAffA\B QAAAAAB B 33AzA\AABRBQBzBffB\)BBBBzAGA뙚AAAA33AQA\AA  AffAzAA{AAARARA=qAA=qAA  AA  AA33AHB A(AA(A33AA=qAAAAA  ABHBAHApAAQAA
ABHB
A(B=qB {AHBRAA=qABBBB
=B\)B{ApB pAB 
B33BBB
=BAQA  A
AffBffB{B(A  AARARAB(BB
BBAA
=A\)AA(AAHAzAA(A=qAA\A(AA홚A\AA
A  AAAAA
=AffApAAApA=qAA=qA\)AzA{A\)A\)AQAA  A\)AA  AHAA\)ApAARA
=A
=AA  AzAAGARA
=AHAzAA=qARAAGARAGAA  A33A
AAAAAzAzA
=AA\)AHA\)AHA=qAGAABBA
=A  A  A
AzA
=AAB ffB =qBHBRB RBpB \)B A{A\)AAzAQA  A33AΣA{AͮA
AΣAԏ\AAљA{AԸRA
ApA֣AAۮA\)AApA  A\A(AQA33AۅA
=A=qA  AAffAGApAffABB BAB (BHB33A
AAAA\)ApAAAzAGB 33BB\)BBGB
=BBB
=B(BB=qB
BRBBGBB QB\B ARBffB
=BHBB
=AA33B A33AffA\AAA(AzA  A(A=qA噚AQAA(A33AffAAAHA\AA
AffAGAHA
=A߮AA{AAHAAA癚AffA(A\B\)BB (AAffABffBpBA=qB
BQB BBAAA
AzAQAAQB
=ABGBffB\AGBBGB33A
A
AAAAAAAApAB
=BA  B zBB\)BBB{B33B =qBBHBHBB  AAGAQBB  BBBBBBpBAA\)A
=A\)AA
AffApAAGAAffA=qA\)AApARAAzA
A
ARA\)BQA  BBB(B\)B{BQBHB
BB
B
B
\)B33BHAHBHB (B
{B
\A33BBBffB	BBzA(BAB BzB B\)B(B  AzBQAzB \AB B33B\B 33B =qBGB B \)ABBzB\)B 
BQB zB=qB
BHBBB
=BBB
BBRBpA\)A(AzA33AHA33B =qAA(ARAAHA\A  A=qA(A(AA  A{AA
A33A(AffAApAQARAHA(B   A=qA{AffAAffAffApAQB GBBB(AB BffBB=qB(BHAffAffA\A(A\B zARA{B AA
B QA(A  A=qA33AGAA{A(AffA  AGA\)A
AAB \AB\BHBffB   A=qAA
=A
AARAGAAAffAAQAzA
=AAAA\)AAAA\AzAQAffA{A{A(A(A=qA  A{AAffA
A
AQAAHA\)AAGA\ApA\AA{A(AA{ARA׮A(AARAA=qA\A홚AAHAA\)AAHB\)B\B
=BB=qA{A{BHA(AAAGA33A{AA=qA{AzA陚A陚AA\)A
=AAAB
=BffB
=BBzBA33BffA=qAAAA\)B  B33BB  AApAAAAۮAffA(AA
AңA33A{AՅAGAٙA33ApAHAڏ\AQA  AffA(A؏\A݅A{ARA33AAܸRA{A33A=qAᙚAAAAA
AffAQAGAQA33ARA  AA\AAAAA  AAzAffAAB 33BAGAAAAzAA
=A\AARA=qAGApAA=qAGAQAzApAAGAzAGAApAAzAAݙAA\)AAffAA\)A\A\)A{A  AGAARA
=ApA=qA=qA{AAAA
=A  A(AA{AA\)AARA߅AA  A
=A  AApAA\)AAGA\A߮AAQAAARAQA
A\)AQAAGAGA
A噚AA\)AGB {AffAAA
=AzAA  A
=A
AAA\AzA\A\)AAHApA\)A߅A홚A陚A  AAAQAA{A  BBffBzAB{BpBBzBAAQAARAA\)AHAA33A(AGAHAAHAGA\)A(AffABB\)AHAAAB 
AQAAQABA\)AA33A  BzBB\BBB
=AAHBRBBB(B
=BRBzB
=B\)B\)BpB
B
=A  A\)AARA\AAGA\AGAAGAA(AA(AAAGA陚A\)A33ARARA
=B RA33AHAB ffApB(BzB\)B zB {B B ffB BRBQB(B(BRB\)B AGAAB{B\BHBHBAAARAA\A33A
=AAzAffAڸRA׮A޸RA=qAffAzA
AApARAApB \)BAHAA  AABBA{BHBB ABBBBA
=B{B\)BQBA\)AffAAAQBffA\AA=qA  AQA33ARAAzAzAAffAGAApB AAAA\A=qB33BB\)B33B	RB	pB
GBB=qB\BGB
B   B AA=qAQAHA  AA\AA\)A\AGAHAAffAAHARAGAA  AzA
AA(A  A  AAA
=B \B HA
B BQBBGBffBBpBBBffBB=qAffAAARAGA{AAAffAA
=ARAA
=BffB QABQAAAAGAHAAA=qAA\)B   A
AApA
A\)AAA=qB\)BAA
=AA(A
=AzAQAAAQA33AAAHA
=A\)A=qAAHAAA
AGApA  A\AGA  AAAffAARAHAAAAAzA
=AA=qA(AAA33A{AٙA\)A(AAׅAAܣA؏\AУAzAԣAɅAAAݙAƏ\AAQAAAӅAGAڣAAGAAQA\)ApA=qAA\)AAA
A\AAAGAQAAA=qB (AA  AffA홚AAzA  AGAApAffA33ApAA\)AAffAمApAA
=A33A\)A(ARAAQA{A
A=qApAAQA=qAAHAGAAAA\A=qA\)AB   A\AAAAQAffApA
=AB B QBB\)BzBAAzAGA\AA(AA
AAAAAAffApA{A  ARA
AAAGAAzAGA\A\AA\AffA
=AAffA{A\AAAAAAAAzA\A=qA\)AGAA\)AA
=AGAB A홚AAޣAA{AzAGAzA=qAHAAAAHAA
=AAffA㙚A߮AA
=AzAHA{A{AAAzAA(ApA33A{A33AAAA\AffA  AA\)A\)A
=A  A33ARARAffA{A
=AARB 33B ARAGBAzA=qAARAA\A  ARAARBB QAAHAA{AzAAA33A  AA
=A
=AA
=ABGB  B
=B33BB(BHAzAARAffAAffAAAApAA=qA
A{A{AAAHA\AAAA\)AQApA(AAAffAffAAffAGA33A33AQAHAQA{AGAGAAw33Ah  AIA(zA)A5A<(A=AFffA-A,zA(QA-A1GA*\A2RA@Ad  AAAAffAAuGAb\ATAHQAIpAOAKARHAR\AMAJ=qAN{ARRAf\Ap  AUGAd(AT(AtA`  AA33A  AA  AA{AAffA33A\A{AAAAQAQA
=A\A\A{AxQAGAffA(ARA\AGAARAARA=qApA\)A
=AϮAQAGAAGA
=AAřAffA\)AAAzAمA33AAՅAظRAԏ\AAA\AAApAApAQAAzAA=qAA=qAAAîAӅAAθRAA(AŮAϙAAzA  AAAHA\)ApAAܣAHAQAzAzAQAAЏ\AA˙A  AQA\)A  AffA\)A(AQAAAAQAA33A=qA{AAGAAffAQA
AîA
A=qAffAޣA\AHAAԸRAffAAGA\A
=A33AԣAA{AѮA
AͅAA33ApAAA
=AzAzARAQAAARAffApAA33AGAAAA\)A=qAGA=qA
=AffA  AffApA33AzAAAffA=qA\AA
=AxzA\AGAz\A
=Ah  Ao33A[
A_AD  ABRAAGAEAApA>RA
A&RA&ffA'\)A.ffA:{A0A+33A%A((AffA#
A%A"{AA"HAA\)AAzA,zA0A<AkAZ\AHA=qAk\)A`zAA2HA0QA=qA-A}pAffA2\AfHAT  A(ApAB{A5pAAA-GAlAwA?
=AF=qA\  AAdzAF{AA=qAGA  AA\)AHA{A\AyAGA33A{AffA{A=qApA\AQAAA\AzAQAffA33A{AAAHAAGAffApAAAGAA\A\)AARARAA(A
=ARAAzA(AA\)AARAAA=qA\)AAA
AA
=A  A
=AApAAGA33AAHAA(A(AAGA{AQAHAAA33AA(A\)ApAA{AA
=ARAzAA(AHAA{AffApARAA
=A\)ARAA  A\AffAˮAA\A
AAA33A\A{AffAA=qAAAA=qA\AApA\A{AHAAAHAffA\)A{AA
A(AʣAA
AA  A  A  AffAApApAAA{AAzAGA\)AQAA\)AzA\AffAAQAQAAA\)A=qAA
=AGAA\A
AAA
A  A\)ARA{A\)A(AAHAAA\)AHAApAŮAzA\AA
=AA
AA(AAAAA  AAAAA
A{A¸RAA  A33AAA\)AApA(AAGAУA33A=qAAΏ\A
AQAAA\)AQApA  AA\A
=A
=A\AA(AHAARA(AAHAHAծAΏ\A
=AffAA
=AffA  A  A
A\)A  AA{A\)AAHA߅AA33AGAA
=AˮAHA33ApAApA
AApAA
=AAGA(AɅA=qAHAəApAffA
=AAHA\A
=AA33A33AA  AAQAA\)AAHAA  A  AAzAAA(A  AAARA33AʸRAHA  AAA
=ApAA
AA33A(AA{AffAAAAA
=AAA\)AffA(A=qAffApA\)AffA\AzAA\)AA=qA\AzA33A
=AAHA\)A
=AAAffAzApA
=AAQA  AzAA\A  AA  A{A{AzAAzAAARA(A=qAA}Av{Az\A{At  AkAyA~=qA{ApA(AGAA{A(AGA=qA
=AzAAffAA\)A{AA(AAA
AQARA
AAA(AA
=AzAAAA
=ApAzRAuAs
=A|A(A}A\)ApA\AA  A\AAAAQAAAGAGAA\AA33ẠApAAzAQAffAA  AHA
AAzAA=qAA
A홚AA(A(AQA\AGApAAAAA=qA
ApAA  A
=AA{A
=AQAA  A  AHAA
AAQA{A\)A=qAGAA
A=qA(A{AAGA
=B 33A\AGA
=AٙApAGAffAĸRA£AAAAA
=A\AzAGAAAAzA(AAîAA\AA
AAAAGA33A\AQAzARA
A
A=qA  A33AffAARApAQAApAA\A
ApAAzA\)AAAA
AәAzA=qA=qA{A=qAAHAA33A
AA\)A\)A=qApAzApAAA
A\AQA
AA\A\)AzAffAHA(AAQAffAϮA33AᙚAAٙA¸RARAA=qA  A
=A=qAA\)A(AA=qAAA33AAAAAffAA
=A=qA33AA\AAHAAzA=qAHApA
AA  A
=A=qAA=qA  AAA  AHA\ARAAHA
=AAA
ApA\)A
A{A(AffAHAA\)A{AARAAA{ApA
=AAGAAffA
=A\)AA  AffAARA\A
AffAAAGAAGAA\)A\)A33A
AAA
=AGAffA\AAAffA(AA  AApAzAAAQA33A\AAGAzAAAAffAA\A
=A
=A
=ARAAAA  AA\AQAAGAA
=A  A(A  AA  A(AGA\AARA
=A
=A  AA33AA(A{AAAAA
=AQAAA33AA(A
=A=qA
=AHAffAAîApAAAHAGAA  AGARA(AARA33AzAAAAffA{ApA\)A{A33AAA\A
AffAٮA  AzA
AffA33Aď\AǅApA33A\)AQAA  AffAQAAApA
A\ARAAA=qA\)A\)ApAAzAffAffAAApBffAAzAAHA33AQAAAHAGAAzAAA=qAAA
A33AA
AHA؏\A
A
=AA{ApA\A{A=qA=qAApA=qAA
=AƸRA
AAGApApA33A=qAԣAA33AхA=qAffA
AHAAAffA=qAʣA͙AA\)AAGAAAAA  AA{A  AQAAҸRA{AGAQA{AGA{AQA\A\)AzAzARAA
ApA\A  A33A=qAzAffA\)AAAB   AffAAGBHBBzBffBBGBBHBRB{B\B\BffB
A=qAAAAAAAGAGA
AQA\AffA\)BffBB{AAAAA=qAzA\)ApA{A=qA  A=qA\)AظRABA=qAzA\)AHA
A癚AffAA(A\)AAᙚAAGAGAA=qAAffAA陚AGAA
=AAAHA
A33AA\)AA߮AA
AAA
A  AAffAHAQARAAAGA뙚AffA
=AAAAARA
A
A33ApBAAB {BAzA=qAA\)AAffAQAB
A
=ARA(A  A33A
A\)A  AA=qAAffA{ApA33AՅAAAQA؏\AAApAA  A=qAffA=qAA
A  AՅAՙAأAظRA
A33AffAAffAݮAAHA33A޸RA=qA=qAQA޸RARAQA߮ApA=qA33AԸRA
ApA
A
A噚AA(AApAAQAA{ABAAHBA
ApAzB\B{B  BpAB\A=qAHA=qAzA
=A  AHAHAGB \AzA(B  A\AAAAA
AAAApA  A\AA(ApAzA\A=qAԸRAҏ\A{A  ARAHA
=A\)AGA
A  A(A=qAA߮AAA{A33A  AAߙAQA(A  AAݮA=qAݮAzAٙAAHAAٙAGA  AӮAHAܸRAA\)AAхAɅAAQAΏ\A؏\A
=AzAHAGA(AAHApAAЏ\AA\)AA
AڣAARAAA33A(A
A{AAAA(AHA\)AARAzA=qAA33A
=AAA
AA
=AAأAՙA\)A\)AޣAzA\)ARA(AٙApA܏\ApA=qAGAA  AzA33AAAՙAA
AA{AAzAAƣAffAQA
AẠA̸RAɅAAĸRA£A=qAHA\)A
=A
ApA{A{A33ARA\)A  B QB BffAAQA33A\)AAA
=AAApAAA뙚A(AA33AHApA  A(AQAAQAGARAQAA(A33A
A33AffAAHAAAAHA=qARAAzApA  AzAffA{A  AQAAQApAA=qAA=qApAffA(A33AQAAHAHAA֏\AGAAңAA(AA
=AՅAծAA֏\A֣A33AzA\)A
=A33A
=A׮A\)A
=AzA֏\AָRA  AA=qA\)A
A
=AA
=A=qAA{AA(A(A{AHAzA{A
AAzAAApAAAzAAApAAA
=A{AQAAHA{AGAAQAGApA{AGA\)A݅A߮A=qARA
=ARAAAzAA  A(AGAA\)ApA\AAAۅAHAAQAAݮAߙA{AA
A{AzAAA{AQA{ApAAARAA\A(A33AAffA
AzAA33A  AAQAA\A\)A(A
=Ar\Aj{A[33AdQAuAnRAgAw\)A}AqAR{AipAaGAqpAn{AsAoAmGAiGAmpAo
=Ab=qAepAiA{A  AAzARA{AAA\A=qAAAA
=A
=AA33AA{AffA
A  ApAA{A=qApAA=qAA(AAwA\)AA  A  A
AHA33A33A=qA33AA{A\)AA\AQAGAA\AQAAAA=qAAAAɅAzA=qAA
=AAAzA(A(AHAAߙAAAAGAA\)A
AݙAݮA
=AָRAffAGAQApA  AǮA{Ȁ\ApAAAẠA
A
=AA
AGApA
=AAمA{ApA  AݙAzA=qA
=A  ARAHAܸRAAzApAAA
=A
AAApARA\)AHAQAAAAAHAzA(A
=AA=qAffAAQAAŅAzApAAHA=qAffA  A֣AAAAAAڣAиRA׮AA\)AGAәAHA  AzA  AәAzAمA\Aڏ\A
=AAffA
=AA=qAARA\ApA
AGA=qAQA33AAA֏\A{AٙA33AAA=qA\)A=qA
=A(A=qAHA؏\A
A
=A33A(A֣AGAQA  A33A
=Aԏ\AQAffAffAᙚAA
AffAәA{AzA
=A(AHAѮAϙApAAQA֏\A  AzAԏ\AAAAǙA=qA\A  AzA\)AŅA(A{A\)AA{AQA{AAGA=qA=qAAڏ\A癚A\)A߅Aޏ\AHAAAffAAAGA\AHA陚ARA(AAA
AݙA(AۮA33ApA33AָRAA
ApAGAA噚AzAffA޸RAAڣA(A\)AA\)AA=qAGARA\)AAAA\AAAAHAQAA{ARAAGA=qA(A
=AAGAAԏ\A33A֏\A
AQAAQAAHA
=AיA  A֏\A؏\A׮A33A=qAAAHAAHAHA\)ARAAŮAAəA\)AGA=qA{AA  A
=AApA(AۙA(AAA=qAQAٙA˙AAGAA
=AGAQAQA{AA  AȸRA{AA(AQAAAظRAָRAAޏ\AzAGAHAAffA癚AAڏ\AA  AHȀ\ẠA(A(AffA33A\)AA
=A  AƏ\AƣAGA=qA=qA{A33A
AApAzAAA  A=qAAHAAAffA(AˮA̸RA=qAA(AA=qA(AĸRA{AAA
=A  AApA33AAA=qA
A\)A33A  AffApA
ApA33AA  A  AffAA\)A
=AAHAQA{AGARAA\)A\)AᙚAzA=qAApA\)AAA܏\A33AGAȣAAQAGAffAԸRAA
AЏ\A=qA
=AϙA{AУAиRAHAљA(AHAA  ApAAQAffA(AffA
=AÙApAA(AGAHAAA  A=qApAAGA33A33A33AAffAApAAffAA
=ApAffA=qAlQA1A   @ff@  @@\)Aff@(@
AAA
A(AA A)A&{A0zA-A@A-GA?\)AQAS
AB=qA'\)A
@Ӆ@ff@=q@
=@z@ҏ\@p@A
A
pA	A
{@R@@R@G@@@G@=q@@@  @ə@@R@p@@p@=q@@@  @@@@AAdzA{AD  APA  A=qAA33AzA=qAAK
=AX  AN=qAO
ApABffAN{AQA\)AUA^HA
=Aj=qAA{ApA(AffAGAA33AGAQA(AA=qA
AAAA(AGAA\A
AQAffA{AA{ApA
AAAA\A\)AARAHAA  A\)A33AGAAffAffAB\)A
B {AARARA\)AARAA(AAffA  AAAAAffA
=AzAzAA{A{A(A\AAA{AAA(AzAAҸRAυAAHAHAAڸRAHA
A
=AHAA
=A\)AGAəAzAAAA\A(ApAGAffAzA
AŮAQA=qA(A=qA\)AQA
ApA\AřAAƣAffAAAApAzA\A=qAGA{AAHA33AffAApA{A33ApAAAffAAA33AHAAAApAA
=ApA
AAHAA(AAGAQAGAGA  A
ApAHApAGAQA  AQAzA=qARA  AA\A=qA  AՅAGAA\)AAA\)Aڏ\AA=qAߙAARA{AA\)A33A33ARA(AQA  AA\)AzARAAAA\)AAARAAA\A33AB =qAA\A{A33A
A=qA
=A(BABGA
=AApAB
=AzBAHAzA
B
AzBBAA\)AB
=A
B BBBA{AHA
BBGAA=qAA=qA(A(A(AٮA{AAzAAARA\AAA  AAffA  AA(AQA\)AA{ApA33A33AיAHAA(AAARARAA\)AA  AffAQApA  A=qAܣAAffAAffAA\)A  AQA陚AA33A=qAУAzAGAApA  A(AA\)A
AAAۙAAAЏ\A
A\AQAGA\A(AA
=AAAݙAAAHB pApB33B{B=qB GBBBBpBB\)BB\BBBffBBHB{BRBHB
A33AA  A  AA(AA  AQA
AApAAΣAAߙA
AHAAυA
=A=qAA˙AљAAzAzAAHA\)B HAA=qAzAәA\)AGA
AAAGAAApA
AA؏\A˅A33A
=AәAA
AAظRAffAAQA(AAA˙AffAGA
ARA33AHAQAAffB RB
=BHBBzB{BBB\)ARAzApA\AAA\A\AQAAA(A  A{AffAA\)A޸RA
AәAffAQA
=AəA(ApAģAA\)A
=AGAAA{AQAGAAzApA  A˅AAAzAәAGAA
=A  AQApAΣAɅAQA33A
AřApAÙA(AϙA
=AQAQA(A
AAAApA
AGAA  A  AGAQAAәA֣AAAQA
AA{A
=A(AHA  A33AGAAAffB B  AzA
AAA
A
=B B \AffAApAARAA=qAAQA=qA\)A  AָRA{A
=A뙚AAQAA  ARAzAٙAzAģAޏ\A=qAA  ApA=qAAҏ\A{AzA33A\)AffAGA33AAHA\)A{AGAzAAffApA
AΏ\AGA=qA  AA\)AAQAA
=A=qAAAͅAARAGAQA뙚A=qAA=qA=qARA
=AAAHAAAA=qAGAA\A33A{AHAzA33A\)ARA(A33A
AAHAzAA=qAA
AAGA  ARA{AA\)ARAAHAA
=AAAGAzA=qAAA
AƸRAHA\A\A  AAAzẠAȏ\AQA(AȣAȣAAУAAGAƸRA˙AHAffAЏ\AיAzA33ẠAӅAA  A  A33AHAAAGA  A\AGAffAAA=qA
AApAA˙A
=A
=A=qAA33ARARARA
AA\)ApA\)AAHAAAAQAA
=AAAAHAAAQAAAAQAQAA=qA\)AGAA{A
=AAzA\)AQA  A\)AAzAϙAA(AQAυAAA33ApA{ApA{AAAzAA
=AA=qAAApAHAHAŮAffAzA=qAffAAAHA\AGA  A¸RAƏ\AQAAGAɅAQAAѮA  A̸RAHAׅAffA  AA(ApA=qAיA{A\AA=qA  A噚A(A(AAQA  AA{Aҏ\AGA(AAA  A33AzAA33AffAÙAAQAAřAffA  AA\)AԸRAA{A׮AAׅA
AzA
=AffAffApAθRAAљAѮA(A
A
=ApAzAAGA\)A33AHAGARA  AffA33A\AHAzARAQAAAQAA(AAAHAîAQA
AGA\AAzA33AffA  Aڏ\A\)AzAAAAAיAA=qA\)AHAAffA  ARAzAAA  AAGAAffA(A  AAA(AϙAzAAʸRAA  ApAA{AffAA
AzAAHApAAGA͙AHAƸRA{AffAAȣAA{AzA(ARAAHAApARA
=A=qAHAA¸RAָRAA  AУAHAAA
=A  A\AAƸRA֏\AȀ\A(AHA
=A
=AAAA(ARAffA33ARA\)AA{A{A{AAA=qAA=qARAzAHAABRBpB{BBzB\BHB AAHA
=ApAAAzA\AA=qARAA{B(BRBB=qAABzBffBzBA\y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AffA{A=qAA
=AծAծAAٙAۅAA33AffAzApA܏\AAAA\A=qARA\)A
=ARA
=AA{AffA(AGAޣAApAA
AAffA߮A\AHA  A\)AQA
AA噚A{AA  AffA
=AAAAQA\)AA  AAAABHAAA33AHA
=AffAAApAAAƣA
AHAAAƸRA
=Ȁ\AAQAA(AzAzAУAʏ\A{AA  A  AHAՅAffA  A\)AA
AzAA\)ApAQAAGA\AzAA33ApARA
=A
=AAQA  A{AGA33AGAAߙAAAA=qA
=A
=AA
=AffA
=AA\)AQAffAHAAᙚA33ApA{AB   ApAAA33AffA
AA\)A33A{AAA33AA  AAARA
AẠAffAffAȏ\A=qA33AAGAGA  A(AљAԏ\AA
=AܣA(A{A
AAAA{A(A{AzAAQA=qA(A33AffA\AzB AGAA{AAAB33BQABHB33B
BzB\BGAHA
A=qAAA  AA{A\)Aڏ\A  AۮA(AzARA
AffA(AA{A33A(AAHA
AAAARAA
=B(A
=A
A\AA(AzAA\)AGAA{AffAأA{AAA
A
A33AARAAHA\A
=AAAAApAA33A홚AA(AA  AB =qAAGB QB{B=qB  BBBHB(BpBBB
=B33B	{B	
=B	\B
ffB	pB

=B	\B	(BB	BB=qBBBRB
B
BGB
B	  BBpBABBzB =qA
A
=AAAffA{AAHA33B(BBAzBA(AHAAAffA\)B ffBQB	  BBGA\)AARARA{AGA
=AA
A{AAB 
=ApAA=qA\)A
=A
A\)ARAApA
AzAAAA\)BffB
B
B=qBQB
=BzBBBQB=qB  BffB	=qB
HB
BB
=BBBB
=qBzBB
ffB
\BB\B\B
BRB	
=B BQB QBAGB=qB=qBzBB
=AQBB\BQBBffABARApBHBB(B BffBffBBHAA{BB AAQAAAzAA  A
=AAQA(AGA  A(AGAA
=A߮AAAA뙚A\AA
AffA\AGAAGA33AAA\)AQAAApAABB(B
=BBBGB33BQB33B\BBBpBBB(BBBzBzA{ApA
=A\A
A\ARAA뙚AffAA33AAAA\)B
=ARB\A
A  AGB {ApABQB QBB=qBBpB
=A\)A  ApAB
=BffB  A
=BRAA33AffAAQAffA33AGARARA(AHAHAHA  AA  AHApA  AA=qAAA
=AzAA\B33BA=qBffAHA(A\)A  AAGA(B B B 
=AGB BBBB	B	B	{BB(B	QB	B\)BRB(BB	pBBHAABB{BzB BBBB(BzB=qB=qBB  BRBBRB
=B\AzB 
BB\)BBffBpBffB AAA(AHAGAAAAffA33AffAQA=qAAAAHAGA
AA33A\A홚AA
AAGAGAARA{AGB ABQAAGABQBBBRB B 
ABBA\)BB
A\)BRBAzB zBBB	
=B
BzBGB\BB	HB
GB  BB\)B	33BB{B	zB
QB  BQB{B{BRB
B
HBffB
B
=B	B\)AB	B\)B\)BHBB
  B
(B
ffB
B\BQBBBB=qAAA
=AA\)AB=qBRBzBGB \AA{B B GAAQA{ApB 
B{B33B   A\)AAAAAAAApB AB=qB
BzBGBBB
=B{B =qB   B 
=BGAAB{BBBzBB{BBBHBBBGB
=B \B\B ARAGAA
A(A
A
=A(ApBBBQBB 
BpB  BRB(BB
B  BHBBHB  B
B  A33A33AzA\)AARA  AA\A33A  AA=qA=qAHAA\)AA=qARAAARAffAffAzA\)ApA  AA(AffA=qAA
A33A޸RAGAApA߮AffAGA噚A
AA
=AzAAzAA  AB\BHBB BpB =qBffAGApA
A\A
=AA(B =qB B RAAAA\A33AffB33BBffBB{BRBGBBffBQB{BB33B(B\)B{B 33A=qB=qBB\)B  AAGA  A33AA  AffAAzApApAQA
=ApA{AAߙApAA㙚A=qAGAQAA\)A(A
A33A33A33AAHAAAzAzAA{B B  BzB(BB=qBBHB{B33B\BBBzBGBGB{BBB=qB A
=A  AAA\)A(ApAffAB GABBHBpB  BB(BBBpB33BBB(B B
=B(BBBBRBB =qBQBB
B  BAAA  AGAGAA\)AzA{AGAA
=ApA=qAffAHA  A\)A{A(AA؏\AՅAGA
=AA=qAA=qA33AڸRA33A
=A{B\B\A33AAHA{B=qAAHA(AHAffA\ApA\)ARABzB=qAAApA33A(AA\)AHAAA  AzBQBApB (BB B
BBB  B33BzB\BffB{BRBBB=qB BBRBffBpBHBffBBGBHBAA33Aޏ\AAڸRAAAۮAHA{AGAܣAA(AAA=qAAAAGAA
AAApAHA
AApA  AzAAAAA=qA=qAHAA\)AGB GA\)AAAffAHAffA癚BB\A
=AARA33AHA(A\)A
=AAzA
=A  AGAA
A  A(A  AGB=qB=qBBpB
BzB  BzBB{B
B\BB	
B	HBBGBBAAA(BpB
=BHA
=A33A\A33AAHApAQA  AAA
AAA33AAHAAffAAGAA
=A
=A33A
=A  AAAAAAAA
A
=AAzAAHAA\)A
AzAA
=AB33BGA{B
=BHB(BB33AA  A(A
AAAA\AAAAQA\AAAA{AB\)B pB  B B\)B33BRB=qB{B
=BffBRB\)BBHB\)BBHA\AAA
=AAAAzA뙚A(AHA㙚AQARAAA{A{AzA癚AHAzAAGAzA(A(AffA  AAAAzA߅AQA܏\AۙAQA\)A=qAGA{A\)AA
=BB QB(AAA{ABAA
=B=qBBA\A(A
ApAGA  A\A=qAABBzBRBA=qB33BQB AGAABpBA\)BB=qBB	
B\)B\BB\)BBA
=BRBBffBB\)BB
B33BAQA
=AAHAAAGA홚AA\)AAffA癚A
=AHA  AAAA
=ARApAAAQAAHA(AA뙚AAzAAAAzAAzB B=qBffBzBHB
=BBB{B=qB\B=qB
BB\)B(BGBAA=qApAHB RAA
A{A\)AzAARA=qAHA=qB GAGAAAB
BB{BB 
=B ffB33B\)BGBzBHBffB
=BGBB
=B{B{AA(A
AA{AAAAA\)B (B 
B zAAB \)B A(B 
=A\A=qA(AAAGA33AA{ABBB\B
(BBBB\BffB
BBHBHBB
33B
BBRB
B
QB
B
\B
=qB=qBBGB(BffB=qB\)B(BBffB33BB33B(AAAGAA  B33B\)B33B33BBQBBHBBBB\)BpB	B	zB
BBBBBBB{BzB(BBBQAA\AffB   AAAB
B
B33B=qBB{B\BffBBBHB B RAARA
ApAAAffB HBB{B33BpBB(BpB{B33B(BB
zB
QB

=B(B
zBzB\BGB
=B
BB33B=qB{BB	pB	B{BBzBB{B	B	B	BHB{B
B	GBBB
BB
(BB	HB
33BBB  ApARBBB
B
BBBQB {BBGB pBQB=qBBzB(ARA{A\)A
A
A\AA
=A=qAHAzAzB B(B\)BBBBQBBABQA
A  A\A
=AA=qB{BQBB
=B	{B	BB
=B	HB  B
=B
=BBA  AzA(A{B B BB\)BB
=BB33B
{BB=qB
B	B
\)B	\)BHB
=B
=B{BAAAffBHB (BRBBB BHBGBA\)BRBzB
=BRB
=BBBzBGBHB \AAzAQAAQAA\AQAAA  AA(A
=AGAA{A(AzA=qAffAAzA(A  A
=AA(AA33A
=A
AGAAAAzAA
=AQAGAAQAGApABBBB{B
=B B 
BAB   B=qB=qARAA=qApA\A\AffBpAHAAB HB pBffBGB33B\BQBB\)B	  B	ffB
=B\)B(BBBHBBffB	B	\B
\B	A33AAA33BB{A(A(A  A
=ARAAffA\ApAA=qA
ApAAzAAffAA=qAA홚AHAAAAApA\A\AffB BB\)BB\)B	HBGBBHB	GB	B
zBB	B
QB	B	B	BHB	BGB
pBBBGB
BQBBHBzB\)BBGB
=qBffBpB
=B\B(B	  BBBGBBpB{BB=qBQB	B	B
B
=qB
33B
=BB\B(B\BpBQBBB33B
B=qBQA33BRA\AA\)AQAAzAHAA33AQA(A\)A{AApAA=qAQAA=qAA  AffAQAAA
ApAAQA=qAffA=qAAAAAHA
AAA33A\)ARABBRBHBABBzBzB  ApB(AA
AAA{A{AARA
AAffAffAQA\)AA(BA  ABB pB
BpBA
AApAA\)AAAQAQAAffAQA癚AA=qAAApAzAQA
=AAA뙚A
=A(AzAA  A
A\A\)AAHAA(AA{A  A
AAA(A\)A=qA(AAffAAGApAA
AB 33B
=B(B\)BHB
BBBBGB\BpBB=qBGB  B\B  BB=qBBBRBGB\)B33BBffBzBBBQBGBBQBpBB
=BBRBB33BB33B33B
=BBB\)B=qBBBBffB BBBQABB\)BffBBB BBBpB=qB\BBBBBB\)B\)B\BB(B=qBBBQBB33B  BB
=BGB33BzBBBRB
33B	B
BBffBB
=B(BB\AB
=BBzB{B33BB	B	  BHBBpBB  BpBB\BGB=qBBBBGBHB	33BB33BBB33BffBB  BB  BpB33BBffBHBpBpBGBB\)BBBB
AA(A(A
=BHB(BHBffBBQBB\B=qB
=B(B{BBB  B
B\)AGApA
=AQAAGBB{B BBzBffB
B\BRBAB ffA\ABHBAGBGBApApBpBpBzA  ABA
ABB33AA=qAQA  AB(AGAAA(B pBffB BB  BBBA=qAA\BzBB \AAApAA
AQAGAAARAA\)BAARA
AApAGARAAAA  AA(A33AAGAA=qBRAA\)ARA(AAHAHAffA\)AÙAAAGBA{BGAA\B RA
B
=A33AAAARA\)AAQARA=qARAAQA=qA{AffAHARAA
=A33AAffAffAA(ApAAA{A
AAQA=qAA=qABpAB(B 
=B33B
=B{BQB{BB\)BHAA\AAAQAHB AAHAA(AGARA  AffAAAAAA{AHAffAQAHAAA(AffAAAA\)A33A\)A\)ABRB33BBRBBzB\B\BzB33BQBBzB
B	zB
zB	B
QB	
=B	B	GBB
=BB
B
BBB	B
B	33B\)BB
QB=qBBB\B\B B\)BBB BffAABA(AB=qB{B	BAffAAA(A(B 
=A(AAAGAAffA(AQA33AGApAGAA噚AA33AApARA(A
=AA\)AffAGA
=AGA33A\AzAApAAAAAGAA33AAQA=qA
=AQAHAAAB BQAۅA\A{A{BpB(B\B=qA=qB BQBzBBQBRAQAAffARARAA
=A=qAAAA{BBQAGA\ApBB
=AffAA\)BB=qBQBBB  BBRAB pAzBBAAffAzAAB\)A\A33A  AAffA(AA
A
=A(ARAA  AHAzAA  A{ApApApAAA  AzA(B AA\)B (B=qBGA
BBB=qBRBffBBBffB33BpBBQBB
=BRBB(BpB{B{B
=B(BQBHB BHB\)B (BB\BHB(B
B	ffBQB  AB =qBQBffBpBB
=B  B
=B	HB	
=B	GB
=A
A\B{BpBBGB
BRB
BRBpB
ffBHB zB   B
=AAzAA
A33ApAGA{AA{A=qA=qAA33AAGAA=qAHA=qA33AAzAGAQAAA{AAA
B
BffB BAQA  BffBB{BQB RB=qB(BBB
BB(BBB(BB AAAA
AA=qAQAAA{ARAAAߙAA\AQAAA33B33B pB
=B\)B33B  AB B{ApB BA  A
=AApA=qA=qA  AAA߅AQAAAQAAA
AA
A  A(AzA(A\)AffAA=qAffA  AܸRA֣AQAA33AGAAGB B
B=qBBB
BBB33BBA
=BQB\)B B BBBBB RB A\)ApBRB A\)AAAA33AA홚ARAA33A=qAAHA
=AA֣ApAӮAzAQAGAzAAAB zBBBB

=B
GB
zB
\B
RB
RB	BB\)AGA
=B\AffAGAAzAAAAA
AzAAApAzAA=qAA
=A(B(BB\)BGBBGB (BGBBB(B	33B
BBBRBBB\)B
B	B\AQB
=AHBzAGB
=B RBBB AB B QApAffA  ApARAAffAzBRAA{BBBBQA(AffBBAQApB RAARBB  BHBGB=qB	ffB	BB	zBB	ffBpA(A
A
=AA=qA
=AGB QB B RB
=B(BBB
=B\)BB B QAAHAA
AAA  A\)AB A\)AQBpB
=B33BBRB	{B	\B	RB\)B

B

BHBffBB	(B
ffBB
zB
QB	pB	\B
\)B
=qB
  B
=qBRBQBRB{B ffB A33A
AHB\B\)B(B(B=qBBABzABB\)BAQBRBBBB  BRBBpBBBBA
=B33B\BpBQAA
A(ABBGB33BB33B33BApAA\)A
=AA\AQA=qApAAAzA  AB B=qBB\)BzB{BBB=qBBB\)BBBHA\AGAA33AAQABB RB BBzBBRB(BGB\B	{B	zBB=qBB	B	
B	B	RBBBpB33B=qBB\B\)B AAffAffAGB A\)ApAQAGA
AHA(BAQAffAA
AQAQAAA
ABB zB B B =qBBGBRBBRB{BffBBHB33ApB=qA33B 
=B \)B BzBQBA=qA(AB 33ABB\)BA{AA{A홚A
ARAffA\A홚AAA{B33BpB zAB A
=B B (B\)B  B33B(BRBffBffB\)B zB =qBB
AHBHB(B{BffB\)BffB(BQAAAARA
=A
BB(B\)BHA=qAGA  AApAB33ApA  ApAAAHApA  A\)AGA33AA홚A\)AAGA
=A\)ARA
A
A
=A(AGAAGApAHB{BB\BB\AAA33B(BQBGBHAzAGAA(AAzA
AAQA{ApAABABQB(AB {AHA=qA33AAQA  BA33B{BpBBpBQB\B{BB  B GB  AHBAAA\AB {A(AA=qAA
AAA癚A\)AzA=qAHA
A=qAAB QB A(A\A
A{AAA
AAzARAAApAAAظRAAAA
A㙚A߮AffAAAApAffA
=A33AAHAܸRA(AHAθRAABB B BBGBzA\)ABQBA  AGA=qA\A{AAAA(AHAAzARA{AA
AA
AA\)AA{A\)AAAAB\B=qBHB GAAAB{AQAAA=qAAA\)ApAHAQAARAAzA=qA\)A=qAAARARA
A33AAAA33A
=AzA㙚AQA  A33A\AAHA=qAA߮AQAܣA(A{A\AQAGA噚ApA{A=qAHA֣AAA=qA֣A33A\AQAzAA
=AA=qA(AARA
AAAA(A33ARA(A33AA(ApAGAffAAA
AAffAQA\A
BB
=BQB \A\AA{AA
=B\B33AGAAAA  A(AA  A\)A㙚A\AHA
=AAۮA\AޣAAݮA=qAᙚA(AA{AA{A\A33AHA\)A(A
=A=qAݙAܣAϮAɅAApA\)AQAʏ\AARAAǙAQAGAGA
AAHAA{A=qAA=qAأA܏\AAAHAARA\)ABBB(ARB(BB 33B {AB=qAAA(AHAGAAAQA  AQAGAApA
A
=A
=AA=qBBHB33AAAffApA
=ApAHAQAzAAffAAAA33AQA陚AHAAApAAA\)A  AGA\)AffAAAAAzAA(AAQAA{AHAA33AA홚AA\AA(A\AARA=qAffA{A=qARAAAAzAzA\)AHAQAHAzAffA33AAAAHAzAGA33AAAGAzAA(A=qA{AAA
=AARA  AffARAAAA(AARAA(ApA=qAAA(A\A=qApA
A
=A33A
=AQAAQApAծAApA=qA݅A{AGAԸRAٮAܣAAAHARAAQA=qAυA\)AApA(A{A
=A  AAffA\)AծA(AݮAGAϮAхAծA33AAׅA33ApA(AӮAzAظRA(AffAffAA33AA33A\)AA\A(AGA33AAAffA{AQARAQAARAA\AApBHBBB
=BBAGAAffAAQA33A홚A{AA
=A{AzAAQAARA=qAffA  AGA
A噚AAAzA\)AᙚAzA
ARAB B =qB  BBRAA
=BpBffB
\BffB33BzB(ApB A(A\)BHAGA=qA=qBA  A\A\)A  A33AARAA
A=qB=qB=qB(ABABABB33BGBRBB=qBBBAAB(BffB	(BGB\)B
B\BAzA33A
=ABGB\B	33BB
B
BpB \)BBGB33AAzBBQBBHBBB
=qBRB	  BB	=qB33B	33B	QB(B	
BRBffBpBBpBffB  B
=BB33BBRBffBQBRB 
=A33A
A
=AQAAABHB=qAAAAzB B \)B HB 33B(BQB zBQB
=B \)BA
=BBB
BffBBBBB(B
B(B
BBB
33BffBB
BGB
B33BQBBBBB{BBB 
B\)BB
=BB BHAAzAApA=qAARA{ARAGA
AA  AQAffAA\AHA33AGA\)A{AAGA
AAQAApAA33AB (BpB QBpB  BB=qB=qBBffBBB
BGBGB(BGBBffB=qB\)BHBBBHAffB A\A33AAAA\ApAABABBBB{BffB{B
B33B\)B ABB AzAAAffA\)AB B33BB\B(B
BAB B B AA33BB RB   ARA(AGAAHA
AAAffApA
AQB \)A(AA  A(AGA\AffB(B33BBRB  B{BGB\B33BRB
B(BzB
zB
BB
ffB
BzB
BpB
33BGBQB
HB
(BRA
=BHBA
=AApAAzA
AzApB33AB\)A33AA=qAAA{A\)A=qAAAA33ApA{AGA\)AA{AљA
AA\ARAAŮAGA33AffAA33AQA\AHAHA\)AwAtzAj{Ah(AjffAt  A{
A33A{\)AupAmAw33Av=qAlQAuGAt  A{\)Ax  A{Ao\)Ap  AlQA|QAGAGAHAffA(AAAHAAQAA  A33AApAAHAA33AA=qA(A=qAzAˮAffA  AA=qA˅A  AGA\A\)AA
AծAAAAzA£ApAݮAzA{AᙚA\)AGAA(BHB33BBQAB\AA(AzAAAAA33AffAٙAAGA  AAՙAAAHA=qA\A  AffAffAzAAAď\A{A{AzAAAQAGARAAHAAffA(AAGAAHAHAffB \)ApAHAAA
=A\)AQAzAAffA
AHApA
=AQAڣA{A{A  AAzAzAָRAffAQA\A噚AA(A\A33A(A(A
AApABRBBHB33BffB\)BB	QBB
=B
=ARARApAA
A{A  AGAAAA\)A=qA\)A  AHA
=AA
AGA
AQAAQARABABGBB {BGAARB
=B
=B 
B  BzB33B\)BBffB   BHB\)BzB=qARB {BBA(BB{ApB (B(B=qB\B{BA\)B pA33AGA
=BHB 
AA
AA  AAA{AA(AA\)B{B\BB=qAARB{BBHAffA
=A33AQAHAAHAAApA  AApA
AAAA\)AA  A=qA
=A33ARA(ARA\A
ApARA=qAGA=qA\AffAAzA
=B ffABpBBzBpBQB\B{BB
B
(B\)BBBBB	33B	B
33B
B
B  B
RB	pB

=B	BpBB{B
BBffBQB	HB
BpBGBGBBBGB QB33BRB
=BpB
=BRB\)B
BB\BBB{BffB  BBBGBpBzB=qBBQBzBB
=A\)AA\B 
=B  BGBHBHBBBpB\BBGARA\AARAQAA
AB ApA33B =qBBBBBHBRBRBzBB\BGBHBGBpB	B	=qB\)B
zB

B
(B
  B
zB	B
B

B
=B=qBHAAAأAGB (AAQB33AAHA  AzAAAffA(AB
=BQB	
=BRBHBRB=qBABQB{B\)B =qB 33AffA{ABpA  A
=A(BBAffBHB B AA\)AAAAA33A(AA\)AA뙚AffAGAA
A{A
=A뙚AA\A
=AARAAARAA
=ApAA陚AzApAA\)A{B\)AGB RB33BAGAA{A33AAA{AAffAffAffAAAAffA  AAAHAAA(AQA
AGA
=ARAQAHB AAA{A(BBARB\BB\B33B\)B{B RAGAHA\AA\)AAGA=qA\ARAAQAHAA㙚A\)AAA=qA뙚A=qApA33A
=AARApAA(AGA  AA\AHA
A=qAA(A\)AffAAAAAffA  AAA(B  B{BBBB
=BHBB	BB
B33BGBffB	
BGBB	33BBBQBBQB=qBB\B B A
=BBB{BBBARARA
=AffBzABHA  B
A\B pARB (B{BQB{B\)BpBBzBGB  BB
33B	QBpA{B\)B{BAA\AQAA\AA
=ApAAAAAAQA{AA\AA{A(AA{AApA\A\)AAQB \A=qA(A
AAAAAA\)AQB \)A(AAHAHAAAGBpB GB AGAHBzB(B 
=AAAAARAA\AAAHAAA\)AAHB \)B
=AA=qA  A(AzA\AA\)AApAA\)A=qAQA33ApA33AAAAHA
A(AAzA{AQAAHARA\)A
=B zB\)B zB 
=AAA\)B B pAAA  AA
=AA=qAA  BBGB \)A
AAA=qAAHApA\)A\A{AzAGA  AAHAAAARA  AQAAGAAApAAHBpA
=B A=qAAAAA\)AGA\A33A33AzAffA=qB
=AAAGAA
=A33A\)A
=BB
=AApB {A(AzA=qA  A=qAA
AA\)A\A33AGAAGA\)A33A33AApAGA=qAAA
A  AиRA{A
AffA33AffARAffAHA{A癚A  A(B BRA\)BpAzAAAQAAQAffA33A(A(A癚AA
=AHBABBpB  AAAB {AAHAA(A33AGA(A{AB{A=qAHA
=AAAAffAAB\AB \A
AHAQA
A33AAffA޸RAڏ\A݅AA  AAQA(AA  A㙚A  A{A\)A
AAffA=qA\)A
=AHAzAߙARA  AۙA܏\AAAAHAffApB33BQB\A\)AAAzA(AA33B  A\)ARAHB{AQAzAAAA噚AA33A  A{AAA33A=qA=qAAAAffAAGA(A
AAA\AAzA=qA\)A{ARA{B RBGA\)B pA  AAQAQAzAHA\AHA33AAA\A\ARAA\AA
A
AzAܣAңA\)AA  A(AzAHA
A{AAA{AAzA  A{ApA{ApAffA=qAAA(AAA
=A\A  AGAÅA  AzA{AAA33A=qAٙAA{AzA  AQAݙAиRA(A33A(AQAAAAAzAԣA{AApA
=AAGA{AA̸RA
=AzAAQA{AɅAHAƣAAAׅAA=qA=qAAQA  AffAԸRAHAљA̸RAA\)A33AQA\)A(AAA˅A͙A=qAϙA{A\)A
=AљAHAʸRA{A=qA
AAAA(Aď\AAGAA\)AGA33A33A  AA{AffAAApAŮAQAffA
=AΣA£AGAЏ\A{AA33AA\AffA33AӅA
=A{AzA
AхA  AޣA{AA=qA=qA(A(AAA=qA(AA߅A=qAAAAA\)AAA{AAA{A  A\)ApA
AA
=A=qAGAAB GA=qAAGA  A
A
A33AAAGAffAAHAAAA(AHAzAHAGARA=qBpAA  AGA\)BpA\A33ARA\)A{AGA
A\)AGAA=qA
AAA=qA뙚AA\)AA\)AAAAHAA(AAGAQA{A֏\AQAzAAQAAȣAApAA\)A\)AQAAAAzAHA|  AffAAzAHAGAffAAAApAHAA\)AGARA{AAAQAA=qA
AAHA\A
=AAAAAQAA
=A=qAT  AqpAuA|zAAmAApA  A
AAAGAAAAApApAʸRAAQA{AAHAAApA
A
AA  A{AA
AϙAAAzAzA
=AǮAиRA\)AAAǅA(AѮA\)AAGA{A33A=qA\AAHA=qA\)A
A\AAA=qAϮAAAffApAzA\)AGA33AA\AQAɅAΣAA33A\)AAARAAApAHAAApAA  AAAHA
A\AA
A
=AA{A\)A
ApAGAAGAA=qAAٙApAAGA
=ApAA{AAGA=qAHAGA
=AAQAAHA޸RAzAA=qA33AHA\AۅAAѮA  AA\)Aʏ\A=qAAzA͙AAQAzAA\AAQA33AAA=qA{A  AHAQA\AGAď\AAA(AHA=qAϙAͮA˅AȸRAƏ\AffA
A
=AQAAGAAA¸RA\AAʏ\AAAA(AAȸRA\)AǅA(AzAˮA
Aʏ\A
=A33AGAÅA\)A{AHAAAAA\AGAzA
=AAA33AA  A{AAA{AA\)AAAA(A\AAzAzAffAͅAQAGA(AAffA£AƸRAAƏ\A˅Aޏ\A\)AܣAAzA  AHAA33AAƏ\AGAA(AAHAHAGAzAA
A(A
=A
AѮAՙAAHAAGA=qAڏ\AܸRA
=AۙA  AA=qAA  AA33AԣAȸRAAffAA
=AzA(A=qAApAAGAffA
=AHA(A{A£AAGAمA
AzAGA(A\)AA\)AAA{A\)A33AAAQA=qA\)AA\)AAAHAAzAGApApAAHAAAAzA噚A  AޣA\)AAƣA  A=qA33A
=AʣAA33A{A(AAA=qA{AՙA
=A33A˅AȣApAA=qAAÅAřA  AQA  AHA\)AԣA뙚A33AA
=A33ARA\)AHAAAApAɅAřA{AAA
AQA\)AA{AAA
AB   A=qAA{ApARA
AffAAAAAB B(A=qAA
A=qA\)BpA
AGB ffAAzA\AAAA
A
AAAAzAAffAAAzAHAAzBAB 33BAA(AޣA
AGA{AՙAffAڣA33AAzAAHApAAA(A(AHA=qAA=qA{A
=AQAAAA
AA=qAܣA33A(AA=qAHA
AAGA
=AAA陚AARB 
B	HB
=B
B	ApA33B  BA{A(A{AQA=qAA\)A\)AAAAffA=qA
AzA33A
AAA  AffA  A陚A  A  A\AA
=A\A  A(AzAAAQA33AۙAzAAffAzAA=qAA\)AARAHA\)AAHAHA33A
=A33AHAA=qApA\AHAGAA33AAHAGAA=qA{A\A  A{AA33AQAУA\)AQA\)A(A
=AzA\)A(AAGAQAA=qABBGB QAHAARA33AQA(A  AAAA\AAAQA{A33A\)A{A  AARARAA\)AAA=qAAAzA(ARAAA33AA
B AA=qA(AAхAA  A
AָRA33A{A\)A\A\AApAHA
=AAAGApAA\)AHAffAأAQA=qA=qA
A\)AA뙚AAHAAAAA=qAAA=qA(A
=A
A
ApAA(AQA{AA
=ARA{AΏ\AA(A  A
=A
=A߅AA  AQAQA͙AAffAAGAAޣA(AQA=qA=qA=qAAffA\)AGAAHApApA
AڣA
AܣA{Aڏ\A݅AA
AAAffApA=qAffApAׅA{AAAA33AՙAzA֣A
AGA  AHAGApAׅA33ApAAAϮAθRA\)AӅAәA=qA33A  AGAAA33ARApA癚AA׮AأAGA
AǙAAA(AAAAAHAA33ARAGA  A  AQAHARAHA֣A
Aޏ\A  AA=qAٙAA
AHA  A  AHApA  A\A=qAffA  AAQAHAAAAA
=A홚ApAQAQA\AA{A
A
=AA\)A=qA=qAA  AAzAA{AٙAQAGAAQAޏ\ApA  A=qA{AA
AQAAffB=qBQA33AzA홚AA=qAQBBffB  BHB33BzBA
AAGA
=A=qA\)AQAzAHA(AAzA\)AA
=ARAAzAGARA{AffA(AA\)BRApB \B GBBffB33B B  B
=A(BB(B
BRB33B zB B BHBBGBBRBB33AHB AffA
BB 
=A33AAA(A  AQA
A
AAAQA
=AA\)A뙚A\AHAAHAA\AA\AzAA=qARARAA  A
=AAAAAARA\)AAAGAHAApAAQA
AGA(AA  A=qAzAA
=ApApAAzAQA
A33A(A(AAAAGAAzAA  AffBRB AGAB
=AHBB ffABzABpBffB\)BpAAAA\AAQA33A=qA  AAB =qAGA\)AA\AHAA
AAAQB GB 
=B (AAQB  A33AA33B BffA(A=qA33A=qBB\B
BpBHBHB 
B\)B{BB  BB\)B{B
BQBB
=A
B B 
=ARAzB B
BBffBBB A=qA{A\AA(AGA
=AA{A
=B  B
BQBBBB(BffB
B
=BBBB(BpBBBHBHBHB{B
BB  BRB  B 
AAA33A  AB B pB(B\)B\B(BpBffB=qBpBBGB=qBB
BGAB ffAHB\BBQB\)BffBBBBBB  BBGB  BGB  BRBpBBBBHBffBffB33BBzB=qBHBBRBBBBffB\AAHA
B BBQBffBB
=BzBHB33BffB=qB
=BB
=BBGB\BpBBzBffBBBBBB
B(BBBpBBHBB{B
=B\BQBB
BffBQBQB(BffBA\AzBBBGBffBB
BBGAGA  AGA\)A\)A=qA33AA=qA=qA\)A
BQB
BB\)B=qBQBHBQBB	B
{B	B
33B	B
33B
GB
\)BB=qBBB\)BzBpBBB zAAAARAA33A  A33AAAA{AAAA\)B (B BBB=qB(BffB  BRBB BpBffB=qBQAHA
B(B(B 33AAAAQAA=qApAAGAAffARARA{AzA{A
=AAAGA
A
=A  AمAHAAA=qAA=qA\)AAGAA(AAzA=qA  A{A
=A\B BpB
=B  B GAA\)AAARA
A33AAApApA  A
=A
AAA㙚AA
=AGAHARAQAAB 33BBBQB\)BB 33AARAQBB33BBB(B=qB\B(B
B (AzAA\)AAAAB  B ffAARAA\)AHA\)A(AAAffAARAA\)A\AzAzAAzAAB B pA{A܏\AAA33AffA\)AAA˙AffAHAHAAAGAAGAffAAHA홚AAzA
=A\)AGAzApAffA
=AAHAA
A陚A޸RAA߅A33A
A\A
=A33AA{AAڸRAAHAzAAQAHApA  AHA  AA33AAA
AGARA{AA{A(AzAAAzA\)AA(AיAffAߙAzAAHAA{AQAGA=qAzA  AAAָRAGAA
AңA\)AAzA؏\AQA  A  A
AzA  A=qARAffAQA(AA\)AAA\AA  AAQAHAAzAAA33AݮA
A  A=qA
AQA=qAAGA  AA뙚AAzAA\AAApA
=A뙚ARAAA{AAzApAAA{AA(ARA33A{AA33AQA33A  AzAffAffA33AA
A
AQAAAffAAAzA{A(AA\)ApAAٮAיAzAٮAAA  A
=AAzB QBAA\)A
ApAHAA=qAA=qAffARA33AA{A  ARAAzAAA\AAzA(AƣAAzAffAAGAffA=qA\AA
A33A  AݙA  ApA
AGAA
A33A
AAffA\AA\ApAӅAA33AԸRAzA{AAAޏ\AAڸRAޣA
=A
AGAߙAAQAzA33AGA=qAAAAA33A=qAzA=qAA=qA\)A33A
ApAٮARAzAQAA(Aڏ\AڣAGAAAffAA=qA(A{A\)AAA\B GA\A\A(B A33AAffAGA  A(AAA\A{AA=qAffApA\)A33A  AHAApAAQA
A{ABffAB\)A(AzAAAQAARAAA(AHA33ARApAAApAQAA{ARB(BGA\)A\)AA  ARARAA
A(AzAA(A噚A(AAᙚAAͮA
=ARA=qA=qAAQAAЏ\AGApAHAA{AAB HA=qAAAGA\)A{ApA\B
AzA
B
=A
=BA=qAAGAHAAGApA
=AA\)A  ABQAQApAAA
=AffAGA\)AA\ARAA(AAAGAA
AHAB A\AAAzB ffA{BQB {BB33BzBAAApARA
=ApA(A
=AzA(AAAAAAffAzA\AAHA㙚AAޣAA=qApA׮A  A\)A\)AA{AAA
A  A
AB\)AA33A=qApAAB33A
=AffA(AzA{A(AAߙA
=AA
=AۙApAA
AzAA=qApAՅAAۙA  A(AQA{AA
=ApAA
=AAQAA
AAB pAAA\AA33AAAzAAAУAQA(AAڣAQAأA{AAGA\)AA
=A(AzAHA{AA
A(A\AA
A=qAHAA33A  BB AGAA\)AA
AA  A{AAAAA(A\)BGBBRBB\)BABA{BBGB 
=AA  AA{AAAA33ApAA\AHAffAffAAA\)ApA\AffA=qAA
=A
AAB 33BBBRAApApAAAGA{A֏\A(AffAAA(AAAAAA
AA\)AAHA=qA
=A{A(AzARA(A
=AQA  AHA  AAAGB=qAB A\)BHBpB HB
=BzBffB33BBGB(BRB33BRBBB
=BHBBBB	GB\B(BffB	QB=qBB\)B\)BGBQB\B BB
=B33BB 
=B
GB	  BffB	B=qBB\B33BB  BHBA{AAAA(BB	HBBBGB	B  B(B
=A\)AAA{AAA
B
BRBBB=qB zAAAQApAA  AAB 
BB \)ApB BRBBpBHB33BA
=AAAApA\)A\AAzAAAAᙚA  A
AARAϮAQAzA\)A{AHA\AffAB =qAA
A
=AA\A(A\)AQAGAAHAHAAzAAAGA\)A  AzAA=qApAARA\ARAQAׅA(ApAzA=qAAӮAHAA{AzA׮AׅAffAHAAffAGAAAA(A
=A߅AAQA\)AGApARAޣAzA  ARAظRA\AQA=qA{A33A\)A
=A{AQAAGA
=AGAQAzAAAffA
AхA  A(AׅAA\)A33AAA\)AA\ApAffA\)A\AA뙚A\AAAAffA33A\)A{AAAAA33AAQAQAHAHA  AHAAA=qAA\)AᙚA=qA
AQA{A
=A癚AA(AA=qAzA=qAGAGA=qA߮AHAffAߙAGA
=A{A
AA\ARAGAܣA33AQAGAzAzAQAхAA33A=qA33AAA=qA{AQAAAA\AA
A\A
AHA
AAAᙚA33A
=AA\AApARAA33AA
=A33AAA癚AA  A\A33ApA{AAHAGA܏\AA=qAAA
=A
ARA޸RA{A=qARARAA  AHAAGA=qA؏\AffA\)AA33A  AGAffAzA  A߮A
=AAA(A{AAHAAHAߙA\)ApA(A
AAAAAA33A=qA\AGARA\)A
=AA(AA
=AApARAAQA=qAGA33A{AAA  AA\AffApAAffA33A\A{A  AAA\)ARAQApA  AAA{A=qAA33AA
=A=qAGAARAA33A33AA(AffA=qAA(AA=qA\)A{AAᙚA
=AAAQAGA{AAA  AHAA=qAApAAQARAApA{A{AAHA\A  AzAA33AffA
A
AQAAڸRA
A޸RAAA
ApA33ApA
=AȸRA\)A
A  AAGA(A؏\A33A
A\AHA{AzAQA(AΣAQA33AۮAᙚAܣA  AA߅AAA׮AffAGARA  AA=qA
A{AAGAA{AȣA  AA\)A
=A{A
AHAzAGAA{AAHApAA{AARApAAzA
AəAGAQA{AzA33AQA(A{AARA\AƸRAAHAřAffAAAAApA=qAəApA
AAAHA{A˅AA(A=qAHAAظRAQARAAҏ\AGA=qA
ApAAď\AՙA(A{A{AzAAA  A
ApA  AAAAA{AAAffA=qAHA33ARAGA  AQA\)A33AAAHẠA\)A33AAffAA=qA\)A\AffA  A
=AzA=qApAzA£AGAîA  AɅAGAȸRAǙAAəAAAǙAAffAQAAĸRAzAÅAAffA\AGAffAzAA\)A\)AGA  A  A33AzAQAA{AAAARA\)AAQA\)A
=AA  A\)AffA{A(A؏\AָRAHA噚AQAٙAA=qAУAzAHAQAAԏ\AAffApAGAA  AQApAԸRAffA  A؏\AQAffA噚A  A(A\)A
=AڣAHAGAAǙAA
AzA\)AGA؏\A(AۮAۮA֣AApApAAمA{Aޏ\A\)AHAGAffAA\)ApAA\Ȁ\AиRAHAAÅAѮAAڣAAzAAϙAGAHA\)AəAGAAǮAA
ApAQAQA\)A߮A߮A{AڸRA\AA(A33AAA{AA
=A(A33A뙚AGA(AA\)AzARAAAAAA{AHAAAGApA\)ApA
=AA(AQA  A\A{A
AffAA
ApAA\A
=AARA=qApA{A
AHAzAAzA(AAQA33ApApAٙA
=AHApA\)AQA{A\)AAA噚AAA
=AAGAAffAzAGA
AAB AGARAAAARBAAAB
=B{B BQB
A
=B(AAAB   AAzAAQA\)B BpB B 
B B \)B RBQB33B
B=qBRBBB33BAA(AA\AAARAzAAGA(AB \)AAB GB{AB B  B B\B33A=qBAGA
=A\)AHB
=B  B BBffB\)BB{B  BRBBBffB
B{B(BB
=B
=BBBffB
=BB(B \B ARB\)B
AffA\A=qA
=AB AB B(BB{B BB=qBB
=B  BffBBBB33BQBBHBHBBBzBBB
BBBBBBB(B  B\)BGBffB\BBBRBpB\)B{BBQBB(B B  A\AHAA  AA\)A
=AzA=qAQA{AAffAffA  AAAAA\AAA(AA  AA=qA
=ARAA
BGB AA=qAffB B(BpAB  BA\BBzBGBB{AA
ApAAAAAAzA\AAAAA\)AAAQA=qA{A  AffAAffA33AffAAGAA  AGA(AA  AA\AAQA  AA  AAGARAHAA(AGA
=A\A=qARAAAGA=qAffAQAAAAA
=ApAAA=qA
AzAA  B HAffAGAHBA{B B pAB zBAB 
=BQA
=ARA33ARAAffA
=AAA=qAHA\A
AA  AGABB =qABB=qB33BA=qBBAA\ARA
=AAA{BA  BB GApAAARAA
AApAAAffAHAARAzAAAAGAAAAAQAAQA33A\)A{A\AAA
A=qAAQA\AffA(AAۅAAͮAՙAAGA߮A{AApAA
=AAzAڣAᙚAA{AA(AA33AzAHA
AA33A
A(A\AffAffAApApAzA33ARA噚AGAߙAAݙAAzAffAAA33AAA\A\)AffAA  A=qAAGApA=qA\A  AA=qAA陚AHAAHAA߮AAQAA\)A
=A
ApA  A  A33AQA  AᙚA  AzA(AA
AApA=qA
AAAGA\AHApAAQA
AAۙA  A33AA  A(ApAA
A
=ApA=qAAA(AAAAzA{AffAA33A\)ARAGAQAzAAzA  A=qAAARA
=A\ApA(A(AGAA癚A
=A\AAA{AA{AA\)AffAffA=qAGAzA\)AAzARAzA
A陚ApAAAۮA
A(A{A33AAޣAQAA
=A(AHAA33AzAA\A\)ARAA33A  AAAAAB (B \ARAGA  AHA(A\ApA  A(AAA\AAffB B QA33AA  B
=AzBGBB A33A(B33BBBQAAQAA=qAAzA\A=qAzAA(A\)AB   ABB\B 
=AAARAA{ARA  AHAzAAA{A=qAA=qAAQAA
=A33A\A=qA=qA33ARAAGAA
A{A
AA{A(A\)A\A  A
=AAzAA{A\AA  ABHBAAHAAA(ARA\)AAAGAAA  B BBAᙚAA(A33AA\)AAQAffAGApApAAAAA=qB 
BB zB(BGA(A
A\)A\)BzBB\B  BHBAARAAAA\AGAAHAA(A33A\A=qAQAA{AzAARAQARAffAA  AA{AAAA{A33A=qAzA=qAAA
A\)A33AA33A33AAHA{A
A{AAffAA{AffBAHAHAA
=A
=AA
=ApAA33A\)AAAAAAA{AA\AA  AQAGARAAAAAzAAARAHA(A=qA(AAA\AB ffApA\)AA{A
=AffA
=ApAffAAA홚AAGA  A33A  AA{AffAARAA
=A33AHA33A=qA\AᙚA\AzA33A\AzA
=AAAAAA{AAAffA\)AAAB B A(AGAQA(AB 33A{A
=A\AffAQA
AffAAAzA(AAAAAHARAQA
B GABzA(AAA
AAGA\)A\AGAAAAAQAAAAzAA(AzA33AAffAA33A  AAAA  AQA  ARAA33A{AAAAA
A
A{AHApApA=qA  A33A  A33A
=AApAAGA{AAQAAAA{AHAǮAٙAApAAA\)A33AAffAA{A(A  A
=A\)A33AA=qAAAzAHAzApAffAAA
=A\)AzAAA
=A
ARAAՙA
AAAHA߅AzAAQA\ApAzAAA  ApA\A
AٙA=qAAҸRA
=AzA{AffȀ\A33AApAA  A=qA{AffAҏ\AGAA  AŮA=qAϙA\)A
ApAA\)Aȏ\A˙AAGA\AQAGAzAA(AQAޣA
=AAAAzAۙAAzA(AA\AARAᙚAA޸RAQAA܏\AA
=A
=AAGAA޸RAAHAzAA33AAᙚAAAA噚AGAffA(A{AHAGA\ApA=qA33AA؏\AGA(A
AGAәAA
=AGAzApA׮AљA(AظRApA(ApAGA{AۅAzA{A噚AARA=qAAأA\AAHAA\)AAffAAGAQAA(AHA\)AA(A\A=qAAA
AAʣA
=A{Aȏ\AAřAA\)AAAAA˙AA\)AAffA  AϮAzA33A  A
A\)AffA33AAffAA\)AQA
=A(AAAAA(AA뙚AQApAAGAAQAffAAA33A(A㙚A  AAޣAffA{A{A
=AffA{A=qA{AffAAApAɮA=qA=qA(AAޣA\)A߅AӮAQAAՙAQAHA
AəA=qAӮAA  A׮AәAA؏\AAأAQA=qApAffA=qA{AA  A\A=qA  A{AAAApA\)AAA=qA\)AzA\)A\)AAA
=AzA{AQApAAGA뙚ApARAARAffApA\AzAGA(AAffA\A{A33A(AARAAAAA
=A\)AApARA
=AHAARApAA=qAA
=AA{AGAA33A\)AzA  ApA(A
AA  ARAQApARAQA
AffAB GBB
B =qAffAARAAA  B (A
=ARA=qAHB BB 33B  AA{AAARAGAAAA
AA
=AA\)ApA\)AzAAAzARARB=qBB pAB{B GBffAzBBBApBBzB{BffB QA33A(B \)AAAA
=AAAAffA\A\AApAAARAA  AAA(A
=AA  AzAAHA
A\)AzA  A
=A뙚ARA(A{A
AApAA33AA\)B 
=B BffB=qBB=qBBB33B{B  BzB
AABAAB zA{AQA
=A\AA  AAA
=A{A=qA{AAffA  A\)B \B (BzB B A33AffA{AA  AAAAAAA(AA\AA\ApA\AHA=qApAAA(AQAAzA\A33ARAHA  A
A\)AffAA(AAAAA
=A=qAԣAԣAׅAffAzAHAApAzA
B ffB \)BBB\)B{BGBBB(B B AA
AB\B AQAzAAA33AzA
=A  AzAA  A\A
AffAARAQAAAAzAAzA=qAQB=qB{B AGBB\B	B
BA
=ApApAHARA
A  A\AAzA{AA(AHAzAAAA\)A\)AffAA33A{A홚AAA\)AAA
=AA(AzA=qAAzA=qA(AHAABHB {A{BBBBRA
B
=ABHBBpBBB\)B{BffBRBBQBBpB\)B33BpBHBBBBB
=B\B
BRBQBBRBRBB=qB
BzBB\)BBBzB AzBBQBBHBB\BB=qBB{B\)BffBRB B B=qBGB AQA=qA\)AAzA33AHA
AHARA\AA
A
=ARA=qA(A\)AAA{AzAQAGA=qA33A\ARAB\B
=BffA
=BBBBHB	BBQBpBBBBBRBHB\)BBHB  BB=qBB
BB\)BB  BpB(BRBB
BBRB\B\)B{BzB\)B AAAAAHBBQB=qB=qBB
BQB
=BB\BGB(A
=AAHAAA  A(AAA\)ARAAA{A  A
AA
=AGAA\AARA33AA
=AAAffAGA
ApARA=qAB=qB B=qB
=BpAARB  B33B 33B AB GBQB
=BQBBBBB
BpB
{B\B	33BzBB=qB\)B\BffBBBBB AzA33B
=BABB  AB HAzAAAAzA  AGB
B AHAffABB(A33B HB QB pAA33AAAAQA
A\)A
AffA홚AAA
AA  ARAQA\)AA{AHA
=AffA=qAffB \)A
AAAHAGAARAAAAzA\AQA\)AA(AQB33B
=BB=qBffB{BB(BGBpBpB\B  BHB
=B (AA{AApAA=qAzAAB AB(AAffB(BffBzB\BB
B  AGBGB\BBHA
BAHB
=A\ARA  A  B A  B B 33AARAzAA
=AQAHAB QAA
B B AAAA=qB RA=qB \AffB \B  BBRB=qBABBHA\AQAA=qAffA\AB ffA
A
AffAA  B\BpB  BffBQB33BBB33B BzB=qBB
=BzBpBB
B  B\BHBQBBB=qB
B\B\BBB  BB(B=qB33BHBBB\BpB(BB =qBGB BA{A\)AB HB
BzBHB{BBBBBffBRB\BBzB\)BBB\)AB 
=BB{AB=qB 
=AHB\A  A\)B  AA\)A֣BB=qB\)BffAGAAffAB B
=BpBBzB  BBQB{BB\B(BBGB\)BABQBB
B\BRBB(BBHBpBBffBBB  B\B
=BBB
=B33B  B\)B\B\)AABBB=qB=qBHB
=BB
B=qBffBA33BGB\BffB33BBffApB BzBB33B{B{A33BpAGBBQBRB33B
=B ApB   AHB \)B   A{A\)A
B AA=qB \)A33B AzB 33BQBBHB\)AB  ARAAB\BBzB\)B(BGB  B 
=BAB BB
B\BB
=BB  B=qB BQBB33B{B
=BRB ABApBBRBB 33BB=qBQBBB\)BQBBBzB\B (B HB\BRB 33B AA\)A\)A(AAA
=AARAA\)ApApARA=qA
AA{A{ARAAB   B {A{AB=qB\)BHBApBGBzBRBAffAB
=BAB
B ffB(BA=qAARA\A
=ABB=qBBGBAB 
AA
AAAffAzBB ApB
=B
B
=BBB{B=qB 33AAzB  BffBzBBB
=B(B  BBGBB{B GBGBpBQBBpB\BA33AAGAA  AAHARARAٮA  AA(A(AAffA
ARA\)AffB A33A\)AAA\)AAHAzAA{AAffAAAB   A\)AffA(A=qA{AAQA
ApA=qB  BzAGB
=BBABBB=qB 33AA
=AA
AAAAAffAA\)A\A\)A\)A
=A\AffA
AGA(AAA
=AzARA33A\)AAAAAAHA\)A(A
=AzAA33A\)A\)AAAARAAA
=AAQA(AQAAffARAffAA
AA(AAzAA陚A=qApAffAAffAHAA(A33ApAAzA  A
=A
AAffA33ApAGAHARAAzA뙚A  AA܏\AQA=qARAAGA
=AAQA\)AARA33A癚AGA陚AAAARAAffA\A(A=qA=qAQA\)A  AzA\AAAHA
AHA߮A
AzA(A
AAAAA
=AAڏ\AA{AHAAffAA33AGA
=AQA
=AHAzAffA
A=qA{AٙA
A(AA\A\)A
=AQAHBBAB
B{B{BB
=BB33B {BAAA  AB 
=B 33B pB   AB BB\BB\)B  B\)BzBzB
=BB\BBB  BQBBpBB33B=qB{A
A33BRARB GB BHB(B AB AffA(B
=AA{AGB(AAAA
AAAAzA߮AAQA  ApAۮAzA(A{A
B QBBRBpB 33B
=A
B\)BRBGBBQB
=B=qB
B
BBGBRBB\BRAzA
AB  B\)BB=qBRApB=qBA{AAB33BB\)BB
B=qB(B
=BffA\)B33BBBGAB	BA33AGAA
=BGAAB(BB33BB
(B(B(B
\)B
{A(B	A(BRB33B
=B
33B
BBQBGBffBzBRARAAGB\)B(B\BA.ffAffAff@AA33@ffA  AA@A33A   A@33@33@陚@ff@33@ff@33@@33@ff@@y@ff@33@  @ff@ff@  @@  @@@ff@@ff@ff@  @@33@33@  @33@y@@  @  @ff@@@@@33@@  @ff@  @33@@ff@ff@  @@  @ff@@ff@s33@s33@33@Y@s33@S33@ff@@@@  @ff@`  @l@@  @9@   A@`  @  @@33@  @  @@`  @L@y@`  @`  @y@ff@  @@33@33@  @@  @&ff@Fff@33?33?ff??@@@9@   ?33?33@ff?33?ff?33@&ff@333?33@y@@@,@9?  ?ff?  ?ff?ff?33??33?ff?ٙ??ff@ff@333@333@  @ff@  @L@ff@ff@l@@L@9@&ff@?ff@@   ?@@33@ff@   @333@s33@Y@   ?ٙ@ff?ff?ff??33?ff???  ?L?L?fff?fff?L?L?L?fff?  ??ff?ٙ@33@   @9@@  @Fff??@ff?ٙ?ff??  ?  ?fff?L?333?fff?333?333???ff?@L?  ??ٙ@   @   @@  @S33@33@ff@ff@   ?ff????ff?ff@  @@y?33?ff?33?  @33???  ?fff?333?333?333?fff?   ?fff?fff?fff?333?333?333??333?L?fff?ٙ?@   @ff@33@Fff@Fff@9@   @   @@   @@@   ?ٙ?@??  ?33?ff?fff?L?333?333?L?  ?ff?  ?ff?  ?33@33@   ?ٙ?ff?ٙ?33@   @s33@   @@  @fff@S33@@L@fff@,@Y@333@,@Fff@@@&ff@333@   @33@&ff?ff??@&ff????fff?  ?  ???ff?ff?ff?ٙ??  ?ٙ?ٙ?33?ff?ٙ?ff?L??  ?33???ٙ??ff?ٙ?33?33?ff???  ?  ?  ?  ??ff??ٙ?33@   ?ff?ٙ?  ?????  ?  ?  ?  ?  ?  ?  ?ff?33@   @   @   @@?33@Fff@ff?ff?  ?33?  ?ٙ@@@33@L@fff@?@  @?ٙ??fff?fff??333??L?L@9@@  @@&ff@&ff@ff@s33@,@@???ff?33??  @?ٙ@   @&ff@9@33@&ff?33?ff@L@fff@L@?ff?ff@   @33@   @@33@@&ff@33@y@s33@fff@L@L@@  @333@9@S33@`  @fff@`  @,@?33?33?ff?ٙ??  ??  ?  ?  ?33?  ?  ?ff??ff?ff?ff?ff?33?33?33@@ff??33@   @@33@   @&ff@y@@  @&ff@   @   @,@   ?33???  ?33@333@333@ff??fff@   @333@   @9@   @@9@33@@&ff@L@,@Y@&ff@   @Fff@9@`  @y@y@333??333?333?ff?33@L@33@@  @S33@S33@@  @9@@  ?ff?  ?ff@ff@ff?ff?  ?ff@ff@ff?33?33?33@   @   @33@@@@@@   @   @@33@33@33@@33@33@33@@@ff@33@@@ff@   ?  ?ٙ?33@ff@   ?ff@ff@33@@Y@S33@@33@ff@   @33@33?33?ٙ?ٙ?ٙ@   @@33@   @ff@ff@   ?33@   @   @   @   @   @ff@   @@   @@   @   ?ٙ?33?ٙ??33@33@&ff@@@,@&ff@   @&ff@@@Y@fff@Y@`  @9@9@   ?ff?ff@ff@ff@ff@   @ff@ff@@@   @   @@ff@@@ff@   @   @@@ff@ff@   @ff@   @   @ff@@@@&ff@33@@&ff?  ?33@ff@&ff?ٙ@&ff@33@S33@@  @,?ٙ?33@   @   @   @ff@33@ff@ff@@@ff@   @   ?33?33?33@   ?33?ff?33@   ?33@   @33@@@@   @?@?ff?ff?ٙ@ff?  ?33?ff??ff?  ?33??ff?33?ٙ?ff@33@   @333@L@9@33@33?33@ff@@@   ?33@   ?ff??ٙ?ff?ff?33??ٙ?ٙ?  @ff?ff?ff@33@   @33@@@@   @@33@&ff@,@&ff@   @@  @@  @333@333@   @   @   ?ff?33?33?ٙ?  ??33??ff?ff?ff?33?ff??  ??ff?33?33?ٙ?ff?33?fff?ٙ??  ??33?33??  ?ff@ff?ff??ff@ff?  ?ٙ?33?33?  ?  ?  ?ٙ?ٙ?ٙ@ff@ff@33@@,@,@&ff@Fff@?ٙ?fff?333??  ?   ?333?L?fff??????ff?ff?33?33?33?ff?33?33?33@   @33@?33?33?ٙ?  ?  ?  ?33?33??ff??33?  ??  ?  ???fff?33??ff?  ?  ???ff?  ?  ?ff?33@&ff?33?ٙ@,?  ???ٙ?  ?  ?33??33??33?ff??ff?ff?33?ff?ff?33?ٙ??33?ff?ٙ?ٙ?ff?ٙ?ff@?33?fff??  ?L?  ?33?ٙ?ٙ@   ??fff?  ?fff?fff?L?fff?L?L?fff?  ?  ??ٙ??ٙ?  ???  ?ff??ff?ff?ٙ??@ff?ff?33?ff?  ????????  ?33?33?ff?ff?ff???????  ?  ?L?  ?fff??  ?ff?ff?  ?ٙ?ff?33@&ff@ff?33?33?ff?33?ٙ@33@   ?ff?  ?ff?  ?ff?33?33???  ??  ?  ??  ?  ?  ????33?33?  ???ٙ???  ?ff??  ?ff?33?ff?33?  ?  ??ff??  ?  ?fff?L?fff?  ?fff?fff?  ?fff??????fff?  ??  ?????  ???  ????  ?  ?L?L?L?fff?  ??  ?ff???  ??  ?ff?  ?ٙ?33?33?  ??@@   @333@,@&ff@@Fff@333@33?33@   @   @@?33?ٙ?@ff@@   @333@9@@  @ff?  ?  ?L?fff?L?  ????????ff?ٙ@@33@@&ff@   @333@@@   ?ff?ff@   ?33?33@   ?ٙ??ff?  ??  ????  ??  ?ff?33?33?33?33?33?33?33?33?ff?ff?ff?ff??  ???33??ff??ff??33??  ?  ??  ?ff???  @   @@@   @33@33@@&ff@   ?33?33?33@33@ff@@   @ff@   ?33??  ?fff?fff???333??333??333?  ?ff?ff?  ?  ?33?ٙ????ff?33?  ??ٙ?ٙ??  ?ٙ?ff?ff@ff?ff?33??  ????ff?ff??????ff?ff???ff??ff??ff?ff????  ??  ?fff??  ?fff?fff?L??fff?L?   ?   ??L??333?fff?333?333?L??L?fff?L?fff?L?fff?L?fff?fff?fff?fff?L>?   ?   ?   >>>??   ?   ??333????   ????333??L?333?333??333?????333?333??333?333?L?L??fff?  ??L?fff?L?L?fff?L?L?L?L?L?333?L?333?L?L?L?L?L?333???333?333?fff?  ??  ?  ?  ???????????  ?L?  ?fff?L?fff?L?333?L?333?333?333???333?   ?   >>?   ?   >>?   ?   >>>>>>>>>>>>?>>>>>>>>?   >>@Fff>>>>????   ?   ????   ????   ?   ??   ?   >??   ????333?333?333?333?333?333?   ?   >?   >>?   >>>>L>?   ?   ?L?   >>?   >?   ?   ?   >>?   >>>>>>>??333?L?L?  >>>L>>L>>L>L>L>L>L>>L>L>L>>>>L>>?   >>>>L>>>>?   >>L?   >>>>>>>>>>>L>L>>?   >>>>>>>>>>?   >>?   ??   ?   >?   ?   ?L?fff?L?fff??333?   >?   >?   >>?333?L?L???  ?L?L??333>>>>>>L>>L>>>>>>>>>>>>>>>>>?   >>>>>>>>L>>L>L>L>L>>>>>?   ?   ?   ?   ??   >?   >>>>>?   >>>>>?   ?L??  ?ff?ff@   ?  ?ff?33?33??ff?33??  ?  ?333?333?ff??L???fff?fff?L??ff?33@   ?  ?fff?  ??  ?L??   ??   ?>?>>?   >?   >>>>L>>?   ??L?   ?L??333?????333??333??fff?333?333?333?   ?   >>>>>>>>>>>L>L>>L>?   >?   ?>>>?   ?   >?   ?   ?   ??333?333??333?fff??33?33?fff??L?fff?33?ff?ff??>>L>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>@?   ?   ?   >?   >>L>?   >>>>>>L>L>>?   >>>>>L>>>>>>>?   ?   >>?   >>L?   ?   >>>?   >@   >>>>?33??   >>?  ?333>>?333?L?  ?L?>?>>L>>>>?>>>>>>>>=>L>>>>=>L>>>>>>L>>>>>?   >L>L>>L>L>>L>L>>L>L>>>>L>>L>>L>>>>?fff>>>?   >L>>>L>L=>L>L>>L>>@>>L>=>L>L>L>L=>L>L=?   >>L>>?   >>>>>>L>L===    ==        =>L    ==>L>L>L?>L=>L>>>>>>>L>>>L?   ??   >>L>L                        ===    =    =    =    =                =>L>>>L    =    >L?       ==??L?   ??fff?  ?333>>L=>L=>L>>L    =                                                                    =?   >>>=                        ?   ?333?  ?L?333?L?L?   ?fff?fff?  ?fff?L?333?   ?   >>?@9@&ff?ٙ?ff?ff?  ?fff?  ?L?L?fff?fff?ٙ@   @?33?33?ٙ@33@9@@  @ff?33?ff?????33?  ??ff?ff?  ?ٙ?ٙ?33@   ?ٙ??33?33?ff?33?ff??????????ff??33?  ????ff??33?ff?33?  ?  ?ٙ?  ?  ?33?33?ff?33?33?ff?????????fff??  ?33?  ?ff??ff?ff???  ???ff??????????ff?ff?33?ff?ff?ff?ff??????  ???fff?L?  ?  ?L?fff?L????fff?  ??L?L?   ?333?333?????   ?  ??33??  ?  ??  ??  ????ff?ff?33?ff?ff?ff???ff??  ??????fff??  ?fff?fff?  ??  ?fff??  ??ff??ٙ?  ?33??33????ٙ?33?ٙ???fff?333?333?333?333?L?  ?  ?????fff?L?fff?L?fff?333?L?333?L?fff?fff?L?fff?fff????fff???  ??L?333?L?   ?L??>>?333??   ?333?333?>???>>??   ?   ?   ?   >>??333??333??   ??   ??   ?L??ff?  ?fff?L?L?333?L?L?33??333?L?????L?333@   ?  ?33?fff???333??   ?333?333?333?333?333??333?333?333?   ?   ?   ??  ?????   ??   ??   ??333?  ?L?fff?????L?   ?   >>?   ?   ?   >>>?   ?333???333????   ?333?????   ?   ??>>?   >?333???   ?   >>>?   >>>L>>>>>>>>?   ?L???fff?L?fff?333??   ?   ?   ?   ?   ?   ?   ?333?   ?   ?   ?>>>?   ?   ?   ??333?   ?   ?   ?   ?   ?   ?   >>??   >>>>>>>?   >?   ??   ?   ?   ?   ?   ?   ?   >?   >>>?   >L>>?fff>L>>>L>L>L>>>?   ?333??   ?   ?   >?   >>>>>>>>>L>L=>=>L=??333?333?L?  ?  ???fff?  ???ff?ff?ff??ff??L???fff?fff?L??@   ?33@33@ff?  ?ff?33?ff??33??  ?333?L?L?fff??  ?  ??ٙ?ٙ?ff???  ?  ??  ????????  ?fff?  ?fff?fff?  ??  ?  ?  ?  ?  ?  ?  ?  ??  ??  ??  ?  ????L??  ??fff??  ?33?ff?  ?ٙ?ٙ@   @?33@   ??  ?   ?   ?   ?  ???   >?  ?   ??33??fff?ff?  ?33?33????fff?  ?33?  ?  ?ff???ٙ@333@  ?33?ff@?ff??L?L???ff??  ?ٙ?33?ff?ff?  ??ff??ٙ@   ?33@   @ff@ff?33@   ?33?33?ff@   ?ff??ff?ٙ??  ?ٙ@@ff@ff@@   ?33@   @   @ff@   @ff?33@   ??ٙ?ٙ?ff?  ?ff@   ?ٙ?ff@?ff?33?ff?33@ff??ٙ?  ??ff?ٙ?ff??ff?ٙ?33?ٙ?  ?  ?33?ff??  ?fff?  ?L?L?fff?  ??  ????  ??  ????????ff????  ?ٙ@@   @?  ?ٙ??  ?  ?33?  ?  ?  ?  ?ٙ?ff?33?  ?@   @   @   ?33@ff?ff?ٙ?33???33?  ?ff?ff??ٙ?33?33?  ?ff?33?33?33?  ?33?  ?  ?  @   @   @ff?33@?33?ff??ff?ff?ff?ff?  ????????33??  ?ff?33??  ?  ?fff???fff?  ?fff?  ????  ?  ?L???  ?ff???ff?  ?  ?@   ??  @   @S33@9@   @?ff?  ?ff???ff?  ??  ?fff?L?fff?fff?L?fff?333?L?fff?333?  ?fff?fff?fff?  ?L?fff?L?fff?fff?fff?  ?  ?  ?  ?fff?fff?L?  ?L??  ?  ?  ?fff?????ff?33@?  ?fff?fff???ff?  ?L?  ?  ?fff?fff?  ?333?333?333???333?   ??333??333?L?L?333?333?333?L??????   ??333??>?@`  ?333?L?L?  ?L?  ?L?  ?  ?fff?fff?fff?fff?fff??fff?L?333?L?fff?L?L?  ?fff?  ??L?fff?   ?L>?>?   ?   ?   ??   >>>>>>>>>?   ?   >?   >?   >>>?   >?   ?   ?   ?ff?   >?   ??   ?   >>L>L>>>>>>>>L>>L>>?   ?   >>L?   >>>>>>?   >>>?   >>?   ???333????   ??   ?333?   ?333?333??  ?  ???   ?   >>>>L>>>>>>>>>=>L>>>>>>>>=>>>>L>L>L>>>>>L>L=>L>L>L>L>L>L>L>L>L>L    ===?L==    ======    >L    ===>L    ==    >?fff>L===>L    =        >L>L=        ===>L    ==>L=>>L======    =>>>>>>>>L>?   ?   ?333??L?L?L?L?fff?fff?fff?333?33?333?L??  ?333?fff?L?  ?  ?333?333?L?fff??333>>?   ====>L=>L>L>>L>=    >L>>>>>>>>?   ?>>>>L>L>L==>L>L=>?   >>L>===    >>>>L===>L>L=>>L==>L>L>L>=>>L>L>L    =        >>>L>L=        >>>>??L>>L    =    >L>>L>>L>>L>>>>>>?   >>>>>>>>>>=>L>>>?   ?L>?   ?   ?   >?   >?   ?   >L>>>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>=>>>L>=>>L>L>=>>>>>??333?fff?L>>>L>L>L>>>L>>L?   ?   ???   ???333???   ?L?fff?L?  ????333?333??   >>?   ?   >>>>>>>L>L>L>>    >L?   >>=>L>L=>>L>>>>?333>L>L>>>L>>??   ?   ?333>>?L?L?L?fff?fff?L?   ?  ?333?L>?L?333????   >>>>L>>L>L>L>L=>L>L    >L>L>L>>L>L>L>L>L>L>L>L>>>L>L=>L>>L>=>>L>L>L>L>L>?   >?   ?   >>>>?333?333?????   ????>>>?   ?   ?   ?>?   ?   ?   >?   >>>>>>>>L>L=>L>L>>>>>>>>>>?   ?   >>L=>L>L>L>L>L>L>L>L>L>>L>L?333>L>L>L>L>>L?   >?   >>>>>>>>>>L>L>L>L>L>L>L==>L>L==>L>L>>L>L>>>?   >?   >>>>>>>>>>>>>>>?   >?   >??   ?333?333?L?fff?L??L?333?333?L?333>>>L>L>L>L>L=>L>L>L>>L>L>L>L=>L>L>L>>L>>>>L>L?=>L>>>>?L?   ?>??   >>>L?   =>L>>>>>=>>L>L>L==>>>>?   >?   ?   ?333?  ?fff?fff????fff??ff?  ?   ?L?   ?   ??   ???333?L?fff?fff?L?333?   ?   >>=>>=>>L>>>=>>L>L=>L>L>L>L@   >L>>L?fff?   ?   ?   >>>>>>L>>>>?   >??   >>    >>=>>L>L>L=>L>>L>L>>L=>L>>>L>>L===>>>>>>>>>L>L>L>>L>L==>>L>L>>L>L>>>=>>>>>=    >>L>L>L>L=>L>>L>L>L>L>L>>L>L>L>L>L>L>>L>L>?   >>>?   ??   >>>L    >L?  >>>L>L>L>L>L>>L>L>L>>>L>L>L>>>>>>L>>>>>>>>L>>?   >>>>>>>>>>>>?333?   ?fff?fff?fff??L?333??>>>L>>>    =>>>L>L>>L>L>L>L>L>L>L>>>L>>>?   >>>>??   >?   ?   ?   >?   ?   ??L?   ?   >>>>>>L>>>>>>?   >>>L>>>L=>L>>>>>>L>L>>?   >??333?fff?  ?@   ???33??   @ff??  ?   ?   ?ff?   >?   >?   >L>>=>>>>>>?>@L>>>>>>>    @S33>>>>?   >>=>L>L>=>L>>L>>L>L>L=>L>L    =>>>>?   ?>>>L>?   >=>L==>>L>L=>>L>>L>>>>>>>>>>>L>L>L>L>>>>?333??333??L???333?333?333?333?333?   ??fff?L?>??>>>L=>L>L>L>L==>L>L>L>L>L>L>    >L>L>L>=>L>L>L=>L>L==>L>L>>>>L?333?>?L?>>L>>L>L>L==>L>L>L=>L>L>L>L=>L==>L>L==>L>>L==>L>L==>L>L>L>L=?L====>L    >>>>?   ?   ?   =>>>>>>>>L>>L>L>L>L>>L>>L>?   >L>>>>>?   ??   ??   ??ff???  >?  ?>?fff>L??   >>>>>?   >>>>>>>>?>??   ?   >>>>>?   ?L???fff?ff?33?  ?ٙ?  ?ٙ?  ?   >>>=>>>>=>>>L>>=>>>>>L>>>>>>?   >>>?   >?   ?   ?   ??  @33??  ?fff?   ??333????   ?   ?   >?   ??333??   ?   ?   >>>>>>?   >>>???333?fff?  ?????ff?  ?  ?  ?fff?L?  ?ff?ff?ff???ff?ff?33??  ?fff?L?  ?333?L?   >L?   >??fff?  ?fff?L?fff?   ?fff?fff>?33>L>>?333    >>L?L??33?ff?33??L>?ff?ff?33@33@?  ?ٙ?  ?@   ?ff?33???  ?33?  ?ff?ff???ٙ???33??  ?  ?  ????33??  ?333>>>>>>>>>>>>>>=>??  ??   ???   ?>?   >?   >>        >>>?   >>>>>>?  ?=?  ?  ?  ?  ?fff?fff>>==>L>L>L>L>L>>L>L>>>>>>>>>>>?   ?   ?   >>>>>>>?   ?   >>?   ?   ??   ?   ??333?333??333?333?L?333?333?333?333?   ?   ???333?   ?333?333??333?   ?   >???   ?   >???   ????333??333?   ?   ?333??   ??   ?   ?   ?   ??   ?   ?   ?333?333?L?333?L?333?333?333?L?333?333?L?333?333?   ?   ??   ?   ?   ?   ?   ?   ?   ?   ?333?   ??   ?   >?fff?   ?   >>?   >>>>>>>?   >>?   ?   ?   ?   ?   ?   >?   >>>>>>?   ?   ???L??  ??33?@ff@?ٙ?????ff??333??   ?33@@  ?ٙ?  ????33?ٙ?ٙ?ٙ@   @33?@@ff?ff?ff?   ??333?333???ٙ??L??  >?   ?>>L?   >?>>>>>>>>>>>>>>>>>>>>>>=>L>L>>>?   ?@33@&ff>>>?   ?   ?   ?   ?   ?   ?L??L>>===>>>L>L=>L>L>>>>>L>=>    >L>L>L>L>>L>L    >?   ?   >>L=>>>>L>>>L>>>>>>>>>>>>>L>L>L>L>>>>>>>L>L>L?33>>    >>>>>L>L>L>L>L>>>>>L>>L>>>>>>>>>>>>>>?fff?L?  ?  ?L?   ?   ???   ??   ?   >>L>L>L=    >L>L>>>>>>?   ?   >>>?   ?   >>?   ?   >?   >>>>>>>>>>?   ?   ?   >>>>>>>>>>>>>>L>>>L==>L>L>L>L>>>>>L>?@?  ?L?L?333?333?333??   ?   ??ff??333?333@?ff?fff?ff??  ??ٙ?fff?333>??333???fff???333??L?333?fff???   ??  ??333?L?333?33?333?333?333?333?L?333??333?333?fff?333?L?L?L?333?L?  ?333?333??L?L?fff?333?L?L?  ?33?  ?ff?fff?fff?  ?L?L?333???fff?L??fff?  ?fff?  ?L?L?333??   ?333?L?  ?333?  ?L?L??333?L?333?L???   ?   >>>L>>>?   ?   ?   ?   ?   ?   ???   >?   ?  ?fff?  ?fff?fff?fff?fff?  ?L??33?ff????ff???  ?  ??  ?  ?  ?fff?fff??333?L?fff?fff??333?L?fff?fff?333??333??333?   >>?   >??   ?   >??   >L??fff?fff?L?fff?333?333?????333?L????fff?ٙ?>?333??   ?   ?   ?   ??333?L??fff?L?333??????????333??333?L?L???   ?   ????   ?>?   ??>>>?   >>?   ?333?>>?   >>>?   >>??>>>?   >>>>>>>>>>>>    >>>>?   >?   >?   >?   ??333??L?  ??333?33?L?fff???L?L?L?333?333?333?333??  ?333>>>>>?333?fff?fff?L?333?L?L?  ?fff?fff?fff?L?L?333?333???   ?   >>>?   >>>>?   ??L?fff?fff?333?333?333???  ??   ?333?@?333??333?   ??  ?  ??L?L??333???   >?   ??>>L?   >>?   ?   ?   ??  ?>>?   >>>L>>>>L>>L>L>>>>>?   ?   ?   ?>>>>>L>L>>>>>>>>?   >?   ?fff??333?   ?   ?333?   ??   >>>>?>?   ?   >??333>?   >>?   >>L>>>>L====>L==>    =>L>L>L>?   >>?  >>>=>L>L>>>L>?   ?   ?   >>>>L>>>>>>>L>L>>>>>>L>L>L>>>>>>>>L>>>=>L>L>>L>L>L=    =        >L>L>>?  ?333??fff>?   >>>???L?fff?  ?  >>?   ?   >>>?   ??????   >????>?L?   ?>>?   >>?   >??   ?333?   ??333?   ??333?333>>>>?   >L>>?   ??333??333?L?fff???  ?  ??fff?fff?  ?  ?33?ff????fff?fff?333?333?L?fff?  ?fff?333?L?  ??????fff?  ?  ?  ?  ?  ?L?  ???  ?  @@yAffA#33AS33AfffA  A33A33A<A<AAAA   A33@ffA   A33AA+33A4A6ffA8  A<A   A(  AA   @@@  @@@ff@ff@33@@33A33@@@  @@  @33@ff@33@ff@@33@ff@  @33@@33@33@fff@33@  @`  @@  @fff@,@@  @Y@s33@L@9@Fff@?ٙ@@?ff@33@L@9@fff@L@9@Y@,@&ff@   @@33@@ff@33@&ff@&ff@33@33@&ff@&ff@&ff@@@   @S33@9@@   ?ff?ff?ff?ٙ?ff@   @   @&ff@333@9@Fff@@  @9@?ff@   ?  ?  ?ff?  ???33?ff??ff?ff?ff@   @33@ff@@   ?ff?33@33@@   ?ff@33?  ?  ?33??ٙ?  ??  ?  ?  ?  ?ٙ??ff?ٙ???  ?ff??ff???????33?ٙ??  ?????  ??  ?fff??  ??fff???  ???ff?33??33????  ?L?fff?L?L?L?333?L?L?fff?333?L?fff?fff?   ?   ?333???333??L???   ??   ?   ?   ?   >?   ???   ??>>>L>L>L>L>L>>L>?   ?   ?   >?   ?   ?   ???333??  ?  ?fff?  ?  ???fff?  ?333?  ?  ???ff?ff?fff???fff?333?   ?   ?333?L?333???   ?   ?   ?   ?>?   >?????L??333???   >>??   >??333?333?333?L?fff?333?fff?fff?fff?L?L?L?fff?  ?L?L??333??   ?   ?L?  @s33@333@ff?  ?  ?fff?333?  ?L?L?L?L?L?L?L?L?L?333?L?fff?333?L?L?L?L?fff?  ??L?333?L?L???  ?333?L??fff?333??   ?   ?   ?333?>?333??333?333?333??   ???333?333?333?   ??333>?   ?   ??333>?   ??   ?   >>>>??333??   ?>>??333>?????   ?   ??333?333?333????   ??   ??   ?   >?   ?   ?   ?   ?   ??   ?   ?   ?   ??333?fff?fff??  ??fff?L??   ??   ?>?333?333???333>>>L?   >>L>?L?L??   ?   ????333?   >?   ?>>?   @ff?   ??333?fff?fff?fff??   ?   ?>?333>>?   ?   ?   >?   ?>>>?   >>>>>>?   ?   >>>>>L>>L>>>>>>>>?333?333?L?fff?fff?ff???ff??fff?fff??   ??   ?333??L?   ?L>>>>@Fff?L?L??L?L?333??L?L?  ?L?@   @   @@@33@ff@   ?33@@@,@  @y@Y@fff@@  ?33?  ?  @   @   @   @,@&ff@9@&ff@,@333@   @33@   @?33@L@S33@l@@  @Fff@S33@&ff@@33@ff?ٙ?ff?ٙ?ٙ?ٙ?ٙ?ff?ff?33@333@,@&ff@,@   @&ff@&ff@333@Fff@333@&ff@,@&ff@9@9@L@Fff@   @@@ff@&ff@333@@  @S33@`  @S33@L@Fff@@  @@  @Fff@9@Fff@33@   @,@,@   @@,@33@Fff@Fff@333@,@,@Fff@333@&ff@   @,@33@   @33@   @?33@ff@33@33@ff@,@333@&ff@&ff@&ff@@   @   @@&ff@s33@`  @l@33@ff@  @s33@l@Y@  @  @33@@  @ff@33@`  @Fff@33@   @   @   ?ff??ff@33@@@@   @   @,@,@   @&ff@&ff@&ff@   @9@`  @fff@fff@  @Y@`  @L@l@`  @L@L@333@,@333@&ff@@33@ff@@   @@@ff?33@ff@   ?ff@@@33@@33@   @&ff@@9@@  @   @,@333@,@33@   @@33@@@@@@  @333@&ff@,@,@333@@  @,@,@333@,@333@   @,@333@`  @ff@9@fff@ff@@ff@  @@@@ff@ff@s33@ff@@ff@33@  @@@  @  @@l@Y@Y@Y@  @y@fff@Y@Y@fff@fff@fff@l@l@y@y@l@l@fff@y@s33@`  @Fff@@  @@  @,@Fff@@  @Y@Y@fff@S33@Fff@Y@Fff@Fff@@  @Fff@@  @9@9@9@9@Fff@333@@  @@  @Fff@Fff@Y@L@S33@`  @s33@l@`  @fff@l@s33@s33@y@@33@ff@y@33@ff@y@ff@s33@y@y@L@Y@fff@L@Fff@Y@L@@  @333@Fff@9@9@&ff@&ff@,@   @,@&ff@&ff@&ff@&ff@@   @&ff@@@33@@@33@ff@@33@33@9@33@   @333@@   @   @@   @@@@ff?ff@ff@   @33@ff@   @ff?33@ff@ff@33@ff@@33@@ff@33@@@@@@   ?33@ff@@@   @@ff@   @   @ff?ff@   @ff?33@ff@   @@?ff@   ?33@@   @@33@?ff?33@ff@ff?ff?ff?33?ff?33?ٙ?33?33?ٙ?ff?ٙ?33?33?ff??ٙ?ff@   @ff?ff?ٙ??33?ff?33?ٙ?ٙ?  ?  ?  ?33?  ?ff?ff?  ?33?  ?  ?33?ff?33??  ???ff??33?ٙ?ff?33?  ??ff??????fff?fff?  ?L?L??  ?  ?fff?  ?fff??fff?   ?  ???????ff?33?@   @?33??ٙ?  ?ff?33?33??33@?  ?333?fff??fff?  ??fff?  ???  ??  ?  ?33?33@&ff@s33@&ff@   @@ff@ff????  ?  ?  ??  ?ٙ?33?  ?33??  ?33?33????ff?L??fff?  ??  ???????L??????fff?  ?L??  ?ff?ff?fff???L?L?  ??  ?ff??ff?33??  ?ٙ?????  ?33?  ?@33@33@   ??ٙ?ٙ??33?33??  ?ٙ?33?fff?L?L?333????   >??333?333?L?333?L?333?333?L?333??333?  ?   ?   ?333>?   ??L?L?333?L?  ?  ??  ??  @   ?L?333??  ?fff?L?  ?333?  ?  ?fff?  ?333?>?   ?   ????  ??ٙ???  ???  ?333??333?L?fff?fff??fff?fff?  ?L??L?   ?333?ff>?333?  ?fff?   ?   >>?   ?>?   >?   ?   ?   >?   ?   ?   ?   ?333?fff?L??L?fff?fff?333??   ?333?L??   ??L?333?333?333?333?fff?@,?333??L??333??ٙ?ff@ff@33@`  @33@A33A333A4A333A<A<A6ffAIAK33AffA33A@  A   @  @  A33@@@ٙ@@33A33A   A33A@ff@ٙ@33@@@陚@@33@ffA@ٙ@@33@@@ff@33@ə@33@@@ٙ@33@@ə@ff@  @ff@@  @ə@  @ə@  @ٙ@ff@陚@ff@ff@  @@33@ff@@@@33@ff@  @ff@  @ff@33@@@@  @@@@  @@33@@ff@Y@s33@`  @fff@Y@,@333@   @L@S33@9@@  @9@9@&ff@   @@33@@   @@&ff@   @   @&ff@@@33?ff?ff?ff???  ?ff??  ??33?ٙ?ٙ?33?ٙ?ff?33??ff?33?33@ff@33@,@@?33?33?33@@&ff@,@&ff@@   @ff@   ?ff@   ?ff?@   ?33?33?@ff?ٙ?  ?33??fff?333?333?L?ff??ff?  ?ff?fff???33?L?  ??fff????  ?  ?  ?ff?ff?  ?  ??ٙ???ٙ?@   ?ٙ???  ?  ??ٙ?33?ff?333?333?fff??L?333?fff??fff?  ?L?  ?L??   >?L?>?333>??333??ٙ?33??33??L?fff?  ?ff?fff?fff?  ?fff??L??333?fff?33?L?fff?   ?333?L??   ?333?333?fff?L?ٙ?fff??  ?L??L?fff??  ?33?ff?  ?  ?33?333??  ???ff???????ff?33?33?ff??????ff?33???  ?33?ff???ff??33?ff?ٙ@   @   ?ff?33??fff?L??   >?333???   ?L???333?333??333?L?333???333?333?333?  ?  ??  ??ff@   ??ff??33?  ?  ??  ?L?333?L?L?  ?fff?L?L?fff?L?333?fff?fff?L?333@33?fff?L?333?fff?fff?  ??  ?  ?fff?fff?L?  ?fff?fff?fff?333?  ?  ?L?333?  ?fff?fff?  ??fff??ff?  ?  ???333?   ?333?333?L?fff?fff?L?fff????fff?L?   ?L???   ??   ?   ?   >>L>>>>>??   ??333????333?333?333?>?   >?   ?   ?   ?   ??333>?   ?   ?   >>???333?33?L?  ??333?fff??fff??   ?   >L>>?333?333??fff?L?L?  ?333?333?L?   ?  ?fff?fff??L?L?@l???L?   ?   ?   >?   ?L??????fff?fff?>L>>?   >?333>?   >?fff?fff??333??   >?   ?   >?   >>>??  ?333>>?333?   ???fff?L?333?fff?L?333?>>>L>>?>L=??333???   ?33?  ?333?fff?333?fff?L?L????333??333?fff??  ?  ?ff?ff??   ??L?333??L???   ?   ???   ?   ??   ??333?L?L?L?333?  ??L?333?333?  ???L?ff?33?33?  ?33?ff?L>?   >>>>L?   >?>>>?   ?   ?   >>>>L>>>L>>L>>?   >>>?L??333?333??   ?   ???  ?>>?333>???L?L?  ??L?ff?L?L?fff?  ?  ?L??L?L?L?fff??fff?fff?  ??  ?  ??fff??L?  ?fff?  ???33?ff??  ?ff?33?ff?33?ff?ff?L?fff?333?ff?333??ff?ٙ?  ?  ?33@?ٙ?@   @ff@@9@Fff@333@@@  @fff@9@9@@  @`  @Y@Y@@  @33@@   @@   ?ff@ff@   @   @ff@y@@@l@  @ٙA  A1A33A33AəAffAp  A^ffAnffA  AlAx  A33A  AřA33AffBB"BH  BKB9BHffBSBA33BJ  B7BBffBA  AٙA  AAAffA33A33A  A33A  AA33AA  AA33A  A{33AlAfffA[33AFffA9A9AffA.ffA$A#33A&ffA33AAffAA(  A.ffAAffAffAAffA  A33A33A33A@@@陚@  @33@ٙ@@ə@ə@  @33@ff@  @33@ff@@33@33@@33@ff@  @ff@  @@  @@  @  @33@@33@S33@`  @`  @`  @S33@L@S33@S33@s33@fff@y@33@33@@  @  @Y@9@l@@9@fff@s33@s33@s33@33@s33@@ff@s33@9@`  @y@fff@L@,@,@&ff@S33@L@Y@y@  @Fff@S33@l@@s33@S33@`  @y@ff@l@@  @333@@@ff?33@ff?33@   @y@   @   @@  @L@9@333@   @,@&ff@@&ff@33@33@ff@ff@@@ff@?33@ff@ff@?ff@ff??ٙ?  ?Aff???  ?33@@,@L@Y@L@L@`  @ff@ff@  @@33@ffA@ff@ff@  @@  @  @@@@  @@@@33@33@@ff@@ff@@33@y@&ff@Fff@L@33@s33@@l@33@33@Y@Y@Fff@9@333@9@Fff@l@  @fff@fff@l@l@Fff@fff@L@S33@@  @9@333@,@   @fff@l@333@@ff@&ff@33@@   @@333@333@@33@@   @@@33@   @&ff@&ff@9@9@?ff?  ?33?33??  ?  ?33?ff?ٙ?ٙ?ff?ff?33?33?ٙ?ٙ?  ??ٙ?ff?  ?  ?33?33?33@ff@@9@,@33@@33@   ?ٙ?33?33??fff?333?fff??fff?  ?ff?ٙ@Y@Fff@s33@Fff@333?@333????fff?fff?  ???33?33@   @,@   @33A(  ?ff@   @33@   @L@&ff@   @&ff@@@@ff@   @@   ?ff?  ??ff???????ff?33?ff?ff?ff????33??ff?33??ٙ?  ????ff?ff?  ?33@9?33???ٙ?ff?33??ٙ?@&ff@   ?ٙ@33@   @33@,?33@9??L??   ?333?   >?333?L?L?  ?  ???ff?33?  @   @   @   ?ff??ٙ?33?33?33?  @   ??33??fff?L?333?333?  ?L?fff?  ?fff?333?fff?333?333?fff?  ?333?L?  ??fff????ff?ٙ?33?ٙ?  ?ff?ff??L?fff?fff??333?   ?   >>>>>?   ?L?   ?   ??L??L?L?33?333?333?  ??ff@33@33@,@@@,@@   ??  ?  ??333?fff??L?333??333?333??   ?L??333?fff??ff?ff?L?  ?  ?ff?fff??fff??L??   >>L>?   >?333??L?   >>>?>?>?   ?L?   ?   ?333??fff@S33?333?   ?fff?  ??   ?L???333?   ?>>>>?   >>>?   >L??   >>?   >L>L>L>L>L>L?>?   ??ff?   >??   ?   >L>L>L>L>>L>>L>=>L>>>L>>>>>?   ??   ?333?   ?   ?   ??   >>L>L>>>?L?ٙ@   @ff?ٙ?33??  ??L??ff>>L>?>>?   ??@  ?333?   ??333?L?333?L?333?ff@33@ff@&ff@ff@33@   @   @33?33@ff?ٙ?ff@ff@   ?ٙ?ff??ff?ٙ?ff@ff@@333@333@@33@   ?33@   @ff@   @ff@   @   @?33@ff@ff@Fff@333@&ff@@9@@,@33@   @@ff@@   @ff@@ff@@33?ٙ?ٙ?33?ٙ@   ?@ff??33?33?33?ff???ff@33@   @@   @   @   @@33@&ff@@?ff?ff?ٙ??ٙ???ff?@33?33?ff?33@   @@   ?ff@`  @fff@&ff@Fff@   @@333@33@33@&ff?33@ff@33?fff??  @   @@  @@Fff@y@`  @Y@fff@l@S33@`  @`  @@  @L@L@L@   @@&ff@33@@   @ff@33@33@@33@33@@33@@@   @@ff@&ff@@   @@@@@   @ff@?33??  ?  ?ff?33??ff??ff?ff@,?  ??  ??  ?ff?fff??L??fff?fff?  ?  ?fff?333?333??333??333?333?L?L??333@?  ?  ?L?L@ff?L?fff?  ?L?fff????  ??L?fff?fff??fff?  ?333?fff?L?  ?fff?fff?fff?fff?  ?fff?333?  ?33?fff?L???  ??fff?333?L?>?   ?333>>??333???>?   >>?   ?   >>>L>?333?333?   >??   ?>???   ?   ?L??fff?333??L??L?fff??   ?>>>??   ?   >?333??L?333>>?333??333?   ?   ?L?333?333?L?fff?L?  ?33?  ???fff??333?333?333?333?fff?   ?333?   ??333?333??   ??fff????fff?333??  ?ff??fff?fff?fff?fff?L??L?333?333?L??fff?333?L?  >?   ?333??   >?L?fff?fff?  >@ff?>???  ?ff?33?ff?ff?fff?  ?  ??  ?L?L?ff?  ?  ???L??L?333?L?L??fff???  ?  ??ٙ?ff?  ???L?L??ff??333??333>??L?   ?L?333?L?333??fff?333?   ??  ?fff?L??333??  ?  ?fff?  ?L?333?fff?L?L?  ?L?  ?L?  ?fff??333?   ?333??L?333?333?L?>??333?333?333?  ?333?333??   ?   >?>>L>>>>>>>?   ?   >???fff?fff?  ??fff??fff?ff?33?ff?fff??   ????  ?fff?L>?  ?  ?333?333????ٙ?ff?ff?@ff@,@   @@33@?  ?  ?33?ff@ff@ff@@33@@9@33@33@@@@333@&ff@&ff@,@33@   @@&ff@   @   @&ff@   @ff@@ff@@33@@@Y@   @   @@,@   @,@333@@  @&ff?ff?ٙ@   @ff@   @ff???33@@@   @33@?33?33@ff@@ff@@33@Fff@9@333@9@9@,@@ff@@@ff@   @333@333@L@Fff@9@333@@  @,@@  @&ff@   @&ff@333@9@,@@   @@33@33@@@33@   @ff@@&ff@&ff@&ff@33@33@&ff@9@9@333@@  @Fff@9@333@L@Fff@9@Fff@9@333@9@9@   @33@333@@  @33@&ff@@  @l@fff@333@Fff@9@9@333@@333@@  @9@ff@,@   @&ff@@   @   @33@   @@   @   @@   @@33@@@   @333@,@  @33@ff@?  @ff?ff@33@L@L@s33@Fff@Y@Y@Y@s33@`  @Fff@333@@   @@?33@   ?ff@ff@@33@   ?33?33@ff@   @@@ff@33@33@9?@   ?ٙ???33@333@   @333@,@333@&ff@9@@@   @333@@33?33?@ff?ff?33?  ?  ?ff????  ?33?33?33?ٙ??ٙ??ff?ٙ?33?ٙ?33??  ???ff?ff?ff?ٙ?ff?  ?33@33@   ?33@33@9@@@  @,@Fff@`  @@   @33@33@ff@@?33@Fff@@@   ?ff@ff@ff@   ?ff@&ff@ff@@   @ff@   @@ff@@@333@@333@Fff@333@   @   @   @@   @@,@&ff@333?ff?ٙ@@33??ٙ?33?  ?ff@33?33?ٙ?33?ff?33?33?fff?  ??33?L?  ?  ?L??33?  ?33?ff?ff?ff?  ???ff??L?33???33@33?33???  ?33???33?ff???fff?  ?  ?ff?ff??33??  ?L?333?   ?333?fff?L?   ?fff?  ?L?  ?333??  ?  ?ff?33@?33@ff?ff??33?ff?33@?  ???ff????33?L?  ?  ?L?   >L?333???L?333??333?L>?   ?333??333?   ?333???333?333???L>?   ?  ?333??333?L??L?  ?fff?L?L?fff?L?L?33?333?333??333?333?333?fff?  ?L?333?333?333?333??333?333?L?ff?ff?  ?  ?33?ff?ff?ٙ?ٙ?ff?ff@   ?ff@ff?33?ff?ٙ?ٙ?ff??ٙ??ff?@   ?ٙ???33?  ?ff?33?  ?  ?33??ff?33?  ?33?ff?  ?ff?33???33???fff?  ???ff?ff?  ?L?  ??fff??ff??  ??333??ff?ff?  ??fff??333?   ??   ??   ?333??333?333>??   ?   ?   ?333??L?L???L?333?333?333?fff?L?fff?fff?  ?fff?L?   ??333?333?333?  ?ff?fff??33?ff??L?fff?L?L?   ??333????fff??  >>>L>?   ?   ?   >>?333?   >?   >>?   >>?   ?  >?   ???333?333??   ?   >??>?333?>???   >??   >?   >L=>>>?   >>>?>>>??   >?>?fff?L?   ???>>>?L?fff?33???L?fff?L?L?fff?333?L?fff@Y?  ?  ?33???333??333?   ?   ?333??333?L?fff??   ?   ???fff?  ?  >?333?L?L???   ?   >L>>>?333????L?fff?333>?   ???L??   ?L?L??  ?L??L?   ?333?   ???   >?   ?333>?fff?   ??fff>?   ??   ????>L>>?fff?  ?  ?   >>>?   ??33??  ??fff?fff?ff??L??333??L?@&ff??333???   ?333?L?L?fff>??   ?333?333>L?   ?   >L??333?   >?   ?   ??>?   ??333????333?333?   ?333?333?   ?L?333?L?333?L?  ?fff?fff?fff?333??L?fff?  ?333?fff?L?333?333?fff??>??fff?L?fff?  ??  ?fff?L??fff?ff?fff?fff?ff???ff?  ?fff?fff?fff?333?L?fff?L?L?L?fff?33@&ff??  ?  ?fff?  ?L?L?L?L??   >?   ?333??33?  ?  ?333?L?   ????fff??L?333?fff?fff?fff?L?fff?333?333?333?fff?333?333??L>?   ?333???333??333?   ?333??L?L?L?fff?L?L?333?   ??   ?   ??   >?fff?L>>>?   ?333?L?  ?fff??ff?333?fff?fff??fff?fff?L?  ?fff?fff?  ?  ????  ?  ?  ?fff?333?fff@l?333?L>?333?   @   >?>?>?L?L>?>?   ?333??>??L?   ???   ?L?  ?333?333?fff?   >?333?   ?>?333?L?333?L?L?L?333??L?333?L?fff?333??   ?333?L?333?333?333?333?L?ٙ?ff???fff?333?L?L??   ?>L?   ?L?L???L?  ?333?333?   ??333?333?fff?  ??  ?  ?fff?fff?333??   ?   ?fff??   >?   ?333>?   ??333?fff?L?L>?   ????   ?   ?33@33?L?L?fff?333?L?fff?L?333?  ?fff??333?fff?fff>??   ?L??L?   ??   ?333??L?fff?L?   >?   ???   ??333?L??333?fff?ff?33?  ?ff?  ?fff?L?ff??  ?ٙ???  ?fff?  ?fff?  ???ff??fff?  ?  ?fff??L?  @   ??  ?ff??33?  ?????  ????  ?ff??33?L?   ?>?   ???L??L?  ????  ???  ?ff?ff?fff?L???ff?????33?ff??ff?L?fff?  ???333?L?ff?ff?ff?ff???  ?????ٙ@ff?33@ff?ff??ff??ff??  ?  ?fff?  ?L?333?L?  ?fff?L?fff?333?fff?L?fff?   ?L?fff?fff?fff?333?L?333?fff?fff?L??fff?  ?333?333?  ?  ?L?L?L??333??fff?333?L?   ?   ?   ???L?L?L?  ?????fff?fff?fff?L?fff?L?L?  @33??   >?  ?L?333?333?fff?L????333?333?333??   y ?Ly @ff??   y >L=    ===>L>L=>L>>L=>>L>L>L            =>L    >>L    >L    >L=>L=            ==>L        >>L===>L    >L?>L>L>>>?   >?   >L?   >?   >?>>>L>L>L>L>=>??>?>L>>L>>>>>?333?   >?   >L>?333>>L    ==>L=>>L    =>L    >L=>L?   >L>>>L====>>L>L=    =>L>L    =    ===>>L>=>L=>L===                            ==    >L=>>L>L>L>L>L=>L>L>L>L>L=>>=>L=>>L?>>>?   ?   ?>?   >?   ?   >L=?   >L>>>>?   >>?333?   ?fff>?  ??   ??333???fff?333>?   >>>?333?ff?  ?33????   ?   ?   ?fff?  ??33@@  @  @@  @ٙAffAY@@33@33@@  @@y@yA0  AS33AYA`  A(  A\A,AiATAP  AAAAffAA33AffAAA  AiANffA6ffA0  A  A@A@@@33@ff@  @@33@33@ff@  @33@ff@@ff@33@ff@ff@@ff@@ff@  @33@l@`  @  @ff@ff@33@ff@y@33@  @Y@fff@S33@@L@33@@ff@33@@@@@  @@ff?33?@y@L@9@&ff??33?33?@@   ?ٙ@33?33@33??33?ff?33?L??ff???33?  ??ff?33@   ?ٙ?ٙ?33?ff?  ?33?ff?  ??fff@,?fff?L?   ==>?   ?333    >?fff?fff?333?333>>L>L=>L>>L=>>>>>L>=    >L>L?   ?L?fff?==>L    =?>    ===>L    >L?>    =>L>L>L    =>L@Y?L?333?L?L?L??L?L?fff?fff??fff?  ?  ?  ?L?L??  ??  ?  ??  ??  ?L?  ?L?333???L?333?   ??333??333?L?333?333??333???   ?L?@?L?333?333??333?  ?333?fff?333?L??L?333?L?L?333??L?L??   ?fff?  ?fff?fff?L?L?L?L?333?fff?fff?L?L?L?   ?333?333?333?333?333?333?333?L?L?333?L?L?333?333?333?333???????????   ??333???333?333?fff?333?L?333?L?L?333?333?ff?  ??fff?333?ff?L???  ???   ?   ?   >??   ?   ?   ?   ?   ??fff?ٙ?  ?  ?fff?  ?ٙ?ff??L?fff?  ??333?fff?fff?L?L?33?fff?  ?333?333?333?333?fff?L?L??333??333?333?333??333????333?????L?333?L?L?333?333?333?333?????333?333?333?333???333?333????333?333?L?333?333?L?L?L?333?333?L?fff?333>?33?  ????  ??L?  ???  ?????333?fff??   ?ff???  ?ff????33?ff??333?L?333??333?L?L?L?fff?fff?L?fff?L?L?L?L?333??333??333?333?333?333?L?fff?333?333?L?L?L?L?L?333??   ?????????????333?333?333?333?333?L?L?L?fff?fff?L?L?333?L?   >??   ?333??>?   ??????333??   ?   ?   ?   >??   ???   ??L??333??333?333?333?   ?L?333?333?fff?fff?fff?fff?L?L?L?333???????333?333???   ?   ?????????   ?333????333?????????333?333?333?333?333?333??333?333?333?L?333?333?333?333?fff?333?333?333??333?   ?   ?   ?   ?   ??   ?   ?   ?   ??   ?   ?   ????333?L?333?333?333???333??????333?L??????????333???333???????L?L?333?333?333??333??????333??333???333?333?333?333?333?333?333?333?333??333?L?333?333?333?333?  ??333?L?333?333?   ?333?333?333?333?L?L?333??L?L?L??333?333??333??333?  ??   ?L?333???333?333?333?L?L?fff?333?333?333?L?333?333?fff?L?333?fff?L?L?L?fff?333???fff?L?33?33?ff????33??33???fff?fff?  ?  ?  ?  ???  ?L?fff?fff?L?L?fff?  ?L?L?  ?L?  ?L??fff?fff?fff?L?L?L?L?L?fff?fff?L?L?L?333?333?L?L???333?333?333?fff?L???L?333??L?333?333?????L?333?333?L?fff?????333?fff?  ?  @  ?fff?  ?L?fff?fff?fff?L?L?fff?fff?fff?  ?  ?  ???ff?????  ?L?fff?L?L?L?L?L?fff?  ?  ?  ???  ?ff?  ?33?  ?ff?ff?33?ff?33??33??ff?  ??L?L??fff?L?333?333?333?333??   ????333?333?333??333?333??33?????L?   ??   ?   ???fff?333??333?333?333?L?L?  ?fff?  ??fff?333?   ?333?333?333?333?333?333?333?fff?fff?fff?L??ff?33?ff???ff?33??  ?L?L?L??333???   ?   ?   ???   ?fff?  ?  ?L?fff?fff?fff?  ?fff?fff??333???L?   ?333?L?L?L?  ??333?333?   ?L?   ??  ??   ??   >@ff??   ??333???   ???   ?   ?333?333????333???333?L?333?   ?L?   ??   ????333????333?  ?  ?ff?  ?fff?L?L?333?L?333?333?L?333?333?333?333?333?333?333?333?L?L?L?333?L?L?333?333?L?333?L?L?fff?L?L?L?fff?fff?L?fff?fff?L?333?333?L?fff??fff?L?333?L??L?   ?333??L?333?333?333?333?333?333?333?333?L?L?fff??fff?L?333?>??333?L?L?fff?fff?  ?fff??????  ?fff?fff?fff?L?L?L?L?L?333?L?L?333?333?333?333?L?L?333?L?333??333?333??L?fff?fff?L?333?333?333?333?333?333?333??333??L?333?L?L?333?L?333?L?L?L?333?333?L?333?333?333?333?????333??   ?333?333?333?   ?333?333?   ??333?L??   ???   ??   >>?   ?333?L?L?333?fff?L?L?333?333?L?333?L?L?333?333?333?333?L?fff?fff?  ?L?fff?L?33?L?L?L?333?333?333??333?333?333?333?333?L?333?L?L?L?L?L?fff?fff?fff?L?L?L?333?333?  ??  ?L?333?333?  ?L?fff?fff?ff??fff?L?L?333?333?????L?   ?   ??333?   ?333?  ??????   ?   ?   ?333?   >?   ??   ?   ?   ?333?>??   ?   ?   ?   ?   ?   ??@&ff?333???333????333?fff?fff?L?333?L?333?333?333?333?333??333?333?L???333?333?333??333?333???333?333?333?333?L?333?333?333?333?fff?333?L?333?333?333?333?333?L?333?333?333??L?333?L????L??L?L?  ???????   ???????>?   ?333?????   ???   ??333??????   ?   ???   ?   ?   ?   ?   ?   ?   ??333?333?333?333?333?333???333?333?333?333?L?L?L?L?333?333?333?L?333?L?L?L?L?L?L?L?L?333?333?333?333?333?333?333?333?333?333??L?L?333???333??L?L??333?333?333?333?L?333?333?333??333?333?333?   ?   ???   ??   ???   ?>>?   >??   ?   ?   ???fff????333?333?333?333?333?333?333?L?333?333?333?333?333?333?333?333????333??333?333?333?L?fff?  ??fff?fff?333?L?L?L?L?L?L?L?333?333?333?333?L?333?333?333????333?333????   ????333??????   ?333???   ?L???fff@   ?L?333???333?333??????   ?????   ????   ??   ??   ??   ??????   ?   ?   ?   ?   ?   ?   >>????333?L?333??????333?????333?333?L??333?333?333?333?333?333?333?333?333??333?333??   ?   ??333???>?   ?333?   ?   ?   ?   ?333?   ??333?   ??   ?333>????333?   ?333?fff?333?   ?333?333?333??333??????333??   ??   ????????????333?fff?333?333??333???   ?   ?333???   ?   ???   ??   ???   ??333?????333?333?333?L?   ?333?333?fff?fff?L?333???333?L?333?   ?333????L?   >?   ?   ??   ???   ??L?L??fff?   ?   ??333??333?333?333?333?333?333?333???333?333?333??333?333?333?333??????   ??   ?   ?   ?   ?   ?333?   ?>?   ?   ?   ?   ?   ??   ??   ??   ?   ?   ?   ??   ??333?   ???333?333?333?333???L?333?333??333??333?   ?   >??@33>>?   >?>???333??333?333?   ?333>?   ?   ???   ?   ?>?   ???333??333??333?L??333?333??333?333?333??333???333?333??333?333????333??333????   ?   ?333?????   ????333?333?333?L?333?333?L?333?333?333?333???L?L??333?333?333?333?333?333?   >???333?   >>?333?  >?   >?   ?   ?333?   >>?   ?   ??333?333>?   >?333??333?????   ??   ?   ?   ??   >?   >?   ?   ?   >>?   ?   ?   >?   ?   >?   ?   ????????333?333?333?333?333??333?333?333?L?333?L?333?L?L?L?L?L?333?L?L?L?333?L?L?333?333??fff?fff?333?fff??333?333?????333?333??   ?   ?   ?   ?   ?333????333?   ?L?   ?333??333?   ?   ???   ?????333?L??L?333?fff?fff?L?333??333??333?333?333?333?333?333?333?333?333?333?L?333?L?333?L?L?L?L?fff?L?fff?fff?fff?L?333?L?fff?L?L?333?333?L?fff?fff?  ?  ?fff?L?L?L?L?333?L?333?L?L?fff?333?L?333?333?L?333?333?333?333?333????fff?fff?333?L?fff???  ??fff????333?fff?L?fff?333?L?L?L?fff?fff?L?L?L?L?L?fff?fff?fff?fff?  ?  ?fff?fff?fff?  ?fff?L?fff?  ?L?L?fff?fff?fff?L?L?fff?  ?fff?  ?  ?  ?ff??  ?  ?  ?L?  ?  ?fff?L?fff?  ?  ?  ??ٙ?ff?ٙ?ff?ff@   @@   ?33@ff@   ?33@   ?ff@   @ff@   @ff@ff@   @ff@ff@ff@@ff@33@33@33@@@@33@33@9@ff@ff@ff@   @y?33@   @L@@   @33@ff@   @   ?33@@&ff@   @   ?ff?ff?33@   ?ff?ff?ٙ?33?33?33@   @y@   ?ff?33?ff?ff?33?ff?ff?ff@ff@33?ff?ٙ?  ?ff?33?ff?33?33@   A33@?33@   @ff@   @@   @   @   @   @ff@   ?ff@   @ff@333@33@   @33?ff?33?ff?ٙ?ٙ?  ?  ?ff?33?33?33?  ??  ?@9?ٙ???ٙ?ٙ?  ???@   ???33?ٙ??@?ٙ?ff?ٙ?ٙ@&ff?33?ff@   ?33?33?ff?ff@   ?ff?ff?ff?ff?ff?ff?ff?ff?ff?33@   ?33?33@   ?33?33A33@33@33@@33@@ff?33@   @   @ff?ff?ff?  ?ٙ?ff??ٙ?ff????  ???33??33??????  ?  ?  ?  ???  ??  ?????ٙ??ٙ?ٙ?ٙ?ٙ?ff?33?ff?ff?ٙ?33????  ??????ff?  ??ٙ??ٙ?  ????ٙ??33??ٙ?ff?ٙ?ٙ?  ?ff?ٙ?ff?ff?ff?ٙ?33?33?33?33?ff?ٙ??33?ٙ@ff?ٙ?ٙ?ٙ??ٙ?ff?ff@@@@   @   @ff@@ff@?ff?33?ٙ?33?ٙ?33?ff?ٙ?ٙ?ٙ?ٙ?  ?ٙ??ٙ??ٙ?ٙ??ٙ?ٙ?ٙ??ٙ?ٙ?ٙ?ٙ?ٙ?  ??  ?  ???ff??ٙ??ٙ?ٙ?ٙ?ٙ??ٙ?ٙ?ff?ٙAh  ?33?ff@&ff?ٙ?ff?ٙ?  ?ff?ff?ٙ?ff?ff?ٙ?ff??33?ff?ٙ?ٙ?33?ٙ?ff?33@   ??ff?33@ff@ff@,?ٙ?ٙ?ff?ff?ٙ?33?33?ٙ@333?  ??ٙ?  ?ff??ٙ???ff?ٙ?ٙ?ٙ?ff?ff?33?ٙ?33?33?ٙ?33?ٙ?ٙ?ٙ?ٙ?ٙ???  ??33?????33????  ?  @   ?ٙ?ٙ@33?ٙ?????ٙ????  ?  ?  ?  ??@ff??  ?  ?ٙ?ٙ?ff?ٙ@?ٙ?  ?????  ?ff@   @33@@ff@   ???ff?ff?ff?ٙ?ff?33??  ?ٙ??ٙ?33?ٙ??ٙ@   ?33@ff?  ?ٙ?33?ff@   @@&ff@333@,@9@9@@   @   @   @   @@33@ff@ff@@33@33@@@   @ff@ff@ff?ff@   ?ff@ff@@ff@ff?33?ٙ@ff?33@@   @   @   @AA@33@33@   @   @@@ff@33@   @&ff?ٙ?33?33@,@   @   @@ff@@   @   @   @   @ff@ff@@&ff@@33@@@@@33@@@   @ff@   @   A  @   @   @   ?33?ff@   ?33?ff?ٙ?ٙ?ff?ff?ff@ff?ff?33@33@   @ff@@33@,@@   @ff@@@@   @ff@@   @ff@   @@@@l@ff@S33?33@   ?33?33?ff@&ff?33?33?33?33?ff?ff?ff?33?ff?ٙ?33?ٙ@   ?@33????ff??ٙ?ff?ff@ff@ff@33@@@y@ff@33@33@@ff@?33@@ff@33@ff@ff@@  ?ff?33@ə?33?33?33?33?33?33?33?33@&ff?33?ff?ٙ?ٙ?ٙ@   @ffA;33??33?????ٙ?ff?ff?33?33@S33?ff?33?33@@ff@@33A@ff@   @A  @   ?ff@   ?ٙ?33@   ?33?ff?ff@333@@ff@Fff@S33@`  @ff@   @   @ff?ٙ@33?33@   ?33@@@@   @   @33@@@33@  @ff@@@&ff@33@A   @L@@  @   @`  @@A<@`  @l@  ?ff?ffAVff@S33B  A  Aff@ff@  Ay A33BffA33BB*B^A33Al@33@A@BIB   Anff@&ff@&ff@333@9@L@333@L@@  @ff@   @ff@9@s33@L@,@ff@  @,@,@ff@L@9@9@`  @333@ff@&ff@333@9@333@9@333@,@@@   @?33@@,@   ?33?ff@&ff?@?ff@ff?ff@@@@33@33@@33@@33@&ff@   @   @   @&ff@33@  @FffAff@33@333y ?33@   ?33A  A33@  Aff?33?ٙB<ff@@  ?ٙ@@ff@A  y @9A33@ff@`  @@fffA  A33@@  A  @33@@33@@@@ff?ff?33@   @ff?33?33?ff@   @   @&ff@&ff@333@333@&ff@@&ff@   @@,@33@ff@@9@   @fff@333@L@,@y@@@33@   @   ?ff@@9A$@ff@ff@@   @   @   ?33@   @   @@ff@   @   @33@33@33Aff@33@333@33@@33@ff@  @   @@   @   ?33?ff@   @   @  @@   @@ff@&ff??33@333@ff?33?ٙ?33@@@@   @   @333@333@   @9@,@   @33@   ?33?33@   @33@33@33@33@33@33@@   @@&ff@9@@   @   @@@@@@@   A  @   @333@   @   @   @   @33@@@   @@33@@@   @ff@33@@ff@ff?33@ff@   @ff?ff?ٙ?33?33@33@   @33@ff@   @   y @&ff@&ff@,@,@&ff@33@@@   @@@@ff@ff?ff?ٙ?ٙ?  ????  ?ff@?ff@   @ff@ff?ff?33@@@ff?ff?ff?ff?33?ff?ٙ?33?ٙ@?33?ff@   ?ff?33@   @ff?33@   @   @   @ff@ff@@   @@   @ff@@@@  @@  @333@333@Fff@333@333@@  @L@333@&ff@&ff@9@&ff@@&ff@,@9@9@@333@,@   @,@,@&ff@ə@,@   Aff@@@@@@@   @   @&ff@33@@@@@   @@33@33@@   @&ff@陚@,@333@,@@  @ff@@ff@@@   @ff?33@   @   @   @   @   @ff@ff@ff@ff@ff@ff@@ff@@33@33@@333@333@@  @9@Fff@L@y@L@Fff@s33@ff@@@fff@  @fff@Fff@ff@33@s33@333@@  @9@9@,@@  @Fff@@  @9@@  @9@&ff@333@&ff@@@@@ff@@@33@@@33@   @333@&ff@9@@  @@  @333@333@,@   @&ff@&ff@&ff@&ff@,@333@Fff@9@Fff@,@333@,@&ff@   @&ff@   @ff@@,@   @   @&ff@@33@@@   @   @   @@33@@33@@@@   @L@fff@333@,@&ffB-33@,@Fff@9@Fff@L@9@333@333@333@L@333@,@,@9@333@333@333@,@@  @L@9@9@L@@  @9@Fff@,@Y@l@L@333@   @@&ff@&ff@&ff@9@Y@`  @L@,@,@ff@,@9@Fff@Fff@9@333@,@9@,@&ff@@@   @333@@33@@@33@ff@ff@@@ff@33@@@   @33@33@,@@&ff@   @@   @33@&ff@&ff@@33@ff@33@33@@33@@   @@   @   @&ff@@   @333@   @333@,@@  @9@333@,@,@&ff@,@@@   @   @,@   @,@&ff@   @&ff@   @33@@@&ff@   @   @333@333@@  @@  @333@  @@@@ff@@@   @   @33@ff@33@33@@   @&ff@@@   @&ff@33@@   @33@@@333@   Aff@@ff@33@@@33@@@33@@ff@33@33@33@@@ff@ff@  @ff@ff@@@@@ff@   @@@ff@@33@ff@@@33@@@@@   @   @@   @   @   @@ff@333@333@&ff@&ff@@@33@Fff@@   @333@   @,@   @333@   @   @ff@ff@@   @   @@&ff@33@@&ff@333@,@@@   @,@,@333@333@&ff@   @33@   @   @@33@@   @33?33@33@ff@ff@ff@ff@ff@@ff@@   @ff@@@33@ff@33@33@   @@   @   @@@ff@@@ff@@33@ff@   @@@33@&ff@   @   @@@@   @33@,@@@   @@&ff@&ff@&ff@@33@@33@@@ff?33@33@&ff@@   @ff?ff@   @   ?33@   ?ff@   @ff?ff?ff?ff?ff@ff@ff@   @   @   ?ff@ff@   @   @ff@@@33?33@ff@ff@ff@ff@ff?33@   ?33@   ?ff?ٙ@ff@@@   @@@  @   @33@@ff@@@ff@ff@   @ff@   @@9@@ff@   @ff@ff@   @ff@@   @ff@   @@33@33@   @@33@   @@33@,@ff@   @   @fff@33@   @@   @@@   ?33?ff?ٙ@   ?33@ff@   @   @   @   ?ff@   @   ?33@   @@@   @ff@@ff?ff@   @ff@   @@33@@33@33@33@33@   @   @   @@   @@@ff@@   @33@?ff@&ff@@@ff@ff@ff@@ff@ff@ff@ff@ff@ff@   @@  @ff@ff@ff@   @   ?33@   @   @   @   @   ?33@   ?ٙ?33?33@ff@   @@@@ff@   @33@   @   @?  ?  @33@33@   @ff@@@@&ff@   @,@,@,@S33@33@   @@33@@   @   @@33@@@333@@@   @@@@@ff@   @@&ff@333@?33@@33@ff@ff@ff@ff?ff?ff?ٙ?33?33?ٙ@   @ff?ff?33?ٙ?ff?33?ٙ?ٙ@   ?ٙ?ff?ff@?ff?33?ff@   ?ٙ?33@   ?ff@   @ff@@@   @ff@ff@333@ff@   @@,@33@@@@ff@@ff?33@ff@@ff@&ff@@@  @&ff@   ?33@ff@ff?ff@ff?33?ff?ٙ??ٙ?33?33@ff@@&ff@   ?ٙ?@@ff@   @@9@Fff@9@,@333@,@&ff@33@ff?33?ff@   ?@l@   @   @33@Fff@@?ff@33@@  @33@   @   ?ٙ??33?33@@ff?ٙ?33?ٙ?ff??ff?ٙ?ff??ff?  ?33?ff?ٙ?ٙ?33@   ?33@   @   @Fff@   ?ff@   @33@   @ff?33?ff@ff@ff@ff@   ??ff?33@   @@ff?33?ff?33@?@   @ff@&ff@   @33@33?ٙ?ff?ff?33?33@   @ff@   @&ff@   ??ff@?@@ff@33@ff@ff@33@   @ff@   ?ff@   @   @ff@   @   @33?ff@ff?ff?ff?33?ٙ?ff?ٙ?33?33@   @   @33@?33@   @   @ff@ff@   @   ?33@   ?33?ff@   @   @   @   @?33?33?ff?ٙ?ٙ?ٙ?  ?ff?33@   ?33@ff@ff?33?33@   ?33@   @@   @ff@   @   @ff@33@9@ff?33@33@   ?ff@   @&ff?33?ff?33?33?ٙ?33@ff@ff@@   @   @   ?33?33@33@33@   @9@333@333@@  @ff@&ff@333@&ff@@@,@   @   @   @ff@ff?33@ff@ff@ff@   @@&ff@@ff@&ff@,@33@&ff@&ff@@@   @@?33?ff@ff@   @ff@   @ff@ff@   @ff@@   @33@@ff@&ff@@ff@33@@@33@33@,@,@@33@33@`  ?33@&ff@   @ff@ff@33@33@33@@33@33@@@@@33@   @,@,@&ff@&ff@&ff@   @@@ff@ff@   @ff?ff?33?33?ff?ٙ?33?ff?33@ff?33?33?33?33@   @@   @   @   @   ?33?ٙ?33@?ff@ff@   @   @ff@@ff@ff@ff@ff@33@33@@ff?ff?33?33@ff@   ?ff?33?ٙ?ff?ff?33?33?ff?ff?33?33@   ?ff?ff@   @   @ff?ff?33@?ff@   ?ff?33@ff?  @?ٙ?ٙ??ٙ?ٙ?ff???ٙ?ٙ?  ?ٙ@   ?ٙ?ff???ٙ????ٙ?ٙ?ٙ?ٙ?ٙ??ٙ?ٙ?ff?ٙ?ff@ff?ff?33@   ?ff?33?33?ff?ff?33?33?33@   @   @   @ff?33?33?ff?ff?ٙ?ff?ٙ?ٙ?ff?ff?33@@ff@ff@ff@Fff@ff@   @ff?ٙ?33@   ?ff?ff?33?33?ff?33?33?33@   ?33@   ?33?33@   ?33?33@?33@   ?33@ff@&ff@   @ff@   @   ?ٙ?ٙ?33?33?ff??ff?ff??ٙ?ff?ٙ???ff@   ?33?33Aff?ff?ٙ@   @ff@   ?33@33@ff@   ?33@   ?33?33@ff@   ?33@   @   @   @ff@   @   @   @   @   @   @ff@ff@   @33?33?ٙ?ٙ?ٙ?ff@   ?33?ff?ff?ٙ?33@   ?33@   ?33?ff?33?33?33?ff?ff?ff?33?ff?ٙ?ff?33@,?ff?33?33?33@   ?33@   ?33?33?ff?33?33@ff@   ?33@   @@  @@33@   ?33?ٙ@   ?ff?ff?33@ff@ff@   ?33?ff?33?33?33?33@,?ff?ٙ?ٙ@ff?33@ff?ٙ?33@ff?ٙ?ٙ?ff?ff@   @   ?ٙ?ٙ@ff@ff?33@@@ff@@@S33@ff@33@33@@   @   @   @   ?33?ff?33?33@   ?33?ff?ff?33?33?33?33@ff@   ?33?ff?ff?ff?ff??ff?ff?ٙ?ff?ff?33?ff??ٙ??ٙ??ff?ff?33?33??ff?33@   ?33@   ?33@fff?ٙ?ٙ?ٙ?ff?ٙ?ff?ٙ?33?ff?ٙ???  ?  ?  ??  ??33?  ?  ?ff??  ?  ?  ?  ?ٙ??ff?ff?ٙ?ٙ?ff?ff?33?ٙ?33?33?ٙ@ə?ٙ?33?ff?ff?ff??ff@   ?33?33?33?ff?33?ff?ff?33?ff?ٙ?ff?ff?ff?ٙ?33?  ?ٙ?ٙ?ff?ff?ٙ?  ?  @ff?ٙ?ff?ٙ?33?ٙ?  @ff@?ff?ff?ٙ?33?ff?ٙ?ff@   @   ?33@   ?33?33?33@ff??ٙ?ff@   ???ٙ?ٙ??ٙ?  ?  ?ٙ??ff?ff??ٙ?  ?ٙ??ٙ?  ??ٙA1?ff?ff@   @   @?ff@@   @ff?ff@   ?ٙ?33?ٙ?ff@   ?ff?33@   ?ff@   ?ٙ?33?ٙ?ff??ff?ff?33?ff?ٙ?ff?33?ff@   ?ff?33@ff@   ?33@   ?33?33?ٙ?ٙ?33?ٙ?ff?ٙ?33?33?ٙ?ٙ?ٙ?  ??ff?ٙ?ff?ٙ@@  ??ٙ?ff?ٙ?33@fff@   @ff@ff?33@   @   @@   @   ?33?33?ff?ff?ff?33?ff@ff@   ?33?ff@   ?ٙ?ff?ff@ff@@ff@33@ff@ff?ٙ@33@@  @   @9@33@33@ff@333@@   @@@ff?ٙ?33?ff??33?33?33?33?ff?33?33@ff@   ?ٙ??ٙ?ff?  ?ٙ??ff?ff@ff?33??ٙ@   ?ٙ?ff?ff?ff?ٙ?ff?ff?ٙ@ff?ff@??33?ٙ?ٙ?ٙ?ٙ?ff@ff?33@   ?33?33?ff@   ?33@   @@   @ff@ff@ff@?33?ff?  ?ٙ??ٙ?33??ٙ@   ?33?33?ff?ff@ff?33?33@   ?ٙ???ٙ?  ?  ?33?33?  ?ff?ff?ff?ff??33?33?33?ff?33?ff?ff?33?33??  ?33?33?  ??ٙ?ٙ?ff?ff@33?ٙ??ff?ٙ?ff?ff?33?ff?33?ff?33@   @   ?ff@ff@   ?33?33?33?ff?33?33?33?33@   @   ?33?33@ff?33?ٙ@ff@   ??33??ٙ?ٙ?ٙ??33@   ??33??  ?ff?  ??ff@   @ff@   ?33?33?ٙ?33@   @ff@@33@33@@33@33@&ff@33@,@333@   @ff@33@?ff?33?33@33?33@   ?33?33@ff?ٙ?ٙ?ٙ?33?ff?ٙ????ff?ٙ?ٙ?ٙ?ٙ@33?????  ?  ?  ?ff?33?33?ٙ?ff@   ?33?ٙ?33?ff?ff@   @   ?ff?33?ff?ff?ff@   ?33?33@   ?ff?ff?33@   ?ٙ?  ??33?  ??ff?  @ff?33@   @   @`  ?33?ff???ٙ??  ?  ??ff?ٙ?ff?ff@?33?ٙ??ff?ff?33?ff?ٙ@   ?ff?ٙ?33?33?ff@   @   @ff@@@ff@   @ff@   ?33@   @ff?33?ٙ?  @ff@   ?ٙ?33@   ?ff?ff?33??ٙ@`  ?ٙ??  ??  ?  ?33?33??  ???  ???  ????ٙ??ٙ?ٙ?33@s33?33@   ?ff?ff?????????ٙ?ٙ?ff??ff?33?  ?33?33?  ??ٙ?ٙ??33@ff@ff@   ?33?33?ٙ??  ?@   ?ff?33?33?33?ٙ@   ?ff@   ?ٙ?33?33?33?ff@   ?  ?ٙ?  ?33?  ?ff?ff?  ???ٙ?ٙ???  ??@?  ?ٙ???ٙ???ٙ??ٙ??ٙ?ٙ?ٙ?ff?ٙ?ٙ?ff?33?ff?ff?ff?ٙ?ٙ?33?33@@   ?33@   @@33?33@@@   @33@@@@ff@@ff?33@ff@   @?33?ff@333?@   ?  ??ff?  ?33?  ?ff?ff?ٙ?ٙ@   @@@@333@,@@  @ff@   @   @@@33@33@@   ?33?33@   ?ff?ff?ٙ?@?ff?ٙ?ff?ff?ff?ff?ff?ff?ٙ?ٙ?ٙ??ff?33?33?ff?33?ff?ff@   @   ?33?ff?ff?ff?33?ff?33?33@ff@33@ff@ff@ff@@&ff@ff@ff@@33@ff@&ff@&ff@   @,@&ff@,@ff@@&ff@,@333@&ff@@  @&ff@   @   @@ffy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @ff@33@  @@33@@  @@  @@  @33@s33@s33@  @33@ff@@@  @ff@33@@Y@L@fff@S33@33@ff@l@33@  @  @,@   @   @,@9@L@@  @L@L@L@Y@L@Fff@@  @Fff@333@,@L@`  @Y@L@Y@Y@Y@`  @Fff@Y@333@y@333@@  @`  @S33@`  @`  @l@y@33@L@@  @@  @333@9@,@333@,@,@,@333@333@9@,@,@333@333@&ff@333@Y@Fff@L@S33@s33@`  @S33@33@l@  @fff@y@s33@@fff@S33@L@9@?33?33@ff@9@&ff@&ff@&ff@33@L@Fff@9@9@9@Fff@S33@,@@  @33@   @Y@fff@&ff@33@@Fff@ff@@@33@33@@   @@33@ff@33@33@ff@33@   @  @  @  AffAlAyA  AAA  A  AffAA33AAffAAffA  A  A  A  AnffAnffAh  A[33ANffAP  A<A6ffA,A,A.ffA&ffA&ffA!A  AAAffAAffAAA#33@ff@A@ٙ@A  @陚@ff@33@  @@ٙ@ə@33@33@  @@@@33@33@@ٙ@  @ff@ٙ@  @ff@@ff@ə@@@33@@@33@  @@  @ff@  @@@33@y@y@`  @`  @L@Fff@Y@fff@s33@l@33@  @l@  @ff@y@33@33@33@@fff@fff@s33@l@s33@ff@@@y@y@s33@y@  @  @Y@Fff@9@Fff@9@L@Y@Y@`  @s33@`  @l@fff@@  @Y@`  @fff@fff@  @  @`  @Y@  @l@y@L@Y@y@  @@33@@@33@l@Y@,@`  @L@FffAT@9@333@9@Y@S33@Fff@@  @Fff@Fff@L@L@@  @L@S33@`  @Y@S33@Fff@Fff@9@   @,@333@L@s33@,@@  @333@@  @Fff@@ff@33@,A1@&ff@Fff@fff@Y@y@s33@l@33@@@l@@fff@ff@333@33@  @,@  @  @S33@@y@9@333@,@@,@9@333@?33@   @   @   @   ?ff@   ?33?33?ٙ@   @   @33?33@ff@9@&ff@9@9@333@,@,@9@,@@33@ff@@@33@   @ff@ffy @@ff?33?ff@   ?33?33@   @ff?33@33@33@&ff@&ff@333@9@Fff@,@,@@   ?33@   @   ?33?33@   ?33@ff@@@?ٙ@   ?ff@@ff@333@   @L@&ff@@  @l@@ff@33@ff@  @@  @Fff@9@@@@@?33@@&ff@ff@9@33@@333@&ff@&ff@   @&ffAff@&ff@,@@ff@ff@   @ff@33@   @@@&ff@   @   @,@333@&ff@,@333@   @9@ff@   ?33@@@ff@@33@@  @S33@Y@y@S33@33@fff@y@l@33@  @@33@ff@@33@33@  @@S33@  @@@ff@33@ff@33@ə@l@Y@y@  @9@333@l@333@S33@9@l@s33@y@Y@,@Y@y@fff@@y@  @fff@  @l@33@ff@@@  @33@ff@y@@@33@ff@@ə@@@33@@y@fff@s33@fff@  @  @33@  @@33@ff@  @@  y @  @  @@@  @ffAA6ffA  AA   @@33@33@  Aff@33@@AA)A+33A9A0  A1A1A1A,A  A33A33A@33@  @ə@ff@  A33A33@@  @@33@  @@  @@ffAff@33@ff@@əA  A  A33A  @33Aff@ff@  @ff@  @  @@@33@  @  @ff@y@s33@ff@@ff@ff@  @y@@ff@33@33@33@s33@33@@l@@L@S33@Y@y@333@,@333@333@fff@@  @333@S33@@  @9@,@   @@&ff@   @@@,@,@   @&ff@333@@  @@y@`  @fff@fff@`  @Y@Y@L@L@,@@@   @33@33@   @333@L@Fff@`  @l@Y@`  @`  @Y@`  @fff@  @@  @@333@33@@Y@@@ff@33@@  @@  @@  @33@  @L@   @@@&ff@   @   @`  @L@`  @Fff@L@S33@l@  @`  @Fff@333@@9@S33@fff@9@S33@9@L@Y@`  @L@9@33@33@@   @9@&ff@9@333@,@333@&ff@@@&ff@33@AX  @33Aff@&ff@&ff@&ff@9@`  @Y@@  @333@@@@   ?33@   @   @ff@   @ff@33@@33@   @,@,@333@@  @@  @Y@Fff@L@Y@`  @l@Fff@333@y@`  @y@l@ff@ff@@33@Y@9@,@L@9@9@y@  @y@Y@Y@@  @L@S33@fff@`  @s33@l@L@Y@`  @Y@Y@Fff@@33@33@   @&ff@@  @,@&ff@33@   @@@@&ff@&ff@333@@@33@@ff@   @   @   @ff@@@   @33@ff@   @,@@  @Y@@  @Fff@9@9@9@@  @@@,@   @   @,@   @&ff@333@333@33@@&ff@333@333@333@333@@  @S33@s33@s33@s33@  @`  @y@Y@y@ff@@@33@@@l@,@@@ff?33?33@ff@ff@33@@&ff@   @   @@33@33@@?33?33?33@ff@,@&ff@@@ff@,@S33@Y@Y@L@S33@&ffB@ff@333@Fff@333@@  @,@?33?  ?ff@   ?33?33@   @@&ff@   @@@,@   @  @@   @,@,@@@@33@   @   @@@33@@@@@&ff@33@   @,@   @@33@@   ?33@33@   @   ?33?33?33?33?ff??ff@   ?@   @ff@333@&ff@9@@  @L@S33@S33@Y@`  @Y@S33@Y@&ff@@ff@ff@   @   ?33@   @   @,@  @33@   A1?33?33?33@333@?ff@?ff??33?33?33@   ?33@ff@   ?ٙ???33?  ?33?33?ff?33?ff@33@ff@   ?33@   ?ff@@  ?ff?ٙ?ٙ??ٙ?ff@   @   @ff@33@&ff@   @@&ff@&ff@&ff@   @@@ff?33?ff?ff?ff@   ?33?ٙ?ff?33?ff@   ?33@ff@ff@@   @,@333@33@33@@   @   @   @S33@@ff@33?ٙ?ٙ???ٙ@   ?33@@@   @ff@33@   ?33?33?33@   ?ff?ff?ff?ٙ?ٙ?33@   ?ff@?  ?ff??ٙ?ٙ??ff?ٙ?  ??ٙ?33?33?ff?33@   ?33?ff@ff@   ?33@   ?33?ff?33?33?ff@ff@   ?33@ff@@?ff@@   @@33@33@33@33@@   @   @ff@   @ff?33@33@   @?ٙ?ٙ?33?ff?ٙ?ff?ٙ?ٙ??ٙ???ٙ??ٙ?ٙ??ٙ?ٙ?ff?ff?ٙ?ٙ??ٙ?ٙ?ٙ?ٙ?ff?33?ff?ff?ff?ff?ff?ٙ?ٙ??ff?33??@ff?ٙ??ٙ??ff@?33?????  ?ٙ??ٙ????ff?ٙ?ff?  @&ff?ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?  ?33?33?ff??  ???33?33?ff?33?ٙ?  @33?ٙ?33?33?ff?ٙ?ٙ?ٙ?ٙ??ٙ?ٙ??ٙ??ff?ff@   @333?ff?ٙ???  ??33?  ??  ???  ??ٙ?ff?ٙ?ٙ?  ?ٙ?ٙ??ٙ?  ??ٙ??ٙ?ff?ٙ@Y??  ?  ?  ?  ?  ?33?33?33?  ?  ??  ?  ?  ?  ?ff?  ?ٙ@ff???  ?@?ff?33?ff?  ?33?ff?33???  ??ff?ff?ٙ@ff@?33?33?ff?33?33?33?ff?  ?ٙ?ٙ?ff?ٙ????ٙ@ff???  ?  ?33?  ?  ?  ?  ?  ?  ?  ?  ?  ?@33?  ?ٙ?ٙ?ff?ٙ?ff?ٙ?ff?ٙ??ٙ?ٙ@,@&ff?ٙ???ٙ??ff?ٙ??  ?ff?  ?  ?ٙ?  ?33???ٙ??ٙ?  ?  ?ٙ?  ??ٙ?ff??  ?  ?ff?33?33@?33?ff?ff??33?33?  ?@   @   ?33??ff?  ?  ?  ?  ?33?  ?  ?ٙ??33@   ?ff?ٙ?ff?ٙ?ٙ????  ?ٙ?ٙ?ff?ٙ?ff?33?ff?ff????ff??  ?  ?33?ٙ?ٙ?  ?  ???  ?ٙ?ٙ??ٙ?ff@ff@33@&ff@@   ?33?33?33?ff?  y ?  ?33??ff?  ?33?  ?33?33?  ?  ?  ?  ?  ?ٙ?  ?????????  ?  ?  ?33?  ?  ?  ?33?33??ٙ?  ?  ?33?ff?  ?  ?ٙ??  ?  ?33?33?  ?  ?33?  ?33?  ?33?33?  ?  ?33?ff?33?ff?ff?ٙ?ٙ??  ??33?  ?  ?  ???  ?  ?33?????ٙ?33?  ??33???ٙ??  ?  ?  @   ?ff?33?33?ff?33?33?33?  ?33?33?33?ff?33?ff?ff?ff?????ff??ff??????ff??????33?33??33?33?33@?ff?  ?33?33?33?33?33?ٙ???ff?  ?ٙ?33?33?33?33?33?ff?  ?  ?  ?  ?  ?  ??ٙ??@ff?  ?ٙ??  ?ٙ?ٙ@ff?ff?ff?  ??ff?ff?ٙ?ff?ٙ?ff?ٙ??ff?ٙ@ff?33@   @@@S33@@33@A#33A@  AIAh  A33A  A`  A1A1A0  A$A333AAAffA  A  AffA   @ff@@ff@33@33@33@33@ٙ@ə@@ff@@33@ff@33@@33@@ff@  @ff@33@33@@33@33@@@@@ff@ff@@33@@@@@33@`  @S33@S33@L@Fff@Fff@L@Fff@@  @@  @@  @S33@9@Fff@`  A@333@,@,@9@l@fff@Y@S33@L@9@`  @L@@  @   @   @33@ff@33@   ?ff?33?33@@   @   @@ff?33@   @   @ff?33@ff@  @33@@&ff@Fff@9@9@   @   @&ff@   @   @   @&ff@,@@@@@@   @@ff@33@@ff@33@@@33@   @&ff@333@,@33@@   @   @   @   @33@@ff@ff@?33?ff?ff?ٙ???ٙ?ٙ??ٙ???33??ٙ?33@   @   @   @   ?ff?ٙ??  ????33??33?  ?33@&ff@s33?@?33?  ???ff?ٙ???  ??  ?33?  ?  ?  ?ٙ?ff?ٙ?33???  ?ٙ?33?  ??ٙ??ٙ?ff?ff?33y ?ff?ff?@   ?33?ff?ٙ?33@   ?ff?ٙ?33??ff?ٙ?ff?33@   @   ?33@ff@ff@   @@33@@   @   ?ٙ??ٙ?ٙ?@ff?ٙ?ٙ?ٙ?ff?ff?  ?  ?  ??33??  ??  ?ٙ?ٙ?ٙ@   @ff?33@   ?ٙ?ٙ???ٙ?ٙ@   ?ff??ٙ?33??ٙ?33???ٙ?ff?ff?ff?ٙ?ٙ?ٙ?ٙ?33@@@ff@ff@   @333?ff?33y @33?????  ?  ???  ?33?33?33?33?33?33@33?33??33?  ??33?@   ?ٙ@ff@   ?ٙ@   @@@@33@ff@@ff@33@33@ff@33@ff?33@   @@ff@?33?33@  ?33?ff?ٙ?33?ٙ?33?ff?ff?ff?ff?ٙ@333@   ?ٙ??ff?ٙ@   @   @ff?33?33?ff?33?33@   @   @@?ff?33@ff@@ff?33@   ?ff?ff?ٙ?33@ff?33?33?33@   @ff@   @@33?33?ff?ٙ??ٙ?@?ٙ?ٙ?ٙ?ff?ff@   ?ٙ?ٙ?ٙ??ٙ?@   ?33@@   @Y@L@S33@&ff@&ff@ff@   @@ff@?33?ff@   ?33?33@   ?33?33?ff@   @   ?ff?ff?ٙ?ٙ?ff?ff?ff@   ?33@   ?33?33?  ?ٙ??  ?  ?33?33?  ?  ?  ?33?33?  ?ff?ff?33?  ?33?ff@ff??ٙ@33?ff@  ?ٙ?ffA0  @333??ff???  @?33??  ?ٙ@   @33@   @333@@   @&ff?ff?ff?33?33?ٙ??33???33@ff?ff@,?ٙ?ff@ff@@ff@@33@33@33@S33?33@s33@ff?33@   @33?33@   ?33?ff?ff?33@ff@ff@33@@   @,@9@,@9@9@9@@  @@  @S33@Fff@&ff@33@@@@33@33@@ff@ff@@S33@9@`  @l@fff@ff@ffA9AaAVffAk33BQBBffBf  B33B33BBB33BffB33BB  BBBBffB  BbffBAB'B>  BB  BEB:B6  B33BBBBBP  BO33BP  BI33BH  B B!33B33BBBffBB AffAAA홚A陚AA  A  AffA  AAffA33AffA33AAAAAffA{33A	Ac33A1@ffAAANffAfffAc33AdAX  A+33Ax  ALAIAA333A&ffAA33@33@33@  @ff@@  @ə@  @33@@ff@ff@ff@@ff@  @33@ff@33@  @@@  @@ff@@@@33@  @ff@ff@  @@@@@ff@@33@ff@@@  @  @@33@9@s33@Fff@fff@33@s33@33@ff@s33@s33@y@l@l@@s33@Y@l@y@  @fff@y@  @s33@fff@fff@l@fff@fff@l@s33@  @s33@s33@33@`  @@fff@l@l@@ff@`  @`  @l@S33@L@Y@&ff@,@Fff@`  @l@  @L@  @Y@Y@`  @@  @S33@S33@Y@L@S33@Y@Fff@S33@Y@S33@fff@Fff@`  @`  @l@L@`  @  @y@fff@s33@  @@ff@l@9@S33@@s33@Y@l@  @ff@@333@&ff@Fff@L@Y@333@s33@  @@y@S33@  @S33@s33@Y@fff@S33@Fff@Fff@9@,@333@@  @L@333@&ff@33@@@@@33@33@33@33@33@@33@&ff@@33@&ff@@  @   @,@   @,@,@@L@9@,@333@333@   @&ff@9@9@Fff@Y@S33@`  @`  @Y@9@Fff@`  @@   @,@   @,@,@9@   @9@333@   @,@&ff@33@&ff@,@   @33@   @33@33@&ff@@   @&ff@&ff@&ff@333@   @9@   @@,@@  @9@L@   @@`  @Y@@  @fff@Fff@y@@@  @L@9@ff?ٙ?ٙ@33@ff?ff@ff@ff@@   @9@,@,@,@,@&ff@@&ff@,@@@@   @@ff@ff@   @   ?33?33@   @   @@ff@@33@&ffy @&ff@&ff@&ff@,@9@9@@  @9@@  @@  @@@33@   @&ff@@@ff@ff@@   @ff?33@@?ff@   @   @@Ay@33@33@33@   @   @33@@   @@@ff?33@ff?ff?ٙ??33?ff@,?@ff?33@   @   ?ٙ@   ?33?ff?33@@33?ff?  ?ٙ??33?ff?33?ٙ??ff?ff??  ??ٙ???ff?ff?33??@ff?ٙ?  ?ff@&ff?ٙ?33@   @   @   @ff??ٙ?ٙ?ٙ?33?ٙ?ٙ?ff@   ?ٙ?33?33??ff?ff??ٙ@   ?33@   ?ff?ff@ff?ٙ?ff@ff?ff@33@ff@   ?33?ٙ@33@ff@ff@@33@@   ?33@ff?ٙ?33?ٙ?ff??33?33@@33?33?33????33??  ?  ?ff?ff??ff??33??????ff?ff???ff?ff??ff?ff?ff?ff?ٙ@   ?33?ff?ff@   ?ٙ@ff??33?33?ٙ?33?ff?ٙ?ff?ffB~ff?ٙ?ٙ?ٙ?ٙ?  ?ٙ?ٙ?ff?ff?ff?ٙ?ٙ?ٙ?ٙ?ٙ?ff?33?ff?ٙ?  ?33?ٙ?33?ff?ff????ff?ٙ?33?  ?ٙ??ٙ??  ??ٙ??33?33??  ?ff?ٙ????  ?ٙ?ٙ??ٙ?ff?33?  ?ٙ??  ?ff?33?33?  ?fff?  ???33?ٙ???ff????ff?ff?ff?ff?33?33?33?33?33?ff?  ?33?33?33?ff?ff??33?ff?ff?ff?ff?ff?ff?ff?33?33?33?33?33?ff?ff?33??  ?ff?????ff??ff?ff?33?33?ff?33?33?  ?  ?  ?  ?  ?ff?ff?ff@ff?ff?  ?33?ff?ff?ff?ff?ff?33????ff?  ?  ?  ?33?  ??  ?  ?????  ?  ?ff?33??  ?33????????  ?  ??  ?  ??fff?fff?fff???33?33?33?ٙ??33?  ?  ?  ?  ?  ?  ?33?33?ff?ff?ff????33?33?33?33?33?  ?33?33?ff?ff??ff???ff??33?ff?ff?33??33?ff?33?ff?ff?33?ff?33?ff?ff?ff?33??@????33?ff?ff?ff?33?ff??ff?ff????ff?ff???  ?fff?ff????  ??  ?fff?  ?fff?  ?ff??ff@?33?ٙ?  ?  ??33?ٙ?  ?33?33?33?  ?33?33?33?33?ff?  ??  ?ٙ@?  ?ٙ????  ?ff?33??ff??33?  ?33@`  Avff?ff?ff?33?  ???ff?33?33@33@  @?33?33?  ?ff?33??ff?33???????ff?ff?ff???  ????  ?fff?  ?fff?fff???ff?  ?33?33?33?33?  ?  ?  ?  ?  ?  ?  ?  ?  ?33?33?ff?33?33??ff?ff??ff?ff?????ff?33?ff?ff?ff?ff?ff??ff?33??????ٙ????  ?  ??????ٙ?ff?ٙ?ff?ff?ٙ?ٙ?33????  ?  ????L??  ?  ?????  ??ff?ٙ?????????????ff?ff??fff?  ???  ??ff??ff?ff?ff?ff?ff???ff??ff?ff?ff??ff??Ah  ???ff?  ?  ???ff??ff??33?33?33?ff?33?????  ?  ?  ?  ??  ?ff?fff?fff?fff?  y ?  ?  ??  ?  ?  ?  ?fff?fff?fff?  ?fff?fff???   ??333?  ?333?fff?fff?L?   ?   >?>?   >>>L>=====>L>L>L>>L>>>>>>?   >=>>L>L>>>L>L==>@9@9@&ff@9@&ff@@  @fff@  @`  @Fff@Fff@@333@,@9@333@L@,@@Fff@@  @333@Fff@9@,@   @L@Fff@@  @L@Y@`  @333@&ff@Y@y@s33@33@`  @Y@  @@ff@ff@@33@l@@  @`  @Y@Y@L@@33@y@Fff@Fff@@  @9@L@@  @Fff@L@s33@33@33@@  @@fff@l@Y@L@l@s33@l@33@ff@fff@33@  @y@`  @`  @@  @@  @Fff@,@Fff@9@@  @9@@  @@  @9@9@9@,@@  @Fff@,@,@@  @@  @Fff@Fff@@  @&ff@333@333@333@333?  ???ٙ?ٙ?????  ????ff?ٙ?ٙ?ٙ?ff?33?  ?ٙ?ٙ?ٙ??  ?33?  ?ٙ?ٙ?ff??ٙ?ٙ?  ???ff??ff?33?33?ff?33?33@   ?33?ff?ff?33?33@   @33@ff@@   ?  @ff?ff?33?ff??ff?  ??ff?  ???ٙ?ٙ?ٙ?ff?ff?ٙ??  ???  ?33?  ?  ?  ?33?33?  ???ٙ?ٙ?ff?ٙ?ٙ?ff?ٙ??ٙ?ٙ?ٙ?ٙ?ٙ?ٙ?33?ٙ?  ?ٙ?ff?ff?ff?ff?33?@   ?ff?  ?ff?ٙ?ٙ?ٙ?ff?33???ff??ٙ?ff?ff?ff?ٙ?ff?33?ff?ff@   @   ?ff?ff?33?ff?ff?ff@?33?  ?33?  ?ff??  ?  ?ٙ@   @ff?ٙ?ٙ?ٙ@&ff?33?ff@@   @   @   @   @&ff@ff?33?33?33?ff?ٙ?ff?ٙ?ٙ?ff?ff?33?ff?ff?ff?ٙ?ٙ?ٙ?ff?ٙ?ٙ?ff??ff?ff?ff?ٙ?ff?ٙ?ff??ff???  ?33?ff?33?  ?33?33?ff?ff???33????  ??ff?33??  ??ٙ???ٙ?33?ff?33?ٙ?ff?ٙ???  ?ٙ?33?33?ff?ٙ?ٙ??ٙ??33?33@   ?33?  ?ٙ?ٙ@   ??33?ff?ٙ?ff?33?33?ff?ff?ٙ?ٙ?ٙ?????  ?  ??  ?  ?  ?  ?33?  ?  ??ٙ?ٙ?ٙ?ff?33??ٙ?  ?  ?33?  ??33?ff?ff??ff??ff?ff??ff?ff??????????  ??  ?????ff?????ff?  ?ٙ?  ?  ??ٙ?ٙ??ٙ?ٙ?ff?  ?  ?  ?33?33?????ٙ?33?  ??  ?  ?  ?  ?  ??33?  ?  ?ٙ??ٙ?33?  ?33??  ??ff?ff??ٙ??ٙ???ٙ??  ?  ????  ??ٙ?  ?  ?  ?  ?  ?33?  ?33?33?ff?33??ff?33?????33??ff???ff??  ?  ??ff?ٙ?ff@   ?@   @33@ff?ff?ff?ٙ?ٙ?  ?????ٙ?ٙ?ٙ@   ?ٙ?ٙ?ff?ٙ?ff?ٙ????  ???ff?ff?ff?ٙ@   @?ff?ff?33?ff??33?33?ٙ??  ?ٙ?ٙ??33?  ?  ?33?  ??ٙ?ff?????  ?ٙ????  ?  ?  ?  ?ٙ???ff?ff?33?ff?ff?ff?ff?33?  ??  ?ٙ?33?  ??33?ٙ??ٙ??ٙ?33?ff?33@ff?ff?ٙ?ff?ٙ?ff?ٙ?ٙ?ff?ff?ff?ٙ?ٙ?33?@ff?ff?33@   ?33?ff?ff@   @9@   @@&ff@@   ?33@33@33@&ff@   @   @   @   @   @   ?ff?ٙ???ٙ????  ?  ?  ?  ??  ?33?33?  ?33?  ?  ??  ?  ??  ??ٙ?  ?  ?ٙ?ٙ?  ??ٙ??  ?ٙ???  ?ٙ?ff?ٙ??33?33?33?33???ff?ff?33?33?  ?  ??33?  ?ٙ?ff?ٙ???ٙ?ٙ?ٙ@@   @ff?33?ff@ff@   ?ff?ٙ?  ?  ?ٙ?ff?ff?33?  ?ff?  ?33??  ?33?33?33?ٙ?ٙ?ٙ?ٙ?  ?ٙ?ٙ?33?ٙ?ff?ٙ?ٙ????ٙ?ٙ??  ?  ???  ??????ٙ?ٙ???ٙ??  ?ٙ?  ?  ?  ?  ?  ?  ??ff?33?ٙ?ff?ff?33?ff?33?ٙ?  ?ٙ?  ?ff?33???ff?33?ff??ff?33?33?33?33?33?ff?33?ff?ff??ff?ff?ff?ff?33??  @   @   @   @   @ff@   @@ff@ff@@?  ?  ?  ?33?  ?ff?33?33?ff?33????ff?ff?ff?ff?33?  ?33?ff?33?  ??  ??33?33?  ?  ??ٙ?  ??  ??ٙ?  ??  ?  ?  ?ff?33?ff?  ?  ?33?  ?ٙ?  ?  ?  ?33?  ?ff?  ?33?33???ٙ?ff?33?33?33?  ?  ?  ?33?ff?  ?ٙ??  ?  ?  ??  ?33?  ?33?33?33?33?33?33?33?33?33?33?33?  ?33?  ??  ?  ?33?33?33?33?  ?ٙ?  ?  ?33?33?ff?ff?ff?33?33?33?  ?  ?  ?  ?  ?  ?  ?  ?  ?33?  ?  ?  ?  ?  ??  ?  ????  ?  ???ٙ?ٙ?33?33?ff?ٙ?33?ٙ?ٙ?ٙ???ff?  ?  ??  ?  ??ff?ٙ?33?33?ٙ?  ?ٙ?33??33?ff@   @@   @ff@   ??ٙ?ٙ?ٙ?  ?33?  ?  ?33?ff?33?  ?ٙ?33?ff?ٙ??ٙ?33???ٙ?33?ٙ??ٙ?ٙ?ٙ???33?  ?33?  ?ff?33?ff?33?33?  ?  ???33?33?33?33?  ?  ??  ?  ??33?  ?  ???ٙ??ٙ?ٙ??ٙ?ff?ff?33?ff?33?ff?33?33@ff@33@   @ff@@@   @   @   @@ff@   @   @Y@@  @y@@  @333@333@,@@  @L@L@S33@@  @S33@S33@Y@fff@fff@y@S33@`  @L@@  @Y@L@9@`  @y@  @  @fff@@ff@33@@33@33@l@fff@@  @`  @  @L@@  @333@ff@S33@Fff@  @@  @s33@Fff@S33@`  @9@S33@y@L@L@,@Fff@S33@L@Fff@Fff@Fff@333@&ff@,@&ff@@  @&ff@333@9@   @9@L@S33@l@S33@L@Fff@Fff@Y@fff@s33@s33@fff@S33@l@S33@L@@  @9@@  @@  @9@Y@l@fff@l@  @y@s33@fff@s33@s33@y@  @33@33@@@@@@  @@@  @ff@ə@  @@@  @33@33@ə@y@@@33@33@s33@s33@@l@ff@@  @`  @Fff@Fff@@  @Fff@Fff@333@Fff@L@L@L@L@@  @Fff@9@9@,@ff@33@33@   @   @333@@  @333@333@,@&ff@9@S33@Y@  @Y@ff@@ff@@@ff@ff@33@  @@@@ff@@  @ə@  A33A1A>ffAA33@ffAH  @AA$A33A,A4A8  A#33A	AA33A  AffAffA33A33AffAC33@@  @  @ff@ff@33@@@  @@ff@33@33@@ff@@@ff@ə@  @@@  @ə@@  @@  @@  @ff@  @33@@ٙ@ٙ@陚@  @  @陚@A   @ff@@AffA  A  AA  A  AAAffA#33AffA1A,AA  AA33AAA   A.ffAA1A!A$@A#33AA)A#33A8  A@  ADAQAIA;33AQADATAYA!AFffAFffA$A.ffAX  AfffATAaA|AffAp  As33A  As33A  A33A{33AlA  A{33ATAp  AtAs33AAlAYANffA`  @@ə@ff@  @  @@ff@  @  @@33@  @33@33@ff@ff@@@  @ff@ff@33@33@ٙ@@ff@@33@  @ٙ@  @ff@@  @ff@陚@@33@陚@ff@33@33@33Aff@@@A   A  AAffA33A33AAA  A  AA  A  AAA33A  AffA$AA,A0  A333AA!A)AA8  A+33A;33A,A0  A;33AFffA9ADAIAIAaA`  Ak33AyAtAyAp  AdA&ffAAA33AffAA)A33A   A&ffA   A+33A.ffA>ffA$A.ffA0  AP  A4A)A33AAffAAlAiAh  AYAiAH  A#33A;33BqA9A1A)A$A<A@  A;33AFffA{33ALAP  AH  A33A  ANffAC33AIAaAP  A0  A`  ATAYAh  AVffAnffA{33A33AAX  A33AaA  AA  AAffAA  AA  AffA33AAAA  A33A陚A陚A  A33A33AAffAffA\AffA333@33@33@33@33@  @ff@ff@陚@A&ffA+33A   @   @33@ff@   @@   @33@33@33@@   @   @?ٙ??  ???33?33@?33?ٙ?ff?ٙ?ٙ?ٙ????ٙ?ٙ?ٙ?ٙ?ٙ@?ff@,@,@333@&ff@&ff@Y@,@333@?33?ff?  ?33@   ?33@   ?33@   ?ff?33@ff@9@333@   @?ٙ?ٙ??ff@   ?ff?ff?ٙ?33???????ٙ?ٙ@   @   @@@   ?33??ٙ?ٙ??  ?33?33?33????ٙ?ff?ff@   @ff@@@@&ff@@@   ?33?33?  ?33??  ?33?33?33?ff?33?33?ff?ff?ff?33?33?33?ff?ff?ff?ff?ff?  ?ff?ff?ff???33?ff??y ??33?ff?ff?33?ff?33??33?33??ff?33?@y@Y@S33@S33@@33@ff@33@&ff@9@333@,@,@&ff@,@&ff@9@@  @@Y@333@,@&ff@33?33?33??ٙ?ٙ??33?  ?33?  ???ٙ??  ?  ?  ?ٙ?ٙ?  ?ٙ@S33??33?ٙ??ٙ?ٙ?ٙ???  ?  ?  ?  ?  ?33?33?  ??33?  ?ٙ??  ?33?  ?ff?33?  ?ff?33?ff?ff?ff??ff?ff?ff?ff??ff?ff?ff?33?  ?33?  ?  ?ff??33?ff?ff?ٙ@   @   @@ff@ff@   @   ?33?33?33?33@ff?33?ff?33?ٙ????  ??ٙ??  ?  ?  ?  ?33?  ?  ?  ?  ?  ?33?33?  ?  ?  ???  ?  ?ٙ?ٙ?ff??ٙ?ٙ?ff?ff?ٙ?  ??????  ?  ?  ?  ?  ?ff?33?33?ff?ff?ff?33?33?33?ff??ff?33?33?ff?33?ٙ?  ??  y ?ٙ?  ?  ???ff?ٙ?ٙ?ٙ??ff?ff?ff?33?ٙ??  ?  ?  ??  ?ٙ?ٙ?ٙ?33?  ?  ?  ??  ?  ?  ?  ?  ?33?33?  ?  ?  ?  ?  ?  ?33?33?33?33?  ?33?33??ٙ??ٙ?  ???ff?ff?ٙ??ٙ??  ?33?  ?  ?ff?ff?33?33?ff?ff??33?ff??ff?ff?ff?ff?ff???????????????????ff?????ff?ff????ff????????????@@  ?33?33?  ?  ?  ?ٙ?33?ٙ?  ?  ?  ?  ?  ?  ?33?  ?  ?  ?33?33?33?33?  ?  ?  ?  ?  ?  ?  ?  ?  ?  ?  ???  ??ٙ?ٙ?ٙ?  ?ٙ?  ?  ?ٙ?33@??ٙ???  ?  ?33?ff?33?ٙ?33?ff???33?33???ٙ?  ?  ???33??  ?  ?  ?  ??  ?33?ff?33?33?ff?  ?  ?ff?  ?  ?33?33?  ?33?  ?33?ff?ff??ff?33?33?ff?33?33?33?ff?  ??ff@   ?  ?33??  ?ff?33?ٙ?33@ff@@L@S33@@ff@   @33@@@@   @@&ff@ff@ff@33@Y@@ff@@Fff@@Y@@  @S33@ff@y@y@S33@@@33@   ?33?ff?ff?ٙ??@   @   @@   @333@,@@  @Fff@333@,@33@   ?33@   @33@,@   @L@&ff@33@   @@@?33?33@@   @ff@   @&ff@33@&ff@l@ff@  @@@ff@A{33@@y@  @L@S33@@  @l@s33@fff@@  @Fff@S33@fff@33@@ff@  @ff@ff@y@y@s33@33@  @y@y@s33@y@33@y@@  @  @@@33@@@ff@ff@ff@@@@ff@@@@33@33@@@@ff@@ff@@  @  @ff@  @s33@Y@Y@  @ff@@  @33@33@fff@L@Y@l@L@Y@@  @@  @Fff@Fff@L@L@L@S33@L@L@L@Fff@L@L@@  @9@@  @@  @  @ff@  @@33@y@y@s33@l@s33@L@S33@Fff@@  @9@9@333@,@   @9@,@&ff@,@`  @@@@ff@33@fff@fff@l@y@Y@@  @fff@l@`  @S33@ff@fff@y@`  @S33@@  @Fff@@  @333@Y@S33@Fff@L@Y@S33@s33@`  @L@Fff@Fff@,@@  @&ff@@  @Fff@S33@L@S33@L@Fff@Y@l@fff@`  @y@  @y@@  @s33@fff@  @9@&ff@L@L@Fff@Y@S33A.ff@l@`  @Y@`  @Fff@fff@s33@ff@y@33@y@fff@`  @  @33@  @s33@s33@@s33@33@33@@  @@@ff@ff@ff@33@ff@@@ff@ff@  @@y@  @33@fff@@fff@s33@s33@s33@y@s33@s33@s33@`  @`  @l@S33@Fff@S33@@  @`  @Y@S33@L@S33@S33@Fff@@@  @@  @L@@  @333@Fff@9@Y@l@y@33@@  @@  @l@l@y@`  @fff@`  @Y@Y@L@333@@  @9@L@S33@Fff@&ff@S33@Y@`  @Fff@S33@9@@  @@  @S33@fff@333@Fff@L@@?33@ff@,@Fff@@  @`  @fff@S33@Y@`  @  @s33@  @  @33@s33@l@`  @L@L@L@S33@333@9@9@333@@33@@33@33@33@33@@ff@@ff@ff@ff@   @   @ff@33@   @   @   @@   @   ?33@ff@33@@@@@@&ff@&ff@   @33@&ff@&ff@@@  @L@@  @   @,@   @   @@@@ff@   @   @ff?ff@33@33@   @33@33@ff@@   @&ff@   @@ff@   @@@   @@ff@ff@?ff?33?33?33?ff?ٙ?ٙ?ٙ?  ?  ??  ?ٙ??ٙ?ff?ff?33?ٙ?33?33??ٙ?ٙ?????  ?33?  ?33?  ??  ?  @   ?33?ٙ?ٙ?ٙ?ٙ@   ?ٙ@   ?33@33@   ?ff@333@ff?33@33@33?ff@@@ff@   @@ff?@??33@Y?  ?33?ffy ?  ?33?  ?33?ٙ?ff?ٙ?ٙ?ff?ٙ?  ?33?  ?  ?33?33?ff??ٙ?ff@Fff@??  ?ٙ??ff?ff?33?33?  ?  ?33?  ?  ?  ?  ?33??33?33?33?ff?33?33?  ?33A?  ??  ?  ?ff?ff?33?33?ff?  ?  ?ff?33?33?33?  ?  ?  @??33?ٙ?  ?33??ٙ@ff?33?ٙ?ٙ?ff??  ?  @ٙ??  ???  ?33??ٙ?33?ٙ?ٙ?ٙ?ff?@???33?  ?33?  ?ٙ?ٙ?  ?33?ff??B.???ff?  ?ff?ff?33?33?33?33?33?ٙ?33?33?33?ff?33?  ??  ?33?ff?ff?ff?ff??ffy ?ff?33?ff???ff?33?33?  ?33?33?ff??ff?33?ff?ff?33??ff?33?ff??ff?ff??ff?ff?ff?  ??ff??33?ff?33?ff?  ?  ?33?ff?ff?  ?33?ff?33?ff?33?33?33?ff?ff?  ?33?33??  ?  ???  ?  ?  ?33?  ??  ???  ?  ?33?  ?  ?ٙ?ٙ?ff?  ?33?  ?  ?  ??ff?ff??ff?ff?33?ff??  ?33?33?33?33?33?33?  ?  ?  ?33?33?33?ff?ff?  ?33?33?ff?33?33@   @33@   @   @ff?33@   ?  ?33?33@   ?33@@ff@@33@ff@9@9@&ff@9@&ff@@&ff@&ff@&ff@,@&ff@&ff@@?ff?33@   ?33?33@   @@   @ff@&ff@@9@@@Fff@ff@&ff@,@,@   @`  @9@Fff@`  @y@  @l@  @@  @ٙ@33@  @,@&ff@L@S33@Y@Fff@9@,@,@   @333@fff@@lA   @@  @33@@@  @@ff@@ff@33@@@ffA#33@ff@  @@  AAA@  AA$A33A,A33AffA  ADAs33A.ff@Y@  @@33@@ə@33@@  A@33@陚@  A   @@@@  A  @33@陚A33A33@ffA$Aq@Fff@33@ٙAfff@l@@ff@@33@  @ff@333@L@l@y@@Fff@@ff@fff@@  @@@ff@33@ə@ff@@@@33@`  @s33@@@ff@,@S33@  Ap  @33A0  @@  @@  A	@fff@A33A333A`  @ٙA  @A~ffAFffAffA  AX  AffA33AP  AffA  A33AAřA33B  AAAA33AAA  A  AffAffAvffAYAAAffA+33AA33@@@@ff@@  @@33@  @33@ə@  @33@33@@  A	@  @ff@@s33A@@  @?  ?fff?fff?fff?L?fff???33?33?  ?33?33??  ??ff?33?  ?  ?  ?33A[33??  ?  ?????????????ff?????  ??  ???  ?????  ???33?33???????ff?33?ff?  ?33?  ?ff?33y ?33?33?  ?  ?  ?  ?33?33?ff?  ??33?ٙ???  ???????fff?fff?  ?fff?fff?fff?fff?fff?  ?fff?L?fff?  ?fff?  ?  ????????ff???ff?33??ff?33?ff???ff??ff?ff?33??ff?ff?ff???ff?????ff????ff?ff?ff?ff?  ?33?ff??ff?ff??ٙ?ٙ?ٙ@ff???  ???33?33?ff??ff???ff?ff??  ?  ?33?ff?ff?33?33?  ?ff?33?  ??ff?  ??  ?  ?  ????????????????ff?  ?ff?33?  ?33?  ?ff???  ?  ??????ff???ff???????33?33?  ?ff?  ?33?  ?  ?33?33?ٙ?ff??  ?  ??  ?33?33?ff?  ?ff?33???@陚?ff?ff???????  ?  ?ff??33???ff????ff??ٙ?ٙ?ٙ??33?33?ff?33?33?33?ff??ff?33?33??33?33?33?33?  ?33???  ??  ?ff??ٙ?ff?ff????  ?33?33??ff?  ??33?@?33?33@   @33@33@?33@@?33@@ff@   @   @   ?ٙ?ff?33?ff?ٙ?33??33??  ?ff?33?33?33??@   ???ff?  ?  ?  ?33?33?33?ٙ?ٙ???33?ff?ff??33?33?ff?33?ff?ff?33?ff?33?33?33?33?  ?33?  ?33?33?33?ff?33??ٙ???33?ٙ??ff?33@ff@   @ff@33@ff@   ?33?33@33@   @333@&ff@   ?ٙ@@33@@&ff@l?ٙ?ff?ff@ff?33@   ?33???  ?33??ٙ??ٙ?ٙ?ٙ?ff?ff?ٙ@@&ff@?ff?ff?33@   ?33?33@&ff@ff@ff?  @   ?33?33?ٙ?33??  ?  ?33?  ?33??  ?ff?33@@33?33?ff?ٙ?ff?ff?  ?ٙ?33?33?ff?33?33?33?  ?33?  ??  ?  ?  ?ٙ?ff?ff?ٙ?  ??33?  ?ٙ?ٙ?ff???ٙ?ٙ??ٙ?ٙ?ff?ff?ff?ff?33?ff?33?33@   ?ff?33@   ?ff?ٙ?ff?ٙ?ٙ?  ?  ?  ?  ???33??ff?  ?L??33?@ff@   ?33@@@   @@   @33?ٙ@   ?ff??33????33?ff?33?  @ff?33??ٙ?ff?  ?ff?33?ٙ?ٙ?33?33?33?33?33?33?ff?ff?ff?ff?33?ff?ff?33?33???33??  ?ٙ?ٙ?ٙ?ff?ٙ?33?ٙ?33@   @ff@   @ff@ff@ff??33?ff?ٙ??33@   ?ff?33?ff?ٙ??ٙ?ٙ?33?33@ff@   @   @   ?ٙ?ٙ?ٙ?ٙ?  ?  ?ٙ?  ?33?  ?ff???33??33?  ?ff?33?33?33??33?33?33?ff?ff?33?  ?  ?33?  ?  ?  ?  ?  ??ٙ??  ?33?ff?33?33?ff??33?ff?33?ff???ff?ٙ?33@   ?ٙ?ff?ff?33?33@33?ff@   @ff@&ff@9@S33@fff@`  @s33@l@`  @@  @L@333@@??  ?ff@   @   @ff?33@   @ff@ff@ff@   @33@&ff@33@ff@@@   @@ff@@   @@   ?ff@   @ff?ٙ?33?33@   @   @   @33@33@ff@   ?33@   ?ff?????33?ٙ??ff@   ?33@ff@@@@   @   ?ٙ?ff?33?ٙ?ff@   ?33?ٙ?  ?ff?ff??@ff?ff????  ?  ?  ?  ?ٙ?  ?33?  ?ٙ?  ?  ?  ?333??fff??  ?ٙ?ff???  ?  ?  ?  ??  ?@@   ?  ?33@   ?ٙ?ٙ?33?ff?33?ff??  ??ٙ??  ?  ??  ?  ??33?ff???ff?  ?  ?ff@ff?  ??ff@ff?ff@?ff@Fff?@   ?33??  ?33?ff?33@ff?33?  ?ff?  ?  ??ff?33?ff?ff?  ?ff@ff@@33@   ?33??  ?  ?ff?33?ٙ?33?ff?ff?ff?ff?ٙ?ٙ?33?  ?  ??33?33?  ?  ?33?  ?ff?  ????  ?fff?L?333?fff?L?fff?L?33?fff???ff?  ????33?ff????  ?ff?ff?33?ff?33????????33?  ?33?ff@ff@33???ff?ff?33??ff?ff?ٙ@ff?33?  ?ff????  ?  ?33???33?ff?ff?  ?33?  ?  ?33?ff?ff?ff?  ?  ?  ?ff?ff?ff????ff?ff???????ff??33?ff?  ?  ?  ???ff??  ??ff??????33???ff?ff?ff?ff??33@  @@  ?ff?  ?ٙ?  ?ٙ??  ??33??33?  ??  ??33????ff?ff?ff?ff?  ?  ??  ?  ??ff??ٙ?ٙ?ٙ@   ?ff@?ٙ?ٙ?ٙ?@@@ff@   @ff@33@ff?ff?33?33?ٙ???ٙ?33?ٙ?ٙ?33?33?ff?ff?  ???  ??ff?ff?  ?  ?fff??fff?333?fff??333?L?fff?  ??  @@L@@Y@s33@  @33@33@  @,@9@L@@  @333@l@fff@ə@AA@陚AA33A33@ff@33@  @ff@@@33@33A  AffANffAk33ALAIAAAC33A9A|A  A|AffA{33AA33AffAp  AvffAfffAP  ATAFffA8  A$AA   A$A#33A33AA   A   A#33AffAAAA  A33A,AAAffA  A  @ff@ff@A   @33A@陚@  @ٙ@ff@  @@@ff@33@ff@33@  @@ff@@  @33@  @ə@ff@@  @s33@y@9@@  @  @ff@@  @  @ff@ff@S33@Y@fffy @ff@@`  @?33?33?ff?ٙ@@ff@@   @ff@@Fff@Y@S33@fff@@@ff@  @33@33@@ff@fff@@@ff@ff@@s33@Y@333@,@   @@`  @l@Y@33@fff@Fff@S33@9@,@,@333@ff?ff?33??ff?33??33??33?ٙ?ٙ?ٙ?ٙ?????ٙ@   @@   @,@Fff@L@L@9@333@333@333@   @   @33@ff?ٙ?33?33?33A?ff?ff?ff?ff??  ?fff?  ?fff?L?  ???  ?ff?@333@@S33?  ?ٙ??33?ff?  ?  Aff?fff?  ?fff??ff?ff?ff?ٙ?ٙ?ٙ?ٙ?ff?33?ٙ??ff?ff?ٙ???  ?ff?ff?33?  ?ff?33???????ff?ff?33?ff?33??ff?ff?ff?33?33?ff?33?  ?ff?ff?ff?ff?33?33?33?  ?33?  ?  ?  ?ٙ?  ?33?33@s33?  ?  ??ٙ?ff?33?33?  ?33?33?ff?33???33?ff??ff??ff?ff?ff?  ??  @33?ff@   ?ff???ff???ٙ?ٙ?@   ?33@@  @333@Y@Y@L@Fff@,@@   @@   @ff@ff@ff?ff?ٙ?33??33??33?  ??ff?ff?33?ff?ff?ff??33?  ?33?  ?33?33?ff?  ?33?  ?  ?  ??  ?ٙ?33?ff?ff?????ff???ff????ٙ?33?ff?ٙ???ff??????33?ff?ff?  @ff@&ff@333@s33?33@33@?33@@?33???fff?fff?fff?333?333?L?L??  @9@Y@33@&ff@@@ff?  ?ff?ff?ff?fff?  ?  ?  ?  ???ff??????33?ff?  ?fff?  ??fff?L??fff??????ff@   @33@?ٙ@   @   ?ff?ٙ???33??@   @   @@   ?33??  ?ff?ff?33?33?  ?33?33?  ?33?  ?ٙ?  ?33?  ?  ?@fff?  ?ff?ff?ff?@33?33?@   ?33???33?ff@ff@?ff?ff?ff?ff???  ?33?ff?33?33?  ?ff??ff???????  ?@   ??  ?  ?33??ff?ff?33??ٙ??  ?ff??  ?ٙ?33?  ?33?  ?  ??  ???ff??  ?  ?ٙ@   @   ?  ?  ?33??ff?ff??????  @   ?ٙ?33?ff???ff?ff??ٙ?ٙ?ٙ?33???  ???  ???  ?  ?L?  ?L?L?L?fff?L?  ?fff?  ?  ?  ?  ?fff?  ?  ?  ?  ?L?fff?  ?  ?fff?fff?fff?fff?L?L?fff?  ?  ?  ?fff?fff??  ?  ?L?fff?fff?L?L?  ?fff?L?fff?fff?fff?L?fff?L?L?  ?fff?fff?fff?L?fff?fff?fff?L?fff?L?L?@&ff?  ?ff@   ?ٙ?fff?  ?33?33?ٙ?33?  ?@   ??  ?ff?fff?fff?L?fff?L??fff?  ?  ?  @,?fff?fff?L??fff?333?????333???333?333?L?L?L?L?  ?  ?fff?  ?  ??  ?fff?fff?fff?fff?fff?  ?fff?fff?  ?fff?ff??  ??33?@@@   @33@ff@,?ff@33@333??L?  ?L?333?L?  ?  ?L?fff????  ?ff?33?ff?  ????ٙ?33@ff@33@33@ff@   @ff@   @@   @@ff@33@@   @,@9@S33@@@ff?@ff@33@@@   @   @&ff@333@   @,@,@,@   @   @@9@   @   ?ٙ?ٙ?ٙ?ٙ?ٙ?33?ff@@@   @Fff?33?ff?33@   @   ?33??  ?33@   ?33?33?33@   @   @   @33?33?33@33@   @   ?ٙ?ٙ????  ?  @ff?33@33@&ff@333@&ff@   @ff@@   @Fff@Fff@&ff@@  @,@`  @Y@Fff@Fff@   ?33?ff???ff@   @   ?ff?33?33@&ff??ff?ff??ff?@??fff?L????ff?  ?@   @L@`  @   @,@,@@ff@ff@ff@@ff@ff@33@   @&ff@33@@   ?ٙ@?  @   ?  ?ff??  ?  ?33?33?ff?ٙ@ff?ٙ?ٙ?33?ff?33@   @   @   ?ٙ@ff@ff@   ?ff?33??ff?33?  @33@ff@ff?33@   ?33?33?33?ٙ@   ?ٙ?ff@&ff@   @S33@   @9@,@   @   @33@   ?ٙ?ff???  ?333?  ?L?   >>>>>>L>L>L?ٙ?333?333?fff?   >?   ??   ?fff?  ??33?  ?ff??  ?  ?fff?L>>?   ??>>>?   >>?333??L?L?L?333?   ?333??333?333?????333???   >>L>?   >?   >?   >?   >?>??333?  ?L?>?       ==>L>L        ==>?333?   >?L?333>?333?   ?   ?   >?   ?L?L?333??  ?L>?333?333?  ?  >>L>L>?   ?333>==                            ==>L>L=>>L==>L>L=>??fff??L?  ?L??fff?fff?333?   ?  ?????  ?fff?L??   ?   >>>>>?fff?333??  ?L???333?333?333?  ?fff?L?fff?fff?333>>>L>>>>L>L>>>???????333=>L>L>L>L==    ==?>??333?   ??fff?fff?L??   ???333?L???L?  ?fff?333?fff?333>?   >>>>>>?   >>?   >>??333?L??333?333??ff>?>>?L?333??333??????333?L?fff?ff??  ?fff??  ????  ??  ?33?ff??  ?  ?ٙ?  ?ff?33?ff?33@S33@33@?33@333@33?ٙ??  ?ff?33?ff?ff?ff?ٙ?  ??ٙ?ٙ?ٙ?33?  ?33?ff?  ?ٙ?ff?ff?ff?33???33?33??33?33?ff??ff?????33?ٙ?@   @L@ff@  A+33AP  A>ffA>ffA,AK33A<A6ffA6ffA&ffA.ffA)AA;33AffA33A  @ff@ffAffA   A@A	@@  @ٙ@33@  @ٙ@ٙ@ff@33@  @@  @33@33@ff@@  @ff@@33@@@@33@@@  @@33@33@  @33@ff@33@@33@@  @33@  @ff@@l@Fff@@y@l@ff@`  @fff@s33@L@,@,@33?@ff@33@&ff@   @333@?33@333@   @@   @33@33@@33@@@33@33@@   @33@&ff@333@9@ff@`  @@y@s33@s33@l@`  @fff@9@  @s33@s33@fff@ff@  @`  @s33@,@,@S33@`  @l@s33@Fff@@  @9@L@@  @L@Fff@333@9@,@L@333@,@&ff@,@9@9@9@S33@@  @@  @l@`  @Fff@9@,@333?  @   ?  @@333@@  @333@&ff@,@&ff@333@333@&ff?33@@@?ff@33@@   @   ?ff?ff?ٙ?ٙ????  ?  ???ff@ff?33@ff@33@   @9@9@Fff@Fff@Fff@9@   @@&ff@ff@33@ff@33@@@ff@&ff@33@ff??  ?ff???ff?ٙ@   @   @ff@   @ff@?33@   @   ?ff@ff@33?ff@   ?33?33@ff@@&ff@,@,@333@Y@@  @S33@`  @S33@@  @Fff@Fff@9@9@&ff@@@@   @   @ff@ff@ff@@   @   ?ff@@@   @33@@33@33@?33?ff?ff?  @   ?33@33@   @?33@ff?33@ff@@   @?33@   @ff@ff?33?33?ff@33@ff?ff?33@@@  @@  @ff@ff?ٙ??ٙ??33?ff?33?ٙ@?33?ff?33???ff?ٙ??ff???33???ff?33??  ?fff?  ??fff?L??  ???fff?fff?  ?33?33?ff???fff?fff?  >>L>?   >>?   ?   ?L?L?fff?  ?L?L?fff?L?   ?333?   >>>?333??   >???333>?   ?   >>>?   >>?   >?>?   >?L?L?fff?fff??  ?  ?  ?ff?ff?L??fff?fff???333?>>>L    >?>?   >???333??   ??   ?333???   ?333?333??   ?333???fff?  ?????  ??  ?fff?L??L?L??L?333?333?333?333?333?333?L?333???333?   ?   ?   >??   ??   ?   >>>>>>?333>>L>L>=>L>>?   ?   ?333?L?fff?333??333?L?fff?L?333??   >?   >    >=    ?   >?fff?  ?L?fff?>        >L=>L>L?    >>>=    >L>L>L    >L    =>>>L>>>>>>=>L>L=    ===>L>L=        =    >?   ?   >L?   ?   ????333?   ?   ?  ??  ?33?ff?ff?33?ff???????  ??333?L?333?  ?  ???  ??L???   ==>L>L>L>L    >L>L>L>L>    >>L            >L=>L>L>L=>L>L>L>L    =        =        =    =>L?>?   >L>L>L==>L=    ====    >L>L        >?ff?fff?333>>>L>>>L    >L?   ?   ?   ?   ?L?333??   ?   ?>?   ?333?333???   ?333>?>=>L>L>?333?fff?>==>>L==    =        ==>L        >?L?333?333?333?333?   >>>L>L==            =>L=        >L?>>????333?333??ٙ?ff?  ?  ???fff?ff?ٙ???ff?ff?  ?ٙ?  ??   ?>>?33?333>>>>>>??  ??333?333?   ??333???   ??  ?L??   >?333?L?L?L?fff?  ?ٙ?  ?L?L?fff???  ?L?333>?   >>?   >>>>?L>?L?  ?L??333?   ?333?333@?ff?ff?ff???33@33?ff?fff?  ?  ?fff?333??fff?L?>?333?333?333?L?333?333?????   ?????   ??   ??   ?   ??   ?   ?333?   >?   ?   Ay???   >>>>?   ?   ????333?fff???  ??33??333?L?   ?L?  ?L?33?33??L?   >L>L>L>>>??>>>>>L>?333>>?   ?   ?   >=            >L?@   @?ff?ff?  ?33?33??33?ff?   ?L>>>?333??   ?   ??   >>>?   >?>>>>>L==>>>?   >>?   ?   >>>>>>==    ?   =?  ?=>L>>?L?   ?   ??333?  ?  ?ff?ٙ?ٙ???ff?  ?  ?  ??33?33??ff??33?  ?fff?  ?ٙ?33?ff?ff?333?   ?>>L>>L>>L>L>???333??L?fff?fff?33?ٙ?333?   >>>??333???   >?   >?>?   >?   ?   ?>>L=>L?   =?   >>y y ?  ??L?  ?33?33?33?  >?L?@ff>>>==    >L?   ???fff?L??L?L>?   ?333?ff?333?   B&  ?   ?   >>>??   >>>?333>?   >>>>>>>L>L>>?333???>>>>>L==>?>L>>>>L?   ?>>>L>L=    =??fff=>L===    >>L    =??L?333?333?333?       =            =?   ?fff?  ??ff??ff@Y@9@`  @33@y@,@?333>>>L?@ff???L?   ?  ===?   ??   @ff?   ??333?>??   ?>?   ?   @&ff?333?   ???333??  ?L?L?L?  ?  ?L?  ???ff???L?L@33@ff@ff?  ?33?33??fff?L?333??   ?333?L?ff?  ?333>>    ?33?ff?  ??ff??????????????  ??ff???????????  ?ff????33?  ?33?ٙ?  ?33?33??  ?  ?  ?  ?  ?33?ff?  ?33?ff???????????  ?33?33??@?33@ff@,@@  @@?33?  ?33?33?33?ff?33?ff?ff???ff?33?ff?  ?33?33?33?ff?33?ff?ff?  ?ff???ff????  ??ff???ff?ff????ff?ff?  ?ٙ?ff@33@@L@9@   ?  ?ٙ??ٙ??ff?ٙ?ٙ?ff???  ?33?????ff??ff?33?33?ff??ff????  ????ff??33?  ?33?  ?  ?  ?ff??ff?33?ff?  ???33?ff?ff?ff??ff?ff?ff?ff?33?  ?33?33?33?33?ff?  ?  ??ff?33???  ?  ????ff?  ???  ?fff?fff?L?  ?  ??fff??  ????????33??  ?  ?  ?  ??  ?  ?  ?  ?  ?ff?ff?33?  ?????ff?ٙ??ٙ@33?33?ٙ?  ?33??ff??ff?ff?ff?33?ٙ?  ?ff?ff?33?33??33?33?ٙ@ff?ٙ?33?  ?  ?  ?ٙ?33?33?  ?  ?ff?33?ff?ff?ff?ff?ff?ff?ff?ff?ff?33??ff?ff?ٙ?ff?ٙ?ff?33?ff?ff?33?ff?ff?ff?33?ff?ff?ff?ff?ff??ff???ff?????ff?????ff?ff??ff?ff?ff?ff?ff?  ?ff?ff??????????ff?33?  ?33??33??ff??33@   ?ff??ff?33?ff@ff@ff@ff?ff?ٙ@@   @,@ff@@   ?ff?33?33???ff@@?33@@L??33??  ?33??  ?33?ٙ?  ??ٙ@9@Fff@fff@&ff@   @S33@33@&ff@,@9@&ff@33@   @@@   ?33?ٙ??ff??ff@   ?ff?ff?ff?ٙ?ff?33?ٙ?ٙ??  ?33??  ?ff??ٙ?ff?ٙ?ٙ?  ??ٙ?ٙ?ff?ff??ٙ?ff?ٙ???  ?  ???33???ٙ??33?33?  ?  ?  ?  ?  ?  ?  ?ٙ?ٙ?ٙ?  ?  ???33??ٙ?ٙ?33@ff@   ?33?ٙ?ٙ?ff?ff?33?33?ٙ?  ??ff?ff?  ?33?33@   ?ff@ff?33@   ?ff@ff@@@@ff@33@33@33?ff@?33?ff?ٙ?  ?ٙ?  @9@@   @   ?ff?33?33?33?33@   ?33?ff?33?33?33?ff?ff?ff?ff??ff?ff?ff?ff?ff?33?ff@ff@   @@@ff@33@   ?ff?33?ٙ?33@ff?ٙ?ff@   @   @ff@ff@33@@   @@   @ff?ٙ??ٙ?  ?ٙ@?33?33?ٙ?  @33@@&ff@&ff@ff?ff?ff?33?33@   ?33@   ?ٙ@ff@ff?33?33?  ?ٙ?ff??ff?ff??ff?ٙ@   @ff@&ff@@   @@333@   @,@33@,@   @??ٙ@   ?33?ff??  ?33?33?33?  ?33?33?ff?ٙ?  ?  ?ff?  ?ٙ?  @   ?ٙ?ff?33?ff?ff?ٙ@   ?33@   @@&ff@   @@  @   @&ff@,@,@@   @@@9@L@333@333@@  @   @@ff@9@333@&ff@333@333@9@,@333@9@L@Y@L@L@9@@33@?33??  ?ٙ?@   @33@&ff@,@,@   ??  ?  ?fff?  ?fff?  ?  ?  ???ff?ff?  ?  ?  ?  ??  ??ff???  ???ff???  ?  ???33?????ff?  ??ٙ?ff?ff?33?ff@   @ff@@@33@   @   @@@@@@33@@33@@33@ff@@@&ff@   @   @,@&ff@333@@&ff@@   @ff@@@@@   @,@   ?ٙ?33?33@9@@?ff?  ???????  ?fff?L?L?fff?fff??  ???  ?????  ?  ?L?L???  ?  ????ff?ff???  ?  ??fff??  ?  ?  ??ff?33?ff?ff?33?  ?  ?  ?ff?  ??33?33?ff@@ff@   ?33@@ff@ff@   @@   @@33@@@?ٙ?33???  ?fff?  ?fff?  ??fff?fff?ff?ff?33?ff???  ????33??  ?  ?fff?fff?fff?  ????ff??ff?ff????33?????  ?ff?  ????  ??fff?  ?  ?  ?  ???  ??  ????ff?  ?  ?ff?  ?  ??  ?  ?333?  ?  ??  ?  ?  ??fff?  ???  ??????ff?ff@  ?ٙ@   @   @   @ff?ff@ff?33??fff?  ??  ?fff????ff?33????fff?L?fff?fff?  ?  ?  ?  ??  ??  ?fff?  ??????  ?  ?  ?  ???fff??fff???ff??ff?ff?33?33?  ?33??33?33??  ??33?  ??????ff?????  ??  ?  ?fff?  ?  ?fff??  ?  ??  ?  ?  ?  ?ٙ??33?fff?  ?fff?fff?fff?fff?ff??ff?ٙ?ff?ff?  ?ff?33?ff?ff?33?33?  ?33?33?  ?33?33?ff?ff?33?33?  ?33?ٙ@,@   ?  ?33?ff???  ??ٙ?ff?  ?33?33?ff?  ?  ?  ?33?33??33??ff??ٙ?ff??ff?33?ٙ?33@?33@33?ٙ?  ?  ?????????ff?33?33?ff????  ?33?  ?ff?ff?33@   @@?ff??ff?ff?ff@   ?33?  ?  ?ٙ?ٙ@?33?33@   ?ٙ@   ?33?33@33@ff@ff@,@@l@Fff@   ?ٙ?ٙ?ff@@33@33@   @33@@@@   @   ?33@   ?33@   ?33@   ?ff?ff?ff?ٙ??ٙ??ff?ff?ٙ?  ?33?  ?33@   ?33??ff?33????ff?ٙ?ff?ٙ?ٙ?ٙ@   ?ٙ@ff?33@@33@@33@@?33?  ???????ff?33?33?33?ٙ?ٙ?ٙ?33?33@   ?33?33?33?33?ff?ff@   @ff@   ?33@@   @@ff@@333@333@@@   @,@9@333@9@333@333@,@&ff@   @@@@@@@@ff?33?33@ff@@33@   @&ff@@33@@@@ff@ff@   @   ?33?33@   @   @?@ff?33@   ?33?ff?ff?33?33@ff@33@ff@@   @   @&ff@@&ff@ff@@33@&ff@@33@@ff@   @   @ff@?33?ٙ?ff?ٙ?33?ٙ??ٙ???33?33?33?33@   @   @ff@ff?33@   ?33@@   @&ff@&ff@&ff@,@333@@  @333@  @Fff@Fff@@  @9@9@9@9@,@&ff@&ff@333@   @   @@@ff@   ?33?33@?33@   @ff@@ff@@   @@33@@@@@@@ff@33@@ff@33@@33@   @&ff@333@@@33@   @@@33@@?33@   @S33@   @`  @fff@fff@Fff@Fff@Y@,@fff@`  @fff@333@,@,@,@&ff@&ff@&ff@@  @9@Fff@Y@y@  @ff@@@33@  @ff@33@@@`  @l@ff@l@33@@  @  @33@y@l@Y@Fff@9@@  @L@9@9@Fff@@  @333@Fff@S33@@  @Fff@9@@  @@  @Fff@9@9@@  @@  @9@333@333@@  @333@,@   @333@&ff@ff@33@9@Fff@Fff@Fff@Fff@S33@Y@Fff@L@S33@@  @Fff@333@333@&ff@33@33@@ff@33@33@33@@@,@@   @&ff@33@@33@   @   @ff@33@33@@@ff@@@@ff@ff@@,@,@&ff@,@   @@@@33@   @&ff@333@333@L@9@,@,@&ff@@  @,@,@@  @Fff@`  @`  @L@Fff@9@@  @@  @@  @@  @333@333@9@9@9@333@9@33@333@9@333@333@,@333@Fff@Fff@9@@  @@  @Fff@Fff@Fff@9@@  @@  @Fff@L@Fff@Fff@Fff@Fff@333@@ff@333@,@   @&ff@   @   @   @,@&ff@   @   @@   @&ff@&ff@9@&ff@   @&ff@333@Fff@S33@@  @Fff@9@S33@L@@  @@  @333@9@l@S33@L@L@L@9@333@,@,@,@333@&ff@   @@&ff@&ff@@   @,@,@333@9@Fff@Fff@L@`  @fff@Y@S33@Fff@9@S33@Y@Fff@9@333@333@333@,@&ff@333@,@&ff@9@S33@S33@S33@@  @S33@,@@  @@  @&ff@9@9@@  @,@   @&ff@33@@   @&ff@,@&ff@333@,@333@333@,@&ff@,@@@33@33@@@Fff@S33@Fff@L@   @,@S33@`  @Y@&ff@@   @   @&ff@   @   @   @9@   @&ff@L@fff@`  @y@  @l@S33@L@Y@l@l@fff@fff@fff@fff@fff@fff@fff@fff@l@fff@Y@`  @fff@Y@Fff@Fff@Fff@Fff@Fff@333@@  @9@@  @@  @   @&ff@@  @333@333@&ff@,@333@333@@9@333@,@@  @33@fff@l@l@y@s33@  @ff@y@@ff@fff@l@Y@Fff@9@S33@@  @Y@@  @Fff@S33@S33@`  @L@L@9@333@9@@  @9@9@333@&ff@   @,@,@   @Fff@,@,@@  @`  @Y@S33@Fff@`  @@33@@  @@  @  @  @@33@33@ff@  @ff@  @@  @  @ff@@@  @@@@@ff@  @  @@@33@l@`  @`  @L@`  @Fff@S33@@  @@  @@  @`  @S33@L@L@fff@S33@Y@S33@`  @Y@Y@Y@S33@Fff@s33@@  @333@&ff@,@Fff@9@@  @Y@L@`  @y@l@l@fff@fff@`  @@33@@ff@33@@@@  @@ff@33@@33@ff@33@@ff@@@33@  @@33@ff@@ff@@S33@Y@s33@`  @y@ff@33@@@33@@33@@ff@@@@@33@33@@ff@33@ff@@@@ff@33@  @33@33@@@@@33@  @ff@33@s33@s33@Y@Y@Y@Fff@S33@Y@Fff@333@,@Fff@S33@S33@9@9@9@9@,@333@9@9@@  @L@Fff@,@9@,@333@&ff@   @&ff@&ff@&ff@&ff@@  @Y@Fff@9@@  @@  @   @33@@  @L@S33@@  @,@S33@Y@L@S33@S33@,@Y@L@9@9@S33@S33@S33@&ff@,@&ff@33@   ?ٙ?33?ٙ?33@   @   ?ff@   @   @@   @33@   @&ff@   @@@33@333@ff@@ff@ff?33?ff?33??33?ff??fff?333??ff?fff?  ????  ??ٙ?ff?ff?ٙ??  ?  ?  ?33?  ?33@   @@ff@   ?33@L@&ff@,@   @fff@l@&ff@9@,@@y?ٙ?@ff@@ff?33?33?33??L?  ?fff?  ?fff?fff?333?L???  ?ff??ff?ff?  ?ٙ????ff?  ??fff?33??  ?ff?  ?  ?  @&ff?ٙ?ff?  ?33?ff?ff?ff?  ?ff?ٙ??ٙ?  ??ff?33?33?  ?33?ٙ?33?  ?  ??  @   @?ff?ٙ?  ?ff?ff?ff?  ?ff?ٙ??ff?????ff?ff?ff?ff??????ٙ??  ?fff?L?fff?fff?fff?  ?L?fff?fff?  ?  ???  ?  ?  ?33???  ??ٙ?33?33?ff?fff????ff??ff?ff?33?ff?ff???ff?33???ff?ff????333?33?ff?ff?ff?ff?ff???  ????333????  ???ff???????????33?33?  ??ff?????33?33@,@ff?33?33?ٙ@?  ?ٙ?ٙ@@?33?ٙ??  ????  ?fff?fff?L?fff?333?fff?fff?  ?fff?fff?  ?fff??  ?  ??  ?  ?fff?  ?fff??  ?  ??  ??  ???fff?  ?  ??  ?fff?  ?  ???  ???fff??  ??  ?fff?fff???fff?L????  ?fff?L?fff?fff??fff??  ?33@?33?@   @ff@Fff?33?33?  ?  ?L?333?fff?333?333?333?333??fff???333?333?L?fff?333?333?  ?L?L?L?L?fff?  ?  ??fff???333??333?333?L?ff?ff?ff?ff???  ??fff?  ?fff?fff??333???fff?  ??  ??????????  ?  ???  ?ff????ff?  ???333??333?fff?L?L?333??333????L???333??333???  ?  ?L?333??333???333?333?333?333?333??333?333?fff?L?fff??333?333?333?333?333?L?L?L?  ?L?L?L?L?L?fff?  ?fff?fff?L?L???   ??   ?   ??333?L??   ???   ?333?333?333?  ?  ????fff?L???  ?333?333?L?333?L?fff?fff?fff?fff?L?fff?333?333?333???   ???   ?   ??   ?fff?   ?   ?   ?   ?   ??   ???333?   ?   >?>>>>>>>?  >>L>>>L>>?   ?   >??   ?   ?   ?   ??????L??333?L?333?333?L?333?333?L??333?333?333???   ??333??   >>>L>>>>>L>>>>>?333?   >?   ????333?333??333?333?333?333?   ???333??   ?L???   ?   ?   ??33?   ?   ?   ?   >>>>?   >>?   >>>>>>?   >?   ?   ??   ?L?333?  ??333??333?L?L?L?fff?fff?fff?333?333?fff?fff????ff?ff?@@9@S33?33?ٙ??ff?33????  ?  ???  ?fff??ff?  ???fff??  ????  ?  ????  ?fff?  ?fff???  ?fff?fff?fff?fff?  ???ff?33?33?@   @?  ??33@   @33@&ff@?  @   @   @,@   @   @?ٙ??  ?  ??33?  ?ٙ?ff?33???ff?  ?ff?33?ff?ff?ff?ff?ff?ff?ff?ff?  ?33?ff?ff?ff??ff?ff??ٙ?33?  ?33?  ?  ?  ?  ?fff?  ?L?L?333???fff?fff?333?fff?fff??  ??fff?fff?L?fff?L?fff?L?fff?L?L?  ?333?333?L?333?333?333?  ?fff?L?L??   ?   >>?   ??   ???   ??????   ?   >>>>>L>=?   >L>?   >>>L>L>>L>==>>?>>L>>?   ?fff?L?L?L????33?33?33?ff?ff?????  ????ff????ff??ff?????  ?  ???ff??ff??  ?  ?  ?fff?  ?ٙ?  ??????33??33?  ?ٙ?33@   ??  ?  ?  ?ff?ff???ٙ?ٙ?ff?ٙ?ٙ?ff?  ?ff?  ?33??ff?33?ff?ff?ff?ff?ff?  ?ff?ff?ff??ff??33?@ff?ff?33?ٙ?  ?33?ٙ?33?  ?33?33?  ?ff?  ?  ?fff?fff???33?  ??33?  ?33??ff?ٙ?ٙ??33?33??33?ff????  ???????ff?ff?  ???ff?33?33?ff?ff?ٙ?  ?  ???ٙ?ٙ?  ?  ?  ?33?ff?ٙ??ٙ?fff?fff?ff??ff?ff??ٙ??ٙ??ٙ?ٙ@   ?33@@   @33@@33@33?33?@   ?ff@ff@@33@@33@33@@@,@33?ff?ff@&ff@   @ff@   @   ?ٙ?ff??  ?  ?????ff??  ?ff?ff?33??ff?33???ff?33?33?33?  ?  ?33?33???ff??>>?333?  ?   ?333?   ??>?   ??   >?L?  ?ff???333??   ?   ?   ?fff?   ?   ?333?333??L?fff?  ?333?L?fff@   @   ?33@   @   @ff?ff?ff?  ?ff@   ?33@   ?ff?ٙ?ff?ٙ?ٙ?????ff?ٙ???fff?  ???  ??  ???333?333?333?L?ff?333?333?333?L????333?333?333?fff?L?fff?fff?fff??  ?  ?  ?fff??  ??33?ٙ?ٙ??33??ff?ff????33??  ????????33@33@ff?ff@ff@ff@ff@ff??ٙ??  ?33?33?@?33?????  ?fff?L?fff?L?  ?  ?  ??L??L?333?333?333?333?>?333?   >>=>>???   ?   >>?fff??fff?  ?  ?ff?  ???  ?fff???L??   ??333?   ?333?L?L??333?L>?   ?333??333>?   ?333?fff?  ??  ?ٙ@陚?L?333?L?333?333?   >>>>>>>>>>?   ?   >?   >>>>??   ?   ?   ?   ?   >>>?   ?>?   ?   ?333??   ?333??L??L?fff?fff?L?L?333?L?333?L?333?fff?333?fff?333?L??333?   ?   ?L?333?L?333?fff?  ?  ?33??ff?ٙ?  ?  ?33?@   @@,@   ?33@   @?ٙ?33?ff@ff?33??   ?   ?   >>>>?   ?>>>>>>>>>>?   >>>>>L>>>>>?   >?   ?   ?333?   ?   >>L?   ?333?>>?   ?   >?   ?   ?333?   ??   ?333???   ?   ??   >>?333>?   ?>?   ?   ?  ???   ?333?fff?fff?L?  ?ff?fff?  ?  ??ff??fff?fff?  ?fff?333?L?333?333?333????L?333???   ?   ?   ?   >>>>L>L>L>>L>L>L>L>L>L>L>L>>?   >>?   ??333??333?   ??fff?>?   ?   ?333?333?   ?   ?   >?>>>>>?   >?333>?   ?   ??fff>>>>>>L?>>L?333?   ?   >>>?   ?>>L>L>>L>L?   =>L>L>L>L>>L>>L>L>>L>>L>>L>L>>L>L>>L>L>L=>L=>L>>L>L>L>>L=>L>L>L>?   >>>?   >>>>>?   ?   ?   ?   ?   ?   ??333?   >L=>>L>L>L=    =>L>L>L====>L===>L>L>L=>L>L=>L>L=>L    =>>L>L>L=>L??333?   ??   ?   >???>>?   ?L????fff?  ?33??  ?fff???333?fff?L?L?333?L???L?333?L?333?>?   ?>>>L@@?333>>L    ?333?   ?333?L?333?333?L>?L?L?333?>>>L?   >>>>?333>?>>>>>>>>>>>>L>L    >L>>L>>>?   ?   >>>>>L>>?   >>>>>>>?   >?   ?   ?   ?L???L?   ?   >>>>>?L?  ???fff?L?333?L?L?L?fff?fff?333?333?fff?333?333?L?fff??fff??L?L?333?L?L?333?  ?333>?   ?333?333?333?L?L?L?L??333?L?fff?L?>?333?333?L?L?L??>>>?   >>>>?   >>>>>>>>?   >>>?   >>L??   >L>>>>L??   ?   >??L?333??  ?333??  ?fff?   ?L?333??333?  ?fff?  ?  ?  @ff??ٙ?  ?  ?fff?  ???  ?ff?33??ff???  ??  ?fff?L??  ?fff?fff?  ?L?fff?L?fff??fff@33?fff??L?fff?fff?L?fff?fff?L??333?L?L?L??333?333??   ??   ?   ?333?333???ff?333?333?333??333??   ??333?L?333?333?   ?  ?33?fff?L?333?>?   ?>>?   ?   >?   >>>>>?   ?   >>?   >?   ?333?333?>?   ?   >>L?   >>>>?   ?   ???L????  ??  ??>>>?   ?   ?   ?   ?333?   >>>>?   ?   ?   ?   ?   >>>?   ?   ?   ?   ?   ?   ?   ?  ???333?333?333?   >>L>?  >?   >?>L>>>L>>>L>L>L>>L>>>>????>?   >>>>>?ff?   >L???   ?   ??333??333?   ?   ???  ?  ?fff?fff?fff?333?  ??   ???   ?333?333??333???  ?fff?  ?  ?   ?333?fff?333?333?333?L?333?L?333?333?333?L?L?L?L?fff?fff?33?ff?ff?33?fff?fff?L?fff?333?  ?L?fff?fff?L????L?333?333???L?L?333?L?L?333?333?L?L?L?L?  ?33?  @   ?  ?ff?ٙ?ff?ff??fff?  ?fff?333?L?fff???fff?  ?  ??fff?  ??  ?  ?L?fff?  ?fff?fff?fff?fff?  ?  ?fff?L?L?L?fff?L?L?L?fff?333?L?L?L????   ?333?   ??   ??333??   ?   ?   ?333?   ?   >>>>>>>L>L>L>L=>???   >>>>>>??@ff?333?333?333??L?L?333?  ??ff?  ??  ?ff?ff??ff????  ?fff?  ???   ?333??333?333????  ?  ?fff?L?  ?L?333?L?L??  ?  ?fff?  ?fff???  ??fff?L?  ?????33?@@ff@33@@&ff@&ff@33?33@?ff?ٙ?33???ff?  ?  ?fff?fff?  ?333?L?L?333??L?333?L?333?333??333?333????333?333?L?333?L??fff?333?  ?L?L?L?L?L@?L?L?L?fff?fff?  ????  ?333??  ??fff?333?   ?   >?   ?   ??   ???333?333?   ??   ??   ??   ?   ?   ?L>>?>>>>?   ?   >?   ????333?333?333????333??L?fff?fff?333?333?333??333?fff?333?333?333?333?333?333?L?L?333A=qA=qA=qAAA=qA=qAAA=qAA=qA=qAA=qA=qAAAAAA\  A:HA\  A}AA\  A\  A\  A}A\  AAAA}AAA}A}A}A}A}AA\  A}A\  A\  A}A}A}A\  AAA\  AA\  A}AA\  A}AAA}A\  AAAA}AA}A:HA}A}A}A}A\  A}A\  A\  A\  A\  A}AA:HAA@
=AAA:HA:HA}A}A}A\  A}A:HA:HA\  AA\  A\  A:HA:HA}A}AA}AAA}A:HA:HA\  AAA:HA:HA:HA\  A}A:HA:H@GAA}A\  A:HA}A:HAA:HA:HA:HA:HA:HAA@GAA@Y@GA@G@G@GA:HA\  A\  A}@GA:HA:HA\  A\  A:HAA:HA:HAA:HA:HA@G@GAAA:HA:HA:HA@G@GA@G@GA@Y@
=@G@
=@GAA@
=@
=@Y@
=@G@GA:H@GA:HA:HA}A}AA}A\  A}AA\  A\  A\  A\  A:HA:HA:HA:HA:HA\  A\  AA}A\  A\  A\  AA\  A\  A}A\  A}A:HA}A}A\  A:HA\  A\  A\  A:HA\  A\  A\  A\  A:HA\  A\  A}A:HA:HA:HA\  A:HA@GAAA:H@GA:HA:HAA}A}AA:H@GA:H@GA:HAA:HA:HA}A:HA:HAA\  AA}A\  AA\  A:HAAAA:HAA\  A}AA\  A:HA\  A}AzA\)AAAA=qA=qAA\)A=qAA=qAAAAA=qA=qA\)AAAA=qAAAAA}A=qAAA}AA=qAAAAA}AA=qAAAAAA=qA}A}AAA}AAA}A}AA}A}A}A}A}AAAA\  A:HA\  A}AA\  A\  A\  A}A}A:HA\  A}A:HA\  AA\  AA}A\  A}A\  A}A}A\  A}A}A\  A}A}A=qAA\)A\)A\)AAA=qA=qA\)AzB	B\)B\)B{B{B{B{BA=qA\)BB*ABBB	B"B*B*B*B\)B"B	A=qA=qA=qA=qAA=qA=qAA\)AA\)A\)AzA\)A\)AA\)AAAA=qAzAAA\)A=qA\)A=qAAAAA=qA=qAAA=qAAA=qAA\)AA\)AA=qA=qA=qAAAA=qA=qAAA}A\  AA=qAAA\)AAA\)B{AzB{B{B*B*B333B"B"B\)B{B"B{BB	B	BBA\)AzAAAAA\)AzABA\)AzA\)AAzAzA\)AAA\  A}@G@G@
=AA:H@GAA\  AA\  A:HA}A\  A:HA:HA:HAA}A\  A}A:H@G@GA:HA\  A:HAAAA:HAAA:HAA}AA:H@
=A\  A\  A\  AA:HA:HA:HA\  A:HA\  AAAAA}AAAAA\)AA\)A\)AAAzAzA\)AzA\)A\)AAAAAAAA=qAAA\  A\  AA}AAA}AAAAAAA\  A:HA:HA\  A}A\  A\  A\  A\  A:HAA:HA\  A\  A\  AAA\  A:HA\  A:HAA:HA:HA@
=@G@GA:HA@Y@G@
=AA:HAAA:HA}AA:HA@G@
=@
=@G@
=@
=@G@GA@GA:HA:HA\  A\  AA}A\  A}A\  AA}AA=qAAAA=qAA}AA=qA=qA\)A=qAAA=qAA=qAAA\  A\  A\  AAAA}A\  A\  A\  A}A\  A:HA\  A\  A}A}A:HA\  AA:HA:HAAA:HA\  A:HA:HA:HAA@
=AAA:HA\  AA:HAA\  AAA@
=AA:HAA:HA:H@
=AA\  A@G@G@
=@G@
=AA@
=@G@G@GA@GAA:HA\  A\  A:HA}A}A}AAAAzAzBB"B{B\)B"AzBB	AA=qAzAA}A}AA:HAA=qA\  BAzB{B*Bm(B;zB\BupB  B  B}RBTQBupB}RBdHB;zB{AzBAB	AB"B{AzAzAzBB{AzA=qAA=qA=qAA=qA\)A\)AA\)AzAAA}AAAAA}A}A}AAAA\  A\  A}A@
=AA@Y@
=AA:HA\  A}A\  A}AAABB{BCB*B"B;zB333BL
=BL
=B\Bm(BdHBupBdHBpB#B}RBdHB333BCBBL
=B333B\)A\)A\)AA\)AB	AAA=qAAAAA=qA=qBAA}A\  A}ABAB	AzAzBAzAAA=qA}A\  AAAA}A}A\  AA}A\  AA\  A\  A\  AA@GAA:H@
=A@G@G@GA\  AA:HA:HA}A}A}A:HA}AA=qAAAzBB{BL
=B\B#B#B)B#BGBkB#B3B)BB
B\B{BkB
BBBkB
B)B  BRB#B#B;zBdHBL
=B333BTQBCB\)B\)B{AAzAABBB\)AzA\)AzA\)BA=qA\)B	B\)BB{B	B{AzAB*BTQB*B	BAAA\  AAA}A\  AA\  A\  A}AAAA}AAA}A}A}A\  AAAA=qAA}A}A}AA\  A\  @GAA\  A}A}A\  AA:H@GA:HA@
=AA\  A\  B*B"AAA=qAA:HA@GA\  AA\  AA=qA}A=qA=qAAA}AAA:HAA:HAA}A\  A\  A:HA\  AA\  @GA:H@G@
=AAA@G@GA@GAA@
=@G@G@G@G@
=@G@G@G@
=@G@GA@GA@G@G@
=@
=@
=@
=A@
=@
=@
=@Y@Y@G@Y?=q@Y@Y@
=@
=@GA@GAAA:HA}AAA\  A}A}AAA\  AAA:HA}A}A\  A}A:HA\  A\  A:HA:HA}A\  AA\  AAAAA:HA@G@GAA@GAAA@Y@
=@G@Y@
=@
=@
=@
=@G@G@
=A@
=@Y@
=@
=@
=@Y@
=@Y@
=@Y@Y@
=@
=@
=A@
=@
=@G@
=@G@G@Y@
=@
=@YA@Y@Y@Y?=q@Y        @Y?=q@Y?=q    ?=q@Y@Y@
=AA:HA\  @G@G@G@GA:HA\  A}A:HAAA:HA:HA\  A:HA}A\  AAA@GA:HA@G@
=@G@
=@GA@GA@G@G@
=@
=@G@GA@G@G@Y@
=@G@
=@
=@G@G@
=@G@
=@
=@
=@
=@
=@Y@Y?=q?=q@Y@Y@Y@Y@
=@Y@Y@G@G@Y@G@G@G@G@G@G@
=A@G@GA@Y@Y?=q@Y@Y@
=@Y@Y@Y@
=@Y?=q@G@Y@
=@
=@GAAAA\  A\  A:HA\  A\  A}A\  A}A}A\  A\  A}A}A}A}AA\  AA@GA:H@G@
=@Y@
=AA\  A}A\  A\  A:HA\  A}A:HA:HAAA\  @G@G@
=@GAAA@GAAA:HA@GAAA:HA@
=@GAAAA:HA@G@GAAAAA:HAA:H@Y@G@G?=qA@G@
=@
=@G@
=@Y?=qA@Y@G@Y@
=@G@
=@G@YA@GAA:HAAA}A}A\  A\  A\  A:HA\  A\  A}AAA}A}A}A\  AA}AA}AAA}AAA}A\  A\  A\  A}A}A:HA:H@G@GAA\  A:HAA:HA:HA:H@
=AA:H@GA:HA:HAA:HA@GA@G@G@G@YAAA@GA@G@G@GA@
=A\  AA:H@GAAA@GA@Y@G@
=@Y@G@G@G@
=@Y    ?=q@
=@Y@Y?=q@
=@
=@GA@
=@GAAA:HA:HA\  AAAA:HAAA:HA\  AA@GAA:HAAA:HA:HA@G@GA:HAA:HA:H@G@G@G@G@GA@G@
=@
=@G@G@G@G@
=@G@GAA:HAA@GA\  A:HA:H@GA:HAA:H@G@GAA:HA:HA:HA:HA:H@GA@
=@
=AA:H@G@
=@Y@
=@GA?=q@Y@
=    @
=@Y@Y@Y?=q?=q@
=@Y?=q@
=@Y@Y@
=@G@
=@
=@G@G@
=@G@
=@
=@Y@G@G@
=@G@G@
=@G@
=@G@
=@
=@Y@Y@
=@
=@G@G@G@
=@G@
=@
=A@
=@
=@
=@
=?=q@Y@
=@
=?=q?=q@G@G@Y@
=@Y@
=@Y@Y@
=@Y?=q?=q@Y@G@Y@Y@G@Y@G@
=@
=@Y@Y@
=@Y@
=@Y@Y@
=@Y?=q@Y@
=@
=@G@Y@Y?=q?=q@Y@Y    @Y        ?=q?=q@Y@Y?=q?=q@
=    @G@
=@
=?=q@GA@
=@GA@G@
=@GA@GA@GA:HA@G@G@G@GA@
=@G@
=@Y@Y@
=?=q    ?=q@Y?=q    @G?=q@Y?=q    @
=@
=?=q@
=?=q            ?=q@Y?=q@Y?=q@Y@Y    @G@G?=q@Y@
=@Y@Y@Y@Y@G@G@G@
=@Y@
=@G@
=@
=?=q@Y?=q?=q    ?=q@
=?=q?=q@Y?=q@Y    @Y?=q@Y@Y@Y@
=@Y@
=@G@YA@
=@
=A@
=A@GA:H@
=A:HA}A:HAAA\  A}A}AA:HA:HAAA:HA@GA@G@GA@
=@
=@
=@G@Y@
=@G@
=@G@
=A@G@G@GA:H@G@GA@G@
=@G?=q@
=@Y@G@Y@G@Y@
=?=q@
=?=q@
=@Y@
=@Y@Y@
=@
=@
=?=q@G@
=@
=?=q?=q?=q@Y@Y@
=    @G@Y@Y@Y?=qA@Y@Y@
=@G@
=@
=@
=@
=@
=AAA:HA:HA:HA:HA\  A@G@GAAAA@
=AAA:H@G@
=@G@G@GA:H@GAA\  A@G@
=AA@GA@G@
=A:H@
=A@
=@
=@
=@Y@G@Y@YA@G@G@Y@G@
=@
=@
=@
=A?=q?=q@Y?=q@Y    ?=q    @Y@
=@Y    @Y@
=?=q@Y@G?=q?=q?=q?=q    @Y    ?=q?=q@Y@Y@Y@Y@Y@
=@Y@Y@
=@G@Y@Y@Y@Y?=q@
=@Y?=q@Y@
=@G@
=@
=@GAAA@G@Y@
=@G@G@
=@G@GA?=q?=q@Y@
=@
=@Y@G@Y@
=@G@
=    ?=q@
=@Y?=q@
=@Y?=q?=q    @Y?=q    ?=q?=q?=q    ?=q@Y    ?=q?=q@Y?=q            ?=q    ?=q            ?=q    ?=q@Y@Y?=q?=q@Y?=q    ?=q@Y?=q@Y@Y?=q@Y?=q    ?=q    ?=q?=q        ?=q?=q        ?=q?=q@Y?=q    @YAA@
=@
=@Y@
=?=q?=q?=q@Y?=qA@G@
=@
=@
=@Y?=q@
=@G@Y@
=A@Y@G@
=?=q?=q?=q@
=@
=@
=@Y?=q@
=@
=@Y@Y@Y    @Y@
=?=q@
=?=q@G@
=?=q@Y@Y@
=@Y@Y?=q?=q?=q@
=?=q?=q?=q?=q@
=?=q@Y?=q@Y@
=@
=@Y?=q@Y@
=?=q?=q@Y@Y    ?=q?=q?=q    ?=q?=q?=q@Y@
=@Y@
=@Y@
=@
=@G@GAA:HA:HA:H@GAA:HA\  @GA\  A:HA\  AA\  A\  A:HA:HA:HA\  AAAA:HA:H@G@GAAA@
=@G@G@GA:HAAAAA@GA:HA:H@
=A@G@G@
=@
=@G?=q@Y@Y@G@
=@Y@Y@
=@G@
=@
=@Y@
=@
=A@
=@
=@
=@G@
=@
=@
=@Y@Y@Y@Y?=q?=q?=q    ?=q@Y        @
=@
=@G@
=@
=@GA@G@GA:HA:HA:HA:HA\  A:HAA\  AAAA}AAA\  AA:HAA:HAA:HA:HA\  A:HA\  A:H@GA:HA:HA:HA:HA:HA\  A:HA\  A\  A:HA}A}A}A:HA\  A\  A\  A\  AA:H@
=@G@
=?=q@G@
=@G@
=@Y@GAA\  A@G@
=@
=@G@
=@
=@Y@
=@
=A@
=?=qA@
=@
=@
=?=q@
=?=q@Y@
=@Y@Y?=q@Y@Y@Y        ?=q@Y@
=@G@YAA@G@G@GAA\  AA\  AA\  A:H@GA@GA\  A\  A:HA}A\  A\  A}A:HA:HAAA}A:HA\  A:HA:HA\  A\  A:HAA:HA:HA:HA:HAA@
=@G@
=@
=@G@G@GA@G@G@G@G@
=A@
=@G@G@
=@
=@Y@Y@Y@
=@Y@Y@Y@G@G@
=@YA@Y@Y@G@Y@
=@G@Y@
=@G@
=A?=q@
=@G@G@
=?=q@Y@Y@
=@Y@Y@
=@Y@
=@
=AA:HAA:HA:HA:HA}A\  AA}A:HAA\  AA}A}AA:HA\  A\  A}A\  A:HA\  AA\  A:HA\  A:HA}AA:HA:H@G@GAA\  @GAA:H@GA:HA:HA:HA@GA@G@GA@G@GA@G@GA:H@
=A:H@
=@GA@
=@
=A@
=@
=@
=@G@G@Y@G@G@Y@G@
=?=q    ?=q@
=@Y@
=@Y@
=@
=?=q@Y@
=@Y@Y?=q@Y@Y@
=@
=@G@GAA@GA\  A}A:HAA:HA:HA\  A:HA:HA}AAA=qAAAA\  AA}A}A}A\  A:HA:HA:HA}AA:HA:HAA:HAA:HA:HAAA:H@G@G@
=@GA@
=A:HA@
=@
=@G@GA@GAA@G@
=@G@G@
=@G@
=@
=@
=@
=@G@
=@
=@
=A@Y@G@Y@G@G@G@G@G@
=AA@GA:HAA:HA\  A:H@GA\  A:HA@GAAAA:HA\  AA:HAA:HA:HA:HA:HAAA:HA@GA\  @G@G@G@G@GA@GAA:H@
=@G@G@Y@
=A@
=?=qA@Y@
=@Y@Y@
=@
=@Y@
=@
=@
=@Y@Y@YA@
=@Y@G?=q@Y@Y@Y?=q        ?=q?=q@Y?=q?=q    @Y        ?=q@Y?=q@Y@Y@
=@Y@Y?=q?=q    @Y?=q@
=?=q    ?=q    ?=q@Y@
=?=q@Y    ?=q?=q?=q    ?=q@Y@Y@
=@
=@G@
=@Y@G@
=@G@G@Y@G@G@G@G@G@
=@Y@Y@
=@Y@
=@
=@
=@
=?=q@G@
=@Y@Y@
=@G@Y@Y@
=@
=?=q@Y?=q@Y    @
=@
=@
=@
=@Y?=q@Y@Y@Y@Y@Y?=q@Y?=q@Y@Y?=q@Y@Y?=q?=q@Y@Y?=q@Y?=q@Y@
=@Y?=q?=q@Y                ?=q?=q    @Y        @Y@Y    ?=q?=q?=q?=q?=q    @Y?=q@Y@Y@G@G@G@GAA:HA:HAA:HA:H@GA@G@GA@GA:HAA:HA@G@G@G@G@G@
=@G@G@
=@Y@GA@G@G@GA@GA@
=@
=@G@
=@G@G@
=@G@
=@G@G@G@G@
=@G@Y@G@G@
=@
=@Y?=q@Y?=q?=q@Y@
=?=q?=q?=q?=q@G?=q@Y@
=@
=@
=?=q@Y@Y@
=@Y@Y?=q?=q@Y@
=?=q@
=@Y@Y@
=@G@YA@GAAAA:H@
=A:HAA}AAA=qAAA}A:HA}A}A}A}AA\  A\  AA:HA\  AAAAAAAAA@Y@
=@
=@Y@
=@GA?=q@Y@Y@
=@GA@GA@G@G@GAA@G@G@GA@Y@G@G@G@G@
=@
=@
=@Y@
=@GA@
=A@G@
=@
=@G@Y@Y@G@G@G@
=@Y@
=?=q@Y@
=@Y@G@Y@Y@
=@G@
=@Y@GAAA\  A@
=@GA\  A\  A\  A@GAA\  A\  AA=qA=qAA=qA}AAAAA\)AAAAA@GA:HA=qA\  AAAAAAA=qAA}AA\  A}A}A\  A:HA}A\  A:HA\  A@G@GAAA@G@GAAA@G@
=@G@
=AAA@G@G@GA@G@
=A@G@
=@G@GAA@
=@
=@G@
=@Y@
=@
=@
=A@
=@GA:HA\  AAAA=qA=qAAAA\  A\  @G@
=AAAA\  A\  AAA:HA\  A:HA:HA:HA\  A\  AAAA}AA}A\  A}A\  A\  A}A:HA\  A}A}A\  A:HA:HAA\  A}A}A:HAA:HA:HA:HAAA:HAAAAA:HAA:HA@GA@
=@GA@G@GA:HAA@G@G@G@GA@G@G@G@Y?=q@
=@Y@
=@Y@GA@
=A:H@GAAA:HA}A:HAA\  A}A:HAAAAA}A\  A}AAA\  AA}AAAAA}AAAAA}A\  @
=A:HA:HA\  @
=A:HA@YAA:H@G@G@GAA@
=@Y@Y@
=@Y@
=@
=@Y@G@
=@G@G@G@
=@Y@YAA:HAAA@Y@Y@
=@G@
=?=q@G@Y@
=@
=@
=A@G@
=@G?=q@
=@
=@
=@
=@Y@
=@Y@Y@Y@Y@
=@Y@Y@
=@Y@GAA:HA:HAA}AA:HA:H@GA}AA\  A\  A}AA}A:H@GA@GA:H@G@GA:H@G@G@GA@GA:HAA@G@
=?=q@
=@
=@G@
=@G@G@G@G@G@
=@Y@G@
=@
=@G?=q?=q@
=?=q@Y?=q@
=@
=?=q@
=@Y@Y@Y@Y@
=@
=@
=@
=@Y@Y@
=@Y?=q@Y@Y@Y?=q@G?=q@Y?=q@
=@
=    ?=q@Y    @Y?=q?=q?=q?=q@Y@
=?=q@Y@G@
=@
=@Y@Y@
=@Y@Y@Y@Y@Y?=q?=q@Y@Y@Y@
=@GA@Y@Y@Y@Y@
=@Y@
=@
=@Y?=q?=q    @G@Y?=q?=q@Y@G@
=@Y@
=@Y?=q@
=    ?=q@Y@Y@
=@Y@Y@Y    @Y?=q@Y@
=?=q        ?=q    @
=?=q@Y?=q    ?=q@Y?=q@Y?=q@Y@Y?=q    ?=q@Y?=q    ?=q?=q    ?=q@
=?=q?=q    ?=q?=q@Y?=q@Y?=q@
=@
=@GA@G@
=@Y@
=AA@GA@G@
=@GA@GAA:H@GA@
=@G@
=@
=@
=@G@Y@
=@
=@G@Y@Y@Y@
=@Y@Y@Y?=q?=q    @
=@Y@Y    ?=q@Y@Y@Y@Y?=q@Y?=q@
=@Y?=q@Y    @Y?=q?=q@
=@
=?=q@
=@G@Y@Y@Y?=q@Y@Y@Y?=q@
=@
=@
=@Y@G@G@Y@
=?=q?=q@Y?=q@Y?=q@Y?=q?=q?=q        ?=q?=q@Y@Y?=q@Y@Y@G@G@
=@G@
=@G@
=A:H@
=@GA@
=@
=A@GA}@G@G@G@G@
=@
=@
=@
=A@G@G@G@
=@G@Y?=q@
=?=q@
=@
=@
=@Y@
=@Y@Y?=q?=q@Y?=q@G@Y@Y?=q@
=@Y@Y@Y@G?=q@Y?=q@Y@Y?=q?=q    @Y@
=@
=@Y?=q@
=?=q@
=    @G@Y@Y?=q?=q    ?=q?=q@Y@Y    @G    @Y@G@Y@
=?=q@Y?=q?=q@Y    @G@Y@
=@
=@GAAA:H@G@GAAAAA\  AA:HA:HA:HA:HA:HAA@GA@
=@
=@G@
=@G@YA@Y?=q?=q@
=@
=@
=@
=@
=@
=@Y@G@Y@
=@
=@
=@Y@
=?=q@Y?=q    ?=q@Y@Y@Y?=q?=q?=q@Y?=q?=q@YA@Y@
=@G@
=@Y@
=@
=@G@Y?=q@Y@Y@Y@
=    ?=q?=q?=q?=qA:H?=qA:HA:H@Y?=q    A    @Y@Y@
=?=q@Y@Y@G@
=@Y@Y@
=?=q?=q@
=@
=@Y?=q@
=@Y@G@
=?=q@G?=q@
=@
=@G@Y@
=?=q?=q?=q?=q    @Y?=q@Y@Y    @Y?=q@Y@Y?=q?=q    @G@Y?=q        @Y?=q@Y@Y@
=@Y?=q@Y?=q?=q@Y?=q?=q?=q    ?=q    @Y?=q@
=@
=@G@Y@Y    ?=q?=q?=q    @Y        ?=q@
=?=q?=q                @YA:H@Y?=q?=q?=q    ?=q?=q@Y@
=@Y@Y@Y?=q?=q?=q?=q@Y?=q?=q        @Y?=q    ?=q?=q@Y@Y@
=?=q    ?=q?=q    ?=q    ?=q?=q@Y    ?=q    @Y?=q            ?=q    ?=q?=q            ?=q    @Y                                                        @Y?=q?=q    ?=q    ?=q                    ?=q?=q@Y?=q    ?=q@
=?=q        @Y?=q        @Y        ?=q?=q    @G    @Y@Y@Y@Y@Y@Y@Y@
=@Y?=q@Y@Y@
=@
=@Y@Y@Y@Y@Y@
=    ?=q?=q?=q?=q@
=?=q?=q@Y@
=?=q    @
=?=q?=q?=q@Y@Y@Y?=q?=q?=q@Y?=q?=q@Y@Y            ?=q?=q    @Y@Y?=q?=q?=q    ?=q        @Y    @Y@
=@Y@Y@Y@Y?=q@Y@Y?=q        ?=q            @Y    A@Y@G@G?=q?=q@
=@Y@
=@Y@Y@Y@Y    ?=q@Y@Y?=q@Y@
=@
=@
=@G@
=@Y@
=@
=@
=@
=@Y@
=@
=@Y@
=@
=@
=@Y@Y?=q@Y@Y        @Y?=q    @Y@Y@Y?=q?=q@Y@
=@
=A@Y?=q@
=?=q@
=    @Y@Y?=q@Y?=q@Y@Y@
=@Y@Y?=q@Y?=q?=q@Y@Y@Y?=q@Y@Y@
=    ?=q@Y?=q?=q@Y?=q?=q?=q?=q        ?=q?=q@Y?=q@Y@
=?=q@Y@Y@Y@Y@G@
=A@Y@
=@
=@
=A\  @G@
=@G?=q@G@G@Y?=q@
=@
=@G@Y@Y@G@G@Y?=q?=q    ?=q@Y@Y    @Y@
=?=q?=q@Y@Y@
=@Y    ?=q@
=    ?=q?=q    @Y?=q@Y    ?=q?=q    @Y@Y@Y@Y?=q@Y    ?=q?=q@
=    ?=q        ?=q?=q    ?=q?=q@
=?=q?=q?=q?=q@Y?=q?=q@Y?=q@Y@Y@G@
=@Y@
=@Y@Y@
=@Y@
=@
=@
=?=q@G@
=@YA@GA@
=@G@
=@G@Y@Y@
=@Y@Y@G@G@G@
=@
=@
=@
=@Y@
=@
=@G@Y@Y?=q?=q@
=@Y@
=@Y@
=@G@Y@
=@
=@Y@G@
=@
=@
=@
=?=q?=q?=q@
=        @Y?=q@Y@
=@Y?=q@
=?=q?=q@Y?=q@Y?=q?=q@Y@
=@Y@Y@Y@Y?=q@
=?=q?=q?=q            @Y@Y?=q    ?=q?=q?=q?=q@Y@Y@Y@G    @G@
=@Y?=q@Y@
=?=q@Y@G?=q@
=@Y@
=@
=@
=@Y@
=@Y?=q@
=@
=@Y@Y@
=@
=@
=@GAA@GA\  A\  A:H@GA:H@YA\  A\  ?=qA@Y@Y@Y@
=@
=@Y@
=@Y@Y@Y?=q@Y?=q@
=@Y@
=@
=    @
=@
=@Y@
=@Y@Y@Y@G@Y@Y@
=@Y@
=?=qA@G@G@G@GA:H@G@Y@
=@Y@Y@Y@Y    @Y@Y@Y?=q?=q?=q@Y?=q@Y@Y@Y@Y@Y@
=@Y@
=@
=@G@G@G@GA:H@G@GA@GA@
=@GA@G@G@GAA@G@G@G@
=@GA@G@G@
=?=q@
=@Y@Y@
=@
=@
=@
=@G?=q@
=@Y@
=@Y@Y@Y@
=?=q@Y@Y@
=@
=@G@Y@
=@
=@Y@
=@Y@Y@Y@
=@Y@GA:H@G@
=@GAA:HA:H@GAA:H@
=AA@GA@G@
=A@G@
=AA:HA:HAA:HA:HAA:H@GA\  @GA:HAA:H@GA@G@G@
=A\  A:HAAA@GA:HAAA:HAA@G@G@
=@
=@G@G@G@G@GA@GA:HAA:H@GA\  @GA:HA:HA@GAAAAAA@GA@G    ?=q?=q@Y?=q?=q    @Y?=q@Y@Y@Y@Y?=q@Y@G@
=@
=@
=@Y@Y@
=@
=@Y@
=@Y?=q@Y@Y@Y@Y@Y@Y@Y@
=?=q@Y    ?=q?=q@Y@Y@Y?=q@Y@G@G    @Y@Y?=q@
=@
=@Y@G@G@
=?=q@Y@G@
=@
=@
=@Y@
=@Y@
=@
=@Y?=q@Y@
=@
=@Y@Y@
=@
=@G@Y@G@
=?=q?=q@Y@GA@Y@Y@
=@
=@G@
=@
=@G@Y@Y@G@
=@
=@
=@G@G@Y@
=@
=?=q@Y@
=@
=?=q?=q@Y@
=@Y@
=@
=    @Y@Y@Y?=q@
=@Y@Y?=q?=q@Y@Y?=q@Y@Y@Y        @Y@Y?=q    @Y@
=    @Y?=q?=q@
=@Y@G@
=@
=AAA\  A:HA:H@G@GAA:HAA:H@G@G@
=@G@
=@G@GA:HA@
=@
=@
=@
=@G@
=A@
=@
=@YA@Y@
=A@Y@Y@G@Y@Y@Y@Y?=q@Y?=q?=q?=q@Y@
=@G@Y@
=@
=@
=@Y    ?=q@
=@
=@Y@
=@Y@G@Y@
=@
=@G@
=@G@
=@GA@G@Y?=q@Y@
=@Y@
=?=q    @Y@Y@Y@
=    @Y@Y@
=@G@
=@
=@Y@Y@GA\  A\  A\  A\  A:HA}A:HA\  A\  AA=qAA}ALQ@GA@GA@G@G@
=@
=@G@
=@GAA@GAA@GAAAAA@GA@G@G@GA@GA@G@G@G@G@G@
=@
=@
=@G@
=A:HA:H@
=@G@GA:H@Y@Y@G@G@
=@
=@G@
=@G@Y@
=?=q@
=@Y?=q@
=@Y@Y@Y?=q@
=@
=@
=@
=AA\  @
=@
=@
=@
=A@GA:H@GAAA=qA\  A\  AA\  A}A:HA\  A}A}A:HA:HA\  A=qA=qA\  A:HAA\  A\  A:H@
=@GA@Y@
=@G@
=@
=@
=@
=@
=@
=@Y@G@Y@YA\  @
=@
=A@G@{@
=A@
=@G@G@G@GA@G@G@
=@
=@G@YA@G@G@
=AA:HA:H@G@GA:H@G?=q@Y?=q@
=A@Y@G@
=@G@G@
=@Y@
=@
=@
=@
=?=q?=q@
=@
=@Y@Y@GA@
=@G@GAA:HA\  A\  A:HA\  BA=qAAAAAAA=qAAAAAAA}AAA}A:HA:H@G@
=@G@
=@G@G@Y@G@
=@Y@G@
=@Y@
=?=q@
=@
=A:H@G@Y@
=@GA:H@GA:HAA:HA\  A:H@G@GA@
=A@G@G@G@
=A:HA@GA:HA}A\  A@
=A@GA\  A\  A@
=AA:HA@Y@
=@
=@Y@
=@
=@Y@GA@Y@G@YA@GA\  AA}A\  A}A\  A}A=qAAAA=qB"B"B"B"B{BB{BAB;zA\)B{B	B\)B"AA\)A\)AA=qA\)AA\  A:HA:H@G@GA:HA@GA:HAA@
=@
=A@GA:H@
=@G@Y@GA:H@
=@
=@Y@Y@G@
=?=q?=q@
=@Y?=q@Y@Y@Y@GA@
=@G@GA:H@G@GA:H@GA:H@
=A:HAA@
=@
=@
=A:HA\  A}A\  AA\  AAAA=qAA=qA\)AAAAzAAA=qAAAAA=qAAAAA\)AAA}@
=AAAA}A\  A}AA\  A\  A:HA:HA\  AA:HA\  AA:HAA\  A\  AA}AA}A\  A:HA:HAAAA\  AAA:HA}A}A}A\  A}A:HA\  A:HA:HA:HA@
=@Y@
=@G@GAA@Y@Y@Y@Y@
=@G@
=@Y@
=A\  @GAAA\  A\  A\  A}AAA=qAAAA=qA=qA=qAAAAAA=qAA\  AAA:HAA:HA}A:HAA=qA=qA\  A\  A}AAA\  A}A\  A:HA\  A}A@
=A:H@
=A}@GA@G@
=@
=A:HA:H@
=A@G@YAA:HAA@G@GAAA@
=A@
=@GAAAA:HAA\  AA@
=@GA:HAA:H@G@G@GA:H@GAA@
=?=q@
=@Y@Y@
=@Y@
=A:H@
=A\  AA:HA\  A\  A}A\  AAA}A}A:HA\  AAA:H@GA:HA}AA}AAAAAAAAA\  A\  A:HA}AAA\  A:HA\  A\  A:HA:HA:HA\  A\  AA:HAAA@G@Y@Y@G@G@GA\  A\  AA:HA@GA@GA\  A\  AA}A}A}AA@GA:H@
=@G@G@G@
=@
=?=q@Y@G@
=@
=@G@YA:HAAA}A}AAA\)AAzBA=qAB{B\)B*BL
=B{B*B	AzB{B\)B"B;zB*AzAB	A\)A=qA=qAAAA=qAA\)AAAB	B{B\)B	AzAzA\)AAAAzAAA}A}A}AA\  A\  A\  A\  A:HA}A\  A=qA\  A:HAAA:HA\  A:HA:HA:HAA:HAA}AA}A\  A\  A}AAAAA\  A}A:HA:HA:HAAA:HA@YA:H@
=AA@GA:HA\  A}AA=qAAA}AB	A\)AA=qAAAA=qA\  A=qA=qABB{B{AzAzA\)AAzAA\)A=qA}AAA=qAA}AA}A=qAB	AzAzAA=qA\)B{AAA\)A\)AA=qAAA@
=AA}AA}A\  AA\  A:HAA:HA:HA:HA:HAA}A\  A\  AA\  AA:HA:HA}A}@Y?=q?=q    @
=AAAAAzA=qA:HA}A\  A\  AAAAAAzBB{AAAA\)AAAA}AA\  A\  A:HA:HA:HA:HAA@GAA\  A\  A}A\  AA\  AA\  @GA:HA:H@GA}AA@GAAA\  A}AAA=qAA}A\  A=qA\  A\  A\  A\  A}AAAAAA}AA}AA:HA:HA\  AAAA:HAA:HA:HA\  A\  AA}AA\  A}A\  A}A}A:HA}AA}A\  @GA:HAAAA\  AAA}A:HA:HA:H@G@GA@G@G@
=@
=@GA@G@Y@
=AA:HAAAA:HAAA:H@
=A@
=A@G@
=@
=A}@GA:HA@
=@G@
=AA@G@
=@G@G@G@
=@Y?=q@
=@
=@
=@G@
=A@GA:H@
=@
=@
=@Y@
=@
=A@G@G@G?=q@Y?=q@Y?=q@Y@
=@Y@G?=q@YA:HA@G@Y@G@
=@G@YA\  AA:HA@GAA:HA:HA\  A}AAA}A\)A=qA\)AA\)AzA\)AzB{AzAB	BB{B	B	B	BAAzB	AA=qA\)AAAA\)AA=qAAAA:HAA\  A\  AAAA=qA}AA}AA}AAA=qA\)AA=qA\)A=qA:H@GA:HAA@GAA}A\  A\  A}A\  @GA@GAA}A:HA\  A:HAA:H@G@G@G@
=A@G@GA}@GA}A}AAAA\)A\)AA\)AzB*B;zB"B"B"B\)B"B\)B\)B{B*BL
=BCB"B{B\)B*B\)B\)BB"A\)B333B\)BA\)B	B	B	AAzB	BAzBBB	B{B\)B	B\)B*B"B"B*B"B	B\)B	AzAzAA=qAAA}A}AAA:HA}A=qAA=qA=qAA=qA=qA=qAAA:HA\  AAAAA}AAA}A\  AA}A}AA=qA}AA\)AAB{B"B;zBdHB\BupBGBRBupB  BTQBL
=BL
=B\)BBBAzAAzAA\)AAA=qAAzA\)B	AzA\)AA}AAAAAA\  AA}A\  A}AA}AA}A:H@G@GA\  A}A}AAAzAAA}A}A\  AA:HAAAAAA}A\  AAA:HA}A:H@GAA:HA:HAA:HA}A\  AAA\)A\)A\)AB	AzA\)AzB*B	BB333B;zBm(BL
=BCBL
=BupBupB}RB}RB}RBdHBdHB333B;zBL
=BTQBm(BL
=BL
=BCBCBCB"B;zB{B	B\)B	B\)A=qAA\)AAA=qAAA:HA:HA\  A@G@GAAA\  AAA=qAAAA@G@
=@
=@G@GA}AAAAA\)A\)AAA\)AAA\)AAA:HAAAAAAAA=qAA\  AAA=qAA=qAA=qAA}A=qAABAzB{BTQB;zB\BdHBL
=B*B333B"B*B\)B333BB	B{BB	AzAAAA=qAB	B	B{B"B\)B	B	B	BBB{B{AzAAzAAAA\)AzAA\)A\)AAA=qAA=qAAzAA=qBAA\)A=qAAA\)A\)A\)AA\)A\)AzAzA\)A\)AAAAzA=qA}AAAAAAAAA}AB	B"BB\BTQB\Bm(B}RBpBGB  B{B  B}RBTQB333B333B;zB\B\BdHB\B333B\)B\)BBBB{A\)A=qA\  A}AB\)A=qAAA\)AA\  A\  AAA:HA\  A\  A\  A\  A}A\  A:HA:HA}A}AAA}A\  A\  A}A}A}A}A}A\  A\  A\  AAA}A=qAA\  A}A}A}AAAA}AA=qAA}AA=qAAA}AAAzB	B	B{B{A\)BBB\)B\)B{B{B\)B	B\)B	B\)B{BAA\  A\  A:HAAA:HA:HA:HAA}A:HA\  A}A}A\  A:HA}AAAA}A}A}AA\  A\  A}A}AA}A}AA}AAAA}A}A:HA}A\  A:HA}AAA}A:HA\  A:HA}AA:HAAA\  AA\  A\  A\  A\  AA:HA}A\  A}AAAA\  A\  A}AAAAA=qAAAAA=qAA=qAAA\)BBB	B"AzBBAAzA\)AA=qA=qAA=qAA\  A:HA\  AA=qA\  AA=qA=qA\)AA\)A\)AzA=qA=qAAAzAA\)A\)AAAAAAA=qAA\  AA}A\  A}A\  A}AA:H@
=@GA:HA:H@G@
=@GA@G@G@G@GAA\  A:H@G?=q@G@GA:HAAAAA\  A:HA\  A:HA\  AA\  A\  A:HA}A\  A}A=qAA=qAAAzB"B"B\)B{B	BABAzAzAAAzBB{B\)B"AAAA=qA\)AA\)AAAAAAAAA}AA\  A\  A\  @GAA\  A=qAAA\  A}A}A}A=qA}A\  A}@GA:H@GAA:H@
=@G@Y@G@Y@GA:HA@GAAA\  AAAA:HA:HA:HA\  AAA:H@GAA:HA\  A\  AA:HA=qA=qAA}A\  A=qAA\)AB;zB"B*B;zB333B\)B{B	B*B333B333B"B	B	B*B\)B\)AzBB{B\)AAzA=qA}AAAAAAA:HA:HAA}A}AAAAA=qAA}A\  A\  A:HAA}A\  A:HAA\  A\  A\  A\  AA\  A:HA}A\  A\  @G@GAA:H@G@GAA:HA:HA:HAA:HA\  A\  A}A}A:HA=qA\  A}A@G@G@Y@
=A@GA@GA\  A\  AAA=qA\)A=qBB"B{B\)B\)B\)B*B{B	BAA\)AAA=qA:HAA\  A:HAA}AA}A:HA:HB	A=qAAAAAAAAAA}AAA}A}AAAA=qAAAA}A\  AA}A}A\  A:HA:HA\  AAA\  A@G@GAAA\  A}A\  A\  A:HAA\  A}AA}AAA\  @G@Y@G@GA@GA:HA:HAAA\  AAA=qAAA\)AA\)A\)A\)A\)ABAAzAAAzA\)BBBAzAAzB	AzB	BAA=qAAAAA}A}A\  AA\  @
=@
=AA:HAAA@GA:H@GA:H@
=@G@G@
=A@G@
=A@G@
=@Y@Y@
=@Y@Y@GA@G@
=A@GAA@G@G@
=A\  A@G@G@
=A@G@G@
=@G@G@
=@
=@
=@Y@G@G@
=A@
=AA:HAA}A\  AAA\)AAAA=qAAA\  A\  A:HA:HA:HAA:HA:HA:H@GA@G@
=@GAAA:HAAA:HA@
=@
=@G@G@G@GAAA:H@G@G@GAA@G@GA@
=A@GA@G@
=@G@G@
=@GAA@G@Y@G@
=@G@Y@
=@G@
=@
=@G@G@G@Y@
=@
=@
=@
=@
=@G@
=@
=@
=A:HAAAA@
=@
=@
=@GA:H@G@GAA@G@GA:HA@
=A@GA@GA@GA:HAAA\  AA:HAAAAAAA\  A:HAAAA\  A:HA:HAA@GAA:H@Y@
=@G@G@GA@G@G@
=@G@
=@GA@GA@G@
=@
=@G@
=@
=@
=@Y@
=@Y@Y@Y@Y@G@
=@
=@Y@
=@G@
=@
=@
=@Y?=q@Y?=q@
=@
=@Y@Y@
=A@G@G@G@G@G@G@GA\  A@GA@GA\  A:HA:HA:HA\  A:HA\  AA}A\  AAA:HA\  A:HA:HAA\  A:HA\  @G@GA:HA@
=@
=@GA:HA@GA@
=@G@G@Y@Y@GA@
=@Y@G@G@
=A@G@G@
=@
=@G@Y@G@Y@
=@Y@
=@Y@
=@Y@{@
=@
=@Y@G?=q@Y?=q@
=@Y?=q@Y@Y@
=@G@
=?=q@
=@
=@Y@Y@Y@Y@
=A@
=AAA:HAA@
=@GA:HA:HA:HA\  A\  A}A\  AAA:HA}A\  AA}AA@Y@
=@GA:HA}A\  A\  @GA\  A}A:HA\  A\  AA}A}AA:HA@GA:H@G@G@
=@G@
=A:H@
=@
=@
=@G@
=@Y@
=@
=@
=A@Y?=q@Y@
=@Y@Y    @
=?=q?=q@
=@Y?=q@
=@G@Y@
=@
=@G@
=@Y@
=@
=@Y?=q?=q?=q?=q@Y@Y@Y@Y        @Y@Y@Y?=q    @Y@Y@Y@Y    @
=@Y@
=@G@G@GAA}A:HA:HA:HA:HA\  AA:HA:HA:H@GA@GAA@GA@GA@GA@
=@Y@
=@G    ?=q@Y@Y?=q@
=@Y@
=@Y        @Y?=q@Y?=q    @Y@Y    ?=q?=q@Y@Y?=q@Y    ?=q    ?=q?=q?=q@Y?=q?=q@Y    @
=@G@
=@Y@
=?=q@Y?=q        ?=q?=q            @
=?=q?=q?=q    ?=q    ?=q?=q?=q@Y    ?=q?=q@Y@Y@Y@G@G@G@GA:HA}A\  A\  A:HA\  A:H@GA:HAAA@
=@
=@
=@
=@Y@G@G@
=?=q@Y@
=@
=@
=?=q    @Y@Y?=qA    ?=q?=q?=q@Y@G        @Y@Y@
=@Y@Y    @Y?=q?=q@Y@Y    @
=    @Y@Y?=q    ?=q    ?=q?=q@
=@Y@
=@
=@
=?=q@Y?=q?=q?=q?=q@!@Y@Y        ?=q?=q@Y?=q@Y@Y@Y?=q@
=?=q    ?=q@Y@
=@Y@G@
=@Y@
=@Y?=q@
=@
=@
=@
=@
=@Y@Y@
=?=q@Y?=q    @Y?=q?=q@
=@Y@Y@Y    @Y@Y@
=@
=@Y?=q@Y    @Y@Y?=q    @
=    ?=q?=q?=q@Y@Y@
=@Y?=q@
=@Y@Y?=q@Y@Y@Y?=q    @Y?=q@Y?=q    @Y?=q?=q@Y@Y@
=A@G@
=@Y@Y?=q@Y@Y?=q    ?=q        ?=q@
=                ?=q                                ?=q?=q@Y?=q@
=?=q@
=?=q?=q?=q    @Y?=q@Y?=q    @
=    @
=?=q@Y?=q?=q?=q?=q@Y?=q    ?=q?=q    ?=q    ?=q    ?=q@Y?=q        ?=q?=q            @Y?=q    ?=q?=q    @Y    @Y?=q?=q    ?=q    ?=q?=q            ?=q        @Y    @
=?=q    ?=q?=q?=q@Y@Y    ?=q@Y            ?=q?=q?=q@Y@Y?=q    @Y@
=@
=AA@G@
=@
=@
=@Y@G@Y@G@
=A@G@G@G@
=@
=@
=@
=@
=@Y@
=@G@Y@Y@
=@Y@Y?=q@Y    @Y@Y@
=@G@
=AAA}A}A\  AA:HA\  AAA=qA=qAzA\)A\)A=qAzB	B	BBB\)B{BB	B	BBBAAA\)AA\)AAA=qAA=qAA=qA=qAA\)A=qA=qAAAAAAA}A}A\  AA}A\  A}AA}A\  A\  A:HA\  A:HA\  A:HA}A\  A}A}A}A}A}A}AAA:HAA\  A\  A}A\  A:HA:HA:HA:HA:HA:HA}A:HA:HAA\  A:HA:HAAAA:HA:HA@
=@
=@Y@
=@Y@Y@Y@Y@G@Y@
=@
=@
=@
=@
=@G@G@G@G@G@Y?=q@
=@Y?=q@
=@Y@Y@
=@G@
=@
=@
=@G@Y@
=@
=?=q@Y    @Y    @Y@
=?=q@Y@G@Y@G@YA?=q@Y        @
=?=q@Y@
=@Y@Y        @Y        ?=q    ?=q        ?=q?=q?=q?=q@
=?=q?=q?=q?=q?=q@Y@Y    @Y?=q?=q@
=@
=@Y?=q?=q    @Y?=q?=q            @Y        ?=q@Y?=q?=q?=q@Y@Y?=q@Y@Y@Y@Y?=q@
=@Y@
=@Y@
=?=q?=q@
=A@
=@
=@
=@GA@GA@
=@
=AA\  AA}?=q@Y@
=@
=@GA@Y@Y@
=@G@
=@Y?=q@Y@
=@GA:HA@G@
=@
=@G@GAA@GA@G@
=@G@G@
=@
=@G@G@G@G@
=@G@
=@G@GA@G@G@GA@G@G@
=@GAA@G@
=A?=q?=q@
=@
=?=q@
=@
=@
=?=q@
=@G?=q@Y@Y@Y@
=@Y@Y@Y@Y@G@
=@
=@
=@
=A@
=@
=@
=@G@Y@
=@
=@Y?=q@Y@YB?=q@Y@Y@Y@
=@
=@
=@Y@G@GAA:HA:H@G@G@GAAA:HAA\  AA\  A:HAA@GA:H@GA}@
=A@G@Y@G@
=@G@
=@Y@Y@Y@Y@Y@
=@
=A:H@Y@
=@
=@Y@
=@Y@
=@G@Y@
=@
=@Y@Y@Y@
=@G?=q@
=@Y@G@
=@G@
=?=q@G@
=@Y@
=@Y@
=@Y@Y@Y@G@Y@G@
=A@G@GA@
=@G@G@GA@
=?=q@
=@
=?=q@Y@Y@Y@
=@Y@Y@
=@G@G@GA:HA\  A}AAAAA=qA\  AA\  A:HAA:HA\  A:HA:HAA\  AA\  AAA}A\  A}AA}A\  A\  A}A:HA\  AA:HAA:HAAA:HAA@GAAA@G@
=@GA@G@G@G@GA@GAA@
=?=q@
=@
=@
=@Y?=q?=q?=q@G@G@G@
=@G@G@Y@Y@G@
=@GA}AA\  A}A\  A:HAA:HA:H@G@
=@Y@YA:HA@G@GA@GA:HA}A\  A}AA=qAAAAAB	AzAA:HAAAA\)A@Y?=q    @YA\  @
=AA}@G@
=@
=AA=qAAA}@G@
=A:HA}@Y@
=@
=@
=@G@G@
=@G@GAAAA@
=A:HA@GA:HA}A:HA:HA:HA:H@
=AAAA\  AA\  A\  AAA:H@GA:HAA\  AA:HAA:H@GA\  A\  A}A@G@G@G@GA}A}AAAA}AA=qA=qA\)AAzAzB	B\)B"B	AzAzA\)AABABAzAA=qA\)AA\)B	AA:HAAAAA\  AA}A}A\  A}AA=qAA=qAAAAAA}AA}A:HA\  A:HA:HA:HA:HA:H@
=AAA@GAA\  A:HA\  A:HA}AA}A:HA\  @
=AA:HA:HAA\  A\  AA:HAAAA:HA\  A\  A:HA:HA}A}A\  A}A=qA\)AA\)A\)A=qAA\)AA=qA\)A=qA=qAA=qA=qAA=qA}@
=@G@
=A\)A:HA=qAA@Y@Y?=q@Y@Y@Y@Y@G@G@G@
=@GA@G@G@G@
=@
=@
=A\  A=qAAA=qAAAA\  AA@
=@Y@GA@GAAA@
=@@
=@
=@Y@G@
=@Y@G@YAA@G@Y@Y@
=@
=@G@
=A@G@G@G@
=@Y@Y@Y@
=A:H@GAA:HA\  A:HA:HA\  A}A}AA}AAA\)A\)BBA\)B{BB	BB	B{B	AAAzBB{ABTQB\B{B\)B*A\)AA\)A:HA@
=A@
=A\  A\  ABB{B\)AzB	B\)B	AzAAAA\  AA=qAzA=qAAAA\)A=qA:HA\  @
=AA:HA\  A\  AA:HA:HAA}AA}A\  A\  A=qA\)AA\)A}A}A\  AAAAA\)A=qA}A=qAAzAzA\)B\)B{B"B\)B;zB333BCB;zB\)A\)AAA}A:HAA:H@G@YA\)A:HA\  BAB	A=qA\)A=qAA\  AAzABA\)A=qA}@
=A:HAA\  A:HAA:HA}A\  AA@GAA:H@
=?=q@
=A\  @G@G@G@
=@G@
=@
=A@
=@G@Y@GA:HA\  A\  A:HAAA@GA@
=@
=@GA@
=@G@
=A:HA@GA:HA:HAAA\  AAA}AA\  A\  AAA=qAAA=qA=qA\)BAzB\)B"B\)B*B"B	BAzB{AzAA\)AA\)A\)A\)A=qA:HA:HAAA}A:HAA\)B	B{AA}A\  A:HAzAAA}AA}A\  AAAAzA\  AAA:HA:HA:HA:HA=qAA}A\  @GAA:HA}A\  A}AAA}A\  A\  AAAA@GAA:HA:HA\  A@G@GA@GAA:HAA:HA}A\  AAAA\)AAB	B*B333BL
=B\BdHBTQBdHBdHBdHBL
=BL
=BL
=BTQBCAABB	B\)B{B\)B\)B{B*B;zB	AA\)A\)A\)AzA\)AB\)BCA=qAAAA\)AA\)A=qA=qAA=qAAAA=qA=qA=qAA=qAA:HA}A:HAA\  A}A:HAA}A}A\  AAA}AAA\  A}AA:HA:HA}AA=qA=qAA\)AAAB{BB{AzB	B"AzB{BL
=BdHB  BpBGB{BGBGBGBdHBCB\BCB;zBL
=B333BL
=B\)B{BBAB	BAzB"B*B;zBCBCBCB*AzA\)AAAAA=qA=qA\  A}A}A}A\  A:HA:HA\  A\  A:HA=qA}AA}AA}A:HA:HA\  A:HA:HAAAA@GA:HAA:H@
=AAA\  A\  AA\  A\  A:HA:HA:HA:HA\  A\  A:HA}AAA=qAA\)AAzA\)B{BAzB{B*B;zBL
=B;zB\Bm(B}RBupBdHB\BCBm(BdHBL
=B"B333B\)B{B"B*B*B\)B{B\)B{B\)B\)B	AzA\)BAA\)A}AABB	AzABB	AAA=qB	AzAzB	AzBBBB	AzB	B{AzAA=qAA=qA=qA\)AA}A}AAA:HA}A}A}A}A}AA}AAAA\)AABB	AB\)BB	A\)B{B*AzB*B*BTQBL
=BL
=BCBL
=BL
=B\BL
=BdHB"AzAAA\)AAA=qB;zB	AzB\)AAB	AA}AAA\  A}A:HA:HAAA:HAA:HA:HAA:HA:HAAA:HA\  A:HA\  AA\  A\  A:HAA\  AA@
=AA@
=@G@GA@G@
=@G@GAA@GAA@
=@G@G    @Y?=q@G@G@Y@Y@
=@Y@
=@
=AA}A:HAA:HAAA}A=qAA}A}A\)AAA=qAA:HAA}A\  ABAB{AzBA=qA@GA@
=A@GA@G@
=@G@Y@
=@Y@Y@Y@G@Y?=q@Y?=q@
=@Y@
=@GA:HA:HA:H@G@
=?=q?=q@Y@
=@YA@
=@G@
=@
=@Y@G?=q?=qA@Y@
=@Y?=q@
=@Y@G@Y@Y?=q@Y@YA}AA:H@Y@G@GA:HA}AAAA\)AB	A\)AzAzBB	B*B*B	B	AzB"B;zA\)A=qA:HA}A\)AA@Y?=q@G@G@GA\  A@GAAA=qAAzAzAA\)AA=qA=qA}AAA=qAA\  A:HA\  AA:HA}A:HA\  A\  A\  A:HAA\  AA\  A\  A}A:HA\  A\  A:HAA\  A:H@G@
=@
=@
=@
=@
=@GA@
=A:HAA:HAA:H@
=@GAAA@G@
=A:HA:HA}A}AA:H@GA}AA\  A\  A}A}AA\  AA}AA:HA:HA}AAAAA}A}AA\  AAAA\  @GA:H@GAAA:HA\  AAAA\  A:HA:HA:HAA}A@G@G@GA@G@
=AA:H@G@Y@Y@
=@Y?=q@
=@Y@Y@
=@
=AA:HA\  A:HA:HA}A}A\  A=qAA:HAAA=qA\)A=qAA\)AA=qA\)AAA=qAA\)A=qA\)A=qAA\)A=qA\  AA}A}A:HA}A}A=qBAAAzA\)A=qA=qABA=qA\)B\)BB\)B	B\)BpAzA=qAA}A\  A\  A}AA\)AA\)AA=qA=qAAzAzAzAA=qAAA\  A\  A:HA:HA\  AAAA}A\  AAA:HA\  A:HA:HA\  A:HA}A:HAAA\  A\  AAAAAAA}AAAA\  A}A}AA=qAAAAAA}A}AB	AzAA}A:H@G@GAA:HA=qAAB	AA\  A}A=qA\)B	B\)AzB333B*B333BupB*B\AA\  @GAA:H@GAA@GA=qA:HAA\  A:HAA}A=qB{A:H@
=@G@G@GAAA@Y@Y@Y?=q@Y@
=@
=AAA=qAA@Y@GAA\  AAA:HAAA:H@GA:HAAAAAA}AA=qAAA=qAA\)A=qA\)A}A:HAAA\  AAAA=qA}A=qA\)AAB"B"AAAAAB	BB{AzAAAA:H@
=AA:HA@G@G@G@Y@YA\  A\  A}A@G@
=@GAAAAAAAAAA@GA:HA}A:HA:HAAA:HA:HA:H@G@G@G@
=@YA\  @G@YAAA:HA\  A:H@GAA:HAA\  AA\  AAA@G@
=A:HA}AA:HA\  A\  @G@
=A:H@G@G@G@GA@GA@
=AAAAA\  @GA:HA:HAAA\)B\)B	Bm(B#B333B}RBupBm(B*A\)A=qBAzA=qA}AB{A\)A=qAA}A:HAA=qAAA:HA@GA:HA\  AA}AAAA=qA=qA=qAA}A:HAA}@GAA\  A}A}AAA=qA\  A:HA}A}@GA:H@G@GAA\  @GAA:HA\  A\  A:HA\  A:HA:HA:H@
=A:H@GA\  AA}A:HAA@YAAAA}A}AAA=qAAAA\)AAAAB\)B*B\)B\)B{BB\)B"B{B333B\)AzB"AzABAA}A}A:HA}AAA\  AA\  @G@G@
=AA@
=@
=A@G@
=@G@GAA\  A:HAAA=qA\  @
=@YA\  A\  A}A\  A}A}A\  A@GAA\  @GA@G@GA@
=@
=@G@
=@GAA\  AA:HA:HA\  A\  AA}AAAA:HAA}AA=qA=qA=qAAA=qAA}A\)BB"B\)BB{B;zB	AA=qAAA}A=qA\  A\  AA:HA\)A=qA}@GA:HAA:H@
=A:H@
=@G@GA:H@G@GA:H@G@G@G@G@GA:HAA@GA:HAA:H@
=@G@G@Y@Y@
=@Y@
=@G@G@G@
=@G@Y@
=A@G@
=@Y@G@G@G@
=@
=@
=@
=@
=?=q@GAAAA:HA:H@GA:H@GA\  A\  A:HAA}AA=qAAAAAB*AzB{B	AzB"B;zB	B\)B	B"AzA=qAA\)AAzAA=qAA\)ABB	AA\)AzAA=qA=qB	AzA\)@
=A}A}A\  AAA\  AA=qAzAAzAA:HAAA:HA:HA:HA}AA:HA\  AA}A\  AA\  @GA:HA:HA:HAAA=qA:H@GA:HAAAAA\  AA:HAAAzAA}A:HAA@
=A@G@YA:HA\  A}AB\)AzBB	B{B*BCBCB\B	BL
=BupB}RB}RB\B333B"BL
=B\)B*AA:HA\  A@GA:HAAAAAAAA=qA=q@YA\  A}AAA}A\  A:HAA}A:HA:HA}A=qA\)A}A}A:HAA@GA:HA:H@G@GA\  A:HAA}AA:HA}A:HA\  A\  B\A\  A}A:HA:HA:HA\  A}@GA\  @G@G@GAA:HB{A\  AA:HA:H@GAA@
=A@G@G@
=A@GAAA}@GA:H@
=A:H@GA:HAAAA}A\  A:HA:HAA@G@GA:H@
=A:HAAA:HA\  CA\)A\  A\  @GAA:HA=qAAAA\)B"BBB*B	B;zB#B#B
B3BpBkB}RBRB  B}RBGBm(BGBGBpB#B}RB#BupBRB  B  Bm(BGBGB\B)BGBTQBGBL
=B{B333B\)B{AAAzB{AA\)A\)AA}AA}AA}AAAAAA\  AAAAA\)AzA:HAA\)A=qA@GAAABA\)A\)A=qAAA=qAA=qA}A\)AA=qAzAA}AAAAAzBCB\B	B\)B  B#BpB)B#B)BGBRB  BRB)B{B#B#B  BkB#B)BGB  B
B  B
B\B#B{B#BGB#B\)B"B{B333AzA:HA\  A:HA:HAA\  A:HA:H@GA:H@YAAB{B333B333BCBupBdHB\BL
=BdHB\BdHB\BL
=B\)B\)A=qA=qAA\)AAB	B	B{AzAB	AzABA\)B{AAzB{B	B\)A\)AA\)A\)AA\)AAAA=qAAAzAAAAA=qB{B{BB\)B"B{B{B	B"B	B*B333BL
=BCBdHBdHBL
=B	BB\)BB\)B*B{B{AzAA=qAAAA\)A\)A\)B"AAAAzAAAAAAA=qA=qAA}A}AAB{BAA}AA\  AAAA\)A\  A\  A\  A}A\)AzA=qA}A:HAA}@GAAAAA:HA:HAA:HA\  A}AA\  A\  AA\  AAAA\  A:H@GAA:H@G@G@GAA@
=@Y@G@GAA@Y@GA@
=@Y@
=A@G?=q@
=@GA@Y@G@G@
=@G@Y@
=?=q@
=@
=A:HAA:HA:HA\  @YAAAA}AAA@GAAAA}A@Y@Y?=q@Y@Y?=q?=q    @GA}Az@
=?=q@G@
=@Y?=qA:HA:HA\  @G@GAA\  AA:HAAA:HA:HA:HACF  A\)A}BABBAB{B333B;zBAB	AA=qA\  @GA\  A@
=@
=@
=@G@Y@
=?=q?=q@
=@Y@
=@
=@Y    @Y    ?=q@Y@Y    @
=@
=    ?=q?=q@Y@
=        ?=q?=q@Y@Y?=q@Y?=q?=q@Y@
=@Y?=q@
=@
=@Y@YA@GA:HAA:H@GA@G@
=AAA\  AA@
=@
=A@
=AA@
=A@Y@
=@Y@Y?=q@Y?=q@Y?=q@Y@
=A@Y@GA@Y@Y@
=@GA:H@
=A}A@GA:HA:H@G@Y?=q@Y@G@G@Y@
=@
=@Y@Y    @
=?=q?=q@Y?=q@Y?=q@
=@G?=q@Y@Y@
=@
=    @Y@
=@G@G@Y@
=?=q        @Y@G@Y?=q@Y?=q@
=@GAA\  @
=@Y@GA}A@G@
=@Y@Y@G@
=?=q@
=?=q?=q    ?=q@Y    ?=q    @Y@
=@Y@Y?=q@
=@Y@
=@Y@Y?=q@Y?=q?=q@Y@
=@
=@
=?=q@Y@
=@Y@Y@G@
=@
=@Y@YB"@Y@GA:H@G@G@GA\)@G@G@Y@
=@
=@
=@
=@
=@
=@Y@
=@Y@
=@
=?=q@Y?=q@Y@Y@
=@Y?=q?=q?=q?=q@Y@
=@
=    ?=q@Y@
=@Y@Y?=q?=q@Y@Y@Y@Y@
=A@G@
=@
=@G@G@
=@Y?=q@
=    @Y?=q@Y@Y?=q@
=@Y@G@
=?=q@
=@
=@Y@G@Y@Y@Y@Y@Y?=q@Y@
=@
=@Y@Y@
=@
=A@GA@
=@GA@
=@G@G@G@Y@G@G@G@
=@
=@
=@Y@Y@
=@G@G@
=@
=?=q@Y@
=?=q@G@Y?=q@Y?=q?=q?=q?=q?=q@Y@Y@G@Y?=q@Y@
=@
=@Y@G@G@G@
=?=q@
=A@GA@
=@GA@G@GA@
=@Y@
=@Y@Y@Y@Y@Y@
=@Y@Y@Y    ?=q?=q?=q    @Y?=q?=q@Y?=q@Y@Y@Y@Y@Y?=q?=q@YAA@
=@GAA\  A}A}A}A=qA}AAAA\)AAAA:HA\  A}AA\  A\  A'
@G?=q@G@Y@
=@
=@Y@
=@YA@
=@G@G@Y@Y@
=@G@GA:HA:HA=q@G@G@G@G@GAAAA:HAA\  A\  @G@GAAA\  A:HAA\  A\  @GA:HAA:HA\  AA:HA:HA:H@G@G@G@GA@YAAA\  A:HAAA\  A:HAA}A\  A\  A\  A}A}A=qAA=qAAAzB\)B;zB\)B{BB\)B"Bm(BL
=B333B*B333B;zB;zBCB333BdHBL
=BCB;zB;zBL
=BL
=B\B333B"B"BCB;zA\)A}B*BB333B{B;zB	B{ABB{B"B"B*B\)B\)B{B{AAAA\)A\)AzAzAzAABAA}AAAAAA\)AAAAAA=qAA\)AAABB{B\)B"B{B{BBB\)BCB*B"B	B*B	B;zB\BdHB}RBGBupB#BpB}RBm(B}RB"B"B*B333BTQB333BTQB"BB*B333B\)B"B"B{B\)B333A\)AAA=qAA}AA}AA}AAAA}AA=qAAzAzBAzB\)AA\)B\)AAABA\)AAzBAAA\)A\)ABAA=qBA\)AA\)AA\  AAAA=qA}AA:HA}A}A=qB{B\)B\)B*B;zB\B\B;zB\BCBdHB\BGBGB  BupB  BdHB;zBCBCB\)B	B"B{A\)AAA\  A}A}A\  A:HA\  A\  A}AA\  AA}A\  A\  A:HAAAA@G@
=A@
=@
=A@
=A:HAA:HAAAAA=qAAAAA@GA\  AAA:HA@GA\  AAAA:HA:HA\  A\  AA}AA\  A}A@
=@Y@
=A@
=@Y@G?=q@Y@
=@Y@Y@Y@Y?=qA@
=A:HA\  A}A\  A:HA\  @GA@G@G@GA@G@
=@GA@G@G@G@G@G@
=@GA@G@YA:HA:HA:HAA@G@
=@YA@G@GA@
=@G@
=@
=@G@
=@
=@
=@
=@Y@G@
=@Y@
=@
=@Y@Y?=q@Y@Y@Y?=q@
=@Y?=q@
=?=q@Y?=q    ?=q@
=A@Y@
=@
=@G@G@
=@GA@G@Y@
=@Y@
=@G@Y@
=@Y@Y@
=@G@Y@G@GAAAA:HA:HAA\  A\  A:HA}A=qA\)AAA\)B\)AAA=qAA\  A\  A\  A\  A}A\  AA\  A}A:HA\  AA:H@GA:HA:H@
=A\  @GAAA@G@
=@G@Y@
=@Y@
=@Y@Y?=q@G@
=@
=@
=A@G@G@G@G@G@G@GA?=q@G@
=@
=@
=@G@
=AAA:HA:HA:H@GA\  A@GA:HAA:HA@GAAA\  AA:HA}A\)AA}AA\  A\  A\  AA\  A=qAzB	B\)B"B{B{B\)B\)B{BAzAzAAAA\  AAAAA=qAAA=qAA\  A:HAA:HAAA@
=@Y@
=@Y@G@
=@
=@Y@
=@
=@GA\  @GA@G@YA:H@G@
=@
=?=q@Y@G@G@G@G@Y@G@
=@
=@
=@Y@
=@
=@
=@
=@Y@
=?=qAA:HA@
=@G@
=@Y@
=@
=@Y@
=@YA@G@
=A:H@GA\  A:HA:H@
=A@GAAzA\)A\  @G@
=BA\  A}A}A\  A\  A\  A:H@GA@
=@
=@
=?=q@YA:H@G@G@G@GA@
=A@
=@G@
=@
=@
=@
=@Y@Y@
=?=q?=q?=q?=q?=q@Y@Y@Y@Y@
=@Y@
=@Y@Y@Y    ?=q?=q    @GA@Y@
=?=q?=q@
=@G@
=@
=@G@
=A@G@
=AAA:H@
=@G@
=@
=A@
=@
=@GA@Y@
=@Y@G@G@G@
=@G@GA:HA@GA:HA}A}AAA:HAAA@G@
=A@Y@GA:HA@G@GA:HA:HAA@G@G@
=@GA@G@G@
=@GAAAA@
=@G@G@Y@
=A@
=@G@
=@G@GA@G@G@
=A@
=@
=@Y@G@
=@G@Y@G@
=@Y@Y?=q@G?=q?=q?=q?=q@Y?=q@Y?=q@
=@Y@Y?=q@G@
=@
=@
=@G@
=@
=@
=@Y@G@Y@
=@Y@
=@Y@
=@GAA}AA:HA\  AA}A\  A}A\  AAAA=qAAAA}AA\  A\  A}A\  AAA:HA\  A\  A:HAAA:HA}A:HAAA@G@G@G@
=@
=A@G@
=@
=@Y@Y@Y@Y@Y@Y@
=@
=@Y@Y@
=@Y@
=A:H    @
=@G@
=AA:HA:HA:HA:HA\  A@G@GA:H@GA:HA:H@
=@Y@G@G@
=@Y@
=@G@GA@GAAA:H@GA\  A\  AAA=qA\)AA\)AB"B\)B*B*B"B"B*B*B"B333AA\)BA\)AA}A:HA:H@
=A:HAA@G@G@GAA@G@
=@
=@
=@
=@G@
=@
=@
=@
=?=q@Y@
=@
=?=q?=q@Y@Y@Y    @Y?=q@Y?=q        ?=q?=q?=q    ?=q?=q?=q?=q?=q?=q@
=?=q@Y?=q@Y@Y@Y@Y    @Y@Y    ?=q?=q?=q    ?=q@Y@Y@Y@G@YA:HA=qAAA\)AA\)AzB{BL
=B	B	A\)BAzA=qAA=qA\)AzA=qA\)A=qAA\)A=qA\  A@GA:HAA\  A:HA@GA@G@
=A@Y@Y@G@
=@G@Y@
=@G@
=@
=@Y@
=A@
=@Y@
=@
=A@
=@GA@Y@Y@Y@
=@
=@Y@G@
=@
=@
=@Y?=q@
=?=q?=q@
=?=q@Y@Y@
=@G@G@
=@GA:H@G@GA:HA:HA\  @
=@G@G@
=@
=@
=@
=@Y@Y@
=@Y@Y@
=@
=@
=A@G@G@Y@
=@
=@
=@
=@Y@
=@
=@
=@Y@Y?=q@
=?=q@
=@Y@
=@
=@
=@G@
=A@YA:H@Y@G@G@G@G@G@G@
=@
=A@Y@Y@G@Y?=q@G@Y@Y@
=@Y@Y@
=?=q@Y@G    @
=@Y@Y?=q?=q@Y@G?=q?=q@Y@Y@
=@Y@Y?=q?=q@Y@Y    ?=q?=q@Y?=q@Y?=q        @Y        @Y?=q        @Y?=q@Y@
=?=q@G@
=@G@G@GA@G@GAA@G@
=@
=@
=@G@G?=q@
=@
=A@
=@
=@G@G@Y@YA@G@G@G@
=@
=A@
=A@Y@Y?=q@Y?=q@
=@
=@
=@
=@
=@
=@
=@G@
=?=q@
=@Y@Y@Y@Y@
=@Y@Y@
=@Y@
=@
=@Y@
=@
=@Y@
=@Y@
=@Y@Y@Y@Y    @Y@
=@
=@G@G@
=@
=@Y@Y?=q@
=?=q@Y?=q@Y@
=@
=@
=@
=@Y@Y@G@
=AAA\  A}A\)A=qAAzAzAzBBB	AzAzAAAAA=qAA\  AA}A\  A\  AA:HA}AA:H@G@G@G@
=@
=@
=@G@
=@G@G@YA@
=A:HAAA@GAA@G@G@G@G?=q@
=A@Y?=q@G@
=@Y@Y@Y@
=@Y?=q@Y@
=@Y@Y    @Y?=q@Y        @Y    ?=q?=q@Y?=q@Y@
=@
=@GA@GAA\  AA=qA\)B	B*B333BTQBm(B\Bm(B  BGB  B  B  B#BupBm(B\B;zBL
=BL
=B333B*B333BCB\B\BdHB\B;zBL
=B\)B*B333B"B	B\)BB	B\)A\)A\)A=qAAAAAA\  A:HAA:H@GAAA@G@G@Y@G@
=@G@GA\  A@GAA=qA\  AAzAA=qA}A\  A=qAA}A}AA}AAAAAzAAAAA\)ABBBB*BCBCB;zAB"B*B	AzAA:HA=qAAAA=qAAAAzBAAA\)AA=qA\)BB	AzAAA\  AA}A}A:HAAAA}A}A}A\  A:HAA\  A}A}AA:HA:HA\  A}A\  A}A\  AAzBAzB"BL
=BCB;zB*AzA\)B"B\)AB\)AzA\)AzB"A\)AAA:HA}AA@GAAA\  @G@GA}A\  A:HA:HA:H@GA\  AA=qAAAAzAAA=qB*B"B*B*B\)A@
=A:HA:HA:HA\  A:H@G@GA\  A:H@G@G@
=@YAA:HAA}A}A:HA\  A\  A\  A\  A:HA\  A}A\  AAAAA\  A:HAA:HA:HA@GA@
=@G@
=A@
=@Y@
=A@
=@
=@
=@Y@Y?=q@
=@Y?=q?=q?=q@Y?=q?=q?=q    @Y?=q@Y@Y@Y@
=@G@Y?=q?=qA\)?=q?=q@
=@Y@G@
=@
=@G@
=@
=@G@GA@G@
=@
=@Y@Y@Y?=q@
=?=qAAAA\  A@GA:HA@
=@
=@Y@
=AA:H@GA:HA\  AA\  A\  A\  A}A}A\  A\  A\  AAAAAA=qAAA=qAA}A}AA}A}AAA}A:HA:HA:HA:HAA:H@
=@G@G@GAA:H@
=@
=@Y@Y@
=@
=@Y?=q?=q@Y@
=@Y@
=@
=@Y@Y@Y@Y@
=@G@GA\  A@
=@Y@
=A@G@
=?=q?=q@G@
=@
=@Y    @Y@Y@
=@
=@
=@
=@Y@Y@Y@
=@Y@G@
=@GA:HA:HA:HA}A}AA}A=qA\)A\)AAzAB	AA\)AA}AA\)AAA=qA\  A:HA=qA=qAAA}A\  A}AA}A}A\  A}A}A\  A\  AA:HA:HA}A@GAA:HA:HAAA:HAAA\  A:HAAAA}A\  A:H@GAAA\  A:HAAA\  A\  A\  AA:HA}A:HA\  @GAAA:HA}A:HA\  @GA\  @
=A:HA:H@GA\  AA:HAAA\  A:HA:HAAAA=qAzB{BAB"B*BL
=BCB;zB333B333B*B"B"B"B\)B	ABB	BAAA\)A\)AAA=qA=qAA=qA=qA=qA\)AAAA=qAA=qA\)A\)A=qA\  A}AAA:HA}A:HA:HA\  A:HA}@G@GAA}A:HA\  AA\  A\  AA:HA}AAAA:HA:HAAA:HAA:H@GA\  A@
=AAAA:HAA\  A:HA\  AA\  A\  A\  AA:HA:HAA}@GA}AA\  A}A}A:HA}AAAAAAA}AA\  A\  AA\  A:HA\  AAA\  A:HA:HA:HA\  A\  AA:HA\  AA:HAA:HA@G@G@G@
=AAAA:H@
=@
=@
=@Y@G@G@G@G@Y?=q@
=@
=@Y@G@G@GAAAA\  A\  A@
=AA:HA\  A\  A:HA\  A}AA}A:HA:HA\  A}A@GA@GA:H@GAAA@G@
=@G@Y@GAA=qAB	A\)A\)A\)AzA\)A=qAA=qAA}AA\  A:HA:HA@G@Y?=q@Y@G?=q@G@Y?=q@Y@Y@
=@G@G@GA:H@Y@Y@
=@
=@Y@
=@
=@G@GA@
=@G@
=@
=@GA@G@Y@
=@G@
=@GA:H@
=@G@
=@GA=q@G@YA@
=AA\  AAA@Y@GA:H@
=@
=@
=@G@
=@G@
=@
=?=q@G@
=@
=A@G@
=@GA:HA:HAA:HA}AAA=qAA\  A}AA}A}AAA\  A}A}A}AA}A\  A\  AAAA}A}A\  A\  A:HA:HAAAA@
=@G@
=?=q@Y?=q?=q@Y?=q@Y@
=?=q@Y@YAA@G@
=A:H@
=AAA}AAA:HA:H@GA:HAA\  AA:HA@G@GA:HA:HA:H@
=AA\  @
=A@G@
=@
=@GA@GA@G@G@G@G@
=AAA}AA=qAA\)AzAA=qA}BAzB	B	B	BB	B	A=qAAAA:HA:H@
=@GAA@G@G@
=@
=    ?=q@
=@Y@Y?=q    @Y@Y@
=@
=    @Y@Y@
=?=q@
=@
=AA:HA:HA@GA:HAA:HA\  A\  A:HA:H@GAA}AA\  AA:HA\  A}AA:HAAA\  A:HA}A:HA:HA:HAA\  A:HA:HA:HA}A\  AA}A}AA\  AA:HA\  AA:HAAA\  A\  AAAAAAAAAA\  A:H@
=@G@GA:HAAA\  AAAA=qA=qA}@
=AAAAA@
=@G@Y@G@
=@
=@
=A@GA:HA@GA@G@
=AA\  A}A:H@GAAA:H@G@
=A\  AA\  AA:H@GA}AA:HA@Y?=q@
=@G@GA@G@
=A:HA\  A:HAA=qA\  A}AAA=qA=qAAAA\)AAB	AB*AAAB"B{B"B\)AA:HA}A@GAAAAA\  A\  AA\  A\  AA\  A:H@GAAA@G@YA@
=@
=@
=@Y@
=@
=@
=@Y@
=@
=@G@G@G@
=@
=AA:HAA:HA:HAA@G@
=@GA\  AA\  AA\  A}AA:HA@
=A\  AAAAA}AAA\  AAAA=qAAAA\  AAA:HA:HA@GA}AA\  AA}A}A=qAAAAAA=qA}A\  AAA}A\  A@GA@GAAAA:HA\  AAA\)B"AAzA=qAAB{B*B*B*B;zB;zBA\)ABAA\)AzA=qAAAAA}A}A\  AAA=qAAAAA\  @
=@
=AAA}A\  AA}AA}AA=qAA\)AAAA@GAA:HAAzAAzB{B\)A=qAzAB*B333A\)A\  AA\)AA\)AA\)BB{B"B"B333B*B;zBTQB;zB333B333BCBTQBTQBCBTQB333B333B{A\)A\)A=qA=qAA}AAAA}AAAA}A}A}A:HA\  AAA}AB#B  B;zBTQBdHB*BCB333B"B333B333BTQB;zB\)AB	BBAA=qA=qAAB{B;zB;zAB	ABBB333B"BTQB;zA}AAzAAAA=qA\)A=qA}A}AA}AA\)AA\)A=qB{BBBB{B"BL
=B;zB;zBCBTQBL
=B;zB*BAzAzAABAAAA\  A}A}A\  A\  A:HA:HAAA\  A:HA:HA}A:HA}AA=qAAA\  A:HA:H@YA:HA:HAA@GAAA}AA\  AAA=qAAA:HA:HA}A@
=@
=A:HA}AAA=qAAAB\)AAAB	A=qAzB{B	B	AB\)B{B"AAA\)AA\)AB*B	AzAzAzAA\)ABB{B"B{B	AA\)AAA\)AzAAA\)ABAzB	BAB	A\)AAA:HAA}AA:HA}AA\)AA}@GA\  A:HA:H@G@G@G@G@G@G@G@G@GA\  A\  A\  A}A}A\  AA=qAA:HAAA=qA:HA}AA}AA\  A\  A}A\  A}A\  A}A}A}A:HA}AA}A\  A\  A}A}A}AAA\)B{B\)A=qBB	B\)A=qB{B\)B\)B*B\)B	B{B\)B	BA\)AB	AA=qAAAAB	A\)AAAA=qA}A}A=qA?=qA}A}AAAA=qA\  A}AA=qAAA:HA}AAA:HAAA\  AA=qAA}A}A:HA\  A\  A}AA\  AAAAA}@GA@G@Y@
=@Y@YAA:HAA:HA\  A\  A\  A}A\  A}A}A\  A}A\)A}AA}A=qAAAA=qA\)AzBAzAB	AAAzB	ABBB	AB	B	B{B{B*AzB{AA\)AAA\)AzB\)B	AAB333B;zB"AAAAA:HA:HAAA}A}A\  A}A\  AAAA}A}AAAA}AA@G@G@G@Y@G@G@
=@Y@G@
=?=q?=q    ?=q?=q@Y@Y?=q?=q?=q@GAA:HA:HA\  A:HA:HAA\  A=qA:HA}A}A\  A}A\  @GA=qAAB	B{ABBAB	A\)A\)A\)AA:HBAA\)B333AB	AA@GA@GA@G@
=@G@
=@Y@G@
=@Y?=q@Y    ?=q?=q@Y    @Y@Y@
=A\  @G@
=@
=@G?=qA:HA:HA\  @G?=q@
=@
=A:HAAA}A\  A\  A\  A}A}A:HA@GA@
=    @Y@G@G@YAA:HA\  A\  AA}AA=qA\  A=qA:HA\  A:HAzAABAA:HAA=qAA=qAA\)A=qAAAAzB	AAAAA=qA\  AA:HA@GA\  AAAA:HA:HA:HAA@G@
=@Y@
=@G@Y    @
=@Y@
=@
=AA\  A}AAA=qAA}AAAA=qAA}A}AA}A:HAAA\  A}AAA:HAAA\)A\  A:HA@G@G@GA:HA:HAA\  A:HA:HA\  A\  A\  A\  AA:HA\  AA}A}A}AA\  A}A\  A\  AAAAAA=qA\)AA\)AA\)AAA\)AAA:H?=q?=qA:HA}A:HA\  @GA:HA\  A\  AA}A\  AAA\  AA=qA}A=qA\)B*B}RBupBCB"BTQB	B*B"B*B*AAA\)AAAzAzAAAAA\  A:H@G@G@
=@G@Y@
=    ?=qAA@
=A@Y@Y?=q    @
=@G@Y@Y@
=@
=@
=@
=@
=@
=A}AAA:HA=qAzAAAAAAAA=qAAAAAAAA}A\  AA:HA\  @
=@
=@GAAzAA}AA}A@G@G@
=@Y?=q@
=A}AA}AA\)A}@G@
=AA}AAB"B\BCB{B\)B{B\)BAAAA\  A:HA:HAA\)AA=qA\)A\)A:HAA\)@GAA?=q?=q@Y@GAA@Y@
=@G@GA:HAA\  A}A}A\  AA\)A\)ABBB\)B\)B"B*B\)AABAA\)AAA=qA\)AzA}A:H?=q@
=A=qB	B{AAA=qA}A\  A:HA}A=qB{BA=qB	AA:HA:HA:HA}A\)BAAAAABAB333B"B{A=qA\)A\)A:HA\  A=qA}A\  A\)A=qA}A:HA:H@
=AA@
=?=q?=q?=q@Y@Y@
=A}@G@
=@
=A}A:HAA:H@G@GA\  AA\  AA}A}AAzBAzAzA=qB{A=qA=qBB\)B{B"B;zBCB;zB333BCB;zB*B;zB;zB;zB;zB"B\)AzB"AAA\)A=qB	AzA}AA}AA}AA:HA:HAA:HAAA:HA:HA:HA=qAB\)B	BL
=B#B  BdHBL
=AB*B\)B\)AB\)B{AzA\)AAA@GA@
=A\  A:HAA=qA\)A}AA\  A@GAA}A=qA\  A\  AAzAzAA}A=qB	B{BB*B*BCBCB\Bm(B}RBL
=BGB}RBupBTQB;zB;zBCB;zBCB"B	B{B	AB{B"B	B{BABBB\)B*B	B{ABA=qAzB\)A\)AAA=qA:HA:HAA:HAAAA@G@G@
=@GAy @
=@G@
=@
=@Y@Y@
=@G@GAAA:H@Y@YA@G@GA:H@
=AA:HA\  A\  A\  A\  @GA:HAA:HA:HA\  A\  A:H@G@G@G@Y@G@
=@YA@G@
=@GAA}A}AA\  A}AA=qA}AAAA@GA\  A@GA\  @GA:H@G@G@
=@Y@Y@
=@
=@YA@GA:H@
=@Y@YA@
=@G@GAAA\  AAAAAA=qB*B{AzA}AA}A:HA:HA\  @G@G@G@GA@GA\  A}A\  A\  A:HA@Y@Y@Y@
=y ?=q?=q@
=AA@GA\  A\  @Y?=q@
=y A:HAA\  A\  A}A:HA}AAAzAB*B;zB	BL
=B333BTQBTQBCBCBB{BB	B333B"B\)B\)AAAA=qA=qA=qA\  AAAA}AA:H@G@G@Y@GA:HA\  A:HA@YA=qAAAAAAAA=qA\  @GA\)A\)AA=qA}AAAAA=qAA=qA}A\  A\  A}A:HA@Y@Y@
=@GA@Y@
=A:H@GA:HAA}A}A\  A\  AAA=qA}A\  A}AAAAA\)AB	BB\)BBB\)B\)B{B	B	B{B	B	AAzBB	B\)AAzA\)AA\)AA=qAAAA\)A\)A=qA=qA}A\  A\  A}A:HAA\  A@GA}AA:HAAAA}A:HA\)AA\  A}AA\)A=qAA\  AA}AA=qAAA=qA=qAAAAAA:HA:H@
=AA:H@Y?=q@Y@
=@
=@YA:HA:HA@G@GA}@
=@G@G@
=A:HA\  A\  AA\  AA:HA}A}A}BBA\)A\)AAzB333B;zBCAAA=qAAAA\  A:HA}A:H@
=@
=@G?=q?=q@
=@Y?=q?=q?=qy ?=q?=q?=q?=qy ?=q@Y@Y?=q?=q?=q@GA}@GAA\  @GA:HA}AA}AA}AAA\  AA\  A:HA:HA@G@
=A@G@YA:HA:H@
=A@
=A}A\  AA=qAA\  AA:HA:HA\  A}A\  A}AABB	A=qA=qAzBTQB333AA=qAAAzB{AAA=qAAAAB"BA@
=A@
=@
=AA\  A@GAA:HA:HA:HA:HA:HAAA@
=A@
=A:H?=q@YAAA}AAzA\)A}AA=qAA}AA}A@
=@
=A}AA:HA@GAA}?=qA@
=@
=@Y@YAAAA\  AA=qA}A=qA=qAzAB\)B	AAzABAA=qA\)AAzAzB{B{B&B;zB333B;zB"B\)B"B\)B{AzBBB\)B{BCBCB"B\)B333B333B*B"B*B	B	B{BAzB{AAAzAzAAA=qAABBBB	B	BBAB"B\)B*BBBL
=B\)B*BL
=B	B\B\B333B333B	AzA=qAAAAAA=qAA\)AAA=qA}A\  A@GA@Y@
=@
=A\  A@GA\  AA\)A\)B	B	B;zB;zBm(B;zBCBupB#B}RBpB  B  B}RBpB  B	B}RB}RBdHBupBL
=B\B  BpBupBupB*B{B	B	AA}A\  A\  AAAA\  A\  A\  A}A\  A\  AAAAA\  A:HA\  A\  A@G@Y?=q@Y@
=@Y?=q?=q?=q@Y@Y@Y@
=@Y@
=@G@Y@G?=q@Y@G@Y@Y@Y@G@GAA:HAAA\)B{AzBCB;zB;zAAB*B\)BdHB\BL
=B"B;zBTQBCB\BCB\B}RB  B#BdHB}RBRBGB#B}RB;zBdHBdHBTQA:HAAzB{B	AA}AA:HBA\  AA=qAA}AAA\)BA\)AAAA=qA=qA\)AzB\)BCBCBCBL
=BRBL
=BGBkAB	BBAAA:HAAzAAA}A}A}A}A:HAA\  A\  A}AA:HA}A\  AA:HAA}@G@
=@GA:HAA:HA}AAB	AABAAAzBB	BB	A\)B{BB	BB	B\)B\)AAAA\  A\  A@G@
=?=q?=q@Y@Y@Y@
=@YAA=qA\  A:HA@G@G@
=A:H@
=@
=@Y@Y    @
=@
=@Y@Y@
=@Y@Y@G?=q@G@
=@
=@
=@
=@G@
=@
=@G@Y@
=@Y@
=@G@GA:H@G@G@
=@G@Y@
=@Y@G@
=@
=@G@Y?=q@
=@Y@
=@Y?=q@G@
=A@
=@
=@G@
=@GA\  A:H@
=AA:HA}A\  A}AA\  AA}A\  A\  AAzAA=qAA}AA\  AA\)A}AAA=qA:HAA=qAA\  AA}A=qAA\  A\  BBCB*B	B#BCB#BpB)BTQB333AAA:HAzB	BCBCB\)A=qA=qA}A}A}A:HAA@
=@
=@Y@
=@
=?=q@Y@
=@
=@G@GA\  A:HAAA:HA\  A\  AAA\  A\  A}A\  A\  A:HA\  AAAAAAAA=qA=qAAA\)AAAAA\)AAA\)AzBB\)B\BL
=AzBTQB\B\)AAzAzAA=qAA}A}A\  A\  A}@
=A:HA}AA\  @G@G@Y@
=A@
=@
=@
=A@
=@GABCB\)BBB
BTQA\)A\)B\BdHBpBCB	AzAAAzA}AA@
=A\  AA\  A:HA\  A:HA@
=@Y@
=@
=AAA\  A}A=qAAA\)AzAA\)A\)A=qBABB*BL
=B;zB;zBupB}RBupBdHBTQBTQBTQBdHBTQBCB;zB  B#B\B3B3B{B333B333B)BpBpBupBupBCB{AB*A\)A\)A}A}AAA:HAAA:HA\  AA\  A:HAAAA=qAA\  AAzAA=qAA=qA\)A\)A\)AzAAAAAA\)AAA\)A\)AzB{AA}A\  A}A}A\  A=qA=qAA\  A}A\  A}A\  AA}AA\)AAAzBBB"B*BL
=BCBCB}RBCBCB*B*B*B"B"B"B\)AzB\)B\)B	B	B	A\)B"B\)B\)BBAzA=qAA}AA=qAA\  A:HA:H@GAAAA=qA:HA}AAAA:HAA=qAA=qAA\)A\)A\)BA\)A=qA=qA\)A}AA\  AA\  A}@
=@G@
=A@G@G@G@G@GAAAAA}A:HAA=qAAAzB	BAzAzAA=qA\  A@G@GA\  AA}A}A:HAA}AA=qA:HAA\)A}AAA=qA}A:HA:H@GAA@GA@
=A\  AA\  A@G@G@G@G@G@
=AA:HAAA:HA}AAAAA}A\  A=qAB\)B	B	B{B	BB{A\)AAAA:HAA:H@G@YA@G@YAA\  @G@
=@G@Y@
=@Y?=q@
=A:H@
=@GA:H@G@Y@Y@G@G@
=AA:HAB{B	BCB\BTQB}RB{B\BupBdHB;zB;zB	AA\)A=qB;zB\)A=qA}@GAAA=qAA@GA:HAA@
=AA@G@
=@Y@Y@Y@GAA:H@G@G@G@
=@Y@Y@G@GAA}A:HA:HAA=qA=qA=qA\  B	B"AAAA:HAA=qA@G@G@Y@
=    @Y        ?=q    @Y?=q@YA@GAAAA}A\  A}AAAABB{B*B"BTQB\B\B\B\Bm(B\Bm(B;zB;zABA\)AAAAAA=qA}A\  A\  A:HA:HA:HA:HA\  A:HA\  A:HA\  A}AA=qA=qAAAAA\)AAAA\  A\  A:H@
=A:HAA@GA:HAA:HAA:H@GA@
=A}@G@
=@G@G@GAA:HA\  A\  AA\  AAA\)AzAB"A=qA=qAzAAAAAA=qBA\)AAAAAzAzB{B{B"BL
=BL
=B\B\BupB}RB}RB  BGB}RBupB}RBpBdHBm(B}RB#B#B#BGB#B}RB}RBupBupB\B}RBTQB\BL
=BTQB;zB333B{B"B{BB	A=qAB*B"B*B	B	A=qAA\  A}A\  AAA\)ABA\)AA=qA}A:HA}A\  A}A\  A:HA\  A:HAAAzAAAAA\)A\)BB{B\)AAzAzB	B"B\)A\)AAzB	B	B\)B"BTQBCB\BL
=B\BdHBupB;zB\BL
=B;zBdHB\B"BAzBAA\)AAAA=qA=qAA}A}A=qA:HA:H@GA:HA\  A:HAzBA\)A\)AzAA=qAA\)A\)AAzAA=qAAAAA\  AA=qAAA\  A@GA\  AA}A}AA\  A}AAA\  AA:H@GA@GA:H@
=@
=@GA@GA}A\  A}@G@
=A:HAAAA\)AA\)AA}A}AA\)A=qAA\)A\)AAA=qB{ABAAzBAA\)AAA=qAB	AzB\)A\  A}A=qA=qAAAA}A}AA}A}A:HAA}A:HA\  A=qA\  A:HA}A\  A}A:H@GA\  A:HA\  A\  A:HA:HAA:HAAA@GA\  AA:HA:HA:HA}A\  A:HAAA@GAA@G@Y@
=@
=@G@Y@
=@
=A\  AAAAA\  AA\  A\  AA\)A\)A\)AB	BA:HAAAAAAAA=qA\)ABB"B"B	B"B333B	B\)BCB{B\)BCBCB*BCB;zB333BCBTQB333B*B333B333B333B"B"B333B*B*B*B\)B	AzAA\)BA\)AzBB	BB{B\)B\)B{B"B*B*B*B\)B\)A\)AzBAzB	A\)A\)AAzABBAzAAAA\)AA=qA}AA\)ABAzB333BpB*B	B{A\)BAABB\)A\)B\)BA\)AAAzAzAA\)AA}A\  A}A:HA}A\  AA:HA@G@G@GA:H@G@GA:HA}@GA@
=@GA:HAA}A}A:HA\  A\  A\  A:HA@
=@G@
=@Y@G@
=AAAAA:HA:HA@
=@GA@
=@G@G@GA:HAA@
=AA\  A\  A:HA:HAAA:HA:HA:HAAA}A\  A:HAA:HAA}A}A}A=qAB\)A=q@
=A:H@GA@GA\  AA}A}A:HA}B#BCB	A\)A=qA=qA}A}AAAAAA}AA}A\  AA\  AAAA\  A}A\  A\  A:HAA\  AA\)AA\)A=qBAAzB{B*B333B333BCAzA\)A=qA\)AA\)A=qAAAAAAAAAA\)A\)AzAA\)AAAAA\)A\)AAAA=qAA=qAAAAAAAAAAAA=qA=qAAA\)B"AAAAA\  A\  A}A}A\)AAA}AAAAAAA}A}AA\  AAAAAAAAA}A}A\  A}A:HA}A:HA:HA:HA:HA:HA:HA\  AA:HA\  A:HA@GAA@GAAA:HA@GA:HAAA:HA}A\  A\  A\  @G@G@G@
=A@
=@
=@Y@
=BG@GAAAA\  AA}AA\  A\  A\  A\  AA\  A:HAAAB{B\)B{B{B	B{AAA}AAzA\)AAA=qAAAA}A\  A}@GAA:H@G@GA\  AA}AAAA:HA:HA\  A:HA:HAA:HA:HA\  A:HA=qABAAA\)AAAAABAA=qA\)AA\  A:H@
=A@
=@
=AA:H@G@GA}@
=@G@G@
=A:H@YA}A\  AAA=qA=qAzAzAB333BA\)B{B{B*B;zB\B333BCBCB;zBCBL
=BTQBupBupB}RB#B"AA}A=qAA=qAzA=qAAzBL
=BL
=B;zB\)ABL
=B	AB\)A\)AAzAA=qA=qA=qAA}A}AAAAAAAAAAABAzB{B	B{B{B*AzA\)A=qA=qAzAA=qA=qAAAAAAzA=qB{B}RAzB{B"B	B{B{B	B	B\)B*B\)BCBL
=B#B#B
B}RB}RB  B3BupB}RBTQB}RB333B"B333ABTQBdHB"B;zB333B"B"BB{B	AzAAAABB	A\)AABABAAAA\)AAAzAAzAA\)A\)AAA=qA\)A=qA\)AAAA}A}AA}AAAAAAAAA:HA\  AA\  AAA}AA}A\  A}A}A\  A\  AA\  A=qA}AA=qA\)AA\)AA\)A=qAB	B{BB\)B{B\)BB;zB*B;zBB{BB	B{B	AzB	AA\)A=qA}A=qA}AA=qAAAAAA:HA=qA}AA}A}AAAAAAAB\)AAAAA=qA=qAAA=qA}AAA}AAA}AAAA}AAAA}A}A}A}AA}A}A\  A=qAAAAAA=qBAA}A}A:HAAA\  A:HA\  A\  AAAA}AA}B{A=qAA\)BB{B\)B	B333AzBAzAzAAzB\)AzAzAAAAzAAA=qAAA\)A=qA=qAAA}AAA}AA:HAA\  AAA}AA\  A\  A\  A\  A\  A}A\  A}AA\  AAA:HA\  A\  A:HA\  A\  A\  A\)AA@GAAAAA:HA:HAAAAAA\  A}A=qAA}A\  AAAAA}AAA}A\  AA\)A\)A\)B*B\)BCB\B{AzA=qAA\)BB	A=qAA\  A:HAAAA@G@GA:HA}BAzA\  AA}A}A\  A:HA\  AA:HA:HA:HA\  A:HA:HA:HA\  A:HA\  A:H@G@
=@G@
=@
=@GAAAA:HA:HA@G@GA\  A@G@G@Y@G@
=A@
=@
=@GAA:HA\  A:HA:HAA\  A}A}A}A@GA\  A:HA\  A:H@GA:HAAAA:HA\  A@GA@GAA\  A\  A:HA\  A\  AA:HAAA:HA:HA}BAAAAAA:HA:HA}@GA:HA}A}@G@
=AA:HA\  A:HAA\  A:HA\  A:HA:HA:HA:HA:H@
=AA:HA\  @G@G@G@G@G@
=@G@GA\  @
=@
=@
=A@Y@G@
=A@G@
=@Y@G@Y@
=@
=@GAA\  A:H@GA:HA:HAAAAA=qAAA}A:HA\  A@
=@
=@
=A\  A:H@G@
=@
=@
=AA:H@G@
=@
=A\  A@GA:HA}AAAA:HA:HB	A}A}A:HA@GA@G@G@G@
=A@
=@G@
=@G@G@
=@
=@
=@YA@Y@Y@Y@
=@
=@Y@Y@Y?=q@Y@YA:H?=q@Y?=q@Y?=q?=q@Y@Y@Y@Y@Y@Y?=q?=q?=q?=q?=q?=q?=q?=q    ?=q?=q@
=@YA@
=A@
=@
=@
=@Y@
=@Y@G@G@Y@
=?=q@
=@
=@Y?=q@
=@
=@
=    A@
=A@G@G@G@GA:HAA:HA:HA\  A\  A:HA@GA:HA@
=@
=@Y@G@G@Y?=q@Y@G@G?=q@Y@G@Y@Y                ?=q?=q                        ?=q                @Y?=q?=q    @
=?=q    ?=q        ?=q    ?=q            ?=q        ?=q    ?=q?=q            ?=q?=q    @Y?=q    @Y?=q?=q@
=?=q@Y@Y?=q@
=@G@Y@
=@
=?=q?=q@Y@GA@Y@
=@G@G@
=A@
=@G@
=@G@GA@YA@Y@G@
=A@
=@Y@G@
=A:H@
=    @
=?=q@Y?=q@
=@Y@
=@Y@Y?=q@Y@Y?=q    ?=q?=q?=q@
=?=q?=q?=q        ?=q    ?=q?=q            @Y?=q?=q?=q?=q@Y?=q@G@G?=q@Y@
=@
=@
=A@G@Y@
=?=q    ?=q    @Y@Y?=q@
=?=q        @Y?=q@YBL
=                ?=q@Y?=q?=q@G@
=?=qA:H?=q?=q?=qA@GA@G@G@GA@G@
=@
=@GA@GAA@G@
=?=q@G@G@G@
=?=q@Y@
=?=q?=q?=q?=q?=q?=q?=q    @Y?=q?=q?=q            ?=q?=q@Y?=q    ?=q    @Y?=q?=q?=q        ?=q                @
=A@
=?=q@G@G@G?=q?=q@
=@Y?=q@
=@
=@Y@Y@Y    @Y    @
=A}A:HA:HA\  A}A}A:HA}A}AA=qA=qAA\)BAzBAzA\)B{B	B{BA:HA\)A@Y@
=@Y@Y    ?=q@Y@
=@Y@Y@
=@
=@Y?=q@Y    ?=q@Y@Y@
=?=q?=q@Y?=q@
=@Y?=q?=q@Y@Y@Y@Y    @
=@Y    @Y@Y?=q@
=?=q@G?=q?=q@Y@
=@
=@
=@YA:HA:HA:HA    ?=q    @Y    @
=@Y    ?=q?=q@Y@Y@Y?=q@G@
=@Y@G@Y@
=@G@
=@G@GAAA:HA}A}AAA=qA=qA\)AB{B\)B{B*B	B\)A\)B{B{B	BB	BAAAAA\)AA:HA\  A:HA:HAA\  A}A}A:HA\  A\  @G@GA:HA\  A@Y@Y?=q@
=@G@Y@Y@Y?=q        ?=q@G@GA\  @G@
=@
=@G@G@GAA:HA\  A:H@G@
=@GA\  A}AAAAAA\  A\  A:HA:HA\  AAA\  A=qA:HA:HAA}AAA}AA=qAAzAAAB{B{AB*B*B\)B\)AAB	AA=qAA=qAA=qA}AA}A@G@G?=q@
=A:H@G@G@Y?=q@
=@Y@Y@Y@
=?=q?=q?=q@G@Y@G@Y@Y@G@
=AAA:HA:HA:HAA:H@G@G@
=?=q@
=@
=?=q@
=@Y@G@G@Y@Y@GA@
=@
=?=q@Y@Y?=q@Y    @Y@Y?=q@
=@G@G@GA@GAA}A}A\  A:HA:HA\  A:HA\  A\  A\  AA=qA=qAA\)A=qA=qAzA\)A=qA=qA\)A=qAAAAA}A}A:HA\  A:HA\  A\  @GAA@G@GA\  A@
=@
=@Y@
=@Y?=q?=q?=q@Y@Y@
=@Y@Y@Y@Y@
=    ?=q?=q?=q?=q?=q?=q            ?=q                    ?=q    ?=q@
=@G@G?=q@Y?=q@Y@G?=q@
=@
=@
=@
=@
=@
=@G@G@
=@
=@G@
=A@GA:HA\  A}A:H@GA:HA\  AAA@G@
=AA}AAAA:H?=q@
=    @
=AA:HA\  AA:HA:HAAAAA\  AA\  AA\  A\  A}AAA\)AAA}A}A}AAA}A\  A}A\  A}AAA=qAA}A}A\  A\  AA}A}A}AA}AAA\  A}A}A\  AAAAA}AA}A}A}A\  A=qA=qAAA}A:HA}A\  A\  A@GAAA:HA:HAA@GAA:HA@GA:HA:H@GA@
=@G?=qAA:H@G@G@Y@Y@Y@Y@Y?=q@Y@G@G@
=@G@
=@
=@Y@G@Y@
=@
=@Y@Y@G@G@
=@G@G@
=AA@
=@G@
=A:HA@G@G@GA@
=@G@
=@
=@Y@
=@
=@
=@YA@G@GA@GAA@
=@YAA:H@YA@
=A@G@G@G@
=A@G@G@GA:HAA:HAA}AA=qAA\)AAA}A\  B8RBB"B;zBL
=B{B*B333BTQB\)B*B"AzB	BBA=qAA\)AAAA}A}A}A}A}A\  AA\  @GA:HAAA:H@GAA@G@GA:HA\  A}A\  A\  AA\  A\  A:H@GA:HA:HA:HA\  AA@
=A@GAAAA}A\  A:HAA}A\  AAA@GAA@GAA:HAA}A:HA=qA:HA@YA:HA}A}AA\)BB"B{B{B\)B\)B"B;zBL
=Bm(BGB  BkB)BdHB}RBL
=BdHBTQBTQBCBm(BpB;zAB"AB333A=qAAAAA}A:HA:HA:HA:HA:HA\  A}A}A:HA:HA:HAAA:HAA}AA}AzBBBB	ABB{A=qAA=qAA=qAA=qAA=qAA:HAAA@G@G?=q@G@G@GAA\  @GA:HA}A:HA:HA}AA:HA}A:HAAA@
=@
=A}A}AA=qAB{B\)AzBB{B\)B*BAAB{B"B\B;zB\B;zB;zB{B{B{AAAA}A\  A}A\  AA}B333AA:HA:HA\)@GA@
=AAA=qAAA\  AA}@GAAAB{B\)B*B"B*BA@
=AAAA\  A:HA:HA\  AA=qAA:HA\  @Y@
=AAAA@
=@Y?=q@Y@GAA\  A\  A}AA}AAA=qA\)A=qA=qAA\)B\)B*B333BCB\B#BdHBpB#B  BTQB\BL
=B\BupBupBL
=BL
=B\B\BupB\B;zBdHBL
=B	B\)B	AAB	AB\)B;zBdHBL
=A}BRAAB*AA=qA}A\  A:HA:HAA\  @GA@GAAA\  A}A:HA\  A}A\  A:HAAA=qAA\)AA=qAAAA=qAAzAzB{AzB\)B	B{B"B\)B*B;zBL
=BL
=B\B\Bm(B  B#B{BupBdHB  BGB#B{BpB)BpBGB)BGBGB#B{BpB  BupB}RBGB#B{BRBGB{BupBm(B\BL
=BTQABAA\)AABBB	B"B*B	B"B\)B*B*BdHB\)B333B*B"B{B{B	BupB"AA=qA\)A\)AA=qA\)AA=qA=qA\)A\)B\)AAA=qAA=qA\)AA=qA=qA\  AAAA}A}A}A\  AA}A\  A\  A:HA:HA}A}A\  A\  A:HA:HA\  A:HA:HA:HA@GAAA\  A:HA:HA\  A:HA\  A\  A\  A\  AAA\  AA:H@GA@GAA:HA:H@GA@
=AA@GA@G@
=@
=@
=@G@G@
=@G@
=@GA@G@
=@G@G@
=@Y@G@
=@G@Y@
=?=q?=q@Y?=q        ?=q@Y        @Y        @Y    ?=q@Y    ?=q        ?=q?=q?=q    @
=?=q?=q    ?=q            @Y@Y    ?=q    @Y?=q@G@GAA\  AAAA}A\  A\  A\  A:H@YA:H?=q@
=@
=A@GA\  AAAAB{A=qAAAAA@GAAA@
=@GA@
=@Y@Y@Y@
=@
=@
=@
=@G?=q@
=@Y@
=    @Y@Y?=q@
=A\  @
=@Y@Y@
=?=q?=q@
=@Y@
=@G?=q@G@Y@
=?=q?=q?=q@
=@Y@
=?=q    ?=q@Y@Y@Y@G@YA:HA\  A\  AAA=qAB\)B"B333BCBm(B}RBGB{BRB
B{Bm(BGB{C+CB#BGBRBCB
BdHB*BL
=B;zBCB"B333AzB	B{AzB	B{B\)BAAA=qAAzA}A:HA:HA=qAzAA:HBB\B"AAB"BAAA}AAAA\)A=qAAAA\)AAAA:HA:HAA\  A:H@G@
=A\  A:H@G@Y@G@G    @Y@
=A:H@YA:H@Y@YA}AAA=qAAzAzAzAAAAAAAAAAAAA\  A}A}A}A\  A\  AA:HAA}A}AA\  A}AA:HA@GAA:HA\  A\  A}AA:HA\  A\  AA\  AA\  A:HA}AAA:HAA:HA\  AA:HAA}A}A\  ACAA:HA:HA\  A\  @
=A:H@GA@Y@G@
=@
=@YA:HAA=q@G@
=A:H@
=@
=?=q@Y@Y@Y@
=@
=?=q?=q?=q    @Y@
=@
=@
=@G@G@G@G@
=@
=AAA:HA:HAA:HAA=qAA:HA@G@G@GAAA\  A:HAA:H@G@
=@
=@
=@G@
=@
=@
=@
=@
=@Y@Y@
=@Y@Y@
=@Y@
=@Y@
=@Y?=q@Y@
=?=q@Y?=q@Y@Y@Y?=q?=q@G?=q?=q?=q?=q@
=@Y@Y@Y@Y@
=?=q?=q@Y?=q@Y?=q@
=@
=@Y?=q@Y?=q?=q?=q    @Y@Y@Y?=q?=q?=q?=q    ?=q    ?=q?=q@
=?=q@
=AA:HA}A=qA=qA=qAAAAAA:HA:HA:HAA\  A:HAAAA\  A:H@GAA@GA@GA@GAA\  @GA@GAA@GA\  @
=@Y@
=@Y?=q@Y?=q@Y    @
=@
=?=q    @Y?=q        ?=q?=q?=q            @Y?=q@Y    @Y@Y?=q?=q@Y@Y?=q@
=@
=@Y@Y@
=    ?=q?=q@Y?=q@Y    @Y            @
=    @
=    @Y?=q@Y@
=@
=@
=@
=@GA}A:HA}AAA\  A}A\  A\  AA\  AA:HA:HA:HA}A\  @GAAA\  @G@G@GAA@GA@G@
=@
=@G@G@
=@
=@
=@Y@
=@Y    ?=q@Y@Y@Y@Y@Y@Y@Y@G    @Y?=q?=q    @Y@
=?=q@Y@Y?=q@G@Y?=q?=q@Y    ?=q@Y?=q@Y?=q    ?=q@Y@Y?=q@
=@G?=q@Y@Y?=q@Y@G@G@
=@GA:HA\  @GA=qA:HA\  A:HAA:HA}A}AA\  A:HA:H@
=@G@Y@G@GAA\  AAB\)BAA\)AA\)A=qA=qAAA}AA\  A}A\  A:HA\  A\  A\  A\  A}AA:HA:HA}AA:H@
=@
=@Y@
=@
=@
=A@Y@Y@YA@GAA@GAAAAA:HA\  A@G@G?=q?=q    ?=q@Y    @Y    A:H?=q@Y@
=@
=    @Y@Y@Y@
=@
=@Y@
=@Y@Y@
=@Y@
=@Y@Y@
=@
=@
=?=q@Y?=qA:HAAAA\)AzAzAAA\)A\)AAB\)AAA}AAA}AAA\  A\  A\)A\)AAB@
=@
=ABA}AAA:HA=qAA}A\  @GAA\  A\  A\  A:HA}A:H?=q@G@GAAAAA@
=@GA:HA@GA@
=@Y@Y@
=@Y@Y@
=AA@Y?=q?=q@Y@
=@Y    @
=@Y@
=AA}AA\)BBBA\)BB"B"B\BTQBL
=B;zB\BdHBTQB;zB\B333BTQB;zBAAA=qA=qB{A\)AAA\)BB	AB{AzABAAB	BCB*B"B\)B"B333B333BAzAA=qAAAA=qAzAzA\)AAA=qAAAAA@
=    @G@G@GA@
=@Y?=q@Y@
=?=q@
=@
=?=q@
=@
=@Y?=q?=q?=q?=q    ?=q?=q?=q?=q@Y?=q?=q?=q?=q@Y@G@GA:HA\  A}A=qAA=qAA:HAA\)A=qA=qA}AB	A=qAzB{AA@
=@GA=qA\  A:HAA\  A:H@GA:HA\  AA\)AA\)AAA=qAA\  @Y@G@
=?=q@Y    ?=q    @GA@Y@Y?=q?=qB{?=q    @Y@Y?=q                ?=q            A:HB{B	BL
=BdHAA=qA\  A}A:HAA@GAA}A=qA}A:H@
=?=q@Y@Y@GAAAA}A:HA\  AAAAA=qA=qAzAAA}A}AA:HAAA:HA}AAAz                                                                                                                                                                                                                                                                                                                                                                                                                                                                BBB͊=B=qB3BB
BRB  BpB{B{B#B;zB333B\)B"B\)B333BL
=B*B	B*B	B333B*B333BupB#B;zBCBGBpBL
=BdHBm(BupBm(B\BTQBL
=BTQB\BCBAAAA\  A}A:HA}A:HAAA\)@G@GA\  AB{A\)A    AAA\)B	B{ABB	B\)B;zB;zBCBdHB  B}RBGBm(BpB#BRBGBkB
BB͊=BffB8RBBB8RBaHBBBBaHBB8RBBBCB{B#B=qA\)B333AAB	B
BdHB\)B\BB{BdHB{BGB#BRBdHBupBpBpBGB#BRBGB#BupBGBpB  B  B#Bm(B  Bm(B}RB\)AA}AAAAAA\  AAA}AA}A:HAAA\)AAA}AA:HA\  AAB\)B*B;zB333BTQB}RB*B;zBm(BdHB  BRBRBpBGBB)B\B#BGB}RBdHB#BB
B  BGB  BRB  B#BpB	B333B\AzA\)B{B	AA\  AAA\  AAAAAA\  A}AB"BB	B{BB	ABTQB*BL
=B*BTQB{B{A\)B"B\)B\AB{B"AzAA\)B\)A}@
=@G@G@G@
=AA\  A\  AAA:HA}AAA=qAAAA\)AA\)AzA\)AAAzBB"A=qB	B	B{B"BCB  BTQB;zBdHBpBkB  B;zBL
=B{BCB"BAzAA=qA\)AzA\)AA=qAAA:HA:HAA@
=?=q@
=@Y?=q    ?=q?=q?=q@G?=q    @
=@Y        ?=q@GA@GA?=q@YAAAA}A:HAAA\)AA}A}A:HA\  AA\  A:HA}A}AA=qAA@G@Y@
=@Y?=q@
=A\  AAB	B	B"B	AAzBB{BB\)B333B"B\BdHBL
=B#BGB3B#B#B  B#B#B\Bm(B\)B\)B{B"B{B{AzAzA=qAA}AAA=qA}@
=@GA:HAA=q@Y?=q@Y?=q        @YAA@
=A=qA@GAA}AA=qBAzAzABAzA\)AA=qAAAAA=qAA\  AA\)AzBAA:HA\  A=qAA:HAzAA=qAA=qAB	B{AB333ABm(BGB;zAzBL
=BL
=B;zB333B333B;zB\BdHB\Bm(B}RBGBGB{BpBTQB\Bm(BpBL
=B;zBCBTQBL
=B{AB	B	B	B	AAAAA=qA=qAAA}AA@
=AA:HAA}AAB	ABB	B}RB}RB#B  B#B}RB*B	B"B\)AB	BB\)B333B333AB{B"A\  AA@G@GA@YAA:HAAA:HA:HA:HA=qAA\)A\)AzA\)AAzAzB*B333B*B	AAzB{B"B\)B	B*BL
=BdHBm(BdHBm(Bm(BdHBL
=B#BGB"B	B#B*B*B333BL
=BCB;zBCBCBm(B\)B;zBTQBdHB;zAA}@GA@
=@Y@GAAA}AAA@GA}AAAA\  AAA=qAA}A}A\  A@
=A:H@GAA@
=@Y@G?=q@
=@
=    @Y    @
=@YA?=q@YAA\  A}AAA\  AAA=qA:HA@
=@
=A:HA:HA:HA\)B{B333BTQBGB)BRBGBupBm(BTQB\B*BCBL
=B"B;zB	B*B{B333AA=qA\)AAzAzB*@
=@GA@Y    @
=?=qA}A}AA@Y@Y@Y@
=?=q@Y@
=    ?=q?=q@Y?=q        ?=q    @Y        @Y@Y?=q@Y    @Y@Y@Y@G@
=@
=A\  @G@Y@
=A:HA@GA}@Y?=q?=q@YA            ?=q@
=A@
=?=q@GAAA:HA:HA:HA\  A=qAA\)A\)B	B\)B\)BB"B333B*B333A\  B333B\)B{B333A\)B;zB\)B\)BL
=BBA\)B{B;zB{BTQB{B{B;zA\)A\)A=qA\  AA:HA\  A=qA=qAAAAB{ABB	AAAzA\)A\)AAAA\)AAA}A\  AA\  A\  A@GA}A\  @
=?=q?=q@GA@Y@
=A:HAA@GA@GA\  A}A=qAA=qAA=qAABAzB{B*BL
=BL
=B\BupB}RBGBRBGBRB  B#B)BGBRB)B#B\B  BRB)BpB)B  B  B{B)B  BkBRB;zBm(BdHB333B*B;zB*AA=qAA\)A}BAzB\B\BupB\BCB\)BCB	B{AB;zB333B\BTQBTQB\)AA}A=qA}AAA}A:HA@G@
=    @G    @
=@Y@
=A\)@GA@
=@
=A\  AAA}AAAAzAAAAA\)AA=qA=qBB333B\Bm(Bm(B#BTQB"B\)BCB	B\)B333B  B;zB}RBL
=B  B\B\)B"AzB	AzBAA=qA=qAA\  A=qAA:HA}AA\  A\  AAA=qAAAABB333BL
=BL
=BL
=B	B*A\)A\)BA\)A=qAA@GAA:HAAAA@GAAA@G@
=?=q@
=@YA:HA}A\  @GA@Y@Y?=q@
=AA\)AA\)AzB\)BCB\BL
=BupB;zBTQB#Bm(B)B  B)BkBBBBBB\B;zB#BffBRB  BRBRB\)AA}A:HB333A\)A}AA:HB\)A\)BupB{A=qB*AA\)B\)BAzAB*AAzAA=qBA\)A\)B	B"A\)A=qA:HA@GA:HAA}AA\  A:H@
=AA\  AA\  @GA:HA}AAAA\  A}A\  A}@G?=q@Y?=q        A:HAAB	A\)A\)B{B333B333B\B"BCBCB	B;zB333BGB#Bm(BGB}RBm(BCBB{B	BB{B;zBTQBupB}RBGB\BffBBkBRB}RBdHBdHBpB{BdHBupB\BBffB8RBRBA\)BTQB*BB333B*B333B}RB\B)B*BCBTQB  BCB"B{B\)A\)A=qA\  A}A:HA@G@
=@G@Y?=q@YA@
=@G?=q@
=A\  A:HA}A\  A\  A:H@
=@
=?=q@GAAA\)A=qA\  A\  A}AAB{AAAB*B	B333BCB;zBCB"BL
=BTQB\BTQBL
=BTQBL
=B\BCB\B;zBBTQBL
=BCBL
=BL
=BCB333B\)A\)AA\)B333AzAzBBAB{B	AA\)AAB{BGBupB*BTQAzB*B*B{BCBTQB"BB\)B{B*B"B333A\)A\)A}BL
=AA=qAAAA=q@G@YA\  @G@Y@Y?=q@
=AA\  @GA:HAA:HA:HA}A\  AAB"BCAB\B333B;zB;zBL
=B\B*B\BL
=BdHBGB\B#B}RB}RBGBm(BGB#BBGB#BaHBѮBB  BupBdHB}RBTQB	AB{@
=B{B*B"BL
=A\)B"BTQAB	AzB{B\BCBupBupBTQBCBupBm(B*A=qAA=qB{AzAAAAA\)AzA=q@GBA}A:H@G@
=A:HA}A\  A:HA:HA}A=qA\  AA\  A}A}@G@GA:H@Y@GA:HA\  A=qAB	B	B*B"B*B;zBdHB}RB#BpBGB{B{BGBkBkB  BGB#B  AB{A}B#BTQBTQBTQBdHBm(B\)AB;zAA}A}A=qA:HA}@GA:HA}A:H@
=?=q    ?=q@G@GAA\  AAB{BA=qA\)A=qAAAB\)AA=qAAAA}AA}A}A:HA:HA\  @G@
=A\  A:HA@G@GA:H@G@
=AA@G@
=@YA\  A}A\  AAAAAA\  A:HA:HA}A\  AAA\)AzBB\)B*BTQB333B\BdHBm(B\B\BTQBm(BL
=B	BAA}AAAA}AAA\  A@
=@G@G@G@G@G@GAA\  A\  A\  A\  AA:H@G@Y?=q@
=A:HAA}A:HA@GAAAAAA\)A@GA:HA:HA:H@GA@Y@
=A@G@GA:H@G    @
=@GAA\  A@
=A@
=AA:HA\  @
=A:HAA:HAAA}AAAA}AA}A}A:HA:HA=qAzB	B"B\)B\)BCAzB{B{BTQB"B"B"AB*BABAAAAA:HA:H?=q?=q@Y@Y@
=?=q    ?=q?=q    @G@G    @
=@G@Y?=q?=q    @
=    @
=@YA@
=@Y@
=@Y?=q@Y@
=@Y@
=?=qAA@G?=q@
=?=q?=q@GA:HAAAA}A\  A=qAAAAAAzA=qAA}A:HA:HAAAAA}AAAzAAzB\)AzBB{BAzBB	B	B*B\)BCB}RB}RB{B  Bm(B{B	AAAzAAAAA}BA}AAAAA=qAA=qA\)AA\  AA}A}A\  @GAA\  A:HA:HA:HA\  AA}AA=qAzA\)AAA=qA}A=qA\  A}A\  A\  A\  A}AAA\  A:HA:HA:HAA\  A\  A\  A}A\  A}A:HAA}AAA\  A\  AA:HA\  A\  AAA}AA=qAABB"B\)B;zBL
=BupBpBpB3BB  B#BRB
B{BpBCBdHB\B\BTQBTQB#B;zB\BCAA=qAA=qA}AAA=qA=qAA=qA:HAAzB"B{AB	BB*BB"B*B	AAAA}A=qAAAA:HAAA:HA:HA\  @
=A\  A}@
=A:H@G@Y@Y    AB	A@
=@G@GA\  AA\)AAAAzAAAAA}A}A\  AA=qAzBBL
=BGBm(BupBCBCB\B}RBm(BL
=BCB#B*AAB"AAA\)A\)A=qAA\  A}AA=qA:H@GAA@GA@Y@
=@Y@Y    ?=q?=q        ?=q@
=?=q@
=@GAA\  A:HA:HA:HA:HAA:HAA:HA\  A@G@Y@G@
=A?=q?=q?=q@Y@Y    @Y?=q@
=    ?=q@
=@GA:HA@
=@GAA}A:HA=qA\)BA\)AB	AB{BB"B\)B*B{BCBCBL
=BTQBTQBCBTQBL
=B}RBm(BpB\B  B}RB#BupB{B{B  B}RBm(B#B#B#B#BdHBupB\Bm(B333B	AA=qBB
A\)AA}AB;zB*B333BL
=B"B*BB*B;zAB333B333B\)B	B	B"B\)B"A}A\)A=qAA\)A}AAAAAA}AA}AAA\)AB"B{B\)BAA\  A\  AAAA\  AA\  A}AA\)AAA=qBAzAzBB\)A\)A\)AB{B;zB;zB*B\)B\)B"A\)A\)AAzA=qAAAA=qA}A\  A\  A:HA\  A:HA\  A}A:HA\  AA@GA@G@G@G@G@
=@YAA:H@
=@GAAAA@
=@
=@
=A:HAA:HA}A:HA:H@GA@
=@
=A@
=@G@GA\  @G@
=A@GA:HA\  @G@
=@
=AAAA\  A:HA:HA}A:HAA:HAAA:HA:HAAA@GA:H@
=AAAAAA\)AAA}AA}A}A:HA\  A}AAA:HA\  AA}A\  @
=@G@GA:H?=q@Y@G@Y?=q@Y@
=@Y@Y@Y@Y@
=@
=@Y?=q    ?=q@
=?=q?=q@Y@Y?=q@Y    ?=q@Y?=q        ?=q?=q?=q@Y    @Y?=q@G@
=@GA@G@G@G@G@
=@Y@GAAA@YA:HA}A}A:HA:HAAAA}A=qAA\  A:HA:HA}A:HA}A\  A\)AA\)AzA\)AAAA@GAAA=qAA=qA\  AAAA\  AAA\  @Y@
=@
=AA:HA}A\  A:HA}AA:HA:HA@GAA:HAA@
=A}@Y@
=AA\  A\  A@GAAAA:H@GAA:HA\  AA\  AA:HA=qA}A\  A}A}A}AA}A\  A\  A=qA\  AA:HA\  AA}A\  A:HA=qA}A:HA\  AA\  A=qAA=qA=qAAB\)B	BBA\)A\)AA=qA=qAA}AA=qAAAAAAzAAzA=qA=qAA=qA=qAA=qA\)AA=qA=qAAAAA\  A:HA\  AAA:HA:HAAA\  @G@
=A@G@GA\  @GA:H@G@
=@
=@
=A\  @GA@
=AAA:HA:HA:HA:HA:HA\  A:HA\  A:H@GA:H@Y@G@GAAAA@Y@
=@G    ?=q?=q@
=?=q@YA@
=A}AA=qAAA\)AA=qAAA}A=qA=qAA=qAAAA=qAA}A}A}A}A}A\  A}A:HA\  A}A\  A}A}A}A:HA\  A:HAA:HAA\  AA:HAA@
=AAAA\  A:HA:H@GA:HAA:HA@
=A:HAA:HA:H@GA@GA@
=A@G@GAA@GA}A:HA\  AA\  A}A@GAAA:HA}A}AAAB	A=qAAA\  A=qA=qA\)A\)AA\)AA}A\  A\  A}AAAzAzA=qAzBB	B	AzAzB	A\)A\)A\)AAA:HA}A\  A}A\  AAA:H@
=AA:H@G@
=A}A\  A}A}A:HA}A}A\  A}A}AAA\  A:HA\  A}A\  A\  AA\  A\  A}A:HA:HAAA:HA@
=AA:HA\  A:H@GB#@
=@
=A@GA\  A\  AA:HAAA}AA:HA\  A\  A}A}AA:HA}AA\)ABBB\)B{B{B{BBB	B\)B;zB\)B	BAzB	B"B	AB	AA\)A}A}A\)A\  AA=qAAA}A}A}A\  AA:HA\  A:HAA\  A\  A}AA}AA\  A}A:HA:HAA:HA\  A}AA\  A:H@G@GAAA:H@GA:HA\  AAA\  AA\  A\  A@GB*A\  AAA:HA:H@
=?=q?=q?=q    @Y@G?=qAA}A=qAAA}AAB{A\)BB\)B	B{BL
=BL
=B"B\)BB*B\)B\)B\)B*B\)B{B"B\)A\)A\)B	B\)B	AAzA}AA\  A}A\  A}A\  A@
=@
=A\  @Y@
=@Y@
=@G?=q?=q@Y@Y@G@G@
=@G@
=@
=@Y@GAA}A}AA:HA\  AA}A}A\  A\  A\  A:HA\  AAA}A:HA:H@G@Y@G@GA@Y@
=@
=AAA\  A:HA\  A}A\  A:HA}A}A=qA=qA=qAAAA\)AzB{B"B\)B;zB333B\)B	B\)B*B"B;zB;zB333B{B{Bm(BCB*B"AAAAA=qAA}A?=q@Y@Y@YA@G@G@
=?=q        @Y@
=@
=@YAA:HA}A@GA@GA}A:HA=qA\)B{AzB\)AzAzAAA=qA:HA:HA:HA:HA\  AA}AA=qA\  @G@Y@G    @Y?=q    @Y?=qA@YA}@GA}A:H@
=A}AA:HAzAB	B	B\)B\B333BCBL
=BB\)B*B\)B\)B	A\)AA=qA=qAA}A\  A:H@GA@
=?=q?=q@Y@Y@Y?=q    ?=q@Y@YAAAA@Y@GA\  A\  @
=AA:HA\  A\  A\  @GAAAA:HA}A}A=qA}A=q@GAAAAAAA@
=@
=AAA\  A:HAA:HAAAAA?=qA@GA@
=@G@
=AA?=q@
=@
=@G@GAA\  A\  A\  A:HA:HAA}B	B"B;zB*BCBTQB;zB*B\)Bm(B;zB{B"AAzAAA=qA}A\  A:HA:HA:H@G@GA@GA:H@GA@
=@
=@G@G@G@G@GA@
=A:HA:HA\  BB*AzB"B{B{A=qA=qBAA}AAAzA=qBTQB	A:HA}AzAAA=qAA\)AA@GAAAA:HAA@YA\  A\  A\  A\  A\  A}AAAA}AA\)B"B;zB\Bm(Bm(BGBm(BGB  BRB#B  BGBBB)B  BupBdHB*B*B{AA=qAA}AA=qAAA\  A\  A}AAA\  A:HA\  A:HA\  @GAA:HA:HAA}A:HA:HA:H@GA}AAA:HA\  AA:HAAA\)A\)AAAA}A:HA@
=AAA:H@GA:HA}AAA\  @G@GAA\  @G@G@YA\  A\  A}A\  A}A:H@GAA:HA:HAAA@GA:HAAA}A\  A=qABB\)B*B"B\)B	B{BAzAAAzBB	A=qB{BAB	B{AAzB{AA=qAA=qAAAAA:HA\  A}A\  A\  A\  A\  A\  A\  AAAAA=qAAzAAAAzB	B{B{BB	AA\  AAAAAzAAA}AAAA\)A\)AzAAAABAB	AzB	B{B	BBAB"B;zB*B\B;zB\BCB333B\BdHB*B;zBCB;zAAA\)B;zA=qB	AB*B  B	B"A:HA:HA:HAAzA=qAA:HA:HA:H@G@GA:HA:HAAAA:HA}A}A\  A:HA:HAAA\  A}A\  ABA=qAAAAA=qA}A}AA}A\  A:HA:HAA:HAA}AA:HA\  A@G@
=@G@GA:HA:HA:HA:HA\  A}AAA:HAA}A\  A}AAAA=qA\)BAB{B"B"B333BL
=BdHB333BL
=B\B\BTQBTQB}RB\BB;zBpBCB"BTQB*B333B\BCB{B"ABupA=qAAA=qAA}A:HB333A\  A\)AB	B*B\)B	B*B;zAzB"B\)B333BB	ABBB	BBA\)AAA=qAAAAA=qA\)AAAA\)AAAAA=qA=qBGB\)B*AzAAzAA\)B{B333BA\)A=qABA\)B{B{B  BTQBTQBTQBm(BupBm(BdHBL
=BupBpBpBm(B;zB*BupBdHB  B{BpB{B  B  BupB  BTQA=qBRBupBB#B  B	B  BGB)BGB͊=BupB"B;zBCBL
=B333AA=qAA\)A\)AzAAB	B	B{B{B"AzBupB  BCB333B"B"B;zB333B;zBpB\BTQAAAzB*AAA:H@G@
=A\  AA=qAA\  AAB333AzB333A=qAzAB333B"B	B{B"B;zB333BCB}RB;zBdHBm(B  B}RBupBupB;zB333BL
=B*B  B#B\B\B\BdHBTQBCB;zB333BCB;zB\B\BTQBCBTQB;zBCBL
=BL
=BL
=BL
=B333B{BAA\)A@GAA}A:HAA@GA:H@GA:HAA@GAAA@GAA\  AAzB{ABAzB	A\)AA}AABAAB"B\BBdHB333AzAzA:HA}A=qAAzA}A\  B;zBCB\BdHBdHB\BGB}RBm(BTQBTQBdHBCBL
=A\)B"B*B333B333BupB\BupBupBdHBm(BdHBm(Bm(B#BupBdHBm(BCAA=qB"B	BBB"BAzAA=qA=qAA\  AA:HAAA=qA\)AAAAA:H@
=A\  A:HA:HA}AA\  BA\)AAzB	AzB{AA=qA=qAB\)B{B\)B\)B\)BL
=B;zBCBTQAzAA\)A=qA=qA\)A}BBAB\)BTQB  Bm(B#B#BL
=Bm(BupBGB}RBpB)BdHB\B;zBTQB*BL
=BCBm(B;zB\)AAAAAAAAAA=qAA\)AAzA\)A\)AAAAA}A}A\  AA}@
=AAA=qAA}A\  A:HA}AA}AAA=qAA\  A:HAA\  A:HA@G@GA@GA:HAA:H@G@G@
=@G@YA@G@G@GAA}A\  A@GAAAA:H@GA:HA\  AAB{B	BB"B333B  BL
=B;zBCBAzA=qA=qA=qAA\)AAAzAA@
=AA:H@
=@Y@
=A:HA:H@Y?=q@GAA\  A:H@G@
=A:HA:HAA}@Y?=q@Y@Y?=q@Y@
=A\  A\  A\  @
=A@GAA:HAA:HA}A\  A}A}A=qA\)A\  A:H@G@GAA:HAA:H@
=@GAA:HA\  A\  AAA}A:H@
=@Y@GAAA=qAA}A:HA\  A=qA\)A=qAA=qA:HA}AA=qA\)AAzAAAA:HAAA}A}@GA}A\)A=qAAAA=qA}AAABAzAB{AA:HAABA:HAA=qA}A\  AAAA\  AA\  A}A}AA}A\  AAA:HA:HA:HA}A:HA\  A\  A\  A:HAA@
=@
=@G?=qAA\  A:HA:HA}AA\  AAAAA:HA@GA\  A:HAAAA\  @GAA:HAAAAAA\)A\)A\)AAzB	B"B"B;zBCBCB333B333B333B;zBL
=B*BCBTQB;zB*B*B333B"B"B*B333B333BTQB*B	AAB{B*B*B"B	B	BAB{B"AAzA\)A}A=qAAB\)B*B{B333B{B333B*B"B"B	B{B	AA\)AAAAAABBAB	A\  AAA}AAB{B{BAzAAB	B	B*BL
=B;zB;zB\BCBupBm(BTQBTQBdHBTQB"B\)BCB333BL
=BL
=BCB	B	BAAA\)AA\)A=qAA=qA\)BABA\)AAA\  AA@G@
=@Y@GA=q@Y@YA@Y?=qA@Y@Y@YAA:H@GA}A\  A\  A:HA\  A:HA:HA:HAA\  A:HAAAA}A}AA:HA\  A:HA@GA=qA:HAAAAA\  A}AAAAAA}AAAA\)A\)A\)AAAA\)A\)A\)A=qA=qAA=qA=qAAAAAAAAA=qAA=qAAAAAA=qA}A}AA}A}A}A\  A}A\  AA\  A\  A\  A\  @GA:HA:HA\  A:HA:HA:HA@
=AAAA@GA:HA\  A:H@GA:H@G@G?=q@
=A:HA@G@YA@G@Y?=qA@Y@Y@G@
=A@Y@G@
=@G@GAA:H@G@Y    ?=q@
=AAA:HA:H@GA:HA}A\  @Y@G@G@G@Y@
=A@Y@G@G@
=@
=@G@
=@
=@
=@
=@G@G@G@Y@G?=q@Y?=q?=q?=q?=q                ?=q                                        ?=q    @Y@Y@Y    @
=@Y@Y?=q@Y?=q@
=?=q            ?=q        ?=q            ?=q    @Y                                    ?=q@G@
=?=q@Y                                                        @
=A@G@GA}A}A}A=qAAA=qAAA}AAAA\  AA}A:HAA@G@G@GA:H@GAA@GA:H@G@
=AA:H@GA@
=A@G@
=AA:HA@Y@
=@Y@Y@
=A:H@
=?=q@Y    @Y?=q?=q@Y@Y?=q    @Y@Y    @
=@
=@
=@
=?=q?=q?=q@Y?=q        ?=q@Y    @
=?=q@
=?=q    ?=q@
=@Y@Y@
=@GA:H@G@G@
=AA\  AA=qA\)AB	B{B"B;zB*B	B\)BBB\)B	B	AABAAA=qA\  AAAA=qA=qAAAAAAAAAAAAAA}A:HA:HA}A}A\  A:HA}A}@G@
=A\  @
=@G?=q@
=@
=@
=@G@Y@
=@
=    A\  AAAA:HA:HA\  AA:HA:HA@
=AAA\  A@G@G@GA:HA:H@Y@GA@G?=q@
=@Y@GA:HA:HAAAAzAA\)AAA=qAAAA}AAA\)AAAAA}AA\  A}A}A\  A\  A}A\  A:HA:HAA:HA:HA:HAA@G@GAA@GA:H@G@
=@G@
=A:HAA@
=@
=AAA@GA@G@G@GAA@GA@Y@
=@G@G@GAAA:HA\  A:H@G@G@GAAA?=q@
=@
=@
=@
=@Y@Y@G@
=@
=AA:HAA\  A}@G@GA:HA}A=qAAA=qAA}AA=qAA=qAA\  A}A\  A\  A=qAA:HA:HAAAA=qAAAAA}A\  AA}A\  A}A=qA}A\  A\  A\  A\  A}A:HA:HAA:HAA:H@
=A:H@GAA:HAA:HA@GA:H@G@
=A@
=@G?=q@GA@G@
=@
=@G@
=AA@G@
=A:H@GA:HA:HA:HA:HA@
=@GAA}AAAAzAA}AA:HAA:HA}A}AA}A}AAAA\)A\)AAA}AA}A=qAAAAA\  A}A}AAAA\  AA@G@G@G@Y@Y@
=@G@Y@
=?=q@
=@Y@Y?=q@Y?=q?=q@
=@Y?=q@
=?=q?=q@G@Y    ?=q?=q?=q@
=@G@GAA:H@Y@
=A:HA\  A\  A\)A}A:HAAA\  AAAA:HAA\  AAA@Y@
=@G@Y@Y@GAA@
=@
=@G@GA\  A}A\  AAA\)BB	B"B{B{BA=qA=qAAA}A\  AAAAA=qAAA\  AAA}A}A\  A:HA\  A:HA:HA:HAAAA@G@Y@Y@Y@G@Y@
=@YA@GAAA@
=@G@Y@G@Y@Y@
=@
=@G@
=@
=@G@Y@Y@
=AA@GA:HA:H@G@G@
=@GA@
=AA:HA}A}A:H@G@GA@
=A\  A\  A:HAAAAA}AA=qABAA:HAzBAAA=qA\)AAA\)A\  AAABBA=qA=qA=qAA=qA=qA}A}A\  A}A=qAAA\  A:HA}AA:HAAAA=qAAA}A}A\  A:H@GA\  AA}A\  A}AAAA\  A@G@GA:HAA\  A\  AAA\  @G@G@YAA:HA:H@G@G@
=A@
=@YAA:H@GA:HA:HA}AA}AB	A=qAA\)A\)A\)AAzB\)B"AzA\)A=qA\  BBBB\)A}AA}AAA\)ABA=qAzAA\  AA=qA\)AzBBAzABA\)BBTQB{B*B*B"BdHB\)AA\)AzAzAAAAzAzAzAzB	A\)AAA=qAAA}AAAAA}AA\  AA\  AA\  AA:HA\  A}AA\  AAAAAAA=qAA}A=qAAAAA\)AAAAAA}AA=qAA=qA=qA\)AA\)AA=qBB	AzAzA\)A\  A}A\)AA=qA}A\  @
=@G@G@G@GA}@
=A:HAA\  @G?=q@Y@
=@G@
=@GAAAA\  AA:HA:HA\  @GAAA:HA\  A:HA:HA\  A:HA:HAAA\  AA@G@YAAA:HAAA:HAA\  A}A}A}A}A}A\  A}A}AAAAAA=qAAAAzAAA\)B	B	BAzAA}AAAA=qAA=qA}A}AA:HAA}@G@GA@G@GA\  A:HA@GA@
=@
=@G?=q@Y?=q@Y?=q@Y?=q@
=@G@
=@
=@G@
=@G@
=@
=@G@GA@G@
=@
=@G@
=@Y@
=@
=@
=@Y@Y@
=@
=?=q@
=?=q?=q@G@Y?=q@
=@Y@Y@
=A@
=@GAA:H@G@
=@Y@G@
=?=q@Y@Y?=q@G@
=@G@G@Y@
=A:HA:HA:HA}A=qAAA\)AAAA\  A\  A:HA}A\  AAA=qA}A}A:HAA\  AA}AA}A}AA}A}A}AA=qAAAAAAA\  AA@G@G@G@GA\  AAA}A\  A\  A}A\  A:HA:HA:HA@GA:HA@
=A@
=A:H@G@G@
=@
=@
=@
=@GA:H@GA:HA:H@G@G@
=A\  A:HA:HA}A}A\  A:HA\  A:HA=qA=qA=qA\  AAAA=qA\)AzBA=qAAAAAAA}AA=qAzA\)A\)AAzBAAA:HA\  A:HA\  A\  A\  A}A:HA\  A\  AA:HA}A:HA:HA:HAA:HA\  A:HA\  AA\  A\  A\  A\  A}A:HA\  AA}A}AA}A\  AA}A\  A}A}A\  A}A\  A}AA\  A}A\  A\  A\  A:HA}A}A}A:HA}A:HA\  A:HA\  A:HA\  A:HAA\  AA\  A}AAA\  A}A\  A\  A}A}AA}A}A\  A}A\  A}A\  A}A\  A:HA:HA@
=A:H@GAA\  A:HA:HAA:HA:HAA@GA:HA:HA@GA\  A@
=@GA:HA:HA@GA:H@
=@G@G@G@G@G@Y@
=@G@G@Y@
=@G@
=@G@G@G@G@G@
=@G@Y@
=A@Y@Y?=q@Y?=q@G@G@G@G@
=@G@GA@
=@GA@
=@G@GAA:HA:HA\  A\  @GAAAA:HA:HA:HAA\  @GA:HA:HA:HA:HA}A}A\  A}A:HA:HA:HAA:HAAAA@
=AA@
=AAA@G@G@G@
=@G@GA@G@G@
=@Y?=q@G@
=@
=@
=@G?=q@G@
=@
=A@
=@G@
=A@
=@Y@G@G@Y@
=@Y@Y@Y@
=@Y@Y@Y@Y    ?=q?=q?=q@Y@
=?=q@
=@G@Y@Y@Y@G@G@
=A@G@G@G@GAA@G@G@GA@G@GAA:HA:HAAA:H@G@Y@G@G@G@Y@GA@
=@Y@
=@G@
=@
=@G@
=@
=@
=@
=A@
=@G@
=@
=@G@G@G@GA@
=@Y@
=@
=@Y@
=@
=@
=@G@
=?=q@Y@Y@Y?=q@G?=q@Y@Y@Y@Y@
=?=q@Y@
=@Y?=q@
=@Y@G?=q    ?=q@Y        @Y?=q@Y?=q    ?=q?=q    @Y@
=    ?=q@
=@Y@Y@
=@
=@Y@
=@
=@GA\  AA\  A:HA:H@GA:HA:HA\  A:HAA:HAA@GA:H@YA\  AAAAA}A:HA\  A:HA\  AAAAA@GAAA@
=@
=@G@Y@YA@G@G@G@GA@
=@
=@Y@
=@G@
=@G@Y@Y@G@G@Y@Y@Y@
=@
=@
=@G@Y@
=@G@
=@
=@
=?=q@Y@Y@Y        ?=q?=q        ?=q    @Y    ?=q?=q?=q?=q@
=@
=?=q@
=@
=@Y@G@
=@G@G@GAAA}AABB	B"B\)AzABAAAA@G@
=@Y@
=@GA:H@
=@
=@
=AAAAB	A\)B	AA\)A=qA\)AA=qA:HA\  A:HAA\  A}AA:HA:HA\  AA\  @
=@GA@
=@G@
=@GAA@G@G@
=@G@Y@
=@Y@
=@Y@Y@
=@
=@G@
=@
=@Y@G@G@G@
=@Y?=q?=q@
=@Y?=q@Y@
=?=q?=q?=q?=q@Y    ?=q@
=@
=@GAA@G@GAAA\  A}A\  A}A}AAA\  @GAA:HA\  AA\  AA}A}AA\  A\  @GAA:HAAA}AAA:HA}A:HA:HA:HA:HA\  A:HAAA@G@G@
=@G@G@
=@
=@G@
=@
=@Y@G@YA@
=@
=@Y@Y@Y@
=@Y@Y?=q@
=@
=@Y@Y@Y@Y?=q        ?=q                @
=@Y@Y?=q@Y?=q        ?=q    @Y        ?=q    ?=q    @
=@G@
=A:HA:HA\  @GAA@
=@YA:H@G@G@GA@G@G@G@G@
=@G@GA:HA:HA}@
=@
=@
=@
=@Y@
=A@G@
=@
=@
=@Y@Y@Y@Y@Y@Y@Y@Y@Y@
=@
=?=q@Y@G@Y@Y@Y?=q@
=@Y@
=@Y@Y?=q@Y@Y?=q?=q@Y?=q?=q@Y@Y@
=@
=?=q?=q?=q    ?=q?=q                        ?=q    ?=q    ?=q@Y@Y@G@GAA\  A\  A\  A:HA}A:HA\  A:HA}A}AA}A:HA\  A\  AA\  A}@GAA:HAAA:H@
=AA\  AA@GAAA@G@
=@
=@G@Y@G@
=@
=?=q@
=@
=@G@Y@G@
=AA@
=@G@G@
=@
=@Y@
=@G@G@Y@
=@G@Y@Y@G?=q@Y@G@
=@Y@Y?=q?=q?=q@
=@Y@Y    ?=q    @Y?=q?=q    @Y@
=@G@G@Y@
=@Y@G@
=AA\  A:HA:HA\  AA}A\  A\  A\  A\  A\  A}AAA\  AAAA:HA:HAA:H@GA\  A:HA@Y@GA\  A\  A\  A:HA:HA@GA@G@G@Y?=q@
=@Y@
=@Y@
=@Y@Y@Y@Y?=q@
=@Y@Y            @
=@Y                ?=q?=q@Y?=q        ?=q                    @Y?=q@
=@
=@Y    @
=@G@G@Y@Y@
=?=q@Y@Y@Y@G@G@G@Y?=q?=q    ?=q?=q@Y@YA@G@
=A@G@G@
=@Y@G?=q@YA@
=AA\  @
=    ?=q?=q?=q@
=A@G@G@
=@Y@Y@
=A:HA:HA\  AA:H@
=    @
=@
=@Y?=q@Y@Y?=q@
=@Y    @Y?=q        ?=q?=q?=q            ?=q?=q?=q    @Y?=q    ?=q@Y?=q@Y?=q?=q@Y@Y?=q@Y?=q    @Y                                            ?=q@G@Y@Y@GAA:HA}A\  A:HA}AA}A\  AAAA\  A}AA\  A\  A}A=qA=qA}AAA:HA\  @GAAA}AA}A:HA:HA\  A}A\  A}A\  AA:HA\  AA\  A\  A\  AA@GA:H@
=@GAAAAAAAA:HA@Y@
=?=q@G?=q@Y@Y?=q    ?=q@Y?=q@
=@G@
=A:HA:H@GA:H@G@Y@Y@Y?=q@G?=q    @Y?=q@GAA\  A}AAA=qA\  A=qA\)A=qA=qA=qAA=qAAA\  A}A@
=AA:HA}A}A}A:HA@
=@YAA:H@G?=q@Y@Y@G?=q@Y?=q@
=@Y?=q    @
=?=q?=q@Y@
=?=q@Y@Y?=q@Y    ?=q?=q@Y@
=    @Y?=q?=q?=q@Y?=q@Y@Y@Y        @Y?=q?=q?=q        @Y@Y?=q?=q?=q    @
=?=q@Y@Y@Y@Y@Y@
=@G    @YAAAA:HA:HA:HA:HA:H@
=A@Y@
=@GAA\  A:HA}AAA@
=@Y@YAB"AA}AA=qAA=qA}A}AAAA}AAA=qA}A}@GA:HA:HAAA\  A:HA\  A\  A:HAA:HA@
=@GA:HAAA:H@GA\  AAA@G@G@YA@
=A@
=@
=@
=@G@G@
=?=q@G@G@
=@
=?=q?=q?=q@Y@Y@Y?=q?=q?=q            ?=q                                    @Y@Y@
=@Y@GA@G@GA\  A}A}A\  A}A\  A:HAA}A:HAA:HAAA:HA\  AAA}AA=qA:HA\  A@
=AAAAA@G@G@G@G@GA:HA:HA:HA\  AA@GA:HA:H@G@GA:HAA@G@G@
=?=q    @
=AAAA:HA:H@GA}AA:HAAA:HA:HA?=q?=q?=q@Y?=q@
=?=q?=q?=q?=q@Y@
=@Y?=q@G@
=AA:HAAAAAA\  AAA:HAA\  A}A}AAA=qA}AAAAAAB{A\)AA\)A=qAA}A=qAAAA=qAAA\  AAAAA=qA=qAA=qAAA=qAA=qA:HAA}AA=qA=qAAAA=qAA=qA=qA=qA=qAA}A\  A\  AA}A:HA}A}A}A\  A:HA\  A:HA:HA:HA:HA}A\  A:H@G?=q?=q@Y@
=@Y@
=@GAAA\  A\  A\)B	BB333B	B"B"BBB{B\)B"B{BAzBB*B	B*B	B\)B{B\)B	BAzA\)AABAzB{B	BBA=qAA=qAA=qA\)AA\)AA=qA=qA=qA=qA}A\  A\  A}A}A}A}AAAA}A}AA}A}AA}A}A\  AA:HA}A\  A\  AA}A:HA\  A}A\  A\  A}A}A}A:HA:HA\  A:HAA:HA}A}A\  A}AAA=qAzAAzBBA\)B"B333BTQBCBTQBL
=B*B\)B"B{BAzAzBAzAA=qAAA\  A}A\  A\  A}@G@
=A@
=A:HA:HA@G@G@Y@GAA:HA:HA:H@
=@G@G@GAA\  A@G@YA@G@G@GA:H@
=@
=@Y@
=@
=A@
=@G@G@
=AA:H?=q@G@G@G@G@G@G@Y@YA@G@GAA}AAAA}AA=qA=qA=qAA:HA:HAAAA\)AzB{BAzB	BAA\)AAAAA\  A}AA\  A}AA}A\  AA}A:H@
=@G@GA:HA}A@Y@
=@
=AA@G@
=A:H@GA@G@G@Y@
=@Y@
=?=q@Y@Y?=q?=q@
=@Y?=q@Y@
=@
=@
=?=q@Y@Y?=q?=q@Y@
=        ?=q?=q    @Y@Y?=q@Y@G@Y@G?=q    ?=q@Y@Y@
=@
=@
=@
=@Y@Y?=q@GA\  A\  AA}A=qAAAB	AAzB\)B	B	BA\)AA=qAA:HA:HA\  AAAA}A}A\  A\  A:HA}AA\  @GA@G@
=@GAA:HA:HA\  @GAA\  A@GAA:H@
=@GA\  A@
=@G@Y@Y@Y?=q?=q@Y@Y@Y@Y?=q@Y?=q@Y@YA:H@G@
=@G@G@
=@
=@GAA:H@GAA}A\  A@
=@G@G@
=@G@GA@GAAA\  A\  A:HA\  AAA\  A}A\  A:HAAAAAAA}A:HA:HA@GAA@G@
=@G@Y@
=@
=@G@G@G@GA:H@YA:H@G@GA@G@GA@G@
=AAA@GA@G@
=@
=A@GA:H@G@GA\  @GAA\  A}AA@Y@G@G@
=@
=A@YA@
=@
=@G@G?=qA:H@GAAA:HAA\  AAAAA}A}A\  A@G@GA:HA\  A\  A}A}AA\  AA=qAA\  A}A:HA}AAAAA}AAAAAAA=qAAAA\  AA:HA:HA@GAA@GA:H@GAA:HA\  A@GA@YA:HA:H@
=@G@
=@G@G@G@G@
=@
=@G@
=@G@
=@Y@
=@
=@G@
=@G@G@G@G@
=@G@
=A@
=A@
=@GAAA}A:HA:HA\  A:HA\  A\  A}A:HAA\  A}A\  A:H@G@
=@G@G@G@
=@
=A@GAA\  AA@GAAA}AAAAAA=qAAA=qAA}@G@
=A:HA:HA}A}A}AA:HA:HA:HA:HA@
=@Y@G?=q@Y@Y        @Y?=q@GAA@GAA@G@GA:H@
=@GA:HAAA:HA:HA:HA\  A\  AA\  A:HA\  @
=A@Y@G?=q@G@G@
=@Y@G@
=@Y?=q@Y@Y?=q?=q@
=?=q    ?=q@Y@Y    @Y@Y?=q@Y@Y@
=@Y@Y@G@Y@
=A:HA}A\  AA\)A\)AA=qAA\)A=qA}AAA}A:HA@GA@G@G@GA@G@
=AA@GA@
=@
=@
=@GA@
=@Y@Y@
=@
=@G@
=@G?=q@
=?=q?=q@G    ?=q    @Y?=q@
=@
=@Y@
=@G@
=@G@G@GAA:HA\  A:HAA:H@GA}AA@G    @G@G@
=@Y@G@
=@Y@G@G@
=@
=@G@
=?=q?=q@Y?=q@
=?=q@Y@
=A@
=AA:HA:HA\  A\  A:HA:HAAAAAA:HA:HA\  AA}A}A\  AA:HA\  A}A\  A\  A:HA\  A:HA:H@GAA\  A\  A:HA}A:HA\  AA:HA\  A\  A\  A\  A\  A:H@Y@
=@
=@G@Y@Y    @Y@Y@Y@Y@Y@
=@Y?=q@
=@Y?=q    @Y@Y@
=    @
=@Y@
=@Y@Y@Y@Y@
=@Y@
=@Y?=q@Y@Y    ?=q@
=@Y@Y@Y@
=@G@GA:HAA\  AA\  A\  AA}A:HA\  A}AAAA}A\  @Y@
=AA\  @
=@
=A\  @G@GA:H@G@
=@
=@Y@
=@
=@Y@
=    @Y@
=?=q?=q?=q@Y?=q@Y@Y@
=@Y@Y@
=?=q@
=?=q@Y@G@
=@Y?=q@Y?=q        ?=q        @
=@Y?=q@Y?=q@Y?=q?=q@Y?=q?=q@YA@
=@Y@
=@Y    @
=@Y?=q@Y    @Y        ?=q@Y@G@
=A\  A:HA@G@
=AA@GA\  A\  A}A}A}A}A:HA:HA:HA:HAA:HA@GA:HAA:HA}A\  A\  A:HA:H@G@G@GA:HA:H@G@GA@G@Y@
=@
=@G@
=?=q@Y?=q?=q        @Y    ?=q?=q    ?=q            ?=q@Y?=q        ?=q    ?=q?=q@Y?=q?=q?=q?=q    ?=q?=q?=q    @Y        ?=q?=q@Y@Y?=q@Y?=q?=q@Y        ?=q?=q?=q    @Y?=q@
=A\  A\  A:HA\  @GA@GAAAA:HA@
=@
=@GAA:HA}A}AA:HA\  A}AA@YAA:HA:HA:HA}A:H@
=@
=@Y@Y@G@G@G@
=@
=@G@Y?=q@
=@G@
=@Y@Y@Y@
=@
=@
=@G?=q@Y?=q@G@
=@Y@Y@Y?=q?=q?=q    ?=q    ?=q?=q            @Y    @Y?=q@Y@
=@Y@Y?=q@Y?=q@Y?=q@Y@Y?=q@
=@Y@Y@Y@
=@
=@
=@
=    @YA@
=@G@G@
=@
=@G@G@G@
=@Y@YAAAA:HA:H@
=@GA@G@G@G@Y@G@GA:HA\  AA:H@
=@
=@
=@Y?=q@Y?=q@Y@Y@G@
=@
=?=q@Y@Y@
=@G@
=@
=@
=@
=?=q@Y?=q@Y?=q?=q?=q@Y?=q?=q?=q@Y    @Y@Y@
=?=q    ?=q@
=@Y?=q?=q@G@Y@
=@
=@G@Y@Y@Y@Y@Y@Y?=q@Y@
=?=q?=q@Y@
=?=q?=q?=q    @Y?=q?=q?=q@
=?=q@YA@Y@Y    ?=q@Y?=q@
=@Y?=q@Y@
=?=q@Y?=q@Y?=q?=q?=q@
=?=q?=q?=q    @
=@
=?=q?=q?=q    ?=q@
=?=q?=q?=q    ?=q?=q@Y    @Y?=q?=q?=q        @Y?=q?=q?=q        ?=q?=q    ?=q?=q    @Y                        @Y@Y@Y?=q                        @
=?=q    ?=q            ?=q    ?=q    @
=@Y    @
=?=q@
=@Y?=q@
=@GA@G@Y@Y@YA@
=@G@
=@G?=q?=q@Y@
=?=q@Y@Y@Y@Y@Y@Y?=q@
=    ?=q?=q@
=@Y@Y@Y@Y?=q@Y?=q?=q@Y?=q    ?=q?=q                @Y?=q?=q@Y?=q?=q@Y    ?=q?=q?=q?=q?=q?=q?=q    ?=q    ?=q    ?=q@Y?=q?=q@Y    @
=@
=@Y            @Y@Y    ?=q?=q@
=@G@Y@Y@
=@Y@Y@Y@
=@Y@
=@YA\  A}A\  @GA\  A:HA\  AAA\  A:HAA:HAA:H@G@GAA\  A:HA@GA@Y@G@G@G@
=@Y@
=@Y?=q@
=@Y@Y@G@
=@
=@Y@Y@Y@G@Y@Y@G@
=@Y@Y@Y@Y@Y    ?=q?=q@Y@Y?=q@
=?=q@Y            ?=q        @Y@Y?=q@
=@Y?=q?=q@Y?=q?=q@Y@
=?=q@Y@Y@
=@Y?=q@
=@
=@G@Y@Y@
=@
=@
=@
=AAAAA:H@
=A\  A@GAA\  AA\  AA:HA:HA\  A:HAA\  @
=@G@G@
=@
=@Y@Y?=q@
=AA}A@G@G@G@Y@Y@
=@Y@Y@G@
=@G@
=@
=@G@Y@Y@Y@
=@G@Y@
=@Y@Y?=q@Y@Y?=q        ?=q@Y@Y    ?=q?=q?=q@Y@Y@Y@
=@
=AA\  @G@
=@
=A@G@GA:HA}A@GA:H@GA\  @G@GAA:H@GA:HAA\  A}@GA\  A:HA\  @GA:HA:HA\  @G@
=AA@
=@
=@Y    @Y?=q@
=@
=@Y@Y@
=    @Y@Y@Y@Y@G@YA@Y@Y?=q@G@G@G@
=A@Y@
=@YA}@G@
=@
=@Y@
=?=q?=q@Y@Y@Y@Y?=q        ?=q@Y    @Y                        ?=q        @Y    @Y@Y?=q    @Y    @Y@Y@Y?=q                    ?=qAAA:HA:HA}A@GA@GA@
=@G@Y@
=A@G@
=@Y@
=?=q@Y@G@Y@Y@
=@
=@Y@
=        ?=q        @
=?=q?=q?=q@Y    @Y    @Y?=q?=q?=qA@
=?=q@Y@
=@G@
=@G@
=@
=@Y?=q?=q@Y?=q?=q    ?=q    @Y?=q    ?=q?=q?=q?=q        ?=q    ?=q    ?=q@Y@Y@Y?=q?=q?=q@Y@
=    @Y@G@Y@GA:HA\  A:HA\  @G@
=AA=qA}AAAAA}A:HA:HA\  AA:HA:HA:HA:HA@GA:HA:HAA\  AA}@GA\  AA@GA\  @
=A:HA:HA:HA@
=A@G            ?=q    ?=q        ?=q@Y@Y@Y?=q@
=@G@
=@Y@Y@Y@Y@Y@
=@GA@Y?=q?=q@Y@
=@G@G@Y@Y?=q?=q@Y?=q?=q@
=@
=@Y@Y@
=?=q@Y@Y@
=?=q?=q@
=@
=@G@Y@
=@
=@GA:H@Y@
=A@GA:HA}A}AAA=qA}A\  A\  A\  A:HA\  A}A\  AA:HA:H@GA@G@G@G@G@G@G@G@
=@Y?=q@Y@Y@Y@
=@G@
=@
=@G@
=@G@
=@Y@G@G@
=@
=@GA@
=@
=?=q@
=@
=@Y@Y@
=@Y@Y@
=@G@
=@
=@Y@Y@Y@
=@Y@Y?=q?=q@G@
=@Y@Y@Y@Y?=q@Y?=q?=q?=q?=q    @Y@Y?=q@Y    @Y    ?=q?=q    @Y?=q@Y@Y?=q@Y@
=@G@Y@YAA:HA:HA:HA\  A\  A:HA\  A:HAAA\  A}AA\  A}A:HA\  A\  AA@G@GAA}A\  A=qAA:HA}A@G@G@
=A@GA@
=A:H@G@G@
=@GA:H@YA@
=@G@GA@
=@G@Y@
=@G@G@
=@G@Y?=q@Y?=q@Y@Y@Y@Y@
=@
=?=q@G@Y?=q    @Y@Y@Y@Y@Y                                                        ?=qA@
=@
=AA:HAA\  A@GAA@
=AA@GA@
=AA\  A\  A:HA\  A\  A:HA\  A:HA:HA@GA@
=A:HA:HAA\  AA:H@G@G@YA:HA@G@Y@Y@Y?=q@
=@
=@G@
=@G@Y?=q@Y@Y@Y?=q    @Y?=q@
=@Y?=q?=q    @Y@Y?=q?=q    ?=q@Y@
=?=q?=q                        ?=q        ?=q                            ?=q@Y@Y@Y@G@
=@
=@G@G@GA\  AA:HA\  A\  A:HA\  @
=@
=@GA@G@GAA@GA\  A\  @GA:H@G@G@G@G@
=@
=@G@Y?=q@
=@
=@
=@G@Y@
=@Y@G@
=?=q@
=@
=@Y@G@
=A?=q?=q@Y@
=@
=?=q@Y@Y    ?=q?=q@Y    ?=q    ?=q@Y@Y@Y@Y?=q    ?=q?=q            @
=    ?=q    ?=q?=q    ?=q    ?=q?=q?=q    @Y@Y?=q@
=@GAAAAAAAA}A:H@GA:HAAAA@GAA\  AA:HAAA:HA\  @GA@G@G@G@
=@Y@Y@Y    @
=@G@
=@
=?=q@Y@Y    @Y?=q@
=@Y?=q@Y        ?=q?=q@Y        @Y?=q            @Y?=q    ?=q?=q    @Y?=q@Y@
=@
=@Y@Y@Y                                                            ?=q?=q?=q?=q?=q@Y@Y@Y@Y@
=@
=A:H?=q@G@G@G@G@Y@
=@
=@GAA@
=A:HAA\  A}@
=A:HA@
=    ?=q?=q?=q    ?=q            ?=q@Y@Y?=q?=q@Y    @Y@Y?=q@Y@Y        ?=q        @Y                                ?=q                                                                                                            ?=q?=q@
=@Y    ?=q@Y@G@G@
=?=q@Y@G@Y@Y?=qA?=q?=q    ?=q?=q@
=@Y?=q    ?=q        ?=q    @Y?=q?=q                ?=q?=q    ?=q    ?=q@Y?=q    ?=q                                ?=q    @Y?=q                        ?=q                        ?=q?=q@Y?=q?=q?=q@Y?=q@Y@
=@Y@
=@Y@Y@Y@Y@
=@Y?=q?=q            ?=q?=q?=q?=q@G@Y@
=@Y@Y@
=@G@
=@
=@G@
=@G@G@G@G@G@G@G@G@G@
=@G@
=@
=@G@
=@G@
=@Y@Y@Y?=q@Y?=q@Y@Y            ?=q?=q?=q        @Y@Y?=q?=q?=q                        ?=q?=q        ?=q?=q?=q@Y    ?=q                ?=q    ?=q                                                ?=q            ?=q            ?=q@G?=q?=q@Y@
=@
=@
=@GAAAAAA:HAAAA:HA:HA\  A\  @GA\  @G@G@G@G@G@GA@GA@
=@
=@
=@G@G@G@G@
=@
=@
=@
=@
=@
=@Y@
=@Y@Y?=q@
=@Y@Y@
=@Y@Y?=q@Y?=q@
=@Y@Y@Y?=q?=q    ?=q?=q?=q?=q    ?=q    ?=q?=q?=q?=q    ?=q@Y@Y    ?=q        @Y        ?=q                        ?=q?=q    @Y@Y@Y@Y@
=?=q@Y@
=A@
=A:H@G@
=A@
=A@G@
=A@
=AA:HAA@G@GAAA@
=@G@G@
=@
=@
=@Y@Y@
=@G@
=@
=@Y@Y?=q@Y@
=?=q@Y?=q@Y@Y@
=@
=@Y@G@Y@
=@Y?=q    ?=q?=q@Y?=q@Y?=q    @Y    ?=q@Y?=q    @Y@Y@Y@
=@
=?=q?=q@Y@Y?=qA:H@G@Y?=q        @
=?=q@Y@
=@G@
=@
=@Y@G@G@GAA:HA\  AA}A}AAAA}A}A\  A\  A}A}A}A:HA:HA:HA\  A:HA:HAA:HA@G@GA:HA@Y@
=@
=@
=@G@G@GA@G@Y@
=?=q@Y@
=?=q@
=@
=@Y?=q?=q@
=@Y@
=@
=@Y@Y@
=@
=@Y@G@
=@Y                                    ?=q?=q?=q@
=    @
=?=q@
=?=q                                        ?=q@
=@Y@Y@
=A@
=AA:HA}A:HA:HA\  A:HA:HA:HAAA@GA\  A\  A:HAA:H@
=A@GA@GA@G@
=@
=@G@
=@G@
=@G@G@G@
=A@
=@
=@Y?=q?=q?=q@Y    ?=q        @Y    ?=q@Y?=q    @Y    @Y?=q?=q@Y@Y?=q?=q?=q@Y@Y@Y?=q?=q?=q?=q@Y?=q        @Y@Y@Y    ?=q    ?=q@Y    ?=q?=q    ?=q?=q    @Y?=q@Y?=q@
=@YAA@
=?=q@GAA@Y?=q@
=@
=@Y@
=@G?=q@Y@Y@Y@
=@GA@
=@
=?=q?=q@Y@
=?=q@
=@
=@Y        ?=q@Y@Y?=q?=q@Y@
=    ?=q?=q@
=?=q@Y@Y?=q@Y?=q?=q@Y@Y?=q@Y?=q@Y?=q@G?=q        @Y?=q?=q@Y?=q?=q?=q@
=    @
=@
=@
=A@
=A:H@G@
=@YA:H?=q@
=@Y?=q?=q?=q    ?=q                        ?=q?=q?=q@G@G@
=A@GA:HAA\  @GA:HA:H@GA:HA\  A\  A:HA:HA\  AAAA:HA\  A:HAAA:H@GA:HAA@
=A:HA@G@G@G@Y@G@Y@G@Y@
=@Y@Y?=q@Y@Y?=q@
=@
=@
=?=q@Y@
=@
=@
=?=q@G@Y@
=@G@G@
=@Y@
=@G@
=A:H@G@G@GA:HA}A:H@Y    @
=@Y@Y?=q?=q    ?=q    ?=q                                        ?=q        ?=q?=q    @
=@G@
=@G@Y?=q@Y@
=@
=@
=@
=@
=@
=@
=@Y@
=@Y@G@
=@G@Y@
=@Y?=q@G@
=@G@Y?=q@Y@Y@
=?=q    @Y?=q        @Y@
=    ?=q@Y    ?=q?=q    ?=q?=q?=q?=q@Y@
=@
=@Y@
=@G@Y@Y    @Y?=q@GA\  @
=@G@Y        ?=q    ?=q?=q                                ?=q                    ?=q        @Y?=q@G@
=@
=@G@
=@Y@
=A@
=A@GAA@
=@
=@GA@G@GAA@G@Y@
=@Y@G?=q                ?=q?=q    ?=q?=q        ?=q    ?=q                                ?=q            ?=q?=q                            ?=q    ?=q    ?=q                            @Y    ?=q    ?=q                ?=q            ?=q    @Y    ?=q    ?=q?=q@Y@Y@Y@Y?=q@G@G@G@
=@
=@Y@
=@
=@G@G@Y@YA@
=@
=@
=@
=@Y?=q@
=?=q?=q?=q    @Y            ?=q                @Y                ?=q@Y?=q?=qA?=q    ?=q    ?=q?=q?=q?=q?=q@Y@Y@Y@
=@
=@Y@Y    @Y@G@Y@Y?=q@Y@
=@Y@
=@
=@Y@
=@Y@GAA@G@
=@Y@Y@G@GA@GA@GAA:HA:HA\  @Y@G@
=@Y@Y@
=@Y@Y@Y?=q@
=?=q?=q?=q?=q?=q                            ?=q        @Y    ?=q            ?=q    @Y    ?=q?=q        ?=q                                                                                            ?=q                @Y@Y@G@
=?=q                                ?=q@Y?=q@Y    ?=q        ?=q?=q?=q?=q    ?=q    ?=q?=q        @Y@Y@Y@Y?=q    ?=q                        ?=q@Y@Y@Y?=q    ?=q    ?=q?=q?=q@Y?=q    ?=q    ?=q    @Y?=q?=q@Y?=q    ?=q?=q        ?=q                                                                            @Y@Y?=q?=qA?=q@Y?=q@Y    @Y                    ?=q@Y@Y    @Y?=q@Y?=q@
=@GA:H@Y@
=@
=AA?=q@Y@Y@Y@Y?=q@
=    A@Y@Y@
=    @Y                                            @Y    @Y@Y        @
=?=q@
=@Y@
=?=q@
=    @
=            ?=q@Y@G@Y?=q@Y@Y@Y?=q    @Y?=q?=q@
=    ?=q?=q?=q@
=?=q?=q@GA@
=@
=@Y    ?=q?=q?=q    ?=q                                                            ?=q        ?=q@Y@Y?=q?=q@Y?=q@YA@G@Y@
=?=q@
=@
=AAAA@G@GAA}A?=q@GA:HA@GAA:HA@G?=q        A@
=@
=A:HA@
=@
=@G?=q@Y@
=@
=@
=@Y@Y@
=@YAA@G@
=@Y@Y?=q@G@
=AA:H@Y@GA@
=@GAAA\  A\  A}AA}@G?=qAA\  @G@
=@Y@Y                @Y    ?=q        ?=q    @Y@Y@G@GAA:HAA:HA:HA:HA\  A@GA@GA:HA}A:HA\  A}A:HA}A:HAA@G@GAA:HA@GAA:HA:HA:HA\  AAAAAA\  @G@GAA:H@GA@G@
=@G@G@
=@
=@Y@Y@
=@
=@Y@
=@Y@
=@
=@
=@
=@Y@
=?=q@Y@
=@Y@Y?=q@Y@Y?=q@Y@G@
=@Y?=q?=q    ?=q?=q    ?=q@Y?=q@Y?=q@
=@Y@
=@G@
=A@G@
=@GAA:HA:HAAAA}A}A}A@GA:HA\  AAAAAA}A}AAAA}A}A\  A}A}A}A:HA\  A:HA\  A:HA\  A\  A:HA\  AA:HAA:HAA:HAA:H@G@G@
=@G@
=@
=@
=@
=@
=@Y@Y@Y?=q@
=@Y@Y?=q    ?=q@Y@
=    ?=q?=q@Y@Y        ?=q    ?=q            ?=q                                ?=q?=q@
=A?=q@Y@
=@Y@
=@GAA:H@G@Y@Y@Y@Y    @Y@
=@
=@Y?=q@Y@Y@Y@Y@G@
=@
=?=q    ?=q@Y?=q?=q    @Y@Y                @Y    ?=q    ?=q                                        ?=q    @Y?=q@
=@G@G@G@Y@GA@G@Y@
=@
=@Y?=q@Y@Y@Y    @Y                                                                            ?=q            @Y@
=?=q    @
=?=q    ?=q    ?=q        ?=q                    @Y?=q@Y@Y?=q?=q        ?=q@
=                ?=q                ?=q        ?=q                                                                                                    ?=q        ?=q    @Y                                                                        A
{A\)A	AGA
\A33A
{A	A	pA(A=qAHARAG@GA\@@@@\)@@{@H@G@{@ff@G@G@ۅ@  @@Q@@ff@@(@(@p@@@  @=q@\)@{@(@H@=q@@@@@{@33@  @{@Q@@ٙ@
=@@@ڏ\@ۅ@H@ڏ\@
@ff@@(@@p@
@أ@ҏ\@  @
=@33@@@z@
@ff@(@@@p@\@=q@33@ƸR@Ǯ@  @@=q@  @{@ָR@33@\)@ҏ\@Ӆ@@Ӆ@\)@ə@У@\@Q@@ȣ@Q@˅@Ǯ@=q@Ǯ@ȣ@ƸR@{@R@@\)@@
=@{@@33@
@@@
@z@@Å@@@H@H@@ff@p@ff@p@(@(@@G@@{@@ff@
=@H@@@33@
=@@Å@H@33@@@R@{@p@p@\)@\)@  @{@=q@ə@\)@
=@@@R@@\@@@@  @@@  @Q@@=q@{@z@
=@Q@=q@@@
=@@  @@z@@
@=q@˅@
@(@H@ʏ\@˅@
@@  @Ϯ@θR@@@z@θR@ff@ff@@θR@p@@(@(@(@z@(@
@H@ʏ\@ʏ\@Q@Å@@ȣ@@@@G@\)@=q@@@G@У@G@љ@@@@ʏ\@@Ǯ@33@{@@R@{@=q@H@@z@@ff@p@Ǯ@H@ȣ@  @ȣ@=q@=q@@@
@
=@p@\)@ʏ\@@@ə@ȣ@
@z@@{@@H@Ӆ@z@ff@  @H@У@33@{@@=q@Q@@ff@@{@љ@љ@H@{@@
=@@{@ff@H@=q@@ʏ\@
=@@{@@\)@
@@
=@׮@@
=@
=@@ٙ@=q@z@@ff@@@ff@{@{@ff@޸R@
=@޸R@
=@@
=@
@\)@p@z@޸R@ᙚ@@Q@@\@޸R@\)@ff@޸R@\)@@@(@@{@@
@
@\)@@=q@33@
@p@@p@ff@p@ff@ff@p@(@z@@H@@@{@@  @  @ff@@@@@H@R@(@@@@p@ٙ@{@33@
=@H@(@  @Q@@@G@
=@G@@Q@@=q@\@H@ᙚ@@z@=q@  @
@@z@@
@׮@ff@33@G@ff@@ff@{@  @\)@H@޸R@
@ۅ@\)@@Q@ff@
=@@33@׮@׮@@=q@z@z@{@@߮@Q@p@@ᙚ@Q@33@  @R@  @  @G@H@
@@R@Q@G@@(@\@@z@
@@@{@G@
=@@33@@\)@G@@@{@@@@@Q@33@H@
@\@@G@z@(@H@޸R@p@H@ٙ@G@
@@ff@
@Q@H@\@@޸R@@ٙ@=q@@33@  @@˅@G@߮@
@=q@޸R@(@أ@@@=q@{@=q@ڏ\@G@ڏ\@@=q@޸R@ff@޸R@G@@ۅ@33@@@ff@޸R@G@@@p@@  @@@33@@(@(@@p@
=@R@@(@@{@
=@  @@@(@H@Q@@33@
@
@@33@@  @\@
=@G@@@@G@
=@@@G@G@\)@  @@Q@@Q@
=@\)@
=@R@
=@\@@@\@\@H@33@33@=q@@(@陚@@
=@ff@ff@33@G@H@
=@{@@@
=@\)@Q@
=@H@=q@陚@@(@@@=q@=q@@@
=@@@@ff@@@@Q@Q@  @@(@@p@
@@R@@z@z@=q@@@{@@ff@(@@\@\)@=q@H@@H@Q@G@@
@z@z@(@@@z@z@@@H@H@(@H@33@
@=q@@@@H@@@@@  @@z@33@\@=q@  @{@
=@Q@G@@R@@p@
@=q@=q@R@=q@@@
@{@H@@{@@33@@33@{@@R@
=@\)@@H@@z@@{A QA ApARA=qA
=AAAAA
AAAGARA@@H@@@G@z@G@33@R@@\A   @R@\)AHA{AA\)AHAzA
HA	AAA
A	GA
=@{@{@\)@H@@\@@{@
@=q@@@p@@=q@G@@
=@@H@G@z@@\)@@(@@Q@@
=@
=@@@Q@޸R@@H@ۅ@  @Q@=q@@@@@@p@\)@
=@@33@33@@@  @@(@\)AH@ff@@@z@{@(@pA AA  AApAA{@\)@@Q@@G@z@@@ᙚ@p@Q@߮@ff@=q@G@
=@\)@p@
@=q@{@33@@ָR@z@ff@أ@ڏ\@z@@{@  @@@z@z@p@ٙ@
@
@(@H@z@ٙ@@\)@@Ϯ@У@@θR@p@G@ff@
@p@Q@p@z@Ϯ@33@@߮@ᙚ@G@@@ff@(@G@@H@G@33@
@{A A\A
=AApA	pAQA
A
AAAAAAGAA\)ARA
=AA(A  AGAzA  A(AQAp@AG@\@@33@G@@@
=@@
@H@
@@Q@=q@z@G@p@@@@@33@@z@@
@@@\@Q@G@H@33@@
@ٙ@33@˅@@@z@
=@Q@أ@33@z@p@޸R@\)@  @\@=q@@  @@H@(@\@陚@R@ff@ff@@p@(@33@ᙚ@  @@@޸R@z@p@@p@  @@@
@޸R@ۅ@@{@{@\)@  @G@ڏ\@=q@@ڏ\@ff@{@߮@@G@  @G@G@\)@\)@
@׮@ָR@
@z@@z@ڏ\@@ۅ@H@ۅ@ۅ@=q@=q@ٙ@G@Q@Q@Q@׮@
=@
@p@(@љ@  @ff@Ϯ@
=@Q@\)@{@θR@Ϯ@H@˅@=q@
@ff@{@
=@˅@@33@
@ff@\)@ff@@@(@@G@׮@
=@{@ҏ\@@G@G@љ@=q@z@ָR@\)@z@z@{@{@ָR@׮@G@G@  @p@ڏ\@Q@G@\)@\)@@z@{@ҏ\@
@Ӆ@@p@33@p@(@z@(@@@z@(@@
@33@G@=q@G@p@@
=@Q@\)@@G@ə@ȣ@˅@{@
=@˅@@p@
=@@@У@G@=q@У@Ϯ@Q@\)@{@Ϯ@@@
@ə@ə@@@{@ə@{@@(@33@@Ϯ@=q@=q@p@أ@ٙ@Q@ָR@ָR@ָR@(@z@z@
@Ӆ@@ff@Q@{@ff@ff@{@{@׮@أ@أ@Q@Q@@ָR@ff@@@\)@
=@\)@
=@{@ff@Ӆ@G@  @H@=q@@z@z@(@H@ҏ\@@Q@  @Ϯ@\)@ff@z@ff@
=@θR@Ϯ@@p@@p@@θR@ff@  @@\)@  @=q@@@@
@\)@@@ff@ə@Q@@@@
@@@@@@{@
=@@Q@ff@p@  @\)@θR@љ@H@(@
@Q@ff@أ@أ@@=q@H@ۅ@(@z@@@p@޸R@
=@
=@߮@
=@{@ff@ff@ff@@{@ff@\)@\)@\)@p@p@޸R@@@33@33@33@=q@G@=q@أ@Q@׮@׮@@\)@{@ָR@\)@ff@@ָR@p@
=@\)@@@
@љ@@p@z@@z@љ@33@(@
@33@@
@@\)@
@ff@\)@G@  @@G@@
=@G@G@  @@@@ڏ\@׮@H@H@G@ᙚ@=q@=q@=q@@@ᙚ@G@G@@ᙚ@  @߮@@߮@=q@@H@
@
@(@@z@z@@(@z@
@z@@@(@@Q@@@@H@ᙚ@G@(@G@Q@޸R@@z@ڏ\@ۅ@@=q@
@ٙ@H@@ڏ\@G@=q@z@=q@(@33@ڏ\@z@@أ@@
=@  @@  @ָR@@@=q@Ӆ@@ҏ\@ə@˅@  @G@@
@z@
@G@ʏ\@\)@љ@Ϯ@
=@@@G@@׮@=q@
@p@߮@@G@G@G@G@@Q@޸R@
=@{@߮@߮@߮@  @=q@
@@H@@@33@Q@@߮@޸R@G@=q@@
=@{@{@(@ۅ@ۅ@
@H@G@أ@ڏ\@(@ۅ@
@=q@ڏ\@أ@أ@ڏ\@H@ۅ@G@@=q@ڏ\@@ڏ\@@=q@=q@@׮@\)@Q@  @H@33@33@@G@@љ@@H@@{@G@׮@ָR@@ڏ\@@ڏ\@G@H@@{@{@G@׮@G@θR@ff@ۅ@H@33@@ٙ@
@z@
@(@z@@@p@ff@{@ff@ff@޸R@
=@ff@\)@ff@\)@\)@
=@
=@\)@  @Q@G@G@G@G@@  @@@  @
=@\)@{@ff@33@@=q@G@=q@ڏ\@@33@ڏ\@=q@ۅ@
@z@@ۅ@p@@ۅ@33@p@@ff@  @Ӆ@(@ҏ\@G@\)@H@
@(@ҏ\@(@Ӆ@(@33@ָR@(@Ӆ@33@
@Ӆ@H@@Ӆ@z@@@ҏ\@=q@@@
@G@
@
@{@@ۅ@
@
@
@33@
@
@
@z@p@@@p@{@{@{@@
=@ff@޸R@{@@@p@p@p@@޸R@{@@p@p@@@@ۅ@
@z@@@z@
@H@ۅ@33@ۅ@@33@@33@
@33@ۅ@ڏ\@H@ۅ@ۅ@ڏ\@أ@=q@ڏ\@@ڏ\@H@H@ڏ\@ڏ\@ڏ\@@Q@ٙ@
=@@θR@Q@Ϯ@=q@z@=q@\)@@ۅ@ۅ@33@33@(@(@@p@@Q@ָR@ָR@@=q@33@@@ff@@@ff@߮@
=@\)@\)@\)@Q@p@ff@@p@@@{@@G@@
@H@@\@H@\@@G@@ᙚ@@@@@  @߮@{@޸R@߮@\)@{@@
=@
=@@@@@(@޸R@{@@
=@߮@  @@޸R@@z@@ۅ@ۅ@H@=q@H@33@=q@ڏ\@@@@=q@@ٙ@ڏ\@H@
@G@(@@p@@޸R@ff@\)@
@33@G@G@p@p@Ӆ@=q@ۅ@{@ff@G@@@  @\)@ff@޸R@ff@߮@Q@  @Q@Q@Q@@\)@
@
@
@ۅ@
@@(@p@
=@@(@@
@H@ff@33@=q@ڏ\@
@  @G@z@(@G@أ@  @  @  @=q@Q@@@Q@أ@=q@ٙ@G@Q@ff@ָR@  @أ@ff@@G@ָR@Ӆ@{@@(@  @Q@@G@H@ٙ@ٙ@@Ϯ@
@Ϯ@Q@(@G@@@33@ۅ@z@
@@(@(@(@ff@  @p@
@@׮@G@ٙ@ٙ@ڏ\@=q@33@ڏ\@ڏ\@=q@ٙ@@ٙ@ڏ\@@33@@@
=@\)@@Q@{@33@33@ڏ\@ڏ\@ۅ@33@@=q@z@
@
@H@أ@ۅ@\)@@H@
@
@33@ڏ\@ٙ@ڏ\@H@ۅ@ۅ@33@ۅ@ۅ@
@33@
@@(@ڏ\@G@ٙ@G@@ٙ@׮@=q@(@ڏ\@(@
@@@ۅ@أ@G@G@@ָR@(@{@
@љ@Ϯ@@  @ڏ\@ٙ@G@  @ff@{@{@\)@׮@@@G@G@أ@Q@@=q@33@z@ff@޸R@߮@
=@G@33@G@Q@\)@{@@{@@{@(@
@z@(@(@H@@{@޸R@޸R@@@z@(@@z@(@(@z@
@ۅ@
@ۅ@
@@33@@
@
@H@ڏ\@H@H@=q@=q@H@(@33@@(@z@z@ٙ@@ָR@H@H@@׮@ָR@p@@@@@(@@z@@ָR@{@{@
=@@@ٙ@33@@{@(@\)@@G@G@H@\@@H@H@H@
@p@z@@p@\)@ff@  @\)@
=@@  @Q@  @@@  @\)@@
=@\)@  @@Q@@\)@@
=@  @{@R@p@H@@Q@@Q@  @
=@@Q@  @߮@@G@G@@33@@=q@=q@\@(@
=@H@@  @\)@ָR@@33@
@ٙ@ۅ@@ڏ\@@@@
=@޸R@
=@߮@@@
@ff@ff@ff@  @ff@@߮@
@@H@@
@ᙚ@=q@G@  @\)@޸R@
=@\)@@  @ᙚ@G@Q@@@=q@@
@
@@\@(@=q@\@H@H@@@33@@H@@p@@Q@@޸R@ff@߮@޸R@߮@33@(@ۅ@@ڏ\@ڏ\@Q@G@  @@Q@=q@z@{@p@ff@\)@33@p@
@ff@
@p@@p@H@Ӆ@@Ӆ@p@@@H@ȣ@θR@@Q@ff@=q@@
=@ff@p@=q@љ@@@θR@У@=q@=q@=q@@G@G@Q@  @  @  @\)@  @@ٙ@ٙ@=q@ڏ\@ۅ@(@(@z@@@
=@߮@ᙚ@\@@(@@@(@z@@(@@(@@=q@@߮@@Ӆ@H@  @G@ٙ@G@ٙ@ٙ@@G@@G@أ@أ@ָR@
=@\)@@@θR@p@p@33@=q@H@  @{@@
=@{@
@ۅ@H@H@G@@G@33@=q@Q@أ@ٙ@H@@@@
=@
=@޸R@@@p@޸R@(@  @߮@ff@@z@߮@Q@@߮@Q@@@@G@@@@=q@\@\@33@(@@\)@\)@@@@@33@=q@陚@@33@陚@G@G@H@\@@@G@@@@
=@@ff@@
@@@@G@@@=q@\@@=q@=q@@޸R@Q@@G@G@ᙚ@  @G@H@@@  @{@=q@
@@@@p@{@p@{@{@
@أ@أ@=q@H@H@@@@޸R@޸R@\)@=q@ᙚ@@@޸R@޸R@
=@@@@G@\@@\@33@(@(@z@p@@@p@@@z@(@{@\)@  @@G@\@33@H@@@=q@@陚@@  @@  @@G@@G@@ff@p@@@z@
@33@33@=q@=q@=q@@ᙚ@ᙚ@33@(@(@
@(@@R@\)@{@ff@p@ff@@\@@@ᙚ@33@33@@H@(@H@33@=q@\@@@Q@  @
=@@@{@(@z@p@=q@=q@\@@33@
@@@(@H@@33@@z@p@ff@\)@@@@@@@Q@G@R@
@@  @=q@陚@(@(@p@H@@@33@H@ٙ@ָR@@R@\)@H@p@z@@
@33@z@ۅ@@@@@׮@ڏ\@@@  @  @׮@  @H@p@@
=@  @\)@G@  @߮@Q@@G@
=@(@@p@@33@߮@@(@z@ָR@ҏ\@p@ff@{@@أ@@33@Ӆ@@У@  @Q@33@=q@z@{@G@
@=q@ff@ۅ@׮@33@H@ڏ\@33@
@z@ff@Q@Q@߮@޸R@(@(@@\)@
@@޸R@ff@{@z@޸R@޸R@p@@z@=q@@\)@H@@@@  @
@Q@љ@@@=q@@ָR@@p@Q@\)@ָR@33@G@ҏ\@љ@У@(@G@@p@z@ҏ\@@ڏ\@G@Ӆ@أ@ۅ@
@@@z@p@ڏ\@H@@ٙ@ڏ\@ڏ\@@(@H@=q@33@\)@
=@ۅ@33@G@ٙ@@=q@H@H@ٙ@G@ٙ@Q@Q@Q@Q@  @׮@@ٙ@
@@@ff@@أ@׮@
=@ָR@׮@{@@\)@@@{@ff@Q@G@p@׮@@Ӆ@@p@@=q@=q@H@@
@ҏ\@G@@@=q@33@\)@
=@У@@ҏ\@G@љ@Ӆ@@G@Ϯ@У@ҏ\@Ӆ@H@
@z@p@(@Ӆ@љ@@
@p@@Q@
=@ff@θR@У@=q@@z@љ@G@Q@@=q@G@@@ҏ\@=q@
@@
@z@(@
@@{@@p@{@@ָR@Q@G@G@ٙ@=q@@G@ٙ@@ff@ָR@أ@Q@ڏ\@
@z@@33@
@@@G@ۅ@ۅ@ٙ@@=q@ۅ@
@=q@\)@ۅ@@G@H@@H@H@H@@@أ@  @\)@أ@\)@Ӆ@
@H@(@p@@(@H@љ@@Ӆ@@У@љ@=q@Q@@@
@  @@p@@
@G@ڏ\@
@33@=q@ٙ@@=q@G@G@=q@H@ٙ@=q@ٙ@=q@ۅ@33@
@@@
=@Q@Q@@@@\@@Q@@@@@@p@ff@
=@  @=q@=q@@\@@\@{@z@33@\@=q@@@@{@@  @@ff@@p@\)@(@ff@޸R@
=@߮@Q@Q@@߮@@@@G@  @ᙚ@
@
=@\)@=q@@33@z@@@p@33@G@ڏ\@
=@ٙ@{@ָR@{@(@@ff@@ff@
@
=@G@߮@\)@@陚@{@33@G@Q@@ᙚ@@\@H@z@{@\)@H@@p@@(@陚@@Q@p@{@R@
=@\)@\)@R@{@R@@@@  @@=q@@G@  @@@z@
@z@H@{@p@@Q@@@@@@\)@@{@@\@ᙚ@{@@@@33@ᙚ@=q@G@  @G@=q@\@  @
=@\)@  @߮@
@\)@߮@{@ff@z@
=@=q@H@p@
=@@33@H@@\)@\@G@R@@p@{@R@\)@Q@Q@@陚@=q@=q@G@H@\@33@33@
@=q@@@陚@@H@=q@@陚@  @ff@@
=@Q@陚@ff@{@(@
=@@\)@  @@G@@p@Q@\)@(@\@@p@z@
@@\@ᙚ@  @@z@H@ᙚ@ᙚ@  @\)@{@@@{@޸R@߮@
=@߮@߮@\)@ff@@=q@ۅ@׮@H@ff@
@Q@ָR@أ@z@(@(@p@(@(@ff@@{@@
@H@׮@p@G@أ@ff@\)@Q@H@@z@@z@@{@R@@Q@陚@@G@G@陚@H@\@Q@陚@G@ff@@@  @
=@@ڏ\@@@\@=q@@Q@ᙚ@@
=@@G@@
=@@@@
=@߮@@H@H@@@33@@@G@=q@H@@  @ff@޸R@ff@{@=q@z@ۅ@z@ff@H@@33@p@@ff@ٙ@Q@@
=@޸R@p@{@ۅ@z@z@@ڏ\@أ@@H@=q@H@ٙ@G@@أ@ٙ@G@ڏ\@33@H@ڏ\@ۅ@ۅ@33@H@33@(@
@(@@@@@@ff@޸R@{@޸R@޸R@ff@@@@@(@ۅ@(@ۅ@(@(@33@ڏ\@@H@33@H@ڏ\@=q@=q@أ@G@أ@أ@  @@  @@G@G@@G@  @G@ٙ@ٙ@ٙ@@  @أ@{@{@@z@z@@@@p@@ff@׮@  @ָR@{@@p@@@ff@@\)@\)@\)@׮@׮@\)@Q@  @أ@@33@z@@@
=@
=@ff@{@@ۅ@
@ۅ@(@@@  @ff@ff@
=@\)@ff@@@@
@أ@  @ٙ@
@=q@ٙ@=q@ڏ\@ڏ\@@
@z@
@
@z@ۅ@@z@ff@ff@z@(@z@@33@z@@@
@z@ۅ@
@33@H@@33@H@=q@ۅ@ۅ@33@ۅ@ۅ@G@@p@Q@@
=@  @\)@
@Ӆ@@33@љ@@Q@Ӆ@{@{@ٙ@33@ָR@@@ڏ\@33@(@@@ۅ@@
=@p@@@z@
@ۅ@H@(@@@@@޸R@ff@ff@ff@
=@\)@  @
=@G@ff@{@޸R@Q@G@@@@@z@p@p@(@
@ۅ@@ڏ\@@أ@=q@
@p@@ۅ@ڏ\@p@z@@z@{@{@ff@ۅ@@ۅ@z@(@G@ٙ@ָR@@p@z@H@z@ff@\)@
=@@ٙ@@ٙ@@H@ڏ\@H@ٙ@@  @33@=q@ff@@@{@{@\)@@@ָR@z@\)@@@ff@߮@@G@G@G@Q@@ᙚ@=q@\@33@
@@
@(@@
@@z@z@(@@{@{@ff@@@@@@33@@@@@Q@@@  @@@  @  @  @߮@޸R@޸R@ff@@p@G@ָR@G@@
@
@@Q@  @Q@  @@أ@ٙ@أ@@H@@ff@  @@ff@ff@(@z@
@p@
@ڏ\@H@
@
=@߮@=q@\@H@@@=q@ᙚ@G@\)@޸R@޸R@߮@
=@
=@޸R@\)@Q@߮@@Q@G@ᙚ@\@33@@
@z@p@
@
@@@\@@=q@
@(@(@
@@@p@@z@@33@(@33@H@H@ᙚ@Q@  @@@  @@\)@߮@޸R@޸R@
=@ff@ff@33@ڏ\@H@H@
@G@أ@ڏ\@ڏ\@33@=q@ڏ\@=q@ڏ\@33@
@z@
@ۅ@
@z@@(@@{@p@أ@\)@G@G@
@z@{@
=@
@@(@
@33@33@ڏ\@ۅ@z@@
=@ff@߮@
=@ff@@@@@ff@
=@߮@\)@߮@  @  @  @  @@߮@߮@\)@  @Q@G@Q@G@@@@
@=q@  @Q@߮@\)@ff@޸R@ff@޸R@{@{@޸R@  @ff@޸R@@@
@
@ۅ@z@
@(@@(@(@
@33@ڏ\@@@@G@@ٙ@ڏ\@33@
@33@H@H@33@(@(@ۅ@(@@@ۅ@ۅ@@߮@ff@޸R@@@@  @߮@\)@޸R@z@\)@@ۅ@(@
@@
@z@@p@޸R@
=@\)@Q@Q@G@@G@G@=q@\@=q@@G@ᙚ@G@@ᙚ@G@ᙚ@@@  @  @@  @\)@Q@
=@\)@޸R@{@޸R@ff@{@{@ff@{@{@޸R@p@  @߮@߮@޸R@@޸R@ff@޸R@޸R@{@
=@@z@33@ۅ@
@(@@(@z@@z@33@33@
@=q@  @  @׮@\)@Q@Q@׮@(@ڏ\@ff@\)@ڏ\@޸R@{@޸R@p@(@ᙚ@޸R@޸R@@z@@z@
@z@p@ff@ff@@ff@ff@@@
=@޸R@@Q@G@@G@ᙚ@@=q@=q@@H@33@(@@@@@
@H@33@=q@33@\@\)@߮@@
=@޸R@ff@@߮@@(@
@@z@=q@=q@ٙ@@(@H@H@G@@=q@@z@z@@أ@ָR@
@
@33@@@=q@G@ҏ\@\)@׮@ff@  @ָR@أ@  @  @أ@ٙ@ٙ@@H@33@ff@z@
@H@
@
@33@33@(@(@\)@\)@@޸R@޸R@
=@\)@@Q@
=@\)@{@@(@߮@
=@  @Q@߮@
=@Q@
=@޸R@@
@@\)@@\)@Q@Q@Q@Q@@@@{@p@@\)@p@@@
@Q@@=q@ۅ@
@@@z@@@@@p@@@@(@z@@p@
=@{@p@p@@@@@@ff@@߮@
=@{@@z@(@@@@z@
=@@@@z@@@@޸R@  @\)@@@@H@
@H@@R@@p@ff@p@(@@(@(@(@{@z@\@@
@33@(@\@H@@@@ff@
@(@@(@z@G@(@߮@@(@ۅ@{@Q@ҏ\@  @\)@
=@(@޸R@@ۅ@(@
@@(@@ٙ@أ@Q@  @G@G@Q@ٙ@
=@ff@\)@أ@׮@
=@\)@@ָR@׮@
=@׮@=q@{@H@@@\)@
@H@\)@  @z@߮@
=@@ᙚ@
=@{@@H@ۅ@z@@޸R@ff@
=@޸R@߮@
=@
=@@\)@  @  @߮@߮@Q@Q@  @  @
=@\)@Q@Q@G@ᙚ@  @\)@  @  @߮@\)@@׮@@G@@\)@z@33@
=@
=@\)@\)@
=@\)@ff@{@@@@@z@z@@z@(@
@ڏ\@H@H@ڏ\@33@H@H@z@H@ڏ\@ٙ@  @
=@\)@\)@ָR@@=q@33@{@(@@أ@=q@@33@@z@@@(@@z@(@p@@p@z@@@p@{@޸R@
=@  @Q@G@ᙚ@=q@\@
@@
@(@(@33@
@33@33@\@ᙚ@Q@G@G@=q@@@=q@33@=q@=q@\@@=q@ᙚ@ᙚ@@G@@@@Q@Q@\)@ff@{@\)@߮@@߮@@p@@ۅ@ڏ\@أ@  @
=@
=@@@z@ff@
=@ff@
=@ff@p@@љ@G@=q@ҏ\@ҏ\@@z@ָR@G@G@H@(@ff@أ@ٙ@=q@@ۅ@33@ڏ\@ڏ\@33@(@ڏ\@@(@ff@\)@ڏ\@@(@(@@z@p@ff@  @@@@H@p@  @ᙚ@@  @=q@ff@p@@
@H@@z@ҏ\@H@Ӆ@z@p@p@@@33@  @
=@p@У@Q@У@љ@@G@=q@@33@@  @@=q@
=@׮@׮@׮@ۅ@@33@@
@ۅ@ۅ@=q@
@{@޸R@33@H@У@@H@@=q@љ@ҏ\@H@z@=q@Ӆ@Ӆ@ҏ\@أ@ڏ\@׮@@Q@@ٙ@G@@
@@G@أ@ٙ@ٙ@G@  @ٙ@ڏ\@(@
=@@Q@  @=q@33@H@(@\@ᙚ@Q@G@=q@@@
@z@(@33@@H@=q@G@@H@33@
@=q@@߮@
=@  @Q@߮@@أ@أ@޸R@@z@
@ۅ@G@(@@@
@(@33@
@=q@
@ff@@H@ff@
=@{@ָR@  @ָR@ָR@@  @G@=q@=q@=q@H@ڏ\@33@H@z@
@z@
=@@ָR@H@
=@G@@ڏ\@@أ@\)@@{@Q@  @  @\)@
=@@@G@ڏ\@z@{@ff@
=@޸R@Q@G@ᙚ@\@\@G@@Q@  @\)@\)@
=@ff@޸R@
=@޸R@߮@\)@
=@@
=@\)@ff@޸R@  @
=@޸R@  @  @
=@\)@޸R@
=@  @p@ff@\)@p@@z@H@ۅ@ڏ\@G@@أ@ٙ@@أ@@@H@G@@أ@  @ٙ@أ@ڏ\@\)@ff@
=@ָR@\)@(@G@У@@ٙ@G@@H@H@33@޸R@@޸R@  @  @Q@\)@  @@  @  @\)@Q@@33@33@@
=@@G@@@@@Q@@@@@@{@@@@
@
@@p@@H@@H@\@
@=q@@@33@33@H@33@\@\@@H@=q@\@G@@@@Q@ᙚ@=q@(@=q@@޸R@p@@  @޸R@Q@Q@޸R@{@@(@
@@@(@p@@ff@H@ڏ\@  @
=@{@@޸R@Q@
=@H@@z@
=@@p@p@ᙚ@@@33@
=@p@
=@@G@  @@  @@@@\@
@(@@
@(@=q@@(@G@\@z@(@H@@H@@@@@\)@@@\)@R@
=@p@@@z@@
@z@33@@\@@Q@@@@@@
@\@33@\@@@@@=q@@=q@G@
@ff@ۅ@߮@{@@޸R@߮@H@\@@z@33@
=@ff@Q@=q@\)@ٙ@@{@޸R@@޸R@  @33@(@p@p@(@@(@p@{@{@ff@\)@@  @@33@H@H@{@@@@  @{@ff@ff@
=@@@@z@(@@z@@@@@@Q@@@\)@@=q@@H@\@G@߮@\)@
=@@(@H@=q@ff@@ᙚ@\)@@Q@@p@@
@Q@p@
@=q@\@\@\@\@@H@33@@z@z@G@
=@@H@@\)@
@p@{@@@@33@@@R@@(@
=@@
=@\)@@@\@(@p@R@  @@@R@@  @p@
=@R@ff@\)@@HApA{A=qApA33AGAffAA{AA33ARA=qAAA A z@p@{@p@{@@(@
@z@{@
@@G@  @\)@R@
@@@@z@@@p@z@p@z@@(@
@@33@H@H@H@陚@陚@\@\@@
@(@(@
=@{@@
=@@33@=q@33@z@33@z@(@
@
@
@@@ff@
=@\)@  @@=q@G@\@@RA zA AAGApAG@p@@{@{@@33@H@@z@z@
@(@33@@  @@p@@\)@H@@H@@{@@H@z@@{@(@@z@@{@@\)@
=@@ff@@@\)@
=@@(@(@@p@ff@@  @p@@{@(@  @@@@p@@@@@
@
=@\)@\)@
=@{@\@@\@
@p@R@R@@@@
@@33@(@@@@
=@z@@@@ff@A A33AA  AA(A@@@@@@\)@
=@\)@@@@@\@@
@@@Q@@Q@@z@=q@33@@@@@{@ff@@z@H@
@@@
@=q@\)@@@@@Q@
=@  @@
@H@@G@
@33@@\)@  @=q@G@z@@p@\)@33AApAAffARA33ARAA z@@@\@@
=@Q@  @=q@33@@@\)@
=A   A AffA33AA\)AG@@
@\@@@
=@ff@A zA
=AffA=qA{AAGA AA @p@@33@Q@
@@@@@@@@@@@@\@@@33@  @
=@@@\)@p@@Q@@=q@@H@Q@@@z@R@=q@@@(@z@R@
@Q@@Q@\)@@ff@ff@(@
@@=q@
@(@{@  @G@=q@=q@@
=AAHA AAAAA  A
=qA	A	GAHA	GAApA
RA  AA  A@@
=@\)@{@
@33@H@=q@ff@{@@{@{@H@HA  ApAH@p@{@H@@@p@\)AAA   @
@33@
@\@33@@Q@Q@@33@  @R@  @@\@G@@@Q@@@@=q@33@@
@=q@\@@@
=@@\)@A A Q@RA\ApAAA=qA Q@@G@@G@(@@@
=@
A ApA(A\)ApA=qAzAA
A{A A @R@R@RA{AAGAA{AAA
=A\)A\)A\)ARA=qAp@A   A   A zA @R@@
=A (AA=qA@
=@
=@@
=AA A QA A A (A QA A Q@z@@@33@{@@@(@=q@ff@
=@p@@=q@@@@
=@Q@@(@@@(@
=A{@33@@33@\@=qAARA\)A
AA(A{ARA QA (AHApAAQA
{A
=qA
{A	AffA\)AAQA
AHAHAffAAA @@R@{@@@(@@\)@\)A QA @\)@R@
=@@ff@{@RA A (A (A(A33AA(A
AA33ARAHAffAzA
ffA\)A  A\)A
RAQA{A
\A
AffAApApA
AzA
=AQA
AAA
=AAAAffAGA
\AzAzA\)A=qA\AA\)AA
{A\AA(A
\A
\A	A
{A  A
A(A	GA(A	A\)A=qAA33AAA\A
ARA
AG@ff@ff@
=A(@@pAAAA
{A{AzA\)AA@AA A\AA
A\)A{A{A(A33AA=qAA{@p@R@G@33@ffAA zAGAA(A(A @R@R@p@@33@@@@(@33@@A zA @@
=@
@{@A (ApAAA33AHA33@AA QAA
=AffA33A
A  AQAApAAffAAQAzA	pA
\A
ffA
{A
ffA33A
RA
=A33A
RA
\A
ffA
=qA
HA
HA
\A
AA
GAA	A
=qA
\A	AA
=qA	A\A{AA\AAzARARAffApAAGAAAAAAHAffAAApAAAAAAAA  A(@@=q@z@@=q@@
@R@@zA\)AAApAA  AAHAA  AAA\AA QA AA{A33A\)A  AAAQAzA
RA  A\)AARAffAAA
=A{A=qA{AAffApAAHA{A{AAAAA33A(A{A{ARA=qA
A  ApA33A
GA(AAzA
=qAzA
AA	A	A
{AzA(A
ffA
RA	A
=A33A33AA33AffA\A  A z@ffAHARA QAff@ARA=qARA  A=qA=qA{AA(A@A{AHA\A
=A\AA33A	pAAA\)AAAARAzA
AQA\A(A{A\)A  AAA\)A!pA
ARA%A&RA&{AA(AGA33AQA{A
A
{A
\A
=AffAA
{AAA	GA	A
RA{AHA{AHAzAA	A
ffA
AffA	AA\)AQA  AzAHA=qA{AGAA
AAA  A
=A33A
AQA AAG@{@@{AGA=qA
=AApARAApA
=ApAffAQA
=AHAA33A{A\)A
A	A
ffA
A\)AA33A
AGAHAAAQA=qAGAAQAAA\)AA\)A$QA$A'A'\)A#
=A$A"\A\AQA\ApAGA\AHA  A33AAQAAA{AffAA
A\)AA	A	pA
HAzAA
=AApAGAA A ApAA\A33A\A33AAQA\A zAA @AApA=qA{AHA z@\)AAA\)AQA	A	GAAAzAQA(A  A
A
=A  AA\ARAARA
=AHAAzAGAA
pA
HA
A
AQA\)A	GA33AffA  A#\)A"HA'A((A$A#A33AAA\A(A  A
AARAA(A
ffA{ApApARA
RA(AzAA\)A33A	pAAAAzAzAAQA
pA33A
{A
{A	AQAA
AQA
\A	A	GA	A(AGA=qA A zAHAAAzAzAAAApApARAHA  A  AAAzA\)AzA  AQAA	A
=qA
\A
\AA
=AAzA
A\)AGApAA  AffAHAHA\)A
AAAffARA\)A=qApAAGAAA
=ApA
=AAApAAQAA	pA
A\)AHAA
AHAA\A
=AffAA  A
=AAAQAAAAQA
A  AAAA=qA\A (AA ApA zA{A\)ARAffA=qARA=qAApApA AAAA=qAAAA=qARA\)A\)A
A	A	pA	AA33A
=qAHA  AHA33AAffA{AA\)AApAAA{A\ARA{AAGAQA
RA{A  A33AHA=qAAffApA Q@{@z@33@@@AGA\A=q@ffA   @{@AAz@AG@@@@R@@p@
@@R@@陚@@@陚@(@@\@@@
@{@@@@Q@@G@=q@\)@z@ff@Q@
@33@ffAff@{@@A A A zApAARA A
=A33AA\A\ARAQA
=A Q@z@H@@R@AAzAzAQ@
A=qAQAA@AR@R@{A33A (@H@@\)@@pApAGApAffAffAzA
=AAARA  AzApA\AffAAQAAHA AG@R@
=@@@{@ff@@z@@z@p@@@\@@@
=@Q@=q@
@=q@@@@(@@p@{@  @\)@@33@
AAffA\)AQAAA
AzA
AAA{AHA\)AA33A  A33AffA\A
=AzA	GA
A
pA
A
=A  AAQAHA{A
=A\AA=qAHAAA
pA
A
=AA
{A
\A  AzA  AA
RAAAQAA
=AA@ff@ff@\@G@@\AffA @AAG@{@ffA   @@\)@@A @\)@@
@\@@=q@33@@Q@G@
@ff@R@@R@z@@
=@ff@pA zAQApApA
A\)AHA33AA  AQA  AA=qAHA
AA	A33AQA{ApAGAAAA  A
A\)A
=AAAHAHA\A33AA  AQAffAGAA\A(ARAffA
AQAA
GAQAAAARAAAA
AA33AffA\)ARAGAAAGARA
=ARAAA  A33A@ffA\@@A (A   A   A   A   @ff@{@\)@\)@ff@A QA AAffA
=A\A  AAA
AAAQA\)A
AA	A	pA
ffA
=AzAAAGAHA
A=qA
AA\)A  AA=qA{AAAA33AAAA\A=qA{AAA=qA  AAzAQA\A
A\)AA
A
AzAApA\A=qA
AQA
ARAA\AzAAARA=qA
=A=qA
AzA(A=qAA=qARA(AAffA	GA	A	AAA  A  A
A	pAzAzA
=A	ARAAAQAA  AAGA
=AAA{A\A	pAA
GA=qAA
AzApAA  ApAAA(AzAA(AAAAApAAAQAA(AAHAHAAA
=AARA=qA
A
=AA(A
\AA
AA\)AARAQAQApAAAA33A\ApAAA\)AAA\)A
A33A\)AHA\)A  AzAAzAAAAHA\)A zAAQA(A
A  AA{AA\)A  AAA\A\)A	A
A
AA(AA
A  AzA	A	A	A  AA
=A	A
\AQA(A
pARAAA=qAQA
=A	AAA  A(A
AA{AffARAHAA\)AHAAAzA{A
=AA(AA
=AA
pARAHAHA
A
RAA(A
pA\A\A
=AA
AQA
ffAAA\)A{A
=A
RA
\A
A
A
AAA
HA
HAAA\A(A
A\)A=qA  A\)A\AA=qA
A
=A\A
AA
=qA33A
A
ApA{AA(A
AQAGAAAA{AARA=qAAAAAGA  AAA  A=qAAA(ARAAAA33A(A\A33A=qApAffAAAzAA=qAQAA\AA	GAzA\A
AAAQAffA=qA
AAzA33AAAQA
=A
=A
A
AAAA  ApA  A{AH@
=@AHAGA
AAA
AzA{A
=A{AA @
=ARA  A  A33A  AAA
pA
A{A
pAffA33A\AA
AffAffAAGAAA
AAAA
AQA
pA  A
A
{A33A
RA
=AA(A(A	A(ARAA  A
A	A=qAA  A
AzA
A(AAA	GA	GA	A	GA	A	A  AzAAHA33A
A
{A
=AHAAAffA\A A @
=ApAffAA @@{A@\)AA{A33A@ffA=qA
AA  A
=A(ApAffA(AQA\A=qA=qAHA
=A33AA(AA	GAzAA  A	pA	A
HA	A
=AApA  AGA{A @\@@{A{AzA\)AAA
A{A A=qA	AffA(A(A\)AAA AA{AAzAffA33A Q@
=@ffA A QAR@z@@@@z@\)@
=@@ff@RA (A @\)Ap@\)AGA\@
@ff@z@Q@\@  @@
@z@zA z@
=A z@Q@ff@@@(@@z@@(@z@33@(@@@@
=@@=q@
@p@@@ff@ff@{A AAzAzAAzA\A\)ARA AffA@ff@@@\@Q@\)@z@z@@
@z@H@@@H@=q@@@\)@R@Q@G@@(@33@H@z@@H@33@@\@33@p@=q@@@Q@
=@p@@@@@H@=q@@Q@@
=@ff@@{@Q@{@R@@@ff@=q@@
=@{@ff@@{@\)@Q@Q@@(@@@\)@=q@ff@
=@@ff@\)@@@  @
=@@Q@@
@A   @RA z@ff@G@{@@@z@H@  @@
=@{@
=@@@z@H@Q@@p@@@H@Q@H@=q@H@H@@\@\@@H@@@ff@(@@@@G@@@@H@\)@
=@@{@G@ff@@@@p@@p@@
=@
=@@\@@  @(@(@\@@ff@@\@@@
@
@=q@@G@  @@=q@H@H@(@z@@z@H@(@@  @G@R@
=@@\)@  @=q@=q@@=q@@
@33@@Q@@@p@z@@z@@
@
@@ff@R@33@@@(@R@
=@@\@@@
@@ff@@G@@@
=@\)@@=q@33@33@H@
@@@\)@陚@@
@@@(@  @=q@Q@p@z@@
=@(@Q@p@ff@@\)@33@G@33@33@H@H@z@@@33@@@@
=@@
=@R@@@Q@@G@@=q@33@\@33@33@
@
@
@@@  @ff@@\@
=@Q@  @H@@@R@  @@  @(@33@  @RA A zAGA A z@{@@@(@R@ff@z@\@33@
@p@{@
=@z@@Q@
@z@z@G@=q@z@\@33@p@33@A z@G@R@@G@G@(@R@
=@\)ApA A{A @ff@ff@
=A AGAAA=qA\A{A
AAHApAA{ApAA=qA
=A\AHAA\)A
=AA A AAAffAHAHA
AA\AQA @ff@\)A A A (A33AHAA	GA\)ARAA{AHA\A\AARAffAffA
=A
=ARA=qAA
A"HA zA$QA&{A)A&{A'33A)A)A*=qA0QA0zA.RA3A3A2ffA5A5GA0(A/
A/
=A2RA+A+A+A0  A1A0zA0A2=qA/A1GA0  A.\A+
A+A(A&HA%A#
AA%pA"HA$  A#
A#A A\A{ApAAA
A(AAffA33A!A$zA"=qA\A
ARA
A
=A
AA  AQAAGAAAAA{AAQAQAQA33AAAA  AGAAApA
{AA(A@
=A
AffAAHARA
A@A\)ARAAA=qA
ffA@@(A @(@G@@p@H@{AAAA
\@@z@H@p@@(@陚@@G@Q@@@p@@  @  @33@G@AAHAGAApA@{AAffA=qAAffA\AA{A{AzA{AAAzA
RA
RA33A
ffA
\A
=A
A  A	AQA(A A=qA=qARA
pA
\A\)Aff@\)A A=qApA@
=@A=qA=qAAA{A{A
AAAAA  AAAAAGA{AARAHAA{AA\AAQA(A33AA33A\AQA
=AAQAA{AAAAA=qAAA
=A\)A{A=qA{A  A\)AGA33AAGA{A\A\)A{AARAARA{AzAGA
GA	pAA{ARAA=qAA{AGAA{AA\AHA  A\)AzAA	AA	AzA(A
=A=qA
RAQAA\)AA=qAA
A
AAAA{AAQA  AA=qAAQARARAA\)AQA	pA
RA  A
ffAAA\AA	A
{A	AAAGAGA QApA (ApAA\A\)A
=A
HAA	GAzARAA\AQA\)A  AzAA{A33A
ffAA
pA
=AA
=A	pAA\A=qA
=AA
=AAG@A Q@
=@A A @{A   A @@
=@@{@zA   A A zA zA (A=qAAA\)A(AzA  A\A\A33A
=A{AAAQAffA AA
=A\A
=AffApA A  AGA
AGA @@@@AAGApAA=qARA(A\AAzARAffARAAAGAHA=qAARAApA\AA
=A QAAA(AA	AGA\)@{@RA Q@R@z@z@33@z@\@@R@z@z@\@@@\)@
=@@@
@
=@33@Q@=q@@@@@@G@{@ff@ffA Q@@@(@
@z@
=@@A @
@{@(@GA z@\@@\@{@H@@@R@@G@G@\)@@=q@R@33@@z@p@{@33@{@  @G@@p@R@@33@p@
=@\)A QA=qAA
AAAAGAA33AA
ffA	A\)A
A
ffA	GA33AA
A
=AGA
=A  A{ApAAAA AAAQA	pAA33AHAHAA(A33AGARARAA(A33A@A\)AHAAAffAAA{AA
=A{AffA\)AHA=qAAHAA\A{A\A
=AQA\ApA33AGA   @RA @33A   AAAA\)A(A  AAA	A(A(AAAQAAA{A
GAzAA\AQA  AffA
=A\)ApA  AAA
=A33A
pA
AAA	pAQA33A33A(AA(A\)A
pA
GA  AA	GAQA\AAAAA{AAAAA\AffAAAAGAA  A  AApAffAHA{A\)A
A	pAAzA  AffA
=qA
\AAHAA
=A  A(AQA
\A
HA
ffA33A(A  AzA	A
{A	A
RAQAzA
GA{A{A  A
A  AzAAQA{AAA{AApAA{A{ApApA=qAA\)A33A
A=qAA33A
=AA33AQAHAA  AARA
AAAA=qA\)A\)A
ffA\)A
A
AQA  A
A\A  A	A	pA
HA\)A
RA
=qA\)A(A	pAA
A
A(AAAAQAQAzAzA  AA
AA AA  A(A ApAHA33AA\)AQA
\AAzA  A	AAA
A
A{A{AAzA
A{A=qAAAAA=qAHA33A  AAApAAAAzAffA
A\AHA(AA\AAAAA\AAAAAA\)A\)AA=qA
A	A
HAAA
A
RA\)AAffAAApA=qAAA
A
AzA(A
AA
A=qAffA
A
AA  A
RA	A
=A
ffAA(AA	A
pA
=A  A
A	pAA
A
ffAA
pAAHAAA{AQAA
AAA=qA33AA\A(A  AA
=A
=AA
=A
AA
AA{A\)AA(AzA	AA	AAHAA
=A(AA
AAAAzA
=qA	AA{AAzA=qA\A
RA  AA
GAAA
\A
=AA\)AAAA	GAffAAA\)A(ARAAA{ApAAzAAA(A33AffA33A=qA@
=A\)A QA AzA
=ApAAHA\)A{AHA	GA
ffA
ffA	A  A\)AHARA
AA
{A	A33A
=qA33A\)A(AQA
A
=ARA(AApA33A
=AA\)A33A{AAAGAzAA\A{AHA=qA=qA
=qA  A	AA
\A	ARA
{AQA=qAA\A  AffAA	AHA\AA\A\A{A33AHAA33A{ARAAHAA  A(AzA33A
=A\)A=qA
AAAGA=qAQAHAAA  AHAAAzA
A
=qA33A
RA
AQA  AA
GA{AHA33AQAGAA=qA
AQAA{AAQAAARA  AzAA=qARAHAHAffAGAApAzAAAAzAHA  ARARA
=AAQAAA33A{AHAQAffAA33AAGA
=A(AA(A\AAAzA33A{ARA{A
GA
pA
GAA(AAA33AAQAA  A(AA
A
\A(A(A  AA
AA
A=qA
pA
ApA
ARARAzA(ApA{A33A  AA
=AARAQAA(AA{AGA (A"RA#
=A#33A"RA#\)A#\)A#\)A!A!A!pAA{AAA(A  A33AHAffAAAGAAzAApAApAGApAA\)AffAHA=qAApAA(A
A
A33A33A
AA
A{AQAAA
A
pA
A  AAQA\)A
HA33A
A
=qA
AQA(AQAA
A=qA{ARA(AGA\A\A
=A\A
=ARA\)A
=A(AGAAARA33AApAHAQAAAffA
A
A A!A"RA"HA#33A#A$A%A%A$A%A&RA%A#AffA{A  A\)AffARAAA
=AHARAAARAAffA=qAAQAARAA(AA33AHA=qAA
A(AQAAzA  A
A  A33A\)A
=AA\AHA
A
A
RAA
A
=A\)A
A  AAA
=qA
HA  AQA33AApAffA{A\A\)AApA33AAAA{AffAApAHA=qARA\)A$  A#33A&\A)A)GA)A*HA*HA,QA*{A'\)A/A)A&RA#ARA zAA
=A{AAAAA  A
A33A{A
AAQA=qAHA\AQA33AGAAARA\AA=qA33AHAA(A33ARA
A
A
A
A
GA
=AA\AQAGA=qAAAA  AA(AAQA
=A
AAA
=AQA
pARA
=AAQA\)ApAA\)AffAAAAAGApA=qA\AAGA\)A\)A\A{AHAARA\)A\)AA!AzA
AA
=A\A A
A#
A
=A33AA
pA
AHA
A33AAHA
A(A\)A
=qA	GA	A
ffA
{AA	A
A
AA=qAAHAQAffA%A
=AAA{AA33AA  AAzA
A\AffA
=A{AQAzA
HAQA
HA33A
AAA=qA
pA
A=qA\)AQAffAAHA
A
ffA\)AzA(A  AARARAAAzA{A\A"ffA%A$A)A%GA$(A$  A(A((A
ApA\A33AffA=qARAzA	AA
AAAAAAAGA  A=qAA\)A\AAGAQAzA
=ARAAQAGA\)A\)AARAA(AGAAQAAzA
A(A\)AA
=AGAffA
=A{A  A=qAGA
A  AAA  A
GA
A{A\ARAHAHAzAzAA
A
A
A
ARA=qA\AApAAAA  AAHA
A(A
A=qAffAA AA
A
AffAHAffAAApAAARAApAzAAA
=AAHA
AAAA=qAGAAA{A33A{A\ApAAAzAQAAAAHAHA{A
HA	AA
=A
\A33A	A	A	A	A
GA
=A\)A(A\)AAAA33AGA33AA\)A{AQAA(A
=AAA\AAAzAAAAAHAHAA QA   A!A#
A#A$(A$A$  A%pA$(A#33A&ffA#A"ffA
A zA
A
=AHAQA#
A QA%A&ffA%A$A%A=qAGAAA=qAA\)A
=A\)AAAAAApAA33AA
=AAA
A
A\A{A
=A\A
=AA=qAAHAA  A\)AA
A(AQAAA
=ApAAQAAzAAAA
ARA33AHAffA\A\)AAA=qAffA=qAzAffA\)A\A\AAAA  AA\)AGA  AAzAzA  A (A&RA!GAzAAA=qA (A!AzA%A#A$zA%GApAffA
=AAAzA
ffA
=ApAA  AA\)AA\A\)AAffAffAAA
\A
=qA	A33A=qARARA
=A	A
RA33A
A
AA
AffA
AAA
A
A
GA\AQA
AQA
ffA
{AzA33AA{A{A
A
pA
AHARA
A33A33AA	A  AAAAffARAAHAA  AA
A\)AAffA AA"=qA%GA"=qAA  AGA
=A)A$A+A+
=A#
AzApA
AA{AA{AAAAA33ARA
A\)AHA{AA
AAHAAQAAAARA33ApA
HA	A
RA(A
GAA
A
A=qA
AzAA(A
A(A
GAA
=A(AQA  A
{AA(A	GA33A33AQAHA  AAzA	GAA=qAzAAAA33A
AAA
A\A(A(A\A
=A
AAGAAAGAAAHAGAQAAA\AHAHA*{A*\A#A-A*\A&HA"RAA(AA(A\)AA  AAffA
A33A
AHAA{AGAzARARAffA
A
pAAAAAzAAAGAA  A33A\)A
=ARA=qA
AQA
A
=AA{A
A
A{A=qAzA
A(A  A
HA33A
HAA
pA
=A\A  ApAAAAAAGAHA{A(A=qAAAA\AA{A33ARAzAA\)AAQAAAAAHA  AAA33A#
A#A!GAHAffA (A   A!A=qA\)AQAAffA(A  AA	AzA	pA
GA33AA
A\)A	AAA	A	AQAQA	A
{A
HA
=qA	A
ffA
AAAAffAAzA33A  A
A
HA
HA  AA
=qA33A33A  AA
RA33A\)AAAAAAzA\)AAAGA33A(A(AA\A
=AAA
AApA  A33AffAHAAGAzA (AHA#A$A(A"RAA A(QA&=qA#
=A(ARA
A
=A\)AAAAAA33ApA\)A33ARAA
HA
A
pAQAA
A
AzAAQAA
A
AzA
GA
A
A
GA
AQA
AAzA	AzA	A	pA	pA
ffAA
=qA	A	A	GAAA
{A
ffA	A
{AA
=qA\)A	A	A
{A	A
RA
=A(AQA
A\A  AAApAA=qAAA\)ARAAGAA{A=qAAA33AA
=A\)AQAHA!AAAAAAHAffAApApAGA(AAA=qAA=qARAAAHAQA{AHA33AAzA=qAHAffApAAAffAA  ApAAA(A
=A
=A{A
ARAAffAA
A{A
=ARA
A
pA
A
GAffAAHA\)A  A=qA\)AQAHAAApApAQAHA\A\)AA{AA(AAAQA
AQA
AzAA=qAzA#
=A"RA#
A%GA&ffA&\A&RA(A(A%A'A)A)A(QA&{A$(A"=qARAA=qAQA33AGAAzA\AAffAA
A  A33AffAA=qA	A
=AHA33A(A(A
=AzAAAGA\)AAApAAA33A\)AA(ApA{A\A
=AA
\A
=A
A\A
pA(A33AAA
GA\)AA	AAA33AAAGA@@\@A A	@(@@p@@(@33@@  @\)@@\)@33@@\@p@@@(@G@@
=@\)@R@ff@\)@\)@Q@@@H@ff@=q@@{@33@
@
@p@
=@@A (@p@@@AGA
A
=A
=qA
ffA
=qA\)AQA33AA
A
AAGAA"RA!A\)AA(A33A\)ApAzAQAApAQAA{AHAAHAffAA\AHA(A33AAA\)ApAAA
HA	AAA (AAp@A=qAA z@@p@=q@  @H@AA33@H@R@  A@z@\)@p@GA@@Q@
@z@ff@@{@z@
@\)@RA
=AHA AApA=qAA	A
A(A(AA33A\)A
pAHA=qA{AAAQAA$QA$  A%GA"RA"{A!pA#
=A$QA$  A#A&ffA$A#33A"\A#33A"\A!A33AAffAAAA\)A
A=qAGAARAA	AA
A  AA
=AffAp@@@\)A@\)@@
=@
=@
@\)@\)@33A A AA=qA AGA zA A A (@ff@\)@@@R@@@R@A A QAGA A=qA\A(A(A\AA\)A AAHA
ApA
A
ffA
\A
=qA	A	A{AQAffAA33A33AA=qAAffAA  AAAA
A
AzA  AA
AAA{AAA33A\)AzAGA
A(AA=qAAQA{AGAAGAAA\AHAAAHAA=qA
AQAzA=qA	A33AAGAHAHA zAA	GAAAA A=qA{AR@@33AAp@GA   A\)A@pA QA
=A	ApAHA
=A
=@@Q@AA AR@ff@  @@ff@A@\A A
AA  AA	A	GA\)A\)A{AffA\AAzAQAzAp@@p@z@p@@@@ff@=q@ff@@\@ff@
@33@@\)@(@@p@
@@33@z@@@\)@p@\)@@\)@Q@{@
@AffAffA=qAA	G@zA(AzA  AffA	@=q@z@陚@\)@(@(@@\@\A\)@@@@\@{@(@@G@\@pA A\A=qAAHAQA	AzAA\)A (AA\A
=AffA
HA
HA
=A	pAA
GAA
AA
AGA33AAp@
@
@\)@
=@@@H@\@@\)@R@p@  @\)@
=@p@  @\)@Q@@  @@
=@
=@ff@{@{@@@(@z@H@(@z@@p@(@@陚@33@33@@@=q@33@\@@@{@  @@  @@=q@\@@\@
@@@@G@p@@Q@@H@  @=q@{@@H@H@@@\@@@@\@H@z@@
@33@H@@
=@@33@
@R@@@p@
=@@(@\@(@@33@@H@@33@ff@ff@\)@@@{@{@
=@@  @@
=@@z@{@@R@@p@p@
=@@@33@@z@@
@\@@=q@陚@@33@@@陚@@=q@\@@  @@(@(@  @@z@{@  @\)@ff@@p@z@@p@ff@R@@\)@@  @  @@@\)@
=@
=@@
=@{@@
=@@@@@@Q@\@H@@@@@@@@@\)@@33@@@(@=q@@  @@  @@{@
=@ff@33@
@
@@33@\@=q@(@@@p@z@z@z@@@G@\@@  @\)@@  @@@Q@Q@@Q@@=q@G@=q@G@@{@R@ff@
@33@33@H@H@p@@R@ff@ff@
=@
=@\)@
=@@G@\@=q@\@33@@R@\)@@Q@@@G@@H@
@z@ff@  @@
@@
=@ff@R@
=@R@{@{@(@H@G@33@(@@(@\@@@@@@=q@@@@  @Q@\)@ff@
=@\)@@@Q@@@H@33@{@@
=@33@@ff@Q@陚@Q@
=@@(@H@=q@@@@@@@33@ff@@(@=q@G@=q@@@@@G@=q@33@33@H@@
@(@{@@@(@=q@@@=q@p@@{@@A QA A AGAGA{ARAAARAAA(A
=A
=A
=AffARA Ap@=q@\)@@G@@Q@=q@
=@G@@@{@@ff@z@@@@
@p@ff@z@z@
=@z@H@ff@33@33@@=q@@@33@@@@
=@{@ff@
=A   A   A AAffAAA  A  AG@@\A   A ARA
=A
=A  A  AAAApAHAAA
A  AAA33AA{AA(A	GA	A(AQA
RAAA
=qA(A
A{A
A
pAAA
A(AHAAQA\A\)A
A  A
=A(A\)AA=qA
{A@ffAAHAA	pA\)A	GA
\ARApA\ARAA(A
=A
AA{AAGAAA\A
=A\)AAGAQAA\AA
=A
A
=A\)A
=AQA
ARAAAAffAA=qAzAGA\)AAA   A A
A!GAAQAAA33A{AzAA
AzAQAA(ARA
=ARA (A!A"{A A!A#
A"=qA"{AHAAHA\)A
A
pAHAA{ApA   AzA
=ARA(AA{A@\)@\A\)A A\AGA A AffA\)A  AGA=qApAAAQ@RA A	AAA A@pA (AAAffAffAA
RA
A\)A
pA
A{A
RA\)A33AffA
A\)AA=qAHA33A  A
pAGAAA=qAAA{A\AA
A\AA=qAHA
=A=qA=qAA{AGAAQAGA
A
=A
A  AAAzAffAGA\A=qAAA
=A@{@@@R@\@@@@@
@@@@\@@\@\@@@ff@\)@@pA A
A  AR@z@p@\@@(@@
=@
=@\@\@z@@@\@G@=q@G@z@
=@Q@\)@(@
@
@@@zAAffA@R@Q@
=@@z@@@@\@\@@H@H@{@@\@@\@
=@z@ff@@R@{@
=@@p@\)@  @\)@@
@=q@@Q@Q@=q@@@\)@R@Q@@
@@@@{@p@ff@
=@ff@@p@
@ff@z@@z@@z@33@(@33@\@陚@陚@=q@@=q@33@陚@陚@@G@陚@G@=q@H@G@@@Q@
=@p@  @@H@@(@@@@@(@z@(@33@{@@p@
=@@R@@G@@  @Q@G@  @@
=@\)@R@@@(@H@@@A@\@@33@@p@{@\)@@{@@@@@@33@
=@@  @H@\)@ff@ff@\@z@33@(@  @Q@\@陚@R@33@p@z@  @G@Q@  @G@Q@@@{@R@
=@ff@
=@{@
=@
=@@\)@@33@@
=@\)@@@33@G@@z@\@@@p@\)@\)@@
@@\)@H@R@A
A   AA (@p@G@@\)@@pA A\A33AQAA
AAA  AHAA @@@Q@
=@
=@\@@
@@@H@@=q@@(@ff@@
=@\)@@@z@p@@R@
@z@@@(@(@@z@@\)@Q@{@@
=@ff@@ff@  @G@Q@@陚@@ff@R@@Q@z@@@@=q@H@\@@33@
@
=@@{@z@ff@
=@  @  @@@@@H@@H@@@@@@@G@\)@@Q@A z@@33@G@\@@@\@@@Q@\)@
=@  @Q@@ff@\)@@
=@  @ff@@{@p@p@@@z@H@@@@陚@@@Q@@@@@@z@H@=q@(@@(@z@{@R@ff@@R@\)@{@\)@\)@
=@@{@{@
=@(@ff@Q@\)@@@(@{@33@Q@
@\@
@R@@\)@@@ff@
=@
@@z@\)@  @G@=q@(@z@z@ff@@@@R@@{@@(@(@@@H@@@@Q@@
=@\)@{@
=@ff@{@@\)@
=@@\)@
=@@\)@R@p@@{@\@
@@@@z@33@陚@G@Q@\)@Q@
=@\)@\)@@@@ff@{@
=@  @@陚@@@@G@=q@@=q@@33@G@@@@@33@H@33@@  @@
@@(@@@  @\@=q@@(@ff@ff@@  @Q@Q@@33@@\@\@\)A Q@@@p@@@@  @
=@=q@@@H@H@@  @p@@33@H@@@@H@33@\@@Q@\)@\)@@Q@\)@@
@G@Q@\)@@\)@
=@  @z@Q@\)@R@@{@R@
@@߮@@{@@p@@@@p@@  @H@=q@=q@G@H@@=q@Q@陚@
@{@Q@@@(@
@G@H@p@G@A\@(@\@p@
@\A (A A AA AGA=qAAAG@@H@ff@@@  @@R@ff@@\)@\@\)@\)@@@  @@@@@{@@(@p@z@@@ᙚ@@(@ۅ@Q@@G@G@ᙚ@=q@@  @@33@ᙚ@=q@ᙚ@ᙚ@ᙚ@\)@ff@
=@p@p@@ff@@@@{@Q@\)@\)@\)@߮@ᙚ@@
@@
@p@R@@@Q@ᙚ@
@H@@z@
@
=@@ff@{@@  @@Q@H@Q@z@@G@R@  @@
=@@33@@
=@z@G@@@\@
@R@p@(@H@\@=q@ᙚ@@@(@
@
=@{@@ff@
=@z@p@@{@33@\)@ٙ@G@  @Q@ָR@
=@Ӆ@@Q@33@ff@Q@@@H@\)@  @33@z@
=@
=@ff@ff@@أ@p@ҏ\@׮@  @\)@\)@\)@ڏ\@ٙ@
@
@H@Q@Q@@G@Q@Ϯ@Q@@G@@ҏ\@
@33@@G@33@ҏ\@љ@Q@G@H@Q@
=@ff@
=@@ff@z@\)@@Q@@G@  @θR@ff@Ϯ@Ϯ@
=@\)@\)@θR@(@@@
@ʏ\@(@@ȣ@G@Q@
@H@˅@ʏ\@
@
@z@˅@ə@=q@@Q@{@ff@Q@\@\@@(@@@Å@Q@@
=@(@33@G@@\@@{@
@33@G@@@@R@p@z@z@(@G@R@@  @Q@p@R@@{@@p@
=@{@@@p@
@(@p@@@z@ff@@33@(@=q@@=q@@
@(@33@z@z@p@(@@@\@=q@@@@@Q@(@=q@Q@@Q@
=@@  @@ff@{@@ff@
=@@z@(@@
@@=q@@=q@33@\@H@\@@Q@=q@(@z@@@(@R@R@@ff@@33@@Q@@(@(@(@z@=q@\)@@p@@=q@@Q@\@=q@\@  @@Q@\@(@@=q@G@@z@@R@
=@\)@Q@@  @Q@
=@H@(@
@@33@@@  @\)@Q@G@33@p@  @\@{@@G@Q@@{@{@33@@@  @(@G@\@@=q@
@=q@@@
=@@@@ff@(@R@ff@
=@G@G@@  @@@(@
@=q@\@H@z@@p@G@H@\@@  @  @
=@@@
@z@@z@z@  @@@@\@=q@33@@{@@@@@R@  @\)@  @ff@
=@ff@(@H@@(@G@=q@(@\@@(@@p@
@(@(@33@(@G@H@@  @\)@  @(@@(@@\@@{@
=@R@@33@=q@@\@@  @\)@@@(@(@@@33@\)@Q@=q@=q@ff@@H@@@
=@@(@33@@z@=q@
@@  @(@H@ff@@@@@\)@@@H@Q@@@@@ff@
=@@@@@  @@R@33@@@=q@@\@@@@@G@z@(@H@
@
@
=@z@(@@  @  @=q@H@@\@@R@@z@Q@\)@@@@@@G@@@@H@@Q@G@Q@Q@@Q@@q@33@33@@{@@H@@
@@\@z@  @Q@\)@
=@z@@Q@z=q@(@z@vff@u@vff@vff@s33@r\@u@s
@s33@p@o\)@nR@n{@o\)@s
AGApAQAAA33AHA QAAHA
ApA@@@@\)@G@{@@G@Q@=q@Q@Q@@@@@=q@@=q@33@@\@33@z@
@\@@@@ff@Q@G@G@=q@Q@33@@@(@p@H@@@ff@p@@H@G@Q@G@@ᙚ@H@ᙚ@33@=q@ᙚ@@=q@\)@@
=@
=@  @\)@ff@
=@p@p@33@ڏ\@ۅ@@G@33@@޸R@@p@ۅ@=q@@ff@Q@  @@\@Q@Q@@\@
@@G@
=@ָR@\)@G@@ff@H@\)@R@陚@G@p@@@(@Q@(@z@z@{@R@Q@\)@@@@H@
@@\)@G@@33@@(@ff@@33@@@R@p@@
@=q@@G@G@p@p@
@\@@=q@=q@陚@Q@
=@  @\)@@@@(@@G@ᙚ@@
=@@{@H@
@ٙ@׮@Q@
=@{@@޸R@ff@{@ff@Q@\@(@H@(@z@@@ff@陚@@@=q@@\@33@@@@=q@@\@\@H@z@{@@G@@  @\@
@(A QA AAAAAAAzA
A\A
=A
@@p@{@z@@AA (@=q@@  @p@\)@Q@@@\@@@G@(@(@\@=q@@@R@R@@@@=q@=q@  @@(@\)@z@z@R@@@
@ff@@@@(@H@(@G@@(@ڏ\@z@33@@@@G@@G@\)@p@@p@@A z@
@R@{@RA   A A=qA{A\)AA(AQAA\AHAQA	A
RAA  A
pA
A
A
AA\A\A\AA\)AAzA
{AA  @\)@@
=A\)A zA z@zA@{@A   @z@{@(@z@\)@=qA zA  AApA33A A QA @R@{@@@z@\@=q@@p@@@z@@  @{@p@@
@\@\)@
@RA{A zA{A{AAp@\)@@ffAAA   AffA\A  AzA(AzA A(A=qAzA\AAA\)A	A
HA33A  A
=A
=AA
RA
{A	A	GAQA	A33AAQAHAA A
AAA(AAQAAAQAQARA zAAHAA33A@R@@33@\A @
@(@@@33@@@\)@@\@@
@@\@@@{@{@p@@p@{@R@z@  @@@@@=q@z@@@
@p@H@H@  @ff@=q@=q@33@
@(@@(@@(@A Q@RA A AR@RA @\)@ff@\)AGA\A
RA
GA
GA
AAAA	pA
A
@\)Aff@@@@@=q@=q@@@\@{@\)@Q@\)Az@AGAA
AAA@@z@p@@@ff@RA @R@RA\@@
=A (A Q@@@
=@\@Q@
=@
=@
=@@\)@@\)@@@
@@Q@Q@@{@@@Q@@@@R@33@@pA z@@Q@@H@@@R@p@@
=@\)A A A A AAGA Q@
=@\)A (AAAA\A=qAAA@A A A (@@@z@p@33@  @@\)@R@@\@  @{@\)@{@p@
=@
=@@@
@@@\@@陚@H@
@@
@33@H@33@@@
@
@(@z@@@H@p@陚@@@\@p@@@GA z@@
@Q@@  @33@
@=q@A   A A{AA (@@ff@=q@{@RApA=qAA	A33A=qA{A	GAQA=qA(AAGAGAAHA\A(AffA33AHAAAAAGA{AffA=qA@
@G@
=@R@\@
=@@p@@33@@R@Q@@ff@(@@@
@@R@@ff@z@\@@R@ff@
=@\)@\)@GA (@\@@\@@@Q@@A QAG@33A z@R@@@@R@@G@33@ff@z@R@R@ApAffA\)AAAAAAA
=A	AA	A
=qA
AzA
GA\A
A
HAA=qA{AA{AHA{A  A	A	A	pA	GA\)A	A
{A
=A\)@
=A{A@
=@33@@  @\)@G@H@@@33@ffAAffAAHA   A zA AA A Q@{@@
=@ff@@@\)@\@z@  @{@z@{AG@
=@
=@ffA@@33@
=@p@
@@A (AApA33AH@
=@@H@@GA   AGAAA\A\)AGAA\)A	GA	AAA(A  A
A
GAGAAffA
@\)A (A A{A(AQAAAffA
{AQA (@@@(@@z@H@A Q@  @H@@A @@RA   @@A
\A@z@=qARAAAGA z@ff@{@@H@
=@\)@{@(@G@\@z@R@@(@\@R@z@=q@@H@R@Q@=q@z@@{@\)@@ff@R@
@@\@p@{@@\)@@@@Q@{@@@@@  @=q@\)@33@33@G@G@@@@@\@=q@@=q@@ff@@H@Aff@@ff@@@@@@@@(A
AAA	GA@@H@33@@@@  @@33@@z@ff@@{@@p@\)@ۅ@G@G@p@Q@@ff@\)@ڏ\@ڏ\@ڏ\@{@
=@Q@
=@@z@(@@@33@
=@@H@ʏ\@Ӆ@{@  @R@@@(@\)@
=@@G@
=A\AHA @z@RA @\)@
=@p@\)A QA ApA
=A33A
AQAAzAAGA
=A(AzAAAHA @\@陚@33@@@@
=@߮@z@H@z@{@z@
=@@33@H@p@G@
@ڏ\@Q@@@陚@@p@
=@߮@
=@߮@@p@߮@=q@Q@33@@Q@߮@G@޸R@Q@33@@33@@@z@{@=q@G@
@33@pAA
@@@HA A=qAR@R@z@ff@{AA (A QA33A
AzA{A\AA	pA
\AzA
pA
AAA
A
ARAAA
@G@HA @(@@R@@
@\)@{@p@33@H@z@@@׮@  @@Q@ff@ٙ@أ@޸R@@\)@Q@@ٙ@ff@ff@
=@ff@׮@ָR@׮@ff@  @Q@ڏ\@޸R@(@Q@Q@p@33@G@ڏ\@Ӆ@ָR@θR@=q@ʏ\@
@@  @(@{@33@ff@  @  @@
@Q@R@@A@A\)ApAA=qA	A
A
AffAzAAA\)AA  A
HA	A
ffA @A zA\)@A#
=A
HA  A\)AAA{AHAAAHAGAHA
A\ARAAAQA
ARA{A{Ap@=q@@\)A@R@Q@(@(@(@ff@{@@p@=q@
@@@z@Q@=q@Q@@@@@{@{@@@@
=A	A33@=q@A A zARAGAAAffA{A
\AA
ARAAAAA\)AAHA
=AAffA(AHApA(A
A\A(AAAQAAA
A\AQAHA  AA
A
=AAAQ@@(@ffA@
=A
AGA@pA   @@
@@{@\)AA@
=@A   @33@@@\)@33@@Q@\@H@@{A@A z@p@\)@@@ff@zA	GA @Q@@@
=@\)A	GA
=qA
\AA{@陚@@(@33@@@A\A=qAA
=AA
RA33A
A
A
AAA
A(A\)A
=A  AA\)AAHA
=ARA33AAAA(AAAAffA
HAffA(AA
A{A{A
A
A
=AA	ARAQApA(A33AARAA\AHAHA
=Ap@
A   @@@(@@
@@H@@
=@z@ff@@陚@@@ff@
=@  @ff@
=@Q@@\@@33@@A @=q@  @  @@G@
=@@@
=@
=@Q@@ff@ffA\)ApA
pA
=A{AffAAAAAHA=qA\ARAGAAAAQAA\AAzAAffApA{A\)A33A33AA
GAAA
\A=qAHA
=AH@R@GA QARAGA@
@@\)@ff@@\AAHA	AAA
=A(A A zAGAA
AzA
=A(A (@@H@H@(@@@  @@@R@{@  @@ff@@G@@
@Q@@R@@=q@@\)Aff@zAA
=AQA\)A
A\A
=AAA
{AA
A
AAA{A\ARA
=AQA
\A
ffAARAffAAAAffA(AA
A
A(AA
@=q@p@@@@H@z@p@ff@{@@ff@(@z@{@\@@ff@@@G@ff@@=q@\@R@(@A=q@R@\)A (@
AG@
@G@G@(@Q@@z@G@\)@p@p@@AA A A33ARA @33AAffA zApAA{A\)A{AQAAffA
=A(A
A	GA\)AQA
ffA
HA33AA(A(A\AffAA(A
A	GAA(A(A(A33A\)AAA\AGAHAHA=qAAff@@z@z@A=qA @\@
@\@\@ff@RA  AA
=AHA	A
ffAA	AAHAHA\)AARAApAAAAA33A=qAA
=AA\)A A{@HA   A33A  A{AA
{A(A33AHAA
=A(AGAQA  AA (@R@ff@@(@@\@H@ff@\)@\)A   A A @@
=A (@{AffA\)AAA\AA
=A  AAffAA\)AA	A\)AGAA A z@@=q@R@@H@@33A(A
=@@\)@G@Q@A@{@@@=q@z@@@
=A@H@@GA{AAH@
=@@H@@(@(@Q@@@z@Q@
@R@@ff@p@33@\@AA  @AQA  A	AA{A (@33@@A
=A
AG@
=@@G@=q@(@A   @@A ARA
AAAA
=AHA	pAzA(A{AAQA\)A@@z@pA A@
=@\@H@HA (A @\@
=@p@@@@\@(@
@ff@  @R@@@p@33@\@@
@  @
@@33@@{@@=q@
@{@Q@=q@z@p@{@{@=q@@޸R@  @߮@\)@@@{@G@=q@33@z@أ@@ff@@
=@  @
@(@@G@pA @@@
@Q@33@ff@Q@\AA=qAG@
=@RA=qAff@@R@@{@\)@Q@@pA A AA (@\)A z@{A   A (@ff@\@G@@@@H@߮@@(@  @ۅ@ۅ@{@{y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y     y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y     y y y y y y y y y y y     y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y     y y y y     y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AARAA33AA(AzAHAA
=qAAA\AAAffAHA\)A33AAzAQAA	AQAA=qAGA  A  AApAA=qA
=A@ffA\)A
A
=AAAA@\)AA@@
=@33A
=A(A(A{AHAffA\A A@z@(@H@޸R@{@H@A=q@@
A Q@GAA@H@R@@{@33@  @
@A=q@
=@@
=A=qA{A\)A=qAzA  A\)AzAHAffA\)A!A!A A=qA\A\)A(A  A=qA\)AA\)AA
AQA\AGAAA
=AA  ARA	pA@\)@@R@{A@@A QA Q@(@@A QA   Aff@\@R@
=@@
=@=q@@@@\@@\)@\)@߮@  @=q@{@ᙚ@33@@\@@@  @R@陚@Q@=q@@@{@@@{@
=ApA  A
HAQAA\)AAA=qAA
=AAA!A QA
AzA"HA"RA   A
=A
=AAffA
AA#33A(A"RAQAA\A@@AA\)AAR@=qA Q@\Aff@HA QA @
=A (A (A (A A @@@(@ff@zAHAAAA\)AAHAA\)A\)AAAA{AAAAA=qA=qA{AA
=A=qAQAAA A{A zApA A QA AGA@A\AffA=qA
=ApAA
=A(AA
ffA33A
A	A\A33A	A  A=qAzAAAApAAAAff@ff@pAGA  A(AGA
=A{A @@=q@(@@@G@R@ٙ@@@R@\)@@H@=q@Q@H@@
=@p@{@  @H@@=q@G@ۅ@޸R@z@@Q@{@
=@ۅ@{@@33@
@z@@@  @ff@33@أ@  @G@@@@z@@أ@\)@z@@ff@ٙ@(@@33@
@
@
@\)@G@ᙚ@
=@z@G@33@H@@Q@@H@@H@  @\@33@=q@@H@陚@p@z@Q@Q@  @z@  @\)@ff@
=@Q@33@
@{@@陚@@\@R@\)@@p@R@=q@\)@@@(@@߮@=q@H@ff@G@  @ff@
=@Q@z@@33@33@H@ᙚ@@@@  @p@ۅ@ۅ@=q@@ٙ@@ٙ@@G@{@p@@@p@ff@{@޸R@G@R@Q@H@陚@
=@
=@H@
@\)@@Q@@A   @
=A AAAHA
AAAGAA=qARA
=A
A  AA
AAA	GAQA	A
\A
{A	A	AAAA
=A(AA\)A{A\AA  A (@@@@@
=@33@@
=@@=q@G@  @@33@33@z@@(@G@p@@@p@H@  @@ff@@Q@p@(@{@@ff@ff@@@\)@H@R@@H@\@AA\AARAARAG@@
AffAAAA\)A	pAzAA
=A	GA	AHAffAAA\)A\)AA(A\AAA   A{AGA=qAAAA{A\AGAAzA(AQAA
AAA=qA33A33AHA33A{AAA A @  @@\@
@
@33@@
=@@H@Q@G@@{@Q@@@p@@  @  @
=@@@R@\)@
@@\)@z@
@G@@@{@@@\@AG@33A QA QA   A   @{A
=A
RA
=AQA(AAAHAHAA\ARA  A(AA	A
pA{ApA
=A(A\)A&{AA\A=qAA33AA
AAAA
A
A\)A
AA
GAHA
{A	A\A(AQ@AR@ffARA{AAR@  Ap@@A Q@@z@=q@R@@p@@@
=@RA   @\)@zAffA
A@A@p@A z@@\@@@R@\@\)@ff@\)@{@@  @p@G@ff@
=@Q@@33@@p@pA
=ApAA33AQA	GA
ffA
=A{AA A@@@A@@@@\)@@z@H@Q@(A
=@\)@@
=@G@@z@\)@߮@{@H@(@\@@@\@
@@p@@@{@\@ff@@@z@\)@(@@(@=q@@=q@@\@p@G@@G@@@Q@R@
=@
@@@  @陚@RA@@  @z@{@@ff@G@{@@33@ff@G@G@@33@z@@@G@@R@p@
=@
@@33@A
HAQA
A
AGAzAAQAA   A
=A\A
pA
A
A
@ffAA@@ff@
@
=@@Q@G@@{@Q@{@=q@@z@@Q@@@R@H@@z@@H@33@ff@=q@@H@p@׮@R@=q@33@R@@p@=q@ff@AHA
A (@@@@@@@G@@ָR@z@33@@z@@׮@  @33@Q@
=@@@G@H@Q@\@@R@33@  A   AAGA
=AA	pAA
=qARA
AGA{A33AAHAAAAGA{AA @{@@(@\)@@Q@@@@@@R@@@p@@{@@\)@@{@\@33@@33@@@@
@@@G@R@z@{@(@@@=q@=q@\@@G@
=@G@\)@\)@G@H@ff@陚@
=@  @\)@Q@@Q@A@
=A=qA@
=AAQ@RA33AzAAAHA
AAAAAzAA	A
=qAA(A
A{AHA33A  AzApAAAAAA
HAA	A
=A(A	AAQA	pAARA
=A\)A=qA=qAAAAAGA (@@A Q@\)@H@{AA@p@@
@@{@H@\@H@33@Q@p@{@p@=q@@@  @@@@@Q@@
=@ff@(@=q@  @@R@p@A(ApA
AAA
A
AHA
=ARA{A
GA
=qA
HAA33AApA\ApA{AAA
AffAA=qA33A33AA  A	A
=qA  A
ApA	A	A(AAQA\A@
AQA  A{AAHA@\@\A
AAQAffAAffA  A  AQA33A	A(A   @p@@AA{@@@H@@\)@@  @
=@Q@H@(@\)@@z@
@@@(@@Q@{@{@ff@=q@
=@ff@@\)@@=qA AA\A AAAAzAQA	A
=qAA33A	A
=qA
=qA
=qA
=AAQAAA
A\)A
=AHA\AffA	A
ffA	A	A	A  A (A
RAA@z@33A zA@R@@z@ff@@G@p@@Q@@G@H@
=A AA{A @33@\@{@  @R@H@R@{@ff@@\)@R@(@@@{@33@z@Q@=q@@\)@=q@@@  @{@(@@@z@@{@@{@@  @{@\@@@@33@\@@{@(@@@@@QA   @@@@@=q@@z@\@(@RApA33A{A	pAQAzAA
ffA33AA(AA
A
{AA
AHAAGA  AA
=A
=AAAHA{AQA
=AA\)AAAffARAzA{AA=qA
HA(AQA
A
=A	A\)AzAA33AA33A\AA
=A33AAA\)@
=@@@@
@@33@z@{@@H@
@@G@׮@(@G@ڏ\@ᙚ@z@33AG@z@@@@  @
=@z@p@z@@=q@@
=@@=q@Q@p@\@=q@Q@\)@@@陚@p@
@\)@  @33@{@z@޸R@Q@@{@\@@@\)@Q@Q@G@(@@@߮@Q@@\@@p@z@@@
@\)@@33@H@G@
=@@
@@@Q@Q@=q@أ@ٙ@(@
@@@  @  @\)@z@ڏ\@33@p@׮@33@@\)@@z@Q@33@@=q@@=q@(@H@љ@@ָR@p@ڏ\@p@z@@
=@أ@أ@أ@@(@  @z@@{@z@
@\@{@=q@
=@@@@=q@{@H@@ᙚ@Q@Q@G@ff@p@
=@@\@{@@@߮@G@
@@\@@@{@@@ff@  @G@p@@
=@p@RA QAARA(A(A
AAA=qA{AffAffAAzAA  A\)A(AAQA(A{ApAAAAQA33A\)AzAAAA
A
RAQARAA
AffA  A
pAA{A(A (@RAAffA=qAQA(AA@p@ffAzA(ApA{@QA @\)A Q@{@z@@@@
=@H@AG@@ff@@@\@p@  A @33A@R@{@  @@R@@
@p@@G@@(@@@=q@Q@
@Q@=q@@=q@@\)@
=@  @@  @@
=@{@ff@\)@
@陚@@p@
@
=@@ff@z@p@\)@33@@{@p@33@@@ffA (A QA (@H@(@\@p@@p@pAGA A @@@H@z@p@p@33@@@p@Ӆ@@Q@@  @{@\@@33@=q@33@z@H@ff@@@\)@@@@=q@陚@@Q@G@p@=q@(@@33@ᙚ@@p@@H@{@@ᙚ@@@G@ff@@\@G@
=@@  @@߮@
@Q@@H@@  @  @ff@׮@H@@@H@\)@ff@{@ffAp@=q@AAHA	pAA
A{A\A
=A(ARA
ApA=qAGA
AffAHAAAAQAA\)A QA   A33ApAA
=qA   @\)A@p@
@\@@@33@ff@\)@  @@{@@R@@@R@@@{@Q@=q@@z@@33@A z@R@z@  A A (@=q@ff@@p@(@\@@ff@p@@  A @(@@\@{@ᙚ@@\@R@=q@A QA\A\)AARA	A
RAA
@AAzA(AAA	AAAHAAAffA33AA{A\AAA
RA
=qA\)AQA
A  A	AA	pA(AffA
=@@Q@{@ff@{@\@{@\@{A Q@\)AAAffA   @Q@G@@\)@  @\@@p@R@@@p@Q@  @H@\@@
@@p@@33@33@\@陚@@p@@
=@H@{@@\)@@\)@  @\)@H@ᙚ@@  @߮@\)@ᙚ@@(@  @@p@@@{@H@ff@H@H@H@ff@\)@A\@@R@{@RA A Q@\)@@A Q@@@p@p@Q@z@@@ff@(@@z@=q@
=A @(@Q@
=@@Q@  @@(@@@R@HA\)ARA=qAQAA(AAA
=ApA (@@G@H@{@@G@{@@@@@@@@
@@@@@@@R@@\)@@33@  @
@@G@(@=q@@ApA (@z@\@@p@Q@@=q@=q@@@Q@G@@=q@z@R@
@{@ff@33@Q@
@{@@p@أ@z@{@
=@ə@ff@@=q@{@ڏ\@ٙ@(@@@@Q@
=@@\)@z@H@
@
@ᙚ@@\@  @=q@@@陚@  @H@R@  @ff@  @{@33@G@p@@@  @z@@
@
@{@Ӆ@
@Q@޸R@(@@  @@ȣ@ָR@@
=@ҏ\@=q@@\@z@@\@\)@{@\@(@\@@p@@H@@  @@@\@Q@
=@@@(@@@  @Q@@
=@@=q@@=q@@@@@R@@R@\@z@33@(@@33@33@@@
@\@{@G@陚@  @  @@33@(@G@@\)@Q@@
@@\@@z@@ff@@陚@Q@@@@=q@  @\)@z@ᙚ@\)@H@
@@33@ڏ\@ҏ\@H@33@޸R@@  @=q@@H@\)@@
=@z@@Q@@\@{@G@@@@H@33@@H@
=@{@@  @@@@ff@(@33@@=q@
@(@@@@ff@G@\)@@Q@G@ff@G@@@@
=@ff@ff@
=@
=@@                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @(@ٙ@p@(@H@޸R@
@  @(@@\)@Q@@=q@@@ff@\@\)@ff@G@@ff@@@
=@ff@R@ff@@{@  @=q@@R@G@33@(@z@\)A A A@
=@=qA   @R@@@Q@@@\@@H@33@@
=@@=q@p@=q@\)@
=@=q@@ff@ᙚ@߮@ᙚ@=q@@\@@\)@@H@  @޸R@߮@33@{@G@
=@(@ڏ\@G@@@=q@@\)@ڏ\@@{@{@@ᙚ@33@@  @ff@Q@  @=q@  @
=@߮@H@ٙ@p@@@H@@@p@{@@@\)@G@\@\@=q@
@(@@@\@\@\@\A A AQAAffAGAA@
AffA @@G@\@H@@ff@G@@R@\@
@G@@\@@z@z@@z@z@p@陚@@\@
=@@@@=q@@z@Q@ᙚ@ᙚ@
=@z@߮@H@ᙚ@=q@\@
=@\)@@33@\@@z@
=@{@p@ff@@Q@@
=@
=@@@@=q@@
=@{@@@p@33@A{A A @@=qA=qAAA\)AApApA(A\)AA\)A\)AA
HA
{A
=A
=qA33ARAGA @(@R@
@H@z@R@33@z@(@@33@=q@@@H@=q@@G@@@(@H@@ᙚ@@\@
@(@33@@G@ᙚ@@@(@z@ff@\)@(@ff@
=@z@G@G@z@@޸R@@@H@޸R@@@(@p@\)@ff@
=@@G@R@Q@陚@R@z@@@\)@@
=@(@@R@@z@@@A   @ff@@@R@
=@ffA A (A@@\)A z@@
@ff@@@p@z@
@
@H@H@  @@\@(@=q@{@@Q@(@
@
=@=q@G@@=q@33@@=q@߮@@@ᙚ@@G@@\)@ff@@p@ff@@z@{@p@޸R@@p@\)@
=@
=@(@{@=q@ᙚ@@@\)@@޸R@\)@Q@
=@(@@=q@=q@p@Q@H@@G@p@@@@@  @(@@(@Q@@@@@@G@Q@H@@@  @(@R@@@\)@\)@p@z@@
=@R@G@G@@(A A\AGA
A(AzARA\AAQA
RAffA
pAA  A
AA(AAAA
=qA	A\)A	GAA
A
ffA
RA	AAARA
=A A @@
@\A\ApA @
=A A z@\)@A @\)@R@{@\)@ff@@{@R@\)@ff@=q@@{@{AGA z@@@@ff@@33@RA@H@@=q@@@@@@{A @33@@z@@@  @H@@@޸R@@  @@أ@
@  @
@@ᙚ@(@z@H@@ff@@\)@p@p@\@\@{@ۅ@(@H@Q@\)@\)@ff@{@
=@
=@Q@p@@(@@=q@\@@ۅ@Q@=q@@@33@=q@ᙚ@H@@(@z@@@@G@=q@=q@R@@p@(@@@@G@33@@
=@Q@Q@@\@\@ff@(@\)@@@@
=@R@@ff@z@z@@@@p@@G@@z@@@H@@  @=q@@G@陚@Q@\@{@z@@  @@@
=@z@{@@@
=@R@@  @ff@@(@H@z@\)@\)@Q@  @@{@@{@@@ff@߮@@\@@z@Q@@{@陚@ff@{@ff@@H@@\@G@=q@H@=q@ᙚ@H@(@(@
=@{@{@  @@\)@  @R@@
=@AA Aff@{@\)A{A  AA\)AAARAA	GAzA	pA33A(A{A\)AA(@\@H@H@@@p@p@z@=q@陚@@@  @Q@
=@{@\)@R@@(@@(@޸R@=q@(@
@@@\)@@{@z@z@@{@{@@ff@ff@@@  @\@=q@33@@
@(@@@  @{@z@陚@@@Q@33@G@ff@\@Q@z@陚@=q@
@@33@zA@A@\@33@z@\)A A QA\A(A
=A
=ApAAApA{AAARA
ffAzA
=A
GA  AA(AA
=A QA   @@z@p@  @(@H@G@@@@@@Q@=q@
=@  @p@33@@ff@@
=@@ᙚ@
@p@R@\)@@\)@@(@z@R@=q@G@{@陚@陚@@33@  @33@p@G@@p@Q@\)@ڏ\@\)@@{@\)@33@G@@(@\)@
=@=q@
A A A
=AA
=A	AAAffAA\)AA
A=qAHAHA\AA#
=AAA33AAGA!A!AHA\)AApAA(A
A
=A@
=AQAp@p@
=A=qA
A
{A=qA  A
R@A@ff@z@z@@p@@\)@@
=@@ff@@  @@
=@陚@@H@@{@
=@  @@@
@H@z@ff@@z@@@G@
@ffA AAGAA\AAAA{AQAA\)AHA(A	A
AAA
AA
{A
ffAA	AA\)A\)AA  A\)A@A{A(A
A
=AAzAAAGAA\)A
=@p@(@@  @  AAzAAHA
ApA"HAGA\A\AGA\)AAA
=A AAQAA\)AA\)AzA=qAA  A\)AA AA
=A\AQA(AQAAAAAQA
=AAAAApA{A\AARAAffAffA\)AA
=A\A\)A33AA  A\)AAAA
=A	pA
=A  Ap@  @R@z@(@@H@\AAffAHA{@AHAA @R@@H@@
=@ff@Q@Q@p@@@=q@@  @=q@@p@@{@G@H@\)@
@(@@@z@@陚@  @\)@33@@Q@\@@G@{@Q@p@
=@z@(@Q@\)@ȣ@@
=@@
=@љ@@z@G@H@G@
=@ָR@\)@˅@{@ٙ@\)@{@@@߮@  @(@ᙚ@G@ff@  @\)@  @@@  @\@G@33@=q@33@p@H@޸R@ۅ@@@(@=q@@@{@z@33@@{@H@@@\@(@Q@@@陚@G@@@陚@33@@(@ᙚ@
=@@H@(@\@@@@ff@@p@@ڏ\@׮@  @ٙ@G@ڏ\@ָR@(@ff@  @(@@G@  @=q@
@ָR@@{@@@H@{@z@@@@{@Q@z@ᙚ@z@\)@
=@G@\@
=@  @(@\)@@H@
=A=qA33AA
AAffA  A(A\AzAAA	A
\A\)A!A%A$QA
AQARAA,QAHA	GAA  AAA33AA\)A QA Q@@=q@@=q@@  @G@ff@@@@z@=q@R@@ff@@A Q@@@@R@\)@\)@@\)@@@H@(@ٙ@@H@(@@z@G@@@У@
@{@ff@=q@  @\)@ٙ@ff@@
=@33@ʏ\@{@H@@أ@
@@@  @A ARA
HARA33A(AAA
\A33A
AA (A\A
=AGA\ARA(AA
A33AQA33A\)A
=A	pAAA=qA
ffA  A
RAHA z@Q@Q@A   @ff@@ff@p@@R@@@@R@ff@@  @߮@陚@33@H@(@@{A @@\)A @@pA   @z@@@Q@@33@@H@H@(@@
@H@@׮@z@
=@أ@p@z@Ӆ@(@z@أ@  @{@(@  @=q@@Q@Q@(@ٙ@  @ᙚ@p@@@@p@@߮@ff@\)@\)@@z@\)@@G@@ᙚ@ۅ@@
=@@{@
=@H@@\)@޸R@H@@  @@
@G@@G@33@=q@p@޸R@
@z@ff@  @ٙ@  @=q@\)@ָR@p@  @33@У@ff@Ӆ@Q@@{@
=@p@
@33@ۅ@@@أ@޸R@{@(@ٙ@
=@=q@33@
@33@33@ڏ\@Ӆ@\)@@p@G@33@@@  @33@33@z@@ff@@33@ڏ\@
=@\)@
=@@@޸R@G@@@
=@Q@@
@\)@ff@ᙚ@33@@@G@\)@33@=q@@H@(@33@@@@33@=q@陚@@(@G@@  @ff@@{@z@
@@  @G@ᙚ@\)@
@޸R@أ@\)@@ff@޸R@p@\)@=q@H@Ϯ@У@  @G@θR@\)@׮@ff@׮@ٙ@33@ff@p@(@Ӆ@ָR@=q@G@@ָR@G@p@z@33@ٙ@޸R@ff@  @@G@z@{@H@  @@У@Ӆ@@@=q@H@@(@
@@z@{@@ff@@{@陚@ff@@z@{@@
=@  @\)@\)@@p@@H@\)@\@R@
=@@R@Q@  @
=@
=@{@@H@߮@H@@\@Q@ҏ\@ٙ@@أ@@ff@ڏ\@@@
@ڏ\@(@ۅ@=q@@33@
@=q@θR@@߮@H@޸R@ۅ@z@ٙ@
=@@@(@@љ@љ@=q@@\)@G@z@z@z@ff@
=@׮@@z@G@@p@\)@  @\@@G@  @@ff@
=@\)@33@@z@\@{@(@G@@H@@@33@G@@@  @z@\@ff@@G@\)@\@@@\@G@
=@{@=q@@\)@@z@\@z@@@=q@\)@R@Q@\)@ff@p@p@@\)@\)@\)@\@@=q@=q@33@  @@@@\)@\)@  @R@Q@33@
@@z@{@p@ۅ@33@@
=@G@(@p@أ@@\)@@޸R@  @@G@\)@@Q@߮@ff@أ@أ@@p@@p@  @@\@\@@ᙚ@(@@33@@ff@@R@R@@@(@33@H@@Q@  @@  @@@\)@@@@H@
=@G@R@Q@@@  @{@H@
=@@R@
=@{@@@z@
@@Q@陚@H@@{@Ӆ@=q@@@@p@z@@p@
@{@\)@@@\@=q@
@=q@{@@z@@@G@ff@=q@@
@p@@(@@{@@
@zA33A=qARA{AAHAA{AzA
GAffA
RA  AQA
HAA  A  A  AH@(@(@\@@(@@@
=@@=q@@
@@\@  @  @\)@ff@(@\)@ff@\@H@H@33@
@@p@@
=@@  @@ff@R@  @@{@@R@{@p@=q@33@@
@أ@33@
=@߮@H@@љ@(@@љ@
=@G@߮@=q@@@@@@  @@(@(@@  @@(@ڏ\@z@z@=q@{@\)@p@\)@H@@pA   @pAARA{ApAA=qAARAA@RA  A
=q@{@
=@=q@zA   @@\@(@@@陚@@@@@
A@@z@{@@Q@
@ۅ@G@p@Ӆ@Ӆ@\)@z@޸R@@
@{@ff@Ӆ@z@@θR@
=@@@
@z@ff@=q@θR@@@G@zy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y     y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y A$zA$QA
AffAzAAAQA(AAA
AA=qA\)AA @@ff@@H@33@ff@G@G@@A\)A
\A
AAA
@pA A ApA @(@@\)@z@@\@  @@@@{@H@H@=q@G@z@@  @
@(@@
AA{A@@AGAffA
=A'A
=AARA%A&RA(A'33A)A*{A+\)A+\)A(zA/
A+\)A&ffA%A*HA/A333A8QA;
AB\A=A:HADQA@QA>{A>{A>ffA:RA:HA3A,A  AGA!GA/A	AzA
A\)A(A%AA  A(A\A(A
AA
AHAA\AQA  A
=AffA\)AHA(A
=A
AzA{AQA  A\ARA=qAA=qA
RA
=@Q@\AGAA AHA	A
\AzA=q@
=AAA
AA
=A33A(Aff@
@AQAHAA!A A\AA&\A)pAA
=A'AA,A2RA)A#A-A0zA"ffA+33A0QA&\A"RA$A0A8QA8QA.\A*HA*\A
AA!AffAA
A
=AA
AffA
A Q@Q@
=@Q@@@@
=@z@
=@R@@@@ff@p@A@z@AAAA
A@\)AH@A{@A
=@(AffA A@
@R@@@=q@33@\)@33@  @
=@(@A
A (@Q@ffA QA\A=qA  AA(A	pAAA
=qA  A(A=qAAAAAAA{AA
AzA
A\)A=qAA
=ARA33A\)AHA  AGA AAA @ff@(@G@@=q@  @{@@(@G@
=@@\@@@ᙚ@G@G@@=q@@@G@G@=q@G@@
@@p@  @{@@  @z@p@
=@Q@
@33@=q@33@@H@=q@@ff@У@z@@G@33@@ff@@@@@@=q@{@@R@=qAA	A	AAA\AHA ApAA\)ApAAA
HAGA\AffAAA33A
{AAA
ARA A @{@\@@=q@Q@ff@z@@\)@@(@@\)@@޸R@(@z@(@@ڏ\@ۅ@أ@
=@
=@@Q@p@=q@z@Q@G@
@\)@\)@(@@p@(@z@@\)@ff@@Q@ٙ@H@H@ff@  @陚@
@@G@(@
@R@\)@ff@@  @33@陚@=q@A=qAA
ffAA
HA
A	A	AAAzA   A
\A
\A
ffA	A	GA
RARA=qAQA(A  AARARA=qAffA33AAAAARAffAA @\@@{@H@z@H@\@@@@߮@Q@@߮@@ۅ@ۅ@
@33@(@@33@
@@@G@@@{@@{@H@@(@H@\)@(@H@
=@G@p@@z@@=q@ff@H@
@H@ff@ff@@=q@z@H@H@H@ڏ\@
=@@=q@(@@A (A{AA33A  A(A\A{@@@Q@\)@\)@G@
=@
A AAAAQAAAA (Aff@H@(A	@
@@33@@33@=q@(@@@G@@@@G@@@  @޸R@޸R@@ᙚ@@@@
=@G@  @
@ۅ@@@@@33@޸R@Q@@=q@@{@  @33@@
@{@G@@@33@@z@G@׮@أ@ۅ@Q@=q@{@  @R@
=@Q@Q@(@ff@(@@=q@@陚@G@z@@@G@@A AAA{ARAA
=qAAA(AffA @@z@@@@@
@@@\)@@p@
@
=@@@\)@\@=q@
@
=@  @@@33@޸R@@޸R@{@(@\)@(@ָR@
=@{@ff@Ϯ@z@ʏ\@@@
=@
@ʏ\@˅@У@θR@@@p@@  @p@
@  @=q@@\@@@
@@@  @θR@=q@z@׮@33@ָR@أ@ٙ@ۅ@H@H@G@
=@߮@G@
@p@@G@z@\)@@(@H@\@33@H@=q@
=A zA=qA@HAGA@ffA @RA A A @  @@
@
=@Q@@H@33@G@@=q@@
@@(@ۅ@@أ@@ff@ٙ@=q@G@@@
=@{@@@{@@=q@\)@z@@{@
=@ff@33@Q@׮@@
@׮@
@@@=q@Q@ָR@׮@߮@ᙚ@
@@G@=q@\@@@@@R@@H@@
@\)A
=AQAffAHA	AA
AAHAAA
A  AAA  AAffAAHAAzAA
AA
AQAA
A
A\AQAA{ARA\)A
{A33AARAHA Q@(@@=q@\@@@=qAA
A33A(@R@@@@(@@H@@
=@33@Q@z@陚@@ff@ff@33@@@H@=q@H@@
@@z@G@@Q@@\@z@@AA
\A\)@AG@\A=qAAAffA	A
AAAHA
=AzA
ApAA
AffAA\)ApA
=A	GA
{A
=AAAAA	pAA{A\AQAA @H@R@@@@p@  @=q@@Q@R@\)@
=@ff@G@{@\)@A (@  @\)@@z@@Q@\)@@@
@
=@
=@@
=@  @\)@ff@p@@(@
@(@z@@Q@@z@(@H@@pA z@
@
@@@@H@
@Q@pA
{AARA\)AGA\AGAAAAA"=qA$A(A,QA*\A"=qA.HA/
=A1A.RAQA  A#A/
=A#33A"=qAAA\)@(@(@pA  AzAA=qA zA  A
=A=qAARA(@@\)A @zA @AAGA Q@@@(@=q@z@@@@\)@  @޸R@ᙚ@\@H@ᙚ@\)@@߮@@H@߮@  @G@G@\@@p@p@Q@z@\)@@@@(@R@@陚@@A(AGA=qAAHA\)A\)AGAAAQA\AHAA33AffA QA{A33AA\)AzA  AzA
A
GAzA=qAA
pARAAA\A\)ApAHAA
=qA33A{A(A
AAQA
AAA\)@@33AA   A   @R@{@A=qAA(@G@\@\)AA{@Q@G@@G@=q@ff@p@p@@@@@@@ff@p@ff@R@@z@p@
@Q@GApA@@\@R@R@
=A   AAARA\)A
=qA
A=qARA
=A
pA{AHAGA=qAzAAA
AAApAffAffA=qAAHAzA  AA(AQAzAAffA	GA@zA   A @ff@(A33A A
=@{@@(A@G@@(@=q@=qAHAA\A
=AffA
=AzA33A
A
\AA@@=q@  @pAA (@G@@@{@@z@\@(@{@@R@@p@{@R@z@(@ƸR@@ff@@G@G@A{A	pA  A
A  AzAA
AHAA  A(AHAAA33A{A
AffARAARA QA"=qAA%GA&=qA(zA(QA)GA(A%GA"\AGA33A(A33A=qAR@R@@@  @\)@zA@  @33AR@=qA   @=qAffA\AHAGAp@A ARA @@R@\@ff@@\)@@Q@
=@\@\@
=@(@{@G@\@{@p@@R@@G@@@p@@ff@@R@@H@陚@=q@@@H@G@G@QAHA
=A
HAAAHAA=qAA\)A (A#
=A$A%pA'33A'33A'A'A33A$A$@ARA{ApA=qA
ARA=qAHA zA=qA@ff@@@
@=q@  @Q@R@@@(@33@p@޸R@@G@@@@p@ff@33@H@ff@@=q@33@z@\)@@G@޸R@ff@p@{@p@أ@z@=q@ᙚ@@@p@ٙ@ڏ\@p@ٙ@
=@ff@(@ff@\)@@
=@=q@@H@Q@R@R@
@@H@ff@@ff@H@=q@{@Q@@
=@@(@z@{@\)@@=q@33@H@@=q@z@R@
=@z@@@Ӆ@\)@p@@@33@@أ@љ@\)@\)@z@(@z@33@@p@  @ٙ@У@\)@
@
@Q@=q@33@
=@(@
=@ff@z@\)@˅@p@@=q@@@
=@H@ƸR@
@33@H@@@Å@Å@
@{@ff@ə@@H@ȣ@{@z@33@z@Ӆ@@{@z@=q@\)@(@  @G@@33@@(@@G@@  @  @  @ۅ@ٙ@@z@\)@\@(@  @33@@H@@\)@\@@33@=q@z@@p@@ff@@33@ڏ\@Q@@@  @ҏ\@=q@  @љ@
=@У@У@@У@Ϯ@Q@p@ff@@Ϯ@Ϯ@@\)@\)@
=@Ϯ@
=@Q@  @  @ff@Ϯ@@{@@˅@ʏ\@
@z@@
=@\@
=@{@  @  @ff@(@@G@ff@G@R@p@z@ff@p@@@\@@@Ϯ@33@@H@z@\@Q@G@@33@
@@\)@@R@
@H@(@@Q@\@
=@@@33@(A QAz@33@@
@
=@@  @
=@أ@@ff@أ@z@p@
=@  @@׮@
=@Q@33@޸R@޸R@ڏ\@ۅ@(@G@\)@@ָR@ָR@@
=@p@{@أ@\)@@\)@
@=q@\)@p@Ӆ@(@p@Å@H@
=@(@R@@
=@33@@z@G@@\)@@
=@H@ᙚ@@R@@\)@\@H@{@@R@G@@Q@@\@z@
=@{@ff@@\@{@\)@ffA
=ApAzA\A\)AARA	pA
=A	A
ffA\@@@@@AA
{AAA@33@\@@Q@Q@@ff@@=q@@@R@\)@R@ff@Q@@(@
@@p@p@=q@
=@@@@  @ۅ@
@ڏ\@Q@Q@\)@{@p@(@{@\)@@H@޸R@׮@G@@Q@ٙ@@HAGA (@ff@Q@  @A QApARAA  @@@\)A @@
@{@@@@\)AHAA\)AAA\AQApAffAAAAA@@33@33@R@33@G@@@@
=@
@ff@\)@R@{@{@@z@@{@@@
@@z@H@=q@=q@@أ@
=@޸R@
=@
=@\)@\)@\)@޸R@{@޸R@Q@@  @߮@\)@޸R@޸R@\)@@{@z@@{@Q@@H@@33@@=q@(@=q@z@p@@p@(@@{A QA  A\AA	A
ffA
A
\A(AzAA=qARAAAAzAQA33AAA{AApA{A\)A{A{AA=qA
=AzAAHAA\)AA=qAzA
AAAffAQA@@@33AR@Q@@33@33@  @@HApAA @A (@@
A @z@ff@
@\AA@z@\)@@@33@  @
=@H@G@=q@@@@@@
=@{AAA
=A
=qA
HAA
{ARA\)A\AQA
ff@(A\A=q@A
\A	GA\AzA\)AA\)AA Q@z@@  @@{AAffA  AA   @ff@@33@@p@G@  @@{@
@@33@=q@@@G@@p@@(@=q@\@\@@33@=q@=q@
=@@ff@{@ٙ@=q@  @أ@أ@H@z@ff@{@@33@@ff@У@@@׮@G@ٙ@@=q@G@@ڏ\@ڏ\@ۅ@@{@\)@H@ʏ\@У@@p@ff@@\)@@
=@
=@@(@z@Q@@Q@=q@G@ᙚ@ff@
=@
=@ə@@@ָR@@@G@@@H@33@ٙ@p@ָR@p@z@\)@H@Q@G@  @ff@Ϯ@@\)@Å@H@
@G@ȣ@˅@ʏ\@
@@@@@ʏ\@(@
@ʏ\@(@=q@@{@{@ff@Ϯ@У@Ϯ@@˅@=q@(@@z@{@ff@p@ʏ\@p@(@
=@У@\)@θR@@ff@z@@{@ff@\)@У@@=q@@{@
=@  @33@@ҏ\@Q@Ǯ@ə@@H@
@ҏ\@(@  @{@@  @@H@R@@z@ff@  @@H@@{@33@
@ff@33@ᙚ@ᙚ@أ@=q@ᙚ@z@G@33@33@H@\)@ٙ@{@ָR@
=@ڏ\@H@ff@޸R@{@=q@G@  @ۅ@@أ@أ@Q@ff@33@@=q@љ@
=@Q@ָR@Q@@z@@p@33@ƸR@@@@=q@@˅@33@@˅@@z@p@{@׮@Q@
@G@  @@@=q@ʏ\@
=@(@׮@ҏ\@Ӆ@G@  @ۅ@=q@@@ff@{@@ָR@@@ڏ\@޸R@Q@33@
@z@H@=q@z@z@\@\)@G@@R@\)@(@أ@׮@=q@\)@G@{@@@
@@Ϯ@H@˅@θR@Ϯ@=q@=q@\@R@@
=@\)@@(@H@H@Ϯ@@p@Q@33@@R@R@z@
@G@\@
@ff@(@@(@@\@G@@H@
@\@@
=@(@z@Q@{@Q@Å@ff@=q@=q@
=@
@G@
=@p@  @z@\)@(@˅@˅@˅@ff@G@(@
=@  @ڏ\@@G@ҏ\@@z@  @@=q@
@@{@@z@@p@(@@
=@H@˅@H@@@ƸR@@@\@=q@@\)@(@R@@{@@z@{@(@z@
@@@@@(@=q@\@H@@G@\@
@33@ff@@R@{@@ff@(@@@{@@Q@@{@z@@p@  @@Ǯ@˅@G@˅@p@z@Ϯ@=q@@Ӆ@z@G@@p@  @(@
@H@33@(@@
@ۅ@=q@@ָR@\)@@ٙ@@ff@ff@@R@R@@@ᙚ@@ff@@@=q@
@Q@أ@ָR@ڏ\@H@z@
=@Q@H@
=@(@
@@33@Q@=q@33@H@
@
@˅@@\)@θR@љ@{@@ff@Ϯ@θR@
@=q@
@H@@ҏ\@\)@Ӆ@p@ҏ\@
=@@@@˅@@@\)@ҏ\@Ӆ@G@Ӆ@@ڏ\@Q@ڏ\@p@@G@
@\)@\@z@
@33@{@
=@@R@@@  @33@  @\@@@H@G@33@@G@@@
=@33@A @A@33@\)@z@z@@@p@H@\@@Q@@\@z@@z@z@\@߮@@
=@  @߮@@\@\@@{@@޸R@33@33@@33@z@(@@Q@׮@@(@(@ڏ\@ڏ\@љ@G@(@33@ڏ\@G@ڏ\@(@ۅ@H@@(@p@(@z@@
=@  @Q@G@G@ٙ@޸R@  @\)@\)@33@z@=q@Q@{@@G@R@z@@A zAA33A
AQAzA
=A
A  A\)A(AAz@A(AffA AA  @RA@z@Q@z@p@{@H@
=@@@Q@p@z@33@@G@@޸R@@@@33@ۅ@
@
@
@H@H@=q@ٙ@ۅ@޸R@@{@\)@(@H@z@  @Q@z@(@G@ۅ@@p@ۅ@@ڏ\@@ڏ\@@H@
=@@\@G@@G@H@H@
@33@@p@Q@H@z@p@
=@@(@@p@ffA (A A{AHAAA{A A ApAAHA33AffAHA=qAzA33@p@@@p@陚@@(@@@
@@\)@
=@߮@G@Q@@\)@p@z@(@@
@H@G@ٙ@޸R@@Q@\)@G@=q@z@
@33@(@z@@  @G@G@=q@(@{@p@\)@(@33@33@33@(@
@Q@@ָR@@׮@׮@أ@  @أ@ٙ@H@z@
=@
@G@(@@@@R@AA  AQAA\)A
A
{A
RA	AGAQA
ffA@
=A{A{@(@{@=q@@33@R@@@߮@\)@@
@ڏ\@H@H@@ff@p@ff@ff@@@ff@@ۅ@G@\)@=q@p@@33@ᙚ@@ff@z@{@z@
@ۅ@@ff@
=@׮@
=@  @@z@ff@أ@H@׮@ff@أ@@Ӆ@
=@Ӆ@Q@Ӆ@z@أ@  @Q@
=@ff@@(@Q@@\@
=@G@\)@@z@߮@@@@  @G@H@G@p@z@G@@A (AA33ARA{AGAA  AA(@R@
@@@@@Q@ڏ\@׮@{@@G@G@p@ҏ\@G@љ@Ϯ@θR@
@p@p@θR@ff@p@{@ff@Ϯ@Q@@@33@@{@@=q@߮@G@\)@@@@
=@Ӆ@{@Ϯ@z@{@
@θR@@
=@@z@љ@
=@׮@  @ff@@  @أ@  @@ff@p@@@=q@@ff@p@@@G@\@\)@\A A AAAGA33A=qA	AA	AA(AQA
AAQAA @H@{@@Q@@
@33@陚@R@{@(@@@
=@@\@=q@\@  @(@
@33@G@  @
=@@ָR@p@
@H@(@@@@@33@=q@ҏ\@\)@{@p@z@@@@{@33@H@@љ@z@33@@G@ڏ\@33@33@@{@Q@  @H@@
@z@@@ff@p@
@@@@p@G@  @@@@@(@@33@p@@\)@(AAA
=AQApA	A	A33AffA
AHA{AGA
\AA  A\A
AAAA@RA (AGA   @@ff@@@G@Q@@{@ff@(@(@@
@@\@=q@z@@Q@p@@  @@z@(@@@=q@@
@Q@R@
=@ff@@
@p@z@@z@  @
@(@{@{@{@AAA\@pA(AHAA	A\AffAA
=AHA	GAzA
RA
=A{A\)A\A
A
A33AAAffA
HA	A	A\)A
HA  AA33A  A(AAp@ff@GA@=q@R@H@
@@@Q@\@@@
@R@@  @G@  @ff@@׮@G@߮@H@{@
=@z@33@߮@\)@
=@ff@޸R@Q@
=@Ӆ@33@(@ָR@@33@Q@׮@G@G@@@@z@33@33@@33@Q@=q@(@ff@  @=q@(@Q@{@33A=q@
@\)@pA\)A\A{A
RA
=A  A33AffAA
=AA\)A  AA\)AAGAApAAAAAA	GA
AGAAffA=qAA
RAQApA@@pAH@A@GA @AzA\)A
=A
HA
=A QA A@A\)A{AzA A=q@{@\@33@@@G@G@@Q@\)@@(@@@
=@G@陚@33@=q@@\@z@{@@@pAffA AA(A\)A	A
{A	pA
ffA
HAQA(A
GA(A
=AQAA\A=qAA\AAARAQAAAA"=qA%pAA{AzA\)AAzAA
=AQAGAAQAA=qA
HAGA
GAApA
A(A
RA  A
AAA\)A{AQA	pAA@
A A (@A A33@\)@R@@{@
@@=q@@G@\@G@@  @R@\)@=q@\@33@@  @33@
=@{@@H@(@@@@p@@\)AAA(A{A{ApA33AQApA\AA33A(AA(A\A(AQA{A{A A A"=qA"ffA"HA zARAAA(A QA!pAAAQAHAAzA
AzA
RA
=qA(A  A	A\)AAAQAA33A{A{AffA Q@@\@@  @
@@33@=q@R@\@p@@
=@@
@G@=q@
@p@޸R@ҏ\@љ@=q@@ff@@=q@(@{@Q@@
@
=@@H@\)@Q@\)@RA{AAA	pA
ffA33AAGA	A  AA\A
AQA{AAGA\)AGAzAA{AQA{ApA33A@pA
A
\A
HA	ApAA
=AA\A33AffAAApApA(AHA
A@ffA(A=qA z@
@33@H@@ff@p@@@߮@@@(@G@(@R@(@{@@@z@
@޸R@@p@Q@p@p@=q@R@@p@ff@
@Q@@@z@@(@A   @z@A A{AA
=A(AA	AA\)A  A
AA
AAA	pAAA  A  A (AA
ApAA{AA@\@@R@(@=q@@
=@@@@@\)@@(@
@@
=@@G@@G@@@=q@@
=@@
@=q@@Q@Q@G@@  @Q@@33@@
=@{@\)@p@ָR@z@{@\)@\)@p@@33@33@Ӆ@33@H@У@(@ʏ\@@ʏ\@
=@ȣ@Q@Ǯ@Ǯ@ƸR@@
=@ƸR@@  @
@@Q@=q@@ָR@ʏ\@@@@ᙚ@33@=q@ff@{@@\@\)@
@\)A@\)A
=@ff@33@@׮@ۅ@ָR@Q@  @Q@Q@Q@(@@@=q@\)@\)@@\)@  @@p@ff@{@p@љ@ff@\)@
@θR@@p@z@Ǯ@ə@ʏ\@
=@{@G@ff@ƸR@(@ʏ\@
=@ƸR@p@z@@H@  @ff@@@
@(@=q@Q@Q@R@p@@@@(@=q@\@@R@Å@
=@
=@@\)@Q@
=@
=@@˅@\)@Ǯ@Ǯ@@H@Ǯ@@z@@(@z@@p@˅@ʏ\@@\)@G@љ@H@H@p@  @Ӆ@=q@@Ӆ@{@Ӆ@@p@ָR@@ҏ\@=q@  @z@p@{@H@ڏ\@
=@p@˅@p@=q@@ȣ@p@G@\)@
@ʏ\@ə@  @@
=@@Å@\)@@@33@{@@@@Å@@
@H@G@@G@@@@@\@\@@=q@@G@ff@33@{@Ϯ@ff@У@  @@H@=q@ƸR@˅@
@
=@{@@ٙ@33@{@(@ۅ@@
=@߮@Q@߮@@Q@\@@Q@@p@
=@Q@
=@G@@{@@
@
@
@@  @Q@ff@H@ff@@\)@@@@  @H@@z@
=@p@ᙚ@G@H@H@@
=@߮@  @Q@=q@޸R@p@@33@@z@
=@ff@@
=@33@@ۅ@ۅ@@
@p@{@ʏ\@˅@z@@33@@G@  @  @أ@׮@ڏ\@@@p@Q@@@G@G@׮@=q@@@ff@=q@=q@z@@@@@{@H@H@z@@ff@\@@p@(@@@@{@Q@
=@\@  @\)@=q@p@
@R@G@\)@(@G@  @(@@@׮@@@@
@@=q@
@=q@љ@G@@z@ff@G@=q@@@Å@@@ff@@=q@@H@G@@
@@ʏ\@@p@@@
=@ҏ\@љ@z@љ@ҏ\@Q@
=@ff@
=@@@@H@\@@(@@@A
=AzAzAA\AHAA=qA (ARAffAA
A(A=qA @ffA   A A{A AA
AHARApApA A@@
=A @@@@@@@p@@޸R@  @@Q@G@ٙ@z@\)@׮@@{@
=@@@@
@
=@p@@ff@
=@Q@أ@@p@=q@z@H@{@ҏ\@z@z@@@33@G@H@  @p@@
=@ƸR@=q@ff@@z@  @@{@@H@(@p@\@33@33@\@33@\@=q@G@p@Å@z@H@
@H@@=q@@ָR@  @
@33@
=@@Q@\)@{@33@@R@33@@@G@
@@z@
@@G@p@ff@{@Q@@{@{@z@Q@Q@@@{@\@R@Å@H@Å@G@33@@
@=q@@Å@33@@p@Q@\)@
@@
=@
=@\@
=@@G@33@@=q@G@  @
=@@H@ƸR@Ǯ@z@@@z@@z@{@\@
@p@(@θR@@Q@˅@{@
@33@=q@G@=q@
=@\)@{@@=q@ʏ\@ə@@˅@ȣ@33@Q@=q@z@(@z@ff@p@{@  @ƸR@ff@ff@@Å@p@ƸR@Å@
@@@ƸR@Å@@R@@@
@Ǯ@{@\@@(@@(@(@p@  @\)@θR@@(@Q@G@@ҏ\@ҏ\@ҏ\@=q@У@љ@θR@
=@33@@=q@Ǯ@p@@ȣ@Ǯ@Ǯ@=q@ə@θR@z@@
=@\)@θR@Q@Q@H@33@H@Ӆ@
@(@ҏ\@@  @ٙ@H@ۅ@@p@{@{@{@Q@
@Q@{@33@@(@H@33@@@{@
=@@ff@\@33@@@ff@G@߮@G@G@Q@  @ָR@׮@=q@ٙ@Q@׮@@ָR@׮@@Q@G@׮@
=@ff@
@@33@љ@\)@  @@
=@У@У@Q@\)@\)@Ϯ@
=@{@@z@@˅@У@
=@
@˅@(@
=@@33@
=@Ϯ@{@H@@z@{@@ff@Ϯ@z@ָR@\)@@z@@@p@@ۅ@@@@\@
@p@@33@  @=q@33@p@G@G@@  @@ff@{@z@33@@߮@@@33@(@=q@G@
=@
=@p@@@33@33@ҏ\@ҏ\@@@@У@Q@Ϯ@Ϯ@z@أ@أ@33@Q@ҏ\@H@
@@(@(@z@
@@G@G@  @ff@@
=@ff@ff@θR@{@@@(@{@
@θR@У@(@p@
=@=q@׮@p@
=@@Ӆ@@(@
@ڏ\@z@ۅ@@
@
=@
=@  @{@@33@R@@G@z@R@@@@@R@@H@(@z@
@@  @@Q@{@@
=@G@=q@33@Q@@z@H@Q@{@@@H@G@
=@G@33@޸R@@{@޸R@ff@
=@޸R@\)@@@=q@{@޸R@(@޸R@33@
@@߮@߮@\)@@@@G@@أ@أ@أ@@θR@ҏ\@@ff@=q@p@ָR@33@ٙ@(@ff@\)@@@@\)@@Q@
@\@
@z@=q@H@G@ff@33@@  @@ff@@H@33@@@G@@@=q@Q@(@陚@@  @Q@@@@{@@H@G@H@Q@
@H@\)@
=@׮@Q@Ӆ@љ@
=@33@ָR@@ٙ@Q@  @أ@\)@
=@  @ٙ@أ@{@ff@ff@p@p@\)@p@@ָR@\)@θR@z@
@
=@z@˅@=q@ff@G@Q@ff@θR@33@@Å@Ϯ@Q@@Ϯ@{@
=@(@Ϯ@@@θR@H@33@z@G@љ@@p@G@  @(@Q@{@@@(@
@=q@@p@RA @\@(@@@
@陚@Q@Q@@@陚@陚@@@H@@@z@{@z@
@33@=q@\)@
=@(@ۅ@@@@{@H@ָR@33@{@@z@@@{@{@{@ff@@(@z@=q@ۅ@H@=q@@Q@Q@\)@
=@
@=q@G@Ϯ@\)@  @p@Q@@ۅ@z@@(@z@ff@߮@\@Q@\)@ᙚ@{@{@@\@@@@@=q@33@@@R@@\@@@@G@H@@z@{@=q@z@=q@@陚@33@p@H@@
=@\)@H@@@p@Q@@{@ff@{@@Q@{@@z@@
=@\@\)@G@\@\@
@޸R@Q@љ@
@θR@
=@@=q@H@=q@˅@
@(@=q@@@θR@@(@H@ə@˅@H@@{@Ϯ@  @z@H@@׮@@Ӆ@=q@  @У@  @У@׮@Ӆ@{@@@
=@H@ᙚ@\@z@G@陚@@ff@@޸R@\)@  @ff@=q@陚@R@ff@R@Q@R@@z@(@@ff@@H@{@@@@陚@R@=q@陚@
@Q@@p@p@@
=@z@  @33@ᙚ@@@@z@G@@ᙚ@ff@׮@@(@
@ָR@У@=q@33@Q@\)@
@33@ڏ\@@@Ӆ@G@θR@ȣ@׮@
@@z@H@(@@p@ff@  @ۅ@ff@@H@@{@@H@
A ApA AffAQA @@@=qAAHA(AGAR@\)A33AA{AHAA(@zA   @\)@A
{A	GA\)@
=@  @33@AffAG@@@@@=q@(@H@=q@@@QA z@{@ff@\@ᙚ@
=@33@p@
@33@ff@  @R@33@R@\@R@@R@p@z@@\)@
=@(@ff@@\@@(@Q@H@\)@
=@H@z@@@陚@
@@@  @  @@@{@G@H@33@@\@=q@(@z@@@@Q@
=@\@\@@@@@R@\@=q@
@  @33@33@\@@
@@@G@H@z@@@\@G@\)@G@{@{@ff@(@{@@z@\@
=@p@ff@H@\@  @R@Q@  @@陚@G@=q@
=@z@ᙚ@@ᙚ@@z@@
@(@33@{@@@ff@=q@z@=q@33@Q@p@ᙚ@=q@\@@\@z@@
@@33@@ff@@33@z@
=@ᙚ@{@@=q@@z@@(@(@H@\@H@@p@@  @\@@(@@ff@
=@Q@{@\)@@ff@Q@(@H@@@H@(@@@G@  @Q@@G@=q@H@H@=q@@G@
@@@@H@(@  @p@@陚@@@  @陚@
=@G@  @  @(@p@
@@H@@  @@@{@޸R@޸R@{@ff@љ@\)@@@˅@{@H@\@H@@ۅ@{@׮@Q@p@@Q@ȣ@ff@@z@@H@(@ȣ@Ǯ@@@@G@@33@R@@@@陚@@33@\)@=q@@p@\@@H@@@{@ff@
=@@ff@޸R@{@@p@@z@޸R@
=@H@޸R@ٙ@ۅ@޸R@p@
=@z@\)@
=@H@{@ff@G@p@\@@  @Q@Q@\)@33@@(@p@33AA=qA AH@AQA@AAzA	A
RAffAA@33AzAAffA\)ApAAzA(A=qAG@z@(@@(@p@\)@@@(@@H@(@@z@@\A ApAzAAG@@@
@AA@@(@\)@@33@H@@@
@Q@ڏ\@
=@@p@  @\@@H@33@33@G@p@G@@@@{@׮@p@  @@z@@(@33@@У@(@(@׮@@ə@H@\)@ᙚ@(@@陚@p@@G@@ᙚ@\@@{@{@R@@@\)@=q@@@@H@@
=@p@{@@  @޸R@
@@@H@@@@Q@{@ff@{@ff@H@ff@Q@@@޸R@@=q@33@=q@(@R@@H@H@\@p@{@@@=q@ə@˅@{@@@33@@z@(@33@Ӆ@ָR@@33@
=@p@ڏ\@
@ҏ\@p@H@(@@G@@\@@˅@@G@Q@@Ϯ@@
=@H@=q@@陚@@G@p@G@@@@R@H@@ᙚ@@@@G@{@z@p@z@@@ָR@ff@@
=@@
@@
@\)@z@  @Q@=q@ٙ@z@ٙ@@G@@33@Q@@p@z@ٙ@ָR@@Q@H@
@@H@@@@޸R@ff@R@=q@\)@@33@@z@@@\@p@@R@R@G@p@@@
@@33@(@{@@@  @Ϯ@ff@@أ@@  @Q@ҏ\@z@
@z@
@Q@ʏ\@˅@@=q@=q@p@ff@@p@Q@ָR@=q@أ@
=@
=@
=@أ@ff@G@H@\)@{@G@@
@θR@У@Ӆ@33@@p@\)@أ@G@G@@ҏ\@G@ff@@@@
@H@H@
=@G@  @(@\)@@@޸R@Q@p@{@\)@33@\)@
@@Ӆ@ۅ@{@У@@У@G@p@@  @Q@H@G@θR@\)@=q@ff@љ@@@Ӆ@@=q@У@@@У@@љ@\)@@H@p@
=@  @θR@θR@=q@Ӆ@33@޸R@\)@@\)@ָR@  @Q@ٙ@
@
@33@@@=q@{@p@  @\@(@z@@@@\@@@  @H@@z@  @@@\@{@p@{@  @{@@33@@\)@@@  @@
=@33@@G@@ᙚ@=q@33@ff@H@@{@(@ff@p@\)@Ӆ@ٙ@\)@p@Ӆ@ff@H@(@H@ָR@ڏ\@Q@G@ڏ\@ff@\)@أ@
@{@G@\)@p@z@z@=q@G@G@ff@Q@=q@@@  @Ӆ@G@p@@@ff@33@Q@  @H@@љ@=q@@
=@ڏ\@{@{@@
@ٙ@أ@H@ff@=q@H@
=@@@޸R@(@@
=@G@@=q@  @z@R@=q@@\)@H@\@R@  @=q@@Q@\)@(@ff@G@@{@@  @@߮@ff@p@@ff@z@(@ۅ@=q@{@@ٙ@ڏ\@z@@@@{@ָR@@  @@@z@׮@
=@
=@\)@أ@׮@{@@{@@@  @\)@{@\)@ָR@ff@ۅ@ڏ\@
@
@G@
@ۅ@ҏ\@H@׮@  @@(@H@{@  @@H@ڏ\@߮@@\@@ᙚ@G@@\@z@@p@
=@Q@@
=@@{@z@(@z@
@p@R@@z@@@=q@@G@陚@33@=q@p@@@z@ff@@
=@ff@p@ڏ\@ᙚ@ff@߮@ᙚ@@z@  @p@@ff@ۅ@p@@ۅ@ۅ@33@p@@z@
@@p@{@@33@ڏ\@ڏ\@H@H@ۅ@33@=q@ڏ\@ٙ@G@ָR@@H@ٙ@{@޸R@G@@(@@޸R@@@@ff@
=@
=@  @H@\@33@@G@@G@陚@@33@@@\)@ff@@@\@  @@@z@=q@@@  @{@@=q@R@@  @@陚@  @@{@@\)@@{@@@@\@z@߮@@R@{@33@{@R@\)@z@@=q@
@@ᙚ@ff@
@@33@߮@(@Q@
=@  @ᙚ@@z@@33@  @{@Q@ff@(@@
=@ָR@{@ָR@@\)@
=@\@H@H@@R@
=@G@@Q@@=q@\@33@@(@@@
=@@Q@G@Q@Q@@@@@=q@@{@@@@G@
=@@@  @@H@@G@@{@=q@(@H@@z@ᙚ@ff@ff@  @  @G@@G@ᙚ@H@@@ff@@
@@33@@@=q@@
@@߮@(@p@@@ff@أ@=q@@@ۅ@
@ۅ@=q@=q@@׮@@G@Q@@أ@
=@  @@أ@=q@@=q@z@@߮@33@R@\)@\)@@@33@@\@=q@33@z@p@
@޸R@{@{@\)@p@  @p@@z@@G@  @Ӆ@ҏ\@@ڏ\@@@G@(@33@ff@ʏ\@H@=q@θR@G@
=@(@@@@(@@H@@У@У@@=q@љ@љ@{@\)@33@ff@Q@ƸR@H@=q@(@
@=q@ʏ\@ȣ@p@@{@Å@=q@G@33@Ǯ@Å@33@ȣ@Q@ȣ@H@(@H@ƸR@@
@(@˅@ə@ff@@33@
@
@=q@@@33@p@  @׮@أ@=q@H@(@
@ۅ@޸R@ۅ@ۅ@(@p@޸R@  @޸R@(@ٙ@Q@
=@\)@߮@G@
=@߮@@Q@\)@޸R@@p@޸R@@@H@@z@@\)@\)@  @@ۅ@G@ۅ@ڏ\@@ָR@  @  @{@ff@@z@Ӆ@{@ff@׮@@\)@z@ҏ\@(@z@@@љ@θR@  @
=@p@Ǯ@H@˅@
@{@@@\)@@{@\)@@\)@\)@  @H@У@@љ@33@@
=@@=q@
=@
=@p@ٙ@z@z@@(@ۅ@z@@ff@Q@Q@G@\@߮@ff@H@׮@ff@љ@(@ff@@H@=q@=q@@Q@@{@@ȣ@Ǯ@ə@H@
@H@ə@θR@@ʏ\@@=q@@ƸR@\)@Ǯ@=q@G@
@=q@z@p@˅@˅@33@z@{@ƸR@ƸR@{@p@ə@Å@@Q@Q@z@G@
=@
@@@33@33@ff@ȣ@@G@˅@Ϯ@@\)@  @  @=q@H@
=@H@\@
=@  @˅@θR@G@@H@@У@ff@@@z@33@ff@Ϯ@@У@Ϯ@Q@Q@=q@@H@=q@G@Ϯ@{@(@@p@@θR@33@@ʏ\@ʏ\@˅@@
@z@z@z@˅@33@33@˅@=q@@Q@
=@ƸR@@=q@
@H@ƸR@@\)@ƸR@@\)@G@
@@@G@(@@Q@@R@@@Ǯ@
=@ȣ@Å@@@\@@@\)@\)@\)@\)@@G@  @Q@@Q@@@  @R@
=@p@{@{@\)@\)@@z@@p@{@  @  @@=q@ҏ\@
@p@@(@޸R@p@@(@
@H@
@أ@
=@{@z@ҏ\@H@33@
@p@33@Ϯ@θR@@(@p@@θR@θR@
=@ff@{@@z@@(@  @33@
@@
@@ff@\)@  @У@\)@ҏ\@љ@У@Q@
=@θR@{@ff@θR@@@
=@@@=q@{@33@z@z@@@@  @ff@أ@׮@ٙ@@H@@ۅ@@޸R@@@z@@@33@ff@p@
@  @
=@ff@\)@\@@\@=q@@{@p@{@Q@@\)@@
=@
=@@
=@G@{@@@33@R@=q@=q@\@p@
=@ff@{@{@ff@@z@@ff@Q@\)@Q@{@@p@@33@H@\@陚@@Q@@
@@p@ff@@33@ff@  @߮@@ۅ@
=@
=@{@߮@Q@H@ff@  @=q@޸R@@=q@=q@@陚@(@
=@\@
@33@G@33@@\@=q@
@ff@  @33@@@{@@\)@\)@\)@ff@z@@@
@@
=@{@p@@G@@@@  @\)@
=@@@{@{@p@R@
=@ff@(@@R@R@{@ff@ff@{@ff@@@33@
@@33@G@@ڏ\@
=@p@\@@=q@=q@H@ڏ\@@ᙚ@H@߮@G@
@\@H@Q@@  @@H@
@@ff@R@\)@Q@Q@H@z@@  @  @@@R@
=@Q@H@33@33@@
=A QAA=qAHAQAAA\AHA33AA	GA	A	A
=ARARApA  AzAA=qA=qA{ApA\AAAA@
=@@=q@(@@A (A
A=q@ffA zA   A @@
@
=A QA  AG@@=q@\)@@=q@(@R@@@p@@(@\@=q@H@@@z@@@33@@33@@=q@  @z@@@@@ff@z@33@@H@@p@@p@
=@p@
@ff@p@(@@
@p@z@\)@@G@H@(@@z@ff@@A QA (A   A   @\)@{@33@\)@@H@@  @
=@@{@G@@@Q@@G@@z@ڏ\@@H@(@ff@  @p@@{@ff@@@H@\)@陚@
=@H@=q@G@@@=q@H@(@@ff@@p@\@  @@\@  @޸R@ff@33@
@=q@ff@33@@@z@{@@z@@p@
=@p@p@  @=q@@@
=@Q@  @@G@\@z@@Q@z@
@p@
=@ff@\@@z@z@=q@33@
=@G@@  @@H@  @p@p@(@@  @
=@@p@@{@@p@R@@Q@ff@Q@@(@@@(@
@
@(@Q@G@@ᙚ@@@@
=@  @Q@@p@p@{@z@p@@33@ڏ\@G@ָR@33@@\)@\)@p@Ӆ@@G@{@@  @ff@p@G@
@ff@Ӆ@33@(@
@@ٙ@  @ָR@׮@=q@@@@ڏ\@ڏ\@أ@ٙ@@H@z@(@޸R@\)@@\)@
=@G@@@@@
@@@ᙚ@=q@
@ڏ\@{@ٙ@@(@׮@  @(@љ@Q@@@Q@H@
@θR@
@У@G@=q@  @@  @љ@@G@{@\)@G@33@(@ȣ@=q@@
=@\)@(@ff@\@  @(@ƸR@G@{@H@@ff@@33@\)@H@@p@p@@H@H@p@Q@  @@@Ǯ@ə@ə@
@ʏ\@@33@p@ff@\)@أ@G@ff@
@ff@
@=q@߮@p@(@z@p@߮@H@ff@  @陚@
@
@Q@{@H@
@H@@G@\)@@@p@أ@љ@@z@Ӆ@
@G@љ@G@(@\)@@@@=q@H@ٙ@33@=q@@
@
=@׮@  @׮@@{@{@
=@׮@׮@Q@љ@θR@˅@(@˅@
@@@@(@{@@G@@@@33@@
@θR@Q@ҏ\@љ@θR@@z@H@=q@@(@  @Q@G@@ᙚ@ff@G@z@@33@
@z@H@=q@@(@33@@{@@@陚@R@@  @=q@ٙ@ۅ@Q@
=@@ff@(@p@@
@
@=q@ff@ָR@أ@(@@@ҏ\@@p@{@@H@  @H@Ӆ@Q@=q@G@  @ָR@@ҏ\@\)@θR@@\)@p@@  @G@p@(@Q@@
@z@{@  @ҏ\@ҏ\@ҏ\@У@Q@У@G@z@Ӆ@  @  @=q@أ@{@@@  @@\)@@@{@(@@@ٙ@G@H@ۅ@z@
=@ᙚ@ᙚ@33@z@ff@@@@
=@
=@@{@@\@{@@ff@޸R@@ڏ\@ۅ@ٙ@׮@׮@Q@Q@ff@@p@@z@p@ff@@ҏ\@Q@Ϯ@H@Ϯ@Ϯ@љ@@@@{@
=@θR@{@G@љ@33@@Ϯ@z@ʏ\@\)@H@33@ff@=q@=q@@Q@ƸR@@ə@33@ff@@@{@z@@@{@@@=q@Q@(@Ӆ@ff@@33@H@@=q@33@p@z@p@޸R@߮@@\@(@z@@  @  @ff@z@@Q@\)@ff@(@@H@\@G@Q@  @ff@@G@@
=@
=@G@G@
@  @ff@\)@
@H@=q@@33@p@
@@{@
=@\@\@@@p@ڏ\@H@@Q@Q@{@H@(@
@(@@ۅ@@@{@@ff@ۅ@أ@Q@p@@33@H@@H@@Q@
@@
@@@p@p@
=@G@G@@陚@@@\@33@(@p@ff@@@G@@
=@\@  @@G@ff@@z@(@G@@H@H@\)@{@@
=@
=@p@p@@G@33@\@\@33@@陚@@\)@33@@G@ۅ@@أ@  @
@ָR@H@@
@ڏ\@  @@@H@(@@@@@
=@@
@׮@Ϯ@ff@G@p@@33@H@ff@ff@ڏ\@@p@z@z@
@H@@@{@@@ff@\)@߮@Q@߮@@  @G@@ᙚ@=q@@@
=@\@\)@@G@@@H@Q@@\@z@@33@p@ff@z@(@(@
@H@@@(@
@@@ff@  @\)@z@@ᙚ@ᙚ@@ff@{@H@@\)@@׮@z@׮@@@@ۅ@׮@=q@G@ff@z@Q@  @@\)@G@  @޸R@p@{@@ff@{@@
=@ᙚ@ff@=q@@p@޸R@
=@p@=q@ڏ\@p@p@ۅ@H@p@@
@{@@{@
@(@޸R@G@Q@ᙚ@G@@p@@z@z@p@R@@=q@33@z@z@@R@z@H@=q@@@\@@@\)@{@R@ff@@p@
=@\)@Q@@Q@@  @z@=q@G@Q@=q@Q@  @z@p@33@ڏ\@H@ڏ\@
=@(@  @  @ڏ\@p@@@
@G@Ϯ@@@G@p@H@@@ڏ\@33@H@H@H@33@z@z@z@
@(@@@p@{@@Q@@ᙚ@=q@H@z@@p@{@R@@@\@33@z@@z@@@@p@@p@@@@{@@z@
@(@@@@
@@p@@p@=q@@p@z@
@@{@33@陚@z@p@@@@p@
@=q@@  @G@陚@{@=q@@H@z@@\@@陚@  @
=@Q@R@{@ff@R@z@陚@Q@z@\@R@@(@33@
=@Q@@R@
=@@@@@\)@@G@=q@\@\)@
=@G@(@p@\@
=@A=qA@\@Q@@@\)@ff@@@
=@
@\@@@@@  @(@@R@@@\@@@@Q@@
=@R@\@@ff@@@@@H@
@@\)@
=@@@@Q@  @\@{@@Q@@z@z@@
=@{@G@Q@@\@z@  @z@p@=q@@Q@ff@
@@(@\)@@@\@33@p@@R@@  @  @@@Q@(@33@(@{@z@=q@z@@@z@(@
@@@G@=q@33@=q@@\@H@(@33@@@p@@@p@{@@@p@@33@z@\@G@=q@@
@G@  @ff@@33@p@p@@z@@\)@p@{@{@
=@\)@{@{@G@  @{@R@H@{@H@@Q@@߮@
@@=q@@@
=@\)@H@H@(@@p@=q@Q@@H@ᙚ@(@@\@@ڏ\@ff@@p@Ӆ@z@@G@H@
@@\@  @@H@H@=q@@ᙚ@@@@@\)@ff@
=@
=@
=@@  @=q@
@
@  @33@@Q@=q@G@\)@ff@
=@Q@@=q@@@p@  @@
=@z@
=@@=q@  @33@\@ff@@@@
@ۅ@=q@ڏ\@@p@׮@@ff@Q@\)@@׮@
@33@ۅ@@@{@ҏ\@33@
@@
@(@p@=q@@  @z@{@@(@@{@H@ff@@@@أ@{@׮@ٙ@=q@ۅ@@G@@(@p@@@@@R@@@@H@@@z@@(@
@@(@@p@@@p@(@z@z@ff@陚@
=@@p@@ff@z@@=q@޸R@\)@
@ff@ff@(@\)@׮@@ʏ\@z@@Ǯ@33@Ǯ@=q@@
@H@@У@ʏ\@˅@θR@@˅@У@θR@G@У@Ϯ@@ȣ@(@@@Ϯ@\)@{@
=@ff@  @Ϯ@Ϯ@\)@@
@\)@ָR@Q@{@أ@\)@{@=q@33@
@ۅ@H@ۅ@ٙ@Ϯ@@ʏ\@@=q@  @Ӆ@=q@@\)@z@ҏ\@33@@ٙ@@G@z@@@G@׮@ָR@ҏ\@=q@Ӆ@33@=q@\)@H@=q@
=@z@p@Q@@@
@H@@33@@{@Ǯ@=q@Q@׮@׮@G@=q@{@ڏ\@@θR@ʏ\@H@ҏ\@@@@G@@=q@=q@p@(@H@33@{@ʏ\@H@
=@Å@У@@@\)@  @Ϯ@@\)@Ϯ@
@љ@
@=q@У@Ϯ@z@Ϯ@=q@ٙ@H@H@@\)@ڏ\@أ@\)@
=@=q@(@ڏ\@(@@ۅ@ڏ\@@ff@\)@Q@Q@@@޸R@@@߮@Q@Q@Q@ᙚ@Q@Q@z@@(@ۅ@@33@љ@(@ҏ\@ff@Q@33@ҏ\@@׮@z@z@
@@أ@(@G@Ϯ@@z@أ@
=@
=@G@@@H@أ@Q@  @љ@p@@ָR@Q@p@=q@  @@G@H@@  @33@H@=q@ʏ\@  @Ӆ@@Q@У@H@  @H@ָR@У@p@߮@
@@H@  @ڏ\@@@@  @z@@R@Q@@@@\@
=@ff@Q@@@\)@G@Q@ff@
=@p@=q@ff@@@أ@޸R@H@@G@p@Q@θR@z@33@Ӆ@ff@ff@׮@H@33@׮@ff@أ@ۅ@\)@H@33@ڏ\@{@@@33@ff@@{@33@ff@H@˅@z@=q@H@@Q@ƸR@@H@@@Q@p@@  @@Q@G@z@@@@@z@У@@{@@\)@
=@  @{@@@H@=q@ۅ@ۅ@p@ۅ@ٙ@=q@ڏ\@@(@{@{@޸R@@=q@ff@@
@H@H@أ@=q@=q@
@@(@\@@
@ᙚ@  @@@
@
=@@
@z@@{@=q@޸R@ff@@ָR@=q@33@@޸R@{@
=@z@
@(@ڏ\@{@ff@
=@G@p@@޸R@ۅ@p@{@\)@޸R@޸R@
=@{@@{@ff@@@@أ@@
=@@Q@\)@@@
=@ۅ@@ָR@ٙ@  @@p@ff@\)@ᙚ@@=q@޸R@ᙚ@@{@@@@H@z@{@@\)@@=q@G@@@\)@R@(@(@@@  @=q@
=@@z@=q@@H@陚@ff@R@33@
@(@@ᙚ@Q@=q@ڏ\@p@{@H@{@@z@{@޸R@p@(@ۅ@ۅ@@Q@ڏ\@Ϯ@@H@أ@Ӆ@@@p@z@
@@z@Q@@G@\)@{@G@{@
@(@
@  @أ@
@ٙ@ۅ@z@@ᙚ@@(@(@33@@@@p@@H@z@\@߮@ᙚ@z@R@Q@@=q@G@G@
@H@\@\@\@
=@\)@G@@33@@\@ᙚ@  @ᙚ@ᙚ@p@@ᙚ@R@@p@(@@޸R@ff@p@z@@p@H@ۅ@z@G@\)@z@H@(@
=@@
@@У@H@У@@Ǯ@=q@
=@p@
=@\)@ҏ\@ָR@{@33@ҏ\@p@ȣ@{@@=q@33@ə@Q@  @=q@ff@@@@
@33@(@
@33@@@H@{@@ҏ\@G@z@{@p@p@ff@\)@\)@p@@@33@ᙚ@@\@H@
@p@@p@@  @
=@
@G@޸R@߮@@ۅ@@׮@  @{@p@z@ff@33@
@ڏ\@أ@׮@=q@G@p@ڏ\@z@33@
@θR@@ff@p@ָR@Q@G@G@أ@  @ff@@@
=@ۅ@{@@@(@p@@@ff@ָR@أ@\)@33@z@H@(@H@@
=@H@33@@{@{@  @ff@
=@  @ڏ\@ۅ@z@@{@p@
=@Q@G@H@
@@ff@ff@ff@\)@Q@@\@@@\@@@
@{@@@@R@(@\)@  @@ᙚ@=q@G@(@@33@@z@  @@\)@ff@ᙚ@
=@
=@p@
=@@p@ڏ\@z@(@@p@@@\@@=q@=q@\@@  @@z@ۅ@=q@Q@أ@׮@أ@أ@@ٙ@G@  @
@أ@Q@(@H@  @ڏ\@33@Q@\)@p@@
=@@ff@  @׮@@
=@
=@Q@G@\@ۅ@ٙ@Q@ۅ@@  @\)@@\@@  @(@
@G@\@@ff@  @
@\@Q@ᙚ@H@
@\@33@33@33@@{@  @ff@33@ۅ@
=@޸R@@@
@H@
@ۅ@@H@@33@ٙ@ٙ@ٙ@33@=q@@@H@z@33@@{@@Ӆ@љ@@ҏ\@33@(@׮@Q@ff@ff@=q@=q@ڏ\@33@H@ָR@ٙ@G@Q@ָR@ٙ@@  @@@@H@=q@(@أ@G@p@׮@@@ָR@\)@p@G@{@(@
=@
@ָR@أ@@@@أ@@z@33@(@ۅ@@  @޸R@
=@ff@
=@ff@@Ϯ@ڏ\@H@@@z@@33@
=@(@أ@33@  @33@أ@H@Ϯ@=q@љ@=q@  @ָR@ۅ@ۅ@33@p@(@(@(@@Ӆ@z@ff@Ϯ@Q@ə@@ʏ\@
@G@љ@
=@Q@@{@޸R@ۅ@H@@ff@p@ff@љ@љ@ҏ\@Ӆ@z@z@
@{@ڏ\@߮@33@@
=@H@@(@@@p@@ff@R@  @@G@Q@  @陚@\@陚@@陚@=q@陚@H@
@H@@33@陚@z@@H@ᙚ@@H@p@z@@@@  @߮@Q@߮@ᙚ@H@=q@\@{@@@{@
=@ff@z@@Q@\)@ff@
=@߮@Q@߮@@߮@=q@޸R@p@(@@Q@@H@ڏ\@ڏ\@@@33@
@33@ڏ\@أ@Q@=q@33@p@@p@p@G@=q@ٙ@ff@ٙ@޸R@Q@z@Q@  @33@@\)@R@  @\)@@@
=@@@G@@\@=q@@H@Q@\@(@Q@  @@G@{@
=@G@@=q@@@@@@@@Q@\)@
=@ff@{@R@
=@  @  @ff@@{@
=@@  @\)@@@@@p@@p@{@@ff@\)@{@@p@H@p@z@\)@=q@\@@@@@(@@=q@\@@(@p@R@@
@
@z@(@G@@@@ᙚ@{@\@@=q@G@@  @z@ff@{@
=@\)@@@@{@p@ff@R@@\@@@\@=q@@@@G@H@@
@@@@@@@H@{@(@@R@\)@@p@(@@33@陚@
=@ff@=q@\@@@\@@@@R@@R@\)@@@=q@@(@
@H@\@@\)@  @@33@33@p@(@z@(@33@H@@33@
@R@R@@Q@@@ᙚ@p@@H@@@߮@\)@\)@G@
=@@@޸R@߮@H@\)@@@  @@G@z@@{@@@@z@p@@\@@Q@z@33@Q@33@ҏ\@@z@
@Q@33@ff@
@{@G@ᙚ@ᙚ@G@  @׮@p@
@
=@ᙚ@@߮@Q@@@\)@z@p@\)@\)@
=@߮@޸R@33@33@33@z@ۅ@{@޸R@޸R@p@@G@\)@@@@z@@
=@Q@@@33@@Ӆ@׮@\)@=q@@@  @߮@z@޸R@{@ڏ\@@@@@ۅ@@G@\)@{@Q@@@@33@@33@@(@@
@z@ff@@p@(@R@R@
=@z@@@33@p@@޸R@@H@ۅ@G@G@=q@G@@׮@@G@H@ۅ@p@z@\)@
=@{@߮@\)@
=@Q@\)@\)@
=@޸R@p@(@(@ۅ@z@
@z@ڏ\@@@@׮@׮@=q@@=q@(@z@z@޸R@ڏ\@ۅ@ff@ff@@߮@  @ᙚ@H@=q@@ᙚ@\@@=q@@@33@p@(@@@@p@@陚@Q@陚@陚@=q@=q@H@=q@\@H@@陚@\@G@33@\@G@Q@@=q@\@Q@  @@@Q@@  @\)@
=@޸R@  @߮@=q@=q@@  @@@Q@=q@ᙚ@ᙚ@G@@ᙚ@ᙚ@޸R@@H@߮@
@ۅ@G@p@33@@@
@(@G@߮@@z@ff@p@޸R@ff@z@
@@ff@@H@\@@  @\)@G@z@@(@  @z@ff@R@陚@ff@{@
=@z@ᙚ@@@=q@H@H@@@(@\)@@(@
@@@H@ᙚ@@H@=q@@33@@@@޸R@أ@
@{@@Q@=q@陚@p@@z@H@(@@߮@ff@z@@@p@=q@@p@
@@(@\)@@@
=@Q@ff@У@G@
=@ʏ\@G@  @
=@ff@@  @{@ff@@33@\)@  @˅@H@@(@33@Q@{@(@@{@ff@Q@  @׮@  @׮@@@Q@Q@33@@@33@G@@Q@  @ᙚ@\@@G@@߮@ff@@@  @߮@=q@  @ᙚ@@@@\)@p@
@@33@p@
=@=q@ƸR@@33@Ϯ@\)@z@@@@@z@
@33@33@
@(@H@@Ӆ@
@Ӆ@љ@H@=q@ҏ\@Ӆ@Ӆ@љ@G@G@
=@Q@Ϯ@\)@p@33@\)@=q@p@=q@H@Ӆ@@H@H@
@Ӆ@G@@33@
@33@
@ָR@׮@׮@أ@(@
=@@\@@
@(@@@H@H@\@p@
@p@{@(@
@@ᙚ@33@\@@@陚@z@H@@
@=q@@H@(@Q@
=@@  @z@ᙚ@\)@  @G@  @@  @޸R@޸R@@@
@
@33@ۅ@33@33@33@
@33@=q@=q@ڏ\@H@33@ۅ@(@H@@޸R@{@޸R@޸R@ff@Q@ڏ\@@\)@p@@G@ۅ@(@33@33@{@ڏ\@@H@@33@33@ۅ@ڏ\@H@ڏ\@H@ڏ\@ٙ@=q@=q@p@ᙚ@@H@\@@@33@=q@33@(@z@p@@p@p@ff@R@@\)@R@  @(@R@  @@G@Q@陚@z@z@Q@G@G@G@p@@z@(@@33@ᙚ@@z@\)@\@\@z@@\)@z@@{@@{@  @Q@\)@  @߮@߮@߮@
=@@Q@ff@@(@Q@G@@@
@߮@(@(@
=@@  @{@޸R@G@\@߮@33@\)@H@޸R@@޸R@G@\)@@@
=@@Q@G@ᙚ@ᙚ@G@\@H@@@@@(@z@@@
@\)@z@G@\)@R@@@(@33@
@H@@@@z@
@z@H@@Q@ᙚ@=q@@\@G@ff@@z@(@H@
@(@@@\)@H@p@@p@p@{@@@
@ۅ@@  @\)@ff@@ҏ\@Ӆ@
=@@H@33@˅@@@  @(@@@
=@
@ٙ@@{@(@ڏ\@ָR@33@@33@ٙ@Q@@  @@Ӆ@@z@p@z@@H@z@@@@߮@@ff@@@p@޸R@33@@ff@
@  @\)@p@޸R@@{@(@@@{@H@z@@G@{@H@(@
=@p@Ӆ@Ӆ@H@  @
=@33@@@ٙ@{@z@У@@G@=q@z@ָR@@z@Q@׮@@@p@33@G@{@ff@ۅ@p@@H@
@=q@@z@@
@ff@ۅ@=q@
=@@ۅ@{@\)@z@ff@=q@{@Q@@@p@@@޸R@޸R@޸R@ᙚ@@Q@(@@@޸R@
@G@ۅ@
=@
=@
=@
=@߮@@@@G@@@G@@@@@@@p@p@p@p@@z@\)@@@=q@(@33@{@(@z@
@@H@@
@\)@z@(@أ@ٙ@ٙ@ٙ@(@ۅ@=q@33@Q@ȣ@33@@Q@p@@@{@  @Ӆ@(@@@  @׮@\)@Q@@ff@׮@{@ff@\)@@ff@
=@@=q@H@߮@@Q@\)@
=@p@ff@
=@߮@@@@@G@ᙚ@@@@G@@
=@
=@R@H@ᙚ@H@
@(@33@ָR@ָR@޸R@@H@ٙ@׮@ᙚ@޸R@׮@@@ٙ@H@=q@@@{@ۅ@
@G@{@=q@أ@{@׮@{@\)@Ӆ@
=@ҏ\@
=@@
=@\)@ҏ\@{@z@G@p@z@
@p@љ@@@@@@(@@H@@H@ҏ\@У@љ@  @
@H@{@׮@  @{@\)@H@33@ff@H@=q@\)@@@Q@(@ᙚ@@@R@@@=q@(@z@@z@@p@@@R@ff@R@ff@ff@{@p@@H@@ᙚ@߮@\)@޸R@޸R@߮@@H@z@@@\@z@p@@\@@(@@ff@\)@Q@޸R@@أ@ָR@@أ@  @(@@ڏ\@@
=@߮@G@@Q@  @  @@33@H@p@H@z@@@
@ff@@@33@33@(@
@@{@
=@Q@\)@@@ᙚ@=q@(@p@@p@p@R@
=@@@@33@z@@
=@  @G@
=@
=@@{@
=@\)@@z@Q@@{@@H@Q@ff@ff@
@z@@@@H@G@  @@
=@p@@\)@(@z@@z@z@
@@ff@{@@@z@z@@p@{@@
@@@@(@Q@  @陚@33@Q@  @Q@{@  @p@
=@ڏ\@
=@@G@ۅ@H@@@(@(@G@@=q@Q@@33@@߮@=q@
@{@(@@@p@G@@{@ff@Q@G@
@@33@(@
@
@  @Q@
=@ff@(@@G@陚@@\)@陚@陚@@33@  @H@@G@=q@陚@@  @G@33@H@  @@z@ᙚ@Q@=q@߮@
=@ff@ff@\)@޸R@@(@
@H@H@H@ڏ\@@G@{@  @أ@ָR@
@љ@@ff@Ϯ@(@G@@߮@@@ڏ\@=q@z@ۅ@=q@ۅ@=q@@p@ff@p@@=q@ᙚ@=q@=q@ff@p@=q@@
@@z@(@@
=@z@@Q@  @
=@
=@@߮@ff@33@߮@\)@ff@@z@ۅ@ۅ@
@H@33@H@@@G@ڏ\@  @@
@߮@Q@߮@
@=q@{@G@@Q@
=@@@@ָR@p@@ff@z@(@ff@=q@Q@أ@G@
=@ڏ\@ff@\)@G@أ@ڏ\@(@ָR@أ@Q@@p@{@z@Ӆ@z@p@ҏ\@@׮@Ӆ@{@z@p@Ӆ@@@ff@
=@׮@ָR@@
@ff@@@33@ٙ@@ۅB33B33BЙBffB33BffBҙBffB  B33BffB  B33B33BffBʙBffB33BffBB33BffBffBffB  BB33BffBB  B33BBBffB  B33BffB  B  BBB33B33B  BB  BffB  B  BB33B  BBBBB33BBBB33BBffBBffBB  B  BB33B33BffB  B  B33BBffBB  BBB33BBffB33BB  B33B  BB33B  BBffBB  B  BB33B  BBffBB33BBB33BffB33BBffBffBB33BB  BffB  BBBffBBBB  B  BBBB33B  BB33B33BB33B33BBB33BB33BB  B33B33B33BffBBBB  BBBBffB  BBBBffBBBffB33BffB  BBBffB33BffBBB  B33B  BBffBffBB33BBB  B  B  B  BffBBBffBffBffBffBffBBBBBB  B  B  BBBffBBB33B33BB33B33BB  BffB  BB33B33BBffBffB33BBBB  BBBffB33BffBBffBBB  B  BBBB  B33BB  BB33BffB33B  B  B33BffB33BBffBffBffBB33BB33BB33B33BffBffBBffBffBffBB33B33BBBffB33B33BB  BffBBffBBffB  BffBffBBffB33B33B  B33BffBBB33B  BffB  B33B33BBB  BBffBBBBBBBB  BBBffB33BBffBB33B  B33BB33BBBBBB33BB  B33BB33B  B33B33BffB33BBB  BBBBB33BBBffBB  BffB33BB  BffBBB  BffBBBffBffBÙBB  B33B  B  BffBBB33BffBʙB  BșBBřBffB  B  B  BBffBB  BBΙBB  BBffBB33B  B͙BBBffBffB  BffBBϙBB33B33B  BffB  B  BBBB33B  BffBffBBB  B  B  BBffBBBffBBB  BBffB33BB  BB33BBBB  B33BB  B33BBBffBBBB33BBBB  BB33B  B33BřBǙB  B33B  B̙BffB33BB33BffB33B  BՙBBBBffB  B֙BBB33B  B  B33B33BffBffB  B  BBB33BffB  B  BǙB33B  B˙BffBffBffBBřBffB33BB  BB  B  BB33BBB  B  B  B  BBffBBffBB  BffB  B  B  B33B  BB33B  B33BBBB33BBffBffB  BB33BřBB  BÙBffBƙB  BffB  B33B33B33BffB  B33BB  B  BB  BBffBBљB33BBЙBffB  BffB33BBԙBffBBϙBBBffB  BffB33B  BBffB33B˙B  BB33BffB  BffB33B˙BBffB  BffBffB  BffBșBffBBffBřBřB33BffBffB  BffB33B33B33BffB  B  BB  B  B33BB  BffBB33BB  B33B33B33B33BBB  B33B  B  B33BB33B  BB  B  BffBϙB33BЙB33BffB33BffBљB  BffBffBBffB33B  B33BәBffBљBBffB33BBڙBיBB  B  B33B33B  BffBB͙B  B͙B  B33B33BffBB  BffB  B  BffBʙB33BffB33B  BB  B33BșBBB33BBęB33BBffB33BǙBǙBffB33BffB  B33B  BřBB33B33BffBffBffBęBęBBffBÙBB33B33BșBB  BBffB  B33BB  BffBBB  BffBffB  BffBۙB33BܙBBB  B  B  B33B33BB  BۙBffBBBיBffB  B33BffBBffBBޙBffBB噚BffB33BB  BffBffB  B33BB  BffB  BBffB֙B33BffB33B33BffBffB  BffB33BBBBBffB33BʙBffBffBBΙBB33B͙B33B̙B  BB33BffB˙BBǙBffBBęBB33BB̙BBffBffB33BBB33B  BffBBB33BҙB33BffBBBߙBffB  B33BffBffBܙBᙚB33B晚B33BffB33BB33BڙBݙBBffB  B  BB  BBffBffB  B  B33B33B  BffBęB  BÙBBffBBBęB  BB  B͙BBBՙBB33B  BřBBBffB33B33B  B  B33BBB  BBffBBffBB33BB33BBB33BBBB  BBBBBҙBBB33BffB  BffBffBffB  BffBBBffB33B33BffBBffC  B  CffC3C C	3C C fC3CCffC3CBffB33BffBBB33B왚BBffBffBBۙBڙBffBՙB֙BffB  B33BffBBٙBәB  BffBB  B  BffBffB33BBBBffBϙB33BBB  BB33B33BBffBffBBffB33BBffBffB33B33B33B33BBBffBBB  B  BB33B33B  B  BffB  B33BB  BB  B͙BBffB  BB  B  BffBљBBB  BffBܙBBЙBBffB  BffBBffB33B˙B  B  B  BΙBΙBϙBffB  B33B33BB  B33B33B̙B  BB33B33BffB33BffBffB  BBffB  BffB33B33BffB  BffB33BÙBBBffBffB  BB33BffBBffB  B  BBBBB33BffB33BB  BBBB33B33BffBBBÙBffBBBBBffBffBffBBBB33BęBffBBBB33B33BB  BffB33BffBřB  B33BffBBB33B  B33BBB  BBB33B  B33B  BffB33B33BBB33B33B  BBB33B33BffB33B  B33BB33B  BBB  BB33B  BBB33BBBffBffB  B  B33BffBffBBBBB  B33BBffB  BffB  B33BffBBB33BBBBBBffB  B  BB33BffB33BÙB  BBB33B33BffBřBffB33BffBffB33BB33B  BęBřBB  B33BffBffBffBBffBffBffBÙBB  BB33BBB33BB33BB  BffB33BBBBB  B33BBBffB  BffBffB33BBBBffBBffBB  B  B33B  BffBB  BB33BBffB33B  B33BBB33B33B  BB  BB  B33B33B33B33BB33BB33BBBffB33BffBffBBB  B  BB  B33B  BBəB  BffBəB  BBǙBffB33BșB  BffBffBffB33BB33BffBffBffB  BffBęBřBBffB  B  BB33BffB33B33B  B33B33BB  BB  BffB  BB33BBB33BBffBffBBffBffBffBB33BBÙB  BB33BBęBBffB  BffBBffB̙BƙBffBBBəBffBəBəB  BBBəB  B  BffBǙBffB˙B33B  B33B̙B͙BffB33B̙B33BB̙B  B̙BffB  B  BffBҙB33B  B  BffB  B33BffBΙBffBffBB  B33B33BșBșB  BƙBǙB33B  BB33BBB  BęBřB  BffB33BB33BffBB33B  B33BffBBBBB  BBffB33BffB33B33BBBffB  BBffBB  BBșBB33BB  BB33B33BB33BffBǙBB33BffBBffBffBǙBBBЙBffBffBffBffB  B33B  BBB  B33BʙB33BșB  BB33B  BffBǙBƙBffBǙB33B  B  B  BBƙBffBffBƙB  B  B  B33BƙBBǙBƙBƙBB  BffB33B33BffBǙB33BffBffB33BÙBffB  BB33BBřBBB  BəBffBB  BffBBffBffB  BffB  BBffBƙBBffB  BffBB33B33BBǙB  BB33BBffBəBffBəB  BB  BffBBəB33BffBB33BBBffB33B˙B˙B  BffB˙B  BffBʙB33BʙBBffBșB33B  BB33B33B33BșB  BB33B33B  BB33BffBșBșBșBșBffBBffB33B  BffB  BBB  B  B33BBBřB  B33B  BffB33B  BffB  BffB33BffBffB33BffBffBBBffB  B33B33B33BƙBffBffBBB33B  BBǙB  B  BǙB33B33B33BffB  BBffB33BB33BffBʙBșBB  BəB33BffBșBffBffBffB  BffBB  B  BəB  BffB33B33BffBʙBB  B  BBșBBƙB  B  B33BffB  B33B  BffBffBffBffB  BffB  B  B  BB33B  BffBBBB33B33B  B  BffBffB  BffB  BffBB  BffB33BffBBBffB  BB33B  BBBƙBffB33B33B  B  BBffB33B  BffBřBffBřBBB  BffBffBșB33BBəB33BBffB33B33B33BəBffBffBBB  BșBB  BBB  BșBəB33B  B33BșBffBB  BșB  BffB  BBffBǙBBffB33B  B33BřBřB33BffB33B  BffBBƙBǙB33B33B33BffBffB  B33B33BffBffB  BB  B33B33B33BBęB  BřBffBffB  BffB  BřB33B33BęBBffB  BffBB  B33BB  BęBffB  B33B  B33B33B  BBffB33B33BffBBBřB  B33BBęB33B33BřBffB  B33B33B33B  BB  BƙBffB33BǙBffBffBÙBBB  B33BBffB33B33B33B33BBƙB  BBB33B  BșBBB  B  BffBBB33B  BəB33BB33BffBB  B  BffBBBffB33B33B33BB33B33BffBffB  B  BBB33B  BB  B  BB  BB  B33B˙BBffBBșBffB  B33BffBffBffBffB33BəBffBǙB33B33BəBəB  BffBB33B33B33B  BffBșB33BffB33B  B  BBșB  B  BffBǙBB33BBřBffBB33BB33B33B33BB  BșBșBffB  B33BBffBffB33BB  BffBBÙB  B  BBB33BffB  BșB33BșBșB33B  BffB33BffBffBB  BBЙB33BB  BffBffBffB33B  B  B  BffB  B33B  B  BffBBǙBBƙBffB  BB33BffBBǙB  B  B33BBB  B33BB33B  B33B33BffBffBBB33BffBffB  BB33BBBffBB33B  BB  BffB33B33B33BffBBffBBffBffB  BBffB  BB  B  BÙB  BBffBB33BBBǙBǙBǙBB  BffB  B˙B  B  B33B  B33BffBffB33B͙BB33B  B͙BB  B33B͙BffB  BB33B  BB33B  BB͙B33BffBB33BBB33BBB  BșB33B  BffBəBəB33B33B˙B33BffB33BffBB33B33BęBffBBBffBBBB33B33BBffB  BęB  BffBffBffBBffBB33BffBǙBffBBBffB  BBșBffBșB  B  BǙB  B  BƙB33B  BB  B  B33BřB33BB  BffBǙBșBffB  B33B  B  B  BffBffB33BB  B  B  B  BBffB  B33BƙBǙB  BBB33B  B33BBƙB  B  BęBřBBffB33B  BBBBffB  BffBBB33BBBffBffB33B33BB33B  B33B  B33B33B33B33BffBBBBB33B33B  B33BffB33BffBffB33BffBBBB  B  BB  B  BffB  B  BƙB  BBffB33BffBBffBffBBffB33B  BffB33B  BΙBB͙BBB  B˙BBffBBB  BffB33B33BBffB  BƙB33BB33BřBffBřBÙBB  B  B  B  BBBB33BBffB33BffBffBșBffBřBBBffBffBęBBBřB33B33BBB  BƙB33B  BəBʙBffBB  BBʙB33BșB33BffBffB  B33BffBBB  BB33B33BB̙BB33B  B  BBffB33B33BffBffB33B33BffBԙBBәBәBffBЙB33BffB  BљBffBҙB  B  BBffBҙBffBЙB33B33B33BffBffB  B33B33B  B  B33B  BffBBB  B  BffBəB  BB33B˙BʙBBșBřBB33B  B33B  BșB  B  B33BffBřB  B  B  BƙBffB  BșBffB33BəB33BffBBBǙB  B33B  B33BBʙB33B͙BffBffBffBΙBΙBBffBB33BffB  BBϙBљBBҙBҙB  BB  BәB  BҙB  BBffB33B33BΙB  BBffB  B  B  B33BΙBΙB33B  B͙BB  BffB33B33B  B̙B33BBʙBffBB  B  BB  BffB33BffBB  B  BffBBƙBffBBBffB33B  B33B33B33BffB  B33BǙBB33B  B33BffBșBBəBəBəBffB  BəBșB33BBB  BBffB  BffBffBǙBBəBəBB  B33B  BBBffBffBffBƙBffB  BB33BB  B  BBęBffBffBęB33BBB33B33B33B  B33B33BBffB  B  BB  B33BBB33BffBBffBB  BffB  BffBęB  BBffB  B  BB  BB33B33B33B33BBB  B33BB33BffBB33B33BB  B  BffB  B  BffB  B33B  BBÙBffBǙB33BB  BffBB  B  BffBB33B  BBřBřBęBBffBffBffBffBBffBBÙB33B  B33B33BffBBBBB  B  BffBBBBffB  B  B  BB33BffB33BffBB  BffB33BB  BB33BffB33BBBB  BffB  BB  BB  BBffB  BffB33B  BffBB33B  BB  BřBřBB33BBffB  BBBBffB  BB  B33BřB  BffBřBřBBřB33B  BB33B33B33B33BffBB  BffB33BffBffB33B33B33BÙBffB33B33BBB  BffB33BffBBffBBBB  B  BB  BffBffBB  BBffB  BffBBBBBBffB  B33BB  BB  BBBffB33BffBffBBffBBB  BffBBBB33BBffBffBBffB33BB  BffBBffBffBBffBBBB33BęB  B  BffB  B  BffBffBffB33BBffBBBșBBřBBǙB33B  BB  B  BffB  BB  BBƙB33BBffB33B33B33BBffBffBffBB  B33BBffB33BęBęBBffB33BB  BB33BÙB  BÙB33BffBB  BffB33BB  B  B  BffBBBffBęBffB  B33B  B  BffB33BffBBBffBffB  B33B33BBB  B  B33B33B  BBffBffB͙B͙B͙BBffB33BBffBΙB33BBffB33BљB  BЙB  B33BffBBB  BBΙB͙BffB  BB̙BB˙B33BəB  BffBʙBʙB  B̙BəBB33BffB33B33B͙B͙B  BBffB  BB33BBB33B33BęBBB33BəBB33BffB33B33BǙBffBB  BƙB  BBəBəBB33B33B̙B  B33BffBB33BB33BB33B  BffB33BϙBЙB33BB  BBffB  BffBffB  BԙB  B  B33BљB  B33B  BffBffBffB  BffB33B  BffBәB33BffBB  BЙBBϙBffBB˙B  B33BșBffBffBϙBB  BљBBffB  B͙B͙B͙B33BB˙BffB33BffB  B33BffBʙB33B  BB  BffB33B33B˙B  B33B33BBffBBffBffB̙BffB  BffB33BffBB  BffB33B  BBBffBffBBϙB33BЙBϙBffB33B  B33BffBBЙBffB33B33BB  B  B  B  B͙BffB  B33BBffBBB33BffB33B33BΙBЙBB33BBϙB33B  B  BB  B33BffBB  B33B  BffBB  BBșB33B  BB  BǙBffB33BǙBBșB  BBBÙBęBffBBBBB  BÙBƙBB33B33B33BffBBBffBBBBffB33BffBęBBęBęB  B  B33B33B33BffB  B33B͙B33B  B  B33B  B  BB33BBB33B̙B̙B  B  B  B  BəB  BəB͙BffB˙B  BBBʙB˙B33B˙B  B˙BffBffBffBffB33BffBffBB  B͙B͙BffBffBBB  BʙBffB33BBBffBBffBřBǙB  BBffB33BffBffB33B33BB33BffB˙BB  BffB  B33B  BB  BBBșBǙB33B33B  B33BǙBffB33BBșB  BșB  BșBBBB  B33B33BʙB  BB33B33BʙB  BʙB33B  BʙBB  B  BffBșB33B  BB33B33B  B  B33BffBșB33BșBB33B  B  BffB  BffB33BǙBǙBffBǙBBB33BǙBffB  BffBffB33B  B  B  B  BÙB33B  BffBÙB  BffB  BBffBffBęB33BBffBB  BB  B33B33B  BffB33B  B  BB33B  BB  BffBB  BřBęB  BęBffB  BǙBffBB33BffBffBffB  B33BǙB  B33B33B33BB33B  BffB33B  BffBƙBǙB33BB  B33BffB  B33B  BBffBffB33B33BǙB  BffB33B  BBB33B  B33BffB33BƙBffBffBBB  BřBffBB33BB33B  BB33BffBB33BffB33B33BffB  BffBBBBƙB33B  B33B  BBƙB  B  B  BřBB  BęB  B33B33BffB  B  B33BB  B  BffB33BB33BBșBffBB  B  BBB33BșB  BffBșB  BəBffBșB33B33B  BǙB33BșBffBʙBʙB33B  B  B33B  BB  BəBB33BəBəB33BB33BƙBBBBffBBB33BBffB33B  BffBffB  BƙBƙB33BB33BǙB  BBǙBffBșBəBffBB33B  B  BffBffBBffB33BB  BʙBBffBʙB˙BBffB  BffB  BBB  BϙB33BϙBϙBffB  BB  BffB33BϙBϙBB33BffB  B  B33B33B33B͙B  B͙B33BffBB  B  BB33BB˙B  B33B33B33B33BffBƙB  B  B  B33BB33BÙB33BÙBęB33BffB  BffBffBÙB33B  BęB33B  BęBřBB33BBǙBəB  B33BəB33BffB˙B33B  BBșBBB33B  BʙBB  BB̙BffB͙BffB  B  BB33BљBffB33BffB33B  B  BB  BBB  B  BϙB  BΙB  BB  B  B33B  B  BϙB  B33B  BBffBffB33B33B  B33B33B33BffBffB  B  BBffBBB33BB  B33BșBǙB33BffBBB  B  B33B  BșB33B33BƙB33BBffBB  BffBB  BəBffBəBB  BB33BǙBffBffB  B  B˙BffB̙BB33B  B  B33B  B̙B33B33B  B33BB  B  B  BB33BffBffB  B33BBffB33B  B˙B˙B  B33BffB  BffB  B  BffBffB33BffBB̙B  B  BBB33B  B  B33BșBB33BffB33BffBəB33BșBBffB33BffB  BǙB  B  BǙBBBBǙBșBffBffBffBffB33B33B33BǙB33B33BBBffB  BǙB  B33BəBB  B33BB  BB  BșBB33BB33BB  B˙B33B33B33B  BffB33BB  B͙BffBBffB  BʙBffB33BB̙B  BB˙B33BffB˙B̙B˙BB˙B  BffB33B33B  BffB33B33B˙BʙBBBBffB33BffBʙB˙BffBʙB˙BB  B  BffBffB  B  BșBșBffB33BffB33BffB33BB  BffB33B  B  B  BBęBƙBǙB33B33B33B  B  BffBəB33B  B  BƙBǙB  B33BəBB  BffB˙B33B33B  B˙B̙B33B͙B33B  BffBB  BB  BΙBffB  B33B33BffB33B33BffBffB  BffB33BB33BffBffBǙB  BBffB  B  B33BffB  B  BșB33B  BƙBƙBffB33B  BffB  B  BʙBB  B33B  B33BffBBB33BBB  BBffBffB33BffBB33BffBÙB33B  B33BffBřBřBBǙBffB  BƙBřBffBřB33BffB  BffBffBffBʙB  BʙBBffBffB  B˙BffB  B33B̙BB33B̙B33B  B33BʙB  BǙBffB33B͙BB  B̙B̙BffBffB  B33BB  B  BffBșBșB33B  BffB  BęBB  BBBffB  BB33B  B  B33BBǙBffBBB33BBBșBșBșBșB  B  BșBșB33BB  BBǙBBffB  BBǙBffB33B33BBBǙBǙBșBBB33B33BB33B33B  B  BBB˙B33B33BB  B͙BffB33BffB  BBBșB33B  BffBffB33BșBffB͙B33BΙB  B33BΙB  BΙB33B  BffBffB33B  BșB  B  B33B33BffBBBB33BB  BffBffB  BBffB  BffBffBB33BBB  BffBBB  BBBBffBBffBB33BffB33BřB33B  B  B33B33BBffB33BșB33B33B  BBB  B33B33BffB˙BffBffBffB  B  BΙBffBBBffBffBBB͙BB˙BffBffBBBBB˙B˙B  BffB  BB33BęBBffB̙B  B33BB  B̙B  BB33B  BffBəBB33B33B  BB33B33BBB  B  B33BB33B33BffBəB33B  B33B  B33B  BBBBBffBffBB33BffBffBffBB33B  BƙBffB  BƙBřB33BffB33B  B  BBffB33BșBffBffB˙B33B  BBBBB33BЙB33B  B  BffBBBffB33BB  B  BffB33B  B  BffB  B͙B33B33B  BffB̙B33B˙B˙B33BffB  BB33BffBB  BffBBBffB33BʙBșBǙBB33B33B33B  B  BBffB33BffBB  BffBB33B33BBB  BB  B33BBB33BB  BffB  BBB  BffBB33B  B  B33BffBșB33B  BBffB33BʙBffBffB  BffBB  BffB33B  BșBffB33B33B  B33B  BffBffB33BffBBB33B33B33BBBB33B33B  BB33BffB  B33BffB  B  BBffB33B  B  B  BB  BBBBffBęBB33BBBBBB  B33BffB  B  BB33BB  B  B  BB33B33B  B  BffBB33BffBffBB33BffB33B  B  BffBB33BffB  BffB  B  BffBffB  BřBęB33B  B33BƙB33B  B  BǙB33B  B33BB33BBffB33B33B  B  BBffB  BǙBǙBșBB33BƙBƙBB  BffBřBffBB33BffB  BB  BB33BB  B  B33BęB  BęBBB33B  BBffBB  BBBBB  B33BÙBffBffBÙB  BffB33BÙB33BBřBęBffBBB  B33BffB  BffB  BffB  BffB33B33B  BBřB  B  B33B33BB  BBffB˙B̙B  B͙B͙BB̙B˙BffBB  B  B33BB  BB˙BB˙B33B  BBʙB  BffBBBʙBʙB  BffBffB33BʙBșBffBffB  BffBBBffBffBffB33B  BffB  B  B  B33BB  BBřB33BřBffBB33B33BBBB  B33BBB33BffB33B33B33B33BBffBșB33B  B  BffBBBffBffBșB33BəB  B33BϙBЙBffB  BBBBBffBҙBBB33BҙB33B33B33BBB33B33B  BBΙBffB33B33BB33BΙB33B33BBB  B͙B͙BffBΙB33BffB͙BB  BffBffBB33BffBffB33BffBəBBʙB33BffBʙB33BǙBBBBÙB  BBřB  BffBB33BBBƙB33B  B̙BffB33BB33B33B  BęBBB͙BffBBB33BBB  BΙBϙBϙBffBB33BҙBBffBәBffB33BffBffBәB  B  B  B  BәBҙBBffBЙB  BЙBBffBљBљBϙBЙB33BB  B33B  BffBB͙BΙBBBB33B  BffBffB33B  BB  B  BΙBBB̙B  B33B͙BЙB  BBřB  BǙBBffBB˙B33BBΙB͙B33BffBBBęBƙBB  BBB  B33B33B  BBΙB  BBffBϙBffBffBBљBB33B  BB  B  BԙB33B  B  BffB33B33BffBB֙B֙BffB  B33B33BB  B  BBיB֙BB  B  BBB  B  B̙B̙B˙BBffBffB  BBffBBB̙B̙B33B  BBBBBәBϙBffBffBəBffBBffBffBBffB  B˙B˙BffB˙BffB33BԙBB  BԙBՙBBՙBffBffBBBҙB  B33BљB33BB  B  B33B  B  BۙB  BffB  B33BܙBffB33B  BB  BBffB  BffBߙB  B  B33B  BꙚB  B33B癚B33B33B  BB  BB33BBB33BBffB33BffBۙB33B  BffB33BffB33B33BB  B33BיBffBffBיB  BؙBffBיBffBffB33B  B33BB֙BffBљBBB33BffBffBBffBffBB33B33BffBffBBBffBܙBffB  BBffB  BBffB  BޙB33B  BffB  B  BBffB  B33B  B㙚B䙚B晚B  B虚B癚BB  BffB  B33B33BffB㙚B䙚B䙚B  B33B  BffBffBBffBߙB  BffBۙB33BffBBBBBBBٙBffB  BBܙBBffB33BB  BՙBڙBB33B33B  B  BٙBB  B33BBB  B33BffBBffB33BٙB33BB33BffBBBffBܙB33BffBBffB  B33BB33B  B33B33BffB  B♚B33BBffBffB  BBB33B  B  BBB  B33B33BBffBffBffBffBBB  BffBBffBB  BffBffBffBߙB  B♚B♚B33BBBffB33BBܙBٙB  B  B33BB33B  BۙBڙB  BؙB33B  BBB  BՙB33BB  BffB33B33BB33BՙBԙB  B  BBؙBBffBB33B33BffBB33B  B晚B33BffB홚B33BffB33BffB33B  B㙚BffB33BffBffB  B33BffBBBB晚BffB33BffB  B홚BB  B  BffBffB䙚B33B33B33BffB♚B陚B33BffB33B뙚B  BBB뙚B33B  B33B  BffB噚B33BBffB33BffBffB  BBBᙚB  BffB33B33BB  BܙB  B33BBffBڙB  BۙB  BffBffBۙBffBffB  B33BffBBB  B33BB  B33BܙB33BffBBffB  BB  BffBBffBBBffBffB  BffB33BffBffBBBffBBffB33B  BB  B  B33B33BBffBBffBffBBffB  BffBBB33B癚B33BffBffB  B33BBffB33BffB33B  B33B虚B  B33B33BffB晚BffB33BffB噚BB33B33B㙚B  BffBB  BߙBB33B  B  BffBB33B33BB33B33BB♚B♚B33BBffBffBffB  B  BBffB  B癚B33B癚BB33B  BffB33B왚B陚B33BB  B33BffBffB33B33BBꙚB뙚B  B  B33BffB  B33B  BffB33BꙚBB33B33BBffBffBffB33B33B  B뙚B33BB  B  B33B  B㙚B33B癚B33B虚B晚B癚B癚B虚BffBffBBffBffB  BB33BffBBffB癚B33B晚B33BffB  BٙBffBۙB33BB33BݙB  BޙB33B  BffB33BߙB33BffB33BBٙBBݙBᙚBB33B  B33B33B  BٙBffB  B  B33B  BB  BffB33BffB陚BBBBB33BffBBB33B33BBB33B33B  BꙚBffB33B  BᙚB  BB33B33BޙBޙBᙚBffB  B䙚B  B33BB  BBffBBBB33BBBffB  BffBffBB  BBffBffB33BB33B  B虚B癚BffB  B  BffB33BB33B33B  BffB  BffB  BffB33BffBffBBBޙB  BBffB  B33B33BBffB㙚BBffB虚BffB䙚BffB33B33B♚B癚B33BffBffB33B䙚BffB  B䙚BBߙB㙚B  BBffB  B33B33BܙBB  BB  B  B33BffB  B㙚B  BffB  B  B  B  BffB33BB  BffBBߙB  BܙBBffBBffBBffB33B33B  B  BڙBffBBBڙBיB  BәB33BffBBffBљBBљB33BBؙBיBٙB33B33BBffB33BB  BߙBB  BᙚBBۙBffB  BߙBBᙚBB䙚B33B  BffB33B  BffB虚B33BffBffB왚B  BB  BBffB  B33B  BBBBBBffBBffB33BB  B33BBffBBffBffB  B뙚B  BffB  B晚B  B33BffB  BBffB33BߙB  BffB♚BffBB33B33BB33B  BffBB33BB  BBBffB  B33B33B33B  BffB33BffB  B33B  B33BffB  B㙚B33BffB晚B虚BffBBffB晚B33B33B33BffB  B33BffBBffB  BB  BBBffBC 3C33C LCffC CffC33C LB33C C LBC fC fC  B33BCffC CBffB33C  C  CC33BB33BffBB  BB  B33B  BB33B33BBB33BffB33B  BBffB33B  B33BBB33B33B癚B  B  BBB  BffBB  BBffBB33B33BffBffB  BBffBffBBBB33BffBffB33BffB  B  B  C LB  C LB  C  C3CCfC	33C	  C
C33C  C
 CffCLC33CC33C	fCCC  CBBB33BBffB33B  C ffBBBffC CCC 33BBBBffC C  B  BBBffB33BffBBBB33B뙚B  BBB  B  B虚BB  BB虚BffB♚B  BB  BffBꙚB33B  BffB  BffBB33BffBffB  BffBBBB33BffB  BB33C 3CC33CC CC	  CfC	 CLC
 C
C
 C  C
  CfCffCfC3C33C  C3CCLCffCC33C
3C	ffC	33CC33C3C33C33CLC C  C CLC LC BB  B  BBffB  BBffBꙚBffBffB33BffBB33BꙚB  B33BBBffBffB뙚B33BffB33B♚BffB33B  BffBB䙚B♚BffB33BffBffBBB33BBC BBB33B  BC CC3CLC C  C33CffCLCffCC fBB33B  BB  BCffCCCLCfCC33C CfCCC	ffC3C C  C3CC  BBBB33B33B  BffBffBffBB  BBB  B  BffB33B33BB홚B  B33BB33B33B33BffB33BffB33BBB㙚BBffBB33BBBBB  B  BffBBBffB33BᙚB噚BffB33B33BB33B癚B虚BffBBffBffBBBBffB  BffB  BB  B  BC fC LCC3C3C C33CLCCC33CCfCffCCffC fC3C CLCB33B33BBB33BffB33B33BffB  BB33B33BBB  B  BBBffBffBffBffB  BB  BffBffBffB33B33BffBffBBBBB33B  BffBffBB  B  BffBffB33BBffBffB33BffBᙚB33B♚B♚BBffBB晚B  BBffB뙚BB33B뙚B  BBffB  B  BffB  B33BB33BCLCLCLC CC C3C33C C B33BB晚B♚BᙚB  B  BߙB33BffB33BB33BۙBffBffB33BffB  B33BޙBffB33BffBB㙚BܙBBܙBffBBؙBBffBffBәB֙BffB͙BB33B͙BffBԙBԙBB33BԙB33BBB  BB  BҙBBBϙBffB  BffBffBffBBffBffBBffBB  BB  B33BB  B  BBffB33B  B虚BB33BޙBffB  BBߙB33BBffBBffB  B33B33BffB  BffB33B  BffB  BffBBffB33BݙB  BB33B  B33BBBB33BffB33BB癚BffBffBffBffBffB33BB  B  B33BBBؙBffBffB  BffBB֙BՙBՙB33BәB  BљBffBffBԙB33B  B33BՙB  BBffB  BؙBBffB  B  B33BBB噚B  BffB  B晚BffB  B虚B33BffBꙚB33B  B뙚B33BB33BB33BBBffBffBffB33BBBffBB33BBBB  B33BffBB33B33BffB33BB  BBffB  BB33BB  BBBffBffBffBffBB  BԙB33B♚BߙB  BffBݙB33BBBBϙBffB33BݙBB  BBB  BBəBęBBBB  B  BBՙBՙBڙBBB33BBBffB33B33BBᙚB33B  B䙚B33BBffB  B陚B  BffBBB  BB  BffB33BffB  B33BBC C fBBBB33BffC C 3BBffB  B  BBffB  BBB33B  B  BffB  BB  B  B䙚BffBB33BffBffB陚B33BBffB  B33B  BffBffB  BBB33B㙚B♚B33BffBߙB33B33BޙB  BB  B33B33BؙB  BffB33BffBBܙBBޙBffB  BffB33B33B33B  BffBffB  B33B  BffBB33B33BBffBffB  BBffC  C33C CCfCffCCCCCBffB33B  B33B33BBB  BBBBffB  B33CLC 3B33BBB  BB33B  BB  B  B33BBBBB33BB33B33B  B  B  B홚BBBB  B  B虚BffB33B33BffBB  B33BffBᙚB  B  B33BffBffB33B噚BB33B33B䙚B㙚BBޙB33BᙚB♚BB  BffBB  BB33BBffBB  BffBBBBffB  B  B33B  BB33B  BffBB  BBffBffBB33BffB  B33BBB33BB33BffBffB뙚BffB33B  B  BB  BޙBBᙚB  B  BᙚB  B33BffBffB噚B33BߙBBBffB  B33B  BۙBۙBܙB33B  BB  BffB䙚B33B33B33BffB♚B  BffB㙚B33B  BffB  B왚B  B♚B  B噚B噚BffBffB33B癚B33B癚BffBffB陚B  B33BffBꙚBffBBffB  BB  B  BBBBB  BffBB  B  BffBffB虚BffB  BB33BBffB  B  B33BB  BffBffB  B33BBffB33BffBffBBffB噚B  BffB33B뙚BffBB33B䙚BB33B33BBBffB♚B33B33B33BffBffBffB  B  BB33BffB33BٙBffB33BBߙB33B33BBffB33BBffBB33B33B  B33B33BB  BB虚B䙚B噚B  BffB  B  B陚BBB  B33BffBffBB虚B虚BffB33B33BffB뙚B  B  B33BffBBꙚBB33BffBffB  B33B33B陚B  BB33B  B33BffB33BffBB  BBffB䙚B  B  BB33B噚B䙚B  BffBB  B33B33B  BBffBB  BיBBB33B  BffB33BffBBffB  BffBBٙBffBיB  BffB  B  BffB33B33BffB  B  B晚B33B  BB33BB  B뙚BB뙚B왚BffBB  BB33BB33BBffB  B33BB  B33B陚BffB  BB陚BffBB虚B虚BB33B33BBBffBffB33BBBB  BB  B  BB䙚BBffB  BffB33BBBBBᙚB  B  BffB33BBffB33BffBBBٙBڙB  BffB  B33BڙBB  BݙBߙBffB33B  BffB  B  B33B33B  BffBffB㙚BᙚB33B♚B  BffB33BBB  BffB  B33BffBffBꙚB  BB癚B䙚B  B  B33BᙚBߙBffBؙBffBffB33BBᙚB33B  BffB33B  B  B癚B  BB33B33BBffBBBڙBᙚB33B  BffBB  BffB  B33B33BB33B33B33BB33B  BB  BBٙB  B33BBB  BBffBffB33BϙBffBBҙB  BffBBffBffBffBB  BffBB  BffB33BffBBϙB33BBBB  BBBۙBffBffB  B33BߙBffBffB  B  BffB  BBBffB㙚BffBBBB33BBffB  B33B33BffBؙBffB  BB֙BffBffB33B33BffB  BBffB  B  BBәBB33B  BԙBB  B33BffB33B33B  BәBffBљBffBffB  BB  B  BBffBffBffB  BffBBffBB33B33B33BB֙BԙBffBB33BffBB  BљBәBB33BffB  BB  B  B  BՙBffB33B33BffBBBB33BݙB33BffBffBffBffBffB  B  B33B  BffBffBffBBۙB  BffBffB33BffB  BۙBffBڙB33B  B  BffB  BffBڙB33BffBB  BB33B33BffB33BffBffB  BٙBffBٙBBۙBffBffB  B33BؙB  BffBffBBBәBffB  BؙBffB33BיBBיB֙B  BB  BԙB֙BԙBՙB  BffBؙBB33B  B  B33BBBffBffBәB33B33B  B  B33B33BBB33BڙB33BڙBڙB  BffB33BffB  BBffB33B  BܙBB  BB  B  B33B33B33B  B33BBffB33B33BBBԙB33B33BffBffBיBB33BؙBB33BיB33B  B33BffBBffBffB33B33BB33BBΙBffB  BșBffB̙B33BffB  BҙBљB  B33B  B  B  B33BffB  B33B33B  BffBBffBBٙBffBffB33BffBBBڙBB  BBffBBܙBBffBBffBffB33BffBBffB  BݙB33B  BBܙBB33BܙB33BBB  BBBffBBݙBffBݙB  B33BB♚BB  BB33B  B  BBB  BffBffBBB  B  B  BffB  BؙBffBB33B  B  B  B  BffB33B33B33BffB33B33BBٙBڙB33BB33BffBޙB  BffBBffB33B33B33BB33BޙBffB33B33B33BffB  B晚B  B噚B噚B噚B噚B䙚B33B  BBBBᙚB33B33BᙚBᙚBffBffBffB  B  B33B  BݙBݙBB33BܙBݙBؙB33BBffB虚B33BffB  B  B  BBffBBffBffB33BBffBB  B33B  BffB  CBBC ffBffB33C  CC C33CC  CC3C C B  CBB33B33BCLC LBffC C ffC CLC  BffBB  BB  BffB虚BB  B33B  BffBB  BB  BBB33BB33BB33B33BffBBffB  BB  B  BffB33B陚B  B뙚B33B33BffBffB33BB  BffB  BffB33BB  B33BBBffBBffB33BBffB33B  BB  BڙB  BffBBՙBBڙB33B  BۙB33B33BffB  B33BffB˙B  BșB˙B̙BffB33BffBBB33B33B  B  B  BffB33B  BffBřB33B  BffB  B͙BB  BffBffB33B33BܙB  BB33BٙBᙚBBB33BffB33B33BᙚBBffB♚BᙚBᙚBߙBffB33BܙB  B33B33B  B33B33B  B  B33B33B  BBBߙB33BיB  BB33B  B  BffB33BffB33BיB33BB噚B  BBffB33B33B  BB♚BBB  B  B陚B33BB33B  BffB  B虚BB  BBB33BB33BB뙚B33B뙚BᙚBՙBBBffB33B㙚BBffB  B㙚BBB33BffBB  BB  B  B33BBffB33BBffB33B  BffBBffB33BBffB33BݙBڙBBߙBޙBݙBffB  BޙB  BffB33BffB33BffB33BBޙBBܙBۙBffB33BBޙB  BffBߙBffB  B  B  BBffB  B♚B33B33B  BBBᙚB  B33BB33BffBffB  BB  BB  B  B  BBffBB  BB  B  B33B  B33B֙BffBffBBB33BBffB  B  B  B  BB33BB  BffBffBB♚B  B  B  BۙB33B  BۙB  BBؙB  BffB  B  BBffB33BB33B33BffB33B33BffB33BB33B33BBffBB33BBffBB  BߙB33BBٙBffBڙBڙBݙBB33B33BB33B  BBٙBٙBؙB33BffBffBBffBB  B  BƙBB  BB33BffBBBۙBB33BB33B  B33B  B  BBffBffBݙBffBݙBffBB♚BffB  BܙB33B33B33BffB  BߙB  B  B33B  BߙB33B33B33B  B  BffBBؙBؙBיB  B33BԙB  B33BљBffBBBәBB33BffB33B  BffBffB33B  BB֙BffB33BffB33B  B  BffBٙB  BיB33B  BՙBffBBffB  B  B  BffB  B33BϙBffBBffBB  BffB33BBՙBՙBәB33BB33BffBٙB  BܙB֙BffB  BBB33BBBffBBB33BffBffB  B33BBffB虚B  BffB33B  BffBBffBffBB33B33BᙚBffB晚BBBޙBBffB  BBffBᙚBBᙚB33B33BB33BffBB  BBڙBB33B33BܙB33BffBffBffB33BB  B  BޙB  BݙB  BB33B  B  BݙB  BBޙBBBޙBBڙBBؙB  B  BB  BffBffBBᙚBB33B噚BffBBffB뙚B  B33BBBffBB  BB33BffB33B  BBB33BffBffB  B  BffBBB  BB  B陚B33BffBffB  BBBB陚BffBBffBffB  BB33B㙚BB䙚BB33B  BBBffB㙚B  BffB  B33BBܙBffBܙB33BffBܙBB33BffBffBBߙBffBffBffBB33B  BBffB  BߙBBffB  B  BݙBޙB  B♚BB  BffBffB  B癚B虚BBffB  BffB  B33B33BBffB  BB33B33B33B33B  BBBBBB33B  BB  BBffBffBBB33BffBffB33BBffB33B  BffBffB33BۙBffB  BݙBffBBBۙBݙB  B  BB  BBBffBB  B33BB33BB  B  BBffB  BffBۙBۙB  BB33BΙB  BBBڙBڙBڙB33B33B  B33BffBB  B㙚B33BffB33B  BB  B33B33B  B  BffBffB  B왚BffBB  B  BB33B  BBB33BBBB33B  B33B  B33BBB33BBB  BC CffB33BB33B33B  B33B뙚B陚B♚B33BB  B33BffB  BBB  B  BffB  B33BB  B  B陚BffB  BffB33BBffBBB  B33B  B  B뙚B  B33BffB33B  B  BBffB33BB왚B33B陚B33B홚B33C  B33BffBffBBffBB33BBffB33BffC C C3C3CffCC33C C  CffC CCCC ffB33B33BBB홚B33BB홚C  C 3B  B  BBB  BBB  B33BBffBB  BBBffB33B홚B  BffB  B  B33B  B  BBffB陚BB  BB  B㙚BᙚBffB33B  BᙚBffBB  B33BffBBB33B噚BB33B  B33BffB33BffBB㙚B33B癚BBffB晚BffB33B33BffB  BB㙚BBB33B陚B  B  BB  B33BffBffB33BffBB33BffBB33B33BBffB  B  BBBB  BffBBBBBffB晚B晚B왚B  B33B33B  B  BB  BB癚B  BBBBffBBᙚBffB33BffB㙚BffBBffB䙚B  BᙚB  B  BffB  B33BffB33BޙB♚B33BޙBBffBߙBB  BB  B㙚B33BffB䙚BffB  B  B  B33BffBꙚB  B홚BffB  B33B33B  BffB33B  B  BffBCCCfC  C  C  CLCCCCLC3C33C33CfC33C3BffBffB33C   CffC 33BC C B33C  CffBBffBC LCBBffCLCffCB  BBBffB  BB33B33BB  B33B  BffB33B  B33B  B  BffB33B㙚B  BB33BffB  BB  B䙚B噚BBffBB癚BBBffB33BBffBBB33B  BffBB  B  B33C ffBB  B  B33BB  B33C fC  CC3C3CCCC33CLCCfC LB  BBffBBffBB33B33BB33B왚BffB  BBB33BBB33B33B  B䙚B  BffB33BffB  BBߙBߙBB晚B  B33B  B  BBffB33BB  B  BffB噚BffB33B䙚B噚B33B䙚B噚BffBffBffBBBffB  BffB33BBBB  B  B33B33BBffB  BB  B  BB  B  B  BffC  CLC33C C  C33CC3C3C3CC33C  CC  CLCCCCfC 33C   BffBBC B  B33B33BB33BBBB  B33BffB  B33B  B33B䙚B33B왚B陚BffB  B  BffBB㙚B晚BffB33BBffB  BffB  BffBBffBffB33BffBffBB㙚B♚B♚B  BffB33BB33BffB  B  B陚BB  BBffBB  BBB33B  BffBB  C LCCLC33CfCffC C CCC  C33C  CCfC33C	C  CffC	33CCC33CffC 3BffCffBffBB33BBffB  BffB33BBffBffBffB33B33B  BffBB33B33B  BBC fBBffB  BffBBBBffBB33B  B  BffB  BB  BBffB33B  B왚BBB  B뙚B33BBffB33BB33B33B  B33BffBffBB33BffB  B33BB33BffBBBB  BffBffB33B33C33C  CCffCCC  CfCB33BBBffB33C B33C	33CCB33BBffB  B홚BffB  BBffBBffBffBB33B虚B  B噚BBB  B  BffC ffBC CffC
ffCLBBffB33B33BBffBBB33B홚BꙚBB홚B陚BB癚B噚BffB䙚B䙚B  B噚B33BffB癚B33B  BffB왚BffBBB33BߙBffBffBB  BBffBBB  BC fCCCffCffCC33C C33C
  C	 C ffB33BB  BBffBBffBffB33BffB33BB33B33B  BffCCC CffCLC CBffBffBB33BBffB33BffBBBffB  B  B  BB33B33BffB33B  B33BffBB  B  B  BBB33BBB33B  B33BBffB33B33BffBBffBB  B  B33B33BffB  BB  BffBBffB왚BB33BffB  B33BBffB  BBffBBB  CLC ffB  B33BffC33C BBB  B  BB33B  C LBffB  BffB  BB  B  BB홚B33BꙚB  BffB  B33BffB33B  BffB33BBffBffBffB  B  B  BffB33B33B  B  BԙBffB33B  B33B33B  B  BffBffB33BB  B晚BꙚB晚B  B㙚BffBBB33BffBffBffB33B뙚B  B33BB33C C   B33C   C C  CLCC C33C  C3C CfC33C33CCfC	LCC C CfCLC B33B  C C33C	 C	ffC	  C  C33C ffBffBffBffBBC   B  B33BB  BBffB  BB33BBffBBB  BB陚BffBB33B33BBffBBB33BffB虚B  B33B  B33B33B  BB  BBB  B  BꙚB陚B  BffBBB33B  BffBffB  B33B陚BB33BBBB  BffBBB  BBB뙚BBB  BB  B  BCffCLC BB  BBC 33CB33C33CLC  CffBffBB  B  B33B  B  B㙚BڙBffB33B33BB33B33BB陚B晚B  B  BB33BffBBffB  BBBB  BBffBޙBBᙚBffB噚BB  B33B  BᙚB33B33B  BffBܙB33B  BffB  BB  BᙚBffBffBBB䙚B㙚B噚B晚B33BffB33B  BB33B33B왚B33B  BB  BBBBC ffCB  C3CLC3C BC ffCC
3CfC C33C BC  CfB  BB33B  BB33BffB虚B  BBffBB왚B  B  BffB홚BffB  BffB왚B33BffBB虚BffBffBffB♚B33BffBffB33B33B虚BffBB  B  BB  B  B33BݙB33BᙚB33B33B  BBffB33B  B  BffB噚BffBffB  BBB䙚BffBB33B33B33B  B33BB33BffB  BBB  BffBffB  BffBBB  B  BBBB  B33CC CCLCfCLCfCCffB  B  BBBB  BffCfBffBB  BffBffBBBB  BB뙚BB  B虚B虚B왚B  BffBffB33B33B  B  B뙚BffB33BffB癚BBB  BffB  BffBB虚B虚B癚B  BB  BffBffB  B䙚B  B  BffB33BBBffB33B뙚BB왚BB33B33BffBB33B  BffBB  BBB  BC  CBC fC 3C CBffBBC 3C CLC C33C  CfCfC CffC3CffC ffBB33BffBffBffB33B虚BB癚B33B33B33BBB䙚BBBB  B♚BBB  B  BB  B♚BBffB  BBBffB33B  B  BffBB  B䙚B噚B  BBBffB  BBffB㙚B  BB虚B晚BBB33BB33B33BBffBB33B33BffBBBBB  BBB  BB33BB  C 3CffCfC33CC
LC3BCC	3C CC 3B33BC C BBB33B33B  B  B33B왚BBBffB33BffB33B  B33B陚BffB  B晚B  B癚B33BB33B  BB33B癚B33B䙚B㙚B33BffB33B33BffB33B33B33B  BB  BٙBٙBؙB33B  B33B33BBB  BffBڙBڙB33BۙBۙB  BffBffBB㙚B噚B  B晚B33BBꙚBB33B  BffBBB  BffBB33BffB33BB33BBBffCC BffBC  B33B  B33B33B  BffBB  B  B33B33BBffBBBB33B33BffB  B  BB  B虚BffBffB  BffBB33BffB왚BBffBB癚B噚BffB㙚B33B33B33BffB33B♚BffBᙚBBBߙB33BߙBB  BffBffB  BffBBBBffB33BffB왚BBffBB  BBffB  B33BBBB  BffBB  BB  BffCfCC CCffC CCLC3CfCCLCCfC3C CLBffB33B33B  BffBB33BffB33B33BB  BB  B홚BffBffBffB33B  B  B33B  B  BBffBB33BBB33BBBffB33B  B  B癚B噚B  B33B  BBᙚB33B33BffB♚BB虚B  B33BݙB  B  BᙚB֙BB  BffBBB  B  BܙBBB  BB33B  B  BBBBB  B  BBffB33BޙB  BٙBBffB  BffBffB33B33BϙBBffB  B  BffBffB33BB33B  BffBffB33B  BffB33BB  B  B  BBߙB  BffB癚BBBffB  BBffBBB33B  BC  C
ffC
33CLCC
33CCLCfCLC3C33C C3CLC CffC  CCC LC3BC LCLCLCfC3BC 33BBBffB33BB  B晚BB  BB  B癚BffBB  BڙBBB33BBBؙBBffBBBB  B֙BBݙB33BٙBڙBffB33B33BיBffBffBٙB  BBffB33BB♚BffBB33BB  BffB  BffB  BB33BC   C  C33C	LCCC33C C33CfC
CC  CC  CCLC
3C
fC
33CC
33C  C	LC CffCLCCC LBBBBBB33B噚B33B  BٙB33BיBB33BՙBB33B  B  B  BB  BffB  B33BBBffBffB  B  BBBffB33BBffBЙB  B  B33B33B33B  B33BffB  BB  BffB  BffB33B33B33B  BffBޙBܙBB  BBBffBB33B  B  B㙚B  BffBB  B  B  BffB뙚BB  B33B  BffBB  BB  B33BB33BBB33BffB  B왚B33B33BBB  B  BffB  BB晚BffBB癚B  B33B癚B33B33BBߙBBޙB  B  BffBיBՙB  BB33BffB33B33BBBҙB33BϙB  BB  B  B  BBϙBҙB  BșBB  BBffBffB33B33BffB  B  BB33BؙBșB  BffBؙB  B㙚BՙBBBꙚBffB  B왚BB㙚B33BB33B33B  BB33BffB  BBffBB33B33B  B  B33B  BҙB  B  B  B̙B33B  BՙB  BҙB33BBBΙB33BBB33BBΙBffB33B33B  BݙB33B虚B  B癚B뙚B33B  BBffBffBBffB33B33BљBЙBffBљB33BԙBޙB晚B33B33BҙB33BљB33BәB33B33B  BB  BffB33B  BB  BB晚BꙚBBBBBB  B33B33BBB  BffB33BBBB33B33BffBB  BB  BffB  B  BB33BBB33BBffBޙBܙBffB  B  BBffB33BffB33BffBۙB33BڙBڙBٙB33BBffB  BB  BffBffBffB33BәB33B33B  BԙBB33B  B  BיB  BffBffBffBffBBB  B  BffB33BۙB  B  B33B33BBffBB33BBߙBffBޙBffB33BffBffB  B  BffB  B  BᙚBBffBffB  BffB晚BB㙚B  BBffBffB33B33BffB33BBffB33B33BBffBffBffBB33B  B  BܙBffBffB  BB33B  BBffBۙB33B  BۙBBBؙBBؙBۙB33B  BBffBffBBffBBΙBffB33B33B  B  BԙBBՙBBؙBBB  BffBffBffB  BؙB  BٙBffB  BڙBBB  BffBBffBffB  B  BޙBޙBޙBffB33B  BffB  BBffBBffB  BB  BߙBߙBߙB33BޙB  B♚B虚BffBffB虚B陚BBffB  BffB  B  BB  BffBffBffBBڙBBffB33B  BffBffBڙB33BBffBBٙB  BBB֙BB֙BffBffB33B33B33B֙B֙BB  BB33BՙBՙBB33B33BٙB  BٙB33BB  BBB  BۙBܙBBBffBBffB33BffBB  BBB  BݙBffBB33BߙBBB  BBBᙚBB33BffB33B33B噚B  BߙBBBBBB33BBB  BᙚBᙚBffB33BB33BffBBBffB33BޙBߙB33BߙBBBffB33BޙB  B33BB  B  BؙBffB33BٙB֙B33B33BՙB  BBffB  B33B  B33BBۙBBܙB  B  B33BffBffBۙB33BؙB33B33B  B33BۙB  BܙB33BffB33BBffBBffBffB♚B  B33BB噚BB33B  B虚B虚BꙚBBffBffB홚B  BBB  B  B  BB왚BffB  B왚B  BffB  B癚BB33BBffB33BᙚB  BᙚBBffB33BffBBBBBߙB  B  B  BB  BBffBffBۙB33BޙBffB33BB㙚BffBBffB䙚B  B晚B33B  B  B  B  B癚B噚BB  B33BffB  BffB33B33BޙBB33B䙚B33B33B33BBB33BBBBBB  B33BB33BB  B  BBBffB  C33BBffBB33B  B33BffBB33B33B  B33BCffC ffC3C fB  C  B33CCLB33BC  C BffB33BC BffBB33BBffC 33BBffBB  B  BBffBffB33B  B  BB  B33B  BBBB33B  BffBBB  BBBBBCB33CLCC3C  CLC33C	LC
LC3CffC3C  CC3C C33C33CCfCLC
  C ffCCCLC3CfC33C33C
C
 CffCCCCCLC  CffCCC C33CfCffC CfCC C3CCLCBB  BB33B  BBBffB왚B  BB  B  BB33BffBB33BffBffB33B虚BꙚB33BffBffB33BffB33BBꙚBffBffB  B33B  C LBffC CCLB  BB33CffC fBffC 33C  CLCLCCCLC	33CC
3C  CC
fCC3CLCffCfCCCC
3C
 CC
C
ffC  CC
ffCC33C CBBB33BffB  B  B  B  BBBB33B왚BꙚBffBffBffy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y B33BB33BBffC   BB홚CffC3CCCLB33BיBؙBB  B33B33BBٙB  BffBffB33BB33B33BޙBߙBBBffB33B  BffBB33BBffBݙBffBBܙBۙBޙBᙚB33BB33BffBffBBB֙B33BәBBҙBBЙB33BBffBB  BЙB33B33B  BffBΙB̙BffB  BB͙B  B͙BB͙BBffB33B  BʙB  BBffBffBBəBffB  BffBBəB33B  BʙB̙B  B  B33B͙B33B  B  B33BB33B33BљBffBffBBB33BffBBՙBffBB  B33BffBBffB  B33BߙB  BffB33BBBffB  B  BffB33B噚B  B㙚BᙚB  BߙB33BB  BffBڙB33B  BBffBffB33BffBԙB  BBBҙBәB33BљBҙBљBЙBffBB͙B33B˙BəBəB33B33B33BęB  B  BB33B33BffBffB33BffB33B  B  B  BBϙB  BffBffBљB33BBՙB33B33BٙB33B  BffBٙB  BffB33BBffB33BB㙚BffBB  BffB33B  BB33BffBB33BffBffB  BffB홚B33B晚BᙚB  BBffBB33B33BBᙚBBBߙB  B  BߙB  BffBffBB33BݙB  BڙBڙBٙB33BffBBۙB33BBffB  BBݙBB33B  BffBBffBٙB33BffBיBڙB33BB33BBBBBəBffBB͙BՙBBڙB33B33BffBܙBBB33B晚B  BBffB33B33B癚BBffB33BBffB  B33B33B  BBffB  B  BB33BffBBB33C C 3C  C 33BffBB33BffBBffB虚B33BffBB  BBffB癚B33BB33BBBBBB33BffBffBBffBffB  B33B33BۙB  BffB  B33BᙚB33B33B33BBޙB♚BffB  B33BۙB33BڙB33B33BB陚B왚BꙚBB33B  BffB  BffBffBffBffB  BffBBffB33BffBBffB  B33B33BBB33B33BB  BBffBBB33BffBffBBffBffBffB33B  B  B  BffB33BBffBffBB  BBffB  BB  B  B33B  BffBBB  BBffBB33BB  B噚B  B  BffB33BffB33B  BݙB33B33B33BffBffB  B  B33B  BۙBЙBߙB♚B33BffBffBffBffBBBffBB33B  BٙBffBffBffBffB33B  B  B  BBffB  B33BBߙBffB䙚B  BffBffB33B噚BBffB  B  B33BBB  B  BB33BBffBB33BffB33BB33BffB  B  BffBәBffB  B33B  B33B  BffBffCfCLCLBB  B33B  B  BBB33BffB䙚B癚B䙚BffBB33B  BffBBB  BBB  BB  B֙BffBffBffBԙB  B  B  BٙBffBۙB  BffBffBݙB33B  BޙBB33B  BffB  BffBBB  BffB  BffB33BB噚B晚B33B33B  B陚BB  B陚B癚B33BffB33B  B㙚B  BBffB33B  BB  BB  BᙚBffBffBffB♚B  BB  BB33BBڙBffBBBԙB  BЙBffB33BљBBffBB33BϙBffBBB  BffB33BBЙBBҙBљBffB33B  BBffB  B33BffB33B33B֙B  BB㙚B33B33B33BᙚB33B  BۙB33BߙB  B33B33B33B33B33BffB33B33B䙚BffBBB  BB  BBB홚BffB33BB  BBffBB33B33BBffBffB  B33BffB  BB33B  B  B  BB  BffBB  BBBٙBᙚBBBffBffBߙB33BB33B33BB  BۙBۙB  B  BٙB  BffB  B  BffBBffBؙBffB33BffB  B  BBԙB  B33BffB  BffB  BffBffB33B♚BffB33BBڙB33B  B  BffBffB33BBBBffB癚BB33B虚B33B  BBB  B  B  B33BB  BffBB33B  BffB  B晚B33B  BBB  BB  B  B33B  BB  BffBB33B왚B  B虚B  BBffBB33BffB  BB  B  BffB33BffB33BffB뙚B33B33BffBBߙB  BB33BffBBffBffB  BB  BffBB33BffBBB晚BffB33BB33BffB  BBffBffB33BٙBܙB  B  BffB  B虚BffB虚B33B33B  BffB  B33BBffBBBBB  B  BffB癚B33B♚BffBffBB  BffB33BB33BB  B♚B  B֙B  B  B33B33B  BffB33BffBffB癚B  BffBffB  BᙚB33C 3B  B  B噚BffBBB  B  B33BffB  BB  B  BffB33B33B  BffB  BٙBԙB  BffBffBB33BffB  BB33B33B  B  B  BBffB  BՙB  BB33B33BՙB  BffB  BffB33B33BffBB홚B  B  B33B噚B  B  BffB㙚BᙚB  B  B  B  BB33BffB  B  B33B33BԙBffB33BԙB  BؙB33B  B  B  BߙB33B33BffB  B33B  BؙBffBٙBBޙBBޙBBٙB  BB33BB33B33B  BęB  BǙBBřBffBB33BBBB  BBffB33BffB  BǙB33BϙBB33B  B  BBffBBBBBBיBB  B33BיB33BffB왚B  BBBffBBffBBB  BffB晚B癚BffBBB왚B  BffBffBB33BffB뙚B뙚B33B陚BB33BҙBBffBʙBʙB33B33B33BBffBffB  B  BffB33B33BB  B33BB  B33B33B33BҙBffB33B33BffBřB  BBB33BəB33B33BǙBffBffB  B  B33B  BffBB33B33BיB33B33B  BffBffBꙚBB  BܙB  B33BffBffB33B♚BffB33B陚BBffBBffBBB33BffBB  BffC CCffCffC CfCCffB  BffBB  B  BBᙚB  BBBB33BffBffBffBęB  B33B  BÙBffBBffB33BB33BffB  BʙBʙBęB33BffB33BB  B  B  BffB  B  B  B  BǙB  BBB  BęBffBffB  BffBB  BffB33B  B33BB  BǙBBיBffBۙBBܙBffB䙚B33B  B  B33BBffBffB33B33BffBffB  CB  C LBffBffBffBBBffBffCB  CffBffCffC
fCC  C
C
CC	C33CCfC3CCLBCBB33B陚B33BffB33B33B  B  B33BB33BؙB  B33BffBffBߙBؙBB33BB  BBffBB  B  BBBffB  B  BffB33BB  BBBffBffB33BBffBBBBffBB33B33BffBC CffCffC3CCLCLC	C33CC
 C	LCLCffC C  C CffC	  CCCCCC3CB33CC 3C   BBBffB왚B  B陚BffBꙚB  BBffBBffB  B  B♚BB33C 33BffBBBffB33BffB♚BיB  B33B  BڙB  B  B  B  B  BB㙚BB䙚B33BffBffBB33BffBffB♚B  B33BCLC CLB  BؙB33BB  BB33BB33BffB33BB33B  B33BC C LBBffC LCLCCLCLCCCfCCCffC3C33CCLCC  C  CCfBffC3C3C33C ffC LC   B  BB  B  BB33B33BffBB33B33BBffBffB晚B  BffB  BBffB  B  BffBffB  BB  BffBffBffB33BffB33BBffB33B  B33B33BBffB  BޙB33B33BBffB  B33B33BffB  BB  BffB33B♚BBffB  B  BffBCffC LC33C   C   CCCCC33C CCLCfC3C LC ffC ffC  CfC  C  CffCCfCC	CfCCfC  CLCLC   C  CLBffBB  B  B33BB  B  B  BܙBB33B33BܙBffB  BC 33B  B  B33B홚B33B33C C CffBBB33B  B  B虚B  BBffB  BBߙB  BיBBBᙚB33BB  BB33B33B♚B  BBffB  B  B  B  BC fBB33B33B  BBB33BffC  CC C  CCCCCLC BCC33C  C  C	33C	33C
ffC33CffC  C B33BBB33BꙚB33BB䙚BffBBB㙚B㙚BB♚BffB33BB  BffBffBffBffBۙBؙBffB  B33BB33BffBffB虚B陚B  B  B  BBBffB33BיBҙB  BؙBBB  B䙚B33BBB  BffB  BB  BffBB뙚BffBffBBffBBffBB33BffBBffBffBBBBB33C C LC  BB  B  B33CLB33BBBBBffBffC33CfCffCC  CffCBBffB33B  BBffBB왚BffB33B33B33BffBffBffBBffBBBB33BffB33BBffBBB33B  B  BꙚBBffBB33BBffBffBBffBB왚B  B  B홚BffB  BBBBB  B33B33BBffBBB陚BBffB  B33B33B虚BB噚BB陚BB  BBBꙚBꙚBBB  BB  B  BBB33BffBBBB  B33BffBffBBB  BBB33B33BB㙚B  B陚C CfBBB33B33BۙBBffB  BffB33B  BffBBB왚B陚B陚B33B33B33B왚BffBޙB33BBffB  B  BBffB  BB♚BۙB33B33BBB  B㙚B33BBffBffBB33B33BffBffBB  B♚BffB33BffBޙBܙBᙚBB  BBBB䙚BB33B33B홚B  BBB33BB33B  B33BffB33BBBBB33B왚B  BffBBB33BffBB  B噚B  BffBB  BB  BՙB33BffBߙBffBϙB  B  B  BB33BיB33B  BBB  BffB33B33B  BBșB  B  BffBΙB  BffB33B33BffB33BƙBffBBffBBB̙B  B33BҙBBڙB33BffBәB  B33B  BB  B33B33BBؙBߙB33B♚B  B홚B33B33B  B33BffBffBffBB33B33BffBffB  BffB33B  B33B癚B虚B33BBB噚B33B33BBٙB  BffB  BffB  B33B33BB̙By y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y C
fC3C
fCC	ffC
C
33CfCLC  CCCC
C
CCCLCC CCffC  BffBBB  B33B  BBffB  B  B  BB  BBBBffBBBBffB  BB  BffBB33B  BB  B  BBffB  B33B33BBޙBffBBBffBB  B33B  B홚B晚BB33BB홚B33BffB뙚BffBBffB33B  B뙚BꙚB  C33CC C
 C
3C
C C
C
C3C CfCC
fC
LC CLC3CfCC33CC33CCLC	3CCCffC3CfCffCffC BffBB왚BffBB  B33BBBBffBB33BffB33BBffBffB  B  B33BffB֙B  B  BՙBBffB33BҙBҙBBBB  B33B  B33BffBיB33BffB  BffBBۙBݙB33BffB♚B陚B홚B  BffCffCffCffCLC C	3CC
fCCLC3C33CffCC3CCfCCfCCLCCC C33CLC3C
  C
fC	fB  B  BBB  BB33BBffB33BffBBffB33B  BffBBffB33BꙚBꙚB晚BffB33BB  BB33BBB  BffB  BffBffBB33BffBffB  BBBffB33B33B  BBffBffBB33BBB  BffBffBffBBBB癚BBffB  B33BB  B33BC C  B33B  BffCfBBffBBBffBBBBffBBBBB홚B왚BBB  B33BBffBB  B왚BffBB33BB33BΙB33BB  B33B33B  B  BBffBBᙚB  B  BB  B  B  BBffBΙBffBffB  B֙B  BB33B33BBB33BәB33BBffBffBB  B  B  B̙B  BffB  BB  BffB33BBffB33B  B33BBB˙B33BBB  BBffB33BffB33BffBffBffBBB  BᙚBffBᙚBB33B33BffB  BB33BݙB33BݙBffB33B33B33BۙBffB  BffBBB  BיBffBB֙B  BڙBffBΙBΙB  BffB  BҙBB33B33BB33BΙB33B  B33BљBЙBҙBB  BB̙B  B˙BffBʙBșB  B33BBǙB  B  B͙B33B  B  BBB̙B33B33BffB  B33B  B  B33BffB33BB  BffBffB虚B뙚BffBBBB  BBBB  B33B  BBffBB  BBB33B  B  B33BC   B33BffBBffBC B  C  BffBBffB  B33BffB  B33BffBffBBיB33B33BBBffB33B  BffB33B33BffBBBffBBffBffBBBffBffBڙB  B33BffB33BffB  BۙB33BB33BBܙBؙB33B33B  BBffBBB  BffBBB  B홚B33B  BBffB33BBB33BBffB33B33BB  B33BBC  C CCCffCfC33CffC
fC CC33C  CCfC C 33B33BB33BffBBBBffB  BB  B  BffBB  B뙚BB  BffB  B㙚BffBB晚B33B䙚B♚B♚B噚B33B  BB♚BљBܙB  BBB  B  BܙBffBٙB  BڙB33BؙB33BBߙBffB  B33BB33B虚BffB  B33B왚BffB  BBffB  BBffBB33B  BBffBBBB33C   C fC  CfC
CLC	C	ffC3C CCC3C33C	C	33C3C33BffCffC CCffC CLC C fC 3BffB  BB33B33B  B33BffBBB33B  B  B33BffB㙚B33BffB  B  BffBffB  BffB홚BffB홚B  B  B  BB  B  BBBBߙBffB33BffB癚B  BʙBBBffBۙB♚B  BB33BᙚBᙚB33BffB♚BffBffBBB  B  CLBC C  B  B  B  B  B  B♚B33BffB33B虚BffB  BB왚BꙚBffBBffBBޙB33B  BffB  B  B33BB  B  B  BB33B33B  B33BffBBԙB33B33B33BBߙB  BBٙB  B  B  B  BB33B33B33B33BffB33BBffB33BffB  BffBᙚBffB  BB֙B  BޙB  B33BffBB  BffBBBffBffBꙚB  B㙚BBB䙚B  BffB33B33BٙBffBBBB  BC CfC
 CC33C  C  C	 C3CfC3C33C33C  BB33C BffBꙚBffB䙚BffB  BBffBffB33B  BffB  B33BBffBffB㙚BB♚B♚BffB홚BBBڙBffB  B33BffB  B  BffBB  BB  B㙚BB  B33BffBffB33B噚BffB33B33BffBffB  B  BB33BƙB33BffB33B33BB  BffBBB䙚B  B33BBBB33B  B㙚B  B  BBB33BffB33BCC C3CLCCCC BB  BBB33BffB  B33BffB晚BffBBB33B  B33BB癚B  BB33BffB㙚B晚B33BB  BB33B33BB  BffBffBffBBffB33BޙB  BffBڙB  BBffBBЙBBffB  B  B33BffBffBϙB33BB䙚B  B晚BffBffB33B晚B33BęBB33BB33BffB  BC 33C LC  C ffB  BBB33BB  BBBB  BffC 3C3C CC C  CCffCCCCfB  BBffB  BBB  BffBffB  BBB33BB  BffBffBffB  BffB33BffBBߙBBڙBݙBffB陚B㙚BffBffB  B33BffBՙBffB  B33B33B33B33BffB  B  BffB͙BBљBBB  BffB  BB  BffBBBffBB33BC B33B33C  C  C CffCC3CffBC CLCffCCLCCCCC  C33C
ffCfC
CLC C3C  BC ffB33CfBBB33B33C33B33BB33B33BBB33B  B  BBBCfC C3C3C  CfCffCC C3C  BBBBffB晚BB  BޙBᙚB33BBffB  B33BffB33BܙBffB  BBB  B  BffB33B  BޙBffBԙBBffB33BԙBBB33BBꙚB33BffBBBBBB33BB33B  B  BB33BB  BBC  CCLCfC33CC  C  CBB  BB  B33B  BBffB  B33B33B  BBffB  B뙚B뙚B33B33B  BffBBffB癚B  B33BᙚB33B33B  BffB33B33B  B33B  B  B33BBffB33B33B  BB33BBffBffBᙚB  B33B33BB  BBݙBۙBffB33BB  BffB  B  BffB33BޙBffB  BיB  B33BBffBBBڙBffBBBB  B  B㙚BffBffBB  BffBffBffB  BffB  BBܙBߙB  B  B33B33BB晚B33B癚B  BffBB33BffBffB  BffB33B33B  B陚BffBffBffB癚BꙚB33B  BBffBB33BB33BffBۙBۙB33B33BޙB33B  B֙BffBB33BΙB  BffBҙB  BffB֙B  B33B  BB  BB33BffB  BBffB33BffB  B33B33BB33BBBffBffBÙB  BffB33B  BffB̙B  B  B33B  BffBBʙBffBffB̙BșBffB  B33B33BϙBffBffB˙BB33B  BffBBBffBBřB  BffBffBffBffB33B33B33BB  BB33BB33B  BB33B33BB  B  BffBřBffBffBffB33B  BřB33BřB  BBÙB33BBffB  BBB  BBB  B  BB  BffBBBB33B33BffBBffB  B33BBBBB  BB  B  B  B33BBƙBB33B  BBB  BBB̙B33B33BЙB33BBBffBffBB  B  BffB  B˙B  BʙBffB  BЙBBffB33BЙBffB33BBffBffBřB  BʙBB  BəB  B  B33BBҙB33B  BffBB  BҙBԙBBBBB33BB♚B㙚BB33B癚BB  BBB33BffB  BޙB  B  B33B33B  B33B  BBڙB  BܙB  BۙB  B33BBffBffBB  B  BٙBffB  BB33B  BԙBՙBB  BffBffB  B  B  B  B33B33B  BBB˙B33BʙBffB˙B33BșBffBBBB33BBffBffB  BffBffBffBffB  BffB33B  B  BffB33B  B  BffBffBffBB  B  BffBffB33B  BffB  BffB  BBffBBB  BffBB  BBffB33BBřBffBffBBBB33BffBBB33B  BB˙B33BBffB33B33B33BЙBљBЙB33BљBЙB  BBBЙB  B  B  BBffBƙBffB  BəBB  BęBBffBffBffB33BBʙB  BffB33BBBffBffB  BffBffBęBffBBǙB33BB33BffB  BffB33BffBBffBƙBB33BęB33BB33B33BB33BBffB33BBffB33B33B  B  BBB  BBBB33BBffBffBB  B  B̙B33BffBffBԙBߙBBBffB홚BBBBB33B33BffBffB33BffBffBBB33BߙBۙBܙB33BԙB33B  B33B  BBڙBԙB  B33B  B  B͙BB  BB  B  B  BBәB33B33B͙BffBffBΙBBffB  B͙BffBљBԙB33BffB  B֙BffBBBB  BؙBݙBffBۙB33BffB33B  BffBffB33B͙B  BBBffB  B33BB  BٙB33BޙBBffBffB33BffB  BC33CfC33CBffBB  B33BB陚B  B晚B  BffBffBB  BB33B  B  BBBBffBB  B33BffB33BᙚB33BB33B33B33B  B33B  B33BffBB㙚B  BߙBffB  BљB33B33BB33BBffBBB33BffBBBffBffBǙB33BřBBffBB33B  B33BffB33BřB  BB  BB  B33B33B33B  BBB  B  BBffB33B33BBřBffBffB  BffB  BffB33BBffBffBBBffBٙB  BBBffB  BffBffB  B  B  B  BffBЙB  BffBBϙB  B  BffB  B  BB  BffB33B  BיB33BffB33BffBԙB  B33B  BٙBיBBBڙB  B33BՙBBBffBBB33BÙBB33BB33BffBffB33BffBBBB33B33B  BffBBęBęBB  B33B  B33BřB33BB33B˙BffBffB  BϙB͙BffBB  BffB  B33B33BB33BЙBB  BffBΙB  BffBffB33B  BəBB  B33B33BB33B  BB33B  BBB33B33BBB  B  BBffB  BffB  BB  BffB  BB33BffB33BffB  B33BffBB  B33BBB33B33B33BffBBBBffBffBB33BBffBBBǙB33B33BBffB33BffB  BB  BBffBB  B  BęB33BB  B  B˙BҙBffBBәBB  BffBҙBffB33B33B  BBB33BՙBffBљBBffBffBBffBBffBffBffB  B33B33BBffBΙB͙B33B33BffB̙B  BffB  B33B33B  B33BffB33B33BB͙B33BșBBșBșBBffB33B33B33B33BřBƙBBffBƙBB  B33B33BBBffB  BffBBęBřBB33BffBBffB  BB  BB33BǙB  BB  B33B  BB  B33BffB33BBBB  BB33BffB  BB33B  B  BffBffBϙBؙB33BB  BffBיBBffB  BB  B33B  B  B  B  B̙B̙BffBffB˙BffBffBəBffBəBffy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y B  BÙBB33B  BffBřBB33B  B33B33B  BffB  B  B33B  BԙB̙BffB33B33B֙B  BBיBffB  BffBB  BB33B  B33B33B33B33BffB陚B33B33B虚BB  B33BffB  BB33B33BffBBBBffB  B  B  B33B  B  BBיB֙BBffBҙBBB̙B  B33B  BffB  B33B˙B33B33BffB  B  B33BffB33BBBffB33BffBffBffBʙB  BʙBB33B33B  B33B  BB33BřBffB33B  BffBΙBҙB  BBԙBB֙BיB33BffB33B  B33B  BݙBBߙB  BffBB䙚BB䙚B33B33B  B  BB  BBB  BBB33BffB  BBffB  BffBBޙBܙB  B33BffBB  B  BB  BffBB33B  BffBB33BB33BffB  B  BΙB͙BΙB  B  B̙B͙BffBffB̙BBʙBșBffB  BBB33BB͙B˙B  B  B͙B33B  BBffBB  BߙB♚B  B33B33BᙚBᙚB33BffBffB噚B癚B  B33B  B33BB  BBBffB33BB33BBB33B33B33BB33B33BBBBB癚B  B䙚BffB33BBffBB  BB33BffBٙBB33BffBBBffB  B33BB33B  B  BffBffB̙B  B33B  BBBҙBBBffBffBffBB33BBffB33B33B  B33BffBB33B˙BBB  BՙBB33BB  B֙B  BՙB  BffBBffB  B33BBffB  BB♚BffB33BffB33BB癚BB  B  BffBB33B陚B뙚BB虚BffB晚B33BB33BBޙBBBܙBBffBffBB  BB33B֙B  BffB33B  B33B  B͙BffBΙBffB̙BffBB  B  BBB33B33B  B  B̙B33BffBB  BBffBffBBBffBBʙB33BffBBʙBșBffB  BǙBʙB  B˙B33B  B˙B  BffB  BљBffBB  B  BBffB33B♚BBڙB  B33BffB  BffB33BB33B33BB֙B  B33BffBBיBڙBBB  BffBffBB  BՙBיBיBיB33BffBB  BBB噚BffBffB癚B♚BBffBffB33BBᙚBߙBffBBB  B  B  BB33B  BBܙBffBffBffBיB֙BיBffB֙B  B  B33B33B33BBffBәB  BB  B33BҙBBљBҙB  B  B  BB  B  B33BЙB33BәB  BffB  B  B  B  BBЙB33BffB33BBffBffB33BәBҙBB  BәBffBB  B͙B33BffBffBșB  BffBffBffBBBBB  BffBffBBB  B33BBBffBʙB  B33B  B  BB  B  BffB  B  BəBB33B33B  BffBffBșB̙BəB33BffB  BřB  B˙B33B33B  B33B33BBffBB  B33BffBB33BffB  B  BB  B͙BB33BffBffB33BffBәBBffB  B֙BԙBBՙBٙB33B  B33BffB33B  B33BffBBߙBB33BߙB  BB33B  BffB33B  B  B  B  BBҙBB33BBϙB33BBϙB  B33BffBffB  B33B  BffB33BffB33B  BffBffBBffB33B  BBBffBBffB̙B33B33BΙB  BffB33B33B  BB33B  BBΙBΙBB33B33BBəBBB  BBffB̙B33B33BBϙBΙBffB  BB  BffBffB  B  B  BffB  BffB33B  B33B33BffBCLC ffBffBBffBBffBB  B  BffBBffBۙBB33BffB  BԙB  BљBBBffB  B33BBffB  B33B  B  B33B  B33B͙BBљBffBB  B33B  BffBBBffBיBffBBBٙBffBڙBBٙBڙB33B  BBәB33B  BҙBBBBBffBB33BB33BffBٙBffBffBBffB  BffBB33BffBB33B  BB왚B33BffC ffBBBffB33BB  BBffBBB  B33B33B  BffB33B  B홚B  B㙚BBڙBBffBٙBٙB  B  B33B33BљBҙB33B  BB֙B33BߙBЙBffBB  BBB  BB  BffB  B֙BB֙BљB  BB33B͙B  B  BљBffBәBffBBffBB33BffBffBBffB33B33BffBBBљB33BBffBffB♚BffBffB33B33BBBffBB33C 33C3CffC  CfC	ffC	33CfC3CfC3C  CCCCLCfC33CCfC
C	C	BC3B  B噚BffBBffB33B  BffBBffBffB  BڙBffBffBB33BB  B33BљBљBBBڙBЙBЙB33BB  BԙBBBϙB  B  B  B33B33B33B  B33BљBffB33BffBffBffB  B  B噚B33BffB  B  B  B33B  BBBffB  B33B  B33B  BBB  BB33BB  B  BB  B  B癚BffB陚B  B33BffB33BffB33B33B癚B癚B虚B癚B33B噚B33BݙBݙBBffB33BיB33B噚B  B㙚B  B  B33B  B  B33BffBffBBB  B33B  B  BffBffB  BBffBffB뙚BffB33B  B  B  BffB䙚B33B  BffB  B  B33BꙚB癚B晚B  B噚B噚B33BffB33B33BB33BᙚB♚BffB♚BffBB  BB  B  BffB  B33BffB33BffBBffB33B  B33BffBBffB  BffBffBBBBffB͙B33BffBffB33B  BB33B33B  B  BBB33BřBffBƙBBffBBB33B  B  BBffB  B33BřBřBBÙBffB33B33BBffB  B  BBBBBBBffB33BBffB33B  BB33B  BB  B  BB33B33B33BBffBBBB  BB  B  B33BffBB33BffB33BBffB33BffBǙBƙBƙB33BBB33BBBffBƙB  BffBffB33B  B  B  B33BBffBBʙB33B̙B͙B  BffBB  BffBffB33B  BBʙB33BffBffB  BřB  BǙBřBB33BffBÙB33B  BƙBǙBƙBƙBB33BBBffB  BffBffBBffB  BffBǙBBBB  BƙBB33BffB33BffBffBB̙B  BffB33B33BҙBBBffBBffBffB왚B  B  C C3CC CffC3CCCLC3C fCLC	CC33C33C	CCffC  CffBffC 33B  BB  B33BB  B  BffB  B33BۙBۙB33BBҙB  B  BffBݙBffB  BffB  B33B  BљB  BB33BәBB33BߙB  B33B33BffBffBΙB33BBB˙B  BʙB33BffB  BBB  BffB  BBffB  BffB  BffB33B  BB33BB33B̙BיB˙B  B虚B虚B  BC C CCLCLC C CfC  C 3BBBBffBffBC C33C BC3C33C	CLBffC CffCB33B  B33BffB  BϙBBffB  B33BffBB  B  BԙBBffB33BՙBљBffBffB33B  B33BffB33B33BϙBffB  BᙚBB  B33B  B33B  BBffB33BB33BB  BBB  BB33B33BؙB  B33B33B33B33BęBB  B33BBffBB  BffB33BǙBffB  B33BBҙBffBffBffB  BϙB33BBffBҙBәBݙB晚B33BљB33BҙB͙BЙB33B33B  BffB  BB33B  BBffBffBBBffB  B  BffBB33B33B  BșBBBBBffBÙBffBB33BBB  BffB  BB33B  B33BÙB33B33BffBBB  BB  BffB33BffB  BffB  BřB33BřBB33B33B33BffBBʙB33B33BffBffBBffB  B33BBBB33BffBB  B33B33B  BؙB  B  BffB  BffBffB̙B33B33BffBBffB  BBϙBЙB33B33B  B  BҙBљBљBffBΙBffB33BBB  BffBΙBffBffBƙBffBǙBB  B33B33BB33B  BBffB33BffBBffB  BB  BffBB33BffB  BBffBęB33B33BBBÙBffBB  BBęBÙBffB  B33BffB  B33B33BffBB33B33BBÙB  BB33BffBB  BəBB̙B33BϙBffBϙBBffBffBBәBBffB  BؙB33BffB33BffBBBҙBffBBffB  B33BffB  B  BffB  BBBB  BBB33B33BB33BBB33B33BBffB33B  BB33B33B  B  B33B  B  B  B  B33BffBffBB  BřB  BęBęBffBffBBBBffB  B  BffBBǙB  BB˙BB  BǙB  BB33B33BB33BיB33B33BBffBBffB33B  BffB  BffBffB  BәBffBBffBB  BBffB  BB33BיB  B33B33BffBBBffB  B  BffB33B33B33BљB33BffBBЙBϙBffB̙B33B33BffB  BΙBffBffBBB33BffBB  BffB  BffB33BffBBffB  BřBƙBffB  BB  BffBB  BʙB  B33BffB33BffB  BB  BəBΙBB33BљB33B33BB33BəBffBffB֙B  B33B33BљBBBԙB  BffBffB  BޙB  B33BB  BffB33BݙBB33B33BffBٙB33B  BBffBBBffB  B  B  BffBffB  BffBǙB  BBڙB33B̙B  BffBҙBB33B  BffB33B͙B͙BffB  B33B  BBffBffBffBBʙB  BʙB33B33BBffBB33B  BffB  BB  BffBffB  BffBBBB33BљBәB33BffBffBffB  B  B癚B  BBffBffBffBB  BB  C ffC  B  BffB33BBB33BffB홚B뙚BݙBBՙBffB33B33B33BٙBffB33BffB  BٙBڙBؙBؙB  BיBffBffB  B  BffBיBBBffBBffBΙBffBffBΙB33BffBffB33BBffB  BΙB33BBffBęB  BffBBffBęB  B33BBB33B  B  BB33BB  BB33BffB33BǙBB33BBffBffBљBB33BՙBܙB33BffBffBB  BffB㙚B33BffB  B33B33BB33BBBB홚BBB  BB33BB33BffBיB33B33BffBBffB  BffBffB  BޙBB  BBB33B  B  B͙B  B  BffB  BBB33B  BB  B  BffB33B  BřB33BB  B  BBB  B  B  BB33B  BB33y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y BBBڙBܙBBۙB33BffBB  B晚BffBBB晚BffBB  BڙBBffB  B33BB33B  B  BBəBșBffBșB33BșB33B  BffB33B  B33BffBB33BBBϙB33B֙B͙BffB33B33B˙BffB  B  BBBBffBBBBBBBB33B33BffBЙBB̙BBffBBBffB  BB33BffBЙB  B  BffB33B  B  BB  BBffCffC
33C33CffCfC33BC	C
CC CC  CLCC  CLCfC  C  CC
33C3C3CffC
C33C3C  CfC 3BBBffB  B33BffBffB33BffB晚BffBffBB33B33B33BffBB  B33B33B  B33BB33BB33B  BBffBߙBB33B  B˙B  B33B33BBffB33BBffBffBBϙB33B  B33B33BffB  BB  CC
ffCBCffCfCLCC33CC3C3C  CfC C CC33C33C33C ffC$  C(3C+fC133C.C+LC2  C/C.33C.33C-  C*LC)C"C33CCCLC" CfC  C C  C  C CfBffC CfC3C  C	 CffC  CLC3C3CffC CfCCfC3CC33CLC  CLCCCLCCCBB  B  BB33B33B  B33CffCCfC33BffCffBCffCC	C	C3BB  BꙚB33C
ffCLC33C3CffC
fCffCC  C33C CCC#3C  CfC 3C#LCfCffC$  CLCC  C$ffC*3C*ffC"33CC C33C3CCBCfCffCfCLCBBB㙚BffBffBBffB  B왚BffB  B뙚B33BᙚB33BߙBffBffBBffBffB33BBBffC BBffB왚BBffB33BffB  B  B  BffB33BffBߙBBffB33BB33B  BffBB33BB뙚BBB  B  BffBffC 33B  CC C 3BBB  BBBB  BBB33C CC3CffCCC
3CC
ffC BB  BBBffB33BBffBffBB  B  B陚BffBffBB  BffB33B33B  BBffBffBBBB33B33B֙B  B֙B33BffB33B33B33BәB33BffBffB33BϙBBB  BffBB33B33B33B33BffB33BffBBffBBЙB  BffB33BB33B33B33BffBffB  BffB  BᙚB33BBC   BffBBB  BffB33BBBffC3CffB33CffC	 C
33C C
CCCLC
3B33BffBffB  BBffB33B晚BB33BᙚBffB33BۙBffB33BՙB֙B  B  BBB  BәB33BB  BffB33BffB33B  BffB  BBffBffBB  B33B♚BۙBߙBB33BBB33B33BݙB̙B33BffB  B  B  BBffB33B33BB33BffBBܙBBB33BBffC LB33C 3B33B  CLCLBffB33B33BBBffBffB  C C33CCCCLCfC3C BffBBffC B  BBB33B33BffB  B33BBBBffB33B  BffBB33B  B33B  BBϙB  BϙBffBffBffB˙B˙BB33B  BffB33BffBffB  BffB  B  B̙BffB͙B  BffBęBԙBڙBәBffB33BffBffB  B33BÙBffBBB  BBBffB͙BffBB  BB  B33B33BB  B33B  B  BffB  B33B33BffB噚BffB  BffB  B33BB33B33BB  B  BBBffBB33C BffB  B  BffBffBB33B  B33BBffB33B㙚BffB  BB֙BՙBffBBffBיBffB33BܙB  B33BBBBB  B  BffBBBffBBffBBBffBBBB33BffB33BBʙBBəBffB33BffB  BBffBڙBffB˙BffBB  BڙB  BffBffBffBBٙB33B  BffBffBB33B  BffB33BB33B33B  BB33BBBffBB  B  BBffB  BffBffBB  B  BB  BߙBᙚBffB33B33B33B  BffB  B33BBffBBB33B  B33B33BЙB̙B͙BffB˙B  B  B  BBB33B33B33BffBffBřBffB  BÙB33BBBffB  BffB33B33BBBBB33B33BBffBffBffB  B33B˙BB33BәBffB33BffBљBәBBיBٙB33BB  B33BffB33B뙚B33B33B뙚B33B33B33BffBffBffBffB33BBB33BBB  BBB  B  BꙚBffB  BꙚB왚B  B33B  BffBB  B  B  BB33B̙BB  B  B  B  B  B33BBϙB  BљB  B33B͙BffB33BffB33BB  B  B33B33BffBffBB˙B˙B33B33BәBB33B33BәBԙB  B  B  BBڙB  BBߙB  B33BB  BBBC C3C  C  CC
C33C
fC  CLC33C3C CffC C33CLC
 C
33C3C  C  C  C3CffC33C33C	fC
 C CC33CffBB33BffB33BB陚B癚B癚BB  B癚BffB33BBB33B  B33B  BB33B왚B  B33BBffB33B  BݙB  BۙB  BBB33B33BؙB  BffB  BۙBB33BffBꙚB  B  BffBBffBffBBB33BB  CCffCfC  BCffBffBBB33B33CffCC  CC  C33BBBffC CCLC33C fBffB  C 3BBB33B  BffBB  B33B  B33BffB  BffBffBB33BB33B  BffBB왚B홚BBB33BffB癚BffB  BBBBBBffBB33BffBffBffB噚B䙚BffB㙚BffBBffBB왚B  BffBꙚB  B33B왚B  BBffBffBB33BBffBffBC C  C  C3C
C  C3C3C C33C C CfCfC!33CfC33C#fC$ffC&C#fCC C  C#fCLCCLC  C3BffBBffB33B33C LC  B  B  CCLCfBCLB  B陚B  BBB33B33B  BffBffB33BBB33BBffBffBBffB33B֙B  BؙBBBffB֙BۙBBffBיBBؙBffBڙBB33B33B33B  B  BB왚B  BBffB♚B홚B33CCffCLCLCC  CLC3CCfCCffCCfCCfC3CCCffCLC3C3CC  CLCLC  CCffCC C CfC
33CLC  CCfCffCBCLCBffC33CLC33CBBB33BBffBB  BB33BB  B  BB  BffB  B왚BB  B噚BBB33B33B33BBݙBB  B33BffBffBB33BffBޙBBB  BB  B  B왚B33BB噚B陚B  BffB33B  B33C CC	 C  C C C
3CC
ffC  CC3CfC  CCffCLCffC33C  C3CLC C  C
LB  C
C
3C
  CfCC3B33B  BB  B  B  B33B33B  BB33B33BB왚BBffBBBffB33B  C 33C CB33C fCfCBB33BBB33BffBB  B33B33BffBBBꙚB  B33B왚B  B噚B33B癚B33B  BBffB33B33BffB33B  BffB33C3CffC33CCCC CfC3C
33C
C
 C3CCffC3CffC CLCfCfCC33C3CCC3CLCfC CLCC3CC  CfC 3B33B癚BB33BBBBffB33B33C  BffBB33B33BffC   BffB33B  BB  BB홚BB  BB噚BB  BffB33B33B33B  B33BffB♚BB33BffBՙB33B33BBܙB  BffBBffB33B33BffBffBBB33BB33BffB噚B  BB  CCCLC
ffC3CLCffC3C CfCffC3C  C CCC CfC3BffC  BffC	ffCCffCCfCBBffB  BB33BffB33B33BB33BBB  B33B  B33B33B  B֙B33BffB33B33B33B  BߙB㙚BffB33BԙB33BBffB33BB33BffB33BB  BffB͙BB  B  B  B  B  BffBB̙B33BڙB33BffB33B33BffBBffBffB♚BᙚBBꙚB33B  BffBB33BffBBB33BffB晚BᙚBBffB  BffB홚BffB  BB  B  BffBB  BffB̙B33B33BBҙBҙBffBffB33BșBƙBffBBBęB33BffB  BșB33B  BBBffBBB33BBBBffBʙBBffBəBBffBffBBBBBB  BBB33B  B33BBffBBffBBBffBffBBșBB  BB33B33BffBB33B33B  BՙB33BBffB33BffBBffB  B  BBB  B33BܙBBBffB33B33BؙB33BffB晚BffB  B33BffB  BffB֙BffB  B  BϙBΙB  B̙BffBBffBșB  BǙBffBffBəB  BffB  BƙB33BffBǙBBBffB33B  B  B  B  BBffBƙB  BB  BB33BBřBBB33BffBffB  B33B  BB33BB33BBB  BB  B33B  BBffB33BB33BB̙BBԙBBffBBљB  BԙB  BffBBۙBffB33BffBљBffB  BffB33BffBffBffBffBffBBffBffBffB33BBffBΙBBffB33BBҙB͙BBԙBBBșBB  B33B33BΙBffBffBffB33BffB  BffBϙBB͙BffB  BffBBB33B̙BB  B  BBBBBBffB33B33BBffB  BBBęBƙBB33B33BffB33B  B33BffBۙBۙB  BݙB33B  BffBffB33BffBffBffB33B  BffB33BB  B33BffB  C C	C33C CC C  CCBBffBBffB癚B33C 33C33CffBB33BffBffB  BffB晚B33B33BffBB  BߙBB  BffBB㙚B33BB  B33B33B33BffBffB33BܙBB33B33BBΙB  B33BffBffBՙBʙBffBB  BffBBЙBBB  BљB33BffB  B  BBԙBB  B33BB  B33BB33BB33B33BffB33B33B  BffBBffBCLC3CCC3C33C
fC3CffC33BCBffB  BffB虚B噚BffB33B  BffBߙB  B  BB33B  B  B  BݙB  BB  BffBffBffBB  B  BffBffBBЙB33BB33BәB33BffBffB33BffBffBB  BffB  B  BԙBԙB  BәB33BәBԙB  B  BffB  BffBffB  B33B33B33B33BffBffBB  B  B  B33BffBC C fCCCC CC CCLCCffC	 CC CLCCffC	33CffC3CLC	fCffCffCCfCC33CfCfC
  C	C CC
C
  CfCC33BB  BꙚB  BBffBffB33BffBᙚB33B晚B  BBffB33B陚B  BB33B  BffBffBB  BffB  BꙚB  BffBffB  B㙚B33B33BޙBffBB33B癚BffBffBffB虚BC CC C BffB33B33B  B33BC  B  BffBffB33CB  BB  B33CBBB33B33BBB뙚B33BffBB33BffBB虚BffBBBBBffB33B33B  BיB33BffBffB  B33BffBffB  BBיBB33BיB  BBיBBffBәBB  BϙB  B͙BffBB  BBffBffB33B33BBB  BϙBffB  BϙB  B33BffB33BBBљBBB33B  BBBffB33B  BÙB  BB33B33B  BؙB33BBϙBffB  BBٙB33BB  B  BffBB33BəBffBffBԙBBBB33BBffB33BffB  BBffB  B33BBBBBffBBBB33BffBffBB33BffB  BffB33BBBB  BBÙB33BffBBffB33BBB33B  B33B  B33BęB  BÙBffBÙBBřBBBęB  B33BBffBffB  BřBB33BBffBffBffBffB33BB33BBBffBB33B33BǙBșBBffBB  BԙB֙B33BܙBBffB33BB  BϙB  B  BřBƙBffB33BB  BBיB33BΙBffBffB  B  B  B  B  BBB  B33BB  B  B33BB33B33B  B33BffBB  BəBęB  BB33B33B  BffB33BffB33BBffB33BBBBB  BřB33B33BÙB33B33BșB33BffBBB  BffB  BB  BffBBșB33BffBBffBffBB33B̙B33BBffBəB  BffBB33BffBffB33BffB͙B33BffB  BB  BffB33BffBיB33BffB  BffBÙB33BBBBřBřBffBBBffBB  B33BBffBffBBBBffBʙB  BBB33BffB33BBBBffB33B33B  BB33B  BffBBffBBffB33BBB  BffB  B  BBffB  BBB  BB  BBB  BBB33B  BB33BBffBffB  B33BǙB33B  B  B33BffB  B33B  BB  B33B33B  BBffBBǙBB33BBÙBffBB  BBBB  BffB33BBBffBffBB33B  B  BffB33BBBBBBffBBB  BffB  B33BBBBBBBB33B33B33B  B33BffBffBB33BffBBBB33B  BffBBffB  BBBBBB  BBB  B33B33B33BB  BșBəB  B  BB  B  BBBřB  BffBB˙BәB33B33BB  BffBљBffBϙB33BBB  BЙB  B33BffB33B33BBBΙBBB  BBƙBffB  BBBƙBBBBÙB33BffBB  BffBB33BffB  B33BffB33BffB  BƙBBffBB  BffBffB33B33BəBęB33BffB  BșB  B  B  BB33BϙB  BffBBBffB  BffB  B33BB  BffB  B  BBB33B虚BB  B  B虚B33BB  BB뙚B噚B33BffBffBffBB33BffBޙB33B33B  BܙBיBB33BffB  BיB  BؙB  B33B33BՙB33BffBffB33BBffBЙBffBffBљB33B  BffBffB  BBЙBffB  B  B  BҙB͙B  B  BB  BffBffB͙B  BB  B33BәBҙBҙB˙B33BәB33B  BffB  B33BffB33B  BffB  BffB  BffBљBܙBޙB33BڙBߙB  B33BffBBffB33BffBB33BffBB홚BffB33BB  BB왚BffBffBffBB  B  BB  BBBޙB  BffBffBۙB33B  B33BԙBәB  B33BЙBBffB33BΙBB  B33BB˙BB33B  B33B  B33B  BBffBB  BBffBB33BffBffB͙B33B33BBϙB  BffBffB33BBBڙBB  B  B♚BB  BߙB  B33B噚B33BBB33BffB  B33B  BB왚B33BBB  B33B陚B虚BBBffBffB  BB33B  B33B33B  B  BffBݙB  BffBBBBՙBffBffB33BәBffBҙB33BffB33BB  B͙B̙B  B33BffB33B  B33B  B  BffBBB  BffB33BҙBffBәB33BB  BffB  BB  B  BəB33BљBffB  B˙BʙB͙BffB  BΙB33BffBBBԙB  BBܙBBB33B33BffB33B  BBffB  C  BC 33BffB  B  C ffBBB33BBffBffBB♚BffB33B  BffBәB33BffBBB  B33B33BB  BBәBЙB33B  BBffB33BЙB33BיB33BffBffB  BΙB33B̙BffBffB  B  B  BΙB33B  BřBffB33BffB33BffB33BBʙB  BBB33BB33B33B̙B  BffB̙B̙BϙB  BՙB֙B33BBffBffB֙BffB33BffB33B33BffB  BBۙBffBיB  B  B  BBBBB33B33BBffBBBB뙚BffB33BffB33BB33BB̙B̙BșBB  B33BffBǙBffBBffBBBffB33BęB33B33BƙBffBșB33B  BՙBffBЙBffB33B  B˙B  B  B˙B33BffB33BB˙BffB33BÙBƙBʙB33BəBBB˙B33BffB33B͙B  BBBB  B33BܙB33BffB33BB33B33B䙚BffBffB  BffB33BffB  BBBffC LBC ffC CffCCffC3C B33BffB33B虚B33B♚B  B  BݙBܙB  B33BיBffBffB33BBљBB33BffBB͙B33B33BʙBffB33B33B  BB  BffB  B33BBffBBǙB33B33BB  BffB33B  B33BǙB  BB33B  BB  B  BffBffBBB33BB33B33B33B̙BBffB֙BffB33B33BBB33B  BBB33B  B  B♚BB晚BffBB  BB  BffC  C   B33C B33CffC33C	3C3C  C
ffC BCB  C3B33B  BB33B33B33B33B왚B  BBffBffB㙚B  BffB  B33BffB  B33BffB  BBffBffB33BffBffBffB  BB֙BBffB  B홚BffB33B  B  BәB  BB  B33B  B  BffBB33BՙB  BffBB  B  B  B33B33BB虚BBffB33BB  BBBBBBffB  B  CffCLC3CffC  C3CC CCffBC C
C3CCBffCLB33C 33BB33BffBBffBB  BٙB33BB33B33BәBffBB  BffB33BٙB  B33BffBșBəB  BffB33BffBffB33BЙB33B33B  B  BB  BǙBffBęBǙBęB33BB  B33B33BffBffBʙBBBΙB33BљB33BՙBffBB  BBffBffBBffBffB33B왚BffBBffBffBffC fCffCLC  C
  C CffCC  CffCCC
fC C  C33C3CfCCB33CLCC CC33CBffBffCBffBffBffB33B뙚BffB33BffBCfCLC CCBffBffBB  C BB  B왚BffBBB33B  B33BBB  B  BB  B33BיB33BffB  BBՙBffBffBޙB  BffB噚B♚BC33B33BBBffBffB  BB  BCffCC3CCC33C  CLCC C	3CLC	ffC
LC3CfCCLCfCCLCCC3CCffCfCfCC3C
 C
C33C
CCffB33C C
fCBBffCLCffCCfBffB33BffB  B  B33B  BffB  BBffBffBꙚB陚B33B33B33B33B  BڙB33B  BݙB33BB  BڙBB  B33B晚B  B  B33BffB33BB33BB33B  B虚B33BBffBC33CC  C	  C CC3CfC C33C  C	  CC
LCCC33CffCCfC33CLCC C33CLCLC  C CLC3C33CffC3C3BB33BB  B  BffB33BBffBBffB  BB  B홚BffB  BB33B33B晚BB  B33BffBBffB  B  BΙBB  BBҙBffBB33BffBB  B33BffBffBB33BffBffB䙚B33BB33B33BffBB  B  B  BBffB33B33C B  B  B  BB  C ffC CfCCC
C
ffC C
LCLC
ffCLC
CC
C33CfBC BffBB33C
C	3C3C	3C3C CCffC33C33CfC33C C33B33B33B  BffBBffB33BB  B33B33BffBB  BffBʙBffB֙B33BBffBBffB  BB  BΙB33BB33B  BʙBԙB33BffBffBffB33B33BffBffBB  B  B䙚B晚BffB癚BB  BBffBBffBffCCCC  CBffB陚BffB33BBꙚBB  BB虚B33BB  BBffB33BB  B  B  B  B  BffBڙBffBffB  B  B33B33BʙBffB33B͙B  BBBffBffBBBffBB33BBșBB  BBBBffB  B̙BffBBBBffBffB  B33BÙBffBB33BBB33B  B33B  BB33BBB  BBBffB  B  BB  B  BBBB  BffBBffBffB33B33B33BffBЙBљBؙBffBB  B33B  BBffB뙚BffBffB  BԙBBffBBBÙBffBffB33B33BęBB  BB  B33B33B33BB  BffBffBB33B33BffBB  BBBBffBB33B33BffBBffB  B33B33BB  B33BBB  BB  BBB  BBBB  BB33B33B33BB  B  B  B33BBB  BffBBffBffBB33B33B33BB  BffB33BffBBBBBBffBB33BB  B33BB  BB33B33BffB  B33BBB33B33BffBBB  BffBffBffB33BB˙B33BffBBșBřB  BBffBB  BB33B  B33BBBBBffBffBBBBBBBffBBBB33BB  BffB33B  BB33BB  BBB33BBBffB33BffBBBB33BBB  B  BBBB33BBřBBșBffB  BffB33B̙B  B33B  BffB33BffBљB֙B33B33BBݙBޙB  BߙB33BffBBffBBffB  BffB  BffBܙB33B33BB33B  BB  B  BB  B  BؙB  B  BB33BffBffBffBBffB33BffB33BΙB33BBB֙B  BԙB֙BB  B33B̙B33B  BffBB  BffB33B33BBffB  B  B  BffB  BBffB33BffB  B  BffBҙBʙBəB33BљB33B33BڙB  B  BB33B㙚BB33B33B33B  BffBffBB33BBffBffBBBBffB  B  BffBffB  B  BBB  B  BffBffBBffB  BЙB  B  BB33B33B33BB33B  B  BffBǙB33BBffB33B  B  BffBB33B  B  BffBBffBB33B  BB  BffBffBBB33B33B  BffBffBB33BBB33B  B  BffBB  BʙBffB33BBffB33BffBffB33BffB  B33BٙBffB33BffBffBљB33BЙBffB  BBBϙBΙBffB33BBљBЙBB  B33BffBffBffBffB33BəBřBBffBB33BB  B33B33B33B33B  BB33BBB33B33BB  BB  B33BBffB33BffBBffBB33BB33B  B33BB  BBBBBBBffB  BffB  BffBBffB  B33B  BB  BffB  BBB33BB  B33BBBBffBBBffBBBB33BffBffBBBffBBffBB  B33BBBBffB  B  B33BBBB33B33BffBBBffBffB  BB33B  B33BB33B  BB33B  BffBBB  BBBffBBBBBB33BB  BB  B33B33BBBffB33BB  BBBB33B33B33B  B  BBBB33B33BffBffB33BffBB33B33B  BB33BffB33BffB  BBffBffB33B33B33BffB33BffBB  BBB33B33BB  BffBB33BB33BBffB33B  BB  BBBBffBB33B  BB33BB33BBffB  BffBBB  BB  BffB33B33B33BBBB  BffBBBB33B33BffB  BBffBB33BBffBffB33BffB33B33B33BB33BBffB33BBBffBB33BB  BęB33BffBB33BffBBΙBϙBffBB  B33BffBBڙBߙB  B33B㙚BBffBffBݙB  B虚BܙBۙB33BBB33BB  B  BϙB  B  B  BBΙB33BBB  B33B33B33BB33BBBffBBffBffBffBęBffBB33B  BęBB33BffBffBB  BB33B33BffBffBƙB  BffBB33B  B  BB33BB  BB33BffBffB  B  BffBB33BffBffB̙BΙBffBΙB  B33B33BҙB  BB33BΙB33B  B33B33B33BBBB  BffB  BיBffB33B33B33B  BffBBϙBBffB33BBBBBffBșB  BǙBǙBƙB33BƙBffB  BřB33BBBBffBffB33BB33BffBffBffB33BBffB  BBffBBBB  BffBffBBBB33B  BffBBBffBB33BffBBB  B33BřBBBB  BBffBffB33BffB  BffBBBffBBB33B33B33BffBffBffB33BޙB  BffBffB  BffB33BB33BBffB33BݙBffB33B33B  BffBBffB33BٙB֙BffBϙB33B˙B33B33B  B  B  B  BffB͙B33B33B  BϙBffB33B33BB  BǙB  B͙BBffBB33BffBffBʙBəB33B  BffBB33B33BffB33BB33BffBBB33BffB  BؙB  BffBffB33B䙚B33B33B癚BffB  B噚BBBޙB  B  BffBB  BڙB33B33B33B33BB33B33BBݙBڙBBffBB  BBBffBBffBffB  BffB  B  BBffBffBffBffB  BƙB33B33BffBЙB͙B  B33BffBffBΙBffB  B33BB33BƙBBBffBffBffBffBBBffB  BffB33BBffBffBBB  B33BB33B  B33B33BffBB  B33BB33BffBBB  BBffBșBffBB͙B˙BƙBffB  B  B  BffB33B  B33BB33BB  B  BߙB  B33BffBBffBՙB33B33B33BB33BٙB33B  BB33BffBffBBffBffBΙB˙B33BffB˙B33B  B  BƙBB33B33B33BffB  B  BB  B33B33B33B33BB  BffB  BffBBffBffB  BB  BB33BBB  B33BffBffB33BB33B33BB  BЙBffBΙB  B33BffBЙB  BffB  B  B33BBؙB  B33B33B  BۙB  B33BffB33BBffBݙBB33B33B33BᙚBffBBBffB33BBB33B  BffB  BBBBB33B  BBҙB33BϙBЙBיB33BBffBffBЙBffB  BBffBffBB  B33B33B  BBB33BBęB33BB  B33BBffBBBB  BB33BBBB33BBffBffB33BB33B  B33B  BB  BʙBffB  B33BffB33B33BffBffB  B  B̙BΙBBߙBЙBBҙBәBԙB33B33BBffBB33BBB33BffBffB  BB33BיBBٙBٙB33BffBffBʙB  BffBffBffBיB  B  B  B33B  BЙB  B  B33BB33BBșBBB33BęB33BffB  BBșBffBǙBƙB  BÙB33BBffB  BB  BB33B33B33BBƙBBB33B  B  B  BBBffB  BBBB33BffBffB  BffBBBB뙚B33BffB  BBB33BB  BffB33B㙚BB  B33B  BꙚBBffBffBB  BBffB  B  B33B33B  BB홚BffB  BB33BҙB33BffBB  B  BBffBffB  B33B  BBffBB33B33B33BffBB  B33BB  B33BԙB  BBՙB33BB33BۙB  BffBffB  B  B  BB  BffB33B  BB  BՙBffBՙBՙB33BBB33BיBڙBffB33B  B  BBffBffBߙBߙB  B  BԙB  BݙBffB33B  B  B33B  B33B33BBffBffBBB  BBffB  B  BffB  B33B  BϙBϙB33B̙BBʙB33B33B33BΙB  BffBΙB  B  BffB33BBB33BBB  B33BffBffBffBffBBƙBB33BffB  BęBB33BB  BřBffBB33B33B  BffBB  BffBB33BB  BffB33BffBffBB  BBffBΙB33BB33BҙB  BffB33B  BB33B  B33BffBB33BٙBڙBBffBٙBBB33BffB33BΙBffBϙB  BffBffBffB33BffB  B  B  BffB  BffB33BB33BffBBϙB33BBBB  B33BffBЙBΙBBBB  B33BBB  BBB  B33BBffBBB  B33B33BB33B  BƙBffBB  B  B33BB  B33B33BffBffB  B  BffBB33BBffB33B33BffBffBB  BBB  BB33BffBٙBffBffBәB33B33BffBיBϙB33B  B  B  BBBB̙B33B  BB˙BB˙B  BBffBffBffB33BB  B33B33BB  BBffBԙB33BffBBB33B  BՙBffBәBffBޙB33BB  BB  BBBڙB33B33BۙB33B  B33B33B  B33B֙B33B  B  BffBffB  BBBffB  B33BBBffB͙B  BffBәBәBB  BBffBB֙BffB33BΙBB  BffBffBffB͙B  B33B  B  B33BBҙB  BB  BęB33B33B  BΙBffB  BffB  BBșB  BB33B  B33BB  BBBffBřBB  B33BBBB33BffB  BffBB  BBffB33B33BffBBęB33B  B  BBęB33B  BƙB33BffBffBBBB  B  BffB  B33BBBBffBffBffBǙB  BƙBBřB33B33BffBffBęBffB  B  BBB  BffB  BffB33B  B˙B  BǙBffB33B  B  BffB33BBB33BB33BB33B33B  B33BB33B  B33BB33BBBBBffBB  BBffB33B  B  BBBBB  B  B  BBBB33B  BB  BřBBBffB33BB  BBBÙB  BffB33B33BBB  BBBffBB  B  BffBÙB33B  BffB  BB33BBB33BBBBBffBBB33B  B33BffBffB  BffBęBřBffBÙBBBșBffBBffBʙB  B33B33B33BęBffBB33B  B  B  B  BffBffB  BBBB33B33B  BB  B33B  B  BffBffBBB  BBffB33BBBBBffB  BBB  BBB  BBB  B33BBffB33BBB  B  B  BBB  B  B33B33BBBB33B33BB  BBBffBB  BƙBBffB  BB  BffB33B33B  B33B33BffB  BffBB33B  B33B  BBffB33BffBffBffBB  BB33B  BB  BffBffBBBffBBffBBffBBffB33BB33BB  BB33B33BBffBB33BBB33B  B  BffB33BffBffBBB  BffB  BffB33BffB  B33BÙB33B33B  BǙB  BBBʙBBBBřB33B  B33BffBB33BșBəBffBffBffBB  B  B  BffBʙB33BBBBB33BəB  BB33BBřBB33B  B  BB  B33BęBB33BęBBęBffB33BffBffBřB33BffBB33BBffBęB  B33BBffBBffBBBB  B33B33BB  BffBBffB33BffBB33B33B  BB33BBBBffB  BffB33BB  B33BB33BBB33BffB  B  BffBffBBʙB33BB͙BffB  BffBΙBΙB  BffB33B33B  BB͙BҙBffB33B  B˙B33BBffBffBffB33BB33B  B33BffBB33B  BffBƙB33B  B33BffB33B  BBffBBB33BB33B33BffBB  B  B  BB  B33B  BBBB33BBBffBBB  BęBęBffBBřB33B  BB  B  BffBƙBBBffB  BBffBBB˙BffBB  BffBϙBffB  BљBffB  B  B  BΙBBΙBffB  B  BB33B  B  BffBBffB֙BBffBBffB33BBBffBBffB33BBBffBffB33BșB  BBB33BBBBęBffB33BffBffB33BřB  BffB33BffBBffBB  B33BBffB  BBBșBBƙBffB33BBffB  B33BęBÙBBșB33B33B  B33B33B˙B˙BBffBffB33BЙBљBљB  BәBffB֙B33BffB33B֙B  B  BffB33BҙB33B33B33B33B  BffB33B  B͙B  BBBffBBffB  B  B33B33B˙B  B  B33BB33BřB  B  B33BB33BəBB33BBəB33BB  BffBșB33B33B33B33BB  BffBșB33BffBșBǙBęBřBB33BffBB  BBBffB33B33BffBB  B33B  B  B  BϙBffB  BffBffB33BBB33B33BBBffB  BffB33BB  B33BffBB  BBʙBBffBљBffBB33BB  B33BBffB33BB˙BB33B  B͙B  B  BB  B  BffBffBșBffBʙB  BBffB33BBBəBB  B  B33BffB  B33BffB  B  BB  BÙBffBBB  BffB  BęBBB33BffB33B  BB  BBffB33B  B  BffB33B33BșBʙB  BB33B̙B33BBffBffBffBșBffBəBffB  B  B33B  B33B  BffB  BB33BBЙBB33BBB33B  BBBBB  BffB33BBBffBffB33B  BffB33B33B33BBffBB  B  BBffBBB33BffB  BffBB33BB  B  B33BBBBBB33B  BffB  B  B33BB  B  BffB  BBffB  BffBBB33BBBffBffBffBB33BB33BffB  B33BB33B33BǙBffB  B33BffBBəBB  B  BffBBffB33BffB33B̙BBffBBΙBB33BffB33B  BffB͙B33B  B33B˙B  BBBffBB33BBffB33B  B  B33B33B33BffBBB33B33B33BffB33BB  B  BęB  BffB  B33BBB33BffB33B  BffB  BBB  B33BBB33B  BffBffBB  B  BBB  BB  BBffB  BB  B33B33B̙BB33BBBBffB͙BϙBffB33BB33BffBffBʙBəBBBB33B33B  BBffB33BBBBffBffB  BBBBffBBB33BBffBB33BffB  BB  BffBB33B33BBBBffBB  BBffBB33BB  B33BB  B33BBB33B33BffB33B  BffBffBB33BB33BffB  BffBffBffBBBBffB  BffBB33BřB33BB33BBBBffB  BB  BffB  BBffB  B  B  B  B33B  BÙB33BffB33BBffB33B33BBffBBBBB33B33B33B  B  BBffBffBffBB  B33B  BBffBffB33BBffBBB  B  BB33BBB  B  BffB  B  BBffB  B33BB  B33BBffBBBffBffB  B  B  BffBBB33BBBB33BB  B33BBBffBffBB33B33B  B  B  BffB33BřBęB  BBǙB̙BffB  B  BBB  B  B  BB33B33B  BBșB33B  B33B33B  BffBBB33BB33BB33B  B33BB33BBB33BBB33BffB33BffBBBB33BBffBffB33BffB33BB33BBffBBBffBBffB33BƙB33B  B  BǙB  B  B33B  BBffB33B̙B˙BffB  BffBBBB33B  B  B33B  B  BB  BәB33BB  BיB  B33BٙBٙBؙB  BffB  B  B  B  BݙB33BBؙBffB  B  BڙB  B  BB33BffBיBffBffB֙BffB33B  BffB  BB  BffBBB33B  B33BffB33BffBffB  BBffBיBB  BљBffBffB  BB33BЙB  B33BBffBљBB֙BBәB  BffBB  B  B33BffBffB  BffB  B  BڙB33BffBBffB♚B33BBBffB癚B癚B晚BBB33B33BffB33B  B33BB  B33BߙB  BޙB33B33B33BB33B33BЙBϙBҙBffBB33BffBBәBBffBBљB  BffB33B33B33B  BB33BșBBBB  BșBffB  B  B33BBBəBʙB33BffB33B33BffB  B33BB  BffB33B͙BBBBffB33BBB  BB  BۙB33BB33BߙB33BBffB  B䙚BB  BffBffBB33B  B  BBffBffBffB33BBBBBB33BffB33BffB뙚B홚BffB33BffBffBBB癚BB㙚B㙚BffBffBBB晚B33B33BffBffBB䙚BBBB33BB  BBBffB  B  BBB  BB  BffBؙB  B33B33B33B33B  BԙBB33B33BڙBffB  BڙBB33B  B  BB33BBB  BffBffBҙBB  B33BٙBB33BB33BBffBۙB  B  BffB  BffBᙚB♚B33BffBB33BffBBᙚB  B  B33B  B  BؙB33BB  BffBffBљBffBיB֙B33BəBB33B̙BB  BΙBBЙB  BffB33BBffB33BBB33B  B  BBșBəBəBʙB33BffBffBəBffBBffBșB  BBBǙBƙBBffBffB  B  B  BffB  BffB  BʙB33B  B33B33BffBffBʙBffB33B33B  B  BBffBԙBB  BffBffB  BޙBݙB  BB33B  B  B晚B33B33BffBݙBffBBffB  B  B  B33B  B33BBB֙BיBיBיB33B  B33BffBffBffBϙBBffBffB33B33B  B33B  B33BB  BffBBBffB33BffBƙBffB  B  B  B  BffB33BBęBęBBffBB  BffBffBBffBB  BB  BBBBBffB  BÙBǙBffBffBǙBBřB  BƙBBffBffBffB33B33B33B  BǙBffB  BșBB33B  B  BffBʙB33BBffB33B  BBBffBBǙBęBÙB  BB  BffB  BffBB  BffB  BffB33B  BB33B33B  BB33BffB  B  B  BB33B33B  BB33BBffBBBBffB33BBB33BffBBB33B33B  BBB33BBB  BBBBB33BB33BB  BB33B  B33B33B  BB  BЙB33BBșB33BBffB  BřBBffBB33B33B33BffB  BΙBffB33BffB  BB33BÙB33B  BBBBB  B  BB33BBBffB  B  BB  BęBÙB  BffB  BBffBB33B33BffBB  BffB33BffBB  BB  B  BBB33BBBB33BB  BB33BBffBBffBBB33BBffBBęBÙBBffB33BșBǙBBffBęB  B͙BB  B33BЙB33BәB33BB33B33BffBB  B33B  B֙B  B33B33BB33B  B  B  B  BBBʙB33BșBəBffBřB  BƙB33BffBBffBB  BęBffB  BB  BBƙBǙBffB  BB  B  B33B  B  B  BffB  BBffBffBBB33BffBBBBB33B  BBffB  BffBB33B  B  B  BBBB  B  B33BBB  BB33BffBřB33BffB  B˙B33BBҙBffBB33B  B  B33B֙BיBffBffBffBB  B  BffB  BϙBffB  B  BffBBB  BBʙBșBB  BffB33B  BBB  BffB  BffB33BB  BBB  BffBB33B33BB33B  B33B33BB33B  BffBBBBBBBBBB33BBB33B  BBB33B33BÙBB  BB  BBǙBƙBffBƙBBəBB̙BB33BϙBBB  BffBffB33B  BffBBffBB33BBәBffB  BҙBffBBffBBΙBΙBB  B͙BΙBffB  BBffB  BB33B̙B  BffBB  B  B  BϙB  B  BBBʙBB˙BffBʙB33B  BffBffBffB33B  B  BəB33B  BƙBffBffBB  BffBBB  BBBBffBffB  B  B33B  BʙBB33B33B̙BffB̙BffBBΙBffB  B  B  BB33B  B33B  B֙B  BƙBffBB33BBB֙B33BffB33B  BffB̙B˙BԙB  B33B33B  BBffBəBB  BffB  BBffBʙBB33BffBBffBBffBffBffBB  BʙB33BʙB33B33B33B˙B33B  B33BǙB33BffBB  B  B33B33B  BBffB  B33BÙB  B33B  B33BBB  B  BB33B33BBffBBǙBB  BƙBșB  B33BffBBřBșBB  BBBffB  B33B33BBffB33BBЙBҙBΙB33B  B33B  BffB  BffBffB  BffBB̙BB  B  BffB  BBęB33BffB  BffB  BB33BB33BB  BB33B33B  BffB33BBB33BƙB33BffBB  BBBBBBBBffBffBBBBB  B33BB  BBBffBÙBffBffB  B33BB  B33BB  B  B33B33BffBffBBBBB̙B͙BBΙBЙBBҙBffBBЙBЙBЙB33BB33BљBϙB  BBffB33B̙B33BBffB33BΙBϙBffBřBffB  B33BBǙB  BffB33B  B33BřBffB33BBB  BffB33BBB  B33B  BęBffBffB  BBB33BBBBB33B  BffB33BffBffBffB33BffB  BffBffB33BřBffB  BBB  BəB  BʙBʙB˙B  B33BB͙B  B˙B˙B33B33BəBBəB  B33BBșBffB33B33B33BΙB  BЙBBffBЙBffBљB  B33B33BϙBffBЙBЙB  BЙBЙB  BB33B˙B  B˙BʙB33B33BBffB  BffB33BʙB  B  B  BBffB33B33BʙBB33BffBffB33B  B͙BffB̙B33B  BB  B͙BB˙B˙BffBffBffB33B33BffB  BffB͙BffB33B  B  BffB  BffBЙB  B  B33BBBffB33B͙B  B̙BBffBffB͙BffB33BљBљBЙB  BffBffBffBBB  B̙B33B  B  BřBBBęBęBB  BffBǙBffBBffBBǙBffBəBBB  BB  BffBB  BffBęBBÙBffBffBffBęB33B  BřB  BffB  BșBffBB33B33BffBǙB  B33BřBƙBBƙBBƙBffB33B33B33B33BB33BșB  BƙB  B33B33B  BBǙBBřBffBǙB  B33B  B33B33BB  BʙB33B˙BffBBB  B33B  B  BșB33BBffBffBB  BBBB  BBřBffBffBƙBƙBffBBffB  BƙBƙBƙBƙB33B  B  BffBffBffB33B33B33BęBB33BBřBffB  BřBBffBÙBB33BffBffB33B33B  B33BBffB  BBffB33B33BffBB33BffB  BBffB33B  B  BffBffB33B  BffB  B  BBęB33BffB  BffBffBșBBB  BffB  BffBΙB  B  BΙBΙBϙBB33BffB  BB̙BffBBșBəB33B  B33BB  B33B  BB33BffBB  B  B33BffBffBBBffBffBffB33B33B  BffBBffB  BBB33B33B  BB33B  BBBBBB  BffBffBBBBƙBB33BB33BffBB  B33B  BÙBęB  BffBffBB  BffB  BffB  BΙBffBЙBffBҙBBffBffBB33B  BffB  BffBBҙBffBffBffBәB33BBffB  BffBffB33B  BBBəB33BęBffBBffBBB  BB  B33B  B33B33BBBB  BBB  B  B33B33B  B  BB  BBffB  BBffBBBffB  BB33BBB33BBBffBffBB  B  BB  BBffBffB  B  B33B33B33B33B  BBBB  BB  BB  BB  BB  B33BəBB33B  BəBBffBffB33BęB  BffBBBB33BffBB  BBffB  BffBB  BBffB33B  BffBB33B  BÙB33BffB33BB  BffBBB33BBffBffBBBBB  BBBBBffBB  B33BffBBBffBB33B33BBB33BB  B33B  BBBBffBB  BffB  B  BBBƙB33BBB  BǙBBǙB33B  BəBB33BBffBB  BB  BʙB  BBʙBBB33BB33B  BffBƙB33B33B33BB  B33BffB33B  BffB33BffBBBBÙB  B  B33BffBBBB  BęBffB  BęBBBB33B  BB33BBBBffBB  B  B  B  BBBBffB  BB33BffB  BB  BBB33BB33B33BffB  BffB33BÙB33B33BB  BB̙BffB  B33B  BʙB  B33B  BffBffB  BBBΙB33B33B  B  B33B  BB  BffBBBBffBffBB33BBffBBęB  B33BBBBB  BÙBffB33BB33BffBBffBffBffBB33BffB33B  BffB33B33B33BBffB  BffBBffBBffB33B  BffBffBB  BffBffB  BffBBffBB33BffBffB33B33BBB33B  BBffBffB33B  BB33BřBBffBƙBƙB33BșBffBffBffB  BffB  BBBB  B  BB33BřBffB33BB  BffBBBBBBffBffBęB33B  BffBB  BBB33B  B33B  B33BB33BęBB33BffB  B33BffBBBffBB33BffBB33BffB  B  BffB33B  BffB33BBBffBBffBB33BB33B33BffBB33B  BBB  BƙB  B  BșB33BB͙B  B  BffBB33B  BffBffB33BBB33B̙B˙BffBBBBffB33BffB  BffB33BBffBϙBΙBffBffB̙B˙B  B  B33BęBƙB33BffB  BęBBffB33BęBffBBB33B33BBBffBBBB33BB33BB33B33BB  B33BBffBB33B33B33B  BBB33B33B  BffBřBBǙBffBəBffBffBʙB  B33B33BBffB  B  B  B33BffBffB̙BΙBϙB33BBffBffBΙBΙBBB33BffB  BffB͙BffB33B  B  B˙BBBBΙB  B  B  B33BffB33BffB33B33BBffB33BffB33BB  B33BffBB  BB33BB33BBffBB  BBB  B  B33BBffBffBB  B  B  B  BffBBffBBffBB  BffBffBB33B33B33B  B  B  B33BBffB  B  B33BřB33B  B33BBBșBǙB33BB33BffB  BffB̙B33B  BΙBΙBffBffBffBΙBB33BffB33BșB33B  BǙBÙBÙB  B33B  B  BBffB  BęB  BBffB33BffB33BffBffBBBB  BBffBffB33BB  BB  BffB  B  BffBffBB33BffB33B  B  B  BÙBBÙBffB33BBBB33BffB33BffBÙBBffBÙBřBB33BffB33BffBB33B  B  BBffBffBffBB  BљB33BBәBffB  BՙBՙBՙB  BffBՙBҙBffBՙBBB33B  B  BBB  B33BffB  B  B33BǙBęBB˙B˙BffB˙BΙBřBBB33B˙B  B33BBffBBșBffBǙB33BșB33B33BƙB33BffBřB33B33BffB  BBƙBBÙBřB33BffBBƙBřBBffB  BBffB33B33BBB  BB33BBB33B33BBBffBęB  BB33B  BșB33B  BffB33BəB  BffBB͙BB33BB  BBffB˙B  B͙BΙBBəBBBəBB33B33B33BB33B  B  BffBffBffBB33B33B  B33B  BffB33B  BffB33B33B  BB33B33BBffB33B  BBB33B33B  B33BBB33B33B33BBÙBÙB33BffB33BffBffB33BffBffBęB33BB  B  BÙB  BBffBffB  BB33BřBB33BB33B33BffBBřB33BffBșBBffB  BBBffB  B  B33B33BBBffBęBffB  B33B33BB33BBffBBBB  B  BffBBffBB  BB  BB33B  B33BÙBBBB33B  B33BBffBffB  BB33BffB  B  BffB  BB  BBBB  BBBBffBffB33BB  B33BffB  B33B33B  BB  BřBƙBBBffBǙBB  BffBffBB33B  B33B33BBffBʙBʙB  B  BffB33BBffBșBǙBřBffBƙBBșBBBBffBBffB33B33BǙBəB  BffBB33B  BffBÙB  BBBBffBffB  B  B  B33BÙBBB33BBffB33BBBBBBffBffB  BBBBBBffBffBBffB  BffB  B  B  BffBB  B33BBB  BffBƙBffBffBǙBffB33B  BșB33B˙BB33B  B  BffBB  BB  BBB33B33BffB33B  BffB  B  B33B33B  BffB  BBBəBBBBəBffBBəB  B33BBB33B33BffBBBəBəB33BəBəBəBșBșB  BB  BffBB33BffBșBB33B  B  BffB33B  BřB  B33BB  BffBBBffB  B  BBBBBffBƙB33BǙBB33B  B  B  B33B33B͙B͙B33BΙB33BffB33B  B33B33B  BBљB  BҙB  BBЙB  BљBBffB33B  B  BffBЙBffBϙB33BffB  B  B33B  B33BΙBffB33B33BB  B33BǙB33BșB33BffB33BffB33BǙBffB˙BəB33B  BffBB  BBB  BBƙB33B  B  BffBǙBBB33BffBB33BffB  BffBBəBffBșB  B˙BffB  B33BB33B  B33BʙBffB  BʙB33BffBBBB33BffB  BffBffB͙BBffBϙBB33BՙB33BBЙB33B33BB  BBBBB33BÙBBBffB33B33BB  B  BB33B  B33B33B33BffB  BB  B33B33BBƙB  B  B  BffBƙBÙBffBB33B33B33B33BəB  B33B33BəB33B  B33BffBB33BBffB33BBBffB33BřB  BB  B  BǙB  BffB33BB33BBffBB  BB  BffB33B33BBffBBƙB  BǙB  B33BʙB  BffB  B33BB˙B  B  B  BffB  BBřB33BBffBBffBB33BffB  BřBBB33B  BBB  B  B33BffB  B  BBBffBǙBB  BffBffBBB33B  BB33B  BęBffBffBBB33BB33B  BęBBffBB  BǙBffBșB  BǙBBB33BffBșBffBffB˙B33B  BB33BBffB  B  BffBBBBәB33BΙB33BΙB33B  BBBBB  B33B33BB33B  BBBBffBBffB  B͙B̙BBffB  BB˙B33BffB33B̙B33B  BʙBəB33BB33B33B33BffB33BffB33BBęB33BffBffBB33BșB33BB33B33B  BffB  BBșB  BffB˙B  BffBǙB˙B  B33BʙB  B  BffBBBffBffB33BB̙B  BffB33B  BșBffBǙBșB33B  BffB˙B  BffB33BffB33BffB  BBB  B33B̙B33B  BffBffB33BʙBǙBffB  BBffBBՙBffB33BәBffB˙B  BB  BʙBffB33BBșBəB  BəBffB  BřB33BǙBřBffBÙBB  B  BB33B  B33B  BBffBffBBB33BBffBffB  B  B33BBBBB33B  BB33B  BffBffBffBřBęBǙBB33BB33B33BB  B33B33BffB33B̙BffBffBffB33BffB˙BffBBʙBBB33BffBffB  BffBșBffBBșB  BBB33B33BB  B33BB  BffB33B33BB  BffBBÙBffB  B  BęB33B33BffBBB  BffBB  BBBB33BffBffB33B  BffB33B  B33B  BBB33BBBB  BBBB  BBB33BBffB33BǙBBʙB  BffB33B˙BffBB33B  B̙B33BffB  B  B33BBB  B33B  BffB33B̙BBffBB˙BBffBffBBB  BBșB̙BB  B  BəB  BəB33BșBBffBffBffB33B  BəB  BB  BBǙBșBBffBǙB  B  BșB  BBB  B  BffBffB  BBffB  B  B33BBB  BƙBřBBffBƙBffB  BffB  BffBęB  BffBB  B  BffBǙBB  BəB  BBffBəBB˙BBB  B  B͙BΙBB  BffB  BҙBffB33BB33BҙB  B  BBffBBЙBЙBffBBB  B͙BffB  BBffB  B  B33BB33BB  BffB˙B  B˙B  B  BffBʙBBB  BB33B33B33BBșB  BffB33BʙBffBffB͙BffBəBffBB33B˙B33BBʙBB33B͙B  B  B33B  BffBBBșBșB  BʙB  B  B˙B˙BBffB33B33B˙BB̙B  B  B33B33BffBBBBљBЙBB  BB̙BffBB  B33B33B33BffB33BB33BəBʙB33B  BB  BəB  B33BəB33B  B33BBB33BǙB  B33BǙBBffBǙB  B  B  B33BBffBffB33B33BffB33B  B  B33BBBB33BffB33BffBBB33B33B33BffB33B33B  B33BÙB  BBB33BB33BffBÙBffBřBB33BBffB  BB  BB33B33BəB33BB33BffBffBB  B33BəBǙBffB33B33B33B33BBffBB  BffBBffBffB  B33BBffB  B33BffBffB33BƙBBB  B  B33BffB  BB  BffBÙBB33BffBffBƙBffBB33BBffBB33B33BƙB33BBBƙBBǙBBffBșB33BəBB33BffBB  BǙB  B33BƙBffB  B  BffBB  B33BəB͙B33B  BșB33B  B  B33BffBəBffBBBffBB33B33B  B  BffB  BBffBBșB33BșB  B33B  B  BffBʙB33BB33BffB  BBffB  BBǙBșB33BșB  BB  BBffBffB  B  BffBB  B33B  B33B  BBBffBffBffBB  B  BffB33B33B  BffBBBBBBBB  BBB  BB  B  BB33BB  BBffB  BǙBB  B33BffBffBffBřBBǙBșBBffBBBB  B͙B33BffBřBffBʙB  BffBșB  BffBffBffBffBB  B33B  B  B33BBffBBʙB33BΙBƙB33B  BÙBffB33B33BffBB33BBffB33B33B  B  BffB  BBBBffBBB33BB  B  B33BB  BBffBBBBBB33BB33B  B  BʙB  B  B  B  B  B33BřBǙBffBǙBBffBșBffB33B33B33B33B33B  BBffB  BB33B  BBB33BffBffB  BffB  BB  B33B33B33B  BffB  BBǙBBffBffBB33BBffBBffB33B33BʙB33B33BffBBBB  BBffB33BffBęB  B33BffB33BBřB33B33BB  BęBffBB33BffB  B  BřB33B33B  BǙB  BB  BșBffBǙBǙB33B  BffB  BffB  B33B̙B  BffBffBB33B  B  BffB  BB  BBBՙB  BBϙBҙBљBffBffBBB  B  BffB33B  BBBffBffBҙB33B33B33BffB  BBffB33B33B  BB̙B33B33B33B33B  BB  B33BffB̙BBBBffB33BBB33B  BffBffBB  BffB33B33BffB33BBffB  BffBBffBffBƙBșB  BB33BB33B  BffB33B33B33BffB  B33BB  BљB33B  BϙBљBffBB33B33BffBәB  B  BBΙB̙B33BBffB  B  BϙBffB  B  BәBΙB33B33BB33BҙB  B33BәBffB33B̙B͙BB33BffBǙBB  B33BBffBffBB33BffBBffBB33B  B  B  B  BBBB33B  B  B  BBffB33B33BffBBB  BffBřBB  B33BřBffB33BB  BǙBffBffB33BB33B  BffB33BƙB33BffBffBəBffB  BBB33BBffBB̙B33B33BʙBBəBffB  B  BBffBƙBƙBƙBƙB33B33BffBBffB33BffBșBffB33B33B  BBBffB33BBB33B  BBB33BffBBBB  BB33B  BBffB  BffB33BffB  B  BB33BB33B33BB33BBffBffB33BB33BffBBBBÙBffB33BB33BBBffBBB  B33Bęy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y ARAAffA=qA(ApA=qA\A(A(AAAAAAAA(AAA33AAzAAffAffAA\AA\A
AA
AARAAAQAA{ARA\AAAA{AGA\)A
AAAHA
AffA(AAQA(AffA(A\A\AQAA(AzA\A
=A33AffA\)AA=qA(A\)AAA  A{AQA
=ARAA33AAA=qAA(AAA=qAzA\AAAA
=ARA(A{AAAAA  A  A{AƏ\AQAƏ\AÙA(AA
ARAzA(AAAApA(AAAǮA
=A33A  AȸRAȣA  AAɮAGA
=AAffA\)AzAQAAɮA  A(AQAȏ\AǙAƣAŅA33ApA(AA\AAAApA  A{A  AA{ApAQAŮApAQA\AQAGA33AAAHARAAAHA=qA  AŮAA\AAffA\AA(AAzAzAAˮAA(AQAȏ\AQAHA˅AʣA(A  AQA=qAzA=qA  AəAApAA  AzAzAQApApApAǅAƸRAGA
=AGAzApAƏ\AAAA\)A\)A{A\)AQA
A
=AzAɮAAƣAĸRAAAAAAA
AřAA
=AAA  AAffAƸRA(A\)AÅAffA  AzAģAAAffAApAA  A(AHAAA  A
=A33ApA{A33A33A
AffAřA(AzAƣA33AǙAHAffAģA(AŮAģAAAzAQAAAģAzApAGAQAQAA=qAzAAGAffAffA
A
=AHA  AffApA{AA\AA=qAAAAzAAAARAAQAAA\)AAAGAA33A33A\A{AA
=ApAA
AA33A
=AApA\)AA
=A
AHA\AA=qA33ARA\)A
A=qA\)AAA=qAQA{AAAAAAAGAAA\A\)AAGAHA\)AHA  A
=AAA{A\)A  A  AGA\)ApAzAAAA33A
AGAQA33A{A\AA  AAzAA
A  ApAAAAAAzAffARARARA33AA{AApAAQAzAAQAQAGA  A=qAA\AzAA33AAGAAzARAAHAA\)A(AA  AzAA
=AAzA\)AAzARA33A33A\)AAAGAA
A
AAA(AA
=AAA33ARAAAHAGAffAHAAApA{AAHAffA=qA=qAAHAAffAffA=qA\AffAAAAAApAAGARA
=AAAGA
=A33ApA=qA(AzA{AAGA{A(A\)AzAffA  AAAAA=qA(A  A{A
ARA\AAA{A  AApAffA\AA
=AA\AA(AAGA
=AAQA{AQAHAGAAA
A  A{A(A(A(AA33AAA\AAAAA  A
AA\AA\AQAA33AQAHAAARAGARAARAAAAAA33ARA33A  A(AAAAQAAQA\)AHA{A
=A=qAQAHAQAARAGAHAAzA{A33AGA
AGA
=AGAAAAA33ARA  AAA33A{AApAAffAHARApAAHA33AQA{A{A=qARAAApAA
=AA{AA  AAAAAA\AA\)AHAApA
=AA
=AAA33AAGAffAA{A\)A33A(ARA\A
A{AGA33ARAA
=AAQAzAGAzAHAzAA  A33AAQA
A
=A\AffA(AAQAffA
A
A
=AffA\A\AAAzAzAARA
=AA(ApAA\)A
=AGAAQA
=AAA{AA33AA33A
AQA(A\)ApApAAAA
AAAAzAAAAAffA
ARAQA33ARAA=qAAAAAGA33AA\A  AAAAAffAAffAQAAAzAA=qAAQAApA\)ARA=qA33A
A=qA\AA  AA=qApAGAzAAA\A\A(AzAAARAAAAA  AGAAA(A{AGAAApAffAQAHAA33A  AA33A
=AGAAA{A(AAAAAAAAA33AA
=AHA33AzA£A  AQAffAď\A
A
=AǅAAɮAAȣAA
=AAffA\)AQAƏ\A\)AQA(AAHAAÙA\)AƏ\AAffAÙAÅAĸRAAffA33AA\AApAA
A=qAA£AzA{A£AGA\)AÙAffA{AffAA  A\)AǙAřAffAA
=AAQA\AAAAAAAAÙAAď\A
=AAƏ\AHAzA\)AA{AˮA  ApAɅA{Aȏ\AAȏ\AɅAQAAAAƏ\A
=AAAAǮAzA(AHAAAAHAA(AGAAQA  A\)AHAAȏ\AGAApAAȣAAGAffAɅAQAAA{AzA=qApARAAĸRA\)AĸRAƏ\A
AŮAģA\)A(A33AAAGA\)AA\A33A{A
=AA=qA
=AɅA  Aʏ\A
=AA\)A
AHAA(A  AAˮAGApAAQA(A(A=qAɅAʣAHAǮAGAəAAɅA(AĸRA{AAGAAřAď\A
AAffAAȣA
=AAɮA  A=qAffAʣAʸRA=qAʏ\AɅA{AAAAzAAHA{AzAAɮAGAɮAȏ\A{AAQA(A33A
AəAȏ\AzAQA
=A
=AîA=qAAîAAAffA33Aď\A
AA\)AHApA33AAď\AHAģA  AîA=qA¸RA33AQAƣApApApAGAAApA(AǅAǅA33A
=AAAffAȏ\A(AffA
=AǅAǙApApAǮAǙAǅAǅA
=AHAAffAQA  AffA(AAŮA(AAŮA33AA=qApAAA\)A  AA  A
=ApA=qAĸRAŮAA
AAffA
AffA{A
AA=qA  A\)AA\)ARAQA  A\)AQAA\AGA
A  A\AHAîAAÙA(A
AA
AQA33AA
AGAAÙA  Aď\AGAŅA=qA
=AǅApApA\)A  A{AQA33AGAAzAffAffA{AƏ\AAƣAƸRAřAAGA
AAGAA(AA
A(A{AQA(A(A  A(A{AAA
AAǙAǙAǙApA33AA
=A
=AA
=AHAƸRAAǙA{AŮAGA
=AAffAzAzAƸRAQAAQAGAģAA=qA\)AƣA\)AƏ\A=qAAģAGAAGA33AAAffAA¸RA(A
=AHAď\AîA=qAQA
=Aď\A
=AA33AřAŅApApAGA\)AApA33AAĸRAA\)ApApA\)A33AA(AĸRA(AŅAGA\)AŅApAřAŮAA
A{AffAHAAGAApAA\)AGA=qAGAǅAHApAŮA\)A=qAffAAď\AAÅAAApAARAAGAGAAAAApA
=AQAffAQAA{A33AîA
=Aď\AŅAA\)AHA{AffAA=qA{AAA{A33A33AAAAQAA=qA(AzA
=AQAAŅApAřAřAAA{A  A  A{A
A  AA  A  A{AǙA33AAA
=AA=qAzA(AɮAAȸRAȣAffApAǙAA33A33A(A{A33AĸRA
A\)A\AzAď\AA=qA{AQAAÅAĸRAA=qAffAHAA  ApAQAHAQAApAA
AȸRAȣA(AAAHA\)AHAAƣAApAřA(AȣA=qA
AHAA(AGA  AHA\)A{AģAĸRAAŮAA{A{A
A
AɮAQA=qAHA
=A\)AƏ\A  AzAHAƣA33AǅApA\)AǙA{A(AA(AȣAHA33AȣAɅA\)A33A
=A
=Aȏ\AȣAǮAǅA
AHAƸRAApA=qA(A  A
A
=AzAȣAHA
=AȸRAzAA33AAɅAɅAɅA\)AGAAȣAHA
=A(A33AɅApAʣAƸRAAQAǙA=qAAHAəAHAȣAƣAHAQAAƣAřAffA(AƸRA33AǅAAȣAȸRAHAAȏ\AȣA=qAA
=A{A=qA  A  AA
A
AAAGApAǮA
A
AA  A(AQAQAȸRAA
AGAAQAffA  AAGAəAA\)AAGAHA
AQA=qAAɅAA
AƣAÙA
=AAÅA\AQAHAA¸RA
=AGAģA33AAHAHA  AģA
AǙAQAǙApAƸRAƏ\AAffAAAəAzA
=AQAAA=qA
=A(A(AǮA(AGA
AǮA=qA{A{A=qAȣA=qA(A(A=qA=qAAɮAGA=qAʏ\A{A33A33AffAəAA
AɅAɅAffA˙A˅ApAAzAʣAAffAɅAA{AQA  AA
=AHAffAʏ\AəAffA
AffAŮAŅApAApAAHAApA\)A33A
A\)AAA{A
=A
=AƏ\AA33A(ApA¸RAffA\ApA33AAAAǙA33AA
A33AA33ApAApAď\AĸRAzAĸRAAAHAA
=AQAffAď\A(AQA  A  A(A(AA  AAģAA33A33A\)A\)AĸRAAAAGApApAAAffAA
=AǮA
A=qAǙAzA=qAQA
A=qApA33A
=AQApA(AƏ\AŮAŮA{AřA  AAA(AAAA\)A  AAffAGA
=AǮAA
A  AAA
=A\)AA33AAQAǙA33AHA\)AGAAzA
=AA
A{AHAGA
AÅA{AzAAQAzA=qA{A{A{A(A(AĸRA33A33AAA
AAřAffA=qAƣA(AHAffApAA˅AʣA
=AAȏ\A  AAGA  AAffAA\)A\)A\)AAA{AǅAA
AəAA(A{AHAȣApAA\)A=qAA=qAQAƸRAAAȣAffAzAʏ\AGA˙ApA33A{AȣA˙ApAAApApA=qAA33A(AffA˙Ȁ\AA  ApAA
A=qAAGAHA\)A{AffAʸRA
=AAA
=AAzAQAQA{A=qAAAHAAʸRAʣApA
ApAAAzAA
A˙AʸRA33AAA33AȣAQAzAʣA=qAɮAffAAAzAQAA\)AA(A  A  AəAAGA  AȣAA  A
AɮA
AəAGAÅA(ApAQAřAƸRA
=AHApAQAAƸRAƸRAǅAƣAAAA
A\A33A=qA
=AHAffA=qApAzApAɮA  A=qAzAʸRAAzAHAȏ\AA
=AAGAA33ApAʸRAGAA=qAAA
=AA
=AȸRAȏ\AffA33A
=AîA\)A
=AŅAģAAffA=qA{A(AzAĸRAřAŮAŅA33A\AGAA(A
A¸RAA=qA  AAîAAA{A
ApAApAAAQA{AApAAA=qAApAAzAzAAQA\AzAA
=AARAAA=qAA{AA=qAGAffAA
=A\ARAA(AHApAGAAA=qA=qA  A=qAQAARARApA
=A33A
=AzAffA\AAffARA{A{A=qA=qA(AQA
=AA  A
AAQAA\A{AA{A{AA\AHAffA
=A
=A=qA33A
=AAA=qAHARA\)AA\)AA33AAA33A(A
A\)AGAA33A\)AA
A
=AQAA
AA=qA
=AGAHAAAAA  AAAAQA
=A{AQA33A  A(A\)A
=AQA(AzApAAA  AQAA  A=qAzAzA=qAzAAAAHAQA(AAA=qA
=AffAQAA¸RA  AA  AA{AQAzA\)ApA\)ApA
AřAŅA
=A  AAAŮAzAA=qAAHAHAAAzA¸RA¸RAAAApApAA\)AHAHAAGAGA=qA
=AǅA33A33A(AffAA33AÙAffA(A  AAGAAA  AAA
=AAffAA33A\)ApApAŅAŅAŅA\)AApA
=AĸRAA33A33A33A\)ApApA33AĸRAffAffAA\)AřAřAAŮA
A=qAffAQAffAffAHAƣAAGApAGAAApA\)ApAŮA\)A
=AARAAAAAffAHAĸRAHAģA{AA  AAQAA  AAAA
=AzAzAAAîAGAĸRA{AAǙAzAzA33A\)AŮAAAA=qA  AA
=AřAŅAŅA  AQAA
A
AȣA
A(Aȏ\A{AȸRAȸRAAHAAQA{A  A  AȣA\)A
=AAŮA
AƸRAƣA
AGApAzAƏ\A
A33AQAȸRAHAGAGAɮAA  A(A(AAA  AAzAA33AAffAA¸RA=qAAHAĸRAA(AHA33AĸRA(AÙAA  AA{ApA
=AîAƣAAƸRAAŅA\)AĸRAzAď\AQAQA(AffAAApA{AzA{A  AAAŮAƸRA(AzAƸRAAHAA33AGAGApApApApA
AA
=AAƣAƸRAƣAƏ\AƏ\AzAƏ\AƣAffAřAď\AGAA\)AŅAƏ\AŮAŮAřAA  AAAQAƏ\AƸRAƸRAƸRAƏ\AffAffAAAffAA33AA(A=qAAAAAAAQAAAzA\)AAHAAAAGApAAA\AzA\AAffAAA(A(A
A  AAGAA33AffAA
=A
AAAAAA\AQAApAAzA\AAAApAA33A{A{A\A(A
=A  AAGA33AAA\)AA
AzAzA=qAffA{AAA(AAAA\A\)A(AAÙAA33A
=AARA
A
=A{A\A{A
=A  AA=qA33AzA\)A\)AGAAA
=AAAAAGA33AAzAA\AAApAzAAA
A{ApAAAAApA\AAA(AAQAA33AHAAA=qAzA(A\A
=A\ARA33AHA
A=qAAffAGA{A{AA
AzAAA\A\)AffAA\)A(AA\)AzAGAď\A  AÅAA33AA\A(AAQA
AAAffA  A
=AQAQAQAAAAGApAAGA
=AQA\A(AA
=A
AApA
A
A
=AÙAGA33A£ApAîAAQAĸRA=qAzA33A
=ApAŮA{AA33AǙA=qAHApA\)AəAəAəApA\)AɅAQAzA{Aȏ\AQAAA
A33A\)AɮA\)A  AA(A
AHAAHA=qAGA{A\)AffAAAǙAAŅAAQAAAzAď\AģAƏ\AǮAffA\)AA=qAAffA\)AAA  A(AAffAffAQA(A  AAAffAA=qAAHA  ApA\)AffAGAď\AGAA{AHA\)A33AŮA\)AzA=qAHApAQAQAffAȏ\AHAGAɅAQAA\)ApApA\)A˙A˅AQA̸RẠAffA
A{ApA˙A˙AA\)A
=A  AǅAʏ\AAzA{AAAHA33AǮAAƏ\AřAHAŮAÙAA{AŮAQAzAffAAA  A33AǙAǮAƣA(AəAGAəAɮA33Aȏ\A33A\)AɮAɮAA
AɅAȸRAQAŅAAÅA\)A\)A(A=qAƣAAA(A  AA
=AHAAHA
AAA\)A{AAA=qAAɮA  AQAQA(A
AAAHAȸRAAAAɅA
=AȣAȏ\AAȸRAzAA(AffApA(A
=AƣAHA{AA=qAA  AzA33AģAHAƏ\ApA{AzA
=AGA\)ApApAGA33AɅA33AGAA33AAAȏ\AǮA
AAzAÙAģAzAƸRAƸRApAǮAAzAffA(AA(AŮAA33A  AGAŮAřA
=AŅAǮAřAffAAHAAŅAffAģA
AɮAA{AQAzA(A(A  AA  A
A{A{A(A{A(A
AGAȣAȏ\AǅAAQAffAȏ\AHA33A
=AzA(AǙAȣAAHAAAAQAffAzAʏ\AA
=AAʏ\AAGAȣAGAAHAɅA\)A=qA  A=qAřApAQAApA  A{AGAQAHAÙAAģAA  AĸRAƏ\Aď\A\)AǙAAHApApAƣAGAAffAzA  AAƸRAffA
A  AzAAÅAÙAQA33A{AQAAffAAAA\)AǅAǅAǙAGA
A
AǮA\)A
=A
=A
=A33A{A\)A(A{AA{AǙAAAzAzAQA(A  A{AHAA  AAAGApApAGAA=qAȣA(A=qA{AǮAAĸRAÙAGA{AHAřAzA{AffAGAÅAffAQAA33AAAřApAŮA{AAAŮA=qA
AŅAGAQAffAAAŮAA(AffApApAffAAffAGA(AzAAAHA33AAA\)AAHAffAQA  AîApA
=A¸RAAAAAÅAģAHA
A(AŮA
A(AffAffAAƏ\A
=A{AƏ\AƏ\AƏ\AQAƣAA
=AAHAAGAǙAAAzAGAřA(A=qAǅA
A\)A  AQAAǮAGA33AřAÅA{A
=AAÙA\)AAƏ\AŮAzAƣA{ApAǮAǙA{A{A=qAQAHA33AQAAǮAA  AQA{A=qA{A{A{AAAA
A
AǮAǙAǙA
A  A{A=qAQA=qAAA
ApAAƸRAffAQAAAƸRA=qAǮAQA
AƏ\AzAŮAA  A(A=qAAǅAǮApAGApApAǅAGAGA  AǙAAAǅA\)A\)ApApAǙA
AA\)A33AƏ\AAffAQA{A  A=qAƏ\AHAHAzAƣA=qAƸRAQAAřA  AƣA
=ApA\)ApA\)AǅA\)A\)AǅAǙAǙAAA  AǅAzAHAÅA\A£AQA\AQA
=AîA{AQAffAHAĸRA  A
=AAA\)AAAřAřA=qAAĸRA(A
=A\)AAAAzAAĸRAď\AģAĸRA=qAîAĸRA
AAģAŅAAQA
=AGAffAď\AffApAApAA\)AGA33A\)ApA\)AAGAAģAģAģAzAzAAA\)A{AAQAîAHAGA\)AApAAAAHA33AĸRAHAAď\AHA=qAģA(A\)AAGA{AzAAA{A
=AGAÅAîAîAÙAÙAîAÅAÅAîAîAÙAApAAA  AQAÙAÅA¸RA33AA33A33AŮAGAřApA{A=qA
=A
=AǮAAǙA
=A
=AƣA{A
A=qA=qA=qAƣA=qAGA
AA33AGAAAA33AĸRAď\AzA=qA\)AGA
=AHA=qAÙAĸRAAAffA  ApA=qAGAîA
AzAA
=AffAAAŅAřAŅA
AřA=qAŮA  A  AƸRAQA(A{A=qAƸRAHA33AǙA
A  AA  A  AAAA{A
AHAȏ\AAzAffAffAHAQA  A
A  A{A{A
A  A
A
A(AQAAffAHA(A{AǙAAHAHAƣA(AřAAAA  AAď\AQAAAzAzAQAAAAzA£A{A=qAA
AQAzAApAHAAffApA33ApAHAzAĸRAÙAÙAÅA\)AAîA{AQAAřA(AƣAGA  AzAȣAHAȣAȣAAGAəAA(AQAʣA
=AHAffA  AA(A33Aȏ\AzA  A  AHA{A
A
A(A
AAHAGA(ApAAQAffAffAffA  AA
A\)A\)AǅA
AAǅA
=AAQAffAzAzAAŮAA(AQAQA
AƏ\AřAŅAAGAŅA\)AQAHAĸRAģA£AAAAAQA
=AŅAAzA{AzAApA(A{A
=AǮAAffA
=AGA\)AA
A=qAʣAHA
=AGAʏ\AHAzA  AʣAGA\)AGA33A
=AAAʣAʏ\AffAGAGAQAȏ\A{A  AA{A
=AʣAʏ\AʸRAʣAʸRAzAzA=qA{A
AəAHAAȸRAzA33AzAAQAƏ\A=qAQA=qA{A  A{A
AřAřAřAŮAŮAřA
=AA{AAQAď\AQAA  A(AA=qA=qA  A=qA
=AřA33AHApAřAAHA\AHAA\A
=AîA(A{AƣAƸRA33A(AA  ApAHAffA{AffAAA
=A33AA33AȸRAzAȣAȸRAffA\)A
=AQAffA(A  AǅAǙAApAǙApAGAGAGA33AA33AA
=A
=A
=A
=AAAƸRAAAƏ\A=qAA{AŅA(AřAŮA
AŅA
=AA
=AģAHAAĸRA  AĸRAģA
AîAA
=AA
=A33A
=AzA=qAA
A33AGA33A
=A
=AHApA33AA
=AAģA\)AŅAQAAAȏ\AHAAAA
AQAQA{A{AQAQAQA(A  A  A
A=qAAəAɅAȏ\AƸRA
AzA33AQAQAA  AQAəAAAAApAǮAAǮAQA{A
ApAGAď\AAřAAA(A=qAAģAď\AřAƸRAA=qAffAGA=qAîAA=qA{A£AAAÙAGAA¸RA£A£A33AzA\)AÅApA\)AÅApAA33AQAQAHA(AffAAzAď\AzAď\AģAģA
=AGA33A\)A
=A{AffAAƸRAǅAǙAǙAǙAǙAApAAGA
=AGApAAAAAƏ\AAģAŅAŅApA  A  AAŅA{AřAŮA33AffAGAA  A
=A
=AA£AzAzA\AzA{A\)AîAAHAAzA\)AAA¸RA
=A\A
=AGAÅAÙAzA
=A33A=qA£AAffAAA33AAÙAAffA\)ApA=qAQA\A\)AÙA
A=qAAzAA  A(AQAAAA{AA\)A
A33A33A(A
AAA£A  AzARA33A=qA  AA
A=qAA
=A  A
A
AAA(A33A33AAA(AAÙAÅAGAHAA
=A=qAAffAQA{AAA\A\ApA{AA\A£AA
=AAAAGAA
=A33AHAzApAQAzA(A
AA\AHAAA
=AA
A33AAÅA\)AGA£A£AAAģApAQAHApAAȏ\AHAAGAAHAAȏ\Aȏ\AffA=qA{A  A  AAAƣA33A=qAApAGA\)AƏ\AƏ\AƸRAAǅAƏ\A(A{A(AffAAǙAǅAǙAƏ\A  AǙAǮAHAAƏ\AzAQAƏ\AAAƸRAƸRAAAHA(AŮA=qA  A=qAƣAAzAQAƏ\AHAAAřAAģAď\AA
=Aď\A
=AA  AzA\)AzAAÅAAA
=AîApAîA
A(AHAģAAGAAŮA(AHAApA\)AǅAA
AzAQAffAzAQA{A(A  A  AAQAAGAA
=AQAƏ\A(AA{A
=A33AƸRA{A{A
ApA\)AřAŮA
A{AƏ\A33A33A\)AAƏ\AǙAƏ\A\)ApAƣAƣAQA(A{A
AAAŮAŮApAAffA{A  A=qA
=A  AzA
=A33A33A  A33A  AQA
=AA(AffAA33A\)AģA
AģAģA=qAzAřAAHAAǙAǮAHA{A(AzAQAȸRAȣAzAAȣAƏ\AģAģAHAAffAŮAƸRA
=AHAAĸRAģAģAřA\)AQA  Aď\ApA\)ApApAŅAřA33Aď\A
=AĸRAĸRAzAģAA(AA
AA  AA
=AģA£A£AAAGAA
=AAA  AAA=qA£AAA33ApAffA(AffA33A{A\)A{AA=qAAA33AA\AQA\)AzA=qA33AAGARAAzAA  A(ApAA  AffA
=AQAAAQA33AHAA(AzAHAAAGA33AHA\AApAHARA
=A\)A\)AAA{A  A  A
AA(A  A=qA=qA33AAA  AAApA{AffAA¸RA33AA\)AApAHAAzA\)A=qARAAGAQA(AA=qAzAHAAA33A
=AAffA(A  AQA{AAApA¸RA=qAÅAîA33AGA33A
=A  A=qAřAHA\)A
=A\)A
AAzA
A  AʣAA
=A33AGA33A\)AA
A  A{A˙AA
AGAAȏ\A=qA=qAQAQAzAzAffAzAǅAA\)AǅAHAA  AHAǅA
=A33A
A33AHAƸRAffAƸRAQA(AQAzA(AA
AŅApA
=AAGAHA=qA¸RAģAQA
=AŮAģApAAffA(AffApAzA33A  AzA{AĸRAŅAAQA
A{AApAAĸRA\)A
=A33A
=AŮAǙApAǙAGA\)AǙAQAffA  A  A  A=qA{AA=qA{AǙA{A
A
=A33Aȏ\AA33AGAȣAȸRA=qAQAQAȏ\AQAzAǮAAǙAƣA
A
A33AŮAGA\)AGA(AƣAƣAAAƏ\AAAƣAzAQAQAffAƏ\AQAƣAAď\A
A
AQAffA£A  AÅAAA\)A  A
AA
AGAA=qAGAA33AAQAzAAAŮAA{AAzAA\)A{AffAîAQAAGA(A  ApAHAÅAA  A{A{A{A(A=qA=qAƣAffA(AƸRAƸRA{A=qA
=A\)A
=A33A{A{A
AA
=A=qAHAA\)A\)AŅA\)AAQAŮAGAA{A  A33A\)A\)A
=A\)A\)AGAHAAGAAA  A
=AA=qA=qAřA
=AQA
ApAA£A£A£AAQA\)AHAA=qAǙAŮAzAŮAAǅAǮAŮAƏ\AAAAAGAA  AA(A  AffAzAAA
=AA
=ApA33A=qAAQAAApA=qAA=qAȏ\A  A(AzAȏ\A{A  AǅAǮA  A{A(AffAȸRAA33AA
=AffAzA  ApA33A{AQA
Aȏ\A=qApAAAǅAGAǅA=qA(A  AAGA\)AA\)A=qAffAA\)AAAA(AAAAA\)A33AAA  A
=AƏ\A33AAģAAffAĸRAQA33AA  AHApA=qA
=AA\)A  A=qAȸRAAəA=qA33AAAʣAffAffAffAffA=qAA
AAȸRA\)AGAzAʸRAzAHA\)AA\)AHA˙AGA
=A\)A33A\)A˅AˮApApA
=A
=AA{A(ApAÙAA\)A\)A\)A\)AHA33ApA\)AîA  AîAA
AAAQApA
AA
A
AA\)AA  A
=AA\)AAHA\)AQAA  ApAA=qApAA£AGA{AAHAGA=qA{AzA£AHAAHAA¸RARAA
=ApA
=A\)A=qAA\)AGAAA
AQAzAzA£AAA
=A33AA\)AGA\)AGAAAAAA
AAAHAGAA\)AAGApAffAA=qA
=A  AQAAAA
A33ARAGAGAQARA
=ApAHAA33AA  AffA33A
=A\)AQAApA{AA\AAffAA\)A\AAHAGAA  A=qAzAHAÙAAƣAffA=qA
AŅAHAAģAŅAHAď\A=qAAA{A{ApA
AGA¸RA\)A  ApA33AGAA¸RAAAHAA(ApAzA(A  AA(A\)A
=AffA(A33AAffAA=qAA
ApAA(A=qAQAffA\A
=AGAHA33AzAGA
A=qAffAģAAĸRAď\A  A
A{AffApAffAAHAĸRAQAAƏ\AƸRAGAǮAQAffAQAQAȣAȣAȸRAəAɮAAŮAQAHAA33AQA=qAɅA  AAA33A\)AɅAAɮA
A
AɅAAHAAAȣAȏ\AȣAzAzAffAAHA
=AGAəA
A  AQA  A
A
AɮAəApAGAGAGA\)AGAAAzAGA  A{A(AA\)AGA{A  AɅAAzAȏ\AŅAAAƸRA
=AřAǅAƣAA
=ARAAÅAzAƏ\AƣAĸRA(AAA(AGA=qAƣA
=A{AAɅA  AQAʏ\AA˅A
=AA\)AHA{AɅAAǅAǮAAGAǙA
AǮA{Aȏ\AAHA  AəA
=AGAəAAAAAA  A=qA=qA(A{A=qA(A  A  Aȏ\A
AAHA(AAɮAȏ\AɅAəAA
=AřAAAQAzA\)ApAA
A(AAA  AAzAģAQA=qAGAA\)A
=AîAŮAGAGAAĸRA(A(A¸RAÅA  A
=AģA
AffA\)AzAAA
AHA
AƸRAAǅA\)AAAA(AA=qAAffAzAȏ\A=qAȏ\AǮA33AŮA=qAŅA  AA=qA  AffAƏ\AŮAGA
=AĸRAzAGAÙAAÙA(Aď\Aď\A
A
AzApAHAQAď\AŅAřA
AŅA33AA33AřAřAA\)AffAÅAĸRAģA
A\)AGAHAAA{AÙAď\AĸRA{AffAřApAQA33AffA\)AA\)A  A
=ApA
=A\)AřA(AA=qA{AffApAÅAzAAGA\)AA\)AÙA{AHAŅAHA(AȸRAAȸRAƸRA
=AƣAHAA
AĸRApAď\AAĸRA{AQAAAAHAA\)A\)A=qAApAAAA
AAA\)ApA33AHA
=ARAA{A=qAA\A\A\)AHAARA
=ApAARA\)AHA=qApAzAffA{AGApAARA(AAAGAARAAGA(AA33A
AAQA33A(A\)A=qAQAA{AAA=qAA33A=qAQAAAHA(AHARA  AzA\)AHA(AQAGA33AffA(AA33A
=A\)ApAÅAzAGAAîAAGAAGA
=A  ApAA\ApAzAAA\)AQA\ApA\)A  AGA33AffAQA  A\AGA(AHAA{AffA  A
=A\A  A\)AAAARAAA
=A(AA\AA\)A
A\AAA\)AA  A
A
=AHA\)ApAGAQA\)AA\)AAA(A\AAQAApA=qAAAGAƣA  AAŅApAŅA{AƏ\AzAzAffAffA(A  A  AAA33AAffA=qAřAQAffA{A(A
A(AřA
A  A  A=qA{A\)AÙAAAA33A
=AAAzA=qA\AAApAAA
AAAAAHAQA
AA
ApA
=AAGA=qAA(AffA(AAGAAAffA  AAA
A=qApAzAîAQAAŮA
A(A=qA33A33AGA33A
AzAȸRAHA33A
AA
A  A
A  AHA
=AAGAȣAǮAƣApAAAzAA{AǮAzA33A33AAÅAHA{AA{AƸRA\)AAAGAffA
AŅA(AƏ\AƸRAA{A(AģAzAffAA
=AAQA\)A\)AHA
=AQA33A33A\)AzA  A
A  A{AAď\AHAģA  AHAAAHAffA
=A33A{AQAzAA=qAzAǙAəA\)AA(AzA(A=qAAGA(A̸RAHAͅAͮApAͅApA{AΏ\AffA{A(AΣAA33A
=AHAθRAzA{A
AͮAͅAͅA\)AAGẠA
=AGAAAA  AQAAQAˮAAA{A
AGAǮA
=AQAAAAǅA{AAÙAzA=qAAHA(AffA{AzAŅA
=A  AƸRAA(AA\)AHAƏ\A
A{A(A=qAǙA=qA\)AȸRAȸRAzA=qAA33A  AGAA˅AAQAzAHAͮAQAAAA
=A
=A33AυApAGAυAϙAυAAAЏ\AHAzAzAϙA33AʸRAAffAffAQAAʣA{Ȁ\A˅AA͙A  A=qAffA
=AA  A(A
=AA
ApAHAAAAA
=A˙AˮA\)A33A  AͮAAGApAɮAQAǙAA(A\)AGAAHApAAffAA{A
=A
AApAGAA\)AȣAAA=qAA=qApA  AA{ẠA
=AA=qAAzAΣAθRA(A{A
AͮAGẠAA(A̸RȀ\AQAAAGA=qAA\)ApAˮA˙AA˅A˅AGA33A
=AAʏ\AʣAQAA{AA
=A{A{A{A  A
A{A33AAƣA{A
=AffA\)AGAAAffAA(ApAGAAAA{A(A¸RA(AƏ\AzAA  A\)A
=AA
AAA(AA(A=qAAffA{ApAAA\)AQAGAîA  AQAAŮA(AƏ\AffA{A
AAA33AA
AHAApA(A=qAAA\AQApAA{AzAffAAAQA  A\AHAQA  AAHAzAGA33ApAARAA
=ARA{AA\)AA(A\AA33AA{AA\)A33AAGApAAffAA\A=qAAApA\AARAAffAAQAzA\AzA  AHA33AA
=AA  AARAApAA
A(ARAAGA=qAffA\A
=AAAAzAAGA\)ApAA\)AAAAAHA(AAAA\A
AAAA\)A\)AzA
=AA{A\A33A
=AAHAQAAHAA
AQAAAA\)AA(A33AAAA(A=qApA£AAHA=qApAHAA\A\A  A33AHAAHAAAARAAA{A\AzAA  AAAAAAAAHAAApAHAA=qA¸RAAÅAAA{AA
A
AA=qAQA(AQAQA(A(AA\)A33A¸RAA\)AA(A=qA33A  AAAAzAARAA\)AA(ARAA33A
=ApA33AAAAGAA{AAAAAAAAQAHA\)A\)A33A33AAQA(AA\)AA=qApA\AffARA=qA\AQA\)AAAA  A\)AffAA£A33AAA{A£A33AAApAAHAHAHA=qA{AA=qA=qA(A  AAAAAAAAAAA33AA
AAzAffAÙAîAÅA
=AAffAzAzAQA\A=qAA¸RA£A
=AHA
AHA  AAAHAffA  AzA(AAA\)ApARAHAzAGA33AAAzA  AzAAHA=qA(AGAAHAAzARA
=A33A
AA33AAffA(AAAzA
=AA
A  A\AA\)AîA  A{A(A  A{A=qAĸRA
=A  AQAƸRAGAǙA  A{AAA33AHAƸRAAHAApAŮA
AzAA
=AGAGA\)AAAHAAĸRA=qAƏ\AŮA(AÅAzAA£A¸RA\)A¸RA  A33ApAA=qAA
=A
=AApA=qAGApA(AffA{AzAÙAģAQAAƣAQAîAAAHAAA=qA33AAffAHAAApAGA
=A\)A
=ApAAffA(ARAQAzAGAQA{AAGAģAQAAÅAQAģAAAGA33AAGAA33AAAƸRA\)AǮAA
A\)A(A\)AA\AÙA(A¸RA
=AAAzAģAď\A(A{AzAģA(A=qA
=AffAGAzAƏ\A33AffApA\)A  AƸRA\)AƏ\A
=AzA£ApA33AzAQA=qAGA{AQAAA(A33A=qAAA
AHA\A\AA{AA33AA33A(AHAAQAGAA£AA33AHAA
=AGAGAAřAŅAŅAřApAřA
A
AŮAŮA
A=qA
A  A
A  AAA\)AŅAŮAřApAAŅA{A
=AřAA{AAHAHAîApA
=A(AģAHA  A£AGAA=qA
=A=qAA£A=qA33AŅAAA\)AA
AAHA33AQAA\AA
=AA=qA\)AzAď\AHAAffA  A33AŮAQAƣA
AǅAǮA{AȸRAAď\Aď\AQAHAAAGAĸRA33ApAŅA
A{AA
=ApAAzA(A
=A(A(AzA
=AffAHA{AQA
A  AŅA33AzA\)A{A(A
A33AÙAApAQAHAǮA  AǮAGAAzA¸RAA{A33AAA(AGAA{A33ARAAffA
A
=AA  AGAAHAAA
=A\A
A
A  A=qA33AApA33A33AGAA\A33A\)AzA(A{A
=ApA\A\AAA33AAAAAAAHAQAHA
=AffA
=AA
=AGA=qAApA
=AAffAzAQA\AAA=qA\A\AzA
=A(A=qA33AA\AAQAGAAApA=qA33AGAAGA{A=qAGA33A\)AA\A  A\A\AA  AAffAA\)A(A  AzAGAARA\)AA33A(AzAGA(AAA\ARA  AAHAQAHAAA  AAAffA(AAHAAffAQAAARAA\AffA\AAGAQA\)AA\)AGAŅA=qA
=AǮAǅAAGA\)ApAApA(A  AHAGAģAzAƣAA\)A=qAzAffAApAAGAffA  AAǙA
=AŅAffA\)A\)AHA33AAGAA33ARAHAzA{A
AA=qA=qA33AzAA{ARAQAAzAAAAA
A
=A£AA=qA  AffAHAÙAÙAHA=qAAzAffAA{A{A  A(AQAģAď\AAA\)A  AAffAAƸRAHAAAA
=AǮAAǙApA
=AǮA=qA=qA\)AGA\)A\)A33AǙAŅAƏ\AAƣAAAQAȣAA
=AǮAQA(AǅAffAffAƸRAƣAÙApA\)AGAȏ\AQAzA33AQA=qApAƏ\A=qA{AƸRA=qA\)AGAA£AQARA  A=qARAApA\A{AAA(A(ApAffA  AA\A(AHA33AřA  A33A=qAA  AĸRAAGA  A\)AAA\)A˅AA
=AAffAAGA{AffAzAffAHAΏ\AAˮAAͅA
Ȁ\A(ApAA{AͮȀ\A=qȀ\A{AɅAQA˙AGA33AʣAffA
AəA33AȸRAAǮAAQA(A=qA
ApA33AAAzA(AzA  AŮAģAƣAAGAǮAƣAAAA(AQA  ApApA33AîA33AffApA{A
AHA{AA(A=qAď\AGAAQAAÅAAA{AģA\)AAřAřAQAffAGAȏ\A\)AQA˙A\)A33Aȏ\AAA33AǮAAƸRAzAƏ\AffAzA  Aȏ\AHAď\AffA(AQAGAÙA  Aď\AffAAģAAAQAQA=qA{A
=AQAA33Aď\AģA\AGAA(ApA
AffAffAAAAAAAQARA\)AAAffAA
AA\A(ApA=qAffAA
A{AzAQAffAHAAAAAA{A
AffApAAAA
ARAAA\AA
=A\)AA{A\A33A\AA
A33AA{AAA{AQA{AAA=qAAA
=ApAA{A33AAA=qA  AAAAA\AA{A{AAGAHAffA  AA\)AA
=AffAAzAApAGAAAA\)AA{A=qAffA
AAAzAA\AAffApA\ARAA
=A(AAAA¸RAAď\AA33A  AGAAzAƏ\A=qAřA33AA=qAAA  A  ApAA  AAffAzAzAA
=A33AAHAAGAGAA
=A
=ApAGA{AzA{AÙA
=AAAzAffAA\)A\)AÙAGAAď\A(A{A
A(AARAQA=qA£AQAAA=qA{ApAzAAA(AQA
AHA\)AHAA=qAA=qA{AAA\AffAQARA(A(AA33A\AAffAA=qA
=AA\)A
=AA{A
A\AA
=AA\)AA33A¸RAA¸RAAAQA(A=qA=qA
AAA  A33A(AA\AffApAAHAAA33A33ARAzA\A
AGA\ARAA\A33A33AzARA\)ApAARAAA(AA33AAA{AAA
A(AQA
AAAA\)A\)AA
AAzA(ARAAzAffAAffAAAQA=qAGA\)AHA33AHA=qAAA  AA
A(A=qA\)A=qA  AA  AAARA  A\)AAAAffA
=AAA
=AzAAA\A\)AQAQApA{A
=AHA(A=qAA(ApAAAzAA\)AHAA  AHAzAQAQARAAA
=A\)A{A=qAAQAffApAAzAHA33AA\AA=qA(ARAHAzAA  A
=A  A
=A=qA
=A
AHA=qA{AQAA33ApAHA(A
=A
=AffAA33AA=qAffA
A\AA(A  A  A
AQA=qAA
A(A{AAAAAAA\AHAîAA=qA(AAGAAHAAAGA{A=qAA
AAHA  AAGAAARA
=A  A(AffAHAA\)AA33AAA33A  AHAAAAARApA{AARAffAQA{AApARAffA  ApA(A  A
ARARAA\AAAA33A
=AffApAffAAGA(A
AHA(AA\AA  AGAAffAzARAGAffAA\AA(A\AffAzA\)ApApA
AffAAQApA=qA(A\AHA
=AA
A  A=qAAAA(AA\)AA=qA  AAAAApA
A{ARA\AA
=AARAAA=qA  AGAzAAA  A  ApAQAAA
AHA
AAA  AzA{AA(AHAAA
=AQARAA
AHA33AQAAA
=ApA33ARAQAAARA
A(A  AAARAAHA{A\A33AGA  AAA33A=qAA
ARAAQA
ARA
A
ApAGA
=A\)AHApAA{AQAzA
=A(AA\)AAAQAA  A  AAHApA(A
=A  A  A33AA  A=qA33A\)A  ARAAHA\AGAA=qApAA\)ARAAAAGA
AHA(A=qAA33AQAffAAA  AAA(AApA=qAA(AzAA=qA\)A{A=qA\)AA=qA=qA{AA\AAffAQAA  A(ARAffAA=qAAAA
=AffAAzAģAAApA
=A\)AĸRApA
AÙAAAA
=AffAA
AGA{AA
=AARA{A  A(AAHA33AHA\)AAAGAGAA  AHAffAAHA  AHAAGAffAAÙAzAAAQA33A£AAHA¸RAAAAA{AA\AHAARAHAA¸RAGA\)A
A\)A{AzA33A\)A
=AffA=qA=qAA¸RAA
A  AAîAzAAAffAAAARA{AHA
=AAA
=AGAA
AQAA\AAAHA=qAffAAAAAARAGA
A{AAA33A\AA(AAzA=qA
AHA
=AAffA33A\)AAAAAzAAAHAA(A{A33AAzA(AAAHAA=qAGA{A{A\AHA
=A33ApAAA\AA\)ApA33A33AAA=qA\A\A(A{AA{A
ApA
=AHA=qA
=AAQAA\)AAAAAA33A\)A33A{ARAAHA=qA{AQAA
A
A(AHAAA33AzAA\)AAffAAGA\A33A
=A33A  AGA
=A  AHA
=AAA
=AA
=AAGAA
A
=AA33A
=A
AQAffAGAAAzAffAAA
=A(A
=AAA
AffA\A(AA(AQARA33AA=qAAGAAA
=A\A{AA\AARA=qA33A=qAAAAffAzA=qAA33AARAGARAA  A  A{A\A  A33A33AffAA  AAAHA\)A  AAAAGAAAGA  AAAHA
=AAHAA
=AA\)A\A\)AHAHAA  ApA=qAA{A=qAAHAA
A
ARA\)AffA{AHA\AAAHAzA\)AffAAAAA  AQAzAAffA(A(A\AffA\A(AA{A
=A(AAA33AAA{AHA
=AHAGAA\AAAA
=AAARA33A{A\AAAApAAAAGAA=qA{AA{A{A{AA{AAAGAAGARAAA(AAGA=qAAHARA(AAzA
=AHAAffAAA{A
=AHAAzAzAAA
=AAffAAzARAA(AffA{AAGAAApAAffAîAzAzAŅAA
=AAQAGA
AHA\)AQAAAGA(A\)AAAAA=qAAA  A=qAAA{AffA
=AAAQAGAzA  A{AQAApAA
AffARA\AGAAA=qAAHAA=qApAA{AA
=AHAQA33AAA(AA33AA(A
AA=qAAQAApAAA\A
=A33A
A(A\AzAA£Aď\AģAffA
ApAAGAGAGA33AAHAHAzAApAApA
=AHA\AAAAHAGAAA
=AHA33AzA
=A{A  AAffARAzA  A\)AAAApAA{AA(ApAQAzAAAA
=AHA\)AffAARARA\A\AA=qAAGARAffA
AA  A
=A
=ARApApAHAA\AAffAApA{A\A33AîAAzAA
=AAřA=qAzAA
=AAGApA33AAƣA(A(AAŅA\)ApAGAA=qA(AîAď\AGAA  A=qAAzAAGAÅA=qAģA=qAAŅA\)AAǅAHAAGA\ARAAAAA(AAAHAA
=AA\)AGA
=AA{AA33A=qAGA  AAzAAQA\)A\AA
AA\)AAHAAAAAAAQA\AHAARAAAARAAA\)ApA
A  AA
=AHAHAARAA=qAAA33AHAA(AAffAHAA=qA  ApAGA33A  A33AAA{A{A{AA\AAAAAzAA  A33AGA33AA
=A\)A{AAHAAA\A\AzAAA=qAA=qA\AAHA  A\)A  ApA33AAA33A33AzA(AApA{AA\)AAA  AHApA
AHA33A  AffA
=AGAÅAA=qAĸRA
=ApA
A{A=qAffAffA
AAA
=AGAGAHAîA33AA
AA33A\)AHA{AAAA
=AffA  AAzA=qA  ARAA\ApA(AA(AAA
A{AAHAzAGAA33A=qA  AA{AAA33A
=AAAGA(AA\AHARAAAA{AffAA=qA(A
=AAAAA33AA\)AHA33A  ARApAGAAA  A(A
=AÙApA¸RA{A\)AÙA(A=qAzAģAzA
=AAAŮA33AAQAA
=A
A33A=qA(A
A\A£A(A
=AARAA  A
A£AÙA£AffA{A\)A
=A
AAģA{AAÅAARAAAAAffAAQA(A
=AGA{A{AA(AAÙA{AA=qAĸRA33ApA{A(AÅAApA  AA{A(ApAzA\)Aď\AA(AǮAA
AGA=qAQA=qAʣAHAHA(AAA\)AA͙AA(A  A{A  A{AθRAffA
A  A(AAzAQA  AQAQAʸRAApAǅA  AffA
A
=A  AQAA(AQA{A\)A(AzAA  AɅAɅAA=qAȣAffAǮA
=AzA  AQAzAĸRA=qA\)ApAģAÅA  AA33AffApAApAÙA£A{A
=AAîA=qA=qAQAHA
=A(AAzAAAAA{A=qAHAÅAĸRAģAAffAAApAA=qA=qAHAǅA33AǙAǮAAAA  A(ApA{AQA
AffAřA
AAHApA\)AA33AǅAA
=AAA
=AA=qAAffA
=AffAȣAHA
=A
=AzAApA=qAQAA(AAQA{AAQAȸRA
=AȣA\)AǮA{AŅA\)AAîAAAHAffA33A33A
=AAzA(AA
AQAîAģAHA
=AŮA=qA
=ApAA{A(A(AHAffA  AAzAʸRA  A{A(AQAGAAƏ\A\)AǅA\)A(AȸRAA(AGA{AGAGAA˅A
=A
=AA{AQAGApApAA{A
ApApA£A(A\)AA
AAGA\)AA(AQAHAA33AA\)A¸RA£AAA\)AQAHAGAA
=AAŮAAA(AffA£AApA\A  AƏ\A¸RAQAA=qARARA  AA(AAÅApAƸRAQA(A
=AʣA
ApAǅAȣAGAGA\)A
=A
A33A
=A{AQA  A˙A˙A˙A˅A
=A
A
=AA{AHAQAQAzA{AAA\)A{A=qAQAʣA(A=qA{A{A  A=qApAzAffA{A{A{AƏ\A{A=qA{A{AƣAAGAAHApAQAģA  AGAA£A
=AA\)AÅAAA(A=qARA33AAÅAAA\)A33AAAA  A(A
=AApAzAÅA(AAAŅA\ApA\A
A
=AAĸRAřApAQA
A=qA
=AAȣAǮAGA
AQA33AHAĸRAAģA33A
=AĸRAA\)AffA
AǮAȸRA33A{A  AAƏ\ApA(A33AAÙAď\AGAGApA33A(A£A
AÙA{A
=AAHA  ARAA
=A\)A\)AffAAffAA\)AARApA{A\)AA  AÙAQAHAÙA(AÙAffA
AAA\)AGAQAAzA=qARAQAAQAîAîAApAîAQA33AŅAAAŅApApAď\AApAAǙA
AHAȸRAAzAGA
=AQA  AGAQA\)A(AGAAÙA33AîA=qA(A\)A=qAAQAffAAGAAzA  A  A  A
AǅAǙAHAǮAGAA
=AHAǅApAƸRAQA33ApAģA
=AGAA(A
AÅA\)AA  AîA
AAAHAHAzA{AAA
A\)A
=AÅAAƣAffA(AƸRAffA¸RAA=qA\)AA=qAAA33A\)A33AA(Aȏ\AAɅA{AA˅A
=AGAͮAffAAApAϙAffAHA=qAA  A{AʣApAGAƣAǮApA{AffAAɅAHA˅A(A=qAQAAAAzA=qA(A
=AʸRA
=A\)ApA˙AHAʸRAəA{AHAƣAzAŮAA\)ApAHA  Aʏ\AAȏ\A{AffA(Aȏ\AzA{AHA\)AzAɮA33AƸRAAŮAřA=qAŮA33AA=qAA
AǮA  AffA\)A=qAAQA
=AQA33A{A̸RAGA{A=qA  AΏ\AΏ\AΣAθRAHAHA
=AHAApA  AAAAffAͅAzA{AffAͅA
A\)AAͅA
AAGAGAȀ\AffA  A
A˅A(AQA
=AAGAAzA
A
=AəAQAAQAffAQAffA
=A{AAA(A33AffA=qA=qAʏ\AŅA{AffA
=A
A
AƸRAəAəAɅA=qA
A=qAzA{AffA{A̸RAffAffẠAˮAGAΏ\AQAʸRAApAAA
=AAGAͮA
=A
=AHAͮAHAͮAzA(AHA{AͅA(AΣAΏ\AAυAAAϮAA{AzAGA{AAͮA33A
=AAʏ\A  AffAA
A=qA˅AˮAGA(AˮAGAzA33A=qApA{A=qA33AHAɅAAɅAAȏ\AĸRAÙAzAQAÅA  AA{A
=AAARA=qAAď\AģA=qA¸RA\)A{A{ARA33A  A{AAAffA£A¸RAzAHA33AîAQAĸRAA
A
=AĸRA
=A(AffA33A\)AGAGAA\)Aď\AÙA\)AŮA
A
A  A  AAƸRAA  A=qAŮAGA\)A
AƣA
AŮAŮAQAzA{AAƸRA(AAffAHAAA=qA
=A
=A  A33A
AQA\)AGA(A\A
A\)A\AAA
A
=AApA
=A
AHAQAApAA\ARAA  ApAAAHA{AAAAAGAAzAAGAAAď\AQAřAA  AǮAQAA{AA(AAzAȣAȸRAȣAzAQA{A(AƏ\AHAAA=qA  AzAŅAffA=qA  AQA
A(A
AQA
ApAHAA33AzA  AAAQAȸRAGAǅAGA
AQAzAǙAȏ\A\)AəAɅAffAȣA(A{A=qA  AģAHA{AAzAQA£A
AGA  AAAAHAA
=AQApA(AHAGARA(AAƏ\AAÙA  AģAƣAA
AͅAAzAˮApAAAHA33ARA33AAGAAGA˅A33AA\)AƏ\AAAffAAQA
AAA
=AAQA
AAAQAGA=qAAAAAApA33AzAď\A\)AA{AƸRA{A
=A=qA(A\)A33AHA£AAffAHAÅAAĸRAffA\)AffAzAŮA  ApAGAA\)ApA
=AGA£A(AGA  AA
=AAGA\)A  A\A
AffAffA
=A33A33AGA\)A
A
AA
=AQA£AŮAÅA
=AQAQAAAA=qA
A
AA{A  A=qA\)ARA\)AAzAÅA{AA{A\)AA=qAA=qAA\)A\)AzApA33AAA\)A=qAAffAA
AAffA\)ApA  A=qA
=A33AffAffA33A
=AA  A(A(AQAAHAzAzAzA=qA
AÙApA\)ApA¸RA¸RAffA(AAzA  A\)AGARA(ApAA  AA  AAAAAzAHAA33AAA
=AGAAAARA
=AHA(A\)AAzAzAA33AA\)AAA
AA
=ARAA33AAA\)AffAHAARAAffA  A33AGAApA
=AAGA\A(A
=ApAA=qApA  AAGAA(AGAzAARA
A{AAA=qA
=A
=AffA=qA
AApAARAAGAAAffAzAAAAA(AzAAffAARAQARAffA(A(AAAAA
=AA\)ApAQAAA
=A33AA
=AGAAA
A33AA\AA
=AA\)A
A\)A(AHAAA{A=qAffAzA{AA  AA
=ApA{AApA\)AŮA  A
=AAAzAȣA
=AAzAɮA{AAGA(A
AARAHAAHARAAzA
=A{AffA\)AAffAHAAəAȣAȣAAGA{AHA
A
=AǮA(AffAȏ\AGAǅAGA=qA\AAzAA
AAAzAHAɮA{ApAǅA=qA˅A͙AzA͙AAǮAA
A=qApA
AģAffA=qAʸRApA\)AzA\)AřA{A{AȸRA{AGA(A
=AĸRAȣAȣAAȸRA  ApA33AffAzA33A\)A  A33A{AApAʏ\A=qA(A˅AffAAΣApAzA
AΣAθRAHAθRAΣA(AQA  A
AͅA
=AAA33A33AQAzAffA  A˅AˮA  AAAAAHAAAʸRAAAffAɅA33AQA{AA\)AQAŅA33AGAAƏ\A{AȸRAA\)Aď\AGAHA  A\ApAAAAAHA(AA(A{AĸRAƸRApAGAʏ\A(A
ApAHA
=AͮApAAẠA̸RA̸RAẠA̸RAffA{AʸRAHA  AA33A(A˙AQA=qAA
AGA  AQA
=A
AAA  A
ApApAˮAA\)A\)AGA\)A33AGApA33AAA=qAzAzAzAʏ\AʸRAAQAɮA  A33A33AAʣAQAzA\)Aȏ\AƣA33AGA33ApAAQA=qA33A
AɅAAA  AAGAAA=qAǙAȣAɅAffAʸRAGAẠAAΏ\AHAθRA
=AθRAzA(A=qA=qA\)A\)AͅAͅA͙AͅA
AAHAQA(AA˅A  AffȀ\A
ẠAAzAzAθRAͅA{AA{AQAApA33AzA  AzAA  A  A  AGAGApAAA33AHAʏ\AʸRAʏ\AQAʏ\A{AAɮAəAɮA33AAɮA{A  A
=A
A=qA
=AAHAAGAAQAApAAffAǮAǅAGA
AAGA
=AHA͙A=qA{A=qA
=A
=A(AУA  A\)A
ApA{ẠAͅA(AΣAGAHAAAУAAϮA33ApAGA\)AΏ\AϮA33AffAffA\)A=qApA͙AA͙AͅAAAzAQA{A
ApA͙A  A͙ApA
=ẠAAHȀ\ẠAzȀ\AAˮA{A
A{AAˮAA33AʸRAɅAA(A\)A=qA(AzA{AGAA33AQA33ApAAQA
AA\)AQAAGApAA  Aȏ\AQAzAGAɮAffAA
AffAHAA33A\)A͙A͙AGAAυAΣAA33A33A
=A
=A\)AGAϮAљAAӅAffAңAѮAGAиRAffAAAυAQAGAGAA33AAʏ\AəAA{A=qAQA  AʣAʣAzAzAʣA
A33A=qA{A  A
AA(AAffAŮAƣAA
AAA=qȀ\AQA  A33AA{A=qẠA
=AHAzAffAffAGAAAQAɅAəA=qAʏ\A33AȸRAȸRA
A{AApA(ẠA(AffAAA{AApAzA  Aԏ\AAәA=qA  A(AffA=qA  ApAApAҏ\A
A  A\)A\)AA  AѮA=qAѮAAAҸRA33AУA  A\)AGAffApAAffAAәAzAzAzAУAҏ\A33AӅApAAHAffAљAθRA(A̸RA͙A
A\)AAAGA
AGA
A\)AЏ\AzAAA33AAHAzA=qAхAϙA=qAͅAQAGAffAЏ\A
=AӅAA{Aҏ\Aҏ\A
=AәAHA
A֣AGAGAQAA\)A  AffA{AAأAQAA  AGA֏\AָRAzAָRAQA{A=qA  A
AՅAA33AGAAָRA
=AׅAׅA
=AHAHAzAָRAHAׅA֣AA33ApAθRAApAAHAGAGApAӮAApAAA=qA(A=qA
AϙAϙAGAЏ\AЏ\A  A33AGAљAAQA
=AffA33A=qApAzAzAңA(AzAәA\)A
=AA
AӮAAHAHA(A
=AAHA{AQAAAAQAffA
=AأAQAQA33AA
A=qAAAיAָRAAׅA֏\AA
=A֣A=qA  A
=AAAHAԏ\AAGA=qAffA(A(AHAӮAA\)AӅAӮApAӮAӅA
=A33AGAA=qAңAҸRAҸRAHAҸRAңA
=AA
A33AAHAծAHAffAAHA
AffAA33AzA  A
=AQAA
=A
=A̸RA̸RA
AϙAGApA
ApAffAGA33AAA33AՙA{A  AՙAՅA33AGApAGA\)ApAHAA
AՙAHAffAAA֣AՙA{A(AQA{A  AAGAzApAAAУAAѮAA=qAQAAѮAffA
=ApA  A=qAffAAA
AљAAA33A(AУAУAУAQA=qA(A33AzAApAffA=qAΏ\AGAϮAHAzA
=A
=AA
=AA(AθRAHAHAAHAθRAA33AHAAΏ\A\)A\)AA˙AA33A\)A̸RȀ\AͅA(A33A\)AA  AffAApAхAA(AffAAAAQA(AQAffAQAffA  A
A(AGAәA=qAAҏ\AAиRA(A
A\)AHAҸRAѮApAиRAA
=A
=AЏ\AQA{AHAAЏ\A
AAAυAQAЏ\ApAAυAA{AA33AΣAͮAGAAAHȀ\AzA=qAA\)AGAHAGA˙AHAGAA
Aʏ\A
A\)A
AA̸RA  A=qAQAɅAHAəA=qAA=qAffAAHAA
=A33AHA
=AzApAͮA=qA
=A(A=qA
=AAУAA33AAHAAAϙAGAθRAΏ\AAHA\)ApAGAϮApAGAΏ\ẠAAHAzA
AˮA
AϮAA=qAиRAGAУAиRA  A(AzAυAA\)AGAGA33AϮAϙAθRAA  A\)ẠȀ\AA  AHA
ẠAAffA˅ApA
=AzApAAAHAǙAGA
AGAHAAȏ\AǅA{AȸRAAzA
A(AθRAAϮAAυA{AAQAУAиRAzAHAQAQAϙAУAЏ\A=qA\)ApAA=qA͙A͙A33AAGA
=AͅAͅAͮA=qAΏ\AAzAΏ\AAQA33AͮAA=qAffA
=AA  A
A\)A˅A\)AHAɅAHAAA
=A=qA˙AAQA  AQAʣAApAGAəAQA  A(AͅAͮAʣAʏ\A=qA=qA̸RAffAAGAHAGAǙA(AffAǅA=qAAA  A33AÙAAQAGA=qAǅAƏ\AǮAA
A{A=qAAˮA˅A˙A
=A
=AAʣAʸRAʸRAʣAA
=AʸRAAʸRAA
=A
=A
=AA\)ApA˙AQAHAA
=ApA͙A\)A\)A\)AffA(A  ApAA\)AQA(AHAȣAɅA
=AəA(AA(A(A=qAffA{A  A  AQAʸRAAHAAA33A=qA˙A(A\)A\)A\)AA(AzA
=AAGAA\)AͮA  ApAHAGAGAHA
=A\)A
=AAAQAAGA{AˮA(ẠAAAQAΣAHA
=AΣAΣAΏ\AΣA
=A
=AAHAθRAΏ\A=qA33AAA33AͅAGA  A͙AQAAGAͅAA
A{A=qA
AAApA̸RAHAffAzA{A˙AA=qAAʣA33Aʏ\A  A(AHAʣAzAffAȸRA  A=qAɮA  A  ApAGAA˙AẠAA{A  A  AA33AəAQAʸRAAʣA\)AɮAzAGApAAQApAHAGAAGAθRAzAθRAA
A(A(AЏ\AffAzAυAAAGAиRAиRAAϙAϙAGAGAAQA(ApAA̸RAθRAAQAθRAGAA(AffAЏ\AA=qAA  A(AA  AA33AΏ\AQAͮAHApA͙A
AGA\)A\)AA33A33A33AGAA33ẠA
=A˙AQA̸RȀ\AGApApA\)AGAAGAͮAffAA\)A
A=qAQA  AzAffȀ\AͮApAA
A͙AA
A=qAAAAGAυAхAљAA
=A˅A  A˅A˅A{AQA˅AQẠẠAffA
AGA
=AQAʣA  AA
=A33A˙A
AẠA(AAffAGA  AAˮA˅AzAQA{AA\)AˮAAˮAAA˅A˙A
A\)AQAAA=qA  A  A{AɮAAHAzAʸRAffA(AQAAHAQAˮAGAAQAAffAQAA{A˅AffAHA̸RA̸RApA̸RA33A\)A
=AAA\)AAɮA  A
=A{ApA33AυAυApAυAυAυA{AQA(AGAυAAϮAϮAϙAϙA33A33AHAΏ\A(A{A=qA(AAQAəAAHẠA{A=qAθRAAAGAϮA\)A{AGA
=ẠA̸RA(AzAHẠA=qA(A{A˙A
A˅AʸRA
=AA{AzAGAGAA
=AɅA  ẠAA
A
AQA(AffAGA
Ȁ\A\)AQA˅AA=qAffAA
=AA̸RAȀ\AAApA͙A  AzAQAθRAAHAA
=AGApAυAυAϙAυA\)AGAGA
=AAAA\)A\)A\)A\)AA
=AAHA  A\)AAGA̸RAApA=qAA
=A\)A\)A\)AApAAAffApA33AAHAA̸RAAGA\)A
=A
A  ẠA=qAAˮAʏ\AzAzA\)A(AAʏ\AʸRAzAQAQA{A(A
AA(AA{A{AzAzA
=AA
=Aʏ\ApA(AAʏ\A{AA  Aʏ\A{A33AAΏ\A
=AAGA
A=qAzAЏ\AQAQAQAzAAиRAУAУAA  A
AυApAGAAΏ\AΣAzAffȀ\AΣAAzA33AθRAΏ\A=qA(A  AffApA  AAGAGA͙A\)A
AAA(A{A(A{AAAA˅ApA33AAAzA˙Aȏ\A  AAʏ\A=qA
=AAApA˙AA\)AʸRAʸRAHAHAHAʸRAʸRA
=AA33A˅A˙AffA˙A˙AA  AGAzAθRA(A˅A
=Ȁ\A
=AA̸RAAzAzApA33A
A33A
AəA{AffAAAAA
=AʸRAɅAəA
A\)AȸRAA33AffAQAzAffA
=AAffAȸRAȣA33AzAAȸRAȸRAApApAɅApAɅAəA
AA{AffAGAAffA
=AHAAHAGAGA33A˙A˅A˅A\)AAɮAffAȸRA  A=qA33AAHAĸRAGA
A=qAȸRAA33AAǅAǮAA  AɮAffAȸRAʣAAəAəAɮAAffA˙AA=qA  AAˮA  A˅AͮAffAffA33AAA
A  AυAA\)A(A
=AΏ\AQA=qA
A(AΏ\AzAQAΣAΣAffAQAHAffAQAΏ\AΏ\AAAHA
AAzAGAzA̸RAAAȀ\A͙ApA{AHA=qA(AəAGAA
A=qAQAǙAGAAřA=qAA
=AzAȏ\AǅA{AffAƣAʣAQAÅAAȣAȣAQA
=AffA
A33A˙A  A(AˮA=qA̸RA
=A=qAA
A(AAθRA
=A\)Aԏ\Aԏ\AffAՙA\)AծA{AA=qA  AҸRAQAQA  AAQAA{A
AApAQA\)AQA
=ApAѮA
A
A{A  A{AQA  A(AffAQAѮAљAA
=AЏ\A=qAQAAGApAҸRAЏ\AAAңA  A(AAϙAϮA(AffAA  AУAϙA33ApA\)AGA
A33AAΣA(AHAHAzAzApAGAͮAQA33AQAffA\)AȣA
A\)A33A(A
=A  AQA
=A
=A{AA
=AHAA{A\)A(A˅ApAHA=qAυAQAΏ\AzAͅẠAυAzA33A  AA=qAGAͮAͅAAʣAʸRA˅AApAHA  A=qAʣA˅A(AAA
A\)A33A=qA\)AʣAffAʸRAHAQAHAHAffAffAəAAAGA=qA=qA
A{AAAA  AA\)AAʏ\AʸRA
=A(AAʏ\AA=qAəAɮA  AɮAȣAGAɮA
AAA33ApAAŅAzA
=AzAƏ\A{AAAHA
=A{AAA  A=qA  A\)Aď\A33AA(A33AɮAGAəA=qAA  AzAAGA33A
AΣAΣA
=AAGApAυAAυAA=qAQA\)AA  AzA\)AGAA
=AAΣAzAHAͮAͅAͅA
AApAzAˮA=qA(A
=A=qAAA
=AQA=qAA  AHA(A
A(A(AHAȸRA=qA
=AAA  AǙA  AHA\)AΣAAHA(AAʸRAAffA=qAʣAAAQA33AȣAɮA33A=qA\)AHA{AAAΣȀ\A(AHAHAGA  AQAQAffA{AA33A33A33ApA͙AA  A{A=qAzAΏ\AΏ\AΣAzAΏ\AzAQAzAΏ\AΏ\AͅAHA{A\)A  AGApA
AϮA\)A
=A
=AθRA\)AAHAAApAϮAϮAGA
ApAϙAAAϮAA
=A33A̸RA
=AʸRAAA˙A(AɅA  AAA  AHAQAAɅAɅAɮA{ApAAzAΣApA  A{AzA(Ȁ\AHAA=qA(AHAυA{AУAHAљAGA
A  AA(AAAAA  AAApAծAՙAA33A  A{A
A=qA=qA=qA33A33AHAffAA\)A\)AAAQAӮA
AAQA\)A33A33AHAAffAңAQAA{AΣA͙A͙AA͙AA  AθRA(AA33AA
=AΣAzAЏ\AAGA  AffAA33Ȁ\ApAA{AAGAAHAAʏ\AˮAʏ\AʸRAʣAQAA
AA  AA(A̸RẠA=qA\)ApAΏ\AzA
ApAQAˮAffA{AAA  AA  A˅AAHẠA(A\)AAAAAQA33AɅAGAHA(AGA=qAǮApA
AffA
AQA  AAəAHAAAQAAA\)AzApApAȸRAɅA\)AɮAəAGApA\)AɮApAɮA33A
=AəAAGAɅAȣAzA\)AAffAHAAAzA
AQAģA(ApAffAřAŅA(AƏ\A=qApAA  AʸRApAQA33AʸRAAAA͙A
A
=AϙA{AHAAzApAӅA(AQA(A
AzA(A(A
A  A
A{A\)AAʣA̸RAAHAʣAəAzAQA(AQA̸RAGAzAGA33A͙ApAAA33A33AəAɮA
AzA  A(A  A˙ẠA˅A33AəAA\)A
A
=A\)AA(AǅA\)AzAAA(AǮA
=AAA̸RA
A
A(AAAGAΣAffAͅA
AA=qAHAAQA(AAͮA(AzAAϙAЏ\AхAAӮAӅA  A  A  A
AHA=qAAϮAA
AӅApApA
=AHAHAA
=AәA{AGA  AϮAΣAQA=qAffAffAԏ\AԸRAӮAA
AAQAAAQA{A{A(AͮApAẠAͅAzA  AQAA\)A(ApAzAɮAʸRAʣAɅAɮAȸRA{AGAAΣA(A=qAAA
AffAA
=A=qAffAzAGApA{A{A=qA
AHAffAA{AAQAffAA  A
A33A=qAɅAɮA
AʣA
=A{A  A  AzAA
=A͙ApAΏ\AΏ\A͙AϙApA=qA  AΏ\AȀ\ApA33AAͅA  AQAҏ\A
=AЏ\A͙ApAЏ\AӅAHAHApA\)A(AAAAϮAGAzA33A=qAHA=qA  AGAHAGAGA
=A(A\)A\)A33A˅A\)AAʏ\AˮAʏ\AʸRA\)AHAHA{AQAAԏ\Aҏ\AAA
AУAӅAApAzAffAљApA=qAΏ\AͮAHAΏ\AΏ\AθRAθRAAzA(A\)AffẠAApA\)A{AffAzAθRAffA33AA͙A\)A͙AΏ\AAHAQA˅AffAθRAQA͙AffApAzA
=A
AυA
A\)AzA\)AиRA\)A
=AHAиRAѮApAffAQA  Aҏ\AffAυAA\)AAẠAffA
A{AˮA33ApA  AffȀ\A  AQA=qAzAAffAAA\)A=qA
AHAA
=A˙A\)A̸RAAAffAAͅA
=A{A
=AɮAGA{AGAAAA(AQA{AхA33AA=qAAѮA
AљA
=AΣApAAAHẠAAʣAəA
=AffAzA{A\)AAəAʸRAAzA{AA=qA  AȀ\AffAA  ApAʸRAɮAʣA\)AHAGAɮApAzAAAʸRA̸RA͙A\)Ȁ\A{AAͅA  AffAzAȣAHApA
=A
=AA
AAA\)A  AŅAHAřAAHA˙AAffAȣAȸRAȏ\A
AAȣAA
A{AȣAəAɅAAɮAǙAƸRA{AAGA33AA=qAA33ApAɮA  A
AAA
A
AɮAɅApAAHAAȸRAHA
=A
=AʣAʣA
A˙A
=AHAzAQAHA33AffA=qA{AQAAǮAA
=AA33AzAƏ\AɮAȏ\A  AǅAAAƏ\AffA(AzA{AAA
A=qAȏ\A  AGA33AzA
=A  A\)AHA
AʸRA  AAɮA33AQA
=A̸RA  AʣAAA\)AzA33A33AͅȀ\AAA=qA=qAθRAAAЏ\AHApAA
AAңAҏ\AҸRA{AzAffAAљAAAAѮA
AA
AЏ\AAffAϮAѮAAA33AϙAQAʣA  AϙAA\)AGA˅AAͅA{ApA\)A(AAA
=A  AA  ApAˮA  AˮAGA33AΏ\A
AffAA
=A  AΣAQA  AAAzAʣA=qA(ApAHAA\)AʸRAQApAAAA{A{AˮA  ẠAAͮAͮA(A33AAAA(AHAљApAңAңAHAҏ\AzAҏ\AzAңAA
=AGAGA
=AAҏ\ApA(A=qAϮAHA\)AA
AϮA\)AGA(AθRAAͅȀ\AA33A{A\)AApAAHAAAA
=A=qAAQA(A˅AA
=AHApAθRA=qAHAQAAffAA=qAʏ\AHA  A(AʸRAˮA  A{AʣAɮA33A(AȣAGAGAɮA=qAA(AAQAGAͮA̸RA=qAzAϮAAAиRAGAQA
=AAzAA֏\AָRA
=A33ApA
=AHAA
=AָRA֏\A=qAAՙAQA=qAHAծAAԏ\AffAԣAԸRAffAӅAAҏ\AAQA(AHAffAϮA{A  AAԏ\AӮA  AҸRAͮAϙAGA˙AAffAffAHAApApApA
=AHAAA{AApAffAθRA(AzAGA͙A\)AApA  AQA=qAҏ\A33AЏ\A̸RA̸RAGAʏ\AAHA=qA(AQAиRAиRAљA  A=qAQA=qAHAGAәAәA  AQAԏ\AAApAՙAծAծAAA
AAՙAGA\)AA
=AQA=qAӅAAҏ\Aҏ\A  A33A\)AϙA\)AA=qA33A\)A˅AA˙A{AAυA33AAffAΣApAΣAϙAzAHAGA\)AA
=AиRAAGAA{A͙AzA
=A=qA͙A\)A
=A(A{AΣA\)AAAиRAЏ\AzAхAAQAхAAAGA
A  AQAAAGAGAУAA=qA{A33AHA33AAAҸRApAzA
=AAӮAAzAAAԣAԸRA33AHA  A{AA(AA{AGAAffA{AAAGA33AхAиRAHA33AљAHAApAԏ\AѮA(AApApAҸRAAԸRAAAAA=qAffAzAAAAGAAAffAGAθRAA33A{AffA=qA{AA(A=qAQAA{AHA
AApA
A\)AffAAHAAAәAAӅA=qAAԣAԸRAHAAApA
A
A
AA{A{AzAָRA{A(AAAGA\)AׅAׅAׅA׮A{A{A֣AHA֏\AָRAָRAָRA  A
AՙAA(A=qAQA{A
AAA33AffA(A(AffAffA
=A33AffA33A=qAzA(A=qApAԏ\AGAAAҸRAGAGA  A
=A
=AQAAHAAGAͮAΏ\AHAиRApAffA=qAGA  A=qA=qAԏ\AzA(ApAхA=qAҸRAGAHAҏ\A{A=qAffA{Aҏ\AzAzAHAGApAәA  AԣA
AәAffA{AԣA
A
A
AӮA(AGAA33A33AA=qAzAHA(AHA
AzAA{AָRAԸRAA{AffAԸRAHAQAAHApAA֣A\)ApAHA{AQAϙAAGA
=ApAHAGAAAQȀ\AϮA(AӮAәA33AиRAAGAffAQAffA
AA  A
AAGApAԸRAׅAҏ\A\)AAˮAQAљAAAAQAҏ\AAAA
=A\)AGAәAzAԣAAHAHAQAAA  A
AӮAAQA
A33AҸRAzAHAѮAAffA  AA  A33A\)A(A
AHA֏\AAHAAծAծAӅA{A=qA\)AAHA
=A\)AffAӅA(A  AGAAGA\)AffAՅAυAAA  AˮAHAHAApAAхA
A{AљA
A33A33AA
=AffA{A{AGAAиRAHA
AAAAHAљAQA(AffAУA33AAAffAzAиRAхAzA  AхAхAѮAѮAѮAљApAѮAѮAzA(AffAffA=qAAAAQA
=AәAA(A
=A\)AAA=qAGAA(A{A
=AGAAΣAHA=qAA  AffA{AљAхA
=AQAA=qAЏ\Aҏ\AA=qA
A
=A
=A=qAΣAffA  AиRAAAAAA  A
=ApAиRAA=qAAHA{AAיApAAٮAAAAHAffA
A
=AӅAָRA֣A  AzAffAffA=qAzAAffA
A{AGA֏\AGA\)AQAׅAׅAָRAQA(A
AծAՙAGA  A=qA{A  A
AәA33AGA=qAffAAәAQA=qAzA{A
=AHAHA  ApAA  AأA֏\AAӮA\)A
=AffAA\)A  AңAA(A  A=qA
A{A=qA
AЏ\AHAиRA33AͅA33AAffAApA  AAHA33AzA=qAQA=qAԏ\A=qAA
=AA(A  AУAAA(AAffA{Aҏ\AӅA{A  A  A(A  A=qA(A  AA(AәAԏ\A  A=qAԣA\)AծAծA\)A=qAA\)A=qApAGAHAԣAAՙA  AAAGAffAA
=A  A=qAԣA
=AGAхApAAԏ\A{A(AAGA
=A
AAzA
=AΏ\A\)AffA
A=qAQA=qA  Aʏ\AzAA(AHAAGAˮAffA
AθRAAAQAffAffAϮAzA
=AGAQAGAѮAљAA=qA
AиRAθRAffAQAΏ\A
=AϙAУAѮA(AAAQAծA  AzA֣AGA׮A(AffA  AffA\)A׮A֏\ApA=qAՅAGAA{AGAAQAffAQAffA֣A
A֏\AffAиRA(AHA
A\)A\)A{A  AңA{A
AAQAңA
=Aҏ\AAzAЏ\AffẠAGApAЏ\AHAΏ\AиRAGApA˙AffAAθRA  A
=ApAzAѮAAԣApA{AzAGA\)AffAzAA33A׮A
=A33A(AծA  AAAAA\)AA33A33AՙA
AAՅA(AQAA(A=qA
=A֏\AzA֏\AffA{A{A؏\ApAٙA؏\AffA֣AffAA{AGAיApAHA(AA33AA\)AיAAӮA
=AיAGAՙAQA
ApA=qA
=A  ẠA  A{AHApAzA̸RA=qAAҏ\AGAHAzAffA  A(Ȁ\AAA{AGAzApAAQAAA
A
A=qAzA{AϙAΣAGAA
AΏ\AA˅AA33A
=A\)AA33AҸRAңA33AGAӅAApAA{AffAzAffAA
=ApAA
=AHAԸRAzAA
=AҸRAңA\)AәA  AԸRAA
=AAҸRAԸRApApA(A(A{AA(A33A  AиRAAA{AHA33AzA=qA=qAҸRAA
=AHAҏ\AA33A
=AљA\)A
=AңA
=AңA\)AУA{ApAQAυA(AzAͅAzAffAңAAffA
=AGA
AՅA(AAծAՅA{AQAՅA=qAHA
=AՅAՙAHA\)ApAA׮AA(A(A{AQA=qA=qAظRA\)ApA33AzAffAQAQA=qAAAָRAAzA؏\AظRAA
=AzAzAأA
=AAAHAأAffA  AיAAA(A{AAأA\)AffAA׮AGAAQAA=qAApAԏ\AAffAQA(AA
AffA(A=qAԸRA(AӅAffAAQAәAzA  AffA
=A
=A
AՙA
AA(AA  A{AәAffAQA
=AծAffA֣ApApAAffAzA=qA=qAQA{A
A(A{AHAHAHA
=A
=AA؏\A(AGAAHA=qA؏\A
=A׮AAGA
A(A  AQAffAA\)AׅAAיAA
A{AA
AAA  AA  AԣA
AHAיA
=A  AGA֏\A
A֏\AzAA\)A\)A33AHA
=AQAffA33ApA\)AAGAGAA  A͙A33A=qA
=A33A{AӮAA  AHAиRA33AѮAA(AAGAGA=qA33AA  A{AHAAA{A{A{A׮A=qAffAzAzA
=AAGA\)AAظRAA{A33AظRAA  A؏\AHA\)AffAHA\)A
A{AHA33AAGAՙApA33AA{A\)AAAAҏ\AAzAzAQAԏ\AffA
AA\)AA\)AAQAԏ\AԣAԏ\AHAхAffAѮA33A=qA  AHAGA33A{AӅA\)A33AffAHAHAAffAAA(A
=AׅA
=AAיA  A=qA\)A33AffA
AمA
=AٙA
=A\)AمA=qAffAApAGAۅA
A  AڸRA\)A\)ApA(A33AA(AٮAAffAA
ApAA֏\A  AffAzA=qA
AأA(AzA=qAGA
=A=qApA
AAA33A{AA
A
AffA֏\AffA(AAՙAffAԏ\AzAHAffA  A
A  A
A33AA\)A\)A=qAиRAѮA\)AffAQAffAҸRAffAQA  AӮA=qA
AAGApA
=AӮAәAAәAffAԸRAA\)AGAՙAAGApAA(A
=AGAffA\)AHAzA=qA{A  A=qAffAA{A{AA
A
=AظRA\)A\)AHAAׅAظRAAAzAzA؏\AAAQA(ApAQAHAAӅA=qAՙAAzA؏\A֣A  AffA؏\AׅAA֣AA(A(A׮A֏\AGAffA=qA
=A=qA\)A֣AA33AffA֣AՙA=qAHA
=AQA  ApAָRAHA33A(A{AAGAAA{ApA(A{A\)AծApA33AAA{AQA{AzA(A(A֏\AָRAzApAGAGAHAAffAAA؏\AGAA{AׅA
=A\)AיAׅA׮AׅAHAA֣AՅAՅAGA
=A(A{A=qA\)A
=AHAHAAHAAҏ\AָRAzA
Aҏ\AGA{AҸRA  AAхA  AzA{AЏ\AѮAхAHAΣAGA33AAGA{AAA
=A33AϮAϙAA{AQA=qA33A
AѮA
AиRA(A\)A=qAAңAA33A33AәAAԣA33AAA33A
AծA{AzAHAHAzAיAHAHAzA  AA33A(AApAAAHA\)AA33A33A֣A(A=qA{A
AGAffApA  AQAffAzAzAAхAGA(A(AApA\)AAAA33A(AzAхA  A=qA33AУAAУAAffAA\)AGA{A(AиRAffA=qA{A  AGAAυApAυAϮA
AAHAGApAGAAffAHA\)A=qAԏ\AծAՙA
AQA֣AָRA
=AיAAA=qA=qA  A  A
AAAAAAׅAׅAA
A
AAׅAׅAApAA  A\)AHA\)AAA(A{A{A
A  AffAA=qApA=qA\)AAAAGA\)A  ApAAҏ\ApA
=AхAљAffȀ\AAAѮAѮA
=A(AQAzA33A{AHA\)AՅA(A{AzA֣AQAQApA(AAzAGAQA{AzA؏\A{A
=ApAHAAA
=AAAԸRA=qA
A{AAיAzAzAAA
=A33AAAAHAQA{AٮAمAA(A؏\AAA{AHAԏ\A
AՅA
=AծAծAAA
AffAA=qAָRAAAA֏\A=qA׮AظRAzA  A33A33A
=AظRAffAծAңAAzApAҏ\A33A
=A
AAԸRAHAԣA(AAQA(A
=AHA
AzA
A
A  AңA
=A\)AzApAԣAGAՙA  AԸRAffAAAffA
=AٙApAڏ\AGApA{AzAHAAHA܏\AzA  A  A=qAA\)A=qAAAzAAHAzA܏\A{AHA
=AAAۮA\)AۙAQA
=AA33AA{A=qAڸRApA
=AffA֏\AHAQAffAAHA33AأAAQAffAיA
=AAffA\)AظRAA{AQA(A
A{A=qA33AAظRAAA(A(A{A=qAzA{AzA  AffAA(AHAzA
=AHA\)AأA׮AHA\)AיA  AzAأAأAzAظRAAظRAأAAHA؏\A33AGAAHAAzAAHAمA\)A\)AGAA
AٮApA\)AGA33AGAٙAظRA  AAAffAأAAՅA33AA
=AԣAffAHA{ApAffAAzAHA{AAҏ\A
AApA{ApA  A{AA33AQAΏ\AAAA33Aҏ\A{A  AՅA33AAAׅAHAծAAQAA  A(AHA33AיAA=qAffAzAA{A=qA؏\A\)AA33AٮA  AAffA(AՙAծAԣAԸRAԸRAA{A{AӅAA\)A33AGAՙA\)AծAAԸRA33A=qAzAHAԸRAA\)AծA֏\A֣AԣA(A֏\AzAָRApA
AٙA(AA׮AיA{A׮A  Aҏ\A(A
=A  A(AЏ\AQAAУAffAԏ\ApA33ApApA
A33A͙A\)A
A
=AӅA
AA\)A
=AA
=A33A
=AQAԸRAՙAAHA{AָRA=qAA
AAA33AңAHAҏ\AGAAAQA{AApAAAQAHAAffAffAA  A(AՅAՙApA\)A\)AA
=AHAGAAԸRAԸRA33A
=AHA
=AGA\)A33AzAAffA  A(A
=AAQA=qA(AҸRA\)AәAәAQAQAzAAGAffAAAzA=qAGAffAAGAΣA
=AУAA̸RAGAAθRA=qAHAffAӮAӅAҏ\AHApAffAA{ApA  AϮAffA33AAυApAυAυApA
AzAAApAAAAA\)A\)ApApAӮA\)AәAӮAӅAAӅAAәAGAApAљAffAzAAHAGAA
=A33AиRAAЏ\A{AθRAΣAAzA=qA
=AAAzAA=qAAffAApA
A\)AθRAΏ\A  AQAA  A=qAϙA
AAиRA\)AAAΣAffA
=A  AA=qA  A33AffAffAυAAzAGAGAиRAA{AAAffAAA{AAAzA\)A
A  ApA  AAffA֏\AHA33A\)AׅAיA\)AׅApAׅA  AGAՅAAzAHA
AAAA(AA=qApAGAQAzA
=AGAAׅAиRA  AzA=qA֣AA  A(ApAׅAAAApA{AԣApAA=qAәAQA33AGAAffA=qAffAffAAffAzAAAHA(A
=AGA\)ApA33AA{A{A(AzAѮA{AAAQAҸRAҸRA33A\)AApA(AffA
=AA\)A
=AAffAHAA
=A33AGAՅAA=qAQAAffA֏\AQA
=A{A
=AAHAAAA\)A
=AGApAGAGA
=A33AGAGApA
AיAAAHAAA(AѮAzAAHAAzAGA
=AHAӅA
=AAӮA{AAHAӅAЏ\AAָRA=qApAхA\)AzA\)A33A(A
A=qA
AA
A
=AzA\)AAԏ\AzAծAGA
AHA\)A  AQAиRAAGAApApApAϮAϮApA̸RA˙A=qAA
AAGA=qAƏ\AA(AŮA33AģApA
=AAffA\)AGARAA
AAHAAAAAQAA=qAA=qAA\AzAAAAAffA(AAAGAAA33A
=AARAApAARAGA  A33AzAAAHA33A=qAzA
AAGA\A(AA
=AAA\A=qAGAA\A
=A  A(A\)AĸRApA=qA=qAApA\)AA\)AȸRAAͮAApAAϙAA33AA\)AGAͅAA33A\)AAиRApAAǮAGAHA\)AAGAиRAQAA{A  A˅AA=qAǮA=qAAzAAQAƸRAȣAAQA˅AAəAA(Aȏ\AQAGA(AGA{AffAɮAəApAAffA\)ApA33A=qAA33A\)A˙A˙A=qAɅA=qAиRAAAΏ\AffAəAAQAʸRAAAəAzAAAģAȀ\A  AHAHAHAA33AA
=AǙAAɅAAA{A(A  ApA=qA=qA
AAQA=qAHAϮȀ\ApA(A
AAAAAυAHAɅAÙA
A(A(AffA\Aď\AŅA{AA
AzAffAȣAQAAřAȏ\AzAȣAHA
ApAzA33AffAARA33A{AAApARAA\)AGApAAzA33A\)AAA
AApAApA=qAffA{AAQAA  A  AGA
=AffA\AAQAzA\A=qAzAAA
A
ARA(AGApAƏ\A=qA  AAAÅAA  A
AffAA
=AA33A  AHA{AARA
=A33AÅAAA¸RAGA{AAA33AAQAffAzA=qAffA{A\AAGApA(AAA\)AŅAHA
AAA=qAA\)AA33A  A\)AAAAAA\A=qAAHA  A(A(AAHA33A
ApARA
=A=qA£AAGAQAÅA=qA
AA{ARA
AA=qAzA
A=qAAffA{AzApApAA
=A33A\ApAffAĸRA33A=qAffA
Ȁ\A\)A33ApA
AAÙA=qA=qA
=A\AGAAGA¸RA=qA{A\)A\AAAzAAAAAzAffAA{A
AAHAA33AŮAffAzAffAzA
=AAA33AffA\AzAGAAffAAA  AGAA  AŅAď\AAAÙA
=AģA33AzAAÙA
AəAʣA33AAA(A(AAQAzAȣAȣAHA\)AAɅAəAQAƸRAffApA{AQAAGA
=A\AAQA
A˅A  A  A33AHAA˅AA
=A=qẠAͅAffAffApA{AffA
AzA{A
=A  AƸRAǙA
A
=AzAɅA˅AɮẠAzA̸RApAͮA33AŅAÙAzA
=AȸRA˅AA
=AQApAQAffA
=AΣAffAHAAA
=AŮAŅA  Aď\AA
=ApAAřAAŮAAA{ApAA=qA
=A(A=qA(AA
AQAffAAҸRA  AхAУAAϮAυA33A33A
=A͙AȀ\AAʏ\AAGA
AA͙AAA
=AA(ApA
=A\)A{A
AʣAAȏ\A{ApAGAģAŅAAzAAGARAGA£A33AAA\)A33AHA  AGAÙAzAffA
AzAAîA\)A33AA{AîAÅAAQA  AA\)A{A
AřAHA\)A
=AGAApAzAƸRA
A\)AAzAA\)A\AzAĸRAzA(A
A
=AA=qAQA̸RA
A
=A\)AzAA(A(A
=AAA
AAAQA
=AQA¸RA=qAAřAƏ\AffA=qAAA  AA(A\)AAAAQARAA(AAAA
AAA
AHAGA\)AA33ApAAzA(AAAGAAA\)AA33AGA{A=qA(ARAHA
ApA{A(AzAAAAAA\)AA¸RA
A
=AAĸRAȸRAȣAAQAȏ\A
=AQAGAAzA
A  A\)A\)AȸRAȣA
A\)A33A
Aʏ\AAA  A̸RAAA\)AAQA33AAAHA33AA
=Aʏ\AʸRA=qA
=AHA(AQAzAŮA  A33ApAA¸RAA
=A(A=qA\A(AAA
=A\AA
=AAApA
AA{AQA\AHA=qAA˙AA=qA{A33AȸRAəA  A\)AƸRAffA(ApApAƏ\A\)AAʣAHAͮA=qApA
A{AAAAAHApAzAAQAA  A  AAHA£A(AAA33AAƏ\AQAʏ\AHAA  A
=Aʏ\AzAAApAA=qAA
AθRAAAQAQAAAA=qA{AŅAAAAGAApAGA\AAA\A  AŅA=qApA
=AApAAzA=qAĸRA  AzA=qAAɅA
AffAAA33AAƏ\AŮAGA{AA\)A{A33AA\)AAŅA  A{AAA{A(AzAA33AAͮAA=qAffȀ\A  AzAQAHAӅA
=AAхA\)AϙA\)AQA{AGA
ApAǅAAGAQAɅAA(AHAƣAA33AA  AA(A˅A  AŮA
=AA(AGA
=A33AƣAzA
AGA\)A(A
=AApAɮAffAGAʸRAQAAˮAəAzA\)AɮAffAAȣA
=AəAffAȣApApA\)AƸRA=qAƏ\AA\)A{AģAAzApAA(ApA\)AHAAAzAGAʸRA
=AA
A(ẠAffẠẠApAGA=qAA  AǮAA{AAAHA\)AzAǙA\)A33AƏ\A=qAHAȣA\)AA
ApAAzA  AǅApAAAzA\)A  A(AɅAGAA33AȣA
AǅAAAȏ\A
=AApAA\)AîA£A=qARA(A
A
=AǙA
=A̸RAAəAAˮAGA(A=qA(A33AGAGAȣAAzA33A
=A{A(AǙAzAA  Aʏ\ẠAA  Aȏ\ApAAGA(AͮA͙AͅA
=AQAA\)AQA
=AAԣAGAffApAzAԸRAAQAAA\)AzA  A=qA{AAffAУAAffAHAAθRAA͙AɅA  AAǙA\)AQAGAQA=qAΏ\AHAHAzȀ\A̸RAffAApAƣAǙA
=A
ApA33AAffAAAȏ\A\)AGAAAAͅAGAHAAǮAǙA33A\)Aȏ\AA33AAGAAAHAzA{AffAθRAHA\)AӅA33AԣAQApAԸRAՅA
A\)AәAGA(AӮAGAA
=A33A
A
AAA  Aԏ\A
Aԏ\AҸRAԸRA
=A
=A(A(Aԏ\AQA{AAGA
AңAQAңAңAAҏ\AхA  AAAffA
=AAzA33A͙AQAΣAzA=qAθRA(A=qA(AA  AʣAȏ\AAẠAAȀ\AA33AHApAA\)AңA33AA͙AHẠẠAQA
=AΏ\AffAffAHA
AA  AQA{Aҏ\A  ApA33AԸRAHAAӅA\)AQAУA
AHAУA
A=qAzA\)AA
=A{Aҏ\Aҏ\AA
=AхAҏ\AHAУAQApAQAAҏ\AӮA{AA{AAәAAӅAffAәAңAӅAA(AѮAЏ\AGAQApAљAzAffAA  AυAAΣApA{AͮAApAHA33AQAřAAzAzAəA  AǮAzAΣA(A=qAGAͮApA=qA  A33A33A  AQAҸRA(AzAңAAAҏ\AHA33A\)ApAәAA
A
AAӮA
AA(A=qAffA(AffAЏ\AЏ\AAљA  AϮAAA=qAAGAѮA33AӅAAA33AхAAѮAAHAHAzAхApAQAθRAGApApAΣA
AЏ\AAȀ\A33AA̸RẠA=qAəA(AθRȀ\A33AͮA=qApA͙A33AAͅAθRAA  AʸRAAA
=A\)AHApAϙA
AQAHAGAA(Aҏ\Aҏ\AQAffAQAGA=qAQAzA{AQAQA(A(A
AՅAՙA33AAԸRAGAծAՙA33AԸRAԸRA33Aҏ\AApA
=AAAA=qAQApẠAA{AɅAHA
AхAAΏ\A=qAϙAffA{AхAAѮAϙAAHA
=A
=ApAAљẠAA
=AA
AиRA
AA̸RAͮA\)A
=A33AA=qA{AAʏ\AHAAΣA{A
=AAAͅA=qAΏ\ApA33A{AQApAAAffAңA{A=qAҏ\AAGApA\)AffAAҸRAңA
=ApApAHAHA(AAϙAGAA=qA  AGAAA  AՅAA  AzAA
=AHApAHA{AzAA
=AHA=qAυA  A
=A=qAA33Ȁ\A33AͮA͙A͙AffAͮAAHA{ApA
AͅA33A(AAGAHA  A  ApApApAͅAA
A{A
=ApAHA(AAљAхA
=A  AHAffAAхA\)AAӅAHAA33AׅAAA
A=qAQAzA؏\A؏\AffAffAQA=qAQAzA  A{AָRA\)A׮AAffAAAAAffAԏ\AffAQA(AӅA{AAzApAApAzAՅAՅA
=AzA
AGApAҸRAҸRA
=A  ApAхA  Aԏ\A
AGAӅApApAGAzAHA
=A(A33AzAѮAУA
A33AAHAΣA
A͙AˮA
AffA
=AУA
=AϮAQAAиRAљA
=AA=qAA
A
=AиRA
A=qAffA\)AAAУAffAA{AA=qA{A33AиRAGA{Ȁ\AυAAA33A  AQAAA\)AA(AAGAHAAAɮAQA
A(AffAzAAffA\A\A33A
AQARAAzAQAA=qA\)AQA{AzA(AAA  A=qApApA\)A(AffAAffA\)AA{A\AffAffApA  A
=A
A=qA(A(A
AAzA33A
=A33A{A{A33AA{A=qAAÙAQAģA
=A(AŮAGAHAƸRA33A33AA  AA
AQA\)A  AˮAGA¸RAA\)AQAȣA{AA\)Aʏ\AQA\)AHAffAͅA  AAzAAAA=qAA  AңAхAAљAHAGA33A=qAυA\)AAȀ\Ȁ\AzApAA=qAAAffA˙A33AȀ\AGA33AzA˙A(AA̸RA=qA33AA̸RA\)A̸RAͮAAAffAθRAͮA
=AͮApA33AУAϮApAHA(AQAGAGApA
A  A=qAQAzAAәAQApA
AA
=A͙A{A\)ApAӅAzApA33AAAA\)AӮAGAApA\)AAAҏ\AAAиRAAУAGAAϙAθRAAHAffAHA=qApAQAθRAθRA͙A  A
AQA33AиRA
A͙ẠA͙AHA(AͮA(A  AиRA{AAQA\)A33A͙AGAQA͙AΏ\A{AθRAAA\)AA{A  A͙AẠA
=A\)A{AQAAңAϙA{A=qAA
ApAͮAυApA=qAzA\)AzAHAA\)A  A(A
AљAAΏ\AQAθRA{AAA33AҸRA=qA
A  AAffA(AѮAA(A(AHA33AϙAQAAffA{AхAA
AѮAQAΣAQAA\)AHAУA=qAAˮAAffẠAGA
=AAЏ\AHA33AHAϮA(A\)A  AA  A(A
=AA=qAGAGAәAӮA
A{A
A֣A
AAA\)AHA33AAGAQAأAGAGAzAAظRAffAAAAۮAQAffAzAܣApA33AA
=AA33ApAAۙApAAHA=qAA33A(AApA
AAAAAAA{AAApA{AA=qAffApAиRA{A\)A{AϙAAAGA
AϙA
A{AffAApAA(A˅AQAͮA  AzAQAHAA
AAQAיA{AAңAՙA(A\)AAυA33AHAΣA{A
A
=AGA=qA  A{AzA  AzA\)A  AAٮA  AzAQA33A\)AA{A
=AAQAApA(AA33A\)AAمAمAمAA؏\A
A  AיA(A֣AAzAՙA\)A=qAԸRAծA
AՙA
=AAffAAӮA=qApAA
=AңAHAѮAAљAAA
AиRA
A
=AHA\)AУAzAHAffA33A
=AzAAϮAA  A=qAGAA(AAGA  AffAΣAΣAGAυAA  AЏ\AA
=AHAA33A\)A\)A33AHAУAУAA  AGAA\)ApA33AAθRAΏ\AQAΣAυA{AHA(AAΏ\A
ApȀ\AQẠAzAzA̸RA{A  A=qAA  A
AGA\)AA=qAQAAA\)AA(AAffAQApAHA=qAA
=AAA\)A=qA
A=qA(A\)A
A
A33AA(AA
A
ARA\)AGAAApAAHAHA(AA33AAffAzAApA  AAQA\)A(A  AQAA33AffA\AAApAGA
AAA=qAAǙA(AʸRA̸RA=qAffA\AAA\AAzAQAAGAA{AffAǅA
AAAAffAHARA
AAAQA  AApAď\A  AA=qAAAAAAffA\ApAAAA
A=qAAAGAHA\AzA\)AGA̸RAQAA33A{AzA\)Ȁ\A(ẠA{AAzA£AˮAǙAÅAÅA
AɮAGAAυAAɮAʏ\Ȁ\AffAHA{A
AffAΣA
=ApA(AQAGAУAA(ApAffAA
AңAٙAzAAA֏\AGA33A(A33AAQA
Aԏ\AAӅAӮAӅA\)A  AAAυAHA\)AͅȀ\A  AA˅AʣA  Ȁ\AθRAAQAAffA\)AӮAGAHAAHAиRA(AGAGA
=A
=AͮAљAҏ\AA
AHA
=AΣA{AAAԸRA(AA\)A  A(AApA
=ApApA  A  A(AA  AzA֣A
AAHAAۙAGA
ARA
=AA߮A\AAߙAޣAGApA
AݙA(ApA
A݅A=qAAHAzAA
ApA  A{ApAAzA33AA
=AхAϙA\)AͮẠAљAٙAAHAAApA(AAGA
=AڣA
Aڏ\AAffA  AծAAAңApAظRAA{AA\)A\)AA{AA
=A
A֏\AQAffA؏\AA33AңAA{AA  A
AGA(A{AAffAApAffA\)A\A\A{ApA(A=qAQA  ApA
=A  AGA\AA\A{AQAGA33AAA
=AAA
AA{ARAzAAܸRA\)AڣA
A=qAffA  AϮA33ApA͙AzA\)AУA{AQAΣAәAQAAׅA֏\AٮAffAQAHAA{AAљAљApAApAУAẠA{AApA
=AθRAԸRAGA(AHAAQAՙAҏ\AffA  AA33AzAA{AׅAمA؏\Aڏ\A=qAHA\)AA{A(A޸RAA(AffAzA=qA{AzAffAzA=qA܏\AzA{AGApAܣApAffAAAٮA  AA=qAңAՙApA
=AA33AGAAQAӮAHA(A{A\)AffAәA(A֏\A{A؏\AQAA=qAУAиRAHAAHA\)ApAAzAͮAGAAΏ\A(AzA33A
A
A33AGA33AQAzA
AHAzAУAA
=AѮA\)Aҏ\AQA  A=qAA(A
=AQAۅA\)AA
=A
=A33ApAGAHA
=A33AڣAGA33A
=AܣAHAHAA݅ApA\)AzAffAAffA\)AӅA(AAA
=AHAA  AңAGAA  A33AиRA33AGA{ApA{A=qAQA\)A  AAQAA\)AQA{AHAGAHA{AθRA{A
=A\)AˮAA(AӅA33A=qAAHA
=AхAzA{A(AffAffA̸RAffA
AиRA{AՅApAAGAA(AA\)AQA33AӮAAAՅAQA\)A{AHAAAffAA  A33AיAA  A  A(AA
=AffAQA(AffApA\)AظRAծAzAAҸRA33A{AۮAffAAHAffAAڏ\AAQA{A  A33AA
A{A{A33AQAGA  AљAQAAΏ\AA\)A=qAHẠA
=AʸRẠAzA
=A˙A˅ApẠA֣AԣA33AظRAָRA=qAGAAAA\)AAA(ApAՅApAGAA֏\AAָRAأAAڏ\AAzAڏ\A(AܣAAA
=A33AۮA
=A׮A֏\A(AHA֣AA޸RApAA=qAAA  AAظRA  AׅAAQAGA\)AAיAծAA
Aҏ\AffAӅAЏ\AzApAиRA\)AQA  A{AθRAAHA
=A(AυA
A33A33AAzAϙAΏ\AQA
AAϮAffA\)AϮAУA
=AθRA{A{A\)AǅA(AAAȸRAAŮAď\A
=A
=A{AQAȏ\AAңA=qAffA\)A  AAffA
=A
AAHApA  A{ApA33AAיAٮAA{AۅAGAGA33AA  AۅA(A
AAA
AQAA  A  A
A\)A
=A33AA
=A=qAՙA֣A33Aԏ\AA=qAQAGAGAQAиRAQAѮAиRA33A\)AA\)A
AA{AHAҏ\AQAЏ\AzAхA
=AGAΏ\A33AΣAAΣA
=AAHA
=AffAGȀ\AGA=qA̸RAffAΣAffAΏ\AυApAffA
AЏ\AHA
AApAԸRAׅA{AzAA{A{AffA{AأApAٮAQAڸRA
=AA{A  A=qAAݮAAAAHAܸRA\)ApA33AHAAGA
=A\)AffA
=A
=A33A(A
=AיAיAGAՙAָRAAA
=A=qApAՅAHAA
=AAA֣AՙApA
=A=qAͅAQAAAHAAͅA=qAGA33AυA\)AGApA(A=qAA͙AGAͅAAУAΣApAAхAΏ\AΏ\AΣA{AA
AAA׮A{AأAمA  A
=AمA{AGAٙA܏\ApAQA
AܸRAGAGAޣA
=A
=A߮ApApAARA
A(AޣApA  AݮAAݙA(AAA=qAAAA(AHA33AAHAA׮AA
=AٙAApAAzAAQAAԏ\AҸRAҸRAzAAѮAңAָRAԣAAzA  A33AԸRAAQAʸRA(AAڣA33AA(A(AA33AQApAffA
AffA\)AۅA܏\AمA
=A  Aޏ\AA
=AQAApAHA=qAApAظRAمA
Aԏ\AՅAQAApAڣApAۙAA  A(A
AAA  A{A(A{AQAQAܣA\)A  A(AAۙA
=AHA  AGAA(ApAڸRAA  AGA
AGAظRAԸRAGAAٙA
A(A
=ApA  AۮA{AٮAGAAzAAׅAAAHA33A؏\A׮AQA  AHAAzAׅA؏\AQAGA{AׅAQAHA\)AHAՙAA
=AיAHAՅAԣAՅApAӮAHAzA{AԣAffA(AApA\)A  AA(AϮA(AHAӅAQAA(AӮAApA33A֣A
AAHApApA  AGA{ApAAAӮA
AAѮA  AAGAәA33AApAQA=qAzAA֣A=qAGAA
=AA=qA  AzAQAGAՙAԸRA\)AA֣AAAHAA  AAAA=qAQA
A
=A(AA{A{A֣AAGA(AҸRA33AљA33A=qA=qAAԸRA
A
=AϙAQA=qAϮAΏ\AQAAAGA  AиRAAQAAA  A
=AffAAGAGAЏ\AQAAHAٙA(AAיAծAGAӮAәAQA=qA(A=qAAՙAAffA֣A֏\AGAAA=qAڏ\AHApA{A  AۅA{A
=AffAAۮAAAٮAAיAAڸRA
AHAAAHA{A
AffA{AQAGA{AAAAAمAڣA=qAAٙAA
=ApAQA(A
=A
=A(AڸRA(AApAzAA(AA
=A
AңAәA(AQAffApA
=A=qA  AHA  A֣AٙAڸRA{A
AGAzA{AAAA33A׮ApAAՅAָRA׮A(A33A33A(AAQAffA33AݮAffApA߮A33A  AA=qAAᙚAAzA{AAA(AAAݮA  AᙚAAQAA\AzAQA
=Aޏ\AARAHA
A  A߅A߮A
=AzAݙAHAffAA
A(AHA(AA֣A\)ApAzAA=qAffAAAAGAޏ\A\)AAGApA
=AHAHA\)AGA{AzAAHAAffAGA\)A\)A  AGA33ApA{A
A؏\A
AHA  A33A{AޣA\)AA{A  AzAzAARARAffAA
A(A=qAAGAAAQAQAA(AQAHAHAAAARAzA\AffA=qAzA=qA(A(AA\)A޸RAGAffAQA=qAQAܣA܏\AAAۙAQAQAޏ\AAzAQAAA{Aڏ\AGA33AGA
=A
AA=qAԣAAәA(A
AظRAQAzA\)A
AՅA
=ApA(AHAGAۙAQA܏\A
=A܏\A܏\AffA=qAzA\)AA{AzAHApA߮A߮A߮A߅A߮AAHApA{AA  AzA33AA  AQAۮA33AffA
A\)A
=AAA޸RAAAQAHAAzA݅A33AGAGAHA݅A݅AܸRAܸRA
=A33AA33AGAAA\)AݮAHA֏\AGAׅAAٮAAGA߅ApAAՅA
=AA{AQAzAQA
=AAԸRAAܸRA=qApA(AffA
=ApAzAffAڏ\AzA(AQA33AffA֣AAHA33AffA
A  AأApA{A
AAffAzA=qA=qA
=AzAffA33A33A
=AAظRAAA  A؏\A
=AڣAڏ\AAٙA
AۙAA
=AAۙA  A=qAQAAffA(A(AzAٮAHA\)AQAzAظRA=qA؏\AظRApA33AffA{A{A
AԣAԏ\AAQA
=AծA֣AיAׅA׮AׅA(ApAAffAGA(A
ApAAAAظRAA33AAԣAAA33A؏\AzAۮAQAڏ\AA=qAQA  A{AA\)A33AApAAzAAָRAApAA\)A׮A  A  A=qAQAffA33AظRAGAAڣAۮAAڣAA=qAzAQAأAA33A{AٙAٮAمAAA\)ApAAۮA
A(A33AA\)AGA
=A{AA
A
=AzA=qAA׮A
A{A
Aڏ\A
=A
Aԏ\AzA(AA\)AzAиRAffAAAA=qA
AӮAӮAAAzAAGA=qAЏ\AңA
A\)AңA  AA  AՅAQAمA  A=qA(AٙA33AQA33AָRApAԸRAAAQA\)AA(AAA
=AָRA֣A֣A  AAA
=A  AQAAHAAQAA
=A
A׮A
=A{AٮApAٙA\)A  AQAAGA\)AAAHAمA{AzA(A(AՙA(A
=A
AծA(ApA=qAظRAظRA{AA׮A֣AָRAAAffAA\)AApA
=AA33ApA  A
=A33A֏\AzA\)AA׮ApAzA{AGAAA֣AApA  A(AأAٙAأAA
=AffAٙAAGA33AAA  A(A
=AzAڏ\AڸRAA
=A  AGA{AGAzAڣAQA{AGA\)AمApA33A؏\AGA{A
=AAظRA
AzAׅAA֏\A=qAAծAHAAAA֏\AՅAAAхA  AҸRAӅAffAAGAָRA\)AمAffAffAׅAӅAffApAQAA
=A(AzAQAׅAffAHA֏\AA\)AQAӮAAGAHA׮AzAAٮAٙA
AڸRAۅAۙA  A{AffA݅A(A{AݙAGAA33AܸRAHA(AۙA\)AA{A=qAffAۙA  AAA{AApAGAܸRAܣAܸRA܏\AܣAzAAݮAQA
=A
=AAffApAffA߅AzAHAAAAAۮAܸRAAݮAۅAHA33A؏\AAHAAAܣAA  A  A\)A݅A\)A=qAAffAAޏ\A؏\A(A
=AٙA(A33ApA33A(A(A׮A
=AApAٮAٙA
AܣA
AA{A\)AܸRAGA\)A
AAQAA  A=qAGAffA  A߮AAAߙAA
AAߙAffApAHA33ApAA{A  AQAzAA\)A33A
=AHAARARAQA\)ApA33ApA\)AᙚA
=AQAܣAݙAA(AffAAffAzAA߅ApA  AAffAQAQAAffARARAQAQAޣA(A
AffAA
=AGAzA33A(AffA  A  AᙚAᙚA(A{A
A  AAA߮A  AA  A=qARA
=AAA  ARA
=ApA
AA
A噚AAzA33AA
=AAHApAQApA
=ApAAA
=A\A\)AffA(AA\)A  AHAޏ\AzA݅AAzA
=AzARAAA\)AAAzA߮AAApA(AA33AAGAA  ApA{A=qA{AA\AzA
A\)AݙA=qA\)AffApAA33A(AᙚARAA
A
A
A
AzA(AffA{AA݅A(A(A\)AޣAAHA  AQAGAApAzAzAffAQAAffAAA
=AAARAQA{A\A
AAA
A
AA33ApA\ARA{A
AARAA\A33AAA\AAffAQA߅AAAffAAA
=A=qA  A\A33A\)ARA\AAAApApA\)AA(AffA\ARA{A
=AAHA33AQA(A33AHAQA܏\AHAzAAAA  AݙAAA(AzAߙA߮ARAAAAzAA
=A
=ApAHARA{A{AQAffA
AAQAA\)A\)A㙚AAHAARAAzA  A
A=qAApA33A\AHAAAAAAffA(A(AAᙚAGAHAAzAzA
=A=qAAᙚAffAA{AAzAAAA
=A=qAffA
=AA
=A噚AffA=qAAffA33A噚AA
=A\)ApA=qAۙA޸RA  A
A  AGA\)AA33AA݅A(A  A݅A\)A
A޸RAA
A33A{AHAᙚAzAHAAAAAAAAAGApA33AGAAᙚAᙚAHAGApA33A\A  AzAQAA  A=qAffAAᙚAARA
=A(A㙚AAGA33AA33AأA
AGA\)A(A
=AߙAAzA݅AQA(AGAffAAܸRAޏ\A=qAڸRAzA
=A33ApAݮAHAffA  AܣAA(A(AܣAܣAݮAݮA(A߅A޸RA{ApA߮AA33A\)A33A߅A=qAA
=AAAA
=A33AA\A
A
=A  A{AzAAAA㙚A
=A(A\)AAAA33AAA=qA  AA\AAᙚAAApAGAGAAzA{AݙAݙAffAAzAGAAAAAA  A33AzA\)AHA=qAHAۮA{Aڏ\AڸRAAAڸRAۅAA\)A33A
=ApAQAQAHAA݅AzAGAA(A\A33AAA
AAAݮAݙA(AzAݙA
A{AHAHAޣA޸RApAAAA߮A33AGAA
=AHA
=A33A
=AAAAAHAHAޣAޣA݅AݙAAAAHAܸRAzAܣAݙAAA{AA݅A=qA\)A=qAGAQA
AzAAAzAffAܣAGAffAQAڣAAAQAظRA=qAظRAApA\)A
=AAۙAۅAffAڣAٮA(A=qA{AQAAݮA(AQA{A(AۮApAۙA{AApA\)AA{A
A(AڣA33A  AzAApA݅A  AzA޸RAHAޏ\Aޏ\AApApApAAzAzA{A޸RA
AAAHAffAܣAAHAHAܸRA(AHAGA\)A݅A݅A݅A݅A݅AݙAݙA݅A݅A݅AݙAݙAAݙAݮA33A33AQAAA
A݅AܸRAHAHAzAܸRA
=A
=AAڣA݅AۙAzAׅA(AAA33AHAՙA(A{AHA(A33Aڏ\A
=A\)AAzA33AA
AٙAGAA
=AzAQA؏\AGApAffAAA
AHAٙA(AAۅAffAܣAܣA{AQAzAAGA  AڸRA  AQA(A
A
=AAܣAHAHAܣAܸRAHAA
=A33AzAA(AۙAA
=A{A  A=qA׮ApAAffA
=AۅA  AHA\)A=qAffA33A\)A(A\)AٮA  AAأAGAԏ\AԸRA
AAA֣AffAHApAQAQA33A\)AAAڣApAffAQAٙA  A(A(A(AA(A  AAzA33ApA=qA
=A
=ApAAffA=qAA(Aޏ\AޣAAAA߅AA=qAHAGA33AQA(A\A=qA=qA33A33AAAHAA݅A
AzA
=A\)AۅAA33AAAHA{AۮA
AQAAܸRAzAAܸRA33AٮAظRAAA{A  AݮAAܸRA{AQAمApAٙAA
=AA
=AGA\)AAAGA33AzAffAAA
AGA݅AffA=qApAffA
AAAHAffAQAGA33AQAA\)AA=qA
=AffAzA޸RAHA33A߅A{A{AA߮A{ARARA
=ARA\)AQA
A{A\)A߅A߅A߅A߅AGApA߮A߮AGAHAޏ\AAA߅A
=AA
=AAݮApAAGA{AܣA33AffAQA  A
A
AzAۅAٙA(AAAGA
AڣAffA(AQAQA(AffAڣAzAffApAAGA33ApA\)A\)AAA֣AԣAA\)AA  ApAA
ApAA  A
AHApAA(AܣAAA{AffAffAffAzAޏ\A޸RA޸RA=qA߅AHA߮AffAGAQAݮA
AA݅A{AޣA{AAA  AGAA
A  AݮA\)AAGA\)AHA\)A{A(AA33A=qA߅A߅ApAߙA\)AߙA߅AA\)A\)AffA\)A{A33A33A݅AݮAܣAA\)AHAظRAAAGAޣA33A=qA{A  AffAQA=qAQA=qAGAGAՅAׅA(AQA(A(AAGAٮAQAHAAۙAAGAGA  AAQAGA{AA
=ApA\)AGAA\A
=A\AQAA=qAAA\A(AApAHA޸RA߮A߅AGAGAޣA
AffAQAAA
A=qAzA(A\)A܏\AQAܣAQAQAApApAڣAڣAۅAA{AٙAڸRAGApA\)AۙAGAڣAAA
=AAA
ApA33ApApAAA\)A  AGAۅA33AڣAڏ\AܸRAAޏ\AQAGAHAzA݅A݅A\)A݅Aڏ\A
=AAA޸RAffAHAߙAffAApA
=A=qAAA
ARA=qAᙚA
=A33A
=AHAffAAffA\AffAQAGA{AGAzA߮A{ApAApAܣA=qAڸRA=qAٙA  A{A=qAAۙA=qAffAzAڣAڣAڏ\AA=qAٮA
A
AQAzAٙAAأAיAGAAAٙAٮAٙAAAAQA
=ApAA  A(AAQA(Aڏ\AffAffAڸRA33AۙAAAffAAۮAڣApAAAffAمA
AQAAffAffAڏ\AڣAڏ\Aڏ\AڣAHA33A33AۅAAGA=qA
Aڏ\AQA\)AffAAQAAۅAGA\)AAGAGAffAA  AAffAHA
AA
=AأAHAAffAA33A  Aڏ\A33AمA(AمA(AAAA(AAffA{AمApA  A
=AQAzAڸRAAzA  AHAzA֏\A33AA33AHAأAAzA{AzA
AHAAAAA{A\)AzAAQAAAAQA  AA{AA
=A  AA  AAܸRAܸRAAۙAܸRA=qAA=qAAQA33A33A(AڸRA\)A
A
=Aڏ\Aڏ\AڸRAڣA(AڣAظRAQA\)A\)AA33AzApAمAٙAٙA33AzAAA׮A  A33AAA33AAԏ\AՙA  AQAծA  AәAҏ\AԣAGA{AԣA
AzAљA֣AQAAA{A33AԸRAAA33A=qAGA=qAAՅA(A
=A=qA  AAAffAٮAۙAAA\)AڸRAAzAAGA
=AݙAޣAޣAffAA
A
AGAA{AffA
AApAAڸRA
=A  AٙAAA
AٙAمAٙAمAمAGAGAHA
=AأAHAAأA؏\AzAׅA{A(A؏\AGAAAffApA=qA
=A33A  AA֣A֏\AָRA\)A{A  A֏\A׮A  ApAGA33AffA
AՅAأA
AظRAAA33AGAAA=qAQAӅAԣA{AәAAGAGAAHAQAՙAӮA{Aԏ\AAAAծAAzAffA
=AA=qA\)AffAԸRA=qAffAָRAA\)AzA\)AAGApAAծAՙA׮AQA(A׮AׅA=qA33A
=AAzA\)AAA  A\)A
A
=AA׮A׮A  A=qAzA
AffAҏ\A{AGAAA  AA\)AQApAA=qAA33AGA  AׅAA֏\A\)A33A
AffAGAأAGAGA\)A{AQAHAӮA
=AA֣AzAָRAAAGA=qAָRA
A33A
=A(A{AظRAAAٙA{A{A=qA
=AQAׅA
AApAָRAA(AڸRAٮAQA\)AAApAأAHAHAQAGA33ApAA؏\AٮApAAٙAApAٙAAمA\)AHAzA{AA֏\A\)A֏\ApAffA׮A  AQApAA
=A{A=qAڣAHAA\)AAՅAA33ApAApA{AQAA33A{A(A
=AظRA33AffA(A
=A33ApAۙAAQA  AA؏\AffAQA֣A
A33A33ApAAԣAA33A
=A=qA
AQA{A
=AffA{A\)A
=A  A֣AzA(AA
=Aԏ\A33ApA33AAAA=qA{A
=AمA(AAمA؏\AGAׅA33A֏\AzAAffA
A\)AָRA֏\A\)AAQA(A
AӅAAҏ\ApA=qA
=AәAA{A33AzA\)ApApAAA  A
=AA{AffA{AHA֏\A  AׅAAA׮AAָRAA{A\)A33A
=A=qA֏\AՙA
A  AAzAָRAAA33A
=A
=A
=AHA  AA
AA  A\)AHAQAAҸRAQAԏ\AffApAzA\)A
A
ApAٮAA؏\AQApAٮAGAApAAAA33AAAָRA=qA{A{A  AׅA֏\A
=AA\)ApAA  AApAңA=qAzA33AиRAϙA\)A\)A
AəAA(AAHAQAӅAHAzAzAAٙA(AQAffAڏ\AڣAڣAڏ\AQAGAAׅA\)A{AׅA
A
=AQAApAQA֏\ApA33AA׮A  A  A
AAٙAzA  AAGApAۅA=qAzA(AיA׮A׮A=qAAأAأAAA\)A\)AGAأAׅAHA
=Aԏ\AA(AԸRAAHAA(A33AAAHAЏ\Aҏ\AA(A33AffAQAffAGAϙA(AԣAՅAAGAљA
A=qAΣAәA=qAQA  AՅA{AָRA
A(AظRAAGAمApA{A\)A(AңA
=ApApA
=ApA=qAAGA\)A׮A=qAأAAHAAffAQAAHA(AأAAGAظRA
A=qAA=qA  A
=A33A\)A\)A  AzAffAڣAHAAHAمA  AٮA=qAڸRAffAHAڣA(AffA=qAffAA(A
AQA(AGAHAGAzA
A{A
A׮AAمAمAHA=qAԏ\A׮A  A\)AׅAAffAHA\)AffAA=qAA֣AzA
A
=A
=AGApAAA؏\A=qAzA֣AAԸRA֏\A׮A؏\AHA\)AAA  AQAzA(A  A(AظRAffAffAHA  A{A׮AQA=qAzAظRA؏\A׮AzApApA\)AGAGAAָRAAAAAQA(A(AAAzAծA{AAՙA(A=qA֣AָRAָRA
=A33AApAיA\)AGA\)ApAGAGAծAffA  AffApAGAzAGAAAA{AffAϮAQA
AAApApA33AAυA  A=qAҸRAA(A=qApA\)AHA֣AffAffAA33ApA{A=qAأAHAA{A{A33A=qA33AA
=AAQAffA=qAٮA  A  A=qAٙAGAAمAٮAיA=qAأAՙAffA֏\AӮA=qAHA
A(A؏\A{AGAHAHAHA33A֣AAAAA֏\A\)AzAָRAAQA(AظRA=qAQA
A
=AA33AA(AHAAA33AAA33A33A=qAAQAA(AθRAϮAAA
A(A(AӅAAffA
=AQA
A=qA
AѮA
A=qAҸRAңA
=AA33AәAԸRAAAA33A  AՙAָRAָRA=qA׮AظRA؏\AzA33AQAA33A(AffAAӅAҏ\AAffAAffAQA\)AA  Aԏ\AffAԣAAӅAԸRAffAӮAӮAӮAӅA  AҸRAAHAzAHAӮAzAAQAAzA
AՅApAAQAϙAңA
=A  A͙AHA  A33AΣA(AAffA
AzẠAAffAиRA(AzAЏ\AzA33AAzAӅAԏ\AӅAԸRAAAA{AAڣA=qAڣA
=A(AAܣAffA{AzAAAQAܸRAܣA{A  AAיAA
=AGA=qAA\)AAԣAAڏ\AAڏ\AڸRA
AQAzAمApAGA  AٮAأAApAGApA(A{AAA{AՙAԣA
AәAAA
Aҏ\AffAffA{A  AAиRA\)AGA=qAAAzA̸RA=qAәAAA
=A֏\A  AA{AAHAA{A  AA(A
=ApAԸRAԸRApApA{A{A  AA(A(A(A{A{A  A  AA{AApA  AzAծA  A=qAAԣA{AԸRAՅAAѮAԸRA\)A=qAυAQAA{AHAхAAУAQAA(AA33A
AՅAffA
A{AԣAAHA  A=qA  AHAzAffApAQAHAHA  A  AAA
A  AApAA=qAAGApAA{AGAGAΏ\A׮A
=AAA=qAңAAffAAffA
=A
=A  A{A؏\A  A{A{AA
=A33AA=qAzAAAAظRAظRAAظRA
=ApAAظRAAzAGAAԏ\ApAҏ\A{AzAиRAAAA
=AѮAffA\)AGApA{AϙA{AA33AҸRAAԏ\AA֣A=qAA\)A{AٮAHAzAA׮A؏\AծAAzAAՙAԸRAңAAAQApAҏ\AAAAҸRA\)AA
=A
=AAծAAQAAңA֏\AAԸRA
A(A؏\AأAQA{AAٮAzApA
=A
A׮AffA\)AA33AיAأAAAGA\)AQA
=AQA=qApA33AׅA33A֣AA\)AAAffA
A\)AzA{A֏\A(A
A=qA֣AAffAՙAӮA33AԣAzAQAAҏ\AA  ApA=qA(AAAGA
AffAzAzA=qAAӅAzAHAQAΣA\)AA33A=qA=qA  ApAΣAffA  AA͙A
=A  A(AиRAЏ\AυAѮA=qA  AѮAffAQAҸRAӮAA(AѮAУA33AzA=qAAAHApAAУAzAAУApA\)AAA\)AffAиRApAԸRAHA
A˙A  A͙AAAffA33AffAɮAA
=A33AʸRA\)AǙAǙAffAˮAffA(A̸RA
=AAHA̸RAA(AθRAA
=AAΏ\AAAAϙApAHAzA=qA{A=qA{A=qA(AHAzAϙAA  Aҏ\AGAHA33AׅAظRA(AA
=AffAzA{AA
=A\)AAәA33Aԏ\AѮAA=qAA{Aҏ\AA=qAУA{AθRA33AApA{ApAAѮAӮAzA
A׮AzAQA؏\AffAծAHAָRA(A{A
AHAAApAHA(Aԏ\A(A
AAAծAAGAәAzA33AzA͙AAQAApA֏\A
A{A
=A33A33AA
=A=qAAffAԣAGA33AHAffAAAffA33A
=A  A(AHAAAzA=qAAиRAAGAAHAٙAظRA
=A
AծAAAҸRA33AAGA33ApA33A
A=qAA  A(AQA33AA  AA=qA{AHAzAAApA
=AffA=qAAӅAA=qAAA(A=qAθRAϙA=qAA=qAAәAԣAѮA(A(A=qAхAAљAGA  A{AѮA
=A
ApAzA\)Aԏ\ApAA33ApAHA\)A(AAԣA\)A33A  A
=AHA
AQAׅAHA\)AffA{AԣApAҏ\AzAљA
=AУAA
AzA33AQAӮAҏ\ApA(AУAzAffA
AQA=qAAѮA{A=qAApA\)AGA\)AGApApA\)AӮAӅAA
A{AA{A  A(AԣAԸRAAAԸRAHAAAAQAzAQA\)A
=A֣A֏\AzAA33AA=qA(AAAzA(A\)AA=qA(AAAffApAԸRAzA  AA{A33A33AָRA=qA{AA  A  A{AָRAzAAA{A  A{AffAхAQAA
=A
=AAGAԣA
=AAԣAՅAAHAAAzA  AzAA=qAHAA=qAQAיA33AׅAׅAGAAAQAծAԏ\AGA\)A(AՙA֏\ApAיAzA(AGAzA33A\)AffAׅA=qA؏\A
=AHA
AظRA33AAمAمAGA
=AHAApAGAGApAՅAѮAҏ\AzAҏ\AυA\)AхAAAӅAҸRA
=AẠA
AGAAϙAGA
AљAA
AQA(AA33A  A\)AzA\)AQAGAAȏ\A=qAzA
=AAA{A
=ARAAzAAAA\)AGAAAA
ApAAApA33A{ApA33A(AAAAzA  AA
=AzA
=AQA
AGA  AAffAGA(A(A¸RAď\AŅAAŮAƏ\AAɮAAɅApAHAffA
AHA33AȸRAȏ\A  A{A{Aȏ\A
AGApA  A33A\)A=qAƏ\A=qAHA
=A33ẠA\)AȸRAȏ\A33AӅAҸRAApAAљA{AGAυAGA33AQAzAиRAAA  AffA(A
=A=qAA֣AffAΣAͮA{A{A
A  AffAAAGAAQAA=qAAҏ\A=qA33AQAԸRA{A33AQAҏ\A{AzA  AңA
A
=AхApA  A33A\)A
AиRAHAffAA̸RAA=qẠA  A\)AȀ\A  A33A(A\)A(AHA˅A̸RAͅA{A=qA\)AͅAͮAυApA
AffAffAՅAQAAHAffA(AA=qA(A=qAӮAԏ\A
A(AϙApA33A
=AAGA33ApA=qAQAAAָRAGAԣAQAzA\)ApA(A
A=qA  A=qAHA
ApA׮AHAHA{A  AffA(AծAAAծA
AՙAAՙAՙApAA=qA(AGApAHAAAAՅAңA  A  AzAAѮAHAиRA\)AӮAҏ\A\)AУAЏ\AA(A{AA=qA
AAAУA(AQAffA  AzAхAA(AΏ\AHApA(AGA
=AθRAθRA=qAHAGAAzAԸRA33A\)AzA33A{AGAAffAڏ\AAQA܏\A\)AAA
AA
=AzApA33AzAٙA  A=qAA  A{A
AAffA
=AAQAQA  A(A{A{A{A{A
AٮA
AٮAGAGA\)AHAHAظRA(AA
=A֣AA33AzAQAGAA
=AAәA
=AAQAffAHAҏ\AA
=A
A
=AAQApAffA  ApAAAAՙA\)AHAA33AծA  AA
A(AծAәAAҸRAәAzAAԏ\AHA33AGAGApAծA{AHAAA33A33AAԸRAHAAӅAԸRAԸRAA33AՙAA\)AAׅAAzAAA\)AGAGAָRA(AHAA=qAffA֏\A֏\AAAHAAԏ\AGAzA
AϙAңAӮApAA\)A=qA\)AGAzAAAzAffA\)AApA
AGAGAHApAGA
=AGAQA=qAAҸRA=qAzA  AffA33AӅA
=A
=A=qAՙAGAAAffAffAHAGA  A֣AיA(A=qA
=ApAۅA(AAمA(A=qA
=AHAQA(AAAٙAمApAٙAGAAٙAAٮAA؏\A؏\AAA33AA
AمAQA(A  AңAՙAA  AzAffAӮAAәAzAAAzA
A
AffAЏ\AHAQA33AGA=qAffApAԏ\AA\)AA{AAәAԸRAA
AApA֣AHA(A\)AzApAAAЏ\AAA{ApA=qAәAՙA  ApAAәA=qAAQAzAApAQA֏\A
=A\)A׮A  AffAظRAAAHA33AGAAظRAHAHAHA
=A33AظRAAA؏\A  AAA׮AffApAڣAAٮAڏ\AڸRAA=qAGA\)AمAHA
=AAzAٙA33AQA{AGA\)AңAҸRAԣAңA=qAQAѮAAәA
AGAԣAAAңAAAAA\)A
AҸRAApAϮA{A33A
AA
=ApA
A33A
=ApA{AAAٙA(AAAAffAGAHAAQA
AԸRAԣA{AQAGA
=A
A=qAApApA  A33A33AQA{AAՙA\)AծA
=AAQAԣAAծAQA(A(AffA{A(AAAծApAA33AѮA=qA\)AGAӅAQAAHA  AՅA\)AA  AAGA33AA  A{A{AA{AHAҸRAңAAծAAGAAԣA{AAA
=AAҏ\AAA{A(AӅAңAA
=A{AAԏ\AԸRA
A33AՅA{AA\)ApAQAיA  A{A{A(AׅA\)AHAffAAՙAՅAԸRAGAAAQAAQA{Aԏ\AzA\)AGAԣA33A
=A33AAAңAҏ\AѮAGAծAѮAApAzAӮA33AzA
AңAHAAAQA{ApAҸRAzAָRA  A
A\)AA33AхAңAQAA=qA
AAѮAA{A
=AңAAAAHAffAиRAQAGAԏ\A(AAӅAңAAѮA  A\)AхAApA33AӮAzAGA
=AffAA=qAHA\)A{AffAAAԸRA
AGApAGA=qA
=A=qApAGAծAzA֏\A33A33A
=AzAQA
=AA{A  AzApAAA
AՅAHA{AAAAхA{A֏\A֏\A{ApA֏\A֣AGAיAָRAAA{AGAzAApAQAAԸRA  AA\)A33AңA=qAA  A\)A
=AAGAЏ\AzAQA33A33A(AA̸RA\)AQAHApAAApAQAA33AӮAffA{AQA  AԣApAQAAՙAיAffA\)A33AظRAzAQAأAأA(AיA(A
AمAظRAAθRA(AЏ\A
AA33A33AQA
A
AҸRAffA\)A=qA
A  AHAAQAHA
A
AAҏ\A
=A(AңAHAӮAA33A\)AffAAAЏ\A{AGA
A\)A
AffA
=AAQAffAAՙAӅAQA
Aҏ\AԸRA\)A  AffApA
=AAAѮAGAHAAԸRA{AA=qAΏ\AAGA(ApA(AҸRA\)A(AzAAzA  A˅AAʸRAʸRA{AAAAǅAǅAȸRAәA\)A  AzApAffAHAHAǙA\)AffA\)A˅A\)AͅA(A
=A
=A33AAA\)A{AAffAͅApA͙A
AQA˅A33AʣApA{A{A{A{AAȣA
A33Aȏ\AzA(AAǅAAHA33AƏ\ApA33AAHAȸRAɅAGAA\)A{AǮA
A(AAffAzAzAͅA
=A
=AGAA  Ȁ\Ȁ\AA\)A\)A
AΣAGApAA˙AzAHAΣA͙A
=AffA  AʸRAffA\)A  AzAHApAAHApAȏ\AA
Aʏ\A˅A˙AʣAʸRA\)AzAΏ\AAУAA(A\)A
=AGAΣAA  A\)A=qAAϮAGAAQApAAffA͙AΏ\A
ẠAˮAͮA
=A
A(AA33A=qAϙAϮAAθRAzA
=A=qAHA͙AAffA33AҸRAAzAGAQAAQA\)AAAA
=A׮AAׅAظRAׅAיA{A{A
A  AAظRAׅAffAA\)AHAָRAA(AיAGA  AA=qAAAGApAәAAzAAA  AѮApA  ApAУA33A=qAʣApAzAA  AAQAGA
A{A=qA(AA£A\AAAAAAHAzAAAffAAAAzA\)AHAA33AAAApA\)AzAAQAAzA
=A\A
AAAzAA£AAA(A(A£A  AAA=qAAApAƏ\AAAAzA\)AffAəA(A\)AA£AA\)AAAʣA\)ApAHAϙA̸RAQA˙AHAʏ\A33AffA
=A{A=qA=qAGA
AA=qAAȣA33A
A=qAffAHAAAAǙAʣA(AHA33AAHA
=A=qA£A33A
=A\)AA  AAQApAHAA\AQAQAA33ApA{A\)AAŮA\)A\)A(A
=AƣAHAHAĸRAffAģAAAAď\AAzA  AGA
=AAA¸RA  AîAGARAAHA
=AGAÙA\)AGAʏ\A=qAffAA{ApAȣApAAAHA
AffAAȀ\A{A\)AυAGAGAA33A\)AAffAɮA(AɅA{AȣA\)A=qA=qAAȏ\AƣAAHA(A\)A(AQAzAÅAAřA  A\)AA
=AffAzAĸRAAĸRApAřAǅA{A\)AHAǮApAƣA=qA  AAģA(A=qA{AQA33AHA
A=qAA
=A
AAĸRAď\AAAffAQAƣAAAƣAzA{A(A=qAGAAŮAzA(AffAHA\)AQAA{A
AffA
AA=qAA\)A33A\)A(AAA¸RAÅAHAĸRA  Aď\AAAƣAzAAď\AffA33A(AģAHAAA{AGA33A
AQAȏ\AzAA33AA(AAîAAA\)AffAAAAAA{A\)AffAAȏ\A(AzAA\)AʣA(Aʏ\Aʏ\AAA(ẠA33AͮA\)AA{A{Aď\ApAA{A{AAHAŮAřAzARA\A(ARAffA{A  AApAʸRA
A
AУApẠA(AGAA
=ApA\)A  A  A\)AυAHAAΣAAA{AzAA͙AϙAGAA
=A  AffA33A=qAAzAGAA
A  ApAAƣAA=qAA\)A{AəAHAA
=A=qAƏ\A
=AAQA=qA  A(A  A\)ApA\)AŮAŮAǅAGA  A˙A{A{A{AffAzAGAGAA\)A33AAθRA33AǮAƸRA  A=qAƸRAA\)A33AAAAGA(A33AиRApAΣA=qAAA  A=qAzA=qA
AΣAffAљAHAA{A=qAA\)A=qAAQAzAGA
=AQAθRA\)AAθRAffAͮA
AAʣAȣAGA
A(AHAAzAHA
=A\)A=qAңAAQA˙AGA\)A
=AʣA  AffApAŮAA  AǙAGAffAffAȏ\A
=AGApA
AʣAA˙A˙A33AAApAQA(A̸RAAυAθRAΏ\AA  A
AA33A\)AθRAffApAHAHAHAAAffAffAA33AA
=AθRAGAθRAΣAΏ\AͅA33AͅAffAQA
A
=AHApAffAʏ\A=qAʸRAHAQAʸRAˮA  A=qAA  A
A
=AGA˙A
=AA33A{AQA=qA
=AʣAɅA\)AAʣẠAApA(AͮA{A
=A{A=qAAA=qA
=ApApApAA  A=qAzAΏ\AA
=AAGAυApAAAA  A
AϮẠAAAzA  AAA(AAAљA
AAAУA{AffAӅAAҸRA(AffA˅A33A(AA(A  A͙A{A
=A=qA
Aʏ\AʸRApAA33AA
=AHA{A˅AˮA
AA33ApA
A͙AΏ\AzA33A  A\)AљA
=A˅A
AHA  A
A(AGAQȀ\A=qAʸRAAffAͅAΏ\AΏ\AHAHA33A
A̸RAAffAzA͙A\)AљAHAͮA=qAApApAЏ\AAGAAQAzAffApA͙AffA
=A̸RA(AAA̸RAzA̸RA\)A=qA(A(AAǙAɮAGAʸRAHApAzA  AQA=qAAQA(AȸRAA{AGA
AʸRȀ\A\)A(A
=AffA
AGA\)AAQA\)A(A\)AAAȏ\AȣA
=AA\)AHA33AAA=qA  AffȀ\A{AffAffAˮAApA
AAQAA{AQAzA\)A˅A33Aʏ\AɅA=qA
A  AApAɅAAʣAA{AˮAAɅAffA\)AͅAΣA=qAAAAA  Aʏ\AffA33AA  AͅApA=qAQAGAffAɮAȣAQAHA{AɮAHAǮAǙAHA33AGAȸRAǙA33AGAǅA=qAAA
AQA
=A͙A\)AAAQAɅAʣAɅAAʣAGAˮA̸RAAͅAA  A
=AApAA=qAͅAAffAHA33A͙AΏ\A͙ẠAA
=AHAAffAA(A{A\)AəAAΏ\A\)A\)AQAGAAA\)A
A=qAzAԣA
Aԏ\AԣA
AAңAҏ\A=qAzA\)A=qAHAHAA\)A(A{A33AA33AA33AϮAAΏ\AθRA\)AθRA\)AA
=AHAzAљA\)AffAљA
A\)A\)AQAffAffAAAңAffAzAиRAA  AQAQAAAzAЏ\AθRAϮAϮA=qAЏ\AУAQAυAͅAAHAA
=AхAGA
=AffAAHAҏ\AApA
=AAGAAҸRAffAԣAffAAӮA{A  AЏ\AѮA  AѮAA(AхAAAҏ\AGAA\)AAAҏ\AAхA  AffApAхA  A=qAυAхAAѮAЏ\A=qAffAA\)AQA=qAΏ\AzAΏ\ApAϮApA{AApA=qAAҸRA  A{AA
AA=qAGAA  AӅAԣAQApA{AA=qAzA33AAͅA  AAHApAQA
AzAHA(AHA
=AAAzAQAA=qAAffA33A(A\)AAA\)AAA\)AHAAAԏ\AApAffAAQAA{AӮA
AAҸRA{A
A
AхAхA33AGA
=AAAHA
AAҸRAҏ\AQAУAAϮAzA=qAApAA(AͮAzA33A
=A{AA  A
AAҸRA
=AHAAҏ\AAGApAAӮAzAхA\)A  A\)A=qAУA(AQA=qAљA=qAAљAHA
AHAffAAA33AA=qA{A=qAָRAQAzAָRA
=A\)AGA
=AA׮ApA֣A(A(A(A=qA(A  AծAA
AՙAAAAHA
AffAHApApAHA
A  A\)A(AQAAԏ\AՙAAzA=qA{ApAAApA{A
=AՙA(ApAGAAA  AԸRAHAQAAӅA33A
=A{AAHAffAQAѮAҏ\AQA
AѮA(AA  AңAHApAAA(AffAQAQA{A(AәAA33AGApAAA=qAHA
=AՅA
A\)AծA  A  AffA֣A
=AיA׮A\)AأAHAAQA(A
AQAָRAׅA
A׮A(AffAzA؏\AظRAAAAAAأAffAA֣AQA(A֏\AffA
AՙAQAAAAңAӅA
A=qAAffAԏ\Aԏ\A33A33AA{AHA33ApAՅA
A{AQA֣AAA33A=qAՙA{AԸRAAQA{AAԣAffA=qAҸRA(ApAӅAQA33A33A
AQAffAzAzAHAHAA33A
=A=qA(A׮AAAAׅAffA(A=qAٮAָRA
AGAՅA{AHAָRA
AHAԸRA{AՅAGA33A{AA
A=qA  A׮AיAׅAיA׮AA׮A\)ApAAGA33A֣AՅAхAAAGA׮AAAQA33AظRA(A؏\AHAظRAHAAApA  AHAzA
AA{A(AظRA33AQA{AأA  AHA=qAApA
=AHAԸRAA33A
=A֣AA
=A33A׮AQAQA=qA
AHAمA
=AQAQA
A
AיApAׅAAיAׅAAffAffA=qAffAA(AυA=qA\)AApAAHAAffAљApAffAAѮA
=AAffAυAApA33AϮA(AΏ\A\)AA\)AθRApAAυA(A  AˮAΣAzA  AffAA˙AʸRAHAApA  A̸RAApAˮAHA33A˅A˅A
AA
AˮApA\)A  A˙A\)A\)A\)A  A(A
A=qAQAffAA  AA
A=qAУAУAЏ\A(A\)AHAθRAΣAzA  A̸RAAHAAˮAzA{A
=A=qAAAAәAҏ\A33AӅAHAA33AԣA
=A  AҸRA33ApAљAQAAA  A  AAAϮAȣApAAǅA\)A
AGA
AA(A  AͮAA\)AAˮA  AΣA{AHA
ApAA̸RA
=AυA=qAљApAΏ\A33A{AffA˅A=qAffA33AA\)AzAQApAǙAGAʏ\AAӅAGAffA
=AѮAAQA  AAȸRA{AȣA(A
A
ApAAHAʸRAʣAˮAΏ\A\)AGA\)A
=AApAQAAQAљAҸRA=qA  ApA{AиRAHAA{A\)AAʣAAA  A
A33A(AAAÅAffApAAǮA(A(AGAA\)AĸRAHAģA  AffA
=A=qAȏ\AGAəẠAAʣA=qAŅAA  AA\)A£A  A(AŮA{AGA
AAAǮAǅAA
A33AA33A
=AAQAɮAHAA
A=qAHAAGAͮAAHAQA33AzAA
=A{AAẠA\)AHApA
=Aʏ\Aʏ\AQAQA̸RAA͙AzAAAHAУAAA=qA=qA(AAˮA\)AffA=qAGAΣA{A  ẠAˮAAA33AAʸRAHAAA(AAQAAQA=qAGAGA\)AHAAЏ\AAzAȀ\A33AͮAffAΣA  AΣAAAAA33AΣAA(AGAУAAΣA  A
A{AͮA\)AͅA(A
AAAͅAA̸RA\)A=qAȣAǙAǙAApApA  AGA˅Aʏ\AGAQA˅AGA  ApAAθRAУAGA  A
AУAAHAAѮA\)AAљAAHA{A=qA33AЏ\AAA(AGAθRAхA
=AzAQAA=qA  ẠAGAA33A\)A(A=qAΏ\A{AHAͮAˮAA\)A  A{AAAHAΣAHA=qApAAхA(A33A  AGAΏ\AͮA͙AͅAHA(AĸRAAřAŮA
AǮAQAAəAQA
ApAȸRAA33AA33A  AA  A\)Aʏ\AɮA̸RAAzA=qAGA
AffA{AAͅAAθRAQAAAffAЏ\A
AApA(Aʏ\AɅAɅA=qAffAGAAHA=qA\)AffApAzA
A=qAʸRAAHAˮAHAA  A33A{AA
=Aʏ\AGAAzA
AAиRAУAΏ\A\)AGAAͅAAͅAϙA
=A=qAGAzAA˅AffAA˙AAGAQA
Aʏ\AA\)AA  A
AAA  A=qAͅAApAЏ\AA33A
=AңAхA  AHAffA(A(AAGAA
AAHA(AϮAQAхAхAAGAљAAzAffA\)AңA
AA
=AθRAA=qApAAA{AθRAQAϙA=qAљApA  ApAAGApA33AQAAȸRAAffA͙AHAAQAAΣAʏ\AȀ\AAffA(A\)A˙A{AGAAʏ\A˅AA  AA\)AA\)AzAA
AffAzAׅAA33A33AQA33AzApA
AӅApAA(AHAAAAA\)A(AָRA\)AAָRAAQAԸRApA
=A  A=qA\)AծAծAՙApA\)ApA33AGAA(A{A
ApAHA{AA{AAzA33AA
A33AAAA
A{AиRA=qAAУAffAȀ\A
=A˙A33AffA{A\)AffAGA{A
=AѮAҸRAAΏ\AAHA
AAffAϙA33AA=qAA{A
AҸRAA
=A
AAҸRA(A(AzAAҸRAzAzAңAffA{A  AA
AϮAϙAAиRAиRAυA(A˙AQAAəA
Ȁ\A=qAzAΏ\ApAzAȣẠA˙AAθRA(AAA{A
=A
Aʏ\A=qAʏ\AHAzA
AȣA33AHAAffA33AɅAzAAA\)AAƸRAAˮAAAzA=qAA=qAĸRAĸRAŅApAHAÙAîAģAA\)A  AA33AǅAGA33AǙAffAƸRAAǅAA\)A{AzApAƣA
Aȏ\AAQAGA  A(AzAʸRAAAȸRAA33A
A  AffA\)AffA  AQAA(AƸRAȏ\A
A(AffA(A\)A(A  AAAˮA̸RAGAA
AAƸRAƣAQAA
AƣA33A(A\)A\)AAʣA33AɅA
=A
=AAȣAzAƸRA(AƏ\AƸRA\)A{AA{AzAffApAȸRA(AAAAffAA  AAzAǙAAAQAAAǅAA{A
AA(A\)AəAQAɅAȣA\)AƸRA33AA(A
=A{AÅAď\A\)A=qAQAǅA
AzAAĸRAAɅA  A
=AǮA
AzAAzApAGA
AApA=qAApAřAffA
AǅAAƣA33AŮA\)ApAQAģAÙAffAApA\AAQA{A33AGA{AAAzAffAGAAAffA  A(ApAÅA\)AƣAzA  ARA=qAÙA  A=qA
=AQAAHApA\)AA(AffAQAƣA33AƣAǅAǙA{AǮA(A=qAȣAzAȣA(AA
=AzAA33A=qAǙA33AAAƣAzAAAffAQA\)A\)ApA\)A33AA33Aȏ\AffA
=A33A
=AQAȏ\AAɅAA
A  A˙AʣAɮAGA=qA{Aď\AĸRAAQAffAHA=qApAffAģA  AzAzAA\)AGApApAÅA\)A=qAffAffA¸RAA33AA33A33AGA\)AGAGAGAÙAAAÅA
=A£AA=qA\)AAAA33A33AA
A
AAHARA
=ApA
=A=qAAģAQAď\AA
=AAĸRAA  AHA
=AffAA\)AQA  AAA{AzA\)AAGA
ApAzA
ARA{AAA(AîAHA\)AÙA\)AA  A
AARA=qARAAAAA{A(AA(AffA{AA\AHA  A  AAAAQA33A{AAzAAA
A(AAzA
=AAARAAQAAA
AAzAzA\AGAAffA\)AAA(AAAAA  AAAQA
AApAA33ApA  ARAA  AA  AÅAÅAHARA  AffApAAAHAA
=A(A{AQA{A  AffA33A
=AA{A33AQAGAQA  A\A=qAARAGA(ApARAA{AA\)A33A  A{ARAGAffAffAAQA33AA
=A33ApAA  A{A{AQARAARA\AffA{AA\AA{AffA(A(A{AGAAAAA\)AzARApA=qA\AA{A=qAzAQAQA\)AAA(AAffAA\)AHA  AAA  AzAAAQApAzA
=AzAffA¸RAzA
AA(AzA(AAAHAA(AAA\A33A=qAAAAA33A\)AQA  AA{A  AffAGA=qAA
A  AAQAA
=AA\)A  AzA
=ARAA  A
A  AffARARAzAzA=qAAAzAffA=qAzAffAffA\)A{AAA33AA£A
A¸RAAAHA\A(AApAA{AGAGAGARAAffA\AHA\AHAA
A
=Aď\AÙAGA\)AzA{AffAffA\AAîAAģAAģAHAAģA(A=qAffAĸRA  A
A  A=qA=qAffAAAffAzA\)A{AAAƏ\AA(AȸRA
=AA  AAGA
=ApAzAHApAˮAAAAAHAzAAAA(A
A
A
AɮAzAQAA
=AȸRAAȣA  AAA{A{AQAAˮA˅AffA=qA  AzAGAəAApA  A\)Aʏ\A\)A˙ApAA˙AzAȏ\AHA33A  AAA\)ApAffAQAƸRApAffA=qAHAQAffAAǮApAQA(AǮAǮA
A  A33AAŮA\)AAQA\)AȸRAA
=AAAʏ\A=qAəAʸRAA
AẠA̸RA
Ȁ\A(A=qẠA(AQA˅A˙A  AˮAAAAʏ\AffAzAʏ\Aʏ\AzAʸRAʸRAAA33AzAʣAzA=qA(AʸRAGA
AɅAȸRAAǙẠȀ\A(A  A\)AHAŮA=qA{A
AAQAʣAƣAAȣAɅAȸRA\)AɮA
ApA\)AəAGApApA\)AGAəAȸRAA
=AAAAȸRAAApA  AffAA33A
=AA
Ȁ\AHAϮAAA=qAzAGA(AA  AffA͙AAA  AAͅẠAAQAAͅȀ\AAA˅AzApA\)A˅AGA{AffA{AzAʣAQAAffA{AGA
AA  Aʏ\AʣA\)AGAGA{AzẠAffA  A˙AzȀ\ApAɮAQA(AQAGAQA
A{AŅA\)AǙA(AGAffAA=qAGAƏ\ApA
AĸRAŅA
AffAApAƏ\AApA\)A(AȣAffA\)AǙAAǙA(A
A  AƣAǅAGAzAAA  AzAŅAA\)A¸RA¸RAzA  AApAƣA  AQAzA\)AǅA33AAǮAGAGA
A
=A33AzAȏ\A{AGAA(Aʏ\A{AGAɮA\)A=qA=qA33A
AǮAzA\)A{ApAřAHAffAHAîAÙA(A
AƸRA
A
AQA
AɅA\)AAQAQAŅA\)A{A(A\)ApAAA=qA\)AˮA33AAAGA
=A
AřA\)AAzA(A{AAA  A
AģA
A
=A£A£AGApA
=AAffAQAAĸRAHAģAA33AAHAHAAQAApA33A
AîAA
=ApAAAA(AA33AÅAA{AQA=qAA{AAQAĸRA=qA33AHAîAÙAHAA  A{AA=qAzApAHAHA
=AA=qA{ARAAGAzAA\)AzAAApAAGApAffAAAAQAzARA\AzAď\AA=qA\)ApA  A(A{A(AA£A¸RA(ApA(AzAA
=A{A
A
AƏ\AƸRA
=AAA
=AGAA
=AAAzA  A  AAHA33A
=A(AA¸RA=qAA(A{A\)AAAǅA
A(AƏ\AǙAAGA=qAAzAAA\)A(AGAA  A  AîA33AģAÙAffA(AAA33AĸRAA(AffAģA(AQAA  A
ARA  AÙAÙA
A(A{AAAÅApAffAffA  AAAAARAHARA=qAĸRAŅAřA  A
A{A  AŮAA\)A(AA
AAAˮAA{A{ApAɮA=qApAAA̸RẠAGAəA(AzA̸RAʏ\ApAǮAAQA
=ApAɅAʸRAGAQAAȏ\AȣA
A
=A  AAAAffA33AΏ\AAA
=AAzA(AAAA  A(AǅA\)Aď\AŮA
AA
=AǙAAȏ\AApAQAA33AzAGA33ApAHApAAAď\A(AzA(A33AA
AA{AffA
=AAA
=AA{A=qA  AȀ\AQApAAzAHA=qA  AAA˅AAQA̸RAA̸RAA
=AffAHAA{AA33AʸRAʣAA(AHAɮAffA\)AA͙A\)A\)A\)AAƏ\AĸRAQAHAA=qAGA33A
=AɅA\)A33AÙAAHA\)A͙AAAA\)A\)AzAffA
=A
A\)AA=qA
=Aȏ\A˙A(A(AAffAɮAAəA
AffAəAƣA33AǮA
AA
AAHA33AGA˅AˮA
A(A=qAA
A
A\)A˅A33AAA=qAA
AHAAȀ\AẠAzAA  A33A=qA  AAffAAϮA{ApAɮAAzA
=AA  A\)AŮAģAAƸRA{A  AAȏ\AǅAŅAApA=qA{AǮA{AzAGA(AffA̸RA
=A
=AGẠAHAAƏ\AffAQAQAzA{AɮAȣAřAQA
=AAA=qA\)AAffA{A=qA=qAGA
A¸RA33A\)AǅAȏ\AGApA{AəAHA(A{A{AAAAɮApAApA\)A  AAGAAAffA33A=qẠApA{AzAAAA˙A
=AA
=ApAAAffAHAẠẠȀ\A(ApA˙A33AȣAʣA  AAA33A˅AAA͙AʣAAzAȏ\AHAHA˙AǙAAffA(AƏ\Aȏ\A33AAȣAA=qAȏ\AA=qA
=AGA(AzA
AAQAAəA
A
=A=qA=qA(Aȏ\A  A=qA{Aȏ\Aȏ\AȸRApAQAAAHA\)AHA{AffApAGApAˮAˮA{A  AQAQAǮAǮAffA\)AǅAAA33AAȣAGAQA33AffA{A
AAˮA˙A(AǮAAQA
=A33AƸRA
=AƸRAAGAAA  A
AəAGAzA(AQAƏ\AQA\)A=qAď\AÅA=qA\)A\)A33AģAzAQAffAƣAŮA  AAAGAřApAƸRA33A(AÙAA\AzA¸RAA¸RAQA
AA
=AAAGA
A\)AHAA\)AGA{AA  A
AApAzA{ARA  AA(A{A\)A
A\)AA33AA=qA(A\)AA{AQAHA33AřA33A
A
ApAApAA\)AAAA=qA
A(A
AffAzAffAAA\A=qA{AffA{A
=AAAzA\)AÅAģAřAď\AARA
=AApA
A(AAA(AzAGAQA\)AGAA=qAA(A(AAAA{AAAAffA=qA33A\AAA33AAAAGAAA(AAGARA  AQAAARA\AHAAA33AAAAzAA=qApA
=AQA\AGA
=ARA\)A  A(AA33A{AAA  AA
AAApAA
=AAA{ARA{A\)ApAA
=AAGAA33AA\A\)A=qAAHAAAzAA=qAQAA\)A33A\)A(AA33AQAA
AA\)AA
A(A\A\AAAAA33A  A(AffAHAA\A\)AffAGA
A(A\)A
=AA33ARAAA{AQAA\A33AAAQAAA£AffAQAîA\A
A  A£A(AQAAzAAAffA  A{AAAAffAA\)AzApA¸RA{AffAGAAA\AAAQAGA
=AHAA£A£AAQAƣAģAA(AģAA(AŮAAffAƏ\A=qApAƣAƏ\A33AǅAǙAǮA
A
AȸRAffA=qA
=A
A=qAȸRAȏ\AQAffA=qAȸRAA33AȸRAGApAAHAəAAǅAAGAzAǅAǙAŮAA  AGAȏ\A(A=qA
=AHAģAAHAŅA(A
A(AzAffA{AA33A=qAAAAHAA¸RARA
AGA  AQA=qAQA\)AHA=qAA33AQA{A=qApAəAŮAAď\AGApAAA=qAAAAA
A\AA
=AGAîAA{ApAffAÙAAAGAffA£AQAA
A{AAffA\)AÙAAŅA  A
AƸRA{AzAAzA  AffAQAffAƏ\A{AƣAHAffAƸRA
AǅAGAHAHAAHAA
A¸RA{AGA\)AÅA
ApA£A¸RAffA¸RAA
=A
=AAA33ApAAHA{A
AŅAA\A{A  A¸RA¸RAAģA\)AffAîA
A=qAď\AzAď\AHA\)AŮAQAƸRAAǙA
=A  A(AQAHAApA33AAzAGApAʣA=qA{A  AȸRA
=AǙApAƣA
=AzAAQApAAɮAʏ\AAʸRAffAffAffA{AɮAA(AAɅAȣAȏ\AGAǮA
A  A  A\)AAĸRAAĸRAQAÅA
A{A  A{A(AHAƣAHA\)A
=AA{A{A\)AAAǮAŮA33A  A\)AAȣAGA{AɅAAGA33AǮAApAAƏ\AA{A  A\)AHAQAffAffAîAzAŅAA
=AA  A  AƸRAǅA(Aȏ\AȣAzAzAȸRA  A(A=qA
=A\)AAzAAHAffAGAʏ\A(AA˙A˅AzA{A  A=qAAͅAzAAʸRA(AA  AAʏ\A(AAȣAʏ\AAɮAApAAAHAA  AzA{AffA{AǙAGAƸRAffAffA
=AffAƏ\AffA
AƣAƏ\A(AzA
A\)AAAʣA(AzAzAʣAffAəAAzA\)AȣAǮAffAA\)A\)A  A33AģA(AGA{AAɅAɅA33A\)A
=AHAȣAȏ\AAAHAA
=A  A
AǮAA
=AHAɅAA
=A(AffAGAAʣA(A
A=qAA  AzAffAQAAAɮApA  AɮAAHAəA=qA˅AffA
AzAQA
=AAffA  AGAHA  AƣAƸRA  AAď\AffAAHA{AGA=qAAAffAA\)ApA33AƏ\AAŅAŅAÅAHAÙA
ApAAAGAîA{Aď\AAAģAA
=AHAHAA33AŮAAŅAGAŮA{AƣA(AffAƏ\AƣAŮA
=AAǮAŮAəAɮA
=AAʸRApAffA
=AffA
=AģA¸RAHAĸRAffAzAAffAǅAAAGAAGAǮAǅAƣA\)AǮAzAHA
=ApAHAAzA(AAQAffA{A\)AřA33A(A\A
=AA=qAA\)AffA
=A(AîAQA{AA
=AHAĸRAAA=qAGA
=AA  A33A
AQAHA33AA{AƣAƣA{AGAřAffAQAAȏ\AǅAHA
=AGA33AHA\)AGAGAɮAʏ\AɮA  A{ApAQA=qA{AAffAA{AȣAAɅAzAʏ\ApAffAAǮA  AAʏ\AffAɮAɅAA
A\)Aȏ\AA(A=qAQAģAQA=qAAHAA{AǙAAʸRAHAʏ\AAGAGA  A=qAApAQA
=A  AģAʣAffAƏ\AAƸRAǙAAHAHA{AAƏ\AQAŅAQAƏ\AƣAzA(A33AHAAffAQA\)A{A(AAQAřA\)AQA{A  A
AŮAģAA(AGAď\A=qAîAApAQAAAA
ApA{A33A
=AAQAəAȣA=qA  AřAÅA(A(AAzA33A=qAA
A(A=qAģAģAAŅApA  AAGAAGAģA\)AQA
=AA\AAƏ\AƸRAGAÅA
AQA\)AHA{A  A=qA¸RAAzAAȸRAQA
AA  A=qAǅAAŮApAŮAGAGAQAzAffA(A(A{A(AffA  AA(AA\)A{AGAAQA{A{AffA=qA33A=qAřAřA{ApA  AȣAAȣAffAȣAHAAzAAffAǅAHA
=A33AApAA
=AzAƏ\ApAHA
=AAŮA\)AŅA
AA=qAQA  A(AQAQA=qAQAffA  A=qAzAA=qAHAGAAApApA(AA  A33A{A33A
A(A(AzA{AQA\A\AffAA\)A=qAAď\A{AGAffAHAGAGAřAŮA\)AŮApAAřA\)A\)A\)AA\)AGAǅA
=A
=AGAǅAA
A\)AǮA
=A{A\AȸRAAQAȣAȸRAA\)A(A33Aď\AA
AƏ\AffA
A=qA\)A
AAAA
=AŅA\)AAď\AAAď\AAǙAA
A33AHAA\)A¸RApA  A£Aď\AAA{ApAÅAAď\A{ApA\)AHAĸRAApA=qAffAzA{A=qAffAzAQAQAÙAAA33A
=AffA\)AHAʸRAQAffAA{AAzA{AɅAffAzAʏ\A{A\)A
=A\)Aȏ\Aȏ\AGAAɅAȸRAřAHAQA  AƣA\)A{A{AAɅAɮAȏ\AzA
A{A£AŮA\)AzAǮA\)A=qAAȸRAA(AApA{A
=A  AGAA
=AəA\)Aʏ\AǮAAɅAAA
=AzA{AəAʣAAʣAɮAA
=A\A\AAîAAffA\)AHAAffA£A\A
=A{AAzA
=A
=A
A
AzAAzA(AQAffA
=A(A  AA{A\A\AApA{A
AA\)A(AAA{A\AffAAAřAģAģA
=A{AƣA\)AHA  A
A=qAAAQARA(AA(ARAA\)AGA
=A\)AAA\)A\)AA33AA\)A33AffA33A\)A33AA=qA(A  AA
=A
AAzAAGAffAzA  A\)A\AzAA\)AAA
A{ApAAAzA  AARAAGAffAAAffAffAA\AA(A
AA\)AGAAQA  AA  AffAzA(A33AA\)A
AQA
=A(AGAffA  AffA\A\)AA\)ApA\)AAAzAAA33A  A\)A\)AQA33AA{A
=ARAA
=AAAAAA(A
=A=qARAQA
=A33ApA\AAGA(AffAHA\AAAA\ARA(A
A\AARAA
AA(AAAA  AAHAzAAzAAAAQA£AA
=ApAffAǮApApAǙAzA  AřA\)AAGAAAHAAAQA  AÅA£AA\AAHA\AGA¸RAAîAÅAÅA£A\)A
AzAÅAAQAAQA\)A£A
=A  AA{AAAAAAAA  AA\A33A{AAHAzAHA=qAA\A
=ApAAzAffAHA{AA(A
=AAď\AGAŮA=qAAǮA(AffAA33A\)AGAAGAA\)AƣA(AŮAAĸRAŅA=qAƣAAzApAAAGAAģA\)A
A
AǮAǙAGApAǅAǙAAzA  AřAAAŅAGAffAQA=qA
A\)AřA\)A
A\)AA=qAîAGA  A
AîA33A\AîAAď\A=qApA  AŅA33A\)AřA=qAÅA
=AA33A{AApA\)A(AA
=ARA(ARA\A                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                