CDF       
      
timeseries        obs   xE   station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:16:12Z http://pacioos.org
2022-11-15T19:16:12Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2016-01-01T00:00:00Z&time%3C2017-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2016-12-31T23:45:00Z   time_coverage_resolution      PT30M      time_coverage_start       2016-01-13T19:15:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      Aե   A      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      ( r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      ?   BR   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       5   salinity                   _ChunkSizes                
_FillValue        y    actual_range      Bz   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B           	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      ffDf   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       4   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      ID   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       
H   oxygen                     _ChunkSizes                
_FillValue        y    actual_range      >ffAZR   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       \   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range          C?ff   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       p   ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       {   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      ?   BR   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       \   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range               =   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	        temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	        temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     $   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     !e8   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     #FL   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     %'`   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     't   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     (   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     *ʜ   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     ,   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     .   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      Bz   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       0m   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range               2N   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     40    salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     6   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     7(   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     9<   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     ;P   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     =d   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     ?vx   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     AW   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     C8   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     E   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     F   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     H   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     J   salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     L   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      ffDf   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       N   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range               P`,   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     RA@   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     T"T   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Vh   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     W|   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     YŐ   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     [   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     ]   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     _h   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     aI   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     c*   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     e   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     f   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      ID   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       h0   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range               jD   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     lX   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     nql   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     pR   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     r3   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     t   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     u   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     w   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     y   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     {   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     }z   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     [    chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     <4   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      >ffAZR   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       H   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range               \   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     p   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	        
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     c   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     D   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     %   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	        
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	        
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     $   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     8   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     L   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range          C?ff   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       l`   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range               Mt   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     .   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	        oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	        oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     u    oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     V   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     7(   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     <   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     P   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     d   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       x   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                  	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     }   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     ^   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     ?   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	         	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	        	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	        	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     ȥ,   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     ʆ@   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     gT   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Hh   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     )|   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       Ѡ 
   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde      0   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    :p i Ap?  wqb_04  Aե   Aեn   AեO   Aե0   Aե   Aե   Aե   Aե   Aե   Aեv   AեW   Aե   Aե   Aե   Aե   Aե~   Aե_   Aե@   Aե!   Aե   Aե   Aե   Aե   Aե   AեH   AեӞ   Aե   Aե`   Aե   Aե   Aեڦ   Aեۇ   Aեh   AեI   Aե*   Aե   Aե   Aե   Aե   Aե   Aեp   AեQ   Aե2   Aե   Aե   Aե   Aե   Aե   Aեx   AեY   Aե:   Aե   Aե   Aե   Aե   Aե   Aե   Aեa   AեB   Aե#   Aե   Aե   Aե   Aե   Aե   Aեi   AեJ   Aե+   Aե   Aե   Aե   Aե   Aե   Aզ q   AզR   Aզ3   Aզ   Aզ   Aզ   Aզ   Aզ   Aզy   AզZ   Aզ	;   Aզ
   Aզ
   Aզ   Aզ   Aզ
   Aզ   Aզb   AզC   Aզ$   Aզ   Aզ   Aզ   Aզ   Aզ   Aզj   AզK   Aզ,   Aզ
   Aզ   Aզ   Aզ   Aզ   Aզr   AզS   Aզ4   Aզ    Aզ    Aզ!   Aզ"   Aզ(   Aզ)   Aզ,c   Aզ-D   Aզ.%   Aզ/   Aզ<5   Aզ=   Aզ=   Aզ>   Aզ?   Aզ@   AզA{   AզB\   AզC=   AզD   AզD   AզE   AզF   AզG   AզH   AզId   AզJE   AզK&   AզL   AզL   AզM   AզN   AզO   AզPl   AզR.   AզS   AզS   AզT   AզU   AզV   AզWt   AզXU   AզY6   AզZ   AզZ   Aզ\   Aզ]   Aզ^|   Aզ_]   Aզ`>   Aզa   Aզb    Aզb   Aզc   Aզd   Aզe   Aզfe   AզgF   Aզh'   Aզi   Aզi   Aզj   Aզk   Aզl   Aզmm   AզnN   Aզo/   Aզp   Aզp   Aզq   Aզr   Aզs   Aզtu   AզuV   Aզv7   Aզw   Aզw   Aզx   Aզy   Aզz   Aզ{}   AզO   Aզ0   Aզ   Aզ   Aզ   Aզ   Aզ   Aզv   AզW   Aզ8   Aզ   Aզ   Aզ   Aզ   Aզ   Aզ~   Aզ_   Aզ@   Aզ!   Aզ   Aզ   Aզ   Aզ   Aզ   Aզg   AզH   Aզ)   Aզ
   Aզ   Aզ   Aզ   Aզ   Aզo   AզP   Aզ1   Aզ   Aզ   Aզ   Aզ   Aզ   Aզw   AզX   Aզ9   Aզ   Aզ   Aզ   Aզ   Aզ   Aզ   Aզ`   AզA   Aզ"   Aզ   Aզ   Aզ   Aզ*   Aզ   Aզ   Aզ   Aզ®   AզÏ   Aզp   AզQ   Aզ2   Aզ   Aզ   Aզ   Aզɶ   Aզʗ   Aզx   AզY   Aզ:   Aզ   Aզ   Aզ   Aզо   Aզџ   AզҀ   Aզa   AզB   Aզ#   Aզ   Aզ   Aզ   Aզا   Aզو   Aզi   AզJ   Aզ+   Aզ   Aզ   Aզ   Aզ߯   Aզ   Aզq   AզR   Aզ3   Aզ   Aզ   Aզ   Aզ   Aզ   Aզy   AզZ   Aզ;   Aզ   Aզ   Aզ   Aզ   Aզ   Aզ   Aզb   AզC   Aզ$   Aզ   Aզ   Aզ   Aզ   Aզ   Aզj   AզK   Aզ,   Aզ
   Aզ   Aզ   Aզ   Aզ   Aզr   AզS   Aէ 4   Aէ   Aէ   Aէ   Aէ   Aէ   Aէz   Aէ[   Aէ<   Aէ   Aէ   Aէ	   Aէ
   Aէ   Aէ   Aէ
c   AէD   Aէ%   Aէ   Aէ   Aէ   Aէ   Aէ   Aէk   AէL   Aէ-   Aէ   Aէ   Aէ   Aէ   Aէ   Aէs   AէT   Aէ5   Aէ   Aէ   Aէ   Aէ    Aէ!   Aէ"{   Aէ#\   Aէ$=   Aէ%   Aէ%   Aէ&   Aէ'   Aէ(   Aէ)   Aէ*d   Aէ+E   Aէ,&   Aէ-   Aէ-   Aէ.   Aէ/   Aէ0   Aէ1l   AէB   AէD   AէE   AէJ   AէJ   AէK   AէM   AէNm   AէON   AէP/   AէQ   AէQ   AէR   AէS   AէT   AէUu   AէVV   AէW7   AէX   AէX   AէY   AէZ   Aէ[   Aէn   Aէp   Aէq   Aէu   Aէu   Aէv   Aէw   Aէx   Aէy~   Aէz_   Aէ{@   Aէ|!   Aէ}   Aէ}   Aէ~   Aէ   Aէ   Aէg   AէH   Aէ)   Aէ
   Aէ   Aէ   Aէ   Aէ   Aէo   AէP   Aէ1   Aէ   Aէ   Aէ   Aէ   Aէw   AէX   Aէ9   Aէ   Aէ   Aէ   Aէ   Aէ   Aէ   Aէ`   AէA   Aէ"   Aէ   Aէ   Aէ   Aէ   Aէ   Aէh   AէI   Aէ*   Aէ   Aէ   Aէ   Aէ   Aէ   Aէp   AէQ   Aէ2   Aէ   Aէ   Aէ   Aէ   Aէ   Aէx   AէY   Aէ:   Aէ   Aէ   Aէ   Aէ   Aէ   Aէ   Aէa   AէB   Aէ#   Aէ   Aէ   Aէ   Aէ   Aէ   Aէi   AէJ   Aէ+   Aէ   Aէ   Aէ   Aէ   Aէ   Aէq   AէR   Aէ3   Aէ   Aէ   Aէ   AէǷ   AէȘ   Aէy   AէZ   Aէ;   Aէ   Aէ   Aէ   Aէο   AէϠ   AէЁ   Aէb   AէC   Aէ$   Aէ   Aէ   Aէ   Aէ֨   Aէ׉   Aէj   AէK   Aէ,   Aէ
   Aէ   Aէ   Aէݰ   Aէޑ   Aէr   AէS   Aէ4   Aէ   Aէ   Aէ   Aէ   Aէ   Aէz   Aէ[   Aէ<   Aէ   Aէ   Aէ   Aէ   Aէ   Aէ   Aէc   AէD   Aէ%   Aէ   Aէ   Aէ   Aէ   Aէ   Aէk   AէL   Aէ-   Aէ   Aէ   Aէ   Aէ   Aէ   Aէs   AէT   Aէ5   Aէ   Aը   Aը   Aը   Aըt   AըU   Aը6   Aը   Aը   Aը   Aը   Aը   Aը |   Aը!]   Aը">   Aը#   Aը$    Aը$   Aը%   Aը&   Aը'   Aը(e   Aը)F   Aը*'   Aը+   Aը+   Aը,   Aը-   Aը.   Aը/m   Aը0N   Aը1/   Aը2   Aը3   Aը4   Aը5   Aը6u   Aը7V   Aը87   Aը9   Aը;   Aթ   Aթ)   Aթ=@   Aթ>!   AթRX   AթD   Aթ%   Aթ   AթT   Aթ   AժS   AժT   AժU   AժV   Aժeq   AժfR   Aժ   Aժ   Aժ0   Aժ   Aժ   Aժ   Aժ   Aժ   Aժv   AժW   Aժ8   Aժ   Aժ   Aժ   Aժ   Aժ   Aժ~   Aժ_   Aժ@   Aի !   Aի   Aի   Aի   Aի   Aի   Aիg   AիH   Aի)   Aի
   Aի   Aի	   Aի
   Aի   Aիo   Aի
P   Aի1   Aի   Aի   Aի   Aի   Aի   Aիw   AիX   Aի9   Aի   Aի   Aի   Aի   Aի   Aի   Aի`   AիA   Aի"   Aի   Aի   Aի   Aի    Aի!   Aի"h   Aի#I   Aի$*   Aի%   Aի&   Aի'   Aի*Q   Aի,   Aի/   Aի1Y   Aի8a   Aի;   AիJ   AիK   AիP   AիP   AիQ   AիR   AիS   AիT   AիW$   AիX   AիX   AիY   AիZ   Aի[   Aի\j   Aի]K   Aի^,   Aի_
   Aի_   Aի`   Aիa   Aիf   Aիf   Aիh   Aիq   Aիv   Aիw   Aի   AիU   Aի>   Aի   Aիȅ   Aիύ   Aիn   Aիմ   Aլx   Aլ3   Aլ@
   Aլ@   AլA   AլB   AլC   AլDr   AլES   AլF4   AլG   AլG   AլH   AլI   AլJ   AլKz   AլL[   AլM<   AլN   AլN   AլO   AլP   AլQ   AլR   AլSc   AլTD   AլU%   AլV   AլV   AլW   AլX   AլY   AլZk   Aլ[L   Aլ\-   Aլ]   Aլ]   Aլ^   Aլ_   Aլ`   Aլas   AլbT   Aլc5   Aլd   Aլd   Aլe   Aլf   Aլg   Aլh{   Aլi\   Aլj=   Aլk   Aլk   Aլl   Aլm   Aլn   Aլo   Aլpd   AլqE   Aլr&   Aլs   Aլs   Aլt   Aլu   Aլv   Aլwl   AլxM   Aլy.   Aլz   Aլz   Aլ{   Aլ|   Aլ}   Aլ~t   AլU   Aլ6   Aլ   Aլ   Aլ   Aլ   Aլ   Aլ|   Aլ]   Aլ>   Aլ   Aլ    Aլ   Aլ   Aլ   Aլ   Aլe   AլF   Aլ'   Aլ   Aլ   Aլ   Aլ   Aլ   Aլm   AլN   Aլ/   Aլ   Aլ   Aլ   Aլ   Aլ   Aլu   AլV   Aլ7   Aլ   Aլ   Aլ   Aլ   Aլ   Aլ}   Aլ^   Aլ?   Aլ    Aլ   Aլ   Aլ   Aլ   Aլ   Aլf   AլG   Aլ(   Aլ	   Aլ   Aլ   Aլ   Aլ   Aլn   AլO   Aլ0   Aլ   Aլ   Aլ   Aլ   Aլ   Aլv   AլW   Aլ8   Aլ   Aլ   Aլ   Aլ   Aլ   Aլ~   Aլ_   Aլ@   Aլ!   Aլ   Aլ   Aլ   Aլť   AլƆ   Aլg   AլH   Aլ)   Aլ
   Aլ   Aլ   Aլ̭   Aլ͎   Aլo   AլP   Aլ1   Aլ   Aլ   Aլ   Aլӵ   AլԖ   Aլw   AլX   Aլ9   Aլ   Aլ   Aլ   Aլڽ   Aլ۞   Aլ   Aլ`   AլA   Aլ"   Aլ   Aլ   Aլ   Aլ   Aլ   Aլh   AլI   Aլ*   Aլ   Aլ   Aլ   Aլ   Aլ   Aլp   AլQ   Aլ2   Aլ   Aլ   Aլ   Aլ   Aլ   Aլx   AլY   Aլ:   Aլ   Aլ   Aլ   Aլ   Aլ   Aլ   Aլa   AլB   Aլ#   Aլ   Aլ   Aլ   Aլ   Aխ    Aխi   AխJ   Aխ+   Aխ   Aխ   Aխ   Aխ   Aխ   Aխq   Aխ	R   Aխ
3   Aխ   Aխ   Aխ   Aխ
   Aխ   Aխy   AխZ   Aխ;   Aխ   Aխ   Aխ   Aխ   Aխ   Aխ   Aխb   AխC   Aխ$   Aխ   Aխ   Aխ   Aխ   Aխ   Aխj   AխK   Aխ ,   Aխ!
   Aխ!   Aխ"   Aխ#   Aխ$   Aխ%r   Aխ&S   Aխ'4   Aխ(   Aխ(   Aխ)   Aխ*   Aխ+   Aխ,z   Aխ-[   Aխ.<   Aխ/   Aխ/   Aխ0   Aխ1   Aխ2   Aխ3   Aխ4c   Aխ5D   Aխ6%   Aխ7   Aխ7   Aխ8   Aխ9   Aխ:   Aխ;k   Aխ<L   Aխ=-   Aխ>   Aխ>   Aխ?   Aխ@   AխA   AխBs   AխCT   AխD5   AխE   AխE   AխF   AխG   AխH   AխI{   AխJ\   AխK=   AխL   AխL   AխM   AխN   AխO   AխP   AխQd   AխRE   AխS&   AխT   AխT   AխU   AխV   AխW   AխXl   AխYM   AխZ.   Aխ[   Aխ[   Aխ\   Aխ]   Aխ^   Aխ_t   Aխ`U   Aխa6   Aխb   Aխb   Aխc   Aխd   Aխe   Aխf|   Aխg]   Aխh>   Aխi   Aխj    Aխj   Aխk   Aխl   Aխm   Aխne   AխoF   Aխp'   Aխq   Aխq   Aխr   Aխs   Aխt   Aխum   AխvN   Aխw/   Aխx   Aխx   Aխy   Aխz   Aխ{   Aխ|u   Aխ}V   Aխ~7   Aխ   Aխ   Aխ   Aխ   Aխ   Aխ}   Aխ^   Aխ?   Aխ    Aխ   Aխ   Aխ   Aխ   Aխ   Aխf   AխG   Aխ(   Aխ	   Aխ   Aխ   Aխ   Aխ   Aխn   AխO   Aխ0   Aխ   Aխ   Aխ   Aխ   Aխ   Aխv   AխW   Aխ8   Aխ   Aխ   Aխ   Aխ   Aխ   Aխ~   Aխ_   Aխ@   Aխ!   Aխ   Aխ   Aխ   Aխ   Aխ   Aխg   AխH   Aխ)   Aխ
   Aխ   Aխ   Aխ   Aխ   Aխo   AխP   Aխ1   Aխ   Aխ   Aխ   Aխ   Aխ   Aխw   AխX   Aխ9   Aխ   Aխ   Aխ   Aխ   Aխ   Aխ   Aխ`   AխA   Aխ"   Aխ   Aխ   Aխ   Aխæ   Aխć   Aխh   AխI   Aխ*   Aխ   Aխ   Aխ   Aխʮ   Aխˏ   Aխp   AխQ   Aխ2   Aխ   Aխ   Aխ   AխѶ   Aխҗ   Aխx   AխY   Aխ:   Aխ   Aխ   Aխ   Aխؾ   Aխٟ   Aխڀ   Aխa   AխB   Aխ#   Aխ   Aխ   Aխ   Aխ   Aխ   Aխi   AխJ   Aխ+   Aխ   Aխ   Aխ   Aխ   Aխ   Aխq   AխR   Aխ3   Aխ   Aխ   Aխ   Aխ   Aխ   Aխy   AխZ   Aխ;   Aխ   Aխ   Aխ   Aխ   Aխ   Aխ   Aխb   AխC   Aխ$   Aխ   Aխ   Aխ   Aխ   Aխ   Aխj   Aծ K   Aծ,   Aծ
   Aծ   Aծ   Aծ   Aծ   Aծr   AծS   Aծ4   Aծ	   Aծ	   Aծ
   Aծ   Aծ   Aծ
z   Aծ[   Aծ<   Aծ   Aծ   Aծ   Aծ   Aծ   Aծ   Aծc   AծD   Aծ%   Aծ   Aծ   Aծ   Aծ   Aծ   Aծk   AծL   Aծ-   Aծ   Aծ   Aծ    Aծ!   Aծ"   Aծ#s   Aծ$T   Aծ%5   Aծ&   Aծ&   Aծ'   Aծ(   Aծ)   Aծ*{   Aծ+\   Aծ,=   Aծ-   Aծ-   Aծ.   Aծ/   Aծ0   Aծ1   Aծ2d   Aծ3E   Aծ4&   Aծ5   Aծ5   Aծ6   Aծ7   Aծ8   Aծ9l   Aծ:M   Aծ;.   Aծ<   Aծ<   Aծ=   Aծ>   Aծ?   Aծ@t   AծAU   AծB6   AծC   AծC   AծD   AծE   AծF   AծG|   AծH]   AծI>   AծJ   AծK    AծK   AծL   AծM   AծN   AծOe   AծPF   AծQ'   AծR   AծR   AծS   AծT   AծU   AծVm   AծWN   AծX/   AծY   AծY   AծZ   Aծ[   Aծ\   Aծ]u   Aծ^V   Aծ_7   Aծ`   Aծ`   Aծa   Aծb   Aծc   Aծd}   Aծe^   Aծf?   Aծg    Aծh   Aծh   Aծi   Aծj   Aծk   Aծlf   AծmG   Aծn(   Aծo	   Aծo   Aծp   Aծq   Aծr   Aծsn   AծtO   Aծu0   Aծv   Aծv   Aծw   Aծx   Aծy   Aծzv   Aծ{W   Aծ|8   Aծ}   Aծ}   Aծ~   Aծ   Aծ   Aծ~   Aծ_   Aծ@   Aծ!   Aծ   Aծ   Aծ   Aծ   Aծ   Aծg   AծH   Aծ)   Aծ
   Aծ   Aծ   Aծ   Aծ   Aծo   AծP   Aծ1   Aծ   Aծ   Aծ   Aծ   Aծ   Aծw   AծX   Aծ9   Aծ   Aծ   Aծ   Aծ   Aծ   Aծ   Aծ`   AծA   Aծ"   Aծ   Aծ   Aծ   Aծ   Aծ   Aծh   AծI   Aծ*   Aծ   Aծ   Aծ   Aծ   Aծ   Aծp   AծQ   Aծ2   Aծ   Aծ   Aծ   Aծ   Aծ   Aծx   AծY   Aծ:   Aծ   Aծ   Aծ   Aծ   Aծ   Aծ   Aծa   AծB   Aծ#   Aծ   Aծ   Aծ   Aծ   Aծ   Aծi   AծJ   Aծ+   Aծ   Aծ   Aծ   Aծȯ   Aծɐ   Aծq   AծR   Aծ3   Aծ   Aծ   Aծ   AծϷ   AծИ   Aծy   AծZ   Aծ;   Aծ   Aծ   Aծ   Aծֿ   Aծנ   Aծ؁   Aծb   AծC   Aծ$   Aծ   Aծ   Aծ   Aծި   Aծ߉   Aծj   AծK   Aծ,   Aծ
   Aծ   Aծ   Aծ   Aծ   Aծr   AծS   Aծ4   Aծ   Aծ   Aծ   Aծ   Aծ   Aծz   Aծ[   Aծ<   Aծ   Aծ   Aծ   Aծ   Aծ   Aծ   Aծc   AծD   Aծ%   Aծ   Aծ   Aծ   Aծ   Aծ   Aծk   AծL   Aծ-   Aկ    Aկ    Aկ   Aկ   Aկ   Aկs   AկT   Aկ5   Aկ   Aկ   Aկ   Aկ	   Aկ
   Aկ{   Aկ\   Aկ
=   Aկ   Aկ   Aկ   Aկ   Aկ   Aկ   Aկd   AկE   Aկ&   Aկ   Aկ   Aկ   Aկ   Aկ   Aկl   AկM   Aկ.   Aկ   Aկ   Aկ   Aկ   Aկ    Aկ!t   Aկ"U   Aկ#6   Aկ$   Aկ$   Aկ%   Aկ&   Aկ'   Aկ(|   Aկ)]   Aկ*>   Aկ+   Aկ,    Aկ,   Aկ-   Aկ.   Aկ/   Aկ0e   Aկ1F   Aկ2'   Aկ3   Aկ3   Aկ4   Aկ5   Aկ6   Aկ7m   Aկ8N   Aկ9/   Aկ:   Aկ:   Aկ;   Aկ<   Aկ=   Aկ>u   Aկ?V   Aկ@7   AկA   AկA   AկB   AկC   AկD   AկE}   AկF^   AկG?   AկH    AկI   AկI   AկJ   AկK   AկL   AկMf   AկNG   AկO(   AկP	   AկP   AկQ   AկR   AկS   AկTn   AկUO   AկV0   AկW   AկW   AկX   AկY   AկZ   Aկ[v   Aկ\W   Aկ]8   Aկ^   Aկ^   Aկ_   Aկ`   Aկa   Aկb~   Aկc_   Aկd@   Aկe!   Aկf   Aկf   Aկg   Aկh   Aկi   Aկjg   AկkH   Aկl)   Aկm
   Aկm   Aկn   Aկo   Aկp   Aկqo   AկrP   Aկs1   Aկt   Aկt   Aկu   Aկv   Aկw   Aկxw   AկyX   Aկz9   Aկ{   Aկ{   Aկ|   Aկ}   Aկ~   Aկ   Aկ`   AկA   Aկ"   Aկ   Aկ   Aկ   Aկ   Aկ   Aկh   AկI   Aկ*   Aկ   Aկ   Aկ   Aկ   Aկ   Aկp   AկQ   Aկ2   Aկ   Aկ   Aկ   Aկ   Aկ   Aկx   AկY   Aկ:   Aկ   Aկ   Aկ   Aկ   Aկ   Aկ   Aկa   AկB   Aկ#   Aկ   Aկ   Aկ   Aկ   Aկ   Aկi   AկJ   Aկ+   Aկ   Aկ   Aկ   Aկ   Aկ   Aկq   AկR   Aկ3   Aկ   Aկ   Aկ   Aկ   Aկ   Aկy   AկZ   Aկ;   Aկ   Aկ   Aկ   Aկ   Aկ   Aկ   Aկb   AկC   Aկ$   Aկ   Aկ   Aկ   Aկ   Aկ   Aկj   AկK   Aկ,   Aկ
   Aկ   Aկ   Aկư   AկǑ   Aկr   AկS   Aկ4   Aկ   Aկ   Aկ   Aկ͸   AկΙ   Aկz   Aկ[   Aկ<   Aկ   Aկ   Aկ   Aկ   Aկա   Aկւ   Aկc   AկD   Aկ%   Aկ   Aկ   Aկ   Aկܩ   Aկ݊   Aկk   AկL   Aկ-   Aկ   Aկ   Aկ   Aկ   Aկ   Aկs   AկT   Aկ5   Aկ   Aկ   Aկ   Aկ   Aկ   Aկ{   Aկ\   Aկ=   Aկ   Aկ   Aկ   Aկ   Aկ   Aկ   Aկd   AկE   Aկ&   Aկ   Aկ   Aկ   Aկ   Aկ   Aկl   AկM   Aկ.   Aկ   Aկ   Aկ   Aհ    Aհ   Aհt   AհU   Aհ6   Aհ   Aհ   Aհ   Aհ   Aհ   Aհ	|   Aհ
]   Aհ>   Aհ   Aհ
    Aհ
   Aհ   Aհ   Aհ   Aհe   AհF   Aհ'   Aհ   Aհ   Aհ   Aհ   Aհ   Aհm   AհN   Aհ/   Aհ   Aհ   Aհ   Aհ   Aհ   Aհu   Aհ V   Aհ!7   Aհ"   Aհ"   Aհ#   Aհ$   Aհ%   Aհ&}   Aհ'^   Aհ(?   Aհ)    Aհ*   Aհ*   Aհ+   Aհ,   Aհ-   Aհ.f   Aհ/G   Aհ0(   Aհ1	   Aհ1   Aհ2   Aհ3   Aհ4   Aհ5n   Aհ6O   Aհ70   Aհ8   Aհ8   Aհ9   Aհ:   Aհ;   Aհ<v   Aհ=W   Aհ>8   Aհ?   Aհ?   Aհ@   AհA   AհB   AհC~   AհD_   AհE@   AհF!   AհG   AհG   AհH   AհI   AհJ   AհKg   AհLH   AհM)   AհN
   AհN   AհO   AհP   AհQ   AհRo   AհSP   AհT1   AհU   AհU   AհV   AհW   AհX   AհYw   AհZX   Aհ[9   Aհ\   Aհ\   Aհ]   Aհ^   Aհ_   Aհ`   Aհa`   AհbA   Aհc"   Aհd   Aհd   Aհe   Aհf   Aհg   Aհhh   AհiI   Aհj*   Aհk   Aհk   Aհl   Aհm   Aհn   Aհop   AհpQ   Aհq2   Aհr   Aհr   Aհs   Aհt   Aհu   Aհvx   AհwY   Aհx:   Aհy   Aհy   Aհz   Aհ{   Aհ|   Aհ}   Aհ~a   AհB   Aհ#   Aհ   Aհ   Aհ   Aհ   Aհ   Aհi   AհJ   Aհ+   Aհ   Aհ   Aհ   Aհ   Aհ   Aհq   AհR   Aհ3   Aհ   Aհ   Aհ   Aհ   Aհ   Aհy   AհZ   Aհ;   Aհ   Aհ   Aհ   Aհ   Aհ   Aհ   Aհb   AհC   Aհ$   Aհ   Aհ   Aհ   Aհ   Aհ   Aհj   AհK   Aհ,   Aհ
   Aհ   Aհ   Aհ   Aհ   Aհr   AհS   Aհ4   Aհ   Aհ   Aհ   Aհ   Aհ   Aհz   Aհ[   Aհ<   Aհ   Aհ   Aհ   Aհ   Aհ   Aհ   Aհc   AհD   Aհ%   Aհ   Aհ   Aհ   Aհ   Aհ   Aհk   AհL   Aհ-   Aհ   Aհ   Aհ   Aհı   AհŒ   Aհs   AհT   Aհ5   Aհ   Aհ   Aհ   Aհ˹   Aհ̚   Aհ{   Aհ\   Aհ=   Aհ   Aհ   Aհ   Aհ   AհӢ   Aհԃ   Aհd   AհE   Aհ&   Aհ   Aհ   Aհ   Aհڪ   Aհۋ   Aհl   AհM   Aհ.   Aհ   Aհ   Aհ   Aհ   Aհ   Aհt   AհU   Aհ6   Aհ   Aհ   Aհ   Aհ   Aհ   Aհ|   Aհ]   Aհ>   Aհ   Aհ    Aհ   Aհ   Aհ   Aհ   Aհe   AհF   Aհ'   Aհ   Aհ   Aհ   Aհ   Aհ   Aհm   AհN   Aհ/   Aհ   Aհ   Aհ   Aհ   Aհ   Aձ u   AձV   Aձ7   Aձ   Aձ   Aձ   Aձ   Aձ   Aձ}   Aձ^   Aձ	?   Aձ
    Aձ   Aձ   Aձ   Aձ
   Aձ   Aձf   AձG   Aձ(   Aձ	   Aձ   Aձ   Aձ   Aձ   Aձn   AձO   Aձ0   Aձ   Aձ   Aձ   Aձ   Aձ   Aձv   AձW   Aձ8   Aձ    Aձ    Aձ!   Aձ"   Aձ#   Aձ$~   Aձ%_   Aձ&@   Aձ'!   Aձ(   Aձ(   Aձ)   Aձ*   Aձ+   Aձ,g   Aձ-H   Aձ.)   Aձ/
   Aձ/   Aձ0   Aձ1   Aձ2   Aձ3o   Aձ4P   Aձ51   Aձ6   Aձ6   Aձ7   Aձ8   Aձ9   Aձ:w   Aձ;X   Aձ<9   Aձ=   Aձ=   Aձ>   Aձ?   Aձ@   AձA   AձB`   AձCA   AձD"   AձE   AձE   AձF   AձG   AձH   AձIh   AձJI   AձK*   AձL   AձL   AձM   AձN   AձO   AձPp   AձQQ   AձR2   AձS   AձS   AձT   AձU   AձV   AձWx   AձXY   AձY:   AձZ   AձZ   Aձ[   Aձ\   Aձ]   Aձ^   Aձ_a   Aձ`B   Aձa#   Aձb   Aձb   Aձc   Aձd   Aձe   Aձfi   AձgJ   Aձh+   Aձi   Aձi   Aձj   Aձk   Aձl   Aձmq   AձnR   Aձo3   Aձp   Aձp   Aձq   Aձr   Aձs   Aձty   AձuZ   Aձv;   Aձw   Aձw   Aձx   Aձy   Aձz   Aձ{   Aձ|b   Aձ}C   Aձ~$   Aձ   Aձ   Aձ   Aձ   Aձ   Aձj   AձK   Aձ,   Aձ
   Aձ   Aձ   Aձ   Aձ   Aձr   AձS   Aձ4   Aձ   Aձ   Aձ   Aձ   Aձ   Aձz   Aձ[   Aձ<   Aձ   Aձ   Aձ   Aձ   Aձ   Aձ   Aձc   AձD   Aձ%   Aձ   Aձ   Aձ   Aձ   Aձ   Aձk   AձL   Aձ-   Aձ   Aձ   Aձ   Aձ   Aձ   Aձs   AձT   Aձ5   Aձ   Aձ   Aձ   Aձ   Aձ   Aձ{   Aձ\   Aձ=   Aձ   Aձ   Aձ   Aձ   Aձ   Aձ   Aձd   AձE   Aձ&   Aձ   Aձ   Aձ   Aձ   Aձ   Aձl   AձM   Aձ.   Aձ   Aձ   Aձ   Aձ²   AձÓ   Aձt   AձU   Aձ6   Aձ   Aձ   Aձ   Aձɺ   Aձʛ   Aձ|   Aձ]   Aձ>   Aձ   Aձ    Aձ   Aձ   Aձѣ   Aձ҄   Aձe   AձF   Aձ'   Aձ   Aձ   Aձ   Aձث   Aձٌ   Aձm   AձN   Aձ/   Aձ   Aձ   Aձ   Aձ߳   Aձ   Aձu   AձV   Aձ7   Aձ   Aձ   Aձ   Aձ   Aձ   Aձ}   Aձ^   Aձ?   Aձ    Aձ   Aձ   Aձ   Aձ   Aձ   Aձf   AձG   Aձ(   Aձ	   Aձ   Aձ   Aձ   Aձ   Aձn   AձO   Aձ0   Aձ   Aձ   Aձ   Aձ   Aձ   Aձv   AձW   Aղ 8   Aղ   Aղ   Aղ   Aղ   Aղ   Aղ~   Aղ_   Aղ@   Aղ!   Aղ	   Aղ	   Aղ
   Aղ   Aղ   Aղ
g   AղH   Aղ)   Aղ
   Aղ   Aղ   Aղ   Aղ   Aղo   AղP   Aղ1   Aղ   Aղ   Aղ   Aղ   Aղ   Aղw   AղX   Aղ9   Aղ   Aղ   Aղ   Aղ    Aղ!   Aղ"   Aղ#`   Aղ$A   Aղ%"   Aղ&   Aղ&   Aղ'   Aղ(   Aղ)   Aղ*h   Aղ+I   Aղ,*   Aղ-   Aղ-   Aղ.   Aղ/   Aղ0   Aղ1p   Aղ2Q   Aղ32   Aղ4   Aղ4   Aղ5   Aղ6   Aղ7   Aղ8x   Aղ9Y   Aղ::   Aղ;   Aղ;   Aղ<   Aղ=   Aղ>   Aղ?   Aղ@a   AղAB   AղB#   AղC   AղC   AղD   AղE   AղF   AղGi   AղHJ   AղI+   AղJ   AղJ   AղK   AղL   AղM   AղNq   AղOR   AղP3   AղQ   AղQ   AղR   AղS   AղT   AղUy   AղVZ   AղW;   AղX   AղX   AղY   AղZ   Aղ[   Aղ\   Aղ]b   Aղ^C   Aղ_$   Aղ`   Aղ`   Aղa   Aղb   Aղc   Aղdj   AղeK   Aղf,   Aղg
   Aղg   Aղh   Aղi   Aղj   Aղkr   AղlS   Aղm4   Aղn   Aղn   Aղo   Aղp   Aղq   Aղrz   Aղs[   Aղt<   Aղu   Aղu   Aղv   Aղw   Aղx   Aղy   Aղzc   Aղ{D   Aղ|%   Aղ}   Aղ}   Aղ~   Aղ   Aղ   Aղk   AղL   Aղ-   Aղ   Aղ   Aղ   Aղ   Aղ   Aղs   AղT   Aղ5   Aղ   Aղ   Aղ   Aղ   Aղ   Aղ{   Aղ\   Aղ=   Aղ   Aղ   Aղ   Aղ   Aղ   Aղ   Aղd   AղE   Aղ&   Aղ   Aղ   Aղ   Aղ   Aղ   Aղl   AղM   Aղ.   Aղ   Aղ   Aղ   Aղ   Aղ   Aղt   AղU   Aղ6   Aղ   Aղ   Aղ   Aղ   Aղ   Aղ|   Aղ]   Aղ>   Aղ   Aղ    Aղ   Aղ   Aղ   Aղ   Aղe   AղF   Aղ'   Aղ   Aղ   Aղ   Aղ   Aղ   Aղm   AղN   Aղ/   Aղ   Aղ   Aղ   Aղ   Aղ   Aղu   AղV   Aղ7   Aղ   Aղ   Aղ   Aղǻ   AղȜ   Aղ}   Aղ^   Aղ?   Aղ    Aղ   Aղ   Aղ   AղϤ   AղЅ   Aղf   AղG   Aղ(   Aղ	   Aղ   Aղ   Aղ֬   Aղ׍   Aղn   AղO   Aղ0   Aղ   Aղ   Aղ   Aղݴ   Aղޕ   Aղv   AղW   Aղ8   Aղ   Aղ   Aղ   Aղ   Aղ   Aղ~   Aղ_   Aղ@   Aղ!   Aղ   Aղ   Aղ   Aղ   Aղ   Aղg   AղH   Aղ)   Aղ
   Aղ   Aղ   Aղ   Aղ   Aղo   AղP   Aղ1   Aղ   Aղ   Aղ   Aղ   Aղ   Aղw   AղX   Aղ9   Aղ   Aղ   Aճ    Aճ   Aճ   Aճ   Aճ`   AճA   Aճ"   Aճ   Aճ   Aճ   Aճ	   Aճ
   Aճh   AճI   Aճ
*   Aճ   Aճ   Aճ   Aճ   Aճ   Aճp   AճQ   Aճ2   Aճ   Aճ   Aճ   Aճ   Aճ   Aճx   AճY   Aճ:   Aճ   Aճ   Aճ   Aճ   Aճ   Aճ    Aճ!a   Aճ"B   Aճ##   Aճ$   Aճ$   Aճ%   Aճ&   Aճ'   Aճ(i   Aճ)J   Aճ*+   Aճ+   Aճ+   Aճ,   Aճ-   Aճ.   Aճ/q   Aճ0R   Aճ13   Aճ2   Aճ2   Aճ3   Aճ4   Aճ5   Aճ6y   Aճ7Z   Aճ8;   Aճ9   Aճ9   Aճ:   Aճ;   Aճ<   Aճ=   Aճ>b   Aճ?C   Aճ@$   AճA   AճA   AճB   AճC   AճD   AճEj   AճFK   AճG,   AճH
   AճH   AճI   AճJ   AճK   AճLr   AճMS   AճN4   AճO   AճO   AճP   AճQ   AճR   AճSz   AճT[   AճU<   AճV   AճV   AճW   AճX   AճY   AճZ   Aճ[c   Aճ\D   Aճ]%   Aճ^   Aճ^   Aճ_   Aճ`   Aճa   Aճbk   AճcL   Aճd-   Aճe   Aճe   Aճf   Aճg   Aճh   Aճis   AճjT   Aճk5   Aճl   Aճl   Aճm   Aճn   Aճo   Aճp{   Aճq\   Aճr=   Aճs   Aճs   Aճt   Aճu   Aճv   Aճw   Aճxd   AճyE   Aճz&   Aճ{   Aճ{   Aճ|   Aճ}   Aճ~   Aճl   AճM   Aճ.   Aճ   Aճ   Aճ   Aճ   Aճ   Aճt   AճU   Aճ6   Aճ   Aճ   Aճ   Aճ   Aճ   Aճ|   Aճ]   Aճ>   Aճ   Aճ    Aճ   Aճ   Aճ   Aճ   Aճe   AճF   Aճ'   Aճ   Aճ   Aճ   Aճ   Aճ   Aճm   AճN   Aճ/   Aճ   Aճ   Aճ   Aճ   Aճ   Aճu   AճV   Aճ7   Aճ   Aճ   Aճ   Aճ   Aճ   Aճ}   Aճ^   Aճ?   Aճ    Aճ   Aճ   Aճ   Aճ   Aճ   Aճf   AճG   Aճ(   Aճ	   Aճ   Aճ   Aճ   Aճ   Aճn   AճO   Aճ0   Aճ   Aճ   Aճ   Aճ   Aճ   Aճv   AճW   Aճ8   Aճ   Aճ   Aճ   Aճż   AճƝ   Aճ~   Aճ_   Aճ@   Aճ!   Aճ   Aճ   Aճ   Aճͥ   AճΆ   Aճg   AճH   Aճ)   Aճ
   Aճ   Aճ   Aճԭ   AճՎ   Aճo   AճP   Aճ1   Aճ   Aճ   Aճ   Aճ۵   Aճܖ   Aճw   AճX   Aճ9   Aճ   Aճ   Aճ   Aճ   Aճ   Aճ   Aճ`   AճA   Aճ"   Aճ   Aճ   Aճ   Aճ   Aճ   Aճh   AճI   Aճ*   Aճ   Aճ   Aճ   Aճ   Aճ   Aճp   AճQ   Aճ2   Aճ   Aճ   Aճ   Aճ   Aճ   Aճx   AճY   Aճ:   Aճ   Aճ   Aճ   Aճ   Aմ    Aմ   Aմa   AմB   Aմ#   Aմ   Aմ   Aմ   Aմ   Aմ   Aմ	i   Aմ
J   Aմ+   Aմ   Aմ   Aմ
   Aմ   Aմ   Aմq   AմR   Aմ3   Aմ   Aմ   Aմ   Aմ   Aմ   Aմy   AմZ   Aմ;   Aմ   Aմ   Aմ   Aմ   Aմ   Aմ   Aմb   Aմ C   Aմ!$   Aմ"   Aմ"   Aմ#   Aմ$   Aմ%   Aմ&j   Aմ'K   Aմ(,   Aմ)
   Aմ)   Aմ*   Aմ+   Aմ,   Aմ-r   Aմ.S   Aմ/4   Aմ0   Aմ0   Aմ1   Aմ2   Aմ3   Aմ4z   Aմ5[   Aմ6<   Aմ7   Aմ7   Aմ8   Aմ9   Aմ:   Aմ;   Aմ<c   Aմ=D   Aմ>%   Aմ?   Aմ?   Aմ@   AմA   AմB   AմCk   AմDL   AմE-   AմF   AմF   AմG   AմH   AմI   AմJs   AմKT   AմL5   AմM   AմM   AմN   AմO   AմP   AմQ{   AմR\   AմS=   AմT   AմT   AմU   AմV   AմW   AմX   AմYd   AմZE   Aմ[&   Aմ\   Aմ\   Aմ]   Aմ^   Aմ_   Aմ`l   AմaM   Aմb.   Aմc   Aմc   Aմd   Aմe   Aմf   Aմgt   AմhU   Aմi6   Aմj   Aմj   Aմk   Aմl   Aմm   Aմn|   Aմo]   Aմp>   Aմq   Aմr    Aմr   Aմs   Aմt   Aմu   Aմve   AմwF   Aմx'   Aմy   Aմy   Aմz   Aմ{   Aմ|   Aմ}m   Aմ~N   Aմ/   Aմ   Aմ   Aմ   Aմ   Aմ   Aմu   AմV   Aմ7   Aմ   Aմ   Aմ   Aմ   Aմ   Aմ}   Aմ^   Aմ?   Aմ    Aմ   Aմ   Aմ   Aմ   Aմ   Aմf   AմG   Aմ(   Aմ	   Aմ   Aմ   Aմ   Aմ   Aմn   AմO   Aմ0   Aմ   Aմ   Aմ   Aմ   Aմ   Aմv   AմW   Aմ8   Aմ   Aմ   Aմ   Aմ   Aմ   Aմ~   Aմ_   Aմ@   Aմ!   Aմ   Aմ   Aմ   Aմ   Aմ   Aմg   AմH   Aմ)   Aմ
   Aմ   Aմ   Aմ   Aմ   Aմo   AմP   Aմ1   Aմ   Aմ   Aմ   Aմ   Aմ   Aմw   AմX   Aմ9   Aմ   Aմ   Aմ   Aմý   AմĞ   Aմ   Aմ`   AմA   Aմ"   Aմ   Aմ   Aմ   Aմ˦   Aմ̇   Aմh   AմI   Aմ*   Aմ   Aմ   Aմ   AմҮ   Aմӏ   Aմp   AմQ   Aմ2   Aմ   Aմ   Aմ   Aմٶ   Aմڗ   Aմx   AմY   Aմ:   Aմ   Aմ   Aմ   Aմ   Aմ   Aմ   Aմa   AմB   Aմ#   Aմ   Aմ   Aմ   Aմ   Aմ   Aմi   AմJ   Aմ+   Aմ   Aմ   Aմ   Aմ   Aմ   Aմq   AմR   Aմ3   Aմ   Aմ   Aմ   Aմ   Aմ   Aմy   AմZ   Aմ;   Aմ   Aմ   Aմ   Aմ   Aմ   Aմ   Aյ b   AյC   Aյ$   Aյ   Aյ   Aյ   Aյ   Aյ   Aյj   AյK   Aյ	,   Aյ

   Aյ
   Aյ   Aյ   Aյ
   Aյr   AյS   Aյ4   Aյ   Aյ   Aյ   Aյ   Aյ   Aյz   Aյ[   Aյ<   Aյ   Aյ   Aյ   Aյ   Aյ   Aյ   Aյc   AյD   Aյ%   Aյ    Aյ    Aյ!   Aյ"   Aյ#   Aյ$k   Aյ%L   Aյ&-   Aյ'   Aյ'   Aյ(   Aյ)   Aյ*   Aյ+s   Aյ,T   Aյ-5   Aյ.   Aյ.   Aյ/   Aյ3\   Aյ4=   Aյ5   Aյ8   Aյ>   AյIU   AյY'   Aն+6   Aն,   Aն,   Aն-   Aն.   Aն/   Aն0|   Aն1]   Aն2>   Aն3   Aն4    Aն4   Aն5   Aն6   Aն7   Aն8e   Aն9F   Aն:'   Aն;   Aն;   Aն<   Aն=   Aն>   Aն?m   Aն@N   AնA/   AնB   AնB   AնC   AնD   AնE   AնFu   AնGV   AնH7   AնI   AնI   AնJ   AնK   AնL   AնM}   AնN^   AնO?   AնP    AնQ   AնQ   AնR   AնS   AնT   AնUf   AնVG   AնW(   AնX	   AնX   AնY   AնZ   Aն[   Aն\n   Aն]O   Aն^0   Aն_   Aն_   Aն`   Aնa   Aնb   Aնcv   AնdW   Aնe8   Aնf   Aնf   Aնg   Aնh   Aնi   Aնj~   Aնk_   Aնl@   Aնm!   Aնn   Aնn   Aնo   Aնp   Aնq   Aնrg   AնsH   Aնt)   Aնu
   Aնu   Aնv   Aնw   Aնx   Aնyo   AնzP   Aն{1   Aն|   Aն|   Aն}   Aն~   Aն   Aնw   AնX   Aն9   Aն   Aն   Aն   Aն   Aն   Aն   Aն`   AնA   Aն"   Aն   Aն   Aն   Aն   Aն   Aնh   AնI   Aն*   Aն   Aն   Aն   Aն   Aն   Aնp   AնQ   Aն2   Aն   Aն   Aն   Aն   Aն   Aնx   AնY   Aն:   Aն   Aն   Aն   Aն   Aն   Aն   Aնa   AնB   Aն#   Aն   Aն   Aն   Aն   Aն   Aնi   AնJ   Aն+   Aն   Aն   Aն   Aն   Aն   Aնq   AնR   Aն3   Aն   Aն   Aն   Aն   Aն   Aնy   AնZ   Aն;   Aն   Aն   Aն   Aն   Aն   Aն   Aնb   AնC   Aն$   Aն   Aն   Aն   AնǨ   Aնȉ   Aնj   AնK   Aն,   Aն
   Aն   Aն   Aնΰ   Aնϑ   Aնr   AնS   Aն4   Aն   Aն   Aն   Aնո   Aն֙   Aնz   Aն[   Aն<   Aն   Aն   Aն   Aն   Aնݡ   Aնނ   Aնc   AնD   Aն%   Aն   Aն   Aն   Aն   Aն   Aնk   AնL   Aն-   Aն   Aն   Aն   Aն   Aն   Aնs   AնT   Aն5   Aն   Aն   Aն   Aն   Aն   Aն{   Aն\   Aն=   Aն   Aն   Aն   Aն   Aն   Aն   Aնd   AնE   Aն&   Aն   Aն   Aշ    Aշ   Aշ   Aշl   AշM   Aշ.   Aշ   Aշ   Aշ   Aշ   Aշ	   Aշ
t   AշU   Aշ6   Aշ
   Aշ
   Aշ   Aշ   Aշ   Aշ|   Aշ]   Aշ>   Aշ   Aշ    Aշ   Aշ   Aշ   Aշ   Aշe   AշF   Aշ'   Aշ   Aշ   Aշ   Aշ   Aշ   Aշ m   Aշ!N   Aշ"/   Aշ#   Aշ#   Aշ$   Aշ%   Aշ&   Aշ'u   Aշ(V   Aշ)7   Aշ*   Aշ*   Aշ+   Aշ,   Aշ-   Aշ.}   Aշ/^   Aշ0?   Aշ1    Aշ2   Aշ2   Aշ3   Aշ4   Aշ5   Aշ6f   Aշ7G   Aշ8(   Aշ9	   Aշ9   Aշ:   Aշ;   Aշ<   Aշ=n   Aշ>O   Aշ?0   Aշ@   Aշ@   AշA   AշB   AշC   AշDv   AշEW   AշF8   AշG   AշG   AշH   AշI   AշJ   AշK~   AշL_   AշM@   AշN!   AշO   AշO   AշP   AշQ   AշR   AշSg   AշTH   AշU)   AշV
   AշV   AշW   AշX   AշY   AշZo   Aշ[P   Aշ\1   Aշ]   Aշ]   Aշ^   Aշ_   Aշ`   Aշaw   AշbX   Aշc9   Aշd   Aշd   Aշe   Aշf   Aշg   Aշh   Aշi`   AշjA   Aշk"   Aշl   Aշl   Aշm   Aշn   Aշo   Aշph   AշqI   Aշr*   Aշs   Aշs   Aշt   Aշu   Aշv   Aշwp   AշxQ   Aշy2   Aշz   Aշz   Aշ{   Aշ|   Aշ}   Aշ~x   AշY   Aշ:   Aշ   Aշ   Aշ   Aշ   Aշ   Aշ   Aշa   AշB   Aշ#   Aշ   Aշ   Aշ   Aշ   Aշ   Aշi   AշJ   Aշ+   Aշ   Aշ   Aշ   Aշ   Aշ   Aշq   AշR   Aշ3   Aշ   Aշ   Aշ   Aշ   Aշ   Aշy   AշZ   Aշ;   Aշ   Aշ   Aշ   Aշ   Aշ   Aշ   Aշb   AշC   Aշ$   Aշ   Aշ   Aշ   Aշ   Aշ   Aշj   AշK   Aշ,   Aշ
   Aշ   Aշ   Aշ   Aշ   Aշr   AշS   Aշ4   Aշ   Aշ   Aշ   Aշ   Aշ   Aշz   Aշ[   Aշ<   Aշ   Aշ   Aշ   Aշ   Aշ   Aշ   Aշc   AշD   Aշ%   Aշ   Aշ   Aշ   Aշũ   AշƊ   Aշk   AշL   Aշ-   Aշ   Aշ   Aշ   Aշ̱   Aշ͒   Aշs   AշT   Aշ5   Aշ   Aշ   Aշ   Aշӹ   AշԚ   Aշ{   Aշ\   Aշ=   Aշ   Aշ   Aշ   Aշ   Aշۢ   Aշ܃   Aշd   AշE   Aշ&   Aշ   Aշ   Aշ   Aշ   Aշ   Aշl   AշM   Aշ.   Aշ   Aշ   Aշ   Aշ   Aշ   Aշt   AշU   Aշ6   Aշ   Aշ   Aշ   Aշ   Aշ   Aշ|   Aշ]   Aշ>   Aշ   Aշ    Aշ   Aշ   Aշ   Aշ   Aշe   AշF   Aշ'   Aշ   Aշ   Aշ   Aշ   Aո    Aոm   AոN   Aո/   Aո   Aո   Aո   Aո   Aո   Aոu   Aո	V   Aո
7   Aո   Aո   Aո   Aո
   Aո   Aո}   Aո^   Aո?   Aո    Aո   Aո   Aո   Aո   Aո   Aոf   AոG   Aո(   Aո	   Aո   Aո   Aո   Aո   Aոn   AոO   Aո 0   Aո!   Aո!   Aո"   Aո#   Aո$   Aո%v   Aո&W   Aո'8   Aո(   Aո(   Aո)   Aո*   Aո+   Aո,~   Aո-_   Aո.@   Aո/!   Aո0   Aո0   Aո1   Aո2   Aո3   Aո4g   Aո5H   Aո6)   Aո7
   Aո7   Aո8   Aո9   Aո:   Aո;o   Aո<P   Aո=1   Aո>   Aո>   Aո?   Aո@   AոA   AոBw   AոCX   AոD9   AոE   AոE   AոF   AոG   AոH   AոI   AոJ`   AոKA   AոL"   AոM   AոM   AոN   AոO   AոP   AոQh   AոRI   AոS*   AոT   AոT   AոU   AոV   AոW   AոXp   AոYQ   AոZ2   Aո[   Aո[   Aո\   Aո]   Aո^   Aո_x   Aո`Y   Aոa:   Aոb   Aոb   Aոc   Aոd   Aոe   Aոf   Aոga   AոhB   Aոi#   Aոj   Aոj   Aոk   Aոl   Aոm   Aոni   AոoJ   Aոp+   Aոq   Aոq   Aոr   Aոs   Aոt   Aոuq   AոvR   Aոw3   Aոx   Aոx   Aոy   Aոz   Aո{   Aո|y   Aո}Z   Aո~;   Aո   Aո   Aո   Aո   Aո   Aո   Aոb   AոC   Aո$   Aո   Aո   Aո   Aո   Aո   Aոj   AոK   Aո,   Aո
   Aո   Aո   Aո   Aո   Aոr   AոS   Aո4   Aո   Aո   Aո   Aո   Aո   Aոz   Aո[   Aո<   Aո   Aո   Aո   Aո   Aո   Aո   Aոc   AոD   Aո%   Aո   Aո   Aո   Aո   Aո   Aոk   AոL   Aո-   Aո   Aո   Aո   Aո   Aո   Aոs   AոT   Aո5   Aո   Aո   Aո   Aո   Aո   Aո{   Aո\   Aո=   Aո   Aո   Aո   Aո   Aո   Aո   Aոd   AոE   Aո&   Aո   Aո   Aո   Aոê   Aոċ   Aոl   AոM   Aո.   Aո   Aո   Aո   Aոʲ   Aո˓   Aոt   AոU   Aո6   Aո   Aո   Aո   AոѺ   Aոқ   Aո|   Aո]   Aո>   Aո   Aո    Aո   Aո   Aո٣   Aոڄ   Aոe   AոF   Aո'   Aո   Aո   Aո   Aո   Aո   Aոm   AոN   Aո/   Aո   Aո   Aո   Aո   Aո   Aոu   AոV   Aո7   Aո   Aո   Aո   Aո   Aո   Aո}   Aո^   Aո?   Aո    Aո   Aո   Aո   Aո   Aո   Aոf   AոG   Aո(   Aո	   Aո   Aո   Aո   Aո   Aոn   Aչ O   Aչ0   Aչ   Aչ   Aչ   Aչ   Aչ   Aչv   AչW   Aչ8   Aչ	   Aչ	   Aչ
   Aչ   Aչ   Aչ
~   Aչ_   Aչ@   Aչ!   Aչ   Aչ   Aչ   Aչ   Aչ   Aչg   AչH   Aչ)   Aչ
   Aչ   Aչ   Aչ   Aչ   Aչo   AչP   Aչ1   Aչ   Aչ   Aչ    Aչ!   Aչ"   Aչ#w   Aչ$X   Aչ%9   Aչ&   Aչ&   Aչ'   Aչ(   Aչ)   Aչ*   Aչ+`   Aչ,A   Aչ-"   Aչ.   Aչ.   Aչ/   Aչ0   Aչ1   Aչ2h   Aչ3I   Aչ4*   Aչ5   Aչ5   Aչ6   Aչ7   Aչ8   Aչ9p   Aչ:Q   Aչ;2   Aչ<   Aչ<   Aչ=   Aչ>   Aչ?   Aչ@x   AչAY   AչB:   AչC   AչC   AչD   AչE   AչF   AչG   AչHa   AչIB   AչJ#   AչK   AչK   AչL   AչM   AչN   AչOi   AչPJ   AչQ+   AչR   AչR   AչS   AչT   AչU   AչVq   AչWR   AչX3   AչY   AչY   AչZ   Aչ[   Aչ\   Aչ]y   Aչ^Z   Aչ_;   Aչ`   Aչ`   Aչa   Aչb   Aչc   Aչd   Aչeb   AչfC   Aչg$   Aչh   Aչh   Aչi   Aչj   Aչk   Aչlj   AչmK   Aչn,   Aչo
   Aչo   Aչp   Aչq   Aչr   Aչsr   AչtS   Aչu4   Aչv   Aչv   Aչw   Aչx   Aչy   Aչzz   Aչ{[   Aչ|<   Aչ}   Aչ}   Aչ~   Aչ   Aչ   Aչ   Aչc   AչD   Aչ%   Aչ   Aչ   Aչ   Aչ   Aչ   Aչk   AչL   Aչ-   Aչ   Aչ   Aչ   Aչ   Aչ   Aչs   AչT   Aչ5   Aչ   Aչ   Aչ   Aչ   Aչ   Aչ{   Aչ\   Aչ=   Aչ   Aչ   Aչ   Aչ   Aչ   Aչ   Aչd   AչE   Aչ&   Aչ   Aչ   Aչ   Aչ   Aչ   Aչl   AչM   Aչ.   Aչ   Aչ   Aչ   Aչ   Aչ   Aչt   AչU   Aչ6   Aչ   Aչ   Aչ   Aչ   Aչ   Aչ|   Aչ]   Aչ>   Aչ   Aչ    Aչ   Aչ   Aչ   Aչ   Aչe   AչF   Aչ'   Aչ   Aչ   Aչ   Aչ   Aչ   Aչm   AչN   Aչ/   Aչ   Aչ   Aչ   Aչȳ   Aչɔ   Aչu   AչV   Aչ7   Aչ   Aչ   Aչ   Aչϻ   AչМ   Aչ}   Aչ^   Aչ?   Aչ    Aչ   Aչ   Aչ   Aչפ   Aչ؅   Aչf   AչG   Aչ(   Aչ	   Aչ   Aչ   Aչެ   Aչߍ   Aչn   AչO   Aչ0   Aչ   Aչ   Aչ   Aչ   Aչ   Aչv   AչW   Aչ8   Aչ   Aչ   Aչ   Aչ   Aչ   Aչ~   Aչ_   Aչ@   Aչ!   Aչ   Aչ   Aչ   Aչ   Aչ   Aչg   AչH   Aչ)   Aչ
   Aչ   Aչ   Aչ   Aչ   Aչo   AչP   Aչ1   Aպ    Aպ    Aպ   Aպ   Aպ   Aպw   AպX   Aպ9   Aպ   Aպ   Aպ   Aպ	   Aպ
   Aպ   Aպ`   Aպ
A   Aպ"   Aպ   Aպ   Aպ   Aպ   Aպ   Aպh   AպI   Aպ*   Aպ   Aպ   Aպ   Aպ   Aպ   Aպp   AպQ   Aպ2   Aպ   Aպ   Aպ   Aպ   Aպ    Aպ!x   Aպ"Y   Aպ#:   Aպ$   Aպ$   Aպ%   Aպ&   Aպ'   Aպ(   Aպ)a   Aպ*B   Aպ+#   Aպ,   Aպ,   Aպ-   Aպ.   Aպ/   Aպ0i   Aպ1J   Aպ2+   Aպ3   Aպ3   Aպ4   Aպ5   Aպ6   Aպ7q   Aպ8R   Aպ93   Aպ:   Aպ:   Aպ;   Aպ<   Aպ=   Aպ>y   Aպ?Z   Aպ@;   AպA   AպA   AպB   AպC   AպD   AպE   AպFb   AպGC   AպH$   AպI   AպI   AպJ   AպK   AպL   AպMj   AպNK   AպO,   AպP
   AպP   AպQ   AպR   AպS   AպTr   AպUS   AպV4   AպW   AպW   AպX   AպY   AպZ   Aպ[z   Aպ\[   Aպ]<   Aպ^   Aպ^   Aպ_   Aպ`   Aպa   Aպb   Aպcc   AպdD   Aպe%   Aպf   Aպf   Aպg   Aպh   Aպi   Aպjk   AպkL   Aպl-   Aպm   Aպm   Aպn   Aպo   Aպp   Aպqs   AպrT   Aպs5   Aպt   Aպt   Aպu   Aպv   Aպw   Aպx{   Aպy\   Aպz=   Aպ{   Aպ{   Aպ|   Aպ}   Aպ~   Aպ   Aպd   AպE   Aպ&   Aպ   Aպ   Aպ   Aպ   Aպ   Aպl   AպM   Aպ.   Aպ   Aպ   Aպ   Aպ   Aպ   Aպt   AպU   Aպ6   Aպ   Aպ   Aպ   Aպ   Aպ   Aպ|   Aպ]   Aպ>   Aպ   Aպ    Aպ   Aպ   Aպ   Aպ   Aպe   AպF   Aպ'   Aպ   Aպ   Aպ   Aպ   Aպ   Aպm   AպN   Aպ/   Aպ   Aպ   Aպ   Aպ   Aպ   Aպu   AպV   Aպ7   Aպ   Aպ   Aպ   Aպ   Aպ   Aպ}   Aպ^   Aպ?   Aպ    Aպ   Aպ   Aպ   Aպ   Aպ   Aպf   AպG   Aպ(   Aպ	   Aպ   Aպ   Aպ   Aպ   Aպn   AպO   Aպ0   Aպ   Aպ   Aպ   Aպƴ   AպǕ   Aպv   AպW   Aպ8   Aպ   Aպ   Aպ   Aպͼ   AպΝ   Aպ~   Aպ_   Aպ@   Aպ!   Aպ   Aպ   Aպ   Aպե   Aպֆ   Aպg   AպH   Aպ)   Aպ
   Aպ   Aպ   Aպܭ   Aպݎ   Aպo   AպP   Aպ1   Aպ   Aպ   Aպ   Aպ   Aպ   Aպw   AպX   Aպ9   Aպ   Aպ   Aպ   Aպ   Aպ   Aպ   Aպ`   AպA   Aպ"   Aպ   Aպ   Aպ   Aպ   Aպ   Aպh   AպI   Aպ*   Aպ   Aպ   Aպ   Aպ   Aպ   Aպp   AպQ   Aպ2   Aպ   Aպ   Aպ   Aջ    Aջ   Aջx   AջY   Aջ:   Aջ   Aջ   Aջ   Aջ   Aջ   Aջ	   Aջ
a   AջB   Aջ#   Aջ
   Aջ
   Aջ   Aջ   Aջ   Aջi   AջJ   Aջ+   Aջ   Aջ   Aջ   Aջ   Aջ   Aջq   AջR   Aջ3   Aջ   Aջ   Aջ   Aջ   Aջ   Aջy   Aջ Z   Aջ!;   Aջ"   Aջ"   Aջ#   Aջ$   Aջ%   Aջ&   Aջ'b   Aջ(C   Aջ)$   Aջ*   Aջ*   Aջ+   Aջ,   Aջ-   Aջ.j   Aջ/K   Aջ0,   Aջ1
   Aջ1   Aջ2   Aջ3   Aջ4   Aջ5r   Aջ6S   Aջ74   Aջ8   Aջ8   Aջ9   Aջ:   Aջ;   Aջ<z   Aջ=[   Aջ><   Aջ?   Aջ?   Aջ@   AջA   AջB   AջC   AջDc   AջED   AջF%   AջG   AջG   AջH   AջI   AջJ   AջKk   AջLL   AջM-   AջN   AջN   AջO   AջP   AջQ   AջRs   AջST   AջT5   AջU   AջU   AջV   AջW   AջX   AջY{   AջZ\   Aջ[=   Aջ\   Aջ\   Aջ]   Aջ^   Aջ_   Aջ`   Aջad   AջbE   Aջc&   Aջd   Aջd   Aջe   Aջf   Aջg   Aջhl   AջiM   Aջj.   Aջk   Aջk   Aջl   Aջm   Aջn   Aջot   AջpU   Aջq6   Aջr   Aջr   Aջs   Aջt   Aջu   Aջv|   Aջw]   Aջx>   Aջy   Aջz    Aջz   Aջ{   Aջ|   Aջ}   Aջ~e   AջF   Aջ'   Aջ   Aջ   Aջ   Aջ   Aջ   Aջm   AջN   Aջ/   Aջ   Aջ   Aջ   Aջ   Aջ   Aջu   AջV   Aջ7   Aջ   Aջ   Aջ   Aջ   Aջ   Aջ}   Aջ^   Aջ?   Aջ    Aջ   Aջ   Aջ   Aջ   Aջ   Aջf   AջG   Aջ(   Aջ	   Aջ   Aջ   Aջ   Aջ   Aջn   AջO   Aջ0   Aջ   Aջ   Aջ   Aջ   Aջ   Aջv   AջW   Aջ8   Aջ   Aջ   Aջ   Aջ   Aջ   Aջ~   Aջ_   Aջ@   Aջ!   Aջ   Aջ   Aջ   Aջ   Aջ   Aջg   AջH   Aջ)   Aջ
   Aջ   Aջ   Aջ   Aջ   Aջo   AջP   Aջ1   Aջ   Aջ   Aջ   Aջĵ   AջŖ   Aջw   AջX   Aջ9   Aջ   Aջ   Aջ   Aջ˽   Aջ̞   Aջ   Aջ`   AջA   Aջ"   Aջ   Aջ   Aջ   AջӦ   Aջԇ   Aջh   AջI   Aջ*   Aջ   Aջ   Aջ   Aջڮ   Aջۏ   Aջp   AջQ   Aջ2   Aջ   Aջ   Aջ   Aջ   Aջ   Aջx   AջY   Aջ:   Aջ   Aջ   Aջ   Aջ   Aջ   Aջ   Aջa   AջB   Aջ#   Aջ   Aջ   Aջ   Aջ   Aջ   Aջi   AջJ   Aջ+   Aջ   Aջ   Aջ   Aջ   Aջ   Aջq   AջR   Aջ3   Aջ   Aջ   Aջ   Aջ   Aջ   Aռ y   AռZ   Aռ;   Aռ   Aռ   Aռ   Aռ   Aռ   Aռ   Aռb   Aռ	C   Aռ
$   Aռ   Aռ   Aռ   Aռ
   Aռ   Aռj   AռK   Aռ,   Aռ
   Aռ   Aռ   Aռ   Aռ   Aռr   AռS   Aռ4   Aռ   Aռ   Aռ   Aռ   Aռ   Aռz   Aռ[   Aռ<   Aռ    Aռ    Aռ!   Aռ"   Aռ#   Aռ$   Aռ%c   Aռ&D   Aռ'%   Aռ(   Aռ(   Aռ)   Aռ*   Aռ+   Aռ,k   Aռ-L   Aռ.-   Aռ/   Aռ/   Aռ0   Aռ1   Aռ2   Aռ3s   Aռ4T   Aռ55   Aռ6   Aռ6   Aռ7   Aռ8   Aռ9   Aռ:{   Aռ;\   Aռ<=   Aռ=   Aռ=   Aռ>   Aռ?   Aռ@   AռA   AռBd   AռCE   AռD&   AռE   AռE   AռF   AռG   AռH   AռIl   AռJM   AռK.   AռL   AռL   AռM   AռN   AռO   AռPt   AռQU   AռR6   AռS   AռS   AռT   AռU   AռV   AռW|   AռX]   AռY>   AռZ   Aռ[    Aռ[   Aռ\   Aռ]   Aռ^   Aռ_e   Aռ`F   Aռa'   Aռb   Aռb   Aռc   Aռd   Aռe   Aռfm   AռgN   Aռh/   Aռi   Aռi   Aռj   Aռk   Aռl   Aռmu   AռnV   Aռo7   Aռp   Aռp   Aռq   Aռr   Aռs   Aռt}   Aռu^   Aռv?   Aռw    Aռx   Aռx   Aռy   Aռz   Aռ{   Aռ|f   Aռ}G   Aռ~(   Aռ	   Aռ   Aռ   Aռ   Aռ   Aռn   AռO   Aռ0   Aռ   Aռ   Aռ   Aռ   Aռ   Aռv   AռW   Aռ8   Aռ   Aռ   Aռ   Aռ   Aռ   Aռ~   Aռ_   Aռ@   Aռ!   Aռ   Aռ   Aռ   Aռ   Aռ   Aռg   AռH   Aռ)   Aռ
   Aռ   Aռ   Aռ   Aռ   Aռo   AռP   Aռ1   Aռ   Aռ   Aռ   Aռ   Aռ   Aռw   AռX   Aռ9   Aռ   Aռ   Aռ   Aռ   Aռ   Aռ   Aռ`   AռA   Aռ"   Aռ   Aռ   Aռ   Aռ   Aռ   Aռh   AռI   Aռ*   Aռ   Aռ   Aռ   Aռ   Aռ   Aռp   AռQ   Aռ2   Aռ   Aռ   Aռ   Aռ¶   Aռ×   Aռx   AռY   Aռ:   Aռ   Aռ   Aռ   Aռɾ   Aռʟ   Aռˀ   Aռa   AռB   Aռ#   Aռ   Aռ   Aռ   Aռѧ   Aռ҈   Aռi   AռJ   Aռ+   Aռ   Aռ   Aռ   Aռد   Aռِ   Aռq   AռR   Aռ3   Aռ   Aռ   Aռ   Aռ߷   Aռ   Aռy   AռZ   Aռ;   Aռ   Aռ   Aռ   Aռ   Aռ   Aռ   Aռb   AռC   Aռ$   Aռ   Aռ   Aռ   Aռ   Aռ   Aռj   AռK   Aռ,   Aռ
   Aռ   Aռ   Aռ   Aռ   Aռr   AռS   Aռ4   Aռ   Aռ   Aռ   Aռ   Aռ   Aռz   Aռ[   Aս <   Aս   Aս   Aս   Aս   Aս   Aս   Aսc   AսD   Aս%   Aս	   Aս	   Aս
   Aս   Aս   Aս
k   AսL   Aս-   Aս   Aս   Aս   Aս   Aս   Aսs   AսT   Aս5   Aս   Aս   Aս   Aս   Aս   Aս{   Aս\   Aս=   Aս   Aս   Aս   Aս    Aս!   Aս"   Aս#d   Aս$E   Aս%&   Aս&   Aս&   Aս'   Aս(   Aս)   Aս*l   Aս+M   Aս,.   Aս-   Aս-   Aս.   Aս/   Aս0   Aս1t   Aս2U   Aս36   Aս4   Aս4   Aս5   Aս6   Aս7   Aս8|   Aս9]   Aս:>   Aս;   Aս<    Aս<   Aս=   Aս>   Aս?   Aս@e   AսAF   AսB'   AսC   AսC   AսD   AսE   AսF   AսGm   AսHN   AսI/   AսJ   AսJ   AսK   AսL   AսM   AսNu   AսOV   AսP7   AսQ   AսQ   AսR   AսS   AսT   AսU}   AսV^   AսW?   AսX    AսY   AսY   AսZ   Aս[   Aս\   Aս]f   Aս^G   Aս_(   Aս`	   Aս`   Aսa   Aսb   Aսc   Aսdn   AսeO   Aսf0   Aսg   Aսg   Aսh   Aսi   Aսj   Aսkv   AսlW   Aսm8   Aսn   Aսn   Aսo   Aսp   Aսq   Aսr~   Aսs_   Aսt@   Aսu!   Aսv   Aսv   Aսw   Aսx   Aսy   Aսzg   Aս{H   Aս|)   Aս}
   Aս}   Aս~   Aս   Aս   Aսo   AսP   Aս1   Aս   Aս   Aս   Aս   Aս   Aսw   AսX   Aս9   Aս   Aս   Aս   Aս   Aս   Aս   Aս`   AսA   Aս"   Aս   Aս   Aս   Aս   Aս   Aսh   AսI   Aս*   Aս   Aս   Aս   Aս   Aս   Aսp   AսQ   Aս2   Aս   Aս   Aս   Aս   Aս   Aսx   AսY   Aս:   Aս   Aս   Aս   Aս   Aս   Aս   Aսa   AսB   Aս#   Aս   Aս   Aս   Aս   Aս   Aսi   AսJ   Aս+   Aս   Aս   Aս   Aս   Aս   Aսq   AսR   Aս3   Aս   Aս   Aս   Aս   Aս   Aսy   AսZ   Aս;   Aս   Aս   Aս   Aսǿ   AսȠ   AսɁ   Aսb   AսC   Aս$   Aս   Aս   Aս   AսϨ   AսЉ   Aսj   AսK   Aս,   Aս
   Aս   Aս   Aսְ   Aսב   Aսr   AսS   Aս4   Aս   Aս   Aս   Aսݸ   Aսޙ   Aսz   Aս[   Aս<   Aս   Aս   Aս   Aս   Aս   Aս   Aսc   AսD   Aս%   Aս   Aս   Aս   Aս   Aս   Aսk   AսL   Aս-   Aս   Aս   Aս   Aս   Aս   Aսs   AսT   Aս5   Aս   Aս   Aս   Aս   Aս   Aս{   Aս\   Aս=   Aս   Aս   Aվ    Aվ   Aվ   Aվ   Aվd   AվE   Aվ&   Aվ   Aվ   Aվ   Aվ	   Aվ
   Aվl   AվM   Aվ
.   Aվ   Aվ   Aվ   Aվ   Aվ   Aվt   AվU   Aվ6   Aվ   Aվ   Aվ   Aվ   Aվ   Aվ|   Aվ]   Aվ>   Aվ   Aվ    Aվ   Aվ   Aվ   Aվ    Aվ!e   Aվ"F   Aվ#'   Aվ$   Aվ$   Aվ%   Aվ&   Aվ'   Aվ(m   Aվ)N   Aվ*/   Aվ+   Aվ+   Aվ,   Aվ-   Aվ.   Aվ/u   Aվ0V   Aվ17   Aվ2   Aվ2   Aվ3   Aվ4   Aվ5   Aվ6}   Aվ7^   Aվ8?   Aվ9    Aվ:   Aվ:   Aվ;   Aվ<   Aվ=   Aվ>f   Aվ?G   Aվ@(   AվA	   AվA   AվB   AվC   AվD   AվEn   AվFO   AվG0   AվH   AվH   AվI   AվJ   AվK   AվLv   AվMW   AվN8   AվO   AվO   AվP   AվQ   AվR   AվS~   AվT_   AվU@   AվV!   AվW   AվW   AվX   AվY   AվZ   Aվ[g   Aվ\H   Aվ])   Aվ^
   Aվ^   Aվ_   Aվ`   Aվa   Aվbo   AվcP   Aվd1   Aվe   Aվe   Aվf   Aվg   Aվh   Aվiw   AվjX   Aվk9   Aվl   Aվl   Aվm   Aվn   Aվo   Aվp   Aվq`   AվrA   Aվs"   Aվt   Aվt   Aվu   Aվv   Aվw   Aվxh   AվyI   Aվz*   Aվ{   Aվ{   Aվ|   Aվ}   Aվ~   Aվp   AվQ   Aվ2   Aվ   Aվ   Aվ   Aվ   Aվ   Aվx   AվY   Aվ:   Aվ   Aվ   Aվ   Aվ   Aվ   Aվ   Aվa   AվB   Aվ#   Aվ   Aվ   Aվ   Aվ   Aվ   Aվi   AվJ   Aվ+   Aվ   Aվ   Aվ   Aվ   Aվ   Aվq   AվR   Aվ3   Aվ   Aվ   Aվ   Aվ   Aվ   Aվy   AվZ   Aվ;   Aվ   Aվ   Aվ   Aվ   Aվ   Aվ   Aվb   AվC   Aվ$   Aվ   Aվ   Aվ   Aվ   Aվ   Aվj   AվK   Aվ,   Aվ
   Aվ   Aվ   Aվ   Aվ   Aվr   AվS   Aվ4   Aվ   Aվ   Aվ   Aվ   Aվ   Aվz   Aվ[   Aվ<   Aվ   Aվ   Aվ   Aվ   Aվơ   Aվǂ   Aվc   AվD   Aվ%   Aվ   Aվ   Aվ   Aվͩ   AվΊ   Aվk   AվL   Aվ-   Aվ   Aվ   Aվ   AվԱ   AվՒ   Aվs   AվT   Aվ5   Aվ   Aվ   Aվ   Aվ۹   Aվܚ   Aվ{   Aվ\   Aվ=   Aվ   Aվ   Aվ   Aվ   Aվ   Aվ   Aվd   AվE   Aվ&   Aվ   Aվ   Aվ   Aվ   Aվ   Aվl   AվM   Aվ.   Aվ   Aվ   Aվ   Aվ   Aվ   Aվt   AվU   Aվ6   Aվ   Aվ   Aվ   Aվ   Aվ   Aվ|   Aվ]   Aվ>   Aվ   Aվ    Aվ   Aվ   Aտ    Aտ   Aտe   AտF   Aտ'   Aտ   Aտ   Aտ   Aտ   Aտ   Aտ	m   Aտ
N   Aտ/   Aտ   Aտ   Aտ
   Aտ   Aտ   Aտu   AտV   Aտ7   Aտ   Aտ   Aտ   Aտ   Aտ   Aտ}   Aտ^   Aտ?   Aտ    Aտ   Aտ   Aտ   Aտ   Aտ   Aտf   Aտ G   Aտ!(   Aտ"	   Aտ"   Aտ#   Aտ$   Aտ%   Aտ&n   Aտ'O   Aտ(0   Aտ)   Aտ)   Aտ*   Aտ+   Aտ,   Aտ-v   Aտ.W   Aտ/8   Aտ0   Aտ0   Aտ1   Aտ2   Aտ3   Aտ4~   Aտ5_   Aտ6@   Aտ7!   Aտ8   Aտ8   Aտ9   Aտ:   Aտ;   Aտ<g   Aտ=H   Aտ>)   Aտ?
   Aտ?   Aտ@   AտA   AտB   AտCo   AտDP   AտE1   AտF   AտF   AտG   AտH   AտI   AտJw   AտKX   AտL9   AտM   AտM   AտN   AտO   AտP   AտQ   AտR`   AտSA   AտT"   AտU   AտU   AտV   AտW   AտX   AտYh   AտZI   Aտ[*   Aտ\   Aտ\   Aտ]   Aտ^   Aտ_   Aտ`p   AտaQ   Aտb2   Aտc   Aտc   Aտd   Aտe   Aտf   Aտgx   AտhY   Aտi:   Aտj   Aտj   Aտk   Aտl   Aտm   Aտn   Aտoa   AտpB   Aտq#   Aտr   Aտr   Aտs   Aտt   Aտu   Aտvi   AտwJ   Aտx+   Aտy   Aտy   Aտz   Aտ{   Aտ|   Aտ}q   Aտ~R   Aտ3   Aտ   Aտ   Aտ   Aտ   Aտ   Aտy   AտZ   Aտ;   Aտ   Aտ   Aտ   Aտ   Aտ   Aտ   Aտb   AտC   Aտ$   Aտ   Aտ   Aտ   Aտ   Aտ   Aտj   AտK   Aտ,   Aտ
   Aտ   Aտ   Aտ   Aտ   Aտr   AտS   Aտ4   Aտ   Aտ   Aտ   Aտ   Aտ   Aտz   Aտ[   Aտ<   Aտ   Aտ   Aտ   Aտ   Aտ   Aտ   Aտc   AտD   Aտ%   Aտ   Aտ   Aտ   Aտ   Aտ   Aտk   AտL   Aտ-   Aտ   Aտ   Aտ   Aտ   Aտ   Aտs   AտT   Aտ5   Aտ   Aտ   Aտ   Aտ   Aտ   Aտ{   Aտ\   Aտ=   Aտ   Aտ   Aտ   Aտ   AտĢ   AտŃ   Aտd   AտE   Aտ&   Aտ   Aտ   Aտ   Aտ˪   Aտ̋   Aտl   AտM   Aտ.   Aտ   Aտ   Aտ   AտҲ   Aտӓ   Aտt   AտU   Aտ6   Aտ   Aտ   Aտ   Aտٺ   Aտڛ   Aտ|   Aտ]   Aտ>   Aտ   Aտ    Aտ   Aտ   Aտ   Aտ   Aտe   AտF   Aտ'   Aտ   Aտ   Aտ   Aտ   Aտ   Aտm   AտN   Aտ/   Aտ   Aտ   Aտ   Aտ   Aտ   Aտu   AտV   Aտ7   Aտ   Aտ   Aտ   Aտ   Aտ   Aտ}   Aտ^   Aտ?   Aտ    Aտ   Aտ   Aտ   Aտ   Aտ   A f   AG   A(   A	   A   A   A   A   An   AO   A	0   A
   A
   A   A   A
   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A 
   A    A!   A"   A#   A$o   A%P   A&1   A'   A'   A(   A)   A*   A+w   A,X   A-9   A.   A.   A/   A0   A1   A2   A3`   A4A   A5"   A6   A6   A7   A8   A9   A:h   A;I   A<*   A=   A=   A>   A?   A@   AAp   ABQ   AC2   AD   AD   AE   AF   AG   AHx   AIY   AJ:   AK   AK   AL   AM   AN   AO   APa   AQB   AR#   AS   AS   AT   AU   AV   AWi   AXJ   AY+   AZ   AZ   A[   A\   A]   A^q   A_R   A`3   Aa   Aa   Ab   Ac   Ad   Aey   AfZ   Ag;   Ah   Ah   Ai   Aj   Ak   Al   Amb   AnC   Ao$   Ap   Ap   Aq   Ar   As   Atj   AuK   Av,   Aw
   Aw   Ax   Ay   Az   A{r   A|S   A}4   A~   A~   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A£   AÄ   Ae   AF   A'   A   A   A   Aɫ   Aʌ   Am   AN   A/   A   A   A   Aг   Aє   Au   AV   A7   A   A   A   A׻   A؜   A}   A^   A?   A    A   A   A   Aߤ   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A )   A
   A   A   A   A   Ao   AP   A1   A   A   A	   A
   A   Aw   A
X   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A    A!   A"p   A#Q   A$2   A%   A%   A&   A'   A(   A)x   A*Y   A+:   A,   A,   A-   A.   A/   A0   A1a   A2B   A3#   A4   A4   A5   A6   A7   A8i   A9J   A:+   A;   A;   A<   A=   A>   A?q   A@R   AA3   AB   AB   AC   AD   AE   AFy   AGZ   AH;   AI   AI   AJ   AK   AL   AM   ANb   AOC   AP$   AQ   AQ   AR   AS   AT   AUj   AVK   AW,   AX
   AX   AY   AZ   A[   A\r   A]S   A^4   A_   A_   A`   Aa   Ab   Acz   Ad[   Ae<   Af   Af   Ag   Ah   Ai   Aj   Akc   AlD   Am%   An   An   Ao   Ap   Aq   Ark   AsL   At-   Au   Au   Av   Aw   Ax   Ays   AzT   A{5   A|   A|   A}   A~   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   AǬ   Aȍ   An   AO   A0   A   A   A   Aδ   Aϕ   Av   AW   A8   A   A   A   Aռ   A֝   A~   A_   A@   A!   A   A   A   Aݥ   Aކ   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A    A   A   Ap   AQ   A2   A   A   A   A   A	   A
x   AY   A:   A
   A
   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   A q   A!R   A"3   A#   A#   A$   A%   A&   A'y   A(Z   A);   A*   A*   A+   A,   A-   A.   A/b   A0C   A1$   A2   A2   A3   A4   A5   A6j   A7K   A8,   A9
   A9   A:   A;   A<   A=r   A>S   A?4   A@   A@   AA   AB   AC   ADz   AE[   AF<   AG   AG   AH   AI   AJ   AK   ALc   AMD   AN%   AO   AO   AP   AQ   AR   ASk   ATL   AU-   AV   AV   AW   AX   AY   AZs   A[T   A\5   A]   A]   A^   A_   A`   Aa{   Ab\   Ac=   Ad   Ad   Ae   Af   Ag   Ah   Aid   AjE   Ak&   Al   Al   Am   An   Ao   Apl   AqM   Ar.   As   As   At   Au   Av   Awt   AxU   Ay6   Az   Az   A{   A|   A}   A~|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A    A¡   A¢   A£f   A¤G   A¥(   A¦	   A¦   A§   A¨   A©   Aªn   A«O   A¬0   A­   A­   A®   A¯   A°   A±v   A²W   A³8   A´   A´   Aµ   A¶   A·   A¸~   A¹_   Aº@   A»!   A¼   A¼   A½   A¾   A¿   Ag   AH   A)   A
   A   A   Aŭ   AƎ   Ao   AP   A1   A   A   A   A̵   A͖   Aw   AX   A9   A   A   A   Aӽ   AԞ   A   A`   AA   A"   A   A   A   Aۦ   A܇   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A    Aq   AR   A3   A   A   A   A   A   Ay   A	Z   A
;   A   A   A   A
   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A 4   A!   A!   A"   A#   A$   A%z   A&[   A'<   A(   A(   A)   A*   A+   A,   A-c   A.D   A/%   A0   A0   A1   A2   A3   A4k   A5L   A6-   A7   A7   A8   A9   A:   A;s   A<T   A=5   A>   A>   A?   A@   AA   AB{   AC\   AD=   AE   AE   AF   AG   AH   AI   AJd   AKE   AL&   AM   AM   AN   AO   AP   AQl   ARM   AS.   AT   AT   AU   AV   AW   AXt   AYU   AZ6   A[   A[   A\   A]   A^   A_|   A`]   Aa>   Ab   Ac    Ac   Ad   Ae   Af   Age   AhF   Ai'   Aj   Aj   Ak   Al   Am   Anm   AoN   Ap/   Aq   Aq   Ar   As   At   Auu   AvV   Aw7   Ax   Ax   Ay   Az   A{   A|}   A}^   A~?   A    AÀ   AÀ   AÁ   AÂ   AÃ   AÄf   AÅG   AÆ(   AÇ	   AÇ   AÈ   AÉ   AÊ   AËn   AÌO   AÍ0   AÎ   AÎ   AÏ   AÐ   AÑ   AÒv   AÓW   AÔ8   AÕ   AÕ   AÖ   A×   AØ   AÙ~   AÚ_   AÛ@   AÜ!   AÝ   AÝ   AÞ   Aß   Aà   Aág   AâH   Aã)   Aä
   Aä   Aå   Aæ   Aç   Aèo   AéP   Aê1   Aë   Aë   Aì   Aí   Aî   Aïw   AðX   Añ9   Aò   Aò   Aó   Aô   Aõ   Aö   A÷`   AøA   Aù"   Aú   Aú   Aû   Aü   Aý   Aþh   AÿI   A*   A   A   A   Aî   Aď   Ap   AQ   A2   A   A   A   Aʶ   A˗   Ax   AY   A:   A   A   A   AѾ   Aҟ   AӀ   Aa   AB   A#   A   A   A   A٧   Aڈ   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   A S   A4   A   A   A   A   A   Az   A[   A<   A	   A	   A
   A   A   A
   Ac   AD   A%   A   A   A   A   A   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A    A!   A"   A#{   A$\   A%=   A&   A&   A'   A(   A)   A*   A+d   A,E   A-&   A.   A.   A/   A0   A1   A2l   A3M   A4.   A5   A5   A6   A7   A8   A9t   A:U   A;6   A<   A<   A=   A>   A?   A@|   AA]   AB>   AC   AD    AD   AE   AF   AG   AHe   AIF   AJ'   AK   AK   AL   AM   AN   AOm   APN   AQ/   AR   AR   AS   AT   AU   AVu   AWV   AX7   AY   AY   AZ   A[   A\   A]}   A^^   A_?   A`    Aa   Aa   Ab   Ac   Ad   Aef   AfG   Ag(   Ah	   Ah   Ai   Aj   Ak   Aln   AmO   An0   Ao   Ao   Ap   Aq   Ar   Asv   AtW   Au8   Av   Av   Aw   Ax   Ay   Az~   A{_   A|@   A}!   A~   A~   A   AĀ   Aā   AĂg   AăH   AĄ)   Aą
   Aą   AĆ   Ać   AĈ   Aĉo   AĊP   Aċ1   AČ   AČ   Ač   AĎ   Aď   AĐw   AđX   AĒ9   Aē   Aē   AĔ   Aĕ   AĖ   Aė   AĘ`   AęA   AĚ"   Aě   Aě   AĜ   Aĝ   AĞ   Ağh   AĠI   Aġ*   AĢ   AĢ   Aģ   AĤ   Aĥ   AĦp   AħQ   AĨ2   Aĩ   Aĩ   AĪ   Aī   AĬ   Aĭx   AĮY   Aį:   Aİ   Aİ   Aı   AĲ   Aĳ   AĴ   Aĵa   AĶB   Aķ#   Aĸ   Aĸ   AĹ   Aĺ   AĻ   Aļi   AĽJ   Aľ+   AĿ   AĿ   A   A   A   Aq   AR   A3   A   A   A   Aȷ   Aɘ   Ay   AZ   A;   A   A   A   AϿ   AР   Aс   Ab   AC   A$   A   A   A   Aר   A؉   Aj   AK   A,   A
   A   A   Aް   Aߑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A    A    A   A   A   A{   A\   A=   A   A   A   A	   A
   A   Ad   A
E   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A    A!|   A"]   A#>   A$   A%    A%   A&   A'   A(   A)e   A*F   A+'   A,   A,   A-   A.   A/   A0m   A1N   A2/   A3   A3   A4   A5   A6   A7u   A8V   A97   A:   A:   A;   A<   A=   A>}   A?^   A@?   AA    AB   AB   AC   AD   AE   AFf   AGG   AH(   AI	   AI   AJ   AK   AL   AMn   ANO   AO0   AP   AP   AQ   AR   AS   ATv   AUW   AV8   AW   AW   AX   AY   AZ   A[~   A\_   A]@   A^!   A_   A_   A`   Aa   Ab   Acg   AdH   Ae)   Af
   Af   Ag   Ah   Ai   Ajo   AkP   Al1   Am   Am   An   Ao   Ap   Aqw   ArX   As9   At   At   Au   Av   Aw   Ax   Ay`   AzA   A{"   A|   A|   A}   A~   A   Aŀh   AŁI   Ał*   AŃ   AŃ   Ań   AŅ   Aņ   AŇp   AňQ   Aŉ2   AŊ   AŊ   Aŋ   AŌ   Aō   AŎx   AŏY   AŐ:   Aő   Aő   AŒ   Aœ   AŔ   Aŕ   AŖa   AŗB   AŘ#   Ař   Ař   AŚ   Aś   AŜ   Aŝi   AŞJ   Aş+   AŠ   AŠ   Aš   AŢ   Aţ   AŤq   AťR   AŦ3   Aŧ   Aŧ   AŨ   Aũ   AŪ   Aūy   AŬZ   Aŭ;   AŮ   AŮ   Aů   AŰ   Aű   AŲ   Aųb   AŴC   Aŵ$   AŶ   AŶ   Aŷ   AŸ   AŹ   Aźj   AŻK   Aż,   AŽ
   AŽ   Až   Aſ   A   Ar   AS   A4   A   A   A   AƸ   AǙ   Az   A[   A<   A   A   A   A   AΡ   Aς   Ac   AD   A%   A   A   A   Aթ   A֊   Ak   AL   A-   A   A   A   Aܱ   Aݒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A    A   A|   A]   A>   A   A    A   A   A   A	   A
e   AF   A'   A
   A
   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A ^   A!?   A"    A#   A#   A$   A%   A&   A'f   A(G   A)(   A*	   A*   A+   A,   A-   A.n   A/O   A00   A1   A1   A2   A3   A4   A5v   A6W   A78   A8   A8   A9   A:   A;   A<~   A=_   A>@   A?!   A@   A@   AA   AB   AC   ADg   AEH   AF)   AG
   AG   AH   AI   AJ   AKo   ALP   AM1   AN   AN   AO   AP   AQ   ARw   ASX   AT9   AU   AU   AV   AW   AX   AY   AZ`   A[A   A\"   A]   A]   A^   A_   A`   Aah   AbI   Ac*   Ad   Ad   Ae   Af   Ag   Ahp   AiQ   Aj2   Ak   Ak   Al   Am   An   Aox   ApY   Aq:   Ar   Ar   As   At   Au   Av   Awa   AxB   Ay#   Az   Az   A{   A|   A}   A~i   AJ   Aƀ+   AƁ   AƁ   AƂ   Aƃ   AƄ   Aƅq   AƆR   AƇ3   Aƈ   Aƈ   AƉ   AƊ   AƋ   Aƌy   AƍZ   AƎ;   AƏ   AƏ   AƐ   AƑ   Aƒ   AƓ   AƔb   AƕC   AƖ$   AƗ   AƗ   AƘ   Aƙ   Aƚ   Aƛj   AƜK   AƝ,   Aƞ
   Aƞ   AƟ   AƠ   Aơ   AƢr   AƣS   AƤ4   Aƥ   Aƥ   AƦ   AƧ   Aƨ   AƩz   Aƪ[   Aƫ<   AƬ   AƬ   Aƭ   AƮ   AƯ   Aư   AƱc   AƲD   AƳ%   Aƴ   Aƴ   AƵ   Aƶ   AƷ   AƸk   AƹL   Aƺ-   Aƻ   Aƻ   AƼ   Aƽ   Aƾ   Aƿs   AT   A5   A   A   A   AĹ   AŚ   A{   A\   A=   A   A   A   A   A̢   A̓   Ad   AE   A&   A   A   A   AӪ   Aԋ   Al   AM   A.   A   A   A   Aڲ   Aۓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A }   A^   A?   A    A   A   A   A   A   Af   A	G   A
(   A	   A   A   A
   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A !   A!   A!   A"   A#   A$   A%g   A&H   A')   A(
   A(   A)   A*   A+   A,o   A-P   A.1   A/   A/   A0   A1   A2   A3w   A4X   A59   A6   A6   A7   A8   A9   A:   A;`   A<A   A="   A>   A>   A?   A@   AA   ABh   ACI   AD*   AE   AE   AF   AG   AH   AIp   AJQ   AK2   AL   AL   AM   AN   AO   APx   AQY   AR:   AS   AS   AT   AU   AV   AW   AXa   AYB   AZ#   A[   A[   A\   A]   A^   A_i   A`J   Aa+   Ab   Ab   Ac   Ad   Ae   Afq   AgR   Ah3   Ai   Ai   Aj   Ak   Al   Amy   AnZ   Ao;   Ap   Ap   Aq   Ar   As   At   Aub   AvC   Aw$   Ax   Ax   Ay   Az   A{   A|j   A}K   A~,   A
   A   Aǀ   Aǁ   Aǂ   Aǃr   AǄS   Aǅ4   Aǆ   Aǆ   AǇ   Aǈ   Aǉ   AǊz   Aǋ[   Aǌ<   AǍ   AǍ   Aǎ   AǏ   Aǐ   AǑ   Aǒc   AǓD   Aǔ%   AǕ   AǕ   Aǖ   AǗ   Aǘ   AǙk   AǚL   AǛ-   Aǜ   Aǜ   Aǝ   AǞ   Aǟ   AǠs   AǡT   AǢ5   Aǣ   Aǣ   AǤ   Aǥ   AǦ   Aǧ{   AǨ\   Aǩ=   AǪ   AǪ   Aǫ   AǬ   Aǭ   AǮ   Aǯd   AǰE   AǱ&   Aǲ   Aǲ   Aǳ   AǴ   Aǵ   AǶl   AǷM   AǸ.   Aǹ   Aǹ   AǺ   Aǻ   AǼ   Aǽt   AǾU   Aǿ6   A   A   A   Aº   AÛ   A|   A]   A>   A   A    A   A   Aʣ   A˄   Ae   AF   A'   A   A   A   Aѫ   AҌ   Am   AN   A/   A   A   A   Aس   Aٔ   Au   AV   A7   A   A   A   A߻   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A @   A!   A   A   A   A   A   Ag   AH   A)   A	
   A	   A
   A   A   A
o   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A    A!   A"   A#h   A$I   A%*   A&   A&   A'   A(   A)   A*p   A+Q   A,2   A-   A-   A.   A/   A0   A1x   A2Y   A3:   A4   A4   A5   A6   A7   A8   A9a   A:B   A;#   A<   A<   A=   A>   A?   A@i   AAJ   AB+   AC   AC   AD   AE   AF   AGq   AHR   AI3   AJ   AJ   AK   AL   AM   ANy   AOZ   AP;   AQ   AQ   AR   AS   AT   AU   AVb   AWC   AX$   AY   AY   AZ   A[   A\   A]j   A^K   A_,   A`
   A`   Aa   Ab   Ac   Adr   AeS   Af4   Ag   Ag   Ah   Ai   Aj   Akz   Al[   Am<   An   An   Ao   Ap   Aq   Ar   Asc   AtD   Au%   Av   Av   Aw   Ax   Ay   Azk   A{L   A|-   A}   A}   A~   A   AȀ   Aȁs   AȂT   Aȃ5   AȄ   AȄ   Aȅ   AȆ   Aȇ   AȈ{   Aȉ\   AȊ=   Aȋ   Aȋ   AȌ   Aȍ   AȎ   Aȏ   AȐd   AȑE   AȒ&   Aȓ   Aȓ   AȔ   Aȕ   AȖ   Aȗl   AȘM   Aș.   AȚ   AȚ   Aț   AȜ   Aȝ   AȞt   AȟU   AȠ6   Aȡ   Aȡ   AȢ   Aȣ   AȤ   Aȥ|   AȦ]   Aȧ>   AȨ   Aȩ    Aȩ   AȪ   Aȫ   AȬ   Aȭe   AȮF   Aȯ'   AȰ   AȰ   Aȱ   AȲ   Aȳ   Aȴm   AȵN   Aȶ/   Aȷ   Aȷ   Aȸ   Aȹ   AȺ   AȻu   AȼV   AȽ7   AȾ   AȾ   Aȿ   A   A   A}   A^   A?   A    A   A   A   AȤ   AɅ   Af   AG   A(   A	   A   A   AϬ   AЍ   An   AO   A0   A   A   A   Aִ   Aו   Av   AW   A8   A   A   A   Aݼ   Aޝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A    A    A   A   A   Ah   AI   A*   A   A   A   A	   A
   Ap   AQ   A
2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A    A!i   A"J   A#+   A$   A$   A%   A&   A'   A(q   A)R   A*3   A+   A+   A,   A-   A.   A/y   A0Z   A1;   A2   A2   A3   A4   A5   A6   A7b   A8C   A9$   A:   A:   A;   A<   A=   A>j   A?K   A@,   AA
   AA   AB   AC   AD   AEr   AFS   AG4   AH   AH   AI   AJ   AK   ALz   AM[   AN<   AO   AO   AP   AQ   AR   AS   ATc   AUD   AV%   AW   AW   AX   AY   AZ   A[k   A\L   A]-   A^   A^   A_   A`   Aa   Abs   AcT   Ad5   Ae   Ae   Af   Ag   Ah   Ai{   Aj\   Ak=   Al   Al   Am   An   Ao   Ap   Aqd   ArE   As&   At   At   Au   Av   Aw   Axl   AyM   Az.   A{   A{   A|   A}   A~   At   AɀU   AɁ6   Aɂ   Aɂ   AɃ   AɄ   AɅ   AɆ|   Aɇ]   AɈ>   Aɉ   AɊ    AɊ   Aɋ   AɌ   Aɍ   AɎe   AɏF   Aɐ'   Aɑ   Aɑ   Aɒ   Aɓ   Aɔ   Aɕm   AɖN   Aɗ/   Aɘ   Aɘ   Aə   Aɚ   Aɛ   Aɜu   AɝV   Aɞ7   Aɟ   Aɟ   Aɠ   Aɡ   Aɢ   Aɣ}   Aɤ^   Aɥ?   Aɦ    Aɧ   Aɧ   Aɨ   Aɩ   Aɪ   Aɫf   AɬG   Aɭ(   Aɮ	   Aɮ   Aɯ   Aɰ   Aɱ   Aɲn   AɳO   Aɴ0   Aɵ   Aɵ   Aɶ   Aɷ   Aɸ   Aɹv   AɺW   Aɻ8   Aɼ   Aɼ   Aɽ   Aɾ   Aɿ   A~   A_   A@   A!   A   A   A   Aƥ   Aǆ   Ag   AH   A)   A
   A   A   Aͭ   AΎ   Ao   AP   A1   A   A   A   AԵ   AՖ   Aw   AX   A9   A   A   A   A۽   Aܞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A    A   Ai   AJ   A+   A   A   A   A   A   A	q   A
R   A3   A   A   A
   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   A K   A!,   A"
   A"   A#   A$   A%   A&r   A'S   A(4   A)   A)   A*   A+   A,   A-z   A.[   A/<   A0   A0   A1   A2   A3   A4   A5c   A6D   A7%   A8   A8   A9   A:   A;   A<k   A=L   A>-   A?   A?   A@   AA   AB   ACs   ADT   AE5   AF   AF   AG   AH   AI   AJ{   AK\   AL=   AM   AM   AN   AO   AP   AQ   ARd   ASE   AT&   AU   AU   AV   AW   AX   AYl   AZM   A[.   A\   A\   A]   A^   A_   A`t   AaU   Ab6   Ac   Ac   Ad   Ae   Af   Ag|   Ah]   Ai>   Aj   Ak    Ak   Al   Am   An   Aoe   ApF   Aq'   Ar   Ar   As   At   Au   Avm   AwN   Ax/   Ay   Ay   Az   A{   A|   A}u   A~V   A7   Aʀ   Aʀ   Aʁ   Aʂ   Aʃ   Aʄ}   Aʅ^   Aʆ?   Aʇ    Aʈ   Aʈ   Aʉ   Aʊ   Aʋ   Aʌf   AʍG   Aʎ(   Aʏ	   Aʏ   Aʐ   Aʑ   Aʒ   Aʓn   AʔO   Aʕ0   Aʖ   Aʖ   Aʗ   Aʘ   Aʙ   Aʚv   AʛW   Aʜ8   Aʝ   Aʝ   Aʞ   Aʟ   Aʠ   Aʡ~   Aʢ_   Aʣ@   Aʤ!   Aʥ   Aʥ   Aʦ   Aʧ   Aʨ   Aʩg   AʪH   Aʫ)   Aʬ
   Aʬ   Aʭ   Aʮ   Aʯ   Aʰo   AʱP   Aʲ1   Aʳ   Aʳ   Aʴ   Aʵ   Aʶ   Aʷw   AʸX   Aʹ9   Aʺ   Aʺ   Aʻ   Aʼ   Aʽ   Aʾ   Aʿ`   AA   A"   A   A   A   AĦ   AŇ   Ah   AI   A*   A   A   A   Aˮ   Ȁ   Ap   AQ   A2   A   A   A   AҶ   Aӗ   Ax   AY   A:   A   A   A   Aپ   Aڟ   Aۀ   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   A j   AK   A,   A
   A   A   A   A   Ar   AS   A	4   A
   A
   A   A   A
   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A    A    A!   A"   A#   A$s   A%T   A&5   A'   A'   A(   A)   A*   A+{   A,\   A-=   A.   A.   A/   A0   A1   A2   A3d   A4E   A5&   A6   A6   A7   A8   A9   A:l   A;M   A<.   A=   A=   A>   A?   A@   AAt   ABU   AC6   AD   AD   AE   AF   AG   AH|   AI]   AJ>   AK   AL    AL   AM   AN   AO   APe   AQF   AR'   AS   AS   AT   AU   AV   AWm   AXN   AY/   AZ   AZ   A[   A\   A]   A^u   A_V   A`7   Aa   Aa   Ab   Ac   Ad   Ae}   Af^   Ag?   Ah    Ai   Ai   Aj   Ak   Al   Amf   AnG   Ao(   Ap	   Ap   Aq   Ar   As   Atn   AuO   Av0   Aw   Aw   Ax   Ay   Az   A{v   A|W   A}8   A~   A~   A   Aˀ   Aˁ   A˂~   A˃_   A˄@   A˅!   Aˆ   Aˆ   Aˇ   Aˈ   Aˉ   Aˊg   AˋH   Aˌ)   Aˍ
   Aˍ   Aˎ   Aˏ   Aː   Aˑo   A˒P   A˓1   A˔   A˔   A˕   A˖   A˗   A˘w   A˙X   A˚9   A˛   A˛   A˜   A˝   A˞   A˟   Aˠ`   AˡA   Aˢ"   Aˣ   Aˣ   Aˤ   A˥   A˦   A˧h   A˨I   A˩*   A˪   A˪   A˫   Aˬ   A˭   Aˮp   A˯Q   A˰2   A˱   A˱   A˲   A˳   A˴   A˵x   A˶Y   A˷:   A˸   A˸   A˹   A˺   A˻   A˼   A˽a   A˾B   A˿#   A   A   A   A§   AÈ   Ai   AJ   A+   A   A   A   Aɯ   Aʐ   Aq   AR   A3   A   A   A   Aз   Aј   Ay   AZ   A;   A   A   A   A׿   Aؠ   Aف   Ab   AC   A$   A   A   A   Aߨ   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A -   A   A   A   A   A   As   AT   A5   A   A   A	   A
   A   A{   A
\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A    A!   A"t   A#U   A$6   A%   A%   A&   A'   A(   A)|   A*]   A+>   A,   A-    A-   A.   A/   A0   A1e   A2F   A3'   A4   A4   A5   A6   A7   A8m   A9N   A:/   A;   A;   A<   A=   A>   A?u   A@V   AA7   AB   AB   AC   AD   AE   AF}   AG^   AH?   AI    AJ   AJ   AK   AL   AM   ANf   AOG   AP(   AQ	   AQ   AR   AS   AT   AUn   AVO   AW0   AX   AX   AY   AZ   A[   A\v   A]W   A^8   A_   A_   A`   Aa   Ab   Ac~   Ad_   Ae@   Af!   Ag   Ag   Ah   Ai   Aj   Akg   AlH   Am)   An
   An   Ao   Ap   Aq   Aro   AsP   At1   Au   Au   Av   Aw   Ax   Ayw   AzX   A{9   A|   A|   A}   A~   A   À   Á`   ÂA   Ã"   Ā   Ā   A̅   Ă   Ȧ   Äh   ẢI   Å*   A̋   A̋   Ǎ   A̍   A̎   Ȁp   A̐Q   Ȃ2   A̒   A̒   A̓   A̔   A̕   A̖x   A̗Y   A̘:   A̙   A̙   A̚   A̛   A̜   A̝   A̞a   A̟B   A̠#   A̡   A̡   A̢   Ạ   A̤   Ḁi   A̦J   A̧+   Ą   Ą   A̩   A̪   A̫   A̬q   A̭R   A̮3   A̯   A̯   A̰   A̱   A̲   A̳y   A̴Z   A̵;   A̶   A̶   A̷   A̸   A̹   A̺   A̻b   A̼C   A̽$   A̾   A̾   A̿   A   A   Aj   AK   A,   A
   A   A   Aǰ   Aȑ   Ar   AS   A4   A   A   A   Aθ   Aϙ   Az   A[   A<   A   A   A   A   A֡   Aׂ   Ac   AD   A%   A   A   A   Aݩ   Aފ   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A    A   A   At   AU   A6   A   A   A   A   A	   A
|   A]   A>   A
   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   A u   A!V   A"7   A#   A#   A$   A%   A&   A'}   A(^   A)?   A*    A+   A+   A,   A-   A.   A/f   A0G   A1(   A2	   A2   A3   A4   A5   A6n   A7O   A80   A9   A9   A:   A;   A<   A=v   A>W   A?8   A@   A@   AA   AB   AC   AD~   AE_   AF@   AG!   AH   AH   AI   AJ   AK   ALg   AMH   AN)   AO
   AO   AP   AQ   AR   ASo   ATP   AU1   AV   AV   AW   AX   AY   AZw   A[X   A\9   A]   A]   A^   A_   A`   Aa   Ab`   AcA   Ad"   Ae   Ae   Af   Ag   Ah   Aih   AjI   Ak*   Al   Al   Am   An   Ao   App   AqQ   Ar2   As   As   At   Au   Av   Awx   AxY   Ay:   Az   Az   A{   A|   A}   A~   Aa   ÀB   Á#   A͂   A͂   A̓   Ä́   Aͅ   A͆i   A͇J   A͈+   A͉   A͉   A͊   A͋   A͌   A͍q   A͎R   A͏3   A͐   A͐   A͑   A͒   A͓   A͔y   A͕Z   A͖;   A͗   A͗   A͘   A͙   A͚   A͛   A͜b   A͝C   A͞$   A͟   A͟   A͠   A͡   A͢   Aͣj   AͤK   Aͥ,   Aͦ
   Aͦ   Aͧ   Aͨ   Aͩ   Aͪr   AͫS   Aͬ4   Aͭ   Aͭ   Aͮ   Aͯ   AͰ   Aͱz   AͲ[   Aͳ<   Aʹ   Aʹ   A͵   AͶ   Aͷ   A͸   A͹c   AͺD   Aͻ%   Aͼ   Aͼ   Aͽ   A;   AͿ   Ak   AL   A-   A   A   A   Aű   Aƒ   As   AT   A5   A   A   A   A̹   A͚   A{   A\   A=   A   A   A   A   AԢ   AՃ   Ad   AE   A&   A   A   A   A۪   A܋   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A    Au   AV   A7   A   A   A   A   A   A}   A	^   A
?   A    A   A   A
   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A 8   A!   A!   A"   A#   A$   A%~   A&_   A'@   A(!   A)   A)   A*   A+   A,   A-g   A.H   A/)   A0
   A0   A1   A2   A3   A4o   A5P   A61   A7   A7   A8   A9   A:   A;w   A<X   A=9   A>   A>   A?   A@   AA   AB   AC`   ADA   AE"   AF   AF   AG   AH   AI   AJh   AKI   AL*   AM   AM   AN   AO   AP   AQp   ARQ   AS2   AT   AT   AU   AV   AW   AXx   AYY   AZ:   A[   A[   A\   A]   A^   A_   A`a   AaB   Ab#   Ac   Ac   Ad   Ae   Af   Agi   AhJ   Ai+   Aj   Aj   Ak   Al   Am   Anq   AoR   Ap3   Aq   Aq   Ar   As   At   Auy   AvZ   Aw;   Ax   Ax   Ay   Az   A{   A|   A}b   A~C   A$   A΀   A΀   A΁   A΂   A΃   A΄j   A΅K   AΆ,   A·
   A·   AΈ   AΉ   AΊ   A΋r   AΌS   A΍4   AΎ   AΎ   AΏ   Aΐ   AΑ   AΒz   AΓ[   AΔ<   AΕ   AΕ   AΖ   AΗ   AΘ   AΙ   AΚc   AΛD   AΜ%   AΝ   AΝ   AΞ   AΟ   AΠ   AΡk   A΢L   AΣ-   AΤ   AΤ   AΥ   AΦ   AΧ   AΨs   AΩT   AΪ5   AΫ   AΫ   Aά   Aέ   Aή   Aί{   Aΰ\   Aα=   Aβ   Aβ   Aγ   Aδ   Aε   Aζ   Aηd   AθE   Aι&   Aκ   Aκ   Aλ   Aμ   Aν   Aξl   AοM   A.   A   A   A   Aò   Aē   At   AU   A6   A   A   A   Aʺ   A˛   A|   A]   A>   A   A    A   A   Aң   Aӄ   Ae   AF   A'   A   A   A   A٫   Aڌ   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   A W   A8   A   A   A   A   A   A~   A_   A@   A	!   A
   A
   A   A   A
   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A    A!   A"   A#   A$`   A%A   A&"   A'   A'   A(   A)   A*   A+h   A,I   A-*   A.   A.   A/   A0   A1   A2p   A3Q   A42   A5   A5   A6   A7   A8   A9x   A:Y   A;:   A<   A<   A=   A>   A?   A@   AAa   ABB   AC#   AD   AD   AE   AF   AG   AHi   AIJ   AJ+   AK   AK   AL   AM   AN   AOq   APR   AQ3   AR   AR   AS   AT   AU   AVy   AWZ   AX;   AY   AY   AZ   A[   A\   A]   A^b   A_C   A`$   Aa   Aa   Ab   Ac   Ad   Aej   AfK   Ag,   Ah
   Ah   Ai   Aj   Ak   Alr   AmS   An4   Ao   Ao   Ap   Aq   Ar   Asz   At[   Au<   Av   Av   Aw   Ax   Ay   Az   A{c   A|D   A}%   A~   A~   A   Aπ   Aρ   Aςk   AσL   Aτ-   Aυ   Aυ   Aφ   Aχ   Aψ   Aωs   AϊT   Aϋ5   Aό   Aό   Aύ   Aώ   AϏ   Aϐ{   Aϑ\   Aϒ=   Aϓ   Aϓ   Aϔ   Aϕ   Aϖ   Aϗ   AϘd   AϙE   AϚ&   Aϛ   Aϛ   AϜ   Aϝ   AϞ   Aϟl   AϠM   Aϡ.   AϢ   AϢ   Aϣ   AϤ   Aϥ   AϦt   AϧU   AϨ6   Aϩ   Aϩ   AϪ   Aϫ   AϬ   Aϭ|   AϮ]   Aϯ>   Aϰ   Aϱ    Aϱ   Aϲ   Aϳ   Aϴ   Aϵe   A϶F   AϷ'   Aϸ   Aϸ   AϹ   AϺ   Aϻ   Aϼm   AϽN   AϾ/   AϿ   AϿ   A   A   A   Au   AV   A7   A   A   A   AȻ   Aɜ   A}   A^   A?   A    A   A   A   AФ   Aх   Af   AG   A(   A	   A   A   A׬   A؍   An   AO   A0   A   A   A   A޴   Aߕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A    A    A   A   A   A   A`   AA   A"   A   A   A	   A
   A   Ah   A
I   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A    A!   A"a   A#B   A$#   A%   A%   A&   A'   A(   A)i   A*J   A++   A,   A,   A-   A.   A/   A0q   A1R   A23   A3   A3   A4   A5   A6   A7y   A8Z   A9;   A:   A:   A;   A<   A=   A>   A?b   A@C   AA$   AB   AB   AC   AD   AE   AFj   AGK   AH,   AI
   AI   AJ   AK   AL   AMr   ANS   AO4   AP   AP   AQ   AR   AS   ATz   AU[   AV<   AW   AW   AX   AY   AZ   A[   A\c   A]D   A^%   A_   A_   A`   Aa   Ab   Ack   AdL   Ae-   Af   Af   Ag   Ah   Ai   Ajs   AkT   Al5   Am   Am   An   Ao   Ap   Aq{   Ar\   As=   At   At   Au   Av   Aw   Ax   Ayd   AzE   A{&   A|   A|   A}   A~   A   AЀl   AЁM   AЂ.   AЃ   AЃ   AЄ   AЅ   AІ   AЇt   AЈU   AЉ6   AЊ   AЊ   AЋ   AЌ   AЍ   AЎ|   AЏ]   AА>   AБ   AВ    AВ   AГ   AД   AЕ   AЖe   AЗF   AИ'   AЙ   AЙ   AК   AЛ   AМ   AНm   AОN   AП/   AР   AР   AС   AТ   AУ   AФu   AХV   AЦ7   AЧ   AЧ   AШ   AЩ   AЪ   AЫ}   AЬ^   AЭ?   AЮ    AЯ   AЯ   Aа   Aб   Aв   Aгf   AдG   Aе(   Aж	   Aж   Aз   Aи   Aй   Aкn   AлO   Aм0   Aн   Aн   Aо   Aп   A   Av   AW   A8   A   A   A   AƼ   Aǝ   A~   A_   A@   A!   A   A   A   AΥ   Aφ   Ag   AH   A)   A
   A   A   Aխ   A֎   Ao   AP   A1   A   A   A   Aܵ   Aݖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A    A   A   Aa   AB   A#   A   A   A   A   A	   A
i   AJ   A+   A
   A
   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   A b   A!C   A"$   A#   A#   A$   A%   A&   A'j   A(K   A),   A*
   A*   A+   A,   A-   A.r   A/S   A04   A1   A1   A2   A3   A4   A5z   A6[   A7<   A8   A8   A9   A:   A;   A<   A=c   A>D   A?%   A@   A@   AA   AB   AC   ADk   AEL   AF-   AG   AG   AH   AI   AJ   AKs   ALT   AM5   AN   AN   AO   AP   AQ   AR{   AS\   AT=   AU   AU   AV   AW   AX   AY   AZd   A[E   A\&   A]   A]   A^   A_   A`   Aal   AbM   Ac.   Ad   Ad   Ae   Af   Ag   Aht   AiU   Aj6   Ak   Ak   Al   Am   An   Ao|   Ap]   Aq>   Ar   As    As   At   Au   Av   Awe   AxF   Ay'   Az   Az   A{   A|   A}   A~m   AN   Aр/   Aс   Aс   Aт   Aу   Aф   Aхu   AцV   Aч7   Aш   Aш   Aщ   Aъ   Aы   Aь}   Aэ^   Aю?   Aя    Aѐ   Aѐ   Aё   Aђ   Aѓ   Aєf   AѕG   Aі(   Aї	   Aї   Aј   Aљ   Aњ   Aћn   AќO   Aѝ0   Aў   Aў   Aџ   AѠ   Aѡ   AѢv   AѣW   AѤ8   Aѥ   Aѥ   AѦ   Aѧ   AѨ   Aѩ~   AѪ_   Aѫ@   AѬ!   Aѭ   Aѭ   AѮ   Aѯ   AѰ   Aѱg   AѲH   Aѳ)   AѴ
   AѴ   Aѵ   AѶ   Aѷ   AѸo   AѹP   AѺ1   Aѻ   Aѻ   AѼ   Aѽ   AѾ   Aѿw   AX   A9   A   A   A   AĽ   AŞ   A   A`   AA   A"   A   A   A   A̦   A͇   Ah   AI   A*   A   A   A   AӮ   Aԏ   Ap   AQ   A2   A   A   A   Aڶ   Aۗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A    Ab   AC   A$   A   A   A   A   A   Aj   A	K   A
,   A
   A   A   A
   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A %   A!   A!   A"   A#   A$   A%k   A&L   A'-   A(   A(   A)   A*   A+   A,s   A-T   A.5   A/   A/   A0   A1   A2   A3{   A4\   A5=   A6   A6   A7   A8   A9   A:   A;d   A<E   A=&   A>   A>   A?   A@   AA   ABl   ACM   AD.   AE   AE   AF   AG   AH   AIt   AJU   AK6   AL   AL   AM   AN   AO   AP|   AQ]   AR>   AS   AT    AT   AU   AV   AW   AXe   AYF   AZ'   A[   A[   A\   A]   A^   A_m   A`N   Aa/   Ab   Ab   Ac   Ad   Ae   Afu   AgV   Ah7   Ai   Ai   Aj   Ak   Al   Am}   An^   Ao?   Ap    Aq   Aq   Ar   As   At   Auf   AvG   Aw(   Ax	   Ax   Ay   Az   A{   A|n   A}O   A~0   A   A   AҀ   Aҁ   A҂   A҃v   A҄W   A҅8   A҆   A҆   A҇   A҈   A҉   AҊ~   Aҋ_   AҌ@   Aҍ!   AҎ   AҎ   Aҏ   AҐ   Aґ   AҒg   AғH   AҔ)   Aҕ
   Aҕ   AҖ   Aҗ   AҘ   Aҙo   AҚP   Aқ1   AҜ   AҜ   Aҝ   AҞ   Aҟ   AҠw   AҡX   AҢ9   Aң   Aң   AҤ   Aҥ   AҦ   Aҧ   AҨ`   AҩA   AҪ"   Aҫ   Aҫ   AҬ   Aҭ   AҮ   Aүh   AҰI   Aұ*   AҲ   AҲ   Aҳ   AҴ   Aҵ   AҶp   AҷQ   AҸ2   Aҹ   Aҹ   AҺ   Aһ   AҼ   Aҽx   AҾY   Aҿ:   A   A   A   A¾   Aß   AĀ   Aa   AB   A#   A   A   A   Aʧ   Aˈ   Ai   AJ   A+   A   A   A   Aѯ   AҐ   Aq   AR   A3   A   A   A   Aط   A٘   Ay   AZ   A;   A   A   A   A߿   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   A D   A%   A   A   A   A   A   Ak   AL   A-   A	   A	   A
   A   A   A
s   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A    A!   A"   A#l   A$M   A%.   A&   A&   A'   A(   A)   A*t   A+U   A,6   A-   A-   A.   A/   A0   A1|   A2]   A3>   A4   A5    A5   A6   A7   A8   A9e   A:F   A;'   A<   A<   A=   A>   A?   A@m   AAN   AB/   AC   AC   AD   AE   AF   AGu   AHV   AI7   AJ   AJ   AK   AL   AM   AN}   AO^   AP?   AQ    AR   AR   AS   AT   AU   AVf   AWG   AX(   AY	   AY   AZ   A[   A\   A]n   A^O   A_0   A`   A`   Aa   Ab   Ac   Adv   AeW   Af8   Ag   Ag   Ah   Ai   Aj   Ak~   Al_   Am@   An!   Ao   Ao   Ap   Aq   Ar   Asg   AtH   Au)   Av
   Av   Aw   Ax   Ay   Azo   A{P   A|1   A}   A}   A~   A   AӀ   AӁw   AӂX   AӃ9   Aӄ   Aӄ   AӅ   Aӆ   AӇ   Aӈ   AӉ`   AӊA   AӋ"   Aӌ   Aӌ   AӍ   Aӎ   Aӏ   AӐh   AӑI   AӒ*   Aӓ   Aӓ   AӔ   Aӕ   AӖ   Aӗp   AӘQ   Aә2   AӚ   AӚ   Aӛ   AӜ   Aӝ   AӞx   AӟY   AӠ:   Aӡ   Aӡ   AӢ   Aӣ   AӤ   Aӥ   AӦa   AӧB   AӨ#   Aө   Aө   AӪ   Aӫ   AӬ   Aӭi   AӮJ   Aӯ+   AӰ   AӰ   Aӱ   AӲ   Aӳ   AӴq   AӵR   AӶ3   Aӷ   Aӷ   AӸ   Aӹ   AӺ   Aӻy   AӼZ   Aӽ;   AӾ   AӾ   Aӿ   A   A   A   Ab   AC   A$   A   A   A   AȨ   Aɉ   Aj   AK   A,   A
   A   A   Aϰ   AБ   Ar   AS   A4   A   A   A   Aָ   Aי   Az   A[   A<   A   A   A   A   Aޡ   A߂   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A    A    A   A   A   Al   AM   A.   A   A   A   A	   A
   At   AU   A
6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A    A!m   A"N   A#/   A$   A$   A%   A&   A'   A(u   A)V   A*7   A+   A+   A,   A-   A.   A/}   A0^   A1?   A2    A3   A3   A4   A5   A6   A7f   A8G   A9(   A:	   A:   A;   A<   A=   A>n   A?O   A@0   AA   AA   AB   AC   AD   AEv   AFW   AG8   AH   AH   AI   AJ   AK   AL~   AM_   AN@   AO!   AP   AP   AQ   AR   AS   ATg   AUH   AV)   AW
   AW   AX   AY   AZ   A[o   A\P   A]1   A^   A^   A_   A`   Aa   Abw   AcX   Ad9   Ae   Ae   Af   Ag   Ah   Ai   Aj`   AkA   Al"   Am   Am   An   Ao   Ap   Aqh   ArI   As*   At   At   Au   Av   Aw   Axp   AyQ   Az2   A{   A{   A|   A}   A~   Ax   AԀY   Aԁ:   AԂ   AԂ   Aԃ   AԄ   Aԅ   AԆ   Aԇa   AԈB   Aԉ#   AԊ   AԊ   Aԋ   AԌ   Aԍ   AԎi   AԏJ   AԐ+   Aԑ   Aԑ   AԒ   Aԓ   AԔ   Aԕq   AԖR   Aԗ3   AԘ   AԘ   Aԙ   AԚ   Aԛ   AԜy   AԝZ   AԞ;   Aԟ   Aԟ   AԠ   Aԡ   AԢ   Aԣ   AԤb   AԥC   AԦ$   Aԧ   Aԧ   AԨ   Aԩ   AԪ   Aԫj   AԬK   Aԭ,   AԮ
   AԮ   Aԯ   A԰   AԱ   AԲr   AԳS   AԴ4   AԵ   AԵ   AԶ   AԷ   AԸ   AԹz   AԺ[   AԻ<   AԼ   AԼ   AԽ   AԾ   AԿ   A   Ac   AD   A%   A   A   A   AƩ   AǊ   Ak   AL   A-   A   A   A   Aͱ   AΒ   As   AT   A5   A   A   A   AԹ   A՚   A{   A\   A=   A   A   A   A   Aܢ   A݃   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A    A   Am   AN   A/   A   A   A   A   A   A	u   A
V   A7   A   A   A
   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   A O   A!0   A"   A"   A#   A$   A%   A&v   A'W   A(8   A)   A)   A*   A+   A,   A-~   A._   A/@   A0!   A1   A1   A2   A3   A4   A5g   A6H   A7)   A8
   A8   A9   A:   A;   A<o   A=P   A>1   A?   A?   A@   AA   AB   ACw   ADX   AE9   AF   AF   AG   AH   AI   AJ   AK`   ALA   AM"   AN   AN   AO   AP   AQ   ARh   ASI   AT*   AU   AU   AV   AW   AX   AYp   AZQ   A[2   A\   A\   A]   A^   A_   A`x   AaY   Ab:   Ac   Ac   Ad   Ae   Af   Ag   Aha   AiB   Aj#   Ak   Ak   Al   Am   An   Aoi   ApJ   Aq+   Ar   Ar   As   At   Au   Avq   AwR   Ax3   Ay   Ay   Az   A{   A|   A}y   A~Z   A;   AՀ   AՀ   AՁ   AՂ   AՃ   AՄ   AՅb   AՆC   AՇ$   AՈ   AՈ   AՉ   AՊ   AՋ   AՌj   AՍK   AՎ,   AՏ
   AՏ   AՐ   AՑ   AՒ   AՓr   AՔS   AՕ4   AՖ   AՖ   A՗   A՘   Aՙ   A՚z   A՛[   A՜<   A՝   A՝   A՞   A՟   Aՠ   Aա   Aբc   AգD   Aդ%   Aե   Aե   Aզ   Aէ   Aը   Aթk   AժL   Aի-   Aլ   Aլ   Aխ   Aծ   Aկ   Aհs   AձT   Aղ5   Aճ   Aճ   Aմ   Aյ   Aն   Aշ{   Aո\   Aչ=   Aպ   Aպ   Aջ   Aռ   Aս   Aվ   Aտd   AE   A&   A   A   A   AĪ   Aŋ   Al   AM   A.   A   A   A   A˲   A̓   At   AU   A6   A   A   A   AҺ   Aӛ   A|   A]   A>   A   A    A   A   Aڣ   Aۄ   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   A n   AO   A0   A   A   A   A   A   Av   AW   A	8   A
   A
   A   A   A
   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A    A    A!   A"   A#   A$w   A%X   A&9   A'   A'   A(   A)   A*   A+   A,`   A-A   A."   A/   A/   A0   A1   A2   A3h   A4I   A5*   A6   A6   A7   A8   A9   A:p   A;Q   A<2   A=   A=   A>   A?   A@   AAx   ABY   AC:   AD   AD   AE   AF   AG   AH   AIa   AJB   AK#   AL   AL   AM   AN   AO   APi   AQJ   AR+   AS   AS   AT   AU   AV   AWq   AXR   AY3   AZ   AZ   A[   A\   A]   A^y   A_Z   A`;   Aa   Aa   Ab   Ac   Ad   Ae   Afb   AgC   Ah$   Ai   Ai   Aj   Ak   Al   Amj   AnK   Ao,   Ap
   Ap   Aq   Ar   As   Atr   AuS   Av4   Aw   Aw   Ax   Ay   Az   A{z   A|[   A}<   A~   A~   A   Aր   Aց   Aւ   Aփc   AքD   Aօ%   Aֆ   Aֆ   Aև   Aֈ   A։   A֊k   A֋L   A֌-   A֍   A֍   A֎   A֏   A֐   A֑s   A֒T   A֓5   A֔   A֔   A֕   A֖   A֗   A֘{   A֙\   A֚=   A֛   A֛   A֜   A֝   A֞   A֟   A֠d   A֡E   A֢&   A֣   A֣   A֤   A֥   A֦   A֧l   A֨M   A֩.   A֪   A֪   A֫   A֬   A֭   A֮t   A֯U   Aְ6   Aֱ   Aֱ   Aֲ   Aֳ   Aִ   Aֵ|   Aֶ]   Aַ>   Aָ   Aֹ    Aֹ   Aֺ   Aֻ   Aּ   Aֽe   A־F   Aֿ'   A   A   A   A«   AÌ   Am   AN   A/   A   A   A   Aɳ   Aʔ   Au   AV   A7   A   A   A   Aл   Aќ   A}   A^   A?   A    A   A   A   Aؤ   Aم   Af   AG   A(   A	   A   A   A߬   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A 1   A   A   A   A   A   Aw   AX   A9   A   A   A	   A
   A   A   A
`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A    A!   A"x   A#Y   A$:   A%   A%   A&   A'   A(   A)   A*a   A+B   A,#   A-   A-   A.   A/   A0   A1i   A2J   A3+   A4   A4   A5   A6   A7   A8q   A9R   A:3   A;   A;   A<   A=   A>   A?y   A@Z   AA;   AB   AB   AC   AD   AE   AF   AGb   AHC   AI$   AJ   AJ   AK   AL   AM   ANj   AOK   AP,   AQ
   AQ   AR   AS   AT   AUr   AVS   AW4   AX   AX   AY   AZ   A[   A\z   A][   A^<   A_   A_   A`   Aa   Ab   Ac   Adc   AeD   Af%   Ag   Ag   Ah   Ai   Aj   Akk   AlL   Am-   An   An   Ao   Ap   Aq   Ars   AsT   At5   Au   Au   Av   Aw   Ax   Ay{   Az\   A{=   A|   A|   A}   A~   A   A׀   Aׁd   AׂE   A׃&   Aׄ   Aׄ   Aׅ   A׆   Aׇ   A׈l   A׉M   A׊.   A׋   A׋   A׌   A׍   A׎   A׏t   AאU   Aב6   Aג   Aג   Aד   Aה   Aו   Aז|   Aח]   Aט>   Aי   Aך    Aך   Aכ   Aל   Aם   Aמe   AןF   Aנ'   Aס   Aס   Aע   Aף   Aפ   Aץm   AצN   Aק/   Aר   Aר   Aש   Aת   A׫   A׬u   A׭V   A׮7   Aׯ   Aׯ   Aװ   Aױ   Aײ   A׳}   A״^   A׵?   A׶    A׷   A׷   A׸   A׹   A׺   A׻f   A׼G   A׽(   A׾	   A׾   A׿   A   A   An   AO   A0   A   A   A   AǴ   Aȕ   Av   AW   A8   A   A   A   Aμ   Aϝ   A~   A_   A@   A!   A   A   A   A֥   A׆   Ag   AH   A)   A
   A   A   Aݭ   Aގ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A    A   A   Ax   AY   A:   A   A   A   A   A	   A
   Aa   AB   A
#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   A y   A!Z   A";   A#   A#   A$   A%   A&   A'   A(b   A)C   A*$   A+   A+   A,   A-   A.   A/j   A0K   A1,   A2
   A2   A3   A4   A5   A6r   A7S   A84   A9   A9   A:   A;   A<   A=z   A>[   A?<   A@   A@   AA   AB   AC   AD   AEc   AFD   AG%   AH   AH   AI   AJ   AK   ALk   AML   AN-   AO   AO   AP   AQ   AR   ASs   ATT   AU5   AV   AV   AW   AX   AY   AZ{   A[\   A\=   A]   A]   A^   A_   A`   Aa   Abd   AcE   Ad&   Ae   Ae   Af   Ag   Ah   Ail   AjM   Ak.   Al   Al   Am   An   Ao   Apt   AqU   Ar6   As   As   At   Au   Av   Aw|   Ax]   Ay>   Az   A{    A{   A|   A}   A~   Ae   A؀F   A؁'   A؂   A؂   A؃   A؄   A؅   A؆m   A؇N   A؈/   A؉   A؉   A؊   A؋   A،   A؍u   A؎V   A؏7   Aؐ   Aؐ   Aؑ   Aؒ   Aؓ   Aؔ}   Aؕ^   Aؖ?   Aؗ    Aؘ   Aؘ   Aؙ   Aؚ   A؛   A؜f   A؝G   A؞(   A؟	   A؟   Aؠ   Aء   Aآ   Aأn   AؤO   Aإ0   Aئ   Aئ   Aا   Aب   Aة   Aتv   AثW   Aج8   Aح   Aخ   Aد   Aذ   Aر~   Aز_   Aس@   Aش!   Aص   Aص   Aض   Aط   Aظ   Aعg   AغH   Aػ)   Aؼ
   Aؼ   Aؽ   Aؾ   Aؿ   Ao   AP   A1   A   A   A   Aŵ   AƖ   Aw   AX   A9   A   A   A   A̽   A͞   A   A`   AA   A"   A   A   A   AԦ   AՇ   Ah   AI   A*   A   A   A   Aۮ   A܏   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A    Ay   AZ   A;   A   A   A   A   A   A   A	b   A
C   A$   A   A   A
   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A <   A!   A!   A"   A#   A$   A%   A&c   A'D   A(%   A)   A)   A*   A+   A,   A-k   A.L   A/-   A0   A0   A1   A2   A3   A4s   A5T   A65   A7   A7   A8   A9   A:   A;{   A<\   A==   A>   A>   A?   A@   AA   AB   ACd   ADE   AE&   AF   AF   AG   AH   AI   AJl   AKM   AL.   AM   AM   AN   AO   AP   AQt   ARU   AS6   AT   AT   AU   AV   AW   AX|   AY]   AZ>   A[   A\    A\   A]   A^   A_   A`e   AaF   Ab'   Ac   Ac   Ad   Ae   Af   Agm   AhN   Ai/   Aj   Aj   Ak   Al   Am   Anu   AoV   Ap7   Aq   Aq   Ar   As   At   Au}   Av^   Aw?   Ax    Ay   Ay   Az   A{   A|   A}f   A~G   A(   Aـ	   Aـ   Aف   Aق   Aك   Aلn   AمO   Aن0   Aه   Aه   Aو   Aى   Aي   Aًv   AٌW   Aٍ8   Aَ   Aَ   Aُ   Aِ   Aّ   Aْ~   Aٓ_   Aٔ@   Aٕ!   Aٖ   Aٖ   Aٗ   A٘   Aٙ   Aٚg   AٛH   Aٜ)   Aٝ
   Aٝ   Aٞ   Aٟ   A٠   A١o   A٢P   A٣1   A٤   A٤   A٥   A٦   A٧   A٨w   A٩X   A٪9   A٫   A٫   A٬   A٭   Aٮ   Aٯ   Aٰ`   AٱA   Aٲ"   Aٳ   Aٳ   Aٴ   Aٵ   Aٶ   Aٷh   AٸI   Aٹ*   Aٺ   Aٺ   Aٻ   Aټ   Aٽ   Aپp   AٿQ   A2   A   A   A   Aö   Aė   Ax   AY   A:   A   A   A   Aʾ   A˟   À   Aa   AB   A#   A   A   A   Aҧ   Aӈ   Ai   AJ   A+   A   A   A   Aٯ   Aڐ   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A [   A<   A   A   A   A   A   A   Ac   AD   A	%   A
   A
   A   A   A
   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A    A!   A"   A#   A$d   A%E   A&&   A'   A'   A(   A)   A*   A+l   A,M   A-.   A.   A.   A/   A0   A1   A2t   A3U   A46   A5   A5   A6   A7   A8   A9|   A:]   A;>   A<   A=    A=   A>   A?   A@   AAe   ABF   AC'   AD   AD   AE   AF   AG   AHm   AIN   AJ/   AK   AK   AL   AM   AN   AOu   APV   AQ7   AR   AR   AS   AT   AU   AV}   AW^   AX?   AY    AZ   AZ   A[   A\   A]   A^f   A_G   A`(   Aa	   Aa   Ab   Ac   Ad   Aen   AfO   Ag0   Ah   Ah   Ai   Aj   Ak   Alv   AmW   An8   Ao   Ao   Ap   Aq   Ar   As~   At_   Au@   Av!   Aw   Aw   Ax   Ay   Az   A{g   A|H   A})   A~
   A~   A   Aڀ   Aځ   Aڂo   AڃP   Aڄ1   Aڅ   Aڅ   Aچ   Aڇ   Aڈ   Aډw   AڊX   Aڋ9   Aڌ   Aڌ   Aڍ   Aڎ   Aڏ   Aڐ   Aڑ`   AڒA   Aړ"   Aڔ   Aڔ   Aڕ   Aږ   Aڗ   Aژh   AڙI   Aښ*   Aڛ   Aڛ   Aڜ   Aڝ   Aڞ   Aڟp   AڠQ   Aڡ2   Aڢ   Aڢ   Aڣ   Aڤ   Aڥ   Aڦx   AڧY   Aڨ:   Aک   Aک   Aڪ   Aګ   Aڬ   Aڭ   Aڮa   AگB   Aڰ#   Aڱ   Aڱ   Aڲ   Aڳ   Aڴ   Aڵi   AڶJ   Aڷ+   Aڸ   Aڸ   Aڹ   Aں   Aڻ   Aڼq   AڽR   Aھ3   Aڿ   Aڿ   A   A   A   Ay   AZ   A;   A   A   A   Aȿ   Aɠ   Aʁ   Ab   AC   A$   A   A   A   AШ   Aщ   Aj   AK   A,   A
   A   A   Aװ   Aؑ   Ar   AS   A4   A   A   A   A޸   Aߙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A    A    A   A   A   A   Ad   AE   A&   A   A   A	   A
   A   Al   A
M   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A    A!   A"e   A#F   A$'   A%   A%   A&   A'   A(   A)m   A*N   A+/   A,   A,   A-   A.   A/   A0u   A1V   A27   A3   A3   A4   A5   A6   A7}   A8^   A9?   A:    A;   A;   A<   A=   A>   A?f   A@G   AA(   AB	   AB   AC   AD   AE   AFn   AGO   AH0   AI   AI   AJ   AK   AL   AMv   ANW   AO8   AP   AP   AQ   AR   AS   AT~   AU_   AV@   AW!   AX   AX   AY   AZ   A[   A\g   A]H   A^)   A_
   A_   A`   Aa   Ab   Aco   AdP   Ae1   Af   Af   Ag   Ah   Ai   Ajw   AkX   Al9   Am   Am   An   Ao   Ap   Aq   Ar`   AsA   At"   Au   Au   Av   Aw   Ax   Ayh   AzI   A{*   A|   A|   A}   A~   A   Aۀp   AہQ   Aۂ2   Aۃ   Aۃ   Aۄ   Aۅ   Aۆ   Aۇx   AۈY   Aۉ:   Aۊ   Aۊ   Aۋ   Aی   Aۍ   Aێ   Aۏa   AېB   Aۑ#   Aے   Aے   Aۓ   A۔   Aە   Aۖi   AۗJ   Aۘ+   Aۙ   Aۙ   Aۚ   Aۛ   Aۜ   A۝q   A۞R   A۟3   A۠   A۠   Aۡ   Aۢ   Aۣ   Aۤy   AۥZ   Aۦ;   Aۧ   Aۧ   Aۨ   A۩   A۪   A۫   A۬b   AۭC   Aۮ$   Aۯ   Aۯ   A۰   A۱   A۲   A۳j   A۴K   A۵,   A۶
   A۶   A۷   A۸   A۹   Aۺr   AۻS   Aۼ4   A۽   A۽   A۾   Aۿ   A   Az   A[   A<   A   A   A   A   Aǡ   AȂ   Ac   AD   A%   A   A   A   AΩ   Aϊ   Ak   AL   A-   A   A   A   Aձ   A֒   As   AT   A5   A   A   A   Aܹ   Aݚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A    A   A   Ae   AF   A'   A   A   A   A   A	   A
m   AN   A/   A
   A
   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   A f   A!G   A"(   A#	   A#   A$   A%   A&   A'n   A(O   A)0   A*   A*   A+   A,   A-   A.v   A/W   A08   A1   A1   A2   A3   A4   A5~   A6_   A7@   A8!   A9   A9   A:   A;   A<   A=g   A>H   A?)   A@
   A@   AA   AB   AC   ADo   AEP   AF1   AG   AG   AH   AI   AJ   AKw   ALX   AM9   AN   AN   AO   AP   AQ   AR   AS`   ATA   AU"   AV   AV   AW   AX   AY   AZh   A[I   A\*   A]   A]   A^   A_   A`   Aap   AbQ   Ac2   Ad   Ad   Ae   Af   Ag   Ahx   AiY   Aj:   Ak   Ak   Al   Am   An   Ao   Apa   AqB   Ar#   As   As   At   Au   Av   Awi   AxJ   Ay+   Az   Az   A{   A|   A}   A~q   AR   A܀3   A܁   A܁   A܂   A܃   A܄   A܅y   A܆Z   A܇;   A܈   A܈   A܉   A܊   A܋   A܌   A܍b   A܎C   A܏$   Aܐ   Aܐ   Aܑ   Aܒ   Aܓ   Aܔj   AܕK   Aܖ,   Aܗ
   Aܗ   Aܘ   Aܙ   Aܚ   Aܛr   AܜS   Aܝ4   Aܞ   Aܞ   Aܟ   Aܠ   Aܡ   Aܢz   Aܣ[   Aܤ<   Aܥ   Aܥ   Aܦ   Aܧ   Aܨ   Aܩ   Aܪc   AܫD   Aܬ%   Aܭ   Aܭ   Aܮ   Aܯ   Aܰ   Aܱk   AܲL   Aܳ-   Aܴ   Aܴ   Aܵ   Aܶ   Aܷ   Aܸs   AܹT   Aܺ5   Aܻ   Aܻ   Aܼ   Aܽ   Aܾ   Aܿ{   A\   A=   A   A   A   A   AŢ   Aƃ   Ad   AE   A&   A   A   A   A̪   A͋   Al   AM   A.   A   A   A   AӲ   Aԓ   At   AU   A6   A   A   A   Aں   Aۛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A    Af   AG   A(   A	   A   A   A   A   An   A	O   A
0   A   A   A   A
   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A )   A!
   A!   A"   A#   A$   A%o   A&P   A'1   A(   A(   A)   A*   A+   A,w   A-X   A.9   A/   A/   A0   A1   A2   A3   A4`   A5A   A6"   A7   A7   A8   A9   A:   A;h   A<I   A=*   A>   A>   A?   A@   AA   ABp   ACQ   AD2   AE   AE   AF   AG   AH   AIx   AJY   AK:   AL   AL   AM   AN   AO   AP   AQa   ARB   AS#   AT   AT   AU   AV   AW   AXi   AYJ   AZ+   A[   A[   A\   A]   A^   A_q   A`R   Aa3   Ab   Ab   Ac   Ad   Ae   Afy   AgZ   Ah;   Ai   Ai   Aj   Ak   Al   Am   Anb   AoC   Ap$   Aq   Aq   Ar   As   At   Auj   AvK   Aw,   Ax
   Ax   Ay   Az   A{   A|r   A}S   A~4   A   A   A݀   A݁   A݂   A݃z   A݄[   A݅<   A݆   A݆   A݇   A݈   A݉   A݊   A݋c   A݌D   Aݍ%   Aݎ   Aݎ   Aݏ   Aݐ   Aݑ   Aݒk   AݓL   Aݔ-   Aݕ   Aݕ   Aݖ   Aݗ   Aݘ   Aݙs   AݚT   Aݛ5   Aݜ   Aݜ   Aݝ   Aݞ   Aݟ   Aݠ{   Aݡ\   Aݢ=   Aݣ   Aݣ   Aݤ   Aݥ   Aݦ   Aݧ   Aݨd   AݩE   Aݪ&   Aݫ   Aݫ   Aݬ   Aݭ   Aݮ   Aݯl   AݰM   Aݱ.   Aݲ   Aݲ   Aݳ   Aݴ   Aݵ   Aݶt   AݷU   Aݸ6   Aݹ   Aݹ   Aݺ   Aݻ   Aݼ   Aݽ|   Aݾ]   Aݿ>   A   A    A   A   Aã   AĄ   Ae   AF   A'   A   A   A   Aʫ   Aˌ   Am   AN   A/   A   A   A   Aѳ   AҔ   Au   AV   A7   A   A   A   Aػ   Aٜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   A H   A)   A
   A   A   A   A   Ao   AP   A1   A	   A	   A
   A   A   A
w   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A    A!   A"   A#p   A$Q   A%2   A&   A&   A'   A(   A)   A*x   A+Y   A,:   A-   A-   A.   A/   A0   A1   A2a   A3B   A4#   A5   A5   A6   A7   A8   A9i   A:J   A;+   A<   A<   A=   A>   A?   A@q   AAR   AB3   AC   AC   AD   AE   AF   AGy   AHZ   AI;   AJ   AJ   AK   AL   AM   AN   AOb   APC   AQ$   AR   AR   AS   AT   AU   AVj   AWK   AX,   AY
   AY   AZ   A[   A\   A]r   A^S   A_4   A`   A`   Aa   Ab   Ac   Adz   Ae[   Af<   Ag   Ag   Ah   Ai   Aj   Ak   Alc   AmD   An%   Ao   Ao   Ap   Aq   Ar   Ask   AtL   Au-   Av   Av   Aw   Ax   Ay   Azs   A{T   A|5   A}   A}   A~   A   Aހ   Aށ{   Aނ\   Aރ=   Aބ   Aބ   Aޅ   Aކ   Aއ   Aވ   Aމd   AފE   Aދ&   Aތ   Aތ   Aލ   Aގ   Aޏ   Aސl   AޑM   Aޒ.   Aޓ   Aޓ   Aޔ   Aޕ   Aޖ   Aޗt   AޘU   Aޙ6   Aޚ   Aޚ   Aޛ   Aޜ   Aޝ   Aޞ|   Aޟ]   Aޠ>   Aޡ   Aޢ    Aޢ   Aޣ   Aޤ   Aޥ   Aަe   AާF   Aި'   Aީ   Aީ   Aު   Aޫ   Aެ   Aޭm   AޮN   Aޯ/   Aް   Aް   Aޱ   A޲   A޳   A޴u   A޵V   A޶7   A޷   A޷   A޸   A޹   A޺   A޻}   A޼^   A޽?   A޾    A޿   A޿   A   A   A   Af   AG   A(   A	   A   A   AȬ   Aɍ   An   AO   A0   A   A   A   Aϴ   AЕ   Av   AW   A8   A   A   A   Aּ   Aם   A~   A_   A@   A!   A   A   A   Aޥ   A߆   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A    A    A   A   A   Ap   AQ   A2   A   A   A   A	   A
   Ax   AY   A
:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A    A!q   A"R   A#3   A$   A$   A%   A&   A'   A(y   A)Z   A*;   A+   A+   A,   A-   A.   A/   A0b   A1C   A2$   A3   A3   A4   A5   A6   A7j   A8K   A9,   A:
   A:   A;   A<   A=   A>r   A?S   A@4   AA   AA   AB   AC   AD   AEz   AF[   AG<   AH   AH   AI   AJ   AK   AL   AMc   AND   AO%   AP   AP   AQ   AR   AS   ATk   AUL   AV-   AW   AW   AX   AY   AZ   A[s   A\T   A]5   A^   A^   A_   A`   Aa   Ab{   Ac\   Ad=   Ae   Ae   Af   Ag   Ah   Ai   Ajd   AkE   Al&   Am   Am   An   Ao   Ap   Aql   ArM   As.   At   At   Au   Av   Aw   Axt   AyU   Az6   A{   A{   A|   A}   A~   A|   A߀]   A߁>   A߂   A߃    A߃   A߄   A߅   A߆   A߇e   A߈F   A߉'   Aߊ   Aߊ   Aߋ   Aߌ   Aߍ   Aߎm   AߏN   Aߐ/   Aߑ   Aߑ   Aߒ   Aߓ   Aߔ   Aߕu   AߖV   Aߗ7   Aߘ   Aߘ   Aߙ   Aߚ   Aߛ   Aߜ}   Aߝ^   Aߞ?   Aߟ    Aߠ   Aߠ   Aߡ   Aߢ   Aߣ   Aߤf   AߥG   Aߦ(   Aߧ	   Aߧ   Aߨ   Aߩ   Aߪ   A߫n   A߬O   A߭0   A߮   A߮   A߯   A߰   A߱   A߲v   A߳W   Aߴ8   Aߵ   Aߵ   A߶   A߷   A߸   A߹~   Aߺ_   A߻@   A߼!   A߽   A߽   A߾   A߿   A   Ag   AH   A)   A
   A   A   Aƭ   Aǎ   Ao   AP   A1   A   A   A   A͵   AΖ   Aw   AX   A9   A   A   A   AԽ   A՞   A   A`   AA   A"   A   A   A   Aܦ   A݇   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A    A   Aq   AR   A3   A   A   A   A   A   A	y   A
Z   A;   A   A   A
   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   A S   A!4   A"   A"   A#   A$   A%   A&z   A'[   A(<   A)   A)   A*   A+   A,   A-   A.c   A/D   A0%   A1   A1   A2   A3   A4   A5k   A6L   A7-   A8   A8   A9   A:   A;   A<s   A=T   A>5   A?   A?   A@   AA   AB   AC{   AD\   AE=   AF   AF   AG   AH   AI   AJ   AKd   ALE   AM&   AN   AN   AO   AP   AQ   ARl   ASM   AT.   AU   AU   AV   AW   AX   AYt   AZU   A[6   A\   A\   A]   A^   A_   A`|   Aa]   Ab>   Ac   Ad    Ad   Ae   Af   Ag   Ahe   AiF   Aj'   Ak   Ak   Al   Am   An   Aom   ApN   Aq/   Ar   Ar   As   At   Au   Avu   AwV   Ax7   Ay   Ay   Az   A{   A|   A}}   A~^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   Aࠥ   Aࡆ   Ag   AH   A)   A
   A   A   A৭   A਎   Ao   AP   A1   A   A   A   Aவ   A௖   Aw   AX   A9   A   A   A   Aൽ   Aඞ   A   A`   AA   A"   A   A   A   Aས   A྇   Ah   AI   A*   A   A   A   AĮ   Aŏ   Ap   AQ   A2   A   A   A   A˶   A̗   Ax   AY   A:   A   A   A   AҾ   Aӟ   AԀ   Aa   AB   A#   A   A   A   Aڧ   Aۈ   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   A r   AS   A4   A   A   A   A   A   Az   A[   A	<   A
   A
   A   A   A
   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A    A    A!   A"   A#   A${   A%\   A&=   A'   A'   A(   A)   A*   A+   A,d   A-E   A.&   A/   A/   A0   A1   A2   A3l   A4M   A5.   A6   A6   A7   A8   A9   A:t   A;U   A<6   A=   A=   A>   A?   A@   AA|   AB]   AC>   AD   AE    AE   AF   AG   AH   AIe   AJF   AK'   AL   AL   AM   AN   AO   APm   AQN   AR/   AS   AS   AT   AU   AV   AWu   AXV   AY7   AZ   AZ   A[   A\   A]   A^}   A_^   A`?   Aa    Ab   Ab   Ac   Ad   Ae   Aff   AgG   Ah(   Ai	   Ai   Aj   Ak   Al   Amn   AnO   Ao0   As   Atv   AuW   Av8   Aw   Aw   Ax   Ay   Az   A{~   A|_   A}@   A~!   A   A   A   Aၥ   Aႆ   Ag   AH   A)   A
   A   A   Aር   A቎   Ao   AP   A1   A   A   A   AᏵ   Aᐖ   Aw   AX   A9   A   A   A   Aᖽ   Aᗞ   A   A`   AA   A"   A   A   A   Aឦ   Aះ   Ah   AI   A*   A   A   A   A᥮   Aᦏ   Ap   AQ   A2   A   A   A   Aᬶ   A᭗   Ax   AY   A:   A   A   A   A᳾   Aᴟ   Aᵀ   Aa   AB   A#   A   A   A   Aủ   AἈ   Ai   AJ   A+   A   A   A   A¯   AÐ   Aq   AR   A3   A   Ay   AZ   A;   A   A   A   Aп   AѠ   Aҁ   Ab   AC   A$   A   A   A   Aب   Aى   Aj   AK   A,   A
   A   A   A߰   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A 5   A   A   A   A   A   A{   A\   A=   A   A   A	   A
   A   A   A
d   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A    A!   A"|   A#]   A$>   A%   A&    A&   A'   A(   A)   A*e   A+F   A,'   A-   A-   A.   A/   A0   A1m   A2N   A3/   A4   A4   A5   A6   A7   A8u   A9V   A:7   A;   A;   A<   A=   A>   A?}   A@^   AA?   AB    AC   AC   AD   AE   AF   AGf   AHG   AI(   AJ	   AJ   AK   AL   AM   ANn   AOO   AP0   AQ   AQ   AR   AS   AT   AUv   AVW   AW8   AX   AX   AY   AZ   A[   A\~   A]_   A^@   A_!   A`   A`   Aa   Ab   Ac   Adg   AeH   Af)   Ag
   Ag   Ah   Ai   Aj   Ako   AlP   Am1   An   An   Ao   Ap   Aq   Arw   AsX   At9   Au   Au   Av   A{A   A|"   A}   A}   A~   A   A    Ah   AI   A*   A   A   A   A↮   A⇏   Ap   AQ   A2   A   A   A   A⍶   A⎗   Ax   AY   A:   A   A   A   A┾   A╟   A▀   Aa   AB   A#   A   A   A   A✧   A❈   Ai   AJ   A+   A   A   A   A⣯   A⤐   Aq   AR   A3   A   A   A   A⪷   A⫘   Ay   AZ   A;   A   A   A   AⱿ   AⲠ   Aⳁ   Ab   AC   A$   A   A   A   A⹨   A⺉   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   AǸ   Aș   Az   A[   A<   A   A   A   A   A%   A   A   A   A֩   A׊   Ak   AL   A-   A   A   A   Aݱ   Aޒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A    A   A   A|   A]   A>   A   A    A   A   A	   A
   Ae   AF   A
'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A }   A!^   A"?   A#    A$   A$   A%   A&   A+	   A+   A,   A-   A.   A/n   A0O   A10   A2   A2   A3   A4   A5   A6v   A7W   A88   A9   A9   A:   A;   A<   A=~   A>_   A?@   A@!   AA   AA   AB   AC   AD   AEg   AFH   AG)   AH
   AH   AI   AJ   AK   ALo   AMP   AN1   AO   AO   AP   AQ   AR   ASw   ATX   AU9   AV   AV   AW   AX   AY   AZ   A[`   A\A   A]"   A^   A^   A_   A`   Aa   Abh   AcI   Ad*   Ae   Ae   Af   Ag   Ah   Aip   AjQ   Ak2   Al   Al   Am   An   Ao   Apx   AqY   Ar:   As   As   At   Au   Av   Aw   Axa   AyB   Az#   A{   A{   A|   A}   A~   A   A   Aㄯ   Aㅐ   Aq   AR   A3   A   A   A   A㋷   A㌘   Ay   AZ   A;   A   A   A   A㒿   A㓠   A㔁   Ab   AC   A$   A   A   A   A㚨   A㛉   Aj   AK   A,   A
   A   A   A㡰   A㢑   Ar   AS   A4   A   A   A   A㨸   A㩙   Az   A[   A<   A   A   A   A   A㰡   A㱂   Ac   AD   A%   A   A   A   A㷩   A㸊   Ak   AL   A-   A   A   A   A㾱   A㿒   As   AT   A5   A   A   A   AŹ   Aƚ   A{   A\   A=   A   A   A   A   A͢   A΃   Ad   AE   A&   A   A   A   AԪ   AՋ   Al   A   A۲   Aܓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A    A}   A^   A?   A    A   A   A   A   A   A	f   A
G   A(   A	   A   A
   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A @   A!!   A"   A"   A#   A()   A)
   A)   A*   A+   A,   A-o   A.P   A2   A3   A4w   A5X   A69   A7   A7   A8   A9   A:   A;   A<`   A=A   A>"   A?   A?   A@   AA   AB   ACh   ADI   AE*   AF   AF   AG   AH   AI   AJp   AKQ   AL2   AM   AM   AN   AO   AP   AQx   ARY   AS:   AT   AT   AU   AV   AW   AX   AYa   AZB   A[#   A\   A\   A]   A^   A_   A`i   AaJ   Ab+   Ac   Ac   Ad   Ae   Af   Agq   AhR   Ai3   Aj   Aj   Ak   Al   Am   Any   AoZ   Ap;   Aq   Aq   Ar   As   At   Au   Avb   AwC   Ax$   Ay   Ay   Az   A{   A|   A}j   A~K   A,   A
   A   A   A䂰   A䊙   Az   A[   A<   A   A   A   A   A䑡   A䒂   Ac   AD   A%   A   A   A   A䘩   A䙊   Ak   AL   A-   A   A   A   A䟱   A䠒   As   AT   A5   A   A   A   A䦹   A䧚   A{   A\   A=   A   A   A   A   A䮢   A䯃   Ad   AE   A&   A   A   A   A䵪   A䶋   Al   AM   A.   A   A   A   A伲   A体   At   AU   A6   A   A   A   Aú   Aě   A|   A]   A>   A   A    A   A   Aˣ   Ā   Ae   AF   A'   A   A   A   Aҫ   Aӌ   Am   AN   A/   A   A   A   Aٳ   Aڔ   Au   AV   A7   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A _   A@   A!   A   A   A   A   A   Ag   AH   A	)   A

   A
   A   A   A
   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A    A    A!   A"   A#   A$h   A%I   A&*   A'   A'   A(   A)   A*   A+p   A,Q   A-2   A.   A.   A/   A0   A1   A2x   A3Y   A4:   A5   A5   A:a   A;B   A<#   A=   A=   A>   A?   A@   AAi   ABJ   AC+   AD   AD   AE   AF   AG   AHq   AIR   AJ3   AK   AK   AL   AM   AN   AOy   APZ   AQ;   AR   AR   AS   AT   AU   AV   AWb   AXC   AY$   AZ   AZ   A[   A\   A]   A^j   A_K   A`,   A   A喪   A嗋   Al   AM   A.   A   A   A   A坲   A垓   At   AU   A6   A   A   A   A夺   A奛   A|   A]   A>   A   A    A   A   A嬣   A孄   Ae   AF   A'   A   A   A   A峫   A崌   Am   AN   A/   A   A   A   A庳   A廔   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   Aɤ   Aʅ   Af   AG   A(   A	   A   A   AЬ   Aэ   An   AO   A0   A   A   A   A״   Aؕ   Av   AW   A8   A   A   A   A޼   Aߝ   A~   A_   A@   A!   A   A   A   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A "   A   A   A   A   A   Ah   AI   A*   A   A   A	   A
   A   Ap   A
Q   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A    A!   A"i   A#J   A$+   A%   A%   A&   A'   A(   A)q   A*R   A+3   A,   A,   A-   A.   A/   A0y   A1Z   A2;   A3   A3   A4   A5   A6   A7   A8b   A9C   A:$   A;   A;   A<   A=   AB
   AB   AC   AD   AE   AFr   AGS   AH4   AI   AI   AJ   AK   AL   AMz   AN[   AO<   AP   AP   AQ   AR   AS   AT   AUc   AVD   AW%   AX   AX   AY   AZ   A[   A\k   A]L   A^-   A_   A_   A`   Aa   Ab   Acs   AdT   Ae5   Af   Af   Ag   Ah   Ai   Aj{   Ak\   Al=   Am   Am   An   Ao   Ap   Aq   Ard   AsE   At&   Au   Au   Av   Aw   Ax   Ayl   AzM   A{.   A|   A|   A}   A~   A   At   AU   A6   A   A   A   A慺   A憛   A|   A]   A>   A   A    A   A   A捣   A掄   Ae   AF   A'   A   A   A   A攫   A   A   A曳   A朔   Au   AV   A7   A   A   A   A梻   A棜   A}   A^   A?   A    A   A   A   A檤   A櫅   Af   AG   A(   A	   A   A   A汬   A沍   An   AO   A0   A   A   A   A渴   A湕   Av   AW   A8   A   A   A   A濼   A   A~   A_   A@   A!   A   A   A   Aǥ   AȆ   Ag   AH   A)   A
   A   A   Aέ   Aώ   Ao   AP   A1   A   A   A   Aյ   A֖   Aw   AX   A9   A   A   A   Aܽ   Aݞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A    A   A   Ai   AJ   A+   A   A   A   A   A	   A
q   AR   A3   A
   A
   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   A j   A!K   A",   A#
   A#   A$   A%   A&   A'r   A(S   A)4   A*   A*   A+   A,   A-   A.z   A/[   A0<   A1   A1   A2   A3   A4   A5   A6c   A7D   A8%   A9   A9   A:   A;   A<   A=k   A>L   A?-   A@   A@   AA   AB   AC   ADs   AET   AI   AJ   AK{   AL\   AM=   AN   AN   AO   AP   AQ   AR   ASd   ATE   AU&   AV   AV   AW   AX   AY   AZl   A[M   A\.   A]   A]   A^   A_   A`   Aat   AbU   Ac6   Ad   Ad   Ae   Af   Ag   Ah|   Ai]   Aj>   Ak   Al    Al   Am   An   Ao   Ape   AqF   Ar'   As   As   At   Au   Av   Awm   AxN   Ay/   Az   Az   A{   A|   A}   A~u   AV   A7   A   A   A   A烻   A焜   A}   A^   A?   A    A   A   A   A狤   A猅   Af   AG   A(   A	   A   A   A璬   A瓍   An   AO   A0   A   A   A   A癴   A皕   Av   AW   A8   A硝   A~   A_   A@   A!   A   A   A   A稥   A穆   Ag   AH   A)   A
   A   A   A篭   A簎   Ao   AP   A1   A   A   A   A綵   A緖   Aw   AX   A9   A   A   A   A罽   AA   A"   A   A   A   AŦ   AƇ   Ah   AI   A*   A   A   A   A̮   A͏   Ap   AQ   A2   A   A   A   AӶ   Aԗ   Ax   AY   A:   A   A   A   Aھ   A۟   A܀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A    Aj   AK   A,   A
   A   A   A   A   Ar   A	S   A
4   A   A   A   A
   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A -   A!   A!   A"   A#   A$   A%s   A&T   A'5   A(   A(   A)   A*   A+   A,{   A-\   A.=   A/   A/   A0   A1   A2   A3   A4d   A5E   A6&   A7   A7   A8   A9   A:   A;l   A<M   A=.   A>   A>   A?   A@   AA   ABt   ACU   AD6   AE   AE   AF   AG   AH   AI|   AJ]   AK>   AL   AM    AQe   ARF   AS'   AT   AT   AU   AV   AW   AXm   AYN   AZ/   A[   A[   A\   A]   A^   A_u   A`V   Aa7   Ab   Ab   Ac   Ad   Ae   Af}   Ag^   Ah?   Ai    Aj   Aj   Ak   Al   Am   Anf   AoG   Ap(   Aq	   Aq   Ar   As   At   Aun   AvO   Aw0   Ax   Ax   Ay   Az   A{   A|v   A}W   A~8   A   A   A   A聼   A肝   A~   A_   A@   A!   A   A   A   A艥   A芆   Ag   AH   A)   A
   A   A   A萭   A葎   Ao   AP   A1   A   A   A   A藵   A蘖   Aw   AX   A9   A   A   A   A螽   A蟞   A   A`   AA   A"   A   A   AI   A*   A   A   A   A譮   A讏   Ap   AQ   A2   A   A   A   A贶   A赗   Ax   AY   A:   A   A   A   A軾   A輟   A轀   Aa   AB   A#   A   A   A   Aç   AĈ   Ai   AJ   A+   A   A   A   Aʯ   Aː   Aq   AR   A3   A   A   A   Aѷ   AҘ   Ay   AZ   A;   A   A   A   Aؿ   A٠   Aځ   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A-   A   A   A   A   A   As   AT   A5   A	   A	   A
   A   A   A
{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A    A!   A"   A#t   A$U   A%6   A&   A&   A'   A(   A)   A*|   A+]   A,>   A-   A.    A.   A/   A0   A1   A2e   A3F   A4'   A5   A5   A6   A7   A8   A9m   A:N   A;/   A<   A<   A=   A>   A?   A@u   AAV   AB7   AC   AC   AD   AE   AF   AG}   AH^   AI?   AJ    AK   AK   AL   AM   AN   AOf   APG   AQ(   AR	   AR   AS   AT   AY   AY   AZ   A[   A\   A]v   A^W   A_8   A`   A`   Aa   Ab   Ac   Ad~   Ae_   Af@   Ag!   Ah   Ah   Ai   Aj   Ak   Alg   AmH   An)   Ao
   Ao   Ap   Aq   Ar   Aso   AtP   Au1   Av   Av   Aw   Ax   Ay   Azw   A{X   A|9   A}   A}   A~   A   A逞   A   A`   AA   A"   A   A   A   A釦   A鈇   Ah   AI   A*   A   A   A   A鎮   A鏏   Ap   AQ   A2   A   A   A   A镶   A閗   Ax   AY   A:   A   A   A   A霾   A靟   A鞀   Aa   AB   A#   A   A   A   A餧   A饈   Ai   AJ   A+   A   A   A   A髯   A鬐   A   A   A鲷   A鳘   Ay   AZ   A;   A   A   A   A鹿   A麠   A黁   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   AȰ   Aɑ   Ar   AS   A4   A   A   A   Aϸ   AЙ   Az   A[   A<   A   A   A   A   Aס   A؂   Ac   AD   A%   A   A   A   Aީ   Aߊ   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A    A    A   A   A   At   A   A	   A
   A|   A]   A
>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A    A!u   A"V   A#7   A$   A$   A%   A&   A'   A(}   A)^   A*?   A+    A,   A,   A-   A.   A/   A0f   A1G   A2(   A3	   A3   A4   A5   A6   A7n   A8O   A90   A:   A:   A;   A<   A=   A>v   A?W   A@8   AA   AA   AB   AC   AD   AE~   AF_   AG@   AH!   AI   AI   AJ   AK   AL   AMg   ANH   AO)   AP
   AP   AQ   AR   AS   ATo   AUP   AV1   AW   AW   AX   AY   AZ   A[w   A\X   A`   Aa   Ab   Ac`   AdA   Ae"   Af   Af   Ag   Ah   Ai   Ajh   AkI   Al*   Am   Am   An   Ao   Ap   Aqp   ArQ   As2   At   At   Au   Av   Aw   Axx   AyY   Az:   A{   A{   A|   A}   A~   A   Aa   AB   A#   A   A   A   Aꅧ   Aꆈ   Ai   AJ   A+   A   A   A   Aꌯ   Aꍐ   Aq   AR   A3   A   A   A   Aꓷ   Aꔘ   Ay   AZ   A;   A   A   A   Aꚿ   Aꛠ   A꜁   Ab   AC   A$   A   A   A   Aꢨ   A꣉   Aj   AK   A,   A
   A   A   Aꩰ   Aꪑ   Ar   AS   A4   A   A   A   A갸   A걙   Az   A[   A<   A긡   A깂   Ac   AD   A%   A   A   A   A꿩   A   Ak   AL   A-   A   A   A   AƱ   Aǒ   As   AT   A5   A   A   A   A͹   AΚ   A{   A\   A=   A   A   A   A   Aբ   Aփ   Ad   AE   A&   A   A   A   Aܪ   A݋   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A    A   Au   AV   A7   A   A   A   A   A   A	}   A
^   A?   A    A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   A W   A!8   A"   A"   A#   A$   A%   A&~   A'_   A(@   A)!   A*   A*   A+   A,   A-   A.g   A/H   A0)   A1
   A1   A2   A3   A4   A5o   A6P   A71   A8   A8   A9   A:   A;   A<w   A=X   A>9   A?   A?   A@   AA   AB   AC   AD`   AEA   AF"   AG   AG   AH   AI   AJ   AKh   ALI   AM*   AN   AN   AO   AP   AQ   ARp   ASQ   AT2   AU   AU   AV   AW   AX   AYx   AZY   A[:   A\   A\   A]   A^   A_   A`   Aaa   AbB   Ac#   Ad   Ahi   AiJ   Aj+   Ak   Ak   Al   Am   An   Aoq   ApR   Aq3   Ar   Ar   As   At   Au   Avy   AwZ   Ax;   Ay   Ay   Az   A{   A|   A}   A~b   AC   A$   A   A   A   A냨   A넉   Aj   AK   A,   A
   A   A   A늰   A닑   Ar   AS   A4   A   A   A   A둸   A뒙   Az   A[   A<   A   A   A   A   A뙡   A뚂   Ac   AD   A%   A   A   A   A렩   A롊   Ak   AL   A-   A   A   A   A맱   A먒   As   AT   A5   A   A   A   A뮹   A믚   A{   A\   A=   A   A   A   A   A붢   A뷃   Ad   AE   A&   A   A   AM   A.   A   A   A   AĲ   Aœ   At   AU   A6   A   A   A   A˺   A̛   A|   A]   A>   A   A    A   A   Aӣ   AԄ   Ae   AF   A'   A   A   A   Aګ   Aی   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   A v   AW   A8   A   A   A   A   A   A~   A_   A	@   A
!   A   A   A   A
   A   Ag   AH   A)   A
   A   A   A1   A   A   A   A   A   Aw   AX   A9   A    A    A!   A"   A#   A$   A%`   A&A   A'"   A(   A(   A)   A*   A+   A,h   A-I   A.*   A/   A/   A0   A1   A2   A3p   A4Q   A52   A6   A6   A7   A8   A9   A:x   A;Y   A<:   A=   A=   A>   A?   A@   AA   ABa   ACB   AD#   AE   AE   AF   AG   AH   AIi   AJJ   AK+   AL   AL   AM   AN   AO   APq   AQR   AR3   AS   AS   AT   AU   AV   AWy   AXZ   AY;   AZ   AZ   A[   A\   A]   A^   A_b   A`C   Aa$   Ab   Ab   Ac   Ad   Ae   Afj   AgK   Ah,   Ai
   Ai   Aj   Ak   Ap   Ap   Aq   Ar   As   Atz   Au[   Av<   Aw   Aw   Ax   Ay   Az   A{   A|c   A}D   A~%   A   A   A   A쁩   A삊   Ak   AL   A-   A   A   A   A숱   A쉒   As   AT   A5   A   A   A   A쏹   A쐚   A{   A\   A=   A   A   A   A   A엢   A옃   Ad   AE   A&   A   A   A   A잪   A쟋   Al   AM   A.   A   A   A   A쥲   A즓   At   AU   A6   A   A   A   A쬺   A쭛   A|   A]   A>   A   A    A   A   A촣   A쵄   Ae   AF   A'   A   A   A   A컫   A켌   Am   AN   A/   A   A   A   Aɻ   Aʜ   A}   A^   A?   A    A   A   A   AѤ   A҅   Af   AG   A(   A	   A   A   Aج   Aٍ   An   AO   A0   A   A   A   Aߴ   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A 9   A   A   A   A   A   A   A`   AA   A"   A	   A	   A
   A   A   A
h   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A    A!   A"   A#a   A$B   A%#   A&   A&   A'   A(   A)   A*i   A+J   A,+   A-   A-   A.   A/   A0   A1q   A2R   A33   A4   A4   A5   A6   A7   A8y   A9Z   A:;   A;   A;   A<   A=   A>   A?   A@b   AAC   AB$   AC   AC   AD   AE   AF   AGj   AHK   AI,   AJ
   AJ   AK   AL   AM   ANr   AOS   AP4   AQ   AQ   AR   AS   AT   AUz   AV[   AW<   AX   AX   AY   AZ   A[   A\   A]c   A^D   A_%   A`   A`   Aa   Ab   Ac   Adk   AeL   Af-   Ag   Ag   Ah   Ai   Aj   Aks   AlT   Am5   An   An   Ao   Ap   Aq   Ar{   As\   Aw   Ax   Ay   Azd   A{E   A|&   A}   A}   A~   A   A퀋   Al   AM   A.   A   A   A   A톲   A퇓   At   AU   A6   A   A   A   A퍺   A펛   A|   A]   A>   A   A    A   A   A핣   A햄   Ae   AF   A'   A   A   A   A휫   A흌   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   AǼ   Aȝ   A~   A_   A@   Aϥ   AІ   Ag   AH   A)   A
   A   A   A֭   A׎   Ao   AP   A1   A   A   A   Aݵ   Aޖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A    A   A   A   Aa   AB   A#   A   A   A   A	   A
   Ai   AJ   A
+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A    A!b   A"C   A#$   A'   A(j   A)K   A*,   A+
   A+   A,   A-   A.   A/r   A0S   A14   A2   A2   A3   A4   A5   A6z   A7[   A8<   A9   A9   A:   A;   A<   A=   A>c   A?D   A@%   AA   AA   AB   AC   AD   AEk   AFL   AG-   AH   AH   AI   AJ   AK   ALs   AMT   AN5   AO   AO   AP   AQ   AR   AS{   AT\   AU=   AV   AV   AW   AX   AY   AZ   A[d   A\E   A]&   A^   A^   A_   A`   Aa   Abl   AcM   Ad.   Ae   Ae   Af   Ag   Ah   Ait   AjU   Ak6   Al   Al   Am   An   Ao   Ap|   Aq]   Ar>   As   At    At   Au   Av   Aw   Axe   AyF   Az'   A{   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   AŽ   Aƞ   A   A`   AA   A"   A   A   A   Aͦ   A·   Ah   AI   A*   A   A   AQ   A2   A   A   A   A۶   Aܗ   Ax   AY   A:   A   A   A   A   A   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A    A   Ab   AC   A$   A   A   A   A   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   A D   A!%   A"   A"   A#   A$   A%   A&k   A'L   A/5   A0   A0   A1   A2   A3   A4{   A5\   A6=   A7   A7   A8   A9   A:   A;   A<d   A=E   A>&   A?   A?   A@   AA   AB   ACl   ADM   AE.   AF   AF   AG   AH   AI   AJt   AKU   AL6   AM   AM   AN   AO   AP   AQ|   AR]   AS>   AT   AU    Au   Avf   AwG   Ax(   Ay	   Ay   Az   A{   A|   A}n   A~O   A0   A   A   A   A   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A尿   A吏   A   A`   AA   A"   A   A   A   Aﮦ   A﯇   Ah   AI   A*   A   A   A   Aﵮ   Aﶏ   Ap   AQ   A2   A   A   A   AＶ   Aｗ   Ax   AY   A:   A   A   A   Aþ   Ağ   Aŀ   Aa   AB   A#   A   A   A   A˧   Ä   Ai   AJ   A+   A   A   A   Aү   AӐ   Aq   AR   A3   A   A   A   Aٷ   Aژ   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   A c   AD   A%   A   A   A   A   A   Ak   AL   A	-   A
   A
   A   A   A
   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A    A    A!   A"   A#   A$l   A%M   A&.   A'   A'   A(   A)   A*   A+t   A,U   A-6   A.   A.   A/   A0   A1   A2|   A6   A7   A8   A9   A:e   A;F   A<'   A=   A=   A>   A?   A@   AAm   ABN   AC/   AD   AD   AE   AF   AG   AHu   AIV   AJ7   AK   AK   AL   AM   AN   AO}   AP^   AQ?   AR    AS   AS   AT   AU   AV   AWf   AXG   AY(   AZ	   AZ   A[   A\   A]   A^n   A_O   A`0   Aa   Aa   Ab   Ac   Ad   Aev   AfW   Ag8   Ah   Ah   Ai   Aj   Ak   Al~   Am_   An@   Ao!   Ap   Ap   Aq   Ar   As   Atg   AuH   Av)   Aw
   Aw   Ax   Ay   Az   A{o   A|P   A}1   A~   A~   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A    AÁ   Ab   AC   A$   A   A   A   Aɨ   Aʉ   Aj   AK   A,   A
   A   A   Aа   Aё   Ar   AS   A4   A   A   A   A׸   Aؙ   Az   A[   A<   A   A   A   A   Aߡ   A   Ac   AD   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A &   A   A   A   A   A   Al   AM   A.   A   A   A	   A
   A   At   A
U   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A    A!   A"m   A#N   A$/   A%   A%   A&   A'   A(   A)u   A*V   A+7   A,   A,   A-   A.   A/   A0}   A1^   A2?   A3    A4   A4   A5   A6   A7   A8f   A9G   A:(   A>   A?n   A@O   AA0   AB   AB   AC   AD   AE   AFv   AGW   AH8   AI   AI   AJ   AK   AL   AM~   AN_   AO@   AP!   AQ   AQ   AR   AS   AT   AUg   AVH   AW)   AX
   AX   AY   AZ   A[   A\o   A]P   A^1   A_   A_   A`   Aa   Ab   Acw   AdX   Ae9   Af   Af   Ag   Ah   Ai   Aj   Ak`   Ao   Ap   Aq   Arh   AsI   At*   Au   Au   Av   Aw   Ax   Ayp   AzQ   A{2   A|   A|   A}   A~   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   Aǩ   AȊ   Ak   AL   A-   A   A   A   Aα   Aϒ   As   AT   A5   A   A   A   Aչ   A֚   A{   A\   A=   A   A   A   A   Aݢ   Aރ   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A    A   A   Am   AN   A/   A   A   A   A   A	   A
u   AV   A7   A
   A
   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   A n   A!O   A"0   A#   A#   A$   A%   A&   A'v   A(W   A)8   A*   A*   A+   A,   A-   A.~   A/_   A0@   A1!   A2   A2   A3   A4   A5   A6g   A7H   A8)   A9
   A9   A:   A;   A<   A=o   A>P   A?1   A@   A@   AA   AF9   AG   AG   AH   AI   AJ   AK   AL`   AMA   AN"   AO   AO   AP   AQ   AR   ASh   ATI   AU*   AV   AV   AW   AX   AY   AZp   A[Q   A\2   A]   A]   A^   A_   A`   Aax   AbY   Ac:   Ad   Ad   Ae   Af   Ag   Ah   Aia   AjB   Ak#   Al   Al   Am   An   Ao   Api   AqJ   Ar+   As   As   At   Au   Av   Awq   AxR   Ay3   Az   Az   A{   A|   A}   A~y   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   AŪ   AƋ   Al   AM   A.   A   A   A   A̲   A͓   At   AU   A6   A   A   A   AӺ   Aԛ   A|   A]   A>   A   A    A   A   Aۣ   A܄   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A   A   A   A   A   Af   AG   A(   A	   A   A   A   A    An   AO   A0   A   A   A   A   A   Av   A	W   A
8   A   A   A   A
   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A   A   Ao   AP   A 1   A!   A!   A"   A#   A$   A%w   A&X   A'9   A(   A(   A)   A*   A+   A,   A-`   A.A   A/"   A0   A0   A1   A2   A3   A4h   A5I   A6*   A7   A7   A8   A9   A:   A;p   A<Q   A=2   A>   A>   A?   A@   AA   ABx   ACY   AD:   AE   AE   AF   AG   AH   AI   AM   AN   AO   AP   AQi   ARJ   AS+   AT   AT   AU   AV   AW   AXq   AYR   AZ3   A[   A[   A\   A]   A^   A_y   A`Z   Aa;   Ab   Ab   Ac   Ad   Ae   Af   Agb   AhC   Ai$   Aj   Aj   Ak   Al   Am   Anj   AoK   Ap,   Aq
   Aq   Ar   As   At   Aur   AvS   Aw4   Ax   Ax   Ay   Az   A{   A|z   A}[   A~<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   Aë   AČ   Am   AN   A/   A   A   A   Aʳ   A˔   Au   AV   A7   A   A   A   Aѻ   AҜ   A}   A^   A?   A    A   A   A   A٤   Aڅ   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A   A   Ao   A P   A1   A   A   A   A   A   Aw   AX   A9   A	   A	   A
   A   A   A
   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A    A!   A"   A#x   A$Y   A%:   A&   A&   A'   A(   A)   A*   A+a   A,B   A-#   A.   A.   A/   A0   A1   A2i   A3J   A4+   A5   A5   A6   A7   A8   A9q   A:R   A;3   A<   A<   A=   A>   A?   A@y   AAZ   AB;   AC   AC   AD   AE   AF   AG   AHb   AIC   AJ$   AK   AK   AL   AM   AN   AOj   APK   AQ,   AU   AVr   AWS   AX4   AY   AY   AZ   A[   A\   A]z   A^[   A_<   A`   A`   Aa   Ab   Ac   Ad   Aec   AfD   Ag%   Ah   Ah   Ai   Aj   Ak   Alk   AmL   An-   Ao   Ao   Ap   Aq   Ar   Ass   AtT   Au5   Av   Av   Aw   Ax   Ay   Az{   A{\   A|=   A}   A}   A~   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   Aȴ   Aɕ   Av   AW   A8   A   A   A   Aϼ   AН   A~   A_   A@   A!   A   A   A   Aץ   A؆   Ag   AH   A)   A
   A   A   Aޭ   Aߎ   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A    A    A   A   A   Ax   AY   A:   A   A   A   A	   A
   A   Aa   A
B   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A    A!y   A"Z   A#;   A$   A$   A%   A&   A'   A(   A)b   A*C   A+$   A,   A,   A-   A.   A/   A0j   A1K   A2,   A3
   A3   A4   A5   A6   A7r   A8S   A94   A:   A:   A;   A<   A=   A>z   A?[   A@<   AA   AA   AB   AC   AD   AE   AFc   AGD   AH%   AI   AI   AJ   AK   AL   AMk   ANL   AO-   AP   AP   AQ   AR   AS   ATs   AUT   AV5   AW   AW   AX   A]=   A^   A^   A_   A`   Aa   Ab   Acd   AdE   Ae&   Af   Af   Ag   Ah   Ai   Ajl   AkM   Al.   Am   Am   An   Ao   Ap   Aqt   ArU   As6   At   At   Au   Av   Aw   Ax|   Ay]   Az>   A{   A|    A|   A}   A~   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   AƵ   Aǖ   Aw   AX   A9   A   A   A   Aͽ   AΞ   A   A`   AA   A"   A   A   A   Aզ   Aև   Ah   AI   A*   A   A   A   Aܮ   Aݏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A    A   Ay   AZ   A;   A   A   A   A   A   A
   A
   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A [   A!<   A"   A"   A#   A$   A%   A&   A'c   A(D   A)%   A*   A*   A+   A,   A-   A.k   A/L   A0-   A1   A1   A2   A3   A4   A5s   A6T   A75   A8   A8   A9   A:   A;   A<{   A=\   A>=   A?   A?   A@   AA   AB   AC   ADd   AEE   AF&   AG   AG   AH   AI   AJ   AKl   ALM   AM.   AN   AN   AO   AP   AQ   ARt   ASU   AT6   AU   AU   AV   AW   AX   AY|   AZ]   A[>   A\   A]    A]   A^   A_   A`   Ad   Ae   Af   Ag   Ahm   AiN   Aj/   Ak   Ak   Al   Am   An   Aou   ApV   Aq7   Ar   Ar   As   At   Au   Av}   Aw^   Ax?   Ay    Az   Az   A{   A|   A}   A~f   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   A   A   A   Ap   AQ   A2   A   A   A   AĶ   Aŗ   Ax   AY   A:   A   A   A   A˾   A̟   À   A   A   Aӧ   AԈ   Ai   AJ   A+   A   A   A   Aگ   Aې   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   Ac   A	D   A
%   A   A   A   A
   A   Ak   AL   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A    A    A!   A"   A#   A$   A%d   A&E   A'&   A(   A(   A)   A*   A+   A,l   A-M   A..   A/   A/   A0   A1   A2   A3t   A4U   A56   A6   A6   A7   A8   A9   A:|   A;]   A<>   A=   A>    A>   A?   A@   AA   ABe   ACF   AD'   AE   AE   AF   AG   AH   AIm   AJN   AK/   AL   AL   AM   AN   AO   APu   AQV   AR7   AS   AS   AT   AU   AV   AW}   AX^   AY?   AZ    A[   A[   A\   A]   A^   A_f   A`G   Aa(   Ab	   Ab   Ac   Ad   Ae   Afn   AgO   Ah0   Al   Amv   AnW   Ao8   Ap   Ap   Aq   Ar   As   At~   Au_   Av@   Aw!   Ax   Ax   Ay   Az   A{   A|g   A}H   A~)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A_)   A`
   A`   Aa   Ab   Ac   Ado   AeP   Af1   Ag   Ag   Ah   Ai   Aj   Akw   AlX   Am9   An   An   Ao   AtA   Au"   Av   Av   Aw   Ax   Ay   Azh   A{I   A|*   A}   A}   A~   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A%   A   A   A   Aϩ   AЊ   Ak   AL   A-   A   A   A   Aֱ   Aג   As   AT   A5   A   A   A   Aݹ   Aޚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A     A    A   A   A   Ae   AF   A'   A   A   A   A	   A
   Am   AN   A
/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A$	   A$   A%   A&   A'   A(n   A)O   A*0   A+   A+   A,   A-   A.   A/v   A0W   A18   A2   A2   A3   A4   A5   A6~   A7_   A8@   A9!   A:   A:   A;   A<   A=   A>g   A?H   A@)   AA
   AA   AB   AC   AD   AEo   AFP   AG1   AH   AH   AI   AJ   AK   ALw   AMX   AN9   AO   AO   AP   AQ   AR   AS   AT`   AUA   AV"   AW   AW   AX   AY   AZ   A[h   A\I   A]*   A^   A^   A_   A`   Aa   Abp   AcQ   Ad2   Ae   Ae   Af   Ag   Ah   Aix   AjY   Ak:   Al   Al   Am   An   Ao   Ap   Aqa   ArB   As#   At   At   Au   Av   Aw   A{   A|   A}   A~   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AƢ   Aǃ   Ad   AE   A&   A   A   A   Aͪ   A΋   Al   A   AԲ   AՓ   At   AU   A6   A   A   A   Aۺ   Aܛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A    A   Af   AG   A(   A	   A   A   A   A   A	n   A
O   A0   A   A   A
   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   A H   A!)   A"
   A"   A#   A$   A%   A&o   A'P   A+   A,   A-w   A.X   A/9   A0   A0   A1   A2   A3   A4   A5`   A6A   A7"   A8   A8   A9   A:   A;   A<h   A=I   A>*   A?   A?   A@   AA   AB   ACp   ADQ   AE2   AF   AF   AG   AH   AI   AJx   AKY   AL:   AM   AM   AN   AO   AP   AQ   ARa   ASB   AT#   AU   AU   AV   AW   AX   AYi   AZJ   A[+   A\   A\   A]   A^   A_   A`q   AaR   Ab3   Ac   Ac   Ad   Ae   Af   Agy   AhZ   Ai;   Aj   Aj   Ak   Al   Am   An   Aob   ApC   Aq$   Ar   Ar   As   At   Au   Avj   AwK   Ax,   Ay
   Ay   Az   A{   A|   A}r   A~S   A4   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aģ   Ań   Ae   AF   A'   A   A   A   A˫   Ǎ   Am   AN   A/   A   A   A   Aҳ   AӔ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   A g   AH   A)   A
   A   A   A   A   Ao   AP   A	1   A
   A
   A   A   A
   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A    A    A!   A"   A#   A$p   A%Q   A&2   A'   A'   A(   A)   A*   A+x   A,Y   A-:   A.   A.   A3a   A4B   A5#   A6   A6   A7   A8   A9   A:i   A;J   A<+   A=   A=   A>   A?   A@   AAq   ABR   AC3   AD   AD   AE   AF   AG   AHy   AIZ   AJ;   AK   AK   AL   AM   AN   AO   APb   AQC   AR$   AS   AS   AT   AU   AV   AWj   AXK   AY,   AZ
   AZ   A[   A\   A]   A^r   A_S   A`4   Aa   Aa   Ab   Ac   Ad   Aez   Af[   Ag<   Ah   Ah   Ai   Aj   Ak   Al   Amc   AnD   Ao%   Ap   Ap   Aq   Ar   As   Atk   AuL   Av-   Aw   Aw   Ax   Ay   Az   A{s   A|T   A}5   A~   A~   A   A   A   A{   A\   A=   A   A   A   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A¤   AÅ   Af   AG   A(   A	   A   A   Aɬ   Aʍ   An   AO   A0   A   A   A   Aд   Aѕ   Av   AW   A8   A   A   A   A׼   A؝   A~   A_   A@   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A *   A   A   A   A   A   Ap   AQ   A2   A   A   A	   A
   A   Ax   A
Y   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A    A!   A"q   A#R   A$3   A%   A%   A&   A'   A(   A)y   A*Z   A+;   A,   A,   A-   A.   A/   A0   A1b   A2C   A3$   A4   A4   A5   A6   A;
   A;   A<   A=   A>   A?r   A@S   AA4   AB   AB   AC   AD   AE   AFz   AG[   AH<   AI   AI   AJ   AK   AL   AM   ANc   AOD   AP%   AQ   AQ   AR   AS   AT   AUk   AVL   AW-   AX   AX   AY   AZ   A[   A\s   A]T   A^5   A_   A_   A`   Aa   Ab   Ac{   Ad\   Ae=   Af   Af   Ag   Ah   Ai   Aj   Akd   AlE   Am&   An   An   Ao   Ap   Aq   Arl   AsM   At.   Au   Au   Av   Aw   Ax   Ayt   AzU   A{6   A|   A|   A}   A~   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   Aǭ   AȎ   Ao   AP   A1   A   A   A   Aε   Aϖ   Aw   AX   A9   A   A   A   Aս   A֞   A   A`   AA   A"   A   A   A   Aݦ   Aއ   Ah   AI   A*   A   A   A   A   A   Ap   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A    A   A   Aq   AR   A3   A   A   A   A   A	   A
y   AZ   A;   A
   A
   A   A   A   A   Ab   AC   A$   A   A   A   Aj   AK   A,   A
   A   A   A   A   A r   A!S   A"4   A#   A#   A$   A%   A&   A'z   A([   A)<   A*   A*   A+   A,   A-   A.   A/c   A0D   A1%   A2   A2   A3   A4   A5   A6k   A7L   A8-   A9   A9   A:   A;   A<   A=s   A>T   AB   AC   AD{   AE\   AF=   AG   AG   AH   AI   AJ   AK   ALd   AME   AN&   AO   AO   AP   AQ   AR   ASl   ATM   AU.   AV   AV   AW   AX   AY   AZt   A[U   A\6   A]   A]   A^   A_   A`   Aa|   Ab]   Ac>   Ad   Ae    Ae   Af   Ag   Ah   Aie   AjF   Ak'   Al   Al   Am   An   Ao   Apm   AqN   Ar/   As   As   At   Au   Av   Awu   AxV   Ay7   Az   Az   A{   A|   A}   A~}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   AŮ   AƏ   Ap   AQ   A2   A   A   A   A̶   A͗   Ax   AY   A:   A   A   A   AӾ   Aԟ   AՀ   Aa   AB   A#   A   A   A   Aۧ   A܈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A    Ar   AS   A4   A   A   A   A   A   Az   A	[   A
<   A   A   A   A
   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A 5   A!   A!   A"   A#   A$   A%{   A&\   A'=   A(   A(   A)   A*   A+   A,   A-d   A.E   A/&   A0   A0   A1   A2   A3   A4l   A5M   A6.   A7   A7   A8   A9   A:   A;t   A<U   A=6   A>   A>   A?   A@   AA   AB|   AC]   AD>   AE   AF    AJe   AKF   AL'   AM   AM   AN   AO   AP   AQm   ARN   AS/   AT   AT   AU   AV   AW   AXu   AYV   AZ7   A[   A[   A\   A]   A^   A_}   A`^   Aa?   Ab    Ac   Ac   Ad   Ae   Af   Agf   AhG   Ai(   Aj	   Aj   Ak   Al   Am   Ann   AoO   Ap0   Aq   Aq   Ar   As   At   Auv   AvW   Aw8   Ax   Ax   Ay   Az   A{   A|~   A}_   A~@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   Aï   AĐ   Aq   AR   A3   A   A   A   Aʷ   A˘   Ay   AZ   A;   A   A   A   Aѿ   AҠ   AӁ   Ab   AC   A$   A   A   A   A٨   Aډ   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A-   A   A   A   A   A   As   A T   A5   A   A   A   A   A   A{   A\   A=   A	   A	   A
   A   A   A
   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A    A!   A"   A#|   A$]   A%>   A&   A'    A'   A(   A)   A*   A+e   A,F   A-'   A.   A.   A/   A0   A1   A2m   A3N   A4/   A5   A5   A6   A7   A8   A9u   A:V   A;7   A<   A<   A=   A>   A?   A@}   AA^   AB?   AC    AD   AD   AE   AF   AG   AHf   AIG   AJ(   AK	   AK   AL   AM   AR   AR   AS   AT   AU   AVv   AWW   AX8   AY   AY   AZ   A[   A\   A]~   A^_   A_@   A`!   Aa   Aa   Ab   Ac   Ad   Aeg   AfH   Ag)   Ah
   Ah   Ai   Aj   Ak   Alo   AmP   An1   Ao   Ao   Ap   Aq   Ar   Asw   AtX   Au9   Av   Av   Aw   Ax   Ay   Az   A{`   A|A   A}"   A~   A~   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   Aȸ   Aə   Az   A[   A<   A   A   A   A   AС   Aт   Ac   AD   A%   A   A   A   Aש   A؊   Ak   AL   A-   A   A   A   Aޱ   Aߒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   A    A    A    A |   A ]   A >   A    A     A    A 	   A 
   A    A e   A 
F   A '   A    A    A    A    A    A m   A N   A /   A    A    A    A    A    A u   A V   A 7   A    A    A    A    A     A !}   A "^   A #?   A $    A %   A %   A &   A '   A (   A )f   A *G   A +(   A ,	   A ,   A -   A .   A /   A 0n   A 1O   A 20   A 3   A 3   A 4   A 5   A 6   A 7v   A 8W   A 98   A :   A :   A ;   A <   A =   A >~   A ?_   A @@   A A!   A B   A B   A C   A D   A E   A Fg   A GH   A H)   A I
   A I   A J   A K   A L   A Mo   A NP   A O1   A P   A P   A Q   A R   A S   A Tw   A UX   A Y   A Z   A [   A \`   A ]A   A ^"   A _   A _   A `   A a   A b   A ch   A dI   A e*   A f   A f   A g   A h   A i   A jp   A kQ   A l2   A m   A m   A n   A o   A p   A qx   A rY   A s:   A t   A t   A u   A v   A w   A x   A ya   A zB   A {#   A |   A |   A }   A ~   A    A i   A J   A +   A    A    A    A    A    A q   A R   A 3   A    A    A    A    A    A y   A Z   A ;   A    A    A    A    A    A    A b   A C   A $   A    A    A    A    A    A j   A K   A ,   A 
   A    A    A    A    A r   A S   A 4   A    A    A    A    A    A z   A [   A <   A    A    A c   A D   A %   A    A    A    A    A    A k   A L   A -   A    A    A    A    A    A s   A T   A 5   A    A    A    A ƹ   A ǚ   A {   A \   A =   A    A    A    A    A ΢   A σ   A d   A E   A &   A    A    A    A ժ   A ֋   A l   A M   A .   A    A    A    A ܲ   A ݓ   A t   A U   A 6   A    A    A    A    A    A |   A ]   A >   A    A     A    A    A    A    A e   A F   A '   A    A    A    A    A    A m   A N   A /   A    A    A    A    A    A u   A V   A 7   A    A    A    A    A   A}   A^   A?   A    A   A   A   A   A	   A
f   AG   A(   A
	   A
   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A _   A!@   A"!   A#   A#   A$   A%   A&   A'g   A(H   A))   A*
   A*   A+   A,   A-   A.o   A/P   A01   A1   A1   A2   A3   A4   A5w   A6X   A79   A8   A8   A9   A:   A;   A<   A=`   A>A   A?"   A@   A@   AA   AB   AC   ADh   AEI   AF*   AG   AG   AH   AI   AJ   AKp   ALQ   AM2   AN   AN   AO   AP   AQ   ARx   ASY   AT:   AU   AU   AV   AW   AX   AY   AZa   A[B   A\#   A]   Aai   AbJ   Ac+   Ad   Ad   Ae   Af   Ag   Ahq   AiR   Aj3   Ak   Ak   Al   Am   An   Aoy   ApZ   Aq;   Ar   Ar   As   At   Au   Av   Awb   AxC   Ay$   Az   Az   A{   A|   A}   A~j   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A   A   A   Ad   AE   A&   A   A   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   Aĺ   Aś   A|   A]   A>   A   A    A   A   A̣   A̈́   Ae   AF   A'   A   A   A   Aӫ   AԌ   Am   AN   A/   A   A   A   Aڳ   A۔   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A ~   A_   A@   A!   A   A   A   A   A   Ag   A	H   A
)   A
   A   A   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A "   A!   A!   A"   A#   A$   A%h   A&I   A'*   A(   A(   A)   A*   A+   A,p   A-Q   A.2   A/   A/   A0   A1   A2   A3x   A4Y   A5:   A6   A6   A7   A8   A9   A:   A;a   A<B   A=#   A>   A>   A?   A@   AA   ABi   ACJ   AD+   AE   AE   AF   AG   AH   AIq   AJR   AK3   AL   AL   AM   AN   AO   APy   AQZ   AR;   AS   AS   AT   AU   AV   AW   AXb   AYC   AZ$   A[   A[   A\   A]   A^   A_j   A`K   Aa,   Ab
   Ab   Ac   Ad   Ai   Ai   Aj   Ak   Al   Amz   An[   Ao<   Ap   Ap   Aq   Ar   As   At   Auc   AvD   Aw%   Ax   Ax   Ay   Az   A{   A|k   A}L   A~-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   A   A   A»   AÜ   A}   A^   A?   A    A   A   A   Aʤ   A˅   Af   AG   A(   A	   A   A   AѬ   Aҍ   An   AO   A0   A   A   A   Aش   Aٕ   Av   AW   A8   A   A   A   A߼   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   A A   A"   A   A   A   A   A   Ah   AI   A*   A	   A	   A
   A   A   A
p   AQ   A2   A   A   A   A   A   Ax   A   A   A   A   Aa   AB   A#   A   A   A    A!   A"   A#i   A$J   A%+   A&   A&   A'   A(   A)   A*q   A+R   A,3   A-   A-   A.   A/   A0   A1y   A2Z   A3;   A4   A4   A5   A6   A7   A8   A9b   A:C   A;$   A<   A<   A=   A>   A?   A@j   AAK   AB,   AC
   AC   AD   AE   AF   AGr   AHS   AI4   AJ   AJ   AK   AL   AM   ANz   AO[   AP<   AQ   AQ   AR   AS   AT   AU   AVc   AWD   AX%   AY   AY   AZ   A[   A\   A]k   A^L   A_-   A`   A`   Aa   Ab   Ac   Ads   AeT   Af5   Ag   Ag   Ah   Ai   Aj   Ak{   Al\   Ap   Aq   Ar   Asd   AtE   Au&   Av   Av   Aw   Ax   Ay   Azl   A{M   A|.   A}   A}   A~   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   Aȥ   AɆ   Ag   AH   A)   A
   A   A   Aϭ   AЎ   Ao   AP   A1   A   A   A   Aֵ   Aז   Aw   AX   A9   A   A   A   Aݽ   Aޞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A    A    A   A   A   Ai   AJ   A+   A   A   A   A	   A
   Aq   AR   A
3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A    A!j   A"K   A#,   A$
   A$   A%   A&   A'   A(r   A)S   A*4   A+   A+   A,   A-   A.   A/z   A0[   A1<   A2   A2   A3   A4   A5   A6   A7c   A8D   A9%   A:   A:   A;   A<   A=   A>k   A?L   A@-   AA   AA   AB   AC   AD   AEs   AFT   AG5   AH   AH   AI   AJ   AK   AL{   AM\   AN=   AO   AO   AP   AQ   AR   AS   ATd   AUE   AV&   AW   AW   AX   AY   AZ   A[l   A\M   A].   A^   A^   A_   A`   Aa   Abt   AcU   Ad6   Ae   Ae   Af   Ag   Ah   Ai|   Aj]   Ak>   Al   Am    Am   An   Ao   Ap   Aqe   ArF   As'   At   Axm   AyN   Az/   A{   A{   A|   A}   A~   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   AƦ   AǇ   Ah   AI   A*   A   A   AQ   A2   A   A   A   AԶ   A՗   Ax   AY   A:   A   A   A   A۾   Aܟ   A݀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A    A   Aj   AK   A,   A
   A   A   A   A   A	r   A
S   A4   A   A   A
   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   A L   A!-   A"   A"   A#   A(5   A)   A)   A*   A+   A,   A-{   A.\   A/=   A0   A0   A1   ARe   ASF   AT'   AU   AU   AV   AW   AX   AYm   AZN   A[/   A\   A\   A]   A^   A_   A`u   AaV   Ab7   Ac   Ac   Ad   Ae   Af   Ag}   Ah^   Ai?   Aj    Ak   Ak   Al   Am   An   Aof   ApG   Aq(   Ar	   Ar   As   At   Au   Avn   AwO   Ax0   Ay   Ay   Az   A{   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   Aħ   Aň   A   A   A˯   A̐   Aq   AR   A3   A   A   A   Aҷ   AӘ   Ay   AZ   A;   A   A   A   Aٿ   Aڠ   Aہ   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   A k   AL   A-   A   A   A   A   A   As   AT   A	5   A
   A
   A   A   A
   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A    A    A!   A"   A#   A$t   A%U   A&6   A'   A'   A(   A)   A*   A+|   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A .   A   A   A   A   A   At   AU   A6   A   A   A	   A
   A   A|   A
]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A    A!   A"u   A#V   A$7   A%   A%   A&   A'   A(   A)}   A*^   A+?   A,    A-   A-   A.   A/   A0   A1f   A2G   A3(   A7   A8n   A9O   A:0   A;   A;   A<   A=   A>   A?v   A@W   AA8   AB   AB   AC   AD   AE   AF~   AG_   AH@   AI!   AJ   AJ   AK   AL   AM   ANg   AOH   AP)   AQ
   AQ   AR   AS   AT   AUo   AVP   AW1   AX   AX   AY   AZ   A[   A\w   A]X   A^9   A_   A_   A`   Aa   Ab   Ac   Ad`   AeA   Af"   Ag   Ag   Ah   Ai   Aj   Akh   AlI   Am*   An   An   Ao   Ap   Aq   Arp   AsQ   At2   Au   Au   Av   Aw   Ax   Ayx   AzY   A{:   A|   A|   A}   A~   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   AǱ   AȒ   As   AT   A5   A   A   A   Aι   AϚ   A{   A\   A=   A   A   A   A   A֢   A׃   Ad   AE   A&   A   A   A   Aݪ   Aދ   Al   AM   A.   A   A   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A    A   A   Au   AV   A7   A   A   A   A   A	   A
}   A^   A?   A
    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   A v   A!W   A"8   A#   A#   A$   A%   A&   A'~   A(_   A)@   A*!   A+   A+   A,   A-   A.   A/g   A0H   A1)   A2
   A2   A3   A4   A5   A6o   A7P   A81   A9   A9   A:   A?9   A@   A@   AA   AB   AC   AD   AE`   AFA   AG"   AH   AH   AI   AJ   AK   ALh   AMI   AN*   AO   AO   AP   AQ   AR   ASp   ATQ   AU2   AV   AV   AW   AX   AY   AZx   A[Y   A\:   A]   A]   A^   A_   A`   Aa   Aba   AcB   Ad#   Ae   Ae   Af   Ag   Ah   Aii   AjJ   Ak+   Al   Al   Am   An   Ao   Apq   AqR   Ar3   As   As   At   Au   Av   Awy   AxZ   Ay;   Az   Az   A{   A|   A}   A~   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   AŲ   AƓ   At   AU   A6   A   A   A   A̺   A͛   A|   A]   A>   A   A    A   A   Aԣ   AՄ   Ae   AF   A'   A   A   A   A۫   A܌   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A	    A	v   A	W   A	8   A	   A	   A	   A	   A	   A	~   A		_   A	
@   A	!   A	   A	   A	
   A	   A	   A	g   A	H   A	)   A	
   A	   A	   A	   A	   A	o   A	P   A	1   A	   A	   A	   A	   A	   A	w   A	X   A	 9   A	!   A	!   A	"   A	#   A	$   A	%   A	&`   A	'A   A	("   A	)   A	)   A	*   A	+   A	,   A	-h   A	.I   A	/*   A	0   A	0   A	1   A	2   A	3   A	4p   A	5Q   A	62   A	7   A	7   A	8   A	9   A	:   A	;x   A	<Y   A	=:   A	>   A	>   A	?   A	@   A	A   A	B   A	F   A	G   A	H   A	I   A	Ji   A	KJ   A	L+   A	M   A	M   A	N   A	O   A	P   A	Qq   A	RR   A	S3   A	T   A	T   A	U   A	V   A	W   A	Xy   A	YZ   A	Z;   A	[   A	[   A	\   A	]   A	^   A	_   A	`b   A	aC   A	b$   A	c   A	c   A	d   A	e   A	f   A	gj   A	hK   A	i,   A	j
   A	j   A	k   A	l   A	m   A	nr   A	oS   A	p4   A	q   A	q   A	r   A	s   A	t   A	uz   A	v[   A	w<   A	x   A	x   A	y   A	z   A	{   A	|   A	}c   A	~D   A	%   A	   A	   A	   A	   A	   A	k   A	L   A	-   A	   A	   A	   A	   A	   A	s   A	T   A	5   A	   A	   A	   A	   A	   A	{   A	\   A	   A	   A	   A	l   A	M   A	.   A	   A	   A	   A	   A	   A	t   A	U   A	6   A	   A	   A	   A	   A	   A	|   A	]   A	>   A	   A	    A	   A	   A	   A	   A	e   A	F   A	'   A	   A	   A	   A	   A	   A	m   A	N   A	/   A	   A	   A	   A	ó   A	Ĕ   A	u   A	V   A	7   A	   A	   A	   A	ʻ   A	˜   A	}   A	^   A	?   A	    A	   A	   A	   A	Ҥ   A	Ӆ   A	f   A	G   A	(   A		   A	   A	   A	٬   A	ڍ   A	n   A	O   A	0   A	   A	   A	   A	   A	   A	v   A	W   A	8   A	   A	   A	   A	   A	   A	~   A	_   A	@   A	!   A	   A	   A	   A	   A	   A	g   A	H   A	   A	   A	o   A	P   A	1   A	   A	   A	   A	   A	   A	w   A
 X   A
9   A
   A
   A
   A
   A
   A
   A
`   A
A   A
	"   A

   A

   A
   A
   A

   A
h   A
I   A
*   A
   A
   A
   A
   A
   A
p   A
Q   A
2   A
   A
   A
   A
   A
   A
x   A
Y   A
:   A
   A
   A
    A
!   A
"   A
#   A
$a   A
%B   A
&#   A
'   A
'   A
(   A
)   A
*   A
+i   A
,J   A
-+   A
.   A
.   A
/   A
0   A
1   A
2q   A
3R   A
43   A
5   A
5   A
6   A
7   A
8   A
9y   A
:Z   A
;;   A
<   A
<   A
=   A
>   A
?   A
@   A
Ab   A
BC   A
C$   A
D   A
D   A
E   A
F   A
G   A
Hj   A
IK   A
J,   A
N   A
Or   A
PS   A
Q4   A
R   A
R   A
S   A
T   A
U   A
Vz   A
W[   A
X<   A
Y   A
Y   A
Z   A
[   A
\   A
]   A
^c   A
_D   A
`%   A
a   A
a   A
b   A
c   A
d   A
ek   A
fL   A
g-   A
h   A
h   A
i   A
j   A
k   A
ls   A
mT   A
n5   A
o   A
o   A
p   A
q   A
r   A
s{   A
t\   A
u=   A
v   A
v   A
w   A
x   A
y   A
z   A
{d   A
|E   A
}&   A
~   A
~   A
   A
   A
   A
l   A
M   A
.   A
   A
   A
   A
   A
   A
t   A
U   A
6   A
   A
   A
   A
   A
   A
|   A
]   A
>   A
   A
    A
   A
   A
   A
   A
e   A
F   A
'   A
   A
   A
   A
   A
   A
m   A
N   A
/   A
   A
u   A
V   A
7   A
   A
   A
   A
   A
   A
}   A
^   A
?   A
    A
   A
   A
   A
   A
   A
f   A
G   A
(   A
	   A
   A
   A
   A
   A
n   A
O   A
0   A
   A
   A
   A
   A
   A
v   A
W   A
8   A
   A
   A
   A
ȼ   A
ɝ   A
~   A
_   A
@   A
!   A
   A
   A
   A
Х   A
ц   A
g   A
H   A
)   A

   A
   A
   A
׭   A
؎   A
o   A
P   A
1   A
   A
   A
   A
޵   A
ߖ   A
w   A
X   A
9   A
   A
   A
   A
   A
   A
   A
`   A
A   A
"   A
   A
   A
   A
   A
   A
h   A
I   A
*   A
   A
   A
   A
   A
   A
p   A
Q   A
2   A
   A
   A
Y   A
:   A    A    A   A   A   A   Aa   AB   A#   A   A   A	   A
   A   Ai   A
J   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A    A!   A"b   A#C   A$$   A%   A%   A&   A'   A(   A)j   A*K   A+,   A,
   A,   A-   A.   A/   A0r   A1S   A24   A3   A3   A4   A5   A6   A7z   A8[   A9<   A:   A:   A;   A<   A=   A>   A?c   A@D   AA%   AB   AB   AC   AD   AE   AFk   AGL   AH-   AI   AI   AJ   AK   AL   AMs   ANT   AO5   AP   AP   AQ   AV=   AW   AW   AX   AY   AZ   A[   A\d   A]E   A^&   A_   A_   A`   Aa   Ab   Acl   AdM   Ae.   Af   Af   Ag   Ah   Ai   Ajt   AkU   Al6   Am   Am   An   Ao   Ap   Aq|   Ar]   As>   At   Au    Au   Av   Aw   Ax   Aye   AzF   A{'   A|   A|   A}   A~   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   Aƽ   AǞ   A   A`   AA   A"   A   A   A   AΦ   Aχ   Ah   AI   A*   A   A   A   Aծ   A֏   Ap   AQ   A2   A   A   A   Aܶ   Aݗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A    A   A   A   A   A   A	   A
j   AK   A,   A

   A
   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   A c   A!D   A"%   A#   A#   A$   A%   A&   A'k   A(L   A)-   A*   A*   A+   A,   A-   A.s   A/T   A05   A1   A1   A2   A3   A4   A5{   A6\   A7=   A8   A8   A9   A:   A;   A<   A=d   A>E   A?&   A@   A@   AA   AB   AC   ADl   AEM   AF.   AG   AG   AH   AI   AJ   AKt   ALU   AM6   AN   AN   AO   AP   AQ   AR|   AS]   AT>   AU   AV    AV   AW   AX   AY   A]   A^   A_   A`   Aam   AbN   Ac/   Ad   Ad   Ae   Af   Ag   Ahu   AiV   Aj7   Ak   Ak   Al   Am   An   Ao}   Ap^   Aq?   Ar    As   As   At   Au   Av   Awf   AxG   Ay(   Az	   Az   A{   A|   A}   A~n   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   Aľ   Aş   Aƀ   Aa   AB   A#   A   Ai   AJ   A+   A   A   A   Aӯ   AԐ   Aq   AR   A3   A   A   A   Aڷ   Aۘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A
    A
c   A
D   A
%   A
   A
   A
   A
   A
   A
k   A
	L   A

   A
   A
s   A
T   A
5   A
   A
   A
   A
   A
   A
{   A
\   A
=   A
   A
   A
   A
   A
   A
   A
d   A
E   A
 &   A
!   A
!   A
"   A
#   A
$   A
%l   A
4]   A
5>   A
6   A
7    A
T   A
T   A
U   A
V   A
W   A
Xf   A
YG   A
Z(   A
[	   A
[   A
\   A
]   A
^   A
_n   A
`O   A
a0   A
e   A
fv   A
gW   A
h8   A
i   A
i   A
j   A
k   A
l   A
m~   A
n_   A
o@   A
p!   A
q   A
q   A
r   A
s   A
t   A
ug   A
vH   A
w)   A
x
   A
x   A
y   A
z   A
{   A
|o   A
}P   A
~1   A
   A
   A
   A
   A
   A
w   A
X   A
9   A
   A
   A
   A
   A
   A
   A
`   A
A   A
"   A
   A
   A
   A
   A
   A
h   A
I   A
*   A
   A
   A
   A
   A
   A
p   A
Q   A
2   A
   A
   A
   A
   A
   A
x   A
Y   A
:   A
   A
   A
   A
   A
   A
   A
a   A
B   A
#   A
   A
   A
   A
   A
   A
i   A
J   A
+   A
   A
   A
   A
   A
   A
q   A
R   A
3   A
   A
y   A
Z   A
;   A
   A
   A
   A
¿   A
à   A
ā   A
b   A
C   A
$   A
   A
   A
   A
ʨ   A
ˉ   A
j   A
K   A
,   A

   A
   A
   A
Ѱ   A
ґ   A
r   A
S   A
4   A
   A
   A
   A
ظ   A
ٙ   A
z   A
[   A
<   A
   A
   A
   A
   A
   A
   A
c   A
D   A
%   A
   A
   A
   A
   A
   A
k   A
L   A
-   A
   A
   A
   A
   A
   A
s   A
T   A
5   A
   A
   A
   A
   A
   A
{   A
\   A
=   A
   A
   A
   A
   A
   A
   A
d   A E   A&   A   A   A   A   A   Al   AM   A.   A	   A	   A
   A   A   A
t   AU   A6   A   A   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A    A!   A"   A#m   A$N   A%/   A&   A&   A'   A(   A)   A*u   A+V   A,7   A-   A-   A.   A/   A0   A1}   A2^   A3?   A4    A5   A5   A6   A7   A8   A9f   A:G   A;(   A<	   A<   A=   A>   A?   A@n   AAO   AB0   AC   AC   AD   AE   AF   AGv   AHW   AI8   AJ   AJ   AK   AL   AM   AN~   AO_   AP@   AQ!   AR   AR   AS   AT   AU   AVg   AWH   AX)   AY
   AY   AZ   A[   A\   A]o   A^P   A_1   A`   A`   Aa   Ab   Ac   Adw   AeX   Af9   Ag   Ag   Ah   AmA   An"   Ao   Ao   Ap   Aq   Ar   Ash   AtI   Au*   Av   Av   Aw   Ax   Ay   Azp   A{Q   A|2   A}   A}   A~   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A%   A   A   A   Aȩ   AɊ   Ak   AL   A-   A   A   A   Aϱ   AВ   As   AT   A5   A   A   A   Aֹ   Aך   A{   A\   A=   A   A   A   A   Aޢ   A߃   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A    A    A   A   A   Am   AN   A/   A   A   A   A	   A
   Au   AV   A
7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A	   A   A   A   A    A!n   A"O   A#0   A$   A$   A%   A&   A'   A(v   A)W   A*8   A+   A+   A,   A-   A.   A/~   A0_   A1@   A2!   A3   A3   A4   A5   A6   A7g   A8H   A9)   A:
   A:   A;   A<   A=   A>o   A?P   A@1   AA   AA   AB   AC   AD   AEw   AFX   AG9   AH   AH   AI   AJ   AK   AL   AM`   ANA   AO"   AP   AP   AQ   AR   AS   ATh   AUI   AV*   AW   AW   AX   AY   AZ   A[p   A\Q   A]2   A^   A^   A_   A`   Aa   Abx   AcY   Ad:   Ae   Ae   Af   Ag   Ah   Ai   Aja   AkB   Al#   Am   Am   An   Ao   Ap   At   Au   Av   Aw   Axq   AyR   Az3   A{   A{   A|   A}   A~   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   Aƪ   Aǋ   Al   A   AͲ   AΓ   At   AU   A6   A   A   A   AԺ   A՛   A|   A]   A>   A   A    A   A   Aܣ   A݄   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A    A   An   AO   A0   A   A   A   A   A   A	v   A
W   A8   A   A   A
   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   A P   A$   A%   A&w   A'X   A(9   A)   A)   A*   A+   A,   A-   A.`   A/A   A0"   A1   A1   A2   A3   A4   A5h   A6I   A7*   A8   A8   A9   A:   A;   A<p   A=Q   A>2   A?   A?   A@   AA   AB   ACx   ADY   AE:   AF   AF   AG   AH   AI   AJ   AKa   ALB   AM#   AN   AN   AO   AP   AQ   ARi   ASJ   AT+   AU   AU   AV   AW   AX   AYq   AZR   A[3   A\   A\   A]   A^   A_   A`y   AaZ   Ab;   Ac   Ac   Ad   Ae   Af   Ag   Ahb   AiC   Aj$   Ak   Ak   Al   Am   An   Aoj   ApK   Aq,   Ar
   Ar   As   At   Au   Avr   AwS   Ax4   A|   A}z   A~[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   Ad   Ae   Afc   AgD   Ah%   Ai   Ai   Aj   Ak   Al   Amk   AnL   Ao-   Ap   Ap   Aq   Ar   As   Ats   AuT   Av5   Aw   Aw   Ax   Ay   Az   A{{   A|\   A}=   A~   A~   A   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A¬   AÍ   An   AO   A0   A   A   A   Aɴ   Aʕ   Av   AW   A8   A   A   A   Aм   Aѝ   A~   A_   A@   A!   A   A   A   Aإ   Aن   Ag   AH   A)   A
   A   A   A߭   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A 2   A   A   A   A   A   Ax   AY   A:   A   A   A	   A
   A   A   A
a   AB   A#   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A    A!   A"y   A#Z   A$;   A%   A%   A&   A'   A(   A)   A*b   A+C   A,$   A4
   A4   A5   A6   A7   A8r   A9S   A:4   A;   A;   A<   A=   A>   A?z   A@[   AA<   AB   AB   AC   AD   AE   AF   AGc   AHD   AI%   AJ   AJ   AK   AL   AM   ANk   AOL   AP-   AQ   AQ   AR   AS   AT   AUs   AVT   AW5   AX   AX   AY   AZ   A[   A\{   A]\   A^=   A_   A_   A`   Aa   Ab   Ac   Add   AeE   Af&   Ag   Ag   Ah   Ai   Aj   Akl   AlM   Am.   An   An   Ao   Ap   Aq   Art   AsU   At6   Au   Au   Av   Aw   Ax   Ay|   Az]   A{>   A|   A}    A}   A~   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   Aǵ   AȖ   Aw   AX   A9   A   A   A   Aν   AϞ   A   A`   AA   A"   A   A   A   A֦   Aׇ   Ah   AI   A*   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A    A   A   Ay   AZ   A;   A   A   A   A   A	   A
   Ab   AC   A
$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   A z   A![   A"<   A#   A#   A$   A%   A&   A'   A(c   A)D   A*%   A+   A+   A,   A-   A.   A/k   A0L   A1-   A2   A2   A3   A4   A5   A6s   A7T   A;   A<   A={   A>\   A?=   A@   A@   AA   AB   AC   AD   AEd   AFE   AG&   AH   AH   AI   AJ   AK   ALl   AMM   AN.   AO   AO   AP   AQ   AR   ASt   ATU   AU6   AV   AV   AW   AX   AY   AZ|   A[]   A\>   A]   A^    A^   A_   A`   Aa   Abe   AcF   Ad'   Ae   Ae   Af   Ag   Ah   Aim   AjN   Ak/   Al   Al   Am   An   Ao   Apu   AqV   Ar7   As   As   At   Au   Av   Aw}   Ax^   Ay?   Az    A{   A{   A|   A}   A~   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   AŶ   AƗ   Ax   AY   A:   A   A   A   A̾   A͟   A΀   Aa   AB   A#   A   A   A   Aԧ   AՈ   Ai   AJ   A+   A   A   A   Aۯ   Aܐ   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A    Az   A[   A<   A   A   A   A   A   A   A	c   A
D   A%   A   A   A
   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A =   A!   A!   A"   A#   A$   A%   A&d   A'E   A(&   A)   A)   A*   A+   A,   A-l   A.M   A/.   A0   A0   A1   A2   A3   A4t   A5U   A66   A7   A7   A8   A9   A:   A;|   A<]   A=>   A>   A?    ACe   ADF   AE'   AF   AF   AG   AH   AI   AJm   AKN   AL/   AM   AM   AN   AO   AP   AQu   ARV   AS7   AT   AT   AU   AV   AW   AX}   AY^   AZ?   A[    A\   A\   A]   A^   A_   A`f   AaG   Ab(   Ac	   Ac   Ad   Ae   Af   Agn   AhO   Ai0   Aj   Aj   Ak   Al   Am   Anv   AoW   Ap8   Aq   Aq   Ar   As   At   Au~   Av_   Aw@   Ax!   Ay   Ay   Az   A{   A|   A}g   A~H   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A÷   AĘ   Ay   AZ   A;   A   A   A   Aʿ   Aˠ   A́   Ab   AC   A$   A   A   A   AҨ   AӉ   Aj   AK   A,   A
   A   A   Aٰ   Aڑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A \   A=   A   A   A   A   A   A   Ad   AE   A	&   A
   A
   A   A   A
   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A     A    A!   A"   A#   A$e   A%F   A&'   A'   A'   A(   A)   A*   A+m   A,N   A-/   A.   A.   A/   A0   A1   A2u   A3V   A47   A5   A5   A6   A7   A8   A9}   A:^   A;?   A<    A=   A=   A>   A?   A@   AAf   ABG   AC(   AD	   AD   AE   AF   AK   AK   AL   AM   AN   AOv   APW   AQ8   AR   AR   AS   AT   AU   AV~   AW_   AX@   AY!   AZ   AZ   A[   A\   A]   A^g   A_H   A`)   Aa
   Aa   Ab   Ac   Ad   Aeo   AfP   Ag1   Ah   Ah   Ai   Aj   Ak   Alw   AmX   An9   Ao   Ao   Ap   Aq   Ar   As   At`   AuA   Av"   Aw   Aw   Ax   Ay   Az   A{h   A|I   A}*   A~   A~   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   Aɡ   Aʂ   Ac   AD   A%   A   A   A   AЩ   Aъ   Ak   AL   A-   A   A   A   Aױ   Aؒ   As   AT   A5   A   A   A   A޹   Aߚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   A|   A]   A>   A    A    A   A   A   A   Ae   AF   A'   A   A   A	   A
   A   Am   A
N   A/   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A    A!   A"f   A#G   A$(   A%	   A%   A&   A'   A(   A)n   A*O   A+0   A,   A,   A-   A.   A/   A0v   A1W   A28   A3   A3   A4   A5   A6   A7~   A8_   A9@   A:!   A;   A;   A<   A=   A>   A?g   A@H   AA)   AB
   AB   AC   AD   AE   AFo   AGP   AH1   AI   AI   AJ   AK   AL   AMw   ANX   AR   AS   AT   AU`   AVA   AW"   AX   AX   AY   AZ   A[   A\h   A]I   A^*   A_   A_   A`   Aa   Ab   Acp   AdQ   Ae2   Af   Af   Ag   Ah   Ai   Ajx   AkY   Al:   Am   Am   An   Ao   Ap   Aq   Ara   AsB   At#   Au   Au   Av   Aw   Ax   Ayi   AzJ   A{+   A|   A|   A}   A~   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AǢ   Aȃ   Ad   AE   A&   A   A   A   AΪ   Aϋ   Al   AM   A.   A   A   A   Aղ   A֓   At   AU   A6   A   A   A   Aܺ   Aݛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   Af   AG   A(   A	   A   A   A   A	   A
n   AO   A0   A
   A
   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   A g   A!H   A")   A#
   A#   A$   A%   A&   A'o   A(P   A)1   A*   A*   A+   A,   A-   A.w   A/X   A09   A1   A1   A2   A3   A4   A5   A6`   A7A   A8"   A9   A9   A:   A;   A<   A=h   A>I   A?*   A@   A@   AA   AB   AC   ADp   AEQ   AF2   AG   AG   AH   AI   AJ   AKx   ALY   AM:   AN   AN   AO   AP   AQ   AR   ASa   ATB   AU#   AV   AZi   A[J   A\+   A]   A]   A^   A_   A`   Aaq   AbR   Ac3   Ad   Ad   Ae   Af   Ag   Ahy   AiZ   Aj;   Ak   Ak   Al   Am   An   Ao   Apb   AqC   Ar$   As   As   At   Au   Av   Awj   AxK   Ay,   Az
   Az   A{   A|   A}   A~r   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aţ   AƄ   Ae   AF   A'   A   A   A   A̫   A͌   Am   AN   A/   A   A   A   Aӳ   AԔ   Au   AV   A7   A   A   A   Aڻ   Aۜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A    Ag   AH   A)   A
   A   A   A
1   A   A   A   A
   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A *   A!   A!   A"   A#   A$   A%p   A&Q   A'2   A(   A(   A)   A*   A+   A,x   A-Y   A.:   A/   A/   A0   A1   A2   A3   A4a   A5B   A6#   A7   A7   A8   A9   A:   A;i   A<J   A=+   A>   A>   A?   A@   AA   ABq   ACR   AD3   AE   AE   AF   AG   AH   AIy   AJZ   AK;   AL   AL   AM   AN   AO   AP   AQb   ARC   AS$   AT   AT   AU   AV   AW   AXj   AYK   AZ,   A[
   A[   A\   A]   Ab   Ab   Ac   Ad   Ae   Afz   Ag[   Ah<   Ai   Ai   Aj   Ak   Al   Am   Anc   AoD   Ap%   Aq   Aq   Ar   As   At   Auk   AvL   Aw-   Ax   Ax   Ay   Az   A{   A|s   A}T   A~5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   A   A   A   A   A}   A^   A?   A    A   A   A   Aä   Aą   Af   AG   A(   A	   A   A   Aʬ   Aˍ   An   AO   A0   A   A   A   AѴ   Aҕ   Av   AW   A8   A   A   A   Aؼ   Aٝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   A I   A*   A   A   A   A   A   Ap   AQ   A2   A	   A	   A
   A   A   A
x   A   A   A   A   Aa   AB   A#   A   A   A   A   A   AQ%   AR   AR   AS   AT   AU   AVk   AWL   AX-   AY   AY   AZ   A[   A\   A]s   A^T   A_5   A`   A`   Aa   Ab   Ac   Ad{   Ae\   Ai   Aj   Ak   Ald   AmE   An&   Ao   Ao   Ap   Aq   Ar   Asl   AtM   Au.   Av   Av   Aw   Ax   Ay   Azt   A{U   A|6   A}   A}   A~   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A   A   Ag   AH   A)   A
   A   A   Aȭ   AɎ   Ao   AP   A1   A   A   A   Aϵ   AЖ   Aw   AX   A9   A   A   A   Aֽ   Aמ   A   A`   AA   A"   A   A   A   Aަ   A߇   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A    A    A   A   A   Aq   AR   A3   A   A   A   A	   A
   Ay   AZ   A
;   A   A   A   A   AA  A  A(A  AA  AA{AAظRA  B ffB(BHB
=BzBGBB BB(BRBBAA{AAAA(AAAQAAAHAAAffAAAzA
ApA
=AAQA{AA{AQA\AA\AQA{AAGAHA\AQAA
A{AAAA=qAA
=ARAffAA(AGA(AAAɮAA
A  AAGA
=AAAGAAAHA{AQAARAApA=qAAA{A
=ARA  AQAA
=AHAGApA¸RAA33AŮAffAQAA
=A  A=qA
=AÙAAHAzA{AzA{AAAffAApA  A33A
=A\)A(AAffA=qA{AA
AAAAAAAA  AAffAAAQAzA33AA  A(AzAAA33AGApAApAAApA33AAA  A
AHAģA(AȸRAƣAAAffAHA
AGAffAHA
AffAAHA=qA33ApA33AAAA{AA33ApAHAAHAA\)AAAffAGAAAzApAAAAAAQAA\)AA\AAAAHARAA33A\A
AQA\)AA
A(A(ApApAŮAHAAřAAA
AAAƏ\AzAƸRAƏ\AƣAƣAzAƸRAƸRA=qAQAffAQAƏ\A(AHAAƸRAA
AAApAŅAîA33A  AîA¸RAÙAÅA
=AHAQA=qA{AîAAAA{AzAÙA{ApApAA{A33AffA33AGAAHAzAA
=A33ApApA  AffAA33ApAAHAA  AGA=qAzAA{A33A
AzAǅA
AffAffAzA
=AA(AzAA
=A
=A33A\)ApAǅAǅAǮAǅAǙApA\)A33A  AAAHAAAffAAǅAƣAƣAģAď\AĸRA33AffAģAAGA£A=qA(AHARAAA¸RAzAGAĸRAA\)A\)A
A(AHA{AARA33AA(A\)Ay ApA=qAA(AA
A(A33Aď\A
=AHAŮA(ApA\)A{Aď\AzAffAÙAîAAAzA£AffA{AGAAď\AÙAffAA(AģAQAzAAƸRAAA=qA=qA
AffAARA\AGA  AGAAŅAîAQA
AAHAA{AAzA\)A(AHA=qA\AA  ApAŮA=qA(AA  AƣAQAzAƣAAffAƏ\AQA(AřA=qA=qA=qA  AQAQA  AAHAƸRAAA33AAƸRA{ApAǮA33A
A\)AA\)AzAȏ\A=qAHAffA{AffAAAȏ\A33AGA{A(AȣA(A(AAȣA=qAAȣAƸRAƣAApAA=qAAAAffA=qAAffAQAĸRAîAQAHA
=AÅAĸRAA=qAģApAAAHA=qA
A=qAQAřAGAřAƏ\AƏ\AzAGAď\A{A\AQA
A
AA¸RAAÙA\)AAGAA
=A{A  A=qA  A
=AGAffAA
=AAAffA{A(AA?   AA
=A33AHAƣAzAA=qy Az@b\y A  A(AGAA
=AA{AffA\AApAHA\)A¸RAGAffAGAřA  A  AŅAřAřAřAAQAAGA
=AGApA=qA(AȣAɅA
AAA33A33AffAƸRA=qA  A33ApApApAřA  A  AzA\)AÙAGApAGAÅAÙA£AQAÅA
=AîA  y y y y y Affy AAGAGy AAÅAGy AA(AzAď\AģAA
A=qAzA(y AHA=qy AffAÅy y y AA=qA  AHy A@\A
=ApAÙA£A\)AAAQA=qAHA(ApAAď\AA(AApAA\)A=qAAAGAQA(AApA(AGAA
AˮApApA
=Aʏ\AAAAʏ\AʣAHAHA
=AHA(AzAA(AʸRAAzAəAQA=qA33AzAAA33AHAA{AzAřAHAA=qAAA33AzA=qAîAîAHA33AzA33AAAĸRAĸRA33AAAA\)A33A33AGAřAřA{AƏ\AA\)A
=A33A
AǙA{AQApA33AǅAƏ\ApAA
=A  AHAA=qAHAAAÅAÙAÅAîAAAA{A{A=qAQAAģA=qA(AĸRA=qAģAzAď\AģA(A
A(AHAǙAAǙAǮAAApAǙA\)A\)A33AA
Aď\AQA  A
=A(AHAA(AŮAAAQAHA33A
=A
=ApAřA=qApAģAÅAď\AAHAA{AA  ARA\A\A¸RA33A
=AffA=qAAA
AA
=A
=A
A(A33AAAzARAAffA\)A{AAGAA=qAffAƣAGAǮA  AAGAzAȏ\AffAAzAQAAǅApAGA33A33A\)A  A  AffAAȣA{AAApAA33AHA33A33AA{AAGA33A{AzAQA  A=qAzAAǙAA=qAƣAAřAAAGAAǙA=qAffAAAA=qAA=qA{A
A  AA\AzAAAHAQAzAAÙAŅAAƣAǙAǅAǮAffA33AAQAA\)AGAA˙A
=Aȏ\AGAAAQA
A{AQA
AGAA(AA
=AQAď\AAAQAHAGAHAŮAŅAƣAffAǮA
AȸRA33AffAAəA33A33AȸRAȏ\AAzA(A{AřAffAQA{A
AffAŅAƏ\AffAƏ\AzA
=A{AŮAAď\AGAģAAģA\)AHAGAAŅAQAHAď\AAŅAǙAAď\AA=qA¸RA  A=qAHAHAQAÙAƸRAAAAîAÅAîAřAA=qApAA=qAʏ\AHAffAAʸRAzAʸRAzAQA
=A  AGAA
=AAGAGAAʏ\AA
AʣA
ApAƏ\AQAzAȸRA33A\)AǅAȣAA
=AGAQAʣAA\)AGAAʣAAGAQAɮA
=A(AAď\AA
AAffAGA=qAzAAAƸRAffAƸRA(A{AA¸RAGA
AGAÅAA33A
=AQAARARA33AAAQAzAÅAĸRAA
A=qAƏ\AƣAA
=AAGAGAƣAAQA  ApAGAA
=AƏ\AƣA(AQA=qA(A(A  AffA{A
AAA
=ARAA\ApAHA£A  AAAzAď\AzA  AAHAHA\AA
AffA  AAA
=AffA
AzAA=qAAQAARAGA=qAQAzA=qA\A
A
=AAA
=ApA\)AAHAAzARAzA  A  AApAGApApA
A  AAAAAAAA\)AGAGAGAAA
A{A\)AA\)AA33AAQA{AA
A(ARAARAGAA33AAA(A  A=qA{A(AAzA(AApAAQA{A\)A
=AAA(AAHAAÅApApAAGAA  ApA
AHAQA  ApA
=A\AAAAAAAffAAGA{AffAzA{A\)AApAAAAAQAAHAA(AAQAAAAQAAQAAzAA\)A33AAHAA
AHA33AA¸RA33AAď\A(AzA(Aď\A
=AÙAAAAQAffAGAzAHAAAƏ\A{AHAHA
=A{A\)A=qA33AzA
A33AHAAzAƏ\AHA  AƣA{A
A
A33ApAŅAffA(A  AAQAAAQA£A=qApAA(A(A(AAGAAA
A  AAHAAHA33AHAAffA(A=qA\ARARA  AARA{A
A33AffAAHAA
A  A=qA  A\AAHA\AAHA£AA
=AHA
=AA
=A\)AÙApApAGA\)AffAHAA33ApA{A33ARA=qAHA(AzA(A
=AGARAAAGAA\)AA33AApA£A
A¸RApAÙA\)A¸RA  AQAAApApA(AAHA
A  AAHAzA\)AffA\)AQA=qA{A\)A{A(AAA  AffAAAApA{A=qAzAffA\AÅA\A£A33AApAAGAîAîA
AîA  AHApA=qA=qA33A\)AřA  Aȏ\AAAǮA33AAĸRA(A  AffAģAģA=qAA{A(AÅA¸RAA¸RAAffA¸RA{A=qA{AA\)A
ApAGAřA(A  AQA{A  AffAzAGAA\A{AAA{AAAAAzAAA{AA(AAAAApA  AAAQAQAA{A(A{A  A  A£A  AHA=qAAÅA33AÙA
=A
=AffAĸRApAĸRA
AHA
AAǮAGA
A=qA  A{AǙA(A(AzAQA(AA
AAzA=qAzAȸRAAHAGAʣA
=AHA\)A=qA\)A  AA\)AǙAAǮAAAAď\A
AA33AĸRAA{AGA
=AȣA=qAǙAAǅA=qA
A
AHAHAHAŮApAîApA
=A33A{A(ApA\)A=qAHApAA(AȸRAəAQAQAffAA{A(AʣAQAAGAA\)Aʏ\AAHAAQAƸRAHApAAQAzAƣAǅA
A=qA{AAAAHAHA
=AHAA33A
=AAzAzAȸRAAȏ\AA(A{A{A(ApAHA
=ApA33A(A(AAƣAzAƏ\AAƸRAAƏ\ApAřA
=AA33A33A
=A  A33A\)AǅAǙA33AA\)AǅAǙAAƸRAƏ\A{AGA(AA(A{AŅApAAÅAAQAHAA
AAA33A33AffAHAQAAQAGAffA\)A=qAʸRAzAA{AGA{ApAǅAffAȏ\AzAHAHA=qA(AAAȸRAA(AA\)AAřAAffA\)AƣA{ApA{AffA{A{A{A(AAAA
=AAffAA
AHAAAGA  AAAHA
AAA(A  A  AAAAzAAA=qAA
AGA  AAA33AA=qAA{AffA\A¸RA¸RAA
=AGA(A  AŅApAA\)AGAGA
A=qA{AAffA(AģAģAHA33AřAGAAA33A33AGA33AAffAQAA  A(A\)A{AHAA(AÙAAffA£AAA
=A\)A
ApA\)A33AGAzAffAA
=AAAffA\AQAAffAÙA(AAAřAŮA{A\A(AÅA  AA  AAA
AîA\)A
=A\)AA33A=qAHAA\)AAA(A
=A(AA33AA{A  AA
AffAAA
A{AffAAAAAHARAAHAA\)ApAA(A=qA(A
AApAA\)A
=ARAffAA=qAAA\)AA{A33A(AAHAAffAAAAAffAA=qA\)AHAzA\AA
=AApA
=ApAA
=AAA
A=qApA=qAAAGAAAzAAAApAGA  AGAffA
=AAA(AAA\)A
AAAQAzAApA  AffAAÅAAAAGApAAQA(AAApA33A\AA\ApAffAAGAGARAAzA(AAQAAAAffApAAffA
AA{A\)AAARAA{A\AHAAAAQAA\)AAAA
=AA33AAA
A33A=qAA
=AQA=qAA(AQARApA
AzAAA33AAffAARAAA
=A\)AAGAA33AA
AAQA=qAAAHA33AAAGAAHAApA  AA
AAA{A(A=qA=qAffA=qAA  AffA\AffAQA\A33AffAffA
=AApA\A33AA\AA\)AHAAAAAAQAAAAA{AffARA  AA\A=qAzAAAAGAGA
=AffAAAHApA
A  AQAffAAHAAAA\AAQAAAA=qA\)AQA{A
A\A{AA\)AAGA\AffAAAAHAÅA¸RAA  A33A
AQA33A
AzAHAzA
=AAAȸRAHAApAɮA
A  AAAɮAAApA
=A\)AHAHAAȣAȸRAQAȣA(A{AǅA
A
=AǅA
Aȏ\A(AHA\)AǙA\)A  A
=AA=qA\)A\)AAzA  AAHAA¸RA\)A  AAAA33A
=ApA\AARAAAGAAď\AÙA(A
=AffA\)A=qAzA
AAAA\)AGA{A(AHAģAzAĸRAAzAģAGAŮA=qA=qAƏ\AHA33ApA\)A\)AǮApA33A
=AA33AǅApA
AǅA
A\)A
A  AffA=qAAɮAɮAɅA{Aȏ\AǮAApAHAAƣAƸRAffAǮAǮAA\)AAzAǙAAQAAƸRAzA(AHAffA  A\)AAGAffAƸRAA
=AffApAARAAHAHA33ARAAGAA\)A
AHAɮAɅAɮAA  A{AƏ\ApAffA\)AHAǙAȣA  Aʏ\AAHAAAGA\)A˅A˅A˅A\)ApAAffAffAʏ\AAHAAA
=A˙AA{A{A  A(A(A{A  A  A  A{AA
=AAˮAHAHA
=AffAzA33A˙A˅AHAɅAɮAApAŮAffA
=A=qAAHAŅAApA
AAQAHA=qA33A
AģAQApAAǅAGAǮA{A33AA=qAƣA{AA
=AzAHAAffA(AƣA
AAAAA
AGAAAAǮAǙApApAA33AGA33AAƸRAAAƸRAƏ\AƸRAGAAƏ\AA
AAA
AA33ApApApA\)AAď\AĸRAŅApAǙApAHA
AAǅA\)A33A
AAGApAApAǮAǙAAAA
AAģA(A(AAAA{AAřAAAƸRA=qAAffAAAHA(A{AA{A  A{A{AȸRAzAȣAGAA33AAəAzAʏ\AA\)A  A̸RA{A  A(A
AGAffA(AˮA˙ApA
=AHA33ApApApAAzAȀ\AGA
=A(AΣAQẠA̸RA33AGA
=A
=A
=AAzA{A  A˙A=qA=qA  A=qAffA{A˙A˅A\)A\)A\)A˅A˙AˮAˮAˮAQA  AzAQAəA\)A(AffAƣAHAzA=qAŅA
A
A
=AǅA=qAȏ\AȸRA{AQAzA=qAAAA
A
=AA(A(A(AHA
AAǅAǅAffA(AǙAƏ\AǙAAA
=A
=AQAɮA
AɮAɮAA\)AGA{A=qAǙAƸRA
=AǮA=qAA\)A\)A  AHAȣA=qA(A=qAQA(Aȏ\A  A
A  AAAȸRAQAǮAǅAǙAGA\)AǅAǅA33AGA33AǮA\)A
AǮAGA
A\)ApApAǮAǮAA
A
AAffAʸRAA(AAAzAAȸRAHA=qA
=AApAɮAffA
=AAAÙApAAƏ\AzAƏ\A\)AzAffAAAǙA
A=qAQAȣA
=A{A  AA\)AAAA(AAƸRAzApA=qAȣA(AA
=AAHAffAȏ\AǮA\)ApAAǮAAA(AAĸRAffA(AŅA
=ApA\)AAAHAHAAAffAÙAîA  ApApApAA\)AŮAŅAffApA=qAzA
=AGAffA
=AA  A{AA
=AǙAƸRA{AAQAA\)A(AA(AAAAŅA\)AAGAGAAĸRAAģAHA
=AŅA  AȸRAzAƸRA
=AǙAGA\)AAɮA=qA(A=qA{A{A
Aʏ\A  AʸRAʏ\AzAʏ\AAʸRAAzAʣAʏ\AffAA
=A\)A(AAHA\)A=qAAA{Aʏ\AffAAəAʏ\A(AɅAAQAəAffA(AǙA
AAʏ\A  A=qAffAʣA33AHAQAŅAƸRAAffA{A=qAHA
AzA(AAAď\AAGApAA{AǅAřA=qAď\ApAģA
=A\)AAŅAřA
AǮAHA\)A  A=qAGAGAɅA  AffA(AɮAAȸRA
A\)ApAffAA
=AGA
=AAȏ\Aȏ\Aȏ\AɅAGA\)AHAȣA\)A
=AA
=AHAȸRA\)A33AAGAA=qAHA
A  A
=AAʸRA
AQAffAƣAƏ\AAŮA{AAǙAQA
=AHAǅA(AAA(AAA(Aď\AA{Aď\AffA
=A
=AzAQAģAď\AĸRAAÅAHAGA=qAHAGAAGA
AAAQAGA=qA¸RAGA=qAzApAQAApAǙAAǙAGA33AGA\)A\)AǮAGA  AŮAAA
=A
=AǙA
=A33AA33AGAǮA  A=qAȏ\AȸRAȸRAȸRAȸRAA
=AȣAAȏ\AAȣA(A(AA{AffA
=AǅAHA
=A\)AGAAGAəAʣAAȏ\A\)ApAGA33A33AzA
=AAGAAģAřAA\)A\)A\)AQA(AȸRA
Aʏ\AA33A
=A˙AAȸRA(Ȁ\AzApAAʸRAA
Aʏ\A\)AQAAˮAA{A˅AzA{A33AǮAAGA
A(A  AzA
=AGA\)AA33AGAHAHA33A33A33A33A33AˮA  AzA=qA=qẠA  A˙AAHAAAAAAzAʸRAQAHAffAAʏ\AAȸRAzAQA(A=qẠAAAHA
=AȣAȏ\AzA{A  AA=qA=qAApAǅAAAŮAA\)A{AǮA{AQAGAHAQAA\)AƸRA{AŅA{AA(AQAGA(A{ApAĸRA{AîAîA  A{AHA=qAƸRAGA  AȣA
=AQAGAˮA
AGAA33A
=AʸRAAA33AHAA
=AA=qAzA(AffAzAʏ\AzAʸRAʣAzAʣAAAzAffAȸRAəA
=AɅA{AAȸRA(AȸRAQA\)AGA=qApA
A=qAGAHAģAAGAɅAffAAʸRAzAffAʸRAHAHA  AȸRA  AîAƸRA\)A
A33AAŮA33Aȏ\AȣAzA
=Aʏ\AQA{AffAzA
=A
=A  AffA=qAQAA\)AA=qAffA(AHAɮAɮAəAɮAHA33A33A33Aȏ\AȸRA
=A\)AəAɮA33AApAGA\)AɮAGAɮA{A  A{AA  AAAQAAzAGAˮA˅A˅AˮA\)AAffA33AHAAAGA(A
AHAQAɅApAA33Aȏ\AzAAǮAAAA\)AAAAƏ\A
AGAQApAȏ\ApAɮA(AffA
AQA{AAA{AffAɮAˮAAffAǅAȏ\AɅA  Aʏ\AˮAzAGA  AffAΏ\AAA\)AA
=AAA
=AHA
=A
=AAHAHAAA  A
A{A  AAffA(AHAffAA\)AθRAυAA  AϮAAGAΏ\A=qA=qẠAAHẠAffA(A  AHA(AffA(A
A=qApAAɅA
=AAHAȸRAHAȣAȸRA
=AA33AȣAHA=qAȸRA{AQA(AQAǮAƣAGA=qAA=qAƏ\AƸRAAzA=qA
AA=qAǙA=qAQAƏ\A  A
=AA
A  A(AzAA
A\)AA{A  A
AAˮA˙A˙A{AffA=qAffAffA=qAffAʸRAAɅAAffAA=qAGAAȏ\A(AGAAAHA=qAQAQA{AAǅAGAGAǮA33AAAAA(ApAŮA\)AƣAƸRAAAîA
A
Aď\AGAřA=qA33AGA
=A
AAA
=A£A=qAřAQAffA¸RA  A=qAĸRAŅA
AƣAzAƸRAA33AQA33AQA33AǅA(AzAApA{A{AʸRAʣAzAʸRA
AAˮAˮAˮA˙AAʣAQA(A{AɮAəA
A
AɮAɅA\)ApAɮAɮA\)A
=AApApA\)ApAA=qAHA
A
AǅA{A(AHAQAzA{ApAAffA=qA(AřA
=AHAģAQAQA(A  ApA
=A¸RA¸RA¸RA£AQA=qAffAffA=qAQA
=AAA£AzA=qA{A=qAQAzAzAAAA33AÅAÙApAîA  A=qA=qAzAHA
=A
=AGAGAAAA=qAApAAA£A=qAQAzA\AQAAzAQAffAffAQAQAAA{AAQA  A=qA33A  AAAApA=qAA\)AAA33AAffARAAA{A=qAApAA33AGAHAA(A
AA
=AAffAzAQAQAA
=A=qAAAA=qAAGAA33A33ApAA\ApAA  AffAA\A
=A\)AAffA
AQAffAHAAzA
=A\AA
AGAAA\)A{AAAHAAffA  AA33AGA33AAHA\)AAAAA\AHAzAGA33AGAffAA=qAQAHAA{A\)AQAAAQAA{A=qAA(AARAA(A(AA33AzA  AGAQAHA\)AQARAAA  A
A\A  A=qAQA=qA  AA
=ApA(AzAGA
A=qAQA33AA  A(AffAQAQA=qAA{A33AA
A\)AApA
A
AApAzApAAAAAzAzA
A  A=qA=qAA
A\)AAAAAAARAQA\AffAAAAApAAARA\)AAGAAAA
A=qA{AzAAffA\)AAHA  AQA
AAAAAA
=A33A
=AA
AAA\A
=AGARAA33A\)ApA{A
AAAAA
AAAAAARA
=ARARAA
=AAQAAzA(AHA
=AA
=AGAAHAAARAffAA  A{AGAAffAAffAAA33A33A(AAQA\)AARAzA
AffAA
=A(AAAHA\)AQAA\A
AzA33ApAffA
=AAQAzAA\ARA\AA\AzA
=AA33A
AGAHAARAffA\)AAAzAA\)AAA33A\)AzA33A
=A\AzAQA{A  A33AAA\A  A(AGA{AAGAA(A33AA\AAAAA£AffA(A{ARApApAAAA\AA
A(AzA
=A\)A\A(AffARAAAAAAA\)A(AzA=qAAAAGAHA{AApAffA\A  A  AA
AGA
A33A
=AA33A
=AAQApAARA33A{AQAQA\A\)AAA=qAAzApAHAzAffAAffAA  A(A=qAAAAAGA
=A{A=qA
=ApApAGAÅA
A{AA
=AA=qA{AA
=AGA
=AA
=AÙAA
=AAHAAHA¸RA£A£AffAzA\A¸RA£ApAA(ApA
AA\)AGAARA{AA(A(A=qA
AAAîAAÅApA
AAzA
A\)A{AffA=qA{ApA
=AAA33A33ApA  A33A=qAAAA(A\AA
AQA£AAA(A£AAGA=qAŅAƸRAǅApAA(A\)A{A=qAQAffAGAAffAA  A\)AA{AffAzAzAffAƏ\A=qAřAřA
AŮAŅA\)A33A{A(AA  AĸRA=qAHAzAÅAQAÅA
AQAAŅAŅA
AŮA\)A\)AAAģAŅApA\)AŅApAA
=AA=qAQAGAQA  A\)A\)A
=AAApARA
=AApAA\)AAHA=qApAAAQAAA(AAA
=AģAGA
AŮAŅA33AAA
AAA{AŮA\)ApA
=AģAQA(A(A(A=qA{A  A=qA{AAAGA
=AA\)ApA\)AHA£A\A\A\AApA  AA{A\)AQAA{A33ARAA=qA\A=qA(A{AAAA\)AAGARARAQA(A{A(A(A  AQAGA\AQA\)A\A
=A\AAA\)AARA
=AA\A(AA{AQA=qAAA=qAHARA
A{AQApA
=A
=A(AARARAzA(A(A\A\ARARAAHA=qA\AzAAQA\AAHA{AHA=qAHA{AAzA(AA=qA\AA\)AHAQApAAAA
=AzAzAHAHAAAAAffAQAA\)AAAA
=ApAHA\)AzA\AA
AzAQA33A33AApAAGA\)A  AA
AAA\)AA=qA=qAAzA(A¸RA33AAA\AA
AAA\)AARAGAA=qAA
=A
=AA
=ApAA
=A\)AA
=A{AGAAQAQAA
=ARA(A  A
A=qAA\)A33AÙA  A33A
AGA{A\AAAzARA\AAQAA¸RAzA33AffA=qAApAGARAffA\A
A  A{A\A
A
=AAQAAA{AAAHA(A
=AAA
AffA{A\)AAAGAAA\AA\)AA
=A\)AAzAGA(AffAA  A
AA
A  A=qAQAffA  A(AAŮAQA=qAA33AHAAƸRAffA{A(AffA{AÙAffAAîAGA£AApAÙAîApAA33A
=A
=AA33AffAzAzA(AA{AA33A
ARA33AQAHA
=A  A  A{AAAA33A\)A(AGA
=AA\)AA
A=qA\AAAAAA33A\AzARAQA\AffAAHAAA33A\)A=qA{AAAAA\AA{AHAĸRA\AÅAîA=qAď\A33AŮApAŅAřAŮA  AAAď\AApAřAQAÙAď\AÅApA33AAAHAGAAÅAAîA
A\)AAGA33AAffAîA
=ApApApAHAA
=AĸRAGAHA=qApApApAA=qA£A\)A\)AAGAA33AzA(A=qAAA¸RAîA=qAzAffAQAAffAQAzAģAHAŮAffAffA(A  AQA
=AǅA
A
A(AQAffAffAAəA\)AȸRAəAAɅAəAAAApAzAffAzA{AQA(A(AQA
AA=qA{A{AffA=qAGAƸRA(A{A(AAŅAGAAHAAřAAģAA
=A(AHAģA33A\)AA£A\AAHAAAHA  AÅAzA\)A\)AAAAA\)A\)AA33AA{AAA{AffAAGAGA\ApAzA\)AAHAApAA
AQA  A(AAĸRAA(AĸRAAŮAƣAȸRAQAA=qAAɅAəA  AGA
=AAȸRAȏ\AffA(A  AƣAGA\)AHA{AǮAA  AǮAǙAǮAHAHA
=AA=qAƸRAAƸRAŅApAAŮA\)AAHAffAzAď\AģAď\AffAzA
=A
=A
=A33A
=AAHAď\AzAffA=qAAzAAQA  A{A  AzAA  ApAffAA¸RA=qA  A  AzA\A£AAÅAzAzAģA
=A\)AAQAƣAAAA  A=qAzAzAȏ\AA(A{AzAȏ\AA
A{AAA(AA\)AGA\)ApAǅA
AGAǮA\)ApAǮAAƸRAAAŮAǅAǅAƣAQAAzAǙAffAǅAAǅA33AřA=qAffA{AzAzAzAƸRAǅAAffAǙAƸRAǅAƏ\AAA33AffA=qAǅAA\)A\)A(A{AAQAQAzApAǙA33ApAApA{A(AGAŅAAAHAQA33AȣAʸRAAAQAQAA˙A
A  A=qA=qA=qA  AˮAGA
A33A(AͅAAA˅AAAGAɅA(AʣApA
AGAʣAʏ\A=qAzAffA(A=qAȏ\AGAA\)AəAɅApApAɅAffA  AQAA33AffA=qA{AzAȸRAHAffAȸRAȣAHAHAA=qAQApAGAGAA\AÙAffAA
=A(A=qA
=AřAŮApAŮAƏ\AQAAƸRAAƣA=qA33AǮAzAApA  AA33AA33A˙A(AA\)AGAAzAʣAzAffAʣAzAAGAAffA(AAAApAƏ\AîA=qAřAffAƸRAAA{AzAA33A\)A\)AGAǙAǮAǙAƣA  AHAǙA{AGAřAHAřA\)A(AƣAAƏ\AHApA
ApAA\)A33AǮAǮAApAA33A33A33AA
=AAAGAA(ApA{A(AzAƣAA
Aď\AA33AAřAƣAƸRA33AA33AHA33A\)AǙAǮAAA33AǅAǮA  AȣAȣA=qAǅA33AGAAA(A=qAAA33A
A
=A(A=qApAɅAA{A33A\)AʸRAQAffAɮAʏ\AɮAɅAzAzAǅAAHAAQA(AAA33AGAHA
=AA{AǅAAǅAzAzA
=A
=A
=AffApAA
AA
AffAÅA\)AffA(AîA(AffA=qA(ApAHA
=A
=A
=AA{AAƸRAŅA
AŮAAŮAŅAAffAA
=AGAǅAffAȸRAAGApA\)A  A(A33A33A
AʸRAHA33AHAAA{AGAGA33A\)AHA
=AAA\)ApA
=AȸRAɅAffAAzAʣAzAʏ\A33AffA˙AʣAApA
Ȁ\AQAAAA˅A
AA\)A{ApAɮAʏ\AAəAʏ\A\)AAHAʸRAGAAʸRA
=A33AʣAAʸRA(A33AzA=qA=qAHA
AȣAffAHA
AGAQAHAA(AzAApA
A{A̸RȀ\A
=ApA  A(A33AϮAϮA  AУA(AffA  AѮAѮAиRAAApAѮAхAQAA
=ApAHAиRA=qAQA=qA  AAϙAϙA  AAθRAΣAzA33AϙA
AϮAθRAAϙAϙAΣAͮAθRẠA˅ApAȏ\Aȏ\A
=AffAGApA(AffAApAΏ\AzAAffA33AGAGApAHAA\)AϮAAͮAQA=qAУAиRAQAA(AΣAͅAA̸RAAAA33AA(A
A(AQAA
=A\)AApAQA
=AffAӮA\)A  AծA(AԣAA{A֣AApAHA(AAzAәA33A(AAA(Aԏ\Aԏ\AffAQAQA(A{A(AffAApA
=AAffAQA33AA  A
AAAAGAAzAAQAΣAffAAHA33A͙ẠA˙A  A33A˙A(A
=A{A
=AGȀ\AͮAΏ\A̸RAGA
AGA=qApA\)AGAA=qAǅAẠA33AAA͙AffA33AAΏ\ApAHAffA(AApA\)A
=A33A͙AA
A(A=qA33A  A  AzA̸RAAGA͙AͅA͙AAQA=qA  A
=AAA33AϙA  AffA=qA(AЏ\AQAQA\)AυAQA33ApA{A33ẠA
=AAAΏ\AAͮA
AΣA33AͅAA
A=qA
A33AzAQA=qAA=qA
A(A\)AAˮAAУAУAϙAAΣAAυA33A
=AHA˙A  ẠAˮA=qA{AA̸RAAAΏ\AzAA  A{A=qAΣAθRAzAΏ\AΏ\AΏ\AϙA\)AAΣA  AθRAΣAУAAAHAΣAGApAυA33AGA\)AυAυA\)A
=AApAAAA33AA{AͮA̸RAA(AAQAHA(AȀ\ẠẠAffA  A(AQA  Ȁ\AẠA  Ȁ\AzAzAAAzA
A(A33AffA\)A˅ApAQȀ\ẠA̸RAͅA
AAA{A  A33ẠAQA{A(A\)AAϮApAA\)AA\)ApA
A
A(A(A{A{A{A{A  AϮAQA̸RAΣA\)AA=qAAθRA\)AHApA(AffA33ẠAͮApA
=AˮAA(A(AA˙AQA(AA(AAApAAʏ\A=qA(AA  AɮAAA(AʸRA=qAffA
A\)AΏ\A˅AA̸RȀ\AHAAʏ\A
A
AAQApA=qAAGAřAAA
ApAffAffAQA(AʣAA(AHAA=qẠAHAA(AΏ\A\)AAϙAQA\)A=qApAzA\)AՙA֣AffA֏\AHAQAA
=A  AAzAA
=AָRAffAAAzA=qAAAffAѮAAУA(AAA{AA(A=qA(AAЏ\A
=AHAGAGA\)A\)ApA
=AA{A33A33A(ẠA(AʣAA
AHA\)ApAʸRAA33A
=Ȁ\A\)A(A=qAGA(AffAAθRAϙA  AϮA{ApAѮAHA=qA{A\)AУA=qA  AA\)A{Ȁ\AffAzA
=A  AЏ\AAAхApAхAѮAљAffAAGAAҸRAffA=qA=qA=qA  A\)AA
AѮA
AQA
A  A=qA{AGApAхAGA=qAQAHA\)AzA=qAͮA(A{A{A{A(A{A=qAffAͮAzȀ\A{Ȁ\A(AQAQȀ\AzA33A=qA˙A(A=qA\)A(AǙAffAzAAAAHAffAɮAQAffAA\)A
AQAQAA
AAA{AGẠAzAzA=qAQA\)AͮAHA  AffAAљA=qA(AffAәA33A
=Aҏ\AңAHAңAңAQA  A
AzAffAQA=qA{AffAңA=qAA33AAAљA=qAΣAиRAAHAΣA33AHAffAQA=qA(ApA˙AAAAAʸRAʸRAHAQAA=qA=qAA=qA=qA
Aʏ\AAGAzAA
=A\)ApA=qAAřA
=AƏ\AQAHAAʏ\AAAQA  AApAGAGA33AAʣAʸRAzAʣA\)AffA33AQAGAϙAυAϮAA=qAЏ\AAAGAхAѮA{AәAәA
ApAGAҸRAffA
AAGAA{A
AAAA(AGApApA
AffAQAЏ\AffAQA=qAA{A  AAffAυAϮAυA33A=qAzAͮA
=A
AAA
A\)AA̸RAzAʏ\ApAffApAˮAAA
A33AˮA˅AʣAȏ\A
A(A\)AƏ\AͅA(AffAQAʸRA\)AˮAHẠAͅAͅAȀ\AAAA(A(A(A=qA=qA(AzAθRAθRAΣAAAΣAzAffA
AApẠAA{A(A  Ȁ\AAȀ\AzAffAQA{A{A
A
A
AʸRAQA  AǮAA{A\)A
AȣAHA=qAƏ\A{AǮA
=A
=AƣAA{AAǮAǅAQAAřA33AÅA(AģAď\AAzApA£AAA{AAGA¸RAQAÙAGA\)Aď\A
=A  A\)AřAffAƸRAAƸRA(AGAĸRAƣApAŅAƣAƏ\AĸRAŮA=qAAÙAGAA(AHA33AǙA
A(AffAȣAHAA\)ApA33AʣApAAƣAHA{AAQA33AzAzA=qAHA33AzA  AAHAAəAȸRAȣAQAɅA\)A
AHAɮApAGA33AGA(A\)AAəAɅA\)AA  AɮAHA
=AȸRAɅAHAȸRA=qAǅAŮAzA
=A=qAAA\)AAHA\)AǅA{AǮA  ApAQAA  AApA(AzAA{AA͙AffA33A{A
=AԣAAәAӮA{A  Aԏ\AHA{AAәAӮAQAHAәAA
=AGA
=AGAA\)AӮA\)A(AA\)A\)AҸRApA  A\)AGAAAʣA\)A=qA͙AGAυAHAAθRAΣAΏ\A(AzA
=ApAHAAffA(A
AffAɮAAAAȣA33AHAAəA33A33AŅApAĸRA
AAĸRA{AQȀ\A
=AQAzAHApA
=AffA(AA
AzAGA\)AͮA=qA
AͮA33AиRAљAҸRAљA=qAӮAӅAAAՅA(AָRA
=AAzAA
=AAzAzA(A
AՅAAAծA
A
A  A=qA
A33AffAQA
=A=qA=qAAzAGA̸RẠA  A
=A=qA
=A
=AffAA{AffA\)A
=AGAẠA\)AffAɮA
A{AAA33AˮA(A
=AffAȏ\AȣA\)A  AffAzAQAA˙AQA
=A(AȀ\AA(AQAQA  A̸RAzA=qAAAzA
A
Aʏ\Ȁ\AffA͙AΏ\AθRAQAΣA
=A\)AυA  AzAApAGA\)AѮA  AѮAиRAAHAA33AQA
=AQAA(A\)AGAQAAAzAиRAHAA33AQAQAΣA
=Aȏ\A˅AͮAͮAHAGAẠAHA
=AΏ\AAA33AGAAzA=qA\)Aʏ\AAʣA
=AGA  AȸRAȣA=qAA33AA
=AHAAAAAAzAGA
=AQA(A(AɮAAɮAAAʸRA33A˅A  ApA33AHApA
AẠAAHA
=AA̸RẠAȀ\AzAQȀ\A̸RAAAAA̸RA̸RȀ\AzA\)AffAzAGAGAẠAffAȸRA  AHA(AGA͙A̸RA
=AAͅApA
=AHAAHAȣAzAȀ\AəAǙA
AˮApA  AQA=qAQA(A33AʣA\)A(AȸRA\)A¸RAAAA\)AAHAȣA=qAƏ\AGAzA
=AAAzAȏ\AɅA\)A  A˅AHA˅AffAA{AzAGAAzA(AAffApA\)A
AffAҏ\AҸRA
=ApAAA  AѮAЏ\AAHAυAAϮAхA̸RA˅AA  A33AAA=qApA=qApAAzAffA33AA(AAAzA
=AΏ\AͮA
Ȁ\AA\)AA{AřAîAď\AĸRAAQApA  AƸRAHApAƣA33AǮAA33AHApA  AǅAQAAģAîA(AAGAÅAģAîAAAHAGAîAAģAģAAAÅA33AîAĸRAĸRAŮAffAAAAHA
=AHAA  Aʏ\A  AzA(AəAʏ\AɮApAffAA33ApAǮA
=AHA
AQA{AQAAffAffAȣAHAɮAǙAAǙAǅA\)AǙAĸRAA
AAA{ARAĸRA
AQA33AÙAGA\AHA\A  ApAAA=qApApAAQAGA33AzAA¸RAApAzA£A=qAzAffAAAAHA\AffA\)AHA33A(AA
ApAAĸRAzAA\Aď\AGAǅAȏ\AHAHAȏ\AɮA(AAʣA
=A{A
=AA\)Aʏ\A  A33AɮAAzAffAAAɮAɅA
AȸRAzAAGAɮAzAApAʏ\AʸRAʏ\AQAAzA  AffA
AQA{AffAGA=qAffA=qAʣAAȏ\AA(AQAģAɮAHAʏ\AA=qApAAA33A  AǅAƸRA=qAAffA
=AQA\AA
=A¸RA  A  A\A¸RA33A\)ApAzAǮAȸRA  A
=AA=qA
=AͅA
AHAẠȀ\AHAA͙A\)AAAAAAͅA=qA=qA
AΣApAA{A˙A(A
=Ȁ\AA\)A\)AzA˙A
AAGAAȀ\A\)AϙAzȀ\AzAQAAzAAď\AřAŮA
AzAřAffA  AHAA{A\)AĸRA  AĸRA\)AGAAzAApAîA(AHA{ApApAAA33AAřAŮAAǮAzAəAApAAAʸRAGA(ApAͅAA\)A{AAʏ\AͅA{AGA{AͅAΏ\AQAApA=qA(AAzAGA
=AzA
=AHApA
=AAQAиRAAѮAAхAAHA33AиRA{AQAЏ\AGAʸRA\)A
AAAȣAɮAA(A  AƸRAƸRA
=A{AA33AGAffAAĸRAffAǮAƸRAA33A  AʸRAA  AzApAȏ\AAffA33A{A\)A33AȸRAǮA  AzAĸRA33A
=AȣA=qAȣAǙAffAAA=qA(A33A
AzA\)ApA{Ȁ\AGAͅA͙AθRAGAυA  AAGA(AzAΏ\AA{AЏ\AHAͮAAGAẠA
=AϙAzA
=AA  ApA33A33AAHA{AzA
=A(A
=AAA(A\)AHAA{A
=ApAΣAAAA{Aʏ\Aʏ\AA33AQAApAAǅAAApApA33AƏ\AQA
A\)A
Aď\AAGA=qA{AřA
AGAĸRAģA\)A
AffAffAď\AĸRAHA33A\)A
A{A(AQAzAƣAAAA  A
A  AAǅAHA\)A33AQAzA(AAîAA=qAQAA
=A33A
AAAAAAA
A
A\A(AÅAffA  AA{AAA\)AAQAGApAAAAAA=qAA=qAA
AģA\)AîAď\ApA=qARA\AHAA\A¸RAHA=qA33AQAARA33AAA  A
=ARAffAGAAƸRAA
=A=qAřAA{AAzAƸRAAHAAGAA=qA
AffA\AÙAQAǙAəAAHA(A33AɅAApAȏ\AřA¸RA{AAApA=qA\)AQAHAQAGAAAGA33AffA(AGAA{AGApAGAQA{A=qA
=A=qAAAAAA
=AARARA(AA
A\)A
AAGAAAffAAAA
AQA
=A33AřAAģA(A
A(A\)AĸRA(A  AAA£ApAAHAAÙAď\A\)AAřA{A=qAzA
=AGApA  A
A=qA=qAA
AGAHAAAǅAGAǅAǙAffAHAQAHAA\)AɮAA  AAɮAAA33A
=AHA33AAA(AffAzA33AAA{A\)AɮA  AA
A{A\)AzA
AǙAApAffAɮAAHAGA(A  AAffAAǅApA
=A\)AÅAƏ\AÅAHAHA=qAAȣA˙A
=A=qA=qAA
AŮApAffAQAȣAffAzA  AQA\)AA=qA
A˅AHA33A˙A
A33A  A\)A̸RẠA\)AGAAʸRAzA=qA
=A  ApAGAɅAʏ\Ȁ\AzA
AffẠA\)AzA  AffAȏ\AʸRA33AzA(A33ApA33A{AȸRAəAffAAǙAAA  A=qAAAAƣAffA(A  AŅAGA
AǮAffAAřAĸRAzAƏ\AřAQA(AŮA{AQAAzAffAGAHAAřAAGA
AzA(A
=A(A  A
=A{AQA=qAƸRAǅAəAɅA
A=qAAA
AA=qAGAΣAAA  AQA  A
A\)A͙A\)A
=AffA  A
AA
=Aʏ\AQAA{AΏ\AΣAffA=qAAAʸRA˙A=qA
AA˅A(A(AˮA  A{ApA33A  AȣA{AA\)AAAApA
=AȣAŮA\)AAzAAA33A33A
=A33AAAffAQA
=A
=AŮAĸRAǅA{A33AAǙAAA˙A
AəAA(AQA  A=qAA=qAʏ\AɮAffAǙA  AffA(AAGA33A(AGApAAA(AɮAAzA=qApA
=AʸRAǙA33A  AAřApAƏ\AƸRAƣAHA(AƣAƣAQApAƸRA
AƸRAA
=AQAAQA
AƣAŮA
AAAAAQAAARAAGA  AzAzA(AA\)AzA
=ApA33AAffAAAAAApA{A\ApA
A=qAAQAffAA=qA
ARAAAQA\ApA(AAffA=qAffAffAzAĸRAřAA{A{AřAA\)A
AAřAAAGAzA(AřApAAffAƣA=qAA
=A
AîAGAAřAAffA
A33AGA\)AƸRAAŮAHAffA
AA\)AƣAffA
A\)A{AzA
AAA\)A(A{AffARA  AAA\AAGA¸RAA(A=qAARAA(AAHAŮApA(A£AA
=A=qAA  A\)A
ApA\)A=qA\)AAəAəA  A  AA(Aʏ\AA33ApA  A(A=qȀ\AA33A
=AAHAQAQA  ApAAAHAAəAzA
=AA˅A˙A33A
=A=qAffAəAA
AGA{A
A\)AHApA\)Aʏ\ApAAAŅAQAAĸRAAŅA\)AAîAA\)AA  AîA\AÅA\)A¸RAA
AAHA
AĸRA{A=qA
=AAAAAîA{AQAɅAʸRAAƸRAA(AA
AHAAA33A\)A(AzAͮAQAAϙA
AA  AϙA
A(A(AУAУAAAυAA
=A
=A
=A  A  A
=A=qA=qAȀ\AɮAAəA
=AəAzApAʸRApA=qAzA
=AAAA{Ȁ\A{A{Ȁ\A{A  AffAA
Aȏ\AGA
=A
=AA=qA\)AffAʣAʸRAAGAQAAGAQAffAzAQAȣA  A˅A
AAffA(AGA
=A  A
=AQAzAAAAəAAA(AA
=AHAHAAAQA33ẠAAQA=qA(ẠAA(AAAAA͙A͙AA
=A̸RA{A=qA33AHAzA33A
AQAˮAHA33A˅AGAA=qA(AAzA  AəAɅAAǅA{A=qAAAQA=qA=qAȣAAȏ\AAɅAəA\)A33A{AȣA
AʣA(A{AȣAzA33AƏ\AffAƏ\AAǙAAzA(Aď\A{AzAƣAA  A{AzAAHAɅA\)AQA(AAʣA(A  AGAəA33AzA
AAɮAɮAɮA
AzẠA̸RA˅ApAɮA=qA{A=qA=qA(AzA\)AɮA  AAAʏ\AɮAʸRAɮA  A  A=qA(AƣAHA{AQA  A(AǅAzAAȏ\A33AA=qA  A
A
=A(AApA{A\)AGAAQA=qA{AAřAGAzA=qA¸RA33AÅAřAffAĸRAəAȏ\A{AǙAffA33A{A(AA\)Aȏ\AƸRA\)AQAȸRA
AGAzAzA33AzAApA
AQA33AA(AʣAAAHAAGAApA\)AʸRA\)AffAȏ\AAAQAʏ\AAzAzAzAQA(A(A(A(A  A=qA
=A(A
=Aȏ\AzAȏ\ApAȏ\AǙAAzAAA{A{A
AǙAƣAƸRAQAřAŅAřAAď\AA(AHAAffA33A{A
=A  ApAA¸RAA  A¸RAAAGAǅA  AGA\)AɮA{AQAĸRA33AŅA\)AA{A
AHAƸRAƸRA33AǮA  AǮAǅAǙAHAəAffA
=AA\)AA{AAffAzA(A̸RA=qA(AQA=qA{AHA
AHAQA\)AAǅApAǙAȏ\AAʸRApAAʏ\ApAzA
A
=A
=AȸRA  AǅAA
AA33A=qAģAŅAģAHA=qAGA=qAƏ\AAȏ\ApAQA=qA(A(AŅAAŅA
A
AQAQA(AAƏ\AHAffAAřAHAHA(AQAzAƏ\AAAƏ\AzAAQAAǅA(AAzAəAHA
=Aʏ\A  ApA{A33AQAˮAA
A͙A  AAHA
AHA=qAA
A(Ȁ\A
=A͙A  Ȁ\A=qA{AAˮAQAHA͙A  A33A=qẠAAA˙AffA{A(A˅AA˅A  Ȁ\A˙AHA  A{A  AGAzAzA
=A\)A(AAA
=ApA˅A  AAˮAA
AHAɮAəAəA˅A˅AʣAA
=A
=A(AAAffA(A
AAzA{A  A
AHA  A
A\)A̸RA\)AAͮA
=A\)AAʸRAˮAAAA  A(A(A{AљA  A=qApA
A=qAхAиRA(A͙A͙AHAGAΣA  AzAͅAGA  Aʏ\A  A
AffAA˙AHA\)AA
A{AA˙AHA=qApA\)AGAA\)AffAǮAAA(AffA{A33AͅA͙ẠA(A̸RAHA\)Ȁ\AApAɅA˅AffAʸRAQApA{AȣA  AǅAHA
AHAƣAAɮAA{A33A
AAffApAθRA\)AQA
=AљAҏ\AAӮAԏ\AffAzAծAzApAA33AGAAzAAffAA=qAAffA\)AA{A{Aԏ\Aҏ\AQA33AљAAхAffA{A
=AңA33AхA=qAAAҏ\AAA
AͮA
AQȀ\AAzAϮAQAQAϙA\)A\)A\)AͅAzAApAʣA\)AƸRA
A
=AȀ\AHAHAffA(A{AA=qAAΏ\AϮA{AΏ\A\)AHA=qA=qApAϙAA
=AGA
AϮAЏ\AAHA
=AУA33A=qAQAЏ\AHApAAхAҸRAzAѮA\)A
=AA\)AυA{AGAApA
AϮA{AffAHA=qAΣA33A=qA=qAffAΏ\AϙApAQA33AGAϮAϙAAϮA
AυA\)A  AA
=AA=qAffAQApA33A
=AAHAǮApA=qA
A(AA
ApA\)AA{A=qA
AAA
=AəAƣA(Aȏ\ApAʣAQAAʏ\A33A=qAAΣApAA33AHAAϮApAA33ApAA{A=qA  AЏ\AHAУAHA
=A=qA33AθRAffAAУAA
ApA\)AzAͮAA33AGAˮA=qA(A
AAGA\)A33AA
=A(A=qA=qAAHAGAGA
=A
=AHAHAʸRAʣAʸRAʸRAffA=qAQA=qApAəAA  AȸRA33AffA{AA=qAǅAƏ\AǙApAǅAAǅA
A\)AǅA33AǙA\)AAA=qAffAȏ\AȸRAHAAffAA33A\)A\)A(A=qAffAzAʸRAGA
=A˙AHAA(AQAffA=qA{AA  AQA̸RAffȀ\A̸RAAAA33A33AGA\)AGA
=AA33AGA
=AHA˅A  AˮA
AɅAA33A33AA  A{A  A(AffAzAzAffAʸRAʣAffAQAQAzAQAffAffAzAAʏ\Aʏ\AAA(AHAǙAQA=qAA33A{A{AA  Aď\AŅAA=qAHA(A(AǅAQAȣAAQAApAzAGAA  A  AˮAAzAθRAzA33A33ApA
=AAHA
=AAAθRAͅA\)ApA\)ApA͙A͙AAAAffAffApA̸RAA̸RA{A
A=qAΣAffA  AA
AͮAAQAA̸RA{A
AAAʸRAʏ\AzA
=A\)ApAʸRApA
=AQA=qAAGAffAAǮAHAǮAAȸRAAɮAzApAffAAəAzA  A̸RAAGẠAAA˅A33AQAffA  A  A=qA
=A
AA\)A{AGAϙAAA
A{AQAЏ\AиRAzAQA=qAQAQAQAQAzAЏ\AzAffA=qA33A
AA=qA=qAzAAУAЏ\A{AϮApAυAAA
=AApApAͮA{A  AAAA
ApA\)A
=AυApA\)A33AffAΏ\A{ẠAHAAGAQA
=Aȏ\AɮAGA  A=qAAɮApAQAA{AȸRA
=AAA33A  A\)AAffA͙AͅAθRAQAθRAAQA33AGAGAAAAAQA͙A  A  AA(AffAffAθRA  AиRApA(Aҏ\AQAA
=AҸRAffAAѮAA(A  AQA{AAљAљAAѮAѮAAљAѮAA\)AA  A  A
A=qA˙AAA
=AffAA  A\)Aʏ\AzA=qAʸRAQAzAˮA=qA
A˅A
=AAA
A33AA
=AAAA33ApA  A=qAGA(AͅAApAzAAQAAɮAA{AAQAAA˅AGAQAffAʣA˙AffAHAAͅA=qAffA\)AυAA{A(AApApA  Aҏ\AQA=qA{A  A  AҸRAA=qA  A  AAQAzA  ApA{AGAљA33A
=AApAѮApAљAљA
AљAAљAљAңAҏ\AzAҸRAHA=qAҸRAffAGAAHAffA=qA
=AљAA{A  AQAffA=qA  AA  AѮA\)AЏ\A
A(AHAAAAA=qAGAAУAffAffAAA{AЏ\A33A33AљAffAA\)AӮA  A=qAffAԸRAHAAAAA
=A
=AAԣAAԏ\AԣAHAԣAԸRAAԸRAԏ\A\)Aҏ\AA
AхA{AӮA\)AϮAυAGAA33AͮAӅAQAffAԣA\)AQA  AA  AA
=A  AffA
AңA=qAAңAѮA\)AљA
A  A
=A=qAAˮA
=AA  ApAAzApAffAϮA
AȀ\AAA(A=qAHAGA
Aʏ\AHA\)AAAɮAzAApA  AGAzAAϮAиRAHAхAA
AѮA
AљAљAѮA33AHAzAQAAGAAϙApA  AϮAA{A
=A(A
=AЏ\A=qAA(AffAA=qAA{A  A
AљA=qApAхAQAҸRAңAQAHAAHAAzA
A\)A
=AA  A=qA̸RAApAGAzA33A  AθRAffAЏ\A=qAAAffAAHAAAHAA
=AQAAGA  AϙAA=qAffAA33A̸RAA͙A
AϙAGAΏ\A
A
=AAQAAңA  A=qA
A
AѮA
AӅAӮA{AzAԸRAAzA\)AQAffA=qA  AԣAԣAffAQA=qA(AAApAAHA=qAЏ\A\)A=qAA
A33AzApAAzAУA=qAθRAApA=qAHAffA(A
=AУAиRA\)A
=AGAffAϙAGA(AAΏ\AzA͙A͙AϮA\)ApAѮA
=AңAzAA{AA{AQAzA
=AAQA̸RA33AffAAGAЏ\A{AGA\)AAӅAHA\)AAzAHAծA=qAָRAHAAQA(AAԣAԸRAA=qA  AѮAѮAиRA33AAϮAυA{AAApAA\)A
=Aҏ\A  AљA
A
AAљAApAAHA
=AУA
A
AA(A
A=qAA\)AϮA
AAA  AAAA33Ȁ\AGApAA˙AQAͮAHAͅAGAʏ\A  ApA˙AGAΣApA
=A
=AGA{AǙAƸRAA=qAHAAǅA(AȣAʏ\AQAͅA=qAAAЏ\AGAѮA{AzA33AGAAAӅA{AAәAҏ\AzAAQA{AA(A  AffA(A{A(AffA=qAffAffAzAffAQAffAffAQA\)AQApA
AхAzA{A33AAAQAAA\)A(AЏ\AQA(AAϙAffA
A˅A
AA
A=qAHAAA͙AͅAQA\)ApAAQA=qAΏ\AAHAAHApA(A˅AȣAɮAzAGAGApA  Ȁ\A=qA=qAAA33AAHAәApAQA
=AՅAA֏\AHAHAHA֏\A
=AAՙA
=A
=AA
A=qA֏\AQA=qA33A֏\A֣AzA33A\)AAApAЏ\A(AУAApA
A\)AA
=A  A(A=qAzAQAAffA33A  AGAffAՅA
=A  AӮAHAzA(AЏ\A{A
=AAHAA=qAA=qAҸRA\)AͅAͮA  AA(AΏ\AθRA  A{AHAHAΣA˅AA̸RAHA
AͮAA{ApAGAffA=qAGAңApAҸRAAGA\)AApAAљA{AAәAQAծA  A{AՙAAծA
AAA{AQAzAԏ\A  AAHA(AAzA{AՙAA(AQAzA=qAAхAzAA  AHAAQA(A{A{Aҏ\AQAҏ\AHAAҸRA{ApAAA33AϙA=qA
A=qAffAAѮAәAӅAffAљAңA  A=qAѮA
=AЏ\AиRAϙAΣA
=AQA  AAЏ\A  A
=AQAиRAA(A
AУAffAәAQAԏ\AԣAAAGAGAffAffA  A=qAffAffA{AGA33AAӅApA
AAӮAӅAQA{A{A
AAәAӅApA
=AAңAffAҏ\AzAҸRAffAAҸRA
A
A\)AA\)Aҏ\AAҸRA(AffA
AA
A(AϙAGAAA{AAѮAHAЏ\AQAͅA33AѮAQAϮA  AЏ\AAϮAυAA33A33AAffAΏ\AQAA{A
=AGA=qA\)A(A33AAffAQAffAQA˙A  A
AzA
=AAAHAAϙAAzAA
=AGA  AљAԏ\A{A
=AAҸRAzApAAAA33AθRA=qAAAA33A{AΏ\A33A
=AиRA(AΣA(A
=AͮA\)AϮAQAAθRA(AϙAzAGẠAAA33AffAffAzA\)AQA33A˙A33A
=A=qA
A33A  AAffAffAAQAAǅApAApA=qA  A  AA\)A(AGAGAΏ\ApAϮAGAυAAϮA
A
A{A{AӅA  AQAGA(A͙AͮA͙A͙A͙A͙AΏ\A=qAΣAΣAΏ\AAHAAAQAzAΣAHAzAQAzAA˙A  AzAA
=AQA{A  ApA33AθRAA(AυAQA=qAϙAzAzAGẠAˮAHAAffAAHAʸRA{AHA˅AGA
=ẠA
=AͅAͅAA{AA̸RAffAǙAGAffAȏ\AˮẠA
AA33A=qAθRAA33AͅAffA33A  AͮAzA  AУAAЏ\A33A\)AzAAиRAυAAϙA=qAAϮA{A
AAA\)AυAA
A  AzAЏ\AυAљAυAυAAGA  AHAzAzAzA̸RAHAHAffA\)AϙAHA\)AAAA33A
=AΣA=qAΏ\AHA33A\)AυAGA
=A
=A33ApAHAffAAɮAˮApAAA͙A\)AA
AǮA  A{Aʏ\A
=AǮAzAǙA
=A(AA
AθRAApAGA̸RAͅẠAͅA33ApAAͅAA=qAAA(ApAυAQAA33AA
=AAA{Aԏ\AAԸRAAAA33ApAՅA=qAծApA33AՙAAAAңAңA  AffAA
=A  A\)AAΣA  ApAͅAθRAAffA(AυAzAQA  AΣAυA{AͮA  A(AAHAffAAAHAGAzA{AʣA(AGAQAиRAA(AApAAApA33ApAApAѮAA
=A(A=qA
=A̸RAиRApAиRApA=qA  AAzAԏ\ApA
=AGA(AzAApA
A=qA֏\AA
=A
=AHA֣A֣A֏\A֏\A֏\AA֏\AzAffA(A
A  AA(A{A  A֏\A(AծAՙAծAAGAQA=qAffAA\)AQAQA=qAAAԏ\AAHAApAԸRAA=qA=qA  A=qAˮA\)AAAHA33AAAθRA\)A\)A\)AzAAυAApAϙA(AУAиRAAУAAAGAzAHAAzA{AAAӮAԏ\AAzAAA
=ApAٙAA(AffA=qAffAAHAffA
AA
A
AٮAQAA\)AHAAzA33A=qAHAzA  AAأA{A׮AAGAGA֣A
=AQAAzA  A=qA{A(AQAGAԣA
AAA
=A33A  A֣AAҸRA{AљAҏ\AGAңAҸRA(AиRAѮAAApAAУAzAљAҸRAApAGApA33AυA=qAAAGA=qAQAA  AAAGAHAAzA
=AAAѮApA(AAzAѮAљA(AҸRAӅAңAңAҸRAAљA33AңAzA=qA(A(A(A=qAиRAA\)AѮA{A
=AA
=AхA33AAҏ\AAA{AQAffAffAљAffAAffAAңAA33AңAA{AљAAHApAυAzAAAHAȣA
ApẠA˅AAA͙A33AzAẠA=qApA33AQAffAA{AA(AffA(AQAApA\)A{ApA33A33AϮA{AAҸRAGA
=AԣAApAңAҸRA(AA
A=qA33AӮApAQA\)AЏ\AAͅAΣA  AffAApAA
AӮAAӅA
=Aҏ\A(ApA\)AиRAHAӮAӅAӅAҏ\AљAAϙAAAA=qAGAAѮA33A
=AAHAApA  AAϙAffAGAA\)A
=AυAzA͙AθRAzAffA
AzAʸRApA  ApẠA
A(AGA̸RAͮAzA͙AA  A\)AAA\)AΣA
AzAAA33AAGA
AA33AхApA33AQAυAAzAzAAAAϙAAHAѮA{A(AffAAҏ\AQAҸRAHAA\)AхA  AHAΣAGAffA33A
=AAGAzAЏ\A
=A(AAQA͙A
AGA33A
AͮA\)AGA{A  A\)AA̸RA
AA  ApA=qA=qA{A33AHAəAAʣAA
AΣAffAQA˙AHAHA33A33AʸRApAA̸RA=qA͙AQA˙A{A\)AAAHA33A{A33A˙AAAGA˅AA33A33A=qAzAA̸RA̸RA̸RAAHAͅAͮApA{A{A=qAzAAϙAA  AAQAGA  AA
=A33A33AA
=AϮAA
=A=qAиRA\)AͮAGAA  AA  A\)A(A=qAzA˅AˮA{Ȁ\AʸRAəA=qAffAAGA
=AAHA
A{AQAzȀ\ApA(AGApApA
AGAA33AQA{A  AzAθRAGA\)A(AffA  A\)AQA\)AϮAQAиRAѮAAңA
=ApAQAԸRAQA=qA
=AHApAHAӅA
=AQAңAхAиRAAffAffAЏ\AHA\)AffAҸRA\)A
=AAA33AAA(AծAApApAGA  AQA\)AծAGAԸRAffAQAәA33AffAHAAҏ\A\)A\)ApA33AΏ\AA
=AAAHAΏ\A33AΣAffAϙAA
=A33A  A\)AυA(AΏ\AθRAQAzA{AA=qA{A=qA33AͅAA33AAA33AљAGA
A(AQAHA
=A33AӮA{AAA
=A\)A
AAA(AHAHAA
AՅA33AAԣAԣA(AAA{AApAиRA  AGAHAAAЏ\AAхA\)A=qA\)A\)A33AHA
=AzAAAAHAՙAծAӮA{AA33AAхAAЏ\AQAQAϙAQA33AQAAθRA{AffAA\)AʣAЏ\A
A\)AQA
A
=AAУAAͮA̸RAAGAApA  AQAQAQAҸRAңAA  AAԏ\AԣAApA
A
AQAzA֣A33A  A{AׅAָRA=qAffA=qA{A=qA=qA\)A{ApA
AGA
AиRAУAθRAиRA
=AϮAA(A\)A33AHAAffAA{AHȀ\AA=qAffAϮAHAυAAҏ\A{AApA33AHAQAԸRAЏ\A
=A  AAffA
A
ApA
=A(A33ApA̸RAͅAzAzẠA  AͮA
=AA{AffA33AHAʸRA=qAQAQAffA(AffA
AQAzAЏ\AzAA\)AAυA  A\)AffAΏ\AApA=qA(A(A  A͙AAAHA  A  AͅA
=A
A33ApA  AA
=A(AAУAzAAAA\)A33AQA=qAHAzA
AəAȸRA
A\)A  Aȏ\AffAʏ\AɮA\)Aȏ\AzA{ApAHA{AAffAʸRAɮApA=qA͙AAA(A=qAAffAAΣA33AAУAѮAAGAApAffAffA{AAAAĸRAA{AƏ\Aȏ\AA  A33AəApAȣA
=AzA\)ApA
=AϮA  AHA{AAʏ\AzA͙A\)AzA=qAʣAA33AAHA=qA(A{A=qA\)A{AGA33AHAA=qA(AzA33AAAAΏ\AAAffA̸RA˅A=qA
AffA\)AGA=qAQAApApAAAAA(AͮAΏ\A
=A  AЏ\AffAϙAHApAA=qA(AљA\)AHA  AA=qAѮApA  AAAAAAHA{AffȀ\AͅAAAAzAA33A33AGApAљAAиRAQA  AQA
=AA33AңA
AңA=qAңA
AЏ\A(AхA=qApAAzAәA=qAУAAHA\)A33ApAУA
AffA(AAAAQAϮAͮAΏ\AθRApA33AQAzAΣA(AHAQAGAAQA
=AљAҏ\AҸRAAGA  A33AϮAA=qA=qAzA{AϙA=qAңA(A  AQAAHAffAљAхA\)AAУAAAљApApAAApA{Aҏ\A(AAAңAAGA{A  A  AӮA
=A33AAA\)AA33AffA
AffAzAAԣAԏ\AAAAA
=AңAAѮAЏ\AЏ\AAθRAA{AΏ\A=qAQAϙA  A
A  A
ApApA  AAΏ\AQAQAθRA
A{AΏ\A=qA
AQAA  AAυA\)AGA
A  AAУA
=ApAхA
=AͅA(A(A
A{AzAϮAΏ\AϙAffAHAљAυAϮAzAzAQA
A{A  A(A=qAzAЏ\AffAУAЏ\AЏ\AffAЏ\A  AAAУA
=AA
=AљAѮAхAљAѮA=qAәA\)AzAHAУA(AΏ\A
A33AυApA{AиRAхAHAA
=AA
=AHAͮA
AzAHAQApAљAAzAA\)A\)AAУAffAAЏ\ApAңAAAәA
A
AAңAAΏ\AAңA\)AHA(AGAȏ\A\)A33A
=A
=AAͮAA  A\)AAzA
=AHAA=qAAHA  A
AУAHAHAApA
=A
=AHAӅAҸRA\)ApA{AHA{A  AңAљApAЏ\AѮAԏ\AAAՅApAӮAA(AAAQAхAAA33AȀ\A  A33AAʏ\AʣAQAAzAͅA
AGA
AffA͙AGA(AʣA  AzA˅A(A=qȀ\A
A{AΏ\A\)AυA  AΏ\A\)AAʏ\Aȏ\A  AA(AȸRAzAƣA  AAAɅAAAffAəA(A˙AˮA
=AffAɮAGAQAǅAȣApA  AGAʸRA
AHA˅AʣAHAʏ\A(AʸRAAʸRA
AɅAʸRAȣAAǮA  A
=A(AHAͮAGA\)AAA
AAQAQAʸRAʏ\Aʏ\A
=A˅AGAʣAʸRAʸRApA33AAA  AAHA33Aʏ\A
=A=qApAȸRA
=AřAĸRAÅA{A33AQAʏ\A33A
A\)ApA\)AɮA
A33AA\)AHAffAHAAA=qA33A
AϮA˅A  AA
=A͙AͅA
AffApAϙAffA{A(AΏ\AzAffA
A͙AA  A  A{AQAΣAAHA33A
=AAGAA
=AθRAzA=qA
=AAA=qAͅAΏ\AAϮA{AffAљA
A
A  A
AAA{A  A=qA{AffAHAAGA  AυAHA
=AAA=qAΏ\A͙A
=AApAϮAHAA{A
=AAApApAAẠAQA(AA33AхAA\)AAAffApAA=qAȀ\AAͅAͮA  A
A{A
=AЏ\AQAAA\)AGAAHAԏ\AA33AAQAHAיAA=qA
A؏\AظRAٙAA{AיAHA(A
A֏\AָRA
AAHAҸRA(A=qAzAQAAA33AQA֏\A
ApA=qA֏\AָRAQA  AA=qA\)AApA
AA  A{Aԏ\AՅAՅAAGAHA
=A
=ApAՙA{AAHA
AљAHAzAA
A
=AӮAGAՅA\)ApAԣA=qAљA33AGA
=A  AGAAffApAHAAAzA33AAԣAffAffAzAAGA33A\)A
A{A(A=qA=qAԏ\Aԏ\AzAԏ\AQA=qAԏ\AAAԸRAffAA\)AHA=qA{AffAHA
A
A=qAA{A
AAA  AљA33AGA{AQAAՙAAԸRAA\)A{AӮAHA
=A
=AGA
AQAԸRAzAԣAәAҏ\Aҏ\AәAA33A
AУA
=AΏ\A\)AzA{AffAУAҏ\A33AA(AԸRA  Aҏ\AңAңAHAzAAGAzA\)AՙAA
=AffA
=AأA{AQA(AڸRA33AAQA(A(A(AAA(AQA=qAܣA܏\A܏\A{AA
=AٙAAA
A؏\A  AAHAAzAٙAHAAffA  A=qAA=qA\)A(A(AffA{A(AAQAAGAAAffAffA  AׅAffA  AAAծA(AծApA  A\)AGAˮApA  A׮AHA
=A\)AٮA
A(AԸRAAHA(AGA֏\A\)AGAzAAApA׮AGAٙAAQAمAAAGAA\)AۅA(A  ApAۅA
=AڣAGA{AQAQAzAzAzAQAffAffA(A
A  AQA\)A(A(AۙAA
A(AۙA33A{AAA؏\AծA{A  A׮AAzAzAA{AظRAA{AAffA؏\AٮA
A
AHA(A֣A  AظRAA
=A33A\)AAGA{AծAԏ\A  AAӮA
=AAA{A(AffAЏ\A
=AиRAиRAApA33AA\)A\)AffAzAAA(A֏\AAՙA(A֏\A\)A33AGAAׅAGAHAHA֣A  AָRAAӅApAӮA\)A{AQAffAAיAׅA\)AAأA33A(AУA{ApA=qA\)A
=AHAAҏ\AиRAΏ\AQA\)AffAA\)AAzAʸRA\)AQA=qA˙AQAAHAǮAƸRAʸRA{A(Aď\AAŅAHAǅA(A\)A33A
=A£AHAGA=qA
=A{AHA͙ApAǅA=qA33AȀ\AˮAApAʣAA
=AGA
A33AǅA(AzAAA{AApAzAGA33A\)AƣAHAA͙A
ApA33AHApA{Aʏ\A=qAAəApA=qA
=AHA
=AGAGAAffA\A33A{A{AApAGAA\)ApAA=qAA(AAzAGARAA\AHAffA=qA33AA33ApA\)A(A33ApAAAA\AffAApAHAffA
=AzA
AîAA£AA£A
A33AA(A33AƏ\AǅA̸RA33A
=AAffAzAA(A33A
A=qA(ApAAȸRA=qAzAGAAzAď\A
AQA\)A˙ApAΏ\AA
=AQA33AAzAQA=qA(AAA
=A=qAAA£AA
=AAzA=qAAAģAřAAA
=AHA£AzAAA33AAAAAA£A{A=qAApA(AA(AAA\AffAGAHAAAffA
A=qA
=AA{A\)AGAApA{AAHA\)Aď\AQA=qA
AAGA
A33A=qAQAffAAffAzAʣA=qAAA
=AAQAApAƸRAAAA  A=qAzAQA
=AǙA
A
A=qA
A33A\)AA(Aȏ\A(AAGA  A  AzAƣAAŅA=qA\)AffA{A{AA{AAɅAŮA  A  AGAGAQA33AģAAǙA33AHA
A
=AA  AřA\)A=qApA¸RAÙAQA
=AƏ\AGAAHA
=A{AzAffAGA\)A33AHAA
=AApApA{AAÙA\)AA{A(AA
=A(Aď\A=qAA{AHAɅAȣA  AffAA  A{AǮAffA=qAŮAAA{AA£AģA(AGA  ApAŮAffAAAAřAHAʣAA=qAɮAffA=qAəA=qA33AffAAřAGAAAGA
=AA(AGAA(AffA
=AAA  AAzA\)AəA
AA33AƣAffA
AɮA
=AzAffA(AϮAϮA(AHA{A
=A{A
AυA=qAљAҏ\AAAԏ\AAA=qAHAAυAzA
=AA33AGAAљAAхAA33AУA
=AAиRA
=AGAGA33A  Aʏ\AˮAGA  A  A  A
AA33A
AυAHAA  AApApA{AQA=qAAAHA(A̸RAA{A
AGAɅAɮA=qAGA  A
A
A{A33AˮAͅẠAQA
A{A=qA{AQAУAGA  AA(AGAAQAAA33ApAA(AQA
=AffAzAAЏ\AУAУApAQA33AHAԣAϙApA(AAHA
A
=AzAծAAԏ\AAәA33AңAҏ\AA33A=qAA(AApA\)AәApAӮA(A
A
AӅAҏ\AQApAЏ\AHA{AzA=qA
=AHAzAA{A33Ȁ\A
AAͮAƸRAAǮA
=A
A(ẠAffA\)A˙AA\)AHAʣA
=A{AǙAAGA˙A(ApAͅA˙AGAΏ\AQAAQAθRAAAAQAHAӮAffAA=qA=qAQA֏\AffA  AA\)A(AЏ\ApAAٙAHAۅAڸRAffA\)AڸRA=qA
AffA{AҸRAͅAAծAӮAAzA\)AGAffAAA(AGA(A{AљA\)A(A33A33A{AأAApApAHAzA=qAA
=AӅAffAיAԸRA(AҸRAAӅAAQA  AQAAҏ\AzA(AθRA=qAΣAffA{A33AΣA(A  A(AAQAңA=qA  AAzAAӮAԏ\AGAծA
AzA֣A33AAA  AHApAمA
A  A  A=qA  A=qAA
=A
=A\)A{AzAAAڏ\AمAzAڸRA
AٙAzA=qA  A\)A׮ApAA
=AA33A{AHAAיAA=qAAңA  Aԏ\AA33A  AAffAԏ\AHAљA  A33AHA(AGAAGA  AΣAAA{AzAffAхA{AffAҸRAzAAA\)A=qAHAQAzA{A=qAAљA\)AәAHAA
A
A  A=qA
=A(A  ApApAծAffAQAGAzA{AGA33AٙAAA(AAظRAQAQAٮAمA  ApA  A  A{A  A
=AAׅAAAׅA\)AA=qAԏ\Aԏ\AHApAA(A
A
A=qAA\)A
=AHA  ApAA33A33A{AQAffA  A  AAAɅApAȸRA(AAˮAAθRAAͅAQAffA{A
AAӅAAA{AHApAיA=qA֣AHA֏\A
AzAzA{AA\)AffA(AAA
AQAA33A  AAHA؏\AAٮAڏ\AA\)A\)A=qAڸRAAGAGAzAGAffA
=AA
=AAHAQAָRAAׅA֣A=qAA
=AϙA=qAԸRAzAffA֏\AQAzAzAҸRAHAAAAHAzAәAиRA=qAGA
A=qAGAәA\)AϮAυAQAУA33AиRAϮApAәA  AHAҸRAffA
=AθRA33A֣AA  AAffAՙAA(AA֣A׮A{AA{AAzA֏\AA׮AA=qAHAA(AمAffA(A  AGA33A܏\A݅A
=AHA33AݙAݮA\)A܏\ApAڸRAڏ\A(AApAAQAffAܸRAA\)AffAffA(A
=AAQAAיA֣A33AظRA
=A(A֏\A  AԣAApAGAHAәAיA=qA  AQAzAA=qAApAA
=ApApAٙAAظRA{AظRAAA(A֏\A  AA(A  AzA\)A؏\A  A\)A؏\AHA33AGA֣A֏\AA\)ApApAיAAA
A{AأA
=AAHAأAظRAAظRAأA؏\AffAApAA
=AAQA
AA
=AӮA\)AzA
A{A33AA33AAHA=qAϮAΏ\A(ApAHAθRA̸RA̸RA
=AA  AHA(A33AAиRAHAGAzA\)AУAGA33AAθRAGA=qAУA(AzAA  AΣAzA
=AAϮA\)A  AHA\)A
=A{A  A\)AAGAA=qA{AљA=qA{AA(AzAӅAAzAQAQAՙA֣A{AAGA=qAA{AAzAԸRAHAA
=AA
=AԸRAԣA{A(AGAԏ\A=qA(AA\)A
=AҸRA
=AѮAffA̸RA=qA
A=qA{A  AAAAAAQȀ\A
AAУAQA  AAϙAAA{A  AAQA  AAˮAʣA33AˮA(AAzAAGAAQA͙A
=A(A33AΏ\A
=A
AθRA
AΏ\AυAA33AffAffAHAApA(A33A
=AGAQAAHAA(A\)A(A֣AՙA
AՅA
AQA֏\A33AׅAA
=AAҏ\A(AAGAHA
=AzA
=AffA33A{AծApAAA
AQA=qAθRAzApA֣AAGAиRAQA(A=qA  AAAAΏ\ApA=qẠA̸RAzA̸RA(ẠApAЏ\A
A33AAҸRA(AͅAA
=AͅAυA\)ApA{AAA  A{AљApAңAӅAApAхAGAљAffA{A{AAAAAЏ\AHA\)A=qAA33AA=qAӮAӮAԸRAAՙA
A
AQAHAA\)A  A{A(AAQAAApAυA33A=qAGAׅA33AָRA
=AzA(A\)AAA  A{AQAzA=qAׅAAәA\)A
A
=A
AәAAҏ\AңA33A  A=qAυAͅAͅA=qAQAЏ\AHA  A  A\)A
=AAϮAAA33Aʏ\AQAAQApAϮA
=AffAAHAffAңAѮA  AӅAffAA  AәAҸRAңAӅA{A
A33A\)AGAәAٙAAQA  AۅAٙAۙAܸRAzAݮApA݅A33AٮApAA܏\AAQAAAA
=AGApAGA\)A=qAA\)AffA
=A=qAԣA  AQApAיAQAGAzAffAffAGAՅAׅAԸRA\)Aҏ\AӅA=qAQA\)A\)AңAffA  AzA=qA33AAffAAQAAAңApA
=AՅAGA33AzA
AAиRAծApAׅAAzA{A
=AAA=qAָRAA33AQA=qAGAA(A\)AQA=qAAAQAzA֣AAffA؏\AHA33A\)AٙA
AQAffAQAA
=AڣA{AffAAzAQAٮAApA
=A
=AظRAzA؏\AAׅA  AHAzA
=A33AҸRAHAffAHAzA
AAԸRAAHAԏ\AAӅAA=qA=qAԏ\AAAffAӮAAҏ\Aҏ\AAиRA  A=qAѮAΏ\AAиRA
=A\)AGAΏ\AA\)AA=qA
A׮A{AQAffAA؏\AٙAٙAffA=qA  AՙA\)AQA(AApA\)AGAzAzAAGAAGAQAAHA݅AݮA=qAAAGAGAܸRAffA\)AۙA{A{AHA׮AGA{AA(AՙAAzAHA
=AәAA{AzA=qAиRA{AGAHAffApApAAzA=qAQAңAAУAυA  AAAхA=qA
=AGAAхApA=qA  AffAAͮAЏ\AAϮA
=A
AңAA{AхA33A\)A(AffA  AA
AѮA\)A(AzAҸRAӮA{A(AӮAAAzAԸRA\)A
A֏\A֣AA
=AAָRAAzA33AGA\)AָRAָRA{A  AՅApAՅAApA
AAԣAӅAҏ\A33AHA  AGAәAA
=A\)A\)A33A
A
=AQA(AQA=qAffAffApA  AGAHAԸRA33A{AAffAУAңA  A
=A  AՅA
A
A
A{AңAzAхAQA\)AУApAA  AzAԏ\A=qAAծAHAHAظRA  A
AQAAA
=ApA(AffAHAA\)A(A\)A\)AA  AظRA  A{A
A
=AzAA
=A\)AAffAA  AAٮAمAHA{A
=AAGAA(AAApApAAHA33A
ApAأA
=AzA{A\)A33AԣAӮA
A=qAԏ\AA\)A
=AAffAAffAffA=qApAHAAQA
AՙAՅAՅAzA֏\AffAAיAApApAAzA(AӮAHAӮAљAҸRA  ApApA{A{A
=A(AљAAхAљAңA=qAәAA
=AAAHAQA33AҸRAAGA\)AՅAQAָRAHApAיAGAGAGAHApAAA
AApA=qAAԣAңA{AHAӮAzAA\)AأAA\)A\)A(A
=AzA  AAffAӮAҸRAAAzAңA(AA
AA֏\AңAծAA  AՅAAծApAӅA
=AQAzA{A{Aԏ\AA=qA(A33AzAӅApA(AAA
AѮA{A
=AAAиRAхAHAAApA  AңAHA\)A  AffAQAԏ\AHA
=A
=A
=A
=ApA\)A33AGAՅAՅAָRA
ApAծAAAAA
=AQAәAA  A33AAffA
=AAՅA33AAHAՅAA
=A\)ApA=qAffA
ApAGA
AA(A{AzAAӅAѮA{A33AA33A(AAGAAծAHApAffAGAЏ\AѮAA=qAAHApA\)AGA
AՙA=qA
=A׮A(A{AأAzAAGAHAA  AGAծAHAӅA{AӅAffAәAAәAffA  AzAAAԏ\A  AAA
=AљAAQA
=A{A{AHA  AGAA(A=qAΣA=qA
=A=qAzẠAAA  AQApA͙AffAzAApAAϙA
=AиRAAGApApA\)AA{AУAЏ\ApAљAffAхApAиRA=qẠA{AffAθRAQAϮAAA̸RAͅA
AAHAGA(AHA͙AθRA33AϮAУAAA33Aҏ\AӮAQAԏ\Aԏ\AAGAAAGAA֏\AGA{AzA{AظRAٮAQAzAzA{AAAAHAظRAA  Aڏ\A\)A
=AHA(AQA=qA\)A{ApA֏\A  A
A
=A(AA  A33AQA
=ApAظRAAA
=AHAHA(A33A  AGAzA{A=qAffAׅA\)AڣAAApAAzAA
=AA
AA{AA
=A{AA33AQAQAQAAffA
=AGApA  AzAHApAAQA
AA{AffAAAGApAGApAA{AzA֣A֣AָRA33A33ApAHAQAӅA
AGA(AңA{A
=A(A\)AΣAθRA\)AffAA33AQAHAиRAѮAУAΏ\AQAffA{AAͅA
=AԣAA{A
=A(AffAA
=AAԸRA֣AָRAיA
=A{AA
AA
A͙AӅApApAffAA\)A  AΣAAGAzA̸RAAAAffAHAA  AQA33AɮAHAẠA33A{AΣAθRAAAffAHAљAҸRAӅA{A33AָRAA
A(A؏\AأAffAיA33A\)A
=AA
=AQAA\)AָRAApA\)AGAAָRA
AzAңAAЏ\Aҏ\AAffA33AϮA=qAGAHAAָRA  A{AAԏ\A{AHAGAԣA{A{A=qAԣA
AA33AAHAAAHAGA  AGA˅A\)AϮA\)AA(AAQA(Aԏ\A\)A  AծAffAAظRAHA(AA{AAAיA؏\AٮAHAA=qAAAڏ\AAۅAAQAHA
=AA  A޸RAޣAAAAAAޣAHA33A\)A߮AAzAܸRA{AAAAڸRAיAՙA33A֣A33AQAأA׮AָRAzAffAՙAָRA\)A֣A
=A\)AzAGApAԏ\A(AQA
A33AGAHAיA׮A
AҸRA=qAӅAGA֏\A
AхAӅA\)Aҏ\A\)AAAGAffA{A33AAأAHAQA(A=qAڣAffAٮAՅA
=AAGAיAHAAAA  AڣAHA33AAffAHA݅AݙA
AQA޸RAޏ\AApA߮A33AQAAݮAAA33AݙAGA
=A33ApAAݮAݮA(A܏\AٙApAQA(AڸRA\)AA{ApA\)AAHA؏\A؏\AAA(AծA֣AzA(A33A׮A
=AAzA  AffAAQA33A=qA{AЏ\AυAGAAA\)A=qAA{A{AHAAиRA  A33AQA=qA(AAQA֣AA
=AHA
=ApAׅAQA33AGAffApAAzApAzAݮAAAޏ\AߙA\A{A(A=qAARAApAHAAGAApAHA
AAޏ\A  A33AzA33A33A=qA33AיAمAA\)AGA33AA݅A  A=qAGA\)A  AA
=AzA{AGAۅA
AGAAָRAԣA33A
=AzA  A֏\A  A֏\AAׅAיAAأAQA  A
AׅA
=ApAQAffAԏ\AՙAծAA{AAzAApAיA  AAGAٙAڣAAۅAAQAݙAޏ\A\)A
A߮A  A(AffAzAARAAARAffA\AA  AAAAAA
A  A33AݮAzA  AAzAޣAAQA
AAA
AAzAܣAәAAAAA
=AffApA݅AzAݮA
A33AQAA݅A  Aޏ\AA߮A
AޣAA33AA\)AAHAQAA(AHAApAٙAڏ\A=qAHAܣAAzAGA=qAAۅAۮA܏\ApA  AHAAAffA
=AA(AzA
=ApA  AA(AA
AAA{A\)ARAzAAA33AߙAffAAffA33AzA(A{AٮAAܸRAAA܏\A33AzA\)AAzA  AHAAQA{A\)A܏\AAzA{A  A(ApAمA؏\A=qAڸRApAAA  AGAܣAQAQA
=AۙApA33ApA؏\A=qAAA
A  AA
=A  AzAڣAAHA
=AڣAۅAڸRAQApAݙA
=AAݮAޏ\A߮AzAA\AzAA\AAAHAQA  A=qAAA(A=qA
A  A=qA߅AzAA=qA\)AݮA
AA
=A  A=qAQA{AA(AA  AHAHA33AAAHA  AۅAA
A=qAA{A؏\A
AԸRAzAAGA֏\AԣA
A=qAAGApA(AAA
A33AGA{A=qAڸRAAQAٮAQAܣAA33A\)A  AݙApAAޏ\AA(AAA\)AߙAARAAA
A  AAAAAAA=qA(A(A{A(A  AA33A\)AAޏ\AݮA߮AzA(AߙA
AffAAߙA\)AٮAAQAAڏ\AיAffAGAծAHAffApAHAApA\)AffAAܣAAAffAQAA\)AGAAGAܸRApAڣAծA  A\)A
=AffAAA{AAffA{AAأApA
=A  AzA܏\AA33A\)A
A(AffA
=AAA޸RAGApAA(AQAQAffAAAHAHAA
A
AAAHA޸RAߙA޸RA  A\)AAQA=qAܸRA  AۅAA
AAܸRA
AzAAۮAAݙAݮAAGAܸRAQA{A=qAAݮA܏\A\)AAApAHAܸRAzAffAܣAAGAڸRAڸRAHAHAGA  A=qAڣAHA\)AAAGAGA\)AA
=A33A݅AA\)AHAHA{AGAۅA  A=qAܸRAܸRA(AA\)AۙA
=AڸRAۙAمAHAApAHAffA33AGA{AApA33A
=A
=AHA
=AڸRA\)AۅAۙA
=AApAۅAۮA{A=qA=qA{AڸRApAGAA
=AAGA؏\AظRAAzAAٮAA{AָRAיAA  AمAzAٮAApAA
=AQAAՙA(AӅAA  AHAхA
A  A  AA\)AAՙAAAхA=qA׮AQA׮A(AAQA33AۮAffAQA݅AݙAQA=qA=qA  AzAAA  A  ApA
=AAظRAQAzA؏\AzAHAA
A  AAHAHAأAAffA׮AAHA\)AمA\)A33A\)AGAGA33A؏\AظRA
=AffA{ApAأAׅApAمApAٮAAQA֏\AծApAGAAՙAGAԸRA
AӅA\)A
=AGAҸRAңAхAzAGAHAәA
A\)ApAAՙAQA  AA(AA
AծAQA\)A
AQAA
=AAڣA
=A
=A
A{A  A(A=qAffA܏\AAܣAܸRAAHAܸRAܣAffA(A  A  A(AۙAGAAڸRAAQA{A
ApAGAQA֣AGA=qAAظRAHA=qA33A
A
=AHA(A׮A
A\)AAQAAAиRAA=qAffA{AAAA\)AAApA֣AA=qAAיAיAՅAA=qAծAffA
AffA  AAיAGA(AHAٮA=qAApApAٙA{AQAڣAۅA{AAAڸRA
AQA=qA܏\A܏\AffAQA33AڸRA{A(AٮA{AمAA33A(AڣAGA
A33AA33AGApAԏ\AӮA\)AA33A
AAAA  A{ApA  AӮA
AffA  AңAӅAҏ\AхA\)AљA  AӮA  AԣAיAA
=AхAңAGAҏ\AҸRAҸRAHAҏ\AHAAУA  A
A33AυAυAA=qAffAAAGAхAAQAAA\)AӅAӅAA
=A33AAAңAzAffA(A
A
AAAAѮAхA\)AGA33AApAA\)A  AυA\)AQA  AzA  AHAA(AffAzApAzAͅA
AˮA
=AffAAzA
=Ȁ\ẠApAΏ\AzAApAϙA  A
=AA\)AʣA=qA{A=qAʸRAA33A33AʸRApAAAzA  AȸRAˮAʣA\)AGA\)A33A
AApA\)A(ApAffApA{A\ARA(AA  A\)A
AAffAGAAAGAA{AAAQAîA
=AzARAHAAHA33AHA=qAAA=qA
=AAAAAzAA
ApAA
AHA33ApA=qAʸRAA{A{AQAQA
=A33AȸRAAAAHAGAƣAģA{A˅AGA{AAzA  A  AzA(A{A=qAAAffAzAffA(AA=qApAHAA\)AиRApAңAffAAӅA
A=qA33AffAиRA\)AA
AzAхAυAA  AӮAAGAHAGAffA\)AљA  AzA=qA
=AAffAѮA{AAA\)Aڏ\AGAHA
=AAAأAٙA  A(A33ApAQAffAۮAڏ\AQAڣAڣAQA{A
A\)AQA
AAGAAԣAمAHAA(AAAAAՅA
AAՙAAԸRAҏ\AAՅAԣAGAՙAzAffAҸRA=qAAѮAӅAәA=qA  A\)AQAAиRAA(AA
AͅA33ẠA(AʣAA
AffA{A(AGAApAϙApAzA
=AA
AA33A{AQAGAәAffA
=A=qA33A؏\A33AQAAAHAzA
=AGAۮAA=qAA  AA33AٮAمAHAAHAAffAمAAљAAAHAAԏ\AAQAHA{A{AAAA
=AGAAAϮAAϙA
=A(A(AΣAΏ\AA  AAA(A
=AՙA{A  AHẠA͙AϙAәA
=AҸRAA
AGAԣAGA
=AGA\)A
=AAAԣAՅA  A{AzAҏ\AzA(AffA33AGAиRA  AӅAָRA׮AٙAAڣAڣAڣA=qAAۙA܏\AAAGAA  AAٮAAA(AAHAAՅAAՙAҏ\AA33AڣAA  AA
A
A
=AA33A{AӮA
=AمAQA=qA{A{Aԏ\AHA{AAA{AׅA{AAzApA{A֏\A{AffAAٮAمA=qA=qA=qA33AGAծAAԸRAAՙAHAA=qAڸRAAHA\)AA33A=qAA{AٙAHAڸRAڸRAGA\)AۅA
A(AAAAAAGApA݅AGA33AAܸRAzAAGAA\)AHAAA  A{AA(A
A  A؏\A{AffA{A֣AA\)AՅApAӅAAHA{AffAѮApAҸRAffAA
AQA  AAzAԣA
A\)A\)AӮAzAAӅAffAzAzA33AGA=qA
AAϙAA{AQA{A33A  AԸRAzA(A{A\)AAGApAAQAAԣAԸRA{A{AׅA(AA\)AAA
=A\)A\)ApA\)AGAۅAA
A
AڣAAۅA
ApA33AzAffA(A
=A=qAQA\)AAQAәAAAԣAGAA
=AQAAأAzA֣AA(A\)A
A=qA
=ApAAA{A
=AAϙAA  A
=AAHAٮA  Aҏ\AzAՅAGAAAApAAϙAffAAԏ\AffAAԏ\AA
=AzAAAQA=qAzAA{A
=AٙAڏ\AڸRA33AQAzAAAAޣAA(AAApAApAQA(AAA  A33AܸRA  A
AQAۅAיAffApA\)AA\)AיAٙA
=A؏\A(A{AzA
=AGAA\)AA=qA33AA֏\A33AffAA؏\AٙAQA
=AڸRAڸRApA܏\A=qAApA=qAхA{AԣA׮AծA
=ApA
AٮAۙAHAܣAٙAA
=AظRA  AۅA33A
=AۙAA(A\)AAمA\)AAQAݮAۙAۅA{ApA
A(AٙAA
=AQA=qAޏ\A\)A݅AA\)AݮAHA܏\AAA(ApAffAHA؏\AӮAAQA
AzApA  A{AٮA
=AA{AGAGA֏\A֣AGA33AיAיA׮AzAQAA{A  AAQA֣AיA  AA33AQApAԏ\AхApA(ApApApA{AљA  A33Aҏ\AиRAzAϮApAυAQAffA33AAיAQA=qAA֣A\)AAA  AA
=AQAٙAffA(AAA܏\AܸRA
=AGAݮA=qAޏ\AAQAAA
=AHA߅AHAAAA
A
A
ApAۙA܏\A{A  AApAAA=qA(A{AٙAAffAHA
=A(AHA  A؏\AGAAApAՙAHAHAA
AۮAA{A33AHA  AAAHAمAQAffAffAzAA=qAיAGA׮A
=A\)AمAA
=A=qAQAzAۙAA33Aڏ\A\)AAAAAzAAA{AܸRAA
=AAݮA݅A{A  A\)AGApA\)A
=AGAܸRA܏\A=qAApAA(A\)AڣA
A\)A33AۅAGApAۅA=qAA{A
AzApAڸRAٙA33AAHAٮAAAٮAٮA֏\AzAיAHAA33AAffAQA{AGAAӅAHA  A
AѮAGA
=AAHAA
=A{AA{AڣAzA  AՙA  AAՙAGAffAԣA\)A
AzAHAׅA  AظRAٙA=qAڸRA
=AۙA
=AffA܏\AܸRAAHA33AAGAAݮA(AݙAzA{A(AHAۙAGAAQAݮA޸RA
=AܣA\)A{A  A{A  A܏\A{AQAzAܣA=qAAffA=qAܣAAA
=A؏\AffAA
A(A33A33A
=AڣAGAffA=qA=qAQAzAGAӅApApA  A(AٙAAGAمA33AGA{A33AHAAծAffA
=AAָRA֏\A
AzAffAمAffAڸRAڸRA\)A33AGA\)A
=A  A=qAzAܸRA(A܏\AzA{A=qA=qA=qA=qApAۮAAظRAAٮA(AffAHAHA{AzA33AAzAApAQAٮA=qA33ApA(A
=A
=A
AffAzAHAHAAffAzA=qA\)A
=AQA(AHAA33A
AHAAQApAҏ\A  AҸRA\)AA33A
AAffA
=AԸRAAAңAQA=qAQA
AӮAԏ\AңAA  AԸRA
=AA(AQAQA  AAHA
AָRAAAzAA33A33A\)A(A33AAzAڏ\AAApAۅAHAAzA\)AٙApA
=AٙAٮA(A\)AGAمAffAQApA  A33ApAAA33A\)A=qA
=AQAՅA(A(AָRAAָRA33AHAHAָRA(AQA{A=qAڸRAمAAأA33A33A
A
AffA֣ApAָRAׅAAzAA(AffAzAA\)A=qA(AzAHA  A\)AۅA
AffAܸRAAA(A߮AA33A33AAQAzAzAffA(A\ARA\A(A33AzAAAffAAAA
A\)A(A{AۮAۅA(AffA33AA33A33ApA33ApA{A(AffA\)AA
=A=qAzA܏\AHAA
=A
=AA܏\A
=AGA  AGA  A{AffAHA\)AۅAHAڸRAAڸRAffAۮAۅAA33AڣAHAٮAڸRApAۙAQA{A=qA{AQAܸRAGA݅AGAQAffApA=qAA  AAGA33A{AzA\AHA\A(A  AA\)AAAffA
=AAA߅AޣA  A  AݙA݅AݙAݙA33AHA=qA(AzA֣AA
AAGA=qAA
AיAA=qA33A{AA
AffAHAffAQAAAAA
=A33AAAڸRA{AA
=A{ApA(AHAݙA݅AۅA
AGAAA=qA
A33AיA=qAA
=A\)AHAۙAAQAAA\)AݮAffAzAAAApA\)ApA(A=qAAAᙚA=qAA\AQA  ApAGAQAQAffA  AQAQA޸RA  AݙA\)AQA޸RA(AڣAHA{A݅A\)AA
=AHA\)A\)A܏\A
A݅A(AzAޣAޏ\AQAAAA{AיAAGA
=ApAA޸RAffA=qAGAA\)A
=ApA33A33AݙA
=AݮAffAܸRA33AAApAڣAظRAAQAffA{AAڣAA33A33AٙAQA=qAڣAٮA  AHAzApAGAA(AA=qA33AAAAׅAظRAأApAQAQAأApAQAA{AzAAAأA  AיA
ApA33AA33AָRApAHA\)A\)AzA
=AAA  AAיA֣A
AՅA
AHA  A=qA
=AAHAA
=A{A=qA=qA؏\AAיAָRApA(A{AיA  AGA(A\)A(A׮A
A33ApA=qAA׮A  AA{AأA(AڣAڸRAAۙAAA
AzA
=AGApAGA  A(A{AA݅AAٮAffAٙAffAٮAQAQAAzA׮A\)AׅAGAzAQAمA؏\A܏\AAܣA܏\A=qA
AffA  A
=AGA=qAיAAffA=qA33A\)A
=AAљAHA=qAУA=qA{AϮAϮA{A(A{AAҸRAQA=qAGAA  A{AϙA  AHAA{A  AzAAAQAҏ\AzAHAՙA{AHA33A׮AA
=AGA{A=qAffAڣAڸRAApA\)AۙAAܸRAQAApA
A
AݙA
=AܸRAffAݮAAݙA
=AڸRAڣAAۙAQAAA=qAzA33A\)AGA\)A  A  AAAzA
=AAGAAӮAQAӅAAHAәA=qA
=AӅAAָRAQA{AAAAAۮA  AAA=qAA(A(AffA(A(AA
=A(AHA
AָRAA֏\Aԏ\AңAхA\)A=qAA(AAGAGA{AAծA֣AHAHAAAAָRAzAGA
Aԏ\ApAA\)ApAAԸRAԏ\AQA  A  ApAHAԸRAAGA  AAA֏\AAffA{AQAQA֏\A֣AAA(Aҏ\A\)AңAA
=A=qAApAffA=qAׅA  A
AA{A\)A֏\A؏\A33A
=AԣA\)A{A{AAӅAAңA(AхAApAУA33A{AQAҸRAGAQAٙAzA
A؏\AA33ApA=qA(AA=qAQAԸRAAAA=qA33AAAљAA
AHAԏ\AQA\)A(AHA؏\A
=Aҏ\A  AӅAңA{A(A\)AAA33AҸRAԏ\A{A˅AffAAA=qA{AAѮAУAzAУAЏ\AυAͮAͮAHA
AGApA˅AˮAA  AAA  AҸRA
AУA=qAΣAAAAхAϮAәAAAиRAGAAHA  AffAHA33A(AAA33AиRApA33AAzAԣAԣA
A(AA
A(A֏\AיA  AHAffAA=qAQA{AծAGA׮ApAԏ\ApAAAzA33A(A
AA=qA(AAAңAԏ\AԣA(A
=AQAGAA  A(A
=A(A{AGAA33AAѮA
=AffA  A\)A=qAϮAA{AHAffA  A33AA
=AΣA\)AѮA\)AA33AAGAA(Aԏ\AA
=A  AظRAffAظRAAzAQAՙAzAQAApAԣAAԣA  AGA=qAӅA  AӅAA
=AAA33AA33A\)AGAәA33AGA33AՅA
AHA  A
AHA33AQAхA
AAAԸRAҏ\A=qAҸRA\)AGA  A
=AA(AAffA  AHA33A{AθRAAHApAӮA=qA(A=qA33AA(AAAGAGAzAA  AAԸRA
=AԣA
=AAApApAGAͮAA̸RA33AA\)AϙAQApA=qAffAҸRA{AAQAQAأAAA֣AGAأA֏\AA\)AQAA
AAAAGA\)A
ApA
A(A
AQAQAzA  ApAA  AӅApAHA  A\)A\)A֏\AAQAՙA
AGAAծAHA  AffAծA33AAGAҸRAԸRA{AAљApAzA(AzAAυA=qAиRAGAӮA33AffAУAAAӮAAAA=qA(A=qAGA=qAԣAHAzA\)AAzAGAՙA33AיAA{AQAAٮA  AٮA{A{Aڏ\AHAۮAۙAA
A  A{A(AA(A܏\A33AGA  AAAAA33AA\)AHA܏\AA(A
AۙAAA(AQAԏ\A(A=qApAAzAAڏ\AzA  AAQAAA{A(AffApAA(A(AՙAffA֏\AAQApAHAGAՙApAԣApAԸRAffA\)A
=AظRA  AHApAzA  AQA{AٮAڣAA  A\)AA{AffAڸRAAAA܏\A
=AݮA=qAA=qAQAޏ\A=qAݮA݅A܏\AAAۙAۅA(AݙA  A\)A܏\A
A\)A
=A
=AffAٙAzAٙAAڣAڸRAڣAHAAיAA33AAAzAۙA=qA=qA33AffA(AՅA(A
AمAׅApA
=AzA(A  A֏\A{AծA33A֏\AAA33AffAA(AәA=qAHAHAAڣA  AAA=qAffAQAAGAQA
=AծAծAՙAQA{AׅAA׮A֣A  A{AA{AHApAԸRA
=AAHAAՅAՅA33AAԏ\ApAA\)Aԏ\AQAәAHAAԣAHA\)A\)AׅAGAAA33A{AAӮA{AٙAA  AיAHAHAAHA=qAA
=AAԏ\AҸRAԣAAׅA33A  A{A  AمA(AA=qAأAԏ\A{AA33AظRA(A
=AHApA=qAzAA(AAHA33A(AzAA33A\)AQAQA(AܣAAݙAAzA޸RA
=A\)A߮A{AzAffA
ApAޏ\A߮A33A\)AzAAffAA\)A
=AۅAۮApAAzAݮAA\)AڸRAHA
=AHAQAQAظRAڸRAAڣApAٙAܸRAۅAޣAޏ\A޸RA
=A33A
AHAݮAA
A
A(AٮAٙApAظRAAAAzA\)A
AمA׮A
AHA\)A
A33AٮA=qAA
AڸRA׮AٮAffAzAأA
=AٙAڸRAۅA(AffAܣA33A  AQAzAޣA\)AAA߅AA{AA
A=qAApAA
AzAAA
=AAAApAA\)AᙚAA{AᙚAARAzAA
=ApAޣAAAAA
=A߅AQAA\AffAAA\)AޣAffAQA33A=qAA33AAAۅAGAQAٙAݙAHA33A\)A޸RAzAzAAA\)A
A޸RAAAGA{AۅA܏\AۮA\)A\)ApA(A\)AٮAzAGAۙAffA  A  A(A
AۅAHA\)A׮A
AA؏\A{AA=qAzA33AQAffAA
=AA
AԸRAծAӅA  AffAָRAGA  AָRA=qA
A=qAיA\)A֏\A{A(AA  AAGAHA=qAQAHAAQA
=AA
=AAAA\)AGA{AA(A
A{AQApApA{AzA\)AGA
=AHAA(AzA{AȸRAɅA33AffAȏ\AHA=qA{AĸRAzA33AAQA=qA33A\)A{A\AAzA
=ApAAA͙A  A{AͅẠAAˮA͙A
AAQApAAͅAA  A{AϮAA  AHA
AHAAQAAͮA
=Ȁ\A˙AʣAA33AA{Aȏ\A=qA\)AɮA  A  AHAGAAAAA{AAѮAQAAΣA\)AљA  A{A
=AҸRAQA33AAӅAzAA
A
AHAAA
AGA
AAǙAиRAAQA
=A(AGA\)AʸRAzAȏ\A{A
=ẠA  AAAAA˅A
=AHAAҏ\Aҏ\AAAAԸRAA33AAAAӮAAԸRA{A
ApAԣA33A(AffA{A\)AGA
AQAffApA(A=qApA=qA33A㙚A\)AA(AAݮA=qAݙA=qAA߅A
=AAzAݙA(AA
=AffA܏\AظRA\)AQAծA(A
AۮAܸRAA  AܣAۅAzAAffAڸRAأAڣAGAծA
=AGAA
=AхAA׮A=qAGAzAӅAQAQAӅAAAAffA
=AA
AGAQAӅA{A33AA֣AGAHA  A
=A  A=qA
AظRAׅA(AڸRAApAԸRA֣A  AHAQA=qAffAA݅A=qAGAzA\)A{AAA33A  AzAޏ\AAܣAGAzA
=A(AApAיA
=AGAA{A֏\A׮AA33AAٮA׮ApA
AAAAAHAܣAAAAиRAڣAڸRAffAٙAzAӮAA\)A
=A=qAAӅA{AQA
=AAAAHA
=A  AϮAAϮAҏ\A=qApAԸRA{AAԣAAzA\)AA\)A\)AAHAA(A֣A33AAQA(A
A=qAA
AAAA=qA  AA33AAAzAݮA  A
=AffAڣA(A{AApAzA=qA
=A
=AٙAAA(ApAAffAAA׮AיAٙAHApAAQAAAApAHAՅAQA֣AA{AAzAA  AA(A
AAظRAGAffAԸRAQApAGApAAAQApAAffA\)AAHAޏ\A=qA\AݙAۅAAA(ApAGA=qAۙA݅A܏\A{AARApA߅A߮A=qAffAAܣAAיA33AՙA\)A=qAzAAA
A(AzApAA33A(A  AAQAԸRAAzAϙAAӮA{AQAAԸRA
A=qAA  ApAЏ\AхA\)A
AA=qAϙA
=AΏ\A
A˅A=qA33A33A̸RA{A  A
AHAљAA33A33AzAA=qA33AAˮAΣA{AzAЏ\A33A=qA{AHAѮApA=qA\)AHAAA
AAQAzAʸRAffAA\)A\)AGA{AΏ\AθRA
A{ApAAˮAˮA  ApA
AΣA
AϙA{AиRApA
AҸRAϙA=qAʣAəA
=A{A=qA(AGAУAͮAAϮA
AЏ\A33AQAAθRAQAQAΣAA{AffA=qAͮẠAHAˮA\)AʣAAAA=qAͅAGA33A
=Aҏ\A33AGAθRAAffAffA  AϮAA
A
AәAϮA\)AAAAϮApA  A{ApApAA֣A33AAיAA
AffAAAA  AHAzAٮApApAQA
AָRA=qA{AхAAأA{A
=AׅAAAԏ\A
AأAA؏\AHA
=AAA33AGAffAϮA(AAAϙA=qA  A=qA{AϮAυAͅA(AGAAQA33AzA
=AA
A  A(AA33A\)A33AHAHA=qAQApAA
=AA\)A\)A\)AGA{AA\)AffApA\)AA(A\A{AA(A(A=qApAƏ\AzAƸRA{AA33A33ApA33A  ApAA
AAA
=AHA(A(AffAA=qA
=AffAAGAGAA\AffA
=A  AHAA
A  AQAA\ApAA  A  AAzA\AAffA\ARApA33AAAffAQA
=A\A\)A\)AzAA\AAGAAAzAzA=qAHAHA{ApAzAHAzApA=qAzA\AAA{A£A=qA=qA=qAA
=A\)A  AffA
=AffA
=A
=AA=qA\)ApAGAəAAAGA(AAȏ\AffAƸRA  AA\)AAGA33A=qAʏ\A  AȣAffApAHAϙA̸RA˙AHA33AGA˙AffA˅AHAApAȸRAffA
=A(Aʏ\AHAAA(AA33AA\)A\)AzAA33A  AzAəAQApAAřAAîAAAƣAGA  AffAǅAAAffAHAzAAGA\)A
ApAԏ\AԸRAծAGAHAzAffApAAAQAApAGAApA33A{AəAA(A=qAУA
=A  AHA33AzA{A33A  A
A  AHAϮAzAΣA͙AAA  A˅AffA  AGAѮA=qAA=qAQA33AAQA
ApA\)AAQA{AQA33A
=AffAAӮApAυAzA{A=qA  AHA֏\ApA
AA(A؏\AAzAzAffAQAAA֏\AQA33AffA
A  A
=A
AGA֏\AA׮AA֏\AA  A33AHA  AffAAA
AzA֏\AffAApAхApA  A
=AָRAA  A  A(AԣAzA
AAA(A{AQAffA֏\AA=qA=qA=qA
AҸRApApA
=Aҏ\AAхAQA{A  A{A\)AϮAΣApA=qAAGAGA{AЏ\AиRAA  AA
ApAͮAzA=qAzAΏ\AA{A
AA
=AυA  AA=qApAGA\)AυApAϮA{AAffAˮA  AͅA33A
=A33A  AAAApA33A{AHA
=AAθRA33A(Ȁ\A
=AGAͅA33AHAAzAAA  AAGAʏ\A\)AAAϮA̸RAGAQA\)A(A=qA͙Ȁ\A  AGAəAAǅAAzA  Aȏ\AAHA{AǙApA33A=qAAzAQA  AˮAˮAAAHAA\)AAAA{AQAυA(AAA(A=qAΏ\AԣApAA33AԸRA
=AΣAҏ\AУAӅAθRAAθRA{AمAڣAAAA
AA{AӅAA=qA33AأA
A33A
=ApApAծA
=AQApAzA
=ApApA{AGAծA
AHA  Aҏ\AHAAzAAQA\)AA
=AΣAͮA\)A(AAɅAHAHApA=qAڣA=qAAAA  A(AљAA33A=qA׮AָRAՙAיAԸRA=qAGAzA{AGA
A{A\)AQAՙA׮AأApAٮA
AQA=qAzAA(AA{A{AApAAHAAɅA\)AHAՙAӅAGA\)A֏\AڣA\)AffApAѮA  AA\)A
A؏\AA
A=qAQAAAAԏ\AӮAAAAA=qAAGA
=AυAϮAϙA
=AHAA(ApA=qAՅAңAиRAAљApAAAzA
=AхAA(A33Aԏ\A(A(AхAΣAAυAAGAA  A
=AԣA
AHAApA=qAأAzAظRAѮAAԸRA؏\A33AAHAԏ\AԸRAzAA  AAA33AAA  AGAAA
=AAQAӅA  A33AHAQA
AQAffAQAיAԣAzA\)AЏ\A(AAffA
=AA(A
=AzAԏ\A
=AA\)A  A\)AA=qAծApAׅA܏\AQA
=AGA{A
=AffAAԏ\A
A(A{A(AApApA\)AAۅAA׮ApAAffAAָRA(AA
=A{AQA  A{AHApAffAA=qAQAzAGA  A  A33AffAхAԏ\AՅAQAGA
AffA=qAffAمA\)A(AָRAAzAѮAQA33AGAׅAיAAGA
AA(Aԏ\A33AzAGApAGAԸRA
=AffA  A{AffAAӮA(AAAиRA=qA
A  A{AиRAڣA=qA\)A33A\)AA؏\AGA֏\AיAQA\)AأA׮A؏\AGAۮApA{AAۮAGAA
=A(AׅA  A{ApAAA(AffAٙAA{Aڏ\AڸRAffAA=qAڸRAQAQAGAڏ\A{AGA=qAׅAAA33A  AAffA׮A(AA  AGAۮAQAمApAQAAA{AA33AA
=AAٙAffA
AՅAԸRAԏ\A֏\A  A\)A
ApAٮA\)AGA֏\A33ApAծAAAՅA33AָRAمA
ApA
ApA=qA\)AׅAٮAAAAA
AQAۮAA
=A؏\A
=A33AA  AAمAQAAQA܏\A܏\AܣA
=A\)A\)A݅A\)AzApAڸRAمAzAAA\)AffAڣA\)A{AffA  AA33A
AHA
AAQA߅AޣA݅AܣAڸRA
=AAA=qAQARA
AffAffAܣAAzAffA
AAأA{A=qAffAAمAHA{A\)A\)AA  A{AA=qAٮAA33A
=AA\)A(ApAffAGA=qAffApA\)AAA؏\A(AA
AffA  AffAܣAffAA
=AA  AA33AA(AzA\AzA\AffAA\AޣAA=qAۮAۮApAڏ\AAQA  A
AQAۅAڣAQA
A{AzA(AA  A  AffA=qAzAHA\)AQAA{A
=AA{AA
=A{AffAzAA33AQA  AQAӅAA=qAA\)AܣAA  AHAA  A=qAAApAڏ\AAܸRA33AA{ApApAAAzA܏\A܏\AzAHAGAޣAAA߮A  AAHA(ApAᙚAAAAA{AA  AAHAffA(A  A{AA߮A(AA=qA݅AA=qA
=AGAޣAApAޣA
AGA޸RAffAAA(A=qAzARAGAA{AffARA{A\A
AffA=qAzAAޣAAzA(A  ApA
A
=AAڏ\ApA  A  AA(AᙚA{AAAAQA  AzAARAA  A\)A߮A܏\AA(A\AA
AAGAA߮AGAߙA߮AAޣA
=AARA=qAzAAffAA
A33AߙAA߮AffAAޣAQA߅AAݮA
A\)ApAۅAAAיAffAٮAHAzA
=AHAٙA\)A33A֏\A׮A֏\A
AAQAGAA
=AAָRAQApApAAffAՅA
ApA׮AzAۮA(AffAA\)ApA33ApA
=Aڏ\AGAظRA\)AAۙAمA33A֣AҸRAA33AA(AHApAA=qAzAffAGAHA  A{A{AffA׮AGAՙA׮AAzA֏\AQAA{AApA\)ApAGA  Ȁ\AͅA
=A33AθRAљAA
AzAHA=qAA(AӮA{A
=AAffAGApA
=A33ApAzA\)A  A\)AǙAffA  A{AAAA  AGA  AAǙAAAGAA33A{ApAĸRA£A
=AA˙A{AHA\)A˅A˅A˙A\)AA
AŮApAAAŅAAAA
=AQAQA=qA(AAA=qAA͙AA{AzAAA͙AЏ\A\)AAzA  ApAƏ\ApA\)AǅA\)AƣA{AA\)AɮA
=ApAzA  ApApAA͙A=qAA  A{AAʣAffȀ\AzAͅA\)AffAzA(AA{AAәAҸRA33AQApAљAHA
AA  AGA\)AָRA(AָRAיAffA؏\A
=AAQA33A33AGA
=AzAzAHAQAָRAHAAA=qAA(ApAA  A
AffAzAGA(A  AAԣAzAԸRAHAӮA=qAԏ\AA  A
=A(A{AGA33A׮AAՙA{AA
=A{A
A  AAAGAљA\)ẠA  AҸRAAȣAA=qAAHAffA=qAȀ\AΏ\AУA33Aҏ\A
AQAGAәAffAA  AGA֣A
AծA֏\AA(A=qAAHAzApAGA=qAA(A{AA\)A33A=qAA  ApAAУA\)AAAA
=AHA
=A(A
=AAυA
=A
AGAхAGAAAAGAGAљAzAffAҸRAQA{AA(A\)A  A(A(AA{Aҏ\AңA
=A
AffAApAHAхA=qA(A
A(AHAҸRA=qAffAҏ\AѮA
AHAϙA
=AϙAυAA{AffA\)AGA  AGA(A
AA=qAAAGAAǅA(AffAQAA{AУAͮAA(AAA{Aʏ\AffAQA33AAϮAУAHAϙA
=AAffAϮA\)AA=qApA
AffAAHA
=ApAHAAzA33AA\)AHA{A=qA\)ApAظRA\)AQAׅA\)A=qA(AA  AffAzA
=AHAҏ\A  A\)AхAAffAхA{AҸRA(AיAzA{A33AңAQAApAϮAAϙA33AΣApAϙAυAGApAA(AA{AϙAϮAAAA(AHAΏ\A͙AˮA=qApAffAϙAAθRAϮAzA
=AzAУAzAHAA{AәAGAzAQAzAԸRAApAՅAffAAAAمAڸRA\)AݮA݅A݅A݅AݙAA
AffAיA
=AzA33AڸRAܸRA  AffAzA܏\A{A33A33AAQApA  A
=AٙA؏\A
=A
AGA{AׅAӮAHAծA=qAָRA֣A
AՙApA\)AAՙA(AAA=qAffAGA
AzA֏\A=qA
AQA=qAңAAAӅAAA
AӅAӅA  AzApA33AffAA\)A(AѮAffAApA=qAzA͙AAzA˙AffA33A
=AɅA33AHA\)AAAffAA
A  A͙A
=AA{Ȁ\AͮA33AAA(A
A{AHAHAͮA
ApAGAAͮAAApAˮAA=qAʣAHA{AǅAA{AȸRA=qAAAffAƣAffA{AAA33AƏ\A
=AHAHA(AHAȣAȸRA  AGA˅A
=AzAHA
=A͙AϮAȀ\A\)A\)AɅA\)A\)AʸRAʣAəAGAAA
A\)A(A͙AHApApAffA  A  A{AQAHAQAΣAA
AAAAͅAQAӅA{AAA{AzA33AՙA֏\AQAHAϙA  AA(AӮAAAυAA  AAHA33A=qAAGAͅA͙A  A̸RA  A̸RA(AA\)A33AffAQAхA˙A
=A˙AAиRA\)AͮAAzAQAУAиRAЏ\AϙAA
AЏ\AϙAGA
=A(AGA\)AA  AGA=qAυAzAѮAQAzAApAӅA(AHAAՅA{AffAיAׅAGApAׅAיA(A֣AA֣AA\)AAQA33ApAA33AzAAA֣A33AAAͅA
A{AAԏ\AمAAڣAۮA
=AApAУAA
=AQAУAӅAQAAGApAAA
=AAҏ\AҸRAәA\)AΣApAљAͮAHA=qApA33AљAAУAAGA{AA\)AGA{AѮAHAzA=qA=qAԏ\AAA{A
AHApAӮAA33A{Aԏ\Aԏ\Aԏ\ApA֏\A(AHA33ApA=qAָRAAffA֣A
AGAΣA(A=qAAzA
=AָRAӮA33AָRAAӅA  AQAA{AAHAffA33AAθRAѮA(ẠAA(A33ApA
AGAGA{AGAA{A=qAУA
ẠAHA\)A33A33AʣAʏ\ẠAQA
=AՙAAՅAHAԏ\A
AAЏ\AzAиRApAӮAҏ\A33A(AHAffA=qAzAA
=AzA{AٙAAzAffA=qA\)AffAAA\)A
ApA  A33AzAҸRAAAԸRA=qA
AHAAԣAffAθRAA
AzAԏ\AӅA  AңAңAхAиRAAAHAθRAΏ\AϮA(AA͙A33AυAͮAffA\)AAУAхAApA=qAAЏ\AQAϙAϙA  AffAͮA͙AffA33A{A33AAGAҸRA׮AԣAיA֣AAAGAffAGA{AхA\)AA33AA{AϮA  AzAffAA  A{AQA33AAѮA{A(AҸRA
=A\)A\)A\)AA33AAAffA=qA\)AәAAљAAAԸRA=qAzA\)A(AffAԏ\AθRAffA33AQAңApAAAAffAApAA\)A
A\)A\)A  A33AхA(AA
AffAͅAAHAAӅAA\)A  A{A33AхAA\)AӮAGA(A˙A
A
=AA\)A\)A\)AAAљA
AffAиRAzA(AApA֣A֣AAGA(ApAA
AQAA؏\AffAAA\)AGAAHAGAڏ\AQA=qAمA
A(AأAمAיA׮AzA֣AQAՙAQAGApA(A{A(AzA(AA  A\)A=qAAzAՙAծAAzAЏ\AHApA
A=qAأAAzAQA\)Aҏ\A
=A
=A33ApAAAQApAҸRAGA  AAڣA(AәAAҸRAffA֏\A\)A
=A֏\AՙAAָRAHAAׅAA{AGAAQAڸRAQAڏ\Aڏ\AڸRAzA
AGAAzA33AHA=qAAAمAأA\)AGAAAzA֏\A
=A
=A(AיAA\)AGA
=A(A  AA33AzAGAԣA33AAffA  AffAA=qAQAӅAGAҸRAQA(A
AѮApApA(AAAϮA׮AQAGAAΣAHAѮAGApA(A=qAHAffAԣAQA{AGAԣAQA{AGAA(AAҸRAӅA=qAAGAffA=qA(AffAԣAHAAA{ApAAAGAAЏ\AAAHAAA˙A{A
AQA͙ApA
AУAϮAA
=AGAυA  A(AΣAQA\)AAA=qAɅAȣA33AƏ\A33Aď\A{A{AîA{A
AffApAA\)ApAHAîAHAA{A
=A
=AîA£A{A{AHAAAAA{ApAAQApA\AzAffAAAAƣA=qA33AÙAAAA  AA{A{A(AffA33AAGAA\)AA
=AîAAGA(A  AAAÅAGA=qAARApAGAARAAA(AffAffAAAA
AffAHAAzAAA\AAA(AAA
ARAzAHAA33AA(A{A\AffA\)AQAQApAAGAAHApAA  A33ApAA=qAAHAzAAAAQAAffAzAffA  A  AAA(A\A33A£AGAŅAA
A  A\)A
=AffAzAĸRAA\)Aď\A
A\)A\)A£AAA
AA{A
AzAAAAĸRAHAHAʣAA
=AƸRApAzAApA=qAA
=AHA\)AA¸RAGAAGA
AzAQA\A
=A=qAA{A33A
A(AA33AAA33A(AA\)A\A33A
=AAffAA{AQApAApAAffApARARAAA
=AA  A(AŅAzAˮA
A  A=qAA\)AƏ\AřAĸRAAHA
A33AÙA
=AA(AA33A
AHAAA{AAGAApA£AřA33ApA\)AA  AffAGA¸RA33A=qAAAÅA¸RAzA{AA
=A
A{AffA
AAffAA(A\A33AA33A{AGAA(ARA{A\ARAGA33A33AAAQA  A  A(AffAffAAA
AAAHApAA33A=qA  A=qAffARA(AA\AGA(A
=AGA
AffA£A  A33A33A
A33AHAAzAQAHA\)A  AQAAAzAA\)AAAGAAA{A\)A
=AAffAffA
=AAzA(AA
A
AGAA\)A
=A\AzAffARA=qA\AA\A
=A¸RAQA
=A\)ApA{AA  AAAA
=A
AA
=AAGAGA
=A
AGA33AGA(A  AQAffAzAA(ApAQAzA¸RA{AŮA\)AAApAGA=qAřAɮAȣAAAAɮAȏ\A
AǅAAǮAffAGA
=AffA\)A=qAzAzAApAQA  A(AAffAAA(A{AzAÙAGA  AQAAŮA
AAQAAAHAAffAď\A=qAƏ\AHAffA
A\)A{AzAȸRA=qA{A\Aď\ApA=qAA33A(AGAŮA\AGAîA(A\)AîA(A\A33AÙA  AQA(AffAzA\)AÙA(AA=qAA\)AGAzAA33A  AA(AÙAAA  A\)AHA=qA=qA\AzA(A\)AHA\AAAGAHAA(AQAAǮAGAʣA33AGA{AAǮA=qAAGAƸRAƣA  AŮAŅA  AƏ\AA
AA  A£A  AAAA  AAģAAzAQA{AAŅAƣAĸRA\)AǅA˙Aȏ\AřA{A
AȸRA\)AQA(AHApA\)AAͮAHA
AϙA
AљA{AAӮA\)AzAңA{AУAffAϙA
=A̸RAθRAAΏ\AˮAffA˅AApAAƣA(AHAʸRApA˅AHAA33AzAAAƸRA\)AA(A\)A  AA33A{Aȏ\AzAA{ApA
=A{A  ApAǅA33Aȏ\ApAGA(AȣA33A
AȸRA33AApAɅA33Aȏ\AzA
=AzAAȣAffA\)A33AHAΣA
AA=qAЏ\A
AffA{AңAңA
A=qAAљAQA
Aʏ\AA\)AAAHAHAAA\)A33AzA
=Aҏ\AGA{AA
=AΣAffA(ApAʣAA{AffA=qAA
AɅA{AǮAɮApAǙAȣA\)ApA˙AzAA(A
=AQAƸRAAHA  A33AHA=qAQA(AʸRA
=A\)AffA\)A33A{AHAȣA
Ȁ\A\)AQAAzAffAzAA̸RAHA{AA=qA
=AAA(AHA{AAҸRAAծA\)AAGAQA\)AљAQApAGApAAҏ\AQAӅAAAffAԏ\AӮA
AҸRAHA\)AA33AApA(AGApAAAHA33AA
AA  AffAΣAҸRAʏ\A  A
=AA  AAQA(AAHAΣA(A33A˅AͅAͮAApA
=AGA33A
=A=qA\)AɮAȣAȣAAȸRAffAAɮAA{A(AʸRAA33AAzAAHAθRAϮAA33AA(A  A=qApApAAQA=qAffAzA
=A
=ApAϙAA
AzAљAQA{AυAA  A
A\)AʣAQA
=AffA͙AQAɮAA
=A
=A33AA=qAʸRA{AA
=A
=AzApAȀ\ẠẠAzAAȸRAˮA=qA  AͅAA33AffA
=A͙A{AzApA˙AQA\)A33AѮAAљAA=qA33A(AffAA33A\)AHA  AAхAzA=qA33AHA{AQAΏ\AAAAHApAθRA
=A
=AAffAA\)A  AAQAHA  AAHAAЏ\A33AәA(A{AQA˙AQAGA
=AθRA  A  A33A
=A=qAʸRA\)AA˅A33Aȏ\AffA\)AQA  AGAffAffA=qAəA{A
=AȸRA33AHAȸRAAA33AzA=qAzAȸRA{AA=qAQA{AHAffAHAǙAAϮAA
=AAzA
=AGA
=A{A  A(AиRA
=AѮA(A
=A  AAA\)A
=AԸRAzA
=A  A(A\)AυAGA=qAA{AAиRAzAͮAAЏ\A{A{AGAAHAAzAϙA̸RAGAGAA  A  ẠA33A
A{A\)AAΏ\A  A=qA\)A͙Ȁ\A\)AffAAAAGAApApA\)A
=AGAHA
=AA(AffA
A\)AAHA=qAхA  AQA=qA\)AzAGAθRAHAAA=qȀ\ẠA=qA33AAυA
=AzAAAхAAQAffAA  A  A֏\A
=AAAffAԸRAA(AffAәAָRAffA͙AAԸRA\)AQA
=AQAffA  AљAzAAA  AQAϮAԣAծAHAAzAHAՅAQA
AGA(A(AffA33AϙA{A
=AAA(A\)AQA\)AGA(A{AzAA=qAA͙AGA\)AиRA˅A33AȣAA\)A{AAQA{AffA\)A  AAAˮAAҏ\AQAQAAѮA(A
AAAӮA=qAAGA(AzAGAԸRAԣA{AәAA(AAzApAffAθRA=qAҸRA\)AHAA{AAиRAAzAͅAҏ\A  A{A  A
AAzA  ApAHAAQA\)A33AAǅA33A
AA  AHAHA\)ApAŮA
=AzAA  AffAffA
=AυAңAAAˮA͙ẠA\)A(Aʏ\AA33ApA͙AzA=qA  A
AʣA\)AʣA(Aʏ\ApAA\)A˙A\)A˙A{AzA\)AAAAAzA
=AA(AљAHAхA
ApA=qAͅẠAA˅AˮAffA  A  AȸRAA(AA{AAAAffAA(A\)A͙AGAAHAAΏ\AΣAϮA{A˅AffAΏ\A͙AΣA
=AAAϮAffAQAˮA
A
=ApA{A(A(AŅA
=AǮAzAƸRAGA{AɮAʣAʏ\A{Aʏ\A˙AAA
=AA
AzAAȏ\AAʸRAA
A(A
AřA
AŅAA{A  AzAAA(AAʏ\A
=AAA(A=qA
=AffAϙApA=qAͮAAͮA(A(ApAΏ\AHAϙAΏ\AAAA
=A(A{AҸRA(AхAHA  AAApAGAΏ\AQAHA{AA  AHA\)A33A33A\)ẠAAGA\)AυȀ\A  A(A=qA(AΏ\A=qȀ\A͙AHA\)A
AzAAAď\ApAA=qAA=qAzAGAApAzA
=A(AGAGAA(AĸRA=qAzAAA\)A
=ApA{AHA33AHAA=qA¸RAA33A\AÙAƏ\A
=AAA=qAQA
=A¸RAAAΏ\ẠAQAAQA  AAϮApA̸RAAʸRAəA
=AAGAzAƣA33AHAzAǅA  AǅA{AffA\)A=qAǙAAA=qAAƣAǙAffAHAA{A
AzApAA  ApA{AzA{AǅA
AQA{A\)A
=AɮA
A=qAQA(AAAGAAHApAAʏ\AA\)A
AƣA
AzAîAAAApAAA(ApA  A
=AAGAHAHARAzA
A
=AffAAA\AzAGA\A\)AQA=qA
=AGA33AAA{AzARA33A\AAffAA33AAzAA{AA33A\AQA
AAzA
ApAAzAAAARA33AGAAQAAHAAAA{AǙAǙAȣA=qAzA33AЏ\AϙA̸RA33AA=qA33AGA\)AA=qAυA\)A{A=qApAʣAʏ\A£AHA£AAA{AApAÙA
A33AffAĸRAƸRA
=A
=AAřA=qAA=qA{AGAApA  AǮA
=AAAAHAAffAAƸRA
A=qAAApA33Aď\A
AƏ\AAŅAŅAAAAŅAAƏ\A
AApAŮA\)ApAA{AHAAA
=A\)AAAAAA
A
A  AȸRA=qA
AAApA
=AHA33AǙAQA=qA33A{A\)AŮAzAƏ\ApA(AQA=qAǮA
=A{A  AA  A=qA(AϙAˮA
A
AffA{AA
AəAɮAffAAAģAzAAƣAɮA(A  AA=qAAffAAARAAzAzA
=AA\)AAHARA
=AA=qAAAA
A(A  AAQAQApAAA
=AîAA\)A
A(AŅA
=ApAǮA(A33AA33AzAA
AzA=qAAApAŮAAA{A
AȣAřAAQAApAAzAA  A
=AzAAffAÅAA
=AGAĸRAA
Aď\A
=AGA33AĸRAģAď\AQA33AAQA(A
AQA
=AƏ\AGA
AŅAA
AAA  A
A{AGAHAŅA=qApA(A(AAƣA=qA  AAřAffA=qA\)AƣAǙApAA\)A
AffA  A
AQA{AApAA=qA
=AGA{Aȏ\Aʏ\AʸRAGAffA
AθRAθRA\)AУAzAffAzAAȏ\AA=qAˮA
AA  AGAAθRAAхAAAHA=qAA˙A=qAθRẠAAAʣAQAzAȸRAʸRA{AA=qAA
ApA=qAzAQA˙A
AAɅAȸRAAQA=qAAAȏ\AɅAƏ\AƸRAƣAffAA
=A{A˙A(AAʣA{AA
=AȣApAAGAHȀ\A\)ẠA\)AzAzA=qA͙A(A{AQAzA=qA=qAGAAQAzAQAAAGAffA=qA33AʣA\)AиRAAGA̸RAɅAA33A  AͅA33A  A{AA(AzȀ\AApAŮAĸRAƸRAAffAGA  AƣA\A33AAGAƸRA(AŮAQAHAQApAAȀ\A33AɮAA{Aʏ\AA˅A(A=qApAzA  AͮA
AңA  AGAәA
=ApAӮAA=qAQAA
AA  AffA  AQAAхAAA\)AA33Aʏ\AǅAɮAAHAQȀ\AHAAAϙAAffAffAAAθRAʸRAzAͮAAθRAzAΏ\AʸRAͅAͅAAẠAʸRA
=ApA{AAͅA=qAffAϙAʸRA˅AυAQAAHA{ApAAGAzAzAGAA{A˅AHAɮA=qAA˙AͅApA  AzAHA  A
AffA33A͙A=qAHAffAffAffAA\)AͮAA
A\)AzAA=qAϮA33AAffAθRAϙA33A
AиRAЏ\AУA  A33A  A͙AGA=qAA\)A{A{AAA33AGAApAA(AHAA{AA
=AA̸RAA\)Ȁ\AHAHAA33AQA
AGAƸRAAGA(AAAȣAA
AǮAAAǙAȸRAAиRAGA
=AHAɅAA=qAzA
A{A33A\)A˙A˅ApA  AzAA˅A  A=qA(Aʏ\A=qA
=ẠAʸRAAGA33AA(AQA  AA=qA\)A33A{AƸRAŮA
=AffA£A
=A{A
AGA
AAAƏ\Aʏ\A
AAAˮAA˅AQAAffAA
=AGAffA{AzAAHA
=AəAGAŮAA(AAA(Aȏ\AÙA(A33AA\AARAAĸRAAQAAƸRA\)AǅAȏ\AHA
A33AffA\A
=AAffA{AffAAAffAHA
=AApAA\)A\)A(A  AQA  AĸRA=qA{AQAA\)AAQAA  AQARAA(AA=qAGA=qAA  Aď\A\)AAAƏ\AGA
AffAHAGAQAHA(AƣA  AřAQA=qA\)A£A£A{AAAzA  AAHAA{AzAHA
A  A=qAApAA(AQAAîAA£AA£A\)AAAffAAAAGA=qA(AQA
=A33AAA
ApAzAA
=AA
A(A{AAAA{AGA
A{AA\A  AAA\A33A\)A
AA{A
A{AA
AAAARA
A
AffAA\ApAGA
AAQAAAAA\AA(A
=A{AAAA
=AA\A  AAA=qAAGAQARAAGAHA{AffAAzA  AAGA  AzAA(ARA  A
AA{AA\A{AA{AAffARAA{AA
=A=qAffA  A=qAA
AffAApAHA(AAAQApA  A  AffA=qAA(AHAA\ApAffA=qARAAA33A\AGAQA(A  AAHA33AAAAffAzARA
=AAAAAA  A
AA  AAAA
=AARAffARAHAQApApAAzA\)AHAAQA
A(A33AAAAA  A\)AffAA{AQAAAAGAA(AA(AGAA\ApA\AA
=A=qA  AApAAzAARA=qA{A{AA
=A\)AƣAQAǙAď\A{AA  AHA
=AɮAQAʏ\AGAAʸRAɮA(AʸRAͅAGAQAˮAQAAȣAGAȣA(AHAȏ\AA  AHA  A\)A
AʸRApA
=AzAAʏ\AzAffAȣA  AŮAAAzAzA  A=qAɮAǙAAQAffApAAAHAȸRAAAAAʸRAʸRA\)A(AQAȏ\AəA
=A=qAApAAA  A\)A33AA(AA  AHA(AzAGA(A(A=qA(A33Aď\AA(A{A
A(A\)AA
A33Aȏ\AAAzAAʣAAAͅA\)A\)A=qAA=qA=qA(AAAˮAAAGA=qAHApApAQAHAGAHA{AA(AffAA
A
=ApA
=A  AA  AAA\)AAƏ\A33A\)A(AƏ\A{A\)AŮA{ApA
=AAA\)AAAĸRAřA
=Aď\A=qAA=qAzAGA
=AA
AA{AA=qAǙAAƸRAȏ\AzA(ApAQA=qAAǙA=qAəAA
=AɮAzAA33AˮAAQA{AA˙AAͮȀ\A̸RA͙AͅAA̸RAɮA
=AɮA  A\)A=qAAGAGAffAA  AˮA33AApA{AA\)AǙA=qAGAAǙAǙA\)A\)A\)AƣAffA=qA
AŅA\)AHAffAffA=qAřA\)A\)AřAřA\)AGAƣA(A=qAGAHAHAď\AzAģAģAQAřAHAřA
A(A(A(AffA\)AƏ\AǙAǙAǙAQA(A\)A\)AQAģA
=A{A
=AGApAƣA\)AǮAȣA
=AəA
=AʣAȣAAAȏ\AŅAHA  AřAřAA{ApA(A\)AAQA=qAHAApAAffA(AGAɮApẠA(A˅AɮAƏ\AƸRAzAƸRAQAƣA(A{AA  A{A=qAzAȏ\AřAHAAQAÅApAAHA£A{AzAGA\A=qA\)AQAA  AîA\)AģAQA=qA
AA\AGA33AQA
=AŅA
AQAzApA(AffAzAȏ\AzAAA
=AAȏ\AAAȸRAzAHAAA{AzApA
A
AǙA=qA=qA=qAȏ\A33AǙAǅA=qAA{A{AffAA  AzAǮAAƏ\AAǙAA{AGAȏ\A{A=qAffA\)AA(AHAGAŮA(A
A
=AA(AA=qA{ApAGAAȣAȸRAGA33AAȏ\AAAȸRAHA\)A33A  AəAAAffAffAʏ\AQAffAffA=qA
AzAffAGAA(A33AffA33AzAAAHA(A33A\)A{A{A{A  A  AɮAəAʸRA
=A{AGA
=AzAHApAGAzA33AHAAffAȣA33AɮApAffAʏ\AHAʸRAAA{A33A33Aʏ\A33A{AəA=qAȣAzAǅAQAA\)A=qA(A
=AGA
A
A\)ApApAĸRAƸRAQA=qA=qAřA(AffAƏ\AzAzAƸRAƏ\AǮAffAHAAˮAHA  AȣA(AzAǮApAυAQA
AAQA
ApAAGAA=qA=qA͙AͅAGA=qA̸RA\)A
AffȀ\Ȁ\Ȁ\AffAQȀ\A
AAAHA=qAA
=AzAAΏ\ApAA\)AA=qA(A(AGAAȏ\AȸRAAAzAAǙAǅAQA33AA\)AAHA(AƣAGAffAzAGAȣAAGAA{AGAA\)AHAffAƸRAǙA33AǅAAffAȣAɅAffAAȸRAAAˮA˙A˅Ȁ\ẠAͮA=qAA\)A  A=qA{AУA=qAA{A
A33A
=AA
=AϙAffAͮAAffAzAA(AAffAθRAΣAAΏ\AzApA=qAGA  AGA
AAAGA  AGA33A33A33AHA33AͮAA\)A=qA(A(AɮA  AʣA
=AAɮAȏ\AzAʣAAʸRAʸRAA{AHA
=ApA{AffAA
AɅA  A33A
=A
=A(A33A(A(A
AAȸRAAǮAGA
AQA
AˮAAˮAˮA˙AAˮA33A
AȀ\AzApAA
A\)A˅A˙AAʣAA˅AˮAˮAA
AʸRAʣApAAȣA(AȣAȏ\A(A\)AAzApAǮA(AA
=A=qA{AAɅA
AAA=qAQAǙA(AffAGAzAA(A
=AAƏ\AffApAA
A33AřA  A(AA
=ApAA(AAGAApA{A33AQA33AȀ\AA\)AA{AQAΣAAA
=AQȀ\AẠAͅA{AQA
AApA(A=qA͙AzAzAΏ\AffAffAzAθRAHAΏ\AΏ\AffAffA\)A(AAGA
=A˅AzAGAGAA33AͮAffAffA{A=qAʣAQAQAÅAģAȣA\)AHAffA=qAQAA=qApAď\A=qA(A  AzAzAAA33AHAzApAȏ\AzA
=AģAÅA=qA33AAzA
A{AAAȸRAȏ\AA
A(AGAGA
A{AHAHAͮA̸RA  AA(A{AGAͅAͮA(AͅAA  AffAAA(A{AУA(AϙAȀ\AˮAHAəAƏ\A  AǮApA(A=qAĸRAApAAȸRAGAHAAAAʸRAʣA˙AɅA{AAřAřAAApA=qA=qA33AffAƣA(AAA  AŮA33A33AA(A
=A(AzAffAǙAGA
AAQAGAzA\)A
A
=A{AA\)A{A\)AApA
AřAQA\A(A(A(A£AAAA\)AzA¸RAA\)AĸRA\)A=qAǮA=qAzAA{AzAĸRA\)Aď\A\)AAHA
A  AAÙA
=AffAzA  AHA{A
A
A
AQAA=qAA=qAffA(AA¸RA
=AAA{AHAzAGAA\)A  AffAAffAAQAGAAA{A  A
=AGAA  A(A
AQA\A\)AÙA{A=qAzAAA¸RA£AzA(A\)A\A=qAAAAAAĸRAHAA
=AffAŮAA
ApAŅAAA
=A  AAQAQAAAƸRAAA33A
=AA(AîAffA33A¸RA  A(ApA
A\)AģA{A{AAAǙA=qAǮAA{AĸRAÙAApA
AAÅA(A{ApA
=ApAəA
=AffAAAzAzAApAĸRAď\AAď\A  AAzA
=AApA=qA\)AÙAffA{A\)AÅA\)A  AA  AAA=qAA{AQA33AƣAAƏ\AA33AAŅAĸRAĸRAAAƏ\AApAAA(A{A£ApA  ApAffA=qAď\AQA{A(AAA
=AĸRA
=A=qAQAģA\)AƣA=qAQApAŅAAƸRAHAĸRAAģAAĸRAď\AģAHAzAApA(AA  A=qAƣA33AHAǙApAApAAƣAǮAǙAGA  AzAAAA(AQAzAAApA
AAA˙AAAHAʣAʏ\AAQA=qAQA\)AHAGAəAAəAAəAAGA33A33ApAHApAŮAGA(A
A33AǮA{AQAffAŮAAAƸRAĸRAQAîAAÙA  AAřAAÅA=qAQA\AffA
ApAA{AAAQA\)AzAGA\AÅAAGA
=A  AÅAAzAzA
=AƏ\A(AĸRA(A\A=qA{AAAHAîAAÅAA{A  A(AzAď\Aď\Aď\Aď\AffAĸRAA33AA
=AAA{A=qA33AGAAA{A
=AzA
A(AǙAȏ\AHA
=AffAģAģAffAď\AĸRA=qAŮAGAŅAGAA\)AƣApA\)AHA
ApAffA(AzA(A=qA\)AîAď\A=qAQA  A=qA
=AA
=AƏ\AŅAģAffAHApAGAffA{AAHAffA
A  A(AHAGA(A\)AAA
AzAʏ\A=qAɮAɮAffAAA33AˮAʣA\)AzAʸRAA
=A33AɮApA˅A\)A
AffA\)ẠA  Ȁ\AffAA\)ApA͙A̸RAQAȏ\A˙A\)AA
AffAGȀ\ApAAȏ\A=qAHAA
=AzAA  AɮAʸRA33AʣAɅAəA  A(Aȏ\AGAȣA=qAAGA\)A
=AA=qAGAŅAřAA
AAď\AAď\AĸRAAQAŅAzA
=Aď\AĸRA{A=qAď\AĸRAQAAQAŮA{AŮAzAřAApA\)AAAŮAHA¸RA{AQAAA(AƸRA¸RAřAŅA=qA(ApAffA  AA£AAď\AffAHA\)AA\AQA{A  A=qAAQAQA\)AǅAģAÙA{A
=A\)AHAAHA  AîAƸRA33AǅAAAÅA  AAĸRAQAď\ApAffA33AAApAÙA  AŅAģA  A  AǮAAÅA\)AAģAď\A  A  AƏ\A(ApApAA
=AģA
=AAģA(AA
AřAAA=qAîAAAAAA\)AAAQAzA
AffA\)A33AAAGAAHAAQA
=AffAQA=qAQAAAAHAQAAA=qA
AA(A  AffAHAAzA{AA{AHAHA(AAA\A33ARA(A\)AzA\)AA\A33AA=qAHAzAAApA(A33AAA  AzA33A  ApA(AAA  A  ApA{A
AAA{A\)AARAA  A{AffA
A{AAA
=AffAAARA(A
=A\AffA=qA\AHAA  A\AA=qA33AzA£AzAAĸRAffA=qA  A(A33AAQAApA(ApA(A{A=qAAAÙAģAģA\)A{AA(AAGAQAzAzA=qAAQA\AffA(AHAGAAzA33A  A
AHAAAAA  AGA
AA  AAA\)AQAA  A£A
AAAHAAAA
=AHAffAHAGAARA{AA=qA\)AAAîA¸RAA  AAA33AĸRA\A\)A\AGAřAAAffAQAƸRAƸRA{A=qA33AQAAAȸRAȸRAQAǙA(A33A33AA{AApA(ApA\AƏ\A{A
=A{A  A(ApA{AA
=AffAA
AffAHAGA\)AApA33A=qAAAAA33AAAAHAGApAA
AA
AA\)ApA\)AAA{AGA  A\)A
=A\)AzA=qAAAQApAHAAHAAAAAAzAAģA=qA(AARAHAA\AAzApA
=AAAA
A{AAAA\ApAAffA(AAAGApAQAAA\)AffAzAAA¸RAAA(AAApAA=qAÅA
=A£A(AAzA
ARAA{A\A
=A{AGAA
=AAffAzAAQA=qAAAAAA\ARA
=A
=A=qA\)ApA  A
=AAzAQAA(AQAAA\)ApA
=A£A33AÅAAÙAzAffAQAQA
A
=AA
=A=qAA=qAApAARAGA  AA\)A\AģAģA33AAHA(AHAAAHA=qAA{AAHA¸RAAApA
=AGAQAAA=qAA\)A  A\)AHAHAffAzAAffA33AA\)AApAQAA=qAAHAARARA=qAAGAA{A{AAAHA(AAHA
=AzA
=A¸RA¸RApAzA\)AGA
AzA  AzA33A{AHAQA  ApAA
=AGAAffA\)AffAAApA  AffA33A{A
=A=qA
=A33A33AA
A
=AHAAAHA  A=qAzAzAA\A{A  A
A£AHA
=AzAAAAAzApAGA=qAAHAQAA  AAA(AAAHA{A\)AÙAÙAAQA{A{A
A=qAHARAzAAzA
=AHAHARAffA(AA33AA(AffA
ApAARAffAAAzA(A
AAAHAA=qAQA{AzAA(AA\AAQA(AHA  AzAA  AA
=ApAHA{A  A(AAARARAA\)A
=A(AQA33ARA33A\A(AAAffAzA
=AA=qA\)A\A=qAAAAAAQAAA{AzAQAAAAA\A=qA=qA(A
=AA{AQAAAQAQAAAzAApAApA{AAApA{A{A=qAA\)A  AAA{AAHA(ApA
=A  A33AA
A\AA\)AAAAHA(A\AAAGAApA
AAAAHAA
A
A
AzAA{AAffAzAzAAA{A=qAQAA
=AAGAAApA=qA=qAA(AffAAHAHA
AHA\)A33ARA  A
=A
AARAAAQAAHAHAAffAA(ARAAAAQAA
AA
=A\)A{A{ARAA=qAARA\AA33AAzA
AAA=qA=qAA=qA=qAA=qAAAA\ARAA\)A(AA  AARAA\)AAQAA
A\AA(A
AA\)AzAAAARAAA\AA(A(A33A=qAAHAGAHAzAAQAA
AA=qAAAA33AAA\)AffAHA33AQApARAAzAffA{ApAA
=AA\)AQAA
AAA33A\)A\)AGA\A33AAAAApAzApAA\)AAAA\A{AA33AffAAGAA  AA
ARA  A\AHAA=qA  AARAHA33A\)AAzA\AAffAAzA\)AQAHA  A\)AAHApA=qAffAA\A\)AGA
=A\)AAA
A=qAAAA=qA
=A
=A(A(AQAGA  A
AzAzAA\)ApAAAzA33A33AffAzA(ARAApAAzAzAAAAARAGAAA=qA
=AGA
AGAQA(AAAA{ARA
AzAA
=A  AAA(AApAAA{A\)A(A
=A\AAGA33A{AA
=AA
AAA\)AAA
AAQA{A\ARA  AHAGA\AffA
=AARA33AA=qA  AAQA{A  A=qA  AAzA{AGA
=AAGAAzAAA33AA(A33AAGAffA33AA\)AzA\A(AAffA
AAQAA=qA\)AAAzA  A(A
=AGAAApA
=AAApA\)AAGAA=qA\)AAARAA\A
A=qA{AzAA{AAGAAzAQApAA(A
=A  A=qA
A\A\AApA\AHA  AA33AAAAAAA(AGAHAAAAA
AA33AA  AA
=A\A33AHARAQAGAA\)AGAAffA=qA{A=qAGA\AffAAzAA  AGA=qAA\AApA=qAffAAAApAzA
=A{AA
A33AA\AA
A(AHA33A
A(AAAHAzA{AffAHA33A=qA  AA\)AffA
=ARA
=AffA\ARA33AA
AAA(A33A
A=qA  A
A
AffA(A33AAÅAAHAAHAApApAGAA(AÙA33AA33ARAHApAAAHAAAA33A  AAHAAAzA\AA  AA  A  AzAzAQAA33AA  AAHAApAAA  AA(A{AARA\)A
A{A\A
=A
=AA
AAA
AGA{A33A{A¸RA£AA33AÅAÅAzAÙA{AA
=A(A¸RAÙA\)AzAŅA=qAŅAGA
AAHAAQA\)AřAGAQA(A=qAAQAAƣAƏ\AAĸRAîA£AÙA(A¸RAÅAŅAGA(AÙAAzA
=AHAzAApAHAA(AHAzA\AAA(AGA\AA(A(AA{AA33AAAA\)AAAA=qApAARAffA
AA=qA33A
AAffAAA\AA33AAHAA  A  A=qA
=AAAAzApAGAA\AQA
A
=AffA=qA
=A(A
=A\)AQAAffAAHAAřAA  AA33AAffA
=A  AGA
=AGA=qA33AA=qA=qAAGA=qAAA
=AAARAHAQA
AA\AAffAAA  AApAAA£ARA33AQA
=AAAAA
AAQA
AA\AA33A  AAzAffAffApAAAAA\AA
A\)A
=A\)AzA=qARAA\ARAGA
A(AA\)A(A  AAď\ApAA=qAA{ARAA{A{ARAApAHAAQA\)AAA
=AHARA33AAApAHAApAQA\AA{A
=A33AffA{AAAA\AHAA\A
A{A(A¸RAA=qApA=qAAA=qA33A  Aȏ\ApA(A{AGAffAAȏ\AA
AɮAHApAǅAzAAƸRAȣA
AAəA\)AȣAHAAGAA{AGAƏ\A
AQAA=qAAA33A\)AHAȏ\Aȏ\A
=AzAAQAď\A  AffAApA
A\)AQAQA¸RA\)A  AARA=qAHA{AAffA
AAAA\)AGA
AAzAA{AA=qA{A33A{AGApA=qAAAGAAQAA\AƏ\A
=ApA33AQA£A(A  A(AA
=A
AAApAAQA  AA
AARA{A33AA
=ARAGAAHAAQAîAGAGAQA
A=qAQAffA  AAAQAîA£A=qAA
=AQAAzAffApA\)AAAAGAQA33A\)AÅA{AA(A\AQAzA
=AGA{AAA  AHAAQA33A  AAAAARAzAAHARAA\)AGA=qAA(AHAGApAÅA
A=qA{AQAď\A
AŮAGAGA
AA33A33AHAGApAGAĸRA
AÙApA¸RA
AffA\AzARAAQAÅAHAAģA33AAA\)AAAffA33AGA{A
A{A(AA
AARA\)AQARA(AAA{AHA33AA(A(A{AQAGApAffAzA\)A(A
=AA{AAA=qAAzAAHAAGAHApAA  AAGAA¸RAîA{A  AQAffAQA(A  A=qA£AffAAA£A¸RAA=qApAGAA=qA£AA£AzA(A\)AQAAƏ\AřAřAŅA=qAQAAģAAAAHAffAAffAĸRAAffAQAzA=qA=qA
AAŮA  AA{AffAƏ\AŮA\A{AA  AAA¸RA¸RA
=A=qAAÅA=qA¸RA\A\)A  AA\)A\)AřA  AA=qAƏ\AA33AAAƏ\AƏ\A(A\)AəAʏ\A{AɅA  AəAGApAǅAǮAQAǮAAǮAA
=A
=A33AAHAzAAA
=A33AQAƏ\AAǮAHA{AzAŮAAAƸRAǅAɅA{AAƏ\AǅApAƏ\A(ApAHA  AA(Aď\AƣAAffAÅAĸRApApA£AAHAQAA\)AAÅApA
=A\)A  AAAApAzAffA
AffAA\AŅAA
AA=qA  A¸RAÅAGAAzA£AA=qAÙAď\AQAĸRAģAffAAŅA\)AAAHAAAAGA  A=qAzA(AŮAApAřA=qA  AÙA
=A\)ApAAŅAAď\AŅAď\AffAffA
=A{A{AA
A{AffAQAAzA¸RAffA
AA£AAHAA  ARAAA33AAA
ApAÅAAAAHA\)A=qAQAAAAHA=qAAGAAA\AApAAA33A
A
=AAA\)AAffAHAApA{ApA
A  AGA(ARA\AA33ARAHA\AGAAHA\A33A=qAA\)A  A33AHAHARA=qA
=A  A(AAffA33A  A¸RA\AAA\A
AQA=qAQA  AGA33AA
A  AA£A33AA=qAzApA  A  A{A
A
AA¸RA{AGA(AQA(AHAHA\)AA{A\AffA
A¸RAAA(ARA33AAA=qAAA\)AA{AffAA\AffAQApARA33AGA
A{AHAAAQAAHAHAAA{AAHAzA{A(A{AQA{AGA=qAAAffAAARAAAzAffAffA=qAARAAGAA(A
=AAzA{A
=A
A=qAA
AARA=qAffA\A=qAAA\AA
A  AAA\AzA
=AAAAA33AffAA\A\AAAQAA
=A\)AA\)AAAAAQA=qA
A=qAffAAAAffAA  AQApAÅAAAAHA\)AAApAîA
=AAffAffA33ApAA
=AAffAAAAAA
=ApApAQAHA
=A\A33AAAARAHAAHA33AffAA\AAAA  AQAAA=qA\)AA
=A33AAA\)AÙAÙA
A=qAAGAģAîAA
A=qAǮAʣAzA{AAAffA=qApA\)A=qAƸRAAAQA
=A{AAģAA=qAAA
AffA33AȣA(A33AĸRApA(A(A\)AHAHAApAzAAzAHAAAAA
=AHA33AAGA\)A\AAGAAHAQAHAA\AAAAQAAA=qA(A{A£A  A(A  A=qA¸RAAÅA\)ApApAAApA\)A£A£AApAA
=ApAřAřAřAGAģA\)ApAHAAď\A=qApA£AAAAAGA33AAA=qA£A(AĸRAffA\)A33A33AzAÅA
A{A\A£AAA  A
=A¸RAA  A
=A¸RAApAGAGA33A33A(A{A
=AA\)A
=A\)A\A
AA
A(AQAHA
=AQARAARAzAA  A{A(A(A=qA\)AAA(A\A
A=qA  AffAAÅAÙAAffAGAA(AAAA=qAAA(AzAGAA  AzAAffA=qAÙApAffA  AAHAAAA(AAď\AQAHA\AA
ApAAA\AzAAA\)AAAAA=qAA\ARA\)A33A
AAA33A  AA33AffA
A
=A=qAAAHA
AA£A33A(A\AAQAAzAzAzAAAHA33AHAAGA  AA(A
=A=qApAAAzA\)A(A  AzA(A33AA33AAģApA33AŅAƏ\AŅAzAď\AQA=qAGA  A{Aď\AQA  A  A(AŅAÙAAÅA¸RAAAA  A(A(AzA{AAAAAAA{ApA
=AĸRAĸRAzAHA
AA(A(AQA
ApA(A
A
AA\)AA(A\)AAAHA(ApA£AffAAAA33AAzAGAARA33A33AGAAGAA
A=qA
=AAHAffApAGAzAGA
AA
=AAQAApA=qAA{A
=A\AA\AAAA\)A  AffA¸RAzA
A{AzAzA
=AAzA
A33AA(AAzAQAGAA\)AAA(AAAAAA\A\AGAHAA(AHAApAAffA=qAA{AAA{AAffAAAAģAÙA33A  A\AAAHA33ApAGAHAAAA=qAAHAffARAA{AAHApA  AAA{AzAQAA  AA
=AAHAA=qAA(A(AAAzAzAGAA(A\AAA(AQA
=AAAHAAARAAAzARA\)AGA\AA{AA{AffAQA\ARA(AA
AA33ARAAzApAAAAffAQAAAAQAQAA
=AA33AQAAzA
AAAzAAGAQAAQA  AQAA
AA  A\A=qAAHAA33A\A  ApAQA  AHAQAAApAA
=ApAHAGAARA{A(AzAAAzAffAAAAzA(AApAAffA(A(AffA{AARA\A
AA
=A
A(AARA\AQA
=A\)A\)AAffA\AQAGApAffARA
AAA=qA  A=qA(AAAffAAzA33A
A=qAffApA33A{AHAAA=qAHA  A  A\A=qARA\)A(ApAÙA=qA
=AQA\)A=qA\)AAzA  A
AÅAAQAQAA33AGA  A=qA
A\)AffAzApA
A
=AA=qA33AARAAGA\AA{AffAA(AA\)AAAA(A(AAAA(AA  A\A(A=qAA\)A\)AGAA=qAGA  A(AÙAA{A{AA=qAřAĸRAA\)AģA  AAGA=qA
=AAAHAQAffA33AzA{AAA{A=qAA=qAA\)AffAAAzAAHA\A(A  A
A
AQA
=A=qAHA
=A{A
=AAAApAAHAHA{AzApAAQAApAA33A\AAA{AA\A(AApAAHApAffAAQAARARA
=AApAffApAffAAGAAAHARA
AGAA\ARA\AA33A33AApAARA=qAAffAffA
A\A(A{ApAAAffA(AA\)AQARAQAApA
AAGAffAHAARA\)AAAÅA¸RAAÙA  A{AffApAA=qA{AAHA
ARA33ARA
=ApAQApAQA33A\AAAAAA=qAGA
=A=qA=qA{AQA
=AA\)A\)AzA\)A(A
=A
AHAA\A=qA(AAffAffAA
=A
A{A{A
A  A
AAA
=AAffAHA33AAGAQA
AAAGAzA33A{AGAAHAA(A£Aff>>>======Gy ==Q=Q=
=
=
=
=
=
=
=
=\)=\)=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=Q===G=G=G=G=G=G=G=G=G=G=G=G=G=G=G=G=G===G>#
>>#
A33A33AffA\)A  A
y AffAAy AAA33AAAA
=AA(AGAA
A
AffAAA  A{BA  B33ApA\)AffA  AABB (A{A
=A
AA  AA{A\A
=A\A
A=qA(AQAGA(A(A
=AAQy ApAAHA\AAAA
=AAHA=qA
=A
=A\)ApAApA
AHAGAޣA=qA
AA  AAA=qAHApAAAffAQA\)AHA(A33BARB 33BB=qB
BAffy AAApAAHAAGAffA  AAAHAA
=A{AAAffA(A
AAHAffB B\)A\)BB AA(AAAAAAAA=qAHAA  AAAAzAAffA\ApAAARAA
AAA{A\A\AA33AAAffARA=qAAzA
=AA=qAQAGAHAAA
AAA{AffAA
AA33AQA
=AA
A  AAAA
=AAffApA\AAAHAAAAQA{AAA{AAQAA\)A{AAA
=AzAA33AAA=qAAA33AQAzA33A
=A\ApAffAGARAA33A\AAQAffAHA(AQA{AffAARA陚A(AffApA\)A{AA(AAA
AHA\)AzA=qAffAA{AA{ARAGApA33A(BAzA33AAGA  AAGB ffBffBQB =qAA\)A\A\)y AQABGBBGAAA\)AAQA
AGARAARAHApy y     y y A\)AAHApAzAAffB (ApB
=AffA33AB BffB(BB33BBHB  B B
=AB {B zB\B
B
=B
=BQAHB
=ABzABA
AAA{AARAAAzB\)BzBB{BzB\B=qBA
AHAA\)A=qA33AA(AAAffAffAzA\)AAQAA=qA(AAHA=qA33AAAAAAAAzAffAAA
AffB GAAAARAzA\A
=AQBB\)BffBBRBBBBffBBHB(BBB{BBBGBGBBB{B=qBzBB ABHB{AAAQA\AAA  A
=AzAARAAABffABffBAB BzBB GB AAA(A\AA
=AAAA=qA(AQA(AAAHA  AAAQA\)AA
=AzAA
A=qAQA{AA33AARA\AQA33A(A
AAffA=qAAy B(BR@\)y AAA
=AAGA\A׽A\        B  B

=B	
B  ?xQBB zA33A(A33A33AGAAAApAQB 
=AApA=qA(A{AzAAzA\AHAHA{AA  AAAARAA  A{A
=A{B=qB ffB  AGBB(BBzB{B
=B
=BBBB\)BB(BffBBBBBpBH>B
y @GLB	  @AAQA      A(A\A>LAAAAAAAAAQAy AGA
=>y Ay B@(A\A{AGA
=B  y y B RAGA
AAGA
A
BA  BBffAffA33AAA\)AA\A
AA
=AApA=qAARAzA=qAAzApAARA
=AGA
A\A{AQA\BB{B	QBBBBBB33B  BAffBB  B GBBRBBBHBBB
B HBHB(A\)AA{AGAzARA=qAQAA
=AHAB AA
AGAA\A(AHAHAA{A=qAA=qAAffB B B  BzBQB(BffB33ARA
=A{ARAAffAA
A
=AAAQA
A\)A\)A(A뙚AA
AHA\AGA\A\)A=qA
=A=qARAAApAzAA
A=qA  A(AAAAA\AB 
ApA\AA=qAGAAA33AAAARAA(AAzB  BRB(B{BBGBBBB=qBB33BffABGBA33A
ARA\)AffARAAffAA
A\AffApA\)AAQA
A33A=qAzARA
=A  A\)AGAAffAAGA33AAAAARAA33A  A\AzAAA
A{AAzARARA{A33AA  AAHA
=AA\)A
=AA\)AQAAA\)AffA(AHAA=qA{A33AB BBB33B\B  BBHBBBBBpB GB \B B=qBQB
=BB (AHAAARApAAAffAQA=qA(A33A\A(B B 
AA{A=qAAA{B BBffB\BHBBB  BGBQB  B\)BRB BBB\)AB B A33AzAARAAGA
A\AA{AHA\)ARAAQAffA  AB \A{AHB B=qABRB(BBB\BA\)AAAzAffAB pB RB BB (BGBB{BpBzB
=B33BpB33B\)BzBBHBQB\B
B{BpBB
BRB{B\)BpBB33ApB33AA33BBB{B33B zB{BzBBA33AAA\ABBB(BzBBQB =qB B A\)A\)ARAA\)AzAA33AApB B
=BpBQB\BRB
=BAAHB RB=qBzBHB  B{BB33BGB(BB{B{B\)BpB{BBBB
B\)BQB QB ffBGA
AA\ARApB(B
A
BBB(B33BpB=qAzAA33A  ARAzA\AzAAffAAffAGA\)A
AAApAA
=B GB\)BB
=BQBB  BpB\BBB\BBB33BRBBHB33BB\)BB  BBB
B=qB AAzA߮A{A33A=qA݅A{ARAApAA\)AzAA33AGA
A=qAzAHA=qA\)AAAA  AAffAAAQA33AAA{AAAGAAzA33AA\)AGAApARA
=AAQA\)A33AA(A(AA33ApAA
AAA(A\A\AAHAQAAAA\AAAApAGAA
AQA
=AAمAA  ApA{A  AAۮA=qA\)AffA(A33A֏\AQAA=qA(AA
=AAمAݮA(AffAÅA߮A  AA\AffAGApARAAAQAzA33A  A  AHA=qA
=ARA  AGAA
AHA
AQAA
AAAffA\)AHA\)AA홚AAA\)B {A33A(A\A  A\)AB B 33B (AQAGA33AzAAQAAffAGA{AARA33A
A33A\A=qA{AHA=qA
A
=AAAHA=qApA{A
AQA\)AQARAAAzAAzAHAA
=AffB=qA=qAAARAA=qAAA33ARAARAAB33B  B   B =qAAAzAAzAffAQA
=AffA=qA
=AA=qA=qB BBB{BHB 
B33BHBB
B(B
BBB\ApABABB BGAGB =qB B{BB{B 33A
AA\AHAA
=A(A
ARA
=AA
=A
=A  A\AGAA(A=qAHAGA
A=qAA(AAA(AAAA33A癚A33AAAAQAA(A\A뙚AffA33A=qA(A(A{B (B B
B\)AA33AAzAHARA
A=qA{A\A(A{A  AAA33A  AAAAffAAA
AA\)A=qAA\)A=qA\)A{A
A\AAAAA\)AA
=AAAAHAAAA
A{A陚AA(A(AHA\)A=qA
AzAApAApA
A33ApAAAzAA{ARAAA  A33AAA33AAAA\AGA33AAzAGA\AQAAAAQAAA=qA33AzAAA(A
AAApAApAHAA  AA(AzAAApA\A33AA{AApAB BBRBGBzB
=B\)BzBffA
B  B B   B ffB
=B{B\)BpBA\B   AA=qA{AAAAGAApA33AQApAAQAAApAGA33AGApAA  AAA
=A(AffAzAGAB{B HA{B
BHBB=qA=qBpB(B33B
=BffBpB
=BBGBBGB =qBBffBB(BGBBBQB\B=qBBB=qB 
B B (A
ApB B \A{B \)AB zA33A33B QBBBHBBBRB{BBHB\)BBB{BRBHBffBQA=qAB
=B =qAARAAGAAAAApA
A=qA
A{A  A
A=qA33A{ARAGARA
A
=A{AQAA
AAAAQB A  ApB   AAA
=B(BB\)BB{BB{BB\B=qB\BHBBB(BHBB	(B	(BBffB
B
B	33B	ffB	\B	B	
B	
B	B	HB	B	ffBBQB
BpB(B(BGB{B=qBB 33BGAGAA\)AA(AHAGAA\)A(A(AzA33A(AGAAA  AffA{A(AGAffA
=B B 
B \A{AAQAffAB(B B AHA(AHAA
=A{A
=A33ABBHBBAA33ARApAAA\)A
ApAzA
AA=qAHA=qA\AzAAA(A\)A\AA
AGAAGAQA{AA  A  AffA{AffA33A\AAA=qAAGA(AB RB{B(B B33BpB
B\BHB QApB RB AAA{AGAAA  AA
=AAHAA=qAHAGAA\)A33A(AAHAQAAAQA\)A
AzA\)AAzARAAffA\)AA  A\AffAA\)A33AAHAAݙA\)AAمAQAAffAAffAHApA\)A
A
=A\A(A=qA\)AGARApAzAGB(B\BRBBBHB{B  BAB\AzA
=A  A
=A{A  AGAۙAAAffA=qAA{A  AHA
=AffAHAA홚AAAGA{AAQAzAGAA(A
AAGA{ApA  A
AQA\)AۮA\)AأA33AظRA  A׮Aҏ\A\)AϮAͮA
=AGAGA
=ApAffAA{AA{A33AffAQARAAA(A(A  AffAAAAffAGA܏\ARA
=AAA33ARAffARAڏ\A{AAA\)A=qA=qA  AAAGAA
AffAQA
A
A\)AAApA{A33AQA(AA(AHAffA
=AAAAA=qA  AA
=AA=qAәAAAA\)A(AffA(ARA33AA33AAAA{A
AAƣAAԏ\AܣAzAȣAQAffAA噚AGA\)AA33AGA(A{AzA(A
=AQAGAzAڸRA\A{AApA\)A\)AAAGAAԣA֣A33AܸRA
A
AAffA
=AA\)AA{A\)AffA=qApAffApAAAAAffA=qAQAAA׮AA\)AHAߙAQAAظRAۅA
A
AzA
A
AA
A
=AA{AzAAApA=qAffA
=Aޏ\AAAAAA33AأAA
=AAA(A癚A\)A
=AGAׅAffAzAAAAAυAzAΣAՙA\)AۅA33A=qA
=ApA{AffAܣAHAffAᙚAAHAAHAApA\AAARAffA
=AAzA(A
=A
=AᙚA(A=qA㙚AA=qAA
=AQA33AARAA\)AAQAQA(AA\)AA
AA
A
=A
=AQA\)AHA=qAA
=A  A
=AGApAۮAA
=ARA
A\AA33AAᙚA\AQA
AQA=qAAAHA\)AHA\)AQA(A{ARAAGAA\)AAGAQApAA(AGAAAHA
ARAHAAffAA33A
=A=qA=qA\)A  AzAAGA{AzA33AAffA
AffAA{A\)A{A{AA(AGAAGA\)A=qAA(A{A
AA33AAA\)AAApAA홚AAAQAffA=qAQARA33A\AHA(AAAzAA=qA\)A
=AffAA
AABBffBpB\)BQA\A\)AQA(A
AAAQAAARA{BffAAzAAGAHAApA\AQA  AAGAA
A{AAQA
A\)A\)AA{AAGA\A\)ARAQAAzAA{A  B=qB
B\BBBQBHBARB \)B ffAQA=qA(ABQB
=B
=BzBGB\)B\B
=B=qBffBBRBGB{AffA{AzA=qAAAAQAAGA
AABHAB 
=BB33BBzBAA(B AA
A
=A
AAAHA=qAAAAHAAA(AGA
AA
=A  AGAAGAAAHAGAffA\)AA33AApB QAB ffB  AB B33AB GA(AQA  AAHAAQAGAGBB{B(B33BB pB AffAA\A=qAApAAA\)AffAQA\AGAAA\)A  AA  ApAA
ApA
AQAA=qAA33AAQAAA홚AzAA\)AAAAA=qAQAzA
=ApAQApA  AAAHAGApAffARAffAAB=qAAAAAGA\)A
AAGA(BffB ABpBB{B  BBBRB \ABB B HB
B BB \B BBRB pB B zAGARA\)ApAQAAffA
=ARAQAA\AzARAHAHAffAffAQAA
=A  A  AAQAA\)AffA(A=qA\)ApA{A=qA
=A=qApA\)B =qB
=A\)B B
=B{B
BpBBGApB 
=A\)AGARAQB \AffAAGAHAffAARAA=qAA\ARAAzAffB GB\B\)B 
=B QA
A\A
=A33AQA
=BHB B B\B B
=B B RB {B B B (AAzAAAAAzAA\)A33AAA  A33A{A\A
A=qAHAzAzAffARA
AAA
AA{ApAffApA{AzAHAA33A癚A=qA{AA{AAAA=qAAQAffAA
=AzA=qAAA
AQARAAffA(A
A\AzAQAA
=AB AAAARAB\)A(B AB RB 33B33B
=A
ARA
AffAzA\A\AA33AApA
AA=qA33AAA\)A\AQA33AApAQAAAAAffA=qARAA33A\)AQAA\)A=qAffAA=qAA\)AAAAQApAAARA\AAQA\AzApAAGAHAA
=AzAAAA
A{A
AGARAzA{ApAARAGA  AGA\)A  AffA
A
=AAAffAAAA\)A=qAQAGA
AAA\ARAffA(AAA\)AzA  A
=AAAAffA=qARAGAA{AffAAA33AAAAAA33AQA\)A(AGAAHAAA33AffAHAAAA(AA\)AARAzA
AHA33AHA
A=qAzA\)A\)AQA(AB   B B HB
B \B=qAAAAB GA
=AApAAGAQAGA\)A(ARAAzA\)A
=A
A
=A(A
=AHA33AAAAAA(AAAQApAA33A\AzA=qAAAAzApAAffAzA=qAAAA  A
=A\)AHApA{AAffA
=AffAA{A33AAQAAQARA\)A  AAGAHAAAAAA
AzA=qAAHAAA(B
=ABBA\A=qA  A{A{ARAAHBBzBBBBffB\BB\)B
=BGBffBHB(BBB(BQB(BBBB(BBpB  BHBB ARB pB 
=AffA{A  AA=qAAAQARARAQAAffAA(A\)AAA
ApAAA33ARA
=AzAAAA
=AGA  A
=AHAffAffAA
A  AAB pB 33B AzB33B  A(B   AB {AzAAAA\B QB
=A(B 
B 
BB
=B BAB B ffA
AAffA\)AA33AAffA(ApA(A  AA33B   B (B 33BBA
=ABBHBGBB=qBAGBBB33BB{B =qAAA33A=qAAAffB A33AA=qAGA
AAAGAA\AQAARA\A{A
=AAGAA\)A
=AAHAQARA
=AAAARAApARAA\ARAAB \)B 33AAzAAzAAAAffA=qAA(AB {B HA{AA33AGApAAA{ARAA33AARA
A
=A(AffARAAA33A
=A33AHAAA\)A\AffA
=AAGAzA{A{AQARAAAAffAAA33AzA33AAA(ARA{A  AAzA\A33A\A33AAA
A
=ARAAHAAA
=A뙚ARA(AApApAAAA
A
=B B AA
A  AHAAAAHAQAAAAAA\)ARAQAARAffApAAA{AAA\)A{ApApARAA  AffA\A
=AA=qARA\A(AA33A\A\)A\)ApAAGA=qApA\)AAffAAAGA=qAAGA\ApA  AffA\)AA33A뙚A(AA홚ARAAAAQAApAHA
AARAAGAAAffAAQAQAHAzA{A  AAA(A
AA\A(AB \AHA=qA
ARA{AAffAHB  B ffAAA\AAAAA(ApAHAffAAGA  AAAApAAA=qAffA(AHAHAA33AAffAA
AAHARAffA=qAA\ApA=qA(A陚A=qAffA
=AA(AAGAAzAA\AA33A
B (B QB ffB pB B \B B B \)A
=A(AQA\)A
=A
=AA=qA
=A\AffAAA=qAHB 
=B   B B {B =qBpB ffB QBBB
B\B{A
=AQAB pB B(BQB  B B GB B B 
B
BB\B{BBpB
=BffB=qBBBB{B(B{BB{B
=B(B 
BB
BRBB
=BBB
B \)AAGAQAA\AAB (B{BB=qBA=qAffAAAA
A(AHAAGAB {B 33B zB \B AAA\ApA=qAzA
A  A(AA33AHARAHA  AHA
B {B B 
B
=BBHB=qB\)BffB\BRB  BB{B QB\)B B\B B 
B 
B{B \B QB BGBRAB RBB QAAHAGB =qB  AAA(AAGAQA
=ABB BB ffB GB \A
=AAffAB   B =qB \B B  B{B33B=qB RB {B B
=B 
B 
B B HB B (A33A=qA=qAAA
AzARAQAA
=AAAA{ARAzAA\AA=qAAA\AGA  AAA\)B GB pB =qA
A33AffA
=AffAA(AA
AHA\AAA=qAffA
=AAA\ARAAffA33AAzA
=AQA  AQA33A33AA\)AHA
=AHAHAA(A(A\)A\)AA
AzA{AHAAAGA33AAQAQA{A{A
A33AzAA
=AzA=qAQA{A(AA
AAAGA  AHAAA33ApA
=A{A{A33A{A(A=qAAՙA
A  AHA33AAA{AA{A(AAAAA(AAzAA
A\)AAzA33AAޏ\A33A
AA߮ARA{AffAffAGA
=A(AᙚAAA\)AApA
=A\AݮAA
=A
=A(AGAHAA33A\)AՙAA
=AAAffA33A=qAzAHAߙA(AܣAAݙAHA{A  A\)AHA{AȣAzApApAəAQAGA
AƣAAA(A£ARAffA\)AAAȸRA֏\A  AA
=A
=A¸RAθRAϮAAƏ\A
=A\A
=AQAzAĸRApAA\)AA\)A{AģAÙAAA
AHAA
A33A{A
AϮA
=A  A˙AǙAHAAGA(A(AffA
=ApAA
A{AAA
=AA=qA33AffA{A(AģAAGAA(A(AA(AǮAGAA֏\A33A݅AӮAˮAHAиRAAAAәApA׮AׅA33A
=AՅA  A
A{A؏\A
AA
=AAffApAA
=AAAffA(A\)AA
=A߅A
AQAGA\AA\A癚AAzAA㙚A(A㙚A
=AffAzARA=qAHAڸRAQAzApA\)A(AAQAAHA噚AA  AAۮA
=ApAHApAGAHAQAʣAGA\)A=qA33A
=AzAHA  A{A  A=qApAAzA=qAʸRAƸRAA{AϙAЏ\AAיA(ApA
=AGAA
AͮAAمAQAܸRA
AA(AQAApAAA{Ȁ\A33Aȏ\A(AAϙA\)AυAAԣAΣAHA=qAAQApAffApAHAzA\)A
A  A  AHApAиRAA
A33AљAffAיAAڸRAAGA33AzAffAɮAՙAͮAffAAzA
=A
=AѮAָRA֣A\)AAAѮAхAٙAA
=AمApApAAHA\)AָRAAиRAָRAٮAAAΏ\A
AA
A߮A  AARA
AᙚAٮAޣAAA  A\A{AGA  AffA
AzAAAAᙚA=qAA
=AAAᙚA33A߅ApApAܣA  AAGAAA
=AAQAۙAzAۅAۅA߮AzAڏ\A\)AffA
=AAzA޸RApAAHA߮AAGA\)AGAHAߙA
=AAAffA\)AzAA
A
=A{A\)A  AzA홚AAzA  A
A(A\)AAGApAQA33A
=AٙA{A뙚AzAA(A  A
=A\AAA  A=qAzAAAA(A陚AApA
=A=qAGA癚AA33A
=AA\AHAA(A(AHAApAQA(AzAHA
AAA{A  AAGA\)A
A\)AAA
A  AzA\AHApAA=qA=qAffAAffA  A  A{A\AA陚A(A\)AHAA=qApApAA33ARA{A
A{A
AGAAQAzA  A{AAA{AAA噚A\A\)A
ApApAARA
AAAAAA
=AAA
A33A
=AA
=AA\A{AGAAApAA\ARA
A
AffAAffA
=ApA
=AA\)A\)A33A
=ARAA33AA  AzAHApA{AA
=A(A
=A(A  A\)A
=A=qAAARAffAAGAAffAA\)A\AAGAAAA(AffAߙA{AffAA\)ARAAA\)AAAAGA
A뙚AffAA33A
=AzA\AQA\)A
A=qA{A=qAzAHA(A  AGA\A=qA
AA
AܸRA=qA(AHAAQA=qA
A  A
AQAffA(Aڏ\AApA(AffA  A  Aԏ\AՅAA{A=qA֣AA\)ApA{AzAָRAHAHAׅA{A؏\AGA=qA  AAAAAffA˅A=qA\)AAA33A
AAA  AA=qA  A=qAGA(ApA=qAAGAA  AAA33AAңAЏ\AHAGAffA33A
AřAQA˙A  AAzAʣAȸRAA
=A{A
ApA\)AQA
A\)AAGA\)A
=A{AffAffAA(A  A  AQA{ApAAHA  A\)AAңAA
AHA{AQA
=ARAAǮAǮA{AQAA
A{A݅A\AAAGAQAA{A
=A\)A=qAffA{AHAQA㙚A
=AA  AA\)AA\)A33AAAQA(A׮A{A
=A(AffAA
=AޣAGAzA33AA(AܣA=qA33AٮAA33A(AzApAծA֣A{ApAָRAAHAQA
=A{AA
A
=AAApA
A
ApA{AA㙚AAA(A  ApAzAQAA=qAAAzAzAzAGA(A
=AGA\)AA  AAA=qA\A33AAQAApAHAGAAzAA\)ApAGA{AAzAA33AA{AAAAzA
=A\)AffAޣA{A
=AA{AARA
AzAAA㙚A(A\)AAffA(A{AᙚAffApA(ARApA33A=qAAHAA{AAٮA\)A(A{AхA
=AGA֣A{AffA=qA޸RAޣA\)A\ApA33AAHAGAHAQAAʸRA{AϮAAأA(AHAݙA=qAA\)A=qAzA=qA߮A(A
=A\AQA߅A\)A
A\)AA噚AAAA33A(A\)AffA33AAA
=AzA
=A  A\)AAGA(AHAۅA(AڣApAAA
AA=qA{AAGAzA=qApAAzA\)A\)A(AHAA{AҸRA{A  A=qA(AA  AݙAAzA
=AzAA\)AzA33A
ApAQAAAQAHA(A癚A
=AAA
=AAA陚A\A癚AA\)AA\)A噚A\)AAffAHApAQA  A\ARA=qA\A{AAzAAA(AA\AA\)AAA33AApA
=AAQAAGAAAAARAAA
=A=qApA=qAAApAffAAA=qA
=AAAApAzAAzAApAAffAHAAAARA
AA33AzA\)AA{ARA=qA(A홚A  AAApA=qAAA33AAAA{ApA33A\)A
AAffAAA
=AAAARA33AHAffAAffAA{A=qARAAAAHA홚AA=qA
=ARA=qA  AAAffApApAA陚AQAA33AAA  AAzA  AAAA  A{A33AA\)A  AA  AffAGAA=qA=qAQA\A  AA=qAffARA
=AAzA
AGAAffARAAQA{A\)AGA33AHAHAAAAGA\)A  AAAAA\)AAAAAQA=qA
A33AGAAAQA  A\AGAA陚AAA\AffAAAAQAA뙚A\AHA
AffA\)AQA33AAHARAAAAQAA
A\)AA
=A\A\)A߮A(A\AHAQA33AQAHA=qAARAA  AAGAzAAA=qAQA\A(AA=qA33A=qAQAAA
=AHAARA(AAffA(A{AAGA  AAQA\A뙚A\ARAAA(A(A\AQAA{A=qAAzAA
AHA\)AAQA뙚A\AAGAQAAGA33AA
AA{AڣA  A  A  AAۙAzAzAQARA
A\AAAGA33AGAApA
=AQAGA
AAAAHAA\)AQA噚A33AA{AAAGApAffA(AApAGAA\)AQARAQApAA
=ApA
=A=qA
A
=AA=qARA(AAzAAA
=AAAAAA=qAzA\AAAAA\AQA=qAA\)A=qA陚AAAAQAA홚AffAQAAAA
=A(AAAAA
=AAA{AHAAffA=qAAGAAGA=qAGAffA\AzAAAARA=qAA
A33A  AAAHAA뙚AQAGA
=A33AA\ApAHAAA
AGA뙚AAA\)A{AGAffA\)AAAffAAA(A\)AA\)A
AzAAA=qA=qApAAAAffA\)AA\)AA\)AHA{AA{AAAAA=qAffAAQAffAAAA\)A
AAHApAApAGAffA
AAݮAܸRAٙA
AAGA  AAָRA
A=qAәAA33A  A=qAҏ\AЏ\A
=AGA33AՅAхAzAAzAAأA  AA
=AAA޸RA\AAA\A{ApAߙAzAׅA
=A=qAAAzA=qA33AzApARA\AQA=qAᙚARA{AffA  A\)AAAQAA33AA
=AGA
=AQAAA
=A޸RAzAA33AGAAᙚA33AA=qA
A޸RApA׮A33AAAљAЏ\A=qAϙAQAHAυA{AzAљA\)A  A\)ApAHAHAApAҏ\AffAңA33AҸRA(AAԸRA
=A  AӮAәAәAA\)AAQAzAzAAHApA֣AQA=qAzAיAAޣAHA\)AQA׮ApAzA(AGA(A=qA  AAA
=AٙAA{AQAA
A
A  A\)AAzAAA
A33AzAffA\)A  A
=A  A
AڣA
AظRA޸RAHAٙAzAA(A  AمAffAzA{A=qAAQA{AAzAAffAA\)AAA  ApAẠAApA
=A=qAɅAAGA  A͙AGAϙAGAAA\)A  AQA׮A
=AQAzAA
AܸRAffAHApA(AAޣAAAzAffAGA{A=qAffAAAzA{AA\)ApAA  AffAQAAGA
=ApA  AzAܸRAAQA߅A\)ARA
=ARAHA{ApAzAA\A33A\)AAHA㙚AGApA
=AA˅A{AHAڣAAHA
=AיA\)AיAGA33A33A\)AAHApAHAAffAAAQA
=AQAQA  AAʣA\)AAиRA(AЏ\A=qAzA  AGA(AzAzAA  ARA(AffAAAAffAظRA(A噚AGAܣAHAۮAA=qA޸RA޸RAޣA(AߙA=qAA{ApA
=A
AAQAAQAQAzAA㙚A=qAGA݅AA  A  AHA
A
AffA=qAӮA(A(AʣAŅAA{A\)AمA{A33A{A(AAGA(AAAΏ\A\)AA
ẠAʣA  A̸RAAхAӮApAffAQAGA\)A\)AģAAԸRA\)AffAأAڣAۮAA(A=qAQAAޏ\AݙA
=AAAAAffA(AzA(AAՙAQAffA׮AAffAۮAAA(A33A(AHAޏ\AGA
=AAAGA  A
AGA(A\)Aڏ\AׅAGA33A\)A(A癚AAzA(A  A  AA33AظRAGAأA
=AԣAӅAQApA\)AڸRA\)AffA
=AA\)AҸRA(A33A33AQA  AѮAAAAѮAGAGAffAAHAAffAAٙAәAAA33A{A\)A\)AffA\AA33AAA  A(ARA{A
=A\)AffA(A33AHAߙA噚A
ApAffApA=qA33AA=qAA  A癚AAAffAffA\AA  A\A
AQA  AAzAHA  AA
ARAA
A{A(A
AGAAAݮAݙAHAۙAڏ\AApA33AݙAHAQAHAAAGA\)Aڏ\A33AAۙA\)A\)A33AAAΣAA
AHApA{AȣAQAʸRA֏\AGA(A
AHA\)ApA\)Aď\AA{Ȁ\AA(A(A˅A(AA¸RAA(AHAɮAɮAHAHAAAQA\)AHAͅAхAGAGAAffAA{AԣAAۮA(A㙚AffAHẠAA  AQAAAAA  AQA{AυAҸRAAGAzA\)A33AA
=AAA(AGAQA  AzAA(ApAď\A¸RAzAAAA
=A{AAQARA
=AzApA(A  A{AAGAA33AGAAGAffA33A=qA{AzAɅA
=A˅AхAָRARAAͮA(AAHAQA{A  A33AAzA߅A\)AܸRA  A{A(AиRAA\)A=qAîAzA(AAAAAAzAԣAAzA  AՙAأA  AGAۅA
AQAAA33A
=AAAzAӮAAԣA33ApAΏ\A
AȸRAAzAͅA  A  AͮAAGA=qA
A(AA{AʸRAÅAîAŮA(AHAffAGA\)A
=A\)A
=AGAApA=qAݮAޏ\AzAۮA  AGAAGAQA=qAAQA{A
AA(AA=qA܏\A
AApAHAGAffAAGAGAAGA{AAAޣAAA33AAGA
AGA\)AָRA׮AAHAffAAA{A=qA֣AׅAzAڣAAԏ\AԸRAڣA
=ApA\AzA=qAծAAQAGAA33A  AݮAAHA
AffAHApAAAffA  AffA{A{AffAA
=A\)AAQAݙA\)AA(AA=qA  AGAAGAAۙA  A(AA㙚ARAzA33AAQARAGA{A
ApAAAHAGAAQAAAAA\)ARAA\)A  AQAffA{AffAA=qAAݮAHAQAٙAffA֏\A\)AAAzAAzAzA{A=qA
=A
=AӮAЏ\A\)AٙA  ApA
=A\)A߅A33AݙA=qAAffAzA
=AAAA(A=qAAHA33AۅA=qAzAAQA\)AzA
AHAA=qAA\)AڸRA݅A{AGAAAޏ\A{AA\AAᙚA
=A{A
A
=A\)AA
=AA噚AA
AAA\AAQAHA\)AAffAzA޸RAffAܸRAܸRAQA=qAڣA=qA
AۙAٙAڣA֣A(AGAۙAAApA\)AᙚAzAمAծAzA(A=qA  A\)ApA(A\)A\)ApAAARA
=AAQA33AݙAݙAAٙAA
AAԏ\AӅAzAffAʏ\A(AzAA\)AA(AA(AڣAAۙA33AڣAA{AffApAAzA=qA
=AGAAǮAAA(AGAʏ\A=qA{AA
A(A(AʸRAffA(A\)AHAHA33A  AA  AQAƣAA  ARA
=AQApA
AzA
=AA=qAGAzA(A
A
A33A(AəApAGA33AGAGAAAffA  AA\)AA{AffA
=AHAffApA{A=qAAAA\AA\)AGA{A(A=qAAffA33AAQAAAffA\AHA\)AzAQAAGA
A
A£A
=AQARA{ARAģA
AǮAģAffAffAGAGAAAŮAAŮAA(AîA{ApAzApAA\)AGAffA£A
ApAAAAAAQA(AzAA
=Aȏ\AffAǮAǅAȏ\AȸRA=qAAɅAɮAʣAffA(AAAŮA\)ARAA\)A
=AA  A
=ARAzA(A\)A\)A33AA
A
AHA
AAARAA  AzA  AAA33A=qA{A\AHAAB=qBAA
AffA
=AzAB GBGB{B\)B33BzApAB ffA  A  AHARA
A=qAzAffAAA  A홚AA33A{AA뙚A
A  A
A  AQA33A
A\)A\BA{A
=AAA(A
A=qARAApA33AA=qAA=qA
=AAAA  AA癚ApA{AApAHA33AA{A\)AA
AAAGAA  AA
=A\AAAޏ\A\)A{A{AAA
AݙAٮA޸RAffAffAAAA  A\A33ApAA
=A
AA癚AA  ApAAAAAA  AAA(AApA=qAzAHAA=qA  A
=AzAzA\)AQAApAAAAGA{AA  AA
A
AAHAAGA
=AffA\)A\)AHAAHApAA(A\)AAHAAApAffAңAQAծAffA
AAffAGAܣARA{A݅AAQAA  AAAAAAAffARApB33BpBRBGBGA\)AAffA  A=qBHAA\)AHAffBA
=AzAA
ApAARAAzA\AA홚A뙚AffA=qA=qAAAA33AGAzA=qBA{AARApAAAAffAA
A{A\)A  AAQA\)AA홚A癚ARA\)AAAAA
AAAHA\)ApAGARApAARAA\)B {BBQBBBpB AAGAAA
=AAAAApAA\)AA\AAA  A  AffA\)AAA\AA홚AApA\)A33AAA\A
=AzAAGA
=AAA\A\)AA=qA=qAA  AAAAHAA33A(BffA\AAQA
=A(ApAAA=qA
A(AAA=qA(AԣA33AمAA=qAAQA33AԣAQAAApAAʣA
=AA=qAAHAAAԏ\AѮA  A
=AиRAA  A  AzA33AAffAzAAffA=qAA{A(AAA\)A  A{AGA\AAzA33AHA  AAAA=qAffA
A{A̸RA
=A(AAAffA{A
AۮAHA㙚AAAApAAAAA33AۮAAHA=qA  AA֣AA
=AAAAffA\AAQA(AzA
AẠA{AĸRA33ApA
AۮAAAApAAA㙚AA{A
AA=qA
A癚ARA\)AAzAܸRA33AQAAAAAָRA޸RAffAAHA
=AGA{AAffA33AڸRApA
=AA
AиRAAHAA33AffAQAA\A  Aޏ\A\)AAHA㙚A{AA\A\)AffA\)A(AHAzA\)A׮AzAAGAA33AGAͅA33A=qAGA{A
AQAHApAîA=qAAA{AУA{AHAzA
AzA33A\)A
=A=qA(A
=AQA(AAƸRA\AAƏ\AʣApAˮAffAQA
=AzA33AQA(A\)AA=qAARAzAzAzAARA33A33AzA\)AffAzARA\A뙚A  AAظRA33AӮA
=AQA\AffAzAAQApAA  BA=qBBAAGAffA{A\)A  A  AQA\AA
=AGA=qAzAمAAHAAAAQA؏\AQA\)A\)AAܸRAffAޣA(A  AGA\ApA
AAڣA33AAԏ\A
AAÅAͅA\)AָRAQA
AԸRAHAffAA\)A\AAA
ARAQA33AzA  A33AHA(AAARA
AA  AHA=qA\)A
=AApA
AA{AQAAQARAQA  AAAApA(A33AA(AA=qAGA\A
=A33AAzA
=AffA
A33A=qA(AAAA\AAA\A=qAAңA͙AQAffA(A(A  AA(A(A
ARAQA
AQAAхAУAQAA33A(A33AĸRAA33A=qA  AzA{A
=A
=A
=AA
=AA
=AڸRAۮA\A=qAAffA
=AGA=qA\)AۅA{A{AAHARAffARARAAA\)ApA{AA(A(ARAHAՅAָRAzA噚AARA\A陚AA(A\)A݅A(AffAAЏ\A\)A33AA
AzAAA(A
AAݮA\)A׮AۅAӮA\)A
=A̸RAиRA33A=qAQA  AAA{AA
=AɅA{A33AQAzApA
=AzA͙AAAQA{A(Aď\A33AGA33AA33AAᙚA
AڸRA  AHAA(AۙA  AܸRA߮A\AGA\AApAAAAGAAAڣAzARAzA\)AAۙA33A=qA{A
=AAzA(A홚AAAHA(A=qAzAHAzAݮAApA{A֣A=qAzA޸RAܣAAۮAGAA33A
=AAٮAffA
=A
AHA\)A\)A  A=qAA{AGApAA  AA\AA  AA\)AQA\A{A33AQAQAQA؏\AffAffAGA{AAQAQApAARA\AљAA(AңA{AυAA  A
AHApAQAϮAəA=qAAA  AAA33AA{A=qAQAffAͮARAAAGAAffA(A
AAHA{AA  A33AיA
AA
AQAAzA(A33AAQAApAzA{AAA(AffA
A
=Ȁ\A  A  A33AQAffAHAzA{AApA
AffAQAA{AAAHAAA=qAAAЏ\AzAυA  A=qAAAQA
A{A
A{ApAAA=qApAHAHApAAߙA{AQAA
AAAzA
AARAHA
A޸RA{AAGAGA\)AzARARAAQAᙚA
A
A(AA(A
AHA33A\)A
AAGAAAݮAHA߅AGAHA{AffAУAڏ\AAA
AA{A{A
=Aҏ\AHAиRAA
=AAָRA=qAיAQAͅA  AA
=A=qA̸RAծA(AӮAAQAٙA  AHA{AAAA{A\)A
=AA\AQAAA陚A
=A߮AzAA߅ApAffA=qAA=qA{A=qA=qAGA陚AA\AQAAA\A{A(ARA  A(AGAA
=AAHA{AGAޏ\AA33A{A33A\)AA{A=qAQB \A
=AzAAA
=AHAzA
=AمAܸRA(AHA(A(A
=A
=AHAGA=qA=qA{AApAәAܣAQAAGA\AA{A
AAA{ARAAGAA=qAAA뙚AB
=ApABA(A  B GA  ApAHB(BA{BGApB A
ApA
=AQAzA(A(ARA\)A  AA33A\A{A{AffA
=A{A
A\AAffA\)AGAAA\AA\A{AA{AzAAAA{ApApAffAQAA33A
=A\)AAA  AHAHAAffA\A\)AAAAzAAAA噚Aڏ\A(AQARA\)AzAAAAffA\)AA33AGAGAffAzB ffB(B\BffAHA(AA33AB AB
=BB B(BB BffB\B ffAHAAGAzA33A
=AAA
=A{AAzA\)A\)A\)AA{AGARABB  B{AAAAAAQAA=qApAA\AB {AB\)AGB QAB 
=AA
=A
B(A(AA  A(A=qA=qA\)AGAAAAApAGA
=A\ARA(A{A{A\A
=AAAzAApA
=AA
A  AffA=qAA噚AAHAGARAAHAAApAzAARAAzAAAAQAApAAڸRAA(AAAffA\)AzAΏ\AQAA{AzAAԏ\AGAA
ABAQAffA
AA
=Aʏ\AҸRAA  BAzBffA=qA33A{A33A뙚AA\)AGA
A
=AGAAȸRAǮAffAGA
A
AAAffAA\)ARAzA߅AAHAA(AA\AA=qA33AQARA  AzAffAܸRA\AzAA\AffAAAARBQA(AQBB {A\AAHA(AzAAAA߅AAzApAHAәA
AQAAأAQAGAA܏\A߅AA  A  A(AA
=AHAAGA(AHAQAAA噚ARAAA  A{AzA  ApA33AAθRA͙A=qAAA(A  AQAGA=qA33AAAAAffA(AQAGAAAffAHAApAمAڏ\A33Aڏ\AzAHA
ApAQAffA
=A
A\)AAQAAzAAA{A\)A
A
AAGAAHA33AzAffAA33A\)AA\AHAڣA
AծAffApA
AQA؏\A
A
=A׮AظRARA  ApAՅAAԏ\ApA=qAGA
AQAGA=qA=qAA=qAffAۮAAƣA
AхAAHApApA̸RA33A33AљAffAApA(ẠAϮA
AУA33A
=A=qApA
=AGAQAAzA(AA=qA\)AffAA33AAAA
=AApApAffA
A\ApAAA=qA\)AAA{A{A
AA癚A
A\ApA\A\)A
=AA=qAAA  AA=qA33AA  A(A33A33AQAffAGAA  A=qA33A=qAzAAAQAA  A(AffAՙA33AffAAڣAA33AAGAAхAAA(AAA܏\AAAAAGA{A  A
AffAA\AGA(A  AzAAARA\AA{AHA\AAA\)A\A\AAAffAAAA
=AA  A(A\)AffAQA  A홚AAHAAAA  AGAAA
=AGA
=AAB AApAAAA{A  A
=A
=A\)A
AA\)AzARA(AGAzAA{A\)AA\A=qAGAA33AAzA\)A\)ApAGAApAQARAA
=AQAA
A
=AffA
=AAA\)A㙚AA
A
AGA\AffAAApA(A33AHA(BA  AA\)AAffApAAHAQAffAAB (AAAAAA  AAQA  A
=ABffAGAQA\AAzAAHAA  AAA(A{AA
BB33BRBB	
=B	B
BffB33BB \ARA
ARA{A  A
=A  AAAApA(A  A\)AffAApAzA{AAAAHAAA  AAθRAffAffAAݙA홚A(AzAAHARA  AAAA{AB{AAA\A=qAA=qB  AARBBffAzB\)A\)AzA=qA
A\AA=qA
AAzA  ApA
=AAAAQAAA
=AGAzAQAA
AA
=AGA
B B (BBBBQA(A  AARAffA  A(A(A=qAA\)ApA\A
AAGA{A(AHAffA33AAA33ApAAAGA
AHAAffAA(A
AAՙA\)A(A
=AٮApApA\)A33A(AzA(AffAGA\)A
=A33A=qAAzA(AApAA=qAAA  A陚AAAA\ARAHAAAA  AAzAA
AzAA{AA33AA
=AAzAA33AAQA뙚AAAA(A
=ApAۙAՙA=qAHA=qAAffAQA\A  A{A(AǮA=qAŮA\)A  AGAʏ\A\)AA  AȣAQAHAffAARAA\)AA=qA
AGA
=A
=AA\AîAQA  AA(A׮A
AAߙA癚A
AARAzA
A(A㙚A
=ARA
=AffAffAQAA
A=qAAHA  A33Aޏ\A噚AۅA
AffAQA=qA
=AQA
=A癚A\)ApA{AAAApA\)A33A܏\AQAAAHA33A\A
Aԏ\A  A
AA(AA(AAHA33AHAAׅAиRAGApAͅA(A͙AGA33AQAɅAHA(AAGAQAffA
ẠA33AȸRAAAÙAA(A(AA
AGAHAHAAffA
=AAA\)A׮A
=AޣA\)A(AAAAffA
=ARA\)AHA(AGA=qA(AAأAGAAGAAGAAffA{AAHAGAAݙAA(AHAQA  AHAA\)Aԏ\A(AQA֣AAӅAȣA
AƣAGAĸRAHAřAAÅA33A\)AzAǅAAGA˙AAΣAУA
AҸRApA  A  AәAQAA  A{AA33AУAGA\)AͮAGAAA(AٙAׅAzAQAHAA(A\)ARApAApARA\)AA\AA\)AA(AA\)ARAHAAAA33A
A\A\)AGA
=AA(A  AAAGA=qAzAGAGA{AApAQAffApAHAGAQAGAA33A(AAAA޸RAAQA\)AA  A߅AA\AAQA\A33A\)AAA
A\AAAA
=A=qA33AA\)AffAGA
=A\)A\)AHA33AQAA\AARAApAA
ApAAA\)A\AHAB33BpBQBB{BBHB=qAA(AA\A  AA  A{A  ARA\)AA  AAQAAGAAQA{AAzAzAHApA33AA33ApAA=qA\AHB =qB
=BHAA
=AAffA=qA(A33AGA33A=qAHA
A
=B BpB
=BffBzA(AAGA33A{B QBAAA{A=qBffB(BB\)BHBB 
=A\)A\AAzAB   B(A(B (BffBAA=qABGBffBBBB33BzBBpBGBBBzBB\BzBRBzBB{B AB
=A33BffBGA\BGB A
BGB \B B  A=qBAA{A
=A
=B BBBzB  B(B zBpB (AB GAAAAAAGA(A(A{AQA\AAB =qB 
BB(BB{B B  BffB pB=qBHB
=BffB{AApB \)B \B{A=qAQBB=qB 33AAffB \)B BB   B (B =qB B  BBGB=qB33BB  B\BB  BQBBBRBffBQB=qB\)B  B{B{B\B
AApA
=A\AQAA
A\ApAA(AHA{A\AA\A
=A  ARA(A\B AA\AAQAzAffAAAA{AApA=qARAA
=AApA=qA33AA\AA(A{A{AzAzAA\)A{AzAA(ARAzARAzAAA뙚AA\)AzAA=qAAA  ARAzA33AzAA
ARB AAAAQA
AAAAA(AAAGApAHA
=AA  AAA(AAAGAffA\)AAQAGAHA\AARA{B AGA(AA\)A=qA(AffAA=qAۅAAHA\)A噚AzA噚ApAApAA  AHA33AHAA뙚AffAAAA{A  AzA33A  AHA{AAᙚA\A=qAA\)A{AAAAzAAAA\AARA  A33A33A\)AA33AA\AzAA
AAApA(AffAAAHApAAᙚA  AHAGAQAA\AAޣAAܣA=qAAQAHAffApAAAAQAAAA33A\)A\AAGAA\)A܏\A݅AQAHARAAzAAAffARA  AAA33AA\)AGA{AzA33A
=A\AAAHAAA
=AQAAQAAA  A(A  ApAAzAAAGAHAAAA=qAGA\)ApAA33AAA\)AA=qA(ApAQA
A
=A
A\AAAGA\AA  AAAA
=ARAA=qAAAQAA33A{A(AA  ApA  AGA33AݮA33AAzAڸRAHAڸRAA܏\AGA܏\A\)AAzAڸRApAQA(AA(AۮAۅAڸRAzAۅAA{AۙAGA=qAzA
=A\)AA  A
A(A=qA=qAAԏ\A  AAAApAڏ\AۙAۅAAApA{A߅A\AffAA
=A  AffA
=ARA33A\AAA
ARA=qAffAGAHA
=AޣA݅AQAܸRAGA  A\ApA\)AߙAQAffAAAAzAAߙAAHAՙAHApApAHAңAAAA
A33A=qAҸRApAA\)ApA܏\AܣA  AۮA=qAzAGA=qA
AݮAA  AARAAHAffA
AQAՅA͙AGAʸRAA  AHA{AŅA֏\A
=AGA(AHA
AQA=qAApAAɅAffA33AУAA\)A  A33A{AApA  AۮAAzAәA
AffAȀ\A  A{AAzAɅA(AǙA=qAAAHAzA33AzA=qA؏\AޣAGAQAθRAQA33Aʏ\AHA=qA˅A
AffAA˅AzA\)AHAAAHA
A̸RA˅A33A=qAʸRAA(AffAQAAAAAAApA
AɅAffAAʣAΏ\A33AGAffȀ\AϙA=qA֏\AA
AAQA{A=qAQAffAA33AQAϙAʣAGAA  AA33AGAA
=AУAљA  AQAA=qApAͮA
AәAAأA{A=qAңA֣AAۅA  AHA͙A
=AzARAHAẠAAAͅA\)A
=AA(A
=AAA
=AHAAAAzA{AAHAAAA\AffA\)AffA  AͅAͅA=qAGA{AمA
A\)A  A  AQAA=qAҏ\AA\)AңA{A{A  AAA
=AQA  AAA\)AGAHAGA˙AAA\)AAAA  AffAffA(A(A(AÅAAΏ\ApA=qAzAӮAzAzA=qAApAӮAQAޣA
=AAAA{AHAGApA֏\AϙA  AAǅAǙAffA33A
=A  A=qAͮAffApA
AQA(A=qA؏\A֣A\)AGAHAߙA33A=qAAA=qAAGApA33AHA
AAAA{AA
=ApAHAHAzA\AAGAA
ARAA\AARA\)A33A33AHAAAQAGA뙚A뙚A
=AffAAGAHAzAAAAAᙚA
AzAA  A֣AԣA\)A߅AAAHAڸRAAA
=A
AAHARAffA\)AܸRA{ApA  AA{Aڏ\AQAzAffA33A{AHAA  AGAARA  AA\)ApA
A
A\)AAՅAAzAQAܣAAQA{Aݙ?
=AAffApApAA\)AAAB B \B
=B=qB\)BBAA33AQB QAAffA
=ABB BQB  BBBHBHB  BBB\)AAAA\AAGAAA  AQA33AAAAApAAQB   AAAAAQAzAQA(A\A  A癚AA{AGAApA{AffAA
A{A\)AGAA  AA(AAApAA\A(AQA
ApA\)AA
=A33A
=ARA㙚ApA陚ApAA=qA33A{AAA33A(ARA㙚AHA
A
A
ARA  A
A\)AAA  A  AAAAHA=qA
AQAA  A
=AARA\)A  AAAGAffARAffAAHAA\)AAzAA\AQAAAzAAARARAQA߅A
AzAAAA\A=qAQA  A{AHAQAAAAAA33AA\)AٙA  AQAzAA
A(AA(A\)A  A
=Aȏ\AzAAٮA\)AAffA\)A  A  AAB zA=qAAzAA{A\AA\)AA=qAzAB\B AA
A\)BAAAA\)A(AAA{ApA=qApAA=qA=qAzA(ApB BGAB=qB 33AAffAAA{AA33A
=A
A(A\AHAA33A
=A  AffAzA\A  AHA\A\AGB B =qARAB \)A\A=qAzA{AAAAA33AffA(A\)A
A  AAAA  AAGAHA{AA  B 
=A
AB AB AA{AB QARARAAABQBzB\B QBzBA
AA
B33BRB\BpBHBRB=qAA\)ApA  A
=A=qAARAAA\)A
=AQARApA33AQA
A\)A33A{A  AHA
=A33AAHAGA
AA\A33A
AAHAA㙚AGA
A33ARAGAApAA{A
=A\)A(AGBB AGB
=AAARA\A
AA
A
AA
=AffAA(ARAHAAzA(A(ApA=qA\AAQAAGAA(A\AzA33A
=AA
AA홚AAAGA{A\)A\A{AAA\)AAA\A\A\)AA\)AzA
=A
=A{A  AffAGARA
ARAA=qB   B {AGARAAA(ApA\AAA(AHAיA\)AәAٙA{AAAУA{A  AHAΣAffA\)A(AffApA  AQAzAAA\)AԣA\)ApA33AA33AAϙAAӮA
A{AθRApAAGAHAAAAAHA{ApA
=A
AA
=AffAA\)AׅAA=qAͮAׅAGAGAA33AAAۅAGAAڸRAЏ\AͅA33A
=AAHA\)AHAAARAA{AAAA(A  A=qAffAARAA癚A߅A33AAzAQAHA
AffA(AAAzAمAمA=qA  A  AAˮAυA  AA  A{A  AGAݮAAHA\)A{AřAHAQAGAAڏ\A
AA
AQA\)AffAA\)AzA{ARA=qA33AzA
=AA  AA33AzAᙚA\)Aޏ\A݅AAGAQAQApAA\A\)A
=A33ApA
AۅApA؏\A\)A
=AGA(A33A
=A(AAA33AA
=AߙA(A=qAAAQA
AffA  A=qAυA  A
=A(ApA
AЏ\A
=A܏\A33A
=A׮A
=A{AAQAA\)AAA  A=qA噚AARAA뙚AQA{A(AAAA\A癚AAffAAGA\)AApA\)AA\AA{AAA33A{AHAzA33A\)A
=AAAAۙAQAAAAܸRA(A\)A\)A=qA癚A(ARAA  AAA
A  A\)A=qAzAQAA
=AzApA33AffAޏ\AAA=qA܏\A
=AHAљA
A{A֣AHApA(AHAHAAڏ\AzAQAڸRAAظRA؏\A  A  AԣAљAхA  AA(AQAzA
A
AAzApA\A\A
=ARA\)A=qAffA癚AA
=A  AAAzAffA
=AAGAzAAA=qAAAGAۮAڏ\A  A(A޸RA߮AHAffAA
A\)A  AzAAffAAAAAA\AHAAGAzA߅A33AAA\)A֏\AAݙA
A˙A\)A˙A  A
=A\)AϙAffAΏ\AHAΏ\AAGAGAQA
A=qAAffAGA{AA33Aԏ\AAAԣA33AӮAљA=qA  AхAHA=qA\)A  AA
=AHAGA{ApA
=AHAA{AzAffAQARAARA33AHA\AGARAffAA
=A
=A׮A\)AָRAHAffAQAGA  A
=AGA33A
AzA
AAAffAHA\)AHAAޏ\A33AffA
A\)AA{AA33AA\AA33A33AAۅAAQAzAΣA\)ApAzA33A
A=qAAAޣAظRA(AARAәA
=ApAAݮAAޏ\AA33AA=qAAA
A
AA㙚ApA
=A\AffA
=A33AffAffAAA
AA홚AHApA{AQARA\)AA=qAQA\A
=AAޏ\A  AՅA33AиRAϙA\)A=qA{AЏ\A{AA{AAA{AAQAffA33AA(A홚A33AAAHAAffAAA(AA\)A(AHAAA{AAffA
=AA{A(A{AHAAۙA{A  AܸRAۅAHA=qAffAʸRA(AAAHAQApAA{AQA\)AAQA
AAffAGA
AQAffAffA
AHAHAQA\)A{AQAAA
=A{AAA33AAAzA\A{A(AAAAffA33AHAAffAAHAA  AzA  A33A
AߙA\)A  AffA\)A
A㙚AARAA=qAA{AHA֣AHAԏ\A
=AAAAApAzAA  AA{A(A(AхAڏ\AGAυA
A
=ApAApAGA
=AHAffAAAAA33AffAffApAGAA33AzA
=ARA(ARA{AA33ApApA=qAAAGAA\)AHA\A  AHAGAAA  A(A33A  AAA=qAGAGA{AA(A
=AHA(AңAۅA
AAffAA(AAzAۮA33AGAQAA
=AQA  A=qAA
AffA33AQAAzAΣAHAA(A=qAAA(AA33ApAzA33AAӅAԣAA
=AQA{AffA֏\AAٮAffAAA=qAA
=A33AQAA\)AAQAAQAffAAA  AzApAHA(AA\)AffAHAA  AQAQA  AA=qA{A؏\AAAϙA33A33AAA\)A\)AffAGAظRA(A  AڸRAAAA
=ARAAffARApA
A33AHA33A
=AA{AzAAGA33AAffAffAظRA33AAAA
AAA
A{A{AϮAиRAffAA{AӅAHA  A\)AGAGAGAGA{A\)A
AٙAGA=qAAA
A\)A=qAffAA
=ARAGA\)A  A(ApARApAAzAA
=A\AA홚A(A
AA
AAA
=AݙAA33AA{AffAA޸RA(A\)AHAGAzA33AAApA(AA{A33AAQA33ApAHA\)AA
AHA\)A
=AQAzA(AҸRAәApAQA{A
AAA(AzAzA(AQA=qA=qA
=AңA
=A(AAȏ\A{A
=A
AApA33A\)AQAəAzAffAAffAzA=qA{A\)Aڏ\AA  AA  AAAͅAʸRApA
=AܸRAHAQA݅A=qA=qA  A  ApAQAQAA33AGAծAՙAԏ\A  A{AffA\)AGA
=ApAAAA33Aʏ\AHA33AQAffAڣAQAԣA  AA\AzAffA(A
AffAʣA  A
A33A
=AAQAAAGA{A=qAA
A{A33A(AAAAffAGAzAffAHAϙAиRAGAA  AAAAAAffA(AA\A\AApAGAAA\AffAzAARApA\)AffAGAHA(ApA\)AQAffA=qA
AծAȣAѮAƸRAͅAAQAAGA=qA33AƸRApAHAAĸRA
=ARAA{AHAA{AffAA(A\)AGA=qA\AA=qApApA=qAzAQAGAƸRA
=AHA(AzA=qAAAGAAAAA
=ApAGAHA\)AA33AApAAAzAAA(A\AA=qA
AHAĸRAA
A  AAAA
AAA=qApAzA\AGAzAzAA33A(AA  A  A
A(A=qAQARAGA\)A{A  AA
=A
AיAGAARA33ApA
A˅A{A(A܏\A33AA(AAAA{AAA  A\)AAAA{A
AA(AAAA(A(A\)A33AffAzApAApA(AAAAA{AAA33AAQAHAAA  A{A\A\)AzAAHA33A\)AffA  AAȏ\AAǙAəAffA33A\)AřA{AAzA(A  A\ARAAA=qAzA  AAA=qAǮAɅAHAGA(AffA
AAQAAffA
A̸RAAAᙚAA
AQAAGA33AGAGApAAAHARAHA\AApA\)ARAffA  AA
ARAAÙAA
A£A33A=qAɅAAAzApAHApAzAAGAHA=qAGA(AzA(A㙚AݮA  AHAzAۙA\)A{AA33A
=AAAAA(ApAAzApA{ẠAAңAQAAǙAʣA̸RAA  A
=AAA
=AAAңA{AAzA£ApA
AHAиRA=qAأAGAA{AϙA\)AzA
=AϙAԸRA\)AzA
=A33A=qA
AAQAQAHA\)A
=AffA(ApA{AA
A
=AAffAA=qA(A  A
A  AHAQAGAQA\)AۙA33A  AGApAЏ\AԣAA(AA֏\A\)AA
=AAGA
=AzAAAQA=qAAAGAAAAAAQA
=ApA(AԣApAffA33AAA=qAAAzAԸRA(A׮AׅAHAHAӅA(AzAHA(AǙAGAƸRA
=ApA33AA=qAzAGAAApAzAGA
=A  AAAAHAffA33A\A¸RAffA  ARAA(A
=AA¸RAƸRAƣAǙAˮA  AA=qAAGA
A
=A޸RAQAəAՅAA  AAA  A\)AȣA\)ApA
A
AƸRAQA(AAApAA
=A33A
AAׅAzAхAGAAGApA  A  A׮AA
A(AA(AHAffAAHAffA=qAA
AљAAA
=A
=AљAͮAA(AzA\)ApAAAzAAQAApA
=A
=A\)AAA=qA
AAA{AAAA(A{AAApAAAGA33A
ApAɮAHA33A{Aޏ\A33AӅA\)AAQAAQA
AzApAQAřA
=A=qAffAAffA{AA\AƏ\AģAAAGAƏ\A
=A=qApAffAQAA
=AA
=A(A(A˅A{A33AAУAzAAffAřAAAA=qA
AAA(A33A=qAA\A
=AAGAffARAA
AAHAffAHARA\A\ARAAAApA\AffA\AQA{A(AHAffA
AffApAAQA
AA{A
=AA{A{ApApARAzA  A
=AA{A(A33AGAAffAQA
AffApA
A33A\)AA\)AȸRAΣA£AQA
=AAĸRAƏ\ARAAARAffAQAQA(AAQAͮAɅAAQA\)A\)A
AA(AQAAΣAffAA=qAθRAÙAƏ\AA
=AAHAzAApA\A
AAGARA
A(A{A33A(A(AQAAHAAHA\)A\AAA{A(AAHAAA(AGA(A\)ApAzApAAffAAAzA=qA˙A(A
AA(AϮA\)A
AA\)AͅARA  A\)AAǮA˅AQAAAA
=A
=AA
AA33A\)ApAzAәAәApAffAA=qAHAǮAʣA
=AϙAGAԣAẠApAAϙA=qAffAÅAHA=qA\)AŮAQAAA\A
=Aʏ\A=qAHA(AzAAAAA33AAAQA\)AA\AHA=qAAAA33A33AzAAA
A(AA  A(AAA\)AȸRAÅA
=AAffAA
AHAQAȏ\AzAAGAffAApAA{A33A  AAA  AљAѮAzApȀ\A(AzAzAǮA
AîA33A=qAĸRA¸RA¸RA
=AŅAAHAΏ\AAϙAGA
A  ApAGA=qAAGA  A
=A=qA33A(A{A=qA\)AHAAffAAA=qA=qA  ApA
AQA  ARAGA\)A33AA{AHAAA
=AA  A  ApAAA33AA\)AAHA\)ApA  AȣAffAˮA(AffARAzA{A
A33AApA\)A=qA\)AŮAffAzAģA\AîApAQA\)ApAA  A  AffAŮAîAffA(AA\AA
=A=qA\ARA{A
=A(AGAŅAÙAǅA=qA\)AAGA
=AA
=AA{AA=qA
=AffA(AQA
A=qAzA33ApARA(AAAAA  AAHA33A\AHA=qAA\)AAHAGAffAA  A{AAHAGA\)AGAAAAA\AǅAffA˙AȣA  AzAA{AAffAA{A
AA
A
=AzAffAAHA\AAA33ApA{A
AA=qA\AARAAÙA{AAA
A
A(Aʏ\AƏ\AřA\AA=qAǙAffA
=A{AQAQAˮAAˮAHAAA=qAAHA(AAGAQAϮAʸRAHA
=AApA
AAGAAAGA=qȀ\AϮApA=qAffAՙA=qAA{A(AHAHApAٮAיA
=A
A=qAיAәA
AA=qA͙A33A
AAAA
A\)AQAЏ\AGAA\)AAҏ\AA33AffA
=AQA\)AңA(AAHAՙAAЏ\A(A
=A
AǙA  AAA
AGAAARA{AAA
A{AHAQA=qARAQAA  AAARA\)AzAAA(ARAAAA  ARA{A(A
AGA  A  A=qA{AA
=AAA(AzAʸRAA(AəAAAAA\A33A
AAQA
=AAAA\AQAzA=qAAAAA{A\)A33AApAARAApAGA
AA\AHAAAGA33AQA\)AAAAA  AAffA
=A\A\)A{AffA
AA\AffAAHAA=qA{A\)AA=qApA=qA
A\)AAAGA\)AA
=AGA33A
AA  A\)AA=qAAA=qA
=A=qA(AAA(AGA(A\)AQA{AA~RAt(AtApzAf{AaAc33AbRAeAeAjHAhAhzAk\)AmpAzAQA{A
=AyAvffAyGAvHAuAk33AjffA^{A`(Ac33AjffAn{AiAmAyAyGAv=qAsAmAf{AdzAj\Ao
=AQA
A  AQA33AAAzAA{A  A{AAAA(AAAAGAffA33AGA  AzA(AHAGA(A
ARAA(AAA{AQA=qARAAAAA{AA=qAAA(AA{A\AArHAaAdAs33A~HAr{AAAAzAffA
=AAffAffAAzAQAAARAAA  AA
=ApAAAjHAdA`  AWAhzAf{A\AjffAuAxzA}pA
AHARAGAAA
=A(AA{AA
=A\A(AA{A
AAGAAHApAAHA~HAyAyGAv\AtAtQApAmAyAlAlAAwAz=qAqGAAAQA=qAAzAAAAQAA\A=qAAffAA{A(A(A33AA  AARAffAx(ApARARAQAHA33A\A  AA=qA\)AAAz{AqA
AAAA}AAA(A
=AAAwAffA\)A=qAfHATAs
A(AAHAA=qAffAAA(AyAvffAkAvHAhQAbRAGA{ALzAIGA]A33ARAA\)AA
=AA  AzA|(Ag\)A  A}A=qAApAGAx  Av\AQAARAAAAffAAGA~=qArffAvHAxA}AvHA|  A\)AffAAAzA(AQA{A
=AHAHAzAAA\AAAHApAQAQAQAA\AA~=qAAA}AAAffA  AAAAGA(AA  A
=AzAffApARA
=A
=AAGA(AA33AA
=A  A  ARAAHAAAAGAA\AAQA
=AffAA\AA
=ARA\)AAzA{AHA\)A\)AAAQAAARApAA  AAAA\A
A\)A33AA33AzAzAffAA33AA(AQAAffA=qAA\AARAAQA  A\)A\AQA=qAAAA
AffA
AAAffA{AApAHA  AApA=qAAAQA{AAHA  A  AQAQA33A
AA33A{ApA
=AAA(A=qAGAGAARARAQAzAAzAGAzA\AAGAA
=AAARAAA\AA
ApAAQA\)A{Aȏ\AzA  A\)ApA(AAƣA\)A33AAHApAA33A{A\AAŮAffAA{A(A
ApApAARAzAAA\)AzAAHAHAGAA=qAHA{AARAA
=ApAAHA
AAARAzAA
=AAAAAA
=A33A{AAAQAQA33AQARA33AzAAA\)AAA
=AA\)AzApA33AGA(A=qARA33A33AAAQAAAHAȏ\AffA\)ARA
=AAA
=AAAffA{A
=AɅAAAffA=qAQA\)AAAAAƏ\AA
=AGAÅAffA{A33A
AHA\)ApA33AAApAHAAAA33AQA
A{AA=qAA(AAffAQAGA  AGA33A\AzAQA=qA{AApAAzAA
=AA  AAHARAAGAzA
AffA\)AAAHA
=AA
=AA  AAGAAAAHA=qAzAffAA
AAQAQA
=AAHApAzAAQAA  A{AA  AGAAAAA\A  AzAĸRAGAQA
=A
=AAzAAAzAA{A
=A{AGAAAAAAApApA\)AHARA\)A(A¸RBAAڏ\AծAԸRA33AGA\)A\)A=qAAA\)AffA{AAGA(ApAGAzApA(AAAA33AA˙A˙A
=AA\)AAzAGA\)A  ApAGA
=AffA(AAݮA  A݅AA33A
AzA33A33A33AQA{ARA  ARApA
A\)ApAՙAA{A  AffA=qA  AîAAAQApA\)A(AծA׮AAARAA{A
A\A(AHA
AApA33AA\)AffAffA
AHAA33A\)A
A\)A  ApAA\)AQApAAAAAGApAA
=A\)AAA(AAGA
=AAAApAGAAܣAۮA\)A\)A=qA{A33A
=AϮAA{AQAGA(A33A  A߮ApAHAHAA
=AAffA(A33A陚AAAzA\A(AAA
=AA
AQAAA
=AARAA\A{A=qA{AzAzAA  A{AzA(A\)AAA
=AAHAQA
=A\)A؏\A\)AA\AzA
=AAA
=AᙚAA\)A  AHAffA޸RAܣA
AGA=qAAA噚A=qA  AHAۮAA\)AA{AAGAAAzAA=qAAA\)A  AzAzAA
=A=qAA(AHARA\A
AA߮AApAGA홚AA=qARAzA  AA  AA\)A=qAA33A  AA{AݙAA=qA\AzA
A  AzA\A\A  A\)AA\A\)A=qAA
=AffA߮AܣAA
=A߅AߙAAApA=qAHAHAAAAGAA{AA\AzAQAA{A33A޸RAޣAGAAGAҸRAAԣAхAA  A(A33AřAA(A(ApA
=AGA
=AA
=A\)A33A\)A  AA\A
A
=AA֏\A
AAݙA33A33AffA=qAHAәAȸRAՅAQAAA\)A޸RAӮA\)AݮAffApAzA
=AҸRAA
AǅAA
=Aʏ\A\)AzAͅA
=A\)AЏ\A(AA
Aҏ\A
=A\)AѮA
AzAQAAQAA{AHAAAAɮAHAθRAϮA=qAQAQAυAθRAͅAAʸRAAAffAffAAƣAQAAA{A{A
A=qAAAHA=qAA33AA33A=qAA
=A(AGAzAA\AAәAHAQAAHA=qA33A{A\AGAA\)AA(A\A
=A
AAAAffAGAffA{A  AÙAQA\)AGAGAA{AAAAffAQAA\)AA\)AAffA\AHA=qA\A  A{AffA(A\ARA\)A
A  ApAffA
=AffAzA\)ApA  AAA
AffA=qA{AәAAA(AA  AAQAA  AHAzAAAGA33A
A
AՅAAHAHAzAAA  AHA
=AffAɅA
A{AՙA  AAA33AQA\)AzA\)Aҏ\AAAApA\A
=A(AAzAA=qAAzA
=AGARA{AAAA݅A\)AיȀ\A{ẠAϮApA
=A  A(AƏ\AzApA{AffAA  AGAA  A¸RA£A¸RAQA  AzAAA{A(A
A=qA\AffAA
=A
=A
=AQAzA33AHApAA  B HAzAA33A=qAAHAffA(AARAApA\AGA(AܣAڣApA\)ApA33AڣAAمAzA33AQA{A{A
A\)AHA{A33AAB\AAARA
AHAHAffAApA\)A(AA{AAᙚAGA
=AHAڸRAA33AܣAݮAAQA33A\)AřAˮAəAffAǅA
=AAffA\)A
=AAGAAAՙA33AȸRAՅAՙAAȀ\A(AAffAAA=qA=qAA33AA\)AA  A\)A뙚AHA
=AAAQAAA\AQA޸RApAڏ\AzA
AffA33ARAAApA\)AAffA{AAAA\)A{AApAׅAAzAzB  A33BApA
=AffAQARA=qAAffAA33A=qAA߅A(A\)AəA=qAңAGA{AHAffA=qAۅA
AGAzA33AffAAQAAՙAѮApAAAݮAzAHAߙA
=AA=qAAzAA\AAAA{A{ApAAAGAA(A
AffA
=AAAA\)AAffAAzA  AGA噚A
AHA
=AzAQAۙA33AHAۅAA{ApAAHAظRA܏\A=qAAAԏ\AAQAHAzAAAHAAA(A\)ApAQAzA
AffA  AzAңAGA(AQA\)A=qAQAA(AϙAffA(A\)AAمAӮA
=AHA\)A(A=qAAڸRAޣAܣAQAHAGA\)A33A{A=qA\)AA=qAA\)A޸RA(A{AQAңAӅA
=A33AA£A{AAΏ\AA=qAzARAAffA33A33A33AиRAңAzAAzAأA͙ApAApAA(A˙A33AffA{AAָRAffAAAA
A\)A
=A(A{A(AA\)A{A
A
AܸRA33AхAHA=qApAGAAAAA{AǙAɅA
A
=A(A
=AA  AzAAApA=qAAAApA  AA\AffA=qA{AAzAA(AAARAAGẠA\)AӅAzAٙA݅AQAAGAAGAQAAQA
AGAA
=AA(A(AffAҸRAAиRAAԏ\AׅAAAffAAиRA33A  AՅA33AA
=AHA=qA޸RAGA(AA=qAAᙚA
AAمAAͮA
=A=qAzA
A33AffAA33A  Aȏ\AffA{A\A
=AzA=qA{AGA33AיApAʣAAÙAȸRAǮAǅAȏ\A
AAУA33AAffA{AHA  A
=AA߅A\AAffA=qAffA
=ApA\)AQA=qA
=AݮA\A݅A
AݙAޏ\AAAQAA׮A
=AHA=qAۅA33A  ApApA\)A홚ARAffA\)AܣAAAA
AA33AQA  AܣAAAAQAAAA(A\)ApA  AQA
=A  AQApA  A(AA߅AzAffAHA33A=qA33AAA=qAᙚAQAffA33AGARA(AzAAAA33AHA(AARA
=AffA(A{A{AܸRA=qAA뙚AQAAGA\)AA{ApA  AA  AA  AQAڸRA  A
AAA
AQA\ApA\)AA{AGAffApA\)AGAA{A33AA噚AffAA\A\AA
A(AHAffAAAA  ARAzA\A(AծA؏\AԣA؏\A=qA(AAHAGA
AҸRAA  A(AHAAAӅAAәA33AAңAӮA(AAHApA33A(AA\A
=AAzA(AzAHAHAɮAͮA33A=qA߅AأAHA(A
AQAAޏ\AAܣAAzAQAzAԣA=qAظRA  ApAAAՅAAffA(A
=AffAׅAGApAffAAQARA(A
AGAffAApAAߙAݮAڣApA
A33AQA
AAAAApAA{AAzA\A
=AGAٙAA
=Aڏ\AzA͙A  AϙA
=AQA  A(A˙AAA
=ApAAAAQARApAHA
A{A{AzApA\)A\AAAAAffA  AA(A  A  ApAzAGA33A  A(AzA\)AA33A=qA߮A\)A
=AzAQApA\)AA(AAA=qAҸRAɅAAzAApAʸRAAAzAzAřA
=AA\)AGAAzAAHA\)A
ApAAHA=qAffARA(AA=qA
=AA(A
=AGA
AAAA{AAffApAAAA33AA(AGARAA{A
=AAA=qA(A(AAAzAARAA{A(A  AA  AHA
AffAAƣAQAAAAGAHAAApA
=A˅A{AffA{AGAAQAAA\A33AŮApA=qARAQAHAQAHAHAA\)AHAHAAffA33A=qAA=qAAA{A33AA  AffAzAAffAAQAHAQA  A  AHAAA(AAAARA=qA=qAzAffAA\)AGA{AA\AARAAA(AA(A33ARAHAA(AA\A
=ARAzAHA33A=qA{A(A33AAAAQApA
=AQAAAGAzAQAîAffAA  A(AHA{A33AffAAQA{AGA(AAffAA{AA\)A33A
=AA\AAAA
=AGAAA(A\AffAA
=A\)A(AHA  AffA{AAGARA
ApAAA33ApAGA  AzAHAA\AAA=qAAA\AA\A
AAQAAAAA\)A  AzA
=AAzA33AAAGAAzAQA=qAGAA
AQAA
=A=qAzA33AAAA=qA
AzAA
=A{ApAA
AzAAA\)ApApAApA\)AAQA{A{ApA{A{ApA\AARAAAA33AA33AAHAzARAAGA\AAAGA  ARAGAzA(AA
AA(A\AHA33A  AAAA
A=qA33A\)A(A{A33ApAAzA\)AA33A\)AAAA(AAAA=qAffApAffAA\ARAAHA(AA\A33AzAffAffAA{AAA\A  AQAAffAAAGA(AA
AAAAA(AA{AA
A33A\A\)AAΣAHAGAA
AA˅A{AQA33AAApAAHAAHA˅A\)AAԣAәA{A
A=qAA\)AGA\)ApAHAܣAffApA=qAffAA33AAA
=A{AٙA  ApAA33A
=A(A\)AApAGARA(ApA
=A  AAA{AffAAGA뙚A\)AHA(A֏\AָRA=qApAAffA
A  AAׅA  AAA=qAHA\)AθRAQAzAQA  A\)A33A=qAAHAffAA
A
=AܸRAѮAAQAޏ\A=qAAAQAGA\)AʸRAʸRA=qApAHApAAΏ\A{A
AϮAA\)AAHAGA{A
AA(AиRAA33A33AAۅA33A(AAAԣA
A癚AzA  AffAQAGAA
=AAffAٮA  A  AQAAAA  AAҏ\A֣AAffA
=ApAA
AHApAA{A
=ARA\)AQA=qA=qAٙA  A؏\AAAGApA
A(AzA  A(A
AffApA=qAzAA
AzA{A33AۮAۮAAApApApA
=AffAծAхAApAԣAAՅA  A=qAGA
A33Aڏ\AHAAA  A
AAAAAAA33A\)A홚A\AᙚA\A=qAffA
=AAۙA=qA
=ApAffAA
A
=AAAA\)AGA  AAQA
AffA
A  AGAHAA{AQAAA(AffAAAApAHApAA
=A\)A
A33A
AЏ\A
A
=A
=A׮A\)AAHAA{AA  AԣA33ApAԣApAڣA=qAAffA߮AA=qApApA
AиRA33AHAA{A\)AA
=A33AA(A
=ApAA33A  AAApA{A33AAAzA
=AAA=qAzA
=AA߮AܸRAڏ\AA=qA\)AٙAAApA
=A
=A\A
AAAAAAzA=qAAffA(A=qA
=A  AٙA33A
AzAzAAA=qA
=AA
=AzAƸRA=qApAHA
=AģAȣA33AAzA=qA
AA(A
=AθRA(AQA{AzAzAAAA{AzApA=qA  AǙAǙAAAAУA=qA݅AA{AۙAzAGAϮA33AƏ\A{A{AڣAڣAA33A
A  A{AAŮAAA{AυAͅAffAAGA(A
=A噚A\)AApA{AAAQAAA(AA
=AQAA=qAffAAңApAHAA=qAɅAA33A  A(AA\)AGA
A(AAQAzA  A=qA
A{A  AHAA
=AzA݅AA{AՅAAəA\A=qAA(AA
=AAHA
AۅAЏ\AA
=AzAΣAQAzAApAHAAHAAGAݮAߙA33AzAAHA{AGAQA\AA(AڣApAA\AA(ApA(AGApA  A=qAHAffAffAAQAAAAAARAGAHAAA陚A33A
A  A(AAGA  ApA\)A\AQA(A  A\)AAA
=AA\A  A
A
AARAffAffAQAzA\)A˙AAՅAA(AAHAQAٙA(AAĸRAظRAA33A(AApAHAAA=qA=qA33AAGA\)AHAzA
=A=qAA(A(AGAGAA
AAA뙚AHAzAAA(ApApA  A
=AA  ARA  A
AzA  AAA
=A
AA陚AA\A\ARA\AzA\)A  AzA
=AzAAAAA  A(AGA{AGAzA=qA(AAQA\)AAzA=qA홚A
AQA  A
AffA(A\ARA\A33A(AAA
=AA=qAAAA\A{A
AA=qAAAzAARA  AzA
A
A33A
=ARAHA=qAA  AAA=qAffA\)B\B{BRAAAHA  AAA{A
ARA  A
AzA33AB 
=B BBRBpBB  B\)BBzA  AHAAffAHAAAAAffARAQAAA뙚AQAQARAAHAA
A
A  A(AA\)AQAAffAA\AAApAffAAApA(A
=B
B BpA(A{AffAAAA
AffAGAA{AAAAzAARApAAA
=AffA
=A  A33AGARAA
=A
AAAAAffAAAApA=qARARAGAAGAffAAzAQAAAAA\AQAAHAA33A=qA{A  A=qA
=ApA
=A㙚AA33A(A{AGA
=A
AA{AffA{A(AffAHAA(A{AHA
AGAzAAAAffARAzAQAԣAԏ\A{ApAׅAzAA(AzA\)ApA\A{AGA  AARAݮAAQAQAٮAУA
=A
=AޣA=qA=qAAGAHA{ApA=qApA߮A\A=qAݙAAHA׮AA  AمAܸRA
=AA޸RAHAzA=qAzAԣAԏ\AҸRAͅAԸRApAңAٙApAffAffApA33AمAQAApAAGA{AəA\)A
A{AHAď\AzAAͅAхAѮAffAffAAA(A=qAGA
ApA֣AzAۅAQAApAA֏\AAGA׮A
A
A{ẠAȸRA33AAAA  AAGAAAAA£AAHAAGA(A
=AAA(AA̸RA
=A\)A=qAGAAHApAAAA\)ARAzAAAffAAAA
AQA(AA33AAffAA=qAAHAA\)AÙA  AGARA
A
AGAAAApA{A=qA\A(A33AAǙA{AA(AA\AzA\)AGAAA33A\A  AA  AHAAAQA(A
=AGA\)AA
AA|AK
=ALQAGA#A
\A A
A@GAzA+AFffA!AQAPAYAV{Ao33A]pAr{AAA
=AA(AA\Ah  Aj{Ak
A\QAQAT(AS
=AZ\A]pAT(AG33AMAXAc33AdQAg
=AlAbRAd(AS\)Ag33AkA~RA  AzA
=A\ApA33A\A
A33ApA33A{A{ApAAHAA\)AAA  A\A\AA\)AApAA  AzAAHA~=qAA
=AAQA\AAAffA\)AAA{A  AHA(A
A\)AAA
AA\)AzA=qAAGAARAAAƏ\A\)A\)AAAAAA=qAA?AffAAA33A陚AffA  AHA\)AAHAzAAA
AAAA  AA(AڸRAAApApAffA\)ApA
=AAQA  AA֣AHA(A
=A
=AzAApApAGAffA{A  AzAA33A\)ApAGA=qAAffAAA{AGAARA
=A뙚AzA33AGAHAzAzA  A{AA  AA  A33A
ARAA\)A{AGAAAܸRAA\)AA噚A
AAA݅AAۮA
AGAA癚AAAAQAAA\AAffAGAA=qAAAQAGAGA{A33A(AأA=qA33ApAޣARA߅AӅAA33AՅAAQA(A=qA癚AAzA(A噚A
=AAApApA
=A
A
AݙA(ApA33AҸRA  AAAA\)AA\)A33A陚AzA
AΣApAQAAzApB zAGAApA{ApAHApAffARAAAGAAzA  AAApAHA
=AApA{A\)AˮAA(AA
=AAAȀ\A=qAAzA33AAQAA=qApA33AffAAHA33AAŮAARApAAڏ\A{AAمAffA\)AAA33AGA
A݅AHA\)AA
=AGAQA=qAAA  AۙAAAAA  AAܣAޏ\AzApApAAA\)ApAA\)A  AGA\A  AAAzAA
AARA33AAHAAQAGAۅAA\)AٙA  A33AظRA׮AQAיAffAծAGA33AHAHA{A{ApA  AA33AծA  A=qA
A(A{ApA33AîAQAffA͙A  A\)AңAЏ\A\)AAAARAAAٮARA
AAAAܸRAAARAߙAffA33AAAיA׮AׅAAՅAA(A噚AAA
=A(A  A
=AA=qA  A
=A=qAGA
=AHA33A޸RA=qAHA{AŮAffA  A33AAՅA
=AAAݮAA33A\)AAAAأA(A33A
=AθRAAffA
Aԏ\AffAHAAA
=AA33AAȏ\AApAA\A\AA
=AQA  A\)ApAHAծA(ApAA33A\A噚A(AzA
A
=A\)AԣApAAٮApA  A
A=qAӮAA\)AAAAffA{AAAAAA\)A33AϮAڣA\AA{ARAAA\AAffAGA
=AGAAAffAΏ\A\)A(AzAޏ\AAA(A{AQAңA
=A(Aҏ\AAApA=qAָRAAָRAAQAAAأAAzA\A(AzAۅAAGA(AָRAA=qA=qAAHAA\)AAA=qAA(A=qAAޣA  A
=AۮA=qAAA  AffA\AARA\AA޸RAAzAָRAGAA陚A33AAA{AA33AzAHA{AAAQA
AA33ApA(AA  A\AAB\A=qA(B QAAARAAAAzAAA(ApABBBQBHBBB=qAQAARA
=AHA
=AAAA  A\)A=qA\AAAAHAA
=ARAARAAAGAAA
=A
AffA=qA
AA  AHAAA33AQA
AA
A=qAzA
A
=AzAA
AAQA{AGAQAAffA
AzAHA\AAHAffAA{B HAGAAHAGA\AAzA\ARA\)A=qAzAA
=A癚A(A(AAA\A33AffAHA陚AzARAA\ARAA\AAA
A{AB AAAQA33AAffApAAGA(AAQBBB =qAQA{AGAQARAAQAQAAGAGAA\)AA=qA=qB\)B{A
=AA\AGB ApA  ApAQARAAGAA\)A
=AAAApAA{AB \)AAA\)A(ApAAHA뙚ApARAGAAAGA\A  A  A
=A=qAHA
=AHApAA33AAffAAAA33A  A֏\A
=A(A߮ARAAA
A=qAffAAzA  A{AAAAAAAHAQAzAA  A
=A\)AA(AQAzAA(AHApAQAAzAffA\)A\)AQA33AAAzAAffAA
AA
A  AA  AA
=AffAzAAA\)AܣA33AڸRAAzA33AGAA
AHAHAA  AAHAAHAA
=AHApA\)AܸRAffA
A  ApAAQAޣAAHA
=A  AzAAApAGA{A  AHAAAAGAQAA\)AA=qAQA33A  AAAHARAAAzAQA33AAAApA=qAGA\AAAA\AAAHAAGAGAHAAA=qAHA陚AA{A
AGAAHAAAQAA=qA=qAGAAHA
A  AffA噚A噚AAffA
=A
=A\)AA(AzAffA\)A
AHAA(AA
=ARA33AApARApA{ApAffAAA  AzA=qAGAA\)AAA
=AAHA(A\AGAA(ApA  A=qA{A
AA{AzAAA33AQAGAGAAAAzA=qAAHAApAAٙAzAffA{A\)A\AAA=qApAGAAڣAAأAHAQAAQA
=AGAAAˮAGA(AAҏ\AѮAңAffAߙA33AݙAHApAA홚A\A\A\)A  AA{A(A(AA=qAHA{ARA=qA\)AٙAəAHA\)A˙ApAхAAHAģA=qA\)AHAGAۙA߮AAAGA(AAA(AA(A\A  A  AA{A(A  A(A=qAAAA  A=qA\)ARAAGAHAQA  A33AՅAGAAffA
A{AA33AApA\AAHAAffA  AAA33A(A
AzAQA\A\AGA=qA{AA\)AAA33A33AхAHAffA\)A  A\)A33A33AA
=AAA(AffAAHA{A  ARA{AA陚AffARA\AQA
=A=qA{AffA33AGAzA33ApAHA  AGAQA  AAzA(A  AzAAGA
A
=A癚AA܏\AA\A(AAQAA
AGAۅAA{AA=qAQAGA{A{AQAGARAA{AffAAAAA
A\A{AAAzAAzAA=qAAAAA
=AA
=A\)ARA
AARA(A\)A
AffAAzAA{ARA\ARAGApAA
=AzAAAffA\)A\AA
AAA
A33AGA(A  AAHA{AAAA\A(AGA\A\AA=qA33ApAAffAA\AHA
AAAQA(AzAzAA=qA\)AA{A{AzA33AAAAA33A
A  ApA(Aڏ\AۙApA
A33AffAAAHAGA  AAApA  AzAQA=qAffAGA{AHA=qAAzAA=qA{A33AA=qA㙚AA噚A  AffA33AAffA֏\AׅAzAA
=AzAGAQAARApA{ARAAA=qAAGARA  AAR?pA{AA
AAffAffARA=qAAA
AA33AARAQA=qAA
AHAA噚A33ARAAAAHA33AAA\)A
=AHApAA  AffAAAHAGAٮA{AQAzAA
=AQA{A\)A  ARA\)A  AA  A\AAGA=qA(A{AAA
A  AApA
A{AAAHAAffAQAA33AAA33ApAAHApAAGAAAQAA\)AAA(AzA
=A
=ApA
=A  A(AәA
AHAхAzAәAHAңAӅA֣A
A֣AGA33Aԏ\AAAϮApAծAAƏ\AGA{A̸RAzA=qAzAAQA(AAQA  AffAA=qA33A33AA\A{AQAHAARAָRAۙAߙAׅA
AzA33A  AA\)AzA
=AƏ\A33AffAAHApA  A{AHA
=Aȏ\A
=AAQA
ApAǙARA
=ApA(AHA(A
AQAAffA33AA{A{A{AAAծA
=AA
=AՅAԸRAHA
A=qAͅȀ\A
=AQAA\)A  A\)AAApAHAGA\)AGA͙AAՅA\)A\)A(A(AͅAQA  AzAHA{AA\A\A\)AHAəA33AzA͙AŮA\A
=A(A\ARA¸RA33AzAď\AAAAA
=A  A(ApApAzAAGAffAA(AAA  AA=qA
AAffAәA{AffA߮A(AA33AGAffAA
AGA33A
A£AģAGAffAA\)A  AΏ\AθRA
=AϮAϙAA\)AυA\)AffA{AAͮAApAAAzA{AffA
A(ApA
A׮AHA=qA33A\A33AAAzA  A33AAHARA(AΣA
A  AA˅AGA(AffApAAGAHAAGAAGA33A{AzAzA=qAHA
A\)A\)AAˮA{A=qAǅAffAzA=qA{AAffAHAffA(AA{AA
A{AQAffAffAAᙚA{ApAQA{AffAߙA=qApAיAǮApAAʸRApAffAQAAAHA=qAHAzAffAA݅AffApAQA33AHAٮA(AָRA\)AQA  A\AAAQAAA(AۮAٙA  A=qAԏ\A
AApA33AAѮAAAHA=qAۮA=qA  A{AAڸRA\)Aڏ\A  ARAAHAGAGAA
=AzAمA33AA\)A{A߮AzA33AAA33A33AA=qAAzAѮẠAAA  AGA
AǙApAffAHẠAAŮAƣAAƣAA{ApA
AQAΏ\AծA
AGA(AA
AΣA33AҸRAzAzAٙAQAA=qAQA33AAffA=qAAڸRA
AיA؏\A׮AAzAиRA͙A33A  A癚AA
Aʏ\A{A{AAAΣAQA͙A33AA
A
=A
=AAAAAGAA33A(ApA=qAHA  AzAAAARAGAљA{A=qAzAA
=AAHAA
AУAffAffAҸRApAGAA33AѮA
=A
A=qAޏ\A(AQAHAAAAAGAܸRAzA  A{A=qA\)AzAA  ARARA{ARA㙚AAA
AA(A݅A=qA33AݮA=qAQA\AffA  A{A  A噚AQA
=A
=A(AمA=qAAGA=qAAApA\)AޣAAffAٮAGAΣA=qAAAGA=qA˙AAȸRAffA(A=qA
=AGẠAHAϙAffAA(AϮAA\)Aҏ\AңAAǙAAA33AffAΏ\AApAQAA(AzAzAAAA=qAAϙA׮AۅAHApAGA\)A{AQAۙA(AظRA  AAApA33A(A
=AAGAԸRA=qAۅA֣A
=AܸRA׮AHAQAԣAҸRAԸRA33A{AGAA  AGA
=AGA
AGBzARAHA\A\)AHAHA
=AAQApA=qA\)AAAAQAA\)AHAA=qA\)AzAߙA݅AHA
A\AA
=AAA\)AAAA33AHAAQA\)AծAffAծAԣAGA  AمAHAAAA  ARA\ApA(A\)AGAGA(A  ApAAQA
ApA  A{AAAA޸RAٮA(AHAAQAAAܸRAA{A
A{A{AAGA=qA=qApA{A\A33A
=A\)AA=qAAQA\A\)A\A33A
=A  AHAݙA
A݅Aޏ\Aޏ\AHAA\)AٮAۮApAHAAQA\AGA\A(AAffAzAzAAAAGAAAAAAA
AzAQAAAGA(AQA33AffAA
=AA33AA{AARARAAHAHAffAGA(A{A(AQApAHA=qAA\)A߮A޸RAܣAAAAHA޸RA33AQAHAڣA33A\)A  AA
=A(A(AAӅAA{A\)AHA33AGA\)AGA
=A
=A
AzA
A
A  AGA
=AԣA؏\A33A
=AԸRApA
A
A֣AzAzAָRAAHAָRAיAAҏ\A(AA̸RApAHAzA{AQA{AGAQAA  A(AϮA(AQA{A
=A噚A{AAffAAHA=qAAHAܸRAHA(ARApAA{B=qBRAQAA癚AzAHAA\)AApAHAA
=A
=AA޸RAAHARA\)A
=A߅A33A(AمAAAA
A{AAzAAυAHAAffA{A33Aʏ\AzAA\)AQAٙA\)AffAָRAGA  ApAAffA\)AffA(AQAׅAԣAծAAȣAəA33AQAzAGA
A=qAffA㙚A
=A\)A
=A\A(AffAzAA(AAA=qAAAA(ARAHA\)A33A陚A\)ARA33A  AAGA33AzAA
=AGA(AGAAAA\A\)A\)ARAffAARApAAHA(AAzA׮AGA
=AQApA{A
ApAAzAAzAA  AA{AQAQA
AأAzA  A{AAzAمA(A\AffAљA{AAHA(AzApA
=AAA
=A33AGAzAA
A33A=qApAA(AARA
=AHAHA\A=qA33A  AAAAAAGA(AA
=A
=AA33ApA33AQB zAB QAB{A  A  AAffB {AApA=qA
=AGA=qARAGAAA=qAHA
ApAA{A33ARAA\)A\ApAA(AAA  AHARA{AQAA
AA{AHAAA\)A  AAA  ARAzAAAA\AHA=qAiAs33A(A\A
A(ARAAz\Ao
AlArHA|(AZRAo\)AW\)AAA5GA9AFHASATzAxQAAQATzAhAk33AA~HA|  AHA(AAzAApAAAHA  AffA  AffA
AA33AAGA33AAzAxzAz=qA
=AGAAAQAA
=ARA33A  ApAzAffAQAA
=A33A
=AHA  AָRAA\AAzAԏ\A=qApAAA{A=qAffAAGAARAA
AA=qAffAAAAA\)A(AAAApAApAA33AA  A=qARApAA{AA\AApAA{A\)AzAA¸RAGAffA\AAAGAffAzAA33A=qAAQAA  AAAAAA{A\ApAzA33A
=A33Aޏ\AffAA
B
=BB
ARBBB  A\)ApAARAA\)A噚A噚AAAAA
A\)AA̸RAǙAAGA  A33A{AffA=qAQAHA\)A\)AA\)AͮA\A{A
=A
=AHA\ApA(A  AA
=ARAA
=AA(AffA\A(A=qAAzA
=A\A
AzAGARA33AA\)A(AA(AGAQA
=AAffAAAGA(AAzA\)A33AřA  AA
A  AAAAffAzAѮAҸRA33AA(A
AGAAA(A
=A
A  AۅAۅA
=AApAAAA
=ARA\)A(A
A\AAÅA{A=qAAA
=AA  AzA
=ApA\)A\AAApA=qA{A  A
=A\A\AA
=A
A  AәAأA  A=qAA=qAHAGẠAHA
=AGAHA\)AAHAffA
AA
=AzA  AffAA\AAAffA=qAծA(ApA{A߅AffAΣAAHAA
=A33A
=AzAffApAAAA
A=qA(ARAAAffA(AffAAGA\)A
A  AΣA(AGAGA33AHApAAQAffA  A  AAA  A
=A\ApAffAQAAģAɅA\)AQA{AA=qA33AA33AAA\)AAARA(A  AA{AQAffApAGAÙA
=A33A(AzAʏ\AAAffA(AAffAÅA\)AQA
=A=qAAA
A{AAՙA
A=qA߮A  AAAAA=qAAffA33AzApA  A\)AHA
AAQAAHAAffAGBBAzAApAAAAA\)AApAA{AA܏\A֏\AzAA\A֏\AffA(AA=qAffAУAAffA
=AApAͅA\)AAיAݮAAGAɮAAzA{AǮAHA=qA33AA  AAQAQAAAAAA=qA\AAGAͮAzAzA=qA=qAA\)AAAGAAHA{A  AǙAQA˅A
=AzAAAffARARA33AA  AGAzAAA(A\AAHAHA33ApARA=qA
=A=qAA(AffA=qARAAARAAA=qAAҏ\ApAffAAAA
=A\AA(AΣAGA33A(A=qAAAθRAẠAʣAAGAAͅAHAˮA  AəAAzA\AApAЏ\ApA  AAřAAأAݮAAA  AϙA
=A{A=qAApAQA\)AAA\AAA  AAAffAGA\)AƏ\AڣAȏ\A\)AAծAיAҸRA=qApA؏\ApAיA\)AңAA33A{AA  AA=qApA(A=qA{A33A
A
=AA  AAGAAA(AۙAܸRAAυAAAAffA\A33AAA\)AA\)A\AA
=AAAAzAzApAA\A=qAAA
AmGAffARA
A(A\AA
=A
=AmA|  Ax  ArHAZRAiA`A]pAbffA\(AeAlAW\)AVHAIA^RA{
=A
An=qApA\AARA\)AHAGAHAAz\AAAGAAGAQGAAGA1pA A   A,  A"\A-A$  A
{AzA@{@(@{@ff@R@RAGA  AA(AAzA=qA$A%A-A1GA5A4A4A'A:=qA>=qA9A9A=GA1A0zA3\)A6=qA<A=pABRA@A3\)A!pAHAQAAA=qA(AffA(AAA
A\)A
RAA\A&=qA9GA;\)A?AC33A`  AiAYpAG\)A[33AW33AmAX(AaAffA:\AxzAA;
=ATAd(A
AA
=AA  A\A\)ApA(AA33A=qAZRAS\)A~RA{AAA
AAAzA{AAHAGA
=AGAA
AHAffA(AA\)ARA
ApAQAAAAA{AffA
AzAA
AA{ApA  AAffA  AffAA33A
=A\A=qA~=qA(AA\)AAA(A~=qA|A~{AoArRAuAv=qAAHA\)ARA
=A33A
=A{AQAA
=AAAAzAzffAAA\A
=ARAAAzA
=AA(AHA
=ApARAzA=qApAA{A\A{A  AAQARAAA\A  ApA{AA
AffA=qA(AARAAA{A33ARAA  AApAAffAGA{A
AzAQA=qAA33AɅAA=qA33A
AAAQA݅A\)AٙAA(AGAzA=qAȣAQAAQA
=AzA  AAffA  A
AffA\)AAA\AzA=qA
A33AA33A
=AAA
=AQA  AA33AHAA{AAHAzA
AAЏ\AAzA؏\AңA\)ApAHAՙA  AAQAGA
A
=A{AǙA˅AȀ\A
A  AzAQA=qAApA{AQAHAA\AA
=AA  AAɮA{ApAARA
A(AA33AHA{AHAzAAffAGA=qAffAAzA{A
=A(AzA=qA
A33AA=qAA  ARAAAAHAApAAAAAffA\)A{A{AAGAHAA{AA\)A\)A\AAQA33AzAA
=A33ARAA=qA{A=qA=qAffAA{A
A  AzAAA33A{A\)AA33AAA=qA  A\AzA=qAAAA{AAAA
=AHA(A\)AAAHAApA=qAARAAAQA\AGAA=qAAGAHA\ARA(AApAAA\)AHAQAHAQAAHA33A(AAAAffAffA=qAA
=A33A
=AA
=ARAAHAApAAQAA\A33A
=A(AA  AARAA=qA(A=qAAAAApAGA{AA\AzA\ApAAޣAAA(A  AQARA(AA(A33AA(ApAAAQA
=AAA
A\AAGA33ARAA{AzA\A  A(AAA
A=qAAAAAGAA33A\AA\)AQAAׅAȣA=qAffAHAHA
=AHApA˅ApA\)A֏\AGA߮A=qAHA(AA
AAA\)A\)Aď\A=qAřAď\A  A\A
=A=qApAQApAA\)A\)AAAA
=AȸRA=qAəAAffA
=AGA33ApA33A  AAGAAApA=qAA=qAzAA{A\A=qAHA  AAAzAQA\)AApA
=AAA  A\)AARAA(AARAAA\)AAAQAəAAәA{A=qAAAGA(AîAffAA  A33ApA  AיA\)A\)AzA  AAzAffA33AͮA33AHAffA
AA{A
=AŅAʣAffAAGA{A(A陚AʸRARAAQAA33AffAA
A\)AǮA\)A\A\)A=qAܣAHA33A˅A
AA͙AÙAA33AHAAGA
AA33AzAGA\)AApA=qA
=AffA(A
AAA
AAA{AARAHA  Aȏ\AAzAffA  AA{AAAAffA33A(Ȁ\A˙AGAQA
AAģAffAÙAAAGA\)AǙAAHAQA33AA(AAffAAAAAGAffA
A(AGAәAAA
=AHAәA(A(AљAΣAHAͅAApAٙAՙA  AՙAHAAAAAffA(A(A{A33AA{A(ApAAQAHARAA=qAQAA(AAGAA(AAAHA  AAA
AGA(A33AAʣAҏ\A\)A(A݅AՙAԣAAQAȏ\AAAA
=Aď\AA{AA{AǅAA{AȣApA33AAHAHAGApA{AřA˅AGApApApA\)A
AGA=qAHAffAQA(AHAAQA\)ApA  A=qAA\)A(AƸRA=qAAAQAGA
A33AffAAzA\)A  AÙA
A33AģA\)AA(AApAAzA(AzAffAApAAAA  AHA  A  AHAGAApAARA{A(A
A=qAAARA{A  A
A{A
A33A33AٙAQA\)AӮAѮAAGA{AAzAA=qAAA=qAA
AApApAGAޣA=qA(A
=A
AA  AQAظRA
=A(A  AGAAffAAffA(AAA
=A33AA
AƣAQA
A
=AģA{AAÅAAQAAÙA33A=qA33AGAAAAA(AAQAGAGApAQAA
=AffAAAHA=qAA  A{AffAݮAA
A
=Aޏ\AڸRAGA  AGA
=AAʏ\A{AffA=qAȸRAffAQA
=AGAzAAzAAzA33AQA\)AܸRA  AA\AAAȣA(A{AffAӅAGAGAffAAѮAƸRApA(AARA{AAAAzAzAGA\)A33AzAA\)AÅAĸRAAA
AA(AAAAffAǙApAƣA{A\A33AA{A
=AAAǙA˅A
AAGAQAѮAA33A֣AָRApAхA
ApAأAיAffAңAAGAQAͅAGAʏ\A=qA=qA=qAȣAȏ\AAzAQAָRAA(A  AAAzApAffAܸRA\)A޸RA{AGAڣAمA\)AAzA
=A\)AAAA=qAzA{AGAHAHAA\)AzAHApAAAHAŅApAѮA{AAGAA33AA{AڣAA{AA{A{AAA33AA=qA؏\A\)A33AAHAGAAƏ\AŅA=qAARA33AǙAǮA{A  AQAA  AAAA\AAGAAîApA  A  AQAAffAzA33AӮA=qAA{A
AGAۙAA  AAAΏ\AAظRAQA
=ApA\A  A{AAиRA33AיAHAQAAAAΣAA(ApAA{AAAAAAAARA
=AAHAAAGAzAAA
=AHAQAAA
AAA{A
=A{A(AAGAAHA=qA(AApAA{AA  AAA=qAAffAAzA\AA  A\)ARA\)A
=A\A(A33AuAf\ARAAA
A}AA\AA\)A
=AGAffAffApAAAAAffAA33AffAffA  AA\A33AHA=qAHA33A
AAAAHA
ARAAAA
=AAQA\AHAGAzA{AAAAAAAAGAQA  AffAAHAQAA\)AA
AQAAzAA
=AAARAAͮA=qApAA33A\)AzA=qAAffA
AA
=AHAA{AHAˮA
=AAHAA
AָRApA33AA
AHAAAхA
AЏ\AθRAzAAHAAA33AȸRA\)A
=AθRAGA̸RAHAAAǮA  A{AəAAAAɮA{AGAHA͙AAffApAQAԸRAAǅA
=ApAA\A  A\)A{A(AAA\A33AǙA\)A  AA{A
=AA=qAARA{AQAzA  AAA
AAAGAAAAA  ARA(AA(AA=qAA=qAAHA(ARA
=AAzA
AffAхAzAɮAffA˙ApAA
=AAHAA33A33AA{A{AHA
AzAܣAӮAApAApA{A(AHAzAŮAApAAAŮAA33AAHAΏ\AAHAʸRAAA(AƏ\AAȣAɅAA(A\A
=AəAA
=A{A\)AأAHAA{A{AzAA=qA
AA֣ApAAAҏ\AffA(A\)A{A\)ẠAʸRA\AApA
=AģAAGAAңAA=qAمA\AѮA(A֏\AzARAApA
=A33A(AQA=qAAGA=qA
=AA  A{A  A33AծAׅAӮApAŅA(AAAzA
AA=qAA=qA\)AAŅA33AAƸRA˅A(AAA=qA33ApAA
A
AAA\A
=AA
AA홚AHA܏\ApA(AApAHA
AAGAхApAԣAՅAAffAׅAffAzA  ApAظRAԣAAAHAAAA  AՙAA  AݙA{A  AQApApAA
Aҏ\ApA(A33AA
=AݮAՅAAQAģAzA
=A̸RA\)A
=A{AApApA\)A˅A{A\)Aʏ\A
=AffA
=A\)A
A
=AAΏ\A\)AzARAARA
=A\)ApAA  A33AAARAHAffAAAGA{AAڸRA޸RAAAAAA
=AA㙚AGA\)AAHA\)AA33AAA
=AA(AAA؏\AAzA(A
=AAAQAۅAңA
A33AQA  AffAGAHAHA  A\)A\AA  A
=AA(AA(AAA  AAA(AAzAA\)A(A  AGA33AA  AffAffA  A\AA{AHA\)AHAŮAAAHA
A=qAA(AA\)AffAAHAAAA=qAHAffAAGAA33A
=AApA\)A\AQAffA{A\)AARA
AAGApAffAzA\A33A  A(AffAA=qA=qARAA=qA=qAAAARA=qA  AQAQAA  AA{AA\)AffAzAzA=qAAQAAffAzAAHAGAA
AAA\)A\)A
A֏\AA33A׮ApAAHA  ApAЏ\A
AzAffA֣A=qA\)AиRAӮA33AffAʸRA  AGAffApAA
=AGAAzA\A
A=qA33AAA(AA(A(AA
=AzA\)AAAAңAzAzA
=ApAGAHApAAƸRAǮA=qAARAÙApA
A  A{A\)ARARAAAAAA(AAHAA
AzAAQAAGA\)A{AARAAApAGAA
AHAA\)A\)AHApA
=A\)AQAA
A{A
=A{AָRAffA
A=qAffA
A(A  A  ARAAAθRAAŮAƣAGA(AǙAӮA
AAffAA=qA=qAA\)A\A׮A{A{AAԸRA׮AљAڏ\AQA  AGAffAۅA
=ApAA=qAHA33AٙA
Aޏ\A
=ARAffAGAA  A̸RAȣAAѮAAѮAЏ\A33AA\)A{AAffAљApA=qARA¸RA
A{A\A\A\)AzA(AHA\)AA\)A܏\AA  AA\)A=qA33AAAffA{A33AGApAA=qAGA{ApAHAA  AHA(AApA
A33AzAîA\)AHA݅A\)AA(AA噚A\)A
AAQAQAA  A=qA
=A33AأAAۮA
=AffAQAHAәAAGA{A
=AQAAAA(A
=AHAAffAAApA{ApAzA
=AϙAQAA{A
A\)ẠA33AQAffAAңAHA33AGAQAAAA\A33A\)A{A֣AծA33ApA\)ApA\)AAQA
AA㙚ApAffA\)A(A{AAAzAffA܏\A\)A=qApAمA{AծAAՙAAAAQA(AHA(AQA
=A  A{A
A\)Aڏ\AAܣAAHAzA=qAQAɮAA\)A
=A
=A
=AzA=qA\)A\)A{A֣A
=AGAָRA33AָRAיAAA؏\AA\)A㙚A(AܸRA  ApA  A
=AAffAAAAAzA  AAۅAA(A=qApA\AA  A噚A\A\)A陚A{A\)AzAA(AAծAAAԣA(AᙚAمARAA  AGA
=AAޣAGAzA=qAӮAՅAAQApA
AQAAA{A=qAzAA
=AA{AAAffA
=AAA͙AљA=qA\)AָRA=qAڸRA{AQA=qA=qA{AǅA  AAHAAمA{A  A
A{AzAAљA{AQApAffA=qAיAͮAzAffA33A  A  AGA\A
A
=ARAAHAA{A݅A
A=qAܸRAAA  AQAۙAڣAAA
=AAأA
=AمAffAߙAHA
Aԏ\AHAA{AQA33A׮AA\)A\)A
=Aڏ\AGAA
=AՙA؏\AՙAAAQA
AͅAͮA{A͙AAGAA(A
=AHAңA  AffA=qA{AϙAQAAAAׅAAA(A
=A
AA\)A33AϙAAQA\)A=qAA33A
=AAAAޏ\AAA{AA{AA(ARA(AAffA
ApA\)AzAأAمAԏ\AأA=qAAHA
AAׅA33AУA=qAffA݅A\)A(AޣA{AAAffA
A  AApAA  AᙚARA
A{A{AHAAAApAAAGAQA
A33AA=qA(A33AʸRAA
A\)A  A
=A
=AAAQA\AHAHAApAApA֣AffAхA
A
=A(AGA\)AffAAzA\)A\AAA
AAzA\)A=qApAQAGA  A33AAA33AAGAffA\AHAHAQAAAHA=qAHAApAAAGAAA(AA{AAA
=AQA{AAAAHAA
=AAAQAAz{AAffAAHAffA{A{AQAzARA
A=qAA33A
A\)A=qAAA
AA\A}GAAz=qAl(AmAvHArffAhzAoA^RAmpAyA|(ApA\)ApAHAtQA}GAw\)AffAApAAHAA{AAAAA\AffAz\Ar=qAhAffA33AxQAyAx  ArRAo
=A\A33A
ApApAA\ApA33AAApA=qA
=AQA
=AGAQAAGAffApApA\)AAAAQAAA=qAApAAAHA
=A
=A\)AGAzAffARApA\AAAAAAGAAA  AGAQA
=A\)AAA(A{AHA=qA{AAARAARA(AtA~=qAqpAdQA_AP  ASAz=qA  AA=qAA\AAAAAA\A\)AzA{A{AGAAARA{AqGAzffAAAAHAQAApA=qA(A(AGAAAA
ApAǅAQAzAңA
AA
A\AA33A{ApA(A33AA\)A\)ApApAAA\)A{A\)AA
A
A=qAzA\)ARAA(AGAffAA(A33AAHApA  AA\)A\ARAt(A
=AYpAw
=AAAffARARA=qAAA=qAA=qApAqGACA733A<(A%GA0(A5A7A<  A@QAH(AF=qAG
AH  AJRAJ=qAXAX(AqAQA
=AHAHA~ffAlQAZHA^HA`AaAdA`  A[
Af\ApA{AGA\AAQA\)A33AAA
=A=qA
AAnffApA  A
AAA
=AAypAhQApQAX(Al(AAQARA(A  A33AAHAA33A(AAA\)Az\A|QA(AAA\)A33A{AHAA{A
AA\)ApA  A
AAǅAffAA(A  A\)A
=ApA33AAAA\A\)AARARAzAA
=AAAGAAGAAA=qA=qA\A  A\AzAffAAGAA(ApAGAffA{AA=qAA{AΣAGAΣA(AAAGAHA
=AzA{AAA33AffAA(ApA(AQAzAGAA  AA{A  AAffAAzA
AîA
=AA33A(A\)A33AGA=qAϮAA
=AծA33AffAAGAAA=qApA(A(AffAřAAA33A{AzA=qA{AzAA\)A\A
=AGA=qA  A33AzAAA(A  ApARAGAAAA
A\)ApAď\AAGAAApAffApA(AAAA{AQA  AQARAAQA{A33AA=qA33ApAQA\)A33AɮAΣAAAҸRAzA(A{A  A  AƏ\AAAAffAHAARA  A
=A=qAA(AGAîA  A
=A(AAA\)AGApAzA
=AffA(AAQA  AAffAzAHAAA(A
AAͅAffAA
AARAA(A\A(A\)AApA=qA{A33A  AzA\)ARARA  A  A(AAA\A33AGA
=AAQAGA{A=qAĸRAAAAQAAAQA\)AƏ\AA(A\)AA\)AA
AGA  AHAA\AAzAGAA\)A33A\AffA\)A{AAGApAApAAQAQAHAA
AA=qAA=qAA
=AAAAAAAGARA=qAGAA{AAA=qAzA  A
=A\)A\AzA33AAAAAAȏ\ApAAAGA\)AAAHA
=A\)A
ARA{A  AffAGA
=A{ApAAAffAAAAA{AffAffA(A
AA(AAAAď\A{AÙA33A  AÅA33AAA(AAzAzAҏ\AA
=AӮAAHA
=ARA£A{AHA\)AA
AffAQAA
A
ARAApAAzA(AA=qA33A=qAGA
=AݮA33AA\)A  A  A33ApAHAffAA
=AA(A{AA\)AffA=qA=qAffA\)AA\)AAAHApAڸRA
=AA\)AA\)A  AHAθRAA\A
=AApAAǮA
=ApApA
A˅AAHA=qA
=A(AffAAA  AHAA33A  AA\)AAA{AAHAffAQAAGA
=AGAGA
A=qAA  A\A  AAGA  A\)AApA=qAƏ\AApA
AGA{A{A  AHApA{A\A{A
AAHAA
=AAffAGAGA33AA
=A
=AA33A(AAAAAGARA\AAAAQA=qA(A{AAAAÙARA\)AzA
=A33AA\A=qA33A
A(A  AAAAͮAΣAHA
A=qAŅA
=AȣAƣAzA
=AAA33AQAGAAA{ARA=qAApA\)A  AQAՅAAAA
A  A{A=qA  AARAffAQAAzA=qAHA
AA(AA
=ApAAأAA\)AAA
=AƏ\A(AGARAApA33AQA(ApA(AA=qA\AAA\A
AGA{AAAAHAA(A(A
=A(AQA(AAzA\)A
=A(AA
AHAAAApAAGAAARAQA(A{AA\)A\AHA{A\)AA{A
=A\AAAHA
AA
=ARAzAA=qAffA£AAA33A  AHAA
A
=AAHAQARAA=qARA33A33A
=AA33AAzAA(A
A  AˮAffAGA
AڸRA{AzAApAA
A
AGAQA\)ARA
AAHARAQApA{ApA33AAǅA{A\AA\)AԣA{AمA߮A{AAzAA֏\A͙AQA{A
=AȸRAHA{AʸRA˅A33A̸RA\)AAAԏ\AAЏ\AAQAQA{AAď\AָRAAA{Aď\AQAʣAGAAzAQA
A
AA
A\)AGAHAׅAA
=AA\)AA33A33AA\)A
=AУAңAЏ\AzAӅAAAAAQAָRApAGAA
=AיAffAAΏ\ApAׅAARA˙A(A  AffAA  AHAAGAffA\)AƣA
A\)A(AƏ\A=qAA
=AٮAޏ\A(AîAAУAǮAǅAGAʣAθRAAAģARAQAAQAHAA{AA(AAHAffAffApAffA33AAGAGAAAGAffA噚ARAAHA  AA
AA\AzAApAGAHAAHAHAQA  AAAHARA
=AAAApA
A
A
=AݙApA  AAиRApAѮA
=A33A=qA33AzAzA{AׅAQAиRA=qAGAA  AA\)AAÙAQA
AAA\AŅAAAA33ARAAHA=qAϮAəAGAƏ\A
A{A(ApAAAA
A{AAA=qAAApAAffAAGAQAAGA(AffApA=qA  AffAͅAHAAAAA=qAAGAAHAAAQA\)AAzAͮA=qAGAAʏ\AͅA  AHA{AA33AzAЏ\A\)AAHA  A33AׅAAîAAffAffAzAA=qA
Aʏ\ARA33AAAHA
=AAARAGAAA\A
=A{AffA
=A
=ARAʸRA33AңApA=qA
=AQA
=AHAzAA(AzA߅AمAAۙA{AAՅAAAA陚AAA㙚A{AAA=qA=qA33A(A  A  AAffApAƸRAAȣA
A{AAQAGA
=AɅAAffAQAAAAAA\)AHAQA(A\A=qAzAA}pAo
=AqpA|QA
=AuGAxQA\A=qARAAffA  AAA(AA(AHAAA\)A
=AA
=A
=AQA33AAo\)AtA{A=qARARAQAj\A
ApAARARAzA=qAA(ARA
=A
=A  A
=A{AAApAAA
=AHA
A
=A(AQAA
=AGAA{ApApA  AAzA33AAA\)A
=A  AAHA=qARA
AA33AAAffA33AAHA\ApAffAAA\AAA33AAA{AA
=AA\)A
AARAA(A  AAApAA
=A=qAqpAqAyAtzAf\As33AvRAw33A{A  AGApA
Al  Ac33AipAb=qA\QAUAN{AJHAOAFRAG
AMAPQAPAUAWAZHA_
Ad(AgAt(A\AAAAA  A
=A{A(A{A\AARA(AHA{AAA(A{AQAA{AffApA{AA  A\)ArRAz{Ao33AbRAdAw33AdQA`A\(AA
A=qA  AA(AxA\)AApA(A(A33AA~\Az{AffAAiAqAA\A}pAzRAA\A\AA33A=qAAHAAAAqA=qA
=AffAyAA=qAAA\)AzA
AzAzAHA(AAAAGA  AA=qAQA{A  ApAAffAA  AGAQA{A=qAHAAAzAAA{A\AAzARA
=AHAAA
A  A~=qAwAQAxArRAQAAHAAQA33AA33AA  AA33AHAzAA
=A33AAffA\)AQA
=AAA  AAAffAAΏ\AffA\)AHA
=AAAHAA\ARApA{AffAAA\AAHAHAzAAzAA\)AAHA
=AGAQAHAA\)ApA\AGA  ApAAHA(ARAHAGAAHARAAHAA
=AQAAA  A=qA(A}As33AxAv\A  ApA33AeAf\AeAZRAUAipAhAw33AGAuAlQAn=qAo
Ao
Av{AvRAsAffAAAGA=qARA{AAA\AAHAzA
=AGA(A(ApAAAQAAApA=qAA
A\)A(A(AzAA\)A  A\)AAAApAQA(A33AHAAAQA33ARAAAAA33A
=AA33AARA=qAzAzAA
AQAHAA\AAAA\A
AA\AAA{A(AzA(A
=AA  A\)A
=AHAGAAA=qApA\)AQA
AAAA
=ARAAAffAΏ\AAA  AzA33A33AAď\A=qARAA=qAAHA  A{A=qApAA{AzAAAHAHAǙA\A
=Aʏ\A=qA  AA{AŮAAQA߅AzAA\)AzA\)A\A33AAУAQAAĸRA
=AzAA  AGA(AA
=AzAQAHARA=qAĸRA  AA
=AHAǅAAA{A33ApA33ARA\)AAď\A  AzAGAzAAAҸRA{ARAA(A=qAHA
AffAGAHA
=A(A\)AƏ\ApAA\)AHA(AAAQAAA
AHAA\AzAA33A=qA\AA(A\)AAQA=qAGAAA=qA\)AřAzAAɮAͮAϮAQA֏\A33AAA(AAA
A33A33A
AѮẠAȸRAGAÙA(A
A{A\)AɅA
=A
AQAĸRAA\ARAHARAAffA
=AApA
=A
=AAGA\)AA\AAQAA
AzAA˙A˅A33A{AffAHȀ\AͮA{AA(A  AɮAAĸRA{AAȣAď\A߮AQA{A޸RAffAA{A
AA33A(AffA=qAӮAʏ\AffA
=AQAffAffA
=AHA(AffAGA(A(AAģA
AA\)A33AA{A
=A(AGAљA\AHAAQA(AA\AffAGAAA\)A(A33A33A=qAȸRAəAffAA
=ARA  AAAɮAHAHAHA33AGAQAA
=AۙAAQA(AA
=A
AGAЏ\AA͙AHAAA=qA
A
=A  AAAɮAffA{AΣA\)ApA˅AHA  A
A{A
=A
AA\)A=qA33Aҏ\AƣA  A{AHAffAAA(AHAARA\)AAA{AzAHAAHAGAQAAzA(A\)AAffARAAAGAGA33A=qAQA\)AffAGAAQA(A=qARAAGA
=AAAffAQAQA  AA
=A=qAGAљAffAЏ\A  AffA{A
=A(AA{AܸRAA\)A\)A  AQAAzA
A\)A=qAAffAAA(A  AAAЏ\A\)AQAHA  AGA
ARAA{ARAA=qApApAAAffAA(A\)ApAQAffAA\)A33A=qA
=AAģAAA33AAGAGA33AQAAA
AAQApA\)A33AHA33A=qA\)A=qA{AzA33A  AυAGA  AA
=AޣAA{AHAA=qAzA
AAƏ\AAAģA{AGAAffAQA
=AÙARA£A\AģARAA\A  AHA
A=qAAA(ARAAAzAAAA{AAQAA\)AffA  AHAƣAApA
A  AA{A¸RA  AAzAQA(AAHA33AffARA=qAAHAffAGAA\)A\A
=AAA\A
=AffAQAA\)AHAA
=AA33A\)AAAzAA
A  A
A{AqAmAeGA  AAHAxzAjffANffAb=qAAAA{ARA\)AQAA  AAARAAAffAAAGAHAA\AHAAw
A33AAA\)A
=AAApA}AHAQA\)A33AffApAAAQAffA
AA
AGA(AAGAA=qAHA  A=qApA(A(A\)AffAQA  A\)A
AAGAffA
=A
=AAHARAA\AA\)AHAzAA  A\)AzAA{AffA\)A\AA(AAAffARAA\AAAffAffAAAA
=AffApAAAAqAffAAQAAAAAA=qAHA{A33AA33ApAyAzA\AApAA
AAHAAApA(AA{AA
=A33AAzA  AA\AQA
=AA\AAA  AffA  AHAA
=A  AŅAHA
A  A(AApA33AzAzAffAffAƸRAAzA
=AAGA(A=qA(AAffAffA  A\AQAHAffA=qAÙAHAAAAzAGARAљA{A(AHAA{AHAGAffAA޸RAʣAzA\)AA
AمAәAApA=qA=qAA
=A  A{A  A
=AAAQA33A
=AAARAݮAӮA{AAffA͙A\)AA=qAAAHAڏ\A߮A
A{A33A  A{A33AQAHAAңAڏ\AGA\)A  AиRA\)AQAffAřAAA{AGApAA(AAHARA33A
A  AAAffA
=AQAĸRAQA=qAиRA33AAAA33AυAծAиRAA33AHA{AՙA\)AA
AHA33ARA\)A
=AڣA33AAׅAיAۙAAAzAA(AA
=A
=AAAۮAAApA33AzAGA
=AAУAӅA؏\A֏\AA\)A33A  AHA\)A
AA
=AߙAݮA\)Aʏ\AA33AffAңA(A=qAA\)AυAAffAGAӮAffAzA
=ApA
=A33AיA=qA33AʣAA͙A
AA(AծA(AA\)A{AzARA  A33A\)AHA\Aޏ\AAQA(AHA\)AޣAAGAA޸RAzAAAAAAzARAzAGA\)AA33AQAffAAAA{AAHAAA  A33A
AA=qAQApA{A
ARA\A\)AAA\)AHA\)A
=A
A{AAzA
A
AۅA33AיApAңA33A߮A\)A=qA㙚AffA\AHAՅAAffAAٙAÙAŅAffAAzẠAARA(AҸRA\AQAARA=qAffA
A33AAAAHAGAffAHAAޏ\A(AAAAA\A\)AGAQApAApAHA׮A
=ApAzA=qAׅA{AܣApA33ApAAffAffApAA33A{A  AA(AA癚A
=A
=AۙA=qAGARA{AA\)AA(A\A{AAQAHAܸRAffAͅA  ApA  AԸRA\)AzAAA(ApAAGAڣApApA=qA
AQAAA\)AA33AAA㙚AQAA\A{A\AAA\A33AAARA
=AQAGAAQA{A㙚AffAffARAAGAQA=qA33AAAHA
=AA
A(A33AA33ApAAffA(ApA  A\A  AAAHAAAffA\)B {AGA33A{A33A(B\)AAAA33B GARAffAA
=A\B(A\)AzA
=A{AA=qAA\AAA=qAA  A
AGA\)A
=AAQAzAAA  AAffA  B BBBHBB
=B (BpAzBQA  B(B GA{AB =qABQAffARAAA\)ARB 
=B ffB   B =qB pApB\)AA\)BB GB B HB B HB  A{B QB \BBBA
BQAAzABGBB HAffA
=AAA\)ApA\AAA\)AAHB B \BABffB pABBBBRB
=BB  AQAB(BpABzBQBzB=qApAARAB33B(B\)B AAQA
=A
ApAA(A{AAA
AffA
AAGAAA
=A  A  AB 
A\)A
=B B 
=A
=AB {ARAGA\AAAHAAB QB B33B(B B 
BffAQA{A
ApAApAzAzAA33A
=AHAApA߮A\A  AAzAAHAApA(AAGApA  AAB \BBGBGA
BzB
AffA\AA
AQARAA
AffA
AA
=AzAAffAA\)AAzA
=AAA{A\A\AAAAA
=A\AAAA\A33AAQAAA  AAA\AAAGAAGA\)ApA
=AAA
AARApAAQAAA  A(A{AGA\A  AQAAHAffA(BpB   B  AGA33AzAffAAAAA=qAA\)A(AA
=AAQA(AA(AAA\AAAAAHAAAAGAA{BB
BBA
=AAB GAffAA{AAAAAzARAAAAA\)AA(A=qA(AAHA\)AQAGARAA\ARAA\AA=qA33AAAHA
=AHAzARA33AA\AQA
=BQB \)B   AHA=qB AB(BRBB\BBBB
BHBHB=qBQAAA{AAAAHAApA33AffAAB {AB =qAzAAAQApAAA\)B=qB ffAB   AAAAAA
AA33ApAAGA
AAA  ApA
=AHA  A
ARA(A(AGAAARAQA{A뙚AHA
=AAA=qAAffARAAApAQA\)A33A  ApAAQA  A  AAHA\ApA33B
B  BRB RB HB 
=A
AA  AHARA=qAQA(AA\A=qA
=A
=A\)ABBB RApA  A\)A33AAApAzAA
=AzARApAAA=qARA=qAAffAAAA\A  A{A\A
A  A{AAffApAAAAAAffAޏ\AHAAffA{A݅A݅A݅AA  A33AAA\)A
A{A
A  AϮAͮAAA=qA݅AڣAܣAAAffA(AڣA
A߮AHAAA  AAޣAAA\)AzAA\)A  AAAA=qAAQA\)A33A
=AA
AAA
=AQAARAAAA  AzAQAAGApAAQA(AQAAffA\ApAQAA33AzAzA=qA(AAffA{AAGA홚AAAA33A
=AAAA=qAA
AffAA  AAffA{A
=AAߙAA癚AAAA33A\)A33AApA㙚ARAA
=AAHAAA{AAAGA33AA33AAAAQAA{A
ARA\A\AAAA\AA{AGAGA33AffB RA
=ApAAffB {AHB zA{A\)AHAAzAARAffA
AAGApAHAffAffAQAAQAAA=qAߙA{AA(A=qAHAApAAffAݮA
=A  A  A\A(AAAHAApARA(AzA=qA\)AzAڣAߙAzAAGA(AܣAA噚AzApAzAAA\)AA33AAAQAA33AHA{AA
A\)AAA\A33AAHAAQAAzAA33AA(AA33AGA\A  AQAAAAAApA  A  AQA33A\)AA
=A=qARAAAA=qA
AffARAA
AzA
AzAGAffApA
=AQAzA=qAAAA܏\AAظRA33A
AAQAQA33AGA\)A\AzARA  AAAAAQAHAAffAzA
=AQAA=qAޣAޣAݙAۙAApA
AffA=qAA
A(A
A
A݅AۮAAzAA{A㙚A
A(AޣApAߙAA
AApAARAٮA{A33A\)A{AHA\)AGAΏ\AθRAGA\)A
=A˅AA
A=qAA
=AGAAQA
=A{AAffAθRAHA  AʸRAϮA(A  A
AAAٮA=qA  AA  AAۮA  A
AGA=qAA{A=qA33AAA(A؏\Aޏ\A33AGAۮA{A݅A  A\ARA\AޣAA
=ApA(AAAQAA(AAA\A
=A  ARAffA33AAAAzA  AGAAzA  A=qAHAA\A\AA
AA
AAApA
AA\A
=AظRAAGA(AAzAzAA33Aԏ\A{AA(A
=A33AA
=AffAA
AA{AAzAA
=B zBAB (AGA{AAB 
BHB pB33A홚AA
AA
A
=AA(AAARAA33AAAAAGAAffAAA\AAۅAGAA\)AQAHAGAA
=A(A߮AۅAAA33AA=qAHAHAA33A\)A
=AߙA33A\AApA
=AA  AA33Aʏ\AA̸RA£AQAݙA
=AA
=A=qAHAGAHAzA\)ARARARA  AA
=A33ARAGAGAݙA  A=qA  AzA{AGAQAA
=A(AAᙚAA=qAA\)AAA㙚A  ARApApA\)A33AAA(AGA(AAAAޏ\ARAAzAA(ARAARAA33AAGApAffAQA=qARAA\A  A  AGA\AAA\AA33AHA=qA\)A
A\)AAA
AHAAAA33AУAAA
A܏\ApAA{A
=ApAיA{AA  A  A{A=qAAߙAAAAAHAAGAAAA(A{AA33AϮA(AAƏ\AǅAAAA33AǮA
=A£AAݙA
AAffA(AA(A=qAA(AAAÅA
A=qA̸RAʣAAQA(AffAGAQA{A\A  A(A(AA33A
A{A(AffA  A
=AA{AA˙AɮA
A=qAAAA  ApAffAGA(A
AQA
=AAA33A
ApAܸRAمAzAծAffAA{A(A{AAGA  AA
=AA33ARA\AA
=A
A  AîA
=A{AAAAAHAHAA
Aڏ\AA
=A{AAA  AAQAQAA=qAGAA(AA=qA=qA
=AAAAA  AѮA(AAиRAՙAA(AffAA֣AffAˮA
=A݅A=qAA=qA(AA
AA(AĸRA\)AᙚAARA\)AHAAܣA߅AA(A=qA
A
A݅AGAA\)AAģA
=AӮA{AA{AGAAQAHA
AՅAAA\AAHAARA{A  AzA{AAHA(AAQAA33ARAGA=qApA33AAA{A=qAAA
ARAzAQA܏\AA(AAA
AAzAمApAܣAGAޏ\AGA{A\AzAA{AQA
=AQAHA
=A33AA\)A33A  A{AAA  AffA
AA\)A޸RAA(AAffAGA
=A  AAAzA
AAģA(AAׅAHAA
=AGAAAzA{AHA33A(A  AAׅAzAAAAޣAQAڏ\A=qAQA=qA33A؏\A  AЏ\A\)AљAAAAAGA\)A
=A
AQA33AA
AffA¸RAAQA=qA=qAAծA
AA
AϙAffA33AHAẠAAՅAۮAzAՅA  A(AQAA{AAA\)AAمA(AffA֣A  AAߙA(AAAHAAAAAGA33AυAzA  A
=A=qAGAƏ\A{A{A\A  AApAřAΏ\A=qAׅA
A=qA{A
ApAAA\)AAHAzAAA=qA33A
=A33AA癚AA33A\)AܸRA
=AzAQA癚AAHARA(A
=AAQAAzApA=qA{AܸRAۮApA\)AA֣A(AAGA  A
A
=A(A{AHAzA
=AHAffA33A{ARA{A
=A{A  A  A{ABAffAGA
=A(A{A33A؏\AܸRA33A33AHA\)AAAA(AܣAAQARAA
=A
AGAHAAzAAA\A陚A33A  A33AGAAzAGAA=qA\AQA
AHAAAHA=qAAApA33ARAAA홚A  AAffA{AA
=AA\)AA  AHAffAzAARApAAHApAHAABB B\AQAApA
AA=qA=qAAzA=qAA=qAAA{AHA噚AQAAA\AffAffAffA{A{AffAAGA  AHA
AA֏\AA噚A¸RAGApAA  A
=AffA  A(AA݅ApApAAzAA
=A(A=qA
AƸRAA33AQAϙA33A  AGA=qA
AAHAQAA  A
AQA(A{A(AՙAمAAA{AAffA
=Aޏ\AA33AAGAffAQA
=AGAAAAA=qA\)AffA=qAA\AϙAAA\AȣAA
AAɅA
=Ȁ\AQA33A\)A  AAGA33AǮAGA(AיAffAᙚAAA
A\)AAхAzAffA
AAQAAHAAۮAzAŅA(A\A  A=qA{A\)A\AAAAQA
A(AHApAzA33ApA=qA
=AΏ\AڸRAGAHA=qAQAffAQAAޏ\A33AHAAAʏ\A=qA
=AA
A  AΣA
=AHAQAGAѮAAAAffARA  AAffAAAAQAAAzAHAARAffA(A
A
ApAQApA
AAzA(A  A  ApAAffAffApA{AAAA
AHA\AGAAAAzAQAHAAQAAQAAAApAA
=A\AA{AzA
A  A\AQAA(ARAAAAA(A  AA
=AffA
=AA{A{A(A|  Ab=qAXATAMpA?\)AHQABHAB{AG33AdAQALAWAW
=AWAS
=ALzAG
=AN{ANHAUAL  AMAF=qAeAl  Aw
ARAA}AxQAdA8(A1pA*ffA4A@AC
=AZRAYAd  Af{A\A|ATA^ffA^ffAh  Ar=qAnRApzAv{ARAxzAzRAXQADzAW
AhQAdAApAAAA  AzAGAApA\)AAzAApA\)AAGAA(AffA
=AAA\)A
A{A33AAA(A{AAqAc\)ApAf\AJRAWAK33A<QA?
=A<(A.HA(A(@@{@  @{@(@Q@{@ə@@  @\)@@
@@ffA
A\)AAAApAAA"{A/33A.RA*RA/A0A5GA QARA\A=qA-A1A9GA;
=A@(AC\)ACA=pAB=qABRAO\)AR=qA\  A]A\(A]AXAXAr{AzRA\AffAApA33AzAA\A(A=qAAAAA\ApA
AAHAA\A(A(AA=qA{AQAA  As
AwA
=A|(AA
=AAQAnffAgA_33AxA33AffAffAAA}AA
=AA
=AA
=AAAAHAo
=AoAgA_\)AdQAvRA|QAl(Ak
AsAyAfffA{33AhAf=qAk
Ah(As
=AuGAAA(ApAAffA  AA  AA\)A
AAQAARA\)ARA\A\)AAffAQA=qA33AAA  AAffAGA33AHAGA33AA{AAAAAA
=A{AAAApApAzAHA
A
=AAAAA
A{ARAzA
A33AA
=AA\)A
AAAAA\ARAAA
=AGA  AAQAzAAQAQA33ARA=qA
=AGA{A\)AͮApAAA
=AAQAGAAAA
=AzAGAAffA\)AAA\AHAA{A(AApA{AHAffAA  AQA{AQAAzA{AʣAA=qAAQA\)AffAGAA
=AA33AA
=AQAzA\)A  A
=AAAA(AGAəAHA(ARAHA\)AA{AA{A  A\)A
A\A\)A
AQA  A(A(A
=AARA33AݮAA\)AHA噚A33A  AAHAzAᙚA\)A  AAA33AҸRAffA\)AܣAffAAzAAA{AQA\AA{A
A33AA(AAAGAAA(ARA
=AA{AңAQAHAHA˙A(A
=A33AffA
AA=qA=qAzAzAA{AܣAݮAGA޸RAA33ApAA
AA޸RAAAA\)AQB\AzBBGAAA33B=qB B
=BBB=qB  B
=BBB
=AAAA=qAApAB
=BffA=qAAzApA{AQAAGA{A  AAͅA
ARAHAARAAAAAAA(AApA=qAۙAǅAffA֏\A\AAAzA
AA
=A  AA\B pAGAAGA߅AυA  A(A{A  A{AGA  A{A=qARAAA(AQAAffAA㙚ARA  B  BBGAB
ApAAA
AAHAHAAffB =qA(A33A{A33AAQAAA\)AQAzAA33AffA33AzA=qAAGA{AîA
=AQAָRAAʸRAGAՅA  AAHAA\AޣAA=qA=qA
=AAHA
=A{A\)AA{AGA  AQAA\)AAA=qA  ARA{A33A  AAHA33AAAGA\)AGAAAHA\)Aڏ\AۅA=qA{AHA  A(ApAיAݮAffAQAAAB{B{AffAffA߮AffAHAAA\)AHApA  A\AAAzAߙAᙚA33ApA  AHAAGA  AAܸRA\)AA(A
AƸRAŅAQA
AAQAApARARA\)AQA
=AAQB   A{AzA(A=qA{AHAAAAA
=A
=A
=AAQARAGA
=A{A33AA뙚A33A{AGAA\AGB(B{A\)AA{A(AAzAAAzARA  A\)BAQA33BB=qB\BBGB=qBRApB AAA\AA\A
AAA  AAAzApAffA
=AAHAzAAzAޏ\AܣAAAۙAA33A=qA=qAHAARAɅA=qA=qAQAA{AAA\)AAGApAAB\)A
=AA(AGA33AQAQA{ApA=qAHA뙚A{ApAѮAׅA
=A{A
A߮AܣAAAHA  AAAAHA陚AApA=qAzA{AϮAծAޣA33A(A=qAAB A
BB(AAApA=qA\AGAAGAffAAAA33AAAA(A{A{A
AAAQAAARAAѮAAׅAAzAA=qApA  A
AAAzAA\A{AGAQAAffAGARA\)AAAAAAA\)AA33ApAAAAApA
AzA=qAGAffApAAA\A=qAA{AffA{A
A\)AAARAԸRAAffAָRA
=ApA\)A=qAARA
AAA\A\)A
=AA{A{AA33A(A  AffA癚A\)AA\)Aޏ\A\)ARARA
=AA
=AAԏ\A{AGA  A{AQAՙAGA
=AAffA
=AABpApAיA  A݅A  A
ApA
=A
=AffA(AGAA{A=qA
A  AA噚A噚AAAA߮A33A޸RA
AAARA\AڣAAA\ApAA
=AA  AQAAAA
AAQAAAGAHAA{ApA  AAA=qAA
=A\BpAGA  AAQA\AA=qA  AzA\A\)AAzAHA\)B zB 33B B {B \)B =qB \B A\)AHAARAffAA
A
AA=qA(A\)A33AA33A\)AQAHAA
=A33AA\A  A\B (B B pA
B   AGB {AAGApB B AGARA\)AB33AA  A{AAAQAAB=qBBQBBBAB AB 
=A=qAA=qAAB\B 
=AGAHB{B ffB 
=ARAAA\)ARAGAB zA
AAffAffAAApAA33B
=BzBAGAB
=B 
BQB QAGAARA=qAAA{AA\ApAA33AffA{A  AQAHA  AAzAA\)A=qA{A
=B 
=BBzBHBB 
=B(AApA{AffAzA(A=qAAffAAGAzAzAGAAAHAGAA
A33AAAffAGAAAAAA
AHAGA  A\A{AQAQA\AAA
=AAQAAAQAAQAA
=A{AQARAApA
=A{AA
A  AAA\)A(A
=AffA
AQA(AݮAA=qAAAQAGA(AAzA{AHApAAAGA
=AffA33ApAffAzAHAQAA{A
ApAAAAA=qA
A
AAGAzAAA(AzAA(AAAAB 33A\)AAzB 
=B (A\)AA\)AGAHAAARAQAQAA
A
=A
A=qAA(AA
A
=AAAHAQAAA33AffAA33AApA{AHA(AŮAQAARA\AAAA  A
A{AzAAAzApAHAGAAծAծA  AQAffAQAQA
=A
=AңAA
AzAGAA33AQAzAAHA
A\A(A=qAA=qApAffA\)AGAAΏ\A=qA(Aʏ\AA{AA\AAA=qAĸRApAQAA
=Aȏ\ApAAAAAAzA
=A(A  A33A  AׅAʏ\A  ApAARAʸRA{AŮAAۅAAzA33A
=ARA(A=qAA  AQA\)AAQA  A33AAGA=qAڏ\A홚A
AA뙚AA
AAAA  AzA
=AAA
A=qAGAA  AQAAA
A
AffAHA\)AAAHAA\)AQA
A{A33A=qAAAAARA
=A=qAA\A
A
=ApAAAQAGAAHAAAA{A\)AAffA=qA
=A  ApAAffAA=qA33AHAA33AřA33A  AffAA\)A{AQA33A
=AGARA\)A߅A߅A
AA  AԣA
A
=A33A{A  A
=AQA֏\AܸRA
AGA
=AGAGA㙚AA=qAA=qAA޸RAۙAAHAGAˮA֏\A33AAHA{AA
AՙARAᙚAAA33AA33A\ARAffAAHAAAGAARA\)A{ApAHAQA(A
=AffA=qApAQA{AA
A(Aҏ\AApAAzA33AHA\)A
ApA\A  AA=qARA\AzA\)ARA癚AA\AݮAQAA㙚A
AApA(A߅AAAA{AzApA{AAA{A
AA
=AAApAAA{A=qAffA
ARA33AA(AA33A  AA  ARAAQAA  AzAA=qA陚AAA33A=qAA33ApAHARARARAApAAAAGA
=AAA
AAA癚A
=AQApAffA
A{ApAQAQAAÙAAAҏ\A\)A޸RA
=AQAzAffAAAA=qA
=AAAQAA33AHA=qAAAzAffAA
A\AAApARA{AffAffApAAHAA\AAQAA
A33ApA
AffAQAAAGA
A
A\AzApAAA\)AAAA{AzA
=AA(AAA\)AAAGA=qAGA(AAAA
AمA  AAA
AARAGAQAA=qApA\)A{AffA\)AAAzAA
=AAHA뙚AApA
A홚AzA{AffAHA33AGAffB {AQA
A{AA홚A=qA
A홚ApAAA=qAAAAzAAAHA  AAAA33AA=qA(A
=AAAHApApApBpABpBpABffAHAGAffAAHA\AAffA
=A\)A(ApA{ApApAApAߙAQAA(AffApAۅA  AׅAAAffAAAGAA{A  AϙAA{Ȁ\AffApAGAڣAڏ\AA\)AޣA{A\AGA
=AffApAzAQApA  AQAAA=qA33AAAQAAQA
=AHA33A  AHA\)A\)ApAHAQAAAAۅA׮AԸRAәApAzAݮAApAzAAA\A  A\)ARA\)AGAA߮A
AA=qA
A
A{AHAAAAffA33A=qApAȸRAA
=AƏ\AGAA{A\)A
AAAřAǮApA=qA(A=qAAffAA=qAڸRA\AA=qAzAA=qAAA뙚AffA\AzAԸRAHAHA
=A(AAAAͮA\)AApAzAzAAQAԸRAҸRA͙A33ARA33AƏ\A  AffAA33AQAԣAݮAՙA33AQA؏\AGAHA
=A\)AQAHARA{AA  AծAAffA
AAޏ\AݮAzAHA(AApA͙A
Aȏ\AAA
A\)AQAͅA=qAzA=qA\)AffAQA  A\)A=qA(A
=A=qA
AHAA\)AzAAAA\)AظRA߮AAA33A\)AA(A
A  AGAA
=AQA  AAᙚA(A
A\AA\AAQAAAA陚AQA\AA
AA33AGAAǅAȏ\A\)AAGAAAAffAGAHȀ\AAA֏\AzA\)AʣA=qA׮AffAAzAA(ApAͮAQAzA33AHAA
=AApAA=qA
AAffA{ApA=qA\)A{AA
A
=AA
=AAAB ARA33A(AHApA
=AzAAAA
A
AHAARAA؏\AApAߙAGApA33AHA=qA{A{AffA
A=qAQA{A߅AAA݅AAۮAQAA33AARAQAQA(AAffAApAA33AAA{AA\ApAAA{AAffA=qA
=AQA(AAHAffAޏ\A33AHAA(AAAHAQA(AQAAԸRA  A33A\AAAAAffA=qA  AA33A
AffAٮAظRAGA(AA
AAԣA  Aȏ\A{AυAHAffAԸRAzA=qA33AAHA\)AQAA\ApAQAƸRAHAHApApA=qApA֏\A  ARAA֏\AӅAffAA(A{A
=AAffA{A=qAApA{AApApAAGA
AأAGAzA=qA33A(AAAARAA{AGAAHAQARAQA{AHA\AA\)AAARARA  AffA
=A(AHAЏ\ApAQAHA  AٙApA=qAffApA\)ARA(A{AQAAA  AA
A(AA
=A{AQAGA\A
A=qAffAHAzA
A
=A\)AAA\)ARA33AA\A  AARA
AQAGAAAHAAA
=AGA\AAQAzAHA(AB 
=A
=AA{AAA(B ffAAA=qAA\A
=AAA=qAGARARA  A33A  AA33AzA33AGAQA
=AAA33ffff      3333y   ffff  33ff  ff  33  ffffff  33    33ffff  333333  y  33ff33yff33ff  3333ff33ff33ff33ff  33  3333ffff    y     y ff33  ff  33ff  33    ff33ffff  ff  33ff  33    33  ff33ff33ffy     33ffff3333ffffffff3333ff33    333333ff      ff3333y ff3333ffyy3333    ff33      s33ff`  y33yy    ffy33  ffffffflyls33ls33yyyffy  ys33s33lys33  yy`  yys33s33y  ys3333  s33yy33  yff33yff33  33ff    ffff33s33333333ffffs3333  s3333yl  33  ffffffs3333lffs33y33fffs33yff33  3333  33ff3333333333ff33y33  33ys33  yff3333s33y33y  y3333s33ff33ffffs33y  y3333ff    3333ffff333333ff33  B33ffy3333  33ffff  ff  y y y y y y33  ff33    33ff  ff    ff  33  ff  fffyyll33ffy33333333  ffff  33      ff33        33            ffffff33ffff  33ff  ffffff  33ff    ff  33ffffff  3333  y        ff33  ff  33ff    33ff3333ffff    ffff33ff  33  33ff      33      33  ffy Ys33y y   ffͿL  333   y ?   B  y ffFff?fff33?33Fffٙffffs33  y33ff3333ff  33    Ϳ  ff  ff9@  ff,;L   33       &ff33ffff  3333  >L   y Bffy y Fffy ٙ33   y s33   Bff  S33ff  333ffff@  S33fffy y ?y    y L  ٙfffy   Bffy y ============================                                                                                                                                =            =====================================================================================================================================================================================================================================================================================================================================================    =============================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================================                                                                                                                            ========            ================================================================================================================================================                                                                                                                                                                                                                                                    ==========================        =    =================    ================================================================================================================================================================================================                                            =    ===            =    =========    =====================================================================    ==============    ====================================================================================================================================================            =                ==;L;L;L;=;;>>=ͽ;L;Lͽ=    =    =>L    ==ͽͽ=        ͽͽͽͽͽ        =ͽ;L;L;L;L;Lͽͽ;Lͽ;ͽͽ    L;L;L;L;L;L;L;L;L;L;L;L;Lͽͽͽ;Lͽ;Lͽͽ                ͽ;Lͽ;Lͽͽͽ    ͽͽ===>L=    ͽͽ;Lͽ;L    L;L;L=;Lͽ>?333?>>>L==    ;Lͽ;L;;;;;;L;L;L;L;L;L;=;ͽͽͽ;L;L;L;L;L;L;Lͽ;L;L            ;L    ͽ;L;Lͽͽ    =    =ͽͽ            ͽ                =    ==>L        L    ;L        =        L;Lͽͽ            >L    ====        =ͽ                ;L>L;;;;;;ͽ;;;Ϳ   ;Ϳ   ;;;;ͽ;;;;;L    =    >Lͽͽͽͽͽͽ;L;L;L;L;L;L;L;L;L;Lͽ;L;L;L;    ;ͽ;L;L;L;L;L=        =>===>L==ͽ    >L>L=    =ͽͽͽͽͽ;L;L;L;L;Lͽ;Lͽ;?L;;L;;;;;LͿ      ;;;;;;;;=>=ͽ;Lͽ            =    ͽ;L;L;L;;;ͽͽ                ͽ                L;ͽ        =ͽ    >Lͽ>L>    L;L;L;;;;;Ϳ   Ϳ               ;Lͽ    ;L;L    ͽ    ==    L;Lͽ;L;L;L    ;L;L;>L;;;Ϳ   ;;;Ϳ      ;;;;Ϳ   ;Ϳ   DRͿ333   Ϳ               333;;;;;;;;Ϳ         ;;L;L;;;;;;   ;;;L>L=@33=;L;L;L    ͽ;Lͽͽ>?    ==    =    >L====>=>L=>L==>L>>L>L>L>>>>L>>>>L>L=>L>Lͽ>>>?   >>>?   ??   ?   ??333?333?>>>>>>>>?>?   ?   ?   ?>?   >>>?>>?   ???   ?   ?   ?   ?>>?   >?   ?   >>?333?   ?   ?   ??333?333?L?L?  ??333?fff?L?333?   ?   ?   ?   >>>>>L=>L>>>>L>>>>>>>>>>>Bu33?   ??>?   >>?   >>??   ?   ?   ?fff???  ?fff?fff?333?333??   ??   ?   ?   ??333??   ?   >>>L>L>L>L>L>L>L>L=>L>L>>L>L>L>L=>L=>>>?   ??L?333?L?fff?333?333?L?333?   ??333?  ?333D ??   ??333?333?L?   ?   >>>>??fff?   ?   ??   ?   ?   ?ff>>>>L>L?L?fff?  ?  ?fff?333?L?L?L?333???333?   ??   >>>??333?   ?L>L>L?333>???   >=>>>?   >>>=>L>L>L>L>=>>>>?   ?   >L>>L>>>>>>>???333?333?L?L???fff?L??L>?   ?   ?   >>=?   ?   >??  ?33?  ?ff?ff??????fff???  ?????33??fff?  ?   >>?   >>>>L>    >>L?   ?   ?333?333>??fff?fff?L?333?   ?fff??   ==?333?333??L?ff?  ?L?ff?  ?ٙ?ٙ?33??fff?L?   =>>L?   >>L==>    =?>=>>?  ?L??  ????ff??ff?L?  ?  ?ٙ@??33??33?33???fff?  ?L?L?fff?  ?  ?fff?L?333?L?333?   >??   ?333??333?L?333?L???L?L?333?   ???   ?>>L>>>>=>L>=>>?   >??fff?   ?L??333?ff?33??  ?ٙ?fff?fff?L?333?L?fff?  ?  ?333??L?fff????   >??33?ff?  ?ff?  ??ff@   ?33???  ????L?333??  >?   ??>?333?   ?   ?   ?fff??fff?333?ff?   ?   ?333???   >>>?>L>>L>>>>>    >L>L>L>L>L=>L>?fff?333?333>>>>L>L>>=>L>>L>L?L>AAA33>L?ff>L>L?           >L>>??333???L?333?fff?33?ٙ?ٙ??fff?fffD#3?>>>>>>>>L=>L>L    ?            ͽ        L=;Lͽ==;    L;L;L;L;L;L;L;;Lͽ;L    Lͽ;;L    ;;;ͽͽͽ;L    L;L;    L;L    ͽͽͽ;L;L;;;L;Lͽͽ;L;Lͽͽͽͽͽ;L;L;L;;;Ϳ       Lͽͽ    =>>>>?fff>?333>?L?333?L?333???   ?fff?L?333?L?333??L?333?L?fff?fff?L?L?L??L?fff?333?333??   ?fff?L?fff?333?L?fff?  ???  ??????ٙ?ff?ff??  ?  ?L?fff??333??   >>L>L>L>>L>L>>L>>?   >?   ?  ?33?fff?fff??  ?333?333?fff?fff?fff?333?333?   ?L?fff?L?333?   ?????????>>?   ?333?  ?fff?L?L?fff?333?L?L?L?L??333?333??   ?333?   >>?   ?   ??   ?333?fff??????  ?L??333?L?L@333@Fff@,@ff@33@ff?33?ٙ???  ?ٙ???  ?ff???33?ff??ٙ?33?@   ??  @   @ff@@   ?33@   ??ff?ff?ٙ?ٙ?33?ٙ?ff??ٙ??  ?ٙ@??ff??  ?ff?ff?33@?  ?33?ff??33@ff?ٙ?ٙ@@@ff?33?  @ff@9A4@   @@333@@ff@Fff@@  ?33??  @,?ٙ?33?33@   @   @9@333@9@333@,@   @&ff@&ff@,@,@   @   @@@@   @&ff@,@33@@&ff@   @33@s33@S33@Y@L@Fff@L@L@Y@@  @@  @   @&ff@,@9@9@,@333@&ff@,@&ff@Fff@l@s33@L@Fff@S33@9@9@333@&ff@,@   @33@333@,@9@@  @Fff@@  @Fff@9@333@333@333@&ffA@Y@,@&ff@@@@9@333@9@@  @@  @L@9@,@&ff@&ff@&ff@   @@@   @&ff@&ff@,@&ff?ff@33@33@@&ff@,@@  @9@333@9@@  @9@   @&ff@&ff@@@   ?33@@@   ?33?ff??ff?ٙ?ff@   ??ٙ??33??ٙ?  ?ff?33??ٙ@   @   @ff@33@33@@9@L@S33@333@333@333@333@   @   @   @33@@@ff@   ?33?ff?33?33?33@?ٙ?33@333@Y@Y@&ff@@   ?33@ff????ٙ?33?ff?33@?ff?33??ff?ff?ff?33@   ??ff?A+33??@l?  ?fff?33????L??  ?  ?fff?fff?fff??ff?  ?33?33?ٙ?33@?33?33?  ??33?33?33???33?@&ff@33@?33@ff?ff?ff?33?ff?  ?33?ٙ?ٙ@33@&ff@   @33@   @ff??ٙ?ٙ???@&ff@33?ff?ٙ@33@@ff?ٙ?ٙ?ٙ?ٙ??33?33?  ??33?  ??  ?  ?????fff??  ?fff?  ?L?fff?L?fff?  ?ff?ff@ff@33@33?33@@   @@33@@ff?  ?  ??33??ٙ?  ?@   @ff?ff?33?L??333?fff?333?   ?   ====>L        >?   ??L??  ??ff?ٙ?  ?  ??????  ??   >??  ?fff?fff??  ??  ?333?>L?   ?fff?333??   ?333?   ?   >?   ???   ??   ?   ?   ?   >>>L?   >>>>>?   >>L=>    >L>>L=    >L=    Lͽ        =>L>==        ;Lͽͽͽ        ==>L=>>L=>===>Lͽ                               >>L>L=>L>L>L>L>L>>=    >L>L>>L=    ===    ==        >===    ==            =ͽ>>L==>=>L;L    Lͽ;L;L;L;L=>>>L>L>L    ͽ;L;L;;   ;ͽ;L=        ͽ            L??   >    =    >L??   >=        ͽ;L;Lͽ;L;Lͽ=ͽ;L;L;L;L;L;L;;;;;Ϳ   ;Ϳ         ;;Lͽ;;L=>>>?   ?   >=    L;L;;L;ͽͽͽͽ            =                ͽ;    ͽ;L;L;L;L;L    L;L    ;ͽ;;L;L;;Lͽ;LDLLͽ>    Lͽͽ=ͽ;L;;ͽ            >=>?>L?333>>?   >L?>>L=ͽ;L??   >>?   >?   ?   >>L>L            ͽ        ;L;Lͽͽ    ;ͽ;   ;;L;Lͽ;    ;L        >L    ;;Lͽ;Lͽ;L        ;L=;L;ͽ    Lͽ;Lͽ    ;;;Lͽ;Lͽͽͽ        ͽ    >L;Lͽ;L    >L=>L;Lͽ;L;L;L;;L;;;;L;L;;L;L;L;;L;L;;L;L;L;;;;A33      L;;;;ͽ;;;L;L;L;;L;;;;Ϳ   ;   ?   Ϳ               ;;Ϳ      Ϳ         Ϳ   L;;   Ϳ      ;;L;L;;L;L;;Lͽ;L>L        @  ;Ϳ   L;;L;Lͽ=ͽ    ;;;;ͿͿ   Ϳ   333333;Ϳ            333      333333Ϳ            Ϳ   Ϳ   Ϳ   ;;;;;;;L;;;;;;;Ϳ      @,Ϳ      333333                333333333   LͿLͿ333333333             Ϳ                  Ϳ   Ϳ      ;;Ϳ   ;;Ϳ   ;;;;;;LͿ   ;LͿLͿ333333@?LͿLͿ   333LDf333333?L?   >        =    ;?L    Lͽ;L>=ͽͽͽ    ;L=ͽͿ      L?333?=    ?       ?       =??   >?   ?   ?   >>>=    >L>>L    >L==        >>?      >=?   >?  ?>?   ?   ?L???   >>L?   ?fffAA  ?33>L@Fff@ff@ffA33B33A@Fff@ff@A  ?@?33@ffA;33A?   @ff;L;Lͽ;L;ͽ=ͽ;L    L==>L>>    >?  ??L?fff?fff?fff?L?@33@333@Fff@&ff@S33@   @   @@@@   @?33?ff?33?ٙ?33?33???fff?333?L?   ?   >??L?  >L?  ?  ??fff?  ?L>??   ??333??   >>>>>=>>>L>L>L?   >L=>L>L>L>>?333??L?fff?   >L?   ?L?  ?ff>>>>=ͽ        L;Lͽ        ====>L=>L>>>??  ??fff??333?fff??  ?  ?L?L?333?fff?ff?33?  ?ٙ?333?333?L>??333??L?ff?L>@?fff?333>??33?ff>?L?333?@,@33@@  ??   ?33@S33@??  ??@?  ?ٙ@   ?ff@33@33@33@Y@ff@?ff@`  @,@@  A   @9?ff?@ff@  @ff@33@9@L?33@   @s33@S33@9@A,@Fff@L@@s33@  @  @Y@fff@A  @ffA@ff@ff@@  @33Aff@Y@ff@&ff????L?fff??L?  ?@Fff?  ?  ?  ?fff?333?333?333?333?   ?333>??ٙ?33??33@   @,?ٙ@@?33?ٙ?  >?fff?L?L?333?333?333?333>??333?333??33?  ??fff?fff?33?fff?333?333??333?L?333?L???333?L?   ?L?333?  ?  @,??  @&ff???  ??ٙ@?33?ٙ@   @   @33@ff?33@ff@&ff?33?ff?L?fff??ff??  ?fff?L?   ?333?>L>L>?fff?333?L?   ?333??   ?L?fff??  ?  ?333???ٙ?ff??ٙ??  ???  @??ff@?33?33A?L?L?  ?ٙ@ff?33?  ?  ?@Fff?LA?fff??  ?33@ff?  ?ٙ?ٙAH  Bff?ٙ@ff@,?ff?L?fff?  ?ٙ@ff@   ?33?ff??ff?@9@33?ff?33?@&ff@33@  @@  @?@&ff@33@@ff@333@33@,@@  @ff@@ff@l@@?@@,@@ff@ff@@ٙ@  @S33@s33@ff@&ff@   @`  @S33@`  @  @ff@  A@33@@陚@@@ffAA@@  A6ff@ə@ff@@333@ff@A  AAk33AT@陚@  A  AAffA`  @@@  A͙A33AA>AffAffA@ٙA@A@ffAff@33A33A33@A33@yAnffA  AAdAffA0  A   A+33Ak33A333A  AA   ANffA(  AdAfffAIBjff@@s33AnffBBb  A>ff@33BtffA;33?  @   @FffA  @AC33@ff@9@ff@陚A8  A+33ATAffA  Ac33@33@əAffAc33AK33@Y@@ffA[33A<Afff@  @ffAA8  ADAAffA`  ANff@ٙAA.ffA  AX  @@33A>ffA8  @ff@ffA33A#33A0  @ٙA@ffA$A0  @AK33Aff@  A@  Aff@@@@AffAS33Aff@@AffAC33AA9A  A  AA#33A;33AH  AffA&ffA  @ٙAA@@AiAk33A33A  AdA{33AAP  AffA{33B  @BBAffAA@ffA   @  AA33A+33@Fff@9@   @ff@ff@@ff@   ?ff@   ?ff??33@   ?33?ff@   ?ff?  ?  ?ٙ??ٙ?  ?33?33?ff??33??33?ff?33@   ?  ?ٙ@   @Fff@,@   ?@   ??ٙ?33@33@&ff@9?33@   ?ff@ff?33?33@?33@   ??ٙ@ff@ff@ff?33@   ?ff@   @Fff@ff@&ff@@   @Fff@   @333@33@Fff@   @Y@@  @333@@Y@333@@  @,@  @y@@ff@   ?ٙ?ٙ?ٙ?33?ff?ff?ٙ?ٙ?ٙ?  ?ff?ٙ???  ?  ?  ?33@?33@   @,?ff??ff?ff?fff?ff?  ?ff?fff?33?  ?????  ?ٙ??33?ff??ff?  ?ff????  ???ff??ff??ff?  ??ٙ?  ?ff??33?  ?33?33??  ?  ?33??33??  ????ff?  ??33?  ?  ?333?fff?fff?fff?fff??L?fff??fff??@33?  ?  @?L????  ?33?ff?33?  ?ff??ff?fff?  ?@33?fff?fff?  ?333?333?   ??333?333?   ??333???333?333?333?333????fff??  ?333?333??L?  ?fff?333?L?fff?fff>??>>?333???333?fff?fff??L?fff??333?L>>????333?   ?L??333???333?ff????   ?   ?   ??333??333?333?333>>?   >>?   >?   >>L>?   ?   >>>L>>>L>>L>>?   >>>>?   ?fff?   ?   >?   ?fff???fff?L?L?L?LD?L?333??  ?fff?333??>>L>>>?   ?????   ?333?   >L>?   ?   ???   >>?   ?   ??   ?>?   >>>>?   >L?   >L>L    =>?>L    =    =>L        >>?   >L>L???>?L??333?L?333??   ??  ?333?L?333?L?fff?333?fff?333?   ??333?L?333?>??333?L?fff?333???L?  ??L?L???   ?L?333??L?>?=>L>>>L>>L?   >?fff?L?ff???  ?  ?  ?L?L?  ?L??fff?333>?fff?  ???   ??333?L?fff?L?fff??L?333??@`  ??   ??333?L?   ?=>L=>L>?   >>>?   >?   ?>L==>L==?L??   ?   >?333?   ?333?>>>>>>?   ????333?   ?333?>?333?fff?>?L?ff?  ?L@ff@@   ?33@&ff?33?ff??L?L?>?   ??  ?  ??  ?ff?33?  ???ff@?  ???   ?  ??  ?ff?fff?L?333???ff@@@@@,?33@@33@   ?ٙ@   ?33@&ff@33@333@&ff@&ff@@  @?ٙ?33@   ?33?  ??ٙ?  ??ff?ff?33?33??ff??ff?ff?33??ٙ@&ff@ff@33@s33@  @l@Y?ff@@9@,?33?ٙ?  @   @33@   ?33?33@9@,@&ff@   ?ٙ?333?   ?   ??ff?333?@333@L@ff?ٙ?ff?fff?  ?33??fff?L?L?L?fff?ٙ@ff@   ?33?  ???  >?333??fff?  ?   ?fff?  ?fff??33?  ?L?333?fff??fff?333?33?fff??  ?ff?ff?  ??  ?fff@ff?fff?L?333>>??333?333??L>L>>L?   ?L?L?333?333?L????   ?333?   ?fff?L?L?L?>L=>L==>L====    >L>L>>L>L>L>?   ?   ?   ?>?333?L???  ?ff?ff?ff?  ??>?  ?>>>?   >>L==    >L=>L=>>        ==>>=>L>L>>L>?   >?fff?   >?>?>>==>>L=>>L>Lͽ>L;L;    ͽ;Lͽ;L?ffL;Lͽ;L;L        >>?333?333>??  ?L?fff?fff?fff?fff?   ?333?   >?   >>>?   ?   ?   ???>>>>L?   ?>>L?L>>?   ??   ?333>?333====        >Lͽͽ    L    ͽ;L;Lͽ;=        ??    L>Lͽͽ;L;=    >L>>>L>L>>>    =>L=>L>L    ==>>===>?333>>>L?   >>>?   >>?   >>>L>>L>L>>L>>>L>>>L>>>>?   >L>>>L?   >L?   =>L>L;L    =    ;Lͽͽ;L=    >>L?fff?   >L>>>L>?  >?fff?fff??L??333?   >?   >?   ?   >?L?333??333?L??   ?   ?   ?L??L?L?fff?L?fff?L?333?L?L?L?L??L?fff?fff?L?L?L@&ff??   ?L>??   ?   ?333?fff??  ?ff?  ??ff??ff?????33??  ?fff?fff??ff?33?ff?33?ٙ?  ?  ??ff?  ?????ff?33?L?L?fff?  ?fff?  ?fff??  ?  ???  ??  ??333?L???L?333?L?333?L?333?333?fff?333????   ?   ?333?   ?   ?   ??33?  ?????ff?fff?  ?  ?fff?fff?  ?L?fff?L?L?333?333??  ?L?fff?  ?fff?fff??fff??fff?fff??   ?333?   ?   ??   ??333??333??   ?   ?   ?333?333?   ?   ?   >??L=??>>=?   >=?   >>>>>L>L>>>>?333???fff?L>>>L>>?L?fff?L?  ?L??>>>?   ?>?   >=>L>L>>=>>>L>L>>>>>>L>L>>>>>>>?   @?33??333??>>>>L    =>=>L>L?333?   >>>?L??   ?L??333??   ?L?   ?   >>>L>>>?   >?fff>>???L???ٙ?333???   ?   ?333??333?333?   ?333?   ?333?   ?333?  >>?   ?   ?ff?333>>>L>>L>?   >>>>L=>>>L>>>>>L?   >>>>L?33>?   >L>L>>>=;=ͽͽ=@>Lͽ    =ͽͽͽͽͽ        =;>L    ==>L=====>L>L>>L>L>??   >>>??   >L>L>L====ͽ=    >L;L    =>L    ;L==    ͽͽ    ;;L            ;    ==ͽ        =    =>L==        ==        >L=;L;L;L;L;Lͽ;    L;L;;L    =;L;Lͽͽͽ    =>Lͽ>L>>?   >>>>L=>L;L>L===    ;L;Lͽ;L        LD3>L?>ͽͽͽ?fff?L?>L=;L    >?   ?333?L?ff?33?  ?ٙ?fff?  ?fff??fff?   >>>>>>?   =>>L>>>?L?   ?L?L?L?L??  ?  ??L?33??ff?L?33??ff?L?  ?L??33????ff?????333?   ?fff?333?L?  ?33?   ?fff?L??ff??33?33?fff??  ?L?333?L?  >L?333?   ?   >L>>?   ?ff??fff?>L>L    ͽͽͽ;Lͽ;L    =>?   >>?   >?   >L==>>>L>L?   >L>>L                =            =ͽ=>====>L>L>L=>L==>L==        ;==>L>>>>>L>>=>=?   >>??   ?   >L>=?333>?   >ͽͽ;;;L;   ;L;L;ͽ;L    ;L    ͽ;L;Lͽ    ;;L;;         ;;;;;;;L;;;L;L;Lͽ        Lͽͽͽ;L    ;Lͽ;Lͽ;Lͽ        ͽͽ>===            =;Lͽ;L;L    L;L;L;L;L;;L;L;L;L;Lͽ        L;L;L;L;ͽ    ;L;   ;                           Ϳ      ;;         Ϳ               L;;L;L;L;L;L;Lͽͽͽ    =ͽ        =        >>L=        =ͽ    =ͽ    L;;Ϳ   ;;;L;L;L;;Lͽ    Ϳ   LͿ         333   ;   ;L;L;;L;ͽ;LͿ   L;L;L;L;L;L;Lͽ    ;Lͽ;L;ͽ;ͽͽͽ;L;Ϳ   ;;L>L    >>L    ==    ͽ    L;L;;Lͽ;L;L;;L;   ?fffL;   L;Ϳ   ;;;;;;;;L;;;;L;;ͿL;L;ͽ;Lͽ;L;   L;L;L;Lͽͽ;Lͽ;L;L?  ;Ϳ      ;;L;L;;;;Ϳ   ;;;Ϳ   Ϳ      ;Ϳ      ;;L;ͽ;L;Lͽ;L;L;Ϳ            A33Ϳ   Ϳ   Ϳ         ;;L;;;;LͿ            Ϳ         L;;Ϳ   ;;;;Lͽ;L;   ;;LͿ   L;;;L;;;;Ϳ   ;;      L;;ͽͽͽ;L;L;L    Lͽ    L;L;;;Ϳ      ;;Ϳ   Ϳ            Ϳ   ;   ;;;L;Lͽͽ;L>L;L;=;Lͽ;L>L>L===    =        ;Lͽ;L;L;L;L;L;Lͽͽ;L;Lͽͽͽͽ            >Lͽ;L    Lͽ;Lͽ?333ͽ>Lͽͽ;L;L;L    ?   ;LͿ   ;;;;;Ϳ   L;;LͿ   ;Lͽ;L;;L;L;L;L;L;L;L;;;L;L;;Lͽ;Lͽͽ    >==    L;L?L    ͽ    ;Lͽ;Lͽ;L;Lͽͽ    ;L=ͽͽ;Lͽ;L;Lͽ;L;L;L;L;L;ͽͽͽ;=;L;;Ϳ         Ϳ   Ϳ   L;L    ͽͽ;ͽͽͽ                ;L;L;L;?333ͽ;L;L;L;Lͽ    ͽ                =ͽ        =ͽ                    ===    =            >        =ͽ=;L;L    ;;Ϳ               ;ͽ;L;L;;;;L;L>>L>>???333?fff???L?333??   ?333?fff>?L>>=>L>L>?   >L        >>        ====>L        =    =>L>L>L=>>>=>L>L>>>>?   ?  >>?   =            ?   >>L=>>?   >L>L>L=ͽ    >==        ͽͽͽ=ͽͽ    Lͽͽͽͽ;L=?   >        Lͽ;L;Lͽ;Lͽ;Lͽͽͽ=ͽ=ͽ    =    >L>?  ?  ?L?       >L            =>L?   >>?>>L>L>L>L=>>>>?   >?>>?L>>L>L==>L>>=====>L=    >=>>=>>L>L>>>L===    ͽͽͽ==    >L>L>L>>>=>L>>??   ??L??fff?333?333??   ?   ?   ?   >??>?   ?333    ͽ            =>L>?   >>L>L>L>L>L>L>L>>>>L>L>>L>>>L>>L>L@L>L>L        ==>                    =            >L===>L>L=>L==>    ==>L>L===    =    >L;    ;;         ;;Ϳ   ;;L;;   ;Lͽ;L;L;L            ;L;L;;;;L?  L;L;;L;L;L;L;L;Ϳ      ;L;;;@ffL;L;;L;L;;Ϳ                  ;;;;;;;;;;;L;L    ͽͽͽ;Lͽ;L;L;L;L;Lͽ;L>L;L;L;L;L;L;L;L;L;    L;L;;?L;;;;;L;L;;;   ;Ϳ      Ϳ;L;=    ;Lͽͽͽ    >    ;L                    ;L;L;;Lͽ;L;;Lͽ    LͿ   ;Lͽ;L;;;L;    ;;L;L;;>;L;Lͽ;Lͽ    L;L;;L    ;L;L;Lͽ;L;;;;;L;L;L;L;L    ;L;Lͽͽ;ͽ;Lͽ;L;    =    ;L;L;L;L;L;L;;L;L;L;Lͽͽ;L;L;L;L;L;L;;L;;Ϳ      ;            =    ͽ;;?;Ϳ;Ϳ   Ϳ            ;;;;L;=;;;L;;;Ϳ   ;L;;L;L;Lͽ    Lͽ;L;L;L;;;;;;L;L;   ;;;;Ϳ         L;LͿ   >   ͽ;Lͽ;L;L;L;Lͽ;L>L    L=>L              ;;;;;    L;L?333L;=>        L>L;L;L;;;;;;;   ;;Ϳ   ;;Ϳ      ;L;L;L;;Ϳ   Ϳ      ;;Ϳ   ;;      Ϳ         Ϳ   Ϳ;;   ;Ϳ   Ϳ      ;;;;Ϳ   ;;;;Ϳ;;LͿ   L?>ͽ;;L;L;L;Lͽͽͽ;L;L;Ϳ         ;;Ϳ   ;Ϳ   ;;;;;;;Ϳ   =;Ϳ   Ϳ   333   333Ϳ      Ϳ   ;            ;Ϳ      ;;;;;L;L;L;;;Ϳ   ?LͿ   ;;L;L;L>Lͽ    ==;Ϳ      Ϳ      ;   333               333      C1     ?Ϳ   Ϳ   LͿ   ?Ϳ333      ?         LͿ         Ϳ   333   LͿ   ;;   ;;Ϳ   Ϳ   Ϳ                           Ϳ   333333333   333333;;Ϳ               ?333LͿ333LͿLͿfffͿ    LͿ    fffffffffffffffffffff      LͿLͿ  333L;L;LͿ333333fffffffffLͿLͿ   LͿ333333333      333      333333333333333333333333         333333333333   333333333333333333333LͿ333fffLͿLͿ333LͿfffLͿ333LͿLͿLͿfffffffffffffff  333LͿffffffffffffffffffffffffLͿLͿLͿLͿffffffLͿLͿ333333Ϳ333333333333333333LͿ333333333333333333   333         ͿLͿ333333   333      ͽ;L;;;;Ϳ                     ;      333;LͿ   L;;Ϳ         Ϳ      ;L>>L        L             Ϳ      Ϳ   ;L;L;;Lͽ;;Ϳ@Y333   ;Ϳ      =;L;L>L;L;Lͽ;;;Ϳ            333                  Ϳ            ;;;L;Ϳ               ?33Ϳ               LͿ333LͿ         333LͿ333LͿ      ;Ϳ   333333333LͿ333LͿ333333   Ϳ333333333            ;;L;Ϳ      333   333   ;>LͿ      Ϳ   ;?333333333LͿ      Ϳ333      333;Ϳ      Ϳ   L?ff      333               333333333               L=ͽ    =ͽ    ;L;L;LͿ   ;;Ϳ   ;    ;    Ϳ   L;   ;?33   Ϳ      ;;;L;;Ϳ   ;;Ϳ      ;L;;;;;Ϳ      ;;?ٙ;L;Dvf;L;L;Lͽͽ>L>>>    ?33L;Lͽ>;   ͽ;>L=>Lͽ        L;L>>>L    >L    ;        >=>L=>?   ?33=?  >@?L>@fff@Fff@333?ٙ@@L?33>L=ͽͽ;@333?33==    >L=    >>>>>L            >=>L>>L==@ff>L>LAff=@?       >L=ͽͽ>L            >L>?333=>L>???Lͽ    >L@333@   ?>L>L??>==>L===>L>>?333?ff?@33?  ?ff?fff?L?L?L@??33@33?33?fff??@L@ff@L@l?333??fff?fff?L?L?L?333?   ?L?fff?@33@   @ff?33?fff?fff?ff?ff???   ?   ?L?  ?   ?L>?   ??   ?fff?   ??   =>L>L?       ;L    >>L>>?   >Lͽ;Lͽ    =>L>L?   >>L>L>L>>>L>?33>L>>>>>L>?33>>L@ff>@L@  ?L?33@?33@>?   ?   >>>>?   >L>L=>@ff@陚?   =>L>L>>L>>L====?33>?   >?   ?@33@ٙA,@&ff?   ?333>>?   ?   ?   >>??333?   ?   >>?   >>=>=>L>L>>L>L>L====>L@ff@@@  @  =>L>L>L>=>L>>>>L@  @@y@@      ?33?   >>>=?   >?fff???fff?fff?333?@  ?@Fff?33??ff?33?  @&ff?   >??  ?ff=>>>>?   ?  ??ٙ?>@33@    ;L@   >>=>L    ==?>L>>L>>L>>>??   ?   ?333=>L??   =ͽ@  ?ٙ?ff>?;Lͽ=>        >=>L>>L>L?ٙ>L=>    ?   >>L>>@ff?333=?  ?   ?>>>>>>>>>=>?fffL;L>L???33??  >??   ?fff>>L==>L>>L>L;L;;L            >L>Lͽ>>L>>?L?ff>?>?    ;L;L;       ͽͽ;    @33?fff?333?333?333?L?>>Lͽ>Lͽ    @33    >>Lͽ;L;L;L;L;;;L;L;Lͽ;L;L;LͿ   ;;;;L;ͽ;Lͽ==>Lͽ        =ͽ            L    Lͽͽ=ͽͽ;L;Lͽ;;L;;;Ϳ   Ϳ;;;   ;;L;;Lͽ;L@ff    L       Ϳ333      A~ffA!Ϳ333333      333333333   333   333Ϳ      Ϳ      >Ϳ   ;;;L;L;L;;;LͿ   Lͽ;    ;L;L    ;;L;;;Ϳ      ;;Ϳ   ;Ϳ333         ;;Ϳ;ͽ;ͿͿ   ;>@@     A                  ?333   >Ϳ333            Ϳ;Ϳ   L;Ϳ      ;L;;L;L;;L;L;;;;Ϳ   L;L;Ϳ   ;Lͽ;L;LͿ333Ϳ333      LͿ   333333LͿͽͿ;;Ϳ         L;;LͿ   Ϳ   Ϳ333333LͿ333333333LͿ333333333LͿ333333333@ff333333333333         ?      Ϳ         LͿ   L;Ϳ   ;Ϳ   Ϳ   333      ;;;;;LͿ   Ϳ            >Ϳ   Ϳ333   333   ;;;;;Ϳ      >L;;Ϳ      Ϳ   Ϳ333Ϳ333LͿ333fffLͿ333fff         333LͿ               Ϳ   Ϳ   ;   >L;ͽͽ;Lͽ;L;;LͽͿ   ;   ;Ϳ      ;;;;;;;;;;;;   ;Ϳ               ;   ;L?ٙL=;L;;Lͽͽ        Lͽ;L=?   >>?   >L?   ?L>=?>L?      ?   ?333?   >=>>;L>L        @===ͽ==?   >Lͽ=        >>>>>>>>L>L>L=>L    =>L>L?333>>L>L    ?   ?  ?>===>=    ===>L        >L>L==>L    =??   L?L>>L=?   ?L?fff@y@33?>=>>>L>L>L?   >=>L>>>>==>L>>>>L?fff>L=    >L>>?fff?       ;L;ͽ?   >?   ?fff?333?   =>L>>>L>L>L>L>L>>L>>L>L?   >L====>L>>>>L?L        ==>>>L>L>L>>LA#33>L>Lͽ    =ͽ=>>=    Lͽ        >>L>>>>>=>>>>>>>L>        ͽ=ͽ;L        =ͽͽ    LͿ      >LͿ         Ϳ   ;L    >L>L==    ͽ    ͽͽ;Lͽͽͽͽ    L        Lͽͽ;L;L;Lͽ        ?fff;L>L;Ϳ   Ϳ333;L;;;L;;;?ff      L;;Lͽ;=>    L;L;L?L;L;L;L    L>L=    >L        >>        >L;Lͽ>>=>L>>Lͽ=ͽ        L;L;L;@@  L;Lͽ;L;L;L;L;Lͽͽ;L;;L;LͿ333333   ;L;;;;L;Lͽ;L;;;;L;Lͽͽ;L;Ϳ                        ;Ϳ   ;Ϳ   333   ;?L;   Ϳ   ;   ;;;;;;;;;;;;;;;         LͿ333333L;        L;ͽ    ;L;      ;;;    ;Ϳ   Ϳ      333333333333LͿ      Ϳ   =;;;L;;;Ϳ   ;;Ϳ            333;   >LͿͿ      ;Ϳ   ;L;;;   Ϳ333   Ϳ   ͿLͿ      Ϳ      L;;Ϳ   ;   =;Lͽ?   ?   ?   ?   ?333?L?L?fff??   >>L>L>L>>>L=>    >L=ͽ?333>            >L=>L>>>?   >>?   ???>>>>>>L>?   ?   >?   ????>???L?????333>>?   ?   ?   >>>L>L>??L?333?>>>>>>>????>L?   ?>=>L>L?   ??333>?333>>L>>>>>?   >>?333>>>>L>>>L>>=>>>>>>>>L>>L>>>>>L>>>>>>>>>>>>>>>>>>>>L>>>?   >???   ?   =        =        >L?   >L>=    =>L?L?   ?   ?>=>?333?fff?33??333?   ?   ?   ?333?>L?333>>?   ?   ?fff?333>?L?333???   >?fff??333>>>L?fff>>>?   >=>>>L>?   ?   =>>>>L>L>L>L>=>>L>>>>?   >>>?   >>>>>>?   ?>>>L===        >L>=;L        >=ͽ>?   ==>>>L;L>Lͽ?           ?   >=ͽ>L>?   >>>?L>?>>    >L>>??   >=>L>>L>>L>>>?   >>L>L>>>?   ?>>>?   >>>>>>>>?   >>?L?333>L>?   ?fff??333?  ?fff??ff?33>?>>?L>>?  >L?333>>>L>??  ??fff?  ?fff???L?333?ff??fff?  ?333??L?L?   ?333?   ?  >?   ?   >?   ?   >>>L>>>>>>>>L>>?333?   ?L>?   >>>L>>>>L?   >??>>>??333?333?333?333?   ?   >>>>>L=ͽ=;>L    >L>>>?L>>>>L==>>>>L=>>?   >        >L>L>???333>            >L    >L?fff>L>Lͽ=ͽ=        L;L;L;ͽͽ;;LͿ   ;;;        L;L;;;Ϳ   =        L;L;L;L;L;L;L;;   ;;;L;;L    ;    =;;L;        =ͽ=    >??  ?L?  ????fff?fff?   ??333?33?fff?fff>>???   ?   >L>L>>L>>L?fff>>    ?   ?fff>?@s33??33?ff>    ?333>>?L??ff?  ?ff??333?L??fff@,@ff@?33@@&ff?ff?33?333?   ?   >L>??ff@ff@@fff@@  @ffA   @ff@A  A,AIAdA9A4A@  AAff@ff@  @  @33@  @33@  @@33@@@@ə@@33@  @33@  @  @33@33@  @33@@L@  @  @  @&ff@,@fff@`  @l@y@`  @9@Fff@@  @L@L@S33@Fff@9@333@@  @@  @ff@@  @S33@@  @@33@33@@@33@ff@y@y@@@ə@  @  AffA$AAAIA6ffA6ffAS33AC33Ac33AC33A333A&ffAA(  AA33A#33AAAA   @ff@33@ff@33@@33@ٙ@  @ff@@ff@33@33@33@ff@@@@ff@33@33@  @ff@ff@ff@@ff@ff@ff@@ff@@@@s33@y@S33@S33@`  @Fff@`  @S33@l@y@33@s33@Y@Y@&ff@333@,@Y@`  @y@`  @L@L@fff@33@  @y@33@33@fff@L@l@`  @`  @s33@fff@L@333@   @ff??ٙ???  ?ff?ff?ff??ff?  ?33?ff@@@33@ff@   @   @,@&ff@,@@,@   @,@,@   @33@33@ff@ff@33?33@   @   ?ff?33@33@ff@   @@   @   @,@,@9@   @33?ff?ff@   ?ff?  ?ٙ@ff@   ?ff@&ff?ff?ff?  ?33@ff@ff?ff?ff?ٙ@   @@@ff@ff?ff@ff?33@@,@Fff@Fff@Fff@Y@L@@  @,@333@9@@  @@  @Fff@,@,@@  @L@L@9@,@   @   @   @@,@   @33@?33?????33???  ?33?ٙ?33?33?ff?  ?ff?33?@   ?ff?ٙ???  ?fff?  ??  ?ٙ?33@ff?ٙ?  ??L?fff?fffA1??ff?ff?33?ff?fff?fff?   ?333?fff?fff??   ??333?  ??ff?33@9@@ff@@33@ff?33@   @@ff@@33@&ff@@  @9@9@9@@  @33@@L@   @@  @?  ?33@?ٙ?  @?  ?ff?ff?fff?ff?33?  ??  ???  ?ff?33?  ?  ?33??  ?ff?ff?ff?  ?  ?ff?fff???33??33??L?  ?ff?  ?L?  ???fff?L?fff?333?  ?ff?fff???  ??  ?  ?  ?  ?33??ff?  ?33?33?ff?  ?ٙ?fff?fff?  ??fff??L??   >?   ?>>?   ?333?L?333?L???  ?fff@33??333?333?L?  ?   ???   ??333?333?333?L??  ??L??fff?L?333?L?>?   >?   >?fff??   ?333?L?   ?  ?ff???L?   ?>?   >?333???>??333>?   >L=>>L??>??   ?L>>?   >?L???fff??ffB}?ff??  ?fff??  ??333?  ??  ??33@ff?  ?ff???  ?33?fff?fff???L?L??ff?L?fff??ff?fff?  ?  ?L?33?fff??333?333??333?333?  ?fff?L??L??  ??fff?fff?333?333?fff>?L?33?333??  ?  ?  ?  ?  ?33??  ????33@33??  ?L?fff?@9??  @?fff?333??33?   ??   ?L?fff>??>???333?L?   ?>?   ?ff??333?333?L?333?L?ff???   ?L?  ?333?   ?fff?33???ff?L?ff?  ?ff??L?L?????fff?ff@ff?33@ff@   ?ff????ff?  ?333??  ?  ?333?33?ٙ?  ?L?ٙ??fff?  ?33?  ?33???@   ?  ?ff?ٙ@??  ?33?  ?ff????  ??ff??333@   ?ff???L??ff??333?fff?333?   ??333??fff??@ff?L?  ?  ?  ?ff????33?  ?ff?fff?fff?  ?  ??33?33??  ?ٙ?33???L?33?  ??fff@33@?ٙ@33?33?33@&ff??33?ffB  @@?  @333@   @S33@   ?33@   ?33?ff@@  @fff@   @@&ff@333@L@ff@9@33@   @Fff@33@@33@@L@Y@Fff@`  @`  @   @`  @L@@l@l@33?ٙ@,@  B@A33?33?33??  ???  ?????fff???fff???ff??ff?ff?33?ff?ff??ff?ffA33?ff??ff?ff?ff???ff????33??ff?33?ff?ff?33?33?33@ff@   @   @   @   @ff@   @33@@@@   @@   @@ff?33?33?33@@   @33@33@33@ff@,@33@&ff@33@33@33@   @   @@ff@ff@@@@B@   @   @@@   @&ff@&ff@9@Fff@Fff@S33@@  @9@333@9@9@333@   @333@,@&ff@   @,@,@,@333@@&ff@333@&ff@&ff@&ff@,@,@,@,@333@,@`  @`  @Y@S33@S33@Y@L@Y@y@l@y@l@  @s33@L@@  @S33@s33@S33@L@S33@Y@Y@S33@9@Fff@@  @Fff@S33@Fff@L@S33@S33@L@L@S33@Y@Y@fff@s33@l@l@Y@fff@L@fff@l@fff@L@fff@`  @fff@l@s33@l@`  @l@Y@ff@ff@  @33@ə@y@y@33@l@l@y@@`  @`  @l@fff@fff@s33@`  @`  @l@y@s33@y@y@y@s33@s33@  @@y@y@s33@s33@s33@33@fff@@s33@y@l@`  @l@l@l@l@Y@s33@s33@y@s33@  @`  @`  @y@s33@s33@`  @fff@`  @l@s33@y@s33@l@y@y@y@33@y@y@y@y@y@  @  @33@33@y@y@  @y@  @33@  @  @ff@  @@  @ff@  @33@ff@33@  @ff@33@33@ff@@ff@33@ff@33@fff@33@ff@ff@@ff@ff@@@@fff@33@s33@@33@@ff@@@ff@ff@@@@@  @@@y@@ff@  @@@@ff@33@ff@33@@  A@@@33@  @ff@  @ff@@  @33@  @33@  @@33@@S33@@33@  @ff@s33@33@@ff@ff@ff@  @  @33@@  @@33@33@ff@33@ə@33A@@  @陚@ə@ff@ff@ff@ٙ@33@@33@  @ff@  @ff@@@@@33@  @s33@l@`  @fff@`  @s33@s33@s33@l@l@s33@l@y@  @fff@@ff@@ff@@ff@ff@ff@@  @@@ff@33Aff@ff@@@@@@33@  @@  @ff@@33@@@33@  @ff@@@ff@ff@ff@@ff@@33@ff@33@@@33@@  @@33@@33@@  @ff@@33@33@  @@@33@@ff@@33@33AIBq33BݙBq33C Bvff@  @fff@  @33@33Aff@ff@@ə@@@@  @  AVff@@ff@ff@33@@  @ff@  @@33@ff@y@ff@@@33@y@@ff@  @33@33@s33@ff@@ff@  @33@@@@  @ff@y@33@ff@s33@@y@@@@y@  @fff@y@@ff@ff@33AFff@ff@  @@@33@33@33@ff@l@  @  @33@  @33@  @@@  @  @Aff@ٙA33Bo33B  A`  B33BMABo33A33B@ffB$@ff@  A@  A,@l@fff@ff@fff@@fff@ff@@fff@l@l@y@l@y@s33@fff@l@s33@Fff@&ff@`  @s33@S33@L@`  @fff@`  @Y@Y@`  @S33@Y@y@Y@y@`  @`  @`  @l@l@l@  @  @  @ff@  @@  @`  @y@  @ff@  @33@l@y@y@y@y@s33@s33@s33@fff@s33@l@l@`  @y@l@l@l@`  @l@l@l@33@y@  @ff@@@  @@@  @@s33@s33@  @ff@yA33@s33@s33@s33@s33@l@l@l@l@fff@l@fff@L@S33@L@`  @Y@Y@`  @l@l@l@l@  @`  @Y@S33@l@l@`  @Y@Y@`  @333@S33@s33@fff@fff@  @s33@s33@s33@y@l@s33@y@33@  @  @  @y@  @33@y@s33@l@ff@y@  @ff@s33@y@y@y@y@s33@y@s33@y@s33@  @s33@33@y@y@33@s33@l@y@  @33@l@  @y@y@l@fff@ff@s33@  @s33@s33@s33@s33@@s33@`  @Y@`  @S33@Y@S33@S33@Y@S33@S33@L@S33@S33@`  @S33@Y@Y@S33@BA1@@  @l@  @ff@l@S33@fff@S33@`  @Y@fff@fff@Fff@l@l@`  @l@fff@fff@l@fff@`  @S33@l@s33@fff@s33@l@fff@s33@s33@l@,@33@y@  @@l@y@  @  @s33@  @  @l@l@fff@y@fff@fff@S33@S33@fff@Y@L@L@fff@S33@9@L@S33@`  @S33@`  @`  @S33@`  @Y@y@fff@ff@l@  @l@  @`  @l@fff@l@fff@`  @Y@Y@S33@Y@S33@S33@L@L@Fff@Fff@Fff@@  @Fff@L@  @`  @33@`  @Y@`  @Y@Y@`  @Fff@  @@  @,@Y@Y@`  @`  @S33@L@Y@@  @S33@S33@`  @Y@S33@L@S33@S33@fff@fff@y@33@33@@33@y@33@`  @S33@L@Y@`  @`  @l@Y@S33@Y@S33@Y@`  @Y@L@YA)@`  @Y@S33@L@Fff@@  @Fff@Fff@@  @Fff@Fff@Fff@@  @L@L@Y@L@L@fff@S33@S33@@  @9@Fff@fff@Fff@L@L@L@Fff@S33@Fff@`  @`  @Y@  @y@33@ff@fff@Fff@S33@Fff@ff@,@333@333@9@9@9@9@333@9@9@Fff@L@L@@  @`  @S33@S33@fff@S33@`  @S33@fff@y@y@y@`  @s33@`  @S33@l@Fff@,@,@Fff@Fff@&ff@L@`  @fff@`  @S33@L@@  @&ff@33@@@ff@A   @@@@Y@  @  @陚AAAA,@@陚@33@fff@Fff@9@333@`  @l@yA33@@Y@L@fff@S33@L@l@L@L@S33@Dvf@9@@  @33@,@9@   @   @   @&ff@&ff@ff@33@,@ff@33@&ff@9@@  @@  @@  @9@333@@  @@  @L@@  @@  @S33@S33@Y@Y@33@  @@33@ff@@@@  @33@@  @@333@9@ff@@@33@@   @@33@,@   @&ff@   @,@,@33@333@@9@   @9@9@L@Fff@L@@  @333@S33@Fff@ff@33@Y@33@ff@@  @ffAA#33@ff@33@@  @,@y@9@33@y@@  @@  @  @ff@  A33@@ff@s33@33@y@33@Y@33?ff@@   @333@333@L@l@  @  @y@ff@@Y@s33@`  @s33@ff@  @33@@@s33@33@@@l@l@@@  @  @Y@`  @@  @9@`  @@33@ff@33@l@  @y@@33@ff@@@@@ff@ə@ff@33@33@@  @@  @ff@ff@  @@33@ffA@ff@@y@l@`  @L@@@@9@333@Fff@@   @33@33@333@&ff@&ff@333@9@@  Df@9@   @@  @ff@9@@  @fff@S33@  @l@`  @L@l@`  @s33@@@ff@ff@ff@  @ff@@@  @@  @33@ə@ff@  @ٙ@ٙ@@ffAffA33AA  AAA  A   A!A(  A)A+33A0  A4@ٙ@@@33@A33A0  @33@ə@ə@@33@A0  @ff@ff@ff@  @  Aff@ə@@ٙ@@@A@  @ff@@  @@@33@ff@ff@  @33@@陚@33@y@@s33@ff@fff@l@ff@  @s33@s33@ff@S33@s33@@  @9@9@&ff@s33@Y@@  @l@fff@l@ff@@  @L@Y@l@33@33@  @33@@ff@ff@@@@33@33@陚@@ff@33@@@陚@ff@A33A33@A.ffA33@ff@  @  @ff@ٙ@33@33@ٙ@33@  @  @  @  @33@  @ff@  @ə@@ff@33@33@@33@ff@  @@@  @ff@@  @@ff@  @ff@@33@@ff@  @  @33@ff@@333@   @@33@@@333@&ff@L@fff@9@@  @`  @fff@  @ff@  @@  @@@33@ff@ff@  @ə@@  @S33@fff@`  @s33@ff@ff@ff@  @@@@  @ə@@@@@  @ٙ@33@A@  @ff@ٙ@33@陚@ff@ٙ@@@ff@@33@33@  @l@fff@S33@l@Y@Y@  @,@,@Fff@Fff@333@@  @   @Y@@  @333@9@S33@,@S33@33@@   @9@&ff@Fff@,@333@S33@L@`  @`  @Fff@@  @9@L@L@S33@S33@S33@L@Fff@`  @fff@&ff@L@9@L@Y@Y@`  @`  @l@s33@y@  @l@33@ff@@  @@ə@ff@@33@@@ff@33@33@  @33@  @  @ff@  @  @  @@@ff@ff@33@@ٙ@@ə@@  @  @@ff@33@  @l@Y@Y@Y@L@Fff@@  @Fff@S33@fff@l@`  @  @33@@  @ff@ff@@@Fff@fff@l@s33@l@ff@S33@S33@S33@@  @Fff@L@`  @l@s33@ff@@@  @@@ff@ff@33@33@ff@  @33@  @  @ٙ@33@@ff@  @  @ə@  @@  A$@陚@@ff@  @@@AA	AffA	A	A33A  A33AA33@@陚@陚@陚@@  @A   Aff@@A@33A  @33@33@@@@ff@@@ff@@@  @@@  @ff@陚@陚@  @33@ffA33@@ff@Dt&f@fff@ff@@Fff@  @fff@9@L@@  @   @@333@ff@333@  @Fff@  @fff@@  @@  @y@fff@33@33@ff@@ff@  @  @  AA33@ff@9@333@Fff@y@  @  D9@`  @s33@33@33@33@ff@ff@33@@ff@@ٙ@33@@@ffAA	AffA  AffA  AA   A33AAA  AAffA33@  @33@@ff@@A<@33AAAffA33AffA  ?333?33@ff?ff??ff??ff?  ?ff?ٙ?  ?33?  ?33??33?33?33?33@?  ?  ?ff?  ??ff???  ?@ff?33?@ff?ff?33?33?ff?ff@   ?ٙ@@@   ?33@ff@@?33@,@,@@333@@  @   ?33@ff@   @&ff@333@,@@&ff@Y@fff@s33@s33@s33@  @@  @y@fff@fff@s33@  @s33@`  @l@33@`  @fff@S33@L@@33@ff@   @@   @33@@@   @9@L@Fff@,@L@333@   @ff@33@33?33@9?ff@33@@@@   ?ٙ?ff@?ٙ?ff??33?ff?ٙ?33?ff?33?  ?L??333????ff?   ???fff?L?  ???33?33?L??ff???33?ff???ff?  ?  ?  ??fff?fff??fff?fff?  ?  ?fff??fff?L?   ?33?fff??>>>ͽ?>>>L?L?   ?333?   ?>>>>>>>>L>L>L>L>L;L>L>>>>>>>>>>>>?   >?   ??   >>>>>?333>??333??333?>?   ?>L>?>ͽ?   ??L?  ??fff?L?333???  ?=?L?L>L?   >L;L>?   >Lͽ>L>???333>>>?L?   ?>L>?   >?   ?   ?ٙ>>?333?333??333?  ?ff?333?333>?   >L>?   >>L>L>L>L>>L>L>>L>>>>>>?   >>>>L>>?333>?    ?   ?        >    @    L;    @33?   >=>;L?L>L>>L=>L    >L===;L>L??   ?333>?L?@   ?>>>>L?   =?333?333>?=?333>L??   >>?333??333?  ?  ?  ?fff???ff?333=?>>;L>>>>>?   >>>>?   >>>?   ͽ?   >L>>;L>L?   ?>>?333?333?   ?   ?   >?  ?  ????   =?L?333?333?   ??   ?   ?   >?   ?333?fff?   ??fff>L?333?  ?fff?????333??333>>?   ?L=?333>>>>L>=???L???L???  ?L?   >>L>>L?   >?L?L?  ?fff???L?333?>?fff>@Y??fff?333??fff?L?fff?  ??33?33A;33?fff?ff?ٙ?ٙ?  ?ff??fff?ff??  ?ff??L??fff?   >?   ?fff??fff?333?fff??33?  ?ٙ??33?33?33@   ?ٙ??ٙ?ٙ@   ?ff?  ??fff?L?   ??fff?L?fff?fff?fff?L?fff?  ?????  ?  ?33?ٙ?  ?33??ff?33??ff?fff??L?L???fff?333?L>?LA>?fff?  ?L?ff?333?L?  ?fff?  ??33?  ?ff?ٙ?ff?33@@9@@  @,@,@333@&ff@@  @333@L@Fff@Fff@?ٙ@   @ff??33?33@?ٙ?ff?33@   @@@ff@33@?  ?33@   ?ff?33@@33@ff@@@ff@@   @   ?33@ff?ff?33@ff?ٙ@33?ٙ?ٙ??33@   ?33@@@&ff@33@33@S33@@  @   @   @,@l@9@&ff@   @,@,@Fff@@  @s33@  @   @33@333@333@   @   @&ff@@   @&ff@,@333@333@Fff@@  @L@fff@`  @  @@ff@@33@  @ff@@@33@   @9@   @&ff@   @333@9@333@@  @@  @Fff@@  @Fff@L@Fff@Y@S33@Y@Y@l@Y@9@fff@l@fff@fff@S33@`  @@l@l@s33@y@@@ff@ff@@33@33@  @33@@ff@ff@y@s33@Y@Y@Fff@9@,@Fff@L@L@l@  @  @@@ff@@ff@33@y@@ff@  @@  @@  @@ff@ff@33@ff@ff@@  @33@A33A	A  AA33@A33Aff@ff@  @ff@@  @@@@  @Fff@S33@Y@Y@`  @l@y@33@  @33@  @ff@l@@33@33@@  @@  @Y@fff@l@s33@s33@y@Y@`  @fff@fff@`  @9@,@33@   @   @@9@333@S33@Y@s33A(  @S33@ff@`  @s33A͙@  @@@ff@33@ff@33@@@ff@  @33@  @  @33Aff@ffA@@B33A33@@33@A  Aff@A33AA   A   A.ffAffA33A  @@@@@@  @@ə@ə@ə@ə@  @@33@@ff@33@  @@@@  @  @ff@  @33@33@ff@ff@@ff@@33@@ə@@ff@ٙ@ff@陚AB  @33A@  @@陚@  @AAffAA(  A#33AffA!A6ffA1A.ffAK33A.ffA0  A  AqA\A33A[33AdAnffAs33A{33AAAA  AffA33AAA  A  AA33A  A33A  A  A陚AffAAffAAffA  A33AffAAffA  DE AiAfffAffB!33AH  A0  A;33A)A<A   A33A33A	A  A#33A#33A$A)A.ffA6ffA>ffAAAC33ALAH  ALA[33AYAS33A[33Ah  AyAdAnffAAAAA33A  AAffAffA  AffAAAffAffA  A33A33AffAAffA  ABffAA33AAՙAAA33AAffBA  AAffB!33AffA33AA33A  AٙAffAffA33A  A33AffAffA  AAAffAA33A33A  AA33A33AAAffAAAAAA  B33AAffAA  AAAAA33A  AA33A33AffA  AA33AAB\AffABBBffBB
  BB
33B33A33B33BADA  BAAAffAAٙA陚A  A  A33AA33A  A  BAAffB BBffB  B  B33BffBffB33BBB33B"ffA  AAAffAAAAAAAAA  A  A^ff@33@@陚@ff@ə@33@ff@33AffA  @33@ff@ff@  @33@33@ff@陚A   A   AffAA33AA)A4A4A&ffA$AAA33AAA+33A0  A>ffAffANff@@A@ffAffA33AA  AA+33AIA9L>>?ٙ?   ?33@`  ?  @@Fff?333??ff?ff?ff@Y@,@ff@33@@9@333@S33?@S33@33AK33A@@  @33A  ?33?ٙ@FffA8  @Fff@,@9@9@fff@@`  @l@fff@fff@y@@ff@ff@@@  @L@`  @l@s33@ff@  @  @@33@ff@ff@33@@33@  @33@ff@ff@@33@@ff@  @ff@33@ff@  @ff@,@   @l??33?ٙ?@ff?33?  ?33??ff?ff@9?  @@  ??33?ٙ@@ff?@?ٙ@9?ff@ff@33???ٙ?ٙ@L@fff?@y?  @@  @ff?  @   @9?33A!?fff?  @   @L?L@fff?33?ff?   >?333?33?333?  ?33?fff?  @ff?  @,@  A   @fff@L?@s33@@s33@L@33@L?ٙ@@   =?   ?   ?333>L>L=@L>?L?L?333>?   ???   >?333@   @33?   ?>>?L?>L>?L?@?fff?fff?33?ٙ>L>L?  @A   ??L??333?ffA	?   A333@   >L>>@@?333=    @333@   ?ff;Lͽ?  ?@L;=>>?   >??ff?ff?333???  ???L?333???L?fff?>@33?L?33?33?fff@Lͽͽ@33        =    L>>A33>>@L==?fff>@@?fff?L?L@&ff?>?   ?fff?  ?  >?   ?   @   ?   ?   >?   >>?333B33A  ?   >>>L>?ff>L@@fff@s33@@33@ff?33>?  ?ff?  >?>?@@&ff@333?fff?fff?  ?L?ff??33?  @33@&ff@   ??33??ٙ@   ?ff?ff????ff??  @?>L=>L>>L    >L=@Fff>L@33=>?   ?   >>???@ff??ff?>?   >?L?fff?ٙ>@33@  @S33>>>>>>?   ?   ?@33@@@  @Y?333@333?fffA33?  ?@ff?  ?ff@ff@   @@?  ?@@  ?L?fff?33?33?  @9@ff>>>L@??33@  ?ff?fff?fff?L?ff??  @L@@S33@   @9@&ff@  ??ff??33A?L?>>?   ?   ??   >L=???   ??L?333?ff??  ?  ?  ?  ??fff?L@@  ?  ???   ?333?333?L?  ?  ?333?@  ?ff?@ff?L?  @S33@ff?ff??33?  ?  ?ff?fff?fff?L???   >>?333??L?fff?  ?@@S33?  ?33@@L?  ??333??   @ff@@ff?@?ff?@   ?33??@l@33@Fff?   >?   ?333??   >?333>?>??fff???fff?   @33?333?333>==>@>?L?L?L?  ???ff??ff??L>>L>>>>L@ff??L@ff?33@   ?ff?  ?fff?33??fff?L?fff??ff@   @33@fff@S33@y@ff@33@fff?L?>??33@&ff?L?  ?ff??  ??fff@S33@   @,?33?>    >>L>    ===>L>L>==            =    ?  >L>L==    L@ə@   ?>>?L>>?fff?L?333?   ?   >??   @  >L?   ?L?333?333A@ff@  @?L@?L?   @@  ?@y@333?@l@   @9@L@333@@L?ff?33?  ?ff???ff?  ?ff?ff??333?fff?L?fff?fff?fff?333?L??L?333?L?L>?@ff??333@s33>??L?333???333?L??L?ffA.ff?   @L?   >?   ?L??L?L?fff?@33?333?333?L?  ??fff?  ?  ?  ???@??ff??ff?ٙ??ff?33@@333?ff?33@@Fff@9@l@y@   @?@33?ٙ?ٙ@333???@&ff?ff?ff?ff@@Y@Y@  ?@@333@?33@&ff@@9?  ?ff?ff?33@33@@  @   @   ?ٙ?33?33?ff???ff????  ?ff?  ???33@33??  ?  ?33?33????ٙ?33?ff@   ?33@@ff@@@33@33@33@ff@@@@@33@&ff@,@@  @Fff@LAA@  @  A33@  @@l@ff@  @  A.ff@ff@fff@Ap  @lA$A@ff@33AP  Aff@@33@  @@33@33@@@  A33AA   @33@AffA33@@@  @ff@A&ffA33A@  @33@  @33@@ff@@@@@@  @ə@  @ٙ@ٙ@@@@@ٙ@  @33@陚@  @  @A33A33AffA33A+33A  A	A33A33AAA  AK33A333A4A@  A>ffA>ffAFffAAAQA  A  AS33AfffAK33AS33AffAh  A{33AffAffAAAAffA33AffAAAffAAA  A  AA33AffAAffAA  A33AffA  AffA33AffAAAffA  A{33@ff@  @@ٙA@33@  @陚@陚@33A   A@@ff@A@AffAAA  A  AffAffAAA!A(  A.ffA.ffA333A333A<AH  AH  AVffAX  AaAaAfffAyAyA33AA33AffA  AA  A33AAAAA  AffA33AffAA  AAᙚAffAAAffAAAᙚA  B   AffAAB ffA  B
33B
  BB33AAB   AAffB
BAA  A33AA  AffA33A33AA33AAA33AffAffA  A33A  AAffAA  A33A  AAffAffAffBB(ffB  A33B}33A  AՙAffAffA  AAA{33AyAtA~ffAAffAyA  AAAAABJAffAAA33A33A33A33A33AffAAffA33A  A  AffAffA  A  AA  A  AᙚAᙚAffAᙚAA  A  AA33A  ABB  AAAffA  A33AffA噚AffA  AٙBF  A  AffA  A  A  AA  A  B_B  AᙚBpBF  B B33BB  BB
  B33AffAAA陚ABAffABB33B	BB  BB33B	33BffB
B  B33BB$BffBBDffB-33B  B&  B(B2  BF  BHffBD  BOBJBVBT  B]33BD  BI33BLBU33BY33B^  BY33B%B)B1B6  B7B133B333B8ffB733B8B>  BA33BG33BXBCB>  BM33BFffBGBI33B<B=33BHffBI33BJBJffBKBNffBNBL  BKBI33BBB:ffB>ffB>  BA33B<BbffBGBZ  BBgBi33B`ffBRffBtffBJffBM33BTBTffB[33B[33BY33BNffBD  BNB#33B ffB0  B#B%B0ffB7B4B9BA33B>ffBN  BS33B\ffBe33Bm33BhBj  B~Bv  Bw33B~  BzBB33B  BBffBffB33BBj  Bg33BoB  Bq33B  B33B33BzBp  B|ffBxffB33B  BffB  BBB33BBffB33BBffB  B  BffB33BBffBBBB33B33B  B33B  BBBffBffBB33DͿ;;;;;>L;L;;L;L;L;L    Lͽ;;;L;>@ffAP  ?     L;LͿ   ͿͿ      333   fffffffffLͿ333333333                     333               L?      fff333LͿ   LͿfff     LDɚ   LͿ   fff   333;Ϳ333      333   Ϳ;;;;      @     ?333?;;;Ϳ333   333      Ϳ;Ϳ   333333333LͿ   333Ϳ   333               333Ϳ   Ϳ   333333      333@      Ϳ333            ;Ϳ   ;;;;;>Ϳ      Ϳ   ;;;;;Ϳ   333   333   333      333333L;;Ϳ333Ϳ   333ͿLͿ   LͿfff333333333L;ͿLͿ            Ϳ;;;;;Ϳ         Ϳ      Ϳ   @Fff;;L>;L;Lͽ;Lͽ?  BffL;L;L;;;Lͽ;;L;;L;LͿ      ;Lͽ;L    =;        =    >>LͿ       >L>L>>    >=?L?       ??333>?   ?333??fff?    ?>L?L??33?  ?L>L    >?????fff?  @  ??L?  ??fff?L?  ?fff??ff?L??L>>L>?333?   >L    >?  >>?ff=?333?333?333?L?   ?fff?333?333?fff@@ff>?   >>>L>?333???   ???=?   ?>L>>    ?           ;LͿ      ;L;ͽ==    >>        >>>    ͽ                Lͽ;L;Lͽ;?33L=ͽͽ;L=;;    ;;L@s33   ;>LͽͿ   Lͽͽ;?;L;L;L;Lͽ;L;   ;Lͽͽ            ?333ͽ;Lͽ    ͽ;   L;Ϳ      ;;;L;;;Ϳ333;;;        >L    L;L       L;L;L;L;L;;;Ϳ333333LͿ333   @yL;Ϳ   L?LͿ   ;ͿLͿ333   ;    L;L;Lͽ;Lͽ;LͿ   LͽͿ   ?333;>L;;;;Ϳ   ;Ϳ      Ϳ   ;;       ;;L;Ϳ   ;    LͿ   L=ͿLͿ   LͿ333?333   Ϳ;Ϳ               ;ͿLͿ333fff333333LͿͿ?ff;    L;;ͿͿ        ?   >Ϳ   ;;Ϳ   @S33;Ϳ   ͽͿ                  333fffL;LͿ333fff333   333333LͿLͿ333333ͿL    >   LͿ   Ak33333   fff      333ͿC     L?fff   Ϳfff333L;=?BA@s33@33?33   ;ͿLͿ   333         333333   333Lͽͽͽ;;;;Ϳ   LͿLͿLͿ333Ϳ   @FffLͿL;   ;LͿL;L;L=?333?   ?   >?   >L>>       >L?  =?33>>L;L;L@Fff=?   L        L?>;L?333L>?   ?@        ?333>        =ͽ==ͽ>L            >L>L=ͽ=;L    =ͽ       L    =>L==?333    >    >Lͽ>LͿ=>Lͽ>L=Ϳ   =>L>L    @y>L>L>?>    ?   >>L>L?333?   >L>L>???333?fff?333A+33????  ?333?fff?ff@ff@ff@33?  ?fff?33C f@9>>L?333????ff?  ?ff?@33?33?ff?  =?fff?333??  ?fff?L?  ?fff?333??333??fff?L?333?L?L?   ?333?333??L??L?fff??333?   ?   >L>?fff?333?  ?  ?33?@33?  ?L@&ff??ff?33?  ?  ?33??L?Aff?  ?333?>?333>??   ?L@>L>??   ???ff?  @ff??  @&ff?33@   ?ff?  ??  >?333?L?fff?fff?ff?L?333?ff?   ??33?L>?333>?   ??   ?333?333?L?fff??L?  ??fff?333?L?L?fff?L?fff??333?   >L?L?  ?fff?L?333?333?L>??  ?L?>?@ff?33?333?>?333>L?L>@&ff>>L?   ?  ?fff??fff?L?L?   ?fff?L?  ?333?L?L?333?  ?fff=?       ?   ?L??  ?fff?  >B`  =?333>>>>>L>>@?333=ͽ>?fff>>>?  ??   ?   ?   ?L?L>?>>?   ?333?>L?>>>=    >L@>>LDs3?L;ͽAh  ?@@,@&ff@y@ff@@Y@s33@  @  @@s33@ffDp AB!33A33BB2  B
B33BAffA33B&  A홚AffAA  AA  AA  AAffAX  AQA&ffA)A$@  @  A33A33AL@ff@  A   AA   D @33Cs3@ff@@l@Fff@fff@ٙA&ff@@ff@ffAS33AH  AFff@ADALAK33ADAK33A#33Aff@33@@ٙ@33@  @ff@@ff@@  ??ٙ@L@   @33@33@ff@33@333@333@L@?ff@YA33>L?L?L?   >>=>L>L    >L?33>?33?333@   ?333?L?L?  ?33?fff?ٙ@@   DA?33@   ?33??  ???  ?333??L??  ?ff@@`  @l?ff?33@   @   ?  >>L>?   >L>L        ͽ?   =;L>L?fff????  ?ٙ@   ?333??>>>?>=?   ?L?  ??fff?ff?33???33@ff@@   ??333?fff@>>L>?   >L=    ͽͽ>=?fff=>Lͽ@?==>L    >>    L?   Dp9>LA33>L>=>L>>L=AC    =?L?>L>=?   ?333>>?L?   >L@ff;        >=>??   =>L>>    ==ͽ=>??   ?ff?333?L?>?333??   =?fff???   ?   ?333?   ?L?   >=>        ==>    ?333?  ?fff?333>>?L?  Cv>L@Y>>    =;L>L>=    >    =ͽͽ?fffL;;   L;LͿ   L;L;L;ͽ    Lͽ?fff?L?   ???   >    ?@ff??   >>L??L??  ??ff??  ?  ?   ?   ??   ??Lͽ;L        L;LͿ      L;   333>Ϳ333;L;L    @==    =;Lͽ===    @  C@   Df>>Cff    >=?fff?  @   @   @ff??   ͽͽ>?L?  ?  ??   ?   >>L>>??   >>L=?   ?   ??fff?333??fff>L?333>L>LͿ          333   Ϳ;?   =>L>L>L    ?   L;   ;L;Lͽͽ?   =    =;L;L=    L    @>>?fff???333   ?ٙ?ff@   ?L=??  ?fff?fff?@   @   A   B  @s33D&fBq33@@  @   ??ٙ?  ?@@333Cff@9@@@@  @L?33@   ?  ?  @@9@,@333@@33@ff@@?  ?33?ff?33?fff??L?333?ٙ@   @   @?ٙ?ff?33@   ??  ??ff??  ??ٙ?  ?33?33?  ?ff?fff??333??333?333?333B ff?   ?   >>?   ?   ?   ?333?L?fff??>?>    =?   ??>L>L>L>>>>?   ???333?  ?  ?  ?333?   @9A  ?   ?fff>?   >>=    >L>?  ??   >L    ==>?   ?333?   ?   ?>=    >L????  ?L?ff?  ?fff?L?fff?   ?L?33??fff?333?L?fff??  >>>?   ?L>?   ?>L=>>?   ?333?   ?fff?fff?  ?L??333?333?  ??333?333>>>?L>>>>L        >>??>>??ff?33?fff?33?33?33@@   @Fff@   ?ff@   ??ff?  ?33@@ff@ffAAA33AffA  A@33@  @y@  @@@  @陚@ff@33A33AAA$A+33ADAAAəA  AAB
ffBAffAffAffA33AᙚAAffAffAA  A33AAA  AffAAAAffAAvffAffAp  Ah  AX  AQALAP  AC33A6ffA4A0  A,A#33A(  A!A&ffA&ffAAA  A  AA33Aff@33@陚@陚@ٙ@33@ff@  @ə@ٙ@33@  @  @ٙ@@ff@ff@  @  @ff@ff@@@33@ff@Aff@ff@ff@33@33@@  @  @33@@@@33@@@33@@@ff@ff@@33@ff@  @33@  @@fff@S33@Y@l@s33@@  @,@   @ff@&ff@   @@@@?ff?ٙ@ff?33@ff@ff@   ?33?33@   @@@@33@ff?33?ٙ@   @   @ff@fff@ff@33@   @333@ff@   @,@   @   @33@@   @@   ???  @?ff@33@?  @   @&ff@?33?ff?@&ff@@Y@@9@@   @,@33@@   ?ٙ?  ?  ??  ?ff??ff?33?  ?ٙ?@   ?33?ff?ff??ٙ@   @ff?33?ff?  ?fff?ff@&ff@33@&ff@@   ?@ff@   @@9@@33@ff@33@&ff@333@   ?33@@   @   @   @   ?ٙ??@   @@ff?33@ff?33@@33@   @   @ff?33?ٙ?33?33@   ?33@@?33@@ff@&ff@Fff@33@@,@@33@@   @,@9@&ff@@@  @Fff@,@l@fff@  @s33@L@@  @  @S33@fff@33@  @@@@  @ff@  @@  @s33@Y@Fff@`  @S33@,@,@33@Y@   @   @ff??33?  ?  ?  ?33?  ??33?fff?ٙ?ff?ff??  ?  ?  ?  ??33?33?33?33?33?ff@   @,@333@Fff@L@&ff@33??ٙ?ff@?ff@@L@S33@Y@33@ff?33@@333?ٙ>L        ͽ>@   ?ٙ??33?@  @,@@@33@  @  @ff@  @y@S33@&ff@ffAVff@  @ff@ff@`  @@  @@`  @,@`  @&ff@L@   @Fff@Y@   @,@&ff@&ff@Y@333@@   @  @ff?33?33?ff??33?ff?33?ff??ff?ٙ?ٙ?33@   ?ff?33??ٙ@33@?33??fff?L??333?fff?ff?ff?33?ff?33?33??ff?  @Fff?33@ff?33?ٙ??  ?ٙ?33?ff?ٙ?33?ٙ??ٙ?ff@   @   @ff??  ?ٙ?ff?  ?ff?33?ٙ?33?33?  ??fff?fff?L??fff?L?ff?333?333?fff>>    >L>L>L=>L>L=>L=>L=>>L>==>=>    ===>>>>?>?   >L>L>L=        ͽAi==>>L=    >L>>?   >>L?   ?   >>L>>?   >?   ?   >L=;L;L;L;L;L;L?33    >?33>>L=>==;Lͽ>L;L        ͽ;;L;LͽͿ   333            333   Ϳ   Ϳ   Lͽͽͽ    Lͽ>L>;L;L;;Lͽͽ=ͽ            =ͽͽ    >>L;L;;   >L;;L;L;L;;LͿ   ;;;            ;Lͽͽͽͽ    ?L=;L;   333Ϳ      333333LͿ333   LͿ      =ͽ;Ϳ333            Ϳ   ?ff;L;333ͽ;Lͽ=    >?L?33?333?   >>L>=    >L==ͽ    L;Lͽ            L=ͽ>==ͽ    =>>??   >>=>L>L>L;    L    ;L        L;    ;L;Lͽ;L;L    ;L;        >L>L>L>L>=    ;;L;==>L>L>>>L=>L>>>L>=ͽ;         ;;      Ϳ         Ϳ      ;;L;    Ϳ      Ϳ   Ϳ      L;      LͿ      Ϳ         Ϳ;Ϳ         ;L=?       ;L        =ͽ                ;L;L;;         ;?LͿ         ;;;;Lͽ    ͽͽ    ;;L;;;Ϳ   L;L;Ϳ   Ϳ   L;L;;      ;   =;L=;L;Lͽͽ;Lͽ>    ?>>L=>L;L;L;Lͽͽ;;;=;LͿ   Lͽ    ?   >?   >Lͽͽ        >L    ====    =>L>>>L>L    >L;L        =    >>L>L=    =    L;Lͽ    L;L;=;LͽͽͿ   L;L;Ϳ      L>L    ?   ?   >>>L>L?   ?>L    >=>L=;;;;;;>L;L        L;L;;L    >==    L;L;L;;L;L;LC;L;L;L;;;L;;Ϳ      Ϳ;L;L;Ϳ   333      333ͿLͿ333333   333   ;;>>L=;L;ͽ;;ͽͽ;L;Ϳ   ;;;;;;;Ϳ            Ϳ   ;;L;L;;;;;;ͽ??  ?33@@@33@Y@fff@,@333@9@Fff@@L@Y@Fff@Fff@ff@@@33@@s33@y@33@Y@@  ??  ?333>L;L        >@ff>>?   @ff?>?  @`  @  ?33@@  @   ??  ??fff>L;?fff>Lͽ??>ͽͽ    >L>;LA<;;;L;L;L??  ?33?  ?  ?  @@33??   ??L?   =;=    >LAS33A33AffBB  A  A  AAffAAH  A6ffA!A4A;33AC33@AaAx  A>ffA;33A;33A@  A33AA0  A333A.ffA>ffA.ffA+33A  A33A  AA33A	@@@@ff@  @33@ff@陚@33AffAA  A	AA  @  @33@  @33@@ff@33@@ff@ff@33@`  @s33@33@@@@  @@33@@@33@S33@y@33Aff@33@ff@  @   @,@S33@33?ff??  ???  @@,@L@Fff@333@Y@S33@@333@&ff@9@&ff@ff?ff?33??ff?ff??  ?   ?ٙ>??33>?L?  >L    L;Lͽͽ;?ٙ    L=    ?333?33?333??L?ٙ?  @9?  A#33?  ??L???L?333?33@  ?   ?>?L?  ??L??ff?  >L>??ff?ff?  ?33?  ?333?   >?   >??ٙ?   ?   ?           L>?fff?  ?fff    >>?   ?ٙ?ٙ?ٙ??ٙ?33??ff@   ?33?ff?  @9?L>?ٙ@`  @L@9@   @@&ff@Y@333@333@&ff@333@@  @33@&ff@l@333@333@,@s33@,@ff@@333@33@   @@S33@,@33@L@@&ff@?ff@ff?ٙ?33??fff??L?fff>?333?>>>>=>>L?   ??   >>L>>L>>>?   >L>?fff?>    >>L==>L    >L=        ͽ        >L;L==>    =>=    ͽ;?  >L;;=;L===>L>L    >L>==ͽͽ    Lͽͽͽ>?>L=>??333?L??333=>>??L?333??  ?ff@   @33??  ????ٙ??ff?ff??L?L??333??L?   ?333?333?fff??>>L=>    >=    ==>?fff>?333>>>>>L=>        L            ?   >>>=>?   ?       >>L>=    >??   >L>L?    >?333?L?fff?   >L>>L=>L?   >>?   >?   >>>?   ?333?L>>L            ͽͽͽ=    =>L=>L>>L=>L>=?333@;;L;L;L;;Lͽͽ;=;ͽ        L;L;    L    =;Lͽ;L;L;L;L;;   L>Lͽ;;L;L=;=>??333?fff?fff>??333>?L?  ???  ?ff?ff@&ff@   @y@S33@9@33?ff@@,@33@9@`  @@33@ff@33@33@ff@33@@ff@33A   @  @  @ff@@@@ff@33@s33@BzffAH  @@L@   @   @@  @   @S33@`  ?ff@33@  @  @y?33@@@  ?33@  @   @   @ffAA;33@9@,@ff@  @ff@ff@?33?  @ff?ff?  ?fff??  ??L???ff??  ?ff?ff?ff?ٙ?ٙ@ff?fff?33?@   ?33??  ??  ??L??  ?  ?  ?333?   >L=                            >??L?fff????ff?      =>L@@  @  @      L@L@9?   LCffC&fD@ CCٚ=BޙC{fCC Cƀ CC&fD'C33BffC@   C3C3?L@33A@S33??L?ff?333?fff?L>L?LC  ?   ==ͽ    =>Lͽ    >L    >=>L>>L>L==;L;L        ;L;    L;L;L    ;;L;;;L;L;L;           L    ;;;L=;L    L;   ͽ;            333333Ϳ   ;L;Ϳ333LͿ   Ϳ   L;L;;LͿ   ;Ϳ         ;LͿ;Lͽ;      @  Lͽͽ;L>?   >>    ?=        L=;L;;L;L;L;;L==?   ?   ;ͽ    L;=?  ͽͽͽ;;L;Lͽ;L;   333   333      ;   ͽ=    L=;=>L;L;L;L;;        ͽͽ;L;L;L;Lͽ;;ͽ;;ͽ    @?L>?L?fff?fff?fff>L>L>=ͽͽͽ;L;L;    ;    >L    =ͽ;L    ;A>L=    @   333LͿ333   Ϳ   @Y   >L    =>@&ff>?333?L?>===>>L?fff>Lͽ;;Ϳ      =;L;Ϳ   ;Ϳ      333LͿ               ;;;;Ϳ333LͿ      L;LͿ         Ϳ      L;L;L;L;LͿͿ   L;        ??    ?333??L>?   ?ff=    L;L;LͽͿ         333;;;ͽͽ    =Ϳ   >L>L    =;Lͽ    =    L=    L>Lͽͽ;L;;;   A  L;Lͽ;L;L;L>       Ϳ   333    =>>=>>L    ?333>?   >L??L?   ?333?ff?>>>L>L    >L>>>???   ?333??ff?   ??>?  ?  ??ff?L?L?333?   >>>L>Lͽ    L;L    Lͽ;L;L;Lͽ    ͽͽ;;===    ͽ;L;L    L??   ?   ?333?   >>>>>L>L=>>L?   >?333?333>L>>>>>>L=>>L>>L>?   >    >=>L>L>>??333?L?L>    >L>    >??L?333?  @,@333@9@Fff@S33@L@9@Fff@Fff@`  @@l@  @@33@33@s33A33@@  @LA  @33CffB@`  BB,CF3CCB  @ٙ?33C$ C}ffCdLC BQ33BC*33DJfBffAffB33@ffC33D C33CCG@CC  DlCI3@ٙBffC"ffA@ff@陚@  @@33@  @33@ff@@  @@33@ə@  @  @@fff@ff@@fff@`  @fff@33@S33?ff@&ff@@@fff@Y@fff@33@@@@ff@ff@  @@@@ff@  @ff@  @@@@@@ə@ə@ə@@ff@ə@ff@@ə@ə@33@@33@AəA   A<@陚@33@  @ffAT@Afff@@ff@  @  @  @@A33@33@陚@`  A$@fff@ff@ff@AA@Fff@l@s33@s33@Y@s33@lA   @L@Y@`  @s33@Y@9@`  @@  @9@9@9@9@L@,@Y@L@Fff@fff@9@@?33@@ff@   @   @y@33@  @  @33@@  @`  @ff@@Y@L@9@Fff@9@`  @Fff@Fff@@  @s33@s33@  @@33@ff@y@@S33B33@@ə@ٙ@@ə@33CAff@ff@A   A   A#33A@ff@33@ə@@ff@33@ff@ff@@@  @@@y@@  @33@Y@Fff@L@Fff@,@33@,@&ff@Fff@333@   @L@Fff@9@9@ff@ff??ff?ff?ff?ff?ٙ?ٙ??ff@&ff@@33@&ff@@   @33@&ff@   @&ff@,@@33@@   @33@   @ff@ff@@,@9@L@L@s33@y@s33@`  @l@ff@@333@Fff@ffA(  AA噚B  A  AffA33AAffAݙB  CDBOAffBA33AAAA  ABBffB33BCnAffAnffAnffAfffAdAA33ABB33BffAffB B	33B   AՙAAqAA33AffAh  AS33A9A6ffA(  A)A1A.ffA4A0  A;33A9A+33A0  A33A(  AffA33AffA33AffA  @ffA33@陚@ٙ@  A33@33@33@ff@@ff@ٙ@@  @33C833@ff@33@  @@yCfCf@fffA4@y@33@S33@fff@l@ff@ff@@@33@@  @  @ff@33@  @@ff@@fff@Fff@fff@@  @@  @333@@  @9@9@Fff@333@9@   @   @L@Y@   @&ff@333@,@,@@  @,@&ff@33@?33@   ?ff?33?  @   ?33@?33?33@33@@@333@&ff@333@   ?33?  ?ٙ?@@   @?  ?333?@33@@333@ff@ff?33@   @&ff@33@33@ff?ff?@33@Fff@,@   @   @   @   @&ff@?ff???  ?  ?   ??????L?  ?ff?  ?L?L?fff?  ?ff???ff?ff?33    ?333?ff?ff?ff?33?33?  ?  ?33????33?ٙ??33?  ?fff???33?33?33?fff?>L    >L    =>>L>?333>>L>L>L>??ff?ff?33?33?33?ٙ??33AB  ?33C?ff??ٙ?ff?fff?BڙCL @lAff>Cs3CL ?   A33>@   D;ٚ?333B  D@   CfCffCAff@s33B?33?A)CٚA  CfCkffCIfB33@ff?@ff>>LA?>?  ?L???L?   >L>L?L>>??fff??L?  ?ff??ٙ??L???fff?L?L??   ???fff?333>??  ?   >>>>?>L>==>L    >>L>?333??333?>??333??333?333?@s33?L?L??fff?L?fff??L>?   ?  ?  ???   ?333?L?333?fff?fff?fff?  ?  ?  ??ff?L?ff?  ?  ?  ??   ??fff?333>??>?   L>    ?fff>L>=>>??L?L?   >>>>???>?   >?   ?   ?   ?   ?   ?  ?333?   >@ff?L?Bx  >?LBff?   @   ?ff?ffBDc3BffD)Y?333?L??ff?33?  ?ٙ??ffCɦf??33?  ??33?  @ff@??  ?33?ff?  ??  ?33?33@   @ff??ff@9?fff?  ?fff?  ?fff?   >?L?fff?33???   ?333?   ?  ??ٙ?ff?ff?  ?L??ff?ff@,@?33?33@ff?ff??ff?fff??ff?L?  ?ٙ?ff?ٙ?ff@   @   @ff@33@&ff?ff@9?33??  ?  C@333?fff?C  BffA33AnffA33B33@`  CffA  ?33BBffA33?33?ffBBe33@   A   A@   @ffB333A@fff@&ffAř@,B.  D @Fff@333B%?33@333@333@`  @`  @`  @S33@Fff@L@333@@  @@  @l@@  @,?  @@@@  @&ff@9@@&ff@,??333???fff??  ??ff?33?33@y@Y@33@fff@,@&ff@9@333@   @@ff@33@,@ff@33@ff@ff@&ff@,@33@S33@L@9@,@@@   @   @   @333@`  @   @9@l@s33@L@Fff@33@333@?ff@ff@?33@ff?33@   ?33?ٙ@33@@fff@33@333@@9@@  @@@&ff@33@   @333@33@ff@333@   @333@fff@333@333@y@S33@@  @fff@Fff@33@9@   ?  ?ff?  ?ff?ٙ?ٙ?@?ff@9@   ?ff@   ?ٙ?ٙ??33?  ?33@&ff@33@   @Y@fff@y@s33@   @S33@?33@   @9@Y@,@Y@9@@  @L@   @L@,@   @   @,@33@9@Fff@`  @@   @9@   @   @&ff@33@S33@9@   ?ff@@&ff@Y@   @   ?ff?ff??33??  ?33??ff?ff?33?ff??   ?  @ff???ff?33@&ff@@  @33@33@  @Fff?33?ٙ@@ff??  ?33@,@@ff@?33@  @S33@l@ff@ff@fff@s33@s33@@  @Fff@,@9@33@@,@?ff?  @   ????33@   @@Fff@333@L@   @@@&ff@   @L@   ?33@,@Fff@@333@9@&ff@`  @@?33@?33?33@&ff@@33?33@&ff@33@S33@33@?ff@&ff@33?ff@fff@333@9@33@Y@@  @Y@&ff@@  @L@   @ff@&ff@Y@@9@Fff?@Fff@`  @@&ff?@,@?33@   @,@33@&ff@9@Y@333@@  @`  @Fff@&ff@33@33@9?ff@   ?33@S33@ff@L?ff@ff@@&ff@33@&ff@@  @Y@l@@9@,@fff@33@ff@@   @   @   @,@   ?33@ff@?ff?33?ٙ@S33?33@@   @@  ?ff@@?  @33@fff@s33@   ??  @,@&ff@33@@   ?  ?33@@@33?33@&ff?ٙ?ff@@  ?ٙ?ٙ@&ff?33?ٙ@33??33?ٙ@9@@   ?ff?33?ٙ?@ff@L@   @,@333@Fff?33@ff@ff@&ff@   @@  @@  @@Fff@l@@@  @l@s33@,@   @fff@333@@  @,@S33@`  @   @ff@s33@33?33@S33@33@ff@@Fff@L@Y@L@Y?ff@,@Y@fff@Y@@  @L@y?@@333@Y@S33@  @fff@33@333@L@S33@S33@@333@ff@@ff@@@  @ff@@fff@,@S33@@`  @  @@33@ff@Fff@`  @fff@  @S33@fff@fff@Fff@&ff@s33@ff@33@   @   @l@`  @y@  @@`  @ff@S33@   @Fff@@Y@@`  @  @&ff@l@S33@Y@@@333@  @@  @@  @  @L@  @`  @Y@s33@l@@L@33@  @ff@S33@@  @@  @33@@@y@Y@@l@@Fff@@s33@  @ff@33@Fff@`  @L@  @ff@   @9@L@`  @@  @333@  @ff@ff@@ffAX  @33?33@ff@&ff@Fff?  ?33?@Fff@fff@s33?ff@@@33@ff@`  @&ff@ff@Y@Y@Fff@@9@@,@   @  @33@@@333@@ff@@@@@@@33@33@  @ٙ@ff@fff@33@ff@  @@33@33@  @@@ff@S33@@  @  @33@ff@ff@  @33@33@陚@ff@ffAx  A\AK33AnffA&ffA&ffA;33A#33AA0  AffA33A  Ap  A   A   As33A9A`  A,ALA+33A   AAff@33@33@  @33@ə@@ٙ@33@ff@@33@33@@33@33@33@33@33@@@  @@  @@@ə@@@@@33@  @  @  @  @@Fff@@  @@33@  @ff@@ff@  @33@Y@C^Bff@ffAs33BAVffA@AvffA33A33@@l@ff@s33@ff@s33@@s33@S33@S33@ff@ə@`  @  @  @@  @@  @y@@33@,@ff@ff@@@  @@  @33@33@@@  @333@l@@  @@ff@33@333@Fff@ff@ff@y@@33@@ff@33@L@  @ə@ə@33@  @ff@ffA4AAA(  Ax  AyAx  A33AAA33A^ffA`  A;33A$A)Ak33A(  AC33AYAH  AffA4A>ffA.ffA	AK33A33A  A(  A33A  A33A  A	A@@@33@33AA9@33AffA@  @陚A   A33A6ffA33@33@33@陚AffA   A33@ٙ@  @33@@y@33@@ə@ə@ff@l@ff@  @ff@y@ff@@  @  @@  @陚@陚@@ff@@@33@ff@@@@Y@@L@fff@  @Fff@  @s33@`  @s33@  @fff@L@33@l@@@  @y@  @y@y@fff@ff@  @  @L@s33@`  @L@S33@9@Y@@  @&ff@@  @Y@l@@@y@ə@fff@Fff@@y@@Y@@@@  @@@Aff@  @ff@  @@ff@  @@  @@@33@  @  @@@33@@33@  @33@33@33@Y@33@@33@33A33@A33@  A   @@@33A@33@ff@33@ff@  @ff@ə@@ff@ff@ff@ffAff@ə@ffA  @33AA@@@33A33@A33@@33@33@ə@  @@33@@@@33@  @@ٙA@ə@ff@ffA  AffA@  A33A&ffA33AAAffAffA,A@33A#33@ALA	A,A6ffA)AAA33AAffA33A6ffA(  AC33A+33AYA333A	AqA#33A&ffA9A&ffA1AH  A33AH  Ac33A  AA33@A(  A33AffAff@ffAA$A	A!A   @A  A8  A33@AA  A;33@33A+33@33ADA  A)AA(  AffAff@A@ffAff@ffA@@33AA@33A33A   A#33AAffA	A#33A  AA33@33A	A   A.ffAff@33A  AAffA   A+33A6ffA333A33AaA0  A&ffA`  AFffAAA33A!AIA   A333AAC33A#33A<AffA  AdA+33AC33A[33AIAaA33A   A33AAAAA@33A  @ff@33A  @ff@ffA  A;33A33@A33A@  @əA	A)A333A<A#33@@ffA   AA333AC33Aff@  @33@33A33A@  @33A)@  A  @@33A	@A9@ٙ@ff@ff@33A@A)A@ffA@33A33A$A@33@ٙ@@ffAAI@陚@@A   A  A   A6ffA>ffA(  AAff@A33A0  A   @Aq@ff@33@ffA@ff@33A@33A@33A33A@33@ٙ@A+33@ff@ff@33@əA33A9A$@ffAffA  A   @ٙA;33A>ff@33@陚@ffAA)AAAC33@陚A33AA@ffA9@A@ffA  @AA+33@ٙ@ffA0  Aff@  @ٙ@@33@33@@  @@@A	A!@A33AA[33@ٙAlATAC33A6ffADAFffAAs33AyAs33A0  AffAIAAffAA#33@A4A+33A   A!AAP  AIAffAAAffAYA&ffAtA6ffAX  A$A@  A$A  AdAffA.ffA&ffAAffA33AAA8  AffAP  AP  AffATA>ffA.ffA\AX  A[33AFffA33AAS33AAaA  AAAQAANffA33AiAfffA\A$A0  AffAAA.ffAAff@ٙA	A33@33AAVffAA)A6ffA1ATAh  A	ALA  AA33AC33AqA)A.ffA>ffAA;33A  AA33A  AFffAAAIAx  A)A;33CLA0  A  A$AAff@33A\A~ffA333AIA  ANffAffAA33Ax  AAVffA#33AAffAYAA6ff@A#33A	A&ffA  AFffA$Ak33A.ff@ffAc33AdA.ffA9AFffA  @A&ff@AA  A   A33A@A  A	ALAA!AnffAAA   A33A~ffAATAAA~ffA  A{33AffAIA<A(  AP  A  AFffA1A   AAffA6ffA0  A$AQAS33ADA1Ak33A#33A33AP  A#33A~ffAP  A<AaAAtAx  A,A4A0  A6ffA;33A1A@  AiA>ffAaA@  AdAk33AffA  AnffA33ALA33A~ffAAA33AqAp  AA  AAffAffAffA  AA33A33A  A  BffAffAffA  A  AffAffAAffA  A  A33A  AffA33AAA33AA33A33AAAffAffAffAffAffA  AffA33A  A33A  AA  AAffAlAA~ffANffAA33A@  A  AAffAffB  A  AAA  A陚A33B33AffA33B33A33AffAAAA  AAݙAA홚A33AAffA33AffA33AAffA33AᙚA噚AAAA33AffAAA33BffAAљAB33AAAffAA33AffAAB   B33BC33B ffB)33B33B%33B
BAB  BB%33B ffB  BAB*ffBBB33B?33BB'B
33B  B33AB!B(  B*ffBBBBffB33B"ffAB+B,  B  BB  BFffB4  BffB2  BB  AB0BffBB%33B8BABB!B/33B33B  B$  BB"BB33B:B&B8  B'33BB0BSB33B  B!33B2ffB)A  B(BB533B*  B)B   B33B733B133B*ffB8  B/33BLBC33B533B ffB4ffBffB0  BDB5BPffBBVffB/BnffBRffB<  B&ffB<  B%33BC33B)B6  B.  B%33BA33B  B<B;BU33BG33BffAB  B;B)BEB<BG33B"B(ffBffB.ffBBffBB  BZffBA33B.BEB/33BFffB6ffBBB2BVffBB533B#B>  B,B*BLffB@  B9BPffB@B^  B%33BABRBMBb  B>B,ffB0BJ  B.ffBmB33B2  BffB&Bj  BFB.ffB  B4ffBIB6  BPffB733BxffBX  BFB`Bj  B33BxB.ffB  B0ffBrffB&ffBIB,BKBW33BDffBO33BR  BaBDffB-B<  BRffB<BNffBrB.  BC33B8B7B
BABSB733Bf  B\  BvBOB933BQ33B33BvffB&ffB ffBH  BUB  B3B?B_33BUBjffBK33Bm33BBu33BW33B733Br  B33BffB33B33By33B  B  Bx  B33BBB33B33B  BBBBBffBBB  B  BՙB33B33BBBB33B33B33BBu33BB33BB33BffB  B  B33B33BB  BB  BffB  B  B  B  BffB[B  BBBzB  B  BBffB  B{33B  BBffB  BBl  B  B33B  BB33BəB33BffB33BBffBBffBB  BBffBBffBBffBffB  B33BffB33BffB  BB  BffBBB  BBB33B  B  BffBffB33BBS33CffB@  B\ffCfBffB/33A  BzB  B  BBR  B#BC33BLffB33BB$BmB2B2ffB^  B  B#33B,BfB8ffB?BJBRffBVBV  BOBFffB.ffB!33BH  BxffB,BBB733BB^BB;33B33BOB:B]B2  BgBTBKBBeBBG33BO33BB3B'33BZCD|fD<B  B33Dc3D>B-BB8  B4  BL  BB:B ffBB.  B`  BQ33B6B*ffBB%BffB1BB@BRffB4ffBbffBNB=BBO33D@ CN33BZ  BFffC33B>B2ffBZ  Bf  BYBsBbffBUB;BBffBq33BLBffB\  BLBtB^  BJBPB@  B3BoBd  BRffB33BffBTffBEBffBA33Bl  B'33BB  B>BffBBD  B$  A  BB`B9B33B@  BBffB  B33AB0  BB  DLBffAffA  B33B33B533BVBffBB  B0B)B
B:ffAffBY33AffAffABA33B  BB'B
  ABffB)33B33B0B?B*B  B6BA33B B.  BB$AffB'33B33B  BD  B=BB*ffB  BffB0ffB2ffBKB(  AffB2BB  B$ffB|  BB ffB2  B=B'33BD  BBj  B<ffBQ33Bm33B  B333BW33BFffB0  BB933BKB=33Bc33BM33B'B
33B/33B33BFB33B#AB>ffB'B33AffB A33B  B  BA33B&CYA  A  BB  AB33B7B'BBI33B  BlffB  B*B  B&  B  B
BB%33BB33B,B>ffB*  A33B  B8ffB#33BB-33BODfB33BKB"  BA  BffB  B"AffBBBBD  B33BBB4ffB!B  B'BBF  A噚B33BB,ffB)BffBB  B
ffB@B]33BOBffBKB4B   B  B  B>  B B#BJffB B!B ffBffB33B*ffB@  B:ffB33BffBBHffB<ABB BffB>B33B0  B=ABjB33B
ffBP  B	B)33BB(  BnffB33B@ffB$B33BBr  BDBPB*  BGB533B~ffBB:ffBUBEBB33BffBffB33B&ffB33B  B
B#B3BBB#33B*B4  B7B+BffB33BffBA33BD  BB@BB:ffBWBP  B?B)33BB  BeB;33B&B;33BB-33BD  BF  BEB  AffB>ffB3B-BZ  BffBB/B  BAՙBB:ffB2ffB*  B!33BB133B(BBB  AAffBA  B"B:B,ffBffB<ffB/BB0B4B#33B  BB33B33B]33B,ffB$ffB33BffBjBRB0ffBHBABBB,ffB'BBzBdffB=33B,A  BJ  B  B0ffB5A  BrffAffBffB
33BA33B33A33ABv  B(B\B  BBBbBffBBB  B  BJ  BBBTAffB  B?33B@  BffAB"ffBP  BB  B  B:  BM33BHffBB?AffB  BB33B	B  B*BffB(  B33B33BDBNBffB:  B<ffB  B BB(  BBB8B4ffB&  BB	B$  B
BBXB33AB0  BFffBB>BffB33AB*  B$  AffB+B  BABvB933BB@ffBffBA33B  B:ffBdffBO33B^BD  Bh  BbffABB3B&  B33B2  B33BffB733BDffB,ffBBVffB  B   A33B33BB  BffBI33B8  B)33AB
  B>ffBDA  BB  B:B<  BuB3B333BffBffBffBB33B"ffB0B33BffB+B,  BffBBT  B33B$  B2ffBBA33B33BBBffB&  B*B33BffB"ffBRBRffBGBmBY33BJffBjffB3B^ffB(BKBs33B8  B4  B6  BzffBpffB;BxffB{BJffB"  B&B(AB:ffBLB@BBOBffB33A  B.  BI33BffA33B133B  B(B/B<ffBffBBBB'Bc33BVBf  Bi33BB%33B"B!33B'BS33BjBffB33BBB   B6  B33B&  B0B733B333B  BK33B  BffBh  B   BA33A33A噚BB33B  B33B\B4  BF  A  BffB*ffBVffBPffBO33BffB"BOB&B33B<BEBH  B B0ffBb  A噚BBBN  B
  B  BBDB   ABQ33B&B,ffB*ffBnffB  B`ffAB8B|  BVffBpffA33BbffBNffB+BOBw33B#33B33BRffB333BBVffB"  B,B@ffA33B\ffB6ffB  B133BLffBaBt  B33BffBffBH  B(ffB?33BVffBB(Bm33B
B|ffB  B8B33BABIBZ  B,ffB<  B  BffB>  AB*  BB(A  B?BN  B"  BCBg33B.B  B_33B<B,  BB33BO33B2  BP  B*ffB933B@ffB  AB  B)BtBffBLffB33B$  B6  B  BVB9B	BBz  BffB'33B:ffB=B?B%BGBfffBFffBVB33B2By33B?33A  BTBBBt  BR  Bg33B"B]33B  BXB'B8B733B<BBI33B	ABBBBjffB33BBB*ffBOB@ffB+B$ffB>B(ffB33BD  B0  BB	B+B  BBffA  B@Br  B!BAA33B BIB:  A  ABA33BJ  A홚BB33AB=33A陚B*B3A33B ffB   B  AffB-B333B  BWB33BH  B  B.BC33AřB  B"  B0ffA33BB&B8  BLffB(BBB-33B33BffB^ffBD  B!33BB33B)B33B=33B  B.AB@  BffB(ffB.ffBH  B33AB ffAAffB.B ffBB33BB@B/BgB&ffBBCBBeBP  B33B+33B33BC33B
Bd  A  A  B  AffBB
B  A33A33B?B33BffB.BffBAB+33BB  A  B  B7BB33BB)33BE33B:ffBB$ffB#33B,B-33A  BBC33B  AffBB#A  B33A陚B  BffA33BdffB33B^B  A33B  BffB33A  BBffBB33B333BA  BABBB  AffBBB+33BffBB   AffBA  AAB(  B6AݙB0B  B4BK33B6BBBB>  A陚B.  A  B33B;33B  B933AB  BB+B
33A  AffB33AffB1AffAA33B33B33A  B+BA33B:ffBB33AffB  BAB$ffB8ffBH  BV  B(  ABM33B.B&  B BffBAB7BB"  BA  B   A33BffAB#33A33BB5BB&B  B  B0ffBA  ABBAB#BffB
ffA33B*  B33ABGA  AB0ffBHB!33B.B33BBBB)B  BAB6ffB#BffB!BffB<ffBffBffB(  B0ffB  BffB33BB-B  BB.BB&  ABffB0  BB9B B	B(  BHB
BW33BffBvBN  B(  B33BBB%33B<BffB  B33B533B33BffB0BE33B  B,  B6ffB  B,  BB33B133BRffB+33BLffB@ffA  B:B^  BB8B*  B]33B33B?33BHffBB-33ABU33BD  B`BPffBmBlBBBiBLffBffB)BiBB  BB  BBffBBffBk33BBffBrBJB9B4ffB533B?33ABk33B33B@BK33AffB!33BI33B^  B  BXffB
  BP  B/33BC33B.  Bd  B533BU33Bm33BS33B  BcBBffBB33BaBBffB  B|BffBMB  BffBBB  BffB  BB  B  BffBffBB33BffBB33B33B33BBB  BffB33BffByBB  B}B]BBW33BqBh  BjffBffBq33BffBnffB/33B  BBw33B33BqBBffBBBBB33BB  BB  B  B  BB  BBk33BffBffBB`ffBnBBtB33B33B  BB33B  B33BffBB33BBBB33BB  BffB33B  B33BffB33BffB  BffBffBffB  BB  B33B33BB  BBB  BB  BBBBffBffBv  B33BB33A  BBA33B'33B0BB%33BBFffBH  BDBXffB?33BffBxffBN  BBffBR  BdBb  B~  BB^ffB33BBB  BffBe33BiB  Bn  BB|  BB33BffB*ffBBffBo33BG33BffBnffB33By33BBMB33B]B8ffBBzB'33BPBW33BffBt  BPBBPffBffBd  BT  Br  Bv  BJffB933BpB.Bb  BnffBzBB  B33BffBm33B8  BOB  B0ffB  B33BBB33BBB-33B>B\ffBz  BBG33BLffBB=33B|BYBB  B>ffBffBBBffB33B33B33BffBffBfffBBP  BBBB33B33BB33BB@ffB33B  B  BBb  B<ffB  AffB  BNffBe33BCBDffBU33B?BB  BmB9BnBaB"  BBBYBH  B!BLffBB  BSB<ffBQBBABh  BffB2  B_B&  B%BffB8  B  BBB	B(B  B0ffBB*  AffBE33BkB;33AffB@ffB0B%B,ffB  BHBGB<BRB  B
33ABBffB  BA33B&ABffB33AB  B  ABffB-33B-B ffBA33B B#A33B  B)33B$ffB(ffB33BB(ffBB:ffA33B!B8B,  B"  B(BXBBA33B{33B[BtffBffBBlffBx  BB  B33Bl  BXBffBBBNffBoBB  B^BB  Bs33B_33BaB|BB  Be33BHB33B`ffB,ffBfA33AٙB&  BBmBffAffA홚AᙚB B  B8B6BBL  B  B   B5B>ffABPffBfffB  BJffB4BB4B]BS33B|BnffB-BB+33BCB\  B>BB	By33B4ffB#33B?B'33BB$ffB&ffB=33BwBffB[33AB$B,ffA33B)33A33BffA  B[BBffBlffBB/B3BABN  BUB.ffBoBe33B,  BffBE33B3B3B  AffA33B	33B  B33B6ffB533B   B@ffBlffB)33BB533BQBhB\  Bd  B33Bz  BBzffBffBB  Bv  B33BNBbffB=BEBU33BFB,B.B[33BBTffB  BffB  B33B  BffB/33Bm33AB6BpffB$  BE33B8  BB%BQBB\  BAB>  BB6ffABNffB!B  BffB*B333B*BB  BdffB133B33B@  B$B#B%BI33BBdBBPffBnffBn  BBBB4  BBLffBLA33BR  AA  B   BffB33BFBOB33BqBDffB|  BTffB  B  B.  B
B/B333BpBSB3BHffBY33B3BAB  B!33B933BdBCB(Bd  Bc33BjffBGB}B BB33B ffB7BE33B?33BP  B+33B33B#B933B733B;B9B;B$BlffB?B$ffB%B_Bb  Bc33BtffB33BhffBlB  B7BBvffBIB>BffBB6BBxBvffB33B3B  B  Bz  BwB33BBRBT  BBZffB{33B33B[33Bx  B33BBBffBj  Bh  BM33B  BFBXffBffB  BF  B,ffB~ffBfffBB2ffBffBABHffB8BJ  BB4ffBH  B]BDffB,B  B_33B|ffBD  BffB  BBffB6  B{33BB\BffBA33BBBi33BffBBffBffB33BV  B33BB  Bd  BqBBffBffBřBffB33CfBB  B  B33B  B  B33B33BBBB  BffBBffBBffBB  BffBlffB  B  BOB33B33BBffB33BB}33B ffB;BQB   BwBg33Bc33B!33BVB33BAB+BBlffBuBBB  B33BBB33BBBwBffB  B33BBBBffB|ffB33B  B33BB33B  B  B  B33B33B33B  B  BB  B  B33B  BffB  BBB  B33BB33B33Bs33BffBffBffB  BB33BA  BC33BW33Bx  BB33B33B33B陚C fCLC$ C
fBffB33B33B  B  B  B@  BBkB&ffBtBdBQ33B_BNffAB<ffBUBBffBv  B33BB  BřBB33BffB33B33BffBffBBQ33BBzB}B33BjffB  Ba33BhffB4ffB133BBBffB,ffB133B&ffB%33B4  B  B8  BBRffBB  BG33BPffB3B ffAٙBl  BNffBBAB5B  BMB33B33B
  BKBXffB?B33B4  BBB9B533BffB\  BBi33B  A33B33BZ  BUBd  BffBJ  BE33B$  BM33B<  BI33B:  BBV  B\  BffBJBF  B_BZ  B+BPffBTAffB#BYB+33B*BA33BeBB33BB2  By33BBB33BH  BXB33B\  BfffBs33Bq33B8B$  B\BhBffB|B	33B  BS33B_33B`BB  B533BBEB  BpffBCBfB;33B33BffBwBVBf  Bp  BffBq33BlB~ffBBffBH  B~  B33B  BvBffB  BS33Bi33Bs33B33AffB33B!33B(  BBJ  B  BB33BBF  AݙBR  B7BB  B  B]33B[Bm33Bi33BpffBrffBPBZBdB\  BRffA  AB4  BvB_33BNffBc33B(ffBVffB2B333BFffBu33BlffB.B/BBe33B8B0  BD  BJBPBbffB8ffB(  B$ffB  BHB  BB"ffB,BbB
33BH  BZB@ByBffBf  BrffB[B`ffB333B7BmBMBn  BffB33BhBq33B33BBQBBj  B33B33BffB33BBaBB~  BhB33BBo33B33BBKB  BB_33BffB  BffBffBvBVffB  BqBffB  Bw33B$B}B#33B]B*B?33BQB2  BA33BffB933BPffB6  Br  BffB33B^ffB3B?33BFffB  B33BX  B+B
ffB;BB  B33B
33B33B.  B4BBBS33Bv  BGBTBB/33B5B8BABN  BbffBe33B33B8ffBvffBfffBBy33Bu33B  B|B  Bi33BRBBBffBffB!33B  B@  BZ  BBBBC  CVCmLC\fC0ffC:C3BffBB  B33BBB  BffBffBBs33B]33BUBBffB33B  BBdBqBV  BCBpffBGB;BT  BSBi33B,B@  BLBB%33BBB  BBAB-BBA33BKB  AffB933B   B6ffB*ffA33B"AٙBAAffB"  AffBA33B ffAffAٙBB   B+33B0AffB+33B.ffBAffA  A33A  AљAffAAA33A  B  A33A  AA  BffBffABA  AA33AAA  AA  A33A33AffAՙA  B!AA  AffAB33B33AݙAAᙚAAAA  AffBBBAAffA33AA  AAA  AAA33AՙAAffAffB-33AAffA33B   A33A33A  A  B533A33A͙AffA  A  AffBffBB ffB33AAAffB'A33B	33AљABffA  B ffAffAffB  A33A  A33AA  AəAA  AffA33AAAAA  AAffAffAffAAA  AA33A33AB  AAffAffAffA33A  A33AřAA  A홚BA  AffAAffA33A33AffAffA33AٙBAAffBA  BAՙAffAA33A33BA33B&ffA  B*ffBBAffA33A33AљAffB   A33B  B33A33AABA33AA  B
ffB
B33AA  AffBAffAffBff?ff@Fff@9@l@ff@33@33@@  @Y?@Fff???   ?   ?   >?333>??   >>?ff?33?ff?33?33??ff@???33?  @?ff??  ?L??  ??33????ٙ??fff?  ??33@@?ٙ?ٙ?33?  ???  ?ٙ?  @ff@333@   ?ٙ@   ?ٙ?ٙ?fff?  ??ff???  ?  ?  ??ff?33?33??ff?ff@?  @   ?ff?  ?33?fff?fff@ff?ff?  ?  ?ff?33@,@Y@Y@@  @   ?33?333??ff?33??ff@   @33@@9@@   @333@&ff@,@,@,?ٙ?ff??ٙ?ff?ٙ?  ??ٙ?33??ff?????fff?fff?ff?  ?ff?ff?ٙ@@,@L@   @?33?33?ff?33?ff@ff@ff@ff?33??  ?ff??ff??ff??   ?   >>?   ?>????  ??  ?  ???fff?  ?333?  ???  ?ٙ?ff??fff????33@@@ff@S33@,?33@`  @fff@@  @S33?33?ff?33?33?  ?ff?>?ff?L?33???fff?333?  ?????33?33???  ?33?ٙ@??fff?  ?33?ٙ?  ?  ?33?33@   @,@33@,@33@33@&ff?ff?ff@ff?ٙ?ff?33?  ?ff??   ?fff??333??  ?ff?ff?  >??L?fff???  ?fff?33?  ?  @?ff??fff??  ?33??????ff??  ?33???ff??fff>>?   ?ff>?   >L=>L=>L?fff?  ?333?fff?L?333?L>>L>???L?fff?333??333?333?333?L???333?333?  ?333?L?333?333?L?333?   ??>?>?   >>>?333?   ???????fff?333?  ?  ?  ?33?  ??333?L?333??fff???33@ff@@33@@ff?ff??fff??ff??33?33?ff?ff?L??  ?L??333?  ?L?   ?>?fff??ff?333?333?  ??   ?  ?fff?fff??fff?fff??ff?333??33?ٙ??  ??  ??333?fff?L??333?333?   ?   ?   ?   ??   ?fff?   ?fff?333?333?fff?L?L?L?  ?fff?fff??L?333?fff?333??>?   ?   ?333??  ?33????333>>>>L>??ff?fff??   ?  @ff?33???  @ff??33?ff??  ??333??ff?33??ٙ?33?  ?ٙ?33?33?33??>??ff>?L??L>>?333?   ?   ?33?ff?ff?  ?  ?   ?  >>>>>>?333>>??   ?333?   >L>>L>?   >L>L>L?   >?   ??L>?   >L>>>>===>>L>>>>>L=>L==>>L>L>?   ?333???L?333?333?L?fff?  ?  ?  ???33@ff@,@   ?ff?  ?   ?   ?   ?L?L?L?L?fff?L?333?L?   ?   >?   ??   ?  ?33?33??ٙ?33@ff?33@   @   ?ff@?ٙ@?33?ff?fff?ff???ff?33???ff?  @ff@@ff@ff?33@@   @   @Fff@?  @   @S33@333@ff?  ?@   @   ?ff?33?ff??ٙ?ff@   ???33???33?ff?@@s33@9@ff@9@333@y@fff@@  @@  @@@333@33@33@fff@@  @@@,@@  @  @33@ff@ff@l@S33@fff@Y@@  @,@&ff@L@L@Fff@9@l@ff@Fff@@  @Y@Y@Fff@Fff@S33@Y@y@y@l@33@ə@  @陚@  @  @@33@l@l@y@y@ff@@@ff@ff@  @33@ff@@y@fff@y@@@ff@@@@ff@Fff@`  @Y@s33@L@@  @`  @S33@`  @S33@`  @`  @`  @@  @Fff@333@&ff@   @,@@333@&ff@@ff@  @  @@  @`  @l@333@L@`  @s33@@  @S33@@  @9@   ?ff@   @33@???@ff@&ff@@  @@Fff@333@33@ff@fff@fff@,?ff?ff?  ??ff???ff?ٙ?ff?ff??  ?fff?33?  ??ff?  ?ff?33?33@@   @   @   ??33?ff??ٙ?33??  ?  @&ff?  ?33?ff????33?33?33??  ?33@   ?ٙ@   ???33?ff@   ??33?ff?ff??33?ff@33@33@&ff@@@   ?ٙ?  ?  ?ff?33?33?ff?33??ff?ff??ff?33?  ?  ?ff??ff?33?ff?  ?33?ff?33?@   ?33?ff??ff?fff?fff?  ?L?333??333>?   ?fff??  ?333?L?fff???  ??fff????  ????L??????ff??33???L?ٙ?33?ff??L?fff?33?33??  ??  ??fff?L?  ??ff?ff??  ?  @,?33?>L>?L@Y?33?ff??AQ@33?fff?  @`  @ff@   ?33@   @33?33@ff?33@9@?ٙ?ff?ٙ@ff@@  @Y@y@Y@L@Fff@y@L@y@ff@@  @@@  @L@@y@333@@@9@9@333@33?ff??ff?@9@33@ffA33A;33A4A0  AiA9AffA33@@33@  @@@ff@@  A   @33@  @ff@A	@  A@ff@  @A	A	@33@33@`  @`  @  @@  @,@9@@  @333@  @&ff@@  @S33@@,@33@9@Fff@`  @33@ff@`  @l@Y@S33@s33@Y@   @333@@  @fff?33???ff??ff?ff??fff?ff??33@333@&ff@A+33@   ??@33?  ?@   ?fff?  ?C&f??ff?33?@33??L?fff??ff@ff?ٙ?ٙ@ff@33@@   @@,@@   @,@,@,@@  @@@  @S33@&ff?33@   @   ?ff@   @@   @@,@@ff@   @   ?ٙ??ٙ?ff?33?33?fff??fff?  ????  ?ff?ff?  ?ff??  ?ٙ?ٙ???ff?33?ff?  ?  ??ٙ?  ???33@   @   @   @&ff?33@   @ff@   ?ff?ff?ff?  ???33?  ???@   ??fff?fff?  ?ff?  ?ff????ff?33???ff?ff??  @ff?  ?33?  ?ff?33?33??33?ff?33?ff?ff?ff?  ?33?  ?33??  ?33?  ????  ???fff?  ?33?fff?ff?ff?  ?ff?ٙ?ff?ff?33?  ?fff?fff?ff?L?L??333?L??L?333?L??333?333?333?fff??L?fff?L?  ?  ?33??ff?ٙ??33?fff???ff?33?ff?ff??ff?ff?ff?ff?  ??ff?33?ff?33?333?L?L?L?fff?  ?fff??  ????ff??  ??ff?33?33?33??33?  ?33?ff?33????   >L>>>>>>>?>?L?fff?fff?   ???L>??L?L???fff?333>L?333??333?L???ff?33?ٙ?ff?33?ff?ff??ff?ff?ff?@   ?  ??33?  ?ff????  ??  ??ff?fff?L?333???333?L??  ?L???33?ٙ?ٙ?ٙ@   ?ٙ?33?ٙ??L?333???L?   >>>>?>>??  ???  ??33??33?  ??fff?   ??333??   ?333?L?fff?L?L???   >>    >=>L>L=>L>L=>>=ͽ=>>L=>>L@?fff?   ?fff?fff???  ?L?ff??  ?fff??333?   ?L?333?   >?L?333?L?L?  ?fff???ff?  ?ٙ?ٙ?  @   @ff@   ?ff?ff??333?>>L?333?333>?333>?>?L?fff???L?  ?  ?fff??333??fff?   ??fff?333?333>?   >L?   ?   =?   ==>L=>L==        =    >L>L>>=>>>>??   ??  ?L>>>>L>L>L>L>    =>L>L>L=>>>L    >L>L>>L?>?333?   >?333?   ?>>>?   >>L>L>>>L>>??>L>>>L==>L>>L>?   ?L?   ??  ???L?L?  ?fff?L>?L?  ?ff?ff?ff??ff?  ?fff??   >>L>L>>>>>L>?fff???L?333?L??L?fff?  ???fff??L?333?  ?  ????ff?  ?ff??  ?ff??33?33?ff?ff??L>>?fff>?   ?fff?  ?ٙ?ff?33??ٙ?L???  ????ff?  ?ff?ff?  ?33?  ??333AP  ?ff?fff?fff?33?333???L?  ?L???33??ff??  ?ٙ?ff?33?33?ff?ٙ@   ?  ??  ??33?ff@   ?33?ff???fff?  ?L?   >?   >L>L=???   ?   ?   >?   >L>>?   ??L?L?333?L?333?L?L?333?   ?   ?L?fff?L?333?   ??L>?L?fff?L?  ?????333?   ?   ??   ?>>>?>>>>>>>=>=>L>L>>L????fff?L?L?L??L?L?  ?fff?  ??ff??  ??33??L?fff??fff?fff?333???333?  ?L?333?L?L?L?L?33?  ?ff??>>??333?L?   ?   ?   >>>?   >L>>>?   >>?fff?fff?fff?  ???  ?   ?   ?L???fff??333>??333>????=?   >?fff??   ???333?fff?fff?333?L?fff?fff@33@@@ff???333?ff??ff?L???L?  ????33?33@9?fff?  ?fff?  ?fff?L?fff??  ?  ?33?  ?L?33?ٙ?ٙ???  ??  ??33??@   @   ?33@   @@@33@@?33?33???L?ٙ????ff?33??ff???  ??L?333??fff?  ?  ??fff?L??L?L?333>>>=>L>L>>L>>>>>L??  ?L?@   ??  ?33?  @@&ff@@   ?ٙ@ff?ٙ@@   @@   ?fff?   ?ff?ff?fff??  ?  ??  ?  ?@   @??33@ff@333@S33@y@@?ff?33@ff@   @,@&ff@`  @33@@@   ?ٙ?ff@333@33@333@,@@  @@9@@@  @Y@   @@?ff@ff@ff@ff@@33@@@?ٙ?33?  @   ??33?@ff@   ?  ?33?ٙ@   @ff?ff?  ?  ?@@@?33?33@@@S33@  @l@9?@33?ff@&ff@9@333@&ff=q=q=q=q=q=q    y =q=q=q    =q=q    =q=q=q=q=q=q=q
==q    =q=q        =q=q    =q=q=q=q    =q=q=q=q    =q=q=q=q=q=q    =q=q=q    =q=q=q    =q=q=q=q    =q    =q    
=
=    
=<y ><>y >><?33?>?p<?p>?p?p?33?p?p>>?p><=q
=?p׾
=<
=    
=
=
=
=
=
=    
=<
=    
=    =q        
=
==q
==qy =q    =q=q            =q        =q                    
=        =q            <>>>?p?p?p<?p?p>>
=<
=<><>><y <
=
=    
=
=
=    
=    
==q    
=    
==q            =q                                    =q    
=    =q    =q    =q    =q    =q=q    =q    
=
=    =q    
=    >><
=
=?33>>>>?p?p><<<
=><<<
=<<
=
=
=
=<<<<    
=<    ><
=
=<
=
=<    
=            <
=
=
==q
=
=
=        =q=q=q    =q=q
=            =q        =q    =q=q            =q    =q=q        =q
=    
=
=        
=<
=<<<?p<>?p>>?33>?p?p?p?p<>>>><<><<><>
=
=
=<
=        
=            
=A33    =q
=
==q            
==q    
==q    
==q=qy y y y y ?p><<><
=<
=
=
=>
=
=<    
=
=    
=    
==q
=            
=    =q                
=        
=    
=    
=    
=    
=
==q    
==q            =q    =q
=    =q        =q    
==q        
=
=<<
=<<<<><<>
=
=<<<<
=<
=<                <=q            <            
=    >            
=
=        =q
=        
=    
=    
=    
=                =q=q            =q    =q        
==q    
==q    
==q=q=q            <
=<<>
=<<
=
=<<<<<<<
=
=
=
=<
=
=
=<
=    
=
=                <
=        
=y <>y y =q=q
=    <B =q    ABH?33=q>@{
=    <    =q=q    =q    =q=q    =q
==q    ?33    <<    <
=
==q
=<=q<
==q<    
=<<
=<
=    <    
=
=    
=
=            
=
=
==q<A
=    Ay A33Iy ?p        AQI
=
=AQ  
==q
=>    
=
==q
==q=qBQy =qAp    y =q  
=Ap    AHy y C\C\CC\CC\CRC33CxRCCCHCC>CaHC3CJ=C3C3CCCCnC駮CW
CnCRC3CCC+C3C\CAHC\CcCAHCCCCC|)CCCCC*=CC|)CAHCCCCCCAHCKCꐤCbC{CC\CbCCCnC駮C CxRCxRC'CC'C'C\C\C1CC` CxRC)C\CCaHC33CCC3CaHCxRCxRCaHC=C'CC33C33CW
C(C\C\C{C33CC C)CUCCC=C=ClC=CC=CxRCCaHC)CCCCnC駮C)CW
C˅CyCC
CCKCCKCKCfCqCKC CXRCCNCXRC\CCCCo\C5CfCKC CKC
CnC33C C C駮C˅C駮C33C{CyCCqC5CC5Co\CqCyCqCCC駮CCaHC\C` CkCGC
C\C\CC\CC3C>C'CW
CaHCC C駮CaHC)C3CxRCaHCCC)CCCCCbC
C
CqCqC
CC5CCCAHCCcC*=CNC\C*=C|)CCCRCC)C3C*=C*=CC*=C*=C C˅C(CCKCC\CC CC@ CCKCCCCXRCqCCC\C C5C)C)CC33C\CꐤC˅C\C
C˅CKCCaHCxRC=C3C33CnC CnC CC C=C)CCCxRCUCqCCC)CbC CCCo\CCCpCCCCC\CXRCcC=C|)CcC5C)CRCCBC3C+C  CC\CgC{CqCCCФCCCCCCC\CCCgCCgCqC\CqCqCٚCCCO\C3C5CHC3C
C3C=CYCcCpCC駮C33CHC\CUCCC)CxRC3CaHC CC CJ=CC)C)C'CCCC CނC]qC֋CԀ CؘRCCxRCkC
C CCxRCRC)CClCHC)C3CC33C33CCC3CC CyC˅CꐤCꐤCC˅C(C\CW
CW
CC{C\CfCo\C|)C|)CC\CyCC˅CꐤCꐤCC@ C@ CyC(CbCbCqCCCC  CٚCCBCZC)CCC\C3C3CCC)CHCxRCcCfCCyCbCbCqCC C1C0CCxRCCqC` C\CC\CCHCCRC1ClCRC䧮C\C'C33CꐤC˅C˅C@ C@ C@ C{CbC(CCKCCCo\Co\CCCqCCo\CC5CC5Co\CCCqCCCC(CfC˅C\CCCC5CfC(C CKCCqCC@ C(CW
CnCnC33CC33CJ=CCC'C=C3C=C3CxRC>C=CC1C>C\C)CqCCCHCCCCC` C` C` C` C&fCxRCCCC\CCHCC1C䧮C)CxRC)CaHCCaHC)CCHCUC=C>C3CaHCCCaHCCC˅C˅CCCyCfCqC*=CCCCpC*=C*=C*=C*=CXRCqCKC CꐤCyC˅CyCꐤC˅C{C@ CyCW
CꐤCW
CC{C+CO\CO\C!HCCٚC7
C\CٚC|)C3C)CHC)CC3C+CCBCcCCCC|)C|)CpC3CAHC CfCC@ C{CC{C\C{C
CqCbCCKC(CCCCCC˅CnC33CC@ C
CfCo\CC\CeCZCO\CO\CCC=CCCCECO\C\)C3D D 4{CED 
Cs3C!HCs3C=CٚC  C
C\CC=CCBC CNCYCCRCqC CDqD	\D
RD
pDDqDDL)DqDDfDRD5DD D{D CDD5DfCD:=D  DfD
D D
D{D DDHDCCCCC{CcC3C CfCCNCAHCCeCCCC)C@ C(CCqCXRCCqC|)CcC\CCNC5C=C3CBCC C{CZCRC,C}qCCZC  CZCfCqCC C+CCCCC  CCCbC'CCqCC3CXRD QHD)CCnCCCqCeCfC7
CeCCYC|)CRCCqCBCpCNCAHCCC*=CCqCqCC)C˅C@ C駮C)CCKC C'C
CUCC)CC䧮CxRClCJ=C䧮C>CW
CJ=C駮CC)CyC(C Co\CCCC*=CC5CC CZCqCZCCCqC C+C{C{CCqCgCCs3C=C}qCO\C7
C CYCRC\C3C5C5CC)CCCC5C*=CbCbC(CyCCCAHCCyCo\CfC\CCCJ=CnCCC)C駮C CJ=CCCC)CCC)C)CHCRC1CCxRC3CCCCC33CCꐤCC˅CC33C\CC>CJ=C1CCfCqC˅CC(CfC\CcC  CYCC|)C CO\CqCCCqCC7
C C{CCCC+C CeCCeCZC}qCfC|)CC{C=CCC  C5C|)C=C  CCC駮CC5CbC5CqC3CHCRCfCCBC3CC駮C33CaHCxRCCW
CCC)C>C=CC&fC3CyCC\CaHC
CCqC3CpC)CNCCCKC|)C\CC
CC5C
CXRCD 
CZD 4{C\)D:=DfD D  D 
CC,CCCRC\CC7
C7
C{C\CCfCCCC)CHDD{DDfD DFfDDCCED˅D\Dt{DDD 
C CФCRCCC  CCeCCqCCCCC)CRCJ=Co\CyCqCC\C\CUC)C\CCHCނCCQC֋C#CC)C5CC*=C\C5C CCbC(C\C
C
CbCCCXRCC5C=CeC+CC
=D 
C!HCC3DDHDuDAHDXRDC8RCO\C\)DD DqD*=DC3C  CO\CٚCCcCD D;DDDL)Dz=CO\Dt{CCYC|)C+CYC3C=C)C)CC5CHC)C  CCCCCCXRCAHC|)C|)C3C\CAHCqCo\C\CC駮C CCW
CJ=C'CC)CKC{CCRCcCC3C)CNCcC)CHCCo\C\CC\CC|)CRCC\CAHC*=CcC)CYCBCBCBC
CeC C{CCqCCCCqC  CeC3CCCYC|)CYC  C5CCCCCC3CC*=C*=CcC*=C\CC*=C|)CC|)CC\C\CC\CXRC CqC C
CfCfCo\CCCKC{CCo\CKC CC
CKCCfCCC)CCXRCCC3CXRCCfC5C
CCCC*=CcC3CCHCNC)C=C3C
C|)CCO\CO\CCqCCZCgCDt{DD@ D CYC*=C*=CCo\CCo\CqC*=CcC
C  CCC  CٚCCO\CqCqCCfC  CfC}qCCBCC\C=CCgCC!HC\)CeC5CpCCCC)CAHCpCC=C\CfCCHCAHCCC{CCCC3CXRCKC)C|)CC5C3CCfC+CC{CٚC{CٚCqC,C8RC)CDRD^DuD=DD nC CCC3CC|)C}qCC
=Cs3CHC  CC
C=CNCBC3C3C=CCC3CNC|)CXRC
C5CYCeC3CCC5CCC\C*=CCpCCꐤCCꐤCCCXRC*=CCCCXRC駮C CfCyC)CyC˅C
C(C5C
CCyCC{CqCfCfC5CCCqCXRCKCqC5C5C\C*=CNC|)CCeCYC5CCCC5CXRCXRC\CpC3C=CCO\D nDt{D D D QHD C)CCCCBCYC5C*=CXRCCCo\CqC5Co\CCC
CCCCCCٚCCC3CRCC=C=CCCBCeCeCCqCCCC=CeCCCC  CO\C,CCRCqCgD:=D 
C=CC,CRC)CC=CXRCfC˅C{C CCCaHC33CbCꐤCCqCCꐤCCKCpCCHCC5CC+CCCRCCCC8RC\)CCCs3CC3D D RD D:=D  D C
=C!HC
D 
Dt{DfDDc3DCgDt{CDHDD
3D{D
SDDuDfDDXRD
DiD 
Cs3D˅C,CfCCeCC
D CC  D˅C,CfCꐤDCyCD=C{CC{C@ C)CC3CD@ DqC3C  D#3C\D/\D#3DRDiC
=CC  CCXRC33C
C*=C C
CC\)C CCCO\C,CCHCO\CCC\)D 4{D 
D QHD 4{CC3D 4{D QHD 
D D RD nD QHD 4{CC3C3C\Dp DRDDDFfDqD 4{D  D nCHC\C\C|)CDHCCCED)D 4{CC\Dt{CO\C,CCCC{C)CbCCC*=CCCC5CC  C3CBCbCW
CC{ClCHCCqCqCC|)CqCRCФC,CФCCC,CYCqCCHC5C  C|)C  CRCCФCgC8RC!HC\)CCФCECECEC3C\)CCD  CED D  CHC=D 4{D 
CDqD D D D 
CCФC3CФCCCCO\CCٚCC=CCC CCC=C7
C)CpCHC|)C\C=C*=CCCpC3C
CCC{CCٚCBCٚCCٚCC,C
=C3C3C\)D D QHD@ D 
D  Dt{D nCcCKC3CRC8RCC=Cs3C)CHCqCqC CC+CeCٚCqCCC\C,CRCRC)CO\C!HCs3CФC!HCCs3C=C=CCCCCZCCZC  C  C  CfC7
CqCٚC+C|)CCCCC3C\CqCXRC5CqCKCCCCCCyCfC CyC(CCCRCC*=CC\C|)CCXRCC5CNCCC|)CCKCyC5CC|)CHCHC)C5CCpCCC{CO\CCCCCCC  CCRCqC{CqCO\CCO\C8RCCECCC
=D 
D 
CD CD 4{Dt{Dt{DDp DD:=DWDz=DDDDDD]qDt{D(D˅DDDL)D5DHDCC8RCHCCC\)CD D 
D QHC3D RC\)Cs3CpCfCW
C CCCCaHCCߥCCC\CnC\CCUC\CC  CCCCCs3D DHD)Dz=CCHC&fCS3C0CC>CW
C
CfC@ C˅CbCfCC CCC\CCcCC CCfC\C33C(CCHCXRCXRCo\C=C|)C)C5CCHC5C  CHCNC3CCCHCHCC|)CC*=CcC*=CcCCcC\C*=CC*=CCRCCRCRCcCcC*=CCNCC\CC\C}qCCCHCNCC|)CqCCqCCC3CCCCCCJ=C)C3CC5C
CpCCCٚCCCYCpC  C
C\CZC\)D  D@ DDRDDDRD;DD	)DRD
qD
+D8RDD=DAHDDRDDt{D˅D  C Dt{CCCC+CCC3CCC CC
C(CbCKCCCC)CaHC>CCxRC3C=C3C` C)C)C|)C+CCJ=CCqCqC*=C\CqCCHC=C3C CCO\CCqCNCHC
CCC+C{CC|)CC5C)CꐤC)C)C=C)CCC)CC{CCCcC3C
C\C!HDHDFfDRDXRD;DAHDDDfDD
DL)D{D]qDqDHDWD QHDD
=D
D RC!HDqD]qCD 
CZCCRCC,CEDFfDXRDc3D5DD{DxRDRD  D	NDD=DD	D
RD3DDGC|)CC5CCC'CxRC>CCC\CqCHCC\CxRCC\CbCCqCCXRCcCeCC!HCФD  D/\C)C\)D*=D
pDUDD{D=D DP DD
 D
D	D	3DDAHD
qD{DRDGD	jD
pDHDRDBD{DD
D)D
DDfDBD%D{Dw
D
7
D{DD${D
qD
qD=DD
Dp DGDD
D
RDDp DL)D(DFfDDL)DL)DDqDDD{DC8RCФDDXRD#3D:=CCCRD QHD]qDWDqC3C,CYCRC)CpC\CC)CED QHCCYC\C(CꐤC\C*=CC  CZCeCDHDRDd{D	)D
D\D D
ffDAHDDiDDp D\D
D*=Dt{D:=C3DHC D C!HCCC
=Dc3Dp DDfD  D
D
SD<D	D` D
ffDBDHDfD` D{D
3D{DfD
DDDJ=D}qD'
DDfDDD
 D
D;DiCФCC5CǮCnCC=CO\C  CBCCHCYCD  C
=C3DDiD]qC!HDDD	jD
7
DD	CqD)DDd{D	D DqCCy y y y y y y =q=q                                        =q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q    =q=q        =q    =q                                                                                                                                                                                                                =q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q=q                                                                                                =q=q                                                                                        =q                        =q                                    =q        =q        =q                    =q    =q        =q        =q=q    =q=q        =q            =q=q=q=q=q=q=q=q        =q    =q=q=q=q                                                                                                                                                =q                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q    =q        =q            =q=q=q                                                                                                                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q    =q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                =q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                =q=q        =q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                                                                                                                                                        
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                                                                                                                                                
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                                                                                
=    
=
=
=
=
=
=
=
=
=                    
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=    
=
=
=
=
=                                                                                                                                    
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                            
=                        
=
=
=
=
=
=
=                    
=    
=
=
=
=                        
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                                                                                                                                                                                                                                
=        
=    
=                                
=
=
=
=
=
=
=                                                                                                                                                                    
=    
=
=
=
=
=    
=    
=
=
=
=
=
=
=    
=
=
=    
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=    
=        
=
=
=
=
=
=        
=
=
=
=        
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                                                                                                                                                                                                                                    
=
=        
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=
=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            
=                                                                                                                                                                                                                                        
=                    
=
=
=
=
=                    
=
=
=
=    
=
=                                                                                                                                                                                                                                                                                                                                                
=
=
=    
=
=
=
=
=
=
=
=
=
=
=                                                                                                                                                                                                                                                                                                        
=
=
=
=
=                    
=    
=    
=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        
=
=        
=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q        =q        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q        =q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                    =q=q    =q                                =q=q=q=q=q=q=q=q=q                                                                =q=q=q=q=q        =q=q=q=q=q    =q                                                                            =q=q=q=q=q=q=q=q=q=q                                                                =q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q        =q=q=q=q=q            =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q    =q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                =q=q=q                                                                                                                    =q=q=q=q=q    =q    =q                                        =q                                                                                                                            =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                    =q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            =q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                    =q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q        =q=q=q=q=q=q=q=q=q=q=q                            =q=q                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                        =q=q=q=q=q=q=q=q    =q                    =q        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    =q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                    =q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q    =q=q=q=q=q=q=q=q    =q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                =q=q=q=q=q=q        =q                                                                                                                                                                                                                                                                                                                                    =q=q=q        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        =q=q        =q                    =q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q                                                                                                            =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                =q            =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                    =q=q=q=q=q                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                        =q=q=q=q=q    =q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    =q=q=q=q                =q                            =q        =q=q=q=q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q            =q                                                        =q=q=q=q=q=q                =q=q                                                                =q        =q=q                                                                                                                                                                                                                                                                                            =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q                                =q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q=q=q=q                                    =q=q    =q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                            =q                                                                                        =q=q    =q                        =q                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                    =q=q=q=q=q=q=q=q=q=q=q                =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q        =q=q        =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        =q                                                                                                                                                                                                                =q=q                    =q    =q    =q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      =q=q=q=q=q=q=q=q=q=q=q=q                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                A33A	AAHAAzAHA @{y @R@
@ff@33@@@У@33@ff@Q@
@@Å@(y y AzA	A
AzA
A
A
A\A
=A\)A
AzAAAGA=qAAffARA\ARA
=A\)A
=A
=AHA\)A33A
=A33AAA
A
A(A
A(A
A33AAQA\AA\)A	AzA33AAAffA Q@@H@  @ff@GA\)@G@(@@{@ff@
=y @=q@@=qy @H@
@(@p@
@z@@\@
@@z@=q@@\)@  @
=@@
@33@@=q@@@ff@
=@33@H@G@@G@@\)@߮@@ff@ۅ@@@p@@@߮@  @(@ff@ff@@ٙy y @(@{@
=@z@@ڏ\@  @\)@Q@z@@H@=q@@@\)@߮@  @@ᙚ@H@\@33@\@33@33@
@(@p@ff@
=@ff@@R@@33@
@@\@
=@@@  @z@@y y @=q@Q@ۅ@  @
@\)@@G@@@@z@  @@ᙚ@ᙚ@G@=q@޸R@  @@\)@@ڏ\@@33@H@@@  @@p@(@@H@@
=@\@33@@=q@@33@H@\@\@@@p@@33@G@ᙚ@p@R@\@@
=@@Q@  @@=q@@
=@ff@R@R@@p@@(@@p@@z@@@@@z@z@z@z@@(@z@33@z@
@H@(@
@33@@H@=q@H@Q@߮@@H@H@
@H@33@=q@(@33@ᙚ@33@H@z@@@ᙚ@ᙚ@@  @@G@G@ۅ@ff@޸R@z@{@H@@ff@@\@{@Q@R@@@(@z@@(@33@(@H@33@
@{@
=@@R@\)@Q@@Q@@@G@Q@@@R@{@ff@
=@  @
=@@
=@{@{@{@{@@@p@@@
@z@=q@@@
=@ff@޸R@G@ᙚ@Qy @\)@@Q@@@Q@@G@=q@Q@=q@H@@@p@@{y y y y y @=q@G@(@H@ff@@H@@陚@{@Q@@z@(@\@\@@\@ᙚ@ᙚ@@=q@@\@33@\@ff@H@H@@@߮@H@@@z@ۅ@H@ᙚ@  @
@޸R@z@ۅ@
@p@{@@
=@@ff@߮@
=@߮@
=@\)@޸R@@\)@
=@Q@  @  @33@(@@G@޸R@{@@
=@
=@\)@@G@=q@=q@@33@=q@
@H@(@\@=q@\@33@
@@(@(@
@@=q@G@33@H@@@33@\@33@=q@33@
@33@=q@ᙚ@ᙚ@
@33@33@
@@@(@
@(@{@z@z@
@\@ᙚ@@  @Q@33@p@z@p@p@H@{@
@Q@
=@H@(@=q@@@=q@ָR@@\)@ָR@{@G@
=@
@33@Q@ҏ\@@׮@(@H@
=@33@@@z@33@\)@R@(@H@@@=q@33@33@@H@@@33@(@{@z@@\@33@@z@(@z@z@@@
@33@@y @@\y y y @ff@\)y @@ff@y @y y @ff@G@@\A\)@G@ff@߮@Q@߮@ff@@@(@@p@@\)@߮@@\@33@@{@p@R@Q@陚@=q@33@@\)@R@@R@p@
=@{@(@@ff@@@(@
=@33@H@33@z@@z@(@(@@
@
@(@(@
@H@=q@33@\@H@
y y y y y @y @33@p@y @@p@py @p@@{@R@R@Q@Q@Q@Q@y @=q@y y y y y y @R@  @\)@Ry y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @@z@@@  @H@ff@@(@\@{@\@@@Q@z@@H@(@A zAA AAQAAAA @p@p@p@  @  @
=@
=@{@
@@@\)AAAARAA AA zARAA\)AQA{AA A (AA\AGA Q@p@p@z@H@\@=q@@@@@\)@{@{@{@p@@33@@\)@=q@G@G@G@@\)@@
@p@
=@R@Q@G@\)@@陚@@@\@  @  @H@@
=@Q@R@
@@@=q@G@\@\@@Q@\)@p@@p@G@z@
=A zA zA A AGAA AGAAA   @z@@(@@@@@@ff@
=@@
=@@z@R@G@R@H@  A (@@@H@A@\)@zA @p@@  @@@(@  @@G@(@
=@@@\)@ff@@@@@  @33@{@R@R@@G@@A (@33@(@@  @\@@
=@
@@@Q@@@@ff@Q@Q@(@\)A AAA QA A   AG@@(@@\)@@{@R@p@R@@@
@\@@@Q@Q@@@
@@33@{@{@@\ApA Q@@=q@{@@@@H@@G@@@@Q@陚@G@=q@
@(@(@
@@H@(@@=q@@@=q@G@{@G@@\A Q@@G@H@{@G@G@@@@Q@@\)@=q@33@@R@Q@@
@p@
=@
=@Q@@@@@Q@G@G@@
=@  @@@@@@ff@p@@@
@(@@(@H@@z@(@@@  @H@@@
=@@=q@@p@\)@ff@=q@ffAff@R@@H@{@(@@@@ff@@
@Q@@{@@陚@@33@@33@p@ff@@R@\)@R@\)@p@ff@p@p@z@@@@ff@ff@޸R@{@
@p@p@33@@ff@@
=@  @@(A (ApA  AARAR@z@p@33@=q@
=@@p@@@p@@{@{@{@@@@@R@
@
@@z@{@  @{@p@G@{@\@=q@
@@R@@33@p@@
@@
@@=q@@@@@z@(@33@
@\@@H@@@߮@߮@޸R@ۅ@=q@(@Q@ᙚ@@޸R@Q@{@ۅ@ff@z@33@@Q@\@@\)@@p@ٙ@@߮@@\@=q@@@@p@ff@\)@  @Q@  @@
=@H@@@@޸R@{@
=@\)@  @@H@p@  @\@H@
@@G@Q@\)@  @@=q@@
@H@@H@@\@@\@=q@@@ff@ff@{@ff@{@@p@@
@\@@33@
@\@H@\@H@@H@\@\@\@\@33@33@@@33@33@33@33@H@\@@  @  @  @@G@=q@\@G@@=q@\@
@z@
@\@H@(@p@@@@{@R@@Q@  @@@@G@G@G@@\@\@33@
@@{@\)@  @@Q@Q@@@R@{@@@@G@@@@\)@@Q@ff@@@@
@\@@@@@H@H@@@@  @陚@陚@\@=q@
@@p@@@@
=@@ff@ff@\)@@@@{@
@@R@\)@ff@
=@R@R@\)@\)@R@R@@\@H@=q@@33@33@z@ff@  @@H@=q@G@33@A AA AGAGA Q@@@z@A AAAGAGApA\AHA=qA=qARA\A\)A33A33A\)A\AA33AAA\A A A @A zA QA @R@@\)@ff@@H@
=@@(@(@
@@z@H@z@@ff@@@
=@ff@=q@G@G@@@G@
@@\@
@=q@@z@@@p@pA   @
=@@
=@\)@
=@@@z@@@{@
=@\)A   A A A AA{A=qARA
A
AAzAAA
A33AA(AQA
{AAQAA\)A
AAA\)AAA
A  AAHApA AffAHA@@p@AR@R@RApA@=q@  @@ff@@ff@{@p@{@@R@@  @\)@GA A33AQ@@\)@@p@z@33@@{A @z@@@=q@A   @p@G@@Q@{@Q@G@G@@{@\)@ff@@@R@@  @@@@@\@@@
=A   A zAA=qARAApAApA{ARA AAA A A (A{AAHAAA33AAAAAAA=qA
A(A
=@\)@=qAGA QA @{A zA QA@@z@(A@A z@  @
=@@@@
@=q@R@@  @@ff@@@33@(@@@p@G@@@p@R@@@A QA@
@ffA
AzA(@{@AA  A{A{A
=AAQAzAzAffA(A1A,A0A7
A<(A-A!A
=A!GA*{A,A*\A*\A&\A!A%GA
=AA
A{AAA(AA\)ApAA=qA  AHAA=qA(AA{A=qA   @
=@ff@\)@ff@@@\)@
=@G@@{@@(@33@@
=@{@@\)@{@@33@@
=@{@@陚@p@=q@\@Q@
@@\)@@{@@@أ@H@z@@@@p@\)@z@@@@H@\)@H@@@@
@\)AQ@AAA33A\)A{AGAQAAzAffAAA\)Az@33@\@33@
@
=A A@A (@
@z@{@(@H@  @@@{A QAA z@@z@@@@{@@33@G@@G@
=@R@@@{@{@
=@@@@{A@p@H@G@@@z@H@@\)@@Q@  @ff@
@ff@=q@
@z@Q@@@z@
@p@33@Q@ff@\)@\@@(@@
A   @@AGAAzA
=qAzA
A=qA
A
A
=AHA(AAA
{ApAz@@R@@G@
=@(@@@@HA@
@\@z@
@@
=AHA z@@33@@@@(@33@@33AA @=q@\)@=q@RA33@@(@ffA   @@H@=q@(@=q@߮@@H@@@Q@@
=@33@H@\)@G@\@Q@33@(@ff@ff@@\@@ff@R@p@@p@z@@@{@Q@\)@
=@
=@ff@@ff@
=@\)@  @  @G@@@@\)@@@p@@p@z@\)@
=@
=@  @@\)@
=@
=@Q@@  @Q@\)@@
=@@z@z@(@@(@H@=q@@@@@G@@  @\)@ff@R@
=@
=@  @\)@\)@\)@
=@
=@R@R@
=@R@ff@\)@@G@@@@\)@@@\)@
=@@@G@G@G@@@@@@G@@G@@G@@@@H@@@
@p@@ff@@@
@\@
@@@ff@ffA   @\)@{@@@@@@@@H@@@G@G@@@  @  @(@R@R@@@R@@z@@\@\@\@33@(@{@R@p@R@@R@(@@
=@R@p@p@33@
@@(@(@
@33@33@=q@=q@G@G@@G@@  @33@z@陚@(@@
=@{A   @z@ff@\@
@=q@H@@\)@R@z@
@p@@(@
@@@33@@ff@33AA\ARAA\)ARAA	A
ApAGAAGA\)A
=A z@pA33A
AA
ARA33@33@R@H@33@@Q@@ff@R@@@\)@@z@@@@z@R@z@ff@Q@@陚@(@{@=q@陚@@Q@@p@@@@@z@@z@G@ff@p@z@(@@z@@{@@@@@{@@p@{@\)@@R@
@Q@@
=@@@@p@{@@{@{@ff@ff@
=@R@
=@\)@
=@  @G@@G@G@@G@@R@R@R@ff@@@@@@@@@Q@\)@ff@
=@@{@{@R@{@{@@@@@R@R@@@@{@ff@R@@@(@z@(@@(@
@(@
@
@\@=q@@@@@@Q@G@陚@@@33@(@(@@(@@  @=q@陚@Q@@Q@G@G@@H@=q@  @陚@33@@ff@z@
@@(@@  @G@\@@
@z@=q@{@@@@@  @\@H@@33@z@
@(@
@@z@  @ff@{@ff@(@33@
@
=@  @@z@33@33@@@\@=q@@H@@  @\)@p@G@p@33@\)@Q@H@@z@\@\)@
=@@(@ᙚ@ff@Q@߮@p@z@Q@޸R@\)@G@Q@޸R@{@\)@@
=@ff@޸R@ff@@@z@@p@@@(@33@ٙ@H@ڏ\@޸R@
=@  @{@@@p@陚@Q@G@@@@R@@33@Q@ٙ@
=@p@(@=q@
=@{@{@Q@߮@޸R@\)@\)@@@\)@޸R@
=@Q@@  @@޸R@޸R@ff@߮@ۅ@޸R@33@=q@ۅ@H@33@(@ۅ@
@أ@\)@p@ۅ@  @=q@Q@˅@(@ƸR@
@
=@@=q@H@θR@(@p@Ϯ@
@@@љ@G@p@@׮@p@{@@p@أ@33@33@z@
@(@@ᙚ@G@@߮@@@33@@
=@Q@p@@@\)@
=@=q@H@@@陚@33@\@
@z@@Q@Q@R@p@p@ff@33@@R@@Q@@@@@@{@{@ff@R@@@@p@@@
@
@@\@=q@=q@  @\)@߮@ff@
=@߮@G@@߮@@@߮@
=@@Q@@ᙚ@@{@ff@ff@@ff@޸R@{@=q@(@(@@@@ff@ff@  @@@@=q@
@(@(@
@
@z@  @Q@@@@@  @@@=q@@ff@@{@@@@G@@@Q@@陚@H@G@=q@=q@=q@@=q@@陚@@\@H@\@G@陚@\@G@G@@G@G@@@@H@\@H@H@\@@33@z@
@z@@@@(@@@\)@@Q@{@@
=@@(@\@@=q@H@H@(@@@Q@@z@p@H@@@p@p@@{@z@H@@H@@@@p@@p@@{@ff@R@\)@  @
=@Q@@{@\)@G@G@@@  @@@{@{@@\)@  @  @\)@@\)@ff@
=@R@\)@
=@@@(@33@@
@(@(@(@(@@(@33@\@@=q@@@=q@=q@@@=q@H@@=q@H@
=@  @R@R@{@ff@ff@@@{@{@p@@p@@@@@@@\)@Q@  @
=@@@@=q@\@@(@z@@@{@
=@R@R@ff@@@@@@p@p@@z@(@(@
@(@z@{@@@(@
@@H@
@@陚@H@H@\@33@\@@=q@\@=q@H@\@=q@@@陚@陚@G@\@陚@@\@G@@H@H@@@@@@@@@@陚@G@G@陚@陚@\@\@@@H@@=q@=q@@陚@G@=q@\@\@\@=q@@陚@\@33@
@
@(@(@@@p@p@{@ff@ff@R@R@R@R@
=@\)@  @  @@Q@Q@  @@G@=q@33@(@z@33@H@\@@\)@\@G@@  @@@@  @@=q@H@@Q@Q@G@Q@@@@@\)@\)@\)@\)@@G@@G@G@@H@@@(@@@
@z@@p@@@ff@@@@p@R@ff@33@H@@
@@@33@
@
@33@@@z@@@@@@{@{@{@R@
=@  @@@@=q@
@(@@@(@(@R@p@@H@z@(@
@(@
@@
@@@
@=q@G@@Q@  @@=q@H@@G@@@@  @@G@(@@@@33AR@
@
=@33@@
=@AA(AAAQA33A (A AApAHAA{A=qA\AAA@@zAAA(AA
A\)A
AAGA (AffA
A@@@@@@
@=q@\@33@R@@A QAARA33A33A  A\AffAAzA	pA	pA	GAAA	A  AA@ff@@\@Q@p@@z@@@R@@G@{@(@@\@@@@R@\)A   @@A   A Q@{@H@\@\@p@G@@
=@@@@@(@\@@\@(@p@
@p@
=@  @33@@ff@@@@H@H@pAA\A
A=qAAGAA\AffAA AffARA
AQAApAA
=A
=AQAAffAA  A
=qA
pA
{AA\)AAA(AA33A  A
=AA  AAHAHAA\A  A
A(AA AzAA @@  @RAAA zA AAA\)AHA\AA A (A zAA
=AHA (@
=@@R@ff@@  @ff@Q@@33@@@33@(@@@\)A   A @\)@\)@
=A AGA\)AAAA(AA{A{A
=AHA
=A
AHA	A
=qAzA33AzApAffA\AzA
AAzAA
A
AAA
=AA
GAAAA\)A=qAA  A  A33AAHAffA=qA\)AAA33A
=A33A{AA
AGA
ffA\)AAHA (AA=qAffAGA QA @A   @{@\@{@{@@@33@@G@G@@\)@@@@\)@{@@z@H@@z@p@{@33@@Q@p@z@@Q@z@G@H@A @
=@@\)A (AA\AHA(AA  AA{AHAA(A
A
A
pAA=qA\)AffA33AffAA	A
AA
=AAQA\)@
@GA @G@33@H@HA@{@ff@ff@@\)AGA@ff@@\)@@@
@G@{@ff@@@z@@H@33@@@@@@Q@ff@{@(@@
@H@@H@33@H@\@H@@@  @@@@@\@33@{@
=@ff@  @p@@@@@@{A @{A zAAHAAAzAApA=qA\A\)A33AQAQAzA\)A
RA
=qA	A\)AAA{A33A33A{AA AffAARARA33A\A@{@33@
=@{@p@(@z@(@33@\@33@@@  @
=@R@
=@(@H@33@@@@(@R@ff@R@{@
@(@陚@Q@@p@p@@z@\)@G@@@@
@(@p@{@\)@p@p@{@@p@@@
@RA   AAffARA  AQAzAAzAAffAAA
=A
HA
A
A  AA=qA
A
A
=A
ffAAAzAHAA(ARA  A
=qAA
pAA33A
HAAAAAA
GA  A	AzA
{@R@=q@@Q@@{@  @@@@
@@@@@  @Q@@G@@  @\)@@@z@ٙ@
=@33@33@R@z@ff@\)@{@@H@  @@Q@@(@
=@陚@G@=q@@@=q@@\@(@{@\@AA33AA=qAzA
ffAA
A
=AzA33A  AAA33ApA{AAA
AA	A33@(@=q@p@Q@@@@@@
@@=q@Q@=q@G@G@@H@@@@
@@=q@
=@{@R@p@p@@p@33@\@\@@R@=q@@@G@@G@@@Q@@  @Q@  @33@@@@{@@@ff@{@R@
=@@@
@@@
=ApA\)AA33AAA @ff@RAGAG@33@A (A  AHAGAzAzAAAzAA(A(AA\AA\A
=A
RA33AAAAARAA   @@@\@\)@G@@
=@\@@  @33@H@
@33@H@G@\)@  @Q@Q@
=@@R@Q@Q@ff@\)@@R@{@p@z@=q@=q@Q@@  @G@(@@{@
@33@p@@
@33@
@\@z@z@@陚@(@G@@\@@@@Q@@@@@@p@R@@=q@H@@z@ffAQA@{AGAA=qAHA33AffA\A33AHAQAzAQAffAAAA   A\A
=A(AHA
AA QAHA@ffAffAAHA(AzA(@GA @ffAp@ff@p@
@(@=q@ff@@  @  @\@H@@H@
@@=q@@@(@@@@{@@H@@@
=A QAAA zA A zApAGA zA (@A   A ApA{AA\)A A\AffA=qAAA{ARA
=AA	pA33AA=qA(A
A
pA
A	GAffAAAAAA  A\)AAHARAffA
=A
AARA\AA  A  AHARAAp@\)@@@z@@@  @@ff@@@z@@@@R@\)@@@@=q@H@@=q@H@@@H@(@R@
@@@=q@z@(@=q@\@@
=A AffA33@\)@RAA
=A(AA
A(A
RA	GA	AAA
{AffAA\)A{ApAAA{A
=AzA\A\)AAApA=qAAAHA
AA AApAzAA A @@A zAA	AA
GA
{A
AQA
=A
A	A	A
RA\AAzAAA{A{@@ffA   A   @H@Q@pAHA\)AA A\)A z@@G@R@ff@\)@@@
@@@  @G@\@
@p@@(@{AA
=AHAHA
AA33A
A(A
ffARA{A  AA33AAAzAAA33A(AGAA=qAffApA  AA33AA33A
=AQAQA\)AAzA@=qA AAA@pA=qA @ARAHAAA @
=A   @A=q@@
@@@R@(@@
=@{@  @
@{@H@@33@p@z@33@@
=@H@z@  @Q@陚@@Q@z@ᙚ@=q@ff@R@@G@@@{@\)@=q@G@=q@
@AAHAA=qA
=AA=qAHA
=qAAA
=A  AA\AApAA33AAARAzAAAA
pAffA(AffA33AAAGA
=ApAAAAAA	AGA@@
=@33@R@@A @(A   @=q@33@
@@(@@G@@  @@33@G@@R@=q@{@{@=q@@@\)@R@
=@@z@p@z@
@
=@@@Q@@
=@pAA=qA A(A33A zAA(A33A(ARAQA
pA\)A
pA  AA
=A!GA#A%A'
=A(  A!A$(AHA$zA!GAA*RA$AQA	ApAffA	AQA33A33AAzA	GAAzAA	A  A  A
=qA
=A  A=qA  @@(A (A   @{@
@R@A QAApARA	AQA A  A
AGAA(A33A
Ap@A{@(@@G@ff@@@
=@p@@
@
@A A@\)A(@
=@AGA QA A (ApAAQA33A33AAHAQAAAAHA\A{AQA
pA
A\)A  ApAffAA\AffAAzAA  AAAA\)A
A33A
=AA=qAHA  AA
AAAA	pAAA	A  A
=qA
HAAzA{A	AA\AA  A  AApAA zA (A zAffA (A=q@p@@@@=q@
=@=q@@p@@G@=q@=q@
=@@Q@R@
=@@\@ffA{A(ARA(AAffAQA(ApAAAffAA33ApAA
=ApA  A{ARAQAAffAGAzAAGA\A	A
AzAA33AA
AHAHA
=AGAAAAAAA
=AA	A\)A	GAA33A	pAAAA
=@@@@(@z@p@p@pA zAAp@@p@{@z@z@{@{A (ApA z@
@@=q@@
@R@R@R@
=@p@G@(@z@G@@A QA   A (A A A zA zA
=A33A33AHAGAAAA{A
=A	A	AQAAA\)A
GA
AzA
HAARAzA\A"=qA(A  AHAAAQA(A
AzApA
A
=A
A
A33A
pAAA
AffAA @{@A AA AAApA  A=qA\A(ARA\A   A	GA\)A=q@@@@=q@=q@z@G@(@(@Q@\)@(@\@Q@{AG@=qAA @\@=q@G@p@
=@\@33A A\AAA
AAAA	A	pA
=A
RAzA=qA\AffA(A	pAA
RAA
\A#
=A=qA
A  AA33ApAA ApA\)AAAA
=A
AzA\)A
=qAA=qA
AAARAAQAQAARA{AAA\A
\AAA  AAzA
A33A=qA @
=@
=@@R@@(@
@p@@z@z@@
@
@H@@@@@H@{@@p@@H@@R@  @(AApA(A
@Aff@zARAffA\ARAQAApAAQAA  AA
A\)AGAA\)A33AA
=AffApA  AHAAA33AffAGAAA  AzAA A@R@A (@\)@A   @@
@ff@
@(@A   A (A @@  @{@@z@R@R@\)@
=@R@z@@z@@{@G@@=q@@33@G@
@@33@=q@@Q@\@@ff@Q@\)@@@@z@
@33@@A{AHA\)A	AARAGA\AARAA=qAAAAA33AGAA
=A
A
=AffA
HA{A\)AA(A
=A\)A=qA
AffA
AQAAHA
=A  A  AHA\)A
A  A\)ARA@HAA
A\)@p@R@
@@{@@@Q@{@@\@\)@G@@p@@ff@A=qA{@@
@Q@@\)@Q@=q@{AG@\)AGAAAA(AHA
=AGAA
=AAzA
AA=qARA=qA33A
{A\)A(AffAA
{ARAAQA(AA
A(A\)AAQA
A\A33A"RA#A AzAzAAQA(A\)A{AAHAA(A33AA33AApAAA{A	pA
=qAA  A{A\A33A
=AAAHAA{AG@
=@@AAAzAGA{AA
=A
{A
@ffA@\)@z@G@\)@
=@
=@@@Q@=q@  @\)@@@@@H@Q@
@@R@\)@A A   A AA=qA
=AAQApAffAHA
AAA	A	pAzAzAAAGAAAQAzA\)A{A
ffAA{AzAAAGARA
=AA\A
=AAA\A33AA
RA	pA
AA(AzAAH@@Q@(@{@33@@33@Q@@G@Q@@z@=q@  @@H@
=@\@\@z@G@{@{@z@@(@@@@33@(@@@
=@H@H@H@G@
@@A @AAz@@@@=q@33A
=@@33@(@@
=@A QAAA A zAGA @@\)@ff@\)@  A   @zA@
AffAGA\)A	pAp@z@GA33A@  @=q@@H@A33@
@\A33@A
A
A\)AAHAApAAA  A@A A@
=@ff@@R@R@
=@\)@@z@\@@@z@{@@@G@  @@R@@@@p@@@\@@
@p@@(@(@H@  @
=@ff@QAGAA	AAAA
A
=AzAAApA{A
=AQAzA	pA	ARAA	A
RAA\)A{AQAGAGAAGAA	AH@{@
=@RA AGA Q@ff@@AA zA=q@ffA @H@\)A z@\)ARA A
=AA z@A   @@(@@(@@@@=q@=q@@@
@=q@33@  @ff@@@  @@  @
=@z@{@@
=@z@
=@R@H@@=q@  @{@\@
@z@@=q@{A@ApAG@R@AAffA z@(@@H@H@zA zAGApAA\)A33A\AA\)AA=qARApA=qAAARAAA
A(A@Q@z@\)@R@(A (@@@{@
=AA\A@\)@p@33@@p@
=@ff@\)@@  @  @33@
@@
@@\@H@33@pA@
@@@@@@G@\)@@@ff@@ff@@@A @@(@@\)A QA(A=qAHA=qA A AAARA
=AffA AffA\A\ARA\)AAA\)A AA  AA
AAApARA{A
AA
ffAHA
=A\A{A\)@@@{@=q@@@G@H@Q@R@@R@@@@z@33@R@@@\@33@
@\)@\)@p@@{@G@G@@33@
=@@Q@{@p@
=@ff@  @  @G@@G@p@  @
=@\@\)@@\@33@陚@z@z@\@@@@\@33@H@ff@  @\@33@
@\)@R@@\)AzAzA@(@ff@ff@z@@{@(@
@
@@@G@@R@@@Q@p@@=q@H@@G@@@33@Q@\@
=@(@=q@
@R@z@
=@\)@H@@@@=q@@Q@  @=q@\)@{@陚@\@G@p@p@G@(@@z@@@@
@Q@@@Q@@@@@ff@@(@@H@ff@@{@\)@\@@H@(@@@G@33@=q@\@@@HA(AAQA(@A @ff@@A ApA{AA\A@33@33@@p@@A zA=qAA AAA Ap@
=A @
=@HA A(AAGAAQApAff@(A A
=A   AzAAQ@(@  @@ff@R@@
@  @  @@p@@(@Q@Q@\@(@
=@@p@@(@  @陚@@
@@@R@@
@
@陚@@
@R@@A QA=q@@33A z@@@Q@@\@z@\)@@H@
@=q@G@@(@(@ffA A A A{AffA
A@@G@RA QA A
A@
=A A @@R@=q@(@@\)@@@@z@@(@33@@ff@z@p@
@H@
@
@z@(@z@z@@p@p@R@\)@ff@ff@@@z@@@(@@z@@Q@Q@@  @G@ff@@ff@R@Q@\@Q@(@
@R@@zA A=qA=qAG@RA A (A QA QAGA=qAHA(A
AzAAA\A  A
\A
A\AAA\)A
A
HAAzAQA
ffA\)@{A
AAA=qAA@(@{@(@@G@\@G@ff@@@@@
@  @  @@@ff@\)@Q@z@@@{@\)@{@  @ff@ff@ff@ff@
=A@
@{@ff@G@@R@@\)@@@Q@Q@G@H@Q@z@H@@G@=q@@
=@A zAA   AffAHAA
=A33Ap@AAAAAHARAA  ApA(AAA
=A\A	pA	A\)A
ffA
AzA	pA33A	A
\A	A\)A	pA(AzAA A=qAA\ARARAAApAAAzARAA33AA
=ApAHAAA=qAA
RA33AzA
AA A=qA @
=@
=@
@A QA @@H@@\)@@@@33@@  @\)@{@@@G@\@@\@@  @@
=@@
@p@@{@R@Q@G@  @@A AAffAARA\)A(AApA\A{A{A	A
A\AAHA{A@\)A A @@\)A z@@z@@@@
@@Q@@(A Q@\@@z@@@@
=@
=@@@@@p@@@
@
@G@Q@33@(@\@@{@p@p@\)@z@@@
@(@
=@{@@z@@\@(@
=@ff@޸R@@G@@z@@@z@(@(@@{@=q@33@@@R@R@
=@ff@@{@ff@ff@@\)@@@@@@@p@p@
@G@
@\)@@p@ff@@{@
=@@
=@z@\)@{@@@(@33@
@R@@R@@@  @Q@  @33@@@  @  @{@p@{@z@(@@@Q@G@G@@G@ff@{@
=@R@\)@
=@\)@ff@@@@33@߮@p@ٙ@H@H@Q@\)@@G@
@R@H@
=@@\)@
=@@Q@@
=A (@@
@@ff@{@p@@@z@@Q@  @@
@Q@AG@
=@AGAA@R@ff@@G@@  @@33@p@=q@@
=@Q@=q@33@@R@@@@Q@@=q@@\)@
=@Q@ff@(@@p@R@Q@@@@Q@@
=@Q@Q@@@\)@
=@\@@陚@@33@(@{@@ff@  @  @p@@@\)@Q@G@@33@{@@z@
@A AffA{A\)AAA=qA\)A(A	GA
RAA=qA\A33AGA(AffA  A{AAA=qAGAGA=qAAAARAQA
RAzA\)A33A
\A33AA
=A\)A\A  AAA   A (@@{A @AA=qAG@
@p@@z@{@{@
=A A\A zAA AffAAGA A QA zA Q@
=@z@(@{@
A33AzA
ApAA@@@
=@(@RA (A
=AA\)@
=@=qAQA33AzAAA\A33AQ@@z@=q@(A{AQA
AQApApAzAAA
=A
ApA(A
=AA\)A
=A{A{AHAA(AGA33AA\A
pA
{AA{AAApAA A A (@@
@@@  @Q@\)@p@
=@\)@H@H@@G@@@RA
\A
AQ@(@33AA
=A{Ap@@R@p@A (@
@(@ffA\A=qA\)ARA\)A	GA	GAA	A
A
A(AA=qA
=AzAAzA=qAHAAzAQAAGAAHAHAQAAAAA=qAzAzAAQA\AAA
A
=ARA=qA(AAA(A\ARA@
=A A A@{@
@\)@
=@p@@@ff@@@@{@@p@p@ff@
=@Q@@@@H@@G@Q@z@@\@G@=q@p@{@z@@R@{@@z@@(@@@
@{@@@@A33ARA{A{A=qAA
RA\A
AAAGAAzAQA33AAA{A{AGAQA
A(A  A33AARAA=qAGAAA=qA{AAA\ApA{A=qA  A{ApA @@R@\)@@z@p@33@@@@
=@ff@@@@{@@\)@@=q@\@
=@@
@z@@@@@\)@  @(@(@@@\)@@{@@@R@=q@@@
=@(@@@@R@@@@  @
=@\)@33@p@
=@  @\@@p@@H@H@33@@ff@
=@  @@@  @  @
=@  @ff@陚@\)@ff@@@R@z@p@@@G@R@(@@@G@޸R@\)@
=@\@Q@@33@{@ָR@=q@ָR@@{@ff@ff@ָR@z@@Ӆ@Ӆ@Ӆ@(@@ָR@أ@ڏ\@ڏ\@ٙ@@  @{@  @
@ff@ָR@(@@@Ӆ@{@@\)@  @G@G@Q@\)@أ@=q@G@H@z@
@@@\)@޸R@\)@ᙚ@\@
@R@@@  @@@
=@@@@@\@p@
=@Q@  @@@Q@  @陚@@R@@(@@G@陚@@{@\@@33@@@ff@{@@@
@=q@=q@H@@@Q@  @  @߮@޸R@޸R@޸R@@z@@
@ٙ@أ@@@\)@Q@@33@=q@ᙚ@
@33@\@ᙚ@{@{@{@\)@{@Q@\@33@G@@
@33@ff@=q@@p@@ᙚ@@\)@ff@߮@߮@@\@
=@
=@{@ff@R@\)@ff@@Q@G@\@@@@R@\)@@=q@@(@@@  @@G@@\@=q@G@\)@Q@@R@(@(@(@@\@@  @
=@R@@p@z@z@@
@H@=q@\@@\@\@\@33@@H@=q@H@@陚@=q@H@@=q@@H@@\@  @@
=@ff@ff@ff@\)@陚@\@@H@33@(@p@@@(@
@@z@H@@p@R@@R@{@  @@@A   AGARA  AQAzAAAAAffAAHA
=A
=A
=AA\)A
=A	GAA
AA\)AHAAA Q@ff@\)@@@p@pAApAA @p@\)AA z@p@
=@@
@@@H@@@@G@@@@z@@@=q@\@G@G@
=@33@\)@
=@@Q@ff@@
@  @33@R@@R@  @=q@R@  @p@R@@H@@@@ff@{@=q@@p@  @@@@@@H@z@33@(@{@ffA   A (AAA{AA   @ff@ffA A zAA @@@\@z@33@@@\@@@G@@@\)@(@R@@@@@@@z@@
@@@p@@
@@
@@p@p@
=@
=@@\)@{@{@ff@@p@@33@@@@
@H@Q@R@@  @G@@H@G@G@\@G@(@@=q@@G@=q@@@33@33@H@@(@@z@z@ff@@@H@33@@(@@
@{@RA QA @{@{A zA A A   @@
=@@z@33@(@=q@\@@@\@=q@@@@@G@@Q@Q@  @ff@R@@(@ff@@ff@p@ff@
@ff@ff@\)@@@z@33@H@(@@(@R@=q@=q@\)@\@33@
@@z@(@p@@ff@@
@(@
@
@R@
=@ff@{A z@A   A AA zAGA A A zA A AA{A
=AAGAAApAffAQA
=A@RA A A A @RA AAQAA	A	A(ApAAA
=Ap@A(AHA A @@\)@@Q@z@@\@p@AAffAA
AG@\@\)@@G@\)@Q@@@  @@33@\@=q@@\)@
@@(@ff@\@@{@@(@Q@Q@@z@\@@{@\@@ff@
=A QA ApAAHAARA=qAAAAA33AHAAzA	A	A	pA	A	A
{A
RA
RAA33A
HAQA=qA(AzA
RA	GA	AAHAAAGA
=A(A
=AAA
HA	A\)A
ffAAAA	@A z@
=@A @G@@
=@ffA QA   @A A (A   A@@@p@p@G@@R@Q@33@=q@@(@@
@@
@z@\@޸R@z@@ffA  A
Aff@RA zAA@@A   @\)@
=@R@ffAzA
=AHAGA33AA
AHAA\A  A  A{AA @pA @33AA  A Q@{A (A
A=qAAQAHA QAffA\AGA(AAHA @33@p@@=q@
@@\@ff@
@=q@p@(@@  @p@@@z@G@@
@@Q@@
@ff@H@ff@@R@33@z@@
@33@(@ٙ@Q@  @H@ᙚ@
@H@\)@\@@R@
@ff@(@z@@Q@@ff@@H@Q@@
=@R@@(@z@@Q@
=@p@@p@@@@@@@z@(@ff@
=@{@ff@R@@@  @\)@Q@陚@
=@\@\@ᙚ@
=@
=@@ff@@  @  @Q@  @@@Q@  @
=@ff@@{@p@@ff@  @ᙚ@33@\)@
=@ff@{@ff@{@Q@@Q@@@p@@p@߮@޸R@@@@ٙ@
=@\)@33@ff@  @Q@@=q@@\)@33@=q@ff@@@H@@\@陚@  @\)@@{@ff@@
=@
=@\)@@Q@@R@z@R@@{@
=@A33@  @=q@@  @R@@@{@@
@H@@G@Q@@ff@G@G@@
=@R@
=@\)@
=@p@@
@(@(@p@z@@@z@ᙚ@\@@
@(@@@@33@33@
@=q@
@z@@@@
@(@p@
@z@ff@@@ff@@G@=q@@\)@@R@(@R@{@@H@(@33@  @\)@G@  @@R@ff@{@
=@\)@  @@33@{@@ffA AAGAHARAG@ffA AG@{A   @@\@z@33@(@
@(@@
@H@G@G@
=@Q@@Q@ff@@ff@ff@@{@@G@G@@@@{@@@\)@G@=q@H@=q@Q@Q@@(@H@G@@  @ff@@{@@@(@\@@ᙚ@@߮@H@H@p@=q@  @{@(@@@\@=q@H@R@@H@@H@@@@=q@G@@@=q@@@@Q@  @\)@Q@@
@@pA A QAGA @@@
=@R@R@33@@@G@陚@(@{@(@=q@\@Q@@\@\@@  @
=@\@(@(@z@{@G@@p@\)@@陚@R@@
@@33@=q@@G@@=q@@@@@ff@p@
@
@@{@
@{@{@p@@@@Q@Q@33@\@@陚@G@
@33@陚@@Q@R@{@p@{@R@@z@p@(@Q@@@@  @  @H@(@z@H@@
=@p@@@@
@\@\@@陚@@@ff@ff@@p@@ff@\)@p@z@@z@z@
@R@p@@p@(@@(@
@G@Q@Q@33@H@33@
@ᙚ@\@H@H@ᙚ@ᙚ@@Q@@@  @ff@޸R@@@@\@
@z@p@{@@{@@(@H@@\@z@(@z@p@R@@@\@@H@@(@@@  @{@陚@陚@{@p@  @@@@陚@@ff@@@@G@\)@@Q@
=@@G@陚@@G@@
=@  @
@@@\)@
=@
=@@@@p@@p@
=@\@陚@Q@R@  @@@\)@\)@G@=q@@@陚@@p@33@H@\@H@
@(@@@H@
@
@
@p@H@
=@@=q@(@\)@@G@Q@ᙚ@G@ff@G@
@z@z@Q@@@
=@33@@\@ff@@@A   A AGAARAHAQAAAAApAA=qA{AAAA  AQApAAHAffAA ApARA
=A\)A @@33@\)@@\)@
@@z@\)@\)@@@@R@Q@@z@
=@@(@@@G@@@G@  @ff@@
=@
@33@  @33@G@@
=@  @@G@@
=@@Q@=q@陚@G@@ff@pAGAHAAHA  AAA{AGAARAQA=qA@p@{AGA  A\ApAA(A\A\)ARA
A
=A\)A	pA
AffAHAffA\)A
A\)A
ARAHA
A
=AAARARARAzAA QApAAGA=qAA
HA(A
pA  A(A{A @@@
@(@\@  @AAzA	AR@
A
@  @z@@ff@\)@33@33@GAQA zA@A@pA	AA
A
ffA
GA
GA
A
AAAAzA  AffA
AHA!A\AAA#33A"=qA#\)AA\AA{A#\)A)A+
=A%GA,A-A,  AAAQAzA@{A=qA\@@p@
=@=q@G@pA@RA=qA  @p@z@=q@A (A33AA\A{A(AffA
AAARAA33A(A
A{A z@A  A=qA QA\AHA\A33A\AG@
A QA (@
=@(A   A A
=AffA (@  @\AffAAAA(AA
=AQA=qA\)A\A{AffA=qARAA$A$zA#A!pA{ApAApA\)A!A#
A%pA&HA&HA'
A+A,A,A+A%A!pA zA$A"=qA%A"=qA
\AQA @zA
@R@
@R@R@@@33@=q@pA{@RA A33AAQAffAAz@(@\)@@=qAA{@ff@@=q@=q@@@ApAzAA  AA=qAGAHAffAApA A AA A\)AffAAGAffAA(AAA\)AA
\A
AAAzAAA33ApA=qAA (A A!GA"=qA$(A(QA'\)A$zA A=qAGApAAAApAAAAAzAAA{A\)A33AA
=A
pA
pARA(AAAffAzA\)AApAARAAGA\A
=@(AAHA=qAAGA(A  AApA{AHA33ARA   @@@
@G@@\@@Q@z@@
=@\@H@\@R@@  @@33@RAffAA{AAAA  AA  AQAAA33A AAHAA
=qA\)A
HA  AffA33AQAzAHAzA33A
=AARARAA{AA{AzAA
AA{AA=q@z@
@@z@@@@\)@
=@@@@@(@p@@(@@@@=q@\)@  @@  @=q@{@@\)@
@33@  @Q@p@@Q@ff@
@  @G@{@@\@=q@@z@H@@\@@{@@\)@\@\@
A A
=AHA33AQA
ffA
RAQA\)A\ApARAARARAA\)AAAGA	A @RAA{A{AARAGA
A
A
A	A	AAzA
=qA\)A	AAA\)A@@@ff@@G@R@ff@@z@H@=q@@  @
=@p@陚@
=@  @ff@@
=@
=@{@@@@p@=q@H@(@@G@@p@\)@@
=@z@陚@@@Q@@\)@{@
=@\)@@
=@ff@G@  @
@33A  AA  AHApA A (A A A A QA @
A{A\)AA\)ARA  AAffA\)AA
\A(A\A  A\A{A z@{@z@\@@H@\)@@@{@z@p@p@z@z@H@@33@H@33@33@\@@@@
=@@ᙚ@@G@ᙚ@\)@\)@\)@@@{@  @ᙚ@@@@ff@Q@@33@\@@H@@
@Q@\@=q@G@=q@@ff@p@z@z@@@@@\@
=@\)@\@@(@Q@=q@AGA=qA
ffAzA{AffA=qAAQA=qA33A
A	pAAAA=qAAAGA33ApAAzARA
ARA
=AzAAA	AA
=AffA z@{@z@=q@@@p@@  @@  @@
@\@R@R@=q@33@@@@@@(@R@
@z@\@@@z@=q@
=@@
=@@
@
@陚@@G@p@H@@ff@@=q@(@Q@p@
@@H@\)A
=AA
A33AGAHARAffA\)A
AAGA{A=qAHAffA\)A
AA	AA  AHAHAQAzA\A(AAA\)A\)AAAA{A
=A	AGApA@RA @@p@ff@\)@33@33@\@=q@陚@  @@(@@z@H@G@ۅ@33@
@@ff@@{@@
@@@R@ᙚ@=q@=q@@@(@@z@{@@@@=q@\)@33@\@@@R@@
=@@@AffAA33A\AQAAA(AzApAAA=qARA(ApAzAGA33AA(A
=A zA
A#A'
=A(QA%A(AAA"=qA%A'33A!A=qARAGAAA\AA=qA
A
=qA  A z@
@pA@@H@ff@\)A33A  A@@33A33AQApA{ApA A Q@R@\)AA=qAQA\A
AzAA\A{@ffA
RAA
\A	AR@@QAAA@HAHA
A
=AApA(AAA\)A\AA=qAAzAAGAA{AA (A!A"HA!A"\A#33A#A"\AHARAA
AAQA33A\AA(AAAHAHAAApA33A{AA33AA(A\)A
AA
A
=A(AA\)A	AzA
pA  A
A
AA
=A
A{AA
{A{A
=AzAAAffA
AA33AR@@\)@@
=@\@\)@@@G@@
@=q@33@
@@{@33@z@H@z@\)A33A
ARA
=A{AA\A33A33A  AA
{AA (A#A(A
=AQA-A-A#
A&ffA&ffAGA   A QA33A   A%A$A%A%A#
A"\A"{A=qAAA  A
AHA{A=qA  A\)AffAzAHAA@  @  A A AA33AA
AQA
=A	A	GAA	A
{A
=AA(ARA\)A{AA Ap@@
=@@@\@Q@@{@\@@  @Q@ff@@
@@
@@@pAGA@\A (AGAARApA=qApAzA
=A QA\)A$(A$QA+33A#\)AA=qA{@A (A (A.\A)pA'A#A0zAA(AffA
=qAA$zA+\)A2RA.\A,A.=qA0QA/
=A$A
AAAffAA @@@@Q@RA{A33A
HA
=qAA	A  AApAAzAA(ARAA\)AzA\)AA=qAA\)A AH@@@H@@G@@
=@@G@\@陚@  @  @R@(@p@@\@\@{@@
=@@ffAA	AAQAGA=qA\)AzAA\)A(AAA
=A
A\AAAAHAAzAHA
AzAAQAAA\)A\)AA
GAz@(@@{@@@@@R@  @
=@@G@R@p@z@
@=q@R@{@(@(@\@R@{@
@H@
=@ff@
@\)@@@R@ff@G@
=@\@@@@@@Q@
@Q@\)@G@@@=q@\@{@@  @@@z@{@{@33@@
@ffA   ARAAffAAffAA\)AQA33A
=qA
=A
GAAAAA
=A\)AQA
=ApAAzA{A
=AGA Q@p@G@\)AGA
GAA
AAA(AA  AQA  AGAQA\)AAARA\)AR@
=@z@A  A  A @@
=@\)ARA@(@@Q@=q@@Q@
@陚@  @\@=q@@@\@@@{@=q@\@z@(@=q@H@
@@Q@\)@z@
=@p@@@@RAApAQAApAffA{A\AAQAA	A
RAA  AA
AA  AGA=qAA
{A
\A	pAAA\@{A   AG@(@{@@zA@@zAzAHAA	A
{Ap@Q@@
@@R@陚@=q@@33@@33@\@@=q@
@ff@\@p@\)@{@
@
=@(@@H@@\@G@R@z@@(@@@(@@@H@=q@@@
=@ᙚ@(@ٙ@@ff@@@@
@@p@\@\)@@H@G@@ff@@\@G@\@\@(@
@@
=@@@33@@@
=@@@33A   A zA33@@ff@@{@  @@@=q@@@p@@@@@@@@R@Q@{@{@
@(@@@33@G@33@@{@33@@
=@@R@{@{@z@
@H@@@@(@H@@p@陚@@
@
=@@(@ff@G@@ff@@@R@@
=@@33@Q@=q@
@H@@R@AA AA  AffA	pAQAAAA
=qA
AAzA33ApAAA
=A=qA
A=qApA  A
AA  AA@pA=qAffAAAA	pA(AHA
HA	AAAGA
=A	AHAzA
=A{A
ARA33AQAA33A
\ApAA\)AAHAAAAffA33@@@\)@@{@
=@  @
=@@R@@陚@\@@z@ff@Q@@@\)@@
@\@@{A{A zA @pA QA
A
A
=A!A&HA(A,A.=qA.HA1A2ffA2HA4QA5GA4A5A5pA3
A333A2ffA2HA0A1A0(A.=qA((A)pA)GA)A-A)GA
=A
=A&RA(A=qA=qA
pA33A
ffA
=qApA A	AARA  AA@=qA
AA
AzAAAAA
AAzA\AzA	AA\)AQAA zAA A QAA{A
AAzAzAQ@@AApARA\A AG@A{AApAA
A\)A	A
=A
HA
RA	pAA
A{AzARAAAHA
AAApAAffAAA=qA   ARA
=AffA\AA{A\AffAffAApA\AA(AHA
A
pAffAApARAARAffA(A
HA	GA33ApAARA
=@@\)@@(@\AHAA\AQA
A@=qA33A
A
AA
=@HA
=A(A33ApAQA33AzA\)A  AHAHA z@p@G@33@\@33@(@\@z@@z@ff@A @R@{@ARAffAQAzA\)A(AGAAAA33A!A#\)A%A'33A(A+
=A+A+\)A,  A,QA#
=A&\A QA*\A%AAGA{A  AQA	pAA33A{A\AQA{AA	pA
=AA\)AffAffA
=AAA
AA
=qA(A  A
AzAz@A Q@(@G@=q@AA{AA@33@@z@=q@A33A
{@A
=AQARA33@33@H@33@Q@ff@A QA AGARA{A
A
=qAffA
=qA
=A
AQA=qAffAGA\AA
=A{AffAAAAzAA{A
=A!AA$(A"ffA A!A
=A  AA  AA{A33A	GAAGA  A  A\)A
=AA  AHAAGA   AAGAHAA{A  A=q@@zA Q@@H@\)@Q@
AGA	G@z@  @p@=q@\)@
@\)@
=@HApAG@
=ARAA33A	AA\)AA{AA{AGAA  ARAzAGA	AHA  AQA
A=qAHA@
=@@@
@ff@@
@(@=q@\@z@
=A AHAAAQAA\)A
AQAA\)A{A @@@G@  @p@G@\@@R@ff@ff@@33@@=q@
=@@z@
=@33@@=q@p@@ff@Q@@
@(@(@H@@@陚@  @  @z@  @Q@R@@p@\@p@@ᙚ@(@
@p@@@@@\@@@@ff@@@Q@\)@  @\@@G@=q@=q@@H@@p@@@=q@H@=q@
@
@@@z@R@
@@@@{@@Q@R@(@  @G@@=q@@z@{@33@{@33@
@@@@@
@{@@@G@  @G@@@@33@@@R@(@(@z@@R@R@R@@@R@\@
@@@H@@ff@(@@@@@@A @
@33@@\@\)@R@@=q@33@R@@=q@33@@R@@@R@@R@@@33@@
@@@33@  @{@G@A   @@@@33@@@@{@@  @  @R@A
@z@@\)A AAAffA{A(AA
HA	A
=A\)AA
=qA
=qA	GA	A(AA{AHA=qA33A@
=A AffA\A=qAffAAARA=qA{A
=AAQA=qA\)A AA33A\AAAGA  A{@H@(@\)@@@Q@33@G@@  @z@
@@=q@33@@@@(@{@\@zAA @ffA (@\)@
@Q@G@p@z@A A QA @ff@@@\@(@H@G@@@R@{@p@z@p@@@zAAA  A (ApA A Q@A   A@\)@H@@z@ff@RA QA A Q@
=A zA (A zA z@ffAAp@RAffA=qA\AHAA
A(A
=@
@(A @33@p@@@{A@R@p@ff@
@\@{@@(@H@@33A   A (A AAGAHA(AAA=qAAAA=qARA  ARAA
HAHAzAQA
{A
=AAQAApAAA
=A AAAA
A33A QAARA\)AffAA AAARA\ApA\A\)ARAA zA Ap@H@G@@  @
=@z@RA@@{@@p@  @\)@
=@
@@QA   A
AA@@=q@ffAG@@R@ff@@@@A zARA\AHA(AAAAAA	A33AAQA\A\AAAA zApAGA(AA
=AA  A	GAzAzA
HAzAQA
=A
HA
A\)AARAA(A
AA
AA\)AAAAAA  AAQAA
AzA  AAQAAAGA\)AAAHAA (@
=@pARAffA
=ApAA@33ApApA\A zARAG@Q@@(@@@33@@@A@ffA z@R@G@p@@{@
=A A QAAA=qA
A AA\)AGAzA AHAA  AHA
AAffAHA
=A(A(AA	A	A	pA	pAAA(AQA
=AAA{@p@G@@H@@(A zAGA@z@p@(@@G@@R@Q@@@@@z@@\)@\@@\)@z@
=@@@{@z@
=@ff@(@@H@@@@\@@z@@33@
@@@@\)@  @@p@@H@\@H@@
@H@
=@@A
=AHAAffA{A\AffAA\AQA
=AAAA
=A(ARAA{AAA\A
=A\A\AA@z@@p@H@\)@
=@@{@p@@@Q@\)@ff@\)@(@ff@{@\)@R@@@\@(@@@@Q@@@R@{@
=@
=@Q@R@(@@ff@@
@
@(@
=@p@{@R@@{@
=@R@p@H@R@H@p@(@Q@@ff@{@@R@@H@33@Q@Q@R@  @@@  @=q@\)A=qAzA{AA	A
=AzA
pA	A	AffA	AHA
=A
HAA
GAzAAARA Q@p@@z@H@33@ff@=q@@@(@@@Q@Q@@@ff@=q@  @=q@
=@=q@
@33@  @=q@
=@{@ᙚ@@Q@@R@ff@p@33@=q@@
=@ff@@@@  @G@
@\@@
=@p@R@\)@@
=@@ff@p@
@33@33@\@@
@(@@G@z@H@@33@@@@@@\)@@@
=A QA{AA
A
=A  A{AGA
AGA  AzA
\A=qA\)AA
A
ffAA(A\AA
A A (AG@
@@@H@Q@G@R@\@@R@@z@@p@{@陚@@33@@
@G@@@
@@H@
@z@@\)@ff@ff@\)@
=@@H@  @@ᙚ@H@@
@@@  @@@@H@=q@p@>ff@(@  @zA   AA
=ARAAffAQA
AAA33A
pAffA(A
A	AA{ApA{ApAQA\)AAA\)ApAzAA
A
AA
pA
A
A\)A
=A\@\)@
@@=q@@@@\)@
=@@ff@{@@@  @@@=q@p@(@  @@p@
@33@@
=@G@@ff@Q@@R@p@z@@@@@@(@@R@@\)@@R@@=q@(@@ff@ff@\)@  @Q@R@Q@z@33@@\AAAApAAAA
\A	GAA
A
GA
AQAA
RARA\)A  AAzAHAQAQAAAA\)A\AA
RAAA@{@p@
=Ap@@ARA (A z@33@@ff@z@@@@
@@=q@\@Q@@@=q@@@Q@@G@{@\@陚@@p@@G@=q@Q@z@@p@ff@@Q@@@@@ff@@R@ff@(@R@AzAA=qAHA33AAHAAA33A=qA QA A QA zApAA33A	AA
{AAA(AA{A
AAARA\AA
\A
RA\)AAQAHAAA{AAARA\A @@p@R@R@H@@{@@ff@@@
@33@zAA33A A=q@\)@p@
@@@@H@Q@@@Q@{@{@\A @ff@(@\)@Q@z@ff@
@\)@\@@
=@G@@@\)@Q@@AGA
AA=qAHAffA=qAA	A
ffA
HA
AA
A
pA
GA\A
A
A{A
A
AAAAARA
A
AA\)A
RA	A	A
=qAQA33A33A(A=qAA
=AffA\A\AAA @A   @@@pAG@p@=q@@Q@  @
=@p@@z@@@@\)@@{@R@R@Q@@G@33@H@=q@@@H@33@z@@ff@H@@@\)@ff@@p@
=@RA @@33A (A
A=qAA=qAAAAApA\AffAAffARA
A(ApARA  AAA\AQAAQAzAA(ApAA33AAQA(A\A
\A
=A
A   A@\)@@{A   @@@@Q@@@33@H@G@
@
@@p@z@(@H@@ff@{@
=@ff@p@ff@(@R@@
=@A Q@G@@
@ff@33@@(@{@=q@@@@\)AAAGA=qA\)A(AA
=AAAAzA	A
=A
RA
A
AAA{A
=A(A\)AHARA!pAQAAAzAGAHAzAAA=qA(AA33A=qARAA
ffARAAHAQAA\)AQA
=AA=qA
=AAAAA\)A(A A zA QAAHAAQAA
A
=qAARA33ApA@A@ff@@
@@z@(@  @@@  @(@(@z@{@R@@@\@@=q@(@@(@@@A\)AA{A(A\A\ARA
=A\AAAAffA   A A!A#\)A$QA%GA'A*HA-A/
A1pAA A$A'AA\)A!A
=A{A
AQA
@{@@Q@@p@
@=q@@Q@@=q@H@@R@p@@ff@@R@@z@\@@@G@R@  @z@@ff@@G@(@\@@@R@(@@33@@@H@@@
@33@@@@@\@@H@{A=qA(ApA=qA\A Aff@@G@@@@@33@@
=A   A@AA\)AA
pA33AAAffAffAGAA  A=qA\)@@33@Q@A Q@@(@=q@  @  @ff@@@z@{A @@A (@H@H@@@@AAp@H@
A   @@z@33@HAffAA@AffA Q@@@@z@@\@
=@@@p@33@ff@@H@
=@@@{@z@=q@{@{@RAGAffA=qAGAA
{A
A33A=qA(AA\)A'\)A%AA=qAGA\)A(A
AAAGAA{AA{A (A(QA)A(QA((A*ffA(AGAffAGAAA=qAG@z@\@p@@@ff@{AA(@@\Aff@\)@  @p@p@Q@@Q@{@@@@=q@\@(@\)@@@=q@=q@@33@@(@{@@A{AA@ff@@  @z@
=@@@@
AAGA\A
=A
AA(AAA\AHA33A33A	AA   A\AA Q@AAAAA
A	pAA  AA   A"ffA#
=AA
=A#AApA{AA{AA
=A\)A
=AA=qApAAA@p@\)A
=A=qAzA@
@RA   @@  @\)@@@@R@p@
@@z@=q@ff@G@@@@{@Q@H@=q@Ap@{@
@@@G@H@G@Q@(@@G@@\)@  @@p@{@@{@p@A	GAR@AA
=@
=A33AA
GA\AGA
GA(A  AAAA  A"HA!A(A"{A#
=A$(A&RA$zA&ffA A\)AAAQAApAzAAHA
AGAA  AffAHA
AA
GA(AGAA33ARAAA  @z@z@Q@33@G@33@\@ff@
=@@
A @\)A   @@G@HA A (A (@
=AAA   @@{A zAA@
=A @(@ff@R@
@@R@\)@H@HA @
A\)@A{AAA
=A
=qA
AA\)AzAHA
{AGAA33A(A   A
AA33A33AG@
=@\@AA
=A=qA%GAzA{AAARAQ@\@@R@@ff@z@ff@@G@R@
=@ff@z@@@\@R@
=@@@G@=q@\@ff@
=@@R@@@G@(@@\@=q@
=@33@=q@@p@\@\@@G@@G@@  @@z@\@G@@@@Q@ff@@  @=q@33@ff@@{@(@AAffAGA QA@@\)A AA\)AAffA
A33A
GAAA ARAHA\A AGAffAHA{AGAQApA\AQAAAz@
=@@@@@\A zA
A(A  AA(A  A\A  AffA33A33A@\)A{A   @AR@@=q@A (AAA   @{@A QAG@H@@@  @R@@@(@@@@@
=@
=@@@@@
=@ff@\@Q@H@@H@@
=@@p@ApARAA	A	A
\A(A
ffA
\A
A\)AAffAGAAGAAffA(A"{A AAQA   A!AAAAA
GARAAA\A
A	AA
\A  A
AzA{AA(A(AA@{@pApAG@
=AAAA=qAA zAAAHAA@AA{AA A A AA\@@(@@33@@@
@@@H@
@
=@z@@R@A Q@
=A   ApA
@
=@\@
ARA\)A\)AA\)A	AA
RA=qAA	AARA=qARA\ARA	AGA  A   A AHARA AA (AAff@\A=qA
pA(A{AGA
=A  A
=A(A33A (A @ffA A=qA33A(AA\ApAH@{@@z@@R@R@z@=q@@G@@H@\)@ff@
=@@@ff@
=@@
=@@R@@
=@R@  @\)@(@@A (@@\)A QA A A AGAHA
AAHARAQA=qAA  AGA(AA
=A  ARAAQAAGA(AAGA
=AAzAA
=A
AA\)A{AAffAAAffAA{AAQAA
GAARAA
AAzA{A
=AA
A
\A{A	A33A	pA
A33A{AAH@A{AA33A	AA
AA
AffA
AzAAA=qA33AAA\)ApAAAAA{A	AQA
pA=qAAAAA\)A  A  A=qAAAAHA
AHAQAAHA   A   A   A A A A A"{A!A zA!GA A!GA$  A)A)pA%GA#AARA(AARA\A
AA	AQAAzA{AAAHAzA
=A	A\AA@@@33AAA	pA\A\)@@(A A (ApAG@ff@HA QA QA @
=@@
=@G@G@@A @@p@H@@
=@
A=qA   @G@A33AHAAzAAAARAzA	GAQA
GA=qA
AAAA33ApAQAAzA(AAGAAA\AHAA$(A$(A&=qA'\)A)GA%A-GA$AAA
AQA=qA{AA   A @
=@@H@A
=A z@H@@H@@Q@{AQA	pA
A
pA
RA
A
RAQAA=qA\A
=qA
RA
{AA\A\A   @@\)@
=@@@@
=@H@@@ff@H@\)@\)@\)@R@\)A A33A
\A	AA
HA
=A	pA33A(A\)AffAffA@@
=AAAA33A
=A
ffAffAGAA
A=qARAAA{A=qA"=qApA QA#33AA
AA"{A  A A (A A QA\A  A
A(A (@(@
=@ff@@H@
@H@Q@\)@R@R@@@\)@@G@
=@@
=@@GA=qA=qA\AAA Q@ff@ff@@p@@{@
=@H@G@
=@z@=q@\@=q@p@ff@
@@Q@AA@H@ffA=qA\)AAApA@A QAHAAARAffAzAQA
A=qA=qAAHAAHA\)AGAAHAA\)A\)A\AA{AApAHAAzAA
AA
A
{A\)A	GA\)A
=AffA ARA@
=A
=@z@Q@{@@@ff@p@{@33@@@@Q@@ff@z@@@R@@
@@@@p@
=@R@
=@@R@@R@Q@@p@=q@R@
@@@@@A   @@{@@{@GA Q@AR@AAHA
A
ffA
=@R@H@  A QA
A\)A\)A{AzAAAA	pA	pAQAzAHA
{A  AAA(ARAARAA
@\)@@G@pAG@ff@ff@  @{@R@@
A A\A(Aff@  AHAA	A
{A	A	A	GAR@AzAHAAGA @R@@@p@G@@@33@H@=q@@p@{@
@=q@@@A AA QA (A zAffAAHAffAQAA
A	AA
pA{A
AGAA=qAzAAApA=qAQAffA33A=qA
A A#
=A$QA#33A%A"ffAHAAzA
=qAffA=qAzA\)ARA\)@pAG@zA
=A A
A A A\)A(AAGA
A(A@AA
=A\)Aff@  A(A\)A@@@@z@@{@AffA{AAAA\)A @@@\)@@GA @p@@zA  AAAAA\A
\A{@
=@=qA33AGAAA33@{AAA{A33A=qA
pA33A(AApAzAA
=AAA zA33A=qAAzA=qAHAA
=AGAAAA
GA
pA	A@@R@@@@@A (@\@
=A@
AHA=qA   A A
=AA (@
=@z@@\)@
@p@ff@\)@@z@ffA\AA\)@@
=@{@@p@\)@@
=@G@{@\@H@  @@@@Q@@(AGA
=AA
A QA @\@@{@pAGA   @\)A
A zA
=A (A(AAQA(A
GA=qAAA{A
A33A
{A
A  ARAAGA33ARA
HA
{AA33AzA	p@
A @p@=q@G@=qA @R@
=@Q@@HA33A A z@\)@A   A QAGARA   A{@(@Q@{@ff@@\)@@=q@R@p@@@
=A (@R@=qA33A  Az@=qA{A\)A
A
A=qARA
AzA{A\)A(AzA\)A\ApAzAGA
=A
=qA\A=qA
AAA{AAzAffA\)ARA  A
AA\AffAHA
A\)A
=AHAA
AA  A\AA(A(AGAA
=A  A33@A (@ff@@(@@@\@@Q@{@@H@@ffAQA=qA  A   A A z@R@p@@@(@ff@{@@@@@@H@=q@@A @p@G@@@33@H@G@z@@\)@@@@p@RA AGA @(@ff@@A zA QAAAffAHAA  AQAzA
A{ARA33AAGA\AAAAAQAHA A{A	ARA
=AHARA
=A\)A   @=qAAAA
=@ff@=q@@@@ff@@H@(@ffA   @@@@A A (@@z@@@33@  @׮@\)@H@@33@
=@ۅ@߮@H@޸R@ᙚ@33@(@{@
=@@  @@@@(@H@(@
@{@\)@Q@p@
@G@@  @=q@z@\@Q@@
@@
=@@@@H@33@=q@\)@@ff@(@G@@(@@
@z@@\@@ᙚ@G@ᙚ@G@ff@\)@\)@߮@\)@\)@@߮@ٙ@Q@ڏ\@@  @33@=q@ٙ@@\)@ff@ٙ@H@޸R@G@@  @
@Q@{@p@У@@ff@@@
@G@ڏ\@  @@θR@У@\)@@
@H@@@љ@\)@  @أ@=q@@ff@{@@(@
@ff@@\)@ٙ@{@  @p@@{@\)@R@@(@
@
@陚@Q@R@ᙚ@߮@޸R@=q@\)@@@(@ᙚ@@33@@(@z@ff@
@Q@߮@  @ᙚ@z@
=@G@@\)@z@@p@=q@@33@љ@ҏ\@\)@ff@@@H@H@Ӆ@
@(@@@(@H@ҏ\@
@33@@θR@@@@љ@Ӆ@p@@@@=q@љ@@G@G@33@Q@{@ff@@(@p@z@G@  @R@G@G@  @@@@  @z@=q@@{AGA z@{@@ff@z@ffA (@@
@G@G@@  @@Q@ff@p@@33@{@p@@@z@ff@陚@z@(@@Q@@陚@  @{@Q@@@  @
=@p@  @ᙚ@Q@߮@ff@R@@G@@=q@ᙚ@@  @@\)@p@p@@p@33@\)@=q@
@@@p@@=q@z@
=@A ARAGA\AAA(AzAA	A
RA\)A
=qA
RA
RA
A
=A
AARA\A
=A
=A=qA33A\AAA
A
A33A A   Aff@
@@(@p@{@=qAA@@@\)@
=@
=@z@@p@@Q@@
=@{@R@p@@p@G@\)@
@(@@\@(@\)@@@(@(@ff@\)@ff@33@\@\@=q@@@G@A AAffAAGA\)AA
AzA(A
A(A
A
A
AHAA
pA
A
RAA{AAA=qA
=A33AffA
=A\ARAAzA\)A  A
\A
RAA
ffA
=qA
\A33A
=AffA @=q@ff@@@
@@33@(@(@33@(@@@@
=@{@p@z@z@
@33@H@@@z@@R@\)@@@=q@H@33@@33@
=@=q@p@@pA @
@@(@z@ApAGAGA
=AAAAHAzAA
AGA{A
=AzARA(AA	AQA
\A33AzAA	AA
ffA	A\)AAHA=qAQA
AA33A(AA=qA  A=qA\)AGA\)AA\)AAHAA=qAQAApA@@{@33@
@Q@G@@@@Q@@33@=q@R@@z@G@z@@@@G@ff@p@@@@@@=q@H@{@@H@@
=@Q@Q@(@@{@
=@@@  @@@R@
@RA @
@ff@ff@R@33@@Q@G@@@
=@љ@ҏ\@ҏ\@33@{@@ָR@أ@@ᙚ@
A@{@@@ָR@ٙ@(@ff@33@@=q@33@(@@  @\@H@33@
=@p@@(@@@@G@p@
=@  @@{@(@G@ff@@@(@@@陚@z@@Q@@G@33@@\@@\@(@@z@@@߮@H@G@@@
=@޸R@@@\)@޸R@@ff@޸R@@(@
@H@@@G@H@@޸R@@33@\)@=q@33@@{@\)@@  @G@@@ff@zApAGAA @@33@=q@(@A Aff@33@{A\A
RAA
AQA
=AA  A(A$AAGApAQARA!pAGA
RAzAAQAAA
HA\)ApA  AGA33AG@A@p@(@H@@@\@p@(@@@z@33@@@p@@R@{@33@
@A   @Q@H@ff@@H@R@G@z@{@z@@@
@p@@{@R@Q@p@AffA33@@{@G@Q@(@A (A33A
=@@@@
AAAA\A
RA
AAffA{AAA
AA33A33A=qA  AffAAA  AAzAAAGA
=ApAA
A\@A@33@{@H@\@\)@@
=@pAGARAffAA
AA A@33AzA  A
=A=qAffA
=AQAAffAQA\)AA\)AffAA zA @\@z@{@@z@\)@@33@AAAA
HAA{@ffA A @
A @HAAAA
A33A(A{AGA{AGA\AffAQAAA  A	pAAAAA\)AA
ffAA	AAQAQAA\)AA (A QA@@G@G@R@p@@@@\@z@H@\)@@z@\@@@=q@@
@33@R@z@33@@Q@p@ff@ff@Q@\)@@33@=q@  @@R@@@=q@@@ff@\)A Q@A @R@A
\A(AQA\)A\)AA{A\)AA33A
A(A(AAHA
AzA{A33A!A#
=A!A"ffA$zA"\A#33A A'
=A33AA\)ApA(A=qA  AA(@{@
@@\@\@z@@{@pA(AAAA
=ARAA(AGAffA@@R@
@@A=q@@(@@33ApA   A A A @p@R@=q@Q@G@陚@\@@Q@Q@G@(@@@@@AGARA@@@A (@G@
A QAA@(Ap@@GA33@{A
@A
\AAA
ffAA(A
A33AAAQAzAzA
HA(A
{AAffA@ff@Q@z@G@ff@{@@z@G@(@R@(@=q@@ff@
@@
@z@@@R@Q@@{@@R@@@@@@@
=@
AG@
=@z@@Q@(@ff@R@z@G@@=q@ff@@  @
=@@\@33@@33@
@ff@@p@
=@ff@
=A{@@\@{AApAG@AG@
@@ff@@p@
=A zAG@R@@p@=q@
=ARAzA A (A   @A Q@\)A Q@@RA A@\)A   A (A   @\)@@@\)@@=q@ff@G@(@@陚@{@@@H@=q@33@
@
=@  @@H@@Q@(@@p@@@\@R@ff@z@
=@(@\)@@G@@@(@@@\@=q@\)@=q@G@ff@\)@@G@@
=AA\AAA(AAff@H@G@zA
=A @33@@
@@pA   AAQA{A  AAAQAHA AGA A (@
=@p@
@ff@@@  @
@@ff@\@
@@(@Q@@@Q@@ff@@H@@@@=q@ff@@陚@@=q@陚@@z@z@@陚@@{@@
@G@@p@\)@Q@\@G@G@
@G@(@z@@p@p@@ff@\@
@@@@{@=q@\@z@ffA zAAA
{AAQAA
GA33A QA  A=qAQA(AAGA
=ARA=qAAzA
\AQAQA
GAAAAA\)@A   AH@
=@@@@G@  @@Q@@@@@@R@\@G@G@@z@@@
@@陚@@G@@
=@p@@z@
@@33@33@H@@(@z@R@=q@=q@zA (@R@R@AffA  AApAHARA
=AzAffAQA	A
ffA
RA	AA
pA
A
AAAAAAA(AA\AffARA\AzA
AHAAQAA
ffAzA
=A	AAz@QA=qA@=qA@R@\@@@
A @=qA\)@A   @@z@@R@\)@@@ff@@z@p@@@{@@z@@@33@R@@(@@  @G@{@G@G@
=@{@@\@@\@  @\@R@@
=@pA @
A (AGA @@@H@H@ffAp@
=@{AAGAGA  A	A
AffAQA	AAA
ffAA
RA
ffA z@H@Q@ff@@\@@@33@z@
@Q@=q@@@@=q@(@@ff@z@@Q@R@  @G@@@@@p@@@@{@\@p@(@{@
=@@@@{@R@  @@R@@z@\@Q@@陚@@@
@p@陚@@H@@p@G@@(@=q@GAAAQAA{ARAApA  A(A
=AA
=qAH@\)@=q@A\@\@  @@
@  @=q@\@@(@{@R@\)@@@@=q@@G@z@
=@R@\)@@33@@陚@G@\@\@=q@H@33@  @  @陚@@G@@{@(@@\@\@ᙚ@R@
@R@33@  @@\@陚@=q@
@@@@z@{@z@p@@@G@Q@@\@ff@  @\@@G@@\@
@z@@{@R@@(@@33@@(@(@@@ff@@33A\A33A
ffAffA
p@\)@\@@
@=q@@G@33@\@@R@G@@@=q@  @@33@G@@33@R@Q@ff@Q@ff@z@(@\)@\@@@H@\)@ff@@@@=q@@{@陚@
@33@
@
@{@@Q@陚@H@R@@R@@p@z@
@\@@
@
@p@\)@H@{@z@@@=q@@\)@\)@@
@@
@@@z@33@
@@33@@{@ff@@@\)@ff@@@ff@\@@ff@@G@  @  @  @@@@Q@Q@  @{@޸R@  @\)@Q@
=@@33@@
@{@ff@޸R@@\)@z@
@
@ۅ@@=q@H@ۅ@
@ۅ@(@(@z@ۅ@(@p@  @߮@H@@=q@33@@@
=@G@@@߮@Q@@{@ڏ\@@\@
@@
=@@@G@陚@@陚@p@=q@@@  @Q@
=@  @=q@R@=q@@
=@@{@ff@\)@{@
=@ff@Q@  @{@@  @H@33@@@z@ᙚ@@p@G@\)@{@
=@G@\)@@(@\)@@\@H@@@G@
=@陚@@
@33@ff@@  @ٙ@Q@׮@H@\@p@  @\@@=q@@@@=q@
@R@@@
=A@ff@
@@陚@\@=q@  @33@@@(@@@@{@R@@@=q@Q@=q@@\@@@Q@@@z@ff@33@  @@@33@=q@p@{@
=@{@@
@33@@@ff@H@z@
=@(@Q@ff@@
=@Q@33@G@@\)@߮@ff@߮@=q@@߮@=q@=q@@߮@ᙚ@H@33@H@G@H@@@
=@@z@
@
@
=@{@z@@陚@
@(@p@G@=q@@@{@\)@ff@@@@(@@{@z@@@p@
=@@@@A zA A A A zAGA\A(A  AAQA(AGARARA=qApA\)A\A{A{AHA=qAAA{AAA Q@33@z@z@\@@z@(@@@p@\@G@\)@@\@33@G@ff@  @@ff@  @@H@
@33@=q@  @
=@
=@@\)@R@Q@@@@@
=@@
@@ff@@
=@33@@ff@\)@@@@Q@R@ff@\)@Q@G@A QAffAffA
AA=qA  A
\AzA
AA  AHAA33A\)AA{A\)ApA
AA
=A
A
A
AQAzA  A  AQAAAA=qAAA  A  AA	GA33AAHAAA\AA@ffA QA(A33AA@@@@{@G@Q@
@@\@@
=@G@@A A@@@
=@(@\)@z@{A\)AG@
=A
=A
{AA(A
AA33AAAA\AAAQAAAzAAffAAQA  A\AQA33A(AAA(A  A
A\)AGA  A  A(AAAQA	A
=qAH@\)@H@@
=@@z@H@
=@@{A
HA
HAQAzA
=qA
A z@@z@@@@{@@@\@z@@\@{@H@@@Q@@@AAAA=qA (A
A{A\AAGA Q@
@H@R@G@@@@p@Q@
=@G@@R@{@{@
@z@Q@  A=qA@
=AHAQA	A33AzA=qAAH@Q@@@{@=q@p@@@@
=@
@R@G@@\)@{A Q@\)@\)@
=@{@@p@R@@@@  @p@G@H@\@陚@z@R@{@  @R@R@@G@@\)@ff@@@\)@\)@
=@\@@33@p@@@
=@H@@=q@z@R@@R@R@zA @33AA\)AAAzA
=@HAA\)A$A#
A(A  A  AzAA33A zA+\)A(zA"RA!A\)ARA\)A QA{AQA{A
A33A  A\A\A	AAA
=@(@H@A @RA @R@33@  @@@z@@@=q@33@@
@H@Q@R@AR@@
=@GAp@{A   @@@z@p@z@@
=@  @R@@33@33@
=@p@@(@\)@@(@陚@H@@G@33@
=@z@{@=qAQA@R@  A
AA(A
=AQAffA
AAA(AzAApAffAAA
AzA  AA@
A33A	GA@
=@@H@R@@p@
@@H@33@
@33@  @@@@=q@G@@G@33@@33@@@@߮@@
@
@@
=@  @@=q@
@=q@p@@z@@@@p@ff@\)@@
@R@R@=q@p@@(@zA QApAA{A\)AAHAA33AffA=qA
=A=qAAGAAA
A
A\A
HAAA	AAAzA(A	pAQA\)AARA\)A
=ApA\)A{AQA @@@
@z@@z@@@@@@{A A A z@@\@\@@{@=q@\@@z@
=@ff@@  @=q@\@G@@(@\@\)@33@  @@@@@@(@@陚@
=@G@@@=q@  @  @p@(@
=@33@@@ff@@Q@33@=q@@\@=q@\)@@H@@ff@@@ff@A QA QA A AGA\A\)A  AAA=qA@A  AA\)Aff@\)@@@(@33@@G@@(@H@
=@p@@
@(@\@(@33@@@R@(@33@@\)@@@p@(@
@z@
@  @@z@(@
=@z@H@z@z@p@p@@ff@z@z@Q@@@Q@ᙚ@(@H@p@G@(@
=@(@RA (@(@@{@A zA AARApA z@H@@H@@AHAff@ffA\AA QAA @{@{A QA @p@@\@@33@G@\@Q@
=@R@
=@z@p@  @33@{@@ff@@@p@@ff@33@{@Q@H@@@  @
=@@ff@\)@ff@R@R@
=@@  @  @R@p@@@\@\)@R@@@@ᙚ@H@Q@33@G@A Q@A\AQAA=qA\AHAA  AA\AA
AQAAA
A  A33A  AAHAGAA{A33A=qA\AApApAAAAApAA
HAQAAQAApA{A
R@zA AAffAA
A
AA{AffAffAHA
ARAA
HA\)A
AA
=A   @@\)@z@\)@@@{@
=@=q@\@Q@@ff@{AAffA   @zA(AQAAAA
=ApA\)AAApAHARAffA"ffA%pA'A+33A*\A'33A-A.RA4A1A5A6RA9A/A\)A
=A\AAffARA%A!A0(A)A(A'\)AAA(A\A
=AAHAGA33A	A
A zA\A\AffAffAA=qA ARA  A @\)@{A{AzAA
=A
ffA
=A
=A(AA
HAA	A
{A
AA@H@Q@p@@=q@(@@@@{ApA @Q@\)@(@\)@\)@@zA A
=A=qA
\AAAffA\)A   A#A&RA'
A)GA'A+
A,(A-GA!pA(zA0  A333A1A,(A.ffA-A'\)AAffAAA{AAHA(AAAHA
\AA
A{A	pAA
HA	GA
AAffA@A (AH@@\)AAA A @G@\)@{@(@ff@p@@Q@
A @@@z@Q@R@z@ff@
@@\)@=q@@p@ff@p@@p@G@33@ᙚ@H@z@(@33@@@@  @=q@z@Q@@=q@@{@AHARAA @{@A@@G@Q@@\@{@(@Q@ff@z@p@H@@{@  @@33@@33@G@@H@@{@R@{@@R@ff@AAA
ARA\AARA\A	A
=AffAA  AA
A
HA	pA
HAQAffA=qAzA	GA(ApA
AAA AAARA
=@{@@
=@
@Q@{@ff@@=q@@p@ff@@@G@@@\)@@R@
=@(@(@R@=q@@@=q@陚@z@H@\)@(@=q@z@H@33@Ϯ@Q@@p@љ@@Ӆ@@G@  @ȣ@@z@=q@p@\)@Ӆ@@@@@@޸R@޸R@33@{@  @Q@Ӆ@@=q@R@@ff@  @(@љ@z@H@
=@@\)@߮@  @{@
=@@@{@p@  @ʏ\@\)@@Q@(@@\)@Q@z@߮@߮@  @@H@33@ָR@
@@
=@أ@ff@{@Q@@ٙ@@@\)@33@p@@ff@\)@H@33@@{@H@ff@@@ȣ@@ə@@H@{@{@Q@Ǯ@@ff@θR@p@
@ȣ@G@G@@Q@Ӆ@@ff@
@\)@
=@@@=q@\@z@(@p@  @\)@\)@  @@@@@G@@
=@
=@{@ff@@p@
@p@\)@\)@@{@=q@  @@z@(@R@R@@@@G@=q@陚@陚@\)@G@陚@G@\@(@G@=q@H@R@
=@R@@@p@(@ff@
@(@
@G@z@\)@@@=q@G@(@(@ᙚ@(@Q@  @\)@@
=@{@(@z@@=q@  @H@
@{@\)@\)A (A\AAGAARA	AA=qA(AA=qAHA  A
ApA QA\A
=A
A\)A33AHAAAA z@zAG@{@G@\@33@@z@@@A
pAA{A=qA  AA\)ApAAAA(Aff@{A
Ap@z@H@p@H@p@=q@@ff@ff@@H@\)@@  @ff@@p@@@@@@{@@{@H@{@=q@\)@=q@R@=q@\)@A33A=qAAA	pA  A
AA  A=qAA
A\AQAffAHAHAA
A\A\A
=A
A\)A\AAApA
=A  AAffA
GA
A
A{A33A33AAA	A  A
RApAA\)A
AAA(AA=qARA@ff@\)AA\A @R@H@
=@33@@AH@  A\@R@R@\)@\@\@@@\)A
=AAA
\A
{AA\)A
pAA
A
A
GAQAA
AffA\)@ff@\)AA  A zA (@33@AffA AA Ap@@
@AGAAff@@=q@@@G@z@ff@p@@(@R@\)@@@@z@p@@@{@@@\)@@@(@@ff@  @ff@@@33@R@p@
=@@@H@(@@@@=q@z@=q@ff@R@@z@p@
=@@@@@@Q@p@R@@p@ff@@@G@(@@@H@
@@陚@33@(@@pA (@{A@@@@H@H@A AAA	AzAAAA
\A33A33A(A z@33A	A @33@{@p@H@33@@@@R@G@R@p@@H@=q@G@@=q@@@{@ff@z@
=@(@\@=q@@z@Q@  @G@@@@
@ff@p@  A @33@@\)@@@@R@z@AApA
A
=q@
A  Aff@ff@AA	GA
=@z@=q@@A AffA A   AffA
A	A
RApA
=A{AQAAAAzAR@A QAAA
{AR@@\)@33@@ff@
=@@p@@
@@33@@@H@\)@@@=q@\@@@\)@ff@@(@@@\)@@=q@R@@=q@G@z@@H@  @R@AA\@RAA@=q@G@p@G@A@=q@HA
=AGAQAQAffAAzAA A33AA{A	AA ApAA
A(AA
{A	A
\A
RAAA
pA\)AA=qAA\A33AffA"{A!A\)A
=AffARA$A%A#A(zA((A*{A(A#
A%A#
=A!GA QA{AGAQAAA{AA(A  A
=A
=A{AAAAA(A=qA=qApAA
=A
=AGAA{A  AffA\)A(A
=A
AHAAQA
A	AAAAA{AHA
=A
=A
ffA
HAAQAzA
=AARA\)A(A33@
=A(AG@
AffAA   @H@
=@{@zA   @@R@z@@ff@R@A Q@
=Ap@\)@@33@@@ff@R@RA z@\)A (@@R@@  @ff@
=@\@{@@33@z@@@R@=q@\@33@z@@(@@H@@
@ff@33@
@@@=q@\@\)@Q@@p@
=@\@\)@޸R@=q@
@
=@z@  @\@33@\@A A @@@
=@H@H@H@@
@
=@G@H@\)@
=@\)@A (@@p@@RA   @p@ffA QApA A@R@@\)@\)@R@
@{@R@\)@=q@陚@=q@\@(@
=@=q@  @
=@@@@ff@=q@@H@@@R@ff@{@@  @@
@\@z@@
@\)@p@
@Q@  @ff@G@@Q@33@@z@ff@  @\@33@z@R@  @@H@@z@@@@ff@  @@{AffAA @@p@@@ff@{@\@
@ff@\@@
@\@@  @@  @@@  @@
=@@
=@@Q@G@Q@@{@@H@@@@@p@(@p@\)@@@陚@H@@@陚@ff@G@z@@(@\@=q@ff@  @  @Q@ff@@G@ᙚ@
=@@ۅ@ff@
=@\)@Q@(@z@@
=@G@H@=q@Q@\)@Q@ٙ@  @\@@{@@  @@陚@ff@@@@33@G@@\)@@(@@p@=q@\)@{@  @
=@=q@H@=q@@p@G@=q@\@
=@@@=q@
=@H@
=@@H@33@@
@@@@@{@p@@\@@@(@
=@(@G@@\)@Q@
=@33@\@陚@@p@@\)@
@z@@@p@@H@ff@@@@@
=@33@\@33@@@ff@
=@
=@@@@@(@@@p@@H@\@@@z@R@(@{@{@@R@@(@@@@@@@@@=q@@
@@@(@@
=@@@  @Q@@@@\@@=q@G@@@{@G@@  @  @@{@H@@@@@Q@
=@
=@@p@G@
=@  @@\)@
@33@p@Q@(@Q@@@G@@\)@  @
=@  @G@@(@
@zA z@@@p@\)@z@33@Q@z@@R@@33@@RA   A{A\)AGA @ff@
@@  @zA=qAH@33@R@@@H@ff@@{@ff@33@G@(@G@G@@@p@z@G@@Q@Q@{@{@
=@@@p@(@z@\@33@z@@z@ff@{@33@@陚@@\@ᙚ@(@
@@@\)@Q@@
=@@陚@z@@Q@p@陚@33@@R@H@z@@A\@(@
=@@(@33@@@A ARA=qA33A A
=A (@33@33@z@=q@  @\)@\@H@@@\@=q@@@33@=q@H@G@ff@
@H@Q@=q@H@{@@  @R@G@陚@@(@@(@(@
=@@z@\)@\)@  @{@@\)@\)@
@ff@(@G@{@(@@G@G@G@@  @@=q@@33@p@z@
@@G@
@  @@G@G@@{@{@p@@R@陚@陚@@@H@
=@@@\@=q@G@H@@{@ff@H@33@33@
@@@
@@p@33@{@H@(@@33@=q@@@@@\)@@=q@G@R@R@
@@=q@@@\)@z@@{@\)@  @  @ff@p@@@{@陚@@H@G@陚@@@R@R@p@@{@@\@@G@@@33@@@R@33@@=q@33@ᙚ@߮@\)@ۅ@H@
=@@@@@(@@@@33@(@ffA\)AffAA  AffARAAAA=qAAAQAA\A
A A{AHAA @\@=q@z@{@=q@R@@z@@@@
@R@@(@
@p@(@{@H@@z@@\)@G@Q@R@H@@@@
=@z@{@@@@
=@Q@@33@@@\@@߮@{@@@ff@{@ff@p@@  @z@H@@@p@=q@H@G@@@\)@@=q@@@
=@@Q@R@Q@@=q@@@@@{@@
=@@  @@p@@\@Q@{@@  @ff@\@@@@@A (AA@R@@33@p@A
pA(A\)A AAff@@@z@33@(@@G@H@Q@陚@ff@ᙚ@H@33@@أ@У@z@p@أ@@\)@@@@Q@ᙚ@@@
@{@@@  @  @@p@@陚@G@陚@G@Q@@G@=q@=q@\@@
=@ff@@  @@@  @G@\@z@@@@@@@Q@{@(@p@z@@
@@H@\@=q@=q@@\@@@  @\)@H@@z@@@@
@  @\@
@ff@33@z@@@R@@@{@@  @@  @@=q@\)@@@  @G@33@=q@@z@Q@z@33@H@@@
@@@Q@@
@
=@33@@@Q@G@@zA   @G@z@z@QA\)AAA A QAGAAA(A=qAQAA33Az@GA(A
=A33AffApA{A@{@@@H@@H@H@@@R@@@H@{@@=q@
@
=@\@@z@
@@\@H@=q@
@33@
=@R@{@@\)@@z@@33@@\@@H@@z@{@@ff@@ff@R@  @@@=q@ff@  @\@p@RA@
=@ff@@@@\@z@H@R@z@@=q@@33@z@@H@@@@33@G@z@@(@  @@@@@33@@H@R@
=@@@@\@陚@Q@33@G@Q@
=@{@
=@@
=@\)@R@@@33@ᙚ@@@p@@G@\)@(@@H@@\@=q@Q@@@Q@Q@
=@ڏ\@
=@H@ff@G@\)@ۅ@@@ᙚ@G@@H@p@Q@Q@{@陚@R@33@@@33@\@@@@\@(@  @Q@@@@(@33@
@
@=q@=q@@\@{@
=@{@=q@33@G@G@zA
A\AGAA@
=@  @=qAH@=q@@@G@ff@G@AGA@A ApAff@Q@zA   A
=AHAAffA{A   @ff@R@A@p@=q@R@@  @G@@=q@A A@R@ff@(AG@\)@{@Q@陚@@
=@\)@@R@Q@Q@H@@@33@(@z@@ff@
=@
=@(@(@H@@
@G@(@  @@@{@陚@ff@ff@R@޸R@@߮@=q@@H@\@@@z@@@H@=q@@@@@33@{@{@˅@У@  @
@Ӆ@@z@=q@@\)@@z@޸R@p@H@=q@Q@H@@@=q@ff@  @@{@@ff@z@@
@G@@33@
@@z@@H@{@\)@=q@@Q@޸R@{@p@
=@ۅ@p@33@p@G@
@@޸R@ff@@޸R@{@z@ff@{@@ڏ\@ٙ@@@Q@p@@޸R@@(@z@@{@@\)@H@@ָR@G@(@@ָR@أ@z@z@@@  @@z@
@Q@
@ff@׮@@z@=q@G@@33@
=@ff@R@z@(@ff@
@z@@{@H@@R@
=@@(@=q@=q@\@33@@(@ff@
=@@@z@@(@p@@@陚@  @@R@
@\)A@@=q@@=q@A (@@@{AA   @=q@ff@  A  A
AHAGAAA=qA
pA
=AAA!AffA33A
AA  A33A\)AAQA
A
A\)AA\)AHA
=A	AffAAAQA\)AA
=A
\A
A\)@z@H@@@ff@H@
@33@p@33@@z@H@@Q@
@Q@H@A\)AGA
=A{A @Ap@@@@@@@@
@G@@
@
@
=@{@@RA   A @
@=qAA  AA z@A{A
HAAApAGA (A*=qA!A*ffA  A(  A&RA0QA5GA@(AAAEpA>ffA<A:HA6{A+\)A)GA&RAGA#
=A,A(AA@A33A   @p@p@pAzAAApApAQA\)AQAA
=AHARA @\)@ff@A   @
=ApAAAGA
=A   A Q@GAA=qA   @@\@@@@ff@33@ff@@  @@G@
@@ff@@\)@H@\@33@\)@AAA=qA\AAzAA{AA   AAffA   A (A A!pA#
=A%A%pA$QA%GA%A&ffA=qA=qARA=qAQAAGAAA=qAHAARA=qAzA
\A	pApAHA
=AzAApAAApA @{@R@@
=ApA@@z@H@  @@Q@
=@@G@Q@  @
@ff@@@z@ff@@33@@  @@陚@R@ff@@
=@R@(@  @p@H@{@@@@\@A zAAAA{AffA33AAzA\A(AA(A	A
HAQA
ffAAA	pAA\A\AQA33AQARAG@A@@
@pA{@@(@@H@H@@@\@@@z@z@ff@@\@33@@Q@R@(@\)@\)@@H@=q@=q@@\)@
=@@
=@ff@ff@@\@=q@@@@R@@@@@@\@R@@\)@
=@H@@\@H@{@@R@\)@@@H@G@(@z@\)@
@33@@(@@@@@@@\)@(@{@\)@
=@@(@@\)@@\)@
=@@
=@@33@{@@@
@33@z@@  @=q@=q@@\)@ff@@@
=@@\@@@\@@@@z@{@H@33@{@@@p@ff@=q@@Q@@ڏ\@ff@@
=@
@H@@@{@p@\)@\)@Q@G@
@=q@\@ff@
=@(@\)@
@(@  @@@(@{@@\)@@\@33@z@{A zA   @AApAAAHA{AAAA=qA=qA{A (A   @p@H@z@\)@@@
@p@z@p@R@
=@Q@Q@R@@p@(@H@33@@\)@Q@R@\)@G@
=@R@p@z@@@{@@ff@H@@Q@
@@H@@@ff@z@p@@@ff@R@R@
@ff@\@@@Q@\@\)@@pA @p@{@\@G@H@@\)@@@Q@Q@z@Q@{@@p@@RA (A   A{A{AAzAA\A(A A @R@(@(@@@@陚@
=@H@@ff@
=@  @ff@陚@\)@  @p@@@33@33@\@
@@=q@33@@@z@@\@
@
@p@(@\)@
@@H@@{@
=@@\)@
@أ@޸R@z@@ff@@陚@\@G@@
@@@p@\@@ff@33@G@
=@@p@Q@G@\)@ff@
=@@@p@=q@p@ff@\)@z@{@@@Q@(@@R@@
=@
@
=@p@33@33@@H@33@(@Q@=q@@@R@
@H@p@\@z@@@
=@陚@p@33@@G@R@\)@\)@@ff@@
@ᙚ@\@@  @
=@@  @@G@@p@@ᙚ@ff@ᙚ@=q@H@33@p@
=@  @@߮@G@G@\@@@p@@z@@G@@  @G@=q@@@@@@@@33@@(@@@  @@Q@@  @@
=@ff@\@Q@=q@@@R@  @R@@
=@\@@z@@33@
@
@33@@@@@@G@Q@@=q@@  @ᙚ@
=@G@33@@(@\@ᙚ@@33@@H@G@ڏ\@@ۅ@\)@
=@ָR@  @
=@z@G@Q@H@{@=q@@z@G@
@@ff@ff@@H@
=@@@@@  @=q@@@R@@@@@33@ff@A  @A=qA
AffAGA	GAQApAGAAGA\AAAAAApA AGAH@R@p@p@
@p@@{@@
@Q@@@
@@@@  @
@@@H@@R@\)@
@@
=@
=@=q@z@H@=q@@z@@R@p@R@33@=q@ᙚ@
=@H@
@Q@陚@=q@
@=q@H@G@33@R@@(@@33@\A\)AffAQAAA  A33A
A
ARAA
GAA=qAHA{A33A\)A	A(A@AGARAAA A  ARA33AHA zAA (@z@G@Q@ff@@H@
@@Q@p@@Q@  @@
=@33@(@@@p@p@p@z@
@z@@{@@H@33@@z@@@G@H@@z@Q@R@
@=q@R@p@@p@
=@p@z@=q@(@\@@=q@R@z@@R@@H@Q@z@@(@
=@@
@@p@\@@@@\)@@@G@@33@@{@@@ff@
@
=@\A @\)@@z@{@
@@  @@33@\)@ApARAAA{A{AAAARA(ARA\)AA
=AA
AAAAzARA AAAAA33AAHA  @
@(@@A AAA z@H@z@@HA A QAHA=qA\ARAffA
=AzAQA	A
A
=A(AGAA(ARA33A{ARAHA
=ARAffApAAAQAQAA	AA\AQA33A	A
pAffAA33A33A\AA
pA
A
A
{A	A(A
=AAA	AAHAAQAQARAGAGAARAGAAzA
A\ApApARAA	GA\)AAHAA	pAA
=AHA=qAAA33AApA@@\@G@@
=@@@A=q@@Q@\)@ff@G@@@Q@@ff@
=@z@p@\@@(@@@z@
=@33@\A@A A   AGAAHA33A@p@G@33@pA  AA Q@
=A AHAAARAAAR@R@HA	GA
AAAzAzA	AAAQAA A
=@(@\)@Q@
=@G@
@@
@pAff@R@@=q@\@H@G@G@@33@H@{@=qAA
=A33@{@@@
=@@\@H@@
@p@@@\@H@@@\@  @=q@33@@@\)@
=@
=@@
=@@  @R@R@z@ffA A   @p@R@@R@@@z@@@AffA QA @
@Q@(ARAA\)A
RA  A\)AAAffAA(AQAzA  AAA  A   ApA	A
GAzAQApAQAQAHA
A{A33A=qA=qAARA=qAA  AAAQA\)A
=A	GA
HA	GAQA33A
ffA	A(A
{AAAAA @Q@@@zApAzAA\AAGA
=AzA\)@@R@@ff@@@@@QA{A
AA\A=q@@@(@\)AA (A\)A{AffApAGAGA@@\)@\A   A (@{@=q@@p@G@Q@Q@\@@
@p@Q@@\)@@
=A A @
=@33@(@
@33@@{@G@@@
@p@
=@@\)@{@\)@{@(@@@@@@  @Q@{A{A (@R@(@z@{@p@p@G@\)@@Q@  @@z@ff@=q@@R@@@\@R@Q@=q@  @R@=q@@H@p@@{@\@@Q@z@@@{@\@@G@\@@=q@H@(@ff@\)@(@
=@ff@ff@@@@@\)@ff@@@@  @@  @G@@H@@@p@@z@߮@  @陚@@z@\@(@G@{A=qA33AH@{AHApA{A@ff@@G@H@\@\)@\@(@p@33@
@ff@@H@33@\)AAARAHA\)ApA Q@  @@(@\@@ff@z@@(@陚@@@@@@@@G@p@@z@@@z@@ٙ@׮@@
=@\)@@{@@@Q@\)@
=@(@(@Q@(@(@@(@G@R@@@  @pA@@{ARA QA@{A
=AAGAA=qA{A  ApA
{AAA'
=A.{A2ffA/
A1A0  A+\)A(zA(QA'
=A(QA!pA@Aff@z@
=AQAHAHAA AGA ApA A A A (A A   @RAp@{A AffAA33A (A ApAA AAA (A A
=A=qAHA@ff@@@\@@A QAffAA\A
HAAA
@RA
\A(ApA
AffA{A
=A-A,A3A>\A0QA8A9A$QA=AEAQAZRAQAG\)A=AXA#ApA\)AA/\)AA	pA	AAAAG\)AffAAffA\)AC
=A5A.\A
=A\)AA
HAGARAA\A
AffAzAQAA
pA\AA
RA
AzAzA	pA
=AAAzA	A	A
HA=qAA{A@@\)AA
@A Q@HAG@@@33A AQA
=qA
AAA\A(AA#A&=qA'\)A{A{A&HAAA
=A:HA*{AD(AEpA733A9AK
=ACAJHAK
AAA\)@@33A
AzAAA\)A	AAA
=AAffA\)A
A@
=AA\)AQA  A	pA
HA=qA{@A=qA
=A	GA\@ffA @A(A(A@@
=@A
=A\A
ffA
AAA
AzAQA(A
A33A(ARA	A	A(A\A
=A\)AHA  A
A\)AGAzAQAAAAAQAffAAzAffA (A%pA,A2ffA1A5A4A8  A:HA?33A@zA5A	A
=qA=qAA\)AQApAA
pA=qAHARA!pA0A#33A$QARA{A
=A\AGAAAA
=A(A!pApAA\)AQA
A%AA33AGA\A
A
ffA{AAARAffAQA  AA(AAAffA
RAApAAAApA  AAHAHA	A33A\A\AA!pAQA{AAGA
A(A(A=qAAA  AAA0(A4zA3A-pA2RAA7\)A;
ADQA8(A#
=A(A\)A
=qA
AAA{AQAffAffA33AAAHA
RA(AzAARA@pAA QAA
AHA
A=qAzA	AQA(A{A(A(A
AQAQA\)AGAAA  A
{AA{AffAA33ApAAA
AffA(@ApA@pAAGA33A	AARARAA AA\)A
A\)AA{AzA
A=qA
=ARA
AAA A"ffAA$zA,A QA)A=GA(AAIGAJHAC
A1GARA
=A{AGA  AAA
=qAffAAQAA33AzApAAA"=qARApA
A!GA!AAA (A
A
A(A\AA	AGA @
@HA QAA	GAA  AGAzAA
=qA\AHA   A @{@33@@@@@@  @@@33@@@
=@@z@(@RA AA(AAA33AA
AA
\A
A!pAA#\)A+\)A*HA (A-A+A/
A5A
@\)@@@\A  A
@
=@@RAA zA{A
=AAA{AA\A\)A
A
AAffAA\)A(A{AApA\)A{AA\A
=qA\A=qA A A @
=@ff@33@Q@@@
=@QAGA Q@\@A @@@\@Q@
=@G@=q@@陚@@@@H@
=@p@=q@
@@AApAA	GAz@AA
=A @
A  A	pAApA#\)A"RA%A"=qA!A$QA$  A%A*{A'
A)A)pA(A(A'\)ARA!A\)AAAAAAA  AAA	A	GA	pA33AA
=qAA33Aff@=q@H@@z@p@
=@\)@{@@(@Q@ff@ff@(@@33@(@R@AA (@@\@@zA @(@@@33@@Q@@@@@  @@
@G@@@{A{@
=AAAzAAA\AffAAffA  AQA\A(A33A\)AQAGA\)AA
AA
AQA
HA
=A	A\)@ff@zA (A (A zA AA @ffAffA=qAA=qA\@
=ApA\AffA=qApAAAA@{@ff@\A @@@  @G@G@@33@=q@@H@@z@@G@G@
=@R@ff@@陚@p@\@
@p@@Q@\)@p@R@
=@@H@\)@33@@{@p@@G@  @@@R@@陚@@@\@@  @G@=q@R@@p@@{@Q@@p@ApA\)AA@
=@H@H@p@(@z@\@(@@@@Q@@@=q@@@\)@@\)@@
@R@ff@ff@\@
=@  @  @@G@G@G@=q@
=@G@\)@@@  @@@@
@G@@ff@R@\)A33@\@33@@A\AA@
=A @{@AA\)AQAAQA\AAA33A
=A  A
A	pA  AAA A=qA A AA{AA\)A=qA\AA  ARAHA	A	A{A\)AA\AGA	AHAAHAA33A@{@ff@A A Q@@z@ff@  @H@陚@=q@{@z@G@\)@@@@(@R@@H@=q@z@@@@@@z@z@H@\)@
@ff@\)@@@(@H@陚@\)@@  @@@  @(@R@Q@z@z@(@H@33@33@@R@(@(@{@R@@@=q@\@=q@ff@  @A A\AAQA	A
A=qA{A
A
AA
AA
A	GAQAAA=qA\)AA
{A
RAA
\A(A
A  AA
GA  AAA33A
\A	GA\)AAARApAAzAHA zAA   A=qA   A@\)A @z@@
=AG@@\)A=q@33@p@A (@
=A\)AQA\AG@@A @ff@z@z@
=@A AQA   @\)A (AARAA\)A
=A\A A QA\AAAQAAA33A\)AA33A
AA=qA  AGAA A A A QAA Q@zAG@\)@p@G@@z@@@  @
=@@  @@@{@z@@@
@@@@z@R@{@@  @
=@@z@R@@z@H@\@@@p@Q@\)ApA\)A   @@{@
=@A Q@@{@@zA AA=q@@\@A@RA
=@(AAGA zA (AG@@
A AAAAA33A=q@  @  @33@{@@\@\)@{@@(@\@
=@ff@G@  @H@{@@(@G@\)@@z@@R@{@@
@R@@  @=q@p@R@ff@@@(@p@{A QApA=qAAQA=q@H@@@Q@  @
@A\A33@A zA zAA@zAA zAGA{A33AHA=qAAHAAARA A\)AQA	A	pA	AGA=qARAGA (ApAAAA{AAGA{@ff@
=@@z@pA@{@@
@@R@@{AG@\@p@H@{@
=@@
=@@
@p@
@{@R@@33@@  @@{@Q@@\@{@ff@p@@@@H@@
@ڏ\@@ff@@{@H@p@(@\@(@33@ff@@@H@@R@\)@ff@
=AApA (@A@zA Q@R@
A zAA (@33A   A=qARA (AA@
=A33AA (A{@RA QAQA\AGAHAQAffA\)AAA@z@\)@33@@p@H@@{@@\)A@@33@@\)@G@@@@z@{@33@33@\)@=q@R@33@33@@@(@@
@@z@
@\@G@@p@G@@Ӆ@@@G@(@
=@׮@{@G@@@p@@33@R@p@ff@RAA AA @ff@\)@p@A zAHAA\A{AAffAA\)A33AAAp@zA33A\)A   @@
=A   Aff@(A{A@@@@@H@  @z@\@@@33@G@
@{@R@@@ff@@Q@@\)@@\@@@ff@\)@
@33@33@p@@ff@z@z@@\@R@R@
@@=q@@@(@  @H@@(@z@A ApA A{ARA  A\A\)A  AA\A(AA	A  AA33A(A
A(AA
=A	AzAApA33AA
A
=A
=A=qA33A
RA	A\A  A
=AAAA{AAAAAAApAAA{ARA{AG@\)@
=@R@=q@G@33@\@(@@@陚@@@
=@@H@  @@@
=@33@H@=q@R@33@HA (@\)A@A@(@@@{@@@@@(@33@{@Q@33@H@{AA@@@RA   @{@ffA   @
=@ff@33@(@(@(@\@=q@@@G@\@@@
@@@33@@@@Q@ff@@@@(@@R@p@@@R@{@z@\)@\)@{@@(@(@z@  @\@H@33@@(@
@=q@H@\@z@{@
@p@R@33@33@@=q@{@\@@p@33@R@R@(@{@\)@@@z@@@@@@R@
=@
=A (A QA AAA A A A (@ff@@ff@@@
@33@H@H@H@z@
=@@H@\)@{@{@@ff@\)@@@ff@
=@R@ff@ff@G@@@  @H@{@\)@Q@p@R@\)@H@@@33@H@z@33@@z@@@@=q@\@@陚@@\@@@p@@
@@z@@@@=q@@@R@(@@@@@33@(@@33@\)@Q@G@33@@@33@
@
=@\@z@@{@{@(@p@p@@Q@  @
@33@z@33@
@@@
@G@z@\@=q@H@
@=q@G@
@@H@G@@陚@H@@  @Q@H@(@(@z@\)@  @z@@=q@H@\)@(@@z@@=q@\)@@H@
@{@Q@
@\@p@=q@z@@@
@(@33@R@(@R@Q@
=@@@\)@z@@@z@@=q@
@
@@@p@@@@=q@p@
=@@R@  @R@A   @ffA A\ApAAAHAHA
=AAA=qA=qA Q@@\)A@@
=A (AAAA=qARA\@\)AzA	A(@\)@
=@ffA A
=AzAAHA zARAApAA
AA{A Q@
=@ff@A A=q@@ffAA@(A
AHA	GA\)A	GA	GAQA zAHA  AA	A\)AA (A@RA{A{A@
=A (@@
=@AA @\)@@33@ff@  @@=q@\@@=q@@@ApAA Q@R@H@A\A\A@\)@RA AA\ARAAffA\)@@z@R@@Q@z@=q@
=@{@\)@H@R@R@{AApAG@{@33A @ff@p@(@@\)@A (AQAA{AQA\@
@@@@\)@@@p@{A   @A (@@H@(@@A   A AAA A\)A@@@p@@=q@p@=q@z@@@@p@p@@=q@@H@@@G@@R@\@@
=@
@@@@@@{@{@z@Q@\)@@ff@G@\)@@@
=@(@(@\)@\)@A AA @p@ff@z@@
@@
@p@(@z@(@p@{@
=@(@
=@Q@@  @  @  @G@
=@ff@
@@Q@=q@  @@33@  @  @@Q@Q@\)@33@@p@=q@=q@\@@H@\@=q@أ@p@ᙚ@
=@@@\)@z@
=@p@@G@陚@
@{@{@@p@@@(@p@陚@@@Q@@@Q@@@(@(@p@@
=@33@=q@(@  @R@\)@R@\)@ff@  @@@33@@R@  @\@(@@\)@Q@@Q@
=@\)@
@@H@
@@@\@(@R@@R@
=@=q@
@@33@G@أ@أ@=q@\)@z@33@G@G@
@H@陚@H@@p@@p@33@@陚@陚@H@G@=q@Q@33@@
@G@@@p@Q@@\)@陚@@  @G@  @{@Q@陚@p@@@  @H@33@(@p@ff@@  @@\@(@H@@{@@ff@@ff@p@\)@@ff@@@H@@  @@p@z@  @@@  @ff@z@33@@@{@
=@R@@R@p@@@@G@@@R@@Q@=q@@33@@(@@@@\@(@33@@߮@
@
@z@
=@
=@R@R@@\@ᙚ@ڏ\@ff@H@\)@@=q@@  @\)@  @@陚@=q@(@{@z@@@@33@ff@H@@=q@@Q@ff@Q@@z@@z@\)@@
@@@
=@\)@33@@{@@@\@@G@@  @z@@z@Q@@@
@߮@ff@޸R@@陚@@  @
=@Q@(@߮@p@(@
@G@@33@ۅ@\@陚@@߮@
@@33@@@
=@@{@  @ff@@@
@(@ff@@@=q@޸R@@  @{@@p@
@33@(@z@@{@{@{@
=@  @@@(@p@@@@(@=q@33@@@\@\@
@@@@Q@@\)@@\)@{@@
=@z@z@z@@@@
@\@@
@z@
@@p@@z@p@@@@p@@R@@  @@33@@z@@=q@33@{@H@@ٙ@@G@H@=q@=q@ۅ@{@(@{@@{@޸R@߮@\@G@@@@H@
@@z@@p@p@R@@ᙚ@
=@@=q@@p@@{@@@
=@  @{@33@\@H@H@33@33@
@z@@@(@@G@@33@z@߮@p@@33@
@z@@޸R@ۅ@ٙ@ۅ@޸R@Q@أ@ۅ@Q@@Ӆ@=q@@
=@
=@@
@@ff@ff@߮@
=@p@ff@\)@Q@߮@{@@p@@
@@p@ff@ff@
@@Q@  @׮@@@\)@߮@ۅ@{@
@ٙ@@33@  @@޸R@Q@@ᙚ@޸R@޸R@߮@Q@33@@H@\)@R@@H@
@@33@\@@33@H@  @H@\@33@H@H@=q@\@@@\@=q@R@z@\@  @
=@@33@33@=q@H@
=@@{@Q@ٙ@p@@׮@ff@@@߮@
=@z@  @=q@@@
=@=q@޸R@33@\)@G@(@G@33@z@z@{@@أ@H@@޸R@߮@ڏ\@߮@޸R@Q@ڏ\@ڏ\@H@  @  @
@
=@  @\@(@
@@33@@@\@(@@p@{@G@33@@Q@\)@R@@p@z@\)@@{@@z@z@\@\@ff@z@z@z@ᙚ@(@@  @߮@\)@@Q@߮@@G@\@@\@{@@
=@z@
@
@@@Q@׮@p@\)@  @(@@@@ᙚ@@{@ff@Q@ff@Q@z@ָR@G@@
@ff@@@  @z@\)@G@@ᙚ@@
=@@@R@@Q@陚@p@@{@=q@\@=q@33@33@
@33@
@ff@33@H@\@@G@\)@\)@z@@(@
@p@R@33@\@\@=q@
@@@  @ff@
=@@\)@  @R@\)@
=@\)@@Q@@@ff@@Q@R@@@\)@
=@G@H@ff@ff@ff@
@@@  @@@=q@33@(@33@{@
=@\)@{@@@
=@
=@
=@
=@Q@\)@Q@p@z@p@ff@@@陚@\@H@@33@\@33@H@
@G@ff@@@G@Q@\)@@ff@\)@@@@
=@33@(@
@(@(@33@@@33@\@
@(@@@@@{@
@@
=@Q@ff@R@=q@@Q@@@  @33@(@@G@@H@ᙚ@\@@\)@\)@@
=@p@{@@\)@\@ᙚ@=q@
=@
@@ٙ@@\@@=q@  @(@\@(@ff@H@@Q@Q@\)@p@{@@@{@R@@@H@
@H@G@33@@H@@(@p@@(@
=@
=@
=@
=@(@33@p@{@
=@R@z@  @33@@(@\@@H@@
@p@{@@@p@{@ff@
=@@p@@@Q@\@Q@
@
@R@\)@\)@@ff@\)@
=@Q@@=q@@33@@G@ٙ@@Q@
@߮@Q@@@\@=q@@ڏ\@(@{@޸R@\)@ᙚ@G@@\)@\@  @G@H@
@33@z@@R@\@@R@H@Q@@@G@@@@\@H@@R@  @R@p@
@(@\)@{@@@@  @{@{@@33@z@\@陚@@=q@{@Q@陚@
=@@G@G@{@@ff@@@Q@p@@Q@\)@R@ᙚ@@33@z@@@@{@@@\@G@  @{@@=q@@Q@@{@z@{@@@33@@H@33@  @@陚@G@=q@@=q@\)@\@@@@ff@R@@@Q@@@@=q@=q@@@z@
@
@33@@
@p@R@@@(@33@\@\@H@=q@@\@G@Q@@G@G@=q@  @p@ᙚ@(@z@@߮@33@@ᙚ@G@  @Q@Q@ᙚ@@=q@=q@H@z@ᙚ@@p@H@@@@\)@\@\)@p@@z@@z@z@R@
=@  @G@H@@=q@(@p@R@p@@@G@z@R@ff@R@{@Q@@陚@=q@=q@@陚@@陚@\@=q@陚@@@G@@@R@ff@G@Q@
@@@@(@@@@\@\@\@H@\@@z@R@p@@ff@@z@
@@(@
@=q@@@=q@\@H@@33@H@H@33@陚@陚@@@R@
=@
=@Q@Q@=q@  @G@=q@\@Q@@\@ᙚ@@޸R@߮@  @@=q@z@@
@33@33@33@@@
@z@
=@@G@@Q@@\@@@@@@@@@G@@@@@H@33@@Q@G@@Q@Q@\)@@{@@@陚@@@\)@\)@Q@G@陚@@H@H@@@p@@ᙚ@@Q@@  @z@H@\@@陚@@@@\@ff@G@@(@=q@\@R@z@(@@z@(@Q@@(@@33@@  @33@H@H@33@Q@@(@@\@\@33@
@z@@p@p@p@{@
=@\)@
=@ff@R@R@@
=@{@z@H@\@@G@\@\@G@@H@\@  @@@@
=@\)@@@@{@@@G@Q@  @@p@33@@@陚@@陚@H@G@\)@\)@Q@@{@@(@ᙚ@@z@G@{@
@=q@{@R@\)@\)@@
=@@@@
=@Q@  @G@@33@
@(@@
@z@@R@H@33@@(@p@@@ff@@G@@@Q@@  @@
=@ff@
=@  @
=@R@@z@p@=q@@  @@@\@@=q@@Q@Q@\)@R@{@@H@
@33@Q@߮@@@@\)@ڏ\@ٙ@
=@ۅ@@p@@@@@@@G@p@  @߮@
@\)@{@\@陚@(@
=@33@R@@@z@p@Q@陚@@\@33@@
@@ff@\@G@=q@33@@{@p@
@@R@R@@\)@=q@p@@
@33@@G@@H@\@@Q@@H@@@
=@(@@@@ff@33@
@33@@@{@p@\@@@@z@@@Q@\)@@@\@H@陚@\@  @Q@G@(@z@  @
@R@
=@Q@\@33@Q@@33@33@Q@@
=@{@{@@{@(@(@
@@@@
=@  @H@@ۅ@33@z@@p@@
=@@@  @G@
=@@\)@޸R@33@Q@=q@@R@\@p@=q@(@{@{@@ff@(@Q@p@R@33@AG@@(@  @陚@p@@
@R@@33@@
@\)@p@@  @G@{@@
@z@
@  @Q@@(@R@  @@  @z@Q@陚@
@z@\@@AQA @\AG@@\)@@{@@Q@=q@{@
@{@\@33@@
=@{@@@H@H@z@ff@
@@R@=q@G@Q@陚@@@@@ff@(@(@(@\)@p@{@{@Q@
@H@33@@G@@ٙ@z@33@G@=q@@ᙚ@p@
=@33@H@@  @
=@@@ff@@R@@@=q@=q@(@@=q@@@33@@@
@33@@@ff@
=@@=q@@@@p@@ff@@G@H@@=q@=q@  @@
=@=q@@\)@R@{@@G@R@p@@@=q@@{@
=@@p@z@(@{@@@Q@p@\)@(@(@{@@
=@@@ff@H@陚@@Q@=q@@@p@@H@33@\@Q@R@\@@  @@@@z@@@{@\)@Q@@Q@G@=q@33@z@H@  @p@p@@{@R@@  @
@z@{@p@ff@Q@z@H@@@z@Q@
@H@{@(@@@=q@z@Q@
@p@\)@\)@(@@(@
=@
=@@z@@
=@@@@
=@@33@@p@33@@
=@ff@\)@@@@@33@
@G@{@@@33@@@G@33@\@ff@Q@H@(@=q@@  @@@AzApAA33A@ff@{@ff@
=@@\)@R@G@H@@=q@H@G@p@  @@@=q@@\)@@(@R@@R@@  @=q@@@
@=q@@{@@Q@@@
=@@@
@H@
@@(@R@R@@G@  @G@
@@\@@@(@  @@\)@Q@  @
@  @
@H@
@ff@@{@p@ff@{@@\)@ff@(@@
=@z@\)A Q@{@@=q@(@z@{@{@{@@p@@@zApA (@RA @\)@@{@p@@A=qA zA zA (@\)@
@@
=@@  @H@@  @=q@@@@
@@  @G@G@@R@\@H@(@  @@=q@Q@R@
@p@\@ff@@@@\)@@@\)@ff@  @z@Q@{@@ff@
=@ff@{@
@Q@33@R@
=@
=@R@@@
@@ff@R@@@ff@@33@Q@@(@@
=@@33@Q@R@R@{@p@
=@@z@@\)@Q@陚@@@ff@=q@ff@\)@@@\)@@  @Q@@Q@
@@\)@\)@Q@R@ff@G@@z@ff@\@@\)@ff@=q@p@޸R@  @G@(@z@
=@\)@@33@H@@ᙚ@@@=q@ᙚ@ff@Q@@
=@Q@  @\)@Q@@@{@\)@p@@陚@=q@陚@@@\)@陚@Q@@@(@{@{@ff@{@@p@@@33@\@{@@@=q@H@(@
@@=q@@
@33@@=q@\@@@@
=@Q@H@
@{@=q@@
=@
=@@ff@@@@
=@Q@R@@p@p@@33@z@\@@\)@@33@@{@@
@\@@ff@@
@z@@@Q@H@R@A   @RA A z@@R@
=@  @@Q@@  @  @p@z@H@H@@@p@@p@{@{@@R@@@Q@33@H@\@Q@@p@p@\)@(@\)@@p@(@\)@@@\)@\@R@Q@@Q@
=@z@G@H@(@@A zApARA{A @@@R@@@{@G@33@@z@ff@
@{@@G@@H@@H@@
@p@p@@ff@@
@AA
=A=q@H@(@@p@@{@z@p@@  @\)@@@zA@{A\ARA@A AGA Q@ff@{@@
=@
@
@@@\@@p@\A (A   A AHAA(A   A@ff@G@ffAA@RA33A{A\A{@ffA (@A@
=A zA AA33AAzAA\)ARAGAA zA\)AAGA=qAHAHAzA{AAA
\AA
AA\A
ARA\)A
ARAGAA(AA\)AQAAGAzA  A\)AAA(A=qAAHAAAApAAA
AAA=qAzAAHA  ARARAA\AA(A\)A  A=qA=qA(A\)AQAffA\AffA{AAA(A
GA
GAffAA
\A(AA  AQA33AA
=A
A
{AA33AQApA A @ffA{AAAHApAA=qAA=qAA(AQA=qA33ARA\)A(AHAffARA33A33A(AA
AQA\A=qA (AffA A%pA%A$QA$QA$zA+\)A-A/A+
A'\)A$zA%GA#
A,A*RA*RA*=qA'A&=qA%A$zA!A QA!A (ARA33A A
=A
AAHAAAA=qA  A
=ARAffAA(A{ApA
=A\)AARAffAA33AAzA
GAffAA=qA	pA  AzA
=A=qA
=AA{AGAG@@p@\)@@@\)A   A=q@AAAA=qAAA
ffA
A	GAzA	AAA
pA
A
A\AAAffA=qAA  A\)A	A	A	pA
ffAzA
AA  AAAzAAAA\)AGAGA
=A
=AHA	GAA
{A(A
HAAQAA@  A QA  A	AA(AQApAffAQAAA Q@=q@R@Q@@ff@@陚@@{A (@Q@z@=q@  @\)@@Q@@@\@\@@ff@
@  @\)@Q@
=@
@@p@@
@ff@{@
=A   @
@@@p@@陚@A33A{@@  @@@
@H@{@=q@@
ARAHARA33@zA=qAAAAGA33A  A=q@z@@\)@  @@@@(@H@H@@ff@@@@@Q@\@@33@{@\@
=A @@p@
@\)@
@@  @\@@@R@H@H@z@=q@ٙ@@ڏ\@@p@  @z@
@\)@H@33@G@@Q@{@@
=@H@33@@33@  @p@G@@=q@z@@\)@  @\)@G@@@=q@@ᙚ@\)@33@H@z@\)@@@@ᙚ@\@H@@G@@(@{@
=@H@H@Ӆ@@(@  @@@p@ҏ\@ָR@p@ҏ\@\)@{@@У@@
=@θR@\)@Q@33@  @33@@Q@@Ϯ@
@\)@@ʏ\@  @
@H@  @G@Ǯ@
@(@G@G@θR@У@(@\)@p@p@@H@
=@Q@׮@z@ff@
@׮@\)@p@@p@{@ָR@ָR@ff@@z@ff@ָR@׮@׮@  @@أ@p@(@\)@33@Ӆ@@ҏ\@(@@  @@
=@@{@p@ҏ\@=q@@@p@У@@Q@{@ƸR@@ƸR@
=@ff@@@@H@ʏ\@θR@(@ff@Ǯ@@@θR@ff@=q@ff@  @  @z@@G@ָR@@ƸR@(@Q@
@Q@H@@=q@Q@Ϯ@{@Q@У@Ӆ@@H@\)@\)@@@=q@Q@У@\)@(@\)@@H@Ϯ@p@@ff@z@H@أ@=q@z@ٙ@@߮@@p@@ff@  @@ff@z@\)@\@љ@@ָR@@{@@أ@@z@
@z@  @Ӆ@׮@ָR@ff@љ@\)@  @@\)@\)@Ӆ@\)@@=q@љ@Q@@H@ff@(@θR@ff@
@@(@33@
=@@p@z@H@θR@Ӆ@У@@G@{@Q@ҏ\@У@У@ʏ\@Q@33@@@θR@z@{@У@θR@G@@@ff@˅@p@Q@33@p@@z@Ӆ@p@G@{@
=@׮@z@@@@  @@=q@{@ҏ\@{@@{@ff@(@@ᙚ@H@p@33@(@ۅ@Q@Q@(@˅@У@@@Q@
=@ҏ\@ff@(@H@(@@(@33@@@
@أ@ٙ@33@  @أ@@G@@p@׮@{@H@
=@=q@љ@Q@p@{@\)@ƸR@˅@@У@p@@أ@z@ۅ@أ@\)@@\)@z@H@ָR@=q@@(@Ӆ@@=q@  @@@  @z@@ff@@@Ӆ@(@=q@ۅ@G@  @أ@z@@ff@{@Ӆ@@@\)@@@ᙚ@  @@(@ҏ\@  @Ӆ@ҏ\@
@Q@θR@H@Ӆ@=q@@@@(@@
@@{@(@Ӆ@H@Ӆ@ff@z@ڏ\@@@@z@
@  @@߮@@@@߮@޸R@ff@߮@@@H@z@
=@Ӆ@@
@Q@@أ@{@@@@ff@ff@ҏ\@H@H@33@@Q@@@@z@׮@(@(@Ӆ@(@
@z@@\)@ff@(@@@=q@\)@G@
=@׮@ָR@@@ָR@@@@(@@ʏ\@{@H@@@Ϯ@θR@Q@  @@ff@=q@{@@θR@Ϯ@θR@ȣ@G@@Q@Ϯ@@У@Ӆ@G@G@G@@Ӆ@@@
@@Q@θR@\)@G@{@\)@
@G@ʏ\@
=@@@Ϯ@Q@ָR@G@@H@H@G@z@@Q@(@z@p@p@ff@ָR@{@Q@أ@ٙ@ٙ@ڏ\@33@  @  @  @ᙚ@
@(@@@@@
@\)@Q@ff@H@33@z@G@@޸R@޸R@@@ə@@\)@  @ff@@G@G@@  @@{@Q@\)@  @  @߮@߮@߮@
=@{@p@ۅ@Q@{@ff@\)@=q@H@z@(@z@ҏ\@\)@@@׮@  @
=@{@p@@33@@׮@@@
=@G@ڏ\@z@˅@=q@p@ʏ\@
@ff@33@@ᙚ@@H@\@@\@\@H@=q@=q@=q@ᙚ@R@ff@@@z@@p@@\)@G@Q@  @\)@@  @@  @{@
=@@@@ۅ@@ۅ@
@@Q@@ff@@G@@G@˅@=q@z@@@Q@Q@33@@@ff@
@ff@  @33@ff@  @У@(@
=@=q@У@
=@@@
@θR@љ@(@H@ҏ\@33@@\)@У@ff@Q@G@
@(@(@@@ff@@
=@ff@  @=q@\@ᙚ@@@p@  @H@H@@z@@33@
@
@z@33@@@z@@33@33@@޸R@@
=@G@@
@޸R@@H@(@Q@G@ᙚ@
@ۅ@{@@׮@\)@
=@(@(@
@@أ@ۅ@ۅ@ڏ\@@(@У@У@Q@ʏ\@@\)@@G@{@\)@@Ϯ@33@H@=q@H@@@{@޸R@߮@p@Q@
@@\)@޸R@z@׮@  @@(@ڏ\@G@@H@z@@  @  @G@@ᙚ@\@=q@(@
@@z@@@(@H@H@\@H@H@ᙚ@@@Q@߮@Q@@=q@@z@\)@@
@H@\@@G@  @\)@p@\)@  @ff@ᙚ@{@  @@G@G@@@@(@@p@  @ָR@ָR@@\)@@׮@ۅ@ٙ@ٙ@(@ۅ@33@33@ff@љ@@z@p@  @߮@  @߮@@\)@޸R@=q@߮@\)@@=q@@@33@33@(@p@
@(@@{@R@\)@@@@ff@{@p@ff@p@ff@z@\)@{@\)@R@H@\)@@@@H@H@@@@=q@z@
@@@@{@33@ᙚ@G@@@\@@߮@(@H@@أ@@ٙ@أ@أ@Ӆ@ff@(@ȣ@@@G@=q@
=@Q@ٙ@׮@
=@ٙ@޸R@@@\)@G@z@@{@H@33@@@33@@@H@@ָR@߮@Q@Q@=q@
@@=q@ff@G@R@ff@\@Q@߮@@@@Q@AARA Q@A\)@(@
=@=q@Q@@G@ff@@
=@@@@@p@@ffA (@AffA=qAffAGA
{A	A @z@Q@z@@H@\)@\)@陚@\)@陚@@@  @  @  @z@p@{@\)@@  @@@@p@{@(@@@ff@G@@z@p@p@(@\)@(@p@33@@\)@@@@@z@@@\)@@Q@@@ff@@G@@@  @@\@\)@=q@z@@=q@ᙚ@Q@@ָR@=q@p@׮@{@љ@(@ٙ@ڏ\@z@@ff@@Q@ff@ff@  @H@@@ۅ@@@ٙ@أ@z@{@  @\)@ff@ᙚ@@\)@\)@
=@׮@  @Ϯ@Ϯ@(@@Q@H@{@߮@z@ڏ\@(@p@H@Q@ڏ\@=q@@@@@Ϯ@@Ϯ@G@H@(@@߮@@߮@@@ᙚ@\@ff@p@@@G@G@H@{@(@ff@@p@@z@@
@(@z@@H@@=q@@H@@  @@@R@R@
@=q@(@R@ff@
@z@
=@R@\@\)@p@
=@33@@@(@@(@@
@  @\)@@@ff@\@z@@\@ᙚ@\)@ff@G@\@\@Q@\)@=q@=q@@@ff@
=@@@@@@G@
=@R@@ff@\)@=q@=q@\@H@33@=q@33@33@=q@H@@\@@=q@\@@{@@@ff@{@@  @{@R@ff@
@(@\@@@G@  @
=@@H@@G@G@G@=q@陚@@Q@@@R@Q@  @
=@p@{@@@{@
@ᙚ@@@33@H@\@=q@(@ff@@(@z@(@{@{@@ᙚ@  @߮@߮@G@Q@=q@z@{@@@@\)@ff@\)@
=@\@@p@33@33@(@@(@Q@ᙚ@߮@\@@
=@\)@33@=q@(@G@H@p@z@\)@ff@ff@{@
@@@R@Q@@z@z@Q@{@R@{@\)@陚@  @
=@@G@
=@@@33@=q@\@ᙚ@  @@  @G@H@\@@@@(@=q@
@@z@ᙚ@
=@  @G@ڏ\@ff@޸R@  @\)@@\)@p@@p@ff@p@\)@(@z@ff@߮@
=@
=@@  @Q@Q@@@
@@
=@@@z@@H@@p@H@陚@z@\@H@
@33@@@  @@\@R@@陚@\@ff@R@ff@z@(@p@@G@=q@@=q@=q@ᙚ@ᙚ@33@H@@ᙚ@ᙚ@\@H@H@\@=q@ᙚ@߮@z@޸R@@޸R@p@33@@@ٙ@޸R@\@@z@@ff@@ff@Q@  @  @ᙚ@@ff@{@(@أ@{@Q@
@(@ٙ@@޸R@߮@  @  @@@=q@\@
@z@z@p@
@@@@33@G@ff@@@  @R@@
=@@@H@33@@@  @
=@G@@@{@=q@Q@=q@33@@p@(@(@{@@陚@陚@@Q@@  @Q@\)@\)@\)@
=@\)@@@(@=q@@@H@陚@33@@@@@ff@R@陚@
@{@  @(@@=q@z@{@
@\@@@(@@\@
@\@ff@H@
=@G@(@H@陚@@{@Q@p@z@@  @陚@H@@p@z@z@@@  @Q@=q@@@33@\@G@Q@@  @G@@\)@ff@H@=q@=q@@z@
@\)@  @@@  @@H@@ff@ff@z@Q@@@
=@z@Q@33@\@@@@33@H@ff@@@ff@H@H@z@@H@@ff@
=@
@(@{@@p@@{@
=@@z@
@@Q@@(@
@@{@@@@@@z@Q@R@@p@@@(@@@
=@{@
=@p@Q@{@@  @\@ff@R@p@@\)@@@(@{@@@@  @\)@H@@@=q@@@z@H@\)@@\@Q@G@  @R@@  @33@H@@R@@@
=@33@@z@R@H@(@@  @{@
=@R@
@@@p@\)@ff@{@@=q@\)@陚@p@\)@G@@@@H@@\@\@
@\@  @=q@@@{@
=@R@p@\)@=q@@@33@@=q@
@@z@@Q@@@G@G@H@Q@=q@33@ff@{@
=@  @H@G@@G@z@陚@R@G@@=q@@
@G@\@@G@\)@{@Q@z@@\@33@z@G@@@
=@@@G@p@ff@@@@
@@{@R@\)@{@{@{@@@陚@H@陚@  @ff@\@\@R@H@
@=q@@Q@@  @
@ff@\@  @(@{@Q@@
@p@߮@@R@
=@  @(@p@Q@G@33@@p@@{@H@{@ff@G@Q@@\@@Q@H@\@@@  @@
=@@\)@G@H@33@R@p@
@@p@@=q@@@(@z@(@{@@p@33@p@(@@  @@@H@G@H@@@@\)@{@z@R@
@R@=q@@
=@ff@\)@ff@
@
@\@
=@ff@@@@{@(@@@
@=q@H@
=@@ff@z@@@@\@@H@(@  @G@
=@@H@  @Q@ff@H@ff@@(@ff@G@陚@ff@{@@@
=@@@G@(@p@@z@p@{@\)@@{@@@
=@ff@(@
=@@\)@\)@
=@z@@@
=@陚@ff@{@@Q@G@
=@أ@޸R@{@R@@@33@
=@ۅ@أ@@\)@ٙ@ڏ\@\)@@޸R@R@
@@\)@(@ڏ\@33@p@@{@߮@H@z@@33@ۅ@ۅ@Q@(@@ҏ\@޸R@޸R@
=@p@G@G@@ۅ@z@޸R@=q@H@
@@ҏ\@׮@@  @@@@@@  BBBBffBffB33B  BBy BB33BBBBB  BB  BffBB  BBy y BBB  B33BffBffB33BffBBffBffBBBBBB  BffBB33B  BffBB33BffB33B  BBBBBB  BB  BB  BffBffB  B33B33B33B  B  B  BBB  B  B  BBffBffBBB33BBffBBBffBșy B33BǙBəy B  B  BBffBBffBΙBffBΙBffBΙB  B  B͙B33B33BəB  BffB33B̙B33B33BęBffBBʙB˙BffBǙBffB33B  BřB33B  BBBBBffB  BBffBffB  B33B33y y BB33BB33B33B33BBBBBÙBB  B  BÙB  B33BBffBffB  BB  BƙBffBffB33BffBffBəB  B  B  B  B̙B  BљBffBΙB33BffBffB  BЙB33Bffy y B33BffBffBřBffB  BBffB  B33BffBBBffB  B  BB33B  B33BBB33B  B  B33BffBB33B33B  B33BÙB  B33B33B33BBBřB33BB  BffB33BƙBffBBBBəBffBBB͙B  B33BBBBϙB  BffB  BϙB33BϙBffB  BBΙBBffB  B33B͙BB33B  B  B  B  B  BBffB  BBB̙B  B̙B33BffB33B33BffBffBffBșBBffB  BffBBB33BffB  B33BBB33B  BffBB  BǙB  B33BffBB33B33BBffBBřBBƙBffBffBəB˙B̙BB33BffBffB̙BffBffBffB33BffBffBBffBBB33B33BffB  B  BЙB  BљB  BЙBЙB33BffBBB  B  BBBffBffBffB  BB33BffBB33B̙B͙BffB˙B33BBffBB33B33Bffy BǙBʙB33B˙BB33B  B  B  B33BB  BǙB  B33BBffy     y y y BffB33BҙBB  B  BffBљBffBffBffB33BB33BB  BffB33BB  BffB33BB  B˙BffBB  B33BB  BBřB  BǙBBǙBęBffBffB33BB  B  B33BęBB  BəB  BB  BəBəB  B33B33B33B33BřBffBffBffBBBəBffBB33B33BffBǙB33BB  BB33BffBffBʙBffBB̙BffB33BffB  B33BB̙BΙB33B  BBB33B33BffB  B33BΙBЙBΙBΙBBΙB  B33B  BB  B33B33B33BЙBBB  BәB  B  BffB33B  B̙BffB̙BffB33B33BBffBB  BǙBșBffBffB33B33B  B  B33B  BffBBffB33BB33BB33B  BB33BffB33B33B  B˙B33BʙBBBB  B  BB33B  B  BB  B33BBʙBB33B  BʙB  B  B  B˙B  BffBB33B  BʙBffBffBBǙB33y BљBy y y B  By BBffBy B  y y BBB̙B33BB33BffBǙBǙBƙB  BB  BBB33BǙBəBBB33BBffB33B  BffB33BҙB33BffB֙BB  BffBؙBffB  BffB  BffBB33BBBffB33B  B  BffBЙBBffB͙BffB͙B  BffBΙBffB  B33BB  BB  y y y y y Bffy BșB˙B  y BB33Bffy BffB33BB33B33BΙB  B  BϙBffy BBy y y y y y B͙B33BBffy y y y y AQAS33A^ffA^ffA\A\A\A[33A\A[33AYAYAX  A[33AYA[33A[33A[33A\A\A\A\A\A\A\A\A[33A[33A[33A[33AYAX  ATAS33AS33ANffAK33AIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AIAIAH  AIAH  AH  AH  AH  AH  AFffAH  AH  AFffAIAIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AFffAFffAFffAFffAFffAFffAFffAH  AFffAFffAK33ATAYAYA^ffA`  A^ffA\A\A\A[33A\A\A[33A[33A\A[33A\A\A^ffA^ffA^ffA^ffA\A^ffA\A\A^ffA^ffA\A^ffA\A\A\A\A^ffA\A[33A[33AYAYATAS33ALAIAH  AH  AH  AH  AH  AH  AH  AH  AH  AIAIAH  AIAIAH  AH  AIAH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAFffAFffAH  AH  AH  AH  AFffAFffAH  AFffAFffAFffAFffAFffAFffAFffANffAS33AVffAX  AYAVffAVffAX  A[33A\A\A\A\A[33A[33A[33A[33A[33AYA[33A[33A[33A[33A\A\A\A\A\A\AYA\A\A\A\A\A\A\AYAX  AVffATAS33ANffALAH  AH  AIAH  AFffAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AH  AFffAH  AFffAH  AFffAH  AFffAFffAFffAFffAH  AH  AFffAH  AFffAFffAFffAFffAIALAP  AQANffALAP  AQAS33AP  AS33AS33AVffATAX  ATAX  A\A^ffA[33AYAYA\A[33A^ffAYA^ffA`  AYAYAYAYA[33AYAX  AYAX  AVffAS33AQAQANffAK33AH  AH  AH  AH  AIAIAH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AIAIAH  AH  AFffAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAFffAFffAFffAFffAFffAFffAFffAIAQAS33ATAVffAVffAVffAX  AYAX  A[33A\A\A\A[33A[33A[33A\A[33A\A\A[33A\A\A\A\A\A^ffA[33A[33AYAX  AVffAVffAVffATAS33AQAS33AX  ATAQAP  ANffAIAH  AH  AIAH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AIAH  AFffAH  AH  AFffAH  AH  AH  AH  AH  AH  AH  AFffAIAFffAH  AFffAH  AH  AH  AFffAFffAH  AH  AH  AFffAFffAFffAFffAH  AH  AIAK33AQAP  AP  AP  AQAQAS33AS33AVffAVffAYA\A`  A`  A`  A^ffA`  A`  A`  A`  A^ffA^ffA`  A`  A`  A^ffA^ffA`  A^ffA\A\A`  AaA`  AaA^ffA`  A`  A[33ATAP  AK33AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AIAH  AH  AH  AIAFffAIAH  AH  AH  AH  AFffAH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AFffAFffAH  AH  AFffAFffAH  AFffAFffAH  AH  AIAK33AP  AQAS33AS33ATAS33AVffAYA[33A^ffA^ffA\A\A\A\A\A\A\A[33A[33A^ffA^ffA\A[33A\A\A\A\A\A\A\A\A\A\A[33A[33AVffAS33ANffAIAH  AH  AH  AH  AH  AIAH  AIAIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AIAH  AH  AH  AFffAIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AH  AH  AH  AFffAFffAFffAFffAH  AFffAFffANffAS33AVffAYA^ffA`  A^ffA`  A^ffA\A\A\A\A\A[33A[33A\A\A\A[33A^ffA\A\A\A\A\A[33A\A\A\A\A\A^ffA\A\A[33A^ffA[33A[33AYAVffAS33AS33ANffAIAIAH  AIAH  AH  AH  AH  AIAH  AIAH  AIAH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AFffAH  AH  AH  AFffAIAH  AH  AH  AH  AH  AH  AH  AFffAH  AFffAH  AFffAH  AFffAFffAFffAIAQAS33AX  AYA\A`  A`  A^ffA^ffA\A^ffA\A\A[33A[33A[33A[33A[33A[33A[33A[33A[33A\A[33A\A\A[33A\A\A\A[33A\A\A\A[33A^ffA\AYA\AYAVffATAQALAIAIAIAIAIAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAFffAH  AH  AFffAFffAFffAFffAFffAH  AFffAH  ANffAQAVffATATAYA\A\A\A\A[33A[33A[33A[33A\A[33A[33A\A[33A[33A\A\A[33A\A\A\A\A\A^ffA\A\A\A\A\A^ffA\A\A\A\A\A\A^ffAYAS33ALAIAIAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AFffAFffAFffAFffAH  AFffAFffALAP  AVffAVffAX  AVffA\A^ffA^ffA\A[33A\A\A\A[33A[33A[33A[33A[33A[33A\A[33A\A\A[33A\A\A\A[33A[33A[33A[33A[33A\A[33A[33AYA[33A[33AYATAVffATAP  ALAIAIAH  AH  AH  AIAIAH  AFffAH  AH  AH  AH  AH  AIAH  AH  AIAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AH  AFffAH  AFffAFffAFffAH  AFffAFffAH  AH  AFffAFffAFffAFffAFffAFffAH  AK33AQAVffAYA\A\A^ffA^ffA^ffA\A\A[33A[33A\A[33A[33A[33A[33A\A\A[33A[33A[33A[33A[33A\A\A\A\A\A[33A[33A\A[33A\A[33A^ffA[33A^ffAX  ATAQANffAIAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AIAH  AIAH  AH  AFffAH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AFffAH  ALATAX  AVffAYAX  ATAX  A^ffA[33A^ffA\A\A\A[33A\A[33A[33A[33A[33A[33A[33A[33A\A\A\A[33A\A\A[33A\A^ffA\A\A\A[33A[33AYAX  AX  AX  AYAVffAS33ANffAIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AFffAH  AFffAH  AH  AFffAFffAFffAH  AH  AFffAH  AFffAFffAFffAFffAH  AH  AFffAH  AH  AH  AK33AK33ANffAP  ATATAS33AQAS33AVffA[33A[33A[33A\A\A\A\A\A\A[33A\A^ffA\A\A\A\A[33A[33A\A^ffA\A[33AYA[33A^ffA`  A^ffAYAX  ATATATAP  AK33AIAH  AIAH  AH  AH  AH  AH  AIAH  AH  AH  AIAH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AH  AIAH  AH  AH  AFffAFffAH  AH  AH  AFffAH  AFffAFffAH  AFffAFffAH  AH  AH  AIAIAK33AP  AS33ATAS33AVffAS33AQAX  A`  A^ffA^ffA\A^ffA^ffA^ffA^ffA^ffA^ffA^ffA\A^ffA[33A^ffA^ffA`  A^ffA^ffA[33A\A^ffA\A[33AYAVffAVffAX  AX  AS33ANffAK33AH  AIAH  AH  AIAIAH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AFffAFffAH  AFffAH  AFffAFffAH  AH  AIALALATAQAP  AP  AS33AVffAX  ATAX  A[33A\A`  A\A[33AYA\A^ffA^ffA^ffAYA^ffA\A[33A\A\A\A[33A[33A\A[33A[33AYAVffATAS33AP  ALAIAIAIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AIAH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AIAH  AFffAH  AH  AH  AFffAH  AH  AH  AFffAFffAH  AFffAFffAFffAFffAFffAFffAH  AFffAIAQAQATAQAQAS33AQAQAS33AS33A`  AX  ATA[33A`  A`  A^ffA^ffA\A^ffA^ffA^ffA^ffA^ffA^ffA^ffA\A\A^ffA^ffA^ffA^ffA^ffA^ffA\A[33A[33AX  ATAQAP  ALAIAIAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AFffAH  AFffAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAFffAFffAH  AH  AH  AFffAH  AH  AFffAH  AFffAFffAH  AFffAH  AFffAH  AH  AFffAFffAFffAIANffAQAX  A\A^ffA^ffA^ffA^ffA^ffA\A\A[33A[33AYA[33A[33A\A[33A[33A[33A[33A[33A[33A[33A\A[33A\A\A[33A\A\A[33A\A[33A\A\A\A[33A[33AYAS33AP  AIAIAIAH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AIAH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAFffAH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AFffAIAP  ATAVffAQAS33AS33AYA[33A`  A^ffA\A\A\A\A[33A[33AYAYA[33A[33A[33A[33A\A\A[33A\A[33A\A^ffA\A\A^ffA^ffA\A[33A[33A[33AYAVffATAQAP  ALAIAIAIAH  AH  AH  AH  AIAH  AH  AIAH  AH  AIAIAIAH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AFffAFffAH  AFffAH  AH  AH  AH  AFffAFffAFffAFffAFffAFffAFffAH  AH  AS33AQAQATAYA[33A`  A`  A\A^ffA\A[33A[33A[33AYA\A[33A\A\A\A^ffA\A\A^ffA\A^ffA^ffA^ffA^ffA^ffA[33A^ffA\A[33A[33AX  AVffATAS33AQANffAK33AIAH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AIAIAH  AH  AH  AH  AH  AIAIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AFffAH  AH  AFffAFffAFffAH  AFffAIAQAS33AS33ATAVffAYAX  A\A\A\A^ffA\A\A\A\A\A^ffA^ffA^ffA\A^ffA\A^ffA^ffA\A\A^ffA^ffA\A\A[33A[33A[33A[33AYAYAX  AVffATAP  ALAIAH  AH  AIAIAH  AH  AH  AIAH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AFffAH  AFffAH  AFffAH  AH  AFffAFffAH  AIALAQAS33AS33AS33AVffA[33A\A\A[33A\A\A\A[33A[33A[33A[33A[33A[33A[33A[33A[33A[33A\A[33A\A^ffA\A[33A[33A[33A[33A\A\A\A[33AYAX  AX  ATAS33AP  AK33AH  AH  AH  AH  AH  AH  AIAH  AIAH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AFffAH  AH  AFffAH  AFffAH  AH  AFffAH  AH  AH  AFffAH  AH  AH  AH  AH  AH  AH  AFffAH  AFffAH  AH  AH  AFffALAQAP  AP  AP  AP  AQAS33ATAYA[33A^ffA\A[33A\A[33A[33A[33A[33A[33A[33A[33A\A[33A^ffA[33A[33A[33A[33A[33A[33AYAYAVffATAS33AQAQAQAQANffALAIAH  AIAIAH  AH  AH  AIAH  AH  AH  AIAH  AFffAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AIAH  AIAH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AH  AH  AIAH  AH  AH  AH  AFffAIAH  AH  AFffAH  AH  AFffAFffAFffAFffAFffAH  AIAIALANffANffAQAQAS33AX  AVffAYA^ffA^ffA[33A[33A\A\A\A^ffA^ffA^ffA^ffA^ffA\A^ffA^ffA\A\A[33AYAYAX  AVffAVffAYATAS33AP  ALAK33AIAIAIAIAH  AH  AH  AH  AH  AH  AH  AIAH  AH  AIAIAH  AH  AH  AFffAH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AFffAH  AH  AH  AFffAH  AH  AFffAH  AH  AH  AFffAH  AH  AH  AFffAFffAH  AH  AK33ALAQATAVffA[33AX  A\A[33A\A\A\A\A[33A\A\A[33A[33A[33AYA[33A[33A[33A\A\A\A^ffA\A\A\A\A\A\A^ffA\A\A\A\A^ffA[33AYAVffAS33ANffAK33AH  AH  AH  AH  AIAIAH  AH  AH  AIAIAH  AH  AH  AIAH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AFffAH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AH  AFffAH  AH  AH  ALAP  AQAQAP  AS33ATATAVffAYA[33A\A\A\A\A\A[33A\A\A[33A[33A[33A\A[33A[33A[33A\A\A\A\A\A[33A\A\A\A[33A[33A\A[33AYA[33AYAVffAQANffAIAH  AFffAH  AH  AH  AH  AH  AH  AH  AH  AIAIAH  AH  AIAH  AH  AH  AH  AH  AH  AIAIAH  AH  AFffAH  AH  AH  AH  AFffAFffAFffAH  AH  AH  AH  AH  AFffAFffAFffAFffAH  AFffAFffAFffAFffAH  AH  AP  ATAX  A[33A`  A`  A^ffA^ffA^ffA\A^ffA\A\A\A\A\A[33A[33A[33A\A[33A\A[33A\A\A^ffA\A\A\A^ffA^ffA\A[33A[33A[33AYAX  AVffATAS33AP  ANffAIAH  AIAH  AH  AIAH  AH  AIAH  AH  AH  AH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AIAH  AH  AH  AH  AH  AH  AH  AFffAH  AFffAFffAH  AH  AH  AH  AH  AH  AFffAFffAH  AH  AH  AFffAFffAFffAFffAFffAFffAFffAH  AH  ALAP  AS33AVffAVffA[33A^ffA^ffA^ffA[33A[33A[33A[33A\A[33A\A[33A[33BffB  B33BffB  B33B33B  B33BffB  B  BB  B  BffBffB  BffB  B33BꙚB33BffBffBB33B33B33BB噚B33B  B  B33B33B  BffBffB  B33B  BffB  BffB33B33B  BffB왚B  B33BBffB  BffB癚B33B  B  BffBB  B  BB33BBffBffBffBᙚBffB33B  BޙBBffBۙBB  B33BBٙB  B33BBB33B  BB  B  BЙB  BffBϙBBBffB  B  B  B33B33B33BffBffBܙB33B33BޙB33BBB  BBffB  B33BB  B䙚B  B晚B虚B33BB  BffB虚BB  BB33B33BB  B  BߙBffBBB33BB33B  BffB  BB33BB  B33BBffB33B33B뙚BB  B33B33BҙB33BB33B33B33B33BBffBޙBBܙB33BB33B  BBBffBBffB33BܙBB33BffB噚BffB  B䙚B  B  B33BᙚBBffB33B  BBffBffB33B33BBffBB33B  B33B33BffB癚B33B虚BBffB♚BffBޙB33BBffBffBᙚBB  BߙB33BޙB  B33B33BᙚB33B33BBffBffB  B䙚BffBffB33BffBffBffBԙB  BBԙB  B33B  B33B  BBBffBB33B  B  BԙBBffB  BәBՙB33BffB33BBB33BffBB33BB33BffB33BBffBB  B33BffBB  BffB33BffBffBؙBڙB  B33BffB♚BB  BBffBffBffBffBBffBffB  BB♚BffB♚B  B33BB  BBffB33B33B33B  B  BՙBffB  BҙBBBBB  B  BޙBB㙚BffBffB33BBBffB33BB  BffB  BBBߙB33BBffBؙBBԙBBB  B33BљBffBBffB33BffBffBffB33BffBљB33B33BffBB33BffB  BffBǙBəB33B33BșBffB  BϙB  BffB  BBBBffBB  B33B虚BיBB33BBؙBBBB  BٙB  B  BffB  BBffB33BޙB33BffB  BffBffBB  B33B  BB  B  B  B33B33BܙBBffB33B  BffB  B33BB  B33BffB33B33BԙB33BffBBB˙B33BəB33BșB33B33B33B  BBBffBșBƙBÙBǙB33BBBffB33BB33BBB33BffBBBB  B33B͙B33BϙBB  BBffBffBљB  BffB33BB33B  BffB  BffB  B͙B33B  B  B33BՙB33B33B33B33BffBٙBB  B33BffBffBBBڙBۙB33B  BB  BB  BB֙BB  B33BB  B  BBәB  B  B  BљB  B33BљB  BBЙBB33BЙBffBЙBЙBffB33B33BBffB33BBffB33B33B  BffB33BЙBϙB33B33BЙB  BB33B  BffBҙBәB33BffBԙB  BՙB֙BffB  B  BffBffBB  BffBffB  BffBB33BB  BffBBffBffBffBffBB33BڙB33BٙB  BffBffB  BffB  BB  BיBҙBBљB33B  BB  B  BB33B  B33BBffB33BffB  BB  BffB  BffBffB  B  B33B̙B  BffB  B  B̙B  BffBB33BffB33B̙BffBffBffBBBffB  BB33B33BB̙BffB  BΙB  BљBB  B  BffB  B  BffBffBffBݙB33B  B33BB33B֙BffB  BۙB  B  BיB  BڙB33B33B  B  BۙBffBٙBۙBBffB33BٙBffBffBB  BffB  B33BffBՙBЙB̙B  BffBffBffBffB͙B33BB33BffBffB̙BffBBBffB  B  B  B  B  B33B͙BB33BB  BffBBBљBBBB  B  BBBәBЙB33BЙBffBЙB  B  B33BffBB33B  B֙BffBffBؙBffBffBܙBܙB  BB  B33BffBffB33BݙBBffBBffBffB癚B癚BffB癚BB晚B33B癚B33B虚BBݙBffB  BڙB  BffB33B33BיB33B33B33BܙB33BיB33B  BՙBffBB33B33B33B  B֙BԙBffBB֙BB33B  BffBffBؙB  BיBBBffBޙBffBffBיBB  BޙB33B33B33BB  B  BffB33BՙBffBffBBffB33BBffBffBB  BҙBԙB֙B  BBffB33B33B  B  BB33B  B  BffBffB33BޙBffBBBffB  BffBB癚B  BffBBB㙚B晚B33BB33B33BffBffB33BffB33B33BڙB  BיB33BBffB33B33B33BB33B  B  B33BљBBәB  BffB  B  BffB  BffBҙB  B  B  BB  BBffBB33B33BBәBՙB  BٙBffBB  BffB  B33BffB33B33B  B  BffB  B33BBffBB  CCC33CffCC! CLCfCffCfCCffCffC  C  C
fC3C
fBB33C 33B  B33B  BffB  B癚B  BB33B33BᙚBB晚B  B  B  BޙBBffB33BۙBffBffBBיB33BҙBBٙBffBؙBBBBffBBffB33B33B33B33B33B33BB33B33B33BəBffB  B  BB  B  BffBBffBffBBƙBffBffB33B̙BffBΙB33B͙BBBffBffB  BڙB  BB  B  BffBffC C  CLC	3CCLCCBBffBffBܙB  BՙB֙B  B33BffB33B  BBޙB  B33BBffB  BܙBB33B33BffBߙBB33B33BffB  BB33B  BBffB33BB  BיBB♚BB33BB  BB晚BffBݙBڙBBBBB  BBBffB33B33BffBBffB33BΙBBB33B33BB33BBǙB  BB  BB33BffBߙBffBᙚB  BBB33B  BffC BC33CfBBffBB  BB33BffBB33BffBffBffBۙBB֙B  BߙB  B33B  B33BߙBffB㙚BffBffBffB  B33B33B33BB  BBۙBB  B  BB  B33B  BffBBffBB33BәB  BB33B33BffBB33B  B  B̙BBBǙB  BʙBffB33BB33B33BB  B33B  BBϙBBϙBϙBBffB  BffBB  B33BBՙBffBәB33BB33BBՙB  B  BB33B  BBԙBffBԙBffBffBB  BffB  BԙBffBؙBffBB  BؙBBB33BיB  B33B33B  B  BBffBBBffBB33B33BffBΙB33BffB͙B  BBΙB33B33BBffB33BBB33B  BBffBB˙BB  B33BffB  BffBffB  BffB33B33B̙B  BffB33B  BffB33B33B33BB  B  BffB  BffBәBB  B33BBҙB  BәB33BB33B  BffBBBffBffBffB33BffB  BBBԙB33BffBffB  B  B33BBB  B  BҙBffBffBB33BBЙBffBЙBљB33B  BffBϙBffB33BљB33BffB  BBԙB  B  B33B  BBBҙB33B  BB  BffB  B33BffB33B  BB  B33BBffBǙB  B  BffBؙB33BߙB  B33BB  BBڙBB֙B  B33B  B֙B33B  BԙBԙBffB  B  BBB33B  B䙚BffBffB33B33B33B  B癚BffBB33BffBB  BffB33B  BffBffBffB33B  B̙B  B  BBBffB֙B  B  B  B  BԙBffB33BB33B  BffB͙B  B33BffBffB  B33B33BB  BffBB  BffB  BffBffB  BB  B  BffB33B  BB33B33BəB33B  B33BBϙBffB  BBљBffB  BffB33BҙBәBffBB  B  BBҙBffBҙBB33B33BәB33B33BәBәBԙBffBՙB  BB33BՙB  B33BffB33BBBљBљBffB33BљBffBB33B33BЙBљBffBBBљBBBffBffB˙B  B33B˙BBB̙BΙB33BBϙB  BΙBΙB33B  B  B  BffB33BffBffBB  BffB˙B33B  B  BffB  B  BffB͙B33BΙBϙBΙB33B33BB33BBBʙB  BʙB  BB33BЙB  B  BB33BBBffB  BB  B33BffB  BB  BԙBՙBffB33BҙBәBffBBBBBffBBBffBЙB  B  BffBB33B  BB33BBffB  BB33BϙBΙBBB33BffBffBB33BƙB  BǙBffB33BB33B  BffBB  BÙB  B  BBƙB33B33B  BBəBBBƙB33BffB  BęBffB  BBB  B33BffBBffBBBB33BB  B  B33B33B  B  B33BBB  BՙB  BЙB  B  BB33BffB  B33B33B33B  B  B̙BffB33B33B33B33B33B  B33BBBffBƙBffBƙBffBBffBffBffBffB33B33BÙB33BffB  B  B33B33B  BBB33BffBBffB33B33B  BBffB33BB33BBffB33BBBB33BBBBBB  BBB  B  BB  B33BB  B  BBffB  BffBBBB  B  B33BffBffB33B33B  BBffB33BffBҙBBBљB  BffB33B  B33BՙBՙB33BԙBԙBB  BBffB33BBffB33BϙBffB͙B33B33B͙BBBffB33B33B  B  B33BffBBffB  B33BșB  B33B33BǙB  BəB33B  BəB33B33B33B  BffBffBƙB  B33B  BÙBřB33BęB33BB  BBB33B33B33BffBęB33B33BffBB33BffBBʙBBffBBffBϙBffBBffB  BϙB33B  BBΙBBB33BЙBffBffBϙBffB  BffB  B33BЙB  B  B33B  B33B  BΙBffB33BљBЙBBΙBB33BϙBЙBЙB33BffBB  B33BBffBB  B  BB33B  BәB  BԙBffB  BؙBBԙBBffBՙB33BBB33B33BљBBҙB33BffBՙBffBffBffBЙB  B33BBB33B  B33BffB  BәBҙBB33BBffBԙBffB  BՙB33B֙B  BB33BBB33B֙BיBؙB  B  B33B33BԙB  BՙBffBffBBؙBB33BB33BffBBffBffBיBffBffBffBԙB  B33B33B  B33BBffBffBәB33B33BәBәBffBәBәBәBBәBәBffB33BҙBffBffBB  B  BB33B33BffBB  BffB̙B33B̙BffB͙BffB33BϙB̙B33BB33B33B33BBљB33B  B33B  BԙB  B  BBיB  B  B  BԙB  B  B  BՙBՙBffB33BәBBffBBљBffBљBffB  B  B  BЙB33BffBffBBљBљB  BB33B33B  BffBЙBffBљBЙB  B33BffB  B  BЙB33B33B33BB  BffB33BBBBffBffB33B33B33B  BЙBffB33B  BB  BBϙBϙBљBЙBBЙBЙBBΙBB  B  B  BffB33BBϙB33B33BЙBЙBBB  B33B  BB  B  B33B33B  BB  B33BҙBәBffB33B33BBffBffB֙BffB  B33B33B33B  BffB  B  B֙BffBB֙BffB33B֙B33B  B33B  BB  BB33BffBffBffBBffBBԙBՙBB33B  BәB  BB33B33BB33BЙB33BBϙBffB  BΙBB  BffBϙB33B33BBffB  B  B  BffB33B  BffBffB  BՙBBffB  BffBB33B  BffBיBffB  BffB33BBffBBffBݙB  BB33BB  BᙚBffBBݙBޙB33B  BffBBݙBBffBݙB  BffB33BB  BffBݙBݙB33B  BffB33BffB  BۙBޙB  BffB  B  BffB33B  B33BBߙB  BBߙBB33BB왚BffBffB噚B  B  B33B  B33BBffB  B  B  B홚B  BߙB  BBꙚB33BBffBffB33B噚B33B癚BB  BffBffBBޙBffBffBݙB33B  B♚BffB33BffB晚BBB陚B  B  BffBffBB33BBBffBffBffBffB33B33BB33B33B33BBffBffBޙBߙBڙBBBffBۙB33B  BffB33BۙB33BffB  BffB♚B♚BffBffBffB  BffBffB  BBffB33BffB  BᙚB  B  B33B33B  BffB  B  B噚B  B33BB䙚B♚BۙBB  BB噚BBBB  B33BffB33B  B  B  BffBBffB왚BBB  BB  BffB  BffB33B33B  BBB33BCLCCCCffCfC3CC33CCCffC CC  B33B  BffB  BB33B왚BffBBB  BBBB33B홚B33B33B33BBB  B噚BB虚B  B33BBffB33BיBיB  BffBffB  BBffB  BҙB  BٙBffB♚BffB33B噚B䙚B  B33BffB33B  B  BBffB  B  BffB  B陚B  B  BB  B  BBffB33C C CffCC33CC  CC BffB33C BC3CfBffCLBBffB33BBB왚B왚BBffBffBꙚB  BB33B  B  BB33BBB33BB  B  B33B陚BB  B  B  BffB  BB33BffB  B33B㙚B  B  B33BᙚB  B  BffBޙB33BBB33BffB33BffBBBBffBܙB33B33B33BffB  BؙB  B33BffBBffB  BB㙚B33B33BffB  B陚BB33BffBffB  B  B33BBBBBB  B33C 33CB33B  C ffB33BB  BffB  BB왚BffBB虚BBffBB  BffB  B33BBB  BffBBffB♚BݙBB33BᙚB33BBffB  B  BۙB  BڙBڙB  BٙB33B33BffB  BffB33B  BBffB  BBffB  B  BҙBffB  B  B33B  B  BۙB  BB  B33BՙBԙB  B33BffBBܙBBffBffBBBffB33B  BB  BffB33B  BffB  BB33BB  BB33B  BBffBffB  BB33BBffBB  BB33B33B33B晚BB33B䙚B  B33BBBffBݙB33BݙBܙBB33B  BB33BؙBffB33BיB33BffBBffBffBBffBԙB  B  BřBB33B  B33B33BB33B  BЙBBB  BՙBffBיBffBffBffB  BffBB33BffB  BffBBB  BBB癚B陚BffB  BBꙚB33BB  BBffBBBffB  B  BBBffBffBffB33B33C B33BffB33BB  BffBffBBBBC  BBB  CffBC BffBBB33BffB33BffBB33B33BffB  BڙB  B33BٙBffBʙB33BffBΙBffB  BffBBBffBffBBB˙BB  B  BB  B  BB33BʙBϙBffB33BffB33BffBB  BᙚBffB33BBffBBڙB33B33B33BB왚BBBBffBBBffB33C LC  CLC3C33CLC  C 3BffB  BB33B33B33BffBffBffBҙB33BәBffBBffBBffB33B33BB33BffBffBΙBffB33B33BffBΙB33B33BB͙B  BffBҙB  BffBۙBB  BB  BәB  BԙB33B  BffB  BffB33BԙB33BBffB  B  BB  B  BffB  B33B33B  B  B  BffB♚B33B虚B  BB33BffB  BBffB33B33B  BffBffB33B  B33BBBffB  BBB33B  B  B  BBBB33BB33B  B33BBꙚB33BB33B  B  B33BB33BB  BffBЙB33BBffB  BffBBffBffB33BffBffB͙B33BffB33B  BBffB  B  B  B33BBϙB33BffBffBffBB33BB˙B33BffB̙B  BffB  BffBBffB  B33BffB  BB  BיBBffBffBBB33BffBBBffBffB♚BffB33B  B33BB33B33BffB  BffBB  B33B33BB33BBB  B33BBB癚B  B뙚B33B  BffBffBB  B33BB  BBBffBBBffB33B  B33BB䙚BffBffBffB33BffB㙚BBBBߙBBffB  BޙB33BffBߙB  B  BBffB33BBffB33BffBffBffBffB33BBffB33B33B  B33B33B㙚BffB  B33BffBffB33BffB33B33BBffB33B  BB33B33B  BBffBB  BBB  BffB  B  BB  B33BBffBffB33B33B虚BffBBBB33BߙBߙB䙚BffB33BᙚBB33BB33B33B33B33B  BB  B  B  B33BәBB  BBB33BϙBffBϙBΙBffBϙBffB33B33B33B  B  BҙB33BԙB33B33B33BffBٙB  B33BݙBffBBB  B  B33B  BffB  B  B33B陚B  BffBB  BBBffBB  B噚BffBffB33BᙚBBᙚBffB䙚B  BffBBffBBBBffBߙB33BffB33B  BffB  B33BffB33BffBffB33BBBBffB  B  B  B  BffBB33B  B33BB  B♚BݙB  BffBffBBffB  B33B33BB  BffB  B  BיB33B  B֙B33B  BB33B  B33BBBۙBffB33BBBBffB噚B  B  C33BB33B  BffB  B33BCffCCC3C CffC  B33B  C B33CfCfC3C33CffC  C	C
ffCC  CC33BC33BffBB33BBBB33B33BB  BffBffBB33BffBffB  B  BffB뙚B33B33B  B  BffBBBffBޙBݙBBBffBffBB  BB  B33BʙBљB  BffBΙBB  BBBBΙB33BffB  BBڙB33B33BffBBffBffB33BB홚B33BB  BffBffBBBffC ffCCCLC CCCCLCCLCffCC33C
CC  BffC33C3C CffC	LC
3C
  CCffC
BffC LBB33B33BffBBffBBffB䙚BB  BffB虚B  B  BffBffB  B33B33B33BB33BffB33BffB陚B33B䙚B㙚BBffB  BBffB33B33BBBBޙB  BffBBffBffB晚B虚BffBffBffB  BBB33B  BC  CffCfC  CC 33CffC33CC33CCLC CLC CffCfC33C C  CfCffCBffCLCffBBCLB33BffBBBffBB33BBffB33C 33B33BBffBBᙚBB癚B33BB  BffB33B陚BffB33B  B33BB虚B  B33B  B33B  BffBffBBB33B  B33BffBB33BffB  BܙBffB  B䙚B  BffBffBB33B  BߙB♚B噚BffBffB陚BffB33B  B  BCffB33C CCffC CCffBC fC  B33BffBBffB  B  BBffBB33BBffB  BB33B33B33BffB33C3C3CfCLCB  B33B33BffB  BBffBBffB  C C ffC3BBBffBffBB33BB陚BffB  B33B  B  BffBBB  BޙB33B  B  B  B  BBffBffBffBB  B33B33BffB33B  B33B33BffB  B  BB33B33B  B  BffBBB  B33B  B33BffBBBffBB  B뙚B33BB  BBffBB  BB33C33C3C 3BBBB  BBB  B  B33B  BffB33BBffBffB  BffBffBB  BffBBffB33BffB  BBޙB33BffB33BܙBBB  BٙB33BBffBffBޙB33BffB33B㙚B  B33BffBޙBffB33BBffBB  B  BB  B  B33B  BB33BߙBffBffB  BߙB33B  BffBB  B  BffBffB  BffB  BBBB陚BffBB  BB33C	C
3CC
 C3CffCC	ffC
33CC BffBCLC B  B33BffBffBB  B33B  BBBꙚBffBBBBffBffBffBffB晚B㙚B♚B  BffB  B  B33BB33BBffBٙBٙB  BffB33BffBffBffBBۙB  B33BۙBffB  B  BBߙBٙBffB  BՙBffB33BffBffBBB  B晚B  BB33B33B33BB33B홚B33C BB33BffBB33BffBC
 CLB33C CCfC33C	ffC  C
  C C C33CLCBB  BB  BB  B  BBBB홚B  B홚B33B  BB33B33BBBB33BffBB  B晚B噚BBffB  B33BB  BffB33BffBBffB33BBffBffB33BB33B  BܙB33BBۙBڙB  BffBffBffBffBؙB  B♚BffB33BBޙB㙚B33BB33B  BBffB  BffBBB33BffB  CffC C  CCCffB33BB  CffC CB33C   CfC33CLCLBBffB  B  B虚BB癚B33BꙚB  B晚B虚B  BffBB33B  BffB뙚BBꙚB33BffB  BffBיBؙBBffB  BffBBffB33BBBBffBffB  BffBՙB33B  B  BԙBB33BљB  BffB33BBffB  BffBB  B33BߙB  B33B  BBBffB  BB33B왚B33BBffBffBBB  B  B33B33B33B33BB33BB33BC C 33BBffB33BBBffBBC   BffBffB33C  C C 33BBBB  BffB  BB  BᙚBffB33B33B  BffBffBB33BڙB  B33B  B33BBB  B  BB㙚BffB  BffBBBޙBBffB33B33B  B33BffB癚BB33B  B虚BffB虚BffB33B33BB33BBB33BB33BB  B33B33BBB33B33B33BB  BBB  BffCCffC C33C C
C
fCfC33CB33B  BB33BBffBBB  BBffBBffB  BB33B  B  B虚B33B33BBffBBBB33BB33B  BBBBBffB33B  B33B  B33BۙB㙚B33BݙBBڙB33BBܙB33BB  BB33BffBBB  BffBffBffBffBffBB33BB  BffBffBffBBBffBꙚB왚B33B  BB  BBBBB33B  BB  B33B  B  BBffB33B33B  BffB33BBBB33BB33BBBB  B  BffB33B  B33B33BffBBBB֙B33B  B33B  B  BBffBB33B  BڙB  BBffBBB33BffBffBBBffBיB33B33BffB33B  BB  B  B  BBՙBffB  BffB֙B33B  B  BٙB  BB  BffBBffBܙBBBffBBBڙBٙB33BۙBffB  BBffBB  BٙB33B  B33B  B33B33BBffBB  B33BBffBۙBיBꙚBBBߙB  B  BB  BBܙB虚BffB虚B  BB뙚B㙚B  B33B33BBB  B䙚BffB晚BffB  BBffBޙBffBBBB33B33B  BBBB  B  B  BԙBffB  B33BffBBffB33B  BBBBԙB  BיBܙBBffB33BBffB33BffBB  B癚B晚BffB癚BB  BffBB  BffBffB  BB33B陚B33B33BffBB  BBCCfCLBB33B  BۙB  B  BffB陚B  BffBBBffBffBffB♚B  BffB  B33BB  B33B  BBᙚBffBBffBffB33BۙBffBffB33BffB  B33BڙBܙB33BffB33BՙBәBB  B33BffBؙB33BffBBffB  B33BۙBB33B  BffB♚BBffB  BԙBBٙB  B33B㙚BffBᙚBBB噚B  B33BᙚB33BffBᙚB䙚BB33BffBꙚBBꙚB  B  B  BB33BBffB33B33B33BB  B33B33B33BB33B  B陚B33BB  BffBB33BffB33B  BB33BݙB  BBffB33B  B33BݙB33BBBffBffB  B  BߙBߙB33BBB  B33BffB  BB33BffB33B  B  B33BBffBܙBᙚB晚BffBffB  B  B33B뙚BB  BB㙚B♚BB  BffB33BffB  BB虚BBffB  B33BB  BBffB왚B33B  B  BffB33B  BffBB33B  BB왚B33BffBffB33BffBB33BޙB  B  BffBBffB33B33BݙB  B33BffBߙBB  B  B  BffBB  B33BffBۙBffB33B33BffBffB33B33B  BffBҙBBffBffBיB  B  BB  BיBBffBffB  BBffBBffB  BԙBffBיBݙBffBffBffBffB33BܙBBݙB33BߙBBBffB33BB㙚B33BffBffBBffB  B  B33B  BffB33B㙚B噚BB33B  B33BBB  BffBB  B33B  B  B33BB33B33BٙB33BffBffB֙BBՙBBffBBB33BBBЙB  B33BBB33BҙBffB33B  BљBϙBЙBB  BffB̙B  BffBffBBffBBffBffB33B  BffB33BBffBϙB  B  BBՙBBBؙB  BffB  BffBٙB  B33B癚B  B䙚BڙB  BBffBݙB33BffBBB  B33B  BffB33BB  B  B  BBB陚BffBB  B33BB  BߙBBffB33B홚BB  BB  BB33B癚BꙚB33BB  BBffBffBܙBBݙB33BffBffB33B33BffBәBBffBB33B  B̙B  BB33B33BBffB33BffB33B33BffB  B  B  B33B  BffBҙB33B33B  BBBBB33BB  B33B  BB  BܙB33BffB33B  B  BBffB33BffB噚B  B  BffBffBffBffBBݙB噚B  BꙚB晚BBBBBB  B  BffBBBۙBffB33BffBۙB  BffB  BٙB33BB33B  BffBܙBיB33B  B  BؙB33B33BڙB  BffB֙BffBBB  B  B  B  BffB  B33B  BЙB  B33B  BffBffB  B33BٙBBܙBߙBffBffB33B㙚B晚B  BffBffB33BffBᙚB㙚B噚B  B陚B  BBffB왚B33B  BBffB  C CB33B33B  C  C 3BB33B33BB33BB33BB  B  B33B33BffBݙB33BB  B33B  B33B  BB晚B  BBffBffB  BffBffB  BB  B33BܙB  B33BڙBffBffB33B  B홚B䙚B  BBܙB  B  BܙB33BBۙBffBB33BffB  B  B  BffBݙB33BBޙB  B33BffBffBBffBffB뙚BBBBB33B33B33BffBffB33B  B33B뙚B33BBBBBBB  B33C   BffBffB  BffB  B  B  B33BB뙚B  B홚B왚B33B33BBffB  BffBB33BffB陚BBBffB  BB  BB  BBB  BffBB왚BffBBffB33BffBffB㙚BB  B虚BB  BffBffBۙB33BؙBB  BBB33BҙB  B  BؙBBffB33BB  BBffBB33BffBB  BᙚBᙚBBffB33BBffBffB33BB33B  B33B虚BffBffB33BBB33BB  B陚BffB  BB晚BffBffB癚B噚B33B  BޙBBBB33BffBffBBBᙚBBffBffB  B33BB  BffBB33BޙBffB33B33BffB33BffBBܙBB  B  BՙBB  BffBBBBffBՙBڙB33BB33BBڙB  B33B33B  B33B33BԙBBԙB33B  B  BԙB33B33BڙB33BffBޙB33BBߙB  BB  BߙB33B33B  B  BB  BffB  B33BffBBffBBffB  BffBB33BffB33B  B  B  BڙBB  BޙBܙBffBBٙBٙBיBffBBٙB33BٙBffBBffBB  B  BԙB33BBBffBBΙB  B  B33BB  B͙B͙B33B33B̙BB33B  BB  B  BBffBǙBBB33BB͙BffBffB33B  BBffBffB33BffBBՙBffB♚BߙBBB  B  B  BffBBݙB33BBffBffB♚BᙚBB  B晚BޙBffB33B  B  B  B33BffB  BBڙB  B33BBBffBB33BBۙB  B33BffBffBB֙B  BBBՙB  BBB33BBB33BB33B  BffBffB  BffB  B33B  BBΙBffBљBffBB33BәBՙBB33BffB  BBB  BәBffBԙB33BffB33B  BڙBBܙB  B33B  B  B  BBB왚BffBB  B33B  B  B  C 33BffB  B  B  BBffB33BB虚B33B왚B33BBB  BBB  BB  BffB33B33B33BffBffBffB虚B㙚B  B33BffB33BB  BffB虚B33B♚B33BᙚB  B  B  B  B33BffB33BffBffBffB33BffB  BB噚B  B  B33B33B  BꙚB  B뙚B噚BBBߙBޙB䙚BffB♚BffB虚BffBffBB  BBBffBffB뙚BffBB33BBݙBۙBB噚BffB  C C3CC3BffC33CfBCCLC
CLC33CC  C 3C3C3C  C  CC B  B  BffBB홚B陚B  B  B  BffB晚B噚B㙚BffBB  BݙB  BB  BBܙB  BBffBBffB  B33B33BffBffBffBᙚBBffBB  BBB33BffB噚B♚B  B  BB33B  B33BBffB  B  B33BBB  BC ffC 3CLC33CLCCfC  CfC33C	C	3C	 C CCC CC	CffCfC
fC
fCLC
CLC
LC C CffCffC
fC C
 CCCffBffBBffBffBBBꙚBBꙚB33BB  BffBݙBffB33BBޙB33B  B  BffB  B♚B  BᙚB  B33BBBB  B  BٙBffB33B33B33B  B  B33BBB33BffBffBffB  BffBB  B䙚BffB  BBBB33B홚B  B  BBB  BBBB33BBBB33BBffBffB  BBB33BffBffB  BBBBB  BffB  BffBB33B  BffBBffB33BffBffB虚B33BꙚB䙚BB♚BffB33BߙB  B33B33BB33BffBؙB33BؙBٙB  B䙚BffB33B  BB33BB֙BәB33B  B  B33B33BBffB33BffB  BљB  B33BffB33BЙBϙB  BҙB33BffBffB33BBۙB  B33BיBffB  BۙB33BٙBBٙB33BffBB33B  BB33BffBB33B33BB  BBؙBB33B  BffBffBBB33BffBәBffBB  BϙB  B  BffBffBΙBffBffBșBęB33BBřBB  B33BffB33BÙB  BBBBBÙBęBB  B  B  B  BęBB  BBBBB33BB33BBBffBffB33BBffBB  BB  BǙBșBșBB  B  BəB33B˙B33B33BЙB33B33BB33BҙBҙBffBB33BΙB  BffBB  BBB33B33B33B֙BBffB  BؙBBffBBB  BיB  BB  BB  BffB33BffBffBB  BB33BB  B  B  BB33B  B  BffB33B  BffBBB  B  BřBBBBșB33BffBffBBəBƙB33BřBřBęB  BffBB  B  B  BffB  B33BBBffB˙BffBșBƙB33BBB  B33BBЙBBffB  B33B33B33B  B33B33BffBffBffB  B  BffB  B33BBBB33BB33BB♚B  B  BߙBߙBߙB33B  BffBBBBۙBڙB33BؙB  BB  B  BffBffBBBffBffBBffB  BәB  B  BB33BљBBBffBϙB33BҙB33B33BB33B33B  BϙB33BBB  BB  B  B33B33B  BffBBBݙBۙBffB33BBffB33BffBޙBffB33BBB癚B  B왚B  BffB33B  BBBBBBB  BBBffB33BffBBBB  BBBffBffB  BffBB33B  BffB33B33B  BꙚBffBB33B홚B뙚B  BBffB33B  BffB33B33B33B33B  BffBݙB33BBיB33B33B  BיBBffBB33BB  BԙB  BffBڙB  BffBffB33B33BffBBؙBffBffBB33BܙBffBؙB  BBffB33BڙBBޙB33BBB  B33B  B  BB  B  B33BB  B33B왚B33BB陚B虚BffB  B33B33B  BB33B33BBBB33B噚B33B  B䙚B㙚BffB  BffB  B  BٙB  B33B  BBՙBՙBB33B33BBB  BBBB  BffBffBB33BBԙBBәB  BҙBљBffBϙBΙB  B33B33B33BB33BB  BBffBBBBffBffB  B33B33B33B  BBיB33BٙBffB33B33BܙBffBBݙB  B  B  B♚BffB㙚BBB噚B33B癚B33BB噚B33BffB33B33B噚BB䙚B㙚BffB33BBB  BBᙚBᙚB33BffB33B  BffBᙚBB33B33B  BffBffBߙB  B33BBffB  B  B33B33B33B33BBffB33B  B  BBԙB33BڙBBffB  B33B33B  BBޙBffB  BBffB33B33BBffBffBffB  BffBB㙚BffB  B  B33BBffBBB陚B  B뙚B왚B33B33BBB  BffBBffBB왚BffB뙚B  BBB33B癚BffBffBBB  B  BffBB  BffB  BffB  BBffBffB  B  B  B33B  BffB  B33BffBffB33BffB33B陚BB33BBB33BffB33BҙBәBՙB  B  BBBffB33BB33BB  BЙB33B  BBBffBᙚB33BBffBffBBffB  B33BB33B33BffB虚B  BBffB  B  B33BB33BBBffBffBB  B33BBBBffBffBffBBBC ffBBB33BBB33B  B  B  BffBB  B33BB33BBffB  B  BB33BB33BBBffBffB  B33B33B  B33BBBffBBffB33B  BffB  BffBB  B  BffB  BffB33BיBՙBBffB  BߙBܙBǙBB33BB33B  B晚BߙBBB♚B  BݙB33BBB  BB陚B33BBB33BBB  B33BB홚B33B33B  BffBffB33B  B뙚B33BB33B虚BB  BB  B왚BBffB  BffBffBꙚBB♚B33BՙB  BffBB33B  B♚BݙBBՙB33B  BffB  B33B33B33B  BB  B  B͙B33B  BffB33BәBffBB33BffB  B33BffBBB  B33B  B̙BffBҙBBffB  B  BB  BؙB  BB  BBB33B33B  B33B  BffBәB33BffBՙBԙB33BBҙB  B33BBffBҙBBљB33B33BffBffBffBBBϙBЙB33BffBљBҙBB33BffBB33BffBB33BʙB  BB33B33B33BB˙BB  B  B  B  BBəB  B  B33B  B  B33BǙBǙBffB33BffB  B33BffBffBǙBB33B  BB  BffBǙBřB  BBBB33B33BffB  B̙B  BffBBBՙB33B33B  BffB  B33B33BЙBffB  B33B  B33BB  B  BffBיB  B  BܙB噚BffB33B  B  B晚B33B  BffBffBffBffBBB33BffBؙBB33B  B33BffB33B  BՙB33BffB33BffBBԙBBәB  BB  BB  B  BffB  BB  BffBBBB33BB33BffBЙB33BffBB  B  BBљB  BffBԙB33BB  B  BB  BffB  B33B  BffBB  BffBffBffB  BB  BffBffB  B  B33BffB  BffBޙBffBBffB  B왚B  BffB33B33B홚BB33B  B33BffB噚BB癚BffB  BBffB㙚BffB33BBB  B  B  BBBffBBBffBݙBݙB33BB33BܙBڙBffB  BBBBffBffBۙBffBיBffB33BԙBBffBB33BљB  BЙB33BϙBffB  B  BB33B33B  BB33B  BffBB33B33BffBBffBffB33B33BB33BBffBݙBffBBBffBᙚBᙚB33B♚BBffB  BffB33B  B33B33B虚B33BB33B  B  B33BffBffBBffB  BffBffB  BۙB  B  B33BB  BؙBיB  BffBԙBffBәBffBBffB  B33BڙB33BffB33BffB33BיBffBB33BϙBBffBB  B  B33BffBffB33B  B33B33B̙B33B33B33B  BəBBB͙B  B33BB  B33BffB33B33B  B33BffBB  BB֙BBיBffBffB  BܙB33BffBBܙBffBffBB  BffBBffB33BffB  BۙBB  B  BBؙB  B  B  BBԙBBԙBՙBffBB  B33B  B33B  B33BffB33BBәB  B  BffBBB33BffBffBәBԙB33B33BffBB33B33B33BϙB  BffB͙B̙B  B33BBϙB33B33B33BffB  BB  B33B33B  B  B  B  BәBԙB  B  BffB33BBBffBBۙB33BB33BؙBffBBBffB  B  BffBߙBffBffBBffBffBߙB  BݙB  BffBffBffBՙB֙B  B33BBB33B  B  BffBffBBؙBיBBffB  BBۙBBBffB  BљB33B33BBЙB  BffB  BәB33BffB  BBәB  BffB33BљBBљBB33B  B  B  BffBBB͙BffBB  BЙBffBΙBBffBәB  BB33B  B33BۙBޙB33B33BٙBffBܙBᙚBB㙚B  BB33BffBffB虚BBBffB홚B  BBB33BBBffB  BffB  B  BffBffB  BffBffB33BffBB  B噚B33BBBffBffBBffB  BffBBBܙB  B33BffB  B  BffB33BBffBBB  BBB33BB33BffBҙB  BәBԙB  BffBBBffB  B  BBffBffB֙B33BBffBffBB33BB  CfC33CffC33C3CffC
C3C BffBffBB33BffB  BBBBffBB33BBffBB33BC 3B33B  C33CBB  BBBffBBBffC  C C  BffBBBffBBBBffB  BCC B  BBffB33BffB  BffBffB  BffBݙB癚B33BffB  BffBffBBffB  B33BBffBBB뙚B  B33BڙB癚B䙚B33BffBBBB  BBffBBBC  C C33C   C fC C
CLCCC3CC
fCffC  C33CfC33C CC33CCfCfCffCffB  BffBBffBBBBffBBffBffBffB33BffB33B噚B33B33BffBBffBBBB33B33BB陚B33C  BffB뙚B홚B33BB  B  B  BB  BffB33B癚BffB  B33BffB  B  B33B䙚B33B虚BB홚B癚BۙBBffBBB33B  BffBffB  C  C ffC 33C C CC33C
33CffC33CLC3C33C3CC33CC33CLCfCCLC  CLC33CC  CfCLCffCLCCffCffBffCB  B癚B  BB  BۙB33BBBffBBBB33B33B33BffBffBBB  BffB  BB䙚CLB뙚BBՙB33B  BffBffBffBffBBB33B  B33B  BBffB  B33BB  B  B33B홚BffB33B  B33B홚BBB홚B  BB  B33B  C  CCffCfCfC
C3C CCffCC3CCLC3CCfC33CCLCC3CfC33C33CC33CffCCfC
33C  C
LCC33CC  CC C33C BBffBffB33BffB  BBB33BffB  B  B33B  BBffB33BBffBffBffB33BBBffBBB33BBB  BffBܙBBڙBיB33B33BBB  B  B  BߙBBᙚBffB33BB33B  B  BffBBB  BBB33B  B晚B33C 33BBB33B  BffB  B  BffBffBBBC LC33C3CCCC3CC33C3C fBB33BBB33BffBffB  B33B33B33B  B  BB  BBB晚BffB33B33BB晚B♚B33BۙBܙB  B33B  BB㙚B  B33BffB  B  B33BB33BBߙBB33BBB33BffBffBBB  BffB  BBffBݙBffB33B㙚BffBB  B  B  BffBBffB33B33BBffB홚BB뙚BffBffB  B  BB33BBB33CffC3CfCB  BB  B  BBBBffB33BB  B  BffBBffB  B33BB䙚B33B  BB  B  B  BۙBٙBB33B33BffB33BՙB  B  B33B33B33BBB33BBB33B  B33B  BffB33B33BؙB  B33B33B֙B33BB33B33B33B  B  BܙBffBBffB33BܙBᙚBffB33B  B  BffB癚BffBB  BffB虚B陚B  BBB33B33B33BBBB  BBffBBBffB33B뙚B  B  B晚B33BBBۙBB  B  BffBffBB33B33BffB33BΙBB  BΙB33B33BBʙB33B33BffBB˙BBʙBffB33BBB  BΙBffB  BffBffBffB  BBЙBϙBB33BBϙBΙB̙B̙B̙B  BffBB33BffBffBffB͙B̙BB  B  B  BffBffBffBB  BޙBBB  BB33C C ffC33B  BBBffBffBffB  B33C  C33C33CCCC3C33C33C fC BffBBC BffBB33BB  BޙB33BffBBݙBޙBffB33B33B  B33B33BٙBB33B33BB͙BffB33B33B33B33BۙBffBffBffB  BBՙBB  B  BffBؙBBBB33B  BBB33B33BB33BffBB  BffB  B33BBBffB  BB  B  B陚B陚BffB  BBffB  BB33BBC LCffBffCffCffC33C C	33C	33C
C3C
3CfCffC   CCCCBBBffBB  BB33BffBᙚB33BܙBffB  BffB33BB  BBB  BҙB  BffBəBffB33BffB˙BffBBBB  BBffBB˙BffBffB  B33BBBffBffBffB  B  B  BffBәB33B33B33BffB33B33B33BBB  BB33CLC3CCC3CLCCLCffCCLCCffC33CfC	ffCLCfCffC  C C3CCC3CffCfCCffC33C  C
33C	 CLC
33C BffC  CBffBB33B  B♚BB虚B33B  B33BBffB33BB33B♚BBB  BBBꙚB陚B  BffBffBB홚B33B33BffB  BBBB33BffB33B33B  B33B33BB33BffBffB33BB33B  B33B33B  C  C33BBBffCffCCLC3CC	 C
33CCCffCCffC33CCfC3C3C33C CffC	LC CfC
CC33CLC33BC CffCLC	3C3C	fC3B33B33BffBB  B33BffB  B33BꙚBB33BCBB  BBB  BffBffBB홚B33BBffB  BB33B33BBffBBޙBޙB33B33BffB  BBB33B33BffBԙBՙB33BB  BffB33BBffBffB33BB  BC CBC LBB33BffBffC33CC	  C
3C CCLC3CCLCfC
fCLC
ffC33C33CCffC33CC
3CC	LC	ffCfC BC 33B33B  BBB33BCBB33BٙBBffBޙBB33BBffB뙚B33B33B33B33BB  B33B  B  B33B  B33BޙB33BB33BB33B  B33BBܙB33BԙB  B  B  BffBffB  B33B  B33BBBB  B  B  B33BB  BB  B33C  C33C	CCfCfCfC33CfBB虚BB  BᙚC33C CfC
 C B33BCffBCfC
fCffCLC3C33CLCCCfCLC33BffB䙚B  BffBBB33B  BBffB33B  B33B33B  B33CffCC B  CffC C CC  C33CLC  BffB33B  B33BffBffBffBffBߙB  B33BffB33BB  B33BBBљBffB  B33BffB  BܙBffB33BffBB33BC  C fCC33CfCCC33CCfC  CfC3B  C  C LC C3CffCCffC 33BffC33B33CB33C CLCfBB33B♚B㙚B  BffB֙B33BЙB  BffBיB֙B  BՙB33BәB33BЙBffB33BBBffBڙBBߙBffB  B33B  B  B33BٙB33B  B  B֙BB33BBffBԙB33BffBϙB˙B̙BΙBffB  B33BәB֙BffBffB  BBffBܙB33B33B33BBBBffB33B晚BB홚BffBB33B  B33BBBBBC 3CC33C3C3CfC	  CCCBffBBיBBB33BBBB  B33B  BB  BffB33BffB  BffB33BffBffB홚B33BffBffB33B癚BB♚B  B  B33B癚BBٙB֙B  B33BҙBffB33B  BffBffB33BB  B33B  B33B  BBffBB͙BϙB33BffB  BB  B  BԙBffBB  BffBBffB33B33BffBB  B  B  BB  BffB33B33BBB  BB33BBBBB33B  B33BB晚B  B㙚BB33B33B33BffBffBB33B  B33BffBB  BB33BffBffBffB33B33B33B͙B33BؙBBٙB33B33B33BڙB  B33B  BBB33BffB  B  BffBB  BBBffBffBffBffB  BB  BϙBffBBffB33B33BB33B33BB33BB33B  B33BffB  BB  B  B  BșB͙BB  B  B33B  BљB33B33B33B֙BљB  B33B33B  BBBᙚBB㙚B  BB  B33BBߙB  BffBBڙBܙBBffBڙBffBffBB֙B33B  BB  BBffBB  BԙBB  B33BՙBBffB  B  B33BffB33B33BffB  B33B  BBffB33BBBB˙BBBffB  B  BΙB  B33BffBffB33B  B  B33B33B  B  BיB33BԙBәBՙBBffBffBffB33B♚BBB33B홚BB33B  BffB33C 33CLCLC  C 33B33B33B  BffBBffBffBffB33BB癚BB  BBBBBB  BffB33B  B  B  BB  BB  B晚B  B  BBBffBffB뙚B33B  B陚BffBB虚B33BB  BffBffB陚BffB33BBיB  B  BB33B  B33BЙB33B33B33BffB  B33B  BffB33B  B33B33B  BBB33BB33B33B33CC
33C3C  C CC3CffC C C  CffCffCC C  C3CC CfC33CLCC  CfC  CfC3CffCCC  C33CBffB  B  BBffBBC
BffBBBffBBffBܙB  BBffBC C  BC   BCC C BffBB33B  B33BBffB33BffB33B  B33BBffBffB  BB33B  BB  BB  B晚B33BBffBB33B  BB  B  B  BffBffBBB33BffC LB  CfC33CfC  C  CffCffCC
ffCC
33CffCLCC
3C
  C CLC CLCCfC  C   B33C C3CffBB33BC  C33C CCB  B33BBB33CfBBBffB  BיBB  BڙB  BB33B  B  B  BB33BffB  BBffBܙBBꙚB33B  BB33BBffB  B  B  B33BffBיBffBffB33B  B33B  BڙBffBڙB33B  BB  BB33BBCC CC
 C
LC
C
  CfCC C  CCLCC3CC3CLCffC3C  C  CCLC33C C33C B  B  B뙚BffBB33BffBB  CfC
CfCC  C  BB  B  B  BffC  C  B33B33B  B33BffBᙚBffBߙB  BBB33B왚BؙB33BљB  B  BffB33BՙB33B33B  B  BBߙBffB33BffB33B  B33B뙚B33C  BB  B  B  BBC  CCfCC CC  C CC	 C	fC
 CfCC
fCfCfC
fC C33CCffCCfCfB  B33B33B왚BBBffBffBffC33BB33BffBffB陚B33B癚BꙚB  B뙚B陚BB홚BꙚBߙB33B  B  B33B33B33B33BffBffBBܙB33BB  BҙB33B  BBBffBB33B33B  BBB  BffBffBffBBffBBBffBffBffB33BffB33B33B33BBffBB㙚B33B  B  B癚BffB33B晚B  BffB33BffB  B왚B33BffB  B33BB  BBffB  B33B뙚B33B33B  B  BޙBݙBޙBffBۙBۙBۙB  B33BܙB  BffBffB  BڙBB33BffB֙B֙B  B  BBՙB֙B33B  BBB33BB  BffB33B  BffBB33BB  BffB33BffB͙BffB33B  BBBffBB  BљBҙBBB33BәB33B  BB  BffB  B  BՙBffB33B33BB33B33BՙB33B33B  B  BBۙB33B  BBՙB  BffBffB  BؙB  BB33BffB33B  B֙BԙBB  B  BBBffB  BffBBՙB  BffBB  B֙BffBՙBffBffB33BffBיB  BB  B33BBffBәBffBffB  BԙBffBљBffB  BәBҙBB  BB33BffB33BBffB33B  B33B  BʙBBB  BϙB  B  BB  B  B  B33B˙BffBB  BB̙BΙBЙBљBB͙BЙB  BЙBB33B33BљBffB  B33B  BffB֙BffBffB  BffBffB33BB֙B33B  BۙBB33B33BBݙB33BݙB  BBffBffB33B  BڙBٙB  B֙BיB33BԙB  B  B  B33B  B  BBB33BЙBffBffB33BBәBՙB  BB  B  B  B  B33B33BffB  B  B  B  B33BffBəB  BəB  B  BffBB33B  BffB  BřBffBǙB  B  B33BBffBffB  B  BBЙB33B  BϙBB33B  BҙBљB  B33BB  B33B33BffB  BffBЙB33BϙBffB33BϙBЙB33B33BffB  B  B33B33BљBB33B33B  B33B  BBB  BԙBB33B33B  B33BB  B33BB  B33BB֙B֙BBәB33B33BBB33BB33B  B  B  BffBffBљBBΙBffB33BҙB  BҙBҙBffBBffBffB  B33BיBffBڙBffB33BffB  B33BޙB33B33BB33BB33BffBffB  BffB33B33BffBݙBܙBܙB  B  B  BffB33BffBۙBיB  B33BffB33BؙBٙB  BיB33BؙBBBffBffBffBffBՙB33B33BffB  BϙB33B33BB33B  BB33B˙B˙B  BffBB  BffBљB33BBBffB  BʙBҙBB  BҙBBЙBB33B  B֙B33BffB33B33B33B  BB  B  BBffBBBיBffBffB  BB33B33BؙBؙBffBᙚBffB䙚BffB  BffB33B  B  B晚B33B33BꙚBޙBBBffBB  BffBיB33BיBB33BB  B  BffBBB  BffBᙚBffBB33B♚B  BffBܙB  B33B  B  BffB33B33BffB33B  B33B33B33BBBB  BffB33BBffB33BBffBB33BՙBܙBB  BffB33BB  B  B33B  BB33BᙚB  B䙚BB  B噚BBB  B33B  B33BB33BBBB33B虚B虚B33BffB  BffB33B  BBB  B  BffB33B33BBBҙB33BffBffBffB33B  BۙBffB  BؙB33BffBՙBB33BffBB  B33BBԙB  B֙B  B  BB  B33B  BϙB  B33BffBffBffB  BBBЙB  BffBffBҙB33BBffB֙BәB33B  BљBΙB33BЙBљB33BB֙BffB  B33BffBffBB  BB33BᙚBޙBBffBffB♚B33BBffBffB  BꙚBffBB뙚B33BffBB33B33BB33B33BffBffB33BffB33BB33B33BffB  BB33BBҙB33BBBffB  BЙBffBϙB33BffBffBffB  BBffBϙB33B˙B  B  BffBBΙB33B̙BB33BBffB  BBffB33B  BffBљB33B͙BB͙BҙBؙB  B  B33B  BffBڙBBBBffBffB  B33B33B33B  B33B33B晚BffB  BBffBffBffB  BCLBB  B33BffB33BB33B33B33B33B㙚BB33B  B33BBؙBڙBٙBљBљBB  B33B  B  BB  BBٙBڙBffB  B  B33BffB  BBBffB33B  B33BB  B  BBəBffB33BB33BBBffB  B33B33B  BB  BʙB33BffBBB33BޙBܙB33BۙBۙBݙB33B33BffBBBיBBؙBB  B  B  BיB33BBB33B晚BffB33B33C BffCC3B33CffB  BBffB  BffBBBBB33B왚BB  BB33B㙚BB33BߙB33BffB33BffBffB֙BљBffB33BיB33BBЙBBffB33BΙBffB̙BB  B33B33BΙBBffBʙB  BffBffB33B33BəBffBB  B  B  B  BffBffBffB33BBBBBҙB  A6ffBffBB33B33BffBBffB33B33BBBffBBC   CLCfC BB33CLCC C CCCLC C33CCCLB  BBC 33BBBBB33B33B33BޙB  B33BffB  BffB33B33BљBBffB33B  BBffB  BB  BffBB33BڙB  B  BЙB  B33B  BB33B33BB  BffB33B33BBәBB  BB33B  BB  BᙚBBBBffBՙBBffB33BffB33B33B33B  B  BBffB33BBBBffB33BffCLCLCCCffCfCLB  B33BBBB33BffB33BB33BBBffBffB  B33B  B  B33BBBB33BffBB  B  B晚BBffBBߙB  BB  BBffBffB  B  B33BܙBB33BffBBڙBB33BBҙBB֙BffB  B͙B33BBffBB  BBB  B㙚B䙚B  B噚B  BB33B  B33BffB  B33BBBffB  BBffBBffB왚BB33B33BffB33B  B  BffC CCLC
C
CLCffCfCfCCffC C C 3BBB  B33BBBBffBBBB  B  BffB왚BB虚B噚B♚BffBڙBڙB  BꙚBffB陚BffBB뙚BBffB33BBffB33B33B33B33B  B  BBޙBB噚B  B33B33BffB  B33B왚B  BffB陚B  B  B33BffB33BffB33B  BffB33BBBffBBBBffBffB33C C fCCffCffC33CLC C CLCCC C 3C LCffC 3B33BffBBffBffB33BB  B  BBB  B33B陚B  B33B  B33B♚B33BffB  B33BB  B33BBffBB33BؙBffBBB33BffB  BԙB֙BffBBffBՙB33BffBB  B33BffBBBffBffB33B  BBB֙BՙB33BffBffBB33BffBffB䙚BffBffB癚B왚B  BB33B33BBB33CfCC33C3BffC LC CfC33CffC C33CC33C  C3CCCLCC  C33CfCC	3CffB  BBBffBB  BܙB  B  BBffBB33BB  BߙB33BffBffBB33B  B33B33BޙBBޙBޙBffB  BBݙBܙBBffBB  B  BffBB  BffBۙBffBڙB  BBBۙB33B33B33B  BffB33B뙚BB  BBB虚B  BB왚BBB33B  BffB33C ffC  C33CffC  CLC	CfB  BꙚBB  BB33B  B왚B  BB  B33B홚B33B  B33BB홚B33BffBB噚B33B33C 33BB陚BꙚBffBffBffB33B陚BBffB♚BB33B33B陚BffB  B33BffB  B33B33B33BB33BffBB33BBBffBB  BBffB  B  BؙBؙB  BffBۙBܙBݙBBffB33B33BBffBBB33B  B33BffB  B  BffC  C  C	33C C
  C
 C  C3CC33CLCLC CC3CCfC
CC  C CCfCLCB  C  CC  BBٙB  B  BߙBB  B33BB陚B33BffB㙚BᙚB  B㙚B  B  BffB33B  BB33BBؙBffB33BffBB  BffBBBffBffB  BB33BB33BBffBᙚBB  B  BffB  B  B  BߙB33BBB  BB  B33BffB  B  B홚B33BBܙBBᙚBffB33B33B33BBB  BBBC  C3CfC B홚B홚B33BC 3C3BffBffBffBBffBB33B33BB33B  BB♚BffBB♚BffB癚BffB33BߙB  BB䙚B  BݙB  B  B䙚B  B  BB䙚BffB33BBB뙚B晚BffBBᙚBffBBffBBffBffB  BB33B33BB  BәB33BffB33BffBBffBBffB  B홚BB33BC fB  C B  CffCCCCCCfC  CfCBCCfC3C C  CC	 C  CCCfCffCffCCffCfC	3CC  C	fBffBBꙚBB33BB뙚BBꙚBB  BffBffBB晚BffBffBٙB  B33B33BBffBffBffBB33B33B33B33BffBffBϙBffBݙBڙBBffB33B䙚B  BBꙚBffBBffB  BߙBݙBffB  BffB  B  B  C 33CLCCLC
33C
ffCfCC
3CB33BffB33B뙚B33BffBffB33B  C	CC  B  B  B33CC3CfCC33C33CfCCLCCC33CffC  C3CC3C fC  C  CBffBffB䙚CLCBffBBBݙB33BݙBޙBffBڙBB33BۙBڙBBB  BB33BB  BҙBffB33B  BٙBffB33B33BffB  BBΙBffB33BffBΙB  B̙BBB33B  B  B  BיB33BffBB33BffB  B33BCfB晚BB  BffBC33BffCCffB왚BB  CC3C3C	C3C3CfCffCCLCLC3CCffCffCCC fCLCC 3C CffC  C C  BBB33B33CLC  BBBB33B  BffBffB33BBffBffB  BBffBffBffBꙚBffB33BffB  BB  B  BffB噚BffB33B  B  BB晚BffBB  B  B33BB癚BffBffB  BffB噚B噚BB  BB  B  B  BB  B33C C C  CC33BB33B33B왚B  BffBCC3CffC33B♚B33B33BC33C CLC
fC33CffC
LC33BBBڙB33BffBߙBܙBߙB33BޙBBB33BffB  BB33BffBffBꙚB33BffBԙB33BؙBٙBBB  B33BB33BB  BBffB33B33BB  BؙBؙB  BBffBBffB  B䙚BB33BffB  BffB33B  BB  BffBᙚBB33B癚BBffBffBB33B  B癚B33BB  BB  BBffBBB33B  B  B33BB33BBB  BBB33BBBffBffBB  BBB  BBB  B  B33BڙB  BBBffBBffB  B33BB  B33BffB33B  B33BBffBffB33B33BB뙚B33B  B  B33BffBBB  BBffBBBB  BffBB33BBBB  BBЙB33B33B33B33B33BәB33B33B  BޙBBԙB  B33BBBBBffBffBffBffB33B33CLCC3C
 C
ffC
 C33CC
C CffCffCffCLC C33CC  BffC C3C33CfCffC  BB  B  BC 3C C fBB33C33C   BB晚B33B  BffBB  B왚B  B  B  B癚BB33BffBffB  B  B33B33BBBB33B왚B  B33BBߙBffBffBffBBݙB  BBffB癚BffB  BffB  BBffBffB33B  BBB33B33B33B  BCfB  B  BffC  B33BffBC3CffC	C
33BBBBBffB㙚B虚BffBB  B  B  B뙚B33B  BffBB33B33B33B  BffB33B噚BᙚBᙚB33B㙚BffB33B晚B虚B33B33B  BffB33BB33BBB33B33BffB  BٙBffB  B33B33BיBB֙BBBB  BBffB♚B  BffB  B  B33BB33BB33B33BBB  BBffBBB홚BBffBB33BB33B33BffBffB33B  B33B33B33CffCffCCC  CCC3CLC  CfCffC33CC  C
LC
  CfCfCfC3B33B  BffBC BBCCC3B  B홚BffB  C BCffBffB33B  B33B  BB33BffBBffBffB  B33C 3CCBffB  BffBB33B  BffB癚BB陚B33BffBffB  B  BBBB33BBBffBffC fCCCfCCffC CfC  CC	C
3C3CCCC
3C
ffC
C
C3C C
fCCCLCffCCC
33CCBB33BBBB33BB33BffBffB  BB33BffB33BBB33B  BB㙚B33BיB33B癚B33B뙚BffBBffBܙB33B  B癚B33B33B33B晚B晚B33B33B  B33BffBәBԙB  B33BB33BҙBB33BBffB33BffBBߙB  BB  B  B  B  B噚BBꙚBffBB  B  B33BC fCffC3C C	LCLCCfCLC  C  C3C3CC
fCCffCCCLC  C  CC BffB噚B33B䙚BffB  B33B  B33B  BffB  BᙚBffBBffB  BffBߙBBB  B33BBffBBBBffB33B33B  B  B홚BffB  BޙBffBޙB33B  BB  B  BٙBؙB33B33BB  BffBB  B33B㙚BB  B  B33B  BBB晚B33B  BBffBffBffBffB  BBB  B  BBffBBCCLCLCCfCfC33C3C C
fCLCC
3C33C3BB䙚BffB♚B33BBffB  B33BB  BBיBۙBBݙBffBffBBؙBB  B  B  B33B  B  BٙBffBB33B33B  B33B䙚BffBBffB  B  BffB֙BBffB  B  BיB  B33B33BB33B33B33B֙B  BffBB홚BޙBᙚBB왚BffB33BffBBffBB왚BBffBB33BBffCfCCffCC	fCC
3CC  CCC C  CCC C	fC  C C3CCLCCCLCC  CffBBBffB  B33BBBB33BffB噚BffBffB  B  B  BBٙB  BBڙB  B33B33BffBffBڙB33BؙBٙB33BٙBBB33BՙBԙB33BBBB33B  B33B  BۙBۙBffB  BߙBffB33B  BffB  B33BۙB  BꙚBBBffBBC  BffC  BffB䙚B♚BBBB33BB33BBffB  B  BffBCfCB33CCCCLC3CB  BffBBffB33BffBffBffB33B33B33B  BB  B陚B  B  BBBBffBffB33BB  B33B33BBB33BB  B  B  B  B㙚B33B33BffBffBffBffBffBffBffB33BffBffBB33BBffBffB33B  B陚B  B33BffB홚B33B  B  BBffBffC CffC33CC3CC	33C	C
33C  CC
ffC CCfCffC33CLC  C CfC CCffCLB  C
CC
ffCCLCB33BffBffCfB33BBB  B  B  BffB  B  BffBB  C C CCB33B  BBBB33BB晚BffBffB  B  BBBffBB33BBBffBffB33B33B33BB33B33B33BffBffBBBffC  BBB  B33BffBC 3B33BffBB  C3C fC CffCfC C	LC33CffCfC3CC33C  C33CffCC CCCC	33C CfC33CC3C  CfB33B  B33B33B  BB33B陚BffBB33B33B33BffBffBffB33B33BffBB  BؙBBB  BffB  BffB33B33BBffB  BBB  B  B㙚B陚BB33B♚BffBB  B噚B33BffB  BBݙBB癚B홚CC33CBffBffBffBޙBB  B뙚B33B陚BffBBBBBBffC CffCC
LC
33CCC BBB  C C CfC3C B  B33BBBB  BffB뙚B33B  BffBBBffBBffB  BBffBffB33BffBffB  BffB33BB  B뙚B33B33B  BB  B33BљB33BffBBffBBB33BBffBBBffB33BffBCfCffC3CfC33C  C C  B  CCLC
LCC3C CffB  C3CLC	 C
fCLC C33CCffC
fC
ffC
3C
ffC
C	LC	33C	 C
LC	3C	ffCC33CffCCCLCB33B33B33B33BffBB33B  B  B33B33BffBܙB33B33B33BffBffB  B33B33B33BBB33B홚B  B홚B33BB  BBBBB33BڙB♚BܙB33B33BޙBffB  B홚BffBffBffBBffB  BffBffB䙚B  BBꙚBBB33B33B  BffBBBffB33BffBffBB  B33B  BBffBB33CLC33CC  C  CCffCLCfCCLCffB33BffCBCCLC33C  C  BB33BC  BBC3BBffBᙚBffB  BBBffB  BffB  BffBB33BBB  BffB33B33B33BB  BșBșBffBB˙BǙB33BϙB33BBffB  BB33BB33BٙB  BB  BffB33BB33B噚B33B33BffBffB  BᙚBޙBߙBB  BffBB33B  B㙚B  BB  BffB  B  B噚B  BffBBߙBffB  BB33B33B֙BffBB  BB33BԙB  BҙBffBҙB33BBffB  B33BffB˙B33BBʙB  B  BəBǙBǙB  BffB33B33B33BљB͙BffBffB33BffB  BBffB  BBBϙBBBB  BffB33BffBBffBÙBffBB33BffBffB  BʙB  B  BљBB33B֙BB33B  B33BBڙBffB  B  BBffBڙB  BٙB33B  B  BBBҙB  B͙BљB͙BљBB̙B  B͙B͙BϙB  B  BЙB  B33BffBffBB  BBffBBB33B33BffB  B33BffB33B  BB33BÙB33B  BÙB33B33BffBBBffB33BB33BffBffBffBB  BBBBBffB  BB  B  BșBBffB33BffB  B33BԙB  B  BffB  B  BffB33B33BBB  B  B33B  B33B33BffB33BffB33BffBffBꙚB  BBBffBffB  B33B  BBffBffB  BffBBBffBffBffB  BڙB֙BݙB  B33B33BBffBBffB33B  BffBҙB̙B  BffBffBB33BffBљBЙB  BЙBffBB33BffBffB  BљB33BffBڙB  B  BᙚB33BBB陚BffBB왚BffB33B33BBBB  B  BB  C ffBC LC ffCffC  C3CC CC CC CC CC3CffCLB  BffB  B  B33BBB33BffBB  BBB  B  BB33B  BBBؙBBBffBffBffBffBڙB33B33B33BՙB֙B䙚B晚B33B֙BB  BۙB33BffB  B  B  BBޙBݙB33BffBۙBߙBB  B33BBB  B33B33BB  BBBBBBC B  BB33BffBffBffC33C C33CffCC33CC3C 33BffBBBB33BB33BB  BB33BBBBB33BBޙBB  B33B33BBffBffBffBؙB33B33BB33B33BיBffB33B  B͙BffB  B33BffBffB  BBBffBϙBBљB33BB֙BՙB֙BBB  B  B֙B33BBffBffBffBۙBݙB33BBffBffB33BffBBڙBffB33B33BffBᙚBᙚBffBBBBffB  BB噚BffBBB  BffB  BޙBBB  B33B33BљB33BffBBԙB  B  B33BBB33BffB33BffBB  BffBffB33B33BҙBBԙB33BҙB33B  BBBB  B33BBBBffB  B33BƙB  BBșB  BB33BffBB33BffBB33BffB˙BffBBϙBB33BЙBҙBffBٙB  BݙB33BffB  BffB33BЙB  BffBǙBəB33B33B33B33BffBBBB  BB  B33BʙB33B33B33BffBffB33B  B33B  BB33B33BBBԙB  B  BB  B  BBBffBB33BB33B33B  B33B  BB  BffBޙB33B33BffBffB33BffBB  B33B33B33BB33B33BffB  BffB  BBϙB33BB33BffBBB  B̙B33B33BʙBB˙B  B  BB  BBffBÙBB33BB33BffBəB  BffB  BΙB  BffB33BٙBڙBBffB33B陚BffBffBffBB噚BffB33B陚B33B33B33B  B  C fCC33C	LC33C
CC	fCC C
  CCffC33C33CBffCCCCfC BffBBB33B  B33BB  B33B33B  BffBۙBBBffBBffBؙBԙBB  BBBffBffB33B  BB  B  BffB噚BffBffBffBffB  BBffBܙBB33BB33BܙBffB33B33BffBᙚB  B  BݙB33BٙB33B  B33B癚B홚BBffBB33BffBBffB왚BB  C ffC C3C33C	C33CC3CC
ffC C	3C  C3C  CLC3C3CfCCffBC  CffC33BB♚B  B33B癚B晚BffB  BB  B癚B33BffB33BBffB  BffB33B㙚BffB  BBffBB33BffBBffBBBB  BB33BB  BBB33B㙚B33BޙBffB33BԙB  B33C 33CLBB  B  BffBBffB33B33BBBffCffC CBBBB  BffB  BffBC3BffB33CBffBBBBBBB33B  BffB  BB  BB  BffBffB33B䙚B  BBBffB33BޙB  BBBB  BffBffBݙB䙚B33BB  BffB33B֙B  BffB33BffBBؙBffBB  BffB33B33BәB  B33B33BBB33B  BffB陚B癚B  B33B♚B  B33BffBBffCCfC C	  BffC33CLC C C
ffC C3C33CLCC3CC  C33CffCCC3C CLC CLC CC	fC ffBBffBB  BffBffB㙚B33BffB䙚B33BBCfCBffBBBffBB33BؙBffBۙB㙚BߙBB  BffB  BޙB  B癚B33BBffBffBffBBffBB  BBB33BB  B  BffB  BffBB癚BBB  B33BffBB뙚B33BffBBB33B  BffBB晚BB33B  BffB33C3B  B  BBCC   CCfC33B33C C ffBBBffBBB噚BB  B33B♚BBffB虚B33BffB33B33BB  BߙB  B  B㙚BۙB  BޙBffB33BffB  B33BB  B33B䙚BߙBᙚB  B  B  BBBffB33BBޙBffBB  B33BB  B癚B陚B陚BBBffBᙚBffB33B33B33B33BffB  B  BffBffBBBffBffBBBffB33B33BBBB홚BB33BB33BBBB33BBffBBBffB홚BffBB  B  BB33BffBffBBBffBffB33B33B33BB  B33B  BBBffBB33B  B  BٙBٙB  BffB  B  BBffBffBٙBޙBB  BffB33B33BffBffBޙBBBҙBB  BB  BߙBB䙚B  BB33BB  BBB  B왚BB  BB33BBffB33BffB虚BBB  B  B  BꙚB33B왚BffB  BBBBffBBB33B33BBBBffBB  B뙚BᙚB33BB虚B  BB33B33B33B  BffBffBB  B33BffBffBffB  B  BB33BffBB33BffB33B33BBۙB  B33BٙBffB  B33BݙBܙBۙB  B33BffB֙BB  BBffBBB  BB  BޙB  BffBffBB癚B虚B癚BB33B虚B  B  BB33B33CBBC fC CLBffCCCC CLC3C CLCCCfC  CfCfCLC fBBBffBffBB  B33B  B陚B陚BBffB  B  B陚B33B33BffBݙBB33BffB♚BffB33BffB㙚BffBәBffB33B33BffBB  BffB  BffB33BffB  BΙB33B33BffBϙBffB33B  B  B33BBffBffB33BBBB33B  BB33B  BBB  B33B  C33CLCC3CffCfCC  CC
C
C
 CCCLC  C33CCCCCLCC33C 33C LBffB33BffB33B33BffB홚B  BBB33B33B  B33BffBB  BB䙚B  B䙚B  B㙚B  B  B  B  B  BBBBܙBܙBBffB33B33B33BffBffBܙB33BB33BffBBݙBffBBBBBB㙚BB33BB  B晚BBBBB  BffBꙚB  BBBBBB  B33C CCBC BC LC B  C BBB  BޙBffBՙBB  BBffB  BBB33BffB  B왚BffB  B  BߙBBffB֙B33B33B  B33B  BffB33BffB33BffB33B  BBffB  BffB  BBffBB  BffB33B  BffB  B  BB֙B33B33BffBffBB  BՙB33BՙB  BB  BٙBܙBBBB  BB  BffB33BBffB  BB33C BffCBffB  BB33B33B  BڙBB33BB33BܙB  BB  BBffBffBڙBٙB33BBԙB  B  BBB33BBffBB33BffBҙBB  BffBBffB֙BՙB  B33BffBBЙBB33B  BffB33BffBB33BBBffB  BffBBǙB  BffB33B  BəBffB  B33BffBB  BB  BffB33BޙB  BffB33B33B33B  B  B33B  BB33B  BB  BffB33B  B홚BB  CffCffCB33B33BB  B  BffB  BffBޙBBB33BffB33B33BޙBB33B  BؙBBffB33B  BؙBffBܙBܙBBffB뙚B33B♚B33BBB33BB  BB  B  BܙB  B  B33BffB  B33B  BffB33B33B  B33BܙBڙB33BBBڙBffBffBBٙB  BffB33BٙBBיBffBՙBBۙB33B  B  B噚B33B䙚BffB晚BffB晚B癚BB  B虚BffB33B33B33BffBݙBffBffBՙBffB33BB  BԙBәBBffBBB33BϙB33B33BffB  BB  B˙BʙB  BffBϙBffBB  B  BB͙B  B33BBffBΙBΙB  BΙBΙB  B̙BϙB  BBffBBB33B33B  B33BBBB33B  BB33B33BBffBBBՙB33BיB  BؙBffBffB  BB  B33B  B33BBBBffBBffBޙBffB  B33B33BffB33B33B33B  B33B33BBffBffBޙB  B  B  B33BffB  BԙB33BљB  B33BBBB  BffB33BB33BBBיBؙBffBڙB33B  BЙB  B˙BBԙB  BB  B  BBB33BffB  BffBB֙B33BЙBffB֙BffB33BܙBffBffBBB  BBBBBٙBB33B33B33BffB  B  B33BᙚB♚BffBffBB33B  BB噚B  B  B晚BBffBߙB33BᙚB33B  B33BffB  B  BffBBҙBffBBffB  B33BٙB  BBBffBffB  B  B33B33B33B  BϙBBљB  BffBЙBЙB  B33B  BBљBBffBffBBBՙB  B  BәBB  BۙB33BәBؙBffBffB  BB33BffBB  BۙB  BffB33BffB  BB33BB㙚B䙚BffB33B  B왚B  B홚B  B  B  B  BB  B  BB  B33B  B33BffB  BB33B癚BB陚B陚BffB  BffB  BffB陚B33BB陚B33BffB陚B33B33B33BߙBB  B  BBB33B33BԙB33BffB33B33BՙBffB33B  B33B֙B  BffBB33BffBٙBיBBB33BffB  B  BffB֙BԙB33B  BB33B33BBffBᙚBffB33B33BBffB  BꙚBffB  BffB33BBffBBffC CC3CC	ffC
33C
ffC3C	33CCfCffCffC3C3C C33CCC fC B  BffBffB  B33B33BBBffB  BffBB33B  BffB陚BffBffBB㙚BffB33BBffBffBݙB33BڙBBffBBۙBffBffBffBBffB33BffBBB㙚B  B癚B  BᙚB  BffBBB噚BBBBB33BB33B33C  CC CCffCLC3C CLC  C  C	C	3C	 CfCLC  C	C
C	3C	CCLCCfCCCffCCBB33BffB  BffBffBޙB  BؙBffBffB  BffBڙBffBC 3BffBB  B  B㙚B33BffBffB33B33BffBffBBBBBffBB  B  B  BݙBBBB33B33B  B33B  BB癚B  B홚B䙚B  B  B  B  BffBBBBᙚBBB  B33BBffBffB33BffBB홚BffBBffBB  BCC3B33BffB33BBؙB  B♚BffB♚BڙB  BיB  BיB33B  BB  B♚BޙBBffBBݙBڙBљBҙBffBBB  BffBffBffB  B33B  BffBBffB  B33B33BՙBffB33B  B33BBffBffBB  B33BB33BffBffB  B  BffB33BffBBؙBffBBB  B  B  C3CBBB33B33C  CCCfC33CLC
  C  CC3CffC33CC  CfCffCC  C
C	33C  C
C   BC33C  BB33B홚B뙚B♚BBBꙚB  B33B癚BBB  B  B33BᙚBB  B33BffB33B  B33B  B33B  B䙚B33BffB  B  B  BffB33BB33B  BffB33BBffBB  B  B33BؙB  BB33BB  BڙBBffB33B33B  B  BffB33B33B  BޙB33BB  BffC C33C3CCfCfC33C3C33CffC CfC3CC 33B33BBBBffB33B  B陚BffBffBB33BؙBffBB  B֙BB  BffBB33BffB33B  BיBffBffB33BB33BߙBЙBΙBљBB33BBB  B̙BffBB˙BffBffBffBBB33BBffBҙBЙBB33B33B  BBffBᙚB  B  B晚BffB  BffB홚B33BBB33B33BC  C  C33CLCLC	LC	CffBCCffBffC33B  BB33BffBffB33BBffB  BffBffB33BffB  B33BB  BB33B  BᙚBB䙚B  B㙚B  BB33B  B  BߙB  B33B噚B晚B㙚BᙚB  B  B  B33B  BߙB  B33BffBәBffB33BЙB33BϙBЙB  BЙBBffB  BnffB  BB33B33BܙBߙBB䙚B33B  B33BffB  BffBffBB♚BB䙚B  BffBffBffBᙚBffBBffB33BBffBBB홚B33BBffB  B  B  BffBB33BffB33B  BffBBB  BB33BBffBB33B33B  B  B  BݙBᙚBB33B33BBBffB  B33B33BB  BڙB33B  B  B33B33B33BB33BBffB33B33BљBffBB33BffBBffB33BיBB33BۙB  B33B  B  BffB  B  B33B㙚B  B33BB  BffBB  BffB33BB  B33BB33B  B晚BffBB  BffB33BB33BBffB33B  B홚BB  BꙚBffBBffB  BߙBBffBffBffBؙB  B  BՙB  B  B  B֙B֙B33B  BB33BB33BٙBBBՙBffBBffBffB33BҙB33BBBBԙBB  BљBЙBffBљBB33BB33B  BԙBffB  BffBffBffBffBB  BBBBBBC ffCCC3C   C  BffCffC  BCLCCffCfCC	ffCC3CC  C
LC3CCLCffC
C3C3BBBffC3BB33BffBffBBffB33BffBBB  BBBBffBffB33BBffB  BBBB33BBB왚B  B噚BB  B33B  B  B33BffB  BffBBᙚB  BffBffB33C33B  CCfC  C3C	3C CCC	LCC
ffC
fC33CffCLCC C CLC C&33C#33C& C(  C+C!fC3C  CCC  C33C33CffC"CLCCLC3CC B  B33B33BCC	ffB33B  B  B왚B  B33BffBffBffB33B  BffBffB33B33BBBCCC	CfBCCC BffC 33CffBBBffBB33B  BBBBB  B33BffB  B33B癚B  B홚B왚B  BffBBBC   CCCffCLCffCC3CC  C  CCfC 33CfCffC#C&LC$3C 33C"C!C33CC CffC3C  C	fC3C	fC 3BCC ffCfBffBC33CC CfCLBBffBB홚B  BB  B33BBffBB33B  BB33B  BffBffB33BܙB33B  B33B  BB噚BffBBߙB  BffBBBffBffBB♚BffBBݙBBB  B33BBffBB33B33BBBڙBffBڙB㙚BffBBBB  BBB33B  BBBffB  B33BffBffBffB33BBffBffB33B33BԙB  B33B33B33BЙBffBffBffBffBݙB33BޙBBffBB33BB  B33B  B  BffBffBᙚB  B33BffB  B33B  BffBB33BffBBffB  B  BڙB33BBיBBB  BיBB33B33BB  B  B33BffB̙BB33BffBǙBB33B33B33B̙BBЙBffB  B33BBBffB˙BB33BffBffB  B33BǙBB33B33BBB33BBB  BffBB  BB  BBffBffB33BB  BB33BB  B33BffBBffB33B  BBBB33BBffB33B33B  BffB33BBB33B33BB33B33B  BÙB33B33BffBB  BB33BB33B33BBffBffBB33BBBB  BffBBB33BffBB33BBBB33B  B33BBBB33B33BffBffB  B  BB33B33BBBBBffB33BffBBB  BBBB  BÙBBffB  BffBBB  B33B  BB33BBffB̙B  B  BBffB33BffB33B33BffB33B  BffBיB֙B  BՙBԙB33BffBffBffBBB33BBљBB33BԙB33B33BffB33B  BffBЙB  B  BffB33BffBffBffB  BffBffBBBffB͙BBffB33B  BffBffB  BffBB  BffB̙B  B͙B33B33B33BffB̙B˙B͙B33B  BffB33BՙBәBՙBܙB33B  BؙBݙB33B33BיBB  BܙB噚B癚BBffB  B33BffB33CffC33C33C33C33CffB33B  B뙚B癚BffB  BB  B  B33BBBB䙚BBB33BB䙚BB䙚B33BBݙBffB  B33BBBffBBB33B  B33B33BffB33B陚BBB  B33BB  BffBffB33BffB  BۙBBՙBBϙBљB33BљBЙBB  B  B  BϙB  BffB  B33B  BB  BB33BBB33BBffBffBffC CCLCfC  C	 C	fCC	fC CfCCCC33C  CCffCLCLC C3CffCC 33CC B  CfC BBBB왚B33BffBffBB  BBC33B  B  C33CffC C fB33BߙB33BffB晚B33BݙBB  BffB♚BB  BffBB33B  B  B  BBۙBݙBffBBffB33BffC LC CC33CC
ffC3CffC CCBB  B陚B  B  BBBffBBBffB33B33BBffB  BB  BB虚BBffB晚B癚B33BBBBffB♚BB33BޙBޙB33BٙBffBffBؙBBB33BڙBffBݙBffB  B33BffBB  BffBffBffB  BיB33BffB33BffB  BٙB33BffBffBBB33B33BڙBffBffBBB33BffBffB33BB33BBffBffB  B33BҙB  B33BffBәB  B  BB  B  BԙBәBffB33BffB  BܙBB  BffB33B  B  B33BB왚B  B뙚B33B  BBB  BBB  BB  BڙB33BB  BBB֙BBәB33B  B33B33BיB33B  BffB33BffB  BBffB  B33BљB33BffBffBffB33B33BҙBffBffB33BffB  B33BffBBB֙B  B33B33B  B  BB  BBBB  B  B  B33BffBؙBffBB33BffBٙBffBBffBB  BBffB33BBffBBBffBffBB33B33B33BB䙚B  BffBBB33BB  BffB33B33B  BffBB33BޙBBffB33BffBB  BffBԙB  BԙBԙBBљB  BBB  B  BffBffBffBԙBҙBB33BffBәB33B33BB33BffB33BB33B  BffBffBffB33BϙB33BΙB33BBؙBffB  B  B  BffBffB  B  BffB33BB33BffBB  BB33BffBffB33BffBffB虚BB33BBffBB33B33B33B  BBffB33B  B  BffBffB  BffBB33BBffB33B  B33BBffB  B  B  B  B33BB홚B33B홚B33B  BBffBB  B  BffB33BB33B33B晚BB䙚B  BB33BffBB  B  B33B  BB  B  B33BՙB33B  B33B  BB33BۙB33B33BffB֙BۙBBffB  BffB33B  BffB33BBϙB33B  BffBBffB33B33B  B  BBffB33BҙBBffB33B33BB  BBB33BBffBffBՙBffB33B  B33BՙB  B  B33B33B͙BЙB  BffBffB33B33BϙBљBffBB33B33BffBBffBffBffB33B˙BB  B33BB33BffBffBƙB˙BffB33B  BffB  BBffB33BB33BffB33B33B33B33BәBB  B  BB33B33B33BffBՙB33B  BәBәBԙB֙BffBBffBffB  B  B  BBBffBffB  B33BBљBBffBܙB  BffBəBffBəBB  B̙BҙB  B33B33B33BffBəBBÙBB  B  BB33BB33B33BƙBB  BB  BƙBffBffBBșB  B33BB33B  B  BffBBBffB  BffBffBڙBۙBffBBffBBߙB  B33BܙBffBB33B  B33BB  BBB  BBܙB33BߙB33BBB33BBәBҙB  B  BՙBffB33BBffB  BffBڙBٙBBBٙBffBٙB33B  BۙB  BffBffBffBffB  B  B  BffBffBffBBffBffB33B̙B33B  B33BΙBffB33BffBffB  B  B33BBffBffB  BBffBffBB  B  BBffB33B  B33BffBBB33BʙBffBB33B˙B˙B̙B33BʙB̙BΙBffB33BffBBϙB  BffBffBffB  B33BљBffBΙB͙B  B  B  B  BffB33B33B33B  BffB͙B33B  B  BB33B33B33B  B33B33B33B  B33BffB33B  BffB33BÙB  B  B  BffB33B33BB  B33BƙBB  BffBB33B  B  BBęBffB  BffB33B˙B̙B33B  B33BffB͙BB  BB33B33BffBЙB33BffBffB  B33B33BәB33BB33B  B֙B  BffB33BB  BffBәBBffBffBBBBBffBffBBәBffBBffBBՙB  B33BՙB33B֙B  BffB33B֙B33BB֙B  BBB  BffB  B  BffB  B33BffBBffBffB33BBffB  B͙BB  B33BffBBBљBffB33B  BBBҙBffB  B33BיB  B  B33B  BؙBffBB뙚BBBۙBffB33BؙBәB33B  BBffBBBB  BffB  B33B㙚B  B33BڙBffBBB33B  BڙBۙB33B  B֙BB  B33BB  B33BffB  BҙBffB33BBՙBҙBB33BffB  B33BffB33BffBffBBϙB33BBЙBЙB  BBBЙBffBΙBBϙBϙB  BB  B33BBffB  BffB33B  BffB  BffBљBBBәBՙB  B֙BٙBBB  BffBBffBߙBߙBffBB  B  B  BBB33B  B33BBݙBڙBۙB  BffB  BٙB  BיB  BBffBՙBffBffBBޙBB33BffB  BәBԙB33BB33BB33B33BBffBB  BffBBffBB33B֙BBB33B33B  BBҙBB33BffB33BffB33BB33B  BB33B  BBBBՙBB  BיB33BΙBffBBB33B  BBffBffBffBљBffB33BffB  BffB  BffB֙B33B  B  B33BB33B  BڙBٙBBԙB  B33B  BBљBәBՙBffBffBԙBffB  BB֙B33B33B  B  BBBffBәBffB33B  BԙBBՙBBB  BՙBffBיB33BffBffB33B  BϙBffB  BBBffB33BBB͙B33BffBBؙB33BBBffB33BffBffBBB33BffB˙B  BBffB33B  BϙBffB  BB33BffB33BB33BB  BffBB33BB  B33BffBBB  BBffBffB  B陚B  B33B  BB33B  BffBޙB  B33B  B  BffB  BՙBBB33B33BBB  BffBڙB  BۙBBB33BיB33B  B33BB33BBffB33BԙB33B  B  BBB̙B  B˙B  BffBffBB33B  B33BffB33BffB  BBffBٙB33B33BٙBՙBffB33BBљB33BҙBffBffBBffBffBffB  B33BffB33BffBݙB  BBߙBBffB33BݙBݙBޙBޙBB33BݙBffBBܙB  BffB33BBffBBB  B  B33B33B33BB  C3C3BB33CfC BffB33BB  BffB33B33B33BәBB  BBBBffBB33BB  B  BffB  B  BBΙB  B̙B  BBffBffB33B  BԙBB33BBB  B  BB  BffB33BffBԙB  BffB  BBffBB33BffBffBۙBBBB  BBB  B33B♚B33B  B33B  BڙB33BBffB33BݙB33B  BؙB33BՙBәBҙBәB33BٙBB33BffBffBffBBBffBB  BΙB33B33BЙBBffBB33B  BffBffB  BffBffB33BՙBB  B  BffBBܙBffB33BBԙBBB  BffB33BޙBffBיBۙBՙB33BffB  B33BffBB33B33B33BffB♚BBffB홚B  B  B  B33BffBBB  BffBBBB  BffBBB33BffB33BffBBffB33BB  B  B㙚BBffBBffB33B  BffBBBffB33BB㙚BBᙚBffBBffB  B  B  BڙB33B  BۙBffBffB33B  B  BffB  BܙB  BәB33BB֙BffBBBB33B  B33BBB33B33BᙚB33BffB  B  B䙚B33BBB  BBBffB  B33BB癚B  B  BffB  BB33B33BڙB33B  BffB  B  BffBܙB33B  B33BB33BBffBffBffBffB  B33BffB  B  BffBיB33B  BffBffBәB˙B33B  B  BffBBffB33B͙B̙BffBB  BffB33BffBB  BBəB33BǙB33B  BBffBǙB33B33BffB  BB̙B33BffB33BB  BffBB  B  BBffBffBΙBϙB33B  B  B33B33B  B  BB  BBffB  BϙBffB33B  B33BՙBffB33BffBffB33BBffB33BffB  BݙBffBBٙBBיBffB33BB33B  BB  B  BؙB  BٙBffB33BBՙB33BffB33BؙBffB33BB33BәBB  BљBffBffB  BffBffBЙBљB  BԙBҙBffBBB  B  B͙B  BBϙB33B33B̙B̙B  BBffBffBffBBffB˙BffBB  BəB33B  B33B33B33B33BB33BffB  B  BffBB  BffBBęBęB33B33B33BəBffBffB  B  BffB͙BB  B͙BB  BffBBBBBffBBBBęB33BffB33BffB  BəB  B33BBffBB33BBffBB33B33B̙B  BffBʙBB33BB  B  B33BBBffBBffBƙBșBəB  BBB  B33B33B33BB  BffBǙB33BB33B  BșBB33BǙB  BřBffB33B  B  BffB  B  BBřB33B  BffBffBB  BƙBÙB33BffBffB33BffBB33B33BffB33B  BBƙBǙBÙB33BffBBB̙BB  BΙB  B33BffB̙B͙BB  B33B  BBffBיBBB33B  BBՙBBיBffBffBffB33BԙBәBљB33BәBffBBBffBffB  B  BffB33BBۙB33BڙB  B33B33BffBffBB홚BBB33BffB33B33B33B  BᙚB晚B33BBffB33B  C CfCCC fC  C33C3BC  BffBC 33C   CBC	3BffCfC fB33B  CC CfB33B  BffBBәBϙB33B  BBәBBffB33B33B  BffB֙B33B33BBffBݙBffBffBB䙚B  B  B33BffBB33B֙BffBB33BffB  B  B33B  BffBBffB䙚B晚BffBB33BB  BffBffBB홚BBffCLBC  CfC CffC3C
C33C33CLC!C,ffC/ C2 C,ffC*C)  C$C33C  C  C	C CCC3C
3B33BffB33BffB33BBB噚BBCLC	C3C  B  BffBBB33B䙚B  B䙚B䙚B  B33BffB  B33BꙚBffBffBffBB33B噚BffB  B  BBBB33BڙB  BffBffBffBߙB  B  BܙBffBBBB䙚B  BB  B33BB  CfCfC
LC
fC C
LCC33CCC3CLC C C33C33CC3C  CLC  B  C3CCC3C 33C  CC C	 CffBffCLBB  BBB  BffB33BffB  BB33BffBffB癚B왚B홚B  B  B晚BffB  BB  BffBffB  BffBݙBݙBffB  B  B33B  B33BәBΙB  B33B33B33BؙBٙBBffB  B  B33B33BޙB33BۙBޙB33BffBᙚBffBffB33BBffB33BB33B  BffBB癚BffBffB33B33B癚B癚B33B33BffB33BB噚B噚BffB  B33B33B  BffBҙB33B  BffBffB33BBBffBffBffBؙBffBՙBffB33B  BffB33B  B  BљBffBB  B33BBffB  B  BՙBffBљBљBљB  B33BЙBҙBҙB  BЙB33B  BffB  B  B  B33B  BffBBBҙBљB33BәB  BffBB  BԙBҙBB  BB֙BәB  BB33BԙBBՙB  BB33B  B  B33B33BffB  B33BʙBffBffBffBBffB33BffBBΙBЙB33BffBBBәBffBљB  B  B  BB33BB  BffBԙBB33BәBB33B  B33B33B  B  BBffB  BBBB33BBB33BB  B33B33BҙB  B33BffBՙBBԙBBffBffB  BBBffB33BԙB33B  BBיBffB33BؙB33B33BBBݙBBffB  B㙚BB晚B33B  B  B癚BffB33B뙚B33B  B33BffB33B㙚BffB  B33BᙚB  BBB33B33BBffBffBיBBBB  B33BBffB  BffBٙB33BڙBBBffB  BؙBffBffBffB  B  BffBٙB䙚B33BٙB33B  B33BffBffBBBݙBffB33BיBBBBB  BBB33BޙB噚B陚B33B  BffBܙB  BڙB33BBBffBBffB  BffB  BB噚B晚B  BB  B33B  B33BꙚBffB  BffBffBBB  BffB  BBffB֙B33B  B  B  BB  BB33B33B  BҙBՙBԙB33BәB  BffBffBBffBB  BBffB33BffB33BffB33B  BffBffB  BBЙB  BBϙBffBB  BffB  B  B33BҙB  B  B33B33B33BޙBڙB33B33BڙBffBffB  B  BffB  B  BffBffBBBBffBꙚBffBffBڙBBߙB  BBBᙚBBBBᙚB33B  BBffBBffB  B33BBBۙB㙚B33BۙBBffBљBffB  B  BffBffB͙BBffBffB  B  B33B33B33BΙBffB  B̙BffB33BșB  B33B33B33BB̙B33B  BəBffB  BǙBәB  BЙBЙB  B˙BffB  BffB33B  B33BBffB  B33BffB33BBffB33B33BffBؙBBffBffB  BffB33BB  BB33B33BffB  B  BB  B33B33BBۙBffBBffBؙB33BffBҙBBBϙB33B33B33BBffB33BBffBЙBB̙BΙB̙B  BΙB33BffB33B͙BffB  B  BffBffBəBBęBffB  BB33BșB33B33BBBBϙB33BffBffB  BffBՙB33B33B  B  BB33B  BffB  BיBߙB㙚BBB33BۙBBؙBBٙBffBB  BᙚB  B虚B뙚BffB  BBBB  BBBBffB33B33B33B33BffBBB  B  B䙚BB33BߙB  BffBffBBffBBffB33B33BffBBffBffBBB33BݙBBffB33BB  B  B  B33B33B33B̙B  B  BB  BB33BffBBffB  B33BffB33BffBffBݙB33BBffBffBB  BB晚BB33BBffB33C 33B  B33C3CCffCLC  C fB  B33CffC  C3BB  BBBffBB33B陚B陚BBffB  B  B33B  BBffBBffBBޙB33B33B  B33B  BB  B  BיB33B  B  B  BffBffBffB  BB  BffBәB  BffB  BB33B  BB33BՙB  B33B33B  BәBיB֙B  BB  B33B  BffBڙB晚B33BݙB33B  BffB  B  B  B33BᙚB  BffBޙB33BB33B  B33BB  BݙB  BffB33B  BܙB33B33B33BffB33BBffBۙBBB  BffB  BB33B33B  BؙBәBffBB  B֙B  B33BBߙB33B  BBffBB  BBB33BݙB  BffB  B33BffBB  BBffB33BBؙBؙBBBffBؙB  B33BffBffBffB33BB33B  BЙB33BB  B  B  B  BݙBBݙB33B33BffB33BB33BBݙBݙB33B  BffBB  BB  BBBڙB  B  BffBBffB33B33BffB33B33BffBBB  B  B䙚B噚B  B  B㙚BBffBffBffBffBߙBffB33BߙBffB  BܙBBBBffB  BffB33B  B33B33B33B33B33B33B  B  BۙB  BB33BB  BڙBܙB33BffBBffBؙB33BffB  BffB33BϙBB33BB  BB33B33BffBffBffB  BffBB33BffBB  BϙBB33B  B33BffBB33B33B  BBffBffBԙBBffBB  B  BffB33B33BBBffB  BBۙBܙB33B33BffBڙBBB33BffBffBffB  BffBՙBBffB33BәB  B33B  B33B  B33BB33B33BB33BʙB  BffBљBBffBB33B  BB  B33B33BșBBffBBBBҙB  B  B͙BffBϙB̙BffB͙B˙BffBffBB33B  B  BBƙB33BBB˙B̙B33B  BBffBƙBÙBǙB̙BϙBffBffBՙB33BffB  BB33BәBB33BffBffBffBBBffB33BB33BܙBBffBᙚBۙB33BffBٙBffBBٙBffB  BܙBڙBؙBәBffB  B33BٙB͙BB33BB  B  BܙBߙBBB  B33BffB33B♚BޙBffBffBffB֙BB  BؙBffB  BB33B  BٙBB33B  B  B  BЙBљB33B  B  BՙB33BB33BffB֙B33BәBffBffBffBBffB33BBBB33BffBffB  B  BffBʙBffBffBԙB33BffBיBB  B  BffBffB33B  B  BBϙBffBBBffBBBffBϙB33B  B͙BffB33BәBffB  BffB33BffB˙B33BBB33BBBBBB  B  BљB  B  B  BffBffBffBffB  B  B33BffBBBffBBҙBљBљB  BB33BB˙B  BBffBșB33BəB˙B  BB͙B  B̙BBƙBffB33BffBBB˙BffB33BΙB  BB˙B  B33B  B  B33BBʙBʙB˙BșBffBffB  B  B  BffB33B  BB33B  B33B33BffBBB˙BffBffB33BffB  BffB  B  BffB33BBBB33B33BәB33BBřB  BBffBffB  BB33BBB  B  B33BBB  BffB33B33B  BԙB  BBffB֙BB  BBffB  BffB  B33B33BљBBBffBB̙B  B33B͙BBffB33BBBBBʙBșBəB  BBșB33B  B  B  BBřBffBffBBffB  B  B˙B  BffB33B  BffBB  B  BBffBBיB  B33BffB33BܙB33B  BB33B33B  BffB33BB  BffB陚B33C fCfCC33CCffCffCLCCffCfC CCLB  B  B  B33BB  B  BߙB  B  BffBߙBffBᙚB  B  BffBB33B  BffB  BB33B33B晚BBܙB33B  B  B33B33BffB33BB33BB  B33BB33BڙBB33B♚B33BffBBB홚BffBB  B  B  B33BffBffC33C
CC  CC&LCC!C"LCC&C-  C7 C?ffC6C-C%C<C
LBffC3B33C  BB  B33BC  C C,  CCC	CC,3C3CffCC 33BBB  B  CffC 33C 33B  BB  B  B33BBffBffB33BBBffBffC B  BB33BBffB33B  BBB  B33BB33BffBffBBB33BۙBffBBBffB  CffC33CLCfCfCffC3CC
C	33C C  BffB  C%CLC-LC.fC"33C$  C4  C- C3fC4BffC
B  BffB33C3C  CfCLC33B33C  CCffCCfC BBBffB  B33B33BB  B  BB癚B33BBffB  B33BB  BBBffCfBffBB  BffB뙚BffBB  B  BBffBBBffB33B  BffBffBB홚B  BB33BffBffBBB33B33BffB33C LC CCLC CfC  CCfC
 CCC3CffC33C!C#C&C&C  BBffB  BC3CLBffB  B  B33B  B33C
C  CffCC
CfC3C3BffC3B  BBC C3BC BffBB  C  CB  B33BBffB  B  B  BBB33BB33BffB  BC3BB  BffBCC  C B  CCfC   C ffB  CCLC
C3CCffC	3C
  C33B  BBffBffBffB33BffC LC
  CCffC  CLCLC
ffC3C#ffC)33CC
C3CLB33BCLBC 3BffBB33BBB  BB33C 33BffC LCfB  BޙBB33B  B  CffC	CB  BffBffBB33BBBffBB33BffC33B  BB33BB  B33BffB33B  BffBB晚B  B♚B  BݙB33B33B  BߙB33B33B  BBBB33B晚BffB  BB  CLC CB  CCLC C3CLCfC33CfCfCLCfCffCC' CLC3C2C4ffC*fC B33CCffCfC3BBB33BBBB33BffB33BޙB  CC  CC C C
33C CffCLCLC3BBBBBBB噚BB  B  BBffB33C3CCffBffB33BBꙚBffBffBffBBBffBB  BܙBBBB33BffB33BffB33BB  BffB  B33B  B  B  BffC   BB  B  C  C33B  CffCLCffCC3CfCLC$ B  BBٙB  B33C B33BߙB  BffB  B33B  B33B  B33CffCCffC  BB  BCCLCLB  B  B  BffB33BBB  BBB陚B噚BB晚B33B  BB33B  BBffB  BB癚B  BffB陚B  BB33B  B33B  B33BϙBBBffB֙B33BB33BәB33BffB33B  BᙚB33BB  BBBffBB㙚BB  CC
3C  CC3CfC33CCLCLC3C  CCCLCffCffC C33CLC  CffC
CLC
CCfBBB  B  BffBB33BB  B  BBBffBיBۙB  BܙB  B33BڙB  BBBffBffB33BיBؙB  BB癚B  BBB  BffB晚BffB  BיBffBB͙B  BՙBffB33BԙBBٙBffB  BffBB  B  B뙚B뙚B  BffBBBBffB33BffB  BBBB  BB陚B33C  CffCfBC fB33BB  B噚BݙB  BBBݙBffBB33B33BffBB33BBB  BBffB䙚B  BffBffB  BB33BBBBᙚBffB  B  BܙBBۙB  BBBۙBffB  B  B  B33BΙB33B  BffB  B  BәBԙBBffBB33BffBBҙB  B  B33BffBffB  B֙B  BffB33B  B33BЙB33BəBB  B  B33BffBЙB  B33BffB͙B33B33B33B  BffB33BᙚB  B晚B  BᙚB  BޙBffBBBffB  B  BB  B33B  BٙBϙBB  BܙB  BؙB33BB33BBB  BԙB֙B  BәB  BҙB33B͙BffB  B  B  B33B  B  B33B33BffB֙BؙBffBԙB33BݙBffB  BffBffBؙBB33BיBٙBffBB֙BBڙB  BՙB  B  BBᙚB  B㙚B㙚B33B♚B♚BBffB33BBיBݙBBffB33BڙBܙBB  B  BؙBffBޙBݙB  BBB  BffBۙBBB  B33BBڙB  BڙBffBBBBBB  B  B33B33BϙB33BffBљBBљBffB  B˙BffBșB  BffB33BffB  B  B  BBB̙BffB33B33B  BB33B  B33B˙BffB33B33B̙B  BB33B  B33B  BB33B33B33B  BffBB33B33BBԙBԙB  B  BffB33BB  B33BB  BB33B㙚B33BB  BffB33B  B♚B33B33BB33B  BBޙBߙBffB33B33BffBۙB33BۙBۙB33B33B  BB  B33BffB  BBҙB33BЙBffB33BB33BҙB  B  BffB  B33BBffBffBљB33BffBB  B  BBffBBffBffB33BffBffBB33B33BϙB33BBffBffB33BffBٙBffBڙB33BBffBޙB33B33B  BB33BܙBffB  BBٙB33B33BٙB33BffBؙBBffBՙBBffB  BԙBԙBՙBB33BB  BBB33B  BffBΙBBB  B33BB  BB  BBffB  BffB̙BəB33BffB  B  BffBffBBB  B  BffBffBB  B33B  BBB֙B  B33B33BffBffBffB33BՙBԙBffBB  BffB֙B̙B  B33BBڙBffBB33BffBBܙBBڙB  BffB  BffBffB33BffBיB  B33BffBB33B  B33BffB  B33BљBB33BB  B˙B  B33BəB˙B33B  B  BffBffB33BffBffBffB  BBB33BB  BB33BBffBBffB  B33BBB  BffB33BffBΙB33BB33B  B33BBB33BԙBԙBҙBՙBffB  BBffB  BffB  BffB  BBBٙB  BBޙBBffBB33BBB  BԙBffBffBԙB33BBՙBffB  B  BЙBәB33B  B33BBB  BBЙBҙBՙBffBffB̙BϙBB33BʙBffB  B  BЙB33B  BffBљBffBffBBƙB33B33B  BffBBffBÙBB  BffBffBBffBʙBffBB  BffBʙB  BʙBΙBffB  BҙBffB33B  B33BؙBffBffBB33B33B33B  B  BBffB  BۙBۙBffBԙBB  BݙB  BBB  BffBޙBBBBffB33B噚B♚BB33BffBBffB癚BꙚB  B  B  B  BffB33B  BffB  B  B33B33B  BٙB˙B̙B  BB33B  BBәB33B֙BffBB  BffB33B33B  BffB33BffB33BBffBffB  BBffB33B  B  B  BəB33BBB33BffB33B֙BffBיBڙBۙB33BڙB  B噚BB  B♚BffB33B33BB㙚B  BꙚB  B33BffBB䙚BꙚB뙚BBffBBBBBffB  B㙚BߙB㙚B♚BᙚBBffBffB  BBBB  B  B  BBffBB  B  B33B33B33BB33B33BB  B33BBffB33BB  B  BffBB  BřBřB  BBffBǙBffBəBffB  BB֙BffB33BBB  BB  BޙBffB33BB  BffB홚BffB33BꙚBBB33BBffBffBB  BffBB33B  B홚BffB  BffB㙚BޙB♚BffB33BBB  BBffB  BB  BffBffBᙚBBBffBBB晚BB33B噚B33B  BBffB  B33BBߙBޙBffBBBffBۙB  BffBffBffB33B33BffBיBffB  BBB33BffBᙚBBffBBB晚B33B  B  BffB  B  B  BffBB  BffBffBffBڙB33BڙBB33BffBBB㙚BBBBߙBBffB33BޙBffB33BޙBޙB33BיBB  BffBBBBBߙBffB33B  B  B  BffBffBB  BBԙB33B  BљBffBҙBЙB  BffBљBBљB  B  BB33BB33B  B33BΙBffBffBΙB  B͙BBB  B  BϙB  BBffBB  BҙB33B  B33BffB֙BיB  B  BٙB  BڙBۙB  B33BB33BޙB  B  B  BBffBffBffBޙB  BB33BffB  BffB֙B  B  B33BB  BBffBffB33B33B33B֙B  BҙBffB33B  BBB  BBԙB  B33B33B  B  BffBB  BB  BffBffBffBBљBBBΙBB  B˙BəB33B  B33BffBffB  B̙BffBffBǙBB33BffBffB̙BffB  BBB͙BffBffBffB  BffBB33BBΙB  BffB33BB  B33B33B33B33BffBffBBBՙB33BffBʙB33BffB33BBffB  B33B  BϙBϙB  BB  BB33BffBffBffBB33B33B  B  B̙BffB33BǙB33BəB  B33BęBęB33BBəBffBffBB  BʙBB  B  BBBBB33BB  B  B  BffBffB  BB33BBffB  BB  BΙBęB͙B  BB33BffBB33B  BffBBBffB33B  BffB  B  B  BΙBЙB  BBffB33BϙBB  BҙBәB  B33B33BBBٙBB33B  BffB33BљB  B  BљBffB33BBB33B  B33B  BffBffBffBBB  B33BB33B  B33BԙB33BBB33B  BЙB  BffBffBљB33BffB  BBBffB  BәB  BЙBB  B  BBffBٙB33B33BB  B  BffB33BՙBәBffBΙBәB33BBҙB33B͙BBffBffB33BBBB  BB  BffBΙB33B33BBBffBBffB  B  BBBBffBffB33BffBљBffBffB33BffBB33BB33B  BBB33B33B  B33BffB  BB  BB  BffB  BffBffB33BffB33BB  BB  BB  BBԙBיB  BBʙBffBffBffB33B33BffB  B  B  B33B  BffB33B33B  BffB33B  BәBљB33BיB͙B͙BBϙBffB  BffBffB33B33BҙB33B  B33BffB33B̙B  B  B̙BڙB  BffB˙BәBBB̙B33BffB33B  BęBÙBB  BBB  BB  BffBB  B  B33B  BB33B  B  BڙBffBҙBBffBffB  B  B33BϙB  BffBffB  BBB  BB33B33BffB33BffBB33BBffBffBffBΙBΙBBB33BffBB33BB͙BBəB  B33BffBffB  BffB  B  BffBB33B  BffB  B33BřBřBBffBffBʙBBffBffB33B  B33B  B33B  BffB  BBffBҙBffBffBB  BB33B  B  B  BffBffBBffBיBffBיB  BٙB  BffB33BؙBffBffBffB33BԙB33B33B  B  B֙BB33BB  BBffBBәBffBҙBљB33BB  B  B  B33BBBffB33BBffB  B33BBB͙BffB  BffBBϙB  BBffB  B  BBǙBB  B33B33BffBB  BffBffBBBB  B33BǙBBB33BBəBffB33B33BΙBffB  BffBBB33BՙBffB33B  BڙB  BBB33B33B  BB  BffB֙BffB33BffBB֙BB33B33BffB  BffBԙB  BBffBBәBBBffBffB33BBB  BffB͙B33BffB  B33BșB  BffB33B  B33B33BBșBB  BǙB  BffBBffB˙BffB˙B˙B  BB33B33BBBBffBBǙBffB  B  B33B33B33B  BffB  BffBB33B  BBffBB33B  BffBffBffBffB33BBB33BڙBBffB33BB33BffBB  BؙBBffBffB33B֙BffBՙBBffB  BBٙBB33B  BəB  BffBΙBBffB33B  BB33B  BBBffB33B  B33BB33BffBffBffB  BffB33B  B33B33BʙBəBffBffB33BffB  B˙B  B  B  B33B  BșBǙBșBϙBϙBЙBffB33B33B  BBՙB33B  BיBB  BۙB  BޙBffB  B33B33BBBٙBBB33BffB33BffB33BۙBffB  B33BڙBؙBٙBffBٙBٙBBؙBBB33BB  B33B  BBBBffBffB  B33B33BffB33BB33BϙBBB  B33BffB  BffB  B  BBBffB33BB33BffBffBffBB33BəB  B33B  BϙB33B  BffBϙBffB33BЙB33B  B  B33BffB33BЙB  B  BB  BffB  B  BBBҙBԙB  B33B33B33BffBB33B33BB  B  BB33B  BB33BffBBƙB33BffB33BBǙBřBffBBB33BB  BBB33BBffBffBřB33BffB  B  B˙BəBșBBffBffBffBșBffBB33BffBB  B33BB  BBÙBÙBffBffB˙BBffB33BB  BǙBʙBffB  BffB33B33BffB͙BffB  B̙B͙B  B33B33B33BәBBЙBffB  BB33BЙB  B33BҙBЙBffBBЙBЙBffBffBBΙB  BB  B33B  BΙB͙BB  BffBЙB  B͙B  B33B33BffB33BB  B33BffBʙB33B33B  B  B  BǙBǙBșBffB33BffBffBB33BffB33BB33BffB33BęB  BBșB33B33BffBB  BƙBƙBBBB  B  BffB͙BBΙBffBBffB  BϙB33BB  B33BBffBBB33B33BؙB33BffBB  BffBffB  B  BffBBB33B˙B  B  B˙B33B  BffBBB͙B  B33B33BBBBBәBffB33BffB33BBffBffB  BB  B33BffBB  BBffBB33BB  BffB33B  BB  B33BffBffBffB  BB  B33BB33B33B  B  BB  B  B  BffB33BϙBϙBB  BBffB33BBBՙBB33BBB֙B33B  B  BffB֙BՙBffBffBBffB33B  B33BBՙBԙB  B33B33BЙBЙBЙBBϙBϙB33BBffBBЙBΙB  BB33BffBffBΙBffB33BB33BϙBϙBB33BB˙BffBBBffBffB  B͙BffBB33B33B33BffB  B33BffBЙB  B  B  B  B͙BffB  B  B33BffBB33B  B33BB  B33BיBBؙBffBۙBۙB  BBffB33BBBۙB33B  B33BBffBٙBBB  B  BBffB33BٙBٙBBB33BffB33BffBffB  B33B33BffBBՙBՙB  BҙB33B33BBB33BffB  BBB̙B̙BffBBB33B͙BffB̙B˙B33B33BșB33B  BffB̙BBB  BʙBəBffB  B33B  B33B  B  BBffBffBΙB  BffBffB  BB  B33BҙBB33BffB33B  BՙBffBՙBffBBB33BBffB  BffBffBBffBffBffBB  BffB33B33B33B33B  BΙB  B  B  B33BffB33B33B  BffB33BffB͙BffB  BffB  BB  BB33BffB33BəB33B˙B33B33B33B33BffB33B33BBBǙBǙB  B  BșBBęBəBƙB33B  BffBBffB33BBffBffB  B  B33B33BBBϙBљBB  BffBΙBљB  B33B  BffB33BffBљB33BҙB  BBBBBBљB33BЙB33BBϙB  B33B33BΙB33B  B  BʙBffB  B  BffBB̙BffBB33BffBəB33B  BffB˙BBBǙB  BB33BB  BBBBffBffBffBffBBB33BffBǙB  BffBffB33B33B33B33BљB33BffBB  BΙBffB33B  BffBffB  B33B  BffBʙB33BffBffB33B33BffBffBՙB  BffB33BffB33B33BљB  BԙBB33BffBBB  BBffBҙB33B͙BffB  BBffBBΙB33B̙B33BǙBBʙB33BșBB33BBffBʙB  BǙB  B33BffB33BffB  B  B33B33B33BffB  B  BffB  B33B  BB33B  BffB33B33BffBffBffBBffBЙBffBffB33B  B33BЙB  B33B  BffBBB͙BffB33BBΙBBΙBΙB33B33B33BϙBϙBB33B̙B  B33B̙B33B33B  BB33BffB͙B33B  B  B  BffBϙBffBBљBBҙB  BB33B  B  BffB  B33B33BffBffBљBљB  BB33BBffBљB  BљB  B  BB  B  B33BBBϙB33BəBB˙B  BʙB˙BB  B  BffBB  B33B˙B  BҙB33BҙBҙB  BffBBffB  B֙B33B33BB33B33B33BיBffBB  BBBՙB  BB33BffB  BffBؙBB33BٙBؙBffBB33B  B  BBәBffB33BffB  B33BffB  B  BϙBffBffBəBffBffBffB33BffBffBəB33BffBffB˙BffB˙B33BB  B33B33B̙BffB33BBB33BΙB33B  BB33BљBffBB  BffBffB  BәB33B  BffB33BәB33BBBB  BәBffB33BB  B33BBffB33B  B  B  BB  B  BffBBBB33BB  B33B  BB  BffBB33B  BB  BBffBffBϙBffB33B33B33B33BBB33BʙBB33B  BϙBBΙBB˙B˙B33B˙B33B  B  BffBBBffBB33BffBB  B  BϙBBB33B33BЙBB33B  BBffB33B  BffB  B33B˙B̙BBBffBљBљBљBљB33B33BՙB33BB  B33B33BԙBBBԙBffB֙B֙BיBffB33B  B33B33BffBffBؙBB33BљBԙB  BffBBBffBՙB  B33B  BԙBffBBffB  B˙BffBffB33BǙBBffBB  BffBB33BƙB  BB  BęBÙB̙BffBffBΙBB̙BBffBB33BBffBffBB  B  B33BBәBffBBffBBffB  BffB33BЙBffBәB33BffBיB  B  BB  B  BffBՙB  B֙B33B  B  B  B  B  B֙BיB֙BB33BffBB  BBffB33BffB33BB  BB33BffBffB33BBBffBffBB33B  BΙB33B33BBffB  B̙B33BəB33B  B˙B˙B  BffBffBB33B  B33BBffBffBBffBBffB  BЙBǙBBB33BBffBffBBffB33B  BB33B  BffBBB33BBBffBBffB33B͙BΙBffBљBB33B33BffBϙBB  BffBffB֙BBB33BffBffBЙBffB33BBffBffB  B͙B33B  BBBBffBB̙B33B  B  B33B33BBffB  B33BffB33B33B  B33B͙B33B33BffB  BBffBיB33BBBԙBәB33B  B  B  B33B  BffBBB33B33BΙBffBffBBffBƙBBB  BB  B33BB  B33B33BffB33BffBffB  BffB33BffB  B33BffBBBffB33BffB  BBBffBBB33B33BB33BffBffB̙BffB33B33BB33B  B  BffB  B33B  BffB  BBϙB33BΙB  BϙBB  BffBffB33B  B  B  BffB33B  BffBB33B  B33BffBB33BҙBBBffB33B33B̙B˙BBϙBffB33BЙBffBffBffBffBBBΙBBЙB  B  B33BBΙB  BΙBffB̙B͙BB33B  BBʙB  BffB̙BʙBBBԙB33BљBљBԙBBB  BBՙB  BffBיBיBBB33BؙBffBB  B  B  BB33BffBffB♚BBffB䙚B33BBffBffBffBؙB33BB  B  B  BBڙBٙBffBB33B33BffB33B֙B33BBәB33BәBԙBBffB33BBB33BB  B  B  BBBҙBB  B33B͙BffB͙B33B  BffBΙBffBBʙB  BB  BϙBϙB33B  BәB33B33B33BffB33B33BԙBҙBΙBffBԙB33BBffB33B  B33BBffBB  B33B33BffBיB  B33BB33BBffB33B  B  BffBB33BBBffBΙB  B33BBB  B33B  B33BffBΙBffBffB  BffBЙB  B  B33B  BB  BB33B33B33B33BBBBBBBB33BљBB  BffBBBϙBЙB33BB͙BffBffBЙB  B33B33BB  BffBBB  BBBffB  BB֙BۙB33BB  B  B  BffB33BڙBיB33B  BffBffB  BBffBBffB  BffBBffB33BBޙB33B  B㙚BBffBԙB33BՙBBҙBҙBԙBՙB֙BBڙBffBffBB33BڙB33BBB  B  BBBřBəB33B33BffBffB  B33B33B  B33BffB  BffBΙB  B33BЙBЙB33BљBffB33BϙBΙB  BBffBBB33BB33BffBffB33B  BәBBffB  BיB33BؙB33B33BB33BffBffBՙBBљBffBB33B33B  B  B33BЙB33BҙB  BffB  B  BffB33B33BBB͙BBəB33BʙBB33BffB33BB33B33B33BBBÙBBffBffB  BBffBffB33B  B  BffB  BřB33B33B  B  BBřBęBřBffBffB33BęBBBffBəBffB  BffB  B͙BBffBffBB  BʙB  BB33BB33B͙B33BffBəB̙B  B  BЙB  BffBљB33BϙB33BB  B  B  BҙB  B33B  BBЙBB33B33B  B33BffBffBffBB33BЙB  BϙB  BffB33BffBљBҙB  BB  BB33BBљBљB33BB33BәB  BffBffBffB33BϙB  B  B33BЙB  BЙBЙB  B33BԙBffBffB֙BffB33BffBBՙBffB33BB33B  BffBffB  BΙBҙBffBB  BBffBљBљBBB  B33BB33BffB  B33BљB  BB33B  B33BBffBԙBBՙBBՙBffBؙB  BffB  B33BBәB  BB  B  B33B  BՙBBԙBB͙B  BffBΙBЙBљBB  BffBB  BҙBBB33B  BҙBffBffB  BәBffB33B  B33BB33BffB  B33BffB  B  BBffB33BΙBffB  B  B33BBϙB33B33BffBffB33B33B  BffB  BBיBffBffBB  BffBՙB33B  B33BBB33B33B33BڙBBffBffBffBBffB33BB33B  B  BؙB  BffBffBffB  BәBffB  B  BBؙB  BB  B33B  B33B֙BB33B  BB  BڙB33BffB  B33BffB33B33B33BffBB33BBffB㙚B㙚B  BBB陚BꙚBꙚB虚B33BBffB陚B33B  B왚B  BB33B  B  B33B虚B  BffBB  B33B  B  B33B33B♚BBB33BᙚB33B  B33B䙚B  B33B  BffB  BffBۙBᙚB♚BffBۙBffB  BٙB֙B33BיBB33BB  BݙB  BB33BffBٙBffB  B  BB33B̙BffBҙB  B  B  B33B  B  B33BٙB  B33BB  B  BԙBBљB33B֙BBᙚB癚BffB虚BffBffBB  BBB33BBffB33BffBBffB  B  B  BffBBBBBffB  B33BB  B33B33B  B虚BBffBB33B33BᙚBޙBBffBffBBBᙚB33BffBffB  B  BؙBB֙B33BڙBBffBؙB  BՙBB33B  B33BЙBљBәBҙBB33B33BΙB̙BBșB33B˙BBB̙B33BffB33BҙB  B  B33BBٙBffBBffB  B33BffB  BٙB33BffBffBޙB  BޙBܙB33B33BffB33BՙBBB33BٙBffB33BיBB  BffBffBffBBҙBffB  BЙBffB33B  B  BB  BB  BffB̙BB  B  B33BB̙B33B33BffBB  BB33B33BƙB33BBffBBB  BBffB33B33BǙB33B33BffB  B  BǙBffB  BffB33BBřBffBffBB̙B̙B͙BffB33BffB33BřBЙBB  BffBBBBBffB33BϙBB  B33B33BBffBB  BBϙBBffB  BBBB33B  BәBffB33BҙB  B̙B33B͙B̙B̙BʙB  B33BffBffB  B  B33B  B  BB33BBffB  B33B  BϙBB  BBBffBBffBÙB  BBəBB  BBBffBB33B33BBffB  BB33B33BffBffB  B  BBBBBffBffBBBB33BffB  B  B  BffB33BB  BB  B33BB  BBBÙBffB  BřB  B33B  B33B33BffB  BffB  B33B33B  B  BBB33BBffBB33BB  BffB  B33BB  BB33BBBffBffB33BBB33B33BBffBffBB33B  BBBBBB  B33BB33BBffBB  B33BffBB33BffBBB  BBffB  BBffB33B  BBffBBBffB  B  B33B  B  B33BffB  B  BB33BffBB33B33B33BffB  B  BBBffBB  BBB  BBBffBB33B  BBB33BBBffB33BBB33B  BBBffBB33BBB  B33BBB33BB33B33BBffBBffBB  BffBffBBffBBB33B  BffBffB  B33BffBBB  B33BBBBBffBB  BBB  BffBB33B  B33BffB33B33BffBBffB  BffBffBffBBffBB33B33BffB33BffBffBÙB  BǙBęBffB33B  BffB33B33B  BBB  B  BffBBBB  BBB33BB33B  BffBB33B  B  B33B33B33BBffB  BBffB33BBB  BBffBBBffBBffBBB33B  BB  BffBffBBBBffBffBffB33B33BBBffB33B33BBffBffB33BB  BffBBBffBffBffBB  BffBÙB33BBffBffBBB33BB33B33BB  BffBB33BBBffBBffBBB33B33BBB33B33BffBBB  B33BffB  B  B  B33BBBB  BBB33BffB33BB33BB  BffBBBBB  B  BffBBffBBffB33BB33BBB  B  B  BffBB  BBB  BB  BBBBffB  BęB33BBBBBBBffBB33BBBBBB  BBBBB33BB  BffBB33BBffBffB  BB  BBBBB  BBBBÙBBBB33B33BBffB  BBBffB  BB33B33B  B33B33BB33BBffBB33B33BBffBBBB  B33B33B  BBBBffBBB33BB  BBBffB  B  BBB  B  BBBBffB33B  B33B33BB33BB  BBffBffBffB33BBB33BffBBffB33BBB33B  BBffB33B33BB  B  BB  B33B33BB33BBBffBBffB  B33BBBBB  BBB33BffBBBffBffB33B  B  BBB  B33BffB33BBBB33B  BB33B  BB  BBffBffB  B  BǙBffB  BffB33BəBșBƙBřB33B33BffBffBffBBB33BB  BffBBffB  B33BB33B33B33B  B33BffBffBffBBBffBBBBffBffBBffBffBBBffB  B  B33BB33BB33BBffB  BB  B33B33BffBB33BB33B  BffB33BB33B33B33BffBffBB  B  B  B  BBB  BffB  B33B33BB  B33BBǙBBǙBffBBffBB33BffBffB33B  BB˙BffB33BffB˙B33BffBBffB  B33B  B33B33BffB33B33B33BffBffBffB  BB  BB33BffBffBffB  B33B33B  BB33BffBBBffB33BB33BBBBB  BffBBB  BffBB  B  BB  BffB  BffBBB33BffBB  BffBBffBřBƙB33BBffBffB33BffB33B˙BBBϙBΙB33BBffBΙB33BΙB  B  BB  BΙBffB  B33B  BffB  BBffBəBB  B  BəB  BBBffBffB  B  B33B  BffB33BffB  B  BB33B33BBB  BBBBffBffBB  BffBffB  B  BffBBffB  BBřBffBęBřBęBffBffBB  BffB33BÙBffBB  B33BBffBB33BffBffBB  B  BBBffB˙BB̙BB̙B  B̙B33BB  B33B33B˙BffBB˙BffBʙBffB  BBffB  BBB  B  BffBBșBB  B  BffBffBəB  B  BBB  BffBB  BBBBBffB  BffBBBffBB33B  BB33BffB  BBBBB33B  BBęBBffBB33B33BffB33B  BBB  BBffBffB33BffBffBƙBffB  B33BəB33B33B  B33B33BffB33B  BșB  BffBB  B  B  B33B33BƙB  BB  B  B  BffBșBffBƙB33B  BffBB33BșB33BBffB33B  BffBffBB  B  B  BB  BffBBBBBffB  BBB33BBBB33BBffB33B33BffB  BB  BB  BB  BBffBÙB33B  B  BBB33B33B33BB  B  BffBffBffB  B33BęB  BffBșBffB  B33B  BB33B  B33B  BffB  BBBǙBffBffBəBBffB  BBffBffBϙBB  BffB  B33BffBיB˙BșBffBBffB  BB  BffBBffBBBffBffB33B  BBƙB33BBǙBB33BBƙB  B33B  B33BǙBB  B33BB  B  B33BffB33B33B33BffBBffBffBB  BffBffBB33BB  BBBffBB33BBffB33BƙB  B  B  BșBffB33BffBÙB33BffBffBBBBB  BB  B33B33B33B33BÙBffBB  B33B  BffBB  BBBffB33BB33B  BBBBęB33B33BB  BB33B  BBBBffB33B33BffBB33BB33B33BffB  BBBBffBB  B  B  B  B33B  BB  BffBBÙB  BffB  BÙB  B33BB33B  B  B33BffBffBʙB33B33BBB  B33BffBffBffBBffB  BʙBffBffBffBʙB33B33B33BʙBffBəB33BBBʙBB33BəB33BB33BB  B33BB  BəBřB33B  B33B33BƙBffBBəBBBϙBЙB͙BB33B33B  BffB33B  BffB  B  B33B  BffBʙBʙBB  B  BBBB  BB33B33BB  BBB  BB33BЙBҙB  BB33B33B33BҙB  B33B  B  B͙B  BBBBffB  BffB̙BBffB  BBffB33BB33B  B˙B33B  B  BBffB  B33B  BffB33B33BƙBǙBBǙB  B33BřB33BʙB  BffBffBəBffBęBffB  BęBęBBBęB33BəBʙB  B  B͙BBBB  BBřB33B  BffB33BBffBřBƙB  BB33BffBʙBBffB  BffB33B  B33BffB  BəBBƙB33BffBϙB  B33B  B33B̙BffBffBffB33B  BBffB  BffB33BffB  BffB  BBffB  BffBffB  B  BB  BffBǙBBffBBffB33B33BBffBffB33BffBffB  B  BřBÙB33B33B  B  BffB  BřBęB33BffBB  BffBffBffB33B33B  B  BBBB˙B33B33BffBffBBʙBffBffBffBffB  BϙBϙBffB33B33B33B33B  BB33B  BBBBffB33B  BffBșBșBʙB  BʙB  BffB33BBffBBB33BffB33BffBǙBBffB33BșBřBB  BBBBęB  BBB33BB33B33BÙBęBffB33BęBęBB33BffBBffB33B33B  BęBƙBffB  B33B  B33B33B33BBffBffBBffB  BffB  B˙BffB  BB  B33B͙B˙B33B33B33B33B33B͙B33BB͙B  BffBffB̙BffBBB33B33BffBffBffBΙB  B33B  B33B33BϙB33BffB  BΙBΙB  B33BB  BB  BϙB  BΙB̙B  B  BffBșB33B  BB  B33B  BffBB  B  B33BffB  BʙBffBffBB33B  BBƙBB˙BʙBB33B˙B˙BBBBffB  BffB͙BffB  B͙BB33BBB33BB33BB̙B33B  B  B̙BffBB33BBB33B  BΙBBЙBљB  B33B  BffBffB  B33BB33B  BB  BffB  B  B  BϙBffB  BffB  BffB͙B33B  BʙBffB˙BffB33BffB33BffBϙBљBffB  B˙B33B  B  BBBB̙B33B33BB  B͙BBffBΙB33B  B  BffBBffBBBBϙBffB33BffBBљBBϙBffBB33BB33BәBәBffBffBBffBBΙBBBffB33B  B֙BffBffBffB33BљB  BBәB33B33BәB  B33BffBәBBffBB  BB  BBҙB33BB  BBљB33B33B33BљBffB33B  B33B  BљB33BЙB33BЙB33BԙB33B  BffB  BBffB̙B͙B  B  B  BffB  BB33B  BB33BffBB33B  BϙBffBљB33BB33B  BffB33BffBffBԙBBԙB33BBBffB33BBffBԙBffBԙB  B33B  B33B  BәB  BB33BәBҙB  BffB33BffBBՙBB  BBЙB͙B33BffBBљBffBЙBҙB33BЙB  BffBB  B33BffB  BBBϙB33BB  BΙBBB̙B33B  B͙B33BB  BB33BffB  BffBB33BB˙BffB͙BBffBB33BBffB  BǙBBffBřBBffBBB  BffBřB  BffBƙB  B  BffB33B  BBBǙB  B33B˙BffB̙B33BffBBffB33B  BffBffB33BЙBffBffB33B33BffB33BҙBҙB  BffB33B33BffB  B  BϙB33BBB˙BBB33BffB33BB33BBBљBffBffBB  BBffBϙB33BBB  B33B  B͙B  BffBffB33BBB  BffB  B  BΙBBϙB33BϙBϙB33B33BϙB33B  BffBffBB33B33B  B33B  B33BB  B33B  BffBBљB33BffBBB  B33B33B  B  BffBʙB33BffB  BљBB33BәB33BBffB  BBffB  BәB33B33B  B33B  BB33BBffBљBB  BBBffB  BB33BffBBffB  BBBB  B  B33B  BBřBffBƙBffBęBBffB  BBffBƙBBBffB  B  BBBBBffB33BBBffBB  B33B33BBffBBBB33BffB33BffB33B  B33BffBəB  B  B˙y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AA  A  A(A  AA  AA{AAظRA  B ffB(BHB
=BzBGBB BB(BRBBAA{AAAA(AAAQAAAHAAAffAAAzA
ApA
=AAQA{AA{AQA\AA\AQA{AAGAHA\AQAA
A{AAAA=qAA
=ARAffAA(AGA(AAAɮAA
A  AAGA
=AAAGAAAHA{AQAARAApA=qAAA{A
=ARA  AQAA
=AHAGApA¸RAA33AŮAffAQAA
=A  A=qA
=AÙAAHAzA{AzA{AAAffAApA  A33A
=A\)A(AAffA=qA{AA
AAAAAAAA  AAffAAAQAzA33AA  A(AzAAA33AGApAApAAApA33AAA  A
AHAģA(AȸRAƣAAAffAHA
AGAffAHA
AffAAHA=qA33ApA33AAAA{AA33ApAHAAHAA\)AAAffAGAAAzApAAAAAAQAA\)AA\AAAAHARAA33A\A
AQA\)AA
A(A(ApApAŮAHAAřAAA
AAAƏ\AzAƸRAƏ\AƣAƣAzAƸRAƸRA=qAQAffAQAƏ\A(AHAAƸRAA
AAApAŅAîA33A  AîA¸RAÙAÅA
=AHAQA=qA{AîAAAA{AzAÙA{ApApAA{A33AffA33AGAAHAzAA
=A33ApApA  AffAA33ApAAHAA  AGA=qAzAA{A33A
AzAǅA
AffAffAzA
=AA(AzAA
=A
=A33A\)ApAǅAǅAǮAǅAǙApA\)A33A  AAAHAAAffAAǅAƣAƣAģAď\AĸRA33AffAģAAGA£A=qA(AHARAAA¸RAzAGAĸRAA\)A\)A
A(AHA{AARA33AA(A\)Ay ApA=qAA(AA
A(A33Aď\A
=AHAŮA(ApA\)A{Aď\AzAffAÙAîAAAzA£AffA{AGAAď\AÙAffAA(AģAQAzAAƸRAAA=qA=qA
AffAARA\AGA  AGAAŅAîAQA
AAHAA{AAzA\)A(AHA=qA\AA  ApAŮA=qA(AA  AƣAQAzAƣAAffAƏ\AQA(AřA=qA=qA=qA  AQAQA  AAHAƸRAAA33AAƸRA{ApAǮA33A
A\)AA\)AzAȏ\A=qAHAffA{AffAAAȏ\A33AGA{A(AȣA(A(AAȣA=qAAȣAƸRAƣAApAA=qAAAAffA=qAAffAQAĸRAîAQAHA
=AÅAĸRAA=qAģApAAAHA=qA
A=qAQAřAGAřAƏ\AƏ\AzAGAď\A{A\AQA
A
AA¸RAAÙA\)AAGAA
=A{A  A=qA  A
=AGAffAA
=AAAffA{A(AA?   AA
=A33AHAƣAzAA=qy Az@b\y A  A(AGAA
=AA{AffA\AApAHA\)A¸RAGAffAGAřA  A  AŅAřAřAřAAQAAGA
=AGApA=qA(AȣAɅA
AAA33A33AffAƸRA=qA  A33ApApApAřA  A  AzA\)AÙAGApAGAÅAÙA£AQAÅA
=AîA  y y y y y Affy AAGAGy AAÅAGy AA(AzAď\AģAA
A=qAzA(y AHA=qy AffAÅy y y AA=qA  AHy A@\A
=ApAÙA£A\)AAAQA=qAHA(ApAAď\AA(AApAA\)A=qAAAGAQA(AApA(AGAA
AˮApApA
=Aʏ\AAAAʏ\AʣAHAHA
=AHA(AzAA(AʸRAAzAəAQA=qA33AzAAA33AHAA{AzAřAHAA=qAAA33AzA=qAîAîAHA33AzA33AAAĸRAĸRA33AAAA\)A33A33AGAřAřA{AƏ\AA\)A
=A33A
AǙA{AQApA33AǅAƏ\ApAA
=A  AHAA=qAHAAAÅAÙAÅAîAAAA{A{A=qAQAAģA=qA(AĸRA=qAģAzAď\AģA(A
A(AHAǙAAǙAǮAAApAǙA\)A\)A33AA
Aď\AQA  A
=A(AHAA(AŮAAAQAHA33A
=A
=ApAřA=qApAģAÅAď\AAHAA{AA  ARA\A\A¸RA33A
=AffA=qAAA
AA
=A
=A
A(A33AAAzARAAffA\)A{AAGAA=qAffAƣAGAǮA  AAGAzAȏ\AffAAzAQAAǅApAGA33A33A\)A  A  AffAAȣA{AAApAA33AHA33A33AA{AAGA33A{AzAQA  A=qAzAAǙAA=qAƣAAřAAAGAAǙA=qAffAAAA=qAA=qA{A
A  AA\AzAAAHAQAzAAÙAŅAAƣAǙAǅAǮAffA33AAQAA\)AGAA˙A
=Aȏ\AGAAAQA
A{AQA
AGAA(AA
=AQAď\AAAQAHAGAHAŮAŅAƣAffAǮA
AȸRA33AffAAəA33A33AȸRAȏ\AAzA(A{AřAffAQA{A
AffAŅAƏ\AffAƏ\AzA
=A{AŮAAď\AGAģAAģA\)AHAGAAŅAQAHAď\AAŅAǙAAď\AA=qA¸RA  A=qAHAHAQAÙAƸRAAAAîAÅAîAřAA=qApAA=qAʏ\AHAffAAʸRAzAʸRAzAQA
=A  AGAA
=AAGAGAAʏ\AA
AʣA
ApAƏ\AQAzAȸRA33A\)AǅAȣAA
=AGAQAʣAA\)AGAAʣAAGAQAɮA
=A(AAď\AA
AAffAGA=qAzAAAƸRAffAƸRA(A{AA¸RAGA
AGAÅAA33A
=AQAARARA33AAAQAzAÅAĸRAA
A=qAƏ\AƣAA
=AAGAGAƣAAQA  ApAGAA
=AƏ\AƣA(AQA=qA(A(A  AffA{A
AAA
=ARAA\ApAHA£A  AAAzAď\AzA  AAHAHA\AA
AffA  AAA
=AffA
AzAA=qAAQAARAGA=qAQAzA=qA\A
A
=AAA
=ApA\)AAHAAzARAzA  A  AApAGApApA
A  AAAAAAAA\)AGAGAGAAA
A{A\)AA\)AA33AAQA{AA
A(ARAARAGAA33AAA(A  A=qA{A(AAzA(AApAAQA{A\)A
=AAA(AAHAAÅApApAAGAA  ApA
AHAQA  ApA
=A\AAAAAAAffAAGA{AffAzA{A\)AApAAAAAQAAHAA(AAQAAAAQAAQAAzAA\)A33AAHAA
AHA33AA¸RA33AAď\A(AzA(Aď\A
=AÙAAAAQAffAGAzAHAAAƏ\A{AHAHA
=A{A\)A=qA33AzA
A33AHAAzAƏ\AHA  AƣA{A
A
A33ApAŅAffA(A  AAQAAAQA£A=qApAA(A(A(AAGAAA
A  AAHAAHA33AHAAffA(A=qA\ARARA  AARA{A
A33AffAAHAA
A  A=qA  A\AAHA\AAHA£AA
=AHA
=AA
=A\)AÙApApAGA\)AffAHAA33ApA{A33ARA=qAHA(AzA(A
=AGARAAAGAA\)AA33AApA£A
A¸RApAÙA\)A¸RA  AQAAApApA(AAHA
A  AAHAzA\)AffA\)AQA=qA{A\)A{A(AAA  AffAAAApA{A=qAzAffA\AÅA\A£A33AApAAGAîAîA
AîA  AHApA=qA=qA33A\)AřA  Aȏ\AAAǮA33AAĸRA(A  AffAģAģA=qAA{A(AÅA¸RAA¸RAAffA¸RA{A=qA{AA\)A
ApAGAřA(A  AQA{A  AffAzAGAA\A{AAA{AAAAAzAAA{AA(AAAAApA  AAAQAQAA{A(A{A  A  A£A  AHA=qAAÅA33AÙA
=A
=AffAĸRApAĸRA
AHA
AAǮAGA
A=qA  A{AǙA(A(AzAQA(AA
AAzA=qAzAȸRAAHAGAʣA
=AHA\)A=qA\)A  AA\)AǙAAǮAAAAď\A
AA33AĸRAA{AGA
=AȣA=qAǙAAǅA=qA
A
AHAHAHAŮApAîApA
=A33A{A(ApA\)A=qAHApAA(AȸRAəAQAQAffAA{A(AʣAQAAGAA\)Aʏ\AAHAAQAƸRAHApAAQAzAƣAǅA
A=qA{AAAAHAHA
=AHAA33A
=AAzAzAȸRAAȏ\AA(A{A{A(ApAHA
=ApA33A(A(AAƣAzAƏ\AAƸRAAƏ\ApAřA
=AA33A33A
=A  A33A\)AǅAǙA33AA\)AǅAǙAAƸRAƏ\A{AGA(AA(A{AŅApAAÅAAQAHAA
AAA33A33AffAHAQAAQAGAffA\)A=qAʸRAzAA{AGA{ApAǅAffAȏ\AzAHAHA=qA(AAAȸRAA(AA\)AAřAAffA\)AƣA{ApA{AffA{A{A{A(AAAA
=AAffAA
AHAAAGA  AAAHA
AAA(A  A  AAAAzAAA=qAA
AGA  AAA33AA=qAA{AffA\A¸RA¸RAA
=AGA(A  AŅApAA\)AGAGA
A=qA{AAffA(AģAģAHA33AřAGAAA33A33AGA33AAffAQAA  A(A\)A{AHAA(AÙAAffA£AAA
=A\)A
ApA\)A33AGAzAffAA
=AAAffA\AQAAffAÙA(AAAřAŮA{A\A(AÅA  AA  AAA
AîA\)A
=A\)AA33A=qAHAA\)AAA(A
=A(AA33AA{A  AA
AffAAA
A{AffAAAAAHARAAHAA\)ApAA(A=qA(A
AApAA\)A
=ARAffAA=qAAA\)AA{A33A(AAHAAffAAAAAffAA=qA\)AHAzA\AA
=AApA
=ApAA
=AAA
A=qApA=qAAAGAAAzAAAApAGA  AGAffA
=AAA(AAA\)A
AAAQAzAApA  AffAAÅAAAAGApAAQA(AAApA33A\AA\ApAffAAGAGARAAzA(AAQAAAAffApAAffA
AA{A\)AAARAA{A\AHAAAAQAA\)AAAA
=AA33AAA
A33A=qAA
=AQA=qAA(AQARApA
AzAAA33AAffAARAAA
=A\)AAGAA33AA
AAQA=qAAAHA33AAAGAAHAApA  AA
AAA{A(A=qA=qAffA=qAA  AffA\AffAQA\A33AffAffA
=AApA\A33AA\AA\)AHAAAAAAQAAAAA{AffARA  AA\A=qAzAAAAGAGA
=AffAAAHApA
A  AQAffAAHAAAA\AAQAAAA=qA\)AQA{A
A\A{AA\)AAGA\AffAAAAHAÅA¸RAA  A33A
AQA33A
AzAHAzA
=AAAȸRAHAApAɮA
A  AAAɮAAApA
=A\)AHAHAAȣAȸRAQAȣA(A{AǅA
A
=AǅA
Aȏ\A(AHA\)AǙA\)A  A
=AA=qA\)A\)AAzA  AAHAA¸RA\)A  AAAA33A
=ApA\AARAAAGAAď\AÙA(A
=AffA\)A=qAzA
AAAA\)AGA{A(AHAģAzAĸRAAzAģAGAŮA=qA=qAƏ\AHA33ApA\)A\)AǮApA33A
=AA33AǅApA
AǅA
A\)A
A  AffA=qAAɮAɮAɅA{Aȏ\AǮAApAHAAƣAƸRAffAǮAǮAA\)AAzAǙAAQAAƸRAzA(AHAffA  A\)AAGAffAƸRAA
=AffApAARAAHAHA33ARAAGAA\)A
AHAɮAɅAɮAA  A{AƏ\ApAffA\)AHAǙAȣA  Aʏ\AAHAAAGA\)A˅A˅A˅A\)ApAAffAffAʏ\AAHAAA
=A˙AA{A{A  A(A(A{A  A  A  A{AA
=AAˮAHAHA
=AffAzA33A˙A˅AHAɅAɮAApAŮAffA
=A=qAAHAŅAApA
AAQAHA=qA33A
AģAQApAAǅAGAǮA{A33AA=qAƣA{AA
=AzAHAAffA(AƣA
AAAAA
AGAAAAǮAǙApApAA33AGA33AAƸRAAAƸRAƏ\AƸRAGAAƏ\AA
AAA
AA33ApApApA\)AAď\AĸRAŅApAǙApAHA
AAǅA\)A33A
AAGApAApAǮAǙAAAA
AAģA(A(AAAA{AAřAAAƸRA=qAAffAAAHA(A{AA{A  A{A{AȸRAzAȣAGAA33AAəAzAʏ\AA\)A  A̸RA{A  A(A
AGAffA(AˮA˙ApA
=AHA33ApApApAAzAȀ\AGA
=A(AΣAQẠA̸RA33AGA
=A
=A
=AAzA{A  A˙A=qA=qA  A=qAffA{A˙A˅A\)A\)A\)A˅A˙AˮAˮAˮAQA  AzAQAəA\)A(AffAƣAHAzA=qAŅA
A
A
=AǅA=qAȏ\AȸRA{AQAzA=qAAAA
A
=AA(A(A(AHA
AAǅAǅAffA(AǙAƏ\AǙAAA
=A
=AQAɮA
AɮAɮAA\)AGA{A=qAǙAƸRA
=AǮA=qAA\)A\)A  AHAȣA=qA(A=qAQA(Aȏ\A  A
A  AAAȸRAQAǮAǅAǙAGA\)AǅAǅA33AGA33AǮA\)A
AǮAGA
A\)ApApAǮAǮAA
A
AAffAʸRAA(AAAzAAȸRAHA=qA
=AApAɮAffA
=AAAÙApAAƏ\AzAƏ\A\)AzAffAAAǙA
A=qAQAȣA
=A{A  AA\)AAAA(AAƸRAzApA=qAȣA(AA
=AAHAffAȏ\AǮA\)ApAAǮAAA(AAĸRAffA(AŅA
=ApA\)AAAHAHAAAffAÙAîA  ApApApAA\)AŮAŅAffApA=qAzA
=AGAffA
=AA  A{AA
=AǙAƸRA{AAQAA\)A(AA(AAAAŅA\)AAGAGAAĸRAAģAHA
=AŅA  AȸRAzAƸRA
=AǙAGA\)AAɮA=qA(A=qA{A{A
Aʏ\A  AʸRAʏ\AzAʏ\AAʸRAAzAʣAʏ\AffAA
=A\)A(AAHA\)A=qAAA{Aʏ\AffAAəAʏ\A(AɅAAQAəAffA(AǙA
AAʏ\A  A=qAffAʣA33AHAQAŅAƸRAAffA{A=qAHA
AzA(AAAď\AAGApAA{AǅAřA=qAď\ApAģA
=A\)AAŅAřA
AǮAHA\)A  A=qAGAGAɅA  AffA(AɮAAȸRA
A\)ApAffAA
=AGA
=AAȏ\Aȏ\Aȏ\AɅAGA\)AHAȣA\)A
=AA
=AHAȸRA\)A33AAGAA=qAHA
A  A
=AAʸRA
AQAffAƣAƏ\AAŮA{AAǙAQA
=AHAǅA(AAA(AAA(Aď\AA{Aď\AffA
=A
=AzAQAģAď\AĸRAAÅAHAGA=qAHAGAAGA
AAAQAGA=qA¸RAGA=qAzApAQAApAǙAAǙAGA33AGA\)A\)AǮAGA  AŮAAA
=A
=AǙA
=A33AA33AGAǮA  A=qAȏ\AȸRAȸRAȸRAȸRAA
=AȣAAȏ\AAȣA(A(AA{AffA
=AǅAHA
=A\)AGAAGAəAʣAAȏ\A\)ApAGA33A33AzA
=AAGAAģAřAA\)A\)A\)AQA(AȸRA
Aʏ\AA33A
=A˙AAȸRA(Ȁ\AzApAAʸRAA
Aʏ\A\)AQAAˮAA{A˅AzA{A33AǮAAGA
A(A  AzA
=AGA\)AA33AGAHAHA33A33A33A33A33AˮA  AzA=qA=qẠA  A˙AAHAAAAAAzAʸRAQAHAffAAʏ\AAȸRAzAQA(A=qẠAAAHA
=AȣAȏ\AzA{A  AA=qA=qAApAǅAAAŮAA\)A{AǮA{AQAGAHAQAA\)AƸRA{AŅA{AA(AQAGA(A{ApAĸRA{AîAîA  A{AHA=qAƸRAGA  AȣA
=AQAGAˮA
AGAA33A
=AʸRAAA33AHAA
=AA=qAzA(AffAzAʏ\AzAʸRAʣAzAʣAAAzAffAȸRAəA
=AɅA{AAȸRA(AȸRAQA\)AGA=qApA
A=qAGAHAģAAGAɅAffAAʸRAzAffAʸRAHAHA  AȸRA  AîAƸRA\)A
A33AAŮA33Aȏ\AȣAzA
=Aʏ\AQA{AffAzA
=A
=A  AffA=qAQAA\)AA=qAffA(AHAɮAɮAəAɮAHA33A33A33Aȏ\AȸRA
=A\)AəAɮA33AApAGA\)AɮAGAɮA{A  A{AA  AAAQAAzAGAˮA˅A˅AˮA\)AAffA33AHAAAGA(A
AHAQAɅApAA33Aȏ\AzAAǮAAAA\)AAAAƏ\A
AGAQApAȏ\ApAɮA(AffA
AQA{AAA{AffAɮAˮAAffAǅAȏ\AɅA  Aʏ\AˮAzAGA  AffAΏ\AAA\)AA
=AAA
=AHA
=A
=AAHAHAAA  A
A{A  AAffA(AHAffAA\)AθRAυAA  AϮAAGAΏ\A=qA=qẠAAHẠAffA(A  AHA(AffA(A
A=qApAAɅA
=AAHAȸRAHAȣAȸRA
=AA33AȣAHA=qAȸRA{AQA(AQAǮAƣAGA=qAA=qAƏ\AƸRAAzA=qA
AA=qAǙA=qAQAƏ\A  A
=AA
A  A(AzAA
A\)AA{A  A
AAˮA˙A˙A{AffA=qAffAffA=qAffAʸRAAɅAAffAA=qAGAAȏ\A(AGAAAHA=qAQAQA{AAǅAGAGAǮA33AAAAA(ApAŮA\)AƣAƸRAAAîA
A
Aď\AGAřA=qA33AGA
=A
AAA
=A£A=qAřAQAffA¸RA  A=qAĸRAŅA
AƣAzAƸRAA33AQA33AQA33AǅA(AzAApA{A{AʸRAʣAzAʸRA
AAˮAˮAˮA˙AAʣAQA(A{AɮAəA
A
AɮAɅA\)ApAɮAɮA\)A
=AApApA\)ApAA=qAHA
A
AǅA{A(AHAQAzA{ApAAffA=qA(AřA
=AHAģAQAQA(A  ApA
=A¸RA¸RA¸RA£AQA=qAffAffA=qAQA
=AAA£AzA=qA{A=qAQAzAzAAAA33AÅAÙApAîA  A=qA=qAzAHA
=A
=AGAGAAAA=qAApAAA£A=qAQAzA\AQAAzAQAffAffAQAQAAA{AAQA  A=qA33A  AAAApA=qAA\)AAA33AAffARAAA{A=qAApAA33AGAHAA(A
AA
=AAffAzAQAQAA
=A=qAAAA=qAAGAA33A33ApAA\ApAA  AffAA\A
=A\)AAffA
AQAffAHAAzA
=A\AA
AGAAA\)A{AAAHAAffA  AA33AGA33AAHA\)AAAAA\AHAzAGA33AGAffAA=qAQAHAA{A\)AQAAAQAA{A=qAA(AARAA(A(AA33AzA  AGAQAHA\)AQARAAA  A
A\A  A=qAQA=qA  AA
=ApA(AzAGA
A=qAQA33AA  A(AffAQAQA=qAA{A33AA
A\)AApA
A
AApAzApAAAAAzAzA
A  A=qA=qAA
A\)AAAAAAARAQA\AffAAAAApAAARA\)AAGAAAA
A=qA{AzAAffA\)AAHA  AQA
AAAAAA
=A33A
=AA
AAA\A
=AGARAA33A\)ApA{A
AAAAA
AAAAAARA
=ARARAA
=AAQAAzA(AHA
=AA
=AGAAHAAARAffAA  A{AGAAffAAffAAA33A33A(AAQA\)AARAzA
AffAA
=A(AAAHA\)AQAA\A
AzA33ApAffA
=AAQAzAA\ARA\AA\AzA
=AA33A
AGAHAARAffA\)AAAzAA\)AAA33A\)AzA33A
=A\AzAQA{A  A33AAA\A  A(AGA{AAGAA(A33AA\AAAAA£AffA(A{ARApApAAAA\AA
A(AzA
=A\)A\A(AffARAAAAAAA\)A(AzA=qAAAAGAHA{AApAffA\A  A  AA
AGA
A33A
=AA33A
=AAQApAARA33A{AQAQA\A\)AAA=qAAzApAHAzAffAAffAA  A(A=qAAAAAGA
=A{A=qA
=ApApAGAÅA
A{AA
=AA=qA{AA
=AGA
=AA
=AÙAA
=AAHAAHA¸RA£A£AffAzA\A¸RA£ApAA(ApA
AA\)AGAARA{AA(A(A=qA
AAAîAAÅApA
AAzA
A\)A{AffA=qA{ApA
=AAA33A33ApA  A33A=qAAAA(A\AA
AQA£AAA(A£AAGA=qAŅAƸRAǅApAA(A\)A{A=qAQAffAGAAffAA  A\)AA{AffAzAzAffAƏ\A=qAřAřA
AŮAŅA\)A33A{A(AA  AĸRA=qAHAzAÅAQAÅA
AQAAŅAŅA
AŮA\)A\)AAAģAŅApA\)AŅApAA
=AA=qAQAGAQA  A\)A\)A
=AAApARA
=AApAA\)AAHA=qApAAAQAAA(AAA
=AģAGA
AŮAŅA33AAA
AAA{AŮA\)ApA
=AģAQA(A(A(A=qA{A  A=qA{AAAGA
=AA\)ApA\)AHA£A\A\A\AApA  AA{A\)AQAA{A33ARAA=qA\A=qA(A{AAAA\)AAGARARAQA(A{A(A(A  AQAGA\AQA\)A\A
=A\AAA\)AARA
=AA\A(AA{AQA=qAAA=qAHARA
A{AQApA
=A
=A(AARARAzA(A(A\A\ARARAAHA=qA\AzAAQA\AAHA{AHA=qAHA{AAzA(AA=qA\AA\)AHAQApAAAA
=AzAzAHAHAAAAAffAQAA\)AAAA
=ApAHA\)AzA\AA
AzAQA33A33AApAAGA\)A  AA
AAA\)AA=qA=qAAzA(A¸RA33AAA\AA
AAA\)AARAGAA=qAA
=A
=AA
=ApAA
=A\)AA
=A{AGAAQAQAA
=ARA(A  A
A=qAA\)A33AÙA  A33A
AGA{A\AAAzARA\AAQAA¸RAzA33AffA=qAApAGARAffA\A
A  A{A\A
A
=AAQAAA{AAAHA(A
=AAA
AffA{A\)AAAGAAA\AA\)AA
=A\)AAzAGA(AffAA  A
AA
A  A=qAQAffA  A(AAŮAQA=qAA33AHAAƸRAffA{A(AffA{AÙAffAAîAGA£AApAÙAîApAA33A
=A
=AA33AffAzAzA(AA{AA33A
ARA33AQAHA
=A  A  A{AAAA33A\)A(AGA
=AA\)AA
A=qA\AAAAAA33A\AzARAQA\AffAAHAAA33A\)A=qA{AAAAA\AA{AHAĸRA\AÅAîA=qAď\A33AŮApAŅAřAŮA  AAAď\AApAřAQAÙAď\AÅApA33AAAHAGAAÅAAîA
A\)AAGA33AAffAîA
=ApApApAHAA
=AĸRAGAHA=qApApApAA=qA£A\)A\)AAGAA33AzA(A=qAAA¸RAîA=qAzAffAQAAffAQAzAģAHAŮAffAffA(A  AQA
=AǅA
A
A(AQAffAffAAəA\)AȸRAəAAɅAəAAAApAzAffAzA{AQA(A(AQA
AA=qA{A{AffA=qAGAƸRA(A{A(AAŅAGAAHAAřAAģAA
=A(AHAģA33A\)AA£A\AAHAAAHA  AÅAzA\)A\)AAAAA\)A\)AA33AA{AAA{AffAAGAGA\ApAzA\)AAHAApAA
AQA  A(AAĸRAA(AĸRAAŮAƣAȸRAQAA=qAAɅAəA  AGA
=AAȸRAȏ\AffA(A  AƣAGA\)AHA{AǮAA  AǮAǙAǮAHAHA
=AA=qAƸRAAƸRAŅApAAŮA\)AAHAffAzAď\AģAď\AffAzA
=A
=A
=A33A
=AAHAď\AzAffA=qAAzAAQA  A{A  AzAA  ApAffAA¸RA=qA  A  AzA\A£AAÅAzAzAģA
=A\)AAQAƣAAAA  A=qAzAzAȏ\AA(A{AzAȏ\AA
A{AAA(AA\)AGA\)ApAǅA
AGAǮA\)ApAǮAAƸRAAAŮAǅAǅAƣAQAAzAǙAffAǅAAǅA33AřA=qAffA{AzAzAzAƸRAǅAAffAǙAƸRAǅAƏ\AAA33AffA=qAǅAA\)A\)A(A{AAQAQAzApAǙA33ApAApA{A(AGAŅAAAHAQA33AȣAʸRAAAQAQAA˙A
A  A=qA=qA=qA  AˮAGA
A33A(AͅAAA˅AAAGAɅA(AʣApA
AGAʣAʏ\A=qAzAffA(A=qAȏ\AGAA\)AəAɅApApAɅAffA  AQAA33AffA=qA{AzAȸRAHAffAȸRAȣAHAHAA=qAQApAGAGAA\AÙAffAA
=A(A=qA
=AřAŮApAŮAƏ\AQAAƸRAAƣA=qA33AǮAzAApA  AA33AA33A˙A(AA\)AGAAzAʣAzAffAʣAzAAGAAffA(AAAApAƏ\AîA=qAřAffAƸRAAA{AzAA33A\)A\)AGAǙAǮAǙAƣA  AHAǙA{AGAřAHAřA\)A(AƣAAƏ\AHApA
ApAA\)A33AǮAǮAApAA33A33A33AA
=AAAGAA(ApA{A(AzAƣAA
Aď\AA33AAřAƣAƸRA33AA33AHA33A\)AǙAǮAAA33AǅAǮA  AȣAȣA=qAǅA33AGAAA(A=qAAA33A
A
=A(A=qApAɅAA{A33A\)AʸRAQAffAɮAʏ\AɮAɅAzAzAǅAAHAAQA(AAA33AGAHA
=AA{AǅAAǅAzAzA
=A
=A
=AffApAA
AA
AffAÅA\)AffA(AîA(AffA=qA(ApAHA
=A
=A
=AA{AAƸRAŅA
AŮAAŮAŅAAffAA
=AGAǅAffAȸRAAGApA\)A  A(A33A33A
AʸRAHA33AHAAA{AGAGA33A\)AHA
=AAA\)ApA
=AȸRAɅAffAAzAʣAzAʏ\A33AffA˙AʣAApA
Ȁ\AQAAAA˅A
AA\)A{ApAɮAʏ\AAəAʏ\A\)AAHAʸRAGAAʸRA
=A33AʣAAʸRA(A33AzA=qA=qAHA
AȣAffAHA
AGAQAHAA(AzAApA
A{A̸RȀ\A
=ApA  A(A33AϮAϮA  AУA(AffA  AѮAѮAиRAAApAѮAхAQAA
=ApAHAиRA=qAQA=qA  AAϙAϙA  AAθRAΣAzA33AϙA
AϮAθRAAϙAϙAΣAͮAθRẠA˅ApAȏ\Aȏ\A
=AffAGApA(AffAApAΏ\AzAAffA33AGAGApAHAA\)AϮAAͮAQA=qAУAиRAQAA(AΣAͅAA̸RAAAA33AA(A
A(AQAA
=A\)AApAQA
=AffAӮA\)A  AծA(AԣAA{A֣AApAHA(AAzAәA33A(AAA(Aԏ\Aԏ\AffAQAQA(A{A(AffAApA
=AAffAQA33AA  A
AAAAGAAzAAQAΣAffAAHA33A͙ẠA˙A  A33A˙A(A
=A{A
=AGȀ\AͮAΏ\A̸RAGA
AGA=qApA\)AGAA=qAǅAẠA33AAA͙AffA33AAΏ\ApAHAffA(AApA\)A
=A33A͙AA
A(A=qA33A  A  AzA̸RAAGA͙AͅA͙AAQA=qA  A
=AAA33AϙA  AffA=qA(AЏ\AQAQA\)AυAQA33ApA{A33ẠA
=AAAΏ\AAͮA
AΣA33AͅAA
A=qA
A33AzAQA=qAA=qA
A(A\)AAˮAAУAУAϙAAΣAAυA33A
=AHA˙A  ẠAˮA=qA{AA̸RAAAΏ\AzAA  A{A=qAΣAθRAzAΏ\AΏ\AΏ\AϙA\)AAΣA  AθRAΣAУAAAHAΣAGApAυA33AGA\)AυAυA\)A
=AApAAAA33AA{AͮA̸RAA(AAQAHA(AȀ\ẠẠAffA  A(AQA  Ȁ\AẠA  Ȁ\AzAzAAAzA
A(A33AffA\)A˅ApAQȀ\ẠA̸RAͅA
AAA{A  A33ẠAQA{A(A\)AAϮApAA\)AA\)ApA
A
A(A(A{A{A{A{A  AϮAQA̸RAΣA\)AA=qAAθRA\)AHApA(AffA33ẠAͮApA
=AˮAA(A(AA˙AQA(AA(AAApAAʏ\A=qA(AA  AɮAAA(AʸRA=qAffA
A\)AΏ\A˅AA̸RȀ\AHAAʏ\A
A
AAQApA=qAAGAřAAA
ApAffAffAQA(AʣAA(AHAA=qẠAHAA(AΏ\A\)AAϙAQA\)A=qApAzA\)AՙA֣AffA֏\AHAQAA
=A  AAzAA
=AָRAffAAAzA=qAAAffAѮAAУA(AAA{AA(A=qA(AAЏ\A
=AHAGAGA\)A\)ApA
=AA{A33A33A(ẠA(AʣAA
AHA\)ApAʸRAA33A
=Ȁ\A\)A(A=qAGA(AffAAθRAϙA  AϮA{ApAѮAHA=qA{A\)AУA=qA  AA\)A{Ȁ\AffAzA
=A  AЏ\AAAхApAхAѮAљAffAAGAAҸRAffA=qA=qA=qA  A\)AA
AѮA
AQA
A  A=qA{AGApAхAGA=qAQAHA\)AzA=qAͮA(A{A{A{A(A{A=qAffAͮAzȀ\A{Ȁ\A(AQAQȀ\AzA33A=qA˙A(A=qA\)A(AǙAffAzAAAAHAffAɮAQAffAA\)A
AQAQAA
AAA{AGẠAzAzA=qAQA\)AͮAHA  AffAAљA=qA(AffAәA33A
=Aҏ\AңAHAңAңAQA  A
AzAffAQA=qA{AffAңA=qAA33AAAљA=qAΣAиRAAHAΣA33AHAffAQA=qA(ApA˙AAAAAʸRAʸRAHAQAA=qA=qAA=qA=qA
Aʏ\AAGAzAA
=A\)ApA=qAAřA
=AƏ\AQAHAAʏ\AAAQA  AApAGAGA33AAʣAʸRAzAʣA\)AffA33AQAGAϙAυAϮAA=qAЏ\AAAGAхAѮA{AәAәA
ApAGAҸRAffA
AAGAA{A
AAAA(AGApApA
AffAQAЏ\AffAQA=qAA{A  AAffAυAϮAυA33A=qAzAͮA
=A
AAA
A\)AA̸RAzAʏ\ApAffApAˮAAA
A33AˮA˅AʣAȏ\A
A(A\)AƏ\AͅA(AffAQAʸRA\)AˮAHẠAͅAͅAȀ\AAAA(A(A(A=qA=qA(AzAθRAθRAΣAAAΣAzAffA
AApẠAA{A(A  Ȁ\AAȀ\AzAffAQA{A{A
A
A
AʸRAQA  AǮAA{A\)A
AȣAHA=qAƏ\A{AǮA
=A
=AƣAA{AAǮAǅAQAAřA33AÅA(AģAď\AAzApA£AAA{AAGA¸RAQAÙAGA\)Aď\A
=A  A\)AřAffAƸRAAƸRA(AGAĸRAƣApAŅAƣAƏ\AĸRAŮA=qAAÙAGAA(AHA33AǙA
A(AffAȣAHAA\)ApA33AʣApAAƣAHA{AAQA33AzAzA=qAHA33AzA  AAHAAəAȸRAȣAQAɅA\)A
AHAɮApAGA33AGA(A\)AAəAɅA\)AA  AɮAHA
=AȸRAɅAHAȸRA=qAǅAŮAzA
=A=qAAA\)AAHA\)AǅA{AǮA  ApAQAA  AApA(AzAA{AA͙AffA33A{A
=AԣAAәAӮA{A  Aԏ\AHA{AAәAӮAQAHAәAA
=AGA
=AGAA\)AӮA\)A(AA\)A\)AҸRApA  A\)AGAAAʣA\)A=qA͙AGAυAHAAθRAΣAΏ\A(AzA
=ApAHAAffA(A
AffAɮAAAAȣA33AHAAəA33A33AŅApAĸRA
AAĸRA{AQȀ\A
=AQAzAHApA
=AffA(AA
AzAGA\)AͮA=qA
AͮA33AиRAљAҸRAљA=qAӮAӅAAAՅA(AָRA
=AAzAA
=AAzAzA(A
AՅAAAծA
A
A  A=qA
A33AffAQA
=A=qA=qAAzAGA̸RẠA  A
=A=qA
=A
=AffAA{AffA\)A
=AGAẠA\)AffAɮA
A{AAA33AˮA(A
=AffAȏ\AȣA\)A  AffAzAQAA˙AQA
=A(AȀ\AA(AQAQA  A̸RAzA=qAAAzA
A
Aʏ\Ȁ\AffA͙AΏ\AθRAQAΣA
=A\)AυA  AzAApAGA\)AѮA  AѮAиRAAHAA33AQA
=AQAA(A\)AGAQAAAzAиRAHAA33AQAQAΣA
=Aȏ\A˅AͮAͮAHAGAẠAHA
=AΏ\AAA33AGAAzA=qA\)Aʏ\AAʣA
=AGA  AȸRAȣA=qAA33AA
=AHAAAAAAzAGA
=AQA(A(AɮAAɮAAAʸRA33A˅A  ApA33AHApA
AẠAAHA
=AA̸RẠAȀ\AzAQȀ\A̸RAAAAA̸RA̸RȀ\AzA\)AffAzAGAGAẠAffAȸRA  AHA(AGA͙A̸RA
=AAͅApA
=AHAAHAȣAzAȀ\AəAǙA
AˮApA  AQA=qAQA(A33AʣA\)A(AȸRA\)A¸RAAAA\)AAHAȣA=qAƏ\AGAzA
=AAAzAȏ\AɅA\)A  A˅AHA˅AffAA{AzAGAAzA(AAffApA\)A
AffAҏ\AҸRA
=ApAAA  AѮAЏ\AAHAυAAϮAхA̸RA˅AA  A33AAA=qApA=qApAAzAffA33AA(AAAzA
=AΏ\AͮA
Ȁ\AA\)AA{AřAîAď\AĸRAAQApA  AƸRAHApAƣA33AǮAA33AHApA  AǅAQAAģAîA(AAGAÅAģAîAAAHAGAîAAģAģAAAÅA33AîAĸRAĸRAŮAffAAAAHA
=AHAA  Aʏ\A  AzA(AəAʏ\AɮApAffAA33ApAǮA
=AHA
AQA{AQAAffAffAȣAHAɮAǙAAǙAǅA\)AǙAĸRAA
AAA{ARAĸRA
AQA33AÙAGA\AHA\A  ApAAA=qApApAAQAGA33AzAA¸RAApAzA£A=qAzAffAAAAHA\AffA\)AHA33A(AA
ApAAĸRAzAA\Aď\AGAǅAȏ\AHAHAȏ\AɮA(AAʣA
=A{A
=AA\)Aʏ\A  A33AɮAAzAffAAAɮAɅA
AȸRAzAAGAɮAzAApAʏ\AʸRAʏ\AQAAzA  AffA
AQA{AffAGA=qAffA=qAʣAAȏ\AA(AQAģAɮAHAʏ\AA=qApAAA33A  AǅAƸRA=qAAffA
=AQA\AA
=A¸RA  A  A\A¸RA33A\)ApAzAǮAȸRA  A
=AA=qA
=AͅA
AHAẠȀ\AHAA͙A\)AAAAAAͅA=qA=qA
AΣApAA{A˙A(A
=Ȁ\AA\)A\)AzA˙A
AAGAAȀ\A\)AϙAzȀ\AzAQAAzAAď\AřAŮA
AzAřAffA  AHAA{A\)AĸRA  AĸRA\)AGAAzAApAîA(AHA{ApApAAA33AAřAŮAAǮAzAəAApAAAʸRAGA(ApAͅAA\)A{AAʏ\AͅA{AGA{AͅAΏ\AQAApA=qA(AAzAGA
=AzA
=AHApA
=AAQAиRAAѮAAхAAHA33AиRA{AQAЏ\AGAʸRA\)A
AAAȣAɮAA(A  AƸRAƸRA
=A{AA33AGAffAAĸRAffAǮAƸRAA33A  AʸRAA  AzApAȏ\AAffA33A{A\)A33AȸRAǮA  AzAĸRA33A
=AȣA=qAȣAǙAffAAA=qA(A33A
AzA\)ApA{Ȁ\AGAͅA͙AθRAGAυA  AAGA(AzAΏ\AA{AЏ\AHAͮAAGAẠA
=AϙAzA
=AA  ApA33A33AAHA{AzA
=A(A
=AAA(A\)AHAA{A
=ApAΣAAAA{Aʏ\Aʏ\AA33AQAApAAǅAAApApA33AƏ\AQA
A\)A
Aď\AAGA=qA{AřA
AGAĸRAģA\)A
AffAffAď\AĸRAHA33A\)A
A{A(AQAzAƣAAAA  A
A  AAǅAHA\)A33AQAzA(AAîAA=qAQAA
=A33A
AAAAAAA
A
A\A(AÅAffA  AA{AAA\)AAQAGApAAAAAA=qAA=qAA
AģA\)AîAď\ApA=qARA\AHAA\A¸RAHA=qA33AQAARA33AAA  A
=ARAffAGAAƸRAA
=A=qAřAA{AAzAƸRAAHAAGAA=qA
AffA\AÙAQAǙAəAAHA(A33AɅAApAȏ\AřA¸RA{AAApA=qA\)AQAHAQAGAAAGA33AffA(AGAA{AGApAGAQA{A=qA
=A=qAAAAAA
=AARARA(AA
A\)A
AAGAAAffAAAA
AQA
=A33AřAAģA(A
A(A\)AĸRA(A  AAA£ApAAHAAÙAď\A\)AAřA{A=qAzA
=AGApA  A
A=qA=qAA
AGAHAAAǅAGAǅAǙAffAHAQAHAA\)AɮAA  AAɮAAA33A
=AHA33AAA(AffAzA33AAA{A\)AɮA  AA
A{A\)AzA
AǙAApAffAɮAAHAGA(A  AAffAAǅApA
=A\)AÅAƏ\AÅAHAHA=qAAȣA˙A
=A=qA=qAA
AŮApAffAQAȣAffAzA  AQA\)AA=qA
A˅AHA33A˙A
A33A  A\)A̸RẠA\)AGAAʸRAzA=qA
=A  ApAGAɅAʏ\Ȁ\AzA
AffẠA\)AzA  AffAȏ\AʸRA33AzA(A33ApA33A{AȸRAəAffAAǙAAA  A=qAAAAƣAffA(A  AŅAGA
AǮAffAAřAĸRAzAƏ\AřAQA(AŮA{AQAAzAffAGAHAAřAAGA
AzA(A
=A(A  A
=A{AQA=qAƸRAǅAəAɅA
A=qAAA
AA=qAGAΣAAA  AQA  A
A\)A͙A\)A
=AffA  A
AA
=Aʏ\AQAA{AΏ\AΣAffA=qAAAʸRA˙A=qA
AA˅A(A(AˮA  A{ApA33A  AȣA{AA\)AAAApA
=AȣAŮA\)AAzAAA33A33A
=A33AAAffAQA
=A
=AŮAĸRAǅA{A33AAǙAAA˙A
AəAA(AQA  A=qAA=qAʏ\AɮAffAǙA  AffA(AAGA33A(AGApAAA(AɮAAzA=qApA
=AʸRAǙA33A  AAřApAƏ\AƸRAƣAHA(AƣAƣAQApAƸRA
AƸRAA
=AQAAQA
AƣAŮA
AAAAAQAAARAAGA  AzAzA(AA\)AzA
=ApA33AAffAAAAAApA{A\ApA
A=qAAQAffAA=qA
ARAAAQA\ApA(AAffA=qAffAffAzAĸRAřAA{A{AřAA\)A
AAřAAAGAzA(AřApAAffAƣA=qAA
=A
AîAGAAřAAffA
A33AGA\)AƸRAAŮAHAffA
AA\)AƣAffA
A\)A{AzA
AAA\)A(A{AffARA  AAA\AAGA¸RAA(A=qAARAA(AAHAŮApA(A£AA
=A=qAA  A\)A
ApA\)A=qA\)AAəAəA  A  AA(Aʏ\AA33ApA  A(A=qȀ\AA33A
=AAHAQAQA  ApAAAHAAəAzA
=AA˅A˙A33A
=A=qAffAəAA
AGA{A
A\)AHApA\)Aʏ\ApAAAŅAQAAĸRAAŅA\)AAîAA\)AA  AîA\AÅA\)A¸RAA
AAHA
AĸRA{A=qA
=AAAAAîA{AQAɅAʸRAAƸRAA(AA
AHAAA33A\)A(AzAͮAQAAϙA
AA  AϙA
A(A(AУAУAAAυAA
=A
=A
=A  A  A
=A=qA=qAȀ\AɮAAəA
=AəAzApAʸRApA=qAzA
=AAAA{Ȁ\A{A{Ȁ\A{A  AffAA
Aȏ\AGA
=A
=AA=qA\)AffAʣAʸRAAGAQAAGAQAffAzAQAȣA  A˅A
AAffA(AGA
=A  A
=AQAzAAAAəAAA(AA
=AHAHAAAQA33ẠAAQA=qA(ẠAA(AAAAA͙A͙AA
=A̸RA{A=qA33AHAzA33A
AQAˮAHA33A˅AGAA=qA(AAzA  AəAɅAAǅA{A=qAAAQA=qA=qAȣAAȏ\AAɅAəA\)A33A{AȣA
AʣA(A{AȣAzA33AƏ\AffAƏ\AAǙAAzA(Aď\A{AzAƣAA  A{AzAAHAɅA\)AQA(AAʣA(A  AGAəA33AzA
AAɮAɮAɮA
AzẠA̸RA˅ApAɮA=qA{A=qA=qA(AzA\)AɮA  AAAʏ\AɮAʸRAɮA  A  A=qA(AƣAHA{AQA  A(AǅAzAAȏ\A33AA=qA  A
A
=A(AApA{A\)AGAAQA=qA{AAřAGAzA=qA¸RA33AÅAřAffAĸRAəAȏ\A{AǙAffA33A{A(AA\)Aȏ\AƸRA\)AQAȸRA
AGAzAzA33AzAApA
AQA33AA(AʣAAAHAAGAApA\)AʸRA\)AffAȏ\AAAQAʏ\AAzAzAzAQA(A(A(A(A  A=qA
=A(A
=Aȏ\AzAȏ\ApAȏ\AǙAAzAAA{A{A
AǙAƣAƸRAQAřAŅAřAAď\AA(AHAAffA33A{A
=A  ApAA¸RAA  A¸RAAAGAǅA  AGA\)AɮA{AQAĸRA33AŅA\)AA{A
AHAƸRAƸRA33AǮA  AǮAǅAǙAHAəAffA
=AA\)AA{AAffAzA(A̸RA=qA(AQA=qA{AHA
AHAQA\)AAǅApAǙAȏ\AAʸRApAAʏ\ApAzA
A
=A
=AȸRA  AǅAA
AA33A=qAģAŅAģAHA=qAGA=qAƏ\AAȏ\ApAQA=qA(A(AŅAAŅA
A
AQAQA(AAƏ\AHAffAAřAHAHA(AQAzAƏ\AAAƏ\AzAAQAAǅA(AAzAəAHA
=Aʏ\A  ApA{A33AQAˮAA
A͙A  AAHA
AHA=qAA
A(Ȁ\A
=A͙A  Ȁ\A=qA{AAˮAQAHA͙A  A33A=qẠAAA˙AffA{A(A˅AA˅A  Ȁ\A˙AHA  A{A  AGAzAzA
=A\)A(AAA
=ApA˅A  AAˮAA
AHAɮAəAəA˅A˅AʣAA
=A
=A(AAAffA(A
AAzA{A  A
AHA  A
A\)A̸RA\)AAͮA
=A\)AAʸRAˮAAAA  A(A(A{AљA  A=qApA
A=qAхAиRA(A͙A͙AHAGAΣA  AzAͅAGA  Aʏ\A  A
AffAA˙AHA\)AA
A{AA˙AHA=qApA\)AGAA\)AffAǮAAA(AffA{A33AͅA͙ẠA(A̸RAHA\)Ȁ\AApAɅA˅AffAʸRAQApA{AȣA  AǅAHA
AHAƣAAɮAA{A33A
AAffApAθRA\)AQA
=AљAҏ\AAӮAԏ\AffAzAծAzApAA33AGAAzAAffAA=qAAffA\)AA{A{Aԏ\Aҏ\AQA33AљAAхAffA{A
=AңA33AхA=qAAAҏ\AAA
AͮA
AQȀ\AAzAϮAQAQAϙA\)A\)A\)AͅAzAApAʣA\)AƸRA
A
=AȀ\AHAHAffA(A{AA=qAAΏ\AϮA{AΏ\A\)AHA=qA=qApAϙAA
=AGA
AϮAЏ\AAHA
=AУA33A=qAQAЏ\AHApAAхAҸRAzAѮA\)A
=AA\)AυA{AGAApA
AϮA{AffAHA=qAΣA33A=qA=qAffAΏ\AϙApAQA33AGAϮAϙAAϮA
AυA\)A  AA
=AA=qAffAQApA33A
=AAHAǮApA=qA
A(AA
ApA\)AA{A=qA
AAA
=AəAƣA(Aȏ\ApAʣAQAAʏ\A33A=qAAΣApAA33AHAAϮApAA33ApAA{A=qA  AЏ\AHAУAHA
=A=qA33AθRAffAAУAA
ApA\)AzAͮAA33AGAˮA=qA(A
AAGA\)A33AA
=A(A=qA=qAAHAGAGA
=A
=AHAHAʸRAʣAʸRAʸRAffA=qAQA=qApAəAA  AȸRA33AffA{AA=qAǅAƏ\AǙApAǅAAǅA
A\)AǅA33AǙA\)AAA=qAffAȏ\AȸRAHAAffAA33A\)A\)A(A=qAffAzAʸRAGA
=A˙AHAA(AQAffA=qA{AA  AQA̸RAffȀ\A̸RAAAA33A33AGA\)AGA
=AA33AGA
=AHA˅A  AˮA
AɅAA33A33AA  A{A  A(AffAzAzAffAʸRAʣAffAQAQAzAQAffAffAzAAʏ\Aʏ\AAA(AHAǙAQA=qAA33A{A{AA  Aď\AŅAA=qAHA(A(AǅAQAȣAAQAApAzAGAA  A  AˮAAzAθRAzA33A33ApA
=AAHA
=AAAθRAͅA\)ApA\)ApA͙A͙AAAAffAffApA̸RAA̸RA{A
A=qAΣAffA  AA
AͮAAQAA̸RA{A
AAAʸRAʏ\AzA
=A\)ApAʸRApA
=AQA=qAAGAffAAǮAHAǮAAȸRAAɮAzApAffAAəAzA  A̸RAAGẠAAA˅A33AQAffA  A  A=qA
=A
AA\)A{AGAϙAAA
A{AQAЏ\AиRAzAQA=qAQAQAQAQAzAЏ\AzAffA=qA33A
AA=qA=qAzAAУAЏ\A{AϮApAυAAA
=AApApAͮA{A  AAAA
ApA\)A
=AυApA\)A33AffAΏ\A{ẠAHAAGAQA
=Aȏ\AɮAGA  A=qAAɮApAQAA{AȸRA
=AAA33A  A\)AAffA͙AͅAθRAQAθRAAQA33AGAGAAAAAQA͙A  A  AA(AffAffAθRA  AиRApA(Aҏ\AQAA
=AҸRAffAAѮAA(A  AQA{AAљAљAAѮAѮAAљAѮAA\)AA  A  A
A=qA˙AAA
=AffAA  A\)Aʏ\AzA=qAʸRAQAzAˮA=qA
A˅A
=AAA
A33AA
=AAAA33ApA  A=qAGA(AͅAApAzAAQAAɮAA{AAQAAA˅AGAQAffAʣA˙AffAHAAͅA=qAffA\)AυAA{A(AApApA  Aҏ\AQA=qA{A  A  AҸRAA=qA  A  AAQAzA  ApA{AGAљA33A
=AApAѮApAљAљA
AљAAљAљAңAҏ\AzAҸRAHA=qAҸRAffAGAAHAffA=qA
=AљAA{A  AQAffA=qA  AA  AѮA\)AЏ\A
A(AHAAAAA=qAGAAУAffAffAAA{AЏ\A33A33AљAffAA\)AӮA  A=qAffAԸRAHAAAAA
=A
=AAԣAAԏ\AԣAHAԣAԸRAAԸRAԏ\A\)Aҏ\AA
AхA{AӮA\)AϮAυAGAA33AͮAӅAQAffAԣA\)AQA  AA  AA
=A  AffA
AңA=qAAңAѮA\)AљA
A  A
=A=qAAˮA
=AA  ApAAzApAffAϮA
AȀ\AAA(A=qAHAGA
Aʏ\AHA\)AAAɮAzAApA  AGAzAAϮAиRAHAхAA
AѮA
AљAљAѮA33AHAzAQAAGAAϙApA  AϮAA{A
=A(A
=AЏ\A=qAA(AffAA=qAA{A  A
AљA=qApAхAQAҸRAңAQAHAAHAAzA
A\)A
=AA  A=qA̸RAApAGAzA33A  AθRAffAЏ\A=qAAAffAAHAAAHAA
=AQAAGA  AϙAA=qAffAA33A̸RAA͙A
AϙAGAΏ\A
A
=AAQAAңA  A=qA
A
AѮA
AӅAӮA{AzAԸRAAzA\)AQAffA=qA  AԣAԣAffAQA=qA(AAApAAHA=qAЏ\A\)A=qAA
A33AzApAAzAУA=qAθRAApA=qAHAffA(A
=AУAиRA\)A
=AGAffAϙAGA(AAΏ\AzA͙A͙AϮA\)ApAѮA
=AңAzAA{AA{AQAzA
=AAQA̸RA33AffAAGAЏ\A{AGA\)AAӅAHA\)AAzAHAծA=qAָRAHAAQA(AAԣAԸRAA=qA  AѮAѮAиRA33AAϮAυA{AAApAA\)A
=Aҏ\A  AљA
A
AAљAApAAHA
=AУA
A
AA(A
A=qAA\)AϮA
AAA  AAAA33Ȁ\AGApAA˙AQAͮAHAͅAGAʏ\A  ApA˙AGAΣApA
=A
=AGA{AǙAƸRAA=qAHAAǅA(AȣAʏ\AQAͅA=qAAAЏ\AGAѮA{AzA33AGAAAӅA{AAәAҏ\AzAAQA{AA(A  AffA(A{A(AffA=qAffAffAzAffAQAffAffAQA\)AQApA
AхAzA{A33AAAQAAA\)A(AЏ\AQA(AAϙAffA
A˅A
AA
A=qAHAAA͙AͅAQA\)ApAAQA=qAΏ\AAHAAHApA(A˅AȣAɮAzAGAGApA  Ȁ\A=qA=qAAA33AAHAәApAQA
=AՅAA֏\AHAHAHA֏\A
=AAՙA
=A
=AA
A=qA֏\AQA=qA33A֏\A֣AzA33A\)AAApAЏ\A(AУAApA
A\)AA
=A  A(A=qAzAQAAffA33A  AGAffAՅA
=A  AӮAHAzA(AЏ\A{A
=AAHAA=qAA=qAҸRA\)AͅAͮA  AA(AΏ\AθRA  A{AHAHAΣA˅AA̸RAHA
AͮAA{ApAGAffA=qAGAңApAҸRAAGA\)AApAAљA{AAәAQAծA  A{AՙAAծA
AAA{AQAzAԏ\A  AAHA(AAzA{AՙAA(AQAzA=qAAхAzAA  AHAAQA(A{A{Aҏ\AQAҏ\AHAAҸRA{ApAAA33AϙA=qA
A=qAffAAѮAәAӅAffAљAңA  A=qAѮA
=AЏ\AиRAϙAΣA
=AQA  AAЏ\A  A
=AQAиRAA(A
AУAffAәAQAԏ\AԣAAAGAGAffAffA  A=qAffAffA{AGA33AAӅApA
AAӮAӅAQA{A{A
AAәAӅApA
=AAңAffAҏ\AzAҸRAffAAҸRA
A
A\)AA\)Aҏ\AAҸRA(AffA
AA
A(AϙAGAAA{AAѮAHAЏ\AQAͅA33AѮAQAϮA  AЏ\AAϮAυAA33A33AAffAΏ\AQAA{A
=AGA=qA\)A(A33AAffAQAffAQA˙A  A
AzA
=AAAHAAϙAAzAA
=AGA  AљAԏ\A{A
=AAҸRAzApAAAA33AθRA=qAAAA33A{AΏ\A33A
=AиRA(AΣA(A
=AͮA\)AϮAQAAθRA(AϙAzAGẠAAA33AffAffAzA\)AQA33A˙A33A
=A=qA
A33A  AAffAffAAQAAǅApAApA=qA  A  AA\)A(AGAGAΏ\ApAϮAGAυAAϮA
A
A{A{AӅA  AQAGA(A͙AͮA͙A͙A͙A͙AΏ\A=qAΣAΣAΏ\AAHAAAQAzAΣAHAzAQAzAA˙A  AzAA
=AQA{A  ApA33AθRAA(AυAQA=qAϙAzAzAGẠAˮAHAAffAAHAʸRA{AHA˅AGA
=ẠA
=AͅAͅAA{AA̸RAffAǙAGAffAȏ\AˮẠA
AA33A=qAθRAA33AͅAffA33A  AͮAzA  AУAAЏ\A33A\)AzAAиRAυAAϙA=qAAϮA{A
AAA\)AυAA
A  AzAЏ\AυAљAυAυAAGA  AHAzAzAzA̸RAHAHAffA\)AϙAHA\)AAAA33A
=AΣA=qAΏ\AHA33A\)AυAGA
=A
=A33ApAHAffAAɮAˮApAAA͙A\)AA
AǮA  A{Aʏ\A
=AǮAzAǙA
=A(AA
AθRAApAGA̸RAͅẠAͅA33ApAAͅAA=qAAA(ApAυAQAA33AA
=AAA{Aԏ\AAԸRAAAA33ApAՅA=qAծApA33AՙAAAAңAңA  AffAA
=A  A\)AAΣA  ApAͅAθRAAffA(AυAzAQA  AΣAυA{AͮA  A(AAHAffAAAHAGAzA{AʣA(AGAQAиRAA(AApAAApA33ApAApAѮAA
=A(A=qA
=A̸RAиRApAиRApA=qA  AAzAԏ\ApA
=AGA(AzAApA
A=qA֏\AA
=A
=AHA֣A֣A֏\A֏\A֏\AA֏\AzAffA(A
A  AA(A{A  A֏\A(AծAՙAծAAGAQA=qAffAA\)AQAQA=qAAAԏ\AAHAApAԸRAA=qA=qA  A=qAˮA\)AAAHA33AAAθRA\)A\)A\)AzAAυAApAϙA(AУAиRAAУAAAGAzAHAAzA{AAAӮAԏ\AAzAAA
=ApAٙAA(AffA=qAffAAHAffA
AA
A
AٮAQAA\)AHAAzA33A=qAHAzA  AAأA{A׮AAGAGA֣A
=AQAAzA  A=qA{A(AQAGAԣA
AAA
=A33A  A֣AAҸRA{AљAҏ\AGAңAҸRA(AиRAѮAAApAAУAzAљAҸRAApAGApA33AυA=qAAAGA=qAQAA  AAAGAHAAzA
=AAAѮApA(AAzAѮAљA(AҸRAӅAңAңAҸRAAљA33AңAzA=qA(A(A(A=qAиRAA\)AѮA{A
=AA
=AхA33AAҏ\AAA{AQAffAffAљAffAAffAAңAA33AңAA{AљAAHApAυAzAAAHAȣA
ApẠA˅AAA͙A33AzAẠA=qApA33AQAffAA{AA(AffA(AQAApA\)A{ApA33A33AϮA{AAҸRAGA
=AԣAApAңAҸRA(AA
A=qA33AӮApAQA\)AЏ\AAͅAΣA  AffAApAA
AӮAAӅA
=Aҏ\A(ApA\)AиRAHAӮAӅAӅAҏ\AљAAϙAAAA=qAGAAѮA33A
=AAHAApA  AAϙAffAGAA\)A
=AυAzA͙AθRAzAffA
AzAʸRApA  ApẠA
A(AGA̸RAͮAzA͙AA  A\)AAA\)AΣA
AzAAA33AAGA
AA33AхApA33AQAυAAzAzAAAAϙAAHAѮA{A(AffAAҏ\AQAҸRAHAA\)AхA  AHAΣAGAffA33A
=AAGAzAЏ\A
=A(AAQA͙A
AGA33A
AͮA\)AGA{A  A\)AA̸RA
AA  ApA=qA=qA{A33AHAəAAʣAA
AΣAffAQA˙AHAHA33A33AʸRApAA̸RA=qA͙AQA˙A{A\)AAAHA33A{A33A˙AAAGA˅AA33A33A=qAzAA̸RA̸RA̸RAAHAͅAͮApA{A{A=qAzAAϙAA  AAQAGA  AA
=A33A33AA
=AϮAA
=A=qAиRA\)AͮAGAA  AA  A\)A(A=qAzA˅AˮA{Ȁ\AʸRAəA=qAffAAGA
=AAHA
A{AQAzȀ\ApA(AGApApA
AGAA33AQA{A  AzAθRAGA\)A(AffA  A\)AQA\)AϮAQAиRAѮAAңA
=ApAQAԸRAQA=qA
=AHApAHAӅA
=AQAңAхAиRAAffAffAЏ\AHA\)AffAҸRA\)A
=AAA33AAA(AծAApApAGA  AQA\)AծAGAԸRAffAQAәA33AffAHAAҏ\A\)A\)ApA33AΏ\AA
=AAAHAΏ\A33AΣAffAϙAA
=A33A  A\)AυA(AΏ\AθRAQAzA{AA=qA{A=qA33AͅAA33AAA33AљAGA
A(AQAHA
=A33AӮA{AAA
=A\)A
AAA(AHAHAA
AՅA33AAԣAԣA(AAA{AApAиRA  AGAHAAAЏ\AAхA\)A=qA\)A\)A33AHA
=AzAAAAHAՙAծAӮA{AA33AAхAAЏ\AQAQAϙAQA33AQAAθRA{AffAA\)AʣAЏ\A
A\)AQA
A
=AAУAAͮA̸RAAGAApA  AQAQAQAҸRAңAA  AAԏ\AԣAApA
A
AQAzA֣A33A  A{AׅAָRA=qAffA=qA{A=qA=qA\)A{ApA
AGA
AиRAУAθRAиRA
=AϮAA(A\)A33AHAAffAA{AHȀ\AA=qAffAϮAHAυAAҏ\A{AApA33AHAQAԸRAЏ\A
=A  AAffA
A
ApA
=A(A33ApA̸RAͅAzAzẠA  AͮA
=AA{AffA33AHAʸRA=qAQAQAffA(AffA
AQAzAЏ\AzAA\)AAυA  A\)AffAΏ\AApA=qA(A(A  A͙AAAHA  A  AͅA
=A
A33ApA  AA
=A(AAУAzAAAA\)A33AQA=qAHAzA
AəAȸRA
A\)A  Aȏ\AffAʏ\AɮA\)Aȏ\AzA{ApAHA{AAffAʸRAɮApA=qA͙AAA(A=qAAffAAΣA33AAУAѮAAGAApAffAffA{AAAAĸRAA{AƏ\Aȏ\AA  A33AəApAȣA
=AzA\)ApA
=AϮA  AHA{AAʏ\AzA͙A\)AzA=qAʣAA33AAHA=qA(A{A=qA\)A{AGA33AHAA=qA(AzA33AAAAΏ\AAAffA̸RA˅A=qA
AffA\)AGA=qAQAApApAAAAA(AͮAΏ\A
=A  AЏ\AffAϙAHApAA=qA(AљA\)AHA  AA=qAѮApA  AAAAAAHA{AffȀ\AͅAAAAzAA33A33AGApAљAAиRAQA  AQA
=AA33AңA
AңA=qAңA
AЏ\A(AхA=qApAAzAәA=qAУAAHA\)A33ApAУA
AffA(AAAAQAϮAͮAΏ\AθRApA33AQAzAΣA(AHAQAGAAQA
=AљAҏ\AҸRAAGA  A33AϮAA=qA=qAzA{AϙA=qAңA(A  AQAAHAffAљAхA\)AAУAAAљApApAAApA{Aҏ\A(AAAңAAGA{A  A  AӮA
=A33AAA\)AA33AffA
AffAzAAԣAԏ\AAAAA
=AңAAѮAЏ\AЏ\AAθRAA{AΏ\A=qAQAϙA  A
A  A
ApApA  AAΏ\AQAQAθRA
A{AΏ\A=qA
AQAA  AAυA\)AGA
A  AAУA
=ApAхA
=AͅA(A(A
A{AzAϮAΏ\AϙAffAHAљAυAϮAzAzAQA
A{A  A(A=qAzAЏ\AffAУAЏ\AЏ\AffAЏ\A  AAAУA
=AA
=AљAѮAхAљAѮA=qAәA\)AzAHAУA(AΏ\A
A33AυApA{AиRAхAHAA
=AA
=AHAͮA
AzAHAQApAљAAzAA\)A\)AAУAffAAЏ\ApAңAAAәA
A
AAңAAΏ\AAңA\)AHA(AGAȏ\A\)A33A
=A
=AAͮAA  A\)AAzA
=AHAA=qAAHA  A
AУAHAHAApA
=A
=AHAӅAҸRA\)ApA{AHA{A  AңAљApAЏ\AѮAԏ\AAAՅApAӮAA(AAAQAхAAA33AȀ\A  A33AAʏ\AʣAQAAzAͅA
AGA
AffA͙AGA(AʣA  AzA˅A(A=qȀ\A
A{AΏ\A\)AυA  AΏ\A\)AAʏ\Aȏ\A  AA(AȸRAzAƣA  AAAɅAAAffAəA(A˙AˮA
=AffAɮAGAQAǅAȣApA  AGAʸRA
AHA˅AʣAHAʏ\A(AʸRAAʸRA
AɅAʸRAȣAAǮA  A
=A(AHAͮAGA\)AAA
AAQAQAʸRAʏ\Aʏ\A
=A˅AGAʣAʸRAʸRApA33AAA  AAHA33Aʏ\A
=A=qApAȸRA
=AřAĸRAÅA{A33AQAʏ\A33A
A\)ApA\)AɮA
A33AA\)AHAffAHAAA=qA33A
AϮA˅A  AA
=A͙AͅA
AffApAϙAffA{A(AΏ\AzAffA
A͙AA  A  A{AQAΣAAHA33A
=AAGAA
=AθRAzA=qA
=AAA=qAͅAΏ\AAϮA{AffAљA
A
A  A
AAA{A  A=qA{AffAHAAGA  AυAHA
=AAA=qAΏ\A͙A
=AApAϮAHAA{A
=AAApApAAẠAQA(AA33AхAA\)AAAffApAA=qAȀ\AAͅAͮA  A
A{A
=AЏ\AQAAA\)AGAAHAԏ\AA33AAQAHAיAA=qA
A؏\AظRAٙAA{AיAHA(A
A֏\AָRA
AAHAҸRA(A=qAzAQAAA33AQA֏\A
ApA=qA֏\AָRAQA  AA=qA\)AApA
AA  A{Aԏ\AՅAՅAAGAHA
=A
=ApAՙA{AAHA
AљAHAzAA
A
=AӮAGAՅA\)ApAԣA=qAљA33AGA
=A  AGAAffApAHAAAzA33AAԣAffAffAzAAGA33A\)A
A{A(A=qA=qAԏ\Aԏ\AzAԏ\AQA=qAԏ\AAAԸRAffAA\)AHA=qA{AffAHA
A
A=qAA{A
AAA  AљA33AGA{AQAAՙAAԸRAA\)A{AӮAHA
=A
=AGA
AQAԸRAzAԣAәAҏ\Aҏ\AәAA33A
AУA
=AΏ\A\)AzA{AffAУAҏ\A33AA(AԸRA  Aҏ\AңAңAHAzAAGAzA\)AՙAA
=AffA
=AأA{AQA(AڸRA33AAQA(A(A(AAA(AQA=qAܣA܏\A܏\A{AA
=AٙAAA
A؏\A  AAHAAzAٙAHAAffA  A=qAA=qA\)A(A(AffA{A(AAQAAGAAAffAffA  AׅAffA  AAAծA(AծApA  A\)AGAˮApA  A׮AHA
=A\)AٮA
A(AԸRAAHA(AGA֏\A\)AGAzAAApA׮AGAٙAAQAمAAAGAA\)AۅA(A  ApAۅA
=AڣAGA{AQAQAzAzAzAQAffAffA(A
A  AQA\)A(A(AۙAA
A(AۙA33A{AAA؏\AծA{A  A׮AAzAzAA{AظRAA{AAffA؏\AٮA
A
AHA(A֣A  AظRAA
=A33A\)AAGA{AծAԏ\A  AAӮA
=AAA{A(AffAЏ\A
=AиRAиRAApA33AA\)A\)AffAzAAA(A֏\AAՙA(A֏\A\)A33AGAAׅAGAHAHA֣A  AָRAAӅApAӮA\)A{AQAffAAיAׅA\)AAأA33A(AУA{ApA=qA\)A
=AHAAҏ\AиRAΏ\AQA\)AffAA\)AAzAʸRA\)AQA=qA˙AQAAHAǮAƸRAʸRA{A(Aď\AAŅAHAǅA(A\)A33A
=A£AHAGA=qA
=A{AHA͙ApAǅA=qA33AȀ\AˮAApAʣAA
=AGA
A33AǅA(AzAAA{AApAzAGA33A\)AƣAHAA͙A
ApA33AHApA{Aʏ\A=qAAəApA=qA
=AHA
=AGAGAAffA\A33A{A{AApAGAA\)ApAA=qAA(AAzAGARAA\AHAffA=qA33AA33ApA\)A(A33ApAAAA\AffAApAHAffA
=AzA
AîAA£AA£A
A33AA(A33AƏ\AǅA̸RA33A
=AAffAzAA(A33A
A=qA(ApAAȸRA=qAzAGAAzAď\A
AQA\)A˙ApAΏ\AA
=AQA33AAzAQA=qA(AAA
=A=qAAA£AA
=AAzA=qAAAģAřAAA
=AHA£AzAAA33AAAAAA£A{A=qAApA(AA(AAA\AffAGAHAAAffA
A=qA
=AA{A\)AGAApA{AAHA\)Aď\AQA=qA
AAGA
A33A=qAQAffAAffAzAʣA=qAAA
=AAQAApAƸRAAAA  A=qAzAQA
=AǙA
A
A=qA
A33A\)AA(Aȏ\A(AAGA  A  AzAƣAAŅA=qA\)AffA{A{AA{AAɅAŮA  A  AGAGAQA33AģAAǙA33AHA
A
=AA  AřA\)A=qApA¸RAÙAQA
=AƏ\AGAAHA
=A{AzAffAGA\)A33AHAA
=AApApA{AAÙA\)AA{A(AA
=A(Aď\A=qAA{AHAɅAȣA  AffAA  A{AǮAffA=qAŮAAA{AA£AģA(AGA  ApAŮAffAAAAřAHAʣAA=qAɮAffA=qAəA=qA33AffAAřAGAAAGA
=AA(AGAA(AffA
=AAA  AAzA\)AəA
AA33AƣAffA
AɮA
=AzAffA(AϮAϮA(AHA{A
=A{A
AυA=qAљAҏ\AAAԏ\AAA=qAHAAυAzA
=AA33AGAAљAAхAA33AУA
=AAиRA
=AGAGA33A  Aʏ\AˮAGA  A  A  A
AA33A
AυAHAA  AApApA{AQA=qAAAHA(A̸RAA{A
AGAɅAɮA=qAGA  A
A
A{A33AˮAͅẠAQA
A{A=qA{AQAУAGA  AA(AGAAQAAA33ApAA(AQA
=AffAzAAЏ\AУAУApAQA33AHAԣAϙApA(AAHA
A
=AzAծAAԏ\AAәA33AңAҏ\AA33A=qAA(AApA\)AәApAӮA(A
A
AӅAҏ\AQApAЏ\AHA{AzA=qA
=AHAzAA{A33Ȁ\A
AAͮAƸRAAǮA
=A
A(ẠAffA\)A˙AA\)AHAʣA
=A{AǙAAGA˙A(ApAͅA˙AGAΏ\AQAAQAθRAAAAQAHAӮAffAA=qA=qAQA֏\AffA  AA\)A(AЏ\ApAAٙAHAۅAڸRAffA\)AڸRA=qA
AffA{AҸRAͅAAծAӮAAzA\)AGAffAAA(AGA(A{AљA\)A(A33A33A{AأAApApAHAzA=qAA
=AӅAffAיAԸRA(AҸRAAӅAAQA  AQAAҏ\AzA(AθRA=qAΣAffA{A33AΣA(A  A(AAQAңA=qA  AAzAAӮAԏ\AGAծA
AzA֣A33AAA  AHApAمA
A  A  A=qA  A=qAA
=A
=A\)A{AzAAAڏ\AمAzAڸRA
AٙAzA=qA  A\)A׮ApAA
=AA33A{AHAAיAA=qAAңA  Aԏ\AA33A  AAffAԏ\AHAљA  A33AHA(AGAAGA  AΣAAA{AzAffAхA{AffAҸRAzAAA\)A=qAHAQAzA{A=qAAљA\)AәAHAA
A
A  A=qA
=A(A  ApApAծAffAQAGAzA{AGA33AٙAAA(AAظRAQAQAٮAمA  ApA  A  A{A  A
=AAׅAAAׅA\)AA=qAԏ\Aԏ\AHApAA(A
A
A=qAA\)A
=AHA  ApAA33A33A{AQAffA  A  AAAɅApAȸRA(AAˮAAθRAAͅAQAffA{A
AAӅAAA{AHApAיA=qA֣AHA֏\A
AzAzA{AA\)AffA(AAA
AQAA33A  AAHA؏\AAٮAڏ\AA\)A\)A=qAڸRAAGAGAzAGAffA
=AA
=AAHAQAָRAAׅA֣A=qAA
=AϙA=qAԸRAzAffA֏\AQAzAzAҸRAHAAAAHAzAәAиRA=qAGA
A=qAGAәA\)AϮAυAQAУA33AиRAϮApAәA  AHAҸRAffA
=AθRA33A֣AA  AAffAՙAA(AA֣A׮A{AA{AAzA֏\AA׮AA=qAHAA(AمAffA(A  AGA33A܏\A݅A
=AHA33AݙAݮA\)A܏\ApAڸRAڏ\A(AApAAQAffAܸRAA\)AffAffA(A
=AAQAAיA֣A33AظRA
=A(A֏\A  AԣAApAGAHAәAיA=qA  AQAzAA=qAApAA
=ApApAٙAAظRA{AظRAAA(A֏\A  AA(A  AzA\)A؏\A  A\)A؏\AHA33AGA֣A֏\AA\)ApApAיAAA
A{AأA
=AAHAأAظRAAظRAأA؏\AffAApAA
=AAQA
AA
=AӮA\)AzA
A{A33AA33AAHA=qAϮAΏ\A(ApAHAθRA̸RA̸RA
=AA  AHA(A33AAиRAHAGAzA\)AУAGA33AAθRAGA=qAУA(AzAA  AΣAzA
=AAϮA\)A  AHA\)A
=A{A  A\)AAGAA=qA{AљA=qA{AA(AzAӅAAzAQAQAՙA֣A{AAGA=qAA{AAzAԸRAHAA
=AA
=AԸRAԣA{A(AGAԏ\A=qA(AA\)A
=AҸRA
=AѮAffA̸RA=qA
A=qA{A  AAAAAAQȀ\A
AAУAQA  AAϙAAA{A  AAQA  AAˮAʣA33AˮA(AAzAAGAAQA͙A
=A(A33AΏ\A
=A
AθRA
AΏ\AυAA33AffAffAHAApA(A33A
=AGAQAAHAA(A\)A(A֣AՙA
AՅA
AQA֏\A33AׅAA
=AAҏ\A(AAGAHA
=AzA
=AffA33A{AծApAAA
AQA=qAθRAzApA֣AAGAиRAQA(A=qA  AAAAΏ\ApA=qẠA̸RAzA̸RA(ẠApAЏ\A
A33AAҸRA(AͅAA
=AͅAυA\)ApA{AAA  A{AљApAңAӅAApAхAGAљAffA{A{AAAAAЏ\AHA\)A=qAA33AA=qAӮAӮAԸRAAՙA
A
AQAHAA\)A  A{A(AAQAAApAυA33A=qAGAׅA33AָRA
=AzA(A\)AAA  A{AQAzA=qAׅAAәA\)A
A
=A
AәAAҏ\AңA33A  A=qAυAͅAͅA=qAQAЏ\AHA  A  A\)A
=AAϮAAA33Aʏ\AQAAQApAϮA
=AffAAHAffAңAѮA  AӅAffAA  AәAҸRAңAӅA{A
A33A\)AGAәAٙAAQA  AۅAٙAۙAܸRAzAݮApA݅A33AٮApAA܏\AAQAAAA
=AGApAGA\)A=qAA\)AffA
=A=qAԣA  AQApAיAQAGAzAffAffAGAՅAׅAԸRA\)Aҏ\AӅA=qAQA\)A\)AңAffA  AzA=qA33AAffAAQAAAңApA
=AՅAGA33AzA
AAиRAծApAׅAAzA{A
=AAA=qAָRAA33AQA=qAGAA(A\)AQA=qAAAQAzA֣AAffA؏\AHA33A\)AٙA
AQAffAQAA
=AڣA{AffAAzAQAٮAApA
=A
=AظRAzA؏\AAׅA  AHAzA
=A33AҸRAHAffAHAzA
AAԸRAAHAԏ\AAӅAA=qA=qAԏ\AAAffAӮAAҏ\Aҏ\AAиRA  A=qAѮAΏ\AAиRA
=A\)AGAΏ\AA\)AA=qA
A׮A{AQAffAA؏\AٙAٙAffA=qA  AՙA\)AQA(AApA\)AGAzAzAAGAAGAQAAHA݅AݮA=qAAAGAGAܸRAffA\)AۙA{A{AHA׮AGA{AA(AՙAAzAHA
=AәAA{AzA=qAиRA{AGAHAffApApAAzA=qAQAңAAУAυA  AAAхA=qA
=AGAAхApA=qA  AffAAͮAЏ\AAϮA
=A
AңAA{AхA33A\)A(AffA  AA
AѮA\)A(AzAҸRAӮA{A(AӮAAAzAԸRA\)A
A֏\A֣AA
=AAָRAAzA33AGA\)AָRAָRA{A  AՅApAՅAApA
AAԣAӅAҏ\A33AHA  AGAәAA
=A\)A\)A33A
A
=AQA(AQA=qAffAffApA  AGAHAԸRA33A{AAffAУAңA  A
=A  AՅA
A
A
A{AңAzAхAQA\)AУApAA  AzAԏ\A=qAAծAHAHAظRA  A
AQAAA
=ApA(AffAHAA\)A(A\)A\)AA  AظRA  A{A
A
=AzAA
=A\)AAffAA  AAٮAمAHA{A
=AAGAA(AAApApAAHA33A
ApAأA
=AzA{A\)A33AԣAӮA
A=qAԏ\AA\)A
=AAffAAffAffA=qApAHAAQA
AՙAՅAՅAzA֏\AffAAיAApApAAzA(AӮAHAӮAљAҸRA  ApApA{A{A
=A(AљAAхAљAңA=qAәAA
=AAAHAQA33AҸRAAGA\)AՅAQAָRAHApAיAGAGAGAHApAAA
AApA=qAAԣAңA{AHAӮAzAA\)AأAA\)A\)A(A
=AzA  AAffAӮAҸRAAAzAңA(AA
AA֏\AңAծAA  AՅAAծApAӅA
=AQAzA{A{Aԏ\AA=qA(A33AzAӅApA(AAA
AѮA{A
=AAAиRAхAHAAApA  AңAHA\)A  AffAQAԏ\AHA
=A
=A
=A
=ApA\)A33AGAՅAՅAָRA
ApAծAAAAA
=AQAәAA  A33AAffA
=AAՅA33AAHAՅAA
=A\)ApA=qAffA
ApAGA
AA(A{AzAAӅAѮA{A33AA33A(AAGAAծAHApAffAGAЏ\AѮAA=qAAHApA\)AGA
AՙA=qA
=A׮A(A{AأAzAAGAHAA  AGAծAHAӅA{AӅAffAәAAәAffA  AzAAAԏ\A  AAA
=AљAAQA
=A{A{AHA  AGAA(A=qAΣA=qA
=A=qAzẠAAA  AQApA͙AffAzAApAAϙA
=AиRAAGApApA\)AA{AУAЏ\ApAљAffAхApAиRA=qẠA{AffAθRAQAϮAAA̸RAͅA
AAHAGA(AHA͙AθRA33AϮAУAAA33Aҏ\AӮAQAԏ\Aԏ\AAGAAAGAA֏\AGA{AzA{AظRAٮAQAzAzA{AAAAHAظRAA  Aڏ\A\)A
=AHA(AQA=qA\)A{ApA֏\A  A
A
=A(AA  A33AQA
=ApAظRAAA
=AHAHA(A33A  AGAzA{A=qAffAׅA\)AڣAAApAAzAA
=AA
AA{AA
=A{AA33AQAQAQAAffA
=AGApA  AzAHApAAQA
AA{AffAAAGApAGApAA{AzA֣A֣AָRA33A33ApAHAQAӅA
AGA(AңA{A
=A(A\)AΣAθRA\)AffAA33AQAHAиRAѮAУAΏ\AQAffA{AAͅA
=AԣAA{A
=A(AffAA
=AAԸRA֣AָRAיA
=A{AA
AA
A͙AӅApApAffAA\)A  AΣAAGAzA̸RAAAAffAHAA  AQA33AɮAHAẠA33A{AΣAθRAAAffAHAљAҸRAӅA{A33AָRAA
A(A؏\AأAffAיA33A\)A
=AA
=AQAA\)AָRAApA\)AGAAָRA
AzAңAAЏ\Aҏ\AAffA33AϮA=qAGAHAAָRA  A{AAԏ\A{AHAGAԣA{A{A=qAԣA
AA33AAHAAAHAGA  AGA˅A\)AϮA\)AA(AAQA(Aԏ\A\)A  AծAffAAظRAHA(AA{AAAיA؏\AٮAHAA=qAAAڏ\AAۅAAQAHA
=AA  A޸RAޣAAAAAAޣAHA33A\)A߮AAzAܸRA{AAAAڸRAיAՙA33A֣A33AQAأA׮AָRAzAffAՙAָRA\)A֣A
=A\)AzAGApAԏ\A(AQA
A33AGAHAיA׮A
AҸRA=qAӅAGA֏\A
AхAӅA\)Aҏ\A\)AAAGAffA{A33AAأAHAQA(A=qAڣAffAٮAՅA
=AAGAיAHAAAA  AڣAHA33AAffAHA݅AݙA
AQA޸RAޏ\AApA߮A33AQAAݮAAA33AݙAGA
=A33ApAAݮAݮA(A܏\AٙApAQA(AڸRA\)AA{ApA\)AAHA؏\A؏\AAA(AծA֣AzA(A33A׮A
=AAzA  AffAAQA33A=qA{AЏ\AυAGAAA\)A=qAA{A{AHAAиRA  A33AQA=qA(AAQA֣AA
=AHA
=ApAׅAQA33AGAffApAAzApAzAݮAAAޏ\AߙA\A{A(A=qAARAApAHAAGAApAHA
AAޏ\A  A33AzA33A33A=qA33AיAمAA\)AGA33AA݅A  A=qAGA\)A  AA
=AzA{AGAۅA
AGAAָRAԣA33A
=AzA  A֏\A  A֏\AAׅAיAAأAQA  A
AׅA
=ApAQAffAԏ\AՙAծAA{AAzAApAיA  AAGAٙAڣAAۅAAQAݙAޏ\A\)A
A߮A  A(AffAzAARAAARAffA\AA  AAAAAA
A  A33AݮAzA  AAzAޣAAQA
AAA
AAzAܣAәAAAAA
=AffApA݅AzAݮA
A33AQAA݅A  Aޏ\AA߮A
AޣAA33AA\)AAHAQAA(AHAApAٙAڏ\A=qAHAܣAAzAGA=qAAۅAۮA܏\ApA  AHAAAffA
=AA(AzA
=ApA  AA(AA
AAA{A\)ARAzAAA33AߙAffAAffA33AzA(A{AٮAAܸRAAA܏\A33AzA\)AAzA  AHAAQA{A\)A܏\AAzA{A  A(ApAمA؏\A=qAڸRApAAA  AGAܣAQAQA
=AۙApA33ApA؏\A=qAAA
A  AA
=A  AzAڣAAHA
=AڣAۅAڸRAQApAݙA
=AAݮAޏ\A߮AzAA\AzAA\AAAHAQA  A=qAAA(A=qA
A  A=qA߅AzAA=qA\)AݮA
AA
=A  A=qAQA{AA(AA  AHAHA33AAAHA  AۅAA
A=qAA{A؏\A
AԸRAzAAGA֏\AԣA
A=qAAGApA(AAA
A33AGA{A=qAڸRAAQAٮAQAܣAA33A\)A  AݙApAAޏ\AA(AAA\)AߙAARAAA
A  AAAAAAA=qA(A(A{A(A  AA33A\)AAޏ\AݮA߮AzA(AߙA
AffAAߙA\)AٮAAQAAڏ\AיAffAGAծAHAffApAHAApA\)AffAAܣAAAffAQAA\)AGAAGAܸRApAڣAծA  A\)A
=AffAAA{AAffA{AAأApA
=A  AzA܏\AA33A\)A
A(AffA
=AAA޸RAGApAA(AQAQAffAAAHAHAA
A
AAAHA޸RAߙA޸RA  A\)AAQA=qAܸRA  AۅAA
AAܸRA
AzAAۮAAݙAݮAAGAܸRAQA{A=qAAݮA܏\A\)AAApAHAܸRAzAffAܣAAGAڸRAڸRAHAHAGA  A=qAڣAHA\)AAAGAGA\)AA
=A33A݅AA\)AHAHA{AGAۅA  A=qAܸRAܸRA(AA\)AۙA
=AڸRAۙAمAHAApAHAffA33AGA{AApA33A
=A
=AHA
=AڸRA\)AۅAۙA
=AApAۅAۮA{A=qA=qA{AڸRApAGAA
=AAGA؏\AظRAAzAAٮAA{AָRAיAA  AمAzAٮAApAA
=AQAAՙA(AӅAA  AHAхA
A  A  AA\)AAՙAAAхA=qA׮AQA׮A(AAQA33AۮAffAQA݅AݙAQA=qA=qA  AzAAA  A  ApA
=AAظRAQAzA؏\AzAHAA
A  AAHAHAأAAffA׮AAHA\)AمA\)A33A\)AGAGA33A؏\AظRA
=AffA{ApAأAׅApAمApAٮAAQA֏\AծApAGAAՙAGAԸRA
AӅA\)A
=AGAҸRAңAхAzAGAHAәA
A\)ApAAՙAQA  AA(AA
AծAQA\)A
AQAA
=AAڣA
=A
=A
A{A  A(A=qAffA܏\AAܣAܸRAAHAܸRAܣAffA(A  A  A(AۙAGAAڸRAAQA{A
ApAGAQA֣AGA=qAAظRAHA=qA33A
A
=AHA(A׮A
A\)AAQAAAиRAA=qAffA{AAAA\)AAApA֣AA=qAAיAיAՅAA=qAծAffA
AffA  AAיAGA(AHAٮA=qAApApAٙA{AQAڣAۅA{AAAڸRA
AQA=qA܏\A܏\AffAQA33AڸRA{A(AٮA{AمAA33A(AڣAGA
A33AA33AGApAԏ\AӮA\)AA33A
AAAA  A{ApA  AӮA
AffA  AңAӅAҏ\AхA\)AљA  AӮA  AԣAיAA
=AхAңAGAҏ\AҸRAҸRAHAҏ\AHAAУA  A
A33AυAυAA=qAffAAAGAхAAQAAA\)AӅAӅAA
=A33AAAңAzAffA(A
A
AAAAѮAхA\)AGA33AApAA\)A  AυA\)AQA  AzA  AHAA(AffAzApAzAͅA
AˮA
=AffAAzA
=Ȁ\ẠApAΏ\AzAApAϙA  A
=AA\)AʣA=qA{A=qAʸRAA33A33AʸRApAAAzA  AȸRAˮAʣA\)AGA\)A33A
AApA\)A(ApAffApA{A\ARA(AA  A\)A
AAffAGAAAGAA{AAAQAîA
=AzARAHAAHA33AHA=qAAA=qA
=AAAAAzAA
ApAA
AHA33ApA=qAʸRAA{A{AQAQA
=A33AȸRAAAAHAGAƣAģA{A˅AGA{AAzA  A  AzA(A{A=qAAAffAzAffA(AA=qApAHAA\)AиRApAңAffAAӅA
A=qA33AffAиRA\)AA
AzAхAυAA  AӮAAGAHAGAffA\)AљA  AzA=qA
=AAffAѮA{AAA\)Aڏ\AGAHA
=AAAأAٙA  A(A33ApAQAffAۮAڏ\AQAڣAڣAQA{A
A\)AQA
AAGAAԣAمAHAA(AAAAAՅA
AAՙAAԸRAҏ\AAՅAԣAGAՙAzAffAҸRA=qAAѮAӅAәA=qA  A\)AQAAиRAA(AA
AͅA33ẠA(AʣAA
AffA{A(AGAApAϙApAzA
=AA
AA33A{AQAGAәAffA
=A=qA33A؏\A33AQAAAHAzA
=AGAۮAA=qAA  AA33AٮAمAHAAHAAffAمAAљAAAHAAԏ\AAQAHA{A{AAAA
=AGAAAϮAAϙA
=A(A(AΣAΏ\AA  AAA(A
=AՙA{A  AHẠA͙AϙAәA
=AҸRAA
AGAԣAGA
=AGA\)A
=AAAԣAՅA  A{AzAҏ\AzA(AffA33AGAиRA  AӅAָRA׮AٙAAڣAڣAڣA=qAAۙA܏\AAAGAA  AAٮAAA(AAHAAՅAAՙAҏ\AA33AڣAA  AA
A
A
=AA33A{AӮA
=AمAQA=qA{A{Aԏ\AHA{AAA{AׅA{AAzApA{A֏\A{AffAAٮAمA=qA=qA=qA33AGAծAAԸRAAՙAHAA=qAڸRAAHA\)AA33A=qAA{AٙAHAڸRAڸRAGA\)AۅA
A(AAAAAAGApA݅AGA33AAܸRAzAAGAA\)AHAAA  A{AA(A
A  A؏\A{AffA{A֣AA\)AՅApAӅAAHA{AffAѮApAҸRAffAA
AQA  AAzAԣA
A\)A\)AӮAzAAӅAffAzAzA33AGA=qA
AAϙAA{AQA{A33A  AԸRAzA(A{A\)AAGApAAQAAԣAԸRA{A{AׅA(AA\)AAA
=A\)A\)ApA\)AGAۅAA
A
AڣAAۅA
ApA33AzAffA(A
=A=qAQA\)AAQAәAAAԣAGAA
=AQAAأAzA֣AA(A\)A
A=qA
=ApAAA{A
=AAϙAA  A
=AAHAٮA  Aҏ\AzAՅAGAAAApAAϙAffAAԏ\AffAAԏ\AA
=AzAAAQA=qAzAA{A
=AٙAڏ\AڸRA33AQAzAAAAޣAA(AAApAApAQA(AAA  A33AܸRA  A
AQAۅAיAffApA\)AA\)AיAٙA
=A؏\A(A{AzA
=AGAA\)AA=qA33AA֏\A33AffAA؏\AٙAQA
=AڸRAڸRApA܏\A=qAApA=qAхA{AԣA׮AծA
=ApA
AٮAۙAHAܣAٙAA
=AظRA  AۅA33A
=AۙAA(A\)AAمA\)AAQAݮAۙAۅA{ApA
A(AٙAA
=AQA=qAޏ\A\)A݅AA\)AݮAHA܏\AAA(ApAffAHA؏\AӮAAQA
AzApA  A{AٮA
=AA{AGAGA֏\A֣AGA33AיAיA׮AzAQAA{A  AAQA֣AיA  AA33AQApAԏ\AхApA(ApApApA{AљA  A33Aҏ\AиRAzAϮApAυAQAffA33AAיAQA=qAA֣A\)AAA  AA
=AQAٙAffA(AAA܏\AܸRA
=AGAݮA=qAޏ\AAQAAA
=AHA߅AHAAAA
A
A
ApAۙA܏\A{A  AApAAA=qA(A{AٙAAffAHA
=A(AHA  A؏\AGAAApAՙAHAHAA
AۮAA{A33AHA  AAAHAمAQAffAffAzAA=qAיAGA׮A
=A\)AمAA
=A=qAQAzAۙAA33Aڏ\A\)AAAAAzAAA{AܸRAA
=AAݮA݅A{A  A\)AGApA\)A
=AGAܸRA܏\A=qAApAA(A\)AڣA
A\)A33AۅAGApAۅA=qAA{A
AzApAڸRAٙA33AAHAٮAAAٮAٮA֏\AzAיAHAA33AAffAQA{AGAAӅAHA  A
AѮAGA
=AAHAA
=A{AA{AڣAzA  AՙA  AAՙAGAffAԣA\)A
AzAHAׅA  AظRAٙA=qAڸRA
=AۙA
=AffA܏\AܸRAAHA33AAGAAݮA(AݙAzA{A(AHAۙAGAAQAݮA޸RA
=AܣA\)A{A  A{A  A܏\A{AQAzAܣA=qAAffA=qAܣAAA
=A؏\AffAA
A(A33A33A
=AڣAGAffA=qA=qAQAzAGAӅApApA  A(AٙAAGAمA33AGA{A33AHAAծAffA
=AAָRA֏\A
AzAffAمAffAڸRAڸRA\)A33AGA\)A
=A  A=qAzAܸRA(A܏\AzA{A=qA=qA=qA=qApAۮAAظRAAٮA(AffAHAHA{AzA33AAzAApAQAٮA=qA33ApA(A
=A
=A
AffAzAHAHAAffAzA=qA\)A
=AQA(AHAA33A
AHAAQApAҏ\A  AҸRA\)AA33A
AAffA
=AԸRAAAңAQA=qAQA
AӮAԏ\AңAA  AԸRA
=AA(AQAQA  AAHA
AָRAAAzAA33A33A\)A(A33AAzAڏ\AAApAۅAHAAzA\)AٙApA
=AٙAٮA(A\)AGAمAffAQApA  A33ApAAA33A\)A=qA
=AQAՅA(A(AָRAAָRA33AHAHAָRA(AQA{A=qAڸRAمAAأA33A33A
A
AffA֣ApAָRAׅAAzAA(AffAzAA\)A=qA(AzAHA  A\)AۅA
AffAܸRAAA(A߮AA33A33AAQAzAzAffA(A\ARA\A(A33AzAAAffAAAA
A\)A(A{AۮAۅA(AffA33AA33A33ApA33ApA{A(AffA\)AA
=A=qAzA܏\AHAA
=A
=AA܏\A
=AGA  AGA  A{AffAHA\)AۅAHAڸRAAڸRAffAۮAۅAA33AڣAHAٮAڸRApAۙAQA{A=qA{AQAܸRAGA݅AGAQAffApA=qAA  AAGA33A{AzA\AHA\A(A  AA\)AAAffA
=AAA߅AޣA  A  AݙA݅AݙAݙA33AHA=qA(AzA֣AA
AAGA=qAA
AיAA=qA33A{AA
AffAHAffAQAAAAA
=A33AAAڸRA{AA
=A{ApA(AHAݙA݅AۅA
AGAAA=qA
A33AיA=qAA
=A\)AHAۙAAQAAA\)AݮAffAzAAAApA\)ApA(A=qAAAᙚA=qAA\AQA  ApAGAQAQAffA  AQAQA޸RA  AݙA\)AQA޸RA(AڣAHA{A݅A\)AA
=AHA\)A\)A܏\A
A݅A(AzAޣAޏ\AQAAAA{AיAAGA
=ApAA޸RAffA=qAGAA\)A
=ApA33A33AݙA
=AݮAffAܸRA33AAApAڣAظRAAQAffA{AAڣAA33A33AٙAQA=qAڣAٮA  AHAzApAGAA(AA=qA33AAAAׅAظRAأApAQAQAأApAQAA{AzAAAأA  AיA
ApA33AA33AָRApAHA\)A\)AzA
=AAA  AAיA֣A
AՅA
AHA  A=qA
=AAHAA
=A{A=qA=qA؏\AAיAָRApA(A{AיA  AGA(A\)A(A׮A
A33ApA=qAA׮A  AA{AأA(AڣAڸRAAۙAAA
AzA
=AGApAGA  A(A{AA݅AAٮAffAٙAffAٮAQAQAAzA׮A\)AׅAGAzAQAمA؏\A܏\AAܣA܏\A=qA
AffA  A
=AGA=qAיAAffA=qA33A\)A
=AAљAHA=qAУA=qA{AϮAϮA{A(A{AAҸRAQA=qAGAA  A{AϙA  AHAA{A  AzAAAQAҏ\AzAHAՙA{AHA33A׮AA
=AGA{A=qAffAڣAڸRAApA\)AۙAAܸRAQAApA
A
AݙA
=AܸRAffAݮAAݙA
=AڸRAڣAAۙAQAAA=qAzA33A\)AGA\)A  A  AAAzA
=AAGAAӮAQAӅAAHAәA=qA
=AӅAAָRAQA{AAAAAۮA  AAA=qAA(A(AffA(A(AA
=A(AHA
AָRAA֏\Aԏ\AңAхA\)A=qAA(AAGAGA{AAծA֣AHAHAAAAָRAzAGA
Aԏ\ApAA\)ApAAԸRAԏ\AQA  A  ApAHAԸRAAGA  AAA֏\AAffA{AQAQA֏\A֣AAA(Aҏ\A\)AңAA
=A=qAApAffA=qAׅA  A
AA{A\)A֏\A؏\A33A
=AԣA\)A{A{AAӅAAңA(AхAApAУA33A{AQAҸRAGAQAٙAzA
A؏\AA33ApA=qA(AA=qAQAԸRAAAA=qA33AAAљAA
AHAԏ\AQA\)A(AHA؏\A
=Aҏ\A  AӅAңA{A(A\)AAA33AҸRAԏ\A{A˅AffAAA=qA{AAѮAУAzAУAЏ\AυAͮAͮAHA
AGApA˅AˮAA  AAA  AҸRA
AУA=qAΣAAAAхAϮAәAAAиRAGAAHA  AffAHA33A(AAA33AиRApA33AAzAԣAԣA
A(AA
A(A֏\AיA  AHAffAA=qAQA{AծAGA׮ApAԏ\ApAAAzA33A(A
AA=qA(AAAңAԏ\AԣA(A
=AQAGAA  A(A
=A(A{AGAA33AAѮA
=AffA  A\)A=qAϮAA{AHAffA  A33AA
=AΣA\)AѮA\)AA33AAGAA(Aԏ\AA
=A  AظRAffAظRAAzAQAՙAzAQAApAԣAAԣA  AGA=qAӅA  AӅAA
=AAA33AA33A\)AGAәA33AGA33AՅA
AHA  A
AHA33AQAхA
AAAԸRAҏ\A=qAҸRA\)AGA  A
=AA(AAffA  AHA33A{AθRAAHApAӮA=qA(A=qA33AA(AAAGAGAzAA  AAԸRA
=AԣA
=AAApApAGAͮAA̸RA33AA\)AϙAQApA=qAffAҸRA{AAQAQAأAAA֣AGAأA֏\AA\)AQAA
AAAAGA\)A
ApA
A(A
AQAQAzA  ApAA  AӅApAHA  A\)A\)A֏\AAQAՙA
AGAAծAHA  AffAծA33AAGAҸRAԸRA{AAљApAzA(AzAAυA=qAиRAGAӮA33AffAУAAAӮAAAA=qA(A=qAGA=qAԣAHAzA\)AAzAGAՙA33AיAA{AQAAٮA  AٮA{A{Aڏ\AHAۮAۙAA
A  A{A(AA(A܏\A33AGA  AAAAA33AA\)AHA܏\AA(A
AۙAAA(AQAԏ\A(A=qApAAzAAڏ\AzA  AAQAAA{A(AffApAA(A(AՙAffA֏\AAQApAHAGAՙApAԣApAԸRAffA\)A
=AظRA  AHApAzA  AQA{AٮAڣAA  A\)AA{AffAڸRAAAA܏\A
=AݮA=qAA=qAQAޏ\A=qAݮA݅A܏\AAAۙAۅA(AݙA  A\)A܏\A
A\)A
=A
=AffAٙAzAٙAAڣAڸRAڣAHAAיAA33AAAzAۙA=qA=qA33AffA(AՅA(A
AمAׅApA
=AzA(A  A֏\A{AծA33A֏\AAA33AffAA(AәA=qAHAHAAڣA  AAA=qAffAQAAGAQA
=AծAծAՙAQA{AׅAA׮A֣A  A{AA{AHApAԸRA
=AAHAAՅAՅA33AAԏ\ApAA\)Aԏ\AQAәAHAAԣAHA\)A\)AׅAGAAA33A{AAӮA{AٙAA  AיAHAHAAHA=qAA
=AAԏ\AҸRAԣAAׅA33A  A{A  AمA(AA=qAأAԏ\A{AA33AظRA(A
=AHApA=qAzAA(AAHA33A(AzAA33A\)AQAQA(AܣAAݙAAzA޸RA
=A\)A߮A{AzAffA
ApAޏ\A߮A33A\)AzAAffAA\)A
=AۅAۮApAAzAݮAA\)AڸRAHA
=AHAQAQAظRAڸRAAڣApAٙAܸRAۅAޣAޏ\A޸RA
=A33A
AHAݮAA
A
A(AٮAٙApAظRAAAAzA\)A
AمA׮A
AHA\)A
A33AٮA=qAA
AڸRA׮AٮAffAzAأA
=AٙAڸRAۅA(AffAܣA33A  AQAzAޣA\)AAA߅AA{AA
A=qAApAA
AzAAA
=AAAApAA\)AᙚAA{AᙚAARAzAA
=ApAޣAAAAA
=A߅AQAA\AffAAA\)AޣAffAQA33A=qAA33AAAۅAGAQAٙAݙAHA33A\)A޸RAzAzAAA\)A
A޸RAAAGA{AۅA܏\AۮA\)A\)ApA(A\)AٮAzAGAۙAffA  A  A(A
AۅAHA\)A׮A
AA؏\A{AA=qAzA33AQAffAA
=AA
AԸRAծAӅA  AffAָRAGA  AָRA=qA
A=qAיA\)A֏\A{A(AA  AAGAHA=qAQAHAAQA
=AA
=AAAA\)AGA{AA(A
A{AQApApA{AzA\)AGA
=AHAA(AzA{AȸRAɅA33AffAȏ\AHA=qA{AĸRAzA33AAQA=qA33A\)A{A\AAzA
=ApAAA͙A  A{AͅẠAAˮA͙A
AAQApAAͅAA  A{AϮAA  AHA
AHAAQAAͮA
=Ȁ\A˙AʣAA33AA{Aȏ\A=qA\)AɮA  A  AHAGAAAAA{AAѮAQAAΣA\)AљA  A{A
=AҸRAQA33AAӅAzAA
A
AHAAA
AGA
AAǙAиRAAQA
=A(AGA\)AʸRAzAȏ\A{A
=ẠA  AAAAA˅A
=AHAAҏ\Aҏ\AAAAԸRAA33AAAAӮAAԸRA{A
ApAԣA33A(AffA{A\)AGA
AQAffApA(A=qApA=qA33A㙚A\)AA(AAݮA=qAݙA=qAA߅A
=AAzAݙA(AA
=AffA܏\AظRA\)AQAծA(A
AۮAܸRAA  AܣAۅAzAAffAڸRAأAڣAGAծA
=AGAA
=AхAA׮A=qAGAzAӅAQAQAӅAAAAffA
=AA
AGAQAӅA{A33AA֣AGAHA  A
=A  A=qA
AظRAׅA(AڸRAApAԸRA֣A  AHAQA=qAffAA݅A=qAGAzA\)A{AAA33A  AzAޏ\AAܣAGAzA
=A(AApAיA
=AGAA{A֏\A׮AA33AAٮA׮ApA
AAAAAHAܣAAAAиRAڣAڸRAffAٙAzAӮAA\)A
=A=qAAӅA{AQA
=AAAAHA
=A  AϮAAϮAҏ\A=qApAԸRA{AAԣAAzA\)AA\)A\)AAHAA(A֣A33AAQA(A
A=qAA
AAAA=qA  AA33AAAzAݮA  A
=AffAڣA(A{AApAzA=qA
=A
=AٙAAA(ApAAffAAA׮AיAٙAHApAAQAAAApAHAՅAQA֣AA{AAzAA  AA(A
AAظRAGAffAԸRAQApAGApAAAQApAAffA\)AAHAޏ\A=qA\AݙAۅAAA(ApAGA=qAۙA݅A܏\A{AARApA߅A߮A=qAffAAܣAAיA33AՙA\)A=qAzAAA
A(AzApAA33A(A  AAQAԸRAAzAϙAAӮA{AQAAԸRA
A=qAA  ApAЏ\AхA\)A
AA=qAϙA
=AΏ\A
A˅A=qA33A33A̸RA{A  A
AHAљAA33A33AzAA=qA33AAˮAΣA{AzAЏ\A33A=qA{AHAѮApA=qA\)AHAAA
AAQAzAʸRAffAA\)A\)AGA{AΏ\AθRA
A{ApAAˮAˮA  ApA
AΣA
AϙA{AиRApA
AҸRAϙA=qAʣAəA
=A{A=qA(AGAУAͮAAϮA
AЏ\A33AQAAθRAQAQAΣAA{AffA=qAͮẠAHAˮA\)AʣAAAA=qAͅAGA33A
=Aҏ\A33AGAθRAAffAffA  AϮAA
A
AәAϮA\)AAAAϮApA  A{ApApAA֣A33AAיAA
AffAAAA  AHAzAٮApApAQA
AָRA=qA{AхAAأA{A
=AׅAAAԏ\A
AأAA؏\AHA
=AAA33AGAffAϮA(AAAϙA=qA  A=qA{AϮAυAͅA(AGAAQA33AzA
=AA
A  A(AA33A\)A33AHAHA=qAQApAA
=AA\)A\)A\)AGA{AA\)AffApA\)AA(A\A{AA(A(A=qApAƏ\AzAƸRA{AA33A33ApA33A  ApAA
AAA
=AHA(A(AffAA=qA
=AffAAGAGAA\AffA
=A  AHAA
A  AQAA\ApAA  A  AAzA\AAffA\ARApA33AAAffAQA
=A\A\)A\)AzAA\AAGAAAzAzA=qAHAHA{ApAzAHAzApA=qAzA\AAA{A£A=qA=qA=qAA
=A\)A  AffA
=AffA
=A
=AA=qA\)ApAGAəAAAGA(AAȏ\AffAƸRA  AA\)AAGA33A=qAʏ\A  AȣAffApAHAϙA̸RA˙AHA33AGA˙AffA˅AHAApAȸRAffA
=A(Aʏ\AHAAA(AA33AA\)A\)AzAA33A  AzAəAQApAAřAAîAAAƣAGA  AffAǅAAAffAHAzAAGA\)A
ApAԏ\AԸRAծAGAHAzAffApAAAQAApAGAApA33A{AəAA(A=qAУA
=A  AHA33AzA{A33A  A
A  AHAϮAzAΣA͙AAA  A˅AffA  AGAѮA=qAA=qAQA33AAQA
ApA\)AAQA{AQA33A
=AffAAӮApAυAzA{A=qA  AHA֏\ApA
AA(A؏\AAzAzAffAQAAA֏\AQA33AffA
A  A
=A
AGA֏\AA׮AA֏\AA  A33AHA  AffAAA
AzA֏\AffAApAхApA  A
=AָRAA  A  A(AԣAzA
AAA(A{AQAffA֏\AA=qA=qA=qA
AҸRApApA
=Aҏ\AAхAQA{A  A{A\)AϮAΣApA=qAAGAGA{AЏ\AиRAA  AA
ApAͮAzA=qAzAΏ\AA{A
AA
=AυA  AA=qApAGA\)AυApAϮA{AAffAˮA  AͅA33A
=A33A  AAAApA33A{AHA
=AAθRA33A(Ȁ\A
=AGAͅA33AHAAzAAA  AAGAʏ\A\)AAAϮA̸RAGAQA\)A(A=qA͙Ȁ\A  AGAəAAǅAAzA  Aȏ\AAHA{AǙApA33A=qAAzAQA  AˮAˮAAAHAA\)AAAA{AQAυA(AAA(A=qAΏ\AԣApAA33AԸRA
=AΣAҏ\AУAӅAθRAAθRA{AمAڣAAAA
AA{AӅAA=qA33AأA
A33A
=ApApAծA
=AQApAzA
=ApApA{AGAծA
AHA  Aҏ\AHAAzAAQA\)AA
=AΣAͮA\)A(AAɅAHAHApA=qAڣA=qAAAA  A(AљAA33A=qA׮AָRAՙAיAԸRA=qAGAzA{AGA
A{A\)AQAՙA׮AأApAٮA
AQA=qAzAA(AA{A{AApAAHAAɅA\)AHAՙAӅAGA\)A֏\AڣA\)AffApAѮA  AA\)A
A؏\AA
A=qAQAAAAԏ\AӮAAAAA=qAAGA
=AυAϮAϙA
=AHAA(ApA=qAՅAңAиRAAљApAAAzA
=AхAA(A33Aԏ\A(A(AхAΣAAυAAGAA  A
=AԣA
AHAApA=qAأAzAظRAѮAAԸRA؏\A33AAHAԏ\AԸRAzAA  AAA33AAA  AGAAA
=AAQAӅA  A33AHAQA
AQAffAQAיAԣAzA\)AЏ\A(AAffA
=AA(A
=AzAԏ\A
=AA\)A  A\)AA=qAծApAׅA܏\AQA
=AGA{A
=AffAAԏ\A
A(A{A(AApApA\)AAۅAA׮ApAAffAAָRA(AA
=A{AQA  A{AHApAffAA=qAQAzAGA  A  A33AffAхAԏ\AՅAQAGA
AffA=qAffAمA\)A(AָRAAzAѮAQA33AGAׅAיAAGA
AA(Aԏ\A33AzAGApAGAԸRA
=AffA  A{AffAAӮA(AAAиRA=qA
A  A{AиRAڣA=qA\)A33A\)AA؏\AGA֏\AיAQA\)AأA׮A؏\AGAۮApA{AAۮAGAA
=A(AׅA  A{ApAAA(AffAٙAA{Aڏ\AڸRAffAA=qAڸRAQAQAGAڏ\A{AGA=qAׅAAA33A  AAffA׮A(AA  AGAۮAQAمApAQAAA{AA33AA
=AAٙAffA
AՅAԸRAԏ\A֏\A  A\)A
ApAٮA\)AGA֏\A33ApAծAAAՅA33AָRAمA
ApA
ApA=qA\)AׅAٮAAAAA
AQAۮAA
=A؏\A
=A33AA  AAمAQAAQA܏\A܏\AܣA
=A\)A\)A݅A\)AzApAڸRAمAzAAA\)AffAڣA\)A{AffA  AA33A
AHA
AAQA߅AޣA݅AܣAڸRA
=AAA=qAQARA
AffAffAܣAAzAffA
AAأA{A=qAffAAمAHA{A\)A\)AA  A{AA=qAٮAA33A
=AA\)A(ApAffAGA=qAffApA\)AAA؏\A(AA
AffA  AffAܣAffAA
=AA  AA33AA(AzA\AzA\AffAA\AޣAA=qAۮAۮApAڏ\AAQA  A
AQAۅAڣAQA
A{AzA(AA  A  AffA=qAzAHA\)AQAA{A
=AA{AA
=A{AffAzAA33AQA  AQAӅAA=qAA\)AܣAA  AHAA  A=qAAApAڏ\AAܸRA33AA{ApApAAAzA܏\A܏\AzAHAGAޣAAA߮A  AAHA(ApAᙚAAAAA{AA  AAHAffA(A  A{AA߮A(AA=qA݅AA=qA
=AGAޣAApAޣA
AGA޸RAffAAA(A=qAzARAGAA{AffARA{A\A
AffA=qAzAAޣAAzA(A  ApA
A
=AAڏ\ApA  A  AA(AᙚA{AAAAQA  AzAARAA  A\)A߮A܏\AA(A\AA
AAGAA߮AGAߙA߮AAޣA
=AARA=qAzAAffAA
A33AߙAA߮AffAAޣAQA߅AAݮA
A\)ApAۅAAAיAffAٮAHAzA
=AHAٙA\)A33A֏\A׮A֏\A
AAQAGAA
=AAָRAQApApAAffAՅA
ApA׮AzAۮA(AffAA\)ApA33ApA
=Aڏ\AGAظRA\)AAۙAمA33A֣AҸRAA33AA(AHApAA=qAzAffAGAHA  A{A{AffA׮AGAՙA׮AAzA֏\AQAA{AApA\)ApAGA  Ȁ\AͅA
=A33AθRAљAA
AzAHA=qAA(AӮA{A
=AAffAGApA
=A33ApAzA\)A  A\)AǙAffA  A{AAAA  AGA  AAǙAAAGAA33A{ApAĸRA£A
=AA˙A{AHA\)A˅A˅A˙A\)AA
AŮApAAAŅAAAA
=AQAQA=qA(AAA=qAA͙AA{AzAAA͙AЏ\A\)AAzA  ApAƏ\ApA\)AǅA\)AƣA{AA\)AɮA
=ApAzA  ApApAA͙A=qAA  A{AAʣAffȀ\AzAͅA\)AffAzA(AA{AAәAҸRA33AQApAљAHA
AA  AGA\)AָRA(AָRAיAffA؏\A
=AAQA33A33AGA
=AzAzAHAQAָRAHAAA=qAA(ApAA  A
AffAzAGA(A  AAԣAzAԸRAHAӮA=qAԏ\AA  A
=A(A{AGA33A׮AAՙA{AA
=A{A
A  AAAGAљA\)ẠA  AҸRAAȣAA=qAAHAffA=qAȀ\AΏ\AУA33Aҏ\A
AQAGAәAffAA  AGA֣A
AծA֏\AA(A=qAAHAzApAGA=qAA(A{AA\)A33A=qAA  ApAAУA\)AAAA
=AHA
=A(A
=AAυA
=A
AGAхAGAAAAGAGAљAzAffAҸRAQA{AA(A\)A  A(A(AA{Aҏ\AңA
=A
AffAApAHAхA=qA(A
A(AHAҸRA=qAffAҏ\AѮA
AHAϙA
=AϙAυAA{AffA\)AGA  AGA(A
AA=qAAAGAAǅA(AffAQAA{AУAͮAA(AAA{Aʏ\AffAQA33AAϮAУAHAϙA
=AAffAϮA\)AA=qApA
AffAAHA
=ApAHAAzA33AA\)AHA{A=qA\)ApAظRA\)AQAׅA\)A=qA(AA  AffAzA
=AHAҏ\A  A\)AхAAffAхA{AҸRA(AיAzA{A33AңAQAApAϮAAϙA33AΣApAϙAυAGApAA(AA{AϙAϮAAAA(AHAΏ\A͙AˮA=qApAffAϙAAθRAϮAzA
=AzAУAzAHAA{AәAGAzAQAzAԸRAApAՅAffAAAAمAڸRA\)AݮA݅A݅A݅AݙAA
AffAיA
=AzA33AڸRAܸRA  AffAzA܏\A{A33A33AAQApA  A
=AٙA؏\A
=A
AGA{AׅAӮAHAծA=qAָRA֣A
AՙApA\)AAՙA(AAA=qAffAGA
AzA֏\A=qA
AQA=qAңAAAӅAAA
AӅAӅA  AzApA33AffAA\)A(AѮAffAApA=qAzA͙AAzA˙AffA33A
=AɅA33AHA\)AAAffAA
A  A͙A
=AA{Ȁ\AͮA33AAA(A
A{AHAHAͮA
ApAGAAͮAAApAˮAA=qAʣAHA{AǅAA{AȸRA=qAAAffAƣAffA{AAA33AƏ\A
=AHAHA(AHAȣAȸRA  AGA˅A
=AzAHA
=A͙AϮAȀ\A\)A\)AɅA\)A\)AʸRAʣAəAGAAA
A\)A(A͙AHApApAffA  A  A{AQAHAQAΣAA
AAAAͅAQAӅA{AAA{AzA33AՙA֏\AQAHAϙA  AA(AӮAAAυAA  AAHA33A=qAAGAͅA͙A  A̸RA  A̸RA(AA\)A33AffAQAхA˙A
=A˙AAиRA\)AͮAAzAQAУAиRAЏ\AϙAA
AЏ\AϙAGA
=A(AGA\)AA  AGA=qAυAzAѮAQAzAApAӅA(AHAAՅA{AffAיAׅAGApAׅAיA(A֣AA֣AA\)AAQA33ApAA33AzAAA֣A33AAAͅA
A{AAԏ\AمAAڣAۮA
=AApAУAA
=AQAУAӅAQAAGApAAA
=AAҏ\AҸRAәA\)AΣApAљAͮAHA=qApA33AљAAУAAGA{AA\)AGA{AѮAHAzA=qA=qAԏ\AAA{A
AHApAӮAA33A{Aԏ\Aԏ\Aԏ\ApA֏\A(AHA33ApA=qAָRAAffA֣A
AGAΣA(A=qAAzA
=AָRAӮA33AָRAAӅA  AQAA{AAHAffA33AAθRAѮA(ẠAA(A33ApA
AGAGA{AGAA{A=qAУA
ẠAHA\)A33A33AʣAʏ\ẠAQA
=AՙAAՅAHAԏ\A
AAЏ\AzAиRApAӮAҏ\A33A(AHAffA=qAzAA
=AzA{AٙAAzAffA=qA\)AffAAA\)A
ApA  A33AzAҸRAAAԸRA=qA
AHAAԣAffAθRAA
AzAԏ\AӅA  AңAңAхAиRAAAHAθRAΏ\AϮA(AA͙A33AυAͮAffA\)AAУAхAApA=qAAЏ\AQAϙAϙA  AffAͮA͙AffA33A{A33AAGAҸRA׮AԣAיA֣AAAGAffAGA{AхA\)AA33AA{AϮA  AzAffAA  A{AQA33AAѮA{A(AҸRA
=A\)A\)A\)AA33AAAffA=qA\)AәAAљAAAԸRA=qAzA\)A(AffAԏ\AθRAffA33AQAңApAAAAffAApAA\)A
A\)A\)A  A33AхA(AA
AffAͅAAHAAӅAA\)A  A{A33AхAA\)AӮAGA(A˙A
A
=AA\)A\)A\)AAAљA
AffAиRAzA(AApA֣A֣AAGA(ApAA
AQAA؏\AffAAA\)AGAAHAGAڏ\AQA=qAمA
A(AأAمAיA׮AzA֣AQAՙAQAGApA(A{A(AzA(AA  A\)A=qAAzAՙAծAAzAЏ\AHApA
A=qAأAAzAQA\)Aҏ\A
=A
=A33ApAAAQApAҸRAGA  AAڣA(AәAAҸRAffA֏\A\)A
=A֏\AՙAAָRAHAAׅAA{AGAAQAڸRAQAڏ\Aڏ\AڸRAzA
AGAAzA33AHA=qAAAمAأA\)AGAAAzA֏\A
=A
=A(AיAA\)AGA
=A(A  AA33AzAGAԣA33AAffA  AffAA=qAQAӅAGAҸRAQA(A
AѮApApA(AAAϮA׮AQAGAAΣAHAѮAGApA(A=qAHAffAԣAQA{AGAԣAQA{AGAA(AAҸRAӅA=qAAGAffA=qA(AffAԣAHAAA{ApAAAGAAЏ\AAAHAAA˙A{A
AQA͙ApA
AУAϮAA
=AGAυA  A(AΣAQA\)AAA=qAɅAȣA33AƏ\A33Aď\A{A{AîA{A
AffApAA\)ApAHAîAHAA{A
=A
=AîA£A{A{AHAAAAA{ApAAQApA\AzAffAAAAƣA=qA33AÙAAAA  AA{A{A(AffA33AAGAA\)AA
=AîAAGA(A  AAAÅAGA=qAARApAGAARAAA(AffAffAAAA
AffAHAAzAAA\AAA(AAA
ARAzAHAA33AA(A{A\AffA\)AQAQApAAGAAHApAA  A33ApAA=qAAHAzAAAAQAAffAzAffA  A  AAA(A\A33A£AGAŅAA
A  A\)A
=AffAzAĸRAA\)Aď\A
A\)A\)A£AAA
AA{A
AzAAAAĸRAHAHAʣAA
=AƸRApAzAApA=qAA
=AHA\)AA¸RAGAAGA
AzAQA\A
=A=qAA{A33A
A(AA33AAA33A(AA\)A\A33A
=AAffAA{AQApAApAAffApARARAAA
=AA  A(AŅAzAˮA
A  A=qAA\)AƏ\AřAĸRAAHA
A33AÙA
=AA(AA33A
AHAAA{AAGAApA£AřA33ApA\)AA  AffAGA¸RA33A=qAAAÅA¸RAzA{AA
=A
A{AffA
AAffAA(A\A33AA33A{AGAA(ARA{A\ARAGA33A33AAAQA  A  A(AffAffAAA
AAAHApAA33A=qA  A=qAffARA(AA\AGA(A
=AGA
AffA£A  A33A33A
A33AHAAzAQAHA\)A  AQAAAzAA\)AAAGAAA{A\)A
=AAffAffA
=AAzA(AA
A
AGAA\)A
=A\AzAffARA=qA\AA\A
=A¸RAQA
=A\)ApA{AA  AAAA
=A
AA
=AAGAGA
=A
AGA33AGA(A  AQAffAzAA(ApAQAzA¸RA{AŮA\)AAApAGA=qAřAɮAȣAAAAɮAȏ\A
AǅAAǮAffAGA
=AffA\)A=qAzAzAApAQA  A(AAffAAA(A{AzAÙAGA  AQAAŮA
AAQAAAHAAffAď\A=qAƏ\AHAffA
A\)A{AzAȸRA=qA{A\Aď\ApA=qAA33A(AGAŮA\AGAîA(A\)AîA(A\A33AÙA  AQA(AffAzA\)AÙA(AA=qAA\)AGAzAA33A  AA(AÙAAA  A\)AHA=qA=qA\AzA(A\)AHA\AAAGAHAA(AQAAǮAGAʣA33AGA{AAǮA=qAAGAƸRAƣA  AŮAŅA  AƏ\AA
AA  A£A  AAAA  AAģAAzAQA{AAŅAƣAĸRA\)AǅA˙Aȏ\AřA{A
AȸRA\)AQA(AHApA\)AAͮAHA
AϙA
AљA{AAӮA\)AzAңA{AУAffAϙA
=A̸RAθRAAΏ\AˮAffA˅AApAAƣA(AHAʸRApA˅AHAA33AzAAAƸRA\)AA(A\)A  AA33A{Aȏ\AzAA{ApA
=A{A  ApAǅA33Aȏ\ApAGA(AȣA33A
AȸRA33AApAɅA33Aȏ\AzA
=AzAAȣAffA\)A33AHAΣA
AA=qAЏ\A
AffA{AңAңA
A=qAAљAQA
Aʏ\AA\)AAAHAHAAA\)A33AzA
=Aҏ\AGA{AA
=AΣAffA(ApAʣAA{AffA=qAA
AɅA{AǮAɮApAǙAȣA\)ApA˙AzAA(A
=AQAƸRAAHA  A33AHA=qAQA(AʸRA
=A\)AffA\)A33A{AHAȣA
Ȁ\A\)AQAAzAffAzAA̸RAHA{AA=qA
=AAA(AHA{AAҸRAAծA\)AAGAQA\)AљAQApAGApAAҏ\AQAӅAAAffAԏ\AӮA
AҸRAHA\)AA33AApA(AGApAAAHA33AA
AA  AffAΣAҸRAʏ\A  A
=AA  AAQA(AAHAΣA(A33A˅AͅAͮAApA
=AGA33A
=A=qA\)AɮAȣAȣAAȸRAffAAɮAA{A(AʸRAA33AAzAAHAθRAϮAA33AA(A  A=qApApAAQA=qAffAzA
=A
=ApAϙAA
AzAљAQA{AυAA  A
A\)AʣAQA
=AffA͙AQAɮAA
=A
=A33AA=qAʸRA{AA
=A
=AzApAȀ\ẠẠAzAAȸRAˮA=qA  AͅAA33AffA
=A͙A{AzApA˙AQA\)A33AѮAAљAA=qA33A(AffAA33A\)AHA  AAхAzA=qA33AHA{AQAΏ\AAAAHApAθRA
=A
=AAffAA\)A  AAQAHA  AAHAAЏ\A33AәA(A{AQA˙AQAGA
=AθRA  A  A33A
=A=qAʸRA\)AA˅A33Aȏ\AffA\)AQA  AGAffAffA=qAəA{A
=AȸRA33AHAȸRAAA33AzA=qAzAȸRA{AA=qAQA{AHAffAHAǙAAϮAA
=AAzA
=AGA
=A{A  A(AиRA
=AѮA(A
=A  AAA\)A
=AԸRAzA
=A  A(A\)AυAGA=qAA{AAиRAzAͮAAЏ\A{A{AGAAHAAzAϙA̸RAGAGAA  A  ẠA33A
A{A\)AAΏ\A  A=qA\)A͙Ȁ\A\)AffAAAAGAApApA\)A
=AGAHA
=AA(AffA
A\)AAHA=qAхA  AQA=qA\)AzAGAθRAHAAA=qȀ\ẠA=qA33AAυA
=AzAAAхAAQAffAA  A  A֏\A
=AAAffAԸRAA(AffAәAָRAffA͙AAԸRA\)AQA
=AQAffA  AљAzAAA  AQAϮAԣAծAHAAzAHAՅAQA
AGA(A(AffA33AϙA{A
=AAA(A\)AQA\)AGA(A{AzAA=qAA͙AGA\)AиRA˅A33AȣAA\)A{AAQA{AffA\)A  AAAˮAAҏ\AQAQAAѮA(A
AAAӮA=qAAGA(AzAGAԸRAԣA{AәAA(AAzApAffAθRA=qAҸRA\)AHAA{AAиRAAzAͅAҏ\A  A{A  A
AAzA  ApAHAAQA\)A33AAǅA33A
AA  AHAHA\)ApAŮA
=AzAA  AffAffA
=AυAңAAAˮA͙ẠA\)A(Aʏ\AA33ApA͙AzA=qA  A
AʣA\)AʣA(Aʏ\ApAA\)A˙A\)A˙A{AzA\)AAAAAzA
=AA(AљAHAхA
ApA=qAͅẠAA˅AˮAffA  A  AȸRAA(AA{AAAAffAA(A\)A͙AGAAHAAΏ\AΣAϮA{A˅AffAΏ\A͙AΣA
=AAAϮAffAQAˮA
A
=ApA{A(A(AŅA
=AǮAzAƸRAGA{AɮAʣAʏ\A{Aʏ\A˙AAA
=AA
AzAAȏ\AAʸRAA
A(A
AřA
AŅAA{A  AzAAA(AAʏ\A
=AAA(A=qA
=AffAϙApA=qAͮAAͮA(A(ApAΏ\AHAϙAΏ\AAAA
=A(A{AҸRA(AхAHA  AAApAGAΏ\AQAHA{AA  AHA\)A33A33A\)ẠAAGA\)AυȀ\A  A(A=qA(AΏ\A=qȀ\A͙AHA\)A
AzAAAď\ApAA=qAA=qAzAGAApAzA
=A(AGAGAA(AĸRA=qAzAAA\)A
=ApA{AHA33AHAA=qA¸RAA33A\AÙAƏ\A
=AAA=qAQA
=A¸RAAAΏ\ẠAQAAQA  AAϮApA̸RAAʸRAəA
=AAGAzAƣA33AHAzAǅA  AǅA{AffA\)A=qAǙAAA=qAAƣAǙAffAHAA{A
AzApAA  ApA{AzA{AǅA
AQA{A\)A
=AɮA
A=qAQA(AAAGAAHApAAʏ\AA\)A
AƣA
AzAîAAAApAAA(ApA  A
=AAGAHAHARAzA
A
=AffAAA\AzAGA\A\)AQA=qA
=AGA33AAA{AzARA33A\AAffAA33AAzAA{AA33A\AQA
AAzA
ApAAzAAAARA33AGAAQAAHAAAA{AǙAǙAȣA=qAzA33AЏ\AϙA̸RA33AA=qA33AGA\)AA=qAυA\)A{A=qApAʣAʏ\A£AHA£AAA{AApAÙA
A33AffAĸRAƸRA
=A
=AAřA=qAA=qA{AGAApA  AǮA
=AAAAHAAffAAƸRA
A=qAAApA33Aď\A
AƏ\AAŅAŅAAAAŅAAƏ\A
AApAŮA\)ApAA{AHAAA
=A\)AAAAAA
A
A  AȸRA=qA
AAApA
=AHA33AǙAQA=qA33A{A\)AŮAzAƏ\ApA(AQA=qAǮA
=A{A  AA  A=qA(AϙAˮA
A
AffA{AA
AəAɮAffAAAģAzAAƣAɮA(A  AA=qAAffAAARAAzAzA
=AA\)AAHARA
=AA=qAAAA
A(A  AAQAQApAAA
=AîAA\)A
A(AŅA
=ApAǮA(A33AA33AzAA
AzA=qAAApAŮAAA{A
AȣAřAAQAApAAzAA  A
=AzAAffAÅAA
=AGAĸRAA
Aď\A
=AGA33AĸRAģAď\AQA33AAQA(A
AQA
=AƏ\AGA
AŅAA
AAA  A
A{AGAHAŅA=qApA(A(AAƣA=qA  AAřAffA=qA\)AƣAǙApAA\)A
AffA  A
AQA{AApAA=qA
=AGA{Aȏ\Aʏ\AʸRAGAffA
AθRAθRA\)AУAzAffAzAAȏ\AA=qAˮA
AA  AGAAθRAAхAAAHA=qAA˙A=qAθRẠAAAʣAQAzAȸRAʸRA{AA=qAA
ApA=qAzAQA˙A
AAɅAȸRAAQA=qAAAȏ\AɅAƏ\AƸRAƣAffAA
=A{A˙A(AAʣA{AA
=AȣApAAGAHȀ\A\)ẠA\)AzAzA=qA͙A(A{AQAzA=qA=qAGAAQAzAQAAAGAffA=qA33AʣA\)AиRAAGA̸RAɅAA33A  AͅA33A  A{AA(AzȀ\AApAŮAĸRAƸRAAffAGA  AƣA\A33AAGAƸRA(AŮAQAHAQApAAȀ\A33AɮAA{Aʏ\AA˅A(A=qApAzA  AͮA
AңA  AGAәA
=ApAӮAA=qAQAA
AA  AffA  AQAAхAAA\)AA33Aʏ\AǅAɮAAHAQȀ\AHAAAϙAAffAffAAAθRAʸRAzAͮAAθRAzAΏ\AʸRAͅAͅAAẠAʸRA
=ApA{AAͅA=qAffAϙAʸRA˅AυAQAAHA{ApAAGAzAzAGAA{A˅AHAɮA=qAA˙AͅApA  AzAHA  A
AffA33A͙A=qAHAffAffAffAA\)AͮAA
A\)AzAA=qAϮA33AAffAθRAϙA33A
AиRAЏ\AУA  A33A  A͙AGA=qAA\)A{A{AAA33AGAApAA(AHAA{AA
=AA̸RAA\)Ȁ\AHAHAA33AQA
AGAƸRAAGA(AAAȣAA
AǮAAAǙAȸRAAиRAGA
=AHAɅAA=qAzA
A{A33A\)A˙A˅ApA  AzAA˅A  A=qA(Aʏ\A=qA
=ẠAʸRAAGA33AA(AQA  AA=qA\)A33A{AƸRAŮA
=AffA£A
=A{A
AGA
AAAƏ\Aʏ\A
AAAˮAA˅AQAAffAA
=AGAffA{AzAAHA
=AəAGAŮAA(AAA(Aȏ\AÙA(A33AA\AARAAĸRAAQAAƸRA\)AǅAȏ\AHA
A33AffA\A
=AAffA{AffAAAffAHA
=AApAA\)A\)A(A  AQA  AĸRA=qA{AQAA\)AAQAA  AQARAA(AA=qAGA=qAA  Aď\A\)AAAƏ\AGA
AffAHAGAQAHA(AƣA  AřAQA=qA\)A£A£A{AAAzA  AAHAA{AzAHA
A  A=qAApAA(AQAAîAA£AA£A\)AAAffAAAAGA=qA(AQA
=A33AAA
ApAzAA
=AA
A(A{AAAA{AGA
A{AA\A  AAA\A33A\)A
AA{A
A{AA
AAAARA
A
AffAA\ApAGA
AAQAAAAA\AA(A
=A{AAAA
=AA\A  AAA=qAAGAQARAAGAHA{AffAAzA  AAGA  AzAA(ARA  A
AA{AA\A{AA{AAffARAA{AA
=A=qAffA  A=qAA
AffAApAHA(AAAQApA  A  AffA=qAA(AHAA\ApAffA=qARAAA33A\AGAQA(A  AAHA33AAAAffAzARA
=AAAAAA  A
AA  AAAA
=AARAffARAHAQApApAAzA\)AHAAQA
A(A33AAAAA  A\)AffAA{AQAAAAGAA(AA(AGAA\ApA\AA
=A=qA  AApAAzAARA=qA{A{AA
=A\)AƣAQAǙAď\A{AA  AHA
=AɮAQAʏ\AGAAʸRAɮA(AʸRAͅAGAQAˮAQAAȣAGAȣA(AHAȏ\AA  AHA  A\)A
AʸRApA
=AzAAʏ\AzAffAȣA  AŮAAAzAzA  A=qAɮAǙAAQAffApAAAHAȸRAAAAAʸRAʸRA\)A(AQAȏ\AəA
=A=qAApAAA  A\)A33AA(AA  AHA(AzAGA(A(A=qA(A33Aď\AA(A{A
A(A\)AA
A33Aȏ\AAAzAAʣAAAͅA\)A\)A=qAA=qA=qA(AAAˮAAAGA=qAHApApAQAHAGAHA{AA(AffAA
A
=ApA
=A  AA  AAA\)AAƏ\A33A\)A(AƏ\A{A\)AŮA{ApA
=AAA\)AAAĸRAřA
=Aď\A=qAA=qAzAGA
=AA
AA{AA=qAǙAAƸRAȏ\AzA(ApAQA=qAAǙA=qAəAA
=AɮAzAA33AˮAAQA{AA˙AAͮȀ\A̸RA͙AͅAA̸RAɮA
=AɮA  A\)A=qAAGAGAffAA  AˮA33AApA{AA\)AǙA=qAGAAǙAǙA\)A\)A\)AƣAffA=qA
AŅA\)AHAffAffA=qAřA\)A\)AřAřA\)AGAƣA(A=qAGAHAHAď\AzAģAģAQAřAHAřA
A(A(A(AffA\)AƏ\AǙAǙAǙAQA(A\)A\)AQAģA
=A{A
=AGApAƣA\)AǮAȣA
=AəA
=AʣAȣAAAȏ\AŅAHA  AřAřAA{ApA(A\)AAQA=qAHAApAAffA(AGAɮApẠA(A˅AɮAƏ\AƸRAzAƸRAQAƣA(A{AA  A{A=qAzAȏ\AřAHAAQAÅApAAHA£A{AzAGA\A=qA\)AQAA  AîA\)AģAQA=qA
AA\AGA33AQA
=AŅA
AQAzApA(AffAzAȏ\AzAAA
=AAȏ\AAAȸRAzAHAAA{AzApA
A
AǙA=qA=qA=qAȏ\A33AǙAǅA=qAA{A{AffAA  AzAǮAAƏ\AAǙAA{AGAȏ\A{A=qAffA\)AA(AHAGAŮA(A
A
=AA(AA=qA{ApAGAAȣAȸRAGA33AAȏ\AAAȸRAHA\)A33A  AəAAAffAffAʏ\AQAffAffA=qA
AzAffAGAA(A33AffA33AzAAAHA(A33A\)A{A{A{A  A  AɮAəAʸRA
=A{AGA
=AzAHApAGAzA33AHAAffAȣA33AɮApAffAʏ\AHAʸRAAA{A33A33Aʏ\A33A{AəA=qAȣAzAǅAQAA\)A=qA(A
=AGA
A
A\)ApApAĸRAƸRAQA=qA=qAřA(AffAƏ\AzAzAƸRAƏ\AǮAffAHAAˮAHA  AȣA(AzAǮApAυAQA
AAQA
ApAAGAA=qA=qA͙AͅAGA=qA̸RA\)A
AffȀ\Ȁ\Ȁ\AffAQȀ\A
AAAHA=qAA
=AzAAΏ\ApAA\)AA=qA(A(AGAAȏ\AȸRAAAzAAǙAǅAQA33AA\)AAHA(AƣAGAffAzAGAȣAAGAA{AGAA\)AHAffAƸRAǙA33AǅAAffAȣAɅAffAAȸRAAAˮA˙A˅Ȁ\ẠAͮA=qAA\)A  A=qA{AУA=qAA{A
A33A
=AA
=AϙAffAͮAAffAzAA(AAffAθRAΣAAΏ\AzApA=qAGA  AGA
AAAGA  AGA33A33A33AHA33AͮAA\)A=qA(A(AɮA  AʣA
=AAɮAȏ\AzAʣAAʸRAʸRAA{AHA
=ApA{AffAA
AɅA  A33A
=A
=A(A33A(A(A
AAȸRAAǮAGA
AQA
AˮAAˮAˮA˙AAˮA33A
AȀ\AzApAA
A\)A˅A˙AAʣAA˅AˮAˮAA
AʸRAʣApAAȣA(AȣAȏ\A(A\)AAzApAǮA(AA
=A=qA{AAɅA
AAA=qAQAǙA(AffAGAzAA(A
=AAƏ\AffApAA
A33AřA  A(AA
=ApAA(AAGAApA{A33AQA33AȀ\AA\)AA{AQAΣAAA
=AQȀ\AẠAͅA{AQA
AApA(A=qA͙AzAzAΏ\AffAffAzAθRAHAΏ\AΏ\AffAffA\)A(AAGA
=A˅AzAGAGAA33AͮAffAffA{A=qAʣAQAQAÅAģAȣA\)AHAffA=qAQAA=qApAď\A=qA(A  AzAzAAA33AHAzApAȏ\AzA
=AģAÅA=qA33AAzA
A{AAAȸRAȏ\AA
A(AGAGA
A{AHAHAͮA̸RA  AA(A{AGAͅAͮA(AͅAA  AffAAA(A{AУA(AϙAȀ\AˮAHAəAƏ\A  AǮApA(A=qAĸRAApAAȸRAGAHAAAAʸRAʣA˙AɅA{AAřAřAAApA=qA=qA33AffAƣA(AAA  AŮA33A33AA(A
=A(AzAffAǙAGA
AAQAGAzA\)A
A
=A{AA\)A{A\)AApA
AřAQA\A(A(A(A£AAAA\)AzA¸RAA\)AĸRA\)A=qAǮA=qAzAA{AzAĸRA\)Aď\A\)AAHA
A  AAÙA
=AffAzA  AHA{A
A
A
AQAA=qAA=qAffA(AA¸RA
=AAA{AHAzAGAA\)A  AffAAffAAQAGAAA{A  A
=AGAA  A(A
AQA\A\)AÙA{A=qAzAAA¸RA£AzA(A\)A\A=qAAAAAAĸRAHAA
=AffAŮAA
ApAŅAAA
=A  AAQAQAAAƸRAAA33A
=AA(AîAffA33A¸RA  A(ApA
A\)AģA{A{AAAǙA=qAǮAA{AĸRAÙAApA
AAÅA(A{ApA
=ApAəA
=AffAAAzAzAApAĸRAď\AAď\A  AAzA
=AApA=qA\)AÙAffA{A\)AÅA\)A  AA  AAA=qAA{AQA33AƣAAƏ\AA33AAŅAĸRAĸRAAAƏ\AApAAA(A{A£ApA  ApAffA=qAď\AQA{A(AAA
=AĸRA
=A=qAQAģA\)AƣA=qAQApAŅAAƸRAHAĸRAAģAAĸRAď\AģAHAzAApA(AA  A=qAƣA33AHAǙApAApAAƣAǮAǙAGA  AzAAAA(AQAzAAApA
AAA˙AAAHAʣAʏ\AAQA=qAQA\)AHAGAəAAəAAəAAGA33A33ApAHApAŮAGA(A
A33AǮA{AQAffAŮAAAƸRAĸRAQAîAAÙA  AAřAAÅA=qAQA\AffA
ApAA{AAAQA\)AzAGA\AÅAAGA
=A  AÅAAzAzA
=AƏ\A(AĸRA(A\A=qA{AAAHAîAAÅAA{A  A(AzAď\Aď\Aď\Aď\AffAĸRAA33AA
=AAA{A=qA33AGAAA{A
=AzA
A(AǙAȏ\AHA
=AffAģAģAffAď\AĸRA=qAŮAGAŅAGAA\)AƣApA\)AHA
ApAffA(AzA(A=qA\)AîAď\A=qAQA  A=qA
=AA
=AƏ\AŅAģAffAHApAGAffA{AAHAffA
A  A(AHAGA(A\)AAA
AzAʏ\A=qAɮAɮAffAAA33AˮAʣA\)AzAʸRAA
=A33AɮApA˅A\)A
AffA\)ẠA  Ȁ\AffAA\)ApA͙A̸RAQAȏ\A˙A\)AA
AffAGȀ\ApAAȏ\A=qAHAA
=AzAA  AɮAʸRA33AʣAɅAəA  A(Aȏ\AGAȣA=qAAGA\)A
=AA=qAGAŅAřAA
AAď\AAď\AĸRAAQAŅAzA
=Aď\AĸRA{A=qAď\AĸRAQAAQAŮA{AŮAzAřAApA\)AAAŮAHA¸RA{AQAAA(AƸRA¸RAřAŅA=qA(ApAffA  AA£AAď\AffAHA\)AA\AQA{A  A=qAAQAQA\)AǅAģAÙA{A
=A\)AHAAHA  AîAƸRA33AǅAAAÅA  AAĸRAQAď\ApAffA33AAApAÙA  AŅAģA  A  AǮAAÅA\)AAģAď\A  A  AƏ\A(ApApAA
=AģA
=AAģA(AA
AřAAA=qAîAAAAAA\)AAAQAzA
AffA\)A33AAAGAAHAAQA
=AffAQA=qAQAAAAHAQAAA=qA
AA(A  AffAHAAzA{AA{AHAHA(AAA\A33ARA(A\)AzA\)AA\A33AA=qAHAzAAApA(A33AAA  AzA33A  ApA(AAA  A  ApA{A
AAA{A\)AARAA  A{AffA
A{AAA
=AffAAARA(A
=A\AffA=qA\AHAA  A\AA=qA33AzA£AzAAĸRAffA=qA  A(A33AAQAApA(ApA(A{A=qAAAÙAģAģA\)A{AA(AAGAQAzAzA=qAAQA\AffA(AHAGAAzA33A  A
AHAAAAA  AGA
AA  AAA\)AQAA  A£A
AAAHAAAA
=AHAffAHAGAARA{AA=qA\)AAAîA¸RAA  AAA33AĸRA\A\)A\AGAřAAAffAQAƸRAƸRA{A=qA33AQAAAȸRAȸRAQAǙA(A33A33AA{AApA(ApA\AƏ\A{A
=A{A  A(ApA{AA
=AffAA
AffAHAGA\)AApA33A=qAAAAA33AAAAHAGApAA
AA
AA\)ApA\)AAA{AGA  A\)A
=A\)AzA=qAAAQApAHAAHAAAAAAzAAģA=qA(AARAHAA\AAzApA
=AAAA
A{AAAA\ApAAffA(AAAGApAQAAA\)AffAzAAA¸RAAA(AAApAA=qAÅA
=A£A(AAzA
ARAA{A\A
=A{AGAA
=AAffAzAAQA=qAAAAAA\ARA
=A
=A=qA\)ApA  A
=AAzAQAA(AQAAA\)ApA
=A£A33AÅAAÙAzAffAQAQA
A
=AA
=A=qAA=qAApAARAGA  AA\)A\AģAģA33AAHA(AHAAAHA=qAA{AAHA¸RAAApA
=AGAQAAA=qAA\)A  A\)AHAHAffAzAAffA33AA\)AApAQAA=qAAHAARARA=qAAGAA{A{AAAHA(AAHA
=AzA
=A¸RA¸RApAzA\)AGA
AzA  AzA33A{AHAQA  ApAA
=AGAAffA\)AffAAApA  AffA33A{A
=A=qA
=A33A33AA
A
=AHAAAHA  A=qAzAzAA\A{A  A
A£AHA
=AzAAAAAzApAGA=qAAHAQAA  AAA(AAAHA{A\)AÙAÙAAQA{A{A
A=qAHARAzAAzA
=AHAHARAffA(AA33AA(AffA
ApAARAffAAAzA(A
AAAHAA=qAQA{AzAA(AA\AAQA(AHA  AzAA  AA
=ApAHA{A  A(AAARARAA\)A
=A(AQA33ARA33A\A(AAAffAzA
=AA=qA\)A\A=qAAAAAAQAAA{AzAQAAAAA\A=qA=qA(A
=AA{AQAAAQAQAAAzAApAApA{AAApA{A{A=qAA\)A  AAA{AAHA(ApA
=A  A33AA
A\AA\)AAAAHA(A\AAAGAApA
AAAAHAA
A
A
AzAA{AAffAzAzAAA{A=qAQAA
=AAGAAApA=qA=qAA(AffAAHAHA
AHA\)A33ARA  A
=A
AARAAAQAAHAHAAffAA(ARAAAAQAA
AA
=A\)A{A{ARAA=qAARA\AA33AAzA
AAA=qA=qAA=qA=qAA=qAAAA\ARAA\)A(AA  AARAA\)AAQAA
A\AA(A
AA\)AzAAAARAAA\AA(A(A33A=qAAHAGAHAzAAQAA
AA=qAAAA33AAA\)AffAHA33AQApARAAzAffA{ApAA
=AA\)AQAA
AAA33A\)A\)AGA\A33AAAAApAzApAA\)AAAA\A{AA33AffAAGAA  AA
ARA  A\AHAA=qA  AARAHA33A\)AAzA\AAffAAzA\)AQAHA  A\)AAHApA=qAffAA\A\)AGA
=A\)AAA
A=qAAAA=qA
=A
=A(A(AQAGA  A
AzAzAA\)ApAAAzA33A33AffAzA(ARAApAAzAzAAAAARAGAAA=qA
=AGA
AGAQA(AAAA{ARA
AzAA
=A  AAA(AApAAA{A\)A(A
=A\AAGA33A{AA
=AA
AAA\)AAA
AAQA{A\ARA  AHAGA\AffA
=AARA33AA=qA  AAQA{A  A=qA  AAzA{AGA
=AAGAAzAAA33AA(A33AAGAffA33AA\)AzA\A(AAffA
AAQAA=qA\)AAAzA  A(A
=AGAAApA
=AAApA\)AAGAA=qA\)AAARAA\A
A=qA{AzAA{AAGAAzAQApAA(A
=A  A=qA
A\A\AApA\AHA  AA33AAAAAAA(AGAHAAAAA
AA33AA  AA
=A\A33AHARAQAGAA\)AGAAffA=qA{A=qAGA\AffAAzAA  AGA=qAA\AApA=qAffAAAApAzA
=A{AA
A33AA\AA
A(AHA33A
A(AAAHAzA{AffAHA33A=qA  AA\)AffA
=ARA
=AffA\ARA33AA
AAA(A33A
A=qA  A
A
AffA(A33AAÅAAHAAHAApApAGAA(AÙA33AA33ARAHApAAAHAAAA33A  AAHAAAzA\AA  AA  A  AzAzAQAA33AA  AAHAApAAA  AA(A{AARA\)A
A{A\A
=A
=AA
AAA
AGA{A33A{A¸RA£AA33AÅAÅAzAÙA{AA
=A(A¸RAÙA\)AzAŅA=qAŅAGA
AAHAAQA\)AřAGAQA(A=qAAQAAƣAƏ\AAĸRAîA£AÙA(A¸RAÅAŅAGA(AÙAAzA
=AHAzAApAHAA(AHAzA\AAA(AGA\AA(A(AA{AA33AAAA\)AAAA=qApAARAffA
AA=qA33A
AAffAAA\AA33AAHAA  A  A=qA
=AAAAzApAGAA\AQA
A
=AffA=qA
=A(A
=A\)AQAAffAAHAAřAA  AA33AAffA
=A  AGA
=AGA=qA33AA=qA=qAAGA=qAAA
=AAARAHAQA
AA\AAffAAA  AApAAA£ARA33AQA
=AAAAA
AAQA
AA\AA33A  AAzAffAffApAAAAA\AA
A\)A
=A\)AzA=qARAA\ARAGA
A(AA\)A(A  AAď\ApAA=qAA{ARAA{A{ARAApAHAAQA\)AAA
=AHARA33AAApAHAApAQA\AA{A
=A33AffA{AAAA\AHAA\A
A{A(A¸RAA=qApA=qAAA=qA33A  Aȏ\ApA(A{AGAffAAȏ\AA
AɮAHApAǅAzAAƸRAȣA
AAəA\)AȣAHAAGAA{AGAƏ\A
AQAA=qAAA33A\)AHAȏ\Aȏ\A
=AzAAQAď\A  AffAApA
A\)AQAQA¸RA\)A  AARA=qAHA{AAffA
AAAA\)AGA
AAzAA{AA=qA{A33A{AGApA=qAAAGAAQAA\AƏ\A
=ApA33AQA£A(A  A(AA
=A
AAApAAQA  AA
AARA{A33AA
=ARAGAAHAAQAîAGAGAQA
A=qAQAffA  AAAQAîA£A=qAA
=AQAAzAffApA\)AAAAGAQA33A\)AÅA{AA(A\AQAzA
=AGA{AAA  AHAAQA33A  AAAAARAzAAHARAA\)AGA=qAA(AHAGApAÅA
A=qA{AQAď\A
AŮAGAGA
AA33A33AHAGApAGAĸRA
AÙApA¸RA
AffA\AzARAAQAÅAHAAģA33AAA\)AAAffA33AGA{A
A{A(AA
AARA\)AQARA(AAA{AHA33AA(A(A{AQAGApAffAzA\)A(A
=AA{AAA=qAAzAAHAAGAHApAA  AAGAA¸RAîA{A  AQAffAQA(A  A=qA£AffAAA£A¸RAA=qApAGAA=qA£AA£AzA(A\)AQAAƏ\AřAřAŅA=qAQAAģAAAAHAffAAffAĸRAAffAQAzA=qA=qA
AAŮA  AA{AffAƏ\AŮA\A{AA  AAA¸RA¸RA
=A=qAAÅA=qA¸RA\A\)A  AA\)A\)AřA  AA=qAƏ\AA33AAAƏ\AƏ\A(A\)AəAʏ\A{AɅA  AəAGApAǅAǮAQAǮAAǮAA
=A
=A33AAHAzAAA
=A33AQAƏ\AAǮAHA{AzAŮAAAƸRAǅAɅA{AAƏ\AǅApAƏ\A(ApAHA  AA(Aď\AƣAAffAÅAĸRApApA£AAHAQAA\)AAÅApA
=A\)A  AAAApAzAffA
AffAA\AŅAA
AA=qA  A¸RAÅAGAAzA£AA=qAÙAď\AQAĸRAģAffAAŅA\)AAAHAAAAGA  A=qAzA(AŮAApAřA=qA  AÙA
=A\)ApAAŅAAď\AŅAď\AffAffA
=A{A{AA
A{AffAQAAzA¸RAffA
AA£AAHAA  ARAAA33AAA
ApAÅAAAAHA\)A=qAQAAAAHA=qAAGAAA\AApAAA33A
A
=AAA\)AAffAHAApA{ApA
A  AGA(ARA\AA33ARAHA\AGAAHA\A33A=qAA\)A  A33AHAHARA=qA
=A  A(AAffA33A  A¸RA\AAA\A
AQA=qAQA  AGA33AA
A  AA£A33AA=qAzApA  A  A{A
A
AA¸RA{AGA(AQA(AHAHA\)AA{A\AffA
A¸RAAA(ARA33AAA=qAAA\)AA{AffAA\AffAQApARA33AGA
A{AHAAAQAAHAHAAA{AAHAzA{A(A{AQA{AGA=qAAAffAAARAAAzAffAffA=qAARAAGAA(A
=AAzA{A
=A
A=qAA
AARA=qAffA\A=qAAA\AA
A  AAA\AzA
=AAAAA33AffAA\A\AAAQAA
=A\)AA\)AAAAAQA=qA
A=qAffAAAAffAA  AQApAÅAAAAHA\)AAApAîA
=AAffAffA33ApAA
=AAffAAAAAA
=ApApAQAHA
=A\A33AAAARAHAAHA33AffAA\AAAA  AQAAA=qA\)AA
=A33AAA\)AÙAÙA
A=qAAGAģAîAA
A=qAǮAʣAzA{AAAffA=qApA\)A=qAƸRAAAQA
=A{AAģAA=qAAA
AffA33AȣA(A33AĸRApA(A(A\)AHAHAApAzAAzAHAAAAA
=AHA33AAGA\)A\AAGAAHAQAHAA\AAAAQAAA=qA(A{A£A  A(A  A=qA¸RAAÅA\)ApApAAApA\)A£A£AApAA
=ApAřAřAřAGAģA\)ApAHAAď\A=qApA£AAAAAGA33AAA=qA£A(AĸRAffA\)A33A33AzAÅA
A{A\A£AAA  A
=A¸RAA  A
=A¸RAApAGAGA33A33A(A{A
=AA\)A
=A\)A\A
AA
A(AQAHA
=AQARAARAzAA  A{A(A(A=qA\)AAA(A\A
A=qA  AffAAÅAÙAAffAGAA(AAAA=qAAA(AzAGAA  AzAAffA=qAÙApAffA  AAHAAAA(AAď\AQAHA\AA
ApAAA\AzAAA\)AAAAA=qAA\ARA\)A33A
AAA33A  AA33AffA
A
=A=qAAAHA
AA£A33A(A\AAQAAzAzAzAAAHA33AHAAGA  AA(A
=A=qApAAAzA\)A(A  AzA(A33AA33AAģApA33AŅAƏ\AŅAzAď\AQA=qAGA  A{Aď\AQA  A  A(AŅAÙAAÅA¸RAAAA  A(A(AzA{AAAAAAA{ApA
=AĸRAĸRAzAHA
AA(A(AQA
ApA(A
A
AA\)AA(A\)AAAHA(ApA£AffAAAA33AAzAGAARA33A33AGAAGAA
A=qA
=AAHAffApAGAzAGA
AA
=AAQAApA=qAA{A
=A\AA\AAAA\)A  AffA¸RAzA
A{AzAzA
=AAzA
A33AA(AAzAQAGAA\)AAA(AAAAAA\A\AGAHAA(AHAApAAffA=qAA{AAA{AAffAAAAģAÙA33A  A\AAAHA33ApAGAHAAAA=qAAHAffARAA{AAHApA  AAA{AzAQAA  AA
=AAHAA=qAA(A(AAAzAzAGAA(A\AAA(AQA
=AAAHAAARAAAzARA\)AGA\AA{AA{AffAQA\ARA(AA
AA33ARAAzApAAAAffAQAAAAQAQAA
=AA33AQAAzA
AAAzAAGAQAAQA  AQAA
AA  A\A=qAAHAA33A\A  ApAQA  AHAQAAApAA
=ApAHAGAARA{A(AzAAAzAffAAAAzA(AApAAffA(A(AffA{AARA\A
AA
=A
A(AARA\AQA
=A\)A\)AAffA\AQAGApAffARA
AAA=qA  A=qA(AAAffAAzA33A
A=qAffApA33A{AHAAA=qAHA  A  A\A=qARA\)A(ApAÙA=qA
=AQA\)A=qA\)AAzA  A
AÅAAQAQAA33AGA  A=qA
A\)AffAzApA
A
=AA=qA33AARAAGA\AA{AffAA(AA\)AAAA(A(AAAA(AA  A\A(A=qAA\)A\)AGAA=qAGA  A(AÙAA{A{AA=qAřAĸRAA\)AģA  AAGA=qA
=AAAHAQAffA33AzA{AAA{A=qAA=qAA\)AffAAAzAAHA\A(A  A
A
AQA
=A=qAHA
=A{A
=AAAApAAHAHA{AzApAAQAApAA33A\AAA{AA\A(AApAAHApAffAAQAARARA
=AApAffApAffAAGAAAHARA
AGAA\ARA\AA33A33AApAARA=qAAffAffA
A\A(A{ApAAAffA(AA\)AQARAQAApA
AAGAffAHAARA\)AAAÅA¸RAAÙA  A{AffApAA=qA{AAHA
ARA33ARA
=ApAQApAQA33A\AAAAAA=qAGA
=A=qA=qA{AQA
=AA\)A\)AzA\)A(A
=A
AHAA\A=qA(AAffAffAA
=A
A{A{A
A  A
AAA
=AAffAHA33AAGAQA
AAAGAzA33A{AGAAHAA(A£Aff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                   	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      	         	                                                                                                                                                                                                      	   	   	   	   	      	            	            	                                 	         	         	   	   	               	                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              