CDF       
      
timeseries        obs   .C   station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:17:04Z http://pacioos.org
2022-11-15T19:17:04Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2019-01-01T00:00:00Z&time%3C2020-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2019-11-29T01:00:00Z   time_coverage_resolution      PT30M      time_coverage_start       2019-07-12T19:45:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      AJ8   Axd      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      r r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      AB	
   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH           salinity                   _ChunkSizes                
_FillValue        y    actual_range          C#   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B           	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      ?Ec    ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz        W   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      :HC   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C            oxygen                     _ChunkSizes                
_FillValue        y    actual_range      >A(   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        ,   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      A^ffG5!   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        8   ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        ;D   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AB	
   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH        P   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range                \   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      	fh   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      
t   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      
؀   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	         temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      J   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      
   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      
   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      u   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      .   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	         temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	         temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      Y   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	         temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	         salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range          C#   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B           salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range                >   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      (   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      4   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      i@   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      "L   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      X   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      d   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      Mp   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      |   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	         salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      x   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      1   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	         salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	         salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	      \   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      ?Ec    ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz           turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range                   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	          turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      !@   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      !    turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      "   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      #l   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      $%$   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      $0   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      %<   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      &PH   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      '	T   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      '`   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      ({l   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      :HC   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C        )4x   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range                )   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      *   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      +_   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      ,   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      ,Ѵ   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      -   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      .C   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      .   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      /   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      0n   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      1'   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      1   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      2   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      >A(   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH        3S    oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range                4,   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      48   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      5~D   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      67P   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      6\   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      7h   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      8bt   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      9   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      9Ԍ   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      :   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      ;F   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      ;   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      <   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      A^ffG5!   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C        =q   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range                >*   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      >   oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      ?   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      @U   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      A   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      A   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      B   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      C:(   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      C4   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      D@   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      EeL   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      FX   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      Fd   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`        Gp   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                HI|   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	      I   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	      I   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	      Jt   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	      K-   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	      K   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	      L   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	      MX   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	      N   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	      N   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	      O   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	      P=    	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	      P   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045        Q   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde      RĬ   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    \ [q<Ap?  wqb_04  AJ8   AJ9   AJ:   AJ;r   AJ<S   AJ=4   AJ>   AJ>   AJ?   AJ@   AJA   AJBz   AJC[   AJD<   AJE   AJE   AJF   AJG   AJH   AJI   AJJc   AJKD   AJL%   AJM   AJM   AJN   AJO   AJP   AJQk   AJRL   AJS-   AJT   AJT   AJU   AJV   AJW   AJXs   AJYT   AJZ5   AJ[   AJ[   AJ\   AJ]   AJ^   AJ_{   AJ`\   AJa=   AJb   AJb   AJc   AJd   AJe   AJf   AJgd   AJhE   AJi&   AJj   AJj   AJk   AJl   AJm   AJnl   AJoM   AJp.   AJq   AJq   AJr   AJs   AJt   AJut   AJvU   AJw6   AJx   AJx   AJy   AJz   AJ{   AJ||   AJ}]   AJ~>   AJ   AJ    AJ   AJ   AJ   AJ   AJe   AJF   AJ'   AJ   AJ   AJ   AJ   AJ   AJm   AJN   AJ/   AJ   AJ   AJ   AJ   AJ   AJu   AJV   AJ7   AJ   AJ   AJ   AJ   AJ   AJ}   AJ^   AJ?   AJ    AJ   AJ   AJ   AJ   AJ   AJf   AJG   AJ(   AJ	   AJ   AJ   AJ   AJ   AJn   AJO   AJ0   AJ   AJ   AJ   AJ   AJ   AJv   AJW   AJ8   AJ   AJ   AJ   AJ   AJ   AJ~   AJ_   AJ@   AJ!   AJ   AJ   AJ   AJ   AJ   AJg   AJH   AJ)   AJ
   AJ   AJ   AJí   AJĎ   AJo   AJP   AJ1   AJ   AJ   AJ   AJʵ   AJ˖   AJw   AJX   AJ9   AJ   AJ   AJ   AJѽ   AJҞ   AJ   AJ`   AJA   AJ"   AJ   AJ   AJ   AJ٦   AJڇ   AJh   AJI   AJ*   AJ   AJ   AJ   AJ   AJ   AJp   AJQ   AJ2   AJ   AJ   AJ   AJ   AJ   AJx   AJY   AJ:   AJ   AJ   AJ   AJ   AJ   AJ   AJa   AJB   AJ#   AJ   AJ   AJ   AJ   AJ   AJi   AJJ   AJ+   AJ   AJ   AJ   AJ   AJ   AJq   AK R   AK3   AK   AK   AK   AK   AK   AKy   AKZ   AK;   AK	   AK	   AK
   AK   AK   AK
   AKb   AKC   AK$   AK   AK   AK   AK   AK   AKj   AKK   AK,   AK
   AK   AK   AK   AK   AKr   AKS   AK4   AK   AK   AK    AK!   AK"   AK#z   AK$[   AK%<   AK&   AK&   AK'   AK(   AK)   AK*   AK+c   AK,D   AK-%   AK.   AK.   AK/   AK0   AK1   AK2k   AK3L   AK4-   AK5   AK5   AK6   AK7   AK8   AK9s   AK:T   AK;5   AK<   AK<   AK=   AK>   AK?   AK@{   AKA\   AKB=   AKC   AKC   AKD   AKE   AKF   AKG   AKHd   AKIE   AKJ&   AKK   AKK   AKL   AKM   AKN   AKOl   AKPM   AKQ.   AKR   AKR   AKS   AKT   AKU   AKVt   AKWU   AKX6   AKY   AKY   AKZ   AK[   AK\   AK]|   AK^]   AK_>   AK`   AKa    AKa   AKb   AKc   AKd   AKee   AKfF   AKg'   AKh   AKh   AKi   AKj   AKk   AKlm   AKmN   AKn/   AKo   AKo   AKp   AKq   AKr   AKsu   AKtV   AKu7   AKv   AKv   AKw   AKx   AKy   AKz}   AK{^   AK|?   AK}    AK~   AK~   AK   AK   AK   AKf   AKG   AK(   AK	   AK   AK   AK   AK   AKn   AKO   AK0   AK   AK   AK   AK   AK   AKv   AKW   AK8   AK   AK   AK   AK   AK   AK~   AK_   AK@   AK!   AK   AK   AK   AK   AK   AKg   AKH   AK)   AK
   AK   AK   AK   AK   AKo   AKP   AK1   AK   AK   AK   AK   AK   AKw   AKX   AK9   AK   AK   AK   AK   AK   AK   AK`   AKA   AK"   AK   AK   AK   AK   AK   AKh   AKI   AK*   AK   AK   AK   AK   AK   AKp   AKQ   AK2   AK   AK   AKȶ   AKɗ   AKx   AKY   AK:   AK   AK   AK   AKϾ   AKП   AKр   AKa   AKB   AK#   AK   AK   AK   AKק   AK؈   AKi   AKJ   AK+   AK   AK   AK   AKޯ   AKߐ   AKq   AKR   AK3   AK   AK   AK   AK   AK   AKy   AKZ   AK;   AK   AK   AK   AK   AK   AK   AKb   AKC   AK$   AK   AK   AK   AK   AK   AKj   AKK   AK,   AK   AK   AK   AK   AKr   AKS   AK4   AL    AL    AL   AL   AL   ALz   AL[   AL<   AL   AL   AL   AL	   AL
   AL   ALc   AL
D   AL%   AL   AL   AL   AL   AL   ALk   ALL   AL-   AL   AL   AL   AL   AL   ALs   ALT   AL5   AL   AL   AL   AL    AL!{   AL"\   AL#=   AL$   AL$   AL%   AL&   AL'   AL(   AL)d   AL*E   AL+&   AL,   AL,   AL-   AL.   AL/   AL0l   AL1M   AL2.   AL3   AL3   AL4   AL5   AL6   AL7t   AL8U   AL96   AL:   AL:   AL;   AL<   AL=   AL>|   AL?]   AL@>   ALA   ALB    ALB   ALC   ALD   ALE   ALFe   ALGF   ALH'   ALI   ALJ   ALK   ALL   ALMm   ALNN   ALO/   ALP   ALP   ALQ   ALR   ALS   ALTu   ALUV   ALV7   ALW   ALW   ALX   ALY   ALZ   AL[}   AL\^   AL]?   AL^    AL_   AL_   AL`   ALa   ALb   ALcf   ALdG   ALe(   ALf	   ALf   ALg   ALh   ALi   ALjn   ALkO   ALl0   ALm   ALm   ALn   ALo   ALp   ALqv   ALrW   ALs8   ALt   ALt   ALu   ALv   ALw   ALx~   ALy_   ALz@   AL{!   AL|   AL|   AL}   AL~   AL   ALg   ALH   AL)   AL
   AL   AL   AL   AL   ALo   ALP   AL1   AL   AL   AL   AL   AL   ALw   ALX   AL9   AL   AL   AL   AL   AL   AL   AL`   ALA   AL"   AL   AL   AL   AL   AL   ALh   ALI   AL*   AL   AL   AL   AL   AL   ALQ   AL2   AL   AL   AL   AL   AL   ALx   ALY   AL:   AL   AL   AL   AL   AL   AL   ALa   ALB   AL#   AL   AL   AL   AL   AL   ALi   ALJ   AL+   AL   AL   AL   AL   AL   ALq   ALR   AL3   AL   AL   AL   ALƷ   ALǘ   ALy   ALZ   AL;   AL   AL   AL   ALͿ   ALΠ   ALρ   ALb   ALC   AL$   AL   AL   AL   ALը   AL։   ALj   ALK   AL,   AL
   AL   AL   ALܰ   ALݑ   ALr   ALS   AL4   AL   AL   AL   AL   AL   ALz   AL[   AL<   AL   AL   AL   AL   AL   ALc   ALD   AL%   AL   AL   AL   AL   AL   ALk   AL-   AL   AL   AL   AL   AL   ALs   ALT   AL5   AL   AL   AL   AM    AM   AM{   AM\   AM=   AM   AM   AM   AM   AM   AM	   AM
d   AME   AM&   AM
   AM
   AM   AM   AM   AMl   AMM   AM.   AM   AM   AM   AM   AM   AMt   AMU   AM6   AM   AM   AM   AM   AM   AM|   AM ]   AM!>   AM"   AM#    AM#   AM$   AM%   AM&   AM'e   AM(F   AM)'   AM*   AM*   AM+   AM,   AM-   AM.m   AM/N   AM0/   AM1   AM1   AM2   AM3   AM4   AM5u   AM6V   AM77   AM8   AM8   AM9   AM:   AM;   AM<}   AM=^   AM>?   AM?    AM@   AM@   AMA   AMB   AMC   AMDf   AMEG   AMF(   AMG	   AMG   AMH   AMI   AMJ   AMKn   AMLO   AMM0   AMN   AMN   AMO   AMP   AMQ   AMRv   AMSW   AMT8   AMU   AMU   AMV   AMW   AMX   AMY~   AMZ_   AM[@   AM\!   AM]   AM]   AM^   AM_   AM`   AMag   AMbH   AMc)   AMd
   AMd   AMe   AMf   AMg   AMho   AMiP   AMj1   AMk   AMk   AMl   AMm   AMn   AMow   AMpX   AMq9   AMr   AMr   AMs   AMt   AMu   AMv   AMw`   AMxA   AMy"   AMz   AMz   AM{   AM|   AM}   AM~h   AMI   AM*   AM   AM   AM   AM   AM   AMp   AMQ   AM2   AM   AM   AM   AM   AM   AMx   AMY   AM:   AM   AM   AM   AM   AM   AM   AMa   AMB   AM#   AM   AM   AM   AM   AM   AMi   AMJ   AM+   AM   AM   AM   AM   AM   AMq   AMR   AM3   AM   AM   AM   AM   AM   AMy   AMZ   AM;   AM   AM   AM   AM   AM   AM   AMb   AMC   AM$   AM   AM   AM   AM   AM   AMj   AMK   AM,   AM
   AM   AM   AM   AM   AMr   AMS   AM4   AM   AM   AM   AMĸ   AMř   AMz   AM[   AM<   AM   AM   AM   AM   AM̡   AM͂   AMc   AMD   AM%   AM   AM   AM   AMө   AMԊ   AMk   AML   AM-   AM   AM   AM   AMڱ   AMے   AMs   AMT   AM5   AM   AM   AM   AM   AM   AM{   AM\   AM=   AM   AM   AM   AM   AM   AM   AMd   AME   AM&   AM   AM   AM   AM   AM   AMl   AMM   AM.   AM   AM   AM   AM   AM   AMt   AMU   AM6   AM   AM   AM   AM   AM   AN |   AN]   AN>   AN   AN    AN   AN   AN   AN   AN	F   AN
'   AN   AN   AN   AN
   AN   ANm   ANN   AN/   AN   AN   AN   AN   AN   ANu   ANV   AN7   AN   AN   AN   AN   AN   AN}   AN^   AN?   AN     AN!   AN!   AN"   AN#   AN$   AN%f   AN&G   AN'(   AN(	   AN(   AN)   AN*   AN+   AN,n   AN-O   AN.0   AN/   AN/   AN0   AN1   AN2   AN3v   AN4W   AN58   AN6   AN6   AN7   AN8   AN9   AN:~   AN;_   AN<@   AN=!   AN>   AN>   AN?   AN@   ANA   ANBg   ANCH   AND)   ANE
   ANE   ANF   ANG   ANH   ANIo   ANJP   ANK1   ANL   ANL   ANM   ANN   ANO   ANPw   ANQX   ANR9   ANS   ANS   ANT   ANU   ANV   ANW   ANX`   ANYA   ANZ"   AN[   AN[   AN\   AN]   AN^   AN_h   AN`I   ANa*   ANb   ANb   ANc   ANd   ANe   ANfp   ANgQ   ANh2   ANi   ANi   ANj   ANk   ANl   ANmx   ANnY   ANo:   ANp   ANp   ANq   ANr   ANs   ANt   ANua   ANvB   ANw#   ANx   ANx   ANy   ANz   AN{   AN|i   AN}J   AN~+   AN   AN   AN   AN   AN   ANq   ANR   AN3   AN   AN   AN   AN   AN   ANy   ANZ   AN;   AN   AN   AN   AN   AN   AN   ANb   ANC   AN$   AN   AN   AN   AN   AN   ANj   ANK   AN,   AN
   AN   AN   AN   AN   ANr   ANS   AN4   AN   AN   AN   AN   ANz   AN[   AN<   AN   AN   AN   AN   AN   AN   ANc   AND   AN%   AN   AN   AN   AN   AN   ANk   ANL   AN-   AN   AN   AN   AN   AN   ANs   ANT   AN5   AN   AN   AN   AN¹   ANÚ   AN{   AN\   AN=   AN   AN   AN   AN   ANʢ   AN˃   ANd   ANE   AN&   AN   AN   AN   ANѪ   ANҋ   ANl   ANM   AN.   AN   AN   AN   ANز   ANٓ   ANt   ANU   AN6   AN   AN   AN   ANߺ   AN   AN|   AN]   AN>   AN   AN    AN   AN   AN   AN   ANe   ANF   AN'   AN   AN   AN   AN   AN   ANm   ANN   AN/   AN   AN   AN   AN   AN   ANu   ANV   AN7   AN   AN   AN   AN   AN   AN}   AN^   AO ?   AO    AO   AO   AO   AO   AO   AOf   AOG   AO(   AO		   AO	   AO
   AO   AO   AO
n   AOO   AO0   AO   AO   AO   AO   AO   AOv   AOW   AO8   AO   AO   AO   AO   AO   AO~   AO_   AO@   AO!   AO   AO   AO    AO!   AO"   AO#g   AO$H   AO%)   AO&
   AO&   AO'   AO(   AO)   AO*o   AO+P   AO,1   AO-   AO-   AO.   AO/   AO0   AO1w   AO2X   AO39   AO4   AO4   AO5   AO6   AO7   AO8   AO9`   AO:A   AO;"   AO<   AO<   AO=   AO>   AO?   AO@h   AOAI   AOB*   AOC   AOC   AOD   AOE   AOF   AOGp   AOHQ   AOI2   AOJ   AOJ   AOK   AOL   AOM   AONx   AOOY   AOP:   AOQ   AOQ   AOR   AOS   AOT   AOU   AOVa   AOWB   AOX#   AOY   AOY   AOZ   AO[   AO\   AO]i   AO^J   AO_+   AO`   AO`   AOa   AOb   AOc   AOdq   AOeR   AOf3   AOg   AOg   AOh   AOi   AOj   AOky   AOlZ   AOm;   AOn   AOn   AOo   AOp   AOq   AOr   AOsb   AOtC   AOu$   AOv   AOv   AOw   AOx   AOy   AOzj   AO{K   AO|,   AO}
   AO}   AO~   AO   AO   AOr   AOS   AO4   AO   AO   AO   AO   AO   AOz   AO[   AO<   AO   AO   AO   AO   AO   AO   AOc   AOD   AO%   AO   AO   AO   AO   AO   AOk   AOL   AO-   AO   AO   AO   AO   AO   AOs   AOT   AO5   AO   AO   AO   AO   AO   AO{   AO\   AO=   AO   AO   AO   AO   AO   AO   AOd   AOE   AO&   AO   AO   AO   AO   AO   AOl   AOM   AO.   AO   AO   AO   AO   AO   AOt   AOU   AO6   AO   AO   AO   AO   AO   AO|   AO]   AO>   AO   AO    AO   AO   AOȣ   AOɄ   AOe   AOF   AO'   AO   AO   AO   AOϫ   AOЌ   AOm   AON   AO/   AO   AO   AO   AOֳ   AOה   AOu   AOV   AO7   AO   AO   AO   AOݻ   AOޜ   AO}   AO^   AO?   AO    AO   AO   AO   AO   AO   AOf   AOG   AO(   AO	   AO   AO   AO   AO   AOn   AOO   AO0   AO   AO   AO   AO   AO   AOv   AOW   AO8   AO   AO   AO   AO   AO   AO~   AO_   AO@   AO!   AP    AP    AP   AP   AP   APg   APH   AP)   AP
   AP   AP   AP	   AP
   APo   APP   AP
1   AP   AP   AP   AP   AP   APw   APX   AP9   AP   AP   AP   AP   AP   AP   AP`   APA   AP"   AP   AP   AP   AP   AP    AP!h   AP"I   AP#*   AP$   AP$   AP%   AP&   AP'   AP(p   AP)Q   AP*2   AP+   AP+   AP,   AP-   AP.   AP/x   AP0Y   AP1:   AP2   AP2   AP3   AP4   AP5   AP6   AP7a   AP8B   AP9#   AP:   AP:   AP;   AP<   AP=   AP>i   AP?J   AP@+   APA   APA   APB   APC   APD   APEq   APFR   APG3   APH   APH   API   APJ   APK   APLy   APMZ   APN;   APO   APO   APP   APQ   APR   APS   APTb   APUC   APV$   APW   APW   APX   APY   APZ   AP[j   AP\K   AP],   AP^
   AP^   AP_   AP`   APa   APbr   APcS   APd4   APe   APe   APf   APg   APh   APiz   APj[   APk<   APl   APl   APm   APn   APo   APp   APqc   APrD   APs%   APt   APt   APu   APv   APw   APxk   APyL   APz-   AP{   AP{   AP|   AP}   AP~   APs   APT   AP5   AP   AP   AP   AP   AP   AP{   AP\   AP=   AP   AP   AP   AP   AP   AP   APd   APE   AP&   AP   AP   AP   AP   AP   APl   APM   AP.   AP   AP   AP   AP   AP   APt   APU   AP6   AP   AP   AP   AP   AP   AP|   AP]   AP>   AP   AP    AP   AP   AP   AP   APe   APF   AP'   AP   AP   AP   AP   AP   APm   APN   AP/   AP   AP   AP   AP   AP   APu   APV   AP7   AP   AP   AP   AP   AP   AP}   AP^   AP?   AP    AP   AP   AP   APƤ   APǅ   APf   APG   AP(   AP	   AP   AP   APͬ   AP΍   APn   APO   AP0   AP   AP   AP   APԴ   APՕ   APv   APW   AP8   AP   AP   AP   APۼ   APܝ   AP~   AP_   AP@   AP!   AP   AP   AP   AP   AP   APg   APH   AP)   AP
   AP   AP   AP   AP   APo   APP   AP1   AP   AP   AP   AP   AP   APw   APX   AP9   AP   AP   AP   AP   AP   AP   AP`   APA   AP"   AP   AP   AP   AQ    AQ   AQh   AQI   AQ*   AQ   AQ   AQ   AQ   AQ   AQ	p   AQ
Q   AQ2   AQ   AQ   AQ
   AQ   AQ   AQx   AQY   AQ:   AQ   AQ   AQ   AQ   AQ   AQa   AQB   AQ#   AQ   AQ   AQ   AQ   AQ   AQi   AQ J   AQ!+   AQ"   AQ"   AQ#   AQ$   AQ%   AQ&q   AQ'R   AQ(3   AQ)   AQ)   AQ*   AQ+   AQ,   AQ-y   AQ.Z   AQ/;   AQ0   AQ0   AQ1   AQ2   AQ3   AQ4   AQ5b   AQ6C   AQ7$   AQ8   AQ8   AQ9   AQ:   AQ;   AQ<j   AQ=K   AQ>,   AQ?
   AQ?   AQ@   AQA   AQB   AQCr   AQDS   AQE4   AQF   AQF   AQG   AQH   AQI   AQJz   AQK[   AQL<   AQM   AQM   AQN   AQO   AQP   AQQ   AQRc   AQSD   AQT%   AQU   AQU   AQV   AQW   AQX   AQYk   AQZL   AQ[-   AQ\   AQ\   AQ]   AQ^   AQ_   AQ`s   AQaT   AQb5   AQc   AQc   AQd   AQe   AQf   AQg{   AQh\   AQi=   AQj   AQj   AQk   AQl   AQm   AQn   AQod   AQpE   AQq&   AQr   AQr   AQs   AQt   AQu   AQvl   AQwM   AQx.   AQy   AQy   AQz   AQ{   AQ|   AQ}t   AQ~U   AQ6   AQ   AQ   AQ   AQ   AQ   AQ|   AQ]   AQ>   AQ   AQ    AQ   AQ   AQ   AQ   AQe   AQF   AQ'   AQ   AQ   AQ   AQ   AQ   AQm   AQN   AQ/   AQ   AQ   AQ   AQ   AQ   AQu   AQV   AQ7   AQ   AQ   AQ   AQ   AQ   AQ}   AQ^   AQ?   AQ    AQ   AQ   AQ   AQ   AQ   AQf   AQG   AQ(   AQ	   AQ   AQ   AQ   AQ   AQn   AQO   AQ0   AQ   AQ   AQ   AQ   AQ   AQv   AQW   AQ8   AQ   AQ   AQ   AQ   AQ   AQ~   AQ_   AQ@   AQ!   AQ   AQ   AQ   AQĥ   AQņ   AQg   AQH   AQ)   AQ
   AQ   AQ   AQ˭   AQ̎   AQo   AQP   AQ1   AQ   AQ   AQ   AQҵ   AQӖ   AQw   AQX   AQ   AQ   AQ   AQٽ   AQڞ   AQ   AQ`   AQA   AQ"   AQ   AQ   AQ   AQ   AQ   AQh   AQI   AQ*   AQ   AQ   AQ   AQ   AQp   AQQ   AQ2   AQ   AQ   AQ   AQ   AQ   AQx   AQY   AQ:   AQ   AQ   AQ   AQ   AQ   AQ   AQa   AQB   AQ#   AQ   AQ   AQ   AQ   AQ   AR i   ARJ   AR+   AR   AR   AR   AR   AR   ARq   ARR   AR	3   AR
   AR
   AR   AR   AR
   ARy   ARZ   AR;   AR   AR   AR   AR   AR   AR   ARb   ARC   AR$   AR   AR   AR   AR   AR   ARj   ARK   AR,   AR 
   AR    AR!   AR"   AR#   AR$r   AR%S   AR&4   AR'   AR'   AR(   AR)   AR*   AR+z   AR,[   AR-<   AR.   AR.   AR/   AR0   AR1   AR2   AR3c   AR4D   AR5%   AR6   AR6   AR7   AR8   AR9   AR:k   AR;L   AR<-   AR=   AR=   AR>   AR?   AR@   ARAs   ARBT   ARC5   ARD   ARD   ARE   ARF   ARG   ARH{   ARI\   ARJ=   ARK   ARK   ARL   ARM   ARN   ARO   ARPd   ARQE   ARR&   ARS   ARS   ART   ARU   ARV   ARWl   ARXM   ARY.   ARZ   ARZ   AR[   AR\   AR]   AR^t   AR_U   AR`6   ARa   ARa   ARb   ARc   ARd   ARe|   ARf]   ARg>   ARh   ARi    ARi   ARj   ARk   ARl   ARme   ARnF   ARo'   ARp   ARp   ARq   ARr   ARs   ARtm   ARuN   ARv/   ARw   ARw   ARx   ARy   ARz   AR{u   AR|V   AR}7   AR~   AR~   AR   AR   AR   AR}   AR^   AR?   AR    AR   AR   AR   AR   AR   ARf   ARG   AR(   AR	   AR   AR   AR   AR   ARn   ARO   AR0   AR   AR   AR   AR   AR   ARv   ARW   AR8   AR   AR   AR   AR   AR   AR~   AR_   AR@   AR!   AR   AR   AR   AR   AR   ARg   ARH   AR)   AR
   AR   AR   AR   AR   ARo   ARP   AR1   AR   AR   AR   AR   AR   ARw   ARX   AR9   AR   AR   AR   AR   AR   AR   AR`   ARA   AR"   AR   AR   AR   AR¦   ARÇ   ARh   ARI   AR*   AR   AR   AR   ARɮ   ARʏ   ARp   ARQ   AR2   AR   AR   AR   ARж   ARї   ARx   ARY   AR:   AR   AR   AR   AR׾   AR؟   ARـ   ARa   ARB   AR#   AR   AR   AR   ARߧ   AR   ARi   ARJ   AR+   AR   AR   AR   AR   AR   ARq   ARR   AR3   AR   AR   AR   AR   AR   ARy   ARZ   AR;   AR   AR   AR   AR   AR   AR   ARb   ARC   AR$   AR   AR   AR   AR   AR   ARj   ARK   AS ,   AS
   AS   AS   AS   AS   ASr   ASS   AS4   AS   AS   AS	   AS
   AS   ASz   AS
[   AS<   AS   AS   AS   AS   AS   AS   ASc   ASD   AS%   AS   AS   AS   AS   AS   ASk   ASL   AS-   AS   AS   AS   AS    AS!   AS"s   AS#T   AS$5   AS%   AS%   AS&   AS'   AS(   AS){   AS*\   AS+=   AS,   AS,   AS-   AS.   AS/   AS0   AS1d   AS2E   AS3&   AS4   AS4   AS5   AS6   AS7   AS8l   AS9M   AS:.   AS;   AS;   AS<   AS=   AS>   AS?t   AS@U   ASA6   ASB   ASB   ASC   ASD   ASE   ASG]   ASH>   ASI   ASJ    ASJ   ASK   ASL   ASM   ASNe   ASOF   ASP'   ASQ   ASQ   ASR   ASS   AST   ASUm   ASVN   ASW/   ASX   ASX   ASY   ASZ   AS[   AS\u   AS]V   AS^7   AS_   AS_   AS`   ASa   ASb   ASc}   ASd^   ASe?   ASf    ASg   ASg   ASh   ASi   ASj   ASkf   ASlG   ASm(   ASn	   ASn   ASo   ASp   ASq   ASrn   ASsO   ASt0   ASu   ASu   ASv   ASw   ASx   ASyv   ASzW   AS{8   AS|   AS|   AS}   AS~   AS   AS~   AS_   AS@   AS!   AS   AS   AS   AS   AS   ASg   ASH   AS)   AS
   AS   AS   AS   AS   ASo   ASP   AS1   AS   AS   AS   AS   AS   ASw   ASX   AS9   AS   AS   AS   AS   AS   AS   AS`   ASA   AS"   AS   AS   AS   AS   AS   ASh   ASI   AS*   AS   AS   AS   AS   AS   ASp   ASQ   AS2   AS   AS   AS   AS   AS   ASx   ASY   AS:   AS   AS   AS   AS   AS   AS   ASa   ASB   AS#   AS   AS   AS   AS   AS   ASi   ASJ   AS+   AS   AS   AS   ASǯ   ASȐ   ASq   ASR   AS3   AS   AS   AS   ASη   ASϘ   ASy   ASZ   AS;   AS   AS   AS   ASտ   AS֠   ASׁ   ASb   ASC   AS$   AS   AS   AS   ASݨ   ASމ   ASj   ASK   AS,   AS
   AS   AS   AS   AS   ASr   ASS   AS4   AS   AS   AS   AS   AS   ASz   AS[   AS<   AS   AS   AS   AS   AS   AS   ASc   ASD   AS%   AS   AS   AS   AS   AS   ASk   ASL   AS-   AS   AS   AT    AT   AT   ATs   ATT   AT5   AT   AT   AT   AT   AT	   AT
{   AT\   AT=   AT
   AT
   AT   AT   AT   AT   ATd   ATE   AT&   AT   AT   AT   AT   AT   ATl   ATM   AT.   AT   AT   AT   AT   AT   AT t   AT!U   AT"6   AT#   AT#   AT$   AT%   AT&   AT'|   AT(]   AT)>   AT*   AT+    AT+   AT,   AT-   AT.   AT/e   AT0F   AT1'   AT2   AT2   AT3   AT4   AT5   AT6m   AT7N   AT8/   AT9   AT9   AT:   AT;   AT<   AT=u   AT>V   AT?7   AT@   AT@   ATA   ATB   ATC   ATD}   ATE^   ATF?   ATG    ATH   ATH   ATI   ATJ   ATK   ATLf   ATMG   ATN(   ATO	   ATO   ATP   ATQ   ATR   ATSn   ATTO   ATU0   ATV   ATV   ATW   ATX   ATY   ATZv   AT[W   AT\8   AT]   AT]   AT^   AT_   AT`   ATa~   ATb_   ATc@   ATd!   ATe   ATe   ATf   ATg   ATh   ATig   ATjH   ATk)   ATl
   ATl   ATm   ATn   ATo   ATpo   ATqP   ATr1   ATs   ATs   ATt   ATu   ATv   ATww   ATxX   ATy9   ATz   ATz   AT{   AT|   AT}   AT~   AT`   ATA   AT"   AT   AT   AT   AT   AT   ATh   ATI   AT*   AT   AT   AT   AT   AT   ATp   ATQ   AT2   AT   AT   AT   AT   AT   ATx   ATY   AT:   AT   AT   AT   AT   AT   AT   ATa   ATB   AT#   AT   AT   AT   AT   AT   ATi   ATJ   AT+   AT   AT   AT   AT   AT   ATq   ATR   AT3   AT   AT   AT   AT   AT   ATy   ATZ   AT;   AT   AT   AT   AT   AT   AT   ATb   ATC   AT$   AT   AT   AT   AT   AT   ATj   ATK   AT,   AT
   AT   AT   ATŰ   ATƑ   ATr   ATS   AT4   AT   AT   AT   AT̸   AT͙   ATz   AT[   AT<   AT   AT   AT   AT   ATԡ   ATՂ   ATc   ATD   AT%   AT   AT   AT   AT۩   AT܊   ATk   ATL   AT-   AT   AT   AT   AT   AT   ATs   ATT   AT5   AT   AT   AT   AT   AT{   AT\   AT=   AT   AT   AT   AT   AT   AT   ATd   ATE   AT&   AT   AT   AT   AT   AT   ATl   ATM   AT.   AT   AT   AT   AT   AU    AUt   AUU   AU6   AU   AU   AU   AU   AU   AU|   AU	]   AU
>   AU   AU    AU   AU
   AU   AU   AUe   AUF   AU'   AU   AU   AU   AU   AU   AUm   AUN   AU/   AU   AU   AU   AU   AU   AUu   AUV   AU 7   AU!   AU!   AU"   AU#   AU$   AU%}   AU&^   AU'?   AU(    AU)   AU)   AU*   AU+   AU,   AU-f   AU.G   AU/(   AU0	   AU0   AU1   AU2   AU3   AU4n   AU5O   AU60   AU7   AU7   AU8   AU9   AU:   AU;v   AU<W   AU=8   AU>   AU>   AU?   AU@   AUA   AUB~   AUC_   AUD@   AUE!   AUF   AUF   AUG   AUH   AUI   AUJg   AUKH   AUL)   AUM
   AUM   AUN   AUO   AUP   AUQo   AURP   AUS1   AUT   AUT   AUU   AUV   AUW   AUXw   AUYX   AUZ9   AU[   AU[   AU\   AU]   AU^   AU_   AU``   AUaA   AUb"   AUc   AUc   AUd   AUe   AUf   AUgh   AUhI   AUi*   AUj   AUj   AUk   AUl   AUm   AUnp   AUoQ   AUp2   AUq   AUq   AUr   AUs   AUt   AUux   AUvY   AUw:   AUx   AUx   AUy   AUz   AU{   AU|   AU}a   AU~B   AU#   AU   AU   AU   AU   AU   AUi   AUJ   AU+   AU   AU   AU   AU   AU   AUq   AUR   AU3   AU   AU   AU   AU   AU   AUy   AUZ   AU;   AU   AU   AU   AU   AU   AU   AUb   AUC   AU$   AU   AU   AU   AU   AU   AUj   AUK   AU,   AU
   AU   AU   AU   AU   AUr   AUS   AU4   AU   AU   AU   AU   AU   AUz   AU[   AU<   AU   AU   AU   AU   AU   AU   AUc   AUD   AU%   AU   AU   AU   AU   AU   AUk   AUL   AU-   AU   AU   AU   AUñ   AUĒ   AUs   AUT   AU5   AU   AU   AU   AUʹ   AU˚   AU{   AU\   AU=   AU   AU   AU   AU   AUҢ   AUӃ   AUd   AUE   AU&   AU   AU   AU   AU٪   AUڋ   AUl   AUM   AU.   AU   AU   AU   AU   AU   AUt   AUU   AU6   AU   AU   AU   AU   AU|   AU]   AU>   AU   AU    AU   AU   AU   AU   AUe   AUF   AU'   AU   AU   AU   AU   AU   AUm   AUN   AU/   AU   AU   AU   AU   AU   AUu   AV V   AV7   AV   AV   AV   AV   AV   AV}   AV^   AV?   AV	    AV
   AV
   AV   AV   AV
   AVf   AVG   AV(   AV	   AV   AV   AV   AV   AVn   AVO   AV0   AV   AV   AV   AV   AV   AVv   AVW   AV8   AV   AV   AV    AV!   AV"   AV#~   AV$_   AV%@   AV&!   AV'   AV'   AV(   AV)   AV*   AV+g   AV,H   AV-)   AV.
   AV.   AV/   AV0   AV1   AV2o   AV3P   AV41   AV5   AV5   AV6   AV7   AV8   AV9w   AV:X   AV;9   AV<   AV<   AV=   AV>   AV?   AV@   AVA`   AVBA   AVC"   AVD   AVD   AVE   AVF   AVG   AVHh   AVII   AVJ*   AVK   AVK   AVL   AVM   AVN   AVOp   AVPQ   AVQ2   AVR   AVR   AVS   AVT   AVU   AVVx   AVWY   AVX:   AVY   AVY   AVZ   AV[   AV\   AV]   AV^a   AV_B   AV`#   AVa   AVa   AVb   AVc   AVd   AVei   AVfJ   AVg+   AVh   AVh   AVi   AVj   AVk   AVlq   AVmR   AVn3   AVo   AVo   AVp   AVq   AVr   AVsy   AVtZ   AVu;   AVv   AVv   AVw   AVx   AVy   AVz   AV{b   AV|C   AV}$   AV~   AV~   AV   AV   AV   AVj   AVK   AV,   AV
   AV   AV   AV   AV   AVr   AVS   AV4   AV   AV   AV   AV   AV   AVz   AV[   AV<   AV   AV   AV   AV   AV   AV   AVc   AVD   AV%   AV   AV   AV   AV   AV   AVk   AVL   AV-   AV   AV   AV   AV   AV   AVs   AVT   AV5   AV   AV   AV   AV   AV   AV{   AV\   AV=   AV   AV   AV   AV   AV   AV   AVd   AVE   AV&   AV   AV   AV   AV   AV   AVl   AVM   AV.   AV   AV   AV   AV   AV   AVt   AVU   AV6   AV   AV   AV   AVȺ   AVɛ   AV|   AV]   AV>   AV   AV    AV   AV   AVУ   AVф   AVe   AVF   AV'   AV   AV   AV   AV׫   AV،   AVm   AVN   AV/   AV   AV   AV   AV޳   AVߔ   AVu   AVV   AV7   AV   AV   AV   AV   AV   AV}   AV^   AV?   AV    AV   AV   AV   AV   AV   AVf   AVG   AV(   AV	   AV   AV   AV   AV   AVn   AVO   AV0   AV   AV   AV   AV   AV   AVv   AVW   AV8   AW    AW    AW   AW   AW   AW~   AW_   AW@   AW!   AW   AW   AW	   AW
   AW   AWg   AW
H   AW)   AW
   AW   AW   AW   AW   AWo   AWP   AW1   AW   AW   AW   AW   AW   AWw   AWX   AW9   AW   AW   AW   AW   AW    AW!   AW"`   AW#A   AW$"   AW%   AW%   AW&   AW'   AW(   AW)h   AW*I   AW+*   AW,   AW,   AW-   AW.   AW/   AW0p   AW1Q   AW22   AW3   AW3   AW4   AW5   AW6   AW7x   AW8Y   AW9:   AW:   AW:   AW;   AW<   AW=   AW>   AW?a   AW@B   AWA#   AWB   AWB   AWC   AWD   AWE   AWFi   AWGJ   AWH+   AWI   AWI   AWJ   AWK   AWL   AWMq   AWNR   AWO3   AWP   AWP   AWQ   AWR   AWS   AWTy   AWUZ   AWV;   AWW   AWW   AWX   AWY   AWZ   AW[   AW\b   AW]C   AW^$   AW_   AW_   AW`   AWa   AWb   AWcj   AWdK   AWe,   AWf
   AWf   AWg   AWh   AWi   AWjr   AWkS   AWl4   AWm   AWm   AWn   AWo   AWp   AWqz   AWr[   AWs<   AWt   AWt   AWu   AWv   AWw   AWx   AWyc   AWzD   AW{%   AW|   AW|   AW}   AW~   AW   AWk   AWL   AW-   AW   AW   AW   AW   AW   AWs   AWT   AW5   AW   AW   AW   AW   AW   AW{   AW\   AW=   AW   AW   AW   AW   AW   AW   AWd   AWE   AW&   AW   AW   AW   AW   AW   AWl   AWM   AW.   AW   AW   AW   AW   AW   AWt   AWU   AW6   AW   AW   AW   AW   AW   AW|   AW]   AW>   AW   AW    AW   AW   AW   AW   AWe   AWF   AW'   AW   AW   AW   AW   AW   AWm   AWN   AW/   AW   AW   AW   AW   AW   AWu   AWV   AW7   AW   AW   AW   AWƻ   AWǜ   AW}   AW^   AW?   AW    AW   AW   AW   AWΤ   AWυ   AWf   AWG   AW(   AW	   AW   AW   AWլ   AW֍   AWn   AWO   AW0   AW   AW   AW   AWܴ   AWݕ   AWv   AWW   AW8   AW   AW   AW   AW   AW   AW~   AW_   AW@   AW!   AW   AW   AW   AW   AW   AWg   AWH   AW)   AW
   AW   AW   AW   AW   AWo   AWP   AW1   AW   AW   AW   AW   AW   AWw   AWX   AW9   AW   AW   AW   AX    AX   AX   AX`   AXA   AX"   AX   AX   AX   AX   AX	   AX
h   AXI   AX*   AX
   AX
   AX   AX   AX   AXp   AXQ   AX2   AX   AX   AX   AX   AX   AXx   AXY   AX:   AX   AX   AX   AX   AX   AX   AX a   AX!B   AX"#   AX#   AX#   AX$   AX%   AX&   AX'i   AX(J   AX)+   AX*   AX*   AX+   AX,   AX-   AX.q   AX/R   AX03   AX1   AX1   AX2   AX3   AX4   AX5y   AX6Z   AX7;   AX8   AX8   AX9   AX:   AX;   AX<   AX=b   AX>C   AX?$   AX@   AX@   AXA   AXB   AXC   AXDj   AXEK   AXF,   AXG
   AXG   AXH   AXI   AXJ   AXKr   AXLS   AXM4   AXN   AXN   AXO   AXP   AXQ   AXRz   AXS[   AXT<   AXU   AXU   AXV   AXW   AXX   AXY   AXZc   AX[D   AX\%   AX]   AX]   AX^   AX_   AX`   AXak   AXbL   AXc-   AXd   AXd   AXe   AXf   AXg   AXhs   AXiT   AXj5   AXk   AXk   AXl   AXm   AXn   AXo{   AXp\   AXq=   AXr   AXr   AXs   AXt   AXu   AXv   AXwd   AXxE   AXy&   AXz   AXz   AX{   AX|   AX}   AX~l   AXM   AX.   AX   AX   AX   AX   AX   AXt   AXU   AX   AX   AX   AX   AX   AX|   AX]   AX>   AX   AX    AX   AX   AX   AX   AXe   AXF   AX'   AX   AX   AX   AX   AX   AXm   AXN   AX/   AX   AX   AX   AX   AX   AXu   AXV   AX7   AX   AX   AX   AX   AX}   AX^   AX?   AX    AX   AX   AX   AX   AX   AXf   AXG   AX(   AX	   AX   AX   AX   AX   AXn   AXO   AX0   AX   AX   AX   AX   AX   AXv   AXW   AX8   AX   AX   AX   AXļ   AXŝ   AX~   AX_   AX@   AX!   AX   AX   AX   AX̥   AX͆   AXg   AXH   AX)   AX
   AX   AX   AXӭ   AXԎ   AXo   AXP   AX1   AX   AX   AX   AXڵ   AXۖ   AXw   AXX   AX9   AX   AX   AX   AX   AX   AX   AX`   AXA   AX"   AX   AX   AX   AX   AX   AXh   AXI   AX*   AX   AX   AX   AX   AX   AXp   AXQ   AX2   AX   AX   AX   AX   AX   AXx   AXY   AX:   AX   AX   AX   AX   AY    AYa   AYB   AY#   AY   AY   AY   AY   AY   AYi   AY	J   AY
+   AY   AY   AY   AY
   AY   AYq   AYR   AY3   AY   AY   AY   AY   AY   AYy   AYZ   AY;   AY   AY   AY   AY   AY   AY   AYb   AYC   AY $   AY!   AY!   AY"   AY#   AY$   AY%j   AY&K   AY',   AY(
   AY)   AY*   AY+   AY,r   AY-S   AY.4   AY/   AY/   AY0   AY1   AY2   AY3z   AY4[   AY5<   AY6   AY6   AY7   AY8   AY9   AY:   AY;c   AY<D   AY=%   AY>   AY>   AY?   AY@   AYA   AYBk   AYCL   AYD-   AYE   AYE   AYF   AYG   AYH   AYJT   AYK5   AYL   AYL   AYM   AYN   AYO   AYP{   AYQ\   AYR=   AYS   AYS   AYT   AYU   AYV   AYW   AYXd   AYYE   AYZ&   AY[   AY[   AY\   AY]   AY^   AY_l   AY`M   AYa.   AYb   AYb   AYc   AYd   AYe   AYft   AYgU   AYh6   AYi   AYi   AYj   AYk   AYl   AYm|   AYn]   AYo>   AYp   AYq    AYq   AYr   AYs   AYt   AYue   AYvF   AYw'   AYx   AYx   AYy   AYz   AY{   AY|m   AY}N   AY~/   AY   AY   AY   AY   AY   AYu   AYV   AY7   AY   AY   AY   AY   AY   AY}   AY^   AY?   AY    AY   AY   AY   AY   AY   AYf   AYG   AY(   AY	   AY   AY   AY   AY   AYn   AYO   AY0   AY   AY   AY   AY   AY   AYv   AYW   AY8   AY   AY   AY   AY   AY   AY~   AY_   AY@   AY!   AY   AY   AY   AY   AY   AYg   AYH   AY)   AY
   AY   AY   AY   AY   AYo   AY1   AY   AY   AY   AY   AY   AYX   AY9   AY   AY   AY   AY½   AYÞ   AY   AY`   AY"   AY   AY   AY   AYʦ   AYˇ   AYh   AYI   AY*   AY   AY   AY   AYѮ   AYҏ   AYp   AYQ   AY2   AY   AY   AY   AYٗ   AYx   AYY   AY:   AY   AY   AY   AY   AY   AYa   AYB   AY#   AY   AY   AY   AY   AY   AYi   AYJ   AY+   AY   AY   AY   AY   AY   AYq   AYR   AY3   AY   AY   AY   AY   AY   AYZ   AY;   AY   AY   AY   AY   AY   AY   AYb   AZ C   AZ$   AZ   AZ   AZ   AZ   AZ   AZj   AZK   AZ,   AZ	
   AZ	   AZ
   AZ   AZ   AZ
r   AZS   AZ4   AZ   AZ   AZ   AZ   AZ   AZz   AZ[   AZ<   AZ   AZ   AZ   AZ   AZ   AZ   AZc   AZD   AZ%   AZ   AZ   AZ!   AZ"   AZ#k   AZ$L   AZ%-   AZ&   AZ&   AZ'   AZ(   AZ)   AZ*s   AZ+T   AZ,5   AZ-   AZ-   AZ.   AZ/   AZ0   AZ1{   AZ2\   AZ3=   AZ4   AZ4   AZ5   AZ6   AZ7   AZ8   AZ9d   AZ:E   AZ;&   AZ<   AZ<   AZ=   AZ>   AZ?   AZ@l   AZAM   AZB.   AZC   AZC   AZD   AZE   AZF   AZGt   AZHU   AZI6   AZJ   AZJ   AZK   AZL   AZM   AZN|   AZO]   AZP>   AZQ   AZR   AZS   AZT   AZU   AZVe   AZWF   AZX'   AZY   AZY   AZZ   AZ[   AZ\   AZ]m   AZ^N   AZ_/   AZ`   AZ`   AZa   AZb   AZc   AZdu   AZeV   AZf7   AZg   AZg   AZh   AZi   AZj   AZk}   AZl^   AZm?   AZn    AZo   AZo   AZp   AZq   AZr   AZsf   AZtG   AZu(   AZv	   AZv   AZw   AZx   AZy   AZzn   AZ{O   AZ}   AZ}   AZ~   AZ   AZ   AZv   AZW   AZ8   AZ   AZ   AZ   AZ   AZ   AZ~   AZ_   AZ@   AZ!   AZ   AZ   AZ   AZ   AZ   AZg   AZH   AZ)   AZ
   AZ   AZ   AZ   AZ   AZo   AZP   AZ1   AZ   AZ   AZ   AZ   AZ   AZw   AZX   AZ9   AZ   AZ   AZ   AZ   AZ   AZ   AZ`   AZA   AZ"   AZ   AZ   AZ   AZ   AZ   AZh   AZI   AZ*   AZ   AZ   AZ   AZ   AZ   AZp   AZQ   AZ2   AZ   AZ   AZ   AZ   AZ   AZx   AZY   AZ:   AZ   AZ   AZ   AZ   AZ   AZ   AZa   AZB   AZ#   AZ   AZ   AZ   AZȧ   AZɈ   AZi   AZJ   AZ+   AZ   AZ   AZ   AZϯ   AZА   AZq   AZR   AZ3   AZ   AZ   AZַ   AZט   AZy   AZZ   AZ;   AZ   AZ   AZ   AZݿ   AZޠ   AZ߁   AZb   AZC   AZ$   AZ   AZ   AZ   AZ   AZ   AZj   AZK   AZ,   AZ
   AZ   AZ   AZ   AZ   AZr   AZS   AZ4   AZ   AZ   AZ   AZ   AZ   AZz   AZ[   AZ<   AZ   AZ   AZ   AZ   AZ   AZ   AZc   AZD   AZ%   A[    A[    A[   A[   A[   A[k   A[L   A[-   A[   A[   A[   A[	   A[
   A[s   A[T   A[
5   A[   A[   A[   A[   A[   A[{   A[\   A[=   A[   A[   A[   A[   A[   A[   A[d   A[E   A[&   A[   A[   A[   A[   A[    A[!l   A["M   A[#.   A[$   A[$   A[%   A[&   A['   A[)U   A[*6   A[+   A[+   A[,   A[-   A[.   A[/|   A[0]   A[1>   A[2   A[3    A[3   A[4   A[5   A[6   A[7e   A[8F   A[9'   A[:   A[:   A[;   A[<   A[=   A[>m   A[?N   A[@/   A[A   A[A   A[B   A[C   A[D   A[Eu   A[FV   A[G7   A[H   A[H   A[I   A[J   A[K   A[L}   A[M^   A[N?   A[O    A[P   A[P   A[Q   A[R   A[S   A[Tf   A[UG   A[V(   A[W	   A[W   A[X   A[Y   A[Z   A[[n   A[\O   A[]0   A[^   A[^   A[_   A[`   A[a   A[bv   A[cW   A[d8   A[e   A[e   A[f   A[g   A[h   A[i~   A[j_   A[k@   A[l!   A[m   A[m   A[n   A[o   A[p   A[qg   A[rH   A[s)   A[t
   A[t   A[u   A[v   A[w   A[xo   A[yP   A[z1   A[{   A[{   A[}   A[~   A[w   A[X   A[9   A[   A[   A[   A[   A[   A[   A[`   A[A   A["   A[   A[   A[   A[   A[   A[h   A[I   A[*   A[   A[   A[   A[   A[   A[p   A[Q   A[2   A[   A[   A[   A[   A[   A[x   A[Y   A[:   A[   A[   A[   A[   A[   A[   A[a   A[B   A[#   A[   A[   A[   A[   A[   A[i   A[J   A[+   A[   A[   A[   A[   A[   A[q   A[R   A[3   A[   A[   A[   A[   A[   A[y   A[Z   A[;   A[   A[   A[   A[   A[   A[   A[b   A[C   A[$   A[   A[   A[   A[ƨ   A[ǉ   A[j   A[K   A[,   A[
   A[   A[   A[Ͱ   A[Α   A[r   A[S   A[4   A[   A[   A[   A[Ը   A[ՙ   A[z   A[[   A[<   A[   A[   A[   A[   A[ܡ   A[݂   A[c   A[D   A[%   A[   A[   A[   A[   A[   A[k   A[L   A[-   A[   A[   A[   A[   A[   A[s   A[T   A[5   A[   A[   A[   A[   A[   A[{   A[\   A[=   A[   A[   A[   A[   A[   A[   A[d   A[E   A[&   A[   A[   A[   A\    A\   A\l   A\M   A\.   A\   A\   A\   A\   A\	t   A\
U   A\6   A\   A\   A\
   A\   A\   A\|   A\]   A\>   A\   A\    A\   A\   A\   A\   A\e   A\F   A\'   A\   A\   A\   A\   A\   A\m   A\ N   A\!/   A\"   A\"   A\#   A\$   A\%   A\&u   A\'V   A\(7   A\)   A\)   A\*   A\+   A\,   A\-}   A\.^   A\/?   A\0    A\1   A\1   A\2   A\3   A\4   A\5f   A\6G   A\7(   A\8	   A\8   A\9   A\:   A\;   A\<n   A\=O   A\>0   A\?   A\?   A\@   A\A   A\B   A\Cv   A\DW   A\E8   A\F   A\F   A\G   A\H   A\I   A\J~   A\K_   A\L@   A\M!   A\N   A\N   A\P   A\Q   A\Rg   A\SH   A\T)   A\U
   A\U   A\V   A\W   A\X   A\Yo   A\ZP   A\[1   A\\   A\\   A\]   A\^   A\_   A\`w   A\aX   A\b9   A\c   A\c   A\d   A\e   A\f   A\g   A\h`   A\iA   A\j"   A\k   A\k   A\l   A\m   A\n   A\oh   A\pI   A\q*   A\r   A\r   A\s   A\t   A\u   A\vp   A\wQ   A\x2   A\y   A\y   A\z   A\{   A\|   A\}x   A\~Y   A\:   A\   A\   A\   A\   A\   A\   A\a   A\B   A\#   A\   A\   A\   A\   A\   A\i   A\J   A\+   A\   A\   A\   A\   A\   A\q   A\R   A\3   A\   A\   A\   A\   A\   A\y   A\Z   A\;   A\   A\   A\   A\   A\   A\   A\b   A\C   A\$   A\   A\   A\   A\   A\   A\j   A\K   A\,   A\
   A\   A\   A\   A\   A\r   A\S   A\4   A\   A\   A\   A\   A\   A\z   A\[   A\<   A\   A\   A\   A\   A\   A\   A\c   A\D   A\%   A\   A\   A\   A\ĩ   A\Ŋ   A\k   A\L   A\-   A\   A\   A\   A\˱   A\̒   A\s   A\T   A\5   A\   A\   A\   A\ҹ   A\Ӛ   A\{   A\\   A\=   A\   A\   A\   A\   A\ڢ   A\ۃ   A\d   A\E   A\&   A\   A\   A\   A\   A\   A\l   A\M   A\.   A\   A\   A\   A\   A\   A\t   A\U   A\6   A\   A\   A\   A\   A\   A\|   A\]   A\>   A\   A\    A\   A\   A\   A\   A\e   A\F   A\'   A\   A\   A\   A\   A\   A] m   A]N   A]/   A]   A]   A]   A]   A]   A]u   A]V   A]	7   A]
   A]
   A]   A]   A]
   A]}   A]^   A]?   A]    A]   A]   A]   A]   A]   A]f   A]G   A](   A]	   A]   A]   A]   A]   A]n   A]O   A]0   A]    A]    A]!   A]"   A]#   A]$v   A]%W   A]&8   A]'   A](   A])   A]*   A]+~   A],_   A]-@   A].!   A]/   A]/   A]0   A]1   A]2   A]3g   A]4H   A]5)   A]6
   A]6   A]7   A]8   A]9   A]:o   A];P   A]<1   A]=   A]=   A]>   A]?   A]@   A]Aw   A]BX   A]C9   A]D   A]D   A]E   A]F   A]G   A]H   A]I`   A]JA   A]K"   A]L   A]L   A]M   A]N   A]O   A]Ph   A]QI   A]R*   A]S   A]S   A]T   A]U   A]V   A]Wp   A]XQ   A]Y2   A]Z   A]Z   A][   A]\   A]]   A]^x   A]_Y   A]`:   A]a   A]a   A]b   A]c   A]d   A]e   A]fa   A]gB   A]h#   A]i   A]i   A]j   A]k   A]l   A]mi   A]nJ   A]o+   A]p   A]p   A]q   A]r   A]s   A]tq   A]uR   A]v3   A]w   A]w   A]x   A]y   A]z   A]{y   A]|Z   A]};   A]~   A]~   A]   A]   A]   A]   A]b   A]C   A]$   A]   A]   A]   A]   A]   A]j   A]K   A],   A]
   A]   A]   A]   A]   A]r   A]S   A]4   A]   A]   A]   A]   A]   A]z   A][   A]<   A]   A]   A]   A]   A]   A]   A]c   A]D   A]%   A]   A]   A]   A]   A]   A]k   A]L   A]-   A]   A]   A]   A]   A]   A]s   A]T   A]5   A]   A]   A]   A]   A]   A]{   A]\   A]=   A]   A]   A]   A]   A]   A]   A]d   A]E   A]&   A]   A]   A]   A]ª   A]Ë   A]l   A]M   A].   A]   A]   A]   A]ɲ   A]t   A]U   A]6   A]   A]   A]   A]к   A]ћ   A]|   A]]   A]>   A]   A]   A]   A]أ   A]ل   A]e   A]F   A]'   A]   A]   A]   A]߫   A]   A]m   A]N   A]/   A]   A]   A]   A]   A]   A]u   A]V   A]7   A]   A]   A]   A]   A]   A]}   A]^   A]?   A]    A]   A]   A]   A]   A]   A]f   A]G   A](   A]	   A]   A]   A]   A]   A]n   A]O   A^ 0   A^   A^   A^   A^   A^   A^v   A^W   A^8   A^   A^   A^	   A^   A^~   A^
_   A^@   A^!   A^   A^   A^   A^   A^   A^g   A^H   A^)   A^
   A^   A^   A^   A^   A^o   A^1   A^   A^   A^   A^    A^!   A^"w   A^#X   A^$9   A^%   A^%   A^&   A^'   A^(   A^)   A^*`   A^+A   A^,"   A^-   A^-   A^.   A^/   A^0   A^1h   A^2I   A^3*   A^4   A^4   A^5   A^6   A^7   A^8p   A^9Q   A^:2   A^;   A^;   A^<   A^=   A^>   A^?x   A^@Y   A^A:   A^B   A^B   A^C   A^D   A^E   A^F   A^Ga   A^HB   A^I#   A^J   A^J   A^K   A^L   A^M   A^Ni   A^OJ   A^P+   A^Q   A^Q   A^R   A^S   A^T   A^Uq   A^VR   A^W3   A^X   A^X   A^Y   A^Z   A^[   A^\y   A^]Z   A^^;   A^_   A^_   A^`   A^a   A^b   A^c   A^db   A^eC   A^f$   A^g   A^g   A^h   A^j   A^kj   A^lK   A^m,   A^n
   A^n   A^o   A^p   A^q   A^rr   A^sS   A^t4   A^u   A^u   A^v   A^w   A^x   A^yz   A^z[   A^{<   A^|   A^|   A^}   A^~   A^   A^c   A^D   A^%   A^   A^   A^   A^   A^   A^k   A^L   A^-   A^   A^   A^   A^   A^   A^s   A^T   A^5   A^   A^   A^   A^   A^   A^{   A^\   A^=   A^   A^   A^   A^   A^   A^   A^d   A^E   A^&   A^   A^   A^   A^   A^   A^l   A^M   A^.   A^   A^   A^   A^   A^   A^t   A^U   A^6   A^   A^   A^   A^   A^   A^|   A^]   A^>   A^   A^    A^   A^   A^   A^   A^e   A^F   A^'   A^   A^   A^   A^   A^m   A^N   A^/   A^   A^   A^   A^ǳ   A^Ȕ   A^u   A^V   A^7   A^   A^   A^   A^λ   A^Ϝ   A^}   A^^   A^?   A^    A^   A^   A^   A^֤   A^ׅ   A^f   A^G   A^(   A^	   A^   A^   A^ݬ   A^ލ   A^n   A^O   A^0   A^   A^   A^   A^   A^   A^v   A^W   A^8   A^   A^   A^   A^   A^   A^~   A^_   A^@   A^!   A^   A^   A^   A^   A^g   A^H   A^)   A^
   A^   A^   A^   A^   A^o   A^P   A^1   A^   A^   A_    A_   A_   A_w   A_X   A_9   A_   A_   A_   A_   A_	   A_
   A_`   A_A   A_
"   A_   A_   A_   A_   A_   A_h   A_I   A_*   A_   A_   A_   A_   A_   A_p   A_Q   A_2   A_   A_   A_   A_   A_   A_ x   A_!Y   A_":   A_#   A_#   A_$   A_%   A_&   A_'   A_(a   A_)B   A_*#   A_+   A_+   A_,   A_-   A_.   A_/i   A_0J   A_1+   A_2   A_2   A_4   A_5   A_6q   A_7R   A_83   A_9   A_9   A_:   A_;   A_<   A_=y   A_>Z   A_?;   A_@   A_@   A_A   A_B   A_C   A_D   A_Eb   A_FC   A_G$   A_H   A_H   A_I   A_J   A_K   A_Lj   A_MK   A_N,   A_O
   A_O   A_P   A_Q   A_R   A_Sr   A_TS   A_U4   A_V   A_V   A_W   A_X   A_Y   A_Zz   A_[[   A_\<   A_]   A_]   A_^   A__   A_`   A_a   A_bc   A_cD   A_d%   A_e   A_e   A_f   A_g   A_h   A_ik   A_jL   A_k-   A_l   A_l   A_m   A_n   A_o   A_ps   A_qT   A_r5   A_s   A_s   A_t   A_u   A_v   A_w{   A_x\   A_y=   A_z   A_z   A_{   A_|   A_}   A_~   A_d   A_E   A_&   A_   A_   A_   A_   A_   A_l   A_M   A_.   A_   A_   A_   A_   A_   A_t   A_U   A_6   A_   A_   A_   A_   A_   A_|   A_]   A_>   A_   A_    A_   A_   A_   A_   A_e   A_F   A_'   A_   A_   A_   A_   A_   A_m   A_N   A_/   A_   A_   A_   A_   A_   A_u   A_V   A_7   A_   A_   A_   A_   A_   A_}   A_^   A_?   A_    A_   A_   A_   A_   A_f   A_G   A_(   A_	   A_   A_   A_   A_   A_n   A_O   A_0   A_   A_   A_   A_Ŵ   A_ƕ   A_v   A_W   A_8   A_   A_   A_   A_̼   A_͝   A_~   A__   A_@   A_!   A_   A_   A_   A_ԥ   A_Ն   A_g   A_H   A_)   A_
   A_   A_   A_ۭ   A_܎   A_o   A_P   A_1   A_   A_   A_   A_   A_   A_w   A_X   A_9   A_   A_   A_   A_   A_   A_`   A_A   A_"   A_   A_   A_   A_   A_   A_h   A_I   A_*   A_   A_   A_   A_   A_   A_p   A_Q   A_2   A_   A_   A_   A_   A`    A`x   A`Y   A`:   A`   A`   A`   A`   A`   A`   A`	a   A`
B   A`#   A`   A`   A`
   A`   A`   A`i   A`J   A`+   A`   A`   A`   A`   A`   A`q   A`R   A`3   A`   A`   A`   A`   A`   A`y   A`Z   A` ;   A`!   A`!   A`"   A`#   A`$   A`%   A`&b   A`'C   A`($   A`)   A`)   A`*   A`+   A`,   A`-j   A`.K   A`/,   A`0
   A`0   A`2   A`3   A`4r   A`5S   A`64   A`7   A`7   A`8   A`9   A`:   A`;z   A`<[   A`=<   A`>   A`>   A`?   A`@   A`A   A`B   A`Cc   A`DD   A`E%   A`F   A`F   A`G   A`H   A`I   A`Jk   A`KL   A`L-   A`M   A`M   A`N   A`O   A`P   A`Qs   A`RT   A`S5   A`T   A`T   A`U   A`V   A`W   A`X{   A`Y\   A`Z=   A`[   A`[   A`\   A`]   A`^   A`_   A``d   A`aE   A`b&   A`c   A`c   A`e   A`f   A`gl   A`hM   A`i.   A`j   A`j   A`k   A`l   A`m   A`nt   A`oU   A`p6   A`q   A`q   A`r   A`s   A`t   A`u|   A`v]   A`w>   A`x   A`y    A`y   A`z   A`{   A`|   A`}e   A`~F   A`'   A`   A`   A`   A`   A`   A`m   A`N   A`/   A`   A`   A`   A`   A`   A`u   A`V   A`7   A`   A`   A`   A`   A`   A`}   A`^   A`?   A`    A`   A`   A`   A`   A`f   A`G   A`(   A`	   A`   A`   A`   A`   A`n   A`O   A`0   A`   A`   A`   A`   A`   A`v   A`W   A`8   A`   A`   A`   A`   A`   A`~   A`_   A`@   A`!   A`   A`   A`   A`   A`   A`g   A`H   A`)   A`
   A`   A`   A`   A`   A`o   A`P   A`1   A`   A`   A`   A`õ   A`Ė   A`w   A`X   A`9   A`   A`   A`   A`ʽ   A`˞   A`   A``   A`A   A`"   A`   A`   A`   A`Ҧ   A`Ӈ   A`h   A`I   A`*   A`   A`   A`   A`ٮ   A`ڏ   A`p   A`Q   A`2   A`   A`   A`   A`   A`   A`x   A`Y   A`:   A`   A`   A`   A`   A`   A`   A`a   A`B   A`#   A`   A`   A`   A`   A`   A`i   A`J   A`+   A`   A`   A`   A`   A`   A`q   A`R   A`3   A`   A`   A`   A`   A`   A`y   Aa Z   Aa;   Aa   Aa   Aa   Aa   Aa   Aa   Aab   AaC   Aa	$   Aa
   Aa
   Aa   Aa
   Aaj   AaK   Aa,   Aa
   Aa   Aa   Aa   Aa   Aar   AaS   Aa4   Aa   Aa   Aa   Aa   Aa   Aaz   Aa[   Aa<   Aa   Aa   Aa    Aa!   Aa"   Aa#   Aa$c   Aa%D   Aa&%   Aa'   Aa'   Aa(   Aa)   Aa*   Aa+k   Aa,L   Aa--   Aa.   Aa.   Aa/   Aa0   Aa1   Aa2s   Aa3T   Aa45   Aa5   Aa5   Aa6   Aa7   Aa8   Aa9{   Aa:\   Aa;=   Aa<   Aa=   Aa>   Aa@   AaAd   AaBE   AaC&   AaD   AaD   AaE   AaF   AaG   AaHl   AaIM   AaJ.   AaK   AaK   AaL   AaM   AaN   AaOt   AaPU   AaQ6   AaR   AaR   AaS   AaT   AaU   AaV|   AaW]   AaX>   AaY   AaZ    AaZ   Aa[   Aa\   Aa^e   Aa_F   Aa`'   Aaa   Aaa   Aab   Aac   Aad   Aaem   AafN   Aag/   Aah   Aah   Aai   Aaj   Aak   Aalu   AamV   Aan7   Aao   Aao   Aap   Aaq   Aar   Aas}   Aau?   Aav    Aaw   Aaw   Aax   Aay   Aaz   Aa{f   Aa|G   Aa}(   Aa~	   Aa~   Aa   Aa   Aa   Aan   AaO   Aa0   Aa   Aa   Aa   Aa   Aa   Aav   AaW   Aa8   Aa   Aa   Aa   Aa   Aa   Aa~   Aa_   Aa@   Aa!   Aa   Aa   Aa   Aa   Aa   AaH   Aa)   Aa
   Aa   Aa   Aa   Aao   AaP   Aa1   Aa   Aa   Aa   Aa   Aaw   AaX   Aa9   Aa   Aa   Aa   Aa   Aa   Aa   Aa`   AaA   Aa"   Aa   Aa   Aa   Aa   Aa   Aah   AaI   Aa*   Aa   Aa   Aa   Aa   Aap   AaQ   Aa2   Aa   Aa   Aa   Aa   Aa   Aax   AaY   Aa   Aa   Aa   AaȾ   Aaɟ   Aaʀ   Aaa   AaB   Aa#   Aa   Aa   Aa   AaЧ   Aaш   Aai   AaJ   Aa+   Aa   Aa   Aa   Aaׯ   Aaؐ   Aaq   AaR   Aa3   Aa   Aa   Aa   Aa޷   Aaߘ   Aay   AaZ   Aa;   Aa   Aa   Aa   Aa   Aa   Aa   Aab   AaC   Aa$   Aa   Aa   Aa   Aa   Aa   Aaj   AaK   Aa,   Aa
   Aa   Aa   Aa   Aa   Aar   AaS   Aa4   Aa   Aa   Aa   Aa   Aa   Aaz   Aa[   Aa<   Ab    Ab    Ab   Ab   Ab   Ab   Abc   AbD   Ab%   Ab   Ab   Ab	   Ab
   Ab   Abk   Ab
L   Ab-   Ab   Ab   Ab   Ab   Ab   Abs   AbT   Ab5   Ab   Ab   Ab   Ab   Ab   Ab{   Ab\   Ab=   Ab   Ab   Ab   Ab   Ab!   Ab"d   Ab#E   Ab$&   Ab%   Ab%   Ab&   Ab'   Ab(   Ab*M   Ab+.   Ab,   Ab,   Ab-   Ab.   Ab/   Ab0t   Ab1U   Ab26   Ab3   Ab3   Ab4   Ab5   Ab6   Ab7|   Ab8]   Ab9>   Ab:   Ab;    Ab;   Ab<   Ab=   Ab>   Ab?e   Ab@F   AbA'   AbB   AbB   AbC   AbD   AbE   AbFm   AbGN   AbH/   AbI   AbI   AbK   AbL   AbMu   AbNV   AbO7   AbP   AbP   AbQ   AbR   AbS   AbT}   AbU^   AbV?   AbW    AbX   AbX   AbY   AbZ   Ab[   Ab\f   Ab]G   Ab^(   Ab_	   Ab_   Ab`   Aba   Abb   Abcn   AbdO   Abe0   Abf   Abf   Abg   Abh   Abi   Abjv   AbkW   Abl8   Abm   Abm   Abn   Abo   Abp   Abq~   Abr_   Abs@   Abt!   Abu   Abu   Abv   Abw   Abx   Abyg   AbzH   Ab{)   Ab|
   Ab|   Ab}   Ab~   Ab   Abo   AbP   Ab1   Ab   Ab   Ab   Ab   Ab   Abw   AbX   Ab9   Ab   Ab   Ab   Ab   Ab   Ab   Ab`   AbA   Ab"   Ab   Ab   Ab   Ab   Ab   Abh   AbI   Ab*   Ab   Ab   Ab   Ab   Ab   Abp   AbQ   Ab2   Ab   Ab   Ab   Ab   Ab   Abx   AbY   Ab:   Ab   Ab   Ab   Ab   Ab   Ab   Aba   AbB   Ab#   Ab   Ab   Ab   Ab   Ab   Abi   AbJ   Ab+   Ab   Ab   Ab   Ab   Abq   AbR   Ab3   Ab   Ab   Ab   Ab   Ab   Aby   AbZ   Ab;   Ab   Ab   Ab   Abƿ   AbǠ   Abȁ   Abb   AbC   Ab$   Ab   Ab   Ab   AbΨ   Abω   Abj   AbK   Ab,   Ab
   Ab   Ab   Abհ   Ab֑   Abr   AbS   Ab4   Ab   Ab   Abܸ   Abݙ   Abz   Ab[   Ab<   Ab   Ab   Ab   Ab   Ab   Ab   Abc   AbD   Ab%   Ab   Ab   Ab   Ab   Ab   Abk   AbL   Ab-   Ab   Ab   Ab   Ab   Ab   Abs   AbT   Ab5   Ab   Ab   Ab   Ab   Ab{   Ab\   Ab=   Ab   Ab   Ab   Ac    Ac   Ac   Acd   AcE   Ac&   Ac   Ac   Ac   Ac   Ac	   Ac
l   AcM   Ac.   Ac
   Ac
   Ac   Ac   Ac   Act   AcU   Ac6   Ac   Ac   Ac   Ac   Ac   Ac|   Ac]   Ac>   Ac   Ac    Ac   Ac   Ac   Ac   Ac e   Ac!F   Ac"'   Ac#   Ac#   Ac$   Ac%   Ac&   Ac'm   Ac(N   Ac)/   Ac*   Ac*   Ac+   Ac,   Ac-   Ac.u   Ac/V   Ac07   Ac1   Ac1   Ac2   Ac3   Ac4   Ac5}   Ac6^   Ac7?   Ac8    Ac9   Ac9   Ac:   Ac;   Ac<   Ac=f   Ac>G   Ac?(   Ac@	   Ac@   AcA   AcB   AcC   AcDn   AcEO   AcF0   AcG   AcG   AcH   AcI   AcJ   AcKv   AcLW   AcM8   AcN   AcN   AcO   AcP   AcQ   AcR~   AcS_   AcT@   AcU!   AcV   AcV   AcW   AcX   AcY   AcZg   Ac[H   Ac\)   Ac]
   Ac]   Ac^   Ac_   Ac`   Acao   AcbP   Acc1   Acd   Acd   Ace   Acf   Acg   Achw   AciX   Acj9   Ack   Ack   Acl   Acm   Acn   Aco   Acp`   AcqA   Acr"   Acs   Acs   Act   Acu   Acv   Acwh   AcxI   Acy*   Acz   Acz   Ac{   Ac|   Ac}   Ac~p   AcQ   Ac2   Ac   Ac   Ac   Ac   Ac   Acx   AcY   Ac:   Ac   Ac   Ac   Ac   Ac   Ac   Aca   AcB   Ac#   Ac   Ac   Ac   Ac   Ac   Aci   AcJ   Ac+   Ac   Ac   Ac   Ac   Ac   Acq   AcR   Ac3   Ac   Ac   Ac   Ac   Ac   Acy   AcZ   Ac;   Ac   Ac   Ac   Ac   Ac   Ac   Acb   AcC   Ac$   Ac   Ac   Ac   Ac   Ac   Acj   AcK   Ac,   Ac
   Ac   Ac   Ac   Ac   Acr   AcS   Ac4   Ac   Ac   Ac   Ac   Ac   Acz   Ac[   Ac<   Ac   Ac   Ac   Ac   Acš   AcƂ   Acc   AcD   Ac%   Ac   Ac   Ac   Ac̩   Ac͊   Ack   AcL   Ac-   Ac   Ac   Acӱ   AcԒ   Acs   AcT   Ac5   Ac   Ac   Ac   Acڹ   Acۚ   Ac{   Ac\   Ac=   Ac   Ac   Ac   Ac   Ac   Ac   Acd   AcE   Ac&   Ac   Ac   Ac   Ac   Ac   Acl   AcM   Ac.   Ac   Ac   Ac   Ac   Ac   Act   AcU   Ac6   Ac   Ac   Ac   Ac   Ac   Ac|   Ac]   Ac>   Ac   Ac    Ac   Ac   Ac   Ad    Ade   AdF   Ad'   Ad   Ad   Ad   Ad   Ad   Adm   Ad	N   Ad
/   Ad   Ad   Ad   Ad
   Ad   Adu   AdV   Ad7   Ad   Ad   Ad   Ad   Ad}   Ad^   Ad?   Ad    Ad   Ad   Ad   Ad   Ad   Adf   AdG   Ad (   Ad!	   Ad!   Ad"   Ad#   Ad$   Ad%n   Ad&O   Ad'0   Ad(   Ad(   Ad)   Ad*   Ad+   Ad,v   Ad-W   Ad.8   Ad/   Ad/   Ad0   Ad1   Ad2   Ad3~   Ad4_   Ad5@   Ad6!   Ad7   Ad7   Ad8   Ad9   Ad:   Ad;g   Ad<H   Ad=)   Ad>
   Ad>   Ad?   Ad@   AdA   AdBo   AdCP   AdD1   AdE   AdE   AdF   AdG   AdH   AdIw   AdJX   AdK9   AdL   AdL   AdM   AdN   AdO   AdP   AdQ`   AdRA   AdS"   AdT   AdT   AdU   AdV   AdW   AdXh   AdYI   AdZ*   Ad[   Ad[   Ad\   Ad]   Ad^   Ad_p   Ad`Q   Ada2   Adb   Adb   Adc   Add   Ade   Adfx   AdgY   Adh:   Adi   Adi   Adj   Adk   Adl   Adm   Adna   AdoB   Adp#   Adq   Adq   Adr   Ads   Adt   Adui   AdvJ   Adw+   Adx   Adx   Ady   Adz   Ad{   Ad|q   Ad}R   Ad~3   Ad   Ad   Ad   Ad   Ad   Ady   AdZ   Ad;   Ad   Ad   Ad   Ad   Ad   Ad   Adb   AdC   Ad$   Ad   Ad   Ad   Ad   Ad   Adj   AdK   Ad,   Ad
   Ad   Ad   Ad   Ad   Adr   AdS   Ad4   Ad   Ad   Ad   Ad   Ad   Adz   Ad[   Ad<   Ad   Ad   Ad   Ad   Ad   Adc   AdD   Ad%   Ad   Ad   Ad   Ad   Ad   Adk   AdL   Ad-   Ad   Ad   Ad   Ad   Ad   Ads   AdT   Ad5   Ad   Ad   Ad   Ad   Ad   Ad{   Ad\   Ad=   Ad   Ad   Ad   Ad   Adâ   Adă   Add   AdE   Ad&   Ad   Ad   Ad   Adʪ   Adˋ   Adl   AdM   Ad.   Ad   Ad   Ad   AdѲ   Adғ   Adt   AdU   Ad6   Ad   Ad   Ad   Adغ   Adٛ   Ad|   Ad]   Ad>   Ad   Ad    Ad   Ad   Ad   Ad   Ade   AdF   Ad'   Ad   Ad   Ad   Ad   Ad   Adm   AdN   Ad/   Ad   Ad   Ad   Ad   Ad   Adu   AdV   Ad7   Ad   Ad   Ad   Ad   Ad   Ad}   Ad^   Ad?   Ad    Ad   Ad   Ad   Ad   Ad   Adf   Ae G   Ae(   Ae	   Ae   Ae   Ae   Ae   Aen   AeO   Ae0   Ae	   Ae	   Ae
   Ae   Ae   Ae
v   AeW   Ae8   Ae   Ae   Ae   Ae   Ae   Ae~   Ae_   Ae@   Ae!   Ae   Ae   Ae   Ae   Ae   Aeg   AeH   Ae)   Ae
   Ae   Ae    Ae!   Ae"   Ae#o   Ae$P   Ae%1   Ae&   Ae&   Ae'   Ae(   Ae*w   Ae+X   Ae,9   Ae-   Ae-   Ae.   Ae/   Ae0   Ae1   Ae2`   Ae3A   Ae4"   Ae5   Ae5   Ae6   Ae7   Ae8   Ae9h   Ae:I   Ae;*   Ae<   Ae<   Ae=   Ae>   Ae?   Ae@p   AeAQ   AeB2   AeC   AeC   AeD   AeE   AeF   AeGx   AeHY   AeI:   AeJ   AeK   AeL   AeM   AeN   AeOa   AePB   AeQ#   AeR   AeR   AeS   AeT   AeU   AeVi   AeWJ   AeX+   AeY   AeY   AeZ   Ae[   Ae\   Ae]q   Ae^R   Ae_3   Ae`   Ae`   Aea   Aeb   Aec   Aedy   AeeZ   Aef;   Aeg   Aeg   Aeh   Aei   Aej   Aek   Aelb   AemC   Aen$   Aeo   Aeo   Aep   Aeq   Aer   Aesj   AetK   Aeu,   Aev
   Aev   Aew   Aex   Aey   Aezr   Ae{S   Ae|4   Ae}   Ae}   Ae~   Ae   Ae   Aez   Ae[   Ae<   Ae   Ae   Ae   Ae   Ae   Aec   AeD   Ae%   Ae   Ae   Ae   Ae   Ae   AeL   Ae-   Ae   Ae   Ae   Ae   Ae   Aes   AeT   Ae5   Ae   Ae   Ae   Ae   Ae   Ae{   Ae\   Ae=   Ae   Ae   Ae   Ae   Ae   Ae   Aed   AeE   Ae&   Ae   Ae   Ae   Ae   Ae   Ael   AeM   Ae.   Ae   Ae   Ae   Ae   Ae   Aet   AeU   Ae6   Ae   Ae   Ae   Ae   Ae   Ae|   Ae]   Ae>   Ae   Ae    Ae   Ae   Ae   Aee   AeF   Ae'   Ae   Ae   Ae   Aeȫ   AeɌ   Aem   AeN   Ae/   Ae   Ae   Ae   Aeϳ   AeД   Aeu   AeV   Ae7   Ae   Ae   Ae   Aeֻ   Aeל   Ae}   Ae^   Ae?   Ae    Ae   Ae   Ae   Aeޤ   Ae߅   Aef   AeG   Ae(   Ae	   Ae   Ae   Ae   Ae   Aen   AeO   Ae0   Ae   Ae   Ae   Ae   Ae   Aev   AeW   Ae8   Ae   Ae   Ae   Ae   Ae~   Ae_   Ae@   Ae!   Ae   Ae   Ae   Ae   Ae   Aeg   AeH   Ae)   Af 
   Af    Af   Af   Af   Afo   AfP   Af1   Af   Af   Af   Af	   Afw   AfX   Af
9   Af   Af   Af   Af   Af   Af   Af`   AfA   Af"   Af   Af   Af   Af   Af   Afh   AfI   Af*   Af   Af   Af   Af   Af    Af!p   Af"Q   Af#2   Af$   Af$   Af%   Af&   Af'   Af(x   Af)Y   Af*:   Af+   Af+   Af,   Af-   Af.   Af/   Af0a   Af1B   Af2#   Af3   Af3   Af4   Af5   Af6   Af7i   Af8J   Af9+   Af:   Af:   Af;   Af<   Af=   Af>q   Af?R   Af@3   AfA   AfA   AfB   AfC   AfD   AfEy   AfFZ   AfG;   AfH   AfH   AfI   AfJ   AfK   AfL   AfMb   AfNC   AfO$   AfP   AfP   AfQ   AfR   AfS   AfTj   AfUK   AfV,   AfW
   AfW   AfX   AfY   AfZ   Af[r   Af\S   Af]4   Af^   Af^   Af_   Af`   Afa   Afbz   Afc[   Afd<   Afe   Afe   Aff   Afg   Afh   Afi   Afjc   AfkD   Afl%   Afm   Afm   Afn   Afo   Afp   Afqk   AfrL   Afs-   Aft   Aft   Afu   Afv   Afw   Afxs   AfyT   Afz5   Af{   Af{   Af|   Af}   Af~   Af{   Af\   Af=   Af   Af   Af   Af   Af   Af   Afd   AfE   Af&   Af   Af   Af   Af   Af   Afl   AfM   Af.   Af   Af   Af   Af   Af   Aft   AfU   Af6   Af   Af   Af   Af   Af   Af|   Af]   Af>   Af   Af    Af   Af   Af   Af   Afe   AfF   Af'   Af   Af   Af   Af   Af   Afm   AfN   Af/   Af   Af   Af   Af   Af   Afu   AfV   Af7   Af   Af   Af   Af   Af   Af}   Af^   Af?   Af    Af   Af   Af   Af   Af   Aff   AfG   Af(   Af	   Af   Af   AfƬ   AfǍ   Afn   AfO   Af0   Af   Af   Af   Afʹ   AfΕ   Afv   AfW   Af8   Af   Af   Af   AfԼ   Af՝   Af~   Af_   Af@   Af!   Af   Af   Af   Afܥ   Af݆   Afg   AfH   Af)   Af
   Af   Af   Af   Af   Afo   AfP   Af1   Af   Af   Af   Af   Af   Afw   AfX   Af9   Af   Af   Af   Af   Af   Af   Af`   AfA   Af"   Af   Af   Af   Af   Af   Afh   AfI   Af*   Af   Af   Af   Ag    Ag   Agp   AgQ   Ag2   Ag   Ag   Ag   Ag   Ag   Ag	x   Ag
Y   Ag:   Ag   Ag   Ag
   Ag   Ag   Ag   Aga   AgB   Ag#   Ag   Ag   Ag   Ag   Agi   AgJ   Ag+   Ag   Ag   Ag   Ag   Ag   Agq   Ag R   Ag!3   Ag"   Ag#   Ag$   Ag%   Ag&y   Ag'Z   Ag(;   Ag)   Ag)   Ag*   Ag+   Ag,   Ag-   Ag.b   Ag/C   Ag0$   Ag1   Ag1   Ag2   Ag3   Ag4   Ag5j   Ag6K   Ag7,   Ag8
   Ag8   Ag9   Ag:   Ag;   Ag<r   Ag=S   Ag>4   Ag?   Ag?   Ag@   AgA   AgB   AgCz   AgD[   AgE<   AgF   AgF   AgG   AgH   AgI   AgJ   AgKc   AgLD   AgM%   AgN   AgN   AgO   AgP   AgQ   AgRk   AgSL   AgT-   AgU   AgU   AgV   AgW   AgX   AgYs   AgZT   Ag[5   Ag\   Ag\   Ag]   Ag^   Ag_   Ag`{   Aga\   Agb=   Agc   Agc   Agd   Age   Agf   Agg   Aghd   AgiE   Agj&   Agk   Agk   Agl   Agn   Agol   AgpM   Agq.   Agr   Agr   Ags   Agt   Agu   Agvt   AgwU   Agx6   Agy   Agy   Agz   Ag{   Ag|   Ag~]   Ag>   Ag   Ag    Ag   Ag   Ag   Ag   Age   AgF   Ag'   Ag   Ag   Ag   Ag   Ag   Agm   AgN   Ag/   Ag   Ag   Ag   Ag   Ag   Agu   AgV   Ag7   Ag   Ag   Ag   Ag   Ag   Ag}   Ag^   Ag?   Ag    Ag   Ag   Ag   Ag   Ag   Agf   AgG   Ag(   Ag	   Ag   Ag   Ag   Ag   Agn   AgO   Ag   Ag   Ag   Ag   Ag   Agv   AgW   Ag8   Ag   Ag   Ag   Ag   Ag   Ag~   Ag_   Ag@   Ag!   Ag   Ag   Ag   Ag   Ag   Agg   AgH   Ag)   Ag
   Ag   Ag   Agĭ   AgŎ   Ago   AgP   Ag1   Ag   Ag   Ag   Ag˵   Ag̖   Agw   AgX   Ag9   Ag   Ag   Ag   Agҽ   AgӞ   Ag   Ag`   AgA   Ag"   Ag   Ag   Ag   Agڦ   Agh   AgI   Ag*   Ag   Ag   Ag   Ag   Ag   Agp   AgQ   Ag2   Ag   Ag   Ag   Ag   Ag   Agx   AgY   Ag:   Ag   Ag   Ag   Ag   Ag   Ag   Aga   AgB   Ag#   Ag   Ag   Ag   Ag   Ag   Agi   AgJ   Ag+   Ag   Ag   Ag   Ag   Ag   Ah q   AhR   Ah3   Ah   Ah   Ah   Ah   Ah   Ahy   AhZ   Ah	;   Ah
   Ah
   Ah   Ah   Ah
   Ahb   AhC   Ah$   Ah   Ah   Ah   Ah   Ah   Ahj   AhK   Ah,   Ah
   Ah   Ah   Ah   Ah   Ahr   AhS   Ah4   Ah    Ah    Ah!   Ah"   Ah#   Ah$z   Ah%[   Ah&<   Ah'   Ah'   Ah(   Ah)   Ah*   Ah+   Ah,c   Ah-D   Ah.%   Ah/   Ah/   Ah0   Ah1   Ah2   Ah3k   Ah4L   Ah5-   Ah6   Ah6   Ah7   Ah8   Ah9   Ah:s   Ah;T   Ah<5   Ah=   Ah=   Ah>   Ah?   Ah@   AhA{   AhB\   AhC=   AhD   AhD   AhE   AhF   AhG   AhH   AhId   AhJE   AhK&   AhL   AhL   AhM   AhN   AhO   AhPl   AhQM   AhR.   AhS   AhS   AhT   AhU   AhV   AhWt   AhXU   AhY6   AhZ   AhZ   Ah[   Ah\   Ah]   Ah^|   Ah_]   Ah`>   Aha   Ahb    Ahb   Ahc   Ahd   Ahe   Ahfe   AhgF   Ahh'   Ahi   Ahi   Ahj   Ahk   Ahl   Ahmm   AhnN   Aho/   Ahp   Ahp   Ahq   Ahr   Ahs   Ahtu   AhuV   Ahv7   Ahw   Ahw   Ahx   Ahy   Ahz   Ah{}   Ah|^   Ah}?   Ah~    Ah   Ah   Ah   Ah   Ah   Ahf   AhG   Ah(   Ah	   Ah   Ah   Ah   Ah   Ahn   AhO   Ah0   Ah   Ah   Ah   Ah   Ah   AhW   Ah8   Ah   Ah   Ah   Ah   Ah   Ah~   Ah_   Ah@   Ah!   Ah   Ah   Ah   Ah   Ah   Ahg   AhH   Ah)   Ah
   Ah   Ah   Ah   Ah   Aho   AhP   Ah1   Ah   Ah   Ah   Ah   Ah   Ahw   AhX   Ah9   Ah   Ah   Ah   Ah   Ah   Ah   Ah`   AhA   Ah"   Ah   Ah   Ah   Ah   Ah   Ahh   AhI   Ah*   Ah   Ah   Ah   Ah®   AhÏ   Ahp   AhQ   Ah2   Ah   Ah   Ah   Ahɶ   Ahʗ   Ahx   AhY   Ah:   Ah   Ah   Ah   Ahо   Ahџ   AhҀ   Aha   AhB   Ah#   Ah   Ah   Ah   Ahا   Ahو   Ahi   AhJ   Ah+   Ah   Ah   Ah   Ah߯   Ah   Ahq   AhR   Ah3   Ah   Ah   Ah   Ah   Ah   Ahy   AhZ   Ah;   Ah   Ah   Ah   Ah   Ah   Ah   Ahb   AhC   Ah$   Ah   Ah   Ah   Ah   Ah   Ahj   AhK   Ah,   Ah
   Ah   Ah   Ah   Ah   Ahr   AhS   Ai 4   Ai   Ai   Ai   Ai   Ai   Aiz   Ai[   Ai<   Ai   Ai   Ai	   Ai
   Ai   Ai   Ai
c   AiD   Ai%   Ai   Ai   Ai   Ai   Ai   Aik   AiL   Ai-   Ai   Ai   Ai   Ai   Ai   Ais   AiT   Ai5   Ai   Ai   Ai   Ai    Ai!   Ai"{   Ai#\   Ai$=   Ai%   Ai%   Ai&   Ai'   Ai(   Ai)   Ai*d   Ai+E   Ai,&   Ai-   Ai.   Ai/   Ai0   Ai1l   Ai2M   Ai3.   Ai4   Ai4   Ai5   Ai7   Ai8t   Ai9U   Ai:6   Ai;   Ai;   Ai<   Ai=   Ai>   Ai?|   Ai@]   AiA>   AiB   AiC    AiC   AiD   AiE   AiF   AiGe   AiHF   AiI'   AiJ   AiJ   AiK   AiL   AiM   AiNm   AiON   AiP/   AiQ   AiQ   AiR   AiS   AiT   AiUu   AiVV   AiW7   AiX   AiX   AiY   AiZ   Ai[   Ai\}   Ai]^   Ai^?   Ai_    Ai`   Ai`   Aia   Aib   Aic   Aidf   AieG   Aif(   Aig	   Aig   Aih   Aii   Aij   Aikn   AilO   Aim0   Ain   Ain   Aio   Aip   Aiq   Airv   AisW   Ait8   Aiu   Aiu   Aiv   Aiw   Aix   Aiy~   Aiz_   Ai{@   Ai}   Ai}   Ai~   Ai   Ai   Aig   AiH   Ai)   Ai
   Ai   Ai   Ai   Ai   Aio   AiP   Ai1   Ai   Ai   Ai   Ai   Ai   Aiw   AiX   Ai9   Ai   Ai   Ai   Ai   Ai   Ai`   AiA   Ai"   Ai   Ai   Ai   Ai   Ai   Aih   AiI   Ai*   Ai   Ai   Ai   Ai   Ai   Aip   AiQ   Ai2   Ai   Ai   Ai   Ai   Ai   Aix   AiY   Ai:   Ai   Ai   Ai   Ai   Ai   Ai   Aia   AiB   Ai#   Ai   Ai   Ai   Ai   Ai   Aii   AiJ   Ai+   Ai   Ai   Ai   Ai   Ai   Aiq   AiR   Ai3   Ai   Ai   Ai   AiǷ   AiȘ   Aiy   AiZ   Ai;   Ai   Ai   Ai   Aiο   AiϠ   AiЁ   Aib   AiC   Ai$   Ai   Ai   Ai   Ai֨   Ai׉   Aij   AiK   Ai,   Ai
   Ai   Ai   Aiݰ   Aiޑ   AiS   Ai4   Ai   Ai   Ai   Ai   Ai   Aiz   Ai[   Ai<   Ai   Ai   Ai   Ai   Ai   Ai   Aic   AiD   Ai%   Ai   Ai   Ai   Ai   Ai   Aik   AiL   Ai-   Ai   Ai   Ai   Ai   Ai   Ais   AiT   Ai5   Ai   Ai   Aj    Aj   Aj   Aj{   Aj\   Aj=   Aj   Aj   Aj   Aj   Aj	   Aj
   Ajd   AjE   Aj
&   Aj   Aj   Aj   Aj   Aj   Ajl   AjM   Aj.   Aj   Aj   Aj   Aj   Ajt   AjU   Aj6   Aj   Aj   Aj   Aj   Aj   Aj |   Aj!]   Aj">   Aj#   Aj$    Aj$   Aj%   Aj&   Aj'   Aj(e   Aj)F   Aj*'   Aj+   Aj+   Aj,   Aj-   Aj.   Aj/m   Aj0N   Aj1/   Aj2   Aj2   Aj3   Aj4   Aj5   Aj6u   Aj7V   Aj87   Aj9   Aj9   Aj:   Aj;   Aj<   Aj=}   Aj>^   Aj??   Aj@    AjA   AjB   AjC   AjD   AjEf   AjFG   AjG(   AjH	   AjH   AjI   AjJ   AjK   AjLn   AjMO   AjN0   AjO   AjO   AjP   AjQ   AjR   AjSv   AjTW   AjU8   AjV   AjV   AjW   AjX   AjY   AjZ~   Aj\@   Aj]!   Aj^   Aj^   Aj_   Aj`   Aja   Ajbg   AjcH   Ajd)   Aje
   Aje   Ajf   Ajg   Ajh   Ajio   AjjP   Ajk1   Ajl   Ajl   Ajm   Ajn   Ajo   Ajpw   AjqX   Ajr9   Ajs   Ajs   Ajt   Ajv   Ajw   Ajx`   AjyA   Ajz"   Aj{   Aj{   Aj|   Aj}   Aj~   Ajh   AjI   Aj*   Aj   Aj   Aj   Aj   Aj   Ajp   AjQ   Aj2   Aj   Aj   Aj   Aj   Aj   Ajx   AjY   Aj:   Aj   Aj   Aj   Aj   Aj   Aj   Aja   AjB   Aj#   Aj   Aj   Aj   Aj   Aj   Aji   AjJ   Aj+   Aj   Aj   Aj   Aj   Aj   Ajq   AjR   Aj3   Aj   Aj   Aj   Aj   Aj   Ajy   AjZ   Aj;   Aj   Aj   Aj   Aj   Aj   Aj   Ajb   AjC   Aj$   Aj   Aj   Aj   Aj   Aj   Ajj   AjK   Aj,   Aj
   Aj   Aj   Aj   Aj   Ajr   AjS   Aj4   Aj   Aj   Aj   AjŸ   Ajƙ   Ajz   Aj[   Aj<   Aj   Aj   Aj   Aj   Aj͡   Aj΂   Ajc   AjD   Aj%   Aj   Aj   Aj   Ajԩ   AjՊ   Ajk   AjL   Aj-   Aj   Aj   Aj   Aj۱   Ajܒ   Ajs   AjT   Aj5   Aj   Aj   Aj   Aj   Aj   Aj{   Aj\   Aj=   Aj   Aj   Aj   Aj   Aj   Aj   Ajd   AjE   Aj&   Aj   Aj   Aj   Aj   Aj   Ajl   AjM   Aj.   Aj   Aj   Aj   Aj   Aj   Ajt   AjU   Aj6   Aj   Aj   Aj   Aj   Ak    Ak|   Ak]   Ak>   Ak   Ak    Ak   Ak   Ak   Ak   Ak	e   Ak
F   Ak'   Ak   Ak   Ak
   Ak   Ak   Akm   AkN   Ak/   Ak   Ak   Ak   Ak   Ak   Aku   AkV   Ak7   Ak   Ak   Ak   Ak   Ak   Ak}   Ak^   Ak ?   Ak!    Ak"   Ak"   Ak#   Ak$   Ak%   Ak&f   Ak'G   Ak((   Ak)	   Ak)   Ak*   Ak+   Ak,   Ak-n   Ak.O   Ak/0   Ak0   Ak0   Ak1   Ak2   Ak3   Ak4v   Ak5W   Ak68   Ak7   Ak7   Ak8   Ak9   Ak:   Ak;~   Ak<_   Ak=@   Ak>!   Ak?   Ak?   Ak@   AkA   AkB   AkCg   AkDH   AkE)   AkF
   AkF   AkG   AkH   AkI   AkJo   AkKP   AkL1   AkM   AkM   AkN   AkO   AkP   AkQw   AkRX   AkS9   AkT   AkT   AkU   AkV   AkW   AkX   AkY`   AkZA   Ak["   Ak\   Ak\   Ak]   Ak^   Ak_   Ak`h   AkaI   Akb*   Akc   Akd   Ake   Akf   Akgp   AkhQ   Aki2   Akj   Akj   Akk   Akl   Akm   Aknx   AkoY   Akp:   Akq   Akq   Akr   Aks   Akt   Aku   Akva   AkwB   Akx#   Aky   Aky   Akz   Ak{   Ak|   Ak}i   Ak~J   Ak+   Ak   Ak   Ak   Ak   Akq   AkR   Ak3   Ak   Ak   Ak   Ak   Ak   Aky   AkZ   Ak;   Ak   Ak   Ak   Ak   Ak   Ak   Akb   AkC   Ak$   Ak   Ak   Ak   Ak   Ak   Akj   AkK   Ak,   Ak
   Ak   Ak   Ak   Ak   Akr   AkS   Ak4   Ak   Ak   Ak   Ak   Akz   Ak[   Ak<   Ak   Ak   Ak   Ak   Ak   Ak   Akc   AkD   Ak%   Ak   Ak   Ak   Ak   Ak   Akk   AkL   Ak-   Ak   Ak   Ak   Aks   AkT   Ak5   Ak   Ak   Ak   Akù   AkĚ   Ak{   Ak\   Ak=   Ak   Ak   Ak   Ak   Akˢ   Ak̃   Akd   AkE   Ak&   Ak   Ak   Ak   AkҪ   AkӋ   Akl   AkM   Ak.   Ak   Ak   Ak   Akٲ   Akړ   Akt   AkU   Ak6   Ak   Ak   Ak   Ak   Ak   Ak|   Ak]   Ak>   Ak   Ak    Ak   Ak   Ak   Ake   AkF   Ak'   Ak   Ak   Ak   Ak   Ak   Akm   AkN   Ak/   Ak   Ak   Ak   Ak   Ak   Aku   AkV   Ak7   Ak   Ak   Ak   Ak   Ak   Ak}   Al ^   Al?   Al    Al   Al   Al   Al   Al   Alf   AlG   Al	(   Al
	   Al
   Al   Al   Al
   Aln   AlO   Al0   Al   Al   Al   Al   Al   Alv   AlW   Al8   Al   Al   Al   Al   Al~   Al_   Al@   Al!   Al    Al    Al!   Al"   Al#   Al$g   Al%H   Al&)   Al'
   Al'   Al(   Al)   Al*   Al+o   Al,P   Al-1   Al.   Al/   Al0   Al1   Al2w   Al3X   Al49   Al5   Al5   Al6   Al7   Al8   Al9   Al:`   Al;A   Al<"   Al=   Al>   Al?   Al@   AlAh   AlBI   AlC*   AlD   AlD   AlE   AlF   AlG   AlHp   AlIQ   AlJ2   AlK   AlK   AlL   AlM   AlN   AlOx   AlPY   AlQ:   AlR   AlR   AlS   AlT   AlU   AlV   AlWa   AlXB   AlY#   AlZ   AlZ   Al[   Al\   Al]   Al^i   Al_J   Al`+   Ala   Ala   Alb   Alc   Ald   Aleq   AlfR   Alg3   Alh   Alh   Ali   Alj   Alk   Ally   AlmZ   Alo   Alo   Alp   Alq   Alr   Als   Altb   AluC   Alv$   Alw   Alw   Alx   Aly   Alz   Al{j   Al|K   Al},   Al~
   Al~   Al   Al   Al   Alr   AlS   Al4   Al   Al   Al   Al   Al   Alz   Al[   Al<   Al   Al   Al   Al   Al   Al   Alc   AlD   Al%   Al   Al   Al   Al   Al   Alk   AlL   Al-   Al   Al   Al   Al   Al   Als   AlT   Al5   Al   Al   Al   Al   Al   Al{   Al\   Al=   Al   Al   Al   Al   Al   Al   Ald   AlE   Al&   Al   Al   Al   Al   Al   All   AlM   Al.   Al   Al   Al   Al   Al   Alt   AlU   Al6   Al   Al   Al   Al   Al   Al|   Al]   Al>   Al   Al    Al   Al   Alɣ   Alʄ   Ale   AlF   Al'   Al   Al   Al   AlЫ   Alь   Alm   AlN   Al/   Al   Al   Al   Al׳   Alؔ   Alu   AlV   Al7   Al   Al   Al   Al޻   Alߜ   Al}   Al^   Al?   Al    Al   Al   Al   Al   Al   Alf   AlG   Al(   Al	   Al   Al   Al   Al   Aln   AlO   Al0   Al   Al   Al   Alv   AlW   Al8   Al   Al   Al   Al   Al   Al~   Al_   Al@   Am !   Am   Am   Am   Am   Am   Amg   AmH   Am)   Am
   Am   Am	   Am
   Am   Amo   Am
P   Am1   Am   Am   Am   Am   Am   Amw   AmX   Am9   Am   Am   Am   Am   Am   Am   Am`   AmA   Am"   Am   Am   Am   Am    Am!   Am"h   Am#I   Am$*   Am%   Am%   Am&   Am'   Am(   Am)p   Am*Q   Am+2   Am,   Am,   Am-   Am.   Am/   Am0x   Am1Y   Am2:   Am3   Am3   Am4   Am5   Am6   Am7   Am8a   Am9B   Am:#   Am;   Am;   Am<   Am=   Am>   Am?i   Am@J   AmA+   AmB   AmB   AmC   AmD   AmE   AmFq   AmGR   AmH3   AmI   AmI   AmJ   AmK   AmL   AmMy   AmNZ   AmO;   AmP   AmP   AmQ   AmR   AmS   AmT   AmUb   AmVC   AmW$   AmX   AmX   AmY   AmZ   Am[   Am\j   Am]K   Am^,   Am_
   Am_   Am`   Ama   Amb   Amcr   AmdS   Ame4   Amf   Amf   Amg   Amh   Ami   Amjz   Amk[   Aml<   Amm   Amm   Amn   Amo   Amp   Amq   Amrc   AmsD   Amt%   Amu   Amu   Amv   Amw   Amx   Amyk   AmzL   Am{-   Am|   Am|   Am}   Am~   Am   Ams   AmT   Am5   Am   Am   Am   Am   Am   Am{   Am\   Am=   Am   Am   Am   Am   Am   Am   Amd   AmE   Am&   Am   Am   Am   Am   Am   Aml   AmM   Am.   Am   Am   Am   Am   Am   Amt   AmU   Am6   Am   Am   Am   Am   Am   Am]   Am>   Am   Am    Am   Am   Am   Am   Ame   AmF   Am'   Am   Am   Am   Am   Am   Amm   AmN   Am/   Am   Am   Am   Am   Am   Amu   AmV   Am7   Am   Am   Am   Am   Am   Am}   Am^   Am?   Am    Am   Am   Am   AmǤ   Amȅ   Amf   AmG   Am(   Am	   Am   Am   Amά   Amύ   Amn   AmO   Am0   Am   Am   Am   Amմ   Am֕   Amv   AmW   Am8   Am   Am   Am   Amܼ   Amݝ   Am~   Am_   Am@   Am!   Am   Am   Am   Am   Am   Amg   AmH   Am)   Am
   Am   Am   Am   Am   Amo   AmP   Am1   Am   Am   Am   Am   Am   Amw   AmX   Am9   Am   Am   Am   Am   Am   Am   Am`   AmA   Am"   Am   Am   An    An   An   Anh   AnI   An*   An   An   An   An   An	   An
p   AnQ   An2   An
   An
   An   An   An   Anx   AnY   An:   An   An   An   An   An   An   Ana   AnB   An#   An   An   An   An   An   An i   An!J   An"+   An#   An#   An$   An%   An&   An'q   An(R   An)3   An*   An*   An+   An,   An-   An.y   An/Z   An0;   An1   An1   An2   An3   An4   An5   An7C   An8$   An9   An9   An:   An;   An<   An=j   An>K   An?,   An@
   An@   AnA   AnB   AnC   AnDr   AnES   AnF4   AnG   AnG   AnH   AnI   AnJ   AnKz   AnL[   AnM<   AnN   AnN   AnO   AnP   AnQ   AnR   AnSc   AnTD   AnU%   AnV   AnV   AnW   AnX   AnY   AnZk   An[L   An\-   An]   An]   An^   An_   An`   Anas   AnbT   Anc5   And   And   Ane   Anf   Ang   Anh{   Ani\   Anj=   Ank   Ank   Anl   Anm   Ann   Ano   Anpd   AnqE   Anr&   Ans   Ans   Ant   Anu   Anv   Anwl   AnxM   Any.   Anz   Anz   An{   An|   An}   An~t   AnU   An6   An   An   An   An   An   An|   An]   An>   An   An    An   An   An   An   Ane   AnF   An'   An   An   An   An   An   Anm   AnN   An/   An   An   An   An   An   Anu   AnV   An7   An   An   An   An   An   An}   An^   An?   An    An   An   An   An   An   Anf   AnG   An(   An	   An   An   An   An   Ann   AnO   An0   An   An   An   An   An   Anv   AnW   An8   An   An   An   An   An   An~   An_   An@   An!   An   An   An   Anť   AnƆ   Ang   AnH   An)   An
   An   An   Aṋ   An͎   Ano   AnP   An1   An   An   An   Anӵ   AnԖ   Anw   AnX   An9   An   An   An   Anڽ   An۞   An   An`   AnA   An"   An   An   An   An   An   Anh   AnI   An*   An   An   An   An   An   Anp   AnQ   An2   An   An   An   An   Anx   AnY   An:   An   An   An   An   An   An   Ana   AnB   An#   An   An   An   An   Ao    Aoi   AoJ   Ao+   Ao   Ao   Ao   Ao   Ao   Aoq   Ao	R   Ao
3   Ao   Ao   Ao   Ao
   Ao   Aoy   AoZ   Ao;   Ao$   Ao   Ao   Ao   Ao   Ao   Aoj   AoK   Ao ,   Ao!
   Ao!   Ao"   Ao#   Ao$   Ao%r   Ao&S   Ao'4   Ao(   Ao(   Ao)   Ao*   Ao+   Ao,z   Ao-[   Ao.<   Ao/   Ao/   Ao0   Ao1   Ao2   Ao3   Ao4c   Ao5D   Ao6%   Ao7   Ao7   Ao8   Ao9   Ao:   Ao;k   Ao<L   Ao=-   Ao>   Ao>   Ao?   Ao@   AoA   AoBs   AoCT   Aom   Aone   AooF   Aop'   Aoq   Aoq   Aor   Aos   Aot   Aoum   AovN   Aow/   Aox   Aox   Aoy   Aoz   Ao{   Ao|u   Ao}V   Ao~7   Ao   Ao   Ao   Ao   Ao   Ao}   Ao^   Ao    Ao   Ao   Ao   Ao   Aof   AoG   Ao(   Ao	   Ao   Ao   Ao   Ao   Aon   AoO   Ao0   Ao   Ao   Ao   Ao   Ao   Aov   AoW   Ao8   Ao   Ao   Ao   Ao   Ao   Ao~   Ao_   Ao@   Ao   Ao   Aoæ   Aoć   Aoh   AoI   Ao*   Ao   Ao   Ao   Aoʮ   Aoˏ   Aop   AoQ   Ao2   Ao   Ao   Ao   AoѶ   Aoҗ   Aox   AoY   Ao:   Ao   Ao   Ao   Aoؾ   Aoٟ   Aoڀ   Aoa   AoB   Ao#   Ao   Ao   Ao   Ao   Ao   Aoi   AoJ   Ao+   Ao   Ao   Ao   Ao   Aoq   AoR   Ao3   Ao   Ao   Ao   Ao   Ao   Aoy   AoZ   Ao;   Ao   Ao   Ao   Ao   Ao   Ao   Aob   AoC   Ao$   Ao   Ao   Ao   Ao   Ao   Aoj   Ap K   Ap,   Ap
   Ap   Ap   Ap   Ap   Apr   ApS   Ap4   Ap	   Ap	   Ap
   Ap   Ap   ApD   Ap   Ap   Ap   Ap   Ap   Apk   ApL   Ap-   Ap   Ap   Ap    Ap!   Ap"   Ap#s   Ap$T   Ap%5   Ap&   Ap&   Ap'   Ap(   Ap)   Ap*{   Ap+\   Ap,=   Ap-   Ap-   Ap.   Ap/   Ap0   Ap1   Ap2d   Ap3E   Ap4&   Ap5   Ap5   Ap6   Ap7   Aplf   ApmG   Apn(   Apo	   Apo   App   Apq   Apr   Apsn   AptO   Apu0   Apv   Apv   Apw   Apx   Apy   Apzv   Ap{W   Ap   Ap   Ap~   Ap_   Ap@   Ap   Ap   Ap   Ap   Ap   Apg   ApH   Ap)   Ap
   Ap   Ap   Ap   Ap   Apo   ApP   Ap1   Ap   Ap   Ap   Ap   Ap   Ap   Ap   Api   ApJ   Ap+   Ap   Ap   Ap   Apȯ   Apɐ   Apq   ApR   Ap3   Ap   Ap   Ap   ApϷ   ApИ   Apy   ApZ   Ap;   Ap   Ap   Ap   Apֿ   Apנ   Ap؁   Apb   ApC   Ap$   Ap   Ap   Ap   Apި   Ap߉   Apj   ApK   Ap,   Ap
   Ap   Ap   Ap   Ap   Apr   ApS   Ap4   Ap   Ap   Aq   Aq   Aq   Aq    Aq!t   Aq"U   Aq#6   Aq$   Aq$   Aq%   Aq&   Aq'   Aq(|   Aq)]   Aq*>   Aq+   Aq,    Aq,   Aq-   Aq.   Aq/   Aq0e   Aq1F   Aq2'   Aq3   Aq3   Aq4   Aq5   Aq6   Aq7m   Aq8N   Aq9/   Aq:   Aq:   Aq;   Aq<   Aq=   Aq>u   Aq?V   Aq@7   AqA   AqA   AqB   AqC   AqD   AqE}   AqF^   AqG?   AqH    AqI   AqI   AqJ   AqK   AqL   AqMf   AqNG   AqO(   AqP	   AqP   AqQ   AqR   AqS   AqTn   AqUO   AqV0   AqW   AqW   AqX   AqY   AqZ   Aq[v   Aq\W   Aq]8   Aq^   Aq^   Aq_   Aq`   Aqf   Aqg   Aqh   Aqi   Aqjg   AqkH   Aql)   Aqm
   Aqm   Aqn   Aqo   Aqp   Aqqo   AqrP   Aqs1   Aqt   Aqt   Aqu   Aqv   Aqw   Aqxw   AqyX   Aqz9   Aq{   Aq{   Aq|   Aq}   Aq~   Aq   Aq`   AqA   Aq"   Aq   Aq   Aq   Aq   Aq   Aqh   AqI   Aq*   Aq   Aq   Aq   Aq   Aq   Aq   Aq   Aq   Aqj   AqK   Aq,   Aq
   Aq   Aq   Aqư   AqǑ   AqS   Aq4   Aq   Aq͸   AqΙ   Aqz   Aq[   Aq   Aq   Aq   Aq   Aqա   Aqւ   Aqc   AqD   Aq%   Aq   Aq   Aq   Aqܩ   Aq݊   Aqk   AqL   Aq-   Aq   Aq   Aq   Aq   Aq   Aqs   AqT   Aq5   Aq   Aq   Aq   Aq   Aq   Aq{   Aq\   Ar   Are   ArF   Ar'   Ar   Ar   Ar   Ar   Ar   Arm   ArN   Ar/   Ar   Ar   Ar   Ar   Ar   Aru   Ar V   Ar!7   Ar"   Ar"   Ar#   Ar$   Ar%   Ar&}   Ar'^   Ar(?   Ar)    Ar*   Ar*   Ar+   Ar,   Ar-   Ar.f   Ar/G   Ar0(   Ar1	   Arf   Arg   Arhh   AriI   Arj*   Ark   Ark   Arl   Arm   Arn   Arop   ArpQ   Arq2   Arr   Arr   Ars   Art   Aru   Arx:   Ary   Ary   Arz   Ar{   Ar|   Ar}   Ar~a   ArB   Ar#   Ar   Ar   Ar   Ar   Ar   Ari   ArJ   Ar+   Ar   Ar   Ar   Ar   Ar   Arq   ArR   Ar3   Ar   Ar   Ar   Ar   Ar   Ary   ArZ   Ar;   Ar   Ar   ArD   Ar%   Ar   Ar   Ar   Ar   Ar   Ark   ArL   Ar-   Ar   Ar   Ar   Arı   ArŒ   Ars   ArT   Ar5   Ar   Ar   Ar   Ar˹   Ar̚   Ar{   Ar\   Ar=   Ar   Ar   Ar   Ar   ArӢ   Arԃ   Ard   ArE   Ar&   Ar   Ar   Ar   Arڪ   Arۋ   Arl   ArM   Ar.   Ar   Ar   Ar   Ar   Ar   Art   ArU   Ar6   Ar   Ar   Ar   Ar   Ar   Ar|   Ar]   Ar>   Ar   Ar    Ar   Ar   Ar   Ar   Are   ArF   Ar'   Ar   Ar   Ar   Ar   Ar   Arm   ArN   Ar/   Ar   Ar   Ar   Ar   As
   As   Asf   AsG   As(   As	   As   As   As   As   Asn   AsO   As0   As   As   As   As   As   Asv   AsW   As8   As    As    As!   As"   As#   As$~   As%_   As&@   As'!   As(   As(   As)   As,g   As-H   As.)   As/
   As/   Asi   Asi   Asj   Ask   Asl   Asmq   AsnR   Aso3   Asp   Asp   Asq   Asr   Ass   Asty   Asw   Asx   Asy   Asz   As{   As|b   As}C   As~$   As   As   As   As&   As   As   As   As   As   Asl   AsM   As.   As   As   As   As²   AsÓ   Ast   AsU   As6   Asʛ   As|   As]   As>   As   As    As   As   Asѣ   As҄   Ase   AsF   As'   As   As   As   Asث   Asٌ   Asm   AsN   As/   AtH   At)   At
   At   At   At   At   Ato   AtP   At1   At   At   At   At   At   Atw   AtX   At9   At   At   At   At    At!   At"   At#`   At$A   At%"   At&   At&   At'   At(   At)   At*h   At+I   At,*   At-   At-   At.   At/   At0   At1p   At2Q   At32   At4   At4   At5   At6   At7   At8x   At9Y   At::   At;   At;   At<   At=   At>   At?   At@a   AtAB   AtB#   AtC   AtC   AtD   AtE   AtF   AtGi   AtHJ   AtI+   AtJ   AtJ   AtK   AtL   AtM   AtNq   AtOR   AtP3   At`   Ata   Atb   Atc   Atdj   AteK   Atf,   Atg
   Atg   Ath   Ati   Atj   Atkr   AtlS   Atm4   Atn   Atn   Ato   Atp   Atq   Atrz   Ats[   Att<   Atu   Atu   Atv   Atw   Atx   Aty   Atzc   At{D   At|%   At}   At}   At~   At   At   Atk   AtL   At-   At   At   At   At   At   Ats   AtT   At5   At   At   At   At   At   At{   At\   At=   At   At   At   At   At   At   Atd   AtE   At&   At   At   At   At   At   Atl   AtM   At.   At   At   At   At   At   Att   AtU   At6   At   At   At   At'   At   At   At   At   At   Atm   AtN   At/   At   At   At   At   At   Atu   AtV   At7   At   At   At   Atǻ   AtȜ   At}   At^   At?   At    At   At   At   AtϤ   AtЅ   Atf   AtG   At(   At	   At   At   At֬   At׍   Atn   AtO   At0   At   At   At   Atݴ   Atޕ   Atv   AtW   At8   At   At   At   At   At   At~   Au
*   Au   Au   Au   Au   Au   Aup   AuQ   Au2   Au   Au   Au!a   Au"B   Au##   Au%   Au&   Au'   Au(i   Auk5   Aul   Aul   Aum   Aun   Auo   Aup{   Auq\   Aur=   Aus   Aus   Aut   Auu   Auv   Auw   Auxd   AuyE   Auz&   Au{   Au{   Au|   Au}   Au~   Aul   AuM   Au.   Au   Au   Au   Au   Au   Aut   AuU   Au6   Au   Au   Au   Au   Au   Au|   Au]   Au>   Au   Au    Au   Au   Au   Au   Aue   AuF   Au'   Au   Au   Au   Au   Au   Au   Au   Aun   AuO   Au0   Au   Au   Au   Au   Au8   Au   Au   Au   Auż   AuƝ   Au~   Au_   Au@   Au!   Au   Au   Au   Auͥ   AuΆ   Aug   AuH   Au)   Au
   Au   Au   Avq   AvR   Av3   Av   Av   Av   Av   Av   Avy   AvZ   Av;   Av   Av   Av   Av   Av   Av   Avb   Av C   Av   AvҮ   Avӏ   Avp   AvQ   Av2   Av   Av   AvY   Aw   Aw   Awj   AwK   Aw	,   Aw

   Aw
   Aw   Aw   Aw
   Awr   AwS   Aw4   Aw   Awz   Aw[   Aw<   Aw%   Aw    Aw    Aw!   Aw"   Aw#   Aw$k   Aw%L   Aw'   Aw'   Aw(   Aw)   Aw`/   Awa   Awa   Awb   Awc   Awd   Awh   Awi   Awj   Awk   Awp   Awq   Awr   Aws   Awtf   AwuG   Aw   Aw   Aw   Aw   Awp   AwQ   Aw2   Aw   Aw   Aw   Aw   Aw   Awx   AwY   Aw:   Aw   Aw   Aw   Aw   Aw   AwÀ   Awa   AwB   Aw#   Aw   Aw   Awʈ   Awi   AwJ   Aw+   Ax   Ax   Axk   Ax   Ax   Ax	   Ax
   Ax   Axs   Ax
T   Ax5   Ax   Ax   Ax   Ax   Ax   Ax{   Ax\   Ax=   Ax   Ax   Ax   Ax   Ax   Ax   Axd   BB
B(B
B\A
A(AB
=A\AAzAAAAA  AܸRA
=AݙAAQAޏ\AA33AA
AHA\AHAA33AAᙚApAApA  AQAHAݮA  AzAA
=A(AAAAAQAQAڸRApAGA܏\ApAGAA\A(A  A
=A  Aڏ\AAAQAffAߙA
=AۙAׅAAA\)AڣAzA(AAծA  AA  AAA\)AAAݙA{A܏\AܣAHAAffAڸRAA\)AAۙAۙAHA(AۮAAffAffAٙA{AڸRAA  A܏\A  A(AzA
=A
=A33AAAAAAA33AAAGApAA
=AffA=qA
=AffA߮AQA33A
=AHAA
=AA=qAA
AQA\)AffA܏\AڸRAۮA33AA{AzAA(A
A
=A֏\AA{ApAָRAzA\)A
A  AffA׮Aڏ\A؏\AأA\)A  AۮAA(A\)A33AۙA\)A
=A\)AۙApAA(A
=A33A߮A33A(AAffA
AffAAzA\)A\)AݙA݅AA  A{AݙA
AݮAݙA  A=qA  A\)AAffA܏\AܸRAܣA܏\AܣA܏\AܣAQA(AAܣA(AܸRA
=AHA=qApA߅A  A
AAۅAAffAٙAAA݅AߙAAAQAAޏ\AzAޣA
A=qAAzAAݙAGAٮA(AۅA޸RAHA33AޣAAGA(A  AffA\)A=qAڸRA=qAӅA
=A
AffAAڣAݮAܣAAܣAڏ\A\)A  AGAۅAGAAGAAۅAAzAܸRAAQAHA߮AffA\AffAAARA=qARA33A{A=qA
=AzA=qAARA
=AHAA\)AGA
AAA㙚AzAffAA=qAzA
AA=qAAzAAAAGApAGAA
AGAHA{AzA(AGA߮AڸRAׅAAAQA\)AQAffA  AA߅AA{AffAA
AA
AA33AAA
=A
=A{A=qA=qAHAA{AAffAQAޣA  A
AAzA33A=qAHA\)AAzAA(A\)AᙚAAA
=A  AffAzAᙚA  AAzAQA  A㙚A(A
AᙚA{AA
AGAAAAGAQAzAHA33AAޣA޸RAQAAAzApARAffA\)AAAHAHAۮAApAأAHA(A(A
AڸRA
AAHAڸRAܸRAAffA(AffApA(A
=AٮAׅAأAAffA
=AAڣAAGA֣A؏\AA\)AGAٙApA
A݅A
=AݮAzA(AޣA(ARA
=A33AᙚAQAޣA=qA߮A(ApA  AA܏\AޣA  ApAQA  AڣAڣA(A(A
A=qA33ApA
=A=qAأAGA
A؏\AffAمAzAA
=AٙAffAAۮA܏\A
A  A
A(AݮAApAڸRAۅA׮ApAApA\)AأAGAffA
=A(AәAA33AHAQAzA
=AҸRAffAAHAQAԣApA{ApAQA=qAԏ\ApAGAՙAՙAՅA(AԣAAԸRAHAApA
A(AffA
A
AיAׅApAAA=qAأAAAHAأAHAHAHAA33ApAGAٙAffA(A{A  AA{AQAڏ\Aڏ\AffAڣAzAzAzAzAAمAzAڣAAAffAٮAٙAٮAمAأA(A
=AAA
AمA=qAڣAڸRAمA
=AٙAٙAٮApAAمAGA  AffApA\)A=qA
A؏\AA
AQAzAAڸRA(AڸRAٮAAڣAAAظRA؏\A  ApA\)AffAzAڣA(A
AAAffAA=qAffA޸RAGAA
A{A\AAA=qA(A{A  A߅AGA\)A33AAHA
=A33ApA
=A޸RAAAzAA{AA݅AApAA
=AٮAzAffAAܸRAܸRA܏\AQA  ApA=qAٮAיAffApAA  ApAAGA
A(AQAA=qAApA
A(A(AA=qA{A(A܏\AۙAGAHAA
Aڏ\A܏\AGAۙAzAڣAAffAܣA  ApAۮAۙAAQAA(AAApAA{AQAߙAA(AAA(AAHARA(AA
=AAGA33A33AApA\)AAQApA
A߮A
AAޏ\A
AA=qAߙApA߮AAA߅AA33ApAߙA
ApAHAޣAHA=qAHAAGAAGAQAAڸRAAAܸRA{AAHA=qAٙA=qAA=qAAۙA
AAAA
=A\)AۙA  AۙAۮAۙA33A33ApAۮAffA  AQAffAffAzAܸRA
=AݮA݅A
AݮAAݙA33A
=AݙAA(AffA=qAA޸RAGAߙAA33AߙAApAAQA(AQAޏ\AffAޏ\A{A
AzAffAA
AAGAHA{AHA
A{AGA{A=qApA޸RAffAzAAߙAۅA=qAܸRAffA܏\AAAۮAAA{AۙA(A  AHAzAAܸRAGAzA
AARAAzA
A߮ARA33A޸RA=qAAGAHApA  AGA  AظRAQAGAGAAAAA  Aޏ\AA
A  A޸RA33ApAA݅A܏\A\)AGA
AzApAGA  AڸRAأApAGA33AAQA
=AՙA
AծAA(AظRAQA؏\AׅAA\)A֏\AA
=AGA{AAzAأAA33AffAٙAأAׅAָRAQA֣AAA֏\AzApA
AՙA
A{AzA(ApA(A  A
AәAӮAQAծAA
AHA\)AGAA  A(AQA\)AAӅA=qA33A{AAGA
AָRAHApA
A(AA
AQA{AָRA׮A׮A(A֣AՙA֣AAzA{AHA
A\)A=qAAAٙAAffA
=A=qAAzAأA=qAffAAGAׅA(AffA{AffA  Aԏ\A
A
A  A=qAA
=AGA33AָRAծA\)ApA
=A\)ApAՙAծAAAGAffAHAԣAffA{A
=ApA{A{A33AffA=qAHAA=qApA
AAA  A{A{AAA
A33AAA
AA֏\A֣AAAA׮A(AAA
=AAGAHA֣AHA֏\AHAHA
=AGA׮AׅAיA׮A
A  AׅAHAGAAQAzA(AzA׮AzA
=A
AffAA׮AA(AGAA{Aԏ\AԸRAՙAHA(AzAծA
=AzAQA
A(AQAAzAՙA
AA\)A
ApAffA֏\A33A  A
AՅAA  A
A{AأAA֣AHAAظRA  AHA(A  AAA
A=qAۮAAzA
=A33AAAGApAAڣApA׮AAAAA
A(AffAffAA{AffAffAzAظRA=qA؏\AمAApAA
=AAAGAمA\)ApAGA  A{A(AمAGA(AA؏\A׮AHAHA{AHA
A33AA֏\A33AأAڸRA
AzAظRAApAԏ\A
A(AAҏ\AffAԸRApA  A=qA(AAQAA33A
AՅA
AAA  A\)A{AأA  AAA=qAHAAԣAHAGAAծA
A=qAAA؏\AffA(A(A{A
A{AA
A  A(AzAzAAظRAظRAAٮA
=AA׮AأAAAAffAApAA֏\AzA
=AӅA33A
=A  AQAAHA֣A
AיA
AGA(AיAzA
=ApAԣAffAffA{Aԏ\ApAffAA
=AffAA33AA؏\ApAHA
=AAԸRAHAA؏\A
AA\)AAAAܸRA܏\A
AۮAA\)A{AffAzAAAיAׅApAיA  A  AׅApA=qAAڸRAۅAA
A{A{A{A
AA=qA  A  AAۮAۮAۙAۅAAHA
=A{AGAۙAzA
A
=AzAܸRA\)AܸRAܸRAܸRAܸRA܏\AzAHAHA׮A  ApApAA
A֣A{AGA
=AGA\)A(AׅA
AAAGA(A
=A
AHApA{AٙAՙAA=qA֏\AA(ApAԸRAHA(AAffAծAAָRAffApA׮A\)AׅAApAظRA33AٮA=qAffAHAHA\)AAAAffA
A߮AAA
=AQA\)AAzA(AAAAAAzAAAAA=qAQAA  AA߮ApAA33AA33AߙA
AzAݮA\)AAA\)AܸRA܏\A  A(A(AۅAGAڸRAAAAAA؏\A33A
=AAzAA  ApAzAA\)AۮAAHAzAzA33AHA
=AA
=AffAHApA
AۮA33A(Aڏ\A
ApA  AA\)A݅A\)AܣA
AߙAA  AApAA{A(AQA  AA
AAۅAأA  AأA؏\AAA\)ApAA{AHA{A  A(ApA(AQApA{A=qAzAۅAAٮAAA݅A݅A{AܸRA\)ApA޸RA{AzAAۙA܏\AGA׮A(A(AGAA
AA  A\)AAծAQA
=AA=qA
=AGA\)A(A33AA{AׅAمA  AAיAA{AУAGAHA=qAzA
=A=qA33AAѮAҸRApAיAA
A؏\A(AffA(AffAՙA{A=qAׅAAQA
=AAGAzAָRAApAׅA\)AHApAָRAӮAՅA֣AAمAHA(A=qAأA؏\A׮AAׅA=qAzAApA(A\)AAԏ\A
AQA  A33AGAGAzA{AzAAAיAA{A{AHA33A  AA33A(AAAHAzA=qAzAHA\)Aҏ\AAzA=qAHA\)A(AGAљA
ApApAAA(AиRA(ApAffA=qAͮA
AHA  A  A{AυAϙA\)AυApAAGAzAхA=qA(AΣAAGAAHAУAAzAЏ\AңAҸRAӅAҸRA\)A=qA  A(AQA{AA
A(A=qAQA=qA
AQAУA(AGA͙AϙA
ApAGAffAA33AAApAHAAQAͮA=qA\)AA33AA=qA
AͅAffAQA˅AAA˙A
A  A\)AAǮA=qA˅AA(A33AAffA=qAQẠA(A  AffAGAAAẠA(AǅAAəAAθRA  A=qAЏ\AиRAA=qAʸRA{A  AљAθRA
=AHA=qAHAffA(A
A{AQAGA=qAA33A͙AHA=qA33AAAAAиRAAAЏ\AЏ\A  AͮAzAAυA
AGAAA{AffẠȀ\AAzA  A\)Ȁ\A˅AA
A\)AAAAAAAffAGARA{A33ARA(AAÅAÅAA
AAAAAAAAA=qA{A  A
A
A
AGAA33ApA  A  AAA\AAAA
AzA\A
=ApAA  AAAÙAGAAAGA{AAƣA\)A(AAÙAApAzAzAQAA\)Aȏ\ApAǙAȏ\AHAAAQAQAǅAʣA
=ApAAͅAAɮAɅAQA˅AzAAʏ\AAAʏ\AˮA\)AAΣA͙AʣA  A(ApApAɮAQA
A(Aď\AAAA  AȸRAHA͙AAԸRAAљAHA\)A
AHAA\)A
=AAՅA
=A
AӅAHAϙAGAzAAУA{Aҏ\AAHAҏ\A˅AAA  AљAљAͮApAϮAҏ\AҸRẠA\)A{AAAzA33Aҏ\ẠAGAՙAәA(AAAAծAԏ\A{AHAAծAHAA  AQA
AҸRA
=AQAхAЏ\AA\)AυAA{AHAffAQAθRA  A=qAHApA33AϮAϮA
ApAAυAϮAѮAffAffAAAzAGA
A  ApA
AHA\)AA
A  A(AzAA33A(ApA
=AzAأA{AHA
=Aҏ\AҸRAA=qA{AAAA33AQA33A
=A\)AAHAAffAGAхAffAzA{AffA  A
=A
AәA
AGAӅApAHAA\)A
=AңA=qAAԏ\A  A  A(AAAAA
A33AAAA33AHAAAAԏ\AffAA\)A  Aԏ\AA33AA33AGAAzA  AՅA\)AՙAGAffAffA33A
=AAՙA=qA
AָRAHAAffAأAأA
=AAA؏\AAA  A׮AיAAHAיAA33AGAzA(AA  AיApAיAA\)A(A33AzApAQA׮ApA  AffApA  AӮAHAA\)AAՙA
A\)ApAGAGApAAApAՅAHAA
AAҏ\A(AԣA  AffAffAљA\)AA=qA(AGAffA33A
=A(AָRA\)ApAAffAQA  A
ApAA{AHAAأAffAAA֣AHAHAHA33AיA  AAGAA֏\AffA֣A33AffAՙAҸRAAәA  AGA\)AHAQA
AzAՙAծA
A{AffA֏\AA  A33A33AA\)AffAAԣA  A
A(AAzAՙA
AHAԏ\AGAAAAӅAA=qAAffA
AәA=qA=qAԏ\AAffAәAәAңAGA
=AHAAAA
=AA
A(AңAzA
=AffApAQAGAAAAӮA=qAffAAԣA
=AGAծAAծA
AQA֏\AA֏\AָRAAAA
=AGA  A֏\AffA
AיA\)AAָRAA{AָRAָRAQAAffA{AָRAQA  A
A(AQAָRA  AGAәAԣA\)AGA{AQAffAԏ\A{A
AGAA
A33AҸRAәA(A
AHA(AGAծA33AәA
A\)AҸRA\)ApAљAAAQA
=A
=AffAHAA=qA=qAAAAQA  AAAGAҏ\AAGA=qAԸRA
=AՅAQAָRA33AAיApA
ApAGApApA33AQA=qApAظRAQA
A
A(AAGAzAA(AAָRAAQApAأAffA\)ApA
=AA\)AٙA  A(A
=AٮAمA\)A33AHApA{AٮAأAGA\)A
=AzA(AظRA\)AApA\)A  ApA
AAׅApAHAQA{A(AA=qAQAAA
=AGA=qAA  AظRA  AׅAHApAQAHAHAApAAظRAA33AظRAAٮA
AA؏\A
=AٙAA  AA33A\)AمApApAGAٙAظRA33ApAٮA(AzAAAzA
A(AQA׮AAzAAQA(AAڏ\Aڏ\AAQAAffAAظRAA׮A׮A{A
ApAffA(A\)A{AffAңAQAGA(AәAAԸRAAQAӮAffAУA=qAԏ\AԸRAGA33AffA
AٙAAٙAAԏ\AԣA33A  A\)A{AHAϮA{AHAA
=AҸRAҏ\A\)AәAffAffA֣AָRApAzA(A  AQA=qA=qAzAzAӅAffAԏ\A
AԸRA{AՙAңA33A
AffAAffAA  AיAA=qAQAGAHAՙAծAԣA33A{AיA=qAA{A؏\AzAأAzA=qAԏ\ApA֏\A33AAQA  AHA\)AffAՅA
AԣApAHAAQAHAHAиRA
AHAAffA{AٙA=qA  AHAיAAHApA33A
AAffAHA׮A=qAGAأA\)A\)ApAAQAQAA݅AݮAGA
=AޣAڸRAAAظRAQA؏\AAA(A(AAA\)AHAمA(AAzA  A׮A=qAAAٮAQA=qAڸRAA
AۙA
AGAzA33AHAAGAAۙApAffAAAAffA
A{A׮A=qA33ApA؏\A؏\AAzAAУAAHApA33AӮAָRAzAzA֣AָRA
Aڏ\AAHAffA
ApA\)AGAٮA\)AA=qAA  AA(AzAGA  A  AffA(A{AzA33A\)AۙAۅAۮAۮA33AHA\)A=qA  AGA݅A\)AzAܸRA
AHAۅAAۮApA{A33A\)AffAٙA  AٙAڣAzAٙA33AAGApAۮA=qAHAڏ\A\)AڣAAAffApAۙAAׅAQAAمAffA  A
AمA(AAA  AٮA  AAzA{AQAffA\)AGA{AAAAڸRAڣAHAӮA=qAՙAԣAzAיA\)A  A{A  AׅA׮A
AAzAAظRAمAڸRAGAGAڏ\A  A33AA(AGAA\)AۙAۮA
AQAQA܏\A(A{AAAHAAׅA
A  A
=A\)AAAڣAٙA=qAA33A(A(ApA{AٙAمA(A(A  Aڏ\A
=A
=AAHA{AA
=AA؏\AٮA33AָRAAԸRApA
=A֏\AHA
A׮AծAA33AхAGAӮAԏ\A(AծAffAՅA33AA
AAׅA(AAQA(AՙAGA(A
A  A  AHAA  AHAיAA(AGA{AܣAܸRAܸRAܸRA܏\AA  A{A{AAzA=qAAܣAQAzAffAffAHAzA
=AHAAAzAA
AAffAzA
=A\)ApAHA=qAܸRA(AA33AffAڏ\A=qApAظRAHApA=qAAڏ\AA33AڸRA(AGAAA؏\AzA{A=qAzA  A׮AיAGA  A
AGA{A33AQApAAAGA
ApAָRAأA  A
=A{A؏\AAٙAQA؏\A  AAAܸRAAGAffAffApA݅ApAݮAA޸RAHAAݙA܏\A
=AݮAݙApApA݅AݙAGAAۙAAܸRAHA݅AAffA=qAAzA
AAffAzAApA=qA܏\ApA܏\AܸRAffAQAۅA=qAAQAڣA
AAffA֏\AGA{AffAffA=qAۮAAۮAffA
=AAGA{AܣAA{AQA
A  AAݙA{A{AB=qA  AQAAAHA(AGA(AظRA
=AApAGAA
=AHAۅAۙA{AAA݅AA(AzA޸RAAHA
A߅A{A{A߮A  AffA=qA(A=qA(AQA\A(A޸RAHApAzAGA߅AݮAA\)AAzAAݮA܏\A  A(A{A{A=qAAݮApAA(AQAܣA=qAGAAQA\)A  ApApAHAظRAָRA(AծAәA֏\AA
AAQAAzAAzAAׅAffA=qApAAۙAffA  A
A{AHAHAٮAzAAQA=qAA{A{A
=ApA  A{A{AGA=qA܏\AAAAHAzAffA(Aڏ\AA33A
AGAۙA\)AAQAA\)A=qA
A\)AffAݙAA݅AۅAۮA33AHAGAظRA\)AۙA݅AQAڸRAAzAGAAיA׮ApAA  A(AAffA=qAA  AAHAAA
=AԸRApAԏ\AљA=qAGAAzA֏\A33ApA(AAGAٙA  A\)A
=A{AָRA(AAQAAHAA\)A=qA؏\AٙAڣAۙAܣA܏\A܏\AݙA
A\)A(AA\)AAAA
AAA
AAAߙA
A(A  A{A\)AGAGAHAޏ\AzAQAA  AݙA
A=qAظRA  AۮA{AA޸RA؏\AA  AۅA\)AGAיA  A
=A  AHAAׅA33AzApAGAծA  AAQAQAQA
=AAAٙA33AAA
AffA׮A{AAHAzA33AGAܣAQAGA{A\)A\)AAffAffAffAHAٮA
AAGAAۅAۅAۅA  AQAAAHAGAGAAޣA߅A(A߮ApAAffA
AAzA\AߙAA(AAA  A  A{A
=A
=AGAffAمApAܸRAzA߮A{AAGAGAHAffAQAAٙAݮAڣA=qAٙAظRAA  AffAAHAffA33AٙAڏ\AA33AAffA=qApA݅A؏\A{AffAHA33AGAHAGAHA{AܸRA(A
AQAٙAA33AA
=AA{Aڏ\AڸRA
=AۮApAAzAAffA{A  A=qA=qA=qA\AAGA{A33AHAA޸RAޣAQA
=AGAAHAA{AffAAQA
=AAޣA݅A33AޣAAGA(AA  A߅A=qA\)A\)AHA
AAAA=qAۅAAڏ\AHA\)A(AAأA؏\A{AڣA(A\)AzAHA
=AQAAzA(AzApAՙA{ApAAffA=qA  AׅA؏\ApAۅAۅAzAffAzAAAAHAGA33ApAڏ\A܏\ApA=qA
=AAA33ARAGA
=AA\AAAᙚAA
=ARARA
A
=AA޸RAzAffA  AAGAGAޏ\AzAQA
=A  A
AQAޣAA߅AzAGAAޏ\A33Aޏ\ApAAߙA߅AA  A߅A݅AzA
A=qA޸RApA(AA  AApA
A(A=qA=qAA33AzAA\)A\)AAܣAHAApAAAAffA܏\ApA޸RAzAޣA  A߅A߮A  AAAޣAffA{AA33A
=AffAAAᙚA(A(AA  A=qA=qA(A(AAApA  A\AQApA\)AA(A=qA(AᙚA33AffAA=qA\)A\A
=A33AHAAAAGAAGApA
AAQAAA\A(A  A
A
=AHAܣA܏\AzAA  AAGAAffA
AAzA
=A  A\)AGAA(AzA{ARAAGAA\ARAA
=A
ApA߅A߮AߙA߅A(A\AAffA\AA\)AAQA  A(A  A\AA\)AzA  AA  A  AGAffAA\AAAARARAAffA㙚AAA{A=qA(A\AߙApAAARApA\)AAzAGA㙚AffAAQAQARApAA
=A=qA  AݮA{A33AAA
=AApA\AA{ApA
=A܏\AڣA
AܸRAAܸRAAHA{A\)AA߅A\)AGAQAݙAAAffAݙAzAA܏\AܣAA
=ApAߙA  AzA
AGA33AݙA݅A\)A=qAHAzAA\A=qAffAA߮AffAA߅A߮A{AA=qA{AHAܸRApA=qA\)A\)A(ApAمApA\)AGAظRAzAٮA\)A؏\AHAAAAAأA=qA
AAA܏\AAAܣA  AۅA
AffA=qAffAA(AHA
=A=qAGAA=qAٙA33AHAffAݙAHA
AHAHAGAAٙAمA\)ApAׅA{A=qA(AQAQAAיA(A33A
=A׮A
A  AAGA33A=qAzA=qA=qA=qAQA޸RAzAA=qAAHA߅A߮A߅AHAffA(AAHAA\A\A\A{A{A{A߮AA
A  A
AGAAGA=qAAAA33AޣAAHA޸RA݅A33A\)A33A(A{A߅A33ApAGA޸RAAۮA\)A(A
A=qA(AGA
AffA
=AffA޸RA݅A{AApAGA{AޣAޣApA߅A߮A߮AAޣA\)AAHA=qAHA\AA
A  AzAffAA\)A=qAA(A\AffA
AᙚA{AApA\)A33ARAޏ\AQAHAᙚAA݅A߮A=qA\)A=qARAA
=ARAGAQA  ApA=qAޏ\AA(A{AGAA  AߙA  A\)AffA\)AA33Aޏ\A܏\Aޏ\AAAGAQA޸RAޣAAA{A\)A=qAffAAffA܏\AAQAAޏ\AܸRAޏ\A33A߮A(AߙAQA(AffA  A=qA
AffA
AA߅AAzA
AHA  AAߙAffA33AA{AffARA\)AA
A{AzAAAAHA\ARAA噚AA\)A
=A噚AA
=AA\A{AffAffA=qAA
=A
AzA\AGA
=ApAGAA  AAzA
=A(AHAAAA
=ARARAffAAApAAHAAQA߮AffAA
A33AQAffAffAGA
AA(AGAHA{A(A
A\)AGAAA{A33A(AAAAA33A
A=qAAAAGA
AQAAGAA{AffARAHAA
=A\)A癚A癚AGAA\)AA
A\)AAA\)A=qA
=A
=AA\A\A噚AGA(AAA  AQAffAQA(AAA噚A噚A噚AAA=qA  AAAffA
=AAAAAApA=qAHA33AHA  AAAARA  A  AffAA=qAܸRAAAۮA(A\AAGAzAAAGA㙚AAAA
A(A33A\AzA㙚AQAAAARA\)A  A=qA\AAAAA\)AA{AA  AAAHAAAffAAHAQAApAGAA  AAA=qA\A{AAAARA㙚AGApA  AQAzAA
AAA㙚ApApA{A=qA=qApAA=qA33AQA\A
=A
=AۮA܏\AAffAApAHAۅAۙAۅAGA\)AA33Aڏ\AAGA
=AHAA
=AۮA(AHA  AGAA(A\A
A߮AA(A=qAGAAHA
=A޸RA{Aޏ\AޣAA=qAA  A߮ApA޸RA߮A(AffARA(AGA=qA
A  AAzAA33AAA33Aޏ\AAAAᙚAzARAzA(AzA=qAڸRA=qA  AAAܣA
AffA(A(AzA(AݮA݅A޸RAޏ\A{A
AffAܣAHA(AA
=A
=AݙA޸RAHA\)A{A(A=qA=qAAHAA33A33ARAApA\ARAHAAQAHA
=AA{AA
=AAGA33A
=AARAA33AA\)A(AAA(A\AA=qAA  AGAAffARAA
=AAAGAA\)A33A\AAGAA=qA\AAHA(AܸRARAAޏ\AGApAޏ\AߙA\)AݮA
=AzA(A\A{A߅AAܸRAܣA  AA  A33AA  A\)A  A\)AۅA
=ApA(AzAHA\)AݙAݮA  A݅AGA\)AGAA(A
=A\)AGAᙚAᙚA{AQAffAzAAAQAzAzA\AᙚAHAzAAAAHAffAQAAA  A
AAᙚApAAA
AAAA33A\)AHAQA
=A
=A33ARAA(AA33AAffAAQAQA33AޣARA\)A  A
AHAᙚARAAA(ApA  A݅AܣAGAߙA=qAAzAޏ\A33A(A(AݮAܣAݮAݙAA
AݮA޸RAHA
=A33A
A  AffAGA\)AAQAAGAAA=qA߮AQAffA=qA\AAzAA33ApA{A=qA33AAAAApAffAQAAGARAAAᙚAAAA(AA
AA=qA(AAffA
A(ApA{AAHA(A(AzARA
=A33A  AzAA
AzAQA(AffAAAGAGA֣AA=qA\)AޣAGA޸RAݮAۮAAHA
A\)A
A=qA\)ApAzA33A  AHA
A
=AApA  AA݅A  AA߅A
AzAffARAA\ARA(ARA\AAGAGAGA33AGAAQARA=qAAAARA\AAޣA(AA޸RAߙA=qA  A  A
A\A(A\A(AGAA{A\)Aޏ\A\)AffAޏ\AAݙAHA
AApA=qAڸRAڣAڏ\AיAGA(AffApAGA޸RAޏ\AzAܸRAAܸRA
=AQAAA33A߅AQAGAܸRA݅AݙApA(A  AGA33AGAݙAA  A\)A  A(AAڸRAffAܸRA\)AݙA  AQA=qA33A(A  ApA{AۙA{AQA\)A\)A{A{AzAA{AAffA  A
AAQA
A؏\AQAۮAۅAA{AܸRA\)A
=AAffAGA
A
=A(AQA؏\A(A׮AAׅAffA
A=qA(A
=A(A  AffAffA  AمA
=ApA\)AمAQAzAׅAمA{A{A{A
=Aڏ\Aڏ\AڣAA
=A֏\B	
A  A׮A{AأAHA(AڣA(AۅA܏\AۅA  AمAظRAAڏ\AApAGAHAAܣAAAܣAA33AA33AApA=qAQAܣA=qApAHAHA
AיA
A
AA33AׅAA33A׮AQA(A؏\AمAHAAzA=qA33AApA
A{ApAAffAGAAأAיA{AAA  AٙAffA=qA  AAAٮAٮA\)A=qAQAA33Aڏ\A33A
A\)AHAAffAۅAٙAAGAA  AGAAAQA{AܸRAAܸRAAffAzAAAA޸RA{A
=AGAA=qAAApApAA(AA
=AA\)AffAffA㙚AAAA\ARAAARA(A  A{A=qA
A  AffA\AQAAA(AQARAAApAQAۅA33AA
AAأA33AڣA\)ApAHA
=AAڏ\AffAڏ\AffAzAڣAAمA=qAڣAAۅAGAA  AأAA  AۮAffAݙA(A{AۅAٮA݅ApAAAffAAzA(Aޏ\AݮAHAA܏\A{AA݅AAA{A(A=qA=qA{A  AA߮A߮A  AA=qA޸RAHAܸRAzAA33A  AGAQApAHAٮAQA(AGA33AAAAA33AۙAGA33AGAQA  AۮAAAGA
=A\)AۙA܏\AٮAffAٮApAA  A33AGA
ApA\)AzAGA\)AׅA\)Aڏ\AٮAzA  AzAأAAGAA
=AָRAzAzAՙAָRAׅA
AיAA33AיAAٙAAأAAHA{AffA\)AAHA  AHA=qAHAA\)AAAApA߮A
=AAzA\AffA{A  A=qA=qA(A\AA\AA(A(AAzAݙAA=qA33AA߅AAAzAGAޏ\AݙAffAAA
AHAA܏\A
=Aڏ\AzAzA=qAHAHAHAzA
AٮA=qAffAAAՅAQAHAڸRAQAGAA
AHAffAHAڸRAHAݙA(A  AٙAڸRAA{A(ApAۅA=qAڸRAApAمAڏ\AQAQA߅AzAAAGA\)A
AA\AHAA=qA(ApApAޣAAAHAGA  ApA\)AAߙAHAGA߅AA  AۮAۅAۅAAQAٮAA(A
A(AQAAHAۮA{Aڏ\ApAAAGAأA=qA33A=qAAڏ\AAAܣAܣAA(A(A֣A33A  AGAָRAAAݙA\)AzAٙAظRA=qAGAAQA\)A{AGA  A(AA
AffAzA߅AzA{AzAAAᙚAAQAAGAGAAAAAAHAHAAHARA{AQAARAQAzAA
AQAzA\AzA
=ApA\)A
=A{A
A
AffAᙚARAHAA
A=qAۅAQAzA(AAzAQAHARAApAA݅AA\)AأAHAAffAڏ\AHARAzAAA  AGAۮApAA\)AGAzA
AA\)ApA
AܸRAAGAA=qA33AQA߅A
AA  AAAA33AA  A
A݅AAQA\)ARAA\A=qAffAA
AA\)A=qA\A(AApAQAAޏ\A(AAᙚAᙚA\)AAzA=qAAܣAzA=qA
AٙA(AۅAڸRA݅AffA(AAAۅAA33AAڸRAffAAA
=AAHAGAظRA؏\AA\)AGAA
=AأAAA(AA(A33A
AA
A{AۮA=qAܸRAۙAzAHAAAA(A  AffAGA{AܣAHA\)A  AffAAߙA{AA
=AAޣAAAޏ\AHAAAHAHAHA޸RAޣAHAAAffAޏ\ApAGA(A33AᙚA
A{A(A(AQA
=A=qA\AAAA\)AHAޣA
=A
=ApA  A
AA(A  AA\)A(A\)AQA
=AGAA
Aޏ\AܣA߅A  A߮A33A\)A{A{ApAApApAApAffA\AA33A߮AHA
=AHAQAAܸRAzAܣAGAݮAffAޏ\A
=AGA߮A{A=qA=qA=qAzA{AARAA33A݅AA33A\)AA
=AٮA(AffAܸRAGAQAzAAQA33AzAߙA޸RApAGAAGAQAAA
=A(A\)AڣApAӮAAHA=qAAՙAA(AՙAAffA(AԸRA(Aԏ\AAҸRAҏ\AAׅA
AGAAffAAAAۅAܸRA  A\)AA=qAHAffAأAٙAڣAA(AGAۙA
=AAڏ\A33AGAffA(AA
A
A(A(A\A\AQApA\)AQA\)AffAzAGA
AGA
=A݅A  AA  A
A33ApAffAA
=A(A\AAGAAA  A=qAA
A{AᙚAffAApAA\)AA
AAᙚA
A
A
AAA(AޣAA=qA33AzAۮA33AzA
=A\)A(AAڏ\A֏\AAffAA  A{A\)AA
AAܣA=qAGA݅AݙA  A  AHAA  AA=qAGA  A\)A{ApA(A\AHA{A{AQA=qA=qA(A(A  AA
=AAQAQAzAQA\AffA\AAzA=qAApAHAAA\)A\A\)AA\)A\ApAAAAᙚAGAAHAݮAޏ\A{A޸RAHAHA  AޣA=qA݅A{A\)AݙAffA݅A\)AffAܸRA{A܏\AAA\)AHAzA\)A33A܏\A  AۙAڸRAA33A(A܏\ApA޸RAHAGAA(AAffAܸRA\)AAQAܣA
=AܸRApA  A=qAA߮AA{A(AffAzAzAzA(AAA  A(AQAQAQA  AHAߙAAffA=qAGApAA
=AffA݅AܸRA\)AAApAAApA  AQA=qA
AffAARA܏\AGAHAۙAHAۮAA  AzAHAAA\)ApAݮAA
A(AQAٙAA(AأAzA  AHA
AHAٮA33AمA
AGAۅA\)A  AQA\)AڸRAffA  AffA\)A
=AڸRA
ApAzAA\)ApAA{AA
=A33AA33AA
=A33AQAܣAAAA\)ApAݙAzAۮA33ApA33A\)A{A܏\A\)AݙAܸRA\)AܸRA  ApA\)AGA33AڸRA
=Aޏ\A=qAޏ\AzA
AzAܸRAHA
A
=AAA{A=qA=qAAA
AGAA=qAffA
AHA  AظRAAffAQAׅAיA(AAffAzA33A=qAAڏ\Aڏ\A33AظRAظRA
=AAٮA
AAٙAأAGAAظRAAڏ\AffAQAffA33AA33AݮAA=qA޸RAޏ\AAQA33A
=A33AAffA33A=qA  AGA߮A߅A
=A  AffApA33AAffA܏\A  AAQAQAHAأAffAffAظRAٮAمAAAHA=qA
AQA=qAمAGAA\)AGAzAffAHAGAHAGAӮA
AA  AQA(AA֏\AAָRAA֣AָRAffAיA֏\AAӮAA=qA(A
AQA(A{AffAAQAׅA
=A\)A\)AAAGAׅAAffA؏\AٙAzAٮAQA{AzAAzAڸRA\)A\)A33A
=A
=ApAAGAۅAA33A
=A(AQAָRA33AָRA(AظRA=qAڸRAڏ\AzAAHAAA{A\)AمAיAָRAQA(AGAԣA{A  AApAAӮA\)AA
=AHA(A{AffAzApAApAҏ\AzA33AҸRAA  A=qAңAHAңAәA
AzAAAӅAGAHAQA{A\)A{AGAGAиRAՙAA  A
AՙApAAA֏\AָRAzAffAQA(A֣AָRAָRAzA
=AffAffA(AffA֣A
=AzA׮A{A  A(A؏\AHAأA  AAAAAAծA33AAA{A
=AzApAAffAӮAA  A  AУAzAffA(AAA
=AAGA
AхA=qAծA=qAHAHA\)AAffAGAffAAיAzAffAA(AӮAffAָRA(AҸRAAAAQA33AAӅAԏ\AA  A׮A=qAٮA=qAHAڣAGAGAۅApAAGA  A=qA  AA=qA(A{AzAzAffA޸RAffA(AzAGA(Aޏ\AzAA33A  A܏\AۅA(AGAGAAGAGA\)AۮAA{AأAӮAA33A  A
A
A
AAAAAۅA\)Aڏ\Aڏ\AApAAۙA\)AGA33A
=A
=A
=AAAAۅA  A
AQA=qAQAܸRAGA޸RA޸RA޸RAAߙApAAAQAA(A(AAAGAAAGA
AAARARAARAzAzAffAffA  A
A{AAQA
A=qAQA(A{A(A=qA  AAAA=qAߙAA
AGAݮAQA
A߅A  A  A
AߙA
AGAQAGA߅AߙApA޸RAݙA߮AޣA{AffAޏ\A{AHA\)AGAܸRAAffAۮAܣAٙA\)AA(A\)ApAGA  AأAAA׮A׮AיAA{AAzA  A(A{A
A=qA=qAzAAׅAAA֏\ApA
=AA؏\A؏\A(A(A\)AzAffAzA(AffA
AԸRA{A
ApA
AA
=AA
ApAApAHA(A{A
=A׮A33A(AAAHAA(AיApAGAGAA(Aҏ\AzA
=AffAAծA
A
A(A֣Aԏ\AԸRAθRAA֏\AQAA  AԣAHA
=AAGA
AәA{AхA(AՅAңA33AHA
A
AHApAffAGA=qAAffA  A  A֏\AظRA{AQA33A  AQAzAܸRAܣAܸRAA33A݅ApA
AAGA
=AA=qA
=AffA33AGAۙA(AGA  A=qAAأA(AQAffAAQAڸRA33ApAۅAAAܸRA
AGAzA33A
=A؏\AأA=qA  AGA
=AHA(A(AծA\)AՙAԏ\AAAAAHA  A֏\AApAңAAAAGAA=qAA{AA\)A֏\AGAffApA׮A  A=qAA=qAHAٮA=qAA{ApAA(AQA=qA=qA=qAA33A\)AA  A\)A݅A{AzAHA\)AHAۅAڣAݮA33AܣA
=AAA(AܸRA߮Aޏ\A=qA݅A=qAAQAffAGAHAHAGA߮A޸RA33A
ApAA=qAffAffAzA
AffA
A\)AיAApApA
=A\)AA  AA  AمAA(ApAGA{AAQAAAݙA  A=qA
=A
AGAAAAA33A\)AAzA
=AۙA=qAAݙAGAAQAAAޣAffAQA(AA߅AAAߙA߮A  ApA  A\)AAAᙚAޣA{A(A
=AHAA33AA
A{A\AA
A  A
A  AffAAA
A\)AA  A  AAAA\)AAHA{A\)A(AA{AߙARAHAffAۙA\)AڣA
=AffA
=Aޏ\AAA
=A\)ApA\)ApAAffAA33A\)A
=A{AAA33A  ARAAA(AffA33AᙚAAA  A  AQA  AffA\AGA
AAAHA
=AHAHApA
AA\A(A
A  AAA
AAAA{AA
A\AQAA噚AffA(ARAA\)AffA
A
=AAQAQA=qAHAA{A\)A33A݅ApAApA(AGAޣA  A33AffAffAQAָRAAָRA=qAA(A33AܣAޣAQA  AQAQA
A޸RAHAA
=AGA\)AAAAܣA(AffAAA(A=qAGA
A=qAAݙAAHA߮AQAffAAߙAޣAA(A
A
=AA=qA{ApAݮA=qA  AA33ApA=qAA{AQA\)AߙAA߅AޣAffA=qAGApAمAظRA(A
=A
A\)AٮA(AAzA؏\AffAأA\)A33AzAQA=qAQAAأApAAمAٙAٮA\)AA{A\)A؏\AGA  A(A(AHAָRAHAffA(A
=A  AָRAGA{AAA֏\AQAzA؏\AAأAzApA
A=qAHA=qAAAޣAޣAޣAA=qAffA޸RA޸RA(A{A(AGAܣA{AA
=A33AAzAQAۅAۮAGA33A=qA(AQA޸RAޏ\AޣAޏ\AHAA{A33ApAAzAzAޣA{AA߮A߅A\)A
A
Aޏ\AffAQA{A\)A
=A=qApA܏\A{AمAGAܣA33A
AQA(AܣAA33ApAQApApA=qA܏\A
AffApAA=qA33AAGA{AظRA
A
A33AأApAApAA(A݅AܸRAܣA߅AHAHA߮AffA߅A
A  A{A  A
A  AHAAAffApAA߮A
AAA߮AA=qAA\A=qApAAHA
=A܏\AffA(A=qA{A  A=qAffA  AمA܏\AHAAA  A؏\AٙAٙA܏\AHAܣAffA33A
A  A\)AׅAzAffA֣AffA֣AՙA
AA=qAApA33AGAQAAׅAA׮AAQA(AGA\)AAzAffAA{A(AۮAڸRAAA{A܏\AApA
AAHA
=AApA\AHAAHARAA=qAGAA33AAᙚAAAA
AAAHAffApA߅ARAA\A(A{A
=A\A߮AQAA
AAAߙAGAޣAA߅AݙAHA߮A߮ApAAQAمA
AffAGA33A
=Aޏ\AHA
AمA
A
AGAA=qAۅA  AAܣAffApA(AHA݅ApAffAQAA
AڸRAڸRApA(AffA
AHAHAڣAAڸRAQAAAڏ\AA  A  AAAA33A݅A  Aޏ\AAݮAޏ\A(AQA=qAzAGAAffAAA܏\A(A(AٙAAGAzAHApAA
=ApAڣA
AffA\)A
A\)AA=qAAQAA܏\AQAڏ\A{A\)ApA{AظRA  A
ApAHAׅAQA=qAQAAHAAۮAA(AGA
Aڏ\AA֣AzAAمAAGA=qA  A(AzAAٮAڸRAffA=qAۮAA{A\)A=qA(AffAzAQAzA޸RA\)A(AA
=ApAA܏\AA
AA
=AAA߮AAA  A
A
Aޏ\AzA֏\AۙA߅A  A33AAٙA33A(A{AffA  A
=AAܸRA\)A=qA(AAGAA
=A=qAޏ\AAA܏\A(AHApA\)AA\)Aڏ\AٙA33A{AAمAڸRAA  A33A{A{AڣA{AAffAQA=qAQAA{AAܸRAݙA\)A
A
A  A33A߮A߮A(AzARAAApA߅A\)AAᙚA\)AA
A߅AHAQA\A33A\)AݙA\)AA  A=qA֏\AGAޏ\AAڣAAA
=AzA
A
AzA  A؏\A
A=qAٙAۙAGA(A
=A
=A{AffAA݅A
=A\)AA܏\AGApAծA{A
=AQA
=A(Aڏ\A(A  AԣAGA  AQAHAיAQA(AAAAA
=A(AAGA{A{A  AzAQAA܏\AzAܸRAA݅AGAAAޣAA\AApA(AQAAGA  A=qA㙚A33AQApAAQA\)AA(AAܸRAAGAAQA
A߮AAQA
AAHAAApA\)AᙚA=qAGAApAffAܸRAffA݅AڸRAffA  AAڏ\AAQA=qAA
AA֣A
A{AAAׅA  AظRAQAأAمAA=qA
=AA(AޣAA
AGA
=A
AzA{AA{AޣAݙAApAzA  A  A=qAQAܣA\)A=qAA=qAAffA=qA=qA33AᙚA(A{A\AApAAA=qAzAAzApApA\A=qAAAQAzAAᙚA{AA
AᙚAߙA=qAAAzAAA(A߮ARA\AHA\A߮AAQAzAޣA  A(A߮AޣAޏ\ApApAޣA
AݙAA  ARAݙApA޸RAߙAHA  AۙAܣAܸRAݙAݮAA  AݙA\)A
AApA
AߙA=qA
A\)AzAHAޣA܏\A܏\AܣAffAApAAQAAA߮A߅AAA  A=qA(A=qAQAzAQAHAzAAAffA
=AᙚA{AAHAA(AAA{AffA\)A{ApA\AHA
AHAAA
A
A33A߅A
=AzA  AݙAHAܣA\)A\)AGA
AffAAأAzAٙAAܸRAGAۅAQA\)AܣAGAAA33AA
=AGA=qAA߅AAzAAߙAܸRAݮAQAݙAAA\)AHAHApA߅AzAAAA  AffARA
=AAffAQA  A(AQA㙚A
A{A=qAzAzAzARAzAzAQAffA{A
AGA33AGAᙚAzA(AzA{ARA33ARA\A=qAA\)ApAߙAzARA=qA
ARA
A\)AGAHA{A  A
AA܏\A
=A
=A
A
=A  A  A33A(AA\)AGAݮAHAAQAAA݅A  AffA{A=qA  ApA\)A(Aޏ\AHAAzA\)AGAA  AڸRAGA
=AzAHAA(AA\)A33A  A(A(AܸRA  A\)A33AHA=qA
AAA݅AHA
A\)AA(AمA(AۅAAAA=qAffA\)AHAffAzA{Aڏ\AA܏\AQAܸRA=qA33AAQAffAQA=qA
=Aޏ\A
A=qAQA(A=qA33AߙA  AA(A  AA\AA
=AA
=AߙAߙA  A=qAٮA
AۅA
A\)AffA
=AffA޸RA=qAffA=qAޣAޣA33AGAGAA߮A(AݙAAA{AڸRAGA؏\AأAA  AAQAA{AzAA(A{AQA׮AׅAAffA{A  AA{AAQAٙAAzAffA(AݙA
AܸRAڸRAAܸRA݅AGA\)AٙAHA\)AAHA
=AAAۙA{AQAٮA\)AAظRAzA(AQAAA33A{AA֣ApA(A
AffA=qAأAA33AڣAA
=A
AffAظRAGAQAۮAzAڣA{AAGA33A  A܏\AGA
AߙAA܏\A
=A=qA{AHAٮA
A܏\AApA
=AQAڣAڏ\AGAAGAۮAۅApAAHAۅA
AA{A
A
=AGAHAAۅA܏\ApAffAzAffAڣAڸRAAA{A\)A33A\)AffAHAAظRA
=A
=A{AٙAA\)AA=qAAAGAffA=qA{A֣AQApA(AԸRAA؏\AӅA(AAffA{AՙAAzA
A{A{A=qA
A{AA׮AA׮AHA  AAڸRAAzAQApAApAمAHAٙAAأAׅAAffA=qA֏\AAׅAA  AAۅAGA\)A  AA33A\)AAQAٙApA(Aڏ\AGAAڸRAGAٮAۙA\)A33AڣAzA\)AظRA=qAAApAzAۮAHAHAٮA(AٮAأAffAffA{A{A
AffAAAGApA\)A
=A
=AיAffAָRAיA{AA֏\AA
=A׮A33AAمAGAٮA
A  AQAיA
AGApAׅAHAׅAיA
AQAApAمA{A=qAڣAA\)AۮAۙA\)AۙAzA  A  A
A(A
AAۅAۅApAHApAA{AܣAA
=AAAHA
=AٮAڣAAGAffAQAA
=AzAffAAٮAGAمA
=A(AAٙAGAمAיAAHAAՅAծAzA  AAAHAHAffAA֏\A
=AA
=AGAGAAظRAGAمAA؏\AGAffA33A֏\A؏\ApA
A=qAA{A(Aڏ\A\)A  AAzAAۮA\)AGA
A{A  AzAA33AݮAݮA{A{AAQA޸RAAffAAߙA߮AQAffA{A߮A  A
A܏\AAGAڸRAffA{AۙA
=AHAA33AffA(AA
AffA(A(A݅A݅A
A
=Aޏ\A{ApAA{AA\)AHA(A\)AAffAAzA
AQA֣AمA33AzAA  AffAԏ\AA{AAA  A
=Aڏ\AAأAQA  A
=A(AAAHA
=ApAAzAAA{AHA
=AA
A{AQA޸RAޣAAHAޣA\)AGAAA
=A
=A
=AHA(A{A߅AAA
=AAޏ\A  A޸RA޸RAzA=qAޏ\AA߅AA  A{A(A
A߮AA߅AAAApA߅A޸RA(AQAffA(ApAQA޸RA\)AۮA؏\AA=qAݮAffA
AHAHAQAQAAzAQA=qA޸RA
=ApApAAA=qAۙAAzA߮A\ARAAGApAܸRApAQAzAAۅAڣAٙAHApA  AzA(A=qA
A\)AAffAzA
ARAڣAGARARA  ApAzAGA33AA33A
AApA=qA{A  A(A{AAAffA(A\)AA{AQAAzAAAAAQAAzAAzAAzAAAzAAzAۙAHA=qA
=AA
=AݙAzAQAGAݙAQAA\AHAzA߅AA߮AA܏\AAGAGAޏ\A
AۙAAظRA؏\A(AGA  AQAA݅AܸRA33A33AGAAQAA{A݅AܣAHAڣAAۮAGA33AApA  AAޣAޏ\AߙAAA=qA{A݅A33A
AۅA
AzAHAQA{AA33AzAޏ\AGAQA
=AQAޣAQAAQA{A
=A\)AApAHA=qAA  A\)A
AA=qA{A33AAA
=A{A݅A
=ApAAڸRAApA
AمA؏\AHA
=A33AأApAffAHAظRA؏\AApApAA{A(AffAffAޣAޏ\Aޏ\AޣA33A
=AAHA޸RAޏ\AffAffAzAA߮A\AffA{A{AffAQARA\A(AA\)A  A
A33Aޏ\A33AA33AGApAApAA
=AA߅AQAݮAQAGA(AGAzA=qA=qA  AAApA(A؏\AAAAיA
AٙA
AffA(A33A{AՅAAA\)A
=AѮA
AAAQAAGA
AffA
AQAHA  A  AAAffA(AHAAۮAAAQA܏\A  A݅AGAzAA(AffAA=qA=qAGA܏\AAGAGAAAAffA33AA  AAQAA
=A\)AffAڏ\AAA  AGAۙAAHAڣA=qA=qA{AAمAffAAיAA33A33AAA\)AQA{AGApAԏ\AAGAAHAHAأAأAffAHAHAٙAffA
=AAܣAA܏\A{AA\)Aڏ\A\)AHA؏\AAzA=qAA
AzAzAمAGAA33AڸRA
=ApAۮAA(AffA܏\AHA
=AA\)AHAHAHAܸRAܣAAۙAA\)A܏\AAHAܣAGA\)ApAAAޏ\AAA޸RA(AzA(AAۙAffAAAAGAA(ApAffA
AHAHA(AzA\)AAAۙAffAمAڣAمAAٙAA\)A(A
A33A  Aҏ\A=qAA{A
=A֣A  AיAظRAAۅAۙA{A{AA
A
AA݅A\)AٮA  Aڏ\A\)A{A33AAAzAAAAGAݙA33AA33A  AܣAA݅A݅A܏\AA33AffAAGAׅAۮA\)AQA=qAHAAHAHAAffA(A(AGAٮAٮA
A
A(AۅAffA\)AܣA=qAمA
=AA
A(AAAڸRAڣAڏ\AAGA=qAffA{A=qAAffApAՅAӅA33AffAAQAAظRA
=AA33AAGAAHA33AمAٙA
=AՅAzAAffAمAA=qA
AأAffAمAۅAHA\)A=qAAApAAمA
=AHAAzAffAظRA؏\AQAظRA(AAHAAHApApAڸRA  AzAffAQAffAAA{AڸRA{A{AAAGAAA=qA  A=qAGA(ApA\)A܏\AA(AٮAٙAffA  A(A(AAمAمAA؏\A׮A
=AָRAׅAAffA\)AA=qAٙAיAA(AAQAՅA33A  AQA\)A(A{AA33AָRAffAHA(AمA  AHA  ApAٮA
AAzA  AzApAHA
=AAAأAظRA  A\)A֣AA
AٮA33AمA
=ApAAٙAۅA
=A(A
AzA{AAffAڸRA33AۅA
AffAQA\)A=qAمAׅAָRAzAzAAAԏ\AQA(A  A=qAffA
AffA{A33AGAAљApApA33AQA
=A  AHAA\)AA  AظRA  A33A
A  ApApA  AApA33A33AQAA(AA؏\A\)AffAA
A{AffAA33A
A=qAA(AܸRA܏\AܸRA=qA=qAڏ\Aڏ\AمAڸRAffAzAAQAޏ\AݮAffAݮA  AAffAzA(AHAޏ\Aޏ\AApAAAGAAA  AGAڏ\Aڏ\AffA(A(AGA
=AٙAڣA=qAۙA{AAGA(AzAAGAGAffAHAHAHA\)ApAԣAԸRAAٙA=qAA؏\A\)AffAzAHAGA\)A֏\AA֏\AָRAיAzAApAAQA  AQAGAHAffApApAٙAمAA(A(AQAיA=qAٙA  AٮAQA\)AٙAمA(A{AAۅA=qAGAHAAAڣAQA33AAffAzA=qA33AA
AApA(A=qA{A  AffA=qAQAڸRAzAڸRA
A=qAHA(AGA׮A֏\AA  AAծApA
=A(AA
=AGAAծA֣AQA֣A֣AA\)A33AAׅAA=qA33AffA=qA֏\A
A
A=qAԏ\A(AՙAAָRAAיAHAA=qA
A=qA(AՙA  AՙA(AָRA֣AGAHAffAHAظRAQAHA\)AHA֏\AׅAAQAׅApAA\)A
AffA(ApA\)A(AzA(A=qA{AAA(AQAA
=AA  AzAzA=qApAAңA=qAѮAQAѮA  AׅApAffAָRAA{A(ApAԸRAҸRAѮAA
A=qA(AffAGAGAָRA33AHAffA{A
AAՙAA\)A
A\)A
=A
=A
=AՅAԸRAApAՙA=qA
=A
AA{AׅA׮A
AAٙAGAA(AffA  ApA  AA\)AAffA
A֣A\)AffAffAծA\)AمA؏\ApA(AffAA  A(AAA֣A֏\A֣A=qAAApApA33ApAGA33AGA\)A  A؏\A{A  AAGAٮA
A33AՅA֏\AA33AGAָRAffA
=ApAGAՙA=qA
AԸRAHAQAׅAAAظRA׮A\)A=qAGA  AQA׮AׅA33AA=qA=qA33AffAA33Aڏ\A܏\AܸRAܣAGAAܣAAۮAAAۮA
A
=AGAzA=qAQA
A(Aޏ\A݅AׅA=qA  A33A33AA
AffAٮAA{A{AיA(A܏\AA\)A(A(A
AأA؏\AظRAיAAA33AzAHAܸRA33AۅA(AAA=qAיAָRA
AAӅApAՅAGA(AAzAzAԏ\AGAffAA
AڣAffAܸRAۅAۙAzAظRA؏\AHA(A(AzAڸRA
=AA33Aڏ\A=qAٮApA{AڣAHAApAA  AAڏ\A{A  AGApAأA
AA\)A(AA=qAffAHAՅAAffA(AGAAAיA{AڣAzAڣA
=A=qA  A33AQA(AQAGAAA
AHAApAAQAAHAApA=qA=qAиRA=qAffAAffA33A=qAApAHAAAՙAHA{AAffAיAAծAָRA
AzA=qAGA(AׅA33AAffAGAAA
A  AڸRAܸRAݙAHApA߅AA(AQAzAQAAffA݅A=qAA(A33A{AܣA܏\AݙAݮAAGA݅AA
=AAAzA33A(AۙAۮAA
A
AA
AۮAۮAzA(AAAQAA  A؏\A(AٮAمAAAAA  AAٮAGAffA
AָRA33A=qAA=qA33AAׅA
AzA{AָRA\)AA  A\)A
=A=qApAA׮AأAٮA  A(AQAڏ\A
=A33AAffAzAffA(AAۙAۙAffA
AffA
AHAHAGAAߙAffAA\ARAA߅ARARAzAA
A33A\)A(A܏\ApA
AQAAHAGAܣA
=ApAAۮA
=AAffA
=A(AA
=AۮAڸRAۮA  ApAۙAݙAGAۙAA
AGAۅA{AۅAGAAQA(A
AAAܣA
=AܸRAHAGAQAAڣAۮAGA{A33A
AHA
A=qA\)A\)AٙA=qAzAڸRAGAAzAA=qA܏\AffAffA܏\AQA=qA܏\AzAffAAffA
=AݙA݅A\)AzAGAffAHA\)AffAظRA33Aڏ\AAڣAڸRAA
=AۮA(A\)A=qAܸRA33AܣAۮA܏\A33AݙAݙA(AA33AߙA߮A߮A߮AA߮A߮AߙA߮A߮AQAQAޏ\AޣAA  AAHA
ApA߅A(A
=A33A(A߮AAߙAA  A{AHA
=A{AݮAGA߮A߅AAAGA=qAffA
=A(AA(AGAA{AffA\AAAAA
A  AQA\AAAffAA(A33A
=AAffA\A\AzAA  A(AHAA\AAffA  AᙚAA  AᙚA=qAHAᙚApAA
AGAA
A(A{A  A\)A  AA
A
A{A(A(A(A  AApA\)AApAA\)A\)AGAܸRAٙA(AAzA33A(ApAA(A(AA33AޣAޏ\AHARAzAffAHAAGAAzA\ARAAA
=AffAߙA33A
AݙA݅AݮA
=AHA
=AffA33AApApA  AAA{AA=qAQA߅ApAHAAڸRA֏\AQA(AA
=AHA
=AGAAA  A33AGApAzAڸRAA
=AڣAڏ\Aڏ\Aڏ\AڸRAAA=qAۮA
A(AffAzAHAHA݅A݅AڣAQAAܸRAۙApA(A=qA33A{AAAHAAA  AffApAffAQA(AGAӮA{AffA33AzA{AffAӅApAHAffAҸRAHAffA(Aԏ\AffAA(AA؏\AAA  ApAՅAGA{ApA{AzAzAGAۮAzAA\)A{AٙAأA33AAAڸRAzAHAA
ApA
=AGAHA܏\AGA܏\A\)A33A޸RAffAAffAAGA  AܸRA\)A(A  ApAڸRAHA  A
AظRAHA33A\)AQAHA33ApA
A׮AffA
=A33A(AAffAAۮA33AAAA(AHA33A{A
=AApA33A܏\AA݅A
AA
AGA(AHA׮AApA  AA֏\AGAAA33AיA
A{AA
A
A׮A׮AׅA{AAAظRAffAA؏\AA=qA  A
=A=qA
=A33A
=A
AA(AQA=qAۮAAHA޸RAHApAApA(AffAܸRAAzApApAݮAݮA݅AAHA
=A\)A݅A33AݙAGAGA33AGAGApA݅AAA
AA  A  AA
AA33AAݙA
A{A=qAAA
=A߅A߮A
A
A
AAA޸RAGAAAGA
A  Aڏ\AڣAۅAۅAAQAGAݮAzA݅A
AݮA{A=qAGAQA33A
=A{AAۙAAمA{AظRAQAGAAA
=A֏\AQAAffAHA{AQAA\)AٙAAA=qA
AمA
AٙAمAGAGAA33AGAAAAAAظRA(A(AظRAA
AAQA33AۙAۅAՅA=qA(A{Aڏ\AA  AA܏\AܣAۙAۮAٙAۮAAAݙA݅AݙAݮAܸRAܣA33A  AAQAAA
AݮA\)AݮAAAۮAۮAۮA
AۮA  AffAA{AA  A
=AܣA\)A܏\AAۮA  A=qA
=A{ApAApAޏ\AApA
A
A(AHA33AٮAڣApAzAٙA=qA
AzAAAݙA
A=qA33A޸RAHA
=AݮA\)AܸRA=qAAޏ\A33AAzA
=AA޸RAAzAAߙA  AGAAA  A
Aڏ\A
A
AAڣApA  A
AAHAA
AܣAܸRAAffA=qAۅAۮAۅAApA(AAzA(A
=ApA
A
A\)A׮A(AzAffA؏\AAHA׮AA  AיAAffAڸRApA=qA(A\)AڸRAڣA{AAAمAڸRAAۅAAܣA܏\A=qAQAۮA  A
A  AffA܏\AffAQA=qA܏\A
AffAיA
A\)AA߮AAAA(Aڏ\AٮAمA\)AGAظRAمAAA؏\AأAAHAٙAٮAٙAمA  A{A(AzAA\)AظRAzAمAA=qA(AۙAAڏ\AHA\)A
A(AAffAۙAAGA
=AA
=AڸRAAGA  AAffA܏\A܏\AffAܣAܣA܏\A܏\A\)AApA
=A{AHA؏\A؏\AڣAڣA{A
AAHAQAٮA܏\A݅AݙAݮAAA  ApAQAffA(ApA\)AٮAGAzAQAHAzAA=qAHA֏\A
=AיAA33ApApA33AAAA֏\AՅAӮAAAѮAAAAԏ\AHAAԸRAԸRA(AffAԏ\A
=AAffA=qAHAA
=A(AԣAԣAӮA(Aԏ\AAԸRA\)AGAAծAծAAAzA֣AAGA  A
A{A33AՅA33AՙA\)A֏\AׅAffAffA؏\AAGA
=AָRA  A{AיAAAAHAיA=qA33AGA=qAzAQA=qAQAA׮AיA=qA{AظRA(AAQAA(AQAffAA{ApAٙAAمAمAٙAGA33AGA\)A=qA  A=qAڏ\AHAzAAffA=qAٙA(A{AzAAٙAڏ\ApAظRA
=A(AأA=qAAAٙApAޣAA݅A
A33AٙAQA{AQA\)AׅA33A׮AأA(A  AAׅApAAA  AׅAA׮AHAأA
=AAۮA  AHA33A
=A33A֏\AՙAzA\)A\)ApApApAGA33AA  AљA33AՙA  AAAՅAAHA(AAAиRAAQAGA  AظRAGAAHA\)A
=A\)AAAA\)AمAQA(A(AzAffAңAHA\)A\)AәA\)AәAHAAӅA{A(A
A
=AA=qA33AɅAAA
=A\)A
AHA
A  AˮA̸RAzAA\)A\)A{AffAA\)AA
=AHAAAAAAѮA(A\)AApA
AQAAңA
=A(AzAAzA33AAApAAӅA{A  AAӮAffAQAϙA\)AAffAffAͮAzA  ApAУAA
AңAQAApAffAЏ\AzAϮAAHAиRA\)AQAҏ\AҸRA
AAQAA  AzAHAʣA=qAͮAA  AGAѮA(A(AApA33AѮA(Aҏ\AAGAәAffAG                                            AΣA{AQA=qAAzA(A˅A
=AHA
=A33AzA\)A
=ApAffAffAΏ\A
=A
=AAʸRA
Aʏ\AəA  A̸RAAAҏ\AծAיAAQAAQA{AApAffA33AHAA
=ApAAAAAA=qA
=A(ApAAGA33A=qAܣA޸RA
AzAApAAHA߅A=qAA(ApA33AAAApA  AAAffAAApAApA{AAzAA\AAzAzApAzAAΣA(AхAApA{AGA33AA
AGA
AAٙAAffA
=AۙA{A(AQAAәAAA(A
=A͙A(AA=qApAA(AHA\AA
=A=qAffA{AA\ApAAGAAA\)A\)AffApAffA\A޸RAHAAA
=ApA
AffARAAAAHA癚A\ApAAHA\)A\ApAQA
=AA\)A{A
A  AAAA  A\A\A{A33AA뙚AݙAffA\)AGA(A{A
AzAϮA\)AHA\)A
A{AAЏ\AAAͮA
AGAGAͅAͮA  A{A  A(AGA33AۅA{AA\)AQARAGAGA홚AݙAA
=A\)AхAQAzAHA  AAA33A=qA  AAAAA
=AAAGA=qApAAGAAHAHA
=A
=AAA\)AA
AAHA33A(A=qAA  A{AffAGA噚A(ApAAڣAGA{AA(AˮAA(A
A{AAAΣApAGA  A
AΣAͮAA{AzA
=AAʏ\AAGA=qAA33A
=Aʏ\Ȁ\AAApAAHA֏\AӮApAGAAڣAÙAQAHA33A  AAAAAAAA  AA\A\A33A\)AHA33A
A  AA
AA=qARAffAAHAzA
=AzAffA  ARAAA(AB 
=AzBA33B   B zAQAAAffBGB=qB\)AA{AzAA
=A
=AAffA  AffA=qA  ApA
AffAA{AARAAAAAzA癚AAHA
=AA
AGAAA{AA홚AABGB{BRAAzA(AGA=qAA=qAA=qApBffBBAApA\)ARAAAA\)AAzAQAAGA=qAAGAGAA\B GA
=AffAA\)AA\)AAffA
AAGAAAzAA33A=qAA33AzAzAAAzApB=qB=qB{BQB  AB \B =qBBHBpB ARBHAAAA(AAGA
AA\ApAAAAHA
AAޏ\A  A
=AGA
A33AA\)AA(AAAAAQA{AGB BB   AHAzA33B(BpAARB 33A\)AzAffApAA=qAQAA\)AA=qAAA
=AzAAAAA33ARA
A
=AGA\ARAA{ApApA\)AHAApAGAffA
=A  AܣA  AA݅A\)AA޸RAApAffA=qAzARAGAAffApA\A
A33A噚A33AA\)Aޏ\AAzA{AAAAffA\)A(AAAAHA(AA
AB {A  AHAA(AAAA=qAQA33A
=AA
=A
=AzA陚AA=qAAzAffApAARA  AGAA{AApAA33AffAzAAAAA
=AAGAAAzAAAA{AGAAQA
AA=qAۙA(AHAӮAzAQAA݅AzA
=AHAA\)AA\)AAGA
=A{AA噚AGA(AGA
=Aޏ\AffAQAAAGAAARA\)ApAA{AAA(AA(ApAGAA=qAB B=qB BpAHAA33AHA  A
=AAGA=qAA{AA\)A\AGAARAAA\AAAA{B AAAffAHB33B RAAAAzAAQAA  ARAAARA=qAA\)A33AAQA  AQAA
A(A{A
AA{A(AQAAᙚAAAAQAA  AA  AA=qAffA33A
A(ARAA{AzA  A33A  AAGA\A\A(ApA(AAHAAAGA=qAAAA(A  AA33A=qARAffA33A\)AHA
=ARA  AAHAA{AA=qAAAAAffAARAAAAQAAA
ApA{AHApAA{AAAA߮AA߅AAޣAAAzAAA33A
=A{AzAޣAAޣA
A癚ApAA\AHB ffB AffARAGAA
AzA  A\A{AHAARAQARAA{AQAA(ABB
=B33BBB  BB33BB\BAAARB33B
B B\)AA
=AARARA=qAA{AAAB33A\)BBBB{BB(B\)BB33B  BffBRBBB RAARA33A
=A(A
AAQA{AApB33BBpB
=B33BBpBB
=B QA33B=qBGBAA33BAAQAAAB AA\)A\)A=qA=qAAQAAA(A33AAAAAHAAAzApApB pBA\)BRBzB
=AzAzAAGAGA(A=qAQApAffA\AA{A
AA33AzAzAHA33AAB A
=B(AA
A=qApAARAzAQAGA=qAzA\AffA
A\AGA(A=qApA  AGAAA߅Azy ApAAAAHA{AHAA33AGA
=A33ARAAGA
A
AB (A(B B BQB \A\)AzAGABAQAAGAA\AAzARA
=ApAAB\)BAA33A=qARA\)ApAQAB
=B
AA
=A  A(AHAzA(A\)ARA
AB AzB B 
BGBBB
A  A{A{AA33A=qA\)AGAA33ARAffAA{AAHAQAAA뙚A
=AARAQAA{A
AᙚA
=A=qA(A\)AzAAAA\A
AA  A(A\)AAzAB HBGB zBzB B BB
B
BBQBzB=qAAA(AABQB ApAA\)A\ApA
=AAA=qA33AA  A{A
AAzA(A33AAA33AAARBffBBRBffBB(BRB33BBpBpApA{A  AGA{ARA  A\AAAHAAApA{ApAHAQA(AAA=qAHAA\ARAzA
AHAAHA
A\)A=qA(ApA  A
A\AAGAA
=ARA\A33AzAQA
=A{AAGAHA
AAAAGA\)A\)A=qAzA33AQA\AAAffAAAAAzAAzA33A(AAA
=AA{AAGAAHA  AffAApA癚AzA\AAAA  AAffA(ARAAA
=ApAQAA  AGA  AzAAAffAA癚AAA癚AffA癚AAzA=qA\A
A{AAQAffAAA\A{ApAAzABGApAA홚A  B
=BA\ARA(A\)ApAA
AffA
AHA\AffA뙚ARA=qAffARA=qAA(AffA=qAQA
A
AAA33AHA33AA{AB B(B33BGBB
BzBBpBRAAAAB (B {A\)A
=AQAAGAGA\)AQAQAzAAיA
=AAffAffA=qA\)AAzAәAzAأAAיAיAAQA33AGAAָRAA(AA\B 
ABHBB(BBRB33BHB33A
=A33A  AGAAABA=qB  AzB ARA33AA\)A
AApA=qA=qAA=qA(A\AffAB AAA(A(A  AAA{AA
AA=qApA\)AffB AAA
=ARA=qA\)AARA=qARA
AffAApAffAAGARAA
=AHA=qAQA=qApAGAHAzAHAָRA
AظRARAzApA\AAA
AAAzAA
B =qAA=qB (ARAA
AApARAHA\AzA\A{AGAA\A=qA\A
=A
AffAAAAA  A
AAHA\A癚AA=qAzAHA
=A(BAB33BB(BBB33BHBGB
=BBBAB(ARB
=BBpBHBQBHBGBpBzB\)A33ARApAAAAQAGAA=qA=qApApA\AApAAGA뙚AA\AzAA33A(AHAAffAAQAA
BQAA
AAA  B(BffB zBB(BB(BB=qBB =qBAA(AAHAzAQAApA{A(A  A33AAA\)AAAGB  B33B(AApBQBBQB{AHAARAHAQA癚AAA\)A
=AA\)A
AAABHB=qAARA=qAAAA陚AGAzARA
=AAGA{AGApA=qAAA
AA\AffAңAAۅApA{AAHAAHA
=AAffAAA{AAQA\A
AA\A
A=qAAAGA33A\)ARA(A
A=qAHAA{AAAAffAAAGAAGA{AzAQAQAffAQAA{A  ApA
AAffAQAAzA׮AAA\)A\)A  A(A
AzAGA33AAAA\A33AAAA(A\AHA(AzAHAzApAAA
=A
=AA\)AGAAAͮAϮAׅAѮApApA  A33A\AAffA\)A\)A=qAffAA\AÙA̸RAQAGA
=AAAQAA(AŅAΏ\AA\AAAA
=AARA=qAAA
=A  ApApAA{AAzAQAAGAAA  AA
=ARApA=qAA=qAQAA{A(AAA
A
=AAAzAA  AAQA\)A(AA  AAzAA
=AffA  AAffAHAA
=AAAQAAAAGARAHAzAffAAzApAAAAGA=qA  A=qAA˙A33A33A(A
A33A=qA  A\)A֏\A
A
AffAA
A
=AARAffAA
=A  AAzAQApAApAmALAeAQpAAAYAQA_
=AAzA
A33A\AAAl(Ac33AWA=ADzAPQABHAPzAJHAHAF\ADAEAAQAp  A
A^ffA$zA6ffA#33APQA&\AzAAHApAo\)ARAPAA0QAsA  AAAAhA
=Ak\)AffAAHAAAAHA\A33AffAA33A\A=qApA
=AGA
AA=qApA{AA33A\)AGA\)A  AQA=qA\AAQAQA(AAffAA\)AA33AApAәAzAA
=AAAzA(AA
A\AAA=qAAAA׮AGA33B HApA
=AAAffA\AzA\)ApAGA{AA(ApAGAzAA\)AffA(A  A
A
=AٙAGA{AQA\AGAGAՅA
A33A  AA33BARAARA\)AHARAHBBffABAQBQARB(BAA
=A
BRAAA(AB
=AAA\AAA
AApAApAAA\AAA  A=qAHAAAGA33A\)A=qA\)AApARA
=AAQAzAApApAGAAٮAGA=qAAޏ\AHApAܣAޏ\AffA߅A  AzAAffAAHA˅AQApA\)A{AУA{AңA(AңAzA{A{AffAԏ\ApAAGA\)AffAŅAAGAA=qAQAQAԏ\AHAA
=A\)AQA(AGAхA{AHAAݙAzA=qA֏\AffA33AHA\)AAHAAA
=AԸRA֏\AffA33AڣA
A{AHAApAΣAAAzAzAHAϮAApAHApAAAAAAQApA{AAǅAA(AڸRAAAffAAHA\AHAߙAA\)AApA
=AAGAQAAθRA(AA33A33AܸRAGAӅAٮA=qAffA(A
AGAffAAAA(AA33ApAA  ApA\)A=qAA=qA=qARAzAA{AAAQAARAzA\)A
A뙚A\)AzA(AAGAAGA
A=qA33A{AAAAAzAA{A=qA\)AGA  AzA\A
=A=qA33A
A  B =qAB (B 33B \)B BGBBpBB{BGB33BRBRBBffA
=AApAA\)B\BGABBBB33BffB(BBGBB =qAAAA=qA{AABpBBBBffBAB\)B(B  B(BRBBBzB(BB\BRBBRB\)B  B33BB
=B
=BBffBffB\B B(AAARA{AAffA
=AAA{AAAAQA\)AA\)AGA{AAHApAAHAA\A33AAzAGA{AAAAA  A  A\)AAAGAzAAA(A=qAQA\A
=AA=qA(AAAffAAAQAAffARA\)A  AApAAA33A33A33A
AffAHAAAA  A=qAApAAA33ABHAAApAGAA  A\)ARB33BB
AAHB A{AA33A\ARA(AAAAڸRAA(A  ARA{AzAzARAzA陚AAAAHAQA
=AՅAA\)A
A(A=qA  AzAGAAA  AAߙAAQAۅA33AHA  A\)A  AffBQBB {AB{B ffABA  B\BB AB B BffB AQA\AApAffA33BGBQB HB\)BA  AAApA=qARA
=BBffB RBGAAffB zA=qABB \BAABABpB (A(AzA뙚A\)AzA33AHA=qAzApAA\)AA=qAAHA癚AAffAA
=A\AA(AAQAAA
=AAAA{AA\)AA؏\AAzA=qAGA(ARA\)AA
=B BAA
=A33A
A{A
=AAAGABB\)A\A
=A\A(AAffAzA
=AAA
=AAAHAQAAzA(A
=A=qApA=qA홚ARB AAA(A(A  A=qA\A{AˮA(AAHAA{AGAAAzAA33AA33AAARA33A
=AA33A(AARAA(A\)AHA
ApAffAA
=AA33AAQAzA
=A\)A{AӮAəAAAAGAAAݮA{AHAzA33AzA\AAARA=qAHAA݅AA33AzAAHAA(AQA\)AAApA  ẠAA  ApB  AAA  B\)AHAAA33AAAzB AARAՅA
AظRAAGA
AУAȣAӅAGA  A\)AHA
A=qAمAA
=AǅAHAՅAAA{AԸRAQAңA
=AzAA߮AAffA׮A\AׅA
=AۙA33AAffA33AA{AA
=AA
=A
=B(ABBGBHBB\AAGAAQA=qA\AA{AA33A\AQAffAAQAܸRA  A=qAڣAHA
=ARAffA(A  A{A
AAA33AAffA\)AA(AzA33AA\AAAAGAAGA33AٙAGA
AGAAA33AәA{AӅAAQAAծA
A=qA  AHAHAQA\)A
=A癚A\AA33A
=AAGAHAzAAQA{AA  AQAAA33ARA{AA  A33AAzA33B \ARA\)AAffABBAA
B AAAAGA  AAA
A33AGAAGAAGAA33AA33A(AAAffBzB\)A=qAffApA=qAHAGAA
A\)AQAA  AA33A
AGAApA(AHAzAHAAzAzAָRAיAظRAׅAՙAAՙA׮AٙAAGA  AAAffAѮAΣA
A33AzB =qB(BBQA
=AA
A
=AA\A  AB 33B A33BB=qBffBRBBGAzAB B\B
B\)B pB{BAHA  A
=AHAA
AA
A33AB =qA(AA  AQA(AzAzA
=AB ARAA  A\AAQA  AGA(A\)A
AffAzAARAGAAA\ARARA
AQAA(AHA(AHAAAQAGA{AA
=AAQA{AGA
A\B \)ABBA
BGAB
AffA
BQB=qB  BRB33BA\BB\BQB\)BGB{B B \AAB{B{BBRBQBB{BpB33B\)B33B B B pB pB  BGBGB B{A\)ARAB\)AffA\)AB=qBGA33A(AAB  AffB A\ApApA33AzAzA(AA(AApAA33AzAAAzAAA
A(A\AGAAAGAA33A
=AAAGAA
AAARAAB\)BHAA
=BffA
AzApA
=A  A{B  B\)B(B
BBB=qBRBHAA33BzA
A{AA
A{AGBffBB\B(BBA{B \)BpBBBRA
=A
AGAB
=B33BHBRBCA\)B=qB{B
A\A(A=qA=qAA=qA
=ApARA陚A(AQAGA{AzAA(AAAzA  A=qA
A  AffA{AffARAAA=qAApAA33AQAAAA\)A
A
=B33BRB(BBzBB  ABRB BB BpBBBffBBB	ffB\)B{BpBB(B(BHB BGA=qA\ARA
=AA(ARA
=A
B 33AA{AzARAAAzA
AHAÅAA{ABQA  AzApAAAQARARA
A{A(AffAzAB 
=B {B33B
B{AA33AzAffAAffA(A\)AQARAAA
=A\)AA(A(A(A=qAQAAA
=A33AGBAB  A
AzA  A
=AGAAAzB\)B =qA=qAA{A
=AApAAApB(BBRABB=qBzAHABHB(AAzAffA{AGA\)AAffA  A\AAApAHAGAzA=qAA{AGAGAAAA\)ARAHAA  A(AՅAA
=A\)AљAәA=qAAffAA޸RAHAA  A  ApA  AHA=qAAA{A֏\AQAQAָRA\)AHA\)A\)AAzAQA\)A
A
A
A(A\)AAGB 
=AB33AAARA\AAGAAAAzAAAAA=qARA
=A\A\)ARA陚AffA홚ARAGA=qAA
=AQAA\)A(AzAA  A(AAA33A
ApAHAAAA(A33ARA  AA=qAHAAzA  AޣAAffA
A{AݙAA׮A{A\)A33AAffAzA
=Ȁ\A{A
AQAAAA  AۅA33AGA\ARAAAᙚA(A(A(AA
AمAAQAA
=AzAzAHAA\AA  AAQAAffAQA\A  AA  A\A  A(A
AHA
=AGApA
=AAAAzAAAQAB RBB
=AAAAڸRA{AA݅AAٮA  A(AHAffAAǙAAA=qA£AƏ\A(ApAAzAAHAzA(AzAAۙA
=A=qApAHA\A{AApAffA=qA\AHAHB RAB AAA=qA(AA  AHAQA߮A=qAA\AAA\AA{AHA  A33A{AHAzAA  AָRA
ApAQA\)A=qA  AA
=A
AA{A  AA
=A(AA(AAGA陚A陚AQA  AA\AzA\AAzA
A\)AA33A\)A
=AHAŮAəAApA
AͅẠAzAʸRA{AAȀ\A
=A=qAAzA33Ȁ\AӅA  AAHA=qAffAGAƏ\A(AθRAθRAzAffAAɮA\)A{Ȁ\AAÅAхA{AڸRA噚AA(AA  A\)AAHAzAffA33AzAAAAиRA
AzAAA
=AA{AA33A
=AAڸRAڸRAA{A=qARA
=AAffA\)A
=AffAAffAzAQAAAQAٮAHAzA(AA\)AzA(AzAͮA  A
A
AAGAAAʏ\A
=A
=A=qA\)AمA{A\)A33AAAAAŅAA
=AЏ\AAəA\)AzȀ\AAҸRA33AQAffAAAAAA(AQAA뙚AzAHAARAA
=A
AQAAHA݅A(A\)A
=AAARAAzA
AGAA(AA\)AAA=qAAAQA{A
=ApARAGApA\)AA
=A
=AAAHAAzAffA\A\)AAzAffA  AffAAApAAAA=qAAffAܣAffApA
AޣAAAA(AAGA(AAA
AAB B(B B zB 33BARAA
=B\)B(BABBBHB\BAAA(A\)B zB  AA33AABA\)BGB=qA
B=qB=qAAA
=AAARApARA\AA{AA33A\)B
B \B ffB(B ffAAApAAGA
=AA\AB pAffA\AHAA
=AAAAA=qAzAffA=qApAzAA
=ABBBBBzBB\)B{A  A
=B =qAA
=AAAHA
A癚A(AAA\)ARApApAA(A\AA\)AffA  A33AAffAARB =qA
=AA(AQAQAA=qA\AQAHAAQAA\AB {A
=AAA\)AGB \A\)B (BGBzBBGAA{AffA  AAAA\A
=A\)A=qAA\A
=AAHAAGAA\A=qAARAQAzAzA=qAzAQAAARA\AQAAGAQAA\AffARA\)A(A=qApAA\)AffARAAAARApAAA{AQARAAAAA{ApAHAzAAAA\A\)ARAzA{AQAHAA  AAAA(A33AA33A=qA  AQA{AA
AA(A
A\A  B (AA
=ABQB\BRBBzBGB  BAQB BBpBAAAffAGAARAQA
=A
=A(A㙚AAA܏\AAGA(AHAzA33A(AGAԸRA
A
A\AAGAHAAHApA{AυA\A  B(AB{ApBGB
=BBBB(BffB\B ARB \)A(AQAAARAAAQA
=AAA(B AA
AHAA33AAzB (BRB=qB  BAA  AA33AAAAABQAAAGAffAAA(A  AAA
=AA\AAA  AHARApA(ApAHAAA33ApAAQA
=AޣAzA홚B\)AARAAGAGAAߙA  A\AffApApAA
=B{AA{AA33AA\AAAA  AAQAAzAAA33AA\AffAzA  AAzA{AGAQAAAAffA\)A(ApAAHAA\AHAB zA{AAAA
A=qA
=AGAA33ApAQAHA33A{AAޏ\A޸RAA߅A߮AffA\AHA33A(A=qAAGAGARAA=qA{AzAޏ\AApAAHAA\)AAApAzAAGB A
=AA
A\AB 
=BGB\)B=qBRBQB B\)A\)BB(BzBB  B AHAAAA33A(AAB A33A{BBBHB zBRAAAGB \)A(AzBQA33AAB AB  BGBBBRBB  BpBRB AAzAAARA33AA  A
AQA  A{AQAAA
=A(AA(AffA  Aڏ\BHB\)B=qB\)BzB
B=qBRBBRAHAA=qAB=qBBpB
=BA=qBBBHB33BBQB=qB\BBBBzB  B33BpBBHBRB=qBBBQB
A
A
=A=qA
A  AAA\AB (B ffARAAAQAA33AHA  A=qA(ARA{A؏\AٮA33A=qAGAAAߙA{AAGA{AAҏ\AAׅAA
=AԸRA\)AQAARAAQA(AQA33AAffA
=A33AAGB GA=qB 33BAA{BRAffAA\ABBHBBffB\BBHB(B =qAGAAHAffAGAAAA
=AA  A(AAHAHAAGAQA{AARARAAA  AAB RB(BA\A33AQAffAA33AA{AQAAffAAGA33AzAAHAQA
=AQA{AAQA\ApAAHAAHAQA\AAQA33AHAHA  A{ARA33AAHAA{ABpB GBBQB(B
=BpBBB33BBA  B=qAAB33AffBAABQB=qBpBBQB B \B HB  BBRB\)B{ABBffAA33A\)A
=A
AffAA33AAAA
AAQAAAHA\)AAAQA
A
=A=qAffAffApAzAQA33A(A  A
=AQAA=qA{AHA=qA
A{AAzAAAAApAAA=qApAffA=qA\A{AAAAzAABpBA\)B zB(BQBGB  AB33B  BRBBpBQB=qBRBffB \B(BHBB A
B ABAAGB
=AGA33B33B{BRBBB33A=qARB zB\)B=qB33B\BBGBRB33BBffB=qBQBBHBBHB
=AzAAzAAffAA\ARAA
AݮAȣA=qA\A\)AQApAQAAA(AAffAAHAzA{A
AAQAA(AAAAABB
=BB{BQBB33B\B\)BB
=BGBB
BBRBQBB
=B\A{A=qAzAA33BBHBHB=qB
A\B  BRBBB
=BB=qB  AB{BBffB(BRB ffAAARApA
=A=qA{AffAA\A
A  AAA
AGA
A
=AAApAAHAffA{A33AܣAAHA\)AHA߅AA33A{A33A(AQAffAA=qAffA
=AA(A=qABzA33A33AA33AAAB {BQB\BBGAHB B\)AARAA
B
=AAAAA{ApBBA=qAHBBAAB B B 
BHBBBzB=qB
=B=qA\)B
=BzBBQBHB
B33BBGBBBAA33A(AAffA
AB 
=B33BHB AAGA33A{A  AzA
AQA\)AzAAARAffAHA݅ApA
A(AzAzAGA
AA{AAAB AABB   AA(A33ARAA  A33ARAAzAAB\)AA33B \)A\)A
=AzAAQAGA\)AAGAAA\AGA\A
=AB 
BGB{B
=B\)A33AHA;
ApApAAGAAHA(AffA
=AAA{A(A33AڸRA33A=qA݅ApA
AAAׅAׅA33AGAQAAA  AGA  A\)ApA\)AθRA
AՙAAA\)Aޏ\AGAA33A
=AA=qA{A(A癚A\)AQA\)AAffAGA
=A=qApAAAAA
=AA\ApA(A
AA\AA=qARAQAAAA=qAQA(AQA  AHA{B B(AB 33A33BBAA\)AffAApAA
B   A(A{AA\AAAzAAffA噚A
A{A33AӅAApA߮A
=ApApA
=AAzAAA
AAHAffA\)A
=A=qA(AAAAAA=qA
=A\AA(B\)AAB A  BzBB\A
=ARAAAHAApA33A  AAQA{AffA(A(A33AA(AAA{AAzAQA=qAAzAA{AQA\AAffAA=qA=qAQAQB B
=AAHA
=A(A
=AA
AGAARA33AQAAAAA\)AAffAzA33AA
=AAAAA{AAHAB 33B \)AAQA(A(ApAzA(A33A=qAָRApA(A\)AAA33A\)AA\AAGAHApARAA=qAAQAA33AHAA33A\AffA
=ApA=qA
A\AAAA(AGAAffAA
A{A33A
=ARAAA  AAݙAA\AQA33AAAܣA\)AA\)AHA\)A  AAHAffARAAffAffAAGA
AAA
=A
AzAGAظRA\)AՙAA{AׅA
=A  AzAA\)A  AҸRAAA\A  AAGAQA(AAA  A
=A=qAGAQAB AQB=qBBpAAA  AHApA{ARA  AAA  AAQAAAHAAA  AHA
=A
=A=qAQAA(AffApAA33AAHA=qAQAAAzApAAQA=qA陚A{AAGAffAHA\A\A׮AAGAA
AAA\)A33B(B {AzAA
=B=qA
=A{A  AApAAffAAGAAڣAAۮAAGAAQA33AQAffA癚AA\)ApAAGAA  AHA=qA
A=qA\)AffAAA
ARA  AQAzAQA뙚A  AAAAA
AAAzA{A\A
=AAApAA
=AARB \)A
=AAAݙAGAHA
A
=ApA33A(AQAܸRAԏ\AQAQAAљAQAϙAυA  AAљA
AA
=Aԏ\AңAzA  AzA(AΣA
AȣAAHA33A\)AffA(A(AAzA33AHAHA(A=qARAAzAAQAAHAAzA=qAAA
=AA=qA
=AQARA
=AAA\AA(A\AffAffA\)AAAA
A\A{AHAA
=A
=A{A\AAAA33A݅AQAA
A陚AA\AQAA홚AA\)AAHAzA
=AQAA\)AAA33A{A\)AAAGApAzA=qAظRA
=AHB \)B
A33B GBQAB pBHBzBARAAQAApAAB\)AAzAHA  A  AApAA33A
=A(AA
=AGB  BA
B(AA=qAGAA(AHAffA{AffAffAGAAzAA
A\AA
=A  AAAAAA\AA=qAA  AAA33AA
=AQAAAHAffAAAGA33ApAHAۙApA=qA\)AAffAHAHA  A(AAA33AGA(AQA͙A
AffA͙A
ẠA  AAApAAGy AˮAApApAAHAAA33A=qAGA{AGAAAAffA(AARAQAGA\AHAAA\AAAAA噚AAA(AAQApB AHA
A=qAA33ABBBA\)ARA=qAAA=qAGAzA  A
=A=qAѮAAzAA33AGApAffA
AHAA
=AAAAޏ\AAzA{ARA  A{AAGAzBHAAAzA33AffAAA(AGAffAzA߅A(A{AQApA=qA  A(AGAיAGAAA{A˅AQAǮAzA{ApAәAQA\)AA  AA͙AHAɅAffAA
=A\AAA33AA(A
AffA\AHAA33AAݮA  A\A(A\)AffAA(AAA
=A陚AӅAAϮAzAAAңAA33AAQAA=qA\)AHAיAA݅AA\)AzA\)AA㙚AQA㙚AzA(A\)AB33BAB\B{B ARAB
B=qBBBHB33B(B  BB\)B	33BBBQBBBBffBBQB=qBBBBffB(AHAA
A
=AA=qAAA\A{A  A\ApAAA
=AB QAGAA
AAAzA\)A33B 33AHB
AB ffA33AA
=A{AA33AA{AAB(A
BBBQBQBBBHB(B{B  B  BffBBB\BB HBB\B
=BQBBHB  BB\BB
=BA=qB{BB(BBHBzBHB A
=BBffBpBQB33BGBffB\)BABffB\BGBpB\B
B=qBBB33BBQB HBBB
BQBGBB  BB{B
BAB
B{ApBBB\A
AAB  A\AA(AAzAAAAA  A
ARA
=A=qA(A
AAA(AAAAA(A=qARAHA(AAB =qBBGB RAA\)ABQBffBRA\)ApA  A(B\BzBpBBHBBzA33BBA33B
=B
=B\BzBBBBpBBpB  BBB=qBBffBAAA33AA{A
A33BQBQBBAGBB\)B\)AHA
=A
=B(A33A{AQA=qAA33A
=AzARA  A  AQAffA{AHAAA\A33A(A\)A
AAGA\AAAAHA\)A{ARA\)A{A{AA  AA(A  AAB 
=BBGBpBABBGBBB(BffB=qBBQBB B =qAB\)BRB=qB
=BB(BB\)B\B  BBBpB 
AA\)AzAA\)AHB QA{ApA\AGA
A\B (A
A33AAffA\AHApAzAA  AzAQAA
=A  A33AAAABRB33BGBGB
=B(BpBB
=BBQBHB	{BHBBBB(B=qB  BzA
B{ABB\)B(BzB33B	=qB
zBGB 33BBpBBffB
=B  BHB=qB{B BGB BffBBBBBzB AHARApAAA
AAB GABB=qBHBpBGB B B =qB  BApAGAA
=A  AAB33A=qBAAAApB QB  A(A\)AA\)B zBB AA(AffAHA(A\AAGAA{AAffAARB 
=A33B  B33BHBBGBA=qAA\)ARBRB
=B pAAA
=AzAA(A\)AAAAAzAAAA(AA33AzAA
ApAA  A홚AAAzA{A\)AQA  ARA
=AQAAAAAAHAA33A  A
A{AGAA{AzAffAZffARApAGAȏ\AA
=AffAffAأA  A=qAGAQAHAzA㙚A݅A
=AffAGAۮA\)AA{AAA\AHA
=A  AAAA{A
A
A(A\)AAffA뙚A
AAGA\)A=qA(AA  A\AffAGB {A=qARAA㙚A\AA(AA
AA
AAA
=AffAAA33A(BGB
B\BB
AAAAGBzAHAGAAA=qA=qApAARAAәA\)AиRAAHA\)AA33A  A
AQAȏ\AәApAAA(AظRAAffAAAAffApA{A=qAGA
AA{AA\)ARAAA33AAA=qA(AAA\)AA=qAA
ARAffA=qAGApAAAA  A{B33B =qB B \B BAffAA(AAA  A33AA33B B B \B BpBHB\)BRBpB\B  BGB{B zBBzBB {A(AA=qA\AzA=qA{AffAAApA  A{A{A\)A{AAGAGAAAzAAAA\)AAA
AHAAAHAA{BpAffBBBQB
=BRA
=BQBGBHAHAB=qB =qA(BB
BBQBQBBRB  B  B BBQB\B\)B\A(BGBBRB\BBAzBAB
=A
AA\)BzABzAHAAHAzAGAAHAA
A
A\AAHAAffAA
AA(A(A  ApA㙚AAAA  AffAGAQAA  AAAυAԸRA  AzAݙA
=AأApA
A{A=qAAzAApApA33A  A(AA  A  AA\AApA(ARAAAAظRAQA\AHAzA\)A\)A{AQAʸRAffA
=AظRAzA{AѮA(AQAA¸RAHAGAA33A؏\AGAAHA\AARAәAиRA(AApAffAծAAʣA
=A
=ApAA
AÙA
A33AA33A  AApAAzA  A
=AA\)A{Aȏ\A33A\)AƣAǅA
=A  ARAzAAffAA
=A
=AffAA{AzA{A(AAHApA=qAAHA
=A  AA  AQAA(AffAAHAAAA陚AARAAffA  AA
=AGAA癚AA\)AHA  AAA݅ApAA܏\A
=A33A癚A㙚AHAA
AGAA
=A\A33ARA݅AAAA{AffA{AׅAأA=qAܸRA  y A(AHA{A\)AGAAffAۙAAܸRAڣAffA=qA\)AGA֏\A(A
=AAAҏ\AA\ARA(AzAHA\)AAA{AAABARA{AA=qAA(A33A  AApA  AAffAAA(AA  AGAARAQAffAA33AA(AAAQA\)AA\)AA  BAApA
AAHA33AA  AA33A
=AAA{Aޏ\A  AAAGAA{A(AzAA{AٙAٮAAffApA33A=qA33AمAGA{A  A
ApAAzAݙAQAHAHAΣAzA=qA=qA33A33A
=AAA{A
=AffAGAAGA\AA
AA(AQAA\A{AzA\)AARAffA
=AApAAHA=qA\ARARAA
AzAA\)AApA=qA{A33A\)A\AQAffA=qAzA(A(B QB  AA{AA{A=qAAAܣA33AzA噚A׮AAHA
A  AQA=qA(A{AA(A(AzAGAQAAHAޣAGA
=A33A\)A  AAA{AGAHAAA
A\)ARAA{AAA(A\)AQAzB AA  B  A\AAzAAGAQAAAHAAAAffA  A\)A\)A\)AA\)AAzAHARAHA=qARA=qAA
A(ApBHApA=qB33ARBB\A
BpB (B 
=A\AffA홚AAffAA
=AAARA\A
AA\AzAA{AAHA33AA(AAAHA뙚A33AA(AAA陚A
=A(AAzA(AA33AffAAAB A\)A\A(ARA=qA
AA=qAGAA=qAzA
AQA  ARAA  AAA{AAzA\)AA  A
A\)AAQA홚A
=A=qAA{A33AQAAHAQAA陚AQAA
=AA33A{A{A33A癚AAAܸRA=qA{A33A\AA޸RAffAAGAA㙚AffAAAHARA
AARAARA޸RA33A
=AQA(AAծAڸRAڸRA=qA
=A{A
AGA\)AϮA{A
AzAARA  AQAzA
AHApARA\)A{AffA=qAA
A
AAffA=qA
AGA\A
=AA  AQAA
=A  AGAAA
=A33AzAAA33AzAۮAHA
A33AAAAzA(AQA=qA=qA홚AA홚A\)A
AA33AzAͅA\)A33AffAQAA=qAGA33AᙚAffAQA=qA\)AAApAAGA(AzAA=qAAHA(AAQAARAA\AAHA(AGA
A33A
=AA\)AAffAzA{AGA\ApA뙚A33A陚AAAAA\)AAA\A\A{AA  AA\AA(AARAAffA=qAA\A  AA(A(A  A(A=qA=qA
AA
=A홚AA(A{A{AAzAAAAAQARAApA33AHA=qAARAAffA\)A  AApAAGA݅A (AظRAzAAAA
AzA{A\)AA\A
AHAAA(AAGAHA  ARAQAA\A
=AA(AAGAAAQAAQA
A
A
=A33AA33AQA(A\ARA\A(A
=AA\AffA(AAAA
=AA\)A
A=qA{AA\)AHA=qA=qA(ApApA\)A=qAAAQA홚AAffA
AQA܏\AGAzA
=A
=A  AHAAA  AA\)AAzAAAA33A{A33AQAHA
=ApA\)AA\A33AHAHAAHAAGARAA  AHA(AA(A  AA陚A\)AQA\ApA
A(AABGAAffA\AzA\ApA
=A
A陚AARA=qA\)AAAAQA
=AA
AffAAzAAAAAA=qAzAޏ\A(AݙAQAAffA  AzAAծAzA(AA{AAAA
=A
AׅAָRA(AAAΏ\AأA߅A
AQA£A(AffAAzA߮AAGAzAAAA  AHA(AA
A\)A  ARA\)ApAHAAffAA=qA{A{A
=AA=qAQA
A(AA=qAGA\AQAffAffARA(A
=AA
=A
A㙚AAA33AHA\)ARA  A  A(A(AHA\)AAffAۙA{A=qA㙚ApA
AAHAޏ\AڣA\)AzApA{A\)ApA˙AQA{AAzA  AApA33AŮAQA\)ApAAQAzAA33AAΏ\AHAAA
=A
=A
=AHA(A߮AA
AڣAQA噚ARAzAɮA{AәA
=AAAA  AߙAA  AzAQAGA33A
=AzAA=qAAQARA
=A
AAQAGAAAApAHAᙚAA33AAAQARA{A=qA߅A޸RAܣAAGAHA33AHA{AأAQAGA=qAAиRAffAAAԸRA  A{A
ApA33AA=qAңAAՙA\)A
A
=ApApAңAGAA=qA
AʸRAGA{AA
=AHA\AA
ARB AABA{ARA\)AA(A{AAA
=A(A\)AA
AQA{A33A{AAQAAAA(ApAAAA(AzAffAA=qAARA{AzAAA\)BBB A\AzAA  AAQAAGA  AHARAGAA  AGAGAָRAHAأAٙA
A
AffA(AأAݙAzAApA33AHA
=AA33AAGA=qApA33A  AQA݅AHAAծAAHAffApAAffAHA{AQAAA\)A33A
=AGAHAA{AAQAA(AAGAHAA\AAAffAA  A  AA=qAA
AA뙚AApA  AA
A33AA뙚A\)B{AAA33ARA\)A
AAA(A(AA(ApAA
=A癚AA=qA\AARAQAAGAᙚA
A\AApAHA33AHAzAۅAAA
AAAAAffAAA33AA\)AAzAAAffAffBA
=AARA{AA
A
AHA=qAGA
AAA33AzAGAA{AQA\A\)AAA\A\)A\AGAAzAffAA\)AAA\A  AAAAA(A33<=QB AAA\)AzA=qApAAA
=AAHAA
AAAAA33AA{AAGAzAAAzA{A\)AzA\AHA\)ApA=qAHAARAHAzA{ApA  A  AAGA(AAAGAAHA
=A  AA\)AffARAHAGAQAA{A  AzB A=qAzA=qApApA33ARARAffAA  A=qA(AffAQARA
AAA{AAAQA\)A=qB 
=AGAffB pB =qA
=AAAHAA=qAApAQAffAA=qAAAARAA\A
AAA\AA33AQAAHAffAzApA
AHA
=A  AA33AAAAA\AzARA
AGAffA陚AffAzAARAzAffA(BA33A\A(A{B B pA33A=qApB   B B HA{AAAA  A33AAA  B33B \BB  A\)AA\B B
=AA=qAAQA33AB GB33B33BB BBHBB\)BB  BAAA=qA33A\ARApAHA{AAAApA{A  A
AGAAݙA{A(A33A33AzA뙚ApAAAffAzABAAffAffBHBQB  BpAA
=BB33BpB\)AARAA\B AzBBQBBGAB 
=AAHA=qAQApAAGAAA=qAAAzA33A(A(AApAQAzBBffB
=AGAAB QB  BpB
AA\)AHA\AAB HBzBB
=B\)BAGA33B{B\A
AHAB{AA\AAHAA(A{A
A\)ApA{ApAAA\)A=qA=qARAQAA\B\)BffAA  AAB\BffA{AAffAHBzB 
AB(A=qB ffB\)B B \B  BpB\B33AHA\)B RA
B A33A{A
=A33AA{AGAGAA
=B \AAAAQAAHAA\)AAHAAzAAB(ARARA\ApARAB HA=qA\AAAAAAffApA{AAڏ\AAzAzA33A\)AߙAAAAAARA  A  A=qAA=qAAA
=AA{AA\AAffAA
AAAA\AAAGA=qAHBRB {B=qBAAzB   AA(A\)AAffA33ARAAHA\)AAAAAAAGAARAApAzARA\AA
=AAAAHAARAA  AffA\)AAApA  AߙA݅AQA
=AGA
=AQAQAAޣApA㙚AAffAAQAA޸RAݙAA\)A(A=qAffAQAARBpB GAA\)B\)BBA{A\)A(A\)AQA{AQAA(A
=A\)ApA\A  B AAA  A
=A\)AHAzARAAAA
AApAzA{AA  A=qA33AAAHAffAGA{A33AffARAA{AA  AAGAA=qA
B AA  AAAA33AffA(AGAGAAQAGARA=qAQA\)A(A߮A\)A33AAQA33A(AAA
=A
AApA33A{A{A\A  AzAQAA  A  AffAA(AQAGAA  AzA{ApBB  AA33B ARAHB B \BA=qARARA
=AAAAAA=qA{A\)A{A=qB(A
=B AA\A=qAA
=AA(AAAA
AHAAQA
=A{A(ApA
AA  A
AffAAffA{AAQAAffAޣAߙAffA{A=qA{A\AA  AAQA=qAGAڏ\AׅAׅA
=AffAA
AAHAzARAA\A
=ApAA\AAApAAA(AAApAAA=qAAGARA\)ARA=qAQA
AzAGA\)AHA
=AA
AAAGAHAA
=A=qAA=qAAAA\AAA  B\)BBBpA=qAHAGAQA33AApA{A\AAAݙAظRA׮AGAQA=qAAApA(A=qAGAAᙚA\AA߅AffAA(A\)AQA陚AAzAAA
BBzBRBBGBB
=BBpBB\B(BBB HB B 33B(BBB
=BGB{B
=B=qBBB\B33BAffA33B(AB AQA\)BAB pAQBffB
=BAQAGB
=B
B QBBHB{BzBB  BzB
B33B 
=AHA
=B(AAAAA
AGAGApA
=AffAA
=AQAQA{A33A
=A=qApAApAQAAAzA{AA홚AAGB \AABBAAAA\AHApA{AAzA
AB=qBB=qB=qBBQB (B{B33BRBBBRB\B BpB=qBBzBRB \A
ARAAA\)AAB BBBBBBB ABBffB=qApAA\AffA=qAB RBA
=A\A\)AHA33A\)ARAffARAA  AAA{AffAAy A陚A
ARA\AHAzA\ApAA=qAGA\AB =qBB BRBpBBRBzB AzAB
=ApB=qBBzApAAAB\BB{A(A(A=qA{AAffAHAAAARAARA
=AHA  AA\A
=B  AApA\)A\)AHAAA{AAB \B\B(BB{A\)AA{A  AQBpBB RBpB B \AQAAQAARAAA(B RA
A
A
=AAzA\AHA
=AA
A\A\)ApB zAA=qB{AAA
AffA(AAGB 
BBzA=qB  B 
=BffBHB GB (B (AA
=B   B 
=B {B AAHAGA{AQA  ApA=qA
ApAQApAQAGB B=qB\)A33AffAAAGA\)A\AB =qB BpB
=BB
AAA(B(A{A\AAGA(A
AzAQAffA{A(AffAQAARApAQA33A\)A(A
=ARAA
A\AGA\)A홚A\)A
AffA
=A
AffA(AQApApAAffAB=qB HBBBGBB\)BGB
=BpB=qA
=ABA\AzA{B \BffBBB\BBpBBBRBBBB {B B{B  B(B{BB33BB B 33A
=A(A
AHA33ApA
AAABHBzBHBHB pB(B
=BpB  BBpA
A
=AAA{ApARA\AAAQA{AffAffARAA(AA
=AAA33AffAAAQAA߮A߮AA
AA
=A(ARA뙚A
AHA
=A뙚A  A=qAHA홚AAffA
=A  AA{A\)AGA(AAffAAA{AQA\AAzA33A\ApA\)AAGA  ARARAAzAA\A(AzAGAAffA  A33AAAAAA33AQA
=AHAׅAA{AHAޏ\AAۅAAQAHA
AAAGAAԏ\AffA
AGAAQAA33AA֣AՙAGAۙAA(AA33AffA(AAAA33AA(A=qA33A{BzA  AAA(AB QBB33ABA
=BBffB\)BHB=qB  AA\AGAQA=qA=qA33ARA
=AA=qAAA\AAA
AA\B B {B \AAAzA33A\A\A
AAA
=AAAA=qA
A癚A  A陚A
A
=AffAAffApAA33AffA=qAAA\A
=AA
=A
A{A=qAAzAᙚA
=ApA{AHAAffA
=AHApA\ApAAAAA=qAAzB GB  ARA{AAGAA(ApAHAHAAAHA  A=qAHA
AzAAA홚A=qAGAA=qAAA33AARAGA  AA
=BB {ApA\AHAA33AAffAHA(A  AHA\AzAHA{AffA
AHAQAHA홚A=qAzAffAA  AA\)ApA=qAGAA33AAQAA(AAzAB{BB33B zAffB \)B{AGBffB\)B
BBpBBBRBHB{BzBzBHBB 33AAzB ApBGAAHB RBffBHBBBzB \A
B\BpBRBB  B ffAA33AA  ApA\AffBABzB {B (A
AB{A\AGA=qAAGAQA  AffAARA=qA
ARAffA  ARA33AA
AAAA{A\ApA{A{A  AzAzA(AHAffAARAAB  BB
BzB=qBGAHA\)AHApA\B RBB
=B{B
=BQB33B  BBpAB ffB B\)BzBBHBB{BHBQB   A
A
=A{AAAAAGAAA\)AA{AQA\AAGAA=qAA\)AHARA  AAAA
AAA\)AA
=AHA\)A  A癚A
A
AGAzAQA\AQA\)AAQA
A33AQA
=AA{A\A뙚AAA=qAzA\)AA\)AQApARAAffAHAAAGAzApA\)AGApAffA33AHAHApAAzAAzA\)AA  A
A\AAAzA
A
=AffA  AAHAAzA
A  AA{AAAAzAzA(AApA33AAAQAAGAAAzA\AAAA\AA(ARARAA\)AAAAAAAAAAAzAAHA\A{ApAA=qA{AzA  AA
=A\)A(AA\)AAA33AAApAApAzAzAA(AAQAHA(AAARA(A  AA
A\AQAffARAA
AffA(AGA33A  A33A=qA33A33AzAHAAAA\ABA
A{AAA33ApA{AQA{AApAffAAA(AA=qA  ARARAGA
=A癚AAAHA33A
=AA33A
AݮA
AffAAA=qA
AAAA(AQA33AB \B=qA33A  AzA33AAAffAA33AAQA\AAzA(AGAB AQA\A  AQAHAA  AAAAHAHBRBRAB ffAA\)AGAA
AGA(ARA
=AAA33AAAAB
=AB BB{B\BB33BffB\)AQA{ARA
AAA
A\)A
=A
=A
=A
A=qAAApAA33AGAAARAAAAA33ARA\A(A(AAQA
=AAA33A
=B 
A
ARA{AAA\AA
=AA=qAffAffAARAA홚AApA\)AA
=A  ARAQAAAA\)AzA=qAAA
=AAAA  A
=AAAffAAApAGAzA(A噚AGA=qA
A
=A߮AGA
AA\)ARAffAA(AA
=AܣARAApApAAffA؏\AAA  AAHA(AAffA  AAQA  AQApA=qA\A33AffAAHAQAffAAHA
=A{AHAGA(AQA=qA{AA
AAHAAffAAzA  A  AAAGAA{AzAAA{AAzAAGA\)A33ApA33AA  AAA33AQA(AA(A=qA
A{AA=qAAAA{A
=A=qA=qA(AARA\)AGAQAHA
AA\AAHA݅A\)A  A=qAAAAHARA33AHA%AיAᙚA
AAAᙚA{A(A\AA\AAA(AQAffAיAAHAAQA  AA홚A=qAffApAA(B A  A{A(AApAQARApAA{A\)AAGAAA
AzAA{AzAA\)A  BB
B B 
=B=qBA(B{A
A
AARA
=ApA
=AHA=qA=qA\)ApA
AAAQA  A=qA
A\AAA噚AA(AA޸RA  AA{AAffAHA
AffA\A{B
=B B (AAGAAB zB RB QAA  B =qA\AffAzAAAAHAAHARA33AAffAA\AA\)A=qA\AA
=A
A{AA\)A\)AAAA=qA=qAAQAA(A(AA癚A33AGA  A\)AA33AHA\A=qA{A
=AB 
B=qBB=qB pAffAAA{A33AAGAARApAAHAQARA  A
ARAAHA\AA噚A\A
A33ARAApAAAAAAARAAAzAA\)A  A
AAA\A\AיAHAARA\)AAQA
AA33A
=A  AQAffA=qAAGAffAAA(AA=qA
=AHA
AHA{AA(A=qAffA33A\A\AffA{AA\)A
AAAAA
=A
=AA
=AA\)B QBzBffBBB
BBB  B\)BQBB pApAHAGAA(B33BBB\BBB(=#
B\)BBBzBRBBA
A\B 
=A\AB \ARAQAA
=AGA=qAARAA=qAHAffAAzApAAzAAGAAzA33B  B
=BpBB(B
=BBBBRBB ffB
BzBAA
=AAffAAAAAQAA\)A\)AAGA=qApA(A
=A\AHA\AأAApAݮAQAHA  AffAGAAAAzAHAzA(A
AGAAA=qARA(AA{A
=AApAzAAA܏\AGAᙚAأAA33AѮA(A
A=qA
=AffAffAAQAQA(AӮA33A  BAzAB BzABAHA33AHA
AA{ApAAAAA33A(AA  A
=AAA=qAA  A=qA33A
A=qA{A\)B ffAAHA33ABA
B BffB  BHA=qAB=qB \)BBBBA\)ARAA\)A(AHAQAAAAAA{ARA
A  A{AAA
AAAQAARAAAGAHABB33BffBzBpBHBRBB
BffBBQBzBzB(BRB\A(AAffAzA  AAA  ApAAQAAffAA{A홚A\AAQAAApA33AAA\A{A33ARA=qAGB A{A  BAB   BBpBBzBGBpBB\)BQBBBBB{BAzAA
A
=A\)A  ARA\)AA=qA\)A
AAARAHA  A
ARABzBB
BpB  BBBHBB(B AffAAzA
A{AAzAA33AzAAA{AAzApAARAA  AGAA㙚AQA=qAAA㙚AGAzAzA33A\AHA\A(AA  AA33AAHAB B\BA\)B B  BAB\)AB \BzBAAAQA(AB  B  AAAAAA=qApA{AAAHA  AAAGAffA
=AA  AڸRAڸRA=qAڣA
=A(AffA׮AzAAzA=qA(AޣAA\A߅A\ARARAQAffAzA\AAB B  B \AAAzA
A33A  ApAA(B  A=qA
=B B\)B{B
BQB  AHBRA\)B\)BRBffA\A  AHB B AHA
=AAAB  B\)A{AA\)AHAzA{A=qAzA(ARAAAA\B{B 33B(BBB
=B33B pAzA\AAAGAHAA=qAAA=qA33A{AHA\A\A33B
BBQBRBzB\B{B=qB\BQB  BRB
=B =qBRBB   AA\AAAA=qA{A\A
B (A33B {AB (B A\AAAQAA=qB33BpBBzBB=qBpBQB\BHBBBBB B RARAA(AAaAAA=qAA  A=qA뙚A(AAAA{A{AzAA
=A
AA\)AffARB 
=AB B\BB33BpB\B pB RAB   B B 
=B QBAQB(BBBBRBBRB\)BGB  BBQB\)BHB\)A33A\BRB  A
BpBAGBB \B=qB(BB(BRB\)BB
=BRAAA=qApAffAAHAAA홚AAffAA
@QAA\)A뙚AffAA
=AA
A\)ARAA陚AA癚ARAޣA
AA
=ApAHA=qA\A  A\)AApAffA陚AAHA
=AA  A=qA=qA=qA{A=qAHAGA=qAQAAAQA{AHApAB BpA(A=qARA
AAAAHAAB AB {B \)B A{AGA  A(A=qAA{A(AA  A  A(A(A
=AA=qAAAA(AAA{AffApBpBGBpBBBB{BAB A
BB(BpB RB BQC#B\B\BBGBzB
=BBB
BBRBBB=qApB(BGBB\BB  B B  A  AffAA=qAAffA
AA
AffAAQApAAA\)AA33ApAAAHA  AQA33AzA\)AAݮA(AA
=AAARAA(A
AA33AAA
=A\)A  A  A\)AGApAA33AA{A\A(B  A
AA
=ApAffAzAAAAA
=B33AAB AGA\)BzB
BQA33AQB   ARA\)A=qApApA(ARA
A33AARA(A\ApAAޣA{AAA=qA
AẠA=qAəAffAA
=A\ARA\AAAA=qAffAQAAHA(AAA
=A=qAAHA(A(A=qAHAApAzA\AAAAAAA33AA=qARApA=qApA  AA\AA\A\)A=qAAAQARA\AAGAGAffA
AARAAAA{AAB 33A
A
=AGApA=qBBzBpB\)A=qAAGAAAA(AHA߮ApAzA
ApA홚AAffARAA\AffAHAzA
AHA  A\)A  @ٙ@@{@޸R@Q@{@
=@  @33@{@?(?????
=q?z?
=q?z??\)?
=q?z??(?(?!G?(??
=?#
??(?!G?#
?0?(?(?R?&ff?#
?(?!G?#
?!G?R??!G?
=?R?!G?#
?!G?.{?@  ?R?+?=p?+?(?R?@  ?Tz?h??\)?:H???333?(?+?(?.{?
=?B\?h?Tz?:H?5?#
?Y?333?c
?B\?8Q?8Q?5?@  ?O\)?=p?(?R?333?8Q?E??=p?(?&ff?@  ?J=q?G?J=q?B\?&ff?5?5?+?&ff?+?(?!G?&ff?.{??!G?.{?#
?+?8Q?+?#
?(?+?E?@  ?G?=p?Q?Q?Q?G?J=q?E?B\?@  ?5?8Q?&ff?z?\)?????
=q??\)??R?R?!G?B\?z?=p?.{?\)?5?+?5?5?@  ?Y?E?5?
=?R?(?(?(?333?+?L?:H?R?#
?R?(?(?333?z?(??
=?(?\)?z?(?
=?
=q??\)?z??
=??!G?(?0?333?(?+?&ff?.{?333?0?=p?.{?8Q?333?+?5?333?+?.{?+?.{?5?8Q?333?5?@  ?=p?B\?8Q?0?B\?8Q?5?0?@  ?5?#
?0?333?R?#
?5?0?&ff?&ff?+?+?#
?+?!G?+??!G?!G??#
?(?333?(?
=?0?z?G?Y?^R?W
=?Q?L?333?#
?&ff?=p?(?#
?.{?.{?+?0?8Q?:H?B\?L?R?L?E?:H?333?(?=p?5?:H?=p?@  ?J=q?O\)?B\?@  ?J=q?E?B\?=p?B\?B\?J=q?B\?=p?:H?5?@  ?J=q?E?E?G?@  ?W
=?Y?\(?W
=?\(?Y?\(?^R?Y?Tz?Y?^R?W
=?J=q?p?G?G?B\?333?@  ?\(?u?xQ?^R?&ff?5?&ff?5?B\?+?(?#
?5?R?0?0?:H?0?(?+?8Q?E?Q?J=q?J=q?L?@  ?Q?O\)?B\?E?Tz?Tz?=p?J=q?5?0?8Q?8Q?B\?.{?0?333?&ff?k?5?0?333?G?:H?G?J=q?Q?L?aG?p?W
=?J=q?:H?@  ?=p?5?=p?333?5?B\?J=q?L?Q?L?O\)?Y?Tz?Q?\(?G?L?Y?fff?L?O\)?\(?Tz?Q?\(?aG?Q?Y?Y?Y?J=q?aG?n{?u?p?\(?W
=?^R?W
=?c
?
?ff??  ?ff?=q?s33?p?ff?{???\)??\??=q??z???33?????}p?zH?xQ?zH?}p?  ??zH?u?  ?zH???
???}p?  ?u?xQ?}p?}p?}p?u?c
?  ?\?G?p?zH?ff?G?G?xQ?
?aG?h?c
?\?\)?u?\?
?????=q?=q?z??=q?=q????{?????z??Q??
=?
=??Q??{?
???  ?  ?z?(?H?
=?
?ff?p?R????
???u?xQ?n{?  ?Q?Q?ff??z?z???=q??33??z?????33?33?p?(????Q?
=?R??(?
??33??p???z?
=?z?z?Q?(?z??z?p?
=?
=?
=??R??=q??Q??=q??
=?  ?p?G?Q?  ?{?p???ff?Q???{?{???zH???\)???
=?z???(???G?xQ?\?G?
?
?
????33?p?(?
=??
=?H?=q?H?Q?p?R?  ?
=??p?33??Q??(??33???
?G??{?  ?(?(?H?p?H?Q?  ?p?p?  ?H??(?  ???=q?\?\???=q?  ?
=??=q???p?33????=q??\??\?
=?\)?У?z?=q?
=@\?Q@?33?ff???G??\)?p?p?(???{???
=?G?ff??ff?\?Q???33?R?33?  ??=q?z?G?ff?H?G??Q?(?33?(??=q?G?  ?(Bܮ??\)??
=?
=?\)?{??=q?=q??
?H??R??33?  ?=q??G?\?
?\?R?H?
=???H??z?
=??{???\)?33???p??  ?R?
=??Q?z???=q???=q???  ?Q?(?(?R?Q?
=?  ?p?33?p?H?33?H?(???G?
=?
=?(?  ?\)?33???z??H?G?  ??ff?=q???  ?\?
?\?ff?(??p?H?(?R?p?z?
=?=q???
??R??p?z??
=??p?ff??Q?H??33???\)?(?R?R?Q??33??H?(?  ?z??\)??ff?\)?
??{??ff??\)??{?\)?{?=q?
?????p?\)?=q?\)?{?=q???\)????ff??\)?33??
=?33?Q?G???
=?H?R?(?
=?z??Q??{??Q?
=?R?{?z?z?33?У???(?
=?H?\?33?33??R?
??  ?ff?=q?\??H?H?Ǯ?ff?\??\)?
?H?G?  ???Q?p??H?\??Q?(?
=?H??(?{?\??G?У?
=?{??\)?У?G??33???{?Q?Q???{?33?=q?R?=q????\)?=q?=q?{?ff??ff??Q?33?H?G?H?˅??(?H??Q?Q?33?z?\?=q?y ??Ǯ?H?(?p??  ??33?\???33???\)??{??Q??\)?H?33?\?\???33?(?
=?Ǯ?{??=q??H??\???(?\?=q?\?
?(?  ?R?\?(???33??z??33?\)?z????{?{?z???33??Q?\)?ff?p???H???
=?H?(??Q?(?R??H?(?\?=q???
=??{?H?ٙ?Q?p?H?(?(?H?{?33???޸R?޸R??\?H?p???˅??\)?R??R?R?R?R?R?Q?ff?(??У??=q?G?p?G?z??  ?
=?\?G?\?(?(?(?Q?(??
=??G???z???(?  ?Ǯ?\?p??Q?H?
=?Q??R?R?  ?
=?Q??z?z??R?p?{?H????R??{?
?\?\?\??ff???
?R?R?\?  ??\?˅?G?\?  ?  ??H?\?\??ff??\??˅?Ǯ??˅?G?R?  ?(?  ?=q?Ǯ?\)?{?=q?˅??
?  ?
??G?ff?\??  ?
?p??  ?z??\)?z?Q?(?(?\?ff?  ?H?  ?\?H??
=?
=?33??
=?p?Q?
=?z?Q?{???H????\)?z?z?=q?˅?R??Q?R?  ?z?p?p?R?H??  ?p?  ?H?
?(?(?G?p?  ?
?R??z??Q??ff??
?H?\)???H?{?????Q?z?z?z?33?33???33?z?R?R?33??H?33?Q??{????z?
=??=q?=q??=q?R?=q???R??=q??=q?
???  ?=q?{??\)?{????33?33??=q?z?
=?33???\)?
=???Q?z???
=?z?p?z?
=?
=?(?33???=q?\)??\)?=q?(??H?(?p?p?  ?ff??=q???????33??=q??????{??=q????33?p?G???R??\)????ff?
??
??Q?\)??
?H?(???G?33?33???H?
=?
=??z??
=?\)???Q?z?=q?z?
=?\)??  ?G?  ?ٙ?Ǯ?  ?˅?
=?\)??G?(?z?Ǯ?p?z?z?\)???G?H?R?p??(?H?H?R?ff?  ??R?(?R?(?\?G?H?z?Q???p?H?ff?R?\??ff??{???\?  ?Q?G??ff???Q?G?=q??
=??????(?z?  ??H?
=?\)?z?Q?33?H??33?R?\?  ?  ??
??{??=q??
=?{?\)??
=?\)?z?z??  ?H?33?
=?  ?G?
?  ?(??{???{?\)?33?33?33?
??ff?G?G???33?{?\?{?
=?33??\?Q?R?(?
=?33??(??z??H?33?(?33?33???\?
=??{?\??{?{??p????????z?z?z?33?\)???G?G?=q??
=?p?R?p?Ǯ?33?H??z??{??{?
??p?ff?˅?
??=q?˅???G?Ǯ?˅??޸R?
=??  ??ff?z??H?H?  ?Ǯ??(?H?У?(?Q?˅?  ?  ?H?p?  ?H?
=????(?
?  ?z??Q?p?У?{?p?У?33?޸R??p@\@G??(@G?\)?(?{??z?
?z?ff?z@?ff???H??Ǯ?\?R?@+@Y@\@dz@G@E@1@)@,@3
@\)@=q@H@@=q@}p@e@Mp@l@s33@A@C33@7
=@L@@G@
=@=q@@@w@W@R\@^R@U@<@7
=@(Q@'
=@0@R\@O\)@:=q@NR@4z@Fff@>{@Dz@p@P  @[@=q@X@@g@u@@@  @qG@\@^R@|(@@\)@r\@\)@R@R@@@ff@{A
=qA{A33@ۅ@
@33@pA=q@G@ƸR@@Q@@@q@Y@NR@N{@o\)@j=q@#
A\)@R@
=@Ǯ@@\)@ff@=q@@{@@ʏ\@ə@@p@@=q@y@@~R@`  @E@  @{@\)@@@@@@@  @hQ@A@p@B\@C33@S33@W
=@#
@1G@.R@Dz@R\@G
=@@,(@
=@{@@@0  @ZH@A@Q@_\)@=q@\)@AA%AXQAZffAd  ATQAARA{AGA(A
=AQA9pAXATA]AJ\@@p@\)@ff@{@@ȣ@ARA\)AGAA
Aff@=q@A@\@
@Q@z@H@(A	G@H@@  @Q@ٙ@陚@{@@
@@G@@{@@
=@@@@~R@\@\)@H@R@^{@b\@Fff@\@Q@W
=@4z@!@)@G@c33@e@=p@5@G@G@=p@5@.{@33@@(Q@7@9@>{@!@ff?@@@Q@\?33?
??@\@
@{@@\@   ?\)@   @
H??
=?(?@
=q@\@{@
p?Q?@\@\?G?=q?R@Q?33?{?޸R?H@@@0@'
=@0@Q@H@p@
H@*=q@.{@/\)@!@\)@@\)@
=q@
=q@Q?\)@@	?Q@z@G?
??=q@   @
=?
=?H?G?޸R?p???  ??R?p?ٙ@?  ?p??G?\)?У?(??@G?
=??G?ff@
=@
=?R@ @
=q@@@ @?p?@G@@@ @
H??G?ff?=q?=q@G?\)??@?G??H???
=?ff?z?{?{?33?Q?
??p?{@@
??ٙ?
=??
??G?G?\?\)??{?@ @\@R?p?(@
p@(@
@Q@z@@
=@??{???p?(?У?Q?  ?{?@\??
=?p@
@'
=@
@1@@ff?z@   @\@G?z@G@ff?z??ٙ??\??
??\??H?У?ff?ff?\)?У?\?p?
=??G?\?G?޸R??˅?\)?\)?(@
H@@@@
=q@ff@  @
@!G@,(@*=q@@@  @{?@   ?{@33???  ?ff?z@
?\??R?33??z???޸R?˅?z?
?ٙ?=q?  ?  ?p?
=?G?\)??(??ٙ?p?p?У?\)?H?p?H?
=?
=?У?޸R???H?{?\)?У?H?=q?{?R@ ?H?G?(?\??=q?=q?z?H?У?Q????33??z?Q?{?Q?(?=q??{?
=?{??ff?H?z???˅?\)?33????ff?G???33?{??R?(?
??
?33??z??G??p??33?R????
=???p?33?Ǯ?33?
=?33???=q?=q??{???\?=q?{?ٙ??\?(??=q??????ff?=q?z??
=?????ff?(?
?Q?(???z?z?R?H?Ǯ?=q??=q?33?Ǯ?ff?R?z?H?
?У???(?ٙ?z?H@ @	@z@\@G@
=@?\)@9@!G@+@%@333@8@G
=@=p@]p@[@qG@n{@Y@\(@U@e@H@G@p@zH@(@p@p@@@
=@{@33@(@@Q@=q@@H@R@@@ff@@@R@
@=q@@@  @R@@@G@{@@@ff@@Å@33@{@@@@\@  @\@z@H@@=q@@(@G@Q@Ϯ@@@{@G@@(@ٙ@z@@A33AH@zAQAA33AA (@33AA
{AA
pA A&ffA%GAA%pA\)A33A*=qA\A{A{AAzA  ARAHA
AA\AzA=qAGApAffA\)A\A%A+\)A/AaAB=qABffAffA  AQA  AQApA{A(A
=AAAzAɅAAQAAAA
=AABBB	B
=AřAQBBHB*RB"ffABGB%\)BB
\)BAffA\(AcApAg33ARRAN\APAZ\AbHAQA^ffAVffAeAn{A|A`  A}AAW
AGAffAo\)At(AAepAdAmA\)ApAA=qAt(AzAA
=AAffAAzA=qAAAHA\)AA\A(A  AՅAQAA{AυA=qAQBA=qAABAAQBGB
A(BzffA
B"pB\Bc
B*
B(HB$BB
=B BД{B}\)BQBqB?(BvRBHBIffC@qB7BM=qBb=qBkBDBb(BEBFffB{BGB|GBQBRB}RBz
=B'  BJ(Bճ3B?BB`\B8B/=qBM\B3RBOHB]HBABRBTBB+B*BB?
=A
B;33B6B/B=qBzBDzBDpB`RBPpBR  BUB;B33BNRBu
=B33BpB8RB#BBAHBlBB~  Bs{BsBhHBkBnHBQBeBczBBBBB)BB3B3BB(B
BaHB}33B^(BnBA
=B.BBuBBB BBW
B.BB33BBtQB{BB33BRBqB{BuBkBB  BBBQBu\)BuBHBA0A  BBoffB.BnGBtB&B>ffBB|HB[33BBwB]\BTBBBY\BHB.B{BBRffB33BQB(B3ffB(B)BfBzBW
BpBB)B(BąB33B{BBBB\)BzBB33BօB{B\B)BBBB)BQBBB
=BB#BBB(BLB
=BaHBB
C
B=qBոRBW
BpB\B{B33BB  B=qBkBC(BLBBBffBGBpBÏ\B
=BBBBaHBЊ=BBǮBpB\BB.B(B(BB{BۨB\B BpB AHB33BBuBCffBLBBW
B\)BLCٚB
C
HB޳3Bϳ3BBBuB.BBCBHB(CB)BBQBpBuBBBZHBBaHB B=B BLBHBB(BHBQB.BW
B)BB#BؙB{BC	fB۸RBBuBըB\B
B߳3BB
BBBCJ=BBC\B  BBȮBԔ{BB#BfC(C=CB(B׸RBkC!+C
&fCCzCC'C;W
CzCfCxRC^C   BBBBꙚBQBCCٚC%Cq0CBzB
=B޸RCBQB
C0BRC nB׊=BC1qB{BB33BC GBLBGBřB{BRB=qB.B\BGBzB)CYB\)CpBpBB BHBffCC=C)BfC^B.B=qC5C&(CffC\B
CٚBB=qC
=CB{B33BHB  BBuBď\BǨBBC
hC	s3B홚B=qBHB3BLBǮB BLCD BC+\C=33C1O\C-BHBC/pC&uBފ=B C$
=C
=B  A
BB#BBĞBLBB3C C2CuC
B{C{CO\BB=qBt
CBaHCBCB\)B.CC1\BBHCHBzC	\)C	
BW
CB
CC9pCCJ=C	uCzCpCBC&C(C+CBHC=C
  C&fC{B3CBBC(B{CkCC
!HC8RC{BݙBGCqCR#C$=C {C  C!=qC$\C% C\)C
{CffC4fC)C
C
BǮC
C	BkC.BfCRBpC7cABzC
=BӽqA˅BBW
BL\BBuBBaHBzBBۀ BBffB33BCaHB\)Cs3BRBLB\B\)BfB  BBNzBqBW
BHB.BBBW
BB=qC(CٚC޸CBqBQBffCT{BBBB\)BBuBB{BC 5C	qBD1ФB
=BBBuB33BBCCs3BBLBfB
=BfB  BBʔ{BB8RB)BzB홚BRB{BqA_\)@z@HA QA\)A&H@\A/33A	A;33AA\  A0@
=@@GAHA)pAA(A  ApA@陚@ffA\@ff@zAA@@
=A4(AAHA   AAAA{AzA'A+\)AAA#AA  AA{ApAAAA$@A	pA7
=A
=BJzA QA(AAFH@A
=@
=AA(A2HA\A (@أA"=qAB\A A
=qAA(AQA6\AA{AHA	AzA(A=pAA(AA>=qAIpA:R@=qA6RA4(ACA\A>\AVffA.\A6ffATAAzA&H@@AAA(AA@pA\A.HA2ffA(AUAGA
AAG@A+
A	@A=qAApA=qA'@pA
RA\ARA\AzA%GAzA1GAA!GA+AA'33A z@\)A!A&=q@ff@@{@@\)@RAIA
A
=@
@Q@ff@R@p@ٙ@@{@
@޸R@@=q@=q@\)@أ@޸RA Q@p@@H@@@QA@ָR@ff@@H@@@\@(@\)@@Q@HA33@ff@Q@׮AS@@=q@ڏ\@@
@@
=@33@  @ʏ\@@G@θR@G@Q@љ@׮@
=@33@ff@@ABaHA
\@AH@ָR@G@@@@ff@ٙ@@
@ff@33@@@=q@@@ᙚ@R@߮@
=@\)@33@@ٙ@@(@(@@G@z@أ@Q@ҏ\@@ָR@ff@p@أ@@33@@{@ڏ\@ff@Q@G@G@@ff@p@@(@@AB\AzB.@˅@@@ָR@H@R@@@@\)A"{AW33@
B2H@RBN33@@z@أA$(@=qBe@@@=q@@
@@@\@  @˅@Q@ٙ@p@  @θR@G@@@HAS@@@\)@ə@{@@@@\)@@  @=q@ff@Q@=q@˅@H@G@  @{@ə@ڏ\@ҏ\@@p@@\)@33@(@ƸR@Ǯ@p@z@  @(@ə@ȣ@{@=q@G@(@@@GA@ff@˅@{@θR@z@Ǯ@Å@  @H@ff@AzA33@{@
@  @  @Ǯ@˅@\)@Ǯ@ff@z@Q@\)@@33@@{@@@z@  @H@H@@(@Q@ff@
@@33@ff@@@@Q@{@@=q@
@ff@@@R@\@z@@@@\)@@\@@\)@@@@z@(@G@
@(@
=@  @z@@33@@(@z@(@@  @H@G@\)@{@  @
=@R@Q@@@(@@\)@\@@ff@G@@@33@
@@
=@\@@\@@33@R@\@ff@\@
@\)@\)@(@H@@@\)@
@{@@z@
@
=@A>H@pA @33@\)@R@{@R@@@ffA
AZHBpA*\@@z@@z@\@H@R@@R@@{@@{@@@@@(@\)@(@ff@H@  @@
=@\@33@@@33@@@ff@@\@@\)@H@\@@R@
=@@@{@
=@@=q@z@
=@(@\@H@@@Q@G@Q@@\)@33@Q@
=@(@@p@R@  @@ff@
=@@\@\)@p@\@
=@\)@@@{@@@@@(@@@@Q@  @@ff@{@@  @@{@
=@@R@@@ff@{@p@@p@(@@H@Q@@@@@z@  @@@H@(@@@@@@\@Q@G@@p@z@  @z@
@(@G@p@\@@@\)@
=@\)@\)@
=@z@θR@p@Q@@G@@Q@@\@@p@@@  @  @@G@@@@G@@@ff@@@  @33@(@H@  @ff@@z@@@@  @@\)@@G@@@@
=@  @@@@p@@@R@z@
=@Q@
=@\)@@=q@@@Q@33@H@@@R@R@@R@G@=q@p@@H@@Q@@@@@@p@@@Q@H@G@@z@@(@\)@A(@ȣ@@\@G@G@{@(@(@
=@@@@@
=@@  @@H@  @\)@(@ff@=q@z@
@  @=q@Q@p@R@@R@ff@@R@(@@@p@{@
=@(@@R@ff@@Q@@ə@@ff@z@@z@@G@G@@Q@
=@R@Q@{@
=@R@ff@@p@
@@@33@ff@H@=q@@=q@(@@33@
@H@@@\@@@
=@p@=q@@{@@\@ff@
=@\)@@H@R@G@@@  @@H@=q@z@G@p@
@@{@p@
=@z@
=@ff@{@@  @@@  @Q@\)@@(@{@@@z@G@@\@G@@@p@  @@(@
=@@@@G@H@@G@(@ff@G@ff@(@@
@R@{@(@Q@@33@\)@p@@(@33@@\@@@@@@33@Q@33@=q@@Q@@G@(@@@p@H@@(@p@H@33@(@@ff@\@@\@@R@@Q@@Q@@ff@{@@
@(@@ff@\)@H@G@
@\@@\@@  @G@33@H@  @p@\)@R@@G@@@@z@\)@@{@@@
=@\@ff@
=@z@=q@p@@@@@@@@H@@@@@@@p@@
=@p@@@z@  @@33@{@33@@p@@=q@G@p@(@  @@z@@p@R@33@@p@@(@\)@{@{@z@@@y @@@@@@  @@@@@G@@@=q@@G@\@@@G@33@
=@@H@R@@@@@p@z@@z@
@z@@
@33@@@@@@
@{@p@z@p@\)@@Q@@
=@@{@@\@Q@@@\@
=@@p@z@\)@z@{@=q@\)@  @ff@
@@
@ff@Q@
@@@  @
=@\@@@ff@R@@Q@R@=q@Q@R@@@@@(@@@@G@@@\@@@H@(@33@(@\@\@G@@ff@@@@33@@  @Q@(@{@H@@  @@ff@@@p@{@@=q@@p@H@R@
@@@(@R@ff@@@\)@\@G@
@@@
=@Q@  @ff@=q@(@33@
@33@ff@@  @@Q@@Q@33@=q@@ff@@@@@33@\)@(@ff@z@{@@(@|@  @~{@  @Q@z@@@ff@@{@\)@\)@p@p@
=@p@{@H@@@ff@@ff@Q@z@z@@z@{@w@g
=@g
=@hQ@h@g
=@l@k@fff@jH@=q@  @~{@  @u@u@y@x@@|@|@y@w
=@vff@nR@s33@@q@nR@p@vff@y@33@zH@s
@Q@@|@~R@~{@@z=q@b\@w
=@p@l@n{@j=q@l(@xQ@x@u@vff@tz@~R@@z=q@}p@w@p@p@zH@~{@x@x@xQ@u@s
@u@s33@n{@s33@mp@w
=@u@u@w
=@tz@u@s
@qG@k@l(@l(@j=q@c33@hQ@mp@h@o\)@g@e@`@g
=@fff@`  @c
@g@dz@`  @dz@^{@^R@S
@fff@[@X@Q@ZH@ZH@]p@^{@QG@J=q@Fff@33@?\)@A@J=q@L@N{@W
=@\@X@W
=@S
@W
=@XQ@P  @L@S33@p  @XQ@P@NR@W
=@\(@qG@jH@j=q@p@s33@jH@r\@w
=@o\)@w
=@u@qG@=q@l(@e@zH@w
=@n{@`@U@K@R\@S
@U@Q@Tz@S33@P@O\)@R\@Q@P@QG@QG@R\@U@P@S33@P  @P  @Q@R\@S
@U@Q@NR@S33@W@W@Vff@W@Mp@U@U@Y@Z=qy @NR@C33@E@9@Dz@5@5@8@AG@1G@1@E@.R@Q@@  @N{@Dz@Fff@K@>{@G
=@@  @<@<@=p@=p@Dz@=p@<(@@@<(@:H@Dz@@  @9@<(@6ff@9@<(@<(@<@陚@>R@=p@G@K@L@JH@Q@Mp@J=q@HQ@Fff@E@G@Dz@J=q@N{@Fff@H@C33@Dz@E@E@G@E@C
@HQ@Fff@J=q@K@Mp@I@S33@NR@JH@U@XQ@^R@Tz@dz@c
@X@[@W@Z=q@Tz@O\)@U@R\@X@O\)@NR@W@XQ@U@U@XQ@Tz@P  @H@U@QG@P@O\)@O\)@H@H@Tz@J=q@E@B\@<@;@9@<@Fff@B\@O\)@O\)@P  @R\@QG@Z=q@j=q@QAff@jH@p  @jH@e@z@jH@X@S33@N{@aG@Z=q@Vff@R\@z@P  @C
@JH@Dz@AG@>R@;@AG@9@:H@=p@:=q@>{@>R@=p@<@?\)@N{@K@W
=@Z=q@S
@W
=@S
@S
@S33@Q@N{@Mp@L@QG@[@^{@_\)@ZH@Å@Z=q@Vff@W
=@Vff@_\)@Y@U@K@NR@L(@J=q@Mp@JH@Mp@I@aG@H@N{@P  @R\@K@QG@B\@A@Y@L(@_\)@l(@W
=@Fff@Tz@a@U@S
@U@aG@S33@S
@Tz@P@U@S33@Vff@E@G
=@G
=@E@L@Q@H@J=q@J=q@a@L@HQ@P  @p@{@hQ@W
=@G@L@J=q@aG@`@\(@\@\@S33@W
=@P@QG@W
=@P@P@R\@QG@U@R\@W@Vff@Y@Tz@aG@R\@P@]p@R\@W@Vff@Q@S
@NR@L@S33@P@O\)@QG@JH@O\)@NR@P  @L(@I@HQ@I@JH@L@K@O\)@Y@G@Mp@L@I@J=q@NR@N{@L(@J=q@E@C
@@  @E@H@B\@G
=@J=q@H@O\)@S
@R\@L(@I@K@L@]p@P@E@C33@L@Fff@C33@@@L(@A@AG@C
@C
@AG@@  @>R@?\)@=p@HQ@Q@J=q@S
@QG@S33@S33@S33@U@S
@R\@Q@S33@XQ@`  @^{@[@\@XQ@Vff@U@Z=q@Z=q@[@a@U@Q@XQ@Vff@Y@U@W
=@S
@^R@Z=q@ZH@^{@dz@hQ@aG@b\@]p@]p@S33@U@^{@c33@aG@c33@`  @`@]p@U@Tz@P  @S
@XQ@b\@Y@`@c
@g
=@g@aG@g
=@aG@a@dz@e@e@dz@\(@c33@a@^R@`  @c
@e@e@c33@`@_\)@c33@^{@c
@c33@c
@c
@c33@Y@Q@S
@XQ@Y@U@W
=@W@W
=A-A{AGA(AAA  A33A  A\A33A33AA	A
A33AffAAAffAAAGA\)A
A
A
=A
=A@  ApA
A{AHAAAAAAGApAAAGAAAApAGAAGA\A=qAAApAAQA33A(AA33AA=qA
=A\)A=qAA33AHA{AA=qAAAGApAffA33AAA33A	AffAAffA{A\)A
RAAA	pA
{A
A
A=qA
HAA
=qA	GA	A33A
=AzAAA
=A
pAA
=A=qAGAQAAQAA  AHA
=A\A{A(AA  AHA Ap@
=A=qA\A33A (A\A\)A{@GA QAA  A   A A @ff@@z@(A (@@@ff@G@\@@AG@A AA ARAR@RA (ApA{@
@@@@y @z@@
=@z@p@(@(@
=@(@@H@\@\@@z@A
A(@p@@@@RA   AA z@p@\)A
=AA (@ff@RA@A QA AQA33A4Ap@A (@RA-A (A QA @
=@
=@@\AnR@@@@(@A{A@33@@\@\)@@pAA@A
ff@A	@H@pAA
=A@@\)@
A=q@33A
{AG@ff@
=@R@
@AGA@{A
A
@pA\)AA\)@@p@(@pA QA@@p@ffAAA QA33AAzA (@@  @
=@\@AR@@ff@@ff@
@p@R@H@H@@@=q@@
=@@@\)@{A
=AGAA
AARA{@
=A Aff@Aff@@zA@RAR@A  @ffA
@R@zA!A=q@@@G@@@=q@
=A@
@{@@\@@33@\@A (A z@@@R@@@
=@p@z@G@A@@\@Q@G@@\)@@Q@@@@33@z@@  @@θR@p@{@@@ff@@H@@@@H@
@A A (A@A z@{@33@ff@@=q@@@(@Q@@HA@\)D|)@G@\)@H@Q@p@(@=q@@G@@(@@Q@G@@@
=@@@
=@\)@@@(@
@@AQ@
=@  @{@H@@@@  @@  @(@  @\@p@ff@@@R@p@
=@
=@ff@@Å@ff@@H@@ᙚ@z@=q@
=@G@G@
=@\@@\@
@@@G@
@Q@\@
=@@R@H@z@R@@  @
=@
@\)@\)@\)@p@(@(@{@@@(@@p@z@\y @@G@@(@@=q@@  @z@߮@@  @\)@@߮@{@\)@@ڏ\@@z@{@z@@{@@Q@@
=@H@=q@33@ᙚ@G@(@ff@z@G@33@
=@޸R@@@޸R@@
=@\)@@  @@(@H@H@H@H@=q@H@\@z@޸R@@=q@@G@
=@߮@\A\@@Q@@@@@\)@{@{@H@ָR@Q@ڏ\@{@33@  @G@@{@\)@߮@ٙ@  @@ᙚ@@G@\)@(@@@@H@
@z@z@z@@{@Ϯ@˅@Q@θR@H@(@@ff@ff@{@Q@@p@ff@H@
@  @ȣ@ȣ@ȣ@33@{@@
=@ʏ\@z@{@33@=q@H@H@Ǯ@G@=q@ʏ\@ʏ\@(@
=@@@H@˅@ڏ\@
=@θR@ff@
@
=@љ@θR@Ǯ@Ǯ@Q@
@33@@@@ff@  @@\@@@@ff@=q@=q@p@
=@@@\)@G@G@Q@\)@R@@z@@33@@G@\@@@33@\)@\)@@{@\)y @33@@@(@@@G@@H@z@H@\@=q@@H@{@Q@@
=@
@=q@\@ff@{@
=@ff@R@ff@\@  @\)@@Vff@A@@z@@
@  @
@33@@R@@@\@R@{@@z@  @z@R@@
=@@33@
=@@  @
=@ff@  @@@{@
=@{@R@@@@R@\)@@{@\@ff@{@
@
@
=@@\@@@=q@A*=q@  @陚@A<A@(AdA6HA_
A8A>HAaAAAAoA.ffAG
@zAyA'A-A6=qAAA;33A-AAzAA&{A	pA)@˅Aff@A.RA:{A@AW
=AN=qA   @@@R@ff@@G@=q@p@  @@@@\)@\)@@
@z@
=@@@@\@  @H@@~{@|(@G@~R@\)@w@u@@@@p@A@{@{@Q@@  @z@=q@
=@
@ȣ@@@@Q@
=@@@=q@33@@Q@
=@
@Q@p@l@g@g@k@S33@b\@g
=@@Tz@[@XQ@ZH@`  @^{@Vff@W
=@`@e@mp@q@nR@{@@@Q@{@p@@@@@\@ff@@\)@@=q@ff@ff@
=@u@qG@x@k@~R@g@nR@`  @dz@`  @Vff@[@W@S33@W@Tz@U@S33@W
=@U@Mp@P  @P  @NR@JH@G
=@E@'
=@K@L(@JH@NR@QG@S
@O\)@U@Vff@XQ@7
=@R\@Q@O\)@QG@Q@QG@S
@S
@HQ@Tz@Dz@H@Q@H@W
=@R\@<(@g
=@b\@P@L(@JH@333@J=q@K@Y@aG@N{@R\@Fff@P  @JH@]p@P@>R@1G@C
@P  @G@R\@\)@I@C
@c33@vff@P@S33@P@G@I@J=q@L(@Dz@NR@P@Tz@Tz@U@QG@:=q@:H@R\@X@W@g@x@s33@\@XQ@S
@O\)@[@G
=@I@L(@JH@Fff@G
=@K@JH@@E@G
=@L(@HQ@JH@L@JH@N{@N{@NR@P?@<@?\)@Mp@P@N{@NR@ff@JH@JH@,@C
@\)@H@L@R\@U@NR@HA7@U@c
@Y@S
@HQ@@@@  @J=q@>R@@  @A@W
=@@L@X@H@Dz@@  @<@?\)@>R@@=p@S33@z@?\)@?\)@<@?\)@A@@@A@G
=@E@H@S
@L@U@\@9@C33@A@C33@E@A@A@Dz@L(@-p@Tz@&ff@N{@JH@J=q@H@HQ@HQ@HQ@I@E@HQ@G
=@L(@Mp@L@&ff@O\)@L@=q@:H@Mp@7@(Q@"\@L@L@\@NR@Mp@B\@H@P@jH@:=q@O\)@L(@S
@P  y @I@O\)@U@Q@P@|(@K@L@@c
@ڏ\@(@
=@=q@  @R@33@@
@@33@r\@Y@Q@Q@Y@c33@L@QG@QG@Dz@E@K@JH@G@NR@HQ@Q@L(@L@@A@Q@%@_\)@L(@N{@N{@z@   @QG@QG@Fff@N{@N{@{@NR@K@=p@G@JH@L@i@P@P@O\)@Mp@O\)@NR@NR@Mp@R\@R\@K?33@E?Q@B\@|@s
@I@K@O\)@Fff@W@G@dz@k@~{DA@Q@a@@ff@(@aG@xQ@_\)@a@#
@`@
@g
=@  @b\@i@{@@hQ@{@
=@W@  @[@ZH@^{@_\)@^{@[@^R@dz@{@hQ@@hQ@h@n{@h@~{@\)@g@[@\@X@W@@  @G
=@\@^{@7
=@ZH@ZH@?\)AJff@]p@^R@L@b\@c33@b\@b\@\@`@a@]p@_\)@ZH@:H@A@Vff@k@b\@L@tz@c
@P  @Fff@@@`  @@@@@y@l@|(@g@\)@@Q@  @W
=@[@ZH@^{@ZH@ZH@hQ@i@j=q@g
=@W@Y@^{@^{@`@`@fff@mpy @_\)@aG@Q@^R@aG@`  @c
@c33@dz@|(@hQ@@
@@R@fff@e@}p@`@@Fff@p@e@c
@fff@c
@mp@.{@G
=@ff@@@l(@e@  @_\)@:=q@^{@fff@e@fff@k@i@h@c
@{@g
=@@c33@c
@c
@O\)@dz@s33@zH@X@(@5@p@jH@i@l@k@h@nR@g@mp@Q@e@l(@H@ff@\@@33@@@ff@hQ@h@i@l@H@}p@w@@z@s33@Q@tz@y@s
@w@R@s
@z@@r\@@r\@@`  @qG@g@dz@h@e@fff@g@b\@dz@aG@`@33@e@g@i@g
=@fff@hQ@e@e@hQ@i@k@b\@mp@l@p  @qG@n{@tz@w@w
=@Q@33@b\@G@w
=@|(@w@vff@s33@q@q@+@J=q@xQ@=q@vff@u@o\)@u@~R@P@vff@@@l(@y@x@E@w
=@zH@@G@{@Q@@ff@
=@=q@@z@w@w
=@~{@q@
@}p@w
=@qG@\)@
=@(@NR@{@S
@{@  @w@r\@@Q@  @
=@y@G@@w@u@p@{@xQ@y@@|(@{@x@w
=@NR@s
@R@33@u?R@w@x@j=q@w@
H@w
=@u@,(@c
@c
@W@@vff@z@s
@vff@H@'@(@j=q@G@\@z@@p@@33@|(@
=@R@p@R@/\)@(@z@\@jH@@@H@ƸR@xQ@@z@H@G@  @R@H@{@p@{@@@
=@\@
@z@p@
=@@@Q@@\)@@H@
=@G@@33@@{@Q@R@\@=q@@@(@
=@@H@=q@=q@@(@@\)@p@Q@Q@L@ff@p@=q@G@z@  @\)@(@@@@=q@|@@@@G@Q@^{@|@  @@@@~R@  @@z@\)@RAî@{@Q@s
@@33@=q@@33@G@\)@Q@@Å@z@33@@@@@@@@@
@@R@z@@@G@ff@H@@@
=@  @\)@@@@@
=@Q@H@@@=q@G@@(@R@@@Q@@\)@33@@Q@@G@Q@(@H@
@\@@R@@G@HQ@@B
=@B{@@  @-p@@G@p@R@R@Q@(@p@@@@G@@R@@\)@@G@@
@@X@}p@
=@33@@z@ff@@p@p@{@Q@
=@@@G@@@R@ff@@
=@@{@z@H@\)@@
@33@@
@@@@{@ff@R@ff@{@@{@@@H@=q@@{@p@ffA,z@z@
@?\)@\y @(@R@Q@`  @r\@@33@p@p@@z@X@Z=q@@33@@  @G@=q@XQD?` @\)@\@E@ff@Py @ff@@\)@\)@^{@@"\@33@(@{@\D-D5@=q@=q@z@33@@\)@ff@R@Q@
@  @p@@@@@R@{@33@@@z@O\)@H@ff@Q@@\)@33@  @@@H@G@@@@p@{@\@=q@=q@@@@\@@@(@\@33@(@ff@{@Vff@@@(@Mp@z@33@@X@@p@{@G@@W@
@@H@z@z@q@`@H@@R@R@=q@@(@{@p@
@ff@p@
@{@@\)@@p@{@hQ@aG@=q@@(@Q@=q@p@
=@@@
=@Q@@@=q@(@@=q@\)@@
@@{@G@@~{@Q@\)@g@p@p@@z@  @ff@@c33@@@@H@
=@  @~R@u@=q@z@@p@
@@=q@
=@b\@=q@@@@  @33@H@(@xQ@p@C33@{@\@p@@
=@{@Q@G@@  @R@\@@(@@33@=q@\@@\@\@
@@@@(@&ff@ff@@,(@\@\@\@z@z@H@\@=q@\@ff@@R@@@@@@H@
@@@@G@ff@@@33@ff@@ff@R@{@@@p@@=q@\)@  @  @R@\@(@@H@@\@@
=@c
@
=@@@p@P  @@=q@q@@@@p@G@z@(@z@ff@@a@p@@aG@Q@{@ff@@H@
=@
=@@@(@G@{@  @ff@@@+@,(@i@@z=q@\@H@@@@A@@
@{@@@33@G@@{@ff@@@  @@\)@@@z@H@
@@
@@H@@{@  @\)@@@@
@@G@
=@@@
=@@(@R@@\@@ff@Q@
@z@@{@=q@@@@
=@i@@@NR@(@Vff@@ff@@33@\@@@{@\)@N{@N{@p@=q@E@>R@
@^{@z@@@@z@(@z@@nR@S
@@Q@G@G@33@@(@\@\)@
=@@p@@  @\)@@{@@  @z@
@\)@@
=@H@
@ff@˅@@љ@@@Q@
=@@@  @G@G@@H@z@=q@@@z@33@Az@@Q@=q@@@@R@@@
=@
@+@ff@=p@@H@33@G@z@z@@C
@q@@@\@@@(@\@
=@z@z@@@H@{@Q@=q@@@p@
@@@@G@@Q@@
=@@@ff@z@33@p@@ƸR@@@{@z@\)@
=@@
=@Q@@H@G@@=q@=q@\@{@@33@@z@G@Q@
=@\@G@  @{A\@
=@z@(@@@@  @@R@G@Q@@Q@\)@
=@w
=@B\@@@@ۅ@Q@@@@\@@{@{@@
=@\)@\@ff@\)@p@ff@@GCǮ@\)@H@@\@@
=@{@@  @@
=@@@(@z@{@ff@H@{@@@33@A
=@\@@@p@33@@33@H@Q@\)@Cd{@
@@  @\)@H@R@G@z@(@33@@z@ff@H@p@@R@@@@@\@{@Q@@Q@@33C@=q@=q@@@@33@Q@Q@@
@@
@z@@z@\)@
=@@G@\)@j=q@R@Q@g
=@\@\)@=q@JH@@p@33@Q@Q@C
D)@\@@\@(@33@@
@G
=@@p@p@U@@@@ff@{@@{@Q@R@(@p@@R@@
@@H@G@=q@\)@ҏ\@
@Ǯ@@\)@H@@\)@z@
@Q@ff@ff@H@{@
=A\@@@{@@G@@@{@@@@  @\)@z@{@@ff@@
=@
=@R@ff@
=@{B
=@Q@33@ff@@g
=@\@
@(@k@
@\)@@  @{@@@\)@  @~{@{@@@w
=@Tz@@@A=@G@k@z@Q@
=@z@=q@Q@@׮@@\)@Ӆ@Ӆ@ҏ\@p@׮@G@@  @H@
@@\@@{@@@  @H@Q@@
=@{@ȣ@ff@@@@=q@{@(@
=@
@ƸR@@\@ff@(@=q@ʏ\@@@pC\@R@@\)@@z@ƸR@@˅@ָR@
@@33@zARff@@@\@R@\)A
=@Q@
@@  @G@@@
C_)@(@ҏ\@p@Q@Q@{@@ָR@p@θR@z@{@33@|@R@{@G@˅@@z@
@@@@\)@Ӆ@33@Q@
=@{@  @(@  @=q@z@G@@@ȣ@@
@H@@G@@
@
=@(@G@
=@G@p@ȣ@=q@˅@ʏ\@@=q@ȣ@@p@Q@Ǯ@ƸR@
@  @ə@ff@z@33@ȣ@@z@@Å@  @Q@G@{@z@{Aff@Q@33@Q@Q@p@@\@=q@@@G@Ǯ@@{@@
@@H@p@@
=@p@@@@@@(@@33@Q@@ə@@=q@@=q@(@@(@=q@=q@p@R@@\)@@Q@@R@@@@z@p@R@G@@@Q@H@@@  @
@\)@{@Q@@ff@@{@@@p@z@@@@R@H@@
@@\)@jH@w@G@I@33@@R@{B8R@(@X@Q@ff@z@Ǯ@@E@@R@p@=q@
@
=Dw{@\)@@
=@p@
=@@=q@@H@@=q@\@@(@p@@ʏ\@p@@@=q@@ҏ\@@
A z@p@
@ƸR@
@@  @G@\@33@@@@\@@@p@@@@@A @@@p@\)@
=@\)@Q@@\)@\@  @@@@{@@\@p@{@H@@{@
=@O\)@@ff@33@@
@(D%@R@@@@@@33@R@33@
@ff@@@@(@33@
@@k@@p@ffD.f@R@p@@@{@H@(@@@33@\)@z@Q@@z@{@ۅ@(@@R@@@@  @G@@@p@  @@@\)@\@@@ff@Q@Q@@@{@33@
@z@  @H@@@@=q@@@\@RCn@(@@@=q@Q@@@R@R@@Q@\@
=@33@	@@@z@@@G@  @@@@ٙ@@\@G@@{@H@@@{@
=@
@
=@Q@=q@@R@=q@z@ᙚ@
@A33@\)@(@@(@@33@@@@  @ff@ff@@{@R@  @@  @  @G@=q@{@ff@H@@@ٙ@R@
@Ӆ@
@{@G@׮@
@H@@
@
@@
@@Ϯ@R@@{@߮@p@R@R@@ff@@{@ᙚ@@\@{@  @AARA
R@A@(A (@
=@A z@Q@AffAGA{A\A33A@AR@QA
=@@ff@pA{A @@(@Q@z@@
=@
@\@\)@@ffA @
=@p@
@  @  @@@\@@(@\)@@陚@
@G@  @\)@љ@陚A\AAg33A'33AUpAAffA@  @ҏ\@HAQ@\B@Q@Q@ڏ\@H@@z@A  @ᙚ@HA A@z@{A33AzA\)@Q@ff@
=@@@\)@{@@p@H@H@@@\@@@A{AJ{A  A#A
\A
\AHAzAVffAA/
@A
AA(A@A{A\)A\AA@{A!A{A	A
ffEc A{AzAKA
A\)AffAJHA@\)@A  @HAEpA;A<AHAA7A9pA
=A\)A(AQ@33@\)@33@  ARA*{AG
=A=qAAQAzA
ffA	AA(AAA
A@H@@\@R@@{B_@ۅ@@@(@H@z@@@ٙ@@@
@Q@G@R@=q@=q@  @@Q@G@
=@R@  @33@=q@@(@=q@ff@ᙚ@=q@=q@׮@ff@ff@@ҏ\@@\)@
=@\)@(@(@z@@z@(A	A33ARA
AAffA6=q@33@(A	GA$  AH@@p@@@@@@H@A (@A\@(A\)@  @A33A  A   @33@@\@H@R@=q@z@@
@A<AA
ff@@A
=@=q@QA	@Q@
@ʏ\@33@ff@{A  A
ffAff@陚@@  @
=@(@@G@
=@  @{@޸R@ᙚ@@(@߮@H@\@  @  @
@z@
@Q@G@=q@=q@@@\)@
=@zA\@Q@z@  @׮@@׮@@θR@(@  @@33@ff@@\)@33@Ǯ@ڏ\@
@@@@z@p@ȣ@˅@УAQA6ffA  @ff@p@p@@z@R@@ff@@@GAAA(@@33@УC)@  @Q@\)@
@(@@=q@z@@
=@
=@@=q@{@p@@  @ffAy@G@љ@H@@  @˅@\)@33@@G@@ff@@(@@p@@@ҏ\@Q@׮@׮@׮@(A@  @(@G@pA(AzAARAA
=q@  @ۅ@@H@@  @@33@Å@
@(Aff@Q@{@@љ@
@θR@=q@У@θR@Ϯ@Ϯ@{@θR@
=@Ϯ@θR@G@
@ҏ\@@
=@\)@׮@z@@{@@Q@z@
@\)@ٙ@
@أ@Q@
@QA
@@@(@@  @p@@(@@Ӆ@@
@@
=@˅@z@=q@\@@@ff@p@@@p@@@
=@\@ffA{Ap@Q@\AGA@ə@33@ʏ\@H@@{@ff@G@H@@
@z@@p@ҏ\@H@H@@@@ə@A(A@
=A-p@ڏ\@\@=q@H@
@@@
@A\)@z@@z@
@=q@@33@@@H@ȣ@\@@A{@@p@(@
=@@@  @\)@
=@@\)@\@ٙ@z@
@@H@H@=q@@@  @\)@G@@@@@(@@
=@z@z@p@Q@  @
=@@H@z@@@@@@=q@=q@33@p@
@@@
=@
=@p@@p@H@@@  D@  @p@@@=q@@\)@@@  @@@(@@H@H@Q@Q@\@@p@@Q@@(@@G@@Q@R@ff@p@ff@p@H@@{@G@=q@x@w
=@u@u@|(@
=@~R@(@@@
@@@G@R@  @U@g
=@w@Q@Q@=q@@\(@@@l(@@W
=@p@
=@H@}p@z=q@w@s
@@@Dz@>{@>R@9@8@6ff@2\@2\@,(@+@(Q@*=q@#
@!@(@=q@@]p@(Q@)@%@$z@   @%@%@!G@   @@@Q@@33@@@@=q@H@=q@   @=q@!@@ff@@
H@
H@	@
=q@\@X@E@Q@(@@
=q@
H@	@NR@q@@
@ff@أ@,@N{@(@\@@C
@{@@z=q@\)@   @@ff@
@ff@	@(@@@@B\@@H@@(@`@Q@G
=@\@z@@
=@@\@@\@@@@@@@	@@R@@	@(@
H@R@z@@@   @\@@@@?R@ @33@ff@Q@ff@
=@
=q@@
@
@@@
@@
=@
@33@
=q@
@\)@@
H@@@@{@33@
H@
H?ff@(@  @@@ff@@Q@R@@
H@Q@
@@@
p@@@z@{?ff@
=q@@@(@Ry @  ?Ǯ@{@@33?@
?@p@&ff@'
=@(@@  @{@@(@
=q@
=q@
p@@
=@@(@@Q@{@{@(@G@@33@Q@=q@H@@@(@@
=@Q@=q@Q@=q@@\@@@@@@H@Q@Q@Q@{@@=q@H@@33@g
=@^{@H@ZH@l@W
=@@@33@R@(@5@=q@
=@ZH@L@S33@Fff@U@S33@9@l(@@8@X@S
@_\)@@G
=@{C=@@xQ@`  @|@A@L(@@@@@  @E@)@@`@@(@p@ @R@!G@#
@\)@\)@!@!@ @p@{@\)@%@!@#
@ @{@$zy @!@\)@{@p@H@ff@H@\@
@z@33@NR@@Q@z@Dz@@@@ff@@@{@ @(Q@%@#
A#@.{@.R@1@5@N{@\(@\@5@+@-p@Dz@%@1G@,(@(@333@'@#
@.{@*H@)@'
=@&ff@3
@Q@   @!@.{@(@-p@0  @333@0  @Tz@1G@K@{@u@\@W
=@N{@  @@R@7@0  @1@*=q@'@+@R@#
@&ff@(Q@ @ @R@%@@@H@@{@'
=@'@ @,(@7
=@:H@0  @1@-p@/\)@/\)@%@   @%@"\@'
=@*H@#33@,@%@%@@(@@\)@#33@{@\)@   @@!G@"\@ ??\@"\@&ff@!@S33@DzB@L(@{@~{@k@0@[@\@ƸR@
@z@@@\@5@.R@=p@@@P  @8@AG@Q@\@@33@\@\)@@Q@G@H@}p@W
=@@  @8Q@'
=@)@'@$z@$z@/\)@1G@%@<@7
=@<@5@C33@3
@>R@@@:=q@:=q@7@9@4z@L(@JH@9@8@I@]p@XQA$z@0  @+@(Q@(@\@0  @)@,(@*H@0  @0  @+@0@3
@Q@333@2\A@2\@0  @2\@1G@7
=@4z@333@.R@/\)@.RA$A!@33@H@ȣA!pA)A#@ָR@@G@
@z@33AAzA\A33A  AA(AA\)AAAGA
A@ȣ@@
A{A\A\)@\)AzAGApA\A@A
\A  A\A{AQ@
AQA
H@\@@=qA(@HAAQ@A(A
{AzA	G@@{@@33@@
@AAAAzApBLA\AHA
pA(A
A{A
AA
A=qA\)A{AHAAffAAA(A  A
A
GA
AA
pA
AzA
A
A
A
GA
A
AzA\)A  ARA\@(AA
GA
ARA{A(@A
A
A@\A
GAAQA=qA{A
A\A
GA
AAHA
A
A{A  AffARAzA
=A=qA
A
pA\)AzAA
A
HAA\)A
=qA\A
GA
GA
=A
HA
\A\)AA  A  A(A  A\)A\)AA
HA
RA  AAARA\)@ڏ\AA
pA
pA
ARA
A
GAQA
pA(A
HA	A
RAA
=A\@AA:=qA
{A
RA
{A	A	pAA	A	A  AQA\)A=qA=qAzAB8AH@33B.A
RAARA\)@A33A
A
ffA
pAffA
GAARA	A
{A{A=qAAHARARA	A	p@
=AApAAffAAAA33ApABAA
{@A
{A	AA  A  A
=A
=A
A
=AAA33AA	A	pAzAzA	A\)A
HA	AA	pA	AAA
HA\AHAA\)A	A	A
ffA
RAA	A	A	GARARA\A\AAA(AzA\)A
AAA=qA33@\)AAAff@AAffA@\@
=A\AffAHA%pA{AzARA{A=qAAGAzAA
AA=qAA(AAzAAAAGAA{ARA=qApAffAffAAAGAA A A   A   A (@ff@{A QA@
=@R@A QA AGAAff@A33A@ffA\AHAHA33AApA{AAA
=@
AAHAA @\)A z@
=@A z@@R@@=q@@RA Q@
AA zA\A{@AA{@RA (Aff@ffA@AAHApARA\A33AAA QA\)AzA
A
=AAAzAGAGAQAHA(AA\AAA @
=AGAGAAAAA  AA=qA\AGAAA{AT(A A   @\)@\)A@
=A   A z@\)A AGA AAA Q@
@A A   @A   A Q@@@\)@\)A QA zAAG@  AAA zApAHAz@ff@
A (A QAA
=A
A\)AAA @@  Aff@@p@ARAAA  ApAAHA33A
AA33AffAA QA QA33A33@
=A @@
=@ffAffAAApA A{A=qARAA(A{AA\)AG@A Q@{@p@p@\)A A\AAAHA
=A\A(AHARA
=AApAAGA
AAGA zA A zApAQAA@(A ApA
A	A{AA
=@=qA=qAffAA
A  AR@
=AffA33AA=qAffA\AGA  AA=qA ApA (A@@{@33ApA zA (AH@\A=qA\)@A\A A   AffA\@
=AA @p@\A @{A=q@\)A   @@\)@
=@ffA Q@@@@=q@  @=q@(@z@@{A (A Ap@R@A A(AAQA=qApA
=A=qAHA@R@=qA	@(@A@ff@@{@H@\@@z@@HA @R@@@33@@z@@\)@\)@R@AAAAffA\)A @
@{@\)@\A (AA"RAP(A9A4AHQAffA.ffA4(AffAffAA4  A(zA5AAA\A  AHA-AAffA\)ARARA(zAA
=AA\)A
{A
\Ap@
=AffAA  A
=A   A A(@QApAzAQ@AHAR@\)@p@AAAA
A%A=qA33A  A(A
{AA
=A{A=qA\)A
RA
AAARAA@\A=q@A
A33A	p@@@(@G@@Q@=q@@H@R@R@@(C&=@  @\@ff@z@\@{@@Q@33@@=q@@@G@H@@\)@@Q@G@\)@(@@(A @@G@AG@@@@(@@Q@p@@
=@@ff@=q@Q@G@ҏ\@@ff@p@@@{@@ҏ\@أ@˅@{@@\)@B뙚@Ӆ@z@ۅ@33@@33@@
@33@\)@߮@Q@@@G@(@
@@
=@Ӆ@ۅ@У@=q@\)@\)@
=@{@Q@ǮC\@\)CZ=@Q@@@@{@\)@
@
@@@z@@  @ff@@@(@\@@@\@ff@
@@@33@ff@
@
=@@(@@  @@p@@@@\)@Q@  @\@@\@@Q@@G@R@H@@(@\@x@z=q@{@Q@tz@qG@u@vff@q@Q@@@@@\)@u@Y@zH@~{@qG@n{@mp@l(@jH@o\)@nR@h@c33@h@l@R\@r\@XQ@b\@xQ@w@S33@P  @^R@~R@S
@n{@w
=@!G@y@S
@zH@z=q@s33@s33@s
@zH@\)@33@Q@33@0@W@@zH@7@H@'@o\)@AGC  @e@Tz@p  @mp@jH@k@n{@nR@g
=@hQ@c33@Tz@mp@mp@k@l@*=q@@n{@n{@=p@e@nR@u@Q@zH@{@z=q@I@xQ@.{@vff@>R@zH@q@r\@h@hQ@j=q@l(@p@jH@k@g@(@dz@hQ@mp@i@e@s
@QG@\)@w@y@p@C
@o\)@|@y@{@xQ@jH@x@q@~{@q@u@w
=@x@p  @zH@|@@y@NR@,(@^R@{@j=q@o\)@y@?\)@\)@w@%@i@$z@0@5@q@4z@Z=q@`@q@s33@o\)@h@l@R@Z=q@j=q@p@33@tz@$z@l(@l(@Q@h@e@@p  @g@p@zH@%@o\)@7@p@n{@u@qG@qG@}p@\)@
@Q@|@1G@u@s
@z=q@w@w
=@{@u@x@u@u@qG@hQ@s
@q@<@y@u@s33@;@w@w
=@QG@w@vff@s
@@r\@n{@w@eD@Q@zH@y@G@H@H@pA[
@A	AffA	pAAAQAHAApA A@z@
=A @\)@@
=@{@z@{@\)@\)A QA C'5@ff@p@@  A@
@@33@
=@@@33@z@ff@p@
@\)A8Q@
@\)@
A  @@@H@
=ApA\A@@G@
=@H@33@ff@G@@
=@33@@p@@=q@@@33@\@@{@\)@(BF(@\)@@@@@ff@G@߮@G@@@H@
@@{@@@p@R@@@Q@Q@  @@@{@H@ff@\)@@{@p@ff@ff@@
C)@Q@@@{@H@@@@33@@z@@@p@ff@ff@@  @ff@R@
=@@@@  @z@@z@
@\@=q@@G@Q@
=@@R@
=@@@{@ff@  @@R@\)@  @p@
=@R@@  @\@
@@p@\)@@@
=@\@
=@
=@@@@\)@Q@R@@p@z@@@p@ff@R@@{@R@@{@@\)@
=@@\@@\)@@=q@R@@
=@Q@@
@R@G@@\)@Q@@Q@@\)@\@33@@@@@{@z@{@\)@  @p@R@
=@Q@@Q@θR@
@@@G@z@@(@G@p@{@@{@p@@(@@@@@@@G@ff@@@=q@G@@\)@R@ff@ff@\)A@  @@  @
=@ff@@@p@
=@@
=@  @  @QA
@@@@33@H@H@p@@ff@@@
@\)@p@R@p@\@@
@@z@@@\)@ffBD@{@@@(@33@(@@\D@Q@@(B@@z@@{@@p@ff@R@
=@@@p@
@@z@z@ff@p@z@(@p@@H@@\@{@@\@p@陚@@(@33@
@@@(@AUG@@G@R@A@H@33A?@ff@
@H@\)@z@Q@(@
=@  @R@{@A9p@
@{@ff@Q@@ff@@p@\)@
=@pB@@@@ff@@@(@陚@@@@
@@\)@z@@@@H@\@(@H@(@p@R@{@H@Q@
Ag\)@@Q@\)@@z@
@\)@@=q@{@@
=@@\)@@@R@(@@@(@(@\)@@@@
=@  @{@p@z@A=q@=q@
=@陚@@@@@@A\)@z@z@陚@@H@ff@@@\@
@
@
@H@\@H@=q@
@@Q@陚@
=@@@G@@@pA#@=q@@ٙ@׮@\)A(@G@33Br33@@{@{@ָR@
@Ǯ@
=@z@@ڏ\@ҏ\@33@љA
G@A@A-p@=q@
@ȣ@@@  @ff@D.ɚ@
=@B
=@@\@\@@Q@Q@G@@@QA{@@@Bb{@x@=q@@33A
A
\@љ@@@p@\@B)@G@=q@{@=q@R@@z@p@=q@@@@Q@@@p@p@@  @z@33@{@@@(@\@@Q@~{@@}p@@@Q@  @~R@|@Q@z=q@c33@^R@u@g@g
=@fff@e@fff@_\)@Mp@]p@ZH@tz@h@`@b\@^{@dz@_\)@]p@^{@NR@ZH@]p@W
=@W@P@XQ@U@XQ@N{@@Q@P  AAC%@Tz@<@[@=p@:HCx&f@HQ@W
=@ZH@X@X@P@QG@Q@Q@P  @O\)@Mp@Mp@P@Q@P@Tz@Q@Q@NR@P  @N{@Mp@NR@b\@
=@|@c
@c
@g
=@`@^{@h@ZH@\@]p@X@Q@P@JH@K@Q@Q@XQ@Fff@HQ@A@A@:H@@  @G@/\)@@E@JH@W
=@7
=@3
Al@<@<(@=p@=p@=p@7
=@   @>R@B\@N{@P@P  @,(@:H@W@`@`@Q@[@UA
@E@\@N{@NR@I@J=q@H@<@;@@  @Dz@>R@8Q@@  @;@C33@<(@NRB
@ᙚ@@Q@H@p@ff@@=q@
=@@z@(@{@@أ@@θR@ff@=q@H@
@ə@p@  @Q@(@ə@ff@ff@33@Q@{@{@
=@@p@33@ff@z@z@z@=q@@ff@ə@ȣ@ə@@@(A#
=@@@θR@\)@@@G@ȣ@tz@H@G@@G@@ڏ\@G@33@أ@˅@@n{@
@{@
=@33@G@\)@
@Ӆ@@(@љ@@@\@@ff@ᙚ@@Ӆ@ff@˅@@\)@Q@{@@Q@Q@=q@@@θRA@\@@z@@z@=q@@(@
@Q@
=A QAH@Q@
=@A @(AffA=qA AGA(@p@=q@33@{@(@ٙ@G@
@θR@أ@@@=q@(@@ff@@@z@\@@@=q@@@@߮@@@@p@
=@  @z@޸R@z@@G@ٙ@
@@
@@@@ff@H@@ff@(@\)@=q@@p@H@@ff@{@@(@@@@p@z@  @@@@@@@\@G@\)@@@@@|@H@mp@`@g@nR@k@w
=@u@u@e@h@jH@z=q@r\@qG@xQ@nR@u@u@mp@o\)@g@vff?(?33????\?z??H?\?H@\(@`@u@`  @s
@jH@z=q@y@H@ff@R@@{@\)@
=@HARAApA
A=qA,  ARRA\QAW
=A\Ax(A33A@@{@@
@
@@=q@@R@p@@@w
=@}p@{@33@{@@@@p@{@Q@G@(@@ȣ@\)@{@@@@θR@z@z@@33@~{@C
@8Q@L@qG@@r\@@p@l@nR@\(@W
=@?\)@Dz@5@%@(@1@!@ff@@  ?˅?Q?@@]p@p@@H@=q@c33@{@l@l@g@b\@G@Q@XQ@@{@˅@A   @A(A*{A<AWAUA\zAf=qAr{AAg\)A?A\)AA
=AK
A]A<  ASApAA (@@@G@@Ǯ@z@H@@H@@{@33@H@e@@ff@\)AAz@ff@  @  @@
=AffA@@G@
=@@=q@{@A@@ff@
=@@G@@@@z@Q@@  @\@L@0@@O\)@1G@h@\)@u@33@Q@\)@W@θR@\)@  @ff@G@R@
@G@pA
@\@=qA=qA;
=AG33A@A*=qA3\)Ac
AiAdQAk\)A\A\)AAA=qA(A
A\AqA>=qA33AR{A8zA zA;\)A(@AGA8QAv\Ad  AS33A4(A&{A{A  A
HA@ᙚA zA	A@@@@GAA%p@
=Ap@zA\)@ə@{@Å@\@θR@RA=qAzAA4(A@\@ff@  A\)A*\@@{@H@\@@љ@@Ϯ@@z@@R@@H@@p@@@Q@R@z@@
=@
=@陚@AAA  A\)A(  A8  AEA`(AmA\)A{33AA  AARA\)AA
A33AA\)AFHApA
A
A|An\AA5@ffA&ffARRA%GA(A(A\)A@@ڏ\@R@@@p@
@33@@(@]p@=q@@@AQ@  AXAB=qAAH@@\@Q@
=@ȣ@G@@|(@XQ@p@l@L@9@XQ@6ff@HQ@8@3
@9@A@@jH@(@vff@@Tz@R\@8Q@Y@`  @~R@~R@@\@=qA\)A
@HA
=A  @HAA3
=A/A#33A*HA:HA<A)pA*=qAB=qARAtzAw\)AqA
AJ\AA{A\)AOALzADAFHAHAAA(@\)@33@z@@H@@=q@Q@@G@@@@
@G@@~R@p@zH@@{@@p@\@{@zH@z=q@z=q@{@G@p  @^{@p@>R@@@@(@@qG@vff@p@\)@=q@HA(@p@@H@xQ@@@(@ff@:=q@=q@
=@  @@i@\)@@ff@ff@G@H@H@{@\@@@{A'33AqAA(AiA|(A\A
A\AoA(AA\)Aw
AAA<(A0AApAKA33A6\A\)@R@QA;@@tz@p@=q@(@  @c
@s33@Q@@@z@@@{Aff@A(A=qAR@
=@\@G@׮@@@@@\@  @=q@@ff@@\@z@@\@\)@nR@`  @
@\)@]p@\@@p  @\@c
@s
@ff@@@R@=q@A
A
AA  AA"HA.HAA.{A>ffA<AgAepAmAyAtAuAA{AA\zAhA\AAn=qAuA2R@  @@@{@@@G@ff@@@H@\@=q@=q@GA
A
pA33A
A=qAApA0AT  AYpA%pA A=qAffA9A<  A3
A+
A#\)A
=AAH@@A
R@=q@Q@@@Q@
=@=q@XQ@}p@q@p@ff@\)@33@p@(@@\)@
=@Fff@@Mp@@Ӆ@ҏ\@  @\)@Q@ff@33@@@@@\)@H@
=@33@\@AAA(A5A7A:ffA8ALA QAS
AUGAg
=A9AV\ASAC
APzAS33AK
A-pA@zA=qA  AA\)@G@  @{@ff@{@ff@q@l@~{@}p@(@(@1G?
=@1?G?H@Tz@=p@*=q@ff@@@X@{@U@%@:H@g@~{@hQ@@33@@q@s33@_\)@U@!G@Q?H@.R@B\@H@Tz@'@Vff@7
=@ff@#
@-p@!G@>{?:H@=p@Dz@<(@6ff@E@j=q@#
@vff@:=q@G
=@3
@=p@ƸR@@@ƸR@A@\A@  @
@@@zA
AzAAzAAffApAAA	AA A@
@=q@@33@@\)@{@
@H@@ff@@@@
@ff@θR@
=@p@{@R@{@ff@r\@
@(@@H@  @|@@}p@Z=q@[@XQ@HQ@-p@ @(@\@
=@
@(@   @0  @8@	@
p?ff@(@8@0@(Q@`@i@\@R\@'@7
=@R@1@@#33@=q@W
=@>{@Fff@XQ@z=q@
@xQ@q@z@@{@p  @~R@\)@@
@@{@R@  @@@Ӆ@@\@
=@Q@\)@G@\)@\)@@@@
=@@zH@X@H@A@*H@'@>{@ @   @%@{@\@&ff@=q@#33@J=q@'
=@'
=@5@4z@=p@,@Q@G
=@9@E@<@B\@+@*=q@)@@@7
=@=q@-p@(@
H????޸R?Q@\?(?@G@G@?(?Q?@33@6ff@a@y@|@tz@=q@
@
@z@@ff@{@33@Å@\@=q@{@ff@@@33@@vff@~{@^{@ff@b\@qG@Q@L(@:H@{@W
=@.R@>{@&ff@#
@'@a@;@E@X@C
@ZH@@@Fff@5@G@b\@P@H@l@NR@W
=@>{@:=q@S33@;@.{@%@!@@p@R@'
=@!@'
=@p@'@\)@ff@
=q?z?{@	?H@???H?У?33?˅?{?  ?z?Q?s33??fff?{?G?
=?\??s33??H?33?G??ffy @ ?@\)@\@8@Wy @H@=q@\)@@G@
@@Q@e@c
@S
@nR@Q@|@w
=@g
=@+@k@aG@N{@Y@C
@<@333@)@*=q@+@%@333@@{@.{@@@@'
=@7
=@@H@@@Q@33@@@@R@@(@@
=@NR@7
=@
@@@?(??H?  ?
=?˅??=q?@@%@@-p@=q@1@.R@*=q@)?=q?33?H@@(?z?{@{?Q@\@*=q@%@ff@.{@)@
H@=p@e@@@P@@(@(@{@p@(@@@Q@{@@@\)@Q@@@Q@@@@
@@zH@'@&ff@4z@3
@ @2\@C
@@@I@8Q@5@   @p@!G@'
=@#
@/\)@8Q@@)@(Q@/\)@&ff@.R@4z@4z@K@@  @J=q@8Q@@  @e@mp@K@N{@W
=@S
@L@R\@E@8@&ff@>{@+@@
=??{??
?\???G?p??{?xQ?p?=q?=q??
?G?ff?H@G@$z@<(@0  @/\)@Fff@@<@:=q@E@U@E@jH@n{@s
@@@R@{@\)@H@G@\)@@ff@@  @@p@{@=q@\@H@H@@@(@=q@R@G@=q@p@@@^R@e@\@@
=@(@\)@R@@z@n{@fff@W
=@I@G@Q@K@P@J=q@2\@.{@<@%@1G@,(@>{@8@-p@H@?
=??Ǯ?R?=q?Q?@z???p?
?p??ٙ?z?p?@   @@H@7@?\)@e@dz@p  @QG@Q@@G@p@G@@θR@
@@@@  @R@
=@z@Q@\)@
@(@R@Q@\@H@g
=@B\@S33@B\@
=@5@[@~{@c33@
=@
=@s33@^{@@@@(@=q@U@xQ@K@S33@E@E@+@7
=@o\)@jH@:H@<@C
@U@X@q@Tz@XQ@ZH@p  @h@(@33?33???u?n{?
?c
?}p?Q?
?xQ?ff?J=q?^R?B\?:H?G???\)?H@G??{@@)@Dz@C33@=p@Mp@\)@
@Q@=q@  @G@=q@ff@A{@  @R@{@@p@  A  @{@
=@  @33@@=q@U@@  @,@=q@!G@0  @.R@&ff@)@aG@33@ff@(@p@}p@!@4z@33@p@p@%@'@@!G@@
p@Q@@33@@8Q@2\@E@@%@/\)@{@H@<(@E@>{@:=q@,(@2\@8Q@0@#
@7
=@Dz@H@<(@?=q@
@@?33@(Q@ ?У?(??\?
=?H@Q@;@  @+@"\@Y@^R@  @!@@=q@G@Ӆ@\)A A$A5A?33A9GA/AA&RAA  @
=AAH@  @p@z@p@R@Q@@H@@{@
=@  @(@\@mp@_\)@xQ@33@XQ@NR@3
@8Q@+@ff@
H@@(@%@.{@JH@\(@(@:=q@,@HQ@:H@S33@ff@@33@fff@c
@W
=@JH@3
@]p@@z@$z?=q??33?33?  ??  ???Y?^R?+?W
=??}p?Q?8Q?Q?#
?n{?  ??\@>{@=q@@z=q@
@33@H@ʏ\@
@@ʏ\@HA\)AffA=qA#33AHA (A1pAAAAzAG@{@@ə@z@ff@  @Q@H@˅@(@@Q@R@e@e@@U@0  @Z=q@4z@tz@H@B\@33@@k@x@H@\)@G@@=q@@@@R@@^R@p@@@(@{@Q@0@ff@X@W
=@(?@p@%@$z@jH@:H@g@l@
@@(@p@G@  @H@(@@@A?ff?\)@C33@\)@Ǯ@  @33@H@(A@33@  @=q@\@@  @陚@(@z@G@  @33@ff@z@@  @
=@=q@@@{@(@33@R@\)@˅@p@
=@(@ff@p@\)@ҏ\@θR@{@ƸR@@
=@\)@G@@G@\)@@z@H@Ǯ@33@  @ʏ\@z@\@@@=q@\)@@z@@
@@@@@@\)@|@s33@w
=@@33@ff@Vff@R@@@@  @@{@G@=q@
@@\)@p@R@=q@ҏ\A @@z@\)A#\)A	A+AR=qApA_
=AxA33A*RA#33A"\AJ\AG\)A\AAx(AZRAlA`(AEpABffA1AA@33@H@\)@Ap@A\)AGA @@(A=qARA	@@  A z@z@Q@@@\A@@p@ȣ@@@@@33@Q@\@Q@@@{@=q@@G@R@{@G@p@(@~{@@O\)@NR@
=@33@z@z@@ff@\)@@أ@ff@=q@
=@Q@G@@(@ff@H@=q@^{@@u@@ffA8A:=qA333A2=q@@G@o\)@nR@(@(@
=A
AXQA733A!@
=A
\@33@\)@=q@i@s33@@y@@{@@  @{@ff@Q@@
@\@ۅ@ə@p@@@ȣAG@陚@=q@љ@H@w@\(@a@@G@xQ@R@\@@\)@@@z@@xQ@~{@k@o\)@l(@nR@l(@q@e@fff@g
=@hQ@  @ff@\)@@@ff@G@@
=@(@@@G@ff@
@
@ff@(@z@\)@@@\@`  @p@`@`@=q@@p@G
=@I@B\@Mp@B\@qG@j=q@J=q@Vff@G
=@JH@mp@@@s33@@S
@=q@@e@mp@@u@Vff@@G@^R@L@H@@@c33@p@Z=q@  @p@Y@(@7@.R@{@Q@'
=@I@{A@R@@ffA+\)@(@^R@W@7
=@(Q@'@ff@AG@>R@^{@@<@Tz@/\)@2\@?@
p@
p??H?=q?{??\?@R@%@3
@|@c
@J=q@W
=@G@@;@QG@(@k@H@@|(@q@q@@@QG@Fff@z@W
=@p@33@z@
=@y@@{@ @G@z@@{@<(@N{@1@ff@@g@@_\)@H@R@@@@vff@H@ff@G@ff@G@@R@33@Tz@{@33@|@@H@\@zH@@z@z@@@  @U@HQ@/\)@'
=@<(@!@.R@1@)@=q@
H@
=q@G?@
H?H@?
=??H@   @)@@+@=q@#33@33@
=@Q@R@#
@*=q@C33@3
@9@aG@|@z@G@@@ff@θR@zARAV=qARHA A\)AA\AQ@ٙ@\@{@@\)@@33A@  @|@H@  @p@\)@޸RA\)AA z@陚@A
\AH@  @ᙚ@z@@@@{@@@@z@@@@ff@33@H@
@  @H@  @\)@߮A
{@33@@\)@ff@  @
@
@{@  @@AG@,@_\)@=q@@@
@H@H@
@Ǯ@\)@p@@33@G@p@
=A{@@ʏ\A@p@(AAHAA%AAAGAzAA
{A
R@G@A  A z@QAHA@GA
=A%ARAuA+
=A4(A(AIA\)@
=@@@@@A @G@љ@ff@θR@\@
=@(@\)@@@  @\@{@@G@{@  @@@@ff@@@p@H@@@{@p@
=@z@@{@H@@jH@@s33@J=q@
@ff@Tz@L@@?H@?޸R??\)@?z?ff?\)@Q@@(@ff???R?
=?޸R?@
H@=p@"\@)@!G@  @=q@@B\@7@'@@@I@NR@Y@N{@<@:H@A@333@E@*H@7
=@1G@<@Mp@G
=@>R@QG@=p@?\)@.{@/\)@@G@&ff@S33@/\)@'
=@.{@-p@\)@@.{@,@*=q@   @@@	@{@\@ ?p?33@ ?z???p?{?z?H????
?=q???fff??p?H?ٙ??ٙ?{??޸R??=q?Q?33@G@ @*=q@@JH@,(@@@^R@P  @0  @9@s
@tz@@33@Ϯ@@ᙚA"ff@G@Q@i@]p@@q@@
=@
=@G@ff@
=@@ϮAz@@_\)@@@~{@(A@Q@=q@@\@33@@ff@R@@aG@@\)@@Å@@{@@(A@@H@@@\)A zA@ARA@AA
\@ᙚ@ffA\@׮A4AAffA@@p@pAQ@{@ȣ@׮@H@Q@{AJ{AyALAA9@
=AqA\)@ڏ\AAAzAzA=qBB \)B=(BHBQBkBP33BBBBB\\)B\BvBBBBiBB{BBoBUGABzAAHAԣBB
\)B	AA  A  ApA33A  A
AzA{ABpB
A(AљAǮAApAB=qA  A
A홚A  ABB+{AzAA33A=qAffB\AʣA=qB   BQBj\B{BqzB%{BFQBlzB${BvffB*33B5
=BHB`
=BZpBazBBzBGABBTffB
=BBǣBǅBBBnffBB=B
BffBB=CaHC*\CD3CfhCjCcRCACCpCRCCHCEqC,ٚC#s3C$cCB{C}qBBkB(C 
BB=qBRBBǮBHBBBHBkB\BfGB\BHByRBkBBW
BqBLBBffB=B
=BA  B}B=qBW
BB
=BpB\BBjB̸RBqB
=BRBBeGBB{BGBBQzBqB(BGB)BGB B=qBkBffC@ BBبBB{BffB\)BfCGB˨B.BBBB3BQB#CpBW
Bˀ BC8RCaHBpBHB\BBfBBfBfBQB.BB  BHBffBByHB)BBBB(BBzBBpBǮByBB=qB\BBBBHB33B
=BLBB=BvBBW
B8RBGB\BBBBCBBBaHBBpB3B{B\B=qBBBW
BRB3BBB[BB(BǮBBRBBLB\BpBBBBBBBB.B
=BPBǮB
=BuBBaHB8RBu33C:BzB#CfCB33C
=Cx3C޸CMC
fCwnCYfBޞBpCW
B\)BؙBBQBLBGBƨB=qB
B8RBpBBBBB{RBqBBTBLBBBBGBBǮBB8RBzBo(B=BkB˞BvRBB{B=qBfBffBӀ B{BB\)B  BqCC{CRB)BGB=B33B{BaHBB)BBk
=BBBBRBBwB(BǮBC#ǮBBBЙBBB\BB(BqB
B
=BBB{B
C!nCRCCRCXT{CjCNǮC6:BGC'&fCPqCuC	C*B.BC}qBBuBBC}qBuCB܏\B)B\)BB=qB33BǮB33BBǮBLBBC0BBRCBQB
=BfB.BBB)BBC+BhBBBqB\)BpBB{Br
BLBBC:BvBkBBzBW
BBzB  B
=BؽqB BƅB\BHBffBB{BBuBkBB\B
BuB\BB8RB\)C!HBB
B=qBḄBB˽qC	B
B(C
C!HB܊=B  BpB33C
C+B=B  BǮB  B
Bz  BǮB=qBCaHBkBspBB#B=BBLByBqBB\)BW
BB)B\)B BzB\BB3BqABLBBBaHBB{BHBBBB)B\Bm(BBBBB
=B{B
BffBW
B#BBxQB\)BBB#B=qB
Bb(BPBt33BY\Bg  BpBg(BZ\B\BqBGC@ BGBB{Bt
=BB=qB\BuB)B{BqBQBٙBƞBBW
BGBW
BuB{B\)BBkB#BLB  BBBm  BXffB!QBX33BLQB{BTffBD
=BBB&\)BzB\BszBs\BB  BaB`  BgBn
B>B0  BDRBgB}\)BIB:  BHARBffBA{B  Bi\)BGBp
BRBP(BS\BNGB B[B33B^  BZBdBdRB<BsBYBJ\)B\)BLzABL33B8ffBB7\AGB&
=B:(B>BvpBMffBhB6B-Bl  BkBm
=B~=qB33BkBzBA
Bn(BBTRBPBRB3B8RB.B=Bt{BBBpBpBB3BB
BHBBLBBmGBuBBQBBB_HBs33BmpA33BBBsBK\)BGHB`(B$ffB6=qBI
BYBopB+B`B(BF(BTQBIBDQB,\)BBE33B^B}BcBlHBNBlBBn
B8GB_zB,RB'BHB+  BffB:GB2\)B/B @ffA AGA)A(@
=ATA33AvHAz@RA
=A(AqA(AGABRA3\)AA33A\B\AW
=ARAffAAABffAGAأBA{B@B:B  B\BG{BABEQB#zAffAAA׮A33BA(A{A{AApA=qBAff@@QA:=qAl(AHA1A@
=AP  ATAJffA!A7\)A:{AR=qAA@pAA#
AA33@(Ah(AHAA
ffATA=qAXAXAzAVffAApA
AdzADzARAV=qATzArff@\)Az\@QA(BGA{AAffAffA=qA2\AA-AAS\)AzAA=qA.\A6=qAoAffAAQAA(B33BzAffBpA(AAAnRA}AaAGAA=qAffA"HAtzAAv=qAtAC
=A{AAaAFHA
AV{A\zA@zA
=AH(@33A{@A@ÅAbff@A  A&RA:RA
A@θRA\)@أ@@əAAS\)AA=qARAA*\AAYAK
A`QA?AffAIAQpARffA4zAP(@ffA{A
AAA:=qA4A33AAL  @{@A
AA@A\)A\AzA+A  A33AA=qA33A|AAA8ApB-\AsBDBA̸RA
A33A£AA{B  AۙAA
BGAHAffB^AGAӅAA9GA-A{A?33AA,A (A,(A>=qA7\)AKA:R@{@\A
@QA5A  AEAA
=A9pA@A1A  AzAAݙAKAAAAA=qAffA'AffAfRALApAAiAA
@AQ@\)@A
=@@ϮAbffA0  A$(Aff@zA'
@A
R@A=qA[
A\)A,AA>{Al(AAA`zAR=qAUGA
AABAHAAGB ARBA=qAApA\)ARAB=qA33AGB"ffA(Aޏ\AHBF33AHAQA=qAÙAׅA
=A(A`QAHAAeA=qARA|zAAoAΏ\AAAzAlQA^ffA>HAAHA>ffA)A-A"=qAjHAYAHAg\)A  A$AnHAGA)GAApAAA/
A  AAYAEAAffA+33A9A[
An=qAHASATzAS
=A~RAA?AAAAGAA
=AQAGA(AyGA|AffAoAuGAAA{AGAAA{
=AeA?\)AQArffA{
=AXAS33A,AAA>\AuA?
=A~=qA33A,(A3\)AA7A0  A,(A
GAGAQA^{A=qALAUAHAG33AK33A733AG33ARHA@AdAmAA33AA(B%\AzA|AGA˅An{A33AA33AtQAA{Ad(A
A\)AAAd(Af=qAj=qAAK33A@QAAHAZff@AbRA733A0zA\)A*=qA*RA1ARA)A]pA1pAw
A{AQAvRAw
AAA1Ac\)AfffAGAAAApzAAYA(A  AA\)AߙB
AB  A
=BAA
BffB pBffAAˮBBpBAB
=AQAApARA
AQA  AAwA8zApA(ApQA.ffAhAxA4  A^\AHAj=qA8QA  A8QAc33AA3A!AFRA1AAffAr\A_
=AA;33A@\A$  A  AA  A	pA>=qAzA  A\)A,zA3A6HA_
=AACAl  AzAW
=A\AARA{AffA{A\A
=AffA
A=qAA{A
ApAB$HAffBzBAzBIB
B'B  A(BHBffAAՙBAA  AיAGA\)AAQAARAh  AAAA=qA\)A{AAAGAAA  AB
=A=qAzAA33A  AA{33A\AQAA~\A(zA+
AcA>\AL(AhQAW
A\)AK\)ABffA=qAJ{A@A8AA
{AzA\A	A@A*{A4zAA.{Aj\AC\)A\AUAz{A
=AˮApAAԣAApA
AXAA^ffAzA_\)AQAffA
=AAAuAffAp(A\A_AOApAffA{B\ARA`  A(AAA
=AW
=ApA
=AA5GA=qA#
A%GAcAIA#
AAA;ANHA33A-AvHA-A+A\)ApA(z@ffAPA
@ff@QAA@@
=@33A
HA
@A-GAARANHAW33@zA\A8  AA@QARAffA$AH(AaAU@AdQCA=@GA'AHA
=AA@ffAFRAF=qA=qAZRA\QAUA1ApA/
=A^{A2ffAffATAA7AAA;
=ARARAA]AQAn{AMAAA(B)A  AA33AQA\)ApA\)AQAARA(A{A=qAQA{A
=AA\)As
AA3ATAiGAfffAffAAj=qAXAtQAO\)A4  AfRAhAiAPzAA;\)A8AA1ATzAFffA @A @HA  AA'
=A9p@AC
=@AGA{A   @AR@RA@
=A&=qA'
A(zAYAK33AV\A@(AfRAzARA`  Aw
=Ag
A|AQAs
=AqpAAzApA\)AzAGA{AA33A=qAHA\A
=AŮAARAHAAA  AsAA@  AHA{AGAUA2{AAARRALzAzHA6=qA;A@Ad(AFffAAx  A;A
Av=qAtAJRA0QA9Aj\A  A@QA(AYA&RATArHAfHAc\)A_33AzADzAFffA,QA4  A:RApAGA333A0(AFHA\A.{A
@  @p@ff@pARA
=AffACA\)A<  A)@ffAffA   A	A2{ADA+AmARAHARHAffAЏ\AzAGA{B"GAA  A33AAzA(A  B>ffA~RB(AN\AAA8A-AAAqAA4A{AEGA3
AQGA"=qA5G@A+ARA  @GA=qAA#
AA$(A\A  ARAQAA5pAAHAAzA&\AEA\)AA0Q@(A+A
=@Å@\)A@33A{@H@33A@\)@A
=A@ffA(@@  @{AA@(A\)y AuAC33A?
AXzAzA^RAB\A?\)AjRA`zA  ALA=qA^=qA~{AK
=AyAAp  AupAD(AAt  A$(AW\)A>HAly A
=A{A\A
=AAp(AAA\A[AAQpAuAXAd(A£A\)AUpAXAQA\AxQA{AGA!AAAA0(A$  AtzAHAHA
=A;\)A~{Al  A!AB\Ah@A2{AIpAH(AffAGARAQA_33AQA
H@ARA@(AV{A&RAA33A
pA;\)AA(AA
=@A6HA@AK\)A4A|AypAAGAGA5pAWAF{AQAW
=AAAc33A33AAvHAHAHAQA
A
A=qA{AffApA  AtQAQA
=AJ\ABB{ARAA{33AffAA33ARAA\)B=qA{AzAAzA=qAHA33A(AQA=qAffA{AHA{A33A
=A{A
AaAqA
AffA=qA
A\)AypA\ARAHA[
=AqpAW
AipA`ATA(A)pAAZ{Az{ARA
=A=qA\)ApAHApA(AᙚAABHAApA=qAA
B\)ABS33BDffBm33BeQBBSB|zB\BSRAAAGAA噚AffA\)BQABHA@(A\A%pA=qARAA$(A"\A6HAffAB=qAAA7A[\)AQAc
@G@\)AaAB\A)pA33A>ff@@  ARAO\)AzA$A(zAA(AuAA\A8  Af\A+\)AAD  A8zA0A<AsA|AAAg
=A@A9AAN=qAAApAAffAA"\AjHAy@A QA\)A\)A"R@A
=AAxzAh  AsAGA
=A
=AffA홚BB3A(A  B HB 
=AQA33AHA=qAzB\AУABGAAGA\)AA{A
=A33AGAHAA*RAAASA(AW
=A*\As\)AGA&\A%GA=G@A<QAUAO
=A\)A[33A^\AQAAAxQA\A33AHA
A\A|  AHAtAypA}A=qAA
=A7
=A\)A[
A{AQA
ff@ffA(A@@(A A	p@  @@ə@AQA$zA\)A6\AXA33Al  AzAzA\BRAB$pAOAڣAA
AHARApB9
=AQA
=BQAЏ\BBzBU=qB{HB33ApAAAӮB=qAQAy AAHA
=A(AA$QAApA5A5@p@  @G@{A
=@Q@{@Q@A(A
=qA@ff@p@{@޸RAA{A$  AzA#A QAHA{AOA\A?
=A-AA-GAA zA33ANRAUAGAGA<AAoA\)Ak
=AffA\A@@  A
=AN\A@AwAR=qAuGA  ATA_33AffA33Al(AHAGBA  AB%  ApA
AA33B#=qA33AA  ApARA
B	QA(AҸRAAA홚AQA=qAЏ\BA\AAHA33A=qAQAR=qAA@QAffA(A33AEGAIA
=AiA\)A
=Aw
=A(Ax(AHAApA
AB AA=qA{BAYARA{A`zA AA
A@p@\)@{A#\)AFff@GA
\@
@@R@Q@HA)@  @ff@Q@Q@z@p@ff@@\)A
@GAA(AHAffA33A\)A
A>{AeAAp(A}AARA
=A=qAQApABAᙚAzAffAУA  AHApAA(AARA=qAzA  AzA_
As
A]AupASA(A9A\)ARAHA4(AJHAA$AAA!GA7
A\)AG33AffAw
=A\A$QAmpAYA
=AQA!A"\A
=@R@θRAG@G@A2=q@33AM@{@\)AA@33@@Q@ȣ@@G@AA
ffA33A}GAffAHAsA8A)AKA,QA?\)ADAP(ANRAfHAiA
A\ARA}A\)AQA
=A{AA£BB zA  A\AffBGB	
=A  A\AA  A
=AAHA(A\)AAA{AffA\ApAzA
=AAA{\)AzAxQAF{AN=qA
=AA
A|  A  AA=qAA(AAAffAQA{AHA
A|AGA?AC33AAw
A#33A@pAA&RA
A/A6ffAyA
ARAAAӅAA)A\A\)AAA\A|QA
=AAGA
=ASA
A\zAAD(A=qAA&{AAr\AzAA\AAA  A
A  AA{A=qABRB
ffAB9BffBAApAHAB	AffAAB+AA33AzAffAAzA33AffAAg33AffAHApAffA1pA\AxA6HA|zAfffA[
=AZ=qA7
AtAO
=A<  A;
AEA<  A>{A\QA"\A[A'A33A6=qA*=qA-A(QAmpA33AF\A)G@
=AR{@@<(@G
=@p  @@R\@;@8@z@Fff@<(@W?Q@z@ff@@ӅA&HA<@GA-AABHAzAw
A=AAV{AW\)AdA33AAzA
=AHAzAiGAGAtA=qAP(A=qB1AB\AA\)AA33AApAAGAAgAW
A-A
HA(A\A33AA\)A!@H@\)A`zAQGA1A
AL(A  A2HAHA(QAZ{@{A\@pA
GAffAz@(@A@@\)@@b\@=q@Vff@>{@1@"\@*=q@
p@\)@"\?Ǯ@@1G?p@\@33@@-p@'
=@?\)@qG@X@j=q@\)@\)@@ڏ\AB=q@`@u@^{@?\)@=pA@ff@`Az@{@@G@  @@  @H@a@s
@j=q@u@hQ@{@=q@@c33@G@tz@k@g@P@@@@  @Y@U@Mp@NR@E@e@qG@P@c33@@j=q@mp@y@@GA(@z@ff@@{@\)@\y A  @A@R@  @R@A
ffATQ@ff@A$Q@@^{@@|@6ff@R\@fff@\@Tz@0  @p@\@Vff@Dz@<@Dz@G?H?
@hQ@*H?(?p@#
@
=@A
H@p@@R@33@@~{@{@=qA
@@(@{@H@{@@  @zA$@HAC33A	A<A.=qA?A(A.ff@ӅA@˅@@(@
=@\)@@  @GA@U@@G@~{@\)@{@|(@z=q@u@g
=@?\)@`  @nR@aG@;@W
=@(@;@ZH@N{@;@e@>R@#
@|@h@(@ZH@^{@\@U@L@P@R\@333@hQ@33@_\)@L@l(@tz@9@@@u@@  @b\@z@@~{@@@H@R@ff@G@Q@p@{@\@_\)@  @|@z@
@H@z@=q@RA\@(@@
@pAAR\@@@AQA
=qA<z@ff@@  @Q@
AA*=qA@33@{@XQ@n{AG@p  @Tz@W@\(@|(@^R@l(@N{@Dz@x@@e@H@@p@=q@tz@Y@G@l(@\@{@|@GA2ff@
=@7
=@H@ff@I@(??p?@ff@:=q@5@,(@G@@@!@#33@@'@*H@^{@A@7
=@j=q@s33@hQ@X@G@\@A@\@@\@E@ff@N{@@  @Z=q@`  @W@7
=@7
=@k@`@fff@e@x@Af=qAA@Q@TzA
@  A@G@w@p@@HAAA@33@@p@8Q@ə@p@\)@G@Ӆ@@pA@  @A!@G@G@Ӆ@33@޸R@@@\@HAp@I@dz@I@N{@=q@p@L@p@`  @@{@{@AG@@3
@w
=@~R@@g
=@o\)@5@@qy @@i@r\@&ff@Tz@c
@u@w
=@u@s
@@@љ@
=An=qA-@\)A\AHA
AJ{A0QAFRA;
AX  A4zy AGAQAمApAGA
AAzAA$  A
RA\)@ff@@=q@zA   Ap@
@\@HAA*H@33@H@  @H@ٙ@\)@I@L(@{@l@A@\(@l(@xQ@@G@@ʏ\@z@@G
=@z@ff@z@Q@\)@H@@e@zH@zH@,(@
=@
H@A@H@0@J=q@=q@\(@Y@e@h@\)@n{@{@P  @[@@@@Dz@>{@Z=q@@
=@33@c33@=q@p@R@@H@33@\)A+
@
@H@@:H@@=q@@@R@S
@1G@0@1@.{@%@#33@&ff@^R@g
=@JH@r\@  @{AuA@@@{AD(AQAHA@
@
=@@c
@vff@e@HA@R@(@k@0  @!G@G@$z@@*=q@<@6ff@'@:=q@/\)@(@'@g
=@@  @9@L@S33@mp@h@r\@g
=@;@:=q@1G@(@2\@ff?z@
=@
=q@   @,@,(@J=q@@u@#33@R@@  A\A*\AO
A:ffApAAA33An\A33AAAzA=qAAApAzAAAQAffAA  A\AAƣy AA+@\)@
=@
AH@  A9@@R@HAA{@@B AAA(ARAAGA{@  A@G@HAmAI@(@A   @ۅA<AQ@Q@A^\@@{@A33@@*=q@r\@<(@\?@p@K@\@  @@w
=@Mp@@z=q@A{@p@(@љAA  AnRAeA/
=AZHA0(AzA]pA>\A@zAQAW
A33AAAK33AA7\)AA!pA	A@
=@33As@ff@z@ۅ@{AHAA=qAAUGAMpAAGAnffAqA!GA/
@߮@@˅A\)@\@=q@QABff@RA33AL(Ag
Ac33AvRA\AH  AzA(zAS\)A@H@@ffA@@@@@
=@ff@
AAAzA
H@Q@Q@33@ƸR@(A@33A@pAL  @ff@
=@@;@g@GA@ff@
@@n{@q@@@8Q@>{@E@ff@  @@s33A0  A(@@\)@
=@  @@AAA@p@@(@Q@
=@
=@U@s
@7@R@Q@p@`@{@G@=q?\)??=q???(@@@(@#33@@.{@?Q?(??z@R?@@~{@N{@:=q@^R@<(@2\@8Q@7
=@8@B\@(@8Q@1G@'
=@5@"\@333@\(@a@.{@H@.{@*=q@G
=@?R@z@
@  @?
=@{@?{@\?ff?ff@z?˅?33??z?
=???xQ?G?޸R?p?ٙ?=q@Q@@@%@.{@8Q@4z@Dz@U@@w@H@w@
@p@A@c
@5@333@G@[@U@a@@<@.{@?Q?ٙ?@\)?@{@#
@	?\)??
=?
=@??H?p?\?z?Q?p??ٙ?  ?(?33?{@\)?p?ff??{?˅?R??G??ff??z?z?
=?xQ?\?s33?Tz???\)??s33?\?
??
?Ǯ?=q??\)@z?33@33?  ?33@33@Q@@!@JH@@
@@(@G@|@zH@(@G@
=@@@{@@G@@c33@~R@s33@H@S
@@Fff@@w
=@p  @y@\(@,(@)@=q@%@R@p@\@ZH@:H@B\@!G@8@ff@
p@
@?z@z@@\@z@
?@33??\)?У?˅?
=??33?
=@33?z??G?(?
=?R?  ?У??G?
=?Q?У?p??У?ff@z?
=???Q@   @ff@@z@\@(@H@:H@AG@^R@W@y@|(@@H@@H@
=@@@
=@(@Q@@@R@z@z@y @Q@p@@@@G@z=q@~{@`@xQ@a@U@W
=@H@XQ@^R@N{@?\)@>{@333@(Q@!@Q@/\)@;@L(@B\@#33@B\@B\@@@@G@@@?R?ff?ٙ??@@{@@@   ?R@R@ @\)@@?H?{?G?
?33?ٙ?У?
=?ff?@Q@@!@?\)@L@Dz@nR@nR@R\@1@@  @333@2\@ @{@%@@
p@'@:=q@333@\)@L@L(@H@#
@1@dz@vff@=q@(@z@w@dz@nR@Z=q@qG@l@P  @C
@*H@<(@G
=@&ff@$z@@.R@%@@@\@33@@#
@!@(@R@0@3
@&ff@\)@	@(@G@\)@ff@0  @#
@@$z?33?޸R??p@
=@G@Q@	@33?  ?
?ٙ?
=?˅?=q?=q?@ff?@   ?z@@?=q?ٙ?33@@ff@33@+@1G@8@=p@.{@=q@1G@9@W
=@@ff@@p@@H@
=@ff@\@\)@@\)@@o\)@o\)@x@Q@n{@>{@'
=@O\)@1G@H@hQ@\)@  @z@@S33y @@s33@y@vff@\@Q@@~R@p  @Vff@G@:=q@3
@0  @6ff@:H@>{@333@{@R@@#33@(@@@ @%@,(@/\)@2\@*H@5@/\)@\)@@@(@@(?z?@\??{?p?@ @\)@	?\)@=q@(@)@
@ff@=q@#33@@@#33@%@8Q@I@i@`  @g
=@z=q@@z@@z@z@\)@G@(@
@@@R@@=q@|(@vff@{@\@Q@@@.R@W@JH@>R@Tz@33@*H@$z@Dz@@  @Q@8Q@{@$z@fff@c33@=p@G@L(@8Q@5@>{@E@=p@6ff@C
@AG@+@>{@L(@0  @	@@
=@z@\(@33@#33@;@??\)??  ?\)???(@??  ??R?p?p?ff?(?  ?33?@@X@#
@
p@P  @{@33@b\@@z@R@Q@@R@=q@ff@H@G@G@@33@@
@zH@jH@dz@g
=@g@c
@@@\@\@@Q@@H@\)@\)@@=q@@\)@u@u@U@b\@c33@`@^{@p  @U@<@
=@Dz@G@XQ@`  @JH@H@<@"\@@   ??
?
=?G?\?p?H?=q??33?  ?У?Ry ?Q?(?Q??Q??
=??G??(?ff?
=?p?p?\)??У?  @@1G@Vff@K@K@R\@U@\@e@g@l@mp@x@xQ@
@~R@qG@e@=p@E@L(@6ff@:H@7
=@:=q@;@*=q@:H@:H@@\@33@
@@   @(@@@ @ff@
=q@
H@\@
?R@?Q?G@33@   ?Q?(??Ǯ@@
@   @@
=q@@?@R@?H@H@
=q@(@%@*H@%@:H@NR@O\)@P  @H@L@.R@J=qy @p@@@H@@Fff@@,(@E@Mp@Vff@XQ@jH@  @@@G@zH@@k@  @}p@h@R@}p@@H@w@l(@XQ@z=q@r\@@zH@C
@Ly @=p@NR@9@0@33@G@@G@ff@
=@%??\)?ff?  ?ff?H@??
@{@@"\@@@7@=q@+@#33@>{@(@>R@$z@%@@L(@(@%@!G@R@)@8Q@E@H@qG@(@z@p  @p@p@U@p  @<(@>{@+@^{@33AffAQ@  @X@\@@o\)@Q@HA\@@@@R@z@{@@@Q@
@\@@\@Q@
=@@@G@@z@@@@@@=q@\)@zH@G@\)@G
=@33@G@~R@hQ@l(@nR@p@i@q@nR@o\)@mp@p  @`  @QG@Gy @Dz@P  @=p@7@?\)@3
y @2\@+@,(@'@%@0  @R\@^R@N{@@4zy @<(@p  @Y@aG@hQ@  @ff@~{@Dz@9@:=q@.R@
=q@
p@@ff?@
p@ff@
=q@+@@@
@#
@)y @0  @9@^{@c33@@@\@@ff@zABGA  ARAGA`zAAAAff@  @@@  @R@  @@
=@(@=q@(@ff@
=@
@Q@\@@p@@@{@\@p@@33@
=@ff@l(@|@qG@r\@@{@aG@\)@q@s33@:H@]p@W
=@e@r\@l@{@p@u@~{@c33@tz@o\)@9@xQ@\)@|@HA  @@\@r\@33@g
=@@\)@3
@#33@'
=@&ff@(@2\@9@NR@^R@Z=q@=q@@H@R@ff@{A33@陚@pA (AzA'
=AAAUATAB=qA!A   A$(A(@{@@ڏ\AQ@(@@@33@@33@@{@Q@s33@/\)@<@8Q@2\@-p@=p@aG@U@j=q@b\@g
=@@=q@y@(@33@QG@@z@@@R@33@\@@=q@\@@z=q@
=@5@N{@;@g@s33@@I@U@.R@AG@p@1@?\)?z?\?ff?{?H?У?Ǯ?\?У?p@<(@{@x@,@{@(@@\@\)@@@u@33@  @
=@=q@AffAGA$(A:\AQAFRA((A_
A
GA3\)A0  A5A,zAPA6=qA
A
=qA\)A@=q@33@@\@@
@\@ff@p@qG@l@7
=@0  @>{@\(@hQ@p@nR@o\)@H@R@@@\)@ff@p@@\)@R@  @@G@w
=@h@x@@
=@jH@  @@l@@
@G@=p@z@U@R@#33@%@
=?@
=q@@
=@@w
=@`  @@\@=q@\@@Q@
@p@H@\@@zA@@=qA\ARAGA"\A>{A[AUpAYpA{33Ao
ArffAHAQA8A*\A@
A  A\)@HA  AQAG@\@33@@@33@=q@6ff@9@e@Fff@G@7@NR@H@p@Z=q@b\@a@@@@@@\)@@(@p@@\@p@{@o\)@@@8Q@8Q@Mp@Fff@XQ@L(@4z@,@(Q@J=q@S33@QG@^{@z@\@(@
=@@33@H@(@@33@  @  @{@
=@33@G@ff@@ff@@{@  @G@@
@33@G@\@@AA(A  A{A,APAGAAhzAf{A<  A
AGAt  A'\)A.ffAQ@H@p@G@޸R@ff@ə@z@ff@@@@(@(@\)@H@
=@p@@@Q@@
@@
=A@\)AA(@A@@A\A  @z@\)@@@
=@33@pA'
=A*\A  A
p@A@\@  @z@z=q@
=@(@1G@`  @Q@L@@˅@@@@H@H@Ϯ@H@@@aG@@z@ffA
A0  ARAFRA9A  AA
RA   @@pA:ffA@ff@z@p@=q@G@@@\)@أ@@z@˅@z@ӅA   AAA
=AA*RA$  A\)A@ff@@  @@У@@=q@R@@(@  @@p@
=@p@Q@ff@Q@
=@g
=@R@@G@(@(@@
@\)@@\@@ff@@u@\@@
@@  @S
@W@@@#
@/\)@
=q@{@
=@@)?p@G@W@=p@W
=@H@I@@\@Q@\@zH@|@z@r\@  @  AA
=A=qA/\)@zA%A
A$zA!A:ffA   AH@Q@θR@Q@@@@r\@=q@R@33@s33@S33@E@L(@JH@HQ@Y@X@p  @r\@s33@@@33@
@@@@s33@~R@Q@@@
=@@=q@p@Q@R@g
=@ZH@~R@33@p@@(@zH@dz@c
@b\@Q@
=@Q@s
@G@0@+@^R@z@_\)@j=q@[@ff@u@@w@p@=q@
@@(@  @@@  @\)@  @  @{@@tz@G@@@{@\@z@@@=q@
@~{@zH@`@QG@K@>{@Fff@NR@QG@K@@z@@33?{?Q@#
@
@;@{@@@E@@\)@z@@  @*=q@@333@JH@6ff@Fff@@  @0  @!G@fff@@  @	@@{@@  @6ff@Vff@7
=@e@S
@l(@\(@l(@(@L(@.R@B\@8Q@%?
??@@@6ff@,(@R@-p@@  @,(@5@H@@\)@H@P@p@RAAA @{Az@@p@Q@
@@H@  @p@(@33@@@`@@s
@qG@ZH@P  @E@HQ@6ff@=p@@@X@`@n{@\@p@X@.{@7
=@I@c33@mp@`  @/\)@Mp@@tz@8@@a@z=q@j=q@`  @Vff@h@^{@b\@G@s33@b\@W@Dz@jH@\@b\@R@A@E@0@#33@1@p@1G@@L@*=q@Dz@A@3
@Dz@=q@R@\@   @0  @'@,@-p@(@:=q@*=q@5@^R@a@g
=@W
=@R@G
=@H@I@nR@vff@G@z@@\@{@33@p@@(@
=@@G@g@=q@QG@0@nR@j=q@a@@  @*=q@W
=@l(@I@N{@R\@P  @(Q@P  @%@Fff@1G@r\@G@@\@AG@Q@@Y@Tz@\)@ZH@J=q@C33@:H@H@@#33@,(@333@,(@-p@HQ@1@&ff@,@!@(@!@(Q@'
=@6ff@/\)@7@'
=@?\)@@R@\)@   ?@Y@P  @0@:=q@w
=@@@G@G@  @33@aG@\)@@
@p@z@
@\)A
AA\)Aff@33@@@
@H@@ȣ@@\)@p@o\)@^R@@Q@9@&ff@5@(@
H@
H?R?(?R@z?
=@@=q@5@E@H@@>{@z@$z@\)As33@?@?H@ ?33@??Q?z?z?޸R?p??  ?ٙ?(?Q?=q?\??\?\)?У?\?޸R?(?ٙ?  ?
=?\???
=?p?  ??  ?
=??H@@aG@(@@H@G@@z@?@@(@Ϯ@=q@(@  @H@z@p@@
=@33@=q@
=@
@z@@
@@  @@\)@@\@33@p@Ϯ@  @^{@\(@R@
@@Q@O\)@5@Q@@0  @<@%@z@z@   @G@@\)@@33@p@R@
@H@=q@^R@j=q@XQ@#33@@,(@@   @\@J=q@z@@@@<@  @@\@*H@   ?33?z@\?{?33??R?  ?  ?=q?
=??˅@
H@@*=q@)@:H@Dz@NR@q@(@\)@@{@Q@
=@{A
=AA'
A:=qA<  A#\)AO
=A?
AV=qAEGAKA\AJ=qA=qA
G@@@
@=q@33@@8@N{@4z@3
@*=q@P@u@Vff@K@@  @=q@{?\)?
=@z?\)??޸R?޸R?У?  ?  @@@p@H@3
?ff?@(@JH@mp@Z=q@O\)@HQ@G@=p@'@?\)@,(@1G@-p@:=q@aG@.R@"\@!G:HR@G?@@H@
=@{@ff@
@G?z??p@
H@@R@@ff@
=@   @?\)@e@`@r\@@Q@Q@33@@G@G@љ@@@=q@33@=qA Q@@(@߮@߮@H@z@
@@\)@\@@@  @@=q@@ff@@=q@H@qG@x@
@e@Z=q@Q@mp@@p@\)@tz@mp@e@E@7
=@\@g@_\)@\@U@P@G@J=q@E@JH@#33@-p@%@{@z??ٙ????{??p@Q@+??\@7@(?ff?޸R?(?
?\?p?
??
@@%@S33@XQ@\)@@Q@z@@ff@33@33@@p@H@ٙ@ٙ@@߮@33@\)@G@@@\@@@@@
@
@R@G@(@
@R@@
@|@  @\)@|(@  @G@aG@B\@G
=@[@j=q@Vff@5@E@AG@c33@@s33@X@
@s33@Q@n{@,(@@?@   ?33?
=?33?z?H@
=@H@?=q@8Q@Q@5@g
=@33@@7
=@3
@(Q@?Q@33??\)?@E@g@Q@7
=@8@P  @n{@@  AW
=A2=q@@\)@=q@w
=@+@7@@  @H@W
=@O\)@`  @\@@@jH@y@aG@:H@:=q@'@?\)@,(@3
@ff@@(Q@"\@"\@>R@/\)@'
=@R\@NR@Q@4z@Mp@;@<@*H@@ff?
=@z@@@
p@@@@
=@\)@p@
=q@ff@
=q@z@{@&ff@z@(@{?@Q@{@'@%@8Q@QG@<@H@@Q@@33@p@.{@?\)@zH@
=@j=q@A((@
@33@{@@ALA'AA
A\)BRB
AA{AAff@@@ff@@
=@@\)@nR@a@b\@I@NR@a@?\)@9@?\)@'
=@Dz@p@\)@$z@@@%@@%@8@)@,(@!@z@@R@(@
=q@
=@
?z???
=???\?  ?G?\)?H?Q???{?@@#33@:H@ @\)@#33@W
=@8@5@8Q@E@dz@@\@{@\)A	A!@>R??p@z@Q@@  ARA	@@H@~{@z@(A8@HAEA0(@G@33@H@Y@Tz@mp@s
@|(@@R@  @G@zH@{@
=@(@\)@Q@
=@@@@p@(@ff@tz@@\@=q@\)@l@#
?@#33@1G@1G@  @?H@
=@z@33@@  @(@
H@?@33@@@333@'
=@	@ff@2\@R@@H@@ff@  @ff@@33@?R@@#33@   @G@@   ?=q??
=?H???
=?(@z??
=??H??p?Q@@ff?R?33?
=@@H@   @E@S
@(@@z@@\)@@@@Q@@H@z@ff@@@  @@@љ@ٙ@z=q@g
=@C
@fff@g
=@ff@@I@4z@%@*=q@@  @@33@
=q?p@???{?z?{?  ?  ??(?@   ?
=???=q?{??
=@@@
=q@  @
H@R@ @H@  @ff@@
=q@p@(Q@z?@R?(?\)?H?G????\)?=q??
?
=?  ?Q?\?=q?(?(?޸R?@z@
H@@1@(@<@S33@c33@\)@vff@@z@\@\@33@z@w@b\@@r\@@Y@1@%@H?p?\)?
@z@@$z@R@R@!G@@
=@p@@Q@\)@,@#33@@@R@\@@=q@@  @z@@
@z@33@\@	@
=?33@Q?R@5@.R@@@P  @@@!@R@@z@!G@@
p@
=@??p?\?{?
?Ǯ???\)??G?˅?
=?
=?H@Q@Q@{@>{@*=q@B\@e@=q@@33@
@@33@@@p@
=@
@z@  @=q@@Q@|@Z=q@mp@@z@R@|@@?(?@(@/\)@aG@@g@Mp@}p@Tz@HQ@=p@4z@1G@'
=@{@}p@
p@W
=@E@6ff@{@`@H@J=q@G
=@@@:=q@(@W@\@\@@@0@AG@/\)@R@%@?Q@
=@3
@?{?{??H@@g@z@?p?\)@G@R@[@@(@g@4z@4z@<(@L(@zH@H@P@<(@<(@333@R\@%@?\)@E@\(@C
@.R@333@1@`@}p@U@JH@5@@!@   @)@@(?(??p??33?Q?33?
=?\??{@
=q@z??H@ ?
=?H?????Q?
=@
@33@@\?R@Q@
@
p?(?\)???˅??ff?{?
=?޸R?{?H?\)?ff??u?  ?
=?{?G?H?Q?
??\????z???\?Q??R???  ?(@
p@??(?p?33@5@\@^R@s
@p@p@@@=q@z=q@dz@G@1@'
=@!G@ @@
@  @
=q@#
@Q@
=q?@	@
=q@\)@@z@ff??
=?p?H?\)?=q?\)??33?=q?R?\)?p?H?R?
?(??\?H??p?  ?{?{???ff@?p@33y ?Q@\)@)@(?p?
=?=q?\)?ff@(@ff@ff@H@U@@ff?У?
?\)@Q??
=@R@Dz@9?
=@p@4z@8@<(@Ey @vff@G@@R@H@z@@{@H@p@p@p  @hQ@qG@W
=@W@z@u@{@qG@i@u@^{@7
=@>R@&ff@\)@.R@!@:H@8Q@3
@{@z@!G@)@'@'
=@@
=?@ff@??ٙ?˅?H?G?
?(?=q?
?
=@@(@!@"\@@.{@5@jH@w@u?R?ff@{@@  @1@Dz@R\@c
@~R@]p@33@\@l@(@\)@Q@{@H@ۅ@@R@{A>ff@=qAZ{A(@AyA  AQAeAHA:=qA+33@ABRARHA,@@=q@(@@H@Q@
@S33@7@:=q@5@.{@:H@@@>R@HQ@l(@9@Q@H@P  @H@7@8@8Q@(Qy @0  @/\)@"\@\)@@@{@
p@\)@ff@@\)@
H@ff?ff?Q??\)@#33@5@j=q@P@e@fff@@(@ə@\@əAAARAffAAU@z@@`@߮@	?p?\??R??(?p?ff?(??  ??
?\)??ff?@R@\@[@w
=@33@  @
@H@@@@@
=@Y@aG@nR@@@z@@@@
=@H@?\)@L(@K@4z@8Q@+@@  @5@9@S
@XQ@Tz@o\)@Q@p@qG@ZH@~{@Y@W@`  @E@7@5@%@$z@@Q@R?@(@\)@@
=@-p@	@{@\@\)@ @NR@o\)@Y@|(@Q@U@=q@  @\)@{@8Q@*H@O\)@^{@{@
=A
AAZ\AaG@G??ff?33????@nR@??G?޸R?H@"\@0  @]p@zH@
@Q@p@@=q@ʏ\@@Q@(@@@@@  @r\@8Q@b\@G
=@G@#33@R\@8Q@<@l(@-p@JH@I@G@P  @P  @Z=q@p@  @vff@ff@A
@@U@>R@Vff@0  @H@K@<@ZH@C33@5@  @
@E@@/\)@#
@HQ@k@  @33@>R@P  @.R@(Q@'
=@ff@@'
=@&ff@(@&ff@K@0@Tz@<(@@  @G@Y@B\@W@i@P  @Z=q@i@fff@`  @Y@mp@{@
=@@@p@@  @\)@33A{@@(A\)A33A{A
=A@z@R@|@(@Q@@
=@G@G@@33@{@߮@Q@G@@ff@@}p@~{@g@w
=@^{@j=q@fff@I@X@c33@Z=q@
=@zH@@L@~R@C
@?\)@*H@=q@333@:=q@$z@P@/\)@.{?@@XQ@R@G@@jH@Q@ff@a@@!@N{@mp@@?R@7@R@ @@@4z@R@Mp@C33@?\)@*=q@\@P  @Y@L(@G@@\)@@
AA=qA"{A
@@@@pApA33A	GAGA@  @@G@@@ff@(@@z@y@{@Q@s33@l(@\@e@Y@c33@Y@S
@  @b\@p@q@U@G@G
=@8Q@5@7
=@,(@#
@\@\)@
=@G@@@{@@'@(@Q@G@
H@R@   @@
=q@ff@\)@(Q@0  @1@3
@?R?H?=q?\)@\@
p@R?H@\@  @  @
=@z@
@@(@&ff@6ff@Fff@P@`  @
=@H@R@(AAA
AA/AFHA<A/
A0A(QA?
APA(A@  @\)@
=@H@=q@(@z@@
@@p  @\(@P  @O\)@`@Y@S
@ZH@{@p@G@@x@r\@`  @XQ@G
=@5@{@@R@ff@0  @"\@	@B\@333@\@z?@   @@{@(?(@@@??@*H@vff@C33@ff@@33@@(@(@8Q@>{@Fff@[@xQ@w
=@w
=@n{@h@X@n{@c
@mp@p@@@A\A$zA(A A.\AP  A/\)A
A|AkA33AX  A9A.\A:RA*R@  @׮@33@=q@=q@p@@@=q@@Q@
@ff@@33@\)@P  @W
=@8@-p@(@z@$z@(Q@"\@  @
H@
=@\@{@#
@(@@	@\?@p@{@33@fff@R\@L(@P@U@aG@x@^R@tz@R\@HA\@H@z@=qAC\)@@~R@ff@u@@@5@z?33@@@9@c33@q@33@@z@=q@@
@A
=A33A6=qA/
=ALQAO\)AMpA~RA|  A\)A|A;33AA\)A
=AffAFRAeA  AQA>\Ag
ARARHA}AG
A  Ao33AqA)AO33ABRA\)@33@(@@=q@
=@R@H@G@@
@ȣ@{@@@
=@p@@@@33@pApA(A
A{A
@G@
=@R@H@Q@33@G@@H@@޸RA@Ϯ@љ@p@@Q@˅@@R@@G@n{@R@@@@@\@@R@H@
@pAAA@QA
HA33A   A$QA33A5GA9A=AEA<(A%A+33ADzAFffAhQArffAn\AAXzAWA/A;
=ALzA4QAG
=A:\A8zA"\AAk
=A
GA/
A(@(A
{@=q@p@A\@Az@@Ǯ@HA @(@H@@
=@{A
@{@@Q@h@hQ@QG@l(@r\@z@@z@Q@~R@@@{@C
@=q@p  @W
=@G@\@  @xQ@Q@(@n{@g@5@	@Vff@>R@7@B\@A@^{@l(@^{@G@R@\@
@p@33@@33@޸R@GA	GA\)A%A"=qA5GA0A[33AV\AVRAQA
HAB=qAK
A@  @@@  @@~{@AQ@@@!@r\@@u@a@hQ@~{@`@@`@1@ZH@z@`  @\@@\)@33@@@@  @p  @w
=@qG@;@X@Y@nR@mp@b\A@w@@  @O\)@p@p@S33@(@@:H@[@@p@]p@dz@6ff@5@u?z@	?33?Q?=q?Ǯ?\)?\?@?
?У@{@?R@0  ?@
H@ff@@@S33@nR@a@xQ@@@{@(@~R@w@tz@Q@p@z@
@y@|@b\@~R@@\@u@	@NR@p  @\@h@o\)@\@S33@33@c
@(Q@:H@#
@!@5@%@/\)@$z@+@0@.{@#
@33@(@*=q@@&ff@{@G?=q@
@Dz@C33?p???  @\?p??p?33@ ??(?33@(Q@H@P@c33@vff@|(@W@@@;@,@U@mp@c33@h@>{@Z=q@Q@|(@`@QG@W@K@@:=q@a@S33@3
@>R@A@qG@33@@H@@{@z@33@33@G@\@  @@s33@@
@@~{@qG@Z=q@q@jH@`  @c33@`  @\(@QG@Fff@(@"\@+@.R@333@8@7@>R@:H@,@3
@@@<@'@1G@(@\@p@$z@H@@33@@ff@  @@?Q?Q?z?@ ?{?Q@   @33?z@\?ff@(@   @@Vff@R\@_\)@{@  @Ǯ@@8Q@n{@N{AƣAA33@GA<@Mp@
=@y@u@jH@  @p@@W
=@z@h@\)@a@g@`  @_\)@@@xQ@33@
@zH@s33@s33@\)@h@vff@G@e@l(@tz@H@E@(@E@,(@ff@s33@dz@[@<(@fff@NR@B\@G
=@:=q@JH@]p@b\@c
@Mp@o\)@`  @W@a@>{@1G@J=q@W
=@b\@Vff@9@*H@\)@+@H@ @#33@#
@&ff@+@333@@@,(@\)@@R@	@	???(?p@G?(?33?{?{??
=@@{?{@@z@@
=@33@&ff@@=p@w
=@@@@  @  @@\)@@z@θR@A\@@p@ff@@@{@-p@I@Tz@P@N{@=p@.{@:=q@B\@-p@   @\)@z@33@
H@{@@z@!G@+@:=q@2\@8Q@@+@NR@QG@^R@l(@(@{@@ָR@A
HA(AAA4A,(A,zAzA
=AA33@ƸRA
=AA{ApA33@RAff@Q@@
@@j=q@{@{@^R@dz@z=qA^ff@X@QG@z@@
=q@   @
?H?@z?p@?H@
=q@R@Q@333@C
@AG@>R@Fff@dz@=q@
@z@=qA33@z@p@{@Q@ffA\@=q@@Q@
@@ff@@@G@G@s
@x@n{@w
=@|(@z=q@`  @fff@fff@U@W@P@A@,(@QG@JH@\@^R@g@e@\(@S
@k@[@G
=@c33@^R@@@^{@W@Mp@G@S33@[@333@'
=@)@6ff@@{@0  @(@ff@%@@
=q@(@  @(Q?  ??У?Q?
=?(@@*H??=q?{??{@0@?(@{?  @ff@p@C
@+@,@+?ٙ???=q@	?z:H?xQ??R?Q?\)??Q?Q?˅?Ǯ@@  @_\)@\@(@p@
p@{@{@
=@R@#
@g@@@(@(@@33@33@
@@
@=q@\@\)@\@s
@hQ@L@8@\)@-p@33@\)@G@C
@`  @{@2\@@qG@z@\)@G@У@33@p@  @
@@R@\@  @@
@@@@pAp@=qA+\)AGAHQAATQAEA,AHA&HA;A>\AC
A^=q@A@aG@:H@
=@[@7
=@^{@\@
@H@<(@@w
=@x@Q@Q@@z@p@Q@
=A
=AAEpAR\Av=qASAA|zA{\)A+
AeAjHAK
=AV{A(A?
=A-G@p@\@@@
@p@  @@@R@@(@  @{@
@@G@A"\Ap@AA (@{A
=@A.\@
A
{@@əA@p@ƸR@zA@(@@@
=@33@=q@@@x@@@Fff@p@   @
=q@?G?H@#
?Q@@4z@7@,(@:H@QG@JH@N{@0  @nR@(@@@@ffAA   @  A2\ApA(AA@(A
=qA#A*ffA0  @H@R\@g@@2\@{@Q?ff?޸R?(?=q?{@L(@AG?@
p@+@@QG@H@zH@!G@R@(@
p@@P  @U@=q@R@
@QA\)A
{A
A
=AXzA$  AA
H@ff@
@AffA33@@\)@33@p@ff@33@p@@G@{@HQ@<@9@"\@
=@??G??ٙ?=q?  @   @@333@4z@NR@.R@:H@8@L(@z=q@_\)@p@\@33@
@G@  @ٙ@=q@zAp@H@@
@\)@c
@;@!@=q@HQ@E@XQ@O\)@^R@~{@2\@c33@L@Z=q@u@33@G@ff@  @=q@@\)@@(@Q@=q@ff@=qA0@ffAA%pA1pA?
AEAH  AAAIA]AK\)A>ffARRAApA9A7
=A;A,A%GAAzA Q@2\@h@z=q@z@]p@I@S
@a@$z@+@'
=@
=q@
H@$z@@-p@%@G@
=q@z@
p@(@   @R@:=q@HQ@L@Mp@{@(@33@p@
@33@A(AA4(A%pA=GA*HA\)A1pADQA>=qAH  A A2RA
=AHAffA
H@ff@33@@\)@ʏ\@  @  @@\)@z@A=qAz@G@
@HA@ƸRAff@Q@H@@@G@@p@@ff@@i@g
=@p  @%@(Q@&ff@ff@H@?@z?(????
=??z?ٙ??H@?33@
H@!@HQ@P  @{@@@\)@@33@=q@\@@??=q??G???G??{?Q?p?G@G?p@H@9@%@[@\)@z@e@qG@~{@@
@C33@P?ٙ@+@ff@\@-p@R?
??У??{?=q?\)??@?\)@z?z@R@1@7@;@Dz@e@~R@@\)@@@׮@H@@pA@\)A @(@\?R??H@'@   @\)@
=q@?@@@ @G@\)@.R@z@;@P  @r\@\@@  @\)@Q@\@ff@@@pAA33AA
AAA=qA	@G@\)@33@p@p@Q@p@@@
=@@
@@33@33@=q@@@@ڏ\@  @\)@W@Q@Fff@(Q@5@AG@N{@7@1G@0@:=q@7@]p@|(@\)@h@b\@R@(@@c
@<(@<(@Q?p??=q?
=?\?G?\)?=q@@@%@#33@U@L@Tz@z@|@G@p  @n{@Q@=q@@@
AGA\)AA A%pAffA$(A$  A)pAffA
=qA{@@\)AGAA{A(A#\)AffA@RAzAA(A'A@R@陚@
@θRARA   @{@@=q@33@@ff@(@  @@@p@G@  @@@ff@mp?(@z=q@
=@NR@p@vff@|@>{@=q@
=q@(Q@C33??R?{@#
@\@=q@vff@
=@0@[@o\)@Fff@:H@.{@(Q@\)@G@@@{@@ָR@{@ᙚ@ffA
\A
@@|@z@\)@|@e@g
=@|(@@p@G
=@(@\@u@hQ@g@tz@ff@hQ@1G@L(@B\@E@E@$z?(??(@@
=A4QA@
=@A@@{@   ?  ??G?
@R??\)?@H@\)@>R@S
@W@p@@@
@@p@@33@ff@@ᙚA33A
HA@AAA\)@ʏ\@33@1G@@p@@R@@@ҏ\@θR@
@=q@ff@\)@
=@@Y@I@7
=@N{@<(@JH@N{@<(@k@:=q@r\@c33@l(@xQ@zH@  @\)@
=@\@
@(AA @@A\@@zAA(@ٙ@{@AA  A@ff@H@z@  @@=q@ڏ\AAAA
RAzA[33AHAAJ\A
@A@@
@q@\)@NR@|@y@p  @Z=q@'@,(@=q@@
H?\?ٙ?@
?Q?G?
=?33??33?{@
H@fff@S
@{@
@b\@~{@dz@(@vff@(@(@vff@u@~{@^R@>{@l(@9??@?޸R@[@mp@l(@~{@@
@
@{@@@ff?p@NR?޸R?@\)@p@
=@A1@p@,@{@{ARALQAGA?
@A0A
=A\A{AծA(@{@yAB A
=A@z@ff@
=q@'
=@<(@+@?
?(?  @?R@{@R@@&ff@=p@Vff@fff@e@X@)@@z@
@G@\A (@@Q@\@@{@@A{A AHA33A\)A(AAA{ARA33AQAzA	A	A33A\)AQAzA
ARARA{AA=qAffAzA\AA   A   @z@p@{@=q@@@  @{@
=@@p@@  @@ff@@p@@33@@G@33@{@
@@(@@
=@
=@
=@@H@=q@ff@z@@z@@
@(@
@@@G@H@@33@@@R@\@ff@H@  @=q@z@@Q@@@@AzApA\ARAHAA  AA\)A\)A\)AA\A33AzAA=qA
=AQA	A
RAA{A
AAA(AQARA
AAA  A\AAffAAHAz@33@33@R@\@@@@{@
@@(@陚@@33@G@@=q@(@@(@@=q@H@@Q@@ff@陚@\)@p@R@@ff@R@@(@ff@R@ff@G@  @33@z@(@(@@\)@Q@@33@@A@33A\ApA Q@A	GA  A33A
AAAA
AAQA  AAAA
A
pA{AHAAQAGAAffAffA=qAAA
AAzAzAApAA\AQAA @@AAzAAAA
@@{@ff@p@@@
@
@(@ff@33@  @ff@@@@R@=q@@@ff@@@\)@H@@@(@  @
=@H@@ARAff@ffA{A33AAA	A
\AAA	pA
=AAffAA  AzAAA	pA33AA
A
A\)A
A(AA  AAAA\)A33AHA
=AAffAA{AHA
=A{AzA  AAHA{A
A33AGA  AA
A
pA33A(A33A
ffAA
AHA{A=q@AAGA z@\)@R@\)@@G@
@=q@
@33@A
=@33AA
=A   @@H@@@@
@{@(@@@@@\)@(@\)@@{@\)@R@Q@H@@{@33@@@@@@G@
@
=@  @RAA  AA	pA  A
=AzA=qA\A	GA
=AAQAzAzA@p@RAHAAA\)A
=@(@@@@@@@33@p@ff@p@=q@@(@ff@@@(@33@z@=q@33@p@ۅ@߮@
@ڏ\@  @ָR@@z@p@\)@G@@@أ@H@@=q@ٙ@Q@=q@ٙ@ٙ@G@@=q@G@ٙ@޸R@@z@@
=@R@33@H@p@(@@Q@H@ڏ\@(@߮@ۅ@\)@@G@{@Q@@33@@z@@@ff@@H@@RA{A	A	AAA{ApAA{AA(AARA A @@
@@
=A   @33@@(@R@@=q@=q@ff@
=@@ᙚ@p@ᙚ@@
@p@@Q@G@R@@G@@@@=q@\@\@33@\@\@@\@ᙚ@ᙚ@G@=q@\@H@@\@
@{@  @(@R@ff@33@\@p@@@@陚@ff@R@@@\)A\)A  ApA(A	GA
{AAzA	A
{A	A33A
RA	A
\A
=qA
RA  A
A
A
A
pA
AA=qA	GAA
A@(@@(@@@Q@
=@@
=@  @\@p@p@\)@@  @(@
@@@R@@H@  @  @  @\)@(@@=q@@@=q@  @=q@@H@@@陚@@Q@@33@H@{@R@@G@@=q@\)@ff@@@@@=q@\)@(@33@p@
=@HA AAAAAzAHAGAA (@\)@{@z@33@{@A A=qAA  AGAARA
=A	A{AA
AApAA  A\)A
=A
=A
=A
A{@\)@(@z@@(@H@@@Q@  @
@@\)@޸R@ۅ@H@׮@ڏ\@=q@@ڏ\@33@ۅ@33@
=@=q@(@p@@G@޸R@
=@@(@ff@Q@H@@@=q@@p@\@H@@@p@@ff@@
=@@p@
=@(@@y @@@@@  @ff@@(@
=@@
=@Ap@ff@A
=@{A QA AzA=qAAAA{AffA{A33A\AAzA
AA{A\AHAffAff@
=@A@  @@\)@
=@
=A A   @
=@\@@(@@=q@H@@@陚@33@@\)@
@@\)@p@z@  @\@@\@=q@33@@@(@z@@@R@@G@陚@=q@G@@33@z@{@@R@
@@@
=@@\)@Q@\)@33@
@=q@@{@33@@@\)@\)@p@33@@@@Q@Q@G@@\)@{@@
=@ff@(@ff@\@陚@@Q@Q@Q@
=@p@@
@=q@H@@H@Q@Q@
=@@ڏ\@33@@H@
@(@
@33@H@=q@@@33@@
=@Q@
@=q@p@@@H@@@{@Ӆ@@@@Q@
@@ᙚ@(@@33@
@@p@=q@z@33@љ@=q@H@Ӆ@@ָR@أ@޸R@@
@H@33@@
=@z@
=@\)@\)@{@@ᙚ@@Q@@ff@\)@
@H@(@\)@ᙚ@p@@z@G@
=@@@
=@@@@{@G@
=@(@Q@Ӆ@@(@ָR@@(@Q@(@H@
=@33@@\)@
@@\)@@R@@@@\)@\)@{@\)@  @\)@G@@G@G@@@{@@
=@@@@@ff@@\)@@  @p@У@@љ@{@@{@  @У@Ϯ@ff@z@@θR@  @G@=q@
@@{@Q@أ@=qy @H@z@33@@  @@أ@أ@@@Q@H@Q@@ff@@@ָR@
@H@љ@G@\)@θR@У@\)@θR@{@p@G@
=@Ϯ@ҏ\@У@љ@\)@p@@@@@˅@˅@
@(@z@@@@p@@@@{@θR@ff@θR@
=@θR@\)@У@z@H@G@Ϯ@  @Q@\)@
=@@@H@Q@H@p@ٙ@G@@@  @@33@33@ۅ@(@(@33@ڏ\@(@@޸R@޸R@  @  @
=@=q@@\)@@z@@{@R@ff@@{@p@
@=q@
=@@@p@\@H@\@@  @@ٙ@33@z@(@(@(@ۅ@(@ۅ@H@=q@=q@33@ۅ@H@z@p@p@z@
@(@(@z@z@@@@@z@@޸R@  @Q@33@ٙ@
@(@z@(@@p@
@@Q@أ@ٙ@G@=q@@@{@ff@޸R@߮@@G@@\@(@z@(@@@ff@p@@{@
=@Q@@G@G@陚@@=q@\@\@
@(@@@
=@  @@@@Q@@(@33@
@z@@H@
@33@(@(@H@33@
@H@@@=q@  @{@z@z@\@
@@ff@p@@@
=@Q@
=@@@G@Q@Q@@߮@޸R@
=@ڏ\@
@=q@@ڏ\@(@z@p@ff@޸R@޸R@߮@Q@ᙚ@@33@(@33@(@@
=@@
=@
=@@Q@Q@@G@G@陚@\@
@@@{@  @Q@=q@z@
@\@\@@33@\)@p@@(@z@ff@\)@@{@(@{@\@@{@z@G@=q@
@z@=q@H@{@@(@陚@
@=q@@33@ff@ff@R@R@z@@\)@p@@p@@z@@@
@
@z@33@\@@(@33@
@@(@33@@޸R@@(@ۅ@z@p@ff@@\)@@
@\)@(@
=@ff@H@p@@=q@@@{@Q@\@(@
@p@
=@Q@@@
=@@R@
=A @@33@AA(A\)AQA{AAGAA @ff@ff@(@p@ff@G@@(@@p@H@@  @{@R@p@陚@  @{@\@
=@@
@@Q@p@Q@H@\@\@33@G@@\@߮@ff@@\@@޸R@@@p@
=@@@ff@\@  @߮@@H@@H@@\)@@{@G@z@Q@@33@R@@@@@@(@\@@=q@\)@@@  @p@@@@=qA @AHAARA
pAQAAA\AA	pA
RA\)@AA	A @H@\)@33@@@@(@
@{@@G@\)@Q@R@{@ff@G@\@@@  @@R@
=@ff@@{@@Q@p@
=@\)@\)@\)@ff@\)@  @@R@@@z@(@33@@
@33@33@\)@޸R@@H@@z@ff@@z@ۅ@H@=q@@p@  @@߮@p@  @  @ff@33@=q@@@(@@@=q@33@p@{@
=@{A   AA
=A
=AQA33ARA{A
=A{A{A{A Q@
@@H@@H@(@\)@R@p@@H@
@@(@@ff@陚@@R@Q@R@@{@
@=q@
=@ff@33@@@@@@H@=q@R@@@=q@@\@{@ڏ\@
=@ff@ٙ@@=q@\)@\)@޸R@=q@ff@G@@(@@
@@=q@@ff@\@@G@G@@@@p@@pAARAA33A\)AQARARA=qA	A33A(AA	GAGA  AA@\)A @@=q@@@@\)@H@
@{@\A   A\ARAAGA A{@{@
A @{@z@ff@\@ff@(@@R@@@@
@@R@@ff@p@@@@\)@
@@Q@@@{@(@Q@@@
@\@33@33@ᙚ@@=q@p@(@ff@@
=@\@p@(@z@p@@A   A  ARA	A
A
A33A	AA
AzA
RA
AzA(A
AA{A
A{A33A(AAHAA33AAzAA33ARApAGAHAAApAQAffAHA{A33A @\ARA  A zA z@\)@A@
@  @ApAA (@RA   AGA zA @{A (A QA z@@@@G@33@z@G@  @@\)@
@AAApA @(@\)A @\)@{A@RA=qAHA33ApA zA (@
@33@
A (A (@ffA  AAA
ApA
\A
RAA\)AAz@
=A   A zA zAAA
HA
ffA	G@ffA
AAGAA   @p@@\)@@\)@\@
@33@@{A   @(@zA @ffA @\)AA
AA=q@ff@@@@Q@=q@\@@\)A{A\A @@ffAGA{ApA
ffA  AAAHA
GA\@\)A33A	A
\A  A z@(Ap@p@ff@(@
=AA	A\)A
GAA
HA
=qAQAA
A
GAA{A{A(AzAGA(A
GAAA
=A
AA  A @
=AAHAzAffA
=AHA@ffA AAQAGA Q@  @=q@  @@H@G@޸R@\@@ff@
@\@
@\)@@H@{@@H@ff@H@Q@@陚@@p@(@ff@@H@
=@@G@@Q@@@@ə@33@@׮@Ӆ@@@ҏ\@ָR@Q@H@ə@{@ҏ\@@У@{@θR@@H@H@33@H@@\)@θR@p@Ǯ@(@{@z@G@љ@أ@@˅@  @ᙚ@ff@R@
@z@\)@߮@@
@@G@R@33@G@
=@G@ۅ@z@@Q@=q@@Ӆ@\)@33@@H@Q@{@У@׮@ڏ\@  @Ӆ@33@У@H@H@ə@Q@z@\)@@@\)@@
@p@z@Ǯ@@@ʏ\@ʏ\@H@@
=@ff@H@\)@ff@p@Ϯ@θR@Q@@@љ@ff@љ@\)@˅@
@љ@=q@ָR@@ٙ@@G@@@  @@\)@G@@
@@  @@z@@@@\)AAA	A
A
AAHA33AA\)A(@zA (@
=@p@Q@@@@@R@R@Q@@@@=q@G@
=@
@@
=@  @(@@
=@33@{@ᙚ@p@G@@=q@@\)@@@@(@@@(@z@@Q@\)@@ff@G@p@@@H@@z@=q@@G@@\@(@ff@Q@  @@A   A Q@@A A
=AA (A	AA{A
=A
A  A(A  ARAHA33AHAzAzA	A
HAzA  A(A33A	GA	A\)AA
=AQA
=A\)A\A
\A	AHAA\AAAzA
A{A
AzA=qARAzAAA{AA (A  A
HAGAA
AAA	GAQA	GA	GAHA
A@
=@\@H@=q@@G@p@p@@R@
=@\@(@@@@z@p@z@33@33@=q@Q@p@@@@  @R@@  @@G@R@@陚@33@ff@
@
@33@@@@陚@G@@\)@
=@ff@ff@Q@  @R@G@陚@
@\@
@
=@Q@@p@@  @
=@H@(@@Q@
=@@G@@\)@{@ff@@@G@@Q@@H@H@ᙚ@Q@z@@
@z@z@{@z@@@33@33@H@ٙ@@G@ڏ\@H@(@=q@(@33@ۅ@33@
@(@@\)@@@H@ڏ\@ٙ@(@ᙚ@
=@@@=q@G@@@陚@H@@R@@
@@ff@@=q@@p@@RARA
=A  AA
=A@\)A QAA (A\)A\AA@@@HAH@@{@\@R@@@z@@\)@\)@Q@ff@z@@@=q@G@@  @  @(@33@@@(@H@@  @
@Q@G@=q@@@@\)@@@@33@(@G@@G@@\)@
=@H@@@@33@(@G@\)@@z@=q@R@ff@@ff@(@=q@=q@@\@@
@
=@@@AAz@AA\A
{A	pAAQAA
ffA
{A(A	A
=qA\)AA\A
A @
=@@@@@
@  @@
@@\)@p@{@ff@p@p@@G@ᙚ@ᙚ@ᙚ@33@(@p@@{@ff@{@{@ff@Q@
=@\@ff@߮@(@(@p@{@H@
@
=@ٙ@G@33@  @@
=@33@\)@33@33@(@@Q@Q@Q@p@Q@=q@A  @HA @H@
=@R@G@RA (@\@@AAA  A @@ffAApA
A	AAA(A	pAAQAAzA\AG@(A   @\AHA\@R@@@@@@z@@@޸R@@@z@=q@@ff@H@@z@
=@ff@޸R@=q@@\@  @ff@\)@=q@@@=q@{@@H@z@=q@ff@\)@Q@=q@@G@@
=@ff@@{@@R@p@@@H@\)A AHA
AA zAAAQAHA\AAAQAzAAAARA
=A=qA!GA#A#A=qAA (@(@@(@p@A   @{ARAff@
@A
ARAAAA@{A ApA (AHA\A @@@@\@@
@Q@\)@@G@@H@@@@@陚@@@Q@@H@
=@@p@@@@
=@
@޸R@G@Q@@@G@\)@@@G@ff@GA Q@@(@(AAAHA33AGA(A QA(AffARAA=qAHA{AAA(AHAAzAHA  A=qAGA
AA
ARAA{A
RAzAHARAAQA@z@@@  @@z@{@@@H@  @@G@H@=q@ff@Q@Q@H@R@(@(@
@@@@R@ff@{@p@@\@@{@@@
@\@=q@33@(@p@@@p@\@@@z@\@@
@{@ff@@\)@@@(@
=A
AA(AQAA{AHAAzA
AHA  ARAA  AA33A33A\A"\A%GA"\A"HAzAA
AAAAHAzA(AQA
A
=A\)AGAGA z@@H@R@@
@@@z@@z@z@\@z@p@p@=q@33@@
=@@\@ff@p@@@@@\)@@
@=q@ᙚ@{@@(@@@H@H@z@@33@@@ff@z@߮@ᙚ@޸R@=q@z@\@@ff@=q@\@p@@ffA AAA	A\)ApAAA{AA(A
=AA
A$A&{A&ffA'\)A&HA'
A%A%A#33A#
A!GA"RA"ffA!AA33A33AGAAR@(@G@33@@{@(@
=@H@Q@33@  @@@\)@@@{@
=@\)@@@
=@@  @  @߮@@G@H@Q@ff@ff@\@(@@=q@=q@
=@
=@{@{@@R@p@z@z@z@R@ᙚ@ff@\@@R@(@p@@ffAApA@@
=@@\AAzAA\A\)AzAA33A\)A(AARAHApA\)A	GAA
pAffAAffAAffAAAA(A
AA(@
@A @p@ff@@@@
@R@@p@\)@\@ff@{@@ۅ@33@  @@Q@߮@@޸R@{@{@(@@H@ۅ@33@(@@
@
@@(@H@
@ۅ@ָR@Q@
=@@=q@׮@p@љ@33@\)@z@(@\)@H@\)@Q@z@p@Q@33@=q@
@G@=q@A @
=@\)@R@(@z@A QA @z@@@A33ApARAAAAA=qA	GAA	AA
A
AA(A
A
A33A=qAH@@@  @H@G@p@\)@@@@@Q@@z@Q@@ff@@@@Q@ᙚ@
@@
=@@ۅ@
=@=q@
@
@@z@ff@@R@@(@G@\)@33@߮@ff@H@@@p@p@߮@  ?@(@33@
@ff@p@陚@p@HA AA\A AGAARA33A
A  A
=qA
=AA	pA	pA	A
RA{A=qA\A33AzA
HA
RAA
=AQAA
\A
{AA@\)AQ@\)@Aff@G@@G@@ff@
=@(@@@@@ᙚ@@\)@ff@{@z@H@@33@z@z@z@p@p@@{@ڏ\@z@
=@ָR@p@@z@@ff@׮@أ@H@(@@
=@p@Q@ٙ@ٙ@  @ڏ\@أ@p@
@z@
@\)@\)@@Q@{@Q@33@
=@ff@  @\)@@Q@33@{@G@@33@{@A A{AAAGAA33A=qA	Aff@@@{@@
=@ff@(@@@(@R@@
=@=q@\)@߮@  @@G@  @\@(@أ@@  @@Q@
@  @G@\)@陚@
=@R@33@@@@@
@z@=q@@ۅ@
=@@ٙ@@
=@љ@Ӆ@ff@33@G@33@H@(@ff@ff@Q@@ff@H@z@أ@
=@=q@@  @z@߮@=q@
=@33@{@ff@H@R@Q@@ff@\@=q@{@G@@@@
=@
=A AAAQA (AA	A
\A(AffA
=A A  @p@
@=q@z@@\@Q@@ᙚ@ᙚ@H@  @ff@@@33@33@ڏ\@z@{@{@@陚@H@\)@Q@
@@z@ۅ@z@@@33@ۅ@
@
=@G@޸R@\@(@@@
=@p@Q@ff@\)@z@z@
=@33@(@z@陚@\@@@ff@Q@p@z@=q@=q@@@@p@\)@33@A   AAA\)AA\AGA=qA\)A	A\)A33A33A{A
A
AA
=AQAA
=AzAAAA
AAHA
ARAA(AAHAGA  AA  AQA
A\)@ff@HAffA zApA QA @ff@z@@p@@H@Q@@
=@@@ff@=q@@@
@G@
=@
=@@\)@z@G@
@
@\@@ff@{@z@@@A A=qA
A\)A(AffA33A	A
=qA33AzA\AzA=qA=qAARAA33A
=A AAffAA\)A
A	A	pAHA
=@@@{@@R@@Q@
@
=@{@Q@@
@@p@
@z@@(@=q@  @@{@ff@33@z@  @z@\)@33@\)@A   @@A @AAR@\)@@{@A ApAG@@G@  @\)@@H@33@H@H@\)@H@{@@R@@z@@@Q@@G@
=@  @H@=q@Q@ffA (A zA\A=qAAAAAzAQA
A\)A  A(AAAzA
AA (A	A  A33A
AHApA(A\)ARAA\)AffAQAAA\A{AA=qA  A{AA	A
HA33AH@@ff@ff@Q@@p@33@@@@R@@@H@Q@A (@@@
@@ff@
@R@@(@=q@A Q@@{@@  @z@@33@z@{@=q@ᙚ@{@@G@\)@
ApAffA
=ARA	A  AffAzA
AzAffA\AAAAGAGA{AffAAA33AAAA#A%A$(A A"=qA"\A!pA (AAA   A
=A  AzA
=A  A(A\)A
\A
ffA
A\)AAA33A@RAAAA{AA   ApAARAHA\)@@@@ff@Q@@@@\)@33@ff@ff@ff@R@R@(@@@\)@@(@
=@
=@@G@߮@@G@{@\)@=q@Q@  @ffA AAQAQAA=qAHAzA
=AAA	GA33AA
RAzAAARAA
AAQAQA=qA
AAzA
RA
AQAHAQA	pA	AA@@33A\@=q@G@AA@{@H@@
=A @@ff@@@p@R@@@
@(@@{@
=@@@
=@  @{@@=q@@ff@G@ff@p@H@@
=@
@@=q@ff@(@
=@
=@@@p@@33@@p@@
=@\@  @H@ff@
@@@\@AHA@A
@ffAz@@pA@A Q@QA\)A
@AA z@z@@
=@G@@@z@=q@R@R@@(@A (AAAQA=qA
AGA(AApAAAAA (@@@33@@Q@@G@ff@@R@=q@
@G@G@33@@
=@(@H@33@{@@߮@@\)@@
@ۅ@@\)@ff@@  @33@33@p@=q@\)@@{@\)@@z@@  @R@p@
=@@p@(@(@@
=@\)A AffA A{A
AAHA	pAAA\)A
pA\A
AGA\)A\)A
AA{AA	GAA
A{AQAHA33AApA (@@@\)A
=@R@@@
@\)@@33@
@@z@@\@Q@AG@@@
@@
@@
=@@G@G@@33@33@33@@@@  @陚@\)@
@(@R@{@@ff@@@@@=q@z@
@@Q@@  @@@Q@
A A@z@=q@(A ApAAAA
=A	A
A\)A	A
=A33ApA
=AGAAGA\)A{AA
=A  Aff@\@H@\)@@@Q@R@p@R@G@@  @
@@ff@G@33@G@R@p@=q@@=q@@@@@޸R@
@33@(@ff@ᙚ@(@(@@(@
@@{@
=@H@
@ۅ@p@ۅ@
@=q@ᙚ@ff@޸R@@ᙚ@@@(@
@\@@
@H@@{@33A(A(A(AQAA A AGAA=qAAAffAQA
HA\)A
ffA
=qAQAA33A{AAffA=qA
A (AQA(AGA@HAAQAHAAHA=qA
{ARA\)A\)A{AzA
A (@@@@Ap@Q@
@@p@@z@@=q@{@Q@AGA   A   @(A\)AQA{@
=@33@
@@G@\@Q@\)@
@p@{@{@@@z@H@33@@@@G@HAGAA(AA\AffAQAA  A\)AAAzARA\)AzAAAQAARA (A QA QA!A!GA!pA"{A AQAAA%pA#\)AA{A%pA%pA33AAff@
=AffA z@@33AAA  A@@33@@R@@@\@@\)@Q@(@G@
@@@  @@A AH@33@@Q@@(@@\@ff@
@(@@=q@z@R@=q@@@@Q@@\@z@@p@@G@@@@  @@
@@AA	A{A  A{AAAA
=ApA{AHA\)AA
=A
A
GAAAA\)Ap@@z@z@H@\)@{@@(@H@H@@߮@G@\@=q@(@ff@@@ff@  @R@@ۅ@
=@{@{@
@ҏ\@(@G@  @@@ڏ\@߮@@׮@@H@G@
@љ@ҏ\@@@=q@
@33@ʏ\@@{@ʏ\@
@θR@p@@׮@=q@\@(@@
@\)A zAG@@\@p@A33@HA\)A
A
A
A33A(A A QARA\)AA{A  A\)AAA\)AQAAzA33AA\A
RAffA(A{A	@Az@(@RA   @@ffA
=@@@\@z@(@@=q@Q@\)@{@(@@
=@@z@\@{@H@(@Q@ff@@\)@33@
@z@{@@\@ۅ@@H@33@p@(@׮@(@љ@@z@H@H@\)@Q@@@@G@G@@AA A\)AA
HA33A
A
AAA\)A  A
\AAzAA
A\)AA
HA
pA=qA\)A\)AAAA{AGAffA{AHAA	p@A  @@@=q@
=@߮@޸R@=q@@{@p@@G@p@=q@  @G@p@ff@ڏ\@߮@G@@
@  @@=q@@G@أ@@љ@@p@(@p@(@@{@ָR@׮@@=q@ڏ\@33@ۅ@(@@G@@\@@@R@  @G@
@@{@@H@@@
=@  @Q@\)@@z@@{A   AHAGApAAzAzA
A	A	GA\)A
=AzA
\A	A  AARARA
=@
=@zA33A z@@=q@R@@(@\@\)@  @  @{@R@@޸R@@p@(@{@(@@أ@@@ڏ\@=q@
@=q@\)@\)@Q@@Q@޸R@(@@Q@z@׮@ff@33@@@33@
@  @
=@Q@ٙ@ڏ\@G@׮@(@{@(@
=@ָR@Ӆ@H@@{@  @@@
=@  @@G@G@@@
@
@{A AHA{A  A  A(AA\)A  A33A
=@\@AAR@A@z@@{@zA (@@@R@  @@@\@z@z@H@@G@ٙ@@@@33@@\)@z@أ@@Q@=q@(@G@{@@@@@  @H@Ӆ@@@ۅ@
@H@
=@@\)@G@  @ff@У@@@(@33@=q@
=@H@(@p@  @@
=@p@@@33@@
=A QA AAHA  AAzA
A33A	A
AA
=AGA
ApAAGAA
=ApA
=AAGAffAA
AA{A
{AzA
pA	A{A
@AG@RAGApAzA
A Q@  @Q@  @\)@@@@@{@@@@@H@=q@@@G@@
=@ᙚ@@@\)@ff@@߮@\)@
=@
=@p@z@(@z@@@z@޸R@(@p@p@@
@=q@=q@ڏ\@z@@\)@߮@H@@@
=@p@Q@
=@R@(@@A
AGAAAAA
AAAAAA
ARAzA A=qAApA
{A\)A\)AAHAGAHAQ@R@\@H@z@陚@@@陚@陚@R@ff@p@z@@\@ᙚ@@@@Q@߮@ᙚ@\@z@@@@@@33@\@@\@33@(@@\)@޸R@
@@ָR@33@@p@陚@@@z@p@R@
=@ff@@\@\@@ff@RAAAzA{AA
AA
RA	ARAA\)AA\AHARAA zA33A&\A
AA"{A33A
=ARARA
=A{A
AApA
=AGAA\)AAA
A
{AAA@pA Q@
=A zA@pA A @@A33AzAA@{@(@{@R@@z@@@  @z@
=@G@  @p@p@H@陚@Q@Ӆ@(@޸R@H@(@
=@p@@ָR@z@ָR@(@G@33@޸R@H@z@\@{@(@AA@=q@33AAA	pA@A@p@ffAHA	A33A  ARA=qAAp@A@@@
@@p@A (@G@
=@
=@G@
@z@陚@@(@@(@@@G@{@\@33@@@H@33@
@@\)@\)@=q@{@@@@{@(@ff@=q@@@p@
@@@33@@\)@p@z@p@ff@R@@\)@Q@陚@G@@@@
@@H@
=@
@
=@@=q@Q@Q@G@=q@p@@@
=@@p@@@33@33@HA (@pA ARAGAA@z@
AAAG@@ff@QA   @
=A AGA z@@G@@{@@
@H@=q@=q@@陚@Q@@@p@@p@z@z@=q@ᙚ@Q@޸R@޸R@\@@=q@\@@@@H@33@33@R@H@@@\)@@ff@@  @߮@@@33@p@z@@{@@\@ff@
=@p@\)@@Q@@@@@\)AffA{AA (A zA   A @@\@@p@{@(A @
=AAAAHA z@HAA (A AGApA A A  @@@=qAH@A@
=@@(@@@(@(@@p@{@ff@@p@z@@z@@@=q@\@\@陚@@陚@陚@@@=q@@33@
=@{@ۅ@@@\)@@z@ڏ\@Q@ٙ@ff@\@@G@33@H@ə@(@H@
@@\)@ڏ\@G@\@z@
@z@@z@@@\@{@{@z@33@@\)@p@G@z@  @@{@@@=q@{@G@
AHAAffA@  A QA@Q@\)@\)@@{@@@
@@R@@@p@@@  @
=@=q@(@@G@z@\@@=q@@\@33@
@@33@=q@
=@G@33@ڏ\@ۅ@ff@޸R@(@@z@
@  @G@ff@z@=q@H@\@R@p@@p@z@@{@
@{@  @@@
=@  @G@A A AA
A
{AA  A
AA  A{AA33A{AA  AA\)A{AzAAQA\AzA	A\)AAQAA(A=qAG@A   @@(@@p@R@(@z@@p@  @@\@
@\)@@33@Q@z@=q@@z@@z@\)A (@@\@{@H@@ff@\)@
@p@R@@@ᙚ@=q@@=q@H@޸R@@@߮@ff@z@@=q@G@ڏ\@R@=q@Q@z@
=A @H@(@@p@@Q@  @z@=q@@@zAffA
=@\)A{@(@@@
@p@  @@33@
@=q@\@@
=@@Q@ff@@=q@z@@@p@A
=A  @\)@@@R@{@@33@33@R@@@  @Q@@33@{@=q@@ڏ\@׮@G@أ@@@ڏ\@@G@@أ@  @{@
@Q@G@أ@z@(@ָR@\)@
=@H@
@׮@
@@@@\)@ᙚ@z@@(@(@{@@zApA\A
A\)AAA33A!A (AQA A'A&=qA'\)A(A'
A$zA#33A#A$  A#A"RA"HA$  A$AA33A#A!A\y A(@(@@@G@=q@R@@@
@{@@@R@@33@@\@@@H@@G@ff@@@R@ff@@@\@ff@
=@p@(@Q@
@R@p@@@@
=@\@Q@R@@
=@pA\)A
=@R@@\AA QA	A
A	AAA
=AAGAA=qARARAAGAARA
=AzA33ApA
pA  A\)A
RA33AQAA	p@zAA\)@\)@{@H@AA   AAAGAA QA=qA QA (@pA@R@(@\)@@@@@@@=q@
=@z@(@
@@@{@G@@\)@p@
=@@{@@p@陚@@ff@\@Q@ff@@{@Q@@
@p@@陚@@@Aff@{@@@z@A zAff@(@
=@AzAQ@@p@@@@@=qA AA\@ff@R@@@@H@@@@33@33@(@=q@(@陚@@@G@{@@\)@{@R@(@@@ff@
@@H@p@Q@\)@@@@
@  @@H@@=q@z@=q@@@z@  @Ӆ@Q@ڏ\@ٙ@׮@ҏ\@33@p@H@@@@@@@p@@
@
=@\@@=q@Q@ff@@ff@
@@\)@Q@@H@=q@ff@ᙚ@33@\@p@@@{@߮@Q@ᙚ@=q@=q@@H@@ᙚ@@\@33@
@H@\@\@=q@=q@@@߮@@߮@޸R@
=@@{@G@@H@33@(@(@ۅ@=q@G@@@ڏ\@أ@\)@  @
=@ۅ@ۅ@=q@  @G@أ@ff@  @\)@Q@ٙ@أ@أ@׮@@@\)@
=@{@\)@G@\)@G@\)@Q@أ@@p@ָR@׮@
=@أ@@@@p@Q@z@أ@Q@@G@G@=q@H@(@߮@Q@ff@  @  @\)@33@H@@p@{@޸R@߮@@R@R@@(@33@
@@p@  @p@\)@@
@@@
@@@\)@@p@@=q@H@@33@@߮@
=@߮@{@ff@p@@Q@H@Q@H@{@@@H@ٙ@33@@
@
@(@H@ٙ@@=q@
@
@
@@p@(@ڏ\@=q@=q@H@޸R@޸R@Q@@Q@@R@@p@@  @H@@
@ff@  @\)@@  @@  @Q@@@@  @  @H@
@
@p@
=@@@  @@@@  @Q@@@R@ff@z@@(@(@33y @(@@\@@@G@  @  @@33@@33@H@
@H@޸R@@@
=@ff@p@@@޸R@
=@Q@H@@@ᙚ@
@(@@@@{@@{@ۅ@ۅ@ٙ@أ@  @{@p@ᙚ@=q@
@H@H@G@Q@߮@߮@  @=q@\@z@(@(@  @@@@
@R@@=q@@@@@@陚@
=@@
=@@  @@G@=q@@@=q@@@陚@\)@\)@33@@陚@@@@z@H@陚@(@Q@@ff@
=@@޸R@\)@@@z@33@@@߮@\)@
=@z@@@33@@\)@  @=q@@@@z@(@33@
@@@@@  @=q@
@@޸R@Q@=q@{@p@\)@\)@  @  @@G@ᙚ@@@@
@(@(@z@H@@33@
@@@@G@ᙚ@R@\)@@\@R@  @G@@z@p@(@33@=q@
=@Q@p@33@=q@
@@(@@  @R@ff@  @@@陚@z@@G@@@33@@
=@陚@  @\)@@{@@33@H@=q@@G@
=@\)@޸R@@@p@أ@\)@p@@
=@@=q@(@@{@
=@\)@\)@p@=q@H@z@׮@ٙ@Q@=q@
@@
=@@Q@@  @z@陚@@@@@\@@
@@=q@(@\@H@@R@@G@@Q@@G@R@Q@
=@ff@(@@=q@H@@\@=q@Q@G@@@陚@G@G@@
=@@@@G@@ᙚ@33@{@G@\@G@Q@@33@{@
@@(@ff@33@ff@@33@{@陚@@R@ff@ff@@  @
=@@@@=q@33@=q@\)@{@(@{@\@\@@\)@33@R@R@
=@@R@G@G@Q@G@G@@{@
=@
@@Q@@
@ff@@Q@
=@@@=q@=q@
=@\)@Q@p@
@=q@陚@@\)@33@z@ff@@ff@(@@33@@G@33@ff@{@{@z@H@@@ff@z@Q@R@R@@@p@(@@G@(@@
=@=q@H@@@@  @
=@\)@@Q@G@ٙ@
@Q@Ӆ@@@@@@@{@@\@  @
@@Q@@
=@
=@Q@\)@R@
=@@@@ff@\)@  @@\@=q@
@
@(@z@@@@@(@H@{@H@33@@@  @@@@\)@p@p@G@H@z@ff@{@
@\@\)@@z@@
@AA A   @
@\)@ff@@@陚@G@@H@\@@  @@@@R@@\@@@@(@\@
@R@
@\)@\)@@\)@ٙ@@\)@@@@
@{@33@R@@@@@@{@ff@33@
=@@G@@@@@H@33@@R@
=@G@@@@R@ff@@{@\)@@\@ffAH@
@p@{@@z@  @@=q@@  @R@@
@@陚@{@  @H@@@p@H@\@G@{@
@@@ff@@H@
@H@  @p@33@陚@@@Q@@  @(@\@
=@@@@@\)@  @@
=@@
@(@(@@{@p@@@{@{@ff@ff@R@
@A @z@@R@p@A   Ap@z@ffA ApAffA\A(A(AA @Q@A A(A@Q@@=q@R@@@=q@=qA
@G@@Q@{@\)@Q@H@AHAQAAA  ARAAAHA{AA\@R@(@\)@@@
=@p@ff@ff@{@{@p@{@@(@
=@ff@(@p@@
=@=q@@@p@@@Q@{@@@R@@  @
=@R@@{@{@R@Q@Qy @@
@(@RA zAARAAAAffA
=A	GA
=qA	A	GA
=AAGA\)A{@(@33@{@z@@\@\@H@@@=q@z@{@@@33@\)@@{@G@z@@  @@@@p@p@ff@  @@{@G@  @ff@R@@(@p@z@H@H@
=@ff@=q@
@޸R@@ff@z@G@@@@\@p@ff@G@  @=q@
@33@p@@@\@33@
@@
=@  @@=q@A\A
AA\)A	AA\)A
HA
AAA
=AAQA{A\AA33A33A
=A A  A ApAff@@Q@33@33@@@
=@\@\@H@=q@陚@33@z@\)@@@@33@=q@@@  @@R@\A
=AA zAHA A (@@\)@R@33@R@Q@G@@\)@Q@G@@@@@
=@=q@@
=@Q@@  @@\)@  @@R@p@p@H@@@AGAHAffAAAzA @@
=A   A AA(A\)AA	GA	GA
pA
AGApA	A
A33A
HA
RA	A	AHAAAAQ@33@@RA\A\@H@
A (Ap@
=@HA A A   @ff@
=@\)@H@@=q@@R@@\)@@R@@@ff@ff@@H@{@@(@@@\)@{@z@ڏ\@Q@\@@@{@{@(@@
=@@@33@@  @@H@@@zA (A AAAApAAGAAGAAAA QAAffA AAzA=qA(AApAffAA\ARA=q@@@(@
@@=q@H@R@@@\@@(@p@{@  @G@G@@@33@{@{@
@@(@@
@@{@
=@{@R@p@z@@(@33@H@
@33@(@=q@ۅ@ڏ\@ڏ\@ٙ@p@H@ҏ\@ff@{@@=q@ff@@@\)@\@
@33@@Q@
@@  @\@p@GA\A33A(A{A\)AA{A
AA
=A  A	AA(AQA
A
AAffA
pA(A'
A!A{ARAAAAA(AHA
\A\)A
A	A
HA
=qAA
\AAA A  AAp@@@@@(@(@@@@\)Aff@HA   @@(@G@z@H@HA
@AGAA(@@
=@
=@{@\@H@H@@@@@@pA A QA=qA @@@
@A\ARA=qA  A	pApA
=@@@@  AGAz@{@pA@zA  @@G@z@(@Q@=q@ffAG@@  @  @z@ff@p@ff@ff@@=q@(@p@R@@@@=q@@@\)AGA=qAHA@(@z@@@@33@z@(@@@H@
@33@@
=@@  @\)@
=@ff@\)@R@\)@@\)@ff@@@@z@H@@33@z@@ff@@G@Q@R@(@
=@@\)@
@H@陚@
@@G@G@\@@@(AAA QA   A @@33@\@@G@=q@@p@zA QA@@H@{@G@z@@z@{@p@R@@@G@z@G@H@
@陚@@
@(@=q@@@p@{@@{@R@Q@{@Q@@(@(@{@
=@33@p@@@  @=q@ff@@  @@@Q@\)@
@@陚@H@\@@33@33@z@33@@p@@{@33@@@@33@@
@=q@p@@  @Q@RA (@(A zA (AAffA33A33@{A  AA ARAA\A z@33@z@RA z@R@\@@R@@z@H@\)@\)@@\@@@@Q@=q@޸R@=q@z@z@G@@@@
@{@ff@Q@ff@@A
@\)@@@@@{@p@33@R@=q@@{@@(@@@{@@ff@=q@޸R@ۅ@@(@ff@=q@{@{@@33@\@H@
@(@G@G@@z@@@R@33@(@Q@ffApAA
A  AAA
HA
AGAHA=q@pA{@ff@
=@\)@
=@Q@z@\@p@{@=q@
=@\)@@@Q@G@@@
@33@@\@陚@(@G@@
@ff@ff@@  @@  @ff@H@
=@(@\)@@{@@p@  @@(@\)@\)@{@@(@@33@H@H@  @ff@ff@@(@  @
=@\@R@p@@z@\@p@\)@{@Q@@H@@\@ff@@@H@z@{@R@
=A (@\)@\)@
=@ffA (A z@p@H@@R@z@z@H@@ff@@@@
@{@ff@@R@@  @\)@\)@\@\)@z@@
=@@@ff@ff@(@Q@R@@
@@\@@@@G@陚@{@@@@ff@H@@(@z@@陚@@@\)@@@@@@@ff@z@z@@(@\@@
=@  @@A{@ffAA(A33A	GA
{A
\AApAAffA
HA
{AQA33A(A\AAffA33ApAHA\)A
{A
ffA
ApA	AH@@
=@\)@R@ff@
A
@H@=q@ff@Q@@GA{@ff@@z@R@p@{@z@33@=q@Q@@@@{@\@ff@@H@
@z@@@p@@Q@@z@߮@{@
=@{@ff@{@߮@ff@@@
=@
=@z@\@ᙚ@  @@Q@@陚@\@33@(@R@@@陚@@@(A (AA\ARA(AAARA\AQA\A
HA=qA
=AA
AQA
=A\AQA
ffA{A(A A @@A
=A\AzA z@GA(ARA@
@
@\@\)@@@
=@@\)@@p@  @@
@33@@33@
=@@@=q@陚@陚@@
@G@@ff@@@@{@@ָR@@׮@@  @@Q@
@=q@33@@陚@(@ff@
@{@@@@G@Q@ᙚ@=q@@Q@@
=@@ff@
=@@@33@@@@G@@
@R@@zA A A\A  AA33AAffAAA\A
=A
=A@\@@@
=@
=@@@H@ff@@(@
=@z@G@@(@
@@\)@  @Q@
=@޸R@޸R@ff@ff@@޸R@ff@
=@\)@  @G@{@@@H@ڏ\@{@(@ٙ@ڏ\@ָR@  @׮@Q@ָR@׮@
=@\)@ff@Q@@ٙAR@@@\)@H@  @߮@Q@\)@Q@=q@G@@(@@ᙚ@@@\@\)@\)@
@Q@R@@33@H@33@z@@@@z@\)@@(@@@33@@@  @@R@ff@\)@@
=@z@{@@=q@陚@R@ff@(@33@@
@(@@
@@{@\)@޸R@\)@@Q@߮@Q@  @߮@@=q@@33@@@\)@ᙚ@Q@=q@G@  @Q@@\)@޸R@
=@\)@߮@  @  @  @@H@@=q@@@\@p@ff@Q@ff@@@=q@@@ff@
=@Q@@@33@
@z@@ff@{@{@{@
=@ff@{@ff@{@@@陚@@H@G@@@@p@@G@@ۅ@@@=q@@@Q@{@
=@
@z@޸R@G@ۅ@=q@@@@33@׮@ָR@
=@أ@Q@Q@=q@ڏ\@أ@Q@߮@  @H@@ۅ@أ@ָR@{@33@ָR@ff@@Ӆ@@ff@z@@@{@@=q@@  @=q@=q@@@{@޸R@  @33@@ۅ@ᙚ@(@(@z@@@
@@(@
=@A QA@@
@@@@\)@@(@\)@(@GA z@\AAAA33A (@G@@33@H@(@H@
@33@(@ffA33A QA QA@@A @@@ff@@
=@33@@
@ᙚ@  @z@{@ff@У@  @z@H@@\)@H@@{@Q@ƸR@\)@ȣ@@@@(@\)@У@H@\)@@
@@\)@  @H@@33@ڏ\@@{@{@@{@Q@{@p@
AA{AA
AAAzA	pAHA{@@Q@@Q@33@
@H@(@@  @33@R@@  @@R@  @@\)@
@  @@\@@@@
=@@@@@\@(@\)@z@(@@\)@33@@=q@z@R@@
=@  @\)@\)@Q@@Q@@@@H@G@H@=q@Ӆ@@H@Ӆ@
@z@޸R@@@{@  @@@ff@@
=@@@{@A QA{AA
=qAA
AAAA\)A z@
=@p@H@@33@
@@z@z@G@Q@@@
=@Q@@\@@@{@=q@z@\@\@=q@H@@@z@\)@
@@Q@Q@  @{@{@ff@=q@Q@ڏ\@׮@Q@ᙚ@ۅ@
=@R@@G@  @(@z@33@\@@陚@\@@@G@H@=q@@@=q@33@@=q@z@33@(@z@@@@R@  @
=@陚@=q@{@@G@陚@@@H@(@\@
@@@R@@\)@\)@@
@33@33@G@=q@33@33@33@\@\@\@G@\)@  @G@@ff@H@33@@ff@@=q@\@
=@\@p@z@
@ff@@G@߮@߮@@Q@@z@(@\)@@p@@ff@(@@=q@p@@\)@@@@H@@
=@  @{@{@ۅ@=q@׮@
@Q@{@=q@@
=@R@p@
@G@@@陚@=q@\@@\@G@H@{@\@@ff@G@
=@(@@ff@@G@@G@@@@H@@(@@@z@
@z@
@G@@\)@@Q@ff@(@=q@@@ff@@ᙚ@ᙚ@H@@(@A QAzA  A\)A\@@
=AAGAAHApA\A
A\)A@p@
=@\)A QAA z@@@@H@@ָR@(@Ϯ@ۅ@
@\)@@\)@G@@@
=@@\@ᙚ@@p@@@\)@ff@@  @@33@(@
@z@z@ff@
=@Q@@=q@@\@@=q@\@H@H@@
@@(@@(@@Q@@Q@@@G@@p@@@@@\)@@@@p@@Q@33@@=q@@陚@\@=q@H@陚@陚@@p@
@
=@
@H@ff@  @@@G@z@@{@Q@\)@ff@  @陚@  @@H@@H@z@@33@p@(@H@@(@
@R@=q@@@@\@R@@=q@z@p@@\)@R@@@(@@@@\)@GA Q@(@\)@33@H@33@Q@\)@@@
=@@G@@=q@@H@  @@QAGA@@33@@\)@@R@\)Ap@@@(@=q@H@R@@@@p@@@  A z@\@\@߮@{@ff@ҏ\@G@@أ@
=@ff@ᙚ@p@(@@G@޸R@
=@  @
@H@z@@
@33@G@У@
@G@@G@33@\)@@@G@ff@@@
=@H@
=@  @@Q@ff@33@@=q@ٙ@{@\)@@33@G@G@
@@
=@R@߮@߮@(@\)@33@ָR@Q@H@G@ۅ@߮@G@  @G@ٙ@=q@(@@ٙ@ٙ@G@أ@33@ۅ@\)@33@ڏ\@33@@Q@߮@@@p@@@z@@@(@
@z@z@@\)@p@H@У@Ϯ@ȣ@(@33@33@׮@G@(@z@@@G@G@H@z@\)@p@
=@G@@׮@أ@ff@أ@ָR@\)@@@Q@ff@ff@H@\)@߮@=q@z@ff@{y @p@\)@z@Q@ff@Q@@G@Q@@G@G@p@p@@p@
=@R@@R@
=@\)@@33@H@H@33@=q@
=@\)@{@  @33@@@\@@R@z@\@@@  @ٙ@ڏ\@  @ڏ\@أ@ۅ@@@޸R@@
=@ָR@ff@G@׮@{@Q@ڏ\@@=q@@z@=q@=q@߮@p@
@(@@ᙚ@@G@H@\)@(@@@Q@  @@@
=@@HA=qAAQA
\A\A\A{ARARAA
=@H@@  AAARAp@R@A
AG@@
=@@R@=q@\@@p@@33@@@R@@\)@p@p@{@
@
@33@33@=q@
@أ@ٙ@(@p@߮@
=@߮@
@ۅ@ٙ@أ@{@\)@@@G@\)@ڏ\@ڏ\@  @Q@@H@{@Q@H@@R@\@z@
=@p@@@
@ڏ\@@G@Q@p@ff@ff@أ@(@33@@@ۅ@
=@@ᙚ@33@@R@Q@G@\@(@33@@@G@G@G@@@G@@G@  @@H@\@@@߮@@@@ᙚ@=q@
@\@(@(@{@Q@ᙚ@
=@\)@@{@θR@(@@Q@
@@33@@
=@@R@(@@{@׮@Q@{@p@
@Ӆ@=q@ff@p@ҏ\@
@ָR@
=@@θR@@ff@@@Q@@θR@љ@(@@z@@=q@ff@33@  @ff@\@
=@@߮@޸R@ᙚ@ۅ@@
@p@R@R@\)@G@33@
@{@
@R@@@@@{@\)@@p@@@@p@@޸R@@\)@@߮@(@ڏ\@\)@@  @@  @Q@ᙚ@33@R@p@ff@R@@@  @Q@@
=@(@
@
@=q@{@\@\@z@p@33@@z@@(@@  @ᙚ@Q@ᙚ@޸R@{@߮@Q@߮@޸R@33@33@z@@33@z@@z@\@陚@33@@p@@@@\@33@  @H@=q@@p@
=@  @@=q@@=q@H@@\)@Q@{@p@@@Q@pAR@@33@@@@@@33@z@@z@z@أ@33@ۅ@@@H@ᙚ@33@ff@H@
@z@
@
@G@H@33@@@Q@
=@@Q@=q@@Q@R@@(@@@@Q@@H@@ff@@@ᙚ@@@\@33@@=q@@@=q@33@
@ff@@
@@@@@
@@@@@@(@(@@@  @R@
=@ff@R@\)@  @@\)@
@p@{@{@{@ff@{@
@=q@33@
@Q@\@\@H@@ᙚ@\)@@33@z@@@
=@R@@@@=q@\@\@@\)@޸R@޸R@
=@@
=@Q@@@R@z@@
=@\)@\)@
=@R@R@\)@
=@ff@@@G@33@@(@z@ۅ@(@ᙚ@  @33@Q@R@\)@@@@\)@Q@G@=q@=q@=q@{@\)@Q@ff@G@\)@@=q@H@@
=A z@p@ff@@(@(A Q@
@33@@z@{@(@R@@@ff@
=@@@@ff@@@H@@@H@@@@z@@@@@(@\@H@\@Q@@R@
@(@@أ@G@p@@@ff@33@33@33@@أ@
@@׮@\)@=q@{@H@@@@=q@\)@@@
@=q@H@(@@@@
@@@=qA zARA=qAAARAzAAAAA
A	A
A33ARA\)AA=q@(@@=q@R@@ڏ\@=q@=q@߮@Q@@ᙚ@@@G@@@
=@@  @@z@G@=q@@\)@陚@陚@\@@z@ff@
@@@  @=q@
@(@H@@\@Q@@G@
@@\)@p@@ָR@@33@(@(@
@H@@{@
=@ff@@
@@H@z@@A AffAA=q@A  AAA	A(A
GA
AAQAA\AA\)A
=A=qA33A(A ARAQA
=qA
ffA	A
\A
\A
=AA=qA(AAA{AAQ@p@  @@R@{@@\@p@@@@p@R@\@@@
@\)@@R@ff@@@H@Q@\)A\@H@Q@@@
@@@R@ff@R@@
@p@@
@ᙚ@ff@@
=@ۅ@p@Q@ۅ@p@@=q@@@R@@@
@\)@@\)AAHA
AApA
=AA
{A
AA(AAA
RAAA
A(AAffA\AA\A
pA	A
HAzA
{A	pA\AzAGA33AAAAffAAAAA33AAAH@@@=q@
@@p@
@G@G@@(@33@ff@@
@@(@R@
=@
@p@ff@@ff@
=@Q@ᙚ@{@@G@H@
@33@Q@p@@H@  @=q@{@Å@Q@أ@Q@H@Q@G@@Q@@p@@@@@zA AAARA
=AAA
{A
RAA@HAAG@H@{@Q@Q@R@
@ff@=q@ff@
=@(@\)@
@
=@
=@(@@{@Q@ff@@\@=q@
=@H@ۅ@z@Ӆ@
=@
@׮@ff@У@љ@
=@H@@{@G@
@z@33@  @˅@p@θR@@G@θR@p@H@{@\)@(@33@Q@\)@ҏ\@
=@Ϯ@@ff@p@\)@@H@Q@˅@33@33@33@z@  @
@@أ@ٙ@z@
@=q@@ᙚ@@=q@@  @\)@߮@
=@߮@Q@@߮@߮@@@@
=@@(@=q@z@\)@z@{@@p@@@33@@ff@@ٙ@@=q@ff@Q@{@Q@޸R@\)@33@Q@׮@p@{@p@p@=q@(@@{@z@p@{@׮@33@љ@@Å@G@@@@  @=q@\)@G@z@@=q@@=q@Ǯ@ȣ@
=@@\)@{@@ʏ\@33@У@G@Q@=q@ٙ@\)@@@أ@߮@@(@@Q@@H@
=@@Q@R@
=@@@
=@ff@@33@@H@H@\@ᙚ@߮@@H@H@H@=q@Q@
=@ff@=q@@ff@p@@(@
@z@z@G@ۅ@p@p@׮@ٙ@@
=@ff@θR@z@{@@
=@p@  @ȣ@˅@H@ȣ@Q@p@@@ʏ\@
@@Ϯ@H@(@
@{@
=@\)@ָR@\)@  @ff@Q@{@޸R@\)@  @(A@\)@@33@@=q@ff@{@{@\)@R@
=@R@@陚@z@p@陚@R@
=@@@p@@@Q@@陚@\)@Q@@@@p@@=q@@33@@Q@@@@z@R@{@33@
@\@
@H@@(@@p@33@  @
=@\)@ff@@@=q@
=@ڏ\@ڏ\@ff@p@H@=q@@p@@@H@  @{@{@H@Q@ᙚ@H@@@z@p@(@G@@=q@@Q@\@@Q@R@
=@@Q@@\)@{@@
@  @@
@{@@@@Q@  @\)@  @(@H@G@
=@@{@33@@ۅ@
=@H@z@
@ff@ff@{@{@@@@\)@\)@G@(@@@ff@@\@\@Q@p@@\)@H@@=q@
@@@H@@R@Q@  @  @Q@Q@p@=q@@
@@p@@@
=@(@@33@H@(@@p@\)@  @G@  @@(@@  @G@@R@  @@R@G@H@@R@  @33@\@\@@@\)@
=@Q@@Q@HA zAAAAA\AffA
=A\)A\)ARA
=A
=A  A{A A @ffAG@p@{@\@\@=q@@(@R@\)@
=@\)@R@
@\@33@\@@ff@G@\@@Q@Q@@
=@@(@@陚@ָR@ҏ\@@ᙚ@@@@ff@@{@z@  @@@(@
@p@Q@H@\)@p@@@
@@\)@R@
=@ff@ff@
=@=q@@G@@Q@\)@@G@@@@H@
@{@{@p@߮@Q@@
@G@
=A @(@z@=q@
=@H@{@=q@\)@Q@\@ᙚ@
=@(@{@@ᙚ@߮@\@{@R@@G@(@@=q@\)@{@R@ff@@(@@
@@
@33@=q@(@@ff@p@@@@@(@ƸR@H@  @{@Ӆ@H@\)@G@z@@\)@Q@G@@@H@H@R@@@@@@z@@QAG@ffAzAzA
=AffA(@
=A33AA (A z@(@p@
=@R@@@@p@p@\)@ff@@=q@p@@@
=AAAGAQAA{A\)A
HA
pA(AQAA
AAzAAGA  A
=AA@z@\@
=@=q@R@p@(@Q@ff@(@(AAA	pA  AAAARA @
AQAA   @
@@G@=q@{@  @@@@@@@=q@\)@@@@  @Q@\)@R@\)@@@
@@@(@G@@أ@G@=q@=q@p@  @H@G@=q@33@z@@{@\)@@@z@p@R@\)A z@
=@{A @
=@A{AA@
@ָR@Q@
@z@@@@
=@ᙚ@G@@p@\)@
=@@ff@\@R@Q@@\)@\)@
=@@@@p@
=@@@G@@@z@H@(@@@33@(@@@@R@@
=@@H@\@@H@@
=@(@z@@p@  @@p@@  @@(@33@ۅ@{@@H@z@\)@@ۅ@Q@@@{@@@{@H@@Q@R@@33@Q@\@ƸR@\@(@@{@Q@33@@@H@\)@
@
=@ᙚ@33@H@{@(@@@@@@=q@33@
@\@@A ApA33AAzA
=AffAAGApAAApA{A\A33A33AAGA=qAA33A\)A=q@{@\@@H@p@(@@z@\)@@33@=q@ff@Q@z@H@@(@@z@
=@
@@ff@=q@G@G@ff@Q@\)@RA33AAzA33AHA	A
RA
=AzAAAAA
AAAA
=A
Aff@\)AzAQA
=AAAAffA @33@  @{@\)@Q@\@@ff@p@@@\)@@@@@z@  @@
@@H@@@p@33@ff@G@
=@ff@@@(@@  @z@陚@ڏ\@H@{@@߮@
=@ff@(@\)@\@@ff@@R@\)@@@H@=q@@=q@(@(@33@@@ff@߮@@@G@Q@߮@\@p@G@Q@H@@p@{@R@@Q@\@@R@
@p@ȣ@@
@  @@(@@{@@(@@p@z@ff@@Q@@G@@@H@R@
@  @@{@\@@@{@@\@@  @@@
@R@@=q@p@@@ٙ@{@陚@G@  @@33@H@(@@@\@@@  @@33@ff@ff@  @=q@z@\)@@(@@@{@R@ff@@z@
@\@\@H@G@@z@=q@
@@R@@  @@R@
@@@G@  @ff@p@(@H@ٙ@G@H@@p@ڏ\@أ@  @\)@(@H@@@{@H@33@@\)@Q@33@ᙚ@@ff@׮@@
@@=q@(@ᙚ@陚@=q@H@{@陚@@(@
@@p@@\@
@A
@{@  @G@H@33@=q@\@@=q@G@@@z@(@33@H@p@  @ff@p@
=@\)@
=@@R@R@{@R@z@
@33@G@@z@@{@@@
@@(@@ff@@@z@z@(@\@=q@ᙚ@@ۅ@H@p@Q@  @@G@@߮@Q@@G@33@
@z@@(@@G@\)@=q@陚@H@z@\@@@\@z@  @@=q@33@33@(@ff@ff@
=@Q@@=q@(@@p@H@\@  @\)@陚@陚@H@@@@@@=q>@@(@
=@@ᙚ@(@p@=q@@p@H@@  @ff@  @p@@p@Q@  @=q@Ӆ@\@ڏ\@@H@  @z@(@\@  @R@H@
@ff@@@  @@@@@{@ff@H@@R@
=@@p@  @33@@  @(@{@G@@z@@@
=@@@
=@\@ᙚ@@
=@Q@ff@ff@p@@z@@{@
=@ff@@Q@p@p@陚@@@@@  @@@ffAGA\)AHA
=@R@(AA33AA\@Q@33@
=@=q@
@{@@@p@@@=q@\@zA=qAGA\)A A@=q@@@RA QAAG@{@
=@{@ff@@=q@
@@G@=q@@@Q@@H@@\)@\)@  @ff@R@z@@=q@@G@G@=q@H@ff@@  @\)@33@(@33@@ff@ff@@ff@\)@z@G@
@p@G@ۅ@33@ٙ@33@  @
=@{@ff@@@=q@H@ff@  @\@ff@@@(@A AffAA
ffAA{AAA\A Q@@@@p@33@  @H@
@
=@z@=q@{@z@z@{@@
=@R@@A=qAQAQAAA!BșB\)BBB.BQB)B
=BkB#B̞BBBBBBBW
BuB3BB\)B\)B)BǮBBB
BBC aHC ǮCC)CCCxRCCCYCqBGBfB#BGBzBB\B  BzB.BB܏\BܮBaHBW
BHBB߽qBߨBQBBGB8RB
=B#B
=BaHBBfBaHBBBGBQB
BڨBݙB\B\BҽqBШB
=BpB(BB؅B=qB
BfBB\BfB\BׅBpBǮBB޳3B٣BBB(BLBה{BffB(BW
BBBRB\)BuB(B33BBaHBkBpB3BzB\B
B{B=qBqBfBBC xRC ޸CC3CC0CC	@ C+BuB{BuCxRCCkC\BB BBBuBBuBBޅBB)BǮBڅBB݀ Bה{B8RBfBיBB׸RBBBBڅBBaHBڸRBHBܙBB۸RBfBpB{BBBfBBؔ{B
=BBaHBݨBffB
=BuB\B#B8RBHBB=qB.BffB=BBaHB
BqB.BfBHBB=BC5C^CBC )C \C\)C 
C C CcC
=CBC\)CCqCBC3CC CCCCCC.CCLCC BB\BkBBffBBffBpBC\BaHB\B8RB B
B#BBB
=BHBBBBkBkB\B.B=qB(BǮB{B
BB{BB=qBB\B=B B  BRB(B{BͮBBBڮBǮBqB#B
=BzBQB
BaHBuBB=BkBBBGBB.BuB8RB  BǮC C 3C)CǮC)C CC8RC	C
.C
cC
fCaHC
CCfCQC{CC8RCC  C CW
C
C
33C
qCGCCC)C)CfC!HCB(CRCGCQCCLB)BaHBB=B\)BBLBW
BzBRB#BGBѨBBBB.B(BB B8RB#BW
B8RBBBBB BꞸB\BBpB B  BBffBBQB=qB=qB#B
BBB{BQBB뙚BW
B B晚B  BB BzBGB  B#CcC C YC BBGC HCC C=C
B{BBBW
BBaHBBW
B{BBW
B(B  BBffBBBuB\BBǮBW
BBffBB۸RBGBLBBkBB.BΊ=BkBBBBaHBBkBȮBpBzBB̊=B͏\BzBBB\BB\)BʽqB{B
=Bɀ B)BȅBHB
BBBBЊ=BLBBBBBW
B㙚B33Bӊ=BB
BBfBBuBkBqBffBB BkB B  B{B{BRBuBǮB  BGBffBBffBpBffBHBLBBBB#BBBB{BffBB{B.B  B8RBaHB  BBuB{B(BaHBB\)B33BBBB8RBнqB.B#BѮB׳3B)BzB
BBճ3B=qBQBнqBpB\)B.B.BѣBaHBfB8RBπ BLB{BfBѣB͊=BHBπ B8RB{BԮBؙB\)Bڔ{BHBޙBB{BўBBpBaHB B{BW
BB\)BffBqBkB B#BBC @ B8RB#BLB8RC {C8RC)CCCGCHB.BBBGBQBǮBQBHB{BۣBGB#B(B33BخBBBBיB
=BBظRBffBBLB=BuBpBޙBzB=qBB  B(B#BBB.B{BBߔ{B
=BBBBpBBڣB֔{BGB.BffBۮBzB׊=B\BӣBB
=B.Bޔ{B(Bݳ3B
=BBBݮBڅBaHBڨB{B#BB\BRB)BBB  BBBBfB)BffB=BqBB{BuB=qB
=B
=BBQBBRBB\BfBkBHB=qB\BzBuBfB3BBBRBqBGB{B垸BBB=qB#Bճ3B
=B
=BОBъ=B
BGBˏ\BBˮBșBHBW
BB̞BBBB
=B.B{B.Bʳ3B=qBffB
=B
=BBW
BuBpBߊ=BݽqB.BB33BBB׀ BuB\B.B\)B#B޳3B)BأBՏ\BB(B{BܣG5!BBBBQBޙB\Bߔ{BRB33BBBQB(B#B.BBqBpBHB8RB
B)BB(BLBRBBuB  BB  BBkBQB{BB#B8RB\B\)B)BB
=BBLB3BQBB  B)BaHBBzBB)BBBBڣB
BpB
BӮBٳ3BGB=qBGB{B33BԀ B=qBӀ B33BB
B
=BBBӸRBՅBBpBkBuBڔ{BBB
B{BBǮBfBQBzBfBܳ3BިBݞBޏ\Bݔ{BBkBBBzB8RB
=BBkBkBzB33B۳3BB޸RB.B\)BB\)Bۊ=BB)B.BBߣB3BaHBBB8RBܙB܀ BaHB#BaHB\)BBֳ3BיBBHBѣB  BfBzBzBBBB33B(B33BHBǮBԏ\BϸRBBǮBffBͨBг3B=qBЮBǮBBBaHBffBҊ=BuB{BŞB
=B(BkBBӳ3BB=qBBzBB{B̀ BBB
=B
=BQBȮBkBGBBW
BB{BuB(B.B{B\)BЊ=BЊ=BkBƞB#BƏ\BuBמB  Bճ3BaHB(BӀ BBkBхBpB.BLBkB.B\B8RBŀ BBBBBkBBLBB33BB\BřBBBŮB8RB8RB{BBBBaHBB
B3B=qBzBB\BBB33BB\B\B33BB3BBBBBBLBB3BBLB{BBBzBBBBBHBpB  B(BLBW
B\BpB  BffBBqB)B=BQBǮBBBqBBLBîBB\BB(y BB=qBɽqBB(BˣBBaHB\)B˔{BȮB{BͨBLBB8RBʨBaHBGBBQBB8RBLB£BBuB\BffB33BBB\)BB=qB(BpB#BBBǮBBB(B=qBBBBGBLB)BBqB)B  BB33BpBBpBBB BBBBBkBW
BaHB#BBB\BBaHBƸRBȽqBȮBBBǊ=BɅB  BaHBBBHBkBBB̔{B˽qBBυBΣBuB33BB8RB=qBuB=qB\)B8RBۊ=BaHBۊ=Bۏ\BQBBW
B{BffBHBpBԸRBzB
BңBπ BBͽqB)B.BΙBaHBǮBϸRBγ3BBkB.BW
B̳3BpBBuB#B#B8RB8RBˮB33BQBB{B͞BB
B
B\)BBBBLB)B=qB{BQBW
BfB\B.B{B̊=BpB(BuBfBѣB=qBffBW
B8RBҽqB.BӸRBHBW
BոRB֞BW
BօBBBpBpB{BuB\)B׮BHB{BB؀ B#BBB٨BW
B\)B{BpB  Bُ\BLBaHB{BBQBBBW
BQB\B۽qBܸRB)BuB8RB33BHBzB۽qBBB
B  BՙBLBBBЊ=BaHBzBBԣBW
B\)Bي=B)BGBB#BffB33BΞB)BͮB  BfB=qBBəBɸRB  BB˳3B#B̏\B8RBΨBͮB\Bπ BΞBθRBB  B
=BzBBәBpBaHB8RB(BԳ3BԸRBսqB\B֔{BHBaHBpBBfBݨBBߣB\BHBBQBpB{BB3BBB
BB=qB=B  BLBkB33BB
=BBBٞBٮBBBҸRBB
=Bـ BHBǮBBB٣BW
B#BGBܸRBGBڨBҀ BB8RBҏ\Bҳ3BQBzBBBBѳ3BBңBҳ3BBQB)B{BBBkBѸRBϮBBBBB  BBҸRBҨBBՅBǮBB̨BB=qBѳ3BBє{BBfBB=qBffBB)BzBݏ\B
B{BzBBQB
BRB3B  BuBpB\BqBLB33B=BzB{BkB=BHB.BRBaHBBRBBBB=qBBBڔ{BB  BܽqB  BffBaHBBkBܳ3BBffB
B֙BǮBBfB
=B֔{B\BLB֏\BW
Bъ=BQB)BW
BBӏ\Bϊ=BϙBB8RB͞BLB.BHBfBGB{Bϔ{BLBхBBuBԀ BBڮBaHB{BBمB(B(B)BzBHBfB8RB33B.Bҏ\B֔{B؏\B䙚B=BGB.BB  BpBfB\)BB)B#BBCHCCfC\C  CzBW
C!HC3BffB\B{C BB#BB33BHBBB8RB螸B33B#B\BB8RBLBHBBffBfBkBBڸRBڏ\BB=qBkBBBBGB33BףB=qBffBB=qBՔ{BzBBBըBW
BׅB׽qBׅBBpBffBأBǮBfBGBBB׏\B֊=BHBQB\)BfBΊ=BǮBBBҞB.BW
BuB
=BzBǮBճ3BBBBaHBB\)B=qB33BꞸB=qBB\BB=BRBfBB=qB{B
B(BLBBBB=qBB33B
B  B=qBB=BRB\BHB{B\)B=qBڔ{B)BRBB)BaHB)BzBGB܀ BBffBBzBОBǮBffBBBuBzBُ\Bԏ\BaHBLBҞB#BQBGB  BB
B8RBBQBǮBӣBaHBBffBУBBBBffBڏ\BBB׏\BQB#B\BfBB\)B.BuB=BBBqB  BqC J=C0BBBB{C BǮBBBBB=BLCqB33B\B
=BLBffB33BpBGBLBBB枸BW
BqB{BB(BqB8RBBaHBLBfBB\)BaHBBGB8RB
B33BBLB陚BBB8RBLB왚B
BffBaHB{BGB
=BBqBǮB߀ BLB͙BѨBGB
B)B˙BGBϣBzBϮB
=BuBB\)B8RB(B֨BBQB܏\B#BޣBfBB.BGB33BB\BBffBB\B.BQB
=BBRBaHBBB{B{BBqB=C^C B  B=qBB
=B#BB)B{B
BBB\BRBkBBBB䞸B B(B33BffBaHBǮBޔ{B=BB8RB8RBBǮBRBuB\B߽qB#BuBBBzBݸRBB#BBؽqBգB؏\Bي=BBpBB{BzB=qB݊=BǮB{BBBBBBݽqBB8RB  B#BBBfBW
BGBaHBB)BB
=BۣBBBLBBBaHBB\)B
B8RB\B虚BBڞBBBB=B{BBB
=BLBBpBBW
Bޔ{Bُ\BخBBB׽qBB#B
B)BǮBBBٽqBHB(BB\)BBqBRBzBBBBQBW
BBBuBۊ=B33BBBQBߙBkB)B߸RBBBHBBڣB8RBBB8RBGBܞB܊=BaHB\BW
BpB׊=BўBB
BңB33BB.B
=BBHB(BffB  BB\B  BBBaHBuBQBGBW
B(BaHB޸RB(BW
BB֔{B\)BܣBB
=BB  BٸRBֽqBӨB\Bي=BBffBBkBBBLBB\BzB\B
=B)B=qBBffB{BԙB  BΏ\BW
B̨B\B{BBBɊ=BW
BBĔ{BBBє{BӽqB
BˣBó3BǮB\BBBBBǮB BkB  BĊ=BŞB
=BfBaHB{BBBfB{B#B
=BǮB3BQB(BkB  BBB=qB\BBýqB8RB)B\)B(BĔ{B=qB\BaHB\BffB
BLBBBB˅BB
BД{B
BԊ=B
B#BBB\)B)B\BBBBzBB
B8RBB#B\)BfBuBȞBBŽqBQBB\)B  B BBBkB33BBuB.B=BaHBBB)BBHBGB
BzBBBHBaHBB B{B\)B3B BzB3BW
B3BBBQBGB=qB33BBBBBBB  ḄBˏ\B\)BpBQB=qBѽqBQBaHBB  B B#BB B=C 3CC=CB8RBffBHBBzB33BמB۳3BמBԳ3BB=qBBӅB(B#BؽqBLBHBBݽqBרBBBBBӀ BЮBfBfBșBLB
=Bɳ3BBQB\BB33BQB\)BuB
Bϔ{B
=Bր B3BzB=qB癚BkBQBfBB\)BBǮB
=B.B33B33B)BٸRB۔{BBBaHB=BRBB8RBBB\BBB랸BBC RB=CGB)BǮBpCCECO\C
C0CB#BC RC{C ǮBzC O\BBW
BpBB
=BBB C ޸BBW
C{CffCW
CBQBC B{C CHCGCCO\CCGB
C=B{C&fC (B=qB33BaHB{BQBBB(B BBGB{BBBB\BB=qB{BRBfBzB\BpBBB BB#B33B=B BHB  BB晚BBW
B(B)B=qB  B.BQBڳ3B
=B#B{Bؔ{BW
B33BffBBBBB)B=qBׅB٣BۨB۸RBBuB\BؙBpBuBٙB.B׮BظRBuB{BۨB=qBHB
BיBٔ{B  BBBuBW
BBBBُ\B.BHBB
=BzBBӽqBǮBB.BB
=BW
BBѳ3BBϳ3BΨB{BQBνqB8RBνqBaHBͣBB33BB̞B#B̏\BGBͮB=qBzB̮BQB(BQB̙BB̳3B  B̙BBBGBB.BҽqBB\)B8RBLBֽqBՏ\B#BuBzB۔{B\B\)BBB8RBB瞸BffBzBLBuB)BB\)BGBBBB3B#BB
=BB
=BBW
B=BB{BBBGB=qBW
BW
BB(B33B
BBffBٮB=qB(B)BǮBaHB
=BٮBHB  BRBffBBߙBzBǮBBͨBϊ=BӞBBB˞B)BBGBpBpB͸RB{BBBъ=BBaHB.B
B=qB
=B=qBϙBԣBӏ\BBB(BB(B{BޣBHBݽqBݨBHBBBRBW
BBuB33BpBW
BB)B\)BBRBBBBBB{BW
B\BqB
=BkBHBW
B.BBffBǮBffB)B  B33BBٮB#BBBfBkBLBԨBffBLBaHBB\)B=qBkB#BHBzBffB.B{B
BGB\)BBBGBpBπ BQBBfBϨB.B̅BՅBӅBBߣB8RBB8RBݸRBpBؔ{B٣BpBB)BB#BRB#BBBHBBB
=B=qB(BGBB\)BaHB{BB)B\BW
CffC
C)BCCCcC LB
=BuBB
B
BHBLBpBǮB{BBBpBǮBGBBBBBzB(BGBǮBϸRB؀ BՅB#BaHBQB(BaHBԊ=BkBW
B
=BzBfBг3BўBzB
=BОBfB՞BpBBъ=B՞BW
BBBBBͳ3BHBBGB\)B33BaHBfB׸RBB\B)BBݞBB噚BkB
=BGBB3BBBBBCCB\C 8RC3CC5CCC33CCCC
CBHB)B)BHB߮BW
BBkB=qBQB=qBffC+CfBRBkB33BBaHBB B33B
B뙚BfB{BLBB\BBBBHBHB  BڣB=qB؏\B33BBBLB.BffBuB߅BuBٔ{BfBBBBpBڞBިB#BkBՔ{BўB؞BLBfBܔ{Bڔ{BأBBمB
=Bߔ{BBB)BHBBHBGB
BkC
C+C.C(CCLC\)CHC}qCJ=C
&fCC
=C\BC(C BffC C8RC+CCW
C=qCǮCB\C)B8RCBpB
=BB#B#B.BB.B=B=qBBBQBqB(BۮBzBBLBLB=qBpBB=qBܞB8RB׸RBBuBffBzBffBfB33BzBѽqBЅBъ=BB(BBfBB=qBBpBԊ=Bي=BأB=qB܅BBB݀ BݮBǮB۸RBB  BBBLBBBC&fCzC
CuCs3C0CzCnC
{CfC
qCCcC
^CC=C33CaHC8RCCCCJ=CC^C	qCC=qC
CC}qCC.B=B#BBB8RBB\B8RB{B=BzBBQB\BBB垸B\BB3BaHBQBBBuBBBBB(Bڏ\BBffBGBB33B8RBkB׮B
=BԞBBzBңB
=BӔ{B(B\)BkBĽqBͳ3B=qBGB̀ B=qB33B{B#BQBfBBkBpB홚BW
BBB)CECB33BffBC {CRCC)CCC33CHCC{C=qC=C
CaHCCRCqC3CfC CC
=qCChC5B=qBB)BQBQBB܀ Bـ BBܣB8RBڞBǮB#B׀ BB٣B{BBQBLBfB(BҔ{BpBBB  BӸRBLBBBBѽqBLBݸRB=qBӨBW
B#BBHBBuBB\)BBaHB{B=qBB۸RBBݞBBB(BBGB3BfBBGBzBuBBCٚCkCCaHCCfCJ=BBB33B(BkBBuCC\)CC\C{BBC=BuBCC\)C {C T{B.B{BBQB{BB  B(BBkBBBBB(BߙBܙBۮB\BW
BB̮BB
B
B  B\)B\B\)BѸRB\Bг3Bъ=BǮBОBЀ BЅBHBϨB.BͨBuBB{BaHB
Bǳ3BBȮB  BŅB  BǮBģB
BpBҏ\BϽqB33BkBB.BBaHBaHBB㞸BꞸBǮB3BuB(BpB\)B
=B3BB{BB33B(BkB)BB\CCCqC3CRBCC33C BC!HCB{C
CCBuB
=BB.B{BzBǮBޏ\B)BBB߽qBۀ BBBBGBڸRBLBB#BոRBBԸRB(B\)BfB͙B
=B̙BuBB.B  B
=BӽqBffBה{BBBBB{BuB  BaHB=qBB.B(B\)B8RBWGBQB\)BBB  BfB.BBfB\)B\BBB BBqBRBGC xRB33B=C &fC YC CC5C=qCCaHC&fC#C(CC
C
CqCCCkBBuB
=B8RB3B
=B
=BzB{Bݏ\BGBݙB\)BBBGBHBǮBճ3BBfBB.BҮB(BӔ{BHB.BѽqB\BffBzBkB33BνqBBɨB8RBǳ3BBGBBB
=BGB{BuBBffBͣBBfBɏ\BBW
BBW
B33BLBHBQB=qB۸RBB=qBBB\BLB{BB  BuB\BBqBB.B؊=B  BܨBHB=qBBBGBBfB8RBffB33BB
B.BpB)BܨBaHBHBHBffBؙBBހ BBQB\)BHBW
B)B\)B
B̞BaHBBpBBB33BBHBԀ B؀ B׮B8RBҳ3Bҏ\B=qBЮBfBzBϳ3BBB{BBBHB̽qBǮB
B=qBB.B
B{B\BHBǮBϣBǮBǮB\)BнqBͣB{BʙBB  BٞBBΣBѽqBԣB(BՀ BB8RBHBW
B33B=qBBffBBBB֙BuBGB\)B\)B3B33BBBB{B=qBffC B
=B
=BzBBfBB8RBBה{BԀ B՞BzBkBգBԀ BzBLB̳3B.BυBLB
=BУBuBBBaHB#B\)Bϔ{BBBBHB(B̅BBBBȅB  BBĞB\B
=BңBkB՞B\)BǮBpBLBGB#B
BGB
=BBB{BBLB\BǮBB8RB  BBBB.B)BW
BᙚB\BBzBqBB=BB=qB(B{BpBBaHBC C \C hC@ CCC
BC 
CLC)C{C)CC
=C}qCCC CCC\)BaHBBBBqBGC BuBB{BRB BBBǮBB3BBBBB33B鞸BaHBuBHB.B{BzB\)B\)BۅB߮BW
B
BBBHBBBBffB#BqBޏ\B=B\)BBᙚBBBBB(BB8RBB3B{BBQBB)CHC)C)CQCCCCfBkB(B{BB
B33B33BB#BB.BBBB
BBaHBBB33B3BB癚B33BBBBBǮBB.BkBǮB.BӸRBW
BBB#BzBBffB=qB\)BuBBBBBBBGBBBBBBaHB BQBfBBBB\B
B(BkBڮBBGB{B33BaHBBzBBǮBǮB)BBB{BqB8RBخB{BQBBB33BfB{B{B
BfB  BQCkB\)BuBaHBBCkCnB.C CCqC
CRCJ=CkC
C
YCC
T{C	\C\CCCqCHCBCRCC.C ޸BuBǮBBaHBBffBB\BBkBBBQB\)BB瞸BBBBkBGB33BuBB\BB)BQBиRB)BףB׮BfBB{BaHB#BBBaHBBBبBъ=B
=BB  BQBRBBGB  BB33B\C )BC&fCٚCkCqCcCCqC	hC5CٚC
EC
3CffC(C
C
O\C)C)CC#CCRCǮCCCCCLCCHCCCC C)C C
C{CCLBBkC +BzBBuC B\CC5BB
=BQC{BB.B
=BǮBB\BQB)BB8RBkBᙚB{BBpB\B BW
B
=BBB8RBkBBҏ\B
BҊ=B
BՏ\BB׀ BӞB#BמBݙBqB BB=qB{B8RB
B3BqB BBC @ C {CC5CW
CnCB{BBC{C
C}qC\)CqC=C}qC3C3CpCqCC{CqCRCqC uB\B.BRBfB=qBQBBBBW
BBGBB=qB)B.BGBBBW
B BBBQBW
B3B=BQB33BkBLBBB䞸BB܊=BBُ\BBBkB=qB=qBaHBB.BHB(BBBBBBޔ{B#BBڨBHBQB  B{BBRBQB B݅B(B\)BffBB8RBuBQBGBB\)B\BBGBBB3BpB=qBqBBBzBBBffBB=qBpBffB܏\BBqBBzB)BuBzBBBBqBQBBBB BW
B  BB3BBB8RBB
B鞸BBǮB\B㙚B۳3B=qB.BfBffBה{B.BBuBиRBڽqB͸RB
B͊=BνqBBǮBW
B܅BBǮBBB#BBB.B\)BBBǮBfBaHB♚BuBBuB3BB\)B
B\BBBQB#BQB#B\)C  CxRCCC{CC
CuCCCnC)BC{C )C BRBBǮBB=qBǮBBǮB3BB B
=BBBޔ{B  BBǮB׀ BB(B؅BݣBGB#BGB=B{B잸BB䙚Bߊ=BǮBǮB3BHB#BfBpB
=Bڔ{Bր BBBBٮB8RBQBߙBBBpBBBzBǮB.B33BpB)BzB8RB33B\)B33BBBRBLB=qB{B=B=BaHBW
C BBBC3C{CCCQC	 CCCC
^BC.BB{BW
BGBRB
=B=qBB#B{BB{BB.BffBB  B\BqBBB.Bߏ\BuB\BܞB BB BpB޳3BٙBBBfBΊ=B)BW
Bճ3BW
B׸RB=qBӸRBBLBpBԅB=qBaHBLBЀ B.BBBB֨BkB)BpB׊=BܙB BB{BLBBpBBB۸RBQBB33BBBBkBLBBB{B{BBCCCC\C\CCuCqC޸CC
zC
aHCC#CCC
C
B3C#C)CCECC
C C=C fC \BB
BaHBB{BBfB\BW
B
=B\)B=BfB癚B(BQBaHBBaHBaHB\BBB8RBBB#BBGBfBBGBBpB8RBBBBHBBzBB{B{B{BBB=BuBBBCqC޸C=qCC\)C&fCYCO\C\CfCC
HCC{Cs3C\C3CxRCYCC(C=qCCC8RCCCCC
ECCCffC C.CC}qCfC
=BǮC&fBqB
B\BpC 
BB\B)BaHB鞸BBfB BBB)B\)BLB٣B=qBHBBBB=qB3BaHB  B8RBkBܣBBڅB\B{BffB#BڣB؏\BԀ BBBڨBBBLBuB BB\BB#BB\BqBB.BBffB#BCs3C=CǮC:CBC	hC	޸C
s3CǮC
nCO\CC
C
8RCBCCBRCCO\CB\B
=BBB\)Bي=B{B#B
=B{B\B3B
=BҸRB=qBLBB(B33BۨBpBzBBBԊ=B)BB\)B#BffBBٞB#B
B\)BBaHB\Bр BfB\BaHBˀ Bȳ3BLBW
Bɏ\BBǊ=BW
BRBBBRBBfB33BW
Bʏ\BӨBӅBHBBBfB BqB=BLBB8RB33BuBBaHCHCCCcC&fCCYC}qC	CzCHC^C
=C.C
\CCCCC)CCB.C0B=CO\B垸C	\)BBBaHBBBBB  BB瞸BBkBBB˅BB\BB  BGBLBԊ=B܊=BBpB.BzB\)BuBBӔ{B33BϨBBBBfBԽqB̅Bϊ=BW
BfBΞB(BaHBBB.BǞBQBɮB\BBBzBB.BLB۞BkB\B3BB(B
=BCٚC\C)CCfC^CRCuCٚCC33CC C C T{C\CC
ECT{C
=C3CCRC=CfBBǮBB=C )y B  B{B3BffBǮBBBBB8RB8RB׀ Bր BՅBҏ\B33BѮBˮBΨB\B8RB#BәBήB\)BB#B(Bɀ B{B=qBuBLBɮBB8RB8RBBfBaHB{B  B8RBLBBBBͅBB(BBGBӅBpB)BBBB
BܙBBB  BuB\B)B{BW
B#BqB=BB8RBBBBBHBBkB
=B
=BpB=CGC}qCs3CLCzCCC  BuC 33B.BB\)B#BQBLBfBB\BBBBuB\BHBB#BBHBBB܏\Bۊ=BBW
BGB33B{BգBBB8RBffB٣B֞BffBkB\)BuBճ3B=qBؔ{BBɅB#B#BHBW
BQB\)BuBaHBW
BBϊ=B  BϙB#Bʏ\BBBzBB=qB˔{BffBBǮB{B\BBӮBңBָRB݅B  BB\B33BB3BBLBkBB BpBC EC T{C3BBB3C+B(B)B{B\BqBBBB
BffB\BB
=BzBڞB
=BǮB33BffBӣBҀ Bӳ3B
=BB(B{B.BB\B.BBBBBBB׳3B(BW
B=qBΔ{B8RBffB̞BffBBʣBBffB)BǸRBGBBãBffBHBB=qBpBɨB.BkBBޏ\Bُ\BBB33B.BqB
=BB뙚BBkBB
BBBRBaHC (BB3CECCECO\CCCxRCCkCC	RC&fC	ٚC
+C{CCJ=C
&fBB\BC CB CJ=CJ=B{BpBBBBǮBB)BBBW
B)B۸RBBݸRBB8RB=qBB
B\)B\)Bۊ=BHBޔ{BGB{BpB)BW
B׸RBծBԔ{B\BBBӀ BӽqBBaHB#Bӏ\B(B(BfBfBBGBҮB{BBϳ3BϮB=qB=qBfBffB#BBaHB陚BB BBQBBBB=qBaHBBCLC:CBW
CBCC	RC	޸C
C.CCCRCC
T{B  BuC8RC(C
=C=qBBB
B BGB{BBGB3BpBfBBffBBՅBըB)BB.B.BЀ BB  BuB)BBԸRB)BW
BרB\BzBԮB
=BzB)BBHBҮBB҅BQBHBBBfBfBυBոRB  BmB׮BaHBBBހ BffBHBB\B➸BB B=qB.BBB=qBHBC BB
CC&fC\CpC
C+CCpCCqC3C)C
CC
C
C
5C
C
J=C=C{C}qC}qCJ=CC	!HC
W
C{CaHCC )C:B3BGBaHBB8RB
=B
B.B33BBB{BǮB\)BzB=B{BBǮB.BfB8RB3BQB33B3BߨBkBkBaHBLBkBpB)BȞBQB(BzBLB˙B{BBaHB=qBB\BBBzBѣBBBW
BB=qBB.BHBHBfBB
=BfB8RB=BQBHB{C \CpC\C:BBBzBGBBqBꙚBaHBBBBLBzB\)B  B=qB3B\BB(B  BpBaHB=B=BffB㙚B{B3BBffBBRB=qBfBڮBۀ B=qBHBߔ{B
=BBBܽqB\)BB\BkB܅BޙBܽqBBٸRB\BBBB֔{BBB\B8RB.BǮBfB۔{BB\BLB
BBBzB3BߣBkBHB޳3BGB  B۞B۳3BB虚BkB
BkBfBBBqBaHBBRBQBB=B\BB{BfBuBBBBHBuB\)BǮB뙚BB\)BBB
=BBkB(B8RB\BBB\B8RBB؀ BW
BBB
=BָRB֞B8RB
=B)Bє{B
=BҔ{BB
=B#B
BkBѸRBңBѣB\)B=qBBѣB͏\BB(BB΅BzBBBЏ\B=qB33BBӊ=B)BأB=qB=qB۽qB)BBBǮB߮BB(BBffBB
=BkBB\B{B{B=BBkBB#B=B
BBBBfBaHB#B)BGBBB=qBBBQB=B{BB\B)BBW
BBB{B\BB
BHBBB=BB\)B33B8RBBB
B#BW
BߨBۙBڮB۞BLBfB\)Bؔ{BؙBzBڏ\B٣BB
=BaHBLB=qBӮB.BB̔{B  BLBBW
BW
BBLB
=B#BB
=BͣBBBBBpBGB33BB\)BB
BuBBBB=qBBB B3B{BffB8RBB BBLB㞸BqBB8RBB.BGBuB#BB8RB8RBB8RB3BB
B33BW
BGBB\B{BfBzBBBHBB(BW
B{BfBីBpB=qB\B\BBB
BڮBpBBB#B33B.BQBBzBB
=BͨBس3Bي=BBB(B\B#BfBҳ3BB׀ BܞB  BمB8RBGBBLBBzB8RB{B)BLB=BHB.BힸBW
BBB.C33CCkCRCcC}qCC	CqCC
\)C
s3C0y C CHC&fCW
CqC)B=qC aHB)BC=BzB=B
=BB\)BBBB
=BuB)B(B\)BpBuB\B3BaHB=qBѳ3BљBҞBΞBGBӽqB(BBGBBLBzBfBBۙB#B{BRBBpB܅BffB҅B)BҞBBBBGB(BpB΀ BՙBzB#BkBўB΀ BW
B
=Bٔ{B\B\)BBBBGB{BqB(BB
=BaHBBBB\)BLC B{CGB.BBB33BBBBBBBB)BBЮBuBǮBLBՔ{B#BB=qB BB=B#BBBǮB\)B{BQBBBW
BBzBBfBՅBffB)B\)BW
Bϳ3B
=B.BLBʽqB\)BHB
B=qBɽqBʀ BBBȣBBB=qBuBǨB
BuB\BǮBB)BGBLB\BuB̔{BkB
BBׅB׽qB޳3BBB#B
BW
BHBCCC	+C.CCC=CLC\C{C3C)C=qC.CC CRCkCC C)C{C C)CECffCy C &fBB3B{BBBkBHB陚B鞸BaHBffBǮBLBBBLBB{B
BBuB
=B#BBzBݣBBB鞸BRBBW
BBǮBB㞸BuBffB(B瞸B)B{BqBǮBݨBٽqB(B=B\BaHB)B)BB
=B{C =qC fBuCzC)CCO\C	5C	:C
}qCCLC:C
C
@ CCC
^C	LC\C
BRCRC(CRC 3CCqBQBǮB\BǮBW
BfBBBB=qBBBBLBBBBBBBW
BB8RBB  BLB=qB3BڅB׽qBٽqBؽqBuB۳3B#B\B׀ BBuB  B33B33BBB՞Bֳ3B
=BҞB#B33BBBfB\B8RBг3BffB\)B\)BkBLB܀ BQBGBBBBW
Bڏ\BףB݅B\BB=B33BHB{B#B8RB8RB=B B\BBǮBB8RBBBuB#B{BQB  BaHBB\)BڽqBB33B.BՀ BBBB8RB{BpBB۳3B8RBfBHBuB)B{BkB  B{B#BB#B垸BfB䙚B3BzBW
BQBǮB(B33B  B#BHBͳ3BǮB8RBΣB  B
B\)BB(BŮBȮB33BaHBƮB\B8RBƀ BB(BҙBBיB݊=B#BuBaHBBHBՅBuBQBQB
=B˳3BuBBBBB
=B
=BӅBԮBרBרBٔ{B=qBzBB  BpBLBBB(Bۀ BBǮBڔ{BzBQB{B.B\BBB֊=B׊=BֽqB֨B{BQBHB=qBѮBӊ=BQBҞBB=qBBҨBΨB{BB(BkBBuBBffBffB̀ BfBaHBffBΣB\)B#BGBB=qB33B
=B.BB=qB#B(BB=qBBBzBḄB
BzBBB
BW
BW
B\)BBʸRBB(BϨB\)BBBBuBҽqBB\BHB33Bϳ3BѮBzB  Bӏ\BkBǮBffBB\)Bؔ{BBؽqB
BB(BڨBB33B
=BB\)BLBڅB#Bڏ\BBB؏\B\BBaHBfBBBuB.BԳ3B֏\B(BuB
BaHBBBkB\B
BpBθRBЊ=B8RBӞB{B#B(BЙBQBffB(BaHBǮBΔ{BpBGBɽqBȊ=B\)BaHBBBӏ\B{BBُ\BBمBϨBԊ=BљBaHB#BfBHB(BמBڅB=qBGBLB
B{BBԸRBBBBBǮBaHBBߔ{BBBGBffBBݏ\BGBBHB33BGBkBQBpBBB  By BaHB8RBBB.Bߏ\Bޏ\BGBGBuB
=Bـ BأBzBٳ3BԣBffBGBffB
BaHBBBB\)BB\B.BLBLB
BHBЮBLB
BڮBB  B=qBB
=BB#BʞBW
B\)B
=B(BGB
BBԳ3BBBB\)B)BBԅBBԸRB8RBϳ3BaHBBBBB.BkBfB\)BBޣBBuBpBBߏ\B\)BBǮBLBBފ=BBqBǮB=qBBBBBB8RBaHB܊=B{B.BGBzB#B33BBBGB=B\)BܸRBѽqB\)BѨBҊ=B  B)BBB{BffB\B#BuB.B{BB8RBB(BQB8RBBBGBBuBaHBBffBΔ{B33BϣBB8RB{BLBBУBHB8RBB.BW
B͏\BffBW
BpB8RB\BuBB  BkBB33B\)BͨBB.B͏\BfBϨBЮB
BW
BօBBuB
BkBffBBpB(BBB
BݙBܙBLB)Bُ\BBLBبBpB.Bس3BǮBҔ{BԔ{BBBBGBBBBؔ{BB=qB)BBB{B8RBpB
Bֳ3B=qB(Bъ=BffBfB33BB\BaHB̽qB˅BB#BǮB33BfBB˔{B̽qB)BW
BBffB̨B
BkBBȞBQBW
BfB{BB(B(BHBW
BѸRB)BBzB(B
=BўBpBҊ=BBGB8RB֏\BֽqBkB֊=B֣B׀ B\Bُ\BڽqB8RBQB
=BpBpB  BBڳ3BBB\BzB׀ BHB  Bي=BبBzBuB߀ BfBBՊ=B8RBzBBӽqBBBϙBHB)BңBڏ\BBLBQBffBՀ B.BHBҊ=B{BҽqBHBBٞBB33BGB\BBpBB\BQBڽqB܏\BGBB\BffBB=qBǮBzB8RBBҔ{BΨBfBuB֮BW
BBBBLBuBfBBB#B۔{BffBHBBݳ3B{BBpBzB  BB
=BzBRB3BB\)B߮B
=BGBBۀ BBGBڊ=B
B֊=BkB#BGB#BBB(BuB=qBffBBBǮBqBQBBޮBzBB
=BB\BBB{BaHBW
BB؀ B8RB8RBpB{BBڽqB33BLBٔ{BBգBQB33BB#BBQBʅBɽqBє{B
BpB.B=qB#B׀ B(B)B=qBۙBB#B33B  BBfB۳3BBBHBQBܽqBܔ{BpBB{BBB8RBkBBBW
B\BBB
=BaHBBuBޞBffBBBBqBBBHB=qB.BLB
=BB  B33B#B޳3BBBBuBfBpBLBBGB\BBffBkB8RB\)BޅB8RB(B33B(BW
B)B
BpBۨBBڊ=BaHBzB
=B\)BW
BBB҅B.BʽqB=qBγ3BϮBǮBffB۞BBpBQB
B
BBBBBBǮB.B♚BBW
B8RBߞB޽qBߏ\BuBfB݊=B=B3B♚BǮBkBBB=qBBHBB{BǮB B=BBӣBLB BHB۔{BfBffBW
BՅBzBBBB{BҽqBӞB҅BBӔ{B
=B\)BaHBٽqBfBaHBݞBBݣBHBB۽qBpB\)BٸRBBB8RBBBԸRBхBBўBB۳3B=qBBӳ3BBǮB(B8RB\B.B=qB=qB؏\BzB
=BBaHBBzBǮBQB.BB\B33BBffBzB  BqBBBB.BBB{B
BGB\BfBBB#BGB\BpC BB.B33B\BǮBB{BBB
BBBB\B(BBB(BBB{B{BB)B{B=BLB=B\BB{B(BB\)B  B(B\B
BBǮB=qBBB\B  BLBy BfBB׏\B܅BzB8RBuBBBߨBǮB3B\)BffBpB  B)B#B=BBffBzBBB=qBB.y B\)BkBLBRBLBBBBBBǮBffBǮBB)BBBLBB
=BRBBQBBW
BuB)BǮBkBB=BGB݀ B#B)BB\BBBW
BfBzB\BޣBBW
BBBǮB{BBǮB(BLBݞBaHBBLBfBܸRB{BpBB
=BB=qBظRB(B
=BݽqBB#B{BuBBfBRB.B33BBB
=BBߞBW
BfB߽qBuBLB  B{B㙚BB
=BBuBB8RBQBǮB=qBLB
CLCffCECCC
LC
CLCffCfC0BkB  B#BBBBB
BpBLB=qBHBRB=qB(BBBzBߔ{B=qB{BpBB垸B3BuB=B{B BW
BGB=B3BffBkB  BB\BB\)B=B\)BQBzBݮB33BBHB)BB{BBힸBBB=BBHB(BffBBRBB{BB33BfBB=B{BGBkB\)B
BQBfBqB)BBBfBQBffBBkB3C {CRC3C8RCHC CHC0C{CO\CC3CnCT{C 3C\)BC EB=BGB33BB#B8RB=qBBC BQB\BBBBLB.BqB(B)B=qB잸BBLB3BGB  BBB\)B=qB#BϏ\BGB
BfB҅BzBУB{BaHB#BͮBGBBBW
BW
BؙB\BBHBBB\BBB\BuBBzBBBQB\)B33BBBBBBqBB\BLB
BB{BRB
BBBffB\B  B\B.BW
B3BffBpB
=BqB\)BBBBGB  BB#B\)BW
B(B
=BuB
=BLB(BBBuBԨBؙBBԏ\B\)BpB\BB\BGBfB=qBՔ{BԣBӏ\BBӔ{BBB
=BLB\)B(BǮBkBGBʽqBȔ{BƊ=BǮB̮B̏\B
B(Bӏ\BffBԅB=qB  BffB
=B#B\Bފ=BB{BfB陚B(BB=BB\B=B=BW
B=qBaHBaHB=qC B{CǮC
=C3CC\C0CYC \CCCC\C)C Cs3C33CYC{BB{BC CCcC aHC\C W
BBB3BBkBݔ{B.B垸B\)BqBBaHBfB왚BBBBBBBfB=qBLB#BBB  B
BBpBW
B\BB\B\B\B.BHBkB  BB3B=B\B=qB(BBkBpB{BBB\B\BGBBGBGB\)BBBB\B#B3B=B.B\)B#BqB\)BB3B\B=B(BffBpBBffBBkBBB=qBB\B\B\)BBHB\BBGB\)BRB8RBLBQB
BB B{B
B\)BffBkBQB33B۔{BٸRBB
B\)Bۏ\BBBǮB  B8RBٸRBٸRBQBBBBW
B#B(B8RBzBўBҙBӔ{B(B
=B  BpBHBfBؽqB  BGB=qBхB҅B׸RB٣BB33B{B\)B#BfBǮB{BBB\BBBW
BB3BaHBBQB(B
=BkB\BkBqBRBBzB(BuB\B\)BHB
B8RB(BB
=BB=qBBB݅BǮBBkB؞B#B
B=qB(B׽qB♚BB\BQB=BBffBkBBBBuBfBQB33BBBaHBGBB33Bݳ3BBB=BuBB)BkBBzBB
=BBpB.B݅B\)BB߮B\B
=BBBBBBBីBaHB33B
B=BB{BGBLBLBGBQBffBpB
BBBW
B=qBB(BW
B  B33B{B\B
=BW
BBBB3BffBڸRBfBBBpBB=qB.B33Bˊ=BB.BBǮBzBڽqB
=BkBԀ BQB(B\B  BzC޸BBB=BǮBffBBB  BHBffB.BB)BuB)BǮBԽqBGBpB8RBԽqB\)Bͳ3BЊ=BaHB)BuBaHBBخB\BמBǮBB8RBHBۣBB#BǮBBڸRBLB
=BffBpB{B.BqC:BGBqC !HBQBBkB
=BBkBB33BBQBW
B{BLBLBkBkBuB
BW
BffBB=qBңBBB݅BBBB֙B֨BڽqBzB
=BBߞB)B(BB܊=BB
=B
=B33BBBB(B  B)B\)B
=BըBuBB֊=BffBW
BBѣBήBGBҏ\BuBՀ BB  BkB
BuBBfBBLBaHB(BaHBݮBܞBݔ{BkB#BkB  BW
B.B\B33BBqBQB#BkBfBLBǮBBB#BBHB\B
=BB
BBBB(BB\BǮBaHBBzBހ BBB=qB#B8RBBB۳3B
=BBBHBǮBuBBB㞸B=B=B  BǮBB)B{BpBڅB
BaHBHB(BHBQBHBW
BљBBB)BBBpB{Bӏ\B
=BՙBԽqB՞BB8RBB
BǮBǮBLBpB(B(BBBBBffBpBGBBC BBBBB\)C EBC	zCC
.C\C
CCC\B  BCC #CBC nBW
B33BkB.BB.BGCBBB
BuBBǮBGBkB왚B33BB۸RBBڽqBB
=B\BkBfB݅BBߣBuBԸRB
=BǮB(BB\)BffB(BڅB׏\BҀ B
BBBBBBͳ3BBBkBB#B\)B  BHBBBkBޏ\B߮BޙBأBٽqBW
BGBHB)BڸRBޙBBB\)BBfBaHBLBBǮBBB\)BkB  CCCW
C  CqCCCBCfCCٚBB{BBBHB3BkC BBBBBkBBQBB8RBB\)B BfBkBuBBzBB=qBمB)BBaHB8RB\BfB۔{B)BQBB
=B
=B)BzB
BkBBzBLBLB  B˳3BBBʀ BӅBBzBų3Bϳ3BuBffBBڳ3BBBB
BBϞBW
B  BBB33B\BԔ{BHBոRBaHBמBkBGB\)B
BڙBHBB(BB=BRBaHB虚BBBBaHB
BuB=qBBBRBBBRB(BBB=qB
=BBǮB)BBQBڏ\BBzB)BkBLBBBBօB
=BՙBW
BpB)BQB
BpBuB{BaHBB#B#BpB\B{BLBQB
BBuBQBBaHB8RBffBʞB33BffBB=qBfB.BW
BGBuBŊ=BBB  BӀ BkBBѸRBӣB֊=BBBBuB{BBՊ=BBpBۮB=qB8RB㙚B3B\BRBB8RBGBQBHBfB
=B鞸B\BW
B{B癚B#B\)BHB8RB3B33BB=BBǮBBB)Bߏ\B)B܊=BBBkBҳ3BfBBGB
=B(BBԔ{Bѳ3BӅBB=qBǮBӀ B{BBffB8RBpBuBzB33BB33BfBҸRB33BҽqBӞBBBҽqBр B\BkBBӞBHBBBGB\B=B33B\)B.B֣B
BҽqBBхB)B{B
BaHB.BB)B\BuBخB8RBB
BW
BQBݳ3BBBBB(BBBݸRBfBBuBffB\)B.BHB׮B=qBBBBffB\)BBBfBB\)B\)BLB(BfBffB\BҮB.B̀ BBʣBʣBBaHBBQBB33B)BήBBBӏ\BBBQBkBLBHB{BBˏ\B33BzB̊=BBBBBLBBʊ=BLB˨BӸRB  BBGBfB׮BB֨BԅBB#BBҮB#BLB#BGBkBՀ B.B.B\)B(BBBBQBffB
=BBBBۙB=qBuBؔ{BǮBBծBB܀ CT{C
xRC{BBǮBB)B߀ B)BffBGBB\)BGBW
BaHBBBHBBBBaHB{BB\)Bـ BQBGB(BaHBѨB33B)B
BW
B3B8RBaHBQB(B)BBBB#BpB=BB.B{BB BaHB33B\)B\)BB{BB\)B{B)Bʔ{B˸RBBBB#B΅BԨBQB˙BuBB  BBC=qC3C.C kBfC :BqB\BB#BB.BB.BpB
BBaHB  B
BBBW
B
=BBBBۊ=BW
B(BQBBB)BuBǮBۙBBBۮB{B.BffBaHBܸRBW
BffBۨB\BuBW
BLBBBBBǮB.BB=qBzBΊ=BBBffBBBB8RBţBzB{BḄB\BpB.B)B\B{BLBfBݸRBߏ\BBBHBRBBB  CC aHB\BfB\)BQCC{B33B{BBaHB=qBB)B3BB BuB=B)B{BQBLB\)BaHBBLBLB
=BǮB=qB=qB  B Bي=B܏\B׮BҞBBӸRBuBхBBBϞB\BW
BӸRBυB8RBӨBӀ BBє{BǮBGBB؊=BӀ Bӏ\BzBQBGB
=BBՙBffB\B\B=qBє{Bє{BBЙBЙBBӳ3BGBգBՏ\B)B\BffB#Bُ\BB\BBӸRBBQB
BօBW
BBW
BB؅B#B33BBzBB.BffB
=B{BpB.BBB߽qBB
=BHB\B#BkBBBB\BB  BGBBfB܀ BfBW
BBB  BfBB(BӸRBB.BBaHB҅B؅BָRBծBB
B׸RBרBخBԣBҀ BfB=qB.BָRBLBݮBݣBӏ\BffBBB
B)B\)BHBB
=B̅BʮBQBuB)BpB瞸BBۀ B33B
=Bֳ3B33BaHBLBaHBBfBzBBBܙBB8RB(BpB
B{B33BB=qBfBaHBaHBB{B\BB.B(B
=BuB8RBffBBkBᙚBBBqBGBBaHB׸RBսqB#BШBuBBB33BGBBW
BW
B.C B BaHBLBBBfBC	CCBBffBힸBBBB(BB(BpB3BBLBLBBBÔ{B\B̙BBkBB8RBݣBBѨB֨BԽqBԨB8RBBffBBBHB)BܽqB=qBB߽qBB=BfBB
=BffBQBqBBRBBBHBBpBǮBkBB=BꙚBBB\BB=qBǮBHBuBBW
BpB  BBaHBaHB B  BۙB\BB.BB8RB܀ BBuB33BGB{BkBݨBޏ\B33BHB(BBQB垸BuB۳3BBzB䞸BBBԞBfBB=qB3B\B#BBkB#BkB=qBBBkBBBBBkBpBBpBBBkBBBꙚB#BpBaHBBLBB(BBaHBBpBB\)B\)BBW
BkBzB잸BBzBBBHBBB  BB{BpBBW
BBBRBBHB.BBaHBRBkB#BkB=qC HBQB3BBuBBB
=BpBQBBzB=qBGBBB\BB33B.B.BB.BQB(B.B\)B\BuB߳3BaHB.BaHBzBبBLBبBW
BLBB\B
BҀ B#Bˀ BB  BBkBր B8RBBLB
B΅BpBuBaHBpBʮBɮBLB
=B33B̔{B{BfBͅBBBBգBBǮBֽqB33BQB՞BҮBϙB̙B͞BB\)Bя\B
BBLBͅBB)Bγ3B̔{BHB  B͏\BkBHBkBBfB  BzB\Bր BkB.BfB33B
BУBfBB
=BaHBОB33B
BHBʮBRBBB\B BBkBۣBBЀ BԽqB\)BBBǀ BaHBBBƊ=B\)B)BǊ=BuBBB̔{BGB#B
=BBʨBzBB̅BљB=BBѮBBBBB׏\y BBظRB8RB
=BBkB.BGB#BBGBծB(BBaHBQBGBfB(BBBܞBqB\B
BfBBBBBB33B(BݞBBB#BaHBaHB֏\B)BBўBBBB\)Bˏ\B8RB\B  BB  BBBɣBԔ{BBɔ{BGB.BB(BBʸRBBBkBLBBBٽqBaHB̙B  BHBQB{BBB۔{BfB  BB#BffB.B)B
=BzB=qC =C{CC	
CٚBzBC BW
BGB=qB݊=BGB3BGBLBB=C qBBB
BqBB(BBffBuB BBBǮB=qBfBW
BBfBRB\BBHBBBBLB  BpBͨBBBGBBˣBffBBƣBBaHB#Bɀ B̅BaHB̨B̅BuB33BLBBЮBӳ3B֊=BpBBfBBʨBBϞBGB\)B\BLBʙBuB.Bǳ3BBʅB͙BBBḄBB\)BBB\)BǮB
=B)Bڳ3B(BǮBBuB  BuBڞBڅBBBBBfBuBLBBBսqBBBҨB  BpBGBה{BٸRBBB.BHBڊ=BBըBBBGB
BkB=qBBB8RBaHB\)B=qBBݙB#BݙB܊=B߸RBBߙB
=B̨B(BzBBǀ BƞBBȏ\BLBBLB.B  B3B
B BBÔ{BÞBGBkBƮBǮB͔{BѣBBǊ=B\)BѣBfBBW
BBBҨBQBfBB׊=B{B=qBBkBBBLBBBQB(BBQB.BݙBBB=qBBaHBBٸRBרBي=BBΣBuBǮB˔{BkB̀ BBB͏\BBBB(BzBB33BBBkBGBBҏ\BϏ\BД{BLBffBpB(BpB
=BѣBӸRBB=qBԞBkBԣBҞBԨBѨBW
B=qB\B̊=BQB8RBBaHBQBBǮBҊ=BҔ{B҅BBәBԨBkB׊=BaHBBW
B8RBٞB
=B{BB.BRBߙBB{BីBBB=BB
BBzB#B\BzBBW
BLB.Bߊ=B.B8RB33BzB
B33BfBaHBӏ\B
=BfBBLBϊ=BB(BfBΣBffB
BkBBkB=qBרBLBW
BpB׸RBמBBخBٽqBBLB
BLB BfBRBBuB B䞸B\)BBBzBffBB=qBBǮBӨBҽqBؔ{BLBBҳ3BffBЀ BzB
BЀ BffBҳ3BQBǮBBB؏\B(BB۽qBBBܞBB߀ BaHBGB33B33B\)BkB)B(B\B#B=qBǮB\)BBkBBqBHBB
B߽qBGB
B33BBخB#BHBuB֣BҊ=BGB33BBߏ\B{B#BuB(BpBڽqBW
BHBǮBBҳ3BυBffB8RBffBǮBήBBҊ=BӞBBθRBҸRB
=B33BffBBB  Bҏ\BǮBGBHBה{BǮBBݞB֊=B
=BBBϨBB
=BڸRBր BLB)BB{B#BBLBBBBB8RBqBGB{BB
B\)B{BkBBBǮB.BBB\BfB瞸B=qBGBBBGBBB8RBBBBBBLB33BBaHBRBB{BW
BB\B(B.BffB)BHBؙB
=BBB
=B8RB#BBffBǮBBިBpBffBB̔{Bϳ3B˽qBBȽqBB.B#BW
BfBB̏\BW
B)BaHBaHB8RBǸRBuB33BB
=B(BuBB8RB33B#BkB\BB=B{B\BB\BzBqBpBB  B.B\BǮBpBpC \BBaHBfB{B)BBBuB߸RBB؞BGBǮBШB=qB.B(BLBffBָRBffB#BpBBڊ=BzB\BLB)BGB(BBB܏\BW
BݮBBBBfB޽qB8RBQBQBB\)BB{B8RBҳ3BGBѽqBB҅BBγ3BBɸRBBB8RB˨BB̅BB\BBQB.B׳3BBBخBkBB\B➸B
BB.B\)B8RBB BBC ޸C^CC=qCCzCs3CJ=C
CC^CBBQBqBB(C =qB
C 8RB\BB
B{BBBBB.BBBzBfB3B
=B߸RBQB\BHB(B)B\BBߞB
BqBaHBBBBۅB{BGBה{BǮBܙB
=BLBLBB޽qB#BB\B33BBuBԀ BaHB  BBkBzBǮBBGBۀ BިB  BaHBB̸RB#BBB.BkBݞB
BǮB߅B#BpBB{BBBǮB#BB#BCnC@ CCqCC\)CٚC)C.CC(C
GC
=C޸C
CT{BB  B8RB\BQBGBBpBffBLBB BB C cBǮBB
BzB33B\)BGBBBBؙB۞BߞB\BW
BB3BaHB  B=qBkB\BǮBBׅBB#BuBBսqB8RBϙBД{B(B  B\)BЏ\BԊ=BuBBHBaHBBB.BڮBΞB\BkBfBGBB\BɊ=BkBfB\BBBuBǮB)B鞸B BQB(BB\B33BB)C BBQB(BBBzBBBHBaHBQBuB.BHB(BǨBffBkBB
BB
=BОB{BͣBBBHBHB˳3BfBB8RB.BBșB)B½qBBȸRBBٮBB.BBfBŞBzBfB(B\BB#BǮB\BW
BaHBBBBqBBW
BBŮBBBB\)BB3BB3BRBBBHB(B8RBQBaHB  BBQBLBB8RBQBBBҸRBҀ BЀ B  BЙBѮBB33Bг3BӅBBBBkB
BBB
B
=BBBBҞB
=BД{BB\BʙBBB)B{B.BОB\)BϸRB.BfB͸RBfB=qB\BuBBBHBʊ=BȮBBBW
BB¸RBaHBW
B)BB=qBkBkBB8RBBBkBuB8RBB.B
BuB{BBB8RB.BQBąBB\)BBB\)BHB  Bɏ\BBHBBBͽqBGB8RBBЙBpBԣBkB\BBBW
BBՀ BǮB\BBfBB
BLBBBӳ3BBffBԨB\)BԙB(B҅BLBǮBͨBffBр BGB8RBBBǮBBQB̸RB33B
=B(BBBɸRBBǨB#B(B33BRB.B)BkB\B(BBBBBBBBBfB B=BBffBBGB{Bǳ3BaHBʮBBȏ\Bɏ\BBͅB  BuB  B33B\BBLB
=BBծBffBuBB(BLBaHBzBBڳ3B(B8RBה{BׅB׮BaHB#BW
B=qBzBB.BBaHBB33BڙB׸RBӀ BLBͮB=qB33ḄBBB\)BBǮBBBB
=BBBފ=BQB8RBzB3BޞBHB8RBffBѸRBBؽqBԏ\Bъ=BW
B  BBB̏\B  BʣB΅B
Bڊ=BݨBBڀ BڙB#BW
B֞BB\)BBB  BuBkBBQB33B{BffB8RBBBBfBpB8RB׸RBB  BBBpBڣBBB  B܊=Bݏ\BHBߊ=BLBffBQB\BB33BW
BBBπ B)BW
BҞBGB)B  B)B#Bъ=BGBԸRBBր BB33BBBGBB\)BBB\)BBBB߽qBBffB)BLBޮB➸B BBffB\B{BqBaHBBGB\BBBffBW
BꞸBHB㞸BffB#B BB(BW
BBB䞸BBLBۙBBֽqBBuB33BB
BB➸B
=B3BB
B晚B  BBBB\B#BBBBaHBkB  BB{BB
=BQBǮBBB BpBBBBBpB=qBzBB  B
=B#B
B{BBB8RBGBLBGB{B#BB{B㙚BpBLBBGBǮB߀ B֔{B{BqBzB=qBzBaHBGB=B.BB\B
B\B۔{BמBBGBBzBۣB\)B#BffB{B׽qB۞BBB
=BBBqB  BpB.BBGB)BzBLBBpB
BfBffBGBaHB
=B垸BfBqBB\B.BW
BffBqBǮBBfBQBzBңBȳ3BBBuBʏ\BBaHBB{B(BBB#BB
=BHBLB8RB8RBԔ{BB՞BBBոRB.BLB BBqB߸RBzBB
=BB޳3BݙB(BpB{B#B
=BǮB=B
BqBRB=qBQBBuB=BffBBBBƳ3B8RB
=B\)BBۙB)BǮB\BB݊=BߞBBBGBBBkB33BpBBfB  BffB\BaHBffBBBBkB)B(BBBBB=qB\BB\)BۅB۽qB33BW
Bٳ3BBfB
=BB8RBǮB
=B{BB#BB(B\BfCkBzC޸C}qCqB=qCC :BBB#BBqBBBBB3B(BB
=B=qB陚B.B\BBGCBC {BB{BzBBQBBkB=BBB(BaHBۮBߨB߅BLB޸RB=BBB\BBuB\)B䞸BBpBBBBBؙBHBߏ\BQBQBW
BBB
=BBBLBה{B{B)BBBǮB8RB3B=BHBW
B
=B B{B
=B.BǮBB.BuBB  B#B33B{BBB͔{BօBр Bڀ BW
BB߮BBLBffBBB8RB\)BBLB҅B8RBיBzBQBٽqB(B.BaHB؊=BBW
BHBkB.BBB{B\BfB垸BBffBfB)B=BBBីBB\BuBBBBkB
B#B\B{BRBaHBBHBď\B\BǨBBBBffBffBfBpB\)B{B\)B
BuB\)BѮBLBνqBϽqB33B)B׸RBkBGB\)B)BڸRB(BB BB  BBB.B8RBQB\B{B)BLB33BB(BBس3BW
B\BBBRBB
B
=B
BB#BffBBB\)BBRB  BǮBBBB(B{B\)BB=BBB B{BHB{B{BqB3BBBBB{BʙBB.B  BaHB
B\BBڙBܙBW
BHBǮBffB㞸B\BQBqBǮBBqB{B.BB螸B33B.B=qB\)BW
B\)B3BRBHC !HCC޸CCC޸C C\C
B)BB\BpBffBBffB3BaHBGBB8RBBB  BǮB.BHBQB  B(BٽqBBB{BpBB\)BBB=B#BuBzBȊ=BB33BpBҙBpBffBuBٮB֨B.B{BzBB{BޞBffB33B#BuBkBԅBBӞB8RBس3BffB(B
=B  BB8RBHBW
BaHBBfBBHB΅BBҸRBBHBBըBԳ3BpBBBQB٨B
=B(BqBB㞸B#B33B.B3B\B)BW
BB.B
=BkB˅BBBB)Bя\Bг3B\BϣBzBkB.BHBzBB=qBܔ{BB8RBaHBaHBW
B8RBQBLBzBB33BffBBBBBBBB
=BzB  B8RB BBBLBGBܣB۳3BܨBfB{BpBޞB)B33B  BBB۸RBBaHBފ=BǮB
BGBQB\BBBBBǮBuBBffB
=BpBuBqBޙBW
B{Bހ B߳3BݽqBW
BGBBBីBB#B(B
=BBBLBBнqB\)BzBBҨBpBB͏\BaHBuBǮBBޮB
B  B\BBBB  B
=BBԙB׮BͮBBHBB۔{BHB؏\B{BڨBڨBGBBzBkB\BzB#BLBW
BB33BfB BqBkBaHBRBW
B癚B
BpBfBBLBB#B{BB8RBخBB#Bۏ\BBB\B۳3B(Bڳ3BBB33BBBHBB.BB=qBәB=qBBLBQBpBGBQBQBԳ3B\)BBԮBBӣBBB)BfBBΏ\B33BW
BBѣB.B
=B33BBӅBՅBGBBߨB(B=qBBpB33BخB
B{B٣BzBՊ=B׽qB=qB݅BB
BB=qBBQBB\BpBǮBaHBBkBᙚBaHBuBܣB=qBۣBHB
=BܽqBB)BffBLB\)A^ffBǮB.BuBLB=qBє{Bˀ BHBpB؅BָRB{B8RBѮB
BBB)B BBýqB
=BBkBͳ3B̞B{B=qB=qBB
=Bُ\BBB(BB䙚B=B B8RB33BǮBBBBffBᙚB\)BBǮBGBBυB
B BW
BfBGBBpBaHBGB\BBfBaHBQBLBGB  BBBBfBuBW
BўBԳ3BHBaHB\)B  BBW
BHBuB
=BǮBBBB{BffB
=BzB8RBBLBQB\B33BHC uC0BB33BBףB
=BzBBBLB3BB垸BBGBLB
BfB#BB3BB♚B33Bߔ{BB\BǮB  BBBBBGBƣBQBʨBʣB
BBBW
B\BBB{B.B33BBր B)BBB  BQBϏ\Bϳ3BнqBQB#B
=BBBBuBBBuB33BBʔ{B8RBpB33BB BBɏ\BBǏ\BǮB  BřB=qBLBaHBЏ\BB\)B\)B݊=B)BGBuBBB3B
BBB(BBB)BB B.B̅B\B♚BBW
B8RB׸RBBBQBBBBߏ\B߅BBW
B٨B{BߙBQB3B\C^C	^CC\y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y BB
B(B
B\A
A(AB
=A\AAzAAAAA  AܸRA
=AݙAAQAޏ\AA33AA
AHA\AHAA33AAᙚApAApA  AQAHAݮA  AzAA
=A(AAAAAQAQAڸRApAGA܏\ApAGAA\A(A  A
=A  Aڏ\AAAQAffAߙA
=AۙAׅAAA\)AڣAzA(AAծA  AA  AAA\)AAAݙA{A܏\AܣAHAAffAڸRAA\)AAۙAۙAHA(AۮAAffAffAٙA{AڸRAA  A܏\A  A(AzA
=A
=A33AAAAAAA33AAAGApAA
=AffA=qA
=AffA߮AQA33A
=AHAA
=AA=qAA
AQA\)AffA܏\AڸRAۮA33AA{AzAA(A
A
=A֏\AA{ApAָRAzA\)A
A  AffA׮Aڏ\A؏\AأA\)A  AۮAA(A\)A33AۙA\)A
=A\)AۙApAA(A
=A33A߮A33A(AAffA
AffAAzA\)A\)AݙA݅AA  A{AݙA
AݮAݙA  A=qA  A\)AAffA܏\AܸRAܣA܏\AܣA܏\AܣAQA(AAܣA(AܸRA
=AHA=qApA߅A  A
AAۅAAffAٙAAA݅AߙAAAQAAޏ\AzAޣA
A=qAAzAAݙAGAٮA(AۅA޸RAHA33AޣAAGA(A  AffA\)A=qAڸRA=qAӅA
=A
AffAAڣAݮAܣAAܣAڏ\A\)A  AGAۅAGAAGAAۅAAzAܸRAAQAHA߮AffA\AffAAARA=qARA33A{A=qA
=AzA=qAARA
=AHAA\)AGA
AAA㙚AzAffAA=qAzA
AA=qAAzAAAAGApAGAA
AGAHA{AzA(AGA߮AڸRAׅAAAQA\)AQAffA  AA߅AA{AffAA
AA
AA33AAA
=A
=A{A=qA=qAHAA{AAffAQAޣA  A
AAzA33A=qAHA\)AAzAA(A\)AᙚAAA
=A  AffAzAᙚA  AAzAQA  A㙚A(A
AᙚA{AA
AGAAAAGAQAzAHA33AAޣA޸RAQAAAzApARAffA\)AAAHAHAۮAApAأAHA(A(A
AڸRA
AAHAڸRAܸRAAffA(AffApA(A
=AٮAׅAأAAffA
=AAڣAAGA֣A؏\AA\)AGAٙApA
A݅A
=AݮAzA(AޣA(ARA
=A33AᙚAQAޣA=qA߮A(ApA  AA܏\AޣA  ApAQA  AڣAڣA(A(A
A=qA33ApA
=A=qAأAGA
A؏\AffAمAzAA
=AٙAffAAۮA܏\A
A  A
A(AݮAApAڸRAۅA׮ApAApA\)AأAGAffA
=A(AәAA33AHAQAzA
=AҸRAffAAHAQAԣApA{ApAQA=qAԏ\ApAGAՙAՙAՅA(AԣAAԸRAHAApA
A(AffA
A
AיAׅApAAA=qAأAAAHAأAHAHAHAA33ApAGAٙAffA(A{A  AA{AQAڏ\Aڏ\AffAڣAzAzAzAzAAمAzAڣAAAffAٮAٙAٮAمAأA(A
=AAA
AمA=qAڣAڸRAمA
=AٙAٙAٮApAAمAGA  AffApA\)A=qA
A؏\AA
AQAzAAڸRA(AڸRAٮAAڣAAAظRA؏\A  ApA\)AffAzAڣA(A
AAAffAA=qAffA޸RAGAA
A{A\AAA=qA(A{A  A߅AGA\)A33AAHA
=A33ApA
=A޸RAAAzAA{AA݅AApAA
=AٮAzAffAAܸRAܸRA܏\AQA  ApA=qAٮAיAffApAA  ApAAGA
A(AQAA=qAApA
A(A(AA=qA{A(A܏\AۙAGAHAA
Aڏ\A܏\AGAۙAzAڣAAffAܣA  ApAۮAۙAAQAA(AAApAA{AQAߙAA(AAA(AAHARA(AA
=AAGA33A33AApA\)AAQApA
A߮A
AAޏ\A
AA=qAߙApA߮AAA߅AA33ApAߙA
ApAHAޣAHA=qAHAAGAAGAQAAڸRAAAܸRA{AAHA=qAٙA=qAA=qAAۙA
AAAA
=A\)AۙA  AۙAۮAۙA33A33ApAۮAffA  AQAffAffAzAܸRA
=AݮA݅A
AݮAAݙA33A
=AݙAA(AffA=qAA޸RAGAߙAA33AߙAApAAQA(AQAޏ\AffAޏ\A{A
AzAffAA
AAGAHA{AHA
A{AGA{A=qApA޸RAffAzAAߙAۅA=qAܸRAffA܏\AAAۮAAA{AۙA(A  AHAzAAܸRAGAzA
AARAAzA
A߮ARA33A޸RA=qAAGAHApA  AGA  AظRAQAGAGAAAAA  Aޏ\AA
A  A޸RA33ApAA݅A܏\A\)AGA
AzApAGA  AڸRAأApAGA33AAQA
=AՙA
AծAA(AظRAQA؏\AׅAA\)A֏\AA
=AGA{AAzAأAA33AffAٙAأAׅAָRAQA֣AAA֏\AzApA
AՙA
A{AzA(ApA(A  A
AәAӮAQAծAA
AHA\)AGAA  A(AQA\)AAӅA=qA33A{AAGA
AָRAHApA
A(AA
AQA{AָRA׮A׮A(A֣AՙA֣AAzA{AHA
A\)A=qAAAٙAAffA
=A=qAAzAأA=qAffAAGAׅA(AffA{AffA  Aԏ\A
A
A  A=qAA
=AGA33AָRAծA\)ApA
=A\)ApAՙAծAAAGAffAHAԣAffA{A
=ApA{A{A33AffA=qAHAA=qApA
AAA  A{A{AAA
A33AAA
AA֏\A֣AAAA׮A(AAA
=AAGAHA֣AHA֏\AHAHA
=AGA׮AׅAיA׮A
A  AׅAHAGAAQAzA(AzA׮AzA
=A
AffAA׮AA(AGAA{Aԏ\AԸRAՙAHA(AzAծA
=AzAQA
A(AQAAzAՙA
AA\)A
ApAffA֏\A33A  A
AՅAA  A
A{AأAA֣AHAAظRA  AHA(A  AAA
A=qAۮAAzA
=A33AAAGApAAڣApA׮AAAAA
A(AffAffAA{AffAffAzAظRA=qA؏\AمAApAA
=AAAGAمA\)ApAGA  A{A(AمAGA(AA؏\A׮AHAHA{AHA
A33AA֏\A33AأAڸRA
AzAظRAApAԏ\A
A(AAҏ\AffAԸRApA  A=qA(AAQAA33A
AՅA
AAA  A\)A{AأA  AAA=qAHAAԣAHAGAAծA
A=qAAA؏\AffA(A(A{A
A{AA
A  A(AzAzAAظRAظRAAٮA
=AA׮AأAAAAffAApAA֏\AzA
=AӅA33A
=A  AQAAHA֣A
AיA
AGA(AיAzA
=ApAԣAffAffA{Aԏ\ApAffAA
=AffAA33AA؏\ApAHA
=AAԸRAHAA؏\A
AA\)AAAAܸRA܏\A
AۮAA\)A{AffAzAAAיAׅApAיA  A  AׅApA=qAAڸRAۅAA
A{A{A{A
AA=qA  A  AAۮAۮAۙAۅAAHA
=A{AGAۙAzA
A
=AzAܸRA\)AܸRAܸRAܸRAܸRA܏\AzAHAHA׮A  ApApAA
A֣A{AGA
=AGA\)A(AׅA
AAAGA(A
=A
AHApA{AٙAՙAA=qA֏\AA(ApAԸRAHA(AAffAծAAָRAffApA׮A\)AׅAApAظRA33AٮA=qAffAHAHA\)AAAAffA
A߮AAA
=AQA\)AAzA(AAAAAAzAAAAA=qAQAA  AA߮ApAA33AA33AߙA
AzAݮA\)AAA\)AܸRA܏\A  A(A(AۅAGAڸRAAAAAA؏\A33A
=AAzAA  ApAzAA\)AۮAAHAzAzA33AHA
=AA
=AffAHApA
AۮA33A(Aڏ\A
ApA  AA\)A݅A\)AܣA
AߙAA  AApAA{A(AQA  AA
AAۅAأA  AأA؏\AAA\)ApAA{AHA{A  A(ApA(AQApA{A=qAzAۅAAٮAAA݅A݅A{AܸRA\)ApA޸RA{AzAAۙA܏\AGA׮A(A(AGAA
AA  A\)AAծAQA
=AA=qA
=AGA\)A(A33AA{AׅAمA  AAיAA{AУAGAHA=qAzA
=A=qA33AAѮAҸRApAיAA
A؏\A(AffA(AffAՙA{A=qAׅAAQA
=AAGAzAָRAApAׅA\)AHApAָRAӮAՅA֣AAمAHA(A=qAأA؏\A׮AAׅA=qAzAApA(A\)AAԏ\A
AQA  A33AGAGAzA{AzAAAיAA{A{AHA33A  AA33A(AAAHAzA=qAzAHA\)Aҏ\AAzA=qAHA\)A(AGAљA
ApApAAA(AиRA(ApAffA=qAͮA
AHA  A  A{AυAϙA\)AυApAAGAzAхA=qA(AΣAAGAAHAУAAzAЏ\AңAҸRAӅAҸRA\)A=qA  A(AQA{AA
A(A=qAQA=qA
AQAУA(AGA͙AϙA
ApAGAffAA33AAApAHAAQAͮA=qA\)AA33AA=qA
AͅAffAQA˅AAA˙A
A  A\)AAǮA=qA˅AA(A33AAffA=qAQẠA(A  AffAGAAAẠA(AǅAAəAAθRA  A=qAЏ\AиRAA=qAʸRA{A  AљAθRA
=AHA=qAHAffA(A
A{AQAGA=qAA33A͙AHA=qA33AAAAAиRAAAЏ\AЏ\A  AͮAzAAυA
AGAAA{AffẠȀ\AAzA  A\)Ȁ\A˅AA
A\)AAAAAAAffAGARA{A33ARA(AAÅAÅAA
AAAAAAAAA=qA{A  A
A
A
AGAA33ApA  A  AAA\AAAA
AzA\A
=ApAA  AAAÙAGAAAGA{AAƣA\)A(AAÙAApAzAzAQAA\)Aȏ\ApAǙAȏ\AHAAAQAQAǅAʣA
=ApAAͅAAɮAɅAQA˅AzAAʏ\AAAʏ\AˮA\)AAΣA͙AʣA  A(ApApAɮAQA
A(Aď\AAAA  AȸRAHA͙AAԸRAAљAHA\)A
AHAA\)A
=AAՅA
=A
AӅAHAϙAGAzAAУA{Aҏ\AAHAҏ\A˅AAA  AљAљAͮApAϮAҏ\AҸRẠA\)A{AAAzA33Aҏ\ẠAGAՙAәA(AAAAծAԏ\A{AHAAծAHAA  AQA
AҸRA
=AQAхAЏ\AA\)AυAA{AHAffAQAθRA  A=qAHApA33AϮAϮA
ApAAυAϮAѮAffAffAAAzAGA
A  ApA
AHA\)AA
A  A(AzAA33A(ApA
=AzAأA{AHA
=Aҏ\AҸRAA=qA{AAAA33AQA33A
=A\)AAHAAffAGAхAffAzA{AffA  A
=A
AәA
AGAӅApAHAA\)A
=AңA=qAAԏ\A  A  A(AAAAA
A33AAAA33AHAAAAԏ\AffAA\)A  Aԏ\AA33AA33AGAAzA  AՅA\)AՙAGAffAffA33A
=AAՙA=qA
AָRAHAAffAأAأA
=AAA؏\AAA  A׮AיAAHAיAA33AGAzA(AA  AיApAיAA\)A(A33AzApAQA׮ApA  AffApA  AӮAHAA\)AAՙA
A\)ApAGAGApAAApAՅAHAA
AAҏ\A(AԣA  AffAffAљA\)AA=qA(AGAffA33A
=A(AָRA\)ApAAffAQA  A
ApAA{AHAAأAffAAA֣AHAHAHA33AיA  AAGAA֏\AffA֣A33AffAՙAҸRAAәA  AGA\)AHAQA
AzAՙAծA
A{AffA֏\AA  A33A33AA\)AffAAԣA  A
A(AAzAՙA
AHAԏ\AGAAAAӅAA=qAAffA
AәA=qA=qAԏ\AAffAәAәAңAGA
=AHAAAA
=AA
A(AңAzA
=AffApAQAGAAAAӮA=qAffAAԣA
=AGAծAAծA
AQA֏\AA֏\AָRAAAA
=AGA  A֏\AffA
AיA\)AAָRAA{AָRAָRAQAAffA{AָRAQA  A
A(AQAָRA  AGAәAԣA\)AGA{AQAffAԏ\A{A
AGAA
A33AҸRAәA(A
AHA(AGAծA33AәA
A\)AҸRA\)ApAљAAAQA
=A
=AffAHAA=qA=qAAAAQA  AAAGAҏ\AAGA=qAԸRA
=AՅAQAָRA33AAיApA
ApAGApApA33AQA=qApAظRAQA
A
A(AAGAzAA(AAָRAAQApAأAffA\)ApA
=AA\)AٙA  A(A
=AٮAمA\)A33AHApA{AٮAأAGA\)A
=AzA(AظRA\)AApA\)A  ApA
AAׅApAHAQA{A(AA=qAQAAA
=AGA=qAA  AظRA  AׅAHApAQAHAHAApAAظRAA33AظRAAٮA
AA؏\A
=AٙAA  AA33A\)AمApApAGAٙAظRA33ApAٮA(AzAAAzA
A(AQA׮AAzAAQA(AAڏ\Aڏ\AAQAAffAAظRAA׮A׮A{A
ApAffA(A\)A{AffAңAQAGA(AәAAԸRAAQAӮAffAУA=qAԏ\AԸRAGA33AffA
AٙAAٙAAԏ\AԣA33A  A\)A{AHAϮA{AHAA
=AҸRAҏ\A\)AәAffAffA֣AָRApAzA(A  AQA=qA=qAzAzAӅAffAԏ\A
AԸRA{AՙAңA33A
AffAAffAA  AיAA=qAQAGAHAՙAծAԣA33A{AיA=qAA{A؏\AzAأAzA=qAԏ\ApA֏\A33AAQA  AHA\)AffAՅA
AԣApAHAAQAHAHAиRA
AHAAffA{AٙA=qA  AHAיAAHApA33A
AAffAHA׮A=qAGAأA\)A\)ApAAQAQAA݅AݮAGA
=AޣAڸRAAAظRAQA؏\AAA(A(AAA\)AHAمA(AAzA  A׮A=qAAAٮAQA=qAڸRAA
AۙA
AGAzA33AHAAGAAۙApAffAAAAffA
A{A׮A=qA33ApA؏\A؏\AAzAAУAAHApA33AӮAָRAzAzA֣AָRA
Aڏ\AAHAffA
ApA\)AGAٮA\)AA=qAA  AA(AzAGA  A  AffA(A{AzA33A\)AۙAۅAۮAۮA33AHA\)A=qA  AGA݅A\)AzAܸRA
AHAۅAAۮApA{A33A\)AffAٙA  AٙAڣAzAٙA33AAGApAۮA=qAHAڏ\A\)AڣAAAffApAۙAAׅAQAAمAffA  A
AمA(AAA  AٮA  AAzA{AQAffA\)AGA{AAAAڸRAڣAHAӮA=qAՙAԣAzAיA\)A  A{A  AׅA׮A
AAzAAظRAمAڸRAGAGAڏ\A  A33AA(AGAA\)AۙAۮA
AQAQA܏\A(A{AAAHAAׅA
A  A
=A\)AAAڣAٙA=qAA33A(A(ApA{AٙAمA(A(A  Aڏ\A
=A
=AAHA{AA
=AA؏\AٮA33AָRAAԸRApA
=A֏\AHA
A׮AծAA33AхAGAӮAԏ\A(AծAffAՅA33AA
AAׅA(AAQA(AՙAGA(A
A  A  AHAA  AHAיAA(AGA{AܣAܸRAܸRAܸRA܏\AA  A{A{AAzA=qAAܣAQAzAffAffAHAzA
=AHAAAzAA
AAffAzA
=A\)ApAHA=qAܸRA(AA33AffAڏ\A=qApAظRAHApA=qAAڏ\AA33AڸRA(AGAAA؏\AzA{A=qAzA  A׮AיAGA  A
AGA{A33AQApAAAGA
ApAָRAأA  A
=A{A؏\AAٙAQA؏\A  AAAܸRAAGAffAffApA݅ApAݮAA޸RAHAAݙA܏\A
=AݮAݙApApA݅AݙAGAAۙAAܸRAHA݅AAffA=qAAzA
AAffAzAApA=qA܏\ApA܏\AܸRAffAQAۅA=qAAQAڣA
AAffA֏\AGA{AffAffA=qAۮAAۮAffA
=AAGA{AܣAA{AQA
A  AAݙA{A{AB=qA  AQAAAHA(AGA(AظRA
=AApAGAA
=AHAۅAۙA{AAA݅AA(AzA޸RAAHA
A߅A{A{A߮A  AffA=qA(A=qA(AQA\A(A޸RAHApAzAGA߅AݮAA\)AAzAAݮA܏\A  A(A{A{A=qAAݮApAA(AQAܣA=qAGAAQA\)A  ApApAHAظRAָRA(AծAәA֏\AA
AAQAAzAAzAAׅAffA=qApAAۙAffA  A
A{AHAHAٮAzAAQA=qAA{A{A
=ApA  A{A{AGA=qA܏\AAAAHAzAffA(Aڏ\AA33A
AGAۙA\)AAQAA\)A=qA
A\)AffAݙAA݅AۅAۮA33AHAGAظRA\)AۙA݅AQAڸRAAzAGAAיA׮ApAA  A(AAffA=qAA  AAHAAA
=AԸRApAԏ\AљA=qAGAAzA֏\A33ApA(AAGAٙA  A\)A
=A{AָRA(AAQAAHAA\)A=qA؏\AٙAڣAۙAܣA܏\A܏\AݙA
A\)A(AA\)AAAA
AAA
AAAߙA
A(A  A{A\)AGAGAHAޏ\AzAQAA  AݙA
A=qAظRA  AۮA{AA޸RA؏\AA  AۅA\)AGAיA  A
=A  AHAAׅA33AzApAGAծA  AAQAQAQA
=AAAٙA33AAA
AffA׮A{AAHAzA33AGAܣAQAGA{A\)A\)AAffAffAffAHAٮA
AAGAAۅAۅAۅA  AQAAAHAGAGAAޣA߅A(A߮ApAAffA
AAzA\AߙAA(AAA  A  A{A
=A
=AGAffAمApAܸRAzA߮A{AAGAGAHAffAQAAٙAݮAڣA=qAٙAظRAA  AffAAHAffA33AٙAڏ\AA33AAffA=qApA݅A؏\A{AffAHA33AGAHAGAHA{AܸRA(A
AQAٙAA33AA
=AA{Aڏ\AڸRA
=AۮApAAzAAffA{A  A=qA=qA=qA\AAGA{A33AHAA޸RAޣAQA
=AGAAHAA{AffAAQA
=AAޣA݅A33AޣAAGA(AA  A߅A=qA\)A\)AHA
AAAA=qAۅAAڏ\AHA\)A(AAأA؏\A{AڣA(A\)AzAHA
=AQAAzA(AzApAՙA{ApAAffA=qA  AׅA؏\ApAۅAۅAzAffAzAAAAHAGA33ApAڏ\A܏\ApA=qA
=AAA33ARAGA
=AA\AAAᙚAA
=ARARA
A
=AA޸RAzAffA  AAGAGAޏ\AzAQA
=A  A
AQAޣAA߅AzAGAAޏ\A33Aޏ\ApAAߙA߅AA  A߅A݅AzA
A=qA޸RApA(AA  AApA
A(A=qA=qAA33AzAA\)A\)AAܣAHAApAAAAffA܏\ApA޸RAzAޣA  A߅A߮A  AAAޣAffA{AA33A
=AffAAAᙚA(A(AA  A=qA=qA(A(AAApA  A\AQApA\)AA(A=qA(AᙚA33AffAA=qA\)A\A
=A33AHAAAAGAAGApA
AAQAAA\A(A  A
A
=AHAܣA܏\AzAA  AAGAAffA
AAzA
=A  A\)AGAA(AzA{ARAAGAA\ARAA
=A
ApA߅A߮AߙA߅A(A\AAffA\AA\)AAQA  A(A  A\AA\)AzA  AA  A  AGAffAA\AAAARARAAffA㙚AAA{A=qA(A\AߙApAAARApA\)AAzAGA㙚AffAAQAQARApAA
=A=qA  AݮA{A33AAA
=AApA\AA{ApA
=A܏\AڣA
AܸRAAܸRAAHA{A\)AA߅A\)AGAQAݙAAAffAݙAzAA܏\AܣAA
=ApAߙA  AzA
AGA33AݙA݅A\)A=qAHAzAA\A=qAffAA߮AffAA߅A߮A{AA=qA{AHAܸRApA=qA\)A\)A(ApAمApA\)AGAظRAzAٮA\)A؏\AHAAAAAأA=qA
AAA܏\AAAܣA  AۅA
AffA=qAffAA(AHA
=A=qAGAA=qAٙA33AHAffAݙAHA
AHAHAGAAٙAمA\)ApAׅA{A=qA(AQAQAAיA(A33A
=A׮A
A  AAGA33A=qAzA=qA=qA=qAQA޸RAzAA=qAAHA߅A߮A߅AHAffA(AAHAA\A\A\A{A{A{A߮AA
A  A
AGAAGA=qAAAA33AޣAAHA޸RA݅A33A\)A33A(A{A߅A33ApAGA޸RAAۮA\)A(A
A=qA(AGA
AffA
=AffA޸RA݅A{AApAGA{AޣAޣApA߅A߮A߮AAޣA\)AAHA=qAHA\AA
A  AzAffAA\)A=qAA(A\AffA
AᙚA{AApA\)A33ARAޏ\AQAHAᙚAA݅A߮A=qA\)A=qARAA
=ARAGAQA  ApA=qAޏ\AA(A{AGAA  AߙA  A\)AffA\)AA33Aޏ\A܏\Aޏ\AAAGAQA޸RAޣAAA{A\)A=qAffAAffA܏\AAQAAޏ\AܸRAޏ\A33A߮A(AߙAQA(AffA  A=qA
AffA
AA߅AAzA
AHA  AAߙAffA33AA{AffARA\)AA
A{AzAAAAHA\ARAA噚AA\)A
=A噚AA
=AA\A{AffAffA=qAA
=A
AzA\AGA
=ApAGAA  AAzA
=A(AHAAAA
=ARARAffAAApAAHAAQA߮AffAA
A33AQAffAffAGA
AA(AGAHA{A(A
A\)AGAAA{A33A(AAAAA33A
A=qAAAAGA
AQAAGAA{AffARAHAA
=A\)A癚A癚AGAA\)AA
A\)AAA\)A=qA
=A
=AA\A\A噚AGA(AAA  AQAffAQA(AAA噚A噚A噚AAA=qA  AAAffA
=AAAAAApA=qAHA33AHA  AAAARA  A  AffAA=qAܸRAAAۮA(A\AAGAzAAAGA㙚AAAA
A(A33A\AzA㙚AQAAAARA\)A  A=qA\AAAAA\)AA{AA  AAAHAAAffAAHAQAApAGAA  AAA=qA\A{AAAARA㙚AGApA  AQAzAA
AAA㙚ApApA{A=qA=qApAA=qA33AQA\A
=A
=AۮA܏\AAffAApAHAۅAۙAۅAGA\)AA33Aڏ\AAGA
=AHAA
=AۮA(AHA  AGAA(A\A
A߮AA(A=qAGAAHA
=A޸RA{Aޏ\AޣAA=qAA  A߮ApA޸RA߮A(AffARA(AGA=qA
A  AAzAA33AAA33Aޏ\AAAAᙚAzARAzA(AzA=qAڸRA=qA  AAAܣA
AffA(A(AzA(AݮA݅A޸RAޏ\A{A
AffAܣAHA(AA
=A
=AݙA޸RAHA\)A{A(A=qA=qAAHAA33A33ARAApA\ARAHAAQAHA
=AA{AA
=AAGA33A
=AARAA33AA\)A(AAA(A\AA=qAA  AGAAffARAA
=AAAGAA\)A33A\AAGAA=qA\AAHA(AܸRARAAޏ\AGApAޏ\AߙA\)AݮA
=AzA(A\A{A߅AAܸRAܣA  AA  A33AA  A\)A  A\)AۅA
=ApA(AzAHA\)AݙAݮA  A݅AGA\)AGAA(A
=A\)AGAᙚAᙚA{AQAffAzAAAQAzAzA\AᙚAHAzAAAAHAffAQAAA  A
AAᙚApAAA
AAAA33A\)AHAQA
=A
=A33ARAA(AA33AAffAAQAQA33AޣARA\)A  A
AHAᙚARAAA(ApA  A݅AܣAGAߙA=qAAzAޏ\A33A(A(AݮAܣAݮAݙAA
AݮA޸RAHA
=A33A
A  AffAGA\)AAQAAGAAA=qA߮AQAffA=qA\AAzAA33ApA{A=qA33AAAAApAffAQAAGARAAAᙚAAAA(AA
AA=qA(AAffA
A(ApA{AAHA(A(AzARA
=A33A  AzAA
AzAQA(AffAAAGAGA֣AA=qA\)AޣAGA޸RAݮAۮAAHA
A\)A
A=qA\)ApAzA33A  AHA
A
=AApA  AA݅A  AA߅A
AzAffARAA\ARA(ARA\AAGAGAGA33AGAAQARA=qAAAARA\AAޣA(AA޸RAߙA=qA  A  A
A\A(A\A(AGAA{A\)Aޏ\A\)AffAޏ\AAݙAHA
AApA=qAڸRAڣAڏ\AיAGA(AffApAGA޸RAޏ\AzAܸRAAܸRA
=AQAAA33A߅AQAGAܸRA݅AݙApA(A  AGA33AGAݙAA  A\)A  A(AAڸRAffAܸRA\)AݙA  AQA=qA33A(A  ApA{AۙA{AQA\)A\)A{A{AzAA{AAffA  A
AAQA
A؏\AQAۮAۅAA{AܸRA\)A
=AAffAGA
A
=A(AQA؏\A(A׮AAׅAffA
A=qA(A
=A(A  AffAffA  AمA
=ApA\)AمAQAzAׅAمA{A{A{A
=Aڏ\Aڏ\AڣAA
=A֏\B	
A  A׮A{AأAHA(AڣA(AۅA܏\AۅA  AمAظRAAڏ\AApAGAHAAܣAAAܣAA33AA33AApA=qAQAܣA=qApAHAHA
AיA
A
AA33AׅAA33A׮AQA(A؏\AمAHAAzA=qA33AApA
A{ApAAffAGAAأAיA{AAA  AٙAffA=qA  AAAٮAٮA\)A=qAQAA33Aڏ\A33A
A\)AHAAffAۅAٙAAGAA  AGAAAQA{AܸRAAܸRAAffAzAAAA޸RA{A
=AGAA=qAAApApAA(AA
=AA\)AffAffA㙚AAAA\ARAAARA(A  A{A=qA
A  AffA\AQAAA(AQARAAApAQAۅA33AA
AAأA33AڣA\)ApAHA
=AAڏ\AffAڏ\AffAzAڣAAمA=qAڣAAۅAGAA  AأAA  AۮAffAݙA(A{AۅAٮA݅ApAAAffAAzA(Aޏ\AݮAHAA܏\A{AA݅AAA{A(A=qA=qA{A  AA߮A߮A  AA=qA޸RAHAܸRAzAA33A  AGAQApAHAٮAQA(AGA33AAAAA33AۙAGA33AGAQA  AۮAAAGA
=A\)AۙA܏\AٮAffAٮApAA  A33AGA
ApA\)AzAGA\)AׅA\)Aڏ\AٮAzA  AzAأAAGAA
=AָRAzAzAՙAָRAׅA
AיAA33AיAAٙAAأAAHA{AffA\)AAHA  AHA=qAHAA\)AAAApA߮A
=AAzA\AffA{A  A=qA=qA(A\AA\AA(A(AAzAݙAA=qA33AA߅AAAzAGAޏ\AݙAffAAA
AHAA܏\A
=Aڏ\AzAzA=qAHAHAHAzA
AٮA=qAffAAAՅAQAHAڸRAQAGAA
AHAffAHAڸRAHAݙA(A  AٙAڸRAA{A(ApAۅA=qAڸRAApAمAڏ\AQAQA߅AzAAAGA\)A
AA\AHAA=qA(ApApAޣAAAHAGA  ApA\)AAߙAHAGA߅AA  AۮAۅAۅAAQAٮAA(A
A(AQAAHAۮA{Aڏ\ApAAAGAأA=qA33A=qAAڏ\AAAܣAܣAA(A(A֣A33A  AGAָRAAAݙA\)AzAٙAظRA=qAGAAQA\)A{AGA  A(AA
AffAzA߅AzA{AzAAAᙚAAQAAGAGAAAAAAHAHAAHARA{AQAARAQAzAA
AQAzA\AzA
=ApA\)A
=A{A
A
AffAᙚARAHAA
A=qAۅAQAzA(AAzAQAHARAApAA݅AA\)AأAHAAffAڏ\AHARAzAAA  AGAۮApAA\)AGAzA
AA\)ApA
AܸRAAGAA=qA33AQA߅A
AA  AAAA33AA  A
A݅AAQA\)ARAA\A=qAffAA
AA\)A=qA\A(AApAQAAޏ\A(AAᙚAᙚA\)AAzA=qAAܣAzA=qA
AٙA(AۅAڸRA݅AffA(AAAۅAA33AAڸRAffAAA
=AAHAGAظRA؏\AA\)AGAA
=AأAAA(AA(A33A
AA
A{AۮA=qAܸRAۙAzAHAAAA(A  AffAGA{AܣAHA\)A  AffAAߙA{AA
=AAޣAAAޏ\AHAAAHAHAHA޸RAޣAHAAAffAޏ\ApAGA(A33AᙚA
A{A(A(AQA
=A=qA\AAAA\)AHAޣA
=A
=ApA  A
AA(A  AA\)A(A\)AQA
=AGAA
Aޏ\AܣA߅A  A߮A33A\)A{A{ApAApApAApAffA\AA33A߮AHA
=AHAQAAܸRAzAܣAGAݮAffAޏ\A
=AGA߮A{A=qA=qA=qAzA{AARAA33A݅AA33A\)AA
=AٮA(AffAܸRAGAQAzAAQA33AzAߙA޸RApAGAAGAQAAA
=A(A\)AڣApAӮAAHA=qAAՙAA(AՙAAffA(AԸRA(Aԏ\AAҸRAҏ\AAׅA
AGAAffAAAAۅAܸRA  A\)AA=qAHAffAأAٙAڣAA(AGAۙA
=AAڏ\A33AGAffA(AA
A
A(A(A\A\AQApA\)AQA\)AffAzAGA
AGA
=A݅A  AA  A
A33ApAffAA
=A(A\AAGAAA  A=qAA
A{AᙚAffAApAA\)AA
AAᙚA
A
A
AAA(AޣAA=qA33AzAۮA33AzA
=A\)A(AAڏ\A֏\AAffAA  A{A\)AA
AAܣA=qAGA݅AݙA  A  AHAA  AA=qAGA  A\)A{ApA(A\AHA{A{AQA=qA=qA(A(A  AA
=AAQAQAzAQA\AffA\AAzA=qAApAHAAA\)A\A\)AA\)A\ApAAAAᙚAGAAHAݮAޏ\A{A޸RAHAHA  AޣA=qA݅A{A\)AݙAffA݅A\)AffAܸRA{A܏\AAA\)AHAzA\)A33A܏\A  AۙAڸRAA33A(A܏\ApA޸RAHAGAA(AAffAܸRA\)AAQAܣA
=AܸRApA  A=qAA߮AA{A(AffAzAzAzA(AAA  A(AQAQAQA  AHAߙAAffA=qAGApAA
=AffA݅AܸRA\)AAApAAApA  AQA=qA
AffAARA܏\AGAHAۙAHAۮAA  AzAHAAA\)ApAݮAA
A(AQAٙAA(AأAzA  AHA
AHAٮA33AمA
AGAۅA\)A  AQA\)AڸRAffA  AffA\)A
=AڸRA
ApAzAA\)ApAA{AA
=A33AA33AA
=A33AQAܣAAAA\)ApAݙAzAۮA33ApA33A\)A{A܏\A\)AݙAܸRA\)AܸRA  ApA\)AGA33AڸRA
=Aޏ\A=qAޏ\AzA
AzAܸRAHA
A
=AAA{A=qA=qAAA
AGAA=qAffA
AHA  AظRAAffAQAׅAיA(AAffAzA33A=qAAڏ\Aڏ\A33AظRAظRA
=AAٮA
AAٙAأAGAAظRAAڏ\AffAQAffA33AA33AݮAA=qA޸RAޏ\AAQA33A
=A33AAffA33A=qA  AGA߮A߅A
=A  AffApA33AAffA܏\A  AAQAQAHAأAffAffAظRAٮAمAAAHA=qA
AQA=qAمAGAA\)AGAzAffAHAGAHAGAӮA
AA  AQA(AA֏\AAָRAA֣AָRAffAיA֏\AAӮAA=qA(A
AQA(A{AffAAQAׅA
=A\)A\)AAAGAׅAAffA؏\AٙAzAٮAQA{AzAAzAڸRA\)A\)A33A
=A
=ApAAGAۅAA33A
=A(AQAָRA33AָRA(AظRA=qAڸRAڏ\AzAAHAAA{A\)AمAיAָRAQA(AGAԣA{A  AApAAӮA\)AA
=AHA(A{AffAzApAApAҏ\AzA33AҸRAA  A=qAңAHAңAәA
AzAAAӅAGAHAQA{A\)A{AGAGAиRAՙAA  A
AՙApAAA֏\AָRAzAffAQA(A֣AָRAָRAzA
=AffAffA(AffA֣A
=AzA׮A{A  A(A؏\AHAأA  AAAAAAծA33AAA{A
=AzApAAffAӮAA  A  AУAzAffA(AAA
=AAGA
AхA=qAծA=qAHAHA\)AAffAGAffAAיAzAffAA(AӮAffAָRA(AҸRAAAAQA33AAӅAԏ\AA  A׮A=qAٮA=qAHAڣAGAGAۅApAAGA  A=qA  AA=qA(A{AzAzAffA޸RAffA(AzAGA(Aޏ\AzAA33A  A܏\AۅA(AGAGAAGAGA\)AۮAA{AأAӮAA33A  A
A
A
AAAAAۅA\)Aڏ\Aڏ\AApAAۙA\)AGA33A
=A
=A
=AAAAۅA  A
AQA=qAQAܸRAGA޸RA޸RA޸RAAߙApAAAQAA(A(AAAGAAAGA
AAARARAARAzAzAffAffA  A
A{AAQA
A=qAQA(A{A(A=qA  AAAA=qAߙAA
AGAݮAQA
A߅A  A  A
AߙA
AGAQAGA߅AߙApA޸RAݙA߮AޣA{AffAޏ\A{AHA\)AGAܸRAAffAۮAܣAٙA\)AA(A\)ApAGA  AأAAA׮A׮AיAA{AAzA  A(A{A
A=qA=qAzAAׅAAA֏\ApA
=AA؏\A؏\A(A(A\)AzAffAzA(AffA
AԸRA{A
ApA
AA
=AA
ApAApAHA(A{A
=A׮A33A(AAAHAA(AיApAGAGAA(Aҏ\AzA
=AffAAծA
A
A(A֣Aԏ\AԸRAθRAA֏\AQAA  AԣAHA
=AAGA
AәA{AхA(AՅAңA33AHA
A
AHApAffAGA=qAAffA  A  A֏\AظRA{AQA33A  AQAzAܸRAܣAܸRAA33A݅ApA
AAGA
=AA=qA
=AffA33AGAۙA(AGA  A=qAAأA(AQAffAAQAڸRA33ApAۅAAAܸRA
AGAzA33A
=A؏\AأA=qA  AGA
=AHA(A(AծA\)AՙAԏ\AAAAAHA  A֏\AApAңAAAAGAA=qAA{AA\)A֏\AGAffApA׮A  A=qAA=qAHAٮA=qAA{ApAA(AQA=qA=qA=qAA33A\)AA  A\)A݅A{AzAHA\)AHAۅAڣAݮA33AܣA
=AAA(AܸRA߮Aޏ\A=qA݅A=qAAQAffAGAHAHAGA߮A޸RA33A
ApAA=qAffAffAzA
AffA
A\)AיAApApA
=A\)AA  AA  AمAA(ApAGA{AAQAAAݙA  A=qA
=A
AGAAAAA33A\)AAzA
=AۙA=qAAݙAGAAQAAAޣAffAQA(AA߅AAAߙA߮A  ApA  A\)AAAᙚAޣA{A(A
=AHAA33AA
A{A\AA
A  A
A  AffAAA
A\)AA  A  AAAA\)AAHA{A\)A(AA{AߙARAHAffAۙA\)AڣA
=AffA
=Aޏ\AAA
=A\)ApA\)ApAAffAA33A\)A
=A{AAA33A  ARAAA(AffA33AᙚAAA  A  AQA  AffA\AGA
AAAHA
=AHAHApA
AA\A(A
A  AAA
AAAA{AA
A\AQAA噚AffA(ARAA\)AffA
A
=AAQAQA=qAHAA{A\)A33A݅ApAApA(AGAޣA  A33AffAffAQAָRAAָRA=qAA(A33AܣAޣAQA  AQAQA
A޸RAHAA
=AGA\)AAAAܣA(AffAAA(A=qAGA
A=qAAݙAAHA߮AQAffAAߙAޣAA(A
A
=AA=qA{ApAݮA=qA  AA33ApA=qAA{AQA\)AߙAA߅AޣAffA=qAGApAمAظRA(A
=A
A\)AٮA(AAzA؏\AffAأA\)A33AzAQA=qAQAAأApAAمAٙAٮA\)AA{A\)A؏\AGA  A(A(AHAָRAHAffA(A
=A  AָRAGA{AAA֏\AQAzA؏\AAأAzApA
A=qAHA=qAAAޣAޣAޣAA=qAffA޸RA޸RA(A{A(AGAܣA{AA
=A33AAzAQAۅAۮAGA33A=qA(AQA޸RAޏ\AޣAޏ\AHAA{A33ApAAzAzAޣA{AA߮A߅A\)A
A
Aޏ\AffAQA{A\)A
=A=qApA܏\A{AمAGAܣA33A
AQA(AܣAA33ApAQApApA=qA܏\A
AffApAA=qA33AAGA{AظRA
A
A33AأApAApAA(A݅AܸRAܣA߅AHAHA߮AffA߅A
A  A{A  A
A  AHAAAffApAA߮A
AAA߮AA=qAA\A=qApAAHA
=A܏\AffA(A=qA{A  A=qAffA  AمA܏\AHAAA  A؏\AٙAٙA܏\AHAܣAffA33A
A  A\)AׅAzAffA֣AffA֣AՙA
AA=qAApA33AGAQAAׅAA׮AAQA(AGA\)AAzAffAA{A(AۮAڸRAAA{A܏\AApA
AAHA
=AApA\AHAAHARAA=qAGAA33AAᙚAAAA
AAAHAffApA߅ARAA\A(A{A
=A\A߮AQAA
AAAߙAGAޣAA߅AݙAHA߮A߮ApAAQAمA
AffAGA33A
=Aޏ\AHA
AمA
A
AGAA=qAۅA  AAܣAffApA(AHA݅ApAffAQAA
AڸRAڸRApA(AffA
AHAHAڣAAڸRAQAAAڏ\AA  A  AAAA33A݅A  Aޏ\AAݮAޏ\A(AQA=qAzAGAAffAAA܏\A(A(AٙAAGAzAHApAA
=ApAڣA
AffA\)A
A\)AA=qAAQAA܏\AQAڏ\A{A\)ApA{AظRA  A
ApAHAׅAQA=qAQAAHAAۮAA(AGA
Aڏ\AA֣AzAAمAAGA=qA  A(AzAAٮAڸRAffA=qAۮAA{A\)A=qA(AffAzAQAzA޸RA\)A(AA
=ApAA܏\AA
AA
=AAA߮AAA  A
A
Aޏ\AzA֏\AۙA߅A  A33AAٙA33A(A{AffA  A
=AAܸRA\)A=qA(AAGAA
=A=qAޏ\AAA܏\A(AHApA\)AA\)Aڏ\AٙA33A{AAمAڸRAA  A33A{A{AڣA{AAffAQA=qAQAA{AAܸRAݙA\)A
A
A  A33A߮A߮A(AzARAAApA߅A\)AAᙚA\)AA
A߅AHAQA\A33A\)AݙA\)AA  A=qA֏\AGAޏ\AAڣAAA
=AzA
A
AzA  A؏\A
A=qAٙAۙAGA(A
=A
=A{AffAA݅A
=A\)AA܏\AGApAծA{A
=AQA
=A(Aڏ\A(A  AԣAGA  AQAHAיAQA(AAAAA
=A(AAGA{A{A  AzAQAA܏\AzAܸRAA݅AGAAAޣAA\AApA(AQAAGA  A=qA㙚A33AQApAAQA\)AA(AAܸRAAGAAQA
A߮AAQA
AAHAAApA\)AᙚA=qAGAApAffAܸRAffA݅AڸRAffA  AAڏ\AAQA=qAA
AA֣A
A{AAAׅA  AظRAQAأAمAA=qA
=AA(AޣAA
AGA
=A
AzA{AA{AޣAݙAApAzA  A  A=qAQAܣA\)A=qAA=qAAffA=qA=qA33AᙚA(A{A\AApAAA=qAzAAzApApA\A=qAAAQAzAAᙚA{AA
AᙚAߙA=qAAAzAAA(A߮ARA\AHA\A߮AAQAzAޣA  A(A߮AޣAޏ\ApApAޣA
AݙAA  ARAݙApA޸RAߙAHA  AۙAܣAܸRAݙAݮAA  AݙA\)A
AApA
AߙA=qA
A\)AzAHAޣA܏\A܏\AܣAffAApAAQAAA߮A߅AAA  A=qA(A=qAQAzAQAHAzAAAffA
=AᙚA{AAHAA(AAA{AffA\)A{ApA\AHA
AHAAA
A
A33A߅A
=AzA  AݙAHAܣA\)A\)AGA
AffAAأAzAٙAAܸRAGAۅAQA\)AܣAGAAA33AA
=AGA=qAA߅AAzAAߙAܸRAݮAQAݙAAA\)AHAHApA߅AzAAAA  AffARA
=AAffAQA  A(AQA㙚A
A{A=qAzAzAzARAzAzAQAffA{A
AGA33AGAᙚAzA(AzA{ARA33ARA\A=qAA\)ApAߙAzARA=qA
ARA
A\)AGAHA{A  A
AA܏\A
=A
=A
A
=A  A  A33A(AA\)AGAݮAHAAQAAA݅A  AffA{A=qA  ApA\)A(Aޏ\AHAAzA\)AGAA  AڸRAGA
=AzAHAA(AA\)A33A  A(A(AܸRA  A\)A33AHA=qA
AAA݅AHA
A\)AA(AمA(AۅAAAA=qAffA\)AHAffAzA{Aڏ\AA܏\AQAܸRA=qA33AAQAffAQA=qA
=Aޏ\A
A=qAQA(A=qA33AߙA  AA(A  AA\AA
=AA
=AߙAߙA  A=qAٮA
AۅA
A\)AffA
=AffA޸RA=qAffA=qAޣAޣA33AGAGAA߮A(AݙAAA{AڸRAGA؏\AأAA  AAQAA{AzAA(A{AQA׮AׅAAffA{A  AA{AAQAٙAAzAffA(AݙA
AܸRAڸRAAܸRA݅AGA\)AٙAHA\)AAHA
=AAAۙA{AQAٮA\)AAظRAzA(AQAAA33A{AA֣ApA(A
AffA=qAأAA33AڣAA
=A
AffAظRAGAQAۮAzAڣA{AAGA33A  A܏\AGA
AߙAA܏\A
=A=qA{AHAٮA
A܏\AApA
=AQAڣAڏ\AGAAGAۮAۅApAAHAۅA
AA{A
A
=AGAHAAۅA܏\ApAffAzAffAڣAڸRAAA{A\)A33A\)AffAHAAظRA
=A
=A{AٙAA\)AA=qAAAGAffA=qA{A֣AQApA(AԸRAA؏\AӅA(AAffA{AՙAAzA
A{A{A=qA
A{AA׮AA׮AHA  AAڸRAAzAQApAApAمAHAٙAAأAׅAAffA=qA֏\AAׅAA  AAۅAGA\)A  AA33A\)AAQAٙApA(Aڏ\AGAAڸRAGAٮAۙA\)A33AڣAzA\)AظRA=qAAApAzAۮAHAHAٮA(AٮAأAffAffA{A{A
AffAAAGApA\)A
=A
=AיAffAָRAיA{AA֏\AA
=A׮A33AAمAGAٮA
A  AQAיA
AGApAׅAHAׅAיA
AQAApAمA{A=qAڣAA\)AۮAۙA\)AۙAzA  A  A
A(A
AAۅAۅApAHApAA{AܣAA
=AAAHA
=AٮAڣAAGAffAQAA
=AzAffAAٮAGAمA
=A(AAٙAGAمAיAAHAAՅAծAzA  AAAHAHAffAA֏\A
=AA
=AGAGAAظRAGAمAA؏\AGAffA33A֏\A؏\ApA
A=qAA{A(Aڏ\A\)A  AAzAAۮA\)AGA
A{A  AzAA33AݮAݮA{A{AAQA޸RAAffAAߙA߮AQAffA{A߮A  A
A܏\AAGAڸRAffA{AۙA
=AHAA33AffA(AA
AffA(A(A݅A݅A
A
=Aޏ\A{ApAA{AA\)AHA(A\)AAffAAzA
AQA֣AمA33AzAA  AffAԏ\AA{AAA  A
=Aڏ\AAأAQA  A
=A(AAAHA
=ApAAzAAA{AHA
=AA
A{AQA޸RAޣAAHAޣA\)AGAAA
=A
=A
=AHA(A{A߅AAA
=AAޏ\A  A޸RA޸RAzA=qAޏ\AA߅AA  A{A(A
A߮AA߅AAAApA߅A޸RA(AQAffA(ApAQA޸RA\)AۮA؏\AA=qAݮAffA
AHAHAQAQAAzAQA=qA޸RA
=ApApAAA=qAۙAAzA߮A\ARAAGApAܸRApAQAzAAۅAڣAٙAHApA  AzA(A=qA
A\)AAffAzA
ARAڣAGARARA  ApAzAGA33AA33A
AApA=qA{A  A(A{AAAffA(A\)AA{AQAAzAAAAAQAAzAAzAAzAAAzAAzAۙAHA=qA
=AA
=AݙAzAQAGAݙAQAA\AHAzA߅AA߮AA܏\AAGAGAޏ\A
AۙAAظRA؏\A(AGA  AQAA݅AܸRA33A33AGAAQAA{A݅AܣAHAڣAAۮAGA33AApA  AAޣAޏ\AߙAAA=qA{A݅A33A
AۅA
AzAHAQA{AA33AzAޏ\AGAQA
=AQAޣAQAAQA{A
=A\)AApAHA=qAA  A\)A
AA=qA{A33AAA
=A{A݅A
=ApAAڸRAApA
AمA؏\AHA
=A33AأApAffAHAظRA؏\AApApAA{A(AffAffAޣAޏ\Aޏ\AޣA33A
=AAHA޸RAޏ\AffAffAzAA߮A\AffA{A{AffAQARA\A(AA\)A  A
A33Aޏ\A33AA33AGApAApAA
=AA߅AQAݮAQAGA(AGAzA=qA=qA  AAApA(A؏\AAAAיA
AٙA
AffA(A33A{AՅAAA\)A
=AѮA
AAAQAAGA
AffA
AQAHA  A  AAAffA(AHAAۮAAAQA܏\A  A݅AGAzAA(AffAA=qA=qAGA܏\AAGAGAAAAffA33AA  AAQAA
=A\)AffAڏ\AAA  AGAۙAAHAڣA=qA=qA{AAمAffAAיAA33A33AAA\)AQA{AGApAԏ\AAGAAHAHAأAأAffAHAHAٙAffA
=AAܣAA܏\A{AA\)Aڏ\A\)AHA؏\AAzA=qAA
AzAzAمAGAA33AڸRA
=ApAۮAA(AffA܏\AHA
=AA\)AHAHAHAܸRAܣAAۙAA\)A܏\AAHAܣAGA\)ApAAAޏ\AAA޸RA(AzA(AAۙAffAAAAGAA(ApAffA
AHAHA(AzA\)AAAۙAffAمAڣAمAAٙAA\)A(A
A33A  Aҏ\A=qAA{A
=A֣A  AיAظRAAۅAۙA{A{AA
A
AA݅A\)AٮA  Aڏ\A\)A{A33AAAzAAAAGAݙA33AA33A  AܣAA݅A݅A܏\AA33AffAAGAׅAۮA\)AQA=qAHAAHAHAAffA(A(AGAٮAٮA
A
A(AۅAffA\)AܣA=qAمA
=AA
A(AAAڸRAڣAڏ\AAGA=qAffA{A=qAAffApAՅAӅA33AffAAQAAظRA
=AA33AAGAAHA33AمAٙA
=AՅAzAAffAمAA=qA
AأAffAمAۅAHA\)A=qAAApAAمA
=AHAAzAffAظRA؏\AQAظRA(AAHAAHApApAڸRA  AzAffAQAffAAA{AڸRA{A{AAAGAAA=qA  A=qAGA(ApA\)A܏\AA(AٮAٙAffA  A(A(AAمAمAA؏\A׮A
=AָRAׅAAffA\)AA=qAٙAיAA(AAQAՅA33A  AQA\)A(A{AA33AָRAffAHA(AمA  AHA  ApAٮA
AAzA  AzApAHA
=AAAأAظRA  A\)A֣AA
AٮA33AمA
=ApAAٙAۅA
=A(A
AzA{AAffAڸRA33AۅA
AffAQA\)A=qAمAׅAָRAzAzAAAԏ\AQA(A  A=qAffA
AffA{A33AGAAљApApA33AQA
=A  AHAA\)AA  AظRA  A33A
A  ApApA  AApA33A33AQAA(AA؏\A\)AffAA
A{AffAA33A
A=qAA(AܸRA܏\AܸRA=qA=qAڏ\Aڏ\AمAڸRAffAzAAQAޏ\AݮAffAݮA  AAffAzA(AHAޏ\Aޏ\AApAAAGAAA  AGAڏ\Aڏ\AffA(A(AGA
=AٙAڣA=qAۙA{AAGA(AzAAGAGAffAHAHAHA\)ApAԣAԸRAAٙA=qAA؏\A\)AffAzAHAGA\)A֏\AA֏\AָRAיAzAApAAQA  AQAGAHAffApApAٙAمAA(A(AQAיA=qAٙA  AٮAQA\)AٙAمA(A{AAۅA=qAGAHAAAڣAQA33AAffAzA=qA33AA
AApA(A=qA{A  AffA=qAQAڸRAzAڸRA
A=qAHA(AGA׮A֏\AA  AAծApA
=A(AA
=AGAAծA֣AQA֣A֣AA\)A33AAׅAA=qA33AffA=qA֏\A
A
A=qAԏ\A(AՙAAָRAAיAHAA=qA
A=qA(AՙA  AՙA(AָRA֣AGAHAffAHAظRAQAHA\)AHA֏\AׅAAQAׅApAA\)A
AffA(ApA\)A(AzA(A=qA{AAA(AQAA
=AA  AzAzA=qApAAңA=qAѮAQAѮA  AׅApAffAָRAA{A(ApAԸRAҸRAѮAA
A=qA(AffAGAGAָRA33AHAffA{A
AAՙAA\)A
A\)A
=A
=A
=AՅAԸRAApAՙA=qA
=A
AA{AׅA׮A
AAٙAGAA(AffA  ApA  AA\)AAffA
A֣A\)AffAffAծA\)AمA؏\ApA(AffAA  A(AAA֣A֏\A֣A=qAAApApA33ApAGA33AGA\)A  A؏\A{A  AAGAٮA
A33AՅA֏\AA33AGAָRAffA
=ApAGAՙA=qA
AԸRAHAQAׅAAAظRA׮A\)A=qAGA  AQA׮AׅA33AA=qA=qA33AffAA33Aڏ\A܏\AܸRAܣAGAAܣAAۮAAAۮA
A
=AGAzA=qAQA
A(Aޏ\A݅AׅA=qA  A33A33AA
AffAٮAA{A{AיA(A܏\AA\)A(A(A
AأA؏\AظRAיAAA33AzAHAܸRA33AۅA(AAA=qAיAָRA
AAӅApAՅAGA(AAzAzAԏ\AGAffAA
AڣAffAܸRAۅAۙAzAظRA؏\AHA(A(AzAڸRA
=AA33Aڏ\A=qAٮApA{AڣAHAApAA  AAڏ\A{A  AGApAأA
AA\)A(AA=qAffAHAՅAAffA(AGAAAיA{AڣAzAڣA
=A=qA  A33AQA(AQAGAAA
AHAApAAQAAHAApA=qA=qAиRA=qAffAAffA33A=qAApAHAAAՙAHA{AAffAיAAծAָRA
AzA=qAGA(AׅA33AAffAGAAA
A  AڸRAܸRAݙAHApA߅AA(AQAzAQAAffA݅A=qAA(A33A{AܣA܏\AݙAݮAAGA݅AA
=AAAzA33A(AۙAۮAA
A
AA
AۮAۮAzA(AAAQAA  A؏\A(AٮAمAAAAA  AAٮAGAffA
AָRA33A=qAA=qA33AAׅA
AzA{AָRA\)AA  A\)A
=A=qApAA׮AأAٮA  A(AQAڏ\A
=A33AAffAzAffA(AAۙAۙAffA
AffA
AHAHAGAAߙAffAA\ARAA߅ARARAzAA
A33A\)A(A܏\ApA
AQAAHAGAܣA
=ApAAۮA
=AAffA
=A(AA
=AۮAڸRAۮA  ApAۙAݙAGAۙAA
AGAۅA{AۅAGAAQA(A
AAAܣA
=AܸRAHAGAQAAڣAۮAGA{A33A
AHA
A=qA\)A\)AٙA=qAzAڸRAGAAzAA=qA܏\AffAffA܏\AQA=qA܏\AzAffAAffA
=AݙA݅A\)AzAGAffAHA\)AffAظRA33Aڏ\AAڣAڸRAA
=AۮA(A\)A=qAܸRA33AܣAۮA܏\A33AݙAݙA(AA33AߙA߮A߮A߮AA߮A߮AߙA߮A߮AQAQAޏ\AޣAA  AAHA
ApA߅A(A
=A33A(A߮AAߙAA  A{AHA
=A{AݮAGA߮A߅AAAGA=qAffA
=A(AA(AGAA{AffA\AAAAA
A  AQA\AAAffAA(A33A
=AAffA\A\AzAA  A(AHAA\AAffA  AᙚAA  AᙚA=qAHAᙚApAA
AGAA
A(A{A  A\)A  AA
A
A{A(A(A(A  AApA\)AApAA\)A\)AGAܸRAٙA(AAzA33A(ApAA(A(AA33AޣAޏ\AHARAzAffAHAAGAAzA\ARAAA
=AffAߙA33A
AݙA݅AݮA
=AHA
=AffA33AApApA  AAA{AA=qAQA߅ApAHAAڸRA֏\AQA(AA
=AHA
=AGAAA  A33AGApAzAڸRAA
=AڣAڏ\Aڏ\Aڏ\AڸRAAA=qAۮA
A(AffAzAHAHA݅A݅AڣAQAAܸRAۙApA(A=qA33A{AAAHAAA  AffApAffAQA(AGAӮA{AffA33AzA{AffAӅApAHAffAҸRAHAffA(Aԏ\AffAA(AA؏\AAA  ApAՅAGA{ApA{AzAzAGAۮAzAA\)A{AٙAأA33AAAڸRAzAHAA
ApA
=AGAHA܏\AGA܏\A\)A33A޸RAffAAffAAGA  AܸRA\)A(A  ApAڸRAHA  A
AظRAHA33A\)AQAHA33ApA
A׮AffA
=A33A(AAffAAۮA33AAAA(AHA33A{A
=AApA33A܏\AA݅A
AA
AGA(AHA׮AApA  AA֏\AGAAA33AיA
A{AA
A
A׮A׮AׅA{AAAظRAffAA؏\AA=qA  A
=A=qA
=A33A
=A
AA(AQA=qAۮAAHA޸RAHApAApA(AffAܸRAAzApApAݮAݮA݅AAHA
=A\)A݅A33AݙAGAGA33AGAGApA݅AAA
AA  A  AA
AA33AAݙA
A{A=qAAA
=A߅A߮A
A
A
AAA޸RAGAAAGA
A  Aڏ\AڣAۅAۅAAQAGAݮAzA݅A
AݮA{A=qAGAQA33A
=A{AAۙAAمA{AظRAQAGAAA
=A֏\AQAAffAHA{AQAA\)AٙAAA=qA
AمA
AٙAمAGAGAA33AGAAAAAAظRA(A(AظRAA
AAQA33AۙAۅAՅA=qA(A{Aڏ\AA  AA܏\AܣAۙAۮAٙAۮAAAݙA݅AݙAݮAܸRAܣA33A  AAQAAA
AݮA\)AݮAAAۮAۮAۮA
AۮA  AffAA{AA  A
=AܣA\)A܏\AAۮA  A=qA
=A{ApAApAޏ\AApA
A
A(AHA33AٮAڣApAzAٙA=qA
AzAAAݙA
A=qA33A޸RAHA
=AݮA\)AܸRA=qAAޏ\A33AAzA
=AA޸RAAzAAߙA  AGAAA  A
Aڏ\A
A
AAڣApA  A
AAHAA
AܣAܸRAAffA=qAۅAۮAۅAApA(AAzA(A
=ApA
A
A\)A׮A(AzAffA؏\AAHA׮AA  AיAAffAڸRApA=qA(A\)AڸRAڣA{AAAمAڸRAAۅAAܣA܏\A=qAQAۮA  A
A  AffA܏\AffAQA=qA܏\A
AffAיA
A\)AA߮AAAA(Aڏ\AٮAمA\)AGAظRAمAAA؏\AأAAHAٙAٮAٙAمA  A{A(AzAA\)AظRAzAمAA=qA(AۙAAڏ\AHA\)A
A(AAffAۙAAGA
=AA
=AڸRAAGA  AAffA܏\A܏\AffAܣAܣA܏\A܏\A\)AApA
=A{AHA؏\A؏\AڣAڣA{A
AAHAQAٮA܏\A݅AݙAݮAAA  ApAQAffA(ApA\)AٮAGAzAQAHAzAA=qAHA֏\A
=AיAA33ApApA33AAAA֏\AՅAӮAAAѮAAAAԏ\AHAAԸRAԸRA(AffAԏ\A
=AAffA=qAHAA
=A(AԣAԣAӮA(Aԏ\AAԸRA\)AGAAծAծAAAzA֣AAGA  A
A{A33AՅA33AՙA\)A֏\AׅAffAffA؏\AAGA
=AָRA  A{AיAAAAHAיA=qA33AGA=qAzAQA=qAQAA׮AיA=qA{AظRA(AAQAA(AQAffAA{ApAٙAAمAمAٙAGA33AGA\)A=qA  A=qAڏ\AHAzAAffA=qAٙA(A{AzAAٙAڏ\ApAظRA
=A(AأA=qAAAٙApAޣAA݅A
A33AٙAQA{AQA\)AׅA33A׮AأA(A  AAׅApAAA  AׅAA׮AHAأA
=AAۮA  AHA33A
=A33A֏\AՙAzA\)A\)ApApApAGA33AA  AљA33AՙA  AAAՅAAHA(AAAиRAAQAGA  AظRAGAAHA\)A
=A\)AAAA\)AمAQA(A(AzAffAңAHA\)A\)AәA\)AәAHAAӅA{A(A
A
=AA=qA33AɅAAA
=A\)A
AHA
A  AˮA̸RAzAA\)A\)A{AffAA\)AA
=AHAAAAAAѮA(A\)AApA
AQAAңA
=A(AzAAzA33AAApAAӅA{A  AAӮAffAQAϙA\)AAffAffAͮAzA  ApAУAA
AңAQAApAffAЏ\AzAϮAAHAиRA\)AQAҏ\AҸRA
AAQAA  AzAHAʣA=qAͮAA  AGAѮA(A(AApA33AѮA(Aҏ\AAGAәAffAG                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                       