CDF       
      
timeseries        obs   2+   station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:13:59Z http://pacioos.org
2022-11-15T19:13:59Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2011-01-01T00:00:00Z&time%3C2012-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2011-12-31T23:45:00Z   time_coverage_resolution      PT30M      time_coverage_start       2011-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      AG   Aӿ      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      X r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      AAH   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       Ȭ <   salinity                   _ChunkSizes                
_FillValue        y    actual_range      @
BR   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       Ȭ    	turbidity                      _ChunkSizes                
_FillValue        y    actual_range          A     ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       Ȭ    chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      \)CH   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       Ȭ ^@   oxygen                     _ChunkSizes                
_FillValue        y    actual_range      @A(     ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       Ȭ &   oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      BC    ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       Ȭ    ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       Ȭ D   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AAH   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       Ȭ    temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range               Ȭ 	I   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ 
H   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ 
   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ    temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ lL   temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ 
4   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ 
   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ P   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ    temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ W   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ  T   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ     temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ    temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     Ȭ zX   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     Ȭ C   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      @
BR   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       Ȭ    salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range               Ȭ \   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ    salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ e   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ .`   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ    salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ    salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ d   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ Q   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ    salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ h   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ    salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ s   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ <l   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     Ȭ     salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     Ȭ     
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range          A     ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       Ȭ !p   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range               Ȭ "_   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ #'   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ #t   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ $    turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ %   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ &Jx   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ '$   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ '   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ (|   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ )m(   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ *5   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ *   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ +,   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      \)CH   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       Ȭ ,   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range               Ȭ -X   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ .!0   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ .   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ /   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ 0{4   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ 1C   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ 2   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ 28   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ 3   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ 4f   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ 5/<   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ 5   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ 6   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range      @A(     ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       Ȭ 7@   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range               Ȭ 8Q   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ 9   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ 9D   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ :   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ ;t   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ <=H   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ =   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ =Π   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ >L   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ ?_   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ @(   
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ @P   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ A   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      BC    ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       Ȭ B   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range               Ȭ CKT   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ D    oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ Dܬ   oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ EX   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ Fn   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ G6   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ G\   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ H   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ I   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ JY`   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ K"   oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ K   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ Ld   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       Ȭ M|   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range               Ȭ ND   	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     Ȭ O
h   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     Ȭ O   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     Ȭ P   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Ȭ Qgl   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     Ȭ R0   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     Ȭ R   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     Ȭ Sp   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     Ȭ T   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     Ȭ UR   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     Ȭ Vt   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Ȭ V    	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Ȭ W   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       - Xux   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     	h Y|   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    Ä c
Ap?  wqb_04  AG   AG   AGb   AGC   AG$   AG   AG   AG   AG   AG   AGj   AGK   AG,   AG
   AG   AG   AG   AG   AGr   AGS   AG4   AG   AG   AG   AG   AG   AGz   AG[   AG<   AG   AG   AG   AG   AG   AG   AGc   AGD   AG%   AG   AG   AG   AG   AG   AGk   AGL   AG-   AG   AG   AG   AGƱ   AGǒ   AGs   AGT   AG5   AG   AG   AG   AG͹   AGΚ   AG{   AG\   AG=   AG   AG   AG   AG   AGբ   AGփ   AGd   AGE   AG&   AG   AG   AG   AGܪ   AG݋   AGl   AGM   AG.   AG   AG   AG   AG   AG   AGt   AGU   AG6   AG   AG   AG   AG   AG   AG|   AG]   AG>   AG   AG    AG   AG   AG   AG   AGe   AGF   AG'   AG   AG   AG   AG   AG   AGm   AGN   AG/   AG   AG   AG   AH    AH   AHu   AHV   AH7   AH   AH   AH   AH   AH   AH	}   AH
^   AH?   AH    AH
   AH
   AH   AH   AH   AHf   AHG   AH(   AH	   AH   AH   AH   AH   AHn   AHO   AH0   AH   AH   AH   AH   AH   AHv   AH W   AH!8   AH"   AH"   AH#   AH$   AH%   AH&~   AH'_   AH(@   AH)!   AH*   AH*   AH+   AH,   AH-   AH.g   AH/H   AH0)   AH1
   AH1   AH2   AH3   AH4   AH5o   AH6P   AH71   AH8   AH8   AH9   AH:   AH;   AH<w   AH=X   AH>9   AH?   AH?   AH@   AHA   AHB   AHC   AHD`   AHEA   AHF"   AHG   AHG   AHH   AHI   AHJ   AHKh   AHLI   AHM*   AHN   AHN   AHO   AHP   AHQ   AHRp   AHSQ   AHT2   AHU   AHU   AHV   AHW   AHX   AHYx   AHZY   AH[:   AH\   AH\   AH]   AH^   AH_   AH`   AHaa   AHbB   AHc#   AHd   AHd   AHe   AHf   AHg   AHhi   AHiJ   AHj+   AHk   AHk   AHl   AHm   AHn   AHoq   AHpR   AHq3   AHr   AHr   AHs   AHt   AHu   AHvy   AHwZ   AHx;   AHy   AHy   AHz   AH{   AH|   AH}   AH~b   AHC   AH$   AH   AH   AH   AH   AH   AHj   AHK   AH,   AH
   AH   AH   AH   AH   AHr   AHS   AH4   AH   AH   AH   AH   AH   AHz   AH[   AH<   AH   AH   AH   AH   AH   AH   AHc   AHD   AH%   AH   AH   AH   AH   AH   AHk   AHL   AH-   AH   AH   AH   AH   AH   AHs   AHT   AH5   AH   AH   AH   AH   AH   AH{   AH\   AH=   AH   AH   AH   AH   AH   AH   AHd   AHE   AH&   AH   AH   AH   AH   AH   AHl   AHM   AH.   AH   AH   AH   AHĲ   AHœ   AHt   AHU   AH6   AH   AH   AH   AH˺   AH̛   AH|   AH]   AH>   AH   AH    AH   AH   AHӣ   AHԄ   AHe   AHF   AH'   AH   AH   AH   AHګ   AHی   AHm   AHN   AH/   AH   AH   AH   AH   AH   AHu   AHV   AH7   AH   AH   AH   AH   AH   AH}   AH^   AH?   AH    AH   AH   AH   AH   AH   AHf   AHG   AH(   AH	   AH   AH   AH   AH   AHn   AHO   AH0   AH   AH   AH   AH   AH   AI v   AIW   AI8   AI   AI   AI   AI   AI   AI~   AI_   AI	@   AI
!   AI   AI   AI   AI
   AI   AIg   AIH   AI)   AI
   AI   AI   AI   AI   AIo   AIP   AI1   AI   AI   AI   AI   AI   AIw   AIX   AI9   AI    AI    AI!   AI"   AI#   AI$   AI%`   AI&A   AI'"   AI(   AI(   AI)   AI*   AI+   AI,h   AI-I   AI.*   AI/   AI/   AI0   AI1   AI2   AI3p   AI4Q   AI52   AI6   AI6   AI7   AI8   AI9   AI:x   AI;Y   AI<:   AI=   AI=   AI>   AI?   AI@   AIA   AIBa   AICB   AID#   AIE   AIE   AIF   AIG   AIH   AIIi   AIJJ   AIK+   AIL   AIL   AIM   AIN   AIO   AIPq   AIQR   AIR3   AIS   AIS   AIT   AIU   AIV   AIWy   AIXZ   AIY;   AIZ   AIZ   AI[   AI\   AI]   AI^   AI_b   AI`C   AIa$   AIb   AIb   AIc   AId   AIe   AIfj   AIgK   AIh,   AIi
   AIi   AIj   AIk   AIl   AImr   AInS   AIo4   AIp   AIp   AIq   AIr   AIs   AItz   AIu[   AIv<   AIw   AIw   AIx   AIy   AIz   AI{   AI|c   AI}D   AI~%   AI   AI   AI   AI   AI   AIk   AIL   AI-   AI   AI   AI   AI   AI   AIs   AIT   AI5   AI   AI   AI   AI   AI   AI{   AI\   AI=   AI   AI   AI   AI   AI   AI   AId   AIE   AI&   AI   AI   AI   AI   AI   AIl   AIM   AI.   AI   AI   AI   AI   AI   AIt   AIU   AI6   AI   AI   AI   AI   AI   AI|   AI]   AI>   AI   AI    AI   AI   AI   AI   AIe   AIF   AI'   AI   AI   AI   AI   AI   AIm   AIN   AI/   AI   AI   AI   AI³   AIÔ   AIu   AIV   AI7   AI   AI   AI   AIɻ   AIʜ   AI}   AI^   AI?   AI    AI   AI   AI   AIѤ   AI҅   AIf   AIG   AI(   AI	   AI   AI   AIج   AIٍ   AIn   AIO   AI0   AI   AI   AI   AIߴ   AI   AIv   AIW   AI8   AI   AI   AI   AI   AI   AI~   AI_   AI@   AI!   AI   AI   AI   AI   AI   AIg   AIH   AI)   AI
   AI   AI   AI   AI   AIo   AIP   AI1   AI   AI   AI   AI   AI   AIw   AIX   AJ 9   AJ   AJ   AJ   AJ   AJ   AJ   AJ`   AJA   AJ"   AJ	   AJ	   AJ
   AJ   AJ   AJ
h   AJI   AJ*   AJ   AJ   AJ   AJ   AJ   AJp   AJQ   AJ2   AJ   AJ   AJ   AJ   AJ   AJx   AJY   AJ:   AJ   AJ   AJ   AJ    AJ!   AJ"   AJ#a   AJ$B   AJ%#   AJ&   AJ&   AJ'   AJ(   AJ)   AJ*i   AJ+J   AJ,+   AJ-   AJ-   AJ.   AJ/   AJ0   AJ1q   AJ2R   AJ33   AJ4   AJ4   AJ5   AJ6   AJ7   AJ8y   AJ9Z   AJ:;   AJ;   AJ;   AJ<   AJ=   AJ>   AJ?   AJ@b   AJAC   AJB$   AJC   AJC   AJD   AJE   AJF   AJGj   AJHK   AJI,   AJJ
   AJJ   AJK   AJL   AJM   AJNr   AJOS   AJP4   AJQ   AJQ   AJR   AJS   AJT   AJUz   AJV[   AJW<   AJX   AJX   AJY   AJZ   AJ[   AJ\   AJ]c   AJ^D   AJ_%   AJ`   AJ`   AJa   AJb   AJc   AJdk   AJeL   AJf-   AJg   AJg   AJh   AJi   AJj   AJks   AJlT   AJm5   AJn   AJn   AJo   AJp   AJq   AJr{   AJs\   AJt=   AJu   AJu   AJv   AJw   AJx   AJy   AJzd   AJ{E   AJ|&   AJ}   AJ}   AJ~   AJ   AJ   AJl   AJM   AJ.   AJ   AJ   AJ   AJ   AJ   AJt   AJU   AJ6   AJ   AJ   AJ   AJ   AJ   AJ|   AJ]   AJ>   AJ   AJ    AJ   AJ   AJ   AJ   AJe   AJF   AJ'   AJ   AJ   AJ   AJ   AJ   AJm   AJN   AJ/   AJ   AJ   AJ   AJ   AJ   AJu   AJV   AJ7   AJ   AJ   AJ   AJ   AJ   AJ}   AJ^   AJ?   AJ    AJ   AJ   AJ   AJ   AJ   AJf   AJG   AJ(   AJ	   AJ   AJ   AJ   AJ   AJn   AJO   AJ0   AJ   AJ   AJ   AJ   AJ   AJv   AJW   AJ8   AJ   AJ   AJ   AJǼ   AJȝ   AJ~   AJ_   AJ@   AJ!   AJ   AJ   AJ   AJϥ   AJІ   AJg   AJH   AJ)   AJ
   AJ   AJ   AJ֭   AJ׎   AJo   AJP   AJ1   AJ   AJ   AJ   AJݵ   AJޖ   AJw   AJX   AJ9   AJ   AJ   AJ   AJ   AJ   AJ   AJ`   AJA   AJ"   AJ   AJ   AJ   AJ   AJ   AJh   AJI   AJ*   AJ   AJ   AJ   AJ   AJ   AJp   AJQ   AJ2   AJ   AJ   AJ   AJ   AJ   AJx   AJY   AJ:   AJ   AJ   AK    AK   AK   AK   AKa   AKB   AK#   AK   AK   AK   AK	   AK
   AKi   AKJ   AK
+   AK   AK   AK   AK   AK   AKq   AKR   AK3   AK   AK   AK   AK   AK   AKy   AKZ   AK;   AK   AK   AK   AK   AK   AK    AK!b   AK"C   AK#$   AK$   AK$   AK%   AK&   AK'   AK(j   AK)K   AK*,   AK+
   AK+   AK,   AK-   AK.   AK/r   AK0S   AK14   AK2   AK2   AK3   AK4   AK5   AK6z   AK7[   AK8<   AK9   AK9   AK:   AK;   AK<   AK=   AK>c   AK?D   AK@%   AKA   AKA   AKB   AKC   AKD   AKEk   AKFL   AKG-   AKH   AKH   AKI   AKJ   AKK   AKLs   AKMT   AKN5   AKO   AKO   AKP   AKQ   AKR   AKS{   AKT\   AKU=   AKV   AKV   AKW   AKX   AKY   AKZ   AK[d   AK\E   AK]&   AK^   AK^   AK_   AK`   AKa   AKbl   AKcM   AKd.   AKe   AKe   AKf   AKg   AKh   AKit   AKjU   AKk6   AKl   AKl   AKm   AKn   AKo   AKp|   AKq]   AKr>   AKs   AKt    AKt   AKu   AKv   AKw   AKxe   AKyF   AKz'   AK{   AK{   AK|   AK}   AK~   AKm   AKN   AK/   AK   AK   AK   AK   AK   AKu   AKV   AK7   AK   AK   AK   AK   AK   AK}   AK^   AK?   AK    AK   AK   AK   AK   AK   AKf   AKG   AK(   AK	   AK   AK   AK   AK   AKn   AKO   AK0   AK   AK   AK   AK   AK   AKv   AKW   AK8   AK   AK   AK   AK   AK   AK~   AK_   AK@   AK!   AK   AK   AK   AK   AK   AKg   AKH   AK)   AK
   AK   AK   AK   AK   AKo   AKP   AK1   AK   AK   AK   AK   AK   AKw   AKX   AK9   AK   AK   AK   AKŽ   AKƞ   AK   AK`   AKA   AK"   AK   AK   AK   AKͦ   AK·   AKh   AKI   AK*   AK   AK   AK   AKԮ   AKՏ   AKp   AKQ   AK2   AK   AK   AK   AK۶   AKܗ   AKx   AKY   AK:   AK   AK   AK   AK   AK   AK   AKa   AKB   AK#   AK   AK   AK   AK   AK   AKi   AKJ   AK+   AK   AK   AK   AK   AK   AKq   AKR   AK3   AK   AK   AK   AK   AK   AKy   AKZ   AK;   AK   AK   AK   AK   AL    AL   ALb   ALC   AL$   AL   AL   AL   AL   AL   AL	j   AL
K   AL,   AL
   AL   AL
   AL   AL   ALr   ALS   AL4   AL   AL   AL   AL   AL   ALz   AL[   AL<   AL   AL   AL   AL   AL   AL   ALc   AL D   AL!%   AL"   AL"   AL#   AL$   AL%   AL&k   AL'L   AL(-   AL)   AL)   AL*   AL+   AL,   AL-s   AL.T   AL/5   AL0   AL0   AL1   AL2   AL3   AL4{   AL5\   AL6=   AL7   AL7   AL8   AL9   AL:   AL;   AL<d   AL=E   AL>&   AL?   AL?   AL@   ALA   ALB   ALCl   ALDM   ALE.   ALF   ALF   ALG   ALH   ALI   ALJt   ALKU   ALL6   ALM   ALM   ALN   ALO   ALP   ALQ|   ALR]   ALS>   ALT   ALU    ALU   ALV   ALW   ALX   ALYe   ALZF   AL['   AL\   AL\   AL]   AL^   AL_   AL`m   ALaN   ALb/   ALc   ALc   ALd   ALe   ALf   ALgu   ALhV   ALi7   ALj   ALj   ALk   ALl   ALm   ALn}   ALo^   ALp?   ALq    ALr   ALr   ALs   ALt   ALu   ALvf   ALwG   ALx(   ALy	   ALy   ALz   AL{   AL|   AL}n   AL~O   AL0   AL   AL   AL   AL   AL   ALv   ALW   AL8   AL   AL   AL   AL   AL   AL~   AL_   AL@   AL!   AL   AL   AL   AL   AL   ALg   ALH   AL)   AL
   AL   AL   AL   AL   ALo   ALP   AL1   AL   AL   AL   AL   AL   ALw   ALX   AL9   AL   AL   AL   AL   AL   AL   AL`   ALA   AL"   AL   AL   AL   AL   AL   ALh   ALI   AL*   AL   AL   AL   AL   AL   ALp   ALQ   AL2   AL   AL   AL   AL   AL   ALx   ALY   AL:   AL   AL   AL   ALþ   ALğ   ALŀ   ALa   ALB   AL#   AL   AL   AL   AL˧   AL̈   ALi   ALJ   AL+   AL   AL   AL   ALү   ALӐ   ALq   ALR   AL3   AL   AL   AL   ALٷ   ALژ   ALy   ALZ   AL;   AL   AL   AL   AL   AL   AL   ALb   ALC   AL$   AL   AL   AL   AL   AL   ALj   ALK   AL,   AL
   AL   AL   AL   AL   ALr   ALS   AL4   AL   AL   AL   AL   AL   ALz   AL[   AL<   AL   AL   AL   AL   AL   AL   AM c   AMD   AM%   AM   AM   AM   AM   AM   AMk   AML   AM	-   AM
   AM
   AM   AM   AM
   AMs   AMT   AM5   AM   AM   AM   AM   AM   AM{   AM\   AM=   AM   AM   AM   AM   AM   AM   AMd   AME   AM&   AM    AM    AM!   AM"   AM#   AM$l   AM%M   AM&.   AM'   AM'   AM(   AM)   AM*   AM+t   AM,U   AM-6   AM.   AM.   AM/   AM0   AM1   AM2|   AM3]   AM4>   AM5   AM6    AM6   AM7   AM8   AM9   AM:e   AM;F   AM<'   AM=   AM=   AM>   AM?   AM@   AMAm   AMBN   AMC/   AMD   AMD   AME   AMF   AMG   AMHu   AMIV   AMJ7   AMK   AMK   AML   AMM   AMN   AMO}   AMP^   AMQ?   AMR    AMS   AMS   AMT   AMU   AMV   AMWf   AMXG   AMY(   AMZ	   AMZ   AM[   AM\   AM]   AM^n   AM_O   AM`0   AMa   AMa   AMb   AMc   AMd   AMev   AMfW   AMg8   AMh   AMh   AMi   AMj   AMk   AMl~   AMm_   AMn@   AMo!   AMp   AMp   AMq   AMr   AMs   AMtg   AMuH   AMv)   AMw
   AMw   AMx   AMy   AMz   AM{o   AM|P   AM}1   AM~   AM~   AM   AM   AM   AMw   AMX   AM9   AM   AM   AM   AM   AM   AM   AM`   AMA   AM"   AM   AM   AM   AM   AM   AMh   AMI   AM*   AM   AM   AM   AM   AM   AMp   AMQ   AM2   AM   AM   AM   AM   AM   AMx   AMY   AM:   AM   AM   AM   AM   AM   AM   AMa   AMB   AM#   AM   AM   AM   AM   AM   AMi   AMJ   AM+   AM   AM   AM   AM   AM   AMq   AMR   AM3   AM   AM   AM   AM   AM   AMy   AMZ   AM;   AM   AM   AM   AM   AM    AMÁ   AMb   AMC   AM$   AM   AM   AM   AMɨ   AMʉ   AMj   AMK   AM,   AM
   AM   AM   AMа   AMё   AMr   AMS   AM4   AM   AM   AM   AM׸   AMؙ   AMz   AM[   AM<   AM   AM   AM   AM   AMߡ   AM   AMc   AMD   AM%   AM   AM   AM   AM   AM   AMk   AML   AM-   AM   AM   AM   AM   AM   AMs   AMT   AM5   AM   AM   AM   AM   AM   AM{   AM\   AM=   AM   AM   AM   AM   AM   AM   AMd   AME   AN &   AN   AN   AN   AN   AN   ANl   ANM   AN.   AN   AN   AN	   AN
   AN   ANt   AN
U   AN6   AN   AN   AN   AN   AN   AN|   AN]   AN>   AN   AN    AN   AN   AN   AN   ANe   ANF   AN'   AN   AN   AN   AN    AN!   AN"m   AN#N   AN$/   AN%   AN%   AN&   AN'   AN(   AN)u   AN*V   AN+7   AN,   AN,   AN-   AN.   AN/   AN0}   AN1^   AN2?   AN3    AN4   AN4   AN5   AN6   AN7   AN8f   AN9G   AN:(   AN;	   AN;   AN<   AN=   AN>   AN?n   AN@O   ANA0   ANB   ANB   ANC   AND   ANE   ANFv   ANGW   ANH8   ANI   ANI   ANJ   ANK   ANL   ANM~   ANN_   ANO@   ANP!   ANQ   ANQ   ANR   ANS   ANT   ANUg   ANVH   ANW)   ANX
   ANX   ANY   ANZ   AN[   AN\o   AN]P   AN^1   AN_   AN_   AN`   ANa   ANb   ANcw   ANdX   ANe9   ANf   ANf   ANg   ANh   ANi   ANj   ANk`   ANlA   ANm"   ANn   ANn   ANo   ANp   ANq   ANrh   ANsI   ANt*   ANu   ANu   ANv   ANw   ANx   ANyp   ANzQ   AN{2   AN|   AN|   AN}   AN~   AN   ANx   ANY   AN:   AN   AN   AN   AN   AN   AN   ANa   ANB   AN   AN   AN   ANi   ANJ   AN+   AN   AN   AN   AN   AN   ANq   ANR   AN3   AN   AN   AN   AN   AN   ANy   ANZ   AN;   AN   AN   AN   AN   AN   AN   ANb   ANC   AN$   AN   AN   AN   AN   AN   ANj   ANK   AN,   AN
   AN   AN   AN   AN   ANr   ANS   AN4   AN   AN   AN   AN   AN   ANz   AN[   AN<   AN   AN   AN   AN   AN   AN   ANc   AND   AN%   AN   AN   AN   ANǩ   ANȊ   ANk   ANL   AN-   AN   AN   AN   ANα   ANϒ   ANs   ANT   AN5   AN   AN   AN   ANչ   AN֚   AN{   AN\   AN=   AN   AN   AN   AN   ANݢ   ANރ   ANd   ANE   AN&   AN   AN   AN   AN   AN   ANl   ANM   AN.   AN   AN   AN   AN   AN   ANt   ANU   AN6   AN   AN   AN   AN   AN   AN|   AN]   AN>   AN   AN    AN   AN   AN   AN   ANe   ANF   AN'   AN   AN   AO    AO   AO   AOm   AON   AO/   AO   AO   AO   AO   AO	   AO
u   AOV   AO7   AO
   AO
   AO   AO   AO   AO}   AO^   AO?   AO    AO   AO   AO   AO   AO   AOf   AOG   AO(   AO	   AO   AO   AO   AO   AO n   AO!O   AO"0   AO#   AO#   AO$   AO%   AO&   AO'v   AO(W   AO)8   AO*   AO*   AO+   AO,   AO-   AO.~   AO/_   AO0@   AO1!   AO2   AO2   AO3   AO4   AO5   AO6g   AO7H   AO8)   AO9
   AO9   AO:   AO;   AO<   AO=o   AO>P   AO?1   AO@   AO@   AOA   AOB   AOC   AODw   AOEX   AOF9   AOG   AOG   AOH   AOI   AOJ   AOK   AOL`   AOMA   AON"   AOO   AOO   AOP   AOQ   AOR   AOSh   AOTI   AOU*   AOV   AOV   AOW   AOX   AOY   AOZp   AO[Q   AO\2   AO]   AO]   AO^   AO_   AO`   AOax   AObY   AOc:   AOd   AOd   AOe   AOf   AOg   AOh   AOia   AOjB   AOk#   AOl   AOl   AOm   AOn   AOo   AOpi   AOqJ   AOr+   AOs   AOs   AOt   AOu   AOv   AOwq   AOxR   AOy3   AOz   AOz   AO{   AO|   AO}   AO~y   AOZ   AO;   AO   AO   AO   AO   AO   AO   AOb   AOC   AO$   AO   AO   AO   AO   AO   AOj   AOK   AO,   AO
   AO   AO   AO   AO   AOr   AOS   AO4   AO   AO   AO   AO   AO   AOz   AO[   AO<   AO   AO   AO   AO   AO   AO   AOc   AOD   AO%   AO   AO   AO   AO   AO   AOk   AOL   AO-   AO   AO   AO   AO   AO   AOs   AOT   AO5   AO   AO   AO   AO   AO   AO{   AO\   AO=   AO   AO   AO   AO   AO   AO   AOd   AOE   AO&   AO   AO   AO   AOŪ   AOƋ   AOl   AOM   AO.   AO   AO   AO   AO̲   AO͓   AOt   AOU   AO6   AO   AO   AO   AOӺ   AOԛ   AO|   AO]   AO>   AO   AO    AO   AO   AOۣ   AO܄   AOe   AOF   AO'   AO   AO   AO   AO   AO   AOm   AON   AO/   AO   AO   AO   AO   AO   AOu   AOV   AO7   AO   AO   AO   AO   AO   AO}   AO^   AO?   AO    AO   AO   AO   AO   AO   AOf   AOG   AO(   AO	   AO   AO   AO   AP    APn   APO   AP0   AP   AP   AP   AP   AP   APv   AP	W   AP
8   AP   AP   AP   AP
   AP   AP~   AP_   AP@   AP!   AP   AP   AP   AP   AP   APg   APH   AP)   AP
   AP   AP   AP   AP   APo   APP   AP 1   AP!   AP!   AP"   AP#   AP$   AP%w   AP&X   AP'9   AP(   AP(   AP)   AP*   AP+   AP,   AP-`   AP.A   AP/"   AP0   AP0   AP1   AP2   AP3   AP4h   AP5I   AP6*   AP7   AP7   AP8   AP9   AP:   AP;p   AP<Q   AP=2   AP>   AP>   AP?   AP@   APA   APBx   APCY   APD:   APE   APE   APF   APG   APH   API   APJa   APKB   APL#   APM   APM   APN   APO   APP   APQi   APRJ   APS+   APT   APT   APU   APV   APW   APXq   APYR   APZ3   AP[   AP[   AP\   AP]   AP^   AP_y   AP`Z   APa;   APb   APb   APc   APd   APe   APf   APgb   APhC   APi$   APj   APj   APk   APl   APm   APnj   APoK   APp,   APq
   APq   APr   APs   APt   APur   APvS   APw4   APx   APx   APy   APz   AP{   AP|z   AP}[   AP~<   AP   AP   AP   AP   AP   AP   APc   APD   AP%   AP   AP   AP   AP   AP   APk   APL   AP-   AP   AP   AP   AP   AP   APs   APT   AP5   AP   AP   AP   AP   AP   AP{   AP\   AP=   AP   AP   AP   AP   AP   AP   APd   APE   AP&   AP   AP   AP   AP   AP   APl   APM   AP.   AP   AP   AP   AP   AP   APt   APU   AP6   AP   AP   AP   AP   AP   AP|   AP]   AP>   AP   AP    AP   AP   AP   AP   APe   APF   AP'   AP   AP   AP   APë   APČ   APm   APN   AP/   AP   AP   AP   APʳ   AP˔   APu   APV   AP7   AP   AP   AP   APѻ   APҜ   AP}   AP^   AP?   AP    AP   AP   AP   AP٤   APڅ   APf   APG   AP(   AP	   AP   AP   AP   AP   APn   APO   AP0   AP   AP   AP   AP   AP   APv   APW   AP8   AP   AP   AP   AP   AP   AP~   AP_   AP@   AP!   AP   AP   AP   AP   AP   APg   APH   AP)   AP
   AP   AP   AP   AP   APo   AQ P   AQ1   AQ   AQ   AQ   AQ   AQ   AQw   AQX   AQ9   AQ	   AQ	   AQ
   AQ   AQ   AQ
   AQ`   AQA   AQ"   AQ   AQ   AQ   AQ   AQ   AQh   AQI   AQ*   AQ   AQ   AQ   AQ   AQ   AQp   AQQ   AQ2   AQ   AQ   AQ    AQ!   AQ"   AQ#x   AQ$Y   AQ%:   AQ&   AQ&   AQ'   AQ(   AQ)   AQ*   AQ+a   AQ,B   AQ-#   AQ.   AQ.   AQ/   AQ0   AQ1   AQ2i   AQ3J   AQ4+   AQ5   AQ5   AQ6   AQ7   AQ8   AQ9q   AQ:R   AQ;3   AQ<   AQ<   AQ=   AQ>   AQ?   AQ@y   AQAZ   AQB;   AQC   AQC   AQD   AQE   AQF   AQG   AQHb   AQIC   AQJ$   AQK   AQK   AQL   AQM   AQN   AQOj   AQPK   AQQ,   AQR
   AQR   AQS   AQT   AQU   AQVr   AQWS   AQX4   AQY   AQY   AQZ   AQ[   AQ\   AQ]z   AQ^[   AQ_<   AQ`   AQ`   AQa   AQb   AQc   AQd   AQec   AQfD   AQg%   AQh   AQh   AQi   AQj   AQk   AQlk   AQmL   AQn-   AQo   AQo   AQp   AQq   AQr   AQss   AQtT   AQu5   AQv   AQv   AQw   AQx   AQy   AQz{   AQ{\   AQ|=   AQ}   AQ}   AQ~   AQ   AQ   AQ   AQd   AQE   AQ&   AQ   AQ   AQ   AQ   AQ   AQl   AQM   AQ.   AQ   AQ   AQ   AQ   AQ   AQt   AQU   AQ6   AQ   AQ   AQ   AQ   AQ   AQ|   AQ]   AQ>   AQ   AQ    AQ   AQ   AQ   AQ   AQe   AQF   AQ'   AQ   AQ   AQ   AQ   AQ   AQm   AQN   AQ/   AQ   AQ   AQ   AQ   AQ   AQu   AQV   AQ7   AQ   AQ   AQ   AQ   AQ   AQ}   AQ^   AQ?   AQ    AQ   AQ   AQ   AQ   AQ   AQf   AQG   AQ(   AQ	   AQ   AQ   AQ   AQ   AQn   AQO   AQ0   AQ   AQ   AQ   AQȴ   AQɕ   AQv   AQW   AQ8   AQ   AQ   AQ   AQϼ   AQН   AQ~   AQ_   AQ@   AQ!   AQ   AQ   AQ   AQץ   AQ؆   AQg   AQH   AQ)   AQ
   AQ   AQ   AQޭ   AQߎ   AQo   AQP   AQ1   AQ   AQ   AQ   AQ   AQ   AQw   AQX   AQ9   AQ   AQ   AQ   AQ   AQ   AQ   AQ`   AQA   AQ"   AQ   AQ   AQ   AQ   AQ   AQh   AQI   AQ*   AQ   AQ   AQ   AQ   AQ   AQp   AQQ   AQ2   AR    AR    AR   AR   AR   ARx   ARY   AR:   AR   AR   AR   AR	   AR
   AR   ARa   AR
B   AR#   AR   AR   AR   AR   AR   ARi   ARJ   AR+   AR   AR   AR   AR   AR   ARq   ARR   AR3   AR   AR   AR   AR   AR    AR!y   AR"Z   AR#;   AR$   AR$   AR%   AR&   AR'   AR(   AR)b   AR*C   AR+$   AR,   AR,   AR-   AR.   AR/   AR0j   AR1K   AR2,   AR3
   AR3   AR4   AR5   AR6   AR7r   AR8S   AR94   AR:   AR:   AR;   AR<   AR=   AR>z   AR?[   AR@<   ARA   ARA   ARB   ARC   ARD   ARE   ARFc   ARGD   ARH%   ARI   ARI   ARJ   ARK   ARL   ARMk   ARNL   ARO-   ARP   ARP   ARQ   ARR   ARS   ARTs   ARUT   ARV5   ARW   ARW   ARX   ARY   ARZ   AR[{   AR\\   AR]=   AR^   AR^   AR_   AR`   ARa   ARb   ARcd   ARdE   ARe&   ARf   ARf   ARg   ARh   ARi   ARjl   ARkM   ARl.   ARm   ARm   ARn   ARo   ARp   ARqt   ARrU   ARs6   ARt   ARt   ARu   ARv   ARw   ARx|   ARy]   ARz>   AR{   AR|    AR|   AR}   AR~   AR   ARe   ARF   AR'   AR   AR   AR   AR   AR   ARm   ARN   AR/   AR   AR   AR   AR   AR   ARu   ARV   AR7   AR   AR   AR   AR   AR   AR}   AR^   AR?   AR    AR   AR   AR   AR   AR   ARf   ARG   AR(   AR	   AR   AR   AR   AR   ARn   ARO   AR0   AR   AR   AR   AR   AR   ARv   ARW   AR8   AR   AR   AR   AR   AR   AR~   AR_   AR@   AR!   AR   AR   AR   AR   AR   ARg   ARH   AR)   AR
   AR   AR   AR   AR   ARo   ARP   AR1   AR   AR   AR   ARƵ   ARǖ   ARw   ARX   AR9   AR   AR   AR   ARͽ   ARΞ   AR   AR`   ARA   AR"   AR   AR   AR   ARզ   ARև   ARh   ARI   AR*   AR   AR   AR   ARܮ   ARݏ   ARp   ARQ   AR2   AR   AR   AR   AR   AR   ARx   ARY   AR:   AR   AR   AR   AR   AR   AR   ARa   ARB   AR#   AR   AR   AR   AR   AR   ARi   ARJ   AR+   AR   AR   AR   AR   AR   ARq   ARR   AR3   AR   AR   AR   AS    AS   ASy   ASZ   AS;   AS   AS   AS   AS   AS   AS	   AS
b   ASC   AS$   AS
   AS
   AS   AS   AS   ASj   ASK   AS,   AS
   AS   AS   AS   AS   ASr   ASS   AS4   AS   AS   AS   AS   AS   ASz   AS [   AS!<   AS"   AS"   AS#   AS$   AS%   AS&   AS'c   AS(D   AS)%   AS*   AS*   AS+   AS,   AS-   AS.k   AS/L   AS0-   AS1   AS1   AS2   AS3   AS4   AS5s   AS6T   AS75   AS8   AS8   AS9   AS:   AS;   AS<{   AS=\   AS>=   AS?   AS?   AS@   ASA   ASB   ASC   ASDd   ASEE   ASF&   ASG   ASG   ASH   ASI   ASJ   ASKl   ASLM   ASM.   ASN   ASN   ASO   ASP   ASQ   ASRt   ASSU   AST6   ASU   ASU   ASV   ASW   ASX   ASY|   ASZ]   AS[>   AS\   AS]    AS]   AS^   AS_   AS`   ASae   ASbF   ASc'   ASd   ASd   ASe   ASf   ASg   AShm   ASiN   ASj/   ASk   ASk   ASl   ASm   ASn   ASou   ASpV   ASq7   ASr   ASr   ASs   ASt   ASu   ASv}   ASw^   ASx?   ASy    ASz   ASz   AS{   AS|   AS}   AS~f   ASG   AS(   AS	   AS   AS   AS   AS   ASn   ASO   AS0   AS   AS   AS   AS   AS   ASv   ASW   AS8   AS   AS   AS   AS   AS   AS~   AS_   AS@   AS!   AS   AS   AS   AS   AS   ASg   ASH   AS)   AS
   AS   AS   AS   AS   ASo   ASP   AS1   AS   AS   AS   AS   AS   ASw   ASX   AS9   AS   AS   AS   AS   AS   AS   AS`   ASA   AS"   AS   AS   AS   AS   AS   ASh   ASI   AS*   AS   AS   AS   AS   AS   ASp   ASQ   AS2   AS   AS   AS   ASĶ   ASŗ   ASx   ASY   AS:   AS   AS   AS   AS˾   AS̟   AS̀   ASa   ASB   AS#   AS   AS   AS   ASӧ   ASԈ   ASi   ASJ   AS+   AS   AS   AS   ASگ   ASې   ASq   ASR   AS3   AS   AS   AS   AS   AS   ASy   ASZ   AS;   AS   AS   AS   AS   AS   AS   ASb   ASC   AS$   AS   AS   AS   AS   AS   ASj   ASK   AS,   AS
   AS   AS   AS   AS   ASr   ASS   AS4   AS   AS   AS   AS   AS   AT z   AT[   AT<   AT   AT   AT   AT   AT   AT   ATc   AT	D   AT
%   AT   AT   AT   AT
   AT   ATk   ATL   AT-   AT   AT   AT   AT   AT   ATs   ATT   AT5   AT   AT   AT   AT   AT   AT{   AT\   AT=   AT    AT    AT!   AT"   AT#   AT$   AT%d   AT&E   AT'&   AT(   AT(   AT)   AT*   AT+   AT,l   AT-M   AT..   AT/   AT/   AT0   AT1   AT2   AT3t   AT4U   AT56   AT6   AT6   AT7   AT8   AT9   AT:|   AT;]   AT<>   AT=   AT>    AT>   AT?   AT@   ATA   ATBe   ATCF   ATD'   ATE   ATE   ATF   ATG   ATH   ATIm   ATJN   ATK/   ATL   ATL   ATM   ATN   ATO   ATPu   ATQV   ATR7   ATS   ATS   ATT   ATU   ATV   ATW}   ATX^   ATY?   ATZ    AT[   AT[   AT\   AT]   AT^   AT_f   AT`G   ATa(   ATb	   ATb   ATc   ATd   ATe   ATfn   ATgO   ATh0   ATi   ATi   ATj   ATk   ATl   ATmv   ATnW   ATo8   ATp   ATp   ATq   ATr   ATs   ATt~   ATu_   ATv@   ATw!   ATx   ATx   ATy   ATz   AT{   AT|g   AT}H   AT~)   AT
   AT   AT   AT   AT   ATo   ATP   AT1   AT   AT   AT   AT   AT   ATw   ATX   AT9   AT   AT   AT   AT   AT   AT   AT`   ATA   AT"   AT   AT   AT   AT   AT   ATh   ATI   AT*   AT   AT   AT   AT   AT   ATp   ATQ   AT2   AT   AT   AT   AT   AT   ATx   ATY   AT:   AT   AT   AT   AT   AT   AT   ATa   ATB   AT#   AT   AT   AT   AT   AT   ATi   ATJ   AT+   AT   AT   AT   AT   AT   ATq   ATR   AT3   AT   AT   AT   AT·   ATØ   ATy   ATZ   AT;   AT   AT   AT   ATɿ   ATʠ   ATˁ   ATb   ATC   AT$   AT   AT   AT   ATѨ   AT҉   ATj   ATK   AT,   AT
   AT   AT   ATذ   ATّ   ATr   ATS   AT4   AT   AT   AT   AT߸   AT   ATz   AT[   AT<   AT   AT   AT   AT   AT   AT   ATc   ATD   AT%   AT   AT   AT   AT   AT   ATk   ATL   AT-   AT   AT   AT   AT   AT   ATs   ATT   AT5   AT   AT   AT   AT   AT   AT{   AT\   AU =   AU   AU   AU   AU   AU   AU   AUd   AUE   AU&   AU	   AU	   AU
   AU   AU   AU
l   AUM   AU.   AU   AU   AU   AU   AU   AUt   AUU   AU6   AU   AU   AU   AU   AU   AU|   AU]   AU>   AU   AU    AU   AU    AU!   AU"   AU#e   AU$F   AU%'   AU&   AU&   AU'   AU(   AU)   AU*m   AU+N   AU,/   AU-   AU-   AU.   AU/   AU0   AU1u   AU2V   AU37   AU4   AU4   AU5   AU6   AU7   AU8}   AU9^   AU:?   AU;    AU<   AU<   AU=   AU>   AU?   AU@f   AUAG   AUB(   AUC	   AUC   AUD   AUE   AUF   AUGn   AUHO   AUI0   AUJ   AUJ   AUK   AUL   AUM   AUNv   AUOW   AUP8   AUQ   AUQ   AUR   AUS   AUT   AUU~   AUV_   AUW@   AUX!   AUY   AUY   AUZ   AU[   AU\   AU]g   AU^H   AU_)   AU`
   AU`   AUa   AUb   AUc   AUdo   AUeP   AUf1   AUg   AUg   AUh   AUi   AUj   AUkw   AUlX   AUm9   AUn   AUn   AUo   AUp   AUq   AUr   AUs`   AUtA   AUu"   AUv   AUv   AUw   AUx   AUy   AUzh   AU{I   AU|*   AU}   AU}   AU~   AU   AU   AUp   AUQ   AU2   AU   AU   AU   AU   AU   AUx   AUY   AU:   AU   AU   AU   AU   AU   AU   AUa   AUB   AU#   AU   AU   AU   AU   AU   AUi   AUJ   AU+   AU   AU   AU   AU   AU   AUq   AUR   AU3   AU   AU   AU   AU   AU   AUy   AUZ   AU;   AU   AU   AU   AU   AU   AU   AUb   AUC   AU$   AU   AU   AU   AU   AU   AUj   AUK   AU,   AU
   AU   AU   AU   AU   AUr   AUS   AU4   AU   AU   AU   AU   AU   AUz   AU[   AU<   AU   AU   AU   AU   AUȡ   AUɂ   AUc   AUD   AU%   AU   AU   AU   AUϩ   AUЊ   AUk   AUL   AU-   AU   AU   AU   AUֱ   AUג   AUs   AUT   AU5   AU   AU   AU   AUݹ   AUޚ   AU{   AU\   AU=   AU   AU   AU   AU   AU   AU   AUd   AUE   AU&   AU   AU   AU   AU   AU   AUl   AUM   AU.   AU   AU   AU   AU   AU   AUt   AUU   AU6   AU   AU   AU   AU   AU   AU|   AU]   AU>   AU   AV     AV    AV   AV   AV   AVe   AVF   AV'   AV   AV   AV   AV	   AV
   AVm   AVN   AV
/   AV   AV   AV   AV   AV   AVu   AVV   AV7   AV   AV   AV   AV   AV   AV}   AV^   AV?   AV    AV   AV   AV   AV   AV    AV!f   AV"G   AV#(   AV$	   AV$   AV%   AV&   AV'   AV(n   AV)O   AV*0   AV+   AV+   AV,   AV-   AV.   AV/v   AV0W   AV18   AV2   AV2   AV3   AV4   AV5   AV6~   AV7_   AV8@   AV9!   AV:   AV:   AV;   AV<   AV=   AV>g   AV?H   AV@)   AVA
   AVA   AVB   AVC   AVD   AVEo   AVFP   AVG1   AVH   AVH   AVI   AVJ   AVK   AVLw   AVMX   AVN9   AVO   AVO   AVP   AVQ   AVR   AVS   AVT`   AVUA   AVV"   AVW   AVW   AVX   AVY   AVZ   AV[h   AV\I   AV]*   AV^   AV^   AV_   AV`   AVa   AVbp   AVcQ   AVd2   AVe   AVe   AVf   AVg   AVh   AVix   AVjY   AVk:   AVl   AVl   AVm   AVn   AVo   AVp   AVqa   AVrB   AVs#   AVt   AVt   AVu   AVv   AVw   AVxi   AVyJ   AVz+   AV{   AV{   AV|   AV}   AV~   AVq   AVR   AV3   AV   AV   AV   AV   AV   AVy   AVZ   AV;   AV   AV   AV   AV   AV   AV   AVb   AVC   AV$   AV   AV   AV   AV   AV   AVj   AVK   AV,   AV
   AV   AV   AV   AV   AVr   AVS   AV4   AV   AV   AV   AV   AV   AVz   AV[   AV<   AV   AV   AV   AV   AV   AV   AVc   AVD   AV%   AV   AV   AV   AV   AV   AVk   AVL   AV-   AV   AV   AV   AV   AV   AVs   AVT   AV5   AV   AV   AV   AV   AV   AV{   AV\   AV=   AV   AV   AV   AV   AVƢ   AVǃ   AVd   AVE   AV&   AV   AV   AV   AVͪ   AV΋   AVl   AVM   AV.   AV   AV   AV   AVԲ   AVՓ   AVt   AVU   AV6   AV   AV   AV   AVۺ   AVܛ   AV|   AV]   AV>   AV   AV    AV   AV   AV   AV   AVe   AVF   AV'   AV   AV   AV   AV   AV   AVm   AVN   AV/   AV   AV   AV   AV   AV   AVu   AVV   AV7   AV   AV   AV   AV   AV   AV}   AV^   AV?   AV    AV   AV   AV   AW    AW   AWf   AWG   AW(   AW	   AW   AW   AW   AW   AW	n   AW
O   AW0   AW   AW   AW
   AW   AW   AWv   AWW   AW8   AW   AW   AW   AW   AW   AW~   AW_   AW@   AW!   AW   AW   AW   AW   AW   AWg   AW H   AW!)   AW"
   AW"   AW#   AW$   AW%   AW&o   AW'P   AW(1   AW)   AW)   AW*   AW+   AW,   AW-w   AW.X   AW/9   AW0   AW0   AW1   AW2   AW3   AW4   AW5`   AW6A   AW7"   AW8   AW8   AW9   AW:   AW;   AW<h   AW=I   AW>*   AW?   AW?   AW@   AWA   AWB   AWCp   AWDQ   AWE2   AWF   AWF   AWG   AWH   AWI   AWJx   AWKY   AWL:   AWM   AWM   AWN   AWO   AWP   AWQ   AWRa   AWSB   AWT#   AWU   AWU   AWV   AWW   AWX   AWYi   AWZJ   AW[+   AW\   AW\   AW]   AW^   AW_   AW`q   AWaR   AWb3   AWc   AWc   AWd   AWe   AWf   AWgy   AWhZ   AWi;   AWj   AWj   AWk   AWl   AWm   AWn   AWob   AWpC   AWq$   AWr   AWr   AWs   AWt   AWu   AWvj   AWwK   AWx,   AWy
   AWy   AWz   AW{   AW|   AW}r   AW~S   AW4   AW   AW   AW   AW   AW   AWz   AW[   AW<   AW   AW   AW   AW   AW   AW   AWc   AWD   AW%   AW   AW   AW   AW   AW   AWk   AWL   AW-   AW   AW   AW   AW   AW   AWs   AWT   AW5   AW   AW   AW   AW   AW   AW{   AW\   AW=   AW   AW   AW   AW   AW   AW   AWd   AWE   AW&   AW   AW   AW   AW   AW   AWl   AWM   AW.   AW   AW   AW   AW   AW   AWt   AWU   AW6   AW   AW   AW   AW   AW   AW|   AW]   AW>   AW   AW    AW   AW   AWģ   AWń   AWe   AWF   AW'   AW   AW   AW   AW˫   AW̌   AWm   AWN   AW/   AW   AW   AW   AWҳ   AWӔ   AWu   AWV   AW7   AW   AW   AW   AWٻ   AWڜ   AW}   AW^   AW?   AW    AW   AW   AW   AW   AW   AWf   AWG   AW(   AW	   AW   AW   AW   AW   AWn   AWO   AW0   AW   AW   AW   AW   AW   AWv   AWW   AW8   AW   AW   AW   AW   AW   AW~   AW_   AW@   AW!   AW   AW   AW   AW   AW   AX g   AXH   AX)   AX
   AX   AX   AX   AX   AXo   AXP   AX	1   AX
   AX
   AX   AX   AX
   AXw   AXX   AX9   AX   AX   AX   AX   AX   AX   AX`   AXA   AX"   AX   AX   AX   AX   AX   AXh   AXI   AX*   AX    AX    AX!   AX"   AX#   AX$p   AX%Q   AX&2   AX'   AX'   AX(   AX)   AX*   AX+x   AX,Y   AX-:   AX.   AX.   AX/   AX0   AX1   AX2   AX3a   AX4B   AX5#   AX6   AX6   AX7   AX8   AX9   AX:i   AX;J   AX<+   AX=   AX=   AX>   AX?   AX@   AXAq   AXBR   AXC3   AXD   AXD   AXE   AXF   AXG   AXHy   AXIZ   AXJ;   AXK   AXK   AXL   AXM   AXN   AXO   AXPb   AXQC   AXR$   AXS   AXS   AXT   AXU   AXV   AXWj   AXXK   AXY,   AXZ
   AXZ   AX[   AX\   AX]   AX^r   AX_S   AX`4   AXa   AXa   AXb   AXc   AXd   AXez   AXf[   AXg<   AXh   AXh   AXi   AXj   AXk   AXl   AXmc   AXnD   AXo%   AXp   AXp   AXq   AXr   AXs   AXtk   AXuL   AXv-   AXw   AXw   AXx   AXy   AXz   AX{s   AX|T   AX}5   AX~   AX~   AX   AX   AX   AX{   AX\   AX=   AX   AX   AX   AX   AX   AX   AXd   AXE   AX&   AX   AX   AX   AX   AX   AXl   AXM   AX.   AX   AX   AX   AX   AX   AXt   AXU   AX6   AX   AX   AX   AX   AX   AX|   AX]   AX>   AX   AX    AX   AX   AX   AX   AXe   AXF   AX'   AX   AX   AX   AX   AX   AXm   AXN   AX/   AX   AX   AX   AX   AX   AXu   AXV   AX7   AX   AX   AX   AX   AX   AX}   AX^   AX?   AX    AX   AX   AX   AX¤   AXÅ   AXf   AXG   AX(   AX	   AX   AX   AXɬ   AXʍ   AXn   AXO   AX0   AX   AX   AX   AXд   AXѕ   AXv   AXW   AX8   AX   AX   AX   AX׼   AX؝   AX~   AX_   AX@   AX!   AX   AX   AX   AXߥ   AX   AXg   AXH   AX)   AX
   AX   AX   AX   AX   AXo   AXP   AX1   AX   AX   AX   AX   AX   AXw   AXX   AX9   AX   AX   AX   AX   AX   AX   AX`   AXA   AX"   AX   AX   AX   AX   AX   AXh   AXI   AY *   AY   AY   AY   AY   AY   AYp   AYQ   AY2   AY   AY   AY	   AY
   AY   AYx   AY
Y   AY:   AY   AY   AY   AY   AY   AY   AYa   AYB   AY#   AY   AY   AY   AY   AY   AYi   AYJ   AY+   AY   AY   AY   AY    AY!   AY"q   AY#R   AY$3   AY%   AY%   AY&   AY'   AY(   AY)y   AY*Z   AY+;   AY,   AY,   AY-   AY.   AY/   AY0   AY1b   AY2C   AY3$   AY4   AY4   AY5   AY6   AY7   AY8j   AY9K   AY:,   AY;
   AY;   AY<   AY=   AY>   AY?r   AY@S   AYA4   AYB   AYB   AYC   AYD   AYE   AYFz   AYG[   AYH<   AYI   AYI   AYJ   AYK   AYL   AYM   AYNc   AYOD   AYP%   AYQ   AYQ   AYR   AYS   AYT   AYUk   AYVL   AYW-   AYX   AYX   AYY   AYZ   AY[   AY\s   AY]T   AY^5   AY_   AY_   AY`   AYa   AYb   AYc{   AYd\   AYe=   AYf   AYf   AYg   AYh   AYi   AYj   AYkd   AYlE   AYm&   AYn   AYn   AYo   AYp   AYq   AYrl   AYsM   AYt.   AYu   AYu   AYv   AYw   AYx   AYyt   AYzU   AY{6   AY|   AY|   AY}   AY~   AY   AY|   AY]   AY>   AY   AY    AY   AY   AY   AY   AYe   AYF   AY'   AY   AY   AY   AY   AY   AYm   AYN   AY/   AY   AY   AY   AY   AY   AYu   AYV   AY7   AY   AY   AY   AY   AY   AY}   AY^   AY?   AY    AY   AY   AY   AY   AY   AYf   AYG   AY(   AY	   AY   AY   AY   AY   AYn   AYO   AY0   AY   AY   AY   AY   AY   AYv   AYW   AY8   AY   AY   AY   AY   AY   AY~   AY_   AY@   AY!   AY   AY   AY   AY   AY   AYg   AYH   AY)   AY
   AY   AY   AYǭ   AYȎ   AYo   AYP   AY1   AY   AY   AY   AYε   AYϖ   AYw   AYX   AY9   AY   AY   AY   AYս   AY֞   AY   AY`   AYA   AY"   AY   AY   AY   AYݦ   AYއ   AYh   AYI   AY*   AY   AY   AY   AY   AY   AYp   AYQ   AY2   AY   AY   AY   AY   AY   AYx   AYY   AY:   AY   AY   AY   AY   AY   AY   AYa   AYB   AY#   AY   AY   AY   AY   AY   AYi   AYJ   AY+   AY   AY   AZ    AZ   AZ   AZq   AZR   AZ3   AZ   AZ   AZ   AZ   AZ	   AZ
y   AZZ   AZ;   AZ
   AZ
   AZ   AZ   AZ   AZ   AZb   AZC   AZ$   AZ   AZ   AZ   AZ   AZ   AZj   AZK   AZ,   AZ
   AZ   AZ   AZ   AZ   AZ r   AZ!S   AZ"4   AZ#   AZ#   AZ$   AZ%   AZ&   AZ'z   AZ([   AZ)<   AZ*   AZ*   AZ+   AZ,   AZ-   AZ.   AZ/c   AZ0D   AZ1%   AZ2   AZ2   AZ3   AZ4   AZ5   AZ6k   AZ7L   AZ8-   AZ9   AZ9   AZ:   AZ;   AZ<   AZ=s   AZ>T   AZ?5   AZ@   AZ@   AZA   AZB   AZC   AZD{   AZE\   AZF=   AZG   AZG   AZH   AZI   AZJ   AZK   AZLd   AZME   AZN&   AZO   AZO   AZP   AZQ   AZR   AZSl   AZTM   AZU.   AZV   AZV   AZW   AZX   AZY   AZZt   AZ[U   AZ\6   AZ]   AZ]   AZ^   AZ_   AZ`   AZa|   AZb]   AZc>   AZd   AZe    AZe   AZf   AZg   AZh   AZie   AZjF   AZk'   AZl   AZl   AZm   AZn   AZo   AZpm   AZqN   AZr/   AZs   AZs   AZt   AZu   AZv   AZwu   AZxV   AZy7   AZz   AZz   AZ{   AZ|   AZ}   AZ~}   AZ^   AZ?   AZ    AZ   AZ   AZ   AZ   AZ   AZf   AZG   AZ(   AZ	   AZ   AZ   AZ   AZ   AZn   AZO   AZ0   AZ   AZ   AZ   AZ   AZ   AZv   AZW   AZ8   AZ   AZ   AZ   AZ   AZ   AZ~   AZ_   AZ@   AZ!   AZ   AZ   AZ   AZ   AZ   AZg   AZH   AZ)   AZ
   AZ   AZ   AZ   AZ   AZo   AZP   AZ1   AZ   AZ   AZ   AZ   AZ   AZw   AZX   AZ9   AZ   AZ   AZ   AZ   AZ   AZ   AZ`   AZA   AZ"   AZ   AZ   AZ   AZ   AZ   AZh   AZI   AZ*   AZ   AZ   AZ   AZŮ   AZƏ   AZp   AZQ   AZ2   AZ   AZ   AZ   AZ̶   AZ͗   AZx   AZY   AZ:   AZ   AZ   AZ   AZӾ   AZԟ   AZՀ   AZa   AZB   AZ#   AZ   AZ   AZ   AZۧ   AZ܈   AZi   AZJ   AZ+   AZ   AZ   AZ   AZ   AZ   AZq   AZR   AZ3   AZ   AZ   AZ   AZ   AZ   AZy   AZZ   AZ;   AZ   AZ   AZ   AZ   AZ   AZ   AZb   AZC   AZ$   AZ   AZ   AZ   AZ   AZ   AZj   AZK   AZ,   AZ
   AZ   AZ   AZ   A[    A[r   A[S   A[4   A[   A[   A[   A[   A[   A[z   A[	[   A[
<   A[   A[   A[   A[
   A[   A[   A[c   A[D   A[%   A[   A[   A[   A[   A[   A[k   A[L   A[-   A[   A[   A[   A[   A[   A[s   A[T   A[ 5   A[!   A[!   A["   A[#   A[$   A[%{   A[&\   A['=   A[(   A[(   A[)   A[*   A[+   A[,   A[-d   A[.E   A[/&   A[0   A[0   A[1   A[2   A[3   A[4l   A[5M   A[6.   A[7   A[7   A[8   A[9   A[:   A[;t   A[<U   A[=6   A[>   A[>   A[?   A[@   A[A   A[B|   A[C]   A[D>   A[E   A[F    A[F   A[G   A[H   A[I   A[Je   A[KF   A[L'   A[M   A[M   A[N   A[O   A[P   A[Qm   A[RN   A[S/   A[T   A[T   A[U   A[V   A[W   A[Xu   A[YV   A[Z7   A[[   A[[   A[\   A[]   A[^   A[_}   A[`^   A[a?   A[b    A[c   A[c   A[d   A[e   A[f   A[gf   A[hG   A[i(   A[j	   A[j   A[k   A[l   A[m   A[nn   A[oO   A[p0   A[q   A[q   A[r   A[s   A[t   A[uv   A[vW   A[w8   A[x   A[x   A[y   A[z   A[{   A[|~   A[}_   A[~@   A[!   A[   A[   A[   A[   A[   A[g   A[H   A[)   A[
   A[   A[   A[   A[   A[o   A[P   A[1   A[   A[   A[   A[   A[   A[w   A[X   A[9   A[   A[   A[   A[   A[   A[   A[`   A[A   A["   A[   A[   A[   A[   A[   A[h   A[I   A[*   A[   A[   A[   A[   A[   A[p   A[Q   A[2   A[   A[   A[   A[   A[   A[x   A[Y   A[:   A[   A[   A[   A[   A[   A[   A[a   A[B   A[#   A[   A[   A[   A[   A[   A[i   A[J   A[+   A[   A[   A[   A[ï   A[Đ   A[q   A[R   A[3   A[   A[   A[   A[ʷ   A[˘   A[y   A[Z   A[;   A[   A[   A[   A[ѿ   A[Ҡ   A[Ӂ   A[b   A[C   A[$   A[   A[   A[   A[٨   A[ډ   A[j   A[K   A[,   A[
   A[   A[   A[   A[   A[r   A[S   A[4   A[   A[   A[   A[   A[   A[z   A[[   A[<   A[   A[   A[   A[   A[   A[   A[c   A[D   A[%   A[   A[   A[   A[   A[   A[k   A[L   A[-   A[   A[   A[   A[   A[   A[s   A\ T   A\5   A\   A\   A\   A\   A\   A\{   A\\   A\=   A\	   A\	   A\
   A\   A\   A\
   A\d   A\E   A\&   A\   A\   A\   A\   A\   A\l   A\M   A\.   A\   A\   A\   A\   A\   A\t   A\U   A\6   A\   A\   A\    A\!   A\"   A\#|   A\$]   A\%>   A\&   A\'    A\'   A\(   A\)   A\*   A\+e   A\,F   A\-'   A\.   A\.   A\/   A\0   A\1   A\2m   A\3N   A\4/   A\5   A\5   A\6   A\7   A\8   A\9u   A\:V   A\;7   A\<   A\<   A\=   A\>   A\?   A\@}   A\A^   A\B?   A\C    A\D   A\D   A\E   A\F   A\G   A\Hf   A\IG   A\J(   A\K	   A\K   A\L   A\M   A\N   A\On   A\PO   A\Q0   A\R   A\R   A\S   A\T   A\U   A\Vv   A\WW   A\X8   A\Y   A\Y   A\Z   A\[   A\\   A\]~   A\^_   A\_@   A\`!   A\a   A\a   A\b   A\c   A\d   A\eg   A\fH   A\g)   A\h
   A\h   A\i   A\j   A\k   A\lo   A\mP   A\n1   A\o   A\o   A\p   A\q   A\r   A\sw   A\tX   A\u9   A\v   A\v   A\w   A\x   A\y   A\z   A\{`   A\|A   A\}"   A\~   A\~   A\   A\   A\   A\h   A\I   A\*   A\   A\   A\   A\   A\   A\p   A\Q   A\2   A\   A\   A\   A\   A\   A\x   A\Y   A\:   A\   A\   A\   A\   A\   A\   A\a   A\B   A\#   A\   A\   A\   A\   A\   A\i   A\J   A\+   A\   A\   A\   A\   A\   A\q   A\R   A\3   A\   A\   A\   A\   A\   A\y   A\Z   A\;   A\   A\   A\   A\   A\   A\   A\b   A\C   A\$   A\   A\   A\   A\   A\   A\j   A\K   A\,   A\
   A\   A\   A\   A\   A\r   A\S   A\4   A\   A\   A\   A\ȸ   A\ə   A\z   A\[   A\<   A\   A\   A\   A\   A\С   A\т   A\c   A\D   A\%   A\   A\   A\   A\ש   A\؊   A\k   A\L   A\-   A\   A\   A\   A\ޱ   A\ߒ   A\s   A\T   A\5   A\   A\   A\   A\   A\   A\{   A\\   A\=   A\   A\   A\   A\   A\   A\   A\d   A\E   A\&   A\   A\   A\   A\   A\   A\l   A\M   A\.   A\   A\   A\   A\   A\   A\t   A\U   A\6   A]    A]    A]   A]   A]   A]|   A]]   A]>   A]   A]    A]   A]	   A]
   A]   A]e   A]
F   A]'   A]   A]   A]   A]   A]   A]m   A]N   A]/   A]   A]   A]   A]   A]   A]u   A]V   A]7   A]   A]   A]   A]   A]    A]!}   A]"^   A]#?   A]$    A]%   A]%   A]&   A]'   A](   A])f   A]*G   A]+(   A],	   A],   A]-   A].   A]/   A]0n   A]1O   A]20   A]3   A]3   A]4   A]5   A]6   A]7v   A]8W   A]98   A]:   A]:   A];   A]<   A]=   A]>~   A]?_   A]@@   A]A!   A]B   A]B   A]C   A]D   A]E   A]Fg   A]GH   A]H)   A]I
   A]I   A]J   A]K   A]L   A]Mo   A]NP   A]O1   A]P   A]P   A]Q   A]R   A]S   A]Tw   A]UX   A]V9   A]W   A]W   A]X   A]Y   A]Z   A][   A]\`   A]]A   A]^"   A]_   A]_   A]`   A]a   A]b   A]ch   A]dI   A]e*   A]f   A]f   A]g   A]h   A]i   A]jp   A]kQ   A]l2   A]m   A]m   A]n   A]o   A]p   A]qx   A]rY   A]s:   A]t   A]t   A]u   A]v   A]w   A]x   A]ya   A]zB   A]{#   A]|   A]|   A]}   A]~   A]   A]i   A]J   A]+   A]   A]   A]   A]   A]   A]q   A]R   A]3   A]   A]   A]   A]   A]   A]y   A]Z   A];   A]   A]   A]   A]   A]   A]   A]b   A]C   A]$   A]   A]   A]   A]   A]   A]j   A]K   A],   A]
   A]   A]   A]   A]   A]r   A]S   A]4   A]   A]   A]   A]   A]   A]z   A][   A]<   A]   A]   A]   A]   A]   A]   A]c   A]D   A]%   A]   A]   A]   A]   A]k   A]L   A]-   A]   A]   A]   A]   A]   A]s   A]T   A]5   A]   A]   A]   A]ƹ   A]ǚ   A]{   A]\   A]=   A]   A]   A]   A]   A]΢   A]σ   A]d   A]E   A]&   A]   A]   A]   A]ժ   A]֋   A]l   A]M   A].   A]   A]   A]   A]ܲ   A]ݓ   A]t   A]U   A]6   A]   A]   A]   A]   A]   A]|   A]]   A]>   A]   A]    A]   A]   A]   A]   A]e   A]F   A]'   A]   A]   A]   A]   A]   A]m   A]N   A]/   A]   A]   A]   A]   A]   A]u   A]V   A]7   A]   A]   A]   A^    A^   A^}   A^^   A^?   A^    A^   A^   A^   A^   A^	   A^
f   A^G   A^(   A^
	   A^
   A^   A^   A^   A^n   A^O   A^0   A^   A^   A^   A^   A^   A^v   A^W   A^8   A^   A^   A^   A^   A^   A^~   A^ _   A^!@   A^"!   A^#   A^#   A^$   A^%   A^&   A^'g   A^(H   A^))   A^*
   A^*   A^+   A^,   A^-   A^.o   A^/P   A^01   A^1   A^1   A^2   A^3   A^4   A^5w   A^6X   A^79   A^8   A^8   A^9   A^:   A^;   A^<   A^=`   A^>A   A^?"   A^@   A^@   A^A   A^B   A^C   A^Dh   A^EI   A^F*   A^G   A^G   A^H   A^I   A^J   A^Kp   A^LQ   A^M2   A^N   A^N   A^O   A^P   A^Q   A^Rx   A^SY   A^T:   A^U   A^U   A^V   A^W   A^X   A^Y   A^Za   A^[B   A^\#   A^]   A^]   A^^   A^_   A^`   A^ai   A^bJ   A^c+   A^d   A^d   A^e   A^f   A^g   A^hq   A^iR   A^j3   A^k   A^k   A^l   A^m   A^n   A^oy   A^pZ   A^q;   A^r   A^r   A^s   A^t   A^u   A^v   A^wb   A^xC   A^y$   A^z   A^z   A^{   A^|   A^}   A^~j   A^K   A^,   A^
   A^   A^   A^   A^   A^r   A^S   A^4   A^   A^   A^   A^   A^   A^z   A^[   A^<   A^   A^   A^   A^   A^   A^   A^c   A^D   A^%   A^   A^   A^   A^   A^   A^k   A^L   A^-   A^   A^   A^   A^   A^   A^s   A^T   A^5   A^   A^   A^   A^   A^   A^{   A^\   A^=   A^   A^   A^   A^   A^   A^   A^d   A^E   A^&   A^   A^   A^   A^   A^   A^l   A^M   A^.   A^   A^   A^   A^   A^   A^t   A^U   A^6   A^   A^   A^   A^ĺ   A^ś   A^|   A^]   A^>   A^   A^    A^   A^   A^̣   A^̈́   A^e   A^F   A^'   A^   A^   A^   A^ӫ   A^Ԍ   A^m   A^N   A^/   A^   A^   A^   A^ڳ   A^۔   A^u   A^V   A^7   A^   A^   A^   A^   A^   A^}   A^^   A^?   A^    A^   A^   A^   A^   A^   A^f   A^G   A^(   A^	   A^   A^   A^   A^   A^n   A^O   A^0   A^   A^   A^   A^   A^   A^v   A^W   A^8   A^   A^   A^   A^   A^   A_ ~   A__   A_@   A_!   A_   A_   A_   A_   A_   A_g   A_	H   A_
)   A_
   A_   A_   A_
   A_   A_o   A_P   A_1   A_   A_   A_   A_   A_   A_w   A_X   A_9   A_   A_   A_   A_   A_   A_   A_`   A_A   A_ "   A_!   A_!   A_"   A_#   A_$   A_%h   A_&I   A_'*   A_(   A_(   A_)   A_*   A_+   A_,p   A_-Q   A_.2   A_/   A_/   A_0   A_1   A_2   A_3x   A_4Y   A_5:   A_6   A_6   A_7   A_8   A_9   A_:   A_;a   A_<B   A_=#   A_>   A_>   A_?   A_@   A_A   A_Bi   A_CJ   A_D+   A_E   A_E   A_F   A_G   A_H   A_Iq   A_JR   A_K3   A_L   A_L   A_M   A_N   A_O   A_Py   A_QZ   A_R;   A_S   A_S   A_T   A_U   A_V   A_W   A_Xb   A_YC   A_Z$   A_[   A_[   A_\   A_]   A_^   A__j   A_`K   A_a,   A_b
   A_b   A_c   A_d   A_e   A_fr   A_gS   A_h4   A_i   A_i   A_j   A_k   A_l   A_mz   A_n[   A_o<   A_p   A_p   A_q   A_r   A_s   A_t   A_uc   A_vD   A_w%   A_x   A_x   A_y   A_z   A_{   A_|k   A_}L   A_~-   A_   A_   A_   A_   A_   A_s   A_T   A_5   A_   A_   A_   A_   A_   A_{   A_\   A_=   A_   A_   A_   A_   A_   A_   A_d   A_E   A_&   A_   A_   A_   A_   A_   A_l   A_M   A_.   A_   A_   A_   A_   A_   A_t   A_U   A_6   A_   A_   A_   A_   A_   A_|   A_]   A_>   A_   A_    A_   A_   A_   A_   A_e   A_F   A_'   A_   A_   A_   A_   A_   A_m   A_N   A_/   A_   A_   A_   A_   A_   A_u   A_V   A_7   A_   A_   A_   A_»   A_Ü   A_}   A_^   A_?   A_    A_   A_   A_   A_ʤ   A_˅   A_f   A_G   A_(   A_	   A_   A_   A_Ѭ   A_ҍ   A_n   A_O   A_0   A_   A_   A_   A_ش   A_ٕ   A_v   A_W   A_8   A_   A_   A_   A_߼   A_   A_~   A__   A_@   A_!   A_   A_   A_   A_   A_   A_g   A_H   A_)   A_
   A_   A_   A_   A_   A_o   A_P   A_1   A_   A_   A_   A_   A_   A_w   A_X   A_9   A_   A_   A_   A_   A_   A_   A_`   A` A   A`"   A`   A`   A`   A`   A`   A`h   A`I   A`*   A`	   A`	   A`
   A`   A`   A`
p   A`Q   A`2   A`   A`   A`   A`   A`   A`x   A`Y   A`:   A`   A`   A`   A`   A`   A`   A`a   A`B   A`#   A`   A`   A`    A`!   A`"   A`#i   A`$J   A`%+   A`&   A`&   A`'   A`(   A`)   A`*q   A`+R   A`,3   A`-   A`-   A`.   A`/   A`0   A`1y   A`2Z   A`3;   A`4   A`4   A`5   A`6   A`7   A`8   A`9b   A`:C   A`;$   A`<   A`<   A`=   A`>   A`?   A`@j   A`AK   A`B,   A`C
   A`C   A`D   A`E   A`F   A`Gr   A`HS   A`I4   A`J   A`J   A`K   A`L   A`M   A`Nz   A`O[   A`P<   A`Q   A`Q   A`R   A`S   A`T   A`U   A`Vc   A`WD   A`X%   A`Y   A`Y   A`Z   A`[   A`\   A`]k   A`^L   A`_-   A``   A``   A`a   A`b   A`c   A`ds   A`eT   A`f5   A`g   A`g   A`h   A`i   A`j   A`k{   A`l\   A`m=   A`n   A`n   A`o   A`p   A`q   A`r   A`sd   A`tE   A`u&   A`v   A`v   A`w   A`x   A`y   A`zl   A`{M   A`|.   A`}   A`}   A`~   A`   A`   A`t   A`U   A`6   A`   A`   A`   A`   A`   A`|   A`]   A`>   A`   A`    A`   A`   A`   A`   A`e   A`F   A`'   A`   A`   A`   A`   A`   A`m   A`N   A`/   A`   A`   A`   A`   A`   A`u   A`V   A`7   A`   A`   A`   A`   A`   A`}   A`^   A`?   A`    A`   A`   A`   A`   A`   A`f   A`G   A`(   A`	   A`   A`   A`   A`   A`n   A`O   A`0   A`   A`   A`   A`   A`   A`v   A`W   A`8   A`   A`   A`   A`   A`   A`~   A`_   A`@   A`!   A`   A`   A`   A`ȥ   A`Ɇ   A`g   A`H   A`)   A`
   A`   A`   A`ϭ   A`Ў   A`o   A`P   A`1   A`   A`   A`   A`ֵ   A`ז   A`w   A`X   A`9   A`   A`   A`   A`ݽ   A`ޞ   A`   A``   A`A   A`"   A`   A`   A`   A`   A`   A`h   A`I   A`*   A`   A`   A`   A`   A`   A`p   A`Q   A`2   A`   A`   A`   A`   A`   A`x   A`Y   A`:   A`   A`   A`   A`   A`   A`   A`a   A`B   A`#   Aa    Aa    Aa   Aa   Aa   Aai   AaJ   Aa+   Aa   Aa   Aa   Aa	   Aa
   Aaq   AaR   Aa
3   Aa   Aa   Aa   Aa   Aa   Aay   AaZ   Aa;   Aa   Aa   Aa   Aa   Aa   Aa   Aab   AaC   Aa$   Aa   Aa   Aa   Aa   Aa    Aa!j   Aa"K   Aa#,   Aa$
   Aa$   Aa%   Aa&   Aa'   Aa(r   Aa)S   Aa*4   Aa+   Aa+   Aa,   Aa-   Aa.   Aa/z   Aa0[   Aa1<   Aa2   Aa2   Aa3   Aa4   Aa5   Aa6   Aa7c   Aa8D   Aa9%   Aa:   Aa:   Aa;   Aa<   Aa=   Aa>k   Aa?L   Aa@-   AaA   AaA   AaB   AaC   AaD   AaEs   AaFT   AaG5   AaH   AaH   AaI   AaJ   AaK   AaL{   AaM\   AaN=   AaO   AaO   AaP   AaQ   AaR   AaS   AaTd   AaUE   AaV&   AaW   AaW   AaX   AaY   AaZ   Aa[l   Aa\M   Aa].   Aa^   Aa^   Aa_   Aa`   Aaa   Aabt   AacU   Aad6   Aae   Aae   Aaf   Aag   Aah   Aai|   Aaj]   Aak>   Aal   Aam    Aam   Aan   Aao   Aap   Aaqe   AarF   Aas'   Aat   Aat   Aau   Aav   Aaw   Aaxm   AayN   Aaz/   Aa{   Aa{   Aa|   Aa}   Aa~   Aau   AaV   Aa7   Aa   Aa   Aa   Aa   Aa   Aa}   Aa^   Aa?   Aa    Aa   Aa   Aa   Aa   Aa   Aaf   AaG   Aa(   Aa	   Aa   Aa   Aa   Aa   Aan   AaO   Aa0   Aa   Aa   Aa   Aa   Aa   Aav   AaW   Aa8   Aa   Aa   Aa   Aa   Aa   Aa~   Aa_   Aa@   Aa!   Aa   Aa   Aa   Aa   Aa   Aag   AaH   Aa)   Aa
   Aa   Aa   Aa   Aa   Aao   AaP   Aa1   Aa   Aa   Aa   Aa   Aa   Aaw   AaX   Aa9   Aa   Aa   Aa   Aa   Aa   Aa   Aa`   AaA   Aa"   Aa   Aa   Aa   AaƦ   AaǇ   Aah   AaI   Aa*   Aa   Aa   Aa   Aaͮ   AaΏ   Aap   AaQ   Aa2   Aa   Aa   Aa   AaԶ   Aa՗   Aax   AaY   Aa:   Aa   Aa   Aa   Aa۾   Aaܟ   Aa݀   Aaa   AaB   Aa#   Aa   Aa   Aa   Aa   Aa   Aai   AaJ   Aa+   Aa   Aa   Aa   Aa   Aa   Aaq   AaR   Aa3   Aa   Aa   Aa   Aa   Aa   Aay   AaZ   Aa;   Aa   Aa   Aa   Aa   Aa   Aa   Aab   AaC   Aa$   Aa   Aa   Aa   Ab    Ab   Abj   AbK   Ab,   Ab
   Ab   Ab   Ab   Ab   Ab	r   Ab
S   Ab4   Ab   Ab   Ab
   Ab   Ab   Abz   Ab[   Ab<   Ab   Ab   Ab   Ab   Ab   Ab   Abc   AbD   Ab%   Ab   Ab   Ab   Ab   Ab   Abk   Ab L   Ab!-   Ab"   Ab"   Ab#   Ab$   Ab%   Ab&s   Ab'T   Ab(5   Ab)   Ab)   Ab*   Ab+   Ab,   Ab-{   Ab.\   Ab/=   Ab0   Ab0   Ab1   Ab2   Ab3   Ab4   Ab5d   Ab6E   Ab7&   Ab8   Ab8   Ab9   Ab:   Ab;   Ab<l   Ab=M   Ab>.   Ab?   Ab?   Ab@   AbA   AbB   AbCt   AbDU   AbE6   AbF   AbF   AbG   AbH   AbI   AbJ|   AbK]   AbL>   AbM   AbN    AbN   AbO   AbP   AbQ   AbRe   AbSF   AbT'   AbU   AbU   AbV   AbW   AbX   AbYm   AbZN   Ab[/   Ab\   Ab\   Ab]   Ab^   Ab_   Ab`u   AbaV   Abb7   Abc   Abc   Abd   Abe   Abf   Abg}   Abh^   Abi?   Abj    Abk   Abk   Abl   Abm   Abn   Abof   AbpG   Abq(   Abr	   Abr   Abs   Abt   Abu   Abvn   AbwO   Abx0   Aby   Aby   Abz   Ab{   Ab|   Ab}v   Ab~W   Ab8   Ab   Ab   Ab   Ab   Ab   Ab~   Ab_   Ab@   Ab!   Ab   Ab   Ab   Ab   Ab   Abg   AbH   Ab)   Ab
   Ab   Ab   Ab   Ab   Abo   AbP   Ab1   Ab   Ab   Ab   Ab   Ab   Abw   AbX   Ab9   Ab   Ab   Ab   Ab   Ab   Ab   Ab`   AbA   Ab"   Ab   Ab   Ab   Ab   Ab   Abh   AbI   Ab*   Ab   Ab   Ab   Ab   Ab   Abp   AbQ   Ab2   Ab   Ab   Ab   Ab   Ab   Abx   AbY   Ab:   Ab   Ab   Ab   Ab   Ab   Ab   Aba   AbB   Ab#   Ab   Ab   Ab   Abħ   Abň   Abi   AbJ   Ab+   Ab   Ab   Ab   Ab˯   Ab̐   Abq   AbR   Ab3   Ab   Ab   Ab   Abҷ   AbӘ   Aby   AbZ   Ab;   Ab   Ab   Ab   Abٿ   Abڠ   Abہ   Abb   AbC   Ab$   Ab   Ab   Ab   Ab   Ab   Abj   AbK   Ab,   Ab
   Ab   Ab   Ab   Ab   Abr   AbS   Ab4   Ab   Ab   Ab   Ab   Ab   Abz   Ab[   Ab<   Ab   Ab   Ab   Ab   Ab   Ab   Abc   AbD   Ab%   Ab   Ab   Ab   Ab   Ab   Ac k   AcL   Ac-   Ac   Ac   Ac   Ac   Ac   Acs   AcT   Ac	5   Ac
   Ac
   Ac   Ac   Ac
   Ac{   Ac\   Ac=   Ac   Ac   Ac   Ac   Ac   Ac   Acd   AcE   Ac&   Ac   Ac   Ac   Ac   Ac   Acl   AcM   Ac.   Ac    Ac    Ac!   Ac"   Ac#   Ac$t   Ac%U   Ac&6   Ac'   Ac'   Ac(   Ac)   Ac*   Ac+|   Ac,]   Ac->   Ac.   Ac/    Ac/   Ac0   Ac1   Ac2   Ac3e   Ac4F   Ac5'   Ac6   Ac6   Ac7   Ac8   Ac9   Ac:m   Ac;N   Ac</   Ac=   Ac=   Ac>   Ac?   Ac@   AcAu   AcBV   AcC7   AcD   AcD   AcE   AcF   AcG   AcH}   AcI^   AcJ?   AcK    AcL   AcL   AcM   AcN   AcO   AcPf   AcQG   AcR(   AcS	   AcS   AcT   AcU   AcV   AcWn   AcXO   AcY0   AcZ   AcZ   Ac[   Ac\   Ac]   Ac^v   Ac_W   Ac`8   Aca   Aca   Acb   Acc   Acd   Ace~   Acf_   Acg@   Ach!   Aci   Aci   Acj   Ack   Acl   Acmg   AcnH   Aco)   Acp
   Acp   Acq   Acr   Acs   Acto   AcuP   Acv1   Acw   Acw   Acx   Acy   Acz   Ac{w   Ac|X   Ac}9   Ac~   Ac~   Ac   Ac   Ac   Ac   Ac`   AcA   Ac"   Ac   Ac   Ac   Ac   Ac   Ach   AcI   Ac*   Ac   Ac   Ac   Ac   Ac   Acp   AcQ   Ac2   Ac   Ac   Ac   Ac   Ac   Acx   AcY   Ac:   Ac   Ac   Ac   Ac   Ac   Ac   Aca   AcB   Ac#   Ac   Ac   Ac   Ac   Ac   Aci   AcJ   Ac+   Ac   Ac   Ac   Ac   Ac   Acq   AcR   Ac3   Ac   Ac   Ac   Ac   Ac   Acy   AcZ   Ac;   Ac   Ac   Ac   Ac   Ac   Ac   Acb   AcC   Ac$   Ac   Ac   Ac   Ac¨   AcÉ   Acj   AcK   Ac,   Ac
   Ac   Ac   Acɰ   Acʑ   Acr   AcS   Ac4   Ac   Ac   Ac   Acи   Acљ   Acz   Ac[   Ac<   Ac   Ac   Ac   Ac   Acء   Acق   Acc   AcD   Ac%   Ac   Ac   Ac   Acߩ   Ac   Ack   AcL   Ac-   Ac   Ac   Ac   Ac   Ac   Acs   AcT   Ac5   Ac   Ac   Ac   Ac   Ac   Ac{   Ac\   Ac=   Ac   Ac   Ac   Ac   Ac   Ac   Acd   AcE   Ac&   Ac   Ac   Ac   Ac   Ac   Acl   AcM   Ad .   Ad   Ad   Ad   Ad   Ad   Adt   AdU   Ad6   Ad   Ad   Ad	   Ad
   Ad   Ad|   Ad
]   Ad>   Ad   Ad    Ad   Ad   Ad   Ad   Ade   AdF   Ad'   Ad   Ad   Ad   Ad   Ad   Adm   AdN   Ad/   Ad   Ad   Ad   Ad    Ad!   Ad"u   Ad#V   Ad$7   Ad%   Ad%   Ad&   Ad'   Ad(   Ad)}   Ad*^   Ad+?   Ad,    Ad-   Ad-   Ad.   Ad/   Ad0   Ad1f   Ad2G   Ad3(   Ad4	   Ad4   Ad5   Ad6   Ad7   Ad8n   Ad9O   Ad:0   Ad;   Ad;   Ad<   Ad=   Ad>   Ad?v   Ad@W   AdA8   AdB   AdB   AdC   AdD   AdE   AdF~   AdG_   AdH@   AdI!   AdJ   AdJ   AdK   AdL   AdM   AdNg   AdOH   AdP)   AdQ
   AdQ   AdR   AdS   AdT   AdUo   AdVP   AdW1   AdX   AdX   AdY   AdZ   Ad[   Ad\w   Ad]X   Ad^9   Ad_   Ad_   Ad`   Ada   Adb   Adc   Add`   AdeA   Adf"   Adg   Adg   Adh   Adi   Adj   Adkh   AdlI   Adm*   Adn   Adn   Ado   Adp   Adq   Adrp   AdsQ   Adt2   Adu   Adu   Adv   Adw   Adx   Adyx   AdzY   Ad{:   Ad|   Ad|   Ad}   Ad~   Ad   Ad   Ada   AdB   Ad#   Ad   Ad   Ad   Ad   Ad   Adi   AdJ   Ad+   Ad   Ad   Ad   Ad   Ad   Adq   AdR   Ad3   Ad   Ad   Ad   Ad   Ad   Ady   AdZ   Ad;   Ad   Ad   Ad   Ad   Ad   Ad   Adb   AdC   Ad$   Ad   Ad   Ad   Ad   Ad   Adj   AdK   Ad,   Ad
   Ad   Ad   Ad   Ad   Adr   AdS   Ad4   Ad   Ad   Ad   Ad   Ad   Adz   Ad[   Ad<   Ad   Ad   Ad   Ad   Ad   Ad   Adc   AdD   Ad%   Ad   Ad   Ad   Ad   Ad   Adk   AdL   Ad-   Ad   Ad   Ad   AdǱ   AdȒ   Ads   AdT   Ad5   Ad   Ad   Ad   Adι   AdϚ   Ad{   Ad\   Ad=   Ad   Ad   Ad   Ad   Ad֢   Ad׃   Add   AdE   Ad&   Ad   Ad   Ad   Adݪ   Adދ   Adl   AdM   Ad.   Ad   Ad   Ad   Ad   Ad   Adt   AdU   Ad6   Ad   Ad   Ad   Ad   Ad   Ad|   Ad]   Ad>   Ad   Ad    Ad   Ad   Ade   AdF   Ad'   Ad   Ad   Ad   Ad   Ad   Adm   AdN   Ad/   Ad   Ad   Ae    Ae   Ae   Aeu   AeV   Ae7   Ae   Ae   Ae   Ae	   Ae
}   Ae^   Ae?   Ae
    Ae   Ae   Ae   Ae   Ae   Aef   AeG   Ae(   Ae	   Ae   Ae   Ae   Ae   Aen   AeO   Ae0   Ae   Ae   Ae   Ae   Ae   Ae v   Ae!W   Ae"8   Ae#   Ae#   Ae$   Ae%   Ae&   Ae'~   Ae(_   Ae)@   Ae*!   Ae+   Ae+   Ae,   Ae-   Ae.   Ae/g   Ae6o   Ae7P   Ae?9   Ae@   AeA   AeB   AeC   AeD   AeE`   AeFA   AeG"   AeH   AeH   AeI   AeJ   AeK   AeLh   AeMI   AeN*   AeO   AeO   AeP   AeQ   AeR   AeSp   AeTQ   AeU2   AeV   AeV   AeW   AeX   AeY   AeZx   Ae[Y   Ae\:   Ae]   Ae]   Ae^   Ae_   Ae`   Aea   Aeba   AecB   Aed#   Aee   Aee   Aef   Aeg   Aeh   Aeii   AejJ   Aek+   Ael   Ael   Aem   Aen   Aeo   Aepq   AeqR   Aer3   Aes   Aes   Aet   Aeu   Aev   Aewy   AexZ   Aey;   Aez   Aez   Ae{   Ae|   Ae}   Ae~   Aeb   AeC   Ae$   Ae   Ae   Ae   Ae   Ae   Aej   AeK   Ae,   Ae
   Ae   Ae   Aer   Ae   Ae   Ae   Ae   Aez   Ae[   Ae<   Ae   Ae   Ae   Ae   Ae   Ae   Aec   AeD   Ae%   Ae   Ae   Ae   Ae   Ae   Aek   AeL   Ae-   Ae   Ae   Ae   Ae   Ae   Aes   AeT   Ae5   Ae   Ae   Ae   Ae   Ae   Ae{   Ae\   Ae=   Ae   Ae   Ae   Ae   Ae   Ae   Aed   AeE   Ae&   Ae   Ae   Ae   Ae   Ae   Ael   AeM   Ae.   Ae   Ae   Ae   AeŲ   AeƓ   Aet   AeU   Ae6   Ae   Ae   Ae   Ae̺   Ae͛   Ae|   Ae]   Ae>   Ae   Ae    Ae   Ae   Aeԣ   AeՄ   Aee   AeF   Ae'   Ae   Ae   Ae   Ae۫   Ae܌   Aem   AeN   Ae/   Ae   Ae   Ae   Ae   Ae   Aeu   AeV   Ae7   Ae   Ae   Ae   Ae   Ae   Ae}   Ae^   Ae?   Ae    Ae   Ae   Ae   Ae   Ae   Aef   AeG   Ae(   Ae	   Ae   Ae   Ae   Ae   Aen   AeO   Ae0   Ae   Ae   Ae   Ae   Af    Afv   AfW   Af8   Af   Af   Af   AӃ   AӃ   AӃ   AӃd   AӃE   AӃ&   AӃ   AӃ   AӃ   AӃ   AӃ   AӃl   AӃM   AӃ.   AӃ   AӃ   AӃ   AӃ   AӃ   AӃt   AӃU   AӃ6   AӃ   AӃ   AӃ   AӃ   AӃ   AӃ|   AӃ]   AӃ>   AӃ   AӃ    AӃ   AӃ   AӃ   AӃ   AӃe   AӃF   AӃ'   AӃ   AӃ   AӃ   AӃ   AӃ   AӃm   AӃN   AӃ/   AӃ   AӃ   AӃ   AӃĳ   AӃŔ   AӃu   AӃV   AӃ7   AӃ   AӃ   AӃ   AӃ˻   AӃ̜   AӃ}   AӃ^   AӃ?   AӃ    AӃ   AӃ   AӃ   AӃӤ   AӃԅ   AӃf   AӃG   AӃ(   AӃ	   AӃ   AӃ   AӃڬ   AӃۍ   AӃn   AӃO   AӃ0   AӃ   AӃ   AӃ   AӃ   AӃ   AӃv   AӃW   AӃ8   AӃ   AӃ   AӃ   AӃ   AӃ   AӃ~   AӃ_   AӃ@   AӃ!   AӃ   AӃ   AӃ   AӃ   AӃ   AӃg   AӃH   AӃ)   AӃ
   AӃ   AӃ   AӃ   AӃ   AӃo   AӃP   AӃ1   AӃ   AӃ   AӃ   AӃ   AӃ   Aӄ w   AӄX   Aӄ9   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ`   Aӄ	A   Aӄ
"   Aӄ   Aӄ   Aӄ   Aӄ
   Aӄ   Aӄh   AӄI   Aӄ*   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄp   AӄQ   Aӄ2   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄx   AӄY   Aӄ:   Aӄ    Aӄ    Aӄ!   Aӄ"   Aӄ#   Aӄ$   Aӄ%a   Aӄ&B   Aӄ'#   Aӄ(   Aӄ(   Aӄ)   Aӄ*   Aӄ+   Aӄ,i   Aӄ-J   Aӄ.+   Aӄ/   Aӄ/   Aӄ0   Aӄ1   Aӄ2   Aӄ3q   Aӄ4R   Aӄ53   Aӄ6   Aӄ6   Aӄ7   Aӄ8   Aӄ9   Aӄ:y   Aӄ;Z   Aӄ<;   Aӄ=   Aӄ=   Aӄ>   Aӄ?   Aӄ@   AӄA   AӄBb   AӄCC   AӄD$   AӄE   AӄE   AӄF   AӄG   AӄH   AӄIj   AӄJK   AӄK,   AӄL
   AӄL   AӄM   AӄN   AӄO   AӄPr   AӄQS   AӄR4   AӄS   AӄS   AӄT   AӄU   AӄV   AӄWz   AӄX[   AӄY<   AӄZ   AӄZ   Aӄ[   Aӄ\   Aӄ]   Aӄ^   Aӄ_c   Aӄ`D   Aӄa%   Aӄb   Aӄb   Aӄc   Aӄd   Aӄe   Aӄfk   AӄgL   Aӄh-   Aӄi   Aӄi   Aӄj   Aӄk   Aӄl   Aӄms   AӄnT   Aӄo5   Aӄp   Aӄp   Aӄq   Aӄr   Aӄs   Aӄt{   Aӄu\   Aӄv=   Aӄw   Aӄw   Aӄx   Aӄy   Aӄz   Aӄ{   Aӄ|d   Aӄ}E   Aӄ~&   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄl   AӄM   Aӄ.   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄt   AӄU   Aӄ6   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ|   Aӄ]   Aӄ>   Aӄ   Aӄ    Aӄ   Aӄ   Aӄ   Aӄ   Aӄe   AӄF   Aӄ'   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄm   AӄN   Aӄ/   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄu   AӄV   Aӄ7   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ}   Aӄ^   Aӄ?   Aӄ    Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄf   AӄG   Aӄ(   Aӄ	   Aӄ   Aӄ   Aӄ   Aӄ   Aӄn   AӄO   Aӄ0   Aӄ   Aӄ   Aӄ   Aӄ´   AӄÕ   Aӄv   AӄW   Aӄ8   Aӄ   Aӄ   Aӄ   Aӄɼ   Aӄʝ   Aӄ~   Aӄ_   Aӄ@   Aӄ!   Aӄ   Aӄ   Aӄ   Aӄѥ   Aӄ҆   Aӄg   AӄH   Aӄ)   Aӄ
   Aӄ   Aӄ   Aӄح   Aӄَ   Aӄo   AӄP   Aӄ1   Aӄ   Aӄ   Aӄ   Aӄߵ   Aӄ   Aӄw   AӄX   Aӄ9   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ`   AӄA   Aӄ"   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄh   AӄI   Aӄ*   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄp   AӄQ   Aӄ2   Aӄ   Aӄ   Aӄ   Aӄ   Aӄ   Aӄx   AӄY   AӅ :   AӅ   AӅ   AӅ   AӅ   AӅ   AӅ   AӅa   AӅB   AӅ#   AӅ	   AӅ	   AӅ
   AӅ   AӅ   AӅ
i   AӅJ   AӅ+   AӅ   AӅ   AӅ   AӅ   AӅ   AӅq   AӅR   AӅ3   AӅ   AӅ   AӅ   AӅ   AӅ   AӅy   AӅZ   AӅ;   AӅ   AӅ   AӅ   AӅ    AӅ!   AӅ"   AӅ#b   AӅ$C   AӅ%$   AӅ&   AӅ&   AӅ'   AӅ(   AӅ)   AӅ*j   AӅ+K   AӅ,,   AӅ-
   AӅ-   AӅ.   AӅ/   AӅ0   AӅ1r   AӅ2S   AӅ34   AӅ4   AӅ4   AӅ5   AӅ6   AӅ7   AӅ8z   AӅ9[   AӅ:<   AӅ;   AӅ;   AӅ<   AӅ=   AӅ>   AӅ?   AӅ@c   AӅAD   AӅB%   AӅC   AӅC   AӅD   AӅE   AӅF   AӅGk   AӅHL   AӅI-   AӅJ   AӅJ   AӅK   AӅL   AӅM   AӅNs   AӅOT   AӅP5   AӅQ   AӅQ   AӅR   AӅS   AӅT   AӅU{   AӅV\   AӅW=   AӅX   AӅX   AӅY   AӅZ   AӅ[   AӅ\   AӅ]d   AӅ^E   AӅ_&   AӅ`   AӅ`   AӅa   AӅb   AӅc   AӅdl   AӅeM   AӅf.   AӅg   AӅg   AӅh   AӅi   AӅj   AӅkt   AӅlU   AӅm6   AӅn   AӅn   AӅo   AӅp   AӅq   AӅr|   AӅs]   AӅt>   AӅu   AӅv    AӅv   AӅw   AӅx   AӅy   AӅze   AӅ{F   AӅ|'   AӅ}   AӅ}   AӅ~   AӅ   AӅ   AӅm   AӅN   AӅ/   AӅ   AӅ   AӅ   AӅ   AӅ   AӅu   AӅV   AӅ7   AӅ   AӅ   AӅ   AӅ   AӅ   AӅ}   AӅ^   AӅ?   AӅ    AӅ   AӅ   AӅ   AӅ   AӅ   AӅf   AӅG   AӅ(   AӅ	   AӅ   AӅ   AӅ   AӅ   AӅn   AӅO   AӅ0   AӅ   AӅ   AӅ   AӅ   AӅ   AӅv   AӅW   AӅ8   AӅ   AӅ   AӅ   AӅ   AӅ   AӅ~   AӅ_   AӅ@   AӅ!   AӅ   AӅ   AӅ   AӅ   AӅ   AӅg   AӅH   AӅ)   AӅ
   AӅ   AӅ   AӅ   AӅ   AӅo   AӅP   AӅ1   AӅ   AӅ   AӅ   AӅ   AӅ   AӅw   AӅX   AӅ9   AӅ   AӅ   AӅ   AӅǽ   AӅȞ   AӅ   AӅ`   AӅA   AӅ"   AӅ   AӅ   AӅ   AӅϦ   AӅЇ   AӅh   AӅI   AӅ*   AӅ   AӅ   AӅ   AӅ֮   AӅ׏   AӅp   AӅQ   AӅ2   AӅ   AӅ   AӅ   AӅݶ   AӅޗ   AӅx   AӅY   AӅ:   AӅ   AӅ   AӅ   AӅ   AӅ   AӅ   AӅa   AӅB   AӅ#   AӅ   AӅ   AӅ   AӅ   AӅ   AӅi   AӅJ   AӅ+   AӅ   AӅ   AӅ   AӅ   AӅ   AӅq   AӅR   AӅ3   AӅ   AӅ   AӅ   AӅ   AӅ   AӅy   AӅZ   AӅ;   AӅ   AӅ   Aӆ    Aӆ   Aӆ   Aӆ   Aӆb   AӆC   Aӆ$   Aӆ   Aӆ   Aӆ   Aӆ	   Aӆ
   Aӆj   AӆK   Aӆ
,   Aӆ
   Aӆ   Aӆ   Aӆ   Aӆ   Aӆr   AӆS   Aӆ4   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆz   Aӆ[   Aӆ<   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ    Aӆ!c   Aӆ"D   Aӆ#%   Aӆ$   Aӆ$   Aӆ%   Aӆ&   Aӆ'   Aӆ(k   Aӆ)L   Aӆ*-   Aӆ+   Aӆ+   Aӆ,   Aӆ-   Aӆ.   Aӆ/s   Aӆ0T   Aӆ15   Aӆ2   Aӆ2   Aӆ3   Aӆ4   Aӆ5   Aӆ6{   Aӆ7\   Aӆ8=   Aӆ9   Aӆ9   Aӆ:   Aӆ;   Aӆ<   Aӆ=   Aӆ>d   Aӆ?E   Aӆ@&   AӆA   AӆA   AӆB   AӆC   AӆD   AӆEl   AӆFM   AӆG.   AӆH   AӆH   AӆI   AӆJ   AӆK   AӆLt   AӆMU   AӆN6   AӆO   AӆO   AӆP   AӆQ   AӆR   AӆS|   AӆT]   AӆU>   AӆV   AӆW    AӆW   AӆX   AӆY   AӆZ   Aӆ[e   Aӆ\F   Aӆ]'   Aӆ^   Aӆ^   Aӆ_   Aӆ`   Aӆa   Aӆbm   AӆcN   Aӆd/   Aӆe   Aӆe   Aӆf   Aӆg   Aӆh   Aӆiu   AӆjV   Aӆk7   Aӆl   Aӆl   Aӆm   Aӆn   Aӆo   Aӆp}   Aӆq^   Aӆr?   Aӆs    Aӆt   Aӆt   Aӆu   Aӆv   Aӆw   Aӆxf   AӆyG   Aӆz(   Aӆ{	   Aӆ{   Aӆ|   Aӆ}   Aӆ~   Aӆn   AӆO   Aӆ0   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆv   AӆW   Aӆ8   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ~   Aӆ_   Aӆ@   Aӆ!   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆg   AӆH   Aӆ)   Aӆ
   Aӆ   Aӆ   Aӆ   Aӆ   Aӆo   AӆP   Aӆ1   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆw   AӆX   Aӆ9   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ`   AӆA   Aӆ"   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆh   AӆI   Aӆ*   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆp   AӆQ   Aӆ2   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆx   AӆY   Aӆ:   Aӆ   Aӆ   Aӆ   Aӆž   AӆƟ   Aӆǀ   Aӆa   AӆB   Aӆ#   Aӆ   Aӆ   Aӆ   Aӆͧ   AӆΈ   Aӆi   AӆJ   Aӆ+   Aӆ   Aӆ   Aӆ   Aӆԯ   AӆՐ   Aӆq   AӆR   Aӆ3   Aӆ   Aӆ   Aӆ   Aӆ۷   Aӆܘ   Aӆy   AӆZ   Aӆ;   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆb   AӆC   Aӆ$   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆj   AӆK   Aӆ,   Aӆ
   Aӆ   Aӆ   Aӆ   Aӆ   Aӆr   AӆS   Aӆ4   Aӆ   Aӆ   Aӆ   Aӆ   Aӆ   Aӆz   Aӆ[   Aӆ<   Aӆ   Aӆ   Aӆ   Aӆ   AӇ    AӇ   AӇc   AӇD   AӇ%   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ	k   AӇ
L   AӇ-   AӇ   AӇ   AӇ
   AӇ   AӇ   AӇs   AӇT   AӇ5   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ{   AӇ\   AӇ=   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ   AӇd   AӇ E   AӇ!&   AӇ"   AӇ"   AӇ#   AӇ$   AӇ%   AӇ&l   AӇ'M   AӇ(.   AӇ)   AӇ)   AӇ*   AӇ+   AӇ,   AӇ-t   AӇ.U   AӇ/6   AӇ0   AӇ0   AӇ1   AӇ2   AӇ3   AӇ4|   AӇ5]   AӇ6>   AӇ7   AӇ8    AӇ8   AӇ9   AӇ:   AӇ;   AӇ<e   AӇ=F   AӇ>'   AӇ?   AӇ?   AӇ@   AӇA   AӇB   AӇCm   AӇDN   AӇE/   AӇF   AӇF   AӇG   AӇH   AӇI   AӇJu   AӇKV   AӇL7   AӇM   AӇM   AӇN   AӇO   AӇP   AӇQ}   AӇR^   AӇS?   AӇT    AӇU   AӇU   AӇV   AӇW   AӇX   AӇYf   AӇZG   AӇ[(   AӇ\	   AӇ\   AӇ]   AӇ^   AӇ_   AӇ`n   AӇaO   AӇb0   AӇc   AӇc   AӇd   AӇe   AӇf   AӇgv   AӇhW   AӇi8   AӇj   AӇj   AӇk   AӇl   AӇm   AӇn~   AӇo_   AӇp@   AӇq!   AӇr   AӇr   AӇs   AӇt   AӇu   AӇvg   AӇwH   AӇx)   AӇy
   AӇy   AӇz   AӇ{   AӇ|   AӇ}o   AӇ~P   AӇ1   AӇ   AӇ   AӇ   AӇ   AӇ   AӇw   AӇX   AӇ9   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ`   AӇA   AӇ"   AӇ   AӇ   AӇ   AӇ   AӇ   AӇh   AӇI   AӇ*   AӇ   AӇ   AӇ   AӇ   AӇ   AӇp   AӇQ   AӇ2   AӇ   AӇ   AӇ   AӇ   AӇ   AӇx   AӇY   AӇ:   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ   AӇa   AӇB   AӇ#   AӇ   AӇ   AӇ   AӇ   AӇ   AӇi   AӇJ   AӇ+   AӇ   AӇ   AӇ   AӇ   AӇ   AӇq   AӇR   AӇ3   AӇ   AӇ   AӇ   AӇ   AӇ   AӇy   AӇZ   AӇ;   AӇ   AӇ   AӇ   AӇÿ   AӇĠ   AӇŁ   AӇb   AӇC   AӇ$   AӇ   AӇ   AӇ   AӇ˨   AӇ̉   AӇj   AӇK   AӇ,   AӇ
   AӇ   AӇ   AӇҰ   AӇӑ   AӇr   AӇS   AӇ4   AӇ   AӇ   AӇ   AӇٸ   AӇڙ   AӇz   AӇ[   AӇ<   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ   AӇc   AӇD   AӇ%   AӇ   AӇ   AӇ   AӇ   AӇ   AӇk   AӇL   AӇ-   AӇ   AӇ   AӇ   AӇ   AӇ   AӇs   AӇT   AӇ5   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ{   AӇ\   AӇ=   AӇ   AӇ   AӇ   AӇ   AӇ   AӇ   Aӈ d   AӈE   Aӈ&   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈl   AӈM   Aӈ	.   Aӈ
   Aӈ
   Aӈ   Aӈ   Aӈ
   Aӈt   AӈU   Aӈ6   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ|   Aӈ]   Aӈ>   Aӈ   Aӈ    Aӈ   Aӈ   Aӈ   Aӈ   Aӈe   AӈF   Aӈ'   Aӈ    Aӈ    Aӈ!   Aӈ"   Aӈ#   Aӈ$m   Aӈ%N   Aӈ&/   Aӈ'   Aӈ'   Aӈ(   Aӈ)   Aӈ*   Aӈ+u   Aӈ,V   Aӈ-7   Aӈ.   Aӈ.   Aӈ/   Aӈ0   Aӈ1   Aӈ2}   Aӈ3^   Aӈ4?   Aӈ5    Aӈ6   Aӈ6   Aӈ7   Aӈ8   Aӈ9   Aӈ:f   Aӈ;G   Aӈ<(   Aӈ=	   Aӈ=   Aӈ>   Aӈ?   Aӈ@   AӈAn   AӈBO   AӈC0   AӈD   AӈD   AӈE   AӈF   AӈG   AӈHv   AӈIW   AӈJ8   AӈK   AӈK   AӈL   AӈM   AӈN   AӈO~   AӈP_   AӈQ@   AӈR!   AӈS   AӈS   AӈT   AӈU   AӈV   AӈWg   AӈXH   AӈY)   AӈZ
   AӈZ   Aӈ[   Aӈ\   Aӈ]   Aӈ^o   Aӈ_P   Aӈ`1   Aӈa   Aӈa   Aӈb   Aӈc   Aӈd   Aӈew   AӈfX   Aӈg9   Aӈh   Aӈh   Aӈi   Aӈj   Aӈk   Aӈl   Aӈm`   AӈnA   Aӈo"   Aӈp   Aӈp   Aӈq   Aӈr   Aӈs   Aӈth   AӈuI   Aӈv*   Aӈw   Aӈw   Aӈx   Aӈy   Aӈz   Aӈ{p   Aӈ|Q   Aӈ}2   Aӈ~   Aӈ~   Aӈ   Aӈ   Aӈ   Aӈx   AӈY   Aӈ:   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈa   AӈB   Aӈ#   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈi   AӈJ   Aӈ+   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈq   AӈR   Aӈ3   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈy   AӈZ   Aӈ;   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈb   AӈC   Aӈ$   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈj   AӈK   Aӈ,   Aӈ
   Aӈ   Aӈ   Aӈ   Aӈ   Aӈr   AӈS   Aӈ4   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈz   Aӈ[   Aӈ<   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ¡   AӈÂ   Aӈc   AӈD   Aӈ%   Aӈ   Aӈ   Aӈ   Aӈɩ   Aӈʊ   Aӈk   AӈL   Aӈ-   Aӈ   Aӈ   Aӈ   Aӈб   Aӈђ   Aӈs   AӈT   Aӈ5   Aӈ   Aӈ   Aӈ   Aӈ׹   Aӈؚ   Aӈ{   Aӈ\   Aӈ=   Aӈ   Aӈ   Aӈ   Aӈ   Aӈߢ   Aӈ   Aӈd   AӈE   Aӈ&   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈl   AӈM   Aӈ.   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈt   AӈU   Aӈ6   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ   Aӈ|   Aӈ]   Aӈ>   Aӈ   Aӈ    Aӈ   Aӈ   Aӈ   Aӈ   Aӈe   AӈF   AӉ '   AӉ   AӉ   AӉ   AӉ   AӉ   AӉm   AӉN   AӉ/   AӉ   AӉ   AӉ	   AӉ
   AӉ   AӉu   AӉ
V   AӉ7   AӉ   AӉ   AӉ   AӉ   AӉ   AӉ}   AӉ^   AӉ?   AӉ    AӉ   AӉ   AӉ   AӉ   AӉ   AӉf   AӉG   AӉ(   AӉ	   AӉ   AӉ   AӉ    AӉ!   AӉ"n   AӉ#O   AӉ$0   AӉ%   AӉ%   AӉ&   AӉ'   AӉ(   AӉ)v   AӉ*W   AӉ+8   AӉ,   AӉ,   AӉ-   AӉ.   AӉ/   AӉ0~   AӉ1_   AӉ2@   AӉ3!   AӉ4   AӉ4   AӉ5   AӉ6   AӉ7   AӉ8g   AӉ9H   AӉ:)   AӉ;
   AӉ;   AӉ<   AӉ=   AӉ>   AӉ?o   AӉ@P   AӉA1   AӉB   AӉB   AӉC   AӉD   AӉE   AӉFw   AӉGX   AӉH9   AӉI   AӉI   AӉJ   AӉK   AӉL   AӉM   AӉN`   AӉOA   AӉP"   AӉQ   AӉQ   AӉR   AӉS   AӉT   AӉUh   AӉVI   AӉW*   AӉX   AӉX   AӉY   AӉZ   AӉ[   AӉ\p   AӉ]Q   AӉ^2   AӉ_   AӉ_   AӉ`   AӉa   AӉb   AӉcx   AӉdY   AӉe:   AӉf   AӉf   AӉg   AӉh   AӉi   AӉj   AӉka   AӉlB   AӉm#   AӉn   AӉn   AӉo   AӉp   AӉq   AӉri   AӉsJ   AӉt+   AӉu   AӉu   AӉv   AӉw   AӉx   AӉyq   AӉzR   AӉ{3   AӉ|   AӉ|   AӉ}   AӉ~   AӉ   AӉy   AӉZ   AӉ;   AӉ   AӉ   AӉ   AӉ   AӉ   AӉ   AӉb   AӉC   AӉ$   AӉ   AӉ   AӉ   AӉ   AӉ   AӉj   AӉK   AӉ,   AӉ
   AӉ   AӉ   AӉ   AӉ   AӉr   AӉS   AӉ4   AӉ   AӉ   AӉ   AӉ   AӉ   AӉz   AӉ[   AӉ<   AӉ   AӉ   AӉ   AӉ   AӉ   AӉ   AӉc   AӉD   AӉ%   AӉ   AӉ   AӉ   AӉ   AӉ   AӉk   AӉL   AӉ-   AӉ   AӉ   AӉ   AӉ   AӉ   AӉs   AӉT   AӉ5   AӉ   AӉ   AӉ   AӉ   AӉ   AӉ{   AӉ\   AӉ=   AӉ   AӉ   AӉ   AӉ   AӉ   AӉ   AӉd   AӉE   AӉ&   AӉ   AӉ   AӉ   AӉǪ   AӉȋ   AӉl   AӉM   AӉ.   AӉ   AӉ   AӉ   AӉβ   AӉϓ   AӉt   AӉU   AӉ6   AӉ   AӉ   AӉ   AӉպ   AӉ֛   AӉ|   AӉ]   AӉ>   AӉ   AӉ    AӉ   AӉ   AӉݣ   AӉބ   AӉe   AӉF   AӉ'   AӉ   AӉ   AӉ   AӉ   AӉ   AӉm   AӉN   AӉ/   AӉ   AӉ   AӉ   AӉ   AӉ   AӉu   AӉV   AӉ7   AӉ   AӉ   AӉ   AӉ   AӉ   AӉ}   AӉ^   AӉ?   AӉ    AӉ   AӉ   AӉ   AӉ   AӉ   AӉf   AӉG   AӉ(   AӉ	   AӉ   Aӊ    Aӊ   Aӊ   Aӊn   AӊO   Aӊ0   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ	   Aӊ
v   AӊW   Aӊ8   Aӊ
   Aӊ
   Aӊ   Aӊ   Aӊ   Aӊ~   Aӊ_   Aӊ@   Aӊ!   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊg   AӊH   Aӊ)   Aӊ
   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ o   Aӊ!P   Aӊ"1   Aӊ#   Aӊ#   Aӊ$   Aӊ%   Aӊ&   Aӊ'w   Aӊ(X   Aӊ)9   Aӊ*   Aӊ*   Aӊ+   Aӊ,   Aӊ-   Aӊ.   Aӊ/`   Aӊ0A   Aӊ1"   Aӊ2   Aӊ2   Aӊ3   Aӊ4   Aӊ5   Aӊ6h   Aӊ7I   Aӊ8*   Aӊ9   Aӊ9   Aӊ:   Aӊ;   Aӊ<   Aӊ=p   Aӊ>Q   Aӊ?2   Aӊ@   Aӊ@   AӊA   AӊB   AӊC   AӊDx   AӊEY   AӊF:   AӊG   AӊG   AӊH   AӊI   AӊJ   AӊK   AӊLa   AӊMB   AӊN#   AӊO   AӊO   AӊP   AӊQ   AӊR   AӊSi   AӊTJ   AӊU+   AӊV   AӊV   AӊW   AӊX   AӊY   AӊZq   Aӊ[R   Aӊ\3   Aӊ]   Aӊ]   Aӊ^   Aӊ_   Aӊ`   Aӊay   AӊbZ   Aӊc;   Aӊd   Aӊd   Aӊe   Aӊf   Aӊg   Aӊh   Aӊib   AӊjC   Aӊk$   Aӊl   Aӊl   Aӊm   Aӊn   Aӊo   Aӊpj   AӊqK   Aӊr,   Aӊs
   Aӊs   Aӊt   Aӊu   Aӊv   Aӊwr   AӊxS   Aӊy4   Aӊz   Aӊz   Aӊ{   Aӊ|   Aӊ}   Aӊ~z   Aӊ[   Aӊ<   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊc   AӊD   Aӊ%   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊk   AӊL   Aӊ-   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊs   AӊT   Aӊ5   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ{   Aӊ\   Aӊ=   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊd   AӊE   Aӊ&   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊl   AӊM   Aӊ.   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊt   AӊU   Aӊ6   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ|   Aӊ]   Aӊ>   Aӊ   Aӊ    Aӊ   Aӊ   Aӊ   Aӊ   Aӊe   AӊF   Aӊ'   Aӊ   Aӊ   Aӊ   Aӊū   Aӊƌ   Aӊm   AӊN   Aӊ/   Aӊ   Aӊ   Aӊ   Aӊ̳   Aӊ͔   Aӊu   AӊV   Aӊ7   Aӊ   Aӊ   Aӊ   Aӊӻ   AӊԜ   Aӊ}   Aӊ^   Aӊ?   Aӊ    Aӊ   Aӊ   Aӊ   Aӊۤ   Aӊ܅   Aӊf   AӊG   Aӊ(   Aӊ	   Aӊ   Aӊ   Aӊ   Aӊ   Aӊn   AӊO   Aӊ0   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊv   AӊW   Aӊ8   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ~   Aӊ_   Aӊ@   Aӊ!   Aӊ   Aӊ   Aӊ   Aӊ   Aӊ   Aӊg   AӊH   Aӊ)   Aӊ
   Aӊ   Aӊ   Aӊ   AӋ    AӋo   AӋP   AӋ1   AӋ   AӋ   AӋ   AӋ   AӋ   AӋw   AӋ	X   AӋ
9   AӋ   AӋ   AӋ   AӋ
   AӋ   AӋ   AӋ`   AӋA   AӋ"   AӋ   AӋ   AӋ   AӋ   AӋ   AӋh   AӋI   AӋ*   AӋ   AӋ   AӋ   AӋ   AӋ   AӋp   AӋQ   AӋ 2   AӋ!   AӋ!   AӋ"   AӋ#   AӋ$   AӋ%x   AӋ&Y   AӋ':   AӋ(   AӋ(   AӋ)   AӋ*   AӋ+   AӋ,   AӋ-a   AӋ.B   AӋ/#   AӋ0   AӋ0   AӋ1   AӋ2   AӋ3   AӋ4i   AӋ5J   AӋ6+   AӋ7   AӋ7   AӋ8   AӋ9   AӋ:   AӋ;q   AӋ<R   AӋ=3   AӋ>   AӋ>   AӋ?   AӋ@   AӋA   AӋBy   AӋCZ   AӋD;   AӋE   AӋE   AӋF   AӋG   AӋH   AӋI   AӋJb   AӋKC   AӋL$   AӋM   AӋM   AӋN   AӋO   AӋP   AӋQj   AӋRK   AӋS,   AӋT
   AӋT   AӋU   AӋV   AӋW   AӋXr   AӋYS   AӋZ4   AӋ[   AӋ[   AӋ\   AӋ]   AӋ^   AӋ_z   AӋ`[   AӋa<   AӋb   AӋb   AӋc   AӋd   AӋe   AӋf   AӋgc   AӋhD   AӋi%   AӋj   AӋj   AӋk   AӋl   AӋm   AӋnk   AӋoL   AӋp-   AӋq   AӋq   AӋr   AӋs   AӋt   AӋus   AӋvT   AӋw5   AӋx   AӋx   AӋy   AӋz   AӋ{   AӋ|{   AӋ}\   AӋ~=   AӋ   AӋ   AӋ   AӋ   AӋ   AӋ   AӋd   AӋE   AӋ&   AӋ   AӋ   AӋ   AӋ   AӋ   AӋl   AӋM   AӋ.   AӋ   AӋ   AӋ   AӋ   AӋ   AӋt   AӋU   AӋ6   AӋ   AӋ   AӋ   AӋ   AӋ   AӋ|   AӋ]   AӋ>   AӋ   AӋ    AӋ   AӋ   AӋ   AӋ   AӋe   AӋF   AӋ'   AӋ   AӋ   AӋ   AӋ   AӋ   AӋm   AӋN   AӋ/   AӋ   AӋ   AӋ   AӋ   AӋ   AӋu   AӋV   AӋ7   AӋ   AӋ   AӋ   AӋ   AӋ   AӋ}   AӋ^   AӋ?   AӋ    AӋ   AӋ   AӋ   AӋ   AӋ   AӋf   AӋG   AӋ(   AӋ	   AӋ   AӋ   AӋì   AӋč   AӋn   AӋO   AӋ0   AӋ   AӋ   AӋ   AӋʴ   AӋ˕   AӋv   AӋW   AӋ8   AӋ   AӋ   AӋ   AӋѼ   AӋҝ   AӋ~   AӋ_   AӋ@   AӋ!   AӋ   AӋ   AӋ   AӋ٥   AӋچ   AӋg   AӋH   AӋ)   AӋ
   AӋ   AӋ   AӋ   AӋ   AӋo   AӋP   AӋ1   AӋ   AӋ   AӋ   AӋ   AӋ   AӋw   AӋX   AӋ9   AӋ   AӋ   AӋ   AӋ   AӋ   AӋ   AӋ`   AӋA   AӋ"   AӋ   AӋ   AӋ   AӋ   AӋ   AӋh   AӋI   AӋ*   AӋ   AӋ   AӋ   AӋ   AӋ   AӋp   Aӌ Q   Aӌ2   Aӌ   Aӌ   Aӌ   Aӌ   Aӌ   Aӌx   AӌY   Aӌ:   Aӌ	   Aӌ	   Aӌ
   Aӌ   Aӌ   Aӌ
   Aӌa   AӌB   Aӌ#   Aӌ   Aӌ   Aӌ   Aӌ   Aӌ   Aӌi   AӌJ   Aӌ+   AӺx   AӺY   AӺ:   AӺ   AӺ   AӺ   AӺ   AӺ   AӺ   AӺa   AӺB   AӺ#   AӺ   AӺ   AӺ   AӺ   AӺ   AӺi   AӺJ   AӺ+   AӺ   AӺ   AӺ   AӺ   AӺ   AӺq   AӺR   AӺ3   AӺ   AӺ   AӺ   AӺ   AӺ   AӺy   AӺZ   AӺ;   AӺ   AӺ   AӺ   AӺ   AӺ   AӺ   AӺb   AӺC   AӺ$   AӺ   AӺ   AӺ   AӺŨ   AӺƉ   AӺj   AӺK   AӺ,   AӺ
   AӺ   AӺ   AӺ̰   AӺ͑   AӺr   AӺS   AӺ4   AӺ   AӺ   AӺ   AӺӸ   AӺԙ   AӺz   AӺ[   AӺ<   AӺ   AӺ   AӺ   AӺ   AӺۡ   AӺ܂   AӺc   AӺD   AӺ%   AӺ   AӺ   AӺ   AӺ   AӺ   AӺk   AӺL   AӺ-   AӺ   AӺ   AӺ   AӺ   AӺ   AӺs   AӺT   AӺ5   AӺ   AӺ   AӺ   AӺ   AӺ   AӺ{   AӺ\   AӺ=   AӺ   AӺ   AӺ   AӺ   AӺ   AӺ   AӺd   AӺE   AӺ&   AӺ   AӺ   AӺ   AӺ   Aӻ    Aӻl   AӻM   Aӻ.   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻt   Aӻ	U   Aӻ
6   Aӻ   Aӻ   Aӻ   Aӻ
   Aӻ   Aӻ|   Aӻ]   Aӻ>   Aӻ   Aӻ    Aӻ   Aӻ   Aӻ   Aӻ   Aӻe   AӻF   Aӻ'   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻm   AӻN   Aӻ /   Aӻ!   Aӻ!   Aӻ"   Aӻ#   Aӻ$   Aӻ%u   Aӻ&V   Aӻ'7   Aӻ(   Aӻ(   Aӻ)   Aӻ*   Aӻ+   Aӻ,}   Aӻ-^   Aӻ.?   Aӻ/    Aӻ0   Aӻ0   Aӻ1   Aӻ2   Aӻ3   Aӻ4f   Aӻ5G   Aӻ6(   Aӻ7	   Aӻ7   Aӻ8   Aӻ9   Aӻ:   Aӻ;n   Aӻ<O   Aӻ=0   Aӻ>   Aӻ>   Aӻ?   Aӻ@   AӻA   AӻBv   AӻCW   AӻD8   AӻE   AӻE   AӻF   AӻG   AӻH   AӻI~   AӻJ_   AӻK@   AӻL!   AӻM   AӻM   AӻN   AӻO   AӻP   AӻQg   AӻRH   AӻS)   AӻT
   AӻT   AӻU   AӻV   AӻW   AӻXo   AӻYP   AӻZ1   Aӻ[   Aӻ[   Aӻ\   Aӻ]   Aӻ^   Aӻ_w   Aӻ`X   Aӻa9   Aӻb   Aӻb   Aӻc   Aӻd   Aӻe   Aӻf   Aӻg`   AӻhA   Aӻi"   Aӻj   Aӻj   Aӻk   Aӻl   Aӻm   Aӻnh   AӻoI   Aӻp*   Aӻq   Aӻq   Aӻr   Aӻs   Aӻt   Aӻup   AӻvQ   Aӻw2   Aӻx   Aӻx   Aӻy   Aӻz   Aӻ{   Aӻ|x   Aӻ}Y   Aӻ~:   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻa   AӻB   Aӻ#   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻi   AӻJ   Aӻ+   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻq   AӻR   Aӻ3   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻy   AӻZ   Aӻ;   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻb   AӻC   Aӻ$   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻj   AӻK   Aӻ,   Aӻ
   Aӻ   Aӻ   Aӻ   Aӻ   Aӻr   AӻS   Aӻ4   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻz   Aӻ[   Aӻ<   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻé   AӻĊ   Aӻk   AӻL   Aӻ-   Aӻ   Aӻ   Aӻ   Aӻʱ   Aӻ˒   Aӻs   AӻT   Aӻ5   Aӻ   Aӻ   Aӻ   Aӻѹ   AӻҚ   Aӻ{   Aӻ\   Aӻ=   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ٢   Aӻڃ   Aӻd   AӻE   Aӻ&   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻl   AӻM   Aӻ.   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻt   AӻU   Aӻ6   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ|   Aӻ]   Aӻ>   Aӻ   Aӻ    Aӻ   Aӻ   Aӻ   Aӻ   Aӻe   AӻF   Aӻ'   Aӻ   Aӻ   Aӻ   Aӻ   Aӻ   Aӻm   AӼ N   AӼ/   AӼ   AӼ   AӼ   AӼ   AӼ   AӼu   AӼV   AӼ7   AӼ	   AӼ	   AӼ
   AӼ   AӼ   AӼ
}   AӼ^   AӼ?   AӼ    AӼ   AӼ   AӼ   AӼ   AӼ   AӼf   AӼG   AӼ(   AӼ	   AӼ   AӼ   AӼ   AӼ   AӼn   AӼO   AӼ0   AӼ   AӼ   AӼ    AӼ!   AӼ"   AӼ#v   AӼ$W   AӼ%8   AӼ&   AӼ&   AӼ'   AӼ(   AӼ)   AӼ*~   AӼ+_   AӼ,@   AӼ-!   AӼ.   AӼ.   AӼ/   AӼ0   AӼ1   AӼ2g   AӼ3H   AӼ4)   AӼ5
   AӼ5   AӼ6   AӼ7   AӼ8   AӼ9o   AӼ:P   AӼ;1   AӼ<   AӼ<   AӼ=   AӼ>   AӼ?   AӼ@w   AӼAX   AӼB9   AӼC   AӼC   AӼD   AӼE   AӼF   AӼG   AӼH`   AӼIA   AӼJ"   AӼK   AӼK   AӼL   AӼM   AӼN   AӼOh   AӼPI   AӼQ*   AӼR   AӼR   AӼS   AӼT   AӼU   AӼVp   AӼWQ   AӼX2   AӼY   AӼY   AӼZ   AӼ\   AӼ]x   AӼ^Y   AӼ_:   AӼ`   AӼ`   AӼa   AӼb   AӼc   AӼd   AӼea   AӼfB   AӼg#   AӼh   AӼh   AӼi   AӼj   AӼk   AӼli   AӼmJ   AӼn+   AӼo   AӼo   AӼp   AӼq   AӼr   AӼsq   AӼtR   AӼu3   AӼv   AӼv   AӼw   AӼx   AӼy   AӼzy   AӼ{Z   AӼ|;   AӼ}   AӼ}   AӼ~   AӼ   AӼ   AӼ   AӼb   AӼC   AӼ$   AӼ   AӼ   AӼ   AӼ   AӼ   AӼj   AӼK   AӼ,   AӼ
   AӼ   AӼ   AӼ   AӼ   AӼr   AӼS   AӼ4   AӼ   AӼ   AӼ   AӼ   AӼ   AӼz   AӼ[   AӼ<   AӼ   AӼ   AӼ   AӼ   AӼ   AӼ   AӼc   AӼD   AӼ%   AӼ   AӼ   AӼ   AӼ   AӼ   AӼk   AӼL   AӼ-   AӼ   AӼ   AӼ   AӼ   AӼ   AӼs   AӼT   AӼ5   AӼ   AӼ   AӼ   AӼ   AӼ   AӼ{   AӼ\   AӼ=   AӼ   AӼ   AӼ   AӼ   AӼ   AӼ   AӼd   AӼE   AӼ&   AӼ   AӼ   AӼ   AӼ   AӼ   AӼl   AӼM   AӼ.   AӼ   AӼ   AӼ   AӼȲ   AӼɓ   AӼt   AӼU   AӼ6   AӼ   AӼ   AӼ   AӼϺ   AӼЛ   AӼ|   AӼ]   AӼ>   AӼ   AӼ    AӼ   AӼ   AӼף   AӼ؄   AӼe   AӼF   AӼ'   AӼ   AӼ   AӼ   AӼޫ   AӼߌ   AӼm   AӼN   AӼ/   AӼ   AӼ   AӼ   AӼ   AӼ   AӼu   AӼV   AӼ7   AӼ   AӼ   AӼ   AӼ   AӼ   AӼ}   AӼ^   AӼ?   AӼ    AӼ   AӼ   AӼ   AӼ   AӼ   AӼf   AӼG   AӼ(   AӼ	   AӼ   AӼ   AӼ   AӼ   AӼn   AӼO   AӼ0   Aӽ    Aӽ    Aӽ   Aӽ   Aӽ   Aӽv   AӽW   Aӽ8   Aӽ   Aӽ   Aӽ   Aӽ	   Aӽ
   Aӽ~   Aӽ_   Aӽ
@   Aӽ!   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽg   AӽH   Aӽ)   Aӽ
   Aӽ   Aӽ   Aӽ   Aӽ   Aӽo   AӽP   Aӽ1   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ    Aӽ!w   Aӽ"X   Aӽ#9   Aӽ$   Aӽ$   Aӽ%   Aӽ&   Aӽ'   Aӽ(   Aӽ)`   Aӽ*A   Aӽ+"   Aӽ,   Aӽ,   Aӽ-   Aӽ.   Aӽ/   Aӽ0h   Aӽ1I   Aӽ2*   Aӽ3   Aӽ3   Aӽ4   Aӽ5   Aӽ6   Aӽ7p   Aӽ8Q   Aӽ92   Aӽ:   Aӽ:   Aӽ;   Aӽ<   Aӽ=   Aӽ>x   Aӽ?Y   Aӽ@:   AӽA   AӽA   AӽC   AӽD   AӽE   AӽFa   AӽGB   AӽH#   AӽI   AӽI   AӽJ   AӽK   AӽL   AӽMi   AӽNJ   AӽO+   AӽP   AӽP   AӽQ   AӽR   AӽS   AӽTq   AӽUR   AӽV3   AӽW   AӽW   AӽX   AӽY   AӽZ   Aӽ[y   Aӽ\Z   Aӽ];   Aӽ^   Aӽ^   Aӽ_   Aӽ`   Aӽa   Aӽb   Aӽcb   AӽdC   Aӽe$   Aӽf   Aӽf   Aӽg   Aӽh   Aӽi   Aӽjj   AӽkK   Aӽl,   Aӽm
   Aӽm   Aӽn   Aӽo   Aӽp   Aӽqr   AӽrS   Aӽs4   Aӽt   Aӽt   Aӽu   Aӽv   Aӽw   Aӽxz   Aӽy[   Aӽz<   Aӽ{   Aӽ{   Aӽ|   Aӽ}   Aӽ~   Aӽ   Aӽc   AӽD   Aӽ%   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽk   AӽL   Aӽ-   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽs   AӽT   Aӽ5   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ{   Aӽ\   Aӽ=   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽd   AӽE   Aӽ&   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽl   AӽM   Aӽ.   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽt   AӽU   Aӽ6   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ|   Aӽ]   Aӽ>   Aӽ   Aӽ    Aӽ   Aӽ   Aӽ   Aӽ   Aӽe   AӽF   Aӽ'   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽm   AӽN   Aӽ/   Aӽ   Aӽ   Aӽ   AӽƳ   Aӽǔ   Aӽu   AӽV   Aӽ7   Aӽ   Aӽ   Aӽ   Aӽͻ   AӽΜ   Aӽ}   Aӽ^   Aӽ?   Aӽ    Aӽ   Aӽ   Aӽ   Aӽդ   Aӽօ   Aӽf   AӽG   Aӽ(   Aӽ	   Aӽ   Aӽ   Aӽܬ   Aӽݍ   Aӽn   AӽO   Aӽ0   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽv   AӽW   Aӽ8   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ~   Aӽ_   Aӽ@   Aӽ!   Aӽ   Aӽ   Aӽ   Aӽ   Aӽ   Aӽg   AӽH   Aӽ)   Aӽ
   Aӽ   Aӽ   Aӽ   Aӽ   Aӽo   AӽP   Aӽ1   Aӽ   Aӽ   Aӽ   AӾ    AӾ   AӾw   AӾX   AӾ9   AӾ   AӾ   AӾ   AӾ   AӾ   AӾ	   AӾ
`   AӾA   AӾ"   AӾ
   AӾ
   AӾ   AӾ   AӾ   AӾh   AӾI   AӾ*   AӾ   AӾ   AӾ   AӾ   AӾ   AӾp   AӾQ   AӾ2   AӾ   AӾ   AӾ   AӾ   AӾ   AӾx   AӾ Y   AӾ!:   AӾ"   AӾ"   AӾ#   AӾ$   AӾ%   AӾ&   AӾ'a   AӾ(B   AӾ)#   AӾ*   AӾ*   AӾ+   AӾ,   AӾ-   AӾ.i   AӾ/J   AӾ0+   AӾ1   AӾ1   AӾ2   AӾ3   AӾ4   AӾ5q   AӾ6R   AӾ73   AӾ8   AӾ8   AӾ9   AӾ:   AӾ;   AӾ<y   AӾ=Z   AӾ>;   AӾ?   AӾ?   AӾ@   AӾA   AӾB   AӾC   AӾDb   AӾEC   AӾF$   AӾG   AӾG   AӾH   AӾI   AӾJ   AӾKj   AӾLK   AӾM,   AӾN
   AӾN   AӾO   AӾP   AӾQ   AӾRr   AӾSS   AӾT4   AӾU   AӾU   AӾV   AӾW   AӾX   AӾYz   AӾZ[   AӾ[<   AӾ\   AӾ\   AӾ]   AӾ^   AӾ_   AӾ`   AӾac   AӾbD   AӾc%   AӾd   AӾd   AӾe   AӾf   AӾg   AӾhk   AӾiL   AӾj-   AӾk   AӾk   AӾl   AӾm   AӾn   AӾos   AӾpT   AӾq5   AӾr   AӾr   AӾs   AӾt   AӾu   AӾv{   AӾw\   AӾx=   AӾy   AӾy   AӾz   AӾ{   AӾ|   AӾ}   AӾ~d   AӾE   AӾ&   AӾ   AӾ   AӾ   AӾ   AӾ   AӾl   AӾM   AӾ.   AӾ   AӾ   AӾ   AӾ   AӾ   AӾt   AӾU   AӾ6   AӾ   AӾ   AӾ   AӾ   AӾ   AӾ|   AӾ]   AӾ>   AӾ   AӾ    AӾ   AӾ   AӾ   AӾ   AӾe   AӾF   AӾ'   AӾ   AӾ   AӾ   AӾ   AӾ   AӾm   AӾN   AӾ/   AӾ   AӾ   AӾ   AӾ   AӾ   AӾu   AӾV   AӾ7   AӾ   AӾ   AӾ   AӾ   AӾ   AӾ}   AӾ^   AӾ?   AӾ    AӾ   AӾ   AӾ   AӾ   AӾ   AӾf   AӾG   AӾ(   AӾ	   AӾ   AӾ   AӾ   AӾ   AӾn   AӾO   AӾ0   AӾ   AӾ   AӾ   AӾĴ   AӾŕ   AӾv   AӾW   AӾ8   AӾ   AӾ   AӾ   AӾ˼   AӾ̝   AӾ~   AӾ_   AӾ@   AӾ!   AӾ   AӾ   AӾ   AӾӥ   AӾԆ   AӾg   AӾH   AӾ)   AӾ
   AӾ   AӾ   AӾڭ   AӾێ   AӾo   AӾP   AӾ1   AӾ   AӾ   AӾ   AӾ   AӾ   AӾw   AӾX   AӾ9   AӾ   AӾ   AӾ   AӾ   AӾ   AӾ   AӾ`   AӾA   AӾ"   AӾ   AӾ   AӾ   AӾ   AӾ   AӾh   AӾI   AӾ*   AӾ   AӾ   AӾ   AӾ   AӾ   AӾp   AӾQ   AӾ2   AӾ   AӾ   AӾ   AӾ   AӾ   Aӿ x   AӿY   Aӿ:   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿa   Aӿ	B   Aӿ
#   Aӿ   Aӿ   Aӿ   Aӿ
   Aӿ   Aӿi   AӿJ   Aӿ+   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿq   AӿR   Aӿ3   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿy   AӿZ   Aӿ;   Aӿ    Aӿ    Aӿ!   Aӿ"   Aӿ#   Aӿ$   Aӿ%b   Aӿ&C   Aӿ'$   Aӿ(   Aӿ(   Aӿ)   Aӿ*   Aӿ+   Aӿ,j   Aӿ-K   Aӿ.,   Aӿ/
   Aӿ/   Aӿ0   Aӿ1   Aӿ2   Aӿ3r   Aӿ4S   Aӿ54   Aӿ6   Aӿ6   Aӿ7   Aӿ8   Aӿ9   Aӿ:z   Aӿ;[   Aӿ<<   Aӿ=   Aӿ=   Aӿ>   Aӿ?   Aӿ@   AӿA   AӿBc   AӿCD   AӿD%   AӿE   AӿE   AӿF   AӿG   AӿH   AӿIk   AӿJL   AӿK-   AӿL   AӿL   AӿM   AӿN   AӿO   AӿPs   AӿQT   AӿR5   AӿS   AӿS   AӿT   AӿU   AӿV   AӿW{   AӿX\   AӿY=   AӿZ   AӿZ   Aӿ[   Aӿ\   Aӿ]   Aӿ^   Aӿ_d   Aӿ`E   Aӿa&   Aӿb   Aӿb   Aӿc   Aӿd   Aӿe   Aӿfl   AӿgM   Aӿh.   Aӿi   Aӿi   Aӿj   Aӿk   Aӿl   Aӿmt   AӿnU   Aӿo6   Aӿp   Aӿp   Aӿq   Aӿr   Aӿs   Aӿt|   Aӿu]   Aӿv>   Aӿw   Aӿx    Aӿx   Aӿy   Aӿz   Aӿ{   Aӿ|e   Aӿ}F   Aӿ~'   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿm   AӿN   Aӿ/   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿu   AӿV   Aӿ7   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ}   Aӿ^   Aӿ?   Aӿ    Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿf   AӿG   Aӿ(   Aӿ	   Aӿ   Aӿ   Aӿ   Aӿ   Aӿn   AӿO   Aӿ0   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿv   AӿW   Aӿ8   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ~   Aӿ_   Aӿ@   Aӿ!   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   Aӿg   AӿH   Aӿ)   Aӿ
   Aӿ   Aӿ   Aӿ   Aӿ   Aӿo   AӿP   Aӿ1   Aӿ   Aӿ   Aӿ   Aӿµ   AӿÖ   Aӿw   AӿX   Aӿ9   Aӿ   Aӿ   Aӿ   Aӿɽ   Aӿʞ   Aӿ   Aӿ`   AӿA   Aӿ"   Aӿ   Aӿ   Aӿ   AӿѦ   Aӿ҇   Aӿh   AӿI   Aӿ*   Aӿ   Aӿ   Aӿ   Aӿخ   Aӿُ   Aӿp   AӿQ   Aӿ2   Aӿ   Aӿ   Aӿ   Aӿ߶   Aӿ   Aӿx   AӿY   Aӿ:   Aӿ   Aӿ   Aӿ   Aӿ   Aӿ   AQAAffAzA¸RA
=A
AAffA
AAģAƏ\AffAA{AffAzAģAĸRA=qAď\A
=A33A
=ApAGAAƣAƸRAŮAȏ\A{AQAQAffAƏ\AAA(AffAŅAřA33A{AÅApAHAAHApAA\)AÙA{AîAAA£A(AAzAAQAA
=A(A{AApAGAŮAGAA{AA\)AAƣAAAAffAAď\AA
=AAîAHAGAA\AffAA=qAGAGApAA
A\AHApAA{A(AA\)A\A=qAQAQAAA
AAA(AAGA\)AAŅA\)AA\A¸RAAA
=AffAffA33AA  A  AffA
AƸRAA33AAƸRA(AAzAƏ\AAzAzAîA=qA{AA
Aď\A33A=qA{AGA
=ApAAA=qA(Aď\AîAA\AA
A\AQA(AA\A=qAAAģA=qAGAzA
A
=A
=A=qAzAÅA
=AApA{A  A¸RA=qApAA¸RAQApA
ARA33AA=qAzAHAHAA  ApAƏ\AA\)A\)A=qAÅAĸRApAffAAAȏ\AǅA(AAAffA{A(A33AHAĸRA£AAAQARAAzA
=A  ApA=qAîAÙAHAQAřAHAzAzA  A  AA(AƣAAGA(A{ApAAQAAAApAApA  AAAAAAGAA\)A=qA  A=qAA=qAQAAA\)A33A\AA33A\)AAA
A\)AAGAApA{AQAAffApAAzAHA
AGA33AGAAAAAA
A\)A
=AA
AAAAAzA{AAA\A\)A=qApAQAAzAA(AA{A
=A
=AA\)AAAA
AHAA=qAQAAffAAffAA\)AAA  A(A\AA{A¸RAHAGAAģA\)A{AQAƏ\A  A{ApAAffAĸRAGA
AAHAAAzA¸RAzA
AGAzAA\)AzAƣAHA
=AÅA{AQAîAQA\)A=qAA£A
A  A
AĸRAHAAA(ApA33AAAffApA
=ApA(AAA(AHA=qA  AƏ\AAQAAHAApAA=qA
A{AQApAffAAffA\)AîAzAÙApAA\)AQA\A33AAffAAffAA
A  AAAA{AA
=A{AzAÙAAGA
AģA
=AŅA\)AGA\)AŅAAAA(AzAGAģAA(A=qA
AA(AHAzAffA(A{AAA
=AAAHAĸRA\)AAGAHA\)A\)A33AAffAÅAƏ\AAȣA
A
AzAȣAAȣApAQAAƏ\AAffAǮA33A\)AǮAǙAAƏ\A\)AAffA
=AHApAƣAHAGAĸRA(AAHA
=A{AQAAAď\AA(AHAHA=qA(AƣAffAƣA
A
=AHAAAGApA
A{A{A{AŅApAGAGA
=AĸRAîAAffA
AAAAAÙAÙA\)AGAA(AAAffAA¸RA{AAzA
=A\)A\)A  AĸRA{AA=qAHAAď\AřAƣA33AAƸRAffAffAA
=A£A
=AA33A{A
AzA(A\)A
=AAGAAAHAA(ApAApA
A
A
=AAAA\)A
=A\AAA
AzAAA\AAA
=AAA\ARA
AA
=A\)A  A
=AAAA  AAAAA(AAAA33ARAGAA{AA\)ARAffAA(AA{AAARAGA
A  AA
=AHAAAAA\)AzAQAGARAA(AAAA
A33AAAAAHAzA\)AAAA
=A33AAAAAAAffAAAAAAHA=qAA
A\)A  AffA
=AffAzAApA  Aď\AřA33A\)ApA
A  A(ApAAĸRAAA=qAffA=qAģAffAHA
=A  A(AHAQA=qA\ARA{AAzApA\A\A(AA{A{AAGAA=qAAA\)ARARAAA\AzA\A\A(A
=A\)A\)A=qAffAAAGAA\)AAHARA33AAA\)A{AAAAAA
A  AA(AAffAAzARAffA(A\)A
AAffAA33AAAGAGA\)AGAAAAAAffARAA
=AAHAAAffAzAQAzAA
=AAGAAAAzAAAA  AA{A{AffAď\AffA
=AÙA  ApAzAzAzApApA\)AAQAAHA\)A
=ApA
=AAQAGAzAHAAAzAA=qAffAA33AA
A(AARAzA=qARAAAģA=qA  AA(ApAHAGApAA
A  AzA
AA(AAGAAA\)AAA33AA\AzAzAA  A
AQA{A  A{AQA(A\A\AA  A=qAA{A(A{A  A{A=qAA
=AAA
A(AAQA\)AA
=AGA(A\A\AAzA{AAAA
=A=qA\)A(AzARAAQAHA
ApAAAAHA
AGAAA\)AffAA
=A
=AAQAGApAAA
=AA33A=qAA=qAAffAffAAA
=AA33AAAAGAHA33A
=ApA{AApAAAAAAffAffAffA=qAzAffAA
=AffAAAQA\)AAAzAAAA
AA{A
=AffApAA=qAÙAA{A{AQAAHA\)A{ApAAA\A{A{A{AA(A
=ARA\A  AHAAGAA\)AARA
=A{A33A33A(A{AQAHAA\)A
=AA¸RA
=A33A\)AÙAÙApA
AîAA(A(AQA{A{A{A{AA
AA\)ApA\)A\)A33ApAA
=AAA\)A\)AÅA
AQA=qAGA(A¸RA=qAAA
A{AA=qAA
=A\AHAA  A
=AA=qAAHA£AGAÅAHA¸RA
AzA=qAA\)A(AzA\)A\)A
A33A
AA£AAARA¸RA=qAAARAQA  A(AA33ARAffAAzAAAAGAÙAÅAÙApAA33A
=AAAAAAA=qA{AffAHA£A(A
AA33A33A
=AApApA
=A£AAAAffAAQAApAAffA=qAA\AHAA
AAA=qA(AAQApAAHAA
A33A\)AGAAAHAffAHAQAffAHAAA\)A
AAffA{AffA\A{AA33A33A33AAzAQA=qAGAQAApAA\)A33A
AzAAAřAA(A{AƏ\AƣAAAƸRAHAAA
=AAƸRAƣAHA
=AƣAAQAAŮA\)AřA
AA{A\)A33AA{A\)A\)A
=AǅA\)AA\)AAzAAAȏ\AȣA=qApAƸRA
=AHA\)A
=A=qA{AffAffAAffAģAģAAģA
=AAģA(A\AAGA£AQA(A\AQAzA\A  A
A\)AA33AApAHAA33A
AA\A
=A{AĸRAģAAApA
AGA
=AA\AA(AAA{AA=qA
=A\)A
A33A=qA\)AA
AA  A
A{AAA33A\)AAzARAAAzA\AffAQAffA
=AA\AHARAAAAAzAffAAGA
=AA\ApAƸRAAzAAÅA¸RAA\)Aď\AAÙAHAGA\A33A
=A  A£AQAzAHA33AAApAAA=qA=qAzApA(A
=A33AAAA(A
=AAzAzA{A\)AAAAA33AzA=qAffA
=A=qAřAAƣA
AŅAřAAAQAzAAA
=Aď\AHA(ApApAA=qA
=AQA
=AHAA(A{AA(AA\AA
A{A
A{AffA£A£A\)AîA  A=qA{A{AzAģAģA{A=qAGAQA  AAď\AA{AHA=qA=qAA=qA{A\)A  AA  AffAQAQAGA33AA(A33AffA
AA  AA
AģAzApA33AAzAA\)A(A
=A
=AA{A
A
AzAAHA33A\)AÅApA\)A\)AGA
=A33A33A33AA33A33AA£AA=qAA{AzA¸RA\)Aď\A(AÅAď\AAHAHAffAĸRA\)AA\)AģAAģA
=A
AAĸRA\)AGAzAffA\AffA(A  A\)A\)AGApAAGA(AAAA33AA
ARAffAAA\AffAAzAHA  AA\AQAffA(AHAAffAA(AAAzAAGAA  A\AAGA\)AffA\A=qA(A¸RAAA  A=qA{AA(A{AffA33AAAÅA{A
A¸RAHAAA{AApA{AzAGAA
=A
AGAAffAzA  AAA
AQAA
A
=ARAGA(AzA
AAARAApAA=qAAHAA{AHA
=AAAÅAffAA(A(ARA  AAA\)AGAAAAAAzApAAAHAApAHA\AzAzAQAA
=AAAzA\)A
=A
AA{A
=AARAA(AA
=AAARA
=AAQA  A(A(AQAHAARA  AffARAA{AA
AQAAQAAQAAA  A  A=qA  ApARAGAA=qAAzAA=qAA{AAAHAHAA
=AAAApAGAA(AA\AAARAQAHAA
AzAzA(AAAzARAAAARAHA  AAAAAzA
=AAQAA(A{A\A£A\A(A{A
AGA\)A33A(A{ApA
=A¸RAÅAffA£A
=AAA(AQAA\)A(AGAQA¸RAÅA(AĸRAffA=qA{ApA
AAHA¸RAGAA  AGA{AAAffAAARAAGA
AHAHA=qAQAAAA{ApA33AîAQAAģAA¸RAGA  AQAAAGAzAA33AAHA{AAAzAA
A{AAzAA{AGA33AA(A{AAffA  AAĸRAAîAAAGA{AģAAA\)AA\)A
AzA{AA=qA(A\)AîA33AQA(AHAAAA{AQA(A  AA33AA\)AAGAA
AîAîAîAAAAzA\)AAAAGAQAAffA(A\)A  ApAA(A  AffAffAAAHAAQA\AAAffA=qAHAApAQAAA(AQAA\)AA  A=qAffAQA  A\)AAA
=AAHAAAAA\)A  A=qAQAAAA=qA
A33AA  A\A=qAAQAAHAAA  AARA33A33AAAAÅAffAQAAA  A33AGAApAA
A
A  A
A\)A=qAA  ApA=qApApAffAAA
AAAA=qA=qA\A\A{A{ApA
=AAA
=A
=AApAA£AAQAĸRAA\A{AA\)AA=qAQA  A33A33AAAAA\AQA33AAA33AAGA  AA  AA\)AHAAA  A\)AA\AA
=A\A\)AGA
AAAAffA\A=qARAA\A{AA  A33A(AQAHAGAGApAA{AQAAzA\)A=qAîA\A=qA\)AAARAQA\)AA=qA\A(AAQA  A33AAzAAARA
=AA(A\)AA
A
A  AzA\AAA33AffAAA33ARA
A\A33AffAHAA\AzA(AApA
AffAffAAffAAzA=qA\)A{AzA¸RA
AGAAA
AAA
=AffA
=A{AA¸RAGA  A
=AGAzAA=qAAAA¸RAA33AAA{A{AQAîA(A  A(A\)A\)A{AA=qA33A=qAApAHAAA¸RAA33AA
A  AGAA  AHAAAApAA{AzARAA\ARAzA=qAffAAA33AAAA=qAAAAAGA33A
=AA(A\)AHA
AîA
AřA\)AŅA{A\)Aď\AÅAGA33AA=qA
=AŅAŅApA{A  AA
AřAQAA  AGA  AHAAGAzAQAffApAQAA33AAA=qARA\A{ApAA\ApAAA
=AApAAQAAAA33A
=AQAffAAAQA\A(AHA
=A¸RAAAAAAAA\AffAGAA\)AÅAřA
=A=qAģA=qA  A  AîA
AA{A=qAffA{AzAGAAAA=qAŅA(A=qAŮAzA  AHA=qApAHAApAAAA(AHAffAAAAAA=qAAHAA\)A  A\)AHAffA
AHAA
AA
=AHA(A\AAA=qA\AApAffAQAffAGAÅA{AA33A¸RAAHA33AAGA33AAA
=A33A\)AGAAAAAAA\AQAQAzAAAHAQARA  AAAA¸RAAAÙAîAÙA=qAHA33A33AA
=AA
=AHAAģAQAÅAGAGA  AAA=qAHA£A
=A\)AAAAGAA33AA{AAAAÅAzAA(A{A(AHA
=A  AHA
=AQA  AAAzA\A
AA33AffA=qA{ApA
=AAA\AGAGAQAAA(AAA
=A  AAAHAAA(AAHA
A(A\)A\AA33AAAQA33AAQA\)ApARA\A=qA\A33A\AGA£A£A(AGA
=AA
AAQAARAAAAA£AA  AĸRA(AA\)AA
=A\)ApAAA(A  A
AQA
=AARAAAGAQA  AARA{AzA=qAApA=qAGAA=qAGA{AAAHA(A\)A{A33AGAApA\AHA=qAAA
=ApAGAA
AAHAffAA33A{AQA
=AffAÅA{AzAAAA  AzAQA{AAGAAřA
=A  A  AAAA¸RA
AA
A
AAǅAApA
AǮAzAzAzAǙAAGAGAŅAHA(AHAAAA\)AAAA£ARA(A
ARA  A(AAîAAîA{AQAA=qA=qA¸RAHAGAGAffAA(AAA\)A33AÅA
AAA  AzAď\Aď\AĸRAAA
=A
=AĸRAĸRAřAAģAApAHAzA£AAAÙApAA
=ApAÅA\AQAĸRAď\AŅA  AA=qA
AŅA
=AffAApAGAHAA
=A=qAAAAQAA=qAA(AA  A33A{AHAAAAHAHA\A33AHA\A33AzAHAGAARA
A
A33AApAA
=AA(ARA
=A
=AGA33A\AAAAApA{AAA(AAAA\)AzAA\AA  AAA(A
AzARAHAAA  AAA
=ApAA\)AA\)AA{AzA
=AAAQA=qAAAAApARAAGAA{AAAA\AAAAA  AffA\)ApA
AApAAffApAA33ApAAAQAAffApA
=A\A=qA  A
=ARA(ARA{AffA33A=qAAA
ARAAA33AA\ARAGAAA{AA{A33AGAAGA
A
AA33A\AA
=AARA\ApAAAA
=A{AQAGAQA(AAGAGAA=qAAQAGAA{A=qA
AffAGAAAzA\)ApA(AAAQAffARA=qAA\AA33AHAApA
AA{AAA33AzA\)AARA33A  AARAzA\)AAApAAffA=qAAzA33A
A=qARA33A\)AAffAffA=qA
=AHA\)A
A\AA  A(A  AAAzA{AA33A
AA(AAAHAApA33A
A\AA=qA=qAA
=ARAAA{ApARAA(A=qAA\)AA33AA(AAAAAA{A{AzARAAAA
=AQAAA
A\)AA{A  AzA33AA\A33A\)AA=qA
AAQA
=A(A  A
AA=qA\A=qAA\AQA=qA\A\AQA  AffA  A{AffAA¸RAzAA33AA33A{AAÙAAĸRA=qA
AAA\)AHAA
=AAA(AA{AA\)AGAA33AzAAîA\)A\A33AffAApA
=AAA\A33AAAAAA\AA
=AGA\A=qAAGAAffAAHA\)AA=qA\ApAHA  AA\AzAGAA=qAAAAAA
=A=qAAƣA33AǅAAA{A(A(A=qA=qAQA(A(A{A
AA\)AAƣAffAQAzAŅAffAQApAîAQA  A(AAģAÅA£ApAQAARA33AGAAA\)AzA=qA=qA
AA{A
ARA£AGA\ApAîAAď\AA\)AAAAQA¸RAAA¸RAGA=qAGAA33AAAAffAAzA\AÙARAHAGAAAA¸RAzApAŅA
AHA33Aď\AA=qAĸRAAAGA
AffAƸRAƏ\AffAffAzAzAƣAƏ\AŮAŮAřAŅAŅAŅA33AA\)A
A{AÅA¸RAÙA33ApA(A\)AzAAÙAGAQAA{AAAGAA  A
=A
A
AzA\AAA
=AA\)A(A£AffAzAGAA{AA  AQA33AffAA{A
=A(AA  AA\)AAAAA
ApA
AA{A£AÅAîAA=qAĸRAHAzAHAHA33AAGAGApA\)ApA33AŅAřAŮA
A
A  A=qA(AQA(AŅAAAHA
=A
=A33A\)ApA\)AQA\A33AA33Aď\AffAĸRAď\AÙApA\)AA£A
=AQA=qA33AQA\A
=AÙA  AA(A  A{A{AîAÅAÅAGA
=ApAQA
AffA£A\A
=AîA(AGA33AzAAA£AA(A
=AAA
AAGA
=A  A\AAQA\)AAGA  A\AAzAAAApA33ApA(AGAAffAffAÅAAA=qAAA=qAAAHAQAffAAA\A\AffAApA
ApA(AAzAAAARA=qA
=A(A=qAA(AQAzAAffA
=A\AzAQAAQAGA=qA\)AA\AAzAA
=AAQAA
AQAA=qAAAzAAffAAzARAzAAAffA
=A\)AGAAAA\)ApA33ApA33AQA(A33A\AA  AAApAAAA(AARAARAHARAAHAzApA33ARAA\A
AAA  AffA(A{A{A=qAARAAAAQAHAA
AAA
AAAA{A  AQA
AQAA
A  AffARA{A
ApAGAHA  AAAHAARAAzAAA  AffAzAAA{A{A\)AAA
A(AApA
AQA
=AA
=AHAA(AAzAAHAzAAA{AA\AAAA
AA(AQA  AA  AAAAAQAA\)AzAAA
=AA\)ARAA\ARAHAAA
A(AA{A=qA
AA(AAA\)AHAAffA  AA=qApA\)AAHAQAAAGAffA\AAQAGAAAA33AQAAAAQAQAA{AAQAAffAA{A  AA{ApAzAHAA\A(AQAHApA¸RA{AzA33A33A{A(AffAƣAQAHA
=AA33AGA=qAəAffA=qA(A=qAAǙAGAƸRAzA(AřAQAƣAApA=qA33AzAǮAǙA33AǙAǮAAAAAřAzAŮAQAAƣAzAģA
=A
A£Aď\AffAŅAffAřAzA  AHAHA{A
AAîAď\AA£AAAA\AA{AAAAAQAGA33AAzAAAGA\A£A=qA{AQAzAAGA\)A33AAģAď\AGAA{AƸRAƸRAƏ\AƣAffA
=AƸRApApAffA(A
=ApA\)ApAɅAəA\)A33AA33AGA
=AHAȏ\AffA=qA{A  AAǙAǮAǮApApApAAAAzAQA{AAƏ\A
=AǅAAƏ\AzAA(AřAƣA=qAzA{A33AŅAQAA{A{AĸRA
=A
A
=AAď\A33AGA
A£A¸RAffA\)AÙAA
=AzAÙA(A\)AA\)AHA  AHAA(A  A=qAzAzAAA  AAřAAAQA{AƏ\AřAřAģA(AA=qAƏ\A\)A{AA  A=qAffAAǙApA=qA\)AƣAAzAHAzAAGAƣA{AAAGAAƣAA33AƸRAAAƸRA
=ARA(AǅA\)AAQAGAAAÙAffAAffAAAQA
=A=qAQAA(A(ApA\)AAA  A\AAAQAřAzApA=qA
=AəA{A  AɮAɮAA{AffAQAffAzAʣAHAAGApApA33AA33AAʸRAA
=AHAAzAʸRAʣAAɅAəA33A\)AAřAAAA{AA=qAA
=A
=AHAA  AA\)AģAģAHAHAģAzAAÙAQAffAffAAffAQA(AApAÙAQApAAQA
=A33AAAA{AARA
=A¸RA\AffAA=qAzA¸RA33AA=qAřA  A
AQAAAƸRAǮAzA=qAȏ\A
=AɮApA
=AGA33A33AHAAAGAGA\)AɅAɅA\)AGAɮAəAzAřAAģAřAŅA(AHAAAQAffA
A33A
A{A33AApAŅAAHA(A  A{AAQA(Aď\AffAzAHAď\AîA(AÅAA33A
=A¸RA\)AAÅAÙA(AAGApAQAAAA
=AffAA{AGA=qAAffAHAÅA=qAHApA(AzAAAGAǅA\)AGAǙA\)AA
AQA=qA(AA
A
A
A
A{AǮAA{A=qAQAzAffApAƸRApA
=AA{A(A¸RA
=ApA£A(A
=AĸRAGA¸RAQAƏ\A33AGAAƸRAƣAffAAA  A33AHAA
=AAĸRAAAĸRAAď\AAď\Aď\A=qA  AQAQA=qA(AQA
AîA(AA\)AAAAAffAGA\)A
=ApARA
AHAAffAĸRA
=A\)ApA33AAA33A
=A
=AřAQAHA33ApAƸRA(AAƸRAA33A
=A33AA33AǮA{AffAȏ\A  AA  AŅApAĸRAď\ApAģA  ApA
=AARAzAA£AA\)ApAApAA33ApAGAA  A
AAQAzA{A
=A\)AĸRA=qA=qAHAA33A\)AîAQApAÙA¸RA{AzAA33AAAHA=qAQA{A  AffAHAAffA
A  AAA
A¸RAGAA\A33AÅAffA\)A{A=qA(AQAzAHA33AǮA  AǮAAAAApAGAAA\)A33AA(AAAQAAîAAApA
AĸRAîAzAffA\)A33A  A
A(AQAď\AzAzAA(AÙAA
A
A{A\)A  AGA¸RA\AQA(AA(A\AAzAffA{AA33AzAHA¸RAQA\A
AA\)AA
=A33AffAHAA\AA
A(AHA(A¸RAÙAAzAAŅAŅA(A
=AAApAřAGA
A33AGAAffAffAzAʏ\AHAA33AGApA˙A˅AˮA˙A33A33AffA=qA(A{A\)AȣAA{AHAƸRAAřApAzAQAQAƣAQAzA=qA  A
A\)A{AffAHA(A=qAAffA(AAAQAÅA33AQAÅAAAA{A
A
A(AAHA=qAHAAAffAA(AAzAAzARA
=AA(AffA¸RAGAHA=qA{A=qAzAQAffAģAAŮAAzA33AAAAƏ\AƏ\AƣAffAffAQAQA(AffAffA=qA  AŅA\)A
=AHAď\AffAAA{AÅAAÅAQA{AA\)AAîAîA
A
=AÙAA  A{A{ApA{A(AÙAÙAAîAHA(A¸RA£A¸RA33AAHAA£AHAGAAAGAffA(AAAARAQAzAzA
=AAHAAAAA{A{AAA{AzA33AA{AĸRA33AŅAŮAA{AffAƸRAQA=qAzAHAAAHAAAAA
=AAƸRAAzAƏ\A=qAQA{A(A(AřAffAQAAǙAGAA33AŅAřAřAAAA33A
=AĸRAď\AĸRAģAAģAQA=qAffAď\AffA  A{A=qAQA=qAzA{AAAffAQAzA\A¸RAAAÙA{A{A=qAQAď\A(AAĸRAHA
=A
=A33A
=A\)AřAAQA33AQA=qAffAîA
=AGAÅAAď\AA\)AřAA(AzAƏ\AƏ\AzAƸRA
=AAGAAA
=A
=A
=AA
=AAAAAAƣAAǙA
=A=qAƏ\AQA
AAHAQApA  AzA
A  A
A{AA\)AA=qAQAģA33A33AHA=qA(A{AzA=qAzAzAffA=qA  AAAÅAAGA33AGAÅApA\)AÅAAîAÙAÙA
=AAîAÙA33A(A\)AzA£AîA
AAď\Aď\AffAď\AHAA\)AAA  AA  AA
AŮAŮA(A(AQA=qAƣA
=AAAAAƸRAQA{AAŅAŮAŮAGAffAď\AĸRAzAffA(A{AÙAîA  AQAîAÅA\)AîAAAA(A£AQAzAzAAffA\AzA\AA\AAAA\AA(AAffApApAA\A=qA
AHAA
A33AAAAA
A33ARA(A(A(A(A  AAffA
A{A  AA=qAAGA\)AAGARA\A(A\AA¸RA{A=qA
A\)AAAzA
AzA  AAffAA¸RA  AAA
A\)A\)AAAA{A(A£AQA
=AzAzAAAA\)AHA
AffAAffAAQAGAGAzA
=AzAA33AAHA
AA\)AzARAAAQA\A{AAzAA\)AA
AAAAAAAA33AffA\A\)AAA\AHA\A\)AA
A\AA=qARAAA(AffA\AffA\A  A(A=qAQAzA\)AA
AzAQAAA  AARAzAQA=qAGApA  AAAQA  A
AA
=AHAAHAQAAA
A(A  A  A=qAzAApAffA(AAA{AAA\AzAApAQAAGAHA{AHAA=qA=qAA
=AA(A  AAAQAHAGAAAAGA(A=qAAQAAQApAGAApA(AAA=qA\A
=AÅA(AffAď\AģAzAGA
=AGA
=AGA\)AAAHAHAHA{AHAA33A\)AŅA\)ApAA
=A\)ApAŅAŅA\)A\)A(A\)AHA33AÅAîAÅAAGA¸RAffA
=AQAHAffA
A=qA  AA£ApAÙAGAAHAzA
=A
=AHAA=qA=qAAAApAA\AQApAAAQA=qAA
=ApAAGAQARA33AGA  AzA=qAAŅAřAģAAQAAGApAAřAAA
A  A{A  A33A33AA33A
=AzAQAAffAA=qA  AÙAÙAÙA=qA(Aď\AHA\)A33AîA  AQAAAģA
=ApA
=AĸRAHAGA=qAAzAGAAzAAzAffAÅAGAîAAA{AA\AA
=A{AA\AffAAAzAď\AîAÅA(AHAzA33A
=ApApAA=qAzA¸RAA¸RAA33AîA{AffAA33AŮA=qAQAzAHAHA  A\)AGA33A\)AA(A  AzAǅA
AAAA(AGA\)AǙAAHA33AǙAA\)A33AA=qAA=qA  AŮAA
=AAAřA\)AGAApAHAHAŮA
=A\)AAAĸRAffA(A
AzAzA33AÙA(A\)AĸRA\)Aď\AffApAGAîAGAîApA{A¸RA\AzAHAA
=AGAÅAAGA{AzA\)AAŮAǙA(AA\)AHAApAAQAʸRAAffAA\)A\)A\)AHAA\)A33AAɅAA
AA
ApAAQAA  AŮAřAQAHAA(AffAď\A  A
A{A(A  A\)AǅA
A
AǅAHAAŅAHA33A\)A33AQAQAzA(A\)AHAA
AAƸRAQAǙA  AƸRAAA=qAQAffA33AA  AŅA=qA\)A(A33AƏ\AAƣAAHAŮAAŅA
AAAřAŮA(A{A(A(A=qAffAQA(AAGAA
=AHAģAffA=qA  A
AzAffAzAAîA\)A33AÅAîAÙAÙA\)AAQAQAAAA
AA\AzAffAA
AApA{AĸRA
=AQA=qApAAffA
=ApA=qAAGAzA33AAA
AzAHAAA33AHA
AA33A33A  A=qAzAA
AHAAffA
A
AA
=AA{A{A
=A
AffA\A=qA(AGAzA  AQAHA
A\)A{AApAAzARAffApAA
=ARA\)AAffA
=AA
AAA=qAAQA\A33A33AGA\A\)AAA33AAAffA=qA\AzAA£AApAA33A£A{A\A33AGA£A{A
AApAAA\AAQAffA\A33AAffA\)AAA33AARAzAAA\)A
=AAA\A\AA\AAzAAA=qA33AAAGA
AHA
AA
A{A  AǮAAǮAA  AffAzAȏ\Aȏ\AȣAzAQA{AǮAǙApApAAffAzAƏ\A(A{A=qA
AŮAA\AAQAAHAGAGAƣAffAƣAHAƸRAGAAřAŮA\)A(AĸRAƏ\ApA
=AGAŅA\)A(AHAGAģAAzAAĸRA=qAAîAÙA\)AA¸RAHA¸RA(AQA  A
=A
=AA=qAGA¸RA33AÅA33A\)A
=A
A33AQAģApAA(A  A(A33AffA=qApAÅA  AzA=qAA\)AAŮA
AffAɅAəA33AȸRAQA{AAǙAAGApAǅAGAAAffA=qAAGAHApAGA
=AHAAƏ\A{AffAƣAƸRAAA33AGA33AGAǅA33AGAAǙAǮAǮAzAA=qA{A(A(A(ApAHAHAA
=A
=A
AAŮAřAffA\)A\)AGAApA\)A33AzA
=AAA  AÙARAÙA
A(A
=AAAHA33AffApA
AQA=qAƸRA33AA
AHAA{AGA
=AA
=AA=qAHAzAAAÅAAAA\)A  AffAQAA
=A\)AģA\AzA¸RAîAA=qAÙA=qAîAîAHAîA(A
A  A  AQA  A(AAGAA\)AÙAÙApApA=qA\)AÙAÅAA\)A(A\)A\A
AQAApA
AAAA\)A\ApAzAQA\)AA\AAzAHApA{A\A
=AQA\A{A{AA  A(A=qAffAffAAAGApApA33A
=A33AAA33AAzAffAAA{AQA=qA=qA
AAzA£A
A(AAHA
=A33A\A\)AA
AAA33AzA
=AAÙA33A=qA
=AffA\AQA=qAAA
A
AAApAA\AffAAA
=AHAAGAAAAA\AAAAzAAA33A\)AAQAGAA
A
AQA{AGA  ApAGA
=AzA\)AffA  A
=A\AAAAHAzAAAAA
AAQAAffAzA
A(AQA33AA33AÅA33AAAAGAAAHA£AAHAQAffAzAARAGA
AQAAAHAAAA=qA\)AAGAAAAAHAAGAAAA{A=qA
=AAAzAHAAzAffAGAA(AHA(A(AAAAA  ARAffAA33AAA(A\)AřAzA33AffAģAQAA
=A\)A  AffAƣAȏ\AȣA{AA
=A\A{AffA33AǙAzAƸRAAAǮAA(AA
=A\)AǮAǮA\)AƸRA
AAƸRAǮA
=A¸RA  AA\A£A\)AŅAApAzA{AApA(AGA{A=qA(AAAA\AAAzAAAA33AAAzAApAGA{A\AAAHA{AAAGA£A(AAAzA
=AřAffAǙAA(AQAGA{AƸRA=qA\)A  A(AƣA\)AǅA{A  A{A=qAffAȏ\AȸRAȣAȣAȣAzA=qAAGA
=A33AAƣAǅAA(AƸRAGApAǮAffA33A\)AǙA
=AGAŅA{AQApAǮAǙAffAȣA\)AzAȏ\A
AGAAHAď\AAQApA
=A=qA
A  AA£AA=qA{AŅA33AA=qAAAŅAGAď\AģAQAAQA{A\)AAzAzAzApAîApApA=qApAŅA  AffAHAƸRAǅAȣA33AəA33AAzA  ApAA˙AA  A(A  A=qA=qAffAAApApAA
AɮA{A\)A
=AAəAQAǙAřAAɅAAA{A(A
AzA33ApA{AɅAȏ\A33AƣA(A(AǙAA
=AŅAAģA=qA(Aȏ\AîAHA  AA=qAA
=A\)AffA  AzApA=qA
AHAA\)AƸRAHAzAzA\)A{AffAǮAA  AAȏ\AȸRA{Aʏ\A
A\)AʸRAʏ\AQAʸRA(AȀ\A  A{AAGA  A  AɮApA\)A\)A
A33A
=AQAɮAAAzAȏ\AȸRAAAȣAəAGAAzA(A
AGA
=AAAǮAAǅAƏ\AƣApA  A{A
A(ApAAHAAŮA
AA\)AŮA(A  AAŅA33AGAAAƸRAAď\AA  A
AzA  A\)AGAGAGAA
AQA33AǅAƸRAřAƸRAŮAzAǙA{A\)A
A
A=qA33A=qAʸRAHA
AApAΏ\A(AHAA\)AͮAA33A
=A̸RȀ\AffAA˙A
=A{A  A(A˙A{AQA(AzAApȀ\A˅A  AAʏ\AAȏ\ApA33A33AAQAAAřA\)AAAA  A\)A33A
=A
=A
=A33AzAzA  A{A{A
=A¸RAHA£A33A\A
AA=qApAA{A  A  AzAffAAAAîAA{A33AĸRAQAAffAîAģAAffAAA\)A
AǙAGA
=AAAGA(A(A  A{A{Aȏ\A(AQAQA{A
A
A{A  A  A\)AAƸRAƣA{AAA33A33AA
=A
=A
=AHAAřAAzA\AA£AGAQAÅAîA
AAAQAîA=qAQA=qApAîAÅAA33AAAA{A£A£A{A{AAAApAAzA
=AApA(A£AHA\)A=qA
=A\A\)A\A£AÙApA
=AHAHA\A£A\)AffA
=AAA{AA
=AAffA=qAQAQA=qAzA{A{AffA{A
AǮAǙA33A33A
=AffA(A(AîAģAAŅAzAAA
=AffAA33AHAzAAģA
AffAApAřA{AzAffAffAA(A\)A
A  A{A  AĸRA\)AÙAAGA  A£AÅA33AzA(AApA=qAAAAAA
AAAGA=qAQA(AA33AGA\AHAAHA(A  A=qAzAA\)A
AA33A33A33AŮAƏ\ApAGAGA\)AAAȣAȏ\AǙAQAGA33AGApAŮApAřAQAAAGAA33A=qA  Aď\AQAA33AģAHA=qA(AA{A
A
AGA\AA\)A\AAAAA
=AA
=AAGAA¸RAzAQA=qAzAAzA\A\)AAA\)A=qA
=AApA  A  AzARAAGA  AQAAAAAAffAAA(AHAĸRAGA  AAAffAzAƣAA33ApA
AAȣAffA(A{A(AzAffAȏ\Aȏ\Aȏ\A(AffAHAĸRA=qApAŮA{ApAŮAGAGAHAřAGA\)AzAAHAîAAď\A\)AGAģA=qAAAffAA\)AAffApAzAGA£AHA  AA(AzA
=A  A=qA
=A  A\AAAAffAAHA\)A  A
=AApAA£A33A{A33AAAGAAAAA{AAAzAHAzAAAzA¸RAHApA=qAQAApA{A
A{A
AAApAA
=AA\)AA(AAQAAAģAAģAAzAAGAAQAzAQA(AffA  A=qAAA
=AAģAÅAzAffApAffA=qApAAAA  AffA
AA\)A=qAA{AQAA
A(ARA(AQA\AA
=A  A(A\ARA
=AA33A=qAzAQA  AHAAGAGAHA(AA33A33AA  AGAAŅAAzAƏ\A
=AǮAAQAffAffAȣAȏ\AQAffA=qA(A33A{AǙAAŅA=qA(A=qAzA\)A\)A
=AǅApAGAAAHAƣA=qAřA  A{A{AQA(AƏ\A
=AǙAǮAAHApAGAffAzA(A¸RAA=qA
A
AAA{A\AAAAQAffA
=AAzAQAA=qAzAAffA
A  A
=AzA=qAA33Aď\AAAzA
AA33A=qAQA{AQAƏ\AřAGA(AģA
=A(A33A=qAģAQAHApAzAHAQApA
=Aď\AŅA33AffAzAHAHA
=A=qAĸRAAzAAŅA
AƏ\AAA=qA=qAA¸RAHAA33AAHA\)AffA  AzA{AAA{A=qAA{AHAA
AAAQAApAA\)A
=AAHAAAAA
=A\AQAAzAAA
=AAAAA\)AffAGAAAHAQA\)AAAA  A  AAGApAA33AAzAAHA
=A\A33AAAA  AAHA(AGA\)AHAAA(A\AAHA(AQAA
=AAA\)A{AGAAAAA
=AHAzAAAzA
AA(AA\)A\AAQAGAA
=A
=ARA\)A
AAAA
A
A
A  A
AA
AAQA33AAGAAAAA  A\AGA\)A  AffA(AAAAARAApA
=AAHA\)AAHAAGA(A\ApA{A=qAApAA£A{AzAAÅAApAA=qA(AAAA(A  AAQAffA=qAAA£A
=A
=A{AARApA
A\)A=qAAGAAA\)AzAAApA
=AHA¸RApA{AA
=ApAARA\A\)AA\ARAAARA\A\)AzAA\A=qA(AAffAA{AAAAAA\AAA(AHAAAARAAAA33A
=AA33AGA\)AAffAQAzAA{AAAAQAzAApAffAAQAHAGAA\AA(A\AAffApAAAA  A33AAA(AA\)AAAApAHAA33AHA  ARA\)AA=qAAGAHAAAAHAQA
AAAAA
=AA33AAA\A{A
AAAAAQA
=A
A=qAffA
=AAzA=qAffA33A=qAAA  A=qA=qAȏ\Aȏ\AAȣA=qAA
=A  AǅAǙAǅA\)AA33AƸRAAƏ\A
A  A{AHA  A(AŅAHAŮA
=AAGA(AÅA(A{A
=A=qA(AHAGA=qA
AA  A=qAQARA33A\A{ApA33AA\A\AffA
A\)AAAAAAAffApA\)A33A\)A
AAAA  A(A=qAA  AA33AGA(AAHA
A\AAApA33AQAzA  AAGAAQApAAzAARA{AffARAHAAQAAHAffA{A\AHA(ApA33AA{AAA\)ApA33AHA
AHA(A\)AAGA(AAA{AAA
A
=A\AGARA  AHARAAA  AAA(AA{AHAA  AAA=qA
AA  A\A(AffA33AQAGAA=qAHApAffA33AHAAAAAA
A\AA\)AHAffA{AA
AGAA  AAA(AzA(ARAzAA\)AAAAzAffA\A(A
=AzApAAGAApAzAAffAAAHA{AAHA
=A  AA=qA=qAQA33AzAA\AffAAA(ARAA\AAA  AAAAA{AQAQA=qA33A
A\ARAffA\)A33AffAA
=AA\A\)AARA=qA
AHA\A  AQAA
A=qA=qA{A
=ARA=qAQAAAAzAAzA  AA{AQA(AQAAffAAAQA=qA\)AGA=qAffAA
=A\)ARA  A
AGAAGAAA\A  AHA(A
AzAAQAAAQAARA33AQAQAA  AHAAAzA\)AA{AAGAA  A{AAA=qAAffAAAHAA=qAAAA
=A(A=qA  ARApA
AA  A
AAA33AAGAA\)AHA
=AAAA\)AA33ApA
AffAAQAApARAAAAAAQA\AHAHA\)AA(AffAAA\A\)A{AQAA33ApAAAA
AA
=A(A\)AzApAAA33ApAA\)A{AffAffA(A=qAAA\A\)A  AA
=AA33AAzAAARA{AAA=qAHAAA
=A
=AA=qA
ApA
=AARAGA(AAAAA{AQA(ARAffA  AffAAAHAffApA  AAAQAQAA\)A
ApAAA33ApAGA{A=qAApAHA(A{AARAAA
=A=qAGAA\)AA
AffA\)AzA\)AA  A
A  AHA33AQA33ApA(AA
=AffA(A
AApARAQAAQApA  AA\)AA{AffA(AzA\)A\)A(AffARApAGA  AzA33AApAAAffA\)AQA
AffA(AHARA
A\AAzA
=A(AGA
A=qApAHARAA{A{A=qARAAAQAApAffA{A{A
A(AAAffAAA  A  A(AApA\AzAGA{AAQAA\AAA{AA
AHA33AQAAGAQAzApA=qA
A{AAzA=qA{AA
A(A33AARA{ApAA33A\A{A\AHAHAA
A
=A\AARAA{A(AzAAAQAffAAA{AGA=qAzA(AAAAzAAzAA=qAAAAAQAAAA
=AA33A  A(AAffAAAAAAA
=A=qAAHAA{AAAA
=AAAARA\AApAA  AAApAA33AAAzA\AApAzA=qAA=qAAGAQAAGApAGApA(A33AA  A£AAAĸRAĸRAzAģA
=ApAAAGA=qAQA  AîAApA  A\)ApA(AAHAQAA  A\)A  A\)AŮAAffA£A\AA{AAffA33A£A  AHApAHA
AffA\ApARAAHA=qA  AGARAAAHAzA
=AffAzAAAGAQA(AHAAAzA
AA33AzAQAAAď\A=qAA33AA
AAAzARARARA(AAA
AGAA
A{A
=A
AA
A{A33AGA33ARAzAA  A  A{AAHAA(A\AAAAAAA=qAA\A(AHAzAzA
A(AA33A
=A{AzAAAA=qA{AHAAAAffApAAA\AAffAARAffAGA
=A(ARAHA\AQAGApAffAAQA  AA
A{ARAAAzA=qA\AA  A
=A\AAAAQAAAGA
=AGAGAA\)AA=qAAA33AHAAAARA=qAA33AHA  AA\)AA(ApA  ApAHAׅAzAffAzAzAQA(ApAGAAՅAGAGAծA  AAәA(AәAңAңA
A{AAQAA(AAApA{A33AәA
A(A
A=qA=qA(AQA{ApAӮA=qAQA33AΏ\A\)Aʏ\AAʸRAA  AA{A
AGA\)AѮAљAzA{ApAA\)AzAA(A=qAәA\)AAѮAzAAΣAAͮA
=AA=qA{A  AиRAHA33AѮAzAҸRAffA  AA33A{A(A\)AA{A
=AAՅA
=AAffA{AGAAAHAҸRAHApA
=AҸRAA
=AՅA
A֣AծAծAzA{A\)AҸRAϙA  AGAAzA
=A{AAҏ\AffAffAGAAӅAAAңAAAҏ\AGAQAAffAɅAAA=qAffAAʣȀ\AzAGAzAHAAиRA
=AHAAңAzA{AHAΏ\AAzAQAхA(ApAϙApAffAҏ\A
=A  AA
AA(A֣AzAffAHA֏\AָRAHAAA33AGAAׅA
=A33AAAAGAAׅAׅApA
=A33A֣AHAApAԏ\AGAzA=qAzA{A=qẠAHAͅA\)AͅApA
A=qAHA{A
=A
=A(AΣA\)AAAA=qAffAGAHAffA(A\)A=qA  AQAAQA33ẠA(A
AGAzA(A{AͅA
=A
=AͅAffA{AAɮA(A{ẠA
=AͮAΏ\A\)A
A
=AθRAAθRAHAA(AУAЏ\AQAA{AffAQAЏ\AЏ\A=qAЏ\AffAzA=qA{A  AЏ\AGAУAϙA  A
=AffAA  A{A
AA  A{AQẠAAQA=qAϙA{A(AAApAAиRA(AAApAΏ\AA\)AA33A(A\)AA͙A
=A33AQAȸRA(AHA
=AffAA{AȸRA˅A  AA͙AzAAȸRAzAQAʏ\A(AAAУAQA{ApAHA=qApA
=A(A\)AzA33AHA
AAffAffA\)AA\)AՅA33A33AԸRAԸRA=qAA33A33A33AՙAՅAA{AAHA=qAӅAA\)AAҸRAҸRA33AHAA=qAAHAAzA33AA{A  A
=A  AHAAʣAϙAAΏ\AQA˅AɅAHAQAQAəAˮA
ApAA˅A{AQAǙA  AȣAˮA  AffA=qAzAAǙA\)A
=AAzAzA(AȣAQAǙA\)AɅAA\)AA˅AGAGA
AΏ\A\)Ȁ\A
AAA(AΏ\AϙA33AУAAffAffAҏ\AQAHA{AAA{A=qAңA=qAңAңA
A  AGA{AA=qAҸRApAԣA
ApAѮAхApA\)A(AυAGA(A
AHA
=A=qAzApA(A\)AAA
=A{AͮA=qAzAQAA=qA
=AAУAϮAA(AffA˅AθRAAHA33AAzA  AGAΏ\AΏ\AzA33AυAGA
A
=AA\)AzA33A
AAΣA{A33AAAAAA33AGAzA(ApȀ\ApAA˅A
=A33AzA\)A\)A˅Aʏ\ApA˙AAHAGAAʏ\AGAAA\)A  AAƣApA33AAzAď\AAřAAAA(AQA(A
A=qAffA33A=qAAA
AA
=AAƣA
=A33AAAƸRAA
=AAGA\)AǙA  AȣAǙAƣAAzAQA
=AǮAA33AA\)A  AƏ\AzAA
A
AQApA  A  Aȏ\AȸRA
AzA33A33A˅AAzAAHAAAGA\)AͮA  AͮA͙AAͮAA͙AͮAzA(A  A
AA͙A(A  A
A
A(AͮA(A(AApAA=qAGAʏ\ApA=qAGA
A=qAGAGAAǮAǮAApAAffAffA\)A{A
=AAAǮAQA  A{AɮA{AA˅ApA=qAQA=qA  A{AGAA\)A=qA33AɅAffAQAƸRAAƸRAQAAɮApAɅAʸRA
AA
AQAHAAA˙A=qA
=A33A
AffAθRA33AϙA  AA\)AA\)ApAљAQA=qA=qA=qA
AAиRAHAAЏ\AA  ApA\)AAHA{A=qA=qAA  A
=AΣA
=AΣAΣAͮA  AAΣAzAAGA=qAAəA{AzAAQAɮAɮApA33ApA
AffAzA33AˮAɅAAAzAǙAzA
ẠAˮAɅA  A
=AHA˅A̸RA  AHAAAɮAQA
=AHȀ\AffA̸RAAffAHAυAЏ\AљAAAHAHA
=A  AA{A֏\A
=AׅA\)AָRA֏\AָRAffA
AA(AՅAAҏ\A
=AAӅA  A=qAљAGApA{A
AA
AA  AGAGAAAHAЏ\A{AAGA\)A{AAA
=AϙA
AθRAzAzApAA  AAQAAAzAA33AffAQAAHAzAGA̸RA  A
=AʣAAA=qAGAAϮA{AAffAͮA=qAυA  AAAAθRA
AAљAffA
=AGAHAAHAAGA33ApAӮA  AծAיA׮AzAA\)AffAHA=qA(A(A
AAңAQAҸRAHAҏ\A
AAѮA  AҸRAzAGAA\)A(AHAAAHAAӅAGA\)A\)AAAAQAA(AQAӅA(AA33AхA(AA33A33A
AәAәAәA
=AGA33A
=AAHA(AApAzAAУAA  A
AzAAffAхAAAңA\)A
=A(A
A֏\A33AAׅAffAظRA(AAمAمAHAHAAAAA=qAGAzApAԏ\AԸRAAffA\)AׅA=qA{AAAA
=A{AAAGA33AQAAGAAHAAAѮAzAAϮAApAΏ\AͮAGAͮAA=qA˅AˮAAAAʸRA=qAAGẠAHAAA33AGA(A
AθRAAȸRAˮAЏ\A(AAAAzA
=AApA
=A{AӮAԣAHAAAңAHAԏ\AԸRA\)A{A(ApAծAA
AՙA{AQAQA{AծA33AzAHA=qAzA=qAQAzA{A{AA\)A
=A
=A
=A{ApAAffA
=A{AAхA=qAGA=qAңAԸRA\)AָRAָRAծAAAGA̸RAңA
AAA=qAGA͙A33A
=AGAGA
AAA
=A33AQAHAAAɅAAˮA˅A\)A
=A33ApAHAQAAHAApAΣA{ẠAΏ\AzAA\)AAzA(A=qAʣA˙AAffApAϙAA(AzAAA
=AљA{A=qA(A=qAA  AzAA(A͙A\)A\)AzAA  A\)A=qA=qAQAffA  AљA
=AQA  AУAHAͅAHAA{AAəAffAAAˮApAAffA{AHAzAzAΏ\AΏ\A=qApAυAzA
A  AHA
=A33AAɮAʏ\AzA{A
A(AɅAGA=qAʏ\AHAHAQAͅA̸RA\)A33AУAθRAθRA(AApA(A=qA33A
AθRAυA  AA
=AGAиRA  AGAApAAGA33AA\)AGAGA\)ApAәAәAӮAәAHA
=AAAңA33AљA\)A
=AAУAиRA
AzAA(A  A{A
A\)AθRA{A=qAͮA
A
AA
AAGA=qA˅A̸RAA33ẠAA(A33ApA(AffAzAzA  AAAAAřA\)AAŅAƣAď\AHAŮAHAƣAGA(AȸRAAA{A(AˮAˮA˅ẠAApAͅA
=A{ẠAHAAQAQAθRAΏ\AAQAGAA
=AHAzA{AхAҸRAQAzAҏ\AAQA(AzA
A{A
AAGApAffAQA
AAHAͅAͅAGA
A\)AϙAΏ\A\)AHA33AQAA  AхAЏ\AAzAхAѮAffAffAAѮAAϙApAGAˮA=qApA͙AAɅAHAυA33AApA
=AQA˙AA33AApApAAȀ\A
=A  AϙAzApAAЏ\AAхA(A  A  A(AffAҸRA(A  AәAӅA
AԣAԏ\AәA=qA
AAA\)AәA{A\)A
=A(AGAAffAAљAAAffAҏ\A  A(AQAQA  A=qA33A{AAϙAAQAA(AzAθRAθRApAϙA\)AAffAffA̸RAffAzA͙AA
A  A\)A\)AͅA͙A˅AʣAAQA{AΣA{AθRAAϙAυAϙAGAϮAA
AϮA{AffAѮA{AGA=qAGAAϙA
AQAHA  ApAA  AԸRAA{AffAQAQAAGA=qAיAHAծA=qAGAHAԏ\AffAԏ\AQAԏ\AQA=qAQA
A33AӅA{Aԏ\AAGA
=AңAQAzAңAAңAңA  A=qAA{AQAzAffAffAљA\)AA
=AQA=qA  ApA{AͮAzA{A  A
A\)AzAApAAA˙A=qAA
AͅAzAffAA{A33AȣAAA
A
AffAGAzAA˙ApAGAAA
AAϮAхA=qA\)A=qA{A  A{A
A  A  A(A  A=qAQA=qA  AAӅAGAӮAӅAHAҏ\A  A{AApAУAυA
=AA\)A33AApA\)AAA
=A
=AΣA\)AϙAGAGAGAA33A33A=qA{AͅA\)ApA
=AAzAθRAΏ\ẠȀ\A̸RAHAQAQA˙AffA  AGA\)AAA{A  Aʏ\A33AȀ\AzApA͙AHAA\)AAQA=qA33AGAA(A
=AθRAхAA
A{AңA33ApA
=AA33AAӮAAAAA{AՙA33AQAՅAGAA33AA33AAљAApAApAA  AAљAљA33A33AУA
=ApAΣAAA
AA  A
A\)A  AffA˅AHA(AA=qAzA33AAʸRA  A{AϙAffAffA\)AAљAˮAȸRAȸRA  Ȁ\AApA(Aʏ\AɮAGA̸RA(AA33A  AA
=ApAA(AЏ\AиRAGA=qAHA(AHA  A  A{AҸRAAAAӮA\)AӮA(AQA=qAӮApAҸRAAָRA
AָRAԸRA{A֏\A{AffAՙA\)A(AzAхAхAAA
=AAAҸRAzAzAzAGAffA\)ApAApAυAиRA33AAQAљA  AGAHA\)AHA(ApAA{A
=A33AffA{A(AͅA˙Ȁ\ApAA˅AzAAAHAAAΏ\AGA  A
AЏ\AʸRApȀ\ApAAHAΏ\AA
A(A(A  ẠAA
AffA\)AffAЏ\AGA(A\)AѮAҏ\AAGApA(AӮAӅAA(AAGApA33AA(A  A(ApAAAzAQAAQAffAA33AϮAυAυA
=A
=AУA33A33A  A  AGAHA\)AхAA
=A\)AAиRAУAAЏ\AυAиRAAAAQAGAA̸RA{A{AͮAͮAˮAzA
ApApApAAɮAAɅA
A(ApAAffAHAʏ\AA  AHA  A{AHA˙A{A(AzẠAAͮAA=qApAApAzA33AУAЏ\AA  A{AffA=qA{A{A  A  AAΏ\AͮAAA
A͙AͅAͅA\)AAA(A
A̸RAGȀ\AGAəAA33A\)AAzA
=AˮA˅Ȁ\AzA{AAHAA
=AʸRAffA˅A=qAʏ\A  A\)AAȣAǅAA
=AAAAA  A  A  AAzAHA  AʣA  ApAGAAHAȣAffAffAffAA33A˙A
Ȁ\A
=A{AAυA{AЏ\A33ApAѮA  A{A=qA=qAQAffAffAzAңAQAffAQA=qAѮAA\)AљAAиRAиRAЏ\AffAffAffAхAA
=AQAffAAϮA
AHAУAУA\)A(A\)AυAΣAHA
A\)A\)A33A=qAHAAϙAzA33A(A(A(AЏ\AAAAHAA=qAAGAQA  A(A  AΏ\A(AzAffAffAffAQA=qAQA=qAиRAzAAA(ApA=qAA33AApAGAzAͮAͅAͮAυA33ApAzAGAңAңA(AA  AQAҏ\AApAѮAиRA\)AA{AУA{AϮAυAϙApAиRAHAЏ\AиRAHAЏ\AиRAA
A\)AQAA(A  A(AA
AzAAGẠAHAAˮA(AŮA  AAȣAȸRAAAɅA
AȣAȣAȣAAǅAǮA
A{AffA
=A33AHA\)ApAď\AAÙAď\A  AƣA=qA\)A{AHA
AQA=qApAGAzAA33AəAAffA͙A(AAУApA\)AA{A
AѮA
ApAѮA
A(AљAѮAΣAθRA{AA{A
AУAAAиRA=qAffAQA=qA\)AQA
A̸RA{Ȁ\A=qAQA˙ApA\)A˙AˮA{A=qAˮA˙AGA
=AAzA=qAQAzAȸRApAAAɅAHAAHAHAQAAŅAQApAzA=qA=qAffAAȏ\A{A\)AQAA
=AGA\AAAA33A\)AzAQA\AAGARApA\AffAHAA
AA\)AARAQAGAGAApAAHA
AAAAHAA  A\)AA\AA
=A  A\)AA{AARAAAApAffAA  A(A  AAAApAGA\)AAAffA33AAAAGAHAQA=qA
=A{A
=AHAzAzAA
=A{AAAHAAAARA(AAAAHAAAAHAzARAA\A\AAAA=qAzAA\)AAA(AAA\)ApA{ARA\AAHAA
A
A{AQA  A\)AGAQAHAAQAffARAApAAAAA{A33ARAHA\)A\)AA  ARA\)A
=A
=AQAAHA(AAARAAffA=qAA
=AzAAAAAAA{AAA\)AApAzAA=qAQAAAAAAzA33AAffAAAA  AffAAffA33AAA  AAffAA
=AHA{AAGAAHAA33AAAAAA  AAQAApAQAAARAHA(A
AARA\AAQA  A=qA  AAAffAQAAAQARA\AAA{AGAA\)A
=A\ApAA33AA\AAARAGAAGAApAA{ApA\AQA\)AAzA{AAA
AAA
=AAAQAAHA\)A{ApARA\AApAAAAA\A(AA  AAffA
AAA
=AAA
AA\)AAA  AHAAQAffAAAAApAAA{A\AA(AAQAffAAA\A  AAGAApA\AApA  AAGAAAA\A\A  AAAQA{A  A\ApAAzA\)ApA(A{AzA(A  A  A\A
A\AAA
=A=qA  A=qAA{A(A33A=qA{AA\AAzA=qAAHAA\)AAffAffARA\AAAQA  AA=qA
AHAAA
=A\)ARAA{AAAQAzAA\)AGA\AHAAAA
=ARApA(A  AAAAHA\A
AAffA(AAAAzA\AAGApA{A
=A{AGAAGAAAGA{AQAHAAzAApAAAA
=A=qAA33ARAffA{AAA  AAGAAAA
A33A\)A\)AQA(ARAffAA{ApA  A\AHAffARA{AGAA\)ApA  A=qA\A33AAGA  AApAA=qAAGA  AA  A\)AA\)AAHAA
=A\)A33AAA  A
AA33AARAA33AAzAHAAA{AAAAApA33AA
=A\A\)A=qA\A
=AQAA\)AAHAApA
=ApAzA  A33A{A
=AARAQAAA\)A=qAffA  AzAAzA\)AGA
AA=qAAA\)AAQAzA33A\AA
=A33AAA
AAAAAARA\)AA
AzAQA(A\AAARAHAffA=qA
AAzAApAAAA
=A=qAARA(AAAGA  A  A\)AAAA
=AAA{AGA{ARAA{AAAHAGA(AA
=AGAAAAA  A
A\)AAA{AA\AzA
=A  A=qARAA(AffA
=AffA{AAGAA  ApA(AA\AAGAA=qA  AAA
=ApAA=qA=qA(A33AA\AffA(A\)ApAHA{AQAzAA
=AAAA\ApAAHA\)AQARARA(A=qAAAA(AzAA
A  A33AzA
=AApAffARA(A(AA\AA{A  ARAAAAAAA  AARAAAAAHAA
=A
AzAHA\A
=AAzAAAffA(AApAHAzAApAARAA\AHAA\AAHA
=A{A  AAzA
=AApAAAA(AAffAHAzAAGAHAAGAAAA{AARA
AffAAApA=qA  AHAA\AffAAAAA33A{AA{A33AAHA\A{A(A=qAA\)AAAffAHA
=AAA(AzAAA=qA(AAA(AAAA  A
=AAAA(A=qAA=qAHAzAHA\)AGAA=qAzAAA(AffAzA\AAA  AAAHA33AQA(AAA=qAA  AHA
=ApAzAA=qA(AffAGA\ApAffAHA
A{AA  AAGAA
A  A33AA=qAHA(AzAGAAA\A{AAHAAAffA
ApA\)AffAA\ARAAQA  AffA(A(ApAzAA  A  AA33ApA
A  AA\)AffA
=ApAA\)A{AffA
AA=qAGAHAAzAAAGAAQAzAGA33AQA  A33AQAAA33ARAGAAAA  AAQA
=AA\AAQA  A
A\)AAAA
A  AQAGAAAQAHA  A
A  AGAHAAQAffAA
AAAGAQA
=AA(AzAAAA{AffA  A33AA33A=qA
=AA{AAAAAAHA  A\)A\)AAA=qAAA  AAA
=AA
=AA\)AA=qAA{A{AARA33A
=A(A\)A(AAAA(A33A33AA=qAAAzAARAGAA  A\)AffAGAAA(AzA=qA33AQAHAA\AffAAQA33A33ApA\)AffA(A33AffAAA{AHA
=A
=AA\)ApA33AGAAA{ARAA
A\A  A\AAAffA{AzAAA{A
=AA
AAA\A\)AQAAAApAAA
A{AA\A
AAQAAAA
=AAA
=AQA\)AAGAQA33AA\AA  AHAHAAA=qAARAQA  AAAA=qAHAffAAAffA(A{A{AAAA=qA  AAffAAAQAffAQA  ARA\)AGA  A\A33AGA33A  ARAA  AA
A  AApAAAffAffAAAA(ApA(AzA33AzA(AQAGAAQAA
AApARA33A33AAAAHAA\)A(A
=A
=AAGAA
AffA=qA  AffA
A(AQA(A
=AA\AAAAGAffAAGApAAAA
=AA(AHA(AAAA33A  AAAAAAffAAA(A(AAHAAffAA{AffA(A=qAHA{A{AffAA(AAzA
=AA{AffAAAA{AApAA(A(AGA
=AAHARAQApA=qA\ApA\AQAHA
=AA
=A\AQARA33A  AAffA=qARA33AAQAHAA{A\A=qAQAAAzA\AA\AAApAffA33AA\)AA(AAApA33ARAAGAAAffAQAQA33ARA\)A=qAAffAA\AA=qA33AA=qAzAzAAHAHAA=qApAGA{AAA  AA
AAAzAffAGA\)A
=A=qAAApA33AAGAAAAQAA33AAA(A\AA{A\ARAGAAAA
=A  A\AHAffAffA(A
=AA{AffAffA33AAAQAAA  A  AAAA(AAQAA=qA
=ARApA\)AA\)AAHARAARAzA
A{AAAApAAGA33A(A
AzA\AA\)AAHB=qARAffA=qB
=BB
BApBA\)AffAGAzAAHARAA\)A(B(B zAGBBRBB\B BB  BB{BB BB \A\AAA{AffAGAA
=BffAA
AA\)AABB\BpBGB\)B  B33BzBB33BzBB\)BBBQBBBBBBB\)B(A33AAQAAAAA=qA33AA
=A  AA\)AAQAApA{AAHA\AAA(A㙚A(AA
A=qAQA噚AAAzA33AffAQAAAA  AGA
A=qA=qAAQABHBB   ARAHB\)B HBABRB
BBBB B \)AAAAAAQAABB(BGBBBGBBGBGBffAA(AHAGAAA\)AQBGB
AA  AffA{AB ABffBpB\)B\ARA
A=qA{AA
=AAAA=qA(AA(AzAAAAA=qAffAAA\)A33AHA33AAABpAAzAHA
A33A
A33B AAAffAffAAzA  AA(AQAAAA\)AARAAAAzA=qA
B   B B  A
B\)BGB(BB33B\BHBzB(BBB=qAAQAA33A
=AAAA  A{B \B zA\)AAffA(A(A
=AAA陚A{AA\AA
=A=qAAAffA  ApAffA\)A
AAAAA(A
=AA\A݅ApAAAޏ\A  AHAAHA(AGA{A(A(ARAffARA=qAAA(A
AARA\A=qAAAQA\)AAAAA=qAAAGAHAHA(AA  AAffA\)A\)ApAA
=ARA
=AzAA{A(ARAAA\A\AARAAApA
AA
AB =qB B  AQAAffA(A{AARAAAffA\AARAGAA33AGA陚AQAApA33AA  A\AzAffAGAA(AA
AARAAzA(AffAzApA
=ARA33A
A=qAAA=qAA(A
=AQAHA\A  AQB B 
AA  ARAA=qAApAGA  AA\)AAAQB \B
=BBpBffB
=B(B(AA{A  A홚A
=AffAA뙚AffAAAAApAAQA\AA(AAHAGAzApA\)AA
=AA(A\A\AA\)AA=qAAAHApAffAzA(A\)AAARAA
=A
A{A  A  AQA
=AAQA(A33A\AQAAA홚ABBzBBffBpB
BBHBzBB33BGB\)BpBRB{B=qBBBB33B=qBQBBQB
B\)BzBzBBBB{BBBRB{BGBBBBB{B=qA\)A\B 33B B B ffAAB GB \B
=BffBB{BzBBBzB=qB  B33BQBBBB
=B HB B HB B  B B B AQA(A\)AffA=qAApAAffA{A  AAQAA33ARA(AAA\ApA  B \BzB
=BBBQB
=B GA
=AQAABzBB   AGAzAffAAA33A
AAzAAffAAQA{ApA{AAA
ApAA=qAB
=BBB
=B
=BB
A  AApA
AAA33AA
=AA  A  AAA  A(A
=A33A=qB BGB AAAAAA
AAAzAAAAA33AAA
AQA{A
=AffAHA\A{AAAGAffA(A\)A
=A33AQA=qA33ARAGAA
=AAHAAAAAffARA{A  A(A=qApAGAAAAA\AA  A
BHBA\)AGApB QBBpAB =qAAApAA(AAA(A{AffAffA33A(A{AzA{A
AA\)A{A홚A\A{AQA(A{AAQA  AA{AHAQAzA\)AHAA=qA
AB33B B B B \B (B=qB ffApB B (B \)B =qB {AAAAApA
B   B \B 
=B B 33B 33B   ApB 
=AAB B pB B ffBB pB QB B
=B {B B QB B GAGAAA\AQAAQA\AAzAA
=AGAA33ApAQAHAQApAAGAAA=qApA\AAA33ApA
=AAzA\)ApA{AApA
A\AGAAAA{AAA33ARAARA=qAAB GAAA{AffA\)AA\)A\)AAAQAQApAAAffAA
A  AAHAAA{AAA33AAA  AA{AGAAAB (B33BBBB{B{A\)BffB B B A  AzA33AA\)A33A
=AA(A\AzAzA\A(AQARAA{A
A  AAAApAA  A\)AffAA
=A뙚AA{AAAA  AffA{AAA(AAzAzA=qA\AzAGAQB GA(ARAApAAAA=qApA=qAffApARAARARAQAGA{A
A
A
A홚AzAAAHARAffA\A\)AA  AB33B AAAA\)A(AAAA(A33A\)AGAGA=qAAzAAGAAzAA\ApAA=qA׮AA\)A{A(A癚AAAzAAA=qA
=ApAυAɅA
=AzA(ApA(AffA홚A
AffAAAzA
=AAzAARAGAAAzAAzAARA
AQA=qAAAAAAA(A(AffA=qA=qAAzAffAA
A
AA
AA
A{ARA\)AB {B\B RB(BHB\)BB(BRB
B  BRBQBzB  B 33BB  B{B=qBBzBB=qBBBBBBB33BB=qB{BGBQB
BApABRBQBBBBGBBQB  BB B B\BQBBB {AAA33B BBQBBB\)BGB{BBBBffBBBzBQBB\BzBB \)B   B GBffBGB\)B33B(B(BB \A(A{ABAAB33AA\)AzA=qAzB
B33BBRB=qBffBzB ffAffA33A
AAAAzA\)B =qA(AAzA
=B =qB QB \)AHAAffB zBffB\A=qARAAAHAA\A  ARA(A33AQB HB=qBBB AAA(AAA
AzAA33B B RBBBQBzB
BHA
=AAAA{AB {A=qA\)AB RAGA\A  A  AQAB {B\B
BffA\)B B  AGB HBzBHAAffAAA\)AA\A
=AQAGA\)AApApBAApB (B AzB   ApAB \B HB B B B GB 
=AA33ApB {AAffA
A
=AAA\AGAHA{AzAB  BRBBB 33B B \)B \B(B B BBB
B(BffB
BBBQBB{BB\)BQBzBGB\BB(BpB\BB=qB33BzBB  BGB{BGB33B33BRBQB{BBffB  BffBBBB33AARAAAAQAAAA33AGAA\AAGAHA=qA
AA\)AffA(A\A{AAAAGAffA{AAA\)AffA{A\A
AffAQAApA\ApAffAffAffA(AAA
=A\A
=AAAGA\)ABffBAB33B   B A  B B 
=B\BffBffBB\)BBBBB=qBBB  BBpB QAB pApAAQAAAAApA
AAAGAA
=A\AA  AffAA\)AAA\A{A\AQA{AHAGAffA\)AQApAA{AHAAQAA(AHA
=AQA=qAA\A
=A(AAA{AHAA=qA
AffAAAffAA\AAAAAARAffA
AffAAAzApAzAHA33ApAA\)AAAffA\)AAAB =qAQAA
AGARA홚AffAHA
AAAAA  AffAzAffAAAAAA\)AAffAAAAHA(ApA
A\A33AA
AA(AHA  A=qA(A
=AAQAAHA\)AA(AHA(AAffAARApAAzAzA\)AA\AQA\)A\)AAApA(AAA{A\)AHA
=AA33AGA(A\A(A33AAffA(AzA\AzA
A33A\AAA=qAAAA{AGARAAAGA  A{AAAGAQAGA=qAAzAGAA33A\AAA  A{AQA=qA=qAA=qAA\AA噚ARApAٙAۙAQAHApA
=A㙚A
=AA  AGA
AхAAzAQAffAA\A(AAAHAzA33A{AffA\)AAQA=qAffA{A=qA(AA(A\ApAQA\)A33AzA
=A{AzA=qAffA{AffAAA{AHA{AGAffA
=AAAA\)AA
AGAzAGA  AAA{A\AA{AHAAAAGApA
AAAAQAA\AQAAApAAA33A\)A{A
A
=A
AffA=qA(AARAA{AAAߙA
AAApA\)A{A
=AHA
AApA\)AQAHAffA{A陚AA33A  AAA\)AAAAA
AARAGAAAAffA(AGAzAAHA(AffAA
AAApAAffAQAffAApAGAA
=A
=AffAA\AAARA  A{AA
=AAARA=qAQA\)AA  A
A\)ApA  AffAA{A\A
=A\A(A  ApAA=qAAQA33AHA(AᙚA{AAA{AAffAQAA(A
AA
A33AAAA{AAAzAzA(A
=A
=AA{A  A33AQAAAGAAffA{AzA  AHAAA\ARAAzA\AAA\AAB zB {B GB
=BzBBBB\BRAAApARAAA(A\)A33AA  A
=AA(ARAARAAAAA(A=qA\AAAHA
A
A(A\)A{AzAAAAzA33AGA33B 
B B ffB B\BBGBffB(AGB B
=BA33AQB B AB BB\B
=B\)B=qBQB(B\)BRBB=qBBBBGBzBBBBBpBQBGB
=B \)B \)AA
B (AB pA(AHA\)A
=A
A33B ffB  B B   AGA\AffA{AQA  AGAAA  AzARAffAA{AHA{AAAAGA33AffA\AAQAAAAAffAA
ARA\AAApAA
=AGA33AAA\)A{AAApA\)AA{A{AAffA
B \A{A33B GB
=B AzA  ARAffAB \)AQAzA\ABB RAHAAzA
A33B 
=ARB
=B GABQB B ApA\)ApB =qApApAA\)A\)AGARAAAA
=AAA{AAAzA
A=qAA{AA(A\)AAA\)AAAAQAAffA\A{AAA\AA
=AQA
=AAA  AAAA33AAA{AQAA  AQA
=A{AAAA(AAAA
A
AAQA  A(ARA
=AffAA
AQA\)AHApAffAA{A33B zB HBBB\B zB HB \B AGAAAHAAGA=qAzAHA\)A33A\)A33AAA{AHA{AffA(AA
=A\AAAARA\)AA\A\)AͅAҏ\A=qAA33AHAffAAAApAAAAA33A\)A33A=qA
AGA\AA\AQAzAHB =qB \B B GB AAA=qB33ApABpBHBB (AA33AzB B
=BBB=qBRB33B
B{BBB33BGBHBGB=qB(B BpB BQB=qA(AA{B {B GBGAAAA
=A
AA
=A  AffA=qApA\AA=qA  AAzApARAᙚAߙAQA\)AGA\AzA
A
AAGAAAQA33A33ApA\)ARA{AA33A
=A\A\)BffBBBB AQA  AAAB 
BBB  A
=B\AQAABB ffB{BB  AA
AAQAA
AAQAA=qA
=AAAA
=A\A  AQAAQAA
AAAzA  AHAA(AA=qApA{AAGA{AffA
A{AAA\)ARApA\A
=AAA  AApAffA(AA뙚A33A\)A噚A33ARAA  AA\)AffAGA\)A=qAHApAQA\AApAAAffA(AB pAAAA\)A=qA(A\AA(AAAAA33A=qA
A
AAA(AA33AAAApA\)A33AQAQAAA(A\AHAAA\ABB
B{B  B\BB HAGAGAAARA(AA\AHAffA\A  AAffApAAᙚA33A=qA(AA\)A{A  AffAffAzAߙA\)A{AffAA\)AffA  AA\)AzAAA
=A{AffAAApA(AA33ABB\)BRB  B 
B B =qB A  A{AAAAAHAAA\BffA
AA(A33AAA=qAAA  A  AAA뙚AABffB\)B AAApA33A\A홚A  AApAAHAA
=ApA33AQA
=A㙚AAzAGAA
ApAApA(AA֣A33AظRA=qAԏ\A{A=qAAAQAGAApA(AAA
AA=qA{A
AA
=AzAHAB pB =qBB33B33B33BGBBBzB\B
B  BB{B33BBzBB33BGBBQBzBRB
BB(BRAA{AAAA
=A\)AAQAzA(AA\)AHAHAA(AAGAffA\)A
=AA{A\)AzAAzAAGARA33AA
=A{A
=A\)A{AAA  AHApAA  A=qA(AAAApAAAAAABB\)B AGAAA33A=qB
=A=qA\)BHBB\)B \AA33B (AB B  B
B
BBQB\BB{B(BQBffBBBzB=qBBpB  BGBBRBzABRBzA(BBB\)AffB RB zB33BRBzB
B
=BB\)BGB
=B(BBB33BGA\ApA(A\)A  AAHAA\)AAffAAA\AAQAHApAAA=qAAA33AAGAHA\A33ApAAffA  AAA{AA=qApAAGARA
=B
=BRBApA
=B
BRBB \A\)B\B AA\AApAHAffAHApA{A\ApA\AA\AzA\)AzAHA=qB HBB(B ffA33A=qAAA
=AAAQA
A  A  AAA\)AA\)B ffB BffBBHB  B33B   AARARAQAffARAA\)AQAApA{A(AzAAARAApA\)AARA  AAApAAAzAAA݅AQAA=qAzAffAQAAzAAAᙚA
AQAzAffAAAAAGA
=AA
=AA{ApA  AAAAAA(AHAA33AHA\)AQA  A
=AAAQA{AAA=qAAApA  AAAAApAARAffAAQAGAAffAA(AffAA
AAAAApAAAffAA
AAʸRAA
=AÅAGA\)AƸRA(A\)A  AffAܣAڣAffA{AAffAݮA{A\)AۮAۅAA\)A\)AAA=qA=qAA
=A(AQAA=qAAffA\)ApAARAAA{AzAzAQApAܣAGAzA{A(AAAAAAQAGA33AAARARAA݅AGA(AA\)AӮAffAAA33A=qAAGAzA\)A㙚AA{AA\AHAA\A  A
=A
AffARA
=A=qAHAffAAA؏\A  AzAA
A\)AA
=AzA
=AHAffA33AzAA
=AffA33AQAAQAAA(AB AzA\AAA33AHAARAA\)AffAA
A33A
AAAA=qARAAA\)AQA\)AQB 33ARAffAAAA\)A  A뙚A\AA\)ApA  A33ARA33A(AzAA=qA
AGA
A癚AAAAQAA(A
=A\)A\)AGApAzA{A
=A\)AHAHA(AAA
=A
=AAAA33AQA=qAHAA
AA33A  AAA{A33AB 
A
=AApAAApApA{ApA(AAA=qAzAQAA
A(AAAzAHA\)AAAQA
A
=A  AAzAA{AAAQAAffAA
AA\A=qA(AHA{AffAA\A  A
=AHA(A\B \BB\)BQBB33BpB  BffBBRBGB(BGB\B
=B
BBBpBB
=B {A\A  BHBpB AGAAGAAAAAAAA
AAA\)AAzAffAB\BBBBBzBGBBB33B  B
BzB\)B B BQBHBHBpB(B(B=qBQBffAABB=qAHA
ApAAA\)AAzAGB AA
=A
=AB ffB (B ffB B{B(BB\BGBAffB\BffB  BGBzB
B{B=qB33B=qB33BQBAGA=qA  AARA
AARA  AHB AzAAffAGA
=A
=A
AQAAAHAffAGAAApAB
=AAzA(B
=AAQA\)A\)AHAA33ARBffAA(AGA
=AQAHBBGBffB=qBzB(B  B=qA
B
=B\BRB(B pB ffB\BGBBBBBffBBpBB\BffB\)BBBGBHB\)B\BpBzBRBB
B  ABHBB(B\ABBBBRBB{AARAHA
=A
B  B ffARBHB
=BQAzAffA
=A
A=qAAA
=A33ARA  AAffBRB {AB B GB BBBRB\AAA  A=qA
A(AAA\AB zA=qBB{AQBBABA  AARAAA
=AAA{AAAffA
=A33AB
=A
B\)B\)B\AAAAzB(A
A癚A癚A  A\A
=A\A\A  AA{AAzAAB AffAAAHA{A(A33A=qA
=AffAGAGAA33AA  A
=AAHAAAA\A\)AAA{A=qA(ARApAARAQA\AAApA
AA\AQAB A
ARA(BBQBRBBBBB33BBQB  B\)B  B
BpB\B
=BQB\BB 
A\AzA
AAApA\AHARA33A  A  A
A{A33ApAGA
=AA(AQAzAQAܸRA\)A
A
AA33ApApA=qARAA  AA33ARAAGAzA{AffAAAAAAA\)AAffA(ARAA
A\AAAA\)AA33A  ABA\A\AAAffAffAAAzA33AB AAffA\AGA  AApA\)AAGApAA=qBAzAA{AA홚A
=AQAAAAQAQAA33A  A33AAAHA(ApA{AAA  AAA{AAAAARAzAA뙚ARA뙚AAAzAzA(AARAA\)AA
=AA
A{A\A
=AAzAAA
=AAHAGA33AQAHARAAAAAA\ARAA
=A{AffA
=AQApBRB =qBBBApARAAQAA(AARA33AGA\)AGA(A  AAApAA33AGAzApAA33A  A33AffAAA{AGA
A
=AB 
=A{AAzA\)AApA{AA\)AHARAAA=qA\)AAAA(AQA  A
AffARAGAGAA(A=qA  AAGAAAB RAAAzA=qAA
AAA  B
BpAQA33AAAQAABRB ffB HB\BpB  AAApA
A(A
=AAA  AA
=A=qA=qA
=ApA홚AffAAAAA
AQAQA  ApA(AAzA33AApA
A\A
AA{AAffAQAAA{A{AA\A
A  AGAAA
=A  A  A
=AApAQAA陚AAAA=qA홚A\AffAA33AAHA=qAA
=A{A
=A=qA\A(A뙚AA陚ApARA
=ApA
=A=qApAHA=qAAAAA
=A=qA{AB GAA
=AAAA{AzA  AAAAAAzAHAAA(A\AAGA
AA
=ARAzAAAAA\)A  AAARApAۮA33AAGA(A
AGAAAGApAGAA
=AAGAHAA(AGA(AffA
=AzAAGA
AffA
A(AA  AAzAffAAAffA(AA{A\)A뙚AA
=AffAQAQAA
=A
AzAAGA{AA
=AAA(AzAA
=A{AQA\AA
AffA\)AAA\A{AA{A  B 
=B ffB zB (B B\)BBRB
BBB  B
BBBBBAA\)AQA
AHAAAAAAGAܸRA\)AڣA
AAݙA=qA(A(AzA{AAAAGAAA\A  A=qA\)A
AffAAAffAA33AzAApA(A
=A{AQAA(AAApAA=qAAzA33ApA
=AB (ARAzAA\AAzA
=A
=AAffAzA33AAHAffAHAB   BBB\)BBBB=qBGB=qB33AGBB{B
=B
=BBBBBAHAzAAffAzA33A  A(AڣA
=AA\)AHARAffARAAAAAGAGAA
AAAzA\A
AAzAA(ApA陚A
A\A(AzA=qAHAA
=ARAA(ARA33ABQB33B(A  AAGAA33A=qA33A(AffA
AHAAAA33B B B{B
B
=B=qBzBpBHBBB(BQBffBBB
BBB
BQBpBffBzB\BRBRBGAzAA\A  A\A噚AޣAHAQAffA\)AHAߙAܸRAݮAA  A=qAARA=qApAAA\)A33ApA=qA{AA\AA\AA33A\A
=A33AA
A\AAQAHA\)AffA
=AffA
=A=qB BAAAA(A  A33A㙚AzAAAApAA=qA\)AB {BffB\BB=qBQB pB QB33B
=BBBBffAAAAApAAAAB (B zB B {AARAAzAߙAAzAAAܣA=qAѮAAA  AHAffA33AA(A
=AQA\A  AAᙚA\)A(AffA33AA{AA=qAffA\A33AA
AGAA33A33A=qAAzA  AA  A(A(BffBGBffAGB (AA33A
A{AGA\AA=qA(A\)AA
=ARAHAHAA\)ApAAA  AB pBB{BGBpBB{BzBB{B GBGBffBBGB\)BB
=A{AGARAHAGAA(AA\A
=AGA  AApA噚A(A=qAHAAAHA{AAAAA
A{A
AB\)A
A{AAA
=AzAAA\AAAAGA  A(A
=AA=qA{ABBRBB\)AffA=qA\)A33AAApAApAApAAffAA  A\AA33AAA
=A33A=qB\)BBGAGAAffA33AApA  AA
=AA
A
AffA
=AA  AGA߅AAᙚARA33AHA
A(AffA{A
=AAAQAAA\)AHAߙAᙚAA  A\A\)AAffAAGAڸRA=qAQAGAQAAAzA
AAAAHA
AAAAzApAzAB (B QA33A{AAAGAAAA  ApApAA\)AAzA  A
=AHAA33A(AGA\AGAzAffAGAAAA\AA
=A
=A\)AAffARAB AAA
AA{AQAA  AAAۅAAA
ApA
AՙAAAHAٙAڏ\AA{A؏\AمAffAzAzA33A
=A޸RApAޣA  A\A߮A{AHA
=AzA
AQA=qAGAA33A\AffARAA\)ApA\AzA\AAzA\)AQAQAGAAAzAHAGA=qAA=qAAAHAARAGA
A{AAAA\AB QB RA  AAAAB 
A  AAAAzA
=AB\)AGAAzBAAQA(ApA\)AA  A  AA{AAA(ApA\AA
=A
AGAAA
=AffApA
=A
A  A
ABQA  AGA{BA  AQAApAApApA{AA\)BAQA
B
=B33BQBGBQB
=BB  B{BBAHABA
ApA  AAffA
=A33AAzAA33ApAA{A{A
=ApApA홚AAA뙚AAQAffAAAGB{BQB\)BzAAA\A\)A  AzAA=qAHA(A33ApAffApAAޏ\A\)A33ApAARAA33A(AAAzAHA{A33A33ApAGA\)AAA33A33AHAAA(ARA\)AHA{A
=AGAAB RB{A\)BBB(B  BzBBzB\BQA\AARAA
=A(A  A(A
=ApA\)A  A홚AAGAQA噚AQAAffA
=AA33AA\AA  A(A{A(AA  AzA=qApAHAHAzA{AAAffA
=A  A=qA=qA33A߅ARAffAۅAA\)AAA
AzAAA33A(A陚A\AA
AffA33A\)A
=AA噚ARAApAAQAAAQA\)AAAA{AAAffA\A
=A
=A\)A=qA=qA{A
=AApAA
=AA
A\AAA
AGAA33A  AffA(AffA(AA
AǅAݮAHAAffA
=AA
ApA\)AA(AHARA  A(A  AAQAAAA
=AمA{AA\)AHAHARA  A33AApAAAQAңA޸RAGAAAffA{AAA33A  A{AŮAƸRA(AffAzAAAQAzA{AAAA
A{A\)AGA{A
AzAAAzAGA
AzAA\AHAمARAΣA  AA  AffA  AffAHAAHA
=AffAՅA؏\AffAGAApAzAffA؏\ApA  A  A˅A
AffApAGA
A33AARA
=A\)A
AGAAA
=AAAzA  AHAԸRAӮApAA33AGAAGAՅAzAffAQAܸRA܏\A(AAffAAAӮAzA
AffAGAHA\A{AAAA(A
AGA߅A\)AAA\)AffA{AzARApAHAAffAzA33A{ApAffA\)A(AzARARAAGAޣA{A33AAԣAffA(AAA=qA\)A݅Aޏ\A
A{A  AA
AHAA
=AᙚA
A
A㙚AAffA33AߙA
=AGAGAzAAA
=ARAAQA(AQA
=AffAzA(AHA
A\A  A  AAA\)AA(AQA(AHAA\AzA\AHAGA\A
AApAQAQAffA  A֏\AzA
ApA(A=qA
=A  AԸRAQAGA33AGARAAAA{AHAzARAGAA33A
=AA(A  A(A
=AԣAGA=qA
AәA=qA33AzA33AApAAҏ\A{AHAffA\AAHAzA  AQAQAzA33AAAHAܸRAۅA  AzAA
A
=A\)AffA33AAAAGAݮA{AAQAA\)A=qA݅AffA  AA  A{A=qAߙApARAAAffAAApAݮAA֏\AA{AAQAHAQAHAQAA(AHAA(AAA{ApAQAAQApA33AApAffA
AAAA
=A(AA=qA{AA\A(ApAAA\AA
AAӮA
=AAϮAA33AAиRA(AAԏ\A
=AzAѮAGAиRA\)AAApA(A֣ApAzA(A(A(A\)A  AzAA  AffAمAHAA{A  A33A\)AӅA(AģA  AϙAиRA֣AAϙAAHAЏ\A=qA33AA{AffA=qA{AzA
=AA
A
ApA\)A\AGA{AzAHAAGA
AA噚A=qAAڏ\A33A=qAQA=qA=qA  AGA癚AGA
ApApA
=AAA뙚A=qAAARA\)A33A
=AծAAA
AHAQA  AθRAĸRA
A
=A=qAA{A=qA=qAAHApAGAffA33A\)AGAGAffA{AAɮAHA˅AȣAΏ\A(ApAAGAQAAAzAHAzAGAzAՅApAAGA陚AHAQA=qA
=ARAAA
=A  A  AAGA\)A33AAAAARAAApA
=A
A\)AA=qAϮAQAA{A\)A㙚A㙚AARA\A(AGAHAߙAGAQAAAA33A{ẠAAA33A\)AƸRApAʸRAA˅Ȁ\AzA\)AAAA׮AиRȀ\AHA
=Aҏ\ApA33AzA߮A
AA(A\)AAAA{AAAӮAA33Ȁ\A
=A\)A
AzA
=AHAAAffA\)AA{AAffApAޏ\AۙAGA\)A
AٙA
=A
=A{AAAӅA33AffAծA
AA  AzA
AHA  ApAGAffAzAڸRApAQAݙAϙA
=AٮAGAApApAHA=qAQAˮAẠA
A33AָRA\)AGA{A  A݅AAAffAffA(A33A
AHA{AffAAݮAHAޣAApA܏\AGA
=AAۮAڣAAffAA  AݮAGAffAzA
A{AzA{ARA=qAA
=ARAAA\)A
=AQAAAA  AA\)AGAApAQA{ApA  A\A
=AAApAA\AA\AAA  AHAA\)A(AGARA  AffAA33AAzARARAAGA=qA߮AAApAAޏ\ApAHAffApAGA33AAzAAGA߅AA  AܣAAAffAAQA(ApA=qAA޸RAAAAAffAAA\A  AAGAAffApA\)ApAzAAApA(AA\)A{A{A  A\AA33AzAzAA=qAffA33AAӅA33AمAQAAA33AGA
=AAA
=A
A\)AAzA\)A{ApA(A=qAA33A=qAGA\AHA\AA33AݮA(AA{A
AA
=AffAGAAHAׅAיAHAGAQAݮAAA߮A\)A33AHA=qA\A{AHAܸRAAAQAۅAQA  AٮA=qAffAA{A(AHAأAffAHA\)AA
AA\AHA{AA33A(A=qAAARAzA\AA(A
AARAA\AffA
=AAApApARAAQA=qAAzA؏\A33AAHA=qAAffA{A
=AHAA
=A=qAQA
A  A\)AAHAApAAApAA\AzA
=A
=ApA֣AGAQA(AzAGAA  ẠA\)AAA{AAʣA\)AӅA(AGAθRAͅAϙA  AA{AθRA  AAͅA{AffAAۮA
ApA
AAՙAffA\)AԣAffA=qAQAGA{AzAAAAAAffA33AA
=AΏ\AffA͙AԸRA=qA\)AGAυAHAA
=A֏\A
=AHAA33AӅAAApA  AҸRAzApA(AzA{AȣAʏ\ARAARA{AHAApA
A\)AA
ApAŅAARA\A{AA
A{AՙApApA¸RA=qA33AAGAÙAA\AHA
=AAHAzA
AǅAA\)A=qA\)AHA(AQAffAУAffAAA=qAأA̸RAˮAAͮA\)AffAffA
AAHAÅApAA=qAzA\)A\)A{AzA  A£AA=qAAAAAzAAA£AŮAAԣAHA׮AAAAHAAGAzA33ApARAəA
=A{AA
A  A{AAA33AAA\)AApAAA
=A\AQAAzAGARAA
=AA{A
A{A
=AGAAQA\AA
AApApAAzAA\)A{AA  AAAƏ\AA\A
=A{AȸRAAffA=qA\)A(A33AQAAAzAAA=qAA\)AAQA(A£A=qAÅAAAƏ\AAQAARA=qA
=AGA=qAȣA
=A33AA33AffARAřAAzAQAA33AAÙAQAQA=qA=qAHAGAzAA£A
A=qAzA
=AˮAffAŮAAA{AAΏ\AΏ\ApAA33AHApAǅȀ\A{A{AƏ\AǙAGAGAQA=qA=qAAAQAͮAȸRAAA33AA(AͮA33AAA(AA  AAȏ\AAzAA{A
AApAAAˮAQA{AGA
AGAGAQAAAAQAA(AffAAAΏ\A33A{A33AAGA
=AîAAAʏ\A
AffAffA\)A{AA\A33A  A
AAɮAHAיA=qAffAָRAGAHA(AřA\)A(AA(AŅAAGAAǙAAffAřA33AGAQAzAffA=qAA(A\)A\)AHAAܸRAҸRAAA
=AffAHAzApA{AAAA
=A=qAAA{A33A=qAAͅAͅA\)AϮAθRA  A=qARA(AffA˅AffA̸RA=qA=qAAǮAAÅAA\)A£AzAAȏ\A  AQAظRA\)ApAAA{AffAA=qAGAԣAԣA\)AGA{AԣAA߅AAAA֏\A
A
=A{A
=Aԏ\ApAQAAAȣAAGAAHA
=ApA\)A{A33AٮA33AA噚A=qAA(AHAAzAHA33AA홚AAQA  A
AQAۅApA33AA\A
=A{AffA
=A=qAAAAAHA{AۮAQA=qAҸRApAA
AA؏\A=qApA(AAAHAAQA=qA  AA  A\)AGA(AAHA(AȣAA
=AAA=qAٙAzA33A33A
=ARAA
=AA(AzAܣA
A{A(Aԏ\A(AApAׅAݙAAAAᙚA=qA
AA(AA(A߅AzARAQA{AzA  AA{A  A\)A
=AQAQA=qA\)AQApAAQA
AQA  AA\)AzAQA
A
A  AAAffARAAffAffA33ApA  A{A
=AApAA=qAAA
=A=qA(AAzA{AA=qAAA֣A33A{AۅA{AAAAzA
=A(AA(AHA(A33A(AzAA(AAA
A噚A
=AA=qA
=ApA֣AAHAAAܸRA֣A33AQAA(A  A\)AffA{A\A\A33AۮAApAAΣAApA֣A33AA{A޸RAffA\AᙚAzA\)A  A
=AHA  AGA\)AHAQAAQA
ẠA\)AAܣAA  A\)A
A{A\AGARA  AHA߮A33A
=AApAffAϙAAApAzAA  AA㙚A33A؏\AA(A
AA\)AQA(A\)AQAۮA=qAAՙA
A\)AۙA
A(AzA33ApAA\A
ARA
AA{ApAAA׮A(AA\A
A  A܏\AffA
AиRAޣAڏ\AGAظRAAffAAffA  A(A͙AGAAɮA\)A
=AظRA  A{AӅAApA  AzAzA
AApA33AAA܏\A  AffA  A(AQAGAffAƣA33A  A
A33AϮAAA\)A33A֏\AיA
AGAAȸRA\)AAHA
AָRA33AffApApAGA(AأAGAGA=qAA\)A33A(A=qAGARA{AA癚AA33ARAAAApAffA\)A{AAA
AHAA
AAAHAQARAHAHAAHAA\ARA=qARA\)ApAzAHA
=A
=AA(AApAAA
=A
A33AA\)AřA
AzAA
=AffAQA\AA33A{A\A{A33AAA{A
AzAzAA
A33A
A\A{A(AAffA33AѮA
AzA=qAA33AΣAzA\A=qAA  AHA\)A
=A\)ApA
A(ApApA\AA(A  A  AffA33A\)AAAٮAzAzA\AQA\AQAQAٮAGA33Aڏ\AHAѮA{AϮA
AAGA
ARAzAޣAzAޣAۅAAՅAQAAAAʸRA\)AQA\A
AθRApAQA\)AHA=qAǙAGAHA=qA=qAиRA
A\)A
=A(A  AA\)A\)A
A
=AA{AAzApAzApAʸRAAأAAҏ\AzAAffApA\AApA
=AAA\A
=A  A33A=qARARAA=qAQA(A{A{A݅AHAA  ApA
A  AAۙA(AAGA  A  AGApAۙA=qAAڣAAݮAAᙚApA㙚A(A\A33AمAzA(A=qA\A{AzA
=A33A  AA  ApAAۮAGAA=qAAٮAУAzAHAָRA\)AHAA=qAAzA{AϙA{AHAQA=qAA
=AzAzAɅA33AffAffA  A\)AծA(AŮA\AAA\)ApA޸RA=qA߮AA
=AA\AffAA\)AAᙚA
AzAңAAA33A=qA=qA{AٙAAQAA{A=qAAɮAAÅA=qAîA\)A  A\)A(AGA
=AAGAGA֣AٮAأA\)AA33AHAApAffA
=A
A(AAAHA\A
AQAȣA\)AffA33AGA33AAzA
=A{A
=AGA{A֏\AQA
AffAAAȏ\A
=AƸRA
=AA=qApAAffA33AffAď\AzAŮA\)AzAA\)A\AA\)A(AݙA(A\)AAApApA=qAAzAՅAQA{AAHA˅AQA  ApA
=AA߮A{Aڏ\ApA\)AAď\AffAA(AAAzA
=AA(A{A
=AffA=qAHAA{A\AA(AHA
=AӅAхA(A
=AHA{A(A{AffAA=qAAAɅA(A
=AA
=A
=AAzAQA  AQA
=A33AĸRApAȏ\AzAɅAzA(A=qAQAQA(A
=AAHA
=A{AGA\)AA\)Aԏ\AA  AzApAGAӅAҏ\AAQA
AAAA33AA  AȸRA
=A
AʸRAʣAAHAɅAA
=A
AQAffAAzAzAAGAAGAA=qA
=AAGA{AHAAAGAA33A33AARApA{ApA(A33ApARA\AApA=qA\AAAQAA=qAAQARA
=AA33A  A\)AAAA{AAARA{AAAHAHAA
=ApA˙AA
=AQAͅA  AQAA=qApAAˮAHAŅAAAA=qAQA{A  A
Aʏ\AɅA  AAAQAAřA{AřAzA33AȸRAǙAAAA
=AɅAAɮAȸRAQA33AA(ApAzA
AAHAGAQAAAzAffA33AARAQAəAAAAͮAď\AAzARAAA\)A(AAffA33AGApApA33AAAzA=qA\AzAHAAǅA(A£AAAAffAɅA
AA
=AAGApAQA  AA\A=qA33AA¸RAQAQA\)AAAGAA=qAApAHA=qAQAA͙AǅAAzA\)AAzAffARA33A
=ApAAAA\)A¸RA  AA(AA
AGA\AzApAApAAAAŮAzApA33A
A(A33A33A(A
AAffAA\AAAAA=qAA{AAffAzAzA\AQA
ARAA  AʸRAǅAAӅAAԸRAAffA{AAԸRAAffAARAA\AARA=qAAA\)AAffApA{A=qAA
A{AGAffA  A
=AAAA=qAzA(AGA\A(ARAQA\)AQAzAQAzAA
AA(AAA(AA=qAAA33AzAGA{A33AQAARAGAAA\AQA33AGAAAAA
ARAA=qAAA(A\)AAA{AA\)ApAAzAA
AA=qAA  AGAHApA
A{A=qA  AA=qAAA{AffAAAAA33ApA\)A{AA
AwA{AjffA]pAz{AzffApzAapA[\)AuGAmAaAN\A[\)AH  A>RAFRA^=qADA;\)Ac
=A<  A<(A9ADQAqAl  ApAiA~=qA|(AA
AHAA
=AffAA\)AAAAA33A(AArRAxAA
A|AmpAaAA{33AtzAo
=AsA\)At  AA(A
=AqGApAyAAzHA33AHA  A\AAA{A  AHA
AGAHAHA=qAA  A{AGAGAHA{
=AApAQAuGAt(A\AGAffAwARA}A33AXA_AhQArffA~{A|Ag\)A33Ak
AvHAAk
=A\A33Ap  Av{AfffAc
AgAp  A{
AzHAqpAk33Ao33AHAyAzAAA  AA\)A(A33AHAAApAAAAAQA
=AAffApA\AAA
A{ApA\AAAAAffA33A\)A(A
AAQA33AAffA=qA=qAAHA\A33A(ARA\)AAHA  A(ARAffAAAA
=AzA\A=qA(A\)AA\)AzA(A=qApAA33AAA33AGA\A(AAApA(A(AAGA\)AApAffAAAQAApA=qA\)A
A
A(AAGA\AGA  A
=AHAGARAzA  AGAA
A\AHAA\)AA\A33A{AA=qA
A  AQATAMGAMA5A1A(QA1pA*HA2RA2\AIA7A?
=A6ffAG
AO
AXALAMAG\)AG33AG33AHzAD  ACAEAAA1A'
A
AA33ApA=qAAAA(A&ffA#
=A,A)A%A'
A)A#A&HA$  AffAffA$(A zA((A7
A8ADAN{AMATQAUpA[AmGA\  AhA_
=ATzAW33AYpAfHAn\Ap  AqGAs\)A{AzHAwA  AAlQAyGAo
=Aj=qAdQA_
ATzA]AQANRALAG
AK
APAO
AV=qAd  A|AuAnHAtQAA}AqAAQAA{AzA\AyA
=ApA~ffApA{AGAA(A
A33AnHAf=qA_AeAo
AmpAffAHAzAA\A\)A\)AAuA=qAbffAzA  Az\A{AAAffAz{An\AcA`Ac
=ApzApAd  A\)A
=A}A
Ar=qA^HA]AdQA^RAAAA\)AAAAAHAA
AAffA{A\)A33A\AApA{AffAHAAAffAz=qAAqpAxA}GAzHAAGA
=AA(AA
=A
=AHA(A
AAAGA
=AAA  AAA  A
A(A  A\A  AAAffAA
AA33AAAHAQA
A{A  AAAQAGA\AAA\)ARA\A
=AGAAHAffAHARAAHA
=AAGAAQA
A33AGAHA=qA
=ApAGAA{A{ApAA33A(ApA  A=qAHAHAA=qAA\AQAAAAAGA(ApA{A\)A{AA33AHAzAAAAQA
=A  A{AQAA{AffA  AApAA33AAHApA
AQAQAAARAAA33AA=qAAA(AHAAA=qA
=AģA=qAARAAA=qAA(AAA  AzAzAHA  AGA33AzA(A\A
A{AAA{A  A(AA
=AAۅA{AAߙAAA\)A(A\)A  AQAQAHAA\)AffA{AAAAAA=qAzAQA
AHA\)AẠA  AApAυA  AHAHAʏ\A͙AA(AǙAŅApAAHAˮAQȀ\AQAхA(A{Aڏ\AΣAA(AA
AzAApA\)AA33ARAffAHAA33A  AGAAAzA33AAA\A
AAGAA=qAAAAAffA
=A{A\)A\)A=qARAAAzA
=ApA\)AGA33AݙAA  ApA{A(AzAGAApAA\AAGB\A{AQABHA(AAHA\)A
=A=qA{AQA\AAGA  A33AݮAGA߮AAffAA
A{A{AAAHA(A33AAHAA㙚A
AA
=A=qAQA
=AA=qA(AzA  ApB
=B
A
AB QAAB\)BBB\)B 
A{A{AA\A33A
AA{AAHA
A33AzA  AAzA(AGAA  AAAB \)AAffA33AظRAۙA(A{A(A{A
=AAzA
A(AA(AzA=qA
=AA(AAA\A\AffA
=A㙚AA
AAzAQAAAA{AHAAHA\AQApA
AzA=qA{AAӮAAA33AA
=AGA\)AA=qAzA\A{AA߮Aޏ\A
AܸRAQAA
A뙚AARAAGAAA=qAAA=qA33AARA뙚AAAGAAAGAA
BAGAAB pA  AA
AܸRA\)AzA͙A  AHA{AA=qA߮A\)A(A\ARAAAAA\A\ApBBB HA(A\)AA{A
=ApAHA(AHAAAA{AA  AAAA\)AHAAHA(AQA  AҸRAA{A
A33AمAυAAzAͮAffAHA=qAzAAυAAHAzAQAٙA\)A
=A
=AGAAAffAAARAHAARAA33A=qAB GB 33BA33AAAAQB RB33B 33BAAAA\)AQA(ApAHAffA33AffA\A\)AAAAARAB B\)BB BQBA
BBRB
=A  AAAAAA\A  AA\AAA
A(AAHAAA  A{A\)ApAQA\)A
=AA
=AGA=qA
=AA\AHAAAA{ABpBBAAGBBffAAA
=AA(AA\)AffA{BB
=B
BBHB QAQAB\ApAAHAGARA=qB (AA\)A
=A(A
=A  AB BBBRBffBBBBzB\BA
=ABzA
=A\)A癚AAHAQA
AGAA(AQAGA=qAAAGAGAAAAARA  AAQAAApAApAGAA\)AzA
=AA\A  A
=AzAA
ApA  A=qAHA  A
AAQA(A{AGAA
=AA33AA(B33AAA33AAA\)AzAA  AAA  A33AzARA
=AߙARAA
=AzAzA\A=qApAAAAzAAA
AGA=qA{AffAHA33AB
=AA\)ApA
=A33ApA홚A  A\)AA
=A33A{A噚AAffAAQAzA(A֣A
AAzAAAͅA͙AAΏ\AHAϙA33AAApAQAA
=A33AAәA؏\AAAݮAHA(A\AQA
AAΣAAAAffA=qAAA㙚AAGARAAՙAGAzAA=qAzA=qAA
AAA
=AzAᙚAAGA\AA(A(AzAAQAAffAڣA(AAffAApA  AGAAA33AA
=AAHA=qAׅAAAffA(A݅A(A\)AAGAGAzA  A\)AAAHAAQAA\A  AQB RA噚AAGAB B
=BBBzBHB\)AzAAB 33AHAAzAGAffBzBBBQBGB\)B33B33BB\ARAAA
BBzAA33B A  B
=B(A33A  AAA
=A\)A(AHA\)BB\)BGBzB(BBAAQA\)ApAA33AB{B
=BB=qB A陚AAA
AQAA{AAffAA(A\)AAHA  AHA  ARAHA\)AzA\AB  ARA  AAAAGAHARA=qA
AQA\)A{A\)ARAQAA(AA33AAHAAA\)AAHAA33A\)AA  AAA\AffA33A
AAHAffA
A\)AAA  ApA  ApAAA{AffAA
AAffAA
A(AHA(AAAAHAzAQA
A{AA33AffA{AA
=AQAA홚AA홚AHAA(A(A{AAzA33AA(A=qApA=qApA{A
=A홚A\AAAAzA33A=qApAffAzAGAܣAAAQAߙAAA{A33AHA\)AAAAGA
=A\)A{A\AAffA=qAA\A
ARA  AA{A  A  A\A  A33AQA\A{A
=AA\A\A
AA(AQAAAffAzA\A
=AA
=AQAQAQAQAApAޏ\A{A݅A
ApA݅A{AHAA{ARAGApA{AGAffAHAA\)A33AffA  AGApAGA
AAA=qAARA\)AA
=AA=qAffAzA{A=qAGARApAA\)AAAARAffAffAzA33AA
=AQAAA\A{AAAHARAAA  A\)A33A=qAAffARA\)A\A  AzAAAAGAzAARApA=qAAA  AA=qAffA
AzAA
=A\AA=qA\A=qAARA(A  AzAGAzAA
=A=qA
A{A홚A\A
A
=AAARAzAA
=AQAffAAA
=AAApAΏ\AGAAA
=AA
AAARA33AB (B zA33A
A{AA  AAGA
=A\AAA
AzAGAA
AAzAԸRAᙚAAA
A(A\)A(AffAGAHAzA홚AGAApAzAHAARA
=AzAA\)ARA\)A=qAA\)AڸRAAAAAQA=qA
AAAAAAAA
AffAA  A߅A33AA
=A(A\AAA  AA=qA\A=qAAAAAHAAB ffB{A{A(AB B
=BBB
=BB{A
AA
=AA
=A(A
=ARAA  AzA33AA\AffA  AGAAA\AAzB
A\)ARBBQB\A\)AHAA  AHA\)A\)AAAGA  AA
A  AAzAffAffAffAGA(AAzA
=AA{AffA
=A홚A=qAzAA\A  A{A\)B BGB  BBffB (BpAA\)A=qAA{ApA33A(AffA噚ApAHARAffA\)B RBBBBHB=qB ffAA\)AAzAB 
=AAQA(AA
=A\A\)AAA33A{AAffAzAAzA(A\A33A
ApAQA33AAAGAABA(AA33AAApBpB=qBQBB{BRAB RAGAffAAAAA33A{A\)AQA\)AA
A
=AHAAᙚAAA(AzARAGApAA
A  A  AA(ApA33AzAAAGAA33AA{AA{A=qA\BzB 33B(BffBRAAAARAzA=qARAA=qA  ApA\)AAffAA\AAB AQAGA{AA=qAffAA=qAzA癚A  AAA\)AHAAzApAA=qAGAffA\)A
AAAAffA=qAA
=A\)AAzAAAA
=A  A{AAAAAQAA\)A  AzAAAAA(AHAAA(AAAA
A
=A
AAffAAB  A
=B (AA
A  A33ARAGB \)BzB
=B(BBzBHBBHBBBRB  BBBBBB 
B RA
AQAA
A(ARApA  ApA(AAA  A(ARA{A\)ApApAAAApAA=qAA
=AAA\)A=qAzApA
=AHAffA\AARAAA
AffAApAAA\AAffAAGAA33A\)AffApA\AffAA\)AffAzAA\)A\AAAGAQA=qAAAAAARA33A\AمAAzA(AQAA  AAAzAzA{A
=AARA33AAHA{AARA  AGAzAٙA噚A
=AAA33A(AAA\)A
AۮAffA
AAGA
=AA\AzAߙAzAQAأAAәAAQAAݮAA
AffA\AGA  A
=AAݮAׅAՅA
=AAۮApA=qA؏\A
=AAGA(AA=qAA\AzA\)AϮAÅAAУA{AAܣAA噚A޸RAffA޸RApAHAAAA\)A\)B=qB B=qB
=BB33B 
AzAAzA
=AffA\)AGA33AA\A(AAA\)AAffAA
A\)AAffAffAB {A\)A  A33AA(AHAQAffA(AQAAGAA\)A
A(A  AffA{AAzAffAA癚AAA33AGARA\)AzA\AAA
ARAA{AzAA=qA33A(A
=AAGAAA
=AA
AA\)A=qA33A\AA
=AA(AA(A(ApAffAA  A(AAAAAGAAAGAQA
AARA  AٮAA
=A
AffAA33A\)AAAzAffAGAA\AA
A=qAٮAQARAAAA=qAͅA
=AffAHAAQApAA
A(AQAAAAHAҏ\AHAAzAAGAAzA  Aԏ\AAԣA{AffAѮA
AA33AݮA=qA\)AA\)A=qAAAARAzAGA=qARAAA=qAA홚AA  A
AARAffA(A33AAHA33A\)AAAGA
=A
=A33ApA
=A\)AA\AAGAHA=qAA{AA{A=qA陚AAHA߅A
=AAәAיAA\)AA  A33A33A33Aҏ\AHAA=qAAУA33AиRA\)AA
AzAffAѮA
=ApA뙚AAA33AAAGAGAۅAңAAAϙA
AԸRAυA̸RA(AAHA=qAԣA
A{AHA  AأAQAAffA
AۮA  Aޏ\AQA(AAAA{ARAQA\)ApA{A
A  AffAAAQAݮA(AݙA޸RAAHA\)A33A
A\)A
AAAٮAffAڏ\AzA  AQAAA\)AA\)A
=AхAA\)AHA(AAffAffA=qAǅAQA=qAȣAHA\)AzApAǙA=qA
ApAHAAAAģAzAA
A
A\)A  A
=AzA  AAAڸRAۙApA\)AffAzAۙA=qAA\)ApAAAzA݅AQAGA
AA\)A33AQA
AffA(A\)AAGA؏\A=qAޣA  AA  AffAGA=qAA=qAڏ\AυAQAΏ\A33A֏\AAzA
A33AHAA=qAʏ\AAʏ\AzA
=A
AGAA{AzAAϮAәA֏\A
AQAA֣A(AzA
AQAиRAA̸RAУAAzAיA{AAӮA\)A
AAәAGA=qAAڸRAAޣA{A޸RAffAGA  AA=qA\)AAffAGA  A33ApAᙚA
=AffApA33A=qAޏ\AAQAHA
=A=qAAffAظRA(AffAAAGA
AָRAۅA(A\)AQAHA
AzAٙAޣAA(A
=AA{AQA(AA
=AA  AAӅAУAGA33AHAͅAAиRAHAҸRApA͙A=qA
=ApAȏ\Aȏ\AA  AQAAʣA{ApAƸRA{A̸RA=qAȣAQA{AQAGA
AA
=AA33A(AAGAGA
=AHA(AAzAϮAAәAAA=qA  A(AԣAHAHAAѮAΏ\Ȁ\AAȏ\AHA  ApA  AẠAǅA(Aʏ\AA
=A=qA33A=qA̸RA  A̸RAQA
A˙AzAAQA\)AAA{AA\)AîAQAffAď\AAAA¸RA
AAGA
=A=qA£AAGA
AAď\AApAGA33A˙ApAffAffA33AAď\A{AAGA̸RA  AffA(AA33AffA=qA33A33A{AA(AAAAAȏ\AîAGAΣAGAA{A
=A(AAŅAQA=qAAA{A(AQAffA
A(AzAGA33AAŅAA=qAffAȸRAẠẠAȸRAȸRA33AffAAApA=qAAHAGA\)AzA{AAQAzA=qA{A
AAA33AA(A(AA\)ApA\)AzA\AA{AApAAAzA{AApA\)AzAzAAA=qApA
=AAAHAGAzA{A
A33A=qA
A(AAA\AAģAĸRA=qAŅAQAAffAQA
=AHA\AA
=AA\AAA=qApA{AffAAQAzAQA
=A\AzApA=qAzA\AîAAʸRAA=qA
AAffAυAQA
=ApA33A
AQA
=A  ApAA\)A=qAQAA\AA=qA\AA{AAAAARAA
=AAA=qA\)AA
=ApA33AAAAHARA\AffA(AAAAzA\A  A\)AAAAApA\)A\)AA  AffAGAGA=qAA  AQA
AffAAHAffA  AAAA\)AAA\A
A
=AAA{AAA(A{A{ARAA=qA
AzAA\AQApAAQAA
A33AQA\AAAAQA{A
=ARAA
=AA  A{ARAAARA
=AA(AQAAAGA=qAA\A\)A  A33AffAAApAAA\A  AQAARApA\ARA=qA\)A(AAAAAAAHAAAA
=ApAGApAAApAGAHARAHAHAAAffAA  AAA33A\)A
=AAA\ARAĸRAzAAApA=qAAA=qA
A
A(A{AϮA
A\A{AGAAffA  BB ffB{BzBApA(B33B\)BRAAAHAAAHB33AAA
AAAAٙA{AQAAřA\AffA  Aޏ\A33AAݙBB B AAAAHA
AA{A\AQAA
=BAAGBQBQB  AAffBffAARAGAHAA  A\)AA׮AA
=ApAHA\A
AݮAԸRAȀ\A(AՅA\)AzARAA\)AθRAϮAHAffAǙA(AA\)A33A{AɅA
AAA(AAA=qA=qAAAΣA{AϮAffAffB A\AA
ApAAAQAA  A܏\A  AQAڏ\AܣAۅARA݅AљA\)A=qA  A(A
=A  AAAA
AͅA=qAՙAڏ\AۮA\)AHAAffA\)AA{A(A
A\)A  AAߙA{A=qAϙAAHAAQAGApAAAGA
ApApAݙApA{A{A
=AA33A
A\)A{AA  AffA\)Ȁ\AAٮA
=A(AQAAAAAA\)A
=AA33AۅAѮA33AHAGA(A
A{AAGA(AGA=qA=qAAGAzAAffAAQAAA33A
AڣAQAA(AA
=AAAA
=A߮A
=AAQA
A
A{AAAGAHAHAՅAٙAzAأA
A=qAGAQA=qAA33A=qA=qAffA(ApA\)A{A  AQAҏ\AAGA(A33A{ARAffAA  A33A{AǅAzAʣAA\)A33A=qAzA\)AGA
AAB=qAGAAQAHAA\)AHA
=AzAAAHARAARAAA  AzAޣAffAGA  A(AAAAٙApApAzA
=AͅAAAffAAHAO33AffAzAzAAtAoAzA(A\AffAAAAA
=A  A  A\)ARAzAzAA
=A33A\)AAz{AoATAX  ALzA[33A^ffAfHAw
=A\)A\)AA{ApA]GA%A333A=AHQAAGA9ARA,A	A5pA%@H@@ff@\@HAffARA{AAA(zA;A>HA5A/
=A4(A733A-pA&{AHAA (A(A$A2=qA5AAGAGA=A6{AApA,A-A0  A#ApAQA
AA
ffAH@H@\)@{@Q@{@A{@A AffAA  AA'33A/A,A,A8  A?33AEAHAmpAS\)AXAuGA=qA{AAzA33A{A\(AtzAA33ARA33AAAAHA|  AXzAxAXQA33ApA~HAAffA{A\)A(AAA\A\A1AmAHAQA33A{AjHA_AnHAGAHAAAAAHAQAAA=qAQAAffA
=ARAAAAA
AAAAAzA
A33Ar{AAAGARApAAAA  A(AAAHA(A\AHA\)ARARA\A\A{ARA\AnffAffAiA{
Ao
Aj\AhQAcAmA~ffAAHAYAqAmAMGAIAF\AFRAF=qA2ffA<(AMpAD(A733A2{A*{A%A\A%AA{AA
HA"\AmGAYAYA@AN=qAZ=qAbHA4AAAA2RAApA6{A/33A4QAHzA;
A:=qAG
AJ{A9A9AB\ADQA/
=AIADzA=A'A\A$zA
A#\)A*ffA*=qA2=qA=A8QA;
A<QA6ffA,  A.{A-A7A (AA((A,zA  Az@G@
@ff@G@@@{@p@  @ۅ@H@@AA33A33A
=ARAGA
A!GA.=qA<zA9A8  AF\A@A)A@@z@
=@pA z@ff@@A
R@
@z@@  @@H@@@\)AGAA/
A9AIAD  AjffAYAiGAiGAAsAqpAjffAjHAfHAeGAgA]A]AW33AX  AJRAVffAP(AW33AUAiGAzRAHAA~{At  AA]A?
AC\)AX  ASAupAV\Ac
A>RA,(AffAA&{A:HArHAO33AFffA\QA<QAAA\@ffA1A&HA(QA)pA0QA&\A&=qA.\A*\A/A.{A0(A4A"RA%A$QA0  A7A5A;A9A7AHApQAUpAR\Al(AG\)AxQALAJffAlzAp  AQA\)AXAeAbHAhAo
AXAhQAoAuAmGAd(Ap  A]AQpAK33AZHAdAZRA_\)AaAhAp(A}AQAAzAlA`  Al(An{A~\AGAHAzAQAAzAAAA\)AA33AQAx(ARAnRAQA(ApAAAffA(ApA
AzA
=AffAzA(AApAAzApAAAffAA33A
AA
=AHAAQA(ARA\)A(AA  A(AzA(AQAffAA\A(A33AARApApAAA  AzA
=ARA{AAAAAAA=qAA$zA:{AGA#
=A5AO33AN{AH  AEAAADARRA`Ak33AdQApAupA]GAP(Ad(AhzAyGAYGA^\AW
=AIALAQA^\ATAhAFRAS
Af=qA
=Ak33A{33AAtApAASAkAzAAffA\)AuGAwALAFRALQA[
=Av{AHAypA\QAXARHA`(A2{AIAN=qAepAp(A=qAk
ARAuAPQAeAhQA(ARApA\)AzAffAĸRAA33A(A{A  A33AHA\AzAA  AAA(AA\)AA(AAA\AApAAzAAAA
=A(AAAQAARA33AAAAAHA=qAARAAAA33AHAAAA\AA(A{ARAAAQARAɅAAHAAQAٙAʏ\ARA33AA\)A}AA
A\A=qAAAA
=A\)AAAAffApAGA\)A{AQA=qA{A
AAffApAzAAA(A\)AffAzAzA\A(A\)AA  A£A=qA\)AA33AۮAA(AA
=AHAzAffAARApA\)AAGA(A=qA=qApARAQAAA=qAAAÙA33AQA=qAzA33AzA33A33AAGAAAAHAƣApAffAAHAՙAٮAGAAAGA=qA33A=qAAARAA{A{AQApAARA(AQAA  A  A
=A  A{A
=A
A
=AԣA  A{A
=AffA\)A(A\AAəAAQAA  A\)AAARAޣA
=A
=AAA=qA\AQAARAQA\AffAARAAAzAAARAA  A陚A  AۙAAffAޏ\AЏ\AffAA33AAA\)AzAAA\AA
AϮA
A
AAAzA=qAˮAA33AGAffA˙A˙ApA{AA
AϙA˅AHA{A
=A
AA
=AA33A{AffA33A  ARAAAA=qAAzAA  A33B B zAAA\)AAA{AA\AAffA
AGA
AܸRA  A̸RAffAzA܏\AffAיAA=qA
=AA33ARA
=A{A\AARA33A=qA
A
AAAHAߙAAffAffAQA=qAffAARAA
A33A{Aڏ\AA
=AzA
AAzAAGA(AAzA(ApAɅAA(AQA=qAzA(A֣AA
AA
AA{A\AA33AAA
=AÅA{AA{A33A33A  A{A(AA\)AAA33A
=AA
AAQAAHAHAGAGAA{ApA=qA
ApA  AQA  AAGA=qARAQAAA33AzAAzAAApA
=AA=qA\)A(AHApA
=AffAA=qA߮AָRAәApAAAGAǅA
AӅA
=A  AӮAQA
=AAAՅAffA(AA33AQA£AÙAffAAəAHA(AAAzAA=qAA㙚AAA
=A뙚ApAffARA{BRBpBBHB=qBAA{AAApARA\)AA33A=qA(A
=A\)A(A߅AݙAHA
=AffApA㙚AAGAGAGBB33B(A{A
=B {AffA{AQA܏\AA
ApA=qA33AGA33A
A33A=qA{AHA\AA33AHA  AAAAAA33AGAffAظRAGA{A{AH>>>>>?   >?   ?   ?   ?   ?   >>>>>?   ?   ?   ?   >>>?   >>>>>>>>>?   >?   >>>>>?   >>>>>>>>>?   >>?   ?   ?   ?   ?   ?   ?   ?   >?   ?   ?   ?   ?   ?   ?   ?   ?   >L>L>L>>>>>>>>>>>>L>L>L>L>L>L>L>L>>>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>>>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L===>L>L=>L>L>L>L>L=>L>L>L>L>L>L>L>L>L>L>>L>L>L>L>L>>L>L>L>L>L>L>>>>>>>>>>>>>>>L>L>>>L>>>>>L>>>>>>>>>>?   ?   >>?   ?   ?   ?   >>>>?   ?   ?   ?   ?   ?   ?   ?   >?   ?   ?   ?   ?   ?   >?   ?   >?   ?   ?   ?   >?   >?   ?   >?   ?   ?   ?   ?   >?   ?   ?   >?   ?   ?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   >>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   >>>?   >?   >>>>?   >>>>>>>>>>>>>>>>>>>>?   >>>>>>>?   >>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   >?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   >?   >?   ?   ?   ?   ?   >>>>>>>>>?   ?   ?   ?   ?   >>>>>>>>>>>>>>>>>>>>>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   >?   ?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>L>>>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>L>L>L>>>L>>>>>>>L>L>>L>L>L>L>L>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   >?   ?   >>>>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   >>>?   >>>>>?   >>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   ?   >>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   >>?   >?   ?   >>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   >>?   >?   ?   >?   ?   ?   ?   ?   >>>>>>>>>>>?   >?   ?   ?   ?   ?   >>>>>?   ?   ?   ?   >>>?   >>>>>>>>>?   >?   >>>>>?   >>>>>>>>>?   >>?   ?   ?   >>>>>>>>>>>>>>>>==>>?   ?   >L>L>L====>L>L>L>L>>>L>L>>>>>>>>>>L>=>>>?   ?   >>>>>?   =>>>L=>>>L>?   ?   >>>L=>>?   >>>>    ?   >L?   >L>L>>L    =>L>L>>>    =>L    ==    =>    ==>    >L>=        >>L>>>L>L=    >=>>>=    >L>    >L=    =>>>>L>>>>>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>L>L>L>L>L>L>L>L>L>L>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>L>L>>L>L>L>L>L>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   >?   ?   >>>>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   >>>?   >>>>>?   >>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   ?   >>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   >>?   >?   ?   >>>?   >>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   >>?   >?   ?   >?   ?   ?   ?   ?   >>>>>>>>>>>?   >?   ?   ?   ?   ?   >>>>>?   ?   ?   ?   >>>?   >>>>>>>>>?   >?   >>>>>?   >>>>>>>>>?   >>?   ?   ?   >>>>>>>>>>>>>>>>==>>?   ?   >L>L>L====>L>L>L>L>>>L>L>>>>>>>>>>L>=>>>?   ?   >>>>>?   =>>>L=>>>L>?   ?   >>>L=>>?   >>>>    ?   >L?   >L>L>>L    =>L>L>>>    =>L    ==    =>    ==>    >L>=        >>L>>>L>L=    >=>>>=    >L>    >L=    =>>>>L>>>>>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>L>L>L>L>L>L>L>L>L>L>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   ?   ?   ?   ??333?333?333??????   ?   ?   ?   >>>?   ?   ?   ?   ?????   >?   >>>>>?   >?   >>>?   ?   >>>>>>>?   >>>>>>>>>>?   ?   ?   ?   ?   ?   ?   ?   >>>?   >>>>?   >>?   ?   ?>>>>>>>>>>>>?   >>>>>>>>>>>>>>>>>>>>>>L>>>>L>>L>>L>>>L>>>>>>>>>>>>>>?   >>?   >?   >>>>>>>>>>>>>>>L>L>L>>>>L>>L>>L>L>>L>L>>L>L>L>L>L>L>>L>>>L>L>>L>L>L>>L>L>L>L>L>L>L>L>L>>L>>L>L>L>L>L>>>>L>L>L@fff>L>>>L>L>>>L>L>>L>>>>L>L>L>L>L>L>L>L>L>>>?   >=>L?   >L>?   ?   ?   >>>>L>>L>L=>L=>L>L=>L>L>L>L>L>L>L>L>L=>L>L>L>L>L>L=>L>L>L>L>L>L=>L>L>L>L>L>L>L=>L>>>L>L>>>L>L>L>L>L?   >L>L>L>L>L>>L>>L>=>>L>L=>L>>L>L>L>L>>L>L>L>L>>L>L>L>L>>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L==>L=>L>L>L>L>L=>L>L===>L>=====>L==>L=========>L=======>L=>L=>L>L===>L=>L=>L>L>L>L>L=>L=>L>L=>L===>L>L>L=>L>L>L>L==>L=>L=======>L==============    ============>L>L>L=====>L=======>L=    =    =        =>L    ============>L>>L>L>L>L>L>L>L>L===    ======>L>>?L?   >>>>L>L>L>L>L>L>>L>L>L>>L>L>L>>L>>>>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L>L=>L>L>L>L>L>L>L>L>L>L>L>L==>L>L==?ff====>L=>L>L>L>>>>>>>>>L>L>>L>L>L>L>L>L>>L>L>L>>L>>L>L>L>L>L>L>L>L>>L>>>>L>L>L>>>>>L>>>L>>>>>L>L===>L=>L>L>L>L>L>L>L>>L>L>>>>L>>L>L>L>L>L>L>L>L>L>L>L>L>L>L>>>L>>>>>>>>L>>L>>L>>L>L>>L>L>L>>L>L>L=>>L>L>>L>>>>L>L>L>L>>L>L>L>L>L>L>L>L>L>L>L>L>L>>L>>L>L>L>L>L>>>L>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>?   ?   ?   >>>>>>?333?   ?   >>?   ?   >?   ?   >>>>>>>>>>>>>?   ?   ?   ?   ??   ??L??   ?   ?????   ?   ?   >>>>?   >>>?   ?   ?   ??333?   ?   ?   ?   >?   ?   >?   ?   ?   ?   ?   ?   ?333?  ?fff??@   ?ff?ff@@Fff@@ٙ@AA33@@33@ff@ə@  @@@33@  @33@@  @L@ff@33@33@ff@@33@@`  @fff@S33@   @ff@@Fff@l@@&ff@Fff@33@9@333@Fff@Fff@Fff@L@S33@Fff@Fff@@  @9@9@L@L@Fff@9@S33@&ff@ff@33?ff?ff?33@ff??  ?ff?ff@ff?33?ff?  ?ff?33?ff?ff?ff?ٙ?ff?  ?  ?33?  ?33?ٙ?ff?  ???ٙ?  ?  ?ff?33????ff???????33?ff?33?33?  ?  ?33?ff?ff???  ?fff?  ?  ??ff?????ff??33?33?ff?  ?fff?333?L?fff?L?fff?L?333?333?333?333?333?L?333??????????   ??333??333??333?333?L?L?L?fff?L?L?333?333?L?333?333?L?L?  ?L?L?333?  ?L??L?fff?333?333???333?333??   ?333?333?L???fff?333?333?333?333?L?L?fff?L?fff?fff?  ?fff?L?fff?L?L?333?L?333?333?333?333?333?333?L?LA??  ??L?333?333?333?333?????333?333??ff?333???333??????L?333?L??333?333?333?333?333?333?L??333?333?333???????L?????   ?????????   ??333??L???333?333?L?333?333?333?L??333?333?333?333?333?????fff??L?333??333???@33?   ??   ?   ?  @33??L????333??333?   ??333?fff?   ?   ?333?   ?   ?   >?   ?   ?   ?   ?   ???   ??   ??333??333?333?333??333?   ???   ?   ?   ??   ????333??????   ???   ?   ?   ?333?   ??   ?   ?   ?   ????   ??333???333?333???????L?333?333?333?333?????333?????333?????   ?   ?   ?   ?333?   ?   ?   ?   ?   ??   ?   >?   ?   >?   >?   ?   ?   ?   ?   ?   >>?   >?   >?   ?   ?   ?   ??   ?333???????   ?   ?   ?   ??   ?   ??   ???????333?   ??   ?????333?333?L??333?333?333?333?333??333????   ???   ?333??   @ff?   ??   ?   ?   ?   ?   ?   ?   ?   ?   ??   @ٙ?   ?   ?   ?   ???   ?   ?   ?   ?   ??   ?   ?   ?   ?   ?   ?   ?   ??   ?   ?   ??   ?   ?333?   ?   ?????333????333???????   ???   ?????333??   ???????L??????333??   ???????????   ??????   ????333????L?L?fff?L?333??333??333???333????333???????333?L??333????333?333?333?333?333?333?333?333?333?333?333??333?333?333?333?333?333?L?333?333?????333?????333?333?333?333?L?L?333???333??333?333?333??333?333???333?L?333?333?333?333?L?333?333?333?333?333?  ?333?333?L?333?333?L?L?333??L?333?333?333?333?333?333?L?333?L?L??L?333?333?L?L?L?L?L?L?  ?fff?333?333?333?333?333?333?333?333?333?333?333?333?L?L?L?L?L??L?L?333?333?333?333?fff?333?333?333?333?L?L?333?L?fff?fff?L?  ?L?333?333?333?333?L?fff?fff?  ?fff?fff?L?L?333?fff?fff?333?L?333?333??333?333?333?333?333?333?333?333?333?333?333?333?333?333?333?333?333?333?333?333??????333?333???333?333?????????333?fff?333?333??333?????333?333?333?333?333?333?L??333???333?333?L?333?333?L?333?333?L??333???333??????333??????   ????333?????????????333??   ?   ?   ??333??????333?L?333?fff?L?L?333?L?333??333????333???333?333?333?333??fff??333????333?333?333?333?333???fff?333?333?333?333????   ?   ?333??????L???L?333?333?333?L?333?   ??   ?   ?   ?   ?   ????   ?   ?   ?   ?333??   ?????   ?   ?   ??   ?   ??   ?   ???   ??   ????????333???333?333?L?L???   ?   ?   ??   ?   ?   ?   ?   ?   >?   ?   ?   >?   ??   >>?   ?   ?>>>?   >>?   ?333>?   ?   ?   ?   ?   ?>>?   ?   ?   ???   ?>?   >??333?   ???333?333???   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ???   ??   ???333??333?333?333?L???333?333?333?333?333???333??L??L??333?L??333?333?fff???333?   ?   ??   ????   ?   ?   ?   ?fff??   ?   ?   ??????   ??333???fff?333?333?L?333?L???333????L?fff?fff?  ?  ?  ?  ?  ?L?fff?  ?  ?fff?L?333???333??333?333?L?333?L?L?L?L?L?333?fff?fff?333?fff?fff?L?fff?L?L?L?L?fff?fff?L?L?L?L?L?L?333?333?333?333?L?333?333??L?L?333?333?333?333????????   ??   ?   ?   ?333?333?333?333?L?L?333??fff?  ?  ?fff??  ?  ?33???333?  ?L??L?ff?  ?  ???  ?L?L??333?333?L?fff?L?333?L?L?L?333?333?333??333??333?L?L?333?333?333?333?333?L?fff?L?ff?L?fff?L?fff?  ?fff?L?L?L?L?fff?fff?L?L?L?fff?fff?L?L?L?L?fff?333?L?333?333??333??L??333???   ???333????   ?333?333?????333?333?L?L?fff?fff?fff?L?L?fff?????  ?fff?fff?fff?L?L?????????????   ???333??333???333?333?333?333?333?333?333?333?333?L?L?L?fff?fff?fff?fff?fff?fff?L?fff?L?333?333?333?333?????333??????333?   ???333??????????????   ????333??333?333?333?L?L?L?  ?333?L?L?  ?333?L?333????   ????   ?   ?333?   ?   ?   ?   ?   ???333?333?fff?L?fff??fff????  ?L?L?333?L?L?L?L??333?333?   ?333??333?   ?333?   ?333????   ?   ?   ?   ??   ?>?   ?   ?   >?   >?   ?   ?   >?   ?333??   ????fff?  ?L?333???>?   >>>>?   ?   ?   ?   ?   ?   ?   ??   ???333?  ?  ??ff???  ?fff????  ?  ?fff?L?  ?  ?333?L?333?  ????  ?L?333?L?????333?fff?L?fff?fff?fff?  ??  ??fff?ff?L?fff?  ?  ??ff?  ?  ??ff???????@   ?L?333?333?L?333?333?L??   ?333?????333?L?L?fff?ff?  ?ff?ff?ff?  ????ff?33?ff???  ?ff?  ?  ?fff?  ??L?333?L?  ?  ?????????fff?fff?L?L?L?fff?L?333?L?333?333?L?fff?L?333??333?L?L?L?L?333?L??333?333?333?333?L?L?333?333??ff?fff??   ????333?fff?   ?   ?   ?   ???   ??   ?   ?   ?   ??   ?   ?   ?   ?L??333?333??  ?L?333??333?333???333?   ?333????   ???   ????L?333?333?333?333??????   ?  ?   ?   ?   ??   >>?   ?   ?   >>?   >>?   ?   ?   >?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   ?   >?   ?   ?   ?   ?   >>>>>>>>>>>?   >>>>??   >>>>>>>>?333>>?   ?   ?   ?   ?   ?   ??   ?   ?   ?>>>>>>>>L>>>>>>>L>L>>>>L>>>L>>L>L>>>>?   >>>>>>>>>>>>>>>>>>>L>L>L>L>L=>L>L>L>L>L>L>L>L>>L>L>L>L>L>L=>L>L>L>L>>L>L>L=>L>L>L=>L>L>L>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>L>>L>L>>>>L>L>>L>L>L>>L>L>L>L>L>>L>>L>>>>>>>L>L>L>>>L>>>L>L>L>>>L>L>>L>>>>?333>>>>>>>>>>L>>>>>>>>>>>>>>?   >?   >>>>>>?   >>>>>>>>>>>>>>>>>>>L>>>>>>>L>>L>L>L>L>L>L>>>>L>>L>L>L>>L>L>?   >>>>>>>>>>>>>>L>>>L>>L>L>>>>L>>>L>L>L>>>?   >>??   >?   >>>?   >>>L>L>L>>>>L>>>>>>>>L>>?333?333??>>>?   ?L??   ??333?fff?fff??L?L?L?   ?   >??   ?   ?   ?333?   >?   ?>>>?>???L?fff?333?fff?fff?L??  ?fff?ff?333?333??   ?   >?   >>>?   >>>?   >?   ?333?   ?   ????333?fff?L?L?333?333?   >?   ?L?L?   ?   ??   >>>L>L?   ?   ??   ?   ?   ?   ?   ?   >?   ?333??   >?   >>L?   ?333?   ??>>>>>>>>>>>>L>>?   >>>>>>>L>>L>?   >>>L>L>L>L>L>L>>?   >>>>>>>>>>>>>L>L>>>>>>>>>>?   ?   >?   >?   >>?   >>>>>>>>>>L>>>>>>L>L>>?>>>>>>>>>>L>L>L>>>L>L>L?   >>>>>>>>>>>>>>>>>>L>L>>L>L>L>L>L>L>L>L>L>L>>L>>L>>L>>>L>L>>>>>>>>>>?   >>>>>>>>L>>>>L>>>L>>>L?>>L>L>L>L>L>L>L>>?>L>>L>>L>>L>>L>L>L>>>>>>>>>>>>L>L>L>>>L>>>>>>>>>>>>>>>>>>L>>>>>>>>>L>L>>>L>>L>>>>>>L>L>>>>>>>?   >>>>>>>>>>>L>>>>>>>>>>>>>>>>>>>>>>>?   >>>?>>>>>?   >>>?   >>>>?   ???   ?   ?   ???L?333???   ?   ?   ?   ?   ?   ?333?   ?   ?????333?333?333??333?L?333?333?333?fff?fff?  ?  ??ff?fff?fff?fff?L?fff?fff?fff?  ??fff?fff?L?fff?L?fff??L?  ?  ?fff?fff?  ???  ?????ff?  ?  ??L?L?333?L?L?L?333?L???L?333?333?L?333?333?333?333?333?333?333?fff?fff??L?fff?L?fff?L??fff?L?333?fff?fff?fff?fff?fff?fff?fff?fff?fff?  ??  ????  ?fff?  ?fff???  ?fff?fff?fff?L?L?fff?  ?fff?fff?  ?  ????  ?fff?fff?fff?  ?  ?  ?L?fff?L?fff?L?fff?333?fff?L?L??L?  ?fff?L?333?fff?L?L?fff?L?fff?fff?fff?  ?L?L?fff?L?fff??fff?fff?fff?L?fff?  ?fff?fff?  ?  ?  ???  ?  ??  ?fff?fff?L?fff?L?L?fff?fff?L?fff?L?L?fff?fff?L?  ??fff?fff?fff?L?fff?fff?ff?  ?fff?ff?  ?  ???33??  ?ff?33?ff?????????ff??????ff???ff?ff??ff???33?ff?33??ff??33?  ?33?ff?33??  ?  ?ٙ?ٙ?ff?ff?ٙ?ٙ?ff?33?33?33?ff?  ?  ????ff?  ???33?33?33??ff?ff@ff?  ?ff?????  ?  ?????  ?  ??  ???  ?   ??  ?  ?  ??????33???33???33?  ?33?33?  ?  ??  ?33?ff?33?ff??33?ff?33?33?ff?33@   ???  ?ff?33??33?33?  ?  ?@33?ff?33??ff?ff?  ?  ?33??33@   ?33?33???  ?ٙ?ٙ?  ??33?  ?ff?  ?ff?33?ff?  ??ff??????ff??  ?????  ??ff????  ?  ???ff?ff????33?ff?ff?ff?  ?ff?33?  ?ff??  ??  ?33??  ?ff?33?ff?  ?33?33?ff?ff?ff??33?ff?ff?ff?ff??ff?  ?  ?  ?  ??  ?ff?ff?ff?ٙ?  ?  ?33?  ?ff?ff?  ?ff?33?ff?33?ff???ff?ff?ff??ff?33??ٙ?  ?  ?  ?  ??33?  ?  ?  ?33?ff??33?ٙ?  ?33?33?ٙ?ٙ??ff?ff?ff?33?33?33?ff?33?ff?ff?33?ff?ff?ff?  ?  ?  ?33?ٙ?ff?ff?ff?ff?33?ٙ??ff?33?33??  ?  ?  ?  ?33?33??  ?33?ff???33?ff??ff????ff????ff?33?33@   @,?ٙ??ff?ٙ?ff?33?ff??ff??33@@s33@Fff@   @@  @l@Fff?@@?ff?33?  ?ٙ?ff?ff?33?ff??ff?ٙ?ff?ff?ٙ?ff?33?ff@   ?33?33?  ?  ?  ?  ?  ?33?  ?  ?  ?ff?ff?ٙ?ٙ?ٙ?ff?ٙ?ٙ?ٙ?ff??ff?ff?ff@   ?33?ff?33?ٙ???ff?ff?ff?33?33?33?  ?ٙ?ٙ?ff?  ?????  ?  ??ٙ?????ٙ?ٙ?ٙ?ff?33@   @ff@ff@   @   @   @   ?33@   ?ff?ff@   ?ff@@ff@@33@ff?33@ff@   @   ?33?ff?ff?ff?33?ٙ@   ?33@?33@33@ff@ff@ff@@?33?ff?ٙ@ff@@   @&ff@Y@s33@fff@Fff@9@@  @33@Fff@333@9@9@Fff@33@@l@  @S33@L@&ff@@  @`  @l@l@@  @&ff@L@s33@L@Fff@Fff@`  @S33@Y@s33@fff@S33@Y@9@9@333@,@   @&ff@   @@  @333@@  @Fff@S33@L@fff@  @l@@@@@  @`  @333@333@&ff@33@@   @   ?33@ff@ff@@?33@   @ff@?ff@   @   @   @   @   @33@@@  @@33@9@,@&ff@   @,@   @33@S33@L@@  @333@333@&ff@&ff@33@   @ff@@@@33@@@33@   @,@L    >==>>?   ?   >L>L>L====>L>L>L>L>>>L>L>>>>>>>>>>L>=>>>?   ?   >>>>>?   =>>>L=>>>L>?   ?   >>>L=>>?   >>>>    ?   >L?   >L>L>>L    =>L>L>>>    =>L    ==    =>    ==>    >L>=        >>L>>>L>L=    >=>>>=    >L>    >L=    =>>>>L>>>>>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>L>L>L>L>L>L>L>L>L>L>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>    >    ?>>>L>=        >>L>>>L>L=    >=>>>=    >L>    >L=    =>>>>L>>>>>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>L>L>L>L>L>L>L>L>L>L>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y ===>L>Ly >>>L?333??>?   >??L?fff?fff>>?   >>>>>L>>>>L>L>L>L>>>?   >>>>>>>>L>L=>>L=>L>L>>L>>L>L>L>L>?   @>>>>L>L=>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>>>>>>>>>>L>L>L>L>L>L>L>L>L>L>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>L>L>L>L>L>L>L>L>L>>>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>L>>>>>>L=>>L>L>>>>L>>>L=>L=    =        =>L>>>L>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>>                                                                                                                                            >L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    =                                                                >L                        >L?   >>L>?   >>    >>>L                                                                                                ==                    ==>L>L=>L>L>L=>>L>L=                    >L>?   >L>>L>L=>L==>L=>L>L>>L>>L=>>>            >L==        =                                                                                    ==>L=>L>>L>L>>L?   >?   ????????   ?   ?   ??L?333??333?fff?L?L?L?L?333?L?L?333?>?   ?333?   >??   >>>=>            >>=        >L=>>>L>L==                                ===    =    >L====>L=>L>>??   ?333?333?fff?333?333??L?333?333?   ?   ??>>>?   ?   >>>L    =>L=>L>L>L>>>>>>L>>>>L>L>L==>L>?   =>L>L>L=>L>L>L?   ?   >=>L=                                                                                                                                                =                                        =        ===>L>L>L>=>>>L    >?  ?33?fff???33??ٙ@ff?ٙ@?  ?fff>@9?  @?33?                           >?L?    >>L=?  ?@?33@33@l@@  @@  @33@  @33?=                                                                ?fff??333?333?      ?33>>?>?   >?L>>?   >?   ?333?>??L??333>    >L=            =                                                                                                            ?   >?   =                        ?   ?   >L???ff???ff?L>>L>L====?   >L>L>L>>L>L                                            >L>L>>?333?L?L?   >>>L>L>>L        =        >>>?>>>>>>>>??333?L?L??333?fff?fff>=>L?=                                            ?   =    >L                                ?>?   ?   ????   >L===                                                                                                                                                            ==?>>L                                                                    ==>>?   ?   ?   >?   ?>L=>L=            =    >L=                                                                                                                        =                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                >                                                                >>L==    ?333                                                                                        >===    >>L>>>L=>L?   >L>L>L=>L>L==>L        =    ===        ====>L=                =    ===                                                                    >L    =    >L=                    =>L    =        >>>    =>=                                                            >L                    =>L>L>>L>L>===>L=                            =                            =                    =            =                =                                            ==>====    >L                    =                =>>L>>?  ??   >>>=>L>L>L===>L    ===                    =                                =    =    ==    ===                ==                        ==>L=    =                                                ===    ===    >L    ====>>>L>=>L>=>L>=?   ==>    >L===>L>>L>L=>L>L>=>>L>>L>L>L>L>>L>L>L>L>L>>L>L>>>>>>>>>>>>L>L>?   ?   >>?   >>?   >>>>>>>L>>>>>>>>L>>?   >?   >??333??fff?333?333??   ?   ?   ?   ???333??333?ff?>>?333??fff?333>>?   ?   ?   ?L?   ?   >>>>?ff?   ?   ?   ?   ?   ?   ?   ???   ?   ?   ?   ?   ????>?   ?   >?   ?   ??   ??   ?   ?   ??   ????333?   ?   >>?   ?   ?   ??333???333???333?????333?????333?L?L?????333?L?333?333??333?fff?L?333?333?L?333?fff?????????333?L?333?333?333?333?333??333??????333???fff?333?333?L?333?L?333??  ????333??333?333????333?333?L                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    ?333?   ?L>>L=>L>L>L>==>>L>>L>>???>?333????  ?fff?  ?  ?L?  ???  ??  ?ff??ff?fff?fff?  ?  ?33??  ?fff?333?L>=>L=    >L    >>>>>?L?fff?L?L?L?  ??333?L?333??L?333>L>L?333????  ?  ??fff?fff????  ??L?333?   ?L???33?33??333?L?L??ٙ@ff@33?33?ٙ?ٙ?ff?333??L?  ?  ?  ?fff?fff??  ?ٙ?  ?  ?  ?  ?L?  ?fff??333???   ?L>???333?333?333?L???333?fff?   ?   >>L>L=>L===    >L>??333?333??333?   ???   ??333?   >>>>?>??333?   >>L                                            =>>??fff??>>??>L>L>L?333???ff@??  ?fff???L>?333?   ?   >?   >?   ?   >>?   ?>?>??L?fff?L?L?fff?L?fff?fff?fff?fff??333?333????   >>L===>>>L>?   ?>=    >L=                    ==                                ==    ?33@ff??ff?33??ٙ?ff?ff?ٙ?  =?L??L?  ??33?33?fff?L?333?L??fff?L?   ?  ?L??fff?333?L?333?333??L?333?333???   >>>L>L>>>?L@S33@   ?33?ff?  ?L?  ????>>L@`  @ff@陚AffAADAaAIA0  A  A33AvffA\A0  A6ffA,A#33AAA33@@陚@ff@ff@ٙ@ff@33@ff@33@@ff@33@@陚@ff@ff@ff@  @@ff@@s33@y@l@  @@33@@@  @ٙ@ffA   A(  A;33AAdAh  AA  A33A  y y y y y A  A33AffAffAffAs33A`  ATAIALAP  A9A6ffA+33A&ffA.ffA333A+33ANffA\AQAK33A@  A6ffA4AH  A>ffAK33A\A^ffA[33ANffA8  A+33A(  AAffA  A  A@@ff@@ٙ@33@ff@33@  @ə@ff@@  @  @ff@ff@@@@ff@33@@  @33@33@33@l@l@l@@s33@33@@  @ff@@,@Fff@ff@s33@S33@L@L@L@&ffA  @@33@ff@33@@33@`  @fff@y@ff@@ff@@ff@Y@&ff@L@L@&ff@S33@s33@  @ff@@ff@33@33@fff@,@S33@@  @l@Fff@Y@l@y@y@S33@s33@l@  @33@s33@fff@`  @S33@L@@  @@  @333@,@333@9@333@333@333@,@,@   @,@@  @@  @S33@  @@`  @,?33?  ?ff@   @fff@fff@@@  @  @ff@ff@ff@@@ff@33@@ff@33@ə@ə@  @陚AffAA(  AffA@陚AA   @  @33@@33@  @  @ff@@ə@33@33@33@ff@ff@  @33@@  @ff@  @ٙ@  @@33@@A   AffA  A(  AYA\AYAIAAA.ffAA  AffAA33AAA#33A4AC33AK33AQAQAC33A<A@  A$AffA33AffA  @@@ff@@ff@  @ff@33@@ff@陚@@@@  @33@陚@@ff@ff@ff@ə@33@  @@ff@fff@Y@  @  @ff@33@@@33@ff@fff@Fff@33@`  @L@Fff@S33@Y@Y@S33@Y@L@@  @,@9@333@&ff@@@33@33@33@@&ff@   @333@L@ff@,@y@&ff@@  @   @   @9@@  @   @333@&ff@L@Fff@333@   @L@9@S33@`  @@S33@333@&ff@33@&ff@ff@@  @@@y@  @  @@A@  @AA  Aff@ٙ@@  @A#33A333A9A,AAA6ffA8  A4A#33AffA@@ff@  @33@33@ff@  @@33@@  @y@Y@Fff@333@33@@  @@  @@  @@  @@9@&ff@33@33@@@ff@   @@Fff@   @@33@   @@33@?33?33@ff?33@   @,@,@@33@ff@   @   ?33?33?ff?ff?33@?ff?ٙ@   ???  ??  ???  ?  ?  ?ٙ?ٙ?33?ff?33@ff@   ?33?33??ٙ??33?  ??  ??ff??33??ff?ff??  ?  ??ٙ?33??  ??ٙ??33??ٙ?  @   @ff?ٙ??fff?  ?L?L?fff??  ???fff?  ??@9@  @A  A33@  A+33A$A)AAA  AffAffA@33@@陚@ٙ@  AAA&ffAAffAA$A33A  A	AA   A@ٙ@ff@ff@ff@  @ff@  @33@@33@  @@  @@@  @  @L@   @@ff@33@`  @Fff@ff@@  @33?  @&ff@,@&ff@33@S33?ٙ@ff@33@@@ff@@   @ff?33@ff@33@   @   @ff?ٙ?ff??ff?  ?@@   ???33?@   ????fff?fff???  ?ٙ@@,@ff@,?ff@?33?ff?ff?ff???ff?33?ff?ff?33?33?ٙ?ٙ???  ??ٙ?  ?33?33???33??ٙ??  ?  ??ff?ٙ?ff?ff?33??  @ff?@ff?33?ٙ?ٙ?ٙ?ٙ?  ???ff?  ?33?  ??33?33???ff?fff????  ?  ?????  ?  ?  ???  ???fff?  ?fff?  ?fff?  ???  ??fff?L??333?333?  ??333?L?fff?333?333??333?333?333??333?L?  ?L?  ?  ?333?333?333??  ?L?fff?fff?fff?fff?fff?L?   ??333?ff??   ?   >?   >?fff?ff?L?333?L?L???>L??L>?   ?333?333?  ?  ?L?   ?fff??L?  ?ٙ@   ?33?33?33?ff??L?fff?fff?333??ff??ff?  ??fff?333?33?  ?ff?L???  ?L??333?333?   >>?   >?   >?   ?   >?   ??333?333?ٙ?fff?33??333???333?L??fff?L?L?  ?333?L?   >>==>L?   >>??333?>>??333>?   >>>L>L>>>>>>>>>>?   >>>>>?   ?   ??333?   ??   >?   ?   ?   >>>?   ?   ?333?333?333?333?333??   ?   >?   >?   >>>>L>>>>L    >L>>>>??   >>>>>>>?L??L??ff?333?fff?  ?fff?  ?fff?  ???fff?  ?  ?333?fff?fff?>>L>L>L>L>?   >>>>?   ?   ?   ?   ??333?L?L?333?   ?   ?   >?   ?333?>???????fff?  ??   ???333?333?   ???333??L?L?L?L?333?333???333?fff?L?   >?   >>>>??   ?333?L?333?fff?  ?ff?L?L?L?  ?333?fff?>>>>>>>L>L>>>>L>L=>L>L>L>L>>L>>>?   ?   ??   ?   ???333?333??333?>>?   >>>>>>>>>>?   >?   ?   >?   ?   >>?   ?>>>?   ?   >?   ?   ??333?fff?   ?L?L?333?L?fff?333?L???L??333??  ?  ????fff?L?L?L?333??   >L=            =                            >L>>L>?   ?   >>>>?   >    ?
=\)    ?
=?
=?=q\)?
=?
=?=q?=q?=q@Y?
=?
=?=q@Y?
=?=q?=q?=q?=q?
=@Y?
=?
=?
=?
=\)\)?
=    ?
=\)    ?
=?=q?=q\)    ?=q\)?=q\)\)\)\)\)?
=\)?
=\)?
=\)\)    \)        \)    ?=q?=q\)?=q        \)                ?
=    \)\)    ?
=                                                \)        \)    \)?=q?=q?=q?
=@Y@Y@
=@
=?=q@
=?=q@Y?=q@
=?=q@Y@
=@G@
=@G@
=@Y@
=?
=?
=?=q?
=?=q?
=?=q@
=@Y?=q?
=@Y\)?
=    \)?=q?
=?
=?=q?
=?=q\)@Y\)\)?=q@
=?
=@Y?=q@Y\)    \)?
=    \)    ?
=    \)?
=\)\)            ?
=        ?=q@Y\)?
=    @Y?
=\)\)\)?
=\)    \)        ?
=?=q?
=\)?
=\)\)?=q?
=?=q@
=@G@GAAA\  A\  A\  @GA:HAA:HA\  A\  A:HA:H?=q@Y\)?=q\)?=q?
=?
=?
=?=q?=q\)\)@Y?=q?=q@Y@
=?
=?=q?
=?
=?=q?
=?
=\)\)\)    ?
=\)        ?
=?
=\)    \)\)                    @
=A:H                \)?
=?
=\)?
=\)?
=\)\)\)?
=    \)            \)\)    ?
=\)?
=@Y?
=\)@Y@Y@Y@Y@
=@
=@G@GA:HAAA}AAAAAAA}A\  A}A}A}A\  AAAA\  AA:HA:H@GA:HA@
=@GA@
=@
=AA@G@G@
=?=q@G@
=@Y@Y@G@G@G?=q@Y@Y@Y@Y@Y@G@Y@G@
=@GA@
=@Y@
=@G@Y?
=@Y@
=?=q@Y?=q@G@Y@Y@
=@Y?=q?=q@
=?=q@Y\)?=q\)?
=?=q@Y@YA}A\  A@YA:HA=qAA\)AA=qA\)BB	BB	B"B"BL
=B333B	BB\)BB\)BB"AzAAABA\)B{B{A\)B{BAzA\)AAA}A\  A}A@GAA@GAA}A\  AA}A\  @GA:HAA:HA}A:HA\  A\  A:HAA\  A@GAAA@G@
=@
=@Y@
=?=q@G@Y@
=@
=?=q@GA@
=@Y    ?=q@Y\)?
=?=q?=q@
=@Y@YA\  AA\  A\  A}A:HAA\  A\  AAA=qAAA}AAA=qA=qAAA\  A}AA}A:HA:HA}AAAAA\  AA\  A\  A}AAA\  AA\  A@GA:HA\  A:HA:H@
=AA@G@
=@
=@YAA?=q@Y@Y@Y@G@G@
=@Y?=q?=q@Y?
=@Y?
=?=q?=q?
=?=q?=q@Y?=q?=q?
=\)\)?=q?
=?
=\)\)\)?=q\)        ?
=\)\)\)\)@Y?
=?=q?=q@
=@G@
=@G@GAAA:HA}A}A\  ?=q?
=?=qA@
=@G@Y@G@
=@
=@
=@Y@GAA:HA\  A:HA\  @
=AA:H@G?=q@
=@G@G@G@GAAA@GA}A\  A\  A}A}AA:H@G@
=@GA:H@G@Y@
=?=q@
=?=q?=q@Y?=q?=q@Y@
=@Y@
=@
=@Y@
=AA@GA:H@GA\  @
=@Y@
=@
=@
=@Y@
=?=q?=q?=q\)?=q?=q@
=@GA@GA\  A:HAA\)A\)AA\  A\  @GA}A}AAA:HAA}A}A:H@G@
=@G?
=@G@Y@
=@
=A\  AA:H@GA\  A\  A:HA:HA:HA:HA\  A}AAA:HA:HA:HA\  AA@G@GA\  A:HA@GA\  @
=A}AAA@G@GA@G@Y@Y@Y@
=@Y?=q@Y@Y?=q?=q?=q@Y?=q@Y@Y@Y@G@Y@Y?=q@Y@Y@Y?=q?=q?
=?=q?=q?=q@Y@
=?=q@Y@Y@
=@
=@GAA:HAA:HA}A\  @GA:HAAA}A\  A}A@GAA:H@Y@
=@YA@G@
=@G@GAA@G@G@Y?=q?=q@
=@Y@Y@G@Y?=q@
=@
=?
=@Y?=q?=q?=q?=q?
=?=q?=q?=q?
=?
=@Y@Y?=q?
=@Y?=q?=q@Y@Y@Y@Y@Y@
=?=q?
=\)@Y?=q@Y?
=@Y?
=?
=?
=?
=    \)?
=?
=?
=?
=    ?
=\)?
=\)\)\)\)\)?
=    ?=q@Y@
=@G@Y@
=@G@GA\  AA:H@GA}AA:HA@GA@GA\  A}A:HA}A}A\  AA\  A@GA}@
=@
=?
=@Y@Y@
=@Y@
=@
=@
=@G@G@G?=qA\  A\  @
=AAA@GA\  @GAA:HAA}A\  AA:H@G@
=@
=@G@
=@
=@
=@G?=q?=qA@Y@
=@
=@Y?=q?
=\)?
=        ?
=?
=?
=?=q?
=@Y?=q?=q?
=?
=@Y@Y@
=@Y@Y@Y@GA:H@GA\  A\  A}AA}AAA\  A:H@GA:HA\  A:HA:HAA}AA\  A}A\  A}A\  A\  A:HA\  A\  AA:H@
=AA:HA@GAA@G@
=@YA\  AA@G@G@
=@Y@G@GAAA@GA@Y@G@G@G@GAA:HA:H@GA@GA:HA@GA@YA?=q?=q?
=?
=@G@Y@G@Y@Y@Y@G@YA\  @
=@GA@
=@G@G@G@
=@G@GAA\  A:HA}A}A:HA:HA:HAA=qA=qAA\)AAAA\  AA}AA:HA\  A\  A\  A}AAAA\  AA:HA:HA\  A@G@
=A:HA@G@
=A:HA:H@G@G@G@G@G@
=@
=@G@Y@
=@G@
=@
=@G@Y@Y@
=@Y@
=@Y@
=@Y@Y@
=@Y@
=@
=?
=?
=?
=\)\)?
=    \)\)\)?
=    \)?=q?
=\)\)?
=\)?=q?=q?
=?
=?=q\)\)?=q?=q?
=?
=?
=?=q@Y?
=?
=?=q?=q?=q?
=?
=    ?
=?
=    ?=q@Y?=q?
=?
=@Y    ?
=?
=?=q\)\)?
=@Y\)?=q?=q?=q?=q    ?
=?=q?=q?
=?
=?=q\)?=q?=q?
=@Y?
=\)?
=?=q?=q\)?
=?=q?=q\)?
=?
=    ?
=?=q?=q?
=?=q\)    \)    \)\)?
=\)    \)\)            \)                \)\)\)                ?
=    \)?
=    \)?=q\)?=q?
=?
=\)@Y@Y@Y?=q?
=?
=@Y\)    \)?=q?
=\)\)?
=\)\)\)\)\)\)?=q@Y?
=?=q@Y?=q?
=\)?
=\)\)?
=    ?
=?=q?=q?=q\)?=q?=q?
=?
=?
=?
=\)?
=\)?=q    ?
=    ?=q?
=?
=?
=    ?
=?
=?
=\)?
=\)?=q?=q?
=    \)\)?
=\)        \)            @
=?=q\)    \)?=q                                        ?
=?
=?
=?=q?
=    \)    \)\)?
=?
=\)\)\)?
=    ?
=?=q?
=?=q?=q?=q\)?=q?
=?
=    ?
=?
=?
=\)?=q        \)?
=\)?
=?
=\)\)\)@Y?
=\)?
=\)?=q\)\)\)\)        \)\)                    ?
=\)                                                        ?
=\)?
=            ?
=?
=    \)?
=?
=?
=\)?=q?
=?
=?=q\)?
=@Y@Y?
=?
=?=q?=q?
=?
=?
=@Y?=q@
=?=q@
=?=q@Y@Y?=qA?=q@Y@
=@Y?=q?
=@Y@Y?=q?
=\)    \)?=q?
=?
=?
=?
=\)?=q    ?
=?=q@
=\)@Y?=q    ?
=\)?
=?=q?
=?
=\)?=q    \)\)?
=\)?=q?
=@Y@
=A\  A\  @G@YA\  @G@G@
=@
=A\  @Y@Y?
=?
=@Y\)?=q@
=?
=    @Y        ?=q    \)    \)        \)?
=?
=?
=\)\)?
=?
=?
=?
=?=q?
=?
=?=q?
=?=q?=q?
=?
=?
=    ?=q?
=@Y?=q?=q?
=?=q?
=?
=?
=?
=?
=?
=?
=?
=?=q?
=?
=?=q@
=?
=?=q?
=\)?
=?
=?
=?
=?=q    \)?=q\)\)@Y?=q?
=?
=?=q@Y?=q?
=?=q?
=\)\)?
=?=q?
=\)@Y?=q?
=?=q?=q\)?
=?
=\)                        \)\)    \)?
=\)?
=\)\)\)?=q\)\)\)?=q\)?
=?=q?=q\)@Y\)?=q?
=\)?=q?
=\)?=q\)?
=?=q?=q\)    ?=q\)?
=\)\)?=q?
=\)?
=?=q\)?
=?
=?=q\)?
=?
=        \)\)    ?
=\)?=q    \)    ?
=?=q\)?
=\)?
=    \)\)?
=?
=?
=?
=?=q?
=?
=?
=?=q\)        \)\)\)\)\)\)\)    \)    \)                    ?
=    ?=q?
=\)?=q@
=?=q@
=@
=@
=@
=@
=?=q@
=?
=@Y?
=?
=@Y@Y@Y@Y?=q?
=?=q?=q?=q?
=?
=\)\)\)    ?
=?
=    ?
=?
=?
=B{    ?
=@Y    \)?
=\)\)\)?
=    ?=q\)?=q\)?=q    \)\)\)\)\)\)?
=    ?
=@Y@
=?=q?
=?
=?=q    ?
=?
=?
=        ?
=?
=?=q\)\)?
=    \)?
=    \)    @G?
=?
=    ?=q?=q\)?=q?
=?
=@Y@G?=q?=q    @Y    ?=q?=q?=q@Y?
=\)@Y?=q@Y?=q@
=?=q@Y?
=    ?=q\)@Y\)\)?
=    ?
=?
=\)    \)    \)            ?
=    \)\)    ?
=?
=?
=\)\)\)\)?
=    \)?
=?
=?
=\)        \)                    ?
=?
=    ?
=    \)    ?
=\)        \)            ?=q                                \)\)\)    \)\)\)\)    \)\)?=q@Y?=q?
=?=q?
=?=q?=q\)\)\)\)    ?
=\)?
=\)    \)    \)?
=?
=?
=?
=                                    \)\)    ?
=                        \)                    \)    \)\)\)                                            \)    ?
=?=q\)\)\)    ?
=\)?
=@Y?=q?
=    ?
=?
=@Y?=q?=q?
=?
=?
=?
=?=q\)?=q\)?
=?
=?
=?
=?
=\)?
=    \)\)?
=?
=\)?
=\)?=q?
=\)?=q\)\)?
=    \)    \)\)\)?
=\)?
=    \)\)\)            \)                        ?
=    \)                \)                                \)?=q?
=    \)            \)\)    \)                    \)@Y?=q?=q?=q?
=\)\)    \)\)?
=\)\)\)\)\)\)?
=?
=?
=?
=?
=?
=\)?=q?=q\)?
=        \)?
=?
=\)\)?
=    ?=q\)?
=        ?
=    \)\)\)?
=\)\)\)?
=\)\)?
=\)\)?
=?
=\)\)\)    \)\)\)\)        \)\)        \)\)?
=    \)?=q?=q@Y?=q?
=?
=?=q@
=?=q?=q?
=\)                \)    \)?
=\)?
=?
=@
=?=q@
=\)@Y?=q@Y?
=?
=?=q?=q?=q\)?
=?
=\)?=q@Y?
=?=q@
=?=q@
=@Y@Y@Y@Y@Y@Y@Y?=q@Y?
=@Y?
=@Y?=q@Y?=q?=q?
=@Y?
=?=q?
=\)?=q?
=?
=?
=\)?
=?
=?=q    ?
=\)?
=\)\)?=q\)?
=\)?
=?
=\)\)\)@Y\)@Y?
=?=q@Y@
=A:HA?
=\)\)?
=\)    ?=q?
=\)    \)\)    \)\)?
=?
=\)    \)?=q?
=?
=?
=@
=@
=?=q?=q@G@
=@
=?=q@
=@G@G@Y@
=@G?=q@Y@Y@Y@
=@
=@
=@G?
=@
=?=q?
=@G@
=?=q?=q?=q?=q?
=?=q?
=\)?=q?
=        ?
=\)?
=?
=    ?
=?
=@Y@Y?
=\)\)\)    \)        \)\)\)            \)?
=?
=\)?=q@
=?
=@Y@G@Y?
=?
=\)\)    \)    \)?
=\)    \)\)\)?
=@
=?
=?=q\)@Y\)?
=@
=?=qA:H@G@G@G@Y?=q@
=@
=@Y@
=@
=?=q@
=@Y@
=?
=?=q@Y?=q@Y?
=?=q?=q?=q?
=?=q@Y@Y?
=?=q@
=A@G@G?=q@Y?=q@Y?=q?=q@Y@
=A@GA@G@Y@Y@Y?
=?=q\)\)?=q?=q?=q?
=?
=?=q?
=@
=@Y@Y?
=@Y@Y@Y?=q@Y@Y@Y@Y@Y@Y?
=?=q@
=@Y?
=?=q?=q\)?
=@Y?
=?=q\)\)\)\)?
=?=q\)?=q?=q?
=?
=?=q@YA:H@
=@Y@
=@Y@
=@Y?
=?=q?=q?=q?=q@
=@
=@Y@G@
=@Y?=q?
=?
=?
=?=q@Y?=q?
=?
=?
=?
=?=q?=q?
=?=q@Y?=q?=q?=q?=q@
=A@
=@
=@
=A@Y@G@Y@
=@
=@Y?=q?=q@
=@
=@Y@G@GAA@G@Y?=q@
=@G@
=@GA\  A@
=@
=?=q@
=@Y@Y@Y?
=?
=?
=?
=?
=\)@Y?
=?=q?=q@Y@Y?=q?
=?
=@Y@Y\)\)?=q?=q@Y?=q@Y?=q@YA@
=@Y@Y@Y@Y@Y@
=@G?=q?=qA@Y@G?=q@Y@Y@Y@Y?=q?=q\)?
=\)@Y?
=?
=?
=?
=\)\)?=q?=q\)        ?=q\)    \)        ?
=\)?
=?
=?=q\)?
=?=qA}A:HAAA:HA:HA:HA:H@G@
=@
=?
=    ?
=?
=\)\)?=q\)?=q@
=A=qA=qAA}@G?
=?=q?=q?
=\)?
=?=q@YA@G?=q@YAAA\  A}AAA:HA}@GA:HAA:H@G@G@G@GA@
=?=q@
=@
=@Y    @Y\)\)?=q?=q?
=?=q?=q@
=@Y@Y@
=@Y@YA@G@
=?=q@GA:HA@G?=q@G@
=A\  @
=@Y?
=?
=?
=?
=?
=?
=?
=@G?=qA@
=A}@GA\  @
=@
=?
=?=q?
=\)\)?=q?=q@
=@Y?
=\)?=q\)?
=?
=\)\)?=q?
=@Y?=q?
=?
=?=q?=q@G@
=?=q?=q@
=@
=@GA:H@
=@
=@
=@GA@G@Y?=q@Y@
=@Y@
=?=q?
=\)\)?
=\)?
=?
=?=q?=q?
=?
=@
=@G@
=A\  @GAA\  AA}A}A:HAA\  @
=@Y?=q@
=@
=@Y@Y@Y?=q    @
=@
=@Y@
=@
=A:H@G@YA@Y@GAA@Y@Y@Y?=q?
=?=q@Y\)?
=?=q?=q?
=    \)            \)    ?
=?
=\)?
=?=q?
=\)?
=\)?
=?
=?=q?
=\)?
=?=q@G@
=?
=?=q?=q?=q?=q\)\)\)@
=?
=\)?
=\)?=q?=q?
=\)?=q\)?=q?
=?
=\)\)?
=\)\)    ?
=\)?=q\)?=q\)    \)\)?
=\)?
=\)?
=?
=\)?=q\)?
=    \)?
=?
=@Y?=q?=q@Y?
=?
=?
=?
=                    \)\)\)    \)?
=\)    \)?
=        \)        \)?
=        \)\)    \)?
=@Y?
=@Y?
=@Y?=q?=q?
=?
=@Y@
=?=q?
=\)@
=?
=?=q?=q\)\)\)\)?=q?=q@
=?=q?
=?=q?=q?
=\)?
=\)\)@Y\)?=q?=q\)?=q\)?
=\)?=q?
=\)@Y?=q\)?=q\)?
=@Y?=q?=qA:H@
=@
=@G@GA?=q@
=@Y@Y@Y?=q@
=@
=@GA@YAA:HA}AAA=qA@G@G@G@G@G@
=A\  A:HBGBRBpC(CHC-(B{B8RBRB}RBL
=A\)AAA\  A\  A=qA\  A@Y@Y?=q?=q\)?=q@Y?=q?=q@
=@Y@Y@Y@
=@Y?=q?=q?=q?
=\)?=q@Y?=q\)\)\)?=q\)?=q?=q?
=@
=@Y?=q?
=?
=?=q?=q@Y\)?=q?
=?
=?
=\)?
=\)@Y?=q?
=\)?
=\)?
=?=q\)?
=    ?
=?=q?
=\)    \)?
=@Y?
=@G?=q    ?
=@
=\)@G@Y    ?
=        ?
=@Y@Y@Y@G?
=?=q@
=@G@G\)?
=@Y?
=@Y?=q\)?
=\)?
=\)?
=\)?=q\)\)\)?
=?
=\)?=q@Y?
=?=q\)?=q?=q    \)?
=    \)    \)    ?
=    \)\)?
=\)\)?
=?
=\)\)    ?
=            ?=q    \)            ?
=    ?=q?
=\)\)\)    ?
=    ?
=?
=?
=?
=\)                            \)                        \)?
=    \)\)    \)\)\)?
=?=q\)?
=?=q@Y@
=@G@Y@G@Y?=q?=q?=q@Y@Y?
=@Y@Y@
=@
=@
=?
=?=q?=q@Y?=q@
=@
=?
=@Y    ?=q\)?=q\)\)\)?=q?
=\)?
=                        ?
=?
=    ?
=\)?
=?
=\)\)        ?
=\)    \)    ?
=?=q\)    \)@Y\)?=q\)\)                ?
=?
=\)        \)            \)\)\)    \)\)\)    \)    ?=q\)\)?
=?
=?=q?=q?
=?
=?
=@Y?
=\)?=q?
=\)?=q    \)?=q\)?
=@G@
=?
=\)?
=\)\)    ?
=?
=    @
=?
=?
=@Y@
=?
=@Y@Y?=q?
=?=q\)?=q?=q?
=?
=?=q@Y@Y?
=?=q?
=@Y?=q?
=?=q@Y@
=AA@
=@Y@Y@
=\)?
=\)?=q?=qA?=q?=q\)\)?=q    \)\)?
=    @Y@G?=qA\  AAA}@
=@Y?=q\)?
=    A@Y?=q@Y@Y?=q\)\)    \)    \)\)?
=@G?=q?=q@Y?
=\)?=q?
=    \)    ?
=\)\)?
=\)?
=\)?
=?=q@Y@
=@
=@G@
=@G@
=@Y@
=@G@Y?
=?=q@
=@
=@
=@
=@
=?=q?=q?=q?=q\)?
=@Y@Y?
=?
=?
=@Y@
=@Y?
=?=q?=q@Y?
=?
=\)?=q\)\)        ?
=\)            \)    @Y        \)?
=    \)                    ?
=?
=?
=\)        ?=q\)?
=\)?=q\)\)?
=\)    \)    \)                                            \)\)?
=            \)\)    ?
=        \)                \)?
=\)\)?
=\)        \)\)    ?
=\)\)\)\)?
=\)        ?
=\)        \)    \)                \)                    \)    \)        \)                            ?
=                    \)\)?
=\)    \)\)\)?
=\)        ?
=\)    ?
=\)                                        ?
=\)?
=                                \)        \)                \)    \)\)\)    \)?
=?=q\)    ?=q\)\)\)\)        \)            \)                                                                                                        \)        ?
=\)    \)    \)\)        \)\)                                            \)    \)            ?
=                            \)                            \)                                    \)                                                                                                                \)                                                                        \)    \)    \)                                                                            \)        \)\)?
=    \)                \)                    \)                \)                \)\)\)                                                                                                                    \)?
=\)    \)\)?
=\)\)?=q\)    ?=q?=q\)?
=    ?
=    \)?=q\)\)?
=?
=    ?
=?
=?=q    \)            ?
=        \)        \)    \)?
=?
=                    \)        \)                \)                                            \)                                                \)                                        ?=q    ?=q?
=?=q@Y@Y@Y?=q?=q?=q?=q    ?
=\)?=q?
=?
=\)    ?=q?
=\)\)?
=?
=\)    ?=q?
=?=q@Y@Y\)?=q?=q@Y?=q?=q@Y\)?
=?=q?=q?
=    \)?
=\)?
=\)?=q?
=?
=?
=\)?
=?
=?
=?
=?=q\)?=q?
=?=q?=q?=q\)            \)\)        \)                            ?
=\)        ?
=\)?
=\)\)?=q?
=?=q?
=@Y?
=@YAA:HA:HA:HA}A:HA:HAAA\  A:HA\  AA:H@G?=q@
=@Y@Y@Y@Y?=q@
=?
=?=q?
=?=q@Y?
=?
=@
=\)?
=?
=?=q@G@G@Y@Y?=q@Y?=q@
=?=q@Y?
=@Y?
=@Y?=q?=q?=q@
=?=q?=q?=q@
=?
=?
=\)?
=\)?
=@
=@Y?
=?=q\)\)?
=\)    \)    \)    \)            \)\)    \)    \)            \)?
=?
=\)?=q?
=@Y?
=?
=@
=@G@
=@Y\)?=q?=q@
=@Y@
=\)?=q?=q?
=    ?=q?
=    ?
=?
=        \)                    \)\)                        \)\)        \)                \)                    \)\)\)                                ?
=                                        \)\)                                            \)    \)?
=@
=?
=@Y\)?
=?=q@Y@Y?=q?
=?
=\)?
=?
=?
=\)?
=\)\)?
=@Y?
=?
=    \)        \)\)\)    \)        \)?=q\)    \)                        \)\)\)\)        \)    \)            \)            \)\)    \)                            \)                    \)        \)    \)        ?
=\)?
=    \)    ?
=    \)\)?
=\)\)?
=\)?
=?=q\)\)\)\)?=q\)?
=?=q?=q@Y?
=    ?
=\)    \)?
=?
=?=q    ?
=    \)\)?
=\)\)    ?=q\)\)    \)?
=?
=\)\)\)    \)?
=    ?
=\)\)\)\)?
=?
=        ?
=?
=\)?
=            \)\)\)                        ?
=\)        \)?
=    \)\)?
=\)    \)\)    ?
=\)\)?
=\)    \)@
=@
=?=q@
=@Y@
=@G@GA@
=?
=?=q\)?=q@Y?
=?=q?=q@Y?=q@Y\)?=q?
=?=q@
=?=q?=q?
=?
=@
=?
=\)@Y?
=?=q@Y?
=?
=?=q?=q?
=?=q?=q?
=?=q?
=?
=?=q?
=?
=?
=?
=?
=    \)?
=\)?
=?
=@Y?
=?=q\)?
=\)    \)        \)\)                            \)\)\)        \)?=q\)?=q?=q?
=@Y?
=@Y?
=@Y@Y?
=?
=@Y?
=A:H@
=@
=@Y@Y@
=@Y?=q?=q@
=@Y@
=?=q@Y@
=?=q?=q?
=?=q\)?
=?
=\)?=q?=q@Y?=q?
=?=q@
=?=q@Y?=q?=q@Y?=q\)?
=\)@Y?
=?
=?
=?=q?=q?=q?=q\)?=q    \)?=q    ?
=?
=\)    \)    ?
=    \)?=q?
=?
=\)        ?
=\)?=q\)    \)?
=        \)                \)        ?
=                \)\)    ?
=?=q\)\)\)?=q?
=?
=?=q@Y\)?
=@Y?=q?=q@Y@Y?=q@
=?
=?
=?
=?=q?=q?
=?
=?=q?
=    ?
=?=q?=q?=q?=q?=q\)?=q?
=?
=?=q?
=?
=?=q?
=?
=\)?
=?=q?=q?
=?=q?
=\)    ?
=?
=?=q?
=?
=\)\)            ?
=\)\)?
=?=q            \)?=q\)                @Y@
=            \)    ?
=?
=?
=?
=?
=?=q@Y?=q?=q@Y@Y@
=@
=?=q@Y?=q@
=@Y?
=?=q@Y@
=?=q?=q?
=?
=?=q?
=?=q@Y?
=?=q?
=\)        \)?
=?
=\)?
=?
=?
=?=q\)?=q?
=\)?
=?
=?
=?
=?
=?
=\)\)?
=\)?
=\)\)?=q?
=?=q@Y\)?
=\)?
=?
=    \)?
=                \)    \)    \)                ?
=?
=    A=q@GA@Y?
=\)\)    ?=q                \)        \)?
=\)?
=?
=?
=?
=    \)?
=    ?=q?
=\)?
=?=q\)?=q\)    @Y@Y\)\)?=q?
=?
=\)\)?
=\)?
=?
=\)\)?
=    \)    \)    \)                            \)        \)                    \)                    \)\)    \)                    \)\)    \)@G\)            BC?=q    \)\)?
=    ?
=\)        ?
=            \)?
=    ?
=\)\)?
=    ?
=?
=?
=?
=\)?
=?=q?
=?=q@Y?=q?
=?
=?
=\)?=q\)    ?
=?
=?
=\)\)    ?
=    \)    \)\)?
=        \)\)\)?=q?=q\)?=q?
=    ?
=?
=    \)?=q\)    \)\)\)\)        \)            \)\)\)                                            @Y    A:H@Y        \)        ?
=    ?
=\)?
=\)?=q?=q?=q@Y@Y@Y@
=?
=?
=?=q?=q?
=?=q@Y?
=?
=?
=?
=?
=?=q    ?
=?
=\)    \)\)?
=\)?
=?=q?
=\)?
=    \)\)    \)        ?
=\)                    \)?
=    \)            ?=q\)\)?
=            \)\)?
=?
=    \)\)\)            \)                ?
=                                    \)        ?
=    @Y    \)?
=?
=?
=?
=@Y@Y?=q?=q@Y?
=?
=    @Y?
=\)?
=?
=\)\)?
=\)?
=    \)?=q@Y\)\)\)@Y?=q?=q?
=?
=    ?
=\)\)?
=?
=?
=?
=\)\)?
=\)\)?
=                            ?
=\)    \)    \)        ?
=\)\)    ?
=?
=    \)\)\)?
=?
=?
=?
=    \)\)    \)                        \)    \)?
=?
=?=q?=q?
=@
=?=q?=q?
=?
=?=q?
=?
=?
=?
=?
=?
=@Y?
=?
=?=q?=q\)    ?
=\)?
=    ?=q?=q?
=?=q@Y\)?
=?=q?
=?=q?
=?
=\)@Y?=q?
=?=q?=q    \)\)?
=    ?=q\)?
=?
=?
=\)?
=?=q?
=?=q    ?
=?
=?
=    \)\)\)\)@Y@Y\)@Y?=q@Y\)\)                        \)    \)    \)                        ?
=\)?
=    ?=q\)?
=?
=?
=\)?
=\)@Y?=q?
=\)?
=\)?=q?
=?=q?
=?
=\)?=q?
=?
=?
=?
=\)    ?=q    \)\)    ?
=?
=        \)\)        \)\)    \)                        \)    \)\)    \)\)\)\)    \)?
=        ?
=    \)    \)            ?
=\)            \)            @Y                    \)\)\)                \)\)\)?
=        @Y@Y?=q?=q\)\)?
=?=q?
=@Y?=q@Y?=q?
=?=q        \)    \)?
=?
=\)        \)    ?=q?
=        \)\)?
=?
=            ?
=\)    ?
=\)    \)?
=    ?
=    ?
=\)?
=?
=            \)    \)    \)        \)            \)                            \)                                    \)?
=                \)    \)@Y?
=\)?
=    \)\)\)\)\)?
=\)?
=?
=\)?=q?
=?=q?
=?
=?
=?
=@Y?
=?
=?=q?
=\)        ?
=\)?
=\)        \)    \)    ?
=    ?
=\)        \)\)\)\)\)            \)\)        \)        \)    \)            \)                                                            \)    \)\)                        \)    ?
=?
=?
=\)?=q?=q?
=?
=?
=?
=\)?=q?=q\)    \)?
=    \)\)?
=\)\)    \)        \)?
=    ?
=\)            \)    \)?
=                                \)                \)\)                                    ?
=                            \)\)                                                    \)    ?=q\)    ?
=@Y?=q@G@Y?=q@
=@
=@
=@
=@Y@
=@Y@Y@
=@Y@
=@Y?=q@Y@
=?=q?=q@Y?
=@Y@Y@G@Y@Y?=q?
=?=q\)?
=?=q?
=\)\)@Y?
=\)?
=?
=?
=?
=?=q?=q?=q?=q?=q\)\)?=q?
=@Y?
=    \)    \)?
=\)?
=?
=?
=\)    \)\)\)?
=?
=?=q?
=?
=    \)    ?
=?
=\)?
=    \)    \)    ?
=\)?
=?
=?=q?=q@Y@Y@Y?
=?=q@Y@Y@
=?=q@GAA\  A:HAAA:HAA:H@G@GA\  @GAA@
=@
=A:HAA\  A@Y@
=@
=@Y?=q@Y@G@
=@Y?=q@Y?
=?=q?=q@Y?=q@Y@Y@Y@Y?=q?=q?=q?=q?=q@Y@Y?=q@Y@Y?
=?=q@Y?
=\)\)?=q?
=?=q?=q?
=?=q?
=?
=\)\)\)?=q    ?
=\)        ?
=\)@Y    \)    ?
=?
=    ?=q?=q    \)\)?
=    \)\)?=q?
=\)?
=?
=?
=\)?
=?
=?=q?=q    ?
=    ?
=\)\)\)\)?=q    ?=q        ?
=?=q@
=?
=?=q?=q?=q?=q?=q?=q?
=?
=\)    \)\)\)?
=    ?
=\)\)\)\)        ?
=?
=\)\)        ?
=        ?
=\)?
=?=q?
=\)\)        ?
=?
=\)\)    ?
=\)        \)\)\)    \)                                            \)            ?
=    ?
=\)\)?=q\)\)?
=    \)?
=?
=?=q    \)\)?=q?
=    @Y\)?=q?=q\)    ?=q?=q    ?
=?
=    ?
=\)?=q?
=?
=?=q?
=\)\)?=q?
=\)\)?
=\)    \)\)?
=\)\)\)?
=    \)\)?
=\)        ?
=        \)    ?
=?
=    \)        ?
=?
=?
=?
=?
=?
=?
=\)\)?
=?
=?=q\)?=q?
=@Y?
=?
=?
=?=q?=q@Y@
=?=q@G?=q?=q@Y?=q?=q?=q?=q?=q?
=?=q?=q@
=@
=@Y\)?=q?
=\)\)?
=?
=?=q?
=?=q?
=\)?
=?
=?=q?=q?=q\)\)    \)?=q?
=?
=    \)    \)    ?=q?
=        \)?
=    ?=q\)\)?
=\)    ?
=\)\)                    \)\)?
=    \)?
=                                                                                    \)?
=    \)?
=    \)?
=@Y\)?
=?=q?
=?=q?=q?
=@Y@
=@Y\)?=q?=q?=q?
=?
=?=q?=q?=q?=q\)?
=\)?
=\)?
=\)\)?
=\)?
=>aG\)    \)?
=\)\)    \)?
=\)        \)\)        ?
=\)    \)?
=\)                ?
=        ?
=    ?
=?
=?
=\)\)    ?
=    ?
=?
=\)?
=\)@Y?
=    ?
=?=q        \)\)\)    \)\)?
=\)?=q?=q@Y?
=@
=?
=@Y?=q@
=?=q@Y?=q@Y?
=?
=\)?
=?
=?
=?
=\)@Y?=q    ?
=\)\)\)@Y\)?=q?
=?
=?
=    \)\)\)?
=?=q?
=?
=?
=?
=\)\)\)\)?=q?
=\)?
=?
=\)    ?
=\)\)?
=\)\)        \)    \)?
=?=q\)?=q@Y@G?=q@Y@G?
=                ?
=                        \)\)        \)    \)\)\)?=q@Y?=q@
=@G@G@Y@Y@
=@Y@G@Y?=q?
=?=q@
=?=q@Y@Y?
=@G@
=@G\)?=q?
=?=q?
=\)?
=?
=?=q?
=?=q?=q?=q\)?=q\)?
=?=q\)\)?
=?
=?
=\)\)?
=\)?
=\)?
=\)?
=?
=\)\)?
=?
=?
=?
=?
=?
=    \)\)?
=\)            \)\)\)\)\)?
=\)\)?=q        \)\)\)\)?=q\)@Y?
=@Y?=q@Y@
=@GAA:HA\  AAAAAAA\)A=qA=qA\)A\)A\)AAzABAAAA=qA=qA}A}A}AA:HAA:HA\  AAAA@G@Y@
=@G@G@
=A:HAA:HA@GA:H@
=A:HA:H@G@
=@GA:HA@G@
=@Y?=q?=q@Y@
=@
=?=q?=q?=q@
=AA@
=?
=@Y@Y\)    ?
=?
=?
=\)@Y?
=?
=@Y@GA:HA@
=@
=@
=@GA:HA:HA:HA\  A:HA:HA\  AAAB;zB333B"B\)BB	BBAAAABAAA\)A=qA}A}A\  AA\  A\  AAA}@GA}AA}A:HAA\  @G@G@Y@
=@Y@Y@
=@G@G?=q@
=@
=A\  A@
=A\  A}A:HA@G@GAA@Y@Y@
=AAA:HA:H@G@G?=q@Y@Y?=q?
=?=q@Y?=q@G\)?
=?=q?
=?
=?=q?=q?=q?=q?
=@G@
=A:HAA}AAA@GA:HAA\  AAA:H@GA:H@
=@GAAA@Y@
=A?
=@YA?
=@Y?=q@
=@
=@
=@Y?=q?
=    @Y?=q@Y\)@Y?=q\)?
=?=q@Y?=q@Y?=q?=q?
=?=q?
=\)@Y?=q?
=?=q?
=?
=@Y?
=?
=?
=?
=\)    @Y?=q?=q    ?=q?=q@Y@Y\)?=q@Y?=q    \)\)    ?
=\)    \)?
=\)    ?
=\)\)?=q@Y\)?
=\)    @
=?
=?
=?=q@
=?=q?=qA@Y?=q@Y@Y?
=?=q?=q?=q?
=    ?=q?
=?=q?
=?
=    ?=q\)@Y?=q?
=?=q?
=?
=?=q\)?=q?
=?=q?
=?
=?
=?
=@Y?=q@Y?=q@Y?=q?
=?
=@Y?
=?
=\)\)?=q?
=@Y@Y?=q@Y@Y?=q?=q@G?
=@Y?
=?
=\)    ?
=\)    ?=q\)            ?
=?=q                ?=q\)                \)\)?
=?=q@Y?=q@Y@G@G@G@
=@G@
=@
=AA@G@
=@Y@G?=q@
=@Y?
=@Y?=q?
=?
=?=q?
=@Y@Y@
=?
=    @Y?=q?
=\)?
=?
=\)    ?
=?=q\)?
=?=q\)\)@Y?
=@Y?
=?
=?=q?
=?
=\)?=q\)?
=?=q\)?
=@Y?=q\)?
=@
=?
=@Y@Y@Y?=q?=q?
=?=q\)?
=?
=\)\)    ?
=?
=    \)    @Y    \)\)    ?
=    \)\)?
=\)\)?=q@Y@Y?=q@Y@
=@GAA}A:HA\  A:H@GA:HA:HAA}A\  @
=A:HA@
=A@G@Y?=q?
=@Y@Y@
=?=q?=q@Y?=q?
=?
=@
=?
=?=q?
=@Y\)?
=?
=?
=@Y    ?
=\)    ?
=?=q\)?
=?
=\)\)\)\)\)\)\)            \)    ?
=?
=\)y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y ?=q?=qA\  y ?=qA\  y @
=Ay @YA\  y ?=qA\  y @YA=qy     y @YAy     Ay     Ay ?=qAy     A\  y     @Gy ?=q@Yy ?=q?=qy @Y?=qy A=q?=qy y     y y     y y ?=qy y     y y     y y     y     y y     y y     y y     y y     y y     y y ?=qy y     y y     y y ?=qy y     y y ?=qy y     y y ?=qy y ?=qBy     ?=qy @Y    y B*    y y     y y ?=qy y     y y     y y ?=qy y     Azy ?=q    y y     y y ?=qy y     y y     y y ?=qy     y y     @Yy A:H?=qy y @Yy y ?=qy y ?=qy y ?=qy y         y y ?=qy y     y y     y y     y y     y y ?=q    y y     y y     y y     y y ?=qy y     Ay @G    y y     y y ?=qy y     y y     @
=y y     y y     y y     y y     y y     ?=qy         y y     y y     y y     y y     y y     y y     y y     y y         y A}    y y ?=qy y     y y AA\)AAAAAzB	B{B{B333B*BL
=B\B\BTQB*B*B{AA}AAAAA\)B;zBL
=BTQBL
=BCBCB;zB	AAzA}AAA:H@GA@
=A@
=@
=@G?=qAAB	B	B"B{B"BCB;zBL
=B333B"B"AAA\  A\  AA:HA\  A:H@GA@Y@
=@
=BA:H@YA}A:HAAA}AA:HAA:HA:HA\  AA}AA:HA:HAAA=qAAA\)B{B{B{BB{B"BTQB\B}RB{B{BGBupB}RB  B#BGB#B  BGBupBL
=B*BBA\)A=qAAzA\)A}AA}A@GA:HA}A@GA:H@GA}A\  A}AA:H@GAAAA}@GA:H@G@
=A=qA:HA\)A=qAA=qA}AA}AA\  A:HA@Y@G@
=@Y@Y@G?=q?=q            @G@Y@
=A:HA:HA:HAA@GAA:H@
=@G@G@G@
=@
=A:H@GA:HAA}AAAB	BAB{B"B\)B	AzBBBB	BA=q@
=@
=A}A\  A\  A@G@
=@
=@
=A=q@G@
=?=q@Y@Y?=q?=q?=q?=q    @Y?=q        ?=q                        @YAA:HA:HA\  @GA@G@
=@Y@Y@
=@
=@
=@Y@Y@
=?=q        @G?=q@Gy C=qCO\A}AA@G@
=AAA@Y@GAAAA:HA}AAABB333BL
=B\)B\)BCB;zBCBTQBL
=BL
=B333B{B*B\)B	B*BdHBTQBL
=B;zB\B333BupBTQB;zB333B333B333BCB	B	A\)A=qAA:HAABAzB	B	AzAzA\)A=qA\)AAA}ABAzAzA\)A=qAAAA\)AA=qAAA}A:HAA\  A:HA=qA\)AA@
=A@
=    @
=    @
=@
=A@G?=qA\  @G@YAAA=qAA\)A\)AA=qA=qA\)A\)B{B"BCB\B#BGBpB  BpB{Bm(BTQBL
=B\BdHBm(Bm(BupBm(B}RBm(BL
=B	B"B;zAzA:H@GB;zB"B*AA\)ABB	B\)B{B{B	B"B	B	A\)AAAA}A:HA\  AA\  AA:HAAAA:HAA\)A\)AAAAAA\)BAA}A}A\  A:HA}A}AA@GAAAAAABA=qA=qA\  @G@
=@G?=q@G@G@GA:HA}AAAAAA\  A\  AAA@GAA\  AA\  A\  @GA:H@G@
=@G@GAA\  @Y@
=@
=?=q@
=@G?=q?=q@
=?=q                        ?=q@Y?=q@Y?=q@GA:H@GAA}AA}A:H@G@Y@Y@G@
=@Y@GA:HAA}A\  @YAA:HAA:H@Y?=q?=q@Y@Y    ?=q@Y@G@Y?=q@YA:HA@
=@
=@GA:HA=q@GA\  A}A}A}AAAAA}AAAA}A\)A}A:HAA\  AAAB	B*BTQB\Bm(BL
=B{B"B{BB\)B{B{B{B	B{B	B\)B{B	B\)AzA\)AA=qAA=qA=qAAzAA=qA=qA\)AAA}AAA\)A\)A=qAAAA}A\  A\  AA}AA}AA\  @
=A:HA\  A}A\  AA:H@GA\  A=qAA\  A}AA:HA}A\  A}AA\)AA=qAA\)B{A\)ABB;zBCBL
=BTQBdHBL
=BdHB  B\BL
=BL
=BCBTQB*B;zB"B"B{B	B	B{AzAAAA}A:HA}A:HA\  A:H@G@
=A@GAA@G@G@Y@Y?=q?=q    ?=q@Y@
=@
=@
=@
=@
=@
=A@
=@G@
=@Y@GA\  AA=qA:HA\  A:HA:HA:HA:H@
=@G?=q@GAz@YA\)B333B	A\)@
=B	A@GA:HA\  A:HA:HA:HA\  A\  AA}A=qAzAzBB{B*B;zBCB\B\BupBm(BdHBTQBTQB"A\)B*B	BAA\)AA}A\  @GA:H@
=@G@
=@G?=q@GA:HA:HA:H@G@
=@YAA:H@GA}A\  @
=@G@GAAA@GA\  @GA\  AAAAAA}@GAA:H?=q?=q@Y?=q    @Y@Y?=q@
=@
=@Y@Y?=q@GA@GAA:HB{B}RA\  A\  A\  A}A\  A:HA\  A}A\  AA:H@GAA:HA}AAAA=qAAB	AB	BAAzA\)AAAA=qA=qA=qAA=qAAAAAAA}A\  AAAAA@
=A\  @
=@Y@
=@Y@
=A@YAA\  A\  AA}A}AA}A}A\  A}A}A\  AA@
=A:H@
=@Y@
=@G@YA@
=AA:H@GAA=qA\)AAAAAA}A}AA}A\  A:HA:HAAAA}A}A}A\  A}A\  A}AAA\)B	B	AB	B	A}A=qAzB	A=qB	AAzBBAAAAA\)A\)A=qA\  A\  @GA\  A:HA\  A\  A\  A\  A}AA:H@GA:H@
=AAA\  A}A}A}A=qAA=qAAA\)AA\)AAAAA\)A}AAAA}A\  A\  A:H@
=?=qA:HA:HA:HAAAAA@G@G@Y@
=@
=A@G@
=@GA:H@
=A\  AAAAA=qA=qAB	A\)B	AAA\)AA=qAAA}A\  A\  @GA:H@GAAA=qAA}A}A=qAAA}A\  A\  A\  A:HAA:H@
=@G@G@
=@
=A@Y?=q@
=@
=@
=@Y@Y?=q@Y?=q@Y?=q?=q?=q                    @
=@
=@Y?=qAA:HA:H@GA@
=A\  A}AA}@Y@
=AAAAA:HA\  @
=@Y?=q?=q?=q?=qA@Y@Y@Y@
=AA:HAAA\  AA\  AA=qAAzBB\)B{B	B	B*B\)B{B\)B	B{BAzB{AzB\)B{AzABA}A=qAAA=qA}A}AAA=q@GA}@G@GAA}AA@
=BA=qA:HA}AA\  @GA:HA\  A}AA:H@
=@Y@
=@
=@GA:HA@G@
=A@
=@G@
=@G@Y@
=@Y@
=@GA:HA\  A\  @Y@
=A\  AA}AAA}A}A}AAA}A\  A\  A:HA:HA:HAAA\  AAAA\  A}AA}A}A}BAA\  B\)B*BCA\)AA\)A\)AAA\  A\  A}A\  AA:HA@Y@G?=qA@GA\  @G@
=@
=?=q?=q@Y?=q?=q@Y@Y    ?=q?=q?=q?=q        ?=q?=q    @Y@
=@G?=q?=q?=q@Y@
=    ?=q?=q?=q@Y@Y@
=@Y?=q@YAA@
=@G@G@GAAA:HAA\  AA@G@GAA@GA:HA:HA:HA\  A}AAAA\  A=qAAzA\)AzAzBBA\)AAzBB\)BAAAA\)A\)AA\)AA\)A=qAAAAAAAA\  A}AA\  A:HA:H@YA@
=@
=A}AA:HA\  A}@GAAA@G@G@Y@
=@Y@YA@G@G@
=@YAA:HA\  AAA:HA:HA:HAA:HAB{B}RB\B\)BA:HA\  AA\  AA\  AAAAA=qAB{B\)BB*B{B"B"B{B	AAzB\)B"B*B333BCB*B333B;zB\)B;zB*B*B"B{AzB\)AB{AAzB{BTQB;zB\)B{AzB	B{AzAzAA:HA\  A\  A:HA\  A:HA:HA@
=@
=@G@
=AA@G@G@G@GAA}A}A@
=A\  @GA@GAAA\  A:H@Y@Y@Y@
=@
=?=q@
=@G@
=A\  AzA:HA=q@
=A@GA:HA:HAAAAA=qAAzAA\)BB{AAB"BB"B	AA\)A\)B*B	B\)A\)BBBBAzA\)B{B\)B\)A\)AAAAAAA\)A\)A}AAAA\  A}A}A}A}A\  A\  AA:HA}A\  A\  A:HAA:H@
=A:H@GA\  A:HA:HAA\  A:HAA:HA\  A:H@GAA@G@G@G@G@
=@
=@GAA}A:HAA@G@GAA\  AA:H@GA:HA\  AA\  A}AA\  AAA=qA\)B{B\)A}A\)A=qA\)BA}BB	ABB	B	B{B*B"B{AB{AA\)A\)AzAA\)A}A\  @G@
=@Y?=q@GA\  A:HA:HA:HA:H@GAAA:H?=qAA@G@
=@G@
=@
=@Y@G@G@
=@
=AA@GA@YA@
=@Y?=q@YA:HA:H?=q@
=?=q@G?=q@
=@Y@Y@YA@G@Y@
=@GA:HA}A}AAA\  AAAAzB{B{B*B*B*B"B\BCBCB333A\)A=qA\)AzAA\)B;zBTQB"B{BCB\BTQBTQB\B;zB\Bm(B\)B"B\)B\)B{B{B\)B	AzAzBB\)B\)BAzAAA:HA}A\  AAAA:HA\  A\  A@
=@G@
=?=q    @Y@Y@GA:HAA:HA:HA\  A\  AA:HAA}A:HA}A\  A}A:HA:HA\  A:HA:H@
=A@G@GAA\  AA}AA=qBAzB{AzBAAA=qA=qA\)AA\)BCB333B333BTQB\Bm(BTQB;zB*B*B333Bm(BdHBm(BupB\)BCAA=qA=qA=qA}A\)A\)A\)AAA\  A=qA=qAA@GA\  A:HA:HAA:HA\  A:HA\  A:HA\  AAAA\)A=qA\)AA=qA=qAA:HA:HA}A\  A}A=qA}AA=qAAA\  A\  AA}A\  AAAAA=qAA}A\  @G?=qA\  @GA\  A:H@G@
=A:H@
=AA\  AA\  A\  A}AA}A:HA\  ABBA=qBBB{AzB	B"AzA\)AA=qAA=qAAAAAAAAA}AA:HA:HA}A\  y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y     @Y                                                                                    ?=q?=q?=q        ?=q    @
=?=q            ?=q            ?=q                ?=q                                                                                                                                                                                                ?=q?=q    @Y    ?=q?=q@G@GA:H    A@Y@YA}?=q?=q?=q        ?=q@
=@G?=q@
=?=q            ?=q        ?=q                                                                    ?=q?=q            @Y@Y@Y@Y?=q                ?=q            ?=q?=q    ?=q                            ?=q            ?=q?=q                                                                            ?=q?=q    ?=q    @
=A\  @GAA@G@
=@G@G@
=@
=@
=                ?=q?=q@G@G@G@
=@
=@
=?=q?=q        ?=q@Y        ?=q?=q@Y?=q?=q        @Y    ?=q@Y            @Y@Y    @Y@Y?=q@
=@Y@Y?=q    ?=q?=q?=q                                                                ?=q            @Y            ?=q    ?=q                ?=q@Y@G@
=@Y@G@
=?=q@
=@
=@G@
=?=q@G@
=    @Y            @Y@
=@
=?=q@Y@
=@Y?=q?=q    ?=q?=q                                                @Y                                                @Y    @Y@G@
=?=q?=q@Y@G@G@
=@Y@G@GAAAA@
=@
=@
=@G@GAA\  @YAAAAA@G@G@GA@GA@Y@G@
=@
=@Y@
=@
=@Y@G@G@
=@
=A:HA:HA\  A\  A}A}A}A:HAA}A:HA:HA}A}A:HA}A}AA}A}A:HA:HA\  A:HA\  A:HA\  A\  AA}AA:HA}A}A\  A\  A}A}AA:HA\  A\  A}A:HA:HA}A\  A}A}A\  A\  A\  A:HA\  A:HA}A\  A\  A:HA:HA:HA:HA\  A:HAA:HA:HAAA@
=A@
=@G@
=@
=@Y@
=@
=@
=@Y@Y@
=?=q?=q@
=?=q@Y?=q@Y@
=                @Y    ?=q?=q?=q    @
=?=q?=q@Y?=q    @Y?=q@
=    ?=q@Y@
=?=q?=q?=q        ?=q            @Y?=q?=q?=q?=q@Y        ?=q?=q?=q?=q?=q?=q@Y?=q?=q?=q?=q@Y@Y        @Y?=q    ?=q?=q            ?=q?=q        ?=q?=q                    ?=q?=q                                    @Y        ?=q?=q@Y?=q        ?=q@Y?=q    ?=q        ?=q    ?=q@Y@Y?=q@Y    ?=q@Y?=q    ?=q@Y@
=@Y@
=@
=@G@
=@G@
=@Y@Y@G@
=@
=@
=@G@
=@
=@G@Y@G@
=A@
=A@G@G@GAAA:H@GAAA:HAAA@GA:HAA:HAA\  A:HA:HAA\  A:H@GA:HA:HA\  A\  AA\  @G@
=A}A}A@G@G@
=@G@
=@G@G@G@
=@
=@G@Y@
=@
=@G@Y@
=@Y    @Y@
=@
=@Y@Y@G@G?=q@Y    ?=q?=q@Y@Y@Y@Y@
=@
=@Y?=q@Y@Y?=q    @Y        ?=q@
=@Y@Y?=q@Y    @Y?=q?=q?=q@
=@Y?=q        ?=q    ?=q@Y        @Y?=q?=q    ?=q                ?=q                    @Y?=q    ?=q?=q?=q        ?=q    ?=q?=q@Y@Y?=q?=q?=q@Y@Y@Y@Y?=q?=q@Y@
=?=q?=q?=q?=q?=q    ?=q?=q?=q    ?=q?=q?=q        ?=q                            ?=q    ?=q?=q?=q            ?=q        ?=q        ?=q    ?=q                        @Y?=q                                        ?=q                                                                            ?=q                    ?=q        ?=q    @Y                        ?=q?=q    ?=q                                                                                            ?=q                                ?=q@Y@Y?=q    @Y?=q?=q@Y?=q@Y?=q@Y?=q@Y@
=?=q@
=@Y@
=@Y@
=@
=@
=@G@Y@
=@
=@
=@G@G@G@
=@Y@Y?=q    @
=?=q@
=@Y@Y?=q    @Y?=q    @Y@G?=q    ?=q?=q?=q@
=    ?=q        ?=q?=q                                ?=q        ?=q                                        ?=q    ?=q        ?=q                                ?=q?=q    ?=q                                                        ?=q                                                                                        ?=q                    ?=q                ?=q            ?=q?=q    ?=q                            ?=q    ?=q@Y    ?=q?=q?=q?=q    ?=q?=q?=q                                                ?=q                ?=q                                                                                                                ?=q    ?=q                    ?=q                        ?=q        @Y?=q@Y    @
=?=q@Y    @
=@
=@Y?=q@
=@Y@
=@
=@Y@G@
=@
=@Y@G@GA:H@
=@
=AA@
=@
=@Y?=q@
=@
=A@G@
=A    @Y@Y    @Y@
=@Y@Y@Y?=q@Y?=q@Y@Y    @Y                ?=q?=q?=q?=q?=q@Y?=q                                                                    ?=q                                                                        ?=q        ?=q    ?=q    @Y@Y@
=?=q?=q@G@
=@G@
=@Y@GAA:HA\  AA:HA:HA@GAA:HA:H@GAAA?=q            ?=q@G@G@Y@Y@Y@
=?=q@Y?=q@Y@G    ?=q                                    ?=q                    ?=q?=q            ?=q                            ?=q?=q?=q?=q                                    ?=q                    ?=q?=q?=q@
=@G@G@G@
=@G@G?=q@Y@
=@Y?=qA@
=@Y?=q?=q@
=?=q@Y@Y?=q    @Y@G@G@G@G@
=@
=A@G@Y@Y?=q@Y?=q@Y?=q@Y@Y@
=?=q    @Y            ?=q@Y    ?=q        ?=q        ?=q    ?=q    ?=q                                                                                                    ?=q                            @Y        ?=q?=q?=q@G@G@Y@
=@Y?=q@
=@
=?=q@G?=q?=q?=q    @Y            ?=q?=q                                                                                                ?=q    ?=q                                                                                                                                                        @Y    @
@p@\)@G@G@G@@  @{@Q@z@R@
@Q@p@  @=q@߮@=q@\@@@@H@@ᙚ@@ᙚ@
=@߮@Q@z@@@z@@޸R@{@@
@ڏ\@@H@H@@ff@\)@׮@׮@@\)@
=@{@  @@ָR@ٙ@
@33@{@@(@ۅ@
@H@=q@\)@{@  @
=@p@ָR@ָR@  @
@33@ٙ@H@=q@
=@ָR@\)@\)@\)@@  @@H@H@
@@ff@
=@޸R@߮@\)@޸R@\)@߮@  @  @@ᙚ@ᙚ@@=q@@{@@z@@@@@p@
@33@33@H@z@@33@R@33@ff@@=q@H@Q@߮@{@߮@z@@@@ff@p@@z@{@޸R@ۅ@
@H@=q@߮@߮@ff@ff@ff@@p@
@p@(@@
@H@=q@=q@@@ٙ@@G@33@
@@
=@ٙ@@أ@ڏ\@G@G@@ۅ@@@߮@{@߮@@p@޸R@߮@@G@@ᙚ@  @H@p@(@G@Q@@R@ff@ff@@@G@G@@H@\)@陚@@G@33@R@33@@
@\@@
@\)@R@  @
=@(@޸R@{@޸R@\@\)@Q@\)@p@
=@߮@
@@p@ڏ\@G@ٙ@H@=q@
@=q@=q@G@@G@@
=@(@@(@(@
@z@@@
@  @ָR@p@أ@ۅ@(@p@@=q@@  @@=q@
=@{@
=@
=@ff@  @@@@\@@G@\@@ff@Q@G@G@=q@33@H@
@z@{@\)@@@Q@\)@@@@  @@  @  @z@\)@@  @@ff@\)@
@G@  @ff@
=@@z@(@(@
@33@@@H@z@z@=q@z@
@@\@߮@33@@\@  @G@  @=q@=q@33@
@z@@z@@=q@=q@ᙚ@߮@G@@G@@=q@=q@@
=@\)@@R@ff@
=@{@z@z@@R@p@@@@@@  @33@\)@Q@@H@{@@@@@(@@
=A (AA A A Aff@@{A   A=qAGApA(@pA@R@R@\)@\)A AA   A A z@z@p@(@G@@@Q@p@@ff@@@H@@
@z@z@33@\)@\)@  @33@33@H@
@@@\@@\@
@@(@@H@=q@=q@=q@G@ᙚ@@33@@ff@p@Q@{@@@@@陚@Q@\)@{@
@{@  @33@@33@@R@@z@@
@@@ff@@{@R@p@  @  @
=@  @  @{@@{@\)@{@p@@{@@p@z@
@@@@z@\@(@G@H@\)@@{@@@@ff@@Q@@33@@@  @G@=q@Q@Q@
=@ff@ᙚ@=q@ᙚ@G@޸R@p@
@ۅ@ٙ@H@@@
@ff@
@(@(@ۅ@z@p@{@@ڏ\@H@(@ָR@
=@\)@Q@\)@Q@ָR@ٙ@G@@33@@
@z@@z@@@(@@@  @Q@G@@H@G@@@p@@陚@G@@@@Q@  @@\)@陚@@@@@\@=q@H@G@  @@@@z@@G@G@Q@G@@@أ@ff@33@@޸R@G@@\)@@ff@@@Q@ٙ@=q@(@(@33@Q@ff@\@Q@Q@33@G@{@@@\@\)@R@R@Q@@@p@@z@H@ᙚ@G@G@ᙚ@@H@(@  @  @@\@陚@z@R@\)@@(@
@H@@@R@@=q@@
@\@Q@@p@\@\@(@@@陚@\@G@@@z@@33@33@
@H@H@G@@@G@@@@@@ᙚ@H@z@@33@=q@@{@H@\)@
@ᙚ@  @  @Q@  @@@أ@Q@أ@
@ۅ@H@ٙ@ٙ@@ۅ@(@
=@{@@ff@\)@(@p@߮@=q@G@Q@ᙚ@Q@
@(@G@ff@33@@z@{@H@陚@@p@\)@@@
@@@@\)@G@=q@\@33@@H@\@(@33@@R@=q@G@G@@Q@@z@\@@
=@@  @R@p@@@ff@\)@R@
=@ff@p@p@ff@@ff@@z@@@
@@@33@
@@33@@@@@33@H@33@@33@
@\@\@@@
@
@@@@@{@Q@@@(@(@p@R@{@R@@\)@Q@\@33@(@@ff@@@@@\@@
@z@33@@(@R@
@p@R@
@(@@@{@@ff@ff@
=@@{@{@=q@H@
=@
=@ff@p@@G@  @ff@@@Q@@@@@{@  @\)@  @Q@{@陚@@@
@R@@\)@ff@p@(@@33@(@
@@G@=q@@Q@@=q@Q@\)@ff@@@(@@H@{@
=@@=q@33@(@(@H@=q@H@(@H@33@@\@@@@G@
@@ff@R@  @@@ff@R@{@@@\@
=@p@p@@\)@  @  @R@\)@@ff@@@=q@=q@@
@@@\)@
=@ff@  @\)@R@@H@G@@
=@Q@R@@@\)@@  @(@@=q@@@=q@陚@G@  @Q@@G@@Q@陚@@G@陚@33@@@G@{@z@@  @H@
@33@@
@陚@@陚@z@@@{@@@
=@@陚@@@\)@  @=q@@@G@陚@33@@@@@@p@=q@@33@
@@@(@陚@=q@=q@H@Q@ff@
=@@=q@@\)@\)@@޸R@@z@޸R@\)@
=@@Q@33@ۅ@@@@{@\)@ff@@@33@\@ᙚ@ᙚ@H@z@=q@@ᙚ@=q@Q@\@ff@z@=q@\)@p@@@
@33@H@G@  @׮@\)@\)@\)@׮@Q@أ@أ@Q@  @׮@
=@׮@׮@@أ@أ@G@׮@@أ@Q@G@ٙ@@H@H@ڏ\@H@ڏ\@ڏ\@@33@ۅ@33@
@
@33@G@@=q@ٙ@ڏ\@أ@G@@ٙ@33@33@ۅ@
@33@G@33@ٙ@=q@G@@(@љ@@@p@
@=q@@θR@Q@У@У@љ@G@33@z@(@G@У@@G@Q@
=@@@
=@@{@˅@\)@θR@(@@@Ϯ@@  @
@{@  @p@(@
@Ӆ@Ӆ@
@@p@@\)@Q@أ@G@أ@G@@33@
@33@
@(@@@33@33@
@@(@@@z@@\)@@\)@\)@Q@(@@p@
@
@33@ۅ@G@أ@@  @ff@أ@H@@{@@@
=@{@33@ٙ@@ٙ@@ٙ@أ@G@أ@
@H@ڏ\@@@@
@@߮@@ٙ@@  @{@z@
@z@=q@Q@  @@
@@=q@
@ڏ\@ڏ\@=q@33@H@=q@ٙ@@=q@ڏ\@ڏ\@H@=q@ڏ\@G@@ٙ@ٙ@ٙ@G@أ@G@ٙ@H@H@
@z@@
=@  @@G@@H@z@{@
=@@\)@  @Q@G@@@@@33@33@@ff@@ff@@@R@=q@@ᙚ@@ff@@@@{@{@޸R@޸R@޸R@\)@\)@  @ff@ff@{@@@H@=q@
@ۅ@ٙ@
=@G@G@H@33@ٙ@@Q@Q@׮@
=@Q@ff@ָR@ָR@Q@\)@أ@׮@G@33@@߮@  @@@(@@@@@@ff@R@
=@\)@G@陚@陚@H@@  @G@\@@G@=q@
@@@(@p@@p@\)@@{@{@(@@@@@ff@{@R@Q@
@(@=q@=q@33@@ff@@@=q@@\@{@ff@@33@
@@=q@@\@=q@{@\@  @\)@
=@{@@(@@@@@ff@޸R@  @@{@{@H@  @@@@R@ff@
=@
=@z@H@@@Q@@ᙚ@@=q@@\@@(@
@@@\)@
=@@\)@
=@@  @Q@@Q@(@{@\)@G@(@陚@  @@@Q@@H@@  @=q@@  @陚@@@G@
=@@\@\@(@
@G@@\@z@@
@\)@  @@ff@@@Q@p@@z@@
=@33@33@
@p@{@@p@{@=q@{@@@@陚@(@@33@@@ff@@@@@@@H@@R@@z@@=q@  @ᙚ@@(@{@@R@@
=@\)@  @G@@@@@  @  @@@@@@Q@Q@Q@Q@Q@@=q@H@@@G@@Q@  @Q@Q@@R@@@@陚@(@p@@@(@@@
=@  @@@@@
@=q@G@\)@\)@\)@\)@
=@R@@@{@{@@{@p@
@{@@z@(@
@R@
=@G@33@陚@=q@@
=@G@陚@陚@Q@
=@  @G@@G@G@@\@=q@=q@@
@\@z@@@@@R@\)@@ff@@@
=@33@H@Q@@=q@@@@@@(@(@@@@@  @@R@R@@\)@{@\)@@\@@  @@{@Q@z@R@
=@  @{@\)@Q@  @@@z@G@陚@  @  @R@
@@
=@G@@@@@\)@p@@p@p@@ff@p@ff@ff@ff@@@@Q@Q@ff@@\)@  @@@R@@Q@Q@Q@Q@H@@Q@陚@(@@\)@  @\)@z@ff@{@@(@@@R@@@  @@ff@Q@  @@
=@@@@p@ff@(@
@Q@
@陚@H@=q@H@Q@陚@@ff@\)@\)@ff@{@陚@=q@@G@@@33@33@p@@p@{@z@z@=q@@@G@ᙚ@@@H@@33@=q@\@=q@ff@@
=@
@
@@ᙚ@(@G@ᙚ@޸R@
@p@p@{@{@޸R@Q@ᙚ@Q@@H@@=q@H@33@@=q@ᙚ@@p@陚@@Q@\@@陚@Q@\)@R@H@陚@@{@G@@@Q@@@@@@{@@R@33@p@p@R@@
@@@@Q@Q@{@
@z@R@R@@
=@Q@@\)@@@\@  @
=@G@=q@@H@\@
@@  @
=@ff@޸R@
=@{@@
@ڏ\@ڏ\@@p@\)@ڏ\@\)@
@33@@=q@(@@@ᙚ@A	A@Q@Q@R@G@33@\)@{@
=@
=@Q@  @@@@@@(@
=@G@  @G@陚@陚@G@\@@\)@H@@=q@@H@@(@H@z@
@(@H@@z@@@ᙚ@@G@  @\)@
@ۅ@@@@{@\)@޸R@ff@{@{@ff@ff@@33@H@ۅ@H@߮@޸R@ᙚ@ᙚ@ff@@\)@@33@@@߮@=q@ᙚ@߮@߮@
=@ff@\)@\)@@Q@  @ᙚ@R@@Q@ff@z@@@@=q@33@=q@
@@ff@\)@R@ff@@@@(@@@
=@R@@@R@{@Q@@陚@R@Q@
=@@R@{@p@p@
@p@(@Q@@ᙚ@H@@@\@@@
=@ff@@\)@\)@@ff@ff@{@@ff@R@ff@߮@\)@\)@@@z@@@z@R@z@(@@@@@@p@
=@ff@陚@陚@@=q@G@p@@(@\@H@陚@33@陚@=q@陚@@@{@{@\)@陚@
=@G@@
=@Q@@\@@@G@
=@R@\)@@@G@(@z@@@@@@Q@@\@\@@
@@=q@@H@z@G@Q@@p@@@@
@{@@z@@\)@@
@=q@z@@\)@R@@@@R@@
@
=@G@@H@@@\@ff@R@=q@@\)@陚@H@  @z@@@R@@{@R@
=@  @@@H@G@@@@G@@@  @=q@G@G@ff@@
A
=AA
@=q@R@A\A   @@ff@=q@R@Q@=q@\@@=q@ff@=q@H@@33@@H@H@p@G@33@33@@z@@陚@@@@Q@@
@33@@@(@\)@@\)@@
@@33@\@@@@@@(@Q@=q@{@  @ff@Q@R@=q@33@G@\)@ff@陚@G@@@
=@
@{@\)@@33@@H@\@{@Q@
=@@z@p@@@
=@{@ff@  @H@@@
@33@
@z@@@@
=@R@p@R@@R@
@@33@@{@
@޸R@p@R@(@ᙚ@  @@@@H@H@@@@\)@G@\A AG@(@QA A\@@H@R@@R@@H@@
@
@@@G@@@@G@@@=q@=q@G@33@@33@@@ff@ff@  @陚@@@@\@(@p@@@@@H@  @=q@@=q@@p@p@p@@\)@@@G@@(@\@33@G@\@\@\)@
@@@z@z@33@G@=q@@@\@陚@@@@=q@R@33@@Q@p@G@@@@@Q@@@@  @R@@Q@
=@
=@{@p@
=@@@\)@
=@@p@@
=@\)@R@
@@
@{@  @
=@@@\)@@  @@Q@@(@@
=@@@@@ff@{@@\)@z@@@
=@
=@@@@@@H@H@33@33@33@@@@33@=q@\@(@
@(@
@R@@p@@z@\@@@\)@@@\@\)@R@@Q@@@=q@陚@@@
=@ff@z@H@\@
@z@
@@H@H@\@@@(@@(@@@
@z@@z@@=q@=q@@陚@z@Q@@@ff@ff@\)@p@Q@ff@{@{@\@z@@  @@@
@H@
=@  @@@
@p@
=@=q@33@(@
=@33@A @A   @{@RA @p@@z@@H@@=q@33@R@ff@@
=@@33@@
@  @H@  @@
@@R@@@z@H@@\)@@@=q@R@Q@
=@=q@z@@
=AGA@@(@@@@Q@@ff@@\@H@G@  @陚@@33@@z@@z@{@\)@R@@@@@@(@=q@\@(@@R@33@@R@ff@@@R@  @
=@\)@@@=q@33@33@
@@ffA QApA @@ffA   A   @
=A QA A zA
ffA
HA
=A
HA	pA33A{@(@@@ff@  @A33AffAHA @\)@@ff@@@@\)@@33@@G@=q@@  @33@@@33@@@=q@G@@@=q@@{@Q@G@\)@@Q@
=@@
=@  @@@
@@\@@G@@=q@\)@G@ᙚ@
=@{@Q@@@Q@
=@@(@33@=q@H@(@H@33@z@@@p@@p@{@{@{@{@ff@  @ff@{@p@@@@@@@@
@(@H@@@@G@
=@@\@@=q@陚@=q@@\)@33@ff@Q@=q@z@
@\@=q@陚@@\@@@@@(@@=q@@p@ff@@@(@
=@@Q@@33@@Q@@@H@
@\@
@\@@@陚@\)@p@@R@Q@@Q@@@z@@p@{@ff@{@ff@@(@=q@@
@  AH@@G@p@H@\)@z@(@p@(@
@@(@(@(@=q@@@  @G@Q@=q@\@H@@陚@G@G@G@@@@G@@=q@陚@(@@p@Q@\)@@
=@R@33@@p@A   @
@@=q@=q@G@@=q@
@\@HA z@@=q@@(AAApA@\@@  @@33@p@G@G@\)A
A
AAAA"ffAA	pAA(A(AA\)AA   @{@R@
=A A\AffA @RA A   AffAAA
=A
=AffAHA zAffA @@@@
=@@@\@H@\)@33@@(@@
@@z@Q@=q@H@@@@H@@G@H@=q@z@z@33@\)@@p@{@  @@@H@@\)@{@p@@\@H@
@Q@33@@@{@@=q@@33@@ff@@R@@
@(@陚@  @\)@\@@H@33@@@RA AA\A
=AHAAHA	AzAAA A(AQA@(@H@R@
@@@{@\)@\)@@@@(@@@R@(@\)@  @@@\)@ff@{@ff@߮@߮@G@޸R@G@ᙚ@@\)@@@@陚@陚@=q@@\@@@
@ff@{@ff@33@(@z@(@33@33@@
@H@33@@@H@
@@33@G@ᙚ@ᙚ@@{@p@
@@
=@@@@G@\@@@@
=@  @G@\@R@\)@{@H@@@
@
@
@
@p@@
=@@=q@@R@@=q@Q@Q@H@z@@=q@  @@@
=@@@@=q@
@R@@@
=@@R@\)@陚@
@33@@{@@@p@@\)@33@@\)@\@陚@H@@Q@ff@
@G@
=@  @  @
=@\@(@\)@@=q@@(@\@33@
=@z@@@@@陚@@@
@{@@ff@@@\)@@@p@@p@@@=q@@  @R@@
=@ff@{@z@\@\)@R@@R@p@@p@z@ᙚ@\@\@\)@H@{@@(@z@(@p@@R@{@ff@{@R@@z@
@@@@߮@@@@33@{@{@=q@޸R@@Q@߮@(@أ@z@H@G@@@33@ٙ@33@ۅ@z@p@@@@p@@޸R@Q@
=@ff@@(@(@@@{@\)@  @@=q@\@
@z@R@{@z@\)@
=@
=@@@@@@G@@@@@G@H@=q@=q@@@@G@\)@@  @ff@@33@@R@=q@\@33@  @@ff@@@ff@߮@  @߮@  @޸R@Q@߮@Q@\)@@{@@޸R@  @@p@(@p@Ӆ@p@G@H@ۅ@=q@@Q@\)@  @أ@׮@ָR@@@@@׮@@G@@G@ڏ\@33@z@@ff@޸R@
=@߮@  @  @߮@\)@\)@
=@޸R@
=@
=@߮@  @Q@Q@@Q@  @@H@@H@H@@@ᙚ@ᙚ@G@@@@ᙚ@H@@߮@޸R@
=@\)@p@޸R@޸R@\)@
=@@@z@
@(@z@ۅ@=q@ۅ@
@ڏ\@
=@׮@p@ff@ff@\)@p@@p@ff@{@׮@
=@Q@أ@ָR@p@
=@p@ff@@{@{@@׮@@ָR@׮@Ӆ@أ@ڏ\@  @z@@@
=@=q@ڏ\@׮@
=@ָR@p@{@ָR@љ@@@
=@У@ҏ\@(@(@G@@33@׮@  @@@@ָR@Ӆ@{@ٙ@@\)@p@(@(@
@@p@ff@{@׮@  @ָR@@׮@G@׮@
=@\)@\)@ff@Q@  @أ@أ@  @  @\)@ָR@\)@׮@  @  @  @  @׮@\)@ָR@  @  @
=@\)@@@
@@
@33@  @{@Ϯ@ҏ\@
=@{@z@  @Ϯ@Ϯ@ff@\)@ff@z@  @\)@Ϯ@  @Q@Ϯ@@(@˅@{@Ϯ@Q@У@Q@Q@=q@
@33@Ӆ@
@ҏ\@ҏ\@H@ҏ\@33@H@@@p@
@z@p@(@{@
=@@ٙ@ڏ\@@
@
@ۅ@@@\)@Q@@أ@  @\)@ָR@  @أ@ff@
=@{@z@Ӆ@ҏ\@(@@p@@33@@@@@@@@z@(@Ӆ@Ӆ@33@33@=q@ҏ\@=q@H@
@@
@(@Ӆ@Ӆ@Ӆ@љ@G@=q@
@z@z@Ӆ@Ӆ@(@(@ҏ\@ҏ\@=q@33@H@@(@Ӆ@ҏ\@љ@@ҏ\@H@33@Ӆ@ҏ\@H@@{@@\)@׮@ff@@p@@ff@@{@{@أ@@ff@
@ָR@{@Q@Q@G@G@@
=@@  @Q@=q@ٙ@ڏ\@=q@@G@@G@Q@@{@@׮@p@H@Ӆ@33@׮@
=@\)@׮@
=@ff@@ҏ\@@
=@
=@љ@33@@ҏ\@Ӆ@
=@Ӆ@Ӆ@p@Ӆ@љ@У@  @{@\)@@{@
=@
=@{@@=q@@\)@G@G@@У@\)@@p@˅@@Ϯ@  @Q@Q@G@љ@У@@У@  @Ϯ@Ϯ@  @  @@@=q@ҏ\@H@
@@@ff@=q@ۅ@H@@=q@@G@G@@  @@\)@أ@G@@@=q@@Q@  @׮@ָR@ָR@{@
=@׮@G@
=@ff@
=@
=@{@ҏ\@Ӆ@ָR@
=@ff@\)@z@(@
@љ@\)@  @љ@@=q@љ@љ@H@33@  @\)@Ϯ@ff@  @@ҏ\@Ӆ@Ӆ@=q@z@33@z@(@p@{@p@H@(@@\)@׮@@G@أ@أ@Q@G@=q@ڏ\@ٙ@@G@Q@أ@\)@ٙ@أ@G@ٙ@H@(@z@@@{@@
=@  @{@{@@
@H@=q@@أ@׮@G@أ@@  @\)@\)@أ@@Q@@  @Q@\)@  @\)@  @G@׮@أ@\)@׮@@ff@{@{@\)@  @{@
=@@\)@@ff@Q@
=@
=@{@أ@
@33@@
@@Ӆ@@@33@(@ff@(@@@@ff@ff@@p@{@ָR@׮@ڏ\@@z@(@
@
@
@
@(@(@(@
@@@@  @޸R@33@33@
@@(@{@ff@@@H@z@(@33@@Q@Q@\)@@ff@p@@@@z@ۅ@ٙ@أ@=q@@G@=q@
@(@=q@
@ٙ@(@H@@@z@(@p@(@\)@{@@(@p@p@(@ڏ\@
=@\)@  @z@@ff@@@=q@أ@@Q@  @ָR@ָR@  @G@=q@
@@ۅ@@H@ٙ@@أ@أ@أ@H@33@(@(@ۅ@ڏ\@@ٙ@ٙ@=q@33@33@z@(@z@@p@@@p@p@@
=@޸R@33@z@33@@=q@@=q@=q@ᙚ@\)@޸R@  @Q@߮@
=@@@@@
@p@@@p@ڏ\@ڏ\@33@33@33@=q@@Q@@@=q@H@=q@@@أ@ڏ\@z@@=q@
@ۅ@(@@(@  @\)@Q@@
=@
=@G@Q@@p@ff@{@أ@\)@ff@
=@ָR@
=@ָR@
=@\)@׮@\)@ff@@
@33@33@H@33@Ӆ@@{@ff@
=@׮@ٙ@33@33@ۅ@
@
@z@(@z@(@@G@@ᙚ@߮@  @  @
=@\)@\)@޸R@{@޸R@@@z@@(@@@ۅ@33@H@33@ڏ\@H@H@ۅ@H@ۅ@ڏ\@=q@أ@=q@@H@33@أ@@ڏ\@@@ٙ@ٙ@G@أ@ٙ@G@أ@أ@Ӆ@Ӆ@z@p@ff@
=@\)@ָR@ָR@ff@@@z@(@@(@z@@@@{@@{@ff@{@{@@@p@p@@ff@
=@\)@׮@  @Q@أ@  @أ@أ@G@G@G@@@
@ٙ@33@(@(@33@(@@ff@
=@@ڏ\@@33@@Q@33@ۅ@ٙ@33@ڏ\@@=q@ڏ\@G@G@=q@ڏ\@@=q@ٙ@Q@ڏ\@G@Q@\)@ff@(@(@z@Ӆ@z@Ӆ@Ӆ@33@
@
@@@z@=q@G@=q@Ӆ@
@{@@p@p@@p@p@{@z@z@@@p@@@Ӆ@=q@ҏ\@ҏ\@@@{@\)@  @أ@Q@أ@  @ڏ\@ٙ@أ@G@(@33@ڏ\@H@ۅ@@z@(@p@@@  @߮@Q@\)@G@  @{@߮@@@\)@@=q@ٙ@׮@p@ٙ@\)@ָR@@@أ@
@أ@  @@ڏ\@ڏ\@G@@ٙ@أ@ڏ\@@@{@أ@ָR@׮@@ָR@{@\)@\)@\)@p@{@
=@H@H@H@Ӆ@=q@=q@ҏ\@@@\)@ָR@@(@
@z@Ӆ@33@@Ϯ@@@z@ff@
=@  @
=@
=@  @  @  @ٙ@ڏ\@H@ڏ\@ڏ\@33@@ff@@z@z@@H@H@(@  @@@(@߮@@33@ۅ@
@ff@@{@@p@33@ۅ@޸R@޸R@ff@@
@z@z@@z@@33@z@(@
@
=@@=q@׮@׮@ff@@z@׮@G@\)@\)@@
@θR@{@@θR@{@{@Ϯ@33@
@
@{@\)@@ҏ\@z@H@p@{@Q@\)@@33@Ӆ@ҏ\@
@H@
@z@(@@@
@љ@Ϯ@=q@(@z@@  @  @Q@@=q@H@(@@@{@{@@  @
=@\)@ff@=q@޸R@G@޸R@ᙚ@Q@
=@\)@@  @ff@H@33@
@
@@(@(@(@33@H@=q@@ٙ@  @\)@أ@=q@H@@@G@ָR@G@@Q@@{@Q@@@@ٙ@ٙ@G@=q@G@G@G@@p@p@@ff@G@@{@
=@@@@H@@@ff@ָR@@\)@
=@ָR@\)@
=@
=@
=@{@׮@@ٙ@(@@(@p@p@@ff@ff@
=@
=@\)@\)@  @  @Q@@  @@  @\@ᙚ@@33@=q@\@
@@33@ᙚ@@ᙚ@@@Q@Q@\)@Q@޸R@߮@Q@Q@߮@@ff@  @߮@
=@{@p@@@p@ff@{@ۅ@p@߮@߮@
=@@@
@z@=q@@33@ۅ@ٙ@@@@أ@@@@@@H@G@=q@@G@ٙ@أ@
@@(@@ۅ@H@@ڏ\@@@p@@H@ۅ@޸R@
=@
=@\)@߮@@Q@@ᙚ@ᙚ@ᙚ@ᙚ@ᙚ@޸R@Q@ᙚ@G@޸R@ᙚ@@=q@@@z@\@@=q@ᙚ@G@ᙚ@G@@@  @Q@  @߮@
=@ff@ff@{@@@@@ff@@=q@{@p@@@@ۅ@
@@
@ۅ@(@
@
@
@أ@z@(@׮@  @׮@׮@  @׮@׮@\)@׮@  @  @ڏ\@  @
=@H@@׮@G@33@
@@@@@p@{@ff@{@ff@{@(@@{@ff@
=@߮@޸R@\)@ᙚ@ff@=q@=q@{@ff@ff@{@\@@@=q@G@\@=q@ᙚ@ᙚ@@\@G@@@
@H@@ᙚ@@G@G@ᙚ@  @@G@@@޸R@Q@߮@\)@
=@ff@ڏ\@@z@(@
@H@z@@(@
@z@
@(@H@H@33@@G@  @(@Q@Q@أ@أ@  @ff@{@ff@
=@ff@@أ@׮@=q@@@p@(@
@{@(@@ۅ@{@ff@@ff@ff@ۅ@
@(@@@@ff@ff@ff@޸R@\)@߮@߮@@ᙚ@G@=q@G@H@
@z@z@(@@p@@z@@\@G@߮@G@\)@
@
=@޸R@
=@
=@޸R@ff@޸R@޸R@{@ff@ff@ff@@޸R@@{@(@
@@{@{@{@
@
@
@z@(@@z@33@  @\)@\)@  @\)@  @׮@أ@أ@׮@أ@ۅ@ڏ\@
@
@ۅ@33@
@ۅ@ۅ@p@@33@(@z@(@{@@
=@z@
=@
=@(@@Q@@ᙚ@=q@=q@H@\@(@(@H@@
@\@{@ᙚ@@G@
@
@
@=q@(@33@H@=q@H@\@Q@  @\@=q@z@@\)@z@H@G@33@@p@@R@@
=@\)@G@
=@Q@@G@\@@33@R@ff@\)@(@@z@
=@{@{@p@{@
@Q@
=@߮@@ᙚ@G@޸R@\@\@ᙚ@(@@33@@߮@@\)@\)@޸R@߮@@ᙚ@ᙚ@ᙚ@G@\)@޸R@Q@=q@@\@@
@(@p@{@@  @p@@Q@p@
=@p@z@@@@ff@ff@ff@R@H@(@H@
@@@p@z@@
@
@ff@
@
@@z@@ᙚ@
@(@H@@@(@@H@ᙚ@Q@\)@߮@߮@
=@
=@@{@G@\)@(@  @{@ڏ\@أ@  @ff@@{@\)@ָR@\)@
=@@p@H@љ@
@z@
=@@p@׮@@p@ڏ\@z@ۅ@33@@ٙ@
@@@@@ٙ@33@z@p@{@\)@  @  @޸R@@޸R@߮@
=@@@\)@G@H@z@Q@  @  @
=@
=@z@p@ff@z@(@33@ڏ\@@=q@G@33@=q@ۅ@
@ٙ@=q@H@G@33@@=q@33@H@=q@=q@=q@H@=q@ڏ\@أ@׮@
=@׮@أ@׮@׮@׮@=q@@=q@ڏ\@Ӆ@@
@ff@{@أ@@\)@@Q@أ@@׮@@=q@ٙ@׮@
=@@@@@(@(@ۅ@p@
@ٙ@ڏ\@33@p@
@@@p@߮@
=@Q@@ff@ᙚ@߮@
=@ff@  @ff@@{@ff@@\@=q@33@H@H@\@\@G@Q@Q@@ff@ff@޸R@ff@
=@ff@{@ۅ@@{@@@@{@(@޸R@@޸R@{@ff@@{@޸R@޸R@
=@@{@@p@p@@ff@@
=@@
@@@ٙ@ٙ@=q@ٙ@@@ۅ@z@H@(@
@ff@@z@@33@޸R@@@޸R@\)@
=@\)@\)@\)@  @߮@Q@@@
@  @߮@Q@@@@Q@@@@H@@Q@
@@@@@ff@@@@\)@@@{@
@@H@=q@@@ᙚ@=q@Q@ᙚ@G@H@@=q@ᙚ@G@ᙚ@ᙚ@@ᙚ@=q@ᙚ@@=q@H@@p@@33@H@@@@Q@@Q@(@
@z@@
@ڏ\@ڏ\@ڏ\@
@
@H@33@H@ۅ@z@@޸R@{@
=@
=@ff@@\)@@\@@G@  @  @Q@@=q@G@p@=q@=q@H@{@H@H@33@=q@\@\@\@\@H@\@H@H@
@
@p@(@@@(@@R@H@(@z@33@\@H@@p@
@33@G@G@ᙚ@@G@=q@@z@(@33@33@=q@@=q@G@@ᙚ@@@@ᙚ@G@@ᙚ@ᙚ@\@@{@@޸R@޸R@
=@޸R@@ff@޸R@޸R@޸R@
=@H@@@߮@  @\)@Q@߮@ff@  @߮@@@@G@=q@G@@=q@{@@33@
@@H@H@z@z@p@p@@p@p@{@@@Q@@
@\)@\)@@陚@=q@=q@陚@陚@@@@  @R@@z@p@Q@\@@ff@@(@z@z@(@@33@p@R@@@@(@@{@R@33@G@Q@@@@@@ᙚ@߮@@ff@Q@{@p@޸R@ff@޸R@߮@\)@ᙚ@@߮@@޸R@߮@ff@G@33@G@@@߮@  @@@\@@@\@=q@@(@z@z@p@{@@G@陚@z@@\@33@H@z@p@@
@{@G@@\)@
=@  @@@@z@H@陚@\)@@\)@@@Q@@  @  @\)@p@@p@@@z@@@z@z@z@@z@@H@H@@@  @z@(@33@z@@=q@@=q@H@ٙ@(@z@
@H@ۅ@33@
@@ۅ@@@33@@\)@  @  @G@=q@G@\@=q@@\)@ff@޸R@ff@޸R@޸R@ff@@p@@@@߮@z@@z@z@p@{@@@{@{@  @@޸R@{@޸R@\)@߮@
=@\)@\)@(@(@@@
@ڏ\@(@@ff@޸R@{@޸R@@{@p@z@(@@(@=q@
=@Q@Q@أ@ٙ@أ@@@׮@  @׮@
=@
=@ff@ָR@Ӆ@Ӆ@Q@=q@θR@ff@{@{@ff@p@@@p@@\)@{@
=@
=@\)@@@ff@  @ۅ@=q@@=q@׮@@=q@  @  @  @Q@
@(@\)@{@@H@\@
=@޸R@
@@=q@ᙚ@H@޸R@޸R@{@@\)@@@ff@@@G@Q@  @\)@ff@ff@{@޸R@޸R@
@޸R@޸R@޸R@{@{@޸R@
=@
=@߮@߮@\)@Q@@(@
@@޸R@@@(@33@33@ۅ@33@H@ٙ@ۅ@ڏ\@H@p@׮@{@{@@p@ָR@\)@ٙ@=q@أ@@G@Q@@  @ٙ@@أ@@  @
@z@z@@@
@@@@@p@ff@@  @\)@ff@ff@߮@@G@  @@߮@ff@
=@
=@G@@ᙚ@H@\@\@@  @@߮@H@
@@(@33@@@z@߮@߮@{@33@ۅ@p@z@33@33@ڏ\@H@z@@{@@@@@@33@z@
@33@p@@@
@@@׮@@ff@33@
@Ӆ@@(@
=@
=@H@@ָR@@G@@H@@Ϯ@@  @G@@ָR@
=@  @@p@߮@@޸R@p@@z@{@@z@@@ۅ@(@ff@ff@޸R@޸R@
=@
=@ᙚ@H@33@@(@
@z@@z@
=@{@
@p@ff@ff@@p@
@\@߮@  @
=@  @33@\@@
=@߮@{@޸R@ᙚ@@Q@\@33@=q@߮@@Q@߮@߮@G@\)@ᙚ@@Q@Q@  @G@@߮@Q@@
=@p@H@ۅ@@\)@ڏ\@
@\)@p@@{@G@
=@@z@  @G@\@33@ff@{@p@Q@@=q@@  @@\)@33@@{@G@@\@@33@@@  @=q@@߮@{@{@@  @@\@H@\@=q@\)@
@(@=q@G@(@{@
=@\)@
@H@@@@p@@@@@G@ff@ff@R@z@@@
@@ff@  @@H@陚@@{@R@@\)@@
=@G@(@
@\@33@@Q@@z@p@ۅ@=q@z@\@H@أ@ָR@ff@G@љ@z@=q@@ff@  @(@ᙚ@z@z@p@@p@
@33@z@(@@p@{@R@=q@H@(@G@
=@\)@@@@@H@G@33@
@(@@
@@=q@H@\@33@\@=q@ᙚ@ff@\@@@\@@ᙚ@Q@
=@{@
=@\)@@߮@G@@߮@Q@@ff@޸R@߮@߮@Q@@  @  @߮@Q@@Q@@߮@{@޸R@p@ff@ff@@@G@H@33@Q@Q@@޸R@z@޸R@{@\@{@@{@@\@H@(@R@G@@陚@z@@p@Q@G@H@=q@33@z@{@ff@  @@@\@@H@=q@@@=q@@@@@@@@(@@{@@H@R@@{@=q@R@\)@33@@\)@@@陚@@@@(@p@(@H@\@H@33@陚@@G@G@@=q@H@(@@\@@z@@33@{@z@@@@{@R@@Q@
@@H@{@  @\)@@@(@@ff@@@ff@z@p@p@p@
=@Q@(@@{@Q@@
=AAGA
=AAffA=qAGA\AAAAffA@
=A A@{A A @
@@p@@@G@\)@@@R@=q@
@{@p@p@(@@
=@z@
@ff@\)@
=@ff@z@p@H@(@(@  @@@@@(@{@@{@=q@޸R@ff@ҏ\@p@@33@=q@
@
@\)@
=@˅@@љ@H@=q@H@=q@Q@@\)@@أ@  @ָR@33@
@ff@p@ff@@߮@߮@@\)@@=q@ٙ@H@{@ff@@@@{@  @@޸R@@{@Q@  @  @  @@@ff@@@z@ۅ@
@Q@
=@p@p@p@ָR@H@ۅ@ff@Ӆ@ff@Ӆ@(@Q@@љ@@θR@=q@ҏ\@љ@@ҏ\@33@У@@G@У@Ϯ@  @z@p@{@У@У@
=@ff@
=@\)@Q@Q@ʏ\@ʏ\@H@@@@G@Q@У@33@  @  @=q@@Ӆ@(@p@{@
=@=q@׮@@@أ@=q@@G@@ڏ\@ۅ@@߮@{@@
@{@  @@@{@(@33@@
@@=q@  @\@G@@ڏ\@ۅ@ڏ\@
=@@p@z@@ڏ\@ۅ@(@z@@{@p@=q@H@
@
=@33@\)@@ff@ָR@
=@ff@z@{@@@
@׮@ff@@
@љ@@@  @ff@
=@@Ϯ@Ϯ@@ҏ\@=q@љ@H@33@Q@
@@=q@33@{@ָR@Q@أ@@=q@ڏ\@H@33@أ@Q@أ@G@@
=@@@=q@
@
@(@@33@ff@
=@  @
=@Q@ff@
@
@@@p@\@@@ff@=q@
=@޸R@ff@߮@G@=q@  @G@=q@=q@ff@߮@@@޸R@
@@@߮@޸R@\)@@ff@(@\)@(@
=@@@{@{@
=@ff@@@p@ٙ@ۅ@׮@׮@@\)@׮@Q@ָR@׮@أ@  @33@@@߮@\)@@@ᙚ@޸R@@G@Q@ᙚ@  @H@  @߮@  @\)@@\)@G@߮@@(@p@@@z@@@G@@@{@G@Q@p@
=@  @(@@@@
=@ff@
@@\@@(@
=@陚@@\@  @@ff@@(@(@(@
@z@p@@p@ff@@@\@\@
@\)@
=@޸R@ᙚ@G@@
@{@Q@  @H@߮@@(@޸R@
=@z@@p@ڏ\@(@{@{@{@{@p@{@\)@\)@{@@Q@\@@
@R@R@@
=@\@@Q@@Q@
=@@ff@ff@@p@@33@33@
@@@
=@@@陚@  @@33@@H@ff@z@@
=@z@z@p@@@
=@z@(@=q@@@\@@z@(@=q@33@
=@陚@33@\@@@{@p@@
@\@\@=q@  @p@@p@@(@{@p@p@@R@=q@\@ᙚ@
=@\)@\)@
=@޸R@޸R@߮@@߮@߮@ᙚ@@H@(@  @
@@@@@@@
=@(@
@z@@ff@陚@R@33@H@@
@@@p@ff@@33@33@Q@\)@@
=@H@@@=q@@
=@R@
=@p@@(@p@@@
@@=q@@(@@@(@Q@33@
@33@z@Q@Q@=q@=q@  @H@
@33@R@\)@=q@@
=@\)@p@{@p@p@z@z@@@z@z@
@@@@p@{@\)@
@@@@@R@R@
=@ff@ff@@@@@{@@@@@\@G@=q@\@33@H@\@@@@G@@(@R@  @  @\)@@
@z@=q@H@@@33@@@@  @@R@Q@
@@Q@@@ff@@{@  @\)@R@{@{@{@
=@{@ff@ff@R@33@\@@@@@G@H@=q@@G@\@p@{@{@\@(@(@33@33@33@
@(@z@@z@@p@{@@\)@H@陚@=q@\@@
@@@@33@z@ff@ff@  @{@ff@@=q@{@\)@ff@R@{@G@  @Q@G@\@
@(@@z@@R@@G@=q@ff@@@33@=q@
@H@@@H@\)@\)@G@=q@\)@ff@z@@ff@@\)@R@\@R@@\)@=q@@z@\)@@\)@@  @  @@@Q@@@  @Q@Q@R@p@(@@(@(@
@z@(@
=@@@@R@  @@@\@{@@\)@@  @R@\)@@@@ffA\@AHA QAH@zAAGA (@z@ApAA
AAHAHA (@@@@\@RA (A   @=q@
=A @
@R@33A@\)A (@H@33@@=q@@G@@@@@@\@33@@Q@R@p@@@@\)@Q@(@@G@G@G@33@@@=q@\@H@@G@(@@(@H@@z@@@=q@(@z@@R@z@ff@陚@\@G@33@@@(@Q@@@H@H@(@@
=@ff@@  @@33@z@\)@R@
=A AffAAGAHAAffAApA A @ffAAH@\)@(@zA @@(Ap@z@{@
@\@@@@p@@
=@
=@ff@z@ff@R@\)@z@@=q@
=@@@Q@@
@\@\@\)@
=@\)@@@@ff@ff@@p@{@@{@R@
=@@@@\@H@33@33@@(@{@ff@R@=q@
@{@A QA z@(@Q@\)AGA{AAffAAQAGA{AAA	A
=qA	A
=qA
ffA
\A\)A
=qA	pAA	pA
ffA
RA
RA\AA
ffA33ARA  AA
=AA zAHA33ARARAA(AQA AAAG@
=@\)@33@@  @Q@RA (@\)A A
@
=@@\@@ff@=q@GA @@AHA@@=q@  @@@@{@p@\)@\)@@G@G@\@=q@@33@G@@=q@33@(@\)A AA
=AA
A
AzAA  AA zAffA33A33A33AQA	AzA{A=qA
A=qA
GAGAA(ARA
A
=qAzAAHAAAHA	pA	GA{ApAARAA
AAAAHAA A
AzAA zA{@R@
@{@\)@
=@\@H@33@@@@  @ff@@=q@
@(@\@@\@33@@=q@@G@G@  @
=@33@p@@G@{@33@
=@@(@@@  @=q@@
@
@RA (@\)A A@ffA   A   AffAA\A33AzAA\)A@RA(AApA{ApAA{AffApA
AHAzAAAff@RA Q@
@\)@@@@=q@ff@@H@\)@R@@\)@p@{A=q@
=@@@
@@Q@
=@
@@(@33@33@33@\@\@Q@@=q@Q@\@@=q@\)@@
=@@@@@G@G@@\@H@
@z@  @H@
@@ffA QA   A
=A AAARA33AAffAARAAAAAA(ApAA\)A
A	AA\)AA
\A
AffA
\A
AA
A  A
AA
ARAAA33A  @
=A@33@\)Ap@ff@\)AA QA{A33ARApAffAApAARA\)AAGAAAAA{A{AAAzAHAHApAzApA (A  AA\A=qARAR@
=A QA
A@ffA A zAAARA zA   A (A Q@@@zAA\A\AGA=qA
ApAAGAAAA
=AAHAAAARAGA
A	GA
=AQA
A
AffA
A
A
=AAA33ARAAA
AAAAGA A @@@@@33@{@p@A@R@
@Q@@@(@@33@G@Q@
=@@=q@@@p@@  @\)@@z@@
@@Q@@@33@Q@@\)@H@@@ff@p@@H@G@=q@H@@@=q@=q@\)@\@z@H@(@
=@ff@Q@Q@33@@{@@
@
@@ff@33@A A=qA zA@{@G@  @G@(@R@=q@G@@Q@  @\@{@{@G@(@  @(@\@@@=q@@G@Q@@G@ff@(@@H@33@Q@33@
=AGA\AApARA
=A
ffAzA
=AA
=A
A{AAQAAGA33AA\A
=AA  A\AA
=AA33AAAzAAAAApA\)AzAApAAAA
pAffA\)AAzA
GA
GAffAAAA=qAGAA\A{ApAQAA
GAA
{A	A(AAAA\A
A
A{AAQA\)A33AA=qAAA  A
AzA\)AHAAzA{A=qAARA  AAAAAA\)A
=A33AAHA (A=qAQAQ@\AA(@@@@@\A Ap@R@H@
=A (@@@@
=A Q@A QA  AQAffApA{A Q@Q@ff@ff@
=A\AA\AHAA
=ARAffA33@ffA=q@A AARA(AAAAA33A ApA33A{AA=qAHA{A{A Q@
@\@{A AG@p@(@
@\)@ffApAA (@@
@=q@{@AAA   A   @@RAHAGA A A (A z@\@p@@\@G@@
=@@@
@@H@{@33@\)@\@
=@
@p@ff@@\)@\)@(@Q@\@\@@ff@@R@@\)@A AAA   AAGAA Q@@@{Ap@(@@Q@\@  @33@p@@
=@
=@p@@@\@R@
@z@@33@\@@{@@@@@R@@@G@=q@@33@@@p@  @Q@@@ff@@@@@Q@G@{@陚@{@\)@\)@\)@
=@
=@=q@陚@@G@߮@@@z@\@@Q@@Q@H@p@G@
=@ff@ᙚ@@@
=@ff@\)@Q@(@Q@@G@R@@  @H@=q@@@@@@@@\)@R@
@H@R@G@\@H@33@@Q@@޸R@@G@H@(@{@@@R@@z@p@ff@@G@33@(@R@  @33@33@33@\)@@\)@@
@=q@ᙚ@
=@33@33@
@H@H@ff@
@ff@@޸R@z@z@G@
=@=q@\@\@=q@G@(@@ff@@@@@  @Q@ff@Q@@@p@{@\)@\)@{@@{@@33@@@@H@Q@  @@Q@p@
=@ff@p@  @{@@@@R@ff@Q@ff@@
@33@ff@@@p@
=@(@@@ff@@(@\@@陚@33@33@@@
=@33@
=@@
@@@@\@@陚@\)@@ᙚ@@G@Q@@@@@@
@ff@p@z@=q@
@33@R@  @@{@@G@Q@(@@z@{@R@
@@
@
@(@z@z@(@@p@Q@@@ff@z@@@Q@@陚@H@@ff@Q@ff@@z@(@@@{@@
=@@
@z@
@
@(@ᙚ@ff@@(@@@H@=q@\@\@
@33@ᙚ@ff@@@Q@ۅ@ᙚ@@ڏ\@
=@ff@޸R@33@@H@@G@@@G@p@z@@z@@@=q@޸R@@p@ff@z@
@\@@\)@@z@
=@Q@Q@\)@ff@(@ff@
=@33@p@
=@\)@@  @@@{@@@Q@(@@
@
@ff@A
A33A
AAA
ffA
AAA{A33A\AzAffA\A=qAffAQA
=q@R@@@(@  @G@HAHA(AGAA
ARAA(A   A(@Q@(@H@Q@G@@H@@
@(@=q@H@@@@@33@\@@@H@@
@\)@\@@=q@@\)@  @\)@\)@@@{@@G@@z@
=@  @R@
=@@\@G@@{@p@z@H@GA   AAGAG@QA   A=qA33A  A(AA
RAA
AzA  A
pA
=AGAAAAzAHARA
=A
=ARA{A{A\AA{A  A
=@@\)@
=@A Q@@  @Q@(@@  @@\@@@
@@@@@\@@=q@ᙚ@H@p@@@@@(@  @H@@\@@
=@
=@\)@@@z@ff@@(@H@\@33@ff@p@@
@
@z@R@陚@@\)@=q@z@@@A   A z@@(@
@
@@{@(@@H@
@(@ff@{@@{A (@@zA   ApA\AApA zA zA zA @@\@@@@R@@Q@=q@@@G@33@\)@\)@=q@@G@\)@߮@߮@߮@
@ff@ff@33@p@33@ۅ@33@@@{@@H@(@z@\)@
=@ff@
=@{@
@@=q@@\@33@
@@@p@޸R@ff@R@@Q@H@  @@=q@  @@@@@A (@@@@@
@z@AA  AAQAA=qAGAA{AffA\ARAGA(AAAAAGA
GAA
ARAA=qARA=qApAA
A\)A	A
AAG@p@33@ff@@@\)AQA QAzA\)@@{@G@G@33@@\)@=q@zAA @@@@@@33@@@@  @@@z@z@\)@@ff@@@R@ff@@ff@
=@ff@
@@@\@(@A A z@{A	GAA  A(A{A
A\A  A
A{A\)ARA
=A=qAffA\)A
ApAA
=AAA  A
AzA{AzAAA\AA
RAA\AA\@@33@AHApA@z@@{@ff@A@A Q@
=@\)@@@H@G@@@H@
@@\)@p@33@@{@\@陚@{@
@=q@
@@H@
=@@@{@
=@=q@
=@=q@G@{A   @A   @
=@ffAA
=AA @AQAA
GA  A	pAffAA @\@(@R@@@A{@GA @AQ@@33@ff@R@@@ff@G@ff@@H@@Q@=q@@  @@@ff@@=q@z@@ᙚ@{@p@@=q@{@ff@z@(@@ָR@(@(@߮@@\@=q@@@p@z@\A   @@H@33@@@@z@p@ff@ff@@G@@@33@=q@@33@أ@@=q@@
@p@=q@p@p@ۅ@(@@@@33@ᙚ@@\@ff@@@
=@=q@
=@@
=@  @  @=q@\)@Q@\)@陚@@p@R@=q@ff@@@\)@p@A zA QA Q@z@@@@\@\@@G@@
@@G@G@@\)@  @@=q@  @陚@@
=@@Q@33@@{@R@R@
=@@p@
=@  @{@ff@R@G@@ff@
@(@p@
=@{@{@R@@\)@
=@G@@@@\@\)@\@{@@@33@H@\@@33@=q@33@ff@@R@A   @pAAGAGAHAA{A  A(AAAzA	pA
HA33A
\AA	A\AffAAp@\)AAA
=@H@(@RA @G@@@@@{@@Q@\@ff@
@=q@@@\)@@
=@޸R@߮@
=@޸R@Q@@@޸R@
=@\)@  @=q@R@=q@@G@=q@@R@H@
@(@Q@@R@{@@=q@@@@33@33@Q@@Q@@\@@p@
=@@G@H@
@pA zAA
=ApA33AzA	A
\AA\)A33AA{A\AGAAA\@@R@
@\@33@{@R@p@p@@ᙚ@Q@ᙚ@33@\@z@=q@\@@=q@@Q@@\)@
@H@33@\@@z@(@@
=@G@@G@=q@@  @
@@
@(@(@  @33@
=@ۅ@ۅ@ۅ@
@H@G@  @z@@{@
=@\)@ᙚ@@@33@
@\)@@AAGA AffA A zA A A Q@@@zAGAA{ApA\)A  AApA\A=qAHA=qAAApARA=qAA\A(A=qAApApAA(AAQ@z@R@=q@@Q@@Q@Q@@
@p@@
=@
=@@ff@@@@@@@@
=@R@{@ff@@G@
@z@@33@p@(@ᙚ@ٙ@  @أ@p@@أ@H@޸R@ff@z@(@\@@G@@=q@G@p@R@@\)@  @\@  AGAQA\)AffA
=ARAA{A=qA{A
=A
AGA=qAHA33A(AA (A\A  A
A
=A
\@{AQAAQA@=q@@33@
@  @  @@ᙚ@  @
=@{@@@=q@ff@@{@
@\@@
=@
=@  @@@@ffA   @{A (@@
@@p@(@33@G@=qAA   @(@  @(@@R@\)@(@(@33@@@  @z@
=@@  @@R@@R@p@ff@(@33@\@z@33@\@=q@GA   AffA\)AA  A33A  A=qA	GA
ffAA=qA33A
ffA@\)@  @@  @@@H@G@Q@=q@{@pAQAA @@33@33@  @  @@G@  @@@{@R@@@(@(@\@ᙚ@Q@  @Q@
=@ff@@p@@@z@33@=q@ڏ\@G@Q@أ@ff@@޸R@@\@p@Q@Q@
@=q@
=@
=@\@p@=q@{@@ff@@  @(@{@p@z@R@H@@{@@@H@\)@H@ff@
=@33@
A QA @AAA
A\)AzAHAAGApAA{A{A{AGAA  AA
=A
A
A
A33@QA  @
@{@=q@@Q@=q@A @@@
=@33@H@
@@33@@޸R@=q@(@  @\@(@
@@
=@
=@\)@{@  @
=@(@z@\)@33@@Q@@\@p@@޸R@@
@
=@@ۅ@{@=q@=q@=q@
=@\)@R@
=@@{@@@(@=q@@  @=q@H@\@@@@z@p@
=@@  @@{@(@
@@p@@@A @@=qA{A=qA33@H@p@z@@H@H@@  @ff@z@@=q@@ᙚ@p@{@
=@߮@z@G@ۅ@=q@@أ@
@{@  @Q@޸R@\)@p@@(@H@@=q@H@ٙ@H@@z@
@ٙ@أ@@ff@ff@p@p@z@(@@  @
@
@ff@޸R@陚@  @@
@=q@Q@33@\)@G@\@H@=q@@@\)@p@@@
=@  @R@G@@\@33@\)@{@
@33@33@@{@RA (A zAAGAHAAHAA
@ff@@A{AAp@
@{@@ff@@
@@Q@H@H@=q@
@\)@{@
@@
=@=q@\)@@\@
@@@R@z@@@
=@Q@Q@޸R@
=@
=@Q@ָR@z@ڏ\@ڏ\@@
=@@Q@@  @Q@=q@Q@(@@
@(@
@(@@@p@\)@\@\@p@R@=qAA\)AAAA
A33A
=A
A
GAGA
ApAz@33@  A\AQA  A\)A=qAAAzA
{A33AA	GA
=ApA A@ffA\)A z@G@  @\)@\)@p@z@z@G@zA Q@\@@ff@@p@陚@G@p@(@\)@33@(@
@H@z@陚@
=@ff@@Q@@R@ff@߮@@33@\)@  @@=q@G@@\@߮@Q@Q@
@=q@(@@  @H@Q@\@R@@
@
@@@
@@{@  @\@p@ffAA33ApAAA@GAA @R@p@\)@33@(@ffA (A@R@pA (A (@z@ff@\@(@{@(@=q@
@p@@p@=q@(@@\@@z@陚@=q@G@G@@@G@@Q@\)@p@{@R@@@\@
@G@ᙚ@@@(@H@@33@\@\@@z@\@@@@Q@@R@{@@
@@H@(@@@A\)AA A   @
@
@AG@@@
=@A{AA\A33A\AA\)A@@@@A@A A z@ffA ApA
=A\)A
AAR@zAG@@@@
=@z@@(@G@H@߮@@@\@@@
=@
=@R@ff@@@33@
@p@G@\)@ff@{@{@p@@
@
@(@(@޸R@p@@޸R@@p@
=@\)@\)@\)@ڏ\@
=@߮@G@@
@\)@p@@(@\@@\)@p@
=@H@p@@A (AA A=qA  AA\)AA
A	A	A	A(A{A\A	A
H@\)@@
=@\@\)@pA{A\)A{@{A	A33A A A @Q@pA@p@@\)@Q@@@p@R@@\)@G@  @33@  @{@\)@ff@߮@߮@\)@p@H@=q@\)@ff@
=@
@z@ۅ@أ@
=@ָR@z@ff@ۅ@{@޸R@G@@@޸R@޸R@ٙ@ff@=q@@{@\@@@@@@\)@Q@
=@=q@\ApA QA (A ARAAQAA
RAQA\)@@@@@@R@RApAAA\A	GA
\ARA  ARA=qAA
\A
A
A
A QApA{@@@\@G@@@  @@
@陚@33@@H@(@
@@p@p@ۅ@ۅ@
@(@(@
@@
@@@@ff@@R@@z@{@H@أ@Q@@@=q@(@߮@߮@  @(@
=@
@R@
@R@R@33@\)@޸R@R@\)@ff@@@R@{@@@@@
=@=q@H@H@@z@\@R@@(@\@@
=@
@@@@{@p@\)@\)@@
@Q@  @ᙚ@Q@߮@@@ۅ@(@@p@=q@
=@
@
=@H@ҏ\@љ@\)@  @(@H@\)@H@Q@p@{@{@Q@@
@=q@ə@ə@ə@@  @z@@G@׮@أ@ָR@{@Ӆ@@
@H@z@p@=q@\)@z@{@Q@ə@
=@ָR@z@ҏ\@@أ@
@ٙ@ָR@\)@=q@
=@\@H@@@33@@\)@@p@@
@z@ff@@\@@
=@@=q@@G@G@@\)@{@p@AG@A z@z@Q@{@p@@{@\@=q@p@p@
@\)@=q@@H@(@z@G@  @Q@Q@=q@p@{@@@G@ᙚ@\)@@
=@@{@@@@@@z@@@أ@  @{@  @33@@@أ@33@ff@G@@=q@z@  @R@
@@z@@@33@\@@\@@Q@@p@  @\@\@@R@@z@ff@@\)@=q@=qA   A=qA (@{@{A QA Q@\)A Q@@H@@@ᙚ@ᙚ@H@
=@\@@R@p@@陚@@Q@  @\)@@@=q@\)@Q@\)@Q@{@{@ۅ@@p@H@@@  @ᙚ@  @ff@p@p@(@@\)@@@Q@ٙ@\)@ٙ@ff@ڏ\@ٙ@H@p@  @@Q@@z@@p@߮@
=@@R@33@H@@
=A Q@
=@@@G@\@33@(A QA AGA=qA\A\AAAAffAzAA	A
=qAAA(A33AA
A{AffAffAffA{A
AzApA{@
=@@@\)@ApAA   @R@\)@ff@(@ᙚ@@A@@@@z@33Aff@R@z@@@  @
@p@@z@z@
@z@H@
@33@@G@@=q@
=@@z@H@ᙚ@@p@@@@\)@33@@@p@Q@陚@@\@@@
@@Q@A
A(A
\A(AzA	A33A
A
A
HA
=qA
pA{A
A
AHA
GA
AzA
A
GAQA
AzA33A	AAAffAG@G@{@ff@\@R@33@@
=@{@@=q@\@
@
=@z@@@@\)@p@@@@p@
=@ff@@@
=@Q@@{@(@33@G@G@z@H@ڏ\@H@@G@G@z@(@z@  @p@(@@z@R@R@@@@RA zA @@p@R@HA (AAGAApAAHAAHAAAA(ARA
ARA
=A\A  AQA\)A zA{AA33A
AR@\)@@QApA @ff@=q@{@@Q@Q@=q@\@@\)@{@{@R@{@@
@H@(@Q@G@@@޸R@Q@߮@G@=q@߮@@@z@@\)@޸R@
=@p@ٙ@@ff@(@@G@@
=@p@G@߮@@(@
@љ@=q@H@@@ff@G@ҏ\@љ@
=@Q@׮@@\)@H@Ӆ@Q@Q@
@z@
@33@p@\)@@ə@
@@@ff@@  @@  @  @@@@\@ȣ@Q@p@@Q@@  @@ᙚ@G@@p@Q@{@=q@z@@@@Ǯ@@
@Q@(@{@
@z@{@ff@@ff@@(@\@ə@=q@p@@G@(@(@=q@љ@@  @ڏ\@z@@Q@  @33@z@У@Ӆ@@ڏ\@\@@@ff@@\@@Q@  @@H@H@Q@\@@ۅ@@@=q@\@@@
@\@  @Q@
=@z@陚@
@@R@@R@ᙚ@z@z@@p@@\)@=q@@@@33@\@ff@z@
=@@@z@ᙚ@@Q@G@߮@{@H@H@@@\)@ff@@G@=q@@p@ٙ@ڏ\@
=@G@\)@ff@{@(@p@ڏ\@  @G@  @33@@@G@=q@=q@@@\@G@{@ff@
@(@\)@@@ᙚ@z@=q@@{@R@
@G@  @@G@ff@@\)@@@陚@@\)A A@{@H@@H@陚@@H@ff@H@@@Q@H@33@z@\)@@{@@@@@ff@@@@H@@@Q@
=@陚@\@=q@
=@33@@@z@陚@@
@
@  @@{@@R@33@@\)@@陚@陚@@@@G@Q@@@H@(@(@ᙚ@\@{@ᙚ@(@
=@
=@\)@ff@@@(@@{@@G@G@@\)@@@@@@
=@ff@@@33@@@@H@@ff@ff@@=q@ff@@  @@@@
=@@z@{@=q@33@=q@\)@
@@ff@@H@  @ff@@
@@@G@  @G@z@@ffA (A  A=qA{AzA
=AffA
AQAA\)A	A
GAA\)A(A	A
AQA\)AffApA\)AHAA
HA
ffA
=A
AzAAAAA{AA	A\A\A A zA AAA\AffA
A  AGAAffAAARA  AA!pA
A=qAQA$zA"=qA"=qA%A'A$(A"=qA!pA"\A%GA"=qA!pA zA A A"\A#33A"ffA"{A (A\)AQAAAA\)A ARA=qA QA"HA
A"=qA$A%A%GA$A"ffA ARAAAA%A!AAAAA(AQARAHAAffAAA\)A33AA
A
ffAAzAffA
HA
=AQAA
{A  A(AGAffA AHAffA  AQ@@
=@p@ffAG@{@\)@
@  @AGAffAQA  AA
{AAARAA	GA
AQA	A@R@Q@\)@33@@ff@A AAffAARAAff@  @@zA@Q@zA (AGA ApARAA33AHAHAAAQAAGA (@{@@RAA (A AA=q@{A ARAA\)A{AA\)AA (@@@ff@\)ARA\AffA
=qAAQA
AA	A
{AzA
{A
RA
pAzARAAA\A=qA
ARA  AzA
A(A
A{AAA
\AAAAzAA\)A\)AARA=qAAAA\)A=qAApAQAAffAA33AzAAzApA{AAAAHA   A (A
=AAffA QA=qA QA zA (A!A"RA zA#A!A
A{A"=qAffA!A"HA%A(  A#A%A$  A
=A33A A"RA#A"ffA$QA"RA"\A zA\)A\)A zARA
=AA\AQAQAAffAAAA	AA(A=qA$A$A(AAffAA
A\AA  ARApAGAA
=A\AA\)A\)AzAQAQA	A(A\)A(A
=A
HA33A33A(A
RA   A
=AQA
A{A(AA
ffAAAAA@AA{A
=A
ARA	A	pA\)A=qA
AAzA(AA33AAA\AAQA
=AGA{A  A\AzAffA
RA33A	GAApA  ApA33AGA
=AAA\)A
AA
=AA\A
A
=qA	A33A	A(A
RA(AHA\AA
A (A  AAA	A=qA
A
pA
A
HAHA
=A
AAA
GA	GA(AA
A	A	GA
A
A\AAAffAAApA
=AA33AffAA(AA\AAAAAA (@@\@z@Q@\)@z@\@G@(A\A  A
=@=qA   @\)@z@@{AA   A   @R@
=@(@R@Q@@H@@ff@ff@@=q@@R@@pA @A A(@G@@@Q@H@陚@H@{@z@=q@ff@\)@(@@@@@@ff@@=q@ff@AA=qAQA
AA\AAQA33AHApAAAAGA
=AQAApAGAHAA=qA\)AQAAA(AAAA=qA=qA(ApA=qAAAAA
A
AffAAffAzA(AAA  A(AA\AAA @@@Aff@pA  A33A=qA
{A\)@z@33AHAA=qAA{A
ffAAHA\A{@{@A @Q@@G@ff@  @{@A @R@\)@\)@A	p@@H@R@@@(@AA(ARAA QAp@=q@{@(@R@@@=q@p@33@@
=@@z@(@
=A   @A (@{@@@@pA A\)@Q@=qA33@@(A@=q@z@@  @G@Q@@@@G@\)@@R@p@@QA
AAA @\)@p@@
=@@@
=@
=AffA{A  A (@  @@@\@@H@(@(@R@\)@=q@@@33@@33@R@=q@zA (@\@\@{@p@(@{@Q@@@z@H@@@ff@@\@@=q@z@Q@\@陚@z@z@{@  @@{@R@@陚@G@\)@=q@{@@\)@(@@p@@@ffA Q@\@@陚@R@@=q@@@G@@  @p@
=@{@
@@p@@@@H@\@33@
@p@@@p@@\@33@@G@33@\@(@Q@@@33@@{@=q@{@@
=@33@\)@@  @@H@=q@p@@{@p@{@@@@  @  @\)@@@=q@33@@ff@@߮@\)@@H@@ۅ@
=@Q@@  @@@@@@@H@@ff@(@33@  @=q@޸R@ff@@@@ff@@@{@@@
=@p@ۅ@@=q@\)@R@H@߮@߮@H@(@p@{@
=@Q@@33@33@H@@@
@@(@G@(@ff@Q@@@
@@33@@@
=@\)@=q@ff@33@
=A @ff@A @@33@R@\)@G@@Q@33@z@@@  @@G@z@
@R@{@@ff@@=q@ff@
=@Q@@  @@
=@ff@Q@@  @@@G@
=@@=q@@=q@G@@Q@p@z@{Ap@(@ff@R@  @{@@p@p@=q@@=q@@@@@{@z@R@
=@ff@33@  @@@{@@{@@G@33@@@33@=q@
@ff@@@=q@=q@(@ff@H@@\@@
=@
=@R@@33@@
=@@ff@@ff@@\)@(@Q@@@G@
@陚@z@z@@Q@@@\)@\@@\@(@z@z@p@H@@H@@@(@
@
@z@
@G@@  @@=q@G@@H@@R@  @H@H@
@
@(@@{@@@\)@@@\)@z@p@@@@=q@@\@@\@@@z@z@H@@=q@R@\)@@@{@@(@33@@@  @@@G@@{@\@
=@(@
@H@@ۅ@\)@=q@ff@@@@H@߮@\@=q@=q@߮@߮@=q@{@@@
@@@G@\)@
=@\)@ff@p@  @@@z@z@\)@=q@@p@33@@H@陚@R@陚@@=q@\)@@  @R@@B33BřBƙB  B33BǙBffBșB33B33B33B33B33B  BffBBffB  B33BffBəB  BBB  B33BffBB  BʙB  BBəB  BBBBBB33B33BffBBffB  B  B  B  B  B33BșBffBffBBBBÙB  BffBffB33BffB33BǙBffBƙBÙBffBBBB  BBBBffBƙB33BB33BffB  BffBBBffBBffBBBÙBBffBBB  BffB  BřB  B  BǙBșB  B33B33B33BəBffB33BǙBffBBǙBffBB33BșB  B  BʙB33B  BB33BBșBəBəBBB  BffBșB  B  BǙBșBB  BǙBffBffBB  BřBʙBffBB  BBƙB  BřBB  BffB  B  B33B  BB  BffB  B  BBffBƙB33BBBffBÙBB33B  BffB33BBǙB33B  B  B33BB  BffBBBffBșB  BB33BșB33B˙BffBffBffB33BB  B̙BB33BffB33BBΙB33B33B33B33B33BB  BffBB  BffBffBffBBəBəB  B33B  BǙB  BǙB  BÙB33B33B  B33B33BffB  BBBB  B  B33B33BffB33BffB  BBffBBǙB33BǙBB33B33BB33B  B33B  BÙB33BffB  BBBBBęB  BffB33B33BBBffB  B33BB  B33B  BffB33B  B33BΙBffB  BffBәBԙBB  B  BBffBBҙBЙB  BΙB33BffBffBBΙB33B͙B  B  B  B˙BʙBffB33BBBəBəBffBʙB  B  B33BB  B33BffB  B  B  B33BffB  B  B33BffBęB33B33B33B33BBB33BBB  BșBffBBBƙBffB  B33BșBBBʙB˙BB  B  B  B33B  BffBB  BϙB  B33B33B33B33BffBBؙBBB  BޙBޙBffBffB33B♚BB  BB  B  BBBBBB  B  BB33BBB33B  B33B噚B  B♚B33BڙBޙBBffB33BffBBffBffBϙB  BBәB33BffB33BљB33BB33BЙB33B33B33B  BəBșBffBffB  B33BB  BBffB˙BffB33B̙B33BffBəB  BB33B  B  BBBBffBBffB33BffBffBffBՙB33B33BۙBffB33B  B  B33B  BܙB33B  BܙBffBffB33BBݙBffBۙB33B  BffBBڙBffB  B33B33BBڙB  B33B  BffBBffB  B  BffBיB  B33B33BffBBB33BBB  BffBBBԙBBBBB33B33B33B  B33B  B  B  BBǙBǙBB33BəB33B  BǙBBffB  B  B33BB33BǙBffB33BffB33B  BBB33BęB33BƙB  BffB  BffB  BBBΙBffBffBffBҙB33BәBffBB33BffB33B33BffB33BљBffBffB  BBffB33B  B33B  BffBϙBB33BffBϙBB  BϙBBBʙBffBʙBBʙB  BʙB33B33BB33B  BffBffB33BffBffB33BBffB33BBffB33BB33BřB33B  BƙBșB33BffB̙B  BffBffB  B  B  BffBB  B33B33B33BBffBB33B˙B33BBB33BBBffBB33BffBB33B  BəB  BffBЙB33B  B33BљBffBϙB  B˙B33B33BBB33B33BBffB͙B͙BffB͙BBffBffB33BB  BB  BffBșBBffB33BșBřB  BBƙB  BBB  BffBB  B33B  B33BƙBƙBBB  B33B33BffB33BffB  B  BBBBBęB  BffBřBffBB33BffB  BffBffBffB  B̙BΙB33BBffB  BәBљBBffB33B33B33BؙBBיB  B  BՙBיBBיB33BBBffBٙBB  BBB֙BBffB33B33BәBљBΙB33BffBϙB  BB  BB33BB͙BffBffB33B33B  B33BB33B  B33BffBəBəBBBəB  BBBB  BffB33B  BșB  B  BffBffBffB33BəB33BəB33BB33B33BffB33B  BffBffBB  B˙B33B33BʙB̙BffB33BϙBBffBҙBffB  BB  BffB33B  B  B33BB33B  BՙBיBؙBBffB33B33BؙBffBffBٙB33B33B  B33BיBיB33B  BB33BffBBffB  BBՙBיBffB  B  BЙB  B33BffBԙB33BffBBBљBffB  B33B  B33B  B33B33B33B  B33BffB̙BBBffB33B  BffB͙B̙BffBʙB̙B˙BffB  BB  BB33B33B  BљB33BϙB33BffBBffBffBB33B  B  BffBB  BffBffB33B  B  BBffB  BB  BffBffBB  BBBәBffB  BffBBBffBffBffBffB33BB  B33B33BffB33B͙BBBffBB͙B33BB  B˙B  B͙B  B  B  B33B̙BffB  B  BffB̙B33BffBffB  BB˙BB33B͙BBB33B  B33B  BBB  BffBffB33BBBffBB͙BЙB  B33B33BƙBBBffB33B  B33BBșBʙBffBffBffB  BffB͙B33B  B͙BB33B33B  B˙BBBBBəB  B33BBffBB33B  B͙B  BBB  B  BffBffBƙBB33BB33BBÙBffB33BffBBffBB33BəBffBBƙB  BBB  BǙB33BǙB33B  BffB33BřBÙBÙBB33BffB  BÙB  BBffB  B33BffBB  BB  BBBffBBBffB33BÙBBffBffB33B  B  BBB  B  BffB33BffB33B  BęBřB  BffBB33BB33B33BřBB  B  BffB  B  B33BęB  BBBÙB  BffBB  BB  BffBB  B33BBB  BBBffB33BB33BB33B33BB33BffB33B  BffB  BB  BBB33BB33BffB33B33B33B  BB  BBBBB  BBBBffBB  B  B33B33BBB33B33BBffBęBęB  BffBəBęBffBB  BBffB  BƙBffBBffB33BƙB  B  BęBffBÙB33B  B  B  B  B33BB  B  B33BBB  B33B33BffBBffBB33B33B  B33B  BffBBffB33B  B33B33BęB  BƙB33B  BB33BBBffBB33BBB  BÙBffBBęB33BffBffBBffBÙB33B  BffBffBęBBęB  BffB  BB33BffBęB33BBęB  B  BƙBB  BBB33BffB  BffB  BBЙBffBЙB33B33BffBffB33BB  BәB33BBB33BBffBB  B̙B33B̙BffBșBșBffBǙBffBșBffBB33B33BffB  BffBBffB33B  BBB33BffBB33BÙBffB  B33BffBB33B  BffBBffB33B  BBBB33BffB  BƙB  BB  BffBffBB͙BΙBffB  BffB  BBffB33B  BB  B33BffB͙BffB33BffBffB  BB  B33BB  BB33BffBBB33B33B33BҙBffB  B  BffB  B33BffB  BΙBΙB33B  B  B̙B  BЙB33BB  B  B33B33B♚B33B  BיBҙBәBffB33B  BffBBffBBřBƙBffBB  BșBBffBșB  BřBBBB  BBB33B33BffB  BΙBљB33BB33BB  BęBffB33BʙB  B˙BffB33BΙBffBBBffBBB  BЙBЙB33BBՙBffBBЙBffBBBffB33BBB33BffB  B˙B33BffBffBffB  BffB  BϙBљBB33BffBffB33BәBҙB֙B33BBBffBؙB33BffBffB  BB33BBffBffB33B33BffB֙BәBBΙB33B  BϙB̙BffBffBΙBffBԙBBffBBffB  BffBB  BҙB  B  BԙB33B  B33B  B  BffBBʙBffB33B̙BB͙B33BBffBffBB33B33B33BffBffB33BffBB33B33BB͙B͙B33B  BB̙BBffB  B33BffB33B33BBBBBffBBԙB33BәBffBәB  B  B  BBffBЙBffBffB33BffB͙BffB33BB̙B̙BBB̙B33B33B̙BB  BBffBB33BffB33BffBffBB33B33BΙB33BϙBBffBB33B33BffB33B33B  BBBB  BffB  BBB  BΙBBљBљB  B  B33B33BҙB33B  BffBffBϙBBffBffB  BB33BBffB  BB̙B33B˙B33BB̙B33B  BBB33B33B͙B͙B  B  BffBBffB  B  B33B33BffB˙B  B  BffB33BffB˙BffBB33B̙BBBBșBBBΙBffB  BBBffB33BffB͙B͙B͙B̙B  BəBBB33BffB  B33BB33BB  BffBəBffBffB̙BBBB  B  B  BԙBBffBffBЙBBffB33BffB͙B33BϙB͙BBBϙB33B  BffBffB33BBffBҙB  BffB33BffB  BffBffB33BϙBffB33B͙BffBB  BBB  B  B33B33BBffBffBB33BBəBffBffBBƙBřBffBffB  BffBB  B  BffB33BǙB33BB  B  B  BffBffBBƙBB  BffBÙBBffB  BęBffBBBB  B  BǙBșB33BffB33BB33BЙBB  B̙B  BΙBBffBB33B33BB̙B  B33B33BϙBΙBBʙBB33BffB˙BffBB33B33B̙BΙBBәB  B  BיB֙BיBB33BәBffB͙BϙBBϙBffBffB  BB33B33B͙BB  BBʙB  B  B  BșBǙBǙBșBBffBB33BBB  BB33BBBffBffBƙB  B33BBffBffBܙB33BꙚB  BB  BffB  BBB͙B͙B  BffBB  B33B33BҙB33B33B  BffBffB33BBҙB  BB  BffB33B  B33BәB  BBܙB33B  BBәB  B  BffB̙B˙B33B˙BffBBffB33BffB33BBB33BəBffB33B33BəBəBșB33B33BřBffB33BƙBffB  BBǙB33B  BBffB  BB33BəBffBffB33BBBffB33B  B  B33BffB33B33B  BB33BffBBB  B  BffB  BBΙB͙B̙BBffB33BəBffBB̙BffB  B33B33B  BffB33B33BBϙBffBBBffBffB33BffB33B33BBffBǙBəB˙BϙBB  B33BffB33B  B  B͙BB33BBΙB  B͙B33B  BB33BB33BəBəBΙBϙB33B33B̙B  B33BffBBffBffBBΙB͙B33BЙBBffBffBffBffBҙBB  B33B  B  B33BB33B  BBB̙BffB33BffBffBffBffB33BffBffB  BԙB  B  BәBBՙB  B33BB  BffB  B  BB33BffBՙBՙBәBB֙B  BffBB33B33B  BәB33BϙB33BB  BљB  B33B33BBffBffB33BffB33BʙB  B  B33B͙B33BʙBəB͙B  B  B  BffBffBB33BBљB33BՙB33B  BB  B  B33B  BBBffB  B  B  BffBffB33BҙB33BҙBffB33BffB  B  BffB33BffBיBffBffB  B  BffBޙBBffBffB33BڙB33BڙBffB  BݙB33BffBۙB33BߙBݙB33BBؙB  BBB  BҙBBB33B  B33B͙BϙBיBՙB33BffBBffB33BԙBffBBffBffBBB̙BB33B  B  BB  BffBffBB33BؙB33BB˙BB33B33B33B33B  B33BffBϙBBҙBffBΙBΙBΙB33BffB33BBBؙBؙBؙBљBՙB  BיB  BBB  B33BffBffB  BޙB  BffB33BB  BB33BB  BffBBffBBBəB  B  B  B33BffBffBffBB33BffB33B33BB  BBڙBBB  BffBB陚B33BB  BBҙBԙBיB  B  BffBיB33BffB33B33BffBffBәB33BԙBԙBԙBB  B33BBffB33BBffB  BΙB  B33B  B33BffB  BԙB33B33BB33BffB33B  B33BB33BffBљB  BffBBBBBffB֙B  B  B֙BBffB  BBB  B33BB33B  BBBffBffBBۙB  B  B33BBB  BffB  BB33BBBffBffB  B  B  B˙BʙBB33BBB  B33BffB  BʙBffBffB  B33B33BffBffBЙBB33BBٙB33B33BљBffB33BəB33B33BBBffB33B  BB33BۙB33B33BffBB33B33BBBffBљBffBBffBәBBBffB33BffBffBԙBffB33B33BB  B33BffB33BB33B33B33B33B33B33BԙBB  BffB33BBffBЙB33BB33BәB  BBBϙBBffB  B33BffBffBffB  BBBǙBB33BB  BffB  B֙B֙B33B33BffBB33BBBffBљBffBܙBffB33BԙBB33BՙBffBBffB33BB33B  BffBffB  B  B͙B33BBBffB33B  B33B  BB  BffB  BޙB  BffBۙBffBffBBݙBB33BffB  BڙBڙBBؙBڙB33B֙BffBڙBؙBәBffBffBffBBffBBܙB33BffBB33BffBffB33BؙB  BffB  BBBB33BB33BB  BBBB33B33B33BffB  BffB  B͙B  B  BB  BB33B33B33BffBB  B  BBffBffB  BffB  B  B  B33BB֙BٙBffBۙBۙBffBٙBB  B33BۙB  BB33B  BBߙBᙚB  BffBffBBffBBBffB㙚B噚B  BffB33BBB33B33B33B33B  B噚BffBB  B33B33BBBיB䙚BBffB㙚BBB  BBB  BܙB  B  BٙBB33B33BffBBffB  B33B  BffBffB33BљBffBҙBؙBffBBB33BBffB  BۙB33BݙBffB33B˙BșBÙB  BB33BؙB  BؙBB  BB  BB33BљB  B33BffBәB33BBԙBԙB  BffBffBBBB֙BffBBffB  B33BffB33BәBffB  BB  BљBB33B33BBB33B33B33B  BЙB  B33B  BۙBݙBB  BۙB  B33BffBffBB33BffBB  BffB  BffB33BB  BB  BffBҙBBB  B33B  BB  B33BƙBșBəBffBB  BffBʙBffBffB  B̙BBϙBffB33BЙBBffBșBffB  BffB˙B̙B  BB  B33BffBffBffBffB  B33B33BB͙B  BϙBΙB33B  BϙBBϙB̙B33B33B  BffBffBșBəBəB33BffB33BșBffB33B  BBǙBffBffBffB33B33B33B33B̙B˙BBffBffBΙB  B33BB  BffBffBBffB  BB33BЙBҙBffB33BBffB  B  BffBffBBəBÙB33BBBBBffB  BBffBffC C33C
  B  BB33B33BffBBڙB33BffBffBәB  B  BffBBڙB  BffBffBBffBffB  BffB33B  B  B33BؙBיB33BffB  B33B  B33BљBffBљBљBB  BҙBBffB  B33B33B  B  BB  BԙB33B  BffB  B33BҙBffBffBffBB  B̙BffBB33BffB  B͙B͙BB̙BΙB  BffBB33BϙB33BffB33BffBBB  BB  BffBB33B33B  BЙB  BBffBffB  B33BB  B㙚BffBB  BffB  BBffB  BffBffBffBffB33B  B  B33B  BB33B  B33BB  BBffB33BB33B  BB33B  BƙB  B  B33BęBƙB  BffB  B33BǙBffBBBB  B  BffBBffB̙BffBBB33B  BʙB33B  B33BBB33BB33BșB  BșBffBffBəB33BǙB33B33BB  B  B33BB33B  B33B  B  BBΙBBB33BffBffB33BBffB  B  BݙB  B  B  B  BݙBffB  B33B33BBB33B33BB  BәBәBffBB֙B  BB  B33BBBBٙB33BᙚBܙB  BəBBffB  B̙B  BBљB  B  BՙBffB33B33B33BΙBB˙B  B33B  BffBBffBB̙BffBB33B  BffBffB33BffBљB  BffBffB33B33BϙB˙B  B  B˙B33BB33BffBBffBffB  BffBffBޙB  BffB33BB33B33B33BB  BٙB33B33B  B33BBffBљB  B  B33B͙B  BffB33B˙BffB33BΙB33BffB33BљB33BҙBffB  BffBffB̙B  B̙BffB  B33B̙BB33B  B33BBffBƙBșBffB  B  B  B33B33BffB33B33BB  B33BÙBęBBffBBBBƙBřBÙB  BBffBǙBBƙBffBBƙB33BƙB33B33BəBʙB33BBffB  BBљBϙB33B  BffB  B33B33BB  BffB33B  B  B  B33BәBBB  BffB  BBffB33BB  BffBЙB33B33BffB  B  BB33BffBffBffB33BBǙB33BșBBBƙBǙB  BBƙBB  BffBffBBffBB33B  BBffB33B33BBBBBBB33BffBBB33B  B  BBB  BB  B33BBffB  B  BB˙B˙B˙BffBffB  B  BffBffB  BffB̙BB  B  BBffB͙B͙B  B33B33B͙B͙B̙BBffB33B33BəBBffBəBəB  B  BB  BB33BƙB33B33B  BBB  BffB  BBřB33BffB  BB33BBBffBBffB33BB  BB  BBBffBB33BBffBffB  B33BBffBffB  B  BB33B33B  BBB  BBBffBBBBBBBffB33BffB33B  B  B  BBffBBBBB  BB  B33BBBBBffBffB33B  B  BffBBBB  BB33BB  B  BffBBB  B33B  BffBffB33B33B  BBffBBBBffBffBB33B  B33B  B33BBB33BBBBB33BBBffB  BffBffBffBBffBffB  BBB33B  BBB33B33BB33BB  B33BffBBffB33BBBffBB  BffBffB33BffBffBBffBBBffBffB  BBBffBffBffBffB33BBffBB33BBffB  BBBffB  BBffBffB33B33BBBffB33BBffBB33BBBB33BffB33B  BB33BffBBBBBffBBB33BffBffB  BffBB  BffB33B33BBBffB  BBB33BffBBffBB  B33BBffBffBBffBBBffBBBBB  BBffB33B33BBBffBBB  BBffB  BffBffBBffB33BffBB33BB33B  BBBBBBBffB33B33BffBBffB33BffB  B  BBBBB  B33B33B33BBB  B  BffB  B  BffBB  B33BffBB  BB33BB  BBffB33BBBB33BffBBBBBBBffB33B33B  B33B  B  BffBBffBBffBffBffBB33BffB33BB  BffBBB  B33BBBBB  B  B33BffB33BBBffB  BffB  BBffBB33BffBB33BBB33B  BffBBBffBBffB  BffBBBB33BB  BB  B  B  B33BBBBBBffB33B  BBB33B33B  BBffBBffB33B33BBB33B  BffB  BBB33B  BB33B  B  B  B  BBB  B  BB33BffBBB  B  BBBB  B33BB  B33B33BB33BƙB  BffB  BƙBffB  BęB  BffBffBBffBB33BB33BBB  BB33B33BBBBffBB33B  B  BffB33BffBBB33B  BffBBB  B33BffB33B33B  B33BBB33BffB  B  BBB  B  B33BBffBBBffB33B  BB  B  B33BBBBBBBffB33BBffBřBB33BffBB  BBřBřBB33B  B33BffBB˙B  BəB  BffBəBʙB33B  B  BșBffBffBffBƙBƙB  BffBBffB  BBÙB33BffBęB33B33B33BƙB  B33B  B  B33B  BffBǙB  B  BffB33BřB  BffBffBffBB  B  BBffBffBBffBffBBffBB  BBffBBBÙBBBB33B33BBffBffB  BęBƙBffB33B  B  B33BBffBƙBffBffBffBBəB  BʙBBffB33BʙBʙB33BB33BffBffBB  B33BffBəB  B  BÙBffBBffB33BffB  BÙB33BÙBB  B  BBÙBBffBffBffB33BffB33B  BffBffBffBB33B33BBffB33BBB33BBffB33B  BBBBBffBBffB  BBB  B33BffB  B  B33B33B  BBB33BB  BB  B  BBB33B  BB  BffBÙBÙB33B  BffBffB  BffBșBșB33B  B  BBffBffBřBBffB33BřB33BffB  BffBffBęBÙBÙBB33BffBBffBffB  B33B33B  BffBffBBBBffBB  BffBffBBB33BffBBffBBffBffB33BB33BBffBffB33B  B33B  B  B  B  BBB  BB33BffB  B  BBffBffBBBffBBBffB  B33B  B  B  BB33BB33BęB  B33BřBB  BřBBffBƙBBffBBffB  B33BÙBÙBBBB33B33B  BB  BBBBBffBffBÙB33B  BBBBBffBffB  BffB33B  BBB33BB  B33BffB33BffB33BBBBB  BB33BBBBffBBBB33BBffBBBBffB  B  BBBBffBB  B  BffBBB33BB33B  BęBffBffBBBÙBBBBřBřBB  BșBffB33B  BęBƙBffB33B  B33BffBęBBBB33B  BB33BBffBffBBB33BffBffBBffB33BB  BffB  BffB33B  BBB  B33B33BffB33BBffB33B  BB33BB  B  BffBBBBffBB  BffB33BBB  B  B  B33BffBffB  B  B  B  BffB33BffBB33BB33BffB  B33BřBBffB  BffBǙBffBffB  BBB33BffB  BǙBBffB33BffBřB  BffBffBBÙB33BB  B33B33B33BB  B  B  BB  B33BffBB33B33BBffB33BB  BBffB33B33B  BffB  BBB33BB33B33BffB33BffBBB33B  BffB33B  BffBffBffBBBffB33BffBBffB33B  BBffB  BBB  BffB33B33BBB33B  BffBBBBBBƙBffBșBBəBffBʙB  B33BB33BB  BffBBșBəBffB  B  B33B  B33B33B  B  BÙBffBBBffBBB33BB33BBBffBBB  BffBffBBBffBB33B  BBB  B33BffB33B  BffBBffB33B  BB  B33BffBBffBBB  BBffBB33B33BBB33B  BBBBffBBB33BB  B33BƙB33BBBB33BBBffBəBBBʙBʙBB  B33B33BBffBffBBffBffB33B  BB33BęB  BęB  BffB  B33BffBÙBBÙB33BffBffBęBęB  B33BÙBBB  B  B  BB33BffB33BÙB33BB33BÙBBB33BBB33BffB33B  B  B  B  BBffBffBBBffBBBBBBB  B33BBB  B33B33B  BffB  BřB  BB  BffBǙBB  B  BffB  BffBB  B  BB  B33B  BəB  BB33BʙBB33B33BB  BffBffB33BBffB33B  BǙBBB33BBB33B33B  BBřB  B33B  B  BBffBęBęBBBBB33BffBBB  BB33BB  B  BffB33BffBB33BffB33BffBBBÙB33BB  B  BB  BBffBffBffB  BffBBÙBBřBBBffBffB33BƙB  BffBǙBǙBffBBBəBffBBəBffBffBəB  B  B33BəB  BffBəBșBffBffBB33BBffBBBffBǙB33BǙBB  BǙB33BřBřBřBřB  BBffB  BB33BÙBffBÙBB  BBBBB33B  BffB  B  BffBBffB33B  B33BÙB33B33B  BffBBB  BffBffB33BBB  B33BB  B33B33B  B33BęBęB  B33BBB33BƙBBǙB  B33B33BșBffBBəBffBffB33B33BəBffBffBBB33BəBffB  B33BffB33BffBęB33B33BffB  BęBB  BęBffBffB  B33B  B33B33B  BffBB33BffB33BffBBBBffBB  B  B33BBffBBB33B33BffB  BBBffBffB  BB33BffBffB  BBffBBB33BffBBBBBBBB  B33BffB  BffBffBB33B33B33BffBƙBƙBffBB33B  B33B  BB33B33B33BBffBffBřBffBffBřBřBffBęBęBęBB  BffB33B33BBęBęBBřBffBBB33B  B  B33BBffBffBffB33B33B33BęBffBęB33BffBB33B33B33BB33B33B33BBęBęBÙBÙBBffBffB  BffBffBffB33B  BffBffBffBffBBBffB33BBBBB  B33BÙBB33BB33BffB33B33BƙB  BB33BșBffBffBəB33BffB33B33B  B  B33BffBǙBffBǙBB33BffBffBffB33B  BřB33BBÙBęB  BęB  BffBffB  BB33B33BBffBffBB33B33B33BB  B  BffBffB  B33BBBBffB33BBB33B  B  BB33BBBBB33BB33BB33B33B33BB33B33BB  B  B33BBffB  BBB  BBBffBęB  BffBřBřBBffBB33B33B33BffBÙBBřBřB33BBBBÙB33BffB33B33B33BBB33BBB  BBBBB  BBBB  BBB33BBBB33BBBffBBB  BB  BBBBffBffB33BBBB  BffBffBffBffB  BBffBB33BB33BffBffBffB  B  BB33B  B33BffBB  BB33BB  BB33B  B33BęBffBBffBƙBBřB  B  BffB33B33BBffB  BřBffBffBƙBƙBffBB  BęBęBęB  BęBffBffB33BB33BB33BB33BBB  B  B  BB  BBffBffBÙB  B33B33B33B33BBBBB  B33B  B33B  BB33BÙB  BffB33BffBffBffB  B  B  B  BÙB33BBÙBBffBffB  B  B33BffBƙB33BB  BǙBBǙBǙBƙBBffBǙBBǙBB  B33BƙB33BBffBffB  B33BffB  BəB33BəB33BșB  BffBffB33B  BffB  B33BffB33B33B  B33BB  B33BffB  B33BB  BBffBBBřBřB  BffB  B33BffBBffB  BB33B  BffBB  BÙBBB33BffBffBBBB  BBÙBffB33B  B  B  BffB33BBșBBșBǙBBBffB  B33BBffB33BʙBffBffBffB˙BB33B33BffB33B  B˙B33B33B  B33BǙB  B33B33B  BffBB  B  BęBB  BffB33BB33B  BǙB33BBB  BřBƙBffBÙB33BB  B33B33BBB33BffB33B33BBffBřB33BffBffBffBffB  BffBBBBB  B33B33BBB  B33BB  B33BB33BB  B33BƙBffBffBffB  B33BșB  BBffBffB33BB33BșB33B  B  B  B33BBffBəBffBB  BBffB  B  B  BBǙBǙBB  BB  B33B  B  BșBșBffB33BBBffBffB33BƙBffB33BƙBffB  BƙBƙB  BƙBB33B33B  BffB  BęB  B33B33BffBffBB33B33B33BęBffB  B  BBffBBffB  BffBęB33B  BBB33B  B33BffB33BffBffB  B33BffBffBęBřB  BBBęBBB  BffBffB33B33BB33B  B33B̙B33BffB33B  BϙBffB  BffB̙B  BffBffB33BB͙B̙BffB  BB33B33BB33B33BʙBffB33B  BBB33B  BffBffB33B  BƙBffBBffBBffBffBffB33B  BffB33BBffBffBBB33BB  B  BB  B  BBffBBB33B  BB  B  BffB  BffBBBffBBB  BffBBșBBffBffBffBBBffB33BBǙBffB  B33B  BffBB  B  BƙBƙB33BBBBB33BBffBBB33B  B  BBB  BBB33B  BffBÙBBÙB  BffBBBBffBBffB  BBB  BffBB33B33BB  BBffBffBffB  BffBffB  B33BB  B  BffB  BBB  BBBffBffB33B33B  B  B  BBBBffB  B  B33BB  BffBffBB33BffB33BșBffB33B  B  B33B  B33B  BffB33B33BB33BBÙBBffBBffBřB  BBffBÙBB  BB  B  BęBB  BęBęBffB33BffBřB33B  BBÙB33BBffB  BBB33B33B  BBBffB33BB  B33B33BffB  BB33B33B33BBBffBBBffBBBBB  BB  BB33BBBB33BB  B  BřB33B33BřBəBBBffBB  B33BB33BffBffBB  BBęBBřB  BBB33BB  BBB  BB33BęBffBB  B  BÙBB  BffBBffBB33BB33B33B33BBBBB33B33BffB  BBBffBffB33BffB33BBBBB33BBBBB33BffBBBffB33BBffBBBB33B  B  BBBffBB33BffB33B  BffBB33BffBB  B33B33BB33BB33BffBB  BffBffB33BřBBffBƙBBřB33B33BBffBB  B33B33B  B33B33BB  BB33BBB  B  BBB33BffBB  B33BBffB  BBBffBBB  B33B  B33B33B33BffBBBBffBBffBBBB33BB33B  BBB33BBBBBffBBB33B33BffBBBBffBffBBBBBBBBffB33B33B33B  B33B33BBęBBBffBBÙBB  B33B  BB  BffB  B33BBffB  B33BffB33BffBffBřBB  B33B  B  BffB33BffBffBBBÙBffBffB  BBffB  BB33BBBBBffB  B33B  BB33B33BB  B  BBBB  B  B  B33B33BB  BffB33BBBBffBffBffB  BBBB33BBęBffB33BęBffB  B33BffB  B  BffBBǙB  BșBB33B  B  BęBB  BBřB  BffBffBB  BřBBffBffBffB33BB  BffB  BffBffB  B33BffB  BBBffBBBBffBffB33BffB33B  B  B33B  B  B33BffB33B33BBB  BffBBffBB33BB33BBB33B  B  BBffBBffBBffBBǙBffB33B  BffB  BB33BffBB͙BΙB  BffB33B  BҙBәBԙBBffBיBؙBٙBB33BٙBffBؙBffB33B33BؙBBffB33BיBיBәBffB  B33BffB  BBЙB33BљB  B  BBB  B33B33B33BffB  BB  B33BffBffB  BʙB  BșB  B33BBəBffB  BəBƙBffB  BÙBęBB  BffBBffBffBffB33BB  BB33BʙBffBB˙B33BffBB͙B  BB  BffB  BB33BB  BBffBߙBٙBBיBB33B  BffB33BB陚BffBffB癚BffB33BBffB33B  B33BffB33B  B  B  B  BffB33B  B33BffBB  BBffBBؙBיB  BffB33BffBffBB  BffB  B33B  B  B33BB33BΙBffBԙBffBBBffB33BBffBBBBffB  B33B  BB  B  B  B  BffB  BffBBffBBBBBB  BBffBBB  BəBffBBffBffB  BB33BBÙBB33BffBřBřBƙB  BBffB  BB  BBB  B  BB  BBB  B  BB33B  BB33B33BBB33BBffBffBffB  BB33BBBB  B  BBB33BB  BB33B  BffBffB33BB  B33BffBB  BffBB33BBB  BffBBBffBB33B  BBffBffBBBffB  BB33BBffBÙBęBÙB  B  BffB33B33BBÙB33B33BBffBB  BffBęBřBBBƙBƙBÙB33BB33BęBB  B  B  B  BffB  BBÙB  B  BffB  BB33BB33BB  BB33B33BB33B  BBffBBffBB33B  B33BBBBffB  BffBffBffBBBB  BffB  BB33BBBffB  BBB33B  BffBB33B33BBBffBBB  B  BB33BBBB33BřBƙB  B33BffBBffB33B  B  BffBəBəB33BffBșB33BffB  BffBřBffB  B  B  BffBffBBffB  B  BBBffBB33BffBBB  BffB  BBBBffBB33BffBffB  BBBBBffB33BBB  BB  BB  BB33BffB  BffB33BBB  B33BřBffBffBBęBÙBęB33BffBBffB33BffBBffB33B  BBęB  BșBffB  B˙B  B  BΙB33BЙBBffBҙBҙBBffB33B  BљB33B33B  B  BB͙BffBBffBBBəB33BffBffBBBffBǙB33B  BB  BřB  B33BřBřB  B  BƙB33BffB  BB33BffBB33BffBffB  B  BęB  BB33B  B33B  B33B33B  BBřB33B  BBB33BřBƙBffBffBBʙBBB33B33B33BB  B̙B33B  B33BBB  B33B33B  B  B33B  B33B33BBB  B̙BffBΙB33BBB33BBB  B33B˙BBffB˙B  B33B33B  B  BB33B˙BBșBffBffB33BffBșBffB33BffBBęB  BffBÙB  BęBB  BÙB33B33B  B33BęBffB33B  B33BBffB  BffBffBB33BřB  B  B  B33BǙBffBřB  BffB33BșBșB  BșB33BffBffBșB  BB33BBBЙBffBљBљBBffB33BB  B  B33BffBBffBffBffBBBϙB33BBffB33BB33B͙B  BffBffB33B  BffBǙBǙB  BǙB  BffBșB  BB  B33BB33BBffBBffBB  BB33BffBBșBffB33BBffB33BffBBBffB33BBBffBffBffBBǙBB33BǙBǙBffB33BșBșB  BʙBffBffBəBffBBəB33B33B  BB  BB͙BffB  BffBffB33BffB33BffBBԙBԙB33B33BљBљBBffBB  B  BBffB33B˙B˙B  B  B  BʙB33BʙBBșB  B33B33B33B  BșBșB33B  B  B33BǙBffB  B33B33BffB33BșB  BBffB  BBșB33BB33BffBřB  B  BffBffBffBƙBffB  BB33BBəBəB  BB˙BBBffBffB33B33BBBB33BəBffBBffB33B  B33BffBЙBB33BB33BԙBՙB֙BBB  BffBffB33BBffB֙B  B֙B  B33B  BffB  BBBB33BffBB̙B33B  B  BffBffB  BBəBffB33BffBffBffBffBBffB33BBffBșB33BəBBffB33B  BffBB33BBffB33BffBB33BBƙBB  BffB33B33B  BB  BٙBB33BBffB33BffBBB33B33BffB  B  BۙB33BB33BB  BffB33B  BޙBᙚB  BB  B33BB  BBB  B33BܙBffBffBffB  BBBffBڙBB  BBٙB  BBBffB33B33B  BffBәBffB33B33BB33B  BB  BffB  BΙBBffBBəBșB  B33BʙB  BǙBffB33BǙBǙB  B33BffBffBřBBřBffBffBęBffBřBBffBffBffB  BB  BffB  B33B˙BffB  BffBffBffBB  BffBB  BBffB33B֙B  BB  BڙB33B33B33B  B♚B  B33BffBՙB  BffBؙB33BәBBBҙBffBיBffBffBBBЙB33B  B̙B̙B͙B͙BBffBB̙BffB˙BffBBB33B  BB  BffBffBBǙBffBƙBǙB  BBBffBffB33BBəB  B33BB˙BffBffB  BΙBffBffBffBB  B33BBBffBٙB  BڙB  BBffB  B  BffB33BߙBBB  B  B33B  B33BffBB33BffBBBBffB33B33BffBB33BffBffBꙚB  B33B晚BffB33B  B  B  BߙBB  B33B  B33B  B䙚BffBڙB33BBffBəB33BffBBB֙BٙB33B֙BffB  B33B33B33B  BٙBBۙBBffB33BB  B  B33B33B33B  B33BBBffB33B33BBBB33BffB33BffB  B33BיB33B  BBBB♚BffB㙚B  BB  B晚B晚BB  B  BBBffBffB  BBBffB  BB33BffBffBB  BB33B  BffB33B33BffBffBB  BffB33B33BיBݙBؙBיBffBffB  BB  B33BB  B33BB  BB33BffBΙBϙB  BB  B  B33B33B  B͙BϙBffB  B33BљB33BB33B  BҙBBBffBffB  B  BffB33BЙBffBҙBffBؙBיBffBBffB  BBBffBffBB  B  BᙚB  B䙚B  B陚BffBffB뙚B  B33B33BB33B癚B䙚BBffB䙚BffBBBݙBffBffBffBBffBB  BBЙBffBԙBBffBffB֙B  B33BB33B͙B33B33B33BB33BB  B33B  BffB33BBBʙBffBB  B33B  BffBəBB33BșBffBșBffB33BʙB  B˙B33BB͙BB33BffB  B33BBffBBffB  BBB33BffBffBҙBBffB  BBBffBffBЙB33BffBffB33BB  BԙBBB33BffB  B  B33B  BBBϙBЙBffBffBϙBϙBBϙB  B  B  B33BBffBB  BΙB̙BffB33B  BffB̙BffB33B33BffBffBΙBBffB33BffBBBЙBBBBffB  BB33B  BϙBϙBϙBϙBʙBBB33B33BffB˙BB  BΙBffBffB  BəBșB33BBʙB̙BBB33B  BB  B33BffBffBљBB33BffBffBBffBffBB33B  BԙBBәB33B33BffBљB  B  BЙB33B33BϙBffBffBBffBBљB33BB͙B33B  B  BffBBBϙBffB33B33BB  B  B  BBBffB  BB  B33BęBBffB  BÙB  B33BBBƙBřB  BffBřB33BBffB  BBřB33B  BřB33BęBřBB33B  B33BB  BffB33BřB33B33BB  BffBBBB  BBffB  B33BffBffBffBϙBҙBffB33BBffBBffBBB33BʙBffBʙBB  BffBffBʙB33BB33BffB  B͙BffBffBB33B  BʙBB  BBB͙B  B33BBffBffBB  B33B  BؙBffB33BB33BB  BBffB  BffB33B  B  BBBB  BffBؙBיBffB33BffBB  BB  BffBffBٙB  BٙBٙBffBBffBB  BffBԙB33BәBBՙB33B  B  BؙB  B  BffBBיBBffBffB33BffBffB  B  B  BffB33B33B33BΙB  BffBffB33BffBffBffB33BЙB33BϙBB33BϙB  BB33BB  B33B33BffB  BffBBB  BffBB  BB33B33B  BffB  BB33BBB33B  BffB  BB  BǙBBəB  BʙB33BffB  B  BB  B33BffBəB33B  BʙBffBffBΙB  BB33B  B  B  BffBBΙBBffB33BҙBҙBB33B33B33B33B  BΙBϙB33BB  B33BBЙBϙBBʙBBBB̙B33BffB33BffB33B33BffBΙBffB͙B̙BffB33BB  BBffB̙B33B  BʙB  B  BffBffBffBșBBB  BƙBșBB33B33BffBBBʙBǙB  B33BffBƙBffB  B  BffBffBBBęBffBəBB33BffB˙B  BB  BffB͙BffB33B33BffB  B33B33BB  B33BB33BÙBÙBB  BřBBffBB33BB33B  B33B33B  BƙB  B33BBffBęB  BffBBffB33B  BffB  B33B33BffBffBBBB33BBffB33BBBB  B33B33BffB  B33BB33BB33B33BffBffB33BffB  B  B  B  BB  BBBffB  BBffBBBBffBffBB  B  B33BBșBffB  BBffBBBffB33B33BBffB33BBB33BB33B  BBșBffBffB33BffB33BřBffB  BffBșBBffB33BǙB33BəBBBƙB33BffBffBșB  BB  BB  B33B  BBBB33B33BBBffB33BffBffB33BBffBBęBffB33BB33BB33B  BffBƙB33BƙBƙBBșBșBB  BffBBffB33BB33B  B33B  B  B  B33B33B  B̙BΙBffB  BffBϙB33B33BBBffBffB33B  BffB˙B33B  B33B33BB33BBBʙBʙBəBəB  BBʙB  BB33BșB33B33B33BffB33B33B33BřB  BBBęBffBffB33BffBffBƙB33B33BffBBffBBʙB͙BffB33B  BB33B  B  B33B33B33BffB33B  B  B̙B͙BBffBB͙B33B˙BBəBffBBffBəB33B  B  B  BʙB33B˙BffBffB  B  BB33BʙBʙBBB  BʙBB͙BB33B33B  BffB  BB̙BffB  B33BffB33BffB  BǙBƙBffBřB33BęB33BffBB33BB  BB33BBB  B33B  BB  BBffB  BBffBB33BB33B  BffB  B  BBffB33BB33BBffBęBffB  BřB  BffBBffB  BBB33B33B33B  BBʙB33BəBșBffBffBǙBffBffBBffB  B33C BC C33C3C CfCffCCLCLCffC  CfCfC33B  B  B33B33BB33BffB33B  B  BffC33CfCC  CffCBffBB  BBffBffBBffBB33BffB  BBBffBBB  BᙚBݙBۙB  BB33BޙBffB  BיBBffBܙBB  BBB  B33BffB33BB33BٙB  BffB  BڙB  BB33B  BߙB33B33B  BBB왚B왚BBffBffBffBBffB33BBBB33B33BC CCfC C
C	LCC CLC C CffCC CC CffC   B33BffBffBBffBB  BBffB  BffBәBffB  BffB33BffB  BffBיBffB33BB  BB  B33BffBәBffB33B  B33BʙBљB33BBЙBB  B֙BffBҙBffBҙB  B33B  BffB  B33BԙBBB  B33BB  BffBffBffBB  BB33B  BB33B♚B33B33B33BBBffB33B㙚BBB  B33B홚BB33BBB33B  BB  B  B33BBffBffB  B33B  B  BffB33BffBљB33B33BۙB33B  B33B33B33B33BffB  B33BəB33BffBffB  BșBƙBffBffB  BffBBffBB  B33B  BBBBffB˙BBffB  B33BәB33B  BBBffBB33B33BffBޙB  BffB  B33B  BߙBᙚBBffBB  B  B䙚BBޙBߙBCCLCLC  CC3C
C3CfC  C33C
C	C3CC CffC C3CC3CCfC B  C C  C BffC 3BBffBB33B33BffBB  B33B33B  BffBB33B晚B癚B33B㙚BffB♚BffBBffBffB33BffB  BB33B33B33BffBffBffB33BڙBffB  BffB  B  BЙB  BBߙBB  BBffB33B33BԙB  BܙBBffB陚B33BffBB  B  C C CC  CffC33C CCfCLC33C CfC3C
ffCC C
 C C3BffC33C3CfCCffC LCLBBffBBBffB䙚BffB33B  B虚B  BߙBffB  B  B  B♚B33B癚BBffBBؙB  B33BffBffB33B  BffBffB33B  BəB  B  BϙB33BB  BљBB  B  B33BffB  B33BffB33B33B33BڙBBffB虚BB  BB33B33B33BޙBffB  BffBB  B  BBffBB33BffBffB噚BffBffB  BB  BBB  BBffBBffB  BffB33BB33BBB33B  B  BffB  B33B  B  B  BϙBBffB  BffBffBffB33BB33B  BB  B33B33BƙBffBϙBBޙB  BBߙB33BߙB  BΙBЙB33B33BffB  BB㙚BffBBԙB  BBB  BҙBƙB  B  BřB33BBBBBffBBBffB  B˙B33BBffBBB  BB33BffBBBffBffBݙB33BffB33BBffB  B33B  B  BBؙBؙB  BffBBffBffBffB33BۙB  BffBffBffBffBٙBٙBٙB33B  BՙB  BՙB  BљB33B33B  B  BљBffBҙB  BΙB  BΙB͙B  BBffB  BΙB33BϙB  BҙBffB  B˙B  BBffB  B͙BffBϙBϙB  B33B33BffB33B33BffBיBܙB  B  BffBffB  B33B33BffBffB䙚BffBffBffB33B33B陚BBBBffB33BBB33BBBBBffBBB33BBffB33B33BB33BffBffBߙBffB33B  BBffB  B  BffBffBffB  BffBffB33BffB33BəBB  BǙBffBffB33BșBffB  B  BffB33B33B33BBΙBffBʙB  BffBB  BffBBٙB  BB33B33BBffBB  BBB33BיB  B33BffBBڙB  BܙBffB  B  B  BffBB뙚B33BBffBBBBCCCC3C3CC33BBB  BۙBܙB33BffB33B33B  BB  BffB  BffB33BșB  BffB33B  B33B33BffB͙B  BffB  B  B33B33BffB33B33BҙBљB  BB  BBffB  BffBBޙBҙB33BffBÙBřB33BBffBffB  BƙBffBBffBBBؙB33B  BBݙBffB噚B癚B33BffBꙚBB虚B陚BꙚB33B33BffBBBffB33BffB  B33B  BffB  B33BBffBffB33BB33B33BBffB33B뙚B33B33B33BB  BB왚B33BffB  BBffBffBՙB  BԙB  B33BϙB33BB  BԙBЙBΙB33B  B  B  BיBؙB33B33B33B33BffBљBffB33B  B33BBʙBffBffBBffB33BffBBB33B֙B  B  B33BBۙB33B33B  BϙBBBffBB33B  B홚BffB  B  B  BffBB  BB  BffBffB33BB33B33BB  B33B33C3BB  B33BBffBffBB  BߙB33B  BݙBB  BffB  B  B  BؙBәBBffBB  BB33B33BߙB33BffBBffB  B33BB33BB33BB  B33BB  BޙB晚BB  BB噚B陚B33BޙB33BffBffB33B33B  BᙚB  B33B♚B  BBffB  B뙚BffBꙚB陚B33BffBљB33B33BffB33BB  B33BB  B  BBBC B  BffCffC BffB  B33B  BBBB  BBffBffB  BꙚBB  BBB33B  BBB33B  BB  B33BBB  BffBffBffBB  BΙB33BB33BB33B33B33BəB33B33BffBřBffB  B  BʙBBB33B  B33BܙBffB  B  BڙBؙBB33BיB  BЙBffBffBB♚BffBffB  B33B33B33B33BB  BљBffB  BBffB  BffB  B왚B뙚B  B  BBffC 3CCffCCCfCLCLC33CCfC33CCLC  C 3BB  B  B  BB33B  BffBBffBBBB  BߙB  BBffBB33B  BʙBęBBޙBBBיBBBڙB  BffBB  BؙB  B33BԙBBB̙B  B33BǙBB  BffB  BșBffB33BBB33BBיBB33B  BffBB33BڙBٙBffBBffBffB33B33BffBؙB  B33B  B  BBffBBB  B  B♚BߙBBᙚBBBBffBB33BBᙚBBBffBffBffB  BܙBBٙB  BB  BҙBB33BəBΙB  B33BB  BffBəBBB33BffBBffBBBʙBəB  B˙BəBB  BffBBffBffB33BffB33B  BB33B33BffBęBB33BffBffBՙB33BffBؙB33BՙBB֙B33BBٙB  BffBBffB33B  BؙBڙBۙBffB㙚B  B33BffB  B  B33B33BBffB33B33BB33BBBffBBffBBffB33BffB  B33B왚B33B噚BBffB噚BB噚B  BffBB33BܙB  BәBؙB  B͙BB33B33B33BЙB33B  BՙB  B  BffBffBϙBB  B˙BBB33BB33BBffB33BÙBffBB  BB33B33B̙BϙBffBffB33BљB  BәB33BffB  BBffBB33B33B癚B虚BffBB  B  BB33B  B33CfBCffBB33BB33BB  BC33CB33CLBffCBB  B33BBffBBB  B  B  BיB♚B  B33B  B  BffBB33BffB  B33BB33BBBffB  BffBffBffB33B  B  B  BBәB  BBffBffBЙB33B33B33BB33BBffBffBəBB˙B͙BBB33BBffBBBҙB  BffB֙BB֙BBB  BffBߙBffB  BffB  B33B  B왚BffBffBB33BB  B陚B虚BBffBffBffB  BBڙB  B  B  BB  B  BߙB33BB33B  BffBݙB  BڙB  B  B  BffBB  BffBB33B  BB  BәBffB33BBBffBBffB33B  BB͙BffB33B33B˙BB33B33BәBBffBffBB33B  BffBB  BffBB֙BffB33BיBffBB33BB  B  BffBBBBffB噚B  BBffBffBffBBB홚BffBffBBߙB䙚BBBBB虚B33BB33BB왚B왚B33B왚B33B33BffBB  BڙB  B  BffB  BffB33B͙B  BffBBҙBәBԙBffB33B33B  B˙BΙB  BffBffB  BBəBB33BǙBBǙBffB33B33BB33B  BBffB  B  BffBǙBBBffBffBBffB  BffB33BB  B  B33BB  BffBBffB  BBB癚B33BB33BBBBB  BffB33BC LB33BffB  BҙB  BffBffB33B33B33BffBffBBB噚B33B噚B  BᙚBffBB33B  B  B33B  B33B֙BBffBB  BB33BBBB33B33B  BffBBffB33B33BBffBffB33BBB33BBBÙB  B  B  B33BffB33BƙB  BffB  BϙB  BffB33B  B˙BB  B33B  BBBffB  BB  B33BBBffB  B  BffBBB33B33B33BffBffB䙚BffB  BBffBB  B33BffB  B33B  BBBffBB晚BffBffB  BffBBٙB33B  B֙BЙBBљBB  BffBBffBBB  BffBřBffB  BffBffB33BffBǙB˙B33B  B͙B  BB33BęB  BffBffBBBB33B  BęBB33B33BBΙBBB  B  BffB  BBBBffB  B  BBљBffBffBљB  B33B33B33BԙBffBffBffB  BB33BЙB  BffBffB  B  B33BB33B  B  B33BBB  BffB  B33B33BffBB33BffB̙BșBffB33B33BBB  BffBBBBffB33BB33B33BB33BB33BffBB  BBBB33B  BB  BBB33BBB  BB  B33B  BBB  B33B  BB  B  B33BBffBffBffBB  BB33BBBffBffBffBB33BB33B33B  B  BffB33BffB33BߙBBؙB33BffBۙBffB33B♚BffB  B33BBBffBᙚBBߙBffB  B33B  BBBՙB33BffBB̙B  BÙBffB  B33BffB33BBffB  B  B  B  BffBBBffB  B  BƙBřBBffBÙBffB  B33B33B  BffB  BB33BǙB  B  BșB33BffBBffBǙB  BǙBBB  BB33BřB  B˙B33BBҙB  B33B  BٙB  B  BBffB  BffBffBffB晚BB33B  BffB33BffB33B33BיB˙B  BșBffB  BBϙBffB̙B  BffB͙B  B  BřB33BřB33B33B33B33B  B33B  B  BffB  BffBffBffBffB  B33BBffB  BffB33B33BBffBffBBBBBBB  B  B33BBBffB33B33B  B  B  BəB  B33B33BBB  B33B33B33BffBBڙBBB  BffB♚B  B噚B噚B癚BffBffBffBB  BB  B33BB  BBB  BB  B  B  BBffBBꙚB  B  B33B33B33B33B㙚BffBffBؙBB33BљBBffB33B  BB  BڙBBffBBffBB33B  BB33BBޙBffBffBffB  BB33BϙBB͙BffB  B˙BffBəBB  BBBffB33BęB33BffBffB˙B  B  BΙBffBBffB  BЙB33BffB33B噚B  BffBB33BBB  B33BB33BBBBffB  B  B  BffB  BBB33BBffBB  BffB䙚B33BܙBBffBݙB33BݙBffBffB  BBBffBBؙBBBffB  BљB  B33B  BəBęB33B33BffBffB33BBffB  B33B33BB33BffB33B  BffBBffBffB33B33BffB  BffBǙBǙBBffB  B͙B33BffBffBBڙB33BBՙB33BffBB33B뙚B33BffB  B  BB33B陚B33BffB33B  B33BffBB癚B33BB33BB33BꙚB  BffB33BՙBB33B  BؙB  BיB֙BBЙBB  B˙B33B33BffBB33BșB33BƙB  B33BffBBB33B  BffB  BffB33BBffB  B  BffB33BB33B33BB  BBB33B  BBB  BffB  B  BffBBB33B33BB  B  B  B  B  B  BB33B  BBBB  BffBBB33BffBffBBBffB33BB33BBffB  BBB  BBBB33BBBBBffBffB33BffB33B33BffBffBB33B  B33BffB33B  BffBBB  BB  BB33B  BBBB  B33B33B  BffB33B  BBBB  BffB33BBB  BffB33BBBffBBffBB  B33B33BBBBffBB33BffBřB33BBB33B33BBBffBBB  B33B33B  BB  B33BffB  B  BBBșBșBffB  B  B  B  B  BB33BffBƙBřBffB33B  B  BffBB33B33BffB  BffB  BffBBBB33B33BffBffBB  BBBBB  BffBBffB  BBBffB  BBBBffBB  BffB33B33B33BBB33BB  BBffBB33BB  BffBffBffBÙBBffBBffB  BffB33BffBB33BffB33BBϙBB̙B33BʙB33B  B  B33BʙB33BBffB33B33B33B˙B  B33BffB  B33B  B  B  BB  BșBBB  BffBęBffB  BffB  B  B33B  B33BBffB33BB  BBB  BffB  BB  BffBB33B33B  BBBęBB  BffB33B  BBB33BBffB  BffBęB  B33BșBƙBÙBB33BBƙBřBʙB  B33BffBBffBffB33BBffBB  BffB33B  B̙BBffBffBBBB  B  BB  BffBffB  B33BřB  BƙB33B33B33BBffBBffB̙BffBffBřB  B  BffB  B33B33B33BЙB  B  BәBffB33B33B33B33BBffBffBffBܙB  B33B  BffBBffB  BffBB33B  BffBB  BffBB33BٙB  BBB33BffBffBffB̙B  B  BffBәBB33B33B33BffBڙBߙBffBBffB33BffB  BffB  B33BffBB  BBffB  BffBBBBffBffB33B33BffB33BffB33B33BffB陚B33B  B虚B33BꙚB33B癚B  BffB33BB  BB33B  B33BBffBffB  BBߙBB  BffBffBB㙚BBB33BᙚB  BffBܙB  BؙBBٙB33BB  BBffBBffBBיBՙBיBffB33B33B33BB  BљBԙBffB  BffB33B͙B33BffBBB33B33B  B  B  BBffBB  BBBffB33BB33BffB̙B33B33B33BBffB  BffB33BffB  BBϙBBřBffB  BffBffB  BffB  BffB̙BffB˙BffB  B  BBЙB33BB  BB33BBffBBffB33BϙBffB͙B  BB  BBBЙBәB  BBffBffB  B33B  B33B33B  BB  BffB33B33B  B  B33B  B  BffBffBBԙB  B  B33B33BffB33BBBB  BBffBҙB33B  B33B  BffB33B  BffB  BffB33B33BߙBB33BffBBBBffB  BffB  BffBffB  BffBBB噚BffB33B33B虚B33B33B  BB왚B  BffB왚B  B33B33B  B  B  B33B㙚BB33BffBffBffBffBffB  BB33B噚B癚B33BB뙚BBffB33B癚B癚B癚B33BffBffB33BޙBߙB33B  BBffB  B  B33B  BB33B33B33BљB  B  BB  BBBffBffBBٙB  BיBffBԙBԙB  B  BffBBffBB  B33BәBәBBљBB  B  B33BəB33BǙBљB33BЙBB33B  B33BffB  BB33B33B33BBҙB  B33B  B33BffBffBffBffBB33B33B̙BffBffB33B  B33BffBffBB33BəBffBB  B  B  B33B  B33B33B33B  BffB33B33BәB33B  B33B33BffBיBBffBBBBffB33BBϙB  B  BB33B  BffBffBؙBBיBBffB33BffBBBҙBffBϙBffBffBΙB33B͙BB͙BʙB  B33B33B  B33BffB33B͙BffBffB33BffBΙBffBǙBBffBB33B  BB  B  BBffBB33B33BffB33BBffBB33BffB  BəB33BB  BB33B  B  BffBB33BffBB  BffB  B33BffB  B33BffB  BffBBB33BffBBB33BBBBBBBffB33BffBBBęBB  BffB33BBffBffBBᙚBffB  B  BBffB♚BB  B  B晚BffB♚B33BffB  BޙB  BߙBffBB♚BB  BffB33BٙBffB33BߙBڙB  BffB  BיB33B33BڙBffBBљB  BffBB33BffB  BЙBBBBęBBB33BB  BffBffBB33BB  BBBffBBB˙B33BffBBəB  BffBffB33BЙB  BǙB˙B  B  B  BffB33BBffBBffBBBęBffBәBљB̙B  B33BffB  BəBșBƙB33BBBBffB˙BffBffB  B33BffBBB33BBffB˙B33BBffB33B33B33BΙBəB33B  B  BffB  B  B33BBBffBęBffBBB  B33BBBffBffBҙB̙BB͙BB  BBffB33B33BffBffB33BffB33B33B  BǙB33BǙB  BǙBffBffB33B33BǙB33BșB  B˙BBBBǙB  BffB33B  B  B˙BʙB33BB  B33BB  B33BBBBșB  BBBBffBffBB33BffB33BB33BffB33B  B33BBBffB  BBffBB33BffBffB33B  BƙBřB  BffBBBffBřBffBBșB33BƙBB  B  B33B˙BffB  BB͙B  BB͙BəB  BBBB33B33B33B˙BB  B  BBBBffBffB̙BϙB33BffBBșB  BffB  BffBƙB  BB  BB  B  BffB  BffBBffBBBǙBffBffBșB33B  BBB  BffBB  BB33B  BBBB33B33BB33BBBB  BB  BB33BffB  B  BB  B  BBB  BB  B  BffBB33BB33BBffB  B  BB  B33B33BBʙBʙBʙB  B  BffBʙBB33B͙BffBffBffBffB  B33BffB̙B33BffBBBffB33BBәB̙BBBBǙBB  BǙBB  BBB33BffB̙B  B33B  B͙BB̙B  BffB˙BBBffB33B  BB33B  B̙B  BffBffB33B  BB33B  BffBB˙B33BљB  B33BBB33B33B33BffBffB  BffB  B33BB  B͙B͙B33B  B  B33B˙BʙB33BffB  B33BB  B  BffBBffB  BB33B33BϙB33B33B33BB  BϙBΙBΙB33BB  BҙBBffB  BB  B33BBΙBΙBffBB  BBəBBffBBffB  BB  BBB33BBBffBffBB  B33B33B33BřBffBffB33BffBB  B33BffBřBƙBƙBřB  B  B  BBB33BÙBșBBB  BB  B  B  BB33BffBșBBBBBB  B33BB͙B33BљB33BBBB  BB  BB33B  B  B͙B˙B  B  B˙BffBffBʙB33B  B33B  BəBffBB33B33BșBB33BB33BB  BBÙB33B  BffBBBÙB  BÙB  BǙBșBffBșBBffBB33BBffB  BB  BB  BffB33BʙBƙBffB  BffBB  B33BffBǙB33BƙB33BffB  B33y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AQAAffAzA¸RA
=A
AAffA
AAģAƏ\AffAA{AffAzAģAĸRA=qAď\A
=A33A
=ApAGAAƣAƸRAŮAȏ\A{AQAQAffAƏ\AAA(AffAŅAřA33A{AÅApAHAAHApAA\)AÙA{AîAAA£A(AAzAAQAA
=A(A{AApAGAŮAGAA{AA\)AAƣAAAAffAAď\AA
=AAîAHAGAA\AffAA=qAGAGApAA
A\AHApAA{A(AA\)A\A=qAQAQAAA
AAA(AAGA\)AAŅA\)AA\A¸RAAA
=AffAffA33AA  A  AffA
AƸRAA33AAƸRA(AAzAƏ\AAzAzAîA=qA{AA
Aď\A33A=qA{AGA
=ApAAA=qA(Aď\AîAA\AA
A\AQA(AA\A=qAAAģA=qAGAzA
A
=A
=A=qAzAÅA
=AApA{A  A¸RA=qApAA¸RAQApA
ARA33AA=qAzAHAHAA  ApAƏ\AA\)A\)A=qAÅAĸRApAffAAAȏ\AǅA(AAAffA{A(A33AHAĸRA£AAAQARAAzA
=A  ApA=qAîAÙAHAQAřAHAzAzA  A  AA(AƣAAGA(A{ApAAQAAAApAApA  AAAAAAGAA\)A=qA  A=qAA=qAQAAA\)A33A\AA33A\)AAA
A\)AAGAApA{AQAAffApAAzAHA
AGA33AGAAAAAA
A\)A
=AA
AAAAAzA{AAA\A\)A=qApAQAAzAA(AA{A
=A
=AA\)AAAA
AHAA=qAQAAffAAffAA\)AAA  A(A\AA{A¸RAHAGAAģA\)A{AQAƏ\A  A{ApAAffAĸRAGA
AAHAAAzA¸RAzA
AGAzAA\)AzAƣAHA
=AÅA{AQAîAQA\)A=qAA£A
A  A
AĸRAHAAA(ApA33AAAffApA
=ApA(AAA(AHA=qA  AƏ\AAQAAHAApAA=qA
A{AQApAffAAffA\)AîAzAÙApAA\)AQA\A33AAffAAffAA
A  AAAA{AA
=A{AzAÙAAGA
AģA
=AŅA\)AGA\)AŅAAAA(AzAGAģAA(A=qA
AA(AHAzAffA(A{AAA
=AAAHAĸRA\)AAGAHA\)A\)A33AAffAÅAƏ\AAȣA
A
AzAȣAAȣApAQAAƏ\AAffAǮA33A\)AǮAǙAAƏ\A\)AAffA
=AHApAƣAHAGAĸRA(AAHA
=A{AQAAAď\AA(AHAHA=qA(AƣAffAƣA
A
=AHAAAGApA
A{A{A{AŅApAGAGA
=AĸRAîAAffA
AAAAAÙAÙA\)AGAA(AAAffAA¸RA{AAzA
=A\)A\)A  AĸRA{AA=qAHAAď\AřAƣA33AAƸRAffAffAA
=A£A
=AA33A{A
AzA(A\)A
=AAGAAAHAA(ApAApA
A
A
=AAAA\)A
=A\AAA
AzAAA\AAA
=AAA\ARA
AA
=A\)A  A
=AAAA  AAAAA(AAAA33ARAGAA{AA\)ARAffAA(AA{AAARAGA
A  AA
=AHAAAAA\)AzAQAGARAA(AAAA
A33AAAAAHAzA\)AAAA
=A33AAAAAAAffAAAAAAHA=qAA
A\)A  AffA
=AffAzAApA  Aď\AřA33A\)ApA
A  A(ApAAĸRAAA=qAffA=qAģAffAHA
=A  A(AHAQA=qA\ARA{AAzApA\A\A(AA{A{AAGAA=qAAA\)ARARAAA\AzA\A\A(A
=A\)A\)A=qAffAAAGAA\)AAHARA33AAA\)A{AAAAAA
A  AA(AAffAAzARAffA(A\)A
AAffAA33AAAGAGA\)AGAAAAAAffARAA
=AAHAAAffAzAQAzAA
=AAGAAAAzAAAA  AA{A{AffAď\AffA
=AÙA  ApAzAzAzApApA\)AAQAAHA\)A
=ApA
=AAQAGAzAHAAAzAA=qAffAA33AA
A(AARAzA=qARAAAģA=qA  AA(ApAHAGApAA
A  AzA
AA(AAGAAA\)AAA33AA\AzAzAA  A
AQA{A  A{AQA(A\A\AA  A=qAA{A(A{A  A{A=qAA
=AAA
A(AAQA\)AA
=AGA(A\A\AAzA{AAAA
=A=qA\)A(AzARAAQAHA
ApAAAAHA
AGAAA\)AffAA
=A
=AAQAGApAAA
=AA33A=qAA=qAAffAffAAA
=AA33AAAAGAHA33A
=ApA{AApAAAAAAffAffAffA=qAzAffAA
=AffAAAQA\)AAAzAAAA
AA{A
=AffApAA=qAÙAA{A{AQAAHA\)A{ApAAA\A{A{A{AA(A
=ARA\A  AHAAGAA\)AARA
=A{A33A33A(A{AQAHAA\)A
=AA¸RA
=A33A\)AÙAÙApA
AîAA(A(AQA{A{A{A{AA
AA\)ApA\)A\)A33ApAA
=AAA\)A\)AÅA
AQA=qAGA(A¸RA=qAAA
A{AA=qAA
=A\AHAA  A
=AA=qAAHA£AGAÅAHA¸RA
AzA=qAA\)A(AzA\)A\)A
A33A
AA£AAARA¸RA=qAAARAQA  A(AA33ARAffAAzAAAAGAÙAÅAÙApAA33A
=AAAAAAA=qA{AffAHA£A(A
AA33A33A
=AApApA
=A£AAAAffAAQAApAAffA=qAA\AHAA
AAA=qA(AAQApAAHAA
A33A\)AGAAAHAffAHAQAffAHAAA\)A
AAffA{AffA\A{AA33A33A33AAzAQA=qAGAQAApAA\)A33A
AzAAAřAA(A{AƏ\AƣAAAƸRAHAAA
=AAƸRAƣAHA
=AƣAAQAAŮA\)AřA
AA{A\)A33AA{A\)A\)A
=AǅA\)AA\)AAzAAAȏ\AȣA=qApAƸRA
=AHA\)A
=A=qA{AffAffAAffAģAģAAģA
=AAģA(A\AAGA£AQA(A\AQAzA\A  A
A\)AA33AApAHAA33A
AA\A
=A{AĸRAģAAApA
AGA
=AA\AA(AAA{AA=qA
=A\)A
A33A=qA\)AA
AA  A
A{AAA33A\)AAzARAAAzA\AffAQAffA
=AA\AHARAAAAAzAffAAGA
=AA\ApAƸRAAzAAÅA¸RAA\)Aď\AAÙAHAGA\A33A
=A  A£AQAzAHA33AAApAAA=qA=qAzApA(A
=A33AAAA(A
=AAzAzA{A\)AAAAA33AzA=qAffA
=A=qAřAAƣA
AŅAřAAAQAzAAA
=Aď\AHA(ApApAA=qA
=AQA
=AHAA(A{AA(AA\AA
A{A
A{AffA£A£A\)AîA  A=qA{A{AzAģAģA{A=qAGAQA  AAď\AA{AHA=qA=qAA=qA{A\)A  AA  AffAQAQAGA33AA(A33AffA
AA  AA
AģAzApA33AAzAA\)A(A
=A
=AA{A
A
AzAAHA33A\)AÅApA\)A\)AGA
=A33A33A33AA33A33AA£AA=qAA{AzA¸RA\)Aď\A(AÅAď\AAHAHAffAĸRA\)AA\)AģAAģA
=A
AAĸRA\)AGAzAffA\AffA(A  A\)A\)AGApAAGA(AAAA33AA
ARAffAAA\AffAAzAHA  AA\AQAffA(AHAAffAA(AAAzAAGAA  A\AAGA\)AffA\A=qA(A¸RAAA  A=qA{AA(A{AffA33AAAÅA{A
A¸RAHAAA{AApA{AzAGAA
=A
AGAAffAzA  AAA
AQAA
A
=ARAGA(AzA
AAARAApAA=qAAHAA{AHA
=AAAÅAffAA(A(ARA  AAA\)AGAAAAAAzApAAAHAApAHA\AzAzAQAA
=AAAzA\)A
=A
AA{A
=AARAA(AA
=AAARA
=AAQA  A(A(AQAHAARA  AffARAA{AA
AQAAQAAQAAA  A  A=qA  ApARAGAA=qAAzAA=qAA{AAAHAHAA
=AAAApAGAA(AA\AAARAQAHAA
AzAzA(AAAzARAAAARAHA  AAAAAzA
=AAQAA(A{A\A£A\A(A{A
AGA\)A33A(A{ApA
=A¸RAÅAffA£A
=AAA(AQAA\)A(AGAQA¸RAÅA(AĸRAffA=qA{ApA
AAHA¸RAGAA  AGA{AAAffAAARAAGA
AHAHA=qAQAAAA{ApA33AîAQAAģAA¸RAGA  AQAAAGAzAA33AAHA{AAAzAA
A{AAzAA{AGA33AA(A{AAffA  AAĸRAAîAAAGA{AģAAA\)AA\)A
AzA{AA=qA(A\)AîA33AQA(AHAAAA{AQA(A  AA33AA\)AAGAA
AîAîAîAAAAzA\)AAAAGAQAAffA(A\)A  ApAA(A  AffAffAAAHAAQA\AAAffA=qAHAApAQAAA(AQAA\)AA  A=qAffAQA  A\)AAA
=AAHAAAAA\)A  A=qAQAAAA=qA
A33AA  A\A=qAAQAAHAAA  AARA33A33AAAAÅAffAQAAA  A33AGAApAA
A
A  A
A\)A=qAA  ApA=qApApAffAAA
AAAA=qA=qA\A\A{A{ApA
=AAA
=A
=AApAA£AAQAĸRAA\A{AA\)AA=qAQA  A33A33AAAAA\AQA33AAA33AAGA  AA  AA\)AHAAA  A\)AA\AA
=A\A\)AGA
AAAAffA\A=qARAA\A{AA  A33A(AQAHAGAGApAA{AQAAzA\)A=qAîA\A=qA\)AAARAQA\)AA=qA\A(AAQA  A33AAzAAARA
=AA(A\)AA
A
A  AzA\AAA33AffAAA33ARA
A\A33AffAHAA\AzA(AApA
AffAffAAffAAzA=qA\)A{AzA¸RA
AGAAA
AAA
=AffA
=A{AA¸RAGA  A
=AGAzAA=qAAAA¸RAA33AAA{A{AQAîA(A  A(A\)A\)A{AA=qA33A=qAApAHAAA¸RAA33AA
A  AGAA  AHAAAApAA{AzARAA\ARAzA=qAffAAA33AAAA=qAAAAAGA33A
=AA(A\)AHA
AîA
AřA\)AŅA{A\)Aď\AÅAGA33AA=qA
=AŅAŅApA{A  AA
AřAQAA  AGA  AHAAGAzAQAffApAQAA33AAA=qARA\A{ApAA\ApAAA
=AApAAQAAAA33A
=AQAffAAAQA\A(AHA
=A¸RAAAAAAAA\AffAGAA\)AÅAřA
=A=qAģA=qA  A  AîA
AA{A=qAffA{AzAGAAAA=qAŅA(A=qAŮAzA  AHA=qApAHAApAAAA(AHAffAAAAAA=qAAHAA\)A  A\)AHAffA
AHAA
AA
=AHA(A\AAA=qA\AApAffAQAffAGAÅA{AA33A¸RAAHA33AAGA33AAA
=A33A\)AGAAAAAAA\AQAQAzAAAHAQARA  AAAA¸RAAAÙAîAÙA=qAHA33A33AA
=AA
=AHAAģAQAÅAGAGA  AAA=qAHA£A
=A\)AAAAGAA33AA{AAAAÅAzAA(A{A(AHA
=A  AHA
=AQA  AAAzA\A
AA33AffA=qA{ApA
=AAA\AGAGAQAAA(AAA
=A  AAAHAAA(AAHA
A(A\)A\AA33AAAQA33AAQA\)ApARA\A=qA\A33A\AGA£A£A(AGA
=AA
AAQAARAAAAA£AA  AĸRA(AA\)AA
=A\)ApAAA(A  A
AQA
=AARAAAGAQA  AARA{AzA=qAApA=qAGAA=qAGA{AAAHA(A\)A{A33AGAApA\AHA=qAAA
=ApAGAA
AAHAffAA33A{AQA
=AffAÅA{AzAAAA  AzAQA{AAGAAřA
=A  A  AAAA¸RA
AA
A
AAǅAApA
AǮAzAzAzAǙAAGAGAŅAHA(AHAAAA\)AAAA£ARA(A
ARA  A(AAîAAîA{AQAA=qA=qA¸RAHAGAGAffAA(AAA\)A33AÅA
AAA  AzAď\Aď\AĸRAAA
=A
=AĸRAĸRAřAAģAApAHAzA£AAAÙApAA
=ApAÅA\AQAĸRAď\AŅA  AA=qA
AŅA
=AffAApAGAHAA
=A=qAAAAQAA=qAA(AA  A33A{AHAAAAHAHA\A33AHA\A33AzAHAGAARA
A
A33AApAA
=AA(ARA
=A
=AGA33A\AAAAApA{AAA(AAAA\)AzAA\AA  AAA(A
AzARAHAAA  AAA
=ApAA\)AA\)AA{AzA
=AAAQA=qAAAAApARAAGAA{AAAA\AAAAA  AffA\)ApA
AApAAffApAA33ApAAAQAAffApA
=A\A=qA  A
=ARA(ARA{AffA33A=qAAA
ARAAA33AA\ARAGAAA{AA{A33AGAAGA
A
AA33A\AA
=AARA\ApAAAA
=A{AQAGAQA(AAGAGAA=qAAQAGAA{A=qA
AffAGAAAzA\)ApA(AAAQAffARA=qAA\AA33AHAApA
AA{AAA33AzA\)AARA33A  AARAzA\)AAApAAffA=qAAzA33A
A=qARA33A\)AAffAffA=qA
=AHA\)A
A\AA  A(A  AAAzA{AA33A
AA(AAAHAApA33A
A\AA=qA=qAA
=ARAAA{ApARAA(A=qAA\)AA33AA(AAAAAA{A{AzARAAAA
=AQAAA
A\)AA{A  AzA33AA\A33A\)AA=qA
AAQA
=A(A  A
AA=qA\A=qAA\AQA=qA\A\AQA  AffA  A{AffAA¸RAzAA33AA33A{AAÙAAĸRA=qA
AAA\)AHAA
=AAA(AA{AA\)AGAA33AzAAîA\)A\A33AffAApA
=AAA\A33AAAAAA\AA
=AGA\A=qAAGAAffAAHA\)AA=qA\ApAHA  AA\AzAGAA=qAAAAAA
=A=qAAƣA33AǅAAA{A(A(A=qA=qAQA(A(A{A
AA\)AAƣAffAQAzAŅAffAQApAîAQA  A(AAģAÅA£ApAQAARA33AGAAA\)AzA=qA=qA
AA{A
ARA£AGA\ApAîAAď\AA\)AAAAQA¸RAAA¸RAGA=qAGAA33AAAAffAAzA\AÙARAHAGAAAA¸RAzApAŅA
AHA33Aď\AA=qAĸRAAAGA
AffAƸRAƏ\AffAffAzAzAƣAƏ\AŮAŮAřAŅAŅAŅA33AA\)A
A{AÅA¸RAÙA33ApA(A\)AzAAÙAGAQAA{AAAGAA  A
=A
A
AzA\AAA
=AA\)A(A£AffAzAGAA{AA  AQA33AffAA{A
=A(AA  AA\)AAAAA
ApA
AA{A£AÅAîAA=qAĸRAHAzAHAHA33AAGAGApA\)ApA33AŅAřAŮA
A
A  A=qA(AQA(AŅAAAHA
=A
=A33A\)ApA\)AQA\A33AA33Aď\AffAĸRAď\AÙApA\)AA£A
=AQA=qA33AQA\A
=AÙA  AA(A  A{A{AîAÅAÅAGA
=ApAQA
AffA£A\A
=AîA(AGA33AzAAA£AA(A
=AAA
AAGA
=A  A\AAQA\)AAGA  A\AAzAAAApA33ApA(AGAAffAffAÅAAA=qAAA=qAAAHAQAffAAA\A\AffAApA
ApA(AAzAAAARA=qA
=A(A=qAA(AQAzAAffA
=A\AzAQAAQAGA=qA\)AA\AAzAA
=AAQAA
AQAA=qAAAzAAffAAzARAzAAAffA
=A\)AGAAAA\)ApA33ApA33AQA(A33A\AA  AAApAAAA(AARAARAHARAAHAzApA33ARAA\A
AAA  AffA(A{A{A=qAARAAAAQAHAA
AAA
AAAA{A  AQA
AQAA
A  AffARA{A
ApAGAHA  AAAHAARAAzAAA  AffAzAAA{A{A\)AAA
A(AApA
AQA
=AA
=AHAA(AAzAAHAzAAA{AA\AAAA
AA(AQA  AA  AAAAAQAA\)AzAAA
=AA\)ARAA\ARAHAAA
A(AA{A=qA
AA(AAA\)AHAAffA  AA=qApA\)AAHAQAAAGAffA\AAQAGAAAA33AQAAAAQAQAA{AAQAAffAA{A  AA{ApAzAHAA\A(AQAHApA¸RA{AzA33A33A{A(AffAƣAQAHA
=AA33AGA=qAəAffA=qA(A=qAAǙAGAƸRAzA(AřAQAƣAApA=qA33AzAǮAǙA33AǙAǮAAAAAřAzAŮAQAAƣAzAģA
=A
A£Aď\AffAŅAffAřAzA  AHAHA{A
AAîAď\AA£AAAA\AA{AAAAAQAGA33AAzAAAGA\A£A=qA{AQAzAAGA\)A33AAģAď\AGAA{AƸRAƸRAƏ\AƣAffA
=AƸRApApAffA(A
=ApA\)ApAɅAəA\)A33AA33AGA
=AHAȏ\AffA=qA{A  AAǙAǮAǮApApApAAAAzAQA{AAƏ\A
=AǅAAƏ\AzAA(AřAƣA=qAzA{A33AŅAQAA{A{AĸRA
=A
A
=AAď\A33AGA
A£A¸RAffA\)AÙAA
=AzAÙA(A\)AA\)AHA  AHAA(A  A=qAzAzAAA  AAřAAAQA{AƏ\AřAřAģA(AA=qAƏ\A\)A{AA  A=qAffAAǙApA=qA\)AƣAAzAHAzAAGAƣA{AAAGAAƣAA33AƸRAAAƸRA
=ARA(AǅA\)AAQAGAAAÙAffAAffAAAQA
=A=qAQAA(A(ApA\)AAA  A\AAAQAřAzApA=qA
=AəA{A  AɮAɮAA{AffAQAffAzAʣAHAAGApApA33AA33AAʸRAA
=AHAAzAʸRAʣAAɅAəA33A\)AAřAAAA{AA=qAA
=A
=AHAA  AA\)AģAģAHAHAģAzAAÙAQAffAffAAffAQA(AApAÙAQApAAQA
=A33AAAA{AARA
=A¸RA\AffAA=qAzA¸RA33AA=qAřA  A
AQAAAƸRAǮAzA=qAȏ\A
=AɮApA
=AGA33A33AHAAAGAGA\)AɅAɅA\)AGAɮAəAzAřAAģAřAŅA(AHAAAQAffA
A33A
A{A33AApAŅAAHA(A  A{AAQA(Aď\AffAzAHAď\AîA(AÅAA33A
=A¸RA\)AAÅAÙA(AAGApAQAAAA
=AffAA{AGA=qAAffAHAÅA=qAHApA(AzAAAGAǅA\)AGAǙA\)AA
AQA=qA(AA
A
A
A
A{AǮAA{A=qAQAzAffApAƸRApA
=AA{A(A¸RA
=ApA£A(A
=AĸRAGA¸RAQAƏ\A33AGAAƸRAƣAffAAA  A33AHAA
=AAĸRAAAĸRAAď\AAď\Aď\A=qA  AQAQA=qA(AQA
AîA(AA\)AAAAAffAGA\)A
=ApARA
AHAAffAĸRA
=A\)ApA33AAA33A
=A
=AřAQAHA33ApAƸRA(AAƸRAA33A
=A33AA33AǮA{AffAȏ\A  AA  AŅApAĸRAď\ApAģA  ApA
=AARAzAA£AA\)ApAApAA33ApAGAA  A
AAQAzA{A
=A\)AĸRA=qA=qAHAA33A\)AîAQApAÙA¸RA{AzAA33AAAHA=qAQA{A  AffAHAAffA
A  AAA
A¸RAGAA\A33AÅAffA\)A{A=qA(AQAzAHA33AǮA  AǮAAAAApAGAAA\)A33AA(AAAQAAîAAApA
AĸRAîAzAffA\)A33A  A
A(AQAď\AzAzAA(AÙAA
A
A{A\)A  AGA¸RA\AQA(AA(A\AAzAffA{AA33AzAHA¸RAQA\A
AA\)AA
=A33AffAHAA\AA
A(AHA(A¸RAÙAAzAAŅAŅA(A
=AAApAřAGA
A33AGAAffAffAzAʏ\AHAA33AGApA˙A˅AˮA˙A33A33AffA=qA(A{A\)AȣAA{AHAƸRAAřApAzAQAQAƣAQAzA=qA  A
A\)A{AffAHA(A=qAAffA(AAAQAÅA33AQAÅAAAA{A
A
A(AAHA=qAHAAAffAA(AAzAAzARA
=AA(AffA¸RAGAHA=qA{A=qAzAQAffAģAAŮAAzA33AAAAƏ\AƏ\AƣAffAffAQAQA(AffAffA=qA  AŅA\)A
=AHAď\AffAAA{AÅAAÅAQA{AA\)AAîAîA
A
=AÙAA  A{A{ApA{A(AÙAÙAAîAHA(A¸RA£A¸RA33AAHAA£AHAGAAAGAffA(AAAARAQAzAzA
=AAHAAAAA{A{AAA{AzA33AA{AĸRA33AŅAŮAA{AffAƸRAQA=qAzAHAAAHAAAAA
=AAƸRAAzAƏ\A=qAQA{A(A(AřAffAQAAǙAGAA33AŅAřAřAAAA33A
=AĸRAď\AĸRAģAAģAQA=qAffAď\AffA  A{A=qAQA=qAzA{AAAffAQAzA\A¸RAAAÙA{A{A=qAQAď\A(AAĸRAHA
=A
=A33A
=A\)AřAAQA33AQA=qAffAîA
=AGAÅAAď\AA\)AřAA(AzAƏ\AƏ\AzAƸRA
=AAGAAA
=A
=A
=AA
=AAAAAAƣAAǙA
=A=qAƏ\AQA
AAHAQApA  AzA
A  A
A{AA\)AA=qAQAģA33A33AHA=qA(A{AzA=qAzAzAffA=qA  AAAÅAAGA33AGAÅApA\)AÅAAîAÙAÙA
=AAîAÙA33A(A\)AzA£AîA
AAď\Aď\AffAď\AHAA\)AAA  AA  AA
AŮAŮA(A(AQA=qAƣA
=AAAAAƸRAQA{AAŅAŮAŮAGAffAď\AĸRAzAffA(A{AÙAîA  AQAîAÅA\)AîAAAA(A£AQAzAzAAffA\AzA\AA\AAAA\AA(AAffApApAA\A=qA
AHAA
A33AAAAA
A33ARA(A(A(A(A  AAffA
A{A  AA=qAAGA\)AAGARA\A(A\AA¸RA{A=qA
A\)AAAzA
AzA  AAffAA¸RA  AAA
A\)A\)AAAA{A(A£AQA
=AzAzAAAA\)AHA
AffAAffAAQAGAGAzA
=AzAA33AAHA
AA\)AzARAAAQA\A{AAzAA\)AA
AAAAAAAA33AffA\A\)AAA\AHA\A\)AA
A\AA=qARAAA(AffA\AffA\A  A(A=qAQAzA\)AA
AzAQAAA  AARAzAQA=qAGApA  AAAQA  A
AA
=AHAAHAQAAA
A(A  A  A=qAzAApAffA(AAA{AAA\AzAApAQAAGAHA{AHAA=qA=qAA
=AA(A  AAAQAHAGAAAAGA(A=qAAQAAQApAGAApA(AAA=qA\A
=AÅA(AffAď\AģAzAGA
=AGA
=AGA\)AAAHAHAHA{AHAA33A\)AŅA\)ApAA
=A\)ApAŅAŅA\)A\)A(A\)AHA33AÅAîAÅAAGA¸RAffA
=AQAHAffA
A=qA  AA£ApAÙAGAAHAzA
=A
=AHAA=qA=qAAAApAA\AQApAAAQA=qAA
=ApAAGAQARA33AGA  AzA=qAAŅAřAģAAQAAGApAAřAAA
A  A{A  A33A33AA33A
=AzAQAAffAA=qA  AÙAÙAÙA=qA(Aď\AHA\)A33AîA  AQAAAģA
=ApA
=AĸRAHAGA=qAAzAGAAzAAzAffAÅAGAîAAA{AA\AA
=A{AA\AffAAAzAď\AîAÅA(AHAzA33A
=ApApAA=qAzA¸RAA¸RAA33AîA{AffAA33AŮA=qAQAzAHAHA  A\)AGA33A\)AA(A  AzAǅA
AAAA(AGA\)AǙAAHA33AǙAA\)A33AA=qAA=qA  AŮAA
=AAAřA\)AGAApAHAHAŮA
=A\)AAAĸRAffA(A
AzAzA33AÙA(A\)AĸRA\)Aď\AffApAGAîAGAîApA{A¸RA\AzAHAA
=AGAÅAAGA{AzA\)AAŮAǙA(AA\)AHAApAAQAʸRAAffAA\)A\)A\)AHAA\)A33AAɅAA
AA
ApAAQAA  AŮAřAQAHAA(AffAď\A  A
A{A(A  A\)AǅA
A
AǅAHAAŅAHA33A\)A33AQAQAzA(A\)AHAA
AAƸRAQAǙA  AƸRAAA=qAQAffA33AA  AŅA=qA\)A(A33AƏ\AAƣAAHAŮAAŅA
AAAřAŮA(A{A(A(A=qAffAQA(AAGAA
=AHAģAffA=qA  A
AzAffAzAAîA\)A33AÅAîAÙAÙA\)AAQAQAAAA
AA\AzAffAA
AApA{AĸRA
=AQA=qApAAffA
=ApA=qAAGAzA33AAA
AzAHAAA33AHA
AA33A33A  A=qAzAA
AHAAffA
A
AA
=AA{A{A
=A
AffA\A=qA(AGAzA  AQAHA
A\)A{AApAAzARAffApAA
=ARA\)AAffA
=AA
AAA=qAAQA\A33A33AGA\A\)AAA33AAAffA=qA\AzAA£AApAA33A£A{A\A33AGA£A{A
AApAAA\AAQAffA\A33AAffA\)AAA33AARAzAAA\)A
=AAA\A\AA\AAzAAA=qA33AAAGA
AHA
AA
A{A  AǮAAǮAA  AffAzAȏ\Aȏ\AȣAzAQA{AǮAǙApApAAffAzAƏ\A(A{A=qA
AŮAA\AAQAAHAGAGAƣAffAƣAHAƸRAGAAřAŮA\)A(AĸRAƏ\ApA
=AGAŅA\)A(AHAGAģAAzAAĸRA=qAAîAÙA\)AA¸RAHA¸RA(AQA  A
=A
=AA=qAGA¸RA33AÅA33A\)A
=A
A33AQAģApAA(A  A(A33AffA=qApAÅA  AzA=qAA\)AAŮA
AffAɅAəA33AȸRAQA{AAǙAAGApAǅAGAAAffA=qAAGAHApAGA
=AHAAƏ\A{AffAƣAƸRAAA33AGA33AGAǅA33AGAAǙAǮAǮAzAA=qA{A(A(A(ApAHAHAA
=A
=A
AAŮAřAffA\)A\)AGAApA\)A33AzA
=AAA  AÙARAÙA
A(A
=AAAHA33AffApA
AQA=qAƸRA33AA
AHAA{AGA
=AA
=AA=qAHAzAAAÅAAAA\)A  AffAQAA
=A\)AģA\AzA¸RAîAA=qAÙA=qAîAîAHAîA(A
A  A  AQA  A(AAGAA\)AÙAÙApApA=qA\)AÙAÅAA\)A(A\)A\A
AQAApA
AAAA\)A\ApAzAQA\)AA\AAzAHApA{A\A
=AQA\A{A{AA  A(A=qAffAffAAAGApApA33A
=A33AAA33AAzAffAAA{AQA=qA=qA
AAzA£A
A(AAHA
=A33A\A\)AA
AAA33AzA
=AAÙA33A=qA
=AffA\AQA=qAAA
A
AAApAA\AffAAA
=AHAAGAAAAA\AAAAzAAA33A\)AAQAGAA
A
AQA{AGA  ApAGA
=AzA\)AffA  A
=A\AAAAHAzAAAAA
AAQAAffAzA
A(AQA33AA33AÅA33AAAAGAAAHA£AAHAQAffAzAARAGA
AQAAAHAAAA=qA\)AAGAAAAAHAAGAAAA{A=qA
=AAAzAHAAzAffAGAA(AHA(A(AAAAA  ARAffAA33AAA(A\)AřAzA33AffAģAQAA
=A\)A  AffAƣAȏ\AȣA{AA
=A\A{AffA33AǙAzAƸRAAAǮAA(AA
=A\)AǮAǮA\)AƸRA
AAƸRAǮA
=A¸RA  AA\A£A\)AŅAApAzA{AApA(AGA{A=qA(AAAA\AAAzAAAA33AAAzAApAGA{A\AAAHA{AAAGA£A(AAAzA
=AřAffAǙAA(AQAGA{AƸRA=qA\)A  A(AƣA\)AǅA{A  A{A=qAffAȏ\AȸRAȣAȣAȣAzA=qAAGA
=A33AAƣAǅAA(AƸRAGApAǮAffA33A\)AǙA
=AGAŅA{AQApAǮAǙAffAȣA\)AzAȏ\A
AGAAHAď\AAQApA
=A=qA
A  AA£AA=qA{AŅA33AA=qAAAŅAGAď\AģAQAAQA{A\)AAzAzAzApAîApApA=qApAŅA  AffAHAƸRAǅAȣA33AəA33AAzA  ApAA˙AA  A(A  A=qA=qAffAAApApAA
AɮA{A\)A
=AAəAQAǙAřAAɅAAA{A(A
AzA33ApA{AɅAȏ\A33AƣA(A(AǙAA
=AŅAAģA=qA(Aȏ\AîAHA  AA=qAA
=A\)AffA  AzApA=qA
AHAA\)AƸRAHAzAzA\)A{AffAǮAA  AAȏ\AȸRA{Aʏ\A
A\)AʸRAʏ\AQAʸRA(AȀ\A  A{AAGA  A  AɮApA\)A\)A
A33A
=AQAɮAAAzAȏ\AȸRAAAȣAəAGAAzA(A
AGA
=AAAǮAAǅAƏ\AƣApA  A{A
A(ApAAHAAŮA
AA\)AŮA(A  AAŅA33AGAAAƸRAAď\AA  A
AzA  A\)AGAGAGAA
AQA33AǅAƸRAřAƸRAŮAzAǙA{A\)A
A
A=qA33A=qAʸRAHA
AApAΏ\A(AHAA\)AͮAA33A
=A̸RȀ\AffAA˙A
=A{A  A(A˙A{AQA(AzAApȀ\A˅A  AAʏ\AAȏ\ApA33A33AAQAAAřA\)AAAA  A\)A33A
=A
=A
=A33AzAzA  A{A{A
=A¸RAHA£A33A\A
AA=qApAA{A  A  AzAffAAAAîAA{A33AĸRAQAAffAîAģAAffAAA\)A
AǙAGA
=AAAGA(A(A  A{A{Aȏ\A(AQAQA{A
A
A{A  A  A\)AAƸRAƣA{AAA33A33AA
=A
=A
=AHAAřAAzA\AA£AGAQAÅAîA
AAAQAîA=qAQA=qApAîAÅAA33AAAA{A£A£A{A{AAAApAAzA
=AApA(A£AHA\)A=qA
=A\A\)A\A£AÙApA
=AHAHA\A£A\)AffA
=AAA{AA
=AAffA=qAQAQA=qAzA{A{AffA{A
AǮAǙA33A33A
=AffA(A(AîAģAAŅAzAAA
=AffAA33AHAzAAģA
AffAApAřA{AzAffAffAA(A\)A
A  A{A  AĸRA\)AÙAAGA  A£AÅA33AzA(AApA=qAAAAAA
AAAGA=qAQA(AA33AGA\AHAAHA(A  A=qAzAA\)A
AA33A33A33AŮAƏ\ApAGAGA\)AAAȣAȏ\AǙAQAGA33AGApAŮApAřAQAAAGAA33A=qA  Aď\AQAA33AģAHA=qA(AA{A
A
AGA\AA\)A\AAAAA
=AA
=AAGAA¸RAzAQA=qAzAAzA\A\)AAA\)A=qA
=AApA  A  AzARAAGA  AQAAAAAAffAAA(AHAĸRAGA  AAAffAzAƣAA33ApA
AAȣAffA(A{A(AzAffAȏ\Aȏ\Aȏ\A(AffAHAĸRA=qApAŮA{ApAŮAGAGAHAřAGA\)AzAAHAîAAď\A\)AGAģA=qAAAffAA\)AAffApAzAGA£AHA  AA(AzA
=A  A=qA
=A  A\AAAAffAAHA\)A  A
=AApAA£A33A{A33AAAGAAAAA{AAAzAHAzAAAzA¸RAHApA=qAQAApA{A
A{A
AAApAA
=AA\)AA(AAQAAAģAAģAAzAAGAAQAzAQA(AffA  A=qAAA
=AAģAÅAzAffApAffA=qApAAAA  AffA
AA\)A=qAA{AQAA
A(ARA(AQA\AA
=A  A(A\ARA
=AA33A=qAzAQA  AHAAGAGAHA(AA33A33AA  AGAAŅAAzAƏ\A
=AǮAAQAffAffAȣAȏ\AQAffA=qA(A33A{AǙAAŅA=qA(A=qAzA\)A\)A
=AǅApAGAAAHAƣA=qAřA  A{A{AQA(AƏ\A
=AǙAǮAAHApAGAffAzA(A¸RAA=qA
A
AAA{A\AAAAQAffA
=AAzAQAA=qAzAAffA
A  A
=AzA=qAA33Aď\AAAzA
AA33A=qAQA{AQAƏ\AřAGA(AģA
=A(A33A=qAģAQAHApAzAHAQApA
=Aď\AŅA33AffAzAHAHA
=A=qAĸRAAzAAŅA
AƏ\AAA=qA=qAA¸RAHAA33AAHA\)AffA  AzA{AAA{A=qAA{AHAA
AAAQAApAA\)A
=AAHAAAAA
=A\AQAAzAAA
=AAAAA\)AffAGAAAHAQA\)AAAA  A  AAGApAA33AAzAAHA
=A\A33AAAA  AAHA(AGA\)AHAAA(A\AAHA(AQAA
=AAA\)A{AGAAAAA
=AHAzAAAzA
AA(AA\)A\AAQAGAA
=A
=ARA\)A
AAAA
A
A
A  A
AA
AAQA33AAGAAAAA  A\AGA\)A  AffA(AAAAARAApA
=AAHA\)AAHAAGA(A\ApA{A=qAApAA£A{AzAAÅAApAA=qA(AAAA(A  AAQAffA=qAAA£A
=A
=A{AARApA
A\)A=qAAGAAA\)AzAAApA
=AHA¸RApA{AA
=ApAARA\A\)AA\ARAAARA\A\)AzAA\A=qA(AAffAA{AAAAAA\AAA(AHAAAARAAAA33A
=AA33AGA\)AAffAQAzAA{AAAAQAzAApAffAAQAHAGAA\AA(A\AAffApAAAA  A33AAA(AA\)AAAApAHAA33AHA  ARA\)AA=qAAGAHAAAAHAQA
AAAAA
=AA33AAA\A{A
AAAAAQA
=A
A=qAffA
=AAzA=qAffA33A=qAAA  A=qA=qAȏ\Aȏ\AAȣA=qAA
=A  AǅAǙAǅA\)AA33AƸRAAƏ\A
A  A{AHA  A(AŅAHAŮA
=AAGA(AÅA(A{A
=A=qA(AHAGA=qA
AA  A=qAQARA33A\A{ApA33AA\A\AffA
A\)AAAAAAAffApA\)A33A\)A
AAAA  A(A=qAA  AA33AGA(AAHA
A\AAApA33AQAzA  AAGAAQApAAzAARA{AffARAHAAQAAHAffA{A\AHA(ApA33AA{AAA\)ApA33AHA
AHA(A\)AAGA(AAA{AAA
A
=A\AGARA  AHARAAA  AAA(AA{AHAA  AAA=qA
AA  A\A(AffA33AQAGAA=qAHApAffA33AHAAAAAA
A\AA\)AHAffA{AA
AGAA  AAA(AzA(ARAzAA\)AAAAzAffA\A(A
=AzApAAGAApAzAAffAAAHA{AAHA
=A  AA=qA=qAQA33AzAA\AffAAA(ARAA\AAA  AAAAA{AQAQA=qA33A
A\ARAffA\)A33AffAA
=AA\A\)AARA=qA
AHA\A  AQAA
A=qA=qA{A
=ARA=qAQAAAAzAAzA  AA{AQA(AQAAffAAAQA=qA\)AGA=qAffAA
=A\)ARA  A
AGAAGAAA\A  AHA(A
AzAAQAAAQAARA33AQAQAA  AHAAAzA\)AA{AAGAA  A{AAA=qAAffAAAHAA=qAAAA
=A(A=qA  ARApA
AA  A
AAA33AAGAA\)AHA
=AAAA\)AA33ApA
AffAAQAApARAAAAAAQA\AHAHA\)AA(AffAAA\A\)A{AQAA33ApAAAA
AA
=A(A\)AzApAAA33ApAA\)A{AffAffA(A=qAAA\A\)A  AA
=AA33AAzAAARA{AAA=qAHAAA
=A
=AA=qA
ApA
=AARAGA(AAAAA{AQA(ARAffA  AffAAAHAffApA  AAAQAQAA\)A
ApAAA33ApAGA{A=qAApAHA(A{AARAAA
=A=qAGAA\)AA
AffA\)AzA\)AA  A
A  AHA33AQA33ApA(AA
=AffA(A
AApARAQAAQApA  AA\)AA{AffA(AzA\)A\)A(AffARApAGA  AzA33AApAAAffA\)AQA
AffA(AHARA
A\AAzA
=A(AGA
A=qApAHARAA{A{A=qARAAAQAApAffA{A{A
A(AAAffAAA  A  A(AApA\AzAGA{AAQAA\AAA{AA
AHA33AQAAGAQAzApA=qA
A{AAzA=qA{AA
A(A33AARA{ApAA33A\A{A\AHAHAA
A
=A\AARAA{A(AzAAAQAffAAA{AGA=qAzA(AAAAzAAzAA=qAAAAAQAAAA
=AA33A  A(AAffAAAAAAA
=A=qAAHAA{AAAA
=AAAARA\AApAA  AAApAA33AAAzA\AApAzA=qAA=qAAGAQAAGApAGApA(A33AA  A£AAAĸRAĸRAzAģA
=ApAAAGA=qAQA  AîAApA  A\)ApA(AAHAQAA  A\)A  A\)AŮAAffA£A\AA{AAffA33A£A  AHApAHA
AffA\ApARAAHA=qA  AGARAAAHAzA
=AffAzAAAGAQA(AHAAAzA
AA33AzAQAAAď\A=qAA33AA
AAAzARARARA(AAA
AGAA
A{A
=A
AA
A{A33AGA33ARAzAA  A  A{AAHAA(A\AAAAAAA=qAA\A(AHAzAzA
A(AA33A
=A{AzAAAA=qA{AHAAAAffApAAA\AAffAARAffAGA
=A(ARAHA\AQAGApAffAAQA  AA
A{ARAAAzA=qA\AA  A
=A\AAAAQAAAGA
=AGAGAA\)AA=qAAA33AHAAAARA=qAA33AHA  AA\)AA(ApA  ApAHAׅAzAffAzAzAQA(ApAGAAՅAGAGAծA  AAәA(AәAңAңA
A{AAQAA(AAApA{A33AәA
A(A
A=qA=qA(AQA{ApAӮA=qAQA33AΏ\A\)Aʏ\AAʸRAA  AA{A
AGA\)AѮAљAzA{ApAA\)AzAA(A=qAәA\)AAѮAzAAΣAAͮA
=AA=qA{A  AиRAHA33AѮAzAҸRAffA  AA33A{A(A\)AA{A
=AAՅA
=AAffA{AGAAAHAҸRAHApA
=AҸRAA
=AՅA
A֣AծAծAzA{A\)AҸRAϙA  AGAAzA
=A{AAҏ\AffAffAGAAӅAAAңAAAҏ\AGAQAAffAɅAAA=qAffAAʣȀ\AzAGAzAHAAиRA
=AHAAңAzA{AHAΏ\AAzAQAхA(ApAϙApAffAҏ\A
=A  AA
AA(A֣AzAffAHA֏\AָRAHAAA33AGAAׅA
=A33AAAAGAAׅAׅApA
=A33A֣AHAApAԏ\AGAzA=qAzA{A=qẠAHAͅA\)AͅApA
A=qAHA{A
=A
=A(AΣA\)AAAA=qAffAGAHAffA(A\)A=qA  AQAAQA33ẠA(A
AGAzA(A{AͅA
=A
=AͅAffA{AAɮA(A{ẠA
=AͮAΏ\A\)A
A
=AθRAAθRAHAA(AУAЏ\AQAA{AffAQAЏ\AЏ\A=qAЏ\AffAzA=qA{A  AЏ\AGAУAϙA  A
=AffAA  A{A
AA  A{AQẠAAQA=qAϙA{A(AAApAAиRA(AAApAΏ\AA\)AA33A(A\)AA͙A
=A33AQAȸRA(AHA
=AffAA{AȸRA˅A  AA͙AzAAȸRAzAQAʏ\A(AAAУAQA{ApAHA=qApA
=A(A\)AzA33AHA
AAffAffA\)AA\)AՅA33A33AԸRAԸRA=qAA33A33A33AՙAՅAA{AAHA=qAӅAA\)AAҸRAҸRA33AHAA=qAAHAAzA33AA{A  A
=A  AHAAʣAϙAAΏ\AQA˅AɅAHAQAQAəAˮA
ApAA˅A{AQAǙA  AȣAˮA  AffA=qAzAAǙA\)A
=AAzAzA(AȣAQAǙA\)AɅAA\)AA˅AGAGA
AΏ\A\)Ȁ\A
AAA(AΏ\AϙA33AУAAffAffAҏ\AQAHA{AAA{A=qAңA=qAңAңA
A  AGA{AA=qAҸRApAԣA
ApAѮAхApA\)A(AυAGA(A
AHA
=A=qAzApA(A\)AAA
=A{AͮA=qAzAQAA=qA
=AAУAϮAA(AffA˅AθRAAHA33AAzA  AGAΏ\AΏ\AzA33AυAGA
A
=AA\)AzA33A
AAΣA{A33AAAAAA33AGAzA(ApȀ\ApAA˅A
=A33AzA\)A\)A˅Aʏ\ApA˙AAHAGAAʏ\AGAAA\)A  AAƣApA33AAzAď\AAřAAAA(AQA(A
A=qAffA33A=qAAA
AA
=AAƣA
=A33AAAƸRAA
=AAGA\)AǙA  AȣAǙAƣAAzAQA
=AǮAA33AA\)A  AƏ\AzAA
A
AQApA  A  Aȏ\AȸRA
AzA33A33A˅AAzAAHAAAGA\)AͮA  AͮA͙AAͮAA͙AͮAzA(A  A
AA͙A(A  A
A
A(AͮA(A(AApAA=qAGAʏ\ApA=qAGA
A=qAGAGAAǮAǮAApAAffAffA\)A{A
=AAAǮAQA  A{AɮA{AA˅ApA=qAQA=qA  A{AGAA\)A=qA33AɅAffAQAƸRAAƸRAQAAɮApAɅAʸRA
AA
AQAHAAA˙A=qA
=A33A
AffAθRA33AϙA  AA\)AA\)ApAљAQA=qA=qA=qA
AAиRAHAAЏ\AA  ApA\)AAHA{A=qA=qAA  A
=AΣA
=AΣAΣAͮA  AAΣAzAAGA=qAAəA{AzAAQAɮAɮApA33ApA
AffAzA33AˮAɅAAAzAǙAzA
ẠAˮAɅA  A
=AHA˅A̸RA  AHAAAɮAQA
=AHȀ\AffA̸RAAffAHAυAЏ\AљAAAHAHA
=A  AA{A֏\A
=AׅA\)AָRA֏\AָRAffA
AA(AՅAAҏ\A
=AAӅA  A=qAљAGApA{A
AA
AA  AGAGAAAHAЏ\A{AAGA\)A{AAA
=AϙA
AθRAzAzApAA  AAQAAAzAA33AffAQAAHAzAGA̸RA  A
=AʣAAA=qAGAAϮA{AAffAͮA=qAυA  AAAAθRA
AAљAffA
=AGAHAAHAAGA33ApAӮA  AծAיA׮AzAA\)AffAHA=qA(A(A
AAңAQAҸRAHAҏ\A
AAѮA  AҸRAzAGAA\)A(AHAAAHAAӅAGA\)A\)AAAAQAA(AQAӅA(AA33AхA(AA33A33A
AәAәAәA
=AGA33A
=AAHA(AApAzAAУAA  A
AzAAffAхAAAңA\)A
=A(A
A֏\A33AAׅAffAظRA(AAمAمAHAHAAAAA=qAGAzApAԏ\AԸRAAffA\)AׅA=qA{AAAA
=A{AAAGA33AQAAGAAHAAAѮAzAAϮAApAΏ\AͮAGAͮAA=qA˅AˮAAAAʸRA=qAAGẠAHAAA33AGA(A
AθRAAȸRAˮAЏ\A(AAAAzA
=AApA
=A{AӮAԣAHAAAңAHAԏ\AԸRA\)A{A(ApAծAA
AՙA{AQAQA{AծA33AzAHA=qAzA=qAQAzA{A{AA\)A
=A
=A
=A{ApAAffA
=A{AAхA=qAGA=qAңAԸRA\)AָRAָRAծAAAGA̸RAңA
AAA=qAGA͙A33A
=AGAGA
AAA
=A33AQAHAAAɅAAˮA˅A\)A
=A33ApAHAQAAHAApAΣA{ẠAΏ\AzAA\)AAzA(A=qAʣA˙AAffApAϙAA(AzAAA
=AљA{A=qA(A=qAA  AzAA(A͙A\)A\)AzAA  A\)A=qA=qAQAffA  AљA
=AQA  AУAHAͅAHAA{AAəAffAAAˮApAAffA{AHAzAzAΏ\AΏ\A=qApAυAzA
A  AHA
=A33AAɮAʏ\AzA{A
A(AɅAGA=qAʏ\AHAHAQAͅA̸RA\)A33AУAθRAθRA(AApA(A=qA33A
AθRAυA  AA
=AGAиRA  AGAApAAGA33AA\)AGAGA\)ApAәAәAӮAәAHA
=AAAңA33AљA\)A
=AAУAиRA
AzAA(A  A{A
A\)AθRA{A=qAͮA
A
AA
AAGA=qA˅A̸RAA33ẠAA(A33ApA(AffAzAzA  AAAAAřA\)AAŅAƣAď\AHAŮAHAƣAGA(AȸRAAA{A(AˮAˮA˅ẠAApAͅA
=A{ẠAHAAQAQAθRAΏ\AAQAGAA
=AHAzA{AхAҸRAQAzAҏ\AAQA(AzA
A{A
AAGApAffAQA
AAHAͅAͅAGA
A\)AϙAΏ\A\)AHA33AQAA  AхAЏ\AAzAхAѮAffAffAAѮAAϙApAGAˮA=qApA͙AAɅAHAυA33AApA
=AQA˙AA33AApApAAȀ\A
=A  AϙAzApAAЏ\AAхA(A  A  A(AffAҸRA(A  AәAӅA
AԣAԏ\AәA=qA
AAA\)AәA{A\)A
=A(AGAAffAAљAAAffAҏ\A  A(AQAQA  A=qA33A{AAϙAAQAA(AzAθRAθRApAϙA\)AAffAffA̸RAffAzA͙AA
A  A\)A\)AͅA͙A˅AʣAAQA{AΣA{AθRAAϙAυAϙAGAϮAA
AϮA{AffAѮA{AGA=qAGAAϙA
AQAHA  ApAA  AԸRAA{AffAQAQAAGA=qAיAHAծA=qAGAHAԏ\AffAԏ\AQAԏ\AQA=qAQA
A33AӅA{Aԏ\AAGA
=AңAQAzAңAAңAңA  A=qAA{AQAzAffAffAљA\)AA
=AQA=qA  ApA{AͮAzA{A  A
A\)AzAApAAA˙A=qAA
AͅAzAffAA{A33AȣAAA
A
AffAGAzAA˙ApAGAAA
AAϮAхA=qA\)A=qA{A  A{A
A  A  A(A  A=qAQA=qA  AAӅAGAӮAӅAHAҏ\A  A{AApAУAυA
=AA\)A33AApA\)AAA
=A
=AΣA\)AϙAGAGAGAA33A33A=qA{AͅA\)ApA
=AAzAθRAΏ\ẠȀ\A̸RAHAQAQA˙AffA  AGA\)AAA{A  Aʏ\A33AȀ\AzApA͙AHAA\)AAQA=qA33AGAA(A
=AθRAхAA
A{AңA33ApA
=AA33AAӮAAAAA{AՙA33AQAՅAGAA33AA33AAљAApAApAA  AAљAљA33A33AУA
=ApAΣAAA
AA  A
A\)A  AffA˅AHA(AA=qAzA33AAʸRA  A{AϙAffAffA\)AAљAˮAȸRAȸRA  Ȁ\AApA(Aʏ\AɮAGA̸RA(AA33A  AA
=ApAA(AЏ\AиRAGA=qAHA(AHA  A  A{AҸRAAAAӮA\)AӮA(AQA=qAӮApAҸRAAָRA
AָRAԸRA{A֏\A{AffAՙA\)A(AzAхAхAAA
=AAAҸRAzAzAzAGAffA\)ApAApAυAиRA33AAQAљA  AGAHA\)AHA(ApAA{A
=A33AffA{A(AͅA˙Ȁ\ApAA˅AzAAAHAAAΏ\AGA  A
AЏ\AʸRApȀ\ApAAHAΏ\AA
A(A(A  ẠAA
AffA\)AffAЏ\AGA(A\)AѮAҏ\AAGApA(AӮAӅAA(AAGApA33AA(A  A(ApAAAzAQAAQAffAA33AϮAυAυA
=A
=AУA33A33A  A  AGAHA\)AхAA
=A\)AAиRAУAAЏ\AυAиRAAAAQAGAA̸RA{A{AͮAͮAˮAzA
ApApApAAɮAAɅA
A(ApAAffAHAʏ\AA  AHA  A{AHA˙A{A(AzẠAAͮAA=qApAApAzA33AУAЏ\AA  A{AffA=qA{A{A  A  AAΏ\AͮAAA
A͙AͅAͅA\)AAA(A
A̸RAGȀ\AGAəAA33A\)AAzA
=AˮA˅Ȁ\AzA{AAHAA
=AʸRAffA˅A=qAʏ\A  A\)AAȣAǅAA
=AAAAA  A  A  AAzAHA  AʣA  ApAGAAHAȣAffAffAffAA33A˙A
Ȁ\A
=A{AAυA{AЏ\A33ApAѮA  A{A=qA=qAQAffAffAzAңAQAffAQA=qAѮAA\)AљAAиRAиRAЏ\AffAffAffAхAA
=AQAffAAϮA
AHAУAУA\)A(A\)AυAΣAHA
A\)A\)A33A=qAHAAϙAzA33A(A(A(AЏ\AAAAHAA=qAAGAQA  A(A  AΏ\A(AzAffAffAffAQA=qAQA=qAиRAzAAA(ApA=qAA33AApAGAzAͮAͅAͮAυA33ApAzAGAңAңA(AA  AQAҏ\AApAѮAиRA\)AA{AУA{AϮAυAϙApAиRAHAЏ\AиRAHAЏ\AиRAA
A\)AQAA(A  A(AA
AzAAGẠAHAAˮA(AŮA  AAȣAȸRAAAɅA
AȣAȣAȣAAǅAǮA
A{AffA
=A33AHA\)ApAď\AAÙAď\A  AƣA=qA\)A{AHA
AQA=qApAGAzAA33AəAAffA͙A(AAУApA\)AA{A
AѮA
ApAѮA
A(AљAѮAΣAθRA{AA{A
AУAAAиRA=qAffAQA=qA\)AQA
A̸RA{Ȁ\A=qAQA˙ApA\)A˙AˮA{A=qAˮA˙AGA
=AAzA=qAQAzAȸRApAAAɅAHAAHAHAQAAŅAQApAzA=qA=qAffAAȏ\A{A\)AQAA
=AGA\AAAA33A\)AzAQA\AAGARApA\AffAHAA
AA\)AARAQAGAGAApAAHA
AAAAHAA  A\)AA\AA
=A  A\)AA{AARAAAApAffAA  A(A  AAAApAGA\)AAAffA33AAAAGAHAQA=qA
=A{A
=AHAzAzAA
=A{AAAHAAAARA(AAAAHAAAAHAzARAA\A\AAAA=qAzAA\)AAA(AAA\)ApA{ARA\AAHAA
A
A{AQA  A\)AGAQAHAAQAffARAApAAAAA{A33ARAHA\)A\)AA  ARA\)A
=A
=AQAAHA(AAARAAffA=qAA
=AzAAAAAAA{AAA\)AApAzAA=qAQAAAAAAzA33AAffAAAA  AffAAffA33AAA  AAffAA
=AHA{AAGAAHAA33AAAAAA  AAQAApAQAAARAHA(A
AARA\AAQA  A=qA  AAAffAQAAAQARA\AAA{AGAA\)A
=A\ApAA33AA\AAARAGAAGAApAA{ApA\AQA\)AAzA{AAA
AAA
=AAAQAAHA\)A{ApARA\AApAAAAA\A(AA  AAffA
AAA
=AAA
AA\)AAA  AHAAQAffAAAAApAAA{A\AA(AAQAffAAA\A  AAGAApA\AApA  AAGAAAA\A\A  AAAQA{A  A\ApAAzA\)ApA(A{AzA(A  A  A\A
A\AAA
=A=qA  A=qAA{A(A33A=qA{AA\AAzA=qAAHAA\)AAffAffARA\AAAQA  AA=qA
AHAAA
=A\)ARAA{AAAQAzAA\)AGA\AHAAAA
=ARApA(A  AAAAHA\A
AAffA(AAAAzA\AAGApA{A
=A{AGAAGAAAGA{AQAHAAzAApAAAA
=A=qAA33ARAffA{AAA  AAGAAAA
A33A\)A\)AQA(ARAffAA{ApA  A\AHAffARA{AGAA\)ApA  A=qA\A33AAGA  AApAA=qAAGA  AA  A\)AA\)AAHAA
=A\)A33AAA  A
AA33AARAA33AAzAHAAA{AAAAApA33AA
=A\A\)A=qA\A
=AQAA\)AAHAApA
=ApAzA  A33A{A
=AARAQAAA\)A=qAffA  AzAAzA\)AGA
AA=qAAA\)AAQAzA33A\AA
=A33AAA
AAAAAARA\)AA
AzAQA(A\AAARAHAffA=qA
AAzAApAAAA
=A=qAARA(AAAGA  A  A\)AAAA
=AAA{AGA{ARAA{AAAHAGA(AA
=AGAAAAA  A
A\)AAA{AA\AzA
=A  A=qARAA(AffA
=AffA{AAGAA  ApA(AA\AAGAA=qA  AAA
=ApAA=qA=qA(A33AA\AffA(A\)ApAHA{AQAzAA
=AAAA\ApAAHA\)AQARARA(A=qAAAA(AzAA
A  A33AzA
=AApAffARA(A(AA\AA{A  ARAAAAAAA  AARAAAAAHAA
=A
AzAHA\A
=AAzAAAffA(AApAHAzAApAARAA\AHAA\AAHA
=A{A  AAzA
=AApAAAA(AAffAHAzAAGAHAAGAAAA{AARA
AffAAApA=qA  AHAA\AffAAAAA33A{AA{A33AAHA\A{A(A=qAA\)AAAffAHA
=AAA(AzAAA=qA(AAA(AAAA  A
=AAAA(A=qAA=qAHAzAHA\)AGAA=qAzAAA(AffAzA\AAA  AAAHA33AQA(AAA=qAA  AHA
=ApAzAA=qA(AffAGA\ApAffAHA
A{AA  AAGAA
A  A33AA=qAHA(AzAGAAA\A{AAHAAAffA
ApA\)AffAA\ARAAQA  AffA(A(ApAzAA  A  AA33ApA
A  AA\)AffA
=ApAA\)A{AffA
AA=qAGAHAAzAAAGAAQAzAGA33AQA  A33AQAAA33ARAGAAAA  AAQA
=AA\AAQA  A
A\)AAAA
A  AQAGAAAQAHA  A
A  AGAHAAQAffAA
AAAGAQA
=AA(AzAAAA{AffA  A33AA33A=qA
=AA{AAAAAAHA  A\)A\)AAA=qAAA  AAA
=AA
=AA\)AA=qAA{A{AARA33A
=A(A\)A(AAAA(A33A33AA=qAAAzAARAGAA  A\)AffAGAAA(AzA=qA33AQAHAA\AffAAQA33A33ApA\)AffA(A33AffAAA{AHA
=A
=AA\)ApA33AGAAA{ARAA
A\A  A\AAAffA{AzAAA{A
=AA
AAA\A\)AQAAAApAAA
A{AA\A
AAQAAAA
=AAA
=AQA\)AAGAQA33AA\AA  AHAHAAA=qAARAQA  AAAA=qAHAffAAAffA(A{A{AAAA=qA  AAffAAAQAffAQA  ARA\)AGA  A\A33AGA33A  ARAA  AA
A  AApAAAffAffAAAA(ApA(AzA33AzA(AQAGAAQAA
AApARA33A33AAAAHAA\)A(A
=A
=AAGAA
AffA=qA  AffA
A(AQA(A
=AA\AAAAGAffAAGApAAAA
=AA(AHA(AAAA33A  AAAAAAffAAA(A(AAHAAffAA{AffA(A=qAHA{A{AffAA(AAzA
=AA{AffAAAA{AApAA(A(AGA
=AAHARAQApA=qA\ApA\AQAHA
=AA
=A\AQARA33A  AAffA=qARA33AAQAHAA{A\A=qAQAAAzA\AA\AAApAffA33AA\)AA(AAApA33ARAAGAAAffAQAQA33ARA\)A=qAAffAA\AA=qA33AA=qAzAzAAHAHAA=qApAGA{AAA  AA
AAAzAffAGA\)A
=A=qAAApA33AAGAAAAQAA33AAA(A\AA{A\ARAGAAAA
=A  A\AHAffAffA(A
=AA{AffAffA33AAAQAAA  A  AAAA(AAQAA=qA
=ARApA\)AA\)AAHARAARAzA
A{AAAApAAGA33                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                      