CDF       
      
timeseries        obs   f   station_name_strlen       platform1_strlen      instrument1_strlen     0   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:16:41Z http://pacioos.org
2022-11-15T19:16:41Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2017-01-01T00:00:00Z&time%3C2018-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2017-12-31T23:45:00Z   time_coverage_resolution      PT30M      time_coverage_start       2017-01-01T00:00:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      A   A֒]      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z      6 r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      AAz   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH      p    salinity                   _ChunkSizes                
_FillValue        y    actual_range      ?n{B=q   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B      p E4   	turbidity                      _ChunkSizes                
_FillValue        y    actual_range      $D3   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz      p    chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      \0D;     ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C      p 	|   oxygen                     _ChunkSizes                
_FillValue        y    actual_range          AJ=q   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH      p    oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range          C/   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C      p    ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`      p Nd   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      AAz   ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH      p    temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range              p D   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p     temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p $   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p W   temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p    temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p t   temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p )   temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p T   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p `   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p 4   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p !   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p #3   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p $΄   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	    p &i   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	    p (d   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range      ?n{B=q   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B      p )   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range              p +<D   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p ,״   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p .s$   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p 0   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p 1   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range               comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p 3Et   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p 4   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p 6|T   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p 8   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p 94   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p ;N   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p <   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p >   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	    p @    salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	    p Ad   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range      $D3   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz      p CW   turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range              p DD   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p F   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p H*$   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p IŔ   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p Ka   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p Lt   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p N   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p P3T   turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p Q   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p Sj4   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p U   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p V   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p X<   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      \0D;     ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C      p Y   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range              p [sd   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p ]   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p ^D   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p `E   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p a$   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p c|   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p e   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p ft   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p hN   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p iT   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p k   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p m!4   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p n   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range          AJ=q   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH      p pX   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range              p q   
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p s   
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p u*d   
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p v   
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p xaD   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p y   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p {$   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p }3   
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p ~   
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p jt   
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p    
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p T   
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p <   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range          C/   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C      p 4   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range              p s   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p    oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p    oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p E   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p d   oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range               comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p |   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p D   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p    oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p O$   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p    oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p    oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p !t   oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p    ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`      p XT   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range              p    	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	    p 4   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	    p *   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	    p    	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	    p a   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	    p    	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	    p d   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	    p 3   	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	    p D   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	    p j   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	    p $   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	    p    	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	    p =   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       i( t   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     I@ A   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2     ɊAp?  wqb_04  A   A   Ab   AC   A$   A   Aj   AK   A,   A
   A   A   A   A    A!r   A"S   A#4   A$   A$   A%   A&   A'   A(z   A)[   A*<   A+   A+   A,   A-   A.   A/   A0c   A1D   A2%   A3   A3   A4   A5   A6   A7k   A8L   A9-   A:   A:   A;   A<   A=   A>s   A?T   A@5   AA   AA   AB   AC   AD   AE{   AF\   AG=   AH   AH   AI   AJ   AK   AL   AMd   ANE   AO&   AP   AP   AQ   AR   AS   ATl   AUM   AV.   AW   AW   AX   AY   AZ   A[t   A\U   A]6   A^   A^   A_   A`   Aa   Ab|   Ac]   Ad>   Ae   Af    Af   Ag   Ah   Ai   Aje   AkF   Al'   Am   Aqm   ArN   As/   At   At   Au   Av   Aw   Axu   AyV   Az7   A{   A{   A|   A}   A~   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   AQ   A2   A   A   A   AͶ   AΗ   Ax   AY   A:   A   A   A   AԾ   A՟   Aր   Aa   AB   A#   A   A   A   Aܧ   A݈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A    A   Ar   AS   A4   A   A   A   A   A   A	z   A
[   A<   A   A   A
   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A!5   A"   A"   A#   A$   A%   A&{   A'\   A(=   A)   A)   A*   A+   A,   A-   A.d   A/E   A0&   A1   A1   A2   A3   A4   A5l   A6M   A7.   A8   A8   A9   A:   A;   A<t   A=U   A>6   A?   A?   A@   AA   AB   AC|   AD]   AE>   AF   AG    AG   AH   AI   AJ   AKe   ALF   AM'   AN   AN   AO   AP   AQ   ARm   ASN   AT/   AU   AU   AV   AW   AX   AYu   AZV   A[7   A\   A\   A]   A^   A_   A`}   Aa^   Ab?   Ac    Ad   Ad   Ae   Af   Ag   Ahf   AiG   Aj(   Ak	   Ak   Al   Am   An   Aon   ApO   Aq0   Ar   Ar   As   At   Ay   Ay   Az   A{   A|   A}~   A~_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   Aį   AŐ   Aq   AR   A3   A   A   A   A˷   A̘   A   A   Aҿ   AӠ   Aԁ   Ab   AC   A$   A   A   A   Aڨ   Aۉ   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   A s   AT   A5   A   A   A   A   A   A{   A\   A	=   A
   A
   A   A   A
   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A    A    A!   A"   A#   A$|   A(   A)   A*   A+   A,e   A-F   A.'   A/   A/   A0   A1   A2   A3m   A4N   A5/   A6   A6   A7   A8   A9   A:u   A;V   A<7   A=   A=   A>   A?   A@   AA}   AB^   AC?   AD    AE   AE   AF   AG   AH   AIf   AJG   AK(   AL	   AL   AM   AN   AO   APn   AQO   AR0   AS   AS   AT   AU   AV   AWv   AXW   AY8   AZ   AZ   A[   A\   A]   A^~   A__   A`@   Aa!   Ab   Ab   Ac   Ad   Ae   Afg   AgH   Ah)   Ai
   Ai   Aj   Ak   Al   Amo   AnP   Ao1   Ap   Ap   Aq   Ar   As   Atw   AuX   Av9   Aw   Aw   Ax   Ay   Az   A{   A|`   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A°   AÑ   Ar   AS   A4   A   A   A   Aɸ   Aʙ   Az   A[   A<   A   A   A   A   Aѡ   A҂   Ac   AD   Aة   Aي   Ak   AL   A-   A   A   A   A߱   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A 6   A   A   A   A   A   A|   A]   A>   A   A	    A	   A
   A   A   A
e   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A    A!   A"}   A#^   A$?   A%    A&   A&   A'   A(   A)   A*f   A+G   A,(   A0   A1n   A2O   A30   A4   A4   A5   A6   A7   A8v   A9W   A:8   A;   A;   A<   A=   A>   A?~   A@_   AA@   AB!   AC   AC   AD   AE   AF   AGg   AHH   AI)   AJ
   AJ   AK   AL   AM   ANo   AOP   AP1   AQ   AQ   AR   AS   AT   AUw   AVX   AW9   AX   AX   AY   AZ   A[   A\   A]`   A^A   A_"   A`   A`   Aa   Ab   Ac   Adh   AeI   Af*   Ag   Ag   Ah   Ai   Aj   Akp   AlQ   Am2   An   An   Ao   Ap   Aq   Arx   AsY   At:   Au   Au   Av   Aw   Ax   Ay   Aza   A{B   A|#   A}   A}   A~   A   A   Ai   AJ   A+   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   Aǹ   AȚ   A{   A\   A=   A   A   A   A   AϢ   AЃ   Ad   AE   A&   A   A   A   A֪   A׋   Al   AM   A.   A   A   A   Aݲ   Aޓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A    A   A   A}   A^   A?   A    A   A   A   A	   A
   Af   AG   A
(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A ~   A!_   A"@   A#!   A$   A$   A%   A&   A'   A(g   A)H   A*)   A+
   A+   A,   A-   A.   A/o   A0P   A11   A2   A2   A3   A4   A5   A6w   A7X   A89   A9   A9   A:   A;   A<   A=   A>`   A?A   A@"   AA   AA   AB   AC   AD   AEh   AFI   AG*   AH   AH   AI   AJ   AK   ALp   AMQ   AN2   AO   AO   AP   AQ   AR   ASx   ATY   AU:   AV   AV   AW   AX   AY   AZ   A[a   A\B   A]#   A^   A^   A_   A`   Aa   Abi   AcJ   Ad+   Ae   Ae   Af   Ag   Ah   Aiq   AjR   Ak3   Al   Al   Am   An   Ao   Apy   AqZ   Ar;   As   As   At   Au   Av   Aw   Axb   AyC   Az$   A{   A{   A|   A}   A~   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   Aź   Aƛ   A|   A]   A>   A   A    A   A   Aͣ   A΄   Ae   AF   A'   A   A   A   Aԫ   AՌ   Am   AN   A/   A   A   A   A۳   Aܔ   Au   AV   A7   A   A   A   A   A   A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A    A~   A_   A@   A!   A   A   A   A   A   A	g   A
H   A)   A
   A   A
   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   A A   A!"   A"   A"   A#   A$   A%   A&h   A'I   A(*   A)   A)   A*   A+   A,   A-p   A.Q   A/2   A0   A0   A1   A2   A3   A4x   A5Y   A6:   A7   A7   A8   A9   A:   A;   A?   A@   AA   AB   ACi   ADJ   AE+   AF   AF   AG   AH   AI   AJq   AKR   AL3   AM   AM   AN   AO   AP   AQy   ARZ   AS;   AT   AT   AU   AV   AW   AX   AYb   AZC   A[$   A\   A\   A]   A^   A_   A`j   AaK   Ab,   Ac
   Ac   Ad   Ae   Af   Agr   AhS   Ai4   Aj   Aj   Ak   Al   Am   Anz   Ao[   Ap<   Aq   Aq   Ar   As   At   Au   Avc   AwD   Ax%   Ay   Ay   Az   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   Aû   AĜ   A}   A^   A?   A    A   A   A   Aˤ   A̅   Af   AG   A(   A	   A   A   AҬ   AӍ   An   AO   A0   A   A   A   Aٴ   Aڕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A  `   A A   A "   A    A    A    A    A    A h   A I   A 	*   A 
   A 
   A    A    A 
   A p   A Q   A 2   A    A    A    A    A    A x   A Y   A :   A    A    A    A    A    A    A a   A B   A #   A     A     A !   A "   A #   A $i   A %J   A &+   A '   A '   A (   A )   A *   A +q   A ,R   A -3   A .   A .   A /   A 0   A 1   A 2y   A 3Z   A 4;   A 5   A 5   A 6   A 7   A 8   A 9   A :b   A ;C   A <$   A =   A =   A >   A ?   A @   A Aj   A BK   A C,   A G   A Hr   A IS   A J4   A K   A K   A L   A M   A N   A Oz   A P[   A Q<   A R   A R   A S   A T   A U   A V   A Wc   A XD   A Y%   A Z   A Z   A [   A \   A ]   A ^k   A _L   A `-   A a   A a   A b   A c   A d   A es   A fT   A g5   A h   A h   A i   A j   A k   A l{   A m\   A n=   A o   A o   A p   A q   A r   A s   A td   A uE   A v&   A w   A w   A x   A y   A z   A {l   A |M   A }.   A ~   A ~   A    A    A    A t   A U   A 6   A    A    A    A    A    A |   A ]   A >   A    A     A    A    A    A    A e   A F   A '   A    A    A    A    A    A m   A N   A /   A    A    A    A    A    A u   A V   A 7   A    A    A    A    A    A }   A ^   A ?   A     A    A    A    A    A    A f   A G   A (   A 	   A    A    A    A    A n   A O   A 0   A    A    A    A    A    A v   A W   A 8   A    A    A    A    A    A ~   A _   A @   A !   A    A    A    A ɥ   A ʆ   A g   A H   A )   A 
   A    A    A Э   A ю   A o   A P   A 1   A    A    A    A ׵   A ؖ   A w   A X   A 9   A    A    A    A ޽   A ߞ   A    A `   A A   A "   A    A    A!   A!   A!   A!   A!i   A!J   A!+   A!   A!   A!	   A!
   A!   A!O=   A!P   A!P   A!Q   A!R   A!S   A!T   A!Ud   A!VE   A!W&   A!X   A!X   A!Y   A!Z   A![   A!\l   A!]M   A!^.   A!_   A!_   A!`   A!a   A!b   A!ct   A!dU   A!e6   A!f   A!f   A!g   A!h   A!i   A!j|   A!k]   A!l>   A!m   A!n    A!n   A!o   A!p   A!q   A!re   A!sF   A!t'   A!u   A!u   A!v   A!w   A!x   A!ym   A!zN   A!{/   A!|   A!|   A!}   A!~   A!   A!u   A!V   A!7   A!   A!   A!   A!   A!   A!}   A!^   A!?   A!    A!   A!   A!   A!   A!   A!f   A!G   A!(   A!	   A!   A!   A!   A!   A!n   A!O   A!0   A!   A!   A!   A!   A!   A!v   A!W   A!8   A!   A!   A!   A!   A!!   A!   A!   A!   A!   A!   A!g   A!H   A!)   A!
   A!   A!   A!   A!   A!o   A!P   A!1   A!   A!   A!   A!   A!   A!w   A!X   A!9   A!   A!   A!   A!   A!   A!   A!`   A!A   A!"   A!   A!   A!   A!Ǧ   A!ȇ   A!h   A!I   A!*   A!   A!   A!   A!ή   A!Ϗ   A!p   A!Q   A!2   A!   A!   A!   A!ն   A!֗   A!x   A!Y   A!:   A!   A!   A!   A!ܾ   A!ݟ   A!ހ   A!a   A!B   A!#   A!   A!   A!   A!   A!   A!i   A!J   A!+   A!   A!   A!   A!   A!   A!q   A!R   A!3   A!   A!   A!   A!   A!   A!y   A!Z   A!;   A!   A!   A!   A!   A!   A!   A!   A"    A"   A"   A"j   A"K   A",   A"
   A"   A"   A"   A"	   A"
r   A"S   A"4   A"
   A"
   A"   A"   A"   A"z   A"[   A"<   A"   A"   A"   A"   A"   A"   A"c   A"D   A"%   A"   A"   A"   A"   A"   A" k   A"!L   A""-   A"#   A"#   A"$   A"%   A"&   A"'s   A"(T   A")5   A"*   A"*   A"+   A",   A"-   A".{   A"/\   A"0=   A"1   A"1   A"2   A"3   A"4   A"5   A"6d   A"7E   A"8&   A"9   A"9   A":   A";   A"<   A"=l   A">M   A"?.   A"@   A"@   A"A   A"B   A"C   A"Dt   A"EU   A"F6   A"G   A"G   A"H   A"I   A"J   A"K|   A"L]   A"M>   A"N   A"O    A"O   A"P   A"Q   A"R   A"V   A"W   A"X   A"Y   A"Zm   A"[N   A"\/   A"]   A"]   A"^   A"_   A"`   A"au   A"bV   A"c7   A"d   A"d   A"e   A"f   A"g   A"h}   A"i^   A"j?   A"k    A"l   A"l   A"m   A"n   A"o   A"pf   A"qG   A"r(   A"s	   A"s   A"t   A"u   A"v   A"wn   A"xO   A"y0   A"z   A"z   A"{   A"|   A"}   A"~v   A"W   A"8   A"   A"   A"   A"   A"   A"~   A"_   A"@   A"!   A"   A"   A"   A"   A"   A"g   A"H   A")   A"
   A"   A"   A"   A"   A"o   A"P   A"1   A"   A"   A"   A"   A"   A"w   A"X   A"9   A"   A"   A"   A"   A"   A"   A"`   A"A   A""   A"   A"   A"   A"   A"   A"h   A"   A"   A"   A"p   A"Q   A"2   A"   A"   A"   A"   A"   A"x   A"Y   A":   A"   A"   A"   A"   A"   A"   A"a   A"B   A"#   A"   A"   A"   A"ŧ   A"ƈ   A"i   A"J   A"+   A"   A"   A"   A"̯   A"͐   A"q   A"R   A"3   A"   A"   A"   A"ӷ   A"Ԙ   A"y   A"Z   A";   A"   A"   A"   A"ڿ   A"۠   A"܁   A"b   A"C   A"$   A"   A"   A"   A"   A"   A"j   A"K   A",   A"
   A"   A"   A"   A"   A"r   A"S   A"4   A"   A"   A"   A"   A"   A"z   A"[   A"<   A"   A"   A"   A"   A"   A"   A"c   A"D   A"%   A"   A"   A"   A"   A#    A#k   A#L   A#   A#   A#s   A#	T   A#
5   A#   A#   A#   A#
   A#   A#{   A#\   A#=   A#   A#   A#   A#   A#   A#   A#d   A#E   A#&   A#   A#   A#   A#   A#   A#l   A#M   A# .   A#!   A#!   A#"   A##   A#$   A#%t   A#&U   A#'6   A#(   A#(   A#)   A#*   A#+   A#,|   A#-]   A#.>   A#/   A#0    A#0   A#1   A#2   A#3   A#4e   A#5F   A#6'   A#7   A#7   A#8   A#9   A#:   A#;m   A#<N   A#=/   A#>   A#>   A#?   A#@   A#A   A#Bu   A#CV   A#D7   A#E   A#E   A#F   A#G   A#H   A#I}   A#J^   A#K?   A#L    A#M   A#M   A#N   A#O   A#P   A#Qf   A#RG   A#S(   A#T	   A#T   A#U   A#V   A#W   A#Xn   A#YO   A#Z0   A#^   A#_v   A#`W   A#a8   A#b   A#b   A#c   A#d   A#e   A#f~   A#g_   A#h@   A#i!   A#j   A#j   A#k   A#l   A#m   A#ng   A#oH   A#p)   A#q
   A#q   A#r   A#s   A#t   A#uo   A#vP   A#w1   A#x   A#x   A#y   A#z   A#{   A#|w   A#}X   A#~9   A#   A#   A#   A#   A#   A#   A#`   A#A   A#"   A#   A#   A#   A#   A#   A#h   A#I   A#*   A#   A#   A#   A#   A#   A#p   A#Q   A#2   A#   A#   A#   A#   A#   A#x   A#Y   A#:   A#   A#   A#   A#   A#   A#   A#a   A#B   A##   A#   A#   A#   A#   A#   A#i   A#J   A#+   A#   A#   A#   A#   A#   A#q   A#R   A#3   A#   A#;   A#   A#   A#   A#   A#   A#   A#b   A#C   A#$   A#   A#   A#   A#è   A#ĉ   A#j   A#K   A#,   A#
   A#   A#   A#ʰ   A#ˑ   A#r   A#S   A#4   A#ҙ   A#z   A#[   A#<   A#   A#   A#   A#   A#١   A#ڂ   A#c   A#D   A#%   A#   A#   A#   A#   A#   A#k   A#L   A#-   A#   A#   A#   A#   A#   A#s   A#T   A#5   A#   A#   A#   A#   A#   A#{   A#\   A#=   A#   A#   A#   A#   A#   A#   A#d   A#E   A#&   A#   A#   A#   A#   A#   A#l   A$ M   A$.   A$   A$   A$   A$   A$   A$t   A$U   A$6   A$	   A$	   A$]   A$>   A$   A$    A$   A$   A$   A$   A$e   A$F   A$'   A$   A$   A$   A$   A$   A$m   A$N   A$/   A$   A$   A$    A$!   A$"   A$#u   A$$V   A$%7   A$&   A$&   A$'   A$(   A$)   A$*}   A$+^   A$,?   A$-    A$.   A$.   A$/   A$0   A$1   A$2f   A$3G   A$4(   A$5	   A$5   A$6   A$7   A$8   A$9n   A$:O   A$;0   A$<   A$<   A$=   A$>   A$?   A$@v   A$AW   A$B8   A$C   A$C   A$D   A$E   A$F   A$G~   A$H_   A$I@   A$J!   A$K   A$K   A$L   A$M   A$N   A$Og   A$PH   A$Q)   A$R
   A$R   A$S   A$T   A$U   A$Vo   A$WP   A$X1   A$Y   A$Y   A$Z   A$[   A$\   A$]w   A$^X   A$_9   A$`   A$`   A$a   A$fA   A$g"   A$h   A$h   A$i   A$j   A$k   A$lh   A$mI   A$n*   A$o   A$o   A$p   A$q   A$r   A$sp   A$tQ   A$u2   A$v   A$v   A$w   A$x   A$y   A$zx   A${Y   A$|:   A$}   A$}   A$~   A$   A$   A$   A$a   A$B   A$#   A$   A$   A$   A$   A$   A$i   A$J   A$+   A$   A$   A$   A$   A$   A$q   A$R   A$3   A$   A$   A$   A$   A$   A$y   A$Z   A$;   A$   A$   A$   A$   A$   A$   A$b   A$C   A$$   A$   A$   A$   A$   A$   A$j   A$K   A$,   A$
   A$   A$   A$   A$   A$r   A$S   A$4   A$   A$   A$   A$   A$   A$z   A$[   A$<   A$   A$   A$   A$   A$%   A$   A$   A$   A$   A$   A$k   A$L   A$-   A$   A$   A$   A$ȱ   A$ɒ   A$s   A$T   A$5   A$   A$   A$   A$Ϲ   A$К   A${   A$\   A$=   A$   A$   A$   A$   A$ע   A$؃   A$d   A$E   A$&   A$   A$   A$   A$ު   A$ߋ   A$l   A$M   A$.   A$   A$   A$   A$   A$   A$t   A$U   A$6   A$   A$   A$   A$   A$   A$|   A$]   A$>   A$   A$    A$   A$   A$   A$   A$e   A$F   A$'   A$   A$   A$   A$   A$   A$m   A$N   A$/   A%    A%    A%   A%   A%   A%u   A%V   A%7   A%   A%   A%   A%	   A%
   A%}   A%^   A%
?   A%    A%   A%   A%   A%   A%	   A%   A%   A%   A%   A%n   A%O   A%0   A%   A%   A%   A%   A%    A%!v   A%"W   A%#8   A%$   A%$   A%%   A%&   A%'   A%(~   A%)_   A%*@   A%+!   A%,   A%,   A%-   A%.   A%/   A%0g   A%1H   A%2)   A%3
   A%3   A%4   A%5   A%6   A%7o   A%8P   A%91   A%:   A%:   A%;   A%<   A%=   A%>w   A%?X   A%@9   A%A   A%A   A%B   A%C   A%D   A%E   A%F`   A%GA   A%H"   A%I   A%I   A%J   A%K   A%L   A%Mh   A%NI   A%O*   A%P   A%P   A%Q   A%R   A%S   A%Tp   A%UQ   A%V2   A%W   A%W   A%X   A%Y   A%Z   A%[x   A%\Y   A%]:   A%^   A%^   A%_   A%`   A%a   A%b   A%ca   A%dB   A%e#   A%f   A%f   A%g   A%h   A%i   A%m   A%n   A%o   A%p   A%qq   A%rR   A%s3   A%t   A%t   A%u   A%v   A%w   A%xy   A%yZ   A%z;   A%{   A%{   A%|   A%}   A%~   A%   A%   A%   A%   A%   A%j   A%K   A%,   A%
   A%   A%   A%   A%   A%r   A%S   A%4   A%   A%   A%   A%   A%   A%z   A%[   A%<   A%   A%   A%   A%   A%   A%   A%c   A%D   A%%   A%   A%   A%   A%   A%   A%k   A%L   A%-   A%   A%   A%   A%   A%   A%s   A%T   A%5   A%   A%   A%   A%   A%   A%{   A%\   A%=   A%   A%   A%   A%   A%   A%   A%d   A%E   A%&   A%   A%   A%   A%   A%   A%l   A%   A%Ʋ   A%Ǔ   A%t   A%U   A%6   A%   A%   A%   A%ͺ   A%Λ   A%|   A%]   A%>   A%   A%    A%   A%   A%գ   A%ք   A%e   A%F   A%'   A%   A%   A%   A%ܫ   A%݌   A%m   A%N   A%/   A%   A%   A%   A%   A%   A%u   A%V   A%7   A%   A%   A%   A%   A%   A%}   A%^   A%?   A%    A%   A%   A%   A%   A%   A%f   A%G   A%(   A%	   A%   A%   A%   A%   A%n   A%O   A%0   A%   A%   A%   A&    A&   A&v   A&W   A&8   A&   A&   A&   A&   A&   A&	~   A&
_   A&@   A&!   A&
   A&
   A&   A&   A&   A&g   A&H   A&)   A&
   A&   A&   A&   A&   A&o   A&P   A&   A&   A&w   A& X   A&!9   A&"   A&"   A&#   A&$   A&%   A&&   A&'`   A&(A   A&)"   A&*   A&*   A&+   A&,   A&-   A&.h   A&/I   A&0*   A&1   A&1   A&2   A&3   A&4   A&5p   A&6Q   A&72   A&8   A&8   A&9   A&:   A&;   A&<x   A&=Y   A&>:   A&?   A&?   A&@   A&A   A&B   A&C   A&Da   A&EB   A&F#   A&G   A&G   A&H   A&I   A&J   A&Ki   A&LJ   A&M+   A&N   A&N   A&O   A&P   A&Q   A&Rq   A&SR   A&T3   A&U   A&U   A&V   A&W   A&X   A&Yy   A&ZZ   A&[;   A&\   A&\   A&]   A&^   A&_   A&`   A&ab   A&bC   A&c$   A&d   A&d   A&e   A&f   A&g   A&hj   A&iK   A&j,   A&k
   A&k   A&l   A&m   A&n   A&or   A&pS   A&q4   A&u   A&vz   A&w[   A&x<   A&y   A&y   A&z   A&{   A&|   A&}   A&~c   A&D   A&%   A&   A&   A&   A&   A&   A&k   A&L   A&-   A&   A&   A&   A&   A&   A&s   A&T   A&5   A&   A&   A&   A&   A&   A&{   A&\   A&=   A&   A&   A&   A&   A&   A&   A&d   A&E   A&&   A&   A&   A&   A&   A&   A&l   A&M   A&.   A&   A&   A&   A&   A&   A&t   A&U   A&6   A&   A&   A&   A&   A&   A&|   A&]   A&>   A&   A&    A&   A&   A&   A&   A&e   A&F   A&'   A&   A&   A&   A&   A&   A&m   A&N   A&/   A&   A&   A&   A&ĳ   A&Ŕ   A&u   A&V   A&7   A&   A&}   A&^   A&?   A&    A&   A&   A&   A&Ӥ   A&ԅ   A&f   A&G   A&(   A&	   A&   A&   A&ڬ   A&ۍ   A&n   A&O   A&0   A&   A&   A&   A&   A&   A&v   A&W   A&8   A&   A&   A&   A&   A&   A&~   A&_   A&@   A&!   A&   A&   A&   A&   A&   A&g   A&H   A&)   A&
   A&   A&   A&   A&   A&o   A&P   A&1   A&   A&   A&   A&   A&   A' w   A'X   A'9   A'   A'   A'   A'   A'   A'   A'`   A'	A   A'
"   A'   A'   A'   A'
   A'   A'h   A'I   A'*   A'   A'   A'   A'   A'   A'p   A'Q   A'2   A'   A'   A'   A'   A'   A'x   A'Y   A':   A'    A'    A'%a   A'&B   A''#   A'(   A'(   A')   A'*   A'+   A',i   A'-J   A'.+   A'/   A'/   A'0   A'1   A'2   A'3q   A'4R   A'53   A'6   A'6   A'7   A'8   A'9   A':y   A';Z   A'<;   A'=   A'=   A'>   A'?   A'@   A'A   A'Bb   A'CC   A'D$   A'E   A'E   A'F   A'G   A'H   A'Ij   A'JK   A'K,   A'L
   A'L   A'M   A'N   A'O   A'Pr   A'QS   A'R4   A'S   A'S   A'T   A'U   A'V   A'Wz   A'X[   A'Y<   A'Z   A'Z   A'[   A'\   A']   A'^   A'_c   A'`D   A'a%   A'b   A'b   A'c   A'd   A'e   A'fk   A'gL   A'h-   A'i   A'i   A'j   A'k   A'l   A'ms   A'nT   A'o5   A'p   A'p   A'q   A'r   A's   A't{   A'u\   A'v=   A'w   A'w   A'x   A'}E   A'~&   A'   A'   A'   A'   A'   A'l   A'M   A'.   A'   A'   A'   A'   A'   A't   A'U   A'6   A'   A'   A'   A'   A'   A'|   A']   A'>   A'   A'    A'   A'   A'   A'   A'e   A'F   A''   A'   A'   A'   A'   A'   A'm   A'N   A'/   A'   A'   A'   A'   A'   A'u   A'V   A'7   A'   A'   A'   A'   A'   A'}   A'^   A'?   A'    A'   A'   A'   A'   A'   A'f   A'G   A'(   A'	   A'   A'   A'   A'   A'n   A'O   A'0   A'   A'   A'   A'´   A'Õ   A'v   A'W   A'8   A'   A'   A'   A'ɼ   A'ʝ   A'~   A'_   A'@   A'!   A'   A'   A'   A')   A'
   A'   A'   A'ح   A'َ   A'o   A'P   A'1   A'   A'   A'   A'ߵ   A'   A'w   A'X   A'9   A'   A'   A'   A'   A'   A'   A'`   A'A   A'"   A'   A'   A'   A'   A'   A'h   A'I   A'*   A'   A'   A'   A'   A'   A'p   A'Q   A'2   A'   A'   A'   A'   A'   A'x   A'Y   A( :   A(   A(   A(   A(   A(   A(   A(a   A(B   A(#   A(	   A(	   A(
   A(   A(   A(
i   A(J   A(+   A(   A(   A(   A(   A(   A(q   A(R   A(3   A(   A(   A(   A(   A(   A(y   A(Z   A(;   A(   A(   A(   A(    A(!   A("   A(#b   A($C   A(%$   A(&   A(&   A('   A((   A(-
   A(-   A(.   A(/   A(0   A(1r   A(2S   A(34   A(4   A(4   A(5   A(6   A(7   A(8z   A(9[   A(:<   A(;   A(;   A(<   A(=   A(>   A(?   A(@c   A(AD   A(B%   A(C   A(C   A(D   A(E   A(F   A(Gk   A(HL   A(I-   A(J   A(J   A(K   A(L   A(M   A(Ns   A(OT   A(P5   A(Q   A(Q   A(R   A(S   A(T   A(U{   A(V\   A(W=   A(X   A(X   A(Y   A(Z   A([   A(\   A(]d   A(^E   A(_&   A(`   A(`   A(a   A(b   A(c   A(dl   A(eM   A(f.   A(g   A(g   A(h   A(i   A(j   A(kt   A(lU   A(m6   A(n   A(n   A(o   A(p   A(q   A(r|   A(s]   A(t>   A(u   A(v    A(v   A(w   A(x   A(y   A(ze   A({F   A(|'   A(}   A(}   A(~   A(   A(   A(   A(   A(   A(   A(u   A(V   A(7   A(   A(   A(   A(   A(   A(}   A(^   A(?   A(    A(   A(   A(   A(   A(   A(f   A(G   A((   A(	   A(   A(   A(   A(   A(n   A(O   A(0   A(   A(   A(   A(   A(   A(v   A(W   A(8   A(   A(   A(   A(   A(   A(~   A(_   A(@   A(!   A(   A(   A(   A(   A(   A(g   A(H   A()   A(
   A(   A(   A(   A(   A(o   A(P   A(1   A(   A(   A(   A(   A(   A(w   A(X   A(9   A(   A(   A(   A(ǽ   A(Ȟ   A(   A(`   A(A   A("   A(   A(   A(   A(Ϧ   A(Ї   A(h   A(I   A(*   A(   A(   A(   A(֮   A(׏   A(p   A(   A(ݶ   A(ޗ   A(x   A(Y   A(:   A(   A(   A(   A(   A(   A(   A(a   A(B   A(#   A(   A(   A(   A(   A(   A(i   A(J   A(+   A(   A(   A(   A(   A(   A(q   A(R   A(3   A(   A(   A(   A(   A(   A(y   A(Z   A(;   A(   A(   A)    A)   A)   A)   A)b   A)C   A)$   A)   A)   A)   A)	   A)
   A)j   A)K   A)
,   A)
   A)   A)   A)   A)   A)r   A)S   A)4   A)   A)   A)   A)   A)   A)z   A)[   A)<   A)   A)   A)   A)   A)   A)    A)!c   A)"D   A)#%   A)$   A)$   A)%   A)&   A)'   A)(k   A))L   A)*-   A)+   A)+   A),   A)-   A).   A)/s   A)0T   A)4   A)5   A)6{   A)7\   A)8=   A)9   A)9   A):   A);   A)<   A)=   A)>d   A)?E   A)@&   A)A   A)A   A)B   A)C   A)D   A)El   A)FM   A)G.   A)H   A)H   A)I   A)J   A)K   A)Lt   A)MU   A)N6   A)O   A)O   A)P   A)Q   A)R   A)S|   A)T]   A)U>   A)V   A)W    A)W   A)X   A)Y   A)Z   A)[e   A)\F   A)]'   A)^   A)^   A)_   A)`   A)a   A)bm   A)cN   A)d/   A)e   A)e   A)f   A)g   A)h   A)iu   A)jV   A)k7   A)l   A)l   A)m   A)n   A)o   A)p}   A)q^   A)r?   A)s    A)t   A)t   A)u   A)v   A)w   A)xf   A)yG   A)z(   A){	   A){   A)|   A)}   A)~   A)n   A)O   A)0   A)   A)   A)   A)   A)   A)v   A)W   A)8   A)   A)   A)   A)   A)   A)~   A)_   A)@   A)!   A)   A)   A)   A)   A)   A)g   A)H   A))   A)
   A)   A)   A)   A)   A)o   A)P   A)1   A)   A)   A)   A)   A)   A)w   A)X   A)9   A)   A)   A)   A)   A)   A)   A)`   A)A   A)"   A)   A)   A)   A)   A)   A)h   A)I   A)*   A)   A)   A)   A)   A)   A)p   A)   A)   A)   A)x   A)Y   A):   A)   A)   A)   A)ž   A)Ɵ   A)ǀ   A)a   A)B   A)#   A)   A)   A)   A)ͧ   A)Έ   A)i   A)J   A)+   A)   A)   A)   A)ԯ   A)Ր   A)q   A)R   A)3   A)   A)   A)   A)۷   A)ܘ   A)y   A)Z   A);   A)   A)   A)   A)   A)   A)   A)b   A)C   A)$   A)   A)   A)   A)   A)   A)j   A)K   A),   A)
   A)   A)   A)   A)   A)r   A)S   A)4   A)   A)   A)   A)   A)   A)z   A)[   A)<   A)   A)   A)   A)   A*    A*   A*c   A*D   A*%   A*   A*   A*   A*   A*   A*	k   A*
L   A*5]   A*6>   A*7   A*8    A*8   A*9   A*:   A*;   A*<e   A*=F   A*>'   A*?   A*?   A*@   A*A   A*B   A*Cm   A*DN   A*E/   A*F   A*F   A*G   A*H   A*I   A*Ju   A*KV   A*L7   A*M   A*M   A*N   A*O   A*P   A*Q}   A*R^   A*S?   A*T    A*\	   A*\   A*]   A*^   A*   A*   A*   A*`   A*A   A*"   A*   A*   A*   A*   A*   A*h   A*I   A**   A*   A*   A*   A*   A*   A*p   A*Q   A*2   A*   A*   A*   A*   A*   A*x   A*Y   A*:   A*   A*   A*   A*   A*   A*   A*a   A*B   A*#   A*   A*   A*   A*   A*   A*q   A*R   A*3   A*   A*   A*   A*   A*   A*y   A*Z   A*;   A*   A*   A*   A*ÿ   A*Ġ   A*Ł   A*b   A*C   A*$   A*   A*   A*   A*˨   A*̉   A*j   A*K   A*,   A*
   A*   A*   A*Ұ   A*ӑ   A*r   A*S   A*4   A*   A*   A*   A*ٸ   A*%   A*   A*   A*   A*-   A*   A*   A*   A*   A*   A*s   A*T   A*5   A*   A*   A*   A*   A*   A*{   A*\   A*=   A*   A*   A*   A*   A*   A*   A+ d   A+E   A+&   A+   A+   A+   A+   A+   A+l   A+M   A+	.   A+
   A+
   A+   A+   A+
   A+t   A+U   A+6   A+   A+   A+   A+   A+   A+|   A+]   A+>   A+   A+    A+   A+   A+   A+   A+e   A+F   A+'   A+    A+    A+!   A+"   A+#   A+$m   A+%N   A+&/   A+'   A+'   A+(   A+)   A+*   A++u   A+,V   A+-7   A+.   A+.   A+/   A+0   A+1   A+2}   A+3^   A+4?   A+5    A+6   A+6   A+7   A+8   A+9   A+:f   A+;G   A+<(   A+=	   A+=   A+>   A+?   A+D   A+D   A+E   A+F   A+G   A+Hv   A+IW   A+J8   A+K   A+K   A+L   A+M   A+N   A+O~   A+P_   A+Q@   A+R!   A+S   A+S   A+T   A+U   A+V   A+Wg   A+XH   A+Y)   A+Z
   A+Z   A+[   A+\   A+]   A+^o   A+_P   A+`1   A+a   A+a   A+b   A+c   A+d   A+ew   A+fX   A+g9   A+h   A+h   A+i   A+j   A+k   A+l   A+m`   A+nA   A+o"   A+p   A+p   A+q   A+r   A+s   A+th   A+ɩ   A+ʊ   A+k   A+L   A+-   A+   A+   A+   A+б   A+ђ   A+s   A+T   A+5   A+   A+   A+   A+׹   A+ؚ   A+{   A+\   A+=   A+   A+   A+   A+   A+ߢ   A+   A+d   A+E   A+&   A+   A+   A+   A+   A+   A+l   A+M   A+.   A+   A+   A+   A+   A+   A+t   A+   A+   A+   A+|   A+]   A+>   A+   A+    A+   A+   A+   A+   A+e   A+F   A, '   A,   A,   A,   A,   A,   A,m   A,N   A,/   A,   A,   A,	   A,
   A,   A,u   A,
V   A,7   A,   A,   A,   A,   A,   A,}   A,^   A,?   A,    A,   A,   A,   A,   A,   A,f   A,G   A,(   A,	   A,   A,   A,    A,!   A,"n   A,#O   A,$0   A,%   A,%   A,&   A,'   A,(   A,)v   A,*W   A,+8   A,,   A,,   A,-   A,.   A,/   A,0~   A,1_   A,2@   A,3!   A,4   A,4   A,5   A,6   A,7   A,8g   A,9H   A,:)   A,;
   A,;   A,<   A,=   A,>   A,?o   A,@P   A,K   A,L   A,M   A,N`   A,OA   A,P"   A,Q   A,Q   A,R   A,S   A,T   A,Uh   A,VI   A,W*   A,X   A,X   A,Y   A,Z   A,[   A,\p   A,]Q   A,^2   A,_   A,_   A,`   A,a   A,b   A,cx   A,dY   A,e:   A,f   A,f   A,g   A,h   A,i   A,j   A,ka   A,lB   A,m#   A,n   A,n   A,o   A,p   A,q   A,ri   A,sJ   A,t+   A,u   A,yq   A,zR   A,{3   A,|   A,|   A,}   A,~   A,   A,y   A,Z   A,;   A,   A,   A,   A,   A,   A,   A,b   A,C   A,$   A,   A,   A,   A,   A,   A,j   A,K   A,,   A,
   A,   A,   A,   A,   A,r   A,S   A,4   A,   A,   A,   A,   A,   A,z   A,[   A,<   A,   A,   A,c   A,D   A,%   A,   A,   A,   A,   A,   A,k   A,L   A,-   A,   A,   A,   A,   A,   A,s   A,T   A,5   A,   A,   A,   A,=   A,   A,   A,   A,   A,Ǫ   A,ȋ   A,l   A,   A,β   A,ϓ   A,t   A,U   A,6   A,   A,   A,   A,պ   A,֛   A,|   A,]   A,>   A,   A,    A,   A,   A,ݣ   A,ބ   A,e   A,F   A,'   A,   A,   A,   A,   A,   A,m   A,N   A,/   A,   A,   A,   A,   A,   A,u   A,V   A,7   A,   A,   A,   A,   A,   A,}   A,^   A,?   A,    A,   A,f   A,G   A,(   A,	   A,   A-    A-   A-   A-n   A-O   A-0   A-   A-   A-   A-   A-	   A-
v   A-W   A-8   A-
   A-
   A-   A-   A-   A-~   A-_   A-@   A-!   A-   A-   A-   A-   A-   A-g   A-H   A-)   A-
   A-   A-   A-   A-   A- o   A-!P   A-"1   A-#   A-#   A-$   A-%   A-&   A-'w   A-(X   A-)9   A-*   A-*   A-+   A-,   A--   A-.   A-/`   A-0A   A-1"   A-2   A-2   A-3   A-4   A-5   A-6h   A-7I   A-8*   A-9   A-9   A-:   A-;   A-<   A-=p   A->Q   A-?2   A-@   A-@   A-A   A-B   A-C   A-Dx   A-EY   A-F:   A-G   A-G   A-H   A-I   A-J   A-K   A-La   A-MB   A-N#   A-O   A-Si   A-TJ   A-U+   A-V   A-V   A-W   A-X   A-Y   A-Zq   A-[R   A-\3   A-]   A-]   A-^   A-_   A-`   A-ay   A-bZ   A-c;   A-d   A-d   A-e   A-f   A-g   A-h   A-ib   A-jC   A-k$   A-l   A-l   A-m   A-n   A-o   A-pj   A-qK   A-r,   A-s
   A-s   A-t   A-u   A-v   A-wr   A-xS   A-y4   A-z   A-z   A-{   A-|   A-}   A-~z   A-[   A-<   A-   A-   A-   A-   A-   A-   A-c   A-D   A-%   A-   A-   A-   A-   A-   A-k   A-L   A--   A-   A-   A-   A-   A-   A-s   A-T   A-5   A-   A-   A-   A-   A-   A-{   A-\   A-=   A-   A-   A-   A-   A-   A-   A-d   A-   A-   A-ū   A-ƌ   A-m   A-N   A-/   A-   A-   A-   A-̳   A-͔   A-u   A-V   A-7   A-   A-   A-   A-ӻ   A-Ԝ   A-}   A-^   A-?   A-    A-   A-   A-   A-ۤ   A-܅   A-f   A-G   A-(   A-	   A-   A-   A-   A-   A-n   A-O   A-0   A-   A-   A-   A-   A-   A-v   A-W   A-8   A-   A-   A-   A-   A-   A-~   A-_   A-@   A-!   A-   A-   A-   A-   A-   A-g   A-H   A-)   A-
   A-   A-   A.A   A."   A.   A.   A.   A.   A.   A.h   A.I   A.*   A.   A.   A.   A.   A.   A.p   A.Q   A. 2   A.!   A.!   A."   A.#   A.$   A.%x   A.&Y   A.':   A.(   A.(   A.)   A.*   A.+   A.,   A.-a   A..B   A./#   A.0   A.0   A.1   A.2   A.3   A.4i   A.5J   A.6+   A.7   A.7   A.8   A.9   A.:   A.;q   A.<R   A.=3   A.>   A.>   A.?   A.@   A.A   A.By   A.CZ   A.D;   A.E   A.E   A.F   A.G   A.H   A.I   A.Jb   A.KC   A.L$   A.M   A.M   A.N   A.O   A.P   A.Qj   A.RK   A.S,   A.T
   A.T   A.U   A.V   A.[   A.[   A.\   A.]   A.^   A._z   A.`[   A.a<   A.b   A.b   A.c   A.d   A.e   A.f   A.gc   A.hD   A.i%   A.j   A.j   A.k   A.l   A.m   A.nk   A.oL   A.p-   A.q   A.q   A.r   A.s   A.t   A.us   A.vT   A.w5   A.x   A.x   A.y   A.z   A.{   A.|{   A.}\   A.~=   A.   A.   A.   A.   A.   A.   A.d   A.E   A.&   A.   A.   A.   A.   A.   A.l   A.M   A..   A.   A.   A.   A.   A.   A.t   A.U   A.6   A.   A.   A.   A.   A.   A.|   A.]   A.>   A.   A.    A.   A.   A.   A.   A.e   A.F   A.'   A.   A.   A.   A.   A.   A.m   A.N   A./   A.   A.   A.   A.   A.   A.   A.   A.   A.   A.}   A.^   A.?   A.    A.   A.   A.   A.   A.   A.f   A.G   A.(   A.	   A.   A.   A.ì   A.   A.   A.   A.ʴ   A.˕   A.v   A.W   A.8   A.   A.   A.   A.Ѽ   A.ҝ   A.~   A._   A.@   A.!   A.   A.   A.   A.٥   A.چ   A.g   A.H   A.)   A.
   A.   A.   A.   A.   A.o   A.P   A.1   A.   A.   A.   A.   A.   A.w   A.X   A.9   A.   A.   A.   A.   A.   A.   A.`   A.A   A."   A.   A.   A.   A.   A.   A.h   A.I   A.*   A.   A.   A.   A.   A.   A.p   A/ Q   A/2   A/   A/   A/   A/   A/   A/x   A/
   A/   A/   A/
   A/a   A/B   A/#   A/   A/   A/   A/   A/   A/i   A/J   A/+   A/   A/   A/   A/   A/   A/q   A/R   A/3   A/   A/   A/    A/!   A/"   A/#y   A/$Z   A/%;   A/&   A/&   A/'   A/(   A/)   A/*   A/+b   A/,C   A/-$   A/.   A/.   A//   A/0   A/1   A/2j   A/3K   A/4,   A/5
   A/5   A/6   A/7   A/8   A/9r   A/:S   A/;4   A/<   A/<   A/=   A/>   A/?   A/@z   A/A[   A/B<   A/C   A/C   A/D   A/E   A/F   A/G   A/Hc   A/ID   A/J%   A/K   A/K   A/L   A/M   A/N   A/Ok   A/PL   A/Q-   A/R   A/R   A/S   A/T   A/U   A/Vs   A/WT   A/X5   A/Y   A/Y   A/Z   A/[   A/\   A/]{   A/^\   A/b   A/c   A/d   A/ed   A/fE   A/g&   A/h   A/h   A/i   A/j   A/k   A/ll   A/mM   A/n.   A/o   A/o   A/p   A/q   A/r   A/st   A/tU   A/u6   A/v   A/v   A/w   A/x   A/y   A/z|   A/{]   A/|>   A/}   A/~    A/~   A/   A/   A/   A/e   A/F   A/'   A/   A/   A/   A/   A/   A/m   A/N   A//   A/   A/   A/   A/   A/   A/u   A/V   A/7   A/   A/   A/   A/   A/   A/}   A/^   A/?   A/    A/   A/   A/   A/   A/   A/f   A/G   A/(   A/	   A/   A/   A/   A/   A/n   A/O   A/0   A/   A/   A/   A/   A/   A/v   A/W   A/8   A/   A/   A/   A/   A/   A/~   A/_   A/@   A/   A/   A/g   A/H   A/)   A/
   A/   A/   A/   A/   A/o   A/P   A/1   A/   A/   A/   A/ȵ   A/ɖ   A/w   A/X   A/9   A/   A/   A/   A/Ͻ   A/О   A/   A/`   A/A   A/"   A/   A/   A/   A/צ   A/؇   A/h   A/I   A/*   A/   A/   A/   A/ޮ   A/ߏ   A/p   A/Q   A/2   A/   A/   A/   A/   A/   A/x   A/Y   A/:   A/   A/   A/   A/   A/   A/   A/a   A/B   A/#   A/   A/   A/   A/   A/   A/i   A/J   A/+   A/   A/   A/   A/   A/   A/q   A/R   A/3   A0    A0    A0   A0   A0   A0y   A0Z   A0;   A0   A0   A0j   A0K   A0,   A0
   A0   A0   A0   A0   A0r   A0S   A04   A0   A0   A0   A0   A0    A0!z   A0"[   A0#<   A0$   A0$   A0%   A0&   A0'   A0(   A0)c   A0*D   A0+%   A0,   A0,   A0-   A0.   A0/   A00k   A01L   A02-   A03   A03   A04   A05   A06   A07s   A08T   A095   A0:   A0:   A0;   A0<   A0=   A0>{   A0?\   A0@=   A0A   A0A   A0B   A0C   A0D   A0E   A0Fd   A0GE   A0H&   A0I   A0I   A0J   A0K   A0L   A0Ml   A0NM   A0O.   A0P   A0P   A0Q   A0R   A0S   A0Tt   A0UU   A0V6   A0W   A0W   A0X   A0Y   A0Z   A0[|   A0\]   A0]>   A0^   A0_    A0_   A0`   A0a   A0b   A0ce   A0dF   A0e'   A0f   A0jm   A0kN   A0l/   A0m   A0m   A0n   A0o   A0p   A0qu   A0rV   A0s7   A0t   A0t   A0u   A0v   A0w   A0x}   A0y^   A0z?   A0{    A0|   A0|   A0}   A0~   A0   A0f   A0G   A0(   A0	   A0   A0   A0   A0   A0n   A0O   A00   A0   A0   A0   A0   A0   A0v   A0W   A08   A0   A0   A0   A0   A0   A0~   A0_   A0@   A0!   A0   A0   A0   A0   A0   A0g   A0H   A0)   A0
   A0   A0   A0   A0   A0o   A0P   A01   A0   A0   A0   A0   A0   A0w   A0X   A09   A0   A0   A0   A0   A0   A0   A0`   A0A   A0"   A0   A0   A0   A0   A0   A0h   A0I   A0*   A0   A0   A0Q   A02   A0   A0   A0   A0ƶ   A0Ǘ   A0x   A0Y   A0:   A0   A0   A0   A0;   A0Ο   A0π   A0a   A0B   A0#   A0   A0   A0   A0է   A0ֈ   A0i   A0J   A0+   A0   A0   A0   A0ܯ   A0ݐ   A0q   A0R   A03   A0   A0   A0   A0   A0   A0y   A0Z   A0;   A0   A0   A0   A0   A0   A0   A0b   A0C   A0$   A0   A0   A0   A0   A0   A0j   A0K   A0,   A0
   A0   A0   A0   A0   A0r   A0S   A04   A0   A0   A0   A1    A1   A1z   A1[   A1<   A1   A1   A1   A1   A1   A1	   A1
c   A1D   A1%   A1
   A1
   A1   A1   A1   A1k   A1L   A1-   A1   A1   A1   A15   A1   A1   A1   A1   A1   A1{   A1 \   A1!=   A1"   A1"   A1#   A1$   A1%   A1&   A1'd   A1(E   A1)&   A1*   A1*   A1+   A1,   A1-   A1.l   A1/M   A10.   A11   A11   A12   A13   A14   A15t   A16U   A176   A18   A18   A19   A1:   A1;   A1<|   A1=]   A1>>   A1?   A1@    A1@   A1A   A1B   A1C   A1De   A1EF   A1F'   A1G   A1G   A1H   A1I   A1J   A1Km   A1LN   A1M/   A1N   A1N   A1O   A1P   A1Q   A1Ru   A1SV   A1T7   A1U   A1U   A1V   A1W   A1X   A1Y}   A1Z^   A1[?   A1\    A1]   A1]   A1^   A1_   A1`   A1af   A1bG   A1c(   A1d	   A1d   A1e   A1f   A1g   A1hn   A1iO   A1j0   A1k   A1k   A1l   A1m   A1ov   A1pW   A1q8   A1r   A1r   A1s   A1t   A1u   A1v~   A1w_   A1x@   A1y!   A1z   A1z   A1{   A1|   A1}   A1~g   A1H   A1)   A1
   A1   A1   A1   A1   A1o   A1P   A11   A1   A1   A1   A1   A1   A1w   A1X   A19   A1   A1   A1   A1   A1   A1   A1`   A1A   A1"   A1   A1   A1   A1   A1   A1h   A1I   A1*   A1   A1   A1   A1   A1   A1p   A1Q   A12   A1   A1   A1   A1   A1   A1x   A1Y   A1:   A1   A1   A1   A1   A1   A1   A1a   A1B   A1#   A1   A1   A1   A1   A1   A1i   A1J   A1+   A1   A1   A1   A1   A1   A1q   A1R   A13   A1   A1   A1   A1ķ   A1Ř   A1   A1   A1˿   A1̠   A1́   A1b   A1C   A1$   A1   A1   A1   A1Ө   A1ԉ   A1j   A1K   A1,   A1
   A1   A1   A1ڰ   A1ۑ   A1r   A1S   A14   A1   A1   A1   A1   A1   A1z   A1[   A1<   A1   A1   A1   A1   A1   A1   A1c   A1D   A1%   A1   A1   A1   A1   A1   A1k   A1L   A1-   A1   A1   A1   A1   A1   A1s   A1T   A15   A1   A1   A1   A1   A1   A2 {   A2\   A2=   A2   A2   A2   A2   A2   A2   A2d   A2	E   A2
&   A2   A2   A2   A2
   A2   A2l   A2M   A2.   A2   A2   A2   A2   A2   A2t   A2U   A26   A2   A2   A2   A2   A2   A2|   A2!   A2"   A2#   A2$   A2%e   A2&F   A2''   A2(   A2(   A2)   A2*   A2+   A2,m   A2-N   A2./   A2/   A2/   A20   A21   A22   A23u   A24V   A257   A26   A26   A27   A28   A29   A2:}   A2;^   A2<?   A2=    A2>   A2>   A2?   A2@   A2A   A2Bf   A2CG   A2D(   A2E	   A2E   A2F   A2G   A2H   A2In   A2JO   A2K0   A2L   A2L   A2M   A2N   A2O   A2Pv   A2QW   A2R8   A2S   A2S   A2T   A2U   A2V   A2W~   A2X_   A2Y@   A2Z!   A2[   A2[   A2\   A2]   A2^   A2_g   A2`H   A2a)   A2b
   A2b   A2c   A2d   A2e   A2fo   A2gP   A2h1   A2i   A2i   A2j   A2k   A2l   A2mw   A2nX   A2o9   A2p   A2p   A2q   A2r   A2s   A2t   A2u`   A2y   A2z   A2{   A2|h   A2}I   A2~*   A2   A2   A2   A2   A2   A2p   A2Q   A22   A2   A2   A2   A2   A2   A2x   A2Y   A2:   A2   A2   A2   A2   A2   A2   A2a   A2B   A2#   A2   A2   A2   A2   A2   A2i   A2J   A2+   A2   A2   A2   A2   A2   A2q   A2R   A23   A2   A2   A2   A2   A2   A2y   A2Z   A2;   A2   A2   A2   A2   A2   A2   A2b   A2C   A2$   A2   A2   A2   A2   A2   A2j   A2K   A2,   A2
   A2   A2   A2   A2   A2r   A2S   A24   A2   A2   A2   A2¸   A2Ù   A2z   A2[   A2<   A2   A2   A2   A2   A2ʡ   A2˂   A2c   A2D   A2%   A2   A2   A2   A2ѩ   A2Ҋ   A2k   A2L   A2-   A2   A2   A2   A2ر   A2ْ   A2s   A2T   A25   A2   A2   A2   A2߹   A2   A2{   A2\   A2=   A2   A2   A2   A2   A2   A2   A2d   A2E   A2&   A2   A2   A2   A2   A2   A2l   A2M   A2.   A2   A2   A2   A2   A2   A2t   A2U   A26   A2   A2   A2   A2   A2   A2|   A2]   A3 >   A3   A3    A3   A3   A3   A3   A3e   A3F   A3'   A3	   A3	   A3
   A3   A3   A3
m   A3N   A3/   A3   A3   A3   A3   A3   A3u   A3V   A37   A3   A3   A3   A3   A3   A3}   A3^   A3?   A3    A3   A3   A3    A3!   A3"   A3#f   A3$G   A3%(   A3)   A3*n   A3+O   A3,0   A3-   A3-   A3.   A3/   A30   A31v   A32W   A338   A34   A34   A35   A36   A37   A38~   A39_   A3:@   A3;!   A3<   A3<   A3=   A3>   A3?   A3@g   A3AH   A3B)   A3C
   A3C   A3D   A3E   A3F   A3Go   A3HP   A3I1   A3J   A3J   A3K   A3L   A3M   A3Nw   A3OX   A3P9   A3Q   A3Q   A3R   A3S   A3T   A3U   A3V`   A3WA   A3X"   A3Y   A3Y   A3Z   A3[   A3\   A3]h   A3^I   A3_*   A3`   A3`   A3a   A3b   A3c   A3dp   A3eQ   A3f2   A3g   A3g   A3h   A3i   A3j   A3kx   A3lY   A3m:   A3n   A3n   A3o   A3p   A3q   A3r   A3sa   A3tB   A3u#   A3v   A3v   A3w   A3x   A3y   A3zi   A3{J   A3|+   A3}   A3q   A3R   A33   A3   A3   A3   A3   A3   A3y   A3Z   A3;   A3   A3   A3   A3   A3   A3   A3b   A3C   A3$   A3   A3   A3   A3   A3   A3j   A3K   A3,   A3
   A3   A3   A3   A3   A3r   A3S   A34   A3   A3   A3   A3   A3   A3z   A3[   A3<   A3   A3   A3   A3   A3   A3   A3c   A3D   A3%   A3   A3   A3   A3   A3   A3k   A3L   A3-   A3   A3   A3   A3   A3   A3s   A3T   A35   A3   A3   A3   A3   A3   A3{   A3\   A3=   A3   A3   A3   A3   A3Ȣ   A3Ƀ   A3d   A3E   A3&   A3   A3   A3   A3Ϫ   A3Ћ   A3l   A3M   A3.   A3   A3   A3U   A36   A3   A3   A3   A3ݺ   A3ޛ   A3|   A3]   A3>   A3   A3    A3   A3   A3   A3   A3e   A3F   A3'   A3   A3   A3   A3   A3   A3m   A3N   A3/   A3   A3   A3   A3   A3   A3u   A3V   A37   A3   A3   A3   A3   A3   A3}   A3^   A3?   A3    A4    A4    A4   A4   A4   A4f   A4G   A4(   A4	   A4   A4   A4	   A4
   A4n   A4O   A4
0   A4   A4   A4   A4   A4   A4v   A4W   A48   A4   A4   A4   A4   A4   A4~   A4_   A4@   A4!   A4   A4   A4   A4   A4    A4!g   A4"H   A4#)   A4$
   A4$   A4%   A4&   A4'   A4(o   A4)P   A4*1   A4+   A4+   A4,   A419   A42   A42   A43   A44   A45   A46   A47`   A48A   A49"   A4:   A4:   A4;   A4<   A4=   A4>h   A4?I   A4@*   A4A   A4A   A4B   A4C   A4D   A4Ep   A4FQ   A4G2   A4H   A4H   A4I   A4J   A4K   A4Lx   A4MY   A4N:   A4O   A4O   A4P   A4Q   A4R   A4S   A4Ta   A4UB   A4V#   A4W   A4W   A4X   A4Y   A4Z   A4[i   A4\J   A4]+   A4^   A4^   A4_   A4`   A4a   A4bq   A4cR   A4d3   A4e   A4e   A4f   A4g   A4h   A4iy   A4jZ   A4k;   A4l   A4l   A4m   A4n   A4o   A4p   A4qb   A4rC   A4s$   A4t   A4t   A4u   A4v   A4w   A4xj   A4yK   A4z,   A4{
   A4{   A4|   A4}   A4~   A4r   A4S   A44   A4   A4   A4   A4   A4   A4   A4   A4   A4   A4   A4c   A4D   A4%   A4   A4   A4   A4   A4   A4k   A4L   A4-   A4   A4   A4   A4   A4   A4s   A4T   A45   A4   A4   A4   A4   A4   A4{   A4\   A4=   A4   A4   A4   A4   A4   A4   A4d   A4E   A4&   A4   A4   A4   A4   A4   A4l   A4M   A4.   A4   A4   A4   A4   A4   A4t   A4U   A46   A4   A4   A4   A4   A4   A4|   A4]   A4>   A4   A4    A4   A4   A4ƣ   A4Ǆ   A4e   A4F   A4'   A4   A4   A4   A4ͫ   A4Ό   A4m   A4N   A4/   A4   A4   A4   A4Գ   A4Ք   A4u   A4V   A47   A4   A4   A4   A4ۻ   A4ܜ   A4   A4   A4   A4   A4   A4f   A4G   A4(   A4	   A4   A4   A4   A4   A4n   A4O   A40   A4   A4   A4   A4   A4   A4v   A4W   A48   A4   A4   A4   A4   A4   A4~   A4_   A4@   A4!   A4   A4   A4   A5    A5   A5g   A5H   A5)   A5
   A5   A5   A5   A5   A5	o   A5
P   A51   A5   A5   A5
   A5   A5   A5w   A5X   A59   A5   A5   A5   A5   A5   A5   A5`   A5A   A5"   A5   A5   A5   A5   A5   A5h   A5 I   A5!*   A5"   A5"   A5#   A5$   A5%   A5&p   A5'Q   A5(2   A5)   A5)   A5*   A5+   A5,   A5-x   A5.Y   A5/:   A50   A50   A51   A52   A53   A54   A55a   A56B   A57#   A58   A58   A59   A5:   A5;   A5<i   A5=J   A5>+   A5?   A5?   A5@   A5A   A5B   A5Cq   A5DR   A5E3   A5F   A5F   A5G   A5H   A5I   A5Jy   A5KZ   A5L;   A5M   A5M   A5N   A5O   A5P   A5Q   A5Rb   A5SC   A5T$   A5U   A5U   A5V   A5W   A5X   A5Yj   A5ZK   A5[,   A5\
   A5\   A5]   A5^   A5_   A5`r   A5aS   A5b4   A5c   A5c   A5d   A5e   A5f   A5gz   A5h[   A5i<   A5j   A5j   A5k   A5l   A5m   A5n   A5oc   A5pD   A5q%   A5r   A5r   A5s   A5t   A5u   A5vk   A5wL   A5x-   A5y   A5y   A5z   A5{   A5|   A5}s   A5~T   A55   A5   A5   A5   A5   A5   A5{   A5\   A5=   A5   A5   A5   A5   A5   A5   A5d   A5   A5   A5   A5l   A5M   A5.   A5   A5   A5   A5   A5   A5t   A5U   A56   A5   A5   A5   A5   A5   A5|   A5]   A5>   A5   A5    A5   A5   A5   A5   A5e   A5F   A5'   A5   A5   A5   A5   A5   A5   A5   A5   A5   A5u   A5V   A57   A5   A5   A5   A5   A5   A5}   A5^   A5?   A5    A5   A5   A5   A5Ĥ   A5Ņ   A5f   A5G   A5(   A5	   A5   A5   A5ˬ   A5̍   A5n   A5O   A50   A5   A5   A5   A5Ҵ   A5ӕ   A5v   A5W   A58   A5   A5   A5   A5ټ   A5ڝ   A5~   A5_   A5@   A5!   A5   A5   A5   A5   A5   A5o   A5P   A51   A5   A5   A5   A5   A5   A5w   A5X   A59   A5   A5   A5   A5   A5   A5   A5`   A5A   A5"   A5   A5   A5   A5   A5   A6 h   A6I   A6*   A6   A6   A6   A6   A6   A6p   A6Q   A6	2   A6
   A6
   A6   A6   A6
   A6x   A6Y   A6:   A6   A6   A6   A6   A6   A6   A6a   A6B   A6#   A6   A6   A6   A6   A6   A6i   A6J   A6+   A6    A6    A6!   A6"   A6#   A6$q   A6%R   A6&3   A6'   A6'   A6(   A6)   A6*   A6+y   A6,Z   A6-;   A6.   A6.   A6/   A60   A61   A62   A63b   A64C   A65$   A66   A66   A67   A68   A69   A6:j   A6;K   A6<,   A6@   A6Ar   A6BS   A6C4   A6D   A6D   A6E   A6F   A6G   A6Hz   A6I[   A6J<   A6K   A6K   A6L   A6M   A6N   A6O   A6Pc   A6QD   A6R%   A6S   A6S   A6T   A6U   A6V   A6Wk   A6XL   A6Y-   A6Z   A6Z   A6[   A6\   A6]   A6^s   A6_T   A6`5   A6a   A6a   A6b   A6c   A6d   A6e{   A6f\   A6g=   A6h   A6h   A6i   A6j   A6k   A6l   A6md   A6nE   A6o&   A6p   A6p   A6q   A6r   A6s   A6tl   A6uM   A6v.   A6w   A6w   A6x   A6y   A6z   A6{t   A6|U   A6}6   A6~   A6~   A6   A6   A6   A6|   A6]   A6>   A6   A6    A6   A6   A6   A6   A6e   A6F   A6'   A6   A6   A6   A6   A6   A6m   A6N   A6/   A6   A6u   A6V   A67   A6   A6   A6   A6   A6   A6}   A6^   A6?   A6    A6   A6   A6   A6   A6   A6f   A6G   A6(   A6	   A6   A6   A6   A6   A6n   A6O   A60   A6   A6   A6   A6   A6   A6v   A6W   A68   A6   A6   A6   A6   A6   A6~   A6_   A6@   A6!   A6   A6   A6   A6¥   A6Æ   A6g   A6H   A6)   A6
   A6   A6   A6ɭ   A6ʎ   A6o   A6P   A61   A6   A6   A6   A6е   A6і   A6w   A6X   A69   A6   A6   A6   A6׽   A6؞   A6   A6`   A6A   A6"   A6   A6   A6   A6ߦ   A6   A6h   A6I   A6*   A6   A6   A6   A6   A6   A6p   A6Q   A62   A6   A6   A6Y   A6:   A6   A6   A6   A6   A6   A6   A6a   A6B   A6#   A6   A6   A6   A6   A6   A6i   A6J   A7 +   A7   A7   A7   A7   A7   A7q   A7R   A73   A7   A7   A7	   A7
   A7   A7y   A7
Z   A7;   A7   A7   A7   A7   A7   A7   A7b   A7C   A7$   A7   A7   A7   A7   A7   A7j   A7K   A7,   A7
   A7   A7   A7    A7!   A7"r   A7#S   A7$4   A7%   A7%   A7&   A7'   A7(   A7)z   A7*[   A7+<   A7,   A7,   A7-   A7.   A7/   A70   A71c   A72D   A73%   A74   A74   A75   A76   A77   A78k   A79L   A7:-   A7;   A7;   A7<   A7=   A7>   A7?s   A7@T   A7A5   A7B   A7B   A7C   A7H=   A7I   A7I   A7J   A7K   A7L   A7M   A7Nd   A7OE   A7P&   A7Q   A7Q   A7R   A7S   A7T   A7Ul   A7VM   A7W.   A7X   A7X   A7Y   A7Z   A7[   A7\t   A7]U   A7^6   A7_   A7_   A7`   A7a   A7b   A7c|   A7d]   A7e>   A7f   A7g    A7g   A7h   A7i   A7j   A7ke   A7lF   A7m'   A7n   A7n   A7o   A7p   A7q   A7rm   A7sN   A7t/   A7u   A7u   A7v   A7w   A7x   A7yu   A7zV   A7{7   A7|   A7|   A7}   A7~   A7   A7}   A7^   A7?   A7    A7   A7   A7   A7   A7   A7f   A7G   A7(   A7	   A7   A7   A7   A7   A7n   A7O   A70   A7   A7   A7   A7   A7   A7v   A7W   A78   A7   A7   A7   A7   A7!   A7   A7   A7   A7   A7   A7g   A7H   A7)   A7
   A7   A7   A7   A7   A7o   A7P   A71   A7   A7   A7   A7   A7   A7w   A7X   A79   A7   A7   A7   A7   A7   A7   A7`   A7A   A7"   A7   A7   A7   A7   A7   A7h   A7I   A7*   A7   A7   A7   A7Ǯ   A7ȏ   A7p   A7Q   A72   A7   A7   A7   A7ζ   A7ϗ   A7x   A7Y   A7:   A7   A7   A7   A7վ   A7֟   A7׀   A7a   A7B   A7#   A7   A7   A7   A7ݧ   A7ވ   A7i   A7J   A7+   A7   A7   A7   A7   A7   A7q   A7R   A73   A7   A7   A7   A7   A7   A7y   A7Z   A7;   A7   A7   A7   A7   A7   A7   A7   A7   A7   A7   A7j   A7K   A7,   A8   A8   A8r   A8S   A84   A8   A8   A8   A8   A8	   A8
z   A8[   A8<   A8
   A8
   A8   A8   A8   A8   A8c   A8D   A8%   A8   A8   A8   A8   A8   A8k   A8L   A8-   A8   A8   A8   A8   A8   A8 s   A8!T   A8"5   A8#   A8#   A8$   A8%   A8&   A8'{   A8(\   A8)=   A8*   A8*   A8+   A8,   A8-   A8.   A8/d   A80E   A81&   A82   A82   A83   A84   A85   A86l   A87M   A88.   A89   A89   A8:   A8;   A8<   A8=t   A8>U   A8?6   A8@   A8@   A8A   A8B   A8C   A8D|   A8E]   A8F>   A8G   A8H    A8H   A8I   A8J   A8K   A8Le   A8MF   A8N'   A8O   A8O   A8P   A8Q   A8R   A8Sm   A8TN   A8U/   A8V   A8V   A8W   A8X   A8Y   A8Zu   A8[V   A8\7   A8]   A8]   A8^   A8_   A8`   A8a}   A8b^   A8c?   A8d    A8e   A8e   A8f   A8g   A8h   A8if   A8jG   A8k(   A8l	   A8l   A8m   A8n   A8o   A8pn   A8qO   A8r0   A8s   A8s   A8t   A8u   A8v   A8wv   A8xW   A8y8   A8z   A8z   A8{   A8|   A8}   A8~~   A8_   A8@   A8!   A8   A8   A8   A8   A8   A8g   A8H   A8)   A8
   A8   A8   A8   A8   A8o   A8P   A81   A8   A8   A8   A8   A8   A8w   A8X   A89   A8   A8   A8   A8   A8   A8   A8`   A8A   A8"   A8   A8   A8   A8   A8   ABV   AB7   AB   AB   AB   AB   AB   AB}   AB^   AB?   AB    AB   ABf   ABG   AB(   AB	   AB   AB   AB   AB   ABn   ABO   AB0   AB   AB   AC    AC   AC   ACv   ACW   AC8   AC   AC   AC   AC   AC	   AC
~   AC_   AC@   AC
!   AC   AC   AC   AC   AC   ACg   ACH   AC)   AC
   AC   AC   AC   AC   ACo   ACP   AC1   AC   AC   AC   AC   AC   AC w   AC!X   AC"9   AC#   AC#   AC$   AC%   AC&   AC'   AC(`   AC)A   AC*"   AC+   AC+   AC,   AC-   AC.   AC/h   AC0I   AC1*   AC2   AC2   AC3   AC4   AC5   AC6p   AC7Q   AC82   AC9   AC9   AC:   AC;   AC<   AC=x   AC>Y   AC?:   AC@   AC@   ACA   ACB   ACC   ACD   ACEa   ACFB   ACG#   ACH   ACLi   ACMJ   ACN+   ACO   ACO   ACP   ACQ   ACR   ACSq   ACTR   ACU3   ACV   ACV   ACW   ACX   ACY   ACZy   AC[Z   AC\;   AC]   AC]   AC^   AC_   AC`   ACa   ACbb   ACcC   ACd$   ACe   ACe   ACf   ACg   ACh   ACij   ACjK   ACk,   ACl
   ACl   ACm   ACn   ACo   ACpr   ACqS   ACr4   ACs   ACs   ACt   ACu   ACv   ACwz   ACx[   ACy<   ACz   ACz   AC{   AC|   AC}   AC~   ACc   ACD   AC%   AC   AC   AC   AC   AC   ACk   ACL   AC-   AC   AC   AC   AC   AC   ACs   ACT   AC5   AC   AC   AC   AC   AC   AC{   AC\   AC=   AC   AC   AC   AC   AC   AC   ACd   ACM   AC.   AC   AC   AC   AC   AC   ACt   ACU   AC6   AC   AC   AC   AC   AC   AC|   AC]   AC>   AC   AC    AC   AC   AC   AC   ACe   ACF   AC'   AC   AC   AC   AC   AC   ACm   ACN   AC/   AC   AC   AC   ACų   ACƔ   ACu   ACV   AC7   AC   AC   AC   AC̻   AC͜   AC}   AC^   AC?   AC    AC   AC   AC   ACԤ   ACՅ   ACf   ACG   AC(   AC	   AC   AC   AC۬   AC܍   ACn   ACO   AC0   AC   AC   AC   AC   AC   ACv   ACW   AC8   AC   AC   AC   AC   AC   AC~   AC_   AC@   AC!   AC   AC   AC   AC   AC   ACg   ACH   AC)   AC
   AC   AC   AC   AC   ACo   ACP   AC1   AC   AC   AC   AC   AD    ADw   ADX   AD9   AD   AD   AD   AD   AD   AD   AD	`   AD
A   AD"   AD   AD   AD
   AD   AD   ADh   ADI   AD*   AD   AD   AD   AD   AD   ADp   ADQ   AD2   AD   AD   AD   AD   AD   ADx   ADY   AD :   AD!   AD!   AD"   AD#   AD$   AD%   AD&a   AD'B   AD(#   AD)   AD)   AD*   AD+   AD,   AD-i   AD.J   AD/+   AD0   AD0   AD1   AD2   AD3   AD4q   AD5R   AD63   AD7   AD7   AD8   AD9   AD:   AD;y   AD<Z   AD=;   AD>   AD>   AD?   AD@   ADA   ADB   ADCb   ADDC   ADE$   ADF   ADF   ADG   ADH   ADI   ADJj   ADKK   ADL,   ADM
   ADM   ADN   ADO   ADP   ADQr   ADRS   ADS4   ADT   ADT   ADU   ADV   ADW   ADXz   ADY[   ADZ<   AD[   AD[   AD\   AD]   AD^   AD_   AD`c   ADaD   ADb%   ADc   ADc   ADd   ADe   ADf   ADgk   ADhL   ADi-   ADj   ADj   ADk   ADl   ADm   ADns   ADoT   ADp5   ADq   ADq   ADr   ADs   ADt   ADu{   ADv\   ADz   AD{   AD}d   AD~E   AD&   AD   AD   AD   AD   AD   ADl   ADM   AD.   AD   AD   AD   AD   AD   ADt   ADU   AD6   AD   AD   AD   AD   AD   AD|   AD]   AD>   AD   AD    AD   AD   AD   AD   ADe   ADF   AD'   AD   AD   AD   AD   AD   ADm   ADN   AD/   AD   AD   AD   AD   AD   AD}   AD^   AD?   AD    AD   AD   AD   AD   AD   ADf   ADG   AD(   AD	   AD   AD   AD   AD   ADn   ADO   AD0   AD   AD   AD   ADô   ADĕ   ADv   ADW   AD8   AD   AD   AD   ADʼ   AD˝   AD~   AD_   AD@   AD!   AD   AD   AD   ADҥ   ADӆ   ADg   ADH   AD)   AD
   AD   AD   AD٭   ADڎ   ADo   ADP   AD1   AD   AD   AD   AD   AD   ADw   ADX   AD9   AD   AD   AD   AD   AD   AD   AD`   ADA   AD"   AD   AD   AD   AD   AD   ADh   ADI   AD*   AD   AD   AD   AD   AD   ADp   ADQ   AD2   AD   AD   AD   AD   AD   ADx   AE   AE   AE   AE   AEa   AEB   AE	#   AE
   AE
   AE   AE   AE
   AEi   AEJ   AE+   AE   AE   AE   AE   AE   AEq   AER   AE3   AE   AE   AE   AE   AE   AEy   AEZ   AE;   AE   AE   AE    AE!   AE"   AE#   AE$b   AE%C   AE&$   AE'   AE'   AE(   AE)   AE*   AE+j   AE,K   AE-,   AE.
   AE.   AE/   AE0   AE1   AE2r   AE3S   AE44   AE5   AE5   AE6   AE7   AE8   AE9z   AE:[   AE;<   AE<   AE<   AE=   AE>   AE?   AE@   AEAc   AEBD   AEC%   AED   AED   AEE   AEF   AEG   AEHk   AEIL   AEJ-   AEK   AEK   AEL   AEM   AEN   AEOs   AEPT   AEQ5   AER   AER   AES   AET   AEU   AEV{   AEW\   AE[   AE\   AE]   AE^d   AE_E   AE`&   AEa   AEa   AEb   AEc   AEd   AEel   AEfM   AEg.   AEh   AEh   AEi   AEj   AEk   AElt   AEmU   AEn6   AEo   AEo   AEp   AEq   AEr   AEs|   AEt]   AEu>   AEv   AEw    AEw   AEx   AEy   AEz   AE{e   AE|F   AE}'   AE~   AE~   AE   AE   AE   AEm   AEN   AE/   AE   AE   AE   AE   AE   AEu   AEV   AE7   AE   AE   AE   AE   AE   AE}   AE^   AE?   AE    AE   AE   AE   AE   AE   AEf   AEG   AE(   AE	   AE   AE   AE   AE   AEn   AEO   AE0   AE   AE   AE   AE   AE   AEv   AEW   AE8   AE   AE   AE   AE   AE   AE~   AE_   AE@   AE   AE   AEg   AEH   AE)   AE
   AE   AE   AE   AE   AEo   AEP   AE   AE   AE   AE   AEw   AEX   AE9   AE   AE   AE   AEȽ   AEɞ   AE   AE`   AEA   AE"   AE   AE   AE   AEЦ   AEч   AEh   AE*   AE   AE   AE   AE׮   AE؏   AEp   AEQ   AE2   AE   AE   AE   AE޶   AEߗ   AEx   AEY   AE:   AE   AE   AE   AE   AE   AE   AEa   AEB   AE#   AE   AE   AE   AE   AE   AEi   AEJ   AE+   AE   AE   AE   AE   AE   AEq   AER   AE3   AE   AE   AE   AE   AE   AEy   AEZ   AE;   AF    AF    AF   AF   AF   AF   AFb   AFC   AF$   AF   AFj   AF
K   AF,   AF
   AF   AF   AF   AF   AFr   AFS   AF4   AF   AF   AF   AF   AF   AFz   AF[   AF<   AF   AF   AF   AF   AF    AF!   AF"c   AF#D   AF$%   AF%   AF%   AF&   AF'   AF(   AF)k   AF*L   AF+-   AF,   AF,   AF-   AF.   AF/   AF0s   AF1T   AF25   AF3   AF3   AF4   AF5   AF6   AF7{   AF8\   AF9=   AF:   AF:   AF;   AF<   AF=   AF>   AF?d   AF@E   AFA&   AFB   AFB   AFC   AFD   AFE   AFFl   AFGM   AFH.   AFI   AFI   AFJ   AFK   AFL   AFMt   AFNU   AFO6   AFP   AFP   AFQ   AFR   AFS   AFT|   AFU]   AFV>   AFW   AFX    AFX   AFY   AFZ   AF[   AF\e   AF]F   AF^'   AF_   AFcm   AFdN   AFe/   AFf   AFf   AFg   AFh   AFi   AFju   AFkV   AFl7   AFm   AFm   AFn   AFo   AFp   AFq}   AFr^   AFs?   AFt    AFu   AFu   AFv   AFw   AFx   AFyf   AFzG   AF{(   AF|	   AF|   AF}   AF~   AF   AFn   AFO   AF0   AF   AF   AF   AF   AF   AFv   AFW   AF8   AF   AF   AF   AF   AF   AF~   AF_   AF@   AF!   AF   AF   AF   AF   AF   AFg   AFH   AF)   AF
   AF   AF   AF   AF   AFo   AFP   AF1   AF   AF   AF   AF   AF   AFw   AFX   AF9   AF   AF   AF   AF   AF   AF   AF`   AFA   AF"   AF   AF   AF   AF   AF   AFh   AFI   AF*   AF   AF   AFQ   AF2   AF   AF   AF   AF   AF   AFx   AFY   AF:   AF   AF   AFȀ   AFa   AFB   AF#   AF   AF   AF   AFΧ   AFψ   AFi   AFJ   AF+   AF   AF   AF   AFկ   AF֐   AFq   AFR   AF3   AF   AF   AFܷ   AFݘ   AFy   AFZ   AF;   AF   AF   AF   AF   AF   AF   AFb   AFC   AF$   AF   AF   AF   AF   AF   AFj   AFK   AF,   AF
   AF   AF   AF   AF   AFr   AFS   AF4   AF   AF   AF   AF   AF   AFz   AF[   AF<   AF   AF   AF   AG    AG   AG   AGc   AGD   AG%   AG   AG   AG   AG   AG	   AG
k   AGL   AG-   AG
   AG
   AG   AG5   AG   AG   AG   AG   AG   AG{   AG\   AG=   AG   AG   AG   AG   AG   AG   AG d   AG!E   AG"&   AG#   AG#   AG$   AG%   AG&   AG'l   AG(M   AG).   AG*   AG*   AG+   AG,   AG-   AG.t   AG/U   AG06   AG1   AG1   AG2   AG3   AG4   AG5|   AG6]   AG7>   AG8   AG9    AG9   AG:   AG;   AG<   AG=e   AG>F   AG?'   AG@   AG@   AGA   AGB   AGC   AGDm   AGEN   AGF/   AGG   AGG   AGH   AGI   AGJ   AGKu   AGLV   AGM7   AGN   AGN   AGO   AGP   AGQ   AGR}   AGS^   AGT?   AGU    AGV   AGV   AGW   AGX   AGY   AGZf   AG[G   AG\(   AG]	   AG]   AG^   AG_   AG`   AGan   AGbO   AGc0   AGd   AGd   AGe   AGf   AGk   AGk   AGl   AGm   AGn   AGo~   AGp_   AGq@   AGr!   AGs   AGs   AGt   AGu   AGv   AGwg   AGxH   AGy)   AGz
   AGz   AG{   AG|   AG}   AG~o   AGP   AG1   AG   AG   AG   AG   AG   AGw   AGX   AG9   AG   AG   AG   AG   AG   AG   AG`   AGA   AG"   AG   AG   AG   AG   AG   AGh   AGI   AG*   AG   AG   AG   AG   AG   AGp   AGQ   AG2   AG   AG   AG   AG   AG   AGx   AGY   AG:   AG   AG   AG   AG   AG   AG   AGa   AGB   AG#   AG   AG   AG   AG   AG   AGi   AGJ   AG+   AG   AG   AG   AG   AG   AGq   AGR   AG3   AG   AG   AG   AG   AG   AG   AG   AGĿ   AGŠ   AGƁ   AGb   AGC   AG$   AG   AG   AG   AG̨   AG͉   AGj   AGK   AG,   AG
   AG   AG   AGӰ   AGԑ   AGr   AGS   AG4   AG   AG   AG   AGڸ   AGۙ   AGz   AG[   AG<   AG   AG   AG   AG   AG   AG   AGc   AGD   AG%   AG   AG   AG   AG   AG   AGk   AGL   AG-   AG   AG   AG   AG   AG   AGs   AGT   AG5   AG   AG   AG   AG   AG   AG{   AG\   AG=   AG   AG   AG   AG   AG   AH    AHd   AHE   AH&   AH   AH   AH   AH   AH   AHl   AH	M   AH
.   AH   AH   AH   AH
   AH   AHt   AHU   AH6   AH   AH   AH   AH   AH   AH|   AH   AH   AH   AH   AHe   AHF   AH '   AH!   AH!   AH"   AH#   AH$   AH%m   AH&N   AH'/   AH(   AH(   AH)   AH*   AH+   AH,u   AH-V   AH.7   AH/   AH/   AH0   AH1   AH2   AH3}   AH4^   AH5?   AH6    AH7   AH7   AH8   AH9   AH:   AH;f   AH<G   AH=(   AH>	   AH>   AH?   AH@   AHA   AHBn   AHCO   AHD0   AHE   AHE   AHF   AHG   AHH   AHIv   AHJW   AHK8   AHL   AHL   AHM   AHN   AHO   AHP~   AHQ_   AHR@   AHS!   AHT   AHT   AHU   AHV   AHW   AHXg   AHYH   AHZ)   AH[
   AH[   AH\   AH]   AH^   AH_o   AH`P   AHa1   AHb   AHb   AHc   AHd   AHe   AHfw   AHgX   AHh9   AHi   AHi   AHj   AHk   AHl   AHm   AHn`   AHoA   AHp"   AHq   AHq   AHr   AHs   AHt   AHuh   AHvI   AHw*   AHx   AHx   AHy   AHz   AH{   AH|p   AH}Q   AH~2   AH   AH   AH   AH   AH   AHx   AHY   AH:   AH   AH   AH   AH   AH   AH   AHa   AHB   AH#   AH   AH   AH   AH   AH   AHi   AHJ   AH+   AH   AH   AH   AH   AH   AHq   AHR   AH3   AH   AH   AH   AH   AH   AHy   AHZ   AH;   AH   AH   AH   AH   AH   AH   AHb   AHC   AH$   AH   AH   AH   AH   AH   AHj   AHK   AH,   AH
   AH   AH   AH   AH   AHr   AHS   AH4   AH   AH   AH   AH   AH   AHz   AH[   AH<   AH   AH   AH   AH   AHá   AHĂ   AHc   AHD   AHʩ   AHˊ   AHk   AHL   AH-   AH   AH   AH   AHѱ   AHҒ   AHs   AHT   AH5   AH   AH   AH   AHع   AHٚ   AH{   AH\   AH=   AH   AH   AH   AH   AH   AH   AHd   AHE   AH&   AH   AH   AH   AH   AH   AHl   AHM   AH.   AH   AH   AH   AH   AH   AHt   AHU   AH6   AH   AH   AH   AH   AH   AH|   AH]   AH>   AH   AH    AH   AH   AH   AH   AHe   AI F   AI'   AI   AI   AI   AI   AI   AIm   AIN   AI/   AI	   AI	   AI
   AI   AI   AI
u   AIV   AI7   AI   AI   AI   AI   AI   AI}   AI^   AI?   AI    AI   AIf   AIG   AI(   AI"   AI#n   AI$O   AI%0   AI&   AI&   AI'   AI(   AI)   AI*v   AI+W   AI,8   AI-   AI-   AI.   AI/   AI0   AI1~   AI2_   AI3@   AI4!   AI5   AI5   AI6   AI7   AI8   AI9g   AI:H   AI;)   AI<
   AI<   AI=   AI>   AI?   AI@o   AIAP   AIB1   AIC   AIC   AID   AIE   AIF   AIGw   AIHX   AII9   AIJ   AIJ   AIK   AIL   AIM   AIN   AIO`   AIPA   AIQ"   AIR   AIR   AIS   AIT   AIU   AIVh   AIWI   AIX*   AIY   AIY   AIZ   AI[   AI\   AI]p   AI^Q   AI_2   AI`   AI`   AIa   AIb   AIc   AIdx   AIeY   AIf:   AIg   AIg   AIh   AIi   AIj   AIk   AIla   AImB   AIn#   AIo   AIo   AIp   AIq   AIr   AIsi   AItJ   AIu+   AIv   AIzq   AI{R   AI|3   AI}   AI}   AI~   AI   AI   AIy   AIZ   AI;   AI   AI   AI   AI   AI   AI   AIb   AIC   AI$   AI   AI   AI   AI   AI   AIj   AIK   AI,   AI
   AI   AI   AI   AI   AIr   AIS   AI4   AI   AI   AI   AI   AI   AIz   AI[   AI<   AI   AI   AI   AI   AI   AI   AIc   AID   AI%   AI   AI   AI   AI   AI   AIk   AIL   AI-   AI   AI   AI   AI   AI   AIs   AIT   AI5   AI   AI   AI   AI   AI   AI{   AI\   AI=   AI   AI   AI   AI   AI   AI   AId   AIE   AI&   AI   AI   AI   AIȪ   AIɋ   AIl   AIM   AI.   AI   AI   AIU   AI6   AI   AI   AI   AIֺ   AIכ   AI|   AI]   AI>   AI   AI    AI   AI   AIޣ   AI߄   AIe   AIF   AI'   AI   AI   AI   AI   AI   AIm   AIN   AI/   AI   AI   AI   AI   AI   AIu   AIV   AI7   AI   AI   AI   AI   AI   AI}   AI^   AI?   AI    AI   AI   AI   AI   AI   AIf   AIG   AI(   AJ 	   AJ    AJ   AJ   AJ   AJn   AJO   AJ0   AJ   AJ   AJ   AJ	   AJ
   AJv   AJW   AJ
8   AJ   AJ~   AJ_   AJ@   AJ!   AJ   AJ   AJ   AJ   AJ   AJg   AJH   AJ)   AJ
   AJ   AJ   AJ   AJ    AJ!o   AJ"P   AJ#1   AJ$   AJ$   AJ%   AJ*9   AJ+   AJ+   AJ,   AJ-   AJ.   AJ/   AJ0`   AJ1A   AJ2"   AJ3   AJ3   AJ4   AJ5   AJ6   AJ7h   AJ8I   AJ9*   AJ:   AJ:   AJ;   AJ<   AJ=   AJ>p   AJ?Q   AJ@2   AJA   AJA   AJB   AJC   AJD   AJEx   AJFY   AJG:   AJH   AJH   AJI   AJJ   AJK   AJL   AJMa   AJNB   AJO#   AJP   AJP   AJQ   AJR   AJS   AJTi   AJUJ   AJV+   AJW   AJW   AJX   AJY   AJZ   AJ[q   AJ\R   AJ]3   AJ^   AJ^   AJ_   AJ`   AJa   AJby   AJcZ   AJd;   AJe   AJe   AJf   AJg   AJh   AJi   AJjb   AJkC   AJl$   AJm   AJm   AJn   AJo   AJp   AJqj   AJrK   AJs,   AJt
   AJt   AJu   AJv   AJw   AJxr   AJyS   AJz4   AJ   AJ   AJ   AJ   AJ   AJ   AJc   AJD   AJ%   AJ   AJ   AJ   AJ   AJ   AJk   AJL   AJ-   AJ   AJ   AJ   AJ   AJ   AJs   AJT   AJ5   AJ   AJ   AJ   AJ   AJ   AJ{   AJ\   AJ=   AJ   AJ   AJ   AJ   AJ   AJ   AJd   AJE   AJ&   AJ   AJ   AJ   AJ   AJ   AJl   AJM   AJ.   AJ   AJ   AJ   AJ   AJ   AJt   AJU   AJ6   AJ   AJ   AJ   AJ   AJ   AJ|   AJ]   AJ>   AJ   AJ    AJ   AJ   AJ   AJ   AJe   AJF   AJ'   AJ   AJ   AJ   AJƫ   AJǌ   AJm   AJN   AJ/   AJ   AJ   AJ   AJͳ   AJΔ   AJu   AJV   AJ7   AJ   AJ   AJ   AJԻ   AJ՜   AJ   AJ   AJ   AJܤ   AJ݅   AJf   AJG   AJ(   AJ	   AJ   AJ   AJ   AJ   AJn   AJO   AJ0   AJ   AJ   AJ   AJ   AJ   AJv   AJW   AJ8   AJ   AJ   AJ   AJ   AJ   AJ~   AJ_   AJ@   AJ!   AJ   AJ   AJ   AJ   AJ   AJg   AJH   AJ)   AJ
   AJ   AJ   AK    AK   AKo   AKP   AK1   AK   AK   AK   AK   AK   AK	w   AK
X   AK9   AK   AK   AK
   AK   AK   AK   AK`   AKA   AK"   AK   AK   AK   AK   AK   AKh   AKI   AK*   AK   AK   AK   AK   AK   AKp   AK Q   AK!2   AK"   AK"   AK#   AK$   AK%   AK&x   AK'Y   AK(:   AK)   AK)   AK*   AK+   AK,   AK-   AK1   AK2   AK3   AK4   AK5i   AK6J   AK7+   AK8   AK8   AK9   AK:   AK;   AK<q   AK=R   AK>3   AK?   AK?   AK@   AKA   AKB   AKCy   AKDZ   AKE;   AKF   AKF   AKG   AKH   AKI   AKJ   AKKb   AKLC   AKM$   AKN   AKN   AKO   AKP   AKQ   AKRj   AKSK   AKT,   AKU
   AKU   AKV   AKW   AKX   AKYr   AKZS   AK[4   AK\   AK\   AK]   AK^   AK_   AK`z   AKa[   AKb<   AKc   AKc   AKd   AKe   AKf   AKg   AKhc   AKiD   AKj%   AKk   AKk   AKl   AKm   AKn   AKok   AKpL   AKq-   AKr   AKr   AKs   AKt   AKu   AKvs   AKwT   AKx5   AKy   AKy   AKz   AK{   AK|   AK}{   AK~\   AK=   AK   AK   AK   AK   AK   AK   AKd   AK   AK   AK   AKl   AKM   AK.   AK   AK   AK   AK   AK   AKt   AKU   AK6   AK   AK   AK   AK   AK   AK|   AK]   AK>   AK   AK    AK   AK   AK   AK   AKe   AKF   AK'   AK   AK   AK   AK   AK   AKm   AKN   AK/   AK   AK   AK   AK   AK   AKu   AKV   AK7   AK   AK   AK   AK   AK   AK}   AK^   AK?   AK    AK   AK   AK   AK   AK   AKf   AKG   AK(   AK	   AK   AK   AKĬ   AKō   AKn   AKO   AK0   AK   AK   AK   AK˴   AK̕   AKv   AKW   AK8   AK   AK   AK   AKҼ   AKӝ   AK~   AK_   AK@   AK!   AK   AK   AK   AKڥ   AKۆ   AKg   AKH   AK   AK   AKo   AKP   AK1   AK   AK   AK   AK   AK   AKw   AKX   AK9   AK   AK   AK   AK   AK   AK   AK`   AKA   AK"   AK   AK   AK   AK   AK   AKh   AKI   AK*   AK   AK   AK   AK   AK   AL p   ALQ   AL2   AL   AL   AL   AL   AL   ALx   ALY   AL	:   AL
   AL
   AL   AL   AL
   AL   ALa   ALB   AL#   AL   AL   AL   AL   AL   ALi   ALJ   AL+   AL   AL   AL   AL   AL   ALq   ALR   AL3   AL    AL    AL!   AL"   AL#   AL$y   AL%Z   AL&;   AL'   AL'   AL(   AL)   AL*   AL+   AL,b   AL-C   AL.$   AL/   AL/   AL0   AL1   AL2   AL3j   AL4K   AL5,   AL9   AL:r   AL;S   AL<4   AL=   AL=   AL>   AL?   AL@   ALAz   ALB[   ALC<   ALD   ALD   ALE   ALF   ALG   ALH   ALIc   ALJD   ALK%   ALL   ALL   ALM   ALN   ALO   ALPk   ALQL   ALR-   ALS   ALS   ALT   ALU   ALV   ALWs   ALXT   ALY5   ALZ   ALZ   AL[   AL\   AL]   AL^{   AL_\   AL`=   ALa   ALa   ALb   ALc   ALd   ALe   ALfd   ALgE   ALh&   ALi   ALi   ALj   ALk   ALl   ALml   ALnM   ALo.   ALp   ALp   ALq   ALr   ALs   ALtt   ALuU   ALv6   ALw   ALw   ALx   ALy   ALz   AL{|   AL|]   AL}>   AL~   AL    AL   AL   AL   AL   ALe   ALF   AL'   AL   AL   AL   AL   AL   ALm   ALN   AL/   AL   ALu   ALV   AL7   AL   AL   AL   AL   AL   AL}   AL^   AL?   AL    AL   AL   AL   AL   AL   ALf   ALG   AL(   AL	   AL   AL   AL   AL   ALn   ALO   AL0   AL   AL   AL   AL   AL   ALv   ALW   AL8   AL   AL   AL   AL   AL   AL~   AL_   AL@   AL!   AL   AL   AL   AL   AL   ALg   ALH   AL)   AL
   AL   AL   AL­   ALÎ   ALo   ALP   AL1   AL   AL   AL   ALɵ   ALʖ   ALw   ALX   AL9   AL   AL   AL   ALн   ALў   AL   AL`   ALA   AL"   AL   AL   AL   ALئ   ALه   ALh   ALI   AL*   AL   AL   AL   AL߮   AL   ALp   ALQ   AL2   AL   AL   ALY   AL:   AL   AL   AL   AL   AL   AL   ALa   ALB   AL#   AL   AL   AL   AL   AL   ALi   ALJ   AL+   AL   AL   AL   AL   AL   ALq   ALR   AM 3   AM   AM   AM   AM   AM   AMy   AMZ   AM;   AM   AM   AM	   AM
   AM   AM   AM
b   AMC   AM$   AM   AM   AM   AM   AM   AMj   AMK   AM,   AM
   AM   AM   AM   AM   AMr   AMS   AM4   AM   AM   AM   AM    AM!   AM"z   AM#[   AM$<   AM%   AM%   AM&   AM'   AM(   AM)   AM*c   AM+D   AM,%   AM-   AM-   AM.   AM/   AM0   AM1k   AM2L   AM3-   AM4   AM4   AM5   AM6   AM7   AM8s   AM9T   AM:5   AM;   AM;   AM<   AMA=   AMB   AMB   AMC   AMD   AME   AMF   AMGd   AMHE   AMI&   AMJ   AMJ   AMK   AML   AMM   AMNl   AMOM   AMP.   AMQ   AMQ   AMR   AMS   AMT   AMUt   AMVU   AMW6   AMX   AMX   AMY   AMZ   AM[   AM\|   AM]]   AM^>   AM_   AM`    AM`   AMa   AMb   AMc   AMde   AMeF   AMf'   AMg   AMg   AMh   AMi   AMj   AMkm   AMlN   AMm/   AMn   AMn   AMo   AMp   AMq   AMru   AMsV   AMt7   AMu   AMu   AMv   AMw   AMx   AMy}   AMz^   AM{?   AM|    AM}   AM}   AM~   AM   AM   AMf   AMG   AM(   AM	   AM   AM   AM   AM   AMn   AMO   AM0   AM   AM   AM   AM   AM   AMv   AMW   AM8   AM   AM   AM   AM   AM!   AM   AM   AM   AM   AM   AMg   AMH   AM)   AM
   AM   AM   AM   AM   AMo   AMP   AM1   AM   AM   AM   AM   AM   AMw   AMX   AM9   AM   AM   AM   AM   AM   AM   AM`   AMA   AM"   AM   AM   AM   AM   AM   AMh   AMI   AM*   AM   AM   AM   AM   AM   AMp   AMQ   AM2   AM   AM   AM   AMǶ   AMȗ   AMx   AMY   AM:   AM   AM   AM   AMξ   AMϟ   AMЀ   AMa   AMB   AM#   AM   AM   AM   AM֧   AM׈   AMi   AMJ   AM+   AM   AM   AM   AMݯ   AMސ   AMq   AMR   AM3   AM   AM   AM   AM   AM   AMy   AMZ   AM;   AM   AM   AM   AM   AM   AM   AM   AM   AM   AM   AMj   AMK   AM,   AM
   AM   AM   AM   AM   AMr   AMS   AM4   AM   AM   AN    AN   AN   ANz   AN[   AN<   AN   AN   AN   AN   AN	   AN
   ANc   AND   AN
%   AN   AN   AN   AN   AN   ANk   ANL   AN-   AN   AN   AN   AN   AN   ANs   ANT   AN5   AN   AN   AN   AN   AN   AN {   AN!\   AN"=   AN#   AN#   AN$   AN%   AN&   AN'   AN(d   AN)E   AN*&   AN+   AN+   AN,   AN-   AN.   AN/l   AN0M   AN1.   AN2   AN2   AN3   AN4   AN5   AN6t   AN7U   AN86   AN9   AN9   AN:   AN;   AN<   AN=|   AN>]   AN?>   AN@   ANA    ANA   ANB   ANC   AND   ANH   ANI   ANJ   ANK   ANLm   ANMN   ANN/   ANO   ANO   ANP   ANQ   ANR   ANSu   ANTV   ANU7   ANV   ANV   ANW   ANX   ANY   ANZ}   AN[^   AN\?   AN]    AN^   AN^   AN_   AN`   ANa   ANbf   ANcG   ANd(   ANe	   ANe   ANf   ANg   ANh   ANin   ANjO   ANk0   ANl   ANl   ANm   ANn   ANo   ANpv   ANqW   ANr8   ANs   ANs   ANt   ANu   ANv   ANw~   ANx_   ANy@   ANz!   AN{   AN{   AN|   AN}   AN~   ANg   ANH   AN)   AN
   AN   AN   AN   AN   ANo   ANP   AN1   AN   AN   AN   AN   AN   ANw   ANX   AN9   AN   AN   AN   AN   AN   AN   AN`   ANA   AN"   AN   AN   AN   AN   AN   ANh   AN   AN   AN   ANp   ANQ   AN2   AN   AN   AN   AN   AN   ANx   ANY   AN:   AN   AN   AN   AN   AN   AN   ANa   ANB   AN#   AN   AN   AN   AN   AN   ANi   ANJ   AN+   AN   AN   AN   AN   AN   ANq   ANR   AN3   AN   AN   AN   ANŷ   ANƘ   ANy   ANZ   AN;   AN   AN   AN   AN̿   AN͠   AN΁   ANb   ANC   AN$   AN   AN   AN   ANԨ   ANՉ   ANj   ANK   AN,   AN
   AN   AN   AN۰   ANܑ   ANr   ANS   AN4   AN   AN   AN   AN   AN   ANz   AN[   AN<   AN   AN   AN   AN   AN   AN   ANc   AND   AN%   AN   AN   AN   AN   AN   ANk   ANL   AN   AN   ANs   ANT   AN5   AN   AN   AN   AN   AO    AO{   AO\   AQ   AQ   AQ   AQ   AQ   AQ~   AQ_   AQ@   AQ!   AQ   AQ   AQ   AQ    AQ!   AQ"g   AQ#H   AQ$)   AQ%
   AQ%   AQ&   AQ'   AQ(   AQ)o   AQ*P   AQ+1   AQ,   AQ,   AQ-   AQ.   AQ/   AQ0w   AQ1X   AQ29   AQ3   AQ3   AQ4   AQ5   AQ6   AQ7   AQ8`   AQ9A   AQ:"   AQ;   AQ;   AQ<   AQ=   AQ>   AQ?h   AQ@I   AQA*   AQB   AQB   AQC   AQD   AQE   AQFp   AQGQ   AQH2   AQI   AQI   AQJ   AQK   AQL   AQMx   AQNY   AQO:   AQP   AQP   AQQ   AQR   AQS   AQT   AQUa   AQVB   AQW#   AQX   AQX   AQY   AQZ   AQ[   AQ_   AQ`   AQa   AQb   AQcq   AQdR   AQe3   AQf   AQf   AQg   AQh   AQi   AQjy   AQkZ   AQl;   AQm   AQm   AQn   AQo   AQp   AQq   AQrb   AQsC   AQt$   AQu   AQu   AQv   AQw   AQx   AQyj   AQzK   AQ{,   AQ|
   AQ|   AQ}   AQ~   AQ   AQr   AQS   AQ4   AQ   AQ   AQ   AQ   AQ   AQz   AQ[   AQ<   AQ   AQ   AQ   AQ   AQ   AQ   AQc   AQD   AQ%   AQ   AQ   AQ   AQ   AQ   AQk   AQL   AQ-   AQ   AQ   AQ   AQ   AQ   AQs   AQT   AQ5   AQ   AQ   AQ   AQ   AQ   AQ{   AQ\   AQ=   AQ   AQ   AQ   AQ   AQ   AQ   AQd   AQE   AQ&   AQ   AQ   AQ   AQ   AQ   AQl   AQM   AQ.   AQ   AQ   AQ   AQ   AQ   AQt   AQU   AQ6   AQ   AQ   AQ   AQ   AQ   AQ|   AQ]   AQ>   AQ   AQ    AQ   AQ   AQǣ   AQȄ   AQe   AQF   AQ'   AQ   AQ   AQ   AQΫ   AQό   AQm   AQN   AQ/   AQ   AQ   AQ   AQճ   AQ֔   AQu   AQV   AQ7   AQ   AQ   AQ   AQܻ   AQݜ   AQ}   AQ^   AQ?   AQ    AQ   AQ   AQ   AQ   AQ   AQf   AQG   AQ(   AQ	   AQ   AQ   AQ   AQ   AQn   AQO   AQ0   AQ   AQ   AQ   AQ   AQ   AQv   AQW   AQ8   AQ   AQ   AQ   AQ   AQ   AQ~   AQ_   AQ@   AQ!   AQ   AQ   AR    AR   AR   ARg   ARH   AR)   AR
   AR   AR   AR   AR	   AR
o   ARP   AR   AR   ARw   ARX   AR9   AR   AR   AR   AR   AR   AR   AR`   ARA   AR"   AR   AR   AR   AR   AR   AR h   AR!I   AR"*   AR#   AR#   AR$   AR%   AR&   AR'p   AR(Q   AR)2   AR*   AR*   AR+   AR,   AR-   AR.x   AR/Y   AR0:   AR1   AR1   AR2   AR3   AR4   AR5   AR6a   AR7B   AR8#   AR9   AR9   AR:   AR;   AR<   AR=i   AR>J   AR?+   AR@   AR@   ARA   ARB   ARC   ARDq   ARER   ARF3   ARG   ARG   ARH   ARI   ARJ   ARKy   ARLZ   ARM;   ARN   ARN   ARO   ARP   ARQ   ARR   ARSb   ARTC   ARU$   ARV   ARV   ARW   ARX   ARY   ARZj   AR[K   AR\,   AR]
   AR]   AR^   AR_   ARg   ARhz   ARi[   ARj<   ARk   ARk   ARl   ARm   ARn   ARo   ARpc   ARqD   ARr%   ARs   ARs   ARt   ARu   ARv   ARwk   ARxL   ARy-   ARz   ARz   AR{   AR|   AR}   AR~s   ART   AR5   AR   AR   AR   AR   AR   AR{   AR\   AR=   AR   AR   AR   AR   AR   AR   ARd   ARE   AR&   AR   AR   AR   AR   AR   ARl   ARM   AR.   AR   AR   AR   AR   AR   ARt   ARU   AR6   AR   AR   AR   AR   AR   AR|   AR]   AR>   AR   AR    AR   AR   AR   AR   ARe   ARF   AR'   AR   AR   AR   AR   AR   ARm   ARN   AR/   AR   AR   AR   AR   AR   ARu   ARV   AR7   AR   AR   AR   AR   AR   AR}   AR^   AR?   AR    AR   AR   AR   ARŤ   ARƅ   ARf   ARG   AR(   AR	   AR   AR   AR̬   AR͍   ARn   ARO   AR0   AR   AR   AR   ARӴ   ARԕ   ARv   ARW   AR8   AR   AR   AR   ARڼ   AR۝   AR~   AR_   AR@   AR!   AR   AR   AR   AR   AR   ARg   ARH   AR)   AR
   AR   AR   AR   AR   ARo   ARP   AR1   AR   AR   AR   AR   AR   ARw   ARX   AR9   AR   AR   AR   AR   AR   AR   AR`   ARA   AR"   AR   AR   AR   AR   AS    ASh   ASI   AS*   AS   AS   AS   AS   AS   ASp   AS	Q   AS
2   AS   AS   AS   AS
   AS   ASx   ASY   AS:   AS   AS   ASa   ASB   AS#   AS   AS   AS   AS   AS   ASi   ASJ   AS +   AS!   AS!   AS"   AS#   AS$   AS%q   AS&R   AS'3   AS(   AS(   AS)   AS*   AS+   AS,y   AS-Z   AS.;   AS/   AS/   AS0   AS1   AS2   AS3   AS4b   AS5C   AS6$   AS7   AS7   AS8   AS9   AS:   AS;j   AS<K   AS=,   AS>
   AS>   AS?   AS@   ASA   ASBr   ASCS   ASD4   ASE   ASE   ASF   ASG   ASH   ASIz   ASJ[   ASK<   ASL   ASL   ASM   ASN   ASO   ASP   ASQc   ASRD   ASS%   AST   AST   ASU   ASV   ASW   ASXk   ASYL   ASZ-   AS[   AS[   AS\   AS]   AS^   AS_s   AS`T   ASa5   ASb   ASb   ASc   ASd   ASe   ASf{   ASg\   ASh=   ASi   ASi   ASj   ASoE   ASp&   ASq   ASq   ASr   ASs   ASt   ASul   ASvM   ASw.   ASx   ASx   ASy   ASz   AS{   AS|t   AS}U   AS~6   AS   AS   AS   AS   AS   AS|   AS]   AS>   AS   AS    AS   AS   AS   AS   ASe   ASF   AS'   AS   AS   AS   AS   AS   ASm   ASN   AS/   AS   AS   AS   AS   AS   ASu   ASV   AS7   AS   AS   AS   AS   AS   AS}   AS^   AS?   AS    AS   AS   AS   AS   AS   ASf   ASG   AS(   AS	   AS   AS   AS   AS   ASn   ASO   AS0   AS   AS   AS   AS   AS   ASv   ASW   AS8   AS   AS   AS   AS   AS   AS~   AS_   AS@   AS!   AS   AS   AS   AS)   AS
   AS   AS   ASʭ   ASˎ   ASo   ASP   AS1   AS   AS   AS   ASѵ   ASҖ   ASw   ASX   AS9   AS   AS   AS   ASؽ   ASٞ   AS   AS`   ASA   AS"   AS   AS   AS   AS   AS   ASh   ASI   AS*   AS   AS   AS   AS   AS   ASp   ASQ   AS2   AS   AS   AS   AS   AS   ASx   ASY   AS:   AS   AS   AS   AS   AS   AS   ASa   ASB   AS#   AS   AS   AS   AS   AS   ASi   AT J   AT+   AT   AT   AT   AT   AT   ATq   ATR   AT3   AT	   AT	   AT
   AT   AT   AT
y   ATZ   AT;   AT   AT   AT   AT   AT   AT   ATb   ATC   AT$   AT   AT   AT   AT   AT   ATj   ATK   AT,   AT
   AT   AT    AT!   AT"   AT#r   AT$S   AT%4   AT&   AT&   AT'   AT(   AT)   AT*z   AT+[   AT,<   AT-   AT-   AT.   AT/   AT0   AT1   AT2c   AT3D   AT4%   AT5   AT5   AT6   AT7   AT8   AT9k   AT:L   AT;-   AT<   AT<   AT=   AT>   AT?   AT@s   ATAT   ATB5   ATC   ATC   ATD   ATE   ATF   ATG{   ATH\   ATI=   ATJ   ATJ   ATK   ATL   ATM   ATN   ATOd   ATPE   ATQ&   ATR   ATR   ATS   ATT   ATU   ATVl   ATWM   ATX.   ATY   ATY   ATZ   AT[   AT\   AT]t   AT^U   AT_6   AT`   AT`   ATa   ATb   ATc   ATd|   ATe]   ATf>   ATg   ATh    ATh   ATi   ATj   ATk   ATle   ATmF   ATn'   ATo   ATo   ATp   ATq   ATr   ATv   ATw   ATx   ATy   ATzu   AT{V   AT|7   AT}   AT}   AT~   AT   AT   AT}   AT^   AT?   AT    AT   AT   AT   AT   AT   ATf   ATG   AT(   AT	   AT   AT   AT   AT   ATn   ATO   AT0   AT   AT   AT   AT   AT   ATv   ATW   AT8   AT   AT   AT   AT   AT   AT~   AT_   AT@   AT!   AT   AT   AT   AT   AT   ATg   ATH   AT)   AT
   AT   AT   AT   AT   ATo   ATP   AT1   AT   AT   AT   AT   AT   ATw   ATX   AT9   AT   AT   AT   AT   AT   AT   AT`   ATA   AT"   AT   AT   AT   AT   AT   ATh   ATI   AT*   AT   AT   AT   ATȮ   ATɏ   ATp   ATQ   AT2   AT   AT   AT   AT϶   ATЗ   ATx   ATY   AT:   AT   AT   AT   AT־   ATן   AT؀   ATa   ATB   AT#   AT   AT   AT   ATާ   AT߈   ATi   ATJ   AT+   AT   AT   AT   AT   AT   ATq   ATR   AT3   AT   AT   AT   AT   AT   ATy   ATZ   AT;   AT   AT   AT   AT   AT   AT   ATb   ATC   AT$   AT   AT   AT   AT   AT   ATj   ATK   AT,   AU 
   AU    AU   AU   AU   AUr   AUS   AU4   AU   AU   AU   AU	   AU
   AUz   AU[   AU
<   AU   AU   AU   AU   AU   AU   AUc   AUD   AU%   AU   AU   AU   AU   AU   AUk   AUL   AU-   AU   AU   AU   AU   AU    AU!s   AU"T   AU#5   AU$   AU$   AU%   AU&   AU'   AU({   AU)\   AU*=   AU+   AU+   AU,   AU-   AU.   AU/   AU0d   AU1E   AU2&   AU3   AU3   AU4   AU5   AU6   AU7l   AU8M   AU9.   AU:   AU:   AU;   AU<   AU=   AU>t   AU?U   AU@6   AUA   AUA   AUB   AUC   AUD   AUE|   AUF]   AUG>   AUH   AUI    AUI   AUJ   AUK   AUL   AUMe   AUNF   AUO'   AUP   AUP   AUQ   AUR   AUS   AUTm   AUUN   AUV/   AUW   AUW   AUX   AUY   AUZ   AU[u   AU\V   AU]7   AU^   AU^   AU_   AU`   AUa   AUb}   AUc^   AUd?   AUe    AUf   AUf   AUg   AUh   AUi   AUjf   AUkG   AUl(   AUm	   AUm   AUn   AUo   AUp   AUqn   AUrO   AUs0   AUt   AUt   AUu   AUv   AUw   AUxv   AUyW   AUz8   AU~   AU~   AU_   AU@   AU!   AU   AU   AU   AU   AU   AUg   AUH   AU)   AU
   AU   AU   AU   AU   AUo   AUP   AU1   AU   AU   AU   AU   AU   AUw   AUX   AU9   AU   AU   AU   AU   AU   AU   AU`   AUA   AU"   AU   AU   AU   AU   AU   AUh   AUI   AU*   AU   AU   AU   AU   AU   AUp   AUQ   AU2   AU   AU   AU   AU   AU   AUx   AUY   AU:   AU   AU   AU   AU   AU   AU   AUa   AUB   AU#   AU   AU   AU   AU   AU   AUi   AUJ   AU+   AU   AU   AU   AUƯ   AUǐ   AUq   AUR   AU3   AU   AU   AU   AUͷ   AUΘ   AUց   AUb   AUC   AU$   AU   AU   AU   AUܨ   AU݉   AUj   AUK   AU,   AU
   AU   AU   AU   AU   AUr   AUS   AU4   AU   AU   AU   AU   AU   AUz   AU[   AU<   AU   AU   AU   AU   AU   AU   AUc   AUD   AU%   AU   AU   AU   AU   AU   AUk   AUL   AV   AV   AV	{   AV
\   AV=   AV   AV   AV
   AV   AV   AV   AVd   AVE   AV&   AV   AV   AV   AV   AV   AVl   AVM   AV.   AV   AV   AV   AV   AV   AVt   AV U   AV!6   AV"   AV"   AV#   AV$   AV%   AV&|   AV']   AV(>   AV)   AV*    AV.e   AV/F   AV0'   AV1   AV1   AV2   AV3   AV4   AV5m   AV6N   AV7/   AV8   AV8   AV9   AV:   AV;   AV<u   AV=V   AV>7   AV?   AV?   AV@   AVA   AVB   AVC}   AVD^   AVE?   AVF    AVG   AVG   AVH   AVI   AVJ   AVKf   AVLG   AVM(   AVN	   AVN   AVO   AVP   AVQ   AVRn   AVSO   AVT0   AVU   AVU   AVV   AVW   AVX   AVYv   AVZW   AV[8   AV\   AV\   AV]   AV^   AV_   AV`~   AVa_   AVb@   AVc!   AVd   AVd   AVe   AVf   AVg   AVhg   AViH   AVj)   AVk
   AVk   AVl   AVm   AVn   AVoo   AVpP   AVq1   AVr   AVr   AVs   AVt   AVu   AVvw   AVwX   AVx9   AVy   AVy   AVz   AV{   AV|   AV}   AV~`   AVI   AV*   AV   AV   AV   AV   AV   AVp   AVQ   AV2   AV   AV   AV   AV   AV   AVx   AVY   AV:   AV   AV   AV   AV   AV   AV   AVa   AVB   AV#   AV   AV   AV   AV   AV   AVi   AVJ   AV+   AV   AVq   AVR   AV3   AV   AV   AV   AV   AV   AVy   AVZ   AV;   AV   AV   AV   AV   AV   AV   AVb   AVC   AV$   AV   AV   AV   AV   AV   AVj   AVK   AV,   AV
   AV   AV   AVİ   AVő   AVr   AVS   AV4   AV   AV   AV   AV˸   AV̙   AVz   AV[   AV<   AV   AV   AV   AV   AVӡ   AVԂ   AVc   AVD   AV%   AV   AV   AV   AV-   AV   AV   AV   AV   AV   AVs   AVT   AV5   AV   AV   AV   AV   AV   AV{   AV\   AV=   AV   AV   AV   AV   AV   AV   AVd   AVE   AV&   AV   AV   AV   AV   AV   AVl   AVM   AV.   AV   AV   AV   AV   AV   AW t   AWU   AW6   AW   AW   AW   AW   AW   AW|   AW]   AW	>   AW
   AW    AW   AW   AW
   AW   AWe   AWF   AW'   AW   AW   AW   AW   AW   AWm   AWN   AW/   AW   AW   AW   AW   AW   AWu   AWV   AW7   AW    AW    AW!   AW"   AW#   AW$}   AW%^   AW&?   AW'    AW(   AW(   AW)   AW*   AW+   AW,f   AW-G   AW.(   AW6   AW6   AW7   AW8   AW9   AW:v   AW;W   AW<8   AW=   AW=   AW>   AW?   AW@   AWA~   AWB_   AWC@   AWD!   AWE   AWE   AWF   AWG   AWH   AWIg   AWJH   AWK)   AWL
   AWL   AWM   AWN   AWO   AWPo   AWQP   AWR1   AWS   AWS   AWT   AWU   AWV   AWWw   AWXX   AWY9   AWZ   AWZ   AW[   AW\   AW]   AW^   AW_`   AW`A   AWa"   AWb   AWb   AWc   AWd   AWe   AWfh   AWgI   AWh*   AWi   AWi   AWj   AWk   AWl   AWmp   AWnQ   AWo2   AWp   AWp   AWq   AWr   AWs   AWtx   AWuY   AWv:   AWw   AWw   AWx   AWy   AWz   AW{   AW|a   AW}B   AW~#   AW   AW   AW   AW   AW   AWi   AWJ   AW+   AW   AW   AW   AW   AW   AW   AW   AW   AW   AWy   AWZ   AW;   AW   AW   AW   AW   AW   AW   AWb   AWC   AW$   AW   AW   AW   AW   AW   AWj   AWK   AW,   AW
   AW   AW   AW   AW   AWr   AWS   AW4   AW   AW   AW   AW   AW   AWz   AW[   AW<   AW   AW   AW   AW   AW   AW   AWc   AWD   AW%   AW   AW   AW   AW   AW   AWk   AWL   AW-   AW   AW   AW   AW±   AWÒ   AWs   AWT   AW5   AW   AW   AW   AWɹ   AWʚ   AW{   AW\   AW=   AW   AW   AW   AW   AWѢ   AW҃   AWd   AWE   AW&   AW   AW   AW   AWت   AWً   AWl   AWM   AW.   AW   AW   AW   AW߲   AW   AWt   AW   AW   AW   AW|   AW]   AW>   AW   AW    AW   AW   AW   AW   AWe   AWF   AW'   AW   AW   AW   AW   AW   AWm   AWN   AW/   AW   AW   AW   AW   AW   AWu   AWV   AX 7   AX   AX   AX   AX   AX   AX}   AX^   AX?   AX    AX	   AX	   AX
   AX   AX   AX
f   AXG   AX(   AX	   AX   AX   AX   AX   AXn   AXO   AX0   AX   AX   AX   AX   AX   AXv   AXW   AX8   AX   AX   AX   AX    AX!   AX"~   AX#_   AX$@   AX%!   AX&   AX&   AX'   AX(   AX)   AX*g   AX+H   AX,)   AX-
   AX-   AX.   AX/   AX0   AX1o   AX2P   AX31   AX4   AX4   AX5   AX=   AX>   AX?   AX@`   AXAA   AXB"   AXC   AXC   AXD   AXE   AXF   AXGh   AXHI   AXI*   AXJ   AXJ   AXK   AXL   AXM   AXNp   AXOQ   AXP2   AXQ   AXQ   AXR   AXS   AXT   AXUx   AXVY   AXW:   AXX   AXX   AXY   AXZ   AX[   AX\   AX]a   AX^B   AX_#   AX`   AX`   AXa   AXb   AXc   AXdi   AXeJ   AXf+   AXg   AXg   AXh   AXi   AXj   AXkq   AXlR   AXm3   AXn   AXn   AXo   AXp   AXq   AXry   AXsZ   AXt;   AXu   AXu   AXv   AXw   AXx   AXy   AXzb   AX{C   AX|$   AX}   AX}   AX~   AX   AX   AXj   AXK   AX,   AX
   AX   AX   AX   AX   AXr   AXS   AX4   AX   AX   AX   AX   AX   AXz   AX[   AX<   AX   AX   AXc   AXD   AX%   AX   AX   AX   AX   AX   AXk   AXL   AX-   AX   AX   AX   AX   AX   AXs   AXT   AX5   AX   AX   AX   AX   AX   AX{   AX\   AX=   AX   AX   AX   AX   AX   AX   AXd   AXE   AX&   AX   AX   AX   AX   AX   AXl   AXM   AX.   AX   AX   AX   AX   AX   AXt   AXU   AX6   AX   AX   AX   AXǺ   AXț   AX|   AX]   AX>   AX   AX    AX   AX   AXϣ   AXЄ   AXe   AXF   AX'   AX   AX   AX   AX֫   AX׌   AXm   AXN   AX/   AX   AX   AX   AXݳ   AXޔ   AXu   AXV   AX7   AX   AX   AX   AX   AX   AX}   AX^   AX?   AX    AX   AXn   AXO   AX0   AX   AX   AX   AX   AX   AXv   AXW   AX8   AX   AX   AY    AY   AY   AY~   AY_   AY@   AY!   AY   AY   AY   AY	   AY
   AYg   AYH   AY
)   AY
   AY   AY   AY   AY   AYo   AYP   AY1   AY   AY   AY   AY   AY   AYw   AYX   AY9   AY   AY   AY   AY   AY   AY    AY!`   AY"A   AY#"   AY$   AY$   AY%   AY&   AY'   AY(h   AY)I   AY**   AY+   AY+   AY,   AY-   AY.   AY/p   AY0Q   AY12   AY2   AY2   AY3   AY4   AY5   AY6x   AY7Y   AY8:   AY9   AY9   AY:   AY;   AY<   AY=   AY>a   AY?B   AY@#   AYA   AYA   AYB   AYC   AYD   AYEi   AYFJ   AYG+   AYH   AYLq   AYMR   AYN3   AYO   AYO   AYP   AYQ   AYR   AYSy   AYTZ   AYU;   AYV   AYV   AYW   AYX   AYY   AYZ   AY[b   AY\C   AY]$   AY^   AY^   AY_   AY`   AYa   AYbj   AYcK   AYd,   AYe
   AYe   AYf   AYg   AYh   AYir   AYjS   AYk4   AYl   AYl   AYm   AYn   AYo   AYpz   AYq[   AYr<   AYs   AYs   AYt   AYu   AYv   AYw   AYxc   AYyD   AYz%   AY{   AY{   AY|   AY}   AY~   AYk   AYL   AY-   AY   AY   AY   AY   AY   AYs   AYT   AY5   AY   AY   AY   AY   AY   AY{   AY\   AY=   AY   AY   AY   AY   AY   AY   AYd   AYE   AY&   AY   AY   AYM   AY.   AY   AY   AY   AY   AY   AYt   AYU   AY6   AY   AY   AY   AY   AY   AY|   AY]   AY>   AY   AY    AY   AY   AY   AY   AYe   AYF   AY'   AY   AY   AY   AY   AY   AYm   AYN   AY/   AY   AY   AY   AY   AY   AYu   AYV   AY7   AY   AY   AY   AYŻ   AYƜ   AY}   AY^   AY?   AY    AY   AY   AY   AYͤ   AY΅   AYf   AYG   AY(   AY	   AY   AY   AYԬ   AYՍ   AYn   AYO   AY0   AY   AY   AY   AY۴   AYܕ   AYv   AYW   AY8   AY   AY   AY   AY   AY   AY~   AY_   AY@   AY!   AY   AY   AY   AY   AY   AYg   AYH   AY)   AY
   AY   AY   AY1   AY   AY   AY   AY   AY   AYw   AYX   AY9   AY   AY   AY   AY   AZ    AZ   AZ`   AZA   AZ"   AZ   AZ   AZ   AZ   AZ   AZ	h   AZ
I   AZ*   AZ   AZ   AZ
   AZ   AZ   AZp   AZQ   AZ2   AZ   AZ   AZ   AZ   AZ   AZx   AZY   AZ:   AZ   AZ   AZ   AZ   AZ   AZ   AZa   AZ B   AZ!#   AZ"   AZ"   AZ#   AZ$   AZ%   AZ&i   AZ'J   AZ(+   AZ)   AZ)   AZ*   AZ+   AZ,   AZ-q   AZ.R   AZ/3   AZ0   AZ0   AZ1   AZ2   AZ3   AZ4y   AZ5Z   AZ6;   AZ7   AZ7   AZ8   AZ9   AZ:   AZ;   AZ<b   AZ=C   AZ>$   AZ?   AZ?   AZ@   AZA   AZB   AZCj   AZDK   AZE,   AZF
   AZF   AZG   AZH   AZM   AZM   AZN   AZO   AZP   AZQz   AZR[   AZS<   AZT   AZT   AZU   AZV   AZW   AZX   AZYc   AZZD   AZ[%   AZ\   AZ\   AZ]   AZ^   AZ_   AZ`k   AZaL   AZb-   AZc   AZc   AZd   AZe   AZf   AZgs   AZhT   AZi5   AZj   AZj   AZk   AZl   AZm   AZn{   AZo\   AZp=   AZq   AZq   AZr   AZs   AZt   AZu   AZvd   AZwE   AZx&   AZy   AZy   AZz   AZ{   AZ|   AZ}l   AZ~M   AZ.   AZ   AZ   AZ   AZ   AZ   AZt   AZU   AZ6   AZ   AZ   AZ   AZ   AZ   AZ|   AZ]   AZ>   AZ   AZ    AZ   AZ   AZ   AZ   AZe   AZF   AZ'   AZ   AZ   AZ   AZ   AZ   AZm   AZN   AZ/   AZ   AZ   AZ   AZ   AZ   AZu   AZV   AZ7   AZ   AZ   AZ   AZ   AZ   AZ}   AZ^   AZ?   AZ    AZ   AZ   AZ   AZ   AZ   AZf   AZG   AZ(   AZ	   AZ   AZ   AZ   AZ   AZn   AZO   AZ0   AZ   AZ   AZ   AZ   AZ   AZv   AZW   AZ8   AZ   AZ   AZ   AZü   AZĝ   AZ~   AZ_   AZ@   AZ!   AZ   AZ   AZ   AZ˥   AZ̆   AZg   AZH   AZ)   AZ
   AZ   AZ   AZҭ   AZӎ   AZo   AZP   AZ1   AZ   AZ   AZ   AZٵ   AZږ   AZw   AZX   AZ9   AZ   AZ   AZ   AZ   AZ   AZ   AZ`   AZA   AZ"   AZ   AZ   AZ   AZ   AZ   AZh   AZI   AZ*   AZ   AZ   AZ   AZ   AZ   AZp   AZQ   AZ2   AZ   AZ   AZ   AZ   AZ   AZ   A[ a   A[B   A[#   A[   A[   A[   A[   A[   A[i   A[J   A[	+   A[
   A[
   A[   A[   A[
   A[q   A[R   A[3   A[   A[   A[   A[   A[   A[y   A[Z   A[;   A[   A[   A[   A[   A[   A[   A[b   A[C   A[$   A[    A[    A[!   A["   A[#   A[$j   A[%K   A[&,   A['
   A['   A[(   A[)   A[*   A[+r   A[,S   A[-4   A[.   A[.   A[/   A[0   A[1   A[2z   A[3[   A[4<   A[5   A[5   A[6   A[7   A[8   A[9   A[:c   A[;D   A[<%   A[=   A[=   A[>   A[?   A[@   A[Ak   A[BL   A[C-   A[D   A[D   A[E   A[F   A[G   A[Hs   A[IT   A[J5   A[K   A[K   A[L   A[T   A[U   A[V   A[Wd   A[XE   A[Y&   A[Z   A[Z   A[[   A[\   A[]   A[^l   A[_M   A[`.   A[a   A[a   A[b   A[c   A[d   A[et   A[fU   A[g6   A[h   A[h   A[i   A[j   A[k   A[l|   A[m]   A[n>   A[o   A[p    A[p   A[q   A[r   A[s   A[te   A[uF   A[v'   A[w   A[w   A[x   A[y   A[z   A[{m   A[|N   A[}/   A[~   A[~   A[   A[   A[   A[u   A[V   A[7   A[   A[   A[   A[   A[   A[}   A[^   A[?   A[    A[   A[   A[   A[   A[   A[f   A[G   A[(   A[	   A[   A[   A[   A[   A[n   A[O   A[0   A[   A[   A[   A[   A[   A[v   A[W   A[8   A[   A[   A[   A[   A[   A[~   A[_   A[@   A[   A[   A[g   A[H   A[)   A[
   A[   A[   A[   A[   A[o   A[P   A[1   A[   A[   A[   A[   A[   A[w   A[X   A[9   A[   A[   A[   A[   A[   A[   A[`   A[A   A["   A[   A[   A[   A[ɦ   A[ʇ   A[h   A[I   A[*   A[   A[   A[   A[Ю   A[я   A[p   A[Q   A[2   A[   A[   A[   A[׶   A[ؗ   A[x   A[Y   A[:   A[   A[   A[   A[޾   A[ߟ   A[   A[a   A[B   A[#   A[   A[   A[   A[   A[   A[i   A[J   A[+   A[   A[   A[   A[   A[   A[q   A[R   A[3   A[   A[   A[   A[   A[   A[y   A[Z   A[;   A[   A[   A[   A[   A[   A[   A[b   A[C   A\ $   A\   A\j   A\K   A\,   A\
   A\   A\	   A\
   A\   A\r   A\
S   A\4   A\   A\   A\   A\   A\   A\z   A\[   A\<   A\   A\   A\   A\   A\   A\   A\c   A\D   A\%   A\   A\   A\   A\    A\!   A\"k   A\#L   A\$-   A\%   A\%   A\&   A\'   A\(   A\)s   A\*T   A\+5   A\,   A\,   A\-   A\.   A\/   A\0{   A\1\   A\2=   A\3   A\3   A\4   A\5   A\6   A\7   A\8d   A\9E   A\:&   A\;   A\;   A\<   A\=   A\>   A\?l   A\@M   A\A.   A\B   A\B   A\C   A\D   A\E   A\Ft   A\GU   A\H6   A\I   A\I   A\J   A\K   A\L   A\M|   A\N]   A\O>   A\P   A\Q    A\Q   A\R   A\S   A\T   A\\m   A\]N   A\^/   A\_   A\_   A\`   A\a   A\b   A\cu   A\dV   A\e7   A\f   A\f   A\g   A\h   A\i   A\j}   A\k^   A\l?   A\m    A\n   A\n   A\o   A\p   A\q   A\rf   A\sG   A\t(   A\u	   A\u   A\v   A\w   A\x   A\yn   A\zO   A\{0   A\|   A\|   A\}   A\~   A\   A\v   A\W   A\8   A\   A\   A\   A\   A\   A\~   A\_   A\@   A\!   A\   A\   A\   A\   A\   A\g   A\H   A\)   A\
   A\   A\   A\   A\   A\o   A\P   A\1   A\   A\   A\   A\   A\   A\w   A\X   A\9   A\   A\   A\   A\   A\   A\   A\`   A\A   A\"   A\   A\   A\   A\   A\   A\h   A\I   A\*   A\   A\   A\Q   A\2   A\   A\   A\   A\   A\   A\x   A\Y   A\:   A\   A\   A\   A\   A\   A\   A\a   A\B   A\#   A\   A\   A\   A\ǧ   A\Ȉ   A\i   A\J   A\+   A\   A\   A\   A\ί   A\ϐ   A\q   A\R   A\3   A\   A\   A\   A\շ   A\֘   A\y   A\Z   A\;   A\   A\   A\   A\ܿ   A\ݠ   A\ށ   A\b   A\C   A\$   A\   A\   A\   A\   A\   A\j   A\K   A\,   A\
   A\   A\   A\   A\   A\r   A\S   A\4   A\   A\   A\   A\   A\   A\z   A\[   A\<   A\   A\   A\   A\   A\   A\   A\c   A\D   A\%   A\   A\   A]    A]   A]   A]k   A]L   A]-   A]   A]   A]   A]5   A]
   A]
   A]   A]   A]   A]{   A]\   A]=   A]   A]   A]   A]   A]   A]   A]d   A]E   A]&   A]   A]   A]   A]   A]   A] l   A]!M   A]".   A]#   A]#   A]$   A]%   A]&   A]'t   A](U   A])6   A]*   A]*   A]+   A],   A]-   A].|   A]/]   A]0>   A]1   A]2    A]2   A]3   A]4   A]5   A]6e   A]7F   A]8'   A]9   A]9   A]:   A];   A]<   A]=m   A]>N   A]?/   A]@   A]@   A]A   A]B   A]C   A]Du   A]EV   A]F7   A]G   A]G   A]H   A]I   A]J   A]K}   A]L^   A]M?   A]N    A]O   A]O   A]P   A]Q   A]R   A]Sf   A]TG   A]U(   A]V	   A]V   A]W   A]X   A]Y   A]Zn   A][O   A]\0   A]]   A]]   A]^   A]_   A]d   A]d   A]e   A]f   A]g   A]h~   A]i_   A]j@   A]k!   A]l   A]l   A]m   A]n   A]o   A]pg   A]qH   A]r)   A]s
   A]s   A]t   A]u   A]v   A]wo   A]xP   A]y1   A]z   A]z   A]{   A]|   A]}   A]~w   A]X   A]9   A]   A]   A]   A]   A]   A]   A]`   A]A   A]"   A]   A]   A]   A]   A]   A]h   A]I   A]*   A]   A]   A]   A]   A]   A]p   A]Q   A]2   A]   A]   A]   A]   A]   A]x   A]Y   A]:   A]   A]   A]   A]   A]   A]   A]a   A]B   A]#   A]   A]   A]   A]   A]   A]i   A]J   A]+   A]   A]   A]   A]   A]   A]q   A]R   A]3   A]   A]   A]   A]   A]   A]   A]   A]   A]   A]   A]b   A]C   A]$   A]   A]   A]   A]Ũ   A]Ɖ   A]j   A]K   A],   A]
   A]   A]   A]̰   A]͑   A]r   A]S   A]4   A]   A]   A]   A]Ӹ   A]ԙ   A]z   A][   A]<   A]   A]   A]   A]   A]ۡ   A]܂   A]c   A]D   A]%   A]   A]   A]   A]   A]   A]k   A]L   A]-   A]   A]   A]   A]   A]   A]s   A]T   A]5   A]   A]   A]   A]   A]   A]{   A]\   A]=   A]   A]   A]   A]   A]   A]   A]d   A]E   A]&   A]   A]   A]   A]   A^    A^l   A^M   A^.   A^   A^   A^   A^   A^   A^t   A^	U   A^
6   A^   A^   A^   A^
   A^   A^|   A^]   A^>   A^   A^    A^   A^   A^   A^   A^e   A^F   A^'   A^   A^   A^   A^   A^   A^m   A^N   A^ /   A^!   A^!   A^"   A^#   A^$   A^%u   A^&V   A^'7   A^(   A^(   A^)   A^*   A^+   A^,}   A^-^   A^.?   A^/    A^0   A^0   A^1   A^2   A^3   A^4f   A^5G   A^6(   A^7	   A^7   A^8   A^9   A^:   A^;n   A^<O   A^=0   A^>   A^>   A^?   A^@   A^A   A^Bv   A^CW   A^D8   A^E   A^E   A^F   A^G   A^H   A^I~   A^J_   A^K@   A^L!   A^M   A^M   A^N   A^O   A^P   A^Qg   A^RH   A^S)   A^T
   A^T   A^U   A^V   A^W   A^Xo   A^YP   A^Z1   A^[   A^[   A^\   A^]   A^^   A^_w   A^`X   A^a9   A^b   A^b   A^c   A^d   A^e   A^f   A^g`   A^k   A^l   A^m   A^nh   A^oI   A^p*   A^q   A^q   A^r   A^s   A^t   A^up   A^vQ   A^w2   A^x   A^x   A^y   A^z   A^{   A^|x   A^}Y   A^~:   A^   A^   A^   A^   A^   A^   A^a   A^B   A^#   A^   A^   A^   A^   A^   A^i   A^J   A^+   A^   A^   A^   A^   A^   A^q   A^R   A^3   A^   A^   A^   A^   A^   A^y   A^Z   A^;   A^   A^   A^   A^   A^   A^   A^b   A^C   A^$   A^   A^   A^   A^   A^   A^j   A^K   A^,   A^
   A^   A^   A^   A^   A^r   A^S   A^4   A^   A^   A^   A^   A^   A^z   A^[   A^<   A^   A^   A^   A^   A^   A^   A^c   A^D   A^é   A^Ċ   A^k   A^L   A^-   A^   A^   A^   A^ʱ   A^˒   A^s   A^T   A^5   A^   A^   A^   A^ѹ   A^Қ   A^{   A^\   A^=   A^   A^   A^   A^   A^٢   A^ڃ   A^d   A^E   A^&   A^   A^   A^   A^   A^   A^l   A^M   A^.   A^   A^   A^   A^   A^   A^t   A^U   A^6   A^   A^   A^   A^   A^   A^|   A^]   A^>   A^   A^    A^m   A_ N   A_/   A_   A_   A_   A_   A_u   A_V   A_7   A_	   A_	   A_
   A_   A_   A_
}   A_^   A_?   A_    A_   A_   A_   A_   A_   A_f   A_G   A_(   A_   A_n   A_O   A_0   A_   A_   A_    A_!   A_"   A_#v   A_$W   A_%8   A_&   A_&   A_'   A_(   A_)   A_*~   A_+_   A_,@   A_-!   A_.   A_.   A_/   A_0   A_1   A_2g   A_3H   A_4)   A_5
   A_5   A_6   A_7   A_8   A_9o   A_:P   A_;1   A_<   A_<   A_=   A_>   A_?   A_@w   A_AX   A_B9   A_C   A_C   A_D   A_E   A_F   A_G   A_H`   A_IA   A_J"   A_K   A_K   A_L   A_M   A_N   A_Oh   A_PI   A_Q*   A_R   A_R   A_S   A_T   A_U   A_Vp   A_WQ   A_X2   A_Y   A_Y   A_Z   A_[   A_\   A_]x   A_^Y   A__:   A_`   A_`   A_a   A_b   A_c   A_d   A_ea   A_fB   A_g#   A_h   A_h   A_i   A_j   A_k   A_sq   A_tR   A_u3   A_v   A_v   A_w   A_x   A_y   A_zy   A_{Z   A_|;   A_}   A_}   A_~   A_   A_   A_   A_b   A_C   A_$   A_   A_   A_   A_   A_   A_j   A_K   A_,   A_
   A_   A_   A_   A_   A_r   A_S   A_4   A_   A_   A_   A_   A_   A_z   A_[   A_<   A_   A_   A_   A_   A_   A_   A_c   A_D   A_%   A_   A_   A_   A_   A_   A_k   A_L   A_-   A_   A_   A_   A_   A_   A_s   A_T   A_5   A_   A_   A_   A_   A_   A_{   A_\   A_=   A_   A_   A_   A_   A_   A_   A_d   A_E   A_&   A_   A_   A_   A_   A_   A_l   A_M   A_.   A_   A_   A_U   A_6   A_   A_   A_   A_Ϻ   A_Л   A_|   A_]   A_>   A_   A_    A_   A_   A_ף   A_؄   A_e   A_F   A_'   A_   A_   A_   A_ޫ   A_ߌ   A_m   A_N   A_/   A_   A_   A_   A_   A_   A_u   A_V   A_7   A_   A_   A_n   A_O   A_0   A`    A`    A`   A`   A`   A`v   A`W   A`8   A`   A`   A`   A`	   A`
   A`~   A`_   A`
@   A`!   A`   A`   A`   A`   A`   A`g   A`H   A`)   A`
   A`   A`   A`   A`   A`o   A`P   A`1   A`   A`   A`   A`#9   A`$   A`$   A`%   A`&   A`'   A`(   A`)`   A`*A   A`+"   A`,   A`,   A`-   A`.   A`/   A`0h   A`8Q   A`92   A`:   A`:   A`;   A`<   A`=   A`>x   A`?Y   A`@:   A`A   A`A   A`B   A`C   A`D   A`E   A`Fa   A`GB   A`H#   A`I   A`I   A`J   A`K   A`L   A`Mi   A`NJ   A`O+   A`P   A`P   A`Q   A`R   A`S   A`Tq   A`UR   A`V3   A`W   A`W   A`X   A`Y   A`Z   A`[y   A`\Z   A`];   A`^   A`^   A`_   A``   A`a   A`b   A`cb   A`dC   A`e$   A`f   A`f   A`g   A`h   A`i   A`jj   A`kK   A`l,   A`m
   A`m   A`n   A`o   A`p   A`qr   A`rS   A`s4   A`t   A`t   A`u   A`v   A`w   A`xz   A`y[   A`z<   A`{   A`{   A`|   A`}   A`~   A`   A`c   A`D   A`%   A`   A`   A`   A`   A`   A`k   A`L   A`-   A`   A`   A`   A`   A`   A`s   A`T   A`5   A`   A`   A`   A`   A`   A`{   A`\   A`=   A`   A`   A`   A`   A`   A`   A`d   A`E   A`&   A`   A`   A`   A`   A`   A`l   A`M   A`.   A`   A`   A`   A`   A`   A`t   A`U   A`6   A`   A`   A`   A`   A`   A`|   A`]   A`>   A`   A`    A`   A`   A`   A`   A`e   A`F   A`'   A`   A`   A`   A`   A`   A`m   A`N   A`/   A`   A`   A`   A`Ƴ   A`ǔ   A`u   A`V   A`7   A`   A`   A`   A`ͻ   A`Μ   A`   A`   A`   A`դ   A`օ   A`f   A`G   A`(   A`	   A`   A`   A`ܬ   A`ݍ   A`n   A`O   A`0   A`   A`   A`   A`   A`   A`v   A`W   A`8   A`   A`   A`   A`   A`   A`~   A`_   A`@   A`!   A`   A`   A`   A`   A`   A`g   A`H   A`)   A`
   A`   A`   Aa9   Aa   Aa   Aa   Aa   Aa   Aa	   Aa
`   AaA   Aa"   Aa
   Aa
   Aa   Aa   Aa   Aah   AaI   Aa*   Aa   Aa   Aa   Aa   Aa   Aap   AaQ   Aa2   Aa   Aa   Aa   Aa   Aa   Aax   Aa Y   Aa!:   Aa"   Aa"   Aa#   Aa$   Aa%   Aa&   Aa*   Aa+   Aa,   Aa-   Aa.i   Aa/J   Aa0+   Aa1   Aa1   Aa2   Aa3   Aa4   Aa5q   Aa6R   Aa73   Aa8   Aa8   Aa9   Aa:   Aa;   Aa<y   Aa=Z   Aa>;   Aa?   Aa?   Aa@   AaA   AaB   AaC   AaDb   AaEC   AaF$   AaG   AaG   AaH   AaI   AaJ   AaKj   AaLK   AaM,   AaN
   AaN   AaO   AaP   AaQ   AaRr   AaSS   AaT4   AaU   AaU   AaV   AaW   AaX   AaYz   AaZ[   Aa[<   Aa\   Aa\   Aa]   Aa^   Aa_   Aa`   Aaac   AabD   Aac%   Aad   Aad   Aae   Aaf   Aag   Aahk   AaiL   Aaj-   Aak   Aak   Aal   Aam   Aan   Aaos   AapT   Aaq5   Aar   Aar   Aas   Aat   Aau   Aav{   Aaw\   Aax=   Aay   Aay   Aaz   Aa{   Aa|   Aa}   Aa~d   Aa   Aa   Aa   Aal   AaM   Aa.   Aa   Aa   Aa   Aa   Aa   Aat   AaU   Aa6   Aa   Aa   Aa   Aa   Aa   Aa|   Aa]   Aa>   Aa   Aa    Aa   Aa   Aa   Aa   Aae   AaF   Aa'   Aa   Aa   Aa   Aa   Aa   Aam   AaN   Aa/   Aa   Aa   Aa   Aa   Aa   Aau   AaV   Aa7   Aa   Aa   Aa   Aa   Aa   Aa}   Aa^   Aa?   Aa    Aa   Aa   Aa   Aa   Aa   Aaf   AaG   Aa(   Aa	   Aa   Aa   Aa   Aa   Aan   AaO   Aa0   Aa   Aa   Aa   AaĴ   Aaŕ   Aav   AaW   Aa8   Aa   Aa   Aa   Aa˼   Aa̝   Aa~   Aa_   Aa@   Aa!   Aa   Aa   Aa   Aaӥ   AaԆ   Aag   AaH   Aaڭ   Aaێ   Aao   AaP   Aa1   Aa   Aa   Aa   Aa   Aa   Aaw   AaX   Aa9   Aa   Aa   Aa   Aa   Aa   Aa   Aa`   AaA   Aa"   Aa   Aa   Aa   Aa   Aa   Aah   AaI   Aa*   Aa   Aa   Aa   Aa   Aa   Aap   AaQ   Aa2   Aa   Aa   Aa   Aa   Aa   Ab x   AbY   Ab:   Ab   Ab   Ab   Ab   Ab   Ab   Aba   Ab	B   Ab
#   Ab   Ab   Ab   Ab
   Ab   Abi   AbJ   Ab+   Ab   Ab   Ab   Ab   Ab   Abq   AbR   Ab3   Ab   Ab   Ab   Ab   Ab   Aby   AbZ   Ab;   Ab    Ab    Ab!   Ab"   Ab#   Ab$   Ab%b   Ab&C   Ab'$   Ab(   Ab(   Ab)   Ab*   Ab+   Ab,j   Ab-K   Ab.,   Ab2   Ab3r   Ab4S   Ab54   Ab6   Ab6   Ab7   Ab8   Ab9   Ab:z   Ab;[   Ab<<   Ab=   Ab=   Ab>   Ab?   Ab@   AbA   AbBc   AbCD   AbD%   AbE   AbE   AbF   AbG   AbH   AbIk   AbJL   AbK-   AbL   AbL   AbM   AbN   AbO   AbPs   AbQT   AbR5   AbS   AbS   AbT   AbU   AbV   AbW{   AbX\   AbY=   AbZ   AbZ   Ab[   Ab\   Ab]   Ab^   Ab_d   Ab`E   Aba&   Abb   Abb   Abc   Abd   Abe   Abfl   AbgM   Abh.   Abi   Abi   Abj   Abk   Abl   Abmt   AbnU   Abo6   Abp   Abp   Abq   Abr   Abs   Abt|   Abu]   Abv>   Abw   Abx    Abx   Aby   Abz   Ab{   Ab|e   Ab}F   Ab~'   Ab   Ab   Ab   Ab   Ab   Abm   AbN   Ab/   Ab   Abu   AbV   Ab7   Ab   Ab   Ab   Ab   Ab   Ab}   Ab^   Ab?   Ab    Ab   Ab   Ab   Ab   Ab   Abf   AbG   Ab(   Ab	   Ab   Ab   Ab   Ab   Abn   AbO   Ab0   Ab   Ab   Ab   Ab   Ab   Ab~   Ab_   Ab@   Ab!   Ab   Ab   Ab   Ab   Ab   Abg   AbH   Ab)   Ab
   Ab   Ab   Ab   Ab   Abo   AbP   Ab1   Ab   Ab   Ab   Abµ   AbÖ   Abw   AbX   Ab9   Ab   Ab   Ab   Abɽ   Abʞ   Ab   Ab`   AbA   Ab"   Ab   Ab   Ab   AbѦ   Ab҇   Abh   AbI   Ab*   Ab   Ab   Ab   Abخ   Abُ   Abp   AbQ   Ab2   Ab   Ab   AbY   Ab:   Ab   Ab   Ab   Ab   Ab   Ab   Aba   AbB   Ab#   Ab   Ab   Ab   Ab   Ab   Abi   AbJ   Ab+   Ab   Ab   Ab   Ab   Ab   Abq   AbR   Ab3   Ab   Ab   Ab   Ab   Ab   Aby   AbZ   Ac ;   Ac   Ac   Ac   Ac   Ac   Ac   Acb   AcC   Ac$   Ac	   Ac	   Ac
   Ac   Ac   Ac
j   AcK   Ac,   Ac
   Ac   Ac   Ac   Ac   Acr   AcS   Ac4   Ac   Ac   Ac   Ac   Ac   Acz   Ac[   Ac<   Ac   Ac   Ac   Ac    Ac!   Ac"   Ac#c   Ac$D   Ac%%   Ac&   Ac&   Ac'   Ac(   Ac)   Ac*k   Ac+L   Ac,-   Ac-   Ac-   Ac.   Ac/   Ac0   Ac1s   Ac2T   Ac35   Ac4   Ac4   Ac5   Ac6   Ac7   Ac8{   Ac9\   Ac:=   Ac;   Ac;   Ac<   Ac=   Ac>   Ac?   Ac@d   AcAE   AcB&   AcC   AcC   AcD   AcE   AcF   AcGl   AcHM   AcI.   AcJ   AcJ   AcK   AcL   AcM   AcNt   AcOU   AcP6   AcQ   AcQ   AcR   AcS   AcT   AcU|   AcY   AcZ   Ac[   Ac\   Ac]e   Ac^F   Ac_'   Ac`   Ac`   Aca   Acb   Acc   Acdm   AceN   Acf/   Acg   Acg   Ach   Aci   Acj   Acn   Aco   Acp   Acq   Acr}   Acs^   Act?   Acu    Acv   Acv   Acw   Acx   Acy   Aczf   Ac{G   Ac|(   Ac}	   Ac}   Ac~   Ac   Ac   Acn   AcO   Ac0   Ac   Ac   Ac   Ac   Ac   Acv   AcW   Ac8   Ac   Ac   Ac   Ac   Ac!   Ac   Ac   Ac   Ac   Ac   Acg   AcH   Ac)   Ac
   Ac   Ac   Ac   Ac   Aco   AcP   Ac1   Ac   Ac   Ac   Ac   Ac   Acw   AcX   Ac9   Ac   Ac   Ac   Ac   Ac   Ac   Ac`   AcA   Ac"   Ac   Ac   Ac   Ac   Ac   Ach   AcI   Ac*   Ac   Ac   Ac   Ac   Ac   Acp   AcQ   Ac2   Ac   Ac   Ac   Ac   Ac   Acx   AcY   Ac:   Ac   Ac   Ac   AcǾ   Acȟ   Acɀ   Aca   AcB   Ac#   Ac   Ac   Ac   Acϧ   AcЈ   Aci   AcJ   Ac+   Ac   Ac   Ac   Ac֯   Acא   Acq   AcR   Ac3   Ac   Ac   Ac   Acݷ   Acޘ   Acy   AcZ   Ac;   Ac   Ac   Ac   Ac   Ac   Ac   Ac   Ac   Ac   Ac   Acj   AcK   Ac,   Ac
   Ac   Ac   Ac   Ac   Acr   AcS   Ac4   Ac   Ac   Ac   Ac   Ac   Acz   Ac[   Ac<   Ac   Ac   Ad    Ad   Ad   Ad   Adc   AdD   Ad%   Ad   Ad   Ad   Ad	   Ad
   Adk   AdL   Ad
-   Ad   Ad   Ad   Ad   Ad   Ads   AdT   Ad5   Ad   Ad   Ad   Ad   Ad   Ad{   Ad\   Ad=   Ad   Ad   Ad   Ad   Ad   Ad    Ad!d   Ad"E   Ad#&   Ad$   Ad$   Ad%   Ad&   Ad'   Ad(l   Ad)M   Ad*.   Ad+   Ad+   Ad,   Ad-   Ad.   Ad/t   Ad0U   Ad16   Ad2   Ad2   Ad3   Ad4   Ad5   Ad6|   Ad7]   Ad8>   Ad9   Ad:    Ad:   Ad;   Ad<   Ad=   Ad>e   Ad?F   Ad@'   AdA   AdA   AdB   AdC   AdD   AdEm   AdFN   AdG/   AdH   AdH   AdI   AdJ   AdK   AdLu   AdMV   AdN7   AdO   AdO   AdP   AdQ   AdR   AdS}   AdT^   AdU?   AdV    AdW   AdW   AdX   AdY   AdZ   Ad[f   Ad\G   Ad](   Ad^	   Ad^   Ad_   Ad`   Ada   Adbn   AdcO   Add0   Ade   Ade   Adf   Adg   Adh   Adiv   AdjW   Adk8   Adl   Adl   Adm   Adn   Ado   Adp~   Adq_   Adr@   Ads!   Adt   Adt   Adu   Adv   Adw   Adxg   AdyH   Adz)   Ad{
   Ad{   Ad|   Ad}   Ad~   Ado   AdP   Ad1   Ad   Ad   Ad   Ad   Ad   Adw   AdX   Ad9   Ad   Ad   Ad   Ad   Ad   Ad   Ad`   AdA   Ad"   Ad   Ad   Ad   Ad   Ad   Adh   Ad   Ad   Ad   Adp   AdQ   Ad2   Ad   Ad   Ad   Ad   Ad   Adx   AdY   Ad:   Ad   Ad   Ad   Ad   Ad   Ad   Ada   AdB   Ad#   Ad   Ad   Ad   Ad   Ad   Adi   AdJ   Ad+   Ad   Ad   Ad   Ad   Ad   Adq   AdR   Ad3   Ad   Ad   Ad   Ad   Ad   Ady   AdZ   Ad;   Ad   Ad   Ad   Adſ   AdƠ   Adǁ   Adb   AdC   Ad$   Ad   Ad   Ad   Adͨ   AdΉ   Adj   AdK   Ad,   Ad
   Ad   Ad   Ad԰   AdՑ   Adr   AdS   Ad4   Ad   Ad   Ad   Ad۸   Adܙ   Adz   Ad[   Ad<   Ad   Ad   Ad   Ad   Ad   Ad   Adc   AdD   Ad%   Ad   Ad   Ad   Ad   Ad   Adk   AdL   Ad   Ad   Ads   AdT   Ad5   Ad   Ad   Ad   Ad   Ad   Ad{   Ad\   Ad=   Ad   Ad   Ad   Ad   Ae    Ae   Aed   AeE   Ae&   Ae   Ae   Ae   Ae   Ae   Ae	l   Ae
M   Ae.   Ae   Ae   Ae
   Ae   Ae   Aet   AeU   Ae6   Ae   Ae   Ae   Ae   Ae   Ae|   Ae]   Ae>   Ae   Ae    Ae   Ae   Ae   Ae   Aee   Ae F   Ae!'   Ae"   Ae"   Ae#   Ae$   Ae%   Ae&m   Ae'N   Ae(/   Ae)   Ae)   Ae*   Ae+   Ae,   Ae-u   Ae.V   Ae/7   Ae0   Ae0   Ae1   Ae2   Ae3   Ae4}   Ae5^   Ae6?   Ae7    Ae8   Ae8   Ae9   Ae:   Ae;   Ae<f   Ae=G   Ae>(   Ae?	   Ae?   Ae@   AeA   AeB   AeCn   AeDO   AeE0   AeI   AeJv   AeKW   AeL8   AeM   AeM   AeN   AeO   AeP   AeQ~   AeR_   AeS@   AeT!   AeU   AeU   AeV   AeW   AeX   AeYg   AeZH   Ae[)   Ae\
   Ae\   Ae]   Ae^   Ae_   Ae`o   AeaP   Aeb1   Aec   Aec   Aed   Aee   Aef   Aegw   AehX   Aei9   Aej   Aej   Aek   Ael   Aem   Aen   Aeo`   AepA   Aeq"   Aer   Aer   Aes   Aet   Aeu   Aevh   AewI   Aex*   Aey   Aey   Aez   Ae{   Ae|   Ae}p   Ae~Q   Ae2   Ae   Ae   Ae   Ae   Ae   Aex   Ae   Ae   Ae   Ae   Aei   AeJ   Ae+   Ae   Ae   Ae   Ae   Ae   Aeq   AeR   Ae3   Ae   Aey   AeZ   Ae;   Ae   Ae   Ae   Ae   Ae   Ae   Aeb   AeC   Ae$   Ae   Ae   Ae   Ae   Ae   Aej   AeK   Ae,   Ae
   Ae   Ae   Ae   Ae   Aer   AeS   Ae4   Ae   Ae   Ae   Ae   Ae   Aez   Ae[   Ae<   Ae   Ae   Ae   Ae   Aeġ   Aeł   Aec   AeD   Ae%   Ae   Ae   Ae   Ae˩   Ae̊   Aek   AeL   Ae-   Ae   Ae   Ae   Aeұ   AeӒ   Aes   AeT   Ae5   Ae   Ae   Ae   Aeٹ   Aeښ   Ae{   Ae\   Ae=   Ae   Ae   Ae   Ae   Ae   Ae   Aed   AeE   Ae&   Ae   Ae   Ae   Ae   Ae   Ael   AeM   Ae.   Ae   Ae   Ae   Ae   Ae   Aet   AeU   Ae6   Ae   Ae   Ae]   Ae>   Ae   Ae    Ae   Ae   Ae   Ae   Af e   AfF   Af'   Af   Af   Af   Af   Af   Afm   AfN   Af	/   Af
   Af
   Af   Af   Af
   Afu   AfV   Af7   Af   Af   Af   Af   Af   Af}   Af^   Af?   Af    Af   Af   Af   Af   Af   Aff   AfG   Af(   Af 	   Af    Af!   Af"   Af#   Af$n   Af%O   Af&0   Af'   Af'   Af(   Af)   Af*   Af+v   Af,W   Af-8   Af.   Af.   Af/   Af0   Af1   Af2~   Af3_   Af4@   Af5!   Af6   Af6   Af7   Af8   Af9   Af:g   Af;H   Af<)   Af=
   Af=   Af>   Af?   Af@   AfAo   AfBP   AfC1   AfD   AfD   AfE   AfF   AfG   AfHw   AfIX   AfJ9   AfK   AfK   AfL   AfM   AfN   AfO   AfP`   AfQA   AfR"   AfS   AfS   AfT   AfU   AfV   AfWh   AfXI   AfY*   AfZ   AfZ   Af[   Af\   Af]   Af^p   Af_Q   Af`2   Afa   Afa   Afb   Afc   Afd   Afex   AffY   Afg:   Afh   Afh   Afi   Afj   Afk   Afl   Afma   AfnB   Afo#   Afp   Afp   Afq   Afr   Afs   Afti   AfuJ   Afv+   Afw   Afw   Afx   Afy   Afz   Af{q   Af|R   Af}3   Af~   Af~   Af   Af   Af   Afy   AfZ   Af;   Af   Af   Af   Af   Af   Af   Afb   AfC   Af$   Af   Af   Af   Af   Af   Afj   AfK   Af,   Af
   Af   Af   Af   Af   Afr   AfS   Af4   Af   Af   Af   Af   Af   Afz   Af[   Af<   Af%   Af   Af   Af   Af   Af   Afk   AfL   Af-   Af   Af   Af   Af   Af   Afs   AfT   Af5   Af   Af   Af   Af   Af   Af{   Af\   Af=   Af   Af   Af   Af   Af¢   AfÃ   Afd   AfE   Af&   Af   Af   Af   Afɪ   Afʋ   Afl   AfM   Af.   Af   Af   Af   Afв   Afѓ   Aft   AfU   Af6   Af   Af   Af   Af׺   Af؛   Af|   Af]   Af>   Af   Af    Af   Af   Afߣ   Af   Afe   AfF   Af'   Af   Af   Af   Af   Af   Afm   AfN   Af/   Af   Af   Af   Af   Af   Afu   AfV   Af7   Af   Af   Af   Af   Af   Af}   Af^   Af?   Af    Af   Af   Af   Af   Ag	   Ag   Ag   Ag   Ag   Agn   AgO   Ag0   Ag   Ag   Ag	   Ag
   Ag   Agv   Ag
W   Ag8   Ag   Ag   Ag   Ag   Ag   Ag~   Ag_   Ag@   Ag!   Ag   Ag   Ag   Ag   Ag   Agg   AgH   Ag)   Ag
   Ag   Ag   Ag    Ag!   Ag"o   Ag#P   Ag$1   Ag%   Ag%   Ag&   Ag'   Ag(   Ag)w   Ag*X   Ag+9   Ag,   Ag,   Ag-   Ag.   Ag/   Ag0   Ag1`   Ag2A   Ag3"   Ag4   Ag4   Ag5   Ag6   Ag7   Ag8h   Ag9I   Ag:*   Ag;   Ag;   Ag<   Ag=   Ag>   Ag?p   Ag@Q   AgA2   AgB   AgB   AgC   AgD   AgE   AgFx   AgGY   AgH:   AgI   AgI   AgJ   AgK   AgL   AgM   AgNa   AgOB   AgP#   AgQ   AgQ   AgR   AgS   AgT   AgX   AgY   AgZ   Ag[   Ag\q   Ag]R   Ag^3   Ag_   Ag_   Ag`   Aga   Agb   Agcy   AgdZ   Age;   Agf   Agf   Agg   Agh   Agi   Agj   Agkb   AglC   Agm$   Agn   Agn   Ago   Agp   Agq   Agrj   AgsK   Agt,   Agu
   Agu   Agv   Agw   Agx   Agyr   AgzS   Ag{4   Ag|   Ag|   Ag}   Ag~   Ag   Agz   Ag[   Ag<   Ag   Ag   Ag   Ag   Ag   Ag   Agc   AgD   Ag%   Ag   Ag   Ag   Ag   Ag   Agk   AgL   Ag-   Ag   Ag   Ag   Ag   Ag   Ags   AgT   Ag5   Ag   Ag   Ag   Ag   Ag   Ag{   Ag\   Ag=   Ag   Ag   Ag   Ag   Ag   Ag   Agd   AgE   Ag&   Ag   Ag   Ag   Ag   Ag   Agl   Ag   Ag   Ag   Agt   AgU   Ag6   Ag   Ag   Ag   Ag   Ag   Ag|   Ag]   Ag>   Ag   Ag    Ag   Ag   Ag   Ag   Age   AgF   Ag'   Ag   Ag   Ag   Agǫ   AgȌ   Agm   AgN   Ag/   Ag   Ag   Ag   Agγ   Agϔ   Agu   AgV   Ag7   Ag   Ag   Ag   Agջ   Ag֜   Ag}   Ag^   Ag?   Ag    Ag   Ag   Ag   Agݤ   Agޅ   Agf   AgG   Ag(   Ag	   Ag   Ag   Ag   Ag   Agn   AgO   Ag0   Ag   Ag   Ag   Ag   Ag   Agv   AgW   Ag8   Ag   Ag   Ag   Ag   Ag   Ag~   Ag_   Ag@   Ag!   Ag   Ag   Ag   Ag   Ag   Agg   AgH   Ag)   Ag
   Ag   Ah    Ah   Ah   Aho   AhP   Ah   Ah	   Ah
w   AhX   Ah9   Ah
   Ah
   Ah   Ah   Ah   Ah   Ah`   AhA   Ah"   Ah   Ah   Ah   Ah   Ah   Ahh   AhI   Ah*   Ah   Ah   Ah   Ah   Ah   Ah p   Ah!Q   Ah"2   Ah#   Ah#   Ah$   Ah%   Ah&   Ah'x   Ah(Y   Ah):   Ah*   Ah*   Ah+   Ah,   Ah-   Ah.   Ah/a   Ah0B   Ah1#   Ah2   Ah2   Ah3   Ah4   Ah5   Ah6i   Ah7J   Ah8+   Ah9   Ah9   Ah:   Ah;   Ah<   Ah=q   Ah>R   Ah?3   Ah@   Ah@   AhA   AhB   AhC   AhDy   AhEZ   AhF;   AhG   AhG   AhH   AhI   AhJ   AhK   AhLb   AhMC   AhN$   AhO   AhO   AhP   AhQ   AhR   AhSj   AhTK   AhU,   AhV
   AhV   AhW   AhX   AhY   AhZr   Ah[S   Ah\4   Ah`   Ahaz   Ahb[   Ahc<   Ahd   Ahd   Ahe   Ahf   Ahg   Ahh   Ahic   AhjD   Ahk%   Ahl   Ahl   Ahm   Ahn   Aho   Ahpk   AhqL   Ahr-   Ahs   Ahs   Aht   Ahu   Ahv   Ahws   AhxT   Ahy5   Ahz   Ahz   Ah{   Ah|   Ah}   Ah~{   Ah\   Ah=   Ah   Ah   Ah   Ah   Ah   Ah   Ahd   AhE   Ah&   Ah   Ah   Ah   Ah   Ah   Ahl   AhM   Ah.   Ah   Ah   Ah   Ah   Ah   Aht   AhU   Ah6   Ah   Ah   Ah   Ah   Ah   Ah|   Ah]   Ah>   Ah   Ah    Ah   Ah   Ah   Ah   Ahe   AhF   Ah'   Ah   Ah   Ah   Ah   Ah   Ahm   AhN   Ah/   Ah   Ah   Ah   Ah   Ah   Ahu   AhV   Ah7   Ah   Ah}   Ah^   Ah?   Ah    Ah   Ah   Ah   Ah   Ah   Ahf   AhG   Ah(   Ah	   Ah   Ah   AhŬ   Ahƍ   Ahn   AhO   Ah0   Ah   Ah   Ah   Ah̴   Ah͕   Ahv   AhW   Ah8   Ah   Ah   Ah   AhӼ   Ahԝ   Ah~   Ah_   Ah@   Ah!   Ah   Ah   Ah   Ahۥ   Ah܆   Ahg   AhH   Ah)   Ah
   Ah   Ah   Ah   Ah   Aho   AhP   Ah1   Ah   Ah   Ah   Ah   Ah   Ahw   AhX   Ah9   Ah   Ah   Ah   AhA   Ah"   Ah   Ah   Ah   Ah   Ah   Ahh   AhI   Ah*   Ah   Ah   Ah   Ah   Ai    Aip   AiQ   Ai2   Ai   Ai   Ai   Ai   Ai   Aix   Ai	Y   Ai
:   Ai   Ai   Aia   AiB   Ai#   Ai   Ai   Ai   Ai   Ai   Aii   AiJ   Ai+   Ai   Ai   Ai   Ai   Ai   Aiq   AiR   Ai 3   Ai!   Ai!   Ai"   Ai#   Ai$   Ai%y   Ai&Z   Ai';   Ai(   Ai(   Ai)   Ai*   Ai+   Ai,   Ai-b   Ai.C   Ai/$   Ai0   Ai0   Ai1   Ai2   Ai3   Ai4j   Ai5K   Ai6,   Ai7
   Ai7   Ai8   Ai9   Ai:   Ai;r   Ai<S   Ai=4   Ai>   Ai>   Ai?   Ai@   AiA   AiBz   AiC[   AiD<   AiE   AiE   AiF   AiG   AiH   AiI   AiJc   AiKD   AiL%   AiM   AiM   AiN   AiO   AiP   AiQk   AiRL   AiS-   AiT   AiT   AiU   AiV   AiW   AiXs   AiYT   AiZ5   Ai[   Ai[   Ai\   Ai]   Ai^   Ai_{   Ai`\   Aia=   Aib   Aib   Aic   AihE   Aii&   Aij   Aij   Aik   Ail   Aim   Ainl   AioM   Aip.   Aiq   Aiq   Air   Ais   Ait   Aiut   AivU   Aiw6   Aix   Aix   Aiy   Aiz   Ai{   Ai||   Ai}]   Ai~>   Ai   Ai    Ai   Ai   Ai   Ai   Aie   AiF   Ai'   Ai   Ai   Ai   Ai   Ai   Aim   AiN   Ai/   Ai   Ai   Ai   Ai   Ai   Aiu   AiV   Ai7   Ai   Ai   Ai   Ai   Ai   Ai}   Ai^   Ai?   Ai    Ai   Ai   Ai   Ai   Ai   Aif   AiG   Ai(   Ai	   Ai   Ai   Ai   Ai   Ain   AiO   Ai0   Ai   Ai   Ai   Ai   Ai   Aiv   AiW   Ai8   Ai   Ai   Ai   Ai   Ai   Ai~   Ai_   Ai@   Ai!   Ai   Ai   Ai   Ai)   Ai
   Ai   Ai   Aií   AiĎ   Aio   AiP   Ai1   Ai   Ai   Ai   Aiʵ   Ai˖   Aiw   AiX   Aiѽ   AiҞ   Ai   Ai`   AiA   Ai"   Ai   Ai   Ai   Ai٦   Aiڇ   Aih   AiI   Ai*   Ai   Ai   Ai   Ai   Ai   Aip   AiQ   Ai2   Ai   Ai   Ai   Ai   Ai   Aix   AiY   Ai:   Ai   Ai   Ai   Ai   Ai   Ai   Aia   AiB   Ai#   Ai   Ai   Ai   Ai   Ai   Aii   AiJ   Ai+   Ai   Ai   Ai   Ai   Ai   Aiq   Aj R   Aj3   Aj   Aj   Aj   Aj   Aj   Ajy   AjZ   Aj;   Aj	   Aj	   Aj
   Aj   Aj   Aj
   Ajb   AjC   Aj$   Aj   Aj   Aj   Aj   Aj
   Aj   Aj   Aj   Aj   Ajr   AjS   Aj4   Aj   Aj   Aj    Aj!   Aj"   Aj#z   Aj$[   Aj%<   Aj&   Aj&   Aj'   Aj(   Aj)   Aj*   Aj+c   Aj,D   Aj-%   Aj.   Aj.   Aj/   Aj0   Aj1   Aj2k   Aj3L   Aj4-   Aj5   Aj5   Aj6   Aj7   Aj8   Aj9s   Aj:T   Aj;5   Aj<   Aj<   Aj=   Aj>   Aj?   Aj@{   AjA\   AjB=   AjC   AjC   AjD   AjPM   AjQ.   AjR   AjR   AjS   AjT   AjU   AjVt   AjWU   AjX6   AjY   AjY   AjZ   Aj[   Aj\   Aj]|   Aj^]   Aj_>   Aj`   Aja    Aja   Ajb   Ajc   Ajd   Ajee   AjfF   Ajg'   Ajh   Ajh   Aji   Ajj   Ajk   Ajo   Ajp   Ajq   Ajr   Ajsu   AjtV   Aju7   Ajv   Ajv   Ajw   Ajx   Ajy   Ajz}   Aj{^   Aj|?   Aj}    Aj~   Aj~   Aj   Aj   Aj   Ajf   AjG   Aj(   Aj	   Aj   Aj   Aj   Aj   Ajn   AjO   Aj0   Aj   Aj   Aj   Aj   Aj   Ajv   AjW   Aj8   AqJ   Aq+   Aq   Aq   Aq   Aq   Aq   Aqq   AqR   Aq	3   Aq
   Aq
   Aq   Aq   Aq
   Aqy   AqZ   Aq;   Aq   Aq   Aq   Aq   Aq   Aq   Aqb   AqC   Aq$   Aq   Aq   Aq   Aq   Aq   Aqj   AqK   Aq,   Aq 
   Aq    Aq!   Aq"   Aq#   Aq$r   Aq%S   Aq&4   Aq'   Aq'   Aq(   Aq)   Aq.   Aq.   Aq/   Aq0   Aq1   Aq2   Aq3c   Aq4D   Aq5%   Aq6   Aq6   Aq7   Aq8   Aq9   Aq:k   Aq;L   Aq<-   Aq=   Aq=   Aq>   Aq?   Aq@   AqAs   AqBT   AqC5   AqD   AqD   AqE   AqM   AqN   AqO   AqPd   AqQE   AqR&   AqS   AqS   AqT   AqU   AqV   AqWl   AqXM   AqY.   AqZ   AqZ   Aq[   Aq\   Aq]   Aq^t   Aq_U   Aq`6   Aqa   Aqa   Aqb   Aqc   Aqd   Aqe|   Aqf]   Aqg>   Aqh   Aqi    Aqi   Aqj   Aqk   Aql   Aqme   AqnF   Aqo'   Aqp   Aqp   Aqq   Aqr   Aqs   Aqtm   AquN   Aqv/   Aqw   Aqw   Aqx   Aqy   Aqz   Aq{u   Aq|V   Aq}7   Aq~   Aq~   Aq   Aq   Aq   Aq}   Aq^   Aq?   Aq    Aq   Aq   Aq   Aq   Aq   Aqf   AqG   Aq(   Aq	   Aq   Aq   Aq   Aq   Aqn   AqO   Aq0   Aq   Aq   Aq   Aq   Aq   Aqv   AqW   Aq8   Aq   Aq   Aq   Aq   Ar   Ar   Arc   ArD   Ar%   Ar   Ar   Ar   Ar   Ar   Ark   ArL   Ar-   Ar   Ar   Ar   Ar    Ar!   Ar"s   Ar#T   Ar$5   Ar%   Ar%   Ar&   Ar'   Ar(   Ar){   Ar*\   Ar+=   Ar,   Ar,   Ar-   Ar.   Ar/   Ar0   Ar1d   Ar2E   Ar3&   Ar4   Ar4   Ar5   Ar6   Ar7   Ar8l   Ar9M   Ar:.   Ar;   Ar;   Ar<   Ar=   Ar>   Ar?t   Ar@U   ArA6   ArB   ArB   ArC   ArD   ArE   ArF|   ArG]   ArH>   ArI   ArJ    ArJ   ArK   ArL   ArM   ArNe   ArOF   ArP'   ArQ   ArUm   ArVN   ArW/   ArX   Ar\u   Ar]V   Ar^7   Ar_   Ar_   Ar`   Ara   Arb   Arc}   Ard^   Are?   Arf    Arg   Arg   Arh   Ari   Arj   Arkf   ArlG   Arm(   Arn	   Arn   Aro   Arp   Arq   Arrn   ArsO   Art0   Aru   Aru   Arv   Arw   Arx   Aryv   ArzW   Ar{8   Ar|   Ar|   Ar}   Ar~   Ar   Ar~   Ar_   Ar@   Ar!   Ar   Ar   Ar   Ar   Ar   Arg   ArH   Ar)   Ar
   Ar   Ar   Ar   Ar   Aro   ArP   Ar1   Ar   Ar   Ar   Ar   Ar   Arw   ArX   Ar9   Ar   Ar   Ar   Ar   Ar   Ar   Ar`   ArA   Ar"   Ar   Ar   Ar   Ar   Ar   Arh   ArI   Ar*   Ar   Ar   ArQ   Ar2   Ar   Ar   Ar   Ar   Ar   Arx   ArY   Ar:   Ar   Ar   Ar   Ar   Ar   Ar   Ara   ArB   Ar#   Ar   Ar   Ar   Ar   Ar   Ari   ArJ   Ar+   Ar   Ar   Ar   Arǯ   ArȐ   Arq   ArR   Ar3   Ar   Ar   Ar   Arη   ArϘ   Ary   ArZ   Ar;   Ar   Ar   Ar   Arտ   Ar֠   Arׁ   Arb   ArC   Ar$   Ar   Ar   Ar   Arݨ   Arމ   Arj   ArK   Ar,   Ar
   Ar   Ar   Ar   Ar   Arr   ArS   Ar4   Ar   Ar   Ar   Ar   Ar   Arz   Ar[   Ar<   Ar   Ar   Ar   Ar   Ar   Ar   Arc   ArD   Ar%   Ar   Ar   Ar   Ar   Ar   Ark   ArL   As   As   Ass   AsT   As5   As   As   As   As   As	   As
{   As\   As=   As
   As
   As   As   As   As   Asd   AsE   As&   As   As   As   As   As   Asl   AsM   As.   As   As   As   As   As   As t   As!U   As"6   As#   As#   As$   As%   As&   As'|   As(]   As)>   As*   As+    As+   As,   As-   As.   As/e   As0F   As1'   As2   As2   As3   As4   As5   As6m   As7N   As8/   As9   As9   As:   As;   As<   As=u   As>V   As?7   As@   As@   AsA   AsB   AsC   AsK   AsLf   AsMG   AsN(   AsO	   AsO   AsP   AsQ   AsR   AsSn   AsTO   AsU0   AsV   AsV   AsW   AsX   As]   As]   As^   As_   As`   Asa~   Asb_   Asc@   Asd!   Ase   Ase   Asf   Asg   Ash   Asig   AsjH   Ask)   Asl
   Asl   Asm   Asn   Aso   Aspo   AsqP   Asr1   Ass   Ass   Ast   Asu   Asv   Asww   AsxX   Asy9   Asz   Asz   As{   As|   As}   As~   As`   AsA   As"   As   As   As   As   As   Ash   AsI   As*   As   As   As   As   As   Asp   AsQ   As2   As   As   As   As   As   Asx   AsY   As:   As   As   As   As   As   As   Asa   AsB   As#   As   As   As   As   As   Asi   AsJ   As+   As   As   As   As   As   Asq   AsR   As3   As   As   As   As   As   As   As   As   As   As   Asb   AsC   As$   As   As   As   As   As   Asj   AsK   As,   As
   As   As   AsŰ   AsƑ   Asr   AsS   As4   As   As   As   As̸   As͙   Asz   As[   As<   As   As   As   As   Asԡ   AsՂ   Asc   AsD   As   As   As{   As\   As=   As   As   As   As   As   As   Asd   AsE   As&   As   As   As   As   As   Asl   AsM   As.   As   As   As   As   At    Att   AtU   At6   At   At   At   At   At   At|   At   At
   At   At   Ate   AtF   At'   At   At   At   At   At   Atm   AtN   At/   At   At   At   At   At   Atu   AtV   At 7   At!   At%}   At&^   At'?   At(    At)   At)   At*   At+   At,   At-f   At.G   At/(   At0	   At0   At1   At2   At3   At4n   At5O   At60   At7   At7   At8   At9   At:   At;v   At<W   At=8   At>   At>   At?   At@   AtA   AtB~   AtC_   AtD@   AtE!   AtF   AtF   AtG   AtH   AtI   AtJg   AtKH   AtL)   AtM
   AtM   AtN   AtO   AtP   AtQo   AtRP   AtS1   AtT   AtT   AtU   AtV   AtW   AtXw   AtYX   AtZ9   At[   At[   At\   At]   At^   At_   At``   Atd   Ate   Atf   Atgh   AthI   Ati*   Atj   Atj   Atk   Atl   Atm   Atnp   AtoQ   Atp2   Atq   Atq   Atr   Ats   Att   Atux   AtvY   Atw:   Atx   Atx   Aty   Atz   At{   At|   At}a   At~B   At#   At   At   At   At   At   Ati   AtJ   At+   At   At   At   At   At   Atq   AtR   At3   At   At   At   At   At   Aty   AtZ   At;   At   At   At   At   At   At   Atb   AtC   At$   At   At   At   At   At   Atj   AtK   At,   At
   At   At   At   At   Atr   AtS   At4   At   At   At   At   At   Atz   At[   At<   At   At   At   At   At   At   Atk   AtL   At-   At   At   At   Atñ   AtĒ   Ats   AtT   At5   At   At   At   Atʹ   At˚   At{   At\   At=   At   At   At   At   AtҢ   AtӃ   Atd   AtE   At&   At   At   At   At٪   Atڋ   Atl   AtM   At.   At   At   At   At   At   Att   AtU   At6   At   At   At   At   At   At|   At]   At>   At   At    At   At   At   At   Ate   AtF   At'   At   At   At   At   At   Atm   AtN   At/   At   At   At   At   At   Atu   Au V   Au7   Au   Au   Au   Au   Au   Au}   Au^   Au?   Au	    Au
   Au
   Au   Au   Au
   Auf   AuG   Au(   Au   Aun   AuO   Au0   Au   Au   Au   Au   Au   Auv   AuW   Au8   Au   Au   Au    Au!   Au"   Au#~   Au$_   Au%@   Au&!   Au'   Au'   Au(   Au)   Au*   Au+g   Au,H   Au-)   Au.
   Au.   Au/   Au0   Au1   Au2o   Au3P   Au41   Au5   Au5   Au6   Au7   Au8   Au9w   Au:X   Au;9   Au<   Au<   Au=   Au>   Au?   Au@   AuA`   AuBA   AuC"   AuD   AuD   AuE   AuF   AuG   AuHh   AuII   AuJ*   AuK   AuK   AuPQ   AuQ2   AuR   AuR   AuS   AuT   AuU   AuVx   AuWY   AuX:   AuY   AuY   AuZ   Au[   Au\   Au]   Au^a   Au_B   Au`#   Aua   Aua   Aub   Auc   Aud   Auei   AufJ   Aug+   Auh   Aulq   AumR   Aun3   Auo   Auo   Aup   Auq   Aur   Ausy   AutZ   Auu;   Auv   Auv   Auw   Aux   Auy   Au~   Au~   Au   Au   Au   Auj   AuK   Au,   Au
   Au   Au   Au   Au   Au   Au   Au   Au   Auz   Au[   Au<   Au   Au   Au   Au   Au   Au   Auc   AuD   Au%   Au   Au   Au   Au   Au   Auk   AuL   Au-   Au   Au   Au   Au   Au   Aus   AuT   Au5   Au   Au   Au   Au   Au   Au{   Au\   Au=   Au   Au   Au   Au   Au   Au   Aud   AuE   Au&   Au   Au   Au   Au   Au   Aul   AuM   Au.   Au   Au   AuU   Au6   Au   Au   Au|   Au]   Au>   Au   Au    Au   Au   AuУ   Auф   Aue   AuF   Au'   Au   Au   Au   Au׫   Au،   Aum   AuN   Au/   Au   Au   Au   Au޳   Auߔ   Auu   AuV   Au7   Au   Au   Au   Au   Au   Au}   Au^   Au?   Au    Au   Au   Au   Au   Au   Auf   AuG   Au(   Au	   Au   Au   Au   Au   Aun   AuO   Au0   Au   Au   Au   Au   Au   Auv   AuW   Au8   Av    Av    Av   Av   Av   Av~   Av_   Av@   Av!   Av   Av   Av	   Av
   Av   Avg   Av
H   Av)   Av
   Av   Av   Av   Av   Avo   AvP   Av1   Av   Av   Av   Av   Av   Avw   AvX   Av9   Av   Av   Av   Av   Av    Av!   Av"`   Av#A   Av$"   Av%   Av%   Av&   Av'   Av(   Av)h   Av*I   Av+*   Av,   Av,   Av-   Av.   Av/   Av0p   Av1Q   Av22   Av3   Av3   Av4   Av5   Av6   Av7x   Av8Y   Av9:   Av:   Av:   Av;   Av<   Av=   Av>   Av?a   Av@B   AvA#   AvB   AvB   AvC   AvD   AvE   AvFi   AvGJ   AvH+   AvI   AvI   AvJ   AvK   AvL   AvMq   AvNR   AvO3   AvP   AvP   AvQ   AvR   AvS   AvTy   AvUZ   AvV;   AvW   AvW   AvX   AvY   AvZ   Av[   Av\b   Av]C   Av^$   Av_   Av_   Av`   Ava   Avb   Avcj   AvdK   Ave,   Avf
   Avf   Avg   Avh   Avi   Avjr   AvkS   Avl4   Avm   Avm   Avn   Avo   Avp   Avqz   Avr[   Avs<   Avt   Avt   Avu   Avv   Avw   Avx   Avyc   AvzD   Av{%   Av|   Av|   Av}   Av~   Av   Avk   AvL   Av-   Av   Av   Av   Av   Av   Avs   AvT   Av5   Av   Av   Av   Av   Av   Av{   Av\   Av=   Av   Av   Av   Av   Av   Av   Avd   AvE   Av&   Av   Av   Av   Av   Av   Avl   AvM   Av.   Av   Av   Av   Av   Av   Avt   AvU   Av6   Av   Av   Av   Av   Av   Av|   Av]   Av>   Av   Av    Av   Av   Av   Av   Ave   AvF   Av'   Av   Av   Av   Av   Av   Avm   AvN   Av/   Av   Av   Av   Av   Av   Avu   AvV   Av7   Av   Av   Av   Avƻ   Avǜ   Av}   Av^   Av?   Av    Av   Av   Av   AvΤ   Avυ   Avf   AvG   Av(   Av	   Av   Av   Avլ   Av֍   Avn   AvO   Av0   Av   Av   Av   Avܴ   Avݕ   Avv   AvW   Av8   Av   Av   Av   Av   Av   Av~   Av_   Av@   Av!   Av   Av   Av   Av   Av   Avg   AvH   Av)   Av
   Av   Av   Av   Av   Avo   AvP   Av1   Av   Av   Av   Av   Av   Avw   AvX   Av9   Av   Av   Av   Aw    Aw   Aw   Aw`   AwA   Aw"   Aw   Aw   Aw   Aw   Aw	   Aw
h   AwI   Aw*   Aw
   Aw
   Aw   Aw   Aw   Awp   AwQ   Aw2   Aw   Aw   Aw   Aw   Aw   Awx   AwY   Aw:   Aw   Aw   Aw   Aw   Aw   Aw   Aw a   Aw!B   Aw"#   Aw#   Aw#   Aw$   Aw%   Aw&   Aw'i   Aw(J   Aw)+   Aw*   Aw*   Aw+   Aw,   Aw-   Aw1   Aw2   Aw3   Aw4   Aw5y   Aw6Z   Aw7;   Aw8   Aw8   Aw9   Aw:   Aw;   Aw<   Aw=b   Aw>C   Aw?$   AwC   AwDj   AwEK   AwF,   AwG
   AwG   AwH   AwI   AwJ   AwKr   AwLS   AwM4   AwN   AwN   AwO   AwP   AwQ   AwRz   AwS[   AwT<   AwU   AwU   AwV   AwW   AwX   AwY   AwZc   Aw[D   Aw\%   Aw]   Aw]   Aw^   Aw_   Aw`   Awak   AwbL   Awj5   Awk   Awk   Awl   Awm   Awn   Awo{   Awp\   Awq=   Awr   Awr   Aws   Awt   Awu   Awv   Awwd   Aw{   Aw|   Aw}   Aw~l   AwM   Aw.   Aw   Aw   Aw   Aw   Aw   Awt   AwU   Aw6   Aw   Aw   Aw   Aw   Aw   Aw|   Aw]   Aw>   Aw   Aw    Aw   Aw   Aw   Aw   Awe   AwF   Aw'   Aw   Aw   Aw   Aw   Aw   Awm   AwN   Aw/   Aw   Aw   Aw   Aw   Aw   Awu   AwV   Aw7   Aw   Aw   Aw   Aw   Aw   Aw}   Aw^   Aw?   Aw    Aw   Aw   Aw   Aw   Aw   Awf   AwG   Aw(   Aw	   Aw   Aw   Aw   Aw   Awn   AwO   Aw0   Aw   Aw   Aw   Aw   Aw   Awv   AwW   Aw8   Aw   Aw   Aw   Awļ   Awŝ   Aw~   Aw_   Aw@   Aw!   Aw   Aw   Aw   Aw̥   Aw͆   Awg   AwH   Awӭ   AwԎ   Awo   AwP   Aw1   Aw   Aw   Aw   Awڵ   Awۖ   Aww   AwX   Aw9   Aw   Aw   Aw   Aw   Aw   Aw   Aw`   AwA   Aw"   Aw   Aw   Aw   Aw   Aw   Awh   AwI   Aw*   Aw   Aw   Aw   Aw   Aw   Awp   AwQ   Aw2   Aw   Aw   Aw   Aw   Aw   Awx   AwY   Aw:   Aw   Aw   Aw   Aw   Aw   Ax    Axa   AxB   Ax#   Ax   Ax   Ax   Ax   Ax   Axi   Ax	J   Ax
+   Ax   Ax   Ax   Ax
   Ax   Axq   AxR   Ax3   Ax   Ax   Ax   Ax   Ax   Axy   AxZ   Ax;   Ax   Ax   Ax   Ax   Ax   Ax   Axb   AxC   Ax $   Ax!   Ax!   Ax"   Ax#   Ax$   Ax%j   Ax&K   Ax',   Ax+   Ax,r   Ax-S   Ax.4   Ax/   Ax/   Ax0   Ax1   Ax6   Ax6   Ax7   Ax8   AxG   AxH   AxIs   AxJT   AxK5   AxL   AxL   AxM   AxN   AxO   AxP{   AxQ\   AxR=   AxS   AxS   AxT   AxU   AxV   AxW   AxXd   AxYE   AxZ&   Ax[   Ax[   Axc   Axd   Axe   Axft   AxgU   Axh6   Axi   Axi   Axj   Axk   Axl   Axm|   Axn]   Axo>   Axp   Axq    Axq   Axr   Axs   Axt   Axue   AxvF   Axw'   Axx   Axx   Axy   Axz   Ax{   Ax|m   Ax}N   Ax~/   Ax   Ax   Ax   Ax   Ax   Ax}   Ax^   Ax?   Ax    Ax   Ax   Ax   Ax   Ax   Axf   AxG   Ax(   Ax	   Ax   Ax   Ax   Ax   Axn   AxO   Ax0   Ax   Ax   Ax   Ax   Ax   Axv   AxW   Ax8   Ax   Ax   Ax   Ax   Ax   Ax~   Ax_   Ax@   Ax!   Ax   Ax   Ax   Ax   Ax   Axg   AxH   Ax)   Ax
   Ax   Ax   Ax   Ax   Axo   AxP   Ax1   Ax   Ax   Ax   Ax   Ax   Axw   AxX   Ax9   Ax   Ax   Ax   Ax½   Ax   AxA   Ax   AxI   Ax   Ax   Axҏ   Axp   AxQ   Ax2   Ax   Ax   AxY   Ax:   Ax   Ax   Ax   Ax߾   Ax   Ax   Axa   AxB   Ax#   Ax   Ax   Ax   Ax   Ax   Axi   AxJ   Ax+   Ax   Ax   Ax   Ax   Ax   Axq   AxR   Ax3   Ax   Ax   Ax   Ax   Ax   Axy   AxZ   Ax;   Ax   Ax   Ax   Ax   Ax   Ax   Axb   Ay C   Ay$   Ay   Ay   Ay   Ay   Ay   Ayj   AyK   Ay,   Ay	
   Ay	   Ay
   Ay   Ay   Ay
r   AyS   Ay4   Ay   Ay   Ay   Ay   Ay   Ayz   Ay[   Ay<   Ay   Ay   Ay   Ay   Ay   Ay   Ayc   AyD   Ay!   Ay"   Ay#k   Ay$L   Ay%-   Ay&   Ay&   Ay'   Ay(   Ay)   Ay*s   Ay+T   Ay,5   Ay-   Ay-   Ay.   Ay/   Ay0   Ay1{   Ay2\   Ay3=   Ay4   Ay4   Ay5   Ay:E   Ay;&   Ay<   Ay<   Ay=   Ay>   Ay?   Ay@l   AyAM   AyB.   AyC   AyC   AyD   AyE   AyF   AyGt   AyHU   AyI6   AyJ   AyJ   AyK   AyL   AyM   AyN|   AyO]   AyP>   AyQ   AyR    AyR   AyS   AyT   AyU   AyVe   AyWF   AyX'   AyY   AyY   AyZ   Ay[   Ay\   Ay]m   Ay^N   Ay_/   Ay`   Ay`   Aya   Ayb   Ayc   Aydu   AyeV   Ayf7   Ayg   Ayg   Ayh   Ayi   Ayj   Ayk}   Ayl^   Aym?   Ayn    Ayo   Ayo   Ayp   Ayq   Ayr   Aysf   AytG   Ayu(   Ayv	   Ayv   Ayw   Ayx   Ayy   Ayzn   Ay{O   Ay|0   Ay}   Ay}   Ay~   Ay   Ay   Ayv   AyW   Ay8   Ay   Ay   Ay   Ay   Ay   Ay~   Ay_   Ay@   Ay!   Ay   Ay   Ay   Ay   Ay   Ayg   AyH   Ay)   Ay
   Ay   Ay   Ay   Ay   Ayo   AyP   Ay1   Ay   Ay   Ay   Ay   Ay   Ayw   AyX   Ay9   Ay   Ay   Ay   Ay   Ay   Ay   Ay`   AyA   Ay"   Ay   Ay   Ay   Ay   Ay   Ayh   AyI   Ay*   Ay   Ay   Ay   Ay   Ay   Ayp   AyQ   Ay2   Ay   Ay   Ay   Ay   Ay   Ayx   AyY   Ay:   Ay   Ay   Ay   Ay   Ay   Ay   Aya   AyB   Ay#   Ay   AyɈ   Ayi   AyJ   Ay+   Ay   Ay   Ay   Ayϯ   AyА   Ayq   AyR   Ay3   Ay   Ay   Ay   Ayַ   Ayט   Ayy   AyZ   Ay;   Ay   Ay   Ay   Ayݿ   Ayޠ   Ay   Ay   Ay   Ay   Ay   Ayj   AyK   Ay,   Ay
   Ay   Ay   Ay   Ay   Ayr   AyS   Ay4   Ay   Ay   Ay   Ay   Ay   Ayz   Ay[   Ay<   Ay   Ay   Ay   Ay   Ay   Ay   Ayc   AyD   Ay%   Az    Az    Az   Az   Az   Azk   AzL   Az-   Az   Az   Az   Az	   Az
   Azs   AzT   Az
5   Az   Az   Az   Az   Az   Az{   Az\   Az=   Az   Az   Az   Az   Az   Az   Azd   AzE   Az&   Az   Az   Az   Az   Az    Az!l   Az"M   Az#.   Az$   Az$   Az%   Az&   Az'   Az(t   Az)U   Az*6   Az+   Az+   Az,   Az-   Az.   Az/|   Az0]   Az1>   Az2   Az3    Az3   Az4   Az5   Az6   Az:   Az;   Az<   Az=   Az>m   Az?N   Az@/   AzA   AzA   AzB   AzC   AzD   AzEu   AzFV   AzG7   AzH   AzH   AzI   AzJ   AzK   AzL}   AzM^   AzN?   AzO    AzS   AzTf   AzUG   AzV(   AzW	   AzW   AzX   AzY   AzZ   Az[n   Az\O   Az]0   Az^   Az^   Az_   Az`   Aza   Azbv   AzcW   Azd8   Aze   Aze   Azf   Azg   Azh   Azi~   Azj_   Azk@   Azl!   Azm   Azm   Azn   Azo   Azp   Azqg   AzrH   Azs)   Azt
   Azt   Azu   Azv   Azw   Azxo   AzyP   Azz1   Az{   Az{   Az|   Az}   Az~   Azw   AzX   Az9   Az   Az   Az   Az   Az   Az   Az`   AzA   Az"   Az   Az   Az   Az   Az   Azh   Az   Az   Az   Azp   AzQ   Az2   Az   Az   Az   Az   Az   Azx   AzY   Az:   Az   Az   Az   Az   Az   Az   Aza   AzB   Az#   Az   Az   Az   Az   Az   Azi   AzJ   Az+   Az   Az   Az   Az   Az   Azq   AzR   Az3   Az   Az   Az   Az   Az   Azy   AzZ   Az;   Az   Az   Az   Az   Az   Az   Azb   AzC   Az$   Az   Az   Az   Azƨ   Azǉ   Azj   AzK   Az,   Az
   Az   Az   AzͰ   AzΑ   Azr   AzS   Az4   Az   Az   Az   AzԸ   Azՙ   Azz   Az[   Az<   Az   Az   Az   Az   Azܡ   Az݂   Azc   AzD   Az%   Az   Az   Az   Az   Az   Azk   AzL   Az   Az   Azs   AzT   Az5   Az   Az   Az   Az   Az   Az{   Az\   Az=   Az   Az   Az   Az   Az   Az   Azd   AzE   Az&   Az   Az   Az   A{    A{   A{l   A{M   A{.   A{   A{   A{   A{   A{   A{	t   A{
U   A{6   A{   A{   A{
   A{   A{   A{|   A{]   A{>   A{   A{    A{   A{   A{   A{   A{e   A{F   A{'   A{   A{   A{   A{   A{   A{m   A{ N   A{!/   A{"   A{"   A{#   A{$   A{%   A{&u   A{'V   A{(7   A{)   A{)   A{*   A{+   A{,   A{-}   A{.^   A{/?   A{0    A{1   A{1   A{2   A{3   A{4   A{5f   A{6G   A{7(   A{8	   A{8   A{9   A{:   A{;   A{<n   A{=O   A{>0   A{B   A{Cv   A{DW   A{E8   A{F   A{F   A{G   A{H   A{I   A{J~   A{K_   A{L@   A{M!   A{N   A{N   A{O   A{P   A{Q   A{Rg   A{SH   A{T)   A{U
   A{U   A{V   A{W   A{X   A{Yo   A{ZP   A{[1   A{\   A{\   A{]   A{^   A{_   A{`w   A{aX   A{b9   A{c   A{c   A{d   A{e   A{f   A{g   A{h`   A{iA   A{j"   A{k   A{k   A{l   A{m   A{n   A{oh   A{pI   A{q*   A{r   A{r   A{s   A{t   A{u   A{vp   A{wQ   A{x2   A{y   A{y   A{z   A{{   A{|   A{}x   A{~Y   A{:   A{   A{   A{   A{   A{   A{   A{a   A{B   A{#   A{   A{   A{   A{   A{   A{i   A{J   A{+   A{   A{   A{   A{   A{   A{q   A{R   A{3   A{   A{y   A{Z   A{;   A{   A{   A{   A{   A{   A{   A{b   A{C   A{$   A{   A{   A{   A{   A{   A{j   A{K   A{,   A{
   A{   A{   A{   A|1   A|2   A|3g   A|4H   A|5)   A|6
   A|6   A|7   A|8   A|9   A|:o   A|;P   A|<1   A|=   A|=   A|>   A|?   A|@   A|Aw   A|BX   A|JA   A|K"   A|L   A|L   A|M   A|N   A|O   A|Ph   A|QI   A|R*   A|S   A|S   A|T   A|U   A|V   A|Wp   A|XQ   A|Y2   A|Z   A|Z   A|[   A|\   A|]   A|^x   A|_Y   A|`:   A|a   A|a   A|b   A|c   A|d   A|e   A|fa   A|gB   A|h#   A|i   A|i   A|j   A|k   A|l   A|mi   A|nJ   A|o+   A|p   A|p   A|q   A|r   A|s   A|tq   A|uR   A|v3   A|w   A|w   A|x   A|y   A|z   A|{y   A||Z   A|};   A|~   A|   A|b   A|C   A|$   A|   A|   A|   A|   A|   A|j   A|K   A|,   A|
   A|   A|   A|   A|   A|r   A|S   A|4   A|   A|   A|   A|   A|   A|z   A|[   A|<   A|   A|   A|   A|   A|%   A|   A|   A|   A|   A|   A|k   A|L   A|-   A|   A|   A|   A|   A|   A|s   A|T   A|5   A|   A|   A|   A|   A|   A|{   A|\   A|=   A|   A|   A|   A|   A|   A|   A|d   A|E   A|&   A|   A|   A|   A|ª   A|Ë   A|l   A|M   A|.   A|   A|   A|   A|ɲ   A|ʓ   A|t   A|U   A|6   A|   A|   A|   A|к   A|ћ   A||   A|]   A|>   A|   A|    A|   A|   A|أ   A|ل   A|e   A|F   A|'   A|   A|   A|   A|߫   A|   A|m   A|N   A|/   A|   A|   A|   A|   A|   A|u   A|V   A|7   A|   A|   A|   A|   A|   A|}   A|^   A|?   A|    A|   A|   A|   A|   A|	   A|   A|   A|   A|   A|n   A|O   A} 0   A}   A}   A}   A}   A}   A}~   A}
_   A}@   A}   A}   A}g   A}H   A})   A}
   A}   A}   A}   A}   A}o   A}P   A}1   A}   A}   A}   A}    A}!   A}"w   A}#X   A}$9   A}%   A}%   A}&   A}'   A}(   A})   A}*`   A}+A   A},"   A}-   A}-   A}.   A}/   A}0   A}1h   A}2I   A}3*   A}4   A}4   A}5   A}6   A}7   A}8p   A}9Q   A}:2   A};   A};   A}<   A}=   A}>   A}?x   A}@Y   A}A:   A}B   A}B   A}C   A}D   A}E   A}F   A}Ga   A}HB   A}I#   A}J   A}J   A}K   A}L   A}M   A}Q   A}R   A}S   A}T   A}Uq   A}VR   A}W3   A}X   A}X   A}Y   A}Z   A}[   A}\y   A}]Z   A}^;   A}_   A}_   A}`   A}a   A}b   A}g   A}g   A}h   A}i   A}n
   A}n   A}o   A}p   A}q   A}rr   A}sS   A}t4   A}u   A}u   A}v   A}w   A}x   A}yz   A}z[   A}{<   A}|   A}|   A}}   A}~   A}   A}   A}c   A}D   A}%   A}   A}   A}   A}   A}   A}k   A}L   A}-   A}   A}   A}   A}   A}   A}s   A}T   A}5   A}   A}   A}   A}   A}   A}{   A}\   A}=   A}   A}   A}   A}   A}   A}   A}d   A}E   A}&   A}   A}   A}   A}   A}   A}l   A}   A}   A}   A}t   A}U   A}6   A}   A}   A}   A}   A}   A}|   A}]   A}>   A}   A}    A}   A}   A}   A}   A}e   A}F   A}'   A}   A}   A}   A}   A}   A}m   A}N   A}/   A}   A}   A}   A}ǳ   A}Ȕ   A}u   A}V   A}7   A}   A}   A}   A}λ   A}Ϝ   A}}   A}^   A}?   A}    A}   A}   A}   A}֤   A}ׅ   A}f   A}G   A}(   A}	   A}   A}   A}ݬ   A}ލ   A}n   A}O   A}0   A}   A}   A}   A}   A}   A}v   A}W   A}8   A}   A}   A}   A}   A}   A}~   A}_   A}@   A}!   A}   A}   A}   A}   A}   A}g   A}H   A})   A}
   A}   A}   A}   A}   A}o   A}P   A~9   A~   A~   A~   A~   A~	   A~
   A~`   A~A   A~
"   A~   A~   A~   A~   A~   A~h   A~I   A~*   A~   A~   A~   A~   A~   A~p   A~Q   A~2   A~   A~   A~   A~   A~   A~ x   A~!Y   A~":   A~#   A~#   A~$   A~%   A~&   A~'   A~(a   A~)B   A~*#   A~+   A~+   A~,   A~-   A~.   A~/i   A~0J   A~1+   A~2   A~2   A~3   A~4   A~5   A~6q   A~7R   A~83   A~9   A~9   A~:   A~;   A~<   A~=y   A~>Z   A~?;   A~@   A~@   A~A   A~B   A~C   A~D   A~Eb   A~FC   A~G$   A~H   A~H   A~I   A~J   A~K   A~Lj   A~MK   A~N,   A~O
   A~O   A~P   A~Q   A~R   A~Sr   A~TS   A~U4   A~Y   A~Zz   A~[[   A~\<   A~]   A~]   A~^   A~_   A~`   A~a   A~bc   A~cD   A~d%   A~e   A~e   A~f   A~g   A~h   A~ik   A~jL   A~k-   A~l   A~l   A~m   A~n   A~o   A~ps   A~qT   A~r5   A~s   A~s   A~t   A~u   A~v   A~w{   A~x\   A~y=   A~z   A~z   A~{   A~|   A~}   A~~   A~d   A~E   A~&   A~   A~   A~   A~   A~   A~l   A~M   A~.   A~   A~   A~   A~   A~   A~t   A~U   A~6   A~   A~   A~   A~   A~   A~|   A~]   A~>   A~   A~    A~   A~   A~   A~   A~e   A~F   A~'   A~   A~   A~   A~   A~   A~m   A~N   A~/   A~   A~   A~   A~   A~   A~u   A~V   A~7   A~   A~}   A~^   A~?   A~    A~   A~   A~   A~   A~   A~f   A~G   A~(   A~	   A~   A~   A~   A~   A~n   A~O   A~0   A~   A~   A~   A~Ŵ   A~ƕ   A~v   A~W   A~8   A~   A~   A~   A~̼   A~͝   A~~   A~_   A~@   A~!   A~   A~   A~   A~ԥ   A~Ն   A~g   A~H   A~)   A~
   A~   A~   A~1   A~   A~   A~   A~   A~   A~w   A~X   A~9   A~   A~   A~   A~   A~   A~   A~`   A~A   A~"   A~   A~   A~   A~   A~   A~h   A~I   A~*   A~   A~   A~   A~   A~   A~p   A~Q   A~2   A~   A~   A~   A~   A    Ax   AY   A:   A   A   A   A   A   A   A	a   A
B   A#   A   A   A
   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A ;   A!   A!   A"   A#   A$   A%   A&b   A'C   A($   A)   A)   A*   A+   A,   A-j   A.K   A/,   A0
   A0   A1   A2   A3   A4r   A5S   A64   A7   A7   A8   A9   A:   A;z   A<[   A=<   A>   A>   A?   A@   AA   AB   ACc   ADD   AE%   AF   AF   AG   AH   AI   AJk   AKL   AL-   AM   AM   AN   AO   AP   AQs   ART   AS5   AT   AT   AU   AV   AW   AX{   AY\   AZ=   A[   A[   A\   AaE   Ab&   Ac   Ac   Ad   Ae   Af   Agl   AhM   Ai.   Aj   Aj   Ak   Al   Am   Ant   AoU   Ap6   Aq   Aq   Ar   As   At   Au|   Av]   Aw>   Ax   Ay    Ay   Az   A{   A|   A}e   A~F   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   A   A   A   A   Av   AW   A8   A   A   A   A   A!   A   A   A   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   Aõ   AĖ   Aw   AX   A9   A   A   A   Aʽ   A˞   A   A`   AA   A"   A   A   A   AҦ   AӇ   Ah   AI   A*   A   A   A   Aٮ   Aڏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   Aր   Aր   Aր   Aր   Aր   Aրv   AրW   Aր8   Aր   Aր   Aր   Aր   Aր   Aր~   Aր_   Aր@   Aր!   Aր   Aր   Aր   Aր   Aր   Aրg   AրH   Aր)   Aր
   Aր   Aր   Aր   Aր   Aրo   AրP   Aր1   Aր   Aր   Aր   Aր   Aր   Aրw   AրX   Aր9   Aր   Aր   Aր   AրA   Aր"   Aր   Aր   AրI   Aր*   Aր   Aր   Aր   Aր   Aր   Aրp   Aր   Aր   Aր   Aրx   AրY   Aր:   Aր   Aր   Aր   AրȾ   Aրɟ   Aրʀ   Aրa   AրB   Aր#   Aր   Aր   Aր   AրЧ   Aրш   Aրi   AրJ   Aր+   Aր   Aր   Aր   Aրׯ   Aրؐ   Aրq   AրR   Aր3   Aր   Aր   Aր   Aր޷   Aրߘ   Aրy   AրZ   Aր;   Aր   Aր   Aր   Aր   Aր   Aր   Aրb   AրC   Aր$   Aր   Aրj   AրK   Aր,   Aր
   Aր   Aր   Aր   Aր   Aրr   AրS   Aր4   Aր   Aր   Aր   Aր   Aր   Aրz   Aր[   Aր<   Aց-   Aց   Aց   Aց   Aց   Aց   Aցs   AցT   Aց   Aց   Aց{   Aց\   Aց=   Aց   Aց   Aց   Aց   Aց    Aց!   Aց"d   Aց#E   Aց$&   Aց%   Aց%   Aց&   Aց'   Aց(   Aց)l   Aց*M   Aց+.   Aց,   Aց,   Aց-   Aց.   Aց/   Aց0t   Aց1U   Aց26   Aց3   Aց3   Aց4   Aց5   Aց6   Aց7|   Aց;   Aց<   Aց=   Aց>   Aց?e   Aց@F   AցA'   AցB   AցB   AցC   AցD   AցE   AցFm   AցGN   AցH/   AցI   AցI   Aփ4_   Aփ5@   Aփ6!   Aփ7   Aփ7   Aփ8   Aփ9   Aփ:   Aփ;g   Aփ<H   Aփ=)   Aփ>
   Aփ>   Aփ?   Aփ@   AփA   AփBo   AփCP   AփD1   AփE   AփE   AփF   AփG   AփH   AփIw   AփJX   AփK9   AփL   AփL   AփM   AփN   AփO   AփP   AփQ`   AփRA   AփS"   AփT   AփT   AփU   AփV   AփW   AփXh   AփYI   AփZ*   Aփ[   Aփ[   Aփ\   Aփ]   Aփ^   Aփ_p   Aփ`Q   Aփa2   Aփb   Aփb   Aփc   Aփd   Aփe   Aփfx   AփgY   Aփh:   Aփi   Aփi   Aփj   Aփk   Aփl   Aփm   Aփna   AփoB   Aփp#   Aփq   Aփq   Aփr   Aփs   Aփt   Aփui   AփvJ   Aփw+   Aփx   Aփx   Aփy   Aփz   Aփ{   Aփ   Aփ   Aփ   Aփ   Aփy   AփZ   Aփ;   Aփ   Aփ   Aփ   Aփ   Aփ   Aփ   Aփb   AփC   Aփ$   Aփ   Aփ   Aփ   Aփ   Aփ   Aփj   AփK   Aփ,   Aփ
   Aփ   Aփ   Aփ   Aփ   Aփr   AփS   Aփ4   Aփ   Aփ   Aփ   Aփ   Aփ   Aփz   Aփ[   Aփ<   Aփ   Aփ   Aփ   Aփ   Aփ   Aփ   Aփc   AփD   Aփ%   Aփ   Aփ   Aփ   Aփ   Aփ   Aփk   AփL   Aփ-   Aփ   Aփ   Aփ   Aփ   Aփ   Aփs   AփT   Aփ5   Aփ   Aփ   Aփ   Aփ   Aփ   Aփ{   Aփ\   Aփ=   Aփ   Aփ   Aփ   Aփ   Aփâ   Aփă   Aփd   AփE   Aփ&   Aփ   Aփ   Aփ   Aփʪ   Aփˋ   Aփl   AփM   Aփ.   Aփ   Aփ   Aփ   AփѲ   Aփғ   Aփt   Aփ   Aփغ   Aփٛ   Aփ|   Aփ>   Aփ   Aփ    Aփ   Aփ   Aփ   Aփ   Aփe   AփF   Aփ'   Aփ   Aփ   Aփ   Aփ   Aփ   Aփm   AփN   Aփ/   Aփ   Aփ   Aփ   Aփ   Aփ   Aփu   AփV   Aփ7   Aփ   Aփ   Aփ   Aփ   Aփ   Aփ}   Aփ^   Aփ?   Aփ    Aփ   Aփ   Aփ   Aփ   Aփ   Aփf   Aք G   Aք(   Aք	   Aք   Aք   Aք   Aք   Aքn   AքO   Aք0   Aք	   Aք	   Aք
   Aք   Aք   Aք
v   AքW   Aք8   Aք   Aք   Aք   Aք   Aք   Aք~   Aք_   Aք@   Aք!   Aք   Aք   Aք   Aք   Aք   Aքg   AքH   Aք)   Aք
   Aք   Aք    Aք!   Aք"   Aք#o   Aք$P   Aք%1   Aք&   Aք&   Aք'   Aք(   Aք)   Aք*w   Aք+X   Aք/   Aք0   Aք1   Aք2`   Aք3A   Aք4"   Aք5   Aք5   Aք6   Aք7   Aք8   Aք9h   Aք:I   Aք;*   Aք<   Aք<   Aք=   Aք>   Aք?   Aք@p   AքAQ   AքB2   AքC   AքC   AքHY   AքI:   AքJ   AքJ   AքOa   AքPB   AքQ#   AքR   AքY   AքZ   Aք[   Aք\   Aք]q   Aք^R   Aք_3   Aք`   Aք`   Aքa   Aքb   Aքc   Aքdy   AքeZ   Aքf;   Aքg   Aքg   Aքh   Aքi   Aքj   Aքk   Aքlb   AքmC   Aքn$   Aքo   Aքo   Aքp   Aքq   Aքr   Aքsj   AքtK   Aքu,   Aքv
   Aքv   Aքw   Aքx   Aքy   Aքzr   Aք{S   Aք|4   Aք}   Aք}   Aք~   Aք   Aք   Aքz   Aք[   Aք<   Aք   Aք   Aքc   AքD   Aք%   Aք   Aք   Aք   Aք   Aք   Aքk   AքL   Aք   Aք   Aքs   AքT   Aք5   Aք   Aք   Aք   Aք   Aք   Aք{   Aք\   Aք=   Aք   Aք   Aք   Aք   Aք   Aք   Aքd   AքE   Aք&   Aք   Aք   Aք   Aք   Aք   Aքl   Aք   Aք   Aք   Aքt   Aք]   Aք>   Aք   Aք    Aք   Aք   Aք   Aք   Aքe   AքF   Aք'   Aք   Aք   Aք   Aքȫ   AքɌ   Aքm   AքN   Aք/   Aք   Aք   Aք   Aքϳ   AքД   Aքu   AքV   Aք7   Aք   Aք   Aք   Aքֻ   Aքל   Aք}   Aք^   Aք?   Aք    Aք߅   Aքf   AքG   Aք(   Aք	   Aք   Aք   Aք   Aք   Aքn   AքO   Aք0   Aք   Aք   Aք   Aք   Aք   Aքv   AքW   Aք8   Aք   Aք   Aք   Aք   Aք   Aք~   Aք_   Aք@   Aք!   Aք   Aք   Aք   Aք   Aք   Aքg   AքH   Aք)   Aօ 
   Aօ    Aօ   Aօ   Aօ   Aօo   AօP   Aօ1   Aօ   Aօ   Aօ   Aօ	   Aօ
   Aօw   AօX   Aօ
9   Aօ   Aօ   Aօ   Aօ   Aօ   Aօ   Aօ`   AօA   Aօ"   Aօ   Aօ   Aօ   Aօ   Aօ   Aօh   AօI   Aօ*   Aօ   Aօ   Aօ   Aօ   Aօ    Aօ!p   Aօ"Q   Aօ#2   Aօ$   Aօ$   Aօ%   Aօ&   Aօ'   Aօ(x   Aօ)Y   Aօ*:   Aօ+   Aօ+   Aօ,   Aօ-   Aօ.   Aօ/   Aօ0a   Aօ1B   Aօ2#   Aօ3   Aօ3   Aօ4   Aօ5   Aօ6   Aօ7i   Aօ8J   Aօ9+   Aօ:   Aօ:   Aօ;   Aօ<   Aօ=   Aօ>q   Aօ?R   Aօ@3   AօA   AօA   AօB   AօC   AօD   AօEy   AօFZ   AօG;   AօH   AօH   AօI   AօJ   AօK   AօL   AօMb   AօNC   AօO$   AօP   AօP   AօQ   AօR   AօS   AօTj   AօUK   AօV,   AօW
   AօW   AօX   AօY   AօZ   Aօ[r   Aօ\S   Aօ]4   Aօ^   Aօ^   Aօ_   Aօ`   Aօa   Aօbz   Aօc[   Aօd<   Aօe   Aօe   Aօf   Aօh   Aօi   Aօjc   AօkD   Aօl%   Aօm   Aօm   Aօn   Aօo   Aօp   Aօqk   AօrL   Aօs-   Aօt   Aօt   Aօu   Aօv   Aօw   Aօxs   AօyT   Aօz5   Aօ{   Aօ{   Aօ|   Aօ}   Aօ~   Aօ{   Aօ\   Aօ=   Aօ   Aօ   Aօ   Aօ   Aօ   Aօ   Aօd   AօE   Aօ&   Aօ   Aօ   AօM   Aօ.   Aօ   Aօ   Aօ   Aօ   Aօ   Aօt   Aօ   Aօ   Aօ   Aօ|   Aօ]   Aօ>   Aօ   Aօ    Aօ   Aօ   Aօ   Aօ   Aօe   AօF   Aօ'   Aօ   Aօ   Aօ   Aօ   Aօ   AօN   Aօ/   Aօ   Aօ   Aօ   Aօ   Aօ   Aօu   AօV   Aօ7   Aօ   Aօ   Aօ   Aօ   Aօ   Aօ}   Aօ^   Aօ?   Aօ    Aօ   Aօ   Aօ   Aօ   Aօ   Aօf   AօG   Aօ(   Aօ	   Aօ   Aօ   AօƬ   AօǍ   Aօn   AօO   Aօ0   Aօ   Aօ   Aօ   Aօʹ   AօΕ   Aօv   AօW   Aօ8   Aօ   Aօ   Aօ   AօԼ   Aօ՝   Aօ~   Aօ_   Aօ@   Aօ!   Aօ   Aօ   Aօ   Aօܥ   Aօ݆   Aօg   AօH   Aօ)   Aօ
   Aօ   Aօ   Aօ1   Aօ   Aօ   Aօ   Aօ   Aօ   Aօw   AօX   Aօ9   Aօ   Aօ   Aօ   Aօ   Aօ   Aօ   Aօ`   AօA   Aօ"   Aօ   Aօ   Aօ   Aօ   Aօ   Aօh   AօI   Aօ*   Aօ   Aօ   Aօ   Aֆ    Aֆ   Aֆp   AֆQ   Aֆ2   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ	x   Aֆ
Y   Aֆ:   Aֆ   Aֆ   Aֆ
   Aֆ   Aֆ   Aֆ   Aֆa   AֆB   Aֆ#   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆi   AֆJ   Aֆ+   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆq   Aֆ R   Aֆ!3   Aֆ"   Aֆ"   Aֆ#   Aֆ$   Aֆ%   Aֆ&y   Aֆ'Z   Aֆ(;   Aֆ)   Aֆ)   Aֆ*   Aֆ+   Aֆ,   Aֆ-   Aֆ.b   Aֆ/C   Aֆ0$   Aֆ4   Aֆ5j   Aֆ6K   Aֆ7,   Aֆ8
   Aֆ8   Aֆ9   Aֆ:   Aֆ?   Aֆ?   Aֆ@   AֆA   AֆB   AֆCz   AֆD[   AֆE<   AֆF   AֆF   AֆG   AֆH   AֆI   AֆJ   AֆKc   AֆLD   AֆM%   AֆN   AֆN   AֆO   AֆP   AֆQ   AֆRk   AֆSL   AֆT-   AֆU   AֆU   AֆV   AֆW   AֆX   AֆYs   AֆZT   Aֆ[5   Aֆ\   Aֆ\   Aֆ]   Aֆ^   Aֆ_   Aֆ`{   Aֆa\   Aֆe   Aֆf   Aֆg   Aֆhd   AֆiE   Aֆj&   Aֆk   Aֆk   Aֆl   Aֆm   Aֆn   Aֆol   AֆpM   Aֆq.   Aֆr   Aֆr   Aֆs   Aֆt   Aֆu   Aֆvt   AֆwU   Aֆx6   Aֆy   Aֆy   Aֆz   Aֆ{   Aֆ|   Aֆ}|   Aֆ~]   Aֆ>   Aֆ   Aֆ    Aֆ   Aֆ   Aֆ   Aֆ   Aֆe   AֆF   Aֆ'   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆm   AֆN   Aֆ/   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ}   Aֆ^   Aֆ?   Aֆ    Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆf   AֆG   Aֆ(   Aֆ	   Aֆ   Aֆ   Aֆ   Aֆ   Aֆn   AֆO   Aֆ0   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆv   AֆW   Aֆ8   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ~   Aֆ_   Aֆ@   Aֆ!   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆg   AֆH   Aֆ)   Aֆ
   Aֆ   Aֆ   Aֆĭ   AֆŎ   Aֆo   AֆP   Aֆ1   Aֆ   Aֆ   Aֆ   Aֆ˵   Aֆ̖   Aֆw   AֆX   Aֆ9   Aֆ   Aֆ   Aֆ   Aֆҽ   AֆӞ   Aֆ   Aֆ`   AֆA   Aֆ"   Aֆ   Aֆ   Aֆ   Aֆڦ   Aֆۇ   Aֆh   AֆI   Aֆ*   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆp   AֆQ   Aֆ2   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆx   Aֆ   Aֆ   Aֆ   Aֆ   Aֆa   AֆB   Aֆ#   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aֆi   AֆJ   Aֆ+   Aֆ   Aֆ   Aֆ   Aֆ   Aֆ   Aև q   AևR   Aև3   Aև   Aև   Aև   Aև   Aև   Aևy   AևZ   Aև	;   Aև
   Aև
   Aև   Aև   Aև
   Aև   Aևb   AևC   Aև$   Aև   Aև   Aև   Aև   Aև   Aևj   AևK   Aև,   Aև
   Aև   Aև   Aև   Aև   Aևr   AևS   Aև4   Aև    Aև    Aև!   Aև"   Aև#   Aև$z   Aև%[   Aև&<   Aև'   Aև'   Aև(   Aև)   Aև*   Aև+   Aև,c   Aև-D   Aև.%   Aև/   Aև/   Aև0   Aև1   Aև2   Aև3k   Aև4L   Aև5-   Aև6   Aև6   Aև7   Aև8   Aև9   Aև:s   Aև;T   Aև<5   Aև=   Aև=   Aև>   Aև?   Aև@   AևA{   AևB\   AևF   AևG   AևH   AևId   AևJE   AևK&   AևL   AևL   AևQM   AևR.   AևS   AևS   AևT   AևU   AևV   AևWt   AևXU   AևY6   AևZ   AևZ   Aև[   Aև\   Aև]   Aև^|   Aև_]   Aև`>   Aևa   Aևb    Aևb   Aևc   Aևd   Aևe   Aևmm   AևnN   Aևo/   Aևp   Aևp   Aևq   Aևr   Aևs   Aևtu   AևuV   Aևv7   Aևw   Aևw   Aևx   Aևy   Aևz   Aև{}   Aև|^   Aև}?   Aև~    Aև   Aև   Aև   Aև   Aև   Aևf   AևG   Aև(   Aև	   Aև   Aև   Aև   Aև   Aևn   AևO   Aև0   Aև   Aև   Aև   Aև   Aև   Aևv   AևW   Aև8   Aև   Aև   Aև   Aև   Aև   Aև~   Aև_   Aև@   Aև!   Aև   Aև   Aև   Aև   Aև   Aևg   AևH   Aև)   Aև
   Aև   Aև   Aև   Aև   Aևo   AևP   Aև1   Aև   Aև   Aև   Aև   Aև   Aևw   AևX   Aև9   Aև   Aև   Aև   Aև   Aև   Aև   Aև`   AևA   Aև"   Aև   Aև   Aև   Aև   Aև   Aևh   AևI   Aև*   Aև   Aև   Aև   Aև®   AևÏ   Aևp   AևQ   Aև2   Aև   Aև   Aև   Aևɶ   Aևʗ   Aևx   AևY   Aև:   Aև   Aև   Aև   Aևо   Aևџ   AևҀ   Aևa   AևB   Aև#   Aև   Aև   Aև   Aևا   Aևو   Aևi   AևJ   Aև+   Aև   Aև   Aև   Aև߯   Aև   Aևq   AևR   Aև3   Aև   Aև   Aև   Aև   Aև   Aևy   AևZ   Aև;   Aև   Aև   Aև   Aև   Aև   Aև   Aևb   AևC   Aև$   Aև   Aևj   AևK   Aև,   Aև
   Aև   Aև   Aև   Aև   Aևr   AևS   Aֈ 4   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈz   Aֈ[   Aֈ<   Aֈ   Aֈ   Aֈ	   Aֈ
   Aֈ   Aֈ   Aֈ
c   AֈD   Aֈ   Aֈ   Aֈk   AֈL   Aֈ-   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈs   AֈT   Aֈ5   Aֈ   Aֈ   Aֈ   Aֈ    Aֈ!   Aֈ"{   Aֈ#\   Aֈ$=   Aֈ%   Aֈ%   Aֈ&   Aֈ'   Aֈ(   Aֈ)   Aֈ*d   Aֈ+E   Aֈ,&   Aֈ-   Aֈ-   Aֈ.   Aֈ/   Aֈ0   Aֈ1l   Aֈ2M   Aֈ3.   Aֈ4   Aֈ4   Aֈ5   Aֈ6   Aֈ7   Aֈ8t   Aֈ9U   Aֈ:6   Aֈ;   Aֈ;   Aֈ<   Aֈ=   Aֈ>   Aֈ?|   Aֈ@]   AֈA>   AֈB   AֈC    AֈGe   AֈHF   AֈI'   AֈJ   AֈJ   AֈK   AֈL   AֈM   AֈNm   AֈON   AֈP/   AֈQ   AֈQ   AֈR   AֈS   AֈT   AֈUu   AֈVV   AֈW7   AֈX   AֈX   AֈY   AֈZ   Aֈ[   Aֈ\}   Aֈ]^   Aֈ^?   Aֈ_    Aֈ`   Aֈ`   Aֈa   Aֈb   Aֈc   Aֈdf   AֈeG   Aֈf(   Aֈg	   Aֈg   Aֈh   Aֈi   Aֈj   Aֈkn   AֈlO   Aֈm0   Aֈn   Aֈn   Aֈo   Aֈp   Aֈq   Aֈrv   AֈsW   Aֈt8   Aֈu   Aֈu   Aֈv   Aֈw   Aֈx   Aֈy~   Aֈz_   Aֈ{@   Aֈ)   Aֈ
   Aֈ   Aֈ   Aֈ   Aֈ   Aֈo   AֈP   Aֈ1   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈw   AֈX   Aֈ9   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈh   AֈI   Aֈ*   Aֈ   Aֈ   AֈY   Aֈ:   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈq   AֈR   Aֈ3   Aֈ   Aֈ   Aֈ   AֈǷ   AֈȘ   Aֈy   AֈZ   Aֈ;   Aֈ   Aֈ   Aֈ   Aֈο   AֈϠ   AֈЁ   Aֈb   AֈC   Aֈ$   Aֈ   Aֈ   Aֈ   Aֈ֨   Aֈ׉   Aֈj   AֈK   Aֈ,   Aֈ
   Aֈ   Aֈ   Aֈݰ   Aֈޑ   Aֈr   AֈS   Aֈ4   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈz   Aֈ[   Aֈ<   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈc   AֈD   Aֈ%   Aֈ   Aֈ   Aֈ   Aֈ   Aֈ   Aֈk   AֈL   Aֈ-   Aֈ   Aֈ   Aֈ   Aֈ5   Aֈ   Aֈ   A։    A։   A։   A։{   A։\   A։=   A։   A։   A։   A։   A։	   A։
   A։d   A։E   A։
&   A։   A։   A։   A։   A։   A։l   A։M   A։.   A։   A։   A։   A։   A։   A։t   A։U   A։6   A։   A։   A։   A։   A։   A։ |   A։!]   A։">   A։#   A։$    A։$   A։%   A։&   A։'   A։(e   A։)F   A։*'   A։+   A։+   A։,   A։-   A։.   A։/m   A։0N   A։1/   A։2   A։2   A։3   A։4   A։5   A։6u   A։7V   A։87   A։9   A։9   A։:   A։;   A։<   A։=}   A։>^   A։??   A։@    A։A   A։A   A։B   A։C   A։D   A։Ef   A։FG   A։G(   A։H	   A։H   A։I   A։J   A։K   A։Ln   A։MO   A։N0   A։O   A։O   A։P   A։Q   A։R   A։Sv   A։TW   A։U8   A։V   A։V   A։W   A։X   A։Y   A։Z~   A։[_   A։\@   A։]!   A։^   A։^   A։_   A։`   A։a   A։bg   A։cH   A։d)   A։e
   A։e   A։f   A։g   A։h   A։io   A։jP   A։k1   A։l   A։l   A։m   A։n   A։o   A։pw   A։qX   A։r9   A։s   A։s   A։t   A։u   A։v   A։w   A։x`   A։yA   A։z"   A։{   A։{   A։|   A։}   A։~   A։h   A։I   A։*   A։   A։   A։   A։   A։   A։p   A։Q   A։2   A։   A։   A։   A։   A։   A։x   A։Y   A։:   A։   A։   A։   A։   A։   A։   A։i   A։J   A։+   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։   A։j   A։K   A։,   A։
   A։   A։   A։   A։   A։r   A։S   A։4   A։   A։   A։   A։Ÿ   A։ƙ   A։z   A։[   A։<   A։   A։   A։   A։   A։͡   A։΂   A։c   A։D   A։%   A։   A։   A։   A։ԩ   A։Պ   A։k   A։L   A։-   A։   A։   A։   A։۱   A։ܒ   A։s   A։T   A։5   A։   A։   A։   A։   A։   A։{   A։\   A։=   A։   A։   A։   A։   A։   A։   A։d   A։E   A։&   A։   A։   A։   A։   A։   A։l   A։M   A։.   A։   A։   A։   A։   A։   A։t   A։U   A։6   A։   A։   A։   A։   A֊    A֊|   A֊   A֊   A֊   A֊   A֊	e   A֊
F   A֊'   A֊   A֊   A֊
   A֊   A֊   A֊m   A֊N   A֊/   A֊   A֊   A֊   A֊   A֊   A֊u   A֊V   A֊7   A֊   A֊   A֊   A֊   A֊   A֊}   A֊^   A֊ ?   A֊!    A֊"   A֊"   A֊#   A֊$   A֊%   A֊&f   A֊'G   A֊((   A֊)	   A֊)   A֊*   A֊+   A֊,   A֊-n   A֊.O   A֊/0   A֊0   A֊0   A֊1   A֊2   A֊3   A֊4v   A֊5W   A֊68   A֊7   A֊7   A֊8   A֊9   A֊:   A֊;~   A֊<_   A֊=@   A֊>!   A֊?   A֊?   A֊@   A֊A   A֊B   A֊Cg   A֊DH   A֊E)   A֊F
   A֊F   A֊G   A֊H   A֊I   A֊Jo   A֊KP   A֊L1   A֊M   A֊M   A֊N   A֊O   A֊P   A֊Qw   A֊RX   A֊S9   A֊T   A֊T   A֊U   A֊]   A֊^   A֊_   A֊`h   A֊aI   A֊b*   A֊c   A֊c   A֊hQ   A֊i2   A֊j   A֊j   A֊oY   A֊p:   A֊q   A֊q   A֊r   A֊s   A֊t   A֊u   A֊va   A֊wB   A֊x#   A֊y   A֊y   A֊z   A֊{   A֊|   A֊}i   A֊~J   A֊+   A֊   A֊   A֊   A֊   A֊   A֊q   A֊R   A֊3   A֊   A֊   A֊   A֊   A֊   A֊y   A֊Z   A֊;   A֊   A֊   A֊   A֊   A֊   A֊   A֊b   A֊C   A֊$   A֊
   A֊   A֊   A֊   A֊   A֊r   A֊S   A֊4   A֊   A֊   A֊   A֊   A֊   A֊z   A֊[   A֊<   A֊   A֊   A֊   A֊   A֊   A֊   A֊c   A֊D   A֊   A֊   A֊k   A֊L   A֊-   A֊   A֊   A֊   A֊M   A֊.   A֊   A֊   A֊   A֊   A֊   A֊|   A֊]   A֊>   A֊   A֊    A֊   A֊   A֊   A֊   A֊e   A֊F   A֊'   A֊   A֊   A֊   A֊   A֊   A֊m   A֊N   A֊/   A֊   A֊   A֊   A֊   A֊   A֊u   A֊V   A֊7   A֊   A֊   A֊   A֊   A֊   A֊}   A֋ ^   A֋?   A֋    A֋   A֋   A֋   A֋   A֋   A֋f   A֋G   A֋	(   A֋
   A֋n   A֋O   A֋0   A֋   A֋   A֋   A֋   A֋   A֋v   A֋W   A֋8   A֋   A֋   A֋   A֋   A֋   A֋~   A֋_   A֋@   A֋!   A֋    A֋    A֋!   A֋"   A֋#   A֋$g   A֋%H   A֋&)   A֋'
   A֋'   A֋(   A֋)   A֋*   A֋+o   A֋,P   A֋-1   A֋.   A֋.   A֋/   A֋0   A֋1   A֋2w   A֋3X   A֋49   A֋5   A֋5   A֋6   A֋7   A֋8   A֋9   A֋:`   A֋;A   A֋<"   A֋=   A֋=   A֋>   A֋?   A֋@   A֋Ah   A֋BI   A֋C*   A֋D   A֋D   A֋E   A֋F   A֋G   A֋Hp   A֋IQ   A֋J2   A֋K   A֋K   A֋L   A֋M   A֋N   A֋Ox   A֋PY   A֋Q:   A֋R   A֋R   A֋S   A֋T   A֋U   A֋V   A֋Wa   A֋XB   A֋Y#   A֋Z   A֋Z   A֋[   A֋\   A֋]   A֋h   A֋i   A֋j   A֋k   A֋s   A֋tb   A֋uC   A֋v$   A֋w   A֋w   A֋x   A֋y   A֋z   A֋{j   A֋|K   A֋},   A֋~
   A֋~   A֋   A֋   A֋   A֋r   A֋S   A֋4   A֋   A֋   A֋   A֋   A֋   A֋z   A֋[   A֋<   A֋   A֋   A֋   A֋   A֋   A֋   A֋c   A֋D   A֋%   A֋   A֋   A֋   A֋   A֋   A֋{   A֋\   A֋=   A֋   A֋   A֋   A֋   A֋   A֋   A֋d   A֋E   A֋&   A֋   A֋   A֋   A֋   A֋   A֋l   A֋M   A֋.   A֋   A֋   A֋U   A֋6   A֋   A֋   A֋   A֋   A֋   A֋|   A֋]   A֋>   A֋   A֋    A֋   A֋   A֋ɣ   A֋ʄ   A֋e   A֋F   A֋'   A֋   A֋   A֋   A֋Ы   A֋ь   A֋m   A֋N   A֋/   A֋   A֋   A֋   A֋׳   A֋ؔ   A֋   A֋   A֋޻   A֋ߜ   A֋}   A֋^   A֋?   A֋    A֋   A֋   A֋   A֋   A֋	   A֋   A֋   A֋   A֋   A֋n   A֋O   A֋0   A֋   A֋   A֋   A֋   A֋   A֋v   A֋W   A֋8   A֋   A֋   A֋   A֋   A֋   A֋~   A֋_   A֋@   A֌ !   A֌   A֌   A֌   A֌   A֌   A֌g   A֌H   A֌)   A֌
   A֌   A֌	   A֌
   A֌   A֌o   A֌
P   A֌1   A֌   A֌   A֌   A֌9   A֌   A֌   A֌   A֌   A֌   A֌   A֌`   A֌A   A֌"   A֌   A֌   A֌   A֌    A֌!   A֌"h   A֌#I   A֌$*   A֌%   A֌%   A֌&   A֌'   A֌(   A֌)p   A֌*Q   A֌+2   A֌,   A֌,   A֌-   A֌.   A֌/   A֌0x   A֌1Y   A֌2:   A֌3   A֌3   A֌4   A֌5   A֌6   A֌7   A֌8a   A֌9B   A֌:#   A֌;   A֌;   A֌<   A֌=   A֌>   A֌?i   A֌@J   A֌A+   A֌B   A֌B   A֌C   A֌D   A֌E   A֌Fq   A֌GR   A֌H3   A֌I   A֌I   A֌J   A֌K   A֌L   A֌My   A֌NZ   A֌O;   A֌P   A֌P   A֌Q   A֌R   A֌S   A֌T   A֌Ub   A֌VC   A֌W$   A֌X   A֌X   A֌Y   A֌Z   A֌[   A֌\j   A֌]K   A֌^,   A֌_
   A֌_   A֌`   A֌a   A֌b   A֌cr   A֌dS   A֌e4   A֌f   A֌f   A֌g   A֌h   A֌m   A֌m   A֌n   A֌o   A֌p   A֌q   A֌rc   A֌sD   A֌t%   A֌u   A֌u   A֌v   A֌w   A֌x   A֌yk   A֌zL   A֌{-   A֌|   A֌|   A֌}   A֌~   A֌   A֌s   A֌T   A֌5   A֌   A֌   A֌   A֌   A֌   A֌{   A֌\   A֌=   A֌   A֌   A֌   A֌   A֌   A֌   A֌d   A֌E   A֌&   A֌   A֌   A֌   A֌   A֌   A֌}   A֌^   A֌?   A֌    A֌   A֌   A֌   A֌Ǥ   A֌ȅ   A֌f   A֌G   A֌(   A֌	   A֌   A֌   A֌ά   A֌ύ   A֌n   A֌O   A֌0   A֌   A֌   A֌   A֌մ   A֌֕   A֌v   A֌W   A֌8   A֌   A֌   A֌   A֌ܼ   A֌ݝ   A֌~   A֌_   A֌@   A֌!   A֌   A֌   A֌   A֌   A֌   A֌g   A֌H   A֌)   A֌
   A֌   A֌   A֌   A֌   A֌o   A֌P   A֌1   A֌   A֌   A֌   A֌   A֌   A֌w   A֌X   A֌9   A֌   A֌   A֌   A֌   A֌   A֌   A֌`   A֌A   A֌"   A֌   A֌   A֍    A֍   A֍   A֍h   A֍I   A֍*   A֍   A֍   A֍Q   A֍2   A֍
   A֍
   A֍   A֍   A֍   A֍x   A֍Y   A֍:   A֍   A֍   A֍   A֍   A֍   A֍   A֍#   A֍$   A֍%   A֍&   A֍'q   A֍(R   A֍)3   A֍*   A֍.y   A֍/Z   A֍0;   A֍1   A֍1   A֍2   A֍3   A֍4   A֍5   A֍6b   A֍7C   A֍8$   A֍9   A֍9   A֍:   A֍;   A֍<   A֍=j   A֍>K   A֍?,   A֍@
   A֍@   A֍A   A֍B   A֍C   A֍Dr   A֍ES   A֍F4   A֍G   A֍G   A֍H   A֍I   A֍J   A֍Kz   A֍L[   A֍M<   A֍N   A֍N   A֍O   A֍P   A֍Q   A֍R   A֍Sc   A֍TD   A֍U%   A֍V   A֍V   A֍W   A֍X   A֍Y   A֍Zk   A֍[L   A֍\-   A֍]   A֍]   A֍^   A֍_   A֍`   A֍as   A֍bT   A֍j=   A֍k   A֍k   A֍l   A֍m   A֍n   A֍o   A֍pd   A֍t   A֍u   A֍v   A֍wl   A֍xM   A֍y.   A֍z   A֍z   A֍{   A֍|   A֍}   A֍~t   A֍U   A֍6   A֍   A֍   A֍   A֍   A֍   A֍|   A֍]   A֍>   A֍   A֍    A֍   A֍   A֍   A֍   A֍e   A֍F   A֍'   A֍   A֍   A֍   A֍   A֍   A֍m   A֍N   A֍/   A֍   A֍   A֍   A֍   A֍   A֍u   A֍V   A֍7   A֍   A֍   A֍   A֍   A֍   A֍}   A֍^   A֍?   A֍    A֍   A֍   A֍   A֍   A֍   A֍f   A֍G   A֍(   A֍   A֍   A֍   A֍   A֍   A֍v   A֍W   A֍8   A֍   A֍   A֍   A֍   A֍   A֍~   A֍_   A֍@   A֍!   A֍   A֍   A֍   A֍ť   A֍Ɔ   A֍g   A֍H   A֍̭   A֍͎   A֍o   A֍P   A֍1   A֍   A֍   A֍   A֍ӵ   A֍Ԗ   A֍w   A֍X   A֍9   A֍   A֍   A֍   A֍ڽ   A֍۞   A֍   A֍`   A֍A   A֍"   A֍   A֍   A֍   A֍   A֍   A֍h   A֍I   A֍*   A֍   A֍   A֍   A֍   A֍   A֍p   A֍Q   A֍2   A֍   A֍   A֍   A֍   A֍   A֍x   A֍Y   A֍:   A֍   A֍   A֍   A֍   A֍   A֍   A֍a   A֍B   A֍#   A֍   A֍   A֍   A֍   A֎    A֎i   A֎J   A֎+   A֎   A֎   A֎   A֎   A֎   A֎q   A֎	R   A֎
3   A֎   A֎   A֎   A֎
   A֎   A֎y   A֎Z   A֎;   A֎   A֎   A֎   A֎   A֎   A֎   A֎b   A֎C   A֎$   A֎   A֎   A֎   A֎   A֎   A֎j   A֎K   A֎ ,   A֎$   A֎%r   A֎&S   A֎'4   A֎(   A֎(   A֎)   A֎*   A֎+   A֎,z   A֎-[   A֎.<   A֎2   A֎3   A֎4c   A֎5D   A֎6%   A֎7   A֎7   A֎8   A֎9   A֎:   A֎;k   A֎<L   A֎=-   A֎>   A֎>   A֎?   A֎@   A֎A   A֎Bs   A֎CT   A֎D5   A֎E   A֎E   A֎F   A֎G   A֎H   A֎I{   A֎J\   A֎K=   A֎L   A֎L   A֎M   A֎N   A֎O   A֎P   A֎Qd   A֎RE   A֎S&   A֎T   A֎T   A֎U   A֎V   A֎W   A֎Xl   A֎YM   A֎Z.   A֎[   A֎[   A֎c   A֎d   A֎e   A֎f|   A֎g]   A֎h>   A֎i   A֎j    A֎j   A֎k   A֎l   A֎m   A֎ne   A֎oF   A֎p'   A֎q   A֎q   A֎r   A֎s   A֎t   A֎|u   A֎}V   A֎~7   A֎   A֎   A֎   A֎   A֎   A֎}   A֎^   A֎?   A֎    A֎   A֎   A֎   A֎   A֎   A֎f   A֎G   A֎(   A֎	   A֎   A֎   A֎   A֎   A֎n   A֎O   A֎0   A֎   A֎   A֎   A֎   A֎   A֎v   A֎W   A֎8   A֎   A֎   A֎   A֎   A֎   A֎~   A֎_   A֎@   A֎!   A֎   A֎   A֎   A֎   A֎   A֎g   A֎H   A֎
   A֎   A֎   A֎   A֎   A֎o   A֎P   A֎1   A֎   A֎   A֎   A֎   A֎   A֎w   A֎X   A֎9   A֎   A֎   A֎   A֎   A֎   A֎   A֎`   A֎A   A֎"   A֎   A֎   A֎   A֎æ   A֎ć   A֎h   A֎I   A֎*   A֎   A֎   A֎   A֎ʮ   A֎ˏ   A֎p   A֎Q   A֎2   A֎   A֎   A֎   A֎Ѷ   A֎җ   A֎x   A֎Y   A֎:   A֎   A֎   A֎   A֎ؾ   A֎ٟ   A֎ڀ   A֎a   A֎B   A֎#   A֎   A֎   A֎   A֎   A֎   A֎i   A֎J   A֎+   A֎   A֎   A֎   A֎   A֎   A֎q   A֎R   A֎3   A֎   A֎   A֎   A֎   A֎   A֎y   A֎Z   A֎;   A֎   A֎   A֎   A֎   A֎   A֎   A֎b   A֎C   A֎$   A֎   A֎   A֎   A֎   A֏
   A֏   A֏   A֏   A֏   A֏r   A֏S   A֏4   A֏	   A֏	   A֏
   A֏   A֏   A֏
z   A֏[   A֏<   A֏   A֏   A֏   A֏   A֏   A֏   A֏c   A֏D   A֏%   A֏   A֏   A֏   A֏   A֏   A֏k   A֏L   A֏-   A֏   A֏   A֏    A֏!   A֏"   A֏#s   A֏$T   A֏+\   A֏/   A֏0   A֏1   A֏2d   A֏3E   A֏4&   A֏5   A֏5   A֏6   A֏7   A֏8   A֏9l   A֏:M   A֏;.   A֏<   A֏<   A֏=   A֏>   A֏?   A֏@t   A֏AU   A֏B6   A֏C   A֏C   A֏D   A֏E   A֏F   A֏G|   A֏H]   A֏I>   A֏J   A֏K    A֏K   A֏L   A֏M   A֏N   A֏Oe   A֏PF   A֏Q'   A֏R   A֏R   A֏S   A֏T   A֏U   A֏Vm   A֏WN   A֏X/   A֏Y   A֏Y   A֏Z   A֏[   A֏\   A֏h   A֏h   A֏i   A֏j   A֏k   A֏lf   A֏mG   A֏n(   A֏o	   A֏o   A֏p   A֏q   A֏r   A֏sn   A֏tO   A֏u0   A֏v   A֏v   A֏w   A֏x   A֏y   A֏zv   A֏{W   A֏|8   A֏}   A֏}   A֏~   A֏   A֏)   A֏
   A֏   A֏   A֏   A֏   A֏o   A֏P   A֏1   A֏   A֏   A֏   A֏9   A֏   A֏   A֏   A֏   A֏   A֏   A֏`   A֏   A֏   A֏   A֏h   A֏I   A֏*   A֏   A֏   A֏   A֏   A֏   A֏p   A֏Q   A֏2   A֏   A֏   A֏   A֏   A֏   A֏x   A֏Y   A֏:   A֏   A֏   A֏   A֏   A֏   A֏   A֏   A֏   A֏   A֏   A֏i   A֏J   A֏+   A֏   A֏   A֏   A֏ȯ   A֏ɐ   A֏q   A֏R   A֏3   A֏   A֏   A֏   A֏Ϸ   A֏И   A֏y   A֏Z   A֏;   A֏   A֏   A֏   A֏ֿ   A֏נ   A֏   A֏   A֏   A֏ި   A֏߉   A֏j   A֏K   A֏,   A֏
   A֏   A֏   A֏   A֏   A֏r   A֏S   A֏4   A֏   A֏   A֏   A֏   A֏   A֏   A֏c   A֏D   A֏%   A֏   A֏   A֏   A֏   A֏   A֏k   A֏L   A֏-   A֐    A֐    A֐   A֐   A֐   A֐s   A֐T   A֐5   A֐   A֐   A֐   A֐	   A֐
   A֐{   A֐\   A֐
=   A֐   A֐   A֐   A֐   A֐   A֐   A֐d   A֐E   A֐&   A֐   A֐   A֐   A֐   A֐   A֐l   A֐M   A֐.   A֐   A֐   A֐   A֐   A֐    A֐!t   A֐"U   A֐#6   A֐$   A֐$   A֐%   A֐&   A֐'   A֐(|   A֐)]   A֐*>   A֐+   A֐,    A֐,   A֐-   A֐.   A֐/   A֐:   A֐;   A֐<   A֐=   A֐>u   A֐?V   A֐@7   A֐A   A֐A   A֐B   A֐C   A֐D   A֐E}   A֐F^   A֐G?   A֐H    A֐I   A֐I   A֐J   A֐K   A֐L   A֐Mf   A֐NG   A֐O(   A֐P	   A֐P   A֐Q   A֐R   A֐S   A֐Tn   A֐UO   A֐V0   A֐W   A֐X   A֐Y   A֐Z   A֐[v   A֐\W   A֐]8   A֐a   A֐b~   A֐c_   A֐d@   A֐e!   A֐f   A֐f   A֐g   A֐h   A֐i   A֐jg   A֐kH   A֐l)   A֐m
   A֐m   A֐n   A֐o   A֐p   A֐qo   A֐rP   A֐s1   A֐t   A֐t   A֐u   A֐v   A֐w   A֐xw   A֐yX   A֐z9   A֐{   A֐{   A֐|   A֐}   A֐~   A֐   A֐`   A֐A   A֐"   A֐   A֐   A֐   A֐   A֐   A֐h   A֐   A֐   A֐   A֐p   A֐Q   A֐2   A֐   A֐   A֐   A֐   A֐   A֐x   A֐Y   A֐:   A֐   A֐   A֐   A֐   A֐   A֐   A֐a   A֐B   A֐#   A֐   A֐   A֐   A֐   A֐   A֐i   A֐J   A֐+   A֐   A֐   A֐   A֐   A֐   A֐q   A֐R   A֐3   A֐   A֐   A֐   A֐   A֐   A֐y   A֐Z   A֐;   A֐   A֐   A֐   A֐   A֐   A֐   A֐b   A֐C   A֐$   A֐   A֐   A֐   A֐   A֐   A֐j   A֐K   A֐,   A֐
   A֐   A֐   A֐ư   A֐Ǒ   A֐r   A֐S   A֐4   A֐   A֐   A֐   A֐͸   A֐Ι   A֐z   A֐[   A֐<   A֐   A֐   A֐   A֐   A֐ա   A֐ւ   A֐c   A֐D   A֐%   A֐   A֐   A֐   A֐   A֐   A֐s   A֐T   A֐   A֐   A֐{   A֐\   A֐=   A֐   A֐   A֐   A֐   A֐   A֐   A֐d   A֐E   A֐&   A֐   A֐   A֐   A֐   A֐   A֐l   A֐M   A֐.   A֐   A֐   A֐   A֑    A֑   A֑t   A֑U   A֑6   A֑   A֑   A֑   A֑   A֑   A֑	|   A֑
]   A֑>   A֑   A֑
    A֑
   A֑   A֑   A֑   A֑e   A֑F   A֑'   A֑   A֑   A֑   A֑   A֑   A֑m   A֑N   A֑/   A֑   A֑   A֑   A֑   A֑   A֑u   A֑ V   A֑!7   A֑"   A֑"   A֑#   A֑$   A֑%   A֑&}   A֑'^   A֑(?   A֑)    A֑*   A֑*   A֑+   A֑,   A֑-   A֑.f   A֑/G   A֑0(   A֑1	   A֑1   A֑2   A֑3   A֑4   A֑5n   A֑6O   A֑70   A֑8   A֑8   A֑9   A֑:   A֑;   A֑<v   A֑=W   A֑>8   A֑?   A֑?   A֑@   A֑A   A֑C~   A֑D_   A֑E@   A֑F!   A֑G   A֑G   A֑H   A֑I   A֑J   A֑Kg   A֑LH   A֑M)   A֑N
   A֑N   A֑O   A֑P   A֑Q   A֑Ro   A֑SP   A֑T1   A֑U   A֑U   A֑V   A֑W   A֑X   A֑Yw   A֑ZX   A֑[9   A֑\   A֑\   A֑]   A֑^   A֑_   A֑`   A֑a`   A֑bA   A֑c"   A֑d   A֑d   A֑e   A֑f   A֑g   A֑hh   A֑iI   A֑j*   A֑k   A֑k   A֑l   A֑m   A֑n   A֑op   A֑pQ   A֑q2   A֑r   A֑r   A֑s   A֑t   A֑u   A֑vx   A֑wY   A֑x:   A֑y   A֑y   A֑z   A֑{   A֑|   A֑}   A֑~a   A֑B   A֑#   A֑   A֑   A֑   A֑   A֑   A֑i   A֑J   A֑+   A֑   A֑   A֑   A֑   A֑   A֑q   A֑R   A֑3   A֑   A֑   A֑   A֑   A֑   A֑y   A֑Z   A֑;   A֑   A֑   A֑   A֑   A֑   A֑   A֑b   A֑C   A֑$   A֑   A֑   A֑   A֑   A֑   A֑j   A֑K   A֑,   A֑
   A֑   A֑   A֑   A֑   A֑r   A֑S   A֑4   A֑   A֑   A֑   A֑   A֑   A֑z   A֑[   A֑<   A֑   A֑   A֑   A֑   A֑   A֑   A֑c   A֑D   A֑   A֑   A֑   A֑   A֑   A֑k   A֑L   A֑-   A֑   A֑   A֑   A֑ı   A֑s   A֑T   A֑5   A֑   A֑   A֑   A֑˹   A֑̚   A֑{   A֑\   A֑=   A֑   A֑   A֑   A֑   A֑Ӣ   A֑ԃ   A֑d   A֑E   A֑&   A֑   A֑   A֑   A֑ڪ   A֑ۋ   A֑l   A֑M   A֑.   A֑   A֑   A֑   A֑   A֑   A֑t   A֑U   A֑6   A֑   A֑   A֑]   A֑>   A֑   A֑    A֑   A֑   A֑   A֑   A֑e   A֑F   A֑'   A֑   A֑   A֑   A֑   A֑   A֑m   A֑N   A֑/   A֑   A֑   A֑   A֑   A֑   A֒ u   A֒V   A֒7   A֒   A֒   A֒   A֒   A֒   A֒}   A֒^   A֒	?   A֒
    A֒   A֒   A֒   A֒
   A֒   A֒f   A֒G   A֒(   A֒	   A֒   A֒   A֒   A֒   A֒n   A֒O   A֒0   A֒   A֒   A֒   A֒   A֒    A֒    A֒!   A֒"   A֒#   A֒$~   A֒%_   A֒&@   A֒'!   A֒(   A֒(   A֒)   A֒*   A֒+   A֒,g   A֒-H   A֒.)   A֒/
   A֒/   A֒0   A֒1   A֒2   A֒3o   A֒4P   A֒51   A֒6   A֒6   A֒7   A֒8   A֒9   A֒:w   A֒;X   A֒<9   A֒=   A֒=   A֒>   A֒CA   A֒D"   A֒E   A֒E   A֒F   A֒G   A֒H   A֒Ih   A֒JI   A֒K*   A֒L   A֒L   A֒M   A֒N   A֒O   A֒Pp   A֒QQ   A֒R2   A֒S   A֒S   A֒T   A֒U   A֒V   A֒Wx   A֒XY   A֒Y:   A֒Z   A֒Z   A֒[   A֒\   A֒]   AAAffA£AzA¸RAzA(A{A{AGA{A\)AQA£AAAAA  A(A(A\A
AQAA33AAzA£AAHA=qAffA(A(A
AAARA\A{AQAAQAffA\ApAzA£AAGAAAAAAARA\AApAGAQAAA
ApA33AAA
=A  AAQApAAAGApAffA=qA33AAA=qAA
=ApA  AffAzAA{AGAA(A
AGAAQAA\)ApAAApA33A=qAGA\ApAA=qA  A
AAAzAHAAA(AAGAAAAA{AQAA
A=qAAGAHA\AAAGA\)A  AAHA{AffAQAAA\A
A
AGA(A\)A33AAAARAAA
A
A{AAQAAAAA
ApA
AAAA{AQA\)AHAAARAA\)AGARAARApA\)AA=qA\ApAHA
=AAA=qA\)AAAAAA\AAA
AA  A
AAAGA  AARAQA\AAAffARAQAAAA(A\)A
=A  AA(ARAAA\)A(A  A  A  A(A
AAzAA\)AAAApAAA\ARAAA=qAAAGA(A
=AQAAffAA
A=qAARAAARARAHA
=AHAA  AA=qAQA=qA(A\)A\AAARAA
=AHARAA=qA(A33A  ApAHAGAA  ARAAAzA  A33A
=AAffA
=AHA  A(AA  A  AA=qAffA(A(AA=qAA(AA  A33A
=AAGA=qA=qA\AA\)AA{AAAAA{AA\A(AAzAARARAGAHA\)ARA  AQA33A=qAA{AzAAzA
=A\)AAHAA\A\)A\)ApA=qA{AQA  ApAA{A=qA33A
AARAGA(AA\)A\)AAA\AApApA33ApApA33AGA  A\)A
A=qA{AQAAAA{AAAQAGA\AA{AAA{AAApAQA{AAAGAAAAAffA{AARAAAA=qAffA  ApAAAA\)A  AffAHAAAzA
A=qARA
=A33A
=AHAffA{A
AA33A(A
=ApAAffAzAA33AAAApAAA\)ApAAA¸RA
AzA
AAA{A33AA  A
AAAAARAffAAzA\A\)AHAAAARAQA\)AA\AA(A{AA  AA\A\)AA  AA=qAA
=AA{A(AHAA{AAA=qA\ARAAAA
AzARAAAAA=qA{A
AA{A33A(A33A\)AzAGAzA
A  AAHAHA\)AA{A\)AffAA
AHApAAA33A\)A=qA
=A
=AAAAffA33ApAA(A
A\A33A  ApA(AApA
=AA33A\)AHAHAAAA(A\A33AzAAAA(A\)AA(AzA\AAA
A\AAzAAAA{AA(AQA
A
AAAApAApAGA
=ARAA
A\AAHARA33A(AA
AHARA\A(AAffA  AAzAAAAAA\A  A\AAA\AffAAAARAQA{A
A
=AAQAA
=A\)A
=AAAAAQA=qAAAQAA\A{A\AffAA{A=qAA
=AffApA=qARARAA\ApARAAffA\AAffA\)ApAQApA33A
=AzAGA
=AQAAARAAAQAAQAA\AffAGA
=AAAA{ApA{A£AA£AAA{AAAA{AAffA33AA
AARAQAA=qAAAQAAA{AffAzA(ARAAAAHA=qA=qAAAGAAAA=qA(AGA33A\)AAARA
=AAARAzAA{AAAAA=qAA\)AQAHAzAffARAARAARAA  A{AAA  A{AA=qAA{AA{AAAA=qA=qAA\)ARAA=qA
A{AAA33AAQAA=qAGA{A(AGAHAAAA  AHAAAARA(AAAAQAQA(AHAGAA=qA
=AzApA{AHAARAA\AA\)A
=ApAApAffAAARA
A33AHAHA
=A(AffAA33AAA(A33AA{A\AAHAAzAQA=qAAA
=A{A
=AAHARA  AAAA33A
=AAHAAHAîAQAAAAA\AAffA
=A\)A33A
=ARAQA\)AAA\A  AAAffA=qAAzAQAzA\AAA33AAQAAAA  A
AA
A
=AA
A\)AA  AzA
=ApAAHAA
A=qAA=qA(AzA
=A\)AA=qAzAAGAAď\AA\)A
AAffA  A{AA
AHA  A  A33AAQAA=qA33AzA(A¸RAAAAAģAď\AĸRAffAQA  AA  AAÅA
AA
=AHAAĸRA33A=qA¸RA\A£A¸RAA{A{A(AAAAffA  AAzA  A=qAA
=AAzA  AAzAAHAGAAQA=qAzAA{A
AAAAAHAzAAAA¸RAA\)A
A  AffAģA
=AŅA
A  AƏ\AƣAzAffAƏ\AƣA
=AǅAǅAGA(AǅAAQA
A=qAQA  A  AAQA(A  A  AA
=A
=A{A=qAģA33ApApA¸RA
AÅA¸RAA
=A=qAîAîAÅAA
=AA33AA
A\)AA33AAAAQA  AQA33A\ARA33AA\)AAGAAA=qA=qAzAA
=A  AQAAA=qA
=AA\)A
=AQAHAA
=AA
=AA(AAAAAzAĸRAHA
=AA
A\)A{AffAȣA{A=qA\)AHAA{AQAAǙAǙAǮAǮA{AzA=qA
AGAA
=AAAA  A\)A{AÙA
ApAQAQApAA=qAAAÙA
=AÙAffAAĸRA{A(AAQAQAGA\AA
A33A\A{AApA=qAzAAAď\AAQAA33A(AHAA(AAAzA33AAHAA
=A{A=qA
A{A(AHA=qA(A=qA=qARAHAA(A¸RApApAAAAA33A33AA{A{AQAĸRA¸RA¸RA{AAAQAGAAAAA
AGA=qAffAzA=qAAffA(AAA
A(AHAA
A(A{A=qA(A\AA
A  A=qA(A¸RAAzAAHA\AffAQA(AffApAQA{A
AGAA\A
A  AApA
=AAARAA=qAffAzAAAA=qA\AAA{AAAffAAAA33AQAGAffAĸRAA
=A\)A=qA33A{AQAA\)A
=AGAĸRAHAQA\A\A33A
A(AAAzAQA  A\)AA\)AffAHA33A
=AA  A
AA\)AÅA=qAQAffAzAAffAHARAGAA
A{A(A
A\)ARAAA(AA  AffAA33AAAARAQAGAA(AzAffAzA33AAQA=qAApAA\)AAzAQA=qAAÙA
=A¸RA¸RAAĸRAÙAÅA
A¸RAAģA
A  AA\)ApApAAHAQApAAffA33A33AGAAA=qAAA
A\)AA(A{A\AAGAARA\ARA\A\)A{AAAffA(AAA\)AAGA\ARA
A\AA£A{AAQA
AAA(A33AAA\)AzAA\A  A=qAAAQAQAzAQAzA¸RAA£AAQAHAQA(AQAffA33A¸RAffA(A
=Aď\AŅAA{A{AzAƏ\AƣAƣAƸRAAƸRAffA(AHAAA{AA  AGA(A  AA
AQAîA
=AģAzAffAA
=A33AA\)A  A(AffA\A\)A\A
AAzAffAAAGAQAGAAAď\A=qAffAA
AA
AQA
A  A  AffA  AÅAÙAA=qAGAAƣAApAǮA=qA  A(A{A\)AGAǮAƸRAƏ\AA
ApAƸRA
=A{A=qAQAAApAŮAAzAÙA(AA
A=qA\)A\)AQA=qAQA{A£A\AzAAA
=A  A
=A
=A\A=qAffA{AA\AffA=qAQA£A£ApAAîAAAAîAÙA=qA  A{AîAAAffAQA{AA33A  A
=AA
AA(AQAGA=qAAApAGAAAAA
AAAQAAAGAAAAffARAA
=AAA  AQA{A{AA
=A
=A33AAQA=qA33A=qA(AAQA  A33ApAA\AAGA33AAAzA  AARAA\)ApApAA(A\A£A¸RA{AA
AAAAA\A
=AGAffAffAAAA{AA=qAAAzAAAffAA(AA\AA\)AAA33AzAAApA
=A
=AAAA=qA\A{AA33A  A\)A33AQAGAARA\)A
=ApA(AA  A\AAA\AQA
AQAQA
A\)AGAA
=A\ApA{ApA\)AAGAAAAA\)A
=AAAA
ARAAA=qA=qA(AA(A
=AA  A
=AA\AffApA33AAAzA=qAAGAHA(AA\)AAAA
AHA  AGAAAA\AAzA{AAA\)AffA
A  AHAA(A
A  AAAAQAAffA\AGA=qA
=AGAAHA
=AHA\AQA\AA33AQAAAzAARA=qA\)AAA
A=qA\)AAAA
=A=qAAHA\ApA  AApA\)A
=AGAGAAA  A
ApAA  A  A{A=qAAAGAGA33AGAHAAAQAQAHAzAzARAzA
=A
A\)AGAApAAAAzA(ARAA\ARAA(A{AAA\)AApAQAA\ARA  AAQAGA{A=qA\)A
AQA
AGAAAHAAA
A\)ARAHA\)AA  ApAAAAA=qAA=qAARApAAffA(A  AAzAAA
AA  AA
=A{AffAQAA  AA\)ApA33A
=AA{AA\AQARApAA{AHAA(AAA(A\A\)A=qA{AA=qAffAHApA33A{A33AARA  AAA
=AAAA
A\AAAARAGAGA  A{A\)AAGAAAA(AA33AAAApA\)A\)ApAA
=A\A\)AA
AAAHAAzAffAAAAQAGApAAQAzApAzAHA
=AGA
=A=qAzAAAzAA\A\)AA33AHAA(AA
=A
=AA
A(AAApAGA33A
=AA(AQAQAA  AGAAARAAffA(AffARAA\)AQAQAffAQA(AQA\)AGA  AGAA
=AzAffA
AQA\AAA33ApAApAARAAA33ARAHAAAA{A33AApAQA=qARA33AffA
AAAApAAAzA  AGA  A  A{AGAAAARAARAAAA\AA
=AA{AAAQA=qAA  AQAAAAAAAzAGA\)A  A
AAApA\)AA  A
AA(AQAApAA  AAA  AzA\A(AA
=A
A\AQA(AAA{AAAffAARAQA(A{AA{A
=AGA\ApA(AAAA(AARA
AffAffA\)A
A  AzAQA  AAA(A{AA
AHAzAA33ApAAAA{A
=A33A33AHA\)AA=qAA\AA\)AAA33A  AHApA33AAA
=AA\)A33AAAGAA33AA
=AA
=AQA(AA  AAAHA
AAAAAA
A(AAGA33A=qAQA
=A\A(ApA=qApApAHA
=AA(AffAffAzAffApAGA  A\ApA=qARA{AAA
AAAGA(AHAApA\A(AA33AAGAA=qA
AA  AAAffA  AA{A
AAAAQAA\ApAA\AARA\A
=AffA{A\)AzAzAAHAAHAAffAAAzAA33AAHAffAA
AGAARA\AffAAA  A{AARA  AQARARA  A=qAHAA{AAAAzAAA(AzA{A\A
AA=qAzAA\)AQAAApA
ARAAffAA{AHAHAQAzAQAAffA{AAAffARA  AAARAAAAzAHA\A\AffApA\)A(A\ARAffAA\AA
=AffAffAQA
=AAQAA(A(AA
=AAApA33AAA
=ARA\)AQAAffA\A
AAAzA\)AGA(AA{AGAA  A\AAA=qAHAAGAHAHAAAAA(AAAAARAzAAzAA  AHA  AA33A\)AA
A\)ARA  A
AAAAAGAHA{A  A=qAAA
=A{A33A{AA\ARAAAAARA\)AA
AffA33AzAAA{A\A{AApAzARA33AA=qAARA
AA
=AAHA\A=qA
A  AA  AGA{AGAApA  ARAA  A(AffAAAAAAA  A  AApAA\)AAAzA=qA{AAAAzARA{A
=AAAAA  A
A\AAAzAA{AARAzA  A(AAARA\AAA\)A\AA
AHA{AQA\A\ApAARA{A33A{AARAA  A\)AAAAzAffAGAGA
=AA(A{A(AAGA33AGAAAA  A{A  AQAAffAHAHAA33ApA{AffAzA=qAAAA33A
AGA{AAQARAQAA
A(A  A(AAGAA  AAA33A
=AzA
=A\)A
=AAA(AzAAAzA=qAffA=qA{A
=A\AHA\A(AffA{A\AffARAzA
AAA\)A{AAA
AAA=qA\AA\AAGA{AAAQAffAA
=AAAQAQA
ApA33AAA\)A
=A
=AHA
=AffAAzA=qA
=ApAHA
A\)AzAQA  ARAGAA
A33AzAGAAAAAHARAAAAGAAzAA=qA=qApAQAA(AAAQAAA{A  AAA(AA
=AGA(A(A=qA\AA  A\)AAA(AAAA33A
=A33AApAA=qARAAAA
A=qA\AA  AHAAAAGA{A\A
A=qAzA
=AAHAģAHAģAGAHA
Aď\AģA{AîA\AffAAA
=AzA
=AAffAA\A\)AHA{A¸RApAA  A\AA
=ApARAApAAHAzAAQApAAAAA=qA{AARA{A
ApA{AffAzAA=qA{AHARAA\AAAAffAA33AAzAQA{AAzA
=A{AHAAA
A\)A=qA33AGAHAĸRAAĸRAQAď\AAQA  ApAA
AA  AA=qAAĸRAAÙAA¸RA\)AAÅA
=A  AÅA\)AA
A
A(A{AA
AAA
AÅAA  A\)AGAAAAHAAA=qA\AffAQA(ARA  AA  AQA(AffAAA¸RApAzAîApA
=AffAAGAHA\A¸RA(AGA{A
=AA  AA{A\A\)AARApA\AAzA
=ApAŮAŅAƸRAffA{AŮAAŅAAA{AzAAHAǅAƏ\AffAŮAzAHAǙA\)ApAAƣAAQAA  A
AŅAAA
=AHAA  AffAA\)AAA\)A\ARA{AQAîAHA
=A
=AA{AAffAGA  AřAA
AAAřAAAffAffA
A=qA33A\)A=qAAHAHA  AA
=A(AGAAAAHAHA  A  ApA{A33Aď\A{A  AŮA  AƸRAAAƸRA33AŅAzAǙAAǮA\)AffA
=AɅA33A
=AHAffAAAQAAAɅA{A\)ApA{AQAʸRAʏ\AffA(AʸRAffAzAffA33AQAAAȸRAAȏ\A
=A  AzA33A
A  AzAƣAzAffApAȏ\A=qA(AǅAAǅA{A  AAȏ\AƣA33AƸRA33AǙAHAAGA
=A=qAAAƣA{A{AzA\)A  AGA\)AǅAǙA
=AAAHA
=AAƸRA(AA
A(AƏ\A{AƏ\A  AřAAGA\)AAŮAŅA\)AŮAŮAŅAřA
AQAAzAƸRAƸRApAAzAď\AffA
=A\)ApAHAÙAîAA£A  AA33A33AAffApAA(AA=qA\AzAAzA
A\A  AGAAÙA\)ApAA£A{AAHARARAHAzAzA\)ApA
A
AAAA
ARApA\)AAGAAGA33AAA33AAAA33AQAAAffAGAHAAA\AAffAQAAA\)A
AQA\A{AGA
=A{AApAAAAA=qAAzA{ARAAffA=qAA
=AAAGA  AA\A
AAAAGA=qAQAAQAHAAGA
=AA=qA  A\AAA33AzA=qA
=AAHAQA\)A\)ARA
=AApA=qAzAAA\AAA
=ARAQAAzA\AAA33AHAAA
=A(AAA\A{AQA  AA\ApAA\)AAAA
=ApA(A33A
=ARAQAAA33AA\AA{AHAffA(AQA\A
=AAA
A
=A
=AAffAAzApAAAAAA
A
=AAAA33A
=A33A=qAAzAA(A33AzA33ARAApAAA  AAzApAQA\AA£A(A£A\)AÅA{A  AffA=qAQAzAŮAŮA\)A\)Aď\A  AģAzAQAA(AAQA  A{AA(AƣAƸRAƣA
=AƏ\AzAzAƣAA
=A\)ApAǙAǙAGAŅAƏ\AƏ\AAzAzAzAA
A(AƏ\AƏ\AƏ\AffAA=qA
A{A\)AzAAA33AA
AAHA
AHAAAAAzAAffAGA\)AQA\A
AzAHA=qA
AA33AGAGApAGA  AffAzA\AA=qA{AGAzA=qA=qAAAAzApA\)A33AAApAȸRAA  A=qA  AAzAĸRApApAƸRAA=qAHAHAzA=qA\)A¸RAQAAGA33AŅAď\AAHAA\AzA{AAAffAffAHA33AGA=qAffA
=A
AAAQAffA33AŅAĸRA=qA\)AAGA
=A33A{AA33AffA\A=qA\)A=qA{AffA
AģAzAAǮAǮA{A33AAAǅApA\)ApAGAəA33AȸRAAǅA(AǮAǅAAǮA  A(A(AǙAA(AǮA
=A
AzAAǮA
A\)AzAffAȸRAȸRAȸRAAȣAA=qAŅA{AAÅA  AAzAA=qA
=AAGA{AQAffAȏ\AȣAApAȸRAAAHAAzAAA
=A33ApAQAŮAŅAĸRAA(AAAAîAřA33A{A33AGA{A
A{AƏ\A=qA33AA=qApA\)ApApAQAʏ\ApAAA=qAA\)AA=qAzA  AffAGAA(A\)AffA33A
A
AffAffA33A
A
AˮAHA  AAGAɮAAffA
=AQAÙA
=AzA
=AAAA{ApAAffAHẠA=qAA
=A\)A
A  A  AQAA=qA£AʸRAHAͅAAͮAˮAzA\)AGAA
=AA=qAGAAǙAǙAǅAffAHA{AQAA33A
AHA͙A
AΏ\AΣAHAA=qAzAGAAẠAA\)A˙AˮA˙AA
AGA˙A  ApAGA̸RA\)AGApA\)ApApAApAA(A
=A33ẠA33A33A33AGAɅA  AA33AAHA33A{Aʏ\AAʣA{A
A=qA  A(A\)A=qA
AQAəA¸RA\)A=qAHAGAHA
AzAAɮAAffAQAÙApApAÙAzAAƸRAǮAǮAȏ\AʸRAˮA=qAAͅA33AHAA=qẠAzAA  AA33Ȁ\AͅA˙AHAȀ\ApAHAˮAffAAAHAȣA33A\)AAAffAzAAQA\)AAffAffAffȀ\A
=A33A\)AffAApA\)AQAQAA=qA\)A˅A
=AHA  AAA\)AʸRAǅA
A{AAQAAHA(AȸRA33AA\)AApA
A\)A  AAAƏ\AƣAƏ\AƏ\AA33AAAQAAAȣA(AGA  A=qAffA  AffA  Aʏ\A  A
AAGA
=AGA˙AA(A˅A\)AQAəA33AǙA
=AffA  AƏ\AQA(A  AAQAA\)A33AffA(A\)AɅA{AʸRAȏ\AA(AɅAGA
A  AʣAQA=qA(AQA
AApAʸRAAʣAQA33AǮAffAA(AʸRAǮAAǙAAAƣA=qAAȸRAzAQA
=AAAApAƸRA
=AQA
AAQA
=AȸRAA\)AAzAȏ\A33AQAHAʸRAA
AA=qA=qA=qA(A\)AʣA33Aʏ\A  AAffA=qA=qA33AAQAAAQAʣA˙ApApA\)A
=AHAHAʣAffA(AA
A{AA=qAHAffAQAA
=AAGA\)A33AGAŮAŮAAQA  AffAA  A  AffAƏ\AffApAAAGAƸRAHA{AQA
A33AƣAQA
=A\)ARAA
=AAǙAAAARARAA
=A
=AHAAAA33AGAARA{A=qAffAffAAA=qA\)A  AHA
A
=AAAAAffA{AffA{AAzA33A(A  AA  A
=AHAHA\)A
AA  AAzApAAGA
A
A\)AffAAA\A=qARAA
=AGA\)AA33A
=AAGAAzAApAA=qAGAAGAAHAAAAA=qAAHAAA
AHA=qAQAAHA33AHAAAA\)AAAAAAQA33AHARARAAQA\)AAAAA(ApA(A\)A33ARA(AA\AAffAAGAHARAARA  A=qA{AAAAAAA
ApAzAzAAAA(A(AA(AAA33AGAffAARA
=AHAA
=A\)A  AQAffARAzAA  AzAffAQAAzA\AHAAA\)A\)AApAApA\A=qA{AAHAffA\)A33A\)AHARAQAffAffA\AzAffAGA\)AQA
=AGApA\)AA(AAAA{A=qAAGA{AA
A(A\A\AAA
AAA\AA  A
ApAA33A\AGAA  AGA
=AAA(A
=A33AA=qAAzAffA  A
A{AzA\)AHAGAAQAGAzAARAApAAA
AAA=qARAGAAAAAAQAGAHA(A(AA(ARAAHA(A{AAA
AA33A=qAAffARApAAGAHApA=qAApA
=A  AzAAAAzAGA33A{AAAzA33AAffAQAAzARA  A
AAAAA
AzApA=qAAQAAAAAA{A\AA  A\ARAAA\AAA
=AHARAA\AAAAA
=AAQA=qAA
A  AGAGA(AA33AGA33A
A33AQApAA\)A\AAARAARA
=AAffAHAAQAAA{AAA
=AApApAzA=qA{AAQA  AAAzA\A  AAAA
=AAGA(A
AA\AffA=qAGAHA\)AA=qA=qAA\AARA(AzA(A{A{AA\A\ApAAAAQA
=AAAAAA
=A{ApAApAGAA(A
AAGAApA(A{AA
=AzAA\)A33AzA\A\)A33A\AAGAAA33AA\ApAQAAA\AQA  A(AAAAGAffA
=AARA\AGA
=A33AAA
AAA=qA33A{A\)AGAAGA\)A=qAARAAîAQA
AzAffAA
A\A=qA
AA
=AQAffAAAQA\A£AA33A33A  AA\)AQA
=AzApA
AAAAîA=qAAAGA
AîAAApAîApAGAÙAÙA
AÅAGApA£AA=qA33A33ARAAAAffAA=qA{A
=AGARA
A
=A\AHApA\)AzAA{A=qA(AHAA  A\)AzA33AA\A{AA{AA
=A
AAQAffA{AAA
=ARAQA\)A(AHA(AAAzA
A{A=qA
=AAffA{AAAGAGA\AARAHAA\)A\)AHA
=AzA{AA\)ApAA
A
=AHA=qAA(A
A(AAHAA
AA\)AHAAGAAQA{AAAzAA
=A
A
A  AAQA
A
AA{AzA\)AAA
=A=qA33AHAHAAffAGA{AA\)ARA33AApA
ApA=qARA\A\A
=AAAQAA
AARAA(AQA  A\)AA=qAA(AA
=AGAGA33AGA
=ARAA\AAHARAzAAAA\)A\)AApAAAHAAGAAAGAGA
=AAffA  AA{A\)AAGA
=AAA{AA=qAA(AAHA33A
AffARA
=AAzAA
=A{A=qA{ARAA
=AAARA\A
=AAAQAA33AA
AA  AA\)A\)AA\)ApAAAAAAAAAA  AQA¸RAAÙA\)AÙA
A  A{A{A{AAîAÅApA
=AHAAAAzAQA(AzAQAffAQA{AA  AA
AAAAAAA  A  AAAA{A
=A
=A=qA\)A\)AAGAA\)ApAAA\)A(AzA=qAAApAAA
ApA=qA=qA
AA(ARAAHAAÅApApA  A33A=qAA
=AĸRAřA
A  A(A
A  A  A(AƏ\AA\)A\)AHAHAƏ\AƣA
=AǅAAƸRAAffAƣA(AAAƣAAA(A
A
ApAîA(A£A¸RAzAffAA£AzA
=A33AGA
=AAÙAA\)AA(A£AA\A(AAAA
A
A\A
=AA{ApAffAA
AîA(AĸRAA\)A33A\)A\)A\)AAAAHAHAA\)A
AAAzA  AƏ\AQA{AǮAǅA
=AƣA(AřA33AAAAAA
=AQAģAzAzAffAAffA=qAģAģAHAAĸRAHAQAffA33A=qA33A33A=qA(A33AĸRAAHA33AAGA
=AzAĸRA
=A
=AAÅAÙAffAffA=qAA
AA
AzA=qA=qAAA\)AAAAAÙAAzAAA
AARAApA
=AÅAAAŅAApAǮA
A
=AAǙAQA
=AHAA
=AA33AǙApA
A(AffAzAȣA(Aȏ\AȸRAȣAzA=qA{A
AAǅAHAƏ\A
AAAA
AŮAQAzAƏ\AŮAAď\AHAAģAQAffAQAzAď\A  ApAffAzA\AîAffApA\A=qAffAAGA\)AřA{A33AŮAA=qA=qAA{AA(AGApA
=AQAQAAGAřA  A  AffA
=AA(A(A  A  AƏ\AƣAQAƣAƏ\AƸRAAAHA
=A33AǮA{AzA{AAǮAAǮAȣAAA(AAAA  A
A  A{AAǮAǙAA
A  A33AGA\)A\)ApA33A\)AGA
=A{A  AGApApAǮApAffAǙAAƣA(AǮAǅAAƣAƏ\AQA(AA=qAA=qAAGA
=AAGAGA\)ApAAQAAQAƸRAŮAAzAzA
AAzAȣAAəA  AẠA=qA
AAAA=qAzAzAQA{AQA̸RA\)A
=AA  A33A
=A(AAGAɅAəA{AɅAGAA{AAɮAɅA33A33A33AHA
=A
=AȸRAAQAAA{A{AǮApAffAȣAffAQAHAǙAǮA
=A
AGA=qAŅA  AQA{AzAAQA
AÙA{AffAAzA\)AŅAA(A  AƸRAAA
=AAA33A\)ApAAȏ\AAHApAȸRAA{AA{A=qAHAApAGAHApAȣA{A  AǅA\)A33AGAAǮAǮA  A=qAAGAAAAAAƸRAƸRAffAApAAĸRAď\A=qAAAƣAǅAƣAŮAHA{AHA33AzAHApAzA
AAA\)AȣAAAHAÙAA33AzA
=AAA{ARA{A
A  A
=AzA\)A£A\A{AQA33ApAGA¸RAA33AAAA=qA(A  A{A
A  AA  A(A(A=qAÅA  AÅA¸RAQA
=AA  A(AAHA(AĸRAîAď\Aď\A{Aď\AzAQA=qAA\)AAffAHAQAA
AAA
=A{A¸RA33AĸRAAHApAffAAģAÙA
=AQA\)AAHA{A33A
AA
A(ApA
=AAzAÅAÅAGA\)AÅA¸RAffA
A  A=qA£AÙA=qA
A=qAAHA\)A
AAAffAAffAƸRAƸRAƣA{AffA  AzA=qAQAƏ\AQAffAƏ\A(AǅAHAǙA33AA{AǅA\)AǙA{AHAȸRAzAzAȏ\A  A
=AHAǮA{AHA33A=qA=qAffA\)AģA¸RA=qAA33AA33ApAəAAffAQAA\AA\AARA=qA
=A
=AGAĸRA33AģAAîAAAffAHA
AŮA33AAzAǅApAǮAȏ\AɮA
A{A{A(AʸRAA˅A  AQA\)AffAəA\)ApAAɅAəA(A
AAAA
A=qA{A{A
A{AAɅAAȸRAAGAAAAffA{AAGAAHAȣAHAzA(A  Aȏ\AAǙAzAffA{AGAGA  A{AA
=A
=A=qAĸRA=qAŅAŮA
A£AA{A
A\)AAQA\)A=qAȸRAAA33A33AAƸRAAAHAɅAɅA(AʣAA˅A{A(A33AGAAͅAͮA
AͮAAGA\)A  AAͅAͅAHAQAAȀ\AGAGApAAͮA
A͙AGA33AGAA\)AAA  A
=A=qAAȀ\AA̸RAzA=qAʏ\AffAHAAGA  AQAzAffAGAAǅA33AƣA
=AAQA  A{AȣAȣA33A33AɮApAɮAɅAAǙAAzA{AA
=AAîAHA
A(AHAHA(A(A
AAA
AÙA{A33A
=A33AɅAA{AffA\)AʸRAʣAQAffAʣAˮAAAʣAʸRAʣAʸRAHAAʣAʸRAA
=A
=AA\)AGAGApAAAAA
=AA
=Aʏ\AzAHAGA
=AffAGAHA\)A
=AAQA{AȣAA  AǮAffA{AA
ApAǙA33AffA\)AƸRApAffA(AGAzAffA(A  A33A\)AQAAzA(AffA
A=qAAȏ\ApAAQA=qAƸRA=qAQAřAƣAǮA
A\)AffAA33A  A\)AΣA
=AӅA
=AAAffAљAGAA33AA\)AHAAυAϮApA  AAffA(A̸RȀ\A=qA{AHẠA̸RAzAffA
A(A=qAzAQAzA(A(AˮAˮA
AA
=AA\)AGAȏ\AAzAQAǙAApAGAA
=AAAzA
AA=qAAA{A{AAǅA33AHA33AzA  A{AȸRA33A(A\)A\)AAǅA=qA\)AA˅AA(A(A͙A
=A=qAϮA\)AθRAffAͮAQA
AffAθRAffApA33A̸RA
A(AQA=qA=qA=qAzAzA̸RAAͮA͙AͅAHAA\)AAA33AAApAA
=A33A{AɮAA
=A=qAA33A=qApA{A
=A  AAAAƏ\A33AGAɅAAA˙AA  A=qA  ApAÅA33AAQAGA
=A
AAAAAGAffA  AzAA33AǙAǙAffAȏ\AȣAȸRAGAəA(AʣAA˙A\)A˅AA{AffAQAQAQAA{AAθRA=qA=qApA\)AAHA
=A
=AAHA\)AͮAA͙AͅA͙Ȁ\AAGAA(AAͮA=qA
=AϮAffAzAffAA
A
AAQAA
=AΣApA
=A{AẠA(AffAQA(AʸRAA˅AʸRA33A˅AẠA˙AApAQAQAAffA33A=qAͅA{AHApA
=ApAzAQAAAA\)AAQAHApApAAAЏ\AHAAGApAAAGApA=qAϙApAffAЏ\AϙAHA33AA\)A33A  AҸRAAAAAҏ\AzA  A
=AңA=qAGAϙAQA\)A\)Ȁ\A{AzAApA
=A\)AƏ\AǙAAQA{AȸRAȸRA
=A{A  AGA  AƸRA=qA\)AHAA
AHAǅAƣAƸRAǅA\)AǙAǮA
=AA{A=qA
=ApAǙAQApA{A{A=qA
=ApA  AzAəAzAəA(AəAAA33AȣA{AGAAffA  AA{AzAA{AGA{A
A=qAffAHApAHAAQAAΏ\A(ApAAͅA͙A33AAzAApApAA33AApA33A33AAˮA˙AA(AˮAzȀ\A
=A͙AA{AA=qA=qA
=AffAAAQAAAffAGAGA33AƏ\A  AA\)A(A{AHA
=AGAAŅAffA=qAffAƸRAƸRA
=ApA  A(AȣAAAzAffA˅A
AffA̸RA̸RA͙AθRA33A33A\)A\)A33AAHA͙AͅAͮAͮAͅAəAA͙A˅ẠA=qA=qA(AΣAGẠA
A=qAffA  AͮAffAAHAzAͅA  A˙AʣApA  AGApA̸RA˙AẠApApA(AȸRAəAˮAəAAƣA\)Aď\AAAAQAA33A33Aʏ\AAʏ\AGA
A͙A(AffA(AʣAɮAffAAQAAffAAͮAffAHAAGAϮAQAиRAA{AGA
A  A=qA{AQAffA33ApA=qA{A
AGA{AffA
AAѮA  A=qAѮAѮA
AѮApAѮA
AA  A  AAA
AA33A=qA  A=qA
=Ȁ\A{AzAυA\)A33AzAffA(AffAA{AυAA=qAQAЏ\AzAzAffA
=A\)A
AAHAAϙA  AυAAΣA(ẠA
AA{A\)A  A
=AzAAA  AΏ\A
=AϙA  AffA
=A(AљAѮAGA33AхAA(Aҏ\AQAffAңA
=AҸRA33AHAЏ\AӮAӅA33AGAzA  AAљAхAѮA\)AGAHAAA
=AA
=AЏ\A33A
=AffAиRA=qA33A=qAHA(A{AAA
A  AAGAGApAȏ\AǮA{AA33AAʏ\ApA{A33A=qAУAzAAA33A  AQAңAҸRAHAzA\)A(A
=A(A
ApA{AA  Aҏ\AӅAәA33AӅAAzAԣA33A33AGApAՙAAAՙAAՅAAңAAffAAҏ\AAGAAҏ\AffAAffAA\)AAApAAzAѮAAHA(AϙApA\)A
=A(AQA  AиRAAAϙAHA
=A
AGAGAΣAΏ\AAQAͅAΣAA͙AHAGApȀ\A
=AAQAʣAA\)A˅AQAɮApApApA=qȀ\AẠAQAͅA  A=qAǙAQAƣA33AǙAGAQAGAA{AffAʣAHAA33A33AHA
=AAzAʸRAzAQA(A(AAɮAɅA{AQA(AQAHAʸRA˅A˙A˙A33A
=AGAA33A33AGA33A\)A33AAAffA(AffAzA33AAʏ\AAzAˮAGApA33AHAzAAHAʣAʏ\AGA{AAAƏ\AQAGAzA=qAHA=qAGA33AA
A{A
=ApAřAŅA\)AA\)AřAƏ\AffAHAGAAģAŮAƏ\AAA=qAAffAzAA33AŅAffAzAAAAA
AA\)A  A  AƏ\A(AA(AffAƏ\AAřAAƸRA33A{A  AAAAȸRAQAŮA
A(ApAA(AzAģAAîAÙAîA=qAAzAzA=qAAď\A{ApApA\)AAHAHA=qA{AA33A
AA33AAffAzA{A(ARA33AA
=AAHA  A33A
=A\)A
AffA{A=qAGAƏ\AAHAA(AȣAA{A{AzA(A(A(AɅAAɅAAA
AǅA33AGAA{A=qAAAǙA\)Aȏ\AffAAƏ\AƣAȣAffAQAƏ\AAŅAAƣAŅA\)A33AzA(AA
AGA=qA£AffA=qA=qApAÙA  AzAƣAAGAƏ\AAƏ\A
AHA=qAAƸRAƏ\AǮAǅAHAQAȏ\AApA  AʸRAzAȣAȏ\A\)A=qAəA=qAəA{A
AHApA(A{AQẠA33A
=AzA=qAHAffAffAˮA{AA\)Aʏ\AzAA
=AzA33ApA33AAffA{AAəA\)AȣAffA  A
AAǮAƏ\A
=AǮA
ApAģAď\A
A=qAď\Aď\A
=AřAHAA33AA\)AAA
=A
=AA
=AAAHApAAÅA=qAffAzAŮAzAAîAď\AA  AffAQA  A
=AQA{A{A{A¸RAGAAď\AřA
AzAƸRA
=A33A{AȣA
=AAAȣAffAQAAGA33A33AApAǅAƸRA33AǅAǅApAǅA\)AGApAAAApA
=AQAffAAAƏ\AHA(AAƏ\AzAzAzA
AřAîA=qAAŮAřA
A(AřAŅA
Aď\AzAģAAAAA\A(A33AHA
A
AHAAîA=qA=qA
=A\AQA=qAApAGA(AÙAHAAƸRAA
=AA
A33AffAŅA
A{A
AřAŅAAŮA{A
AQAŮAŅA=qA  ApAŅAAA(AAA(A\)AA{A  AŅAffAAQAHAffA  AAď\AffA
=A33A
=AĸRA{A(A(AffAģAģA
=AAŅA
A
AHAGA=qAzAĸRAAAffAď\A\)A  A
AAA¸RA
AApAApA=qAffA33AA33AA£A£AQAŅA
=A
=AAffA
=A  AAGAŮA  AA\)A\)AQAƸRAA(A=qAApAȏ\AzAHAAQAǮA{A  ApA\)AAGAǙAǮA  AffAǮAǮA  AA=qAzAffAȏ\AffAA
=AA
AǙAAǅA
=A=qA(AAAAA=qA{AŅAǮAAƏ\A(AģAƸRAƣAffA{AAǅAAřAAHAAAAŮAffAGA{AǮAȣAAHAƸRA  AȣAƣAǅAAǙAƣAA33AĸRAHAřAzAǙAǮAA  A=qA=qA{AQAffAQAQA(A(A=qA{A
A33AAǅAAȣAȏ\A
A(AǙAǙAǙAA{AffAAAA33AŮA33A=qA
=AAƸRAGA33ApAǙAAǅAA33A(AAAAƸRAA33AHApA{AAřA(A=qAAÅA\)A¸RA{AA{A{AGAÅAGA
=AAA\)AzAřAQAffAƸRAAzA{A=qAȣAHAAA  AȸRAȣA
=A33AGA33ApAəAAəAAɮA\)AAHAȏ\AɅAAAəA33AAAGA
=A
=AzAȸRAzAȸRAQAffA  A=qAAʣApAGAǮAHAHA  AəA=qAHAA
=AɮAʏ\AAA=qAǮAffAGAA(AřAAAřAŅA=qAĸRAQAQAQAffAffA(AQAAAĸRAĸRA=qAffAffA{AGA\)A
AģAAApAA
=AGA  A=qAffAȣA
=AffAGAɅAȸRAzA\)AA\)AAAAA\)AȣA=qA(A=qA{A  AAzA=qAA¸RAAŅAAA{A33AA
=AǮAǅAƣAAAAÅAAAA33A£AQAAAARAzAAAAA
A33AģApAffA\)AGAîAAď\AAHA
=AŮAffAQAzAzAAffAAzAA
AApAŅAzApAAzAA
=AȸRAGAəAɮA  A{A(A(A=qAzAɅA  ApA  AQA
=AȸRAAəAAQA
A{AffA
AAffAʏ\AffAɮA
AAGAGAAAȏ\ApAffA{AffAzA(ApA(AGAGAȏ\A  AQAɮAQA
=A  A  A
=AǅAQA=qAApA
AffAzAǙA(AAffAAĸRA\)A(A
=AAAHApAQA  A33AAӮApA  AAA33ApAיAAׅAיA׮ApAׅAׅAQA
=A֏\A֣AHA33A\)AׅAׅAffAظRA=qAQAzA؏\AAAzA
=A{ApAAظRAApAAمA
A{A  AՅA
=A\)ApAAәA=qA(AAA(A(ApA
AңA{AGAA
ApAиRA
=A(A
=A{AҸRA33A33AҸRAљAGAGAGA
AAAϙAϙAzAхA  AӅAӅA  AQAԸRAffAAԸRAQA(AffAхAGA=qA\)A
A  A=qA  ApAGAA\)AAAQAQAԏ\A  AAAAәAGAffA\)AQAffAҸRA(AA  AA=qA=qA=qAՙA
=AՙAHAzAffAffAQAϮA(ẠA
AQA(AAQAʏ\A\)A33AAA=qAAAΣAA˙A
AffAυA33A̸RApAHAA
=AQA{AHA
AA\)AAA{AʣAʸRAʏ\AzAυAAͮAHAzAϮAAHA\)AAљAAGA
ApAGApAGApApA33AAиRAAAиRAУAAQAиRAGAϙA{ApA  A33AAGA{A=qAʏ\A\)ẠA  ẠA˅AA\)A33AʣAAA
=AʣAAʸRAffA33AAA\)AAɮA(AɮAɅAA=qAʏ\AzAffAGAȣA{Aʏ\A
=A\)A  A(A  AzẠAHA  A  Ȁ\AAA\)AffAA=qAΣAA
=A{A(AHAA  AQAԸRAԣAffA(AAAGA33Aҏ\A=qA{AљAѮA33AA
=AAGAAQAҏ\AAAѮAУAϙA
AΏ\AθRAθRAHAzAθRAQA  A  AΏ\AυAGA  AAљA
A{AAAѮAѮAңA{AљA=qAϙAЏ\A
A{Aʏ\AQAʣAzA˅AffAͮA(A
AzAɮAAzAffAffA33Aʏ\AA  AA͙ApA
AθRA{A
=AѮAѮAGAљA=qApAA(AQA{A
AGA  A{AAA\)AՅA\)AAAAzA{A{A(AәA
AΏ\Ȁ\AϙAA(A=qA(A
AӮApA33AAApAffA
AϮApAA{ApAzAAΏ\AHAυA  AϙAA  AͅApA͙A33A
=AAQAAˮAGAHAʸRAAA\)AʸRAAʸRA\)AzA
AȣApAQA=qAʸRA˅AffA\)AͅAͅA
AΣAGAυAϮAAAAAQAAAA
=AA
AӅAӮA(AAzAԸRAԸRAԏ\AffA=qA\)A
=A{A
AѮAхAA
=AAQAΣAAAGA̸RAzAzA̸RA
=A{AzAffA=qA\)AAzA
AA=qA
AAHAȣAAAʏ\AAA33A\)A
=AȣAGA\)AAGA  A(AQAffA\)A(A˙AffA\)AzAAЏ\AϮA
=AυAzAffAAA=qAΣA33AͅAΏ\AͅApAAΏ\AA33ApA
=AA(AυAϙAAA33A\)AυAGA\)A\)A
AϮAυAΏ\AΣA
=AAͮAzA\)A{AHAQAAzA˙A˙A  A(AAʣAffA
=A
=AAzẠA33ẠA̸RAAQAAAAHA\)AAQA(ApAGAǅA
=AHA  A
A  A
AffA=qAAApAAffA  AȸRAȏ\A
AQA\)Aȏ\A33AɮAAA33AAzA=qA  A  A  AAˮAAA
AAˮA\)AʸRAʏ\AzAʣAAHAAʸRAʸRAʸRAAHA
=ApAA˅A(Ȁ\Ȁ\AQAˮA33A\)AAAQAAffA
=AɅAAAɅAʏ\A\)AzA
=AAȸRAɅApAAApAAGApAAĸRAǙA  A=qA\)A
A  A(A{AzAAɅAAffA\)A  A
=AGȀ\AQAQA\)AffApA33A\)AƏ\AƏ\AƏ\AGA{AA\)A˙AA33AzA33A33A\)A
AQAA33A\)AA  AGAAA(A\)A
Ȁ\A̸RA{AˮAˮAˮAʏ\A{A
AɮAɅAGA
=AHAɮAzAGAəAQAAHAʸRAʏ\A{AGAAAȣA
A\)ApA=qA33A\)AAȣA\)AAǙA{AffAʏ\A\)AȸRA(A33A=qA
=AQAȸRA(AƏ\AȸRAzA  AǙA(AȣAHAA
=AAA\)AzAAˮẠA(ApAffA
=AzAAУAAхA(AѮAУA{AQA{AQAffA  AУAQA{A  AϮA=qAϙAApAAΣA
=AθRAΣA{AzAApA͙AA{AΏ\AЏ\AЏ\A͙A\)A(AQAHAHAzAzAͮAffA{AͅẠAA33AA  AQAzAzAffA˙AffA
=A˙A
AHA
AAApAˮA\)A  A
ApAGAAQApA\)AA\)AAͅA  AϙA
=AЏ\AЏ\AffA33AzAAׅAzA33AӅAffA33AӅAУA{A=qAGAЏ\AQAQAУAzAffA=qAУAϮApA
=AAAQAΣAA
=AϮA
=Ȁ\A
AffAˮA˅AͅA(A
=AΣA=qA˅AGA{A{A̸RA33AQAˮAGAͮA{A(A̸RAΣAGA  A\)AApA(AǮA{A
AǙAffA33AAȣAAzA  AA(AǅA(AA{AzA33A
A33AAǙA(AffA33AǅAAGA33A{A\)AAffAȣAȣAǙA=qA\)AřAzAĸRApAď\A33AAA  AA\)AGAzAAQAARAGAîAAAffA
=AffApAQARA(A(AAAQA33AAHAAzA
AA33AA(A\)A\AHAAffAA
AzAAHAffA  A\A=qAA
AzA\AAGAA{A
=A=qAA
AA{AģA\A=qARARA£A{AîAAAAŅA
A  AƣA
=AǙA33AǙApA\)AƣAƣA
=AǙAǙAAƏ\A
A  A{Aď\AA\)AGA(AQAAAÅAŅA\)AģA33AƸRA  A=qA{AAQAƣAAHA
AAAď\AAA(AffA  AAAGAAģAAzA33AA33AApA{A{AA\)A=qAffAQA=qARAAA=qA  AGApAAffA
=A\AzApA{AffA\)A
=AǅAGAApAǙAAɮAřAƣA{A33ApAģAQAQA(A  A\)AGA
AŮA33AHA33A
=AA
=ApA
AA
=A
AffAGAA=qAȣAAƣAȸRAȣAQA
=AQA{ApAAzAAA33A33AAAƣA  AĸRA33AAAřA
ApA33A\)A33ApAQAƸRAGAHApApA\)AHAGAƏ\AřAƸRAGAAzAAA\)AzA=qA{AA=qAAffAffAAΏ\AA33A{AHAѮApAѮA(AAAA33A  A=qA33ApA33AQAA̸RAȏ\AffAHAAʏ\Aȏ\AʣA\)AϮA33AAϮAHA=qAQAͅAɮAʣA
=AQAAУA=qAЏ\ApA̸RAȏ\AQA(A  A{A
ApAAƣAzAffAApA=qAɅA  AzA
=ApA\)AA{A\)AQAzAʏ\AzA(AQA
=AɮAGAApA=qAʣAA͙A=qAΏ\AGAAϙAA  AffAHAθRAϙAAУAGA\)AѮAљAA  A  AffA=qA=qAҏ\AzAAѮAхA  A
=AGAθRAAQA
=A  AAAffAGAGAffAAQAAAAGAHAΏ\A(AQA  AʣA
=AHA33A
A
A\)A  AA  Aʏ\AffAHA33A=qAA33Aʏ\A(ApAиRAAffA  AQA\)AAAHAΣAAA\)AGȀ\AˮA˅AA{AQAAAΣAϙAQAQAхA=qAңAҸRAAӮA{AԸRA
=A\)AծAԸRAԏ\AAӮAӅA33AAӮA
=AzA
=A(A
AAЏ\AΣAAAAʸRAAzAυAϙAA  A
AAffA\)Aʏ\AHA
A˙AHA=qA  A=qA33A33AA
=A
A
A  A(AApAQA
AAυAϙA(AffAHAA(AGAA(AϙAϮAQA(AAѮA  A{AA{ApAAљAAffAϮAffAУA͙AAAиRA\)A\)AA=qAAA  A(A
=A
=A(AָRAAHA֣AffA֏\AQA=qAQAQA(AApAA(AәA\)Aҏ\AӮA\)A
AҸRAAиRAиRAHAиRA{AA
=AθRAAAHA
AAGAθRAQApAͮAzA
=A33AͮA(A  AAA͙A
AQAzA{AA\)AzA
A{A
ApAHA͙AAA  ApAGAApA=qAHAθRAffApAAAAHAAGAϮA
=A
AHAϮA33A\)A  AΣAΣAΏ\AΏ\AυA
A
A33A33AΏ\A33AͮẠA
AGAAAɮAˮA˅AGA  AAʸRAffA
=AAυApAAAAəAAffAʏ\A=qA(AɅAQAȏ\Aȏ\AȣAɮAAHAzAʸRA
AȸRA{A{AɮA
=AʸRA˅AɮAGAHA  AŅA33AA=qAHA  AGAA  AA͙A33AəAA33AAffAʸRA˅A=qA̸RApAzApAHA33ApA  AzAиRA
=AA\)AѮA33AӅAҏ\AљAҏ\AңAA33AffAҏ\AAffAffA\)A(AхA=qA=qAA{AAHAθRAA̸RAffAQAA(AA=qAHA
AzAQAAAAϮAAυAQA\)AAffA=qAʏ\A
=A{AAȸRAϮAQAʣA  AЏ\AffA
AA{AAA  AA͙Ȁ\A
A
=A
=AzA  A{AQAѮAffAA  A{AQA33A\)A
AQAԏ\A
=AGAՙAA{AffA֣AQA֏\AzAQA(A(AծAծA33AGAԸRA{Aҏ\ApAAffA33AQA  AffAԣA  Aԏ\AQA(AGA  AzAApApAA\)A(A{A(AљAʸRẠAѮAGAHA͙A  AʸRA˙AɮA33AΣA{AA͙AAA
AA˙Ȁ\AAͮAGA
=A\)ApA  A
=AAAͮAͅApAΣAQAHAυA=qAffA33A
AQAzAҸRAApAAffAzAԣAA33AGAՙAծAAAAԣAӮA  A33AGAӮAffAңA33AӅA{AffApAңAAAzAA
=AԸRApA
=AA\)AՅAԣAA
AQAAAәA  AA\)AQA(A33A33A(AA(A{A=qAA˅AGAHAAAѮAffA(A=qAхAхAAHA
AHAңApA  A
=AGAHA{A\)AυA
=A  AЏ\A
=AѮAQAGAApAӅAԏ\AA  A=qAffAԣA\)A  AՙA=qA
AՅAffA  AAffAծAGAAA\)AHApA֏\ApAApAGA=qAׅA
AظRA\)A
=A
=A(AHAA33Aԏ\A  AA(AљA
A=qA
=AA\)AәAA33AЏ\A  AQA33AиRA\)A
=AΏ\AGA(A=qAHAəAHAA  A  A=qA(AΣAHA
ApApAAУAQAA33A\)AәA
AffAAGApAծAA{A  A  A=qA=qAQA=qA(AԣAՙAծA  A{A(AGA
AQAQA(AՙAՙApAՅAՅAՅA\)AAGAՅAGAGAӅAҸRA{A=qA
A(A  AQAծAԣAHAӅA  AQAծAәAGAԣA33AA  AHAϮA{AA33AAԏ\A
=ApA
AzAAA\)AffA{AԣAGAGAҸRAA
=AԸRAՅA\)AffAҸRAGAffA(A(AffAAGAHAzA=qAәAәAAA(AQAAԏ\A
=A\)AծAՅAA֏\AGAA֣AzAָRA
AA  AՅAQAffA֏\A֣A
=AA
=AHAָRA֣AQAzAGA֏\A{A֣AA{AQA{A=qApA(A\)AծAffA{AA  A=qA
AծAA
AAԣA
=Aԏ\AӮAzAAA  AQAՅAffAѮA(AffAffA33AA
AffAGAAA{AffA\)AQAAԏ\AQAAHA33AA\)AծA33AծA33A  AָRA  A{A
A(A33A׮AAzAظRA=qAAQA=qAGA33A(A  AA=qAQA{A(AمA33A
A(AQA(AzAA{AAQAٙAAAAzAHAظRA
AA
AHAA
AGA=qA؏\AAծAAָRAzA33AHAAffA
A֣A33A(AAׅApAׅAQAAffA=qA׮AzAAAQA33AӮAAAծA
=AָRAffAffAיAׅA33AAHAָRAAAأAAAGAAA֏\A=qAָRA֏\AA=qAGA=qA  AՅAՅAAApAGA
=AԸRAffAHA
=AQA(ApA{AңAҏ\AzAAңAңAУA{ApAAA33AQAHAAHAҸRAҏ\AQAAGAAzA
=A
=AAAApA\)AθRAzAA  A
AϙAA\)AυAͅA33ApAffA\)A  AϮAffAAѮA
AϮAϙA\)A\)AЏ\AHA
AљA
=AA\)AA(A{A=qA33AѮA
ApAхAљAGApA
A=qAAљA  AхAљA  A(AAzAQA{AffAAAGAиRA33A=qAAGA{AHAЏ\AA\)A\)AQA  AA(AAЏ\A=qAA  AAzAzAAA͙A
AffA˙A{AQA˅Aʏ\A
=AʸRA(AͅAGA  A
=A\)A\)AѮA{AңAHAхApAHA=qAAAA\)AA(A{AffAA33AՅApApAA
A(AffAָRAA\)AAA׮AׅAGA֣AQAծAAGA׮AׅAAAAGAQAAָRA33AׅA33AAffA=qAAGA\)A
AԣAAԣAA=qAffAffA{AθRAffAУAHAA=qA33ApAA{AQAHAAϙAA\)AиRA{ApAQAϮA\)AAѮAffAҏ\AӮAAծAffA(A֣AHA33A(A33AffAQAzAA33A\)A  A{AA{A=qA֣AffA{A=qA  A{A  A=qAQA֏\AffA  A{AzAAԸRA{A33A
A\)AAQA{AzAHAҸRA  A=qAA\)AGAQAӅAAA
AQAҸRAGAӅAA\)AA
A
=AϙAzAGA  A\)AAGAAQAA33AхA
=A
AA=qAΣAA(Aԏ\A
=AHAGA
AA
AffA33AA(Ȁ\A
ApAAљA
AzAzAθRAͮAAυA\)AA(AAA33AA33AAӮAҏ\AffAңAӅA=qAA(AӮA\)AAzAzAA=qAҏ\A\)AGApAAљA\)A
AԸRAAAԏ\AӮAQAGAAУAA=qA  AЏ\A(AQAffAQA33AиRAffAAA(A=qApAHAffA33A=qA{A
AA\)A=qA{A{AAҸRApAљAЏ\AAHAQAffAҏ\AAApApAHApA  A  AzAԣAffAA\)A\)AA(A֏\A(AA(A(A33AA(AffA33A
=AأAHA
=ApA\)AGA\)AA33AGAAA{ApAٙAA
=AٮAٙAٙAظRA\)AיAA\)AԸRA  AՙA33AA\)A\)AӮAAԸRA\)A{AAzAA(A(AָRAHAAAzAA  ApAԣA
=A{AAffAA(AӅA\)A
=AA  A(AffAzAظRAGA  AzA(ApAA\)A  A{A؏\AHAGApA(AffAڏ\AA
=AffA(AzAݙAAݮA{A
AGAAGAܸRAffA܏\A܏\AܸRA  A{A\)AۙAۅAHAQAApA=qAQApA{AָRAָRAָRAمAA(A\)A{A
=AQAۙAffAAۮAQAיA  A֏\AׅAA{AHApA
A{AAAGA
=AأAzA33AA
A׮AAAAأAظRAAzAffAA{AGAQA؏\AHAQA=qAҸRA\)A֣A33A
=A{A֣A
AA{A(AzA
A
ApAAA
A\)AGAׅAA=qA{AA
A{AQA\)A{AzA  AՙA
AA
=AأA\)AA
=AzA=qA
AGAA؏\A=qA
=AәA  AAQAAңAԏ\AzAծA
=AA\)AGA=qAָRA׮A
=AAAA{A׮AAAA
=AԸRAzA(AٙAڸRA=qA33A׮AzAQAQA(AمApA33AHAׅAA
=ApA׮A(AظRAAAٙAA  AAۅA33A\)AAQA\)AAAffA\)A
AݮA{A
AA
A{AzAzAzA(AzAݮA(Aޏ\Aޏ\AAzA=qAAAA؏\AأAAظRA\)AAzA
AمAGA=qA
=A{A33A{AHA{AA
AڣAՙAffA33AAA(A{A=qAHAQAAܣA  A݅A\)AA
=AAҏ\AAHA\)AܸRAAA33A33AGAAHA{AظRAA
=AAٮAٙA
A=qAAAGApAۮA܏\A܏\AAݮAA33AAAHAݮAݮAܸRAzAffA=qAAܸRAQAQAܣA  AffAffAܣAܣAܸRA(A
=Aڏ\Aڏ\A
AffAٙAٮA(A33A=qAA33AA  AffAQAA\)A
=AՅAzA  AGAHA{AQA\)AAиRAظRAffAffAffA33AzAAڸRA(AAHA
AAAGAܸRAzAA
=AApA֏\A֣AzA֣A
=A\)AQAzAHAGA  AAAA(A  AA=qAܸRAܸRA  AApA܏\A{AۮAۙAۮAAffAAHA܏\AA
=ApA  A{AHAݮApA
=AܸRAݮAQA܏\AffA33AzA
AݮApA(AיAAHAQA  AA\)AۙAڏ\AAGAGApA
AӅAAA
AԸRAHAA33AAGAAԸRAAAffAA33AՅApAծA33AAGAAA  AָRAQA֣AzA
=A
=AיA
AAأA  AffA33A֏\AffAָRAQAיA֏\AՙA  A  AӮA{A{A֏\A׮AԸRAA\)A33A(A{AffAQAӅA
=AGAHAAQAԸRAԏ\AԸRAԣAGAAffAGAՅA
A{AGA(AAQAԣA
=Aҏ\AQA33AѮA  A{Aҏ\A\)A
A  Aԏ\AHAԸRAHAծA  A\)AGA\)ApA(A(A  A  AQA=qAAQAAHAQA(AzA֏\AQA֏\AָRA֣A(A(AffAיA33AAAָRAָRAzAAA
A
=AHAAAיA33AHAffA  AA33A(A  A33A33AA
=A=qA  AQA\)AA33AҸRA=qA=qApAffAAԸRA(AA
AљAՅAQAffA=qAծA֣A
=AָRA
A֣A\)AAGAA\)A33AׅA(A
=AAAՅA  A{ApApAzAAҏ\AңA
=AA=qAϮAzAA33A
=AиRAQAGApAzA=qAAҏ\AHA
AHAхA\)AθRAA=qA=qA  AHAAӅAffAQAGA=qAңAAңAAffAңAҏ\AAхApAAzAA
AAQAQA{AffAAApA33AQAΏ\AAQA{A  A{AͮAHAϮA
A  A=qAЏ\AHA
AAA
=AхA(AAиRAHA
=A=qA\)A{AԸRAHA(AffA{AGAѮA  AA{ApApA
AzAGAAGAAҸRA33A{AAҏ\AҸRA
=AAAӅAGApAӮAӮAA=qA  AQA
=A  AѮAѮAљAAQA33A
AͮAAGAθRAAAAυAυA33AΣAAAAA33A
=A
=A
=A\)AθRAͮA\)AffAAΏ\A33A\)AAAApA\)A33A33A̸RAA
=AzAхAAAӅA=qAzAAA(AAGA33A׮AיA  AظRAظRA=qAأAAHA؏\A
AׅA(A(A=qAzAAA(A(A{A{A
AAAffAיAAAzAՙApAԣAԣAA  A{A=qAGAҸRAҸRAffAffAAAҸRAԏ\A(Aҏ\AQAхAAѮAzAЏ\AA
=Aԏ\AӮAӅAҸRA
A{ApAAffA
=AzA
=AA33AңA
AAHA
AәA(A{A
A
=A  AzA{AљAЏ\AffA33A{AԣApAAQAzA33AAAA33AGA\)A׮AGAA33A  AAffApA=qApA(A
AA׮AA׮A
=AAAAA֣A
=AAAA=qAzAGAѮAӮA=qAQAAAApAθRA
=A{AQAzAAиRAGAA͙A{AңAHA=qAиRAGAffAңAHAQAA(AУAffAϙA  AЏ\Aʏ\A(AHAΏ\A=qAffAУA(AӅAңA(A
=AGAԣA{AӅAQAHA=qAffAGA׮AAQAffA؏\A؏\AzA֏\AHAAGA  AAAA  AمA
=A{AAA33A
=A  AzAGAיAAGAׅAA=qAA
AәA33AA(AzAԸRAQA
=AQA֣AA(AHA(AәAӮAиRA33AϮAzA
=A
=AGA33ApAљAzAHA
AA  AzAՙAA  AzAHA  A=qA\)AיAGAAAzA֣ApA׮AAGAׅAQAأAA
AׅAAA{AffAҸRAQA=qAҏ\ApA{AffAԸRA33ApAGAԣAQAAӮA
A
ApA(A{AԸRA(AԣA{AGA=qA(A{AәAA
=AӮAAAҏ\AQA
AҸRAApAѮAAхAѮA
=AAAљA
A=qAљA33AHAGAЏ\AϙAzAиRA(A(A(AхAңAGA
=A=qAԏ\AԸRAA
=AԣAәA
=AәA=qAҸRAAңAA33AAԸRAԏ\A{A(A=qA(AQAԏ\AԣAHAApAՙAAGAיAיA׮AAׅAיA{A  AQAAQAׅA׮A
A{ApA\)A33ApApAׅAAׅAָRA֏\AӮAAӅAׅAAGA
AQAQA=qA
ApA{A\)AծA(AA׮AGA=qAυAљAA=qAѮAхA{A\)AQAљAAҏ\AAQA
AՙAAӮA33AApA(AAffAQAzA{AԣA33AԸRA33AԣAA  A=qAffAHA33AՅA  A֏\AQAffAffAffAzA  A(A֏\A֣AHAAHAAA
=AA
=AApA\)AGAGA\)AיA
AGAAָRA  AQA  A(AQAծA=qAAA֣AAAA33A
=AA33AAHAffA{AՅA֏\AAffAA(Aԏ\AӮA  AAӮAәApAӅAGAңAAAHAA\)AAHA
=AәAәA\)A\)AљAAAffA(AzAQAѮA  A{AA(AAңA{AңA33AәAffAԸRAԣAAՅAծA  A֣A֏\AAׅA  A{AHAظRAAAffA
AA  AׅApA\)A\)A
AA
AAHAQAA  A֏\A
=AA{AAA\)A\)AAԏ\A{AHAҏ\A(A
=AA
=AGAAzAA(AHAApAGA=qAzA  AAzAҸRA{AA\)A{AzAzAAGAAԏ\AGA(AGA
=AѮAѮAԣAԏ\ApA
AHAAԏ\AA  AQAԏ\AHAAGApAffAAָRAHAAzA(AffAAA֏\AHAHAָRAָRA=qA{AQAAA֏\A֏\A  A
A
A
A
AA\)AA  A
AHAA(AGAAzAQAQA33AQAљAљAAљA
AӅA{ApAA
=AAхAхA=qAHA
AAA
A{AGAѮAѮAffA
=AGAAA\)A
AAAAҸRAHA
AA(Aҏ\A=qA{A=qAQA
=A\)AәA
AGAՅAAHA\)AGA=qAzA
AיA{A(A=qAQAQAzAأAHAAHA
=A
=AA
=A33AA
=AAAأAׅA\)AAA33AHAAHA֣A33A{AzAԸRA
AHAA{AAQAQA=qAхAffAAиRA(AzA(A33AAQAͮApA
AAAffA  A  AAѮAЏ\AHA{AЏ\AAA  A=qAGAәAGAHA\)AҸRA33AхA\)ApAиRAHAУA
AzAA\)A  AzAHApAָRAApAQAzAظRAA33AA{A
AQAQA
A
AٮAٮA33A33AAأAffAQAAA  AָRAA\)AA{AָRAAffAffAAՅAԏ\AffA(A
=Aԏ\A=qAffAAәApAGAA=qAҏ\A
=A(ApAAҏ\AHA
=A
A
A33A͙A=qApA33A
=A͙A33AAͅAΣAAAffA{AθRA{AAAA\)AQAA=qA=qAңApAzApA  AңAӮAәAԣAԏ\A
=A\)AHAHA
=AGAGAAGA\)AGAָRA=qAA(AAAA  A(AffAffAQA  AffAQA
=AA  A
=AHAAGAԣApAA{AQAA\)AQAffAAzA{AAHAHAхAAA33AQAHA
AЏ\A
A
=AHA33AA  AzAHA
=AffAzA33A
AՅA(AAGA\)AA{AzAظRA33AمA
A(A{AAA
AAٙApA33AAAأAظRAHAظRAظRA؏\AAأA؏\AHAAHAQAzApAՅA(AԣAffAAA\)ApA
=A=qAQA=qAAA(A33AQAzA{A\)AHAAzAӮA
=AHAәA=qApAzApAәA\)AυAӅAAffAGA
=AׅAAA
ApA=qA(AAҏ\AGAҸRA\)AQAAծAQA֣AָRAHApA(AأA
=AٮAA{AڸRAA\)AAޣApA  A݅AGAGA
=AzA{AۮApAۅAۙAA(A33A{A
A\)AHAأA=qA\)AHAHAՙAGAQAAGAGA
=A33AՙAAAԣAzAzAԣAGA\)AAffA{A
AAffAHA  A֏\A֏\A33AzAGAיAffAAיAA  A  AQAQA  AظRApApAٮA
AQAڣA
=AۅAۙA
AA
A{AQA
A{AffAܸRAܣAܣAzA
AA
=A=qA(Aڏ\AAAۮAA  A{AۙA\)AۙAAۮAAA
=AۮAAAAA  A
AAمAAffA׮AA
=A\)AGAA
=AA33AQAA=qAAָRAA׮A{A
AAAظRA\)A33AٙA  AٙA
AQAHAHA33A\)AA=qAAffAQAffA{AHAHAۮAAAQAݙA=qAHAApA߅AA(A(A(A  A=qAffA\AA\AQA(A=qA
AߙAffAQAAffA(A{AݮA(A33A33AAA\)A
=AܸRAQA
A=qA(AܸRAܣAzAۮAA33AffA  AGAGAQAۙAffAۙA(AAڣAzAzAڸRAQAAAۙAۮAۙAffAQAHA\)A33AۮA
=AzA=qAQA  AAظRAHAٙAQA  AHA\)AۅAQAffA\)AzAޏ\AzAݮA  A(A{AޣAHAAA
=AA33AHA޸RAzAQAzAGA܏\AGA
AAٮAAffA
AHA
=AzA=qAܸRAݮAHA{AffA
AۙAۅAA  AffAQA=qAffAHAA
AAzA\)AA
AffApApApAffA=qA=qA\)AAAQAzAA\)AיA֏\AA\)A{AQA(A\)AA
AAA=qAأA{A=qAظRAA33AمAٙA{AffAAAAAHAAAۅAAffAApApA
A{A(A{AAݙAݙAApAzA=qAHA(AۅA33A
=A33AڣAzAffAAGAAffAܣAݙA݅AיA
=AAA׮A33AHAAA=qA(A33A(AٮAٙAأA33AָRA؏\A(A֣A{A
AׅAׅA
A  AzAٙAAQAڣA33AڣAٙAGAzAA׮A؏\AAՅA\)AAӮAԏ\AGA(AA
=AA(AظRAAApA
AzAA{AۮA=qAHA
=AݮA  ApAܸRAQA
AffAۙAAQAffAۙAAzA
=A33A
A(AAzA\)AzAۅA{AHAAAۮA(AظRA{AۅAݮAۅA
AA޸RA  A\)A(A=qA܏\AHA{ApAңAHA{AظRA
AAGAffAApAۙAffAܸRA
AzAAGAA\)A
=A33A
=AA\)AQAAA(AffAأAzAAمA  AڣAApAA=qAzAHA
=AAA33A
=AAffAffA(AzApAݮA
A݅A{A33AHAܸRAܣAGAQA܏\A܏\AܣAۮAݙAzAܸRAQA
AۅAA
=A=qAڣAAAzA(AݮA  AGA{A(A(A{AHAzA33A33ApAffAأAA  AzAAA  AAأA  AHA  AۮAA\)AۅA
=A
=AڸRAHAAڣAQAظRA؏\AzA  AיAGAأA(A֣A  AHAA=qAAHA(AظRAQA
A(AAQAA  A=qA{AffA؏\A؏\AzAHAHAffAffA=qAA33AۅAQAܣAָRAݙA܏\AGA
=A\)AۅAA(A
AٙAA=qA=qAݮA
=AzA
AڣAzA(A{AA֣A33AAGAQA
=A\)AGA
AHAzAA
AAAAυAϮApA33A33AQAAQApAHAzA{AA\)A33A=qA\)A33AGAׅAAffAHAffAظRAظRAأA{AأA33AApAffAHA  AأA׮AיAAHAQAffAָRA33AׅA׮A{A(A33AHAۅAzAۅA
A
=AffAQAApAA
=AAA
=A؏\AzAffAׅAffAGA\)A׮AظRAAffAffAיA\)AיA׮AיAׅApAAA=qA=qA  A؏\ApAAׅAA\)AA=qAA
=AӅA\)AәA
A  AGAAԏ\AzAԣA=qAzAծAHA֣AAיA  AGA\)ApAۅAzAHAڣA(A  AٙAGAzA؏\A33AzA{AzAzAQA؏\A  AzAQAأAA
=A=qA\)A{A33A  A33AۙAAApAAHA
=AA(ApA؏\ApAQA֣AQAHA33A
=AAHAGAQAAأA  A؏\AffA(AffApApAٙAGAAAمA
=AיAA{AمA33AA
A؏\AA\)AۙAffAA݅AAݮA(AA
=A߅AߙAߙA(A  AA  A  A(AA߅A\)A33AAHAޏ\AQA=qA  A  AGAܣAA=qAHAAݮAAAA\)AGA݅A݅AAGA\)A33A
=AܸRAHA33AܸRAQAAٙA׮A\)A33AظRAHA  A\)A֣A(A֣AA=qA(AQAAffA  A(AzAzA=qA
=A
AHAمAQAGA33AA  A=qAQA(A\)A\)AQAיAAAܣAA(AAGAQAA݅A݅A݅A݅AAAA܏\A
AڸRAQAٮA  A(A(A  AQAۮA{AQA(AܸRA܏\AAAzAHA33A33A܏\A܏\AAٮAمA33A\)A؏\AڸRAڏ\A  AAA؏\AffA  AzAظRA؏\AAffA؏\A
=AأA
=AٙAA
A  AָRA(AׅA
=AHAHAأA  AAzAA
A{AHA33AمAHAڸRA=qAۮA܏\AAzAܣAzAܸRAAHAApAݮApA݅A\)A݅ApApAݙA
=A(AAA
=AAAAAGAݙAA
AޣA=qAޏ\A(AAGAHA܏\AzAzAAܸRAۮAQAGAۅAڸRA  A{A{AA{A=qAffAffAمAzAAڣAffA
=A{AffA{ApA\)AGA\)A\)AAڸRAAHA
=AAAAffAA=qA׮A{A֏\A  A
=AAQA=qAҸRAӮApA(A(AәAffA׮A  A׮AAظRA\)A(AAHA\)AGA(ApAA  AQAQAzAޏ\A=qA
A
AݙAQAܸRA݅AܸRAܸRAܣA܏\A
A33A=qAAGAA{AA
A޸RAHAAzAHAffA=qAA  AݮAݮA
A
A  AA\)A\)AA\)AݮA
A  AAAA
=A܏\A  AܣA33AA{A؏\ApAAAA(A  A
A{AQAܸRAQAzApAۮA=qA  AQA  A
AA
A޸RApAffAHA߅AzAAGA
A  A{A  A{A{AAܣA(A(AݙA
=AQAۮA  A\)A  AGAAAHAGAGAHAAzApAGA\)ApA߮AApA
=A=qAۙA{AمAأAA؏\AA\)AAA  A(A=qA؏\A{A33ApA؏\AAA
=AAA(A
AAAظRAAיAׅAA֏\A
AGAHAڣA33AGApA(AۅAApAA
=AGA{Aޏ\A{AA=qAޣAAAzA(AffAzAffAGA(A߮A\)AAHAAQAzAAQApAݙAݙA܏\A
A=qAffAAQAݙA33AAA{Aڏ\AA
=AHA
=AHAffAQAQAffApAיAQA(A؏\AHApAָRAQA֣A33AׅAAAzA33AffA=qAיA\)A(AיAAAA{AQA=qA׮A֏\AA֏\A׮A\)A(AAA؏\AظRA33AGA
A
=A
=AQA(AzAمA
AAGAHAڏ\AGAA
=AڸRAٙAzAA
ApAA֏\AծAzA33A
A(AԣAAڏ\AGAffA  AAڏ\A(AAHAGAمA\)AGAA  A
A=qA\)Aڏ\AڸRA
=A33A33A
=A  AffA
ApAHAQA\)A=qA{AA=qA
A33AffAHAمAAڏ\AffA{AGAAAzAHAA֏\AHAAָRAAAApA=qAծAAԸRAQAAՅAծAQA33AׅA(AأAAأAffA=qA\)A؏\AQA33AGAٮA  AffAQA
AffA  AAظRAA\)AAA  AיA{A33A\)A׮A
=AGA
=AHAAՙA
=A\)AzAA\)AGA33AQAA=qAffA{AAծA33A33AAHAAA  AAAzApA=qAԸRAQAQA
AA
=AA֏\AׅA֏\AAffAQA\)AA
=A(A
A
=A֣AffA֏\A؏\A\)AٙAٮA{A(AڸRAAGAۮA(A33A݅A(A
AA޸RAAAA\)AA=qAޏ\AffA
A  A
=AzA
AۮAGAAffAQA  AٙA{AAQAAHAۮAQAܣAffAzAHAzAۮAיA\)AA(AQAQAAAAٙAGAAAzAׅA\)AHAأA׮AHA\)AffA؏\AظRAGA(A\)AA=qA
A
AծA\)AzAHA؏\A(A֏\A(AffAHAffAHA
A=qA{AAAQAzAA(A{AظRAٮA\)AمA=qAQAڸRAAAۮAAffA  AzAظRAAׅAAQA
=A=qAڣAAڏ\AAAأA(A=qA܏\A=qA=qAأA
A
AA֏\AծAծAGA33A(A{A(AԣApA\)ApAՙAAQAA=qAԣAәAA  Aԏ\A(AGA؏\AHA֣A׮AAAAffA
=A  AAA\)A\)AAՙAzA
=A=qApApAӅAҏ\A
AA
A(ApAAA=qA=qAzA(A  AԣAApApAA(A{A{AծAՅAԣAԏ\ApAA{A{AHAمAمAٮA
AA  A{A(A  AAٮAAיA33AAQAzAQAՙAѮAffA  A
AAңAAԏ\AAAA{AԸRAffAAՙA
A(A  AՙAGA\)AՅAQA֏\AՙAAָRAzAA֏\A  A{AffAA(A(AQA{AأAمAٮAA  AڸRA  A=qAQAۙApAffAܸRAAzAQA=qA=qAA
AAQA(AA
AٙApAمAٙA܏\AzAzAA33A
=AGAۙA
AA{A  AܸRAܣAܣAzA܏\AܸRA
=AܣAܸRAܸRAAA܏\A{A{AA{AGAأAzAHAGAQAHAڣAAAApA\)AڸRAۮAۅAAٮAڣAHA\)AۮA  AzAڏ\AAzAHAۙA{AA܏\Aڏ\A=qAA=qAܸRA܏\AAGAAޏ\Aޏ\AzAAffAޏ\AޣA33AA\)A߅AA=qAQA=qA\A=qAzA
A߅AGAAߙA\)AA߮AޣAAA33AHAffAݮAAAݙAQAA  A܏\AffA{A(A܏\A=qAffAHA  A=qAܸRA
AHAzA  AAٮAA(AQAQA
AAA(A\)AׅAAA
=A\)A׮AA=qA{AظRAHAA\)A؏\ApA(AzAHAظRA؏\A(A
=AأA=qAٙApAGAAzAڣAApAA(AffAAHAA33A
=A
=AApA݅A\)AA33A33A33AAAAܸRAܣAܸRA
=AܣA(AQA=qA  AۅAAۅAQAAڣA  A
=Aڏ\AAQAAzA\)ApA\)A33AA
=AAأA=qA؏\AffAAAAQA{A(AQAQA؏\AzA(AHA{AծAzAffA  A
=AAA֏\AHAAՙAӮA{AA֣AApA(AApA=qAڣAAAۮApAۅAAHA\)AA\)AA
A  A  A{AۙAHAڸRAڸRAzAڏ\A=qA=qAمAظRAHA\)A
A
AٙA\)A\)A33A
=A\)ApA
=AAA33AٙAمApA
=AzAQA׮AHAأAA
=AAGAGApAAڣAQA؏\A؏\A\)AzAApA
AQA\)A{A
=A
=A{A׮A  A\)AAQA  AA  AHA\)A֏\A=qAA(AՙAA  A(A  A
AAA  A33A
AָRA(AA؏\AمAڣA  A  ApAܸRA\)A33ApAݮA
A
AAݙAA
=A
=AAAHAA܏\AzAܣAܣAܸRAffAffAܣAܣAܸRAәAA\)AGAA=qAffA
A{AffAffAAQAAffApAA؏\AAGAA؏\AAQA(A{AمA  A33A=qA33AӅAՅAGAHApAׅA\)A؏\A  A33A؏\A؏\A(A\)A
Aԏ\AGApAzAQAٮApAzA
=ApA  Aڏ\AУAHA
=A\)A׮A  A؏\AQA33A(AA  A=qAAAA(AffAAAzA
=A{AׅA؏\A33A  AQA{AңAأApAծA
AծAԣAA  A33A\)A=qAHAAA(A
=ApA(AΏ\A
=A
A(A(A
=A
AυAϮAffAHAУA=qA
=A33AGApAA
=AңAA(AӮAңAffA=qA  AңA=qA33Aԏ\Aԏ\A(AGApA=qA33A׮AיAA֏\AAҏ\AԣAAA  Aҏ\A
=ApA  AA
AָRAՙAA
=A\)A33A
=AAԸRA
AA33AffA{A
=AHAQAAиRA  A  AffAAхA33ApA
=AхAAA{AЏ\A\)AA  AAQA(AA\)AQAA
AңA  AЏ\AzAGAУAGAAA=qA33AAәA{AAGA(AAA=qAQA׮A=qAffA؏\AHAHA{A33AAAzAA  AzA(A{AA=qAAۮAQA{AA33A
=AڸRA  AAffAAAٮA
=A׮A֏\ApAAAԣAzAA=qAHA܏\A=qA
=AۅA  AۅA
=A
AͅA(AٮA؏\AzApAA֣AٙA
=A  A{AA
A֣A
=AA=qAHAA=qAٙAAA׮AHAAAڸRAڣA
=AA(A  AHAHA\AA=qA޸RAARAffA{ApA\)A33A߮A(ARA=qA=qA(A  A(A(A{A  A(A=qA
A  AGAA  A33AHA
=AۅA=qAAڸRAQAڏ\A\)A(A33AffAQAظRAظRAzAA׮AHAQAՙA{AffA\)AיAՙA׮AAQA
AHA(AA{AffAQA֏\AՙAQAffAָRAAGAׅA׮ApAׅAHA33AיAAיA33AzA{AA׮A
AأAظRAAظRA׮A׮AظRAٮA
A33AffAQAA(A(AGA
=A{AAAA  A{AָRAQAAA֣AQA(A{AAԸRApA33A  A=qAAA33AA֣A
AA(A(AGApAA
Aҏ\A  A{AzAљAAQA
AA
AA=qAAAA
=AApAA׮A  AأAظRA
AffAAGAA\)ApA=qAܸRAAݙAA  Aޏ\AffA޸RA
=A\)A{AޣAA
=AAHA޸RAHA޸RA޸RAޣAAAHAAHAA
=AAA(AGAAffAA܏\A܏\AܣA\)A݅A\)AܸRA  A܏\AzAAzA܏\AAApAڏ\AHAAQA׮AAHA
=AۮAffAأAzA  AQAAzAAAAffAQApA(AzAڣAffA
A{AHAQAffAAQAzA
A
=AAzApA  AQAޏ\A33A߅AAffA(A=qAffAA߅AffApA\)ApA
AHA(AAܣAޏ\A(ApAAA
A=qAظRA
AAAQAAA؏\A  ApA׮A
AffA33AQAHAzA
A33AأAظRAׅAA\)A(A׮AԸRAGAיAAمA
AAٙAApAAAA=qAڏ\AׅAHAڏ\AHAAڸRAzAۅA׮AHA33A\)A\)A(A\)A(A\)AٙA(A
=AAمAAمAAAظRA
A
=AHA
AיA33A=qAffA=qA=qA(A{A  ApAA
=AظRApAAAHA{AأAظRA  A{AA  AffAHA33A֣A֏\A֏\AAzA(A{AAGAGA33AGAA
=AAAHAHAAGAHAծAAAHAԣAՙAծA֏\AQAQAffAAA\)A\)AՙApAAԏ\A(AԣA  AHA֣AA33AׅA=qA׮AA(AQAzA؏\A؏\AffAأAHAHAHAQA\)AffAأAGA\)AAAGAGAٙA\)A  AٙAGAAمAٮAٙA\)A33AA33A33AA
=AHApAA33ApAAٮA
AAA
A؏\A֣AAՅAAA
=ApA
=AӅAA  A{A
=A֣AՅAAAأAAHAffAٮAQA=qAffAمAA{AAQA=qAQAQAQAHAظRAمAA(A=qAHAGA\)AۙA  A=qA=qAzAffAffAzAQAAۮAGAffAڣA=qA=qAAAAمA  AzAHAHAAGA=qAzA؏\A33AA(AأA(AffAffAffAٙA
AHAzA=qA
=A=qAAHA
=AffAمA(A
AAA  AAAיAHA  A33AٮA  AA=qAHA=qAظRAQAA{A33AۅAHA33A\)ApA=qA=qA(AAAܸRA=qA{AffA\)A
AGAQAAAׅA33A
=ApA{A  AzAأAٮApA{AٮAffAAمA\)AٙA  AڣA  A  AA(AHA(A  AA
=AAAܣAAHAAAڣA=qAHA܏\A{A׮A(AQAיAHA
AA(A؏\AأAQA؏\A؏\AظRAAAAAzA(AAffAGA=qA
A(AQA  A֣AffAAA33AٙAAAۙAQA{A{AzA
=AٙA{AzAHA\)A
AAzAHAAAGA݅AGA
=A
=AA݅AݙAݮA݅ApA{AܸRAApA\)AA܏\AzA܏\AffA܏\AQAۅA
A33AٙAأAծAיA{AQA
AA=qA܏\AܸRAffA\)AQAzA
A
AAݙAۙAA
=AGAڸRA33AۙA
AA{AzA  A(AAzAڸRA(AAA\)ApAA\)AQAAGAAۙAffA܏\AܸRAHA33A\)AGAAܸRAHA\)A(AQA  AAA
A{AQAQAܸRAAݮAGA\)AHA33A޸RA33ApAߙAA߅A
AߙA=qA{A߮AA  A{AA{A  AߙA߮A\)AܣAffAۮA
=AGAQA
AۮA  AۮAڸRAQA\)AAۅA(A\)AffAAڸRA(AمA(AڣA33ApAٙAA
AA
A\)A
AٮAGA
=A
=AAڣA  AGAأA
=Aڏ\AٮApAffAffA
=A
AڸRAۮA=qAA=qA܏\AHAܸRA܏\A33ApAݙAA݅A݅AAߙA߅A  AA޸RAffAޏ\AޣA݅AݮAzAApAۙA33AڸRA{AzA=qA{A{AA(AA
AׅApA{A=qAffA܏\AzAAHAA
=AHAGApAڏ\A\)AA{A
=AAzA\)A׮AffA׮ApA  AAAۮApAGAApAffA֣AQA33AٙA  A(AGA{A{AGA؏\A׮AApAمAffAAAיA\)AיA׮A33AיA{AGAAffA=qAA  A  AܸRA
AAۅAAffAAQAffApAAGA{A
=A׮AٮA(A  AffA
AAffAA\)A
=AծA33AQA{AծAHAzAApAA(A؏\AAAAAAAQA=qAA33AԸRAGA  AzAAffA
A
AיAQAzAمAAHA{AڸRAAAffAAAӮAԣAәA=qAAHA\)A(AأAGAzA
=A
A܏\A(AڸRAڸRAzAzA=qA=qAffAمA(AAA
A׮A؏\AAffAA=qAڏ\AzAApAۮApA{A=qA=qAzA{A\)Aڏ\AHA
AݙAڸRAۅAGA\)A\)AAA  AAffAQAHAHAApAHA=qAA  AzA{AՅAՅA(AAAA{A  AffA(Aڏ\AAffAzA(ApA
A\)AQA׮AzA  AzA=qAzAHAA(AA=qAAڸRAAۙAA(AffAܸRAA  AzAA
=A(A\)AޣA޸RAzAHAޏ\AAGAAAAޏ\A
=AzAzAA  AzAAٮAۙA
=AzAQA33AHAGAA=qApAٮAAGAHAGAׅA{AՙAծA(AׅA֏\A׮AffAffAأAمA33AظRA\)AGApA
A{AA(AA
=AA  AAGAٙApAA33AHAAظRAٮApAٙAQAA=qAAڸRAHA\)A=qA  AۙA  A߅AQAܣAA33AAA\)A{A{AݮA
=AAHApA(AۅAzA
=A=qAA(A܏\A  AA(AۮAA=qA
AAۮA݅ApAHAAApA33AGA߮AAܣAAڏ\ApA(AיA33AיAApAGApA=qAGAڏ\AڣA\)AHAHApA\)A
A
A{AمAAGAA{AAAۮA33AۙAمA(A33A܏\AAA33AڣAڏ\A\)A\)AffAHAA=qAA
=A\)AA
AA\A33AA{A(AAQAGA
=ApApAHAA  AAA(AߙAAAAޏ\A(AGA33AA  AAڸRAڏ\AٮA=qAHAٙAAA
=AAAGApA؏\AיAAיAGAGAAمAAָRAA33AӮA  AA33AGApA
=AzA
=ApAA؏\AQAffAA
=A\)AٙA
A{AffAffAAGAۅAQAHA
=A33A
AA=qAzA޸RAHApA(AffAHAAA
=AAAAAA{A=qAQAffAffA33AQA޸RA(AAGA=qAHAۙAAAAۅAHA
AۮA=qAAQA݅AݮA{A{A  A{AA޸RA
A  A
A
AߙAGA
=A33AA(A
AzApA܏\AݮA=qA(AA(A
AA=qAzAܣAܸRAffAffA
=AQAڣA(AA܏\AA=qA(A{AQAأA޸RAA\)A߮A{A=qA{AA߅AAޣAޣAzAzA
=AzA߮AzAAAAAAAߙAGA33A߅AzAA=qApA
=ApApA\)AڸRAzAAۮA܏\AޣAޣAHAAffA
AffAffAٮAGAA܏\A\)A(AffAA
A  AۮA(A
=A݅AݙA{A(A޸RAAApAffAޏ\AGA޸RA33A=qAQAۙA\)AޣAޣA݅Aޏ\Aޏ\A  A(ARAGA\)A{AAHA33AA(AAAApAAA(A  AA  A  A㙚A
A
AA\)AHAGA\AHA33AAApAGA33AQA  AA
A(A
=AAA  A޸RAffAٮAڸRAיA܏\A(A\)A=qAGAAAApAۮAzAۙAAAzA{AAAAۅAۅAAHA܏\A݅A33A
AAQA
=A  AQAA{AA  A{A\)A33A{AۙA33AۅAA  A  AffAܸRAAGAݮAAzA
=A߅AAARA
A{A33AAA(A{A
AGA
A
AQA(AffAޣAA߅A߮A(A(AGA
ApA\)A33A݅AAGAA=qAffAA33A33AA33A\AA\)A\)A=qA޸RAܣAAffApAAA\)A
A(A
AGA=qA߮AAݮA
=AAڸRAA݅AAzAzAHA{Aޏ\ApA
=A(A
=ApA{AܣAۅAܸRAAA\)A33AzAݙAA33A=qAݙAAffAޏ\ApA\)A  A\)A  AQAAzAA=qARAۙAۙA(A=qAQA݅AA  AGA߮AAQApAQAA\)A33AңAҸRA\)AՙAԣAԣAՙApAՙA
=A33ApAQAA
A֣A(AA֏\A\)A(AأAՅA  AӅA\)AAӮAԣA
=AzApAָRA(AzA
A(AA{AҸRAA
AAՅA=qA(AڸRApA\)A  AzA(A
=AAAAAݮAݮAA݅AݙA{A(A݅AAޏ\A=qA(AݮAAHAAGAAۅAGAA  A33AAܸRAGA  A(A  A
=A  A\)AA(AffA  AӅApAHAzAׅA׮AzAأAGAAٙAمAڸRAA(AzA
A(AՅAAԣA׮AffA{AQAϙAffA(AծAAA  AffA33A
=A(A\)A\)A33AAAAA̸RAQAQAˮAffA\)A\)AHAAGAӅApA
A33AљA
AУA\)AУA
=AGA33AA33AHA
=A\)AGAA(A(AAHAAQA(A=qAGA\)AGA  A͙A
AΏ\AGAˮAA33AHA(A(AAʏ\AzAGAQAͮA=qAQAиRA
=AHA=qA\)AAAAHAGAGA33A=qAѮAҏ\A
AQAHAA=qA
AQAA˙AˮAA  AffAHAA
=A33AΣA
AHAffA{ApAffAυA=qApA
=A  A=qAA(AGAHAԸRA33AAиRAffAиRAAѮA=qAAAУA(A\)A{A
=A
A
AHA\)A\)A
=A(A(A33A33A\)A  AңA
A=qA=qA  Aҏ\AGAϮAθRAУAУA
=A\)AzAԸRAHA
ApAԸRAzA33AHAϮA
=AApA{ApAzAzApA(AffAffAхA33AAffAA{A
AffAHA\)AAA=qAAffA\)AҸRAGAӮA=qA(A\)A
=AHAԏ\AffAԸRA33A֏\AzAzA
=AׅAHAA
=AAAA֣A
A33A\)A33AԸRA33AAҸRAzAffAA
AHAυA  Aҏ\A{AQAAיA  AA
=AHAA؏\AAָRA
=AծA׮A\)A(AљA33AA
=AA\)AffAѮA\)A
=A
AѮA
=AffAGA  AQAAҸRAԸRApAQApA{A{AzA  AApA{AՙA(ApApAхAGApAA{AңAGA=qA  AиRAAѮAffAҏ\AA
AzA(A  A(AԣAAԏ\AzAԣAӅAA{AQAљAҸRAGAҸRAQA33A(AӮAAQA=qAAApA=qAAGA=qAЏ\A{A\)AAҏ\A\)AиRAУAffA\)AңA
A=qAAϮAиRAљA
=AQA(A\)AA  AәAzAA
AԣAAՅAԣA=qAҏ\AљA(A
AҸRAҏ\AGAHAAҏ\AծA=qA
ApA֏\A
A
=A\)A  AAGAۅA
A{A(A܏\AܣA
=A
=ApAݙA݅A
=A݅AݙA݅ApAAGAA=qA=qA  A(AzAA׮AAHApAQA  A֣AAA\)A
AA
=AffAԣAzA{AAAA
A=qAҏ\A
=AHAծAA֣AffAA{AQAHA33A  A؏\AA(ApAQAApAٮA{AzAٙAAٮAHA
AffAQAQAAAҸRAҸRAA  AAԸRAAHAԸRA(AAA(A(AAՅAGA{A֣A֣A֣A  A=qAA=qA=qAA\)ApA{AAAAffAA{A
=A33AGAAָRAAQA
=A33AQA33AԣAָRAffAAظRA؏\AHA(AיAQA(A=qAAffAffA\)AՅA
=A=qAQA\)AԣAՅAA
=A
A  AיApAA{AԸRA
=AAAGA
AمA؏\A؏\AHA{AA
AA{A\)AQAۙAۮAA\)AݙAHAAzA
AAAݮAݙA\)AA{AApA33A\)AA\)AݮApA(A(ApA
=AGAܸRA(AޣAޣAAۅAٙA33Aޏ\A(AAAHAA޸RAAA܏\ApAܸRA
=A݅AA
A
=A
AffAA\)AٙA=qAA؏\A(AzAApAՙAAA  A{AٮAHA33AAAۙAGAAڸRAAApAڸRAGA
AAAQAAܣA\)AGAApA
=A\)A33AݙAݮA  A(AGAޣA=qAzA
=AA
=Aޏ\A݅A(A
AQA
AHA\)A  AAA
=AٙAٮAQAA  AڸRAQA33A=qAzAڸRAڏ\ApAأAA(A
=AA(AGAA  ApApAׅAQApA  A{A
A  AָRA\)AAAffA=qA=qA\)A  AA(A֣AzA(A  AGAיAA(A(A33A֣AָRAAԏ\AӅApAA\)AGA
A{A֣AAAׅA  AffA  A  A
A  A{A  A{A֏\AzAAׅA؏\A(AظRAHAظRA؏\A؏\AAAA
=AzAծA
A{AӮAңAzAAA
ApA\)A33AԸRAӅA33AQAA(AAAҏ\AУAGA
AAHA(AхAҸRAиRAϙAAЏ\AzA\)A˅AAA
AυAAңAЏ\AϙAA\)AAУA=qA\)AңAHAѮAѮAУAAQA33A=qAGA(A
=AHA׮A׮AAA(A؏\AzAיAHAיA{A(A{AA  A{A(A؏\A=qAأAffA  AAمAAأAأAٙAAffA{AA=qA׮A֣A=qAԸRAA=qAHA
A
AΣA{AGAͮAAԣAAAׅAAϮAAAәApAәAԏ\AGAA{A׮AzAzAՙA\)AAAAHAӅA33AԸRA=qA
=A=qA֣A
=AיAzA
=AHAمA\)ApApAمAA  A  A{AAAAGAAAA  A  AffA{AAڏ\A33ApApAиRA33Aҏ\AAхAљA
=AzA=qAzAQA
=AAәA(AffAA\)AGA\)AGAظRAzA
=ApApApApA33AAHAAظRAׅAA
AיAՅAHAffApAHA33A  AظRAAAQAQAffA\)AffA\)A33A
AҸRAӮAGAAffAӮAљAA\)AzAәAָRAA  A
AљA33A(A{Aԏ\AAԣAAffAHA(A
AԸRAQAzA{AGAQAӮAffA  AffAԣAԏ\Aԏ\ApAApAAAAHAA{A{A=qAיA{AA\)AAA(AA(A
A
AAٮAٮAٙA\)AAأA33AظRA؏\A؏\A
=A\)A(ApAGA  AzAمAأA
=AA(AՙA\)A  AA
=AHAGA33A33AAApAәA(AA
=A֏\AָRAGAGAA׮AQAffAffAGA\)A
A  AffAHA\)ApAAQA{A{AۅAHA
=AffA=qAAzA33AA  AAQAڸRAڣAzA=qAA33AمA=qA\)AٮA33AAظRA33A{A׮AA
=A(AԸRAծA׮A؏\AzAأAA֣A33A
AQA
=AיAAzAHApAٙAAAA=qAffA(A׮A؏\A=qAAA֏\AGA\)AA
=A֏\A  A  AأApA
AQAڸRAAۙA  AܸRAHAAGA݅AݮA
A33A33AݙA݅ApAݙAGApA\)ApA{AݙAݙApAݙA݅AAAAQA{AQAܣAffA  AݮAAzAGAߙA
=AݮAݮA\)A܏\AAA=qAQAGAٮAۙAܸRA
AܸRAA
=AA\)A\)A
=AGAA
AAAAAQAA{A؏\AzAޣAݮA\)ApAzA33AA=qAܸRA
=AHA\)AٮAffA
=AۅAffAGAAޏ\Aޏ\AGAffAGAߙA  AHAAAA=qA=qAApA
=AAޏ\A޸RA߅AApAA
A  A=qA{A\)A\A=qAGA=qAAzAAQAGAApA(A߅AݙAA  AٮAڏ\A(A\)AAzA
=A܏\AܣAݮAGAA=qAޏ\AzA33AHAAڏ\A  AۮAHA
AHAzAQA  ApA  AzAHA
=A؏\AڸRA33A\)AGAڸRA{Aڏ\AGA{A=qAzAHAۙAGA
=AܸRAAݙAQAAAGApAApAffAHAGA\A߮AߙA߮A
=A޸RAA\)A\)A\)AA߅A߅A
AQAAݙAzAۮAzAzAAۮAAzA  AڸRAA  ApAGA(AAQA(AGAQA(ApAڏ\AٙAAGAAGAA֏\A{A{A{AA\)AۅA=qAיAA\)A  AAA
=A  AQA
=ApAffApA  A{A(AffAAAۙA  A{AA=qAܣAGApAAA33A\)A(AGAݮAݮAݙA݅AAA  AݮA
A(A(AffA޸RAݮA  A(AA33A\)A߅A\)ApAߙA߮A߮A  AQA߮AGAߙAffA
AQAAHAAA=qA\)A  AAיAޣAݮA\)ApAA{AApAGAQAAHApAԸRAAA(AAffAA(AۙA\)AۙAA33A
=AAHAޣA33AA=qAAAᙚApA\A=qARAA{AHA=qAQA\)AAݮAHAܸRAܣAۙA
AߙA
A߮AAA\AߙApA\)AAAAAܣAzA=qAAܸRAA\)A33AGAיAA33AمA  A܏\AAHA{A(AAAڏ\Aڏ\AڣA
A(AzA
=A\)ApA܏\A\)AGA
AA  AA  AۙAAAAARAARA=qA  AA߮AHA  A
AffAGA
=AHAޏ\AAA33A
AAAQA\)AzA(A=qA33AHAAAA߅AGAA
=AzA=qA{AAݙAAAGAAܣAׅA(ApA
AӅA(AӮAA(AظRAA֏\A  AAA
=AzAՙAA\)AAAA
=A  A{A=qAQApA  AAQAA  A33AAA֏\AA\)AffAAٙAffAA
AܣAA33AݮAݮA
AݮApA\)AA33AAܸRA33AHAGAHAAHAA33A
=AHAۮAۅAۮAA݅A(AQA
AۮAAGAڣAأAڣA(AAAٮAGAGA؏\AGAA\)AQAA{AAGA{A
=A
=AծA(AԣA(ApAQAzAHAأApApA  A{A(AA  AA޸RA  AGAHAGA
=AծApAHA33A=qA(AHAڏ\A\)AۅA{AܸRAHAA
=A޸RA(A݅AݮA  A33AGAAffAHA(A  A33Aޏ\A{A(A
A=qA  A=qA  AQA߅A݅AAAݙAffAzAܣAApA\)AA33AzAۙA=qA{AܣAHAٙA
Aڏ\AۙA
AAApA
=A֏\A\)A{AzAA
=A{ApA=qAQAHA{A\)A\)AۙAA(AՅAHAzAӮAGA  AծAיA  A=qA(A(AڣAAGApA=qAzA
=A=qAޏ\AffApA  AAAޣAޣA=qA
AAQA{A{A=qA(AApApAGAޏ\AAA
=ApAHAA\)A{A
=AAۙA
A  AffAGA=qAۙAAA=qAQAffAٙAAAأAA
AAzA؏\AA=qAA=qA\)AׅA=qApAمAHAApAAQA
AzAծA33A33AHAAңAffAAGAӅAA(AԸRA  A(A=qA֣AׅA׮A؏\AAڸRAA33A
=A33A
=AAڏ\A\)AAיAzAAڣA
AAӮAffA=qAGAAAHA
=AGA
A  A=qAمA(AHAԣAָRA\)AA
=AՅAzAӅA=qAԏ\A(A(AծA{AA
Aԏ\A\)AffA33AA=qAәA=qAAәAҸRAиRAAGAӅAzAAՙAAA  AffA  A
=AA=qAԣAԸRA=qAԣAAԏ\AQAQA=qA=qAzAAָRA֏\A33A\)AׅAיAffAAAAQA܏\AAApAՙAzAԣAAӮAУA  A
AzAHAָRAAffAՙA(AӮAffA\)AA
=A33AՙA
A؏\AٙA=qAQA֣A\)AHAԏ\AA
ApAΏ\A=qAzA\)A\)AGAQAQA(A  AA\)AffAծA(AAAAңAQA=qAAAՅAGA33AׅA׮AׅAHA֣A  A33AA=qA=qAHAAٙAAAHAܣAA(A
A(Aޏ\AzAޣA\)AޣA
=A޸RAffAA݅AffAGA
=AAܣAظRAңAA33A֏\A=qAٙAQAڣA=qA(AظRA{AAԣA
AٮAQA{Aڏ\A\)AۙA=qAffApAҸRA(AAHAA  AGA؏\A(AٙA33AAڸRAA=qApAA\)AAGAHAGA֣AՙA\)AӮA=qAQAA\)AAffA33A33AӅA(AָRA{AAمA  AffAٮA(AۙAffAzAzAQAۙAۙApAGA\)AۮA\)A
=AAAGAGAA
AظRAQA\)A
=AڣAffAڣA
=A33AڸRA
AָRAQA(AمAAָRA33A\)AיAׅA{AA
=AٙAffAAٙA\)AڣAڏ\AAApAظRAA33A  A׮AHA\)A֏\AA  AAAApAڏ\AGAڸRAڣAAۅA33AGAAA\)Aڏ\A33A
AأAڣAڸRA\)A
AGAzAAڏ\AۮAA=qAAA؏\A
=AffAAظRAAAAAمAHAڸRA=qA
A{A
AApAAAمAAGA  ApAffAمAApAأAAffAA؏\AHApAGA{AأA׮A33AظRAQAأAA\)A{A  AׅA؏\AA
=A֏\A(AAծAAAՅA{A=qAAָRAָRA{AA=qAHA  AծAԏ\AAffAQA  AأAظRAGA
Aڏ\AHAAQA
A׮AׅA׮ApAՅA
A֏\A֣A{A{AAAمA\)A\)AQAAffA\)ApAAGA
AA33A33A
=A(AA
=AGAGAA
=AGApA\)ApA  AأA  AffA=qA=qA=qAAAظRAGAzAAzA؏\A33AA=qAQA=qA(AԣAHAGA=qAzA{AQAQAӅAѮA\)A33AffAA=qAffA֣A
=A
A
AԣAGAAיAָRA(AمA{A{AׅA=qApAA{ApA֏\A=qA
AffAՙA
A=qA33A{AAAQA=qA
A=qAڏ\A
=AHAۮAۮAHA(A\)AAܸRA
A  AGA{AۮA  A(A33A
A=qAٮAA  AA=qAA{A=qApA{AA(AffAA{AQA\)A\)AAAՅAQAzA֏\A\)AHAHAAA33AAA  AzA{AAأA33A  A33A
=A{A  AAܣA{AHA33A(A{A=qAAۙApAGA
=AAQA(AQAٙAffA  AffAAAAQA
A  AHAۅAHAAAAڏ\ApAۅAAAڣAffA{AQA  A{A{AAٙApA
A
AA  A{AٙAAHA{AمAٙAٮA  AԸRAffA33AծAA33AAzAٙA
AHAAAA֣A33AzAأA\)AffAظRAAA
A׮AHAA  AA=qAAQAԏ\Aԏ\ApAzAمA؏\AיAAHA=qAٙA؏\AHA33AAڣAڏ\A
=AA׮AGAA{A֏\AA\)AԸRA\)A
Aԏ\A(A{A(A  A=qA  A=qA  AGA=qApApAЏ\AzAAGA  AӮAAУAffAA(A
AGAAQAA  AGAA33AQAHAAGAzA=qAՅAAHA=qA=qAҸRAAGAәAAAAAңAffAAңAAGA\)A{AzAԸRA33A33ApAՅAHAԏ\Aԏ\AzAQAԣAAԣAԏ\A
AљAAzA
=AffAQA  AAӮA\)AҸRAҏ\Aҏ\Aҏ\AҸRAGAHAffA(AAAAA(A(A  A\)A
=AAAЏ\AЏ\AυA  AЏ\AAиRAGA
A\)AиRA\)AиRAA
=AGAA
AzAӮA
AAzAԣAHApApAzA
=AGA{AffAffAיAA  AApAQAzAzAHAAA33AՅAAAAҸRA\)AӮA
=A33AAGA\)AAAәAAAՙAԸRAA
=A=qAѮAҏ\AϙAυA
=AA˙ApA  AƸRAǅA
A  A  A{ApAAA(AA\)A
=AffA{AAAAAAffA\ARAzARAHA(AzAA
=A33ARAAGAHAAQAA\AA  AHAA\AA
AffAAA\A  AA{A{A\A\)AřAGAffAǅAQA
=A33AGAAGAzAApAA33AffA33A¸RAQA=qA
AA(AA
A33A
AA
=A
=A£AÙAAzA\AAAHA  A
ApAAAGAA(AA
AAApAA
AA  A
AQAA=qAAAAA{ARAAAGAHA\)AřA
A
AA=qA(A{AHA
=AHAA=qA{A33AAGA
AQA=qA˅A  AzA¸RA
A(A(AAAAA{AApA\)AAAA=qA  AAGAGApAAApARA{A
=A  A£A\)AHA
A\)AAA{A(A(AA
=AApARAA=qARAAAAQAGAÅAzAHAHA(AAAQA33AA
AQAAHAîAAĸRAď\AģA
AA
=AA\AA33A  A
A
AřAHAApAģA=qAĸRA{AffA  AffAzA£A33AAAHAGAAîAǙA{AAGA¸RAAA
=A33AřApAȏ\ARAAAQAzAA
=AAARA(AAAGAA\AQA{A(AHAAARAAA{A
AApAA\AGAA33A
=AHAGAHA{A¸RAHAHAHAzA{AAAAAzAA˅AAʣA  A(A
AɮA\)AzA33AGAQAʏ\AffAʣAAŅAHAɅAɅAɮAŅAA33AA{AA̸RAA=qApAA
AĸRAAAGAƸRApA=qAA33AɅAƣAffAʣAA33AGAîA33AAAAƣAĸRAď\AffAĸRAAHAA
=A\)AĸRA
A(AGAA\AQAŅA=qApAAAA£AGAîAA33A
=AŅAffAGA
AAA  Aʏ\Aʏ\AʣA\)A  A\)AGA̸RAQA{AA
A˙A33AAʸRAzAffA=qA{A  A=qAA\)AAȣA=qAAǅA͙AAHAQA{A=qA(Ȁ\AAʸRA33AHA
AˮAˮAʏ\A\)AǅAȀ\AͮA33AAffA33AřAA33A=qA{A
A{A{AQAHA  AÅA\)A
=AAď\AAȏ\AȣA˅AAʣA(AAAA\)A{AffAȣAAHA=qAΣAzAЏ\A(A
A\)AӮA33AAәA{AQAҏ\A
A
AхAиRA33AAЏ\AAУApAͅA\)AθRAzAϙA\)AAAAGAffAˮAffAA͙A
=AҸRAGA
=AәAQA
AAиRA
A(AυAAͅApA{A̸RAAͅAẠA{AͅAAəApAȏ\AzA33AffA
AAȀ\AAʏ\AǮA33A=qAAzAәA(A\)AffAԸRA=qA  AхA
AԣA֏\A
AAHA33A33AأA{A=qAffA{AA؏\Aڏ\AمAA
A
A=qA\)ApAzAQAAظRA  A֏\Aԏ\A{A
AQAҸRAffA  AӮAffAӅAAGA
A(A
AffAA
=A\)AApAԣAGAA
=AzAҏ\AAA=qAA  AzA
=AA
AA33AGAAQAљA=qAffA{AApAљAA(AA
=A
=AHAzA33AzA(Aԏ\AAAA
=AApA
=A33A  AAffAAA33AיA
ApAAיAׅA{A\)A׮AA33AzAffA(AzA
=A33AͮAAϙAӮAAΣApAA{ApAGAӮAAУAΏ\AzA˙A{AŅA
AA  AģAQA33A33AffApAGAQAŮA
=AffẠAAzAϙA  A
=AAͮA
=A  A33AzApAQAA=qAzAA{A˅AQAA  AʸRA
=A
=A=qA˙AA
=A
=AGAffAأAظRAffA=qA
AAׅAGA33A  A
AAՅAA(AzAzAQApAAҸRAffA  A\)A
AAHAzA{AA{Aď\AA
=ApAAAApAQAAǙAA33AŅA
=AəA(AQA
=AЏ\A
=A=qAA  AHAAʏ\AQAȸRApAAAHAAQA=qAAîA
A(A£AÅA
=AApA(AAģA33A
AGAĸRA33AA\)A
=AAARARAGAAAA(AGAffAA
AApA\)AĸRA{AîAAîApAÙA=qA(A33A\)AAď\AAŮA  AzAA\)AŮApAHA(AƸRApA  A
=AHAGAAffAAģAď\AGAŅA
A
AA=qAffAAffAÅA=qApA  AAA£A¸RAHA(AîA\)AAAGA
AHA\)AHA{A\)A=qAŮA£AAHAɅAƸRAAGAAzAzA
=Aȏ\A33A\)A
AffAffAffAzApApA\)AzAffAffA33AǙA=qAǅAǮA  AAǅA
=AHAAǮAɮA̸RAAAGAA\)AA
A(ApA  A˅AʣAzAQA
AɅAAȸRAAAffA{AǅA\)AAzAAzAʸRAzAȏ\A(ApA\)A
=A  A33AA=qAQApApAǮAəAAȏ\AHAA
AAffAŮAA
=AGAʣAA=qAǮAApA  A{AQAffA˅AˮA͙AHApA
=A{A33AˮAGA
AA{AzAϮAθRAffA{A  A\)ẠAzA\)Ȁ\AˮA=qAͅAͮAzAθRAGAθRAΏ\AHAAzA  AGAͮA
AͮA͙ApA
=A=qẠA
=A33AzA=qAϙAAHAAͅAA͙AA\)A=qAУA͙AAzA=qAHA33A
AͮAθRA
=ApAAϙAυA͙A  AzA\)AA͙A\)ApApA=qA\)A
=AAAA
=AffA=qAA33AAA
A{AQA{AͅAHAzA
AzA  A=qApA(A33AAAffA
=A
AӅApAzAҏ\A
Aҏ\Aҏ\AәAGAӮAәAGAϙA
AAхAzAA
=Aҏ\AA=qAӅA=qA33AzAffAA33AԸRAӅAѮA\)AθRA
=AϙAzA\)AAA(AϙAQAffAffAAΣA
AљAAΏ\AΣAΏ\AzAͮAΣAHẠAAHA  AApA33AЏ\AHA
=AA(AңAѮAAԏ\AՅAAЏ\AҸRA33AӅAffAЏ\AУApAϮAυAAΏ\A\)AA  AхA  A{A=qAͅAͮAA
AͅAAA͙A  AͮAͮAͅAẠAAӅAAA  AAHAϙAϮA͙AυA33AzAGAzA  AAѮA(AѮA
AffAApAљAΣAzAzAzAAQA
=A
=AA\)A{ApAA(A˅AApAΣȀ\A=qAQAA=qA˙A˙AAAHAGA  AʣA33A  A33AHA\)AϮAA
A
=A{AӅAA=qAAA\)AQAظRAGAمAAffA  A  AGAzA=qA{A
=AA\)A  AA33AAzAApAA  AQAAHA=qAׅAAA33ApApAAAQA  A=qAA{A{AA(A(AQAأAיA=qAיA׮A(A֣AGA  AQAAAϙAυA  A
A
AAAHA̸RȀ\A  AzA33AљAЏ\ApAЏ\Aҏ\AAиRA=qAA{AQAՅA(AA33AA{AffAzA=qAAۮAۮA
A  AffAzAۮA=qA  AzA=qA33AQApAָRA
=A(AծAAAAAAA33A  AمAأA{AأA
=AQAأAظRA؏\AffAAAAQAzAA  A  A{AQAHAAffA֣AA֣AәAԣA\)AGAծA33AQA=qAԣAAӅAљAЏ\AυAA(AffApAAAHAQA
=AAθRAAAGAAA{AA(A֏\A֣AA=qA{A
AծA\)AՅAծAՙAAQA֏\AzA֏\A
=A33AՙAԏ\A\)AAzAA\)AѮAffA{A
=AzA
AՅAHAAGAA33AAAA=qAGAԸRA֏\AՅAA=qAԸRAAAQAAԣAAffAԸRAGA  AQAԏ\AQApA(AzAљA\)AA(ApAУAϙAA{A
=AՙApAHAffAA{AGA  AzAffAУApAҏ\AAAAApAҏ\AHA33AәA
AәAApA  A{AԸRAAA=qA=qAQAzA֏\AָRAAAHA֣A֏\AAQAQAzA{A=qA(A=qA֏\ApAָRA
=AHAAAzAԣAԸRAAffAиRA  ApAzApAQA(AffAAՙAAԸRAQA(Aԏ\AzAzA
A
A
ApA\)AQAAυA
AΏ\A=qAffAA
AA
=AA
=ApAQAԣAҏ\AңAzA
=A\)A{AЏ\A{A33AzAAӅApAQAAAA
AGAAԏ\ApA
=AGA\)AәAzAA(A(AffAAHAәAAљAffAzA\)AQA(AՅApAzAQAѮAAApA(AϙA{AәAHAӮAԣAffApA
AЏ\A
AəA33AAGAυAA֏\AՙAԸRApAԣAQAzAӮAәA\)AЏ\A
=AAAQAApAƏ\AHAA͙AffA͙AHA\)A{A{AzAffA
=AҸRAхAҏ\AәAzAA  A  AffA֣A  AAQAָRAָRAA(AָRAffA(AծA33AQAAԏ\A
A{AңAAA
=AңAzAAAAԏ\AA
=AәA  A  AA
=AυA33AA(A
=Aԏ\A
=A  AGAAA(AA(AQAzAAQA{AӅAzAApAHAQA
=AQAУApA{AzAυA
=AzA=qAHAGAAAA=qAAGA{AAљAҏ\AAA
A  A(A=qAԣApAAGAAՙAAA
=Aԏ\Aԏ\AApAA
AӮAQAAQAAAԏ\AzA33AAzAхAљA  AA
=AϮAHAffA=qAzA33A  AAAϮAA{AͮA{AхAzAzAffA{A
AAQAңA
=AAҸRA{A33A  AHAffAҸRA\)AѮAzAԏ\A
AzA\)A33AzA(Aҏ\A
A  AљA=qAҏ\AffAHA=qA{A33A\)AʸRAGAA˙ApA{A\)A33Aʏ\AA(A˅AʸRAAQAA͙AͮApAẠA33A(AA  AAAQAAA˅AA  A  AʣAAHAAGAʏ\AGAəA\)AŅA=qAGA(AAAģA
AAǙAA
AǙAAƏ\AQAzAffA=qA
=A33AAA\)A\)A\)A33A\)ApAƸRAAGA
=A\)A  AzAʣAA
=AGAɮAɮApAȣAAǙA=qA=qAȣAA{A{AŮA{A=qAƏ\AAA33A
=AAǮAƣAƏ\AŮAQAřAƣA
=A=qAǅAǮA(AHAffAA33AzAApAǅAQAƏ\AA
=AHA=qAA\)AAAffAA\)A33A
=A
AHAǅA=qA  A33A
=AîAzAA
=A=qA
=A\)AAzA=qAzAǅA(AzAGAA\)A  AģAzAffA
=AA  A=qAAHAƣApAƣA{A
=ẠAA
AA=qA{AΣA
A{AAHA(AϙAHAHApAApA=qApA(A{A\)AͅAHA
=AAffAAHAGA33AA
A33AˮAA̸RA\)A̸RA(AHAHA{A͙AA(AA\)AAGA͙ApAAGAQA{AƏ\AȣA\)AAA
=AGA(AHA(AzA{AAffA(AȸRA{AĸRAŅAA\)A
A
AzA
=A(A˙A
AffAAA  A  A=qA  A  AzA33A33AθRA33AAAA=qA=qAɮA\)AɮAAAəAzApA\)AȀ\ẠA  AzAzAʣAffAɅAHAʏ\A(A˅AGAGAA33AGA˙AA  AˮA˙AzA˙AAAzAA
=AAffAzAAGAGA33A  AHAAǅAȏ\ApAQAAɅAAHAGAAffAAAffAȏ\Aȏ\AQA
=AGApA  AApA(AffAHAAzAϮA(AͮA̸RAffA  A\)AA
AHAŮAQAA
=A  AAAApAA\AGAA(AApA(AffAQA  A(AͅAУAʏ\A  A\)A=qApA=qAȸRAʏ\AȣAȣAȏ\AAA=qAAAAȣAẠA˅AΣA
AAA
A33A˙A  A
AA˅AͮA33A  A(A(AϙAϮAυAAA  AQA=qA  AΏ\AθRAΣAzAQA(A(A(A{A  AˮAA
AǮA{A=qAȣA\)AɅA33A{AffApApAAffAA33AȸRAAAAƸRA
=A  A
=A(A
=A
AzAAApAA  A(AQA(A̸RA33AʸRApAɅAzAȣAȏ\AȸRA  AǮAǅA
A33AƣAAȏ\A{A(AA{A{AQA
=ApAQAzAAGAˮAQAA{AAẠA  AAA̸RA
=AQAQA˅A=qA  A
A  AffA33ApA
A
A{AffAHAA˅AffA
AAQA\)AzA33A˅AA{AAzAʣAʏ\AAA\)AɮA{AQAʸRAzA
Aȏ\A̸RAHAɮA33AGAAA=qẠAHAQA̸RA̸RA=qAzApA{AHA=qA\)AGAzA{AǙA=qAȸRAffA\)A(AA\)AǮA(AA  AȸRAAA(AʸRA˙A  AzA
A  A=qẠAffAzAzA=qAffȀ\A̸RA̸RAAAA̸RA̸RAA
=AA=qAəApAHAGAŅAffAĸRA\)A\)AɅAƸRAAAAQA{AAAAAAQAȏ\AzAǅA\)A=qAȸRAGAɅA\)AffA  A  A  AAǅA{AAQA  AffA33AffA{AŮAAffA£AffAA\)A\)AA(AîAffAQAĸRApA\)A
=AĸRA(AA
=AApAəAAȏ\A{A(A33AA33A
=AAAffAAAǅA
A  AǅA\)A\)A{AŅA  A  A{AQAAAŮA\)AĸRAď\A{A
AîAHA¸RA\AQA(AA
A
A{A{AA
A=qA  AĸRAA
=AAApA\AAGAA33A{AA33AQA
A=qAffA33AQA
AĸRAA33AîAQAA\AA=qAQA{A{AQA33AA
A  AffAAA
=A(A¸RA\)A
AQA=qAîAA=qAffAď\AzAffAď\AffA=qAApAAAA
=AA(A
=AA=qAAAAQAAzAQAffAffA{A=qA(A
AA{AGA\)A  A
=AAA\AQA=qAzA=qAffAAAAzA\)A£AzA\AAA{AA(AffAAA\A
AA
A\AA  A=qA{AA{AHA=qAAAA33A
AA
A
=A(ApAHA\)AAAQAzAApAffAA33AGAzAQAAQA\)AzA
=ApAA33A33AzA(AAA  A  AGAQAffAffAQARAA
=A\AAzAzAGA33ApA33AA
A
=AHAA  A  A33A\AQA\)A  A33AzARAAHA  A{A{AA  AHAA  ApA{AAA
=A
=A
AAHA{A{AQA{A  A(AAQAAAA=qAzAA
AAAzA33A
A33A(AffAQAAAHA{ApA=qApAAAAAzA\)ApA{A\A=qAAAHAHApA  AHAApAAQAQA=qAAQA
A¸RA=qA  AA£A=qAQA(AAAA(AAHAAA\)AA
A
A  A=qAQAffA{AQA=qAQA{AzAAHA¸RA
AA  AA\)AQAHA=qAQAAAGA{AAffAffA
ApAA  AHAHA(A
A33AA\)AffA33AHAAA=qAAffA  AA\)AAAAARA\A\A
AQA=qA{AQA33A\)A(AAzAAA
=AARAA{AA33A{AA
=AA\)ARA\AHAAQAAGA
=A
ARApA=qAA{AA33AA(AffAAAAA33A
AAA\AAAffA{AA(AzAzAAAffAHARAA\)ARA
A33A  A33A\)AAHAA\AAAARA
=A\A(A  A(AffAAAHAQA=qAffAAHA=qA33AAA\)AA
A33AA=qA33A\AzAA
AAA{ApA\)AApAAA\)A=qA=qAGAA\)A  A=qAHA(AAzA\AAA
AffAA\)A=qA
=AARA(AAA33AHA  A33AQARA33ApAAAA=qAAAA
=AffA\AAzA
=AApAAA
=A\)A(A\)AAA33A\)A\)A
=A(ApAAGAAHAzApAAAA(AA\AA  A\)AA
AAAA33AAQA\)AAHAAAAAA33AA\AzAA
=ARAAAffAApA\)AQA
AAQA{A(A(A=qA
=AAAAAffA{A
AffAApAffARAA
=A
=AAAAAzAAQA
AAHAA
AA
AA  A(AAAAGAAAA  A
A  A
AffAAAGA=qA33AGAA33AAAHAffA
AAQARApA(ApAHAAAAAGAzA33AA\AzA  AAzAHAAAAGAA33AAHAA  A\)A
=A=qA{AAA  AHA\AAAARAAzApAA  A33A(A(A\AQAAAQAAffA\AAAQA\A\A(A=qAAA\A{AA=qA\A\)A=qAAQA
=AAApApAA\)AA
=AAAARAffA\)AARA
A\AA(AAA{A\A\)AARAzAAGA
A
=A
=A
=ARAAzA(AAAA  AA{A{AAffA
=A=qA=qA  A\ARAAHAA(AAA{AA\A{A=qAA
A(AAA  AA(A\)AGAA=qAzAQA33A(A(A\)A33AffAApAGAQA\)AAAAA\AA33AA=qA
=AA=qARA
=AQARAAffAGA\)A
A(A\AAAzApApAAQA(A(A33AzAAGAAA=qAHAAAQA\ARAzAARA
=AAAA33ApAffAA  AGA\)AAA=qARAGA\AHA\)A
AzA(AA(ARAzAAHA  AzA
A\)AffAGAAGA=qA
=A
=AA{A
AAQA\)ApA\)ARAAA
A\)A
AAffA(AffA  AHAAAAAAAA33A  A33AzA  ApA\)AAAAAA33AAApAffAGApAHAHA  AA{A  ARA  A  A
AzAA33A{AHAA(A(AGAGA\ApAAA(A33A(AA\A\)A=qAAzAAffAAA
A  AGAA
ApApA(AzA=qAAQAzA\)A
=AA(ApAAAA  A(A  A=qAffA\A=qAAA\AHApA\AA{AA\)A33AHAGA\AA=qAzA\A
=AAAHAzA{A33A{AGAGARApAAzA\)AQA
AHAAGA(ARApA  AAGA(AHAHA33AGAGAzApAffAffAAQAAAAQAzAA\)AGAA
=AA\A33AAQAQARAA  ARAARAAGA=qAA\)AARA  AHA
=AAA33A\)AzA
=AA  ARAA33AAA33AGA  AHAA
=AGA{AAffA  A
AA(AzAQAHAApARAffA  A(A
=AA
AffAAffA
AA(ApAAAAHAAA(AAAAA\AGA\A=qAA\ARAA\)A(A\AA
AzA{A
=AAŮA(A\)AGA{AÙAîA¸RA  AzAA
AAffA=qAď\AƣAffAA
=AAA
A=qAApA\A{AffApAAA\AA  AHAAQA
=A¸RAÅA  AA
A\)A33AA
A33A{AA{A
A
=A(ApAAAAffAAA  AAA\)AƣAHA(AAÙAGA
A
A33AzAA33AQAA
=A\AHA=qAAA  A
A¸RAHA
=A  AAHA£AHAAGA¸RAA  AHAffAA\)AÙA£A33AA
=AzAHAAAQAAA  AHAARAA\)AAAAAA
=AAGA{A\A¸RAGA\AAAAAAA\)AÙAAHAA\A33AAffA  AzA
=AGAŮA(A=qAƏ\AA\)A
A{AAzAGA33A{A\ARA(AHAÅA
AARAGA\)AA
=A\)AA33AzA{AffAzAffAzApAQAA
AAģAHA\)AffAAA=qA¸RAAQAA{A£A£A\A(ApA{AAÅApAAffAĸRAzA=qA
=AģAAŅAŅAGAAzAAAGAAAAffA33AA
=A{AƣAA\)AAQAA33A(AŮAď\AffAAQAA  AAÙAA£A33AA  AA\)AA33AAȏ\AGA¸RA=qA(AzAA  A\)AA  AHAAŮA{AQA\AzA{AAAɅAA
=AȸRAǅA=qA(A\)AȣA=qA  AA{A
=A
=A(AAȸRA(AA(A(ApAA£A¸RA33AAAzAģAAĸRAffA\)AzAĸRA{AAffA{Aď\A(A  A
=A33A\AA\)AQAHAA
AAGAAA£AAQAQAARAAŅAǮAQA  A(AA\)A\AzA
=A(AHAGA=qAřAffAAAAAAQA
=AGAzA\)AŮA33AHAřAAŮAŅAŮA(AîAÅA\)A{A
A(AřAřAA33A\AGAAffAģAAÙAAAA
=A
=AQA{A=qAď\A=qAA{AHApAAGARAA{A=qA33A=qA\)A\A(AAA{AA=qAA33A(A33AzAGA=qAAA
AA
=AffAHA
AA\)AAAGAApAA
A=qA
=A  AAA33AQA{A£AîAQAAGAHA
=ApAîA\)A  A33AA
=AA33A{AAA(A{AGAffAA=qAGA  AzAA£A\)AApA
=A
=AA(AAA(A  AA  AAHA\AzA33AGA\)A\)AA{AffA=qA=qA{A(A{AAA{ARA33AHAAAGAAA  AA
AA
A\)A{AAQAAA  AGAAQA  AAzA{A33AHAA\)AApAAAAAAAzA{AARA{AA
A\)AAAARA
AApAARA
=AAAA
=ARAHAzAAQA\)ApA  A\A33AA(AA
AAQA33AAA
=AHAAA
AGAA(AAGAGA\)AHAffA  AAffAA(A
=AAAGA
=AAQA\AA\)A{A=qARA
AA33A33AA(AA=qAAAA(AAAHA=qA\A  AQA(AAHAAQAA33ApApA=qAAAA
AzARAAA
AA=qAffAA\A\)A
=AApAA\)AQA\A
=AAffAQAAAQA{A\)A¸RA=qAAzA(AAzA\AÅA¸RAffA\AA¸RAA£A{AAA{A  A\)AAAA\)AGAA\AA(AA=qAffA{A{AA{AA{AHAA(AA
AAGA
=A
=AHAGAA\)A
AîA=qAzAffA  A\)A\)AAffAGAGAAA(AřAŮAŅAzAAAGAzAHAƸRAAAŮA(Aď\AŅA{A  AAÙA
=AzAQA\)AA
=AzAzA33A¸RAffA33AÙAGA
=A(A33A
=AAAAGAzA
=ApA{A\A(AffAffA  A(AAA£Aď\AģAĸRAAģAAARAAQAÙA{AA33AA(A=qAHApAAA{A33A  A=qAŅAAHA
ApA{A
=AffA
AzAģAA33AřAĸRApAAzAƸRA\)AřAAAAAřAřA{AŅApAřApA
=AAHAAQA
=AQAzAHAffAŮAď\AřAŅA=qAŅAQA
=AHA33AŮAŅAŮA=qAřA
=A
=A
=AAA=qAAAAřAģAřAA
=AHAzAGAŅAAAffAŅAAHA\)AQApA
A=qAGA(A33AA=qAzA=qARA{AA\)AAîAGA{AQA{AzAîA33AA33AAGAAApA33AA(AÙA33A=qAQAffAffAffApAA
AGA(AA
A  AA(A{AHAzAGAHAffA
A33AffAzA33AGAÙApAAÅA
AAffAîAHApAQA
AAQA  AHAAGAĸRAAAÙApAÅAÙA  A=qA{A{A£A\AAA{AQARAA
=A\)A=qAAA
AffAAA\)A
AA(AAAA
=AzA{AGA(A{A=qA(AApA
A33AzA
AAA{A=qAQARAAAA=qAAAAAA33AAA\A\A\)AHA
=AAA\A\A\A\AQA  AA=qA(AQAAA\)AGAAQA\)A=qAAAAAA  A  A  A{A(A{AQAzAARAAAzAHA33A
A  A  A
=AffAApAHA
AQA\AARAAffA=qA
A33A
A{AA\AAA
AA\AA
A=qAAApAAHA\AHAzA{A\ARA(AA
AAQAAAAQA  A=qAzARA
=AA  AffAAAGApAAAA33AAAzA=qA(A\A
AzAARARAzARA\AA=qA(AzAA
=AAGAA
=A\AffA  AQAA{ARA\A{A
=AApAAzAAAffAffAARA\ARAAQAHAA(A\AHAHAApA{AAAA33AApA\)AHAAffAHAAAAA33A
=AAAQAA33AGA=qAApAGAAA  ARA{AA=qAAA{AffA{AzAffA\)A{AA
A\)AzAGA\AAAHAzA=qAAA{AGAAA33AffApAAHA33AAzAAAARAHAA
A\A(AA33AQAAzA\)A{A\A33ApA
A=qAffAA33AA
A{A(A
AAA{A\AffAAApAQAffAQARA\ARAAffA\ApAAAA
A
=AAzAARA{AGAAffA\)AGA(AAHAHAA(AAQARARAA
=AGApAHAA=qAA(A\AAARAAAAAAA\AffARA
=AAQA33A33AAzA  A{A  ApA  A  ApAA\)A33AAîA
AAAAQA(AA\AAAA
=A£A  A(AA\)AA=qAQAAGA
ARAQAAAA£AAffApA(ApAAAzA  AzA{A{A\)AzApA\A(AA\AGAAAA(A£A(A(AA¸RA  AApAA=qAAAffAHA33AA{AAď\AAřAffApAA
A{AffAȸRAȸRAAAHAzAffAQAȏ\A=qA{A  AǮAAQA{A(AŮAffA{AAA{AĸRA  AA33A
=AApA33AGAAAƣAffA{AAŮAGAAffA=qAA
=AGA33AAAřApAHAQA£A33AîA
=AA(AzAzA£A\AA\AAGAÅAîA
AffAĸRAAģAQAA
A{A
A\AA
=AffA  AŅAQAA{AAřApA
=A  AƏ\AAřAAHAffAƸRAQAzAzAƏ\A=qAzAAAffAAzAƣAffAQA{A  AHAřAHA33A{A
=AAGAQA  AŮA(Aď\A(AÅA\)AHA{AAAGAHA(A{AGAŅAQAzA  AřAŅApA33AAQA(A=qA  AGAHApAAŮA{AģA
=A
AApAA33A\)AÅAGA(A33AAA\AQA(A£A\)AÅA
=ApAď\AĸRAĸRA
=A\)AŅA
A{AQAAzAzAA
=AĸRA  AffAƸRA\)A33A
=AHApAHAffAǅA=qA=qA{AffAƣAǙAzAAffAHA33A¸RAARA\)AQA\A
=A£A\)A\)A33ApA\)A=qAŮA{A{AzApA\)ApApA=qAA\)A{A
=AA33AGAAffAzAA{AAA  AA  AHAď\AĸRAď\A33A{A{AApApA
A=qA
=AģApAƸRAŅAřAřA=qAffAffAzAzAzAQAQA  AHA{AģA
=A\)A
AffA
=AAď\AĸRAffAffAŮA{AQAffA  A  AQAQA{AzAǮAHAAȣA  AzAȸRA  A(AGAƣAApA
=AǅAAAQAffAƣAA{AîAA
=A33AQAŅAAGAffA33AGApA=qA33AQAHA\)AAGAAHAGAQAîAzA=qAHA\)AAQAHAGAîA  A=qAffAĸRAHA33AGA\)ApApAApA\)ApA33AAHAģA33AffA\A
A
A{AHApAffAAzApAAřA
AffAHA=qAzA\)AARA{AA\)AA
AzAÅAAQA{A{AffAAA=qAAQA\)A
=A\A{AHAAAAAzA33ApAHA{A
A{AHApAÙAA
AřAřA
=A33A
AƸRAǙA33AAƏ\A\)AGARAzAAAQARAA\AAffA\AA癚A(AzAGAA  AAAAHA\)AQAAApApA(AA
=ARAAQAzARA{A\)AA
A(AA
=AHAHA
ApAAffAHA33A{AQARAAA߅ApAAA33AAAA
A33AARAA  A\)AAޏ\A\)AQA=qA
=AAA
=AGAzAffA=qAAAzA
A=qAHAA(A\)A\ARA=qAQAGAAAA
A
=A{AQA33AA  A(AˮAffAffA
AAAAzA=qARA\)AAAzARAAGAApAA\)A\A\ARAAHA=qA33A\AA33ARA33A=qA{AЏ\A\)A\)AA33A(AGA33A33A
=A
A
AA\)A\)AGAA{AA¸RAGApAď\A(A  AAAzAAQAA  AApAA
=AzA{AGAAAA=qAzAzA{AA{AAAGAA  AGA  AHAAģA=qA(A\AA\AzAAzA33AA
=AffAQAAA
=AAA33A33AAAffAA33AAffA\)AA=qA(A\AAQA=qAA{AApAA(Aď\Aď\AGAîAAAQA(A=qAA=qAzAHAffA̸RA=qAA\)A
=A  AAAA\)A¸RA\A
AA  A  A\)AȣAzAffAffAƏ\A£AzAAAA\A  A\)AA(AřApAA
=AͮA{AffAԸRA׮AGA  AGAۮẠAׅAGA˅AۅAʏ\AٮA(AHAAffAGApA\)AAApA33A  AHAأA
=A\A{A
AzA
=A{AGAAԏ\A֣A(A߮ApAQApAffAܣAٙA33A33AzAHA
=A
AffȀ\AA{AA{AѮAApAQAřAA(A  AQA\A
A\)A{AA
A\)A
=ARA\AzAzApARAzA
=AAď\AA\)A\)AA33A˙AGA  AңAAAzA݅AͮA{AÅAHAȣAAAиRA
=A
ApAzAQAAAA\)ApAQAGAffAGAA(AA(A(A(AA\)AA(AQAAٙAׅAޣA\)AQAAHAHAHAzAQAHAHAAffAӮA㙚A  A\AAGA\AApAQAAޏ\AAA\)AQAAҏ\AA  AAHA(AHA߅A=qAA(A
=A\A
A\)AHAQAمA33AA
=ApAGApAHA\)AA
=AA=qApAA\)AQAApAAzAQAHAHAzAA癚A(A癚AzA  ApAA  AA33AHAAHA㙚A  AQA  AڣA
AAAApA33A33AAޏ\A
=AA=qA
AޣAۮA33AffApA\)A  AA\A\A  AA
AAAAQAHAAAzAARA  A(AAAA{A  AAA=qA͙AzAzAA{AHAA\A\)AA{A(A
=A(AzAQA  A  A
=AApAAAAffAڣA\)A\)AAA
=A  AA  A݅A
=A{A{A=qA
AAA(AARApA\AAGApA  A{AA=qAQAApAA
=A߮A׮AڸRA{AzAffA(A
A{A\AzAA{AffA\AA홚AAAzA\AzAQAA
=A
AzAAA  A
=AܣA
A\)ARAAffAA߅AA
=A܏\A
=AAGAمAGAzAffA  AHAՅA  A\)A=qA\A=qAzAAQA{A=qApA\)A  AAQA=qAAQARA33ApA(AAARA=qA33AAAzA\)ARAQA\)AAA{AAA(AAA  A
AHAܸRA
=AA\AAAA  AA33AffAAAA\)ApAGA(AA\)AAǮAծAܣAzA33AA
A݅A=qAQA
AAQAA=qA\A=qA\)A\)A(AzA홚A(AAAAA33A=qA
=A(A
A{A\)AA
AAApA\)A\)AzA뙚AAA\AAHAAAA\)A33AAAAAA\)ARA33AAAB\)A\A
AAAzA\A33AHAۅAA33A33A=qAAzA\AzA  AAzA=qA
=A
=AAApA(A\ARAAzA33AGAffA=qAA
=AAA\)AAAAAAzAAGA
=ApApA(AAzAzA(A
=A\A\AQAAA
=AAGAApA\)AffAffA{A{AAAffAAB QBGB 
=A{B   B AAAzAAB\)BB zA  AQAAAA
=A\)AA\A
=A
AQAAA{A33A33A{AAA=qARA
AGA(ARA\)AAAA֏\AᙚARAGAAAAARAzA=qABB ffB AARAffA
AAA\A{AffAApA(A
=A  ApAGA뙚AHA
=AHA
A\)A=qAA뙚A{A
=ApA  B \)A(AGA=qAA\)A=qAA=qAAGAAAAA
=AA{AAffA(A=qAHAApAA=qA  AAA癚AAAApAApAA
A(AzA=qAAAAAzAAA
AApAffA33AAAffA\)A{AzAGA\AB GB33B QB AA{B\B HB\BB33B \)A(BB
BB
BBB
=B pB\BffBRBBBB(BBQB B RB(B BB  B33B B {AAGAHABARAAB QAffB
=B
=BB (B33B AA
AAzA(AGARA(A{A
A33ARA{A뙚A\AARAAAGApA
AA=qA33ARAA=qA
=ARAA
=A=qAApA{B33A\AB pAA
=ApAAAAffA33ApAQA=qAffAHAB33AAA  AAGBBB AA  A  AffA\)ABHBQBGAA\A
B33BB 33B HB \)BBQBBBzBB pB AGApAGAAQA\A33A(A  AAA{AAzA
AQA
AA  AAffARA(AApA33A=qAAAffA\AAARAzAffAAA
A
A33AzA홚A\BGB pBBHB=qB pB  AffA
=A33AA{A\)AQAAB BpBBBBBBBB \)AB=qB(B33BpB33B33BffB(BB
=BB\B  AAAAAGB \B33B zBRB{B(B=qBBQA{B \B
=A(ApApAQA\)AA
=AQA
=A33AQAARA\)A
AAHAAQA33AAApAAAA=qAAffAApAA=qABB zB \ARBzB\BQB (AA(A{AAzA噚ARA33AGAA{AGAffA
AA\A  AB (AAB
=B ffBBQBzB
B{BBBB\)B\)B{BBQBBzB A
=A{A(A=qAHA{A
=AAB33AA{A\AHA=qA(A=qA  AHAAA{A\)A  AHA  AffAA
AA癚A(A
AAAA  A{AAA33A
=ApA  AHA=qAAffA33AARB   B B AAAAAHAA\AffA
A\AAGARA(AA
=A
A  AB  BB zBBBBB=qB(BzBBBBB
B\)AGA=qA
=A33AzAffAAAA(A(B B zAHA  A{AAA
=A  AA
=A\A(AA
=AQAՙAAٮA(A\)AzAffA
A
=ApAAA{AA
=A(A\ARAAA{AzAAA(B   B33B QARAAQAAA{AAHAAAA
=AA\AffAAQARAQA(A
ApAzA\)AHAApA  AQA\AA\)A(A  AAA{AA
AHAffAQAB=qB (A=qA
=AA=qA\A  AAA  AARAA\AA=qAAAAAAHAA=qA=qAAۮAAA(AAA\)A(A\A\A
=AQA
AQAGA(AQB  B HBB\BRBpBpB
=B=qBzBB ffB ffA{ARAGA{ARA(AApA(AQA=qAHB 
=AA
AA{AGAQA
AA
A
=A  A\)AzAzA\AzA
AGAffAzB BBffB33BBHBA33A  AA33A
A\AGAAAQA
AAA噚AARA\AGARA(AAAQAAQAQAQA
AAA=qA  AAGARAAQAGApAAHA
AAAAQA
B pB=qBzB\)B 
AAAGB GAB 
=A
=B 33BB
=B  BBBBQB33BBB\B33BB{BB
=BBBBBB{BBBBBRBBzBffBARA\)AAGAQA  AAffAzA{A(A33AAzA(AA  A癚AAAffAApAAARA
AAA33A홚AHAzAAABB RB GARAB{AQAA{A\AGAAzA{A\B {BRB
=BQB\)BB  B
BBB
=B=qBBBQBQBGBzBBB33B\)BffBQBB=qBB{BffBQBB AA\AffA  A\)AAQB =qA=qA=qA=qAAffAAA\)AffA
=A=qA33AA{AA  A  A  A陚AQApAHA
=AAQA\)A
A  AHAzA33A(AQAGA
=AzAffA(AAA33AAGA\)AA\A33AzA=qA\A\)AA\)A=qA{A=qAAAffA  A\A(AAQAffB 33AAAARA=qA{AffAA\AHA{AHAAAAffAA{A=qAAA33A33AAΣApAAGAQAQA{AĸRAzA{AA{AA
AAGAڸRA  AQAΏ\AHA\)A\)AAAA
AAffAAˮAA33AzAԣAͅApAzA\AffAA\A{AA
=A33A33AAzA  AA癚AA
A  AA{AAQARApA{AARAAA
AA  A  A
AAAAA\)A\)AzAGAA33AzA  A
A\)AA{A
=A33AA(AAA\)A\A(ApAA\AHA  A{AAHAA(AAffAA
A33A33AAAHA
=AAzA(AHAAGAۮAAGAzA뙚AAAAGA
A\AQApA
=AzAffA\AHA  A=qAA(AѮA\AģA  A(ARA{AÅA33AQAQAď\AAffA{AA33AƏ\AA
AȣA{A
=ARA=qA\)AQA33ARA33ARAAARARAffA
AzAAAffAAGA\)AApA
=AQAA  AAzA\)AAzAAHAAA=qAAHAAA|AAwAf{AkA[AwApA`  AqAeAQAR\A]AqGAAYAc\)AW
=A/
=A,  A8(AXAb\AZ{AiApAmGAvHAAA\A}ApAAAA
A
=AHAh(AhzA^RAqA=qA`zAX  Al(An=qAs\)AAYA^{AX(A_A\AlA_Ad(AiApQAvffA}AAo
=AjHA{\)A  AA  AAHA  A\AA(AA
=AA\)AQAAAAAAA33AtQAA{A=qAARAAARAQA(ApA=qA\)AAAAffAAA33A33AAARAARA\)AzAGA
=A33A33A=qA  AAzA  AAAGA\)A(AAQA=qAA\)AAAA
A
=A¸RAApAffAģA=qAAA\AAA(AzA33AAA\)ẠAHA(AA
A\)AǮAQA̸RA\)A(A̸RAGAřA  A{A(A\)AA
A  AAQAA{A33AzAA(A33AAQAA33A\AAAQAԏ\AA  A޸RA
=AHAAAA=qAAQAzAAzAffA=qAzAA=qA
=A{A=qAHAϮApAA33AA׮AA33AٮAA
AٮA\Aڏ\A\)ApA܏\A\)AGAA\)Aޏ\AApAGAAffAQAffAՅAffARAffAQAңAzAHAǙA=qAAGA=qAۮAHARAA(A=qAУAAׅAA(AffA=qAGAՅAAA
=AϮA  A
AA߮AָRAHAApA\)AA\)A{A
B33AHB\)AAGA(A
=AzApAHARAAAA\)AGAA(ARAA
=AQApA33ApA{AQA\AAzA
=A=qAAAffA=qAAAAA=qA\ApAAAffAAAAA\)A
A=qAGAQAָRA\)A
AAԣA{AQAAӅA
=AQA׮A
=AzAAGA  AޣAܣA߮AA  A=qA(A
AffA\)AA{AGA
=AApA33AHAffAAGAA߮AHAAA
A=qAۅAApA  A  A
=AǮAzAAffA
AHAA؏\AHAAQAAA33AA=qAGApA  ApA=qAGA
A=qAA33AAمApAGAApA
AʣApAAHAՅAffAAAظRAA݅AAzAQA=qA؏\AAQA=qAQA  A
AA
AٮAУA(AffA̸RA{A=qA(AɅAffAĸRA
=AɮAffAQAA  A
A
=AffAA(A\)A  AA
=AA\)A33AAzARAGA33A=qA\)A
=AɮA\)A{AApAǮA
AģAARA  AA  AA
=AŮAffAA{A\AHAAA\ApA{AffAAGAAHAHAAљAAיA\)A\)AA
=AA\AzAA=qAA  AAAzAQAffAAAffAA\)AGARAQA(AA
=A(AAA
=AAAAAzA
=AzA=qAAQAA
AAffAߙAGAA(A{AHAHA  AңAGA=qAAA
=A\)AУAzAЏ\Ȁ\AQAңA˅AHA˅AGAҸRAffAGA
=AAGA֣ApA\)A\AHAHA33AzAApA33A(A
=AA  AAA33A33AARAA=qAAA  AA(AA\)AA\)A\AAAAHA=qA͙AA33AAA(A(AAQAA  A\)A˅AΏ\AffAA{AAAA
=A{A\)A33AA\A
A\)AAA(AffAAHAHA=qA陚AAA{AAAAzAAffAzA
AA
=A  A33AARA=qA  A
=AHA\)AA
=ApAA(A33A
AA\)B zB B \B A33AA33B ffA  AGA
=A
A
=B \)AAAA\)AA(AAAAARAA{AAARAAAAHARAA
AAA  ARApARAApAAA\)AAB \)B GB BQB\)BB{BBRBBzB  B B\B \B pB
=AffA
B 33B AB QAB 
=B GB RB GB BBffBzB  B\)BBRB33BRB\AzARAffABQBGBBRB B \)AHAA
=A噚A(ARA33AGA\A{AA
=A{AAA
=ARAAQA  B \)ApA
AAAA=qA=qA  A=qAffAB B B B\)B pB ffB33B 
B\BzBBHB(B
=B33BB \B GB
=B\AHB 33B =qAB zB ffB B QB B (B QB ffB B pBBBpBB\B
=B 
B  B {B B {B ffBBzBzBRBffB=qBpBApAA  A33AAzA\)AffAAAHA{AzA\A=qAApA
AAAAAA{A=qA
=AAAzAHARAA{AA\AQAA{AzBAB AA33B 
=A
=AB AHA\)AB(BBBBBffBQB \AAAAAAB   B   B QA\A(ApAQA
=AAA33AA\)B 
=AGAAzAQAAA  A\)A\)AA=qARAAA  AAA{AARA{A33AAA\A
=AAAAQAQA\)A\)AffA{A
AffAAGAffAGAA33AHA=qB  A(AB\)B 
=B QBBBffBBA\B=qA\)AB(B B33BpA\A(A  A\A(AAzAGAAffA  A\A33A(A\)A
=B B ARB(ApBB(B=qB\B\)B  B33BB B=qB  B
=BB {ARAQA  AHAAAA=qARAA  ARA
ARAB {B 
B 
B AARAApA{AffAA{A\A=qA\A
=AA{A
A(AQA=qA  A  AB B=qB \)B{B 33B=qBB 
=AAAAApARA{A
A
AQA\AAA陚AA33AA=qA\)A{A\A  AzAffAHA\)B RB \)BpB \B AAAAA=qA
AGAA
AAAARAAAAffA\AQA\)A33A
=A
AA=qApAA
=AݙA
AQA(AQAHAffAHAәAAffAAffA\AģA{A(A(A33A癚A
AߙA\)AAA33AAA=qAA=qARA  AA=qAA=qAAAAzAAA=qAQA
=A
=A{AA33AAA(AQAߙAA
AA33AAQAA  A{AGAQBGAAAAAARAHA
=AA
=ARAAAAA33A=qAAGAAApA(AA\AAApA
AޣAAffAGA{A
AAAAzAׅA
AGA(AA
=AA\)AAAHAGA癚AAA{AHA=qAA
=A(AAHAAffA(AzApAAAA  AA(A  A33AAQAٙApAzA{A{AAffA{AA\)A(A33AApA  A\A=qA33AA=qA
AffAAAA
A
AAA
AQA陚A  AAHA
AAߙAأAHA  A
=AAGA޸RA\)AAzAܣAڸRA=qA
A\)AzAzAәAأAzA  A=qAٮA33AУA
=AθRAffA
=AzAA\)AGA
A
=AAAzA{AzAA\)A
A
A\)AHA\AAA=qA33A\)ApA(AHAAAA  AAAGA\)A홚A\A33AAAffA
A=qA(AAA(AAA(AAQAA{A33AARA{A{ApA㙚A\AᙚA=qARAAAGAAᙚA㙚A(ApA{AAGA(ARAffA{AQAA\A
AAQA
AA{AA{AAffA(A(ARAAHA홚A33A=qAA홚A\)ARAQAA{A{A\A{AAA\)A\AA  A
A  AAAAAffA=qA=qAAAzAGAAA
AA33B=qBHB
=B(AHA\)A(A  AzAA33AAܣA
=AffApAAQA  A{AAQARAA=qAAAA
=A=qAHA  AAzAApARAGARAA  AzAGA
A\AAzA뙚ARAB A\)B GB BBB RB BGB33BQB
B
=BB
=BB(BBBpB=qB\BBBzB\)BBB\)B
=BffBRB  B33BB\A
=AHB B
B=qB{BzA
BA\)BB A=qARBAzA  AzAA  BA=qAGAGAzAAA\AzAA(AffA\)ARAA=qA\A  AHA(AA(AARAAޣA=qA=qA=qAQAGA{BBB=qA
=BRB\A{AAGB BffBBB\)BzB\BA\A\)A\)A
=B 
B 
=AA\)AAQAffAAQA
AQAAHAHAA\)B AffA
AB(B HB  B   B {BBQB QBGB=qA  AAA(A  AQARAA=qAGA{A  A(AffAHAAA\A33AGA
AQAAzAA{A=qA(ARAA{AGApAQA\AAA
AAzAHAQAAA{A
=AHAA{ApA{A33A\)AAAA{A{AAAAAA33AAA=qAAGAHA
=A{AQAAA\)AAAffApAQAA
B QB AAA33A\)B RB B33ARAzAQAApA  A\)AAAA33AffAGAA33AzAHAAAGA
=AApAA=qA{AޣA33AA
=AݙAݙA\)AA
AGAA{AAAA߮AGAffAAHAHAzA
AHA\A
AHAAHA=qA
AA
=A홚A\)A\AffAԏ\A=qAAA{AAHA
=AA\)AAA\)AAA
=A  AQAA  A\AAzA\A
A=qB
=BQBQAAHB ffA{AAAQA=qA뙚A
=A\AAA
A
=AA
=A=qAHAQAA33A\AA\)A=qA
=AAA=qAAA޸RAݮAzAGA\)AAٮA33A  AA\)AA\AA
=A(A
=AAAA33A{AARAHA(ARA\)A=qAQAAAAQA{ARAQAAA=qAAHAQARAAQAA33AffAAApA\A  B 33AAAA  A\)A(AApAAA陚A\)A{ARAA(A㙚AzAAAHAA\AHAA  AA
=AHA
A
AHA\)ARAAAHA(AAA33A\)AQAAA֏\A
=A33A
AA
=A{ARAAA=qAffAA\)AAGA
=A=qAzAHA
=A{AffAA33A
AGA  AA  AAffARA
=A\ApAAA\)AARB pBffAAA  ARAAA\)AA{A\AAQAA(AAQA(AA33AQAA
=A{A(A=qA
=AGAzAיA
=AA=qApAzA(AffAәAҸRAݮAA{A
=A(AAGA{AQA֏\ApAApA=qA
=AAA
AAA=qAffA33A33AݙA
A
=AۅAApAAAHAffA{AᙚApA(A
=AAA{AAA33A뙚AAzA
AGAGApAAA33A33A33A\)A\)AAA  A(AQAHAffA  AA=qAGA{AApAA33A{A(AՅAAzA(A
=AffA(AzAAAAzAAHAA\AAA陚A
=A
A33A33AA癚ApARAApA
A=qAAA33A
AA
AGA
A(AzA=qAAHA\)A\A\AARAA噚AQA
=AGAffA噚AA
AA{ARA=qA\AAARA癚AAAQARA  ApA33A뙚AQAA{A(A(AGA(A=qA(AA
AAffAA33A  AHA(A33ApA(AffAڏ\AffAAzAGAAΣAGAΏ\AAAA  A33A33A(A  A
=AQAΏ\AAffA{AGA33AAAŅA{A
AAffAApAȏ\AAffApAˮA
=AzA
=AA£A
=AffAAHA{AA  ApAApA
=AAAA{A\A=qAAAAA\A
ApA=qA  AffARA  A=qA{AAGA=qAA  AA\)AAffAA\A  A{AAQAA(AQAAAAQA{AHAAGAA
ApA͙A
=AAAA
=AffAԸRA=qA(AQAA=qAՅAәAхAQA  AffApA=qA
=A\)AAAGA
AAAAffAA\)AمAمA(AAGA߮AܸRAٙA
AzA
AәA
=A
=A
=AAffApAGAGA{AAӮApA=qAGAffA
AQAHAϮA  A33AHAAzAGAAGAхA̸RA=qAffA=qAЏ\AAѮA
=Aҏ\AAAzAAAGAzAA33A  AAиRAHA\)A{AffAHAAHAAA(AzA£AȸRAGAAHA=qAzAA  AAHAARAA33AA\)A33AzARAA\A(AApAď\A  AzAzApApAHAAڏ\ApA  A
A(AΏ\AɅAA\)AřA{AGAffA£A\)Aʏ\A(A{AΏ\A\)A(A=qAA\)A
=A\AA33A{A=qAA\)A
=A
ApAzAA{AљAхApAGAAAHA(AÙAGAGA  A33AǮA33AA
=A
=A\)AAģA
=AHARAQAʏ\AəAAHAAffAGA¸RAĸRAAA  A\A\)AAAffAAzA(AA\)AGA{AAAAHAGA  AA
AGAGA\)A=qA  ARAAAffA{AAQA(AQAAA=qA{A=qA33AAAA
AA(AAAzAGAA  AՅAffA{AAAAǅA(AģAffAA̸RAGAAAffAAHAHAQAGAffAȸRAʸRAQAẠA(AͅAϮA
ApAڏ\AA֏\AHAΏ\AӅAGAA  AAߙAԣAׅAAAHA\)AQAAAޏ\AA
=ApAAǙA  AA{AřAƣAAQAA
AQA\)AHAAA̸RAΏ\A͙AGA\)Ȁ\A
AHApAڏ\AApAQAA
AHA\A(AA  AAA  A\AGAAHAAffA
=ARA㙚AA
A33A؏\AAۮAApA
A
A{ApAffAA=qA
AQApA
AAᙚAAAAAAAApA݅AzAzA  AAٮAHA33A=qAٮAׅA  AffAA(A=qAAA
AA(AA{ApA{A؏\AzA㙚AAHAGAzAffA(A33A\)A
A
AAApA\)AA=qAQA
A\)AA\)ApAA
=AAA
=A=qAGA(AAGAA(A\)AAAQAAffAffA
AA=qA(A
AHAffAA=qA(AHAAAAQAA
A=qA  A  AAHAAQA
=A\ApA33AHA噚AA  A
A
A33AA
=AAQAGA33AAApAAGA뙚AAARA癚AzA\AHAffA\)AAQA(A33AGAAAAAGAAA(A\AARAGAARA\ApAzAQAHApAHApA\AAA\)AffA(AA33AۮA(AA\)AA߅A
=AA  A
=A33A
=AGA֣AGA{A33AA{A33A33AAGAAGA{AApA\)A=qA癚A
A=qAA{AA癚A
AGA
=A(A(AAQAffAGA\AHAffAHAzA  AGA
A  AAHAAQAGAAAApAA뙚A=qAA{ARAHAA\AApAHAAQA{AA{AA
=A\AGA{AAHApA
AA
=AAA\)AAAAA
=A  AA=qARAA33A\)AGAA\AA=qAA33AA(AA=qAA  A(ApAApA
A\AAA\A(AffA33A\)A=qA  A뙚A{AffA\)AA33A  A
=AAGAGAA  AffA噚A  A癚A\AAA
=AA(AA\)AA{A\A{AQA(ARAA=qAA=qA\)AffA{AApA(A=qAffAzA\AQA{A=qA{AAGA
AA  AGAAAAAHAHAGAA\)AA  AAffARA
AAffA
A
A\)ApA\)ARA{A  AzA{A\)AAA
=AAAHA
AGA
AA33AAffAGAAQA{A{AA陚AQA
=A33A{A  AܸRAمAA߅A{AGAAHAۅAAAQAGAA{A{A
AAAA  A  AAzA  A\)A  AGAAQAGAGAffA\AA33A  AAAGARARAGAAA
AApA홚A홚AQAAA홚AHAAGA=qA
=AGA\)AARAHA\AA=qAzAAA{A
AQA\A\)A\)A=qARA33AHA33AQAA\)AzA{ApARAA\A\)AA33AGAA(A{AAGA{AA  AQA  A
=AA{AffA
ARA=qARAA(A{AA홚AAGAA(A=qARAAA33AAffAffA\)A33A\)AGAAA33A\)AA\A
=A  A
=A33ARAzA\ARA
AAA(AAAAA=qA\)AA33AA  AQA=qA(AAAQAA
=ApA33A  AAA\)ApA33AAAA
=AAffA\)AHA\)A{AzA  AA׮A֣AׅAffAffA
=AzAиRAGAA\)AAAAffARAA\)AAGA  AffA(AAAAAᙚAA噚AۅAffAۮAA
=AffAA  AARA\)A
AAA  AzA(AzAAzAHAQA(A{AAHAA=qApA=qAARA
A  AzA\AAHAA
=A\)A
A\AAffA
=AGAzA(AAApA=qAAAA
AAAA  AA
=A(AۅAׅAمAQAHA33Aޏ\AzAܸRAܣA  AffA{AzAݮAAAAA=qA
A(A\)AzA\)AHA(AAAHAARAzA\AA(ApAA33A癚ARA
=AzA33AAA{A33AffApAA(A33AAHA\AHAQA
AAAQAQA\ARARAA=qA
=AAAzAffA  A
AQA=qAA{AGAAQAzApA
=AApAA
A  AHA홚AQAAQAA\ARAGA\)AGA
=AA
=AA  A=qAޏ\A  A\AAAᙚAՅAA33A=qAAAA
=AAQA陚AGAGAApA
AAffAAzA
AzAffAARAAQA(A=qA=qAA=qApA{A\)A\A33A  AAAA\A
AA\A  A  A㙚A
ApA\)Aڏ\AۅAܣApApA  A
=AܣAA  A\)AۅAzAHAGAffApA
AٙApAۅAمAHAڏ\A{AܸRA݅AHA߮A33AAzAAA{ApAQAݙAAHAAQA
A
AzAAA(A  AARAAGAA
AzA=qAأApAAA{A=qA{ARAڸRA  AGAޏ\A\)AffAܸRA(A
A\AA(A33AA\)AAA=qA߮A33AݮA\)AڣA  ApAݙAffAAA{A㙚AAHAzAAߙAffAAGAffA=qAAAۙAAGA{AۙAffAۙA
=AܣA  A
AApAܣAApAAffA{A33A\)A{ApAQAAQAffA{AAAffA  A
AA{AA  AA33AffAݮAAAޏ\AܸRAAAQAA=qA{AARAzA=qAAGAAzA\)A
=AAA(AAApAQAA33ARAAHAHAA{AA(A  A  A33A=qAQAzA=qAߙAAA{AHAGA33A=qA\)AzAQA
=A
=AᙚAHAAffA=qAGAA\AffAffAQAApAAAA{A
AQA(AAQAA(AHA
AAAzAffA\AA{ApA\AA  A
AzAAARA\A
AAAQAzA33A=qAAA\)AA
=AAQA\AAAA߮AAA\)A{AAAA(AA\)AHA  A
=AHARAAffAAA\AA{A=qAAᙚAA
=AzA\A33AGAAA=qA  A\A\)A  A
=AAAAAAAAQA33A(AGA
AffA陚AzA33A
=A  A=qA=qAAAAAAAA
=ApAAA33A{A
AffA\A噚AffA33A\)AA33AA{AAHAzAzA
=AQAٙA(A\AAQA
A뙚AffA\AAAA  A
=AzAAAA
=AA=qAffAA=qA{ARAGA  AQARA=qA
A=qA{AAApAARAzAAffAA{A{A(AA
=AA  AA
=A=qA\A{AA  AAAA\)AAA=qApAA  A{ApAA\A\A{A
=AQA(A\)AzARA{A(A\A\)AAApAGA\A\)A
=A
A33A=qARA\)AAHAQA
=AA{A(AGAA=qARApAGA(A{AQA(A\AHApAzAffA\)AQApAA(A(AzA\AAۅARA
AHAffAAzAAHA܏\A\)A=qAzA{AAAAARAzAA噚A癚A
AAAA(A\)AzAQA
A33A\AAffARAAAAHAAAzAA(AQAAGAAzAQApAAAA  A\AHA{A
A  AAAAzAAHA
=A33AffA=qA\)AGA݅A33A=qAծA(AzAՙA=qAәA
A{AиRAA  AHAffAzAA  AAHA\)AA
=AAԣAzA֣AAA
AQAzA
=AffAA=qAARA=qA\)AAHAGA{AAQA{AA
=AAAA{AffAA\)AHAzAHAAffAA{AA(AA{AQAAA33A33AA(A=qAQAAA\)A33ARAHA{AQAAAARAAA
=A\AGA33AApA33A
=A܏\AۅAAAHAڣAGA33A(A=qAAffAA{A\AApA
A(AA
=AAAAQAApAA
AQAARAA֣A㙚AHA
AA\AA  A\A{A=qA(A\)A=qA=qAffA=qAGAzAAAAAAzAAzA
AzAGAA(AA
AHAAAQAGA33A  AAzAAA(A\A=qA  AHAAAzAGAAA\AHAQAA  A=qA{AA(AAffA=qAљAzAHA(A\)AѮAApAAApAzAGAϮA33AAQAffA{AծA(AՅAAمAffA
=AׅA33AQAAծA  A
=AHAAQAQA=qAHA\)AAAAARAQApAAᙚAA33A\)AA\)A  AHAA
A
A\)ApA{AAzAffAA33A33AA(A߮A陚AGA\)ApAAAzAA{AA33A(Ȁ\A  A
AQA
=A33A\)A33A=qAzAAGA33AȀ\AəAzAģAAAAAAA\)AA  A33AzAAApAAffA癚A\AA噚AApA\A
AAA֏\AA  A͙AͮAA\)A\)AAAHAAAAGA\)AzApA{AƸRA{A˙AAAAGAA
=AA{AǙAA33A(AHA{AGA  AAGAzAGAARA
A\)A˙AffAARA(A(A(A  AARApAA=qAA
ARA=qAQAAA
AffAHAAA=qAAA¸RAQA\)A
AHAQAzAAAHAAAAQAծA  AffApAծAӮA33AѮA=qA˙A\)A(A
A{AҸRA33A{AָRAA33AAHA=qA؏\A(AAAA
=AAظRA=qAQAffAAGA{AAΏ\A(AAGAA͙AzAAzA(AA33A{A\ARA{AGApAA\A  AQAA  A
AApA33AHAGA(AA(A  AA33AAAA  A
AAQAAffAAffA\)ApA{AzAQAzAA
=AڣARA߅A\)A\)A޸RAzA  AQAzApAGAffAAڣAGAAQApAHAAׅAHAffAGAљAHA
=AAȀ\A(AÙA
=A
=AffA=qA(AəAңAffApA  AHA=qAۅA
=A=qAA=qA{AϙAGAՅẠA\)AϮAGA33A  A\)A=qAAAAA33AzA
AAA(A¸RA{A(A
ApAʸRA33A\)A(AzAυAffA
A݅ApAAAQAܣA{ApAݮAzAGA{AA=qAݙAGAՅAzA33A\)AzAҸRAȏ\AffAיAAHA
A݅A{AAݙA\)A{A
A(AA\)ApAzARA(AAA
=ARAQAGA
=AQAA(AAڸRAA
AڸRAՅAQA(AΣAAAzApAЏ\AAHApAQAϙAУAͮAffA
=AzȀ\A{AffA
AGAzAģA33A{A  ApAݙAָRAGAA  A33AAA{AA=qAᙚAAAA
=A(A  AAA{A(A߅AمAA
=A߅ApAGA=qAA=qA
A33AAGAڣA\)AQA\)A(AHAAظRA=qAۅA  A
A
AA{AA
ApAA
=AA  A(AԸRAʸRA\)AAΣAٮAffAA݅A{AHAGAׅA׮ApAָRA33AHAApA33A
=ApAQAzA׮AٮAQA
A=qAHA
=AأAA
=ApA㙚A뙚ARAAffAQAGAA
=A\AAAffAGAGAQApApA\AAHA33ARA
=AHA  ApA\A(AApAA{A
AAA33A\A{AAAffAA
AA33AQAAAAHAAQA\)AAffAAzAAGApAG@ffAAAA=qAAA33AAAAAGA
A뙚A
AAAAQA  A=qA(A\AA
A\)A
A\)AA(AAA
ARAHA=qB BzBBzBB
=B{BGBBBQBB\)BBHBRBffBpBpBffBB\)BzBHB \BBBB=qB
=BGB
=B\B  AAA{BffB(BzBB =qA\)AAA\AAARAA{A홚AAARA\)AAAAAޏ\AA܏\AQA\ARAGA\)AAAApAffAɅA(A33AzA
=A\)A{AׅAA33AAGAAAQA
A33AHA  AffA
=B 
=B(B33BffBBBBRAB  B{B33B\B\)B  B=qB=qBBGBBB{B
=BffB\)B\)B  B33BGBzBB B=qBffApAARAzA  A
=A=qA33AQA\)AARAHAAAAAARA=qAA\)AAAffAARA\)AAffAffA  AAAA  ApAApA\)A\)A
AHA=qAQAAA\AA  A  AzAAApApB zA33ARARA{BzB=qB B A  AARB RA{AB =qAHApA  AGA(AHA  AA(A
=AzAQAAGAA{A{AAAB {AHAA\AA
B HB A\B33BB=qBB=qB \AAAAA33AAA\)A
A뙚AA
=A홚A=qAAQApA\A홚A{AffAffA
=AAA
A
=ApA
=A  A噚AA33BHB=qApAzBBB{BBBB zAB B{B =qB{BpBpB{BQB{B(BBBRBB33BBzB
BpB B pABRBffB{BBApB
=BAB   B33BB33ApA\AHA\)AffAAzAAHARAGA\AAzAHA\)AAQA{A\)A  AAAA
A33A
AAA  AA{AHAHAAAA{A  AffAAB 
B HB =qAB
=B\)BQBBBGB=qBzBzBzBB{B=qB
=BBzB  BffBzB{B  BBHB=qBBB	  B	{BHBBB
B\)BQBffAA
A=qB ffAAB33B\B  BBBQBAAAAA\A\)AA
=AzAApA
=BBB33BzBB (AAGAAAAAGA
=AA{AAAQAAAHA=qARAAffA(A=qA
=AAAAHA\)A
A33AA  A(ApAA\)AA{AB
=BBB=qB B {B BQB
=BBffBBQB\BRBffB\)BBBBHBB  BzABQB=qA
AB BB
AAA
AA  A\)A噚AAHAA\A{BRB {B AB 
=B HBBA
B {AGA33AAܸRA\)AQA陚AHAAzA  A\)AA\A=qAA(AAAzA
=AAGAHAHApA  A=qAA
=A  AB \)B ffB=qARAAB  AB\)BffB  BpB BQB\)BffB  BB
BB=qB\B=qBHB=qARBRBA
A\)AGB(BB AABHAAB   B (BpAB zAApAB BB33A=qAGAAffAA  A(A\A{A=qAffAAA33AGAA33AGA=qA=qAffA\AQAARApA{AA{A
=A{AAGAA(AGAA33AAAAB
=B33BA\AB 
ABBBB
BBBffBRBpBBBB
=BpBB
B  BB(BHApAHB   AQAA33AHA{AA
=A\AAQAAHA{A\)ApAGA
ApAApAGA=qA33AA
=AA陚ApAQA33ARA
A\AAQA(AQA
=AA\)AQAA\)A  ApAHAAAAAA  AA  ApAA33A33AHA
ARB ffA33BRB=qBRB A
=AAAzBpB (B(A{B B
=B\)BB\)B\B33AGAAGAA(AzA33AA\AffAGA
AAA  AffAAzA  AGAzAAAAHA
AzA
=A
AHA33AQAAAA
AHA(A\AGAzAAGA߮AGA(A  A\A33AA\)AAHAAA  A陚AA(AA\A
=ApAݮA֏\AхAHA=qAA(A\AffA{A뙚AGAzAAA뙚AAAAzAzAٙAA\A  A\AffA(A޸RA(AApAAGAzA  A33A\A{AA\)AAAA\AA\AffAA(A{AHAQAA=qAAAظRA(AA33AϮA{AԸRAأAAۙAAA޸RAߙA߅AAAA\)A
Aڏ\AAəAHAA(AƏ\AʸRAAHAٙA33AݮAA(ARA(ApAAAA  AA\)AAA=qA{ARAA  A
=ARARAA=qA\ApA\AAAA
=AۮA33A33A
ApAQAA33A  A
=AAGAffA
AߙApAGAظRA  AݮA  AA\)AAQApAHAA33AٮApA{A33ApA  AAQAAHAAA
=AAGAڣA33AA{AzA
AәAA{A  AA߅A\)AA=qA  A  B{AGAA\A
=AA(AAA\)AAA\)AAzAffARAAQA
=AA{AB\BB AQA{ABAAA\AffA(BBGBBHB=qB {B =qA{AffA
AQAGA
AA(AHB GBRB
BB\BB
BAAA
=A\AQA{A\)AAAGAARA\)AAAAAA
=AzA
=AAAA\)BHBB HBzB
\B	B
B
B(B
B	B
\)B
(BB	\)B
{B
BBBGA=qBGAA{AB ffB33AAffARA{B=qBHBHB\BB{BBHA\)ABpBB
ffB

B
B	  B
QB33B	=qB 33A
=B{BQBHBRBBpBBB(B pBB  B{A  B AffB (AB A
A
=AffAARAzAQA\A{AHA
AAAHA
B zBGBzBB
GB\)B
  BBB	B	zB
QBRBQBB
BGB(BB  B\BBpBQBQBBB
BBGBGB	QBBB33BzBQBffBpBBB\)BBB=qB
=B
GB	BABQB\)BBzBpB\BQBpB\)BzBQAB(B  B 
BBBpBGBHBGBffBBB  BBGBHB
B
BBBB\)BBffB(BB AB=qBGBGB{BHBBRBBB(BpB
B(BB
HBGB{B\BzB=qB
=B
B  B{BffBB
GBB\)BpBB	B	GB

B(B
B
  B\BBB
B
B33B
=BHBB
=B33B	B
  B  BHBBHB(B{BBBB	\BffB	  B\)B33BB
BHBQBffBBBB	33B
BGBzB
(B
BzBffB
=BBB
{B
zB
B
B
=B(B{B
B
zB
B
  BRB
\B
BBGBRB(B	BHB\)BBB
{B
33B
RBBBHB33BBGBBGBpB
BB
B
\BRBQB
=B
B
=BBBRBB(B{BB
33BBB  B
=qB
pB
GB
RB=qBBHB=qBzBQBpBQB\BBRBBBB  B33B{BB
=BQBB	B
{B
\B
B  B
=B
B{B=qBRB  B33B
B
BB
BB
B
B
B
B	B
BBHBHBpBRB	ffB
=BzB
\B	
=B	BGB
GB
GB
ffB

B\)B  B
BffBQB(B
(BHB33BBHB
=qBzB
BGB
BzB	QB
B	B  B
B\)B	zBBB	=qB
\)BHB	zBB\B
\)AQB=qBBBHB
ffB
RB{BBzBRBGBGB
BGB=qB{B 33AAA{AA  AHB 33BB\)B33BRBpB
=BB\AQAB  BHB\BHBGBBAffB  BB
BHB{B
B	BHB	B	33B	QB
pB	B

=B

B	\)BB=qBHBBHBBBBGB
=B
HBBpBB  BRB
B\BB
  B
B  B{BBffB
B	HB
BB
  BBGBB\)BB AGB
B  B  BB{BQBB  BBB
=qBB{B
A
BGA
=AAAAQAAA=qA  AA
AHA33AffARA(A{AAAAA
=AB GB  B=qBzBRBB33BffBzB
=BGBffB
QB
  BzBHB\)B	B

BGBpBB=qBRB  B
{B
B\B
ffB	B
RB
B=qB=qBB GBffBpBBB
\BB
BRB\BRBBBGB\BRB
BBBB(BB A\)B{BQB A
AzA(AB
B33BzBpB =qB 
=BpB GAB B BB=qB B BQBBBB(B  B  BffBffB   ARA\B \ApB {BGB33BBB  BBQB=qBQBffBB
=B	\B	QB
{BApB	BB  BB
=BBB(BQBB\)BHBRBB(B=qB\BBHBpBBpBQBBpBBBpBB
=A
A33AA\AA
=A
AB ffBBBBBBGBpBQB AAAAzApA
AA=qAA  AB(AB RAB ffB{B=qAAffAHA(BBBB{BAHAB 33B
=B
=BQBRBBB
BBB\BB{B{BRBBBzBB RAA
A33ApB\BBB
BAGA{AB33BzB=qB
B=qBffB  B RB{BABGBAHAABzB33B
=BpAffBB \ARBQB  BB(B
AQA(AAAffB 33AGABRBB(BB(BQBBB=qBffBB(B  BB{BRB	B	QBRB	
=BzBHB(B{B{B =qA
A33BffBzB
BRB  AA\B \BBQAGAAA=qBzBGB BffB
B\ApAARBAAA
A  AQAQB(BB pBA\)AzAffAAzA\)BABA33BHA  AGAAGAAHA  AAA=qAA\)A(A
AAAApA\A
A\)Aȏ\AA
=AAAApA  A\)AzAîAGA{AQAǅAۮA  A׮A\ARAA\)ARA  AA\A
AQAAA33A(AQAA33ARAffA=qAAARA=qA33AAzAAA(AAA
=AAzA
AA(AffAAzA\AAHAAQA=qȀ\AƸRAzAݮA¸RA
AHA33AAAGAHApA\)A
=ARA\)AAAAQAARA
=A=qA33AAȏ\AAzApAffAHAA33AGA\)ApAAˮAʏ\A33AAAA
=AA33ApAAffAA  A㙚A޸RAAAAQA{A
A=qAAA޸RAAHA{ApA  A\)A=qApAffAAHA̸RAAϮAQAzA͙AzAΏ\AQAθRAffAԏ\ApA
=AA
=AAQAAzA(AAָRA33A  A
=AẠA
A㙚A{AQA\)A
=AzAAGȀ\AAAGAQAA{AAAA
=A33AHAAzAAA{AAHA
=AffAAA\A\A\)A\AffA
=A=qAA\)AѮAǮA(A  A33AAAAAAAAAA؏\AAAzARA33AAHA(A\)ApARARA\)AAHAHAAAAA=qAzAA\)AAɮAɅA\)AA{Ȁ\A\)AAA{ApA\)AԸRAffAӅA\)Aȏ\AHAHAQAQAǅAffA\)A  A{AAAǅA  AΣA{A33AQA{A=qA  AzB ffB BzBRAAA
A\A=qA\ARA\)AApBzB{B
AA\)AA  AAAQAAARA{A\A\)ARAQA  A
A33A\)A{AAAzAQBBGBA33ARAGA\A뙚A\AA뙚AHAQA=qAQAQAAGAHA
=A33AAAAApA{A噚AA\AAAAHAAAA{AzAAAQA\AA
A
BQAA=qAGA\ABBBffBBB{BB AB33B\)B  B

=B33B33AzBzAAffB(AARAA{AA  ApA
A33A
=A33AzAAzAABB\BHBBffBGB=qBBAAGAA
ABAAffA{AA{AAQAAA(AAAAAA
A  AffA\AAzA33AA33AHA{A=qAAARA\)A\)AAAA=qA(AAzAzApAAׅAָRAQA\ABzBA  A{AA\A{ApA=qAAAApAHAGA\)AHAA\A33AzA(A{AGAAA{ApApApA33A
AAA
=AQABRA(AGB
BpB  A33A
=AHAAAzAA\)AHAGA
=AGAQA{AAA  A  AffA  AHAAAAHAAAA陚AffAAAGA33A
ARA\A\A33A\A{AA
=ARAAAAAAA
=AA33ApAAQAAQARA{ApAQAA{A{A\AffApAGAAAGA
AAAAA
AAGAAHAffAQApA{AzA33ApA  A\)A\ApAzAAAAGA  AA{A
A\)ApABB A  AAGAAA噚A{ApAA  AA
AA
A\AGAۙAzAQAӮAA
=AffAffAQAA33AA(A(AHA
=AHAB\)BAffA\AffA  AAQAA\ApBBA\)A{AGAA뙚AHA\ARB =qAzA{AGAA(AAGA33A=qAQAA
AAHARB\)BA33AܣA߅AGAAAffAHAHAAՙAGAGA33AA׮AHAAܣAA߮ApApAAAޏ\AffA33AA\AQAA
=AݮAAAA  A
=ApBRAA  BAAAAQAAA=qAAApAAQAHA
AGAARAGA{A  B RB{AGB B{BB33AzA(A
=AAA33ARAA癚A癚A
AffAAApAffA=qA{A33B AAA(AAA\)A{AAzAGA  AAAAAA陚A(AzA(A㙚A\AA  AA
=AAzA  A(ARAHA{A=qARAQA
A
=AA
=AܸRAffAAA
ApAGA  A{ApAA\)AAQApA\)A
A㙚AHA=qAA=qAAB pAGAA  AB
=BAA=qAA33A  ApA\)BAB (BB=qB (AA
B BHBGBB A  A=qAHBzB (BApAAAAffA뙚A
AA\A뙚AzApAGARAAARA33AA\)AA=qAffAA  AAAAAAffA33AAHA=qAARAAHA
AAffAffAAApB{A
AB\)BpB(BB 
=ApAAARA{A\A
AA33B QAAGAARA=qAAAGAAAAAAHA
AB (ApBAAzAAHA\BHApA  AzA(A\)AAQAAޣA33AQAظRAffAAޣAݙARAAAA陚AA(A
AHAA\)AAAA
=AAzAA
=AffAޏ\BRAzAABRAAB=qAAB33B=qBHB	BffBBB
B	BBGBBRBHB	  B
B33B\B
BzB	(BBB
B=qBHBBpB
=BBB  BGBAA  AffAAA
=BB=qBB=qB  B
=B\B B   AQA
=AffAA=qARA
=ApA=qAAQA\)AQA  AHAA33AAzA
=ApAzAGAA\)AAA\ABQAffA{BGB=qBBB
B
BAffBBQBA
AHARB B33B\)B
=BzBBBBGB (B HB=qB  A
=AB {A{AQA\)AGABQB\)BRB33BRB	\)B	
B=qB
=B	{BBHBQB
BQARB(BRARBBGB
=B=qB
AAHAAzA\)A(AA\)AA  A\A(AGAQA33AAAAA\)AHB
=BB  B
=B(BRBB33B=qBBBzBBffBB(BB{BHB
=BBB
=B(B{B B\)A=qBRBBffBBB33B
BB	QBB	BHB	\B	GB	
=BB=qBBRBB
B
BQB\)B\BB\B33BGB
BBBB\BB(B  BHBHBHAAffA33A
BffB{BpB{B(BRB{BBQAGAAB \)A\B
=BA\)AB ABGB(BBB  B
=B\BQBB\)BBQBzBQBBBBBHBHB
BBHB33B
=qB
B
RB
zB
\)BBB
zB33B
(BBB{BBRB\B=qB{B
zBGB  BpBBpB	zBB=qBBHBB\)BGB	\BzBB
=BBB=qB=qB(BQBGB	33B
QB33B\B
=B  B B
=B{BBB	
=BffB(BQBB=qB  BB
BHB  B33BBB  BQBBffBBB B	B
BB	BB
\)B
B
\)BRBBB
B\B
B  BffB
BffB
{B
B(BB
ffBB
B
B\)BzB
ffB\B	B
GBB
BB=qB
BpBffBGB	\)B	
=B	=qB(B=qB B\B\)B	BB
B
B=qBGB
BzB	=qB	BzBpBB
\)B33B	(BpBzBQB	B\)BBGBffB33BBBAAA(AB GB\)B(B AGA(A
=AA
=AA\)A33A\A\)A
ApARB GB  B\)BHBpBBHBHB	
B	  BBGB33B  BBB	\)B33B	  B\)BHB{BzB  B\)BQB  B
B	pBB  BBBQB
BffBAHAAA(AAAGA=qAAB
=BA=qBBzBpB{BB	QB	(BB A{AzAAAA
AGAQAQAARAA(AQAAA
AAzAA=qA{AAAAzA
=ApAAAGAffA{AAzB B (A=qB \)B\BQBBBpBHBpB
B
B(B\BQB\B33B{BB33AAGAApAHAAzARA
=A  A33A\A\)AAffBRBRAAAA33B A{AAAB B \)B\)A
=BB\)BB
=BRB\ApB{BRBHA(AHA=qA=qAA(ApA(A陚A
=A뙚AA  AQA
=AA
AA\A\)AAݮA(AA
AHAHA  A
=AAAQAQAA33A\)A  ABQB pAA{B\)AzB 
=A
=B BHA
A
BBB
=A\)AAA(AHAffA=qAAA  AffAAHA
=AA(AA
=AA  AzAB
BB{B
=AB B{AzAGAGA
AAAffAQAffA(A\)A(ARAA
=AQARAAARAA
=AHA\A=qA{ARA(AAzAAA
=AAQA33AGAAAffA=qA
=AHA{A
AffAQB 
=A33AB 
=A=qAGAApApAA(A\)A33AAGA\A
AHAAffAA癚A(ARAQAGA
AA
AAAGA{ApAB ffB 33AB
=AffAQA=qAGAffAzAAA\AA\)ARAARAA(AA
=AA㙚A(AffAA
A=qA\)AHA(AܣAəApAzAAAԸRAQAAHAffAffA33ApAAۮAۙAffA\)AGA{A
=A׮A  AzAAQAAzARA(Aҏ\AAHAAԏ\AՅA33A
=AхA=qAHA
=AHA  ApAܸRAAAAAA=qAzAGA\)A33AAffAAQAQApA\)AAAGAHA  AAA\)AAA\)A{ApA
=AAApAGA  ARAQAA噚A{AHA33A33A33A(AAzAGARAAAߙAߙA=qAGA
=AzA\)A\)A  AffA\)AAAzA߅AffApAAzAHAHAHAGAHAA=qAHA\A޸RAHA\AAffAA=qApAzAffAمA33A{A=qA\)AffApAGA{AffAʣAծA{AA(A  A
ARA(AAAQA
=A֣AGA\A{AA
AGA
A=qAAAAA{AǮAÙA33AzAA
=A=qA
=AGA£AzA(A33AQAHAÙAîAAAAffA(A33A
=Aʏ\A
AGAAffA{AzAңAAzAAffAAQAffAAA噚AffAA(A
A  A33A  AHAϙA=qApAA݅A
=AAzAAffAQA݅A  AQA
A33AAQAAGAA33AθRAApApAA
=A\ApAݙAffA\A
A  AAAHAHA˅AzA=qA\)A(A
AHAzAθRAЏ\A  AHAA{A
AA33A
=AAǙA\)AAzAϙA{A
AGA{AAffAGAA  AQAQAܸRAۅA=qAܸRAA\AA{A  A߮AA33AAQAHAA
A  AQAffARA
=AffARAzA\AGAޏ\AAߙA=qAffAǙAҸRAѮAHAޣA\)A  AAA\)AzA\)ApAzAхA\)AQA\A(A{A  A{A(A33AGAGAɮA\)A  AǙA{Aԏ\AAAיAظRAA  AApAHAңA\)AAA˙AffAA\)A\)AGAхAԸRA(A  AzA\)AAHAzAָRAAAAHAQAApAAAzA
=A(AAzA33A
=ApAAA\)AzAffAAA㙚ApAAzAAڏ\AָRA33A\)ApAA\)AۅAGAAۙA߮AAffApA=qAQA=qA  AARAAۅAzAԏ\AHA=qA  AУA=qAA  AzApAхAAңApAffAԸRA\)A\)AAffAΣAA\)AzAAGAApAͅAHA(AHAffAffAAffApAA{A\AffAA
=AA  A  AAAAHAzA\)AA
=AffAAGAۮAۮAمA33A(A{A(A\AAAQAApAzARAARA33AffAA\AAA
=A{A
=AffA
A\AAAGAGAAAGA=qAAffAA33A\AA  A
AzAAʣA˅AAAŮAAA  AHA
=A{A  AHA\)A  ApAApAAŅA(AzAQAQAA=qAQAǅAAAǙApAGApApAď\AĸRAHAAAĸRAHAĸRA  A˅A=qAˮA
=ApAQAA  A\ARA\)A
=ARAA33A
A=qApA\)A
ApAAzA33AApApAHAAHA\)ARAHAAA(A\)ARAAAGA{ARAA=qA
=AHAȣAGAA\)AHAA  A33AA
=AAGA(AƏ\A
ApAAA\)AA£AQAARA\ApA
AAƸRAffAA\A33AAA=qAzAƏ\A\)A
AHAAîA
=AŅAApA  AGAHAɮA
=AHApA=qAɮAʏ\A˅A
AHA\)AzAAAA33A  AGA33AAAA(A\AHARAAAAAAA
=AzAA(A\AHA33AA33A
AHA
=AAAGAAA  A{AAAƸRAƸRAAHA=qApA{A  A
=A  A33AHAGAǅA=qA33AAəA(AƏ\A  AAAŮA  A
=A  AAŮAAÙAQA\)AQAřAƏ\AzAzAffA(A\)ApAHAQAAApAĸRA
=AzAffAA=qA{AzAQA
AAHAAA=qA(AQAAffAAA(AGAAAAAAAHAA=qApAA
=A\A  A=qAA{A
A  AQA
=AQA\)ApAAAARA\)AGA(ARAAffAGAA=qA
=A£AîAHA{AffA=qApAQAApA
AɮAGAƸRA=qAAÙA  AAAGA{AAzAApA\AA
=AA(AAffAAA=qAHAAQAA(AGAARAQAzA=qAAAQA\)AA33AAHAAA
=AzAAA=qA\A\AffA=qAA
=A33A=qAAA
=ARAAApAA{A£AHAARA{A  AQARARA
=A=qAGAGAffAQA\)A  AAA  A
A  AA\AA\)AzA(AAA
AffA(A  A  AA  A
A\)AAQAffAffAAzAHA
A33AA  AA
ApAA
AGA{A\ARA\AAAGAAAAzA33AAAGA33AQA33A33AAHAHAAAQAA{A
=AHA  A33A(A
=A\)AffA{A(A  A(AzAAQARAffA\ARARAGA\ApAzAzAzAAffAAAA33ApAAHA
=AA(AAA{AAGA
=AAffAA=qARAAAAAHAQAHAAzA\)A33AQAQAAffAGAGA\AA\AAGAA33AGA(A(AQA\)A  AA(AAAAA{AAAAAAGAAHAHA\AQA
=AA=qA  AQAffA
A33AzAQA
=A33A\AA\)A=qAA  AA\)AQA  ApA
=AAAA\A(A
=A\A33AAzA\)AA\)ARAAffA  AARAA\A=qAHAffA  ApAGA{AApAA33A\)AAAA33ARA  AffA{A{AAARA{A=qAAHAARAGAAzA
AQARAAQAA
=ARAHAA\)A
AHAA  AA33A{AGA33A
A\)A=qAAGAHA{A=qApAAAzAHAHAHAA\A\)A\)AHAAHA  A  AA
AApA(AffAA33ApAAQA  A(AGA\)A(AHAA33AAAQAAffA\A\)AffAzAAA
=AA(AGA  AQA\A\)A
=A\)AApAAzARAGApAAzAQA{A33AA(AffA
=ARAAQAA=qA
=AHAA  A(AA  AzAGA\AAAzAAA\A\)ApApA{AA33A=qARAA{ARAA=qAAAA  AAAA  AA  AGAAAAHAAAA{AHARA\A\ApAffAAHA
A
A
=AHAAffAA
=AA
AA\)AA
A  AAHAA\)AAHAAAAAHAQAA  A33A
=AAGAAA33AA
=A\A
AA33A33ARAffARAAzA33A
ARAARAApAAAAQAffAQAAGAzAHAGAAAGA33A33AzA=qA=qA  A
A{AGAHAAffA
=AAAAA  AAAAQARAzA\A\)AffAApAA
=AA  AffAffA{AffAAAAHAffAAffA33AHA\)AzAAA\)AHAffAQA\A  AApAAA(A(AQAA(AQA  ARAffA  ARA
=A{AHA33AAAQAffAHAA
A
ApAA
=A\)AAA  AQA  AffA{A33A{AffA(AAA\)AA=qAA
A  AAARA  AQApA
AARAAA
A{AQAGAHAzAAAGAAQAARAzAzAzAA
=A33AffAHAApAGA
ARA33A
AAGAffApAzA\A
A(A  A
=AA(AffAHAQAAApApAAHA\AAAA\)AQAA{A\)A(ARAQAA\AAAHA
AA(AAAffAffA{AGA\AzA  AA33AzApAGAA\)A(A=qAA\ARA=qA\AA  A{A{ApA\)A\)ApAA{ApA  AHAAAAA{A
A
=AzApA
ApApA\)A(AA33A
=ARA\A=qAAzA(A(AA
=A  A
=AA=qApAA
AffAAffAA=qAffA  A33AAA=qAGAA=qA=qAAffA=qARA\)AAHA{A=qAAAHAAGA33AA33AAHAA(A\AA
=AAAARAAA\)ARAAA=qA(A
=AApAAA(AQAGAA\)AAAA{AARARA
=AA
AGAffAffA\)AApAAGAAA=qAAAAHA
=A\AA(AA  A33AAzAAAAzA
=AA=qAffAAGAA=qA\A
=AzAGAA{AA\A33AA
=A
=A(A=qA  AAAARAApAAffAAA{A\)ARA\AHAAAzA  A
AA
=AAQAA\)AHAHA  AAAA  AA\)ARAHApAA
AA=qAAAAAAAGA  A
=A\AA=qAAQAAzAAHARA
=AAAAA
ApAA{AAAA  A(AHAGAAAQAAAHA
AGAAAQAAzAQAA\)AQA\)A=qA33ApA=qA=qAA(AAHA33A\)AA{AQAAAzAQAA33AAA\)AA(AAAAzAAGAA33AAAAA{A\AA=qA=qAGA(AAA  AzApA\)ApA33AAQA\)AARAAAQAGA=qA=qAAƣAřA33AzA¸RA=qA33AA
AzAGAAAîA  AAAAA\A
AAffA33AAAQA=qA(AHAA
=A{A\A33AA{A33AffA\AAA33A33AApA\)A  AAHA\ApARA\)ApAGAAzAAAAA=qAA(AA\)ApA\AAA
=AAzAAA
=A=qAA33AQAHAAffAffAA\AHARA33AAA\A
=AffA
AzA
=AQAARAffAzAAHAzA
=AA
=AzApA33AHAA
A{A
=A
A
A  A
A33AAGAApAAA
AA{A
=AA
=AHAAA
=AAARAzA\AA(AGAAAA(AARA\A=qAAAHA33A\A
A33A
A\)AA\AAA\)AApA  A33A
=A\A
ARAGAAA\A=qA\AAARAffAA=qA
=A
=A33A\)AApA\AzAAAApAGA\A
AA=qAzAGAHAA=qAHA
A\ApAAHAAA
=A
=ARA\)A(AA
=ARApARA=qA=qAzAAAAA\)ARA  ARAA33AAA
=ApAAffAQAQA33A{A{A{AAHAQAzAApAA=qAffA=qAAAAGA=qAAffAQA\ARAGAAA
=A
=A
=AARApA{A=qAAAAQARA(AAAAffA
=AGA=qAAAQAAAAGA33A=qA\A  A=qAQA\)AAGAA{A=qARAAAAHA
=AAGAApAffARAAAzARARAApAAQAffAAApAAGAGA  ARAGApAzAAffAAApAAAAAAAGA
=A(AHA33ARAAAAAAGA=qAHA=qAA=qAA  A{AzAHAAAAQAA33AA
AffAHAHAA
A  AARAA  AGA(A(AHAGA  AAQARA=qAQAAA=qA
=A{A{ARAzA=qApA=qA\AQA
AAA{A\AA
=AzAzA\)A
=AzApAffA\)A
AffAzAHAAAApAAA\)AA\)A  A\A\)ARAAAA=qAffAAAAA
=A
AQAAAAffAAffAQApA(AHAA\)AAA{AAAQAffAHAzA
AAGAzAAAQAAA  AHAApAA{A{A
ApA\)AAzAA=qAA33A(AA  AA  A\AAA(ApAQA  A(A{AzA=qA33AAzAzA{A£AÅAGA33AA  AAffAffApAApAHAA\)A(AzAzA
=AA33A
=A{A=qAAAA=qAAAAAA{A(AAA\)ARAA\AAGAAGA
=AA\)AARAA33AAA=qA{AHA
A
=AffApA
A33AAffAAGA
AA  AAA=qAAAAA{AA33A{AHA(A
AzAA{A\A\)A\)A{AAffA{ApApAAzAA33AzA\)AAAAAQAQAAQApAA33AApA\)AQAAA  A{AAzA  A33A
AHA  AGA=qA33AAHAAAffAAAA33AffAA  AApAA{AAQA33AAffA
A\A{A(AGA{AffA(AAA\)AA
AQAAzAApA{AARA=qA
=A
=AzAA{AAAGApA  A(AA33A=qAAAA{A33A
=A
AAAAAAA{ApApARAA
=AARAzAzAQA
AGAQA
=A{AHAHA\AAffAAAAAAGA(A
AGA\AGA=qAAAffAzA\)AQAGAzA
=AAAAQARA\)AA
=AAAAA
=AA\)AAA=qA
=AA\)A=qA=qAAzAAAAAA33AAzAAAAAQAffA{AffAffA  AQA\)AAHA=qAAzA\)AHAQA{A  AA33ARAARA\)AAA\)AA
=ARA\)A(AGAA=qA(A\)A
=ARAffAAHA{A\A=qAAA33AA
=ApARA
A(AAA=qA33AHA\A=qA=qA(AffAAA
=AA\)A\AARA33AHAAzA=qAA(AHAA
A  A(AA
A\A  AAHARA  AAA33AA{ARAGARAzAGAQAffA
=A33AA(AA  A(A{A=qAAAzARAzA
=A
=ARAAHAAA\AA\AHARA  AA33A(A  A(A
AHA
=AAA  A  A
AARAAAAGA\AffAAzAzA  A\)A33A  A33AGA\)A
AA\)A
AARAAAAQAA
A{AA\AQAAHAAAAffA\)AzA  AA=qAzAzARAA\AffARAAQAA33A  AAGAzAAA\A
A{AAGAA=qA\AAffA\AAGAGAGAGA
AA\AA(A
ApAA33A\ApA33A\A33AGA\A{AApAGAffAA33A
AAzAHA\AA\AAApApAAffAAAA\AA=qARAA(A=qAAA\AAAGA33A(AzAA(A=qApA(AARAGAA
AAGAAffAAAQA
A\)AARA  A(AffApApAA=qAQAA33ARA
=A=qA
AA
A
=AffAAAffAAGAGA{A
AHARA(AzAAA
A  A\AffAAA33A=qAAA=qAAGAAAAQA
ARA\)AGARAA(AA\)A  AHAQAAHAGA(AA
A(AzAQAzAAAApAAzAGAAA33AAffAQAA
AA{A33AffAQAA  AApAHARAQAffAHAAAAA33AAA(AA{AAGA  AA{AffAzAAAGAAAA  AAQAA  A
A
A(A=qAAAAA(AAffA  ARA{ARA
=A=qA(A=qAzA
AAA{AAHAzApAA\)AA(A
A
AHA=qAA\A\)ARAGAQAGAAAA
=A  A\)AAffA33AAARA
=AA=qAAAAAGA\)AA
=AAA=qAAHAA
AA
A\AAzAAAAQAAHA\)AAQAAAzAA33AA
A33AARA33AApAGA(AHAAHAA(AAQAAGA\)A
A\)AA\A\)AA\)AA\)A  A\)AffAffAAA
A  A{A  AHA  A=qAA=qAAA{A  A{AA  AQAAffAA
=ARApAAAzA  A  AAA=qAAzAA
=AA=qAA\)AzAA  ARA{AA\AA  A
=AzARA(A(A
=A\)AA\)A
=A(A\AGAA
A
ARA33AAAffAAffAAA33A
=AQAQAARAApA
=AGAQAAA
=AGAAAzAGAA=qAA33ARAA{A
AGAAzAGAzA\AAzAAAA
=AGA\A\)AA33A
AA(AzAA\)AAApAAAAQApAA=qAA  AGAA  AA\)AAAAA=qAQA
A  AGA(AAGAHAAAHAA=qAQAA(AzAA{ARAAA
=A\)AAA(AAAAARApAAGAGAAA=qA{AA
AHAAffAAzA(A\AApA
A=qAAA
AffA(A
AAQA=qAAGA\AAAApA\A  A  AAA
=A
=A=qApAA  AA\)AAAAzAzA
AAAAAAAA
AffA=qAzAA{AA
=A{AAffAAA(AQA{AARA=qAAQAAAAAffAQAzAzAA(AA
A(AA
A=qAAffAAzARAAAAGA{ApAAA
=AA\AA(A
AA33AzAGAzA
A  A\)AAAAA{AffARAQARAAA(A\AA
A33A  AffAQApA
AzApAAGAA\)AAA\AffApA{AAAAzA
AA(A  AffA
A33A
=A\AzA
=AQAAQAAGA  AARA  AffA{A
A33AAGA=qA=qA\AA(A(AAAQA{AA33AGAAGAHAAzAHAAAAQAzA(AHAAGA\)A(A=qA  AA
=ARAA  AGA(AAAApAA
AAA{AzA
ARA\)A
=A=qAHAQA
=AAzA(AA33AAHAARAAAffAQAApA\)A\)A\A=qAA(AAAAGAA\A=qA{A  AA\)A
=A{AAA(AzA  AAffAA{A\AAzAzAA33ARAQAAAQAA\)A
=A{AAA\)AAzAA
A\AHAAHA  AHA=qA
AGAAAGAA\A{AA\AA}Ak
=AASAA
=Aj\AAAAffAA{AhAAA\)A=qAQAAffA(AQARAAHAA{
AAA(A{AA
=AQA=qAAAGAHAAA
=A\A~=qAQA  A=A  A\AAAQA(AA%A(AAzA33A=qAA{A{AAAAAA\AA=qAAHA(A
=A
=AGApAffAAA\A33AA\A33AffA=qARAA  A33AzAA
A  AA\)A\)AA33ApAGAA{A(AHAAHAARAHA33ApA
AzAA{AAAA  AAffAAA  ARA
AzA{A=qAAQAA
AAAAffAQA\)A33AHAA=qAAAApAAHAA=qApARAAGAAAA\A=qA33A  AAGAAAAzAAHAQAA
=AAffAAffAAAQAzA(AzAGA\A
ApARARAQAGARAAAA{A=qA  A  AAGA\)AAHA{AA=qA  A\AAAAAApA\)AffAzAGAA\)ARAzAA\AAA\)A{ApAAffAARAAAAA\A\)AA(A  A{A  A(AA{AA  A\A=qAA
A=qA(AAAA
=A=qAAARA
A\ARA
AAA=qA=qAffA(A{ApAGA\)AAAGA\)ApAffA\AAzAA=qARAAA\)AA
AAAAffAApA
A
A\AzAAHAAAA(AHAA{AAAGA=qARApAA33AzA{ApAAHAAAAQAA=qA{A\AAHA{AA33AA(ApAA{AQA\)AQA  ApA\AGAzAGAzAAAA
AQAAzAHAAzAA\A
AHAGA\)A33AAffA  AAA\AAAA
A
=A
AzA33AzAffAAA(AffA\A
=A
=AQA  A
=A\)A(A\AffA
AAHAARA
AAAAAzAA\AAAApA(ApA\AzARAAGAGA\)A=qApAAA(AAQAAQAApA
=AA
ARA
A  AAAAAA
=ApAA{A{ApAA(A
AAGA33AA  A{AA33AzHAoAb{AYGATAO
AIA3
=A3A{A\)ApAAAAzAAyAmAoAhAeGA[\)ALzAFffA8A0QA'AAQAAQA\)A  ApAzAQA  AzAA=qAAA
A33AAAA  AzApAA}A~=qA
=AHA\A
AGAAQAAffAA=qA
=AyA{A\A\AA
=A33A  AA  A
A\ApARAAHApAHAffAzAA\)AzAQAARA}pA{
AA
=AzA
=A
=AAA  AA33AffAA33A33ApAHA33A\)ARAA  AAAAuA33AAGA\A33A
AHAzA
=A
=A(A|  AGA
=AApA{A(A\AHAA33A
AzAGAA(ApA|zA\A{\)ApA
A{AAAn{ApQAjffAmAqAn\A\AsAnHA|A
AffA~RAAAAAz=qAl(As\)A~HAAApAAHAA=qA33AA\)AA(AQAGApA
AAAA(A\AA~=qA  A{Aw
ArRAs\)At(AuA33AA{AzAyAr\AAffA(ApA  AQAAQAHAARApAApAAAAffAAAA33AzApA\AAApA=qApAAA\)AARA\AA{A\AGAAAHAA(A
=ARAA(A
A\)A(AwAqAl(Ao33Ap  AxzA33AHAA\A
=AA(A{A\)AAzAqA\)A\)A\AA\)AAA(A\)A  A  A{A{A~{AGAGA(AoAmAt(AA~\A~HA~{A|A{
=A=qAQAAAAAQA
=Aj{Ag
AfffAf\AeAgAl(AqAsAtQApAypAuA|A  A(AAGAA{AAHAA{ApAA\A33A=qAAGAA\)AffAAA33AA\)A
A  AA{A{AAAA=qApAHAAA
AAGARAffA(AA33A
AAA  AAAA(AHA
=AAAA33AQA
=A\AAHAA=qAHAAApA\A
A
=ARAQA
=AHAA  A{AAAA{AzAA
A  AAHAHAA\)A33AA(ApA(A33A\)AA  AAHAAAAffAAARAQAA
=AGA
=ApAHAA  A\AAA
AQA
AAARAAAGA\)AHA
=A{A\A
=AA\ApA\AA
AA33AAAAffAQARAA
=A=qA
=AGA
AffA
=AzAA  AHA
=AAffApAAAQAA(AApAAA\)A(AAQAA
AA\)AAA\)AGARA\)AA=qAGA(A\)AQAQA33AGAAAGA
AAzAA(AAAA\AA
AffA(A{A\)ApA{A33A\A
=AzApA(AA=qAzA(ApAAAA\)AAHAzA
=A=qAAHA  A\)AA\AHAQAGAA(A
AzAAAAAAA\)AA33A=qA{A
ApAA
=AzApA33A\)AQAGA=qAHAQAGA\)A(AAffARA{AARAAA{AHA\ApAffA\)AGApApAQAAQAAA
=AffA\)A  AA{ARAA=qA=qAzAAA
=AA(AHAARApAA{ARARAffA(A
=AHAA
AAAAGA{A
=A\A\A=qAQAGA\)ARARAA\)A\AAAAA\AA=qARAQAA(AA=qAHAA\)A\ARAffAA
AA(AAARA
=A\)AA\)AAAAARAGAAQAAGAGAGAA=qA\)AGA{A\)AA(A{AGA(A
=A\AHAffA
=A  A\AAA(AARA
=A(AA
=AHAAAHA=qAAA=qAA
A
=A(A=qA\)AzAAQAAA  A33A(AzA=qAApAAQA(AHA=qA\)AAA\AAffA=qA
AHAGA\)AA33ARA
AAA=qA=qA
=A33AGA\)A
A  AHAAAA=qAffAzAHAzApA
AzAAA{A
AAAffA33A  A\AAffAA=qA33AAGARAAApAAGApARAA{AAA=qA  A{AAHApAAQA\)AffA33A
=A  AHAHAAGApA\)AAA  AHApA=qAApA33ARAA=qAARAzA(A{AAAA\AA
ARAzA\AA(AQApAAffAQA33AAGAffA=qAAAQA\AA\AAQAGA{A(A\)A  AA(AzA\A
A  A=qAGA\)A=qA
=AAGA33A33AA=qA=qAA(AA
A=qAARA=qAAAA=qA
=AAAAARAQAAAAffA=qAA(AAA=qAA33A\A  AQAA=qA33A(A33A=qAGA(AGA
=AAA  A(AAAAAA
AQA  AA33A\AAA33A{AzApA=qAA\AA(AA
=AHAQAAAA  ApA\)AAQA\AAAA{AffAARAQA\)AA=qAAAAA\A{AAA
=AAA(AAA  A33A{A=qA(A  AA\A  AQAA{A\A(A=qAHAzAAGAHA(AAAAAGAzA{AGAAQAAA\AHA
AQAAGA=qAAHAAA33A(AAApAA\AAAA\AA  A\A
=A=qA=qA
A
A{A=qAA
AA=qAARAffA
=AAAffAAA33AAAAHA  AHAA\A
A
A  AA
=A  A\AzAAAAAQA{AffAQApARApAAAA  AQAARA
AAGAA(AQA33A\)AAffA=qAAAARAQAApAAAAAAA
=A  AHA
=A(AA\AA{AffARAGAGApAQA
AQAzA\)ApAHAGA
AAAA{AffAARA\ApAAA  AAQAAAA
ApAA(AHA{A\A33AA\)AAffAAQAHA(A
=A
=AAAAzAAGA(A33AzA33AGA33A
=AGA  A33AAA(AGA33AQAHAGA\)AzAAGAGAAAA(AAAARA\)AzA33AQAHA(AAAAARApAffAApApAA\)AzAA|A}pA}A|  A}A}AGA  AA\)A{A(ARApAA  A  ARAHAzA33AGAHAffAQApA{A(A  A\ApAHAA  AzAAAAAAHAffAA33ApAAzAARAAAzAGA33A\A
=A
=A  A
=A=qAA(A
=AAHA\A{A\)AGA{ApARAA33AffApA\)AA
A(AAApA{AA33A=qA  AHARA\)ARAAAGAAHAA\AGARAffAAHAQAAARA  AzAA{AAAA=qARAAzAA=qA(A=qAA  AffAAAAA(A(A  AzAAGA\A{A\)AzAAffA
=A
=A33AAAA33AAGA33A
AA
=AffA  A\AQA\A\)AQA=qApAHAAAA\AA
AA(AGAA\AAGApAAA{AHAQAAAA33AGAHA33AA(ARAA
A
=A\)AAHAAGA
=ApA
ARAGA=qA{A\)A~{A}A{33A\)A=qAAARAQApAAA33A33AffA\)A{A\AzA\)A
A33A\)AAffAHA(A=qAQAA33AAAGAA=qAGA  A{AAAGAAA
AAffAQA(A{A
AA(AzA
A\A
=A\AAAARAQAA\)A\AA\)A
AAAGAARAAARAAGA\)AAA{AAApA
=A{A\A\A=qAHA\)AAAzAAA(AA
=A(ARAQA  A
=A(A{AffA{A
A\A(A=qA
=AQAAAApAA=qA\AAA
=AAGA\A{AA  AAGA{AQAQAQA
=A(A(AA{ApAAA33AAHAHA
ApAffA\A(A\)AA(ARA
=A=qAHAA=qA(A=qAAA{A{AA  AA{A\)AAA33A\A(A\AffA  A\AA33AQAA33AAGAzA=qA\)AA\AAffAAAHApA33AAQA{AQA33A{A33A{AA\AAHA\AA  AA
=A(AHA
A{ApApAAffA\)AA\)AA
=A\)AAGA  ApA{AA
=AA=qAA{AHA{AA
AA  AARA
=AApAAAQAQAAAAGA(AQAGAAGAAAQAA\A
A\)AA33AAA
AAQAA{A
=AA\)A=qApAAA
AAAHAAHAA
=A
AGAApAAA=qA\)AA{AGA33AQAA
=AAAQA\A\)AApA\AffA
=A(A=qAAHA{AGA\)AA\A33A33A\AAAA33AAAAA\A=qAApA  A\)AzA{AQA\AA\AAzA
=AAzA\)A
=A  AA{AA{AzAAffApAffAApApA=qAA=qAzAA\A\)AAGA  AAQAffA(AAzAzA{AQAA  ARAGAAARA(AApAGA
=AAAffApA
=A33ARA  AAAAzA33A
AAffAGAA{A
AAQAA\AAzAA\)AARAAHAA{AAzA  AAHAHA
AA  A
=AzA=qAAARAAHAAQA
A
=AQARApA
=A=qA~ffA|A33A{AffAQA=qA\A\)AA
AHAAAGApAGARA33AHAAAQA  AffA
AffAAAAAGAffAAAAffAAffAA
A
=AzAAHAGA(AAApA33A{AyGAAA\A  AAA=qA}AA~RAffA{A(AyAyA{33AyA  A(A
=A\)AAAA
AzAA(A\)AAAzA  AAffA  A(AAffAA{ARAARAAA{AGA
=AQA(AAQA(AAAHA(AffAAAAAAHAHAHA=qARAA
=AGApA  A
=A=qAAA
ApAzAffAAzAAA{AffA  AA  AGA(ApAAA33A
=AAAAA
AGAHAffA  AARAAAA\AzAAGAA33ApA  ApAAAAzffAw
AuApA{
A\A|(AwA
=A}AA  A=qAz\AQA33ApA
A33ApAAAA
=A
AffARAA|A~\AHAA(A=qA33AQAGA33A}pAuAr=qAiAk33Ax  ApAlAgAk33Ak
=AoAqGAyAt  Az=qA}pA\)AA~=qA  AzRA  AzRAyAvRAs\)AtA=qAA33A\)ApA  AAA
AAA{A(AA
A\A  A33AzA
AA\)A
=AzffApAzHAzRA33ARAw
AQA33AHAQA=qA(A
=A{A
=ARAffAA=qAAAAA=qA{\)A|(AHAHA~{A{
=AtQArffArffA
=A\A=qAA\AApA=qAAv\AhAsAtzAD(A<zAH(AF=qAG
AC
=AFRAXA_33AepAr\AtAv=qAiA^HAfffAs\)Az{AfRAg
=Ac33A]AS33ARffAQAJRA>{A?\)A=AEAR=qAN\AHA@  AFffARRATA[A]AX  Ac33AQAR=qAQASAVRAP  AJffAH  ASAHQAYAX(A[33APAQpAZ{AXA^HAv{A`QAbRAgAcAW\)A^{AT(AUpAYA[\)A\A[
=Ak
=Aj\Ao
AsAz=qAyGAxAx(AhAiGAQAQAXA[\)A]AgA^RA_\)A\A[33A\zAg33AsApAmAdzAp(AhzAl  Aw
=A=qAxzArRApAs\)A~=qAx(A~{AffAAh  A`A[AaA`zAZ{AWAS
=AQGAW33AW
ANRAaAo33AiAc
=AYA\(A\AgAkAn\AxAffAAAQAuApAuGAs
AA{A
=AxA\)AGA~{A  AAAAGAAQA  AARAQAAffAffA\)ARAAAffA
=A\)AAA\A=qA=qARA
=ARAHAHA  As
A
=AHAw\)AtA~ffApA  AA
AA{AARAA(AA33AzA  A
=A=qA  AA33AQAApAA=qAAAGAzA(A=qAGAARA
=A  AA33A\AA\AHA
=AAA
=A
=AAGAHA
A  A\)AA\ARA  AAAffAAAA=qA(AAffARAHAQApARA
=A(AAGAGAHAAAzAARA33ApA{AA
=A\A
=AAGAffAAAA\AQAA33A=qAAQAHA=qAAAA=qA
=A
=ARA
AGA33AA{AHA\A
AA(AGAQApARAffAffA\A33A(AAAAAQA
=AAzAAA\AA=qA
=ApAAA
AAAA=qAARAAA  A  ARA(AA
=ARA=qAHAAAA33AQAA\AARAAA  AA\)A{AA=qA  AGA{AAAA
=A(A  A
=AzA(ApAAzARA\AzARA\)A=qApARA33AAGAApA
=A(AAHA  AAGA\)AA{AA=qA33A
=AAA\A(ApAAQA
A
=AAGAGAAAARAffA{A(AApApAGApAGAzA
=AA  ARA{AAGAAA(ApA
=A\AA33A\AAAHA33AA=qAA{ARAAAAA=qAARAGA
AAAARAA33AAA33A
A=qA33A33A\)AAHA{AHAAzAA=qA
AffA\)AzAAffAffAA
A{AHA=qAQAA
AAAAA  A
AAAAAffAAAQAAAzAQAA  AAffA
=AAAffAAffA=qAA\)AAA  AAA=qAA\A{AAAA  AAAQApA  AA=qARA\ApAAzAAA
AAA
=AA  AAQA\)A=qARA  A=qA\)A  A{A{A33A
=AAA=qAAAHA\AQAQApAA\)AAHARA  AffAARA(AA(ARA\)AA\)ApAHA\A33AQAApA\A
AA
=AGAAAA(A
=A  ApAA
AA(AA{AAAA(ApAAHA\AA
ARAAA{A=qARAffA{AApA33AQAA33AQA(AA\AApARA\)A(AzA33AffAzAA{AA=qAAAzARAA  A{AzAA  AAA\A
=A
=AApApAQA\)AAQAAQA  AAA(ApAAffAAA\A\AAGA\)AAA
A=qAQARAA33AAAGA
=AAA
AAAAffAAAzA{AAffApA{A(AzAA33AA{AA  A\)AA㙚A߅AHA㙚AGAA\A  A\)A  A(AA  AzAAA33AHAffAffAߙA  AA{AAQA(AA
=A(A\A33A(AAA
A\)A33A{AGAA\A(ARAAzA=qAHAAzAA{A\A
=A(AzA\AffAA
ARA=qAQAAHAمAAޏ\AQA(A=qA
=A\A33AHA噚AA=qAAA
AAA\A=qAGAAQA\)A
A{AAAA陚A  A  AzAA33AffAAzAAA(ARAB QAzAffAA\)AAAGAQAA  A\AAAHAA{AQA33A  A=qAzA
=AAA  A\)ARAAffAzA\A=qA
A\)AAA33A{AQAAA=qA\)A  AAHAGARA
=AA=qA33AQAA{AAA
AQAA뙚AA
A
=A
AAApA\)AAAAA\)AffA=qA\)ApAGA=qA33AGA{ApA
=ApA\)A
=A\)AA{A
=A(ApA\AA\)A{AGAAffAA{A
=A\A癚A=qA
=AARA
=AzAzA=qApAAA{AA  A(AA
A㙚A(A{A33AApA
A(A(AffA  AAQAAHA(A(A(A
A\)A\AffAA\)A\A\)AAAA\A33AAA33A  A=qAAAffARA뙚AAAQA33A33AAA\AARA33AHAzAܣA  ApAzAGA33AffA(AAAA
=AA(A޸RAAAzA\)A33AA(A  AHAQA݅A=qA{AAQAQAЏ\A
=A  A
=AAGA{AApApA=qAAffARAAARAA陚A{ARAHA\)A\AARAGA\A=qAHApAzAڸRA{AGAݮA݅A߅AHAAAzAA=qAGA(A\AAA
=AۮAA
=AУAGAA
=AA޸RA݅A  AGA33AAܣApAAAA33AAGA뙚A\)A\AAׅAQAߙA\)AA  ARApAQAA=qAffA  AHAAARAQAAApAARA33AAA
=BA  A  ARAAzA{AQApARAzAGA{AAA\)A=qA\)ApAAGA33AAHA=qAA\)AHAQAA33A=qApA\)A  AܣAGA
AGAHA{AHA33AHAGA\)AHAffA\AGA33AAA\)AQApAAA
=AzA33AA  A{A\)AGAzAAAA=qAAAϙA33ApAָRARAA
B 
BffB33B{BBzA(AB(BffARAB33A(BzAHAA\)A(A
=A{AAAAA33A{A\)ApAA(A\)AAAA噚A\)AAAA  AHA{A
=A{A݅A=qAzA
=AAA㙚A\AA\AQA뙚AffARA(A\)A  A=qAffA
=A\)A  A33A{AQA陚ApA  AAHAAARA33AARAARB 
=B\BHAAQAARA=qAB33ABBzBRBBB
=BQB(BffAB
AA  AAA{A
A
A\AAGAffAAQA
Aޏ\AAAffApAܣAGA޸RA
A\)A
=AHA=qAAzAGAGAApA{AA{AQAA=qAA(AAzAAzAQA\ARA(A33AAARAHA
B AA(AffAHAQAGAHAA33AHApAffA33AA33AAЏ\AޣAGAAAAA{A33AAA33ARAAٙA  A  AGAأA
=ApAApA{A33A癚ARAA߅AޣAA
A
=AٙApA  AمA{AHA
=AA  AffAA݅AA33A(A  AA=qA\)ApAAAݮAAݙA33A{ApAzAAAQAA=qA
=AffA{A  AHAQAHAA\AAA\ARAQAQAGApAApBpB\AARAAffAAHAHA(AzAGAHB B
=BzAHApAffAA(A  A{A
A\BBRBB\B\)B33BB
BBffBGBQB AAAQAHAzAAA
AϮA
A
=A
=AA{ApA  B=qBHBBB\)BB{BBQB
=BB\)B
=BBRBffAAA(ApA\AB zB{BBQB(B33B HBBQBB\B33ABBBB
=B\BpBGBffARAA\)AAGAHB 33BBzA
=BHBB33B
AB
=BBpBpBzB
BpB\)B(B
BzBHB AAApA
=A33AffApABpBB{B BBBQB33BB  BBBB=qA\ApAA\AGA(AAAGA{AA(A\)A\A
AzA  AܸRA
AA=qAA\AA{AAQAffA  A\AA{AQAA\B HAA(AA(A=qA33AzA{AA\)AA=qA홚A33A=qAffA  AARAHA\AzARAffAffAHA33A\A33AAAAAQAAAAA\)AA(AAGA=qA(ApAQA
=AARAAHAffAAARApA  AGAARA
AzAAA  AHA
=A(A  AAA
=AA=qAAA=qAffAAzAA  AAGA33BBQAHAAHA{A
AA
AAAݮAA  A\)AzAA
A  AQA
AA=qAQAA33AA  AAGARA\)A\AffAA\)AB{BB(BffB{B\BzBAAA  A33ApB   BBB(BB=qBBzB
=BBzB
=BB B{BBB{BBBpAAzAAAApAAAGAAAAB{BHBRA
AApA  A\A\A\A{A  A{AHAA(ARAQA\)AQARA{AAA(ApAffAAAAARA\BB33B{BBB  BHB{B=qAAA\AHB \)AApARAzAGA
=AQA33A33ARA\)AzA=qAHBA
=B QBBBA\)AAAAAAQA33A33A  B RB (BffB 33AAA=qA=qA  ARA
=AA{AzAA{AAAAAA
=AҸRAAQApA
=AzA㙚A(A{ApAߙAAأAA
A  A(A  A\)AA
=ApA
=A  AߙA
=ApAApAAƸRAAffAϙAܸRAAQA{ARAffAApAffARA=qAHAޏ\A\)A陚A(ApARAQAGA33A  A{A=qA{ApAAHA=qAA{A33AzAمAAظRAzAApAAЏ\A(AAzA33AޣAΣAޣAԸRA33A(A
=AAA(A{AQAǅApAGAGAA=qA
AAAAGAAzA
AƣAƸRAȸRA=qAͅAΏ\AA{AGAffAffAAAAHAA33AHAAϮAffA{AHAGAARAAAA
A
=AA=qApAݮARAHAzAͮA
=AQAAA(A\)AAzA
A{AA{A33AzA
A=qAŅA=qA  AffAA=qAAA
=AA  A
ApAGAυA(AAHApA(AHA
=AٮAGAǙA  ApAA\A(A
=ARA  A
=A33AGApA
AǅAffA  AQAA=qAԸRA(AzAȸRA\)A
=ApA
=AA33A{AAΏ\AAAApAҏ\ApA{AAAA
A(A  A݅AARAAθRAzAQAA
=A  AمAGAיA=qAAzApAAAHA=qA{A  AAzA  AAAAzAAQAGAڸRAAGAәAA
=AHA
=AәA  A܏\A(A
=AzAA{A{A  AHA
=A=qAAݮAzA\)AA=qAA\)AAGAAzAzAGAHAQA
=A޸RAA=qA
=A\)A  AA
=A=qA\)A  AAAQAAA  A\AAQA(A\)A(A
=AAzApAA(AAffA=qA  AAAQAQA(AAffA
=AzA
=A=qAA\ARA
=A\AGAAAAAQAA  A\)AGAAAQAffAAHAAGA=qAzA33AA
=AQA
A{AffARA\AAA(AGA33A(A=qA\A\AAAA\)AAA33AAA(ARA(ApAA
=A
=A{AApAGA=qARAzApAAHAffA
=AGA  AAAGApAAAQApAAA
=AAAHAAffAAA\)AHAAAAA
AA(AHAQAAAAAA(AAA
A33A  AAA\A=qAA33AAHAAA33ARAQAA\)AAA\A{A=qAAApAzAA
AzA(A33A=qA  AA=qAffARAzAGAQAߙA׮A=qA
AۙAڏ\A{AQAA{AAHAzA33A
=A33A޸RAA
=A\)ApAA=qAAAAA\A
A{AzA{AffAݮA{A=qAAARA=qA陚AQAAAA(A\)AApA癚AA뙚A  A癚A33ARA  AA噚AGAӅAәAAҏ\AхA(AҸRAffAυAffAУAGAGAA\)AۮAAܣAGAA{AHAAA\A=qA(AGA33AAHAA  A\)AGAA
A
AGAGA(A\)A뙚AGAA33AAQA癚ARAAAGAGA܏\AAffAڸRAA(AA\)AAHAAAAQAAAAAApAAAAGAA{AffA\)AffA(AAQARAHA{ApA33AApAAAApAAARA\)A\)A\A\AAQAAAAAAffAAA
AA
=AA\A
=A\)ARA{AQAQAAAAA{A\)AAAApAA  AAARA=qAzA{ABA
A\AzAAzA33A\)B{B{B\B 
BAA  AA=qA  A
=AAARAARAQA\)AGA  ARA  A
=A(AAHA
AAA33A=qB \AQB B{AAAffA  A33A(A  AAQA\)A  AA߮AffA
A\AHAApA
=AAAA(AԸRAڏ\AAAffAՅA̸RAzAGA  A܏\A=qAܸRAHAAQA=qA{AAHAAAffA
=ARAA{AAHAA33AffA33A{AGAGAARA
AffA  AA\)AHAffARAAGAffAAApApAA{AffAzApA\)AARAQAA\)AA\AA33AA  AAHAA\ApA\A33AA
=AffA(AAA(A
=A\)AAHA(A=qA33AAHA
=AQA{AzA(AAGApAARA  AffA홚AGA홚AAAffA
=AffApA  AApAffAzA
=A
AffA뙚A\A(A(AzAA=qAHARA
AA
=A33AۅA33AffAޏ\A{AA33ApAݮA(A޸RA
=AffA
Aޏ\AGAzAzAzAApAzA(AHA
AAȏ\AHAA¸RA(A\AzApAAApAʣAT  AFRA[\)AQAAAIA0(A"HA{AA6ffAC
=A\QAiAz{As
AupAgAd  AMA\AXASA[
AXzATAR\AK
=AV=qAhzAaAW\)A]AQpA.{AgAmAg
AhAxAtA\Ab{ABRAHAuGA_
Ac
A?AH  AuGA
=AAAAGAffAGAA
A  AdAcAh  Az{A~RApA\)AAAHAAHAQAffA=qAQAApARAAffARAffA33AA\AAp(AjHAj\As
=A  A|AzAlAz=qAffA\)AQAA\)ARAAGAxQA(Aw\)AbRApA`(A`  A[
=AUAOA[\)A~RAyGARAA33AzAffA{AGAA=qAA(A\)AzA
=AA  AA=qA\)ARAA\AGAHARAAHA{AHAh(Ab=qA  ARAAA33A(AAffARA(AffA33A  ARAw
AtAAAAAHA(AGA\AA33ApAzAA33A=qA\)AA
=AAffAAA\)AzffAHA  A{AffA33AAAAAAAA\)AQAzA
A=qARA{A
=AA  AApAffA|zAo33AhAeGAaA|QAtAAGAAA{A{AAAQA\A\AA(A
A33AffA\AzHAAgA33AAA(AHAAA(ARA\A=qA\)A(A  AffAA(AAA  A33AQAAHAA  ARARA\)AAA33AA33AAGA\AzAGA{A
A
AA{A\A
=AHAA33A{AAA\AffAA\AHA\)A\)AHA?n{A{AAAAARA\)AA=qAAGA  ApA  ARAzA(AGAHAA
A(A  AA\)AAffA
=AffAͅAAͮA
AǅAGA33AzA=qApAAzA˅AzARA\AzAAA
ApAHA{A{A
=ApAHAzAA{AAGAAAA\AHAA  AffAzAAQAAA33AzA\)A
AAQAA
A(AA=qApA(AAzARAA(A(A\)AffAHA33AAzAA\)ARAARAApAffA(AQApAAAAAARApAAHAAAGAƣAҏ\AAAAA\)A
=A\)AAָRA=qAzA\)AAffA
=AAA\)AffAAA(AAQA{A\)A
ApA\AQA
=A\)A=qApAzAzAzARAAģAAffAzAA=qAzAARAA=qAzAHA\)A\)AA(AǙAApAծAA(AAA
=A
=AGAܣA=qAGAGAAAA
AQAQA{A33A33AAAffAQAA
=A
=AA=qAAAzAˮAHAϮAA=qA(A\)A\A
=AffAAϮA  AA33AAָRAQAAGAڣAۮAHApA(A  A\)AGA˙AȸRA
AAУAиRAAHAzAѮAǅApAffApAAzAA
=A  AQAAA33AA\)A=qAGAffA  AGAظRAAAAzAQAzAffA֣AHA
AAAQAffA
AA33ApA=qAA  A{AzAAGA=qAAA\A  AA  A=qAzA33AzA\AzAA=qAQAA\)AAAA
AA33A{A
=AA33AA\A
AAA陚ApA\)ARApAA\AAQAHAHAQAHAQAA=qA33A{A\)A33AQAzAzAA
A\)A
A֣AڸRA  ARAzA
=A޸RApAffA=qAAᙚA33A{AA=qAAAAffA33AAŅAAA\AÅAAQA{AAA˅A
AGA=qAAυA33AA(AHAA\)A\)AA=qAA{AGAzA33A
=AffAHA\AHA{AzA=qA\)A=qA(AAffAAAAffA(AǮAͅAиRAθRAѮA
=A(A{AA\)ApA  AAƏ\AGA{AHA\)AхAՙA  A
AB zBzB  B\BBzBB(BB  BBBBB\)BBffB B HB B pApAA\)A
AAAAAAAQAAQA{A
A
=A
=AAAAHAAQAA  A
AHAȣAffARAA\A\A=qAAAAQAApAHAA(AAQA
=AQA(A=qAzA  A
AGAAzAAApAffAA=qA33AAA(AQAk
=AgAhQAw
AffA\)A(ARA33AGAAAffA(AA{A
AGAAAGAQAA\AHA{A
AA33A
AHAffA
AAGAzA=qA33AA\AffAGAAAAzA
AQA\)A\AQARAGAAGA\)AHAHA
A
=AAAAA
AAHA=qA\)A33A{AzA\AAAA33AAGAA=qAA=qAA  AA\)AAGA
A(A(AzAQAŮAHA\)AA=qAApAQAAAHA\ApA
AƏ\AffA33ARARAA
=A
=AAGAHAGAAzAApA=qA33AAAA  A33ARAGAAHA\AA\)AAGAAffA\)A
AAHAԏ\AΏ\AffA
AAAAAGA¸RARAA33AȣAƏ\AzAAAzA  AAffAGAAAAAAffAAӮAQAA33AHA޸RA
Aڏ\AffAޏ\A
A33A\)AzAffARAGAGA(A(AA(AzA\AAߙA߅AzAAGAffAͅAAzA\)A  A(A
Aʏ\A33AŅAAHAљAHA  AAӮA{AA  AAAӮAͮAHA(AA܏\AA噚AAAAڸRAffAͅAGAҸRA=qAzAAAAԏ\AAAzAۅAA
AARAAApAA\)A(AffAffAzAHAHAA{AAA=qAAAAGA{A݅AծAffAzAQARARAARARA  AAA\)AA
=AΣAHA
A
AŮA
A͙AHA  A\)ApAffA{A  AHAAɮAA33A33AA  AхAffAڏ\A׮AߙA{AA33AA{A
AHA(AApAGA
=AGA33A\)ApA=qAיAzA
=AA؏\A33A
=AffA  AA\AGA֣AָRA\)AHA؏\AQAAAAڸRA\)AAޏ\A(AAHA
A{AQARAAApAGAԏ\ApA㙚A  A{A{AzAQApAAQAzA=qAAAAљA
AAظRAظRAAA
A
AGAԸRApAQAffAffAAAHA\A=qAHA\)A
AθRA؏\A
=A
A֏\A
=AffA  A  AAܣAzAGAA
=AAAffAA(A\)AQȀ\ApA  A33A(AAzAffAȏ\AHAffAʏ\AGAGA܏\A\)A{ApAA=qA{AAffAAΣAA\)AAzA=qAQA\)AffA
=AzApA(A(AGApA
A\AGAAzAA\AARAzAAGA
=AAQAApA
AGAA=qAffA  A
=AA\)A  AGAzApAGAA33B(B\B=qBBffB AGAGApB33B {B=qB  BB{BpBRB33B AB=qB{BAAA\)AApA{AAQAٮAAAzAܣA(A(AAAAA{ARAffA\A  A
=AHAAA(AffAffAᙚAA=qA
A  ARApA  ARAQAAGAAA(AAAAzA33ARA{A  AAA33AA
=AA
AGAGAܸRA  B A(ApA
BBB\BBBB=qB =qA{B A\)ARAApAQA\A  B A=qB 
=B AzB HA=qAA33AB ApA33B
AA\)AA
AGA
=A33AApAA{AzAzA\AAzA=qAQA\AA(ApA\)A(AA{AAAffA\AAA
AA=qA
ARApAA33A(ApA33AQAA癚Aڏ\AffAAظRA\)AܣAQAAA\)AGA=qA{A33AA
AAA
=A{AAzB =qAAB zA=qAA\)AAffAAA\)AAAzAAApAA(AAApA
=AffAzA\)AA\)A\)A
B A\A(ApA\AAARA\A\)A
=A
=A\AzA33AAffA  ApAAHAGA{A  Aڏ\AܸRA(A33A߮AQA
AHAARAAARAٙA(AA
=AQAAQAߙA
ARAA  A33A\)AQA33A{A߅AأA{AffA(AAA(AffAA(A\)A޸RA
=AAzAffA\A33AAAARA=qA\)AA=qA(AzAA߮AQAAхAHAffAA33A噚AQAzA
AffAA߮AffA܏\AzA{AУAΣAAAΏ\A
AHȀ\AυAA(AA33AAGAffAA
A=qAAGAʏ\AGAApApAAAzAGAȏ\A{A
AzAΏ\AAљAAffAAָRAGAA  A{A=qA
AʸRAAA33AGA\AAA{A(AAffAGAәAGAծAA\AA㙚AA  AGAGAAA
=AأA
=A
=A\)A\)A33AzAAA33A
AAծAٙA33AA  AA{AQAffARA{AAARAQAHAAA
A  A{A\AHAAHAHARA
=ApAffAA\)AA
=AA޸RApA(ApAAA
AAAGA\ApAAApA=qA=qAffA
A  AA\AzAA=qA\)A  A
=AQA{A\AzAA
=ARAA{AA\AHAA=qAAHA  A
=AzA  AA  A33AAAA\)A(AARAARA\)AAffAffApAzA{A(A33ARAA(AA(A\)AݙAGA݅ApAA܏\A{Aԏ\AԣAA؏\AAHAәA
AڸRAAGA(A\)AffAAQA陚ARAHAHAAAAGAzARA\ApA
=ApAHAAAA  B ffAAzA
=AffAAAAAAffAHAAA=qAAApAffAffAۮA
A܏\AA  AHAffApAAApA(AܸRAGApAݮA
=AݮA(AAApAzA؏\AA
AA=qAA(A
AAzAQA=qAffA\AAGARAQAA  AGAAQAA
A=qAA{A\A  AHA  ApAzAffA33ARA=qA؏\A{AzAffA{A޸RAA
=AzA{AAA뙚AAQAA(ApAzAAA33AAffA  A  A\)A(A\)AAAARA  ARA=qAAAA{A{A  AGAAffA=qA\AA\AAGA  AGA33AۮA  A
AAߙA޸RA=qA{A=qA=qA
AAA  AAzA
=AGAzAA  A=qA33AQAA33ApAAAffAA  AHAA޸RA܏\AzA
AٮA  A\)A=qA
A
=AHAݮA  A݅AߙAAGAHAAAAApAAAAA
=AAApAAAA{ARAAzA
=ARAAAffA\A{AA{AGAA=qAA
=A(AAA\AA  AHAQA޸RAzApARA  AzA
=AAAAAAHAA{A\)AA\AA
A33A  AAHA{AGAA{ApAApA\)AAzA{A\A33AGAA\AAGAGAAAAQA=qAAA
=B   AGA  A
=A=qARAHAAA  A  ApA=qAA
AzA  A=qA
=AHA
AAAAAAzA\)A33AAA
A33A(ApAAAffA  AQARA\A33AA\A\AAAAAffApAAffAQA\)ApA
=AzA
=A
=AA{AAGA{A\)AAA
=A\ApA
=AAA\)B(ApAAA(AAzARA\A(AAAA\AAA(A{AA
=AffAAzA(AAA\AAffAAzA=qAHA
AApARAHA\)AHA
=AApARA\AzA{AAA(AӮARAHAHA
A{AA  A\)AGApA33A
=AHA
A  A=qA  AA=qA33A=qBzAA(A33A\)AzA(A\)AAAAAAA  AA
A\)AB pA33AGBffAAAB QAA33AA{ApA
B\B=qBBpBBBBBB\)BBHB
=BGBBBBBBBBBBAQAAGAAGA\)ARA(A=qAAA
=AzA33ARAHA33AARARAAA\AffAzAAffAQAHA  AA=qAAB(B  BffB{B zB=qAAA
=ApA=qAAApA
A(ApAGAAHAA{B pA{AAAffAB\)A\)AAAHA\AB 
=B B
=BBGBBBAAB ffA
=AApAA
=A33A33A{A
AA=qAAApAApA
=AAHA\A  ARAB BffB(ApA\)AAAHAQAA\)AzAffABB(AB ApAApAA
=AA(AB B  BQB(BBzB  B =qB B \B (B GB pB QB 33B B B B=qB A
AAB 
=B B\)AApAAB B B B\)BBBBB{B  B HAB 33B GB QB GB \)B pB B zB zB A
AA(AA(AGAzA33ARAHAۙApA
=AܣAAAApA{AAAAA=qAA=qA  AffAAQAAAffA{A\A  AA33AAAzA{AAzAGA܏\A\)AA(A
=A{A33A33AAAffA  A
AAA
=AA
A
=A\)AHAAApApA=qAHAA{AQAGApAAHA{A\)A\ApAAARA
AAA\)AzA홚AAffAAQA  AAQA(A\)A
=A(AHAzA(AzA{AAA
=A陚A{A{A
=ARAAffAAAGAAARAAA\AGA\)ApAQA
=ApAzAAGAA\A  AA{A\AffAA33AA
=AA홚A
=AAApAffAAA=qAQA\)AA\)A
=A33A{A(A{AzAzA\A홚A
A\AffAA홚AA{A(AA
=AGAAᙚA\)AܸRA{A(A
A
=A\)A33AA
=A33A  A  A\AHA
=A
A  AzAAAAAAAffAQAffAAHA33A\)AA  AffAA{AA33AAAGAAffAA33AQAA{AQARAAGAHA
AܸRAHAAA
=A\AAGA=qAGA{AA\)AAAAA{AA  A\)AޣA  AAAGAAAAAA33A
AAAffA
=A(AA\)AAA{AAzAAA33A噚AQAAɮAffApAۙAAޣAٙA
AңAzAӮA(AAхAͮAQA  AffAʣAAA\)AQA{A
=ApAA33A=qAƣAHAޣAυA
=AǮAƣA
AңA{AԣAңAAA(A  A=qAGAAυAzAzAȀ\AHA\)AÅAA(AAAzAHA33AA=qAApAA(AA
A=qAzAffA
=A{AQA
A
ApAAQAA
AAHA  A
=AAA  AAzA33A=qAQAA
=AAAA33AGAQA{A  A33AAA(A
=A  A
AQAAA\)A
=AHA{A{ApA
AffAA
=AAAffAAAA=qAA=qARA
=A
A=qAA(A{A\A(AffAzAXASAmA
=AFHAffADQAeAMGAYAZHAR{APAQpAF{Af=qAjHA\  A}GAAA?AEGASAYAUpAMAP(AT(A
=@@@@  A(A	AA33AffA (A*ffAAHA(zA!A\A%pA)A&RA&{A33A
AQ@
=A(AzAA33ApA   AA	@33@޸R@A33AAQ@{@
=@\A33Ap@
@
=Aff@@ff@p@ʏ\A,@{@G@33@=qAz@33AffA!pA2=qApAT(AMAP  AmGA[Ak
=AAzHA33AzA3Af\A/AYAyA8zAsAYAv{AGA,AzA(AA3A
@߮@ff@G@33@G@
=@p@@@R@@@ȣ@@p@(@@Ǯ@p@G@
@  @У@@@{@@  @Q@Ϯ@@@@Q@@ᙚ@@p@33@(@(@=q@陚@{@=qAQ@@Q@  A
ff@ff@@ff@
=@
@z@z@Ϯ@@R@  @\)@R@@@(@
@(@\)@  @G@33@
=@(@@@  @H@\)@أ@@
=@@R@  @G@@H@\)A{AA\)A$(ACA\A#\)A=A(A'AAzA
A
RAA  @@Aff@@p@@p@{@ȣ@@33A A{AR@@\)A@@G@@~{@q@G@@33@z@H@{@A=q@n{@P@'
=@'
=@*H@Mp@H@=p@HQ@!G@?@Q@
=@@$z@@p@\(@p  @2\@*H@B\@L(@Z=q@i@q@H@
@@
@33@ʏ\@@@z@@@Q@p@(AA QA6=qA1GA1A3\)A$A1A7A.=qA"ffA9A@QAF=qAC33A_AXAUGAnHA(AsAaAhAgAuAHA
AqAg
A`QAV\Ac
A`zA[AVRAbHA|A{A  A=qAAAcAhApzAgAuAyAAAA}AypAuAs
A}A~HAyArRAf\A[A^ffAXzAsAzAAmAUGA@  Ac
AzffANHApA33A33AffAiA^{AO
AB{A8  A:=qA>{AC\)A9A'
=A8A   AA@R@
=@=q@G@@ۅ@@(@@Q@@Q@@@Q@R@H@z@
=AA
{@A'
A!pA7A)AA33AA%A!GA{A\AffAzA
=AAzA@@G@@陚@H@33AA{A@@33@
@
=@\)A @(@z@A (A@
@\)A\)ApA
AAA\)AA A=qA%AA
=A0A5A8A;
A=GA\)A%A
=A	pA
=AzA QA#AA
AffA	AAQA	GA	@@@@33@Q@
@AGAA	A z@RAQA&HA\A,  AAA(A(A(AzA33AHA=qARA\A
AA
=A\)AHA*=qAAO
=ALzASAsAW\)A\zAapAyGAArRA{A{
A{AA4(AffA`(A=qAlQAxzAt(AyA^{AzAjffAo
A}pAA(AzA\)AGAAzAAGAGA  AHAGAzAAzAA{A
=AHA\ApA
A(ARAA\)AApA33AA=qAAAQA
=AAA{AAzA(AA  AGAzAAAA
=A  A\)AA\)AHApA33A
=ARAAApAHAřA
A33AA
AA33AAApAffA=qApA{AA=qAApApAQAA{A
AA33AAQAQAffA\AA
=A=qAAA33AApA33A
A
AAffAAzAA\)AGARAGAAAAffAA{ApAQAHA{A  A33A\)AGAA
AAAHA=qA(AQA=qAQAAGA\AAAA
=A=qApA(AGAAffAAAzARAAAxQA~=qAw\)AA
=AA~RAApA(A
=AGA
=A33A\AAAzAAzApAffAAApA\ARAAA(A(A
=AAQAƣAAAA\)Aԏ\AzA\ARAzA  AGA
=AQAAzAAAffA{A33AAޣApAAיAQAυAͅAQAɮAAGAHA£A
=AzA(A\)ApA{A  AAffAApApAAAzARAAGA=qAARA  ApA(AApAffAzAAθRAAŅAGA{A{AzA
A(ApAAӮA(ApAծA
=A33AΣAHAQAȀ\ApA(A  AAAAA
=A(AܸRAHAϮA
=ARAHAA(AڸRA  AߙAA
ARAAQA  ApAzA{A\)AA
=AQAAîA\AģA(AffAzA\)AQA\)AAA
=AAHAA
AAA=qA33AA{A
=AAA  A33ẠAHAͅApAиRAԸRAҸRAָRAٙAݙAQAzAٙAzApAGA
=A33A\)AAAQA  AHA݅A=qAffARAA
=A噚A(ApAAA(AA33AA
=A(AGA
=AAȏ\A˙ApA֏\A(Aڏ\A33A  AAיApAӮAљApApAffA
=A\)AGA{AQAGApAQAA33A(A(A=qA
A\A\ApA(A33A33AAARAA(ApAAA=qAApA㙚AQAQARAQAAA
AzA(A=qAffA(ApA{A33A  AzApAAA߮A\)AݮA{AzA33A  A\AA
=AģAA  A  AA˅AHA£AGAAA\)AHAAGApA\AAA\)A
=ARAzAHARAA
=AAAARAAᙚApAA
=A  A=qA=qAᙚAA=qAAיA\)AGA(AHAAffAGApA33ARA(ApA
=AHAQAA
=AGA=qA
=A\)AffA{A\A
=AA=qA\A
A
ApAՙA
=AAGA{AffAAAۅAAHAAApApAzA
=AAAA{A{AQA
=A
AHAAAQAAAzApAAQA33ApA
ApAA{AffAGA
AAARAA\BpA
=AAAHA
A{AAAQAzAAQA(A\)AGAffAGA  AQAA
=AA
=ApA33ApAGA\)AAzAGAAzAGAAAA(A{AffARA\AAGAA33A  AمAڣAApAffAAB{A\AA{AA33B
A{A(AHAHAGApAHAAffAAAAGAAQAHAQAGA{AA
=AffAB BHAAffAAQAGA33A  ApApAQA  AGAA޸RAHA(A
=A{A
AAApAffAAA޸RA
AAAA=qAA
=AAҸRAңAυAzAA(AAQApA
=AA(A
A33AffAGAzAGAAQAQAQAA=qAzAffAA(AHA{A  AA  AAAA  AQAAzAApAAAGAQAAAA=qAffA\)A\)ApA\AAGA
=A(ARAA
=A33AAAffB BzBQB
=BpAGARAA홚AzAzAHAAzAHBffBBzBHBGA\AأAAHAGAA  A陚A\)AQA=qAzAHAAAHAGAܸRA\)A{A
=A
=AzA33A뙚AQAGAA\ApAAA33A\)A\A=qA\A=qAHAA(AGAffAA\)AAAA  A
=A{AAzAGAQAA\)A{A33A=qApA33A(AQA֣AzAٮAA33A=qAAׅA
ApApAAA{A33AAA33ARAޣAA
=AA{A33AA(A
=AظRAڏ\AۅA
=A\)A(AAAȸRApAA  AQẠAA33ApAzA
AAԏ\Ȁ\AʸRA33A=qAϮAңAУAzAAGAGAzAңA
=AظRAQAAQAARAAA{AA{A
=AAAHA
=A\)AHA{AAAAHAA  A  AAAffAQAڸRAAٙAAGAڏ\A
=A陚AA뙚AAzAzAffA홚AAA=qA=qAAzAARAffA
=AApAA(A\A(A=qA{AA\AHAffA(AQAAGARA
A\)AzAٙAA\A
A\AQAޣAA\)A
=AAGA  AHA\A陚A\AA33AA
A  AQB 
=A  AA\)AQBB{AAAAAAQA\AHA
=A\)A\)AzB A
=A{AffAAzAffAQAHA
=A(AA33AffA33ARAA
=AHA\)AA33AQARApA\)A(A{AA\)AQA  AAAQAHA\)AAA߅A(A(AHAAA  A
A=qAffA(A\AAffA  AAzA(A  ABHA(A\A\)AA33A
=AA{A(ApAA
ARAAAHAAQA(AA\)A
AffAAAAffA\AAAQA
=A  A
=A{A(A\)AffAA\A(A
AAQAzB 
=BB33A33B pApA=qA=qA
=AQA
A\A33A33AB(A(AAzAA
=A\)AzAA\)AffAAzAQAۙA
=AzA(A33A{AQApA{AGAHA  AGAApAQAA
=AAHAQAHApAAAQAAA\)A\AAA
=B\)A  AffB \)A=qA  A\AzAQAAAAA33AAAQAQA
=ARAQBQBAAAAA\AAA
=AAAA뙚B AQAA\)B {AB pAzBpAGB QBB GAHAAHAHAffAQAHAAGAAAAHAAA33AffAGAA
A33AGA  AAGAffAffB\)B(A33AApApAAAA\)AAAQAA=qA  AApAQAAA(AA=qAQAffARAffA
A  AzB =qAB{B33ABBAAB zAApAffAA=qA{B B33B33BBHBQB{B(BBRB  BGBB
B
ARA  A\)AAGAAAAffA  AA33A{A
=A陚A=qAУAԏ\A=qApAA
AAA
A  AzAQA{AHA(AģAƏ\ApAzAԣAffAۮA33AGAЏ\AAɅAAҸRA(AA  A=qAיA؏\A\)Aޏ\AAAffA
AGAA(AAARApAzAA(AA{AffAHA
AAA\)A\)AHA
A߮AQAA  A\)AAAQAGA\)AAQAAQAAAAA=qAffA=qAA߮A\)A33AAA  AffAHARA{A߮AGA
A
AHApAAAAA
A(AApAA\)A=qA(A33AAARAGA=qA33AAAzA\AAᙚA݅A{A\)AAA홚A\)A  A33A{AA(AQAAAHAA\AGA
A=qA
=A
B GB 33ARAHAGAHAQA
ApAHAA\)ApAAָRAمA33AܣAAأA
=AA
A
=AzA\)ApAHAAQA
A  A{A33A֣AA\)AA
AAA=qAHA  AׅAA33AAApA(AQAڣAGA{AffAڏ\AQAzAGAzAAθRAẠA
AGAA{AȸRAHA
=A
=Aȏ\AA¸RA  A  AɅAAǙAffAA\)A{A33AAԏ\A  AA
A֏\A癚A33A
A
A
A  A߅AAHAۅAQAݮAݮAA\)A33AzAA=qAQA
A=qAQAHAظRA
=A33A(AAAQA
A\)AffA33AA  A33A=qAARA=qAAA
AۮAGA
A33AffApAffAޣAA=qAffA
=AGA\)AHAHAAHA޸RAAAGA
AffA\)AzAAzAA33AHA{AϮApApAәA(AAApARA
AA\Aޏ\AAA
ApAzA
AffAA
=AٙAݙAᙚAQA
AA(A\)AAA\)A\)ARA
=A{ApA
=AA(A
AAHAAAApAAA  A33A=qAA=qApAHAA  AԸRAAA(AHApAGAمAA
=AߙAAHAAGAᙚA\)A  AGAA\AA\)AAAHAzAHAQApA{ARApAAGA
AA=qAzApAGAHAA
AzA
AA\ApA  A{AffA  A\)AAA=qAA
ApA
A\)A  AffAQAQAAGApAGAffB33B
BRA\B QA\)AARApAAAAGA
=AA
AA\AffA  AAGAA(A=qAHAAAHA\B zBQBRBB33BB
B
=BBQBpB
=B =qA
=A\B AB(BRBBffBBBBQBffBRB  BB(B\)BQBB\)BffBBB33BpBQAB(B
=BBHBBQBBBzBBBBBffBBBB=qB\)B\BB{B=qB\)BBQBffBBffBffB
B\)B
=B =qBHApB(AAA33AGA
A\AAGA{AARAA33BA{BQB
B=qB \)BQBB{B
=BpBBBB  B\B(BBBRB  BBB
B=qB=qB B=qApB A\)AHB =qB GBB {B B=qBB \)B(BHB\)B\BHBBBBBABBHAffABHBGB
BzBBpB{BBA33B \AA33AAHAAHAQAQAAAAAAAGA\AA=qA{AAAApAGAA\)AffA\)AAAA
=A{A
=AGAQAQA\)A  ARA  AA
=AzA33AB ffA{A{AA{ApA뙚AHAGAzA=qAHARA=qAApA
=A噚A\A
=AA33AAQAAGAA33ApA{AHAAA(A㙚AAA(A
A{AAAARAA{AGAA(AAGAA33AffA=qA{AA
=A  A
=AffA{ARAHA㙚A=qAA\AAffAzApA33AAAA{A\)AˮA(A33A33AϙA͙AՅAÅAQA\)AQA  A
=ApApAAA33A33A{A{A33A  AApAHAApA33AA\A\)A\)AzA  AAGAAAA
AAA癚A
AHAHApAAA
A{AAHAA
AAA陚A33AAA
AffA݅A\)A癚A\)AzAHAAGA\)AڸRAGAzAHA33A  AHAGA{ARA\)AᙚAffA{AffA=qA  AQApA߮A
A֣A̸RAϮA33AQAԣA\)AAffAGA(AffA{ApA{A
AAAQApAzA  AAHAAܣAA\)A=qA߅ApA=qA
AA߅AܣAzApA33AHAծAzA
AA=qAffAAAA  A
=AA=qA\AAQA
=AzA(AzAAQA{AAA\A33A=qAQA
AG@9@   @@@   @   @fff??ff@S33?33?ٙ@@   @33@   ?33?33@   @ff@   ?ٙ?33???  ???ff??33?fff?ff???  ??ٙ??  ?  ??33??L?L?  ???  ??  ?fff?fff?L?  ?  ?  ?fff??33?ff???fff???ff???33?  ?????33?33?33?@@   ?ٙ?  @`  >?   ?   >?   ???@ff?33?ٙ?  ???fff??33?ff?ff?ff??ff?33?  ??ٙ?ff?ٙ?33?ٙ@ff?ff@   @   @   @@9@   @&ff@Fff@Y@y@@@  @@33@ff@33@@@@  @ff@y@  @@@@@@@@y@fff@ff@  @l@  @  @@ff@33@  @y@L@`  @Y@33@fff@@fff@l@y@  @ff@@ff@ff@  @33@@@  @@33@ff@33@@33@  @fff@fff@Y@s33@ff@@@@33@@@  @l@l@9@@  @9@Fff@333@s33@  @l@`  @fff@S33@`  @`  @Fff@L@L@333@   @@@Fff@,@333@@&ff@@   ?fff@&ff@33?ٙ@@&ff@   @ff@333@@@@ff@@@ff@@33@   @&ff@@&ff@&ff@33?ٙ?ff?33@?33@   ?ff?33@ff?ff??fff?33@   ???33??33?  ???fff?????33?ff??33?33?33??33??  ?  ?  ?  ???  ?ٙ?33?33??ff@   ?  ?ff?@ff??ff???fff?L?L?333?   >?   ?333?333?333?333?   ?   ?   ???333???333???333?fff?L?L?L?333?fff????ff?ff??ff????ff??333?333>>>L>L>L>    >L>L>L>L==>L?   ?>L?   ?333?  ?333??fff?L?L??333>???L?333?333??333>>>??   ?L?L?  ??fff??  ?fff?  ?fff?ff?  ?fff?fff?fff?L?L?L?  ?L?fff???333>?   >>??333>>>?  ???  ??ٙ??33?  ???  ?  ?33@S33@333@333@@333@fff?ff?ff@Fff??  ?@ff?33?fff?33???333?L?>>L?   ?   ?   ??333??333??   ??   ?   ?333?L?  ?>?333??333?   ?L?L>?   ?   ??   ?>?   >?333>>?fff?   ?fff?333?333?333?333??fff>?L?fff?fff?L?  ?  ?L?   ?333?   ?   ?   ??L???L?fff???33@Y?33??  ?  ?fff?33?  ??333?  ?fff?L?fff??  ?L?333?333?333?333?   ???   ?   >???   ?333?L??333?L?  ?  ??ff@ff?  ?ff?ff??fff??  ?  ?fff?L?fff?L?fff?L??L?33?ٙ??33?33????fff?fff?33???????  ??????333??  ??  ?  ?33?ff?  ????ff??33?  ??L?  ?  ?  ?  ?fff?L?L?L???   ?333?333?L?fff?L?L?L?fff?L?  ?fff??  ???fff?fff?????  ?  ?  ??fff?  ?L?  ??  ?fff?fff?fff?fff?fff?333?  ?ff??ff?33@Fff@33?ff?ٙ?ٙ??  ?  ?  ??L?  ?fff??fff?fff?  ???L?ff????  ??  ??33??ff?ff?ff?ff?  ??ٙ?ٙ??  ???33?  ?  ?L?fff?@333?  ??  ?ff?33?  ?  @@   ????  @,?ff?33?ٙ??  ?33?ٙ???@   @@ff?ٙ??ff@   ?ٙ?  ?33?33??ff?  ?33@   ?33@ff?ٙ?ٙ?ff?ٙ?ff??  ?33??  ?fff?  ??fff?  ?fff?L??fff?333?L?  ?fff?  ???ff?  ??ff?  ?33?ff?  ?L?333?ff@33@   ?fff?333?   ?fff???   >>>>?>>L>>>>L>>>??L?ٙ?  ?????L?L?fff?  ?fff?fff?fff?fff?  ?333?   ??L?fff?fff?333?L?L?L??   ?L?333?L?L?  ?333?L?  ?ff?  ?ff?L??L?333?333??L?L?L?L?L??333?L???L?L?   ?333?   ?L?L?fff?L?L?fff?fff???333??L?fff?fff?333?fff????   ?   ?>?   >>??   ?L??L?333?   ??>??>>?   ??333?333?L?L?L??fff?333?333??333???L?L?fff?fff?  ?fff?fff?L?L???  ?  ?  ?fff?fff???L?fff?  ??333?   ?L?L?fff?333??333?333??L?fff??333?333??L?333?L?L?fff?fff?fff?fff??  ??L?L?  ?L?333?333??333??   ?333>?   ?   ??333??fff?   ?   ??333?fff?ff?ff??@33@333@&ff@@  @&ff@ff?ٙ?ff?ٙ?ff?  ?ff?  ??ff?ff?fff?fff?fff?  ?L?333?  ?  ??L?L??333?333?  ?L??fff??   ?333?L?333?333?333??>??333?L?333???>?333?333?333???333?333?L?333?  ?L>?L?   ?>??   ??   >??   ?   ?   ??>?>?   ?   ?   ?   ?   ?   ??   ?L?fff?L?  ?fff?L?  ?fff?  ?  @?33??33@   ?ٙ??33?333?   ?  ?ff?  ?ff?33???  ???fff?L?L?L?333???   ?333?   ??333?   >?   ?>L>>>>?333>L>?   ?   ?>?L?fff?   ?333>>?333?333?L??33???ٙ?ٙ?ff?????fff?33?L??L?fff?fff?  >>L>L=>>L>L=>L>L>>?   ?   ?   ????>?   ?L?fff?L?  ?  ?ff?  ??333?fff????  ???333?333?333?   >>?   >>>=>?   >>>>L?>>>>L>>L>>=?   ?   ?   ?L?fff?fff??fff>>>L>L>L=ͽ=>L        >L            >>>Lͽ    =    =>L>L=>L>L===>L>>L>L?   ??   ?>>L>>??L>?fff?  ?L?   >?  >>?   ?   >?   ?   ?>>?   ???   ?   ?333?L?333?>??>>>>L>L>===>L>L=>    ?>>?   ??   ??   ?   ?333??   ??L>>>>>L>>L    ==    >===>L===    =>L    ==>L>=>L=        =ͽ>L>>L>>L>>>L>>==>?   ?   >>>>L>>>>>L>>=>>>>>>L=>>L=>>L>L>>L>L>L    ??L?  ???  ?   ?>L>L>L>>L>LDf=>L>L    Lͽͽ    =ͽ            ͽ;L                >L                    =        =ͽ    >L=ͽ>==;ͽ    >L=    >L=>=>L    >L>L>L>L>L==>>L=>>L>L>>>>L==>?   ?   >?   ?   ?>?L>?   >L    L==    ͽͽͽͽ;ͽ;;L;L;Lͽͽͽͽͽ    ͽ=        =    >L=    ;L            =        ;L=;    =;LͿ           ===ͽͿ                               ===        ==    >L        ;L=>>>L    =>L>>?   =>L>>>L=>>L    ===>    >L    >        >L=>L>L>>L>L>L>L    =>L>=>L    >L>L>L;>L=>L    L    =;L            ;Lͽͽ=ͽ                        =>=    ==>L===;Lͽ>L>L>L=>L=?333            >L>L==>L=>L>L=?L?=    =    =ͽ    >L    >L>L        ==    =    >L                =    =    ;Lͽ    ;L@ff                ͽͽͽ=ͽ    ͽͽ=    Lͽͽ=ͽͽ=                >L    >L>>>>?   ??>L?   ?  >?   >=>L>L>>>L=>L>=    ͽ    ;;L;L;;Lͽ;L;L    L?ff            =                    ;L=    ͽ        ;Lͽ    ͽ;L=>>>?>L>==    >L?=>L===ͽ>    >>=>L=    =>L=>L>L=>>>>>>>=        =>L?333?   @@333@9@&ff@   @&ff@ff@33@   @   @@&ff@33@@   @   @   @   @@@   @@   @33@ff@S33@Fff@   @&ff@`  @l@S33@S33@y@L@Y@y@l@fff@S33@`  @S33@9@@33?33??ٙ??ff?ٙ@ff@&ff@   ?ٙ@   @ff@ff?33?33@@   @33@ff@33@,@&ff@@@33@@@ff@   ?33@   @ff@ff@   @ff?33?ٙ?33?ff@@ff?33@   ?33@   ?33?33@@@   @?ff?33?33@ff@@   @ff@@33@@   @33@@L@L@Fff@,@33@33@   @@ff@   @   @&ff@y@S33@s33@l@l@L@Fff@333@fff@  @  @  @33@33@AA&ffA.ffA`  A.ffAffA;33A(  @@@  @@ff@33@S33@33@  @  @@ff@33@@33@@@ff@  @@  @33@33@  @ٙA33AffA!@陚@ff@A0  @@  @@@  @ffA33@ff@AA   AAAffA33A33AA1A0  A+33A8  A&ffA33A  A6ffADA(  AfffAIA~ffAvffAVffAffAffAAAx  AnffAK33A+33A9AYAlAp  Ah  AqAp  AlA`  A[33AH  AffA,A)A,AffAffA   @33@  @33@33@@  @ff@ff@ff@33@33@@ff@@  @ff@@33@ff@ff@@33@@ff@  @ff@ff@ff@33@@33@33@Y@l@s33@fff@@  @`  @ff@ff@  @33@  @  @  @@ff@33@33@@fff@`  @fff@33@  @@@@33@@@33@  @y@l@L@Fff@,@   @,@&ff@&ff@@  @9@,@33@   @@33@   @   @   ?33?33@ff@   @   @ff@ff?ff?ٙ?33@   ?33@ff?33@ff@ff@   ?ff@?ff?ٙ?ٙ???ٙ?ٙ?ٙ?ٙ?ٙ?  ?ٙ?ff@   @   @ff@@ff@ff?ff??33?33????ff?ff?????L?  ?  ???fff?fff?  ?  ?  ?L?ff??fff???ff@,@@ff?ٙ@ff@?  ?ٙ?  ?ٙ?ff?ٙ?ٙ??  ?33?33??ٙ?33?ff??  ?33?ٙ?33?ٙ?ff??33@?ff????ٙ??ff?33???????  ?333??ff???ff@   @33@@,@&ff@   @?ٙ?ٙ@   ?ff??33??ff?33??fff?  ?  ?fff?L?  ?333?fff>>>?333>>>>>>>?333?   >??333????   ?fff??33?  ??fff??L?L?333?  >?L?   ?fff?fff??  ????ff??  ?fff?L?  ?L?fff?  ?333?  ?L???  ?  ?33?33??  ?ff??ٙ?ff???  ?ٙ?ٙ@   ?ff?33?  ??fff?333?fff?333>>?333??L?333>???   =?L?   ?   =    ====    ==>L    >>?   >>>L>>>>>>=>>?L?   ?=>>>>=>?   ??   ?   ?   ???   >?  ??   >>>>>>>?   ?   >>?   ???333??333?L?L?fff??333???333@&ff?fff?fff?L?fff?  ?  ?fff?333??333?   ?333>?   >=>L?333?L?fff??   ?   ?   ?L?>?333?333?333?L?333?  ?L?fff??  ?  ?fff?L??333?  ?fff?L?333?L?fff???ٙ?ٙ?33??ff??ff?fff?fff?fff?L?fff?L?fff?fff???333?333?L?L?333>?L?333??L@ff?333?fff?   ?L?  ??  ?fff?  ?L?  ?fff?L?333??  ?fff?L?L?  ?fff?fff?fff@ff?33?  @   @ff?33?33??ٙ@   ?ff?ٙ?  ?????ٙ?  ?  ?  ?  ?  ?ٙ?  ???ff??ٙ?ٙ?ٙ?@ff?ٙA&ff?  ?  ??33???  ?  ?  ?ff???ff?  ?ff?  ??ff?  ?  ?33??  ?  ?????  ?ff???ff?33??fff??  ?@   ?@33@@S33@fff@@  @s33@`  @s33@33@9@333@   @@@33@S33@ff@@@@33@@@@33@33@@@ff?33@   @@   ?ٙ?33?ٙ?ٙ@   ??  ?33?ff?ff?ٙ?  ??33??33@333?ff?ff??ff?????  ?ff??ff?33??33?ff?  ?ff?33?ff??  ?ff?ٙ??ٙ?  ??ff?ff?33??ٙ??33??ٙ?ff?ff?ff?33?33@   ?33?33?ٙ?33?33?ff@33@33@@33@Fff@Fff@&ff@Fff@&ff@?ff@&ff@,@&ff@333@33@L@   @`  @Y@@@@33@@  @33@ff@33@  @  @ff@33@y@y@y@l@s33@fff@l@l@Y@Y@Y@Y@S33@S33@@  @L@@  @  @ff@ff@@@ff@  @y@s33@@33@ff@33@@@33@@@ff@@  @33@@@@`  @y@y@y@l@33@s33@  @y@`  @l@ff@y@l@  @@@  @  @@ff@@33@l@@33@@@33@ff@@  @33A  @@ff@@  @ff@  @  @  @@ff@33@  @33@@33@@y@s33@s33@l@s33@s33@  @l@  @`  @s33@s33@y@l@y@l@l@  @l@s33@`  @Y@L@L@Fff@Fff@@  @L@Fff@Fff@Fff@L@Fff@Fff@`  @Fff@Fff@Fff@L@@  @9@@  @9@9@@  @Y@`  @Fff@333@Fff@@  @L@Fff@@  @@  @@  @L@S33@L@L@`  @@  @333@L@L@L@S33@L@L@Fff?33@@   @,@Fff@Fff@@  @Y@Fff@Fff@S33@y@`  @S33@l@Y@S33@`  @y@fff@l@  @33@l@Y@,@`  @,@&ff@&ff@Fff@9@333@333@   @@   @,@9@&ff@333@&ff@@333@   @@33@33@33@@33@@   ?33?33@ff@   @ff?33?33@ff?33?33@ff@   @33@333@&ff@L@fff@@  @S33@@@33@9@333@@  @9@@  ?ff?ٙ?ff?  @@   @33???33?  ??33@@33@333@&ff@,@   @@   @@   @33@   @?ff?33?  ?33?  ?33?  ?ٙ?  ?  ????33?33?ff?ff??ff?  ??ff??  ???  ???  ??333?  ?L?  ?fff???fff?L?fff?333??fff?333?fff??fff?ff??ff????  ?ff?  ???ff?  ?33?ff?ff?33??ff??L?L?L?333?fff?L???333??L?L?L?fff?333???333?L??333???333?333?L?333>?   ?   ??333?333>>?   ?   ?333??333?L?L?ff?  ??   ?fff?fff?fff?L?   ?333?   ?333>L>>>>?   ?   ?   ?>?   ?   ?333>?   ?>?   ?>L?   ?   ?   >?   ?   ??333?   >>>>>?   >?   >>>>L>?   ?   ?   >>L>>>L>>L=>>L>L>>?   >L>>?   =>L=    >L;==    =ͽͽ            ͽͽ    L;L;L=                            ͽ    L>L    =ͽͽ    =ͽ>L>L=    >L=    L    =>L=    ==        >L    >L                        =    =    =ͽͽ                ===    ==        >L    ;=    ?        ͽ    ;Lͽ    ͽ    >                =            ;L    =>L>>L>>L    ?L?fff?>>?   ?L?>>>L>=>L>L>>>>>>L>L>L>L=    =>L>L>L>>>L>>??333?L?fff?   ???   >??   ???   ?   ??L?   ??   ??   >>?333?   >?   ?333??   ?   >>>>>??L?fff??fff?333?333?fff?   >>>>?333?333>>>L    >>L>>?   ?  ?L>>?   ?  ?   >>>>>=>L=>L=    =    =>L>>L>L        >L>L=>L=    =    =    =>L    >L>L=>L=    ========    ===>L>=>L>=>L>>L==>>=>=>>>L>L>L>L>>L>>>>L>L?   ?333??333?L?L?333?L?333>>?>>L    Lͽ>L=>>L?   >L>L>=        =                >>L?   ?333?333?L?L?333>>??L?ٙ??  ???ff??  ??L?  ?33?>>L>=    >==ͽͽͽ=            =;L    ;LͿ   ;L;L;;Lͽ        ͽ    =>Lͽ=?   ???  ?333=?333?>L    ?fffLͽͽ    ͽͽ;L;Lͽ;L        ͽ    =ͽͽ    ͽ=ͽ=;L        ͽ=;Lͽ        ?   >L>L    ;Lͽ;;Lͽ;Lͽ;;Lͽ    ;L;L        L    =ͽ;L==>Lͽ;Lͽ    ;L==ͽ?   =>=>L?   >L===;L    ͽ;L=ͽͽ    L    ͽͽͽͽͽ                    ;L;Lͽͽ>    ==>L>>>@ff>>L>L=ͽ=ͽ>L=>?   >=>>>==    ;L;L;;L;    ;L;L;Lͽͽ;L;Lͽͽ;L;L;Lͽ;Lͽ;L;L;L>L?   L    ;Lͽ;L;L;L=>L;L;L    L;L;L;Lͽ;L=    Lͽ;Lͽ;    ===>L=        =;L;L;L>        Lͽͽ?   ?    =    ;;L;L    ;L;L>L    ;L    >L=>@S33>L>ͽ        L;L;L;L;L;L;Lͽ;L?  @  @;Lͽ=@@  Ϳ   ;L;L;;L;;L;L    ;;;L;L;    ;;;   Ϳ   ;LͿ   ;;L;L;L;Ϳ      ;;>;;L;LͿ         ;Ϳ;Ϳ   Ϳ      Ϳ   Ϳ   ;;;Ϳ   ;;;L;L;;LͿ   ;Ϳ      ;   ?333   ;;;;   ;?ff;;;;;;;;;;L;L;L;L;L;;Lͽ;L;;L;L;L    ͽ;Lͽͽͽͽ;L;;L;L;Lͽ;L;L;L;;L;;L;L;L;L;L;L;ͽ=>=ͽ;L;L;L;L;;L;L;L;L;L;Lͽͽ;L;Lͽ;L;;;Lͽ;L;L;L;L;;ͽ;L    ==ͽͽ    L;L;L;Lͽ;;;L;;;;L;;L;Lͽ;;Lͽ;L;L;L;Lͽ;L;Lͽ;L;L;L;L;L;Lͽͽͽͽ;L;L    ;=;Lͽ=;Lͽ;Lͽͽ    ;L;L;L;L;;L;L;ͽ    ͽͽͽ;L        L    A33ͽ    D33L            ͽͽ;Lͽͽͽ;L;L;L;Lͽͽ            ;L;;L;=    ͽͽ    =======>>>L>L>>>>?>?   ?333??333?   ?L?fff?333???   =>?   >>>L>?L???   >>L>>L>>?   >>>>L>?   =    >?fff?L?333>>?   >?   ?   ?333?333?333?L?L?333??333?333?333?>?   >>>????fff??333?   ?333?333?L?333?   ?fff?   ???L?L?333?333??L?333?L?333?>?333?   ?ff?fff?fff??L?333??   ???333?>?333?333?333??fff?   ?  ?333?   >?   ?   ?333??   ???   >>>?   >?   >?>???fff?   >?   ?   ?   >>>?   =??333?>?L???   >?333??333??fff?333?333?   ?333??   ?   ?   ?   ?   ??333?333?333?   ??333?   ??   ?L?   >?   >>>?fff?333?L?L?333?fff?333?fff?fff?ff?33?ff?33?ff??ff?  ?ff???  ?  ?fff?  ?  ?ff?fff??fff??fff??fff?fff???ff?fff???L?  ?fff?  ??33?   >?  ?33??333???>?   ?333?333?L????L?   >??L?fff?fff?L???  ?L?  ?333?333?333?333?L?L??L?333?fff?L?333?333?333??   ?   >>?   >L>>>L>?   >>>L>>>>>>>>>??   >?   ?>L?   >>>>=?  ??   ?   ??33>L=?   >>    >    >?   >>>L>L>>L>    >L>L>=ͽ>L>=>L>L>?333>L?   @?   ?   ??L?   ?   >=>>L>>?>>>?   ?   ?333?L??L?333??   ?   ?       >ͽ?  ?   ?   ?   >??   ==>=>>L?>>>    ==?   >L?=>>>L    >=>L=>    =>=>L===>L>L>L>=    >=>L>>L    >L        >?ff=    >LD    =>L=?   >L=>L>L>>>=>?   ?fff??L>>>>?   ?L    L>=>ͽͽ;;Lͽ;L    =ͽͽͽͽ    ͽ=    ===    >L==        >>>L?fff>>=;L>L;>>;ͽ    =    =ͽͽ;Lͽ=;Lͽ;L;L;;L;L;;       ;L        ͽ?    >L;L=    =;Lͽ            >    =ͽ=>Lͽ>L>>L>Lͽ>L>L;L                >L=>?   >>?L>>L            >?       ??333?   >?   ?   ?   ?   ???>?   ?   ?   ??fff>>L?       >L>L>?   >?   ?>>?  >?L??333?L?fff?fff?fff?fff?fff?L?  ?  ?L?  ?  ?L?fff>L?=>?>L>L?   >>?333?L?L??L???   >?   ?>>>L=    >L=>L>>>>>L=>>>L?   ?>>>>>>L>?L>>?L>?L?>?   ???>>?????fff????  ?ff@   @ff@33@33?  ??  ?L>=;;=            L        =>L>L=>L>L?    >>>>>L>>>?333?333?   ??333?L???   ??>>>>>L>>L>?   >>?   >?   ?333?   ?fff?333?   ?   >L>?   ??   ?   ?>>>    >L>L>L>>>=>>L>>>>>L>>?   >>?   >>?   ??L??????  ?ٙ?ff?ٙ??  ????ٙ?33?ff?33??33?????L?L?>?>?   ?fff?   ??fff?333?   =>L>=>L>L=>>L=?   >L    >L    ?   =;;L    L=    >L=ͽ        ==>L>L>?   >>>>>>>>L?   >L>>=>>>>?>???fff?fff?  ??333?L?   >>    ?   >>    >L>>L=    =>>>>>>L>L>L>=>L>L    Lͽ>L    ==    =>L>?   >>L?   ?   >>>>>==    L        ͽͽ        ;L        =            ;L;Lͽ;L;Lͽ;L;;L;L;;ͽ;L;L    =        L;;?L=;Lͽ;L;L;L    ;L    L;L;L;;Lͽ    ͽ;;L;L;L;=;L                        =ͽ    L;L;LͿ   Lͽ;   ͽ;Lͽͽ;L    Lͽ    =    =ͽͽͽ    ;L    L        =    L==>=>L>L=                =ͽͽ>    ===ͽ        ͽ        >Lͽ                >L;L=;ͽͽ;L=ͽ;Lͽͽ    Lͽͽͽ=ͽ    L;ͽ;Lͽ;;;    L;Lͽͽ;;L;Lͽ;L;L;        ͽ    ;L;Lͽͽͽͽ;L;;;Lͽ;L;L;ͽ;L;;LDffLͽ;L;ͽͽ;L;;ͽ;    Lͽͽ=        @  =ͽ=ͽͽͽ            =>>L==>>L?>>L>L                    >?   >>>>>>>>>>>>?>>>L>>L>L    >L=>L==    ====>L=    =    =ͽ    >Lͽͽ    =    =    =>L        =    =ͽ>L=>>>==    >L=ͽ=>L=    ?  >L    >L>L>>L>L=>>L>L=>ͽ==>=>L@   >L>>L>L>L>L==>L=>L=>=    ͽ    L    =    Lͽͽ;L    L;ͽͽ    =    ===ͽ>L    ?           ===?   >L>L=>=>>L>>?   >=    ===    ===        >L        =            >L>>>    >L=>L>L>L>L>=>>L>L>L>L>L>L===>L            ;L==        =>Lͽ        >L        >L=>L=>L>>L>>>=    >L==    ===>L>>>>L>>L>>>=?   ==>L    ;Lͽ    =;L                    Lͽ==>>L>>>>==>>>>    >L==>L>L==ͽ                ==        Lͽͽ                        ;Lͽ    =        =>L>L    =    ==    >L>?L?333?333??L?L?fff?  ?L>?L?333?333?>L?   =?  ?L?L>=>L==    ͽ    ;Lͽ;L;L;L        =ͽ    ͽͽͽ;L;L;L;L;Lͽ;L;L;L;L;Lͽ=>L    =;Lͽͽ    L    >L    Lͽ    =ͽͽͽ>L=ͽ=        ͽ    =    =>L>L=>>>>?ٙ    ==>L=>ͽͽͽͽ    ͽͽ;L;Lͽͽͽͽ;L;;Lͽ;Lͽ?333ͽ;L    ==;Lͽ                L;Lͽ;L;    Lͽ;L;L;Lͽ;L;;L;Lͽ;Lͽ;L;Lͽ;L;L;;ͽ;L;;L;    =>>L>>>>L    Lͽ;Lͽͽ    ͽ;Lͽͽͽ;L;L;L;;;;ͽ;L;L;Lͽ=;L;;L;;L;L;L;L;L;    Lͽ;L        L            ͽ;L;L;L    =        =    >L                            L;        L;L;ͽ;L;L;Lͽ;L;L;;L;Lͽͽͽ    >L>>?>=>>=    =>L;L;L    L    ͽ;    ;Lͽ=;L    Lͽͽ;Lͽ;L;Lͽ;L;Lͽ    Lͽ;Lͽ;Lͽͽ;Lͽ;L;L;L;    ;        =            L;Lͽͽ;L                    =    ====ͽ=ͽ                ;L    ͽͽ        L    ͽͽͽͽͽ        ==            ͽ    L=        Lͽ;    ;L;;L?L=ͽ;Lͽ;    =;Lͽͽ?>>=>L>L>L>=>    ?=;L    =>L?    >==    =ͽ;Lͽ    ͽ=;L;L;L;Lͽ    ͽ        ͽ    ͽͽ=ͽͽ    ͽ=    ==ͽ    =ͽ                =>L    >L>L==ͽ>L    ;Lͽ=ͽ;    ;ͽ=ͽͽ;L=>L=    >L;>=;Lͽ;L=ͽ    =ͽ    L    ͽͽ;L;Lͽ;Lͽ    ==>L==>>Lͽ==ͽ    =ͽ            >L=>L>L>>L>L>>=>L>L>L>L    ==;L=ͽͽ;Lͽ>=>L>L>L>>>L>>L    >L>Lͽ>>>L>>L=>>=>L>L>L    ?   >>Lͽ    >>>>>L>>>>=?333>>>>L>L?fff>=>L>??   >>>?   ?   >?   ?   ??>?333?  ??fff??fff?333?fff?L?  ?  ??  ?333?333>?   ?333?333?333?>>>?>?   ?  ?333>?L?333?fff?  ?333??333?  ?fff?L?L?L?  ?fff?L?L?L???333?L?fff?333>?   >?L?  ?333?L?fff??fff?  ?  ?  ??ff?  ????  ?  ?ff?fff?333?L?L?333?333???333?L?333??   ?333?333?L??L???333?ff?ٙ?ٙ?ff?ff????ff??ff?ff??ff?ٙ??ff?33??ff?ff??ff?  ?fff?  ?fff?33?????  ?  ?ff?ff?33?  ?fff?fff?ٙ???33@   @   ?33@??33?ٙ@   ????ff?ff?ٙ?ٙ@   @   @33?ff?ff???  ???33?ٙ?ff?ٙ@   @ff?ٙ@   ?ٙ?33?ff?  ?  ?  ?  ?333??fff?  ?fff?  ?????33??ff?  ?33?33??33?ff??33????  ??  ?L?ff?fff??fff??  ?fff?  ?ff?  ?????ff?fff?fff?L?333?333?L?fff?L?333??333????333??  ??333?333>?   ?   ??L?333>L?333?   >?   >>>>>??   ?>>L    >>L>L>L>>?   ?   >?   =>L>>    >L?   ?   ???L?  ?  ?  ?L??fff??333?  ?fff?333?333?  ??   ?fff?>??333??333?333>>?333?33?L?333?333?333>>???   >>?   >??   ??   ?   ?   >?>>?>>>?>?   >==>>??fff???   ?   >?   >?>>>L>L=>L?   >>>>>?   >???   ?333>>>L>L>L?   >?   ??>?   >L>L==    =>L>L>L?       >?   >>    ?   ?   ?   >>=>>>L>?>L>??>?L?333?  ?333=?   >>===    =>    ͽ=        ==>>L==    =      >?fff>L>>L>ͽ>L>>>?L>>?>?333???L??  ?L??   >?fff>>>L=>Lͽ=>            ͽͽͽ;Lͽ;L;;L        ;    =?   >?>L?333=>L>>==    >?>L>>?   >>>>>L>>>?333>    =>L=    >L>L===ͽ    =?333>    >L        =>?fff?L??333>?333??333?   >=?   ?L?333>>??fff?L?   @   >L?   =    >=    ?333ͽ;L    =ͽ>L?   ͽ??>L    ͽͽ=ͽ?ff>L@>?>?   ?L?>?>?   >?  ??   ??L?@   ?@   ?fff>?=?333?   >>?fff?   ?   ?L?333>=?fff    >?   ?L?   >>L>=?   ?L?333>L?   >>?   ?333?fff@>L??   ?   ???   Aff??L?333?   ?333>>>?   ?333???>?>>>L    >?fff?   ?   ?333>=;L>@  ==>L>?ff?               =    =;?       =>>>L=ͽͽ==>>L=>L>L>L;Lͽ>L>L>=>>L=>L?    >>?>L    ??       ==ͽ?fff>>>    ?L=ͽ>L==>L    ;L;;L;;Lͽ?    =??   ?@Fff>L?   >=>>>L?L>L    =        =;L=ͽ    >=>L>L==>L>L=>L    =?    ͽ    L>Lͽ;            ?       =>==>    =>L>L    =    ==ͽ;    ?   L;L;Lͽ        L    Lͽ;L;L;;=>L        ͽ        L>L>?  =?fff    ?   ͽ;    ;Lͽ>L;Lͽ        ?   =    >L?  Lͽ;    ͽ        ;L    >L?fff>L    ==;;L    L=ͽ@@  =@@  >ͽ=    >L    >Lͽ>    Lͽ>L;>    ;L=ͽ?   =>    =ͽͽ;;>;L;L>Lͽ    ==>=;L    ?L        =    >L=    Lͽͽ>Lͽ>?333ͽ=?       ?   ==;L    ͽ        =ͽ    =ͽͽ>L    L;=;L    ?>===ͽͽ>L=??   >>L>L>L>L>L?   >L            ==        ==Ϳ   ;Lͽ;L            LBfff>L;L?=ͽͽ;    ͽ        L=ͽ==?   C f=>=>L>L>L>L>==>    >=?333    >?333    >?   =ͽ?   ?   >L=Aff        =>L=>L    >>L=?   =    =;L;        L?   =    =ͽ;L;L==ͽ;L    ;L?>    ;?   ?    @33>L;Lͽ    ͽ        >==>L    ?   =ͽ=ͽ=?L>==>L=    ===ͽ                ==    ͽ;L=        >L?L    ?   >L@333=>Lͽ    =>L>Lͽ>L>L;Lͽͽ    L;L=ͽ    >    ==>L>L    >L?>>    =ͽ=?       ?333?       >?>L>L>L>=ͽ;=    =>        =?Lͽ>L>    ==?                >L==>=;L=>L    =>L>>?   >>??333>L>>?  ͽ;L=?L?   ??ff?333?L?>?333??333?L?ff@?ff??L?   >>?   >>L>??ff?   C@ ?33?>?   @@  ?   >L?33?ٙ???fff?  D ??L?  ?  ?333?ff?fff?L?fff?L>?>L>L>        >L>L    >L    >L>L>L    >?ff>L>?L>L>?   >=>>>L=>>>L    >@33??333?   >?   >L>?L@ff??>L?33>@?>?333?  =>>>?333??   @  >>>L>>>?fff?333=>?33>L?   >L=>L>>?fff>??   ?333?L>@33@@  @@33@@@33@  @ff@33@@ff@@@陚@  @陚AAA   AffA)A#33ALA4Ak33AqA.ffANffAk33Ah  AA>ffA^ffAC33AFffA@  AA(  A9A!AVffA)A#33A>ffA0  A(  A`  AX  AA   AVffA<AC33A;33A;33AP  AH  A   AFffA{33AfffAc33AS33AIAc33AP  ALAc33A$A333AP  A(  A(  A!A4A\AlAh  Ah  A\A0  A+33AffAAA33A  AAffA$A333A  AAffA#33AffA  AAAffA33A  AAff@ff@  @33Aff@ff@ff@33@ٙAffA@@陚@陚@@  @  @  @ff@@33@A8  A33@ff@  @33@  @  @33@ə@33@33@ə@ff@  @ff@  Aff@ٙ@@ff@A@@  @@33@ə@@ff@@33@33@@33@ff@ə@33@ə@ff@ə@  @@@@ff@  @@ff@ff@  @ə@ff@  @@  @@33@ff@@@@33@33@@@  @33@33@ff@  @@@33@@ff@33@33@@  @@@  @33@ff@ٙ@33@ff@@@33@ə@@ff@33@ff@  @33@ff@  @  @ff@ff@ff@33@ff@33@@ff@@Aݙ@@  @ff@@33@  @33@ff@@  @33@@ff@33@ff@ə@33@ə@@ٙ@ٙ@33@33@33@  @ff@ə@@@  @@@@@  @33@  @@@  @  @@  @ff@ff@@ə@ff@  @  @陚@陚@ff@33@33@  @  @  @ٙ@ff@33@33@33@ə@  @33@ff@ff@@ff@33@ə@  @ٙ@ə@ə@ə@  @  @  @@@@ff@@33@@@@33@33@ff@33@@33@@ff@ff@33@@ff@@  @  @@33@@33@  @@ff@@@ə@@  @  @  @  @33@33@@@  @@@@@  @@@@33@ff@@@ff@@ff@33@ff@  @ff@33@  @@ə@33@  @  @@@ff@33@33@33@33@@ff@33@33@  @  @@ff@@ff@ff@@ff@  @@@33@@@  @33@@ff@@  @@  @@  @ff@@ff@  @@  @@@@  @  @@33@33@@@33@33@33@@@ff@ff@33@33@33@  @ff@ff@33@33@33@  @  @ff@  @  @  @@@@  @  @  @33@ff@33@ff@ff@@33@33@ff@ff@33@33@ff@33@@33@ff@  @ff@33@33@ff@ff@ff@33@@ff@@@@ff@@ff@33@@ff@@@@33@  @@@@@ff@  @33@@@@ff@  @33@  @ff@  @@@  @@@@33@  @33@ff@@33@@ff@@@  @@  @@ff@@@33@ff@ff@33@ff@ff@ff@ff@ff@ff@ff@33@33@33@ff@ff@ff@ff@ff@@@  @@  @@@33@@33@  @ff@ff@@ff@33@@ff@ff@@ff@33@33@33@ff@ff@ff@ff@33@ff@33@ff@33@ff@@ff@ff@33@ff@33@33@@33@ff@ff@33@@33@  @ff@  @33@@@@  @  @ff@  @ff@33@  @  @@  @@  @@@@  @  @  @  @  @@  @33@@@@  @@@33@@  @@@ff@@ff@@@@  @@@@ff@@@ff@@l@ff@ff@@ff@@@  @33@ff@33@33@  @@33@33@ff@@@@@33@y@l@  @33@ff@33@33@@ff@@@@@  @y@  @  @y@  @  @  @33@33@  @  @  @  @  @@ff@33@  @33@y@33@y@y@l@l@l@y@s33@s33@s33@y@y@  @  @s33@s33@fff@s33@l@l@l@l@s33@l@lA  @  @  @ff@ff@33@ff@  @  @s33@s33@l@Y@y@l@fff@L@l@S33@Fff@ff@33@33@y@  @  @  @y@  @`  @ff@y@y@y@s33@s33@l@s33@`  @fff@l@fff@33@@33@y@`  @Y@`  @Y@Y@Y@S33@L@Fff@@  @Fff@Fff@Fff@@  @Fff@L@Fff@L@S33@Y@Fff@Fff@Fff@@  @9@@  @Fff@Fff@@  @@  @9@@  @`  @S33@S33@s33@@  @  @  @@ff@  @s33@fff@Y@S33@fff@Fff@LA@Fff@Y@`  @`  @Y@Y@S33@Y@Y@Fff@`  @L@fff@@  @`  @Y@S33@l@Y@L@`  @`  @l@l@l@`  @s33@fff@fff@Y@L@L@S33@L@L@L@L@L@L@S33@S33@,@@  @333@,@9@Fff@S33@S33@L@9@L@33@l@S33@33@  DFf@l@  @fff@  @@33@`  @  @  @@  @  @l@s33@fff@S33@`  @  @l@y@fff@Y@l@fff@Y@S33@s33@s33@fff@fff@ff@33@33@  @Y@s33@9@L@@  @&ff@L@S33@@  @S33@L@ff@33@ff@33@y@@@33@s33@Fff@Y@`  @l@S33@S33@@  @l@  @y@  @S33@`  @l@fff@fff@fff@@@33@@@  Aff@ff@  @l@fff@fff@L@`  @  @ff@  @ff@  @`  @333@s33@L@fff@S33@fff@l@y@l@33@ff@33@fff@l@fff@  @@  @  @ff@@33@ٙA@@@ə@@陚A	AA+33A[33Ax  AtAiA[33AffAAc33AffAh  A4AtAAA  A33AAffA  A  A  A  As33AVffAQAYA<A>ffA8  A1A(  AA33AA!AffAffA	A33@ff@@33@  @33A   @A@@Aff@A33A33A	A	@33A   @@  @  @ə@33@ff@33@@  @@33@ff@33@33@ffA33@  @@@陚@@@33@陚@ٙ@ff@  @33@ٙ@  @@@ə@  @@@33@@@33@@ə@@ff@@@33@ff@@ff@33@  @ff@@ff@33@  @@@  @ff@  @ff@ff@ff@  @@ff@@@@@  @s33@ff@33@  @33@@@ff@  @@  @33@@l@@ff@ff@s33@33@33@  @@@  @33@@@ff@ff@  @ff@ff@@ff@@ff@@@@@ff@ff@@33@  @  @@  @@@33@33@33@ff@@33@ff@@ff@  @  @  @  @@  @ff@33@s33@  @@@ff@  @  @  Al@`  @  @y@l@S33@`  @`  @9@Fff@@  @@  @9@333@Fff@`  @Y@`  @S33@9@Y@l@S33@Fff@Fff@fff@L@@Fff@Fff@333@,@33@9@,@Y@S33@  @fff@L@S33@`  @s33@  @s33@y@33@33@33@y@l@fff@s33@S33@`  @fff@s33@l@@ff@ff@33@@fff@ff@ff@L@`  @Y@L@l@S33@y@y@L@S33@@  @9@,@&ff@@  @9@333@Fff@@  @333@@  @9@@  @@  @&ff@333@&ff@@&ff@&ff@333@9@,@,@9@9@,@,@333@9@@  @,@333@@  @@  @&ff@333@L@Fff@Y@S33@Y@L@,@33@,@,@&ff@Fff@@  @   @@,@   @@   @@@@33@33@@@33@@,@&ff@&ff@&ff@,@,@,@   @333@,@,@,@&ff@,@,@   @&ff@&ff@@333@,@@  @333@@  @Fff@,@,@333@&ff@,@333@9@,@9@Y@ff@33@   @@ff@   @ff@   @33@   @   @   @,@,@@@@@   @@33@ff@33@33@&ff@ff@   @   @,@&ff@&ff@33@@@@33@33@33@33@33@   @@   @   @&ff@@&ff@   @@33@333@@@33@33@33@33@33@33@33@33@33@33@@@@@@&ff@   @   @&ff@@&ff@   @&ff@&ff@&ff@   @33@,@@@@@@@   @&ff@   @   @@   @@33@33@,@   @33@33@   @   @33@&ff@33@33@   ?33?33?ff?33?33@ff@ff@ff@   @ff@@@   @@@@   @33@ff@33@@33@33@ff@33@@33@@&ff@@33@@@@@33@33@33@33@33@33@@   @   @@33@ff@33@@@33@@33@33@@@@   @33@   @@@   @33@33@33@@@@@@@   @,@ff@   @ff@   @   @ff@ff@33@@ff?33?33@   @ff@ff@   ?33@@   ?33@@?33?ff@@ff@   @33@ff@@   @   @@@@   @@33@33@33@@@@ff@@@33@@   @33@@@@33@@@33@   @@33@@@33@@33@@33@33@@@33@@33@33@33@@@33@@@   @   @&ff@   @&ff@   @   @   @ff@33@@   @,@   @@&ff@33@@@@@ff@&ff@   @@@   @??33@@ff?33?33?ٙ@ff@ff@@ff?ff@?ff?ff?ff?ff?33?ff@   @ff@ff@@   @?33?33@@@@@   @9@,@9@,@&ff@@   @   @   @   @@@@@33@@   @@33@@@33@33@33@@&ff@,@@33@   @   @&ff@   @@@   @   @33@ff@ff@ff@33@@@   @9@33@33@@@   @   @   @&ff@@   @   @33@@ff?ff@?33?33@?ff@   @33@   @@33@@@33@   @@   @@@33@   @333@333@&ff@333@&ff@9@9@333@333@,@,@,@,@&ff@&ff@   @   @,@333@@33@   @   @&ff@333@33@   @&ff@   @&ff@   @&ff@&ff@   @333@&ff@,@,@9@9@@  @333@9@333@333@Fff@Y@,@9@333@333@  @@  @Fff@9@333@   @33@@   @ff@33@   @,@@,@33@   @@   @33@@&ff@   @33?33@@33@@   @@@   @   @33@   @33@33@   @@@33@@33@33@33@   @@   ?33@33?33@@   @,@333@@   @,@   @&ff@&ff@   @   @   @   @@@&ff@@   @   @   @   @   @   @@   @   @   @@@&ff@&ff@   @   @@33@   @ff@S33@   @&ff@,@   @   @&ff@@ff@@   @@&ff@   @33@,@L@ff@Fff@@@@ff@@33@   ?33@   ?ff?33?33@33@@ff@?33?33@   @   @@@fff@ff@ff@33@@@@   @@@33@ff@@@@33@@33@33@@ff@@ff@ff@@ff@@ff@@   @ff@   @   @ff@   @ff@   @@ff@ff@33@?33@@33@ff@@   @B733@ff?ٙ@ff@ff@   @   @ff?ٙ@333@ff@,?ff?ٙ?ff@33@   ?ff?33@   ?ٙ?ff?ٙ?ff?33?33?33@   @   @   ?33??@  ?33?ٙ?33@   @   @   ?ff?33?33@ff@@@@   @33@@@&ff@   @   @33@@33@@ff@@   @ff@@@ff@ff@@ff@ff@ff@33@33@33@@33@33@   @   @,@@,@@33@@ff@ff??33?33?ٙ?  ?33?ff@   ?  ?ff?ff?ٙ?ff??ٙ?33?33?33?ff?ٙ?ff?33??  @   ?@@   @ff?ff?ff@   ?ff?ff?33@@?33@33?33@ff@ff@ff@ff@ff?33?33@ff@   ?33@   ?33?33@   @   @   @@33@@ff@ff@33@&ff@@ff@ff@   @   @ff@ff@ff@ff@   @@ff@   @33@33@@@33@33@?33@@   @ff@ff@@   @   ?ff@@ff@   @   @   @,@33??33@?ٙ@Fff@   @  ?ff?ff@ff@   @ff@   ?ff@ff?ٙ?33AP  @ff@   @   @@@  @Y@9@   ?33@   ?ff?ٙ@@ff@ff@   ?33@@   @ff@ff@   @   @   @ff@ff@   @   @33@   @ff@   @   @@@33@ff@   @   @   @   ?33@   @   @   @   ?33@ff@@@@33@@33@@ff@33@33@ff@@@   @ff@   @   ?ff?ٙ@@   ?33?ٙ@   @   ?ff@ff@   @ff@   ?33?33?ff?33?ff?33@   ?33@??ٙ?ٙ?33?ff?33?33@ff?ff@@   ?ff?ٙ?ٙ?ff?ff@   @   @ff@@33@?ff@@ff@@   @   ?33@   ?33?ff?ff?@   ?ff@?33@ff?33@   @   @   @   @   @ff?33?33?33?33@   @ff@ff@   @   @ff@ff@@@@ff@ff@ff@   @ff@@ff@@ff@   ?33@ff@ff@@?ff?ٙ@   @ff@   @@ff?33?ff?ٙ?33?ff@   ?ٙ?33?ٙ?  ?@   @   ?  ?33?@   @   @   @ff?ٙ@ff@   ?ff??ٙ?ٙ@   @ff@ff@ff@@33@@33@fff@@33@@,@L@&ff@   @&ff@l@l@@,@33@   @L@ff@y@S33@9@   @@@@33@@@@&ff@   @@@ff@ff@ff@ff@@   @   @@33@@  @33@33?33?33?33@,@33@ff?ff?33?33@@   @   @?33?33@ff@   ?ff@?33@   @ff@ff@   ?ff@ff?33?33@Fff@ff@ff@ff@ff@ff@ff@ff?33@ff?ٙ?ff@ff@   @ff@ff@@ff@ff@@@33@@@ff@ff@33@ff@ff@ff@ff@ff@@33@33@@@@33@@@ff@@@@ff@ff@@@@33@@ff@@33@33@@33@33@@   @   @&ff@@&ff@33@   @   @@@ff@33@@&ff@@33@333@&ff@33@33@33@&ff@@@@,@333@   @@33@   @@&ff@@@,@&ff@,@&ff@@  @,@&ff@,@333@   @Fff@@  @   @9@L@Fff@333@&ff@Fff@333@333@Fff@Fff@333@,@S33@S33@Fff@Fff@L@L@@  @@  @fff@Y@L@`  @s33@fff@33@`  @S33@`  @fff@S33@Y@L@S33@@  @S33@`  @S33@Y@S33@fff@l@l@S33@fff@y@s33@y@Y@s33@S33@  @fff@33@s33@33@  @@33@  @@  @  @ff@l@  @  @ff@ff@ff@ff@  @33@@ff@  @ff@33@ff@33@S33@  @  @ٙ@@33@@ff@AffA33@Aff@33A9@ff@ٙ@@ff@ff@ff@  A33@  @33@@l@y@l@`  @`  @`  @fff@s33@y@s33@fff@s33@s33@33@s33@ff@33@33@ff@@ff@ff@ff@  @@@@   @333@   @   @&ff@333@&ff@Y@,@9@   @@@ff@ff@33@@@33@33@@@@?ff@33@@?33@33@   @   @@ff@33@33@ff@ff@33@   @33@?33@@@   @@@@@33@33@ff@@   @33@ff@ff@@ff@33@33@   @&ff@@@ff@@@@ff@@@@33@   @@  @,@9@&ff@&ff@@&ff@@  @&ff@&ff@&ff@@@   @&ff@   @   @@&ff@   @,@,@,@&ff@,@&ff@333@@  @,@333@333@@33@   @&ff@ff@@L@33@   @@,@@9@@,@L@&ff@@   @&ff@&ff@,@   @@  @9@Fff@,@33@   @@ff@ff@   @@ff@@@,@L@Fff@S33@9@@  @,@,@   @@   @@33@ff@   @   @ff@@@33@@@@@@33@@@33@@@@@@@33@33@ff@@@@33@33@33@@@33@@@33@@@33@   @333@Fff@L@y@@   @33@?33?33?ff@ff?33?ff@ff?33@@ff@ff@33@33?@ff@@@@ff@@33@@@33@   @   @@@@   @33@@@@@   @33@@33@@33@@33@   @33@@33@@33@   @@   @33@   @333@333@,@,@,@,@&ff@   @333@&ff@&ff@   @&ff@   @   @   @&ff@   @333@&ff@&ff@,@333@@&ff@   @@   @@@@@33@ff@ff@ff@   @   @   ?33?ff@@@   @33@@陚@33@33@   @@  @9@&ff@   @&ff@&ff@333@&ff@,@   @@ffC3@33@  @@@ff@@@@,@333@@ff@ff@ff@   @33@33@33@33@,@@33@33@@33@ff@@ff@ff@@@@@@@33@33@@@@@33@@@@@33@@@33@@   @@@@@&ff@33@@@@   ?33@   @   @   @   ?ff@ff@33@@   ?ff?ff@@   @@   @33@ff?33@   @   @ff@   @   @   @   @ff@33@ff?ff@   @   @ff@ff@ff@ff@ff@   @   @@@   @ff@ff@@   @33@ff@@ff@ff@ff@@ff@@   @33@@@33@?33@ff@   @ff@ff@ff@ff@ff@   @@ff@ff@33@33@33@@33@@ff@ff@33@@ff@   @   @   @ff@ff?ff@   @ff@   ?ٙ?33@   ?33?33?@   ?ff?ff?33?ٙ?ٙ?ff?  ?ff?ٙ??ff?ff?ٙ?33?33@   @   @   @   ?ٙ?ff@   @ff@   @@@   @   @ff@   @   @   ?33?33?ff@   @   ?33@ff@   ?33@   @   @@   @ff@ff@ff@   ?33@   ?33@ff@   @   ?33@ff@   @ff@   @   @   @   @ff@   @ff@@ff@@33@   @ff@ff@@?33@   @   ?ff@   @   ?33@   @ff?ff?33?ff@   @?33@ff@   @@ff@ff@   ?ff@   @ff@ff?33?ٙ?33@ff@ff@ff?33?33?33@ff@ff?33@   AA<A33AffA@  AA33A  A333@ffAffA;33AA>ffAffA33AP  AIA  A  AqA^ff@  A8  A0  A  AA0  A	A   @33ALA@33A   AlAvffA8  AA   @ff@ffAff@33A+33AvffAyAaA33AffAAP  @A)AVffA!AYAA	A  A1AANffA333AA33AaAAs33AlAA  A  @A0  A  A  AQA  @AffA8  A&ffAAYA4AAffA33AffA33AFffA>ff@33AYA!A{33AYA+33AP  @陚@AAffAD@ff@33A33A  @AK33A33A@33@33AAA  A@ffA  A33A+33AffAffAffA   AA	A   A^ffAAffAff@  A@ATA4AA33AffAIA33A!A&ffA@  AlA  A(  B   A$AA  AffATAAiA>ffAff@陚Ax  @ffA33A<ATA^ffAAB
  AљA33A&ffA  ADA,@33A  Ap  AA   @AAA@ٙAAA33Aff@əA  B   Ak33AlA\A33A[33AAffA\A   AAAAX  AAAA^ffAAffAqA@33A33A+33A>ffAp  BRA!AyA33AffA>ffA@  A\BAffAAA33A  A6ffA33AFffAffAffAFffAvff@33A33AlAffA{33AANffAAAdAA4@  B
AnffAc33A	@33AA  BU33A9BAvffAVffAQA  A  A[33A33Ap  @@ٙAK33A33A33A!A~ffAYA홚AA  Ac33Aff@ffAC33A33ALAtA#33AAffAA33BAA.ffAAA{33@33A`  A	A   A33AffA33A@AffA  AADA33AffAA33AAS33AAAC33A[33A0  Ap  A  @əAA33A`  A@ffA  AQAffA  AAA  AřAff@B  A33A  AffAyAAtDfAffBAٙAA33AAQBQAffAAAffBffA33BA  A33B33B=A33BB:ABB  B
AA33A  AAATA33AffAA+33A33AB,  AffA  A  A  A33AAFffAљAYB  AA  A6ffAAAffAAAffA333AٙBAffA  AA{33A33BAA陚BAffB)B8  B  BVffBBBzBB ffBAA33B+A  BA33B?B2  A33BBAffAAA  AffB33AAfffBffA  B3AyABC33AՙABAAADA4AffA(  BAffA@  AvffAaA333A͙AX  ATA,A33A  A!AffA33AS33AəAAAqAffAAffA0  AiADA噚AffALAffDA  A  Aff@ffA33AAAk33Ah  A@陚AnffA  AAffA1AffA  AA[33A  AffA  AvffA0  A  A33Ax  @ٙA  A>ffBB33AffAA  AvffAA	ADAdADAC33A<AFff@ffAAAs33A홚A33AaA  AfffAffA͙B'BffA  A+33AffA  Ac33A  A333A͙A,A33AffA1@ffAX  A6ffA  @ٙA9A  AdANffADA<AX  @ffA	A9AffAAp  A33@ffA6ffAx  AqAAffAAffA  AffBffAffA33AA33A噚A`  AAffAffAA  A  @AffA@  A)Ai@A0  Ak33A$A  A33AAAH  A#33Ai@ffA+33B33AffAff@ffAA33A33Ac33@33AA!AffA9@33A33AA333A33A33A|AAA333AiAiAAqAffAH  As33@33A1D3A0  AA(  A33AAAffBff@A  Ak33A  A@AAAA33A;33A33AAA@33A0  A~ffA~ffA33A#33AffA   A8  B#A   AffAAA#33AAffA6ffADA33A^ffAA33AAffB33AA4A&ff@  AfffAA	A@  @@A33AAAAaAP  AffA)A@陚@AaA   A0  Aff@A  A  A33A!AAlA33A+33@33AK33AA$A33AAfffAff@ffA(  AffA;33A$AffA33AYAs33AyA8  A+33AA  AK33AffAYAS33A  A`  A>ffA33A33A\ATAff@33AlA   Aᙚ@33@A\A33AK33AIA>ffAs33A#33A<AffAAC33A,AAA  A$AAffA@  A6ffANff@ffAffB"ffA4A6ff@əA33AAA33AAP  @@ffA  A33A  A  AffA  AAvffAK33AiAX  AAA8  AAc33A[33A6ffAYAvffA33AffA   AANffA9A+33@A8  A33@33AffAD@A6ffA33AnffAdA@AQA1ANffAH  AA333AaAfffAAAffA+33AAYAQA{33AA`  ADA  AffAC33AC33A33AQA|A\A  AH  AlA33A33A33AP  A)A   AB
  A@A9AAA   A@  A33A;33AffA333AS33A33AAnffA33A(  A͙AffA  AffAAAfffAAc33Ac33AA.ffA33A  AQA  AlAAlAAqAdAQAffAAx  AfffA,AffA>ffAAAiAəAA  AՙAC33A33A1A  A[33AAffAA33A  A  A33A  A33AADfAAffA  A33AffB
  A  A33AffA33AAᙚA33ABffA33A陚BB&ffBffBEBB$  BffB  BffBB33BffB%B BA33B  B
B2BA홚B	BAAx  A.ffAA  @ffA33ALAP  A0  AAffA0  A  AAVffA  A@  A33A  A  AIAA+33A  A!@ٙAA#33AtAffA  A33A  @33A6ffA333AAA333A#33AffA  AAlAffAAnffAQA  A  @陚A  AdA`  A@33AaA33AB ffA  As33A   A  AAk33AAAffAAA  AAlA33A#33ALAA  AtA^ffA0  AffAAffAAA33A  A33A  AAAA6ffA{33AVffA.ffAٙA33AAAAqA~ffAAA33A|As33AfffA  AffAAA33A33AX  A  A|AiA33A33Ax  AffAs33A  AffAffAffAqA^ffA{33AA  B  ANffA33BffA{33A  AAtA͙AffAA~ffA33A  AffA33AA  A  A33AٙAAffAAAAAAffA  A33AAffA33AAffAAAA33AffAAA陚A33AffB6AAB ffAA33AAљAtA33A  AffAAAA33AffAAA33A33AAA  B AA33A33A  A33A33AAA  AffA噚AAAA33AA~ffAffAA33AAAffA  A  AB  AffA33A33A  AB0AA  AAAAřAffB*  AffB533BAffA  AB$  AffAA33B33BBABAAffA33AA  A  A33A  B33B  BBffA33BffA  AffBffAAAA  AəAAAA홚A33AA33A  AffA33A  B  A33A33BA33AffA  AA  AAљBAřAffAAřA33AffA  AAAAAՙA33AffBffAA  A33AAAAffBffAffAA  AffAAAffAffB,  B-A  A33B<ffAffBO33B   B!33A33A33AřB
33A  A͙AљB  AAA33AAՙA  BffAAAAB
AffA  BffA33AffAffAffA  AAA33AA  A  AffB  AAA  B-33AB333BffBAffABffBA  B
AA  B2A33AAљA  B33A  AA33AA  AAffBAAB@  BffB,ffBV  BffB8  BwB.ffAB B  B533Bu33BxB2B}B>  B2B  @,@Fff@9@,@Fff@333@,@333@&ff@s33@,@   A홚@,@&ff@@L@,@   @,@,A33@33@@@@@33@ff@@@33@@@33@@33@33@33@33@33@333@@@@33@@   @   @&ff@   @333@&ff@   @   @9@,@   @,@9@`  @,@@  @,@   @,@,@&ff@&ff@333@,@ff@ff@Fff@,@  Aff@   @L@@@ff@33@@ff@33@@@33@@@,@ff@@ff@@@@@   @333@33@@ff@ff@@33@ff@ff@33@@33@@33@@@@@33@@@@33@   @@,@@33@33@33@&ff@&ff@   @@33@@&ff@,@&ff@,@33@   @,@&ff@   @&ff@,@@33@&ff@   @&ff@@   @y@@&ffAX  @&ff@   @@333@@33@&ff@333@@   @@@   @@ff@ff@33@@@@33@33@33@33@33@@@&ff@`  @@&ff@Bff@@@@@@33@C@@33@33@@ff@33@ff@33AP  AAffAA33A@  A<AH  ALATAd@@ff@@ff@ff@@  @@33@  @ٙAAAS33A  A  B@&ff@33@333@333@333@S33@333@9@@  @y@S33@`  @fff@l@Y@S33@Y@fff@`  @S33@S33@L@@  @@  @@  @@333@,@333@&ff@,@&ff@@,@,@&ff@,@&ff@S33@,@,@,@   @,@   @333@33@   @@@@333@   @333@   @   @&ff@   @   @   @,@,@&ff@&ff@&ff@,@,@,@,@&ff@333@,@,@333@333@,@,@@333@,@9@333@9@333@9@9@`  A   A33Ah  AffBe@  @Fff@L@S33@S33@Y@  @L@S33@L@Y@L@Fff@@  @Fff@S33@  @@  @@  DCy@Fff@S33@S33@L@  @l@33@33@@@@l@s33@s33@33@33@@@@  @@ff@@  @  @ff@@33@ff@ff@33@33@@@  @@@@ff@33AffAff@ə@  @@  @@陚@陚@ff@A   A33A  A33AffA33A	@  AA  AffAffA$AA4A6ffAK33ALAH  ALAVffA`  A\AqAp  AAAA  AffAAffA33AAffA33AAffABB ffB ffB  A33AffB33A33A  A33AA33B   AՙBffB33B  B  B33B  BffBBBB33B33BB  BffB&B*  B.ffB+B%B/33BffB<BB  B333B(  BHffBV  BM33BW33BVBW33BbffB`ffBa33BkBi33BnffBq33BlBlBj  BtBlffBr  BvffBy33B|  BBB33BffBffB  BBBB33B33BBffBffB33BffB33B  B33B33C CLCC3C+C>fC8C3C;33C0  C=ffC1fC=C(C13C5C:C:3C?C(ffC3CCC C3C33CBB33BBBffB  B33BBB33B33B  Bu33BBB  BBB33B  BffBB  BBffB33BB  BBBBBffB33B33B  BB33B  BBB  BBffBB33BffBBB33B33B33BBЙBB  BBffB䙚BBC!fB33B33BBB33C$LBB왚BB  B  BffB  B  BB  BffB  BBBBffBBBBBB  BffB  B  BffBB  BBBffB33BffB왚BB33B33C   B  BB  BB33BB33C33BBffC33C CffCffC C  C C C
C	C33CC33C3CffCC33C3C CLC C
  C
 C  CLC
CC3C
3CCCCfCCfC CC  CLC  CC C CfC CLC CCLC3C  C)fC' C!C3 C+C.fC  CLC3C"  C  C CLCC  CC3C C  C3CC C  C33CffCLCffC C
CCC CC  C3C
fCCC C3C	 C
CfCLCC33CfCffC C33C  CffC CC33CfCffCCLCLC LC LC#LC#C"C$LC.3C(33C*ffC(LC+33C)BC.C0  C<fC@3CCC9C933C2fC/C;C<fC8ffCE3C7C9 C=  C=C>CAC<  C@C@ C@LCC3C9ffC833CDffC633C:  C5ffC;C,fC(C)C)CC+33C C'LC'C(3C)C/C*fC+  C(3C!LC-  C/LC.  C2C5 C033C.fC.  CC2LC53C.3C0C0C)C-3C.33C333C, C0ffC? C4C4LC6  C3  C; C5  C: C8LC8C8LC6fC9  C6LC4C5C@33C?CBCBC@ffCE3CGCHLC; CG C=3CRLCN B33CQCI33CTfCRLCN  CGCQC`CU3CTCSLCS C^C\fC] CX Ca33C_ffC\  CZ C[C]LCpC{fCsCSCOCX33CZLCPfCQ33CF  CCCI  CZ3CRLCP CK3CL C`LCOLCO  CO33CO  C`3CP CQCSffCPCNffCRffC?3CIBCL33CN  CTffCS33CR33COfCVCP3CPC`3CWfCV BffCZ CZfC\3CTCV3C[CA3C+CA3CCffC;CD33CF3CF CRffCNffCO33CF  CTCLCHfCPffCMCE33CJ33CHCKCJ33CI CPCFCO CNffCQLCPCQ  CRffCO  CR3CMfCQffCSfCR CS  CTCE33CZ3CNCMfCRffCS  CRfCQ33CPLCNLCOCI CH3CI3CNC3fCO  CO COCS3C:3CRLCRLCHffCQ3CP CQLCMfCQ33CSCT3B33CT33CWCW33CVCRCWffCR CVLCRfCT3COffCTCVCVCYffCLCS  CXCY  CWLCTCYCXfC[CZLCW3CZfC\ C]  C[LCZCZLC`fC^3CYCZ  C` C] BCZffC_CdCa  CaC\  C`C`ffC]  CXCaffCc  C`ffC^ C[C[LC_ C`  C_Cr  CiCdfCWCKfCRLCXffCVCQffCSCQ CTfCRLCTfCRCWCU3CY3COCRCUfB33CU3CV33CV CVCZLCWC\LCT C\3CZffCZffC3C]LCaCY CV C]  C_C]3CdfC^ Ca33CXCZ33C  Ca33C<LCbCf  CdffCefCcCb  Ce  ChffCbCaCd  CgffCi  CeffCe C)Ci  CeLCgLCgLCf  CgffCf3CdLCiffCl ClCq33CnCrCrfB  CrCpCq33ClCm33Cl  ClfCjCuffCjfCiLClCf B33Cf CjCifCtCh  CiLCa C^33CjCiLClLCg3CgLCdLCeLC}CCh  Cf3C[  CYCfffCgCk  CefCpffCm3B  C_  Cl  CmffCrLCn CpCnCpCqLB33Ct33Cq3Ct33CeCkfCmCn Cl3ChCfCg CffCjfCj  CkCh3C
LCl Cj3Cm CmLCpfCo  C\fCmCqffCr3Cn  Co3CrffCpCtLC/  CqLCoCtffCm  Ck C0fCtCpfCpfCrfCvffCtCrCGCtCv  Cy  CxCyC}ffCwffC0  CuCvffCzLCzCyCrLC{ CuC{3CJLCt33CqCfLCmffCr CdffCnCo CnCLCj CmCk3Cj CdC`fC^fChLC^fCOfCl Ci  CmCj3CdfC\fC_3C$CWC^CdffCkfCnfClCjfCi33ChCCCffCJLCSCWffC03C!3CH  CGfCPffC`C_fC(ffCifC^fCjLCn3C[CC_Cd33CqffCg  Cn  Cg CgfCi33CkLCe C|  CnC3CtCb3CjLCj3ChffCm33Cg33Cl Cq33Cr3Cg  CuLCn3CmfCn33C}3Cv33CuCyCm33CXC"BffC:33CSC\CDCOCTCOCQCC53C=  CT33CZfCCECV3C[3CA3C=3CPC7CffC;  CELCDCE3CHffCNLCS3CK3CO33CM CX  CLCTC?33C\CHfCQLCPLCJ  CV  CV C4Cf3Cb33Ct3Cl3CqCf33CoLCq C_CiCwffCp Co CpCp  CKCmLCkCwCx  Cy CmLCICv CyLC|CuCvLCq  CtfCx  CPCx33CsCyfCzC}LCrC73CvffCv CcCf  CjCe3CmCu33C~fCLCzC~  Cx CsLCw C}ffC~CtCvCC_LCq  Cp  CsLCk  C33CsC Cp3Ct  CzC  CC&fCsffC Cu  CC C&fCTCq3CyCr  Cz CufC33C3C  CxLCxffCCffC  CffCC3CfCfCCQfCC  CCCCifCs3CCLCC3C3Cs3CfCC CC  CCfCLC3CfCffC C3CCfCffCfCCCC33CDLCq  C3C@LCeLCwCc  CrLCrffCpffCr3Cp3CٚCsffCsffC3CfCC  CCYCLC CCC CfCs Cs3Cs3CffC3CfC3CmffCٚCw3C3CC]CYCfCfCfCfC3C~  C33CCfCC33C3C33C  CCYC33CLC&fC&fC@ffCf CffC~33CqCwCrLC~LC&fC CٚCwLC C&fC&fCC33CfC  C3CCC33Cs3C{ffCC3C  C C C  CffC3C C3CCfCfCٚCL C C&fCfCLCCfCCٚCffCCCYC3C3Cs3C  CfC&fC33C CYC&fC33C@ C33CC CYC3CٚC~C}CffCs3C3CCffC&fCzffCfC  C@ C@ C C CfC CffCYCs3C3Cm  Cm33CLCLCfC3C&fCffCfC3CfCfCffCLC3C}  Cr33CٚCCp33CzfCC33C3C3CYC`33C]CbC`fCZ Ca  CUfCoLCtCkffC=C0C4fC=C63C?CAC<33C< CGffCCCILCK3CF33CE33CAC>fC<fC8ffCA3C@33C>CB CFCECG  CMCF  CICD  CGfCG  C@3CE  CI3C@CCfC=3C?  C=33CH33CK3CGC>  CGC= CF  C?C7CD CAC>3C@CECNC13C3CC  CF3CICA3CDfCK C>  CS3CP  CQCWCZffC^LCXfCPCM  CTCI33CGffCRCZLC_3CZfCQ CE CKffCDffC@3C9 C=CDffCAC?33C@33CE33CF3CCfC@ C;ffC@LCJLCB CFLCGC;CBLC3  CGC?  CAffC> CE3C6C1LC;C;ffC;  C:C;ffCD33CA3C?C?CE CBffC;LC@LC< C:ffC5 C=ffC9C,C7C.ffC4LC8ffCMLC-C6ffC; C^ffCFC?ffCfCP C\ CdffCs3C{CZ CMLCFLCQfCUCS33CDfCzfC=fCGLC&CELC<3CS  C3 C7C9  CD33CI33CNCB  CBCI  CK33CB  CLffCG3CJCPfC;fC] CH3CGffCLfCHffCMLCGCQ3CVCMfCP COffCLfCQ CPffCS33CGCQ  CPffCI CBLCKC;ffCJ33CY CNLCTCVffCNCQLCS  CZffCVCM CM  CT3CFfCMfCWCeffCY C@ Cv33CCCyLChfC} CCfCYC|LC  CCYC&fC@ C3CyC33CYCC33CwLCfC  CLC@ CYCٚC@ CCfCfC33C3CC CC B33CCC  CfC3C3Cs3CٚCfCfC C3CffCCCC CCfCC@ CC@ C  CYCy  CCCrfCCٚCLCz3C3CfC CCs3C}33C}  C  C|fCffCfC@ CٚCz  C|CzffCwC{ffCzCC&fCffCfCv33Cs3CC|Cs3C CCCzCC33CffC C&fCٚC33CYC&fC3C  CfC  CYC C C&fCCCYCpC  C33CYCٚC33CC33C CC3CC@ C3CCffCq C@ CwC  C3C33Ch3CvC3Cv  CrCtffCjC|LC3Cs3CrfCo33CiffCsCy33C#ffC[33CbfCh33Cm33ClCcCYCzLC3C|CuCsCqC@ CwfCy  CC33CfCC@ CCfCffCCfCfCfCCCLCfCC3CLCLC3CfCC3CYCYC~3CfC@ CzCpLCs3C|LC C33C&fC33CCC3CffC C@ C3C  CzLCyC{  C{CffCC&fCzffC@ CfCs3CC3CYCYC3CC3C@ Cj3CYCkLCjC}CzffCk C Cm  CzCYCoCCrfCtCzfC{LC&fCx Cs3CwLCtfCzLCzLCt Cn  CzLCr33Co  CpClLCkLCt Cp33CoCcffCfffCi Ci  CcCeCdC]Ca3Cd  C`Ca CKffCTCpCv CC&fCbCcLCs CfLCl3Cu33CbCfCefCpCkffC_Ce3CC[CY C33C3CdCn33CT  ClffC\ffC]ffCZ33COCQffCHLCP3CPLC\ COCHfCSLCfCMffCX3CPCO3CDLCX  CRCUCRffCb  C_3CNCGCBLCLffCM  CTCICJ3CLffC6CQ CPffCL  CS33CULCjLCNCSLCM33CLLCLC?CWLCNffCN3CRffCLCU  CI  CL  CIffC^CE33CHCD CBLCC33CGLCK3CILC` Cv33CefCQ CW C[ CJffCZfCHfCzCFC[ ChLCQffCٚC^3C33CJ3Cn  CyCN3CULCSLCf33CBCdfCn CAffCfCr C&fCUfCP C[CQ  CjfCYC  Cg  CU3C}Cq33CeffCV33C[  C\C_  C[CYLCV33Cf33C]3C^fCZLCmCaCZ  C`33C\fCWffC\C[  CY CdfCWfCW CcfC`33Cg33CHLCULCS CQLCOCMffCWfCfLCeCV3CKCKLCK COLCE33CX CM3C_CnLC]  CufCULCYfCI3CPC[CIffCK33CMCPCLCX CVLCN33CS33ChffCTCpCOfC`33CjC^CS  CU3CU  CTfCUCZffC`33C  Cj33CMCT33CTCaLCXCO  Cj  COLC_33CdCxCYCZC^CvC_33CZLCrC\33CM3CXffCffCTCXLCi  Ct ChffCqfC\ffCZ33Cy3Cd33C|ffCuffCmfC]33CY  CUffCY CW CW CXLCeLC` CeCm CS CcLCXCcfCr3Cs3CqLCY  Cg  C~3C}33Ci Cr C@ CX3C^LCY3C\LCe33CQ CyC^3C|fCaCo3C_  CC33CqffCnC3CcfCeC}33Cn  Cg C|Cf C|LCXLCeC_C@ C  C|fCkffCJ3CICWffCHCSffCi CMC5 CICHLCV33CٚCoLCUCP3CX3CULCI CNCT  CSCPffCOClLCb3C_  CQfCuC{3C]3CX  CsLCm33ChCk Ca3Ck  CbCzC]33C`33Cj33CgCofCeLCf33ChffCrCCd  CeCd C{ CfLCj3CuCf33CiCaCb33CgC` C\ffCl CnLCdffCCy  Cc3Cr33Cg  Cz3C3CsCs3CLCr3CzfCCLCLCv C  CzffCs3CCrfCkfC33CfCeCٚCٚC  CYCz  Cr3Cx  C{  C3C CwLC&fCCCCs3CfC&fCCfCffC3CCfCٚCCC C3C  CzC|ffCC CC C CffC&fC3C33C CYCCffCffCLCffC C  CffCLCCٚC3CfCC&fC33C  CCCfC3CLC C CٚCLC CLCs3C@ C@ C&fC CffC&fC CCٚCfCٚC3CCffC CLC3CLC CYC@ C[CC}ffCC73ClffC C  CCYCC  CCfCC C33CYCffCfC&fCCfCffCCC@ CC3CCLCCfCCCYC Cn C CvCfCfCYChLCCC&fC@ C C3CfC3CCCfCC&fC CYCyC} C@ CzCffCfCoffC[3Cq  C_CUfCC{3CٚC{33CnC`LC{CsCC~fC{fCzLC&fCxC C~LCfC CYCvCn  CC3CCyC@ C@ CC3C CfC3CwC CnLCffC~CLC@ C|C CLC3C33C{ffCYC3CC CLC CC3CCCCffCCCٚCk  CfCCC C C C C3C&fCCffCCCCffC3CfCfCMfCCCYCC C  CxfCk  C3CٚCs3CCfCo33Cn3C{fCF3CYCC33C&fCffCCr C3C C C  CC  CLCqffC3CCjCgCyfC33CzLCp33CN Ck C{ffC  C3CC Ch3CZCE33CCٚCt33CX3Cx33C|CCCW  CfCfCdLCX33CcCYCw Cs3C|CffCs3CT33CULCXCLC  CffCN CUffCZ  CW33CWffCh33CffC3CC CCf  ChfCfCaLCٚC^LC CٚC`C}33C^3CYLCe  C_  C]  Cd3C\ C&fCp  C\  ChffC33Cs3CCyC3C3C[LC&fCeC_ Cm33C\fCgLCC Cs3Cd33CChfC33CCs3C^33CfC3CdffC_LCm33C@ Ck3Cj CaCYCeCoffC~3CCC}33C C_CvCC3CCh33CzLC_CiCdfCa3C|ffC@ CCfCLC33CjCs3C3C CCvLC&fCfC CffCC@ C{Cl CLCLCfCzffCm3CdC@ CtfC&fCkC C~CmCYCtffC3C}3C  Cv3Cx  CfCYC&fC3CC CffC CC C&fC33C{Cs3C@ C  CwC@ C CsCCzffCx  Cy  C|fCC@ C&fC C33CuCjC}fCCCvLCs3C33C  C C33CffC{ffC3C&fCfC|3Cs3C CfC&fCs3C  CLCC33CffC3C3CٚCٚCYCs3C@ CYCYC&fCfC CCٚC C3CfC@ CCs3C CLCs3C  C&fCfC3CCYC  CC3CC CCffC&fCC&fC@ C@ C33CffCCLC@ CC C&fCCfC  CCLCfC CCC  C C&fC  CCCCCC C3CCC3C  C@ Cs3CCs3C33C3C3CCCLCC  C CٚCYC3CC C3CYCCs3C&fCfC&fC  C CLCLC@ CC3C&fCYCLCffC C3CC  CC33C3Cs3CfCw33Cr3C@ C CfCs3CLC&fC33CC|CCfCLC33CC|CLC{fC CCCLC CCYC&fCs3CC CfC&fCffC33C C CC3CCC  C C3C CfCfCٚCC@ CfC&fC C3CCCfCCYCs3CffCCCC3C C3CCfC  CٚCYCٚCfCYC CLCYC3C@ CfCLCLCffCfCs3CfC&fCYCC33CC3C Cs3C CLCfCC&fCCffCCfCffC3CffC3CC3CCCCYC&fC33CC&fC CٚCCs3C@ C CCٚCCCٚCffC@ CLCffCC3C CYC@ CYCfCYC  CٚC  CٚC&fCٚCfC CYC3C3Cs3CfCLCLCٚCCCCfC3C@ CfCC33CfCfC CffCYC@ CffCCffCfC&fCLC&fCLC3C C@ CCٚCfC33C  C3CC33CC3C3CC3CLC3C C@ CC3C3CCCCC C3CCC33C&fC CCYCCfCCٚC3CC33CffC&fC C CC C3CCYCCCCffCfC&fCs3C&fC3CfCC33CfCCC33C&fCs3CC@ CٚC&fCCs3CYCffCfCYC&fCٚCC3C3CCLC CYCfC&fCffC33C&fC3CYC CffC&fC C  C@ CfC C3C C@ C33C33CCC  C CfC3C33CffC3CffCffC33C CٚCfCCfC&fC3CLC33C C3C CٚC@ CfCfCYC33CfCC  C  CٚCs3C33C CLC@ C3C@ CCs3CYCffC CYC3CffC3CfCC&fCCfC Cs3CCfC~CC}3C~C|Cy  CwCx3Cq3CpfCnffCh  Ck3Cd Cg  Cb3CkCgCh Ce33ChfCcCk33CeCgfCd33CgfCf3CfffCcCj CcfC`C\33CbffC_C]33C`C_ C_fC^33C`ffCa C_Ca3C_33C_LCdffCd  Ca  CgCe CiCbCb33CafCgCiC_CkffCiCdLCjCg33CkffClCr33CsCpCofCtCyLCu3Cu33Cw CqffCnCeC]33C`C\LCbCe  CaC`33Cd  Ce33Cf Ch  CcfCiCfCcLCbCc33Cd  CfC`ffCYfCd3CdCe  Cb CcLCbfCe CcfCg  CeffCYCeffCeffCcffCfLCjffCgfCnffClffCiCh33CgffChLCd  Ch33CmffCpfCiffCo  Cp3Ct  CqClCkCuCjfCwCv3CyLCzCwC{CyC|Ct33Cn33C{CvClC}fCxCzLCz33Cx3C~C~C~C Cw33CCtffCk  Cm  CsLCt CxCv33Cs Cy3Cz  CwfCzffCw3Cv CyfCoCq  CyfCpfCnCp  CuffCu Ck3Cm  CpCqfCq Cx  CtLCy33Cs  C|Cq  CrCs Cx CrCs Co33Cw  Cr3Cv33CrCmCoffCt3Cs Co33ClCnCiCkffCrfCqfCk33Cv33CpffCtCpfCjCrCrCj Cm  CpLCo  CpffCkCkClClCk33CgCp CW  CwfCpffCxfCvCy3CyC{Cz  C{  CufCv  CtLCofCxCCs3C&fC3CmffC33C~CffCfC CC  CCfCLC|C@ C CfCvC&fCfCLCC3CfC C33CCCuCuCy33CyLCv CtfC|C{C{LCy Cz33C}C} CfCCCLCC  C33C  C~CffC@ C3CfCYC Cq3C&fCs3CCLC33CLCC@ C3C3C| C CffC~ffC C~33CCs3CLCfC C&fCCffC3C C33CCs3C@ C CfCCC3C33C  Cv CffC@ CLCCٚCٚC C3CfC33CLCCYCٚCٚC3C CYC&fC  CCx C~33C{CuffCYCzfC~ffChC CfCp CfC|LCs33CuffCyC C3C  CCfC~Cs3CCYC~C|33CffC33CffC@ CYCfCLCٚC3C}ffCYC  C3CCCYC  CfCffCLCu3C|LCCCCC33CC3CfCCCs3C3C C3CffC@ CfCLC@ CCCfCYC}LCC&fCٚC3Cs3CfCs3CCfC3CCCC33CC&fC3C CfC CffCCjCs3C3C33C  Cs3CLC3CCCCfCCrffC|  C C33CC CffCLCuLC3CYC  C&fCٚC&fC@ C  C@ CC C3CCs3C C CC@ C@ CfCC33C  C3C&fC33C  C33CٚC@ C{  C CfCCCffCYC~fCٚCffCC@ C  C3C3C  C}CٚC3CٚCffCfC Cw3CC3Cs3CC C  C3CfCYC C  C C&fCffCffCs3Cs3C  CffCC  C CC CC&fCC CffC CLC&fC&fC C CC CCٚC&fC3Cs3C CCC C C@ CLCCs3C C~CCC C3Cs3CCLCfCLCٚC  C3C&fCCCYCCLCC C CC@ CC33CLC C  CCCC3Cs3CCٚCLCffCffCfCC  CfCC  C CffCCC Cs3C  CLCs3C C3C CCC@ Cs3CffCYC3C33C33C@ CffCYC  CٚC3CCfC33C3CYC C33Cs3CfCYC3C3CCfCLCC3CCfCs3CCYCs3C&fC CLCCYC&fCCfC@ C33C@ CfCfC  CCCCYC@ C&fCffCYCٚC3C@ CLCCfC&fCCfCfCLCffC CYCLCYC CfCٚC Cs3CLCfCfC  CC  CC3CC CLCffCffCCfCC3C&fCffCfC33C C  CYC CfC  CCLCC3C@ C@ C&fC&fC33C  CfCC3CffCC@ CC33C3CCfCLC  C C&fC Cs3C33CfCC&fCCCffCٚC3Cs3CٚCLC CLC3CC@ CfCfCٚCffC C3CYC  Cs3C C@ CfCfC&fCٚCCٚCYCfCCs3CffCYCffCCC3C@ CfCffCYCfCCffCs3CCCs3CC  CCLCfCCfC CffCC@ C CLCCffC@ CYCCfC3CC&fC3C&fC3CfCC33CC33CYCCCC33CYC3C&fCffC3C C Cs3C CfCC3C&fC3C Cs3CffC3CfC|C C} CxCffCx C|Cv33CzfC{fC| Cu3CwLCnLCz CpCk33CgLCk  Cf3CjCj CjCi33C] Ce33CgCcCYfC\Ce CYLCf  Cf CafC^33C]LCZ  CaC]fCc CbCdCQC]  C\ffC_C` CYfCXLC^CYCX  C] C_ffC^3C_  C[C]CZLCX3CRCW33C\ C^ C^3CYCY33CYfCTCQCH3CSffCYfCZC`LCWfC\C_fCYffC`  C`3Cd CdC_CTLCTCW  CW3CZ33CZ33CZ33C^33C[ C[fC[33C^33C[ffC^  C] Cb33C\fC[33CX33C]C`33C^CWCXfC\33CQffC[33CO33CVffCU33CSC[LCYfCXCRCYffCWffCXffCV C[LCTCV  C]ffCY3CU33CKCHCWffCWffCB3CKCC  C=ffCE33C3C@LC; C.LC7fC8C;LC73C63C2fC233C433C/ffC4fC3C133C833C5ffC2C3fC5  C8C6C:  C2C;LC6LC4C5C9  C6ffC8ffC7LC3  C7 C/  C3fC3C4fC6  C9C:C:33C. C133C9C%C33C#CC9C7LC9fC6LC<LC5fC7C:C: C>3C<fC7 C: C5LC9C933C>3C<  C:ffC>  C>ffC;fC>CAC>fC?C3C6ffC1C/C1C:  C5ffC8C<C;3C=ffC=3C;LC8C033C(3C;ffC9C;ffC;fC-33C=3CB  C<LC>  C;C<ffC: C7C5ffC23C;fC;C;  C=3C<fC/fC/fC13C.3C8C4fC6C3 C9fC6  C:ffC:C8C:LC=ffC:  C>fC8fC=C4C@LC>C<C;LC:C<ffC=ffC6ffC;LC<LC<33C8C<C; C@ C< C=33C9 C0C8  C=C9fC:C/3C1 CA  C4C;  C?fC53C1  C6C=ffC;33CE  CC3CFffCC CJCHfCJ CEC?CG  CECG33CILCHCKCNffCJLCQ3CQ CT  CRCQLCRLCL3CQLCQffCRLCQ CQffCOLCRCPCQLCQ CPfCKfCM  CIfCMCNffCI33CLLC=CDLCDCIC?3CJ3CFfCI3CGC=CE33CECC  CJCH33CLLCJfCILCQ CC3CNLCP3CM  CJfCPCPffCMCICLCB33CFCACC CB CFffCH33CECAfCAfCG CEC;3C4  CD CK3CHffCC33CF CHffCIfCKLCI3CF CJLCICHffCJCGCHCKLCHCK  CI33CJCELCICI CG3CGLCGCGLCH3CICJCE33CF CFffCK  CJC@ CHCJCH CHLCH3CICG33CGffCGCGCGffCICGCH33C4CEffCF33CECECEffCF  CE  CD  CGCC C@CC  C@CBC?3CB3C?C?LC?  C?CDC@ CDfC=3CCC@fCDCA  C?CC3CELC=3C>33C<33C;3C=33C?  C:3C8ffC>33CAC@33C@  C2C333CA33C?CA CBC6fC9 CAffC;  C; C=3C8C?  CA3C<  C:fCB  CC  CACA3CC CD3C>fCD CBffCD CCCDffCCfC?fCDLCBC@  C?C7 CBffCB C? CA  C?fCA33C>C=C>C:33C=C>C<LC>3C<C;ffCA3C?  CALC:C?3C? C>ffC:33C<LC=  C<3C<fC:ffC833C;33C8C6C7fC8LC7  C8  C,3C7LC6ffC/3C7 C8C833C83C63C/C0fC9ffC7  C0ffC533C9LC3 C9ffC8C9C8C9C933C9C9C3C93C:C5fC933C4ffC8  C4ffC6LC:3C:33C: C:  C;ffCAffCC33CJ33CJ CI  C@CHCH  CHffCIfC@CKLCICHLCBCGffCB CC3C=ffC=C:C9fC;C633C6C;C533C033C3LC2  C.C+C3C8C7LC: C7ffC<3C> C=3C9fC?3C?C;ffC?C? C; C<3C7C;fC;C8C733C5C3C;  C:C;LC8C,LC9ffC1ffC0 C- C2C9  C8LC8LC73C3C2 C3LC,3C6ffC.C3C6LC333C7fC) C7  C/LC*ffC(C8  C2C7ffC2C7C1C3C.LC933C9fC9ffC2LC8  C,fC73C8C-C3LC5C7C7  C6  C8 C7ffC8C933C9  C7C:LC9C83C:LC733C5 C/C6C6C4LC0C. C0fC13C3  C/C133C/C233C1C&LC.C- C-33C/ffC,33C-33C)3C*33C*LC'C* C'fC!  C) C( C#LC$33C+ C(fC)  C(C%fC)C&C'33C) C( C)LC&C'C'33C(3C'C,C'ffC$C( C% C$C(  C$C%ffC'LC& C(C%C&fC&33C'33C$C'fC(  C(ffC&fC& C%  C'33C)LC'ffC(  C( C 33C'  C&C'3CffC&C&C C%C%ffC'33C' C( C'C$C(fC)  C) C%C*C'33C"3CC)C)fC) C(LC(33C'C(LC(ffC(LC& C"  C%C)C(fC'CffC(ffC&C'fC%C' C' C(C(ffC'3C'3C(33C&33C&fC&C% C'ffC%C%3C$ CffC$  CLC"LC"ffC"33CC 33C ffCLCCLC CCfCfCffC  CCf$!   $$Bff   $ff  ?  ?LͿ33@  @s33@@陚Aff@AffA  A  AffA33AA33ALA   A9BA@  B,A6ffA&ffA8  A9A@  B33AVffA\ATAffAnffBffAx  AaAAA[33A~ffAk33AqAaB33As33AA  A|AAffA33AffAAA  ABffAffBffAc33AffBffAA  A33AA~ffABffA  AAffA  AffA33A33AAAffAffA33AAAffA  A33AAffAAA  A  A  AffABABffAřA  AAA  BA33AA33A33AffAAAAffABffA͙A͙BffAffAffBffAA33AffAřBffAA  A  AA33A  AffA33AᙚAՙAffA  A  A33AffA  AffA  A  A  A͙A  BAffAA33AffB33A  AAA  A33BffAAٙAffA33A  AffA  A͙A  AAAAffAəA33AffA  A  AA  AffBffA͙A33AAՙABA?L?ٙ?333?333?  ?  ??  ?ff?L?L?L??333?L?L?L?33?33?  ?  ??fff?333?L?  ?  ?  ?333?L?fff?L?L??333?fff?L?L?  ?>?fff??ff????ff@33?  ?ff?33??33?@   ?ff?fff?fff??333?fff@L?L?L?  ??ff?  ?ٙ??33?ff=?fff@ff????33?ff?  >??fff?333?L?  ?  ?  ?  ?  ??fff?  ??L??33?  ?ff?ٙ@   ?ff@33?ٙ?ٙ?ff@33?  ??  ?  ??ff?33?  ?ff??   ??333??33?L?ff??ff?ff?ff?ٙ?  ?  ?fff?ff?ff?L??33??  ?ff??33?33???33?  ?ff?ff@ff?ff?33?ٙ????  ?  ?  ?33?fff?L????L?  ?fff?ff?333?333??  ?ff?  ?  ?  ??333?333?  ???L??  ?fff??ٙ??ff?ٙ?ff?  ??L?  @ff?  ??  ?ff?33??333??L?L????  ???L??  ?333???ff?fff?333??333?   ??fff?33?333?L?   ?333????fff??L???33?fff?ff?L?fff??33?333?L?   ?L?fff?  ?fff?  ?  ?  ?33?  ?fff??L??333?  ?fff?L??  ?????  ?fffA  ???  ?  ??  ?L?  ?333?fff??L?fff?fff?fff?  ?ff??  ?  ??fff?fff???L?333?   ??fff>>>?????333>?333?333?333>?333??L?fff?  >?   ?fff???33?  ?  ?  ?  ??fff?33?fff?333?fff?fff??   ???  ????fff?333?L?L??333?L?fff?ff?333?  ?L?ff?   ?   ?L?L?L??fff?L>?333?333?L?   ?fff?  ?ff?L??  ??33??L?333?L?   ????  ?ff?L>?L??fff?333?333?L?333>?   ?fff?fff?fff?L?L?fff????    ?L?fff?333?333?L?  ?L?333??333??333??  ?L?fff?fff??fff?L?fff>?   ?333?L?333?  ?ff?  ??   ??333?333?fff?333?fff?L?L?L?ff?333?   ?fff?L?L>?fff??333?fff?  ?L??fff??333?333?   >>?   ?fff??L?ff?  ???33>?L?33??fff???A  ?33?L?  >?L?L?L?fff?@@  ?333?fff?L>?  ?L>?L?fff?L?  ?L?fff?fff??fff?333??   ?  ???  ?33???  ?33?L?  ?fff?ff?  ?  ?fff?fff@&ff?  ?L=?ff??fff?ffAQ@?ٙDDvf?33?ff??33?ff????ff??ff?ff?fff?ٙ@   ???fff??L?333?  >L?333?>L?fff?>>??333?   L>?L?   ?L?333>?fff?L?   ?   ???333??   >L>?L?L=?L?L>??L>?L??L?fff??L?333??fff?fff?fff?  ??L?L?  ?>L?L>>L?333>L>?  ?   ?L;?fff?L?>>?fff?   ?fff?  ?fffDv  ?  ?  ?  >?   ?L?fff?L?333??333?333?   ??  ?33?ff??ff???333?fff??  ?   ??   ??   ?333>>?fff>?   >L    >L>>>?L=???   ?333?333>L?  =?   ?fff@333@   @fff?ff?33@ff?  ?@   ?33@,@33@ff@,@fff@   @   @ffD<D@ @`  @,@  @  @33@ff@@@  @fff@33??33?L?  ?ٙ?33@33@@ff@   @@ff?33@ff?ٙ?33?  ?33@333@&ff@   ?33?@   ?ff?ff?ff?fff?L??fff???fff?333>?fff?fff??333?L?  ?ff?  ?L?fff?333???33??  D9@33@?33?ٙ?  @,?33?ff?@   Dɚ?ff@33@9?@ff@?ff?33@@,D@33@@S33?  @@   DAffAB??  ?L?fff??333?ff>L?  ?fff???fff?ff?333>?fff?333>?  >>L?>>>L?  ?   >>?>?  ?L?>??L>L>?>=>>L?333?   ?333?ff?ff??   ?333?fff?   ?>>;L>L>>L>>>L>>>;>?=    >L=?   >L>>L;L?L>L??  >>L?    >>?   @   ?  ?333??L?>?333@      ?333>>>?L?   ????333=>>=>L>?333?   >??   >L?>==?==    =>?>L?   =?fff>?   >    ?  ?333>L?=>?333>L?  >>@   >?333?   ?   ?  ??  >?L?   ?  ?333?fff@   @  ?  ?ٙ?ff????fff?fff??  ????333?33?33??fff?ff@33@@  @   ?ff??L?  ?33??   ?   ?L?333?L??  ?333??;L>ͽ?L??>?33?    =;?>L;L?   >?@>?fff?333?  ??   ?  =?333>L>L;Lͽ???L?fff??   =;L;L>    ?   ==?fff?fff>L        >L;=>?  >@L?  >?   =?  ?L>L?L?L?ff??>L            >L;L??   >>?   =?   >?fff??  ?fff??fff?  >?  ?  ?ff??333??ff@?33?33@333?ٙ?  ?33??33????   >>>>??ٙ?  ?@   ??  ?>??  ?ٙ@   @,?33??ٙ?ٙ?333??    L?   >>==>?fff?   ?fff?333?>?   >L??fff?  ?333?333>>?ff?333?  ?L??333?333?fff?  ?  ?  ?fff?L?   >=>L?L?333?L??333?  ??333?  ?  ??  ?fff?L?fff?  ?L?333?   >>L?   ??fff?fff??  ???333?  ??333??ff?  >?333?  >?333??   ?fff?  ?>L>?L???333?33?33>??L?333?333???fff?   ?L?  ??ff?L?fff?  ??ff>?fff>L    ;===?==ͽ?   ?>>>>?>=ͽ;?333L?   =>?    =?        LͿͿ333   L>L>L=?ff@ff@   ?ٙ@ff    ?   >L?   >L?   ?   L;=;;L;>L>;>L?       ??L>??fff?>=?  ?fff?  ?333>?333??L?        ?      Lͽ    >;   ?fff??L>L=?   >>L;Lͽ>=?   >?>?L?L?fff??L?  ?fff>>    ?   >?fff?333?fff>?   ?>?  ??33?  @,?33?ff???33?fff?33?ff@@,?ff?ff?@@?33???ff???ٙ?333??333@fff?ff@ff?  ??33?33?fff?fff?  ?>??ff>        L;?   >>>=>    ?  >>L>L?333>=>L=;L;=>L;>>L???333??>    ==>=>L>;L>L=?   ?   >;;L        ͽͽ=;    ;Lͽ?fff>>L;=Ϳ=ͽ>L;    >ͽ;   L    ;L?   >L>L>L=?333>>L;L>=?   >L>    >;ͽͿ333>L    ͽͿ?   LͿͽͿ   @@  =           =Ϳ   333       333ͽͿͿ333    Ϳ       ?;LͿ333  ?            ͽ    333>L?L;>    >>LͿ   @33fff?333?333>=Ϳ333LͿ   ;?33?   =?   =Ϳ333>L;L;LͿ   >Lͽ;ͿL;LͿ333=ͽ       LͿL;L        ͽ>L;L=    333=ͽ;L>?   >L    =ͿfffL?333L;Lͽ;>    >;L>L;;@ff333L;Ϳ333ͿL;LͿ   LͿLͿ333  LͿfff333LͽͿ   Lͽ;L       Ϳ333         L;L;LͿ        L;Lͽ>333=;Ϳ333=;L    >ͽ?           ?   >L?333=?L?   ?   >?333>??ff?  >?   >?      ?fff??L>    >=>?   >>;L>Ϳ333Ϳ=;    >L?333>?333?   ??>>?fff>??333@ff@333@,??ٙ?>?L?   ?   ?   ?  ??  ?33@33@   ?ff?  ?33@   ?33??33@ff?ff@ff?  ?  ?ٙ?ٙ?  @   ?ff?33?33?33?ff?33?  ?  ?ff=??@333?333?fff?   ?ff??L?33?   ?L?fff?333??  ???L??L?  ?ff?33?  ?   ?  ??ff?  ?33@   ?  ??ff?  =?  ?ff???L?ff?ٙ?  ??ٙ?ff?  @33?ff?  ?33?  ???  ?ff??ff??33@&ff@`  @S33@,@@9@   @&ff@@&ff@&ff@33@Fff@S33@Aff@33A\AqA.ffAA33AA33A33AA33A33A33AffAffAffA  AAtAaAS33AVffAVffAS33AK33AS33A~ffA6ffA+33A(  AAA   AffAAA8  A<A+33AA)A@  Aff@  A	A33AffA33A   AffA	AffA33@@  @@33@  @  @@  @@33@fff@  @  @@  @33@  @@@  @`  @fff@@@y@  @fff@fff@s33@S33@l@fff@  @@33@33@@@ff@y@fff@33@Y@  @l@Y@ff@@  @s33@fff@y@  @l@ff@s33@@33@  @  @`  @@  @fff@Fff@Fff@S33@S33@`  @ff@ff@`  @`  @l@S33@fff@S33@Y@s33@fff@9@Fff@s33@@y@ff@S33@@  @L@fff@L@333@@   @   @33@@   @ff?@333@S33@@  @@  @333@ff@,@&ff@?ff@@@33@33@S33@333@Fff@&ff@9@Fff@`  @Y@Y@9@Y@@333@@ff@ff?ff?ff??  ?33????ff@   @@   @@   @ff@?ff@ff@333@9?ff@33@S33@ff@   @ff?ٙ?  ?ٙ?33?ٙ?33???ٙ?ٙ@   @??33@?33@ff?ٙ@   @   ?ff@   ?33?ff@   ??  @?  ?ٙ?33@ff?  ?ff@33@ff@@??33?  ?ff????33??ff?33@&ff@ff@   @9?33?33?33??33?ff?  ?fff?  @   ??ff?33??ff@   AX  ?ff?@33??@   ?33?ff?33???ff?  ?  ?  ?ٙ@ff@,?  @   ?33?ٙ?33?ٙ?  ??ٙ??33Y?  ?  ?  ??  ??fff?ff?33?ff?ff?ٙ?@   ?33??  ??  @ff@   @@   @?@   @   ?  ?33?33?  ?L?>?fff@   ???333?ff?33?L??33??33?33@   ?ٙ@ff@   ?ff?ff@ff?ٙ?  ?@,?  @33@ff?  ?ff???ٙ@&ff?  ??????ff?33?ٙ?ff?33?33@   ?33@33?ff@33@Fff@,@&ff@,@@  @,@9@S33@333@@&ff@   ?ff?ff?  ??fff?>Lͽ?333>L>>?fff?333?33??fff?fff??33@??33?ٙ?33?ٙ?ff?ff?33??  ?fff?ٙ?fff??ff?333?L??L?L??ff?  ?33?fff?  ?L?ff??fff??@33@33@?33?ٙ?33?33?ff?ff???33?ٙ?33@ff@33@   @9@   @@33@ff?ٙ@333@   @   ?33@   @@@   ?ff@,@@Fff?ff@,@&ff?33?  ?ٙ?33@   ?33@   ???33@ff?33?ٙ@ff??@   ?ٙ??33?  ?33?@   ?33?ff?33?33@ff@@&ff@@   ?  ?ff?ff?ٙ?ff???ff????ff?  ??ff?ٙ??fff?  ?333??ٙ?   ?  ?fff?  ?ٙ?fff?ff??ٙ@   ?33?ٙ?ٙ?ff?  ?ff?ff?33@   @&ff?ٙ@33?33?33?L?@@@   ?ٙ?@   ?33?ٙ?ff?  ?fff?L?33?  ?ff??ٙ????ٙ?  ?33?ff@   @   ??ff>=?   ?L?ٙ?fff?33???ff?  ?L?  ?fff?fff?33?L?L?33??  ?   ??ٙ??ٙ?33?  ?ff??  ?33?ff????fff?ff?ff?ff?33?33?ff?33?33?ff?33??ٙ?ff@?ٙ??  @s33>>?   ???L?@ff?ff@Y@   ?ff?ff@   ?33?33?ٙ?ٙ?@   ?ff@33?33@33?ٙ??ٙ?33@fff@S33@33@33@  @AAAffA   @@陚Aff@@ff@33@ə@  @ff@ff@33@ٙ@33@ff@ff@ff@Y@33@  @ff@  @@ff@  @  @`  @L@ff@L@fff@ff@L@9@&ff@9@S33@9@   @Fff@  @,@S33@333@L@9@@  @Fff@,@&ff@@   @   @333@L@@  @?ff????ٙ?ff????   ?333?333?L?>>>?   ?L?=?fff?L?   ?L?fff?   ?333?L@ff@   @@@ff@?ff?ff@`  @ff?@   @33?ff@@   ?ff?33?33@   ?ٙ?ٙ@   ?ٙ?ff?33??  ???fff?  ??33??33?33??33?  ??  ???????fff?33?  ?  ?L?  >?ff?  ?????ff?ff?33?  ?ff?@   ??33?  ?ff?ff?33?fff?L?fff?fff???333@33?ff????33?ff??ٙ?ff@,@ff?33@   ?33?  ??ٙ?33??33@   @ff@@?33@ff?ٙ?ٙ?33?@   @ff?33?33?33@ff@?ff@   @   @333@@33@9@@??33?ff@ff??ٙ?@   ?ٙ?  ??  ??  ?333??>?  ?  >?333??L????  ?333??fff??333?fff??33?  ?   >?fff>L?L?33?fff?33??  ?33?fff??  ?  ?ٙ@S33@y@?ff?ٙ??ff???ٙ?  ?333?  ?   ??333??333?333>L?fff?33???ff??  ?L????333?   ?ff??L?L?   ?333>>L>ͽ?   ?333=?  ?  ?L??fff?   ?333?333>>>?fff?fff?fff?   >L>?   >>??@&ff?333?@?L?L?L>?fff?L?33>?  >?333?L?L?333?333?  ?ff?fff?ff?fff??L?ff?ff?33?  ?  ?333?333?333=?333@Fff>?fff?   ?  >L    ?33    ??333?  ?L?fff?fff?  ??L?Lͽ?ff>>>?333??333?333>>L?>?   ?L?>>?33>>>>???   ???ff?  ?  ?  ???  ?   >>>    >??333>?333?   >L;>>;L>L??fff?  ?L>?fff?  ?L?   >>;?fffL=;?>    >?  ?L?   ?333?L?L?L?   ?>?333>L?   >>    ?L?   >?   ?fff?   >?=?333=?   >L=>L?>=?>    >Lͽ=?   >L>??=??333?fff?333?333?=?       ?>=>=    ?   >?  ?333?L==ͽ;L>L    L?>L>L?L?  ?333=>L?333?   =    =;=;    >>L    >>==>=@&ff?ff?33?  ?ff?ff?33??ٙ?33@33?ff?33?ff?  @33??L>??33@ff??ff??333?fff?fff?   ??ff>L?33=?   ?   ?333?  ?  ?>L?   ??ٙ??  ?@,?ٙ@9?33>?   ?   ?L=    >Lͽ;>;L;;      L?333>?   ??>?>==    ?fff?fff?333?33??333??fff?>>?   >L>L>Lͽ=;L>L    Lͽ>?L>>??   ?   ?  >L?    >=>L;L>??>?333?@33???  ?333;>>LͿ333=    Ϳ=>L>L        ;    ͽ?       Ϳ333   >    >;L>?333>L;L?fff?   ͽCY=;L?    =;Lͽ>L>ͽ=    ?   ?333=;L>L=    ?333=;L==;L;LͿ?   LD)@333        =Ϳ       L?>L=    ?fff?ff>BHff?fff?fff?>=    ?fff?fff?   >ͽ?   A;ͿLͿL;;>;L;?333    ?=;L    >;          =A33    ?333?L?   L?    =?333>L>LͿ   >ͽ    >    ?333?L?   >Lͽͽͽ        =Ϳffffff>;L>>        >L=>>Aa>LͿ   ?   ͽ;          ;==ͿLͿL;L;LͿ333    ;;;LͿ   fff;LͿLͿLͽ      fffͿ   fff?fffͿ333ͽ;==Ϳͽ=Ϳ333Ϳ   ?      =;;   ;L;Ϳ333       L;Ϳ          Ϳ   LͿ;L;Ϳ       >L>>L;Ϳ?   Ϳ      ;    =;   LͿ333    =ͿLͿff    LͿff>L    ;;L>L=    =>    >=;L?333>Lͽ;L>L=ͽͽ>;L=    >L;;;L    >ͽͿ   >    ;?fff>ͽ    >>L?fff>LC33333L>L;Lͽ>>L>        L;L;    >?    >>ͽ?==;    Ϳ333>LͿ   ???fff?ff?ff???33?ff?33?  @   @&ff?33???ff?  ?ٙ?ff??33?  ?ff@  ??  ?ٙ?Al?  ??333??  ?fff?33@ff??33?33@   @ff?33?@&ff@333@   ?  ?33?33?  ?  ???fff???333?   ??   ?L=?L??333    ?        >?   >?L??33?fff?fff??>>=>L    ?>?   >ͽ?L?fff?L?   ?&ff   @  9   ff,fff9   @  @  33Fff@  LͿ33L@  Fff   333ff333   9S33?ٙ;>?=FffFffS33,Y`  @  LYlLFffYfffFffL  fff9Fff`  Yfff9S33  S33S33Y  S33333ylffffffy@    y9ffy`  LS33S33Y333S33S33@Fff@  AA1@ٙ@@  @33@fff@  @y@L@9?ff@333@   @33@ff@ff?ٙ?33@ff?  @   @@,?33@@,@ff@@33@33@   @?ff@   ?33?  @   ??ff?ٙ?L??ff?333?ff?ff?L?L?L?ff?  ??  ??  ?  ?fff?   ??333??fff?333?ff?  ?fff??   ?ٙ??333?fff?333>?33?333?>?333?333@   @L@  ???ٙ@33@ff@S33@33@Y@   @   @ff?@   @@   @  @y?ٙ@   ?ff?333?33@ff?ٙ@@33?  ?L?  ??33?L?33?33?L?>?fff????fff?333?333?333?   ?   ?L?  ???33?333>?333?fff??  ??L?L??   ?L?  ?333    ?   =?L?  ;L?fff>L?333>?fff?   >>L>L=>    =Ϳ   >L?333>?L?ٙ@ff@@   @&ff@9@@  @Fff@Fff@Fff@L@S33@Y@L@S33@Fff@9@L@9@9@,@@  @Fff@L@,@Fff@S33@L@Y@l@@@fff@S33@l@S33@l@`  @Y@L@Fff@@  @Fff@S33@@  @@  @Fff@333@@  @9@S33@9@333@@  @9@33@@  @9@,@333@   @33@  @fff@33@S33@L@L@Fff@Fff@Fff@Y@`  @`  @@  @L@S33@S33@Fff@`  @S33@S33@L@@  @L@L@Y@L@Fff@@  @L@Fff@Fff@S33@fff@  @  @fff@`  @Y@l@S33@@  @9@333@333@Fff@,@333@9@@  @Fff@9@@  @Fff@@  @@  @@  @Fff@333@9@@333@   @&ff@333@,@333@@  @9@@  @@  @@  @@  @Fff@L@L@Fff@L@S33@@  @9@`  @9@333@9@@  @9@&ff@333@9@333@,@&ff@,@,@&ff@&ff@,@,@333@333@@  @9@`  @,@,@333@@  @9@9@9@333@333@9@@  @9@Fff@9@9@,@,@333@333@333@9@9@333@,@9@@  @333@   @,@333@,@333@9@,@333@333@@  @333@@  @9@Fff@@  @L@,@Fff@@  @@  @9@L@L@9@L@L@Fff@@  @,@@  @&ff@@  @L@Fff@9@@  @Fff@@  @Fff@Y@S33@S33@Y@@  @Fff@L@L@Fff@Fff@@  @9@9@9@9@9@9@@  @9@9@333@@  @9@@  @9@333@333@,@&ff@&ff@&ff@&ff@&ff@&ff@   @&ff@&ff@&ff@,@,@L@9@Fff@@  @Fff@@  @@  @L@S33@Fff@`  @`  @`  @l@l@Y@`  @S33@fff@Y@`  @fff@fff@l@fff@y@@y@y@y@ff@s33@Y@fff@ff@`  @`  @`  @Y@L@`  @Y@`  @`  @Y@Y@S33@L@L@L@S33@L@Fff@S33@@L@L@Fff@@  @@  @Fff@Fff@S33@`  @S33@s33@fff@Y@l@l@y@y@`  @fff@l@s33@  @`  @l@33@ff@  @@@@  @33@33@y@y@fff@s33@fff@fff@`  @Y@S33@Y@S33@`  @@  @l@S33@l@s33@l@`  @`  @Y@`  @fff@s33@`  @`  @Y@s33@l@fff@y@Y@`  @l@s33@s33@fff@`  @S33@L@ff@33@33@@@33@33@33@ff@  @fff@y@s33@l@@y@`  @S33@s33@fff@l@l@l@l@fff@fff@y@fff@l@s33@fff@l@`  @`  @Y@`  @l@fff@s33@fff@s33@y@y@y@@s33@y@y@y@s33@s33@s33@l@s33@l@fff@fff@fff@`  @Y@L@Y@`  @fff@`  @s33@s33@l@s33@s33@`  @`  @`  @fff@fff@`  @fff@`  @`  @l@l@`  @fff@l@s33@l@l@`  @s33@fff@y@l@`  B   @  @  @l@33@s33@l@y@y@S33@fff@`  @y@y@s33@  @  @33@@ff@@@ff@  @@33@@@@  @@@@ff@@@33@ff@@@  @ff@33@ff@@ff@  @ff@  @ff@@ff@ff@ff@33@  @  @  @  @  @33@@@ff@@@@@@ff@33@33@@ff@ff@@@  @@@@  @@@33@@33@@  @  @33@ff@ff@  @  @@  @33@@ff@  @  @@ff@ə@ff@33@ə@  @  @@ff@  @  @@  @@33@  @ə@@  @ff@@@33@33@  @@@  @33@ff@@@@A)@  @ff@33@@@@  @33@ff@ff@33@  @33@33@33@  @@@ff@ff@  @@@@  @ff@ff@@ff@ff@33@33@  @33@33@33@@  @33@ff@  @@33@@@  @@@@@@@  @  @33@@@33@33@  @@@  @@@ff@33@ff@@ff@ff@@  @@@@@@ff@  @  @@@ff@  @  @s33@ff@ff@CV3@ff@@@@@ff@  @33@fff@S33@`  @fff@33@s33@fff@`  @`  @33@ff@  @  @@33@ff@ff@@33@  @@ff@@@@@  @  @33@33@ffAS33@  @@  @33@@@ff@  @@@33@ff@33@33@y@s33@s33@33@s33@33@33@  @  @ff@  @  @33@  @  @  @y@ff@33@  @33@l@  @y@s33@y@@33@@@ff@33@  @33@@ff@ff@y@y@Y@s33@L@`  @Y@Y@fff@S33@fff@l@ff@`  @`  @  @s33@y@s33@fff@fff@l@y@s33@y@l@s33@s33@s33@@l@s33@s33@33@y@33@y@l@l@l@s33@`  @s33@s33@fff@l@s33@ff@33@33@  @@  @@lA`  @s33@@  @ff@ff@ff@ff@@@  @33@@@l@s33@ffA  AᙚB  B$  B B=ABA  A  A33A͙A  A  AffA33AAAA33AA33A  AAqAp  AnffAp  AlAA  AffAA33AA  AffAAAAݙAffAA33A  AəAA33A  AAAAffA  A  AAA  AffAAffA  A  AA  A33AA  A  A33A33AAtAc33AVffA^ffATA^ffAX  ANffAC33AC33AK33ADAH  A8  A.ffA1A)A$A)A.ffA0  A0  A)A33A&ffA	A33A  AffA33AffA33@33@@A   AffA@ff@@@ffAA33AA33AffA   A(  A+33A1A4A;33AFffAFffAFffAC33A<AC33AH  ATA  AffAffA33AݙBffB  B
ffB  BffBAݙAffA33BBffB  B33B33B  B  BAAA33AffA33AffAffAA33A33A  AAAffA33A33AAffA  A|Ax  AnffAiAh  AdAh  Ah  Ac33AfffA^ffAaAYA[33A9A1A@  A>ffA0  A1A0  A$A!A!A33A&ffA#33A#33AA#33AAA4A&ffA6ffAFffA^ffAffA  AAffA  AffABBBAA  A33AљA33AəAA  AffAA  B&ffBHffBaBiBZBSB8B333B.BI33BbffBv  B^BFffBO33BF  BH  BEBA33BffB&B&ffB ffB33BBB2B_33BJ  B0B!33B.ffBFBBA  AffA  AAffA33AAA  A  A33AA  A33AqAfffA\AP  AIAK33AFffA8  A<A@  A9A0  A,A#33A#33AffA  AAA	A	A	A  @A@ff@ff@ff@ff@陚@33@@@陚@ٙ@@ff@33@ٙ@ff@ff@33@@@ə@@@  @@@ff@33@33@  @ə@@@ff@  A@@@@  @ff@33@@@ff@  @ff@@33@33@@  @33@ff@@@ff@@ff@  @33@@33@@33@33@y@  @@ff@@33A33BA33B   AffAљA33AffAaAYAQATAP  AIA>ffAC33A+33A&ffA#33A,A+33A$A#33A$A0  A.ffA333A@  A4A@A33A33A33A33A33A33A   @@A   @@ٙ@33@33@@33@  @33@33@@  @@33@  @ff@ff@  @  @33@33@ff@  @33@ff@@33@ff@33@A	A@33AA33A@ff@ə@ff@@  @33@  @ffA@@33@@@陚@33@ٙ@33@  @@@ff@ff@ff@ə@@ffA33@陚@陚@33A@  @  @@ٙ@ٙ@@@ff@@@33@  A@A33A@@ff@ff@A   @@33@@A  A33AA33A  AAAffA!A  Aff@@ٙ@ff@ə@  @@  @33@ff@  @  @33@ff@33@ff@ə@@ə@  @ff@@@  @ff@33@33@  @@  @ff@@ff@  @ff@@33@33@33@@  @@ff@@@@@@33@@@@  @33@@  @  @  @33@  @@@@ff@@ff@  @ff@@@@@33@@@  @ə@ff@  @  @@@33@33@  @ff@  @ə@@陚@  @@@  @33@ff@  @33@33@@  @ff@  @  @@@ff@ff@  @@@  @@33@33@ff@33@@  @@33@33@@33@ff@  @33@  @ff@  @  @  @ff@@ff@@  @s33@33@s33@Fff@@  @Fff@@  @9@9@333@9@l@fff@33@@33@l@l@y@@  @@33@@@  @@@@  @  @  @@  @@  @  @@ff@ٙ@@ff@@@33@ff@y@@@@@@ff@  @ff@@ff@  @  @@33@@ff@@@33@y@y@y@ff@y@  @@@ff@  @@@33@33@@  @l@`  @ff@  @  @33@  @@33@ff@33@  @@@  @ff@33@33@  @  @  @ff@33@@ff@  @  @@@ff@  @33@@@  @33@ff@33@@@33@ff@  @@@@@33@@@ff@@33@@  @  @  @@  @@@l@Fff@s33@s33@@ff@33@s33@s33@l@fff@l@fff@fff@s33@y@l@l@s33@Y@s33@  @ff@33@@33@@  @@33@@s33@fff@Y@Y@`  @Y@Y@ff@33@33@ff@y@ff@33@@ff@33@@@@@@33@@@@@fff@S33@S33@  @y@33@  @  @`  @Y@  @  @@  @  @33@33@  @@33@  @@@33@fff@y@fff@Y@@@33@S33@Fff@@  @,@   @333@   @333@Fff@`  @@ff@S33@Y@l@`  @`  @l@fff@fff@S33@L@S33@l@`  @L@fff@Fff@9@L@@  @L@Fff@&ff@333@,@9@9@9@9@333@9@9@Fff@S33@S33@`  @Y@Fff@S33@Fff@@  @@  @Fff@@  @   @,@&ff@333@@   @&ff@,@   @333@@&ff@333@&ff@&ff@@   @,@@  @333@9@Fff@Fff@`  @`  @33@33@33@@33@   @33@33@33@@@@33@@@@&ff@   @   @@   @&ff@&ff@333@9@&ff@Fff@@  @L@Y@9@9@333@Fff@   @   @333@&ff@&ff@@@@33@   @&ff@   @@&ff@   @@@   @,@,@   @   @&ff@&ff@33@33@33@@@@@@33@@@@33@   @333@&ff@   @&ff@33@33@   @33@9@@,@,@&ff@Fff@@  @333@L@S33@L@33@Fff@33?ٙ@?33?33?33@   @   @   @ff?33@@@ff@   @   @   @   ?33@ff@33@33@33@@ff@   @33@ff?33?ff@?33@   @ff@@@33@@33@33@@33@33@@@@&ff@   @333@@,@@&ff@   @@   @&ff@,@&ff@   @33@&ff@&ff@9@@  @Fff@`  @S33@ff@ff?33@   @33@Fff@ff@@33@,@333@333@Y@ff@l@y@  @`  @`  @fff@  @`  @S33@l@`  @Fff@Y@333@L@,@,@   @,@333@&ff@,@9@333@Fff@L@Y@Y@Fff@Fff@&ff@@  @&ff@@&ff@&ff@   @,@9@   @@@   @@@,@9@@  @9@&ff@33@33@@@@@   @ff@   @   @ff@@33@ff@@&ff@ff@ff@33@   @   @   @@@ff@33@@Y@ff@ff@&ff@33@   @,@   @   ?33?33@ff@   @ff@   @ff@   @   ?33@@@ff@?33@   @ff?33@ff@ff?33@   @ff?33?33@ff@   @   ?ff@ff?ff?ff@   @   ?33?ff@ff@ff@ff@ff@@@9@`  @Y@9@`  @L@Fff@,@S33@Fff@@  @@,@33@@33@   @ff@@33@L@ff?33?ٙ?ٙ@?33?33@?33?ff?ff?33?ff?33?ff?ٙ?ٙ?ٙ?  ???33@@   @@   @&ff@,@   @33?33??ff???ff@33@@  @Y@fff@l@Fff@@  @@  @L@L@l@L@Fff@L@,@,@,@9@333@@33@@   @@@@&ff@,@333@@  @L@L@L@Fff@@  @Fff@Fff@333@,@333@333@,@&ff@,@9@333@333@333@333@9@s33@33@33@l@y@  @Y@fff@`  @L@Fff@Fff@L@@  @L@Fff@Fff@@  @Fff@Y@`  @`  @l@  @`  @S33@L@@  @Y@Fff@Fff@fff@l@S33@l@33@y@ff@ff@@@  @  @Y@S33@L@Fff@L@Fff@L@9@L@L@S33@L@Fff@Fff@@  @@  @Fff@Fff@S33?  ?ff?@   ?ff?ff?ٙ??33?ff?ff???  ?  ???ff??ff@@&ff?fffff?  ?fff?L>LͿL??L?333?333????fff?  @`  ??  ??ff????33?ff?33?  ???ff  ??  ?ff??ٙ?ٙ@?  ?33?33?L?  ?   s33=?L?  ?fff??>;?>>L=    =>L=??  ?L?33?33@33@@@?ٙ@   ?ff?ٙ?ff>L?  ??ٙ?fff?L?  ?fff?  ?33??fff??>?L?333???L?333?fff?ff?L???  ?fff?333??L?fff?  ?L?L?L?L?ff???   >L>L;>>>L??   ?   ?   >>>?   ?   ??333?333?333?333?333?   ?   >?333???fff?  ???ff?fff?L?  ?  ?ff@   @33?33?  ?ٙ?ff@33??ٙ@   ?ٙ?ٙ@ff@   ?ٙ?33?ٙ?ٙ@   ?ٙ?33?  ??ٙ?33?33?33??ff??ff?ff??ff?33?33??  ??  ?fff??   ?   ?   ?   >>>?   >L>>>>>>>>L??>>>L>>L>L??fff???33?ff??ff?333?  ?33?33??L>ͽͽ    >    =>?L???333?fff>L>L>>??  ?333?   >?fff?L??   ?L?333?????333?333??@ff?   ?L?333?333??   ?333???   ?>?   >>>>>>?L>??>?>>>?>>>?   ???333??333??   >>?   >>L?   >>>>L=>L?   ?   >=?333>?   ?fff?????33?L?  ?  ??33???  ?  ?  ?fff?  ?L?   ?   ?333?333?fff?L???fff??333?>?   >L>>>>    ==>L>L>>>>>L>>>?   >?   ??L?333?fff?L?fff?fff?33????fff???  ???L?333?333?333?   ?fff?fff??  ?ٙ??  ??fff?333??  ?  ?fff?L??L@33@A33A\A0  A4A  A@陚A$AffA@ff@@@  @ff@  @ff@ff@s33@s33@L@L@Fff@9@Fff@Y@ff@@33@  @ff@@@  @@S33@333@33@   ?  @   ?33@   @@ff@ff@   ?33?ff?ٙ?ٙ?33?ff?ff@33@33@33@@@33@333@&ff@ff?ff?ff?33?ff????  ??ff?  ??  ???ff?33?ff??ff?ff@@ff@33@&ff@@9@L@S33@   @   ?ٙ@   @33@@33@@@,@&ff@   @   @&ff@,@ff?ff??ٙ@ff@33@@   ?33?33@33@ff@ff@ff@ff?ٙ?33@ff@ff@ff@33@   ?33?ٙ?33?ٙ?  ?ٙ?ٙ?  ?ff?ff?ٙ?ٙ?ff??ٙ?ٙ?ff??ff?????ٙ?  ?ff?ff?ٙ@33@33@   @@,@333@,@333@333@Fff@,@9@333@@  @Y@L@ff@   @ff@@   @@?ٙ?  ?ff@   ?ff@   ?33?  ??ٙ@33?ff???ٙ??33?33@   ?ff?ٙ?  ?ff?33?  ?ff??ff???  ??33@@   ?33@ff@@@   @@S33@L@9@Fff@,@@  @333@@&ff@   @&ff@ff@   @9@@333@&ff@33@@,@?ٙ?ff@ff??ٙ@33??L?L??333?L?   ?fff?  ?fff??fff??  ?fff???  ?  ?  ??333??  ??33?fff?ٙ?333???  ?ff?33?L?  ?fff?333??fff?333?L?  ?L?  ??ff?ff?ff?  ?  ?  ?  ?fff?  ?fff??ff?ff?ff??ff??ff?ٙ?33?33?33@   @   ?ٙ?  ?L?  ?fff??fff?L?  ?fff??L?  ?  ?333?  ?L??ٙ?  ?33????  ?fff?333?L?fff?  ?fff??fff?  ?  ?  ?  ?L?fff?L?fff?fff?333?L?fff?  ?L?L?  ???ٙ?33?  ??L???  ??ff???ff?  ?  ??fff??ff???  ?fff???33?ff?L?  ?333?  ?ff@?  ?  >L>?333?   ??   ?   ?333?L?  ?fff@Fff?33?ff@   ?  ?fff?333?  ?fff?  ?333???fff?L?   ?   ?333?L?=>L    ==    ?   >?   ??>L>?333?L?>?>L>>??  >??   ????fff??ff?33?ff??33??ff???fff?fff??  ?L?L?fff?L?333??333?333?L?fff?L??33??@ff?ff?L?fff?ff??  ?  ?  ?  ???????  ??  ?  ?  ?  ??  @   ?33?  ??  ?L?fff?  ??L?L?333?333??333@?fff?L?L?  ?333>@33?   ?>>>>>L>>>?33?  ?   ??333@,@   @9@33@?33?ٙ?ٙ?ٙ??33??  ??  ?33??33?  ?  ?  ??L?  ?fff?  ?  ??  ?L?  ?L?fff?L?fff?fff?L?fff?L?  ?333?fff?fff?L?L?333>?>?333?fff?D3?333?L???fff?333?L>?333?fff?  ???  ?L>?L????   ?   ?L?333?  ?fff?   ?   ??   ?L?333>L>?   >>>>>>>>>?   >L>>>?>>??   ?   >??  ??  ?L?@   ??  ?  ?33?fff?  ??fff?  ?L?   ?L?  ?333?fff?L?333?L?333?333?333?   ?333?333?L?333?L?  ?   ?fff?333??>>?   ?   >>L>?333???   ?333?   ?   ?   ??L>?333>>>L>L>L>=>L>>>L>L>>>L>L=>L>>??333?   >>?   >>>L>>>??L?   ???333?   ?333?333?   ??   >>>?   ?L>?   ?   ?   ?333?>??   ?>???   ?L??>?fff??fff?>>?333???   ??fff??333?>?333?fff?L??333?333=?333?   ?   ?   >?   ?   ?   >?   >>>>>>?   ?   ?   ?   >?????>?   ?   >>>?   >??   >??   ???333?L?333??333?333>>>>?   ?   >?????333?L?333@??L????   ?333?   ??333??   ????   ???   ?   >>?333?  ?  ?L??L??ff?33?ٙ?33?  ?33?  ?ff?33???fff?fff?  ?333????ٙ                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        @\@Mp@jH@\@jH@33@33?33@0?@\@G@@@\@33@33@@33A
RA@QA
RA AGA A{@QA A
RA/33@Q@@Q@QA
R@33A
R@@33@@\A@@{@@\@Mp@
@33@0@jH@@\@\@@{@G@@\@{@\@{@Mp@0@Mp@
@\@jH@G@Mp@\@\@jH@
@@33@0@0@33?@Mp@\@0@\@G@jH@
?@0?33??p@jH?>?@Mp?@Mp@G@@jH@G@@{@
A@A{AA{@QA
R@@33@QA{@Q@@@{@33@\@G@G@@G??33@33?@33@0@0@33@jH@0@Mp@0@0@33?@jH@Mp@0@@
@Mp@0@Mp@33?@Mp@33@0@jH@33?33@Mp?@0@33?33?33@33@0@0@33<?p<>@33??33<?33?p?p?33?p?33?33?p??p?33@33@Mp@Mp@33@33@jH@\@G@jH@jH@
A
R@Q@@A
RA @@@@33@Q@{@33@jH@
@Mp?33@jH@0@33??33??@Mp@Mp@33>>?p?33@0??@33?@33@33?@33@Mp@0@
?@33?33???p?<<>>???33?>?33@33@Mp@0?@33@0?33@33@0<@0?@33@0@0?p?p?33@0?p?p?p@33?@33??p@33@33@0??@33@0?@33@0?@0@0?@0@33?@33@33@33??@0@Mp??33?><<?p>>>>>    <
=
=
=?>?p>?p?p<?33>>?33?p?p?33?p<?p>?p?p<<><?p>?p>>?p<
=?33<>
=?p?p><<
=
=        =q>
=>
=    <><
=
=
=><
=
=>>>>?p?p>
=>
=<<    >?p<?p>?p><>
=
=<
=<<
=
=    <<>>    
=
=
=>
=
=
=
=>    <?p>
=?p?p<<>>><<  @jH?p@Mp<
=>    
=>
=?p׾
=<    =q<<<    <?p    
=    @\@Mp>>    ?p<<>??33@33?p@33???33@33@0?33?<?p<
=?p>><?p><>
=<
=>=q<
=?p׾
=
=
=    
=<>=q<<
==q    <<<
=
=?p?p>?p<
=
=>?p?p    <>?p>    ?p׾
=?p׾
=<<?p?p<<@0<@Mp
=>?p<>@33??33?33??p?33?p?33>?p@33@33@33??33?p?p@33>?>>?33?p>?p?p?33>>?p>><?p?p?33?p>?33>    
=?33<<>>><
=
=<>    <
=?p<>>>?33
=
=<<<<<<    
=<?p׾
=
=?p׾
=
=<
=><@
=q<<?33?33?33@0@33@33@0?@0?33@0@0@0@Mp@Mp@0@Mp@0@
@0??@0@0??p?33??33@33<?p?p?p>?p?p<
=>><<
=?p><<<?p><
=?33<
=
=?p><
=><?33<>
=><<
=
=><><>    <
=>?p><>?33>???33?>?33@33>?@jH@Mp@jH@33?@0?33?33?p??@0?@33@Mp@33@0@0@0@jH@Mp@33@0??33?p?@33?p?33?33?33?33?33><?p??33@0?p@0??33?p?33?p?33??p??p<>>    ?;
=    <        
=><
=
=<<?p<<?33<
=
=>>    <@
@\@G>@33@Mp?p@33?33??p@0@33@33@33@33@jH@Mp@
@Mp@
@Mp@\@jH@0@Mp@\@0@Mp@0@Mp@0@Mp@0@33@33?@0????33@33?p?33?@Mp@33@33@33@33@33@0@33@33@33?33@0?33?33?p@33>@0?33???p׾
=?p?p?33?p><?p?p?33?p>?p<?33
=?<>?p<?p?33?p>?p?p??33@33@0@Mp@G@@
@jH@jH@Mp@33@jH@
@0?33@33?@0@0@Mp@jH?33?33@33@33@0??p?33>?>?33?33?33@0??p>>?33?p?p?p>
=?33?p???p>>?33<>?p׾
=<?33>?p    ?p?p?p?p?33?p?p?33>?@33?>?33?33?p<>?p?33@0@{@G@0>@0@33@jH?33?@0?@jH@Mp?33@0@0@
@jH@jH@\@jH@Mp@Mp@\@0@Mp@jH@Mp@Mp?@Mp@
@0@\@
@@jH@0@
@\@\@33@@0@0@Mp@Mp@0?@Mp@0@0??33@Mp@33??33?@33@33?p??p??@33?p?@33@33?33???p@33@jH@jH@0@0?p?33@0@33?p???p?33?@33@33?p??33?p?@33?33@33?@33@33@0@33@jH@Mp@Mp@jH@33??@0?@33?33?p@33??33??33@33?p?p??p?33?p???33?33>??p?p?p?p?33>>?33?p?33?p?33?p?p>?33?p<?33    >?p<??33@33@33?33@33?33?33?33?33?33?33?33?@0??@33@33@
@jH?@33@0@jH@33A@@Q@@Mp@0?33@Mp@jH@jH@0@jH???@33??@33??33?33@33?p???33>??33?33?33??33?33<?p@0?p?>?33?p<?p?p@33@33?p??p??p?@0?33?33@33?p>?p?p>@33?33@33@0@jH@0?@33?@33?33?33@0?33@0??p?><?33?33?p?33?p?33?33?@33@33@33?33@
@33?@Mp?@33@jH@
@jHA@33@33A @@@{@\@
@jH@
@33?p?33?33?@Mp@Mp??33?p?33@33??33<?p?33>@jH?33??p>>>><?p?33?>?p>???33?p@33?p??p???p?p?p>?33@0@0>?33>?p??33@33?33?p>>>
=?p?p׾
=?33?@33@33@jH@jH@0@jH@Mp@\@G@{@@@@{@@33@@@
@
@
@jH@
@jH@Mp@
@Mp@jH?p?33?p?33@0?p?33?33?p>?33?33?p??33????33?33@33@jH@0@0@0@jH@jH@Mp@33@Mp@G@\@\@
?@33?;
=?p>?33??>?33>?33?33?33?33?33<>@33@33@jH@0@Mp@0@Mp@0@0@jH@Mp@jH@jH@Mp@Mp@jH@{@G@
@@@@{@@@\@@{@G@@@G@{@@{@{@{@Mp@0@Mp@33??33?@33@0@33??p?p??33?33@Mp@33@33@
@33@
@@
@0@
@jH@G@@@33@\@@G@@{@G@\@{@\@Mp@Mp@Mp@33?@jH?33?@0?p??33>?>?p?33@33?p@33?p?33?33>@jH@0@Mp@\@0@jH@jH@Mp@
@G@
@\@@{@G@@{@33@Q@G@@Q@33@@33@@@@@@{@@@\@@@\@@jH@jH@
@
@jH@Mp@0@0@0@0@0@33@33@Mp@33@jH@0@33@33@0@jH@Mp@Mp@jH@
@
@33@
@Mp@jH@jH@\@Mp@33@jH@Mp@
@\@33@Mp@Mp??33@33@33?@0@Mp@33?>?33>?p??p?@33@33?@33?33@0@0@
@0@@
@\@Mp@jH@
@@@\@
@G@G@@
@G@@{?>>@jH@{@Mp@33@\@jH@0@0@G@G@{@{@G@{@@G@jH?@0@0??p?33??33@33???p?33@0?@33??33?@33?@33@33@Mp@33>    >??p?33??p?p>??33@0?33?33?p??33??@0?33@Mp@0@33@Mp@Mp@0@jH@Mp@Mp@Mp@Mp@
@0@0@Mp@0@\@jH@jH@0@33@Mp@Mp@Mp@33@Mp@33@\@0@0?33@33???33?33>>?@jH@jH?@Mp?p>@33?33>?p>?33?33>>
=??33??p?p?p?<?p@33?33?p>>??p?p?>?p?p׿<
=?p?33>?33?p?33>?p?p?p>?33?<?33>?p>?p@33?33@Mp@0@33@Mp@jH@0@jH?33?33@Mp?@33?33@33>>?p?33><>
=><
==q
=
=<><=q<>
=
=><
=
=<>    <><<<<?33<<    ><
=>
=<<
=    
=>?p?33<    <<>>?p><?p><
=><?p?p?p?p<?33@33?p?@33@0@0@33@jH@0@
@
@G@
@0@jH@Mp@
@jH@\@Mp@
@jH?33@0@33??33>?33?>>?33?33@33?33??>?33?33@33?33?>?33>
=
=>>?;
=<<>>
=>?p<
=>>
=    
=<<<<<<<    ?p׾
=<>>
=
=
=??;
=
=<<
=<
=<>?p>?33?p>?p?33?p?33?p?33??>?33?p><?33<?p>?<?p    ><><
=>>?p<
=
=    <<<<>?p?33<<<    <
=?p><>
=>        <<?p>>
=<<=q<<>?p<
=    <?33<?>
=<?p?33?33??p@33@0@G@{@33A'
A/33A'
@@33@G@\@Mp@33@33???@0?p@33??33?33?p?p?<?33>>>?33?33@33?33?33?p?@33@33@33?33?@33?33@33?33??33?33?33?33?>>?33?p?33<>?p<>>    ?p>?p><>?p<
=?33<<>><
=?p<?p?33?33?33@0@0@
@
@
@\@{@
@jH@
@Mp@0@0????p?p?p@33??33?33>??33?33?33??>?33?p?33@33@33@0@Mp@jH?@0@0@Mp@Mp?33@0??33????p??33?33>?p?33>?p?33?33<?33?p><?p>><<<<>?33?33?p?p>?33>>
=
=
=<
=>
=?p@0?@jH?@jH@G@{@jH@\@Mp?p?33@33?33?33?33?p>>?33>>?33>><
=>        <
=<<>>?p<>?p?p@0?p?p>?33<?33><?p>??p>?@33?@33@Mp??p???p?p<<    
=><?p>>?33<>?p?p<
=>?p>
=>?p<
=><><><?p?;
=?p>>?@
@Mp@jH@33?@0?33?p?p?33>>?p<?p?33<
=?p<?p>>    ?p<<
=
=?p׾
=
=<<<?33@\@Mp@G@
@\@33?p?33<?33>?p?p@0?33@Mp?@
@0@
@@G@33?33?@33@MpA{A=AD@{ApB7A
=ASAG@\@Mp@jH@0@33@33@Mp@33@jH@\@
@33@0?33?@33@
@
@
@jH@jH@\@G@
@jH@jH@0@jH@jH@jH@0@0@0@0@0??33?@33?p?33?p?>>?p?>
=>>?p??33?33??p?33?33?p??33@33?p?p׾
=?33><
=?p?p>?33?p??33?p?33?p>?33??p׾
=>>?p?33???33>?p?p>    <?p?p?p@33??p@Mp?@Mp@0@Mp@0@jH@\@A{A
RA@@@{@{@33@G@{@\@\@G@Mp@jH@
@0@0???@33@33@33@0@33@0@0@0?@Mp@33?p@0@33@33@33@
@jH@0@0@0@
@0@Mp@0?@0?@Mp@Mp@0@Mp@0@Mp?33@33@33?33?33?p?p?33?33?p??33@0@0@0@33@0@33@33@
@jH@33@33@jH@G@\@G@G@G@A@33@QAA'
A/33A'
AGADA=A=@33A{A{A{AA{@33@@{@{@jH@
@0@Mp@0@0@
@\@Mp@0@0@jH@33@Mp@jH@0@G@G@
@G@0@
@@\@\@\@G@
@jH@jH@G@Mp@33@Mp@0@Mp@jH@\@jH@jH@G@0@33@33@33??p?33?33@33@33@jH@jH??33@33@33?p@Mp@Mp@Mp@jH@jH@\@0@jH@\@\@Mp@G@
@{@@@Q@@@QA@QA'
AAG@@@{@\@@G@
@jH@G@jH@33@Mp@0@jH@0?@Mp@Mp@jH@G@
@@@@@\@\@G@G@\@33@
@Mp@
@
@jH@Mp@@
@G@\@G@\@
@G@jH@Mp?33?33@33?p@33>?p<?p>><?33?33?p?33?p>><??33??33@0@jH@G@@Mp@
@
@G@jH@@33A A AGA6ffA'
A'
A
R@@@33A
R@QA@AA@AG@33A A6ff@{@@\@0@G@Mp@0@QA@Q@33@33@33@{@0@{@G@\@
@Mp@@jH@@{A@@{@G@
@{@
@0@{@MpA
RAGA6ffA{@@@jH@Mp@33>>??33?33><<<?p>?33@33??>?33?33?33?@33@33@0@33?33?33?p?33@33@0@0@33@jH@33@0@0?@Mp@Mp@0@33A@
@jH@33@
@@33A@
@0@33@33@0@0??p@33?>?33?p?33?33>?p?33?33?@33@33@0@jH?@0@0?33@Mp@Mp@jH@jH@0????@0?@0@Mp?@33@0@33??33@0??p?33??33>?p?33?@33?@Mp@0@33?@0@0@33?@0@Mp@jH@\@jH@Mp@Mp@Mp@
@\@\@
@\@\@
@
@jH@\@Mp?@
@Mp?33?p?33><?p<>?p?p<<>??p?p?33?33?@
@
@
@33@33@Mp@0@jH@\@0?33@Mp@33@33@0@0??p@0@33@0@\@jH?33?p<
=>>><>?p׾
=>
=?p><?p׾
=>>>>>@33<??33    ??p@33?p??p?33@jH@33@Mp@0@Mp@jH@jH@Mp@Mp@Mp@Mp@jH@33@jH?@33?33???33?p׾
=<@33?33
=<?>?33?p?p>?33?33?p?p?p?33?33><?33?p??33?p?33?p?p?33?33?p><??33<<?33?33
=@33>>><
=?p?33@\<
=>><>
=
=
=
=<?33    >?p?p??33>@Mp@
@
@G@33@\@33@jH@\@jH@jH@
@
@Mp@
@jH@\@Mp@jH@jH@0@0?@0@33?33?33?33?p?p?p?33>?p>
=<<?>?p?33?p׾
=?33?p<<>    >?p׾
=><?33?33?33?p?p>
=<?p<?p<><<
=>?p?p?p>
=?p?p>    
=>?p@33@33@33@0@33?33??@0@0@jH@
@@\@Mp@jH@
@G@\@jH@Mp@
@G@jH@33?@Mp@0@jH@G@Mp@Mp@Mp@jH@Mp@jH@jH@
@0@Mp@0@33@33@33@33@33?33?p?33<
=?33><<?33<<    
=<>><
=
=<?p<>?33??p?33?33?33?@Mp@0???33??>><
=>><>
==q><>><<<<?p?p        >
=<    >
=?p׾
=    <?p    >>    
=<
=
=>
=><<><<?p<
=>
=<    ?><<    
=<<<
=<<        >?p>><<?p<<?p׾
=>>?p?p?p>?33?p?p?33?33?p@33????33?p>?p??p?33?p?p?p?33?33?p>?p׾
=<>>?p?p>?p?33>><>
=>
=>
=<?p>
=
=    
=><?33?33>>    <<?33            ><<>
=    >?p׾
=><<<?p?33>?p?p?33?p@33??@0@Mp@Mp@Mp@Mp@
@Mp@jH@Mp@jH@jH@G?@jH@Mp??33@33?33?@33??p?33>    <<<>?33?p<<>
=>><<
=<<
=<
=<
=
=<
=
=>
=<<><<?p    
=<>>
=
=<<?p?>>>?p<    ?33>?p<?p<>>@33??p?p?33???@33@0@0@0@33@0@33@0@Mp?@33@0@0@0@33@Mp@33@0?p@33?33??p@
@jH@33@0@0?33?33
=?p>?p?>?p?33?p<>?33?p><?p<><
=
=<?p><><<?p׾
=><><<?p>><?33>>?p><?33?33?p>?p>?p?p<?33?p׾
=?33?p@33@Mp@Mp@G@G@@@G@Mp@
@\@
@\@\@
@jH@jH@jH@33@Mp@jH@Mp?33?33?33?33@33@33?33?p׾
=>
=?33><
=>><<>?p?33><?p<>?33
=?p?33??33?33?p?p?p>?p?p??p?p<
=>?p>?p><<?p><
=?p׾
=<>><>><>><<<?33?p@33>?33??33@33?@Mp@Mp@0@33?@33@Mp@Mp@0?@33@jH@33?@33?p@33@33?33???p?33?p?p?p?p?p<>><<><    
=<<<?p?p?p?p@0?p?33?p@33?p?p?p>?33??p??@0??33?33?33?@33???33?33<
=>>>?p>?p?33?33?33@33??33@jH@33@\@
@jH@G@@@33@Q@QA
R@@{@@33@@A{@@A@Q@{@@\@G@G@@\@Mp@Mp??@Mp@0@33?33?p?33?33?33?p?33@33@0@0@G@G@33@Q@{@@33@@@{@33@@Mp@
@\@G@
@Mp@33@0@33@33>?p?33?p?33?33>>?33???33?p?p?@33?>?p?33?p??A@QA A'
A'
AGAGA A{A{A/33A'
A/33A A/33A'
A=ALQA6ffA{@Q@Q@@Q@33@
@jH@33@33@Mp?33@0?33?33?33?@33?33?33?33?33?33@33?33@33?p@Mp???33@0@jH@
@0@0@0@\@Mp@0?@33@
@33@33??@33??p>?p?33?p?@jH>@33??p?33@33?p>?@jH@Mp@jH@
@\@0@0@0@0@G@\@0@{@@Q@@Q@Q@QA{A{AAAG@Q@33A@@Q@33@{@@Mp@Mp@Mp??@@jH@
@
@G@\@jH@jH@jH@jH@jH?@33?p@33?33@33@jH>@Mp@\@jH@@@G@\@jH@0@jH@jH@0?33?p<?p?p?p?33    
=<<
=<><?p?33??33?33?33?@jH@Mp@Mp@G@Mp@jH@jH@\@Mp@G@G@\@{@@{@{@@{AAA
RA
R@QA
RA
RA@Q@A(A A
R@@@Q@A
R@{@@@G@\@jH@
@
@jH@Mp@0@0@33@0@Mp@0@Mp?@Mp@0?33?33@33?33?@33?>?33?p@33?33?p?p?p?p<><?33><    >>>>?p<<<?p?@0?@0?@jH@
@0@Mp@\@
@Mp@0@0@0?33@Mp@0@Mp@jH@jH@\@\@
@G@@\@@G@{@QA
R@Q@@Q@@Q@@Mp@33@G@G@G@\A@G@@jH@@
@jH@\@jH@Mp@0@33??33?@Mp@Mp@Mp@jH@33?@0@0@33??33>???@Mp@jH?@33@0@Mp@33@0@
@jH@\@
@\@G@G@Mp@Mp@\@Mp@0@G@\@@jH@
@@jH@{@G@@@{@{@G@@\@@@G@{A@AA
RA{A A{A
RA6ffA6ffA'
A6ffA AA{A6ffAGAb{ALQALQ@Q@{@
@G@@33@33@33@{@@@@{@{@G@G@G@G@G@\@jH@@@@{@\@{@@33@A@@@G@G@{@G@G@\@G@\@\@@jH@G@jH@G@jH@Mp@
@0?@Mp?@jH@G@Mp@G@@G@\@
@
@
@jH@Mp@\@Mp@\@
@G@
@\@
@\@@@{@Q@A AGA6ffA=A/33AZHALQALQA=A=A/33A6ffA'
ALQA6ffA=A @@0@jH@Mp@@\@
@Mp@
@
@33@A{AGA'
ADA6ffA/33A AGA'
A{AGA
RA{AGA{AA A
RA
RA
RAGA
R@QA@@33@{@@@@{@@G@Mp@Mp@0@0@\@jH@Mp@33@@Mp@jH@
@jH@
@Mp@jH@jH@jH@jH@\@\@
@Mp@
@jH@Mp@G@G@\@\@@{@@\@{@@33@{@@A@Q@Q@Q@QAAA{A A{A'
A6ffA A@QA
R@Q@33@33A@@@AA
RA{A@33@A@@AAA
R@A@QAAA
RAA{A{A{@Q@QA
RA
RA
R@QAAA@{@G@@@G@\@{@
@\@@\@G@jH@@{@jH@@@@{@{@G@QA@Q@{@{@A@@AA6ffA/33A'
A'
ALQALQADA6ffALQASALQA=AZHAZHALQALQA=A=A A6ff@Q@A@@33@@A{A@QA{A{A@33@33@G@33A{@A
RAA{A'
A=A{A
RA
R@@{@G@@@G@\@jH@Mp@jH@Mp@0@0@0?@33@jH@33@0@Mp@jH?@jH@jH@
@0@
@
@
@@@33A
RA{A'
A{AGA @QA/33A{@Q@@QAG@Q@{@@@@@\@@0@Mp@33@33@jH@Mp@33@33@Mp@0@Mp@0?@0@33@Mp@0@0@Mp@0?@jH@jH@jH@0@Mp@Mp@0@33?33?33??@Mp@Mp?@33?p?33@0<?33?@Mp?33?33?33@Mp@33@33?@0@33?33??@33?33@33@33??@Mp@Mp@
@Mp@
@@G@@@{@33@33@A@33@@QA
RAA{@A
R@A@33@QA
R@@@G@Mp@0@33@Mp@0??@33@33?@Mp@Mp@jH@0@0@Mp@33@jH@
@\@0@Mp@jH@jH@Mp@0@jH@0@
@
@
@
@G@33@\@0@Mp@Mp@jH@33@0@jH@33@jH?@Mp@G@jH@G@@{@{@{@@33@@33@{@{A
R@33@QA6ffAGA A6ffADALQA=ASALQADAZHA6ffADASA6ffA=A=A'
A AAGA
RAAA
RA
R@@33@33@@G@\@\@\@jH@jH@Mp@
@\@@jH@\@\@
@G@G@{@G@{@\@
@G@jH@Mp@@\@\@jH?p?@33@0@0@0@33@0??33@jH@0@Mp?@jH@Mp@
@jH@33@jH@jH@Mp@
@
@\@\@{@{@@{@{@Q@@Q@A{A
RA'
AGA/33A{A{A'
AGA{A6ffA=A'
A/33A AGA'
@@{@@@33@33@G@@@{@\@
@33A@G@@@@Q@Q@A@Q@Q@@33@{@@@G@@@\@@33@Q@Q@{@\@\@jH@
@
@
@Mp@0@0@Mp@Mp@Mp@@jH@G@\@
@\@\@
@
@G@
@\@@@@{@AAAGA{A/33A=ALQASAipADALQAZHAZHALQAipAx  AipA6ffA6ffA{A=@Q@Q@@
@G@Mp@Mp@33??@Mp@
@@@\@jH@\@33@@{@33@33@33@@{@33@@Q@Q@{@@G@A{@@G@G@\@G@jH@33@jH@\@\@jH?@Mp@33@0?33@0@jH@jH@G@jH@0@33@33@33@Mp@\@Mp@jH@
@Mp@
@jH@jH@jH@\@@@{@@@AA{A{A'
A A{A{@@\A
RA
RA A@33@@@Q@@A@@33@{@33@G@0@jH@G@\@\@@
@@jH@\@jH@
@G@G@\@@
@@G@{@33@33A@@A
R@@@{@{@{@G@@@\@{@@{@{@@@@@{@@@@@@@\@@@@@@33@@@Q@33@{@@@@AAGA'
AGA/33A'
A'
A=A/33A6ffA/33A=A6ffA/33A'
A/33A{AG@QAA@Q@Q@Q@Q@Q@33@@@Q@33@@@@33@@33@@Q@Q@QA@QAG@Q@QAA
RA
RA
R@A@Q@@@@Q@@@Q@@@@Q@@A@{@@@Q@33@@@{@33@@@Q@@@@@@QA@A
RAA
R@QAA{A
RAGA'
A/33AGA{AGAAA{A{AA@33AAA
RA
RA
RA
RAAGA
RA A
RA
R@@QAA
RAAAGA{A@33A
RAGA{A'
AGA AGAGA{A{AA@QA{A
RA{A'
A
RA{A{AA
RA{@Q@Q@33A@@Q@Q@QA{@QA{@QAA{@Q@AGA
R@QAA{AAA
RAA
RA
RA
RAAA
RA
RA{@A
R@QAAA
RA{A A A
R@Q@QAA
RA
RAGA
RAGA{@QA
RA{A{@QAA
RA@QAGAGAA
RA{A{A{AGAGAGAGA'
A
RAGA{A
RA A
RAAGA{A
RA
RA
RA{A{A{A
RAAA AA{AGAAA
RA@QA@AA
RA
RAA{A
RA AA
RAAA{A
RA{AGA'
AAGA{AGA
RA{A'
A AGA A{AGA AGA
RA A A{A A{A
RA{A'
A{A'
A{A{AGA
RA{@QAA{AGA{AGA{AGA{A
RAA
RA'
A'
AGA/33A{A{AGAGA'
AGA A'
AGA A A{A{A{A'
A{A AGA'
A'
AGA{A'
AGA A A{A{AGA
RAGA{AGA'
A{A
RA{AGA'
A A{A A AGA/33A'
A/33AGA AGA A'
A/33A/33A6ffA/33A'
A6ffA'
A{A AGA
RAA
RAA
RA{AGA{A{AG@QAGAGAGA'
A{A'
A{A A'
A A{A A{A6ffA/33A'
A/33AGA=AGA'
A'
AGA{AGA'
A6ffAGA/33A'
A'
A/33AGA
RA{A6ffA{A{A
RA A/33A{A AGA{A A
RAGAG@QA'
A
RA{A A A{A'
AGA A'
A'
A'
AGA'
A A/33A/33A AGA6ffA'
A AGA'
A AGAGAGA A'
AA{A
RAGAA/33A AGA'
AA{A A{A
RA{AGA/33A{A'
A6ffAGA'
AGA/33A'
A'
A'
A{A6ffA=ADA6ffA'
AGAGA'
A'
A/33A'
A'
A6ffA/33A/33AGA A A'
AGA A A6ffA'
A/33A AGA A/33A{A'
A6ffA/33A A=A A6ffA'
AGA'
A A/33AGAGA/33A A=ADA6ffA6ffA'
A/33A/33A'
A A/33A6ffA'
A A/33A6ffADA=A/33A/33A'
ASALQASAZHASAb{ALQASALQA/33A/33A=A6ffALQA6ffA/33A{A/33ALQA/33A6ffALQA/33ADA6ffAZHAipAipA6ffAZHADA=A=ASA/33ADADA'
A'
A/33A=A6ffA=A'
A=A6ffA=ADA/33A6ffADA=A A/33A/33A6ffA=A{A/33A A A'
A/33A{A6ffA/33A/33A/33A'
A A A A/33A6ffA A/33A'
A'
AGA AGAZHA=ASA'
ADA/33A6ffA=ADASA=A6ffA=A'
A/33A'
@33A6ffA'
A A{A=A6ffA6ffA/33ADA=AGAGAGA6ffAGAGA AGA'
AGA A'
A A A{A'
A'
A{A{AGA'
A{A/33A A/33@AGAGAGA{A{AGA
RA{AAG@QA{AA
RAA@Q@QA@A@QA
R@33@@@33@33@33@@@@A@33@33@{@@{@@33@AA
R@@33@@Q@@@A A
R@@Q@@33@{@33@Q@33@33@@@Q@33@@Q@@@33@QA@Q@@33@@@@Q@33@
@G@33@@33@@{@@33@G@{@@{@@@{@@\@
@G@@@{@G@{@@@G@{@G@G@@G@G@@G@G@\@@G@G@\@G@
@\@
@\@@\@G@jH@0@{@{@@
@jH@G@jH@
@jH@{@
@\@G@\@G@G@@@G@@G@jH@
@{@\@G@@\@jH@
@\@\@
@G@
@
@jH@jH@\@@\@\@\@G@@\@Mp@jH@
@
@jH@
@
@
@0@{@Mp@Mp@
@
@jH@
@jH@Mp@0@0@Mp@jH@0@jH@0@Mp@0@33@Mp?@0?33@Mp@0?@33@33@33@33@33@33@0@33@33@0@Mp@33??33?@jH@33?33?33@33@0?p@33?33?33@33?33@0??@33@0@33@33@0??@0@33??@33?@33@33?@33@33?@33?>?p?33?33?33?33>?p?33?p??33?p?33?>?p?33?33@33?33?33??p?p?33?33?33?33>?33??p?33>@33@33?33?33?33?p>?p?33@33?33@33?@33??33?33?@33@0?@0@jH@33?@33?@0@Mp@33?@0??33?>@33?p?p?33?@33?33?33@0@33@33>?p???????33@33@33@33@33?33?p@33?33??33?p@33>?33????33@33????33?p@33?p?33@33@0??33?????33??33@33@33?33?33??33???33???33??p@33?33???33?@33?33?33?@33??p@33?33?p??33?33@33@33?33?33@33>?33?p?p?33@0<?33>?33??p??33?p?p?>?33?p???33?33@33??33?p?33@33?p?33@33?33?p??p?33?33?33??@33?p?33?p?33?p?33?33?p?33?33?33@33?33?p?33?p??33>???p?33??????33?p@33@0>?33?p?33??33?p??33?33?p@33?p?p>>??33?p?p??33?33>??33?33?p?33?p?p??p?33?p@33?p?p??33?p??33?33?33??33@33?p?33?33?p?33?33???@Mp<?33?33???33?p?33>??33??p??33?p??p?33?p?p>?33??33?p?33>?p?33?p?p>?p?p?33?33?33?33>??p?p<?p>><?p>?33?p?p?p??33?33<??33?33?33??@33?33?p<@33?33??33@33?p?33?>>?p?33?p?33><?p?33<>??p?p?p<?p>?p?33?p<?p?p>?p?p>?33
=?33><?p?33?p?p?p>
=><>>>
=
=?p>
=?p    <<>>><    <>><<>>?p>>
=    >
=
=<<<<><?p?>    <<
=    
=><<?p>
=<<        <    ><
==q<
=<
=>><<
=<    <>
=<>
=<<        
=    =q=q=q<>
=<<?p׾
=<    >>>
=
=><
=<
=<
=
=
=    <>
=>><?p׾
=
=<>    
=<<@33    <?p>    ?33    <?p><?p>
=        <<><><>>    
=>>>><<<<>><>>
=<>>
=<<    
=
=<<<<
=
=<<>><<<?p׾
=    >><?p    >?p>><
=><>?p<><    <<
=<<>
=
=<
=>    ?p?p?33
=<    
=
=<
=>    <<<<=q
=<?p<<<    <
=?p׾
=
=<    >>    >>
=<
=<>?p>?p<><<>>?p<>    ?p<>    >
=
==q
=<    >
=<<
=><?p׾
=<<<
==q<>
=    <<>
=    <
=<?p>>?p><>
=<?p>><<?p<<?p׾
=<<<>?33<>?p>?p><<?p?33?33?p?p>
=?p>>?33<<?p>>>>><>>    ?33?p>>>>
=
=>>        ?p?p>>><<<><<<<
=
=
=
=>>>
=
=<>
=    >
=
=
=?p׾
=><>
=<<<
=
=><<<>
=
=<
=>
=?p׾
=
=
=<?p><    
=    >
=
=<
=
==q        
=<
=<    
==q>=q>=q=q
=<<    
=
=<
=<
=
==q    =q<<
=<    <
=    <>
=<<
=<<>>
=
=<=q    <><
=<
=<
=<
=    
=><<    
=
=
=
=
=<<<
=<=q
=
=
=
=    
=<    <
==q<
=
=
=    
=
=
=<
=>    <
=<=q
==q<        
=    <        <
=<
=>
=    <<=q    
=>    
=<
=
=
=
=    
=    =q<    
==q<        
=
=
=    
=    
=    
=>            
==q<
=
=
==q
==q        =q
=    
=
=<?p    
=
=    <
=
=<
=<
=
=
=
=><
=
=>
=
=<
=
=><
=    
=>>
=
=
=><>    =q?p    
==q    
=    >
=
=<>
=        
==q
=<>?p׾
=    
=
=><<>    
=<<<<><    >
=    ?p<<<<?p<    >>
=<>
=>    <<<    <><
=<
=
=<>    
=<<<
=<<><    <
=>>
=    
=
=<<>
=    <        <<<
=<
=
=
=>
=
=
=
=
=
=>
=
=<><
=
=
=<    =q    <
==q<
=
=<<
=
=<    <    <    
=<<
=><    >
=<<<
=>
=>><
=>
=?33?p?p?p?p>>?33?p?p<?p?p?33>?p?p?p>>
=?33?p?p?33?33?33?p?33?p?p?33>?p>?p?p?33<?p?33>?p>?p?33>?@33?p>?p??33?>?p?33?33>?p?33?p?p?p>?p?33?33?33>?p?p?p׾
=??33?33?;
=?p?33?p?p?p?33?p?p<?p>?33>?p?33?p?p>?p<<?33?33>?p<>>><?p?p?p>?p?p>?33??p>?33<?33<>>?p>>    ?p?p?33>><?p?p<?p?33>?p?p?33
=??33?p?33?p?33?33>?33@33?33?33??p?p?<>?>??33?p?p?p?p>@33?p?p?p?33>>?p?33?p><>?33
=<<<<?33?p׾
=><?p?p?33?33?33>?p>?p>><><
=>?p<?p<?33>>>?p?p>?33?33?33?33?p?p?33?p><?p?p?p?33??33?33?p>?p?33?33?p<>?p?p?p@33?p>?p?33?p?33?p?33?33?p?p?33>>?33<
=<>?p?p?33<<?33?p׾
=?p>>??p<?@33?33?p??33?p?33?33?p?33@33?33?33?33>??33??33?33>?p?p?p?33?>?;
=?p?p>?33?p??p>>><?p?p?33?33<@33?33?33?p?p>?p?33?p?33??p?33?33>?p?33?33?33?p?p??33>?p>?p>?p>><?33<?33<>>?p?p<?33<?p>>>?p?33>>>><<>?p><?p<???33>?p?33?33@33?33?33?p?p?33?33>?33?33?33?p?33??33?p?>>???33@33?33???33?33?33?p??33@33@33?33>>?33?p?p>?33?33@33>?p?33?p??p׾
=?33<?33??p??p?33>>?p?p?p<?p><?33?p?33?p<?p?33?33?p?p?p?>>?33>?33>?33?p?33?33?33@33?33<??p?33?33?33?p?p?33??33?33?@0?p?33?p?33?<>?p?33?33?33?33?p?p?p?33?33?33?p?p?33<>>>?p?p?33>?33?33??p<?p>??>?p><?p?p?p??33?p>?33?33?33?33?p?33?33@33?33?33?33?33????p?33?33@33?p??33?p?p?33?p?p@33??p?33?33?p>?p?p>>?p<?33?33?p?33>>?p><>
=<?33<??p?33?p?p?p?p?p?p>?p?;
=>>>?p<>?p<><<><><>><><
=>><?p?33?p?33?33?p????p??33??33??33?33?33?33??p@33????33??p?33?p?p???33?33?p@33?33??p?33@33?33?p?33?33??p??p@33??@33@0@33?33?33?33>??p?33@33?p??@0??p@33??p@33@33@33????@33@33???@33@0@0??@33@0@0@Mp@jH@0@0?33@Mp@33?@0@33@Mp?33@0@33@jH?33@33@jH@jH@33@Mp@Mp@33@
@Mp@Mp@Mp@jH@0@Mp@Mp@0@jH@33@jH@Mp@jH@jH@0@33@0@Mp@Mp@0@Mp@Mp@
@Mp@0@0@jH@Mp@Mp@jH@jH@Mp@Mp@33@Mp@Mp@0@jH@jH@Mp@jH?@jH@jH@Mp@0@Mp@33@Mp@Mp@0@0@jH@Mp@jH@0??@33@0@0@Mp@Mp@33?@0@0@Mp@Mp@0@Mp@0@0@0@33@Mp@Mp@0@Mp@Mp@33@0@Mp?@Mp@33@33@33@33@33?@Mp@33?p?33@33?33?@33?33@33??@33??33@0@33??p@33?33???@33??@33?33@33?33??33?>?33??33??33?33??p??33?p?33?33??33?p@33?p??p?33??33?p??33@33@0@Mp@0@33?p@0@jH@jH@Mp@\@
@0@0@33@0@Mp@0@33@Mp@
@Mp@jH@Mp@0@0@Mp@33@Mp@Mp@0@jH@0@33@jH@0@33@0@33@Mp@0@Mp@0@jH@jH@jH@Mp@Mp@0@Mp@jH@jH@
@\@G@\@Mp@Mp@Mp@Mp@jH@0@0@jH@33@Mp@
@0?@jH@jH@\@jH@Mp@Mp@jH@jH@jH@0@jH@jH@jH@0@Mp@jH@Mp@Mp@Mp@33@0@0@0@0@jH@
@\@jH@Mp@jH@jH@
@
@G@
@33@0@Mp@0@
@
@jH@jH@Mp@G@
@Mp@jH@jH@
@jH@\@G@jH@\@
@\@0@
@jH@Mp@Mp@
@
@Mp@Mp@jH@\@jH@
@\@\@jH@
@jH@
@
@Mp@
@33@jH@Mp@0@jH@
@jH@jH@\@@
@\@
@\@
@\@
@\@jH@G@G@
@\@jH@jH@\@Mp@
@\@jH@
@Mp@jH@jH@
@G@
@
@jH@@
@@@G@G@\@\@\@@
@G@\@\@
@G@\@G@\@
@\@G@
@\@@\@@jH@\@
@Mp@jH@\@
@
@\@jH@G@
@\@\@
@G@Mp@jH@
@G@
@\@G@\@jH@jH@Mp@G@
@Mp@G@
@
@\@jH@jH@@\@{@G@G@\@\@G@G@
@
@@\@\@G@0@Mp@jH@
@
@jH@
@jH@
@jH@
@jH@Mp@jH@
@jH@jH@Mp@jH@jH@jH@\@jH@
@jH@Mp@
@
@\@G@G@\@\@G@\@
@
@
@
@\@G@G@G@
@
@
@jH@G@\@jH@\@\@
@\@Mp@jH@jH@
@jH@Mp@G@jH@
@jH@G@
@jH@
@G@
@
@
@jH@G@\@\@\@@\@jH@\@
@
@jH@jH@jH@G@G@G@\@\@
@\@G@G@\@jH@
@
@\@
@G@jH@
@
@G@
@
@jH@
@\@\@\@jH@Mp@@\@@\@G@\@\@
@G@@
@
@jH@Mp@
@
@
@jH@Mp@\@jH@jH@G@
@jH@
@jH@jH@jH@33@
@jH@0@Mp@\@jH@jH@jH@Mp@jH@\@jH@jH@\@0@\@Mp@jH@\@\@
@
@
@
@
@
@
@Mp@
@0@jH@Mp@jH@jH@jH@0@Mp@jH@jH@
@\@\@G@\@G@\@
@
@jH@jH@Mp@\@jH@Mp@\@\@Mp@\@
@
@\@jH@Mp@\@Mp@jH@jH@Mp@jH@G@\@G@{@G@jH@jH@G@jH@
@
@jH@\@\@\@\@G@jH@jH@G@jH@jH@
@
@
@
@
@
@\@jH@
@@\@G@jH@Mp@G@\@G@jH@\@\@
@
@
@
@\@\@\@jH@\@jH@Mp@\@
@jH@@@\@G@G@{@@G@G@G@\@G@\@G@G@@\@
@\@\@
@\@G@G@\@\@\@G@@@G@{@{@G@@G@
@G@G@\@jH@\@{@G@@@@@jH@G@
@\@\@jH@0@jH@\@G@\@jH@jH@Mp@
@@jH@\@jH@G@0@\@G@\@
@G@\@jH@\@G@\@\@\@G@@\@@G@@@{@{@@G@
@
@
@\@\@G@G@\@G@\@G@G@G@
@
@@jH@\@G@@
@G@\@\@G@\@\@G@@G@\@
@\@G@\@\@@G@
@
@
@\@
@G@
@\@@\@G@\@G@G@@@@@{@@G@@{@@@G@@G@G@@@@@@{@@@
@@G@@G@@@{@@G@@@G@{@{@{@{@@G@{@@@{@@@@{@{@@33@@G@@{@@@G@G@{@{@G@{@{@@@@\@33@{@{@{@{@{@{@{@33@@{@33@@{@{@Q@{@Q@@{@G@33@33@{@33@@33@@@33@33@@@{@33@33@33@{@A@@33@33@@@33@33@@@@@@@@@@33@@@@@{@@33@33@33@@33@@@@@Q@@{@{@@{@@{@33@{@@33@@{@@{@@@@@33@@@Q@@@@{@@@@{@{@@@@Q@33@33@@33@{@Q@33@{@{@{@@@@@@A@Q@@@33@@@Q@@@@33AGA@QA@Q@@{@@@G@{@@{@@33@{@@@@33@{A{@@33@@{@@@@33@33@33@{@A@33@@33@@{@33@@@{@33@@@@@{@@Q@QA@Q@@33@QA{A{A
RA@QAA@33@33@33@33@@@A
R@@@A@{@@Q@QA
RA@Q@33@33@Q@Q@Q@33@Q@@@33@@33@@@33@@@Q@@QA
RA
R@33A
R@QA@@33A{@33@33@@33@@{@33@{@@@{@33@@{@{@@{@{@33@33@@33@{@33@@33@@Q@33@@@{@33@{@33@33@@33@G@@@{@@@@@@33@{@@Q@33@33@@@@{@{@@@@@@@A@Q@33@A@{@@@@@A
RA
RA
RA@@@33@33@@@Q@@@A@@33@@33@Q@{@@@@{@G@{@@{@{@Q@@@Q@Q@@@33@@@@@Q@Q@QA{A6ffA=@QAGA/33AGA{AG@Q@@AA{AGAGA{A@Q@QA
RAA
R@QA
R@33@A@@Q@@@Q@A{@@AA
RA{A @QA/33AGA A'
A AGA{A{A{A{A{@Q@QA{A/33A{AGA{A AA{AGAAGA@QAAAA
RA{AA{@QA{@@QAAA A'
AA{A{AGAGA{AGAGA'
A@A@Q@Q@A @QAAA
RA AA{A{AGA=A'
AGA A
RA A{AAGA/33@QA/33A{A
RA/33A
RA A/33A'
A
RA
RA'
AGAGAGA AGA A=A A'
A AGAAGA6ffA A
RA{A{A
RA{AA{A
RAGA
RA'
A
RAGA{A@QAA'
A{A'
A{A A/33A{A A
RA A{A A
RA
RA
RAGA
RA
RAA A
RAAA
RA A A A AGA/33A A{A{AGAGA A A A
RAA AA A A
RAGA A{A{A
RA AGA'
AA{A{@33@QA{@@Q@@@Q@QA
RA
RAGA6ffA6ffA/33A A A{@A
RAA{A
RA@Q@@A@Q@QAGA
RA@@QA
R@33A@@33@A@Q@Q@Q@Q@@33@AA A'
A
RAA{A@Q@Q@A
RA
RA@@Q@@33@Q@Q@A
RA@@Q@QA
R@@QAA
RAA
R@33A@@AA@@A
RAA A@33@33A
RAGAGA
R@33@A
R@Q@@@Q@QA@@@@@Q@@@33@Q@@33@{@A/33A/33A A
RA{AGAGA{A/33A A/33A6ffALQA/33A=A6ffA/33A/33A A/33A'
AGASA6ffADAZHA=A6ffAGAGA{A
RA A'
AGAGA{A6ffA A A{A A{AGAGAGAA A A A A6ffA6ffA=AGA AGAGA A{AGA
RA A6ffA{AAGA
RA
RA A
RA
RA
R@QA{AGA'
A
RA6ffA
RA
R@@QA
RAGA
R@QAA
RA@QAA@33@Q@QAAG@QA
RA @33AGAA
RA{A/33A
RAA
RA{AGAGAA{A A AG@QAA{A@QA{A{AGAGA/33A A
RA{A{AA
R@A
R@Q@QA
RA
RAAA{@A
RA{A
RAA{A6ffAGA{AGA{AA @QAA
R@A
R@Q@QAA
RA
RAA{A'
A{A A{AA
RA{AA{A{A{A
RA{A{A{A{A{AGAAGA A6ffA/33A/33A A6ffA6ffA A/33A/33A'
A/33A6ffA'
A{A
RAGAGA AGAGA'
A
RA A{A A{A{A A'
A AGA'
A A{A{A A A/33A/33AGADA/33A6ffA
RAGA
RA{A{A
RAGA{AGA{A/33A'
A'
A AGA{A{A'
A A/33A=A'
A/33A6ffA=A'
A/33AGA A{A AGA
RA{A{A{A{A=AGA{B
HBB\)BBBGBpB\BB(BBGB\)BRBRB(BB  BGBB\B(B33B {B\)BRBBGB{BBBRBRBGBBBGB
  B
(B(BHB\)B	BRB{BpBBHBHBpBpBB  BBA
=AQA
=ApB ApB BQAB=qBRB(B BHBpBB\)BAB B(ApB BRBB(BB	  B
B
HBRBBpBBBB\)BB\)B\)B\BpBRBpBB\BB\BBB B!\)B#  B\B$
B%  B#RB!\B"{B  B{B!33B(B(B  BBB
{B
=qBRB{B	  BAA
=A33A(AzAHAAQA(AQB	HB
=qBB=qB
\)BRB
pB{BBHB(B=qB\)BQA
=AQA33A(AzBA33B(B
B
BB
{BBGB
  B=qB  B(B
B
B
B(B  B
B	  B	HB
B	RB	HB
B\)B{BBHB
  BpBpB{B\)BB\)BBpB\)BpB(BB
(<5p.=qo
D~D:D9D8ٚD9kD0QD:qHD:qHD
AD5=D5{D5{CCԹD?\D ffGHDB=qCBBQBCm{D6Ὺ=q
=
=D:
=CK޸C)D:HBD:fD:D4D:T{D8 D.ED:(D:fD:fD9RD:D:f(D9CBCD#)<D9CD9(D/fD8*D;  C\)D9C=qD8 D:D:)(D:fD:(D91HD9kD:D:fD:qHD:=D:fD9{D63D:fD:fD:fD:qHD:)C@ D9D:)D8
C(D:)D8 D9{@D9 C
=D;3D9D:CD:D:D:fD3D9 D:fD:=B%D:fD:D:fD:D9 D8 D:fD:7D:qH(D8 D2fD8D:fD:)D:7D:fD:fD:T{D9ND:fD91HD:fD:D
+D9kD/.D:fD:D:D:fD9D:D9D:D7|)D.=D8D:C CD8 D:fD9D:D:fD:D9 D8
D:fD:)D:D8eD:D9D9{D:D8*D9D;3D:D9D:fD9RD9D9RD9D8HRD8D9D6D:fD:qHD9D9kD9kD9D9RD91HD9D:fD:D9kD9ND:fD8D:fD:fD9D:)D:fD:fD:fD9kD:=D8
D9D:=D:D:D7BD:)D9RD9RD9 D9RD9D8
D:D9D:D:fD7|)D:D:fD:D9 D:fD:=D:D:7D:fD9D:fD:fD:fD9ND:)D:fD9ND:qHD:fD:fD8D:qHD8D:qHD9RD:D8D9D:D8
D:D:D:fD:D:D9{D:D9RD:fD:7D9D:T{D:fD:7D9D:D:)D:fD6<)D8D:D9D:T{D9D9 D:qHD9RD:fD:fD:T{D9D:qHD9D:=D9RD:fD9 D:fD9D:7D:D:D8*D:D:D8ٚD:7D:D7D8D56fD9D:D:fD:D:D9RD9{D:=D8D:D:D:D9D9ND8
D:D:D:7D9D9kD6D:)D8HRD:)D:fD;3D:fD:D9{D;3D:D91HD:T{D:fD:D9 D8
D9D:qHD9D9{D:D:fD:D:D:fD:D9ND:fD9 D:D:fD:D8eD:D;3D91HD:D:D8D:=D8ٚD5{D91HD:T{D7D:fD:fD9D8ٚD:7D9D:D9D91HD8HRD91HD:)D8D:fD:D9ND:fD:)D:D:fD:D9 D:D8*D9 D:qHD:D:D9 D9D:D9{D:D:fD:fD:D:7D9 D8D:7D9D:qHD8 D8D:D9D9kD9 D:fD:D6D8*D:D:D9{D:D63D:fD:fD:D:D:D9RD:)D8D9D8HRD8D:qHD9kD:T{D:D9ND9kD9{D:D:D:7D:T{D:D:)D9D:D:D:fD:fD:D:fD9D:7D:7D9D9{D8D:fD91HD:D:)D:7D:fD:D8HRD:D:)D9 D9D9{D9kD9 D:D:D:fD9ND8D8 D:T{D7|)D9D:7D:D:D8D:)D:qHD9D:D:fD:=D9RD8eD:fD9D:D:=D:fD8D:D:D:fD:qHD:)D:D:D:D:)D:D:T{D91HD9D:D:D:D:fD:D8*D:fD:D:D;3D:D:fD:D7_\D9{D:)D:T{D8D:)D:T{D:fD:fD:D:D3HD:D:fD:D8ٚD:D:7D:fD:fD9RD:qHD:D9D8ٚD9D9D9ND9kD:T{D:fD:D9kD9ND:7D9D:D9D:D:D:qHD:fD:T{D:fD:D:T{D:fD:fD:D:)D:D:fD9D9RD:T{D:D9D:D9RD:7D:D:D:qHD9kD:D:T{D:7D:7D9D8*D8 D:)D:D8ٚD:=D:7D9 D9D9ND:D:D9kD9RD9D:D:D:qHD:qHD:=D:7D:D:)D;3D9kD:D:D:)D9D:D:fD:D:qHD:qHD:D9ND:D:fD:fD:qHD:)D:D:)D:D9D:D:7D8D8D:T{D:=D9D9ND:D:D:D9D7D:D:fD:)D:)D:D:fD:7D9kD:fD9kD8ٚD:D9kD:D8ٚD8D:D9RD91HD8
D9RD:)D9ND91HD:=D8eD9D8
D9kD:D:D8D:D:=D9 D:T{D8D:qHD9{D:D9RD8 D:D8*D9D9D:D:fD:D8ٚD9kD7D8*D:D:7D8D9{D:D8ٚD9{D8 D9kD:7D:D9kD:D56fD8D8
D8D:fD9D:fD9D9kD9D9ND8eD8
D8HRD:fD:D:fD91HD8
D:D9 D9ND7fD8ٚD8 D8D9D8D:T{D:D:D9 D:qHD:7D9D9 D9 D:7D9RD:T{D8D:D9 D:D9D:)D:D:=D:fD:=D:fD8
D:D:D9RD:D7D:D:fD;3D:D:7D9D8 D8ٚD:=D8HRD3G
D7%D:D:T{D9 D8ٚD9{D8D9RD7|)D9D:)D9D9D9{D8D:=D:D6D9D:fD8ٚD:fD:=D9ND:D:7D9D:D:fD9kD:=D:fD:D9kD:D:D9kD9D:qHD8D:D:fD:qHD:qHD9D:7D:fD8D91HD:7D:fD:D8D:fD:D:fD91HD:qHD:D:fD:D:D8
D9 D9kD9 D:D:D9{D9{D:fD:D:T{D:fD:fD:fD:fD:D9 D:D:D8 D:D:D:D:D9 D8D:D9RD8ٚD:qHD:D:D:D:fD:fD9ND:D:D:T{D:fD9D9 D8D9ND8D:fD:qHD:D9 D8D:T{D9D:T{D9D9{D:)D9 D9D9ND:fD9 D8
D8
D:fD8
D:D:D8D8HRD8*D9D7BD:D:7D:qHD:D:D:D9D8 D8D:fD:D8D:D9D9D9kD9 D:fD9D8 D9{D5D8HRD:fD:qHD:fD8
D:7D:D8*D:fD:D:7D7D:D:fD9ND8ٚD:)D:D:D8D9RD6XD:qHD:=D8*D:fD:fD9D9D:D9D:fD;3D:D8D9kD:fD:D9RD:fD9 D8D:qHD7D:D9D:fD:=D9D:)D8HRD9kD9D:7D9kD9D:D:D:D9D9 D:)D:D9D:qHD:)D91HD:)D:D:fD:D:D91HD9D:fD:7D9 D:D9D:fD8ٚD:D;3D:D9D:fD9 D:)D9D:)D9 D:fD9ND:fD:fD7D9ND9kD9ND9 D9ND:)D8*D:=D:7D:D8D:D8ٚD:fD:D9RD:D:D:fD9kD8D:)D:)D9{D9kD9 D:fD9 D9D:D8*D:qHD:fD:D:D9D8eD9D91HD8*D:fD:qHD:fD:)D91HD:T{D9kD9D9{D:D:=D:D:7D9 D:D:D:D:=D9D:fD9D:D:D:qHD8D:D:T{D:D9kD9RD:7D9kD:)D8 D:7D:D9kD9D:D:D9D:D:qHD9RD9RD9kD:fD:7D:)D:D:fD91HD8
D9 D9{D:fD:D8eD:D91HD:fD:fD:D:D:=D6vfD:D:qHD:fD:=D:fD:fD:D:D9D:D:7D9ND8D:T{D:fD:D:D:fD:)D91HD:fD;3D9D;3D9RD:D:)D:fD8D9ND:fD9RD9D:D9 D8 D9 D:D:D:qHD:qHD:fD:)D:fD:=D:D:fD:D8ٚD:D:7D9D:D8D:qHD:T{D:D9D:fD9kD8
D:D:=D;3D:qHD:D91HD:fD9RD:D:=D:D9ND8ٚD:D9D:D:D9RD:D:D9D91HD9D9D:D9D:D:D8HRD:T{D:fD9 D:fD:fD:fD:D:D:fD:D91HD9RD9kD:T{D:)D8 D6D9 D:D:D:fD8D9D:)D9D:fD:fD:)D9kD8 D:=D:)D:fD9ND:fD:fD9kD:7D:fD:qHD9D7D9{D:D:D8ٚD8D8eD8D8ٚD9RD:D:D:T{D9RD:D9kD:fD9D:D9D:D:D:fD9 D:fD9D9ND8 D:fD:D6D:fD;3D:D9ND9RD9 D9RD8eD:D:D7|)D8
D:D:fD:7D8ٚD6D:T{D9 D9ND:T{D9{D:=D8eD:D:fD8
D9D:D:)D:T{D:qHD91HD:T{D8D:fD:fD8D:D9ND;3D:D:fD9D:)D9RD:T{D7_\D8 D:)D9D:=D6\D9RD8D:=D9D9D:D:D:)D:fD:D:7D9 D:D9{D7D9D:D:)D91HD:D9D9D:fD:D8
D:D:D:D;3D8
D8
D:qHD;3D:fD8D;3D8ٚD:D9RD:D8D9D8ٚD9D:D8
D:D:D:D:D:qHD:)D9D:T{D8
D:D9D8
D9D:D:D:D9D6vfD9RD8ٚD8HRD9{D:T{D8HRD9ND9kD8
D:fD:D:)D:D:D:D8D9ND:D:=D:qHD:D:)D:qHD9kD9 D:=D8eD:7D:fD9RD9{D:)D:fD:D9ND:D9 D:fD:)D:qHD9RD:=D:fD8D9ND:D9D:fD9D9RD7D:fD:D:D8eD9 D:fD:fD:fD:fD:=D:D9RD:fD9ND9ND9D9D:T{D9D:7D8*D8D9RD:D8D:fD:)D:=D:D9D;3D9 D:D:T{D;3D9RD:qHD8 D8eD9D:D:7D:D7fD:D:=D:fD9RD:fD9 D:)D:D:D:D9D:)D:)D8*D8 D9ND9 D:D7D:D:fD8 D:fD:)D8eD:D9D8 D:D:D:)D9ND9ND9D8 D:D9kD8ٚD6D:fD8D:D:D8 D9RD9D:D9 D7_\D:D:D:7D8ٚD:D9 D9 D9D:qHD:7D:D:D7D:qHD:qHD8D8D:fD9RD:D9kD8D9RD8D:D:)D9D:D9RD8D8D:D:qHD:fD9kD9D8D7_\D9D:D8ٚD;3D:7D:fD:D:D8D:D:D:fD9RD:D:D:)D8ٚD91HD:T{D:fD:D:=D:D9kD:D8
D:7D:T{D9D:fD:qHD9{D:fD8 D:fD7|)D8ٚD:D:D:D:D:D8ٚD:fD9 D:T{D:fD:fD8D5{D6<)D8D:T{D:fD:qHD9kD8ٚD:D6<)D:=D7D7%D9D:D:)D:D9 D9RD:fD9kD6vfD:fD:D8*D:D:D8D7D:7D6vfD;3D:7D:T{D:fD8D8D:)D:D8
D:D6vfD:7D8eD:)D9D:D:7D:fD8
D9RD:fD:fD:D:)D:)D9D:fD8eD:fD9D8 D:=D8D:fD9 D:fD:fD:D:D:T{D:D9D:D:T{D7%D9D91HD8D:D7fD:T{D:D:fD:=D9ND:D8D9kD:fD:=D:D9D:D8ٚD8ٚD8eD:qHD8 D8D:D9RD9 D5qD;3D9D:D9RD7D9kD9 D:D8
D:D:D7_\D:D:fD:D:D:T{D9kD:)D9D9D9D9RD:)D9kD;3D9D:D:D63D;3D91HD9RD91HD9D9RD:D9D8ٚD7D:=D:D9D9RD8 D7D:D:D:D:fD:D:fD7_\D:fD:D9D:fD:fD8eD:)D9{D9 D:D:qHD9D9D:D9D9ND9ND9D:)D:T{D:fD:D9 D9D91HD8ٚD:D63D9D:D:fD:fD9D:T{D:D9D:D:D9D:D:fD:)D9kD9D:D7BD9D:D:7D:D:T{D:fD:fD:qHD:fD9 D9D:fD9kD:)D9ND:D7D:T{D5{D:D9D7D:=D:D:)D8D:)D:D:fD:)D9ND:D:fD:D:fD:D:D:qHD:)D:fD9kD:D:)D:D:T{D9D:fD:D9kD8D8
D:=D:7D:)D8
D9D:)D:D:fD8ٚD:fD:fD9RD:fD9D9{D8
D:D8D91HD;3D:fD:)D9D:D:fD9RD:D9ND:7D6<)D7fD9D9RD8
D:D8*D9D6D:fD:)D9RD:7D9D8 D:fD:T{D:qHD6D:fD:D7BD9D6XD:fD:=D:)D9kD;3D:D9D9RD9D:D:D:D:fD:D8D6vfD7D:D:T{D:)D:T{D9D:)D8D8eD8HRD9D:)D:fD:)D9kD9{D:7D8*D8D8
D8 D:D:T{D8D8D9kD:=D:D:D7D7D7D9D8D:fD8 D91HD9kD:D8D8
D:fD9ND:fD8D:)D4HD:fD:fD:=D8D:)D:qHD:T{D7fD:=D8D9{D8*D:fD9D8ٚD9D7|)D7D9kD7D63D8D7_\D8 D9{D8ٚD5S3D6D8D7BD:)D8D8*D:)D9D:D7|)D8D8ٚD:D6D9RD:D9D8 D:)D7|)D:D8D8
D:D7D8*D7D:T{D8eD8D:=D9D:qHD91HD9ND8
D9D:D9RD9RD8
D:)D7D91HD:T{D:D:fD:)D9D:D9kD8*D:D:qHD:D:D:fD8D:)D:7D:D:)D:D8 D9ND9D:D7D:)D7_\D:7D9kD:D8*D6D:D:fD9 D9ND:T{D9kD9ND:)D:)D:fD9ND8ٚD:D91HD:D9D9D:D:fD9RD9RD:)D:T{D:D8 D:7D9ND9D:fD9D8
D:)D:fD9D:D9kD:D:fD9{D7_\D91HD:7D9D6D:)D9D8*D:fD9{D:fD8D;3D:T{D:fD9 D9D:D9 D9RD91HD:T{D:fD8D:T{D:D:qHD7_\D:fD:D:7D9 D9RD:D:fD:D:fD:fD:D:D9 D7_\D7D9 D:D:)D7D9D9D:fD9 D:qHD8*D9ND:D9RD:T{D9 D:=D7D9kD:fD9{D:D:D:7D:D9 D:D6D:D:D9{D:D8
D8
D:D9D:7D9kD:)D;3D9kD9 D:qHD:qHD:fD:)D9D8*D8ٚD:=D:=D9kD:qHD9D:)D8*D:fD9D:T{D:7D:fD:=D:fD:)D9D:T{D9RD:=D8D8D9RD8 D5qD9kD9kD:)D:)D9 D:=D:fD:fD:D9D:)D9{D9ND:D8D:D:=D8ٚD:D:=D:D:7D9{D9{D:D:D8ٚD:D9{D:fD7fD:fD9 D9D9D:=D:)D:qHD9kD:fD:D:D;3D9RD:D9D:D9RD9D:D:7D:fD9kD:D:fD:fD:fD8D:T{D91HD8*D9kD:T{D:7D:D:)D:D8D8D8D9 D:)D9D:qHD9 D:D:D7_\D:)D:qHD:D:)D8*D63D5D:D9kD:)D8D:)D9D8D:)D:qHD:D:)D9D:D:D9{D:=D9kD9 D:D:7D8
D7D:D:D9 D9kD:D:D8ٚD:D8
D9kD9kD8 D9D:fD9ND9ND:D:fD:qHD:qHD9D:T{D8D:fD:T{D:fD:qHD:D9D:fD:7D:fD:qHD:7D:)D:D7|)D:fD:qHD:D:D9kD9kD9D:D:T{D9kD8HRD8D91HD:qHD8D7D8ٚD:D:D:D:fD:T{D9ND:D8eD:D:)D:fD9kD:fD:fD:D9RD:D:D7%D8D:fD9RD9D:D9D:7D:qHD8
D:fD:D:fD9 D:fD:D9 D:D:D:D:D9 D8
D:)D8HRD:)D7D91HD8 D:7D91HD:D:D:)D9 D:T{D:fD9{D:T{D8D:)D:D9kD;3D9ND9D:fD7D9kD:D9D7D:fD9RD:D9RD:qHD:)D;3D9RD:qHD9RD91HD:D:fD:fD8ٚD8
D:D:D:7D9D;3D9RD:fD:D:fD8HRD:D9D8HRD9kD:D:D8D9{D:7D9D:7D:)D:D9ND:)D:=D9D:qHD:qHD9D:D:D:D:D:)D8 D9 D:D:T{D:D8 D:D9 D:T{D:fD9D:=D:qHD9D8*D:fD9D8
D9kD9D:fD7|)D9 D9D:D:)D:)D:D9D8*D:=D8D9RD:fD8HRD9D:D:D:fD:D8ٚD9D9D:D:fD:fD:fD:fD:D:fD:fD9 D9kD:)D:fD:7D8D:fD:D91HD9D:D9D;3D9D9D9D8D;3D9{D:fD:)D9kD9D:fD8HRD8 D9D:T{D:D9 D9RD:fD:)D:D9 D:D9 D:)D7D:D8*D:D8*D:T{D8 D:qHD8D8 D:)D7fD:fD:D7|)D9RD5D8D:D7D:fD9 D9RD63D9kD:=D9D7D:D:)D91HD:fD:=D9D:fD:D:qHD8HRD9D:D6D:D9ND8ٚD9RD9D:D9D:D7%D:fD9RD:D:D7_\D:fD8D:D7D:=D:D:qHD9{D9D9kD:qHD:fD:D:fD:)D9D:D9kD9kD9D:7D7BD8D:fD:fD:)D:)D7fD:fD8D:7D6D9D^D2fD:fD:D8D:fD9D:=D;3D:7D:D9D:fD9RD9D:D:qHD8*D9D8eD8D:fD:D8 D:D:fD:qHD:fD:D:fD91HD9D8D:D8D:fD9kD:T{D:7D:D:=D8ٚD:fD:fD:D:fD9D9RD:D:fD9D9RD:fD:T{D:)D:qHD;3D:fD:qHD:D:D8HRD:fD:fD9 D8 D8
D9D9D9RD:fD:fD8 D:=D:D9D:D9ND:)D9{D7D9D;3D9 D:fD8D9 D:D:T{D91HD:)D9kD9D8D9D8eD9{D9kD9D8HRD:fD:D9ND:fD9ND9 D:fD:D:fD:fD8ٚD:D:)D:fD:T{D8eD9D91HD9 D:qHD5ǮD9RD:7D9D:qHD:fD9D9D:D8ٚD:fD9D:=D:D91HD91HD8D9RD:fD9kD:fD:=D:7D:fD:fD7D:D:qHD:fD9D:fD:=D:fD:fD:fD9{D:qHD:fD:D9 D9D9ND9kD:D9ND:D9RD7D:D:fD9D9D9D:D:D9RD:7D9ND8*D91HD:D:fD:D9ND8 D91HD:=D:)D:)D:fD9D:=D!D:T{D:D:D:fD:D:D:7D9RD:fD8 D:fD9D:fD:D:qHD8 D:T{D:fD8eD:fD8D:D:fD9{D9D91HD9kD:D7fD9D;3D9 D:fD:qHD:D:fD9 D:D:fD9RD:T{D91HD:fD9D9D9ND:D:fD7D91HD:D:=D:fD9ND9D9kD:fD:D9D9D:7D9RD:D:=D:fD9ND9ND8eD+D03D:D9RD/L)D7|)D3d{D0)D2^D2RD1uD-yD7D9kD2^D3d{D.{D/qD:D1XRD0QD:D3HD+D.bD.ED*{D( D,VfD/fD0o\D+D*D9RD7D03D*D%3D)D{D,)D+D'
D-D* D*D%,)D* D#{DqD&O\D%D(!HD(D)fDRD$D%,)D.D"RD({D#HD)
=D(xRD#<D0D%RD"D&DqD+nD!ND'rD=D"D&D"D))D*\D"RD!D*-qD'D#<DLD#  D!D%D!D \D'rD&DLD)D"D$&fD$&fD%RDD"7
D#HD$=D"qHD"D! D&2D!DDD$&fD$=D(!HD!DD&D$&fD(DXDAD${D&fD#HD#)D|)D! Dp DRD"qHD\)D!DD3D
DD!DfDLDǮDRDfDD#3D!Dt{D)D=DfDFfD!D\D\)D=D *DXD4{DvfDRDҏD D3DO\D!Dt{D=D *DҏD\D!NDDDD
D DD=DHDD.DnD!RDqD"T{D#3DAD)D DDnD=DDvfD{DǮDD ٚD5D|)DfD)D#)DHDǮD fDDDiD!D eD33DfD4{D D
3D
DLD! DD{DDDADRDDqD )D?\D)DDDDD
D3D^DWDp DQHD
 DDcDDcD  DD#3D)D${DDRD)DDEDDyDD8DfDt{Dt{DHD{D{D3D)D *D^D
D^DiDDVfDD^DHDDiDp DfDD"T{D#wD5DDLDfD fD)DXD{D0 D"D=D
DmqD#  DvfDP DDҏDDD"T{D` DO\DqDgDǮDD  DiD{DDHD'
DDDED
DD
D=D)DD\DD]qDDDҏDD$` D#HDD8DDqD!0D{DҏDDD{D8DDmqDnDKDP D!jD%HDRDt{DDHDHDP DDqDD
D \D3Ds3D~D\DqD3DqD)DDKD5D8
DD!RD  DfDQHDfDP D)'D{D  DD?\DRDD  D3D DDDDED	Dz=D"T{DD(RDDfDnDDDD@D=DHD~D"RDD!DD{D=DHDfDФD	Dp D"7
D  D
D!RD{D!0D"D D fDRDDzDD#Z=DfDiDRDDD(RD5DfD4{DFfDhRD)D)D  DUDAD$C3Dl)D{D )DcD'
Dp DvfD\)D{DXDbD
D)DbD&l)DfDD)D
qDHD0 D=DҏDt{DD *D{DD(RDDD5D DRDt{DDDp D)DD8DnDnDDhRD_\D{D)D~D)DD\)D3D@DqD5D\)D=DDWD:=D=D~Ds3DvfDҏDbDfDRD}qD8DYD?\D!D5D DDUDP D!0D!RDD$}qDRD)D
=DfDXRDKCDHD"T{D DDqDDRD\)D@D)D{D)DqDFfD=DfD
ffD>D#wDzDDD{D3DWD=D\DHC!HDHDvfDXDqDDDD D
DD'
DD)DDmqD)D(RD
DD\D DHD DD4{D?\DED"DD"D
SD4{DDHD"D"T{DnDDDҏDd{DDnD,Dt{D
7
DD@DDEDDD,D^DD
qDmqDD.DvfCDDDDt{DDXRDLD"DDDDDzD)D33CD8D?\DLD DDD DGDDD \D)DDP DfD\D
D{DDD>DDDD"DDD
D)DRD
+DDDgDFfDHD_\DDDs3DD*=CDP DDD$DD{D@DD\)D4{D?\D@DhRD{D(RD	D@D{DDKD
DD
DVfDD{D<)D  D
DaHD
D D\DD{DDmqD)DФDbD{D
DD	D
pDHCD	jD{DYDDfDJ=C)D(RDD
D)D@D D#HD.D{DxRDRDyDФD>D
CXRDD3DD{D~DD:=D@ DDDP DDDHDRDDcDcDQHD
qDDDD eDDD3DVfD
DDD'
D QHDVfD	D
D DD
 DD{DLDDVfDD` DO\DDnDhRDDD{D)DD
+DfD\D3DD\)D8RD)DDnDDDФDD! DDDD DJ=D	3DmqD
SDDD{DD
D)D DDDt{D\D>DɚD{DDbD	NDD	DФD"D
pD{DDmqDgD
DD)DDRD
DDD)D.DDɚD{D8DDgD
SDD:=DD\Dw
DED'
Ds3D\)DDFfDLDD=DD DDRD{D.D"T{D D\D
D DDFfD!NDP DS
Ts3U^U^U^TUUU^UVEVEUUVW0W0WW0W0VW0X
W0VEVW0W0W0W0VVVEVEVVW0VVX
VEVEU^U^S=S=T  Ts3TU^U^VEVEUTUU^TTs3TT  T  TT  TU^U^U^U^U^U^U^UW0W0UUW0W0W0WWWWX
W0WW0W0WW0WWVVEVEVW0W0WVEX
WW0W0W0W0VX
WWWW0X
X
X
WXXX
X
X
X
W0WWUUW0TUW0VEVVVVX
WYuX
Y  W0VEVVW0WVWW0VX
Y  WXY  XWXWWWX
XYuXX
XWXXY  YuYuYYYu\0[Z[GBpB
  BGB{B
  BpBGB  BBB\)BB  BB{B {B {B{B\BBGBB(BGBB=qBHB{BBpBBBBBRB{B\)B(BRB pBAAB(A33A\)AzAA33A{A33AمAQAAA\)A홚AQAAzAAzA33AAAzA33A
=A
=A33A
=AA
=AA噚A\)AAAAAHA33AAAAAAHAQB {BRBGBRB=qBHBHB(B
BB(B B BBHB=qBB{B{BBpBB=qBHB=qBBRBHB B(AAHBRA
=BB=qB BBBB(BBB{BRB
(BAAAQA\)AAAA{A33A\)A\)A33AzA
=A陚AQAAA(AA33AAAA
=AAQB =qB(B(BQB{B=qBB=qBRBRBBBB(BBBHBHB{BHB=qB(B=qB	(B(BpB
=qB(BRBB	  BB  B{B\)BHB\)BB(B(B(B(B{B=qB\)B =qAAA
=AA
=A\)AHAHAA{A\)A33A{AAHAHA\)AA{AA\)AQAzApAzA33A
=AzAA(A
=A{AAA\)AAAA33A\)A\)AzAAAHB {AAAHA33AAHA(ApA
=AAAHAB =qBRBB{BBBRB B pBB B B A
=AAQAA
=AHAA(AzA
=AA
=A33AAAAQA陚A33A
=AAA33AQA33A
=AAA\)A{A{A33A
=A\)A33AAA33A홚AAAHA33A\)AAAAHAzAQAAHAzAHA\)AHA{AA33A
=AAzA\)AA(AAzAzAHAA
=A
=AzAHA
=AQAAHAQA33AAAQAAAAzA
=AAAAAAQAAzAAzAAA33AzA\)A
=A\)A홚AHA\)A
=A{AA
=A陚AQA噚A\)A
=AzAAAzAAAAA\)AAA噚AA33A{AAzA\)A{AzA33AQA
=AQAHAAAA{A{A{AzA홚A\)AQA\)AzA(AzAA
=AA33AQA
=B B BB  B	HBBpBBHB	B
{B	RBRB	(B{BHB\)BRBBRB(BHBHB\)BRB{B =qAQA(AAzAA33ApA(AAHAAzAHA
=AAAAA\)A33AQAHAA\)A
=AAAAzAA(AzAzA\)AA\)AzA33AAA
=B {ApApAHAzAHAzAB(BBB BRBBHBBRBpBBB=qBHB=qB(BRB(BRBRB B =qB {A
=AAAAAQAAApAAAQAA
=A
=A
=AQAAA33AAzAzAAzAzAAAA\)AA
=A(A
=AAQAAzAAAQA33AAzAzAA
=A{AAAzAAHApB {B B B(B(BQBHBpBB(B(BB B BRBpBBRB(BHB{B\)BRBRB=qB{BHBpBBHB
(BB
=qB=qBHB
pBB	(BRBBpBBBBBpB B pB B {B pB {AAAQApB {B =qB B pB pB pB pB {ApA
=AA33AAAAApAHAHApB {AAA(B B B(A
=AB pB BBBpBBB(AB BB pB=qBHBBABB  B	HB	(BpBBGB\)B
RB{BRB
=qB  BHB{BBB	(B
{BBpBBHBHBBBBRB(BBpBBB{BHBHBHBHBRB{B{BRB{BB(B=qB=qBB=qB=qB=qBB=qBpBBBB=qBpB\)BHB	HB{BBRB BABRBBHBBRB\)BBHBB=qB(B	  BRBRBBHB=qB	  B	(B	(B
=qB	HBRBRBB	  B=qBBBBBRBB\)B(B=qBBBB{BBBB{BpBBBBBRBB(B=qB AQAQB =qAzAAQA
=AB {B AAzAApAA\)AzAA\)A\)A\)A\)AHAAA
=A(AHA33ApAAA(AzA\)AHAA33A33A33AzAzAAA(AA
=AAHA\)AzAAAzAzAA33B {B =qB B\)B {B#  B BRB&B\B(B!\)B%\B#RB#\)B$B$zB!\B"zBRBB#\)B33B%\B%\)B$GB"{BB {B B zB\B)\B-B>QB:
B:zB2zB5B5B6zB3ffB2GB2zB4
B4GB1B3B6B2B2B2B2
B4GB7
=B7B9\B8zB8B6
B6B6
B4GB5
=B8
B;B;
=B<
B733B2GB4B:
B:QB8B4
B4B5\B1B133B5
=B8QB5ffB2zB(B.B2B0B/33B1\B-B*GB(zB%33B*B33B{B\B{BGBGB{B  B\B\B#\BRB"GB(B\BBGBBB#RB!RB'\B*B*B#B&zB+B.zB/ffB.zB-B0GB-  B/B133B0
B0zB3B533B5B9ffB8
B=33B<B<zB;B>B?B=B9ffB9B=B<zB7
=B533B;33B:B=33B>QB:
B8zB7ffB6
B7
=B2B3
=B6QB8QB9ffB7B6QB4GB6QB7
=B5\B1ffB4
B3B2zB1B2
B4B7B6QB5
=B2
B5\B7
=B8B<zB=B<B=B:B9
=B733B6QB)B+ffB.B0
B(GB+\B,B'B(B)  B$B,zB,B,B0GB1\B0GB0zB0GB.GB,B)B)B/33B.B'B)\)B,B.B3
=B4B533B2
B2B5B7B3\B533B7ffB6QB9ffB:B:
B9
=B8QB2GB0B4B7ffB:QB9\B<B<QB>QB@BC=qBAB:QB@
BBQBCBG=qBJB3BDHBGB@zBCBE
=B@QBDBCffBEB>B>BAB=33B?B?ffB=B<zB8
B4zB5
=B4zB/\B+33B-33B/33B+B)\)B(zB-\B*B'  B 
B"zB,B*B&B(zB%\B)\B*B&zB$B!\B\B
B\)BB{BB\)B
BBGB  B(B
B{BpBGBGBB(BRBBB\B  BpB(BHBpBpBB\)B{BpB  B
\)BpBB
\)BHB
=qB
RBRBBB  BB(BB\)BpB	\)BB
  B\)B{B=qB{B{B(B  BpAA\)A(BB
\)B
(BB\)BBB	HB{B
RB(BBRBB(BGB(BHB0GB5B2
B7
=B3B1
=B3\B733B3B3ffB2B1\B2GB3ffB.B.GB*B+  B%\B*zB'B'B'B'B*
B*B%B$BB\)BBB
B"zB"GB
B {B {B\)B\B{B!33B&B&B!RB!33BB{B)  B  B%B zBRBB\)B\B!  B"
BGBBpBGBBBBBB\)BBRB
RB
HBpB(BHBGBBRBGB\)BBHB\)BB(B\)BB{BB{BB\)BB(B  BpBRB{B\B33BGB  B  B(B  B{B\)BRB\B33BGB  BGBGB{BGBB33BBB\BRB\B  BB  BpBBB  BGBGB{B  B  BBB{BHBRB  B
\)B
(BBBBHB
  BpBB{B\)BRBRBBBB
\)B  BB\)BGBGB{B=qB{B=qB=qB(B\)BB=qB
{B
pB(B
\)BRB
HB{B
BB
{B  B
pB{B	\)BRBB=qBHBHBA33A33A33AzABRA(AB=qA33ApABBHB A(B =qB {B=qBB\)BB	HB
=qBB pBRA(AA33A
=BAB BHB\)BBHBpB\)BBRB(B  B\)BBBRBHBpBBBHB{B\)B(BpB=qBBBBHBRBB	\)BRBpB\)BRB\)B(BB{B	  B=qB=qB=qB{B=qB
\)BHB
(BB
(BGBpB(B(BBRBB{A33A33A33AzBQBRBBB(BRBB=qBB  B	\)B
=qB
  BRBpB  B	RBBpBBBRB\)B\)B  BBpB{B	HBBGBHB
B	  BRBHBHB{BHB
pBBRBpBBB	RBB
(BRB  B=qBB  B(BHBB=qB{B
pB(BB{B{B(B
=qBA
=AzAzB BQBHB(B=qABpB\)B{BBBRB(AHAAAA
=AQA(A
=AHAB\)B BRBHBB=qBRB(BB  BB  B
BpB(BpB{BB(BpBRB	RBB\)BBB(B(BBB{BHB
  B  B{B(B=qBB{BBRB{BpA(AAAzA33B ApAB B =qA
=A
=ApAAAQAA{AzAA{AAA\)A홚AA陚AQA
=A
=AQApA33AQAAAHA{AAApAAHAA
=AQAQAHAB {B=qBB=qBB\)B  BBBHB=qBHBRBBHBBB\)AAHAA
=AA
=AAzA
=AA
=A33AHA33AA
=A
=AAHAzA33A(AAQA33AHA33AA\)A{AA{AA\)A33A
=AQA홚A\)AA
=A{AA
=AzAzAHAzA{AHB=qBB(BpAzBRApB =qA33AAQBB {B=qBpBB =qB =qAB B =qBQBQAA
=BA\)AAAQAHAzAA33AzA
=A\)AAAQAQAzAA\)A33AAA
=A\)AAQA
=A\)AHA{AA(AQAAA(AA33BAQApAA33AAQAAAAQA33AQAQA
=BpApAA
=BB\)B\)B(BHBpBHBRA\)AAQAAA(AzAAHAAQAQAAA
=AzAQAA(A\)AA33AAAAAHAHA
=AA(AAQAAzA
=AQAA33AQAzA(A\)A33A33AAA33AQA\)AHAAA{A\)AAzA33A(AA\)AAHAHApB {B B(AAzAAApA33B =qB B(AAAAAAQA33A(A33AQAzA\)A
=AQA\)AAA
=A
=AAzAAAQA
=A(A(AAHA(AHA\)A\)AQA
=AAAA\)AA\)AAHAQAAAQA\)AA(AA33A(AA33AA\)A\)AQAAQAAzA(A33A(AA(AAA33A33AzAQAzApAQAAAAAHApA33AzAHAzA
=AAAHA\)A{AQA(A
=AA33A\)A
=AA
=AzAHAzAHAzAzA33AHAA33A33AA\)AAAA
=AQAHA{A33A33A\)AAA{AAQAAQAHA
=A(AQAA33A33A
=A
=AAB B(B(B ABRBHB=qBHBB B B BB{B B pBpAA33AAQAA(B {A
=AzAAA33AHAA
=AAQAAAAHA
=A(A\)A{A33AzAAQA33AAAA\)AAA33AHA33A
=AA\)AAA33A
=AQAAzAzAzA{A{AAAzA噚AA\)A33AAHAA홚A홚A33A33AAzAAAAQA33AAAA33A
=AAQAAHA33B{BB{BA33AAzAzA
=AQAA33A(AAA33AAzAAAQAAA
=AAHAzAzB {A
=A33A
=ApApB B{B(BHB(B(B(BB\)B=qB(B(B(BBB
B(B
BRB
{B
pB	(BpB=qBBHBBRBHB(BBBBBBHBBAHBpBB(B(B=qB{B(AA
=B =qA(A\)AAAAQB {A33A
=B BQBHBBB(BRBRB{BRBHB{BBB\)BRBB  Bpy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                 @@@p@p@R@  @G@=q@=q@@@@p@@@=q@=q@=q@@R@ff@@@  @33@陚@陚@@\@@=q@H@33@(@33@@\@=q@陚@R@@  @\@
@@@@ff@p@(@ۅ@@  @H@@
@@陚@@p@=q@(@p@@\)@\@
=@
@\)@  @@{@\@R@z@  @ff@@@p@p@@@@H@H@(@=q@H@H@=q@
@@G@@@{@\)@\)@
=@G@@z@@H@H@@\@p@p@R@\)@\)@Q@Q@Q@@@=q@z@(@@p@z@@\)@
=@\)@ff@(@(@@@@@@ff@{@\@@z@
=@AGA   @@=qA z@\)@{@=q@@R@@@@z@\)@\)@H@(@@@R@33@@\@=q@=q@
@pA zA33A(AQAQAAAAApA
AAAAAAARAffA\)AAffAAAzAAR@@z@A (AHA  AA\AAzAzAAAzA\)AA=qAR@@@@@@{@@@@@{@33@33@  @  @=q@@=q@p@
=@@@\@@z@R@
=@@\)@R@@@R@33@z@H@G@  @\)@=q@H@
@=q@\@33@@
=@
@\)@@@@p@{@{@@@z@@@p@@Q@=q@p@@@p@z@p@@
@
@G@33@@@  @  @R@@@@\)@@(@(@z@R@@\)@z@ff@ff@(@@
@z@@@
@
@
@@Q@G@  @  @@ff@ff@\)@@
@(@(@G@G@@@z@\@陚@\@@@H@H@33@H@@(@@
=@@(@ff@  @H@(@=q@p@{@
@@@@G@G@  @  @@Q@(@RA   @{A QAGA @RAA (A zA (@R@
=@33A   @@ff@@@H@
@@Q@33@@(@@@z@@Q@z@  @z@@@p@G@Q@@z@=q@
@\@(@
@z@H@=q@G@p@ff@H@@ff@z@G@\@@H@{@@33@(@H@H@@{@߮@@\)@(@@R@(@\)@
@G@@{@z@@R@@H@\@{@
=@@(@
@G@R@
=@\)@R@  @G@G@
@33@
@
=@@Q@\@@  @@@G@G@@Q@@@p@
@
@@33@(@H@
@33@
@(@{@{@@
@(@@G@R@@@@@p@ff@(@H@@@ff@@(@  @R@@=q@{@
@
@ff@
@z@H@z@  @ᙚ@ff@=q@@@@  @R@ff@  @G@=q@\@=q@@\@\@33@z@G@@@G@=q@33@
@z@@(@Q@ff@ff@AGA Q@33@33A z@@@p@\@\@=q@@@33@
@(@@@
=@@ff@@@R@p@{@p@{@z@@@@(@@(@R@
@z@@(@
@\)@z@{@
@R@@@z@{@z@@\@@H@
=@  @z@33@ff@ff@@@Q@@
@@=q@=q@=q@@@@@@H@
@{@{@
=@\)@@  @  @@G@@@@@H@@=q@33@
@=q@H@@@@@G@  @\@@@@H@
@@H@@ff@H@{@@@G@@@@(@G@@@@ff@R@R@@\@  @G@@@{@  @@p@{@@(@R@33@@(@陚@R@陚@@p@@z@{@  @Q@陚@Q@z@@@
=@\@p@@p@H@@{@G@ff@@(@H@  @ff@z@
@33@
@@=q@\)@
@(@@33@=q@33@p@@
=@@p@@  @33@(@@33@R@@z@@
=@@@{@
=@@33@33@@\@33@@G@G@@Q@
=@ff@@@  @ᙚ@  @@޸R@33@ٙ@@{@=q@Q@
@@R@p@33@Q@{@@Q@޸R@H@@H@@G@@z@@Q@(@33@ff@@\)@p@@陚@@@
=@ff@@\@@ff@{@ff@@
=@{@@\)@@@@Q@ff@=q@p@H@Q@@33@R@\)@{@@@G@@  @p@z@@p@H@@@=q@z@z@z@
@
=@H@@\)@
=@@޸R@߮@
=@ff@  @
=@\)@{@{@@33@{@{@p@@p@H@(@@Q@أ@ָR@p@׮@=q@H@ڏ\@  @(@
=@  @޸R@@@Q@@=q@@@{@R@R@@\@陚@@@@H@=q@33@H@H@@@@@H@@@@(@=q@
@H@@\)@߮@@  @ff@  @ᙚ@33@G@G@@=q@ᙚ@\@H@33@33@33@H@@@(@@
=@@=q@H@G@@=q@ۅ@׮@{@p@\)@z@ff@=q@ff@Q@ָR@@33@33@ۅ@@(@(@@
@33@ٙ@z@@@
@=q@@@(@@@@@=q@33@@@(@@\)@@@Q@  @  @@z@ff@ff@R@p@z@@R@R@z@@H@{@H@z@p@=q@G@  @Q@Q@  @Q@{@
=@ff@z@@{@ᙚ@  @
=@߮@@Q@Q@@=q@=q@@@@@H@
=@
=@\)@@=q@G@@\)@@=q@  @@ᙚ@@
@@\)@33@R@  @߮@@ff@ۅ@@@@
=@33@H@
@(@@ff@ff@R@
=@@R@{@{@p@{@R@R@
=@Q@@@G@陚@\@H@33@@H@@(@@H@@\@=q@@
=@@G@\)@Q@@R@Q@
=@@@  @  @p@@@Q@@(@@{@ff@p@@33@@(@z@p@@
@
@@@G@
=@ᙚ@
@@\)@  @
@
@z@z@
@@\@@H@{@@׮@@@@߮@z@\@=q@G@=q@33@ᙚ@H@\@=q@(@R@Q@\@\)@  @@@=q@Q@Q@  @Q@Q@@G@@陚@G@G@=q@陚@陚@@G@  @@
=@(@p@{@p@ff@(@@p@
=@@  @  @@@  @\)@p@ff@ff@p@R@z@
@(@
@@@@@z@
@33@33@H@@@@@=q@޸R@{@@߮@Q@Q@޸R@޸R@
=@\@@\@@33@\@@@
@(@p@(@
=@
=@@33@@@{@ff@@@G@Q@陚@=q@\@33@\@33@33@\@@(@@@@=q@(@p@@(@Q@@@  @Q@
=@R@\)@p@@G@Q@@陚@@Q@\)@@陚@陚@@R@Q@@(@@@H@H@
@H@33@z@
@(@
@@33@33@H@\@\@H@@H@Q@@@
=@ff@޸R@޸R@@
=@\)@z@@ff@أ@{@@p@33@33@Q@@\@H@G@33@Q@@@@@@p@H@\@\@(@@Q@
@H@H@H@=q@G@33@@\@=q@  @@@@Q@ff@
@=q@\@=q@H@33@@p@ff@(@=q@(@z@@33@@(@(@
@z@=q@\@Q@ᙚ@@  @{@ff@{@@߮@@G@G@@Q@G@=q@G@(@ڏ\@@=q@=q@z@\@@(@\@=q@@ᙚ@=q@@@@
=@@@@@@p@
=@\)@  @Q@@@\)@ff@p@@@@@ff@R@
=@@@@R@@
@@(@p@
@@33@Q@@Q@陚@H@
@@H@
@\@陚@G@@  @  @\)@@@@p@@z@@\)@p@@@@33@z@@H@@R@@@@33@@G@=q@  @
@33@@@
=@{@  @G@@@@p@33@\)@p@ff@H@H@G@@
=@z@@\)@  @  @\)@R@Q@@@H@33@@33@\@(@@@33@\)@@\@  @@ff@33@=q@陚@G@@=q@G@陚@@G@G@G@G@G@Q@@
=@\)@R@
=@\)@  @@Q@@  @
=@{@(@@@33@=q@@@
=@@陚@Q@  @R@Q@@@
=@p@@\@G@\)@ᙚ@z@=q@Q@\@33@33@p@@
=@@Q@@@陚@@
@(@
@=q@陚@@  @@@@@33@@
@(@
@
@z@z@@@H@@@\@@@(@(@33@33@@\@\@H@\@=q@\@陚@Q@G@\@@陚@陚@@p@(@ᙚ@@ᙚ@=q@@G@G@@ᙚ@G@
@H@@@ᙚ@@ᙚ@ᙚ@=q@@@@@  @߮@\)@޸R@
=@\)@@G@@  @
=@\)@ff@@@G@G@@@  @H@陚@\@33@@33@z@
@z@(@@z@@@@@@R@R@R@@@\@
@@陚@G@陚@@@33@
@@@@p@(@(@33@\@G@@Q@@
=@\)@ff@{@@@p@@@@(@z@
@@33@=q@@ᙚ@G@@
=@{@{@@(@߮@\)@ٙ@ᙚ@@@Q@  @
@z@@p@p@@p@ff@\)@@H@33@@@@@z@p@@z@
=@@
@Q@@@Q@H@@z@p@z@(@
@\@=q@\@G@\@=q@z@(@\@33@=q@G@\)@{@@{@ff@(@G@Q@@@\@  @@  @@ff@@{@@p@@
=@
@@ff@@陚@@@@H@陚@=q@@z@@(@@@@(@@@@
=@@H@@@R@
=@@  @@@
=@ff@@ff@p@@ffA   A zA ApA   @ffAp@\)A   A A A A   A (A (A QA (A (A QA zA A A @
=@\)@@(@H@33@@=q@33@H@=q@=q@@=q@@H@\@@(@(@=q@=q@@@
=@\)@\@@@@\@@G@Q@@@{@@p@ff@  @  @  @  @Q@@R@ff@\)@@@@  @Q@  @\)@G@ff@R@@@@  @R@@
@ff@@Q@Q@H@H@p@@@p@=q@H@G@@@@\@@z@H@@G@33@\@(@H@
@\)@(@Q@\)@@@@@@A@pAffA@\AAGAzA
{AAzA
A	pARAHAA @@@(@R@\)@=q@@
=A{AAARA\)AA33A AA@33A zA\Ap@{AG@=q@HAA\)A   A A AA
=AA
A@AQAzA  A
=qA
\ARA\AAA=qA
=AzA  AA(A
pA
=A33AA{AQAA\A  A\A\)ARA\)A	A=qA
A
A=qAQARA
=A
=AA33A=qA
=ApA	AHARAQAHAHA  A
AQA
AffAGA
AA
=A	pA
GAAAApAA  A	GAQAAAffAffA
\A
A
=A
ffAAA
\AAAH@(@G@RA(@@AA	pA{AA  AHA@A\A  A  A(A
RA
HA
A
A33A  ARA\AA
AA{AAHA33AQA@p@ffAA{A QA\)AAQAAA(AAA  AHAAGARA
A\AAA zA zA   AGA Q@
@@{@A (@{@@
@@{@=q@
@G@=q@@@Q@z@@(A (AAHA @ff@(@@G@@p@
@
@z@33@@@@\@Q@{@p@
=@@{@Q@\)@@{@
@
@@@
@p@R@  @ff@{@pA (@@G@H@=q@
@@@p@p@z@  @@Q@@陚@p@
@
=@  @@z@@
@
@\@\)@
=@
@@z@ff@\@@  @@ff@R@@@p@@
=@@  @
@p@@  @@{@@@@@@\)@ᙚ@
@陚@(@(@=q@(@
=@z@z@@@\@
@@G@@33@@
@
=@R@@\@Q@
@33@
@Q@
=@@G@@H@@@z@{@Q@@z@G@ff@R@
=@@
@z@@@@\@@p@{@陚@H@\@@ff@@@p@{@  @\)@@Q@@@@@=q@@R@(@z@@z@=q@陚@33@@(@z@@@z@@@
=@@z@Q@@@33@Q@{@=q@@\)@p@33@\)@@G@R@R@=q@
=@{@H@=q@@Q@@\)@R@(@ff@@@@33@@R@@Q@@H@33@@H@
=@p@\)@@@@@  @z@R@@=q@@=q@{@@
=@\)@@G@G@\@33@33@@\@\@\)@@R@(@p@ff@@(@z@@(@
@@@@=q@G@p@{@@@@H@@{@@Q@Q@@@R@@@@ff@ff@R@
=@R@
=@Q@@@G@@  @  @@@@
=A ApA
=AHA
=AA\ARA33A{A=qAAA AAGA=qApAGAAA=qAA AA A A AA   @A (@
@R@R@{@(@=q@33@@33@\@@G@33@(@33@H@@ff@p@H@\@
@R@@\A Q@pA   A (@@RA @@ff@H@@@@R@@\AGA zA   A
A
AA\ARARAA
AAAA
A(A(AzAAAzAA(AAzA
AzAzAA(AAA@ff@z@@G@ff@\)A   @
=@\)@
=@@\)@@G@z@@Q@\)@G@=q@@@z@p@@@{@@@ff@R@H@\)@ff@ffA @p@@ff@@@R@  @H@{@\@\@H@@@Q@@@@z@@33@\@ffA @AAAAA=qAAA=qAAffA=qA\A=qAffAAHAAAAAAzA(A  AAQA
AA
A\)AA\)@(@
@@pA Q@ff@A   @@H@z@@ff@@@
@@@@(@@@(@@@@@@\)@\)@R@Q@
=@R@@\)@@
@H@=q@@@\)@R@@@=q@
@@@@@=q@@
@  @陚@(@{@p@G@p@R@\@
@@ff@p@\@@Q@@33@@@
@@=q@\)@@@  @ff@
=@  @\)@@\)@
=@
=@
=@\)@R@R@
=@{@ff@(@z@(@(@33@H@33@z@=q@@p@\@G@H@{@
@H@@@p@@ᙚ@ᙚ@H@G@
=@@\@z@Q@p@{@{@{@@ff@@p@
=@R@{@p@ff@@{@
=@p@z@(@
@@@R@@@陚@=q@
@(@@@ff@@
@@@@@p@(@p@@\)@Q@@
=@  @p@  @{@H@=q@陚@@陚@Q@\)@@R@@H@@=q@33@33@G@@G@=q@ᙚ@ᙚ@\@\@H@33@
@@@߮@H@G@@\@߮@޸R@ff@Q@ff@Q@
=@\)@޸R@Q@G@ٙ@ڏ\@ڏ\@ۅ@@{@{@ᙚ@\@H@=q@  @@ᙚ@Q@
=@=q@@=q@33@33@@
=@\@=q@z@@33@陚@Q@@@=q@\@@z@  @@ff@\)@{@@\)@  @
=@p@R@{@p@@
@@@
@@H@\@@@H@H@@=q@33@
@\@  @@@Q@@p@p@p@@p@@p@R@33@G@߮@
=@ff@
=@p@
@@@=q@ff@  @@@\)@  @Q@\)@\)@R@@@@G@=q@=q@@{@@z@
@
@(@@H@@@@@33@
=@ff@ff@ff@@\)@ff@Q@@@@@@@  @@\)@@  @{@陚@(@G@\)@=q@@ff@Q@  @@z@p@H@@p@z@p@p@33@@@@(@@p@p@@(@@\@@=q@\@\@@@@=q@@G@(@\@@߮@@@G@@\@H@\@\)@=q@@(@ff@\)@Q@
=@=q@@@
@@
@@33@@(@@@@@{@R@R@Q@=q@(@@p@p@
=@R@R@ff@
=@R@@@=q@33@=q@\)@\)@
=@@@R@(@
@
@@@@{@R@@R@
=@@G@
@@p@G@{@Q@\@Q@@33@@  @\@p@@@\)@R@@@@z@R@  @@@z@=q@@p@ff@@@G@@Q@@G@p@ff@@@G@
=@(@R@  @@@G@
@p@@  @@  @@\)@G@
@\)A zA=qAHAA=qAA  A Q@ff@
=@@@
@R@R@
=@{@z@@@R@
@@33@33@=q@H@@@H@@@
@
@
@@ff@ff@@
@@z@(@\)@\)@
=@
=@@  @Q@@Q@@  @@@
=@@@\@@z@{@@R@  @@G@@\)@@@R@p@@(@(@@\)@z@(@@ff@
=@@@@@@@\@G@\@=q@=q@H@@@{@@@@ff@{@@{@@R@ff@ff@@@
=@p@@(@R@@\@p@p@z@
@@33@\@\@\@33@(@(@
@33@z@p@@@@\@33@=q@Q@G@=q@G@@=q@@@  @G@@=q@H@33@(@
@
@33@H@@@@@@=q@\@=q@=q@H@@@{@Q@@@@Q@@@@=q@=q@\@H@33@z@@R@{@@
@\@@\@H@=q@@@@\@H@\@@p@ff@z@@@p@@=q@@z@
=@  @Q@@33@@33@33@H@G@H@\@@@\)@  @@(@p@p@@@33@@
@@33@(@@@@@@{@p@ff@\@@@  @@Q@@@H@
@(@@
=@{@R@
=@
=@  @\)@  @Q@@@@@H@=q@=q@@ff@\)@=q@\@@@z@p@{@\@=q@33@@33@G@陚@Q@
@
@z@@@{@@@33@@z@@@z@@@@p@z@H@@p@{@p@\@@R@ff@ff@ff@G@p@(@  @
=@33@{@
@@@p@(@z@@{@p@z@@p@  @@p@@R@z@\@@Q@H@
@
@
@@p@R@\)@@\)@R@R@p@@R@R@  @@@
@\@\@\@=q@@ff@@@(@Q@@@陚@=q@=q@=q@  @G@陚@陚@@Q@@  @  @\)@\)@  @Q@R@
=@{@ff@ff@ff@ff@@p@@@p@@ff@R@{@@ff@{@ff@ff@{@@33@ۅ@ۅ@@@\@Q@@@@G@
=@Q@G@G@=q@@
=@@
=@@33@@(@=q@33@@33@H@\@=q@@ff@  @@
=@\)@  @Q@  @@
=@@@\@@@33@ff@@@ᙚ@\)@
@H@@\)@@
=@=q@
@(@
=@
=@@  @ff@(@p@(@Q@@=q@H@@陚@陚@\@\)@@@
=@@33@H@H@Q@\)@
@33@ٙ@ָR@p@@׮@ff@p@  @\)@@@޸R@޸R@
=@@@陚@G@陚@  @Q@@G@\@
@R@@\@@{@{@@@
=@
@
@(@@@@z@@@@@@(@@(@(@
@R@z@33@
@R@@33@@(@@ff@@p@z@(@@@@R@p@@=q@33@@@\)@@@@@{@@p@
@(@@33@@@33@=q@陚@@  @H@@@@33@@@G@  @
=@H@\)@H@@\@@@@@G@H@z@@{@{@ff@R@{@  @Q@@=q@=q@@A zA zA A z@H@@(@z@p@{@p@@@(@\)@z@@@p@
@
@Q@@(@z@G@  @@p@@\)@  @ff@ff@@@\@@@Q@Q@@z@@@@@
@@R@@
=@ff@z@@\@@H@Q@@p@@ff@\)@@@R@{@R@
=@\@ff@@@{@R@\)@@  @Q@@@  @
=@{@{@
@@@@{@=q@pAA@\)@\)A (@@R@R@p@@@(@@{@p@@33@@\@@\@\@H@@@=q@Q@  @@@G@@\)@H@z@\@33@
@@(@(@
@@@@@=q@R@  @\@@@@\@@  @@Q@@=q@@@@G@=q@=q@@@=q@H@@@@@@H@@H@\@=q@
@\@\@\@H@@@H@z@@@
@@@  @G@H@(@@@z@{@@@z@\@@@Q@33@33@@@\@@33@G@@\@@H@Q@33@p@33@H@@@
@@{@@p@@\)@ff@Q@Q@{@@\)@\)@R@33@@
=@ff@{@{@{@@ff@
=@@
=@R@\)@@{@{@ff@@{@  @@@(@@R@@A A Q@R@
@@z@@G@H@@
@@=q@\)@ffA z@
=A@\)A=qAA@\)@@ff@@@@z@(@(@Q@  @RA   @
=@@H@@Q@G@@\@G@H@Q@@G@@@
=@G@@@=q@@@@@G@@ff@ff@@H@@@
@
@@H@=q@@p@p@
@@@@@@R@@\)@@@  @p@@p@{A (@
@(@p@
@{A z@\)@A (A A A{AA{A=qA A   A A zA (@@R@p@\)A A
=A=qA   @A   @ff@@@@@(@
@(@@\@\@\@\@Q@=q@@@@{@R@\)@\)@@@
=@\)@Q@@\@@@@@H@@@\@@@@@@  @\)@H@(@{@(@ff@@H@@\)@G@@R@RA QA QA zA AApAApA ApA{AAGApA=qAA33ARAA\)ARA{AApAGAA A A zA (A (A QA AGAffA=qAAApA QA zAAG@@p@@@@A @
=@R@{@{@ff@{A AA   @zA AA zA (@
=@\)@@@A A (AA=qAApAffAffA{A=qA\ApApA{AffAffAHA
=AAA
AA  A\)AA33A
A
A  AAA33A
=ARAQA  AHAGAAzApAGA zA   A zA z@@\)A QA QAGA A AAA
=AA\AzAAAzAffAA=qA=qAGAA A ARA (@
=@\)@R@{@{@RA (@\)ApA=qA (@
=A (A zAA A Q@@ffA QAApAA AA=qA\ARA
AzAAffAffAAffA33AA  A\)AA\)A  A
AA\)A33A=qA{AApAQAQAAAA  AAQA(A\)AHAffAA A A A A ApA33AA\)AffA\AHAH@
=ApAAApAffAAA{AA{AA{AApAGA ApAAAAAAGARAAGARA
=ARAGAA	AAA  A	A@{A AGAApARAQA
=qA
A
GA
AAzAQAA
GAA	A
HA=qAffA
AAAAA{AAzA\)A	pAA
=A
=@
=AzAA=qARAA(AA(A\)AzAQA
RAA  A\A  A
ffA	A	A	GAzA	GA	GA(AQAA  AzA\AA
A
=AA
{AAA
=AA
RA
A
\AzAAA  AzA	AAA	GAA  A
=AApA(AA(A33AAA	pA	pA
RA33A(AA
GA
RAA
RA	AA	AAHA
GA
GAffApAAA
RAA
\A
AA
=A
AQA	pA{A	AAA(A  A\)AA\)A
\A	A
{A	pAAA
=AHAA\)AA	AA  AA	GA(AA  AzA	A	GA
=A
AA\)A
AHARAAzA
ffAHA
AffA
A33A
=A=qAA
HARAA
AAA
=qA\)AA  AQAARA{A\AzAAzAA
{A	GA	pA	AA
GAAA
A
A
AQAQA	A
=AzApARA@
A AA z@{@\@  @R@@ff@@(@
=@{@@R@AffA(@z@\)@\)A @ff@p@pA
A{@\@R@@
@(@@@@z@(@
=@\)@@
@\)A\A(AA zARA AffA\A=qA QA AARAA@{@@@33@@ff@@=q@@\)@@@=q@33@z@@
=@Q@@@\)@ff@R@ff@
@@H@
=@\)@R@@R@\)@ff@G@Q@  @@@陚@陚@@@@@=q@@@Q@Q@Q@@@Q@\)@\)@
=@  @  @\)@@z@@R@\)@@@G@p@@@Q@@{@
=@@  @G@@=q@
@p@z@(@z@33@
@@p@
=@  @=q@33@@@ff@ff@@@@@z@@@{@@@p@R@
=@\@\@ff@@@{@H@
=@@\)@Q@
=@H@\)@33@33@  @ff@R@@@H@=q@\@ff@@@@p@p@p@\)@\)@Q@@@  @@33@@=q@33@33@@@G@R@@ff@Q@=q@\@=q@@@@@@
=@\)@@(@@=q@z@G@R@ff@{@(@@33@ff@  @ff@
=@ff@ff@{@33@z@@  @p@G@@@33@H@33@(@H@H@@@G@33@@\@陚@G@G@=q@陚@@@ff@@
=@p@  @G@\@(@(@@@(@
@(@z@@z@p@p@@G@z@H@p@{@@
@\@(@@@z@(@z@(@
@(@@(@(@
@
@@33@
@
@(@@z@(@33@@H@H@(@
@p@@@H@
@Q@=q@=q@33@@\@陚@  @\@
@z@(@H@陚@@Q@  @@@R@
=@  @Q@  @  @Q@陚@@@G@@@H@\@@z@(@@p@p@p@@p@ff@@
@(@{@H@@@@Q@ff@\)@  @R@\@{@߮@33@\@z@p@ff@@{@ff@@R@
=@{@@\)@
=@\)@ff@@=q@=q@\@33@@
@33@H@z@\@=q@=q@@G@@@@\)@G@33@@(@
@(@33@@@\)@R@
=@ff@@
@陚@G@\@
@p@
=@R@@@@@@33@33@
@@p@
=@
=@Q@G@@@@@@=q@@  @@@=q@\@@@ff@
@R@@(@  @H@@\)@@\)@@@Q@@@  @Q@@
=@\)@R@
=@{@
=@
=@@  @@  @R@ff@@{@{@  @
=@
=@@G@@R@(@@@@ff@@@(@@@@\@@H@H@@33@(@
@z@z@@z@z@@(@(@
@@p@{@{@{@@{@{@@p@@@z@z@(@(@
@z@
@
@@@z@
@@(@
@@(@
@@@@H@(@33@33@=q@H@\@H@H@H@33@H@H@H@H@@
@\@33@H@G@G@H@\@@@\@
@
@@z@@@@@ff@{@\)@Q@@{@ff@@ff@ff@
=@ff@\)@R@@{@@p@ff@R@R@\)@=q@=q@H@\@@@@(@33@=q@=q@@@@@G@Q@  @@\)@@@\)@
=@@\)@Q@
=@{@@H@@z@ff@{@z@H@\@\@33@\@@@@@@Q@G@@G@@@@@@@@33@=q@@G@33@\@33@R@ff@\)@ff@
=@@H@G@33@33@33@\@H@=q@\)@@Q@G@@@G@@  @@@@H@\@=q@H@33@H@\@\@H@
=@
=A z@{@z@
@33@@R@
=@\@H@@Q@@@Q@@@
=@p@{@ff@@G@@Q@  @@\)@@  @Q@  @Q@@R@R@R@  @H@G@p@@@(@
=@\@
=@Q@
@p@ff@@@G@@
@@G@\@@ff@
=@p@H@z@p@z@ff@R@R@{@@p@@@@{@p@p@p@R@  @Q@@Q@  @@@@@G@\@H@
@@@Q@Q@@\)@ff@
=@R@@{@ff@
=@p@
@
@
@@{@{@@@{@{@z@@
@H@H@33@G@@@
@33@@@H@33@(@
@Q@=q@@G@33@33@
@p@@@z@p@ff@p@R@
@@ff@@  @
=@@\)@  @  @@G@\@@G@G@R@@@{@\@
@@(@{@@AG@
=@ff@@
@G@@@R@
=@Q@@  @  @{@R@ff@\)@@R@{@{@@@R@{@ff@@p@
=@
=@@
=@p@
=@R@@@  @@(@
@R@@@@@@z@Q@@{@@p@(@
@33@@z@H@z@@
@=q@H@@G@33@p@33@@H@p@z@
@
@
@(@@@ff@@R@ff@{@{@ff@R@
=@@@Q@@@\@@@@G@  @R@@\)@{@R@\)@p@{@@@@(@z@@{@ff@p@{@R@  @@\)@\)@@z@p@@H@@  @陚@=q@33@\@\@@H@G@@@\@G@@33@H@
@@p@=q@@(@@
@(@@@@@@\@@G@=q@@G@G@@@Q@@\@33@33@@p@@ff@Q@ff@@{@@@@@{@@
@
@
=@@@p@\)@@@@R@
@
@  @G@@(@@(@@@R@{@ff@{@ff@G@@{@ff@@H@p@
@@@33@p@
=@@@@@p@=q@G@@@p@\)@
@z@z@@z@z@\@=q@@@@@@R@p@@
@
@@(@z@
@p@@ff@R@Q@@@@@@@@=q@=q@@\)@\)@\)@
=@@R@@{@
=@@R@
=@  @z@@@\)@{@\)@R@
=@
@H@@p@33@
@33@p@z@@@@@(@(@@\@=q@@@@p@
@H@H@\@@@@
=@z@=q@
@@ff@G@\@33@@=q@@@@@p@ff@p@Q@@=q@
=@
@
@p@Q@ff@@p@R@{@R@R@
=@ff@@R@@@Q@@\)@z@RA\)@\)@@\)@@  @@G@\)@
=@R@
@ff@QA A QA (@
@@@  @R@Q@  @ff@@@\)@z@@33@{@33@@@@Q@@\)@R@R@ff@ff@\)@Q@
=@  @@@Q@@@@@  @  @R@\)@@33@@@@@@@  @\)@(@@ff@p@\)@@@p@33@@
@\@@@(@=q@\@H@
@
AGA (@@@(@@@pA zAApAA   @\)@RA (A   AAGA\)AARA A\)AA   @
=A   @R@@@G@H@  @
=@
=@@@@\)@ff@Q@=q@@@R@@=q@Q@R@\)@@{@p@=q@G@H@@@z@Q@z@@\@p@=q@@33@R@p@@RA zAA
=A A=qAAGApAGA{AH@
=AA\)A
ApA33AQAA	pA	A	A
\A
=A
A
A
\A33A	GA(A
ffAA A33AGA(A @@
A   A (@pAAzA\)A\A AA z@@ff@{@
@=q@@  @R@
=@
=@\)@  @@@R@@
@H@H@@
@
@
@(@
@@
@@p@z@@(@z@p@@@{@Q@@ff@Q@  @=q@@@ffAHAA=qA33A33A\)AffAffAA  AA
AGA\AffAAA @AA ApARA
AHAA=qAAA(AAAzApA(A Q@@@@A\Ap@p@@@@z@
=@p@=q@=q@@H@z@G@@@@
@@p@@
@R@
@{@z@{@{@\)@\@@(@@@  @
=@ff@@Q@@33@=q@R@@\@=q@@=qA@\)@@A\A A AAHA33A33A(A	pA
ffA\)AA
pARA
GA
ffA
A
AAAAffA{AAffA\A\A
=A\)AAAAA\AzA  AzAAAAAAA
A(A
AAzA
=A  A=qA A   @@H@
A{@R@pA33A(ApA33A\A zAAAGAAffA(A
\AA @
=@z@@@\@G@@(A{ARAzAAA=qA=q@z@A AffA=qAA"=qA33A
ApA{AAGAGApAAA
=A33A(AAAA"=qA%GA(A*=qA5A6=qA4(A/A1A/A/
=A.RA*RA&ffA=qAffAAAA33ApAA{A=qARAGA(AAA=qAA\A\A
AGA33AQA=qA
A
A  A
GA
A
pAffA\AffAA
=A{A
A  A
GA(A
HA	A
=qA	A
{A
=AA
\A\)A{A\)A(A  AAAzApARAAA  ApA
=A{A$(A'\)A QA#\)A)A-A'A6ffA/
A5A5A8(A:ffA;
A>ffAG33AF\AHAEGAEADzAAGAEpAJ=qA?
=A8A;A<A=GA=GA>RA;
A5GA;A.RA"RA$A!A%A'A,(A*RA)A&=qA'
=AAGA\AQAffA\)A
=AAGA  AffApAA=qA"=qA (ARA AA
=A=qAAffAA\)A
GAA
=AA\A#AA
=AHA  ARA
=A
=A
ffA
pA\)AAffAzAffA
=AAAA\)ApAA#
=A$  A&{A&ffA)A+33A,A-GA,A(QA%A0(A$QAA(AApAA\A\A
A33AAA	A(AA(A	GA	pAAA
=A33AGAA
AAA!GA{AAAA{AARA=qARAffAA  A(A(A  AA
A(AA@(@H@=q@@@@{@p@@
=A (A33AARAGAA
A
=qA(AA
=AAAA\ARA=qA!A{AffAAzAA33AAGA(AAA!A$(A%A"RA'A,A1A\)A A'\)A(QA*HA*HA$A!A   A
AA33AA  A33A\ARA  AAAAGAApAAHA(AGAGA
=AA{AA(AGAGAzAHA  A
=A(AQAAA  A\AAA(A\A{A
RAQA	AA
\AAA  AAA
pA(AHA
=A(AA\AHA{AApARA\)AA33AAAAA{AARARA  AAzAAAAGA A!A%pA$A#33A!A$A*ffA&ffA QAGA\A   AA
AA	A33AAAAAA33ARA\)A  A=qAAQAzA=qA33AQA
\A
\@\)AA{AAAGA zAHA A zA AHAAffARApA ARA(AA
AAAzAAQARA33AAAQA  AzAA{AARAApARA
A
AA
=AQA
=A
ffAAA{AffAAzA\)AQAzA  A  AAAzAA  A
\A
=qA	A
{A	A	AA(AA\)A   @R@\@  @@@{@p@@@  @=q@
=@p@@p@{@G@@@@{@\)@z@=q@\@@@@@\@z@陚@@ff@
@@@@Q@\)@@H@ff@R@
@(@@p@ff@@\@@R@{@@ff@ff@=qA	A QAQA33A\)A z@@@ffA QA   A A{A33AAGAAAAA(A\AAA(AQAAHA=qAQARAHAzA   A\@(@@@陚@@Q@G@陚@G@G@=q@陚@Q@Q@
=@p@@@@R@\)@@@\)@  @\)@@R@@p@p@@33@z@ٙ@G@33@z@33@=q@\)@H@{@@
@@@33@R@33@@
=@@\@@\)@ff@p@H@@G@  @33@
@(@33@ff@\)@z@@@(A A\)AAAA
RA33A
HA
{A	A
A  A
RAA	GA\)A{ARA@R@@R@H@{@H@@@@33@@=q@@R@ff@@
@33@33@H@@=q@陚@@@@@Q@@@@\)@\)@  @G@陚@33@H@\@\@H@H@H@=q@z@z@\)@{@@p@\@@\)@@(@H@RA AHAAA(A=qA AA @
=@@
@
@33@H@H@@@R@ff@\)AHA
=AffAQA	A\)A	A	A  AAA @ff@p@\)A QAG@z@\@@@=q@@{@@33@=q@=q@@@z@
@(@@  @@33@@@@@@@@=q@p@
=@
@ff@@33@\@(@G@{Ap@\)AA@@
A (@R@33A AAA\)A	A33A33AA\A
AzAAA\A\)AA
ARA
AAA  A\A
AHA
A
AAA(A	A  A	GAA(AAQ@RA zAA\)@\)@p@p@ff@=q@Q@=q@\@@
=@@@@p@@p@p@@{@{@R@\)@\)@  @
=@R@z@@@(@H@33@p@
@@@
=@\)@=q@G@{@
@\)@@p@@@A (@G@
=@AAffAAHARA
A\)ARA\A\AAAAzAzA
A
=AApAA\ARARAHAzAAApA{AAQAAAARARA
=ARA=q@pAA AApAp@A   A (A QA QA (@{@z@H@\@@@R@(@R@@@@@@@G@G@G@@@@R@z@@@Q@@p@R@ff@@p@@@G@@(@p@@@AARA @pARApA AG@\)@\)ApA(A(ApAAA33AQA	GAA(AAA
=AHAQAA\)AARARA33A A
=AzA
ApAQA=qA  AARA=qAGAzAA	pAAAQAQA  A
AQAApA AA A A ApA Q@@@G@G@@Q@@Q@=q@p@R@@@  @@
=@H@
@@R@A zA\A\A@\)A A zAA{A33ARA\)A\)ApAffARA
=AAAA	A
AQA  A\)A33AA	A
\A  A(A	A	pA	pA	A	pA
=A	A
=qA	A	AAAAzAAA
AA
=A{A	AAzARA
ffA=qA\)A  AA
=ARA ARAA A @\)@@A (@\)@ff@A A
A
=AQAzA @ff@ApA33AA@A @@{@@@(@@
@G@  @@33A (@ffA Q@{@ff@
=AGAffA=qAAffARARAHA
=A  AzAAAA=qA
=AHA
=AHA\AffAA33AAffAQA=qAAAA33A33AffAAA  AHAHAA @H@(@@@H@@
=@p@p@@H@
@=q@@  @@\)@ff@  @ff@R@
=@
=@@33@
@33@(@z@\)@=q@  @Q@p@ff@p@{@\)A (@33@(@(@\)@{AAAQA33AAGAGA{A\AA33A\)ARA{AAGA(AAAApAAA=qARAA  AQA(AzAzAA  AA
=qAAAzAAAA33AHAffA{ApA A (A (A   @
=A   @\)A (ApAA   A A Q@
=@ff@(@z@\@\@@ff@
=@\@\)@R@z@@@@@@@  @@H@G@z@@(@@G@
=A QAG@A (A A  A=qAAffA	pAAA(A
HAzAAQAA=qA
=AffA\)A	pA
AA
RAA
GAA
=qA
{A(A33ARAAAAQA
AAA  A{A\)A\)AQAAAQAA
=A33A\A@
=@\)@\)@{@G@\@ff@\)A   @
=@33@@{@33@z@@z@@@\@@@
=@Q@QA   @
@H@  @\)@@@R@@p@pA   A Q@RA (A AAHA(AA
AzA(A{A\)AA	A	A
=qA(AAAA
GAQAzAA{A
A  A
A\)A
RA
\A
=A  A  AGAHAHA\ARAAA
ffAA33AzARAA{ApAAGAQAARA
A
A
=A  A
AA33A33AQA
=AffApA(AHApA\ApAA=qAA QA@{@RA   AAAA QA A A (@{@RA   @
=A
ff                                                                                                                                                A
        A33AAQA=qAffA=qA\AA
=A(                                                                                                                                                                            A=qA33AA=q                            A
A{AA
A33A\A
=AHA\A
A
GA
            A
=q                            @@
=            AG@\)                                                                @H@ff@    @(@z    @@  @{                            @{@H@@                                                @        @z                    A(A    AApA33A    AA
=AAzA                                @\                                                        @{@G@
=@\)            @@33                                        @(@ᙚ@@ff@@@\)@ᙚ@@޸R@@@G@H@G@@@
=@@@G@R@R@@p@
=@Q@\)@@  @  @Q@  @@@\)@
=@@  @Q@@ff@ff@@R@@@=q@
@@=q@@@R@\)@@@@  @@Q@(@\)@ffAAp@@\@  @@G@陚@G@p@
=@@@@{@R@=q@Q@p@z@@@33@{@R@G@@@@
@@Q@p@@z@\)@ڏ\@33@ٙ@ٙ@33@H@ٙ@ָR@G@G@=q@z@@ff@Q@ᙚ@\)@ᙚ@\@@G@G@
@H@@ᙚ@ۅ@ڏ\@G@(@
@
@@@@߮@@@߮@ff@@@@p@@޸R@  @Q@(@@  @p@@@޸R@\@Q@Q@\)@ff@ff@@z@33@@@G@G@=q@@Q@G@أ@ٙ@Q@Q@  @Q@@Q@ָR@@@p@\)@׮@33@
@Ӆ@33@Ӆ@z@z@ָR@{@  @  @=q@@G@@@أ@@@G@@@أ@@@ٙ@@ٙ@@ٙ@=q@ۅ@z@@@p@p@ff@޸R@޸R@Q@Q@@@ff@\)@Q@G@=q@=q@H@=q@@33@H@\@\@ᙚ@@{@@{@ff@{@{@p@p@@@(@33@H@ٙ@=q@@G@=q@ڏ\@33@@G@ۅ@H@p@ff@{@{@=q@G@أ@ٙ@H@
@
@z@@(@@(@@p@@޸R@ڏ\@33@(@(@(@ۅ@33@ff@ff@  @  @33@@@@@p@33@@p@{@{@R@\)@  @Q@Q@  @Q@陚@=q@=q@33@33@z@(@H@33@33@@@Q@(@  @@陚@\)@\)@R@R@@ff@@@@z@(@(@=q@@H@H@\@G@\)@@߮@@G@=q@=q@@@=q@H@@@@=q@@p@{@޸R@@@p@(@z@@{@p@
=@
=@@@R@R@33@H@p@@@R@{@@\)@@
=@@H@33@@陚@\@=q@=q@H@33@@@p@{@ff@{@ff@\)@Q@
=@\)@@=q@@@@@\)@p@ff@@(@z@z@G@H@33@陚@Q@R@@(@p@
@@33@\@\@\@@@@\)@\)@߮@Q@ᙚ@  @@@{@Q@  @G@@@Q@
=@߮@G@  @Q@\@@p@
=@p@@@@@@@p@(@@
@@                                                    @                                                                        @@
                    @@          @ff@R@(@33@@=q@ᙚ@=q@                                                        @@@
                                                                @G@p    @
=@R@R@\)@R    @@R    @@陚@\@@
=@  @@33@H@
@@@z@@\@\@ff@R@
@p@@
@\@H@Q@@p@Q@G@
@H@H@@
@    @ff@z@(@@z@(@\    @p@p@{@H@@\@@@(@@\    @  @\)@@\)        @\)@R@\)@@ff@R@Q@{                            @      @H@陚                                    @@G        @    @33    @      @                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    @33                        @(                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                @ff@
=                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                        ApAzApA  A  AQAA33A  A  A	A	A	A
=qAffA  ApAHAA
=AARAA @@{@33@
=@p@p@G@@@(@(@H@    @@(@@{@
=@@ff@\)@@H@  @R@@@R    @A@p                        @H    @RA @
=@\@  A\ApAA\)AARA@
=AA
=A=qAA	A\)A(AAA
HAAAAHAA
AzA	GA
RA
GA
A\AA
A\AAGAAHAA33A33AA
=A\)AA
=A\)AQAQAzA(AffAAAGApA @A z@
@H@
=@@
@=q@z@@p@p@@=q@@@\)@
=@\)@@33@R@\)@
=A QAA
AQAzAA\AffA@@@G@@  @@@  @@z@=q@z@@Q@=q@@@\)A A{AAA
=AQA\AffARA{A\)A	A	A
ffA
\AAA33A(ARAA\A  AAApA
=AQAAAAA33A
=A
A  AAA\)AGAAAA
A(A
=AA@
=@
@
@(@H@z@33@@A@
=@@33@\@
@R@
=A A\AHARA  A{A@ffAA{@@@@
@@p@p@@@@33@=q@(@ff@p@A=qA\)A@\)@33@(A QAffAA(A
AHAAAAzAA
GA	A
=qA	AA
=A
{A
=A	GA
=A
HA\)A    AAHA	    A
{A (@{@AA
RA Q@{AAA\@A\)A
=A
A
{A	A	AQA\)@@@@33@(@@ff@@
@(@p@@@\)@@p@z@H@ff@
=@@@R@@{@Q@  @GA   AA\AffAAQAp@ffA A\AAApA\A{AAAAAAAQAAAA=qAARAffARAA\)ARA=qAGAA QA zAA   @@\)@@@Q@@A@
=@H@@p@33@33@G@\)@@@G@@\@
@z@
=@=q@@
@=q@33@R@@  @@
@@p@@G@@\@@@R@(@R@p@33@@@\@{@陚@@z@=q@@{@\)@@H@\)@@\@=q@Q@@ff@  @G@H@z@@\)A   A zA A AAAffA\)A
AzAAAApA A   A{A@
=@@@p@@\)@(@ff@=q@@@z@33@@H@@\@\)@@@@Q@陚@@{@
@
=@@@(@@Q@@ff@@@@R@R@  @  @陚@@@@{@
=@ff@z@@{@@\@@{@@@\@\@z@@@{@@\)@@@@@@@@=q@33@33@@G@=q@
@pA QAAGApApAAAA zA   A (@@@@ff@ff@
=@p@@{@=q@\@@\)@@33@ff@@@@@33@@{@  @z@{@@@
@
@@(@
@{@@z@=q@
=@@Q@@Q@@\@@H@\@R@\)@ff@R@@@@{@\)@@@@@z@G@@33@@@@
@@@@{@R@R@@@Q@G@@G@33@=q@
@33@@  @@
=@Q@@ff@@\)@  @  @R@G@\@33@z@@(A A=qAAGA=qAA AG@\)@{@(@@@@
@\@@\@@@p@
=@\)@\)@ff@\)@{@G@Q@(@@@=q@@@@\@p@@Q@{@@Q@@
=@ff@G@\@@@@\)@@=q@33@\@\@\@=q@\@\@@@z@p@R@
=@Q@G@\@(@
@{@R@@R@\)@@Q@(@(@@@@ff@@{@z@
@\)@Q@p@@33@@@\@H@=q@@
=@  @@@@33@
=@H@z@
@33@@@\)@(@p@@@
=@p@@@p@{@Q@(@@@\)@@p@
@33@=q@  @Q@p@=q@@H@p@\)@@\@(@@{@{@
=@\)@  @p@p@ff@\)@G@@@(@p@@p@@G@(@\)@
=@Q@
=@33@=q@@
=@(@@H@AA\AA33A z@
=A z@{@33@Q@{@33@{@ff@=q@ff@@=q@陚@G@H@@@(@{@
=@@
@@Q@  @ff@Q@R@\)@
=@33@
=@@H@(@p@@@@=q@p@@ٙ@G@  @@p@H@\@@@@@@R@R@\)@
@@{@@@@
@@@@  @(@@A\AGAAAA@
=@p@
@@{@@R@A A=qAAHA=qAGAAHARA
A(AzA(@A
pA	GA
@@Ap@GA z@33@
@R@A
AA
pAAAHA  @@@\)@@@p@@\A
{@z@@
=@=q@@G@\@@@@33@ff@@=q@@@  @\@@
@33@\)@\@@\@@޸R@33@H@@޸R@G@ff@Q@@=q@@  @ff@@
=@GA{A
=A
=A
AA
ff@@HA @\@(@
=@z@z@@R@{@
@z@@\)@@
=@
@=q@@
=@\@@ᙚ@@G@p@\)@
=@Q@Q@G@  @@Q@\)@=q@ڏ\@
@@p@p@  @ڏ\@z@=q@33@Q@
=@Q@Q@=q@G@G@@@@zA=qAA  AA A A\)AG@@@@(@H@  @R@
=@@@(@ff@=q@(@@@@@33@ff@p@\)@R@  @@@@=q@ff@
=@
=@{@ff@(@z@Q@{@
@H@R@  @p@H@@=q@@@H@
@H@z@=q@\@33@H@G@@=q@Q@=q@\)@{@
=@H@{@p@ff@R@Q@
=@  @ff@G@@33@Q@H@
=@{@陚@33@陚@p@@\@p@\@
@@
@
@@@
@(@@\)@@R@\)@@\@
@@@@@\@@\)@{@{@@@@(@@(@@
@
@@R@Q@@{@@@  @
=@ff@R@@  @R@p@p@33@(@33@z@
@(@(@@@ff@@
@@33@=q@@ff@@@G@
=@R@R@  @z@@{@  @33@
@z@@ff@@Q@@@33@z@=q@@\@
=@  @@@@33@(@(@@{A zAGAffAA
ApA=qAAQA	A
ffA	A
\A	AzAAA	A33AHAA(A   @@ff@G@@
@ff@(@@  @@p@33@p@{@zA@z@ff@p@z@@
=@@@
@=q@@@@Q@H@H@@@\@G@@@p@33@z@Q@=q@@(@
=@
=@Q@@H@
=@  A @@(@RARA@@@(A Q@
=A33A(ApARA=qA A  A33A (@\@{AGA\)A\)AAAA
A33A	AAzAA(AHA
A33AzAAGA\AG@z@A=q@\)A A\AA (AA QA AAffA=qApAGA A A (A   @p@H@{@R@RA (@G@
@Q@@@@  @@Q@(@(@G@@@G@@H@Q@Q@33@=q@R@{@{A{@
@RA{AA\)AzA
=AzA
=@
=@AA	A33AAHA
=A
A	pA\AA\)A=qAffARAzA
A
A  AA33A
A
ffA	A(AA(AAQA=qARA
HAQARA @@@  @QAffAHA Q@
=@ff@
@Q@@  @\@(@@{@
=@A A A @@\)@R@33@z@
@R@@
@33@@@A AAA=qA@G@A @HA   @{@H@ff@p@zA AffA
=A{A
=ARA(AQAAAA=qA
=AQA  A	GA	A  AA
=A
=A	GA
ffA\)A	A
AzA
RA(A	AAzAQAQA(AHA=qAA@
@
@ff@@@H@\@@@A   @@RA
=AA	GA
A
HAAz@A\A\AHApAp@A  @@@  @R@QAAffA\)ARAHAAAAffAzAffAA\AAA33A
A @(@R@H@H@G@33@(A QA\AAA\AffA\AffA\)A\)A33AHA
A33A\)A
=AA\)AAA  A  AA  A  A AQA\)AffAHA
A z@Q@\)@@@z@@陚@=q@陚@33@@R@33@  @@@@@@A (@p@ffAA\AffA@
=@@HA ARA A Q@\)@{@@@p@=q@@@@R@\)A(A(AzA	A	GA\)AAffAA=q@{@(@@
=@@(@z@@@p@ff@
=A (@Q@33@
@z@\)@
=@@=q@p@
=@
=A   AGAA
AAA\AffA zA A AARA (A   @\)A (@\)@R@陚@R@ff@{@
=@p@@H@Q@z@@@@(@@R@@  @@  @  @Q@@@p@=q@@z@@33@
=@
=@@
=@
=@@@R@p@p@=q@@@=q@@  @@@@33@
=@\@33@
@@G@G@@
=@@Q@G@=q@@@z@@
@(@33@p@@
@
=@ffA (A @@@\)@\)@\@@p@@\@@
@\@
=@@{@@G@  @  @\)@陚@@  @\)@R@=q@G@ᙚ@@ᙚ@\@z@@@߮@z@ᙚ@@=q@Ӆ@ָR@ff@ۅ@أ@  @@@
=@{@@\)@R@ff@@@{@陚@Q@@ff@H@H@=q@@33@
@@p@@(@
@@z@@@{@{@z@{@@@
=@\)@\)@G@\@@\@  @
=@@H@@33@@(@z@Q@
@33@\)@Q@ff@
=@@陚@
=@z@
=@Q@{@@@@ff@@@@R@陚@H@@G@陚@G@@G@\)@ff@@33@
=@@H@@
@{@p@p@@p@{@@z@p@\)@@p@Q@@{@\)@Q@@H@33@
A zAA(AAAHAGA=qA=qAQAGA
AAHA\)AA
=AffA{AAA	A
=A
=AGAAA	p@pApAGAA\A A QA QAAARA33AHA zA(AAA\A\)A
=AAHA Q@\)@A{A@@@
=@  @@33@(@33@H@@@
@33@@
@@z@H@H@@H@@\@H@z@33@(@@@p@z@\@\@33@p@@@(@H@z@=q@@ff@33@@AGA@H@\@(@R@{@H@(@  @@@{A A@G@@z@
@
@@
@@@@p@
=@@@R@\@@Q@陚@\@@ff@ff@\)@  @@@(@@A A(AzAAGAffAQ@A @A zA=q@
=@A   @R@@\@R@(@ff@R@A zA AGAAARAA\A\AA  AA=qAAAAAA=qA{ARA
=A(AAA  A  A QAA{AGA\A(A\)A	A
{AAA  A
AA
pA\AA\AA\A
A	@@\@R@@(@Q@33@=q@=q@H@@@33@  @@  @=q@@H@@p@AA@p@
=AGA33AzARAA{A@R@33@33@33@H@@RApARAAA  AARAHAffA A{AAA  AAAA  AAHA
A
AAA  AQApAAA{A
\AA	AA(AAQA
=AffA	GA\A
=AA\A\AA\AAAAffA @
=@p@@
@@G@ff@@ff@p@{@@z@@@@ᙚ@@
=@@@\@޸R@@
@p@=q@@{@@H@
=@@(@
=A QA AAffA
=AQAA
=A
HA	pARAAA
=A(AA
=AAzAA
AAQA	AAA	GA
{AA(A  A33ARAzAAApA ARAAGA@zAApA{A33A@RA (@{@p@pA A z@\)A (@@@@ff@p@@Q@@=q@p@@
@@\@@@@  @@陚@ff@
@33@@\)@p@33@z@@\@33@(@H@ff@@\)@  @@
=@G@  @
=@
=@@\)@  @@
=@@=q@=q@@@@@@
@@(@(@
@p@@@@@G@
=@\)@@@@R@=q@G@@@{@@\@@Q@Q@@R@
=@(@p@@\)@@@@33@@  @@(@@\)@=q@=q@(@=q@\@(@H@@R@p@@=q@p@@\)@
=@(@@@@Q@@G@33@p@
@  @@p@ff@@ff@\)@\)@
=@@\@
@z@p@
=@A   A A@@\A A A ApARA
A33AAAA  A=qA=qA\A@\)@
@33@
=@\)@@@(@{@p@@p@@{@33@\@z@@{@R@  @@@\@@p@{@
=@@Q@@@33@@@Q@p@@@@@=q@R@R@\)@@@
@ff@@@@@@@G@R@
@Q@z@
=@=q@p@z@RA (A AH@zA (A
pAA
GA  AA
A
ffA	AA
AA	A
=qA
RA
=qA	AARAffAAQAAA @{@@@@\@@\@
@@Q@  @Q@@R@{@ff@{@H@(@ff@@{@ff@  @@ff@@33@=q@ff@p@G@@\)@ff@@33@@@@@@\@@R@@  @  @@(@A @\@@{@AA zAA AffA{ARA33ARA
=AAA
A(AQA  AHAARARAAAzAAGA=qA
=AzAAGA  A@p@RA   @@z@@
@{@p@\)@ff@  @A (@Q@Q@@H@@H@p@
@@@p@@p@{@p@=q@33@(@
=@\)@  @R@  @Q@  @@
=@@
@@R@@{@@@߮@ff@  @@@ff@Q@G@33@A   @A33AA(A	GAAA33AQA
HAA(A
=A
{A
\A	A	pAA
\A
RA33A
A
GA\A(A(AA
AffA\A
AA
=A
=qAAQAA	A(A\)@ff@  @
=@@
=@@G@{@33@@z@ff@@{@ff@ffA\)A	A
=A33A
AA@A (@ff@@z@@@@@@{@{@p@33@(@@@Q@\)@p@@33@\@(@
@\@=q@  @z@H@z@
A QAAARARAA=qA  A
A
AA(A
\A  A
A
pAHA
=A
AAffAA  A
A
\A\)A33A\A
GAA	A
HAGA\@R@
=A
ARApAA (A @@ffA AA Q@
=@z@\@@@G@ff@H@33@z@@p@@H@\@@H@p@@@\@(@=q@Q@@@@@@H@(@ff@  @p@
@@@R@@ff@33@A (AApAA(AAA
=A=qA\A
A
ffA(A{A{A
AQA
AAAffAA(A\AAzAA\A
=A33A
AGAA
A
A(AAAAGAA	GA{A\)A33AAA  A
AA\A(A33@ffA z@@=q@@ff@G@
=@H@ff@R@AAffA{A AA QAA A A @ff@A (A   AGA (A A z@H@ff@@H@H@ff@\@@@\)@p@RARAAQAAGAAA
=AffARA
AAA	A
HA	A
\A
A
RA\)A\)A
A=qA
AAA\AQAAA{AAAAAA
A{AA{A\A@{@33@@33@\)@@\)@(@@AA   AffA
=A
AAApApAA@A@AffA{A A   @@=q@@
@@ff@p@@@@\A @
=A zApA{A=qA zA (@{A A\A(A\)ARA33AApAffAAHA33AHA
=A  A	A
{A  AAA
AffA
A\A
=ARA  A(AGAAAAGAA
A(A
A33ARAAAzAAzAQA
A
GAQA
AA	A
A
=A
AAAAAAA\)A  A(A\AHA
=A{AA{A A zAA{A=qAffA{A
=A\A@z@@R@
@
@
@H@(@  @@R@\)A A{ARA(A(A=qA(AA	AA	A	pA\A=qA
=@
=AA  A	AAAAA  A
A(AAA
AGAAAA(AAA\)AA\ARARA{A
pA
GAA  AA	A=qA\AzAQA @@@H@=q@=q@
@\@ff@33@R@Q@@@@H@=q@@{@@@@=qA@=q@ff@\)@
=@@@(@33@A AffA A
=A
A33A{AAA  AQA=qAHARA
=ApA{ARA
=AAzAQAAA
AA	A
HA
\A
HA
{A	A
\A
=qA	A	A	pAAAAHAzA{AAGA(AA z@@  @\@@\@R@ff@R@Q@  @ff@p@G@p@@@ff@@z@p@H@R@R@@\@@{@
=@@H@@@  @@@R@@H@ff@ff@\@\@\@@=q@
@G@{@@  @@@@Q@  @Q@\)@
@
@{@\)@@
@H@
@A AA@A AHA(AzA  A(A  ApA\A\AffA\)A{A AAA\)A33A@p@@@
=@@\@Q@߮@@@ۅ@=q@ڏ\@33@ۅ@(@H@߮@ff@{@
@@33@@
@@z@@\@@z@p@R@@Q@
=@H@z@ff@H@Q@{@R@G@RApA33A=qA33AGA
A(A\)A(AA(AAGA{AAHARAzA
ffA  AA  AzA{AAAAA\)AAA\AAA  AA
A33A
A @@
=@ApAp@@z@33@  @@\)@@\@@(@ڏ\@p@@{@ff@@(@߮@  @޸R@@ff@=q@G@@@@@@\@Q@@@p@\@@G@(@p@  @R@@R@@
=@R@33@33@z@p@=q@  @@Q@@@33@{@(@RApA=qAA33AAAA{A{AHAHARA33AAffAHAffA(A
=A
AAffAzA\)@@p@@
@{@R@@ff@@H@@@@@@=q@  @ff@p@@p@  @
=@33@@\)@{@@@
=@R@H@z@@(@@=q@@z@R@H@@@
=@z@@
@@@@ffA A zApAA
=A  AQA
A(A33ApAAffAzA	A
\A
=qAAQA
GAAGAAGA(AAAA{AAA
AzA
=A
=@R@@
@(@@
=@@  @ᙚ@
=@
=@߮@@
=@G@@R@Q@Q@\@@
@@z@
@@\)@(@=q@陚@{@@ff@@
@=q@\@G@@@
@@@@@G@G@陚@@p@@
@\@\@@R@p@33@@Q@=q@@@
@ff@
=@\)@z@p@@@33@{@ffAA{A\)A  A(ApAA
=A{AARA  @A AG@\)@@(@R@p@(@@ff@
@@H@Q@@\)@@{@@ᙚ@ff@33@@z@z@@@\@ff@@\)@@ff@=q@p@
@\)@{@@@Q@\@  @{@=q@33@\)@\)@\@ff@@z@ᙚ@
=@
@@@Q@H@=q@@G@\@Q@
=@@Q@@@Q@@ff@{@\@Q@@G@@@z@G@{@(@\)@G@@
@ff@@G@@ff@H@@H@@ff@=q@@
=@@=q@׮@@ٙ@ڏ\@{@G@z@@=q@  @33@33@ۅ@@ᙚ@@=q@޸R@ҏ\@
@\@(@ڏ\@ٙ@{@
@H@ٙ@Ӆ@ٙ@ۅ@ڏ\@@  @{@ָR@@  @p@=q@@(@Q@{@@@=q@ҏ\@@\)@
=@ff@׮@  @@G@G@(@
@p@@@޸R@Q@Q@
=@@z@ۅ@\)@z@ۅ@@p@
@
@@@  @
@Ϯ@G@@=q@{@׮@p@ff@ҏ\@H@\)@Ӆ@=q@\)@ff@
@θR@θR@Q@=q@(@p@@  @@  @z@@(@ʏ\@@@ff@
@  @  @@G@G@(@θR@ə@ҏ\@@@  @@\)@ff@  @љ@Ϯ@{@z@
@@ȣ@  @p@@{@H@{@љ@{@
@H@z@@ָR@@
@@33@ڏ\@z@@ڏ\@z@
=@@ᙚ@ᙚ@@ڏ\@=q@@@(@@
=@@ə@θR@@\@@@  @33@33@޸R@{@33@@߮@p@\)@H@  @@
=@33@@A (@{@G@@@(@H@@{@H@R@@@=q@A z@G@
=@@(@=q@\)@Å@Ǯ@@33@
@ə@ə@ə@33@@{@ff@У@Q@
@p@H@@z@G@=q@=q@G@  @ʏ\@@ƸR@@ə@(@˅@z@
@z@
@˅@=q@
@=q@33@ʏ\@ʏ\@G@@Q@ȣ@
=@@\)@=q@@Å@G@z@z@p@
@@p@\@\)@Q@@@\)@@@G@@@@Q@Q@H@@@@(@
@{@{@R@
=@\)@
=@{@33@@R@
=@R@p@@=q@@z@ƸR@ȣ@@θR@{@@ə@z@33@@  @  @ۅ@ָR@Ӆ@@=q@Ϯ@Q@θR@H@H@@Ϯ@\)@H@
@z@{@\)@ff@ff@G@z@p@ff@@\)@G@У@θR@θR@z@33@z@
@ʏ\@@ȣ@@  @33@@  @(@Q@@@
=@\)@@@ʏ\@ə@Q@Q@@ʏ\@H@ʏ\@=q@p@
=@@z@@Q@H@H@@=q@\@@  @\@G@Å@z@@
=@
=@p@ƸR@ƸR@
=@ff@ƸR@@@@ʏ\@˅@p@(@ff@Q@У@@(@@p@p@θR@{@
=@33@ָR@ٙ@@@@ָR@ff@ff@(@
=@Ϯ@@p@z@@33@
=@p@33@\@(@
@\@\)@@@G@=q@@G@  @  @\)@@
@33@\@(@=q@\@=q@33@@@@
@@
@
@=q@z@H@G@@  @ff@\)@  @@G@G@\@Å@33@\)@@{@@{@
=@˅@G@\)@
=@@33@33@@  @
=@Ϯ@@љ@ff@ff@@  @љ@ҏ\@@\)@@Ϯ@p@\)@ҏ\@Ϯ@\)@=q@@=q@=q@@=q@@
=@p@
=@Q@ҏ\@=q@H@@
@љ@љ@У@@33@33@@ȣ@У@G@
=@
@ʏ\@ə@@ə@z@@z@33@@θR@ff@{@{@  @G@  @
=@p@@
=@@@ʏ\@@@p@ff@=q@=q@p@\)@  @ff@ff@Q@\)@Ϯ@\)@=q@љ@(@
@p@θR@
=@Ϯ@\)@\)@@ff@@{@ʏ\@(@@H@{@θR@У@G@=q@љ@ҏ\@z@
@ҏ\@ҏ\@@G@Q@Ϯ@
=@θR@z@
@
@@@  @p@ə@Q@ff@{@z@33@z@
@=q@=q@Å@Å@(@Å@
@33@z@@{@ȣ@Ǯ@G@ff@Ǯ@  @=q@@ə@@@G@@  @@@\)@Q@Q@ȣ@G@ə@@@Ǯ@
=@ə@Q@@ʏ\@˅@z@\)@
=@У@33@z@p@p@ff@ff@Ӆ@=q@@(@z@=q@  @@ff@  @Q@@@\)@ff@޸R@z@޸R@Q@ᙚ@Q@@(@@33@@@=q@G@\@@߮@  @G@\)@@p@@  @ff@ff@p@p@(@(@  @@@{@@Ϯ@G@\)@  @33@33@p@@{@{@p@(@ҏ\@G@љ@z@ʏ\@\)@@33@(@{@(@R@@33@@=q@@R@@z@
@ȣ@@p@G@\)@Ϯ@\)@θR@
=@G@@=q@H@z@ff@(@
=@G@=q@@߮@33@33@@@G@H@H@ff@ʏ\@  @G@p@@\)@@p@z@@@@љ@{@G@ff@@
=@
@@(@@33@=q@
@@@@@@(@ȣ@@Å@@33@p@\@ff@@\)@@{@\)@@ff@z@@\@33@
@@ƸR@@  @Q@p@@ƸR@ə@@z@@33@@@@Ϯ@ȣ@(@@ff@@@У@@@љ@{@33@˅@@H@G@{@=q@\)@
=@z@{@  @@(@\@@Ǯ@=q@ə@=q@ʏ\@G@
@@H@@p@@z@
@{@H@˅@@@Ǯ@(@\)@{@H@{@@(@Å@\@z@33@\@=q@(@@ƸR@
@
@˅@ʏ\@Ǯ@ff@@G@(@@{@(@  @
@Å@@ff@@z@@Ǯ@  @ƸR@
@H@@
=@@(@Ϯ@@@H@33@θR@H@˅@Q@G@H@
@@ff@
=@
@=q@ʏ\@@@У@@Ӆ@Ϯ@@ə@p@=q@G@z@@Ӆ@@@G@  @H@ff@p@{@љ@
=@У@Ϯ@=q@ff@@أ@@ff@@@ڏ\@@
=@p@G@H@
=@G@@ۅ@˅@@Ӆ@=q@  @
=@{@У@
@θR@=q@p@@33@\)@z@@z@@Q@\)@  @p@
=@Q@ff@
=@ə@\)@G@ȣ@ff@Q@33@=q@ə@  @p@@33@H@33@ff@Q@\)@Ǯ@Ǯ@\)@(@=q@=q@G@ə@\)@@@@\@33@H@@\@@@\@=q@@@33@@@@G@@
=@  @@R@{@ff@R@Q@@Q@H@ff@ƸR@
=@  @ff@
=@{@@p@@Ǯ@{@(@
@
@@z@@@\)@
=@ff@\)@p@@{@@
=@@ƸR@@p@
@z@˅@p@H@@@Q@G@z@
@=q@ٙ@
@H@
@{@=q@@=q@  @=q@
=@أ@
=@33@У@{@@@
@\@@\@R@G@(@@
=@Å@@@
=@@˅@p@33@H@\)@
=@@@Å@33@
@G@
@G@33@
=@\)@p@@H@@(@H@\)@\@=q@Q@@ȣ@@ƸR@33@(@Ǯ@ȣ@  @˅@ə@p@p@@@@@
=@
=@  @Ǯ@  @=q@@(@Ϯ@\)@@@z@z@{@{@(@
=@  @Q@{@׮@p@@33@@  @{@ƸR@@p@ʏ\@θR@
@@ʏ\@ə@ʏ\@ȣ@@\)@z@z@H@z@z@Ǯ@ƸR@ƸR@@Ǯ@\@R@@
=@p@p@
@33@\)@p@z@R@(@p@@Q@@@\@z@=q@@@  @{@H@@z@
@@@@@@@z@
=@\)@\@@ff@Å@p@@Ǯ@@@@@@{@\)@@=q@Q@H@@@(@  @p@@@@@У@@˅@H@љ@ff@
@H@H@z@@@G@33@@@θR@G@ff@@ff@G@{@@G@@=q@=q@(@Å@@@{@@Q@@\)@z@ʏ\@@@@@@Å@Å@ƸR@ȣ@{@{@\)@p@Ǯ@@
=@(@@@@R@
@Q@(@@H@z@33@@@z@@
=@\@H@(@G@z@@H@H@G@R@@@33@{@R@@H@@@
=@33@z@p@ff@љ@@@@Ǯ@ə@(@Å@@(@
@\@@ʏ\@33@  @Q@ʏ\@Q@(@ff@@Å@  @\)@G@@@{@p@=q@@Q@\)@H@ff@Q@
@G@
=@{@p@@@@  @Q@@{@@@33@\)@@@  @ff@
@p@=q@R@Q@@@@
@
@p@  @z@=q@ƸR@
=@@@Q@ə@Q@ȣ@Ǯ@@33@ə@{@33@ƸR@G@
@ff@@33@H@{@@ƸR@Q@=q@@(@(@@  @@=q@@@G@Q@Å@  @@G@@@{@@{@@@H@@p@
=@@\)@@@  @R@z@ff@@G@ff@Q@\)@=q@R@@@Q@
=@@@R@ff@H@z@@H@=q@Q@G@@Q@@33@@@Å@@ff@R@33@@(@@ff@@H@  @\)@Å@  @Q@\)@\)@\)@R@@{@\@H@33@@@@@@Q@@Q@Q@\)@@@@  @
=@@  @z@@G@@  @@@@  @@@@=q@
@(@z@  @{@@@@@  @
@@@@@  @
=@@=q@G@33@=q@R@@@@z@{@{@\)@@G@33@@\)@  @@=q@
=@
@@ff@33@@{@z@
@  @@z@G@@
@p@33@
=@@p@R@
=@@33@\@
@z@@@@\)@@\)@Q@\)@@Q@@\@Q@@@R@{@33@=q@@@=q@ff@@R@@@\@(@=q@=q@33@
@33@H@\)@R@
=@@=q@G@H@ff@@@
=@@  @@{@  @@ff@@@33@ff@(@@\)@G@H@@@ff@G@
=@@33@@
@(@@G@G@H@
=@  @\@\@H@Q@@@
@z@H@H@G@@  @@
=@@z@@=q@z@ff@  @@\@(@p@@@  @@@(@
=@@@z@@@  @@\@
@@@@@@@{@Q@{@@
@\)@@@R@{@@33@
=@p@@@@ff@@@\)@G@  @ff@@@
=@@\@@@R@Q@H@@@{@@H@
@@@=q@@{@Q@
=@H@{@@=q@H@@33@@@
=@@
=@33@@p@@@33@
@@33@33@  @@ff@\)@@z@@@ff@@H@\@  @@(@(@G@@G@R@
@G@@R@
=@z@33@G@ff@R@@@
@=q@
@z@  @@
=@@@@
@z@33@@\)@G@=q@@\)@R@R@
=@Q@  @@@@ff@R@33@
=@ff@R@(@p@@Q@Q@33@H@Q@G@@@=q@@@33@  @H@ff@33@  @@(@@ff@@
=@{@ff@\)@@
@@z@ff@@p@Q@
=@\)@H@{@@  @@@@@@
@z@{@@@(@H@H@
@\@\@@@(@=q@@@33@
@Q@@(@H@\@G@@{@p@@@@z@ff@33@@\@@@@@@@@@
@{@
@@=q@  @@@p@H@@  @\)@@z@{@p@z@p@@z@@@@H@@@
@{@
=@@  @=q@
=@@R@@H@H@@ff@~R@~{@@G@{@G@  @  @  @@@R@ff@33@=q@33@  @33@p@
=@R@\@
@=q@(@G@=q@H@@p@@\)@@@@@@@33@
=@Q@p@@@33@@
@Q@@{@(@@ff@@(@@H@|@|@@@@@p@@@p@{@R@@H@p@33@\)@~R@Q@R@G@@p@ff@
=@G@
=@  @=q@@@33@\@@@=q@G@@=q@Q@z@33@\@\@@@@@{@
@p@{@@(@p@@u@q@w
=@}p@w@xQ@\)@\@z@k@p@u@y@|@|@@@  @Q@@33@@=q@R@{@p@\)@ff@\)@@@@R@{@@=q@@|@\)@~R@
=@33@o\)@s33@nR@vff@z=q@xQ@u@o\)@u@w@Q@y@G@@H@33@jH@nR@vff@{@~{@@(@(@R@R@@p@G@@G@Q@@
@=q@@@  @@ff@G@R@R@
=@G@zH@\)@H@Q@@{@@  @@z@H@Q@@@@\@\@(@@Q@\@(@G@(@|@~R@(@  @@@@@\)@  @=q@@=q@p@H@@z@
@
@@
@@33@G@(@
@}p@zH@{@~R@w@|(@w
=@x@qG@s33@nR@aG@\(@^R@h@q@s
@mp@p  @l(@h@k@tz@s
@u@tz@l(@aG@b\@_\)@nR@jH@g@jH@xQ@vff@y@y@s
@{@u@@u@xQ@y@x@u@xQ@y@33@@
@zH@{@Q@~{@|(@
@zH@xQ@|@p  @e@e@_\)@jH@qG@mp@k@i@hQ@jH@fff@aG@e@hQ@h@fff@u@\(@^R@\@]p@XQ@_\)@g
=@XQ@]p@`  @^{@^{@p@|(@g
=@jH@jH@p@o\)@r\@u@s
@s33@nR@u@|@g@g
=@j=q@=q@{@~R@nR@j=q@nR@x@\)@@\@p@@p@w@~{@Q@zH@g@aG@^R@a@]p@c33@c
@mp@nR@j=q@}p@l@j=q@jH@l@mp@s
@i@o\)@q@r\@|(@qG@s33@y@@@~R@|(@~{@^R@S
@U@]p@c33@`  @c
@i@j=q@dz@`@\@`@\(@R\@JH@?\)@B\@H@Vff@R\@Z=q@X@HQ@AG@ZH@dz@e@jH@o\)@c
@e@c33@h@e@h@q@G@@|(@nR@jH@jH@o\)@xQ@~{@
=@@p@G@ff@G@H@H@
@R@=q@=q@\@@z@=q@@
=@\@ff@@\@(@
@Q@@@\)@H@ff@\)@p@~{@n{@s
@~{@tz@i@o\)@n{@^{@c
@l(@hQ@jH@ZH@aG@@qG@U@_\)@b\@n{@r\@qG@nR@k@qG@tz@p  @qG@w
=@zH@vff@qG@w
=@aG@hQ@c33@\@^{@b\@c
@tz@q@w
=@xQ@p@r\@p  @o\)@w
=@zH@  @~{@p@H@@Q@`  @[@ZH@s33@@@@R@(@@@  @{@ff@@@@ff@@@(@@@=q@Q@\)@33@
@@
=@@@=q@@@~{@~{@@@G@
@|@l@Y@^{@\(@X@JH@<@AG@AG@B\@JH@Dz@E@8@:H@:H@@  @?\)@8Q@5@4z@<@6ff@2\@2\@!@@#33@(@5@@@B\@C33@7@1G@=p@G
=@K@N{@1@<(@H@Fff@Dz@AG@I@Q@G
=@?\)@L@O\)@^R@W@e@c
@E@7
=@AG@O\)@NR@b\@p@}p@}p@~{@u@zH@zH@u@@zH@33@jH@^R@[@dz@p  @ZH@XQ@Fff@<(@3
@%@p@@.{@0  @,@(@R@=q@H@@Q@(@)@!@Q@
=@ff@@\)@@ff@=q@$z@H@z@@@  @R@G@33@  @
=@
p@
=@@
H@?H@G@G@@
=q@(@  @
=@ff@z@@R@?R@?R@\@33@z@R@R@+@3
@$z@!@'@333@A@E@G
=@Dz@HQ@W@K@NR@<(@B\@Tz@e@Fff@Dz@Q@G@Fff@AG@>R@:H@H@Vff@B\@.{@+@4z@#
@1G@"\@ @\)@#
@*H@ @#33@-p@'@
=@@=q@@\)@  @@
p@
@*=q@'@(Q@(@'@,@8Q@8Q@NR@5@;@;@@  @'@1@,@+@.{@*H@*=q@%@.{@+@/\)@2\@8Q@:H@9@Tz@g@]p@aG@Vff@Vff@h@x@p  @o\)@`  @dz@hQ@i@g@r\@|(@@
@z@@G@w@\@Q@~{@~R@xQ@z=q@s33@Z=q@k@i@U@ZH@`  @Mp@:H@=p@A@Fff@C
@G@B\@>R@@@C33@P  @K@E@O\)@Fff@C
@HQ@I@O\)@C
@E@;@9@<@>R@B\@C33@JH@C
@A@A@H@HQ@Q@K@G
=@I@L(@S33@\(@JH@8@2\@:=q@;@Fff@=p@@  @W
=@J=q@W@mp@s
@|@k@p  @G@~R@
@  @(@
@(@(@\@}p@=q@@@\)@  @z@@(@@(@
=@ff@{@@ff@ff@@@Q@Q@@G@
=@p@(@~{@@nR@o\)@h@n{@nR@|(@\)@|@w
=@aG@X@dz@x@
=@i@Q@HQ@Mp@N{@Y@l(@U@W@S33@G
=@Dz@Q@P@N{@J=q@E@AG@8@+@1@8Q@333@<@HQ@L(@8@7
=@:H@.{@5@:H@5@B\@<@E@>R@S33@P@S33@K@ZH@N{@QG@]p@dz@c
@(@hQ@h@l@jH@W@fff@q@w
=@xQ@}p@`  @[@XQ@E@5@:=q@JH@JH@\@XQ@XQ@l(@s
@l@c33@r\@u@l@z=q@g@s
@_\)@`  @S33@K@s
@S
@e@j=q@^{@vff@z=q@h@w@NR@Dz@C
@.{@8Q@K@1G@6ff@3
@333@N{@U@`  @XQ@Y@l@q@xQ@o\)@e@l@q@i@]p@NR@G@`  @QG@Tz@K@JH@HQ@U@c33@|(@tz@\)@qG@qG@n{@g
=@|@q@vff@w
=@ff@33@z=q@jH@c
@{@
@@R@@R@ff@{@33@Q@{@=q@{@@  @w
=@x@|(@|(@qG@Y@A@Mp@B\@Mp@Q@:=q@7
=@!G@'
=@#
@(@{@I@<@@  @C33@e@QG@S33@Fff@W
=@_\)@G@B\@Dz@H@QG@U@X@U@K@I@AG@L@C
@>{@P  @C
@@  @@  @`  @Vff@7@4z@i@_\)@Y@X@HQ@JH@U@XQ@W
=@^{@U@`@\@g
=@c
@e@c33@a@tz@z=q@y@Q@p  @u@G@\@(@r\@@@@H@G@\)@@@\@p  @\)@@
=@p@
@H@@33@H@|@
=@
@{@33@@@@Q@~R@~R@vff@o\)@j=q@a@dz@qG@N{@Vff@b\@aG@b\@s
@w@g@r\@|@p  @xQ@\@@z=q@p@x@
@n{@dz@l(@c
@l(@fff@aG@hQ@J=q@Fff@=p@Tz@L@G
=@E@E@K@JH@R\@ZH@`  @nR@p@u@o\)@l@fff@g
=@l@qG@`@X@p@w@@{@{@Q@mp@\@\)@jH@l(@|(@  @=q@@@{@(@@
=@@@ff@~{@\)@
@{@{@zH@G@@e@c33@X@L@G@L(@NR@Vff@@@>R@>R@<@.{@;@/\)@(Q@#33@#33@,(@=p@I@L@Vff@R\@QG@S
@Z=q@e@Y@K@U@E@S
@P@NR@Dz@G
=@NR@HQ@H@@  @4z@-p@5@?\)@@  @.R@3
@A@L(@C
@4z@E@I@W
=@g
=@c
@X@Q@A@:=q@@@E@O\)@]p@h@p@s33@xQ@ZH@Tz@`@P@XQ@h@o\)@~{@}p@@\)@G@i@l@c33@~R@x@Q@\)@q@n{@mp@y@u@g@Z=q@AG@:=q@`  @R\@S33@S33@NR@NR@HQ@E@HQ@L@A@I@H@L(@I@U@QG@Fff@U@P@jH@W
=@J=q@X@Fff@G@P  @I@O\)@>R@AG@@@@@B\@P  @A@Dz@7@5@<(@HQ@R\@P@O\)@AG@NR@G
=@:H@;@<@E@<(@?\)@<@+@(@/\)@333@5@.{@5@AG@G@AG@:=q@A@<(@C
@Dz@Vff@@@L(@G
=@C33@L(@B\@5@7@7@Mp@AG@AG@:=q@<(@H@ZH@S33@C33@.{@#33@)@{@@@(@p@\@@H@#
@*=q@'@&ff@.R@0@'@%@   @@  @7
=@<@<(@<(@C
@=p@7
=@8Q@2\@,(@C33@'@%@"\@(@,@#
@p@ @*=q@,(@!G@%@!G@@
=@H@   @'@@\)@!@%@0  @(Q@)@+@6ff@=p@E@%@)@333@2\@:H@9@3
@7@A@8Q@8@8Q@;@@@<(@P@G
=@C
@>R@E@E@B\@J=q@>R@7
=@333@2\@333@0  @E@G@H@p  @U@L(@Fff@.R@5@:H@>{@G@5@.R@3
@.R@<@1G@-p@R@.R@!G@.R@K@P@L(@L(@G@>{@<(@C33@>{@7
=@&ff@0@3
@7
=@1G@2\@-p@(Q@1G@@@AG@G
=@C33@R\@?\)@E@L@W
=@QG@Q@QG@L@I@G@H@>R@<@Dz@<@7@?\)@1G@R@R@!@(@;@@  @;@;@@  @<(@Q@Q@Vff@P  @C33@Fff@E@8@ @&ff@6ff@@!@@=q@=q@ff@=q@@#
@E@5@9@I@'
=@/\)@"\@+@0@,(@,(@*=q@R@@!@@\)@%@   @)@.R@$z@%@%@p@'@"\@{@!@!G@/\)@!@@!@
=@ff@\@\)@@
=@p@%@\@
@ @Q@@z@=q@H@#33@%@#
@
=@@*H@%@!G@(Q@#33@%@(@,@R@R@@z@z@@@@R@!@1G@.{@.{@.{@.{@   @\)@R@ff@33@Q@z@Q@R@	@@
=@
@'
=@@(Q@.{@1@7
=@%@+@/\)@,@,(@5@.{@,@/\)@HQ@@@"\@2\@E@5@.R@@\@(@{@   @&ff@@
=q@H@@{?
=?@G@@?Q?p@33?@Q@@@	@
@ff@\)@@
@@@ff@@\@ff@@\@=q@\@R@33@
@33@@	@@
p@@G@(@@@
p@  @G@(@G@@ff@@\)@
=@\@ff@@ @!G@
@@@@@H@
@@@Q@{@{@@   @
@ff@R@\)@G@  @\)?Q@@@@@
H@z@z@(@@R@  @33@@@@z@Q?R@z@@
=@@{@  @
=@\)@\)@$z@p@!@@@#33@'
=@$z@,@@  @\)@Q@@@\@(Q@333@:H@2\@,@'@,(@@&ff@*H@*=q@(Q@p@
=@\@@\)@,@$z@%@H@'
=@,(@#33@&ff@!G@$z@0@2\@)@,@1@1@#
@)@,@-p@\)@@   @*H@*=q@%@"\@#33@
=@ff@{@@  @'@0  @6ff@333@*=q@"\@@\@p@(@&ff@
=@@@
=q@!@$z@p@%@1@.R@AG@8Q@/\)@1G@J=q@K@%@33@\)@#33@333@8Q@6ff@@  @;@Fff@P  @HQ@\@R\@N{@QG@Fff@`  @b\@s33@r\@hQ@`  @e@c
@NR@C33@N{@HQ@W
=@P  @NR@Z=q@g
=@aG@X@W
=@R\@K@C
@HQ@G@@  @Fff@L(@aG@ZH@J=q@1G@3
@9@8@:H@AG@G@0@&ff@H@{@#33@'@+@6ff@>{@N{@6ff@4z@6ff@@  @E@@@@@!G@#
@%@(@4z@>{@<@C
@JH@JH@3
@,(@.{@8@B\@J=q@P@J=q@JH@U@L(@E@H@G@XQ@Dz@XQ@_\)@X@NR@p@y@w@p  @]p@S
@JH@QG@\(@]p@O\)@\@W@QG@Dz@E@JH@B\@_\)@W@g@^{@B\@N{@Vff@\(@W
=@L(@AG@G@Y@hQ@[@^{@[@p@@l@h@h@Vff@c
@`@c33@P@L@[@[@aG@c33@S
@Tz@Tz@^R@l(@a@P@O\)@L(@B\@?\)@:=q@6ff@AG@L@N{@HQ@K@ZH@:H@=p@'@,(@.{@;@J=q@A@8@8@>{@6ff@9@E@XQ@HQ@<@H@>R@;@=p@C33@?\)@Fff@L@N{@Tz@^{@B\@O\)@W
=@\@]p@n{@Q@(@}p@@}p@o\)@u@mp@o\)@s
@p@dz@g@fff@jH@XQ@ZH@W
=@HQ@QG@Mp@XQ@o\)@\@@u@r\@h@h@}p@|(@s
@i@tz@Q@QG@N{@C33@W@JH@Mp@XQ@@@I@XQ@a@N{@H@@  @<@L@HQ@C33@I@J=q@:H@A@H@=p@>{@A@=p@Dz@Fff@JH@H@QG@L(@U@Tz@\@b\@^{@\@Vff@R\@G@>R@G
=@U@Vff@l(@dz@w
=@\)@z=q@Q@33@r\@h@p  @zH@~R@|@z=q@H@|(@i@`@dz@o\)@q@n{@vff@tz@g@jH@\@e@`@a@O\)@Fff@Y@E@AG@P  @\(@\(@_\)@aG@ZH@aG@`  @^{@j=q@Vff@XQ@c33@e@U@X@J=q@_\)@G
=@NR@O\)@k@h@`  @NR@O\)@L(@ZH@e@b\@?\)@@@Dz@G
=@G
=@AG@8@'@,@5@8Q@<(@Dz@?\)@2\@@  @>R@G
=@C
@Q@R\@Tz@\(@g@g@j=q@l@nR@S33@J=q@R\@W
=@`@\@W
=@`  @^R@jH@\(@g@mp@r\@[@_\)@S
@Q@L@Dz@L(@e@Mp@^R@\(@aG@X@]p@S
@X@Y@Y@hQ@xQ@z=q@r\@e@]p@U@^R@@@G@C
@HQ@h@\(@XQ@^{@S33@`  @`  @vff@e@G
=@6ff@5@P  @HQ@E@Dz@C33@Dz@+@(@%@R@*H@,@5@5@5@C
@>{@<@,(@*=q@(Q@'@(@1G@E@NR@Q@O\)@W
=@S
@U@I@L@Vff@G
=@C
@8Q@0  @7@=p@Q@X@JH@U@P  @C33@;@>{@9@3
@=p@(Q@1@7
=@>{@>R@7
=@>{@:H@2\@Q@(@
=q@#
@(@W
=@E@0  @.R@333@0@1G@"\@Q@@33@@p@@\@   @{@"\@ff@"\@(@@?p?p@ff@   @
@??33?z@G@
@???  ?  ??R@\)@z@@
@@
=q@33@"\@
@(?p?{@\@
=@\)@ @\)@-p@5@9@AG@E@J=q@H@]p@U@y@c33@?\)@\@c
@c33@dz@`  @g
=@g@QG@@~R@e@c
@`  @c33@^R@`  @nR@w
=@tz@U@HQ@XQ@R\@R\@R\@I@@  @B\@5@B\@Dz@@  @<(@8Q@G@;@Dz@7@-p@7@G@L@L@O\)@o\)@S
@!@#
@.{@>R@XQ@\@aG@b\@`@Y@K@:=q@J=q@C33@L(@P@NR@>R@L(@U@N{@Y@\@`@^R@]p@qG@g@hQ@x@
=@@@H@ff@@@@
=@  @p@e@n{@p  @z=q@{@r\@tz@s
@aG@aG@`  @H@XQ@QG@JH@L(@<@8@B\@Fff@Fff@I@[@Y@U@Dz@)@8Q@XQ@5@,(@)@,(@1G@7
=@NR@\(@c33@fff@g
=@c33@a@h@}p@e@S
@U@Y@L(@>{@C
@>{@0  @9@U@@  @333@1@:=q@L@J=q@Fff@P@?\)@N{@e@i@QG@Fff@,(@@5@@@I@S
@r\@y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @@@p@G@@@@\)@{@\)@\@33Ap@HARA
=A33AA33A\)AA
=AAA33A"=qA A   AAAGA\A\)A AAHA (A   A
=AA33AffApAAAGAQAA{AA  @
@
A @\)@@
@(@H@@@Q@@
=@33@  @=q@G@A33Ap@Q@{@ff@
@@
=@@(@@33A   @G@(@R@G@@@(AHA\AHAAzAHAA  A=qA
AAHA\AAAAA$(A"=qA'A zA\A33AzAA(AA
=AAQAAA	A\)A  AAA   A(A\AA\)AGA
=A{AQA   A
=AA  AHA  AAQARA	A	AA
=A
AAA  A	AARAzAA
=@\)@ff@@@R@z@  @=q@A=qApA=qA{A\)AA\)A  A
=AffA33AAAGAAzAAffAAzAQAAAAApA{AGA  AA\)AAzAffA
A
=A  A{AA@@@AffA
AAff@@
=@(A   A (@(@ff@33@@(@Q@G@H@@G@=q@
@(@ff@@Q@
=@޸R@ڏ\@@\)@@Q@
=@ff@A\)ApA  AAAAffA33A
AzA
A
AA	pA	A
{AAA
=A  AHAAAAAAAAA
=AQAffA
A
AzA
=A{A(AAA33A   A=qA\@@33@\)@33@
@33AffAA\)A
=AQAA z@(@ff@\@
@@
@@\)A   @@z@@@@ff@\)@\@\@G@Q@@H@\)@@
=@z@z@@33@z@@p@@{@AGA=qA\)AA
=AAffA
A\)AQAAffA	pA
HAQA
RAA
pA\)AzAAAApAffAA\)AQA\)AzA(A(AzA(AA	GARA  AA   @G@@RA(@z@=q@  @@H@ff@p@@@A Q@\)@GA@(ApA z@H@(@\)@=q@Q@  @@@G@Q@@@@  @߮@\@H@
@33@@@@@\)@33@@@@
@@@@ffAA{A(A	A
AAAAHA33AA=qARAzAffAA
GAAQAHAffA
AzAA33A  @{A QA A\)A @{@\)AffAAA
=AA{@A Q@G@\)@33@@=q@ff@@
=@\)@=q@@{@@
@@{@@\)@@@  @G@p@@\@@H@z@G@  @33@\)@@{@(AAAHAQA
AA	A  A
GA33AAAAGAAAA
=AHA!A$(A%A%GA$A-A/
A+33A(QAA.ffAA
=A%pAzAAffAHA\)A (A{AAffA(A A#AA=qAAGA=qAffA\)A
A
\A
=AffA
{AA=qA
A	A33AA\AffA
AQAA
A33A
HA33A AG@@  @R@H@(@G@R@\)@H@H@33A@{@  @ff@
AGAA A ApAff@Q@H@@@33@@33@@(@H@@@@Q@@=qAzARAffA\@=qAA
AQA\)A=qAAQA=qA (@@@Q@@{@
@R@@@@G@(@@G@ᙚ@
@(@
@=q@p@ָR@=q@ff@Q@Q@@H@@G@Ӆ@У@\)@  @ҏ\@Ӆ@(@@Ӆ@(@z@{@
=@G@
=@ff@{@@
=A @33@(@陚@ff@R@
@@@G@@ᙚ@\)@޸R@z@@z@z@
@(@(@33@@(@@@z@
=@@@߮@߮@޸R@@(@@
@ٙ@
@H@
=@׮@׮@Q@  @Q@Q@Q@@ٙ@Q@ָR@=q@ۅ@޸R@  @@߮@Q@ᙚ@@G@\)@@@=q@@Q@
=@ff@ָR@ff@@@(@@@p@Q@׮@{@ָR@ָR@Q@@ff@ᙚ@Q@{@޸R@=q@33@33@z@z@z@@@\@
@{@Q@@z@\@R@{@R@@@
@@@@@@@(@@=q@Q@@Q@p@  @ᙚ@@@@@z@
@Q@  @  @@H@=q@@@G@@@߮@  @
=@ff@@{@
=@@(@p@Q@@Q@
=@@ᙚ@@G@@@Q@\@@ᙚ@  @@Q@ᙚ@陚@
=@
=@33@R@33@p@{@{@@33@H@
=@33@G@\@z@{@{ARA(AAzA@(@@(A
GA  @G@33A@R@33@陚@{@{@{@@ff@@ᙚ@@@ff@R@(@(@ᙚ@ff@p@z@33@ڏ\@ڏ\@ڏ\@=q@ۅ@Q@@@{@ff@H@ff@\)@@@@p@ҏ\@ҏ\@Q@@Ϯ@@Ӆ@ff@@ff@@@ۅ@
=@\)@G@ff@z@@@  @@z@@  @@  @{@@@=q@=q@z@@@R@@@ff@\@H@
@@=q@{@\)@H@\@\@H@Q@R@@(@  @ff@@@
@ff@\)@@
=@@z@=q@=q@=q@=q@
=@Q@p@(@@\)@@(@@=q@ff@@(@@@=q@  @
=@p@(@ڏ\@33@H@@z@H@@G@@
@(@љ@G@=q@ٙ@{@(@ff@33@{@H@H@(@p@{@@H@z@@{@@33@{@ff@p@@@H@A AA@{AHAAQA  @@@@G@33@@
@{@
=@z@\)@\)@ff@\@@@p@=q@
=@33@\)@@
=@ᙚ@G@@@p@@ٙ@׮@@H@@33@(@z@=q@ٙ@ۅ@H@z@@{@
=@{@
=@
=@
=@R@R@p@@@Q@@  @@z@@
@@H@R@
@G@
=@@@H@@zA Q@A(AzAA33A
=AA=qA{A
AA
AAAA\AHA	ApA
HA{@AG@@33AQA
p@R@@@@G@\)@\)@  @p@  @=q@@R@AG@\)@z@
@߮@߮@ff@  @H@@
=@@@\@33@G@R@@Q@33@H@@@(A A @{A   A33AARA
AA
@A\A	A
A=qA
A	GApAAHAz@(A A
A
AAAG@A\AHA   A\)AzA
=qA(AzA
=AAAAzA
A{AA@
=@@@R@Q@\A
AzAA	pARAR@@@ff@Q@p@p@AApAzAAAAA AAA @ffA A (@pA z@  @@
=@
@A\A Q@@(@A@A (@{@@(A   @QA @
=@z@p@p@@ff@H@33@@@ff@z@@A\AA33AGAHA
=AQA(ARA\)A\)A
AzA	A	A	A	A	pA	AzA
=AzARA\)AffAG@
=@=q@(@R@@@
@@A @p@(@H@Q@@陚@H@z@ff@@@@\)@@ff@\)@G@RA A\)@@@H@R@{@=q@p@\@G@\@@=q@@@QA@G@  @Q@\@G@AAff@@@ۅ@ff@\@
@ff@@(@
=@{@{@߮@
@\)@R@z@@
=@  @@(@\@@@\)@\)@
=@ٙ@H@z@߮@ff@  @@@@  @G@\@ᙚ@\)@@{@\)@ff@
=@߮@{@H@H@@ۅ@ڏ\@z@H@Q@أ@ٙ@\)@أ@ff@@{@p@33@z@Ӆ@ҏ\@33@33@ҏ\@33@Ӆ@
@33@G@\)@@ʏ\@z@33@Q@z@H@@ȣ@\@
=@@Q@H@{@ʏ\@ʏ\@@ȣ@Å@Å@  @Q@{@@
@Å@@(@
@{@=q@=q@(@(@(@(@@33@(@z@H@
=@ff@33@
@33@33@=q@
@
@׮@@p@@@أ@ٙ@ff@p@p@{@ٙ@@@ٙ@@H@  @@33@ۅ@ٙ@H@׮@33@ۅ@@@33@Q@׮@Q@\)@\)@@
=@H@@׮@@p@@z@H@G@ۅ@G@G@p@ָR@
@p@z@z@H@p@H@z@{@@@@أ@\)@@\)@@=q@H@33@
@ۅ@{@  @G@(@@@@{@R@p@@@ff@  @@\@@G@=q@@\)@=q@
@@H@@=q@\)@@=q@  @
@ٙ@߮@޸R@޸R@33@ff@z@@@H@=q@ٙ@=q@H@ڏ\@H@H@p@@@@@
@33@@G@
=@(@(@
=@{@  @(@  @Ӆ@ҏ\@Q@أ@ff@ٙ@ff@ۅ@G@@@33@ff@޸R@@  @33@@p@@z@z@p@p@@{@{@
=@R@R@@\)@z@  @@G@@G@@
=@@\)@\)@R@\)@ff@ff@@z@@p@p@@(@(@@33@H@H@33@@\@33@(@Q@\)@\)@=q@(@G@=q@=q@\)@  @z@ۅ@33@G@@
@33@H@H@=q@أ@  @G@33@@
@ۅ@33@(@(@@@@(@׮@@{@
=@=q@@@  @\@\@G@ᙚ@H@G@ᙚ@@@Q@G@=q@ᙚ@@  @޸R@@@z@(@
@
@\@33@@33@H@33@33@@33@z@=q@33@(@@ff@@@߮@޸R@޸R@{@@@(@p@@33@@@ۅ@@z@
@H@@33@
@H@@ڏ\@z@33@
@Q@G@ڏ\@=q@H@33@33@33@
@
@@{@ff@\)@\)@߮@  @\)@
=@޸R@ff@
=@{@޸R@G@  @@
@H@ۅ@ڏ\@ڏ\@@ڏ\@\)@
=@׮@љ@z@
=@
=@p@ff@Q@=q@@p@@@(@޸R@
@ڏ\@
@H@
@ٙ@ۅ@ڏ\@H@
@ۅ@33@=q@=q@ٙ@33@=q@G@@G@ٙ@\)@z@
=@
@ָR@@G@
=@@ָR@أ@ٙ@޸R@@\@ff@(@\@@H@\@Q@@
=@p@@p@@\)@  @@@ff@R@@G@@\@H@@
@(@@@{@@@@
@(@@\@ᙚ@33@@G@\@\)@G@ᙚ@  @{@(@p@  @
@@{A @ff@@@(A
A
=AGA\A  ApAAA\ApA
=ApA\AA
=AAQA\)A
=AA{A33A\A
A
AA=qAffA
A	A
=qA	AzA  A\)AH@zA33A{A33AAA	pA
RAA\)AzAffA
A(A33@
=@@@\)@QA (Aff@
=A33@A=q@R@R@=q@@Q@G@\)@  @\)@  @Q@  @@@@@{@G@z@@@@
@
=@
@A AA\A{@(@@=qA A Q@@R@z@(@\)@R@  @@{@\)@ffAHA (AA
=A
=A33AA@
@@@@@pA @@ff@@33A (@\@p@=q@@=q@
=@\)@H@@@@@H@@Q@=q@  @
@(A A
=A Q@H@@@@R@  @ff@@33@33@@H@@@{@@=q@@@@G@@33@@(@@@ff@@@(@ff@  @(@@@@H@{@@G@=q@@
@(@@{@
=@H@
@@=q@@=q@@@\@H@=q@@Q@\)@@  @zAAA  A(AHAff@p@{@@@z@z@@z@H@
@H@33@@G@(@@p@R@A@
@H@
@
=@z@{@
@@H@
=@G@@H@G@z@Q@=q@
@33@@\@@@33@@ff@\@R@\@=q@H@@ff@@@\)@@  @@@Q@@  @@\)@
=@H@33@H@\)@@ff@R@  @Q@z@R@G@Q@G@HA	@(@z@
@@
@Q@@\)@
=@
=@@@@陚@
@@@33@ff@\@{@{@ff@  @R@p@G@@@
=@Q@@  @@\)@陚@陚@陚@@@p@33@@H@ff@߮@@  @
=@@ᙚ@ff@@@@@H@z@G@ᙚ@Q@\)@ff@߮@\)@{@@߮@G@p@
=@R@{@\)@@@@\@  @p@=q@33@@ff@H@@
=@G@\@@(@z@@33AAzA(@H@\)@33@@z@@ff@
=@  @@
=@p@@(@{@z@
@p@R@@G@R@@p@ff@R@@H@@@Q@  @=q@@H@ڏ\@33@@@(@@=q@R@ff@p@=q@(@陚@p@@@@(@@\)@\)@ff@{@@@@H@@\@@R@(@(@@
@
@G@@@R@@@  @@@G@
=@z@@  @H@A @@=qA   @pA Q@@\)@33@G@Q@@@z@\)@ff@G@\@z@@
=@
@p@33@p@
@z@@(@@H@
=@H@=q@Q@@z@@\)@@@陚@H@Q@33@(@߮@@
@ff@@H@@@ᙚ@
=@@޸R@H@H@@ff@@{@\@(@@@  @H@(@@z@R@{@R@{@ff@33@{@H@Q@
=@G@ff@@\@\@
@@@@@@
@H@z@33@G@p@
=@@@p@p@陚@
=@\)@@(@@z@Q@=q@G@@{@@z@
@Q@@@p@R@
=@  @G@  @Q@@G@G@Q@@
@p@Q@љ@У@  @Q@  @@  @
=@@
=@{@z@ٙ@@أ@H@=q@33@ff@Q@(@\)@@\)@ʏ\@G@z@Ӆ@@z@  @G@\@
@G@=q@  @Q@߮@33@@G@@@Q@@Q@@陚@@G@陚@\)@G@p@\)@=q@陚@z@33@p@(@{@@
=@
=@
=@\@ff@R@@
@Q@@{@H@أ@@p@p@33@=q@@
=@@ff@@=q@@@z@(@@G@33@@@
@@љ@θR@Ϯ@ff@\)@p@Ӆ@ff@ff@H@
=@(@H@(@p@p@У@33@H@\)@G@׮@=q@\)@33@(@Ǯ@\)@@z@G@Ϯ@p@p@@ff@{@ff@
=@ff@љ@љ@@H@z@p@
@H@ҏ\@H@Ӆ@33@G@R@@@H@R@33@@            @@G@
@{@  @@@\)@@
=@p@p@@z@@Q@ᙚ@ٙ@@=q@
=@p@=q@G@
@޸R@
=@ff@@
=@z@\@
=@{@=q@  @\)@R@G@
=@33@@p@33@
=@陚@\)@H@33@
@
@H@=q@33@
=@H@@33@ff@\)@p@R@
=@z@@陚@p@(@@ff@
=@\@G@\)@
@ff@(@  @\)@ff@
@@H@G@R@@
@z@(@@ff@
=@@
@@(@z@@p@@@ff@@@@@=q@ff@@ff@@ff@@G@@@33@@p@@{@@z@G@33@陚@Q@@\)@(@\)@陚@Q@G@R@陚@ff@@p@Q@@
=@(@H@33@Q@z@@H@33@z@޸R@
=@ff@@\)@
=@ff@z@ff@@{@
@@ڏ\@H@\@ff@{@@Q@\)@33@{@p@{@@@ᙚ@33@G@z@@@  @R@Q@陚    @@
@R@@@@H@@
=@@H@@  @@@G@=q@@@H@@@R@@\)@z@@@@p@޸R@@߮@ᙚ@Q@ᙚ@@=q@@ᙚ@p@ff@@߮@\@=q@Q@  @H@ff@z@Q@\)@@@G@H@@ʏ\@z@
@33@ҏ\@θR@@Q@Ǯ@˅@  @(@@ff@ff@
=@Q@Q@H@@ٙ@33@p@
=@@@
@  @H@\)@Q@\)@
=@33@(@@@@
@@ڏ\@ff@
=@׮@@@H@@\)@
=@33@@  @љ@  @Q@@ٙ@׮@\)@p@p@(@@(@33@H@
@G@\)@љ@
@(@H@33@ҏ\@
=@  @ə@(@˅@H@  @G@ə@p@\)@z@=q@{@(@(@H@љ@@У@z@θR@@@@z@
=@=q@33@
@@p@R@@@@
@
=@  @\)@{@
@\@@@
@ᙚ@{@@@H@=q@@Q@p@
@@ٙ@ᙚ@  @ڏ\@G@޸R@@{@\)@p@ff@@H@z@@@@z@ۅ@ۅ@{@@@
=@ff@@H@p@
@z@ٙ@p@\)@H@ڏ\@أ@ָR@@  @H@Q@@\)@33@θR@@Q@θR@\)@z@H@ָR@z@
@  @=q@@=q@z@
@(@p@߮@Q@@
@ۅ@z@@z@ۅ@@@{@޸R@ff@  @߮@߮@@33@
@@\)@33@ff@H@@Ӆ@
@޸R@
@޸R@33@z@@@@G@=q@33@@p@ҏ\@@Q@  @p@ָR@@Q@z@@@@(@H@  @=q@@@ָR@\)@ڏ\@@=q@Ϯ@ҏ\@Ӆ@z@љ@G@@=q@
@(@@@@
=@Q@@  @33@
@33@׮@ff@{@@@G@@׮@33@@z@z@(@p@{@@G@@@  @
=@ڏ\@@ff@@z@33@
@ҏ\@Ӆ@p@33@
@@
=@{@33@ۅ@
@ٙ@{@ff@{@  @ff@G@  @ָR@G@33@@{@\)@Ǯ@z@G@ʏ\@θR@ҏ\@@{@\)@\)@G@=q@G@z@@
=@Q@G@ٙ@@Ӆ@ָR@@{@@@\)@@@@Q@
@
@@\)@Q@G@Q@@=q@
@33@@@θR@θR@\)@@@ҏ\@ff@׮@G@33@@z@ڏ\@p@G@\@(@=q@@ڏ\@ڏ\@H@ۅ@
@H@H@@@G@  @(@(@(@=q@أ@أ@\)@ff@@{@׮@׮@׮@
=@أ@\)@Q@\)@
=@\)@
=@{@׮@׮@@
=@p@׮@@@@@H@@{@{@ə@z@ff@\)@ʏ\@z@θR@@@{@p@ҏ\@ff@@ff@أ@أ@  @G@=q@ڏ\@H@=q@Q@׮@Q@Q@ڏ\@ۅ@z@@p@
=@\)@@@\@@@z@
@
@\)@  @
=@p@p@
=@R@ff@@@
@=q@ff@{@߮@  @@
=@Q@ff@p@@{@@{@@ff@߮@  @p@@
@33@@{@߮@  @  @@{@
@z@׮@ҏ\@z@ff@@Ӆ@Ӆ@\)@{@أ@أ@{@Q@(@{@أ@@H@33@Q@أ@H@@(@{@
=@\)@߮@@@@ᙚ@
@@ff@ᙚ@
@z@
@@(@(@H@@\@33@z@z@(@@@
=@Q@@@@
@z@ff@33@ff@p@R@@R@p@  @G@(@@@
@33@
=@\)@
@R@@@
=@߮@  @z@
@p@޸R@ᙚ@Q@@@@=q@G@@@  @  @  @Q@\)@
=@G@߮@@p@޸R@p@
@@=q@(@@ᙚ@@{@p@z@@@{@ff@@@  @@陚@H@33@H@@ff@H@Q@@R@@@G@R@
@33@@ff@@=q@(@@G@@G@{@R@@@H@G@
@@@@\)@
@@p@@@p@@{@  @@@        @
=@z@(@(@Q@
@Q@\@@=q@H@陚@@@ff@  @G@\@G@H@  @޸R@@@@@z@@R@ff@R@
=@@@R@@33@R@  @@@@Q@z@@H@@\@
@
=@(@z@\@(@{@@H@@{@@33@@H@Q@@  @Q@@@\)@@  @{@
=@H@@޸R@@33@(@أ@@@ff@@z@33@H@(@\@p@33@H@G@33@=q@
@@R@R@33@
@
@(@
@
@z@@@ᙚ@=q@@@z@{@
@(@G@@@{@@(@p@@Q@z@z@(@陚@\@p@R@{@R@@33@@33@\@
@@z@@z@
=@
=@
=@
=@ff@@@@
=@(@@@  @  @(@@\)@@@߮@߮@
=@@ᙚ@@33@33@@@=q@=q@\@\@\)@\@p@@{@@@ᙚ@p@@@H@G@\@
=@@H@(@=q@Q@\@陚@@@@G@@陚@=q@\@H@H@
@(@z@@@(@
    y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y A(  y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y @R@G@
=@p@
=@  @
@H@@@@@
@z@@@\@@{@@@\@@33@R@
=@R@ff@@{@R@ff@
=@R@H@@(@@@p@33@@p@@p@p@@{@@@(@  @@ff@p@@@H@G@@@@@z@{@@=q@@\@@R@p@33@H@@ff@(@@@\@=q@@Q@@@ᙚ@@
=@
=@ff@{@ff@@
@H@@@
@H@
@@z@@@\@@@@@޸R@  @޸R@ᙚ@(@p@{@޸R@@ٙ@ff@p@
=@أ@33@@p@ff@z@(@
@z@
@  @
@
@ڏ\@Q@ڏ\@  @ҏ\@
=@  @޸R@@߮@@  @ᙚ@  @@Q@Q@  @{@׮@{@G@љ@@Ӆ@=q@(@@
@@@(@ٙ@(@Q@޸R@{@ڏ\@
@p@@p@@ff@ۅ@  @p@H@H@H@@33@ٙ@@ۅ@H@أ@(@p@z@{@ڏ\@33@ڏ\@@(@ٙ@ٙ@Q@Q@
=@{@\)@p@
@=q@33@ڏ\@ٙ@׮@أ@׮@أ@33@p@p@(@z@z@=q@ҏ\@=q@ҏ\@@@@Q@33@z@{@33@Ϯ@Ϯ@
@˅@z@ҏ\@(@Ϯ@z@@G@p@(@
@ٙ@ff@(@  @Q@׮@Q@\)@@{@p@@ڏ\@@ۅ@ۅ@33@(@@޸R@޸R@߮@@{@@\)@ᙚ@=q@@ff@@޸R@@@@@p@@ڏ\@G@@ٙ@=q@@@@أ@\)@ָR@@G@G@  @\)@
=@G@  @G@ڏ\@  @ff@G@G@@G@Q@\)@{@@@@\)@z@p@=q@\)@У@p@
@(@H@@z@H@@{@@=q@@
@33@H@H@=q@ff@޸R@@(@H@{@ۅ@z@@{@޸R@߮@@ڏ\@\)@  @z@z@H@ff@׮@p@  @p@z@
@{@33@G@@
=@ۅ@\)@=q@@
=@ָR@ҏ\@\)@z@{@
=@ٙ@أ@ۅ@ڏ\@H@ٙ@G@@@@أ@׮@\)@@33@p@@׮@׮@@33@љ@@{@@Ϯ@33@33@H@У@  @ҏ\@Ϯ@Q@Q@(@G@  @@(@Q@G@@ۅ@ۅ@ڏ\@H@׮@\)@ٙ@@@H@ڏ\@H@@ٙ@p@(@z@
@33@@\@@@R@p@@@33@R@z@z@
=@@G@@@G@33@陚@陚@@陚@\)@p@ff@R@\)@@R@Q@Q@{@@p@@=q@(@@p@{@G@p@p@Ӆ@(@أ@Q@@z@Q@G@G@Q@أ@=q@@ۅ@
@=q@Q@أ@׮@ٙ@@p@  @@ᙚ@߮@߮@  @߮@޸R@
=@  @Q@G@G@G@G@G@G@@@@@33@ff@Q@@陚@@
=@  @\@
@33@33@ᙚ@=q@@
@@@@߮@{@
=@@
=@{@@
=@{@p@Ӆ@33@ָR@׮@G@(@\)@أ@Q@ָR@أ@p@
=@=q@߮@ff@(@p@ۅ@ڏ\@@@@@=q@H@ڏ\@ڏ\@=q@=q@H@=q@ff@ff@ff@ff@{@
=@Q@@H@@=q@H@@=q@(@@p@(@
@@@(@{@(@@=q@@@{@  @H@陚@=q@陚@@  @@z@p@\@H@{@
@@{@Q@=q@33@ff@\)@  @
@
=@@@Q@@@@G@H@33@
@
@
@@
=@\)@@@\@(@@@ff@ff@@@@p@{@@z@{@z@\@H@@{@(@
=@@\@@ff@Q@@(@33@\@G@陚@@@ff@{@ff@@@\@(@p@z@@(@
@
@=q@陚@=q@@
@33@@ff@@G@@\)@@H@@G@=q@@@H@޸R@{@33@G@33@@@陚@@
=@R@ff@R@
=@\)@  @@@陚@\@33@@@
=@@@H@@\@\@@
@H@H@@G@=q@
=@@{@z@(@@33@33@=q@p@\@z@@H@=q@@陚@陚@p@@{@\)@@@@(@p@(@  @z@(@޸R@
@@@H@\)@@޸R@H@33@(@=q@H@
@@
@G@߮@Q@33@@  @33@@\)@@陚@@Q@G@33@@\@
@z@p@@G@@{@  @@@33@G@{@@
@\@
@ff@陚@(@p@R@{@z@\@@@(@
@H@@@
@33@@@Q@(@@(@@=q@Q@Q@޸R@{@ff@  @߮@@@߮@\)@@z@p@{@p@@33@أ@  @ڏ\@@G@ۅ@H@@
@
@ff@@@p@(@ڏ\@ٙ@33@ٙ@=q@ٙ@  @
=@ָR@أ@ٙ@G@@  @ٙ@
@@ff@ff@
=@\)@޸R@
=@
=@޸R@{@@p@p@@z@
@\)@ҏ\@
=@  @\)@@=q@
@ٙ@Q@
=@{@{@ָR@ff@@@p@@\)@أ@
=@@@p@@Ϯ@G@33@G@љ@=q@(@  @p@(@Ӆ@@@(@{@(@@Ϯ@ҏ\@33@Ӆ@z@(@
=@@@ff@׮@ff@
=@ڏ\@  @\)@  @Q@  @أ@ff@أ@  @ٙ@ٙ@  @H@ۅ@\)@߮@߮@߮@{@޸R@z@(@=q@@
@H@=q@33@أ@׮@@@ָR@أ@\)@\)@{@  @ۅ@
=@\)@
=@{@@{@@\)@  @G@ٙ@=q@߮@(@H@\)@ָR@Q@׮@p@\)@@
=@  @Q@p@@p@
@љ@H@@33@Q@@Q@H@H@Ϯ@\)@H@  @  @У@33@z@ָR@Q@\)@ٙ@G@G@
=@\)@ff@p@{@@@أ@ٙ@=q@33@
@z@p@@@ff@ff@ff@
=@  @@=q@33@G@@H@{@@@{@{@@z@@H@H@@H@=q@H@G@ff@{@Q@߮@@\@ᙚ@\@@  @=q@H@
@@@@@@33@p@@@@(@@ff@
=@  @@@=q@\@\@ᙚ@
@G@@  @
=@
=@\)@Q@߮@=q@@H@ff@޸R@{@@  @@@G@ᙚ@ᙚ@=q@ᙚ@@=q@33@z@(@@@\)@ff@{@R@@@p@p@p@p@ff@@G@@z@\@
@33@@{@@@@z@p@@(@@
@H@\@\@H@G@G@
=@@
=@p@R@@p@\@陚@  @Q@@p@@@z@
=@\)@ff@R@ff@33@@z@@ff@@z@@H@z@@ᙚ@H@R@
=@@@R@p@
=@Q@{@\)@  @\)@G@G@@陚@=q@33@33@(@
@(@@@p@R@ff@
=@@@\)@  @  @Q@  @@@Q@@@H@33@
=@H@@G@@{@@@\@H@@@@@@(@@H@H@33@@
@z@@z@33@@@@@33@\@
@R@@@{@@@=q@@z@=q@G@=q@\@@33@
=@@G@\)@  @G@@=q@@@G@=q@H@(@(@z@@@ff@BʙBffBB  B  BΙBffB  BBBffBBffB  BBffB33B33B33BffB33B33BB33BЙBЙB33BB33BЙB33B33BЙB  BffBҙBffBΙB33B  B33BffB  B33BǙBffBffB33B  B  BB33B33BBffBəBB33B  B  B  B  BBʙBffBBǙBBffB̙B33BB̙BB33B33BffB33B33B33B  BΙBB͙BΙBffBBffBffB  BΙBϙBϙB33BBҙBBffBBffBҙBB  BffB33B33B33BҙBҙBBffBffBBϙBffBffBϙBϙB  BffB33B  B  BffB33BffB  B  B  BffBffBBBffBB33B͙BϙBffB  BBffBBB֙BәBBՙBffB33BәB  BҙBBBffBәB  B  BЙB  BffB͙BffBB33BffBffB  BљBffBffBBٙB33B33BB  BffB  B33B33BݙB  BffB33BffBBݙB33B  BffBڙBB  B  BffB33B  BffBڙBۙB33BffBٙBB  BؙB  B  B  BיB  B  BffBffBffBBBԙB  BB͙B33B  BffB͙BffBffBBʙBffB̙BffBB33BҙBBЙBΙB33B  BBBB33BffB33BffB33B33B˙B˙BffB͙B  BϙB  BBB  BffB33BBЙB  BBϙBffB33B  BB  B33BffB33BҙB33B33B֙BB33B  BffB33BՙB  BBBffB  B33BԙB  BՙBՙBB  BffB  BffBffB  BB  B  B33BffB  B֙B  BBffBBϙB33B33B  BffBffBffB33BffB33BffBffBΙB  B  B  BffBЙB  BffB͙B̙BB33B33BffBBBBəBB  B  B  BBBffBffB  BffB  BffBBffBBB33B̙BffBffBΙBЙBϙB  BBffB33B  BB  BB33BffBffBיB33B33BBffB33BffBB33B  B33BיB33B  BB  B33BffBffBՙB33B33BҙBffB͙BƙB33B33B33BBB33BffBÙBBffBffBffB33B  BљB33B33BәBBffBBBǙB  BǙB33B  BBřB  B  B33BffBəB33BffB˙BB  B  BљB  B33BB33BffBB33B33BffBffB  BΙBϙBBffB33BϙBffBBBffBB  BB33BԙBBBffBffBڙB  B33B33BB33B  BffBؙBؙBיBBffB  B  B  BBffBՙBffB33B  B  B33BffBՙB  BBBʙB֙B̙BΙBBBəB͙BffBԙBffBB33B  B̙BffBBЙBffBBB33BBffB33BǙBBřB  B  B̙B33B33BB33BffBffBBffBBBB33BffB  BՙB33B  B33BBffBԙBffB33BffBՙBBffBBffBBB  B33B33B33BۙB  B  B33BffBۙBڙBffBffBffBffB33B33B  B  B  B  B33BffB33B33BBffBBffBԙB  B  BԙB33B33BBәBϙBffBB33BffBffBϙBffBffBB  B  BșBBB  B  B  B  B33BΙBffBffB  BBBЙBffBљB33BffBffB33B  BffB  BffB33BיBיBffBؙBؙBB  B33B  BffB33BffBBffB֙BffB֙BBיB33B  B33BՙBՙB33BffB  BՙBffBՙBՙB  BBBәBҙB  BʙB33BBϙB33B  B  B˙BffB  BBffB33B  BBșB  B33B  B33BBffB  B33B33B  BffBffB  B˙BffB  B  BffB  B33BǙB33BB  B˙B33B˙B33B  BϙB  B33B  BBЙBΙB33B33BffB33B33BBB  BB֙BؙB33BBBBՙBB33B֙B33BffB33B33BљB  BB33B̙BB  B33B33BЙBB  B  B  BʙBffBffBB  B33B  BB  B  B̙B̙BffB33BəB  BșBBǙBƙB  B33BBB  BffBBffBB  BBffBB33B  BBffBÙBBBB  B  B33B33BƙB33B33B͙B  BffBəB33BffBffB͙B̙B̙BffB  BffBəBBffB  B33B  BBffBʙBʙB  B˙BBffB33BBƙBəB33BffBșB33B33BB  B  BBʙB  B  BəBffBffBB33BffBșB33BffB  BBffBffB33BffB33BƙBřB33B33B  B  B33BffBffBffBřB  B33B33B  BB  BffBffBffBffBBffBBBffB  BffBB  BBÙBřB  BÙB33BBB33BffB33B  BBșB  BșBəBffB  BʙB  B  B  BB33B  BffBB33B̙B  B͙BffB  B33BffBffB  B33BffBBBffBșBǙBǙBșBBffBffB  BǙBǙBffB  BBǙB33BBBBffB33BBBffBBffBBffBBB  BffBBffBBffB33B  BffB  BBBB  BffB33BB  B33B  B33B  BÙBffBffBB  BffB33B  B33B  BffBșB33BəBʙB̙B33B33BЙBffBЙBBB̙BBffBΙB  B33BBffB33BffBffBffBB  B̙B̙BB  B  BffB33BəBB33B  BșB  B33BBʙB  BB˙B  B  BBffBB˙B  BʙB  B33B˙B  BșBffBffBB33BffBB  BB  B33BəBəB  BffBffBBB  B  BffB  BffBB  B33B  B  B  B  BffB33B  B˙B˙B  BBB˙BBffBBBffBffBЙB33BffB  BffBB  B33B  B  BffBffB  BҙB33BBBљBB33B  B33B33B33B33BBB  BffBϙBffBB  BffBffBffBBBffBffBBBBffB  B  B̙BffBffBffBffB  BBB  B33B33BffB33B33B  B33BffB33B̙BffBəBffB  BffB33B33BB  B33BffB  B33BffBǙB  BșBʙB  BffB33BʙB33B  B̙B͙BϙB  B  B  BffB33B33BϙB33B33B  BҙB  BffBffBBBffB  BffBB33BB33BЙBBBB33BЙBffBB33BffB33B  BBffB  BffBffBBϙBffB  B33B  B  B33B  BffBffBB  B  B  B  B  BBB33BBBșB  BffBffBƙB33B  B33BffB̙BBΙB33BBffB  BB  B  B33B˙BʙB33B  BffB  BffB33B͙BB̙BB33BB33BΙB  B  BΙB33BϙBffB33BBffBffBffBffB  BffBffB33BB33BЙBЙBB33B  BB  B  BffBffB  BffB̙B33B  B  BffB33B33BffBəB33BʙB33B˙B33B33B̙BffB33BBBffB̙B  BBB33BB̙BffBBBffBB  BffB  BB33B  B33B  B  BƙB  BffBəBB  B33B̙BffBB33BB33B33BffB33B  B  BΙBΙBB  B33BЙBϙBϙB  BЙB  B33BffB33BљBBB33BЙBBBΙB33B  BffB  BffBffB33BffB  B  B33BB33BB˙BffBB  BBffBB33B33BBffBB33B33B33B33BffB33BB  BʙBffB  BʙB  B  B33BB  B  B33BffB33BBBBșBəBșBəBBBffB  BffBffB  BffB  B  B  BBϙB33B  B  BљB33B33B33BЙB  BBB33BB33BB  B33BB  B  BBљBffBB  BffBљB  BffB33B  B  B33B33B33BffB33B  B  BB33B33B33B  BʙB33B  B͙B33B  BffBBffB33BBəBffBffBffBBBƙB33BęBB  B33BʙB33B  BϙB͙BffBffB  BЙBBϙBffBЙB  B33BҙBҙB  BљBffB33BffBB33BBffB  B33BәB33BffBՙBBffBәBffB33BffBffBԙB33BffB33B  BffBәBffBffB  BBffBәBBffB33BBәB33BffBffBBffBffB  B  BffB  BB33B  B33BB33B  BBffBffBBBʙB33BffB  B33BB͙B33B33BffB33B33BB  B  BəBffB  BBBB˙BBBBBBffBffBffBϙB33BffB  BffB  BBBffBB33B33B33BәB  BB  B33B  B33B  BB  BBffBB33BәB33BBәB  B33BҙB33BBBBBԙBffBәBffB  B33BffBљBffBBBB  BffBBʙBB33BffB  B33B33BffBffBffB  BBBffB  B  BffBffB33B  B  BʙBffBB33B33BffBBǙBffB33B̙BBB33BffB  BΙBB  BffB͙B  B͙B  B  B  BϙB  B33BЙBBҙB33B  B33BffBљBffBљB33BљB  BffBљB  BffBffBљBffBffBҙBљBffBffB  B  B33B33B33BBffB33B  BffBΙBffBffBB  BB  B33B̙B  B̙BffBffBBB˙BffB33BffBffBǙBffBřBffB  BB33B  B33B  B  B  BffBB33B˙BffB˙BB  BBffB  BBΙBΙB  B33BBB33BBB33BЙBB  B33BB  BffBffBBљBЙBϙBffBЙB  BffB33BBB33B33BϙBΙB  BBBBffBϙB33BΙB  B  BB  B  B  BBffBB  B˙B˙B33B33B˙BffBBffB  B33BBffB˙B33BB͙BBB  BffBBffBBffBB  BffB  B33BffBBffBffB֙B33B  BffBffBәB33B33BۙB33BۙBffBBBBBBBBffBffB33B  BffBB33B  BffBؙBffBffBffBB  BڙBBٙBBؙBBBffBffB33B  B  BיBיBffB33B  B  BؙBffBՙBffBBffBΙB33BЙB33BffBB  BffBffB33BЙB33BBәBҙB33B33BBBԙBffBԙBBB  B33BB  BՙBBՙB  BיBB33B33B  B  B33BB33B33B  BffBffBffB  BffBיB  BffBיBBՙB֙BffBBB33BיB33BBffBؙBB33B  BٙBBٙBڙB33B33BB  BۙBB33BؙBB  BܙBB  B  B33BݙBBB  BB33BffB33BBיB  B33BB33B  B  BB33B33BٙBBBB  B33B33B  BәBB33BBәBBBBBԙB33BB  B33BәB33B33B33B  BBBBffBBffBB  BffB  B33BBؙBBB33BB33BB33BffBffBߙB33B33BBڙBBיB33BBؙBB33BB  B33B33B♚B33BᙚBffB  BffB33B33BB  BݙBffB33B  BffBݙB33BᙚBBBՙBBߙBffB33B  BB  B33BBB  BșBBffBՙBffB  BיB33BԙB33BB33B  B33B˙B  BΙBffB֙BؙBffBffBؙBҙB  B33BԙBBffBffBۙBffB33B  BB33B33BffB33BBffBٙBffBffBBיBؙBffB33B  B33BԙBffBٙBיB  BffB֙B  BffBՙB  B33BffBBՙB  BB33BffBffB  BBәBB33B  B33BffBљB33B  BB33BB  B  B33B33B33B  B  BҙBffB  BffB֙B33BffBBffBBB͙BffBffBBBB˙BffB  B33B  B  BBBffB  B  BB͙B33B  BBB33B33BBљB֙B  BffB  BffBBffBffBB33BffB33B33BB33B33B  B33B33BB  B  B  B33B33BљB33BBBB33BBffB33B  BΙB  BffB  B33BB  B33B33BB  BBBB33B33B33BBffB˙BffBB  BffBBBʙBBffB  B  B33BffB  BffBřB  B  BřB  B  BǙB  BB̙B33B33BffBBBffBffB  B33B  B  B33BϙB  BB33BBffB33B  BB  B33B33BffB33B33BЙBΙBBBB33BffBB͙B  BffBB  BϙB  BffB  B33BЙB  BЙBϙBЙBffBffBЙB  BffBB͙B33B  BffB33B33BB  BffBBB33BBffB  B  BffBffBBB33BffB33BB  B33B33B33BffBBB33B  B͙B33BљBBBffBϙB33B33BB͙BϙB33B͙BB͙BΙBϙBBffBЙB  B֙BBBffBffB֙BB33B33B33B33BffB33B  BBB  B  B33BffB33BԙBBBBԙB33BBՙB33BffB33BBffBBљBffB33B  BffB33BЙB  BϙB͙B  B33BB˙BffB  B33BϙBffBBBffB33BffB33B33BәBffBBffB33BՙBffBffB  BBffB  B33B33BڙB  BB33BۙBffBݙBB33B  BߙBBffBffBffBffBܙBBffBڙBٙBB  BיB33BB33B33BBffBBB33BffBffBBBԙB  BBffBBBB  B33BB33B33BBB  BЙBffB  B  B33B  BffBBffBB  B33B33BffB  BffBB33BBBљB  BB  B  BB  B33B33BB33B  BBBؙBٙBBffBffB  B33BۙBܙB33B33BܙB33BۙBܙBBBB  B33B33BٙBؙBffBB33BәBBB  B  B33B33B  B33B  BBԙBBffBffB33BffB  BBBBffBՙBB  BՙBՙBffB  BBffBffBBBԙBיBffB  BәBҙB33B  BҙBB33B  BB͙BBffB  BΙB33BffB  BB33BәB  B33BffBՙBBffBB33BؙB33BBB33B  B33BB33B  BBߙB33B  B33B  BffB  BߙBBޙBffBffBffB  BB  BffBffBB33B  BՙBؙB  BBffB33B33BיBBәBBffB  BәBҙBffBҙBԙBԙBәBffBB  B33BҙBffBB33BљBЙBљBЙBBffB33BffBЙBљB33BBҙB33BffB33B33B  BB  B  BffBΙB33BffB  BffBB33B  B  B33BBffBffB  BffB  B33BffBffBBޙB  B  BffB33BffBٙB33BٙB  BB33B  BB  BffB33B  BיBBיB  B  BffBՙBՙBՙBЙB33B33BBffB  BʙBəB33BBB33BB33BffB33B  BBəBffBBffBffBffBffBB  B  B33B˙BffB˙B33BffB  B  B̙BffB33BffBffBffB  B33B33BffBљBBffBBљB  BљB  BЙB33BffBBffB  BҙBffBBBBB  BffBffB33BBBBffB  B33BЙBϙBffBB  BB  B͙B  B33BʙBffBBəB  BBB33BB  B33B  B33B33BffB  B  BBffB33BB33B  B  BřBƙBffBffBffBřB33BffBffBffB  B  BBffBffBffB33B  BffB  B  B  B  B  B33B33B̙BffBʙBʙB  B͙BBffBBffB33BffBϙB33B33BљBffBBәB33B33B33B  BԙBB  B֙BBԙB33BәB  BffB  BBB33BҙB33B  BљBffBffBBffB  BҙB  BBϙB  BffB33B  BB̙BffBffB33B33B  B̙B  BffB33BƙBBffBffB  BƙB33B  BʙBB˙BffBBffB̙BB  BB͙B  BBffBBffBB33B  B  BB  BB  BffB33BffBffBBљBffBffBәBәB33B  BB33B  B33BB  BBBBffBffBBՙBB  B  BffBffB33BBϙBBЙB  B  BΙB  BffBffBB  B  B  B  BffB˙B  BffBffBffB33B33BҙBBBffBB  BffB33BffBffBffB  BffBffBBBʙB33BB˙BB  BB33B33BBffB33B33BffB33BBB  BЙB33BϙB33BϙB  BBәBffB33BB33BBBffBڙBB33BܙBܙBB  B  BffBBޙB33BݙB33B  B  B33BffB  BݙB  BffBffBffB  B  B33BB33BB33BBB33B֙BffBffB  BԙB  BffBffBԙBffB  BffB  BffBBәBBәB  BԙBBB  BBB  B33B33B  B33B  BffBBffBߙB  B33BB33B  B33B33BBB  BٙBffBڙB  BffB  B֙B  BffBٙBڙBB  BBۙBޙBB33BB  B晚B  B虚BffB33BffBBٙB33BؙBffBܙBܙBݙBffBffBB  BffBffBffBBۙBۙBffBB33BBܙBܙBBB  B  B33B33BۙBBBB33BיB33BٙBBffB  B  BffBffBffBBיB33BBۙB33BffBffBBڙBffBffBBffB  B33B33BڙB  BffBffB  BffB  BB33B33B  B  B  BffBffBۙB33BܙBffBffBffB  BffBܙB33BܙBffBffB  B  B33BBڙB  B33BffBBffBڙB33BffB  B  BBBٙBٙBB  BBB  B  BBB  B  BffB  B֙B33BԙBԙBB33BԙB33BffBB  BԙB33BҙB33B  B33BffBՙB33B֙B33BBffB  B33B33BBffB33BԙBԙB  BBffBԙBBԙB  BB  BffB  B  BBffBffB֙B33BffB  BffB  BffBؙB  BffBB33BffB33B  BB  BffB  BffB33BBBBffB33BffBיBffBיBffBB33BffBffBBBffB33B  BԙBffB33B֙BB33B  B33B  B֙B33B̙BffBB  BBffBB  BffBB  BffBB̙BffBB33BffB  BffBЙBBBΙB  B  B  B33BffBBffB˙B  B  B33B33BffB  B  B33BB  B  B  BЙBЙBffBffB33B  BљBffB  B33B  BffB  B33BB  BЙB33BB33BffBffBffBBЙBЙBffB33B  BЙB  BBϙBffBϙBϙBB  B33B33BffB͙B33B  BffBB  BffBffBЙB͙BffB33BřBB̙BǙB  BǙB  B  BʙBBffB33BϙB33B33BffB33BffB  BB  B33BǙBffBΙBffBB33BϙB33B  B  BffB  B33B33BBffBәBәBB33B33B  B33B  BB  B33BffBB  B  B33BffBљB33B33B33BB33B33BB  B  B33B33BәBffBBffB33BffBәB  BB33BBљBB33B33BffBffB  BffBЙB33B33B  B  B  BB  BffBЙBљBΙBΙBΙBǙB  B  B  BffB  BffB33B͙BB33B33B33B  B  B  B  B˙BǙBffBǙB33BffB͙B  B33BffB  B͙B͙B33B  BϙB33BBffBffB33BЙBЙBffBBΙBffB33BffB  B33BffB33BəBBʙBffBffB  BBЙBϙBʙBBB  BҙB33B  BB͙BffB33B33BffB  BffBffBffBΙBϙBBffB33BffB͙BBffB̙BBəBBffBffBffBffB33BǙB33B  BǙB33BBƙBB  BffB  BB33BBΙB33B  B  B33B33BљBљBәBՙBB  BffB  BBffBݙBBٙB33BffBBBffB33BffB  BffBffBffBffB  B  BffBۙBڙBB33BΙB  BљB  BBBBՙBffB  B  B֙B֙B֙BBffB  BԙB  BՙBՙBՙBffBB33B  BB33BffBffBBBՙB  BB33B  BffBffBҙBBәBԙBB33B33BљBљBBB33B33B33B  BBB֙B  BBffB33B33BB33B33BB33BBB33B  B  B33BB  B33B  B噚BBffBBB33B  B33BB  B  BᙚBB33B  BffBBޙBޙB33BB  B  B33BB  B  B  BBB33BיBؙBffBB  B  BB  BffBݙB  B  BܙB  BܙBffB33B33BٙB33BיB33B  BffB֙B33BٙBffB  BۙB  BffB  B33BBffBffB33B  BffBffB33BڙBۙB33BffBBޙB  BB33BߙB33BffBB  BffBߙBffB♚BB33B䙚B㙚BffBB  B  B33B  B33BBBBޙB  B33B33B  BffB  B  B  B33B  BۙBBۙB  BffBffB33BffB  BۙB33B  BٙBڙBۙBܙB  BۙB  B  B33BٙBBffBܙBB33B33BffB33B  BffB  B  BܙBB33B  B  B֙BB  B  BԙBBffBffB33BffB  B  B  BB  BBڙB33BffBٙB  B33B  B  BۙBffBܙB  BffB  BܙBBܙB33BۙB  BBB  B  BffB33BBBffB33BBBffB  B33B33BffBBۙBffBBڙBݙB33BffB  BffBBffB  B33BיB  BffB33B  B  B  BB  B֙B֙B֙BffBffBffB33BffB  BיB  B  B  BffB33BBיB  BffB  BffBBffB  B  BffB33B  B  B33BffBffB  BffB  B33B  BޙB  BBffB33B33B  B  BffBBffBB33BBBffBBۙBؙBBBffBBffBffBBffB33BffB♚BffBffBޙB33B  BB33BB  BՙBՙB  B  B  BB  B33BffBffB33BB  B  BBffB33B33B  BBffBB33BBffB33B֙B33BB33B  BڙBffBffBBffBۙB  B  BBٙB33B33B㙚BB33BBffBffB33B33BBBB㙚B  BffBffBB陚B33BB癚BBB晚BBffB33B  BB  BffB  BffB癚BBffBffB  B33B33B33B  B33B䙚B㙚B㙚B㙚B33BᙚBBffB㙚BؙB33B  BB  B33BۙBB  B  B33B  BܙBܙBBݙBޙBffB33B  B  BffBޙBB  B  B33BffBffBffBB  BffB33BffBݙBffB33BݙB33B  B  BߙB  BffB33BB33BffB33B  BߙB33BffBߙB  BB33B  BᙚBߙBBffB33BݙBffB  B  BffB33BffBB33B33B33BffB  B33BBBBۙBffB  BffBB33BB  B  BB33B  BBffBffB  B33BBffBBәB  B33BB  B33BffB  BffBԙB  BffB33BB33BB  B33B  BB  BffBB33B♚BBffBBޙBffBߙBB  BffBBޙBޙB  BffBޙBޙBffB33BޙBBBffB  BݙB33BڙBffB33BݙBB  B33BffBffBffB  BffBffBBB  B33BffB  B33BᙚB䙚BᙚB  BBB33B33B33BffB  BffBٙB33B33B  B33BffB33BBB33BۙBffB33B  BB֙B  BBܙBݙB33BڙBݙBޙB  BB  BᙚBBffBB33B噚BffBBffB  BffBB虚B虚BffBffB33B33BB33B  BffB33B  BffBߙBB  BB33BffB33BffBۙBڙBffB33BffB33BיB33B33B33BٙBffB  B33BffBffBיBיBffBffB֙B֙B  B֙BffBffBBיB33B  B33B33BՙB33BB  BB33B33B  B  BffB  B  B33B晚B왚B33B33B䙚B  B33BffBBB33B33B  B㙚BB  BBffBffB33B  B  B홚B  B33B  BffBffBB33B  BB  BBBffBffB33BBffB  BffBffBޙBB33B  B33B  B33BffBffBffBffBffB噚B33B33B虚B33B虚B虚B33BffB  B33BffBffB  BB33BffB  BBffB♚B33B  BffBffB  BB  B  B晚B  BBffB33B  BffB  B  BۙB33B  BBffBڙB  B  BffB  BffBBᙚB♚B䙚BffBffBffB33B  B♚B33B♚BBBB虚BꙚBBB33BffB噚BB  BffBB33BBffBBBB33BBBBffBffB뙚BB33B33BB虚B33BffB  B㙚B33BffBffBffBffB陚B33BffB33B  B  BBBffBffBffB33BffB  B  B33BBB33BBffBB33BBffB33B  BBBBffBBffBBB虚BffBB  BB33B  BffB  B  B33B33BffBBBffB33B33BB  BffBffB33BBB  BffBffB33B  BB  BffBܙB  BBffBffBffB  BBBBәB  BB33B  BffBܙB33B  BޙB  B  BffBBffBB33BB33BBBffB  BB֙BffBBffB  B33B33BB  BB33B  B33B33BBffB♚B  B33B  BffBܙBB  B33B33BљBBffB33BffB33B33BәB  BffBՙB33BҙBBBBffBBBB  B̙B̙BffB  B͙BffB͙B33BBљBϙB33BB33B33BB33B33BBΙBΙB  BΙBffBffBB33B  B͙B  BBΙBB˙BffB̙B͙BBB  BffBB  B33B˙B˙BB̙BϙB33B33B  BB  B33BB33B  B  B33BЙBffB  B33B  B  BҙBffBffBB33BB33B  BB  BffB33BΙBΙBBϙBffB  BϙB  BB  B33BЙB  BB33B33B33BBffB  BBffB33B33BʙB33BB  B͙BB  B̙B̙BffBffBffBffBBffB˙B  BЙBљB  BBBffBffBBffBffB  BffB  B  B  BЙBљB  B33BffBB33BBBBՙBffBB  BBB33B  B֙BB33BBיB33BffBffB  BՙBffBffB  BffBffB33B  BBҙBffBffBffB  B  B33B33BB  BffBB33BffB33B͙B33B̙BB  B  BB33BBΙB33BЙBffBљBљB  B  B  B  BBffBљBB͙BB33BffB  BffBϙB33B33BffB  BffBffBBffBЙBBЙBBϙBB33BΙBΙBΙBΙBB33B  BϙB  B33BBΙB  BBΙB  B  BffB  B̙B̙BffB33B̙BB  B˙B̙B33BffB  B̙BB˙B33BffBffB33B  B  B  B33BB33B̙B33BBB33BBΙBϙBffB33BЙBffBBffBљBBffBffB33B  B33BљBBffBΙBffBffB  BffBffB  B̙BșB33B  BB  B  BBBffB33B̙B33BB33B33B͙BffB33B33B̙B  B33B33B  B33BB  BB  BϙB  B  B͙BffBBB33BBffBffBB33BϙBϙBϙBBϙBϙBBϙBffBffB͙B33B  BBBΙB33BB33B  B  BәBBffBB33B  BؙBffBڙBڙBBB  B  BݙB  BBffBBۙBݙB  BޙB  B33BۙB  BڙBܙB  BB33BٙBBBיBffBB  BB33B  BԙB33BԙB33BBffBB  BBՙB  BB  BԙB33BB  B  B33BB  B  B33B  BҙBЙB33BΙBB  B33BיB  BBBBؙBיB  BיBBffBؙBffBؙB  B33BBٙB33BڙB  BڙB33BB33BffB  BۙBffBffB  BڙBڙBffB  BBٙB  B33B  BffBB33BٙBffBٙB  B  BffB33BB  B  BffBؙBffBB33BffB33BBffB  BؙB33BؙB  B  BffBBؙBffB  B33BffB  BԙBffB  B  BB  BffB  BB  BffB33B  BffBffBB  BڙBۙBBffB  BB  BՙBBffB  B33BBؙBB33B  BBB  B  B  BffB33BۙBffBܙBffBB  BffB33BޙBޙBffB33B33B33BffB  B  BBܙBۙBffB  BڙB33BffBffB33B  BBffBܙB33BffBB33BB  BffBיBיBB  B33BffB33BffBffBBffB֙BBיB33BffBBB33BffBffB33BBB  B33B  BffBffBffB  BffBffB  BffBܙBڙB  BٙB  BB33BB  BڙB33B  BBB  BܙBݙBB33B33B33BBffB  B㙚B  BB  BޙBBffB♚B  BffBBݙBffB  BݙB  B33BܙB33BffBffB33BޙB33B  BBffBffB33BB  BffBBBB  B33B33BޙBBۙBffBؙBffBBffB  B  BBB33BffBB  BffB  B  BיBffBBffBB33B  B33BۙBffB33B  B33B  B  B33BڙBڙBBܙBܙBBffB  BޙBffBBffB33B33BߙB  B  BߙBBBBffBffB  BffBޙBffBB33BܙB33BܙBBBBffBffBڙBۙBffBffB  BffB  B33B  BٙBffBڙBڙBffB33BڙB33BٙBٙBBffB33BٙB33BٙB֙BؙB33B  BיB  B33BB33B33BB33B33BؙBٙB33B33BؙB  BBٙBڙB33BBBB  B  BBffB33BٙBיBB  BffBffBߙBBffBB♚BBB33BffBBffBBffBڙBBۙBܙB  B33B  BۙBffB33BۙB  B33BffBۙBffB  BffB33B33BؙB  BؙBB33BؙB  BBٙBؙBB֙BؙBؙB33BffBffBՙB33BיB  BffB33BۙB  B  B33BϙBBffBffBB33BffBBffBffBBffB  B  B33BՙBBffB  BBBՙB33B  BB  BיB33BBיBB  B33BؙBffB33BٙB33B  B  B33BٙBٙB33BB33BڙBffB  B  BٙBB33B33BؙB33B  BB33BB  BיBffB33B  BffBB  B33BffB33BB  BB͙BBϙBBB33B  BB33BffB33BיB֙B  BffB  B  BBBB  B  BԙBffBB33BffBffB33BffB33B33B33B  BffBffBәB33B  BәBԙB֙BffB33BBffBBffB  B  B33BٙBؙBffB  B33BffB33BؙBBB33B  B33B33BBۙBۙB  B33BBؙBٙBB  BBڙBffBBffBffBݙBffBB  BffB33B33B  B  B  BffBffBffBB33B33B33BBϙBB  B  B33BffBffB33BәB33B33B33BәBffBיB  BB  BؙB  BffBٙB  B33B33B33BٙBٙB  BۙBffB  BffB  BܙBffB  BffB  BBB33B  B  BffBffB  BBB33B  BޙB  B  B33BݙB33B33BBB  BB  BffB33BݙBBۙBBBڙB33BBڙB  BBffBBBBffBffBٙBBffB  BBB  BBB33B33BؙB33BؙBBB33B33BffB  BB  BffBffB  B33B  BߙBܙB33B  BB33BffB33BffBBBܙB33BB  BffBffB  BߙBBffBBB  B  B  BffBB33BBffBffB33B33BffBB  B33B♚B  BB33B䙚BߙBffBffBB  B33B䙚BffBᙚBB  BffB33BffBffB33BffB33B  B33BB33B  B  BBB33BffBB33BיB  BؙB  BؙBB33BB  BBٙBffBB33BffBB33B  B33BܙBB33BߙB  BߙBB  BᙚBޙB33BޙB33BffB33B  BffB  B  BffB♚B  B33BffBBB33BBffBB33BffBᙚB  BffB33B虚BffB33B33B33BB33B噚B  B癚B  B  BꙚB33BBffBBB䙚B  B㙚B  BffB33BBffB  BffB  BffBޙB  BffBffBB  B  B  BBB33B33BBB33BBܙBffB33B33BffBߙBffB33BᙚB  BffB  B  BB  BffB  BBBB33B噚B  BBffBBB  BBBffBB홚BffB왚BffB  BffBBB  BffBB33BffB  B33BB33B뙚BffB  B  B33BffBffBB33BffBffB33BffB33B陚BBffBffB晚B晚B䙚B㙚BffBffB33BBB  BBffB  B33BܙB33B  B  B33B33BffB  BڙBڙB  B33B  BBffBB33BڙBffBBffB33BBffBBBޙB  B  BB33BffB虚B  BB虚B33BBffBꙚBffBffB  BBffBꙚB  B  BffB  B  B癚BffB  B  B뙚B  B  BffB33B  B33B  B  BBB癚B癚BBffB  BffB虚B噚B噚B  BffB䙚BffBffBB  BB  B  B33BB33BݙBۙBffBܙB33B33B33B  B33BB  BffBffBBB  BᙚBB  BBffB33BۙBܙBB33BޙBffB  B33BffBffB  B33B  BffBB䙚B33BffBB  BB  BBffB33BffBffB  BBBB  C ffC C 33CCffC ffCfC  CLCCfCCCffC CLC3C   CC3CC  CffC	  CBC C3C BBBffB33BBffB  B噚B33B  B33B33B33B33B  B  BffB  BB  B33BB33B  BffBB  B  BᙚB  B33B  B33B33BffBBBB  B33B33BB  BffBffBCffC33C
BBffCC3C   CffCCCLCfCCCC
CLCLCC33C  CfC   C ffC33CCfC3CCLC33CCC	33CffC
 CC33C3CfC33CCLCffCCffCC  C	C	LCC
  C  BC33CffB  CLC  B33BffB33B33BffB  B33B  BB33BffB  BBB  B  BffBBB  BB  B  B  BBBB33C CCC CfCffCCC	fC  C  C	CffC  C3C33C3C  CffC3CfC!C"C#3C,C,33C/  C+LC+33C*3C(C,33C/C&C!fC$ffC#C'  C$ffC&ffC#3CfC%CCC33CffCffC3CLC  CLC3CC  CC  C33CfCfC3CffCCC33C3CfCfCC33C	C3C3C C
CLC3C	3CfBffC33BBCCffCC 3C  BffB왚B33B33B33BB33B33B  BCffCLCfCLC33CLC33C	ffCC
C  C3C C33C C CfCffC33C  CLC	fC	LCC 33C LC BBffBB  B홚B  B33B33B33BBffCffCC
C
CBBC33C
  CCCC33CCfCC B  BB33B33BB33B  BffBB  BffB  B晚BffBܙBB㙚B33BߙB֙B֙B֙BB33BBB  BffC LB  B  BffC  C33C33C33CfCCfCCLC33CBB  C fC  CLCCfC33C
CC  CfCC  C3C3CCCC CLCfCfCffCCLCLCffC  C  CC C3C33CCC CfCfCffCCC33CCC C BCLCffCfC3C 33B33C C3B33CLCCffC33CCLC33C33C	fC 33BBBBffB33B33BffBffBffBffC CffC C CCCffCCC	C	ffCLCCCC  CffC C 3CC3C C3CfCC C	 CffC
  CCCC33CffCC3CfCCCffC
C3C C	C33BB  BffB  BffBffBffB33B33BBB33BffB33B33BBffBffB33B  BffB䙚BffB  BffB虚BBB陚B䙚BB䙚B  BffBffB33BB㙚B癚BffBB33BB33B  B  B33B33B  BB  CffC
33B33C33C  C CffCffC  C   CC   C  CB  BffBBffBC CLCffCC	C	fC
33C	fC	fC33C3CffBBffB  B33B33B33BB33BffBB33BBffB33BffB  BBBBB  B  B㙚BBBB  B33BᙚBBB  B  BffB33B  BffBޙB33BۙB  B33BՙBיBffB33BffB33BBۙB33B33B  B  B  BBB33BՙBB  BffBBBᙚB  B  B33B33BBᙚB֙BB뙚BBffBB33B33B  B  B噚BBB  BB33B33B33BBBBffB33B  B33BB33BB33B홚B33BBBB  BB33B  BffB  BffB  B33B  BBffB33BffB  BffB33B  BBBffBffBҙBԙBәBB33BffBԙB  BffB  BBffB33B  BřB33BBBBB֙BffBffB  BҙBЙBٙBЙB33BәB  BffB  B  BᙚBffB33B33B  B33BBffBܙB  BޙB33BffB  BffBBBBffBffB  BBffBB33BffB  BffB33BBBBBB33BffBffB33B33BffB33BBB33B33BffBffBݙB33BffBBBՙBB  B33BәB33BҙBffB  B33BffBffBBҙB  B33B33BffB33BҙBҙB33BB33B  B  B  BffBffB33BԙB33B33B  BݙB33BBffBB  B33B㙚B  BffB뙚B  BB㙚B  B䙚BBffB33BBBᙚBB33B  B33BBBffB33B  BffB  BB  B33BBBB癚B  BffB  B33B  BffB33BffB  B33BffB33BffB33B  BffBۙBffBffBBffBޙBޙB  BB33B  B33BffB33BB33BBffBffBܙBffBffB  BffB㙚B33BB  B  B陚BffB33BffBffB癚BffBBBffB33B  BCffBCCLC B33BBC BffC 33C fCCC3C33C fC CBBffBffB33BBB  BBB  B  BB陚BffBBB  BB癚B33BBffB33B33B  B33BffBffB33B  BffB  B33B33BؙB  B33B33BڙBB  BffB  BBBڙBڙB  B33BB  BݙBBB33BBffBffB33B晚BBffB33B33B噚BffBffB  BBBBB33BBBffB  B  B33BBffBffBBB33BffB33BBB33B33B왚B  B  B  BBffB33BffB홚BffB뙚B33B  B홚B33BffB  B  BffBffB  B뙚B  B  B陚BB33B33B晚BBffBffB33B  B  BޙBBffBۙB  B  BffBܙBffBffB  BffB  B  BBЙB  B33BffBffB  B33B  BޙB  BffB  B33B  BffB♚B㙚B  BB虚B33BffBffBffBB  B뙚B  BffBB  BBB33BffBBBffB  B33BB  BB  B33B33BBffBB33BffBB  B33B  BBffBBB  BB  BB  B  B  BBB  B  BffBffBBBB33B  B33BffB  BBffB33B33B♚BBᙚBffB33BB33BB  B33B  B  B33BB33B  B  BffB33B♚B  BffBffBffBffB  B33B33BffB왚B  B33BffB33B33BB33BffB33B33BffB  B33B  B33BB  BBBffB33BB  BBBB  B33B33BffB  BBB뙚B왚B홚BffBBB  B  BBB33B33B  BB33BffB33BBffB  BBffBffB  BB  B  B  BB  BBffBB33B33B33B䙚B  BBffBffB33B噚B33B噚B䙚B  BffB  B33B33B33BB  B㙚B  B癚BB  BBffBffBB  B癚B  BB陚BꙚBffBBB  B33B33B33B  BffBBB  BBBB33BBBB  BBBB  BB  BffB  B33B뙚BffBꙚBB晚B  BB  BffBߙB33BB33B  BBݙBffB33B33B33B  B  B  B  BڙBڙB33B  BffB  B33B  B33BݙBB  BᙚBffBߙBffBffBBޙBffB33BffBffB33BffBB  B陚B虚B33B  B33B  BffB  B33B  B홚B33BffBBffBffBffBBBffBBBffBBB33B  B33BffBB  B  BB  BB33BffBB  B  BBffBBffBꙚBꙚBBB33BBffBBB33BꙚBffBB癚BffBB  BB33B  B33B33BffBBڙB  B  BffB33BB  BB33BffBffB33B33BB  BB㙚B33BݙBB33B  BffB33B왚BB33BffBBBBB  BC CC 33BBC BffBB33BffBBB33B  BffBffB  B  B뙚B홚BffB33BBffB왚B33B  B  B陚BB33BffBB  BBffBffB33BffB  B  BffBBB  BB33BB  BffBffB  B33BBffBffBۙBffB  BݙB  B噚BBBBffB  B33BۙBffBffBffB33BߙBffB  BffB  B33B陚BffB33BffB  B陚B  BffBBBB33BBB33BffBB33B  BffBffB33BffB33B  BffBBffBBBCffBBC 3B  BBBB  B  BBB33BffB33BB33B陚B  B왚B  BffB왚B뙚BBffB  BB  BB33BB33B33B  B  B홚B  B  B  B33BB  B癚BB晚B  B33B33B  BB  B  BB                                                                                                                                                C          B  BffB33B33BffB33B  B  B33B33                                                                                                                                                                            B  B  B  B                            CffCLBCC33CC33C  CffCffC33C3            B                              B  Bff            BB                                                                BffBffBff    BߙB33    B  B虚B                            B33BB  B33                                                B          B33                    BffBff    BBBffBff    BBBBC f                                Bff                                                        BBיBffBff            BffBٙ                                        B33BΙB  B  BffBBBϙB  B33B33BffB33BffBffB33BffBBB33B  B33BffBBᙚBB  BffB33B33BB  BB33B  B  B  B癚B33BB33B晚B33BffBffB  B  BffBBB  BffBBffB噚B33BBB  BBffBffB33BffC33BffB陚BffBBٙB  BڙBffBB33BBBB  BBBᙚB晚B晚B  B  BBffBffBB㙚B33B  B33B֙BڙBffB33BʙB  B33BBffB33BB  BffB  BǙB33B  BffBϙB  B  BBBBљB33BЙB33BB33BљB33B͙BffBBffBϙBBBB  BB33B33BffBffB33B33BҙBҙBBәBԙBԙBΙBffBffBΙB33BBϙB  B33BffBBBҙBB  BBΙB33BffBffBBffBB̙B˙BffB33BB  BBffBffB  BǙBǙB  B  BBB33B33BffBBffBřBB33B  BffB  BBB  B33BB  BB33B  B33BǙB33B  B33BB  BffBBB  B33BΙB33B33BЙBљB  B33BәBB  B33B  BBԙBffB  B33B֙BB33B33BԙBәBffB  BffB  B33BffBЙBBB33B33BffB33BB33B33B  B33BB33B33BB33BʙBffB  BʙBffBffB̙B33BəBffB33BffB  B33BffB33B  B  B  B33B33BffBB  B33BBffB33B̙B  B33BBffBBBBB33B33BB33BffB33BљBBBҙBffBՙBffB33B  BffB33BffB  B33BB  BB33BffBffBBffBffB33BBBٙB  B  BffBffBB  B  BffBԙBBәB  B  BϙBffB  BљBffB33B  BЙBҙBffBffB  B  BffBBffBffB33BәB  B  B˙BffB33B33BBBffBBљBϙBB33B33BљB  BffB  BЙB33BffB33BҙB  B  BәBԙB  BB֙B33B33BffBffBffBB33B33B֙BB33BؙB  B  B33BBיBffBB33B  BBffBBBڙBB  B33B33BڙB  BڙBffB  B33BٙBؙBffBԙBffB  BљB33B  BљBffB  BffBҙB  BB33B33B33B  BffBΙB  BBffBBffBffBBB33B33BB33BB33BffBffBffB33BB33BәB33B33B֙BffB33B  BΙBB                                                    B                                                                        B33B                      BԙB        BәB  B33B33BffBffB  BәBff                                                        B  B  BЙ                                                                BЙBff    BB33B  B  B    B  B    BffB  BBffBB33BffB  B  B  BB♚BB  BBffB㙚BBᙚBBᙚBBffBB  BߙB  BffB  BffB  BB33BٙB33    BffBffBffBffBffB33B    B33B  BffBBB  B  BB  BؙB33    B33B  BffB          B  BffB  BB33B  BffBҙ                            B33    B  B                                    B33B          Bٙ    B    B33    Bff                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                    Bؙ                        B                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                  BۙB                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                          B  BBffBB33BB33B  BBffB  B33BffBBffBffB33BffB  BB33BB33B33BꙚB  BBBB  BffB33BߙB33B䙚BffB      B  B33BBffB33B  BB33B33BՙBڙBBB33B33    B  B  B                        B      B  BffB33BffB噚BBffB33B33BBBB癚BffBBffBB33BffB  B33BffBBBBBBBffB  BBC CCfC33CfCfC  CC3C33CC
LC
33C C
33C
CffC
33C
CC  BffBB33B  B  B33B  B33B陚BffBffB33BB  BBBۙBffB33BBޙB33BޙBffB  BBޙB  BB㙚BffB33B  BBBffBffB  BffBB뙚BffBffB  BffBffBffBB33BBBB  BffB  BffB33B  B뙚BB  BffBB  BffBC  C  C B  BBffBBCCCffC C3C3C33C C	fC
 C
  C
ffCLCfCCC33CC
C33C
fCCC  CfC  CffCCB  BBB33BB晚B33B  B33B33B33BB  B  BffB33BffB  BB33B  B陚B  BffB  B  BffB33BffBB  B䙚B33BffB  BffB33BffB  BBffBBB33BꙚB33B  B홚BBB33BB33B陚BffBffBB  BffBBB33B  B33C  B  BffB33B33B  BB  BffBBBB    B33B  Bff    B  BffB㙚B33B홚B33B33B♚BBBffBCCLC  BffBBB33B33B33B33BffBBB  BB33BݙBBB  BB33BffBB33BffBؙB33BffBBffBffBٙBffBBB䙚B噚B  BBBBffBܙBBBffB33B  B33B33B33BB  BffBffBBBffBBBffB33BffBBB33B33BBBB33BffBffB33BffBB뙚B  BBffB33B  B  BffB  BBBBffBڙB  BffBB  B33BB  B癚BffBffB33B33B33B  BB  B  BffB33BBޙB  B  BffBؙBB  B  BBffB  BB  B  BB33BffBffB33B33BffB֙BffBٙBffB33B  B33BffBffBB  B33B㙚B  BffBffB  B  B33B  B  BB33B33BBBB  B  BBffBBB  B  B  BB  B♚BB33BffBݙBBB33B33BٙB33B33BٙB  BBffBBϙBB  B֙B  B  B33B  B33BBB  BffB33BBϙB33BffB33B  BԙB  BB  B  B  BәBәB  BәBffB  B  B  B  B  BܙBB֙B  BffBffBיBיBffBBBffBffBffB♚B33BffBB  B  BffB晚B33B  B  BB  BffB33B33B  B  BBꙚB  B  B33B  BB  B陚B33BݙBffB䙚BB噚BffBB33B33BffB  B  BᙚBᙚBffB䙚B33BBܙB33B  BBBffBffBBffBBؙBffB  BffB33B  B33BәBBיB33BٙBBBB33BffBΙBffBݙB  BffB  BffB  BBؙB  BBۙB33B33BB  BB33BߙBBffB33BBB噚B䙚B噚B癚B  B33BffB噚BBffB㙚B䙚BffB  BffB33B  B㙚B33BꙚB33BffBffB噚BffB  CCBC fBB33BffBꙚB33BffB  BBffB33B33BڙBۙBٙBޙBߙB  B33BBffBBBBffBffBffBffBB  B33BԙBәB  B  B33BۙB33B  BۙB  BBB  B33B  B  B33BBߙBB33BB  BB  B33B  BB33BffB33B噚B晚B  B33B癚B33B33B33BffB33BffB33B虚B뙚B뙚B  B晚BffB  B晚B晚B䙚BffB  B33B  B  BBffBffB噚BBffBffBffBffB  B㙚BB  B33B㙚BBBB33BffBB  B33BffB♚BB  BB  B33B33B  BffBٙBffBܙBB  B  BB  B  B33BffBܙB  B33BҙBB33BffBffBڙBffBܙBB  BޙBffBffBffB  B  B  B33B33BB虚BffB홚B  B홚B陚B33B33BB33BffBBBݙB  B33BB  B  BB  BB33BBB33BBB33B  B33BBB㙚B  BffB33B  B33BB33B  BB뙚B晚BffBB33BB陚B33BffBffBffB33BۙB33B33BffBBffBәBB33BBffB  BəB͙BљBϙBϙBffB  BؙBffB  BffBB陚BffBB  BԙBffBffB  B噚BB  BffBB33B33BB33C  C3BffC fB  B33BBꙚBBB  BffB  C33CfCCCCLC
LC
33CffC
ffC
C
LBCfCLC  BꙚBffC BffB33BBBBffC
ffC33CfC
ffC BBffBB㙚BBݙB  BffB33B  CBBffB  B33BffBffBB홚BBffBffBffBޙB  BffB  BؙBۙBۙBߙBޙB  B֙B33B33BԙBffBBΙBB  BՙB33BB  BBB  BB  B  B  B  C  BC C 3CBffB33B33BBffB33BffB晚B  BBffB33BffB♚BffBBBBffBBffB33BBBffB  BffBffB  B  BB33B33BߙBٙBffBffB  B33BffB˙B33B33BB33BBffB  BBЙBffBffBffB  B33B  B晚B33BBB33BBB33BffBBffB33B33B  BB䙚B  B䙚BᙚB33BBBޙB33B  B33BᙚB♚BߙBffBB  BB䙚BB♚B  B  B홚BB33BBffB33BffB  BޙB  BB33B  BޙBffB33BffBB  BٙBBffBffB  BBBB  BffBB֙BBffB  B  BBffB33BҙB33BәBffB33BffBיBBBffBffBffB33BڙB  BۙBBffBffBB33BBۙBٙBٙB33B  BٙB33B33BBffB  BB  B  B♚BBB33B33B33B  BffB33B33B뙚B  B  B陚BB33B33B33B33B33B33BffB♚BB♚BBffB33BBB  BᙚBBޙB  B33BffBB33B33BٙB33B33BffBBB  B֙BBB  B33B  BffBBԙB33BՙB33B  B  BҙBBٙBffB33B  B  BffB33BffB㙚BffBffB  B  BffBB䙚B33B33BffBBBB虚B陚B왚B33BB  B  B  BB  BffBffBB  B  B  B  CLBffBBBB33B  BffB  B  BffB  BffB33BB33BB  B  BB33B  B  BB  BffB33BffB癚BB晚BffB33B33BߙB33BffBBݙBBBffBffBB33BffBۙB33B  B  BBBBffB33BB  B  BB  B뙚BBB  BffBB  B㙚B噚B33BB33BB  BBffBB33B홚BBB虚B  BB  B33B  B  BffBBB  BffB  B  B  BBBBffBffB  B홚BBBffB홚BffB  B  B홚BB  B  B33B홚B33BBBffBB  B陚B33B噚B33BffB  B  B  B  BffBB  BffBݙBޙB  B  BߙBB33B33B33B  BffBۙBٙB33BBܙB33BffB33BffB陚BffBBffBBffB33BB  BBBBB  B33BffBBCCffCLCfC CC  C C33C  C ffBC LBBffBBBffBBB  B33BffBBBB  B晚B  B  BB  BffB33B33B  BffBffBffBۙBB  B  BB  BBBB  BB陚B晚BB  B㙚B33B  BffB  BBffB  BB  BffBB33B  B33B  BffBBBffB33B  B33BB  BBffBffBffB  BBffBffB  BBBB33BffB  B33BffB  BC ffC33C ffCC33C   C B  B33B33BffB33BffBBffB  BBffBffBB  BBffB晚B  BB33BB  B虚B33B33C B  CBffB  B  B  BB33B왚BffBffB  BBBffBBB33B33BBB  BffB  B33BffBBBffB  BBBBBffBffB㙚B  B  BܙB33B33B  BffB33BBffBB  B  BB33B33BB  BBBBffB33BffB  B33BBBBBBB  BBffBffB  B  BۙB33B  B33BڙBؙBffB33BffB33B33B  BҙBffBBBffB  BffB  B  BffBB  BffBffBffB33B33B33BffB33BBBBB  BffBܙBBB33B33BffBB33B33B33BffB33BffBffB33BffBffBBᙚB  BBffB33B  B噚B晚B癚BffBB  B33BB  B33B뙚BffBB虚B33B  B33BffBBBffBB  B33B33B  B33B33BffBB홚B왚BBffBB33BBBBԙB33B  BffB33B  B33B  BBBffBBB晚BffBBffBBܙB♚B33B33B33BܙBBݙBBBBffB  BffB䙚B33B  B33B33BffBffBBBffBB33B33B  BBڙBۙBB  B33B33BBڙB33BffBffBB  B33B  BBBBBffB  B噚B33B  B33B33B33BB㙚B㙚BffBB  BᙚBB  B  B  B  B33B  BffB33BBBB  BBffBԙBBffBB33BffB͙BϙB33BffBՙBffB  BffB33BffBBBÙBB  BffBԙB33BԙB  BЙBffBffB33BBԙBBBBԙBffBBBԙBԙBffBffB֙B  B  BBՙBB  BffBؙB  BffBؙB33BBffBۙB33B  BffBݙB㙚B33B33BᙚBffB  BBffB  B33BᙚBݙBٙB33BffB33B33BffBffB  BBٙBۙBffBffBٙBffB  B  BB֙BיB  B33BffB33BffB  BיBBffBBffBԙB33B  B33B  B33BBBٙBBffBBڙB  BBٙBffBۙBffB33BBffBffB  BffB33BޙBߙBffB  B왚BB  BffBffBffB  B  B陚BffBCLBffBBBffB陚BffBffB  BBB33BffBffB33B  B癚B晚BffBꙚB晚B噚BffB  B33BffB뙚BꙚB晚B33BffB  BffBBB33BffB噚B䙚B♚BffBꙚBBߙBffBffBܙB  BޙBܙBܙBۙBؙB33B33BڙB33BffBڙB  B  B  BffB  B33B  BffBffBB  B33B  B33BffB33B  B  BB33B  BffB33BBיBffBBB33B33B  BB  B  BffBB33B33BBݙBffBffBBffBffB33BڙBBffB33BЙBffB͙BB̙BBffBBBBffB33BffBљBЙBݙB  BffBB˙B̙BffBB33BffB  BB  BB33BBffB  BB癚B33B33BBffB  BBBffBB♚BffBB  B33BffB噚B陚B33BffB噚B  BB噚BffBffB  BB  B33BBffB33BBB33BffB33BffB  BޙBB33BffBBBBB  B  BB33B33B뙚BB33BB  B33BB  BBffBBffBB33B33BΙBffB͙BΙB  BB  BffBffB̙BffB33B  BԙB33BffB䙚B33BB  BffB  BBffB  B  B33B♚BߙBffBffB33B33BffBffB33B  B뙚B虚B  B  BffBBffBBBBB33B뙚BffB  B33B晚BffB33BffB  B  B  B  BBB  B33B33BffBB虚B  BffB晚BffBB  CCBffBBB  B  B  B晚B  B33BffBߙB33B33B33BffB  BB  B33BB˙BffBBʙBșBBʙBffBʙB  B33BęB  BffBBBՙB33BۙB  BBܙBݙBffBffBffBffB  B虚BffBB33BffBBffBffB33B  B  B  BffB33B33B  B33B33BBB33B33B  BBffBffB33B  BBBB  B33B  B  BBffB  BffBBBB  BBffBffBB  B  B䙚B33BB33B33BffB33BffBffBffB33BffB33BffBB33BffBffB33BՙB33BBBBșBffBΙB33B  BffB33BffBBffB33B  BB33B֙BBٙBffB  B  BffB33BڙBٙB33B33BBBffBޙBޙBffB33BݙBB  B  BBBBffBᙚB  B  B  BBffBܙB33B33BᙚBBܙBߙBޙBݙB33BB33BffBffB  B̙BffBәBffB33BB  B  B33B  B33B33BBffB33BBffBffBffBffBBBB  B  B  B33BљBffB  BؙB  BB33B33B33BffBffB  BffB  BffB  BffBffB˙B  BffB  BffB33BBؙB  B33BޙBߙBB  B  BffB䙚B33BBBffB㙚BffB䙚BffB  B33BBffBB  B33BffBffBB33BffB33BffB33BܙB  BffB  B33BљB  BffBҙBffBBљBBBffBBffB33BffBٙBBffBBB  B33BBffBBϙB  B33BșB͙B͙BϙBffB  BB33B33BffBBffBϙBB  B  BffBffBݙB  BBBffBffBffBffBB  BffBffB癚BBBB33BBffB  B  B33BBB33BffBB  B  BffBB33B  BB  B虚BffB  BBBBB33BB33BffBЙB  BB33BffB̙B˙BB  B33B  B  B  BBʙBʙBB  B  B֙BՙB33BB  B33B  BffBЙBffBƙB  B33B  BffB  BffBB  B  BܙB33BיBB33B㙚BܙBߙB  B  BffB33BBffB33BffB33B  B  B뙚B  BBBB  BBffBCLCLBC B33CC3C C33C BC ffBBBffBB㙚BffBB33BBۙBBB  BffBffB㙚BBffBBffBB  B  BffBBffBBBffBBљBԙB̙B33BffBB33BBffBBBffBBЙBffBB  B  B33BBffB  BBBffB33BffBffBffB33B  BᙚBffB晚BB33BB33B  B  B33B  BffBBB33B  BB  BffBBBffBBffBBBffBffBBB  BC   BB  B홚BB  B33BB  BB  B  BffBffBffB  B33B  BB  B33BB  B♚BBBffBBB  B33BffBB㙚BffB33BffB  BBBBؙB  BBBBB33BffBԙB  BљBB  BffBЙBffB  BffBҙBB33BB  BB  B33BffB뙚B  BBBB33BBBB33BBffB33BBB33BffB33B  BB33BBffBB33BB  B  BffB  B♚B♚B33B  BB33B33BB33BB  BBffB  BߙBݙBffBffBB33BՙB  BBۙB  B֙B  BBؙB  BffBB33B33BffBBffBffBәBՙBB33B  BBffB33BffB33BܙBB33B  B33BۙBffBBB33BBB33BB33BffB뙚B홚BB33BB  BffB33B33BffC ffC fCC C fC3CffCC CCCCffC ffBBffCffBffCCCffBBB홚BB33B  B33B  BffB왚B33BffB  B33B33BffB33BffB33BffB33BۙBޙBffBߙB㙚B33BffBB33B  B♚BB  B33BBffBffB33BffB  BBBffB  BݙB  B33B33BB33BffBffB  BBBBB  BffBBffBffB陚B33B33B33B33B33BBBB33BBBB33BB33B  BffC ffC  C C C33CC33CLC C3C33C CC CBBBffBB  BٙBffB  BffBՙB33B  B33BBffBBB噚B晚B  BB癚B33BffB  B33BBBݙB33BיB֙BB33BәBBBB33BB33BBݙB  BBffBffBffBB33BffBffB  BffB䙚B33BffBB陚BffB33BBB  B33B33BBffBBBffBBBBB  BffBBffB  B  BBBffB  BffB  BffB33BBBBffB33B  B33BBBBBB뙚B33B33B陚B  BꙚBffB33B䙚B  BffB33BB  B33BᙚB33BffB33BޙB  BᙚBffBᙚB♚BBffB33B  BffB  BB  BBBffB33B33BؙB  BݙB33B33B33B33BB33BffB33B  BffBffBBffBܙB33B㙚B  BBB  BBBffBB33B33BBffBffBBffBB33BBBBffBffB33BffB33BffB  BB33B  BB  BB䙚BߙBәB  BBffB  BڙBffB33B33B  BffB33B33B33BffB33B֙BBffBffBBffBBffBBBffB33B  B33B33BBffBffBB  B陚BB33B癚B虚BBB33BB  B왚B  B33B  BBffBffBBffBffB  BffB33B33BffBBffB33BBffB33B33BffBffBffB뙚B33B  B33BffBB  B뙚B33B33B33BBBޙB♚BB  BffBffB33B33B33BB33B  BffBBffB㙚B  BܙBܙBՙBBיBffBۙBۙBB  BffBBffBBՙB33BBBB  BəB33BBffBffBBؙBffB33B֙B33B33BՙBffB  BB  BffBBffBޙBBB  B  B33B33BffBffBffBffBffB33B  BBB33B  BBB33B33BffBffB  BffBffB33B33B  B33BB̙BəBǙBB  BBÙBffBBffBffBBBƙBřBffBʙB33BəBəBəB  BffB33B33BBffBffB  BәB33BffBיBٙBBؙBffBffB33BffB♚B晚BꙚBBffB왚B  BꙚBffB33B왚BB33BBB33BffBffBB33BBB  B33B  B33BBBBffBB33BBBffB  B  BB33B  B  BB33BB虚BB33B33BڙBffBB  B  BB  BffBBřB  BBffBffBffBǙB  BB33BBB  B33B33BffB33BffBҙBffB  BffB  BәBؙBffBۙBB  BޙB33B33BffBffB  BB33BB♚B  BffB  BޙBBB33BB33B33BB33B홚B  BBB  B33BffBBBffBB  B33BffBB33B  BBB33BffBffB  B֙BB  BݙB  BB33B33B  BәBffBB  B33BffBB33BBBܙB  BB  BffB֙BffBԙBB  B33B  BffB  BffBڙB  B  B  B  B33B  B  BܙBڙB33BBBۙBBᙚBffBB  BffB陚B33B왚B왚BB33B33B  B  BBffBBffB  BBC 33CCLCC CCC33CfCffC 33B33BBffB  B33B33BffBBՙBffB  BB̙B  BBffB͙B33B33B33B33BBBBffBB33B33BᙚB33B  BBB͙B  B  BЙBffBffB  BBB  B33BffB  B33B˙B  B  BffBљBffB֙B  B33BffB  B  B  B  BffB33BffB33B33BffB  B  BffBBB  BffBffBݙBffB33BBBffB  B33BffB33BB晚B33B  BBB  B噚B33BffBޙBBffBޙB33BBBffBB  BBBffBffB33BǙB  BB  B˙B33BǙB33BffBffBB  B  B͙BB33BəB  B33BffB33BffBB  BBBBB  BffB33B  BҙBșB33BəBЙBՙB33B  B  B  B33BB33BffBBffBBBљBBffB33BB  B  BәBԙB֙BB33BڙB  B33BB  BיBffB33BB33BٙBBՙB33BffBB33BșBƙB  BffBB33BB  B  B  BB  B33BBffBBffBЙB  BٙB̙B  BBffB˙BffBBffB33B33B33BffBBB  B  B33BffBffBB  B  B33B33BffBB  B  B  B  BffBBBBB  B  B  B  BB  B  BBffBffB33BBƙBƙBřBBffBffBBBffB  B  B33B33BΙB  B  BffBB33BBB33BffBffBffBffB  B  BBffBffB33BffBBBBffBffB  B  B  B33BffBB33BffB  B33BB33B  BBșBffBB33B33BffB  BB  BBBffB33BBB33BffBBffBBffB33B33BB  B  BBBffBB33BffB33BBB33BB  BffB  B33BffB33B33BęB  B33BBBBBBBBBBffBffBBBB  BܙB  BffBB  BəBB33BșB33B  BffBB  BBffBBffB癚BB  BffBffBffBBffBffBBffBB33BЙBBBșBǙB33B33B33B  BBB  B33B33BB33B33BB  BB  BffB  B33BffBBffBBBBB33BffBffBffBBBffB33BffBBffBBBBBBffBB33BBBBffBffB  B  BffBB33BBB33B33BBBBBB  B  BBffB33B33B  BBBffBffBBBffB  BBffBffB  B  B  BBB33B33B  BBBBffBBB  BffB  BffBffBffB33BB33B  BBffBB  BffB  B  BB  BB  B33BBffBBBBBffBB  BBB  BBBffB33BBB33BBB33B  BffB33BBffB33BffBB  BB33B33BB  B  BffB  BBffBB33B33B  BffB  BBffBB  BBB  BB  B  BBBBBB33BBffBBBB33B33BB  B  BffBBB33BBffB  BffBffBB33B33BBffB33BBB  B  BffBffBB33B  BB  BffB  BffBBB  B  BBBB  BBBffB  BBffBffB  B33B33B  BffBB33B33BBBBBB  BB  B33BBB  B33BB33BBBBBffBB  BffB  BffB33BffB  BB33B33BBffBBffBBBffBBBffBffBffBBBffB33B  BBBB  B33B33BffBffBffB  B  B33BBB  B33BB33B  B33BBBB33B  B33B  B33BBB33B  BffBffB33B33B  BBBffBBffBB  BBBffBffBBBffBffB  BBBBffB  B33BffB  B  BBffB  BBBBBBBffB  BBBBB33BBffBBffB33B  BBB  BffBffBBBffBB  BffBffBBBB33BB  BB  BB33BffBBB  B33B  BBffB33BBffBB33BB  BBBBBffBffB  B  BffBB  BffB33BffBB  BffBBBBBB33BB33BffBBBffBB  B  B33BffBBBBB33BBBB  B33BffB  BBBffB33BBB  B  BB  B33BBBffB33BffBB  BffBffB  BffBBBffB33B33BBBffBB33B  BffB  BffBęBBB  BB33B  BffB33BffBșBBșB33BB  BffBB33BffBBffBBffBBB  BBBBBBB  BB  B  B  B  BffB33BBffBBffBBBB  B33B  B  B  BB33B  B33BBB33BB  B  BffBffB33B33B  BBffBBffBBffBffB  B33B33B  B33BffB  BffB  BffBB  BBB  BBffBffB  B33BBB33BB  BBBBB33B  BęBffB33B33BffB  BffB  BBB33BBffBBffB  BffBffBffBffBBB  B33B  BB33BB  BBffB33BBffB33BBffBffBffBBB33B33BffBffB33BB  BBffBBBB33BB  BffBffBffBBffBBffBffBB  BBffBBBB  B33BBBB  B33BffB  BffB  BBB33BB33B  BffBBffB  BffB33BffBBBBffB  BffBffBBffBBffBB33B  BBB33BB33BB33BB33BBBffBBBBffBffB  BffBB  BB  B  BB  BBBBBffBBBB33BBB  BffB  BffBBBB  B33BBBB33BBB  B33B  B  BffBB  BB33BffB33BBffB33BffBBB  B33BBBffBBffBffBBffB33B33BBBB33BffBB  B33BB  BB  BęB  B33BǙBBB  BffB33BffBB33B  B33B33BBBB33B  BB  BBffBB33BB33B  B  BB33BBBBBBffB  B33B  B33B  BBB  BBffB33BB  B33BB  BBBB33BffBB  B33BB33BffBffB33B33BBB  B33B  BB  BffBB  B  BffBffBffBB33B  BBffBBffBBffBB  B33B33BB33BffB33B  B  BffB  B  B33BBffBB33BBBffBB  B  BffBffBBBBffB  BBB  BBB33BBffBffBffBffBBBBB  B33BffBffB33BffBBB  B  B33BBffB33BffB33BBffBBffBBBffB33BffB33BffBBBffBB33BffB  BB  B33B33BBBB33BffB33BBffBffBB  B33B33BBBBBB33B  BBBB  B33B  BffB  B  BBBB  B  B  BB33BB  B  BBB  B33B  BBffBBBBBBBffBBBffBBB33BB  BBB33BffB33B33B33B  BBffBffBffBBBBBBffB33BffB33BBffBB  BB  BBffBB  B33BBBB  B33BB  BBBBBffBBBffBffBffBBffBB  BBBBBffBBffBB  B  BffBBB33BffB  BBffBffBffBB33BBffBffB33BBBBffB  B33BBBB33B  BB33BffB  B  BBffB  B33BffB  BB  B33B33BffBffBB  BBB  BB33BB  BBffB  BBffBffBBBB  BffBffBffB  B33BBB33BBBBffBffB33B33BffB33BffBB  B33B  BffBffBBffB  BBBffB33BBffB33BB  BB  BBffBffBffB33BffBffBBB33BffB33BffBB33BffBBffB33BBBBB  BBB  B33BB33B33BffBffB  BBffBBBB  B33B  B  BB  BBB  BB  BffBB33BB  BffB33B  B33BB  B  BffBBB33B33BffB  BBB33B33BffBffBffBBB  BB  B33B33BBB33BB  BBffBffBB33BBffBB  BffB33B33BBBB33BBffBBB  BffBBffBBB  BBffB  B33BffBffBffB33BffB  B  B33BBBffB33BBBBffBffB33B  B33B33BB33BffBffBBffBBBBBffBBffBBB33BBffBB  BBffB  BBB  B  BB  BBffBBffB33BBB  BffBB33B33B33B  B  BBffB33BBffBBffBBffBffB33B  BBffBBBffB33B33B33BB  BffBB33BffBB33BffBBBBffB33BffB  B33BBB  BBffBBffBBB  BffBB33BB33B33BffBB  BBffBBB33BffBBBffB33BffB33BBBB33BBBBBBB33BB  B  BBB33BffBB  B33BffB  B  BffB33BffBffBBB33BffB  BB  BffBBffBB  BB33BB33BffBB  B33B33BBB  BBBffBB  BBBB33BB  BB  BBBBBB  BBffB  BffBffB  BBB33B  BffB33B  B  BBffBffB  B33BBB  B  BB33BffBBB33BffB  BffB  BB  B33B33BB33B  B  BffBffB33B33BBB33BBB  BffB33BBB33B  BffBBBffB  B33BB  BBffBB  BBB33B  B  BBB33B33BffB33B  BBBffB  B33BB  BB  B33BBffB  BBBffBB  BB33BBBB33BBB33B33BB  BBB33BBffB33BBffB  BB  BB33B  BBffB33BffBByBBB  BBB|  BBffBffBBBffBB  B  BBBB33BBBB33BBBB33B  BBBBBffBffB33BffB33B  BBffBffBBB33BBB33B  BB  BBBBBBB33B33BBffBBffBffB  BzffBxB  B  BffB33BzffBhffBeBcBcBmBl  BhBqBeBo33B~  BzBj  BlffBp  BffBffBBBffBBffBBB33BffBffB33BB  B  BBBBBBBB}33B33BBffB  BB  BBffBffB  BBBffBBB33B  BB33B33BB  BB  B33B33BBBffB33B  B  BffB33B}33B33BBBB  B33B  B33BB  BffBBffBffB33BB33BB  B  BBBBB33BBB33BffB  BBB33B  BBBBwBBB}B}33BffBBBBBBffBffBB  B  B~BBffB  BBB  BffBB  B  B  BB}Bj  Bt  B~B  BBBBffB}B{B~ffB~B  B33BBBwB~  B}33B  BBBffBm33BwBzffBxffB|ffBw33By33BtffBe33Bc33B`BkBr  BZ  BY33B_BlffBt  BtBs33Bu33BwBzBvffBtffBtBmBn  BbffBjffBpffBtBx  BvBpB33BB  BB  BBB  BBffB  B|  B}33B  B33B  B  B33BffB  B33BB  B33BBBs33BkB33BvffBzffBxBu33BhffBdffB]B]Ba33BjBrffBxBwBvffBx  BwBxByBwBrffBh  BdB^  B]B^BjBoBsB33BB33BffB  B  BBBB}B|B33B  B|Bn  Bt  B}BzB  B33B~ffBo33BmBq33Bg33BjBg33BbBdBg33BfBe33BhBhBX  BTffBXffB^  BY33BZffB`BdBgBN  BR  BVffBZ  B\ffB\  B_33B`  B^  B^BgBdffBe33BbBk33Bj  BhBlffBjffBl  Bl  Bp  BoBi33BhB`ffBbBh  B\B^B^BhBo33BNffBQ33BM33BRffBV  BRffBS33BM33BTBTB[33BTB\  BcB_B`ffBJffBLBRBYB\Bb  Bf  Bf  Bj  BiBnBfB`  BfffBnffBlBn  Bs33BpffBu33BoBm33Bo33BkBbBl  BlBm33Bq33B\B^  BdBnBp  By33B}B`ffBi33BhBtffBoBpffBrffBoBtffBfffBwBvffBbffBfffBhBc33BhB^ffB`  BhBoBr  BrffBr  Bp  BoBp  BsBoBt  Bk33Bu33BpBvffBv  Bv  Bn  BgBcBfffB`Bh  BeB^B]33B^ffB^BZB^BZffB\ffBVffBXffBT  BGBBBD  BM33BS33BV  BPBSBNffBJffBLBTffBU33BWBV  BNBDBFBDBRffBOBM33BQ33B]B\  B_33B_B[33BaB\ffBhffB[B^ffB]B^ffB[B^  B_BjBgBjffB^ffB`BeBbffB`ffBhB^  B[33B_33BTBJBJBEBP  BV  BRffBPffBNffBM33BP  BJBFffBJBN  BN  BK33BX  BBffBDBB  BAB<  BDBK33B<ffBBffBE33BDBDBUB`ffBLffBNffBNffBR  BS33BV  BVBX  BUBT  BZ  B`ffBM33BLBO33BfffBjffB_33BS33BOBS33B[33BlBjBdBiBhBi33BX  B^ffBa33B[BKBEBBBDffB@  BE33BFffBNBQBO33B`  BQBP  BP  BQBRffBX  BNBSBUBVffB^ffBU33BVB[BjBe33B`B^ffB`ffBE33B;33B<ffBBBH  BE33BHffBN  BNffBI33BEBA33BE33B@B8B2ffB(  B*ffB0ffB;B8ffB>B>  B/B(B@ffBHffBH  BM33BPBGBI33BG33BLffBHBL  BRBaBaB[33BP  BLBLffBOBW33B\  BjBp  BvBoBjBp  Bs33BrBt  BxBqBqBr  B{33BgBq33Bp  BzffBrBxBwBqBtBt  B{Bq33Bo33BkBpBi33Bj  BfB^BR  BVffB_33BVffBLBQBPBD  BHBP  BLffBNB@BFffBc33BTffB<  BDBH  BRffBUBTffBQ33BMBR  BS33BPffBPBUBXBTBPffBU33BBBI33BDB>B@BD  BFffBTBT  BXBXBRffBUBT  BSBZ  B\ffBaB^  BhffBd  B_33B^BBB>ffB>ffBRffBaBfBh  BiBB|ffBvffB{B33BffBBBffBlffBdBv  Bv  BffBB~B|  ByB33BBv  By33B|  BB~BpB  B`ffB`BsB}33BnffBeB\BN  B>  BA33B@  B=B2  B&B,  B+B,ffB3B,B/33B$  B&  B&  B)B(ffB"ffB ffBB&ffB!33BB33BffB33BBB33B)B*ffB+BBB&  B-B2ffB4  B  B&B333B133B.B,ffB2B8ffB.ffB)B5B8  BE33B>BJ  BH  B,BB'33B4  B3BCBP  B[33B[33B\ffBTBYBZ  BVffB`  BZBd  BLBAB>BFBPB>B=B/33B&ffBBffB  B	BffB  B  BB
B	B
ffABffBBB  B  BffB  BA  AffBBffB  BBffB33AffAA  B ffBAffAffABAA  A陚AAAAAffAA33A  AA陚A33AA33A  AAB  B ffB33B
  B
  BBffBBBBffB)B-33B.  B,  B/B=B2B5B%33B*B:BIB.ffB,B8ffB/B.ffB)B'33B$  B0ffB<ffB+33B33BBBffBffBB  BB33BB
B  BBBBffBffBA33B   B33AB33B  BB  BffBffB  B"B"B6  BB%B%33B)33BBBffBffBB  B33BBffBffB  BB#33B#B"ffB<  BJBA33BE33B;B;BKBZ  BRffBR  BDffBHffBK33BL  BJBTB]BiBBffBy33BpBY33Be33Bn  B]B^BZ  B\  BV  BB  BPBO33B=BBffBFffB6B&B)33B-B2  B/33B2ffB.B+B-33B/33B:B6B0B8B0B.ffB2  B333B8  B-B0  B'33B%33B(ffB)B,ffB-33B4ffB.  B+B(  B0  B0B:  B4  B0  B2ffB4B933B?33B2ffB#B  B$B&  B.B(  B)B=B1B=33BQ33BVB^  BN  BQBb  B_Bf  BlBrffBBffBeBc33B]33BBzffBmBm33B|ffB33B33B  BBffBm33BzByBw33Bz  BlffBj  BffBB}33Br  B33B{Bk33BhffB_33Bb  BR  BRffBL  BPffBO33B[33B^ffB\ffBXffBDB=BHffBVBw33BLffB8ffB0B5B6  B?BPB=33B?33B:B0  B.  B8ffB8B6  B2  B,B'B   BB  BB33B$ffB-B2ffB"  B ffB$ffBffBffB"  BffB(B$ffB,  B&B8B4B6ffB.ffB<  B1B5B?33BD  BGBeBJffBJ  BO33BIB8ffBEBO33BS33BTffBYBBffB>B=33B,BB#B2ffB2BAB<ffB<BNffBTffBJBE33BS33BW33BOBY33BK33BSBA33BC33B6B-33BOB4ffBF  BJB@BTBTBH  BT  B0ffB(ffB(  BffB   B133BBBffB  B4  B9B@B<  B=33BKBO33BVBN  BEBL  BO33BH  B<B0B*  BBB6ffB8B1B133B/B;BH  B]33BVB_33BR  BPffBLffBG33BYBPffBSBTffBfB}33BX  BJBDBhffBffBBffB|ffBxBBvBr  BzBffB}BvBy33Bk33BUBW33BYBYBPB=B)33B2  B)33B333B733B"B B  BBffB
  BB0ffB$ffB&  B*ffBFB6ffB:  B-B<ffBAB-B(  B(B,B533B8  B<B:B2ffB2  B*ffB533B-33B(  B8  B.ffB)33B&ffBAB:  B ffBffBLBFffB@  B=33B0  B2  B<ffB?B>ffBDffB<ffBEBBffBLffBGBGBF  BFffBVBZffBXffB^  BOBTB`  BbffBeBRffB_BnBu33B33B`BkBBBrffBRB`  Bv  BzBwBfBrffB}BBB]BlffBu33Bk33BeBzB33B|  B\  BZffBYBSBO33BLffBFBHffBSB6B>ffBHffBG33BHBV  BXffBIBSBZBPffBX  BbffBa33BXffBPBXBeBOBH  BNBH  BNBHBF  BI33B/33B,  B$  B8  B1B,B+33B,ffB133B0B8ffB@  BDBQBSBVffBQ33BNBHBJ  BNBRBC33B=33BR  BYBbBjB\B`  BPBdBl  BQ33BPB]Bo33BqB`BpB\Bv  BnffBl  BlBhBjffB\  B\ffBr  Bh  BhBZB`Bc33BIBFB>  B4  B/33B2ffB5B<  B*  B'33B(ffB&BffB%B33B  BffBffBB&  B2  B3B<  B7B6  B7B=BHffB>  B1B9B,  B933B6B6  B,B.B3B/B0  B(  BBB   B(  B)33B33BB*B1B,ffBB.ffB1B;BK33BGB>B8B+33B#B(  B+B4B@ffBJBR  BU33BYB@ffB:ffBEB8  B>ffBM33BRB`ffB_Bc33BnffBcBN  BOBG33B^  BXffBo33B`  BT  BPBQ33B\  BY33BLBA33B,  B%BG33B:B<  B;33B6  B6  B0ffB.  B/B4  B*ffB133B0B3B133B;B8  B.ffB;B6BMB<  B0ffB<ffB,B.B6ffB0  B4  B$ffB(ffB&  B&B(B533B(B+33B   BffB$ffB.ffB8  B6ffB5B)B533B.ffB$  B$B&  B.  B%B(  B&ffB33BffB33BffB33BB33B)B.B)B#B*ffB%B,ffB-33B=33B*  B4ffB0  B,ffB4ffB,  B!33B"B"B6ffB+B*B$ffB&ffB1B@ffB:ffB,B  B  BB33BB
ffB	33B
  B ffBB  BffB  B  BBB33BB33BB)B!B'33B&B&ffB,B'33B!B"BBB+33BffB  B33B33BBB33B
B  BBBffBBB  BBBBffBB
BBBffBB  B  B#33B*B33BBB33B$ffB#33B  B!B*B!B"B"  B$ffB(B$ffB5B/33B-33B(B0  B.B,B333B)33B"ffB33BffBffB33B.  B0ffB1BT  B<  B333B.ffB  BB$ffB'B0  B BffBB33B$ffBB  BB  B
BffB3B733B2B2B.B&B%33B+33B#B!33BB  BB!BBffB  B33BffB*ffB+33B0  B-33B8  B&  B,B4B=B8ffB8  B8ffB3B0ffB.B1B(B&B.ffB&  B!33B(  BBBBffBB%33B)B%B%33B)B&  B8ffB8B<ffB7B,B0  B.ffB$  B  BB$  B
33B33B	B
  B
  BB
  B  BB0B!B$B333BffB33BffB33B  BffB  B  B
B  B
BBBB  B  BBffBBB	B33B  B
B  B
B  B  BffB33BBffB AB	33BB
  BB ffB B  AAB33BB33B  BB  BBBffBB  B  B
33BBBffB
  B
ffB  B  B  B  B  BB
B
BBBBBB33B33ABB ffBBAAAAffB  B33B  B
  BBBB!BffB  B  BB  B"ffBBBB3B,ffB  B ffB/33B   B33BB   BB
BBA33A33BBffA  AffAљA  AAffA33A  A33AݙAB BA33B33BBffB  B33ABBA33B   BBA33B33B ffAB  BB ffB33AAffA33BffBB33B33B33A33B33BffA  B33A33A陚AffAAB33B  B	33BBB33B  BBBB  A  A33A33A33AffAAffAffAA噚AAffAffAAAAffAAffB A홚A噚A33A  AffAffAAffA  B33AAffAffA  AAB BffB  A33AffBffB  BBB
  BBffBB33B  B33B  A33AA홚AffAAB  BB!BffB33B33B  B  B33BBBBffB33A33BB
B  BffBB33BffBffBBBBBffBffBBffBBBffB33BffB33B	B33B	33BBBffBBBBB
  BffA33B  BB33BBffB
  BffAffB33BBAAA33A33BBffBffBBffB33B'33B33BffB  B+33B&BffABffB  BffBBBB33B'33B0  B)B9B/33B,B0ffB(  B;B=BK33BIB?B8B=33B:ffB'BffB'33B$  B2  B,ffB*B333B>  B:B4  B333B/33B)33B#33B%B$BffB#B)33B9B3B%BffB33BB33BB  B#B33B	33B   BB33BffBBBB+B  BffB  B  B"ffBB!BB	BB33BffB B   B#B)B&ffB33B
BBB"  B'33B,B'33B(  B0  B*  B%B(  B&B3B$B4ffB:ffB6B0ffBK33BQ33BP  BJ  B;33B2ffB,  B2ffB<  B:  B-33B8ffB4  B/33B$  B$  B(B!B9B333B=33B8ffB$  B,ffB333B6B2  B(B!B'33B6ffBD  B:B=B:  BLBWBE33BC33BBB6  BBffB=33B>ffB0ffB-33B8ffB933B@ffBCB6  B6  B6B@  BK33B?B0B.B,  B$  B!B33B  B#33B,B/33B*  B.B8ffB33BB33BB  BffB*B#BBBBffBB&  B5B)33B B+33B#33B ffB"  B'33B#B)33B.B0  B533B>ffB(ffB333B9B?B@BN  B]BdffBZBe33BYBNBSBN  BMBQBNBDffBF  BDffBHffB5B733B533B)B0  B.ffB8ffBNffBaB^  BUBRBJBJB]BZBTBJffBT  B5B4ffB2B&B8  B-33B.B8  B%B-B933B@ffB0B,  B$  B"  B/B,ffB(  B.  B-B!33B&B-33B$  B#B&ffB"  B)33B)B,B,  B4ffB133B:  B8  B=BAB>  B=33B6B333B*ffB"ffB*B6  B6BHBABRffBYBUBZB`ffBP  BHBN  BW33BZBYBW33BaBY33BHB@BD  BLffBNBK33BRBQBFffBHB<  BD  B@ffBB  B2ffB+B;B+33B'33B4ffB=B>  B@  B@ffB<ffB@B@ffB>BHB6B933BB  BE33B8  B:B.ffB>  B)B0ffB1BIBGB@  B2  B2  B0ffB<BFBD  B&  B'33B*  B,B,  B&ffBBBBffB33B ffB(  B"BB$  B#B*B'B4ffB4B7B>BI33BHBK33BN  BOB8  B0ffB8  B;33BCB@B;33BCBC33BM33B@  BJffBO33BT  B?BCB8B733B2ffB+B2  BG33B0  B@B>BC33B:B>  B4B9B;33B<BJffBXBYBPBG33B>ffB7B?B%B,ffB(B+BH  B<B9B?33B733BAB@BUBEB*  BffBffB2  B-33B*ffB+33B)B*  BBBffB33B  B  B B33BB,  B&ffB$B  B  BffB33BBffB)B133B4ffB133B8ffB6ffB8ffB,ffB0  B8  B+33B(  BffBffBB"ffB4ffB;33B/33B733B2ffB(  B!B$ffB!33BffB&  BffBB!B)33B(ffB"  B(B%33B  B33BA  BffBB:ffB*ffBBB  BBB33B33BB  BB	33BB ffBB
  B  BB
B  BA33AݙAAAffAAffA  A  A33AffAffAA  AAffA33A33A33AffBAffA  AAffB ffB
B A  AݙAA噚A홚AB
B
33BB ffB$  B*B.  B2B2  BCB<  B\BHB)33BBBI33BHBJBF  BM33BM33B9BkBb  BKBJffBFBKBH  BI33BU33BZffBVB@  B4  B@B<  B<ffB<B5B,B/33B$  B.  B/B,  B(B&  B2B'33B-33B!33B33B!B0B533B4ffB6  BRffB733B
B33BB&ffB>  BA33BEBHBFBA33B4ffB&  B4ffB.  B5B9B7B*  B533B>B733BBffBDBGBE33BDffBTffBL  BM33B\BoBtffB33B33B|  B{BxffBuBqBdffBVffBL  BSBVffB`  B`ffBX  BXBYBI33BIBHffB3BA33B:ffB4B5B(B$B,B.ffB/33B2ffBB  B@  B<ffB.  BffB#33B?BBBB  B33B!B6BBffBHBK33BJBG33BFBLffB]33BI33B9B:ffB>ffB333B'33B,ffB(ffBB$B<ffB)BBB$  B4B2  B0ffB8B)33B6  BJ  BNffB933B/33B33BffBB(B/33B8BRffBf  Ac33AdA^ffA\Ah  AaAaA^ffAh  AQA\AVffAQAS33A\ALANffAP  ALANffALALALAK33ANffANffAK33AIALALAK33ANffAK33AQALAP  AP  ANffALALANffANffAQALAK33ANffANffAQANffAP  ALAK33ALANffAIANffAIAIALALAK33AK33AK33AK33AK33AIAIALAK33AIAP  ATATAS33AQATAP  AQAP  ANffAP  AX  AX  AS33AYAVffAS33AYAS33ATAQAP  AQAS33AQAQATAP  ANffAS33ANffAP  AQAQAP  AP  AQAQANffANffAQANffANffAK33ALAP  ALALANffANffAP  AP  AK33ANffAK33ALAK33ANffAIAP  ALAK33AIAIAK33AK33ALAK33AH  AK33AK33AIAIAK33ALAK33AK33AK33AK33AH  AK33AK33AIALAIAK33AIAIAK33ANffAQAX  AS33AS33AS33AX  AS33AVffAS33AS33AS33AP  AP  ANffAP  ANffANffANffANffAP  ANffAP  AQAQALANffANffANffANffALANffALALAK33ALANffANffALALANffBBԙBݙBB33BB䙚B㙚BffBBBB  BffBffBffB33BBCLCBCLCC33C  CC CCfCffC CffCCLCCLC33C C33C CCLCffBB33C   B  C3CB  BBBB晚BBffBؙB  B33BB  BBB  B33BؙB  B  BBBffB  B  B33BffB33B  BffB  BffB癚B33B  B  B33BffBB  BBBB  BBBBffCCC3CffC3C CfC33C3CLC C  C C C  C CffCLC
  CCB  CC LB  C   CfC
  CLC33C3C33CC C  C CLCffC  C	C	LC	fCC3CffCC3C 33C B  C3CLC3CffCffB  CLC  C 33CffBB33B  BB33BBBB33B  C	ffC	ffC
  C
  C33CfCCC3CC3CLC
C
C	fC	C	 C	CCCC33CffC33CfCCC3C CffCCLC33CC33BBBBBB33BB  BBBB  BB  BᙚB뙚BffB癚B㙚B晚B  BBBBffBffB  BB  B  B  B  BBיBBB  BݙBᙚBB뙚BffBB  B33BffBffB33B33BBffB  BffBB33BffC C  C 3C33CC C CfC CLC3C3C CC3CffCfCCC3CfBB33B  B  BBffB33B33B  BBBffBB  BffBBffBffB  B33B33BB  B뙚B33B33B왚B  B  BB33B  B  BB  BڙBݙBڙBBffBיBffB֙B  BffBffB  B33BffBB  B33B33B  BffB  BBBB33BB33B33BffBBBBBffBC 3CCffC33C33C3CffC33CC C	CC  C33CC
LC	 C3C33B  CffBffB  C B  BffB  B33B왚BBB  BffB33B  B홚BBB  B  B33BffB  B33B33B33B  BffBBffB33B33BBffB  BffBܙB33B33B  B  B  BԙBffB  B33B33BBBffBؙBffBיB  B  BffBffB33BBBffB33B33BBffC C C3CC CfCC
CC33C  C  C
CBBBCCLC   BffBffB33BB  B33B33BffB  B  B33B33BBB33B  B33BB33BffBۙBB33BݙB  BffB  B33BffBܙBݙB  BB晚BBffBffBB֙BB  BܙBݙB33BffB  BB33B  B33B  BffBBBB33BffB33B  B  B33CLC CC	LC
33C
 C  C	fCLCLC3CffCffCCC3C3C"CC3C33C fCC
CLCC C
LC3CC  CCCLC3C  CC33C33CffCC CLCCLC33C CCfC B  BffBCC
ffC	3C3C C33BffC3BC BBBB  BޙB虚B晚B  BffB  BffB䙚B  B噚BBB  BffBffBffBBB33B33BBB  BܙB  B33BB  BB  BB왚B33BB  B  BffC33C3C
ffBBC  CfCLCffCCffCBffBBffBݙB홚B  BffBffB  B33B㙚BB33B  B  BBffBٙBؙB33B33BșB  B  B33B  B33BB  B  B  BșB  BB33BffB33BB33B  BʙB  BffB͙BBәBffBB  BffB33BݙB33BffB33B33BB  B  BffBיB  BffBՙB33B  BffBBBBBљBҙBљBBљBBB33BffBәB33B33B  B33B  BљBB  B33BB33BB  BBB  BffB͙BffB  BB  B  BffBffB˙BB  BffBBəB33BB  B  B33BBB33BB  BǙB33BB33BffBffBffB33BșB33BB33B  BffBB  B33B˙B33BffBffB33BBBՙB  BB33B  B  BffB㙚B33BBffB왚BffBB33B  B噚B  B噚B♚BB  B33BffBBB  BffB  BՙB33BB  B֙BՙBffBBffBffBљBffBffB33BffB  B33B33BffBB  BBB33B  BffBB͙B33BffB  B  BB  BffBffBBΙB33BԙBBffBؙBB  BffBffBᙚBBBۙB33BߙB33BᙚBB  B33B  BffBffB  B  B  BffB  BC  CCfBffBffBffCfB33B  BffB  B♚BBBB33B  BffBffBBB33BB  BBffBיBB33BffB33BffBBBffB  BffBՙB֙BffB33BB33B33BffBB  B33BǙBBffB  B33BffBBffBB33BΙBffBBffBffBB33BBffBܙBڙBԙBBؙB  BffB  BߙBffB  B33B陚BB  BffBBffBffB  B  B33B  B  BB  BBffBffB33B  B33B噚BffB♚BڙBBffBffB33B33BᙚB33BᙚB  B  BBffBffB33B㙚B33B♚BffBffB  BffB33BؙB  B  B33B33BffBBffB  B  B  B33B33B33BΙB  BЙBffB˙BffBəB  B  B  B  BÙB  B33BB33B  BB33B  B33B  BЙB  BffBffBBffBB  B33B  BffB  B33B癚BffB  B33BBffBBB  B  BffB33B33BffBffBڙB33B  BՙB  BffB㙚B33B33BBݙBBݙBۙBיBffB33B33B33B  BəBBffB33BffB33B33BřB33BBBʙB33BǙB  BffBΙBB33BB33B  B  BЙBΙB33BffBǙBffBB̙BЙB  B  B33B33BffB  B33BB  BڙB33BffBBBBBBffBffB33CffCCfC C  CffC
  C3CffBBBBffBffB33CB33BffB33B33B  B  BC   B  B  BffB33BיB  B㙚BBBB33BBBffBBB33B  BBffB33B33BffBffBffB33BәBәB  BffBϙB33BЙBB33BffBffB  B  BBffBB33B㙚B噚BBBBffBffB33BBBffB33B33BCBB䙚B33BCC	33CC BCfCB33B  B33BC LCffB33B33BBBB  B  BB홚BBBߙB  B33B  B33BB  C B33B  B33BB33B  BϙBBB  B33BBB  BB33BffBffB33B晚B33B33B33BBBB33BܙB33BB  B홚B왚BB왚BB  B  B33BBBffBB33B  BBޙBffBffB  BB♚B  B33B  BBBffB33B33B33B33BB  B33B  BBBBBBB33BBB  B  BBffB  BB  B  BffBB33BB癚B  B33B33BffB  B33BBffB33BffBB  B  BffBffB陚BB  BB33B  BB  BBBBffB  B33BB  BߙBffB33B33BB33B  BB33B  BB  B  BffB33BBffBB33BB33BBߙBBffBBҙBffBffBșB  BBffB  B33BBffB33BBיB  BB  BffBffBffBffB  B˙B  B  BBffB  BffBffBЙBffBљBffBffB33BϙBffB33B33B  BB  BffB̙B  BB̙B  B33BBəBșBffBBƙBffBffB33B  B33BBBÙBBffBÙBffB  BB  BffB  BBffBffB33BBffBBB33BB33BB33B33BffBffBBBB33BBB33B  BB33B  B  BffB  B  BęB  B33B33B33BBęB33BffBffBBffB33BBÙBB  B33BǙB33B  B33B  B33BʙBBffB33BBffBffBǙB33B33BB33B33BB  B  B33B33BəB  B  BB  B33BffB  B  B33BBęBBʙB  BB  B  B  BƙBBffB33BBęB  BBBBffB  BřBffB  BffBBB  BșBƙBffBBBBBBffBB  BBffBffBffBffBB  B33B  B33BٙBB33B33B  BBffB♚BBffB  BڙBܙBffB  BBB  B33BΙBBəB͙B  BBBBəB˙BљB33BB  BB33BffB33BffB  BffBBffBB33BffB͙BΙBBBęB33BffBBB33B  BffB33B  B33B̙B  BΙBәBBffB33B  B33B  BB  BՙB  BBffB  BBB  BB֙BffBffB33B  B33BBffB33BBٙB  B33BffBBB33BיB33BBיBffB33B33BBffBB  BBffB33BBBB  BBB33BBBљB33BffBffBЙBϙB33B  B͙B̙BΙB33B  B  B  BB̙BffB33B˙B͙B33BffB33BffBB33B͙B33B33B  B33BB33B33B33BΙBffB33B  B  BBB33BԙBffBB  B33B  BffB  BffB̙B  B33BffBљBљBB  BffBBffB33BΙBΙBBBΙBB33BBBffBBffBB33B33BffBBB33BəB  B33B33BffBB33BBffBșBșBəB  BffBBəB33BffB  BʙBÙB  B  BșBBəB  BffBʙBB  BB  BBffB̙BffBffB33BB  BB  B33B  BB͙B  B˙BʙB˙BBʙBBBffBffBǙBffBBBffBBřB33BffBʙB33B˙B  B33BʙB33B  BB  B33B33B33BffBșBșBffBBǙB33BƙB33BƙB33B33BffBffBffB33B  BffBÙBffBB33BřBffBƙBșB33BffBB33B  BؙB  BB  BffBҙBBB33BffB  BԙB  BffBBffB  BB  B͙B33BΙB  BffB͙BffBBffBffB33B33BffBB  B͙BffBB  BBffBB33B33B˙B  B˙B  B̙BәBB  B֙B33BffB33B33B33BB晚B33BffBffBffB33BffBffB33BBffBffBffBᙚBBffB♚B33BBᙚBffBffBBffB  BߙBBffB33B  B33BffBffBffB̙BؙB33BBffB33B33B33B33BBBיB33BffB33BffBB33B  B33B33B  BBffB  B33B  B  BBÙBffBffB  BBřBB  B33BB  B33B33B  BB˙BʙB33B33BʙB  BffBffBB͙B  BЙBBffBffB  BΙBBBB  B33BffB  BBffB33B͙BBϙB  BffBBffBؙBBΙB  BЙBffB33B33B33BљB33B33B33B33BB33B  B  B  BBffB  B33B  B33B33BB33BffB  BffB33B33BffBB33BffBffB˙B33B33BBǙB  BffB33BffB33BǙBəB̙BBBffBffB̙B͙B̙BffBBffBffBffBB  BffBřBffB  BB  BșB33B˙BB˙B  BBffBBBșBəBffB33BffBffB̙B̙B33B͙B͙B33BffBBB  B  B33BffBBffBB  B  B33BffBB  B33BffBЙBЙBBBffBϙB33B33BΙBffB  B33B33B33BϙB  B33BBffBϙB33B  B  BBffB  BB33B  B  BBB˙B  BǙB  B  BB  B  B  BffB33BəBffB  B33B33B33BffB33BəBffBffB  B  B  BʙBffBBʙB  B  BBșBffBʙBB  BB33B  B  BϙBΙBBffBffBffBBffBffB  BҙBffBffB  BffB33BffB33BffBffBffBB33B  B̙B˙B̙BffBffBffBffBΙB33B33BffBB33BffB33B33BęBBB33B  BęB  B33B  BffB  BB33BffBffB  B33B33BB33BBBBffBBBB  BffBffB  BffBBB  B  B  B33B  BB33B  BƙB  BB33B  BBʙBB33B  BffB33B33BffB  BffB33BffBBffB  BBB  BffBB  BffB  B33B֙BB  B  BՙBffB  BffBffBԙBיBBB  BәBffB  B  BffBϙBB͙B33B33BřBB33B  B33B  BřBBffBBffB  BÙB33BffBəB33BșBffB  B33BÙB33BƙBBǙB  B33B  BB33B  B  BffB  B33B33B  BBffB33BffBٙB  B֙B  B33BB  BߙBffB  B33BBBBffBffBB33BBffB  BffBffB  B33BۙBffB  BBffBB33BיB33B  B֙BB  BffBBՙBәBB  B  BB  BffB33B33BBBffBBffB33BBB  B  BffB˙B  B33B33B  B33B  B  BffBffB33B33B33BBffBB33BffB  BffBƙB33B  BffBB33B  B33BՙBffBB̙BffBBffBBffB  BיBؙB  BBffB  BffBB  BffBffB  B33B  BٙBB  B  B33BܙB˙BffB33B33BܙBffBݙBffBЙBffBB  BBffBffBҙB33BB33B  BBffB33BffB֙BffBffB33BʙB  BB  B33B  BB33B  B  BBBB33B  BʙB33B  BǙBB33B  BffB33B33BB33BBBffB  B33B33B  BffBəBB  BffB˙B  B33BffB  BԙBԙB  BәB33B  BB֙BffB֙B33BBffB33B  B33B  B  B33B33B33B33BffB  BϙB33BffBBBЙBffBΙB  BB  BʙB  B  BƙBffB̙BB˙BffBB33BB33B33B  B  BB33BB33B  B  BBB  B33B33B  BB33BffBBffBB33B  B33B  B  B33BffBBBffBffBBffBBffBB  B  BBB33BffBB33B  B  BBffBęBęB33B  B33BffB33BffB  B33BęB  BffBřBBffB33B33BffB  B            B͙B  BffB33BB33BBffB  BBƙB  BʙBBffBBșB33B  B33BBffB  BșBffBBffBB33BʙB  B33B33BffB͙B33B  BffB33B  B  B33BffBB  BBǙBřBB  BB  B33BBB33B33B33BƙB33BBB33B33B33B33BBęBřBB33BffB  BffB33B  BƙBBəB33BffBBffBʙBəBșBffB33BB33B  BșB33BffB  BBBffB  BBʙB  BffBffB͙B33B33BffBB  B  B  B33B33B  BB˙BəBęB33B33B  BB  BffB33B33B  B  B  BB  BęB33BBęB33B33BBBBBBB  BBB  BBffB  BffBBffB  BffBffBB33BřBęBBffB33B  B33B33BffBBBB  BB33B  B  B33BBB  BBffB  B33BB33BffBʙ    BffB33BffBB33B̙B˙B  B  B͙B  B33B33BB33B˙BBffB  BffBB33BǙB  B  BBffBBffB  B33B33BBBB33BBBffBB33BffB33BffBffBB  B  B  B33BB  B33BBffB33BBB33BBB33BffB33BffBBB33B  BBffBffBBffB  B  BffBffB  BffB33BBffB  B  BffB33BffB33BBBșB33BǙBBęBffBB33BBBBffBffB33BB  BBffBBBffBBBBBBBBffBffB33B  B33B  B  B  B  B33BB  BBB33BffBBBB33BB  B33BB  BBffBffBBBB  BBffB  B  B  BffB33B  BffBffBffB  B˙B  B  B  B  B  B̙B̙B  BЙB33BBffBB33BffBϙBffB  BBʙB  B33B33BBB33B33B  B̙B33BəBB̙B  BəB  BBffB  BBřB33BffB33BřB33B  B  B33B  BffBffBBBB33BBffBBB  B  BB33BBffBBB33BBB  BB  BffBB33BB33BB  BffBB33B33BBBffBBBB33B33B  BBB  B33B33B  BffBffBƙBB33BǙB  BffB  B  BʙBB  BBffB  B  B  B33BBffB33B  BB33BB33B  BBB33B  BB  B  BffBřB33BǙBB  BBBffBffBBÙB33B33B  B33BffBffBB33BffBffBB  BÙB33BBffB  B33BffBffBƙBffBBffBBBBffBřB  BBffBǙB33B  B33BBBffB  BBffB33B33B33BBBB  BƙBffBffBffB33BBBÙBB  B  BffB33BffBffB  B  BB  B  B˙BəB˙BBffBB  B33BBffB  B33BffBB33B33BBB  BffBBB33B  BB33B  B33BffB33BffB33B33B  BBB  BBffB33BffB  BffB33BffBBBB33B33BB33BffB33B  BBB  BBffB  BffBB  BB  B33BΙBffB  BΙB33BffB33BffBB33B  B  BffB  B33B33BBϙB  BB͙B  B33BBB  BffB33B33BəBBB33BəB  BB  BBșB33BəB33BșB33BǙBffBffBBBęB33B33B  B33BffBBBB  BB  BB33B  BBBffB33BęBffBBBffBBffBffB33BǙB  B33B33B33BB  B  B̙BffBffB33BBљB  B  BffBBԙB33BBϙB33B33BBϙB33BffBBBB͙B  BffBffBΙBB͙B  B͙B  BB͙BҙBffBffBљB͙B͙BffB33BffBΙBffBϙB  BBffBBffBBffBffBffB  BBBBB  BffB  B  B33B33BșBəBffB˙BÙBBřBB  BBB͙BB͙BЙBϙB33BǙBB  B33B  BΙBffBϙB33BffBΙBffBffB  B33BBљB33BЙBҙB  B  BљB33BffB33BҙBffBB  BBҙBB  B33B  BB33BΙB  B  B  BƙB  B33B33BBәB33BB˙B33BffB  B  B͙BB͙BBffB33BffB  B33BBB33BəBB33BB˙BBBffBBffBffB33B33B̙B33BffBBB33BffB33B  BffB  BBЙB  BBәBffB  BәBffBffBיBffB  B  BBݙBٙBՙB33BBffBBffBffBיBffBffB33BB  B33B  B  BffB֙B33BffB33BB  B  BffB  B33BԙBffB  BB33B33        BffB33B  BffBșB  B33BϙBәBB33BB33B33B  B33BffBBəBffBffB  BffBffB  BЙBB  BBffBffB33BB  BBB  B33B  BՙBffBBB  B33B33BffBffBBB♚B33BB33B  B33B  B♚BffBᙚBB33BݙBBB  BڙBB  BՙB  B  B  BB  BffB  BffBB33BB33BffBBЙB33B33B33BBB  B̙BљB  BffBffBҙBffBՙBffB33BЙB33B  B33B33BBffBΙB  B33B33BffB  B  B33BϙB͙B  B̙BffB̙BΙB33B33BffB  BB33BЙB֙BB33BffBB33B  B  B33BffBffBBffB33BϙBffB  B33B33B  B  B33B  B  B  BљB  BΙB33BffB33BB͙B33B  BffB˙BBBffBffBљBBffB  B̙B̙B  B  BBB33B  BBB33BҙB  BϙBЙB33BBՙB33BffBBBBffB  BBB  B33BffBҙBBәBBB33BՙB  B֙B33BՙB    AC33ADADADADADADAC33AC33AC33AC33AC33AC33AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA@  A@  A@  AAAAA@  AAA@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A>ffA@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  AAAAA@  A@  AAADAC33AAAC33AAAC33AAAAAAAAAC33AC33AC33AAAC33AC33AC33AC33AC33AAAAAAA@  AAAAAAA@  A@  A@  A@  A@  A@  A@  A@  A>ffA@  A@  A@  A@  A>ffA@  A@  A@  A@  A@  A@  A@  A>ffA>ffA>ffA@  A>ffA@  A>ffA>ffA@  A>ffA>ffA@  A>ffA>ffA>ffA>ffA@  A@  A>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA@  A@  A>ffA>ffA@  A@  A@  A@  A>ffAAAC33AC33AFffAH  AIAH  AIAK33AK33AK33AK33AIAIAIAH  ALALALAK33AK33AIAIAH  AFffAFffAFffAFffADADADAFffADADADAC33AC33ADAC33ADADAFffADAC33ADAFffADADADADADADADAFffADADAC33AC33AC33AFffAC33AC33ADAC33AC33ADADAC33AAAC33AC33AC33AC33AC33AC33AC33AAAC33AC33AAAC33AC33ADAAADAAAC33ADADADADADAC33AFffADADAFffADAH  AIALALANffAP  ALAK33AH  AH  AFffAFffADAIAH  AFffADADADADADAFffADADADADAC33ADADADADADADAC33ADADAC33ADADADAC33AC33AC33AC33AC33AC33AC33AAAAAC33AC33AC33AAAC33AC33AC33AC33AC33AC33AC33AC33AC33AAADADAC33AC33AC33ADAFffAK33AIAFffAH  AIAIAIALANffAIAK33AK33ALAIAK33ALAIAIAH  AH  AFffAFffAH  AFffAFffAH  AFffAFffADADADADADADADADADADADADAFffAC33ADADAC33AC33ADADADADADADADAC33AC33AFffAC33ADAAAC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33ADADADAIANffAP  ALANffANffAK33ALAK33ANffAK33AH  AH  AIAIAIAIAH  AFffAFffADAFffAFffAFffADAFffADAFffADADADAFffADAFffADADADADADADADADADADADADADADAC33AC33ADADAC33AC33ADADAC33ADADADAC33AC33ADADAC33AC33AC33ADADAC33ADAC33AC33AC33AC33AC33ADAC33AC33AC33AC33AC33ADADAFffADAFffAFffADADAFffADADAK33AP  AP  ANffAIALALAK33ALALAK33AIAK33ALAIAIAK33AIAIAIAH  AH  AH  AFffAFffAFffAFffADAFffADADADADADADADADADADADAFffADADADADADADADADADADADADADAFffADADAFffAC33ADAC33ADADAC33ADADADADAC33ADAC33ADADAC33AC33AC33AC33AC33AC33AC33AAAC33AC33AC33AC33ADAFffAH  AH  AH  ALANffANffAP  AP  AP  AQAP  AP  AQAQAK33AIAK33ALALAK33AIANffAK33AH  AIAH  AH  AH  AH  AH  AFffAH  AFffAH  AFffAFffAFffAFffADAFffAFffADAFffAFffADADAFffADADADADAFffADADAFffAFffADAFffADAFffADADADADADADAC33ADADADADADADADAC33ADAC33ADAFffADADADADADAC33ADADADADAC33ADADAFffADAFffAH  AFffAH  AIAK33ANffAK33ALAIALAIAK33ALALAK33AK33AIAH  AIAH  AH  AFffAFffAFffAFffAFffAFffADADADADADAFffAFffADADADAC33AC33ADADAC33ADADADADADAC33ADAFffADAC33ADADADADAC33ADADAC33ADADADADADADAC33AC33ADAC33AC33ADADAAAC33AC33AC33AC33AAAC33AC33AAADADAFffAFffADADAFffADAFffAFffAFffAFffAK33AH  AIAK33AIAIAK33AH  ALAK33AIALANffALAK33AIALAIAH  AFffAFffADAFffADADADADADADADADADADADAFffADADAC33ADADADADADAFffADADADADADADADADADADADADAC33AC33AC33ADAC33ADADAC33AC33AC33ADAAADAC33AC33AC33ADAC33AC33ADADAC33ADAC33ADAFffAFffAH  AFffAFffAH  ALAIAIAH  AIAIAH  AH  AH  AH  AFffAH  AIAIAIAH  AK33AH  AFffAFffAFffAFffAFffAFffAFffADADADAC33AC33AC33AC33AC33AC33AC33ADAC33AC33AC33AC33AC33AC33ADAC33ADAC33AC33AC33ADADAC33AC33AC33AC33AC33AC33ADADAC33AC33ADADAC33ADAC33AC33AC33AC33AC33AC33AAADAC33AC33AC33AC33AC33AC33ADAC33ADAH  AFffADAFffAFffADADAFffAIAFffAIAK33AFffAFffADAFffAH  AFffAH  AFffAFffAFffAFffAFffAFffAC33ADAC33ADADAC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AC33AAAC33AAAC33AAAAAC33AC33AC33AC33AC33AC33AC33AAAC33AC33AAAAAAAC33AAAAAAAC33AAAAAAAAAC33AC33AAAC33AC33AAAAAAAAAAAAAAAAAAAC33AAAC33AAAAAC33AAAC33AAAC33AC33AAAC33AAAC33AAAAA@  A@  AAAAAC33AAAAAAAAAAA@  AAAAAAAAAAAC33AAA@  AAAAAAAAAAA@  AC33A@  AAAAAAAAAAA@  AC33AAA@  AC33A>ffAAA@  AAAAA@  AAAAAAA@  AAAAA@  A@  A@  A@  AAA@  A@  AAA@  A@  A@  AAA@  A>ffA@  A@  AAA@  AAA@  A@  AAAAAC33AAAC33AC33ADAC33AC33AC33AC33AC33AC33AC33ADADAIAFffADADADADAC33AAAC33AC33AC33AC33AAAC33AAAAAAAAAAA@  A@  AAAAAAA@  AAAAAAA@  A@  A@  A@  A@  A@  AAA@  AAAAA@  A@  A@  A>ffA@  AAA@  AAA@  AAAAA@  AAA@  A@  A@  A@  AAA@  AAA@  A@  AAA@  AAAAA>ffA>ffA>ffA@  A@  A@  A@  A@  A@  A>ffA@  A>ffA@  A@  AAAAA@  A@  A@  AAAAAC33A@  AAAC33AC33AC33ADADADADADAC33ADADAFffADAC33ADAC33AAAC33AAA@  AAAAAAAAAAAAA@  A@  AAA>ffAAA@  A@  AAA@  A>ffA@  A>ffA@  A>ffA@  A@  A@  A@  A@  A@  A@  A@  A@  A>ffA@  A@  AAA@  A@  A@  A@  A@  A@  A>ffA>ffA@  A@  A@  A@  A>ffA@  A>ffA@  A@  A>ffA@  A@  A@  A@  A>ffA>ffA>ffA@  A@  A@  A>ffA@  A>ffA>ffA>ffA,  A>ffA<A@  A@  A>ffA@  A@  A@  A>ffA@  A>ffA<A@  A>ffA@  AAA@  A@  A@  A@  AAA@  A>ffA@  A>ffA@  A@  A>ffA>ffA>ffA<A<A>ffA>ffA>ffA@  A>ffA>ffA>ffA>ffA>ffA@  A>ffA>ffA>ffA<A>ffA>ffA>ffA>ffA<A@  A>ffA>ffA>ffA<A>ffA>ffA>ffA<A>ffA<A<A>ffA<A<A<A<A>ffA<A>ffA>ffA<A>ffA>ffA>ffA>ffA>ffA>ffA>ffA<A>ffA@  A>ffA>ffA>ffA@  A>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA@  A@  AAAC33AC33AFffAH  AFffAH  AAAAA@  A@  A>ffA@  A@  A>ffA@  A@  A@  A>ffA>ffA>ffAAA>ffA>ffA<A>ffA>ffA<A>ffA>ffA>ffA>ffA>ffA<A>ffA>ffA<A<A>ffA<A<A>ffA<A>ffA@  A@  A@  AAA@  A@  A@  AAAAAAA@  A@  A@  AAAAA@  A@  A@  A@  A@  A>ffA@  A@  A@  A@  A@  A@  A>ffA>ffA>ffA>ffA<A>ffA>ffA<A<A<A>ffA>ffA>ffA>ffA<A<A<A<A<A<A<A<A<A<A<A<A<A<A<A<A>ffA;33A<A<A<A<A<A;33A<A<A<A<A<A<A;33A<A<A;33A<A<A<A<A<A;33A<A<A<A>ffA>ffA<A<A<A<A<A>ffA>ffA<A@  A@  A@  AC33AH  AC33ADAFffADAFffAH  ADAFffADADADAC33AC33AAAAAAAAA@  A@  A>ffA>ffA>ffA>ffA>ffA>ffA>ffA@  A@  A>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA<A>ffA<A>ffA>ffA>ffA@  A>ffA<A>ffA<A>ffA>ffA>ffA<A<A>ffA>ffA<A<A;33A<A>ffA<A<A>ffA<A<A>ffA<A>ffA<A<A<A<A<A>ffA;33A>ffA<A;33A<A>ffA;33A<A<A<A;33A<A>ffA<A>ffA>ffA>ffA>ffA@  A@  A@  A@  A>ffA>ffA>ffA<A>ffA@  A>ffAAA@  A@  AAAAA@  A@  A@  A@  A@  AAA@  A@  A<A>ffA>ffA>ffA>ffA>ffA<A<A<A<A;33A<A<A<A<A;33A<A<A<A<A<A<A;33A;33A<A;33A<A;33A;33A;33A<A<A<A;33A<A;33A;33A<A;33A;33A<A;33A;33A;33AAADAC33ADADAFffAC33AC33AAAAAC33AC33AC33AC33AAAAADAC33ADAC33A@  AAAAAAA@  AAAC33AAA@  AAA@  A>ffA>ffA>ffA>ffA>ffA@  A@  A>ffA>ffA>ffA>ffA>ffA<A<A@  A>ffA<A<A@  A<A>ffA>ffA>ffA>ffA>ffA>ffA<A>ffA>ffA<A@  A<A<A>ffA<A<A<A<A<A<A>ffA<A<A<A>ffA<A<A<A<A<A<A<A<A<A<A<A<A<A<A<A<A>ffA<A<A>ffA@  A@  AAAC33AAA@  ADAAAAADAFffADAFffAFffADAC33AC33AFffADAC33AC33AAAC33AC33AAADA@  A@  AAAAA@  A@  A@  A>ffA>ffA>ffA<A>ffA>ffA>ffA>ffA>ffA>ffA>ffA@  A>ffA@  A>ffA>ffA<A>ffA>ffA>ffA>ffA<A>ffA>ffA>ffA>ffA>ffA>ffA>ffA<A<A<A>ffA>ffA>ffA<A<A<A<A>ffA<A<A<A<A<A>ffA@  A<A<A<A<A>ffA<A>ffA<A<A<A<A>ffA<AFffADADAFffAFffADADADADAC33AC33ADAFffADAAA@  A@  A@  AAA@  A@  A@  A@  A>ffA>ffA>ffA>ffA@  A>ffA>ffA>ffA@  A>ffA@  A>ffA<A@  A>ffA>ffA>ffA>ffA>ffA>ffA<A@  A>ffA>ffA>ffA>ffA>ffA>ffA<A<A>ffA<A<A<A<A>ffA<A<A<A<A<A>ffA<A>ffA<A<A>ffA<A<A<A<A>ffA>ffA>ffA@  A>ffA@  A>ffA>ffA>ffA>ffA@  A>ffA@  A>ffA<A>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA<A>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA@  A<A>ffA<A<A>ffA<A<A<A>ffA>ffA>ffA<A<A<A<A<A>ffA>ffA<A<A<A<A<A<A>ffA>ffA>ffA@  AAAC33ADAC33AFffAFffAFffAH  AH  AFffADAC33AAAAAFffAC33ADAC33AC33AAAAA@  AAA@  A>ffA@  A@  A@  A@  AAAAA@  A@  A@  A@  A>ffA>ffA>ffA@  A@  A@  A>ffA>ffA>ffA>ffA@  A>ffA>ffA>ffA>ffA@  A>ffA>ffA>ffA@  A@  A@  A>ffA>ffA>ffA>ffA>ffA>ffA@  A>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA>ffA<A>ffA>ffA>ffA>ffA>ffA@  A>ffA>ffA>ffA<AAAC33AC33AFffAFffAH  AFffAFffAFffADADAFffADAC33AAAAAAAAAAA@  A@  AAA@  AAA@  A@  A@  AAA@  A@  A@  AAA@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A@  A>ffA>ffA@  A@  A@  A>ffA>ffA>ffA@  A@  A@  A@  A>ffA@  A>ffA<A@  A@  A@  A>ffA@  AAAAADADAFffAFffAFffAFffAH  AH  AH  AH  AH  AIAIAIAH  AIAH  AH  AIAIAH  AFffADAC33AC33AAA@  A@  AAAC33A@  AAAAA@  AC33AAA@  A@  AAA@  AAAAAAAAAAA>ffAAAAA@  A@  A@  A@  A@  A@  AAA@  A@  A@  A>ffA@  A@  A@  A@  A@  A@  A@  A@  A@  A@  AAAAA@  A@  AAA@  A@  AAA@  A@  A>ffAAAAAC33ADADAFffAK33AIAH  AH  AIAFffAFffAH  AH  AH  AH  ADADADAIAIAH  AFffADAC33AC33AAAAAAAAAAAAAAAAAAAAAAAAAAAAAAA@  A@  AAAAA@  AC33AAAAA@  A@  AAAAA@  AAAAA>ffAAAAAAA@  A@  A@  AAAAA@  A@  A@  A@  AAAAA@  AAA@  A@  A@  AAAAA@  A@  A@  AAA>ffA@  A@  AAAAAC33AAADAC33ADAAAC33AH  AFffADAFffAC33ADAC33AC33AC33AC33ADADAC33AC33AC33AC33ADAAAC33AAAAAAAAAAAAA@  AAA@  AAA@  AAAAAAAAA@  A@  AAA@  AAAAA@  AAAAA@  A@  A@  AAA@  A@  A@  AAADAC33AC33ADAC33AAADAC33AC33AAAC33AC33AAAAA@  AAAAAAAAA@  AAA@  A@  AAA@  A@  A@  A>ffA>ffA@  A@  AAA>ffA@  A@  A@  A>ffA@  A@  A@  A@  A@  A@  A>ffA@  A@  A>ffA>ffA@  A>ffA>ffA@  A>ffA@  A>ffA@  A>ffA@  A@  A>ffA>ffA@  A>ffA>ffA@  A@  A>ffA>ffA>ffA@  A>ffA>ffA>ffA>ffA>ffA@  AAAAA@  A@  A>ffA@  AABB33B33B33B  B33B33B  BffBBB  B  B33B  BBffBffBffB33BffBffB33B̙BffB  B  B33B  BffBBB̙B  BǙB  B33BffBffBB  B33B  BB33B33B33B33B  B  B  BffB  BB  BBBBǙBBÙBB33B33BB33BșBffB  BffB33B  BBffBB33BB  BffB33B  BB  B33BřBffB33BǙB  B33BƙB  BffB33BffBffB33B  B  BB  B33B  BB  BBƙBffBffBffB33B  BBřB  B33BffBBffB  B33BffBBffBB33BffBffBffB  B33BffBBffBffBB  BffB33BffBBB33B33B  B  B33BBBBB  BBB  BffB33B  BBffBB  BffB  BffB  B33B  B33BBffBffBÙBęBřBřBffBřB33BBB  BffBęB33BB  BffB33B33B33BęBƙBffBBBÙBffB  BÙBffB  BBB  B  BBBÙB33BffBffB  B  BBffB33B33BBBffB33BffB  BffB33B  B33B33BB  BffBB  B33BffBB  B  B  BffBBffBB  BB  B  BBB  B  B  BB  B  B  BBBÙBÙBÙBffBB  BBBBęBřBffBffBřB33B33B33BffBB33BǙB  BB  BƙBB33BBBffB  BBffB  BB33B33B  BB  BffB  B33BÙBBffB33B  BBBBffB33BffBffB  B33BffB  B33B  BęBffBffBffB  B  BffBBB  BBBffBBB  BffB  B  B33BB33BBB33BʙB33B33B33BffBffBBBB  BBffBBBffBBffB33BBB  B  BffB  BÙB33B  B  BBBǙB33B  B  BBBBB  BB33BBBBBB  BBÙB  BBBB  BBB  B33BBB  BBB  BB  B  B  BBB  BBBffB33B33B  B  BB  BB33BBęB  B  B33BffBB33B33BBBBBffBffBBB33B  B33BÙBřBffBB33BęBffBÙB33BffBB  B33BffB  BÙBffBÙB  B  BffBffBBB  BffBřBřBřBffBB  B33BB  BB  BB  B33BBBBffB33B  BffB  B33BB  BBB  B33BffB33B33BBB  B33BB  BBB  BBBffBB33B33BB  BffB33BƙBffBǙBǙBǙB  B33B33B  B  B  BffBǙBǙBǙB33BffBffB33B  BřB33BffBÙB33B  B33B  B33BffBffBBBffBffBffBffB33B  B  B33B33BffB  B  BBB  BffBffBBBBBffBBffBffBBffB33BBffB  BffB  B  B33BffBBffB33BffBƙBB  BBǙBffBffB  BB33BffBʙB˙B33B  BffB33BəBǙBB  BffBffBřBB  BffB33B33BB33BB  BBffB  B  BffB  BffBBffBffB33BB  BffBBBBBBBffBBęB  BffBBB33BBffBB  BəB33B  BB  BffBffB͙B33BffBB33BșBffB  BBB  B33BBffBBʙB  B  B  BffBəBB33BB̙BBffB33B33BBB  BBB33B  BffBffBffB33BB33B  B33B33BffBBșB33BǙB33B  B33B  BB33BB33BffBřBBffBffBBffBffBBffB  B  B33BǙBB  B33B33BB  BșBffB33BffBffB33B  B33B33B33B33B33B  BљBBffB33BB  BљBϙBЙBB33B33BBffBϙBϙBffBΙB  B͙BffBffB  BBB  BffB33BřBęB33BřBB  BǙBBǙBBB  BffB  B33B33B33B  B33BB33BBB  B33B  BęBB33BB  BB33BffBBƙB  BffB  BffBșBBffBffBffBBBBffBffBB33B  BB33BBΙBB̙B͙BϙB33BffBffBϙB33B  BB̙BʙB33BəBBffB33BffBB33B  BșBϙB33B  B33BB33B33BffB  B  B  B  B  B  BffB  BffB  BffBBffBBffB33B33BffBBffBBffBB33BBffBęBBBęB33BBffB  BB33BB33B  B  BffBBBB  B33BÙB33B33BBəBBffB33BʙBB33BB33B33B  B33BșBB  BB33BBBffBffB33B  B33B  B  BffB  B33BffB  BB  BBffBÙBB33B  BffB33BBBBffBBB  BBBffBB  BB33BB33B  BBBB33B  B  BB33BBBÙBBffBffB33B33B33BBffB33BB  BBffBÙB33BffB  B  BǙBșBffB  B  BffBffB33B  B  BffB  BffB  BBB33BffBffBBffB33BffBffB  BÙBB  BB  BffB33BBffBřB33BffB  B33BBBBB33BBBffBB  BB33BBffB  B33B33B33BffBB  BffBB  B  BBB  B  B33BBBBB  B  B33B  BBffBffBffB  BB  BffB  BffB  BffB33B33B  BƙBB33BǙBBffB  B33BffB  BffBBB  BffBB33B  BBB33BəB33BBffB  BəBəBB33BǙBffB  B33B33B  B  B33BffBffBffB33B33B  B33B33B33B33BBffB  BBəBBB33BBB33B  BffBffB33BffBBB  BÙB33BB33BBǙBřB  B  B33BəBBʙBBB  B33B33B  B33BB˙B33B̙B̙BBffB̙B  BB33B33BffBffB33B33BBffB33B͙BffBffBΙB33B  BϙB33BљBffBffB  BffBB  BffB33B33BffBЙB  BffB  BBBB  B33B33BffBBB33BffBBBB33BB  BffB33BƙBB  BffBB33B33BffBBffB33B  B  B˙BBB͙B  B͙B33B̙BBffBffB  BffB33BffB  B33B͙BΙBB33B33BffB  B33B33BBәBәBffBffB  BffB  B  BBBB  BBҙB33B33B  BәBffBәBffB  B33BBҙB33B33BBBffBЙBffB  BBBB33B33B33BB33BΙB  BBffB33BffB  BB̙B  B33BffBB33BffB͙B  B̙B̙B  B33BffB33B33B  B33B33B33B  BљBffB  BBffBB  BәBϙBffBBy y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AAAffA£AzA¸RAzA(A{A{AGA{A\)AQA£AAAAA  A(A(A\A
AQAA33AAzA£AAHA=qAffA(A(A
AAARA\A{AQAAQAffA\ApAzA£AAGAAAAAAARA\AApAGAQAAA
ApA33AAA
=A  AAQApAAAGApAffA=qA33AAA=qAA
=ApA  AffAzAA{AGAA(A
AGAAQAA\)ApAAApA33A=qAGA\ApAA=qA  A
AAAzAHAAA(AAGAAAAA{AQAA
A=qAAGAHA\AAAGA\)A  AAHA{AffAQAAA\A
A
AGA(A\)A33AAAARAAA
A
A{AAQAAAAA
ApA
AAAA{AQA\)AHAAARAA\)AGARAARApA\)AA=qA\ApAHA
=AAA=qA\)AAAAAA\AAA
AA  A
AAAGA  AARAQA\AAAffARAQAAAA(A\)A
=A  AA(ARAAA\)A(A  A  A  A(A
AAzAA\)AAAApAAA\ARAAA=qAAAGA(A
=AQAAffAA
A=qAARAAARARAHA
=AHAA  AA=qAQA=qA(A\)A\AAARAA
=AHARAA=qA(A33A  ApAHAGAA  ARAAAzA  A33A
=AAffA
=AHA  A(AA  A  AA=qAffA(A(AA=qAA(AA  A33A
=AAGA=qA=qA\AA\)AA{AAAAA{AA\A(AAzAARARAGAHA\)ARA  AQA33A=qAA{AzAAzA
=A\)AAHAA\A\)A\)ApA=qA{AQA  ApAA{A=qA33A
AARAGA(AA\)A\)AAA\AApApA33ApApA33AGA  A\)A
A=qA{AQAAAA{AAAQAGA\AA{AAA{AAApAQA{AAAGAAAAAffA{AARAAAA=qAffA  ApAAAA\)A  AffAHAAAzA
A=qARA
=A33A
=AHAffA{A
AA33A(A
=ApAAffAzAA33AAAApAAA\)ApAAA¸RA
AzA
AAA{A33AA  A
AAAAARAffAAzA\A\)AHAAAARAQA\)AA\AA(A{AA  AA\A\)AA  AA=qAA
=AA{A(AHAA{AAA=qA\ARAAAA
AzARAAAAA=qA{A
AA{A33A(A33A\)AzAGAzA
A  AAHAHA\)AA{A\)AffAA
AHApAAA33A\)A=qA
=A
=AAAAffA33ApAA(A
A\A33A  ApA(AApA
=AA33A\)AHAHAAAA(A\A33AzAAAA(A\)AA(AzA\AAA
A\AAzAAAA{AA(AQA
A
AAAApAApAGA
=ARAA
A\AAHARA33A(AA
AHARA\A(AAffA  AAzAAAAAA\A  A\AAA\AffAAAARAQA{A
A
=AAQAA
=A\)A
=AAAAAQA=qAAAQAA\A{A\AffAA{A=qAA
=AffApA=qARARAA\ApARAAffA\AAffA\)ApAQApA33A
=AzAGA
=AQAAARAAAQAAQAA\AffAGA
=AAAA{ApA{A£AA£AAA{AAAA{AAffA33AA
AARAQAA=qAAAQAAA{AffAzA(ARAAAAHA=qA=qAAAGAAAA=qA(AGA33A\)AAARA
=AAARAzAA{AAAAA=qAA\)AQAHAzAffARAARAARAA  A{AAA  A{AA=qAA{AA{AAAA=qA=qAA\)ARAA=qA
A{AAA33AAQAA=qAGA{A(AGAHAAAA  AHAAAARA(AAAAQAQA(AHAGAA=qA
=AzApA{AHAARAA\AA\)A
=ApAApAffAAARA
A33AHAHA
=A(AffAA33AAA(A33AA{A\AAHAAzAQA=qAAA
=A{A
=AAHARA  AAAA33A
=AAHAAHAîAQAAAAA\AAffA
=A\)A33A
=ARAQA\)AAA\A  AAAffA=qAAzAQAzA\AAA33AAQAAAA  A
AA
A
=AA
A\)AA  AzA
=ApAAHAA
A=qAA=qA(AzA
=A\)AA=qAzAAGAAď\AA\)A
AAffA  A{AA
AHA  A  A33AAQAA=qA33AzA(A¸RAAAAAģAď\AĸRAffAQA  AA  AAÅA
AA
=AHAAĸRA33A=qA¸RA\A£A¸RAA{A{A(AAAAffA  AAzA  A=qAA
=AAzA  AAzAAHAGAAQA=qAzAA{A
AAAAAHAzAAAA¸RAA\)A
A  AffAģA
=AŅA
A  AƏ\AƣAzAffAƏ\AƣA
=AǅAǅAGA(AǅAAQA
A=qAQA  A  AAQA(A  A  AA
=A
=A{A=qAģA33ApApA¸RA
AÅA¸RAA
=A=qAîAîAÅAA
=AA33AA
A\)AA33AAAAQA  AQA33A\ARA33AA\)AAGAAA=qA=qAzAA
=A  AQAAA=qA
=AA\)A
=AQAHAA
=AA
=AA(AAAAAzAĸRAHA
=AA
A\)A{AffAȣA{A=qA\)AHAA{AQAAǙAǙAǮAǮA{AzA=qA
AGAA
=AAAA  A\)A{AÙA
ApAQAQApAA=qAAAÙA
=AÙAffAAĸRA{A(AAQAQAGA\AA
A33A\A{AApA=qAzAAAď\AAQAA33A(AHAA(AAAzA33AAHAA
=A{A=qA
A{A(AHA=qA(A=qA=qARAHAA(A¸RApApAAAAA33A33AA{A{AQAĸRA¸RA¸RA{AAAQAGAAAAA
AGA=qAffAzA=qAAffA(AAA
A(AHAA
A(A{A=qA(A\AA
A  A=qA(A¸RAAzAAHA\AffAQA(AffApAQA{A
AGAA\A
A  AApA
=AAARAA=qAffAzAAAA=qA\AAA{AAAffAAAA33AQAGAffAĸRAA
=A\)A=qA33A{AQAA\)A
=AGAĸRAHAQA\A\A33A
A(AAAzAQA  A\)AA\)AffAHA33A
=AA  A
AA\)AÅA=qAQAffAzAAffAHARAGAA
A{A(A
A\)ARAAA(AA  AffAA33AAAARAQAGAA(AzAffAzA33AAQA=qAApAA\)AAzAQA=qAAÙA
=A¸RA¸RAAĸRAÙAÅA
A¸RAAģA
A  AA\)ApApAAHAQApAAffA33A33AGAAA=qAAA
A\)AA(A{A\AAGAARA\ARA\A\)A{AAAffA(AAA\)AAGA\ARA
A\AA£A{AAQA
AAA(A33AAA\)AzAA\A  A=qAAAQAQAzAQAzA¸RAA£AAQAHAQA(AQAffA33A¸RAffA(A
=Aď\AŅAA{A{AzAƏ\AƣAƣAƸRAAƸRAffA(AHAAA{AA  AGA(A  AA
AQAîA
=AģAzAffAA
=A33AA\)A  A(AffA\A\)A\A
AAzAffAAAGAQAGAAAď\A=qAffAA
AA
AQA
A  A  AffA  AÅAÙAA=qAGAAƣAApAǮA=qA  A(A{A\)AGAǮAƸRAƏ\AA
ApAƸRA
=A{A=qAQAAApAŮAAzAÙA(AA
A=qA\)A\)AQA=qAQA{A£A\AzAAA
=A  A
=A
=A\A=qAffA{AA\AffA=qAQA£A£ApAAîAAAAîAÙA=qA  A{AîAAAffAQA{AA33A  A
=AA
AA(AQAGA=qAAApAGAAAAA
AAAQAAAGAAAAffARAA
=AAA  AQA{A{AA
=A
=A33AAQA=qA33A=qA(AAQA  A33ApAA\AAGA33AAAzA  AARAA\)ApApAA(A\A£A¸RA{AA
AAAAA\A
=AGAffAffAAAA{AA=qAAAzAAAffAA(AA\AA\)AAA33AzAAApA
=A
=AAAA=qA\A{AA33A  A\)A33AQAGAARA\)A
=ApA(AA  A\AAA\AQA
AQAQA
A\)AGAA
=A\ApA{ApA\)AAGAAAAA\)A
=AAAA
ARAAA=qA=qA(AA(A
=AA  A
=AA\AffApA33AAAzA=qAAGAHA(AA\)AAAA
AHA  AGAAAA\AAzA{AAA\)AffA
A  AHAA(A
A  AAAAQAAffA\AGA=qA
=AGAAHA
=AHA\AQA\AA33AQAAAzAARA=qA\)AAA
A=qA\)AAAA
=A=qAAHA\ApA  AApA\)A
=AGAGAAA  A
ApAA  A  A{A=qAAAGAGA33AGAHAAAQAQAHAzAzARAzA
=A
A\)AGAApAAAAzA(ARAA\ARAA(A{AAA\)AApAQAA\ARA  AAQAGA{A=qA\)A
AQA
AGAAAHAAA
A\)ARAHA\)AA  ApAAAAA=qAA=qAARApAAffA(A  AAzAAA
AA  AA
=A{AffAQAA  AA\)ApA33A
=AA{AA\AQARApAA{AHAA(AAA(A\A\)A=qA{AA=qAffAHApA33A{A33AARA  AAA
=AAAA
A\AAAARAGAGA  A{A\)AAGAAAA(AA33AAAApA\)A\)ApAA
=A\A\)AA
AAAHAAzAffAAAAQAGApAAQAzApAzAHA
=AGA
=A=qAzAAAzAA\A\)AA33AHAA(AA
=A
=AA
A(AAApAGA33A
=AA(AQAQAA  AGAAARAAffA(AffARAA\)AQAQAffAQA(AQA\)AGA  AGAA
=AzAffA
AQA\AAA33ApAApAARAAA33ARAHAAAA{A33AApAQA=qARA33AffA
AAAApAAAzA  AGA  A  A{AGAAAARAARAAAA\AA
=AA{AAAQA=qAA  AQAAAAAAAzAGA\)A  A
AAApA\)AA  A
AA(AQAApAA  AAA  AzA\A(AA
=A
A\AQA(AAA{AAAffAARAQA(A{AA{A
=AGA\ApA(AAAA(AARA
AffAffA\)A
A  AzAQA  AAA(A{AA
AHAzAA33ApAAAA{A
=A33A33AHA\)AA=qAA\AA\)AAA33A  AHApA33AAA
=AA\)A33AAAGAA33AA
=AA
=AQA(AA  AAAHA
AAAAAA
A(AAGA33A=qAQA
=A\A(ApA=qApApAHA
=AA(AffAffAzAffApAGA  A\ApA=qARA{AAA
AAAGA(AHAApA\A(AA33AAGAA=qA
AA  AAAffA  AA{A
AAAAQAA\ApAA\AARA\A
=AffA{A\)AzAzAAHAAHAAffAAAzAA33AAHAffAA
AGAARA\AffAAA  A{AARA  AQARARA  A=qAHAA{AAAAzAAA(AzA{A\A
AA=qAzAA\)AQAAApA
ARAAffAA{AHAHAQAzAQAAffA{AAAffARA  AAARAAAAzAHA\A\AffApA\)A(A\ARAffAA\AA
=AffAffAQA
=AAQAA(A(AA
=AAApA33AAA
=ARA\)AQAAffA\A
AAAzA\)AGA(AA{AGAA  A\AAA=qAHAAGAHAHAAAAA(AAAAARAzAAzAA  AHA  AA33A\)AA
A\)ARA  A
AAAAAGAHA{A  A=qAAA
=A{A33A{AA\ARAAAAARA\)AA
AffA33AzAAA{A\A{AApAzARA33AA=qAARA
AA
=AAHA\A=qA
A  AA  AGA{AGAApA  ARAA  A(AffAAAAAAA  A  AApAA\)AAAzA=qA{AAAAzARA{A
=AAAAA  A
A\AAAzAA{AARAzA  A(AAARA\AAA\)A\AA
AHA{AQA\A\ApAARA{A33A{AARAA  A\)AAAAzAffAGAGA
=AA(A{A(AAGA33AGAAAA  A{A  AQAAffAHAHAA33ApA{AffAzA=qAAAA33A
AGA{AAQARAQAA
A(A  A(AAGAA  AAA33A
=AzA
=A\)A
=AAA(AzAAAzA=qAffA=qA{A
=A\AHA\A(AffA{A\AffARAzA
AAA\)A{AAA
AAA=qA\AA\AAGA{AAAQAffAA
=AAAQAQA
ApA33AAA\)A
=A
=AHA
=AffAAzA=qA
=ApAHA
A\)AzAQA  ARAGAA
A33AzAGAAAAAHARAAAAGAAzAA=qA=qApAQAA(AAAQAAA{A  AAA(AA
=AGA(A(A=qA\AA  A\)AAA(AAAA33A
=A33AApAA=qARAAAA
A=qA\AA  AHAAAAGA{A\A
A=qAzA
=AAHAģAHAģAGAHA
Aď\AģA{AîA\AffAAA
=AzA
=AAffAA\A\)AHA{A¸RApAA  A\AA
=ApARAApAAHAzAAQApAAAAA=qA{AARA{A
ApA{AffAzAA=qA{AHARAA\AAAAffAA33AAzAQA{AAzA
=A{AHAAA
A\)A=qA33AGAHAĸRAAĸRAQAď\AAQA  ApAA
AA  AA=qAAĸRAAÙAA¸RA\)AAÅA
=A  AÅA\)AA
A
A(A{AA
AAA
AÅAA  A\)AGAAAAHAAA=qA\AffAQA(ARA  AA  AQA(AffAAA¸RApAzAîApA
=AffAAGAHA\A¸RA(AGA{A
=AA  AA{A\A\)AARApA\AAzA
=ApAŮAŅAƸRAffA{AŮAAŅAAA{AzAAHAǅAƏ\AffAŮAzAHAǙA\)ApAAƣAAQAA  A
AŅAAA
=AHAA  AffAA\)AAA\)A\ARA{AQAîAHA
=A
=AA{AAffAGA  AřAA
AAAřAAAffAffA
A=qA33A\)A=qAAHAHA  AA
=A(AGAAAAHAHA  A  ApA{A33Aď\A{A  AŮA  AƸRAAAƸRA33AŅAzAǙAAǮA\)AffA
=AɅA33A
=AHAffAAAQAAAɅA{A\)ApA{AQAʸRAʏ\AffA(AʸRAffAzAffA33AQAAAȸRAAȏ\A
=A  AzA33A
A  AzAƣAzAffApAȏ\A=qA(AǅAAǅA{A  AAȏ\AƣA33AƸRA33AǙAHAAGA
=A=qAAAƣA{A{AzA\)A  AGA\)AǅAǙA
=AAAHA
=AAƸRA(AA
A(AƏ\A{AƏ\A  AřAAGA\)AAŮAŅA\)AŮAŮAŅAřA
AQAAzAƸRAƸRApAAzAď\AffA
=A\)ApAHAÙAîAA£A  AA33A33AAffApAA(AA=qA\AzAAzA
A\A  AGAAÙA\)ApAA£A{AAHARARAHAzAzA\)ApA
A
AAAA
ARApA\)AAGAAGA33AAA33AAAA33AQAAAffAGAHAAA\AAffAQAAA\)A
AQA\A{AGA
=A{AApAAAAA=qAAzA{ARAAffA=qAA
=AAAGA  AA\A
AAAAGA=qAQAAQAHAAGA
=AA=qA  A\AAA33AzA=qA
=AAHAQA\)A\)ARA
=AApA=qAzAAA\AAA
=ARAQAAzA\AAA33AHAAA
=A(AAA\A{AQA  AA\ApAA\)AAAA
=ApA(A33A
=ARAQAAA33AA\AA{AHAffA(AQA\A
=AAA
A
=A
=AAffAAzApAAAAAA
A
=AAAA33A
=A33A=qAAzAA(A33AzA33ARAApAAA  AAzApAQA\AA£A(A£A\)AÅA{A  AffA=qAQAzAŮAŮA\)A\)Aď\A  AģAzAQAA(AAQA  A{AA(AƣAƸRAƣA
=AƏ\AzAzAƣAA
=A\)ApAǙAǙAGAŅAƏ\AƏ\AAzAzAzAA
A(AƏ\AƏ\AƏ\AffAA=qA
A{A\)AzAAA33AA
AAHA
AHAAAAAzAAffAGA\)AQA\A
AzAHA=qA
AA33AGAGApAGA  AffAzA\AA=qA{AGAzA=qA=qAAAAzApA\)A33AAApAȸRAA  A=qA  AAzAĸRApApAƸRAA=qAHAHAzA=qA\)A¸RAQAAGA33AŅAď\AAHAA\AzA{AAAffAffAHA33AGA=qAffA
=A
AAAQAffA33AŅAĸRA=qA\)AAGA
=A33A{AA33AffA\A=qA\)A=qA{AffA
AģAzAAǮAǮA{A33AAAǅApA\)ApAGAəA33AȸRAAǅA(AǮAǅAAǮA  A(A(AǙAA(AǮA
=A
AzAAǮA
A\)AzAffAȸRAȸRAȸRAAȣAA=qAŅA{AAÅA  AAzAA=qA
=AAGA{AQAffAȏ\AȣAApAȸRAAAHAAzAAA
=A33ApAQAŮAŅAĸRAA(AAAAîAřA33A{A33AGA{A
A{AƏ\A=qA33AA=qApA\)ApApAQAʏ\ApAAA=qAA\)AA=qAzA  AffAGAA(A\)AffA33A
A
AffAffA33A
A
AˮAHA  AAGAɮAAffA
=AQAÙA
=AzA
=AAAA{ApAAffAHẠA=qAA
=A\)A
A  A  AQAA=qA£AʸRAHAͅAAͮAˮAzA\)AGAA
=AA=qAGAAǙAǙAǅAffAHA{AQAA33A
AHA͙A
AΏ\AΣAHAA=qAzAGAAẠAA\)A˙AˮA˙AA
AGA˙A  ApAGA̸RA\)AGApA\)ApApAApAA(A
=A33ẠA33A33A33AGAɅA  AA33AAHA33A{Aʏ\AAʣA{A
A=qA  A(A\)A=qA
AQAəA¸RA\)A=qAHAGAHA
AzAAɮAAffAQAÙApApAÙAzAAƸRAǮAǮAȏ\AʸRAˮA=qAAͅA33AHAA=qẠAzAA  AA33Ȁ\AͅA˙AHAȀ\ApAHAˮAffAAAHAȣA33A\)AAAffAzAAQA\)AAffAffAffȀ\A
=A33A\)AffAApA\)AQAQAA=qA\)A˅A
=AHA  AAA\)AʸRAǅA
A{AAQAAHA(AȸRA33AA\)AApA
A\)A  AAAƏ\AƣAƏ\AƏ\AA33AAAQAAAȣA(AGA  A=qAffA  AffA  Aʏ\A  A
AAGA
=AGA˙AA(A˅A\)AQAəA33AǙA
=AffA  AƏ\AQA(A  AAQAA\)A33AffA(A\)AɅA{AʸRAȏ\AA(AɅAGA
A  AʣAQA=qA(AQA
AApAʸRAAʣAQA33AǮAffAA(AʸRAǮAAǙAAAƣA=qAAȸRAzAQA
=AAAApAƸRA
=AQA
AAQA
=AȸRAA\)AAzAȏ\A33AQAHAʸRAA
AA=qA=qA=qA(A\)AʣA33Aʏ\A  AAffA=qA=qA33AAQAAAQAʣA˙ApApA\)A
=AHAHAʣAffA(AA
A{AA=qAHAffAQAA
=AAGA\)A33AGAŮAŮAAQA  AffAA  A  AffAƏ\AffApAAAGAƸRAHA{AQA
A33AƣAQA
=A\)ARAA
=AAǙAAAARARAA
=A
=AHAAAA33AGAARA{A=qAffAffAAA=qA\)A  AHA
A
=AAAAAffA{AffA{AAzA33A(A  AA  A
=AHAHA\)A
AA  AAzApAAGA
A
A\)AffAAA\A=qARAA
=AGA\)AA33A
=AAGAAzAApAA=qAGAAGAAHAAAAA=qAAHAAA
AHA=qAQAAHA33AHAAAA\)AAAAAAQA33AHARARAAQA\)AAAAA(ApA(A\)A33ARA(AA\AAffAAGAHARAARA  A=qA{AAAAAAA
ApAzAzAAAA(A(AA(AAA33AGAffAARA
=AHAA
=A\)A  AQAffARAzAA  AzAffAQAAzA\AHAAA\)A\)AApAApA\A=qA{AAHAffA\)A33A\)AHARAQAffAffA\AzAffAGA\)AQA
=AGApA\)AA(AAAA{A=qAAGA{AA
A(A\A\AAA
AAA\AA  A
ApAA33A\AGAA  AGA
=AAA(A
=A33AA=qAAzAffA  A
A{AzA\)AHAGAAQAGAzAARAApAAA
AAA=qARAGAAAAAAQAGAHA(A(AA(ARAAHA(A{AAA
AA33A=qAAffARApAAGAHApA=qAApA
=A  AzAAAAzAGA33A{AAAzA33AAffAQAAzARA  A
AAAAA
AzApA=qAAQAAAAAA{A\AA  A\ARAAA\AAA
=AHARAA\AAAAA
=AAQA=qAA
A  AGAGA(AA33AGA33A
A33AQApAA\)A\AAARAARA
=AAffAHAAQAAA{AAA
=AApApAzA=qA{AAQA  AAAzA\A  AAAA
=AAGA(A
AA\AffA=qAGAHA\)AA=qA=qAA\AARA(AzA(A{A{AA\A\ApAAAAQA
=AAAAAA
=A{ApAApAGAA(A
AAGAApA(A{AA
=AzAA\)A33AzA\A\)A33A\AAGAAA33AA\ApAQAAA\AQA  A(AAAAGAffA
=AARA\AGA
=A33AAA
AAA=qA33A{A\)AGAAGA\)A=qAARAAîAQA
AzAffAA
A\A=qA
AA
=AQAffAAAQA\A£AA33A33A  AA\)AQA
=AzApA
AAAAîA=qAAAGA
AîAAApAîApAGAÙAÙA
AÅAGApA£AA=qA33A33ARAAAAffAA=qA{A
=AGARA
A
=A\AHApA\)AzAA{A=qA(AHAA  A\)AzA33AA\A{AA{AA
=A
AAQAffA{AAA
=ARAQA\)A(AHA(AAAzA
A{A=qA
=AAffA{AAAGAGA\AARAHAA\)A\)AHA
=AzA{AA\)ApAA
A
=AHA=qAA(A
A(AAHAA
AA\)AHAAGAAQA{AAAzAA
=A
A
A  AAQA
A
AA{AzA\)AAA
=A=qA33AHAHAAffAGA{AA\)ARA33AApA
ApA=qARA\A\A
=AAAQAA
AARAA(AQA  A\)AA=qAA(AA
=AGAGA33AGA
=ARAA\AAHARAzAAAA\)A\)AApAAAHAAGAAAGAGA
=AAffA  AA{A\)AAGA
=AAA{AA=qAA(AAHA33A
AffARA
=AAzAA
=A{A=qA{ARAA
=AAARA\A
=AAAQAA33AA
AA  AA\)A\)AA\)ApAAAAAAAAAA  AQA¸RAAÙA\)AÙA
A  A{A{A{AAîAÅApA
=AHAAAAzAQA(AzAQAffAQA{AA  AA
AAAAAAA  A  AAAA{A
=A
=A=qA\)A\)AAGAA\)ApAAA\)A(AzA=qAAApAAA
ApA=qA=qA
AA(ARAAHAAÅApApA  A33A=qAA
=AĸRAřA
A  A(A
A  A  A(AƏ\AA\)A\)AHAHAƏ\AƣA
=AǅAAƸRAAffAƣA(AAAƣAAA(A
A
ApAîA(A£A¸RAzAffAA£AzA
=A33AGA
=AAÙAA\)AA(A£AA\A(AAAA
A
A\A
=AA{ApAffAA
AîA(AĸRAA\)A33A\)A\)A\)AAAAHAHAA\)A
AAAzA  AƏ\AQA{AǮAǅA
=AƣA(AřA33AAAAAA
=AQAģAzAzAffAAffA=qAģAģAHAAĸRAHAQAffA33A=qA33A33A=qA(A33AĸRAAHA33AAGA
=AzAĸRA
=A
=AAÅAÙAffAffA=qAA
AA
AzA=qA=qAAA\)AAAAAÙAAzAAA
AARAApA
=AÅAAAŅAApAǮA
A
=AAǙAQA
=AHAA
=AA33AǙApA
A(AffAzAȣA(Aȏ\AȸRAȣAzA=qA{A
AAǅAHAƏ\A
AAAA
AŮAQAzAƏ\AŮAAď\AHAAģAQAffAQAzAď\A  ApAffAzA\AîAffApA\A=qAffAAGA\)AřA{A33AŮAA=qA=qAA{AA(AGApA
=AQAQAAGAřA  A  AffA
=AA(A(A  A  AƏ\AƣAQAƣAƏ\AƸRAAAHA
=A33AǮA{AzA{AAǮAAǮAȣAAA(AAAA  A
A  A{AAǮAǙAA
A  A33AGA\)A\)ApA33A\)AGA
=A{A  AGApApAǮApAffAǙAAƣA(AǮAǅAAƣAƏ\AQA(AA=qAA=qAAGA
=AAGAGA\)ApAAQAAQAƸRAŮAAzAzA
AAzAȣAAəA  AẠA=qA
AAAA=qAzAzAQA{AQA̸RA\)A
=AA  A33A
=A(AAGAɅAəA{AɅAGAA{AAɮAɅA33A33A33AHA
=A
=AȸRAAQAAA{A{AǮApAffAȣAffAQAHAǙAǮA
=A
AGA=qAŅA  AQA{AzAAQA
AÙA{AffAAzA\)AŅAA(A  AƸRAAA
=AAA33A\)ApAAȏ\AAHApAȸRAA{AA{A=qAHAApAGAHApAȣA{A  AǅA\)A33AGAAǮAǮA  A=qAAGAAAAAAƸRAƸRAffAApAAĸRAď\A=qAAAƣAǅAƣAŮAHA{AHA33AzAHApAzA
AAA\)AȣAAAHAÙAA33AzA
=AAA{ARA{A
A  A
=AzA\)A£A\A{AQA33ApAGA¸RAA33AAAA=qA(A  A{A
A  AA  A(A(A=qAÅA  AÅA¸RAQA
=AA  A(AAHA(AĸRAîAď\Aď\A{Aď\AzAQA=qAA\)AAffAHAQAA
AAA
=A{A¸RA33AĸRAAHApAffAAģAÙA
=AQA\)AAHA{A33A
AA
A(ApA
=AAzAÅAÅAGA\)AÅA¸RAffA
A  A=qA£AÙA=qA
A=qAAHA\)A
AAAffAAffAƸRAƸRAƣA{AffA  AzA=qAQAƏ\AQAffAƏ\A(AǅAHAǙA33AA{AǅA\)AǙA{AHAȸRAzAzAȏ\A  A
=AHAǮA{AHA33A=qA=qAffA\)AģA¸RA=qAA33AA33ApAəAAffAQAA\AA\AARA=qA
=A
=AGAĸRA33AģAAîAAAffAHA
AŮA33AAzAǅApAǮAȏ\AɮA
A{A{A(AʸRAA˅A  AQA\)AffAəA\)ApAAɅAəA(A
AAAA
A=qA{A{A
A{AAɅAAȸRAAGAAAAffA{AAGAAHAȣAHAzA(A  Aȏ\AAǙAzAffA{AGAGA  A{AA
=A
=A=qAĸRA=qAŅAŮA
A£AA{A
A\)AAQA\)A=qAȸRAAA33A33AAƸRAAAHAɅAɅA(AʣAA˅A{A(A33AGAAͅAͮA
AͮAAGA\)A  AAͅAͅAHAQAAȀ\AGAGApAAͮA
A͙AGA33AGAA\)AAA  A
=A=qAAȀ\AA̸RAzA=qAʏ\AffAHAAGA  AQAzAffAGAAǅA33AƣA
=AAQA  A{AȣAȣA33A33AɮApAɮAɅAAǙAAzA{AA
=AAîAHA
A(AHAHA(A(A
AAA
AÙA{A33A
=A33AɅAA{AffA\)AʸRAʣAQAffAʣAˮAAAʣAʸRAʣAʸRAHAAʣAʸRAA
=A
=AA\)AGAGApAAAAA
=AA
=Aʏ\AzAHAGA
=AffAGAHA\)A
=AAQA{AȣAA  AǮAffA{AA
ApAǙA33AffA\)AƸRApAffA(AGAzAffA(A  A33A\)AQAAzA(AffA
A=qAAȏ\ApAAQA=qAƸRA=qAQAřAƣAǮA
A\)AffAA33A  A\)AΣA
=AӅA
=AAAffAљAGAA33AA\)AHAAυAϮApA  AAffA(A̸RȀ\A=qA{AHẠA̸RAzAffA
A(A=qAzAQAzA(A(AˮAˮA
AA
=AA\)AGAȏ\AAzAQAǙAApAGAA
=AAAzA
AA=qAAA{A{AAǅA33AHA33AzA  A{AȸRA33A(A\)A\)AAǅA=qA\)AA˅AA(A(A͙A
=A=qAϮA\)AθRAffAͮAQA
AffAθRAffApA33A̸RA
A(AQA=qA=qA=qAzAzA̸RAAͮA͙AͅAHAA\)AAA33AAApAA
=A33A{AɮAA
=A=qAA33A=qApA{A
=A  AAAAƏ\A33AGAɅAAA˙AA  A=qA  ApAÅA33AAQAGA
=A
AAAAAGAffA  AzAA33AǙAǙAffAȏ\AȣAȸRAGAəA(AʣAA˙A\)A˅AA{AffAQAQAQAA{AAθRA=qA=qApA\)AAHA
=A
=AAHA\)AͮAA͙AͅA͙Ȁ\AAGAA(AAͮA=qA
=AϮAffAzAffAA
A
AAQAA
=AΣApA
=A{AẠA(AffAQA(AʸRAA˅AʸRA33A˅AẠA˙AApAQAQAAffA33A=qAͅA{AHApA
=ApAzAQAAAA\)AAQAHApApAAAЏ\AHAAGApAAAGApA=qAϙApAffAЏ\AϙAHA33AA\)A33A  AҸRAAAAAҏ\AzA  A
=AңA=qAGAϙAQA\)A\)Ȁ\A{AzAApA
=A\)AƏ\AǙAAQA{AȸRAȸRA
=A{A  AGA  AƸRA=qA\)AHAA
AHAǅAƣAƸRAǅA\)AǙAǮA
=AA{A=qA
=ApAǙAQApA{A{A=qA
=ApA  AzAəAzAəA(AəAAA33AȣA{AGAAffA  AA{AzAA{AGA{A
A=qAffAHApAHAAQAAΏ\A(ApAAͅA͙A33AAzAApApAA33AApA33A33AAˮA˙AA(AˮAzȀ\A
=A͙AA{AA=qA=qA
=AffAAAQAAAffAGAGA33AƏ\A  AA\)A(A{AHA
=AGAAŅAffA=qAffAƸRAƸRA
=ApA  A(AȣAAAzAffA˅A
AffA̸RA̸RA͙AθRA33A33A\)A\)A33AAHA͙AͅAͮAͮAͅAəAA͙A˅ẠA=qA=qA(AΣAGẠA
A=qAffA  AͮAffAAHAzAͅA  A˙AʣApA  AGApA̸RA˙AẠApApA(AȸRAəAˮAəAAƣA\)Aď\AAAAQAA33A33Aʏ\AAʏ\AGA
A͙A(AffA(AʣAɮAffAAQAAffAAͮAffAHAAGAϮAQAиRAA{AGA
A  A=qA{AQAffA33ApA=qA{A
AGA{AffA
AAѮA  A=qAѮAѮA
AѮApAѮA
AA  A  AAA
AA33A=qA  A=qA
=Ȁ\A{AzAυA\)A33AzAffA(AffAA{AυAA=qAQAЏ\AzAzAffA
=A\)A
AAHAAϙA  AυAAΣA(ẠA
AA{A\)A  A
=AzAAA  AΏ\A
=AϙA  AffA
=A(AљAѮAGA33AхAA(Aҏ\AQAffAңA
=AҸRA33AHAЏ\AӮAӅA33AGAzA  AAљAхAѮA\)AGAHAAA
=AA
=AЏ\A33A
=AffAиRA=qA33A=qAHA(A{AAA
A  AAGAGApAȏ\AǮA{AA33AAʏ\ApA{A33A=qAУAzAAA33A  AQAңAҸRAHAzA\)A(A
=A(A
ApA{AA  Aҏ\AӅAәA33AӅAAzAԣA33A33AGApAՙAAAՙAAՅAAңAAffAAҏ\AAGAAҏ\AffAAffAA\)AAApAAzAѮAAHA(AϙApA\)A
=A(AQA  AиRAAAϙAHA
=A
AGAGAΣAΏ\AAQAͅAΣAA͙AHAGApȀ\A
=AAQAʣAA\)A˅AQAɮApApApA=qȀ\AẠAQAͅA  A=qAǙAQAƣA33AǙAGAQAGAA{AffAʣAHAA33A33AHA
=AAzAʸRAzAQA(A(AAɮAɅA{AQA(AQAHAʸRA˅A˙A˙A33A
=AGAA33A33AGA33A\)A33AAAffA(AffAzA33AAʏ\AAzAˮAGApA33AHAzAAHAʣAʏ\AGA{AAAƏ\AQAGAzA=qAHA=qAGA33AA
A{A
=ApAřAŅA\)AA\)AřAƏ\AffAHAGAAģAŮAƏ\AAA=qAAffAzAA33AŅAffAzAAAAA
AA\)A  A  AƏ\A(AA(AffAƏ\AAřAAƸRA33A{A  AAAAȸRAQAŮA
A(ApAA(AzAģAAîAÙAîA=qAAzAzA=qAAď\A{ApApA\)AAHAHA=qA{AA33A
AA33AAffAzA{A(ARA33AA
=AAHA  A33A
=A\)A
AffA{A=qAGAƏ\AAHAA(AȣAA{A{AzA(A(A(AɅAAɅAAA
AǅA33AGAA{A=qAAAǙA\)Aȏ\AffAAƏ\AƣAȣAffAQAƏ\AAŅAAƣAŅA\)A33AzA(AA
AGA=qA£AffA=qA=qApAÙA  AzAƣAAGAƏ\AAƏ\A
AHA=qAAƸRAƏ\AǮAǅAHAQAȏ\AApA  AʸRAzAȣAȏ\A\)A=qAəA=qAəA{A
AHApA(A{AQẠA33A
=AzA=qAHAffAffAˮA{AA\)Aʏ\AzAA
=AzA33ApA33AAffA{AAəA\)AȣAffA  A
AAǮAƏ\A
=AǮA
ApAģAď\A
A=qAď\Aď\A
=AřAHAA33AA\)AAA
=A
=AA
=AAAHApAAÅA=qAffAzAŮAzAAîAď\AA  AffAQA  A
=AQA{A{A{A¸RAGAAď\AřA
AzAƸRA
=A33A{AȣA
=AAAȣAffAQAAGA33A33AApAǅAƸRA33AǅAǅApAǅA\)AGApAAAApA
=AQAffAAAƏ\AHA(AAƏ\AzAzAzA
AřAîA=qAAŮAřA
A(AřAŅA
Aď\AzAģAAAAA\A(A33AHA
A
AHAAîA=qA=qA
=A\AQA=qAApAGA(AÙAHAAƸRAA
=AA
A33AffAŅA
A{A
AřAŅAAŮA{A
AQAŮAŅA=qA  ApAŅAAA(AAA(A\)AA{A  AŅAffAAQAHAffA  AAď\AffA
=A33A
=AĸRA{A(A(AffAģAģA
=AAŅA
A
AHAGA=qAzAĸRAAAffAď\A\)A  A
AAA¸RA
AApAApA=qAffA33AA33AA£A£AQAŅA
=A
=AAffA
=A  AAGAŮA  AA\)A\)AQAƸRAA(A=qAApAȏ\AzAHAAQAǮA{A  ApA\)AAGAǙAǮA  AffAǮAǮA  AA=qAzAffAȏ\AffAA
=AA
AǙAAǅA
=A=qA(AAAAA=qA{AŅAǮAAƏ\A(AģAƸRAƣAffA{AAǅAAřAAHAAAAŮAffAGA{AǮAȣAAHAƸRA  AȣAƣAǅAAǙAƣAA33AĸRAHAřAzAǙAǮAA  A=qA=qA{AQAffAQAQA(A(A=qA{A
A33AAǅAAȣAȏ\A
A(AǙAǙAǙAA{AffAAAA33AŮA33A=qA
=AAƸRAGA33ApAǙAAǅAA33A(AAAAƸRAA33AHApA{AAřA(A=qAAÅA\)A¸RA{AA{A{AGAÅAGA
=AAA\)AzAřAQAffAƸRAAzA{A=qAȣAHAAA  AȸRAȣA
=A33AGA33ApAəAAəAAɮA\)AAHAȏ\AɅAAAəA33AAAGA
=A
=AzAȸRAzAȸRAQAffA  A=qAAʣApAGAǮAHAHA  AəA=qAHAA
=AɮAʏ\AAA=qAǮAffAGAA(AřAAAřAŅA=qAĸRAQAQAQAffAffA(AQAAAĸRAĸRA=qAffAffA{AGA\)A
AģAAApAA
=AGA  A=qAffAȣA
=AffAGAɅAȸRAzA\)AA\)AAAAA\)AȣA=qA(A=qA{A  AAzA=qAA¸RAAŅAAA{A33AA
=AǮAǅAƣAAAAÅAAAA33A£AQAAAARAzAAAAA
A33AģApAffA\)AGAîAAď\AAHA
=AŮAffAQAzAzAAffAAzAA
AApAŅAzApAAzAA
=AȸRAGAəAɮA  A{A(A(A=qAzAɅA  ApA  AQA
=AȸRAAəAAQA
A{AffA
AAffAʏ\AffAɮA
AAGAGAAAȏ\ApAffA{AffAzA(ApA(AGAGAȏ\A  AQAɮAQA
=A  A  A
=AǅAQA=qAApA
AffAzAǙA(AAffAAĸRA\)A(A
=AAAHApAQA  A33AAӮApA  AAA33ApAיAAׅAיA׮ApAׅAׅAQA
=A֏\A֣AHA33A\)AׅAׅAffAظRA=qAQAzA؏\AAAzA
=A{ApAAظRAApAAمA
A{A  AՅA
=A\)ApAAәA=qA(AAA(A(ApA
AңA{AGAA
ApAиRA
=A(A
=A{AҸRA33A33AҸRAљAGAGAGA
AAAϙAϙAzAхA  AӅAӅA  AQAԸRAffAAԸRAQA(AffAхAGA=qA\)A
A  A=qA  ApAGAA\)AAAQAQAԏ\A  AAAAәAGAffA\)AQAffAҸRA(AA  AA=qA=qA=qAՙA
=AՙAHAzAffAffAQAϮA(ẠA
AQA(AAQAʏ\A\)A33AAA=qAAAΣAA˙A
AffAυA33A̸RApAHAA
=AQA{AHA
AA\)AAA{AʣAʸRAʏ\AzAυAAͮAHAzAϮAAHA\)AAљAAGA
ApAGApAGApApA33AAиRAAAиRAУAAQAиRAGAϙA{ApA  A33AAGA{A=qAʏ\A\)ẠA  ẠA˅AA\)A33AʣAAA
=AʣAAʸRAffA33AAA\)AAɮA(AɮAɅAA=qAʏ\AzAffAGAȣA{Aʏ\A
=A\)A  A(A  AzẠAHA  A  Ȁ\AAA\)AffAA=qAΣAA
=A{A(AHAA  AQAԸRAԣAffA(AAAGA33Aҏ\A=qA{AљAѮA33AA
=AAGAAQAҏ\AAAѮAУAϙA
AΏ\AθRAθRAHAzAθRAQA  A  AΏ\AυAGA  AAљA
A{AAAѮAѮAңA{AљA=qAϙAЏ\A
A{Aʏ\AQAʣAzA˅AffAͮA(A
AzAɮAAzAffAffA33Aʏ\AA  AA͙ApA
AθRA{A
=AѮAѮAGAљA=qApAA(AQA{A
AGA  A{AAA\)AՅA\)AAAAzA{A{A(AәA
AΏ\Ȁ\AϙAA(A=qA(A
AӮApA33AAApAffA
AϮApAA{ApAzAAΏ\AHAυA  AϙAA  AͅApA͙A33A
=AAQAAˮAGAHAʸRAAA\)AʸRAAʸRA\)AzA
AȣApAQA=qAʸRA˅AffA\)AͅAͅA
AΣAGAυAϮAAAAAQAAAA
=AA
AӅAӮA(AAzAԸRAԸRAԏ\AffA=qA\)A
=A{A
AѮAхAA
=AAQAΣAAAGA̸RAzAzA̸RA
=A{AzAffA=qA\)AAzA
AA=qA
AAHAȣAAAʏ\AAA33A\)A
=AȣAGA\)AAGA  A(AQAffA\)A(A˙AffA\)AzAAЏ\AϮA
=AυAzAffAAA=qAΣA33AͅAΏ\AͅApAAΏ\AA33ApA
=AA(AυAϙAAA33A\)AυAGA\)A\)A
AϮAυAΏ\AΣA
=AAͮAzA\)A{AHAQAAzA˙A˙A  A(AAʣAffA
=A
=AAzẠA33ẠA̸RAAQAAAAHA\)AAQA(ApAGAǅA
=AHA  A
A  A
AffA=qAAApAAffA  AȸRAȏ\A
AQA\)Aȏ\A33AɮAAA33AAzA=qA  A  A  AAˮAAA
AAˮA\)AʸRAʏ\AzAʣAAHAAʸRAʸRAʸRAAHA
=ApAA˅A(Ȁ\Ȁ\AQAˮA33A\)AAAQAAffA
=AɅAAAɅAʏ\A\)AzA
=AAȸRAɅApAAApAAGApAAĸRAǙA  A=qA\)A
A  A(A{AzAAɅAAffA\)A  A
=AGȀ\AQAQA\)AffApA33A\)AƏ\AƏ\AƏ\AGA{AA\)A˙AA33AzA33A33A\)A
AQAA33A\)AA  AGAAA(A\)A
Ȁ\A̸RA{AˮAˮAˮAʏ\A{A
AɮAɅAGA
=AHAɮAzAGAəAQAAHAʸRAʏ\A{AGAAAȣA
A\)ApA=qA33A\)AAȣA\)AAǙA{AffAʏ\A\)AȸRA(A33A=qA
=AQAȸRA(AƏ\AȸRAzA  AǙA(AȣAHAA
=AAA\)AzAAˮẠA(ApAffA
=AzAAУAAхA(AѮAУA{AQA{AQAffA  AУAQA{A  AϮA=qAϙAApAAΣA
=AθRAΣA{AzAApA͙AA{AΏ\AЏ\AЏ\A͙A\)A(AQAHAHAzAzAͮAffA{AͅẠAA33AA  AQAzAzAffA˙AffA
=A˙A
AHA
AAApAˮA\)A  A
ApAGAAQApA\)AA\)AAͅA  AϙA
=AЏ\AЏ\AffA33AzAAׅAzA33AӅAffA33AӅAУA{A=qAGAЏ\AQAQAУAzAffA=qAУAϮApA
=AAAQAΣAA
=AϮA
=Ȁ\A
AffAˮA˅AͅA(A
=AΣA=qA˅AGA{A{A̸RA33AQAˮAGAͮA{A(A̸RAΣAGA  A\)AApA(AǮA{A
AǙAffA33AAȣAAzA  AA(AǅA(AA{AzA33A
A33AAǙA(AffA33AǅAAGA33A{A\)AAffAȣAȣAǙA=qA\)AřAzAĸRApAď\A33AAA  AA\)AGAzAAQAARAGAîAAAffA
=AffApAQARA(A(AAAQA33AAHAAzA
AA33AA(A\)A\AHAAffAA
AzAAHAffA  A\A=qAA
AzA\AAGAA{A
=A=qAA
AA{AģA\A=qARARA£A{AîAAAAŅA
A  AƣA
=AǙA33AǙApA\)AƣAƣA
=AǙAǙAAƏ\A
A  A{Aď\AA\)AGA(AQAAAÅAŅA\)AģA33AƸRA  A=qA{AAQAƣAAHA
AAAď\AAA(AffA  AAAGAAģAAzA33AA33AApA{A{AA\)A=qAffAQA=qARAAA=qA  AGApAAffA
=A\AzApA{AffA\)A
=AǅAGAApAǙAAɮAřAƣA{A33ApAģAQAQA(A  A\)AGA
AŮA33AHA33A
=AA
=ApA
AA
=A
AffAGAA=qAȣAAƣAȸRAȣAQA
=AQA{ApAAzAAA33A33AAAƣA  AĸRA33AAAřA
ApA33A\)A33ApAQAƸRAGAHApApA\)AHAGAƏ\AřAƸRAGAAzAAA\)AzA=qA{AA=qAAffAffAAΏ\AA33A{AHAѮApAѮA(AAAA33A  A=qA33ApA33AQAA̸RAȏ\AffAHAAʏ\Aȏ\AʣA\)AϮA33AAϮAHA=qAQAͅAɮAʣA
=AQAAУA=qAЏ\ApA̸RAȏ\AQA(A  A{A
ApAAƣAzAffAApA=qAɅA  AzA
=ApA\)AA{A\)AQAzAʏ\AzA(AQA
=AɮAGAApA=qAʣAA͙A=qAΏ\AGAAϙAA  AffAHAθRAϙAAУAGA\)AѮAљAA  A  AffA=qA=qAҏ\AzAAѮAхA  A
=AGAθRAAQA
=A  AAAffAGAGAffAAQAAAAGAHAΏ\A(AQA  AʣA
=AHA33A
A
A\)A  AA  Aʏ\AffAHA33A=qAA33Aʏ\A(ApAиRAAffA  AQA\)AAAHAΣAAA\)AGȀ\AˮA˅AA{AQAAAΣAϙAQAQAхA=qAңAҸRAAӮA{AԸRA
=A\)AծAԸRAԏ\AAӮAӅA33AAӮA
=AzA
=A(A
AAЏ\AΣAAAAʸRAAzAυAϙAA  A
AAffA\)Aʏ\AHA
A˙AHA=qA  A=qA33A33AA
=A
A
A  A(AApAQA
AAυAϙA(AffAHAA(AGAA(AϙAϮAQA(AAѮA  A{AA{ApAAљAAffAϮAffAУA͙AAAиRA\)A\)AA=qAAA  A(A
=A
=A(AָRAAHA֣AffA֏\AQA=qAQAQA(AApAA(AәA\)Aҏ\AӮA\)A
AҸRAAиRAиRAHAиRA{AA
=AθRAAAHA
AAGAθRAQApAͮAzA
=A33AͮA(A  AAA͙A
AQAzA{AA\)AzA
A{A
ApAHA͙AAA  ApAGAApA=qAHAθRAffApAAAAHAAGAϮA
=A
AHAϮA33A\)A  AΣAΣAΏ\AΏ\AυA
A
A33A33AΏ\A33AͮẠA
AGAAAɮAˮA˅AGA  AAʸRAffA
=AAυApAAAAəAAffAʏ\A=qA(AɅAQAȏ\Aȏ\AȣAɮAAHAzAʸRA
AȸRA{A{AɮA
=AʸRA˅AɮAGAHA  AŅA33AA=qAHA  AGAA  AA͙A33AəAA33AAffAʸRA˅A=qA̸RApAzApAHA33ApA  AzAиRA
=AA\)AѮA33AӅAҏ\AљAҏ\AңAA33AffAҏ\AAffAffA\)A(AхA=qA=qAA{AAHAθRAA̸RAffAQAA(AA=qAHA
AzAQAAAAϮAAυAQA\)AAffA=qAʏ\A
=A{AAȸRAϮAQAʣA  AЏ\AffA
AA{AAA  AA͙Ȁ\A
A
=A
=AzA  A{AQAѮAffAA  A{AQA33A\)A
AQAԏ\A
=AGAՙAA{AffA֣AQA֏\AzAQA(A(AծAծA33AGAԸRA{Aҏ\ApAAffA33AQA  AffAԣA  Aԏ\AQA(AGA  AzAApApAA\)A(A{A(AљAʸRẠAѮAGAHA͙A  AʸRA˙AɮA33AΣA{AA͙AAA
AA˙Ȁ\AAͮAGA
=A\)ApA  A
=AAAͮAͅApAΣAQAHAυA=qAffA33A
AQAzAҸRAApAAffAzAԣAA33AGAՙAծAAAAԣAӮA  A33AGAӮAffAңA33AӅA{AffApAңAAAzAA
=AԸRApA
=AA\)AՅAԣAA
AQAAAәA  AA\)AQA(A33A33A(AA(A{A=qAA˅AGAHAAAѮAffA(A=qAхAхAAHA
AHAңApA  A
=AGAHA{A\)AυA
=A  AЏ\A
=AѮAQAGAApAӅAԏ\AA  A=qAffAԣA\)A  AՙA=qA
AՅAffA  AAffAծAGAAA\)AHApA֏\ApAApAGA=qAׅA
AظRA\)A
=A
=A(AHAA33Aԏ\A  AA(AљA
A=qA
=AA\)AәAA33AЏ\A  AQA33AиRA\)A
=AΏ\AGA(A=qAHAəAHAA  A  A=qA(AΣAHA
ApApAAУAQAA33A\)AәA
AffAAGApAծAA{A  A  A=qA=qAQA=qA(AԣAՙAծA  A{A(AGA
AQAQA(AՙAՙApAՅAՅAՅA\)AAGAՅAGAGAӅAҸRA{A=qA
A(A  AQAծAԣAHAӅA  AQAծAәAGAԣA33AA  AHAϮA{AA33AAԏ\A
=ApA
AzAAA\)AffA{AԣAGAGAҸRAA
=AԸRAՅA\)AffAҸRAGAffA(A(AffAAGAHAzA=qAәAәAAA(AQAAԏ\A
=A\)AծAՅAA֏\AGAA֣AzAָRA
AA  AՅAQAffA֏\A֣A
=AA
=AHAָRA֣AQAzAGA֏\A{A֣AA{AQA{A=qApA(A\)AծAffA{AA  A=qA
AծAA
AAԣA
=Aԏ\AӮAzAAA  AQAՅAffAѮA(AffAffA33AA
AffAGAAA{AffA\)AQAAԏ\AQAAHA33AA\)AծA33AծA33A  AָRA  A{A
A(A33A׮AAzAظRA=qAAQA=qAGA33A(A  AA=qAQA{A(AمA33A
A(AQA(AzAA{AAQAٙAAAAzAHAظRA
AA
AHAA
AGA=qA؏\AAծAAָRAzA33AHAAffA
A֣A33A(AAׅApAׅAQAAffA=qA׮AzAAAQA33AӮAAAծA
=AָRAffAffAיAׅA33AAHAָRAAAأAAAGAAA֏\A=qAָRA֏\AA=qAGA=qA  AՅAՅAAApAGA
=AԸRAffAHA
=AQA(ApA{AңAҏ\AzAAңAңAУA{ApAAA33AQAHAAHAҸRAҏ\AQAAGAAzA
=A
=AAAApA\)AθRAzAA  A
AϙAA\)AυAͅA33ApAffA\)A  AϮAffAAѮA
AϮAϙA\)A\)AЏ\AHA
AљA
=AA\)AA(A{A=qA33AѮA
ApAхAљAGApA
A=qAAљA  AхAљA  A(AAzAQA{AffAAAGAиRA33A=qAAGA{AHAЏ\AA\)A\)AQA  AA(AAЏ\A=qAA  AAzAzAAA͙A
AffA˙A{AQA˅Aʏ\A
=AʸRA(AͅAGA  A
=A\)A\)AѮA{AңAHAхApAHA=qAAAA\)AA(A{AffAA33AՅApApAA
A(AffAָRAA\)AAA׮AׅAGA֣AQAծAAGA׮AׅAAAAGAQAAָRA33AׅA33AAffA=qAAGA\)A
AԣAAԣAA=qAffAffA{AθRAffAУAHAA=qA33ApAA{AQAHAAϙAA\)AиRA{ApAQAϮA\)AAѮAffAҏ\AӮAAծAffA(A֣AHA33A(A33AffAQAzAA33A\)A  A{AA{A=qA֣AffA{A=qA  A{A  A=qAQA֏\AffA  A{AzAAԸRA{A33A
A\)AAQA{AzAHAҸRA  A=qAA\)AGAQAӅAAA
AQAҸRAGAӅAA\)AA
A
=AϙAzAGA  A\)AAGAAQAA33AхA
=A
AA=qAΣAA(Aԏ\A
=AHAGA
AA
AffA33AA(Ȁ\A
ApAAљA
AzAzAθRAͮAAυA\)AA(AAA33AA33AAӮAҏ\AffAңAӅA=qAA(AӮA\)AAzAzAA=qAҏ\A\)AGApAAљA\)A
AԸRAAAԏ\AӮAQAGAAУAA=qA  AЏ\A(AQAffAQA33AиRAffAAA(A=qApAHAffA33A=qA{A
AA\)A=qA{A{AAҸRApAљAЏ\AAHAQAffAҏ\AAApApAHApA  A  AzAԣAffAA\)A\)AA(A֏\A(AA(A(A33AA(AffA33A
=AأAHA
=ApA\)AGA\)AA33AGAAA{ApAٙAA
=AٮAٙAٙAظRA\)AיAA\)AԸRA  AՙA33AA\)A\)AӮAAԸRA\)A{AAzAA(A(AָRAHAAAzAA  ApAԣA
=A{AAffAA(AӅA\)A
=AA  A(AffAzAظRAGA  AzA(ApAA\)A  A{A؏\AHAGApA(AffAڏ\AA
=AffA(AzAݙAAݮA{A
AGAAGAܸRAffA܏\A܏\AܸRA  A{A\)AۙAۅAHAQAApA=qAQApA{AָRAָRAָRAمAA(A\)A{A
=AQAۙAffAAۮAQAיA  A֏\AׅAA{AHApA
A{AAAGA
=AأAzA33AA
A׮AAAAأAظRAAzAffAA{AGAQA؏\AHAQA=qAҸRA\)A֣A33A
=A{A֣A
AA{A(AzA
A
ApAAA
A\)AGAׅAA=qA{AA
A{AQA\)A{AzA  AՙA
AA
=AأA\)AA
=AzA=qA
AGAA؏\A=qA
=AәA  AAQAAңAԏ\AzAծA
=AA\)AGA=qAָRA׮A
=AAAA{A׮AAAA
=AԸRAzA(AٙAڸRA=qA33A׮AzAQAQA(AمApA33AHAׅAA
=ApA׮A(AظRAAAٙAA  AAۅA33A\)AAQA\)AAAffA\)A
AݮA{A
AA
A{AzAzAzA(AzAݮA(Aޏ\Aޏ\AAzA=qAAAA؏\AأAAظRA\)AAzA
AمAGA=qA
=A{A33A{AHA{AA
AڣAՙAffA33AAA(A{A=qAHAQAAܣA  A݅A\)AA
=AAҏ\AAHA\)AܸRAAA33A33AGAAHA{AظRAA
=AAٮAٙA
A=qAAAGApAۮA܏\A܏\AAݮAA33AAAHAݮAݮAܸRAzAffA=qAAܸRAQAQAܣA  AffAffAܣAܣAܸRA(A
=Aڏ\Aڏ\A
AffAٙAٮA(A33A=qAA33AA  AffAQAA\)A
=AՅAzA  AGAHA{AQA\)AAиRAظRAffAffAffA33AzAAڸRA(AAHA
AAAGAܸRAzAA
=AApA֏\A֣AzA֣A
=A\)AQAzAHAGA  AAAA(A  AA=qAܸRAܸRA  AApA܏\A{AۮAۙAۮAAffAAHA܏\AA
=ApA  A{AHAݮApA
=AܸRAݮAQA܏\AffA33AzA
AݮApA(AיAAHAQA  AA\)AۙAڏ\AAGAGApA
AӅAAA
AԸRAHAA33AAGAAԸRAAAffAA33AՅApAծA33AAGAAA  AָRAQA֣AzA
=A
=AיA
AAأA  AffA33A֏\AffAָRAQAיA֏\AՙA  A  AӮA{A{A֏\A׮AԸRAA\)A33A(A{AffAQAӅA
=AGAHAAQAԸRAԏ\AԸRAԣAGAAffAGAՅA
A{AGA(AAQAԣA
=Aҏ\AQA33AѮA  A{Aҏ\A\)A
A  Aԏ\AHAԸRAHAծA  A\)AGA\)ApA(A(A  A  AQA=qAAQAAHAQA(AzA֏\AQA֏\AָRA֣A(A(AffAיA33AAAָRAָRAzAAA
A
=AHAAAיA33AHAffA  AA33A(A  A33A33AA
=A=qA  AQA\)AA33AҸRA=qA=qApAffAAԸRA(AA
AљAՅAQAffA=qAծA֣A
=AָRA
A֣A\)AAGAA\)A33AׅA(A
=AAAՅA  A{ApApAzAAҏ\AңA
=AA=qAϮAzAA33A
=AиRAQAGApAzA=qAAҏ\AHA
AHAхA\)AθRAA=qA=qA  AHAAӅAffAQAGA=qAңAAңAAffAңAҏ\AAхApAAzAA
AAQAQA{AffAAApA33AQAΏ\AAQA{A  A{AͮAHAϮA
A  A=qAЏ\AHA
AAA
=AхA(AAиRAHA
=A=qA\)A{AԸRAHA(AffA{AGAѮA  AA{ApApA
AzAGAAGAAҸRA33A{AAҏ\AҸRA
=AAAӅAGApAӮAӮAA=qA  AQA
=A  AѮAѮAљAAQA33A
AͮAAGAθRAAAAυAυA33AΣAAAAA33A
=A
=A
=A\)AθRAͮA\)AffAAΏ\A33A\)AAAApA\)A33A33A̸RAA
=AzAхAAAӅA=qAzAAA(AAGA33A׮AיA  AظRAظRA=qAأAAHA؏\A
AׅA(A(A=qAzAAA(A(A{A{A
AAAffAיAAAzAՙApAԣAԣAA  A{A=qAGAҸRAҸRAffAffAAAҸRAԏ\A(Aҏ\AQAхAAѮAzAЏ\AA
=Aԏ\AӮAӅAҸRA
A{ApAAffA
=AzA
=AA33AңA
AAHA
AәA(A{A
A
=A  AzA{AљAЏ\AffA33A{AԣApAAQAzA33AAAA33AGA\)A׮AGAA33A  AAffApA=qApA(A
AA׮AA׮A
=AAAAA֣A
=AAAA=qAzAGAѮAӮA=qAQAAAApAθRA
=A{AQAzAAиRAGAA͙A{AңAHA=qAиRAGAffAңAHAQAA(AУAffAϙA  AЏ\Aʏ\A(AHAΏ\A=qAffAУA(AӅAңA(A
=AGAԣA{AӅAQAHA=qAffAGA׮AAQAffA؏\A؏\AzA֏\AHAAGA  AAAA  AمA
=A{AAA33A
=A  AzAGAיAAGAׅAA=qAA
AәA33AA(AzAԸRAQA
=AQA֣AA(AHA(AәAӮAиRA33AϮAzA
=A
=AGA33ApAљAzAHA
AA  AzAՙAA  AzAHA  A=qA\)AיAGAAAzA֣ApA׮AAGAׅAQAأAA
AׅAAA{AffAҸRAQA=qAҏ\ApA{AffAԸRA33ApAGAԣAQAAӮA
A
ApA(A{AԸRA(AԣA{AGA=qA(A{AәAA
=AӮAAAҏ\AQA
AҸRAApAѮAAхAѮA
=AAAљA
A=qAљA33AHAGAЏ\AϙAzAиRA(A(A(AхAңAGA
=A=qAԏ\AԸRAA
=AԣAәA
=AәA=qAҸRAAңAA33AAԸRAԏ\A{A(A=qA(AQAԏ\AԣAHAApAՙAAGAיAיA׮AAׅAיA{A  AQAAQAׅA׮A
A{ApA\)A33ApApAׅAAׅAָRA֏\AӮAAӅAׅAAGA
AQAQA=qA
ApA{A\)AծA(AA׮AGA=qAυAљAA=qAѮAхA{A\)AQAљAAҏ\AAQA
AՙAAӮA33AApA(AAffAQAzA{AԣA33AԸRA33AԣAA  A=qAffAHA33AՅA  A֏\AQAffAffAffAzA  A(A֏\A֣AHAAHAAA
=AA
=AApA\)AGAGA\)AיA
AGAAָRA  AQA  A(AQAծA=qAAA֣AAAA33A
=AA33AAHAffA{AՅA֏\AAffAA(Aԏ\AӮA  AAӮAәApAӅAGAңAAAHAA\)AAHA
=AәAәA\)A\)AљAAAffA(AzAQAѮA  A{AA(AAңA{AңA33AәAffAԸRAԣAAՅAծA  A֣A֏\AAׅA  A{AHAظRAAAffA
AA  AׅApA\)A\)A
AA
AAHAQAA  A֏\A
=AA{AAA\)A\)AAԏ\A{AHAҏ\A(A
=AA
=AGAAzAA(AHAApAGA=qAzA  AAzAҸRA{AA\)A{AzAzAAGAAԏ\AGA(AGA
=AѮAѮAԣAԏ\ApA
AHAAԏ\AA  AQAԏ\AHAAGApAffAAָRAHAAzA(AffAAA֏\AHAHAָRAָRA=qA{AQAAA֏\A֏\A  A
A
A
A
AA\)AA  A
AHAA(AGAAzAQAQA33AQAљAљAAљA
AӅA{ApAA
=AAхAхA=qAHA
AAA
A{AGAѮAѮAffA
=AGAAA\)A
AAAAҸRAHA
AA(Aҏ\A=qA{A=qAQA
=A\)AәA
AGAՅAAHA\)AGA=qAzA
AיA{A(A=qAQAQAzAأAHAAHA
=A
=AA
=A33AA
=AAAأAׅA\)AAA33AHAAHA֣A33A{AzAԸRA
AHAA{AAQAQA=qAхAffAAиRA(AzA(A33AAQAͮApA
AAAffA  A  AAѮAЏ\AHA{AЏ\AAA  A=qAGAәAGAHA\)AҸRA33AхA\)ApAиRAHAУA
AzAA\)A  AzAHApAָRAApAQAzAظRAA33AA{A
AQAQA
A
AٮAٮA33A33AAأAffAQAAA  AָRAA\)AA{AָRAAffAffAAՅAԏ\AffA(A
=Aԏ\A=qAffAAәApAGAA=qAҏ\A
=A(ApAAҏ\AHA
=A
A
A33A͙A=qApA33A
=A͙A33AAͅAΣAAAffA{AθRA{AAAA\)AQAA=qA=qAңApAzApA  AңAӮAәAԣAԏ\A
=A\)AHAHA
=AGAGAAGA\)AGAָRA=qAA(AAAA  A(AffAffAQA  AffAQA
=AA  A
=AHAAGAԣApAA{AQAA\)AQAffAAzA{AAHAHAхAAA33AQAHA
AЏ\A
A
=AHA33AA  AzAHA
=AffAzA33A
AՅA(AAGA\)AA{AzAظRA33AمA
A(A{AAA
AAٙApA33AAAأAظRAHAظRAظRA؏\AAأA؏\AHAAHAQAzApAՅA(AԣAffAAA\)ApA
=A=qAQA=qAAA(A33AQAzA{A\)AHAAzAӮA
=AHAәA=qApAzApAәA\)AυAӅAAffAGA
=AׅAAA
ApA=qA(AAҏ\AGAҸRA\)AQAAծAQA֣AָRAHApA(AأA
=AٮAA{AڸRAA\)AAޣApA  A݅AGAGA
=AzA{AۮApAۅAۙAA(A33A{A
A\)AHAأA=qA\)AHAHAՙAGAQAAGAGA
=A33AՙAAAԣAzAzAԣAGA\)AAffA{A
AAffAHA  A֏\A֏\A33AzAGAיAffAAיAA  A  AQAQA  AظRApApAٮA
AQAڣA
=AۅAۙA
AA
A{AQA
A{AffAܸRAܣAܣAzA
AA
=A=qA(Aڏ\AAAۮAA  A{AۙA\)AۙAAۮAAA
=AۮAAAAA  A
AAمAAffA׮AA
=A\)AGAA
=AA33AQAA=qAAָRAA׮A{A
AAAظRA\)A33AٙA  AٙA
AQAHAHA33A\)AA=qAAffAQAffA{AHAHAۮAAAQAݙA=qAHAApA߅AA(A(A(A  A=qAffA\AA\AQA(A=qA
AߙAffAQAAffA(A{AݮA(A33A33AAA\)A
=AܸRAQA
A=qA(AܸRAܣAzAۮAA33AffA  AGAGAQAۙAffAۙA(AAڣAzAzAڸRAQAAAۙAۮAۙAffAQAHA\)A33AۮA
=AzA=qAQA  AAظRAHAٙAQA  AHA\)AۅAQAffA\)AzAޏ\AzAݮA  A(A{AޣAHAAA
=AA33AHA޸RAzAQAzAGA܏\AGA
AAٮAAffA
AHA
=AzA=qAܸRAݮAHA{AffA
AۙAۅAA  AffAQA=qAffAHAA
AAzA\)AA
AffApApApAffA=qA=qA\)AAAQAzAA\)AיA֏\AA\)A{AQA(A\)AA
AAA=qAأA{A=qAظRAA33AمAٙA{AffAAAAAHAAAۅAAffAApApA
A{A(A{AAݙAݙAApAzA=qAHA(AۅA33A
=A33AڣAzAffAAGAAffAܣAݙA݅AיA
=AAA׮A33AHAAA=qA(A33A(AٮAٙAأA33AָRA؏\A(A֣A{A
AׅAׅA
A  AzAٙAAQAڣA33AڣAٙAGAzAA׮A؏\AAՅA\)AAӮAԏ\AGA(AA
=AA(AظRAAApA
AzAA{AۮA=qAHA
=AݮA  ApAܸRAQA
AffAۙAAQAffAۙAAzA
=A33A
A(AAzA\)AzAۅA{AHAAAۮA(AظRA{AۅAݮAۅA
AA޸RA  A\)A(A=qA܏\AHA{ApAңAHA{AظRA
AAGAffAApAۙAffAܸRA
AzAAGAA\)A
=A33A
=AA\)AQAAA(AffAأAzAAمA  AڣAApAA=qAzAHA
=AAA33A
=AAffAffA(AzApAݮA
A݅A{A33AHAܸRAܣAGAQA܏\A܏\AܣAۮAݙAzAܸRAQA
AۅAA
=A=qAڣAAAzA(AݮA  AGA{A(A(A{AHAzA33A33ApAffAأAA  AzAAA  AAأA  AHA  AۮAA\)AۅA
=A
=AڸRAHAAڣAQAظRA؏\AzA  AיAGAأA(A֣A  AHAA=qAAHA(AظRAQA
A(AAQAA  A=qA{AffA؏\A؏\AzAHAHAffAffA=qAA33AۅAQAܣAָRAݙA܏\AGA
=A\)AۅAA(A
AٙAA=qA=qAݮA
=AzA
AڣAzA(A{AA֣A33AAGAQA
=A\)AGA
AHAzAA
AAAAυAϮApA33A33AQAAQApAHAzA{AA\)A33A=qA\)A33AGAׅAAffAHAffAظRAظRAأA{AأA33AApAffAHA  AأA׮AיAAHAQAffAָRA33AׅA׮A{A(A33AHAۅAzAۅA
A
=AffAQAApAA
=AAA
=A؏\AzAffAׅAffAGA\)A׮AظRAAffAffAיA\)AיA׮AיAׅApAAA=qA=qA  A؏\ApAAׅAA\)AA=qAA
=AӅA\)AәA
A  AGAAԏ\AzAԣA=qAzAծAHA֣AAיA  AGA\)ApAۅAzAHAڣA(A  AٙAGAzA؏\A33AzA{AzAzAQA؏\A  AzAQAأAA
=A=qA\)A{A33A  A33AۙAAApAAHA
=AA(ApA؏\ApAQA֣AQAHA33A
=AAHAGAQAAأA  A؏\AffA(AffApApAٙAGAAAمA
=AיAA{AمA33AA
A؏\AA\)AۙAffAA݅AAݮA(AA
=A߅AߙAߙA(A  AA  A  A(AA߅A\)A33AAHAޏ\AQA=qA  A  AGAܣAA=qAHAAݮAAAA\)AGA݅A݅AAGA\)A33A
=AܸRAHA33AܸRAQAAٙA׮A\)A33AظRAHA  A\)A֣A(A֣AA=qA(AQAAffA  A(AzAzA=qA
=A
AHAمAQAGA33AA  A=qAQA(A\)A\)AQAיAAAܣAA(AAGAQAA݅A݅A݅A݅AAAA܏\A
AڸRAQAٮA  A(A(A  AQAۮA{AQA(AܸRA܏\AAAzAHA33A33A܏\A܏\AAٮAمA33A\)A؏\AڸRAڏ\A  AAA؏\AffA  AzAظRA؏\AAffA؏\A
=AأA
=AٙAA
A  AָRA(AׅA
=AHAHAأA  AAzAA
A{AHA33AمAHAڸRA=qAۮA܏\AAzAܣAzAܸRAAHAApAݮApA݅A\)A݅ApApAݙA
=A(AAA
=AAAAAGAݙAA
AޣA=qAޏ\A(AAGAHA܏\AzAzAAܸRAۮAQAGAۅAڸRA  A{A{AA{A=qAffAffAمAzAAڣAffA
=A{AffA{ApA\)AGA\)A\)AAڸRAAHA
=AAAAffAA=qA׮A{A֏\A  A
=AAQA=qAҸRAӮApA(A(AәAffA׮A  A׮AAظRA\)A(AAHA\)AGA(ApAA  AQAQAzAޏ\A=qA
A
AݙAQAܸRA݅AܸRAܸRAܣA܏\A
A33A=qAAGAA{AA
A޸RAHAAzAHAffA=qAA  AݮAݮA
A
A  AA\)A\)AA\)AݮA
A  AAAA
=A܏\A  AܣA33AA{A؏\ApAAAA(A  A
A{AQAܸRAQAzApAۮA=qA  AQA  A
AA
A޸RApAffAHA߅AzAAGA
A  A{A  A{A{AAܣA(A(AݙA
=AQAۮA  A\)A  AGAAAHAGAGAHAAzApAGA\)ApA߮AApA
=A=qAۙA{AمAأAA؏\AA\)AAA  A(A=qA؏\A{A33ApA؏\AAA
=AAA(A
AAAظRAAיAׅAA֏\A
AGAHAڣA33AGApA(AۅAApAA
=AGA{Aޏ\A{AA=qAޣAAAzA(AffAzAffAGA(A߮A\)AAHAAQAzAAQApAݙAݙA܏\A
A=qAffAAQAݙA33AAA{Aڏ\AA
=AHA
=AHAffAQAQAffApAיAQA(A؏\AHApAָRAQA֣A33AׅAAAzA33AffA=qAיA\)A(AיAAAA{AQA=qA׮A֏\AA֏\A׮A\)A(AAA؏\AظRA33AGA
A
=A
=AQA(AzAمA
AAGAHAڏ\AGAA
=AڸRAٙAzAA
ApAA֏\AծAzA33A
A(AԣAAڏ\AGAffA  AAڏ\A(AAHAGAمA\)AGAA  A
A=qA\)Aڏ\AڸRA
=A33A33A
=A  AffA
ApAHAQA\)A=qA{AA=qA
A33AffAHAمAAڏ\AffA{AGAAAzAHAA֏\AHAAָRAAAApA=qAծAAԸRAQAAՅAծAQA33AׅA(AأAAأAffA=qA\)A؏\AQA33AGAٮA  AffAQA
AffA  AAظRAA\)AAA  AיA{A33A\)A׮A
=AGA
=AHAAՙA
=A\)AzAA\)AGA33AQAA=qAffA{AAծA33A33AAHAAA  AAAzApA=qAԸRAQAQA
AA
=AA֏\AׅA֏\AAffAQA\)AA
=A(A
A
=A֣AffA֏\A؏\A\)AٙAٮA{A(AڸRAAGAۮA(A33A݅A(A
AA޸RAAAA\)AA=qAޏ\AffA
A  A
=AzA
AۮAGAAffAQA  AٙA{AAQAAHAۮAQAܣAffAzAHAzAۮAיA\)AA(AQAQAAAAٙAGAAAzAׅA\)AHAأA׮AHA\)AffA؏\AظRAGA(A\)AA=qA
A
AծA\)AzAHA؏\A(A֏\A(AffAHAffAHA
A=qA{AAAQAzAA(A{AظRAٮA\)AمA=qAQAڸRAAAۮAAffA  AzAظRAAׅAAQA
=A=qAڣAAڏ\AAAأA(A=qA܏\A=qA=qAأA
A
AA֏\AծAծAGA33A(A{A(AԣApA\)ApAՙAAQAA=qAԣAәAA  Aԏ\A(AGA؏\AHA֣A׮AAAAffA
=A  AAA\)A\)AAՙAzA
=A=qApApAӅAҏ\A
AA
A(ApAAA=qA=qAzA(A  AԣAApApAA(A{A{AծAՅAԣAԏ\ApAA{A{AHAمAمAٮA
AA  A{A(A  AAٮAAיA33AAQAzAQAՙAѮAffA  A
AAңAAԏ\AAAA{AԸRAffAAՙA
A(A  AՙAGA\)AՅAQA֏\AՙAAָRAzAA֏\A  A{AffAA(A(AQA{AأAمAٮAA  AڸRA  A=qAQAۙApAffAܸRAAzAQA=qA=qAA
AAQA(AA
AٙApAمAٙA܏\AzAzAA33A
=AGAۙA
AA{A  AܸRAܣAܣAzA܏\AܸRA
=AܣAܸRAܸRAAA܏\A{A{AA{AGAأAzAHAGAQAHAڣAAAApA\)AڸRAۮAۅAAٮAڣAHA\)AۮA  AzAڏ\AAzAHAۙA{AA܏\Aڏ\A=qAA=qAܸRA܏\AAGAAޏ\Aޏ\AzAAffAޏ\AޣA33AA\)A߅AA=qAQA=qA\A=qAzA
A߅AGAAߙA\)AA߮AޣAAA33AHAffAݮAAAݙAQAA  A܏\AffA{A(A܏\A=qAffAHA  A=qAܸRA
AHAzA  AAٮAA(AQAQA
AAA(A\)AׅAAA
=A\)A׮AA=qA{AظRAHAA\)A؏\ApA(AzAHAظRA؏\A(A
=AأA=qAٙApAGAAzAڣAApAA(AffAAHAA33A
=A
=AApA݅A\)AA33A33A33AAAAܸRAܣAܸRA
=AܣA(AQA=qA  AۅAAۅAQAAڣA  A
=Aڏ\AAQAAzA\)ApA\)A33AA
=AAأA=qA؏\AffAAAAQA{A(AQAQA؏\AzA(AHA{AծAzAffA  A
=AAA֏\AHAAՙAӮA{AA֣AApA(AApA=qAڣAAAۮApAۅAAHA\)AA\)AA
A  A  A{AۙAHAڸRAڸRAzAڏ\A=qA=qAمAظRAHA\)A
A
AٙA\)A\)A33A
=A\)ApA
=AAA33AٙAمApA
=AzAQA׮AHAأAA
=AAGAGApAAڣAQA؏\A؏\A\)AzAApA
AQA\)A{A
=A
=A{A׮A  A\)AAQA  AA  AHA\)A֏\A=qAA(AՙAA  A(A  A
AAA  A33A
AָRA(AA؏\AمAڣA  A  ApAܸRA\)A33ApAݮA
A
AAݙAA
=A
=AAAHAA܏\AzAܣAܣAܸRAffAffAܣAܣAܸRAәAA\)AGAA=qAffA
A{AffAffAAQAAffApAA؏\AAGAA؏\AAQA(A{AمA  A33A=qA33AӅAՅAGAHApAׅA\)A؏\A  A33A؏\A؏\A(A\)A
Aԏ\AGApAzAQAٮApAzA
=ApA  Aڏ\AУAHA
=A\)A׮A  A؏\AQA33A(AA  A=qAAAA(AffAAAzA
=A{AׅA؏\A33A  AQA{AңAأApAծA
AծAԣAA  A33A\)A=qAHAAA(A
=ApA(AΏ\A
=A
A(A(A
=A
AυAϮAffAHAУA=qA
=A33AGApAA
=AңAA(AӮAңAffA=qA  AңA=qA33Aԏ\Aԏ\A(AGApA=qA33A׮AיAA֏\AAҏ\AԣAAA  Aҏ\A
=ApA  AA
AָRAՙAA
=A\)A33A
=AAԸRA
AA33AffA{A
=AHAQAAиRA  A  AffAAхA33ApA
=AхAAA{AЏ\A\)AA  AAQA(AA\)AQAA
AңA  AЏ\AzAGAУAGAAA=qA33AAәA{AAGA(AAA=qAQA׮A=qAffA؏\AHAHA{A33AAAzAA  AzA(A{AA=qAAۮAQA{AA33A
=AڸRA  AAffAAAٮA
=A׮A֏\ApAAAԣAzAA=qAHA܏\A=qA
=AۅA  AۅA
=A
AͅA(AٮA؏\AzApAA֣AٙA
=A  A{AA
A֣A
=AA=qAHAA=qAٙAAA׮AHAAAڸRAڣA
=AA(A  AHAHA\AA=qA޸RAARAffA{ApA\)A33A߮A(ARA=qA=qA(A  A(A(A{A  A(A=qA
A  AGAA  A33AHA
=AۅA=qAAڸRAQAڏ\A\)A(A33AffAQAظRAظRAzAA׮AHAQAՙA{AffA\)AיAՙA׮AAQA
AHA(AA{AffAQA֏\AՙAQAffAָRAAGAׅA׮ApAׅAHA33AיAAיA33AzA{AA׮A
AأAظRAAظRA׮A׮AظRAٮA
A33AffAQAA(A(AGA
=A{AAAA  A{AָRAQAAA֣AQA(A{AAԸRApA33A  A=qAAA33AA֣A
AA(A(AGApAA
Aҏ\A  A{AzAљAAQA
AA
AA=qAAAA
=AApAA׮A  AأAظRA
AffAAGAA\)ApA=qAܸRAAݙAA  Aޏ\AffA޸RA
=A\)A{AޣAA
=AAHA޸RAHA޸RA޸RAޣAAAHAAHAA
=AAA(AGAAffAA܏\A܏\AܣA\)A݅A\)AܸRA  A܏\AzAAzA܏\AAApAڏ\AHAAQA׮AAHA
=AۮAffAأAzA  AQAAzAAAAffAQApA(AzAڣAffA
A{AHAQAffAAQAzA
A
=AAzApA  AQAޏ\A33A߅AAffA(A=qAffAA߅AffApA\)ApA
AHA(AAܣAޏ\A(ApAAA
A=qAظRA
AAAQAAA؏\A  ApA׮A
AffA33AQAHAzA
A33AأAظRAׅAA\)A(A׮AԸRAGAיAAمA
AAٙAApAAAA=qAڏ\AׅAHAڏ\AHAAڸRAzAۅA׮AHA33A\)A\)A(A\)A(A\)AٙA(A
=AAمAAمAAAظRA
A
=AHA
AיA33A=qAffA=qA=qA(A{A  ApAA
=AظRApAAAHA{AأAظRA  A{AA  AffAHA33A֣A֏\A֏\AAzA(A{AAGAGA33AGAA
=AAAHAHAAGAHAծAAAHAԣAՙAծA֏\AQAQAffAAA\)A\)AՙApAAԏ\A(AԣA  AHA֣AA33AׅA=qA׮AA(AQAzA؏\A؏\AffAأAHAHAHAQA\)AffAأAGA\)AAAGAGAٙA\)A  AٙAGAAمAٮAٙA\)A33AA33A33AA
=AHApAA33ApAAٮA
AAA
A؏\A֣AAՅAAA
=ApA
=AӅAA  A{A
=A֣AՅAAAأAAHAffAٮAQA=qAffAمAA{AAQA=qAQAQAQAHAظRAمAA(A=qAHAGA\)AۙA  A=qA=qAzAffAffAzAQAAۮAGAffAڣA=qA=qAAAAمA  AzAHAHAAGA=qAzA؏\A33AA(AأA(AffAffAffAٙA
AHAzA=qA
=A=qAAHA
=AffAمA(A
AAA  AAAיAHA  A33AٮA  AA=qAHA=qAظRAQAA{A33AۅAHA33A\)ApA=qA=qA(AAAܸRA=qA{AffA\)A
AGAQAAAׅA33A
=ApA{A  AzAأAٮApA{AٮAffAAمA\)AٙA  AڣA  A  AA(AHA(A  AA
=AAAܣAAHAAAڣA=qAHA܏\A{A׮A(AQAיAHA
AA(A؏\AأAQA؏\A؏\AظRAAAAAzA(AAffAGA=qA
A(AQA  A֣AffAAA33AٙAAAۙAQA{A{AzA
=AٙA{AzAHA\)A
AAzAHAAAGA݅AGA
=A
=AA݅AݙAݮA݅ApA{AܸRAApA\)AA܏\AzA܏\AffA܏\AQAۅA
A33AٙAأAծAיA{AQA
AA=qA܏\AܸRAffA\)AQAzA
A
AAݙAۙAA
=AGAڸRA33AۙA
AA{AzA  A(AAzAڸRA(AAA\)ApAA\)AQAAGAAۙAffA܏\AܸRAHA33A\)AGAAܸRAHA\)A(AQA  AAA
A{AQAQAܸRAAݮAGA\)AHA33A޸RA33ApAߙAA߅A
AߙA=qA{A߮AA  A{AA{A  AߙA߮A\)AܣAffAۮA
=AGAQA
AۮA  AۮAڸRAQA\)AAۅA(A\)AffAAڸRA(AمA(AڣA33ApAٙAA
AA
A\)A
AٮAGA
=A
=AAڣA  AGAأA
=Aڏ\AٮApAffAffA
=A
AڸRAۮA=qAA=qA܏\AHAܸRA܏\A33ApAݙAA݅A݅AAߙA߅A  AA޸RAffAޏ\AޣA݅AݮAzAApAۙA33AڸRA{AzA=qA{A{AA(AA
AׅApA{A=qAffA܏\AzAAHAA
=AHAGApAڏ\A\)AA{A
=AAzA\)A׮AffA׮ApA  AAAۮApAGAApAffA֣AQA33AٙA  A(AGA{A{AGA؏\A׮AApAمAffAAAיA\)AיA׮A33AיA{AGAAffA=qAA  A  AܸRA
AAۅAAffAAQAffApAAGA{A
=A׮AٮA(A  AffA
AAffAA\)A
=AծA33AQA{AծAHAzAApAA(A؏\AAAAAAAQA=qAA33AԸRAGA  AzAAffA
A
AיAQAzAمAAHA{AڸRAAAffAAAӮAԣAәA=qAAHA\)A(AأAGAzA
=A
A܏\A(AڸRAڸRAzAzA=qA=qAffAمA(AAA
A׮A؏\AAffAA=qAڏ\AzAApAۮApA{A=qA=qAzA{A\)Aڏ\AHA
AݙAڸRAۅAGA\)A\)AAA  AAffAQAHAHAApAHA=qAA  AzA{AՅAՅA(AAAA{A  AffA(Aڏ\AAffAzA(ApA
A\)AQA׮AzA  AzA=qAzAHAA(AA=qAAڸRAAۙAA(AffAܸRAA  AzAA
=A(A\)AޣA޸RAzAHAޏ\AAGAAAAޏ\A
=AzAzAA  AzAAٮAۙA
=AzAQA33AHAGAA=qApAٮAAGAHAGAׅA{AՙAծA(AׅA֏\A׮AffAffAأAمA33AظRA\)AGApA
A{AA(AA
=AA  AAGAٙApAA33AHAAظRAٮApAٙAQAA=qAAڸRAHA\)A=qA  AۙA  A߅AQAܣAA33AAA\)A{A{AݮA
=AAHApA(AۅAzA
=A=qAA(A܏\A  AA(AۮAA=qA
AAۮA݅ApAHAAApA33AGA߮AAܣAAڏ\ApA(AיA33AיAApAGApA=qAGAڏ\AڣA\)AHAHApA\)A
A
A{AمAAGAA{AAAۮA33AۙAمA(A33A܏\AAA33AڣAڏ\A\)A\)AffAHAA=qAA
=A\)AA
AA\A33AA{A(AAQAGA
=ApApAHAA  AAA(AߙAAAAޏ\A(AGA33AA  AAڸRAڏ\AٮA=qAHAٙAAA
=AAAGApA؏\AיAAיAGAGAAمAAָRAA33AӮA  AA33AGApA
=AzA
=ApAA؏\AQAffAA
=A\)AٙA
A{AffAffAAGAۅAQAHA
=A33A
AA=qAzA޸RAHApA(AffAHAAA
=AAAAAA{A=qAQAffAffA33AQA޸RA(AAGA=qAHAۙAAAAۅAHA
AۮA=qAAQA݅AݮA{A{A  A{AA޸RA
A  A
A
AߙAGA
=A33AA(A
AzApA܏\AݮA=qA(AA(A
AA=qAzAܣAܸRAffAffA
=AQAڣA(AA܏\AA=qA(A{AQAأA޸RAA\)A߮A{A=qA{AA߅AAޣAޣAzAzA
=AzA߮AzAAAAAAAߙAGA33A߅AzAA=qApA
=ApApA\)AڸRAzAAۮA܏\AޣAޣAHAAffA
AffAffAٮAGAA܏\A\)A(AffAA
A  AۮA(A
=A݅AݙA{A(A޸RAAApAffAޏ\AGA޸RA33A=qAQAۙA\)AޣAޣA݅Aޏ\Aޏ\A  A(ARAGA\)A{AAHA33AA(AAAApAAA(A  AA  A  A㙚A
A
AA\)AHAGA\AHA33AAApAGA33AQA  AA
A(A
=AAA  A޸RAffAٮAڸRAיA܏\A(A\)A=qAGAAAApAۮAzAۙAAAzA{AAAAۅAۅAAHA܏\A݅A33A
AAQA
=A  AQAA{AA  A{A\)A33A{AۙA33AۅAA  A  AffAܸRAAGAݮAAzA
=A߅AAARA
A{A33AAA(A{A
AGA
A
AQA(AffAޣAA߅A߮A(A(AGA
ApA\)A33A݅AAGAA=qAffAA33A33AA33A\AA\)A\)A=qA޸RAܣAAffApAAA\)A
A(A
AGA=qA߮AAݮA
=AAڸRAA݅AAzAzAHA{Aޏ\ApA
=A(A
=ApA{AܣAۅAܸRAAA\)A33AzAݙAA33A=qAݙAAffAޏ\ApA\)A  A\)A  AQAAzAA=qARAۙAۙA(A=qAQA݅AA  AGA߮AAQApAQAA\)A33AңAҸRA\)AՙAԣAԣAՙApAՙA
=A33ApAQAA
A֣A(AA֏\A\)A(AأAՅA  AӅA\)AAӮAԣA
=AzApAָRA(AzA
A(AA{AҸRAA
AAՅA=qA(AڸRApA\)A  AzA(A
=AAAAAݮAݮAA݅AݙA{A(A݅AAޏ\A=qA(AݮAAHAAGAAۅAGAA  A33AAܸRAGA  A(A  A
=A  A\)AA(AffA  AӅApAHAzAׅA׮AzAأAGAAٙAمAڸRAA(AzA
A(AՅAAԣA׮AffA{AQAϙAffA(AծAAA  AffA33A
=A(A\)A\)A33AAAAA̸RAQAQAˮAffA\)A\)AHAAGAӅApA
A33AљA
AУA\)AУA
=AGA33AA33AHA
=A\)AGAA(A(AAHAAQA(A=qAGA\)AGA  A͙A
AΏ\AGAˮAA33AHA(A(AAʏ\AzAGAQAͮA=qAQAиRA
=AHA=qA\)AAAAHAGAGA33A=qAѮAҏ\A
AQAHAA=qA
AQAA˙AˮAA  AffAHAA
=A33AΣA
AHAffA{ApAffAυA=qApA
=A  A=qAA(AGAHAԸRA33AAиRAffAиRAAѮA=qAAAУA(A\)A{A
=A
A
AHA\)A\)A
=A(A(A33A33A\)A  AңA
A=qA=qA  Aҏ\AGAϮAθRAУAУA
=A\)AzAԸRAHA
ApAԸRAzA33AHAϮA
=AApA{ApAzAzApA(AffAffAхA33AAffAA{A
AffAHA\)AAA=qAAffA\)AҸRAGAӮA=qA(A\)A
=AHAԏ\AffAԸRA33A֏\AzAzA
=AׅAHAA
=AAAA֣A
A33A\)A33AԸRA33AAҸRAzAffAA
AHAυA  Aҏ\A{AQAAיA  AA
=AHAA؏\AAָRA
=AծA׮A\)A(AљA33AA
=AA\)AffAѮA\)A
=A
AѮA
=AffAGA  AQAAҸRAԸRApAQApA{A{AzA  AApA{AՙA(ApApAхAGApAA{AңAGA=qA  AиRAAѮAffAҏ\AA
AzA(A  A(AԣAAԏ\AzAԣAӅAA{AQAљAҸRAGAҸRAQA33A(AӮAAQA=qAAApA=qAAGA=qAЏ\A{A\)AAҏ\A\)AиRAУAffA\)AңA
A=qAAϮAиRAљA
=AQA(A\)AA  AәAzAA
AԣAAՅAԣA=qAҏ\AљA(A
AҸRAҏ\AGAHAAҏ\AծA=qA
ApA֏\A
A
=A\)A  AAGAۅA
A{A(A܏\AܣA
=A
=ApAݙA݅A
=A݅AݙA݅ApAAGAA=qA=qA  A(AzAA׮AAHApAQA  A֣AAA\)A
AA
=AffAԣAzA{AAAA
A=qAҏ\A
=AHAծAA֣AffAA{AQAHA33A  A؏\AA(ApAQAApAٮA{AzAٙAAٮAHA
AffAQAQAAAҸRAҸRAA  AAԸRAAHAԸRA(AAA(A(AAՅAGA{A֣A֣A֣A  A=qAA=qA=qAA\)ApA{AAAAffAA{A
=A33AGAAָRAAQA
=A33AQA33AԣAָRAffAAظRA؏\AHA(AיAQA(A=qAAffAffA\)AՅA
=A=qAQA\)AԣAՅAA
=A
A  AיApAA{AԸRA
=AAAGA
AمA؏\A؏\AHA{AA
AA{A\)AQAۙAۮAA\)AݙAHAAzA
AAAݮAݙA\)AA{AApA33A\)AA\)AݮApA(A(ApA
=AGAܸRA(AޣAޣAAۅAٙA33Aޏ\A(AAAHAA޸RAAA܏\ApAܸRA
=A݅AA
A
=A
AffAA\)AٙA=qAA؏\A(AzAApAՙAAA  A{AٮAHA33AAAۙAGAAڸRAAApAڸRAGA
AAAQAAܣA\)AGAApA
=A\)A33AݙAݮA  A(AGAޣA=qAzA
=AA
=Aޏ\A݅A(A
AQA
AHA\)A  AAA
=AٙAٮAQAA  AڸRAQA33A=qAzAڸRAڏ\ApAأAA(A
=AA(AGAA  ApApAׅAQApA  A{A
A  AָRA\)AAAffA=qA=qA\)A  AA(A֣AzA(A  AGAיAA(A(A33A֣AָRAAԏ\AӅApAA\)AGA
A{A֣AAAׅA  AffA  A  A
A  A{A  A{A֏\AzAAׅA؏\A(AظRAHAظRA؏\A؏\AAAA
=AzAծA
A{AӮAңAzAAA
ApA\)A33AԸRAӅA33AQAA(AAAҏ\AУAGA
AAHA(AхAҸRAиRAϙAAЏ\AzA\)A˅AAA
AυAAңAЏ\AϙAA\)AAУA=qA\)AңAHAѮAѮAУAAQA33A=qAGA(A
=AHA׮A׮AAA(A؏\AzAיAHAיA{A(A{AA  A{A(A؏\A=qAأAffA  AAمAAأAأAٙAAffA{AA=qA׮A֣A=qAԸRAA=qAHA
A
AΣA{AGAͮAAԣAAAׅAAϮAAAәApAәAԏ\AGAA{A׮AzAzAՙA\)AAAAHAӅA33AԸRA=qA
=A=qA֣A
=AיAzA
=AHAمA\)ApApAمAA  A  A{AAAAGAAAA  A  AffA{AAڏ\A33ApApAиRA33Aҏ\AAхAљA
=AzA=qAzAQA
=AAәA(AffAA\)AGA\)AGAظRAzA
=ApApApApA33AAHAAظRAׅAA
AיAՅAHAffApAHA33A  AظRAAAQAQAffA\)AffA\)A33A
AҸRAӮAGAAffAӮAљAA\)AzAәAָRAA  A
AљA33A(A{Aԏ\AAԣAAffAHA(A
AԸRAQAzA{AGAQAӮAffA  AffAԣAԏ\Aԏ\ApAApAAAAHAA{A{A=qAיA{AA\)AAA(AA(A
A
AAٮAٮAٙA\)AAأA33AظRA؏\A؏\A
=A\)A(ApAGA  AzAمAأA
=AA(AՙA\)A  AA
=AHAGA33A33AAApAәA(AA
=A֏\AָRAGAGAA׮AQAffAffAGA\)A
A  AffAHA\)ApAAQA{A{AۅAHA
=AffA=qAAzA33AA  AAQAڸRAڣAzA=qAA33AمA=qA\)AٮA33AAظRA33A{A׮AA
=A(AԸRAծA׮A؏\AzAأAA֣A33A
AQA
=AיAAzAHApAٙAAAA=qAffA(A׮A؏\A=qAAA֏\AGA\)AA
=A֏\A  A  AأApA
AQAڸRAAۙA  AܸRAHAAGA݅AݮA
A33A33AݙA݅ApAݙAGApA\)ApA{AݙAݙApAݙA݅AAAAQA{AQAܣAffA  AݮAAzAGAߙA
=AݮAݮA\)A܏\AAA=qAQAGAٮAۙAܸRA
AܸRAA
=AA\)A\)A
=AGAA
AAAAAQAA{A؏\AzAޣAݮA\)ApAzA33AA=qAܸRA
=AHA\)AٮAffA
=AۅAffAGAAޏ\Aޏ\AGAffAGAߙA  AHAAAA=qA=qAApA
=AAޏ\A޸RA߅AApAA
A  A=qA{A\)A\A=qAGA=qAAzAAQAGAApA(A߅AݙAA  AٮAڏ\A(A\)AAzA
=A܏\AܣAݮAGAA=qAޏ\AzA33AHAAڏ\A  AۮAHA
AHAzAQA  ApA  AzAHA
=A؏\AڸRA33A\)AGAڸRA{Aڏ\AGA{A=qAzAHAۙAGA
=AܸRAAݙAQAAAGApAApAffAHAGA\A߮AߙA߮A
=A޸RAA\)A\)A\)AA߅A߅A
AQAAݙAzAۮAzAzAAۮAAzA  AڸRAA  ApAGA(AAQA(AGAQA(ApAڏ\AٙAAGAAGAA֏\A{A{A{AA\)AۅA=qAיAA\)A  AAA
=A  AQA
=ApAffApA  A{A(AffAAAۙA  A{AA=qAܣAGApAAA33A\)A(AGAݮAݮAݙA݅AAA  AݮA
A(A(AffA޸RAݮA  A(AA33A\)A߅A\)ApAߙA߮A߮A  AQA߮AGAߙAffA
AQAAHAAA=qA\)A  AAיAޣAݮA\)ApAA{AApAGAQAAHApAԸRAAA(AAffAA(AۙA\)AۙAA33A
=AAHAޣA33AA=qAAAᙚApA\A=qARAA{AHA=qAQA\)AAݮAHAܸRAܣAۙA
AߙA
A߮AAA\AߙApA\)AAAAAܣAzA=qAAܸRAA\)A33AGAיAA33AمA  A܏\AAHA{A(AAAڏ\Aڏ\AڣA
A(AzA
=A\)ApA܏\A\)AGA
AA  AA  AۙAAAAARAARA=qA  AA߮AHA  A
AffAGA
=AHAޏ\AAA33A
AAAQA\)AzA(A=qA33AHAAAA߅AGAA
=AzA=qA{AAݙAAAGAAܣAׅA(ApA
AӅA(AӮAA(AظRAA֏\A  AAA
=AzAՙAA\)AAAA
=A  A{A=qAQApA  AAQAA  A33AAA֏\AA\)AffAAٙAffAA
AܣAA33AݮAݮA
AݮApA\)AA33AAܸRA33AHAGAHAAHAA33A
=AHAۮAۅAۮAA݅A(AQA
AۮAAGAڣAأAڣA(AAAٮAGAGA؏\AGAA\)AQAA{AAGA{A
=A
=AծA(AԣA(ApAQAzAHAأApApA  A{A(AA  AA޸RA  AGAHAGA
=AծApAHA33A=qA(AHAڏ\A\)AۅA{AܸRAHAA
=A޸RA(A݅AݮA  A33AGAAffAHA(A  A33Aޏ\A{A(A
A=qA  A=qA  AQA߅A݅AAAݙAffAzAܣAApA\)AA33AzAۙA=qA{AܣAHAٙA
Aڏ\AۙA
AAApA
=A֏\A\)A{AzAA
=A{ApA=qAQAHA{A\)A\)AۙAA(AՅAHAzAӮAGA  AծAיA  A=qA(A(AڣAAGApA=qAzA
=A=qAޏ\AffApA  AAAޣAޣA=qA
AAQA{A{A=qA(AApApAGAޏ\AAA
=ApAHAA\)A{A
=AAۙA
A  AffAGA=qAۙAAA=qAQAffAٙAAAأAA
AAzA؏\AA=qAA=qA\)AׅA=qApAمAHAApAAQA
AzAծA33A33AHAAңAffAAGAӅAA(AԸRA  A(A=qA֣AׅA׮A؏\AAڸRAA33A
=A33A
=AAڏ\A\)AAיAzAAڣA
AAӮAffA=qAGAAAHA
=AGA
A  A=qAمA(AHAԣAָRA\)AA
=AՅAzAӅA=qAԏ\A(A(AծA{AA
Aԏ\A\)AffA33AA=qAәA=qAAәAҸRAиRAAGAӅAzAAՙAAA  AffA  A
=AA=qAԣAԸRA=qAԣAAԏ\AQAQA=qA=qAzAAָRA֏\A33A\)AׅAיAffAAAAQA܏\AAApAՙAzAԣAAӮAУA  A
AzAHAָRAAffAՙA(AӮAffA\)AA
=A33AՙA
A؏\AٙA=qAQA֣A\)AHAԏ\AA
ApAΏ\A=qAzA\)A\)AGAQAQA(A  AA\)AffAծA(AAAAңAQA=qAAAՅAGA33AׅA׮AׅAHA֣A  A33AA=qA=qAHAAٙAAAHAܣAA(A
A(Aޏ\AzAޣA\)AޣA
=A޸RAffAA݅AffAGA
=AAܣAظRAңAA33A֏\A=qAٙAQAڣA=qA(AظRA{AAԣA
AٮAQA{Aڏ\A\)AۙA=qAffApAҸRA(AAHAA  AGA؏\A(AٙA33AAڸRAA=qApAA\)AAGAHAGA֣AՙA\)AӮA=qAQAA\)AAffA33A33AӅA(AָRA{AAمA  AffAٮA(AۙAffAzAzAQAۙAۙApAGA\)AۮA\)A
=AAAGAGAA
AظRAQA\)A
=AڣAffAڣA
=A33AڸRA
AָRAQA(AمAAָRA33A\)AיAׅA{AA
=AٙAffAAٙA\)AڣAڏ\AAApAظRAA33A  A׮AHA\)A֏\AA  AAAApAڏ\AGAڸRAڣAAۅA33AGAAA\)Aڏ\A33A
AأAڣAڸRA\)A
AGAzAAڏ\AۮAA=qAAA؏\A
=AffAAظRAAAAAمAHAڸRA=qA
A{A
AApAAAمAAGA  ApAffAمAApAأAAffAA؏\AHApAGA{AأA׮A33AظRAQAأAA\)A{A  AׅA؏\AA
=A֏\A(AAծAAAՅA{A=qAAָRAָRA{AA=qAHA  AծAԏ\AAffAQA  AأAظRAGA
Aڏ\AHAAQA
A׮AׅA׮ApAՅA
A֏\A֣A{A{AAAمA\)A\)AQAAffA\)ApAAGA
AA33A33A
=A(AA
=AGAGAA
=AGApA\)ApA  AأA  AffA=qA=qA=qAAAظRAGAzAAzA؏\A33AA=qAQA=qA(AԣAHAGA=qAzA{AQAQAӅAѮA\)A33AffAA=qAffA֣A
=A
A
AԣAGAAיAָRA(AمA{A{AׅA=qApAA{ApA֏\A=qA
AffAՙA
A=qA33A{AAAQA=qA
A=qAڏ\A
=AHAۮAۮAHA(A\)AAܸRA
A  AGA{AۮA  A(A33A
A=qAٮAA  AA=qAA{A=qApA{AA(AffAA{AQA\)A\)AAAՅAQAzA֏\A\)AHAHAAA33AAA  AzA{AAأA33A  A33A
=A{A  AAܣA{AHA33A(A{A=qAAۙApAGA
=AAQA(AQAٙAffA  AffAAAAQA
A  AHAۅAHAAAAڏ\ApAۅAAAڣAffA{AQA  A{A{AAٙApA
A
AA  A{AٙAAHA{AمAٙAٮA  AԸRAffA33AծAA33AAzAٙA
AHAAAA֣A33AzAأA\)AffAظRAAA
A׮AHAA  AA=qAAQAԏ\Aԏ\ApAzAمA؏\AיAAHA=qAٙA؏\AHA33AAڣAڏ\A
=AA׮AGAA{A֏\AA\)AԸRA\)A
Aԏ\A(A{A(A  A=qA  A=qA  AGA=qApApAЏ\AzAAGA  AӮAAУAffAA(A
AGAAQAA  AGAA33AQAHAAGAzA=qAՅAAHA=qA=qAҸRAAGAәAAAAAңAffAAңAAGA\)A{AzAԸRA33A33ApAՅAHAԏ\Aԏ\AzAQAԣAAԣAԏ\A
AљAAzA
=AffAQA  AAӮA\)AҸRAҏ\Aҏ\Aҏ\AҸRAGAHAffA(AAAAA(A(A  A\)A
=AAAЏ\AЏ\AυA  AЏ\AAиRAGA
A\)AиRA\)AиRAA
=AGAA
AzAӮA
AAzAԣAHApApAzA
=AGA{AffAffAיAA  AApAQAzAzAHAAA33AՅAAAAҸRA\)AӮA
=A33AAGA\)AAAәAAAՙAԸRAA
=A=qAѮAҏ\AϙAυA
=AA˙ApA  AƸRAǅA
A  A  A{ApAAA(AA\)A
=AffA{AAAAAAffA\ARAzARAHA(AzAA
=A33ARAAGAHAAQAA\AA  AHAA\AA
AffAAA\A  AA{A{A\A\)AřAGAffAǅAQA
=A33AGAAGAzAApAA33AffA33A¸RAQA=qA
AA(AA
A33A
AA
=A
=A£AÙAAzA\AAAHA  A
ApAAAGAA(AA
AAApAA
AA  A
AQAA=qAAAAA{ARAAAGAHA\)AřA
A
AA=qA(A{AHA
=AHAA=qA{A33AAGA
AQA=qA˅A  AzA¸RA
A(A(AAAAA{AApA\)AAAA=qA  AAGAGApAAApARA{A
=A  A£A\)AHA
A\)AAA{A(A(AA
=AApARAA=qARAAAAQAGAÅAzAHAHA(AAAQA33AA
AQAAHAîAAĸRAď\AģA
AA
=AA\AA33A  A
A
AřAHAApAģA=qAĸRA{AffA  AffAzA£A33AAAHAGAAîAǙA{AAGA¸RAAA
=A33AřApAȏ\ARAAAQAzAA
=AAARA(AAAGAA\AQA{A(AHAAARAAA{A
AApAA\AGAA33A
=AHAGAHA{A¸RAHAHAHAzA{AAAAAzAA˅AAʣA  A(A
AɮA\)AzA33AGAQAʏ\AffAʣAAŅAHAɅAɅAɮAŅAA33AA{AA̸RAA=qApAA
AĸRAAAGAƸRApA=qAA33AɅAƣAffAʣAA33AGAîA33AAAAƣAĸRAď\AffAĸRAAHAA
=A\)AĸRA
A(AGAA\AQAŅA=qApAAAA£AGAîAA33A
=AŅAffAGA
AAA  Aʏ\Aʏ\AʣA\)A  A\)AGA̸RAQA{AA
A˙A33AAʸRAzAffA=qA{A  A=qAA\)AAȣA=qAAǅA͙AAHAQA{A=qA(Ȁ\AAʸRA33AHA
AˮAˮAʏ\A\)AǅAȀ\AͮA33AAffA33AřAA33A=qA{A
A{A{AQAHA  AÅA\)A
=AAď\AAȏ\AȣA˅AAʣA(AAAA\)A{AffAȣAAHA=qAΣAzAЏ\A(A
A\)AӮA33AAәA{AQAҏ\A
A
AхAиRA33AAЏ\AAУApAͅA\)AθRAzAϙA\)AAAAGAffAˮAffAA͙A
=AҸRAGA
=AәAQA
AAиRA
A(AυAAͅApA{A̸RAAͅAẠA{AͅAAəApAȏ\AzA33AffA
AAȀ\AAʏ\AǮA33A=qAAzAәA(A\)AffAԸRA=qA  AхA
AԣA֏\A
AAHA33A33AأA{A=qAffA{AA؏\Aڏ\AمAA
A
A=qA\)ApAzAQAAظRA  A֏\Aԏ\A{A
AQAҸRAffA  AӮAffAӅAAGA
A(A
AffAA
=A\)AApAԣAGAA
=AzAҏ\AAA=qAA  AzA
=AA
AA33AGAAQAљA=qAffA{AApAљAA(AA
=A
=AHAzA33AzA(Aԏ\AAAA
=AApA
=A33A  AAffAAA33AיA
ApAAיAׅA{A\)A׮AA33AzAffA(AzA
=A33AͮAAϙAӮAAΣApAA{ApAGAӮAAУAΏ\AzA˙A{AŅA
AA  AģAQA33A33AffApAGAQAŮA
=AffẠAAzAϙA  A
=AAͮA
=A  A33AzApAQAA=qAzAA{A˅AQAA  AʸRA
=A
=A=qA˙AA
=A
=AGAffAأAظRAffA=qA
AAׅAGA33A  A
AAՅAA(AzAzAQApAAҸRAffA  A\)A
AAHAzA{AA{Aď\AA
=ApAAAApAQAAǙAA33AŅA
=AəA(AQA
=AЏ\A
=A=qAA  AHAAʏ\AQAȸRApAAAHAAQA=qAAîA
A(A£AÅA
=AApA(AAģA33A
AGAĸRA33AA\)A
=AAARARAGAAAA(AGAffAA
AApA\)AĸRA{AîAAîApAÙA=qA(A33A\)AAď\AAŮA  AzAA\)AŮApAHA(AƸRApA  A
=AHAGAAffAAģAď\AGAŅA
A
AA=qAffAAffAÅA=qApA  AAA£A¸RAHA(AîA\)AAAGA
AHA\)AHA{A\)A=qAŮA£AAHAɅAƸRAAGAAzAzA
=Aȏ\A33A\)A
AffAffAffAzApApA\)AzAffAffA33AǙA=qAǅAǮA  AAǅA
=AHAAǮAɮA̸RAAAGAA\)AA
A(ApA  A˅AʣAzAQA
AɅAAȸRAAAffA{AǅA\)AAzAAzAʸRAzAȏ\A(ApA\)A
=A  A33AA=qAQApApAǮAəAAȏ\AHAA
AAffAŮAA
=AGAʣAA=qAǮAApA  A{AQAffA˅AˮA͙AHApA
=A{A33AˮAGA
AA{AzAϮAθRAffA{A  A\)ẠAzA\)Ȁ\AˮA=qAͅAͮAzAθRAGAθRAΏ\AHAAzA  AGAͮA
AͮA͙ApA
=A=qẠA
=A33AzA=qAϙAAHAAͅAA͙AA\)A=qAУA͙AAzA=qAHA33A
AͮAθRA
=ApAAϙAυA͙A  AzA\)AA͙A\)ApApA=qA\)A
=AAAA
=AffA=qAA33AAA
A{AQA{AͅAHAzA
AzA  A=qApA(A33AAAffA
=A
AӅApAzAҏ\A
Aҏ\Aҏ\AәAGAӮAәAGAϙA
AAхAzAA
=Aҏ\AA=qAӅA=qA33AzAffAA33AԸRAӅAѮA\)AθRA
=AϙAzA\)AAA(AϙAQAffAffAAΣA
AљAAΏ\AΣAΏ\AzAͮAΣAHẠAAHA  AApA33AЏ\AHA
=AA(AңAѮAAԏ\AՅAAЏ\AҸRA33AӅAffAЏ\AУApAϮAυAAΏ\A\)AA  AхA  A{A=qAͅAͮAA
AͅAAA͙A  AͮAͮAͅAẠAAӅAAA  AAHAϙAϮA͙AυA33AzAGAzA  AAѮA(AѮA
AffAApAљAΣAzAzAzAAQA
=A
=AA\)A{ApAA(A˅AApAΣȀ\A=qAQAA=qA˙A˙AAAHAGA  AʣA33A  A33AHA\)AϮAA
A
=A{AӅAA=qAAA\)AQAظRAGAمAAffA  A  AGAzA=qA{A
=AA\)A  AA33AAzAApAA  AQAAHA=qAׅAAA33ApApAAAQA  A=qAA{A{AA(A(AQAأAיA=qAיA׮A(A֣AGA  AQAAAϙAυA  A
A
AAAHA̸RȀ\A  AzA33AљAЏ\ApAЏ\Aҏ\AAиRA=qAA{AQAՅA(AA33AA{AffAzA=qAAۮAۮA
A  AffAzAۮA=qA  AzA=qA33AQApAָRA
=A(AծAAAAAAA33A  AمAأA{AأA
=AQAأAظRA؏\AffAAAAQAzAA  A  A{AQAHAAffA֣AA֣AәAԣA\)AGAծA33AQA=qAԣAAӅAљAЏ\AυAA(AffApAAAHAQA
=AAθRAAAGAAA{AA(A֏\A֣AA=qA{A
AծA\)AՅAծAՙAAQA֏\AzA֏\A
=A33AՙAԏ\A\)AAzAA\)AѮAffA{A
=AzA
AՅAHAAGAA33AAAA=qAGAԸRA֏\AՅAA=qAԸRAAAQAAԣAAffAԸRAGA  AQAԏ\AQApA(AzAљA\)AA(ApAУAϙAA{A
=AՙApAHAffAA{AGA  AzAffAУApAҏ\AAAAApAҏ\AHA33AәA
AәAApA  A{AԸRAAA=qA=qAQAzA֏\AָRAAAHA֣A֏\AAQAQAzA{A=qA(A=qA֏\ApAָRA
=AHAAAzAԣAԸRAAffAиRA  ApAzApAQA(AffAAՙAAԸRAQA(Aԏ\AzAzA
A
A
ApA\)AQAAυA
AΏ\A=qAffAA
AA
=AA
=ApAQAԣAҏ\AңAzA
=A\)A{AЏ\A{A33AzAAӅApAQAAAA
AGAAԏ\ApA
=AGA\)AәAzAA(A(AffAAHAәAAљAffAzA\)AQA(AՅApAzAQAѮAAApA(AϙA{AәAHAӮAԣAffApA
AЏ\A
AəA33AAGAυAA֏\AՙAԸRApAԣAQAzAӮAәA\)AЏ\A
=AAAQAApAƏ\AHAA͙AffA͙AHA\)A{A{AzAffA
=AҸRAхAҏ\AәAzAA  A  AffA֣A  AAQAָRAָRAA(AָRAffA(AծA33AQAAԏ\A
A{AңAAA
=AңAzAAAAԏ\AA
=AәA  A  AA
=AυA33AA(A
=Aԏ\A
=A  AGAAA(AA(AQAzAAQA{AӅAzAApAHAQA
=AQAУApA{AzAυA
=AzA=qAHAGAAAA=qAAGA{AAљAҏ\AAA
A  A(A=qAԣApAAGAAՙAAA
=Aԏ\Aԏ\AApAA
AӮAQAAQAAAԏ\AzA33AAzAхAљA  AA
=AϮAHAffA=qAzA33A  AAAϮAA{AͮA{AхAzAzAffA{A
AAQAңA
=AAҸRA{A33A  AHAffAҸRA\)AѮAzAԏ\A
AzA\)A33AzA(Aҏ\A
A  AљA=qAҏ\AffAHA=qA{A33A\)AʸRAGAA˙ApA{A\)A33Aʏ\AA(A˅AʸRAAQAA͙AͮApAẠA33A(AA  AAAQAAA˅AA  A  AʣAAHAAGAʏ\AGAəA\)AŅA=qAGA(AAAģA
AAǙAA
AǙAAƏ\AQAzAffA=qA
=A33AAA\)A\)A\)A33A\)ApAƸRAAGA
=A\)A  AzAʣAA
=AGAɮAɮApAȣAAǙA=qA=qAȣAA{A{AŮA{A=qAƏ\AAA33A
=AAǮAƣAƏ\AŮAQAřAƣA
=A=qAǅAǮA(AHAffAA33AzAApAǅAQAƏ\AA
=AHA=qAA\)AAAffAA\)A33A
=A
AHAǅA=qA  A33A
=AîAzAA
=A=qA
=A\)AAzA=qAzAǅA(AzAGAA\)A  AģAzAffA
=AA  A=qAAHAƣApAƣA{A
=ẠAA
AA=qA{AΣA
A{AAHA(AϙAHAHApAApA=qApA(A{A\)AͅAHA
=AAffAAHAGA33AA
A33AˮAA̸RA\)A̸RA(AHAHA{A͙AA(AA\)AAGA͙ApAAGAQA{AƏ\AȣA\)AAA
=AGA(AHA(AzA{AAffA(AȸRA{AĸRAŅAA\)A
A
AzA
=A(A˙A
AffAAA  A  A=qA  A  AzA33A33AθRA33AAAA=qA=qAɮA\)AɮAAAəAzApA\)AȀ\ẠA  AzAzAʣAffAɅAHAʏ\A(A˅AGAGAA33AGA˙AA  AˮA˙AzA˙AAAzAA
=AAffAzAAGAGA33A  AHAAǅAȏ\ApAQAAɅAAHAGAAffAAAffAȏ\Aȏ\AQA
=AGApA  AApA(AffAHAAzAϮA(AͮA̸RAffA  A\)AA
AHAŮAQAA
=A  AAAApAA\AGAA(AApA(AffAQA  A(AͅAУAʏ\A  A\)A=qApA=qAȸRAʏ\AȣAȣAȏ\AAA=qAAAAȣAẠA˅AΣA
AAA
A33A˙A  A
AA˅AͮA33A  A(A(AϙAϮAυAAA  AQA=qA  AΏ\AθRAΣAzAQA(A(A(A{A  AˮAA
AǮA{A=qAȣA\)AɅA33A{AffApApAAffAA33AȸRAAAAƸRA
=A  A
=A(A
=A
AzAAApAA  A(AQA(A̸RA33AʸRApAɅAzAȣAȏ\AȸRA  AǮAǅA
A33AƣAAȏ\A{A(AA{A{AQA
=ApAQAzAAGAˮAQAA{AAẠA  AAA̸RA
=AQAQA˅A=qA  A
A  AffA33ApA
A
A{AffAHAA˅AffA
AAQA\)AzA33A˅AA{AAzAʣAʏ\AAA\)AɮA{AQAʸRAzA
Aȏ\A̸RAHAɮA33AGAAA=qẠAHAQA̸RA̸RA=qAzApA{AHA=qA\)AGAzA{AǙA=qAȸRAffA\)A(AA\)AǮA(AA  AȸRAAA(AʸRA˙A  AzA
A  A=qẠAffAzAzA=qAffȀ\A̸RA̸RAAAA̸RA̸RAA
=AA=qAəApAHAGAŅAffAĸRA\)A\)AɅAƸRAAAAQA{AAAAAAQAȏ\AzAǅA\)A=qAȸRAGAɅA\)AffA  A  A  AAǅA{AAQA  AffA33AffA{AŮAAffA£AffAA\)A\)AA(AîAffAQAĸRApA\)A
=AĸRA(AA
=AApAəAAȏ\A{A(A33AA33A
=AAAffAAAǅA
A  AǅA\)A\)A{AŅA  A  A{AQAAAŮA\)AĸRAď\A{A
AîAHA¸RA\AQA(AA
A
A{A{AA
A=qA  AĸRAA
=AAApA\AAGAA33A{AA33AQA
A=qAffA33AQA
AĸRAA33AîAQAA\AA=qAQA{A{AQA33AA
A  AffAAA
=A(A¸RA\)A
AQA=qAîAA=qAffAď\AzAffAď\AffA=qAApAAAA
=AA(A
=AA=qAAAAQAAzAQAffAffA{A=qA(A
AA{AGA\)A  A
=AAA\AQA=qAzA=qAffAAAAzA\)A£AzA\AAA{AA(AffAAA\A
AA
A\AA  A=qA{AA{AHA=qAAAA33A
AA
A
=A(ApAHA\)AAAQAzAApAffAA33AGAzAQAAQA\)AzA
=ApAA33A33AzA(AAA  A  AGAQAffAffAQARAA
=A\AAzAzAGA33ApA33AA
A
=AHAA  A  A33A\AQA\)A  A33AzARAAHA  A{A{AA  AHAA  ApA{AAA
=A
=A
AAHA{A{AQA{A  A(AAQAAAA=qAzAA
AAAzA33A
A33A(AffAQAAAHA{ApA=qApAAAAAzA\)ApA{A\A=qAAAHAHApA  AHAApAAQAQA=qAAQA
A¸RA=qA  AA£A=qAQA(AAAA(AAHAAA\)AA
A
A  A=qAQAffA{AQA=qAQA{AzAAHA¸RA
AA  AA\)AQAHA=qAQAAAGA{AAffAffA
ApAA  AHAHA(A
A33AA\)AffA33AHAAA=qAAffA  AA\)AAAAARA\A\A
AQA=qA{AQA33A\)A(AAzAAA
=AARAA{AA33A{AA
=AA\)ARA\AHAAQAAGA
=A
ARApA=qAA{AA33AA(AffAAAAA33A
AAA\AAAffA{AA(AzAzAAAffAHARAA\)ARA
A33A  A33A\)AAHAA\AAAARA
=A\A(A  A(AffAAAHAQA=qAffAAHA=qA33AAA\)AA
A33AA=qA33A\AzAA
AAA{ApA\)AApAAA\)A=qA=qAGAA\)A  A=qAHA(AAzA\AAA
AffAA\)A=qA
=AARA(AAA33AHA  A33AQARA33ApAAAA=qAAAA
=AffA\AAzA
=AApAAA
=A\)A(A\)AAA33A\)A\)A
=A(ApAAGAAHAzApAAAA(AA\AA  A\)AA
AAAA33AAQA\)AAHAAAAAA33AA\AzAA
=ARAAAffAApA\)AQA
AAQA{A(A(A=qA
=AAAAAffA{A
AffAApAffARAA
=A
=AAAAAzAAQA
AAHAA
AA
AA  A(AAAAGAAAA  A
A  A
AffAAAGA=qA33AGAA33AAAHAffA
AAQARApA(ApAHAAAAAGAzA33AA\AzA  AAzAHAAAAGAA33AAHAA  A\)A
=A=qA{AAA  AHA\AAAARAAzApAA  A33A(A(A\AQAAAQAAffA\AAAQA\A\A(A=qAAA\A{AA=qA\A\)A=qAAQA
=AAApApAA\)AA
=AAAARAffA\)AARA
A\AA(AAA{A\A\)AARAzAAGA
A
=A
=A
=ARAAzA(AAAA  AA{A{AAffA
=A=qA=qA  A\ARAAHAA(AAA{AA\A{A=qAA
A(AAA  AA(A\)AGAA=qAzAQA33A(A(A\)A33AffAApAGAQA\)AAAAA\AA33AA=qA
=AA=qARA
=AQARAAffAGA\)A
A(A\AAAzApApAAQA(A(A33AzAAGAAA=qAHAAAQA\ARAzAARA
=AAAA33ApAffAA  AGA\)AAA=qARAGA\AHA\)A
AzA(AA(ARAzAAHA  AzA
A\)AffAGAAGA=qA
=A
=AA{A
AAQA\)ApA\)ARAAA
A\)A
AAffA(AffA  AHAAAAAAAA33A  A33AzA  ApA\)AAAAAA33AAApAffAGApAHAHA  AA{A  ARA  A  A
AzAA33A{AHAA(A(AGAGA\ApAAA(A33A(AA\A\)A=qAAzAAffAAA
A  AGAA
ApApA(AzA=qAAQAzA\)A
=AA(ApAAAA  A(A  A=qAffA\A=qAAA\AHApA\AA{AA\)A33AHAGA\AA=qAzA\A
=AAAHAzA{A33A{AGAGARApAAzA\)AQA
AHAAGA(ARApA  AAGA(AHAHA33AGAGAzApAffAffAAQAAAAQAzAA\)AGAA
=AA\A33AAQAQARAA  ARAARAAGA=qAA\)AARA  AHA
=AAA33A\)AzA
=AA  ARAA33AAA33AGA  AHAA
=AGA{AAffA  A
AA(AzAQAHAApARAffA  A(A
=AA
AffAAffA
AA(ApAAAAHAAA(AAAAA\AGA\A=qAA\ARAA\)A(A\AA
AzA{A
=AAŮA(A\)AGA{AÙAîA¸RA  AzAA
AAffA=qAď\AƣAffAA
=AAA
A=qAApA\A{AffApAAA\AA  AHAAQA
=A¸RAÅA  AA
A\)A33AA
A33A{AA{A
A
=A(ApAAAAffAAA  AAA\)AƣAHA(AAÙAGA
A
A33AzAA33AQAA
=A\AHA=qAAA  A
A¸RAHA
=A  AAHA£AHAAGA¸RAA  AHAffAA\)AÙA£A33AA
=AzAHAAAQAAA  AHAARAA\)AAAAAA
=AAGA{A\A¸RAGA\AAAAAAA\)AÙAAHAA\A33AAffA  AzA
=AGAŮA(A=qAƏ\AA\)A
A{AAzAGA33A{A\ARA(AHAÅA
AARAGA\)AA
=A\)AA33AzA{AffAzAffAzApAQAA
AAģAHA\)AffAAA=qA¸RAAQAA{A£A£A\A(ApA{AAÅApAAffAĸRAzA=qA
=AģAAŅAŅAGAAzAAAGAAAAffA33AA
=A{AƣAA\)AAQAA33A(AŮAď\AffAAQAA  AAÙAA£A33AA  AA\)AA33AAȏ\AGA¸RA=qA(AzAA  A\)AA  AHAAŮA{AQA\AzA{AAAɅAA
=AȸRAǅA=qA(A\)AȣA=qA  AA{A
=A
=A(AAȸRA(AA(A(ApAA£A¸RA33AAAzAģAAĸRAffA\)AzAĸRA{AAffA{Aď\A(A  A
=A33A\AA\)AQAHAA
AAGAAA£AAQAQAARAAŅAǮAQA  A(AA\)A\AzA
=A(AHAGA=qAřAffAAAAAAQA
=AGAzA\)AŮA33AHAřAAŮAŅAŮA(AîAÅA\)A{A
A(AřAřAA33A\AGAAffAģAAÙAAAA
=A
=AQA{A=qAď\A=qAA{AHApAAGARAA{A=qA33A=qA\)A\A(AAA{AA=qAA33A(A33AzAGA=qAAA
AA
=AffAHA
AA\)AAAGAApAA
A=qA
=A  AAA33AQA{A£AîAQAAGAHA
=ApAîA\)A  A33AA
=AA33A{AAA(A{AGAffAA=qAGA  AzAA£A\)AApA
=A
=AA(AAA(A  AA  AAHA\AzA33AGA\)A\)AA{AffA=qA=qA{A(A{AAA{ARA33AHAAAGAAA  AA
AA
A\)A{AAQAAA  AGAAQA  AAzA{A33AHAA\)AApAAAAAAAzA{AARA{AA
A\)AAAARA
AApAARA
=AAAA
=ARAHAzAAQA\)ApA  A\A33AA(AA
AAQA33AAA
=AHAAA
AGAA(AAGAGA\)AHAffA  AAffAA(A
=AAAGA
=AAQA\AA\)A{A=qARA
AA33A33AA(AA=qAAAA(AAAHA=qA\A  AQA(AAHAAQAA33ApApA=qAAAA
AzARAAA
AA=qAffAA\A\)A
=AApAA\)AQA\A
=AAffAQAAAQA{A\)A¸RA=qAAzA(AAzA\AÅA¸RAffA\AA¸RAA£A{AAA{A  A\)AAAA\)AGAA\AA(AA=qAffA{A{AA{AA{AHAA(AA
AAGA
=A
=AHAGAA\)A
AîA=qAzAffA  A\)A\)AAffAGAGAAA(AřAŮAŅAzAAAGAzAHAƸRAAAŮA(Aď\AŅA{A  AAÙA
=AzAQA\)AA
=AzAzA33A¸RAffA33AÙAGA
=A(A33A
=AAAAGAzA
=ApA{A\A(AffAffA  A(AAA£Aď\AģAĸRAAģAAARAAQAÙA{AA33AA(A=qAHApAAA{A33A  A=qAŅAAHA
ApA{A
=AffA
AzAģAA33AřAĸRApAAzAƸRA\)AřAAAAAřAřA{AŅApAřApA
=AAHAAQA
=AQAzAHAffAŮAď\AřAŅA=qAŅAQA
=AHA33AŮAŅAŮA=qAřA
=A
=A
=AAA=qAAAAřAģAřAA
=AHAzAGAŅAAAffAŅAAHA\)AQApA
A=qAGA(A33AA=qAzA=qARA{AA\)AAîAGA{AQA{AzAîA33AA33AAGAAApA33AA(AÙA33A=qAQAffAffAffApAA
AGA(AA
A  AA(A{AHAzAGAHAffA
A33AffAzA33AGAÙApAAÅA
AAffAîAHApAQA
AAQA  AHAAGAĸRAAAÙApAÅAÙA  A=qA{A{A£A\AAA{AQARAA
=A\)A=qAAA
AffAAA\)A
AA(AAAA
=AzA{AGA(A{A=qA(AApA
A33AzA
AAA{A=qAQARAAAA=qAAAAAA33AAA\A\A\)AHA
=AAA\A\A\A\AQA  AA=qA(AQAAA\)AGAAQA\)A=qAAAAAA  A  A  A{A(A{AQAzAARAAAzAHA33A
A  A  A
=AffAApAHA
AQA\AARAAffA=qA
A33A
A{AA\AAA
AA\AA
A=qAAApAAHA\AHAzA{A\ARA(AA
AAQAAAAQA  A=qAzARA
=AA  AffAAAGApAAAA33AAAzA=qA(A\A
AzAARARAzARA\AA=qA(AzAA
=AAGAA
=A\AffA  AQAA{ARA\A{A
=AApAAzAAAffAffAARA\ARAAQAHAA(A\AHAHAApA{AAAA33AApA\)AHAAffAHAAAAA33A
=AAAQAA33AGA=qAApAGAAA  ARA{AA=qAAA{AffA{AzAffA\)A{AA
A\)AzAGA\AAAHAzA=qAAA{AGAAA33AffApAAHA33AAzAAAARAHAA
A\A(AA33AQAAzA\)A{A\A33ApA
A=qAffAA33AA
A{A(A
AAA{A\AffAAApAQAffAQARA\ARAAffA\ApAAAA
A
=AAzAARA{AGAAffA\)AGA(AAHAHAA(AAQARARAA
=AGApAHAA=qAA(A\AAARAAAAAAA\AffARA
=AAQA33A33AAzA  A{A  ApA  A  ApAA\)A33AAîA
AAAAQA(AA\AAAA
=A£A  A(AA\)AA=qAQAAGA
ARAQAAAA£AAffApA(ApAAAzA  AzA{A{A\)AzApA\A(AA\AGAAAA(A£A(A(AA¸RA  AApAA=qAAAffAHA33AA{AAď\AAřAffApAA
A{AffAȸRAȸRAAAHAzAffAQAȏ\A=qA{A  AǮAAQA{A(AŮAffA{AAA{AĸRA  AA33A
=AApA33AGAAAƣAffA{AAŮAGAAffA=qAA
=AGA33AAAřApAHAQA£A33AîA
=AA(AzAzA£A\AA\AAGAÅAîA
AffAĸRAAģAQAA
A{A
A\AA
=AffA  AŅAQAA{AAřApA
=A  AƏ\AAřAAHAffAƸRAQAzAzAƏ\A=qAzAAAffAAzAƣAffAQA{A  AHAřAHA33A{A
=AAGAQA  AŮA(Aď\A(AÅA\)AHA{AAAGAHA(A{AGAŅAQAzA  AřAŅApA33AAQA(A=qA  AGAHApAAŮA{AģA
=A
AApAA33A\)AÅAGA(A33AAA\AQA(A£A\)AÅA
=ApAď\AĸRAĸRA
=A\)AŅA
A{AQAAzAzAA
=AĸRA  AffAƸRA\)A33A
=AHApAHAffAǅA=qA=qA{AffAƣAǙAzAAffAHA33A¸RAARA\)AQA\A
=A£A\)A\)A33ApA\)A=qAŮA{A{AzApA\)ApApA=qAA\)A{A
=AA33AGAAffAzAA{AAA  AA  AHAď\AĸRAď\A33A{A{AApApA
A=qA
=AģApAƸRAŅAřAřA=qAffAffAzAzAzAQAQA  AHA{AģA
=A\)A
AffA
=AAď\AĸRAffAffAŮA{AQAffA  A  AQAQA{AzAǮAHAAȣA  AzAȸRA  A(AGAƣAApA
=AǅAAAQAffAƣAA{AîAA
=A33AQAŅAAGAffA33AGApA=qA33AQAHA\)AAGAAHAGAQAîAzA=qAHA\)AAQAHAGAîA  A=qAffAĸRAHA33AGA\)ApApAApA\)ApA33AAHAģA33AffA\A
A
A{AHApAffAAzApAAřA
AffAHA=qAzA\)AARA{AA\)AA
AzAÅAAQA{A{AffAAA=qAAQA\)A
=A\A{AHAAAAAzA33ApAHA{A
A{AHApAÙAA
AřAřA
=A33A
AƸRAǙA33AAƏ\A\)                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                             