CDF       
      
timeseries        obs   x7   station_name_strlen       platform1_strlen      instrument1_strlen     +   
crs_strlen     	      _   acknowledgement      BThe Pacific Islands Ocean Observing System (PacIOOS) is funded through the National Oceanic and Atmospheric Administration (NOAA) as a Regional Association within the U.S. Integrated Ocean Observing System (IOOS). PacIOOS is coordinated by the University of Hawaii School of Ocean and Earth Science and Technology (SOEST).     
cdm_data_type         
TimeSeries     cdm_timeseries_variables      (station_name, longitude, latitude, depth   citation      Citation to be used in publications should follow the form: "PacIOOS. [year-of-data-download], [Title], [Data access URL], accessed [date-of-access]."     comment       :Data produced by Dr. Steven Colbert (colberts@hawaii.edu).     contributor_email         jadolf@monmouth.edu    contributor_institution       Monmouth University    contributor_name      Jason E. Adolf     contributor_role      
originator     contributor_type      person     contributor_url       8https://www.monmouth.edu/directory/profiles/jason-adolf/   Conventions       CF-1.6, ACDD-1.3, IOOS-1.2     
creator_email         colberts@hawaii.edu    creator_institution       University of Hawaii at Hilo   creator_name      Steven L. Colbert      creator_type      person     creator_url        http://www2.hawaii.edu/~colberts   data_center       0Pacific Islands Ocean Observing System (PacIOOS)   data_center_email         info@pacioos.org   date_created      
2010-10-23     date_issued       
2013-05-12     date_metadata_modified        
2022-11-14     
date_modified         
2022-11-14     defaultDataQuery      ^time,temperature,salinity,turbidity,chlorophyll,oxygen,oxygen_saturation&time>=max(time)-3days     defaultGraphQuery         2time,temperature&time>=max(time)-3days&.draw=lines     distribution_statement       PacIOOS data may be re-used, provided that related metadata explaining the data have been reviewed by the user, and that the data are appropriately acknowledged. Data, products and services from PacIOOS are provided "as is" without and warranty as to fitness for a particular purpose.   Easternmost_Easting          featureType       
TimeSeries     geospatial_bounds         POINT Z (19.7341 -155.082 1.0)     geospatial_bounds_crs         	EPSG:4326      geospatial_bounds_vertical_crs        	EPSG:5829      geospatial_lat_max        Ap   geospatial_lat_min        Ap   geospatial_lat_resolution                geospatial_lat_units      
degrees_north      geospatial_lon_max           geospatial_lon_min           geospatial_lon_resolution                geospatial_lon_units      degrees_east   geospatial_vertical_max       ?     geospatial_vertical_min       ?     geospatial_vertical_positive      down   geospatial_vertical_resolution               geospatial_vertical_units         m      grid_mapping_epsg_code        	EPSG:4326      grid_mapping_inverse_flattening       C    grid_mapping_long_name        coordinate reference system    grid_mapping_name         latitude_longitude     grid_mapping_semi_major_axis      J¥2   
gts_ingest        true   history      2010-10-23T10:00:00Z UH-Hilo deployed (J. Adolf).
2013-05-12T00:00:00Z PacIOOS asset.
2017-01-25T00:00:00Z QARTOD QA/QC implemented.
2017-09-01T00:00:00Z Steven Colbert assumes wqb_04 oversight.
2019-07-16T19:00:00Z Buoy replaced after Hurricane Lane.
2021-03-08T00:00:00Z NetCDF variables station_name, platform1, instrument1, and crs converted from int to string and now contain respective data values.
2021-07-23T19:11:00Z Change QARTOD variables "units" attribute from "0" (invalid) to "1", per CF conventions for unitless variables.
2022-04-15T20:30:00Z Buoy repaired and refurbished. Data now report every 30 minutes rather than every 15 minutes.
2022-11-14T19:33:00Z Dataset identifier modified from "WQB-04" to "wqb_04" to satisfy future ERDDAP requirements.
2022-11-15T19:17:15Z http://pacioos.org
2022-11-15T19:17:15Z https://pae-paha.pacioos.hawaii.edu/erddap/tabledap/wqb_04.ncCFMA?&time%3E=2020-01-01T00:00:00Z&time%3C2021-01-01T00:00:00Z    id        wqb_04     infoUrl       1https://www.pacioos.hawaii.edu/water/wqbuoy-hilo/      institution       0Pacific Islands Ocean Observing System (PacIOOS)   
instrument       In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Fluorometers, In Situ/Laboratory Instruments > Chemical Meters/Analyzers > > > Oxygen Meters, In Situ/Laboratory Instruments > Conductivity Sensors, In Situ/Laboratory Instruments > Photon/Optical Detectors > > > Turbidity Meters, In Situ/Laboratory Instruments > Profilers/Sounders > > > CTD, In Situ/Laboratory Instruments > Temperature/Humidity Sensors > > > Temperature Sensors     instrument_vocabulary         GCMD Instrument Keywords   ioos_ingest       true   ISO_Topic_Categories      oceans, environment    keywords     :Earth Science > Oceans > Ocean Chemistry > Chlorophyll, Earth Science > Oceans > Ocean Chemistry > Oxygen, Earth Science > Oceans > Ocean Optics > Turbidity, Earth Science > Oceans > Ocean Temperature > Water Temperature, Earth Science > Oceans > Salinity/Density > Salinity, Earth Science > Oceans > Water Quality     keywords_vocabulary       GCMD Science Keywords      license      The data may be used and redistributed for free but is not intended for legal use, since it may contain inaccuracies. Neither the data Contributor, University of Hawaii, PacIOOS, NOAA, State of Hawaii nor the United States Government, nor any of their employees or contractors, makes any warranty, express or implied, including warranties of merchantability and fitness for a particular purpose, or assumes any legal liability for the accuracy, completeness, or usefulness, of this information.     local_time_zone          	locations         Continent > North America > United States Of America > Hawaii, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Big Island, Ocean > Pacific Ocean > Central Pacific Ocean > Hawaiian Islands > Hawaii Island > Hilo      locations_vocabulary      GCMD Location Keywords     
metadata_link         3https://www.pacioos.hawaii.edu/metadata/wqb_04.html    naming_authority      org.pacioos    ncei_template_version         /NCEI_NetCDF_TimeSeries_Incomplete_Template_v2.0    Northernmost_Northing         Ap   platform      OIn Situ Ocean-based Platforms > Buoys, In Situ Ocean-based Platforms > Moorings    
platform_code         wqb_04     platform_vocabulary       GCMD Platform Keywords     processing_level      3near real-time (nrt) and possibly delayed mode (dm)    product_version       1.0    program       0Pacific Islands Ocean Observing System (PacIOOS)   project       0Pacific Islands Ocean Observing System (PacIOOS)   publisher_email       info@pacioos.org   publisher_institution         0Pacific Islands Ocean Observing System (PacIOOS)   publisher_name        0Pacific Islands Ocean Observing System (PacIOOS)   publisher_type        institution    
publisher_url         http://www.pacioos.hawaii.edu      sea_name      North Pacific Ocean    source        'in-situ measurement of water properties    	sourceUrl         http://pacioos.org     Southernmost_Northing         Ap   standard_name_vocabulary      CF Standard Name Table v71     subsetVariables      temperature_dm_qd, temperature_qc_agg, temperature_qc_gap, temperature_qc_syn, temperature_qc_loc, temperature_qc_rng, temperature_qc_clm, temperature_qc_spk, temperature_qc_rtc, temperature_qc_flt, temperature_qc_mvr, temperature_qc_atn, temperature_qc_nbr, temperature_qc_crv, temperature_qc_din, salinity_dm_qd, salinity_qc_agg, salinity_qc_gap, salinity_qc_syn, salinity_qc_loc, salinity_qc_rng, salinity_qc_clm, salinity_qc_spk, salinity_qc_rtc, salinity_qc_flt, salinity_qc_mvr, salinity_qc_atn, salinity_qc_nbr, salinity_qc_crv, salinity_qc_din, oxygen_saturation_dm_qd, oxygen_saturation_qc_agg, oxygen_saturation_qc_gap, oxygen_saturation_qc_syn, oxygen_saturation_qc_loc, oxygen_saturation_qc_rng, oxygen_saturation_qc_clm, oxygen_saturation_qc_spk, oxygen_saturation_qc_rtc, oxygen_saturation_qc_flt, oxygen_saturation_qc_mvr, oxygen_saturation_qc_atn, oxygen_saturation_qc_nbr, oxygen_dm_qd, oxygen_qc_agg, oxygen_qc_gap, oxygen_qc_syn, oxygen_qc_loc, oxygen_qc_rng, oxygen_qc_clm, oxygen_qc_spk, oxygen_qc_rtc, oxygen_qc_flt, oxygen_qc_mvr, oxygen_qc_atn, oxygen_qc_nbr, chlorophyll_dm_qd, chlorophyll_qc_agg, chlorophyll_qc_gap, chlorophyll_qc_syn, chlorophyll_qc_loc, chlorophyll_qc_rng, chlorophyll_qc_clm, chlorophyll_qc_spk, chlorophyll_qc_rtc, chlorophyll_qc_flt, chlorophyll_qc_mvr, chlorophyll_qc_atn, chlorophyll_qc_nbr, turbidity_dm_qd, turbidity_qc_agg, turbidity_qc_gap, turbidity_qc_syn, turbidity_qc_loc, turbidity_qc_rng, turbidity_qc_clm, turbidity_qc_spk, turbidity_qc_rtc, turbidity_qc_flt, turbidity_qc_mvr, turbidity_qc_atn, turbidity_qc_nbr, ph_dm_qd, ph_qc_agg, ph_qc_gap, ph_qc_syn, ph_qc_loc, ph_qc_rng, ph_qc_clm, ph_qc_spk, ph_qc_rtc, ph_qc_flt, ph_qc_mvr, ph_qc_atn, ph_qc_nbr, instrument1      summary      The water quality buoys are part of the Pacific Islands Ocean Observing System (PacIOOS) and are designed to measure a variety of ocean parameters at fixed points. wqb_04 is located in Hilo Bay on the east side of the Big Island. Continuous sampling of this area provides a record of baseline conditions of the chemical and biological environment for comparison when there are pollution events such as storm runoff or a sewage spill.      
testOutOfDate         
now-90minutes      time_coverage_end         2020-12-31T23:45:00Z   time_coverage_resolution      PT30M      time_coverage_start       2020-01-28T19:30:00Z   title         ;PacIOOS Water Quality Buoy 04: Hilo Bay, Big Island, Hawaii    uuid      org.pacioos.wqb_04     Westernmost_Easting          wmo_platform_code         51045         u   latitude             
   _CoordinateAxisType       Lat    actual_range      ApAp   axis      Y      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Latitude   
short_name        lat    
standard_name         latitude   units         
degrees_north      valid_range       ApAp       r   	longitude                
   _CoordinateAxisType       Lon    actual_range         axis      X      comment       instrument is in fixed location    
ioos_category         Location   	long_name         	Longitude      
short_name        lon    
standard_name         	longitude      units         degrees_east   valid_range              r   depth                   _CoordinateAxisType       Height     _CoordinateZisPositive        down   actual_range      ?  ?     axis      Z      comment       instrument is in fixed location    
ioos_category         Location   	long_name         Distance below mean sea level      positive      down   
short_name        depth      
standard_name         depth      units         m      valid_range       ?  ?         r   station_name                   	_Encoding         
ISO-8859-1     cf_role       
timeseries_id      
ioos_category         
Identifier     	long_name         station    
short_name        station        r   time                
   _ChunkSizes                _CoordinateAxisType       Time   
_FillValue                 actual_range      A׌"   A      axis      T      calendar      julian     coverage_content_type         
coordinate     
ioos_category         Time   	long_name         Time   
short_name        time   
standard_name         time   time_origin       01-JAN-1970 00:00:00   units         "seconds since 1970-01-01T00:00:00Z       r   temperature                    _ChunkSizes                
_FillValue        y    actual_range      A
=B/     ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (processed)      	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       4   salinity                   _ChunkSizes                
_FillValue        y    actual_range          C8R   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (processed)   	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       x   	turbidity                      _ChunkSizes                
_FillValue        y    actual_range        F{   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (processed)      	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       T   chlorophyll                    _ChunkSizes                
_FillValue        y    actual_range      8QCn   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (processed)    	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       
0   oxygen                     _ChunkSizes                
_FillValue        y    actual_range          AF{   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         *dissolved oxygen concentration (processed)     	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH          oxygen_saturation                      _ChunkSizes                
_FillValue        y    actual_range      <#
C4   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        true   
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         'dissolved oxygen saturation (processed)    	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C          ph                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (processed)     	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       y   temperature_raw                    _ChunkSizes                
_FillValue        y    actual_range      A
=B/     ancillary_variables      1instrument1 platform1 temperature_dm_qd temperature_qc_agg temperature_qc_gap temperature_qc_syn temperature_qc_loc temperature_qc_rng temperature_qc_clm temperature_qc_spk temperature_qc_rtc temperature_qc_flt temperature_qc_mvr temperature_qc_atn temperature_qc_nbr temperature_qc_crv temperature_qc_din      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Temperature    	long_name         water temperature (raw)    	ncei_name         WATER TEMPERATURE      observation_type      measured   platform      	platform1      
short_name        temp   
standard_name         sea_water_temperature      units         Celsius    valid_range         BH       Z   temperature_dm_qd                      _ChunkSizes                
_FillValue           actual_range                 coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         1water temperature delayed-mode quality descriptor      
short_name        
temp_dm_qd     
standard_name         !sea_water_temperature status_flag      units         1      valid_range               ;|   temperature_qc_agg                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     X   temperature_qc_gap                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     4   temperature_qc_syn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        temperature_qc_loc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	        temperature_qc_rng                     _ChunkSizes                
_FillValue           actual_range               comment       lThe following ranges were flagged if exceeded: suspect_or_high_interest: (15.0, 30.0); failed: (-5.0, 50.0).   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	        temperature_qc_clm                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	        temperature_qc_spk                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     !a   temperature_qc_rtc                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     #B\   temperature_qc_flt                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     %#8   temperature_qc_mvr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     '   temperature_qc_atn                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     (   temperature_qc_nbr                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     *   temperature_qc_crv                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     ,   temperature_qc_din                     _ChunkSizes                
_FillValue           actual_range               coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        temp_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     .   salinity_raw                   _ChunkSizes                
_FillValue        y    actual_range          C8R   ancillary_variables      instrument1 platform1 salinity_dm_qd salinity_qc_agg salinity_qc_gap salinity_qc_syn salinity_qc_loc salinity_qc_rng salinity_qc_clm salinity_qc_spk salinity_qc_rtc salinity_qc_flt salinity_qc_mvr salinity_qc_atn salinity_qc_nbr salinity_qc_crv salinity_qc_din   cell_methods      9time: point longitude: point latitude: point depth: point      comment       Practical Salinity Units (PSU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Salinity   	long_name         salinity PSU (raw)     	ncei_name         SALINITY   observation_type      
calculated     platform      	platform1      
short_name        salt   
standard_name         sea_water_practical_salinity   units         1      valid_range           B       0h`   salinity_dm_qd                     _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ,salinity PSU delayed-mode quality descriptor   
short_name        
salt_dm_qd     
standard_name         (sea_water_practical_salinity status_flag   units         1      valid_range               2I<   salinity_qc_agg                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     4*   salinity_qc_gap                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     6
   salinity_qc_syn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     7   salinity_qc_loc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     9̬   salinity_qc_rng                    _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.0, 36.0); failed: (0.0, 70.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     ;   salinity_qc_clm                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     =d   salinity_qc_spk                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     ?o@   salinity_qc_rtc                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     AP   salinity_qc_flt                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     C0   salinity_qc_mvr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     E   salinity_qc_atn                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     F   salinity_qc_nbr                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     Hӌ   salinity_qc_crv                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         'QARTOD T/S Curve/Space Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_crv    
standard_name          ts_curve_space_test_quality_flag   units         1      valid_range             	     Jh   salinity_qc_din                    _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Density Inversion Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        salt_qc_din    
standard_name         #density_inversion_test_quality_flag    units         1      valid_range             	     LD   
turbidity_raw                      _ChunkSizes                
_FillValue        y    actual_range        F{   ancillary_variables       instrument1 platform1 turbidity_dm_qd turbidity_qc_agg turbidity_qc_gap turbidity_qc_syn turbidity_qc_loc turbidity_qc_rng turbidity_qc_clm turbidity_qc_spk turbidity_qc_rtc turbidity_qc_flt turbidity_qc_mvr turbidity_qc_atn turbidity_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      comment       "Formazin Nephelometric Units (FNU)     coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Optical Properties     	long_name         turbidity FNU (raw)    	ncei_name         	TURBIDITY      observation_type      
calculated     platform      	platform1      
short_name        turb   
standard_name         sea_water_turbidity    units         1      valid_range           Dz       Nv    turbidity_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         -turbidity FNU delayed-mode quality descriptor      
short_name        
turb_dm_qd     
standard_name         sea_water_turbidity status_flag    units         1      valid_range               PV   turbidity_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     R7   turbidity_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     T   turbidity_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     U   turbidity_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     Wl   turbidity_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.1, 120.0); failed: (0.0, 1000.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     YH   turbidity_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     [$   turbidity_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     ]}    turbidity_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     _]   turbidity_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     a>   turbidity_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     c   turbidity_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     e p   turbidity_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        turb_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     fL   chlorophyll_raw                    _ChunkSizes                
_FillValue        y    actual_range      8QCn   ancillary_variables      instrument1 platform1 chlorophyll_dm_qd chlorophyll_qc_agg chlorophyll_qc_gap chlorophyll_qc_syn chlorophyll_qc_loc chlorophyll_qc_rng chlorophyll_qc_clm chlorophyll_qc_spk chlorophyll_qc_rtc chlorophyll_qc_flt chlorophyll_qc_mvr chlorophyll_qc_atn chlorophyll_qc_nbr    cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Ocean Color    	long_name         chlorophyll (raw)      	ncei_name         CHLOROPHYLL A CONCENTRATION    observation_type      
calculated     platform      	platform1      
short_name        flor   
standard_name         .mass_concentration_of_chlorophyll_in_sea_water     units         ug/L   valid_range           C       h(   chlorophyll_dm_qd                      _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         +chlorophyll delayed-mode quality descriptor    
short_name        
flor_dm_qd     
standard_name         :mass_concentration_of_chlorophyll_in_sea_water status_flag     units         1      valid_range               j   chlorophyll_qc_agg                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     l   chlorophyll_qc_gap                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     nd   chlorophyll_qc_syn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     pE   chlorophyll_qc_loc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     r&t   chlorophyll_qc_rng                     _ChunkSizes                
_FillValue           actual_range            	   comment       kThe following ranges were flagged if exceeded: suspect_or_high_interest: (0.0, 90.0); failed: (0.0, 454.0).    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     tP   chlorophyll_qc_clm                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     u,   chlorophyll_qc_spk                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     w   chlorophyll_qc_rtc                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     y   chlorophyll_qc_flt                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     {   chlorophyll_qc_mvr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     }k   chlorophyll_qc_atn                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     Lx   chlorophyll_qc_nbr                     _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        flor_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     -T   
oxygen_raw                     _ChunkSizes                
_FillValue        y    actual_range          AF{   ancillary_variables       instrument1 platform1 oxygen_dm_qd oxygen_qc_agg oxygen_qc_gap oxygen_qc_syn oxygen_qc_loc oxygen_qc_rng oxygen_qc_clm oxygen_qc_spk oxygen_qc_rtc oxygen_qc_flt oxygen_qc_mvr oxygen_qc_atn oxygen_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         $dissolved oxygen concentration (raw)   	ncei_name         DISSOLVED OXYGEN   observation_type      
calculated     platform      	platform1      
short_name        odoc   
standard_name         )mass_concentration_of_oxygen_in_sea_water      units         mg/L   valid_range           BH       0   oxygen_dm_qd                   _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         >dissolved oxygen concentration delayed-mode quality descriptor     
short_name        
odoc_dm_qd     
standard_name         5mass_concentration_of_oxygen_in_sea_water status_flag      units         1      valid_range                  
oxygen_qc_agg                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	        
oxygen_qc_gap                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        
oxygen_qc_syn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	        
oxygen_qc_loc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     r|   
oxygen_qc_rng                      _ChunkSizes                
_FillValue           actual_range            	   comment       jThe following ranges were flagged if exceeded: suspect_or_high_interest: (3.5, 12.5); failed: (0.0, 50.0).     coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     SX   
oxygen_qc_clm                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     44   
oxygen_qc_spk                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	        
oxygen_qc_rtc                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	        
oxygen_qc_flt                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	        
oxygen_qc_mvr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	        
oxygen_qc_atn                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	        
oxygen_qc_nbr                      _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        odoc_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     y\   oxygen_saturation_raw                      _ChunkSizes                
_FillValue        y    actual_range      <#
C4   ancillary_variables      Yinstrument1 platform1 oxygen_saturation_dm_qd oxygen_saturation_qc_agg oxygen_saturation_qc_gap oxygen_saturation_qc_syn oxygen_saturation_qc_loc oxygen_saturation_qc_rng oxygen_saturation_qc_clm oxygen_saturation_qc_spk oxygen_saturation_qc_rtc oxygen_saturation_qc_flt oxygen_saturation_qc_mvr oxygen_saturation_qc_atn oxygen_saturation_qc_nbr      cell_methods      9time: point longitude: point latitude: point depth: point      coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Dissolved O2   	long_name         !dissolved oxygen saturation (raw)      	ncei_name         OXYGEN - PERCENT SATURATION    observation_type      
calculated     platform      	platform1      
short_name        osat   
standard_name         ,fractional_saturation_of_oxygen_in_sea_water   units         %      valid_range           C       Z8   oxygen_saturation_dm_qd                    _ChunkSizes                
_FillValue           actual_range             coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         ;dissolved oxygen saturation delayed-mode quality descriptor    
short_name        
osat_dm_qd     
standard_name         8fractional_saturation_of_oxygen_in_sea_water status_flag   units         1      valid_range               ;   oxygen_saturation_qc_agg                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	        oxygen_saturation_qc_gap                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	        oxygen_saturation_qc_syn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     ݨ   oxygen_saturation_qc_loc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	        oxygen_saturation_qc_rng                   _ChunkSizes                
_FillValue           actual_range            	   comment       mThe following ranges were flagged if exceeded: suspect_or_high_interest: (70.0, 180.0); failed: (0.0, 500.0).      coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     `   oxygen_saturation_qc_clm                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     <   oxygen_saturation_qc_spk                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     a   oxygen_saturation_qc_rtc                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     A   oxygen_saturation_qc_flt                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     "   oxygen_saturation_qc_mvr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	        oxygen_saturation_qc_atn                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	        oxygen_saturation_qc_nbr                   _ChunkSizes                
_FillValue           actual_range            	   coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        true   
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        osat_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     d   ph_raw                     _ChunkSizes                
_FillValue        y    ancillary_variables       instrument1 platform1 ph_dm_qd ph_qc_agg ph_qc_gap ph_qc_syn ph_qc_loc ph_qc_rng ph_qc_clm ph_qc_spk ph_qc_rtc ph_qc_flt ph_qc_mvr ph_qc_atn ph_qc_nbr     cell_methods      9time: point longitude: point latitude: point depth: point      comment       8Dummy variable. This quantity not measured at this time.   coordinates       time latitude longitude depth      coverage_content_type         physicalMeasurement    grid_mapping      crs    
gts_ingest        false      
instrument        instrument1    
ioos_category         Other      	long_name         pH (raw)   	ncei_name         PH     observation_type      
calculated     platform      	platform1      
short_name        ph01   
standard_name         $sea_water_ph_reported_on_total_scale   units         1      valid_range           A`       @   ph_dm_qd                   _ChunkSizes                
_FillValue           actual_range         coordinates       time latitude longitude depth      
flag_meanings         qmissing_value quality_not_evaluated failed_or_bad questionable_or_suspect passed_or_good interpolated_or_adjusted      flag_values                          
ioos_category         Quality    	long_name         "pH delayed-mode quality descriptor     
short_name        
ph01_dm_qd     
standard_name         0sea_water_ph_reported_on_total_scale status_flag   units         1      valid_range                  	ph_qc_agg                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         (QARTOD Aggregate/Rollup Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_agg    
standard_name         aggregate_quality_flag     units         1      valid_range             	     g   	ph_qc_gap                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Gap Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_gap    
standard_name         gap_test_quality_flag      units         1      valid_range             	     H   	ph_qc_syn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Syntax Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_syn    
standard_name         syntax_test_quality_flag   units         1      valid_range             	     )   	ph_qc_loc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Location Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_loc    
standard_name         location_test_quality_flag     units         1      valid_range             	     
   	ph_qc_rng                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Gross Range Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rng    
standard_name         gross_range_test_quality_flag      units         1      valid_range             	     h   	ph_qc_clm                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         #QARTOD Climatology Test (processed)    
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_clm    
standard_name         climatology_test_quality_flag      units         1      valid_range             	     D   	ph_qc_spk                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         QARTOD Spike Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_spk    
standard_name         spike_test_quality_flag    units         1      valid_range             	     ƭ    	ph_qc_rtc                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         &QARTOD Rate of Change Test (processed)     
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_rtc    
standard_name          rate_of_change_test_quality_flag   units         1      valid_range             	     ȍ   	ph_qc_flt                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         !QARTOD Flat Line Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_flt    
standard_name         flat_line_test_quality_flag    units         1      valid_range             	     n   	ph_qc_mvr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         %QARTOD Multi-Variate Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_mvr    
standard_name         multi_variate_test_quality_flag    units         1      valid_range             	     O   	ph_qc_atn                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name         )QARTOD Attenuated Signal Test (processed)      
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_atn    
standard_name         #attenuated_signal_test_quality_flag    units         1      valid_range             	     0   	ph_qc_nbr                      _ChunkSizes                
_FillValue           actual_range         	   	   comment       CNOTE: QARTOD does not yet have tests for pH; this is a placeholder.    coordinates       time latitude longitude depth      
flag_meanings         Gpass quality_not_evaluated suspect_or_high_interest failed missing_data    flag_values                      	   
gts_ingest        false      
ioos_category         Quality    	long_name          QARTOD Neighbor Test (processed)   
references        %https://ioos.noaa.gov/project/qartod/      
short_name        ph01_qc_nbr    
standard_name         neighbor_test_quality_flag     units         1      valid_range             	     l   	platform1                         	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         platform   	ncei_code         3164   
short_name        platform   wmo_code      51045       L H   instrument1                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	long_name         +YSI EXO2 Multiparameter Water Quality Sonde    
make_model        +YSI EXO2 Multiparameter Water Quality Sonde     1@ Ô   crs                       	_Encoding         
ISO-8859-1     coordinates       time latitude longitude depth      	epsg_code         	EPSG:4326      grid_mapping_name         latitude_longitude     inverse_flattening        C    	long_name         coordinate reference system    semi_major_axis       J¥2    9 Ap?  wqb_04  A׌"   A׌#   A׌$   A׌%   A׌&r   A׌'S   A׌(4   A׌)   A׌)   A׌*   A׌+   A׌,   A׌-z   A׌.[   A׌/<   A׌0   A׌0   A׌1   A׌2   A׌3   A׌4   A׌5c   A׌6D   A׌7%   A׌8   A׌8   A׌9   A׌:   A׌;   A׌<k   A׌=L   A׌>-   A׌?   A׌?   A׌@   A׌A   A׌B   A׌Cs   A׌DT   A׌E5   A׌F   A׌F   A׌G   A׌H   A׌I   A׌J{   A׌K\   A׌L=   A׌M   A׌M   A׌N   A׌O   A׌P   A׌Q   A׌Rd   A׌SE   A׌T&   A׌U   A׌U   A׌V   A׌W   A׌X   A׌Yl   A׌ZM   A׌[.   A׌\   A׌\   A׌]   A׌^   A׌_   A׌`t   A׌aU   A׌b6   A׌c   A׌c   A׌d   A׌e   A׌f   A׌g|   A׌h]   A׌i>   A׌j   A׌k    A׌k   A׌l   A׌m   A׌n   A׌oe   A׌pF   A׌q'   A׌r   A׌r   A׌s   A׌t   A׌u   A׌vm   A׌wN   A׌x/   A׌y   A׌y   A׌z   A׌{   A׌|   A׌}u   A׌~V   A׌7   A׌   A׌   A׌   A׌   A׌   A׌}   A׌^   A׌?   A׌    A׌   A׌   A׌   A׌   A׌   A׌f   A׌G   A׌(   A׌	   A׌   A׌   A׌   A׌   A׌n   A׌O   A׌0   A׌   A׌   A׌   A׌   A׌   A׌v   A׌W   A׌8   A׌   A׌   A׌   A׌   A׌   A׌~   A׌_   A׌@   A׌!   A׌   A׌   A׌   A׌   A׌   A׌g   A׌H   A׌)   A׌
   A׌   A׌   A׌   A׌   A׌o   A׌P   A׌1   A׌   A׌   A׌   A׌   A׌   A׌w   A׌X   A׌9   A׌   A׌   A׌   A׌   A׌   A׌   A׌`   A׌A   A׌"   A׌   A׌   A׌   A׌Ħ   A׌Ň   A׌h   A׌I   A׌*   A׌   A׌   A׌   A׌ˮ   A׌̏   A׌p   A׌Q   A׌2   A׌   A׌   A׌   A׌Ҷ   A׌ӗ   A׌x   A׌Y   A׌:   A׌   A׌   A׌   A׌پ   A׌ڟ   A׌ۀ   A׌a   A׌B   A׌#   A׌   A׌   A׌   A׌   A׌   A׌i   A׌J   A׌+   A׌   A׌   A׌   A׌   A׌   A׌q   A׌R   A׌3   A׌   A׌   A׌   A׌   A׌   A׌y   A׌Z   A׌;   A׌   A׌   A׌   A׌   A׌   A׌   A׌b   A׌C   A׌$   A׌   A׌   A׌   A׌   A׌   A׍ j   A׍K   A׍,   A׍
   A׍   A׍   A׍   A׍   A׍r   A׍S   A׍	4   A׍
   A׍
   A׍   A׍   A׍
   A׍z   A׍[   A׍<   A׍   A׍   A׍   A׍   A׍   A׍   A׍c   A׍D   A׍%   A׍   A׍   A׍   A׍   A׍   A׍k   A׍L   A׍-   A׍    A׍    A׍!   A׍"   A׍#   A׍$s   A׍%T   A׍&5   A׍'   A׍'   A׍(   A׍)   A׍*   A׍+{   A׍,\   A׍-=   A׍.   A׍.   A׍/   A׍0   A׍1   A׍2   A׍3d   A׍4E   A׍5&   A׍6   A׍6   A׍7   A׍8   A׍9   A׍:l   A׍;M   A׍<.   A׍=   A׍=   A׍>   A׍?   A׍@   A׍At   A׍BU   A׍C6   A׍D   A׍D   A׍E   A׍F   A׍G   A׍H|   A׍I]   A׍J>   A׍K   A׍L    A׍L   A׍M   A׍N   A׍O   A׍Pe   A׍QF   A׍R'   A׍S   A׍S   A׍T   A׍U   A׍V   A׍Wm   A׍XN   A׍Y/   A׍Z   A׍Z   A׍[   A׍\   A׍]   A׍^u   A׍_V   A׍`7   A׍a   A׍a   A׍b   A׍c   A׍d   A׍e}   A׍f^   A׍g?   A׍h    A׍i   A׍i   A׍j   A׍k   A׍l   A׍mf   A׍nG   A׍o(   A׍p	   A׍p   A׍q   A׍r   A׍s   A׍tn   A׍uO   A׍v0   A׍w   A׍w   A׍x   A׍y   A׍z   A׍{v   A׍|W   A׍}8   A׍~   A׍~   A׍   A׍   A׍   A׍~   A׍_   A׍@   A׍!   A׍   A׍   A׍   A׍   A׍   A׍g   A׍H   A׍)   A׍
   A׍   A׍   A׍   A׍   A׍o   A׍P   A׍1   A׍   A׍   A׍   A׍   A׍   A׍w   A׍X   A׍9   A׍   A׍   A׍   A׍   A׍   A׍   A׍`   A׍A   A׍"   A׍   A׍   A׍   A׍   A׍   A׍h   A׍I   A׍*   A׍   A׍   A׍   A׍   A׍   A׍p   A׍Q   A׍2   A׍   A׍   A׍   A׍   A׍   A׍x   A׍Y   A׍:   A׍   A׍   A׍   A׍   A׍   A׍   A׍a   A׍B   A׍#   A׍   A׍   A׍   A׍§   A׍È   A׍i   A׍J   A׍+   A׍   A׍   A׍   A׍ɯ   A׍ʐ   A׍q   A׍R   A׍3   A׍   A׍   A׍   A׍з   A׍ј   A׍y   A׍Z   A׍;   A׍   A׍   A׍   A׍׿   A׍ؠ   A׍ف   A׍b   A׍C   A׍$   A׍   A׍   A׍   A׍ߨ   A׍   A׍j   A׍K   A׍,   A׍
   A׍   A׍   A׍   A׍   A׍r   A׍S   A׍4   A׍   A׍   A׍   A׍   A׍   A׍z   A׍[   A׍<   A׍   A׍   A׍   A׍   A׍   A׍   A׍c   A׍D   A׍%   A׍   A׍   A׍   A׍   A׍   A׍k   A׍L   A׎ -   A׎   A׎   A׎   A׎   A׎   A׎s   A׎T   A׎5   A׎   A׎   A׎	   A׎
   A׎   A׎{   A׎
\   A׎=   A׎   A׎   A׎   A׎   A׎   A׎   A׎d   A׎E   A׎&   A׎   A׎   A׎   A׎   A׎   A׎l   A׎M   A׎.   A׎   A׎   A׎   A׎    A׎!   A׎"t   A׎#U   A׎$6   A׎%   A׎%   A׎&   A׎'   A׎(   A׎)|   A׎*]   A׎+>   A׎,   A׎-    A׎-   A׎.   A׎/   A׎0   A׎1e   A׎2F   A׎3'   A׎4   A׎4   A׎5   A׎6   A׎7   A׎8m   A׎9N   A׎:/   A׎;   A׎;   A׎<   A׎=   A׎>   A׎?u   A׎@V   A׎A7   A׎B   A׎B   A׎C   A׎D   A׎E   A׎F}   A׎G^   A׎H?   A׎I    A׎J   A׎J   A׎K   A׎L   A׎M   A׎Nf   A׎OG   A׎P(   A׎Q	   A׎Q   A׎R   A׎S   A׎T   A׎Un   A׎VO   A׎W0   A׎X   A׎X   A׎Y   A׎Z   A׎[   A׎\v   A׎]W   A׎^8   A׎_   A׎_   A׎`   A׎a   A׎b   A׎c~   A׎d_   A׎e@   A׎f!   A׎g   A׎g   A׎h   A׎i   A׎j   A׎kg   A׎lH   A׎m)   A׎n
   A׎n   A׎o   A׎p   A׎q   A׎ro   A׎sP   A׎t1   A׎u   A׎u   A׎v   A׎w   A׎x   A׎yw   A׎zX   A׎{9   A׎|   A׎|   A׎}   A׎~   A׎   A׎   A׎`   A׎A   A׎"   A׎   A׎   A׎   A׎   A׎   A׎h   A׎I   A׎*   A׎   A׎   A׎   A׎   A׎   A׎p   A׎Q   A׎2   A׎   A׎   A׎   A׎   A׎   A׎x   A׎Y   A׎:   A׎   A׎   A׎   A׎   A׎   A׎   A׎a   A׎B   A׎#   A׎   A׎   A׎   A׎   A׎   A׎i   A׎J   A׎+   A׎   A׎   A׎   A׎   A׎   A׎q   A׎R   A׎3   A׎   A׎   A׎   A׎   A׎   A׎y   A׎Z   A׎;   A׎   A׎   A׎   A׎   A׎   A׎   A׎b   A׎C   A׎$   A׎   A׎   A׎   A׎   A׎   A׎j   A׎K   A׎,   A׎
   A׎   A׎   A׎ǰ   A׎ȑ   A׎r   A׎S   A׎4   A׎   A׎   A׎   A׎θ   A׎ϙ   A׎z   A׎[   A׎<   A׎   A׎   A׎   A׎   A׎֡   A׎ׂ   A׎c   A׎D   A׎%   A׎   A׎   A׎   A׎ݩ   A׎ފ   A׎k   A׎L   A׎-   A׎   A׎   A׎   A׎   A׎   A׎s   A׎T   A׎5   A׎   A׎   A׎   A׎   A׎   A׎{   A׎\   A׎=   A׎   A׎   A׎   A׎   A׎   A׎   A׎d   A׎E   A׎&   A׎   A׎   A׎   A׎   A׎   A׎l   A׎M   A׎.   A׎   A׎   A׏    A׏   A׏   A׏t   A׏U   A׏6   A׏   A׏   A׏   A׏   A׏	   A׏
|   A׏]   A׏>   A׏
   A׏    A׏   A׏   A׏   A׏   A׏e   A׏F   A׏'   A׏   A׏   A׏   A׏   A׏   A׏m   A׏N   A׏/   A׏   A׏   A׏   A׏   A׏   A׏ u   A׏!V   A׏"7   A׏#   A׏#   A׏$   A׏%   A׏&   A׏'}   A׏(^   A׏)?   A׏*    A׏+   A׏+   A׏,   A׏-   A׏.   A׏/f   A׏0G   A׏1(   A׏2	   A׏2   A׏3   A׏4   A׏5   A׏6n   A׏7O   A׏80   A׏9   A׏9   A׏:   A׏;   A׏<   A׏=v   A׏>W   A׏?8   A׏@   A׏@   A׏A   A׏B   A׏C   A׏D~   A׏E_   A׏F@   A׏G!   A׏H   A׏H   A׏I   A׏J   A׏K   A׏Lg   A׏MH   A׏N)   A׏O
   A׏O   A׏P   A׏Q   A׏R   A׏So   A׏TP   A׏U1   A׏V   A׏V   A׏W   A׏X   A׏Y   A׏Zw   A׏[X   A׏\9   A׏]   A׏]   A׏^   A׏_   A׏`   A׏a   A׏b`   A׏cA   A׏d"   A׏e   A׏e   A׏f   A׏g   A׏h   A׏ih   A׏jI   A׏k*   A׏l   A׏l   A׏m   A׏n   A׏o   A׏pp   A׏qQ   A׏r2   A׏s   A׏s   A׏t   A׏u   A׏v   A׏wx   A׏xY   A׏y:   A׏z   A׏z   A׏{   A׏|   A׏}   A׏~   A׏a   A׏B   A׏#   A׏   A׏   A׏   A׏   A׏   A׏i   A׏J   A׏+   A׏   A׏   A׏   A׏   A׏   A׏q   A׏R   A׏3   A׏   A׏   A׏   A׏   A׏   A׏y   A׏Z   A׏;   A׏   A׏   A׏   A׏   A׏   A׏   A׏b   A׏C   A׏$   A׏   A׏   A׏   A׏   A׏   A׏j   A׏K   A׏,   A׏
   A׏   A׏   A׏   A׏   A׏r   A׏S   A׏4   A׏   A׏   A׏   A׏   A׏   A׏z   A׏[   A׏<   A׏   A׏   A׏   A׏   A׏   A׏   A׏c   A׏D   A׏%   A׏   A׏   A׏   A׏   A׏   A׏k   A׏L   A׏-   A׏   A׏   A׏   A׏ű   A׏ƒ   A׏s   A׏T   A׏5   A׏   A׏   A׏   A׏̹   A׏͚   A׏{   A׏\   A׏=   A׏   A׏   A׏   A׏   A׏Ԣ   A׏Ճ   A׏d   A׏E   A׏&   A׏   A׏   A׏   A׏۪   A׏܋   A׏l   A׏M   A׏.   A׏   A׏   A׏   A׏   A׏   A׏t   A׏U   A׏6   A׏   A׏   A׏   A׏   A׏   A׏|   A׏]   A׏>   A׏   A׏    A׏   A׏   A׏   A׏   A׏e   A׏F   A׏'   A׏   A׏   A׏   A׏   A׏   A׏m   A׏N   A׏/   A׏   A׏   A׏   A׏   Aא    Aאu   AאV   Aא7   Aא   Aא   Aא   Aא   Aא   Aא}   Aא	^   Aא
?   Aא    Aא   Aא   Aא
   Aא   Aא   Aאf   AאG   Aא(   Aא	   Aא   Aא   Aא   Aא   Aאn   AאO   Aא0   Aא   Aא   Aא   Aא   Aא   Aאv   AאW   Aא 8   Aא!   Aא!   Aא"   Aא#   Aא$   Aא%~   Aא&_   Aא'@   Aא(!   Aא)   Aא)   Aא*   Aא+   Aא,   Aא-g   Aא.H   Aא/)   Aא0
   Aא0   Aא1   Aא2   Aא3   Aא4o   Aא5P   Aא61   Aא7   Aא7   Aא8   Aא9   Aא:   Aא;w   Aא<X   Aא=9   Aא>   Aא>   Aא?   Aא@   AאA   AאB   AאC`   AאDA   AאE"   AאF   AאF   AאG   AאH   AאI   AאJh   AאKI   AאL*   AאM   AאM   AאN   AאO   AאP   AאQp   AאRQ   AאS2   AאT   AאT   AאU   AאV   AאW   AאXx   AאYY   AאZ:   Aא[   Aא[   Aא\   Aא]   Aא^   Aא_   Aא`a   AאaB   Aאb#   Aאc   Aאc   Aאd   Aאe   Aאf   Aאgi   AאhJ   Aאi+   Aאj   Aאj   Aאk   Aאl   Aאm   Aאnq   AאoR   Aאp3   Aאq   Aאq   Aאr   Aאs   Aאt   Aאuy   AאvZ   Aאw;   Aאx   Aאx   Aאy   Aאz   Aא{   Aא|   Aא}b   Aא~C   Aא$   Aא   Aא   Aא   Aא   Aא   Aאj   AאK   Aא,   Aא
   Aא   Aא   Aא   Aא   Aאr   AאS   Aא4   Aא   Aא   Aא   Aא   Aא   Aאz   Aא[   Aא<   Aא   Aא   Aא   Aא   Aא   Aא   Aאc   AאD   Aא%   Aא   Aא   Aא   Aא   Aא   Aאk   AאL   Aא-   Aא   Aא   Aא   Aא   Aא   Aאs   AאT   Aא5   Aא   Aא   Aא   Aא   Aא   Aא{   Aא\   Aא=   Aא   Aא   Aא   Aא   Aא   Aא   Aאd   AאE   Aא&   Aא   Aא   Aא   Aא   Aא   Aאl   AאM   Aא.   Aא   Aא   Aא   Aאò   Aאē   Aאt   AאU   Aא6   Aא   Aא   Aא   Aאʺ   Aא˛   Aא|   Aא]   Aא>   Aא   Aא    Aא   Aא   Aאң   Aאӄ   Aאe   AאF   Aא'   Aא   Aא   Aא   Aא٫   Aאڌ   Aאm   AאN   Aא/   Aא   Aא   Aא   Aא   Aא   Aאu   AאV   Aא7   Aא   Aא   Aא   Aא   Aא   Aא}   Aא^   Aא?   Aא    Aא   Aא   Aא   Aא   Aא   Aאf   AאG   Aא(   Aא	   Aא   Aא   Aא   Aא   Aאn   AאO   Aא0   Aא   Aא   Aא   Aא   Aא   Aאv   Aב W   Aב8   Aב   Aב   Aב   Aב   Aב   Aב~   Aב_   Aב@   Aב	!   Aב
   Aב
   Aב   Aב   Aב
   Aבg   AבH   Aב)   Aב
   Aב   Aב   Aב   Aב   Aבo   AבP   Aב1   Aב   Aב   Aב   Aב   Aב   Aבw   AבX   Aב9   Aב   Aב   Aב    Aב!   Aב"   Aב#   Aב$`   Aב%A   Aב&"   Aב'   Aב'   Aב(   Aב)   Aב*   Aב+h   Aב,I   Aב-*   Aב.   Aב.   Aב/   Aב0   Aב1   Aב2p   Aב3Q   Aב42   Aב5   Aב5   Aב6   Aב7   Aב8   Aב9x   Aב:Y   Aב;:   Aב<   Aב<   Aב=   Aב>   Aב?   Aב@   AבAa   AבBB   AבC#   AבD   AבD   AבE   AבF   AבG   AבHi   AבIJ   AבJ+   AבK   AבK   AבL   AבM   AבN   AבOq   AבPR   AבQ3   AבR   AבR   AבS   AבT   AבU   AבVy   AבWZ   AבX;   AבY   AבY   AבZ   Aב[   Aב\   Aב]   Aב^b   Aב_C   Aב`$   Aבa   Aבa   Aבb   Aבc   Aבd   Aבej   AבfK   Aבg,   Aבh
   Aבh   Aבi   Aבj   Aבk   Aבlr   AבmS   Aבn4   Aבo   Aבo   Aבp   Aבq   Aבr   Aבsz   Aבt[   Aבu<   Aבv   Aבv   Aבw   Aבx   Aבy   Aבz   Aב{c   Aב|D   Aב}%   Aב~   Aב~   Aב   Aב   Aב   Aבk   AבL   Aב-   Aב   Aב   Aב   Aב   Aב   Aבs   AבT   Aב5   Aב   Aב   Aב   Aב   Aב   Aב{   Aב\   Aב=   Aב   Aב   Aב   Aב   Aב   Aב   Aבd   AבE   Aב&   Aב   Aב   Aב   Aב   Aב   Aבl   AבM   Aב.   Aב   Aב   Aב   Aב   Aב   Aבt   AבU   Aב6   Aב   Aב   Aב   Aב   Aב|   Aב]   Aב>   Aב   Aב    Aב   Aב   Aב   Aב   Aבe   AבF   Aב'   Aב   Aב   Aב   Aב   Aב   Aבm   AבN   Aב/   Aב   Aב   Aב   Aב   Aב   Aבu   AבV   Aב7   Aב   Aב   Aב   AבȻ   Aבɜ   Aב}   Aב^   Aב?   Aב    Aב   Aב   Aב   AבФ   Aבх   Aבf   AבG   Aב(   Aב	   Aב   Aב   Aב׬   Aב؍   Aבn   AבO   Aב0   Aב   Aב   Aב   Aב޴   Aבߕ   Aבv   AבW   Aב8   Aב   Aב   Aב   Aב   Aב   Aב~   Aב_   Aב@   Aב!   Aב   Aב   Aב   Aב   Aב   Aבg   AבH   Aב)   Aב
   Aב   Aב   Aב   Aב   Aבo   AבP   Aב1   Aב   Aב   Aב   Aב   Aב   Aבw   AבX   Aב9   Aג    Aג    Aג   Aג   Aג   Aג   Aג`   AגA   Aג"   Aג   Aג   Aג	   Aג
   Aג   Aגh   Aג
I   Aג*   Aג   Aג   Aג   Aג   Aג   Aגp   AגQ   Aג2   Aג   Aג   Aג   Aג   Aג   Aגx   AגY   Aג:   Aג   Aג   Aג   Aג   Aג    Aג!   Aג"a   Aג#B   Aג$#   Aג%   Aג%   Aג&   Aג'   Aג(   Aג)i   Aג*J   Aג++   Aג,   Aג,   Aג-   Aג.   Aג/   Aג0q   Aג1R   Aג23   Aג3   Aג3   Aג4   Aג5   Aג6   Aג7y   Aג8Z   Aג9;   Aג:   Aג:   Aג;   Aג<   Aג=   Aג>   Aג?b   Aג@C   AגA$   AגB   AגB   AגC   AגD   AגE   AגFj   AגGK   AגH,   AגI
   AגI   AגJ   AגK   AגL   AגMr   AגNS   AגO4   AגP   AגP   AגQ   AגR   AגS   AגTz   AגU[   AגV<   AגW   AגW   AגX   AגY   AגZ   Aג[   Aג\c   Aג]D   Aג^%   Aג_   Aג_   Aג`   Aגa   Aגb   Aגck   AגdL   Aגe-   Aגf   Aגf   Aגg   Aגh   Aגi   Aגjs   AגkT   Aגl5   Aגm   Aגm   Aגn   Aגo   Aגp   Aגq{   Aגr\   Aגs=   Aגt   Aגt   Aגu   Aגv   Aגw   Aגx   Aגyd   AגzE   Aג{&   Aג|   Aג|   Aג}   Aג~   Aג   Aגl   AגM   Aג.   Aג   Aג   Aג   Aג   Aג   Aגt   AגU   Aג6   Aג   Aג   Aג   Aג   Aג   Aג|   Aג]   Aג>   Aג   Aג    Aג   Aג   Aג   Aג   Aגe   AגF   Aג'   Aג   Aג   Aג   Aג   Aג   Aגm   AגN   Aג/   Aג   Aג   Aג   Aג   Aגu   AגV   Aג7   Aג   Aג   Aג   Aג   Aג   Aג}   Aג^   Aג?   Aג    Aג   Aג   Aג   Aג   Aג   Aגf   AגG   Aג(   Aג	   Aג   Aג   Aג   Aג   Aגn   AגO   Aג0   Aג   Aג   Aג   Aג   Aג   Aגv   AגW   Aג8   Aג   Aג   Aג   AגƼ   Aגǝ   Aג~   Aג_   Aג@   Aג!   Aג   Aג   Aג   AגΥ   Aגφ   Aגg   AגH   Aג)   Aג
   Aג   Aג   Aגխ   Aג֎   Aגo   AגP   Aג1   Aג   Aג   Aג   Aגܵ   Aגݖ   Aגw   AגX   Aג9   Aג   Aג   Aג   Aג   Aג   Aג   Aג`   AגA   Aג"   Aג   Aג   Aג   Aג   Aג   Aגh   AגI   Aג*   Aג   Aג   Aג   Aג   Aג   Aגp   AגQ   Aג2   Aג   Aג   Aג   Aג   Aג   Aגx   AגY   Aג:   Aג   Aג   Aג   Aד    Aד   Aד   Aדa   AדB   Aד#   Aד   Aד   Aד   Aד	   Aד
i   AדJ   Aד+   Aד
   Aד
   Aד   Aד   Aד   Aדq   AדR   Aד3   Aד   Aד   Aד   Aד   Aד   Aדy   AדZ   Aד;   Aד   Aד   Aד   Aד   Aד   Aד   Aד b   Aד!C   Aד"$   Aד#   Aד#   Aד$   Aד%   Aד&   Aד'j   Aד(K   Aד),   Aד*
   Aד*   Aד+   Aד,   Aד-   Aד.r   Aד/S   Aד04   Aד1   Aד1   Aד2   Aד3   Aד4   Aד5z   Aד6[   Aד7<   Aד8   Aד8   Aד9   Aד:   Aד;   Aד<   Aד=c   Aד>D   Aד?%   Aד@   Aד@   AדA   AדB   AדC   AדDk   AדEL   AדF-   AדG   AדG   AדH   AדI   AדJ   AדKs   AדLT   AדM5   AדN   AדN   AדO   AדP   AדQ   AדR{   AדS\   AדT=   AדU   AדU   AדV   AדW   AדX   AדY   AדZd   Aד[E   Aד\&   Aד]   Aד]   Aד^   Aד_   Aד`   Aדal   AדbM   Aדc.   Aדd   Aדd   Aדe   Aדf   Aדg   Aדht   AדiU   Aדj6   Aדk   Aדk   Aדl   Aדm   Aדn   Aדo|   Aדp]   Aדq>   Aדr   Aדs    Aדs   Aדt   Aדu   Aדv   Aדwe   AדxF   Aדy'   Aדz   Aדz   Aד{   Aד|   Aד}   Aד~m   AדN   Aד/   Aד   Aד   Aד   Aד   Aד   Aדu   AדV   Aד7   Aד   Aד   Aד   Aד   Aד   Aד}   Aד^   Aד?   Aד    Aד   Aד   Aד   Aד   Aד   Aדf   AדG   Aד(   Aד	   Aד   Aד   Aד   Aד   Aדn   AדO   Aד0   Aד   Aד   Aד   Aד   Aד   Aדv   AדW   Aד8   Aד   Aד   Aד   Aד   Aד   Aד~   Aד_   Aד@   Aד!   Aד   Aד   Aד   Aד   Aד   Aדg   AדH   Aד)   Aד
   Aד   Aד   Aד   Aד   Aדo   AדP   Aד1   Aד   Aד   Aד   Aד   Aד   Aדw   AדX   Aד9   Aד   Aד   Aד   AדĽ   AדŞ   Aד   Aד`   AדA   Aד"   Aד   Aד   Aד   Aד̦   Aד͇   Aדh   AדI   Aד*   Aד   Aד   Aד   AדӮ   Aדԏ   Aדp   AדQ   Aד2   Aד   Aד   Aד   Aדڶ   Aדۗ   Aדx   AדY   Aד:   Aד   Aד   Aד   Aד   Aד   Aד   Aדa   AדB   Aד#   Aד   Aד   Aד   Aד   Aד   Aדi   AדJ   Aד+   Aד   Aד   Aד   Aד   Aד   Aדq   AדR   Aד3   Aד   Aד   Aד   Aד   Aד   Aדy   AדZ   Aד;   Aד   Aד   Aד   Aד   Aד   Aה    Aהb   AהC   Aה$   Aה   Aה   Aה   Aה   Aה   Aהj   Aה	K   Aה
,   Aה
   Aה   Aה   Aה
   Aה   Aהr   AהS   Aה4   Aה   Aה   Aה   Aה   Aה   Aהz   Aה[   Aה<   Aה   Aה   Aה   Aה   Aה   Aה   Aהc   AהD   Aה %   Aה!   Aה!   Aה"   Aה#   Aה$   Aה%k   Aה&L   Aה'-   Aה(   Aה(   Aה)   Aה*   Aה+   Aה,s   Aה-T   Aה.5   Aה/   Aה/   Aה0   Aה1   Aה2   Aה3{   Aה4\   Aה5=   Aה6   Aה6   Aה7   Aה8   Aה9   Aה:   Aה;d   Aה<E   Aה=&   Aה>   Aה>   Aה?   Aה@   AהA   AהBl   AהCM   AהD.   AהE   AהE   AהF   AהG   AהH   AהIt   AהJU   AהK6   AהL   AהL   AהM   AהN   AהO   AהP|   AהQ]   AהR>   AהS   AהT    AהT   AהU   AהV   AהW   AהXe   AהYF   AהZ'   Aה[   Aה[   Aה\   Aה]   Aה^   Aה_m   Aה`N   Aהa/   Aהb   Aהb   Aהc   Aהd   Aהe   Aהfu   AהgV   Aהh7   Aהi   Aהi   Aהj   Aהk   Aהl   Aהm}   Aהn^   Aהo?   Aהp    Aהq   Aהq   Aהr   Aהs   Aהt   Aהuf   AהvG   Aהw(   Aהx	   Aהx   Aהy   Aהz   Aה{   Aה|n   Aה}O   Aה~0   Aה   Aה   Aה   Aה   Aה   Aהv   AהW   Aה8   Aה   Aה   Aה   Aה   Aה   Aה~   Aה_   Aה@   Aה!   Aה   Aה   Aה   Aה   Aה   Aהg   AהH   Aה)   Aה
   Aה   Aה   Aה   Aה   Aהo   AהP   Aה1   Aה   Aה   Aה   Aה   Aה   Aהw   AהX   Aה9   Aה   Aה   Aה   Aה   Aה   Aה   Aה`   AהA   Aה"   Aה   Aה   Aה   Aה   Aה   Aהh   AהI   Aה*   Aה   Aה   Aה   Aה   Aה   Aהp   AהQ   Aה2   Aה   Aה   Aה   Aה   Aה   Aהx   AהY   Aה:   Aה   Aה   Aה   Aה¾   Aהß   AהĀ   Aהa   AהB   Aה#   Aה   Aה   Aה   Aהʧ   Aהˈ   Aהi   AהJ   Aה+   Aה   Aה   Aה   Aהѯ   AהҐ   Aהq   AהR   Aה3   Aה   Aה   Aה   Aהط   Aה٘   Aהy   AהZ   Aה;   Aה   Aה   Aה   Aה߿   Aה   Aה   Aהb   AהC   Aה$   Aה   Aה   Aה   Aה   Aה   Aהj   AהK   Aה,   Aה
   Aה   Aה   Aה   Aה   Aהr   AהS   Aה4   Aה   Aה   Aה   Aה   Aה   Aהz   Aה[   Aה<   Aה   Aה   Aה   Aה   Aה   Aה   Aהc   Aו D   Aו%   Aו   Aו   Aו   Aו   Aו   Aוk   AוL   Aו-   Aו	   Aו	   Aו
   Aו   Aו   Aו
s   AוT   Aו5   Aו   Aו   Aו   Aו   Aו   Aו{   Aו\   Aו=   Aו   Aו   Aו   Aו   Aו   Aו   Aוd   AוE   Aו&   Aו   Aו   Aו    Aו!   Aו"   Aו#l   Aו$M   Aו%.   Aו&   Aו&   Aו'   Aו(   Aו)   Aו*t   Aו+U   Aו,6   Aו-   Aו-   Aו.   Aו/   Aו0   Aו1|   Aו2]   Aו3>   Aו4   Aו5    Aו5   Aו6   Aו7   Aו8   Aו9e   Aו:F   Aו;'   Aו<   Aו<   Aו=   Aו>   Aו?   Aו@m   AוAN   AוB/   AוC   AוC   AוD   AוE   AוF   AוGu   AוHV   AוI7   AוJ   AוJ   AוK   AוL   AוM   AוN}   AוO^   AוP?   AוQ    AוR   AוR   AוS   AוT   AוU   AוVf   AוWG   AוX(   AוY	   AוY   AוZ   Aו[   Aו\   Aו]n   Aו^O   Aו_0   Aו`   Aו`   Aוa   Aוb   Aוc   Aוdv   AוeW   Aוf8   Aוg   Aוg   Aוh   Aוi   Aוj   Aוk~   Aוl_   Aוm@   Aוn!   Aוo   Aוo   Aוp   Aוq   Aוr   Aוsg   AוtH   Aוu)   Aוv
   Aוv   Aוw   Aוx   Aוy   Aוzo   Aו{P   Aו|1   Aו}   Aו}   Aו~   Aו   Aו   Aוw   AוX   Aו9   Aו   Aו   Aו   Aו   Aו   Aו   Aו`   AוA   Aו"   Aו   Aו   Aו   Aו   Aו   Aוh   AוI   Aו*   Aו   Aו   Aו   Aו   Aו   Aוp   AוQ   Aו2   Aו   Aו   Aו   Aו   Aו   Aוx   AוY   Aו:   Aו   Aו   Aו   Aו   Aו   Aו   Aוa   AוB   Aו#   Aו   Aו   Aו   Aו   Aו   Aוi   AוJ   Aו+   Aו   Aו   Aו   Aו   Aו   Aוq   AוR   Aו3   Aו   Aו   Aו   Aו   Aו   Aוy   AוZ   Aו;   Aו   Aו   Aו   Aו   Aו   Aו   Aוb   AוC   Aו$   Aו   Aו   Aו   AוȨ   Aוɉ   Aוj   AוK   Aו,   Aו
   Aו   Aו   Aוϰ   AוБ   Aוr   AוS   Aו4   Aו   Aו   Aו   Aוָ   Aוי   Aוz   Aו[   Aו<   Aו   Aו   Aו   Aו   Aוޡ   Aו߂   Aוc   AוD   Aו%   Aו   Aו   Aו   Aו   Aו   Aוk   AוL   Aו-   Aו   Aו   Aו   Aו   Aו   Aוs   AוT   Aו5   Aו   Aו   Aו   Aו   Aו   Aו{   Aו\   Aו=   Aו   Aו   Aו   Aו   Aו   Aו   Aוd   AוE   Aו&   Aז    Aז    Aז   Aז   Aז   Aזl   AזM   Aז.   Aז   Aז   Aז   Aז	   Aז
   Aזt   AזU   Aז
6   Aז   Aז   Aז   Aז   Aז   Aז|   Aז]   Aז>   Aז   Aז    Aז   Aז   Aז   Aז   Aזe   AזF   Aז'   Aז   Aז   Aז   Aז   Aז    Aז!m   Aז"N   Aז#/   Aז$   Aז$   Aז%   Aז&   Aז'   Aז(u   Aז)V   Aז*7   Aז+   Aז+   Aז,   Aז-   Aז.   Aז/}   Aז0^   Aז1?   Aז2    Aז3   Aז3   Aז4   Aז5   Aז6   Aז7f   Aז8G   Aז9(   Aז:	   Aז:   Aז;   Aז<   Aז=   Aז>n   Aז?O   Aז@0   AזA   AזA   AזB   AזC   AזD   AזEv   AזFW   AזG8   AזH   AזH   AזI   AזJ   AזK   AזL~   AזM_   AזN@   AזO!   AזP   AזP   AזQ   AזR   AזS   AזTg   AזUH   AזV)   AזW
   AזW   AזX   AזY   AזZ   Aז[o   Aז\P   Aז]1   Aז^   Aז^   Aז_   Aז`   Aזa   Aזbw   AזcX   Aזd9   Aזe   Aזe   Aזf   Aזg   Aזh   Aזi   Aזj`   AזkA   Aזl"   Aזm   Aזm   Aזn   Aזo   Aזp   Aזqh   AזrI   Aזs*   Aזt   Aזt   Aזu   Aזv   Aזw   Aזxp   AזyQ   Aזz2   Aז{   Aז{   Aז|   Aז}   Aז~   Aזx   AזY   Aז:   Aז   Aז   Aז   Aז   Aז   Aז   Aזa   AזB   Aז#   Aז   Aז   Aז   Aז   Aז   Aזi   AזJ   Aז+   Aז   Aז   Aז   Aז   Aז   Aזq   AזR   Aז3   Aז   Aז   Aז   Aז   Aז   Aזy   AזZ   Aז;   Aז   Aז   Aז   Aז   Aז   Aז   Aזb   AזC   Aז$   Aז   Aז   Aז   Aז   Aז   Aזj   AזK   Aז,   Aז
   Aז   Aז   Aז   Aז   Aזr   AזS   Aז4   Aז   Aז   Aז   Aז   Aז   Aזz   Aז[   Aז<   Aז   Aז   Aז   Aז   Aז   Aז   Aזc   AזD   Aז%   Aז   Aז   Aז   AזƩ   AזǊ   Aזk   AזL   Aז-   Aז   Aז   Aז   Aזͱ   AזΒ   Aזs   AזT   Aז5   Aז   Aז   Aז   AזԹ   Aז՚   Aז{   Aז\   Aז=   Aז   Aז   Aז   Aז   Aזܢ   Aז݃   Aזd   AזE   Aז&   Aז   Aז   Aז   Aז   Aז   Aזl   AזM   Aז.   Aז   Aז   Aז   Aז   Aז   Aזt   AזU   Aז6   Aז   Aז   Aז   Aז   Aז   Aז|   Aז]   Aז>   Aז   Aז    Aז   Aז   Aז   Aז   Aזe   AזF   Aז'   Aז   Aז   Aז   Aח    Aח   Aחm   AחN   Aח/   Aח   Aח   Aח   Aח   Aח   Aח	u   Aח
V   Aח7   Aח   Aח   Aח
   Aח   Aח   Aח}   Aח^   Aח?   Aח    Aח   Aח   Aח   Aח   Aח   Aחf   AחG   Aח(   Aח	   Aח   Aח   Aח   Aח   Aחn   Aח O   Aח!0   Aח"   Aח"   Aח#   Aח$   Aח%   Aח&v   Aח'W   Aח(8   Aח)   Aח)   Aח*   Aח+   Aח,   Aח-~   Aח._   Aח/@   Aח0!   Aח1   Aח1   Aח2   Aח3   Aח4   Aח5g   Aח6H   Aח7)   Aח8
   Aח8   Aח9   Aח:   Aח;   Aח<o   Aח=P   Aח>1   Aח?   Aח?   Aח@   AחA   AחB   AחCw   AחDX   AחE9   AחF   AחF   AחG   AחH   AחI   AחJ   AחK`   AחLA   AחM"   AחN   AחN   AחO   AחP   AחQ   AחRh   AחSI   AחT*   AחU   AחU   AחV   AחW   AחX   AחYp   AחZQ   Aח[2   Aח\   Aח\   Aח]   Aח^   Aח_   Aח`x   AחaY   Aחb:   Aחc   Aחc   Aחd   Aחe   Aחf   Aחg   Aחha   AחiB   Aחj#   Aחk   Aחk   Aחl   Aחm   Aחn   Aחoi   AחpJ   Aחq+   Aחr   Aחr   Aחs   Aחt   Aחu   Aחvq   AחwR   Aחx3   Aחy   Aחy   Aחz   Aח{   Aח|   Aח}y   Aח~Z   Aח;   Aח   Aח   Aח   Aח   Aח   Aח   Aחb   AחC   Aח$   Aח   Aח   Aח   Aח   Aח   Aחj   AחK   Aח,   Aח
   Aח   Aח   Aח   Aח   Aחr   AחS   Aח4   Aח   Aח   Aח   Aח   Aח   Aחz   Aח[   Aח<   Aח   Aח   Aח   Aח   Aח   Aח   Aחc   AחD   Aח%   Aח   Aח   Aח   Aח   Aח   Aחk   AחL   Aח-   Aח   Aח   Aח   Aח   Aח   Aחs   AחT   Aח5   Aח   Aח   Aח   Aח   Aח   Aח{   Aח\   Aח=   Aח   Aח   Aח   Aח   Aח   Aח   Aחd   AחE   Aח&   Aח   Aח   Aח   AחĪ   Aחŋ   Aחl   AחM   Aח.   Aח   Aח   Aח   Aח˲   Aח̓   Aחt   AחU   Aח6   Aח   Aח   Aח   AחҺ   Aחӛ   Aח|   Aח]   Aח>   Aח   Aח    Aח   Aח   Aחڣ   Aחۄ   Aחe   AחF   Aח'   Aח   Aח   Aח   Aח   Aח   Aחm   AחN   Aח/   Aח   Aח   Aח   Aח   Aח   Aחu   AחV   Aח7   Aח   Aח   Aח   Aח   Aח   Aח}   Aח^   Aח?   Aח    Aח   Aח   Aח   Aח   Aח   Aחf   AחG   Aח(   Aח	   Aח   Aח   Aח   Aח   Aט n   AטO   Aט0   Aט   Aט   Aט   Aט   Aט   Aטv   AטW   Aט	8   Aט
   Aט
   Aט   Aט   Aט
   Aט~   Aט_   Aט@   Aט!   Aט   Aט   Aט   Aט   Aט   Aטg   AטH   Aט)   Aט
   Aט   Aט   Aט   Aט   Aטo   AטP   Aט1   Aט    Aט    Aט!   Aט"   Aט#   Aט$w   Aט%X   Aט&9   Aט'   Aט'   Aט(   Aט)   Aט*   Aט+   Aט,`   Aט-A   Aט."   Aט/   Aט/   Aט0   Aט1   Aט2   Aט3h   Aט4I   Aט5*   Aט6   Aט6   Aט7   Aט8   Aט9   Aט:p   Aט;Q   Aט<2   Aט=   Aט=   Aט>   Aט?   Aט@   AטAx   AטBY   AטC:   AטD   AטD   AטE   AטF   AטG   AטH   AטIa   AטJB   AטK#   AטL   AטL   AטM   AטN   AטO   AטPi   AטQJ   AטR+   AטS   AטS   AטT   AטU   AטV   AטWq   AטXR   AטY3   AטZ   AטZ   Aט[   Aט\   Aט]   Aט^y   Aט_Z   Aט`;   Aטa   Aטa   Aטb   Aטc   Aטd   Aטe   Aטfb   AטgC   Aטh$   Aטi   Aטi   Aטj   Aטk   Aטl   Aטmj   AטnK   Aטo,   Aטp
   Aטp   Aטq   Aטr   Aטs   Aטtr   AטuS   Aטv4   Aטw   Aטw   Aטx   Aטy   Aטz   Aט{z   Aט|[   Aט}<   Aט~   Aט~   Aט   Aט   Aט   Aט   Aטc   AטD   Aט%   Aט   Aט   Aט   Aט   Aט   Aטk   AטL   Aט-   Aט   Aט   Aט   Aט   Aט   Aטs   AטT   Aט5   Aט   Aט   Aט   Aט   Aט   Aט{   Aט\   Aט=   Aט   Aט   Aט   Aט   Aט   Aט   Aטd   AטE   Aט&   Aט   Aט   Aט   Aט   Aט   Aטl   AטM   Aט.   Aט   Aט   Aט   Aט   Aט   Aטt   AטU   Aט6   Aט   Aט   Aט   Aט   Aט   Aט|   Aט]   Aט>   Aט   Aט    Aט   Aט   Aט   Aט   Aטe   AטF   Aט'   Aט   Aט   Aט   Aט«   AטÌ   Aטm   AטN   Aט/   Aט   Aט   Aט   Aטɳ   Aטʔ   Aטu   AטV   Aט7   Aט   Aט   Aט   Aטл   Aטќ   Aט}   Aט^   Aט?   Aט    Aט   Aט   Aט   Aטؤ   Aטم   Aטf   AטG   Aט(   Aט	   Aט   Aט   Aט߬   Aט~   Aט_   Aט@   Aט!   Aט   Aט   Aט   Aט   Aט   Aטg   AטH   Aט)   Aט
   Aט   Aט   Aט   Aט   Aטo   AטP   Aי 1   Aי   Aי   Aי   Aי   Aי   Aיw   AיX   Aי9   Aי   Aי   Aי	   Aי
   Aי   Aי   Aי
`   AיA   Aי"   Aי   Aי   Aי   Aי   Aי   Aיh   AיI   Aי*   Aי   Aי   Aי   Aי   Aי   Aיp   AיQ   Aי2   Aי   Aי   Aי   Aי    Aי!   Aי"x   Aי#Y   Aי$:   Aי%   Aי%   Aי&   Aי'   Aי(   Aי)   Aי*a   Aי+B   Aי,#   Aי-   Aי-   Aי.   Aי/   Aי0   Aי1i   Aי2J   Aי3+   Aי4   Aי4   Aי5   Aי6   Aי7   Aי8q   Aי9R   Aי:3   Aי;   Aי;   Aי<   Aי=   Aי>   Aי?y   Aי@Z   AיA;   AיB   AיB   AיC   AיD   AיE   AיF   AיGb   AיHC   AיI$   AיJ   AיJ   AיK   AיL   AיM   AיNj   AיOK   AיP,   AיQ
   AיQ   AיR   AיS   AיT   AיUr   AיVS   AיW4   AיX   AיX   AיY   AיZ   Aי[   Aי\z   Aי][   Aי^<   Aי_   Aי_   Aי`   Aיa   Aיb   Aיc   Aיdc   AיeD   Aיf%   Aיg   Aיg   Aיh   Aיi   Aיj   Aיkk   AיlL   Aיm-   Aיn   Aיn   Aיo   Aיp   Aיq   Aיrs   AיsT   Aיt5   Aיu   Aיu   Aיv   Aיw   Aיx   Aיy{   Aיz\   Aי{=   Aי|   Aי|   Aי}   Aי~   Aי   Aי   Aיd   AיE   Aי&   Aי   Aי   Aי   Aי   Aי   Aיl   AיM   Aי.   Aי   Aי   Aי   Aי   Aי   Aיt   AיU   Aי6   Aי   Aי   Aי   Aי   Aי   Aי|   Aי]   Aי>   Aי   Aי    Aי   Aי   Aי   Aי   Aיe   AיF   Aי'   Aי   Aי   Aי   Aי   Aי   Aיm   AיN   Aי/   Aי   Aי   Aי   Aי   Aי   Aיu   AיV   Aי7   Aי   Aי   Aי   Aי   Aי   Aי}   Aי^   Aי?   Aי    Aי   Aי   Aי   Aי   Aי   Aיf   AיG   Aי(   Aי	   Aי   Aי   Aי   Aי   Aיn   AיO   Aי0   Aי   Aי   Aי   AיǴ   Aיȕ   Aיv   AיW   Aי8   Aי   Aי   Aי   Aיμ   Aיϝ   Aי~   Aי_   Aי@   Aי!   Aי   Aי   Aי   Aי֥   Aי׆   Aיg   AיH   Aי)   Aי
   Aי   Aי   Aיݭ   Aיގ   Aיo   AיP   Aי1   Aי   Aי   Aי   Aי   Aי   Aיw   AיX   Aי9   Aי   Aי   Aי   Aי   Aי   Aי   Aי`   AיA   Aי"   Aי   Aי   Aי   Aי   Aי   Aיh   AיI   Aי*   Aי   Aי   Aי   Aי   Aי   Aיp   AיQ   Aי2   Aי   Aי   Aך    Aך   Aך   Aךx   AךY   Aך:   Aך   Aך   Aך   Aך   Aך	   Aך
   Aךa   AךB   Aך
#   Aך   Aך   Aך   Aך   Aך   Aךi   AךJ   Aך+   Aך   Aך   Aך   Aך   Aך   Aךq   AךR   Aך3   Aך   Aך   Aך   Aך   Aך   Aך y   Aך!Z   Aך";   Aך#   Aך#   Aך$   Aך%   Aך&   Aך'   Aך(b   Aך)C   Aך*$   Aך+   Aך+   Aך,   Aך-   Aך.   Aך/j   Aך0K   Aך1,   Aך2
   Aך2   Aך3   Aך4   Aך5   Aך6r   Aך7S   Aך84   Aך9   Aך9   Aך:   Aך;   Aך<   Aך=z   Aך>[   Aך?<   Aך@   Aך@   AךA   AךB   AךC   AךD   AךEc   AךFD   AךG%   AךH   AךH   AךI   AךJ   AךK   AךLk   AךML   AךN-   AךO   AךO   AךP   AךQ   AךR   AךSs   AךTT   AךU5   AךV   AךV   AךW   AךX   AךY   AךZ{   Aך[\   Aך\=   Aך]   Aך]   Aך^   Aך_   Aך`   Aךa   Aךbd   AךcE   Aךd&   Aךe   Aךe   Aךf   Aךg   Aךh   Aךil   AךjM   Aךk.   Aךl   Aךl   Aךm   Aךn   Aךo   Aךpt   AךqU   Aךr6   Aךs   Aךs   Aךt   Aךu   Aךv   Aךw|   Aךx]   Aךy>   Aךz   Aך{    Aך{   Aך|   Aך}   Aך~   Aךe   AךF   Aך'   Aך   Aך   Aך   Aך   Aך   Aךm   AךN   Aך/   Aך   Aך   Aך   Aך   Aך   Aךu   AךV   Aך7   Aך   Aך   Aך   Aך   Aך   Aך}   Aך^   Aך?   Aך    Aך   Aך   Aך   Aך   Aך   Aךf   AךG   Aך(   Aך	   Aך   Aך   Aך   Aך   Aךn   AךO   Aך0   Aך   Aך   Aך   Aך   Aך   Aךv   AךW   Aך8   Aך   Aך   Aך   Aך   Aך   Aך~   Aך_   Aך@   Aך!   Aך   Aך   Aך   Aך   Aך   Aךg   AךH   Aך)   Aך
   Aך   Aך   Aך   Aך   Aךo   AךP   Aך1   Aך   Aך   Aך   Aךŵ   AךƖ   Aךw   AךX   Aך9   Aך   Aך   Aך   Aך̽   Aך͞   Aך   Aך`   AךA   Aך"   Aך   Aך   Aך   AךԦ   AךՇ   Aךh   AךI   Aך*   Aך   Aך   Aך   Aךۮ   Aך܏   Aךp   AךQ   Aך2   Aך   Aך   Aך   Aך   Aך   Aךx   AךY   Aך:   Aך   Aך   Aך   Aך   Aך   Aך   Aךa   AךB   Aך#   Aך   Aך   Aך   Aך   Aך   Aךi   AךJ   Aך+   Aך   Aך   Aך   Aך   Aך   Aךq   AךR   Aך3   Aך   Aך   Aך   Aך   Aכ    Aכy   AכZ   Aכ;   Aכ   Aכ   Aכ   Aכ   Aכ   Aכ   Aכ	b   Aכ
C   Aכ$   Aכ   Aכ   Aכ
   Aכ   Aכ   Aכj   AכK   Aכ,   Aכ
   Aכ   Aכ   Aכ   Aכ   Aכr   AכS   Aכ4   Aכ   Aכ   Aכ   Aכ   Aכ   Aכz   Aכ[   Aכ <   Aכ!   Aכ!   Aכ"   Aכ#   Aכ$   Aכ%   Aכ&c   Aכ'D   Aכ(%   Aכ)   Aכ)   Aכ*   Aכ+   Aכ,   Aכ-k   Aכ.L   Aכ/-   Aכ0   Aכ0   Aכ1   Aכ2   Aכ3   Aכ4s   Aכ5T   Aכ65   Aכ7   Aכ7   Aכ8   Aכ9   Aכ:   Aכ;{   Aכ<\   Aכ==   Aכ>   Aכ>   Aכ?   Aכ@   AכA   AכB   AכCd   AכE&   AכF   AכF   AכG   AכH   AכI   AכJl   AכKM   AכL.   AכM   AכM   AכN   AכO   AכP   AכQt   AכRU   AכS6   AכT   AכT   AכU   AכV   AכW   AכX|   AכY]   AכZ>   Aכ[   Aכ\    Aכ\   Aכ]   Aכ^   Aכ_   Aכ`e   AכaF   Aכb'   Aכc   Aכc   Aכd   Aכe   Aכf   Aכgm   AכhN   Aכi/   Aכj   Aכj   Aכk   Aכl   Aכm   Aכnu   AכoV   Aכp7   Aכq   Aכq   Aכr   Aכs   Aכt   Aכu}   Aכv^   Aכw?   Aכx    Aכy   Aכz   Aכ{   Aכ|   Aכ}f   Aכ~G   Aכ(   Aכ	   Aכ   Aכ   Aכ   Aכ   Aכn   AכO   Aכ0   Aכ   Aכ   Aכ   Aכ   Aכ   Aכv   AכW   Aכ8   Aכ   Aכ   Aכ   Aכ   Aכ   Aכ~   Aכ_   Aכ@   Aכ!   Aכ   Aכ   Aכ   Aכ   Aכ   Aכg   AכH   Aכ)   Aכ
   Aכ   Aכ   Aכ   Aכ   Aכo   AכP   Aכ1   Aכ   Aכ   Aכ   Aכ   Aכ   Aכw   AכX   Aכ9   Aכ   Aכ   Aכ   Aכ   Aכ   Aכ   Aכ`   AכA   Aכ"   Aכ   Aכ   Aכ   Aכ   Aכ   Aכh   AכI   Aכ*   Aכ   Aכ   Aכ   Aכ   Aכ   Aכp   AכQ   Aכ2   Aכ   Aכ   Aכ   Aכö   Aכė   Aכx   AכY   Aכ:   Aכ   Aכ   Aכ   Aכʾ   Aכ˟   Aכ̀   Aכa   AכB   Aכ#   Aכ   Aכ   Aכ   Aכҧ   Aכӈ   Aכi   AכJ   Aכ+   Aכ   Aכ   Aכ   Aכٯ   Aכڐ   Aכq   AכR   Aכ3   Aכ   Aכ   Aכ   Aכ   Aכ   Aכy   AכZ   Aכ;   Aכ   Aכ   Aכ   Aכ   Aכ   Aכ   Aכb   AכC   Aכ$   Aכ   Aכ   Aכ   Aכ   Aכ   Aכj   AכK   Aכ,   Aכ
   Aכ   Aכ   Aכ   Aכ   Aכr   AכS   Aכ4   Aכ   Aכ   Aכ   Aכ   Aכ   Aכz   Aל [   Aל<   Aל   Aל   Aל   Aל   Aל   Aל   Aלc   AלD   Aל	%   Aל
   Aל
   Aל   Aל   Aל
   Aלk   AלL   Aל-   Aל   Aל   Aל   Aל   Aל   Aלs   AלT   Aל5   Aל   Aל   Aל   Aל   Aל   Aל{   Aל\   Aל=   Aל   Aל   Aל    Aל!   Aל"   Aל#   Aל$d   Aל%E   Aל&&   Aל'   Aל'   Aל(   Aל)   Aל*   Aל+l   Aל,M   Aל-.   Aל.   Aל.   Aל/   Aל0   Aל1   Aל2t   Aל3U   Aל46   Aל5   Aל5   Aל6   Aל7   Aל8   Aל9|   Aל:]   Aל;>   Aל<   Aל=    Aל=   Aל>   Aל?   Aל@   AלAe   AלBF   AלC'   AלD   AלD   AלE   AלF   AלG   AלHm   AלIN   AלJ/   AלK   AלK   AלL   AלM   AלN   AלOu   AלPV   AלQ7   AלR   AלR   AלS   AלT   AלU   AלV}   AלW^   AלX?   AלY    AלZ   AלZ   Aל[   Aל\   Aל]   Aל^f   Aל_G   Aל`(   Aלa	   Aלa   Aלb   Aלc   Aלd   Aלen   AלfO   Aלg0   Aלh   Aלh   Aלi   Aלj   Aלk   Aלlv   AלmW   Aלn8   Aלo   Aלo   Aלp   Aלq   Aלr   Aלs~   Aלt_   Aלu@   Aלv!   Aלw   Aלw   Aלx   Aלy   Aלz   Aל{g   Aל|H   Aל})   Aל~
   Aל~   Aל   Aל   Aל   Aלo   AלP   Aל1   Aל   Aל   Aל   Aל   Aל   Aלw   AלX   Aל9   Aל   Aל   Aל   Aל   Aל   Aל   Aל`   AלA   Aל"   Aל   Aל   Aל   Aל   Aל   Aלh   AלI   Aל*   Aל   Aל   Aל   Aל   Aל   Aלp   AלQ   Aל2   Aל   Aל   Aל   Aל   Aל   Aלx   AלY   Aל:   Aל   Aל   Aל   Aל   Aל   Aל   Aלa   AלB   Aל#   Aל   Aל   Aל   Aל   Aל   Aלi   AלJ   Aל+   Aל   Aל   Aל   Aל   Aל   Aלq   AלR   Aל3   Aל   Aל   Aל   Aל   Aל   Aלy   AלZ   Aל;   Aל   Aל   Aל   Aלȿ   Aלɠ   Aלʁ   Aלb   AלC   Aל$   Aל   Aל   Aל   AלШ   Aלщ   Aלj   AלK   Aל,   Aל
   Aל   Aל   Aלװ   Aלؑ   Aלr   AלS   Aל4   Aל   Aל   Aל   Aל޸   Aלߙ   Aלz   Aל[   Aל<   Aל   Aל   Aל   Aל   Aל   Aל   Aלc   AלD   Aל%   Aל   Aל   Aל   Aל   Aל   Aלk   AלL   Aל-   Aל   Aל   Aל   Aל   Aל   Aלs   AלT   Aל5   Aל   Aל   Aל   Aל   Aל   Aל{   Aל\   Aל=   Aם    Aם    Aם   Aם   Aם   Aם   Aםd   AםE   Aם&   Aם   Aם   Aם	   Aם
   Aם   Aםl   Aם
M   Aם.   Aם   Aם   Aם   Aם   Aם   Aםt   AםU   Aם6   Aם   Aם   Aם   Aם   Aם   Aם|   Aם]   Aם>   Aם   Aם    Aם   Aם   Aם    Aם!   Aם"e   Aם#F   Aם$'   Aם%   Aם%   Aם&   Aם'   Aם(   Aם)m   Aם*N   Aם+/   Aם,   Aם,   Aם-   Aם.   Aם/   Aם0u   Aם1V   Aם27   Aם3   Aם3   Aם4   Aם5   Aם6   Aם7}   Aם8^   Aם9?   Aם:    Aם;   Aם;   Aם<   Aם=   Aם>   Aם?f   Aם@G   AםA(   AםB	   AםB   AםC   AםD   AםE   AםFn   AםGO   AםH0   AםI   AםI   AםJ   AםK   AםL   AםMv   AםNW   AםO8   AםP   AםP   AםQ   AםR   AםS   AםT~   AםU_   AםV@   AםW!   AםX   AםX   AםY   AםZ   Aם[   Aם\g   Aם]H   Aם^)   Aם_
   Aם_   Aם`   Aםa   Aםb   Aםco   AםdP   Aםe1   Aםf   Aםf   Aםg   Aםh   Aםi   Aםjw   AםkX   Aםl9   Aםm   Aםm   Aםn   Aםo   Aםp   Aםq   Aםr`   AםsA   Aםt"   Aםu   Aםu   Aםv   Aםw   Aםx   Aםyh   AםzI   Aם{*   Aם|   Aם|   Aם}   Aם~   Aם   Aםp   AםQ   Aם2   Aם   Aם   Aם   Aם   Aם   Aםx   AםY   Aם:   Aם   Aם   Aם   Aם   Aם   Aם   Aםa   AםB   Aם#   Aם   Aם   Aם   Aם   Aם   Aםi   AםJ   Aם+   Aם   Aם   Aם   Aם   Aם   Aםq   AםR   Aם3   Aם   Aם   Aם   Aם   Aם   Aםy   AםZ   Aם;   Aם   Aם   Aם   Aם   Aם   Aם   Aםb   AםC   Aם$   Aם   Aם   Aם   Aם   Aם   Aםj   AםK   Aם,   Aם
   Aם   Aם   Aם   Aם   Aםr   AםS   Aם4   Aם   Aם   Aם   Aם   Aם   Aםz   Aם[   Aם<   Aם   Aם   Aם   Aם   Aםǡ   AםȂ   Aםc   AםD   Aם%   Aם   Aם   Aם   AםΩ   Aםϊ   Aםk   AםL   Aם-   Aם   Aם   Aם   Aםձ   Aם֒   Aםs   AםT   Aם5   Aם   Aם   Aם   Aםܹ   Aםݚ   Aם{   Aם\   Aם=   Aם   Aם   Aם   Aם   Aם   Aם   Aםd   AםE   Aם&   Aם   Aם   Aם   Aם   Aם   Aםl   AםM   Aם.   Aם   Aם   Aם   Aם   Aם   Aםt   AםU   Aם6   Aם   Aם   Aם   Aם   Aם   Aם|   Aם]   Aם>   Aם   Aם    Aם   Aמ    Aמ   Aמ   Aמe   AמF   Aמ'   Aמ   Aמ   Aמ   Aמ   Aמ	   Aמ
m   AמN   Aמ/   Aמ
   Aמ
   Aמ   Aמ   Aמ   Aמu   AמV   Aמ7   Aמ   Aמ   Aמ   Aמ   Aמ   Aמ}   Aמ^   Aמ?   Aמ    Aמ   Aמ   Aמ   Aמ   Aמ   Aמ f   Aמ!G   Aמ"(   Aמ#	   Aמ#   Aמ$   Aמ%   Aמ&   Aמ'n   Aמ(O   Aמ)0   Aמ*   Aמ*   Aמ+   Aמ,   Aמ-   Aמ.v   Aמ/W   Aמ08   Aמ1   Aמ1   Aמ2   Aמ3   Aמ4   Aמ5~   Aמ6_   Aמ7@   Aמ8!   Aמ9   Aמ9   Aמ:   Aמ;   Aמ<   Aמ=g   Aמ>H   Aמ?)   Aמ@
   Aמ@   AמA   AמB   AמC   AמDo   AמEP   AמF1   AמG   AמG   AמH   AמI   AמJ   AמKw   AמLX   AמM9   AמN   AמN   AמO   AמP   AמQ   AמR   AמS`   AמTA   AמU"   AמV   AמV   AמW   AמX   AמY   AמZh   Aמ[I   Aמ\*   Aמ]   Aמ]   Aמ^   Aמ_   Aמ`   Aמap   AמbQ   Aמc2   Aמd   Aמd   Aמe   Aמf   Aמg   Aמhx   AמiY   Aמj:   Aמk   Aמk   Aמl   Aמm   Aמn   Aמo   Aמpa   AמqB   Aמr#   Aמs   Aמs   Aמt   Aמu   Aמv   Aמwi   AמxJ   Aמy+   Aמz   Aמz   Aמ{   Aמ|   Aמ}   Aמ~q   AמR   Aמ3   Aמ   Aמ   Aמ   Aמ   Aמ   Aמy   AמZ   Aמ;   Aמ   Aמ   Aמ   Aמ   Aמ   Aמ   Aמb   AמC   Aמ$   Aמ   Aמ   Aמ   Aמ   Aמ   Aמj   AמK   Aמ,   Aמ
   Aמ   Aמ   Aמ   Aמ   Aמr   AמS   Aמ4   Aמ   Aמ   Aמ   Aמ   Aמ   Aמz   Aמ[   Aמ<   Aמ   Aמ   Aמ   Aמ   Aמ   Aמ   Aמc   AמD   Aמ%   Aמ   Aמ   Aמ   Aמ   Aמ   Aמk   AמL   Aמ-   Aמ   Aמ   Aמ   Aמ   Aמ   Aמs   AמT   Aמ5   Aמ   Aמ   Aמ   Aמ   Aמ   Aמ{   Aמ\   Aמ=   Aמ   Aמ   Aמ   Aמ   AמŢ   Aמƃ   Aמd   AמE   Aמ&   Aמ   Aמ   Aמ   Aמ̪   Aמ͋   Aמl   AמM   Aמ.   Aמ   Aמ   Aמ   AמӲ   Aמԓ   Aמt   AמU   Aמ6   Aמ   Aמ   Aמ   Aמں   Aמۛ   Aמ|   Aמ]   Aמ>   Aמ   Aמ    Aמ   Aמ   Aמ   Aמ   Aמe   AמF   Aמ'   Aמ   Aמ   Aמ   Aמ   Aמ   Aמm   AמN   Aמ/   Aמ   Aמ   Aמ   Aמ   Aמ   Aמu   AמV   Aמ7   Aמ   Aמ   Aמ   Aמ   Aמ   Aמ}   Aמ^   Aמ?   Aמ    Aמ   Aמ   Aמ   Aמ   Aן    Aןf   AןG   Aן(   Aן	   Aן   Aן   Aן   Aן   Aןn   Aן	O   Aן
0   Aן   Aן   Aן   Aן
   Aן   Aןv   AןW   Aן8   Aן   Aן   Aן   Aן   Aן   Aן~   Aן_   Aן@   Aן!   Aן   Aן   Aן   Aן   Aן   Aןg   AןH   Aן )   Aן!
   Aן!   Aן"   Aן#   Aן$   Aן%o   Aן&P   Aן'1   Aן(   Aן(   Aן)   Aן*   Aן+   Aן,w   Aן-X   Aן.9   Aן/   Aן/   Aן0   Aן1   Aן2   Aן3   Aן4`   Aן5A   Aן6"   Aן7   Aן7   Aן8   Aן9   Aן:   Aן;h   Aן<I   Aן=*   Aן>   Aן>   Aן?   Aן@   AןA   AןBp   AןCQ   AןD2   AןE   AןE   AןF   AןG   AןH   AןIx   AןJY   AןK:   AןL   AןL   AןM   AןN   AןO   AןP   AןQa   AןRB   AןS#   AןT   AןT   AןU   AןV   AןW   AןXi   AןYJ   AןZ+   Aן[   Aן[   Aן\   Aן]   Aן^   Aן_q   Aן`R   Aןa3   Aןb   Aןb   Aןc   Aןd   Aןe   Aןfy   AןgZ   Aןh;   Aןi   Aןi   Aןj   Aןk   Aןl   Aןm   Aןnb   AןoC   Aןp$   Aןq   Aןq   Aןr   Aןs   Aןt   Aןuj   AןvK   Aןw,   Aןx
   Aןx   Aןy   Aןz   Aן{   Aן|r   Aן}S   Aן~4   Aן   Aן   Aן   Aן   Aן   Aןz   Aן[   Aן<   Aן   Aן   Aן   Aן   Aן   Aן   Aןc   AןD   Aן%   Aן   Aן   Aן   Aן   Aן   Aןk   AןL   Aן-   Aן   Aן   Aן   Aן   Aן   Aןs   AןT   Aן5   Aן   Aן   Aן   Aן   Aן   Aן{   Aן\   Aן=   Aן   Aן   Aן   Aן   Aן   Aן   Aןd   AןE   Aן&   Aן   Aן   Aן   Aן   Aן   Aןl   AןM   Aן.   Aן   Aן   Aן   Aן   Aן   Aןt   AןU   Aן6   Aן   Aן   Aן   Aן   Aן   Aן|   Aן]   Aן>   Aן   Aן    Aן   Aן   Aןã   AןĄ   Aןe   AןF   Aן'   Aן   Aן   Aן   Aןʫ   Aןˌ   Aןm   AןN   Aן/   Aן   Aן   Aן   Aןѳ   AןҔ   Aןu   AןV   Aן7   Aן   Aן   Aן   Aןػ   Aןٜ   Aן}   Aן^   Aן?   Aן    Aן   Aן   Aן   Aן   Aן   Aןf   AןG   Aן(   Aן	   Aן   Aן   Aן   Aן   Aןn   AןO   Aן0   Aן   Aן   Aן   Aן   Aן   Aןv   AןW   Aן8   Aן   Aן   Aן   Aן   Aן   Aן~   Aן_   Aן@   Aן!   Aן   Aן   Aן   Aן   Aן   Aןg   Aנ H   Aנ)   Aנ
   Aנ   Aנ   Aנ   Aנ   Aנo   AנP   Aנ1   Aנ	   Aנ	   Aנ
   Aנ   Aנ   Aנ
w   AנX   Aנ9   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ`   AנA   Aנ"   Aנ   Aנ   Aנ   Aנ   Aנ   Aנh   AנI   Aנ*   Aנ   Aנ   Aנ    Aנ!   Aנ"   Aנ#p   Aנ$Q   Aנ%2   Aנ&   Aנ&   Aנ'   Aנ(   Aנ)   Aנ*x   Aנ+Y   Aנ,:   Aנ-   Aנ-   Aנ.   Aנ/   Aנ0   Aנ1   Aנ2a   Aנ3B   Aנ4#   Aנ5   Aנ5   Aנ6   Aנ7   Aנ8   Aנ9i   Aנ:J   Aנ;+   Aנ<   Aנ<   Aנ=   Aנ>   Aנ?   Aנ@q   AנAR   AנB3   AנC   AנC   AנD   AנE   AנF   AנGy   AנHZ   AנI;   AנJ   AנJ   AנK   AנL   AנM   AנN   AנOb   AנPC   AנQ$   AנR   AנR   AנS   AנT   AנU   AנVj   AנWK   AנX,   AנY
   AנY   AנZ   Aנ[   Aנ\   Aנ]r   Aנ^S   Aנ_4   Aנ`   Aנ`   Aנa   Aנb   Aנc   Aנdz   Aנe[   Aנf<   Aנg   Aנg   Aנh   Aנi   Aנj   Aנk   Aנlc   AנmD   Aנn%   Aנo   Aנo   Aנp   Aנq   Aנr   Aנsk   AנtL   Aנu-   Aנv   Aנv   Aנw   Aנx   Aנy   Aנzs   Aנ{T   Aנ|5   Aנ}   Aנ}   Aנ~   Aנ   Aנ   Aנ{   Aנ\   Aנ=   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ   Aנd   AנE   Aנ&   Aנ   Aנ   Aנ   Aנ   Aנ   Aנl   AנM   Aנ.   Aנ   Aנ   Aנ   Aנ   Aנ   Aנt   AנU   Aנ6   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ|   Aנ]   Aנ>   Aנ   Aנ    Aנ   Aנ   Aנ   Aנ   Aנe   AנF   Aנ'   Aנ   Aנ   Aנ   Aנ   Aנ   Aנm   AנN   Aנ/   Aנ   Aנ   Aנ   Aנ   Aנ   Aנu   AנV   Aנ7   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ}   Aנ^   Aנ?   Aנ    Aנ   Aנ   Aנ   Aנ   Aנ   Aנf   AנG   Aנ(   Aנ	   Aנ   Aנ   AנȬ   Aנɍ   Aנn   AנO   Aנ0   Aנ   Aנ   Aנ   Aנϴ   AנЕ   Aנv   AנW   Aנ8   Aנ   Aנ   Aנ   Aנּ   Aנם   Aנ~   Aנ_   Aנ@   Aנ!   Aנ   Aנ   Aנ   Aנޥ   Aנ߆   Aנg   AנH   Aנ)   Aנ
   Aנ   Aנ   Aנ   Aנ   Aנo   AנP   Aנ1   Aנ   Aנ   Aנ   Aנ   Aנ   Aנw   AנX   Aנ9   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ   Aנ`   AנA   Aנ"   Aנ   Aנ   Aנ   Aנ   Aנ   Aנh   AנI   Aנ*   Aס    Aס    Aס   Aס   Aס   Aסp   AסQ   Aס2   Aס   Aס   Aס   Aס	   Aס
   Aסx   AסY   Aס
:   Aס   Aס   Aס   Aס   Aס   Aס   Aסa   AסB   Aס#   Aס   Aס   Aס   Aס   Aס   Aסi   AסJ   Aס+   Aס   Aס   Aס   Aס   Aס    Aס!q   Aס"R   Aס#3   Aס$   Aס$   Aס%   Aס&   Aס'   Aס(y   Aס)Z   Aס*;   Aס+   Aס+   Aס,   Aס-   Aס.   Aס/   Aס0b   Aס1C   Aס2$   Aס3   Aס3   Aס4   Aס5   Aס6   Aס7j   Aס8K   Aס9,   Aס:
   Aס:   Aס;   Aס<   Aס=   Aס>r   Aס?S   Aס@4   AסA   AסA   AסB   AסC   AסD   AסEz   AסF[   AסG<   AסH   AסH   AסI   AסJ   AסK   AסL   AסMc   AסND   AסO%   AסP   AסP   AסQ   AסR   AסS   AסTk   AסUL   AסV-   AסW   AסW   AסX   AסY   AסZ   Aס[s   Aס\T   Aס]5   Aס^   Aס^   Aס_   Aס`   Aסa   Aסb{   Aסc\   Aסd=   Aסe   Aסe   Aסf   Aסg   Aסh   Aסi   Aסjd   AסkE   Aסl&   Aסm   Aסm   Aסn   Aסo   Aסp   Aסql   AסrM   Aסs.   Aסt   Aסt   Aסu   Aסv   Aסw   Aסxt   AסyU   Aסz6   Aס{   Aס{   Aס|   Aס}   Aס~   Aס|   Aס]   Aס>   Aס   Aס    Aס   Aס   Aס   Aס   Aסe   AסF   Aס'   Aס   Aס   Aס   Aס   Aס   Aסm   AסN   Aס/   Aס   Aס   Aס   Aס   Aס   Aסu   AסV   Aס7   Aס   Aס   Aס   Aס   Aס   Aס}   Aס^   Aס?   Aס    Aס   Aס   Aס   Aס   Aס   Aסf   AסG   Aס(   Aס	   Aס   Aס   Aס   Aס   Aסn   AסO   Aס0   Aס   Aס   Aס   Aס   Aס   Aסv   AסW   Aס8   Aס   Aס   Aס   Aס   Aס   Aס~   Aס_   Aס@   Aס!   Aס   Aס   Aס   Aס   Aס   Aסg   AסH   Aס)   Aס
   Aס   Aס   Aסƭ   Aסǎ   Aסo   AסP   Aס1   Aס   Aס   Aס   Aס͵   AסΖ   Aסw   AסX   Aס9   Aס   Aס   Aס   AסԽ   Aס՞   Aס   Aס`   AסA   Aס"   Aס   Aס   Aס   Aסܦ   Aס݇   Aסh   AסI   Aס*   Aס   Aס   Aס   Aס   Aס   Aסp   AסQ   Aס2   Aס   Aס   Aס   Aס   Aס   Aסx   AסY   Aס:   Aס   Aס   Aס   Aס   Aס   Aס   Aסa   AסB   Aס#   Aס   Aס   Aס   Aס   Aס   Aסi   AסJ   Aס+   Aס   Aס   Aס   Aע    Aע   Aעq   AעR   Aע3   Aע   Aע   Aע   Aע   Aע   Aע	y   Aע
Z   Aע;   Aע   Aע   Aע
   Aע   Aע   Aע   Aעb   AעC   Aע$   Aע   Aע   Aע   Aע   Aע   Aעj   AעK   Aע,   Aע
   Aע   Aע   Aע   Aע   Aעr   Aע S   Aע!4   Aע"   Aע"   Aע#   Aע$   Aע%   Aע&z   Aע'[   Aע(<   Aע)   Aע)   Aע*   Aע+   Aע,   Aע-   Aע.c   Aע/D   Aע0%   Aע1   Aע1   Aע2   Aע3   Aע4   Aע5k   Aע6L   Aע7-   Aע8   Aע8   Aע9   Aע:   Aע;   Aע<s   Aע=T   Aע>5   Aע?   Aע?   Aע@   AעA   AעB   AעC{   AעD\   AעE=   AעF   AעF   AעG   AעH   AעI   AעJ   AעKd   AעLE   AעM&   AעN   AעN   AעO   AעP   AעQ   AעRl   AעSM   AעT.   AעU   AעU   AעV   AעW   AעX   AעYt   AעZU   Aע[6   Aע\   Aע\   Aע]   Aע^   Aע_   Aע`|   Aעa]   Aעb>   Aעc   Aעd    Aעd   Aעe   Aעf   Aעg   Aעhe   AעiF   Aעj'   Aעk   Aעk   Aעl   Aעm   Aעn   Aעom   AעpN   Aעq/   Aעr   Aעr   Aעs   Aעt   Aעu   Aעvu   AעwV   Aעx7   Aעy   Aעy   Aעz   Aע{   Aע|   Aע}}   Aע~^   Aע?   Aע    Aע   Aע   Aע   Aע   Aע   Aעf   AעG   Aע(   Aע	   Aע   Aע   Aע   Aע   Aעn   AעO   Aע0   Aע   Aע   Aע   Aע   Aע   Aעv   AעW   Aע8   Aע   Aע   Aע   Aע   Aע   Aע~   Aע_   Aע@   Aע!   Aע   Aע   Aע   Aע   Aע   Aעg   AעH   Aע)   Aע
   Aע   Aע   Aע   Aע   Aעo   AעP   Aע1   Aע   Aע   Aע   Aע   Aע   Aעw   AעX   Aע9   Aע   Aע   Aע   Aע   Aע   Aע   AעQ   Aע2   Aע   Aע   Aע   Aע˶   Aע̗   Aעx   AעY   Aע:   Aע   Aע   Aע   AעҾ   Aעӟ   AעԀ   Aעa   AעB   Aע#   Aע   Aע   Aע   Aעڧ   Aעۈ   Aעi   AעJ   Aע+   Aע   Aע   Aע   Aע   Aע   Aעq   AעR   Aע3   Aע   Aע   Aע   Aע   Aע   Aעy   AעZ   Aע;   Aע   Aע   Aע   Aע   Aע   Aע   Aעb   AעC   Aע$   Aע   Aע   Aע   Aע   Aע   Aעj   AעK   Aע,   Aע
   Aע   Aע   Aע   Aע   Aף r   AףS   Aף4   Aף   Aף   Aף   Aף   Aף   Aףz   Aף[   Aף	<   Aף
   Aף   Aף   Aף
   Aף   Aףc   AףD   Aף%   Aף   Aף   Aף   Aף   Aף   Aףk   AףL   Aף-   Aף   Aף   Aף   Aף   Aף   Aףs   AףT   Aף5   Aף    Aף    Aף!   Aף"   Aף#   Aף${   Aף%\   Aף&=   Aף'   Aף'   Aף(   Aף)   Aף*   Aף+   Aף,d   Aף-E   Aף.&   Aף/   Aף/   Aף0   Aף1   Aף2   Aף3l   Aף4M   Aף5.   Aף6   Aף6   Aף7   Aף8   Aף9   Aף:t   Aף;U   Aף<6   Aף=   Aף=   Aף>   Aף?   Aף@   AףA|   AףB]   AףC>   AףD   AףE    AףE   AףF   AףG   AףH   AףIe   AףJF   AףK'   AףL   AףL   AףM   AףN   AףO   AףPm   AףQN   AףR/   AףS   AףS   AףT   AףU   AףV   AףWu   AףXV   AףY7   AףZ   AףZ   Aף[   Aף\   Aף]   Aף^}   Aף_^   Aף`?   Aףa    Aףb   Aףb   Aףc   Aףd   Aףe   Aףff   AףgG   Aףh(   Aףi	   Aףi   Aףj   Aףk   Aףl   Aףmn   AףnO   Aףo0   Aףp   Aףp   Aףq   Aףr   Aףs   Aףtv   AףuW   Aףv8   Aףw   Aףw   Aףx   Aףy   Aףz   Aף{~   Aף|_   Aף}@   Aף~!   Aף   Aף   Aף   Aף   Aף   Aףg   AףH   Aף)   Aף
   Aף   Aף   Aף   Aף   Aףo   AףP   Aף1   Aף   Aף   Aף   Aף   Aף   Aףw   AףX   Aף9   Aף   Aף   Aף   Aף   Aף   Aף   Aף`   AףA   Aף"   Aף   Aף   Aף   Aף   Aף   Aףh   AףI   Aף*   Aף   Aף   Aף   Aף   Aף   Aףp   AףQ   Aף2   Aף   Aף   Aף   Aף   Aף   Aףx   AףY   Aף:   Aף   Aף   Aף   Aף   Aף   Aף   Aףa   AףB   Aף#   Aף   Aף   Aף   Aף   Aף   Aףi   AףJ   Aף+   Aף   Aף   Aף   Aף¯   AףÐ   Aףq   AףR   Aף3   Aף   Aף   Aף   Aףɷ   Aףʘ   Aףy   AףZ   Aף;   Aף   Aף   Aף   Aףп   AףѠ   Aףҁ   Aףb   AףC   Aף$   Aף   Aף   Aף   Aףب   Aףى   Aףj   AףK   Aף,   Aף
   Aף   Aף   Aף߰   Aף   Aףr   AףS   Aף4   Aף   Aף   Aף   Aף   Aף   Aףz   Aף[   Aף<   Aף   Aף   Aף   Aף   Aף   Aף   Aףc   AףD   Aף%   Aף   Aף   Aף   Aף   Aף   Aףk   AףL   Aף-   Aף   Aף   Aף   Aף   Aף   Aףs   AףT   Aפ 5   Aפ   Aפ   Aפ   Aפ   Aפ   Aפ{   Aפ\   Aפ=   Aפ   Aפ   Aפ	   Aפ
   Aפ   Aפ   Aפ
d   AפE   Aפ&   Aפ   Aפ   Aפ   Aפ   Aפ   Aפl   AפM   Aפ.   Aפ   Aפ   Aפ   Aפ   Aפ   Aפt   AפU   Aפ6   Aפ   Aפ   Aפ   Aפ    Aפ!   Aפ"|   Aפ#]   Aפ$>   Aפ%   Aפ&    Aפ&   Aפ'   Aפ(   Aפ)   Aפ*e   Aפ+F   Aפ,'   Aפ-   Aפ-   Aפ.   Aפ/   Aפ0   Aפ1m   Aפ2N   Aפ3/   Aפ4   Aפ4   Aפ5   Aפ6   Aפ7   Aפ8u   Aפ9V   Aפ:7   Aפ;   Aפ;   Aפ<   Aפ=   Aפ>   Aפ?}   Aפ@^   AפA?   AפB    AפC   AפC   AפD   AפE   AפF   AפGf   AפHG   AפI(   AפJ	   AפJ   AפK   AפL   AפM   AפNn   AפOO   AפP0   AפQ   AפQ   AפR   AפS   AפT   AפUv   AפVW   AפW8   AפX   AפX   AפY   AפZ   Aפ[   Aפ\~   Aפ]_   Aפ^@   Aפ_!   Aפ`   Aפ`   Aפa   Aפb   Aפc   Aפdg   AפeH   Aפf)   Aפg
   Aפg   Aפh   Aפi   Aפj   Aפko   AפlP   Aפm1   Aפn   Aפn   Aפo   Aפp   Aפq   Aפrw   AפsX   Aפt9   Aפu   Aפu   Aפv   Aפw   Aפx   Aפy   Aפz`   Aפ{A   Aפ|"   Aפ}   Aפ}   Aפ~   Aפ   Aפ   Aפh   AפI   Aפ*   Aפ   Aפ   Aפ   Aפ   Aפ   Aפp   AפQ   Aפ2   Aפ   Aפ   Aפ   Aפ   Aפ   Aפx   AפY   Aפ:   Aפ   Aפ   Aפ   Aפ   Aפ   Aפ   Aפa   AפB   Aפ#   Aפ   Aפ   Aפ   Aפ   Aפ   Aפi   AפJ   Aפ+   Aפ   Aפ   Aפ   Aפ   Aפ   Aפq   AפR   Aפ3   Aפ   Aפ   Aפ   Aפ   Aפ   Aפy   AפZ   Aפ;   Aפ   Aפ   Aפ   Aפ   Aפ   Aפ   Aפb   AפC   Aפ$   Aפ   Aפ   Aפ   Aפ   Aפ   Aפj   AפK   Aפ,   Aפ
   Aפ   Aפ   Aפ   Aפ   Aפr   AפS   Aפ4   Aפ   Aפ   Aפ   AפǸ   Aפș   Aפz   Aפ[   Aפ<   Aפ   Aפ   Aפ   Aפ   Aפϡ   AפЂ   Aפc   AפD   Aפ%   Aפ   Aפ   Aפ   Aפ֩   Aפ׊   Aפk   AפL   Aפ-   Aפ   Aפ   Aפ   Aפݱ   Aפޒ   Aפs   AפT   Aפ5   Aפ   Aפ   Aפ   Aפ   Aפ   Aפ{   Aפ\   Aפ=   Aפ   Aפ   Aפ   Aפ   Aפ   Aפ   Aפd   AפE   Aפ&   Aפ   Aפ   Aפ   Aפ   Aפ   Aפl   AפM   Aפ.   Aפ   Aפ   Aפ   Aפ   Aפ   Aפt   AפU   Aפ6   Aפ   Aפ   Aץ    Aץ   Aץ   Aץ|   Aץ]   Aץ>   Aץ   Aץ    Aץ   Aץ   Aץ	   Aץ
   Aץe   AץF   Aץ
'   Aץ   Aץ   Aץ   Aץ   Aץ   Aץm   AץN   Aץ/   Aץ   Aץ   Aץ   Aץ   Aץ   Aץu   AץV   Aץ7   Aץ   Aץ   Aץ   Aץ   Aץ   Aץ }   Aץ!^   Aץ"?   Aץ#    Aץ$   Aץ$   Aץ%   Aץ&   Aץ'   Aץ(f   Aץ)G   Aץ*(   Aץ+	   Aץ+   Aץ,   Aץ-   Aץ.   Aץ/n   Aץ0O   Aץ10   Aץ2   Aץ2   Aץ3   Aץ4   Aץ5   Aץ6v   Aץ7W   Aץ88   Aץ9   Aץ9   Aץ:   Aץ;   Aץ<   Aץ=~   Aץ>_   Aץ?@   Aץ@!   AץA   AץA   AץB   AץC   AץD   AץEg   AץFH   AץG)   AץH
   AץH   AץI   AץJ   AץK   AץLo   AץMP   AץN1   AץO   AץO   AץP   AץQ   AץR   AץSw   AץTX   AץU9   AץV   AץV   AץW   AץX   AץY   AץZ   Aץ[`   Aץ\A   Aץ]"   Aץ^   Aץ^   Aץ_   Aץ`   Aץa   Aץbh   AץcI   Aץd*   Aץe   Aץe   Aץf   Aץg   Aץh   Aץip   AץjQ   Aץk2   Aץl   Aץl   Aץm   Aץn   Aץo   Aץpx   AץqY   Aץr:   Aץs   Aץs   Aץt   Aץu   Aץv   Aץw   Aץxa   AץyB   Aץz#   Aץ{   Aץ{   Aץ|   Aץ}   Aץ~   Aץi   AץJ   Aץ+   Aץ   Aץ   Aץ   Aץ   Aץ   Aץq   AץR   Aץ3   Aץ   Aץ   Aץ   Aץ   Aץ   Aץy   AץZ   Aץ;   Aץ   Aץ   Aץ   Aץ   Aץ   Aץ   Aץb   AץC   Aץ$   Aץ   Aץ   Aץ   Aץ   Aץ   Aץj   AץK   Aץ,   Aץ
   Aץ   Aץ   Aץ   Aץ   Aץr   AץS   Aץ4   Aץ   Aץ   Aץ   Aץ   Aץ   Aץz   Aץ[   Aץ<   Aץ   Aץ   Aץ   Aץ   Aץ   Aץ   Aץc   AץD   Aץ%   Aץ   Aץ   Aץ   Aץ   Aץ   Aץk   AץL   Aץ-   Aץ   Aץ   Aץ   Aץ   Aץ   Aץs   AץT   Aץ5   Aץ   Aץ   Aץ   AץŹ   Aץƚ   Aץ{   Aץ\   Aץ=   Aץ   Aץ   Aץ   Aץ   Aץ͢   Aץ΃   Aץd   AץE   Aץ&   Aץ   Aץ   Aץ   AץԪ   AץՋ   Aץl   AץM   Aץ.   Aץ   Aץ   Aץ   Aץ۲   Aץܓ   Aץt   AץU   Aץ6   Aץ   Aץ   Aץ   Aץ   Aץ   Aץ|   Aץ]   Aץ>   Aץ   Aץ    Aץ   Aץ   Aץ   Aץ   Aץe   AץF   Aץ'   Aץ   Aץ   Aץ   Aץ   Aץ   Aץm   AץN   Aץ/   Aץ   Aץ   Aץ   Aץ   Aץ   Aץu   AץV   Aץ7   Aץ   Aץ   Aץ   Aץ   Aצ    Aצ}   Aצ^   Aצ?   Aצ    Aצ   Aצ   Aצ   Aצ   Aצ   Aצ	f   Aצ
G   Aצ(   Aצ	   Aצ   Aצ
   Aצ   Aצ   Aצn   AצO   Aצ0   Aצ   Aצ   Aצ   Aצ   Aצ   Aצv   AצW   Aצ8   Aצ   Aצ   Aצ   Aצ   Aצ   Aצ~   Aצ_   Aצ @   Aצ!!   Aצ"   Aצ"   Aצ#   Aצ$   Aצ%   Aצ&g   Aצ'H   Aצ()   Aצ)
   Aצ)   Aצ*   Aצ+   Aצ,   Aצ-o   Aצ.P   Aצ/1   Aצ0   Aצ0   Aצ1   Aצ2   Aצ3   Aצ4w   Aצ5X   Aצ69   Aצ7   Aצ7   Aצ8   Aצ9   Aצ:   Aצ;   Aצ<`   Aצ=A   Aצ>"   Aצ?   Aצ?   Aצ@   AצA   AצB   AצCh   AצDI   AצE*   AצF   AצF   AצG   AצH   AצI   AצJp   AצKQ   AצL2   AצM   AצM   AצN   AצO   AצP   AצQx   AצRY   AצS:   AצT   AצT   AצU   AצV   AצW   AצX   AצYa   AצZB   Aצ[#   Aצ\   Aצ\   Aצ]   Aצ^   Aצ_   Aצ`i   AצaJ   Aצb+   Aצc   Aצc   Aצd   Aצe   Aצf   Aצgq   AצhR   Aצi3   Aצj   Aצj   Aצk   Aצl   Aצm   Aצny   AצoZ   Aצp;   Aצq   Aצq   Aצr   Aצs   Aצt   Aצu   Aצvb   AצwC   Aצx$   Aצy   Aצy   Aצz   Aצ{   Aצ|   Aצ}j   Aצ~K   Aצ,   Aצ
   Aצ   Aצ   Aצ   Aצ   Aצr   AצS   Aצ4   Aצ   Aצ   Aצ   Aצ   Aצ   Aצz   Aצ[   Aצ<   Aצ   Aצ   Aצ   Aצ   Aצ   Aצ   Aצc   AצD   Aצ%   Aצ   Aצ   Aצ   Aצ   Aצ   Aצk   AצL   Aצ-   Aצ   Aצ   Aצ   Aצ   Aצ   Aצs   AצT   Aצ5   Aצ   Aצ   Aצ   Aצ   Aצ   Aצ{   Aצ\   Aצ=   Aצ   Aצ   Aצ   Aצ   Aצ   Aצ   Aצd   AצE   Aצ&   Aצ   Aצ   Aצ   Aצ   Aצ   Aצl   AצM   Aצ.   Aצ   Aצ   Aצ   Aצ   Aצ   Aצt   AצU   Aצ6   Aצ   Aצ   Aצ   Aצú   Aצě   Aצ|   Aצ]   Aצ>   Aצ   Aצ    Aצ   Aצ   Aצˣ   Aצ̄   Aצe   AצF   Aצ'   Aצ   Aצ   Aצ   Aצҫ   Aצӌ   Aצm   AצN   Aצ/   Aצ   Aצ   Aצ   Aצٳ   Aצڔ   Aצu   AצV   Aצ7   Aצ   Aצ   Aצ   Aצ   Aצ   Aצ}   Aצ^   Aצ?   Aצ    Aצ   Aצ   Aצ   Aצ   Aצ   Aצf   AצG   Aצ(   Aצ	   Aצ   Aצ   Aצ   Aצ   Aצn   AצO   Aצ0   Aצ   Aצ   Aצ   Aצ   Aצ   Aצv   AצW   Aצ8   Aצ   Aצ   Aצ   Aצ   Aצ   Aצ~   Aק _   Aק@   Aק!   Aק   Aק   Aק   Aק   Aק   Aקg   AקH   Aק	)   Aק

   Aק
   Aק   Aק   Aק
   Aקo   AקP   Aק1   Aק   Aק   Aק   Aק   Aק   Aקw   AקX   Aק9   Aק   Aק   Aק   Aק   Aק   Aק   Aק`   AקA   Aק"   Aק    Aק    Aק!   Aק"   Aק#   Aק$h   Aק%I   Aק&*   Aק'   Aק'   Aק(   Aק)   Aק*   Aק+p   Aק,Q   Aק-2   Aק.   Aק.   Aק/   Aק0   Aק1   Aק2x   Aק3Y   Aק4:   Aק5   Aק5   Aק6   Aק7   Aק8   Aק9   Aק:a   Aק;B   Aק<#   Aק=   Aק=   Aק>   Aק?   Aק@   AקAi   AקBJ   AקC+   AקD   AקD   AקE   AקF   AקG   AקHq   AקIR   AקJ3   AקK   AקK   Aק   Aק   Aק   Aק}   Aר*   Aר   Aר   Aר	   Aר2   Aר   Aר   Aר   Aר   Aר   Aרx   AרY   Aר:   Aר   Aר   Aר   Aר   Aר   Aר   Aרa   AרB   Aר#   Aר   Aר   Aר   Aר    Aר!   Aר"i   Aר#J   Aר$+   Aר%   Aר%   Aר&   Aר'   Aר(   Aר)q   Aר*R   Aר+3   Aר,   Aר,   Aר-   Aר.   Aר/   Aר0y   Aר1Z   Aר2;   Aר3   Aר3   Aר4   Aר5   Aר6   Aר7   Aר8b   Aר9C   Aר:$   Aר;   Aר;   Aר<   Aר=   Aר>   Aר?j   Aר@K   AרA,   AרB
   AרB   AרC   AרD   AרE   AרFr   AרGS   AרH4   AרI   AרI   AרJ   AרK   AרL   AרMz   AרN[   AרO<   AרP   AרP   AרQ   AרR   AרS   AרT   AרUc   AרVD   AרW%   AרX   AרY   AרZ   Aר[   Aר\k   Aר]L   Aר^-   Aר_   Aר_   Aר`   Aרa   Aרb   Aרcs   AרdT   Aרe5   Aרf   Aרf   Aרg   Aרh   Aרi   Aרj{   Aרk\   Aרl=   Aרm   Aרm   Aרn   Aרo   Aרp   Aרq   Aרrd   AרsE   Aרt&   Aרu   Aרu   Aרv   Aרw   Aרx   Aרyl   AרzM   Aר{.   Aר|   Aר|   Aר}   Aר~   Aר   Aרt   AרU   Aר6   Aר   Aר   Aר   Aר   Aר   Aר|   Aר]   Aר>   Aר   Aר    Aר   Aר   Aר   Aר   Aרe   AרF   Aר'   Aר   Aר   Aר   Aר   Aר   Aרm   AרN   Aר/   Aר   Aר   Aר   Aר   Aר   Aרu   AרV   Aר7   Aר   Aר   Aר   Aר   Aר   Aר}   Aר^   Aר?   Aר    Aר   Aר   Aר   Aר   Aר   Aרf   AרG   Aר(   Aר	   Aר   Aר   Aר   Aר   Aרn   AרO   Aר0   Aר   Aר   Aר   Aר   Aר   Aרv   AרW   Aר8   Aר   Aר   Aר   Aר   Aר   Aר~   Aר_   Aר@   Aר!   Aר   Aר   Aר   Aרǥ   AרȆ   Aרg   AרH   Aר)   Aר
   Aר   Aר   Aרέ   Aרώ   Aרo   AרP   Aר1   Aר   Aר   Aר   Aרյ   Aר֖   Aרw   AרX   Aר9   Aר   Aר   Aר   Aרܽ   Aרݞ   Aר   Aר`   AרA   Aר"   Aר   Aר   Aר   Aר   Aר   Aרh   AרI   Aר*   Aר   Aר   Aר   Aר   Aר   Aרp   AרQ   Aר2   Aר   Aר   Aר   Aר   Aר   Aרx   AרY   Aר:   Aר   Aר   Aר   Aר   Aר   Aר   Aרa   AרB   Aר#   Aר   Aר   Aש    Aש   Aש   Aשi   AשJ   Aש+   Aש   Aש   Aש   Aש   Aש	   Aש
q   AשR   Aש3   Aש
   Aש
   Aש   Aש   Aש   Aשy   AשZ   Aש;   Aש   Aש   Aש   Aש   Aש   Aש   Aשb   AשC   Aש$   Aש   Aש   Aש   Aש   Aש   Aש j   Aש!K   Aש",   Aש#
   Aש#   Aש$   Aש%   Aש&   Aש'r   Aש(S   Aש)4   Aש*   Aש*   Aש+   Aש,   Aש-   Aש.z   Aש/[   Aש0<   Aש1   Aש1   Aש2   Aש3   Aש4   Aש5   Aש6c   Aש7D   Aש8%   Aש9   Aש9   Aש:   Aש;   Aש<   Aש=k   Aש>L   Aש?-   Aש@   Aש@   AשA   AשB   AשC   AשDs   AשET   AשF5   AשG   AשG   AשH   AשI   AשJ   AשK{   AשL\   AשM=   AשN   AשN   AשO   AשP   AשQ   AשR   AשSd   AשTE   AשU&   AשV   AשV   AשW   AשX   AשY   AשZl   Aש[M   Aש\.   Aש]   Aש]   Aש^   Aש_   Aש`   Aשat   AשbU   Aשc6   Aשd   Aשd   Aשe   Aשf   Aשg   Aשh|   Aשi]   Aשj>   Aשk   Aשl    Aשl   Aשm   Aשn   Aשo   Aשpe   AשqF   Aשr'   Aשs   Aשs   Aשt   Aשu   Aשv   Aשwm   AשxN   Aשy/   Aשz   Aשz   Aש{   Aש|   Aש}   Aש~u   AשV   Aש7   Aש   Aש   Aש   Aש   Aש   Aש}   Aש^   Aש?   Aש    Aש   Aש   Aש   Aש   Aש   Aשf   AשG   Aש(   Aש	   Aש   Aש   Aש   Aש   Aשn   AשO   Aש0   Aש   Aש   Aש   Aש   Aש   Aשv   AשW   Aש8   Aש   Aש   Aש   Aש   Aש   Aש~   Aש_   Aש@   Aש!   Aש   Aש   Aש   Aש   Aש   Aשg   AשH   Aש)   Aש
   Aש   Aש   Aש   Aש   Aשo   AשP   Aש1   Aש   Aש   Aש   Aש   Aש   Aשw   AשX   Aש9   Aש   Aש   Aש   Aש   Aש   Aש   Aש`   AשA   Aש"   Aש   Aש   Aש   AשŦ   AשƇ   Aשh   AשI   Aש*   Aש   Aש   Aש   Aש̮   Aש͏   Aשp   AשQ   Aש2   Aש   Aש   Aש   AשӶ   Aשԗ   Aשx   AשY   Aש:   Aש   Aש   Aש   Aשھ   Aש۟   Aש܀   Aשa   AשB   Aש#   Aש   Aש   Aש   Aש   Aש   Aשi   AשJ   Aש+   Aש   Aש   Aש   Aש   Aש   Aשq   AשR   Aש3   Aש   Aש   Aש   Aש   Aש   Aשy   AשZ   Aש;   Aש   Aש   Aש   Aש   Aש   Aש   Aשb   AשC   Aש$   Aש   Aש   Aש   Aש   Aת    Aתj   AתK   Aת,   Aת
   Aת   Aת   Aת   Aת   Aתr   Aת	S   Aת
4   Aת   Aת   Aת   Aת
   Aת   Aתz   Aת[   Aת<   Aת   Aת   Aת   Aת   Aת   Aת   Aתc   AתD   Aת%   Aת   Aת   Aת   Aת   Aת   Aתk   AתL   Aת -   Aת!   Aת!   Aת"   Aת#   Aת$   Aת%s   Aת&T   Aת'5   Aת(   Aת(   Aת)   Aת*   Aת+   Aת,{   Aת-\   Aת.=   Aת/   Aת/   Aת0   Aת1   Aת2   Aת3   Aת4d   Aת5E   Aת6&   Aת7   Aת7   Aת8   Aת9   Aת:   Aת;l   Aת<M   Aת=.   Aת>   Aת>   Aת?   Aת@   AתA   AתBt   AתCU   AתD6   AתE   AתE   AתF   AתG   AתH   AתI|   AתJ]   AתK>   AתL   AתM    AתM   AתN   AתO   AתP   AתQe   AתRF   AתS'   AתT   AתT   AתU   AתV   AתW   AתXm   AתYN   AתZ/   Aת[   Aת[   Aת\   Aת]   Aת^   Aת_u   Aת`V   Aתa7   Aתb   Aתb   Aתc   Aתd   Aתe   Aתf}   Aתg^   Aתh?   Aתi    Aתj   Aתj   Aתk   Aתl   Aתm   Aתnf   AתoG   Aתp(   Aתq	   Aתq   Aתr   Aתs   Aתt   Aתun   AתvO   Aתw0   Aתx   Aתx   Aתy   Aתz   Aת{   Aת|v   Aת}W   Aת~8   Aת   Aת   Aת   Aת   Aת   Aת~   Aת_   Aת@   Aת!   Aת   Aת   Aת   Aת   Aת   Aתg   AתH   Aת)   Aת
   Aת   Aת   Aת   Aת   Aתo   AתP   Aת1   Aת   Aת   Aת   Aת   Aת   Aתw   AתX   Aת9   Aת   Aת   Aת   Aת   Aת   Aת   Aת`   AתA   Aת"   Aת   Aת   Aת   Aת   Aת   Aתh   AתI   Aת*   Aת   Aת   Aת   Aת   Aת   Aתp   AתQ   Aת2   Aת   Aת   Aת   Aת   Aת   Aתx   AתY   Aת:   Aת   Aת   Aת   Aת   Aת   Aת   Aתa   AתB   Aת#   Aת   Aת   Aת   Aתç   AתĈ   Aתi   AתJ   Aת+   Aת   Aת   Aת   Aתʯ   Aתː   Aתq   AתR   Aת3   Aת   Aת   Aת   Aתѷ   AתҘ   Aתy   AתZ   Aת;   Aת   Aת   Aת   Aתؿ   Aת٠   Aתځ   Aתb   AתC   Aת$   Aת   Aת   Aת   Aת   Aת   Aתj   AתK   Aת,   Aת
   Aת   Aת   Aת   Aת   Aתr   AתS   Aת4   Aת   Aת   Aת   Aת   Aת   Aתz   Aת[   Aת<   Aת   Aת   Aת   Aת   Aת   Aת   Aתc   AתD   Aת%   Aת   Aת   Aת   Aת   Aת   Aתk   A׫ L   A׫-   A׫   A׫   A׫   A׫   A׫   A׫s   A׫T   A׫5   A׫	   A׫	   A׫
   A׫   A׫   A׫
{   A׫\   A׫=   A׫   A׫   A׫   A׫   A׫   A׫   A׫d   A׫E   A׫&   A׫   A׫   A׫   A׫   A׫   A׫l   A׫M   A׫.   A׫   A׫   A׫    A׫!   A׫"   A׫#t   A׫$U   A׫%6   A׫&   A׫&   A׫'   A׫(   A׫)   A׫*|   A׫+]   A׫,>   A׫-   A׫.    A׫.   A׫/   A׫0   A׫1   A׫2e   A׫3F   A׫4'   A׫5   A׫5   A׫6   A׫7   A׫8   A׫9m   A׫:N   A׫;/   A׫<   A׫<   A׫=   A׫>   A׫?   A׫@u   A׫AV   A׫B7   A׫C   A׫C   A׫D   A׫E   A׫F   A׫G}   A׫H^   A׫I?   A׫J    A׫K   A׫K   A׫L   A׫M   A׫N   A׫Of   A׫PG   A׫Q(   A׫R	   A׫R   A׫S   A׫T   A׫U   A׫Vn   A׫WO   A׫X0   A׫Y   A׫Y   A׫Z   A׫[   A׫\   A׫]v   A׫^W   A׫_8   A׫`   A׫`   A׫a   A׫b   A׫c   A׫d~   A׫e_   A׫f@   A׫g!   A׫h   A׫h   A׫i   A׫j   A׫k   A׫lg   A׫mH   A׫n)   A׫o
   A׫o   A׫p   A׫q   A׫r   A׫so   A׫tP   A׫u1   A׫v   A׫v   A׫w   A׫x   A׫y   A׫zw   A׫{X   A׫|9   A׫}   A׫}   A׫~   A׫   A׫   A׫   A׫`   A׫A   A׫"   A׫   A׫   A׫   A׫   A׫   A׫h   A׫I   A׫*   A׫   A׫   A׫   A׫   A׫   A׫p   A׫Q   A׫2   A׫   A׫   A׫   A׫   A׫   A׫x   A׫Y   A׫:   A׫   A׫   A׫   A׫   A׫   A׫   A׫a   A׫B   A׫#   A׫   A׫   A׫   A׫   A׫   A׫i   A׫J   A׫+   A׫   A׫   A׫   A׫   A׫   A׫q   A׫R   A׫3   A׫   A׫   A׫   A׫   A׫   A׫y   A׫Z   A׫;   A׫   A׫   A׫   A׫   A׫   A׫   A׫b   A׫C   A׫$   A׫   A׫   A׫   A׫   A׫   A׫j   A׫K   A׫,   A׫
   A׫   A׫   A׫Ȱ   A׫ɑ   A׫r   A׫S   A׫4   A׫   A׫   A׫   A׫ϸ   A׫Й   A׫z   A׫[   A׫<   A׫   A׫   A׫   A׫   A׫ס   A׫؂   A׫c   A׫D   A׫%   A׫   A׫   A׫   A׫ީ   A׫ߊ   A׫k   A׫L   A׫-   A׫   A׫   A׫   A׫   A׫   A׫s   A׫T   A׫5   A׫   A׫   A׫   A׫   A׫   A׫{   A׫\   A׫=   A׫   A׫   A׫   A׫   A׫   A׫   A׫d   A׫E   A׫&   A׫   A׫   A׫   A׫   A׫   A׫l   A׫M   A׫.   A׬    A׬    A׬   A׬   A׬   A׬t   A׬U   A׬6   A׬   A׬   A׬   A׬	   A׬
   A׬|   A׬]   A׬
>   A׬   A׬    A׬   A׬   A׬   A׬   A׬e   A׬F   A׬'   A׬   A׬   A׬   A׬   A׬   A׬m   A׬N   A׬/   A׬   A׬   A׬   A׬   A׬    A׬!u   A׬"V   A׬#7   A׬$   A׬$   A׬%   A׬&   A׬'   A׬(}   A׬)^   A׬*?   A׬+    A׬,   A׬,   A׬-   A׬.   A׬/   A׬0f   A׬1G   A׬2(   A׬3	   A׬3   A׬4   A׬5   A׬6   A׬7n   A׬8O   A׬90   A׬:   A׬:   A׬;   A׬<   A׬=   A׬>v   A׬?W   A׬@8   A׬A   A׬A   A׬B   A׬C   A׬D   A׬E~   A׬F_   A׬G@   A׬H!   A׬I   A׬I   A׬J   A׬K   A׬L   A׬Mg   A׬NH   A׬O)   A׬P
   A׬P   A׬Q   A׬R   A׬S   A׬To   A׬UP   A׬V1   A׬W   A׬W   A׬X   A׬Y   A׬Z   A׬[w   A׬\X   A׬]9   A׬^   A׬^   A׬_   A׬`   A׬a   A׬b   A׬c`   A׬dA   A׬e"   A׬f   A׬f   A׬g   A׬h   A׬i   A׬jh   A׬kI   A׬l*   A׬m   A׬m   A׬n   A׬o   A׬p   A׬qp   A׬rQ   A׬s2   A׬t   A׬t   A׬u   A׬v   A׬w   A׬xx   A׬yY   A׬z:   A׬{   A׬{   A׬|   A׬}   A׬~   A׬   A׬a   A׬B   A׬#   A׬   A׬   A׬   A׬   A׬   A׬i   A׬J   A׬+   A׬   A׬   A׬   A׬   A׬   A׬q   A׬R   A׬3   A׬   A׬   A׬   A׬   A׬   A׬y   A׬Z   A׬;   A׬   A׬   A׬   A׬   A׬   A׬   A׬b   A׬C   A׬$   A׬   A׬   A׬   A׬   A׬   A׬j   A׬K   A׬,   A׬
   A׬   A׬   A׬   A׬   A׬r   A׬S   A׬4   A׬   A׬   A׬   A׬   A׬   A׬z   A׬[   A׬<   A׬   A׬   A׬   A׬   A׬   A׬   A׬c   A׬D   A׬%   A׬   A׬   A׬   A׬   A׬   A׬k   A׬L   A׬-   A׬   A׬   A׬   A׬Ʊ   A׬ǒ   A׬s   A׬T   A׬5   A׬   A׬   A׬   A׬͹   A׬Κ   A׬{   A׬\   A׬=   A׬   A׬   A׬   A׬   A׬բ   A׬փ   A׬d   A׬E   A׬&   A׬   A׬   A׬   A׬ܪ   A׬݋   A׬l   A׬M   A׬.   A׬   A׬   A׬   A׬   A׬   A׬t   A׬U   A׬6   A׬   A׬   A׬   A׬   A׬   A׬|   A׬]   A׬>   A׬   A׬    A׬   A׬   A׬   A׬   A׬e   A׬F   A׬'   A׬   A׬   A׬   A׬   A׬   A׬m   A׬N   A׬/   A׬   A׬   A׬   A׭    A׭   A׭u   A׭V   A׭7   A׭   A׭   A׭   A׭   A׭   A׭	}   A׭
^   A׭?   A׭    A׭
   A׭
   A׭   A׭   A׭   A׭f   A׭G   A׭(   A׭	   A׭   A׭   A׭   A׭   A׭n   A׭O   A׭0   A׭   A׭   A׭   A׭   A׭   A׭v   A׭ W   A׭!8   A׭"   A׭"   A׭#   A׭$   A׭%   A׭&~   A׭'_   A׭(@   A׭)!   A׭*   A׭*   A׭+   A׭,   A׭-   A׭.g   A׭/H   A׭0)   A׭1
   A׭1   A׭2   A׭3   A׭4   A׭5o   A׭6P   A׭71   A׭8   A׭8   A׭9   A׭:   A׭;   A׭<w   A׭=X   A׭>9   A׭?   A׭?   A׭@   A׭A   A׭B   A׭C   A׭D`   A׭EA   A׭F"   A׭G   A׭G   A׭H   A׭I   A׭J   A׭Kh   A׭LI   A׭M*   A׭N   A׭N   A׭O   A׭P   A׭Q   A׭Rp   A׭SQ   A׭T2   A׭U   A׭U   A׭V   A׭W   A׭X   A׭Yx   A׭ZY   A׭[:   A׭\   A׭\   A׭]   A׭^   A׭_   A׭`   A׭aa   A׭bB   A׭c#   A׭d   A׭d   A׭e   A׭f   A׭g   A׭hi   A׭iJ   A׭j+   A׭k   A׭k   A׭l   A׭m   A׭n   A׭oq   A׭pR   A׭q3   A׭r   A׭r   A׭s   A׭t   A׭u   A׭vy   A׭wZ   A׭x;   A׭y   A׭y   A׭z   A׭{   A׭|   A׭}   A׭~b   A׭C   A׭$   A׭   A׭   A׭   A׭   A׭   A׭j   A׭K   A׭,   A׭
   A׭   A׭   A׭   A׭   A׭r   A׭S   A׭4   A׭   A׭   A׭   A׭   A׭   A׭z   A׭[   A׭<   A׭   A׭   A׭   A׭   A׭   A׭   A׭c   A׭D   A׭%   A׭   A׭   A׭   A׭   A׭   A׭k   A׭L   A׭-   A׭   A׭   A׭   A׭   A׭   A׭s   A׭T   A׭5   A׭   A׭   A׭   A׭   A׭   A׭{   A׭\   A׭=   A׭   A׭   A׭   A׭   A׭   A׭   A׭d   A׭E   A׭&   A׭   A׭   A׭   A׭   A׭   A׭l   A׭M   A׭.   A׭   A׭   A׭   A׭Ĳ   A׭œ   A׭t   A׭U   A׭6   A׭   A׭   A׭   A׭˺   A׭̛   A׭|   A׭]   A׭>   A׭   A׭    A׭   A׭   A׭ӣ   A׭Ԅ   A׭e   A׭F   A׭'   A׭   A׭   A׭   A׭ګ   A׭ی   A׭m   A׭N   A׭/   A׭   A׭   A׭   A׭   A׭   A׭u   A׭V   A׭7   A׭   A׭   A׭   A׭   A׭   A׭}   A׭^   A׭?   A׭    A׭   A׭   A׭   A׭   A׭   A׭f   A׭G   A׭(   A׭	   A׭   A׭   A׭   A׭   A׭n   A׭O   A׭0   A׭   A׭   A׭   A׭   A׭   A׮ v   A׮W   A׮8   A׮   A׮   A׮   A׮   A׮   A׮~   A׮_   A׮	@   A׮
!   A׮   A׮   A׮   A׮
   A׮   A׮g   A׮H   A׮)   A׮
   A׮   A׮   A׮   A׮   A׮o   A׮P   A׮1   A׮   A׮   A׮   A׮   A׮   A׮w   A׮X   A׮9   A׮    A׮    A׮!   A׮"   A׮#   A׮$   A׮%`   A׮&A   A׮'"   A׮(   A׮(   A׮)   A׮*   A׮+   A׮,h   A׮-I   A׮.*   A׮/   A׮/   A׮0   A׮1   A׮2   A׮3p   A׮4Q   A׮52   A׮6   A׮6   A׮7   A׮8   A׮9   A׮:x   A׮;Y   A׮<:   A׮=   A׮=   A׮>   A׮?   A׮@   A׮A   A׮Ba   A׮CB   A׮D#   A׮E   A׮E   A׮F   A׮G   A׮H   A׮Ii   A׮JJ   A׮K+   A׮L   A׮L   A׮M   A׮N   A׮O   A׮Pq   A׮QR   A׮R3   A׮S   A׮S   A׮T   A׮U   A׮V   A׮Wy   A׮XZ   A׮Y;   A׮Z   A׮Z   A׮[   A׮\   A׮]   A׮^   A׮_b   A׮`C   A׮a$   A׮b   A׮b   A׮c   A׮d   A׮e   A׮fj   A׮gK   A׮h,   A׮i
   A׮i   A׮j   A׮k   A׮l   A׮mr   A׮nS   A׮o4   A׮p   A׮p   A׮q   A׮r   A׮s   A׮tz   A׮u[   A׮v<   A׮w   A׮w   A׮x   A׮y   A׮z   A׮{   A׮|c   A׮}D   A׮~%   A׮   A׮   A׮   A׮   A׮   A׮k   A׮L   A׮-   A׮   A׮   A׮   A׮   A׮   A׮s   A׮T   A׮5   A׮   A׮   A׮   A׮   A׮   A׮{   A׮\   A׮=   A׮   A׮   A׮   A׮   A׮   A׮   A׮d   A׮E   A׮&   A׮   A׮   A׮   A׮   A׮   A׮l   A׮M   A׮.   A׮   A׮   A׮   A׮   A׮   A׮t   A׮U   A׮6   A׮   A׮   A׮   A׮   A׮   A׮|   A׮]   A׮>   A׮   A׮    A׮   A׮   A׮   A׮   A׮e   A׮F   A׮'   A׮   A׮   A׮   A׮   A׮   A׮m   A׮N   A׮/   A׮   A׮   A׮   A׮³   A׮Ô   A׮u   A׮V   A׮7   A׮   A׮   A׮   A׮ɻ   A׮ʜ   A׮}   A׮^   A׮?   A׮    A׮   A׮   A׮   A׮Ѥ   A׮҅   A׮f   A׮G   A׮(   A׮	   A׮   A׮   A׮ج   A׮ٍ   A׮n   A׮O   A׮0   A׮   A׮   A׮   A׮ߴ   A׮   A׮v   A׮W   A׮8   A׮   A׮   A׮   A׮   A׮   A׮~   A׮_   A׮@   A׮!   A׮   A׮   A׮   A׮   A׮   A׮g   A׮H   A׮)   A׮
   A׮   A׮   A׮   A׮   A׮o   A׮P   A׮1   A׮   A׮   A׮   A׮   A׮   A׮w   A׮X   Aׯ 9   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ`   AׯA   Aׯ"   Aׯ	   Aׯ	   Aׯ
   Aׯ   Aׯ   Aׯ
h   AׯI   Aׯ*   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯp   AׯQ   Aׯ2   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯx   AׯY   Aׯ:   Aׯ   Aׯ   Aׯ   Aׯ    Aׯ!   Aׯ"   Aׯ#a   Aׯ$B   Aׯ%#   Aׯ&   Aׯ&   Aׯ'   Aׯ(   Aׯ)   Aׯ*i   Aׯ+J   Aׯ,+   Aׯ-   Aׯ-   Aׯ.   Aׯ/   Aׯ0   Aׯ1q   Aׯ2R   Aׯ33   Aׯ4   Aׯ4   Aׯ5   Aׯ6   Aׯ7   Aׯ8y   Aׯ9Z   Aׯ:;   Aׯ;   Aׯ;   Aׯ<   Aׯ=   Aׯ>   Aׯ?   Aׯ@b   AׯAC   AׯB$   AׯC   AׯC   AׯD   AׯE   AׯF   AׯGj   AׯHK   AׯI,   AׯJ
   AׯJ   AׯK   AׯL   AׯM   AׯNr   AׯOS   AׯP4   AׯQ   AׯQ   AׯR   AׯS   AׯT   AׯUz   AׯV[   AׯW<   AׯX   AׯX   AׯY   AׯZ   Aׯ[   Aׯ\   Aׯ]c   Aׯ^D   Aׯ_%   Aׯ`   Aׯ`   Aׯa   Aׯb   Aׯc   Aׯdk   AׯeL   Aׯf-   Aׯg   Aׯg   Aׯh   Aׯi   Aׯj   Aׯks   AׯlT   Aׯm5   Aׯn   Aׯn   Aׯo   Aׯp   Aׯq   Aׯr{   Aׯs\   Aׯt=   Aׯu   Aׯu   Aׯv   Aׯw   Aׯx   Aׯy   Aׯzd   Aׯ{E   Aׯ|&   Aׯ}   Aׯ}   Aׯ~   Aׯ   Aׯ   Aׯl   AׯM   Aׯ.   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯt   AׯU   Aׯ6   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ|   Aׯ]   Aׯ>   Aׯ   Aׯ    Aׯ   Aׯ   Aׯ   Aׯ   Aׯe   AׯF   Aׯ'   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯm   AׯN   Aׯ/   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯu   AׯV   Aׯ7   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ}   Aׯ^   Aׯ?   Aׯ    Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯf   AׯG   Aׯ(   Aׯ	   Aׯ   Aׯ   Aׯ   Aׯ   Aׯn   AׯO   Aׯ0   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯv   AׯW   Aׯ8   Aׯ   Aׯ   Aׯ   AׯǼ   Aׯȝ   Aׯ~   Aׯ_   Aׯ@   Aׯ!   Aׯ   Aׯ   Aׯ   Aׯϥ   AׯІ   Aׯg   AׯH   Aׯ)   Aׯ
   Aׯ   Aׯ   Aׯ֭   Aׯ׎   Aׯo   AׯP   Aׯ1   Aׯ   Aׯ   Aׯ   Aׯݵ   Aׯޖ   Aׯw   AׯX   Aׯ9   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ`   AׯA   Aׯ"   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯh   AׯI   Aׯ*   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯp   AׯQ   Aׯ2   Aׯ   Aׯ   Aׯ   Aׯ   Aׯ   Aׯx   AׯY   Aׯ:   Aׯ   Aׯ   Aװ    Aװ   Aװ   Aװ   Aװa   AװB   Aװ#   Aװ   Aװ   Aװ   Aװ	   Aװ
   Aװi   AװJ   Aװ
+   Aװ   Aװ   Aװ   Aװ   Aװ   Aװq   AװR   Aװ3   Aװ   Aװ   Aװ   Aװ   Aװ   Aװy   AװZ   Aװ;   Aװ   Aװ   Aװ   Aװ   Aװ   Aװ    Aװ!b   Aװ"C   Aװ#$   Aװ$   Aװ$   Aװ%   Aװ&   Aװ'   Aװ(j   Aװ)K   Aװ*,   Aװ+
   Aװ+   Aװ,   Aװ-   Aװ.   Aװ/r   Aװ0S   Aװ14   Aװ2   Aװ2   Aװ3   Aװ4   Aװ5   Aװ6z   Aװ7[   Aװ8<   Aװ9   Aװ9   Aװ:   Aװ;   Aװ<   Aװ=   Aװ>c   Aװ?D   Aװ@%   AװA   AװA   AװB   AװC   AװD   AװEk   AװFL   AװG-   AװH   AװH   AװI   AװJ   AװK   AװLs   AװMT   AװN5   AװO   AװO   AװP   AװQ   AװR   AװS{   AװT\   AװU=   AװV   AװV   AװW   AװX   AװY   AװZ   Aװ[d   Aװ\E   Aװ]&   Aװ^   Aװ^   Aװ_   Aװ`   Aװa   Aװbl   AװcM   Aװd.   Aװe   Aװe   Aװf   Aװg   Aװh   Aװit   AװjU   Aװk6   Aװl   Aװl   Aװm   Aװn   Aװo   Aװp|   Aװq]   Aװr>   Aװs   Aװt    Aװt   Aװu   Aװv   Aװw   Aװxe   AװyF   Aװz'   Aװ{   Aװ{   Aװ|   Aװ}   Aװ~   Aװm   AװN   Aװ/   Aװ   Aװ   Aװ   Aװ   Aװ   Aװu   AװV   Aװ7   Aװ   Aװ   Aװ   Aװ   Aװ   Aװ}   Aװ^   Aװ?   Aװ    Aװ   Aװ   Aװ   Aװ   Aװ   Aװf   AװG   Aװ(   Aװ	   Aװ   Aװ   Aװ   Aװ   Aװn   AװO   Aװ0   Aװ   Aװ   Aװ   Aװ   Aװ   Aװv   AװW   Aװ8   Aװ   Aװ   Aװ   Aװ   Aװ   Aװ~   Aװ_   Aװ@   Aװ!   Aװ   Aװ   Aװ   Aװ   Aװ   Aװg   AװH   Aװ)   Aװ
   Aװ   Aװ   Aװ   Aװ   Aװo   AװP   Aװ1   Aװ   Aװ   Aװ   Aװ   Aװ   Aװw   AװX   Aװ9   Aװ   Aװ   Aװ   AװŽ   Aװƞ   Aװ   Aװ`   AװA   Aװ"   Aװ   Aװ   Aװ   Aװͦ   Aװ·   Aװh   AװI   Aװ*   Aװ   Aװ   Aװ   AװԮ   AװՏ   Aװp   AװQ   Aװ2   Aװ   Aװ   Aװ   Aװ۶   Aװܗ   Aװx   AװY   Aװ:   Aװ   Aװ   Aװ   Aװ   Aװ   Aװ   Aװa   AװB   Aװ#   Aװ   Aװ   Aװ   Aװ   Aװ   Aװi   AװJ   Aװ+   Aװ   Aװ   Aװ   Aװ   Aװ   Aװq   AװR   Aװ3   Aװ   Aװ   Aװ   Aװ   Aװ   Aװy   AװZ   Aװ;   Aװ   Aװ   Aװ   Aװ   Aױ    Aױ   Aױb   AױC   Aױ$   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ	j   Aױ
K   Aױ,   Aױ
   Aױ   Aױ
   Aױ   Aױ   Aױr   AױS   Aױ4   Aױ   Aױ   Aױ   Aױ   Aױ   Aױz   Aױ[   Aױ<   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ   Aױc   Aױ D   Aױ!%   Aױ"   Aױ"   Aױ#   Aױ$   Aױ%   Aױ&k   Aױ'L   Aױ(-   Aױ)   Aױ)   Aױ*   Aױ+   Aױ,   Aױ-s   Aױ.T   Aױ/5   Aױ0   Aױ0   Aױ1   Aױ2   Aױ3   Aױ4{   Aױ5\   Aױ6=   Aױ7   Aױ7   Aױ8   Aױ9   Aױ:   Aױ;   Aױ<d   Aױ=E   Aױ>&   Aױ?   Aױ?   Aױ@   AױA   AױB   AױCl   AױDM   AױE.   AױF   AױF   AױG   AױH   AױI   AױJt   AױKU   AױL6   AױM   AױM   AױN   AױO   AױP   AױQ|   AױR]   AױS>   AױT   AױU    AױU   AױV   AױW   AױX   AױYe   AױZF   Aױ['   Aױ\   Aױ\   Aױ]   Aױ^   Aױ_   Aױ`m   AױaN   Aױb/   Aױc   Aױc   Aױd   Aױe   Aױf   Aױgu   AױhV   Aױi7   Aױj   Aױj   Aױk   Aױl   Aױm   Aױn}   Aױo^   Aױp?   Aױq    Aױr   Aױr   Aױs   Aױt   Aױu   Aױvf   AױwG   Aױx(   Aױy	   Aױy   Aױz   Aױ{   Aױ|   Aױ}n   Aױ~O   Aױ0   Aױ   Aױ   Aױ   Aױ   Aױ   Aױv   AױW   Aױ8   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ~   Aױ_   Aױ@   Aױ!   Aױ   Aױ   Aױ   Aױ   Aױ   Aױg   AױH   Aױ)   Aױ
   Aױ   Aױ   Aױ   Aױ   Aױo   AױP   Aױ1   Aױ   Aױ   Aױ   Aױ   Aױ   Aױw   AױX   Aױ9   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ`   AױA   Aױ"   Aױ   Aױ   Aױ   Aױ   Aױ   Aױh   AױI   Aױ*   Aױ   Aױ   Aױ   Aױ   Aױ   Aױp   AױQ   Aױ2   Aױ   Aױ   Aױ   Aױ   Aױ   Aױx   AױY   Aױ:   Aױ   Aױ   Aױ   Aױþ   Aױğ   Aױŀ   Aױa   AױB   Aױ#   Aױ   Aױ   Aױ˧   Aױ̈   Aױi   AױJ   Aױ+   Aױ   Aױ   Aױ   Aױү   AױӐ   Aױq   AױR   Aױ3   Aױ   Aױ   Aױ   Aױٷ   Aױژ   Aױy   AױZ   Aױ;   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ   Aױb   AױC   Aױ$   Aױ   Aױ   Aױ   Aױ   Aױ   Aױj   AױK   Aױ,   Aױ
   Aױ   Aױ   Aױ   Aױ   Aױr   AױS   Aױ4   Aױ   Aױ   Aױ   Aױ   Aױ   Aױz   Aױ[   Aױ<   Aױ   Aױ   Aױ   Aױ   Aױ   Aױ   Aײ c   AײD   Aײ%   Aײ   Aײ   Aײ   Aײ   Aײ   Aײk   AײL   Aײ	-   Aײ
   Aײ
   Aײ   Aײ   Aײ
   Aײs   AײT   Aײ5   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ{   Aײ\   Aײ=   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ   Aײd   AײE   Aײ&   Aײ    Aײ    Aײ!   Aײ"   Aײ#   Aײ$l   Aײ%M   Aײ&.   Aײ'   Aײ'   Aײ(   Aײ)   Aײ*   Aײ+t   Aײ,U   Aײ-6   Aײ.   Aײ.   Aײ/   Aײ0   Aײ1   Aײ2|   Aײ3]   Aײ4>   Aײ5   Aײ6    Aײ6   Aײ7   Aײ8   Aײ9   Aײ:e   Aײ;F   Aײ<'   Aײ=   Aײ=   Aײ>   Aײ?   Aײ@   AײAm   AײBN   AײC/   AײD   AײD   AײE   AײF   AײG   AײHu   AײIV   AײJ7   AײK   AײK   AײL   AײM   AײN   AײO}   AײP^   AײQ?   AײR    AײS   AײS   AײT   AײU   AײV   AײWf   AײXG   AײY(   AײZ	   AײZ   Aײ[   Aײ\   Aײ]   Aײ^n   Aײ_O   Aײ`0   Aײa   Aײa   Aײb   Aײc   Aײd   Aײev   AײfW   Aײg8   Aײh   Aײh   Aײi   Aײj   Aײk   Aײl~   Aײm_   Aײn@   Aײo!   Aײp   Aײp   Aײq   Aײr   Aײs   Aײtg   AײuH   Aײv)   Aײw
   Aײw   Aײx   Aײy   Aײz   Aײ{o   Aײ|P   Aײ}1   Aײ~   Aײ~   Aײ   Aײ   Aײ   Aײw   AײX   Aײ9   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ`   AײA   Aײ"   Aײ   Aײ   Aײ   Aײ   Aײ   Aײh   AײI   Aײ*   Aײ   Aײ   Aײ   Aײ   Aײ   Aײp   AײQ   Aײ2   Aײ   Aײ   Aײ   Aײ   Aײ   Aײx   AײY   Aײ:   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ   Aײa   AײB   Aײ#   Aײ   Aײ   Aײ   Aײ   Aײ   Aײi   AײJ   Aײ+   Aײ   Aײ   Aײ   Aײ   Aײ   Aײq   AײR   Aײ3   Aײ   Aײ   Aײ   Aײ   Aײ   Aײy   AײZ   Aײ;   Aײ   Aײ   Aײ   Aײ   Aײ    AײÁ   Aײb   AײC   Aײ$   Aײ   Aײ   Aײ   Aײɨ   Aײʉ   Aײj   AײK   Aײ,   Aײ
   Aײ   Aײ   Aײа   Aײё   Aײr   AײS   Aײ4   Aײ   Aײ   Aײ   Aײ׸   Aײؙ   Aײz   Aײ[   Aײ<   Aײ   Aײ   Aײ   Aײ   Aײߡ   Aײ   Aײc   AײD   Aײ%   Aײ   Aײ   Aײ   Aײ   Aײ   Aײk   AײL   Aײ-   Aײ   Aײ   Aײ   Aײ   Aײ   Aײs   AײT   Aײ5   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ{   Aײ\   Aײ=   Aײ   Aײ   Aײ   Aײ   Aײ   Aײ   Aײd   AײE   A׳ &   A׳   A׳   A׳   A׳   A׳   A׳l   A׳M   A׳.   A׳   A׳   A׳	   A׳
   A׳   A׳t   A׳
U   A׳6   A׳   A׳   A׳   A׳   A׳   A׳|   A׳]   A׳>   A׳   A׳    A׳   A׳   A׳   A׳   A׳e   A׳F   A׳'   A׳   A׳   A׳   A׳    A׳!   A׳"m   A׳#N   A׳$/   A׳%   A׳%   A׳&   A׳'   A׳(   A׳)u   A׳*V   A׳+7   A׳,   A׳,   A׳-   A׳.   A׳/   A׳0}   A׳1^   A׳2?   A׳3    A׳4   A׳4   A׳5   A׳6   A׳7   A׳8f   A׳9G   A׳:(   A׳;	   A׳;   A׳<   A׳=   A׳>   A׳?n   A׳@O   A׳A0   A׳B   A׳B   A׳C   A׳D   A׳E   A׳Fv   A׳GW   A׳H8   A׳I   A׳I   A׳J   A׳K   A׳L   A׳M~   A׳N_   A׳O@   A׳P!   A׳Q   A׳Q   A׳R   A׳S   A׳T   A׳Ug   A׳VH   A׳W)   A׳X
   A׳X   A׳Y   A׳Z   A׳[   A׳\o   A׳]P   A׳^1   A׳_   A׳_   A׳`   A׳a   A׳b   A׳cw   A׳dX   A׳e9   A׳f   A׳f   A׳g   A׳h   A׳i   A׳j   A׳k`   A׳lA   A׳m"   A׳n   A׳n   A׳o   A׳p   A׳q   A׳rh   A׳sI   A׳t*   A׳u   A׳u   A׳v   A׳w   A׳x   A׳yp   A׳zQ   A׳{2   A׳|   A׳|   A׳}   A׳~   A׳   A׳x   A׳Y   A׳:   A׳   A׳   A׳   A׳   A׳   A׳   A׳a   A׳B   A׳#   A׳   A׳   A׳   A׳   A׳   A׳i   A׳J   A׳+   A׳   A׳   A׳   A׳   A׳   A׳q   A׳R   A׳3   A׳   A׳   A׳   A׳   A׳   A׳y   A׳Z   A׳;   A׳   A׳   A׳   A׳   A׳   A׳b   A׳C   A׳$   A׳   A׳   A׳   A׳   A׳   A׳j   A׳K   A׳,   A׳
   A׳   A׳   A׳   A׳   A׳r   A׳S   A׳4   A׳   A׳   A׳   A׳   A׳   A׳z   A׳[   A׳<   A׳   A׳   A׳   A׳   A׳   A׳   A׳c   A׳D   A׳%   A׳   A׳   A׳   A׳ǩ   A׳Ȋ   A׳k   A׳L   A׳-   A׳   A׳   A׳   A׳α   A׳ϒ   A׳s   A׳T   A׳5   A׳   A׳   A׳   A׳չ   A׳֚   A׳{   A׳\   A׳=   A׳   A׳   A׳   A׳   A׳ݢ   A׳ރ   A׳d   A׳E   A׳&   A׳   A׳   A׳   A׳   A׳   A׳l   A׳M   A׳.   A׳   A׳   A׳   A׳   A׳   A׳t   A׳U   A׳6   A׳   A׳   A׳   A׳   A׳   A׳|   A׳]   A׳>   A׳   A׳    A׳   A׳   A׳   A׳   A׳e   A׳F   A׳'   A׳   A׳   A״    A״   A״   A״m   A״N   A״/   A״   A״   A״   A״   A״	   A״
u   A״V   A״7   A״
   A״
   A״   A״   A״   A״}   A״^   A״?   A״    A״   A״   A״   A״   A״   A״f   A״G   A״(   A״	   A״   A״   A״   A״   A״ n   A״!O   A״"0   A״#   A״#   A״$   A״%   A״&   A״'v   A״(W   A״)8   A״*   A״*   A״+   A״,   A״-   A״.~   A״/_   A״0@   A״1!   A״2   A״2   A״3   A״4   A״5   A״6g   A״7H   A״8)   A״9
   A״9   A״:   A״;   A״<   A״=o   A״>P   A״?1   A״@   A״@   A״A   A״B   A״C   A״Dw   A״EX   A״F9   A״G   A״G   A״H   A״I   A״J   A״K   A״L`   A״MA   A״N"   A״O   A״O   A״P   A״Q   A״R   A״Sh   A״TI   A״U*   A״V   A״V   A״W   A״X   A״Y   A״Zp   A״[Q   A״\2   A״]   A״]   A״^   A״_   A״`   A״ax   A״bY   A״c:   A״d   A״d   A״e   A״f   A״g   A״h   A״ia   A״jB   A״k#   A״l   A״l   A״m   A״n   A״o   A״pi   A״qJ   A״r+   A״s   A״s   A״t   A״u   A״v   A״wq   A״xR   A״y3   A״z   A״z   A״{   A״|   A״}   A״~y   A״Z   A״;   A״   A״   A״   A״   A״   A״   A״b   A״C   A״$   A״   A״   A״   A״   A״   A״j   A״K   A״,   A״
   A״   A״   A״   A״   A״r   A״S   A״4   A״   A״   A״   A״   A״   A״z   A״[   A״<   A״   A״   A״   A״   A״   A״   A״c   A״D   A״%   A״   A״   A״   A״   A״   A״k   A״L   A״-   A״   A״   A״   A״   A״   A״s   A״T   A״5   A״   A״   A״   A״   A״   A״{   A״\   A״=   A״   A״   A״   A״   A״   A״   A״d   A״E   A״&   A״   A״   A״   A״Ū   A״Ƌ   A״l   A״M   A״.   A״   A״   A״   A״̲   A״͓   A״t   A״U   A״6   A״   A״   A״   A״Ӻ   A״ԛ   A״|   A״]   A״>   A״   A״    A״   A״   A״ۣ   A״܄   A״e   A״F   A״'   A״   A״   A״   A״   A״   A״m   A״N   A״/   A״   A״   A״   A״   A״   A״u   A״V   A״7   A״   A״   A״   A״   A״   A״}   A״^   A״?   A״    A״   A״   A״   A״   A״   A״f   A״G   A״(   A״	   A״   A״   A״   A׵    A׵n   A׵O   A׵0   A׵   A׵   A׵   A׵   A׵   A׵v   A׵	W   A׵
8   A׵   A׵   A׵   A׵
   A׵   A׵~   A׵_   A׵@   A׵!   A׵   A׵   A׵   A׵   A׵   A׵g   A׵H   A׵)   A׵
   A׵   A׵   A׵   A׵   A׵o   A׵P   A׵ 1   A׵!   A׵!   A׵"   A׵#   A׵$   A׵%w   A׵&X   A׵'9   A׵(   A׵(   A׵)   A׵*   A׵+   A׵,   A׵-`   A׵.A   A׵/"   A׵0   A׵0   A׵1   A׵2   A׵3   A׵4h   A׵5I   A׵6*   A׵7   A׵7   A׵8   A׵9   A׵:   A׵;p   A׵<Q   A׵=2   A׵>   A׵>   A׵?   A׵@   A׵A   A׵Bx   A׵CY   A׵D:   A׵E   A׵E   A׵F   A׵G   A׵H   A׵I   A׵Ja   A׵KB   A׵L#   A׵M   A׵M   A׵N   A׵O   A׵P   A׵Qi   A׵RJ   A׵S+   A׵T   A׵T   A׵U   A׵V   A׵W   A׵Xq   A׵YR   A׵Z3   A׵[   A׵[   A׵\   A׵]   A׵^   A׵_y   A׵`Z   A׵a;   A׵b   A׵b   A׵c   A׵d   A׵e   A׵f   A׵gb   A׵hC   A׵i$   A׵j   A׵j   A׵k   A׵l   A׵m   A׵nj   A׵oK   A׵p,   A׵q
   A׵q   A׵r   A׵s   A׵t   A׵ur   A׵vS   A׵w4   A׵x   A׵x   A׵y   A׵z   A׵{   A׵|z   A׵}[   A׵~<   A׵   A׵   A׵   A׵   A׵   A׵   A׵c   A׵D   A׵%   A׵   A׵   A׵   A׵   A׵   A׵k   A׵L   A׵-   A׵   A׵   A׵   A׵   A׵   A׵s   A׵T   A׵5   A׵   A׵   A׵   A׵   A׵   A׵{   A׵\   A׵=   A׵   A׵   A׵   A׵   A׵   A׵   A׵d   A׵E   A׵&   A׵   A׵   A׵   A׵   A׵   A׵l   A׵M   A׵.   A׵   A׵   A׵   A׵   A׵   A׵t   A׵U   A׵6   A׵   A׵   A׵   A׵   A׵   A׵|   A׵]   A׵>   A׵   A׵    A׵   A׵   A׵   A׵   A׵e   A׵F   A׵'   A׵   A׵   A׵   A׵ë   A׵Č   A׵m   A׵N   A׵/   A׵   A׵   A׵   A׵ʳ   A׵˔   A׵u   A׵V   A׵7   A׵   A׵   A׵   A׵ѻ   A׵Ҝ   A׵}   A׵^   A׵?   A׵    A׵   A׵   A׵   A׵٤   A׵څ   A׵f   A׵G   A׵(   A׵	   A׵   A׵   A׵   A׵   A׵n   A׵O   A׵0   A׵   A׵   A׵   A׵   A׵   A׵v   A׵W   A׵8   A׵   A׵   A׵   A׵   A׵   A׵~   A׵_   A׵@   A׵!   A׵   A׵   A׵   A׵   A׵   A׵g   A׵H   A׵)   A׵
   A׵   A׵   A׵   A׵   A׵o   A׶ P   A׶1   A׶   A׶   A׶   A׶   A׶   A׶w   A׶X   A׶9   A׶	   A׶	   A׶
   A׶   A׶   A׶
   A׶`   A׶A   A׶"   A׶   A׶   A׶   A׶   A׶   A׶h   A׶I   A׶*   A׶   A׶   A׶   A׶   A׶   A׶p   A׶Q   A׶2   A׶   A׶   A׶    A׶!   A׶"   A׶#x   A׶$Y   A׶%:   A׶&   A׶&   A׶'   A׶(   A׶)   A׶*   A׶+a   A׶,B   A׶-#   A׶.   A׶.   A׶/   A׶0   A׶1   A׶2i   A׶3J   A׶4+   A׶5   A׶5   A׶6   A׶7   A׶8   A׶9q   A׶:R   A׶;3   A׶<   A׶<   A׶=   A׶>   A׶?   A׶@y   A׶AZ   A׶B;   A׶C   A׶C   A׶D   A׶E   A׶F   A׶G   A׶Hb   A׶IC   A׶J$   A׶K   A׶K   A׶L   A׶M   A׶N   A׶Oj   A׶PK   A׶Q,   A׶R
   A׶R   A׶S   A׶T   A׶U   A׶Vr   A׶WS   A׶X4   A׶Y   A׶Y   A׶Z   A׶[   A׶\   A׶]z   A׶^[   A׶_<   A׶`   A׶`   A׶a   A׶b   A׶c   A׶d   A׶ec   A׶fD   A׶g%   A׶h   A׶h   A׶i   A׶j   A׶k   A׶lk   A׶mL   A׶n-   A׶o   A׶o   A׶p   A׶q   A׶r   A׶ss   A׶tT   A׶u5   A׶v   A׶v   A׶w   A׶x   A׶y   A׶z{   A׶{\   A׶|=   A׶}   A׶}   A׶~   A׶   A׶   A׶   A׶d   A׶E   A׶&   A׶   A׶   A׶   A׶   A׶   A׶l   A׶M   A׶.   A׶   A׶   A׶   A׶   A׶   A׶t   A׶U   A׶6   A׶   A׶   A׶   A׶   A׶   A׶|   A׶]   A׶>   A׶   A׶    A׶   A׶   A׶   A׶   A׶e   A׶F   A׶'   A׶   A׶   A׶   A׶   A׶   A׶m   A׶N   A׶/   A׶   A׶   A׶   A׶   A׶   A׶u   A׶V   A׶7   A׶   A׶   A׶   A׶   A׶   A׶}   A׶^   A׶?   A׶    A׶   A׶   A׶   A׶   A׶   A׶f   A׶G   A׶(   A׶	   A׶   A׶   A׶   A׶   A׶n   A׶O   A׶0   A׶   A׶   A׶   A׶ȴ   A׶ɕ   A׶v   A׶W   A׶8   A׶   A׶   A׶   A׶ϼ   A׶Н   A׶~   A׶_   A׶@   A׶!   A׶   A׶   A׶   A׶ץ   A׶؆   A׶g   A׶H   A׶)   A׶
   A׶   A׶   A׶ޭ   A׶ߎ   A׶o   A׶P   A׶1   A׶   A׶   A׶   A׶   A׶   A׶w   A׶X   A׶9   A׶   A׶   A׶   A׶   A׶   A׶   A׶`   A׶A   A׶"   A׶   A׶   A׶   A׶   A׶   A׶h   A׶I   A׶*   A׶   A׶   A׶   A׶   A׶   A׶p   A׶Q   A׶2   A׷    A׷    A׷   A׷   A׷   A׷x   A׷Y   A׷:   A׷   A׷   A׷   A׷	   A׷
   A׷   A׷a   A׷
B   A׷#   A׷   A׷   A׷   A׷   A׷   A׷i   A׷J   A׷+   A׷   A׷   A׷   A׷   A׷   A׷q   A׷R   A׷3   A׷   A׷   A׷   A׷   A׷    A׷!y   A׷"Z   A׷#;   A׷$   A׷$   A׷%   A׷&   A׷'   A׷(   A׷)b   A׷*C   A׷+$   A׷,   A׷,   A׷-   A׷.   A׷/   A׷0j   A׷1K   A׷2,   A׷3
   A׷3   A׷4   A׷5   A׷6   A׷7r   A׷8S   A׷94   A׷:   A׷:   A׷;   A׷<   A׷=   A׷>z   A׷?[   A׷@<   A׷A   A׷A   A׷B   A׷C   A׷D   A׷E   A׷Fc   A׷GD   A׷H%   A׷I   A׷I   A׷J   A׷K   A׷L   A׷Mk   A׷NL   A׷O-   A׷P   A׷P   A׷Q   A׷R   A׷S   A׷Ts   A׷UT   A׷V5   A׷W   A׷W   A׷X   A׷Y   A׷Z   A׷[{   A׷\\   A׷]=   A׷^   A׷^   A׷_   A׷`   A׷a   A׷b   A׷cd   A׷dE   A׷e&   A׷f   A׷f   A׷g   A׷h   A׷i   A׷jl   A׷kM   A׷l.   A׷m   A׷m   A׷n   A׷o   A׷p   A׷qt   A׷rU   A׷s6   A׷t   A׷t   A׷u   A׷v   A׷w   A׷x|   A׷y]   A׷   A׷   A׷n   A׷O   A׷0   A׷   A׷   A׷   A׷   A׷   A׷v   A׷W   A׷8   A׷   A׷   A׷   A׷   A׷   A׷~   A׷_   A׷@   A׷!   A׷   A׷   A׷   A׷   A׷   A׷g   A׷H   A׷)   A׷
   A׷   A׷   A׷   A׷   A׷o   A׷P   A׷1   A׷   A׷   A׷   A׷Ƶ   A׷ǖ   A׷w   A׷X   A׷9   A׷+   A׷   A׷   A׷   A׷   A׷   A׷q   A׷R   A׷3   A׷   A׷   A׷   A׸    A׸   A׸y   A׸Z   A׸;   A׸   A׸   A׸   A׸   A׸   A׸	   A׸
b   A׸C   A׸$   A׸
   A׸
   A׸   A׸   A׸   A׸j   A׸K   A׸,   A׸
   A׸   A׸   A׸   A׸   A׸r   A׸S   A׸4   A׸   A׸   A׸   A׸   A׸   A׸z   A׸Kl   A׸LM   A׸M.   A׸N   A׸N   A׸O   A׸P   A׸Q   A׸Rt   A׸SU   A׸T6   A׸U   A׸U   A׸V   A׸W   A׸X   A׸Y|   A׸Z]   A׸[>   A׸\   A׸]    A׸]   A׸^   A׸_   A׸`   A׸ae   A׸bF   A׸c'   A׸d   A׸d   A׸e   A׸f   A׸g   A׸hm   A׸iN   A׸j/   A׸k   A׸k   A׸l   A׸m   A׸n   A׸ou   A׸pV   A׸q7   A׸r   A׸r   A׸s   A׸   A׸   A׸o   A׸P   A׸1   A׸   A׸   A׸   A׸   A׸   A׸w   A׸X   A׸9   A׸   A׸   A׸   A׸   A׸   A׸   A׸`   A׸A   A׸"   A׸   A׸   A׸   A׸   A׸   A׸h   A׸I   A׸*   A׸   A׸   A׸   A׸   A׸   A׸p   A׸Q   A׸2   A׸   A׸   A׸   A׸Ķ   A׸ŗ   A׸x   A׸Y   A׸:   A׸   A׸   A׸   A׸˾   A׸̟   A׸̀   A׸a   A׸   A׸   A׸   A׸   A׸r   A׸S   A׸4   A׸   A׸   A׸   A׸   A׸   A׹ z   A׹[   A׹<   A׹   A׹   A׹   A׹   A׹   A׹   A׹c   A׹	D   A׹
%   A׹   A׹   A׹   A׹
   A׹   A׹k   A׹L   A׹-   A׹   A׹F   A׹G   A׹H   A׹Im   A׹JN   A׹K/   A׹L   A׹L   A׹M   A׹N   A׹O   A׹Pu   A׹QV   A׹R7   A׹S   A׹S   A׹T   A׹U   A׹V   A׹W}   A׹X^   A׹Y?   A׹Z    A׹[   A׹[   A׹\   A׹]   A׹^   A׹_f   A׹`G   A׹a(   A׹b	   A׹b   A׹c   A׹d   A׹e   A׹fn   A׹gO   A׹h0   A׹i   A׹p   A׹Q   A׹2   A׹   A׹   A׹   A׹   A׹   A׹x   A׹Y   A׹:   A׹   A׹   A׹   A׹   A׹   A׹   A׹a   A׹B   A׹#   A׹   A׹   A׹   A׹   A׹k   A׹L   A׹-   A׹   A׹   A׹   A׹   A׹   A׹s   A׹T   A׹5   A׹   A׹   A׹   A׹   A׹   A׹{   A׹\   A׺ =   A׺   A׺   A׺   A׺   A׺   A׺   A׺d   A׺E   A׺&   A׺	   A׺	   A׺
   A׺   A׺   A׺
l   A׺M   A׺.   A׺   A׺   A׺   A׺   A׺   A׺t   A׺U   A׺6   A׺   A׺   A׺   A׺   A׺   A׺|   A׺]   A׺>   A׺   A׺    A׺   A׺F   A׺Gn   A׺HO   A׺I0   A׺J   A׺J   A׺K   A׺L   A׺M   A׺Nv   A׺OW   A׺P8   A׺Q   A׺Q   A׺R   A׺S   A׺T   A׺U~   A׺V_   A׺W@   A׺X!   A׺Y   A׺Y   A׺Z   A׺[   A׺\   A׺]g   A׺^H   A׺_)   A׺b   A׺c   A׺do   A׺eP   A׺f1   A׺   A׺   A׺   A׺   A׺   A׺q   A׺R   A׺3   A׺   A׺   A׺   A׺   A׺   A׺y   A׺Z   A׺;   A׺   A׺   A׺   A׺   A׺   A׺   A׺l   A׺M   A׺.   A׺   A׺   A׺   A׺   A׺   A׺t   A׺U   A׺6   A׺   A׺   A׺   A׺   A׺   A׺|   A׺]   A׺>   A׺   A׻     A׻    A׻   A׻   A׻   A׻e   A׻F   A׻'   A׻   A׻   A׻   A׻	   A׻
   A׻m   A׻N   A׻
/   A׻   A׻   A׻   A׻   A׻   A׻u   A׻V   A׻7   A׻   A׻   A׻   A׻   A׻   A׻}   A׻^   A׻?   A׻    A׻   A׻   A׻   A׻>g   A׻?H   A׻@)   A׻A
   A׻D   A׻Eo   A׻FP   A׻G1   A׻H   A׻H   A׻I   A׻J   A׻K   A׻Lw   A׻MX   A׻N9   A׻O   A׻O   A׻P   A׻Q   A׻R   A׻S   A׻T`   A׻UA   A׻V"   A׻W   A׻W   A׻X   A׻Y   A׻Z   A׻[h   A׻\I   A׻]*   A׻^   A׻^   A׻_   A׻`   A׻a   A׻bp   A׻cQ   A׻d2   A׻e   A׻e   A׻f   A׻g   A׻h   A׻j   A׻K   A׻,   A׻
   A׻   A׻   A׻   A׻   A׻r   A׻S   A׻4   A׻   A׻   A׻   A׻   A׻   A׻z   A׻[   A׻<   A׻   A׻   A׻   A׻   A׻   A׻   A׻c   A׻D   A׻%   A׻   A׻   A׻   A׻   A׻   A׻k   A׻L   A׻-   A׻   A׻   A׻   A׻   A׻   A׻s   A׻T   A׻5   A׻   A׻   A׻   A׻   A׻   A׻{   A׻\   A׻=   A׻   A׻   A׻   A׻   A׻Ƣ   A׻ǃ   A׻d   A׻E   A׻&   A׻m   A׻N   A׻/   A׻   A׻   A׻   A׻   A׻   A׻u   A׻V   A׻7   A׻   A׻   A׻   A׻   A׻   A׻}   A׻^   A׻?   A׻    A׻   A׻   A׻   A׼    A׼   A׼f   A׼G   A׼(   A׼	   A׼   A׼   A׼   A׼   A׼	n   A׼
O   A׼0   A׼   A׼A   A׼B   A׼Cp   A׼DQ   A׼E2   A׼F   A׼F   A׼G   A׼H   A׼I   A׼Jx   A׼KY   A׼L:   A׼M   A׼M   A׼N   A׼O   A׼P   A׼Q   A׼Ra   A׼SB   A׼T#   A׼U   A׼U   A׼V   A׼W   A׼X   A׼Yi   A׼ZJ   A׼[+   A׼\   A׼\   A׼]   A׼^   A׼_   A׼`q   A׼aR   A׼b3   A׼c   A׼c   A׼d   A׼e   A׼f   A׼gy   A׼hZ   A׼i;   A׼j   A׼j   A׼k   A׼l   A׼m   A׼n   A׼ob   A׼pC   A׼   A׼   A׼   A׼   A׼   A׼k   A׼L   A׼-   A׼   A׼   A׼   A׼   A׼   A׼s   A׼   A׼   A׼   A׼   A׼d   A׼E   A׼&   A׼   A׼   A׼   A׼   A׼   A׼l   A׼M   A׼.   A׼   A׼   A׼   A׼   A׼   A׼t   A׼U   A׼6   A׼   A׼   A׼   A׼   A׼   A׼|   A׼]   A׼>   A׼   A׼    A׼   A׼   A׼ģ   A׼ń   A׼e   A׼F   A׼'   A׼   A׼   A׼   A׼˫   A׼̌   A׼m   A׼N   A׼/   A׼   A׼   A׼   A׼ҳ   A׼Ӕ   A׼u   A׼V   A׼7   A׼   A׼   A׼   A׼ٻ   A׼ڜ   A׼}   A׼^   A׼?   A׼    A׼   A׼   A׼   A׼   A׼   A׼f   A׼G   A׼(   A׼	   A׼   A׼   A׼   A׼   A׼n   A׼O   A׼0   A׼   A׼   A׼   A׼   A׼   A׼v   A׼W   A׼8   A׼   A׼   A׼   A׼   A׼   A׼~   A׼_   A׼@   A׼!   A׼   A׼   A׼   A׼   A׼   A׽ g   A׽H   A׽)   A׽
   A׽   A׽   A׽   A׽   A׽o   A׽P   A׽	1   A׽
   A׽
   A׽   A׽   A׽
   A׽w   A׽X   A׽9   A׽   A׽   A׽   A׽   A׽   A׽   A׽`   A׽A   A׽"   A׽   A׽   A׽   A׽   A׽   A׽h   A׽I   A׽*   A׽    A׽    A׽!   A׽"   A׽#   A׽$p   A׽%Q   A׽&2   A׽'   A׽'   A׽(   A׽)   A׽*   A׽+x   A׽,Y   A׽-:   A׽.   A׽.   A׽/   A׽0   A׽1   A׽2   A׽3a   A׽4B   A׽5#   A׽6   A׽6   A׽7   A׽8   A׽9   A׽:i   A׽;J   A׽<+   A׽=   A׽=   A׽>   A׽?   A׽@   A׽Aq   A׽BR   A׽C3   A׽D   A׽D   A׽E   A׽F   A׽G   A׽Hy   A׽IZ   A׽J;   A׽K   A׽K   A׽L   A׽M   A׽N   A׽O   A׽Pb   A׽QC   A׽R$   A׽S   A׽S   A׽T   A׽U   A׽V   A׽Wj   A׽XK   A׽Y,   A׽Z
   A׽Z   A׽[   A׽\   A׽]   A׽^r   A׽_S   A׽`4   A׽a   A׽a   A׽b   A׽c   A׽d   A׽ez   A׽f[   A׽g<   A׽h   A׽h   A׽i   A׽j   A׽k   A׽l   A׽mc   A׽nD   A׽o%   A׽p   A׽p   A׽q   A׽r   A׽s   A׽tk   A׽uL   A׽v-   A׽w   A׽w   A׽x   A׽y   A׽z   A׽{s   A׽|T   A׽}5   A׽~   A׽~   A׽   A׽   A׽   A׽{   A׽\   A׽=   A׽   A׽   A׽   A׽   A׽   A׽   A׽d   A׽E   A׽&   A׽   A׽   A׽   A׽   A׽   A׽l   A׽M   A׽.   A׽   A׽   A׽   A׽   A׽   A׽t   A׽U   A׽6   A׽   A׽   A׽   A׽   A׽   A׽|   A׽]   A׽>   A׽   A׽    A׽   A׽   A׽   A׽   A׽e   A׽F   A׽'   A׽   A׽   A׽   A׽   A׽   A׽m   A׽N   A׽/   A׽   A׽   A׽   A׽   A׽   A׽u   A׽V   A׽7   A׽   A׽   A׽   A׽   A׽   A׽}   A׽^   A׽?   A׽    A׽   A׽   A׽   A׽¤   A׽Å   A׽f   A׽G   A׽(   A׽	   A׽   A׽   A׽ɬ   A׽ʍ   A׽n   A׽O   A׽0   A׽   A׽   A׽   A׽д   A׽ѕ   A׽v   A׽W   A׽8   A׽   A׽   A׽   A׽׼   A׽؝   A׽~   A׽_   A׽@   A׽!   A׽   A׽   A׽   A׽ߥ   A׽   A׽g   A׽H   A׽)   A׽
   A׽   A׽   A׽   A׽   A׽o   A׽P   A׽1   A׽   A׽   A׽   A׽   A׽   A׽w   A׽X   A׽9   A׽   A׽   A׽   A׽   A׽   A׽   A׽`   A׽A   A׽"   A׽   A׽   A׽   A׽   A׽   A׽h   A׽I   A׾ *   A׾   A׾   A׾   A׾   A׾   A׾p   A׾Q   A׾2   A׾   A׾   A׾	   A׾
   A׾   A׾x   A׾
Y   A׾:   A׾   A׾   A׾   A׾   A׾   A׾   A׾a   A׾B   A׾#   A׾   A׾   A׾   A׾   A׾   A׾i   A׾J   A׾+   A׾   A׾   A׾   A׾    A׾!   A׾"q   A׾#R   A׾$3   A׾%   A׾%   A׾&   A׾'   A׾(   A׾)y   A׾*Z   A׾+;   A׾,   A׾,   A׾-   A׾.   A׾/   A׾0   A׾1b   A׾2C   A׾3$   A׾4   A׾4   A׾5   A׾6   A׾7   A׾8j   A׾9K   A׾:,   A׾;
   A׾;   A׾<   A׾=   A׾>   A׾?r   A׾@S   A׾A4   A׾B   A׾B   A׾C   A׾D   A׾E   A׾Fz   A׾G[   A׾H<   A׾I   A׾I   A׾J   A׾K   A׾L   A׾M   A׾Nc   A׾OD   A׾P%   A׾Q   A׾Q   A׾R   A׾S   A׾T   A׾Uk   A׾VL   A׾W-   A׾X   A׾X   A׾Y   A׾Z   A׾[   A׾\s   A׾]T   A׾^5   A׾_   A׾_   A׾`   A׾a   A׾b   A׾c{   A׾d\   A׾e=   A׾f   A׾f   A׾g   A׾h   A׾i   A׾j   A׾kd   A׾lE   A׾m&   A׾n   A׾n   A׾o   A׾p   A׾q   A׾rl   A׾sM   A׾t.   A׾u   A׾u   A׾v   A׾w   A׾x   A׾yt   A׾zU   A׾{6   A׾|   A׾|   A׾}   A׾~   A׾   A׾|   A׾]   A׾>   A׾   A׾    A׾   A׾   A׾   A׾   A׾e   A׾F   A׾'   A׾   A׾   A׾   A׾   A׾   A׾m   A׾N   A׾/   A׾   A׾   A׾   A׾   A׾   A׾u   A׾V   A׾7   A׾   A׾   A׾   A׾   A׾   A׾}   A׾^   A׾?   A׾    A׾   A׾   A׾   A׾   A׾   A׾f   A׾G   A׾(   A׾	   A׾   A׾   A׾   A׾   A׾n   A׾O   A׾0   A׾   A׾   A׾   A׾   A׾   A׾v   A׾W   A׾8   A׾   A׾   A׾   A׾   A׾   A׾~   A׾_   A׾@   A׾!   A׾   A׾   A׾   A׾   A׾   A׾g   A׾H   A׾)   A׾
   A׾   A׾   A׾ǭ   A׾Ȏ   A׾o   A׾P   A׾1   A׾   A׾   A׾   A׾ε   A׾ϖ   A׾w   A׾X   A׾9   A׾   A׾   A׾   A׾ս   A׾֞   A׾   A׾`   A׾A   A׾"   A׾   A׾   A׾   A׾ݦ   A׾އ   A׾h   A׾I   A׾*   A׾   A׾   A׾   A׾   A׾   A׾p   A׾Q   A׾2   A׾   A׾   A׾   A׾   A׾   A׾x   A׾Y   A׾:   A׾   A׾   A׾   A׾   A׾   A׾   A׾a   A׾B   A׾#   A׾   A׾   A׾   A׾   A׾   A׾i   A׾J   A׾+   A׾   A׾   A׿    A׿   A׿   A׿q   A׿R   A׿3   A׿   A׿   A׿   A׿   A׿	   A׿
y   A׿Z   A׿;   A׿
   A׿
   A׿   A׿   A׿   A׿   A׿b   A׿C   A׿$   A׿   A׿   A׿   A׿   A׿   A׿j   A׿K   A׿,   A׿
   A׿   A׿   A׿   A׿   A׿ r   A׿!S   A׿"4   A׿#   A׿#   A׿$   A׿%   A׿&   A׿'z   A׿([   A׿)<   A׿*   A׿*   A׿+   A׿,   A׿-   A׿.   A׿/c   A׿0D   A׿1%   A׿2   A׿2   A׿3   A׿4   A׿5   A׿6k   A׿7L   A׿8-   A׿9   A׿9   A׿:   A׿;   A׿<   A׿=s   A׿>T   A׿?5   A׿@   A׿@   A׿A   A׿B   A׿C   A׿D{   A׿E\   A׿F=   A׿G   A׿G   A׿H   A׿I   A׿J   A׿K   A׿Ld   A׿ME   A׿N&   A׿O   A׿O   A׿P   A׿Q   A׿R   A׿Sl   A׿TM   A׿U.   A׿V   A׿V   A׿W   A׿X   A׿Y   A׿Zt   A׿[U   A׿\6   A׿]   A׿]   A׿^   A׿_   A׿`   A׿a|   A׿b]   A׿c>   A׿d   A׿e    A׿e   A׿f   A׿g   A׿h   A׿ie   A׿jF   A׿k'   A׿l   A׿l   A׿m   A׿n   A׿o   A׿pm   A׿qN   A׿r/   A׿s   A׿s   A׿t   A׿u   A׿v   A׿wu   A׿xV   A׿y7   A׿z   A׿z   A׿{   A׿|   A׿}   A׿~}   A׿^   A׿?   A׿    A׿   A׿   A׿   A׿   A׿   A׿f   A׿G   A׿(   A׿	   A׿   A׿   A׿   A׿   A׿n   A׿O   A׿0   A׿   A׿   A׿   A׿   A׿   A׿v   A׿W   A׿8   A׿   A׿   A׿   A׿   A׿   A׿~   A׿_   A׿@   A׿!   A׿   A׿   A׿   A׿   A׿   A׿g   A׿H   A׿)   A׿
   A׿   A׿   A׿   A׿   A׿o   A׿P   A׿1   A׿   A׿   A׿   A׿   A׿   A׿w   A׿X   A׿9   A׿   A׿   A׿   A׿   A׿   A׿   A׿`   A׿A   A׿"   A׿   A׿   A׿   A׿   A׿   A׿h   A׿I   A׿*   A׿   A׿   A׿   A׿Ů   A׿Ə   A׿p   A׿Q   A׿2   A׿   A׿   A׿   A׿̶   A׿͗   A׿x   A׿Y   A׿:   A׿   A׿   A׿   A׿Ӿ   A׿ԟ   A׿Հ   A׿a   A׿B   A׿#   A׿   A׿   A׿   A׿ۧ   A׿܈   A׿i   A׿J   A׿+   A׿   A׿   A׿   A׿   A׿   A׿q   A׿R   A׿3   A׿   A׿   A׿   A׿   A׿   A׿y   A׿Z   A׿;   A׿   A׿   A׿   A׿   A׿   A׿   A׿b   A׿C   A׿$   A׿   A׿   A׿   A׿   A׿   A׿j   A׿K   A׿,   A׿
   A׿   A׿   A׿   A    Ar   AS   A4   A   A   A   A   A   Az   A	[   A
<   A   A   A   A
   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A 5   A!   A!   A"   A#   A$   A%{   A&\   A'=   A(   A(   A)   A*   A+   A,   A-d   A.E   A/&   A0   A0   A1   A2   A3   A4l   A5M   A6.   A7   A7   A8   A9   A:   A;t   A<U   A=6   A>   A>   A?   A@   AA   AB|   AC]   AD>   AE   AF    AF   AG   AH   AI   AJe   AKF   AL'   AM   AM   AN   AO   AP   AQm   ARN   AS/   AT   AT   AU   AV   AW   AXu   AYV   AZ7   A[   A[   A\   A]   A^   A_}   A`^   Aa?   Ab    Ac   Ac   Ad   Ae   Af   Agf   AhG   Ai(   Aj	   Aj   Ak   Al   Am   Ann   AoO   Ap0   Aq   Aq   Ar   As   At   Auv   AvW   Aw8   Ax   Ax   Ay   Az   A{   A|~   A}_   A~@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   Aï   AĐ   Aq   AR   A3   A   A   A   Aʷ   A˘   Ay   AZ   A;   A   A   A   Aѿ   AҠ   AӁ   Ab   AC   A$   A   A   A   A٨   Aډ   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   A T   A5   A   A   A   A   A   A{   A\   A=   A	   A	   A
   A   A   A
   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A    A!   A"   A#|   A$]   A%>   A&   A'    A'   A(   A)   A*   A+e   A,F   A-'   A.   A.   A/   A0   A1   A2m   A3N   A4/   A5   A5   A6   A7   A8   A9u   A:V   A;7   A<   A<   A=   A>   A?   A@}   AA^   AB?   AC    AD   AD   AE   AF   AG   AHf   AIG   AJ(   AK	   AK   AL   AM   AN   AOn   APO   AQ0   AR   AR   AS   AT   AU   AVv   AWW   AX8   AY   AY   AZ   A[   A\   A]~   A^_   A_@   A`!   Aa   Aa   Ab   Ac   Ad   Aeg   AfH   Ag)   Ah
   Ah   Ai   Aj   Ak   Alo   AmP   An1   Ao   Ao   Ap   Aq   Ar   Asw   AtX   Au9   Av   Av   Aw   Ax   Ay   Az   A{`   A|A   A}"   A~   A~   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   Aȸ   Aə   Az   A[   A<   A   A   A   A   AС   Aт   Ac   AD   A%   A   A   A   Aש   A؊   Ak   AL   A-   A   A   A   Aޱ   Aߒ   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A    A    A   A   A   A|   A]   A>   A   A    A   A	   A
   A   Ae   A
F   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A    A!}   A"^   A#?   A$    A%   A%   A&   A'   A(   A)f   A*G   A+(   A,	   A,   A-   A.   A/   A0n   A1O   A20   A3   A3   A4   A5   A6   A7v   A8W   A98   A:   A:   A;   A<   A=   A>~   A?_   A@@   AA!   AB   AB   AC   AD   AE   AFg   AGH   AH)   AI
   AI   AJ   AK   AL   AMo   ANP   AO1   AP   AP   AQ   AR   AS   ATw   AUX   AV9   AW   AW   AX   AY   AZ   A[   A\`   A]A   A^"   A_   A_   A`   Aa   Ab   Ach   AdI   Ae*   Af   Af   Ag   Ah   Ai   Ajp   AkQ   Al2   Am   Am   An   Ao   Ap   Aqx   ArY   As:   At   At   Au   Av   Aw   Ax   Aya   AzB   A{#   A|   A|   A}   A~   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A 
   A    A¡   A¢   A£   A¤r   A¥S   A¦4   A§   A§   A¨   A©   Aª   A«z   A¬[   A­<   A®   A®   A¯   A°   A±   A²   A³c   A´D   Aµ%   A¶   A¶   A·   A¸   A¹   Aºk   A»L   A¼-   A½   A½   A¾   A¿   A   As   AT   A5   A   A   A   Aƹ   Aǚ   A{   A\   A=   A   A   A   A   A΢   Aσ   Ad   AE   A&   A   A   A   Aժ   A֋   Al   AM   A.   A   A   A   Aܲ   Aݓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A    A   A}   A^   A?   A    A   A   A   A   A	   A
f   AG   A(   A
	   A
   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A _   A!@   A"!   A#   A#   A$   A%   A&   A'g   A(H   A))   A*
   A*   A+   A,   A-   A.o   A/P   A01   A1   A1   A2   A3   A4   A5w   A6X   A79   A8   A8   A9   A:   A;   A<   A=`   A>A   A?"   A@   A@   AA   AB   AC   ADh   AEI   AF*   AG   AG   AH   AI   AJ   AKp   ALQ   AM2   AN   AN   AO   AP   AQ   ARx   ASY   AT:   AU   AU   AV   AW   AX   AY   AZa   A[B   AÂ   AÃ   AÄ   AÅr   AÆS   AÇ4   AÈ   AÈ   AÉ   AÊ   AË   AÌz   AÍ[   AÎ<   AÏ   AÏ   AÐ   AÑ   AÒ   AÓ   AÔc   AÕD   AÖ%   A×   A×   AØ   AÙ   AÚ   AÛk   AÜL   AÝ-   AÞ   AÞ   Aß   Aà   A/   A   A   A   Aڳ   A۔   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   A'*   A(   A(   A)   A*   A+   A,p   A-Q   A.2   A/   A/   A0   A1   A2   A3x   A4Y   A5:   A6   A6   A7   A8   A9   A:   A;a   A<B   A=#   A>   A>   A?   A@   AA   ABi   ACJ   AD+   AE   AE   AF   AG   AH   AIq   AJR   AK3   AL   AL   AM   AN   AO   APy   AQZ   AR;   AS   AS   AT   Az   A{   A|k   A}L   A~-   A   A   AĀ   Aā   AĂ   Aăs   AĄT   Aą5   AĆ   AĆ   Ać   AĈ   Aĉ   AĊ{   Aċ\   AČ=   Ač   Ač   AĎ   Aď   AĐ   Ađ   AĒd   AēE   AĔ&   Aĕ   A   A   AѬ   Aҍ   An   AO   A0   A   A   A   Aش   Aٕ   Av   AW   A8   A   A   A   A߼   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A"   A#i   A$J   A%+   A&   A&   A'   A(   A)   A*q   A+R   A,3   A-   A-   A.   A/   A0   A1y   A2Z   A3;   A4   A4   A5   A6   A7   A8   A9b   A:C   A;$   A<   A<   A=   A>   A?   A@j   AAK   AB,   AC
   AC   AD   AE   AF   AGr   AHS   AI4   AJ   AJ   AK   AL   AM   ANz   AO[   AP<   AQ   AQ   AR   AS   AT   AU   AVc   AWD   AX%   AY   AY   Azl   A{M   A|.   A}   A}   A~   A   Aŀ   AŁt   AłU   AŃ6   Ań   Ań   AŅ   Aņ   AŇ   Aň|   Aŉ]   AŊ>   Aŋ   AŌ    AŌ   Aō   AŎ   Aŏ   AŐe   AőF   AŒ'   Aœ   Aœ   AŔ   Aŕ   AŖ   Aŗm   AŘN   Ař/   AŚ   AŚ   Aś   AŜ   Aŝ   AŞu   AşV   AŠ7   Aš   Aš   AŢ   Aţ   AŤ   Ať}   AŦ^   Aŧ?   AŨ    Aũ   Aũ   AŪ   Aū   AŬ   Aŭf   AŮG   Aů(   AŰ	   AŰ   AH   A)   A
   A   A   Aϭ   AЎ   Ao   AP   A1   A   A   A   Aֵ   Aז   Aw   AX   A9   A   A   A   Aݽ   Aޞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A!j   A"K   A#,   A$
   A$   A%   A&   A'   A(r   A)S   A*4   A+   A+   A,   A-   A.   A/z   A0[   A1<   A2   A2   A3   A4   A5   A6   A7c   A8D   A9%   A:   A:   A;   A<   A=   A>k   A?L   A@-   AA   AA   AB   AC   AD   AEs   AFT   AG5   AH   AH   AI   AJ   AK   AyN   Az/   A{   A{   A|   A}   A~   Au   AƀV   AƁ7   AƂ   AƂ   Aƃ   AƄ   Aƅ   AƆ}   AƇ^   Aƈ?   AƉ    Aƍ   AƎf   AƏG   AƐ(   AƑ	   AƑ   Aƒ   AƓ   AƔ   Aƕn   AƖO   AƗ0   AƘ   AƘ   Aƙ   Aƚ   Aƛ   AƜv   AƝW   Aƞ8   AƟ   AƟ   AƠ   Aơ   AƢ   Aƣ~   AƤ_   Aƥ@   AƦ!   AƧ   AƧ   Aƨ   AƩ   Aƪ   Aƫg   AƬH   Aƭ)   AƮ
   AƮ   AƯ   Aư   AƱ   AƲo   AƳP   Aƴ1   AƵ   AƵ   Aƶ   AƷ   AƸ   Aƹw   AƺX   Aƻ9   AƼ   AƼ   Aƽ   Aƾ   A   Aͮ   AΏ   Ap   AQ   A2   A   A   A   AԶ   A՗   Ax   AY   A:   A   A   A   A۾   Aܟ   A݀   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A    A   Aj   AK   A,   A
   A   A   A   A   A	r   A
S   A4   A   A   A
   A   A   A   A   Ak   A L   A!-   A"   A"   A#   A$   A%   A&s   A'T   A(5   A)   A)   A*   A+   A,   A-{   A.\   A/=   A0   A0   A1   A2   A3   A4   A5d   A6E   A7&   A8   A8   A9   A:   A;   A<l   A=M   A>.   A?   A?   A@   AA   AB   ACt   ADU   AE6   AF   AF   AG   AH   AI   AJ|   AK]   AL>   AM   AN    AN   AO   AP   AQ   ARe   ASF   AT'   AU   AU   AV   AW   AX   AYm   AZN   A[/   A\   A\   A]   A^   A_   Aq(   Ar	   Ar   As   At   Au   Avn   AwO   Ax0   Ay   Ay   Az   A{   A|   A}v   A~W   A8   Aǀ   Aǀ   Aǁ   Aǂ   Aǃ   AǄ~   Aǅ_   Aǆ@   AǇ!   Aǈ   Aǈ   Aǉ   AǊ   Aǋ   Aǌg   AǍH   Aǎ)   AǏ
   AǏ   Aǐ   AǑ   Aǒ   AǓo   AǔP   AǕ1   Aǖ   Aǖ   AǗ   Aǘ   AǙ   Aǚw   AǛX   Aǜ9   Aǝ   Aǝ   AǞ   Aǟ   AǠ   Aǡ   AǢ`   AǣA   AǤ"   Aǥ   Aǥ   A   A   A˯   A̐   Aq   AR   Aҷ   AӘ   Ay   AZ   A;   A   A   A   Aٿ   Aڠ   Aہ   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   A k   AL   A-   A   A   A   A   A   As   AT   A	5   A
   A
   A   A   A
   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A    A    A!   A"   A#   A$t   A%U   A&6   A'   A'   A(   A)   A*   A+|   A,]   A->   A.   A/    A/   A0   A1   A2   A3e   A4F   A5'   A6   A6   A7   A8   A9   A:m   A;N   A</   A=   A=   A>   A?   A@   AAu   ABV   AC7   AD   AD   AE   AF   AG   AH}   AI^   AJ?   AK    AL   AL   AM   AN   AO   APf   AQG   AR(   AS	   AS   AT   AU   AV   AWn   AXO   AY0   AZ   AZ   A[   A\   A]   A^v   A_W   A`8   Aa   Aa   Ab   Ac   Ad   Ae~   Af_   Ag@   Ah!   Ai   Ai   Aj   Ak   Al   Amg   AnH   Ao)   Ap
   Ap   Aq   Ar   As   Ato   AuP   Av1   Aw   Aw   Ax   Ay   Az   A{w   A|X   A}9   A~   A~   A   AȀ   Aȁ   AȂ   Aȃ`   AȄA   Aȅ"   AȆ   AȆ   Aȇ   AȈ   Aȉ   AȊh   AȋI   AȌ*   Aȍ   Aȍ   AȎ   Aȏ   AȐ   Aȑp   AȒQ   Aȓ2   AȔ   AȔ   Aȕ   AȖ   Aȗ   AȘx   AșY   AȚ:   Aț   Aț   AȜ   Aȝ   AȞ   Aȟ   AȠa   AȡB   AȢ#   Aȣ   Aȣ   AȤ   Aȥ   AȦ   Aȧi   AȨJ   Aȩ+   AȪ   AȪ   Aȫ   AȬ   Aȭ   AȮq   AȯR   AȰ3   Aȱ   Aȱ   AȲ   Aȳ   Aȴ   Aȵy   AȶZ   Aȷ;   Aȸ   Aȸ   Aȹ   AȺ   AȻ   Aȼ   AȽb   AȾC   Aȿ$   A   A   A   A¨   AÉ   Aj   AK   A,   A
   A   A   Aɰ   Aʑ   Ar   AS   A4   A   A   A   Aи   Aљ   Az   A[   A<   A   A   A   A   Aء   Aق   Ac   AD   A%   A   A   A   Aߩ   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A .   A   A   A   A   A   At   AU   A6   A   A   A	   A
   A   A|   A
]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A    A!   A"u   A#V   A$7   A%   A%   A&   A'   A(   A)}   A*^   A+?   A,    A-   A-   A.   A/   A0   A1f   A2G   A3(   A4	   A4   A5   A6   A7   A8n   A9O   A:0   A;   A;   A<   A=   A>   A?v   A@W   AA8   AB   AB   AC   AD   AE   AF~   AG_   AH@   AI!   AJ   AJ   AK   AL   AM   ANg   AOH   AP)   AQ
   AQ   AR   AS   AT   AUo   AVP   AW1   AX   AX   AY   AZ   A[   A\w   A]X   A^9   A_   A_   A`   Aa   Ab   Ac   Ad`   AeA   Af"   Ag   Ag   Ah   Ai   Aj   Akh   AlI   Am*   An   An   Ao   Ap   Aq   Arp   AsQ   At2   Au   Au   Av   Aw   Ax   Ayx   AzY   A{:   A|   A|   A}   A~   A   Aɀ   AɁa   AɂB   AɃ#   AɄ   AɄ   AɅ   AɆ   Aɇ   AɈi   AɉJ   AɊ+   Aɋ   Aɋ   AɌ   Aɍ   AɎ   Aɏq   AɐR   Aɑ3   Aɒ   Aɒ   Aɓ   Aɔ   Aɕ   Aɖy   AɗZ   Aɘ;   Aə   Aə   Aɚ   Aɛ   Aɜ   Aɝ   Aɞb   AɟC   Aɠ$   Aɡ   Aɡ   Aɢ   Aɣ   Aɤ   Aɥj   AɦK   Aɧ,   Aɨ
   Aɨ   Aɩ   Aɪ   Aɫ   Aɬr   AɭS   Aɮ4   Aɯ   Aɯ   Aɰ   Aɱ   Aɲ   Aɳz   Aɴ[   Aɵ<   Aɶ   Aɶ   Aɷ   Aɸ   Aɹ   Aɺ   Aɻc   AɼD   Aɽ%   Aɾ   Aɾ   Aɿ   A   A   Ak   AL   A-   A   A   A   AǱ   AȒ   As   AT   A5   A   A   A   Aι   AϚ   A{   A\   A=   A   A   A   A   A֢   A׃   Ad   AE   A&   A   A   A   Aݪ   Aދ   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A    A   A   Au   AV   A7   A   A   A   A   A	   A
}   A^   A?   A
    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   A v   A!W   A"8   A#   A#   A$   A%   A&   A'~   A(_   A)@   A*!   A+   A+   A,   A-   A.   A/g   A0H   A1)   A2
   A2   A3   A4   A5   A6o   A7P   A81   A9   A9   A:   A;   A<   A=w   A>X   A?9   A@   A@   AA   AB   AC   AD   AE`   AFA   AG"   AH   AH   AI   AJ   AK   ALh   AMI   AN*   AO   AO   AP   AQ   AR   ASp   ATQ   AU2   AV   AV   AW   AX   AY   AZx   A[Y   A\:   A]   A]   A^   A_   A`   Aa   Aba   AcB   Ad#   Ae   Ae   Af   Ag   Ah   Aii   AjJ   Ak+   Al   Al   Am   An   Ao   Apq   AqR   Ar3   As   As   At   Au   Av   Awy   AxZ   Ay;   Az   Az   A{   A|   A}   A~   Ab   AʀC   Aʁ$   Aʂ   Aʂ   Aʃ   Aʄ   Aʅ   Aʆj   AʇK   Aʈ,   Aʉ
   Aʉ   Aʊ   Aʋ   Aʌ   Aʍr   AʎS   Aʏ4   Aʐ   Aʐ   Aʑ   Aʒ   Aʓ   Aʔz   Aʕ[   Aʖ<   Aʗ   Aʗ   Aʘ   Aʙ   Aʚ   Aʛ   Aʜc   AʝD   Aʞ%   Aʟ   Aʟ   Aʠ   Aʡ   Aʢ   Aʣk   AʤL   Aʥ-   Aʦ   Aʦ   Aʧ   Aʨ   Aʩ   Aʪs   AʫT   Aʬ5   Aʭ   Aʭ   Aʮ   Aʯ   Aʰ   Aʱ{   Aʲ\   Aʳ=   Aʴ   Aʴ   Aʵ   Aʶ   Aʷ   Aʸ   Aʹd   AʺE   Aʻ&   Aʼ   Aʼ   Aʽ   Aʾ   Aʿ   Al   AM   A.   A   A   A   AŲ   AƓ   At   AU   A6   A   A   A   A̺   A͛   A|   A]   A>   A   A    A   A   Aԣ   AՄ   Ae   AF   A'   A   A   A   A۫   A܌   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A    Av   AW   A8   A   A   A   A   A   A~   A	_   A
@   A!   A   A   A
   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A 9   A!   A!   A"   A#   A$   A%   A&`   A'A   A("   A)   A)   A*   A+   A,   A-h   A.I   A/*   A0   A0   A1   A2   A3   A4p   A5Q   A62   A7   A7   A8   A9   A:   A;x   A<Y   A=:   A>   A>   A?   A@   AA   AB   ACa   ADB   AE#   AF   AF   AG   AH   AI   AJi   AKJ   AL+   AM   AM   AN   AO   AP   AQq   ARR   AS3   AT   AT   AU   AV   AW   AXy   AYZ   AZ;   A[   A[   A\   A]   A^   A_   A`b   AaC   Ab$   Ac   Ac   Ad   Ae   Af   Agj   AhK   Ai,   Aj
   Aj   Ak   Al   Am   Anr   AoS   Ap4   Aq   Aq   Ar   As   At   Auz   Av[   Aw<   Ax   Ax   Ay   Az   A{   A|   A}c   A~D   A%   Aˀ   Aˀ   Aˁ   A˂   A˃   A˄k   A˅L   Aˆ-   Aˇ   Aˇ   Aˈ   Aˉ   Aˊ   Aˋs   AˌT   Aˍ5   Aˎ   Aˎ   Aˏ   Aː   Aˑ   A˒{   A˓\   A˔=   A˕   A˕   A˖   A˗   A˘   A˙   A˚d   A˛E   A˜&   A˝   A˝   A˞   A˟   Aˠ   Aˡl   AˢM   Aˣ.   Aˤ   Aˤ   A˥   A˦   A˧   A˨t   A˩U   A˪6   A˫   A˫   Aˬ   A˭   Aˮ   A˯|   A˰]   A˱>   A˲   A˳    A˳   A˴   A˵   A˶   A˷e   A˸F   A˹'   A˺   A˺   A˻   A˼   A˽   A˾m   A˿N   A/   A   A   A   Aó   AĔ   Au   AV   A7   A   A   A   Aʻ   A˜   A}   A^   A?   A    A   A   A   AҤ   AӅ   Af   AG   A(   A	   A   A   A٬   Aڍ   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   A X   A9   A   A   A   A   A   A   A`   AA   A	"   A
   A
   A   A   A
   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A    A!   A"   A#   A$a   A%B   A&#   A'   A'   A(   A)   A*   A+i   A,J   A-+   A.   A.   A/   A0   A1   A2q   A3R   A43   A5   A5   A6   A7   A8   A9y   A:Z   A;;   A<   A<   A=   A>   A?   A@   AAb   ABC   AC$   AD   AD   AE   AF   AG   AHj   AIK   AJ,   AK
   AK   AL   AM   AN   AOr   APS   AQ4   AR   AR   AS   AT   AU   AVz   AW[   AX<   AY   AY   AZ   A[   A\   A]   A^c   A_D   A`%   Aa   Aa   Ab   Ac   Ad   Aek   AfL   Ag-   Ah   Ah   Ai   Aj   Ak   Als   AmT   An5   Ao   Ao   Ap   Aq   Ar   As{   At\   Au=   Av   Av   Aw   Ax   Ay   Az   A{d   A|E   A}&   A~   A~   A   À   Á   Âl   ÃM   Ā.   A̅   A̅   Ă   Ȧ   Ä   Ảt   ÅU   A̋6   Ǎ   Ǎ   A̍   A̎   Ȁ   A̐|   Ȃ]   A̒>   A̓   A̔    A̔   A̕   A̖   A̗   A̘e   A̙F   A̚'   A̛   A̛   A̜   A̝   A̞   A̟m   A̠N   A̡/   A̢   A̢   Ạ   A̤   Ḁ   A̦u   A̧V   Ą7   A̩   A̩   A̪   A̫   A̬   A̭}   A̮^   A̯?   A̰    A̱   A̱   A̲   A̳   A̴   A̵f   A̶G   A̷(   A̸	   A̸   A̹   A̺   A̻   A̼n   A̽O   A̾0   A̿   A̿   A   A   A   Av   AW   A8   A   A   A   Aȼ   Aɝ   A~   A_   A@   A!   A   A   A   AХ   Aц   Ag   AH   A)   A
   A   A   A׭   A؎   Ao   AP   A1   A   A   A   A޵   Aߖ   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A    A    A   A   A   A   Aa   AB   A#   A   A   A	   A
   A   Ai   A
J   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A    A!   A"b   A#C   A$$   A%   A%   A&   A'   A(   A)j   A*K   A+,   A,
   A,   A-   A.   A/   A0r   A1S   A24   A3   A3   A4   A5   A6   A7z   A8[   A9<   A:   A:   A;   A<   A=   A>   A?c   A@D   AA%   AB   AB   AC   AD   AE   AFk   AGL   AH-   AI   AI   AJ   AK   AL   AMs   ANT   AO5   AP   AP   AQ   AR   AS   AT{   AU\   AV=   AW   AW   AX   AY   AZ   A[   A\d   A]E   A^&   A_   A_   A`   Aa   Ab   Acl   AdM   Ae.   Af   Af   Ag   Ah   Ai   Ajt   AkU   Al6   Am   Am   An   Ao   Ap   Aq|   Ar]   As>   At   Au    Au   Av   Aw   Ax   Aye   AzF   A{'   A|   A|   A}   A~   A   Àm   ÁN   A͂/   A̓   A̓   Ä́   Aͅ   A͆   A͇u   A͈V   A͉7   A͊   A͊   A͋   A͌   A͍   A͎}   A͏^   A͐?   A͑    A͒   A͒   A͓   A͔   A͕   A͖f   A͗G   A͘(   A͙	   A͙   A͚   A͛   A͜   A͝n   A͞O   A͟0   A͠   A͠   A͡   A͢   Aͣ   Aͤv   AͥW   Aͦ8   Aͧ   Aͧ   Aͨ   Aͩ   Aͪ   Aͫ~   Aͬ_   Aͭ@   Aͮ!   Aͯ   Aͯ   AͰ   Aͱ   AͲ   Aͳg   AʹH   A͵)   AͶ
   AͶ   Aͷ   A͸   A͹   Aͺo   AͻP   Aͼ1   Aͽ   Aͽ   A;   AͿ   A   Aw   AX   A9   A   A   A   Aƽ   AǞ   A   A`   AA   A"   A   A   A   AΦ   Aχ   Ah   AI   A*   A   A   A   Aծ   A֏   Ap   AQ   A2   A   A   A   Aܶ   Aݗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A    A   A   Ab   AC   A$   A   A   A   A   A	   A
j   AK   A,   A

   A
   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   A c   A!D   A"%   A#   A#   A$   A%   A&   A'k   A(L   A)-   A*   A*   A+   A,   A-   A.s   A/T   A05   A1   A1   A2   A3   A4   A5{   A6\   A7=   A8   A8   A9   A:   A;   A<   A=d   A>E   A?&   A@   A@   AA   AB   AC   ADl   AEM   AF.   AG   AG   AH   AI   AJ   AKt   ALU   AM6   AN   AN   AO   AP   AQ   AR|   AS]   AT>   AU   AV    AV   AW   AX   AY   AZe   A[F   A\'   A]   A]   A^   A_   A`   Aam   AbN   Ac/   Ad   Ad   Ae   Af   Ag   Ahu   AiV   Aj7   Ak   Ak   Al   Am   An   Ao}   Ap^   Aq?   Ar    As   As   At   Au   Av   Awf   AxG   Ay(   Az	   Az   A{   A|   A}   A~n   AO   A΀0   A΁   A΁   A΂   A΃   A΄   A΅v   AΆW   A·8   AΈ   AΈ   AΉ   AΊ   A΋   AΌ~   A΍_   AΎ@   AΏ!   Aΐ   Aΐ   AΑ   AΒ   AΓ   AΔg   AΕH   AΖ)   AΗ
   AΗ   AΘ   AΙ   AΚ   AΛo   AΜP   AΝ1   AΞ   AΞ   AΟ   AΠ   AΡ   A΢w   AΣX   AΤ9   AΥ   AΥ   AΦ   AΧ   AΨ   AΩ   AΪ`   AΫA   Aά"   Aέ   Aέ   Aή   Aί   Aΰ   Aαh   AβI   Aγ*   Aδ   Aδ   Aε   Aζ   Aη   Aθp   AιQ   Aκ2   Aλ   Aλ   Aμ   Aν   Aξ   Aοx   AY   A:   A   A   A   Aľ   Aş   Aƀ   Aa   AB   A#   A   A   A   A̧   A͈   Ai   AJ   A+   A   A   A   Aӯ   AԐ   Aq   AR   A3   A   A   A   Aڷ   Aۘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A    Ac   AD   A%   A   A   A   A   A   Ak   A	L   A
-   A   A   A   A
   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A &   A!   A!   A"   A#   A$   A%l   A&M   A'.   A(   A(   A)   A*   A+   A,t   A-U   A.6   A/   A/   A0   A1   A2   A3|   A4]   A5>   A6   A7    A7   A8   A9   A:   A;e   A<F   A='   A>   A>   A?   A@   AA   ABm   ACN   AD/   AE   AE   AF   AG   AH   AIu   AJV   AK7   AL   AL   AM   AN   AO   AP}   AQ^   AR?   AS    AT   AT   AU   AV   AW   AXf   AYG   AZ(   A[	   A[   A\   A]   A^   A_n   A`O   Aa0   Ab   Ab   Ac   Ad   Ae   Afv   AgW   Ah8   Ai   Ai   Aj   Ak   Al   Am~   An_   Ao@   Ap!   Aq   Aq   Ar   As   At   Aug   AvH   Aw)   Ax
   Ax   Ay   Az   A{   A|o   A}P   A~1   A   A   Aπ   Aρ   Aς   Aσw   AτX   Aυ9   Aφ   Aφ   Aχ   Aψ   Aω   Aϊ   Aϋ`   AόA   Aύ"   Aώ   Aώ   AϏ   Aϐ   Aϑ   Aϒh   AϓI   Aϔ*   Aϕ   Aϕ   Aϖ   Aϗ   AϘ   Aϙp   AϚQ   Aϛ2   AϜ   AϜ   Aϝ   AϞ   Aϟ   AϠx   AϡY   AϢ:   Aϣ   Aϣ   AϤ   Aϥ   AϦ   Aϧ   AϨa   AϩB   AϪ#   Aϫ   Aϫ   AϬ   Aϭ   AϮ   Aϯi   AϰJ   Aϱ+   Aϲ   Aϲ   Aϳ   Aϴ   Aϵ   A϶q   AϷR   Aϸ3   AϹ   AϹ   AϺ   Aϻ   Aϼ   AϽy   AϾZ   AϿ;   A   A   A   A¿   Aà   Aā   Ab   AC   A$   A   A   A   Aʨ   Aˉ   Aj   AK   A,   A
   A   A   AѰ   Aґ   Ar   AS   A4   A   A   A   Aظ   Aٙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   A E   A&   A   A   A   A   A   Al   AM   A.   A	   A	   A
   A   A   A
t   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A    A!   A"   A#m   A$N   A%/   A&   A&   A'   A(   A)   A*u   A+V   A,7   A-   A-   A.   A/   A0   A1}   A2^   A3?   A4    A5   A5   A6   A7   A8   A9f   A:G   A;(   A<	   A<   A=   A>   A?   A@n   AAO   AB0   AC   AC   AD   AE   AF   AGv   AHW   AI8   AJ   AJ   AK   AL   AM   AN~   AO_   AP@   AQ!   AR   AR   AS   AT   AU   AVg   AWH   AX)   AY
   AY   AZ   A[   A\   A]o   A^P   A_1   A`   A`   Aa   Ab   Ac   Adw   AeX   Af9   Ag   Ag   Ah   Ai   Aj   Ak   Al`   AmA   An"   Ao   Ao   Ap   Aq   Ar   Ash   AtI   Au*   Av   Av   Aw   Ax   Ay   Azp   A{Q   A|2   A}   A}   A~   A   AЀ   AЁx   AЂY   AЃ:   AЄ   AЄ   AЅ   AІ   AЇ   AЈ   AЉa   AЊB   AЋ#   AЌ   AЌ   AЍ   AЎ   AЏ   AАi   AБJ   AВ+   AГ   AГ   AД   AЕ   AЖ   AЗq   AИR   AЙ3   AК   AК   AЛ   AМ   AН   AОy   AПZ   AР;   AС   AС   AТ   AУ   AФ   AХ   AЦb   AЧC   AШ$   AЩ   AЩ   AЪ   AЫ   AЬ   AЭj   AЮK   AЯ,   Aа
   Aа   Aб   Aв   Aг   Aдr   AеS   Aж4   Aз   Aз   Aи   Aй   Aк   Aлz   Aм[   Aн<   Aо   Aо   Aп   A   A   A   Ac   AD   A%   A   A   A   Aȩ   AɊ   Ak   AL   A-   A   A   A   Aϱ   AВ   As   AT   A5   A   A   A   Aֹ   Aך   A{   A\   A=   A   A   A   A   Aޢ   A߃   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A    A    A   A   A   Am   AN   A/   A   A   A   A	   A
   Au   AV   A
7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A    A!n   A"O   A#0   A$   A$   A%   A&   A'   A(v   A)W   A*8   A+   A+   A,   A-   A.   A/~   A0_   A1@   A2!   A3   A3   A4   A5   A6   A7g   A8H   A9)   A:
   A:   A;   A<   A=   A>o   A?P   A@1   AA   AA   AB   AC   AD   AEw   AFX   AG9   AH   AH   AI   AJ   AK   AL   AM`   ANA   AO"   AP   AP   AQ   AR   AS   ATh   AUI   AV*   AW   AW   AX   AY   AZ   A[p   A\Q   A]2   A^   A^   A_   A`   Aa   Abx   AcY   Ad:   Ae   Ae   Af   Ag   Ah   Ai   Aja   AkB   Al#   Am   Am   An   Ao   Ap   Aqi   ArJ   As+   At   At   Au   Av   Aw   Axq   AyR   Az3   A{   A{   A|   A}   A~   Ay   AрZ   Aс;   Aт   Aт   Aу   Aф   Aх   Aц   Aчb   AшC   Aщ$   Aъ   Aъ   Aы   Aь   Aэ   Aюj   AяK   Aѐ,   Aё
   Aё   Aђ   Aѓ   Aє   Aѕr   AіS   Aї4   Aј   Aј   Aљ   Aњ   Aћ   Aќz   Aѝ[   Aў<   Aџ   Aџ   AѠ   Aѡ   AѢ   Aѣ   AѤc   AѥD   AѦ%   Aѧ   Aѧ   AѨ   Aѩ   AѪ   Aѫk   AѬL   Aѭ-   AѮ   AѮ   Aѯ   AѰ   Aѱ   AѲs   AѳT   AѴ5   Aѵ   Aѵ   AѶ   Aѷ   AѸ   Aѹ{   AѺ\   Aѻ=   AѼ   AѼ   Aѽ   AѾ   Aѿ   A   Ad   AE   A&   A   A   A   Aƪ   Aǋ   Al   AM   A.   A   A   A   AͲ   AΓ   At   AU   A6   A   A   A   AԺ   A՛   A|   A]   A>   A   A    A   A   Aܣ   A݄   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A    A   An   AO   A0   A   A   A   A   A   A	v   A
W   A8   A   A   A
   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   A P   A!1   A"   A"   A#   A$   A%   A&w   A'X   A(9   A)   A)   A*   A+   A,   A-   A.`   A/A   A0"   A1   A1   A2   A3   A4   A5h   A6I   A7*   A8   A8   A9   A:   A;   A<p   A=Q   A>2   A?   A?   A@   AA   AB   ACx   ADY   AE:   AF   AF   AG   AH   AI   AJ   AKa   ALB   AM#   AN   AN   AO   AP   AQ   ARi   ASJ   AT+   AU   AU   AV   AW   AX   AYq   AZR   A[3   A\   A\   A]   A^   A_   A`y   AaZ   Ab;   Ac   Ac   Ad   Ae   Af   Ag   Ahb   AiC   Aj$   Ak   Ak   Al   Am   An   Aoj   ApK   Aq,   Ar
   Ar   As   At   Au   Avr   AwS   Ax4   Ay   Ay   Az   A{   A|   A}z   A~[   A<   AҀ   AҀ   Aҁ   A҂   A҃   A҄   A҅c   A҆D   A҇%   A҈   A҈   A҉   AҊ   Aҋ   AҌk   AҍL   AҎ-   Aҏ   Aҏ   AҐ   Aґ   AҒ   Aғs   AҔT   Aҕ5   AҖ   AҖ   Aҗ   AҘ   Aҙ   AҚ{   Aқ\   AҜ=   Aҝ   Aҝ   AҞ   Aҟ   AҠ   Aҡ   AҢd   AңE   AҤ&   Aҥ   Aҥ   AҦ   Aҧ   AҨ   Aҩl   AҪM   Aҫ.   AҬ   AҬ   Aҭ   AҮ   Aү   AҰt   AұU   AҲ6   Aҳ   Aҳ   AҴ   Aҵ   AҶ   Aҷ|   AҸ]   Aҹ>   AҺ   Aһ    Aһ   AҼ   Aҽ   AҾ   Aҿe   AF   A'   A   A   A   Aī   AŌ   Am   AN   A/   A   A   A   A˳   A̔   Au   AV   A7   A   A   A   Aһ   AӜ   A}   A^   A?   A    A   A   A   Aڤ   Aۅ   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   A o   AP   A1   A   A   A   A   A   Aw   AX   A	9   A
   A
   A   A   A
   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A    A    A!   A"   A#   A$x   A%Y   A&:   A'   A'   A(   A)   A*   A+   A,a   A-B   A.#   A/   A/   A0   A1   A2   A3i   A4J   A5+   A6   A6   A7   A8   A9   A:q   A;R   A<3   A=   A=   A>   A?   A@   AAy   ABZ   AC;   AD   AD   AE   AF   AG   AH   AIb   AJC   AK$   AL   AL   AM   AN   AO   APj   AQK   AR,   AS
   AS   AT   AU   AV   AWr   AXS   AY4   AZ   AZ   A[   A\   A]   A^z   A_[   A`<   Aa   Aa   Ab   Ac   Ad   Ae   Afc   AgD   Ah%   Ai   Ai   Aj   Ak   Al   Amk   AnL   Ao-   Ap   Ap   Aq   Ar   As   Ats   AuT   Av5   Aw   Aw   Ax   Ay   Az   A{{   A|\   A}=   A~   A~   A   AӀ   AӁ   Aӂ   AӃd   AӄE   AӅ&   Aӆ   Aӆ   AӇ   Aӈ   AӉ   Aӊl   AӋM   Aӌ.   AӍ   AӍ   Aӎ   Aӏ   AӐ   Aӑt   AӒU   Aӓ6   AӔ   AӔ   Aӕ   AӖ   Aӗ   AӘ|   Aә]   AӚ>   Aӛ   AӜ    AӜ   Aӝ   AӞ   Aӟ   AӠe   AӡF   AӢ'   Aӣ   Aӣ   AӤ   Aӥ   AӦ   Aӧm   AӨN   Aө/   AӪ   AӪ   Aӫ   AӬ   Aӭ   AӮu   AӯV   AӰ7   Aӱ   Aӱ   AӲ   Aӳ   AӴ   Aӵ}   AӶ^   Aӷ?   AӸ    Aӹ   Aӹ   AӺ   Aӻ   AӼ   Aӽf   AӾG   Aӿ(   A	   A   A   A¬   AÍ   An   AO   A0   A   A   A   Aɴ   Aʕ   Av   AW   A8   A   A   A   Aм   Aѝ   A~   A_   A@   A!   A   A   A   Aإ   Aن   Ag   AH   A)   A
   A   A   A߭   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A 2   A   A   A   A   A   Ax   AY   A:   A   A   A	   A
   A   A   A
a   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A    A!   A"y   A#Z   A$;   A%   A%   A&   A'   A(   A)   A*b   A+C   A,$   A-   A-   A.   A/   A0   A1j   A2K   A3,   A4
   A4   A5   A6   A7   A8r   A9S   A:4   A;   A;   A<   A=   A>   A?z   A@[   AA<   AB   AB   AC   AD   AE   AF   AGc   AHD   AI%   AJ   AJ   AK   AL   AM   ANk   AOL   AP-   AQ   AQ   AR   AS   AT   AUs   AVT   AW5   AX   AX   AY   AZ   A[   A\{   A]\   A^=   A_   A_   A`   Aa   Ab   Ac   Add   AeE   Af&   Ag   Ag   Ah   Ai   Aj   Akl   AlM   Am.   An   An   Ao   Ap   Aq   Art   AsU   At6   Au   Au   Av   Aw   Ax   Ay|   Az]   A{>   A|   A}    A}   A~   A   AԀ   Aԁe   AԂF   Aԃ'   AԄ   AԄ   Aԅ   AԆ   Aԇ   AԈm   AԉN   AԊ/   Aԋ   Aԋ   AԌ   Aԍ   AԎ   Aԏu   AԐV   Aԑ7   AԒ   AԒ   Aԓ   AԔ   Aԕ   AԖ}   Aԗ^   AԘ?   Aԙ    AԚ   AԚ   Aԛ   AԜ   Aԝ   AԞf   AԟG   AԠ(   Aԡ	   Aԡ   AԢ   Aԣ   AԤ   Aԥn   AԦO   Aԧ0   AԨ   AԨ   Aԩ   AԪ   Aԫ   AԬv   AԭW   AԮ8   Aԯ   Aԯ   A԰   AԱ   AԲ   AԳ~   AԴ_   AԵ@   AԶ!   AԷ   AԷ   AԸ   AԹ   AԺ   AԻg   AԼH   AԽ)   AԾ
   AԾ   AԿ   A   A   Ao   AP   A1   A   A   A   Aǵ   AȖ   Aw   AX   A9   A   A   A   Aν   AϞ   A   A`   AA   A"   A   A   A   A֦   Aׇ   Ah   AI   A*   A   A   A   Aݮ   Aޏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A    A   A   Ay   AZ   A;   A   A   A   A   A	   A
   Ab   AC   A
$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   A z   A![   A"<   A#   A#   A$   A%   A&   A'   A(c   A)D   A*%   A+   A+   A,   A-   A.   A/k   A0L   A1-   A2   A2   A3   A4   A5   A6s   A7T   A85   A9   A9   A:   A;   A<   A={   A>\   A?=   A@   A@   AA   AB   AC   AD   AEd   AFE   AG&   AH   AH   AK   ALl   AMM   AN.   AO   AO   AP   AQ   AR   ASt   ATU   AU6   AV   AV   AW   AX   AY   AZ|   A[]   A\>   A]   A^    A^   A_   A`   Aa   Abe   AcF   Ad'   Ae   Ae   Af   Ag   Ah   Aim   AjN   Ak/   Al   Al   Am   An   Ao   Apu   AqV   Ar7   As   As   At   Au   Av   A~   Af   AՀG   AՁ(   AՂ	   AՂ   AՃ   AՄ   AՅ   AՆn   AՇO   AՈ0   AՉ   AՉ   AՊ   AՋ   AՌ   AՍv   AՎW   AՏ8   AՐ   AՐ   AՑ   AՒ   AՓ   AՔ~   AՕ_   AՖ@   A՗!   A՘   A՘   Aՙ   A՚   A՛   A՜g   A՝H   A՞)   A՟
   A՟   Aՠ   Aա   Aբ   Aգo   AդP   Aե1   Aզ   Aզ   Aէ   Aը   Aթ   Aժw   AիX   Aլ9   Aխ   Aխ   Aծ   Aկ   Aհ   Aձ   Aղ`   AճA   Aմ"   Aյ   Aյ   Aն   Aշ   Aո   Aչh   AպI   Aջ*   Aռ   Aռ   Aս   Aվ   Aտ   Ap   AQ   A2   A   A   A   AŶ   AƗ   Ax   AY   A:   A   A   A   A̾   A͟   A΀   Aa   AB   A#   A   A   A   Aԧ   AՈ   Ai   AJ   A+   A   A   A   Aۯ   Aܐ   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A    Az   A[   A<   A   A   A   A   A   A   A	c   A
D   A%   A   A   A
   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A =   A!   A!   A"   A#   A$   A%   A&d   A'E   A(&   A)   A)   A*   A+   A,   A-l   A.M   A/.   A0   A0   A1   A2   A3   A4t   A5U   A66   A7   A7   A8   A9   A:   A;|   A<]   A=>   A>   A?    A?   A@   ACe   ADF   AE'   AF   AF   AG   AH   AI   AJm   AKN   AL/   AM   AM   AN   AO   AP   AQu   ARV   AS7   AT   AT   AU   AV   AW   AX}   AY^   AZ?   A[    A\   A\   A]   A^   A_   A`f   AaG   Ab(   Ac	   Ac   Ad   Ae   Af   Agn   AhO   Ai0   Aj   Aj   Ak   Al   Am   Anv   AoW   Ap8   Aq   Aq   Ar   As   At   Au~   Av_   Aw@   Ax!   Ay   Ay   Az   A{   A|   A}g   A~H   A)   Aր
   Aր   Aց   Aւ   Aփ   Aքo   AօP   Aֆ1   Aև   Aև   Aֈ   A։   A֊   A֋w   A֌X   A֍9   A֎   A֎   A֏   A֐   A֑   A֒   A֓`   A֔A   A֕"   A֖   A֖   A֗   A֘   A֙   A֚h   A֛I   A֜*   A֝   A֝   A֞   A֟   A֠   A֡p   A֢Q   A֣2   A֤   A֤   A֥   A֦   A֧   A֨x   A֩Y   A֪:   A֫   A֫   A֬   A֭   A֮   A֯   Aְa   AֱB   Aֲ#   Aֳ   Aֳ   Aִ   Aֵ   Aֶ   Aַi   AָJ   Aֹ+   Aֺ   Aֺ   Aֻ   Aּ   Aֽ   A־q   AֿR   A3   A   A   A   A÷   AĘ   Ay   AZ   A;   A   A   A   Aʿ   Aˠ   Á   Ab   AC   A$   A   A   A   AҨ   AӉ   Aj   AK   A,   A
   A   A   Aٰ   Aڑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A \   A=   A   A   A   A   A   A   Ad   AE   A	&   A
   A
   A   A   A
   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A     A    A!   A"   A#   A$e   A%F   A&'   A'   A'   A(   A)   A*   A+m   A,N   A-/   A.   A.   A/   A0   A1   A2u   A3V   A47   A5   A5   A6   A7   A8   A9}   A:^   A;?   A<    A=   A=   A>   A?   A@   AAf   ABG   AC(   AD	   AD   AE   AF   AG   AHn   AIO   AJ0   AK   AK   AL   AM   AN   AOv   APW   AQ8   AR   AR   AS   AT   AU   AV~   AW_   AX@   AY!   AZ   AZ   A[   A\   A]   A^g   A_H   A`)   Aa
   Aa   Ab   Ac   Ad   Aeo   AfP   Ag1   Ah   Ah   Ai   Aj   Ak   Alw   AmX   An9   Ao   Ao   Ap   Aq   Ar   As   At`   AuA   Av"   Aw   Aw   Ax   Ay   Az   A{h   A|I   A}*   A~   A~   A   A׀   Aׁ   Aׂp   A׃Q   Aׄ2   Aׅ   Aׅ   A׆   Aׇ   A׈   A׉x   A׊Y   A׋:   A׌   A׌   A׍   A׎   A׏   Aא   Aבa   AגB   Aד#   Aה   Aה   Aו   Aז   Aח   Aטi   AיJ   Aך+   Aכ   Aכ   Aל   Aם   Aמ   Aןq   AנR   Aס3   Aע   Aע   Aף   Aפ   Aץ   Aצy   AקZ   Aר;   Aש   Aש   Aת   A׫   A׬   A׭   A׮b   AׯC   Aװ$   Aױ   Aױ   Aײ   A׳   A״   A׵j   A׶K   A׷,   A׸
   A׸   A׹   A׺   A׻   A׼r   A׽S   A׾4   A׿   A׿   A   A   A   Az   A[   A<   A   A   A   A   Aɡ   Aʂ   Ac   AD   A%   A   A   A   AЩ   Aъ   Ak   AL   A-   A   A   A   Aױ   Aؒ   As   AT   A5   A   A   A   A޹   Aߚ   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A    A    A   A   A   A   Ae   AF   A'   A   A   A	   A
   A   Am   A
N   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A    A!   A"f   A#G   A$(   A%	   A%   A&   A'   A(   A)n   A*O   A+0   A,   A,   A-   A.   A/   A0v   A1W   A28   A3   A3   A4   A5   A6   A7~   A8_   A9@   A:!   A;   A;   A<   A=   A>   A?g   A@H   AA)   AB
   AB   AC   AD   AE   AFo   AGP   AH1   AI   AI   AJ   AK   AL   AMw   ANX   AO9   AP   AP   AQ   AR   AS   AT   AU`   AVA   AW"   AX   AX   AY   AZ   A[   A\h   A]I   A^*   A_   A_   A`   Aa   Ab   Acp   AdQ   Ae2   Af   Af   Ag   Ah   Ai   Ajx   AkY   Al:   Am   Am   An   Ao   Ap   Aq   Ara   AsB   At#   Au   Au   Av   Aw   Ax   Ayi   AzJ   A{+   A|   A|   A}   A~   A   A؀q   A؁R   A؂3   A؃   A؃   A؄   A؅   A؆   A؇y   A؈Z   A؉;   A؊   A؊   A؋   A،   A؍   A؎   A؏b   AؐC   Aؑ$   Aؒ   Aؒ   Aؓ   Aؔ   Aؕ   Aؖj   AؗK   Aؘ,   Aؙ
   Aؙ   Aؚ   A؛   A؜   A؝r   A؞S   A؟4   Aؠ   Aؠ   Aء   Aآ   Aأ   Aؤz   Aإ[   Aئ<   Aا   Aا   Aب   Aة   Aت   Aث   Aجc   AحD   Aخ%   Aد   Aد   Aذ   Aر   Aز   Aسk   AشL   Aص-   Aض   Aض   Aط   Aظ   Aع   Aغs   AػT   Aؼ5   Aؽ   Aؽ   Aؾ   Aؿ   A   A{   A\   A=   A   A   A   A   AǢ   Aȃ   Ad   AE   A&   A   A   A   AΪ   Aϋ   Al   AM   A.   A   A   A   Aղ   A֓   At   AU   A6   A   A   A   Aܺ   Aݛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A    A   A   Af   AG   A(   A	   A   A   A   A	   A
n   AO   A0   A
   A
   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   A g   A!H   A")   A#
   A#   A$   A%   A&   A'o   A(P   A)1   A*   A*   A+   A,   A-   A.w   A/X   A09   A1   A1   A2   A3   A4   A5   A6`   A7A   A8"   A9   A9   A:   A;   A<   A=h   A>I   A?*   A@   A@   AA   AB   AC   ADp   AEQ   AF2   AG   AG   AH   AI   AJ   AKx   ALY   AM:   AN   AN   AO   AP   AQ   AR   ASa   ATB   AU#   AV   AV   AW   AX   AY   AZi   A[J   A\+   A]   A]   A^   A_   A`   Aaq   AbR   Ac3   Ad   Ad   Ae   Af   Ag   Ahy   AiZ   Aj;   Ak   Ak   Al   Am   An   Ao   Apb   AqC   Ar$   As   As   At   Au   Av   Awj   AxK   Ay,   Az
   Az   A{   A|   A}   A~r   AS   Aـ4   Aف   Aف   Aق   Aك   Aل   Aمz   Aن[   Aه<   Aو   Aو   Aى   Aي   Aً   Aٌ   Aٍc   AَD   Aُ%   Aِ   Aِ   Aّ   Aْ   Aٓ   Aٔk   AٕL   Aٖ-   Aٗ   Aٗ   A٘   Aٙ   Aٚ   Aٛs   AٜT   Aٝ5   Aٞ   Aٞ   Aٟ   A٠   A١   A٢{   A٣\   A٤=   A٥   A٥   A٦   A٧   A٨   A٩   A٪d   A٫E   A٬&   A٭   A٭   Aٮ   Aٯ   Aٰ   Aٱl   AٲM   Aٳ.   Aٴ   Aٴ   Aٵ   Aٶ   Aٷ   Aٸt   AٹU   Aٺ6   Aٻ   Aٻ   Aټ   Aٽ   Aپ   Aٿ|   A]   A>   A   A    A   A   Aţ   AƄ   Ae   AF   A'   A   A   A   A̫   A͌   Am   AN   A/   A   A   A   Aӳ   AԔ   Au   AV   A7   A   A   A   Aڻ   Aۜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A    Ag   AH   A)   A
   A   A   A   A   Ao   A	P   A
1   A   A   A   A   A   A   Ah   AI   A *   A!   A!   A"   A#   A$   A%p   A&Q   A'2   A(   A(   A)   A*   A+   A,x   A-Y   A.:   A/   A/   A0   A1   A2   A3   A4a   A5B   A6#   A7   A7   A8   A9   A:   A;i   A<J   A=+   A>   A>   A?   A@   AA   ABq   ACR   AD3   AE   AE   AF   AG   AH   AIy   AJZ   AK;   AL   AL   AM   AN   AO   AP   AQb   ARC   AS$   AT   AT   AU   AV   AW   AXj   AYK   AZ,   A[
   A[   A\   A]   A^   A_r   A`S   Aa4   Ab   Ab   Ac   Ad   Ae   Afz   Ag[   Ah<   Ai   Ai   Aj   Ak   Al   Am   Anc   AoD   Ap%   Aq   Aq   Ar   As   At   Auk   AvL   Aw-   Ax   Ax   Ay   Az   A{   A|s   A}T   A~5   A   A   Aڀ   Aځ   Aڂ   Aڃ{   Aڄ\   Aڅ=   Aچ   Aچ   Aڇ   Aڈ   Aډ   Aڊ   Aڋd   AڌE   Aڍ&   Aڎ   Aڎ   Aڏ   Aڐ   Aڑ   Aڒl   AړM   Aڔ.   Aڕ   Aڕ   Aږ   Aڗ   Aژ   Aڙt   AښU   Aڛ6   Aڜ   Aڜ   Aڝ   Aڞ   Aڟ   Aڠ|   Aڡ]   Aڢ>   Aڣ   Aڤ    Aڤ   Aڥ   Aڦ   Aڧ   Aڨe   AکF   Aڪ'   Aګ   Aګ   Aڬ   Aڭ   Aڮ   Aگm   AڰN   Aڱ/   Aڲ   Aڲ   Aڳ   Aڴ   Aڵ   Aڶu   AڷV   Aڸ7   Aڹ   Aڹ   Aں   Aڻ   Aڼ   Aڽ}   Aھ^   Aڿ?   A    A   A   A   Aä   Aą   Af   AG   A(   A	   A   A   Aʬ   Aˍ   An   AO   A0   A   A   A   AѴ   Aҕ   Av   AW   A8   A   A   A   Aؼ   Aٝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   A I   A*   A   A   A   A   A   Ap   AQ   A2   A	   A	   A
   A   A   A
x   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A    A!   A"   A#q   A$R   A%3   A&   A&   A'   A(   A)   A*y   A+Z   A,;   A-   A-   A.   A/   A0   A1   A2b   A3C   A4$   A5   A5   A6   A7   A8   A9j   A:K   A;,   A<
   A<   A=   A>   A?   A@r   AAS   AB4   AC   AC   AD   AE   AF   AGz   AH[   AI<   AJ   AJ   AK   AL   AM   AN   AOc   APD   AQ%   AR   AR   AS   AT   AU   AVk   AWL   AX-   AY   AY   AZ   A[   A\   A]s   A^T   A_5   A`   A`   Aa   Ab   Ac   Ad{   Ae\   Af=   Ag   Ag   Ah   Ai   Aj   Ak   Ald   AmE   An&   Ao   Ao   Ap   Aq   Ar   Asl   AtM   Au.   Av   Av   Aw   Ax   Ay   Azt   A{U   A|6   A}   A}   A~   A   Aۀ   Aہ|   Aۂ]   Aۃ>   Aۄ   Aۅ    Aۅ   Aۆ   Aۇ   Aۈ   Aۉe   AۊF   Aۋ'   Aی   Aی   Aۍ   Aێ   Aۏ   Aېm   AۑN   Aے/   Aۓ   Aۓ   A۔   Aە   Aۖ   Aۗu   AۘV   Aۙ7   Aۚ   Aۚ   Aۛ   Aۜ   A۝   A۞}   A۟^   A۠?   Aۡ    Aۢ   Aۢ   Aۣ   Aۤ   Aۥ   Aۦf   AۧG   Aۨ(   A۩	   A۩   A۪   A۫   A۬   Aۭn   AۮO   Aۯ0   A۰   A۰   A۱   A۲   A۳   A۴v   A۵W   A۶8   A۷   A۷   A۸   A۹   Aۺ   Aۻ~   Aۼ_   A۽@   A۾!   Aۿ   Aۿ   A   A   A   Ag   AH   A)   A
   A   A   Aȭ   AɎ   Ao   AP   A1   A   A   A   Aϵ   AЖ   Aw   AX   A9   A   A   A   Aֽ   Aמ   A   A`   AA   A"   A   A   A   Aަ   A߇   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A    A    A   A   A   Aq   AR   A3   A   A   A   A	   A
   Ay   AZ   A
;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A    A!r   A"S   A#4   A$   A$   A%   A&   A'   A(z   A)[   A*<   A+   A+   A,   A-   A.   A/   A0c   A1D   A2%   A3   A3   A4   A5   A6   A7k   A8L   A9-   A:   A:   A;   A<   A=   A>s   A?T   A@5   AA   AA   AB   AC   AD   AE{   AF\   AG=   AH   AH   AI   AJ   AK   AL   AMd   ANE   AO&   AP   AP   AQ   AR   AS   ATl   AUM   AV.   AW   AW   AX   AY   AZ   A[t   A\U   A]6   A^   A^   A_   A`   Aa   Ab|   Ac]   Ad>   Ae   Af    Af   Ag   Ah   Ai   Aje   AkF   Al'   Am   Am   An   Ao   Ap   Aqm   ArN   As/   At   At   Au   Av   Aw   Axu   AyV   Az7   A{   A{   A|   A}   A~   A}   A܀^   A܁?   A܂    A܃   A܃   A܄   A܅   A܆   A܇f   A܈G   A܉(   A܊	   A܊   A܋   A܌   A܍   A܎n   A܏O   Aܐ0   Aܑ   Aܑ   Aܒ   Aܓ   Aܔ   Aܕv   AܖW   Aܗ8   Aܘ   Aܘ   Aܙ   Aܚ   Aܛ   Aܜ~   Aܝ_   Aܞ@   Aܟ!   Aܠ   Aܠ   Aܡ   Aܢ   Aܣ   Aܤg   AܥH   Aܦ)   Aܧ
   Aܧ   Aܨ   Aܩ   Aܪ   Aܫo   AܬP   Aܭ1   Aܮ   Aܮ   Aܯ   Aܰ   Aܱ   Aܲw   AܳX   Aܴ9   Aܵ   Aܵ   Aܶ   Aܷ   Aܸ   Aܹ   Aܺ`   AܻA   Aܼ"   Aܽ   Aܽ   Aܾ   Aܿ   A   Ah   AI   A*   A   A   A   AƮ   AǏ   Ap   AQ   A2   A   A   A   AͶ   AΗ   Ax   AY   A:   A   A   A   AԾ   A՟   Aր   Aa   AB   A#   A   A   A   Aܧ   A݈   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A    A   Ar   AS   A4   A   A   A   A   A   A	z   A
[   A<   A   A   A
   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   A T   A!5   A"   A"   A#   A$   A%   A&{   A'\   A(=   A)   A)   A*   A+   A,   A-   A.d   A/E   A0&   A1   A1   A2   A3   A4   A5l   A6M   A7.   A8   A8   A9   A:   A;   A<t   A=U   A>6   A?   A?   A@   AA   AB   AC|   AD]   AE>   AF   AG    AG   AH   AI   AJ   AKe   ALF   AM'   AN   AN   AO   AP   AQ   ARm   ASN   AT/   AU   AU   AV   AW   AX   AYu   AZV   A[7   A\   A\   A]   A^   A_   A`}   Aa^   Ab?   Ac    Ad   Ad   Ae   Af   Ag   Ahf   AiG   Aj(   Ak	   Ak   Al   Am   An   Aon   ApO   Aq0   Ar   Ar   As   At   Au   Avv   AwW   Ax8   Ay   Ay   Az   A{   A|   A}~   A~_   A@   A݀!   A݁   A݁   A݂   A݃   A݄   A݅g   A݆H   A݇)   A݈
   A݈   A݉   A݊   A݋   A݌o   AݍP   Aݎ1   Aݏ   Aݏ   Aݐ   Aݑ   Aݒ   Aݓw   AݔX   Aݕ9   Aݖ   Aݖ   Aݗ   Aݘ   Aݙ   Aݚ   Aݛ`   AݜA   Aݝ"   Aݞ   Aݞ   Aݟ   Aݠ   Aݡ   Aݢh   AݣI   Aݤ*   Aݥ   Aݥ   Aݦ   Aݧ   Aݨ   Aݩp   AݪQ   Aݫ2   Aݬ   Aݬ   Aݭ   Aݮ   Aݯ   Aݰx   AݱY   Aݲ:   Aݳ   Aݳ   Aݴ   Aݵ   Aݶ   Aݷ   Aݸa   AݹB   Aݺ#   Aݻ   Aݻ   Aݼ   Aݽ   Aݾ   Aݿi   AJ   A+   A   A   A   Aį   AŐ   Aq   AR   A3   A   A   A   A˷   A̘   Ay   AZ   A;   A   A   A   Aҿ   AӠ   Aԁ   Ab   AC   A$   A   A   A   Aڨ   Aۉ   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   A s   AT   A5   A   A   A   A   A   A{   A\   A	=   A
   A
   A   A   A
   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A    A    A!   A"   A#   A$|   A%]   A&>   A'   A(    A(   A)   A*   A+   A,e   A-F   A.'   A/   A/   A0   A1   A2   A3m   A4N   A5/   A6   A6   A7   A8   A9   A:u   A;V   A<7   A=   A=   A>   A?   A@   AA}   AB^   AC?   AD    AE   AE   AF   AG   AH   AIf   AJG   AK(   AL	   AL   AM   AN   AO   APn   AQO   AR0   AS   AS   AT   AU   AV   AWv   AXW   AY8   AZ   AZ   A[   A\   A]   A^~   A__   A`@   Aa!   Ab   Ab   Ac   Ad   Ae   Afg   AgH   Ah)   Ai
   Ai   Aj   Ak   Al   Amo   AnP   Ao1   Ap   Ap   Aq   Ar   As   Atw   AuX   Av9   Aw   Aw   Ax   Ay   Az   A{   A|`   A}A   A~"   A   A   Aހ   Aށ   Aނ   Aރh   AބI   Aޅ*   Aކ   Aކ   Aއ   Aވ   Aމ   Aފp   AދQ   Aތ2   Aލ   Aލ   Aގ   Aޏ   Aސ   Aޑx   AޒY   Aޓ:   Aޔ   Aޔ   Aޕ   Aޖ   Aޗ   Aޘ   Aޙa   AޚB   Aޛ#   Aޜ   Aޜ   Aޝ   Aޞ   Aޟ   Aޠi   AޡJ   Aޢ+   Aޣ   Aޣ   Aޤ   Aޥ   Aަ   Aާq   AިR   Aީ3   Aު   Aު   Aޫ   Aެ   Aޭ   Aޮy   AޯZ   Aް;   Aޱ   Aޱ   A޲   A޳   A޴   A޵   A޶b   A޷C   A޸$   A޹   A޹   A޺   A޻   A޼   A޽j   A޾K   A޿,   A
   A   A   A°   AÑ   Ar   AS   A4   A   A   A   Aɸ   Aʙ   Az   A[   A<   A   A   A   A   Aѡ   A҂   Ac   AD   A%   A   A   A   Aة   Aي   Ak   AL   A-   A   A   A   A߱   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A 6   A   A   A   A   A   A|   A]   A>   A   A	    A	   A
   A   A   A
e   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A    A!   A"}   A#^   A$?   A%    A&   A&   A'   A(   A)   A*f   A+G   A,(   A-	   A-   A.   A/   A0   A1n   A2O   A30   A4   A4   A5   A6   A7   A8v   A9W   A:8   A;   A;   A<   A=   A>   A?~   A@_   AA@   AB!   AC   AC   AD   AE   AF   AGg   AHH   AI)   AJ
   AJ   AK   AL   AM   ANo   AOP   AP1   AQ   AQ   AR   AS   AT   AUw   AVX   AW9   AX   AX   AY   AZ   A[   A\   A]`   A^A   A_"   A`   A`   Aa   Ab   Ac   Adh   AeI   Af*   Ag   Ag   Ah   Ai   Aj   Akp   AlQ   Am2   An   An   Ao   Ap   Aq   Arx   AsY   At:   Au   Au   Av   Aw   Ax   Ay   Aza   A{B   A|#   A}   A}   A~   A   A߀   A߁i   A߂J   A߃+   A߄   A߄   A߅   A߆   A߇   A߈q   A߉R   Aߊ3   Aߋ   Aߋ   Aߌ   Aߍ   Aߎ   Aߏy   AߐZ   Aߑ;   Aߒ   Aߒ   Aߓ   Aߔ   Aߕ   Aߖ   Aߗb   AߘC   Aߙ$   Aߚ   Aߚ   Aߛ   Aߜ   Aߝ   Aߞj   AߟK   Aߠ,   Aߡ
   Aߡ   Aߢ   Aߣ   Aߤ   Aߥr   AߦS   Aߧ4   Aߨ   Aߨ   Aߩ   Aߪ   A߫   A߬z   A߭[   A߮<   A߯   A߯   A߰   A߱   A߲   A߳   Aߴc   AߵD   A߶%   A߷   A߷   A߸   A߹   Aߺ   A߻k   A߼L   A߽-   A߾   A߾   A߿   A   A   As   AT   A5   A   A   A   Aǹ   AȚ   A{   A\   A=   A   A   A   A   AϢ   AЃ   Ad   AE   A&   A   A   A   A֪   A׋   Al   AM   A.   A   A   A   Aݲ   Aޓ   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A    A   A   A}   A^   A?   A    A   A   A   A	   A
   Af   AG   A
(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A ~   A!_   A"@   A#!   A$   A$   A%   A&   A'   A(g   A)H   A*)   A+
   A+   A,   A-   A.   A/o   A0P   A11   A2   A2   A3   A4   A5   A6w   A7X   A89   A9   A9   A:   A;   A<   A=   A>`   A?A   A@"   AA   AA   AB   AC   AD   AEh   AFI   AG*   AH   AH   AI   AJ   AK   ALp   AMQ   AN2   AO   AO   AP   AQ   AR   ASx   ATY   AU:   AV   AV   AW   AX   AY   AZ   A[a   A\B   A]#   A^   A^   A_   A`   Aa   Abi   AcJ   Ad+   Ae   Ae   Af   Ag   Ah   Aiq   AjR   Ak3   Al   Al   Am   An   Ao   Apy   AqZ   Ar;   As   As   At   Au   Av   Aw   Axb   AyC   Az$   A{   A{   A|   A}   A~   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   Aࡱ   A࢒   As   AT   A5   A   A   A   Aਹ   Aਗ਼   A{   A\   A=   A   A   A   A   Aఢ   Aృ   Ad   AE   A&   A   A   A   A෪   Aซ   Al   AM   A.   A   A   A   Aྲ   A࿓   At   AU   A6   A   A   A   Aź   Aƛ   A|   A]   A>   A   A    A   A   Aͣ   A΄   Ae   AF   A'   A   A   A   Aԫ   AՌ   Am   AN   A/   A   A   A   A۳   Aܔ   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A    A~   A_   A@   A!   A   A   A   A   A   A	g   A
H   A)   A
   A   A
   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   A A   A!"   A"   A"   A#   A$   A%   A&h   A'I   A(*   A)   A)   A*   A+   A,   A-p   A.Q   A/2   A0   A0   A1   A2   A3   A4x   A5Y   A6:   A7   A7   A8   A9   A:   A;   A<a   A=B   A>#   A?   A?   A@   AA   AB   ACi   ADJ   AE+   AF   AF   AG   AH   AI   AJq   AKR   AL3   AM   AM   AN   AO   AP   AQy   ARZ   AS;   AT   AT   AU   AV   AW   AX   AYb   AZC   A[$   A\   A\   A]   A^   A_   A`j   AaK   Ab,   Ac
   Ac   Ad   Ae   Af   Agr   AhS   Ai4   Aj   Aj   Ak   Al   Am   Anz   Ao[   Ap<   Aq   Aq   Ar   As   At   Au   Avc   AwD   Ax%   Ay   Ay   Az   A{   A|   A}k   A~L   A-   A   A   A   AႱ   Aგ   As   AT   A5   A   A   A   Aቹ   Aኚ   A{   A\   A=   A   A   A   A   Aᑢ   Aᒃ   Ad   AE   A&   A   A   A   Aᘪ   Aᙋ   Al   AM   A.   A   A   A   A៲   A᠓   At   AU   A6   A   A   A   Aᦺ   A᧛   A|   A]   A>   A   A    A   A   Aᮣ   Aᯄ   Ae   AF   A'   A   A   A   Aᵫ   Aᶌ   Am   AN   A/   A   A   A   Aἳ   Aὔ   Au   AV   A7   A   A   A   Aû   AĜ   A}   A^   A?   A    A   A   A   Aˤ   A̅   Af   AG   A(   A	   A   A   AҬ   AӍ   An   AO   A0   A   A   A   Aٴ   Aڕ   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A `   AA   A"   A   A   A   A   A   Ah   AI   A	*   A
   A
   A   A   A
   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A    A    A!   A"   A#   A$i   A%J   A&+   A'   A'   A(   A)   A*   A+q   A,R   A-3   A.   A.   A/   A0   A1   A2y   A3Z   A4;   A5   A5   A6   A7   A8   A9   A:b   A;C   A<$   A=   A=   A>   A?   A@   AAj   ABK   AC,   AD
   AD   AE   AF   AG   AHr   AIS   AJ4   AK   AK   AL   AM   AN   AOz   AP[   AQ<   AR   AR   AS   AT   AU   AV   AWc   AXD   AY%   AZ   AZ   A[   A\   A]   A^k   A_L   A`-   Aa   Aa   Ab   Ac   Ad   Aes   AfT   Ag5   Ah   Ah   Ai   Aj   Ak   Al{   Am\   An=   Ao   Ao   Ap   Aq   Ar   As   Atd   AuE   Av&   Aw   Aw   Ax   Ay   Az   A{l   A|M   A}.   A~   A~   A   A′   A⁓   At   AU   A6   A   A   A   A⇺   A∛   A|   A]   A>   A   A    A   A   A⏣   A␄   Ae   AF   A'   A   A   A   A▫   A◌   Am   AN   A/   A   A   A   A❳   A➔   Au   AV   A7   A   A   A   A⤻   A⥜   A}   A^   A?   A    A   A   A   A⬤   A⭅   Af   AG   A(   A	   A   A   Aⳬ   Aⴍ   An   AO   A0   A   A   A   A⺴   A⻕   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   Aɥ   Aʆ   Ag   AH   A)   A
   A   A   AЭ   Aю   Ao   AP   A1   A   A   A   A׵   Aؖ   Aw   AX   A9   A   A   A   A޽   Aߞ   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A #   A   A   A   A   A   Ai   AJ   A+   A   A   A	   A
   A   Aq   A
R   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A    A!   A"j   A#K   A$,   A%
   A%   A&   A'   A(   A)r   A*S   A+4   A,   A,   A-   A.   A/   A0z   A1[   A2<   A3   A3   A4   A5   A6   A7   A8c   A9D   A:%   A;   A;   A<   A=   A>   A?k   A@L   AA-   AB   AB   AC   AD   AE   AFs   AGT   AH5   AI   AI   AJ   AK   AL   AM{   AN\   AO=   AP   AP   AQ   AR   AS   AT   AUd   AVE   AW&   AX   AX   AY   AZ   A[   A\l   A]M   A^.   A_   A_   A`   Aa   Ab   Act   AdU   Ae6   Af   Af   Ag   Ah   Ai   Aj|   Ak]   Al>   Am   An    An   Ao   Ap   Aq   Are   AsF   At'   Au   Au   Av   Aw   Ax   Aym   AzN   A{/   A|   A|   A}   A~   A   Au   AV   A7   A   A   A   Aㅻ   A㆜   A}   A^   A?   A    A   A   A   A㍤   A㎅   Af   AG   A(   A	   A   A   A㔬   A㕍   An   AO   A0   A   A   A   A㛴   A㜕   Av   AW   A8   A   A   A   A㢼   A㣝   A~   A_   A@   A!   A   A   A   A㪥   A㫆   Ag   AH   A)   A
   A   A   A㱭   A㲎   Ao   AP   A1   A   A   A   A㸵   A㹖   Aw   AX   A9   A   A   A   A㿽   A   A   A`   AA   A"   A   A   A   AǦ   Aȇ   Ah   AI   A*   A   A   A   Aή   AϏ   Ap   AQ   A2   A   A   A   Aն   A֗   Ax   AY   A:   A   A   A   Aܾ   Aݟ   Aހ   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A    A   A   Aj   AK   A,   A
   A   A   A   A	   A
r   AS   A4   A
   A
   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   A k   A!L   A"-   A#   A#   A$   A%   A&   A's   A(T   A)5   A*   A*   A+   A,   A-   A.{   A/\   A0=   A1   A1   A2   A3   A4   A5   A6d   A7E   A8&   A9   A9   A:   A;   A<   A=l   A>M   A?.   A@   A@   AA   AB   AC   ADt   AEU   AF6   AG   AG   AH   AI   AJ   AK|   AL]   AM>   AN   AO    AO   AP   AQ   AR   ASe   ATF   AU'   AV   AV   AW   AX   AY   AZm   A[N   A\/   A]   A]   A^   A_   A`   Aau   AbV   Ac7   Ad   Ad   Ae   Af   Ag   Ah}   Ai^   Aj?   Ak    Al   Al   Am   An   Ao   Apf   AqG   Ar(   As	   As   At   Au   Av   Awn   AxO   Ay0   Az   Az   A{   A|   A}   A~v   AW   A8   A   A   A   A䃼   A䄝   A~   A_   A@   A!   A   A   A   A䋥   A䌆   Ag   AH   A)   A
   A   A   A䒭   A䓎   Ao   AP   A1   A   A   A   A䙵   A䚖   Aw   AX   A9   A   A   A   A䠽   A䡞   A   A`   AA   A"   A   A   A   A䨦   A䩇   Ah   AI   A*   A   A   A   A䯮   A䰏   Ap   AQ   A2   A   A   A   A䶶   A䷗   Ax   AY   A:   A   A   A   A佾   A侟   A俀   Aa   AB   A#   A   A   A   Aŧ   Aƈ   Ai   AJ   A+   A   A   A   A̯   A͐   Aq   AR   A3   A   A   A   Aӷ   AԘ   A   A   Aڿ   A۠   A܁   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A    Ak   AL   A-   A   A   A   A   A   As   A	T   A
5   A   A   A   A
   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A .   A!   A!   A"   A#   A$   A%t   A&U   A'6   A(   A(   A)   A*   A+   A,|   A-]   A.>   A/   A0    A0   A1   A2   A3   A4e   A5F   A6'   A7   A7   A8   A9   A:   A;m   A<N   A=/   A>   A>   A?   A@   AA   ABu   ACV   AD7   AE   AE   AF   AG   AH   AI}   AJ^   AK?   AL    AM   AM   AN   AO   AP   AQf   ARG   AS(   AT	   AT   AU   AV   AW   AXn   AYO   AZ0   A[   A[   A\   A]   A^   A_v   A`W   Aa8   Ab   Ab   Ac   Ad   Ae   Af~   Ag_   Ah@   Ai!   Aj   Aj   Ak   Al   Am   Ang   AoH   Ap)   Aq
   Aq   Ar   As   At   Auo   AvP   Aw1   Ax   Ax   Ay   Az   A{   A|w   A}X   A~9   A   A   A   A偽   A傞   A   A`   AA   A"   A   A   A   A剦   A劇   Ah   AI   A*   A   A   A   A吮   A呏   Ap   AQ   A2   A   A   A   A嗶   A嘗   Ax   AY   A:   A   A   A   A垾   A域   A堀   Aa   AB   A#   A   A   A   A妧   A姈   Ai   AJ   A+   A   A   A   A孯   A宐   Aq   AR   A3   A   A   A   A崷   A嵘   Ay   AZ   A;   A   A   A   A廿   A张   A彁   Ab   AC   A$   A   A   A   Aè   Aĉ   Aj   AK   A,   A
   A   A   Aʰ   Aˑ   Ar   AS   A4   A   A   A   AѸ   Aҙ   Az   A[   A<   A   A   A   A   A١   Aڂ   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   A M   A.   A   A   A   A   A   At   AU   A6   A	   A	   A
   A   A   A
|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A    A!   A"   A#u   A$V   A%7   A&   A&   A'   A(   A)   A*}   A+^   A,?   A-    A.   A.   A/   A0   A1   A2f   A3G   A4(   A5	   A5   A6   A7   A8   A9n   A:O   A;0   A<   A<   A=   A>   A?   A@v   AAW   AB8   AC   AC   AD   AE   AF   AG~   AH_   AI@   AJ!   AK   AK   AL   AM   AN   AOg   APH   AQ)   AR
   AR   AS   AT   AU   AVo   AWP   AX1   AY   AY   AZ   A[   A\   A]w   A^X   A_9   A`   A`   Aa   Ab   Ac   Ad   Ae`   AfA   Ag"   Ah   Ah   Ai   Aj   Ak   Alh   AmI   An*   Ao   Ao   Ap   Aq   Ar   Asp   AtQ   Au2   Av   Av   Aw   Ax   Ay   Azx   A{Y   A|:   A}   A}   A~   A   A怟   A恀   Aa   AB   A#   A   A   A   A懧   A戈   Ai   AJ   A+   A   A   A   A掯   A提   Aq   AR   A3   A   A   A   A敷   A斘   Ay   AZ   A;   A   A   A   A朿   A杠   A极   Ab   AC   A$   A   A   A   A椨   A楉   Aj   AK   A,   A
   A   A   A櫰   A欑   Ar   AS   A4   A   A   A   A沸   A泙   Az   A[   A<   A   A   A   A   A溡   A滂   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   Aȱ   Aɒ   As   AT   A5   A   A   A   AϹ   AК   A{   A\   A=   A   A   A   A   Aע   A؃   Ad   AE   A&   A   A   A   Aު   Aߋ   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A    A    A   A   A   Au   AV   A7   A   A   A   A	   A
   A}   A^   A
?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A    A!v   A"W   A#8   A$   A$   A%   A&   A'   A(~   A)_   A*@   A+!   A,   A,   A-   A.   A/   A0g   A1H   A2)   A3
   A3   A4   A5   A6   A7o   A8P   A91   A:   A:   A;   A<   A=   A>w   A?X   A@9   AA   AA   AB   AC   AD   AE   AF`   AGA   AH"   AI   AI   AJ   AK   AL   AMh   ANI   AO*   AP   AP   AQ   AR   AS   ATp   AUQ   AV2   AW   AW   AX   AY   AZ   A[x   A\Y   A]:   A^   A^   A_   A`   Aa   Ab   Aca   AdB   Ae#   Af   Af   Ag   Ah   Ai   Aji   AkJ   Al+   Am   Am   An   Ao   Ap   Aqq   ArR   As3   At   At   Au   Av   Aw   Axy   AyZ   Az;   A{   A{   A|   A}   A~   A   Ab   AC   A$   A   A   A   A煨   A熉   Aj   AK   A,   A
   A   A   A猰   A獑   Ar   AS   A4   A   A   A   A瓸   A甙   Az   A[   A<   A   A   A   A   A盡   A眂   Ac   AD   A%   A   A   A   A碩   A磊   Ak   AL   A-   A   A   A   A穱   A窒   As   AT   A5   A   A   A   A簹   A籚   A{   A\   A=   A   A   A   A   A縢   A繃   Ad   AE   A&   A   A   A   A翪   A   Al   AM   A.   A   A   A   AƲ   AǓ   At   AU   A6   A   A   A   Aͺ   AΛ   A|   A]   A>   A   A    A   A   Aգ   Aք   Ae   AF   A'   A   A   A   Aܫ   A݌   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A    A   Av   AW   A8   A   A   A   A   A   A	~   A
_   A@   A!   A
   A
   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   A X   A!9   A"   A"   A#   A$   A%   A&   A'`   A(A   A)"   A*   A*   A+   A,   A-   A.h   A/I   A0*   A1   A1   A2   A3   A4   A5p   A6Q   A72   A8   A8   A9   A:   A;   A<x   A=Y   A>:   A?   A?   A@   AA   AB   AC   ADa   AEB   AF#   AG   AG   AH   AI   AJ   AKi   ALJ   AM+   AN   AN   AO   AP   AQ   ARq   ASR   AT3   AU   AU   AV   AW   AX   AYy   AZZ   A[;   A\   A\   A]   A^   A_   A`   Aab   AbC   Ac$   Ad   Ad   Ae   Af   Ag   Ahj   AiK   Aj,   Ak
   Ak   Al   Am   An   Aor   ApS   Aq4   Ar   Ar   As   At   Au   Avz   Aw[   Ax<   Ay   Ay   Az   A{   A|   A}   A~c   AD   A%   A   A   A   A胩   A脊   Ak   AL   A-   A   A   A   A花   A苒   As   AT   A5   A   A   A   A葹   A蒚   A{   A\   A=   A   A   A   A   A虢   A蚃   Ad   AE   A&   A   A   A   A蠪   A衋   Al   AM   A.   A   A   A   A觲   A訓   At   AU   A6   A   A   A   A论   A诛   A|   A]   A>   A   A    A   A   A趣   A跄   Ae   AF   A'   A   A   A   A轫   A辌   Am   AN   A/   A   A   A   Aĳ   AŔ   Au   AV   A7   A   A   A   A˻   A̜   A}   A^   A?   A    A   A   A   AӤ   Aԅ   Af   AG   A(   A	   A   A   Aڬ   Aۍ   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   A w   AX   A9   A   A   A   A   A   A   A`   A	A   A
"   A   A   A   A
   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A    A    A!   A"   A#   A$   A%a   A&B   A'#   A(   A(   A)   A*   A+   A,i   A-J   A.+   A/   A/   A0   A1   A2   A3q   A4R   A53   A6   A6   A7   A8   A9   A:y   A;Z   A<;   A=   A=   A>   A?   A@   AA   ABb   ACC   AD$   AE   AE   AF   AG   AH   AIj   AJK   AK,   AL
   AL   AM   AN   AO   APr   AQS   AR4   AS   AS   AT   AU   AV   AWz   AX[   AY<   AZ   AZ   A[   A\   A]   A^   A_c   A`D   Aa%   Ab   Ab   Ac   Ad   Ae   Afk   AgL   Ah-   Ai   Ai   Aj   Ak   Al   Ams   AnT   Ao5   Ap   Ap   Aq   Ar   As   At{   Au\   Av=   Aw   Aw   Ax   Ay   Az   A{   A|d   A}E   A~&   A   A   A   A遪   A邋   Al   AM   A.   A   A   A   A鈲   A鉓   At   AU   A6   A   A   A   A鏺   A鐛   A|   A]   A>   A   A    A   A   A闣   A阄   Ae   AF   A'   A   A   A   A鞫   A韌   Am   AN   A/   A   A   A   A饳   A馔   Au   AV   A7   A   A   A   A鬻   A魜   A}   A^   A?   A    A   A   A   A鴤   A鵅   Af   AG   A(   A	   A   A   A黬   A鼍   An   AO   A0   A   A   A   A´   AÕ   Av   AW   A8   A   A   A   Aɼ   Aʝ   A~   A_   A@   A!   A   A   A   Aѥ   A҆   Ag   AH   A)   A
   A   A   Aح   Aَ   Ao   AP   A1   A   A   A   Aߵ   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A :   A   A   A   A   A   A   Aa   AB   A#   A	   A	   A
   A   A   A
i   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A    A!   A"   A#b   A$C   A%$   A&   A&   A'   A(   A)   A*j   A+K   A,,   A-
   A-   A.   A/   A0   A1r   A2S   A34   A4   A4   A5   A6   A7   A8z   A9[   A:<   A;   A;   A<   A=   A>   A?   A@c   AAD   AB%   AC   AC   AD   AE   AF   AGk   AHL   AI-   AJ   AJ   AK   AL   AM   ANs   AOT   AP5   AQ   AQ   AR   AS   AT   AU{   AV\   AW=   AX   AX   AY   AZ   A[   A\   A]d   A^E   A_&   A`   A`   Aa   Ab   Ac   Adl   AeM   Af.   Ag   Ag   Ah   Ai   Aj   Akt   AlU   Am6   An   An   Ao   Ap   Aq   Ar|   As]   At>   Au   Av    Av   Aw   Ax   Ay   Aze   A{F   A|'   A}   A}   A~   A   Aꀌ   Am   AN   A/   A   A   A   Aꆳ   Aꇔ   Au   AV   A7   A   A   A   Aꍻ   Aꎜ   A}   A^   A?   A    A   A   A   Aꕤ   Aꖅ   Af   AG   A(   A	   A   A   AꜬ   Aꝍ   An   AO   A0   A   A   A   Aꣴ   Aꤕ   Av   AW   A8   A   A   A   Aꪼ   Aꫝ   A~   A_   A@   A!   A   A   A   A겥   A곆   Ag   AH   A)   A
   A   A   A깭   A꺎   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   Aǽ   AȞ   A   A`   AA   A"   A   A   A   AϦ   AЇ   Ah   AI   A*   A   A   A   A֮   A׏   Ap   AQ   A2   A   A   A   Aݶ   Aޗ   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A    A   A   A   Ab   AC   A$   A   A   A   A	   A
   Aj   AK   A
,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A    A!c   A"D   A#%   A$   A$   A%   A&   A'   A(k   A)L   A*-   A+   A+   A,   A-   A.   A/s   A0T   A15   A2   A2   A3   A4   A5   A6{   A7\   A8=   A9   A9   A:   A;   A<   A=   A>d   A?E   A@&   AA   AA   AB   AC   AD   AEl   AFM   AG.   AH   AH   AI   AJ   AK   ALt   AMU   AN6   AO   AO   AP   AQ   AR   AS|   AT]   AU>   AV   AW    AW   AX   AY   AZ   A[e   A\F   A]'   A^   A^   A_   A`   Aa   Abm   AcN   Ad/   Ae   Ae   Af   Ag   Ah   Aiu   AjV   Ak7   Al   Al   Am   An   Ao   Ap}   Aq^   Ar?   As    At   At   Au   Av   Aw   Axf   AyG   Az(   A{	   A{   A|   A}   A~   An   AO   A0   A   A   A   A넴   A녕   Av   AW   A8   A   A   A   A닼   A댝   A~   A_   A@   A!   A   A   A   A듥   A딆   Ag   AH   A)   A
   A   A   A뚭   A뛎   Ao   AP   A1   A   A   A   A롵   A뢖   Aw   AX   A9   A   A   A   A먽   A멞   A   A`   AA   A"   A   A   A   A밦   A뱇   Ah   AI   A*   A   A   A   A뷮   A븏   Ap   AQ   A2   A   A   A   A뾶   A뿗   Ax   AY   A:   A   A   A   Až   AƟ   Aǀ   Aa   AB   A#   A   A   A   Aͧ   AΈ   Ai   AJ   A+   A   A   A   Aԯ   AՐ   Aq   AR   A3   A   A   A   A۷   Aܘ   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A    A   Ac   AD   A%   A   A   A   A   A   A	k   A
L   A-   A   A   A
   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   A E   A!&   A"   A"   A#   A$   A%   A&l   A'M   A(.   A)   A)   A*   A+   A,   A-t   A.U   A/6   A0   A0   A1   A2   A3   A4|   A5]   A6>   A7   A8    A8   A9   A:   A;   A<e   A=F   A>'   A?   A?   A@   AA   AB   ACm   ADN   AE/   AF   AF   AG   AH   AI   AJu   AKV   AL7   AM   AM   AN   AO   AP   AQ}   AR^   AS?   AT    AU   AU   AV   AW   AX   AYf   AZG   A[(   A\	   A\   A]   A^   A_   A`n   AaO   Ab0   Ac   Ac   Ad   Ae   Af   Agv   AhW   Ai8   Aj   Aj   Ak   Al   Am   An~   Ao_   Ap@   Aq!   Ar   Ar   As   At   Au   Avg   AwH   Ax)   Ay
   Ay   Az   A{   A|   A}o   A~P   A1   A   A   A   A삵   A샖   Aw   AX   A9   A   A   A   A쉽   A슞   A   A`   AA   A"   A   A   A   A쑦   A쒇   Ah   AI   A*   A   A   A   A옮   A왏   Ap   AQ   A2   A   A   A   A쟶   A젗   Ax   AY   A:   A   A   A   A즾   A짟   A쨀   Aa   AB   A#   A   A   A   A쮧   A쯈   Ai   AJ   A+   A   A   A   A쵯   A춐   Aq   AR   A3   A   A   A   A켷   A콘   Ay   AZ   A;   A   A   A   Aÿ   AĠ   AŁ   Ab   AC   A$   A   A   A   A˨   Ả   Aj   AK   A,   A
   A   A   AҰ   Aӑ   Ar   AS   A4   A   A   A   Aٸ   Aڙ   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   A d   AE   A&   A   A   A   A   A   Al   AM   A	.   A
   A
   A   A   A
   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A    A    A!   A"   A#   A$m   A%N   A&/   A'   A'   A(   A)   A*   A+u   A,V   A-7   A.   A.   A/   A0   A1   A2}   A3^   A4?   A5    A6   A6   A7   A8   A9   A:f   A;G   A<(   A=	   A=   A>   A?   A@   AAn   ABO   AC0   AD   AD   AE   AF   AG   AHv   AIW   AJ8   AK   AK   AL   AM   AN   AO~   AP_   AQ@   AR!   AS   AS   AT   AU   AV   AWg   AXH   AY)   AZ
   AZ   A[   A\   A]   A^o   A_P   A`1   Aa   Aa   Ab   Ac   Ad   Aew   AfX   Ag9   Ah   Ah   Ai   Aj   Ak   Al   Am`   AnA   Ao"   Ap   Ap   Aq   Ar   As   Ath   AuI   Av*   Aw   Aw   Ax   Ay   Az   A{p   A|Q   A}2   A~   A~   A   A퀶   A큗   Ax   AY   A:   A   A   A   A퇾   A툟   A퉀   Aa   AB   A#   A   A   A   A폧   A퐈   Ai   AJ   A+   A   A   A   A햯   A헐   Aq   AR   A3   A   A   A   A흷   A힘   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A¡   AÂ   Ac   AD   A%   A   A   A   Aɩ   Aʊ   Ak   AL   A-   A   A   A   Aб   Aђ   As   AT   A5   A   A   A   A׹   Aؚ   A{   A\   A=   A   A   A   A   Aߢ   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A '   A   A   A   A   A   Am   AN   A/   A   A   A	   A
   A   Au   A
V   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A    A!   A"n   A#O   A$0   A%   A%   A&   A'   A(   A)v   A*W   A+8   A,   A,   A-   A.   A/   A0~   A1_   A2@   A3!   A4   A4   A5   A6   A7   A8g   A9H   A:)   A;
   A;   A<   A=   A>   A?o   A@P   AA1   AB   AB   AC   AD   AE   AFw   AGX   AH9   AI   AI   AJ   AK   AL   AM   AN`   AOA   AP"   AQ   AQ   AR   AS   AT   AUh   AVI   AW*   AX   AX   AY   AZ   A[   A\p   A]Q   A^2   A_   A_   A`   Aa   Ab   Acx   AdY   Ae:   Af   Af   Ag   Ah   Ai   Aj   Aka   AlB   Am#   An   An   Ao   Ap   Aq   Ari   AsJ   At+   Au   Au   Av   Aw   Ax   Ayq   AzR   A{3   A|   A|   A}   A~   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   AǪ   Aȋ   Al   AM   A.   A   A   A   Aβ   Aϓ   At   AU   A6   A   A   A   Aպ   A֛   A|   A]   A>   A   A    A   A   Aݣ   Aބ   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A    A   A   An   AO   A0   A   A   A   A   A	   A
v   AW   A8   A
   A
   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   A o   A!P   A"1   A#   A#   A$   A%   A&   A'w   A(X   A)9   A*   A*   A+   A,   A-   A.   A/`   A0A   A1"   A2   A2   A3   A4   A5   A6h   A7I   A8*   A9   A9   A:   A;   A<   A=p   A>Q   A?2   A@   A@   AA   AB   AC   ADx   AEY   AF:   AG   AG   AH   AI   AJ   AK   ALa   AMB   AN#   AO   AO   AP   AQ   AR   ASi   ATJ   AU+   AV   AV   AW   AX   AY   AZq   A[R   A\3   A]   A]   A^   A_   A`   Aay   AbZ   Ac;   Ad   Ad   Ae   Af   Ag   Ah   Aib   AjC   Ak$   Al   Al   Am   An   Ao   Apj   AqK   Ar,   As
   As   At   Au   Av   Awr   AxS   Ay4   Az   Az   A{   A|   A}   A~z   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A飯   A碑   Al   AM   A.   A   A   A   Aﯲ   Aﰓ   At   AU   A6   A   A   A   Aﶺ   A﷛   A|   A]   A>   A   A    A   A   Aﾣ   Aￄ   Ae   AF   A'   A   A   A   Aū   Aƌ   Am   AN   A/   A   A   A   A̳   A͔   Au   AV   A7   A   A   A   Aӻ   AԜ   A}   A^   A?   A    A   A   A   Aۤ   A܅   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A    Ao   AP   A1   A   A   A   A   A   Aw   A	X   A
9   A   A   A   A
   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A 2   A!   A!   A"   A#   A$   A%x   A&Y   A':   A(   A(   A)   A*   A+   A,   A-a   A.B   A/#   A0   A0   A1   A2   A3   A4i   A5J   A6+   A7   A7   A8   A9   A:   A;q   A<R   A=3   A>   A>   A?   A@   AA   ABy   ACZ   AD;   AE   AE   AF   AG   AH   AI   AJb   AKC   AL$   AM   AM   AN   AO   AP   AQj   ARK   AS,   AT
   AT   AU   AV   AW   AXr   AYS   AZ4   A[   A[   A\   A]   A^   A_z   A`[   Aa<   Ab   Ab   Ac   Ad   Ae   Af   Agc   AhD   Ai%   Aj   Aj   Ak   Al   Am   Ank   AoL   Ap-   Aq   Aq   Ar   As   At   Aus   AvT   Aw5   Ax   Ax   Ay   Az   A{   A|{   A}\   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   Aì   Ač   An   AO   A0   A   A   A   Aʴ   A˕   Av   AW   A8   A   A   A   AѼ   Aҝ   A~   A_   A@   A!   A   A   A   A٥   Aچ   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   A Q   A2   A   A   A   A   A   Ax   AY   A:   A	   A	   A
   A   A   A
   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A    A!   A"   A#y   A$Z   A%;   A&   A&   A'   A(   A)   A*   A+b   A,C   A-$   A.   A.   A/   A0   A1   A2j   A3K   A4,   A5
   A5   A6   A7   A8   A9r   A:S   A;4   A<   A<   A=   A>   A?   A@z   AA[   AB<   AC   AC   AD   AE   AF   AG   AHc   AID   AJ%   AK   AK   AL   AM   AN   AOk   APL   AQ-   AR   AR   AS   AT   AU   AVs   AWT   AX5   AY   AY   AZ   A[   A\   A]{   A^\   A_=   A`   A`   Aa   Ab   Ac   Ad   Aed   AfE   Ag&   Ah   Ah   Ai   Aj   Ak   All   AmM   An.   Ao   Ao   Ap   Aq   Ar   Ast   AtU   Au6   Av   Av   Aw   Ax   Ay   Az|   A{]   A|>   A}   A~    A~   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   Aȵ   Aɖ   Aw   AX   A9   A   A   A   AϽ   AО   A   A`   AA   A"   A   A   A   Aצ   A؇   Ah   AI   A*   A   A   A   Aޮ   Aߏ   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A    A    A   A   A   Ay   AZ   A;   A   A   A   A	   A
   A   Ab   A
C   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A    A!z   A"[   A#<   A$   A$   A%   A&   A'   A(   A)c   A*D   A+%   A,   A,   A-   A.   A/   A0k   A1L   A2-   A3   A3   A4   A5   A6   A7s   A8T   A95   A:   A:   A;   A<   A=   A>{   A?\   A@=   AA   AA   AB   AC   AD   AE   AFd   AGE   AH&   AI   AI   AJ   AK   AL   AMl   ANM   AO.   AP   AP   AQ   AR   AS   ATt   AUU   AV6   AW   AW   AX   AY   AZ   A[|   A\]   A]>   A^   A_    A_   A`   Aa   Ab   Ace   AdF   Ae'   Af   Af   Ag   Ah   Ai   Ajm   AkN   Al/   Am   Am   An   Ao   Ap   Aqu   ArV   As7   At   At   Au   Av   Aw   Ax}   Ay^   Az?   A{    A|   A|   A}   A~   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   Aƶ   AǗ   Ax   AY   A:   A   A   A   A;   AΟ   Aπ   Aa   AB   A#   A   A   A   Aէ   Aֈ   Ai   AJ   A+   A   A   A   Aܯ   Aݐ   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A    A   Az   A[   A<   A   A   A   A   A   A	   A
c   AD   A%   A
   A
   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A \   A!=   A"   A"   A#   A$   A%   A&   A'd   A(E   A)&   A*   A*   A+   A,   A-   A.l   A/M   A0.   A1   A1   A2   A3   A4   A5t   A6U   A76   A8   A8   A9   A:   A;   A<|   A=]   A>>   A?   A@    A@   AA   AB   AC   ADe   AEF   AF'   AG   AG   AH   AI   AJ   AKm   ALN   AM/   AN   AN   AO   AP   AQ   ARu   ASV   AT7   AU   AU   AV   AW   AX   AY}   AZ^   A[?   A\    A]   A]   A^   A_   A`   Aaf   AbG   Ac(   Ad	   Ad   Ae   Af   Ag   Ahn   AiO   Aj0   Ak   Ak   Al   Am   An   Aov   ApW   Aq8   Ar   Ar   As   At   Au   Av~   Aw_   Ax@   Ay!   Az   Az   A{   A|   A}   A~g   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   Aķ   AŘ   Ay   AZ   A;   A   A   A   A˿   A̠   Á   Ab   AC   A$   A   A   A   AӨ   Aԉ   Aj   AK   A,   A
   A   A   Aڰ   Aۑ   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A {   A\   A=   A   A   A   A   A   A   Ad   A	E   A
&   A   A   A   A
   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A    A!    A!   A"   A#   A$   A%e   A&F   A''   A(   A(   A)   A*   A+   A,m   A-N   A./   A/   A/   A0   A1   A2   A3u   A4V   A57   A6   A6   A7   A8   A9   A:}   A;^   A<?   A=    A>   A>   A?   A@   AA   ABf   ACG   AD(   AE	   AE   AF   AG   AH   AIn   AJO   AK0   AL   AL   AM   AN   AO   APv   AQW   AR8   AS   AS   AT   AU   AV   AW~   AX_   AY@   AZ!   A[   A[   A\   A]   A^   A_g   A`H   Aa)   Ab
   Ab   Ac   Ad   Ae   Afo   AgP   Ah1   Ai   Ai   Aj   Ak   Al   Amw   AnX   Ao9   Ap   Ap   Aq   Ar   As   At   Au`   AvA   Aw"   Ax   Ax   Ay   Az   A{   A|h   A}I   A~*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A¸   AÙ   Az   A[   A<   A   A   A   A   Aʡ   A˂   Ac   AD   A%   A   A   A   Aѩ   AҊ   Ak   AL   A-   A   A   A   Aر   Aْ   As   AT   A5   A   A   A   A߹   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A >   A   A    A   A   A   A   Ae   AF   A'   A	   A	   A
   A   A   A
m   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A    A!   A"   A#f   A$G   A%(   A&	   A&   A'   A(   A)   A*n   A+O   A,0   A-   A-   A.   A/   A0   A1v   A2W   A38   A4   A4   A5   A6   A7   A8~   A9_   A:@   A;!   A<   A<   A=   A>   A?   A@g   AAH   AB)   AC
   AC   AD   AE   AF   AGo   AHP   AI1   AJ   AJ   AK   AL   AM   ANw   AOX   AP9   AQ   AQ   AR   AS   AT   AU   AV`   AWA   AX"   AY   AY   AZ   A[   A\   A]h   A^I   A_*   A`   A`   Aa   Ab   Ac   Adp   AeQ   Af2   Ag   Ag   Ah   Ai   Aj   Akx   AlY   Am:   An   An   Ao   Ap   Aq   Ar   Asa   AtB   Au#   Av   Av   Aw   Ax   Ay   Azi   A{J   A|+   A}   A}   A~   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   AȢ   AɃ   Ad   AE   A&   A   A   A   AϪ   AЋ   Al   AM   A.   A   A   A   Aֲ   Aד   At   AU   A6   A   A   A   Aݺ   Aޛ   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A    A    A   A   A   Af   AG   A(   A	   A   A   A	   A
   An   AO   A
0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A    A!g   A"H   A#)   A$
   A$   A%   A&   A'   A(o   A)P   A*1   A+   A+   A,   A-   A.   A/w   A0X   A19   A2   A2   A3   A4   A5   A6   A7`   A8A   A9"   A:   A:   A;   A<   A=   A>h   A?I   A@*   AA   AA   AB   AC   AD   AEp   AFQ   AG2   AH   AH   AI   AJ   AK   ALx   AMY   AN:   AO   AO   AP   AQ   AR   AS   ATa   AUB   AV#   AW   AW   AX   AY   AZ   A[i   A\J   A]+   A^   A^   A_   A`   Aa   Abq   AcR   Ad3   Ae   Ae   Af   Ag   Ah   Aiy   AjZ   Ak;   Al   Al   Am   An   Ao   Ap   Aqb   ArC   As$   At   At   Au   Av   Aw   Axj   AyK   Az,   A{
   A{   A|   A}   A~   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   As   AT   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   Aƣ   AǄ   Ae   AF   A'   A   A   A   Aͫ   AΌ   Am   AN   A/   A   A   A   AԳ   AՔ   Au   AV   A7   A   A   A   Aۻ   Aܜ   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A    A   Ag   AH   A)   A
   A   A   A   A   A	o   A
P   A1   A   A   A
   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   A I   A!*   A"   A"   A#   A$   A%   A&p   A'Q   A(2   A)   A)   A*   A+   A,   A-x   A.Y   A/:   A0   A0   A1   A2   A3   A4   A5a   A6B   A7#   A8   A8   A9   A:   A;   A<i   A=J   A>+   A?   A?   A@   AA   AB   ACq   ADR   AE3   AF   AF   AG   AH   AI   AJy   AKZ   AL;   AM   AM   AN   AO   AP   AQ   ARb   ASC   AT$   AU   AU   AV   AW   AX   AYj   AZK   A[,   A\
   A\   A]   A^   A_   A`r   AaS   Ab4   Ac   Ac   Ad   Ae   Af   Agz   Ah[   Ai<   Aj   Aj   Ak   Al   Am   An   Aoc   ApD   Aq%   Ar   Ar   As   At   Au   Avk   AwL   Ax-   Ay   Ay   Az   A{   A|   A}s   A~T   A5   A   A   A   A   A   A{   A\   A=   A   A   A   A   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A6   A   A   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   AĤ   AŅ   Af   AG   A(   A	   A   A   Aˬ   A̍   An   AO   A0   A   A   A   AҴ   Aӕ   Av   AW   A8   A   A   A   Aټ   Aڝ   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   A h   AI   A*   A   A   A   A   A   Ap   AQ   A	2   A
   A
   A   A   A
   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A    A    A!   A"   A#   A$q   A%R   A&3   A'   A'   A(   A)   A*   A+y   A,Z   A-;   A.   A.   A/   A0   A1   A2   A3b   A4C   A5$   A6   A6   A7   A8   A9   A:j   A;K   A<,   A=
   A=   A>   A?   A@   AAr   ABS   AC4   AD   AD   AE   AF   AG   AHz   AI[   AJ<   AK   AK   AL   AM   AN   AO   APc   AQD   AR%   AS   AS   AT   AU   AV   AWk   AXL   AY-   AZ   AZ   A[   A\   A]   A^s   A_T   A`5   Aa   Aa   Ab   Ac   Ad   Ae{   Af\   Ag=   Ah   Ah   Ai   Aj   Ak   Al   Amd   AnE   Ao&   Ap   Ap   Aq   Ar   As   Atl   AuM   Av.   Aw   Aw   Ax   Ay   Az   A{t   A|U   A}6   A~   A~   A   A   A   A|   A]   A>   A   A    A   A   A   A   Ae   AF   A'   A   A   A   A   A   Am   AN   A/   A   A   A   A   A   Au   AV   A7   A   A   A   A   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A¥   AÆ   Ag   AH   A)   A
   A   A   Aɭ   Aʎ   Ao   AP   A1   A   A   A   Aе   Aі   Aw   AX   A9   A   A   A   A׽   A؞   A   A`   AA   A"   A   A   A   Aߦ   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A +   A   A   A   A   A   Aq   AR   A3   A   A   A	   A
   A   Ay   A
Z   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A   A    A!   A"r   A#S   A$4   A%   A%   A&   A'   A(   A)z   A*[   A+<   A,   A,   A-   A.   A/   A0   A1c   A2D   A3%   A4   A4   A5   A6   A7   A8k   A9L   A:-   A;   A;   A<   A=   A>   A?s   A@T   AA5   AB   AB   AC   AD   AE   AF{   AG\   AH=   AI   AI   AJ   AK   AL   AM   ANd   AOE   AP&   AQ   AQ   AR   AS   AT   AUl   AVM   AW.   AX   AX   AY   AZ   A[   A\t   A]U   A^6   A_   A_   A`   Aa   Ab   Ac|   Ad]   Ae>   Af   Ag    Ag   Ah   Ai   Aj   Ake   AlF   Am'   An   An   Ao   Ap   Aq   Arm   AsN   At/   Au   Au   Av   Aw   Ax   Ayu   AzV   A{7   A|   A|   A}   A~   A   A}   A^   A?   A    A   A   A   A   A   Af   AG   A(   A	   A   A   A   A   An   AO   A0   A   A   A   A   A   Av   AW   A8   A   A   A   A   A   A~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   AǮ   Aȏ   Ap   AQ   A2   A   A   A   Aζ   Aϗ   Ax   AY   A:   A   A   A   Aվ   A֟   A׀   Aa   AB   A#   A   A   A   Aݧ   Aވ   Ai   AJ   A+   A   A   A   A   A   Aq   AR   A3   A   A   A   A   A   Ay   AZ   A;   A   A   A   A   A   A   Ab   AC   A$   A   A   A   A   A   Aj   AK   A,   A
   A   A    A   A   A   A   A   A	   A
z   A[   A<   A
   A
   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A   A s   A!T   A"5   A#   A#   A$   A%   A&   A'{   A(\   A)=   A*   A*   A+   A,   A-   A.   A/d   A0E   A1&   A2   A2   A3   A4   A5   A6l   A7M   A8.   A9   A9   A:   A;   A<   A=t   A>U   A?6   A@   A@   AA   AB   AC   AD|   AE]   AF>   AG   AH    AH   AI   AJ   AK   ALe   AMF   AN'   AO   AO   AP   AQ   AR   ASm   ATN   AU/   AV   AV   AW   AX   AY   AZu   A[V   A\7   A]   A]   A^   A_   A`   Aa}   Ab^   Ac?   Ad    Ae   Ae   Af   Ag   Ah   Aif   AjG   Ak(   Al	   Al   Am   An   Ao   Apn   AqO   Ar0   As   As   At   Au   Av   Awv   AxW   Ay8   Az   Az   A{   A|   A}   A~~   A_   A@   A!   A   A   A   A   A   Ag   AH   A)   A
   A   A   A   A   Ao   AP   A1   A   A   A   A   A   Aw   AX   A9   A   A   A   A   A   A   A`   AA   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   A   Aa   AB   A#   A   A   A   A   A   Ai   AJ   A+   A   A   A   Aů   AƐ   Aq   AR   A3   A   A   A   A̷   A͘   Ay   AZ   A;   A   A   A   Aӿ   AԠ   AՁ   Ab   AC   A$   A   A   A   Aۨ   A܉   Aj   AK   A,   A
   A   A   A   A   Ar   AS   A4   A   A   A   A   A   Az   A[   A<   A   A   A   A   A   A   Ac   AD   A%   A   A   A   A   A   Ak   AL   A-   A   A   A   A   A    As   AT   A5   A   A   A   A   A   A{   A	\   A
=   A   A   A   A
   A   A   Ad   AE   A&   A   A   A   A   A   Al   AM   A.   A   A   A   A   A   At   AU   A 6   A!   A!   A"   A#   A$   A%|   A&]   A'>   A(   A)    A)   A*   A+   A,   A-e   A.F   A/'   A0   A0   A1   A2   A3   A4m   A5N   A6/   A7   A7   A8   A9   A:   A;u   A<V   A=7   A>   A>   A?   A@   AA   AB}   AC^   AD?   AE    AF   AF   AG   AH   AI   AJf   AKG   AL(   AM	   AM   AN   AO   AP   AQn   ARO   AS0   AT   AT   AU   AV   AW   AXv   AYW   AZ8   A[   A[   A\   A]   A^   A_~   A`_   Aa@   Ab!   Ac   Ac   Ad   Ae   Af   Agg   AhH   Ai)   Aj
   Aj   Ak   Al   Am   Ano   AoP   Ap1   Aq   Aq   Ar   As   At   Auw   AvX   Aw9   Ax   Ax   Ay   Az   A{   A|   A}`   A~A   A"   A   A   A   A   A   Ah   AI   A*   A   A   A   A   A   Ap   AQ   A2   A   A   A   A   A   Ax   AY   A:   A   A   A   A   A   AAHA  AzARA\AARA33A{ApA33A\)A  AA  AƣA33ApA=qAǙAǅAzAǅA
AǅA33A\)AHAffAQAřAAď\A=qA(AAŮAGAǙAQAAȸRAA
A  AəA  AA
A33A\)AǙAǮAGAA  A  AGAĸRA33AAAGAHAŅAA=qA\)A(AĸRAHAď\A=qA  AÙA  A
AĸRAĸRAQA33A\AAA
=A(AzApAA£A\AA\AAģAŮAƸRA33AɮAǅAAA33AAȸRAəAȏ\AA  AAAA=qAffA
AffAGAď\AAAAȏ\AA
=A33AA=qA(A33AAƸRAŅA=qAHAApA{AƏ\A{A
AA=qAŮA  A=qAřAAřA=qApA\)A33AŮAGAAHAA=qA\)Aď\AzAģA  AA  A\)A
A(AĸRAHAď\AĸRA
AA
A\)AGAA\AAA
=AGA  A(Aď\AffAGAAîAzAARA{A(A=qAA(AffAÙAÙAģAAƣA
=AǮAAǮAǮA{AAAA=qAAAAǙAǅA\)AƣAƣAƏ\AGA
=AAAffAffAîAA\A\)A
=A{A(AŅAAzAQA
AĸRAzAQA
A
AAQAffA\AÅAÅA
AAQAQAQAHA
=A(AzAffA=qA\A=qAAď\A{AQA
=AAA
=AA33AA  AffA\)AAAAA
AAHAĸRAAĸRA=qAA\)AA  A  A(A33AĸRAîAzAQAQAQA  AAffApAA{A
=AAA\)AAffA  A  A(ApA{A
=AA  A
=AQAAAGA{AîA33A\AHAÅA\)A
=AGApAîAAîA{A{AffA=qA=qA(AĸRAGAĸRAA
=AQAHA{AffAÅA  AîARAffA(A33AA33AA33AAzA33AGAAAA¸RAA
=A\AA(ARAAA\)A
A  A(A  A  A{A33AAHA
ApAzAAA=qA
AGA33AAA
A33AAA(ARAHAAQAffAA=qAGA\AAA\)AAAAGA\A¸RAGAQAîAď\Aď\A=qAģAQA£AzAîAHAA¸RAffAA33A(AAAAAA(AA  AA  A(A
=AAAARAffA\)A(A{A  AAGA33AA  A  A¸RAA\AAGAARA  A
AA{A\ARARAAAGAGAAAA33AGAGAHAA(A{A
AHAzA=qA(A  ARA=qAGAA=qAGA{AA\AffAA{AAAA\)A(A  A  AîA=qA
AÙApA  AAA33ApAAGAA  AHApAzAAAA
AAffA=qAQA(AQAffAGAzA\A\)AHA
=AffAzApAHAA(AAzAffApAA33ApAAzA\)AA\)AApAAffAAQAAď\A\)A33AGAÅA=qAzA33AŮAQA=qAƣAAzAƏ\A  A=qA33AA{A=qAHA  AQAď\A¸RAzAA  A¸RAAzA{AGAAQAAA  AA(A¸RAA  A
AQAHA(A\A  ApA
=AAAAffAA\AA  AAQApAApAffA
=AAAHA\)AGAARA(A(AA  ARAApAA  AffA
=AQAHAřA
AAAA(AGARA  A33A
=ApApARAA=qApAApA
AǮAGA
AǅA  AzAzAȏ\AȸRAȸRAzA
AAǙA\)A
=AƸRAƸRA33A33A{AřAģAď\AffAffAGAƣAHAHAQAGAǮAǅAǙAǮApAǅAǅAǮAAAA  AƣAƸRA{AƏ\AQA\)A=qAŮA=qA=qA{AzAAHA
A\)AffA33A33AffAffAîAÙAÙApAÅAîA\)AGAAQA=qA¸RAĸRAŅAĸRAģA  A{A  A=qA
AzAA
AzAQAffAffAffAffA\AîAřAQA
AAAǮA  AƣAƸRA33AAAAď\A33AA
=AřAŅA\AHA
AQAffA  AHAGAřAŅAHA
A33A\)AAGAAzAŮAA=qAAAAHAHAA\)AřA{AzAAAGA(A=qAîAQA
A
A  A  AApA(A=qAHAĸRA{A33ARAQA
=AA  AAAA£A
=A33AA
=A33A33AAA
=AAAGAA  A
AApA\A\A\)A
=AAGApA\)AA(A(A
AAA\)AHAA  AHARA  AA£A  A¸RApApAHAffAQAA{ApAÙA\A\AffAAAHAffAQA(A{A\)AA
=AAA\)A  AffAQAzA\AGARARAA{AAHAffAGAGAGA  A  A=qAHAHAAzA\AffAApAAAA\AA\A\ARAA  AA
AApA\)A\)A\)A\)A33AAHA
=AHA(A
A
A(AffAQA(A\)A=qAA{A(A\AARA
=A33AGApAAAAA  AAA  AARAAA\A
AAHA33A  AAGAA\AAHA\)A{AGA=qA(AAA  AHA
=AA33A=qAAAGA33A\AA=qA  AzA\A
A\AffA
=A\AGA(A=qAAHAARAAzARAAA
=AA
=A=qA33ARA
AAAA=qA\AHA\A  AA(A{A{AA\A{ApA\)AGAA33AAHAAApAAHA33AAHA
A  A=qA(AQAA=qApAAAAAA33AHAAA{AAHAAHA\AAHAAA
AzAAA(A
ApA  A{A(AAzAAHAAzAA
A  A=qAHAAAzA\)AAQA(AQA(AAAzAffA
AA  AA33A33ApA
A  AAA
=AA\)A\)AAAQARAffAAGAGAARAAHAHAAHAGAzAA\)AA
=A\)AA=qAAAA
AAHAAA  A  ApA
AA
AA
A=qAGAAQA33A
A33A(A  AHAApAffA(A
=AHAzAQAAAAGA(AAffApA(AA
=A(AA(AA
=A  A£A\AA{A{AAGA{AffA33A=qAA\AHA\)A  AffAAA
AQA£AffApA(AA{A(ApAÅA¸RAÙA£AHA{A
A¸RAzAffAA
=AAzA33AHA=qAHA\AAGAA\)AApAQA\AîA(AzAAAA¸RAGA33AGA\AAQA33A(A33AAîA{A33AA\A\AA{A
A(AAAHA{A(A  AŅAA=qA¸RARAQAAAQA33A  AAA{AQAffAAAAAffAffAQA  AApAA33A
=AAHA
=AHAffAAHAAHAA
=A\)A
A  A=qA{AA{A(A(AA(A(A  A(ApAA\)A  AAAHA\)AGA\)A
=ApA\A
A
AA  AAAAHAApAA\A
AAAAAA
AAAAAAffAAAzA33AffAAApAÅAîAĸRA\)AŮA=qAƣAƣAHAA33A\)AǅAGAǮAǮA33A33A33A
AA(AAA{A{AAAAAǅAǙAǙAǙAǙAGAApAApAAA33ApA\)AGAǙAGA
=AĸRA(AƣApAŮAA{A
A
AzAAAA=qAAffA
=ApA\)ApAÙA\)ApA¸RAzA
AGApAA33AÅAîA(AQApA
=AAzA£AîA=qAzAApAŮA
A=qAQAƸRAA=qAƏ\AffAffAAA\)A\)AAA
=A
=AGA\)ApAGA\)AǅAǮAǙAǅApA\)ApAGAAHAQA{AQAffA(A{AQAzAffAQA
AŮAŅAřAŅAřA
AŮAŅAGA33AApApAŮAŅAAA
A
A
ApA
AAAAA
AŮAŮA\)A\)A33AAA33A\)ApA\)AHAĸRAĸRAzAÙAÅAÅAîA\AAÅAGA
=A£A(A=qA(AAÅA{AHAGApAŮAAƏ\AƸRAǙAA(AzAȏ\AȣAzAzAȏ\AAȸRAzAȏ\AHAȏ\A
=AffA  AAAffAȸRA
=AzAAȏ\A33AQAǅAQAA
=AǙA
A
A\)A  A33AQAffAzAAŅAď\Aď\AÅAffAď\AzApAAA
AĸRA33AA  AîA  AÅAAffA{A=qA=qA  A  A
AGAHAffAA
=AAAA{A\)A(AA(A
A£AGA
AHAA=qAzAAAAHAHA  A£AzAHAîA
AAGAffA{A=qA\AAApAA¸RAAîAAĸRAŮAĸRA
AAŮAřA{AƏ\AǮA
=AƸRA=qA\)A
AQAAÅAÅAAHAzAzApAGA(A=qA33AARA
=A(AAAzA\AAzARA(AAAzA
A{AGA
=AzAA33AA
ARAffAAffA=qAApAffA{ApA{A\AÙA\A\ARAAA=qAAA  AA  AAîAÙAď\AAAHAAHApAȣAHA33ApAɅApAɅAAAȸRAGAȏ\A(AřAĸRAAAGA(AŅApApAģAĸRAĸRAAAAQA  AAîA
A(A(A
A{A=qA{AîA  AîAA
AQAA(A\AAffAA33AAffApAAGAHAGAĸRA{AA{A¸RAAGA  AHAAAAHAGAQA  AA\)A¸RA  A=qA
A(AĸRAÅA=qAÙAQA33A{AffA=qAQAffAHAǙAǙA
A(AffA\)AǅAGAAA  AA\)AəAɮA\)ApAA{AHAGA(AffAzAffA{A  AǮA{AAAffAffA{AQAffAffAzAȏ\Aȏ\AǅA=qApA(Aȏ\AHA(ApA
=AAǮAAGAƣA33AHA
=AGA=qA£AAAA£AAAGA\AQAď\A\ApAA(A  AA
=AGAAAAA
AGAGAAîAď\AAzA33AAǙAA  AzAQAA\)A
A{AAHA
AAQA
=AǮAA=qApAŅAAȏ\AǮAA  A=qA
=AHAGA  AǅAGA{AQAzAQAǮA(A
AA  A=qAȣAQAǙAQApAřA
=AA\)A{AAGAAQAzAQAffA\)AƣAǅAģAA{ARARA=qA{AffAA
A{AAAAGAA\A33A33ApAAAGApA¸RA{AzA33AzAAď\Aď\AAHApA  AAƸRAHAǅAGAǮApAHAHA
=AHAGAƣA=qAAǙA  AƣAA33AffAQAȏ\AzAǙA(AǮA(A=qA{A(A
AA
=AHA(AQAQAAAA
AƏ\ApAAA£AAÙA
A
=AHA=qA{AA\)A{AApAA33AAGA{AA
A=qARAAAAA  AAQApApAÅAÅA{A(AĸRApAď\AģAzAffA\)ApAď\AGAŅA{AřA\)AAŮAQAAǅAGA  AǙA  A
=AAAzA{A  A\)A\)AQAĸRA{AƣAGAAǅAGAAAǙA33AƏ\AîAA{A¸RAHA{AŅAĸRAģAA£A(A  AAAGA33AAffA(AAA  A=qAA\)A
A\)A(AGAA  AzAAQA
=AA
A\A¸RAA  A\)AGA{A(A
AHA
=AÅA=qA  A=qAAAAAA33ApAA{ApAA{AAHAAA=qApAǮA=qAď\A
=AAffAÅAĸRAzAŅAģAAA\A(AHA\)AGAARAffAAA
A£AzAHA£AA  ApAHA{AAAAQAAA  ApAQAA{AA  ApAģA
AffAffA{AA(AHApAQAAzA\)A(AQAffAA=qAAGAA\AQA
A
AA33AƸRAAffA  AA  AQAA{A\A\AzAGAAHA
A\)AffAzAɅAȸRApAˮAˮA{A
=A͙AA{A
AAQA(A
AAAAɅA(ApAQAǮAǙAAGA
=AƏ\A{AÅA\A  AA£AAzAģAQAA  AřAAď\A
=AîAHA{A\)A
AQA{A\)A  AA
=A  ARA(A  A{AAA\)AARAARA
AHAAA(AAAA\)AzAffA\)AAAHAARA{A
=A=qAAA33A
AƏ\AffAƸRAAǮAA{AzAȣA33AAAA{AȣAGAA33AȸRA  A
=AQAƣAzAAA
AAHA(AƣAƸRAAAƏ\AAAAAA
=AAAAAAAHAHAƸRAHAHA(AA33AřAAģAffA33A(A(AĸRAApAƸRA  AffAĸRAA¸RAffAffAA¸RAAAÅA=qA
A  A  AÅA\)A¸RAAAAffAzA
=AffAGAA
Aď\Aď\AAAHAAAA
=AAřAĸRAzA=qA  A{A(AQAffA
A(A
A
AîAAA{AģA  AAĸRAƸRA{A
=AƣAƏ\AzA(ApAAffA  A(A
AzAQApAQApA(A
AA£A\A
A=qA\)ApA\)AzAAAAA(AîApAAffAAGAAzA\A\AAA
A=qA  A\)AffAGAAARA  AHAA¸RA\)AzAAA33A33AARAAARAA  AĸRAApA{A
AHA
A(AɮAʸRAʣAHAGAAAAɅA{A
A33A33AzAHAƣA  AÙAAŅAA\)A=qAQAģAGA{AzApAHA33AîA33AÅAAA33AffAA=qA=qAAQAA{AGAHAHARA
A\A(A  AAA
=ARAffAA  AAA
AAA=qAA\A(A\AAffAffAAAAzA33AAAA{A\AzAA33AîA  A=qAzAģAĸRAAĸRAģAzA=qA
A  A(AffA=qA=qA(A(AÅAA£AA{AA33AHAA\A=qAA=qAA33AHA33AA=qAzAAA(A(AGAHAA\A{AAARAAAARA
A
AAAzA=qA=qAHAAAA\A\)A
A(A(AQAffA
AAGAAAA\)AGApAHAGARA
AARAA{AA\)A(A\AA
=AARA  AAAA  AAApA=qA\AA\A{A{A{AA(A(AffAAAAARAAAAAAAffAA=qAAAffA
A
AAAGAAA(AffA=qA
AA\)AA\A=qA(A  AAAffA
A\)ApA33AAQAAAQAGAAAAHA(AQA\)AARA=qAA\)AA=qAffA\)AQA\)A\AGAffA  ApAAffAAA{AAAA
=AAAGAGAA33A33AAAAAA  AzAA
AA=qAffAQAzAA{AQA
=A\A{A=qA33AGA
AHA=qAAA
ARAHAA{ARA  A=qA(A
AAA\)AGAAA=qA=qAAGAQAAAGAAAAGAA{AApAA
AzA\AAApAAGAAAzAQApAA=qA\)A(AA  A
A=qAGA\)AGA\AA
=AffAHARAA\A  AffAffAffAzAAAAQAAARAA=qAA(AAAA{A\)AQA
A=qA  A=qAA\ApARAHAAAAAAAAAHA
AA  AQA33A{AAA(A=qA(ApA{AApAA
A\AA\)AQA(A
=A
AAAApAA  ARAA  A=qAAGAA(A=qARA
A\)ApA
A
AAAHAGA
AffA\AApA  A(A  A\AffAQA\A\A(AARA=qAffA{A
AAHA
=AApAAffAGAAAAAffAAAAQAffAffA{AffAA\)ApA=qA\)AA  AAA(A  A33AQApAAA
AA\A
A(A=qAffARA\AHAAA=qA\A33AzA33A=qA{A
=A  AAAffA\AApA  AffA¸RA33AîAzAď\AGApAģAffAffAAA33A
=AAAHAHAAHAģAzAffAîAA¸RA¸RAffA¸RAGApAGA33A(A{AAAAAA
AA
A
A
AAAGARApA\AffAQAAAAAAffA
A  A
AHA  AAAzA  AA=qARA{AAAQARA{AHA\AGAA
AAQAA  A
=A(AffA\)AAAA{ARAffAA{AA{A(A
AGAffARA\)AAA{A(AHAAGAApAARA(AA33A
=AA33AzApA{AAAA\)A(A=qAHAAApAffAAffAApA
A{AzAAAAA
=AHAAA(A{AffA
=AAARA=qAAA\ApARA
=A  A{AAAGAQARA(AAApAA
A=qA\)A  AAzA  A=qAQAA33A  AAA\)AAA(AA33AAA{AApARA\)A  A=qAAHA\)AQAAAAAA  A=qA
A\)A
=AAARAGA
=A{AA{A
ApAGA{A  AQApAA=qAHA=qA\A=qAAA
=AA\AA
AAAA\AffA(AAApA(ApA\)A\)AffAHA=qA=qA33AA(ApAGARAffA(ARA\)A(AAzAAAAQAAffA
=A{A  AAApAAAAGARAzAAA  A
AA
A33AA(AHARAHApA  AApARA
A(A=qA
A(AAGA
AGARAAAA=qApAAAApA
ARAAA(AAAAA(A
=ARAHApA\)A
AzA\)A
AA33ApA{ApAA(A(AA=qAAAzA\AHARA33ApA(A(AA  AAARA(A  ARAAApAAAAffAQA\)AAA
=AHAQA  A(A\)A
=AAHA(AzA
AAGApAQAA33A  AA
=A\A\)AAGA\)A\)A=qAA  AA{AAA\AGARA
=AGA
A\AAQAApARAA\AQA\)AA
=AzAAAQA\)A  AA(A(A\)AffAAAAAAGAQA{ApA
AA
=AA\)A(AAAQAQA
AAA  AQA  A33A
ApAARAHAAAA{AA
AAAAGAAA(A{AApAARA\A\AAffAAAAAAAAAGAAGA
AA
AAzAA=qApA  A
A=qA
ApAA\AffAffAAARAA\AApA
A(AAHARA
=ApA
AzAAffAA=qA  A
A  AA  AHAAAAApAA{A{AQA\AffAQA  AAAAGA\)A(AAffA(AAGAAHA\AAAAHA
AA=qAHA  AHAAAffA(AAA=qAAAApAAAAGAAAAAQA\)A(AAA  AffAAffAAAQAffA  A  A{AAARAGAffA33AAAHA=qAQAA{AHA(AARA(AApA{AHA\)AHAffA  A{A
=ARA\A  AffAffARA
=AARAffA=qAAAffAzAQA{A{AAApA  A\A
A  A=qAHA  ARA(A\ARARAHAAAA33AAGAApAA\AA(A\)AAA33AAA33AzAAAzApAffA  AAffA  ARA=qApAAA  AA
=A{AffA
AAA
=AffAA\)AHAHAA
=AAA33AHAAGA33A
=AAA  AffAQARAA  A(A(A  AAAAA  AHA
AAffAAAApA33ARApA\)AQA{AGAGAAARA(AA
=AffAA(AA33AAAffAApAAAGAQAffA  A
AA=qAAQA  AA
=AQAGAzAQA
=AGAAHAA\AA
A(AAQAA  AAA=qA
AffA  AQA33ApAAAAGAA  AAGAA\AzAzAHAAHAAHA
=A\)AA{A\A{AffAA
A\)AA33AA(A\AQA=qAA
AHA=qA{AAAA\AzA\A33AA(A=qAAAHAffA=qAAAAAA\)A33A{ARAHAA
ApA  AAffAA(AAA
=AzAzAHARAzA
A
A\A\A=qAA\)AAHAAAAA(AA{AAAAQAAGAA{Aď\AA33AGAŅAA  AffAA  AAQAzAƣAffA{AA£A\)AÙAAA(AÅAffAĸRApAGAAAŅAGA
=AGA\)AA
AffAA
=AzAHAA
=AQAď\AQA{AÙAAAÙAA{A\AzAApAQA
=AffAA
A(A\AQA
AzA(A{A(AAAHApAA33ARAzA=qAAA\AA33AAAA  A\)A=qA33AÙAApAîAîAApApAÅAîAAÙAÅA\)AGA¸RA£AA=qAA{AQAřApAřAŮAŮAA=qA33AA=qA(AffAApAîAARA\)AzAA  AAAGA(A£ApAAzA
AAA
AAA  AA\AHAzAffAA=qAA=qAAApAAA
=AAA(A\AAAzAGA(AzA
=A(AA=qAAffA
AApAAAGA33A\)A{A{A
=AAGA(AzA\AAzA(AzAAAA(AAffAGAQAA
AffA\)AA
A
AA
=A=qA{A\AQAAA\)AAAAA\A\)AAA
A{A(A{AAAAA33AGAAHAA  AA=qA  AAAAAAffAAHAA
=AA\)A  A{AzApAAAAAAHA
AAA  A=qARA=qA33AA\AHApA(A¸RA£AA
=AGAÅAA(A(A(A(A  A  AîAApApA
=AHAÅA33AA  AzAffA
AĸRAffAzA(A(A
AîAAÅAîAGAÅA\)A\)AAAQA=qAA(AffApA\ARA
=A(AA{A\A
A(AApAzAAA\)A
A(A
A\AAAHA{ApAAAA33AApAQAAAffAAA  AzA(A(A\)AffAA
=AŅApAřAŅAŮAŅAŮAAŅAřAřAAŅApAGAAĸRAAAffAA
AAGAÙA
=A
=AŅA\)AřAŮAŮAŅAŅAA
=AHA=qAHAffAAģA
=Aď\AHAÙAÅAAģA
AÙApAHAHA
A=qA(A\AffA33ARA(A  A=qAA(AAA
=A\A  AAHAffAzAAGAGA  A{AAA\AAHA=qA=qARAA
AzAAA33A\AAzA33ApAîA{AîAÅAA¸RAGApAÅAQApA\)AHA
AÙA=qAA
AGA\AÅApA\)ApAÅAAÙAzAzA{A\AA£AA
A£AAAffA¸RAAA=qA\A¸RAAîAAAÅAApA(AGA(AAAAAAA=qAA
AGAA33AApA
A(ApA
A{AA(A
AA=qA
=AAApAAA\AA  AQAHAQAGA\)AffARAHAAQAAAAQAzARA33A
=A
=ARAQA  A  A
=AA(AAA=qAA
A{A\)AA
ARAffAQA{AHAHA\A=qAzA=qA\A{A  AzAAAGAA{A  AAARA{AHA  AAA=qAQA=qARAAAA{A=qAARAzAAzAA33AAApA{AA\)AffApAA
A{A
A
A(AA(A  A\A=qA
A  AffAffA(AHAzA=qA{ApA  A33A=qA
=AffA(A{A{A\A{AA(AQA\A\A\AARARA
A=qAAA(AAGA
=A=qAffAAzARAARAA(AzAAA  AHAGA  AA
AAAA33A=qAApAAApAQARAA
=AA\A(AAffAARAAffA\AAA
=ARApARAAzAAffAAAAAA33A
=AffAA  ARA  A{A(A(AA\)AzA¸RAA¸RA£AffA\A33A\)AA¸RAzA\)AGAGAAÙAAGAffAA
A
=AGAGAAffAApApA(A  A
=A
=A\AA
=A\)AA
A{A{AA
AAAQA(A=qA(ApAA(AHAGA\)ARA(AAAGA{AA\AGAA  A(AAHA=qA=qAA  A
=AffA  A
AA  AHA33A(AAAAAHAA  AAQA
=AA  A=qA=qAffAffA  AA
ApAzAQA
=AARAffAARAApAGAA\)AAHAAARApAA\A\A\)AAHA\)A  AQAA{AffA(A\)A\)A
A\)AA  A{A{A
=AA(A33A
=AffA{A(A(ARAARA\A
A=qAGA\)A33A
AzA
AAGAHAGA=qAAHA(A(AAQAAGAGAA{A33ApA
=AApA=qARApApAAA
=A(AGAAHA(AA
=AApAAA(ARAAGApAffAA=qAGA{AA
A\)AHAzAQAAAA  AA(A
AzAApAAA=qApAA(AAAzA(AA{A(AA
AffApA
A
AA=qAA  AzAARAGAA\AAAARAA(AffAAHAGAAA{AffAAAGAAA{AQA  A
A{A{AHAA33A{A\AA33AzA
A{ARAAAA{A=qAzAQAAA
=AAA
=AffA33AHA
=A\)ARAAA=qA  AAffAA
A\A\)AzA
AA=qA{AA33AA  A
AApA(A\)A\)A\)A\)AA  A{A=qAAHAA=qAA  ApAQAQA(AAAGA33A  A=qApAAzA{A\AHA\AffAAAAGA{AA{A
=AA(AAQAAAAffAAQAffAffAAA(AQARAAffAGA=qAQAAffAGAffAzA  A
A\)AAQAGARAA\A33AA  A\)AffAAAAA(A\AQAHAffAA  A\A{AA{A33A\)ApAGARA\AQAA(A33AAA=qA\A33AA(AAQA(A
=A
=AGA  AQApAffAAGApA\)AAffA
=AAA\)AA33A
=AAAAAARAA33AAAAzA33ApA
=AAAAAHARAAA(ApAHApAAAAAAA{AzA{AzA
=ApAAffAA
=AGA  AAHA
=AQAHA
=AQA{A
AAAHAzARAGApAAAAA
=ApAGAffA\)ApAffA\)AQA\)AffAHAffARA
=AGAAAQAzAzAA=qApAQA=qA\)AAA{AzAHAQAHAAAARAA
A  AAA{AQA
AQA\ARAHA\)AHA(AAzARAGA{A\)A(AHA33AffAQA(AAzAGAGARAAAA33AHA33AA\AzAA\AQAAA\)A33A\)A
=AzAAGAA(AGAffAA
=A
=AAzA
A  AA(A\A\AA
AA=qA
=AAzAQAzA
=AAA{A
AAA\)AAA\AA(AGA  AA=qAA{A
=ARAQAQAAAAffARARAAAzAffAGAA\AA=qAAAAA(AGA(A
=ARA33A33A(AGA\AHAA\)ARAAffA{AA
AAAA
A  AHA{AGAffARA
A  ApAAAAQAAApAAAAApAApAQAAA=qAffAAzAHAAAGApA\A(AA33A
AAA=qARA=qAAA(A{ARAQA(A(AAGAĸRAGAîAÙA=qAHA33A  AffA33A  AA
A\AAA33AzA\AA\AHA
AAAGApAAAffAARA=qA{AQA(A{AA
A\)AA
=ARAHAAA33A\)ARAQAAARA  A=qAA\)AA
A\)AApA
=AARA
A=qApAffA
AAAApAAffAHA
AA  AGAA{ApA=qAGAzA(AAAAA\A
ApA{A=qAAHA(AffA(A=qAzARARAAAzA
=AAAHAzAAA\ARAAA\)AA\AQA(AA\)AHA
AAAAffApAHAAzA
AffARAHAzAAAAAA=qA\)ARA\)A\AQARAA33AA
AAAzApAA  AA\)AAffAGA  AA\AA
=AA\)AQAAAA\)AAAAA(AA\A(ARA\AffARAAffAA
=AAAHA=qAApAffA(A(A  ARAA=qAHAAAA  AAAAHAAA
ApA\)AAA
=A\AA
=A
=A{A{A\AAA  AApAQAA  A\A  AHAAAA(A  AAAAAAA  A(AA\)A(A\AAAAGA
=AA{ApApAffAffAARA\AHAA{A{A\AffA
=AAffA=qAGAzAApAAGARAQAA(AzA  AzAA\ApAAAHA  AA
A\)A\)AAA\)ApA{A\A
=AAAAHAzA\A33ARAAffAHAAAA\AA  AAGAA
=A{AA
ApA  AA{A33A33A33AA{AA\AAAAA(AzAAAHAAHAA\AA
A=qAA=qA33AzAGAAGAARA33ApA{AHApA(AAA{A  AA
A
AAHAA
A¸RAAHAQA(AA  A
AAGAGA33ApA
A=qA\)A
ApAGAzAffA33AHAAGAQA  A  AA  AzA=qAHARAA(A33A33AA=qApARA
AHAAzAffAAAA  Aď\A
=A\)AffAA(AQAzA33AAQA33AAAHARA
A
A
A  A(AAA(A33A\)A(AAA33AƏ\AǙA{AzAA
=ApApAAGAffA  A{A\)AAQAA33A\)A  ApAffA{A
AffA=qA
A\)A33AAAÙA
=A(A
A=qAHAQAĸRAHA  A\)A  AQA
=A\)Aȏ\AȸRApA\)ApAHAzAHAAď\ApAǙAAA{AAřAzAA  AzAffAAA\)A  AȣAAAǮApAAAGAȣAzAAȣAƸRAffAǅAHAǮAzAA\)AffAȸRA  AʸRAAAGA˙AGApAAAA\)AA=qA  A{A(A
=A\)AAAzA{A33AffAɮA\)AȸRAȏ\AzAAǅAA
AǮA33AA\)A=qA=qAAǮAȏ\AzA
=AGA(AffAA
=A\)ApApA{AŮA{AAAŅApAď\AA\)AffApAģA\A
A
A33Aď\A33ApAAffAffAA{AAApA{AHAAA  ARApAA=qAGAffAHAAffAAA33AGAƸRAzApAA
A=qAAQAffA\)AHA=qA(A(A(AAAƣAƏ\A=qAGA(AA
AƏ\A¸RAAAQA  AApAAGAA\A{AîAAĸRA=qAGAzAA{AÙAĸRAGA\)A33AA¸RA
A(A
AGAA\)AAffA(AA{AAA(AA  A\)A  AGAAzA{AA\A=qA£AA  AAGAHA\AffARAA{AA33AzA{AAA33A
=AQA=qA\)A=qAAAffAAAAA=qAzAA\A\)ARAAAffA33AQA(A  A(A33ApAAď\AÅA{AA£AAffAzAQApA=qAAA(AA=qAAzAA  A  A33A\)AA33AQAGA\A{AAA33AAAzAAGAGAGA\)A(AAzA
=AzA\A(AA\)A{ApA=qAȏ\AA  AɅAɮAAAəAʣAA
AzAƏ\A33AǙA
=AAƸRA=qA33AHAQA£A33AApA
=AGA¸RA{AÅAď\AffA¸RA
A\)AA\)A33AA  AQAAA\AffAAAGAAAAA33ApAAAzAARApA\)AA
=AA\A(A  AA  AA\)AApA33A\)AA=qAAA=qA{AA
=A\A
=AARAHA(A  A33A33AQAřA{AŅAAzAARAHA
=AģA  A  AAÙAzARA33A  ApAAGAA£AA£AQAffAA
A
AA=qA33AAffAAA33AGApA\)ARAA  A\)AAA=qA=qAA£AĸRA{AQAffA{AHAAAA\)AGAAAA(ARAGA
ARA  AffAApAAQAzAA=qAGAApAAĸRAĸRA\A¸RAĸRA(AGAAA
=A
A  AzA£AAzAA\A  A£A(AÙA33ApA(AHA(AQApAď\AA=qAǮAAƏ\AAzAǅAAǮAA
AzAGA33A  AŮAƸRAAzA(AAĸRA\)AĸRAAAffAA33AAřAŅA
AGAHAApA
A33A  A(A
ApA\)AřAHA=qAŮAzAƸRA(AƸRAffA\)AÅAAAAzAGA33AAAAARAƏ\AŅAA\)Aď\AAffAƣA  AǮAAzAAzA(Ȁ\AAQApAAǅA=qAA(AAǙAzAAɅA
A(A
AA{AAA
AAffAffAAA=qA{AffAGA\)AHAHApAA(A  A{AȸRA\)AGAƣA\)ApA=qAAȏ\AApAAÅAzAAĸRAŅAA=qAƣAAffApA
A  A\)AŮA\)A33A{A\)AÅA(A
=AAGAAAď\A
AîAď\A{Aď\AA
A
A
A  AAzAQA{AA£A33A33AîA(A  A  AǮAGAĸRAîAzA  AApAď\A
=A{A=qAîAƸRApApAffAAîAA33AApA\AA{AAAzAGA  AHAQAŮAA  Aď\A
ApAĸRA\)AAA
=A\)AAŮAzAŅAřAÙA(AGAA{AAÅAÅAîAAA{A
=A  A\)A
=A{AA
=AffAAAAAAAffA(AzA
=AAARAAA=qAÅAGAGAA
AAAA{AzAȸRAffAA(A  AGAA33AAAGAAɮA(A(AHA33A(AA  AffAʣAGAȸRAɮA{AƣA
AQA
A(A  A=qA\)AAȏ\AAƏ\AGAffAȏ\AȸRA33AGA33Aȏ\A
=ApA
A{AHAǅAHA=qAAA(A(AAHAffAApAHAQAǅA33Aȏ\A
=AzAȣAAɅAGAǮA33ApAAAřAA
AɮAQAffAApApA(A
=A{A=qA33AA
=AAA˅ẠA=qA{AHA=qA
=AffȀ\AffAHA̸RAzA(AQAffA
A͙A͙A͙A(AAAǅAffAHAA(A\)AŮAGA͙AͮAGAAAGAəAȏ\A{AAȏ\AȣA(AAAffA
AA(AQAHAɅAʸRA
AəA(AəAʏ\ApApAA(AîA  A{AHA\)A{AzA\)A
AA{A=qAzAɅA(AAˮȀ\A
=AAffA  AAzAHA=qAȀ\A
A˙AɅAɮA(ApAApA(A̸RAAAˮAA
ApAA{A\)A33AHAA
=AffA{AffAffAQA  A(AAȣAGAA\)AHAA33AffAffAzA  AGAA33ApAʣA  AQAGAAffAHAGAģAGAǮA(AHA  A\)AHA(A(A£AA  AffAAffARA
AA(AGA33A
A=qA33AA\)A{Aď\AĸRAHAģA(AřA  AǙAƸRAAģAď\AAA{AŮAffAģA
=AGAAAHA33AŅAģA(A(AAA
A  ApA(AǮA  AAƏ\AHAǙA
AAǮA
AHA33AAƣA
AA{A=qA
=A(AzA¸RAGAzApA\)ARAAAA33A
=AAA\)A  A=qA(AîAQA  A\A
=A£AffA\AffARAA{AŅA=qA¸RA  AģAQAŅApAřA\)A\)AǮAzAzA33AAzAGA(AAřApA(A(AƸRAAGAA\)A\)Aȏ\A=qA
AǮAǙAǅAǙAApAA33A33AAA
=AHAƸRAQA
AřA{A=qA
AƸRA=qApA  A\)AAîA=qAÙAÙA  A
=Aď\AA
=A{A¸RAA{AGA
AAAAÅAAzAQAŮAď\A=qAģA{A  A=qAÅAA
A\)A{AA
=A=qA(AÙA¸RA  A£A{A(A¸RAAffAHAƣApA(A\A¸RA\)AHAffA\)AGAA  A
AǅAǅAAȣAAHA=qAffAHAA
=AAĸRAŮAAHAǙAA33AQAA
=A¸RAÅA33A¸RA=qAAGAAA£A(AGAA\)AGAA=qA\)AAAffA\)A33AzAA
=AAGA\AA\)AffAA  AGAzAA{AAAHA
=AHARAAffA\AApA(AAzA  AA
=A=qAA
=A=qAA
A¸RAA{A=qAHA  AîA  A=qAffAHAŅA=qAQAƣA  AAȣAAɮAA
AHA=qA{AA  A
AA33A  AApAAQA=qAHAA\)AǅAǮAA\)A
AA
ApA{AQA=qAGA(AGApAģA{AƏ\A
=AAď\A\AřAď\AGA33ApA  A\)A33AÙAď\AAAzA\AA
AA(A£A33AŮAď\A
AŮAAAAƣA=qAƏ\AƏ\AÙAQAAA
A{A(A  A=qAŅA=qAA
AQAȣAȣAAɮA
AGAffAzA
AHAAȸRAǙAA
=AAƣAAAA=qA{ApA  AA=qAA(A=qAQAffAȣAA(AQA  AGAAAHAzAA(AAA
A
AɮAAģAď\AA{AǅAŮAAAffA\)A{Aď\A(AģA{AA(A  AAQAAQA{AAAƏ\AAA  AǙAǙAƸRAAQAÙA
A(A33A(Aď\AAƏ\AGAQAHAɅA=qA{A\)AˮA
A˙A(AQA=qAAzAAAffA\)ẠAzA
AffA
AGAˮA\)A
AAApAƸRApA
=AǙA33AAƏ\AƸRAzAAzAGAƸRA\)A(ApA{AffA{AAŅAřA(AƣA\)A  AA{AîAĸRA  AQAffAď\AffA=qApA
AffA=qA  ApA33A(A¸RAAffA33AQAGAĸRAď\AzA(A{AHApA
AȣAȸRAȣAȣAȣAzAffAȸRAȏ\A(AQA
A{AAAHAǙA{A=qAȏ\AHAGA{AHAȏ\A  AAǅAAƸRAAAƏ\ApAA33AA
=AƏ\AA=qA  A(AQAƣAHAAƏ\A=qA  ApA  A
AAĸRAzA=qA\A\A{A\A  AQAAAAffAHA£AA
AffA=qA£A\AGA
A\AAzAA{AÙAAAffAAAAǮAAǅApA
=AǮA33AǅAAA{AA\)AGAA
=AAGAGA\)AA33A
=A
=A
=AHAAAHA33AA\)AƏ\AƸRAƣAƏ\AAƏ\AffAffAA=qAƏ\AƏ\A(AffAŅAAffAQA(A(ApA33A33AAffA¸RAApAAGA\AHAGAAAffA  A
A(ApAHA(A(AAA(AAÙA33AÅAAzAffAA\)AHAAAA{A
A
=A(A  ApA\AAÙAÙA
AA33A33AHAƣAffA{AQAffAA{A{AǙAQA(AQAQAAǅA\)AGA33AAA(A{AA  AřA  A
AGAģA{A33AA{A{AHA
=A=qAQA¸RA¸RA
A=qA(AAAHAA
=AA
=AzAA
=AA=qA\)AAÅA  AîAÅAAGA=qA£AGAÅA¸RAA£A£AAHA(AAA=qAA(AÙAGA  AzAģA\)A  A{AQAƏ\A
=ApA\)A
=AA33ApAǮAA{A{A
AAAǅAAffAffA
AŮAApA
=AHAAAHAA33ApAffA\)AA
=AffAȏ\AȸRAffA
=AffAƸRAŮApAGApA=qAffAAǙAA
=A33AAǮAA
=AŮA=qAffAQAAGA(A  AzA{AģA  A=qA
A{AffA=qAîAA(AƸRAAŅA33A33AƸRA
A(AǙAA33ApAAAGAĸRAŅAA=qAAGAAzAA\)ApAɮA  AffAHAʸRAA˙A
A˙AA˙A\)AGAGA˅A33AAHAHAˮA˅A˅ApA  AAAˮAA  AffAAAAəA(AəA
=AHAGA{AffA(AGAɅAAAzA
=AzAffA  AǮA33A(AAAA
=A{AHAĸRAffAÅAGAAGAƏ\A
=AǅAǙAƏ\A(A=qAHA
=AAApAA
=A
AȣA  AA˅A(ApA(A
AA
=A33A=qA{AffA=qAzAffAzA  ApA
AApApA\)AAQA  A͙A\)A33AHApȀ\ApA͙AͮA(A
A=qA{A33AAzẠȀ\AQA̸RA33AGA̸RA33AHA̸RAHAffA{A{AɮAQA{A(A
A
AAəA33AɅA\)A(AGAA  AffA  ApA  A=qAQAffAzAʏ\AʸRAAƸRA
=A
AĸRAffApAîA
AģA33A  A=qA33A
AzAA33A
=AˮA=qAGAA\)AQAQAΏ\AθRAΣAθRAυAϮApAAzA(A{AQA
=A
=AzẠAQAAʣAʏ\A  A33AA
AͅApAAA33AΏ\A\)AϙA(AAAAHA
=AAͅAQAʣAƣAA
A=qApAɅA
AAHAǅAAɮAʣAA=qA=qAApAřApAģA
AA{AA{AGAGA
AA\A
A\AQAQAA33A  A£A{A=qAA
AffAHAApAǮA  AQAHAGAəA
AffAʸRAHAAA
=AA˅AHA=qA˙A
=A
=A
=A(A
A
A=qA(AQAA˅AHA
AͮAA
A=qAA=qAzAA  ApAzApA
AzAˮA{AəAǮA̸RAHAA\)AApA
=AHAAȸRAƣAA£A(A\)AŅApAAQAGAffAAQARAA  AAA\AQA
AA{A(AHAA£AHA
AAAffAHApA(A
=A=qAȣAAAʣAʏ\AA
AA(A̸RAAͅA33A
ApA\)AHAˮAffAɅAAGAɅAQAɮA\)AGAɅAzAɅA
=AAȣAzAffAȏ\AAȸRAA
A(A\)A=qA(AffA(AzAffAApAQȀ\AɅAzAAA(AzAGAQA
=AAAƸRAQAHAGA{AʣAQApA(A=qAǙAQAHAAzA=qAQApAzA(AAǮA
ApAƸRAəAʏ\Aʏ\AQA=qA̸RAzAHAGA
A͙A{A
AA=qAQAzAzAθRAΣAΣA  AΏ\AΣA(AzAQAffA33A\)AGAHAϙAΏ\AzAΏ\AθRA
=ApAGAHAΏ\AffAΏ\AΏ\AΏ\AzAffAQAffAHAΏ\A{AͅA{A˙A  ẠA̸RAGA̸RAQA33AA=qA(AˮAAHAʏ\AɅA  AA˙A˙AA{AAHA33A˅A\)AGA˙AApAA=qAΏ\A33A͙AΏ\AθRAθRAͮA  AApAΣAѮAУAЏ\A(AЏ\AиRAѮA\)A
A
AљAљAGAиRA{A  AиRAAffA\)AӅAA\)AGA
=AAңAAхAA(A  AQAϙA(AHAzApAHAHA\)AљAAхApAGA\)AхAA\)AAGAGAHA(AͮAA\)AͮAQAAA̸RA˙AA
=A(A
=AGAɅApAApAAA͙A
AA  AQAʸRA33A
A{AHAAAΏ\ApAϮAAHA=qAzA  A
AAQAA
AAAHAGAѮA{A{A
=AЏ\A(A(A
AϮAA
A\)AGAffAAA
=AͅAHAffA=qAffA˅A
=AHA33AHAAȏ\AQAɅAʣA33AAffAA˅A  Aʏ\AHAɮA=qA
=A\)A{A
AzA˙A\)AAA  A(A
AGA˙AAHAˮAffA
Aʏ\A˙AɅAʏ\AHAƣAAA\)A(A\)AA\)A{AȸRAď\A  AîAA
AřApA=qA{AQApAʸRAȀ\A33Ȁ\A˅AAͮA
AΏ\AυA\)A
A=qAQAAAA33A
=AffAHAHAAHA
=AA
=AиRA(A{A=qAA
=AЏ\AffAиRAиRAAAУAQAQAzAЏ\AffAAHAGAиRA  AHAGAQAϮAApApAΏ\AQA̸RAzA{A  AɮA=qA  AɮȀ\AˮA
=Aʏ\A\)AAffAzA(AˮA  AHAffAˮAͮAzAHA
Ȁ\AAAHAəAẠAʸRAǮAA{AQAHA(AA{AAˮA\)AGAəAAAʏ\AffA̸RAA33A
=ApAGAffAA=qAffAAA33AA
=AffAffApAA{AAʣAffAA
=AAAAGAA  AʸRA̸RAʏ\A
AffA
AͮAAApA(AʸRA{AAHAƣAzAŮA33AzAAîAÅApAAÅA  A
=AřAAAA\)A
AƸRAAAȏ\A\)A{A33A\)ApA\)AəA(A=qA=qAAGAˮA(AzAAͅA  A=qAffAΣAΣA33A\)AϙAAQAиRAиRA  AGAGAЏ\AУAGAиRAУAЏ\A
=AffA{A
A(A{AGAΏ\AΏ\AHAAGApAϙAA=qAͅAGA{AͮAffA(A
AͮAͮA  A  AˮA(A(A͙A33A=qAffAA
AAЏ\AQA{A=qAA\)AAHA
=A  AθRAzẠApAGAΏ\A(AΏ\AA˅A  A
AͅAffAHAffApAA
=A33Ȁ\A̸RApA
AA{AzAAA  AQAAAҏ\AAGA\)AӮAA(A(A  AAәAәAAAAHAffAQA(AAљA=qAQAA(AA33AA33AGA33A
=AӅAGA33AHAAѮAzAQAzAA
=AA
AzA33AQAӮA(AҸRA  AA{AӮAӮA
=AAҏ\AHAAҸRAҸRAHA(AHApA
AҸRA33ApA
=AAAAҏ\AffAAAQA(A(AGAzA33A=qApAHAA{AљAAApAApA  A֣A
=A
=AHA33A
=AffA  AAQA֏\A֣AQA=qAQAAծA
AAծAԣAGAAԸRAәAAңAAA33A33AGAAGAGA=qA֣AׅAA
=A
=AffAңA  A
=AAHAЏ\AApAffA=qA
=A{AzAAHAAҏ\AУAAиRAGApAAΏ\A{A33AЏ\AɮAAȸRAƏ\AffAQA(AAHA
=A˙AAffAGA33A(AAϮAΣAθRAA  AA  AAGA
=ApAυAA\)AиRAzAAffAzAHAљAAңA\)AHA(ApA\)AAхA(A33AѮApA
AA(A(A(A{AzA=qAѮA
=AGA=qAиRAυAGAGAиRAzAУAGAzAЏ\AиRA
=A\)AθRAGAA=qA33AQAQAΏ\AGA(AHApA
=AAzA
=AGA\)ApAGAͅAffA  A{AffAΣAAAQAQAzA=qẠA
=AͮAA\)A  A̸RAHA  AAGA\)AAffA33A
=AҸRAәAHA
=A
AծA\)AHA(AA
A
A(A(A{AA
A
A
A
AӮAәApA\)AӅAA{A(ApA\)A
=AӅAԣAAGAAиRAA=qAffAffAGA
=A33A(A33A{AAAхAGA\)AGAHA  AљA
AиRA
A=qA\)AQA
AѮA
AffApAGA{A(A33AGA
=A̸RAAAA{ApAAΏ\AApA˅A33A  A=qAzA=qA=qAȸRA
=A  ApA̸RAGẠȀ\A̸RẠA  AzA̸RA33A33AGApAͮA͙AͅA\)AGAA
=AGAQAQApA{AͅA
AA=qApA
AA
=AGA
=AHA(AЏ\AzA=qAθRAA=qAffAυAиRA  AυA
=A
ApA
AGAͮAA
A  A˅AAGA͙AApAA˙A(A
=AAGA33A
=A
A˅AɅA{AA(A
AHAHȀ\A\)AʣA  AQAɅAHA  AGAΣA(AУAGA33AхAѮA
A  AQAHA33A\)A(AffAAңAAAHA33AңA=qAffAzAQA(AffAҏ\A(A(AAffA33AAAAA33A
AGA(AHAGA(A  A͙AA{A{A(AA=qAffAffA(AA(A{A  AɅAGAʏ\A\)Aʏ\AɅAA˅AzAA
AAA\)A  ApA
=ApAΏ\AϙAAAΏ\A(AѮApAHA{A(AAA
=AzA
AϙAffAzAHAљA  A(AңA\)ApA\)AAAA
=A33AGAGAAAAAҏ\A\)AҸRAңAQAңAzA(A(A  A
AљA
A{AAA
AљA\)AхAәAA
AҸRAA(A{A  A=qAzA(A  AљA  A\)ApA=qAffAA=qAQAffAAGAΏ\A̸RA
=AAA=qA˅AͮAffẠApAΣA33AAQA{AffA̸RA33A=qAAͮAGAͅA˅A˅A˅A(AQȀ\A͙AA{AHA33AυA
A=qAQA=qAA=qA\)A  AffA33Aҏ\AҸRAHA33A{A{AGAGA  Aҏ\A=qAffAQAffA{A
AGAA33AAЏ\ApAHA33A\)AGAGA\)AхApApAA\)AGApApAѮAхA  AѮApAA=qA{AHAAHA{AffA33A{A˙AffA
AǙA\)AffAHAɮAA˙A(AAHA\)AGẠA  AA̸RȀ\A{A˙A=qA
AffA̸RAGApA(AθRAυA(AAхAѮAA  A
=AA  AGAAGAAҸRA=qAffAңA{ApA(A33A\)AffAҏ\AHAҏ\AzAzAzAAGAӅAәA{A{AAHAAAGAҸRAGAAA\)AәA\)AAAҸRAA{AѮAQAAA
A
=ApAffAAQA{AA  A(AGA33A
A33AΏ\A=qAzAAHAGApAHAHAffAθRAA(A\)A33A\)AzAzA{AAzA̸RAʣAQAɮAA=qAffAAA=qA̸RA̸RAHAHA
=AGAGApAͅAͅAͮAQAffAffAffA
A(AQAzAHAAϙAͅA\)AθRAͮAA  AA{Ȁ\AAAHA\)A33A33AAQA  AAǮAzA\)AəA
A˙A\)A̸RA̸RA
=A
A  AA=qA(A{AA33AHA
=AA
=AGAAAzAffAAΣẠA33A
A33AGAəAʏ\AƣA(AQAǙAʣA
AGAϮAQA(AffAθRA{A
AffA(ApAAApAԸRAՅApAzAApAA  A=qAzAظRA  AڸRAzA  A(AAڏ\AffAڏ\ApA(AٮAAׅAׅAA(A
AՙAAӮAәA
A
Aҏ\AHAAzAffAHApAHAffAљAAGAӅAQAAAAӅA33AңAA{AAхAҏ\AAAzAAAAӅA
ApAәA
AӮAӮA
Aԏ\A=qAHAHAՅAՙA
AՙAGA33A(A=qAљAffAAAѮA
AQAAGAApAA\)A33AәAzA(AHAQAffA֏\AׅA֏\AָRAA  A{AzAGApAՙA\)A
A\)AӮAQAffAzA  A  AzAA(AңA{AzA
=ApAAҸRAffA  AңAAQA33A
A\)A{A(A  AAAAҏ\AzAHAAGAхAzAQAA(A33AУAиRA33AAAљA\)AхAAGAGAЏ\A=qA{AzAApAѮAљAffAхA33AA
A\)AGAA{AHA\)ApA{A  A
AApA  AffAHAA
=AAϮAzAУA(AA
=A=qAAиRAffAиRA(A  AQApAA
A
=AљA\)AѮAffA
AA(AHA
AGAffAAңAAҏ\A
=A\)AҸRAәAәAAӮAAӮAӮAA{A{AQA{AΏ\AʸRA\)AA\)AхAϮAA  A
=AzA  AHAңApAҏ\AQAffAzAҏ\AGAzA
AΣAffAљA(AҸRAffAQAӅA{AA
AָRA=qAffA  AAծA33AQAffA֏\AָRAAA\)A֏\A=qAיA֏\AQA33AAљAAGAՙA{AԣAffApAzA  A33AӅAAӅA(ApA\)ApA(A
=AAA=qA33AиRAzAAθRAAθRApAAGA33AAΏ\AΏ\A(A͙A=qA(A˙ApA˅ApA͙AGA˅A=qAApAffAхA=qAθRA  AzAAGA(AAHAGApAӅAffAAԣA
=A{AAA؏\AHAظRAAأAظRAzAHAAAGApA
AۙApAGAAڸRAzAۅApAGA33AAA
=AأAأAأAأAzAAzApAAAAA{AAzA=qA  AzAHAԏ\AQApAAЏ\A{A\)AϮAGAA=qAHAffApA=qAA
AẠAA̸RA͙AffAAzAHA  A  AAȀ\AA(A33A(A
AƏ\AA
AA\)AQA(A\)AQA{AGA{AHA˅ApA{AA̸RAθRA\)A33AAGAA
AGAAAzAУAA
=AθRAAѮAхAѮAHA\)ApA
=ApAΏ\Ȁ\AͮA33A\)AAAAffAΏ\AϮAffAΏ\AѮAхAQAљAθRA(A=qAAHA
A
=A(AAHA{A
A{AΏ\AQA\)AAA=qA{AffA{A(AυAffA(A{A=qA
AɮAȸRAǙA=qAəAAApAzA
=AA  AͮAAffAGAAA=qApAӮAzAAGA\)A
AՅAAApAA  AA
A
A{A(AծApApApAAAzAԸRA{AAAApA
=AA
=AzA=qA  A
A  A
A
AA\)AQA(AApAљA\)AAAAͅAAͮA
=AAAυAϙA33ApAffA(A͙A
AʸRA
A(A
=A\)ApAA(AGA
=AffAʸRAHA˙A{A(AGA33AHAˮA\)AʸRAʏ\A  AQAʸRA  ApApAǙA{ApA{A{AȣAzA{AQAGAHApAAΣAA
AGApAQApAHA
=Ȁ\AͮAͅAA̸RAGẠAHAffAAAAAGAGAA͙A\)AA
A(AͮApA33A
AͮA(A
A=qAƸRAQAffA
=AθRAAzAͅAzAA  A{A(AəAʣAAQAɮA(AɅAɅAɮAQAffAʣAzA
=AAA
=AA33ApAƣAA33A  AȸRA=qAA{A=qAQAA\)A=qAzA
=AAŮAGA33A
=A̸RAQAHA  A
=AGAA{AHAGA
AA˅A
AffAzAA  A{AGȀ\AApApAGAA͙A
A  A͙A
A{AAAͅAHA\)ApAAQAA˙AA
=AʸRAHAA˅AzA˙A(Aʏ\A\)A\)A33AɮAApAɅA(A33ApAQAffAA
A
AA(AHAHAGAƸRApAA=qA
AGA\)AzAʣAʏ\A
A
AˮA{AAGA33AʸRAHA33AȀ\Ȁ\AffA{Ȁ\A̸RAzA̸RAA
=AAHAAͮAA  AQAQAffAΏ\AffAffAΏ\AAHAA33A\)AυAϮA{AzAQAA
=A
=AHAA
=ApAffAθRAQA
AAA
AAffAA
A̸RA
=AQA  A  A33AȣAAǙAA  A(AɮAAGA
A  AQApA
AɮA
AAʸRAʣAAffAzA
=AzAHAθRAQA33A33A\)AˮA˙A=qAA
A=qA
=ApAGAAAϮA\)AA33AϮA
A33A  AQAAЏ\A(A  A  AAAAυAϙAGAυAυAA  A{AA  A{A  AAυAAϙApAυApAϙA33A\)A
=A(AGAθRAA=qA  A=qAA{AʣAffAͮAGAͅApA=qA  A{A=qAzAQAzAΣA  AQAΏ\A  A
=AffAHAAAθRAϙAϙAAA(A{AQAffẠAAGA\)A{A  AQAAΣAA33AυA  A=qAAAGAљA  AQAңAәA  AzAAA  AAՙAԏ\Aԏ\A33AQAffAzAծA
A=qA{AQA(AQA=qA\)AGAԸRA=qAAԏ\AԸRAQA
AAԣA\)AAӅA
ApAљAAA
=A(Aҏ\A  A\)A\)ApAGA\)AAхAѮA{A(AffAffA(Aҏ\AQAzA33A(A=qAҏ\AAGAAҸRAAApA\)AәAӅAApA=qAԏ\AԸRA
=AHA
=AA\)A  AA
=AՙAA  AՙAՅA(AffAQA
=AAffAAأAٮAٙAA=qApA33A\)A\)AA33AffAAAffA=qAAAffA
AָRAzA׮AHA{A{A֣AAzA֣A  A(AzA׮A=qA=qAApAA(AԣA
=AGA  A=qAzAԸRAGA\)Aԏ\AA\)AA
AAAAәA\)AGApApA
AԣAA\)AQAҏ\A(AυAGAՙAAՙAzA\)AA
A֏\AGAיA(AAA
AA{Aڏ\AڸRAHAڸRAffAGA؏\AׅA{A
ApAׅAׅA
=AAՙApAffAA(A
A=qA=qAA\)A(AffA=qAHA
=AхA  AffAzA  Aҏ\AA=qA  AHA(AAAHAAffAQA\)AA׮AzAzA\)AGAAAGAׅAQAAGAffA
=A֣AՅAәAAHAQA
=AA
=A33AApAzAָRAzA\)A\)A
A  A(A{AA33AԸRAՅA֣AׅA=qAظRAAظRAA(AAۅAAۮAzA(A(A=qAܣAܣAHA33AAApA
A\)A
A{A(A܏\A{AۮA\)AAAffAAGA܏\AAAAGAAQAAA{A=qAHAܣAܸRAzAܣA܏\AzApAQAHApAApA33A=qA
A
A
=AQAٙAGA
AAffAffA؏\A׮AHApAٮAA
A  AA(AffAffAzA=qAڣAAAۙA\)AQAQAGA݅AApA  A܏\A
=AA=qAܸRAܸRA\)AAGA߮AQAffAGAHA\A߮A
AQA\A=qAffAAARAffAᙚAApAAݙA߅AA
AݙApA\)A
=A܏\AGAAAݮA
ApA
A
=Aڏ\ApAأAAAQAzA
=ApA33A؏\A
A{AGAA{A(A{AڸRAzAzAAGA
=AظRA=qA(AApA(A  A  AAݙA=qA
=A\)AGAAA׮A
A\)AAHA33AA
=A33AݙA=qA=qAA{A=qA
=A{A
AA\)A{ARApApAAAQAߙAARAAAAAAᙚAA
AA
AHAffA(A
=A\AA  A߅AAA߅ApAQAzAAGAA܏\AAAA  AzA33A(A=qA\)AffAٮAܣAڣApAffA\)AٙAffAڏ\AA
AQAA݅AffAA\)AzAܸRA
=A\)A܏\A܏\A
=AAGAzAQAڣAAڣA
=Aڏ\ApAQA  A݅AޣA޸RA=qAHA߅AA{A=qAQA=qA=qA  AAffAHAQA
A33AAAAHA
=AzAAAAApA߅A
=AA{AۅAݙApAܣAAܸRAzA{AܸRAܸRAܸRA܏\A=qA(AffAffA  A(A
ApAۅAٮA(AAظRA33A
=AA  AApAأAA(A(A׮AA(AҸRA
A؏\AQAA=qAQAڸRA(AHA\)A(AQAظRA=qAA\)AAHAAأAffA\)A
A(AәA33A  AAAGA=qA
=AمAٙA{A  A=qAQAAA
=A
=A=qAڣA=qA(A  AHA{AڣA
=A\)AA\)AGA{A(ApAffA\)A=qA{AѮAGA=qAA33A33AAԏ\A
AHAΣA
AҸRA=qAAѮAA
AApA{AffAΣAffAzA{A͙A\)AHAθRA  A=qAA\)A  AAAљAљA
A(AGAffAAGA(A33A
AхA{AA=qAA˅ApAʸRAA̸RA˅A
=AAGAʏ\AAɅAAAQA
=ApAAУA\)A=qAHAAAAAAҸRA(AffAffAAхA\)AЏ\AffAхA\)AљA  AхApAffA
A(AAљAͅAApA=qAGApAA(A
=A  A(AAAϙA{AA33AA33AΏ\AGA  AA
AA
=AzAͮAθRAHA{AGA\)AzAΣA  AυAGAApA33AAzA  A{A̸RA͙AzA=qAzAA
AQAAхA=qAңA33AA  AzAAՅA
AA؏\A33AGAApAffAffAGAAGAׅApAׅAA֏\AzA
A\)A
=AGA  AAՙA\)AzApA{A{AѮA
=A=qApA33AңAљAQAҏ\A  AљA{AAAQA=qAәAQAљAQA{A(ApA  AAHAGA(A{A
A͙AAffȀ\AGA33AzAƸRAQAGAΣApAAHAҏ\AAAQA=qApA33AAҏ\AҸRAAҏ\AAzAҏ\AHAҏ\Aҏ\A\)A\)Aҏ\A=qAѮA  AңAA
=A\)AGAA  A{A  AӮAAHA  AQAA
=AApAA=qAѮAѮA  Aҏ\A(AΣAGAffA{AHA  AGAA(AffAΣApA
AAGA33ApAхA  AQAиRAЏ\AHA(AA33AGAӮAA
A=qAԏ\A(A{A{A=qA{A{A{A(AӅA\)AңAzA{A͙A{AͅAAəAHAͅAAQAzAHAA̸RA=qAͅAA(A=qAAHA
=A
=AϮAQAzAHAHAzA(AҸRA=qA  A=qA(AzAңAHA
=AGAGA\)A33A
=Aҏ\AzA(A{A(A=qA
AHAЏ\AѮAѮAGA{A33A
AQAQA=qA  AυA=qAΣAHAA=qAApA=qAQAzA\)A  AиRAУA=qAиRAAAѮAљA33AҸRAffA
=A\)AΣA\)A33A33AGA
A
A=qAAθRAHA(AθRAGAϙApAϮA
AApApA(AиRAApAхAљAAҏ\AAңAҸRAA\)A
A
A=qAffAԣAԏ\AApApApAAGAGAA{AffA\)AӮAӅAA33AңA  AѮAGAAͮA\)A{AffAGA  AѮA=qAHAffAQAffA
=AzAԸRAAGAՅApAՅAՅA33AԣAQAA33AӅAAՅAA33AՙA
=AffAAGAffAHAңAѮAA
AAA
A
=A{A  AυAυA
AzAGAGA33ApA\)AѮA33AѮAffAQA  ApApA=qAϙAAΏ\A
A33AGAΏ\AљAHA̸RAGA=qAffA
AQAGAzAѮAҸRAGA{A=qAӮA(A(AԣAGAӮAԏ\AԸRAHApAΣAffAGAAΏ\AA(A
AϙA{AQAУAHAA{AӅAffA\)A
A  A{A
AՙA
AՙAՅA\)Aԏ\A  A{AָRA33AׅA
=A
=AׅA(AAA(A  A
A׮ApA
=AָRAAAָRAָRAGAAffAՅA=qAGAHAGAAԏ\AzAGA
AԸRAffAffAzAУAAffAGAA(AϮAϙAQA
A=qA{AffApA
=AхAҏ\A  A
ApAQAQA
ApAͮA(A  Ȁ\AˮAzAA\)AHAA
=AffA33A
AAҸRAA(A\)A
=A  AAAAAHAA=qA=qA=qAәAAHAҸRAҸRAңAA\)A(AzAGAՅAAffA֏\AAGApAיA
AA33AHAGAffA֏\A
=AծAԸRAӅAAљAЏ\ApAzAυA=qAAAԸRAAHAAffA
=A  AGA\)AͮAЏ\AиRAzAA͙AAAхA=qA{A{A
=A=qAHAиRAЏ\AљA
A
AA  A=qAAAAHAAA
=A\)AA\)AӅA
AA33AzAHAffAffAffAҸRAͅA
=A=qA\)AѮAA(AΏ\AAzAθRAA{ẠAGAA{AGAΏ\AϙA
A{AЏ\A33ApA
AzAAAAҸRAҏ\Aҏ\AAҸRAҸRA33AGA\)AA
=A
=A
=AAHAҸRAAAAAAҸRAAңAAAA=qAҏ\Aҏ\A
=AA=qAzAϙAУA\)AAGAffAzAAzA͙A=qA\)AAQAA33AϮAA  A{AиRAAAхApApA33AAAA{AA33A\)A
=AGA
=AиRAУA(A
ApAϙAθRAAffA33AzȀ\ẠAHAAGApAA(AffAHA\)AυAυAЏ\A
=AAиRA
=AAиRAиRAHAA
=AA
=A
=A
=A
A(A
A=qAffAңA
=AҸRAHA
=A(A=qApAAA
=AA˙AQA(AA\)A(AϮA{AAģA  AA  AӮAңAzA{AAAGAЏ\AЏ\AΣAΣA\)AЏ\AAAυAθRAAGAffAυAѮAffAAffAAA
AΣAAУA
=A
=AQA=qA  AAəA
A˙AˮA=qAAffAffAAHA33A̸RAAΏ\A˅AͮȀ\A˙Ȁ\A̸RA\)AHAHAʣA
A=qAffAffAGA33A33AAzA˅A
=A=qAffAA
AʸRAˮAA33AGAAHA=qAA
Aҏ\AApAәAәAA  A{A(AA  ApAAGAA33AGA33AҸRAA=qAѮA
AffAHAңAҸRAңAңAA  A
A=qAA(A  A\)AAиRAA(AЏ\AffAQAGA
=AffAΣA
A\)ApA=qAGAͅA(AffAA=qA
A
=AΏ\AAΏ\AGAAQAzAffAzAQAʏ\AA(A˅AˮA˅A33AAQAGAGAA{A(AͮAAA
=AAGA  AˮA=qAA=qAΣAυAЏ\AQAGAHApA(A\)AA
=A=qA
A{AAA\)A
=A֏\AA\)AA
AӮA
=AAA  A\)AϙAAϙAϮApAϙAA
=AffAУAϙAQAϙAΣAΣAA(AυA\)AУAиRA
AυAϙA
AΣAAAApA(A̸RAGA͙AffA\)AA  ApAϙA
=A\)A(A(AzA
=A̸RA  A(AϮAυA  AAffAffA=qAA
A(A(A(A=qAHA  AхAAAԣAGAQA33A  AffAAAٙAٙAAGAA33A33AظRAAAAAHAA
A\)AظRAA(AمA
AzAffAA  AGAHAָRAAיAApAQAQAHAAGA33AAׅAׅAQAAָRAָRAAffAָRA֏\A֣AAQA=qApAAffA
A\)A  AAA͙A=qAAffAЏ\A\)AAУAAУA(AиRApAQAυApẠA(A33AAAzAffAЏ\AиRA{AиRA
AA
AԸRA  AQAՅA֣AAGA(A=qA{A
A=qAHAۙA
=AffAA  A{AٙAQAڸRAA
AHA
=A
=AA=qA
AٮAHA(AQAQAAffA33A{Aڏ\AzAzAA
A=qAۙAأAظRA\)A؏\A
=AAԸRA  AffAAӅA33AՅAA֣AAׅAAGA=qA=qAA33AʣAظRAAٮAHAHAAHA
=AffA33A=qA\)AۙAۙAHAGAQAffA33AAAApAA33A  A(AٙAQA
=AأA  AAAٙAمAAHAHAAAAQA=qA\)A
AGAA{AHA33A33A33A(AA=qA{AffAA{AGAGAGA֣AffA  AAAԏ\AA=qAиRAҏ\AGApAЏ\AљA
AAҸRAҏ\ApAA=qAθRAУAffAAΣA=qA
=AGA33AхApAzAQAffA
A
AЏ\A\)A(AЏ\AA{A33A
=AGAzA˙A(AˮA͙A  A̸RAϙAGAffAУA{AиRAҏ\AA
=AA\)AzA
AQAՅA{A  A=qA33AQApAzAApA=qAӅAәA{AHA  AGAA
AA{AԣA
ApAՙAGAHAәAAAffAиRAAхAAиRAAzAA
=AffAA{ApAAͅA  AffAAGA=qAͅAͅA
A\)A\)AͮA{AffA
AGAA  AΣAθRA33AυAA  AΣAffAУAиRAffAЏ\AHApA
AЏ\AљAAApAәA
A(AAGAAיAA{A  A\)A
AQAAۅA(AۅAۙA=qAڏ\AAQAAAڏ\A
AAA{A
ApAHA=qA=qAA֣A׮AAA  AծApAՅA(A
AQA{A
A  A  AAzAAAҏ\AхAGAAHA=qA(AAϙAzAHAͮAHApAGAQAAGAAGAɅAHA\)A
=AΏ\AAͅA  A
A\)AA  A\)Aԏ\A
AApAϙA(AAЏ\A=qA=qAAGAӅAAA(AԸRAԸRApA
AzAGA  AzAApAڣA{ApAAAܣAHAAܸRA(ApAۅA33AA=qAAffAffA  AٮAٮAGAGAGA(A
A֏\AAGApAA\)A\)A\)AمAApA(AffAzA=qAffA܏\AApA  A
=AffAHAzAHAGA{A֏\AA
A(A(A  AQAAGAAAzAGA33AӮAAԏ\AffAGA  A֣AGApA
AAQA
A33A=qA  A(A؏\AGAGAA\)A  AffAڏ\AڣAGAۮAQAzAޣAHA33AAzAQAffAffA33Aޏ\A(A{A݅AݙA\)A33AA܏\A{AzAzA{AۅAۮAڏ\AۮAffA܏\AA{AAAffA(A{A
AڣA  A\)A  AمA
=A
AHApAGA֏\ApA֣A(A33A
=AϮAѮAԣA=qAApAHAAA
=A{AAظRAՅApAzAAӮA  A֣A(AAQAA\)AAHAՙAՙA{AHA
=A33AׅAA=qAAHAA
=AۮA\)AQAAzA޸RA޸RAޏ\AA܏\AGAAڸRAffA(AA
AGAHA֏\AzApAיA֣AA=qAApA
=A
=A  AHA
=AظRA
AffA\)AGA(A33Aڏ\AڸRAA=qAՙAAA(AffAGAzAՅA
=A\)A\)A{AA(AHAAԣAHAGAGAAՅA=qAzA
=AzAA
AA(AzAԣA
=AԸRAAzA  AAGAӅAәAԸRAApAՙAAAQA  A  A{A  AzA
=AHAA33AA33A33AGAA֣AffA(ApAGAՙAApAՙAԸRAՙAAԸRAӮA
=AffAԸRA֣A֣AzAAәAAծAQAzA=qAffA{AAԸRAAAAԣAGAA
=AхAљA=qApA\)AzAΏ\A33AϙA33A=qAA{AˮAHAAffAAffAHA\)AAGAffA=qA(ApAυAиRAzAAҏ\ApA  AӅAffApAAAיA\)AA(AGAAAA
AA
=AׅApAיAGAAAָRAָRA؏\AHAA؏\AA
AיAHA=qAׅA
=AԸRA
=A  A  AՅAA֣AAA
A=qApAAԏ\Aԏ\A  AԸRAffAQAԣA{AQA
=AңA{A\)ApAHAGAzA{AθRAA
=AzA
=AAͮAΣA33A͙Aʏ\AAAApA
=A\)A͙AͅAΣAzA̸RẠA  A(ApApA  A\)A
=AA(A33AAA\)AAхAA  A
AAԣAGA  AAׅA\)AׅAApA\)A\)AA֣A֏\A֏\AָRA֣A֏\AָRAHAׅA׮AיA
=AAָRAA
=AzA{A(AzAQA֏\AָRAHAAHAffA֣A=qAQA(AffAzApAָRAAAәAҏ\AAAљA
AffA33AzAzApApAAӅAGAңAҏ\A=qAzApAA
=AӅAffA(AA
=A=qAѮA33AңAAՅA=qA(AAA  AA  A\)AzAAffA׮AׅAיA
=AGA
A(AzAHA33A
=AۮAHAHAٙAAظRAffA{A{AיAQAzA
AAٮAأA֏\A{A=qA
AA
=Aԏ\A33AQAGAzAGA\)AхAQA(AAGApA  A=qAљA=qAQAӮAAffAA
AAљA  A
=AQA
A33AҸRA{A=qA  AҸRA{A(AHA33A=qA(AA=qApA
=AәA\)A
AϮAApAAHAGAApAәAӮA{AQAԣAAԣAAA(AQA֏\A=qAAAGA33A
=AԸRA  AffApA\)A
AծAGAHAԣA{AffAffA33AљA
A  AхA\)A=qAffAҏ\A{AӅAӮAиRAGAzAGAAzAA33AAffA  A
A  A33A=qAzAӮAffA(A  AApA{A=qA
=AӅA(AAљA33AA33AͅA(ẠAAAAzAA(A33AAȀ\AA  AGA  ApAQA(A
=AA\)AAυAϮA(A{A
AQA  AA  AAQAAAAQA  A(AυApAAͅA=qAυAϙAAΏ\AGA
=AΣAHAυAυAAϙA(AA
AAAҸRAzA33ApA33Aҏ\AAиRA
AљAЏ\ApAA\)AGA
=AҸRAzA(A
=AHAHAљA=qA=qAGA
=A(ApAθRAAHA  AffAAθRA  A33A
=A
AиRA{AGA(A
ApAA  AA  A=qAA33AHAծA
AՅAHA{A33AGAәA
=AңAңAҏ\AGAУA(A
=AυAGAGA  AϮA33A{AA
AΣAGAϮAAΣA
AGAϙA
AffAAңA=qAApA\)AA33AљAУA  AGAͮAA=qAAHAA
AУAAQA{AGAυA  A{A33A  AHA͙ẠAApAGAHA
AAHAAAGAzA
A{ApẠAΣAApA(A{AˮA\)AљAϙA(A(A
AA(A
AӅAAApAAzAԏ\AzA{ApAәAәAQAQAzAffA=qAQAffAzAQA=qAҸRAffA{A
AffAffAѮA  AхAѮAAҏ\A=qA  A
A(AAAУAA33AGA(AAA33AAQA
=AHAУAљAHA=qAθRAAffA
Ȁ\AA{A
=AAHAŅAŮAAƏ\A
A̸RA̸RA\)A=qAA=qA{A=qAΣA33AffAHAͅAzA\)AϮAAˮA
AAҏ\A  AA(AЏ\A(A
AυA{ApAffAAљAffAҏ\AAՅA  AGA
=AGAָRA(AGAAָRA  AAAHAAAQA  A
AA
AGAAA{AָRA֣A֣AzAָRAAָRA֏\A֣A֣AָRAzAQA{ApAffAGApAAAΣAA=qAGAzAApA(A33AffAffAԸRA=qAAңA(AиRAУAQA{AиRAzAθRAΣA  AAAHA(AѮA  A=qAzA{Aԏ\AAAzA  AAzAָRAffA
=A33AGA
A  A=qAzAڸRAڏ\AQAڏ\AڣA
=AAۮAAۮAۙA(A܏\AffA  AܣAffAAܸRAܣAzA(AۙAۅAڸRAQA\)AأAA(A(A=qAҸRAAAHAظRA\)A(AAzAA=qA
=AffAAՅA(A
=AA=qAQA  AAAGAGAхA
A{AHAиRAffAffA(AθRA{A͙AȀ\AAA
AAffAHA
=AHAA=qA
=ApAԏ\AԣAԸRApApAffA\)AיAA(AffA=qA(AٙA\)AffA(A=qAAAApA33AGA
AffAzAQAHAQA(A  AAӅA  AHAӮAQAGA{A֣AGAGA׮A  AffAApAA\)AٙAA{A
A=qA=qAڣAHA\)AGAHAAAQAQA  A  A
AA(A=qAڏ\Aڏ\AzA=qAڣAAAzAָRAHAAHAָRAA
A=qAׅAAظRA33AffAzA=qAHA{A׮AظRA33AٙA=qAڣAڣA=qAzAA(AGA֣A33A33AGAָRApAԸRAHA
AAԏ\A
A(A  AGA  AAԣA\)AA33A
A֏\AAAApAׅA(AأAظRAHAظRAأA؏\A=qAظRAGAAAA؏\AffAffAA  A(A(A
A׮AA(A(A{A
AծA{ApA33A  AffAA33A33A
A=qAיAA\)A  A؏\AظRAAA33A\)AA{A(Aڏ\AڸRAAAHAGAA33AۅAۅAGAAA
=AڸRAڣAAAمAAA(A{AHAAAAٮAڏ\A{AffAQAمApAAzA  AffA
A
=AAGA
A
AQAڏ\A
=Aڏ\Aڏ\A33AGAAA\)A\)AۙAۙA(A=qAzAApAݙApA
AA=qA(A(A{A  A(AffAzAzAQA{AA
AݙAݮAAQA\)A=qAܸRAݙAAA=qAAAHA33A܏\A
AAܸRAAA33AHA=qA
A
AA\)AAיA{A
A(ApA
AA=qA(AיA(AA
AڸRApAApA{AܸRAۮAAAۅA  AܣAHAGAݮAݙA
A
AA
ApA
A
Aޏ\AffAA
AA
=AGApA\)AݮAHAܸRA=qAAzAܸRA܏\A\)AAۅAA33AۅA
AAHA=qA
=AٙAڏ\AAGAظRAzA=qA=qAAمAٙAمA  A
A
AAAQA
AمAAٮAڸRAۅApA
AA=qA\)A33A{AۙAۙAGA
=AzAffAQAGA  A֣AA\)AA{AQAٙA
A\)AָRAQA\)AAAAAffA\)AAAA=qA\)A(AQA
AGA
=AHA
=AGAA  A=qA
ApAׅAԏ\AљAQA˅AȸRAA
A{AQAAA\AGAA{AzAzAAAA  A
=A
A
=AffApAA=qAAAApAAA\AffA{ApA{A
=A33AAHA(AB
B
BBQB%ffB*{B,  B+zB-B/  B.B,\B+GB*B)HB%ffBpB(B(BBHB(B{B
BBB HARAA
ApA
AzA
AυA(AǙAQA
A=qAAGAARAA\AARA  AGAHA\A{AAHAQA(A{A{A{A{A(A(A(AQAffAffA=qA(A  AGA  AAÅAQA\)AϙApAA\A(ApBBRB=qBBzBBBBBBB
RB
HB\)BQBBBB
{B=qB	\)B\)BA\ARAA{A陚AAA  AڣA33AQAхA
=AAAAǅAffA\)AzAÙA\AAAzA
AAA
=A\AAA\)AAAQA(A=qA{A  AA  Aď\A
=AɮȀ\AϙAA֏\AߙA(AAAQAARBHB(B	
=BB=qBBBBHBQBBBBB\BBBBApA\A33AA
A{A
=A{AGAAظRAffA(A  A  A(AQAʸRA
=A\)AřA(A¸RA
AGAAAAzAAffA̸RAHAzAGAAApAGAHAA  A\A
=B{BB	  BBBB
=BBB33BB(B\)B(A{A\)AQAA
=AQA
ApAGA\)A33A͙A=qAǅA\)AÅA
AffA33A{A
=AA(AA  ARAAQApAHAAzAAARAAA
AffA
=AAAA
=AA
=AGAGAGA\)A{ApAAGA=qAHAAHAHAApAApAffAҸRAҏ\A\)AQA33AA  ApAHA֏\AA׮A{AAA
AHAٙAمAٮAA
AٮAGAQAzA=qA\)A
AA  A֣AGAffAGAGA
=Aԏ\A(A{Aԏ\Aԏ\A
=AffA  A(AՙA\)A  A
AAffAA=qAffAffA(AffAQA33AzA{AQAGA  AffAGAffA  ApA(A
Aҏ\AzA
=AQAAffAԣAApAA  AԣAӮA33A(AffAAAffA33AffAQAϮAHAffAθRA  A=qAAAңA  AHA
=AՙAיAGA(AׅAָRAA
=ApA  A(A=qA=qAzAظRAظRA
=A؏\AQAffA(A{AQAzA֏\AA
A(AՙA֣A֏\A=qAQApAGA{AAٙA33AظRAQA=qAA\)A33AGA׮AGAAAAHA33AzA=qA33ApAHA=qA\)AffAAׅApA{AffAAA  AأA֣A\)A33A֣AӅA\)A33AA
A33AٙAظRA{ApA{AأAAApAAffAQAzA\)A(AzA33ApA׮AGA33AAۮAܸRAAܣAܸRAA33AHA
=AHA݅AAAAA܏\AܣA
A
AAۅA
A\)AGAA33A33A\)AGAGApAGAۅA
=AA\)AۅAAAڸRAAA
A  AظRAٙAAHA׮AָRA
A(AAҏ\ApAAGAمAzA
AӅA\)AGAA
A(A
=ApAָRAՅAGA؏\ApA(AAمAAծAAAיAApAՅAԸRAԸRA
=A\)ApAՅAՅAA(AffA֣AAAAGAׅAGA
=AA
=A
=A֣AzA\)A(A{AծAAיAGA
=AA
AA=qAAzA؏\AأAظRAzA؏\AzAHAظRAظRA؏\AأA=qAQA(AәA  AzAzAӅAAGA33A33AGAָRA֣AzAA(A(AzAA{AأA=qA
=A{A=qAQA33AffAҏ\AffA(A  A(A֏\A{ApAָRA֣AA(AA{AיA\)AأAAAمAיAA
A؏\A(A{A؏\AAApApAAٮA=qA(AGAzAAQAQA\)AمApApA؏\AQA(A33A
=AׅA؏\AAAمAٮApAApAۙAQA33A܏\AApApAܣA
A  AA{A  A݅AffAA  AA
A\)AHAffA\)AGA=qAծA  AHAAffA33AA(AffA֏\A  AApAأAffA
=A\)A
=AظRA  A(AAffAGAܣAHAܸRAA
=A\)AAݙA܏\A؏\AأAיAAGAۅAffA܏\A(AA(AffAGAA(AQAޏ\Aޏ\Aޏ\AzAޏ\AffAA33AzA\)A(AzA  AHAffA
=A  AٮA  AAAffAQAzAAָRA
=A؏\A
A33AA\)ApA\)A  A
=AՙA  A  A=qA֏\A33AA
AHA=qAA
=ApApAأApAQAHAApAGAՙAծA  Aԏ\AHAԏ\AԸRAzApAAAAA
=Aԏ\A
AQAA׮AQAA33ApApA
AڣAۮAzAzAAGAHAAݙAA=qAޣAޣAHAAAzA{A(A  A  A
=A{A
A
AA
AݮA݅AzApA  AHAffA  AGA\)AAzAڣAGAڏ\AAGAمA\)A
=AffA(AffA  AָRAָRApA(AHAڸRAمAظRAffAzAzAQAأAQAHAA=qAffAzAיAA
AQAA
=A=qA=qAA  AQA=qAڏ\Aڏ\AڣA\)AAۅAAGAۙApAGA  AיAQAzAծA
AA
A  A(AAAApApAAיA  A{AAHAծA
=A=qAQA=qAԸRAA\)AԸRAA33AGAԸRAAԸRAAԸRApA33ApAA33AAAA(Aԏ\AԣAA\)A(AGA(AAA{A(AأA(AAظRA؏\AHA{AA
AGAAA(AQAA=qAԣAAAffA{A{ApAԸRAAՙAA  A\)ApA  A֣AA(A(AHAAأA  AHA33AzA
AAAAA\)A33AzAڏ\AA33AGA\)A
=A33A33A\)A33A33AA{A=qA\)AQAGAۮA
=A
=AۅAAAڣA
A(A
=AzA33A33AA
=AٙAGA؏\AffAAׅApA=qA(A33AAffAAGAׅA
AAӮA  A
=AAHApA=qA
A=qAzAԏ\AffAԸRA=qAԏ\A\)A֏\AA(AA֏\AQAffAQAzAָRAA33AGAAHA(AծAAGAAծAffAA׮AHA33A33AGAGAָRAAծApAffAffAAzAffA֣AHAA
A{AיA
A  AׅAיA\)AAAHAAָRAָRA\)AffAԸRA\)AGAҏ\A=qAA\)AHAA\)AGAHAҏ\A=qA  A{AAљAиRA
=A33A33A\)AѮA
A  A(AzAA
=AAңA=qA=qA  AѮAzAHAAAхAQA{ApAGAAAGAAУAHApA\)A33AңA=qAAAAAApA
AAAAA  AzAۅA=qAQAQA  A{AffAQAffAܣAAAAAܸRAHAܸRA33AQA܏\A
=AAA܏\AA{ApA(AAAۙA
=A=qAzAڏ\AAGA33AۮAA=qAمA
=A
AA{AGA\)AAԣAԸRApAԸRAA\)AAGAծA33ApAծA(A֏\A\)AԸRAffAA
=AAAAHAAA=qAՅAAծAծA
=AՅAGAGAGAՙAQA֏\AzA  A{A  AAA{A\)ApAA=qAffAAQA(AA؏\AA׮AGAAA
=AGAׅAׅAAAA\)AGA\)AGA\)AAffA{AأAٙA33A(AHAׅAׅAׅAԏ\AzAHA(AGAGA  AffA(ApAQA
=A33AԸRAҏ\AљAffAA
=A  A(AzAָRAGAAA  A\)AHAՙAҏ\A  A(AәAffA֏\AHA(AA\)A؏\A׮AGAQA\)A  AA33AӮAQAָRAA(A33A33AGA(A\)AظRAأAAHAظRAظRAظRAأAׅA33A33A{A{A=qA؏\A=qA
AAGAffA\)A=qAәAAՅAԸRA
A֣AיAA
=A֣A֣A֣A֏\AffAQA=qA  A{A  AAՅAՙAծA{AՙAՅAAHAхAA33AA
AAA
AHAGA
A  A\)AׅA=qA  A
A(AAffA=qA33AGAGApAA=qA
A{A{AAGAׅAGAQAAAAA=qAffAffAffAffAffA֣AAA\)A\)AGAיAיA  A=qAAظRAHAzA{AA
AAzAffAQAظRAQA׮ApApApA{A{AׅAzA\)AיAA=qAAיAՅA֏\A  ApA  AHAԸRAծAՙAՙApA{A֣AHApA֣AAHAָRA
=ApA  AA
=A
A{AיA֣AGAAffAA  A
AQAHAHA
=AׅAA=qAffAzA
=A(A
AHAA
AQA=qAAمA
=A\)AAzA\)AAGA
=ApApA\)AAffAffAA33AGAAHA  A  AHA33AAޏ\AHAޣAA݅A
AGAGAܸRAAܸRAA܏\AܸRAzAA(AA33ApAAAQAHA؏\AٮA֏\AHAA=qA(A
A
A33A֏\A{AڸRAۙAۙA؏\AA
=A׮AAAӅAٮAffA=qAٮAHAffApAمAGAQAffA33AA(AHAָRAA֣A  A33A
A׮AٮAQAA
=AffAٮAظRA\)AA
AffA  A\)AzAمAzAمAٙA(AٮA\)A33AGAAAGAQAA=qA(AAAڸRAQAAzAzApAQA  AA݅AޣAޏ\AzAffA(AޣA  A݅AAffA(AApAAA\)ApAӮAAԣA
=AAA=qAԏ\Aԏ\AAظRAA܏\AzAۮA
ApAffApAQA
A\)AA
A(AA(Aԏ\A
=AHA(ApA{A=qAָRA֣AzAQAffAԣAԸRAAA\)A  A֏\AָRAGA33A33AA33AGA\)A\)ApAׅAיApApA
A\)A؏\A(AHAA=qA
AA33A{AٙA{A\)ApAAAأAA33A
=AָRA
ApAHAхA33A  A
AӮAҏ\A\)AHA33A֣AQAAHAQAHAA(A
=A=qApAAffAхAAGAAAAA(AأAҸRAQAAиRAͅApA
=A(A{AzApA
=Aҏ\AA
A(AԣA
=AA=qAָRAA
=ApA  A(A؏\AAGApA  AHAڏ\AzAAAAA  AAAGAمAGAٙA=qAٮAAمAAمA33A\)AمApAAHAGAGAAGAA{A
=AָRA(A
ApAAAQAGA  A{AAffAظRAAظRAGAGA(A{AAGAQA\)ApApA33AQA(AA
=A
AAzA׮A֣A֏\ApA33A׮A
A(A
=A=qAՙAծA  ApA؏\A(A֏\ApAA{A(A(AأAA33ApAٙA
A  A  Aڏ\A(Aڏ\Aڏ\AۙA(A  AۅAڸRAzA=qApAۅA  A
ApApA=qAAGApAAAHAHAApApAمAمApAGAأAAׅAzA  AAGA
AHApA\)AA33AיAA׮AיA׮A
=AQAӮAՅAՙAHAAA33A  AՅAAzAA֣A
=AָRAAA\)AA  A؏\AAأA؏\AGApA33A
=AHA33AAzAAGApAA  Aڏ\A
=AGAffAffAܸRApA݅A\)AGAGAAGApAܸRAQA=qAHAzAQA(A  AAڸRApAAApAHAڣAAGAۙAۮAAA  AHA(AܸRAAAA33AGA  AzAܣA܏\AAA
=AA{AٮA
A  A
AٮAGA
AمAffAڏ\AAGAԸRAڸRAffAA(A
A
=A{AA33AٙAA=qAA  A׮AظRA֣A=qAffA֣AGA(AGAGAAٮApAٮA  AۮA
AA܏\AܣAzAffAA(AHA
=AۙA\)A
=AAڏ\AAܣA܏\A  A(A\)AA݅A
A(AffAffA  AٙAQAۙAA
=A
=A33AAA\)A݅ApAzApAzA  AffA(ApAA؏\AHAՅAGAՙAAffAҏ\A  AظRAٮA=qAzA؏\AAAAApAA
A
AA  AGA33AݙA(AA  AffAޣAޣAffAޣAzA33A(AۮAffAڣA  AA{A
AGAzA33AAڏ\A33ApAQAGAۮA  A  A\)AݙA޸RAAHApAݮAHApA  AA݅AzAޏ\A߅A߮Aޏ\AGA  AzAAޏ\AݙAAQA
=AAծA33A33Aڏ\A  A܏\A  AGAA(AۅAzAمA=qA{AGA=qAA{AA  AGA
=AAָRAHAAAGA{A=qAzAGAHAAҸRAAՅA֏\AzAQAأAHAzAAHAHAAڏ\AA
AApAA
AAGApA
A
=A
AҸRA=qAGAAA
Aҏ\AңAAzAHAAҸRAAҏ\A  Aҏ\Aҏ\A=qAAffAԏ\A{AҸRA{AՙA  A
=AظRA\)AׅAՅAԸRAA(A(A  AA{AA
AӅA\)AAzApA33Aԏ\Aԏ\AGA33Aҏ\AѮApApAѮA  A  A{A(A  AAҸRAҏ\AQAAffAӅA\)A  A{A=qAAAHA
=AHAAљAffAԣAԏ\AԣA=qAHAՙAՙAծAծA  A{A(A=qA=qAffAAAffA(AA
=AHA֏\AAffAՅAffAAծAAׅApApAԣAԣAA{A{AՙAAծAGAӅAHApAHAՅA
A33ApAffApAzAԸRAԏ\A
AծA֏\AAA
A
=AԣAA33AzA  AGAϮA
=AHAA\)AхA\)A{AAңAQAApA  AΣA=qAzAzA(A  A͙A33A  AΏ\AffAA
AθRA
=AGAzAzAHAAHA\)A  A{AHA(A֏\A\)AQA=qAAٮAٮAzAA33AۮA=qA(AHA=qA(A=qAA
A
AۮAۮAA
A\)ApAAمAمAAٮAA
A{AGAAA
ApAffAڣAڏ\AzA=qAGA؏\ApAGApApApA
=A  AA33ApAأAAծA(AָRAظRAApAٮAٙAٙA=qAָRA
=AffAAڸRAڣAffAAAظRA33A33A(A  A  AHAGAzAAԸRA  A
A{ApAAAAGA
=A؏\A\)A33AAA=qAffA݅AܸRAAA33A33AݮA݅ApA݅A\)ApApA݅ApA݅A݅A݅A݅ApApA݅AA݅ApA\)A\)A\)A\)A\)A\)A\)AA݅AݮAApAAAzAGA(A  A
AA(A
AڣAAمAAHAffAٙAA  A\)AمAمAAffAA{AHAٮA(AA
A  A
AAA=qAzAڏ\ApAظRA
AA  AAAA{AzA{AffAQAQA
AׅAظRAGAGA
AHAAA
A  AۮAAڏ\A33Aڏ\A(A  ApAAGA؏\AأAAffAA
=AۅA=qA=qAܣAA܏\AA{A  AAAAۮA  AۮAۅA{A(AA  A{A=qA  A{AAApAۮAA
ApAۅA\)AAAffA33ApApAۮA\)A33A33AAGAHAڣA  A  AAA=qA
=AApAAffAQAHAffA  AA(A(Aڏ\A\)A{AAݮAA(AffAޏ\AApA߮A  AzAA33ApAAᙚA
AA
AHA33AᙚAAAA\)AA33AA
=AᙚA
=A
=AߙAߙA޸RAޏ\AffA(A{Aޏ\AQA{AzAAAGA\)A\)A33A݅AGAAݙA33A  AA
AA
AۮAۅA{AA{A=qAffAA
AzAQAAHA(AGAܣA(A{A
=AڸRAA
AA{A  A=qAܸRAA33AAGAAAޣAzAQAzAޏ\A33AAߙA߮AA(AzAAAGAHAGAQAffAAAARA33A
=AAQAA\)A{ApA
A  AzAA=qA=qAzA\AzA=qAA(A  AQA=qA(AGAA=qA߅A(AAQAޏ\AAݮAzAA(AAGAᙚAHARA  A
=AAQAQApA{A=qAA\)A
A
A{A(AߙA\)A
=A(A
AffAA\)AޣA߮A
=AARA=qAHAA݅A\)AffAAQAٙAAڏ\AA  AAffAHAݮAAޏ\Aޏ\AޣAA
=A33AGA\)AHAޣA{AݙA݅AݮA  A݅AAAA(AۅAۙAAAڸRAAۮAAAA
A܏\A
=A33AzA33AݮAA
ApA
=A  A=qAGAAݙAAGAGA\)AA  A{AݙAzAݙA\)AApA33AHAffA=qAܸRA܏\AAAGAApAGA33AGA33AA݅A  A{AQA
=AA
A
=AۅA  AQAHA\)A(AApAA߅AA(AA\)A
AGAQA\AHAAffA{A
A  AApAA33A{AAGAffApAffA=qA=qAAA
A{AߙA33A=qAܣA
A  AzAߙAGAޣA
A  AzAA
AQA33A  A
AA؏\AAٙAAݮAܣAAAHA
A\)AׅAQAיAڸRAAٮAGAۙA{AHAܣA
A
ApA޸RAޣA(AAޏ\AGAA\)A
=AA=qAAA  AQA߅ApA߮A  A{A(ARARAApAA
A
A  AQA(AA
=AAAAzAQAA=qARAHA
=AA\A㙚A
=A
=A
ARA\)ARAGAHApARA
=AAzAߙA݅AٮApAܣAApAᙚAޏ\Aޏ\AܸRAffAAA֣AԣA(A
=A{A{AAA
AAޏ\A
AGA  ApAA{AHA(AffAA݅A  AAޣA33AGAߙAA
AQAۮAAffAܣA33ApA{A33A\)A{AQARAGA\)AA  AQAAAAffA
=A  AzA
A\)A
=ARAAA
ApApA(A  AᙚAᙚA  A  ApAᙚAAᙚA\)ApA\)A(AGAޏ\AGAffAݮAܸRAܣA  AAAQAڏ\AڸRAGAAA  AHA
AAәAHApAQAGAQAGAAٙAٙA33A\)AٙA  A؏\AQA=qAA33AAڏ\AQAڣA
=AGAۮAۅAzAA
AAܸRA{AA33A33AۮAAQAHAAAܸRAAݮA
AQAffAAA33AAߙA\)ApAGA\)AߙA{AAA  A{A  A(A߮A\A  A(A(A\)A޸RA{AݙAݙA33A=qAAQA  AGAܣAAGAٮAA  AݮAQAA  AHAGApAߙA(AQA{AܸRAzAڏ\AAۮAۅA(A33A(A݅AAڏ\A=qAHA  AQAڸRAffA{A֏\AԸRAӮAӮAԣAA{AӮAGA(A(A
A=qA=qAGAffA׮AՙAA
AAAظRAA
A  A  AA\)ApAzAAۙA=qAڸRA{AٮAAظRAzApAA֣A(A
=ApAՅApAzApAGAGA\)A
AՅAՅAAzAAAՙAAzAAӮA
AAՅAAA
A  AA33AׅAיAQAѮAzA=qAAHAA\)A{AиRAAHAAzAѮA{A{A=qAҏ\AGApAApAA(A=qAA
AAGAיAAQAA  A
=AڣAڏ\AڣAHA\)A
A(A܏\AffA{AzAAffAܸRA݅AAA(A{AAA܏\AffAܸRAܣAGAݙAffA\)AAHApA
A=qAApAۙAۙAۅAzAHAAQAAٙAHAzApAA33AQA33AծA=qAQAָRAzA֏\A\)AָRAzA
=AA  AA֣A
=AA׮AיA=qAAӮAׅAA
AGAA\)AQAAHA
AHAAffA(AAzAAٮAظRA
=A
A=qAٮA{AzAHA\)AAAzA܏\AܸRA
=AGApAGAA\)A33AܣAAHA݅A
AQA  A=qA(AffA(A
AAA=qA{AAAHAQA܏\AHA
=ApAA
=AHAܸRAܸRAܣAܣAGAAAAAAأA=qApAAܸRAzAHAܸRAܸRA  AffAAܸRA\)ApAՙAzAGAQA=qA
AA33AAffAAAޣA  AəA  AA
A=qA
=A
=AظRAApA\)AAffAڏ\Aڏ\Aڏ\AQA{A33A
AAGApAA=qAffApA  AAHAA  AzAGAمAGAAQAA֏\AיA֣AծA=qA\)A֣A=qAAՅA
A
A
=AԸRAApA  AA33AffA33AHAԏ\A(AәAӅA\)AA
=Aҏ\AzA33AAffA=qA
=AGAңA
AA
AHAAҸRAffAхA\)AHAљAѮA\)AQA
AԣA{A
AA=qA(Aԏ\AffAԸRAՙA(AzAAיAffAAAHAA
=AGAGAٮA  AQAڏ\AڣAzA=qAڣAffAAAA
A
A
AٮAzAڣAAAAzAffAffAAA׮AظRA{A{AQA
AיAA(AGA33AGA  ApApAAzAԏ\A{AAAQA
=AzA
=A33A\)AAָRA{A{Aԏ\ApA
=AԸRAAGA=qAGAAԏ\AffAGAԏ\AңA׮AGA֣AQA
=AӮA=qAԏ\AGA
A
A
A֣AGA׮A  AظRA
=AGAzAHA33AۙAۙA{A=qAzAܸRAAHAAݙApAGAHAGAHAA܏\A{A\)AHAA
=AAۅAHAܣA{A܏\AzAܣA=qA=qAA{AAۅAA33AGA=qAڸRAQA=qAffAٙAHA  AQAAGAظRAAGA׮AՙA֣AAAיAA׮AHAA\)AۙA
=A(A
AA33A֏\AԸRA(ApAzApAׅAGA
=A=qA\)A  AA=qA=qAمAٮAzA(AffAڣAzAQAQAܣAA\)AݙA
A  AAA33AHAAHAܸRA܏\AffA=qA(A{A  AA
AۮAۅA
AۮAAffAApAffAzAٮAٮAAQAAAڸRA{A=qAٮAمAٙAA
AA\)A{AمAGA
AAٙApA  AQAՅAәA  AAHA
=A  A=qA\)AٙAڣAA{A(AAffAGAGA
A׮AׅAHA\)ApA  AzAQAHAGA\)A  A=qAAHA݅A  AݮA  AQAޏ\AQA(AQAffAffAQAA=qA
A\)AAGA33A
A(AQAzAzAffApAA33AHA܏\A(A(AzAzA݅AۅAAAHAܸRAܸRAAAGA
AׅA֏\AQAGAӮA\)A=qAffA(AAGAңAA(A
=ApAAA{A
=AծAzAծA  A33AAԣAA׮AծA  AיAGAHAHAGApAA{AA֏\A  A{A(A33AA=qAA{AAٙA=qApAQAA݅A  A
=A(AAHAGA33AA{AGA
=AQApAHAA\)AQAzAA
AffA{A܏\AGA(A(A=qA=qAzA
=AܸRA݅A݅A{AAHAݮAGA
ApA  A܏\A܏\A
AAۮAAۙAڸRAAffAיA  AٙA{AHA؏\A  A׮AA
=AA
=A33AAQAѮAGAԸRAA  AԸRAQAAљAffAGAҏ\AиRAУAAA
=A(AA׮A  AzAzA=qAffAzAأAA
=AظRA{AAGAA׮A{A{AffA  AӅAffAӮAԸRAAAAApApAzA
A
=A(AffApA33A
AՙAָRAzA(A֏\AzAHAHA(A
=AՙAGA=qAՙA  AGA(A(AQA=qAՙA  AיA{A(AGAAأAzA  AA
=ApA33ApAGAffAٮAA=qA؏\A(AGAٙApA\)AA؏\A
=ApAGAHA{AzAAAڣAۅAۙAٙAQAAzApAٙAA(A\)A
AffAA\)AA؏\AQAAGA
=AHAHAQA(AffA=qA
AׅA(A\)A=qAA֏\AQAՅAAA
=AAәA(AԸRAԏ\A=qA
AffA=qAffA
AAԣA֏\AffAAHAԏ\Aԏ\AA(AHAԣAGAҏ\A(AzAԏ\Aԏ\Aԏ\AAHAԸRAԣAAApAGA\)A
AծAffA\)A=qA(AAQA(AHAظRAHA؏\AzAHAظRA  A=qAA
=AA
AffAGAݮA=qA=qA=qA(Aޏ\A=qA{A33AAܸRAGAA{A޸RA33A߮A
ARAffAzA(A  A
A
ARA33ApApAGA\ApAޣAGA
=AGAApA׮A=qAظRA33A֏\A֏\AApA=qAA֣A
AQAٙAAٙAQAٙA
Aڏ\AA\)A33A
=AHA33AHA33A\)AHAGAGAڸRAAڸRAAGA
AQA܏\AzAAܸRAݙAA  A(A
=A(A=qAA{Aڏ\AڸRAڣAHApA  AAGAAAAA\)A\)AAAA
=AA33A33AAAGA݅AݮAA  A  AAGA
A߮AHAA33A޸RAAܣA=qA=qA(AAA(AA  AAAAHAA{A  Aޏ\AA(AzA(AA\)A
=A
AApAGAߙAߙA\)AGA33AAGA{AA
AQA  AAGA(AA(A
AAGA؏\A؏\A
=AAAA{AQAHAٙAzAHAffA(AAffAڸRAڸRA=qAGA\)ApAծAՙA\)A(A֏\AQA=qAA  AָRAHAHAffAA
=AGAۙAۮAffAHAܸRA=qAٮAAGAzAٮAffA
A׮A33AffA{A׮AAffAA
AՅApAAzAQAA(AңAҏ\AffA  AУA(AУApA33AљAѮAљAAAAHAGAӅA33A  A=qA֏\AGA{AAA=qA
A  AffA
=AҸRAңA  Aԏ\AGAAAՙAAՙAՙAՙAՅAՙAA\)AGA\)AՙAծAՙAHA\)ApAAՅA(AָRA
=AAHAzAA(A  AffA=qA
A(ApA{AӮAzA  AA\)AHA  AAхAGA
=AAQApAzAҏ\AՅAffA\)AAAхAGA=qA  A33A
AՙAЏ\AͮA{A(AAzA  AϙAGAA
=A  AЏ\AхA\)AљA̸RA
=AAQAυAϮAͅAHAAffA33AAәAffAzAՅAA
AָRAA\)A
A=qAAAGA
=AAHA؏\A=qAAأAAzA֏\A֏\A33AָRAGA֏\A֣AGA(AA
A؏\AA33AمAAAمA\)AffAHAظRA֏\AיA
AffA׮A
AA֣A\)A؏\AׅAظRAԸRAՅAԏ\AQA=qAҏ\AAGA
A
=AAѮA{A(AͮA{AHAA(AA33AͅAffAffA
=AљAAҏ\A
=AQAHAԏ\AՅA
A
A
A֏\A33A
=A  AָRAA
AAAԸRA
=AAA  A֣A33AAיApAA(A=qA=qAzAzAffAأAأAffAיA
=A
=AffA
AיA(AظRAAA{A\)AۮA(AAأA33A\)AAיApAԏ\A{AԸRAڏ\AzAA׮A33A\)AԣAQA  AԣAӅAffA(AffAA33A{AffAQAٙAٮA{AGA33ApA=qAAAңAҏ\AA{AQAGA֏\AיAיAQAأA؏\A
A\)AיAA{AApA(ApAAAҏ\A\)A33A{Aԏ\AAAGA\)AՙAծA
A\)AGAA
AA  AzA\)AAAӮAծAffAGAGAAffA=qA؏\AAأAA\)AٙAAAٮA=qAڣA(AمApAمAأAA
A
AAԸRAAυAңAԸRAQApAՙAԸRA
=A(A=qA=qA
AHAA\)A=qAυA33A(AУAA{AA
AzAQAAAAffApA֏\AAA֏\A=qAA֣AQA=qApAծAAAAGAA(AHAAffA33A33AمA33AGApAٙAAA
AQA{A  A
AAHA=qA=qA(AAGAAzA(A  AA
=A\)AffA
=AHAzAffApAGA33A33AׅAיA{AzA  ApA33AAHAQA=qA(AָRA33AQAծA
A(A(AՙAGAԏ\AGAԏ\AծApA{AA(AffAAAA(A\)AAAGAAظRA{A
A
=A{A\)AffA33A=qA{AAHAffA
AGApA\)A
A(Aڏ\AۅAA{A=qA(AQAܸRAffAffAffAܣAܣAܸRAܣAܣAܣAHAAݮA݅AݙApA܏\AHA(AA݅AܸRAܸRAۮAApAۅA
A܏\AzAAHAۅAHA݅A
=AffAAAۮApAA\)A=qA܏\A܏\A܏\A܏\AܸRAAܣAffAAAAָRAAٙAffA\)AڣA
AQA
AApA
=A(AAAAHA
Aڏ\A؏\AأAAA݅AAڏ\ApAۮAGAzAޣA  AܸRAHA33AAzAAzAzAGA33AAGAA\)AAAHAGA߅A޸RA\)AGAAQAۙAAAAffAzA{A
=A
AأAffA
=AzAՙAAӮAzAzAAՅA֣ApA
AffAHApA{A
A\)AAϮAԸRAA=qAffAָRAՅAA
A=qAGApAA=qA޸RA޸RA=qA\)A\)AA\AffAݮAGA
AA{A(A(AAݮAApAAffAܣAܸRA܏\AA  AۙAۙAGA  AHAۙAڣA  ApAיA33AGAGAA\)A33A
A
=A
=AA  AGAۮAڣA
A  AיA{AzAAAHAAHA܏\AzAQA=qA  AHAAܸRA
AGAQAA֣AڸRAA33AA33A  AHAffA  A݅AۮAۅAzA{ApA=qA  A{AGA\)AHAAzAڏ\AAHAظRAzA׮AQAٮA
=AمAA
=A33AۅA\)AۅAGAۅAffA  AܸRAAܣAQAۮA
=AAݙA
AGAAffAAۮAۅA33AHAHAۅA33A
A=qA\)A(AܸRAAGAAffAGAffAAܸRA  AܣAzAHA  A
=A=qAAAأAAA  AzAA=qAAGA
=A(AHAٮA  A=qAәA
=AAffA؏\AGA  A  ApAڏ\ApAAA
A  A=qAQAGA\)ApAٙApAQAAAمAڸRA\)AGAٙAAՅAzAљAѮAA33A
=AA
AͮAA(ApA(A\)AģAA\)A33A(AzAARAAffA=qA=qAffA=qAAGA
AAAAAHARAA33AA\A\)AGAA\)A
=AQA
=AA
A(AQA\)AAAQAHAApAHAAGAA=qAA
=A  A\)A
AAAAA{AAAARA
AGAGAGAAAQAA¸RAAA{A33ARAAzAΣA
=A=qA(AApA  AffApA=qAA\)A=qAA
AffAA33AѮAAиRA
=AՅAA
=AAzA
=AAffAA  Aҏ\AՙAApA=qAAffAffAӅAzAхAzAҸRAͅAffA
=AAϙA  ApAӅAAҸRA33AQAҏ\AA  AәAffA  AQAљAхAApA33AzA˙AͅA̸RA\)AzA(ApAA  AA=qAԣAAѮA33AAхAAffAAAzA{AzAQA=qA
=ApAA(AHAAۙAA{A
Aڏ\AۅAA{AAٙAQAffAڸRA33A(Aڏ\AHAHAיAڸRAAQAGAҏ\AffAAA=qA
=A  A
A=qAQAAأAA=qA\)AHAٙApAԣApA
AAңA(A  AA33AϮA  AAAAAA\)AمAffAծAԏ\A=qA
=A  A  A33AAׅAAQA(AHAѮApApAЏ\A=qAA33AHAAӮAӅA
=A\)A(AӅAAAѮAzA
AծAHAظRAׅApAיAA
A\)AָRAGA؏\AQA
=AGAA
=A
A֣AٮAҸRA=qA33AA(Aԏ\AGA{A=qAAՅAGAQAAffA
AظRA(AzA(AAffA
=Aԏ\AffAA\)AӮApAиRAGAθRAAхA
A33A
AGAAffApAzAУAљAAA\)AffApA
AҸRA\)A\)AffApA=qAљAA(ApA{AAApAHA{AңAӅAԸRApA֣A{AHA{AڸRAAܣAܸRApAݙAݙApA33AA(AܸRA  AۮAۅAGA
=AHA33AڸRAۮA
A
AڸRA\)ApAHAApA  AٮA  A
=ApAٙA  A\)AՙAAԣAzA֏\AffAAA=qA؏\ApAA=qA
A{AApAՙA33A(AՅAׅAHApA
A=qAָRA֣AA
A  AAӅAAAAffAzA  A33AHAA
=AڸRAA؏\ApApAGAAA
AAڸRAQAzAGAA\)A33AGAAffAܸRA33A݅AA{Aޏ\AޣAޣAffAffA{ApAGAHA܏\A33AۅAڣAAGAܸRAHAA  A{AGAQA{AݮA=qA=qA  A\)AܣA33ApAzAAܸRA
=A=qA
=AQAAQAHAQA=qAHAAQAHAA(AAAA=qA=qA  A=qA
=A(A\)AУAffAA=qApApAAQA{AGAAA{A
=AA{A(ApAA=qAzAA\)AۮA
A  AQAAzAAHA
=ApA
A{A=qAzAޣAHAޣAzAQAޣA޸RAAݙAݙA(A
AA33AۙA33AڣAڸRA(AڸRAA
=AA33A
A  A=qAQApAA=qA(AQA܏\AzAٮA
AHA(ApAٮAAڏ\AffA
AffAzAffA  A=qAۅAffA܏\A܏\AQA{A
=A\)AׅAffA
A֣AHAӅA  AffAAGApAAHApAڸRAA؏\AأA(A(AA(A(A{AzApA\)A=qAA
=AۅApAA܏\AAGA\)AAA=qA=qA=qA=qA(A{AQAHAޏ\AAAߙA=qA=qAߙA  AGAzA\AA33AApA\A=qA
AAA
=AffAA݅AA  ApAݮAܸRAAffA\)AAܣAzA  AAA33AՅA֣AHAAQAܸRA=qA\)A33A\)AAHAQAGAzAAApA(AAׅA\)AۮAڏ\A=qAݙA݅AA  A
A
=A
AHAApAApAGAHA
AA(AߙAA{A  AffA=qAffAAHAA\A޸RA
A
Aڏ\AHA{A  A
A=qAGAׅA\)A֣AָRAיAA  A  AGA\)AיA֏\AHAA{A
A֣ApAGA
AQA{AAָRAA׮AA  AٮAAAA(AHA{AڣAQA33AzAٙAzA33A33AٙAHApA(AffA
AԸRA  Aԏ\AӅAGAңAAAңAA33A{Aҏ\AzAAzAأA  A
AHA=qA=qAޣAA
AffAQARA=qAHAAzA33AAAܣAAۅAڸRAQA{AٮApA
=AA
=A{AHA؏\A33AHAأAٮAٙA{A
AۮAۮAAHA(A
AٙAGApAHAQAA׮AA=qA33AzA(AGA  AAA=qA֏\A֣AffAA=qA  A33A=qAՙA\)AA(AәAӅAAzApAHA33AиRAAхAAGAAzAzAAУAυAѮAA  AGAԏ\AՅA(A֏\A֣AA=qAׅA=qAA=qApA  A  AzAGA
=AA؏\AأAzA\)A{A  A{A(A(A{A
A
AGAׅAAׅAׅAffA
AA֣A֣AיAA֣AffAٙAظRA
=A
=AAHAzApAA֣AzAGA{AAffAAӅA
=AAAәAҸRA  Aҏ\AQA=qA  A
=AffA33Aҏ\A\)A
A=qA
AGA\)ApAGA=qAzAӅA  AA=qApAA(AϮA(AAGAхAA
=AA
=A\)AAԏ\AA
=AGAՅAՙA(A{A(A=qAffAA֣A֏\AA33AHA
AffA
=AׅAיAA\)AׅA33AGAAHAׅAGAHAzAAׅAAGAffAQApA  A؏\AAׅAGAGA
=AיA֣AָRA=qA
A
AՙApAԸRAҸRA
A
AθRAAAApApAzAA
A֣A=qA
Aԏ\AӅAԸRAԏ\AGAAծAQAGAיApA33AAGAAGA=qA33AGAffAA
AٙA(ApAAAAzAأAظRA=qA{ApA
ApAAׅA׮AׅA\)AGA\)A33ApAׅAA(A
A
A׮A33AQAׅA\)AָRA֣AffA(AHApA  AA{AHAA33A(AՅAՙAAՅAGAAA=qAԏ\AԣAծAA{A(A\)AӅAAҸRA=qAAzApA
A(A
=ApA{A33A
A
Aԏ\AәA\)ApAA(AA  AAԏ\AQA(ApA  AffAQAәAzAAA{A(A֏\AHA
=A
A=qAQA֣AApA\)AAAHAQA(A(AծAA  AAffAׅA֏\ApAׅA
A  AAzAzAAAAGAApA33A(AA(ApAAffAԣAׅAHAHA33A  AAԏ\AAHA  A=qA=qAQAffAGA\)AA33AAѮA  AAGA  AA  AיAָRAA
=A\)AGA֏\AGAHA\)A
AיAAׅA
=AיAAffAAՅAՙApA{A{AЏ\AGA  A\)A{Aҏ\AҸRAffAHAzAffAQA
AӮAA(A{A{A{A  A
AԸRAffAHAAAffAApAGA  AApA\)AA֣A(AAQA  A
AAՙAծAA
A33AHAHAffApAA=qAAGAAAхA  A{AA
A33AљA33AAGAffAA
=ApAHAӮAzAAՙAzAGAָRA
A\)A(A֣A
AԸRA
A
=AAQA  A  A  AԸRAՙA
ApA
AՙAծAA=qAffApAԸRAAA\)AՙAծAA\)A  A{AծA(AծA=qA
AQAzA֏\AzAA֣A׮A33A֏\AzAGAGAGAיAAAAAzAHAQA\)A{AA
=AffAңAӮAAӅAAѮA  A(A  A\)AҸRA{AљA{AΣA  AA\)A\)A33A33A\)AHAϙAHApA  AϮA{AϙAffAЏ\A33AʸRApAA
AA{A  AA33A{AA(A33A  AffAڣA
=A
=AAAٮAAٮAGAمA  AQAzAzA(A
AApApAA؏\AGAGAGA33AAHA
=Aڏ\AGAA
=ApAA33A(A
ApA֏\AzAA(AՙA
A
=AzAAԏ\A
=A\)A(AAAׅAA֣AՙAAA  AQA
=A
=AffAՙA
A
AԣAAA\)AGAQAA33AAAHAA{A33ApAAGAָRA֣AԣAHA  A\)AAָRA֣A=qA=qA
AՙApAzA33ApA
AQAAٙAQAA=qA  AAA  AAٙAA{A  A  AHA(A{A
AA{A
AA=qAٮAAٮAHA
=AGApAٙAٙAمAمAffAQAڣA  AAAQAHA  ApA
AGAQAAظRAA
A
Aڏ\A{A\)AGA=qAGA33AAAA
=AA33AAظRA(AٮAظRAQAQAأApAծA  A  A
A(AAzA
=AיAA
=AA֣AHAffA֣AָRAָRAA
=ApAQA=qAظRAHAA
AٮAA
ApAمA
A
AمAA
=ApAٮA  A(A  A  AمAGAQAיAA
AAAمAffA  ApAׅA׮A֣A֏\AApAAA
AAԣAՙAAAAAAzApAӮA
=AzA{AՅAGA{AA
AA{ApAA(A=qAAzAzAׅAffAA֏\A׮A֣AHAظRAApAGAՅA
=AHA
=AffAңAA{ApAQAԏ\AGAՙAA  AffAAGAA֣A
=AAGApA\)AHA
=AAָRA
=A
A=qAffAAGAAGAGA\)AQAAzA  AمAGAffAAA33AHAծAA
=A{Aҏ\AffAәAӅA{AA  AHAՙAָRAՅAHAGA33AՅA33AA  AӅAAҸRAA33AAzA(AљA(AAѮA(A  AffA=qAҸRA{AAffAQAHAQAHAHA{A33AAѮAzAzAffAA(A  AffA  AzAHApA׮A  AffAA׮AffAffA(AA(A
A
AA׮A
=AָRA{A\)A=qApAHA=qA(A
AAׅAHAQAՙAՙAAָRAӅAӅApAQAffA  ApAAA֣ApA  AAAљAGAQAQAAͮA33A
AA=qAυẠA  A33AυA=qApAGAAffAAA(ApAAׅA(AظRA
AׅAיAAAGAAGA(AffA
=A
A  AAׅA=qA\)A\)AָRAAA؏\AApAمA؏\AA33A\)AHAQA\)A
AAAzA{AәAӅA\)AzAQAzA\)A׮A33AA33A
=AأA{A(A(A
A
A=qAzAzAHAظRA
=AأAAGAA(AHAffAA\)ApA(AѮAҏ\AGA
=AУA  A
=A
=AffAHA(A\)A(A
AQAzAָRAAAׅAQAffAAׅAA
AHA؏\A(AAA  A33A؏\AمAzAڸRAڸRAڣAQA  AA
A=qAڣA
=A\)AۙAۅApA
AffAzA(A
A{A33A33A
AڸRAڏ\AAۮAAۮAۅA\)AAAA
AٙAGAAA
=AAظRA؏\AffAffAQA=qAQA=qA=qAffAffA=qAffAׅA֏\A  A(AAA{A
AՙA{A(A(A(Aԏ\A
=A  AҸRA33AӅA  A=qAԏ\Aԏ\AzAAԸRAA  AԸRAԏ\AAA{AffA֣A֣AָRA֣AHAGAAGApA{AzAظRA
=ApAGA\)AGAGAHAA=qAQAzAHAظRA׮AzAQA
=ApA
=AAָRA  ApA
=AԣA(A  A33AzA\)AHAׅAׅA׮AQA
A=qAQA=qA{A\)AծAAԸRA
AAӅAQAӮAGAӅA
=AA  AHA33AA  A33AՅAԸRA33A{A\)AԸRAffAffAffAAA33AGApA=qAAՙAԏ\A{AA  AԸRAzA(AzAAՅA\)AGAՙAQAA(AأA=qA  A{AAHAHAظRAffAzA؏\AzA؏\A؏\AׅAׅA׮AGAָRA֣AAA33AffA֣AQA{AׅA33AA33A33AA׮A(A
A֣AAzA(A  A֣AAGAGA\)AAָRAAGAA\)AԣAQA=qA{AffAәA  AӮA=qAHAAQA  A(AA{A
=A
AAHAӅAQAffAԣApApAAA{AңAHA
=AҸRA  AәAԸRA
=AA\)AA  AffAՅAzAAHA׮A33ApAָRA\)A33AљA33AиRAApAυAϙApApAzAAϙAffAQAAzAHAGA
=A33AΏ\AHAϮAHAυA\)AHAиRAУA  AHAA(AGAAУAЏ\AHA(A
=A  A  AӅA{AGApAQAAffAљA(A  AAQAңAԸRA\)Aԏ\AԣA
=AAHAHAA
AѮAzAAApAԸRA
=Aԏ\A=qA{AԸRAApA  A=qAָRApAָRA
Aԏ\AzAzA{AAAծA=qA֣AHA
=A33AGApAיAffAQAظRAffA=qA{A=qA{AQAׅAָRAffAQAQA(A33A
=AԣAՅA
=A(A֏\AAQA  A=qAHAAAGAҏ\A33ApA\)Aҏ\A(A(A{A\)AHAҏ\A=qAAхA\)AHAzAzA(AA  AzAиRA
=AЏ\AA
=AAAHAQAzA=qA(AAAУA  AzAAхA=qAAffA  A33AәAҸRA=qAHA
=AzA
=AәAQAGA\)A=qA
AծA\)AGA  AzA{A(A{A{A  AԸRAffAԏ\AzAAzA(AԸRAHA33A
AGAffAәAzAԣAAHA{A(A=qAӮAAҸRA=qA=qAԣA=qAzAѮAхAQAAңAҏ\A
=AңAAQA=qAҏ\AAҸRAffAҏ\AAHAffAҸRA
=AљApAУAУAAAϮAAHA͙AGA(AϙAљAAzAzAQAϙAHAA
=A(A(AУA
AQA=qA=qAGAϮA\)AѮAхA(A(Aҏ\AӅA33AәA(A=qA  ApAAAAҸRAAAңAffAҸRAҏ\AӮAAҏ\ApAAGAAA\)AA  AffA  AәAffAQAхAхApAиRAУAиRAAхAиRAGApAGA{AҸRA{AAQAQA=qAAzA
=AυAffA{A͙A=qAzAQAAQAȀ\AA˙A\)A\)A33ẠAͅAGA
A
AУAAQAQAѮAA
=AAzAӅA=qAәA33AGAApA\)A
A
=A  AzAQAָRAAA33AGAGA\)AGAA  AծAA(AA  A  AՙAAәAԸRA\)A\)AA֣A֏\A(A{AffAA(A=qA֏\A֏\A֣A\)A  A  A
A=qAzAA{A{A
AծAA
AA  A
AՅAՅA
=AGA33AGAAAHApAԏ\AAQA33AӅAQA
A(AңA{AAҏ\AӅA  A(AӮAffAQAAAԸRAҸRA33A
A
AәA
A(A=qAA{A  A=qA
A
=A؏\AffAAAAffAApAA
=AHAHAָRA֏\A֣AAzAffA֏\AAAAָRAAHAA֣A֣A֏\A֣AHAHA֣AAHAָRAָRAA֣AAAAAA33AA
=AУA  AAAHAAA֣A=qAԸRA33AA
=AAffAәAӮA
=AAHA  A(AAӅA  ApAԣA  AQAԸRAԣAHAGAծA
AAAՅA=qAQAzAffA֏\A֣AQAAAA
=A\)AՙAAAAԣAԣAGA
=AffAAAәAAӅAAAԣAծA
AծAAA33AՙA
ApAApAGA33A33AAAHAffAQA
=AAAffAԏ\AԣAԸRAԸRAAAӮAAԏ\AԣAԏ\AHAGAQApAAԸRAzAԸRAҏ\A(A33AңAӮAA=qAzAffApA=qA  AљA  AA
AҸRA33A
=A  AffA\)A  AHA33AיAAQAظRAAGApAٙAA(AffA{AA33A\)A\)AAAڸRAAHAAGA؏\AffA׮A
=AzA(AٮAGAGAمA\)AأAQAأAQA
=A33AzA
A
AיAApA֏\A֏\A
=A\)A
=A33AQAAA(A
AQAAQA  AffAAHAՙAAԸRA
=A{AffAAzAѮAυAGAffA(AљAA=qApA
AңApAQAQAQA  AGAәA(A(A
ApAAՙAGAzAHA33Aԏ\A=qAAffA=qA
AәApA33AәA{A{A\)A\)AApAAGAәA
=A\)AӮA\)AffAHA
AA(AQAzAGA=qAϮAzA=qApAAӮAHAиRApAͅAϮAϮAQAϙAAAAϙA{A(AA  A(AAffAffAʏ\AͮȀ\A=qA=qA{AʣA  AΏ\AȀ\A{A̸RA
AΏ\AΣAΣApA=qA{A{AAЏ\AЏ\AQA
=AЏ\AA33AQAzAA
A33AAљA
A  A33AәAҸRAAA33AAѮA
AңAAGAӅAGAAиRAzAҸRAHAHAAңAAAAAAAHA(AљAQAAHA  AHA\)AzA
AӅAzAzAAAиRA
=AQAљAAHAҸRA
AAAљA33AQAQA(AA
AӮA\)Aҏ\A33AҸRAхA(AzApAҏ\A=qAGA  AffAAzAԸRAӮAA=qA\)AAAffA{A{A
AAGAӅAAѮA
=AA{AQAffAҏ\AAҸRAAHA
=AA33AGA(AӮAGA33AGAӮA
AGAApAծAffA=qApAGAAQAӅApA{AAGAHAHAGAQAffAffAGAՅApAAAAՙAՅAՅAՅAՅAՅApA
=A(A=qApAAGA(AԣA{AAffAңA
AQA
A
AHAӅAA
A=qAffAApA\)ApAAڣAAGA\)AAGA33AHAAԣA=qAAQAzAHAffA
AϮAAΣAA
=A33A33AGApApApAυAϮA=qApAхAAA33A\)AA33AљA
AљAA\)AҸRAzAңA\)A  A=qA\)A33AAHAHAHA\)AAffApA
AAzAQAzAzAAҸRAҏ\AAәAA\)AӅAGAҸRA33AԣAzA(AA\)AՙAӅAHAffAA  A\)AAA
AffAԸRApAՅAAA
=A
=A
A{A=qA=qAffA{AA=qAՙA(A  A33AzAffA{A{A=qA=qA=qA=qAzAԣAԏ\AzAԏ\AԸRAAԸRA33A33A{A(AԣA=qAA
A  AAAGA33AApAՙAzA
=AծAծAAԏ\A(A
=AԸRAӮApAӅAәAӮA=qA
AQAӮA{AԣAA33AՅAApAQA֣A=qA=qAQAAՙA  A=qA{A{A  AAծAծA
A
A{ApAՅA{AQAffA֏\AA
=AHAHAGA׮AׅAQApAA֣AQAָRA
=AGAָRAAAAAA(AأA؏\AA
AApApA
AAمAٙApAA\)AAمA\)AA؏\A
AffApApA33AHAۅAAAAۙAۙA{AۮAۮAۙAHAمAzAffAGAGAAA{AA=qA33AڸRAڸRAffAٙAڏ\AzA
A(AAمAA{A{AA{AA  A  AAٮApApAمAHAGAծAHA(A\)A{A֣ApA(A(AأA
A؏\AأA؏\A33AHA=qAأAzA(AظRAffAffAأAA33A{A{AAڣAAzAAڸRAAA
=AzAڸRAAAA\)A\)A\)AGAGAGA܏\A
A33AGAۅAAA
A  AA
A
AGAAzAۅAGAۅAHA\)A(A(AظRA
=AיAأA{AAA؏\A(AA\)AA
=A\)AAٙA
=AAzAծA  A33A  AAA׮AظRA\)ApAAHAׅAظRApAQAڏ\AڸRAQA  AڣAAׅAָRAAGAAԣA  AәA{AԣAHA33AA
A(AzAAۮA=qA33A  A33AA33A33A\)Aڏ\AڣApA
AffAA
A{A=qAQA(A33A=qAAۅA\)A(AٙAأAׅA؏\AיA
AAHAQAA(AAAffAأA{AApA33AٮAffAAAA
=A
=AA33A=qA
AظRAAٙA(A33AAHAׅAffA\)A
=AAHA\)AٙA33A؏\AHA׮A\)A(AAHAAأAAمAڏ\AAA=qA(AzAڣAAGAGAAڣAڸRAzAڸRAzA(AڸRAAAڏ\AAۅApAAAHA33AAAAA
=AA33AڸRAAGAڣA{Aڏ\AHApAGA33AڣAڸRAApA\)ApAۅA{AQApAڸRAڣAڣAڏ\A
=AAAAAAzA
AAAڸRAffAڣAAQA\)AGA33AAمAA(AۅAAffAAAۮAۅAHAۮAAAHAA{A  AzAAAzAHA33A\)ApApAۮAAۅAA\)AAڣAڏ\AAڏ\AffAAHAAۅA33A=qAffAQAڏ\A=qAڸRAAAAA
=AAڸRAڸRAڸRAڸRAڸRAzAڏ\Aڏ\Aڏ\AAffAAڣA=qA
=AۮAQAAHAzAA(AA
AׅA\)A=qA=qAffAAծAGA\)AՙA  A{AGA  AzAAAHAمAzA
AA\)A  Aڏ\Aڏ\A33AٮA  AAظRAAffAأAAٙA  AffA  AQAAA(A=qAA  AٮA
=A(ApA  A؏\AA\)AمA(A  A  AffA  AApAA33A(A
A׮AיApAAApA֏\AָRAA
=A=qAՅAApA\)AzAHA
=A33AԣAA\)AAGAՅA(AHAԏ\AAffAffAԸRAAAGAffAӅA{AԸRApAAיAA  AA  AffAظRAGAA\)AظRA{AיAA  ApAQA  AA=qA{AӮA{A=qAԸRAQAՅAA׮ApAGA\)AAAA׮AA׮A׮A
=A
A=qAAAՅAA33A\)AծAՙAծAAAAծAՙAծAQAA
AAՙAAAծAծAA
AծAAՅAAՅAՅAԏ\A33A=qA  AңAGAУAиRA{AHAAApA{AzAffAAAzAӅApAAA
A  AҸRAѮAzAQA  AѮAУAA{AAѮA
=AApAQAHAљAAAҏ\AA=qAљAA33AӅAzAԏ\AԸRAAәAA
AA=qA{A\)AAzAҏ\AffAAѮAAffAffA  AҸRAҸRA
=AAңAHApApAAQA=qA
A  AиRAAGAAA
=AA  AϮApA(A͙AAθRAQAУAQAHAAϮApA=qAЏ\AЏ\AиRAиRAffAzAffA(AυAϮAυA\)AAGAϙApAAA33AffAffAHAиRApA  AϮAУAHA
AA
=AAGAA
=AQA33AHAԏ\AA33A
A{A33AՅAԣAffA\)AԸRA
Aԏ\A  AzA\)AGA33AffAA=qAԏ\AӮA=qA
AA{AәAҸRA=qA(A
A
AхAAхAGAљAffAAAЏ\AQAHA(AGAʏ\AͮA
A(AA
=Ȁ\ApȀ\AAиRAAA(ApAϙAA  ApAA
AffA{AQAA  AAffAԣA(A=qAAGA
=A\)A  A  AA  AԣA(AQApAљA(A\)AHA
=AAAӅAхAϙAиRAҏ\AиRA{A{AAffAffAAAA(A{Aҏ\AzAAAAAHAӅAӮAQAәAGA\)A33AAAԸRA(Aҏ\AхAҏ\A
=A֏\A=qA\)AGAGA  AңAAAA\)AA
=AA\)Aҏ\AϙAϙAAθRAAϙAQA  ApAA=qAͅA33A(AA
=A\)AυA\)A
AAΏ\A{AA
AzAGAϙAAѮA\)A
A=qA(AУA=qAffAЏ\AЏ\AЏ\AHAхAAffAffAҸRA=qAυAυAͮAυA33A33ApAAѮA=qAQA  AGAхA  A33AA
=Aҏ\Aҏ\AffA=qA
=AҸRAϙAˮA
ApA  AAApApA=qA{AffA\)AʸRA=qA{AGA{AəA(A=qA\)AA\)AHA(AAzA˅AA(AA=qAəA˙AApA=qA(AA͙AAʏ\A\)ApA  A(A=qAɮAA
=AƏ\AƣApAQAȣAzAA
=A̸RA=qApAͅAͮA=qAθRAθRA
AQAffA
=ApA33ApAHAУA\)A͙A˙AAA\)AffA{AffA
A
AApApAzAAAGA33ApA=qApAҏ\AϮAAЏ\AAʏ\AAffA
AGAǮA
AAffAA
AffAƸRAHA33AAQAŅAGAHAAǅA33AzAffA(A=qAAȣAQAA\)AʣA
Ȁ\A
AGAA\)AʸRA(A  A{ApAȸRA\)AɮA
A=qAɅAȣAȣA(AəApAA
AͅAAffAĸRA(AA{A  AA=qAAŮAǅApA=qAzA{AƏ\A33AQAA
AQA
AA{AHAAͮA(AQAAQA̸RAA
=AGAA33AəA
AƸRA  AAŅA  A
AřA  A{AAǙApAĸRAģAAAřA£A=qAzA£AÅApA  AQA\)A
=A͙AˮAʏ\A
=AAffApA  A  A{AȸRA  A33A  A(A
ApA=qAˮAA(AA\)A˙A
AAʸRA
=A˙AffAQApAHAA  A  AυAAϮAA(AA  A
A{AAAѮA
=AυA
AΏ\AAA33A33AхApA
=A  AAȸRAẠȀ\AϮAAHAΣAA\)AA=qA˅A
A\)A
A33AGAʸRAzAQA33AʣA=qA
AzAffA
=AAHAffA
A
=AAɅAAffA  Aȏ\AffAQA\)AGA(AffAˮAzA(A33AAGAzAQAQAЏ\A{A  AHAffAzApA{AffA
AAQA(A{A\)A=qA
A33AəAAȸRAA
AA
ApA
AzAGA(ApAʣAA˙Ȁ\AȸRAGAAA{AȣAHA˙AɮA
AȸRAʏ\AA(AQAAffA33AQA
AƸRAQA
A
AŮAřAA
AǅA\)AGAAA\)A˙A{AΏ\AAGAѮA  AəAA
A33A̸RAzA  AGA
=ApAәAA  A  AffA{AQAθRA33ApAAffA{A33A
=AffAzA=qA=qA˅AGA=qA\)AGAffAƏ\A  AGA=qAAȣAQA33AϮAGA
AA
A{AHAffAΏ\A33A{A  A
=AAθRA{AȀ\AGA  AQAυAϮAAθRAͅAHA̸RA
=A33AzAAGAHAGA33AAϮA  AzAAυAͮA33AɅȀ\AQAzAGA{A
AA\)A  AхA  A=qA
=A33A=qAAGAAzAGA
AHAƏ\AAGA{A(AGAA
A
AHA
=A(AAȣA
AʸRA
=AQA(AAGA͙A(A˅A\)AAzA=qAAzAAGAȀ\A
A(AAffAGApAAǅA33A{AəAA=qAʏ\A  A̸RA(ApAHA{AzAθRAA(A
A
A\)AʸRAHAHAȣA{AǮAAffAAA{AAƏ\AA  AA{AA
A\)A
=AẠAϙApA
A̸RAffAHA(AA
=AzAυA˅AzAzAHA  A{A33AzAHA\)A  AzA͙A{AA
A\)A{AAΏ\AΣAffA
A33AHA(AA33AA  AУAffAzAffAУAиRAϙApAʣA=qAθRA(A33AA{AΏ\AθRAGA
AAA(Ȁ\A  A
AQAA˅A
=AA33Ȁ\A\)A=qApA˙ẠA
AA
AA=qAиRAУAffAzAAGAzAȸRA33ẠAQA(A(A˙ApAA
AzA33AHAθRAУAQAffA
=ApAffA
=A=qAAΏ\AA=qAA{A{A͙AθRA33Ȁ\Ȁ\A=qẠAHAGAGA
AAͅAGAͮA
A͙AA{A{A  AffAQA
A͙AͮAͮA
=AzAAzAA(AA(ApA=qA=qA  Aȏ\AAǙAǙAHA\)A33A
=AƸRAAzA=qAA33AQA33A(AGAHAA
=AˮA
A
AA=qA(AQȀ\AzẠẠA̸RAͅA  A(AɅA\)A=qAəA\)AApAHA=qAAHA̸RAHA=qA{AffA\)A(AffA
A=qA\)AzAGA
=AAϮAGAA(A  A  AAAAHAA
AУAffAхAѮA(AA=qA{A  AљA{AGA33A\)AGAљAGAϮAA=qApA\)A  AиRAzA33AA=qAAAA  AApAffA(A
A=qAQAQAffAGA33AA͙AAAzAAϮAHAAхAљAGAGAљA  AQAAУAffAGAAHAхAffAҏ\A=qAAffAA\)A=qA
A=qAAԣA\)A
A\)AAHA  AQA  A(AծAApApApAיApA{A33AHAHAָRA  A
=A\)AӮAңAљApAљA=qA
=A
AծA
AA(Aԏ\AzAQAԸRAGAApA{AA\)AQAҏ\AAAA33AAAA
A\)AϙAzA
=AхAGAA
=A  ApA  AΏ\A  A
AQA{AGAA
=AHAϙAЏ\AϙA\)AͅAΣA=qA33AʸRAAzA\)A\)AAHAAHAΏ\AAϙAϮAApAυAAңAAУAәA=qA(A  AzAңA
AУAffA=qAzA  A{A  AGAљA
A  AA
=A
=AA33AffAA
AHAGAͮAͮAϙApAAHAHAffAЏ\AA(AθRAAəAHAAQAƣAARAA(AQAA{ARA=qAA\AA33AAA\AARA=qAAA33A
A\AA
=A
=AAAA
=A
=AA  AARAA{AAzA(AAGApA
=A\A33AA
AffA
A
A\A
=AA{AAGA33A
AA
AAAAAA  AA=qA
ARAAGAzApAQAAA(ApA\A
AA  AffA(A\)AApA
A\)AQAQAAQA=qA\AAAAAAzAAA(AAAQAzA33AQAQAA33A\AAAA\)AAAGAzA\AA  AAHAGAA(AA  AHA33AAARAAApAQA\AffAA=qAAQA\A\)AA33AAA\AAAA\)A\A  AAA  A{AAAA=qAAA\)A(AzA
AAA  AA(AAAzARA
AA=qApA  A  A{AAffAzAAGA{A\A
=A=qA(ARAzA
=AAAAA\AA\)AAA\AffAzAARAARAzAzAffAffAQA¸RA=qApA33AƸRA33AƸRA33AŮAHAHA
=AGAA{AzARAAAƣA(ARAAřAȣAAʣA  AȸRAGAəA\)AAA33AA33A=qA33A
AƣAGAAǮA{Aȏ\AffAǮAA
=AffA
A  AȣAAŮA
A  AzA  AzA=qAəAȸRAQAAǙAGAǙAGA
=A
A\)ApA
=A{AŮA(AîAHAAA33A\AGA£A
AřA=qA\)A{AAHAAǙAGA(A  A(AǮAA33Aʏ\A
Ȁ\Ȁ\AˮA(A  A
AƣAzA{A\)AAA  AzA33AQA
AAA  A  A33AA(AQAGAzAřAffAA
AAA  A(A{A  A=qA(A
AA
=AAA{A{AQA=qAffAQA
=AGAAAAAA
AAA33A\)A
=ApA(AA(A=qA=qA
=AAAA=qAAffAA\)AQAA=qAA\)ApA\)AAAAQAffAffA{AAAAAA\)AzAGARA(AA  AzA(AA
=A\AQAzA{AAARA  AQApAÅApAA33AHA  A\)A33AAA
ApA33AQAA\A{ARAAGAA(AzA=qAffA\)AAQAAAGA  AApAAA
AGAAHAAAGAA
ApA
=A{AffAA
A(A33A\ARAAAA\)AAAAzA=qAAAGA  AA=qApA\)A33AAffA\)ApAAffAƏ\A
=A  A(AAŮA¸RA33ApA=qA33AÙAAA  A
A  AAAAQA=qA(AAA=qAGAAģA
=A33AîA
=A=qAA\)A33AffAApAGAAffA  A=qA{AHA  ApA
=A  AA
A
=A{AHAAA=qAQA\)AffAAHA\AAHA(AHAffA
=AA
AAAzAAA=qA=qA
A
=A  AGAHA(AAffAʸRA33A
=A
AˮA
A{Ȁ\ẠAQA̸RAffAzA˙A
AAAʸRA  AʸRAʣAȸRA{AA\)AffA(AffAzAQAAŮAʸRA=qAA˅ApAəA(AƸRAGA\)A(A£AffAHAzAGA  Aȏ\A
AA33AɅA(A  A33A
=A\)AHAQAȏ\Aȏ\AA  AřAzAzA
=AŮAģA  ApAA  A
=ApAzA
A33AAGAHA33AGAffAGAzAQA
AƸRApAǙA=qAzAHAəA
=A\)A\)ApAˮAA=qAzA
=AffA{AAQAA\)A=qApA{AAAAģAȀ\A{AzAʸRA
=AA=qA33AGAAAЏ\AΏ\A(AGAЏ\AϙAffA=qAͅAɅA  AQAřAGAGA  AƸRAQA(Aȏ\AA  AffA˅AA(Ȁ\AAHA
AA{ApApA{AǙApAAApAAŅAƣA(A=qAǮAĸRAAQAƣAǮA33A=qAA33A
A=qAApApAəA
AffAGA=qȀ\AffA(A{ẠA33AɅA33AGAHAϮAffAA{AAAA
AHAzA  AAAAΣAAGApAȣAʏ\AƸRAřAAGAA33AHAAϙA
AA  A\)A=qApA33A
=AffAAȣAǅAAȣA(A{AɮA  A˅A
=Ȁ\AʣAzAffA33A̸RAAAA(ApAA  AÙA  A{A
AƏ\ApA
=AˮA(AA  AAAA
ApAApAAAffA
ApApAAffAHAA
ApAˮA{A{A=qAQA=qẠA̸RȀ\A˙AA
=AɮAɅApAzA
AffAQAAAffA\)A  AAȏ\AǙA
AHAAʏ\AɅA(AʸRA
A\)AȸRA(ApAǮA{AQAȸRA
=Aȏ\AGA\)A̸RAͮA=qA33AAA͙A33A
AA
A˙AzAAAÙA  AAAHAȏ\AzA(A=qAA(AHA33AHAAģAĸRAA\)AQAHAAGA
AAzA  A\)A
=A
A
=AͮAzApAGA
=A
AΣA(A\)A  AGAQAAA(AQA͙AffAHApA{A  AʸRA{AAˮA˅AApAA33AzAυAљAȀ\AHAffA̸RAA
AzA\)A  AAHAʸRAAAffA{A  AŮA  AffA\)AƣAAəAGAHApA33A(A˙A  AAGAffȀ\A\)A  A
=AϙA\)AHAиRAϮA\)AЏ\AHAQA{A(A=qA=qApA  A
AиRAAzAAυA
A=qAffAУAzA33A=qAQAϙAQAHAAAAљAA{AzAffAиRAA{A  A
ApA  AHAffAzAQAЏ\AAθRAGAA  A=qA33ApAA
AQA(A(AGAGA
=AΣA=qA͙AzA
=AˮAA͙A˅AAƣẠApAəA33A=qA33A
AΣA
=AGA{A˅AA(A̸RẠA33A͙AΣA͙AAApA
AͮAzApȀ\AffA(ApA=qAzAffAA
=A
AffA  ApAѮA  AңAffA
=AQA
AҸRAAҸRA  A
=AθRAA{ApA(A
A\)AAHAυA  AЏ\A(A\)AͅA  A  AAͅAA{AAͅAGA\)AͅA͙AΣA\)AAAA=qAQA(A
A33A
AzAͮAAffAƸRAffApA˅AˮA
A33A(AAɮA
AAQAQA\)A  A(A33AA˙AAA33AzAGAQA(A=qA̸RAʸRẠȀ\A(A̸RAAAυA(AУAиRAиRAиRAffA  AA(A\)A\)A{AzA(AУA33AљAљAAӅAAәAHA{A=qAҸRAңAҏ\A
AәAAA{AQAѮAAzAHA
=A\)A(AAA
A
AffAA=qAAУAυAAΣAzAͮApA
=AͅAͮA
AQAAffA33A
A{AGAͮApAQA
AϙA{AљAA\)Aԏ\AԸRAӮAGAHA\)A
AGAzAϙAΣApA  ApAυA(A  AffAAAGAӮAQAԏ\A
=AՅA  A\)A=qA=qAAәAҸRAљAffA33AәAӮAӮAԏ\AՅAծAGAәAffA{AӅA
AәA
A\)AӅAffA
AAA33A  AAӅAӮAAzAHAHAAѮA=qAѮAәA33A33AzAzAGAzA\)A33AϮAAAΣAQAAΏ\AffAA  ApAϮAϙAffA  AϮA=qAGA(AA  A=qAQAAzAAQA
=AυAHAͮApApAAzA
=A̸RAAA̸RAGȀ\A
=A͙ẠAAzA{AffAffAˮȀ\A
A
A
A=qAͮA(AͅAAGAQA͙A(ApA{A͙A
=A(A33AffAҸRAΏ\A33AffAͮAffAGA̸RA
AˮAˮA  AGA\)A
AApAGA̸RA
A33A
AGAǙAȸRAƏ\A(AQApAAAǙAǙAA(A
=AŅAȣA33AzA
A˅AAɅA=qA33AͅApAAAәAA  A(AHAңA=qAGAхAѮAAУA(AиRAAΏ\AApA̸RA˅AHẠAGA33A33A(AA(A(A\)AGAGAGAA(AHAͮAAzȀ\AA=qAffAzAˮȀ\AQȀ\AA33AzAHAffA
=Ȁ\A̸RA͙AAͅȀ\A̸RA˙ApẠA
A33A  AHAA\)A=qAAͮAA(AAffA\)AA=qAGAȀ\AQAffAA=qA  AA=qAǮAəAHAɅA
A  AʸRAǮAGAŮAřAA  A=qAQA=qA
=A(A
=A͙AΏ\AAHAθRAΣAAzA(A{A{A{A(A  A33AffAAϮAAAͅAGAHAAA=qAQAAAθRAAAΏ\AθRAϙA{AAffA  ApAffAQAϙAQAA{A͙AGAAHAA̸RAAHȀ\A
AAffAHAHAʏ\AAffA  Aʏ\A
=A{AAA  A
AQA{AHAffA(AθRA{ApA(A{AҸRAHAAGA=qAApA\)AϮA{A
=AΏ\AAGA33AQẠAffAAffA33A(AHAHAAAϙAGAϙAϙApA
AȀ\A
=A  A33A
=A33AAA  AA=qAиRAzAHAϙApA(AzAAGA\)AθRApAA
AΣA{AθRAΏ\AA
AGAAAЏ\AиRA(AAA\)A̸RA\)AA˅AA=qAffA33ApAQA  A33AA33AͅA(Ȁ\AəAȏ\AȣAŮApAQA  A33A
=A(AHAQA=qAŅAƣAAƸRA
A(AAGA˙A(AA
A=qA  AffAApA˙A=qAffAzAQAffAA  AA(AGAAʸRAAffAẠA̸RA͙AA(AzAHAA
ApAʣAA{AQAAffAˮA͙AffAͮAAA  AAͅA\)A
AffAϮAAHAʏ\AΏ\A˅AAzA
=A(AɮAȣA33A  A{ApAɮA  A(Aʏ\A˅AHAzAA  A=qAzAffAQA
=A  AGA(AHAʸRAA˙AzAA  AAGAzAəAzAzAHAffAȸRAȏ\AȸRAGA(Ȁ\A33AAAQAAAHAQAA{AQAAAAffAzAΏ\AθRAzA33A\)AffAAA\)A{AAϙA(A
A
=AυAQA\)AϮAQAAzAHAffAʣAApAAffAHAQAəAGA(A
AəA
AAzA=qA
=ApApAAͮA\)A
A33AGA(AA=qA\)A33AAQA33A(A͙AͅAAθRAzAЏ\AffAAffAУAAAЏ\A
=AѮAzA
=A  AхA=qA{AQAA(AffA(AAA=qA=qAУApAA
=A33Ȁ\A=qA33AA{A(AAA̸RA(ẠA33A(A33AQAffAAGAͮAͮA
AzAGAHAA=qAAHAиRAffAHA=qAϮAхAffAϮAA
=A
A(A  AAAΣA
A{AAθRA\)A=qAAAəAAʸRAHAAQAHAGA  A  A
A{AffAƣAAA
=AƸRAA{A
=AȀ\A  AQAΣAQApAAQAиRAϮAϮAAffAzA=qA(AͮAHAAУAAУA
=A\)A=qA  AΣA(A
AGAϮAAGAzA=qAAAҸRAҸRAҏ\AAAиRAθRA(AAHA
A{AApApAAхAGAApAHAЏ\A
=AѮAQAAAңAЏ\A{A=qA\)AQA{AQA  AϙA(A
AQAʏ\AA(A  AΣAHAHAAAυAΏ\A͙A
A(AQA\)AϙA\)AAəA  AQA33A{AɅA33A{AɅAHAQA̸RȀ\Ȁ\A\)AzA  A̸RA=qA{AffAGA̸RA=qAQAAAzAQApAθRAHAΣAΏ\A͙AffA
=A
AAzAA\)AApAϮAHAHAGA  AΏ\AͅAHẠA
A{AA{AA=qAɮA=qA\)A\)AAAɅA
AAQAAA33A
AəA(ApA(AGAɮA˙AffAffA{A(Ȁ\A
=A(A̸RA(AȸRȀ\AA\)A˙AAAʏ\AHAʸRApA=qA\)A{Ȁ\AzA
=AAΏ\A=qAHAA̸RA(AˮAAʏ\AAʣAʸRAʸRA{AʣAA(AAAAHA33AAɅAɅA{A˅AGAQAʸRAzAəA(A(AHApAʸRAQAzAAzAA
=A
AɮA
AAA\)AʣA(A\)A(A
ApAAˮAAˮAŮAʣA\)AAΣA=qAffAQAAǮAAGAQAȣAȏ\A
=Aȏ\AȸRA=qAȏ\AʣA33ApAGA\)A=qA  AɮA=qAȏ\AzAAHA\)A\)AApAɮAA˅Ȁ\AAʏ\AȀ\AAQA˙AQAĸRAẠẠAA\)A\)ẠAA\)AˮA  AȀ\AA
A(AzAʸRAʸRAʸRA=qAGA33ApA
=AAʣA  AAǅA(ApAzA\)AAzAffAA  AAA\AARA
A\AffAAQAAAffA(AAHA
AA
=A(AzA
=A  AApAAA{AAGAffAGA=qAARAARApAGA(ARA{AQARA\AAzA=qA=qAQAAzA\A  A(A{A\AQA
=A{ARA=qA{AAAA{AARAGAAAzARA{ARA=qAAARApAGAA\)A=qA=qAA\)AA\A\)A
=AA33A{AAApAAAQAAA
A\)AGAAA  AA
=A=qAAAAAAAAGAA
AAA
=A\)A33ApAAzA\)AAffA
=AGA{A
=A\)AAffAQA(ARAARA\AARA33AQAAAA
A\)A
AAffAHAHAAffAGAAA=qA\AA\)AGA
=AA{AAA=qA  ARARAAHA
=A
=A  AA=qA{A\)A
=AffA\AAApAAAA33AA(AAA=qA\AAAHAAffAA
=AGA  ApAA{AffAAQAAGAA  AAA=qAHAApAQA(AAAA
=AAA\)AffAAffA
ARAAHA
AA
=AA
=A=qA(AAffAA
A(A
AARA{A
=AA\)A
=A\)A{AA\A33AGAARAzARA=qA\AAAA  AA{AQAAHAAAzA{AAzAGA\AHApA=qA  ApAHA{AAÅA(A=qA\AApA
AffAHA
=A  AA\AAAApA=qARAAA
AHA=qA  AffAzApAAffAQA=qAzA
=A33AzAHAGA\AAffA¸RAAA33AffA{AĸRAzAHAGA33A
=AŅAHAA£A\)A¸RAAzAzAģAAA  AAGAA\)A
A=qA
A
AHA33AA
AA
AAAAQAApA£A{A(AA  AzA  AŮAŮAHAAŮAƸRAffAHAAď\A33AƣAƏ\AHAřA=qAƣA(AQAQA(A{AŅAŅA33A
=A33AÅA=qA33AƸRAȣA{A33A  AHAď\AA
=AzAAAȣAȣAAGA  AǙA  A\)AA(ApAGẠAzA
A˙A\)AQA{AəȀ\AQAAAffA
ApA\)A
AA
A{AAǅAȸRA
AģA33AAÙAA\)Aď\AGAQAÙAřAGAŅApAApAHA(AƣA  A=qApA33A33A  AƣAƏ\AAA33Aď\A=qA¸RA\AAŮA(A
=AƏ\AǅA=qAȣAHAȣAGAA(A(AzA\)AA\)AͅAHA
AͅAApAA(A{AAŅAAzA{A
AAffA{AAʏ\Aʏ\A
=A33A͙A͙AΏ\AϙA33AAȀ\A͙Ȁ\A=qA(AʣA  AȸRA\)AffA  AGA
=AzA  A{ApA
=A  A{A=qAřA£AAAƏ\AHAGAƏ\AAɮAHAƏ\A
A  A  AA=qAffAQAffA  AzA\)AAHA  AȸRAAƏ\AzApA  A
AȣA
Aȏ\AHA=qAQA=qAQA=qAǮA{AHA  AŅAA
=A33AƸRAȸRAzA33A=qA(AʸRA
AɅAAǙAAǅAA33Aȏ\AQAȏ\AA
AȣAȸRA  AǅA
A33AA
=AAffAffAřA(A33ApA(AģAƏ\A
AffA=qA
=AǮA=qAzAAA\)AƸRAřAAƏ\AA
=A\)AHAAAffAAAŅAAAAģA(AQA=qAď\A(AAȏ\AGAAAřAAŅAA{AffAƏ\AAffAřAGApAAHA  A=qAΣApA
AQAffA
=AA  AApA33AȸRA(AǮA{AAAzAͅAHA͙AAAȸRA
=A  A33AffAɅAQAȣA  AǮA33AGAGAQAŮAAQAŅApA(AŮAAA=qAAŮAAAAzA
=A  A
A
=AQA(A\)Aȏ\AApAGA{AQAAɅAȣAAA33A
AzAŅA
AƸRAGA
=A  AAAffAzA33AǅAffAƣAƣA  AǮA=qAzAȏ\AA{A=qA{A
A\)A\)AĸRA  A£A\A\AGAAHAA
AQAzAAzAÙAA
=A33A
=A{AffA\A
=AAffAA  AA\AHA{ARA\AAAAAffAGAA\)A
ApAA
=A  A
AffAA
A=qAQAģA33AffA(A(A
AîAA(AGAĸRAģAď\AîA{A
A\AAAƸRA  AHA\)AǮAAffA
=AA
AzA(AɮAA
ApA33ApAAAffAAɅAəApAAǮAzAəAGA{A(A{AAzAGAƣAffAHAGAGA  AzAzAHAzA(AQAAAA  A33AHA{A
AAA=qAzAǅAƸRAAǅAAA  AAĸRAA
=AzA
AA{Aď\AĸRAffA\)A
AAffA\)AAŅA  A{AŮAŮApA  AAǅA˙A˙AGA{ApA̸RAAHAApAϙA33A
A(ApApA\)A̸RAHA=qA\)AHAA
=A\)AGAA̸RAA{AȀ\A33A=qA˙AAA
=AHAHA  AA{A˅AffApA=qAAffA\)AA  A33AzAGAA
=A
=AA=qA
A\)Aď\AAffA£A{AƏ\AffAAAA=qAA{A
=A{AffARAAffA{AAA\AAGA£AQAɮAA33AǅAǙAAGAǙAAȣAA{AAAGAQA
A  A=qAHAHA\)A
A  A  A=qAffAHAQAGAAɮA  AAGA=qA(AǙA  A(A(A{ApAȏ\A=qAƸRAA\)AzA
AȸRAȸRAQA
AɮA33A(A{AGApA
ApAɮAAʸRA(A{AQA33AAzA  AHAəAȣA
=AAAƣAAffAzA
=AAA(AzAÅAHAď\AffA
=A
AřA
A\)AffAƸRA
=A=qAȸRAzAǙAAAAA{AA33AAƸRAƸRA33A=qAǅA(A\)AřAƣAȣAHAɮA{ApApAHApAHAȏ\AGAzA33A  AəAHAɮAApAQA  AffAA
=AGAQAHAzAA(A(A(A\)A{AřAGAřA{AHA£A¸RA¸RAA  AHAQA£AAAƸRAAzA(AffAffAîA¸RAA¸RAŮAQAffAGAÙA(AAAzAGAQAģAAƏ\ApA=qAȸRAƏ\A\)A=qAGAƸRA  AA  <<<<<
<<
<#
<#
<#
<#
<#
AAQAAQARA
=BzAA
AB=qA(A{A{A=qA߅AHAQAA(AAAA
=AzARAAARB  B 33BBBBQB B pBB B =qB BA\A=qBB (AGAzA33A  ARBBQAAGA=qAA
B
=B HB ffA(B B 
=B B =qBBB
B33A
BBHBGBA
AAzB  AQAAHA
BRBBBpBB\B\)B  B
BpBBRB
=BRAGA\)AzA  A  AA{A
A=qAABBBQB{BHBBBB  B  BRB (AffAQApB AA33A\)ARA{A
A  AA  AARA{A
=BQA\AABB AA  B 33AGB\ApAGABB
=B{A  A33BHB
=BBB
=BHBBBB=qBBffBffBpBzBBzBBGBpA(ABGBGBpAA
=AAA(AffA(AffAApAB HAB BB=qBB33B{BGBABpB33BB\BB
=B\BzBB33B HB \B AAA  A
AGB B BBB GB  B
B33B=qA=qAQARARApA\)AQAA33AA(B \)AB(BB\)B33BB=qB	
AAA{A=qB
B{B	\B
{A  A\B{B BQB A{AAHA
=AGABGABB\BBBBAGB{A
=AffBBA{AffB 
=BA
=B=qBBHB
=ARAzAARA\AA{AAA=qAHB AAHAAB (B
A
=B ffA  A  A
AAAHB ffAABB 
AHAARB ffB pB pBffB\)B  B=qBpBB\)BBBB{B QB pBGA
BzBpBAA\)A  ApAHAAAB   B ffB\)B pB GBffB BBBB\)B RA(B RAB zA\)AA\)AGAAffAAzA{A  A=qA33AQAAA
=AffA
A{A\)AAᙚAGA\)A홚A(A
ARA(A݅AGAA33A{AAARAAARAARAAAARA
BRB(B33BA{AAzA{AQApAffA  AGApA  AAHA  A\)A=qA(A
=AA(A
AAAffAA\AzA\ApA33AzAAzAffAB\B B \)BffAB RARA\ApAHB HA
A
A=qA=qAAffAQAARA  AᙚA(AffAAA(AAQA陚A\)AQA(A33A(AffA\)AAApA\B
=ARA{A(AzA(AffAB
=AGAHB BRB BB GB QAAAQA=qARARAA\)ARAA\)ApB=qB =qBpB\)B   BB(BB
BBpB\B  BBBBB\B=qBB
ABffB 
B B   B B 
=AA\)AAAHA
AQAzB
=B33AffBzAAA(ARAA=qA
=AAA
=A
=A\)A\)ApAA  A
=A  AA{AA
=A홚AAGA  A(AAHAAߙAߙA(AA(AffApAA{AGB
AGARA
A\A
ARAAA{A33AAHAAAA\)AzA\)AB AA\AAAQA  AGB pB \B 33AA\A  AHA\)AAApAAGAAzA  AHB AAB
=AffB(BBB{B B(BAffAAQAAAHAzApAGA(AzAAAAA33AAAzAAAAAffA
=A(AAGAA(AA{A(A\)AQAzAAAzAApA\AffB {B B =qB(BBBHBBBffBBBGBAffBHBBffBBBzBB RBB \B=qB=qBzB33BB{BBB  BB
=BBB
BB
=BBBBpB33BzBBBffBGBBQBB pB\)B{B QBHAAB \A=qA
AffA\A
AHAGAAQAA  A=qA\AAQAA33A=qAAAzAAAHA{AffAA\)AffAGAQA\AA(B   A
AGApB 
=B B  B
BffAzBA{BB\B
=B{B\BApBBB33AzB=qBzB zAAffAGA\AzAffA
AAAHA
=A\A
BffA\)AA\)AHA
=A{AHA
A(AAABzB\BRB\BB33B A33A  ApAHAHAAGAAAA{AA=qA(AA
=A=qA\AA  A=qA
AARAڣAAzA
=AffAAB A=qB 33BGA=qA\)AHAABB B A
AHAA
=AAARAQAAffApA=qA{AA\)AA(AzA\)B (B\)A33A\A
AQA\)A  AQAA(A=qA=qA  A\)A  AA
A  AAffA\)ABB HBpAA(AARAAA
=A
ARAAA(A{AA(A{AAAA  A\A  A
ARA{AA(AGA\AA33AARAApA=qARAffA{AB =qBffB BRB\)B33A=qA{AQAAHAAQAA
=AGAA  AARAzA(A\A{A(A=qA33ApA\)AA
=ABQB 
=AAAffA홚AHBB\)BB\)B(BBffB=qA{B   AAGAzA(ApAAA=qAA\ApAAAQAA{A{AAA  AAAA\ARA\)AAA(ARAAA\AAA{AApAA{AARA\AAA
AAffAffAQA{A=qA=qA\)AA33ARA\ApAAAGARAGAB \)BQBGBHAHApAzARA\)A
=AAAzAA33AAGAAzAGAGA\A33AffAzA
=A{ARAQA
ApB AB \B(BffBB =qBQB\AAA\AAGAzAGAA=qAA{ARARA\A\)A33AAAAA{AzAffAA{A\AA(AzAᙚAAA\)A{A=qAGA{AHA  A\A(A=qAAӮA33B B =qA\)ApAAAA33ApA\A  A(A{AA{AA(AA  AApB{B GBpB
=AA=qA=qAAA
B{A\B ApA{A33BB
=qBzBB33BGB{BffB QB HB33B ABzAffA(ApAAA33A(AGARA{AARA33AAA(A\A\A
=AA
A33AA\ABBzBB33B=qBBBB33B33B(BBB (BHB
=B{BB33B 
=BB\BB=qB AAffAGAA33B
=B33BBBQBQBBGB=qBHBHBB
B33BBBB
B=qBBBQBHBBpB\)BB\)BB  ARBBBBGB(B	B	=qBRBffBB A
AffA  AzAffB BBRBBB33AHAffAffAAAA  AHApA{AHAAAA33A
=A(AB zB ffBB 33B BB
=B
=BGBB  BB(BA
B
=B
BHBA=qAzABBQA
=A
BB  BpA(A  AAffA
=A\)A  AAA
ABGB A{B \)AARB AAQBB  ARAB {A=qBHB 
ABAApBAzBBBQAHBHB ffAAB\)ABB\)BBBB  B\BBBRBGBRB\)BBBBQBGBQB\)BGBpB{BBBffBRB33BBB
B  BHB
=B\)B\BzB\BB
B 33AQARBffBGBpB
=BGBGB
B	ffBB
=BB(BB 
=BB{BB33B=qB\B
=BB
=B
BB(BQB{BB  BBQB33BBBBBBRB{BB	pB	B	HB
  BGBB  B GBGBBBBBQBQBHB BRBB
BB
=B=qBzB\BBBB\BBBBQB(BBHB33BffBHB
=BB
=BB(BBffBBBB{BBB\BGBBBBB(BGBB
BB(B(BBB
BHBBpBBBB{B=qBBBBBRB\B(BpB\)B\)BHBBBHB{B\B\)BQBB\B
=ABAGAA{AAApA{BAQAQApA
AzA=qA
A  AGAAAA{AzAAA33AA
=A
=AHAAffA
AAQAApA{BGB pB{B{BffBBGBBHBBQBRBGBBB B =qA\AQAA
B HBAzBB33B33B{BBffB\)B\)BBBB AB \B BBQB\)B 
B 
=AA
=B ffA\A33ARB RB   B HAB A\)B{A\B 33ARAGAAA\)AzAQA{A
AApAAAHAHAAA
AޣAߙAffA
=A{AA\ApA噚AQAAAA\AAAzAABRB\)BBBGBGBpBB=qA\)AzAHAAzB \)BpBBBBBBBBffB(BzBGBB\)AffB GB
B ARAGA  AB ffB=qAApAApA
AAA{A
=A33AARA
=B{BHBGAB
=A{A  A33A
A
=ARAzAAAffAAGAAAAAAޣA(AޣAGA޸RA=qA{A\AAHAA
=A
=AٮA\AQA؏\AٮAAܸRA\)AAHAzA\AAGAA{AA33AAHA(A=qAAAA
=ApA(AAARAQAABRA33AAHAA33AA33A=qAzAAA  A{AA\A=qAA
=A{A
AffAA=qA  A
A  AAzARAA=qA  A
=ApAAAffAAffA33AۮAGAAAAAGAAAԏ\A؏\AAAAQA
AGAΣAǮA{AA
AՙApAA33AQAəAиRAA\)AA
=AA
=AzA=qAA홚AGA
=AA
=A  A
=A  A
=AB QBAAA(B \BB  B 
=B=qAB RABffAB RBAHA{A(AGAzA=qA
AQAA{AGAffA=qAA
=A(AA(AffAAA
AA
=A㙚A=qA\)AQAHAA(AA˙Aʏ\A(A
=AΏ\A33A{AHAϙA(ApAͮA33A33AHA\)A  AzAAљA
=AÙA{A{AffA֣A\A  A(AzA
A(AAA\A\AHA(A홚A  A
A\A33AAA{ApAAHB zA
=A
=A
A\AzAQA  AAAAAAQA33AApAGAARApAA
=AQAA33AffAzA  A=qAGAApAApARAQAA  AA\AARAzARAAzAHA
=A
=A\AzA=qA(AAA޸RAQApAݙA\)Aҏ\A=qAQAAQA\)A
A(A噚A
A=qA
AAQA
=AGAA
AA  A\)AAARAzA
AGAQA\AQAAA33AHARAzAAߙAA
=AAAffA{A
A{AAA\ARAAAAAAAAffAA\)AA  A(AAAA{A=qA  A{A33A33A
AAAA
=A\A
=A\AQA{A(ARA33AHApAGAAAGAA  AAAAAAHAAzARAAAAzARA33AA(BGBBQBQBpBffAA\AQAQAA=qAzAffAAQA=qAGAA33A{AAAAffAzAffAzA{ApApA{ApA
=ApAAHA=qAffAGA=qARA  AAA{A
A
A(A{AQA\)AzAB{B pAAABApAAzA
=A  ApAQAA\AGA\AAApApBBBp=uBAA
ApApA
AAHAA\AffAA33AA
AA\AGA{AQA(ApA\AQBQABA
BBRB
=AAAB QB=qB  ApA
=ApB A\)A\)ApAffAGAB{B QA
=BpB{BB AAGAzAzAzAA
B HA\)B\)BHBBB  B
=BRAB  BQBBzBQB (BGB33B AAzAHA  AAGA
=ApA\AAQA
=A=qAAAAGA=qAAHA
=AApA\A
A
=AffA  A
A\)A{AB=qB B ffA\)A33AGAB=qBB=qAAAA  AffAzA{BB 
BffB  B\)BpB(B
=BHBB
BHB(B\)B=qBB
=BGBRBB BB\)B \B
=B{BzB\)B {B
=B RB 
ApB=qBBQB=qB33BBB
B\)A  AHAQApAA
A33A  AGA33B B=qB\BHB\BBHBGBQBBB
BA(AAGARB QB
=ARB =qB AGA
=B B
=AB RAGA\B\)B(BB\BffBB33B\B  BB{BQB\B{BB  B33BBB	GB	zB	\B	ffB	B	
BffB(B\BBRB(B33B
=BHBRBBpBB33BRBBB\B
=BffBBBBB
33BpB33B=qB=qBHBBB{BB HA
B \AQAQAAAB BzBB\B\B33AGB {B   A
=A33A
A\AzAffA(AAA33A(AA33AApB 33B\B HApAAA\B{B
=BHBpB  BffBBB  BRB\)BHBRABBffBB\B\AffAA\)ApAB zB{B\)BzB
BHB =qAQAAAffB{BBpAB(BGBA33AAAB(BzAGA  AAHARAAHA{A\)B 
=B \B  AA  A
A(AA(A33A=qAQAAA\)ApAAA  AAAA
AAA  A(AA33AGA  AυAzA噚A{AffA\)AQAA\)A㙚A{AQARAA33A
A
AQA  AAAAA\A  AA(A
=A  A
AGA\AAffAЏ\ApAAAA(A  A{AApAAHA  A׮A\)AzAHA=qA  AGApAAAzAAʸRAA  A  A(A\)AA=qAΏ\AA\)AAffApA
AиRA33A33A{AHAQAAA=qAA=qAڣAA  A{AAQAHAQA
=A{AA
A׮A
=AיAGAԏ\AAffAzAAңApA\)A֣A=qAޏ\AQA{AAA=qARA
AظRA(AA
=AffA\)A
=A݅A=qAиRA(A(AAffAAљA
AA=qA
AՙA\)AQAAA(ApA33AAHA  AA{A
=A
AQAʸRAA33A\)A
=A(AA
AͮAzA̸RAŅAAŅAzAͅAHA(ApAAۅAAȣA{ApA\)AəA=qAA{AA33AffA(AAÅA
AGAGAȣApAمARAzAծAffA
=ApAAHAẠȀ\A˙A
AA˅AѮAAHAA(AAɅA  AApAHAQAffAGAAəApA(AA
=AGAAͅAzA  A\)ApApAиRA  A\)AA  AGAA(AGA
=A홚ApAApA\AۙA(AÅA{AHAzAGA33A
=ApA{AffAAҏ\A=qAԣAͮAңAӅAԏ\AңAAAAȣAzAffA  A޸RAGApAA
=ARAzA͙AʸRA
=AAхAffAљAzAAGAAA\)ARA
A  AffAAHAǙAA33A
=AA(A
=AAA\)AAQAQA(ApA\)AA\)AA  A
A33AARAARAQAAApAˮA  AŮAffA
AظRAAڸRA=qA\)AA  A33A
=A\AAA\A=qAzAAGA
=A=qA{AA  AHAAA{AA
=AGAApAQAGA33AAAzAzAAA
AAAĸRA=qAzA=qAA
A(AffAGA{A33AAA׮A
AffAAA=qAQAٙAHA\)A  A33AřAAA(AܸRApAA߮A
=AAAzAңAffA{AAARA  AA\A홚AAA{A33AHA뙚A(A癚AAAA  A(AffAAA\AAAAAQAHA\)AHAGAУA
=A=qA
=AffAGA  AܣAHAApAA=qAQAA
AA33AzA\)AA(AQA
AAAffA=qA  A(AffAA(AApAA(AffAzAffApA\AffA  A=qAHAA
ApA(AAQAARAAffAAGA\AffA\A{AQA=qA  AffAGAQAGAAA
AAGAHAAA33A(AAGA33AAߙAzAAB GB \)B pB B 
B 
B \B \B B RB BffBBBHB
B AAB \B ffB(BB B AGBGAQARAA
A=qB   B RB HB B AzB AAAAAB 33B B GB QB zB GA\AHA(B ApBBAApARAGA
ARAffA  A홚AA=qAHAA=qAffAGA
ApApA̸RAA=qA33A=qAʣAQAA
=AиRAA  AApA\)AffAHAQA\)AAAAGA  AAA  A(AA  AƏ\AAAHA\)AHAAA
=A  A  AAA\A=qA¸RAׅA
=AAQAAمAA(AA£A\AA\)AGA
A
=AAffApAGARAAAffAARA
A=qA\A=qA
=AAAA=qA\ARApAAA  A33AQA=qAzAApA{A(A
AA{AAffAA
=A\)A(A=qA\)AAHApA=qAARAA  A\ARA{AGA\AAA
A{AffAHA
=AA33A\ApA(A\AA\)AzAzAGA\AAHAAApAA(A33AܸRA
=AAAQAA
=AAGAffAAA
=A33AӅA
AȸRA(AffA  AA33AA\)AGA=qAʸRA{A(AAGA
ARA=qApAAGAA
A
AHAA33AAzAAGA33A(AA
AA33A{AAAAA33AA(A\AHAٮA\)AzAzA£A(AHAApAffA\)AQAffAAA33AA  A\)AAA(AA\AGAApAA
=A\)ApA\)AQA  AA  AA\)A
=AɮAA
A=qA\)AʸRA
=AAQAzA
=A(AffAGAA{AA=qAϙAGAffAAəAQAÅA33AQAAAQAᙚAAAzAGA=qAQAAzAHA
AA{A\A=qApAAARAHAffAzAApAAAffAA  A
=AffAAA33AA33ApAAAAAAARA
=AA
=AAAAlAUGAQA
A\A  AzAAffAA  AAGApA{A(AQAQAGAA33AA\)A{A\AARAAHAHA\)AffAGA{AAAA
A{AA\AA33A\AQApAA33A=qAA\)A
=AAAHAQA\AA{AHA  A
AA33AzA
ARA33AffAffARAffAAA\)AA(A
=AA(AAGAffARAffA(AHA\A  AARAQAA33AHAAzA
=AAzA  A  A  AAAA
AGAARApAAAAA(ARAHAQAAQAzAA  A
=A
=AA\A(AffA33AA
=A=qAGAA=qAAGA
A
=AAAA\A(AGAApA\A
=A\AA  AHARARAA(AAffA=qAffA  ApA33A{A\)ARAAHAAHAARAA
A33AApAHA  AAQAApA
A
=ARAHA\)A{AAAffAQA  AARA(A33A\A
AAQARA{AAAAAAQA  AGA(AQARAŮA
=AAA{AApAAffAA{A  AzAA{AAAAQA33AAA\A  AŅAƸRAzA=qApAA
=AA(A{AGAzAA{AϙA{AAA
AAARAffA\A=qAA=qAAzAzA
=AGAzApAApA\)ARAA{A{AA  AAAAAΣA=qAӅAQA
AۅA\)A޸RA
=AAA\)AAљAхA(ApAAAQA  A{AA{AzA\)AיAA33A
A
=AA{Aڏ\AA=qA׮A܏\A=qA
=A݅AA33AApAGAA
=AQAHAHAՅAA
=A=qAzA\AzAHA=qAAAHA=qAAGA  AA
ApA  A
=AGAٮAzA(A
=A
=AծAGA33ApAffA
AߙA
=A(AA=qAAA
A\)AA=qA\)A(AQA
=A(AApAGAA  A33AGApAAAQA33AAAAAGA\AAARAA=qA\A=qApAAAGA\A
=AApA33A33A
=AHA=qBGA(AA
=AA  A33AARAGAApARA=qAAAffAA{A33AAAApAA33A(AQAAzAGAA=qA噚AAA
AA\)AAAzA
=AAA=qAffApA
=A  A(AQAHA{A
=A\)AAHAffAB  AA(B(BQBB \)AB AARAA\)AQAAAHAApAAffAA
=BffAAHA\A\)AQA=qA
AHAAApA33A
AA=qB   A
=AAAzA(AQA33AAApA  AHA  A뙚ARA{AAA  A(AQAAAAAzA33A
AGA
=A=qAAzA뙚AGAQA=qAGA
=A
=ApA  B BBB=qB(B  BHB
BzB=qBBHBRARAA\)A(A
B{BpB  BBy BffB\B{BzBB{B
=B\BB=qA33A
=A33AffAffARBAQBHBQBAApAAA33B {B A\)A=qAA
=A33AA  AGAGAA\)A\AA\)AAA
=A㙚AA
AAA
=AAzARA\A뙚AA\)AGAA\)AGAzA{B B  B{BRB =qBB{A\AHB QB=qB{BHBABffA{AAA(ApA\AAApAB  BA\)A
AHB pAA\AA  A33AzA33AA
A\)A=qA\)A\)AHA
=ARAAffAA\)AGAHAAzAffAA  ApAAGAAAAffA=qAA\A\AA(ARA\)AA
A=qAQARA\AzAHA\A
AzAA{AAGB RB {AAApA\A\)AAffAAA
A\)A=qA\)AAA\AABHB{BzB
=B
=BHB
B  AGAA\AHAA33BBpBQB
=B AffB(B HAA\)A
AAA33A
=AffAAGAA
ApAffA\)B A\)BB =qBB\BRB   B\)B\A\)A
B ABB BGAffA=qAAQAB \A33AA\A\AAAAQAAAffA(AGAAB \)B \B ffB(B B\Aď\ApARAB 
=BB\BRBBB	
=BBBQB\BGB
=BRB\)BQB
=BQB\)BBzBpBQBGB  B=qB B GB QAA(A
AAHA  A33B(AAAA
=AQAB AA33B
=BQA
B{A
=B B HAA=qA=qAzB pBRB\)A  B=qB
BGAffB(A\)AAA\)B \B BpBffB(BzB33BQBB	{BB33B  B=qBBRBBB\BB\B(B
A
=BB=qA  BB
  B	B	B	HB	B	\B	B(BpB\)B{B	33B33B	=qB=qB	\)BzBB
=BB
\)B
(BHBA33BzB\)A\B
BpBBHAHBBGBBBB=qBpBB BB{BpB=qA
B33BA
AQApB =qA  ApAzB QB AAGB zAGA\AHA(AffAAQAAAB ffBHB  BBB AGAHAAA  AAGAAzAB zB pB
=BA(B33B HB\)B(BB33B  B QBpB QBBBBB
=B33BB{B33B\)BBpBB(BB
{B	33B	B33B	
=BBzAHAA\)AA33AAApA\AAݮAQAAأARA  A=qAݮAңAAHA(AA{AAAHA\)AAҏ\ApA{AHA
=A{A\AAGAAA
AGA
AAQA
=AQA=qA(AAA  AffAApA癚AARAAQA  A
=A\A\)AAA
ABB AGA33A(AHAffABB zB {BRBA\B33B{B33BABBRAA
A(A=qAffAzA(AAA
AHA(A
A  AAA
=A\ARAffAAAHBAB AABAApA33AzB=qB{A
A
AAzA33A  A=qA33AzApA=qA
AAzA޸RAffAAApA߅AAzA
=ApAA\)ApARAݙA
=AAAAٮAAzAAAHAAAffAA\)AB33BRAzAA\AQB{BBzB33B B HAAAA=qApA{A33AA
=A\AGA  A
ApAAARAAHA\)A=qAAA{AGAAAA=qARA  AARAHAAAAA(A
=ABGBHBBQAB\)B GAA  B 
A(A(A=qAHAAHAApA
=B QB \)B
=BQB(B33A{AffAA{A{B\)B(BHBBGB=qB\)B33B=qB  ABpB B   ApAffB\B33BB33B	B

B	{BB  A  BAffAffBGB RB \BzAffABA
B=qB\BpBRB
=AQAzBQAAB 
BAAAA(A
=ARAQAA
=A\A噚AffB
=A
A\AAAA(A
A(ARAAAA\)AAAA{A  AHApAzAHAGA{AᙚAzAAffA(A\A{AAB(B \A\)A=qA=qAApARAA  AAݙABA뙚AGB
BA{A{A  A=qAA\AA
A\AGAGA\)AA뙚A
=A\A{A
ARARA(ApAAffAQAAGAA
A(A=qAffA\AAA33AA33AAA\ApAHA؏\A  AָRAԣAA\)ARApAAzApAAGA
=A\A֏\AAAAzAARA{AAHApAzAAffA\)AQAAffB
BApAAA\)A\)AzA33A
=A{AAzAծA{AAzAAۮAڸRA\)AхA  A\zA
=AzAأAAA33A33AAAzAAA
AHA(A  AA\)AGA{A  A33ARAAAffA
=AGAAAA
=A\)A33AffAӅAۙAzA  A=qA=qA\)AÅAQAA
AA{AA  A
A׮AٙAAԸRA͙AθRApA(AՙAAܸRAA
AAzA  AAA33A뙚A\AAAAAAAffAA33A\AיAܣA\)AAA\)AңAԏ\AAٙAAAߙApAAA\)AQA噚A  A{A(ApA(A(AApAffA˅AУAѮAAAffAzAHAA(AAffA  ApAA
AA\)AݙA\)A=qA{AzA
AAQA  AApAzA\)ApA33A(AzAۅAхA
A
A
=AffA(A{AA\)AzAAAAQAzAAՅA\)A{AA{A
=AܸRA33AAHAA
AAGAHAAGAљA  ARAAA
A\A
AۮApA(A=qA=qA(AARAAAHAAAAA\)AA33ARAzAA(AAA㙚AAAQAAA
=ARA=qAA  A{AGAA\)AA(A
A\A\)A(AAA
=ApA(AA뙚A\ARA\)AߙAA33AAAAHAAAA(AңA
=A{AzA  A  AAAՙApAAAA33AGA\)A=qA(A{AՙA
=A=qA(AƏ\AəApAAAGAAffAAAzA33AԣA
AAGA
=AffA  AAʸRAGAܸRAQA\ApA
=A
AޣAߙA\)AAffA  AԸRAA
A33AA=qA  A{AA
=AGAAA(AHAAA  A\)A(A=qA=qA\)AAA{ApA
=AָRAA
=AA(A\)AGAˮAAAϮAffAA˙AA  A{A  ApA=qAApA  A{A
AAA(AA݅A
=A\)A
Ȁ\AHAffAffAď\AAAڏ\A\AGAffAAA
=AA=qAAHA  AA{A33ApA\)A33AAA=qAffA  AޣA؏\AظRAԸRA
A33AәAAAۙA33AᙚAffA  A(AAGA=qAAAAݮA(AffAAAGA=qAхA  AHA陚A(AAA=qAڣA=qA33AAA\)ARAA(AzAAAљAA{A
A=qAAHAAA  AApAAхAAApAQApA=qApAAApAGAAA=qApAAQA  A(AApB 
=AA
=A=qAQB GAA{A
=AzApAHA(AARA(AAGA=qA홚ARA\AzAGA{AA{AA  A  AA{A{A\)A(ARApAAAA=qAHAAA33AAAHA33A(A=qA\AǙAGAffAA33A
=AHA33AģA33A\)AәA(AAHAQA
=AGAQA
ApAA
AARAAGA\)AffAAAGAA=qA\)A\)AzAzAA\)AQAЏ\AffA  AAˮAAݙARAӅARA(A  AGA33A{A
A(A\)A뙚A
AAA߮AυApAܣA  ApAffA֏\A
AzAظRAffA
=AAARAAHAمAffAzApA\)A  AQAHAAA{A=qAAQAA=qA=qA(A  A33AA=qA=qAAffAffAAAAQAمA{AGA\)AӮAzA؏\A\)A
=AzA\AAGAHA33AApARAڏ\ApA\)AA
=AffA=qAAffAAɮAՙAA33A
=A  AəAA
=A  AHAHAхA{AHAAAÙA֏\ApAA33AޣA{A{A=qAQAď\AɮA{AӅAzA(AffAѮA͙AAծAA
AɅAA\)AAAGA
=A(A33A{AA
=AzAA  A{AzAzA33A
AA
AA=qAGAAHAA
=A=qA{A
=AAAA  A33AA޸RAAA=qA
AzA(AģAA¸RA(AGA\)A  AAřA{AGA\AAQA  AAÙAffAzAffAA=qA=qA33AAAHAHA(A=qAzA(AAA
AAzARAAAAAGA
=A
AA(A\)AQA=qAQApA33A  AΏ\AAHAA33AGAA
=AAəA{A
=ApA{A{A33AޣA͙A
AAA\)AA{AQAA{AAGA\)AffA\A
AۙAAA\A܏\A=qA\)A\A(A{A
A=qAݙAAQA(ApAAԸRA33A
=A׮AzAAHA޸RAffAHA=qAQApAA33ARAA  A
AGAAffAApA
=A\)A  A
=A{AߙAzAA(A=qAHAУAәAљA33AHAمAAzA뙚AQARA  A֣A
A
AQAυAAGAHAQAGA{ApAAGA
=AzAAA\A
=AHAffApAGAAA33A33A\)ARAHAAAAңAzAAzA{A33AHAffAzA33AA\)A\AA癚AAAAۙAffAAA33ApAAHAA
=AApA33AхAυApAԸRAA33A
=A  A33AAffAQAAAAAHAGA
ARAAffAffApApAzA{A{A݅AA(AمAGA뙚A݅A{A߮A=qAɮAAәAAAAAffA  A=qAGA{A  A
A\A33AǅAzAď\A
A£AffA{A{AA=qAAzA\)AA
=AٮA33AAAޏ\AAA
AۙAA  A=qAApA\)A33AAAQA
=AAA  A=qA
=ARApAظRAAzAffA  AٙAA  A㙚AzA{A߮AθRAȏ\A{A\AGAAAGA\AGA\)A=qAffAA\)A\AAQA=LA33A33A\AAApAәA33A֣AAHAzAQAA
=AHAzA
=AAGAGAAHAA33AHAA(A33AGA  A(A(AAAQAAB B(B B
=B(BffAAB BzBpA
B RAHB{BQB HB=qBARA33AAAA\)B \)BB BHB =qB   AA
AAQAAHA=qA33A(AAzAAffAθRAAzA\AAA33AApA뙚AA\)A=qAA33A{A(A{AܣAAGAGA\A{A\)AAApAzA{AA  AHA=qAAظRAzAGAzA\)A=qA  AffAծAQA
=ApApAA(A
AA
=A¸RAAA=qAA{A
=AHAAʣAٮA\A\A33AAAA
A=qA33AA
=AAA\AAzARAAޏ\A33ApAA=qAApA  AAA¸RA=qAAApARA
=AAQA33A  ApA  AffA
=A  A{A\)AޣAۙA\)AۅAAAHA㙚ApAzApA(AQA\A=qA=qAA{AAAυA\)A׮AՙA
AӮAAٙA{AzA=qA@wA
A\)A=qAظRB(BRB(BBBA{AQA=qARAApA
=A(AGAffA\)AA׮A{A
AGAzAңAGAΏ\A˅AAǙAQAQAHA{ApAApA33A\)A֏\A㙚A=qA33AHAAA(AffA\)A
=AHA\)AӅAAQAApA(AߙA
=A
=A{A\)AA
A\)A=qAAzA=qB=qBBBffAAA
=AA  A=qA(A\BB33BHAABGBHBGB\)BAAAzA33AHB BGB AA
=AAAA(AffA{AQA
=ApAӮA{ApAzA(A
=Aȏ\A  AGA{AAffA׮ApAљAAA  AA{A33AAAAΣA׮AA\AHA߅AA  AA  AʣA\AAQA˙A(A(A=qAAAәA(AffAQA\)AAAGA33AffA\)AAffAAхAffA\)AApAHAA\)A  ARAͅAAAʣAAApA
=A\A(AA(AzAθRA؏\A(BBB
B ARA33AQApBGA\ApA\A\)B
=A\BB\)BBAApAAA
=A=qARA  A\AAGAQAQA=qAAffAΏ\A
=ApAABGB{AzAHBzAAffAA=qA߅ApA33A
A=qAGA{A{A
=AHAA=qA(AAQB 
A(A  ApAzA
=Aȏ\A=qA33A\)AхAzA  AzAՅAAڣARAQAHAAAQA(A\)A뙚A  A33AHB AAAARA{AAzAAffAGA
=A  AA(AffA(A  ApAA(AAAffAApA  AA
=BzAAAAApAGAAAA=qAҸRA=qAAQB HAHAffAAA
A=qAAHAzAQAffAzAGAϮAzAQA(AffAɅAzA  A\AA\)ApAAAQA
A׮AՅAzAΏ\AApAGA(A
=AA홚A  A
=AAAA=qAzAAffA\)AAA㙚AA=qApA߮A
=Aڏ\AffAQAA\)AAA  AAHAAzA{A\)AzA\A홚A
AffA  AA\ApA(AA  AAApA(A=qB   AHA
A\A\)A(AA33AA
AAϙA(A\)A33ApAAA(AQAîAǙAAffA
=AAAAڏ\A{AApA=qAɮAffAQA=qAA{A
=AAAQAApAAA=qA
A(AA
=AAA
=AGAA33AAffAHA\ApAQAA(AAAAA\A
=A
A\A\AGA
=BffB {ApAAA33AHAA\)AA=qAAA33AQAAAHAAAzA=qA
=AAQAA(A
=AA=qAAApAA=qAٙAzAݮA{AޣAA(AA!A\)AمA{AGA{A  A֏\AA33AA
AffAAffAA=qAQAA=qA뙚AA(AAAAHA=qA33AәAңApA=qA  A\A(A癚A{AzAAA=qA뙚A33A{A
=A\AAAA{A\A{AHApAzAHA
=A\AA
=AQAAAA33AffA33A33A\A(A=qA
=A\AAAHA  ApA
=AAљAӅA=qA\)A\)AffAHAA
=AGA\)AAٙAQAQApAʣAˮAAģAAffAHAәAA(AՙA
AA  A\ARAzAՅAHAGA=qAQAHAAAAAAffA33A=qAۅAHA=qA  AAQAA{AمA܏\A
AA(AA(AәAA{A
A޸RAGA\AA  AAA\AAApAHA\A
=A׮AGA
=AA
B
AAߙA
=A{AAAHA\)ARA{A\ApApA\)AGA\)AAAffAAHAQA  A=qAQARA
ARAA{A癚A33AGBAA\B(AA\AB B QBAAffAQB{BBHB  BGBQBBRBBffB
QBBBzB=qBRBGB{AAGAB\)BB	\AA  B  AHAAAB33BAA(AA  A{AA(ARAA(A(A{AAAQAHAHA{AGAAA=qA\)A\A
A\)AffA\AQB=qA\BffA\AffAAAGAA=qAzAA\)A
=A
=AffA=qA  A=qAffAA  ApAHBB{BffBQBBBzBQBQB33BffBBBBBffBRB
=BBB\B=qBAGA
BGAB
=BGB 
=AA  AzARAA\)AAARA
A=qAzB\ABB GAB(B\)BBBBHA=qAB RBBffB RB
=B
=BGB
BBBBQB{B
=B
ApAAHAAffAGAA33AGAffAAAAQA
AA
=AAAA33ApApA
AQAA33AffARAA\AA\B=qBB pB B=qA
=B\)A33A
BA\)A\)AA  A33A{A=qB QAB   B(AAAQAA33A\)AAA33AA33AA\)AAQA  AffAAHAGAAHApAA
A33A
ApAA(AQARARA{AAHA=qAGABzA33AיA  A  A\)A\)BB  BA(A
=A  A  AAHAA
=AA=qA陚AzAAGAAA  A=qA\A\A(A
=AיAA{AHA33A֣AׅAffAAAԣA{A=qAۙAApA޸RA  AA
A{AAAA
=A
AAAAAA=qAA
=AAAAAAzAA{ApARAA33AAAA{A33AA
ApAAA\AGA{A
=AGA뙚AffAffAA  A޸RA33AGA
=ApAHA
AzApAzA\)A
=A33AۅAzA
=AхAΏ\A33ApAAffAȣA33A33AAAA
=ApAǮA  AAۅAGAApAA\AA(A=qA뙚AAHA
A
=A
AGAA  A\A陚A\AARAAHAffAAQAA  AA\)AAA陚A(AA\)AffA\)A噚A=qApAA  A{AAAGAARAGAHAA
A\AA  A  A=qA33AΏ\A33AGAӅApA{AٙApAHA޸RA߮AAA\ApAGA
AљAͮAAAA
=AУAAA33A{AzA(AA͙AأAυAA\ApA{ApA
AAA\A=qA{AA  A=qARA33A\A  AAB B 33B B 
=A  A
=AA33A{A
AA(A=qA33A\)A(A  AA
AHA{ARAQAARAffA\)AA33AGA(AAAA  AA=qAAAݮA(AGA癚AA݅AA؏\A
=A{A33AܣA{AAHA=qAQA
=AA
AzAGAHA\)AAffAAAA\)A{A{AAGA33AzA
A\)B
ffBBB
=BBHBGB{B	B	B(B	BB	=qB\B(B	B
ARB(BQBBB
\BBQBB=qBHBGB  BHBffB{B{BGBHB33BBpBBBAARB QB {BGB=qBRA=qAA  A  AAAzAffAB B  B  B33BRBB ffBpBBB
=BQBBA{AffBBGB(BffB=qB{BBQB\)BBzBBGBB\)BBpB\B	B	pB
B
pBB

B
{B	
B	HB	B	{B  BBBpBGB(BBQBRBA\)ARA
B=qA=qA
B
=AB   B
=B B\BBGBGABRB{B=qBA
A
B
=ARB QAApA=qA陚A33A
=A  A
=A=qB {B   B zB \AGAARAA=qARA(A
=AA33AAffA\AGAAA=qA=qBAB\B\B =qB BA\)ARAABffBRB(AB(B \BGAB  B\BpBBRB B 
=ARAGAGAA\)AGB 
=AAAARAzA(AQA\A
=AffAffARA\)AApApB{ARA\A=qAAAA\AApAAAAzAQAA
=AAQA\)AzAQAGAGA  A
A{A\AᙚA
AHAHA
=A\AAHA{AA  AffAAGAAA
=AHAQA(A뙚AGAA(AGA
=AܣA
=A癚ApAHAQA
=AARA陚AzAApA(AAAAB A(AHA(B AffB A33ApAAA  AApApAA(A
=A=qA\)AzAAAHARA=qA{A\AQARAAA\)A
A뙚AA (A{A̸RA(AGA噚AߙAffAA
=AA˅AǮA\)AȸRAHAAA
A=qA33AиRAGAӅA=qAхA33AGAAffAљAӅAҏ\AGAхAffAΏ\AffA{AffAHA\)AʣAzA֣AQAA33AHA=qA33AzAGAzAGA  AA\)AAQAA(AffA(A{AzAA
=AA\)A
ARA{A㙚A
=A33A(AAAGA=qAAAHAA܏\AAA{ARAQAffAA
=A33AA  AGA\AHA
=A
=AAݮAAŮA\)AAAHAA
AGA{A  A=qA
A\)A
A\AQA{A
AAŅA(AAHA
=AA(AͅAԣA׮AzA߅AᙚA
=AffAAAHAQApA33AAzAA
=A
=A\A33AA=qAA\)AHABB  A=qARAA
=ARBRB zB B ApARBzAAHAA뙚A㙚AޣAAHAAzA=q@pAHA
=AA33AB 
B \)AAAA(AAӅA\)A{AAAQAGAGAHA\)AffAAA
=A
A  AA
=AA(A{AQAQAA=qAAHAzA
Aҏ\AHAϙAиRAGA\)AәAϙA{A\)AޣAQA
=A(A  A
=A  A{A\)A
=ARAAQAAAB zA33ApA\)AQA߅AAA{A\)A(A  A(ARAGAAApAAGAA
AzA\)ARAA33AA\)A33A{AA=qAQAAAхA
=AffAA
=AģA  AřA(AAA
=Aģ@GAffAǮA˙AHAAͅȀ\A(AΏ\AzAffA33A
ApA߮AAAڣAGAGAGA
ApAٙAծAQAA
A
=AHA=qAffAA
=A\)A뙚AAAffAGAAAzA\)AAAAA܏\AzAA(AA=qAHA
=AAԏ\A
AߙA(A(AAA=qAAffA{AGAAHAA
A{AARA\A{AAAAA{A\)AAA{A  AffApA
=AǮAAƏ\A  AA
=AHA\AzAA  A
AffAGAAHAÙAHAAA33AGAAARAA
=A\ApAA  A
AAAߙA{A
A33AAffA
A
A\)AffA  A
AzAAAAAA  AңAA{AA33AAHAǅAۙAAQAυAᙚAHAQAȸRAϙA
AHA{AAffAӅA\)AA{ARAffA
=AA
=A=qAA  A
=A{AAAA
A
A
AffAA\)AQAAA{AQA=qA{AA  A{AA  A{A=qA=qA
AA
=A\)ApAGA\A(A\AAAHAffAQA=qAARA=qA33A\)AA
AHAAHAHAzA
A(AAffAڸRAzAߙARA
=AAzAA
A  AzApA{A
ARAHAzA\ARA
AGAQA(AA
=A(A
=AQAAAzA  A\A\AAQA홚A(AAA=qAApAlAAHAAϮAHAΣA
=AA
=AAҏ\A
=AffA  AA33A@\)A(A{AAzAQAAGAƏ\AQAHAأAָRAAAzAHA  A홚A\AAQAzAApAHAzAzAApA{A\A\A
AGA\)A{A=qA  AAApAA
=A{AAAAA  AA陚AApA{ARA=qARA=qApAA{AAAAA
AAB ffB QBB(A=qAB\BHBRAQA\AA\AA
A
ApA33A\)AHAGAHA  AAAHAQAǮAQA  A{AHAGA(A֏\AAffAA
AA
=AθRAAApApA\AzAAHApA\ApAAA(AARAAA홚ARAAA  A{A
=AAApAAA
AzAQA噚AA\AA
A\A\A{A=qA  ARAAAAAHA陚AAHAHA{ARAzAQAHAAA\)A=qAA33A\)AA\AGA
A
AffAAAԣA33AAA{A(ApAAAAffȀ\AGȀ\AʣA33AAA  ApAQAHA
AApAA
AAAffA
=AA  AAA33A(AA{AGAffAQAHAɮA؏\A{AQA33AHA=qA
AAA  AAAQA=qA\A=qA\)A  AA\AHA陚AAzAffAHAHAAAQAffA
=A
AGAAẠAA(A=qAϮAΏ\AA=qA=qAA͙AAzA33A(AǅAď\AA
AHAθRAAzA=qA  AHA{AA=qA\)AzAȣAHAAȸRA  AGAffAHAʏ\A=qAffA֏\A(ARAGAARA33AAA33A
=AffA
AGAARAGAHA
A  A{AA
=AQAAAA{AGAۅAzAffAA
=A뙚A  AAHARA=qAۅAAffAAA33@AzAffA
AQAzAAzA
ARApA33AݮA=qAGApA=qAܸRApȀ\AA
ApA  A
AQA
=AA33A{A\A(A=qA\)AAA\AAHA=qA=qAA\A
=AHA(AffA\AAQAAA\ARAQAHAA
AAA=qA(A{ApA\)A
=A\AAA=qAAAzAQAApAGA\)AGA{A=qA
A  AAAAA33AA=qAHAGA33AAAAAA{A{AffA  A  A8AHA33AAAAAA\AGA癚A33ApAzA
=A\)A陚A33AAzAAA
ApAAA\@ָRAAAAA=qAAQA홚A{AGA=qAAAzApA(ARAAQAAQAAQAAffAA\)A(AGAAAAQAzARAAARA{AAAAA\ApA\ApAA  AGA=qA\A
AzA
A\)AAQA=qAffApAHAAffAARAA
=AA
AzA33AAAAݮAAGA{AAѮAљA{AGA  AӮAGA(AGAA
A=qAGAzA(ARARAAh(AAA(A
AAٙAAAԸRAծAУAQAQAхAzAAffA  AAA
=A\ARAAAAA\ARAGAAA\AAAAAAAAA=qAzA
AAQAA33A(AffA(AQA\)A\A(AAffA
=AAGAAAAA\ApAQA{AAHA홚A
AA
=A޸RAAGApAGA33AzAQApA33AԣA=qA33AzAܣAzAAHAA{AθRAA  A33ApAхA
AҸRAӅAA
AA\)AиRAָRA\)AA\AAHA=qA{AARAA{AzAARAffA33AA\)A(AHA=qA  AAAGAAQA
AA{A=qABAzB (A{B  A
B=qA33A=qAAAAffA\)A
ApAٙAA\)A33A  A(A{AAAGA
=AHB=qBAAA=qAڣApAɅAѮAA
=AAA33AGAzA\)AAGAAzAAA
=AAA=qA
AQA홚A
A33AHA癚A
=AGAA\AAAAApAAHAAHAzARAAAHApA뙚A  AffApApBpBHB AAAAA33A뙚AHA  AHAzA
=A
=ApAA\A
=A=qARA{B A
AffAGA  A
AA
A(AffAHAAA
AzA(AHAAA
AߙA
=AAAٙAHA
=AAݮAAA(AQA  ApAۮAۙA=qA
=AAߙAGAAAA33AA
=AGAAA33AA\)A{AA=qAAB\)B RAA(B   ARARAB GBB RB pApAGB ffB {AAAffA  AA
ApAB QBzABQAHB33AA\B=qB B {B
=BBBGBAQA33AAA=qAAA  AAApA\)AHApA\AA
AHA{A܏\A=qAAAffA
A{AA
AApAA  AffAAA\A\)B pABGB
=B BB
=BzBB
=BBB 
=B{AApBQB\)BpB
BB  B  BGBBB{BBpA\)BB
=B
=BB33BGB  BHB{B AGAzBzB
=ApB A(B{B{BzBBB(B zB{BpBBRApBHBB A
A(AAzARB{BRB
BAzA{AAA"ffA  AA(A(AAApAffAAAAHAffAAGAGA(A
=AHAHAAA=qA뙚AQAHApApAA=qB HBRAA33A\)AGBffBQB
=A=qAQA=qA
=A(AAQAGA\)ABBBBBAQAQApA{AGA33B \)BffA{A\)BB=qBzApABGB \)A
B AAB ffBBB33B HB{B\)BB {B  B
=BAAQA(AAzA?
=A{ARA33A
ARA33AHA
A  ARA33AA\AHA33AAHAAAApAA  ARAAAAAAB
B GBffB\B	QB	\B	RB	ffB	B
pB
{B
(B
ffB
QB
BB
33B	pBffB(B=qBBBRB
B	GB
  B
BQB\BB(BAB=qBQB
B{BRBHBB=qBBB BQBB \B{BBHBQBzB  BGBBB<#
B
B  B
BGA\AQAzA
=AA\)AAAAffAHAGApA
=AA=qApAAzAAA  AA  A
AAHAA33AB33BB\A=qAGARA
=B AA{A
B{BBB33B\B=qB\)BQBGB
=BzB33BB(BBffB\)B\B33BffB33B ffBQBRBBHBBBB (B\BB BBB
=B(BBRBAHBQB\BB
B	{BpBB=qB
=BpB{ApAffAHAAHA\)AApA  A\)AAAApAAApAAAGA33A=qAAGAffAA
AAA癚AHA=qARAzA(A\AQBB  BBB\B=qBzB(BRB\)AB B 
=B33A
BABBQBB\)B\)BB  BQB\)B=qBRAGAB HB ARAB GAA\)AAA
=AffA
A=qB33A{B
=BB\)BBffBB\)BzB
BBBBA\AQAA  AAA噚A{A33AAQAأAQA33AAAzAڏ\ApA(A{Aڏ\AۙAۅA33AܣAApAA
=A
=A=qA  A  AAԣAHAQAA
=AٮA(ApAAAAAHAGAAУAģAQA
AمAУAffA\)AffAٮAޏ\AAAQA(AAA=qA
A
AAA33AA
=A
AHA  AA(AA33AAGAAAAHAAAffAGA  AA=qAA(A׮A
A=qAAA
A{AQAיAAHA
AApAיAAA܏\A
AΏ\Aԏ\AGA
AAA=qAzAzA
AA33A\)A
AGA\)AApAzA33AAAzB   A
=B{BB(B
B\B  BHBB=qBAAA=qAffAA=qApA
B \)AA\)AGApAHA߅A  BQBBBHBzB\)B
=AAABBpB
BffB  B(BBzBzBffB33B\)BBGBBGBBQAHAApAffA\A陚A\AޣARA33A(A\)A
=AGAAAAA
AzAAA\A
ApA\)AARA{AGA  AA33AffAAHA=qApApAᙚAffAAARAGAARA
A(AGAHA=qA
AA33A(A33A  AAA\A
AffAApAA\)ARAGAGAffAA{A
=A
AA  AffA
A  AzAQAAAA\A\)AA  AQAQAAAA陚AzA  A=qAQA{AAffAAA\)A=qA33A(A\)A{A{A33AA33AȸRAzAA33AAAϮAffAAA  AA=qA\)A
A{A=qAϙA33AυAAΏ\AˮAGA=qAAApAA
AARA33AAGAQAA\)AGAA  AA(A
A=qAGA33A\)A
ARARA{AHA\AA  A33AЏ\AAٙAA
A\AAA33A(AQAA
ARAAQAAA\BAQAA㙚A  A  ARARA(A
=A\)AHA
=AA\)AffAHA  AQAGAAӮA
A=qAffApAAAAУA
A33A\AAď\A{A{ApAffA(AHA
A33AHAԣA{ApA\)A  ApA\)A  AAAՅAڣA{AAAظRA  A=qAӅA(A  AظRA
=A
AA\)AAָRAAA  AQA\)AîAϮAAA\)A˅AAQA=qAAAۅAzAAAQAGA(A=qA\)AGA\)AffAޣA
=AGAAظRAQAυAHAzAͮA
=AA  AAHA  AzA33AzA=qAGA  A͙AHA
=AQAAGAAA33A(AB QB GB QABAA\)AQAA=qA=qAA33B
BffAQB \B (B \B AGA\)ApA\A  AQAA{ApAGAQAA33A  AApA
=AAARA{A
=AA{A  ApA
AAAzAzAQAGA\AAѮAzA
=AA33ARA  A33A
=AA(A
=A
=@
A=qAAAָRA=qAQAޏ\A뙚A
=A(AϙAAA33A=qA  A
=AAңAۮAA=qA˅AGAGA
A=qAHA{A=qAzAՙApAAHAA\)AA{AA\)AQAAzA\AA=qA=qAAA  A
A\AHApA(AA=qAAA33AzA
ARAAffAAAA  AA\A
=AA\AAAAAGA\AAAQA=qAGA  AHAA\AA\)A\)AAAB A  A{A\AAGB =qB\)BBB(BffBBBBQB\BB33BBBBBpB	33B	B
BHB
33BB(BpBB	(BB   BBBBGB	33BGB(B
B
33B
zB	B	
=B=qBGBpBGBpB33BHB
RBzBQB
=qBB RB	\)B
=BA=qAB\)BBBBA{BB B\BB\)A
B
BBHBzB  BzB
B  B  BzBA=qAHAAzAA  AA\)A33AQB
=B	{BBffB33BHB	ffBBBB
=B(B  A=qB{B QBB=qAAQA=qAA陚AApB 33A
B{B=qBB	B	
=B	pB	B
BB
B\)B33ABBGB	QB zB\AGBpB	
BHB{BBB	QB
B	  B\)BB{BffBBBAGBffB{BRBBBHBBBRBBpBB{B ffAHA  AB BB A
=AQAAB\)AzAARA\A
A
A߮A
AGB  B=qBpBzBA(A33A=qAAffAAffARA\)A  AGA33A\A
A33AGBBB=qB{BBpB(BHBB
BBBBB
=BpBGBpBBGB
=B{B
=B{BB(BBBBGBRBHB
=BBB=qB{AB\AHB AAA
=AHAffAA33AGA  AB B BAB B
BzBpBBA\BRBB
BA\AffAA=qARAA=qAHA=qAAHAzA{A\AAARA癚A33A\)A  A陚A{A
=AA\A  AffAA33AA(A
AzAAAQB 
=AB BB=qBBB\)A\)BffBB  B B\B\)BAA=qA(AGB B=qBpAzAHAA(AAARAQAA=qAffA=qAzA{AHA{AffAGAA홚A\)AA\)AB {B B\B=qB(B {ARA\AGARA=qA\)AܣA{A
=AApAAAAffA\)A
AA
=AAAzAAGA{AܣA݅AGA33AAHARA33AA\)AAABBB\BBB
BB
=B=qB(BBQBB\)BB zAzB
=ABpBBBBpB  AA
=BffA
=A33A\AGBGB\)AB GAA(AffA\ApB\)ApA
=B BQB\BzB
BBRB
=BBGBRA\)AA㙚AHA߮AAAGAAAAAA33AQAApA=qA\)AAGAAA33AԣA\)A{AA݅ApA㙚A޸RAA{AAzA=qAzAA{A  A
A\ARAAGApB A\)ABzB BA=qAAzAAAARAA(AAAHApAA홚AGAAA{AA噚ApARAzAA\ABzB =qBAAA
=A\)AB  B{B(A33BffBBBB(B ffBzAA{A\AAA{A
ARA=qA{A{AAQA
=A癚A
AffA\AffAffA\)A(A׮AffAA=qAzA33AGA33A
=A(A
=AzAffA=qA\)A33A癚A(AzA=qAHA{AQAzA=qAA  A
AffA\)AA
ARA  AzA
=AffAAzA=qA
=A
AA{A  AA33A  A
=AA  AA\AA(AffA(A33A33A
=AHAHA33AA
=A\AA
AGAA(AAA
=AA
AᙚAޏ\AᙚAA
AGAAffA  A=qA陚AAQA  A33AzA
AGA
AA\)A\)AңAQAGAGAΏ\AƸRAƸRA  AffAхAŮAΣAQAݮARAAQA33A=qAϮA\AzA33A(AffAAAHAA
=A(AzA  A33AAAAA(AA
ARAA33AAGAAAffAHAAAA
=AzA\)A߮AzA
A
A=qAAAAAzAA=qA
A
AӮA\)AAAffAA(AGA=qAAA
=AA(AA33AAHA  AAHAA\A
=AHA\)AA
AAA\AAffA(ApAffARAAAAQAHAAAQAAGA\AzAARAAAAHAGARA
ApAAA  A(A{AAAzA\)A{A\AzAA  AיAAA
AHARAAAARAffAHApA\AQAHAzAA
=AAAAHA
=A  A  AffA  A
AffAGA
=AHAGA33AHAQA  AQAQA{AAA
AzAQAәAAңAffA(AA(ApA
=A(AיAٙAAffAߙAQAAGAA(AQAzAAffA{AA\)AAApAA\AGAAA
=A
A\A=qAQAzAHARAAAHAA噚AQAzAAA
=AAAA33A
=AA߮A\A  A33AffAA
=AARAQAA
AAAQA
=A\)A33AGA
AApAffA\)AHA{A=qAA  A{AQA
A
=AHAffAffAAAAۙAQA
A=qẠA˙A=qA=qAA33AߙAݮAGA\)AGA=qAA
=AAA  AHAAAAGAB {BzBGBB
=BBA=qBB{A
A33B BGA
A(AA
=A  AA{AffAHAffAffAA뙚AARApAAAAA  A=qB\B(BzAHAQA{A(AAAGA(A{AA(AA=qAffA33A  A  AGAAHApApA\ARA
ApAAQAHAQAA  A\)AB
AAHAA  ARA  AzAB BB(BpB\)BAB\BpB33B{BB\)BQBB33BRB\BB=qBB=qBGBQBBB  BA(AA(B{B	B B  BQBBQBzBzBGB
=BBGA{BzBBBBffB{B
=A33AzB
BBBBpB=qBzBffBB=qB ffA
=A33ABAGB33B GBBGBB
BffB
=B B
B{BBpB33B=qBHB
=ABBzA(BB(B  B 
BHBzB33BRBBffB\)B\BBB=qB33B
BQBffBzBBzBB{BGBzA
BBffB=qBzBBB
B33BBzBQB\BB  B  BB=qBB\BAzB
=BffBGA\BBB  B\)BBB(B
B BBHB  BpB\)B RA\AA=qA(A\AB AB B \AAHA  AGA{AQA\AAA  A=qB ffA
A(ARAzAAAA=qAAzA\ApA=qA\)A  AA=qApAB B \B{BHB
BBB(AAABBBBRBAB\)BRBBB HBAA
=BBB 33B{B\)B AA
=AA\B QB=qA\BGBB{B @Az@mpA
=A(AHARAApAQAzAAQAQAQAffA(AAA(A  AGARAAzAGAAffA(AA{ApA33A
=AAHAAffAA(A
=AAffA33A(AAQAHB{AAzA{AA\ARA\)AA癚AAAA\)ARAAA(A
AAffAGAARB	B
zB
\)B

=B	
=BB BB{BBffB33BQAA\)AAAAffAQB\AGAAA\)AQAQBBBHBB(BHAB{B
BBBGBffBGB(BAB B GB ffBA\)AAffAA=qAAAAGAffAA\)AA
=A
=AffAA(AzAHA(AA(A߅AAAA(AffAGA
BGBBB A\BGAA=qAA\)A(A(A(ABB
AAAQA33A홚AffA\A\)A(A
AAAQAAA=qA\AHAA
=AzA(A  AzA\A癚A\A\)AAB
=BBBBGB=qBHB HB B B AHAB
AGA(B 
=AQB B pAzB RB\)BBGAAGA\AAAffAAAAAA
=AA\)AAQAGA{A=qA  AAAAGB {BB=qBAA\)AAAA\)AHAAAHA33A  A
AA뙚A{A
ARAA뙚A\A=qA
AA\A
A33A߮AGA癚AAQAApA\AA=qAAGA{AޣA(A=qAQA\)AAA(AB   A
=A  A(AA
A\)AffA{A߅A{AܸRAzA݅A\A޸RAAA=qApAffA߮A\)AޣAA݅AۅA܏\AAߙA{A  AAڣAzAAHAۙAڣA\)ApA\A\)AޣAAGAAGAAA\)A\)A
A
=AQAAApAB \B B pA{A=qAAA
AAԸRA\)A{AҸRA
=AHAۙA(A؏\AAיA=qA\)A=qAQA(AHAA  A\)A=qA\AzAA33AHA=qAARA\)A  AffAHAAAQAGA
=ApAzA
=A홚AAA=qA޸RApA噚AA\A
=BGAA
=AAzA\AHB QAzAHAA\)AffB{B=qABA=qBA
=A=qAA33AAA
=ApBAA{A\)AQApAGA33AffApAA
=A\ApA癚AAA
=AzAAQAAݮAffA33A{ApAA  AAffA
AHA
A(A
A
AGAAzAAQA\B AB AGB(A
=A\AffAQBA\)BQA33BBBHBB  BB(AApAzA33B 
=AAA
AAAA뙚ApAzARA
AAQB BGB\B{BAGApABB=qA  AHAA=qA\AA33ABBffBBA33ARAA{BzB  BRBB\B  BpBB HABBA\)AzAzA
=A
=A\)ARA(AApA{A
=AffA=qA=qAQAHApAAHAAffARAAAARAA\)A\A\)Aڏ\A؏\Ȁ\A\)AңA33A݅ApA33AAAA\)A33AA=qA
AAB
=AA\AA(AffBGBBGAQAAGARAAAAB HA
AffABBRB\BzABB{AAGAAzA(A
=ARA\)ApA{A  AAB\)B	GB	B
B	B
BBAAA\)A{AHA
=ARAA
=AzAAQA
=AAHA
A\AAAzA\)A33A  A
=ApAAA  AA{AAAA=qAA\AA(BB  ABpB
=BHB
BBB{B	B
BQB	
B
A\ABGB
BBB{A=qAzAA{AGAB{B
AHAA(AA=qA(AARA{A(A홚AQAHA
=A=qAGA\A\)ApA
=AffA
BBBB pB\)AQAAHA
=AA
A
AzA=qAffAzAA33AAA\)AHA癚AA=qA  AAAAAffAA(AARAzA33A\)AAA33A
=AHA33A
=AGAABB AA33B  BBffBAA  AGA33A㙚AQAQA{AA=qAQ=L            ApAGAAHAA\)A  A
=A֏\AApAQA=qAҸRAHAQAAAԣAAѮAA33A{A
A
AffAAzAڸRAGAA33A\)AAA
=AApAAA癚AARAA\AARAAzAffAffAA\)AAQAAA\AAA
=AHAA
A=qA{A  AAAA33AAᙚAAߙAߙAۙAڸRAQAHA=qAܣApAHA(A\A{AQAHAHAGAA(AAAA  A\A33A{AHAARAGAA
=AAQAA33AA{AA{A  AAAffAAHAA\AA홚AA홚AAzAARA
ApAffAHAHA
=AHAGAffAA{AA=qA=qAAGAHAHA
=AzA=qA{AܸRAݮAߙAܸRAۙA=qAHAܸRAA܏\A\)ApA߅AA
AQA  A܏\AA
AHAA  A33AAAA(A=qA
=AA  AٮAAGA33AzAřAQApAQA
=A  ARAGA33AGApA33A
AHAffA\)A  AA¸RAHAGAA  AɮA{AʣAA=qAřAˮA(A
=AHApA  AffAڣA\A  AHA\)AGAA(AffA\)A\)AݙA{AffA  AӅAՅAAAffAA\)AܸRA  AHAمA{AffAHA(A{A{AхA{AQA㙚AׅA؏\AGA33AAQAA
=A\)AAծAAřAď\AŮAA\AƣApAQAAA\)AAQA
=AŮA  AƣA
=AǮA{A\)A33Aȏ\AĸRA=qA  AAAARA\A(AA(A\A  AAAQA  A£AAffAAffA33AHA  AAͅApA\)A33AGAzAAQA=qA=qA=qA
=AAHAAݮAȸRAGA\AA33AAzA
A{AA=qAУA  A=qAGAУAҏ\A(A=qAA
AA
AA{AQA=qA
=AAAHAA(AAA33AAA(A(A{AQAA
AAGAAA=qA\)AA\AA{AAA  AAAHAzAAAAAffAAAffAHAA33AA{AzA(AHA
=AffA=qAͮAzAAAϙAA͙AAхAAzAȸRA{AŅAAͅAAA33ApA
AffAƏ\A
=AəAAٙAAzA33A{AGARApAݙAAAA33AAA߮A{A  ARAHA{AޣAAAAAAAŅAApAffA(A=qAAffAAApAAGAARA=qAAA  AffA  AǮA(A33AAA\)A\)A  AHA
AA
A߅AAAzAGAHAAAۅAݙA(AAڣAߙA\)A
AGAAA33A
=AA  AGAAAGA\AffAffAGAAHApAHA  A{A܏\AA  A33A\A  A=qA
AGApA  A
A֣AA
A\)AffA
=A\AHAApAA{AᙚA\)AQA(A\ApA޸RA֏\AAAGAzA
=A(AzA\)A33AffAA{A֏\AҸRAԏ\A=qAڏ\A  A  A݅AHA
AѮAAA\)A33ARAGAA{ApA(AAAApA\AA\AzAA(AffA  ApA
ApAA=qA=qAAA\AA
AAzA{A{AAQA{A\AAA\AAApAA(AA=qA{AffAGAGA{A{AٙAzAzAݮAzAA=qA\)AHAGAAAA  AAՅA(AЏ\AA33A\)A֏\AA{AޣAA  AיA؏\A=qAGA
=AQApAzAָRA\)AApAGAQA(Ȁ\AΏ\AffAԏ\AAAffAAA{AQAQAAQAָRA\)AϙAиRAͅAGAΣA
A
A{A\)A˙A(AA  AAGA
AzAȣA£A{AApAHA  A
=A
AиRAA
AиRAzAzAGAAA=qA33AAAAA\A
ApA=qA
AAA\A\)ARAGA
AAzAA
A  AQAŮA(A33AA{A
AAAA\AGAAA\)AHA33A
A
AA  AA(AffAA  AffAΏ\AQAQAAA
AݙApAHA\AߙAӮAҏ\AӅAиRAA{A
AHAۮAхA
=A33A33ApAA\)AܸRAٮAAffA
=AGA(A  AظRAHAۙAޏ\AA  A(AׅA(A{A
AQApAGAAޣAݙApAQAʏ\A
AHAA(AəAǙA
=AzA33AA=qAA=qA
=A(A(A33AA{AAAAGA=qA(AA33A\)A\)AGAÅA(A  A
AAхAָRAׅAAᙚApApAA  AHA=qA{AߙAGAA33A=qA  AAAAzA߮AzAQAޏ\AffAffAGAڏ\AffA֣AQA
AΏ\AHAzAAAffA=qAA  A
=AA
=A
=AzAA㙚AA33A\)AиRA\)AHAңAAQA(AAAA
=AffA\)A{A
=AمAٙAڏ\AڸRAA
=AAApA\)AͮA  A=qAȏ\A33A{AθRA=qAиRA
A(Aԏ\AAQAffAQApA֏\AAָRAݮAHAQA{AAHA
A  AHAA(AzA߮A{AAAGA=qA
AQAAzAHAݮAAzA(A\)ARA
=AffA  AA=qA  AA=qAGAARAA\)AAAHA=qAHA
AAA=qAzAHAA\A(AARAQAARA=qA{AAA\)ApAA
AGA{A\)A(AAGAAA{A=qAHA(AA(AzAӮA
AхAHAGA33A{AA=qAAQA
=AAAأA{ARAA{AݮA\)ApAA  AffAzA33AAA
AARAAQA߅ApARAAGAHA\AAQA=qAمAHAzA\)AϮAGAzAAծAܣAffAAAHAAAиRAУAHA{A
AzAA֏\AڸRA
=AAQAۮAAQAAHAARA=qAAAAAA33AzA  AA=qAAHA\)A{AffARA=qAᙚAAAAA=qAHAzA\)AGAzA
AָRA
=AAGAA
A
A\AHA\)A=qA=qAffAAAڸRAAQAA{AA(A؏\AHAzA33A
=AAA
=ApAA
=AԣAݮA(AHA˅AffA
=A=qA=qA{AffAzAzA\)A33AAHAȣA(A=qAAAAA\)AAA{AA
=A(A\A(AƏ\AzA\)AGAGA=qA
=A
=AApA̸RȀ\AHA33AAHA{A  AAAAA  A  AٙAA\AЏ\AAҸRA
=AA
A{AQAAHA=qAA
=AA
AA=qAApA\)ApAApA\AAAڣA
=A=qAAQA
=A{AHAÙAÅAffAӅA=qAAGA(AA  ApA
A܏\A  ARAA  AffAڣA߅ApAA=qA㙚A{AQA\)AA\)AԸRAGA=qAřAģA¸RAAA=qAAA{A
AA
=AAA{A{AAA
ApA\)AARA
A{AzAAQA  AzA{AA33AffA{AHAAzA  AGAQAAffAA33A33A߮A\)A{AA㙚A(ApApAzAمA
A(AQApAGAA33AHA  A  AݮA؏\AA߮A(A(A=qA˙A  A
A  A  AӅAHApAθRA=qA=qAɮAHAHA(A
A
AHA=qAGA  A˙A(AAAȸRAȏ\AAřAƣA(A=qAǮAffAɮAǙAǙAȏ\Aȏ\AəA
=Aʏ\A
A  A
AHAffAԣAA(AѮA33AGAẠAGAA=qAzAծAHA  AAAңA
=A33AAЏ\AA=qAQA
AQA{ApA؏\AݙAA
AԸRA=qAA33AGAݙAQA\)A\AQAAA
AљA  ApAA=qAAHA
=AQA
AAɮAGAřAʣAʸRAŮAAΣAڣAأAA\)ApAAQAθRA{AӅAAڣAA(A=qAУAۮA(AHAffAAAGA
=A\)A(AA33AAʏ\AHA=qA=qA33AffAAA\)A=qA\)A
AمA
=ApAHA=qA߅ARA
AAAޣAGAA\)AHAA=qA(A(A=qA
=AzAAߙA
AA  AAAA܏\A  A֣A{AzAzAffARA=qA33AARAٮA33A
=AQAQAA癚A\)A  A  ApA
AAAAA(ARAA߮AQAAAA\)ARAzA33A\)Aڏ\AffAA{A33AffAQAQA\)AGA33ApAGAGẠAиRAHA
=AGAΏ\AGApAffAA\AA߮A
A(A  A陚AAzAAAQAܸRAA33AAHAApA(A
=A
=AA{A
=A33AHA{AffA߅A݅A߅A(A\)AA=qA(A
A=qAظRAۅAۅAAHAApA뙚AAzAAA=qA33AޣA  AңApAzAɮAGA\)A
=AУAУA  ApAGAHAAQA
A33AυAͅAУAυA
A33AAծAҸRApA\)AA
A{A{ARAAGA=qA  AffA=qAܸRA=qAۮA֣AAQAمAffA
AAظRAGAzAQA߮AGAA܏\A  AA
AA\)ApApA
AͮA\)AAAAAA=qAAA(AHAθRA{A
=A  A=qAHAAԸRA  A
AAAQAGAڣAzA(A  AڸRAGA{ApAҸRA
AϙAffAzȀ\A=qAAA=qA=qAƣA=qApAARA33AAA  A33AAAffAAA=qAAApAîAAA=qAңA\)A׮AHAۙAA  AA  AffAA  A{AzAQAzA{ApApAAAHAA(AƏ\AA(A\AřAAA{AHAAQAׅAHA{AA(A(AAGAϙApApA33A33A=qA\)A33AиRAzAхA=qAәAЏ\AzA(A33ApA
=AGA\)A
AARA33A33A=qAAzApA\)AA
=AAffA=qA=qAAHA{A\AAffAGAA(AAA33AQAffAGA
A(AAzAAÅA  A
AffA(A{AAAQAAQAA=qAHA֣AAA{AA  AͅAîAAA{ARA\)ApAA(AAGAffA33A
=AA
AA\A=qAͮAʣA33AA
=AQAîA{AA33A  A\)A  A\)A\)AzAHA=qA\AAApA33AA{AAA\A
=A33A(AA{A
=AAď\ARA(A(A
=A=qAffA
AHC8RA<
AffAҏ\A
AAGAAGA=qAA33ApAGAAzAď\AƸRA\)AʣAffA{AAAAΣAzAAGAHAAǙAAA{A33A=qAHApAѮAHAڸRAݮA\)A(A=qA\)AffAȸRA㙚AAAA㙚AQAGAffAHAHARA\)AzAARAzA\)AԸRA=qAAߙAAAHA߅A{AHApA=qAGAA33AAQA{A
AڸRAޣA׮A
=A
=AA׮AAA=qAAzAGAHA
=A֏\AAA֏\A
=A
AQAӮAיAQAQAA  AA  A\)AHAGAGAԣA=qAffA(A  AAffAzAQAAָRAAA  AzA(ApAڏ\A(A
=AՅAffA
=AAApAď\AffAQA(AəAA
A33A{AA{AAffA\)AAՅAAЏ\AzAzAA33A{AٮAܸRAݙA߮A=qA33A
AA
=AAܸRA(AأA=qA(AظRAAA
AAAAGA
=AHA{A
=A  A㙚AAܣAۮA33AAAAᙚAׅAՅA̸RA
AȣAǙAģAAÅA(AAHAȣAɅAHAApA(A{AQA=qAңAAԣAAQAffA33A33AQAGA33AA  AQA{A{AHAȣAQApA¸RAAAAQAA
A
A\A܏\A  AڸRAzAGA
=AzAHAA
=A{AٙAAffA33AՅAffAAAGAGAəAHẠAQAͅAQAͮA\)AЏ\A  AAυAAAffAffAHA
AHAHAzAA  AиRAՅA`QAAAݮA׮AGA=qAQAQA(A\)A\AAA癚A=qAffAzApA\)AHApAA(ARAAffAڸRAAAAHAۙAffAApAA
A33AQAA  ARA\A\A\)A{AA
A
=AzAGAQA֣AHA{AۙAQAAAHAAGAARAAAAffAAA  AGA  ApAAAAHAQAGA=q<<
<
<?#
?(???(?(?(?(?(?(?R?R?(?R?R?R?!G?R?!G?!G?!G?!G?#
?#
?#
?#
?#
?#
?&ff?&ff?&ff?&ff?&ff?&ff?(?(?(?(?(?(?(?(?(?(?(?(?+?+?+?+?+?+?+?+?+?+?+?.{?.{?.{?.{?0?0?0?0?0?0?0?0?333?333?333?333?333?333?333?333?333?333?333?333?333?5?5?5?5?5?5?5?5?5?5?5?5?5?5?5?5?5?5?5?5?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?8Q?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?:H?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?=p?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?@  ?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?B\?E?B\?B\?E?B\?B\?B\?B\?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?E?EAGAGA
=AəA=qA
=A˙AAGAAͅAͮA͙A  Ȁ\AAGA
=AHA
=ApA  AA(A=qAGAʣApA(A(AA(AA=qAA\)ApAQAARAffA\)A¸RApAʏ\A=qA
A
=AAAAffAߙA{AGA33A
AQA  A  AGA
AHA  A
=AQAAAAffA
A33A
A͙AQAA{AA(A  AGAЏ\AHA
A  A  A33A(A33A
=A
AffAA(AGAGAA{AQApAA=qA  A\)A=qA\ARAAĸRA
=A=qAAHAAA\)AAHAffARAAA(A33AffAHA(A{AA(AA{AffAAARAAAQAGA=qA£AԣAۙAڸRA\)AAңAAՅA=qAAAߙAQAffA=qA޸RA
AzAAffAAظRAA܏\A
AQA=qA
A=qAAAAffAAGAݮAՙAHA33AAzAۙAHAхAGAGA\)ApA
=A=qA\)AHAׅAHA\A33AApA  A\A=qAAQAAAA
AAzA\A
=ARAAA  AAARAHAAHAAffAAA  A
=AәAHAAA噚AzAAAzAAzA(AA=qAzA33A  AffA  A
=AA=qA
=AظRApAׅAApAۙAڣAأAGA(AAҸRAQAApA(AAۮA\)AAffAA(AGA\)AffAzAffA  AܣApAAظRA
AA  Aҏ\AA
=A(A=qAȏ\AzAAA(A(A(A
A\AzAQA=qAffAAA
ARApAA33AA
=AAAHA\A
=AAA{AϙA  A  ApA
ApAͅAApAAffAAGA\)AAApApAAzAAAޣA=qARAzAܸRApAA33A  ApAA\)AܸRA
AAA\AHA=qAARA(A\)AA{AHA܏\AGA33A=qA{A  A  ApApAAffAA
=A(AAGAffAApAAAAͅA\)AAffAǮA
=A
A(AAȸRAQAƸRAȣAǮAA(AffAƏ\ApAAAzAAGA
=AƸRAAzAAffAAAffAAApA  A33AA{A\)A  AzARAAzAAAAffAAAAHAAAzAޣAܸRAԣA33AHAθRAAأAAAHAAAHAAAARA{AA{AGAA  A\)A
=ARA{AA  AQARApAAffARAffA(AA(A=qA֣A33AәA
=A
A\)AۅA  AffA{AA݅AܸRA=qA(AܣAAGA33AڣAڸRA\)AApA=qAAGAHAAAA=qAծA(AA  AA\A\)A=qAQA(AHAAffAAAzAAA\)AAffA=qA{AzA癚A\A
=AA{A陚AGA
=A\)AAAA癚A  A  A{A=qAޣAݙA{A  A  AffAۙAGAظRAHA(AA33A(A{A޸RA(AAQAAQAљAϙA
=AA\)ApAΣAAAAQA=qAzAAQA=qA  A֣AA\)AA  A33ApAAأA{AA֏\AQAQAڣAAffAיAA
A\)A֣A׮A  AHAHA(AHAzAGAݙAA\)ApAA
=AzA
=AApA(AHA߅AHA33AAAAA{AߙAA{ARAAGAHAffA뙚A\)AAA33AApARA=qAA  ApA
=AAHA㙚AQA\)A=qAAHAHA\)AθRAQAA33AffAApA
=AA(AԣAծAHAQAٙA=qAHA=qA33AGAۙA\)AQAA{A
AzAAиRAffAAAAԸRAָRApAظRA
=AQAGA
A  AQA(AHAۮAHA߮A=qAAzAQA\)AzA\A{A  A\A=qAAхAAzAGA\AHA޸RA߮A{AAAݙAAGAGAA
=A{A  ARA\AAA
A{AᙚA(A뙚A
ARA=qAGAGAA
=A(AA\AHA
A33A܏\AAՅA(A=qA  AHA׮A׮AzA(A33A33AGAׅAffA֣A؏\A{AA=qA33A33AAAظRAڏ\A33A(A
=AA
=A=qAA  AA=qAAAQA(A33AffAAAA\A\AA33A33ARA=qAA
AQA(A(ApAARApAAAffA\AffAGA(AHAAAAA=qAA\)AAAA\)AGAA=qAHAޣAәA
=AA\)AQA33AzA\)AٮAA{AAAffA
AffAHAGAGA(AAӅA
AأAߙApAAAzAHAAAAݙA  AA\)AA=qA33AffA
AGA
=ApAzAͅAAHAۙAܣAۮA=qAHAffAУAHA̸RAA
AQAҏ\AQA\)AծA\)AAAAffAAApAڸRAA
=AffẠAЏ\AͮA(A
A͙A=qA  AAHAHAǮA  A
A{AӅAAAAQAAԸRAffAA33A(AӮAA=qAǅAA33AAQA33ARAffAAAA\)A¸RA=qAA(AîA  AffA  AffAHAffA=qAGAAЏ\AzA  AGA\A  A֏\AٮA(A(AAAͅApA  AHA{A׮A=qAЏ\AGAQA33AAzAAAřA  AAA
AԣAԏ\AA(A33AA
AzAڸRAHAzA(A(A
AAϮAŮAÅA
AϮAffA(A{A(AAA{A{AȸRApA=qAAAGA33A(AA  AAƏ\AHAΣA{A33AAA׮AA\)AQAHA33AAAHAAЏ\AHAAQA݅A݅AA\)A\A
A\AAA
ARAffAAQA
=A33AzAՙA
=AAARAzA(AffAAHAQAA33AffAҏ\AڣAܸRA  AA
A܏\ARA33AܣAڏ\AAQApAAәAۅAͅAffAϙApAAAAzAAظRAԏ\Aʏ\A\A\)A33A
=AQAAAۅAأAGAәA㙚A{AffAA{AQAîAAAÅAHA33AGAzAAƸRAAAAAÙA
=AAHAQAA
=A{A
AA\)AυA
AAAҸRAAAծAԏ\A33AAAQAA
=AᙚA=qA\A
=AAQAGAʣA(AAHAAffAAQAzARA(AAApA(AzAGA  ApAHA
AGA  A  AޣA=qAAA{Aޏ\A߮AzAۅAΣA̸RA=qA
=A
AffAՅAՙA(AAәA(A=qA֏\AծAGA
A(A  AԣA؏\AffA(ApApAHAHAܣAܣA{A{A߅Aޏ\A(AAAمAffA33A
AGA33AAۙAA\)AHAAApAGA
AݙA߅AA߅A{AA(ARAAAGAA
=AA\)ARA(A噚ARARAARA\)AzAHAAA33ApA(AGAAQAAQAA(=QA
=AA\AzAARAAzA33AAA͙AGAAAQA33AGA  A
=A33AA\)AřAffA{AA=qA˅A
AA33AHA(A(ApAGA
Aԏ\AHAڣA=qA33A݅A33A33A(A
=AAffA(A33AA
=AA\)AA  A=qA{AA{AApAݮAݙAڣAzA{A
AA=qAAA㙚AߙA(A{A
ApA33A
ApAAQAHA
A\)A  AAARAAGA33AQA
=A{A߮AA
=AAGA{AGA=qA{AA
=AA
=A(AʣẠA=qAAͅA  AQA
A=qARA¸RAAffA  A\)AHA\ARAA\)AQA  AQAffAԣAθRApA(A癚A{ARAA
AA\A  AAApAAAAAffA33ApA\AAzA=qAzA
=A(AQAARAA  AA\A
=AA(AffAQAAAAAA뙚A
A\AffA  A{A
=AQA33AAApA33AARAQApAA݅AHA{AHA֏\AAGAѮAffAAGAθRAͮAzA{AУAхA  A=qApA  AУAЏ\A33AzAAAڸRAzAffA=qARApAA=qA\AAA
=A\AGApAAHA\)A
ARAffAAffA(AQAQAA=qA(A=qA陚AӅA
AAA(Aڏ\A33AGAzA\)AAHAAHAAAAGAAA  AAzA{AA
AGAA
AA{AGAA=qA陚A=qAAA\AAAzA  AHA\)ApAA{AQA33AA33AQA33AAApA{A=qAQA(AA33AffAGA\)ApAA㙚AAA\)AA{AA
=A(AHAAApA=qAAA  ApAGAHAAA=qA\AffA뙚A\A癚AHAGA
=AHAAA\)AffA(AzAޣA㙚AHA33AA\)A=qAAHA뙚A33ARA
A(A33A\)AA{AA=qAA
=A
AA(A\)A
A
=AՙA\)A=qAܣA=qA
=AAݙAݙAݮAޏ\AApA
AA
AܸRA
=ApAAAAzAffA=qA؏\A
=AA=qA
AA(AA=qAݙAA33AA
=A
AAHAAAA=qAA
AAAffAAffAA=qAAQA(AApAGAHAAAA
=AܣAᙚAQA33AzAQAA؏\AGA=qA=qA
AAGAHAHAQA\)ARAARA=qAA33AA=qAffAzAzAA(AЏ\AθRAA\)AA=qAzAHAϮAѮAQAAңA=qAԣAGA{AԣAQA
=A{AхA(AAѮAхA33AУAA33AԣAGAGA{AԣAQAAәAA  A  A{AA߅AffAAQAzAGA\A\AA\)A\)AAA\A\)A=qAAGAAHAGAt  A׮A̸RA(A܏\A
=AAQA˙AQA=qA33AAAffA
=AAAمAA{AA\)AHAٮAǅAzA
=AθRAGA\)AHAQA  A\)A{A  AAAGAffA33A33AARA  AAAA(ApAzA\AffAAApAARA(AGAA
A
=A{A\A33AzA
A(AQAQAQAA{A(AGA33ApAAܣAAHAAAHA
AHARAGAθRA(AQApA\)A=qAARA(A޸RAQA
=AAAzAQAAHA陚AAHAffA
ApApARA{AA{AQAAA33AAA33ApAᙚAܣAأA{AApAҸRAQA33Aԏ\A\)A(AA  A{A(AAApAA(AHAAAᙚA
=AffAAݮA{ARAAA
=A  A
=AffAHAffA(AA=qA\)AAˮA噚AzA
=A  AQAAAAA(A(AzA33A=qAAAA\AAHAAAAffAQA
A\)AHA\A=qAA33A\)AA޸RAHAHAA=qA
=AA{AAHAA(A{AApAQA=qAGA
AA݅ApA֏\AzApAA{AQA33ApApAzAQAHAڸRAمA=qAڸRAAڸRAffA֣A֏\A33AݙA
AٮAffA\A׮ApApAᙚApAGAHAA{AA
A\A  AA
=A(A\AAGA(AA  ARA=qAQA(A(AzA
AA{AffAQAAA
A
ApA(AAAAߙAzAHAA  AAA  AA\)AAffA\)A
=ARAffAQA陚AA
=AAA{A33AAGAAffAzA\A\)A뙚AHA{AAAAޏ\A33AA֏\AA  AA
=AAAApAGA܏\AffAHApA{AᙚA33AAݮA\)ApAQA\)AAA(AffA޸RAAGAGA33AHAGAHAGA\)A
=AA{AffAzA\)AAzAffARAApA{AApApAA  AA
=AٙA؏\AAיA(AGA=qA\)A
A(AA\)AAzA{AɮA  A{A˙AǙA(AîAģA
AzAA=qApA\AA£AQAffA  AA
A=qAAGAQApA(AAHAʣA  AzAGA  A
=AGAzA33A=qAAȏ\ApAɮAAzA
AأAzAңA
=ApAAffA(AƸRA{AHA\)AQAAAAGAѮAԏ\AܸRAQAA{AÅA=qA(AAAA(AzAAA׮AָRAAA\)AffA{AAzAA
A(Aď\AQA  A\A\)AGA
=AƣAGAHA{AffAA  AzA{AAA33ApA\)A
AHA\AQA
AQAzAzA
=AGAA\)AA(AzA  AGAGAHAA
=AA{AAAAA{AAڸRAAAQAAHAffAHARAA
A=qAQAQAffAQAAGA\)AAGA\)A\)AυAAAA\)A  AՅAծA׮AGA܏\AٮAQAGAݮAGApAHA(A=qAGAGAHAGA
AA\)AA33AffAA
AƣAzA  AQAAAARA
A  AQA(AQAУAAA{A\)AHAߙAGApAAљA˅AAřA33AffA=qAffARAA֏\A
AzA\)AAAAffApApA
A(ApA\AAHA
=AA33AHA=qAA㙚ApAGA
A\ApA陚AA=qAAQA
=ApApAzAAAApA\AAAA
=AA\)AA=qApAQAA(AA\A\AA{A33AzA  AA\)AHA
=AAۮAծAٙA\)AљAHAGA˙AAʸRAQA=qAQAʸRAzAQA{A
AQA(AAHApA(A{AɅAHA
=AffA=qA͙ApAHAffA
=A\)AָRAzAߙAمAٙAAᙚAA\)AAAA\ARAA33ApAAffAHAAzARA\)ARARAAAAffAݮAAQAApA33A܏\A
=A33AHA  AARAzAA
A
AzAQAARAA(A
AzA=qAQAGAΣAΏ\A(A(A
A{A=qAA
A33AAAθRAθRAAθRAHAģAzAʸRA
=Ȁ\AA
=AȣAA
AHA˙A
AffAQAzAA
AzAAAARApARA߮AffA\ApARA
A(AAzAQA33A
=AHAәA(AGA33A߅A߮AAHAffAAQAA
=AARAzA
AA
A33A\A
A=qA
A
=A
A=qAA33AQAQAzAA  AAzA\AAGARA
A33Aԏ\AAApA\)AAA  AAA\ARA£A(AzA{A{A\AAÅAAď\A{A(AA\)A
=ApAîAA=qA\)AffA=qA(A{AHAApA{AǙAffA33AQA֏\A֏\AGA{A
AHAHAAәA{AߙAA33A{AԸRARA=qAA
A
=A
AAޏ\AݙAAޏ\A=qA
AffA
AQAAARAAA=qA\A(ApA(AA\A  AQAAHAA=qAAGAřA=qA¸RA{A(AApAzAAA
=AAzAA\)AAA  A=qAAǮA\)A\)A  A\)A
=AɮApA
AA
AAAGAA33A{AA׮AA=qAffA݅AޣA޸RAzAޏ\AAffA\)A\AAA33AAApAݮAApA=qAӅAHAݙAHA
=A\)AAHAzAݮA㙚ApA33A33AAA  AAAApA=qA=qAAA
AAAffA  AffAA33AɅAAAAŮAAGA
AAŅAAQA=qAffAGAAŮAQAzAQAzAAAǮAAzA
=A33A=qAAɮApAAA
AGAݮA33AAAA
A(A(AzA
A
A
AAGAHARARAzAԸRAܣA\)AAA
AAA
AzAffAQAA\)AzAA߅AA\)AGA陚A
=AAA\)AA
A(AGA33ARA{AzA뙚A(A33AQA뙚AQAGA
=A  AA͙AAAAGAAAGA{A\)A  AAAA
=AܣA
AA؏\A=qAиRAA
=AAΏ\AzAAΏ\AԣAAGAAA߮A㙚A\)AHAAAGAQA\AAA\)A
=A33A=qA
=ARAGAzApAffAAAffAffA  A
AzAA33AAAAzAffA뙚AAA
=AAzAQAHAAQAQAQAzA\AAA(A  AffARA33AA{AApAAQAAARAAGA֏\A33AҸRA33A33A{AA
AՅAAzAffA=qA܏\AQAzA
AA33AffA=qAHAHAffAAQA{A޸RAAAQA\A=qAQAAQApAQARAQARAA{AAApAA\)AAAGA  A{A\)A{A33AGAAAA=qA{AA33AAA홚A
=A(AHAAAA(A(AAA\)AAAAAzAAApA(A  AA{ApAAظRAڏ\A{AzAQA{AۅAHA\A
ApAAAA{A  A=qAAAHAHAAA{A{ARA
=A(AA\)A
=ARAA(AHA
A
AGA\)AHAA
ARA=qAA=qAA33AA{AA癚AQA
A
=AAQA
A33A홚A
=AzA\)AHAARAA=qAA
=AHAAA
=AGAQAzA陚AzAHApAAAHAA
=A(AA{AA=qAQA33A\A
ApAQA33A  A33AݙApA܏\A
=A{AHAAQAQAAAׅAA{AAAיA
AAzAffAָRA֣A33A=qAיAAHA
AٙAأA  A  AffAAڸRA33A
=A
AAAAARA\AGA\)A뙚AAARA=qAQAAA33AۙA=qAzA{A
=A\)AᙚAAzAA
AHAA{A܏\AAAGAхA(A=qAGA
=A=qA  A{AݙA  A(AA
=AHA\)A\A\)A
A\)A=qAHAʸRAΏ\AQA  AffAǙAȣAəAA  A  AGAǙAAQA
=Aȏ\A
=AffAʣAɮA{A\)A{AΏ\AHA  AθRAAՙA{AӅA\)A
AGAApA㙚AAAAA  AAA陚AffAAAA{A=qA
=AARAGAGAٙARAHA݅A
=AGAffAAzA(AAAHAAQAA
AA\A33AAAAمA33A  ARA
ARA(<A홚AAAݮAzAݙAAA
=A=qARARApA㙚AA  AQA=qAA=qA
=A(AA(AAA=qAzA=qAAGAGAA
A{ApAA
=A{A
=A{AA33A
=AGA{AQAA
=AA
=A(ARARA\)A\)AApA\A=qAffA\A
=AA=qARApAGA  AAAQAA\AA\A
A=qAzAHA\A
AApAQA{AQA噚A(A  AA=qA=qAA{AA=qA噚A
AHAQA33A
=AڸRAAٙAHAGAGA{A\)A
AمA{AAڸRAA33A\)AڸRAAAׅAzAA\)AQAffA(AA܏\AAffAݮAHAAffA陚AAAQA陚ARAAAffA홚A\)AAAAGA=qARAA
A(AAzAAApA=qAAA
A
=AHA㙚A  AA\)ARA
ApA
AA\AGARA\)A
AA33ApA(AHAA
=A׮A{ApAܣApAAمAHAܸRAzAQA
AۮAۙAڸRAzA(AQA\)ApA33ApAffAӅAљAGAA33AHA=qA33AQAzAAA
=AծA\)AAHA
A\)AzAA33AA
AAAA33AAAffAGAQAAffAQA
AAAAA
ApARAffAGA  AA  AAAzAAGAAGA{AA(AzARAAAAA
=ARARA=qAAAQA\A{A\AA=qAffAA(AAGAәA(AffAAzAQA\)A(AHAGAffA{AәAA
AffAԸRAAzAA
A=qAָRAzA
A  AՅAA݅A
=A؏\AHAݙAffA
=AzA
=A㙚ARAA\AffAzARA\AA(AA\)ApA{AAQAARApA\AA(AAffAAA\)A33ApAA{AARAAAApAzAGAzAffA\)AܸRAzA=qA׮AAHA\)A
=AڸRAffAڸRAظRAծAffAA(AffAAיAAمA\)A33A=qA{A  A  A\)AAأAA(AѮAAHAGA=qA
=A
AAأAffAԏ\AظRA=qAAۙAzA(AәAָRAHAApAڸRAQAAApAGA{AzA
A
A̸RAˮA33AHAAHA{AA  AAHA33AA33A޸RAՙA
Aڏ\A֏\AGA
=AϙA33AGAzAHAA
AׅAAAGAۅA  ApApA\A\)AA㙚AAAۙA߅A\AGAՙAڏ\AAAHAGAHAA
A(AHAřAGA33AHA\)A\)ApA33AHAGA=qA\)A\)A{A
A33ApAAAA=qAzAᙚAApAHAQAGA\A\)ARAA  A{A\A33A{AᙚAQA
AA\)AHApAA癚ApA
=Aڏ\AAGA
A\)A  AAzAGAGAݮAϮAGA{A{A=qAGAA{A{A  AAA  A
A\)A33A£A
=AHAAޣAGA  AzA{AQA\)AzAGA33AAAzAA
=AϮA33AAAGA{AA=qȀ\AzA=qAѮAڣAׅAظRAffAA(AݮA\)A\AA33A
A=qA
=A=qAQAffAݮAݮApA
AHA
=AffA33A\A(AQAzA  A  A=qAARApApAQAA
=A33AAA{AQA=qA33A33AAAAzA
AAAGA\)AzAAAAHAAHAGAAAffAAAffAأA{AGA(A֏\AA  AAA{AȣAAA33A
AffAA(AQAAApAAڣAzAՅAA
=AAӅA
AיAGAܸRAߙA㙚A  ApAQA(AAܸRA=qAׅAA=qAݮA{AGA\)AA33AGAHApAHAA=qA  AA
=A\)A{AڣAQAAAA(ApA=qA(AzAGA陚AGAQAffAzA\)A\AA=qAA(AzApAffAffA33AAݙAޣAQA=qA{AAA
AGA\)AA
AA
Aď\AA{AA{A  AAA
AA\)A(A\)AAHA{AA(A  AAA
A  AGA  ARAAAffA홚AAffAA=qA(A(AA
=AᙚA(A\AAA
A(AHAGAHAA癚A(A
=AAA噚A\AAAAQAA{AA  AApAQA뙚AA{A\A{AAzA\)A33AA뙚A홚AAGAA(AQAͮAAAɮA
AQAAQAffA  AθRApAAʏ\AzA(AGA\)AGAҏ\A(A{A=qAAΏ\AمA33ApAA33ApA
AAA=qA\AffAA  AApAffAAAAHAA\ARA=qAAA
=AAQA\AA
AHAHA(A{AAA֏\AA(AAffA  AGAAA  AA33AGAA(AA\)AHA(A33A
=ApA{A
A뙚A
=AA=qAA\A\)AAGAAӅAAAzAҸRAңAzA33AAA
=AәA=qA=qApAͅAffA33A{AzAΣA
=AzAAA=qA܏\A(AGA  A
=A\AAAGAQAzA{A33AAzAAHAAAA{A\)AA\AHAffAAAAA=qAA
=A
A  A=qA\)AHAݙAޏ\A㙚AffAffAffA=qAܸRA(AAApA33AAA(AA
AHA=qA33A(AAHAݮAQAGAԣAAQA=qAQA{A(AffA=qA=qA(AߙA33A\)A=qA=qA  AHAGAޏ\AAHA\)AApAQAA
=ApAGA=qAA33AAffAAHApAQA  A  AAA\AAQAffA(A
AAQAAAAQA=qAA33AA
=A(A뙚AAAAzAAA\AAQApAAAAHA
=AA{A
=AzA=qAAAAHAۙAHA=qAA33ApA
ARA{A(AHA؏\AAffAzA{AߙAHA\)ApA  A{AAQAA33AffAffA=qA=qAA=qAA{AӮAԸRAAApAAA=qA܏\AQAHA
ARA  AA(AAffA  AA
=AffAAApAA
=A\ARApA
ARARAAAQAA
=AAAQAAAA(A
=A33AA\)AApA\)AHA\AAQA\)AA33A
=AGAAAHA=qAARAAffAAAAAA㙚AffA=qAԏ\AңAffA(A
=AҸRAAӅA
=AAAAAӅA
A  A(AԸRAAQA(AGAQA33A33AQAҸRAGAظRAffAzA
=AApA(AQAzAAܣAzA֣A܏\AۮA(AԸRAA
AQAffA{AAzAA\)AAA뙚AAQAAA=qAzA\)AffAzApAA=qAAQA
AHA  A33AzAA33AAzAHAHAGAHAA\A뙚A
AffA
=A癚AGAApA33A(AzA
A
=AۙAݙAA
A  AA
=A
=ApA
AHAޣAGA݅AA(A{A
=A33AffA߮AAAzAGA(AzA(A\A=qAGA\)AAAzAA
AAffAQAARApAGAA{AHAAAAAA\A(ARAA\)AAffA=qApAAffA33AAA\)ApAQA=qAA{AA\AA홚A(AGA\)AAQA\)AA
AGAffARA33A(AA
=A=qAA
ApA=qAиRAυA
AffAA
AиRAθRA\)AA=qAAљA{AָRAffAՅAԏ\A\)AA
=A(Aҏ\AAϙAffAѮAA33AAمAAAڸRAzA\)AA\A33AHA33A
AAA=qAffAGA{AAA33A癚A
=AHA33A\)ARAAzA  AQAAGAffA  AAA=qA\)A33AA
=AGA\A\)A(AAA(A=qA\)A33AAA33AffAA=qA{A=qAAzA\)AQA
=A  AGAzA
=AمAA\)AHA
=AAA֏\AzApAApAAQAڏ\AAzAٙA  AA
=AAA33A33AHA=qA(A=qA(AAA  A=qAޣA{AAA=qAָRA=qAA33AzAzAAHA
=A\)A\A癚A陚ARAzARA뙚ApA{A陚A33A
A
=ApA߅AARA{A
A{AHA33AۙAAA=qA{A(AAAޏ\A33AzAAQAQAAڸRAAݙAGAA͙ApA
=AʸRAffAAffA
AzAA33A(AQAͅA33Ȁ\AͅA̸RA˙AGA33AAQA  A
=A݅Aڏ\AffAڸRApAA{A{AGA܏\A
AAޣA=qAޣA{AQAAAA  A
=A(AA\AأA{AAA=qA
=A  AAAՙA
=A\)AA(AffA
AGA  A  AA{AA
A33A=qAffA\AA33A߅AٮAzAAGAAGAAHAAA{A{AffAAΣA(AЏ\A
=A=qAzAAиRAApAϮA  AQA\)AGAΏ\AθRA{AQAGAAApA噚AQA=qA  A(A
=A  A\)AGApAAzA{A
=AA33A(A噚AHAAQA癚A=qAGA癚AzA\)AA
AGA\)A  AAGA
A33A{A(AQA\A\A
A\)AzARA33AA\)A33AA
=AAA噚AffAAGA\)A(AAAAHA
AQAAڸRAQAAAAܸRAHA=qAzAHAAԣA˅ApAѮApAQAәAGA33A؏\A
=AQAAAAAAQApA33ApAA  AAQAA홚A  AAAAA=qAAAffAHAApAQA{A=qA\A  A=qAAA
AA
AA{AzA33ApARA(A=qAAffAHAGAAA
=ApAAA(AAAQA홚A\AffA  A=qAHA(A33AHAAffA\A
=AGAУAA=qAQAAzA
AA\Aw
A`AtzAUA~ffAEAeAwAf\A{AAo\)ArffA:{A4z@
@\@  @Q@33A33A)A (A
=A(Ap@p@(@
@33A=qA@{AA=qAQAA
AQA\)AAA
=A A#A(A7
A<A=AAA1APA6\AO\)AiGAVHAh(ApzApAArRAyAp  AA33AqA<
Ao
A}AAr{AzAHA33ApAdAgAoAzA{AT(A}AAS
A\QAeAPQA:ffApAAAffA\)A\ApAAvHApAqAnRAqA~ffA
A{\)AmAX  A>{AF{@2\AvRAAGA(AQAARAzA  A{AffApAA  A33AAGAAzA
AHApAGA=qA\AffApAAGA\)ARAA33A33A\)AffA=qA\A
A  AA33A=qA
A܏\AHAA=qA33A
A(A
=AQAřApAA  AzA
AffA
=AA(AAGAQAA=qA\A  AAA33A\AAHA  AQA\)AAAHAAAA\A{ARAAGAA
A{AHAQA(AQAA33A  AAϙA
=AAϙA33ApAzA=qAffAHAApA33A
=ApAAAzAGAA=qA
AGAAzAΣA=qA  A؏\AHAffA߅AܸRAQAzAAAQAۅAHAzA=qA  A  AA(A{AGA
=AAA{AۮA=qApA{A֣AzAAхAУAffA\AA
=AϮAߙAffApApApA33A\AHA  A  A
AAAGAAAAffA
=AApAHApApA=qARAAzA
AAQA=qA33A
AA
AA(A  AA(AQApAޣAAAA33AGA33AA  A
AA(AHAA(A؏\ApAAҏ\AAzApA(A(A(A\ApAݮAAAA33ApAA{A=qAAAAHA(AʣA{A
AхAzAAzAڏ\AۙA
=A߅A޸RAA33A33A=qA(AңAƣApAzAAHA  A{AAңAzAәAA\)AGAQA(AAA
=ApAGAApAffA
=AzAHAApAܣA=qAٙAQA=qAAA\A{A33A33A\)AffAAA\AAAᙚA
AA\)A
=A޸RA{AAA  AQAA߮A33AޣAޏ\A  AAAAQAGAGA(A\A=qAA܏\AۙA\)Aԏ\A{A=qA{A˅A=qA\)ApAͮAAQAɮA=qAAAQA
=AͮAϮAAzAAzApAGAԣA
A  AffAԣAAzA
AzAHA(ApA
AͅA
AAGAHA\AA=qAzAAffAzA݅A݅AAA(Aԏ\ApAAAәA֣Aޏ\AݙApApA(AA߅AAAARAAffA33AՅApAA؏\A
=AAA׮AAffAمA
AA
=AQAAAffAzA(AQAޣAA  A܏\AHAܣA(A{AffA݅AAA܏\A݅A=qA(@=qAA݅AAHAיAffA֏\A(AϙAAHAzA33A  AAQA֏\ApAAޣAۙA{AA{ApAAA
A33ARAAݙAA{A\AffA陚AHAҸRAA(A
=A܏\AAffAA  A=qAzAffAAHAAzAAQAAA
AAݮA\)ApA(AffAA\)AAGAA\A
=AQA(A  A\A{AٙA
AAQApA33AîAA
AffAƏ\A(AAffAƣAAǮA
A
AzAzAȏ\ApAAAzAAA@tzAɅA
=AApAAۮA=qA߅AQA=qAAGA(AHAHAQAAffAHAAQAQAAAffA(AGA33A=qA
A
A
=A\AARA\AQAApA=qA\)AffARA\)A{A
=A\)A=qAۙAzApA\)A֏\A  ApAAᙚApAAܸRAԸRAA
=AzAHAA(A
=A(AQAA\A{AARAAA
AffA  A\)AA\)AAQA33AA=qAA
AAAA\)ApA\AA{A33AHA\)AHARAzAGAׅAԣAA߅AA\)ARAAffAHARA\A{AAQA{A(A33AAA(AGA
=ApAffAAA
=AA=qA\AAA{AAAAGAA  AAHApAHAA  AAffAHA
=AA(AA޸RAԏ\A
=AA(ApA33AAffAzAzA\)AAzAQA\AARARA(AA  AARA\)AGARAQApA33AAAffAA\)A
ARApAAzA
AAARAffAAAApARA\AA33AAA  A
ARAQAQA33A
AAzA
=AA{A
AAAAzAGAHAAQA\AAHA\)AffA\A=qAA  A{AGARAGAHAzARAA(AzAA{A{A\)AAAAAA33AQA=qAA{A  A  AffA{A33AAQA{A뙚A
=A\A\)A{A\)AAA陚A33AAzAAAffAffAGAGAApA(A\AAAAzApA
A\A\)ApA33AARA  AffAAAA홚A\)AA33ApA  AA=qA=qAA=qAA\AA(A
A
=AA  A\ApApA
A=qA
=AffA\)A
AffAzAA  AAA
=AGA\)A\A
=A(AzAHAܸRA\)A֏\A
=A(Aم@A  AzA
=AGAAԣA(A@  A֏\AAָRA33AHA\)AڸRApA{A
AՙAAHA{A=qA  A
=A
=AQA(A\)AAGAظRA
=AA=qA؏\A
A
=A(AAߙA
=AAAA33A
=A  AQAAA
A
A{A(A
=AApA(AݮAffAأA
AڣAٮA  AAHAAA\)A(AA{A
=ARA{AQAAAA\A홚A  AAAffAApAffA
=AݮAظRAzAA{AAzA=qAAA{AיA
A؏\A
AQAԸRAzAAGAڸRAڣAۙApAA
A  AAޣAAHA\)ApA33A{AffA\A  A(A\AߙA\)AAHAzAA{AA(AAAGA
=AA{A\)AQAAAARA\)ApAA  AA=qA33AA{AA=qAAAAAA홚AA(ARAAARAffA\)AQA  AGA  A\)A\)AA{AQA=qA=qA\)AڸRAGA
AAffA33A=qAAffARA  ARA{AAzAGA\)AGAAܣAA(AAffAAߙAA  AA噚A
AA㙚ARA
=A(ApAQA33AA=qAAAHApAGARAffA㙚A
=ARAAHAA\)A
=A=qAffAAQAAffAAA
=A{ApA(AHAAAAGA\AHAA
=AzAzA\A{AA  AApA33AHAARA33AAA陚A{AGA癚AHAApA(A  AָRAA=qAA  AΏ\A
=A{AծAQAA\)AәAծA(AHA\)A֣AQAA
ApA=qAffA
=AffA  AGA(AָRAAzAQAHApAڏ\AffA33A{AA\A{AA\)AAAAffAHAA(AA(AzAAAA\)AffAᙚApAffA
=AffA\A
=A  AAQAA(A(AzAGARAA{AAARAQA
A\AHA
A(A߮AAݮA
=AAAA
=A  AA\)AffAA33A33ApA=qA(A{AܣA33A
=A  AGApAAߙAffAffA
=AAAAApApAAA{AffAzAA\A\)ApAzAAHAQA
A=qAAzA(A陚ARAAzA(AA33A(A
=ARAAA  A
A
=A  AARAAAAHA{A(AAAzA=qARAAAzAAAQA=qA  AAffAA(AQAApAAffA\)AAQAGARA
=A\)A{AA  A
=AQA33A
ApApApAGAAQAAHA=qAAzAA\ApA33AGAA  AAzApAAzAAAzApARAA  AA  AGA\)AARAGA  AAQAAzAAA\AAzA
ApAHAGAGAzAAQAAzApAAzAAAQAAAGApA  AzAAQA
A\AQAQAA{AA{AA\A(A
=A33A
AAA\)AffApAAHAAGAAۅA  A
AHAzA\A(AAAAAAzAAHAAAAA33ARAA
=A  AARAffAAA(A{AAA=qAAA=qAAAA(AzA
=AQA=qARA{ARA\)AA  A\AzAAAA
=AA陚ARAA=qAAAA{AA33ARA=qA\)A  AA뙚AGA33AffAAApAzAGA
AHARA33A
=Aޏ\ApAGAAzAمA
=A=qAݮA޸RA߅AffAAAA
=AA  A(A
=AڸRAAAAAApA陚AGAA  A癚AGAAQApAA{AAzAAHApAzA뙚A  A
=ARA\A  A뙚A\ApAAffA
AA33A(A\A  A
A
=A
A=qAAAHA33AApA33A=qAGAzAAQApA홚AAzAAQA=qAAffA33A\AA{A癚A{AA\)AQA\)AQA\)AAHA{A\)ApA\)A=qAAHARAApAApAARAA
=AA(AApAᙚARAAGAAA=qAHAA\AGApAHAA\A=qA{AHAQAAHAffAGAAA\)ApA뙚A=qA(AHAAQAGA33AQAAA{AAzAffAHARAApA
=AHA33AA\AAAAzA홚A\)AAA=qAA(A
=AApA
=AQA\)A  AAۅA\)A
AQA޸RAAGA{AQAA\)AA{ApAAA  AffA  AffAA  A
A  A(AA=qA(AzAAᙚAޏ\A噚AA\A{A
=AAGAHAAQAAAzA\)A(AA  ApA\)ApAAffA{ApAAAAAQA
=AGAA{AAGA  A\)AA  AHAA33ARAffAA33ARApAQApAAA\)A(AAA=qAA
=AAA\)A噚AzApARAzAGAA;ARAAffAA\)AARA
=A\)AAAAQAA@l(AA
AQAGARAQAA(AA
AffA\)AAAAGARAAA=qA  AQA\AA{A{ARAA\A
AAHAAHAAAARA\)AQAAA\ApAHARAA=qAAA(AA  A33AۅAAApAA{A33AA  ApA=qA{A
=AzAAAAAQAAzAA=qARAffAffAAzA噚AffA
AQA33A{AGARAAAA噚A(AA
A(AAGA=qAA  ARAA  A
A
AAARAffAAApAAA(AAzAzAGA
=AAA{A{AQAAffAA=qAAA{A\)A=qAQApA
A=qA(AAApAAAAGAffAffAAAARAGA
A33AA\)A33AzA
A{A(A
ApA\)AffAA33AA33AAzAzA33A
A\ARAA=qAGAHA{A
=AzAQAAffAzA  AAHA  AA\A\)AHAQAA
A(A{A33ARAA(AQA33AA
=A
=A
=AApAA
=A=qAAApAAApAA{A33A\)AHA33A
=AA=qA33A33A\)A
=AAAA{AAAQA\)AAAHA33A  AzAA
A  A\A\)AA33AffAffA  A  AA\)A=qAzAA?A
A33AGAAQAA33A(AA=qA{AffA33AAAzAAA=qApAA
=AApA(AA=qA  AAzA(AffARA33ARA=qAAAffA  AzA33A\ARA
=AA{AA33ApAA\A
A  A=qA33A
AffAAAHAzAA{ARAAQARAffA(AAAzA=qAzAffAzAzAApApAHA  A33AAAQAHA  A  ARAGA(AHAA  AAA
A33AA
=AffAAffAA  A  A\)AA(A\AA{AzAAAHA
ARA\AA
=A뙚AGA뙚A
=A
=ARAGAAAAAA
A33A
AAA
AAGAAA
ARA
AARAA  AGAQAQApAA=qAAffAAQA
A(AA\)ApAAAA  AffAAHAAAA  AAA=qARAAAAA33AܸRAᙚAzAffAAA\)A
AGA
ARAA=qAQA  A  AA
ApA\)AGApAA  AzAffAHAAHA(AQA{A
AA(AApA
ApA
AAAzA{ARAA{A33AHA  AAGAzAffAAAzAAAApApAAffApAAAApAHAA{AzAA\AAQAQA33AAAApAARAQAHAAHAffAAAzA=qAQAHAz@
=AffA{AAAAAQAA{A{ARA
AApAA\)AA
=AAA\AA  A(A  AzAAA
=AffA
AA{AA
A33AAAAGAffAAGARA
A\)A{AffAGAA
=AARA{A=qAAffAA\A33AHAARAAA{AAGAA=qAffA  A{AQA{AA(A{A\AffAHAAAA=qA  AAAAAAAAffA=qAAA{AAA{AzAzAuAAA\)ApAzA
=A\)AA33A33AAAA{AAAAzAARAA\A{A
AA
A{A\AAGAAzAHAAAApA
=AAGA\AHAHAARARAGA
AQAAAAAAzA
AA
AAAAAA=qARAAA(A\)A33AAzAAffA  AffAA\A  A@AARAGA=qARAzA\AQAAAGA\)AA
=AffA33AAA{AffARA
=AA33AA홚AA\AA
=A33A33AAzA  A\AHA\)AA
=A33AGAzA\A{AA\AffA(A33A\AARA\A\)ARAAAAAA33AA  AzAQAHAA\A\AAGA\)AA=qAAGA  AA(AAARAAAQAGA=qAGApAAAGA
A
AAA\AQAAHAA=qAAQA=qAffA{AA\)AHAAffAAA{AAHA\)A(AQAA  A(AffARAHAA(A(A\)AA{A{AA(AAffAAARA=qAAzAARAQA
=A33A\AA33AAQA
=A
AA(AHARAzARAAA\A{A{A
AA\AA33AARAHARAA{A
=AAQA(AARAQApAffA(A7
AHA  AAAAA
AA\AAHA  A(A
=ApA{AA(AGAHAHA\)A
=AzAQAA\)AAAHAffAARAAQA33AAzA\AARAAHAQAAARA{AAA=qApA  A\)AA
AA
=AffAAA{AAHA{AAGAAA
AA  A{AAHA  AHA33A  AA\AHA  AA\A33AA\AAA
A{A{A홚A{AAAAffA
AffA@AA=qAAA(AA
A{AQAA{AAHAAHAA\AzAA33AffAHAzAHA33AA{AA{AAAAA{AAAAHApAffAQAGAHAGA\AAAHAAAAAA
=AAGAGARAA
ApAAA(AffAHAAGA홚AffARAHA(AA=qApAAAQA
=A{A\A{AAAAzAAA=qAA=qARA
=A\AffARA=qAAAAA  AA
AffAAA  AA=qA{AAAzA(AQA  AzAHAAAHAffApAAA\A홚AffAAQAHA\AHAAA\)A\A\AQARA
=A=qAA
A\A=qAAAQARAHAAAGAQA  A
=ApAGAA  AAGAA(AA33A{A(A33AAA\)AffApApAzA  A(AAHAAA\A33A=qA(AA(AAA
=A(AA\ApAHAzAARApAA=qAGAHAA  A
=AffAApAGA{A  A
AAzAAAA{A  AAAAQAAA{A{AAffAQAAHAzAA
=AGA(ApAA33ARA=qAzARA
=AHA33AAAffAA=qA
A
=AA\A\AAAA
A
=AAAA\)ARA=qA=qARA{AA
=A\A\AGA(AzAHA
=A33AQAAAffARARA=qAA
=A
A(AAA\)A\AAAzA
=AHAA=qAAA噚AAAAApA{ApAA  A  AA
=A  A
=ARAAGAAffApAAffAAA33AAzA\)A\)ApA\ApAA\)AA  AAAHA33AA߅AA{AzAffAffARA=qAA  AzA
=A\AzAAAA{C
u<
AA
=AA=qApAARAGA  A  AAQA
ffAܣA{AٮApAHA@ffAAffAAٙAAAHAأAۙA33AAݮAӅA  AHAأA؏\AܸRAffA33A=qA
=A
=A\)AAQA=qA{ARAApARA(AzAAAAA陚AAAGAAAApA\)A癚AHAzA  A
=AAA陚AA\)A=qA\)A  A  A{A\)A(AAffApApAffA陚A33AARAA\)AARAzAGA  AA\)AA33A\AGA\)A{AAHA  AAхAffAAәAGAA
=AQA  AׅAzAԣAAzA(A
AQApAծA
=A(AAARA=qAA{A(AA33AA\)A  A(AHAAHAA\AAA=qA(AzA=qAQAיAߙApA\)A{A33A(A\)AA\)AAA
A=qAA\AHA\)AAA
=AHAAAA
=A
=A=qA33A
AffA
AQApAffA
A
=A뙚AAffAA=qAٙAAծAQAQAAҸRAAHAA33AAHAظRAffAAffA
AAAAAzAAQAיA(AAAAAffAۮApAQARAApA
A\AAAA{A{A
A(A=qA33A\AAᙚA  AffApA\)A  AGAAQA\)ApAGAAtQAA{ApAA{A=qARA  AA
AApAAAA  ARAA
=A\A=qAA
=AffA(AAzAAzAA{A\AzAAAARAQAffAQAظRA(A=qA\)AAAHAAׅA
AAHAQA׮A
=A׮A\)A33AܣAApA=qAAA
AA(A  AApA(A\AAA
=AQAA33A\)AzAAGA\)AAARAGA  ARAA{AzA  AHAA\A\)A{A\)AAAHAA(AA(AA
A(A
A
AAA  AGAffAA\)AA\)A=qA\)ApAffAAA{A홚AAAffAQAAHAׅA
=AәAAυAAQA{A\)ARAA
AAAA֏\A\)A(AA=qAA(AHA33AzA\)AGARAzAAAAHAAzAAAAQARAA\AA{ARAA
AAzAAA\AzA
=ARAA  AA\AAQA33A33AARA33AQAHA
ARAAAzAA33ApA\)A
=A=qAAA\A(AApA(ApAAA33AA{AQAGApA\)AAQA(A
=AzAA癚A33AAA\)AA
=ApAA\AAHA
AAA\)A  AA33AGAA{A(A  AApAAA  A{A{AGA  AAAA\)A
A33A\)AHA\)A=qAffAA\AA  AA{AGAAAAA
=AQAHAffA
A
=A=qAA\)AffAGAAA33ARA{A=qA33A(A33AGAHAA{AApA\)A
=AGAAA
=AAA
=A  A\)ApA癚A=qAAQARA=qAQAAGAzA33AA㙚A
=AffA  AA
AApA\A=qA\)ApAHAA\A
A\AAzAAA33AAffAAA(AQAA=qA33AffAAAAA{A33AA33AA=qAAffAffAQAAA=qAAAA  AzA\)AAQA\A  A{A33A  AffAffA(AA(A\A  AAQAA
=AHA  AAzA  AA33A  A(A  AA
AGA{A33ARAAzAQA33AAGA
AAHARApAHAAffAAGA\A  A33A=qAzA
AAffA\AA(AffAQAQAGAffA\)AAA\AGA{A=qA=qAA\AffA\A{AAffAA
=AA(AffAAA{AHAAA\)AAA  A
AzA
=ApAAAAAAAAzA33AAAffAzAzA\)A(A33A33AzAAAAA33A
=ARA\)A(AQAA
AA
ARA
A  AAA
=AA\)AA\)AAAAffA
A  AA홚ARAGA
AAzAAffA{AffAQAA
=A33AQAARAAGAA(AAAA\)AGAGA(AAzA33AAA
AAAAAApAAAARAAffAA(AHAA=qA  ApAAzAApAA33A
AQAffAA=qAA=qA\A\A\)AAQAA\)AAAAA=qApAA33A(AA(A{AAAzAHA\A
AA{A{A  A  A\)AAA33AA\AAffA
AHAA(A{AA  A  AffA\A
=AAGA=qA{ARA
AA  AA  ARAHAA=qAAGAA{A\)AA\A(AAARAffAA(A癚AQAGA(A(A\)AzA\A{A(AGA\A=qAA  AGA(AۮAHA{AzAGAAA
=AՙAAأA=qAAظRA
=AAQA
AיAQAGA\)A{AGA33AܸRAיA  A{A
A
AffA\AA뙚A  A=qAQAA\A{A
A{A  A
=A{AA\A33AAA
=A(A(ApA
ApA33AAHAAA(AA  A{AA33AA뙚A  ARA(AzA33ApAffAGA
A
=AHAA
AA\ApAA\)A33AA\)A
=AA홚A  AApA  A\)A{A  AAA
A(AA=qA{A  AARA\AAffAffA\)AzAGA  AA  AAARA=qAAGA{A뙚AAA  AzAGAApAAA  ARA{AzA\)AAAzA\AA
A(AffAAA=qA33AQAA\A{AffAA=qAA
AApAffAAA\AGAGARA\AApApAffAffAARAA(A\A(AzARAAQA=qAzAzA
=A\)ARAffARAA
=AAܸRA33AGAffA{AffAA
A\)ApAA  AۙA33AA
AQAĸRA
=A
=ARA=qAA޸RA{A33AAffA  A{A£A33ApA{AQAǅA
A(AAA33AǮAAA
A33AHAQAA\)A{AGAٮAУAHA
=A
AGAHApA  A\)AHAA
=AHA33AθRA(AA̸RA33A
=AHAمAϙA  Ȁ\AAA£AîA=qAAffA\)A(AAA(A
=A\AGAzARA  AGAAיAApAAQAAA
=AARA(A
AAAAffApApAHApAAzAGAQAɅA=qAAA(A(ApA  ARAA
=AQA
A£A\)AHA\)AAAHAAQAzA¸RAÙAîA(AHA\)ARAAGA
AzApApAHAӮA
=A=qA33AGAθRAzApA؏\AAAAAAƏ\AƏ\AAzAHA\)A(A33AQAA=qApAAQAAARARA\)ApAA(A(AffARAA\AA
=A\)AA
=A
=AA{AA33A
=AAAAA
AAʏ\AAA(A  AəA=qA33AA{AA33A=qAARAffAAA(A\)AA=qAA  ARAA=qAAAAQAffAA(A
A  AHAAAAffA\)A\)A
AffA\)AffAʣAA¸RAzAA
A\AÅA
A=qAGA
Aȏ\AɅA
A
=AƸRA˙AAQAAA{A\A33AAA
=A{A
A33AApAÙAffA33A{AHA(AQAܸRAffAQAәAAHA  AAGAAݙAffA
=AҸRAAHA
AffAQA\)AA(A
=AظRAHA\)AffAAAQA֏\A
AԸRA
=A=qA
AAҏ\AHAԸRA\)A{A(A  A  AمAzA
=A\)AиRAƣA֏\ApA33AApAԣAڣAA
=A33A(A\)AffAA  AA  AA{AGAffA{ApA噚A݅ARAffAzAA\)AٮA=qAҏ\AЏ\AՙAffAAGAծA33AGAAܣAܸRA
AHAA33AՙAׅAޣAA(AأAӅAA{ApA\)AAڣAۅA=qAA{AApAA
AzA  AׅA(AAԸRA(AAA  AQA=qA(A\)A癚ARAAAAffA\AAA
A  A(AQAAGA=qA\AzA
=AAGA\A  AQAffAA
=AA(AA
=A33A{ARAAAAA  AGAffA
AϙAA  AңAمA=qA̸RA=qAQAA
AA(A=qAQA  A̸RAA\ApAޏ\AHAA뙚AAA癚A{AzA뙚AHAffA(A홚AA뙚AA=qAA33AAߙAAᙚAzA(A
=AA\)A33AAQAzAffAAA=qApAA
A=qAGAffAA(AA=qAAffAA
=AAQAAA޸RAڸRA(AܣA(AffAGA\)A\)AׅAݙAAٮAHAHAߙAܣAHAA
=A\)AA=qAA
=AffA=qA\)A\)A(AܸRA(A33A=qAAffA  AHA߅AHA(AA\)A
=AAAQAAApAAHA=qARA  A(A{AzA\AAHA
AAAffA33ApAۙAᙚAApAAٮA33AGAٮAݙA
A=qA{A޸RA33A
AAA{AGAzAffA(A\A=qA  AAHA{ApA
A33A(AQA33ARAARAAAAAAffAGAAAޣAA\)A
=ApAGAיA(AApAAQA(AAHAAffA{AApA=qAA  AGAA
=AޣA
AA  AAAAHAQAA=qA=qAA
=A噚A\)A
=A(A\)ApA33AAHAffAffAA\)AAA
AAARAHAHAHA
=AAA33A  AQAffARAARAHA\AGAAzAAGA=qA(A
=AHAffA  ApAApAAAA  AڣAQA=qApA׮ApAA
=AܣAffA{AQAAAݮAzA
AAQAׅA׮AHA=qAQApA  AffA=qAծAAхA(AAAA{A\)AңAffAffAŮAA  AA
=AAQAA  A{AظRApAϙAA(AԣA{AۮAۙAڣA\)AA
AA{AAᙚAGAA㙚A{ApA
AQAAAGA\)ApẠAQAAՙA33A33AAA\)AЏ\A
=AzAAQA
AffAA(AffAApAA=qAAGAffA˅AQAȸRAAAAģAŅApAȣA=qA=qAzApA=qAA{A
=AA(AAљAffAHAͅA(AGAݙAffAڸRAՙA֣AA  A
=A\)ApAQAծAHA\)A{AAHAffAݮA߮AڣA=qAٮA=qA(A݅AAzA=qA{AAA=qARA
AGAAAHAApA޸RAGA=qAffAGAAffA  AffAAA\)A\AAAA\AAA=qAHA
ApAA\AffAHAHAzApAAҏ\AAԸRAӮA33A(ApA{A
ApA  A
=A  AQA33A33AffAѮA
A33AApAAA\)AݮAA(A݅AQA=qAA\AzAzA\A\)ARA{ApA뙚AAzA
A{AAܸRA޸RAAzA
AܸRA؏\AۮA{AۮA
=A
A\AApA\A\)AAܸRA\)Aޏ\AffAGAA{A  AAA(A=qAA
=A
AA\)A  A{A33AAA(AA
=AAA\A
A(AA(A=qA\)AAΣA
=AQAARA\)AffAGAѮA
=AAQAA
=A(AA(AA͙AŅAAA  AѮAޣA
=AظRAzAGAٮA  AGA
A\AA\AA\)A=qAIpAAAA}A  AA:RA|AaGAuAdAkAZRAl(AAGA^\A^HAAAFRA0QA|A*=qA?AJ{A&=qAEAXA zA%A6ffA$QA,zAO
A(AffA{A\AR@33AA3\)A2\AC
AQA6HA"RA
pAAR@
=@Q@\@@@@@z@
@  @ff@ƸR@\)@Q@@z@@R@z@\@@{@@Q@G@s
@@
=@=q@\@@u@@@@@@A (@@qG@Mp@H@}p@g
=@jH@}p@H@Q@33@@~R@tz@@p@Q@@fff@z=q@A  @
@33@@Q@@n{@33@=q@qG@33@\)@HA
@
=@Q@Q@\A
HAQAA\)AHA"HA((A,QA4A1A5A'A$A,(A4  A5GA1AAA)A  AGA%pA+
=AQA(@pAAffA@zARACA#AGAA0QAF{AEA6ffA=GAVRAR{AMAP(AW\)A[
AYAcAaA^{AeA^HAcAW33AcAg\)As\)AzRAxAr{A\)Av{AvHA{AA{A=qAARA  AA(A(AAAHA  AQA{AA  AAA=qAHAAA  A{AHAAzAAA(A\AAQAA\)AffA{AAA  AAA
AA\)AzAffAHA=qA33A=qA{ApAffA  AzAHA{A
A£ApAA{AQA{A=qAAAA33AHAA\AAAAA  AAAApA
=A{A  A{A  AA
AAHAA͙AA33AəAA
=A33AffAAzAЏ\A
A  AQARA  AA=qAzApAA(AzAA  A33AAA
A
AA
=AA\)AQAAAȣAAA
=AA
AAffAQAA  A˙AGA(A\A33AAA\ApAzAA(AAHA\)AQA33A\)AA{AAAGAzARAAA~\AdAW\)A\A_33AapAh  Aj\Aj\Al  Ac
AqAmGAwAw
A~=qA{A|QAzRA\)A=qAHAAGAAAA{AAAAApAA|AAAA
=AA=qAAzA{AzAffApAAQAAA
ApAGA{AffA=qAGA33A(AA\ApARApAA\A33A\)AAtQAffAuGA|AnffAz=qAgAupApAAA\A
=A|QAHAA\)AQAAAAA33AA~\A|zAtAo\)Ar{Ao
=AmAgAaGAl  ArffAGA~{A\)Ao33ArffA33A\AffAAHAA{AA(ARA\AGARA  A\)Az=qAzHAffA  A=qA  AA{33ApAApA{AAARA
=AAAApAQAA~{A{33AuAupAA|(AzffA|QA{A|(AA}pAuGAn{AsA=qARApAzAAQAA{AnRAA|An\Az{A}pAAA\)AA
=AzA
AeAhzAZffAW33AUATAXQA[\)Af\A\)AA\AAAAffAAARAAAAA=qAApARAffAGA\)AA  AAAA  A33AARARAAA\)AA
A
=AQA
AA
=ARA\)A(A
=ApA\)AAAARA(AffAzAzAA33AzAAAGA  AA\)A
=ApAA
AHAApAA=qAQAA(A\AAzA  A
=AA  AzAA\)ApA\)AAApAzAAAA
A(A\AAA33A  AAffARAAARAA(A{AGA
AHAGApAzAAAQAAffARAA
=AGARA
=A
=AAA\)AHAA
=AAA{AˮAzA33A  ARA̸RAģA
=AQAA(ApAQAGAAAARA=qAHAAAzA33AA\A\A  A{ApAAAAGA
AA
=AA{A=qA{AAzA
=AGAGA\)A=qAAzAΣAA=qApAޣAAՙApAA܏\A  AϙAffAиRA{AÅAQAA
=AffARAAA\AAGA=qAΣA{ApAAڏ\AΣA  AHA33Aʏ\AAƏ\A͙AAffAA(A{AAẠAGAAAAʸRAzA\A  AzAЏ\AGA{ẠA
=AAA=qAARAAGAGAA{A  AAAzAffA
=A
AGAA\)A{A˅AHAܣARA  AQA{AřAA\ApAA\AHAQA
=AAffAzAHA  A{AQA=qAAٙA
=AHApAˮAHAzAffAffA(AffAƸRA33A
=AʣA{A  A{AA
AӮAׅAAA
=AٙA\)AAAAffA߮AAԣAΏ\AffAA{AzAQAۅA  A{AffA=qAңAGA
=AffA\)A(A
AƣA=qAȸRAŅAGAÅAAAAAzA(ARA  A(AQApAA
AA33AĸRAAGA  AəARA{AAA
AA̸RAA=qAAȏ\A=qAÙAApAQAQAQAңA\)AиRAQA{A33AͮAA{A{AffAAGA  AzAA=qApA\)A\AffAAHApAffA  AA=qA=qA
A=qA33A{A
=AA33AzA\)AA  A33AA\)AAzA{A(AQAzA(A=qA{AυAAԏ\A
AA{A(A(AzA  A33AӅA
=AHA\)A  ApAHAGA33A(AۮAffA߅AGAAAߙA
ARA  AAAҸRA\)ApAAARARAQAHAffAAAARAApApAAGAffA\A
AA
=A=qA
=AAݮA(A\AffAܣAA
=A噚AffAA=qA33AzAAٮARAAA
A
ApA=qAApA=qAARARA{ApA33A33AٮAA(AzAA(ApAzA
Aޏ\A
=A\)AԸRAzA{AA
AGA
=Aҏ\AٮA\)A\)AՙAQA33AمAљAzAGAzAA޸RAҸRA{A
A{AAߙA\A\)AGAA
A\AۮA=qA
ARApARAAGA=qAApA=qAA(AA
=AzA
Aҏ\AظRA{AAQA(AffA=qAɮAȏ\AAA
AGAA33AHA
A33AܣA
AzAGAzA  AHApA
=AA
A(AڣAGAAA\)AA\)A33AƸRAzAAzAAȏ\AffApAָRA
=AA
A
A=qAzA(A\)A33Ȁ\AɮA\)AͅA֏\AzApAͮAۙAAGA(A  AAA33A
AAzAQAAA
=A  AָRAQAzAׅAݙARAAffAمAffAHA33AQA\)AՙAffAHA(AA  AzA33A33ApAzA(A{A33A\)A=qAAA
=AAHA{AAAA33ApA
A
=AffAѮA\)A
=AA(AzAA\)A(AAQAϙA=qA  AffAA
=AΣA
A
AљAA=qAңAΏ\A{AӮAԏ\A(A
=A=qAAffA{A陚AAAffAQA\ApA{AAAAAAzA\)AffAA{AAHAAAAGA
=A  AAGA(A
A
A(AA  AARAA{AAA(A(A\A{AHA  A  AQA33AAA=qAzAARAAA\AA=qA=qARAAAQARA33A(AGAApAA(A\)AGAA癚AAA陚A  A\A  AQARA=qAHAA݅AAAA
ARAAApA  AA(AA
A\)A
=AA
AAGAGA(AGA\A33A
ApA
=AA\)AGA(A
AzAAAAAA\)AzAzApA
=AA홚AA\)AQAA
=AAzAffA
=ApAAAAA\AAHA
=AA33AA\)AARAAQA\A{AGA
A
=AA
=A
=A33A  A{A
AGAQAA
=AAHA
=A33AzA
=A\)AAGAۮAAݙAffA\AAAQAzAAAA{AffAA
AffAARAAAAHA  AޣAAQA{A  A㙚A{A
AGAA뙚AAAHAA㙚A噚A(AAHAGA
=AAA  AA=qAA{A  AAA
=A33A\AA
AAzA\AA{A{AAQAA33A{ApA\AzARAQARAHA33ApAHA
=AA
AHA(A  AffAۅAAffA=qAۅAzA=qA
Aڏ\A=qARAA
=AAAQAAA
A  A33AA  ARAA\)AAAA
=A  AAAffA{AAAApA{ApAAffAzA{A
AA
A\AffAA(ARAA\A  ARAAA
=AA
A33A
=AARAffAGAQAHAQAffA\)AzA{A(AA33A(A  AAffAAA
A܏\AzA
=A(AGAA
A  A
AA
A
=AHAۅA
A(AA
AHAAAHA\AA{AAAHAHAAAGAA=qAAGA(AQA  A\A{AA=qAGApAHAA\)AA(AA33AAAQA  AQAffAQA
=A
ARAQAA{AA(ARA33AQAffA33AQAAQAGAffA  A=qA{A33A  A\)A{A
=AA\)A
=A33A
=A
=AHAQA
=A=qAA(A\AHA  AGAA
AA=qAAHAffAzAffA=qAAQAAApA
=AffAQAGAAAApAQAAQAAAAAAA33AffA  AA\)A(AGAA  AAQA
=AA
ApA33AARAAA  A\)AGAffAzAffA=qAffA
AHAHARAAAHAffA  A\AApA(AAApAzAGAA(A
=AA(AAA\)AA=qA\)A\AAQA=qAAAGAAGAHAA  AA
=AffA33ApA33AA33A߅AAGA
A{ApAᙚA(A\)AAHA33AzAAA\)AffAGAGAQAAffAA  AAA  AAQA\)AQAHA\)AHA
A\AAGA(AAAQAGAHAA=qAA뙚A33AHAA{AA\A\)AAGA33A(AAA
A=qAGAAGA(A
=AAA{AAAA{AAQAAGAAHAиRA\)A{AffA̸RAͅȀ\AA
AGAָRAQAA33AffAAAzA(AԣAffAffApAHA\AzApA
=AGAA33ARA癚A
=AARApA{AAA=qAGAAHA
=AAAAAAA33AHA  ARA
A{AA  AzAGAGA33AA癚AHAA
=AAAffA33AffA
=A陚A(AAAzAffA=qAAGARAAAA\A\A\A{A
AzAAAA(AQA33AAAA{AAA  AAAA
A{AAzAQA33ApAAGA홚A
A  AAAAAA홚AAA  AAffAQA33AAAAARA\)A\)AHAHAAA
=AHAQAA
AAffARAA
=ARAAzAffAAHApAAAffAzA
A\)AQAAA\A\)A
AA{A(ApAAHAAffAAzAA{A
=AۮAAApA33AAGAHAHA܏\A݅A(AffAA(A\)A33A{A
=AzA{A{AHA33A
AQAAA\)A  AA=qA=qAQA
A홚AffAzAAA  AAAA33AA(A
=A\AQAQAAzAA=qA{A  ARAA33A
=A
AA\)A=qA(AGA\AAHA
=A
=AQA=qAffAffAGA=qA=qAA
=A\AA\)AffAGAHAQA=qA\A=qARAQAGAAffA
A\AffA(A{AAGAHA=qAzARAHApA
A  ARAA{AA(AApA噚AAHAA=qA
=A(ApA\A\A33ApAAA  AAA\AAAAGAAA  A홚AA\A\AA(AA\A33AA33A  AApAA\A홚AGAQA=qAAHAA\A
=AffAA{AAAHAGAAAA{A(A{AAA(AAHApAAGA(A\AzAAAzAA{AA
=AAGA\A33AHAA\AAA
AGAAffAA33A(AAGA
A(A(A  A=qA\)A
AAAAAffAHA\)A\A  ARAzAAA
ApAffAARA(A(AHAzA癚A(A\AQA33A  ARAAffAQA  A\)AffA\AA=qAGAAAAA(ARA
A=qA\)A  AzAAA{AHA(AA\AAGAAHA\AA=qAA
=A
=AAAzAQA\)AۅA=qAڏ\A(AٙAAAڏ\AAAAAۙApA
A=qAAzAAظRAۮA
=A\)A
=A\)AAffA癚AARAA޸RA{AA噚AQAܸRAAzA
AAAQA
AA
AARAA܏\A\)AAffAA=qAApA
=A
A(AAQAffAHAAAffA(A(A
AAzA\AA33A(A  AQA
=AAffARA=qAGAA{A(A33A(AA\AAAAffAAAzAAAffAUA^\AyA}A~\A
=As\)Ah  AeA_A^ffA[AOA@A'
A,A(A{A1AEAQATzA_Ar{A]pAapAk
AiA}AA|  AQAA}A\ATAH  AFRA9A)GA$A)GA)A'33A+
AB{A[\)AG33AC
=APAN\AbffAhzAh(AjRAs
As33AoAn\ApAj=qAs
=AmAv{Al(Ag
Af{AhzAhAjffAqpAqA~ffAr{ApQA{\)AQA~=qAgAQAw
ApA{A
ApAzAffAAAUAqAp(AupA|AzAAAA{ApAuAAAHAzAA
ApAAAAr\ApAA~\Ab=qA}AeAo
=AzA{AAAQA}AfHAn=qA
AAGAAAA\)A33AzAAzAbHAaGA33A=qAA=qA\)AffAxApQAp  A~\AAAAA=qAGAAA\AAA  AQA33AHAApApAAA  A
=AAAA\)AHApA\)A  ApAA\)A  AA
=AA\A
=AGAAAzAQAffAAARAAAAA
A33AA=qAHA\)AAHAQA\ARAHAHA\)AQAAffAQAAAA
AA
AA(AAAA33ARA
A\)AQA33A  AHAAAAffAHA{A{ARA=qA33AARA
=AAA{AHA(AAAA{AzA\)AAGARA(AHAAApAA
=AQAAAGAGA(AGAA\)AffA33AAA33A33AAA=qARA33AzAffApAzAzA33AzA=qAAA\)A(A  A33ARA
=AA
AA  A
=AQAA
A(A
A\)AA(AAAApARA
=A
A
=A{A
ApAAzA
=AAA33AAA=qAffAAARA
=AA  A
=AHAA=qAA  A=qAəAffAɮA33AŅA  AAƣAAA
=AHAAffA{AGAA(A33AA(A
AffAAA
=A=qA33AGAA
=A\ApAAApAA{AAffAGApAApAAA(A=qApAGA
AAHAA  AAمA33A  ApAGAzARA\)ApA\)AGA\AA33AA\)AzA=qA
AQA(A33A(AAGAQAzAA
=AɅAzAzA33A33A
A  Aҏ\A=qAأA
=A(AffAAAAϮAffApAиRA(A{AӮA
A˅AzA  A
AͅAGAHAGAÅAzAQAQAApA(A{A
=AAʣA
AQA
ApAQAAɅA=qAȣAƣApAAA(A\A
=A߮A㙚A癚AzAҸRA݅AܸRAzAA33ApA{AApAzA  ApA
AffARAzAAA  AzApA
=A{AA\)AGAAA  ARAAffA33AGAA(A
AA
=AAffA33ARAA33A  A  A  AQAHAڸRAQAGA  A=qAA
=A߅AAAApAzA\)AAAGAAAAffAA=qAQA
ApA(AQAQAAAGAA\)AQARAARA\)AۙAəA\)AA˙AApAљAAظRAΣAzA{AУA(AңA\)AУA(A  AAQA(AϮA33A
A=qAʏ\AGAӮAHAAAA(AQAAָRA33AAԏ\AffAѮAGAAA=qA{A{AљA33AQAAA  A
=A
AAAGA
=A
=AAA33A(A{AA=qA\)AzA=qARA
=A33ARApAQAHAA\AAAAA
=A  A=qA
AAGA  AApAď\AzAAzA
Aҏ\AGAQA{AAAQARAA
=A33AA
A(AzA
=A؏\AzA{AAA33AQAљA
A{AA޸RAAQA\)A(A  AHA֣A  AAA\)AzAHA{AHAQA
A֣AHA33A
=A33AHAHAܸRA\)AQAHAA  AA(A33A=qA(AffAA=qAθRAəAA{A  AA¸RAAzAǙAffAffAHAՙAGAٙA(AzAQA=qAAHA£A  A  A=qAģA(ApA˙A
=AAAAθRAApAA  A(ApAAffA
AA33AGAÅA=qAA33AAA33AzAARA=qAAAQA33AA
A£A\)AAApApA\A  AA=qA33A=qA
AzA\)AϮAA{AAAA=qA=qAʏ\A\)A\)A33A(A
=A{AGA33AQA(AzAHA=qAޣAңA
=AA33A
A\)A{AAQAA33AQA{A=qA(A=qA33AHA=qA؏\AAA(AۙAHA֣A
AA
AApA\)AA{A33AffAQAAHA{A
AA(AApAݮAA{A\)A{A\AAQAQAݙA{A\)AApAGAծAQAљA=qAAHA
=A  AAAHAffApA(A33AAҸRAޣAGAQAGA33A֏\A
ApAQAffA(AGA݅A
AAޏ\AA33AՅAzAA\)AAffA
AHA  AߙA=qApAA\AAGAܸRA\)AAAzA
A=qAA癚A(AA33AAAApAGAQAQAA  ARAApARARAAApAARAA
A\)AAߙA{ARAzAA癚A
AApA=qAڏ\AAGAA؏\AzA{A33AffAA{A=qA
=A{A׮ApAA(AffA=qA뙚AQAA\)AGA
=AHAٙAمA\)A{ApA  A
A\)AܣAڸRAۮA{A33A
=AAۙA
=AAAHAAA
AAAAQA\)AzA{A33AAApApAzAQA33A
AAָRARAAHAGAAAzA33A  A\A癚AffARA\)AA33AA(AQA\)A=qA
A\)AA\AQA33AQA
=AzA܏\AGA؏\AΣAAأAA33A\A=qAffAᙚA
AAAA33AA33AA
AͮAAȏ\AAΏ\AΣApAAϙAHA(ApA(ApAA=qA=qAՅA\)A\)AApAAHA
=A33AHAԏ\AAAA֏\AA(Aڏ\ApA(A£AQA㙚AGA  A{A33Aԏ\Aҏ\ARAAAffAәAҏ\AϮAиRAAAA\)AʸRA=qA  A=qAĸRAͅAzA\)A
=A33AAQA˙AAzAAʏ\AAϮA
=AAʸRAffA(A
=AҸRAܸRAAأA
AУAAظRA\)Aޏ\AAϙA=qAA\)AA߮AA)@  A
A  @=q@l(@=q@Q@|@@H@G>k?H???(?   >
??
=?
@Q?}p?G?z?@33?Q?z???ٙ@.R?@6ff@!@g@?\)@7@9@R@@??y @z@\@z@
p@@{@33@*=q@=p@NR@j=q@g
=@XQ@@K@W@*H@C33@XQ@X@qG@c
@i@J=q@Dz@H@c33@_\)@^R@P  @<(@a@j=q@~{@qG@L@
=@|@JH@>R@0  @@
@	@z@@{@2\@}p@R@l@33@j=q@k@[@W@G@@z@ff@\)@@e@~R@g
=@@33@
???p???Q??\?޸R?(?H?ٙ?=q?33@ @Q@{@HQ@>R@P  @:=q@9@L@?\)@8@]p@Q@>R@G
=@4z@6ff@8@4z@@@0@,(@!@#
@p@   @H@p@@@ @H@p@@!@   @!@#33@)@%@(@%@*=q@(@'@(Q@(Q@%@'
=@'@)@.R@>{@0@8Q@AG@9@>{@Vff@I@333@|(@q@|(@E@P  @,@%@\@
=@@Q@H@#
@)@<@8Q@C33@6ff@"\@\)@&ff@G@c33@q@^R@Mp@B\@8Q@(@(@!@R@R@H@{@(@=q@@"\@%@&ff@+@2\@,@0@)@*H@7
=@1@)@(Q@9@:H@<@8Q@8Q@5@7@9@6ff@2\@7
=@<(@:H@8@>R@:H@5@8Q@8Q@8Q@3
@;@:H@S33@Tz@E@@  @:=q@=p@C
@G
=@C33@8@.{@0  @333@2\@0@1@1@/\)@1G@AG@7@1G@,@,(@(Q@/\)@AG@W@X@`@^R@nR@W
=@\@c33@c33@_\)@1@5@(Q@-p@1G@N{@?\)@%@$z@-p@R@{@   @#33@(@(@   @!G@"\@0@*=q@%@.R@.{@7
=@:=q@<(@HQ@S
@G@Mp@Mp@H@C33@JH@Fff@E@HQ@K@Mp@U@Z=q@Vff@QG@QG@N{@QG@J=q@L(@G@HQ@HQ@S33@S33@U@aG@Q@P  @Q@`@tz@fff@^R@W
=@U@S33@b\@s33@\@@H@@@\@@\@  @p@@@@@@@ff@@\@ff@
@zH@u@;@2\@{@%@'
=@!@!@\)@\)@#33@#33@'@+@!G@.R@/\)@.R@C33@HQ@HQ@X@Q@C33@O\)@JH@N{@I@R\@R\@L@U@p@y@xQ@p@@u@j=q@R\@L(@Q@X@NR@vff@33@@e@l(@e@U@S33@Vff@[@I@g
=@]p@Z=q@`  @P@W@`  @]p@Vff@Vff@U@`  @a@J=q@Fff@ZH@^{@W
=@Z=q@b\@fff@c33@^R@c33@W
=@Z=q@]p@Vff@_\)@\@]p@^R@_\)@\@Y@^{@c
@W@Z=q@L@:=q@<@:=q@;@>{@R\@C
@P  @N{@\@K@;@8Q@Dz@>{@Dz@=p@K@Tz@n{@nR@i@}p@@l(@Tz@mp@@(@@33@p  @@33@G@@G@ff@@
=@@z@@@\)@j=q@Q@}p@  @u@u@s
@~R@|(@^R@x@zH@xQ@=q@\)@@z@@
@@{@@@\@G@ff@@@H@R@
=@@  @@~R@q@~R@(@  @z@j=q@r\@|(@\)@@hQ@\@=q@@p@@z@(@@@x@vff@nR@G@R@  @@33@
=@@
=@(@@@\)@@Q@G@@@\@@@@=q@\)@@  @33@ᙚ@׮@{@Q@{@@  @@\)@  @(@@  @@@@=q@R@
=@@G@\@@H@33@ff@@33@@p@(@Q@33@Q@(@@
@z@33@p@Q@\@(@z@@R@\)@@@=q@@@\@z@H@@@@\)@@@c33@R@@zH@@jH@n{@y@\@G@@\)@z@=q@(@@(@{@z@@=q@
@\)@33@@H@  @
=@\@=q@@@@@@\)@G@@=q@Q@{@@p@(@x@@\)@~R@zH@w
=@~R@|@z=q@u@z=q@qG@xQ@u@@x@u@qG@l(@p@nR@s
@u@o\)@{@~R@~R@Q@qG@nR@u@s33@s
@zH@x@vff@w
=@~{@@@@\@@  @ff@33@@p@@@}p@@H@z@p@mp@g@jH@j=q@h@l@jH@nR@q@tz@z=q@xQ@y@H@p@@Q@@ڏ\@Q@ۅ@z@ff@=q@G@@@@  @
@~{@=q@@\@ff@@\@=q@
=@  @
@@@@@G@~R@z=q@z=q@~{@R@33@{@{@@
@@@R@{@ff@@@{@@  @\@@33@Q@H@=q@@@Q@@@
@\)@|@~R@H@\)@H@p@@
=@R@@R@@{@=q@s
@h@h@h@l(@Y@b\@fff@Z=q@p@o\)@aG@g@^{@p@G@j=q@l@c33@qG@p@z=q@R@@w
=@l@e@p  @@mp@H@p@R@y@ff@R@y@|@G@Q@@=q@@@@R@@H@Q@G@\@@ƸR@
@G@(@=q@  @p@z@  @=q@G@\)@H@@@  @}p@vff@~R@p@{@@@@z@@  @z@  @@@\@@=q@G@\)@w@G@\@@tz@{@w@R@w@zH@s
@j=q@\)@Q@@@@@ff@@\)@p@@
@
=@@\@@@{@\)@
=@ff@@=q@R@
=@{@Q@\)@@\@  @@ff@ff@(@@|(@|@|(@w
=@@=q@@\)@@(@@33@G@  @{@  @@H@ff@p@\)@G@ff@z@R@@ff@\)@Q@@@\@R@@ff@p@@{AffA	@\@@G@  @@u@`  @a@tz@c
@[@XQ@P@Tz@U@Tz@S
@W
=@ZH@W@K@S
@u@mp@`@Y@S33@Mp@P@QG@S33@Vff@[@ZH@`@g@^{@ZH@_\)@_\)@`  @g
=@dz@r\@zH@x@vff@u@mp@jH@k@n{@l(@Q@@@H@\@@p@@G@{@nR@r\@|@
@@p@~{@vff@(@l@c
@`  @^R@[@_\)@G@@33@@@\@
=@@ff@=q@@
@ff@@H@H@
=@\)@
=@@@Q@r\@p  @@ff@ff@
@@33@mp@^R@a@l(@fff@g
=@l(@@R@@p@xQ@{@@@(@g
=@^{@Z=q@X@X@U@L@JH@NR@NR@NR@Vff@O\)@Z=q@h@h@q@a@}p@~R@`@\@g@aG@h@e@Y@Tz@NR@L@e@W@(@b\@Y@U@S33@P  @P@Z=q@ZH@[@W
=@Vff@Tz@Vff@U@W@Z=q@Z=q@Vff@mp@jH@n{@o\)@fff@^{@R\@jH@u@@p@@nR@h@l@@r\@s33@p@@x@_\)@X@|(@qG@fff@i@tz@h@e@c
@jH@q@zH@@~{@|(@~R@{@dz@I@JH@G@L(@P@NR@X@K@HQ@HQ@G
=@K@`@i@jH@_\)@Z=q@^{@c
@ZH@Z=q@^{@z@  @ff@u@vff@s33@q@n{@tz@  @dz@Q@S
@Q@U@X@\@]p@c33@c33@dz@a@\@`@_\)@_\)@[@p  @^R@XQ@\(@U@]p@\@]p@XQ@W
=@Vff@Tz@U@\@`  @Z=q@\(@Z=q@fff@dz@\(@\@mp@vff@k@i@qG@g@X@a@o\)@N{@S33@XQ@U@\(@J=q@K@L(@QG@X@s33@p@@W
=@R\@P@NR@Fff@H@G@J=q@Fff@W
=@XQ@XQ@\(@`  @\(@]p@\@U@Tz@R\@R\@P  @P  @S
@P  @S33@S33@S
@_\)@k@`  @mp@x@
=@u@q@y@e@g
=@jH@p  @\@s
@j=q@q@\@jH@`  @\@R\@\(@^{@S
@Tz@Q@U@b\@`  @X@`@e@ZH@a@W@S33@S
@U@R\@R\@Mp@O\)@P  @N{@Q@NR@P  @Z=q@fff@X@ZH@c33@p@@\@@@R@  @33@@=q@@
=@@
@  @H@\)@z@@u@q@S
@Mp@E@:=q@<(@=p@>R@E@J=q@W@L@Q@G
=@HQ@H@I@HQ@Mp@I@Vff@I@G
=@A@E@A@K@W
=@Vff@a@^{@|@I@C33@Fff@Fff@G@E@HQ@~{@=q@@p@zH@tz@y@qG@p@mp@ZH@l@o\)@33@ff@@
=@(@@33@R@(@n{@jH@@33@@33@@H@}p@{@|(@vff@w@z=q@@H@  @w
=@o\)@k@^R@_\)@]p@Vff@XQ@Z=q@(@\)@ff@@{@\)@e@Tz@K@HQ@C
@B\@K@QG@L@NR@P  @U@L(@N{@N{@hQ@\@W@X@\@^{@X@ZH@W
=@U@Y@W@ZH@h@qG@jH@i@i@X@^{@g@g
=@[@h@nR@w
=@@vff@R@p@  @u@aG@]p@i@\(@\@[@\(@^{@k@Vff@U@XQ@Y@U@Q@Vff@U@Vff@S
@U@QG@S
@U@X@X@\@e@c
@e@jH@k@l@\@Z=q@hQ@e@c
@R\@P  @Mp@Z=q@I@R\@fff@_\)@k@z=q@\)@r\@Q@y@h@h@s33@n{@l@hQ@fff@h@hQ@g@o\)@x@x@w
=@|(@@@h@b\@\@\(@h@(@Q@@
@|(@s
@c
@p@n{@b\@e@n{@dz@hQ@g@dz@i@s33@w@q@k@mp@n{@s33@w
=@vff@u@u@r\@}p@n{@mp@n{@h@l@n{@n{@mp@l@k@qG@tz@y@tz@u@w@r\@u@s
@o\)@r\@p@jH@i@k@^R@c33@]p@^{@^R@ZH@ZH@W@Tz@U@Tz@Tz@^R@S
@W@i@q@ff@=q@@mp@^R@a@a@e@fff@z=q@z@  @@  @  @@@@R@\)@~{@|@l@i@k@i@h@b\@`  @aG@a@jH@e@^R@b\@\@_\)@c
@aG@^{@c33@o\)@y@q@l@e@c33@g
=@e@p  @w
=@u@u@qG@mp@p@l@k@jH@h@g@e@jH@l(@l(@p  @g@a@aG@e@c33@`  @_\)@_\)@e@y@Q@~{@p  @l(@e@fff@XQ@P@QG@Vff@`  @ZH@Y@^R@X@ZH@S33@Tz@NR@I@O\)@XQ@dz@mp@u@}p@j=q@j=q@c
@@(@a@`  @@l(@g@b\@fff@b\@l@mp@nR@u@c
@S33@W
=@ZH@Z=q@Z=q@Z=q@Z=q@X@W@XQ@Z=q@Y@[@XQ@\@p  @_\)@`  @]p@[@[@X@]p@`  @_\)@^R@Z=q@ZH@\@^{@`  @Y@^R@`  @^{@^R@`  @e@`@^{@Z=q@Y@\(@ZH@_\)@^{@Z=q@]p@fff@i@l@^{@^R@X@c
@a@a@Z=q@Vff@Vff@Y@Z=q@^R@ZH@b\@`@p@y@tz@qG@k@n{@P  @S33@Y@U@W@W@^R@aG@jH@vff@fff@nR@`  @g
=@xQ@\)@|(@~{@y@Q@~{@zH@tz@r\@w@s
@x@|(@w@e@r\@w
=@n{@o\)@s
@e@jH@u@o\)@p  @mp@o\)@q@w
=@vff@qG@g@h@h@nR@p@qG@r\@p  @~R@|(@~R@|@u@
@w
=@nR@o\)@o\)@nR@@@tz@o\)@p@qG@nR@g
=@jH@o\)@G@@|(@p@q@{@@u@Q@
@G@~{@@\)@Q@@p@{@@  @R@H@@@|(@xQ@p@{@ff@{@@H@
@@  @@ff@@@
=@\)@@R@\)@G@(@R@z@z=q@`  @@Q@zH@|(@{@p  @r\@k@e@hQ@~R@z=q@qG@z=q@s33@o\)@n{@~{@=q@w@@hQ@l(@c
@a@g
=@g@c33@i@n{@@@H@@\@
=@@@
@l(@nR@u@@\@@@Q@{@@@R@33@@33@@@@(@@@ff@ff@Q@p@
=@z@
=@Q@@@p@G@@  @\)@@@@@@ff@
=@r\@g@l(@@\@vff@tz@H@@33@  @@\)@@@=q@\@Q@x@ff@Q@tz@u@zH@w
=@mp@Q@=q@@{@\)@mp@r\@nR@[@`@l@
@33@@G@33@@ff@@{@\@@\)@
@@u@u@p@\)@@
=@\)@{@\)@@z@R@ff@@p@@  @\)@
=@33@{@@@@@@@
=@G@@
=@H@p@=q@Q@\)@p@{@{@@G@@
=@@G@@@@
@H@@
@@@@
=@
@G@ff@@p@}p@
=@qG@@@@  @@Q@R@(@H@\)@ff@@@
@@\@@=q@@@@@@@G@
=@H@~{@  @@@R@p@@~R@p@\)@G@~{@G@ff@\@\)@@\@@
@@@33@  @z@@
=@
=@@l(@p  @u@y@~{@(@@@\)@@33@@xQ@33@@=q@ff@a@p@ff@xQ@@
@
@@33@R@
@Q@@p@Q@p@@@R@@@\@\@@
@zH@~R@u@|@  @~R@  @@33@H@x@G@Q@@@ff@@(@p@qG@s33@r\@o\)@r\@n{@j=q@s33@x@
@
=@xQ@  @(@{@=q@@@
=@ff@ff@@@\)@H@@@\)@@  @Q@
@33@@w
=@{@@c33@XQ@QG@U@R\@U@R\@Tz@a@nR@w
=@}p@  @@  @z@@\)@Q@p@
@
=@=q@@  @H@p@  @p@@@{@\)@  @}p@@{@@o\)@hQ@nR@l(@G@w@tz@p  @qG@j=q@c33@aG@c33@[@W
=@[@XQ@XQ@W@^{@b\@^R@l(@p  @vff@r\@s33@s
@r\@vff@\)@G@@(@l(@jH@zH@z=q@s33@x@k@@|@@Y@X@W
=@S
@n{@XQ@Y@R\@P  @Tz@S
@XQ@Z=q@W@S33@Q@U@W@\@e@k@s33@r\@x@x@s
@y@w@y@}p@z=q@{@@=q@@@@{@@R@@@=q@s
@u@|@tz@}p@u@`  @Z=q@b\@\@`  @g
=@dz@c33@aG@^{@ZH@XQ@W@Y@W
=@U@Tz@S33@Tz@W@Tz@S33@Q@R\@U@^{@U@W@X@W@Y@XQ@Q@W@W@[@Vff@Z=q@i@e@[@]p@]p@\(@]p@[@[@\(@\(@Tz@XQ@S
@W@U@\(@Y@W
=@]p@XQ@W
=@XQ@X@\@aG@\@Y@ZH@\@W
=@Vff@XQ@XQ@X@P  @\(@[@`  @`@b\@aG@^{@_\)@`  @]p@]p@vff@_\)@^R@xQ@^{@\@ZH@\@]p@a@j=q@b\@aG@\@[@a@Y@X@XQ@ZH@[@^{@ZH@aG@Z=q@XQ@c
@ZH@U@_\)@]p@`@mp@k@l@fff@h@c
@c33@^R@^R@_\)@]p@b\@e@g
=@e@fff@[@`  @_\)@qG@`  @a@`  @s
@u@s
@u@e@l(@mp@l@mp@hQ@g@l@l(@e@dz@^R@_\)@`  @tz@c33@c
@e@^R@XQ@]p@e@e@hQ@mp@
@~R@vff@s33@w
=@u@~R@w@Ad@p@mp@p@mp@q@tz@z=q@a@q@w@h@l@q@hQ@o\)@l@q@p@h@h@jH@k@p  @r\@tz@o\)@nR@g
=@g
=@jH@n{@l(@jH@mp@i@n{@p@s33@n{@w@zH@{@}p@~{@}p@\)@y@y@x@y@xQ@tz@xQ@y@y@xQ@~R@x@z=q@z=q@@z=q@|(@s33@tz@~R@H@\)@\)@Q@(@@Q@R@@
=@p@@@@
=@@{@H@(@@@G@  @\)@@@@G@@@=q@=q@@@H@@33@(@  @H@\@(@z@p@@(@
@\@Q@  @{@z@zH@|(@@z@{@@@@@
=@@  @@=q@  @=q@
=@  @@@\)@p@  @p@@Q@ff@@{@
@@H@H@@  @@@@Q@@ff@
=@@H@{@\@@@@@Q@H@p@@@=q@33@33@@R@\@{@
=@@33@R@@@@R@p@
@ָR@=q@@@@  @=q@@@\@ff@@@@ff@  @@33@@{@{@  @ff@
=@ff@@{@@z@  @@=q@@z@@@@Q@p@@(@(@@H@@H@G@R@R@R@\)@
=@ff@(@ff@\@@z@(@{@
@H@
=@@H@@
=@Q@
=@@@\@G@Å@@{@@
@@G@H@p@@G@=q@@H@
@z@{@Q@G@
=@\@p@\@@G@@\@\@(@H@@R@R@@=q@(@z@@@@@@\)@@=q@
=@@׮@@@\)@p@
=@\@z@\)@@\@أ@\)@ff@RAQA	@A@ָR@
=@z@  @@{@33@Ӆ@R@H@\)@
@G@\)@\@@@  @ff@љ@\)@\)@=q@p@
@@@@@=q@
A @@33@H@@Q@@  @
@G@Ϯ@׮@@@@  @@{@(@@H@z@  @ff@G@
=@z@z@@ff@H@=q@=q@@@H@@@ff@@p@@@z@@R@  @{@@@{@33@Q@\)@(@@G@  @@p@H@33@أ@@Q@љ@G@@H@޸R@Q@  @\)@@R@=q@\)@H@H@@@@H@ff@@\@@=q@@@@
=@@=q@=qA QA@\@@@@@z@\@@33@\A
@=q@z@ə@@z@@θR@
=@\@@@\@z@=q@G@@33@@@R@@p@@@=q@p@{@R@=q@G@@@ҏ\@@R@أ@Å@@Q@@
@(@@@=q@\)Ap@
@@ff@
@=q@ᙚ@(@@@z@@33@
@Ϯ@\@(@A@@{@{@p@G@@ff@@@(@\)@@Ӆ@z@љ@θR@z@H@θR@{@z@{@Ϯ@H@\)@  @@R@@Q@33@{@{@R@@@A   A@@  @z@(@@{@Ǯ@R@p@\)@\)@(A\AA(A=qAHA
AH@@
@z@@߮@
@R@33@z@\)@{@߮@
@@@G@ۅ@  @@@@\@@Q@@=q@HAzA
A"HAA8QA6{AHA;A=A4  Aj=qA=qAN=qA>HADQAA.HA/\)ABRACAj=qA)A-A[\)AG33AO
=ARA9A(  AA\A
A@(A,(AHA33AIpAV{A<  A4(A!A;\)A-AS
AHAG
AUAC*xRAQA\AA:=qAR{A<  ABffATQAC
=A4(AYAlA:\Aw
=AQAdzA~RAs
AW
ARHAipAapApAHAh  AAmAAAA33AGAg
AgAiGAg
=A_AYAYGA>\APQAXzAK33A@  A8  A7
=A/
A+A-A*ffAA{A zAA#\)AHAAzA (AGAp@A
=A{@@33@A#@ᙚ@G@ڏ\@@ڏ\@{@@
@33@
=@
=@(@ff@߮@@ff@@H@
@{@陚@@@33@=q@@(@@33@
@
=@\@@{@@@\@G@p@
@p@=q@\@@p@H@R@{@@@(@@
@z@{@  @Q@@@߮@@G@H@@@ff@Q@@
=@33A QA33AAAH@{@{@\)@{@=q@@߮@陚@{@p@˅@Ӆ@@G@@@G@H@Q@z@أ@{@@H@@Q@@H@=q@@@R@\)@@  @@(@@z@ʏ\@=q@(@H@=q@ƸR@@G@@@
=@ff@
=@أ@@\)@θR@@33@{@θR@H@(@@@\)@  @ff@@H@ƸR@  @@G@\)@33@(@@
=@Q@
=@{@\@  @H@
@H@ff@z@@z@ff@
@@
@33@@33@@@
=@@ff@H@@@  @33@{@
@
@@\)@@@H@@ff@@@H@=q@H@  @
=@p@Q@  @Ӆ@  @G@ff@
=@@ٙ@H@  @Bߣ@@
=@p@
=@
=@G@@G@
=A33A((A?ARA   AHA=qA#
ARA.{A0  A9AVRA=qAcAJRA9A-A   A=A=qA$AA\)A33AHA(A=qAQA  AH@33@@33@A   AHAGAA@
@z@ff@@G@G@@@@@\)@p@@@
=@@@߮@{@@
=@{@A@H@=q@(@ۅ@H@ƸR@ٙ@H@@
@=q@H@@@
=@أ@G@GAp@Q@@Q@@p@ٙ@H@@У@θR@33@{@(@ə@@@\)@33@@@Ϯ@@(@ƸR@  @@{@
@  @\)@Q@Å@\@\@ff@
=@H@ʏ\@@Q@  @@@@
@@p@=q@ff@Q@@p@=q@@p@(@
=@
=@ffA A{A\)AHAQA   A  AR@  @\@\)@G@أ@@(@(@=q@@G@H@׮@@
=@G@@@z@@
@z@{@ۅ@33@(@ff@@ff@\)@У@@=q@
@@ƸR@ƸR@{@H@@H@G@ə@@H@@
=@(@@H@
=@@33@@@z@ff@@  @@H@@{@\@@H@@\)@
@
=@  @@\)@  @p@@ҏ\@ƸR@ƸR@y @
@ff@@@\@@@\)@
@\@@\)@(@@{@  @(@
@ff@\)@G@@R@R@G@  @=q@@ff@G@@p@@@@@@=q@R@Q@@@G@@ff@@@{@\)@@\@\@\)@@G@@׮@H@
@  @@@@@G@R@{@
@{@\@@ff@  @@@ff@@Ǯ@\)@p@@z@
@G@33@@
=@R@@G@=q@R@Q@  @H@@p@
=@
=@@@Q@H@@{@R@@=q@@  @z@
@H@@(@33@ff@  @@{@G@@33@H@z@33@G@G@33@(@G@z@G@{@G@H@@
@(@p@ff@@\@H@\)@p@@@ff@@@33@{@@
=A-@H@\@@G@=q@=q@33@R@@@R@@H@\)@@@H@ff@G@{@G@@=q@@@@H@G@{@@  @@У@ָR@@p@33@@
@
=@@ff@(@\@=q@@{@\)ApA
\A
pA33AA	A	AA\)A
A
=A33@@33@H@
@@@ff@@  @
@@@p@ApAGA@@p@ff@G@GA   @@
@@p@=q@=q@z@ᙚ@@G@@@ָR@ڏ\@33@{@z@z@\)@@أ@ڏ\@@33@
@@׮@@޸R@ڏ\@=q@H@p@@\)@@G@G@@{@Q@z@
@H@H@@33@  @@(@@@@@@@R@陚@@陚@=q@  @33@(@@p@=q@@  @p@@33@\)@޸R@{@@{@(@\)@33@
@˅@ə@˅@
AH@A   A=q@@
=@@p@أ@Ϯ@Q@љ@Ǯ@Å@ə@
@p@{@@=q@@G@z@
=@  @@@G@{@(@@@{@
@
@ff@@y @Q@  @R@  @@@{@@H@\)@
=@R@p@G@p@H@z@@(@ff@@@H@
@\@@@@ff@Q@G@p@33@\@z@p@@Q@@@H@@\@
@33@
=@@\@z@
@
@(@@@\@{@(@@
@
@@\)@љ@ʏ\@\)@  @z@@ff@  @p@Q@33@@H@@(@@@p@@H@@{@{@(@Q@Q@R@Q@33@H@ff@@(@@
=@@{@Q@G@H@ff@p@p@@\@33@p@@@@G@@H@@z@@=q@@
=@
@G@@H@p@H@\@=q@H@@@z@@@G@H@@@@@@R@@@@  @@
=@@  @H@@@@@=q@@@@  @(@@z@Q@
@(@  @=q@@H@  @@(@p@z@=q@@@Q@@G@@R@H@\@z@@@\@@@{@  @33@p@@H@@G@33@@@\)@@R@p@p@@@(@@(@R@z@H@@@@ff@Q@@(@@@@R@
@G@=q@(@G@33@(@@\@
=D"@z@33@33@33@z@R@@\@@(@ff@@@@{@33@z@@z@33@
=@  @@=q@
=@Q@
@p@\)@@@\)@Q@@@\@@@Q@  @  @\)@=q@@  @Q@\)@@Q@p@(@@G@@@H@R@=q@\@@(@@@@z@@=q@y@@  @z@\@\)@\@@ff@R@33@XQ@  @ff@@(@
=@@(C@H@R@p@@@\@\)@@H@}p@@p@@R@\@\)@\@p@@p@(@Q@@R@@
=@
@G@p@(C@ @\@z=q@u@x@|@y@y@|(@zH@~R@G@}p@  @}p@Q@  @}p@(@G@\)@y@|(@Q@@@p@33@
=@@@@G@
=@33@{@y@w
=@@xQ@zH@@33@{@  @=q@(@@
@@p@\@@@\Dn@w
=@~R@~{@B{@\)@
@@
@Q@{@{@\)@@@\@G@H@|@w
=@w
=@H@@G@H@H@G@@p@@(@@p@@
=@@\@pA@\)@@  @
=@
=@R@ff@@@(@\)@@
=@\@H@@@@p@Q@
=@p@{@~R@G@@@=q@
=@p@H@@@z@љ@  @p@33@ǮAff@R@G@{A@@
=AffA
ffA/\)A
p@ff@{@  AA\@
@(@ffAzA
H@(@@@{@
@@33@\@{@
=@@G@R@@޸R@Ӆ@@أ@ff@H@\@=q@@@@@@z@33@@ڏ\@33@Å@@@=q@  @Q@(@\@G@G@@@@@ff@@@@@@@{@=q@
@@R@\@@R@  @
=@@@@z@  @@{@@@
@33@@H@Q@=q@
@
@@@33@@@ff@@@p@R@{@@H@R@@@@
@@ff@@p@@  @@R@Q@@
@@
@
=@  @G@@  @R@\)@Q@@  @@\@Q@@\@H@@H@@@@z@@=q@@
=@~R@\@o\)@tz@y@l(@r\@jH@`@hQ@i@mp@aG@nR@j=q@p  @r\@g
=@l(@p@e@c33@`@hQ@dz@^R@^{@]p@^R@`  @Y@W
=@Vff@W
=@U@S33@U@N{@O\)@L@E@C33@Mp@Mp@HQ@Vff@QG@`@\(@]p@L@R\@L@HQ@L@1@C
@B\@G
=@G@<(@7
=@6ff@1G@%@<(@>R@XQ@C
@7@   @z@@   @%@&ff@"\@@@"\@9@XQ@w
=@s33@|@Fff@.{C@HBB@=q@@@G@
p@@\)@
=@
@@(@	@
=?\)?33??
?
??G@   ?G??\)???ff?\?
???Ǯ??{?33?\?\??Ǯ??(?
?
=?G?У?????p?H?Q?H??˅??C??\)??ff?zH?  ?s33?^R?zH?k?h?h?p?Tz?W
=?zH??B\?  ?u?ff??{?\)?
??Q?33?z??
=?\)???{???\)?p?Q?33@\)??  ?G?{?
=???
?(?33?
=?
=??}p?k?aG?Y?W
=?B\?L?O\)?aG?#
?L?#
??.{?5?
=?#
?=p?E?L?Tz?.{?L?@  ?\(?O\)?^R?L?c
?\(?J=q?W
=?Q?J=q?Q?G?W
=?L?n{?^R?xQ?s33?u?xQ?J=q?h?\(?G?J=q>.{?J=q?L?5?5?5?RC?z?!G?\)?(???z???E?5?Y?E?5?(?333?fff?u?=q?\)?z?G?u>?(þ#
?(?&ff?0?!G?R?(?#
??R?G?5?Q?+?0?O\)?fff?J=q?Tz?h?Q?=p?O\)?G?8Q?fff?E?:H?&ff?!G?R?\)?
=?J=q?J=q?}p??Q?
?xQ?ff?{?xQ?Q?\?R?p?aG?aG?xQ?p=u>  ?\)?Ǯ?z?
?G@,?(?u?E?=q???33?H?{??33?У?H@p?z?@ff?G@N{?G?У?p?=q?\?zH?h?z?p??z?H?(?ff?G?  ?{?Q??p?
=????
??@Mp@<(@U@C
@,(@S33@%@H@7@:H??{??H@?=q@?@=q@#33@#33?@R@I@C
@O\)@\@p@@}p@|(@@vff@k@nR@`  @!G@,@*H@;@)@+@&ff@
H@'
=@0@R\@z@=q@@=q@@@NR@@@=q@hQ@XQ@S
@aG@`@{@1@@7
=@>{@Q@@(Q@(Q@6ff@/\)@{@8@>R@,@!@W@fff@9@K@hQ@Tz@@  @C
@@h@dz@|@~{@o\)@c33@`@P  @QG@8@A@@  @&ff@ @%@(@33@G?
=@z?H?H@@@=q@@
p?
@33@@{@G@@\)@@*H@8@x@@\@\@K@.R@G
=@J=q@K@B\@A@?p@"\@5@'@{@NR@(Q@@NR@G
=@_\)@\(@L(@U@Fff@.{@7@
@(@(?\)@(Q@5@  @=p@@  @b\@P@:H@c
@o\)@{@dz@S
@\?\?p@zH@#
?@@@.R@?\)@=q@3
@3
@Fff@E@`@w@<@C
@n{@jH@@(@@H@@p@Mp@Dz@;@>{@C33@0  @333@^{@~{@hQ@Q@Fff@Dz@A@G@G@E@0  @,@6ff@AG@O\)@i@l@`@^R@i@x@l(@^{@w
=@vff@y@p  @333@QG@w
=@|@2\@o\)@r\@u@]p@9@\(@(@l@P@{@q@\@\@nR@XQ@L(@c
@
=@
=@}p@u@j=q@c
@qG@g@c33@Z=q@hQ@;@N{@1G@B\?z@\@(@4z@A@+?˅@:H@Fff@ff@{@/\)@(@-p@.R@5@1G@(@"\@#33@1G@6ff@3
@#33@,@Q@(@"\@\)@(@{@@/\)@@?=q@Q@\@*H@7@8Q@8Q@7
=@C
@<(@A@K@A@G@;@>{@:=q@@@8Q@8@5@*H@3
@<@K@W
=@P@9@Q?p@@@333@S
@c33@K@\(@NR@U@'@Z=q@C33@@  @A@Mp@S33@C33?@8@_\)@  @E@QG@S
@K@\(@.R?@1G@NR@l(@Fff?(@@@)@JH@Fff@G@Q@8@C
@N{@O\)@C33@7@!@7
=@*H?
@'
=@   @{@p@1G@(@0@5@*H@
H@)@!G@,@&ff@#33@ff@  @{@
H@(@H@#33?
=?33@&ff@.R??ٙ@7
=@:=q@*=q@(Q@*=q@#33@$z@@?ff@=q?@@%@#33@$z@(@#
@\?@H@=q@
@@@(Q@mp@.R@I@>{@7?@H@H@A?H@@@&ff@{@@@
H@L(@L(@@C33@G@@
p@\@%?@,(@@*=q@*=q@Dz@]p@H@H@AG@Dz@HQ@K@7@ @*=q?z@.{@>{@3
@{@<@8Q@e@W
=@$z@@  @,@3
@4z@:H@1@(Q@!@!@'
=@@H@\)@
p@\)@
p@
p@=q@#
@ @-p@/\)@)@(@*=q@5@.{@333@(Q@@\)@@@@1@>{?G@,(@<@QG@E@B\?޸R@@@.R@  @
p?p@\)@$z@4z@H@Y@HQ@ ?ff@
=@R@@1G@G@1G@=q?@\?p@
@
@  @
@
p@C33@H@,(@'
=@6ff?@*H?{??=q@;@5@\)@qG@e@P  @Mp@E@G
=@'@G
=@\(@:H@p@u@~R@I@0@:H@E@1G@:H@333@'
=@,(@:H@Mp@J=q@E@A@2\@NR@.{@L(@^{@U@333@'@2\@4z@!G@'@\)@JH@G@w@%@G
=@Y@7@^R@@@H@w@W@j=q?@R\@aG@9@8@&ff@=p@   @,(@8@#33@G@ @8Q@)?
@,(@W
=@aG@ZH@;@A@.R@1?33@#33??G@
H@{@R@R@\)@\@H@>{@@?G@  @B\@'@4z@'
=@  @E@<(@O\)?R@/\)@Fff@@@;@AG@QG@@@G@G
=@>{@(@A@AG@E@:=q@A@=p@B\@JH@=p@JH@AG@1G@8@5@8@'
=@(@#
@&ff@,(@1@9@,@,(@6ff@5@6ff@\)?\)@8Q@:H@\@C33@!G@@@L@C
@K@H@33@Q@=q@p@'
=@=q@-p@E?  ?{@
H@#
@)@.{@5@A@0  @@/\)@p@&ff@#33@<@7@8@@  @B\@9@I@2\?@.{@(Q@   @
H@\)@@z@Q@   ??\)@Q@
=q@{@@z@33@
@\)?@Q@?@!@@@(@p@\@\?R@p@+?(@+@!G?G??H?Q?@,@+@0@7
=@5@&ff@6ff@\)@
H@{@\@@\)@  @%@(Q@&ff@!G@\)@p@@
=@\@(@8@\)@$z?R??޸R?  ?
?(?@?(@&ff@%@%@%?Q?˅??@G?????\?z?Q?G@@33@
?
?޸R?@?
?p?p?@?xQ@
H?@@\@?{@@
=@?Q@?R@(@z@{@
=@@ff@z@z@
=q@z@@\@ff@@
=@@
@@@R@R@@@
@@?@R@@   ?
=?{?33???ff??{?ٙ@\??@	?z?(?=q@
=??ff?ٙ?z@33?p@Q@ff@@
=@   @(@"\@?=p@p@#33@@?@33@@  @	@  @z@\@\@33@33@@@?H?p?=q>=q????z?@@
@	@
H@G@  @@ff@@@@Q@R@+@+@!@=q@(Q@,(@??  @@@(???\)???33??\)??z@33@ @ ?{?z?R@\?H@   ??(??(?{?{?Q@??þ@  ??\)?˅?ٙ?Q@
>?(?p?\?ff????G?޸R?{?  ?z?z?+?
=?ff??@   @G@
@33@:H?
=@.R?(??
?W
=?(?Q?(>?z?޸R?H?=q?논
?޸R??Q??G?
=??=q?{???\)?\)???ff???Q??z??z?k?(@z@33@
=@   ?33@33?Q@@
=q@
=@
@
@\@G?p?  @@
=@ @
@{@
p?p@?z@8@ff@?YD+?
=??z??\)?(?  ?\)@   ?@ff@p@33@!G@9?@G@4z@+@?\)@@(@33@R?@
?Q?\)?@Q@{@(@(Q@,@@-p@@/\)@ff@H@e@{@@z@@=q@@@p@@\@@  @@@
@@{@P@\@33@\)@AHA  A3
=AA=q@@ʏ\@R@Q@R@@HQ@e@ǮAA@@O\)@,@@u@#33@9@\)@@
=@@{@!@)@1@4z@C33@Vff@
@qG@p@@@R@p@(@z@n{@E@)@/\)@NR@@L(@O\)@O\)@[@_\)@hQ@@L@Q@Q@^R@e@e@@n{@B\@#
@L@ZH@a@~R@
@H@@G@@(@HQ@W
=@\)@@R@@=q@ff@(@  @\)@G@@ff@z@@@h@HQ@5?@AG@C
?=q@K@QG@G
=@L(@8@P@Vff@NR@L@JH@AG@&ff@H@1G@(Q@'@)?R@,(@1@@,(@>R@<@A@H@*=q@g@{@i@Fff@E@z@6ff@R?@Y@+C*\@ƸR@@  @@x@{@@zH@Q@G@@@g
=@w@k@\@@\)@o\)@z=q@g@\@X@{@q@Z=q@hQ@c33@H@@(@xQ@y@n{@	@
p@Vff@^{@@33@
@=q@z@ff@H@{@  @Q@Q@
@j=q@ff@{@R@  @  @(@z@@\@~R@l(@2\@5@6ff@@R@G@dz@^R@>R@I@aG@AG@J=q@0?\@8Q@@|(@(@@Tz@w@J=q@jH@a@QG@~{@r\@~{@\(@c33@<@S
@S
@O\)@@8@E@P@C
@G@0  @(Q@8@.R@,(@@7@2\@@<@A@c33@b\@5?@:=q@1@333@{@/\)@+@@@>{@+@6ff@6ff@:=q@(@ff@@{@{?^R?p?@1G@;@?p@@z@
H@@QG@\)?@"\@"\@.R@@@Mp@{@E@0  @-p@#33@@:=q?W
=@!G@@\?(@<@333@4z@4z@$z@2\@*=q@333@2\@*=q@0  @*H@$z?p@6ff@-p@&ff@,@Q@333@
=@+@Q@GB@-p?@@@ff@@\@G@\@
=q@@=q@33@@@@@ff@Q@\)@z@	@G@@@   @@@@@\@@ff@@  @(@
@33@R@
p@?޸R@5?33?(@@@Q@
p@
=q@@	@
=@(@@"\@#33?@&ff@$z@ @Q@'
=@@"\@H@H@@z@33@@
@
H@G@\)?33?@z@@(@
p@
=q@@@
=@
=?G@@@Q@z@??@
=?>{?H@
=q@\@@@R@(@
p@@
p@@@@(@@R@@\)@@33@
DO@
@\@
?p@   @ @   ?
@@
=@z@33@33@
=q@
@ff@@
=q@
=@z@\??}p
?
=?\)??p???p?@Q@
=q@\?
=?&ff@?R@@
@
=@ ?@@?@G?O\)@ff@@???
=Chn??
@
=@G?\)?H??\@?H@
?\)AR\?(?H@z@	?ٙ@@
H?(@ff@	@	@z@	@	@33@@@
H@@ @\@(?H?Q??H?Q@@@\@   @\@\@
@?Q?{?
=@??H@
?H?G@
@?H?\)?{???=q?
?
?
??
=?(????  ?G?G???R??@@@
H@
=?H@
=q?E?(?H??޸R?Q??  ?G?p?Q?޸R?\)??
@%?^R??33@  ?R?{?(?G?
=@33EMf?33?=q?  ??(??{?\)?33?ff?
=@??z?33@   ??ff?  ?Q?p?z?R@
?p@\@R@
H?H??p?У?=q???H??p???
=@ff?L?ff?  ???=q???(@?޸R?ff?p?  @I?O\)?Q=u?
?  ?@?33???ff?Q?\)?Ǯ?G?=q?  ???G??
?>???zC{?  ??ff?\?Q?Y?H?У?p??  ??\)?\)?ff?=q???޸R?p?ff@@@\)?@ff@\)@\@@z@\)@G@@k@R@33@@z@{@
=@??z?H@
p@ @	@z@   @?p?
??(?H?H@G
=@,(@1@\)@c
@8@
@hQ@s
?G@333@?\@,@{@   @&ff@{@?Q??޸R?
=?Ǯ?(?G??
=?R??0?H??H?  ?
=??Q@	@3
@HQ@ZH@?@*H@
p?
=?@u@33?Q@?z@?^R@$z?=q?z?Q?{?H@ff@@
H?@?p@@?
=@@
p@
@(@!G@*=q@>{@@?@`  @j=q@$z@@4z@:H@\@(@
=@
p@@@?(@R@@?\)@@G@R@@?
@G@z?@ @?p@"\?(??\)?  @@
=q@ff@,(?R?ff?H@ff@?R?R??У?z?\)?У?z??(?33?z?޸R@?{@z???H?@(Q??xQ?^R?(?@ @@
H?(?{??޸R?ff?Q?ff@@  @@  @\@@H@@@R@@@ @\)@$z@*H?@#33@,(@=q@33@G@?
?(@ ?{?33@
?G?޸R??Q?G?޸R@
H???Q?{@?{??H?G??=q?z?Q@\@
=q?@  @33@R?\)?R??ff?  ?  ?z?Q?p?  ?p??=q?p???z?Q?@\@
p@
H@
H@??\??  ?ff??ٙ?z?޸R?޸R?G?z?  ??{?p@G?H?z?\)@   ???\)?z?z?=q?{?=q???
=??Q??Q??=q?{?
??33??ff??@
???G??ٙ?޸R?33Cj=@   ??ff?\)??\)?Ǯ??33@
H@Q?ٙ?H@(Q@	@G@   @  ?Q??@\)?R?H?@?(@??A@  @	@
=q?R@
@
=?ff@	@z?z?\D?(?????\)?{?z??p?Q?33??{??z?p?@@??^R?޸R??Q?z??=q?(??R?=q??{??n{??(?\)?H?
?
?ff?{??\?=q??\)??ٙ?(?\)?z@@\)@G??@
=q?{??s33?=q?޸R@????G?޸R?  ?(?  ?(?\?  >?
?=q???{?=q?{?
=@G?@@33?(?H?R?@
?ff@33?z?ff@z@   ??33??Q?(?
=??=q??(???G?\?  ?G?O\)?ٙ???У??H??\?>aG=G?H??=q?Q??
??Q@33@(@
p@\@R@\@@"\??ff?ff??
?G?
=?
=?
=?ٙ???
=??p?H?
=?
=?  ?\?  ?=q?p??
=>W
=??H?޸R@ff?\?G?33?ff??:H?{??{?ff??
????ff?\>33?
=?H?p??
=>?z?\?(?
=?
=?У?
=?Q?ٙ?Q?{?\?z?z?{??У?ٙ?Q??=q?\)??
?У?\)?˅?33?˅??{?z?˅??ٙ?
=@z??G??p???ff??  ??\?
=?
=?˅?=q??33?Q?z??Ǯ?˅?
=??33?{??\)???p?Q?z?{?z??Y??
=?  ??H?\?ǮA?z??\?ٙ?33??(?z?H??
?33?{??p?У?{?H?ٙ?z?G?
=?33?޸R@\?z???\)?33??  ???  ?z??
=?p?33@?@@@
=q??ff?(?Q?  ?ٙ?p?Q?=q?(?p?z?H?(?H?޸R??G?H?Q?ٙ?
>?˅?
?333??>D
?
=?=p?ٙ??H?Q?@G?@@@@R@?p?(?\)?
=????=q?G?\?\@=p?ff?
?
?  ??  ?p?\??
????\)?{??
??
=?p?p@G@@ff?p?R?@G?R?R>z@
@   @G??@   ???z??
=?\)?
=????=q?\)????=GCh>  ?=q?ff??\)AƸR?H?\?H?(@
@\@
@   @   ??=q@33@ ?=q?p@33@G>@
@\@ ?p?R?H?H@33@@@
=@@G@z@
@\@G@ff@ff?@   @\@
=@
@z@@ff@@ff@@
@33@Q@@33@ff@\@Q@?{@%@(@G@G@@(?  @@'
=@+@!G@{@(@'
=@(@ @?H@G@pD"@@{@pE@@@c33@GBjz@@  @
=@@p@G@@@@p  @@\)@@  @G@a@
=@@\(@
@p@@
=@  @C
@ff@r\@@=q@@(@S33@@Tz@G?G@H@  @@@U@{@\)@p@
@@\)@@R@  @
=@{@?R@ ?ff@(@
=@ff?
@@@(@K@@z@@@  @R@@
=@
@R@@33@H@
@ff@\)@@RC#@@zDHɚCz@33@  @@\@ff@@
@@pC33@
@@
=?H@Q@G@JH@
=@Mp@@@H@@\@\)@@z?33@@w@@p@@Q?
=@=q?=q@  @	@@@n{@p@R@\)@@  @@@R@
=@?
=@<(@  @@+@  @z@  @
=@l(@H@33@z?H@z@z@@{@p@p@~R@33@@*=q@>{@ff@@z@R@ff@{@\)@<@@ff@@@@G@
=@Q@@  @@z@33@A@
@
=@33@A  @=q@\@\@33@
@@(@=q@@@
=@QB8R@Q@Q@G@@D@!H@Q@G@G@\)@  @  @@@R@
=@\)@~{@{@  @33@@p@@ff@@
@  @AG@333@@=q@i@@@>{@@p@(@\)@R@@=q@33@0@@ff@
@#33@,(@Q@+@   @z?\)@Q@=p@@R@G@@{@@H@\@\)@G@@@H@\@@Q@@G@2\@G@z@@@@(@@Q@Q@z@ff@R@@G@@{@G@(@@\@@@  @@  @@3
@\)@333@
@ff@@@}p?R@@  ?@p@Q@^R@(@R@{@G@
@w
=@QG@@33@o\)@R@ff@@z@=q@@p@@@
=@@(@R@@@.{@@@?@@@@,@@@@@H@z@R@@\)@=q@Q@  @Q@R@@@{@p@H@ff@@z@@@g@{@e@@  @@H@z@E?G@@ff@@w
=@R@\)@Q@\)@@tz@@{@@ff@33@@33@(@?33?(@@#
@Fff@9@+@z@\)@\)?\)@p@ff@z@z@33@?Ǯ@@@?˅@@@
=@
=@ff@@@@{@\@\)@@
=@\@ff@33?@G@=q@hQ@G@z@@@\@@
=@G@\)@
=@@@
@=q@p@@@@Q@{@R@p@@  @H@@\C@
=@  @33@Q@\)@ff@ff?+@~R@33@{@  @RA)?
D= @Q@n{@p@R@Q@\)@@@
=@{@@@K@
=@@
@?\@ff@
=@aG@p@\@{@_\)@@@
@@p@
@x@33@\)@@*H@JH@]p@@`  @z@z@\@@@R@=q@@@ff@L(@?B\@R@R@(@@@@R@@\@R@Q@p@q@p@A\@
=@@=q@
=@\@@@Q@@@HC@@Q@@(@@@p@)@\@Q@Q@@p@R@`@@
@Q@R@(CS@@@Cc\@
=@@  @
@@E@33@(@H@{@ff@Q@Q@\)@
=@R@{@@@=q@H@8@Q@@
=@@p@Q@@
=@33@@@{@z@H@@(@@ff@u@@(@@P  @z@ff@  @ff@
=@ff@\)@=qB.@A4z?@=q@ff@@@33@@@
=@Q@Q@@RD}q@33@\)@@  @ff@\)@33@\@R@@
=@=q@
=@
=@33@ff@@\@Q@(@=q@@\@l(@  A5@=q@C*\)@@I@@\)@(@@G@33@Q@=q@@Dz@\@=q@\@@
@  @
@G@e@\)@ @@{@@Q?Q@@@@H@
=@@G@R@
=@@@H@Q@
=@\@(@z@H@G@z@{@@@@@@Q@@@z@
=@33@(@@@G@@@@R@@33@Q@@  @{@@
@H@@~{@@R@33@@  @\?33@  @33@<@\)@R@=qDC#@Q@Q@@  @{@
=@H@33@@
@H@33@@  ?
=?33@@
?(@l(@
@U@@H@@@
=?p@@33@P@dzB@N{@@qG@  @  @ff@Q@\@vff@{@HD@@
=@\)@=q@@\)Ac
@@@@(@@
=@ff@33@R@
=@  @{@
@@(@33@@Q@33@@@\@+@@  @@@@\@\@\Bf@@33@
@H@
@{@
=@z@@
=@c33@@G@@@Fff@=q@\)@Q@=q@33@Q@`@ff@@@<(@@?\)@@@(@H@Q@@@@p@33@Q@vff@R@\)@
@=q@G@  @p@
@@@  @
=@@@H@@@  @@@  @R@  @G@A@
@=q@
=A\(@{?@
=@@@z@G@\@{@=q@?\)@G@@H@H@.R@ff@=q@@@ff@@@@{@@R@@@@
@@@p@\)@(@G@  @@  @B\@G@@@33@ff@
=@z@
@@@\)@&ff@   @x@R@_\)@@@  @=q@R@=q@33@33@\)@R@:H@R@=q@Q@
@{@\)@Q@@z@Q@%@?\)@G@(@\@
@H@@R@G@@\)@{@33@(@=q@33@Q@@z@p@@@@(A
=@@@@@Q@p@@@  @ff@@  @z@
@z@@Q@R@@@\@@@@p@Q@G@  C@G@R@n{@p@G@z@?Ǯ@\)?(@@@@@@@
=@@ff@-p@@@G@  @@R@@@=q@{@3
@U@{@@R@z@Q@@
=@6ff@@  @R@\@  @@\@@ff@@@Vff@\@  @@\)@p@
=@@@ff@@
@p@R@r\@  @
=@  @@@@33@\)@p@@@R@\)@@R@@\)@@@(@=q@33@p@@Q@G@@R@
=@@\@G@H@R@z@A@@@@Q@ff@@Q@=q@\)@@@{?
?33?@@33@@p@@R@z@@@?H@?p@W
=@vff@|@Q?G@G@\)@@
@l(@p@@<@@\@~R@}p@x@vff@@(@=q@z=q@
@@p@33B
pB@p@@(@z@@~R@y@tzC
@q@i@j=q@h@
=@@dz@aG@_\)@\(?fff@X@Z=q@Vff@QG>@@W
=@Tz@Y@j=q@Vff@Y@\@XQ@X@R\@Z=q@L@E@R\@I?@
H?>?0?@5@AG?
=@9@#
@B\@,(@4z@-p@'
=?p=Q?G@;@G@G@?\)@L(@:=q@C
@6ff@;@5@333@7@;@A9@:=q@6ff@7@7
=@8Q@1G@,(@
@%@R@#33@"\@   @\)A@!G@%@%@!@!G@1G@Fff@A@9@Vff@N{@H@8Q@-p@ @,(@ @p@@(@
=@@
@@@z@  @@@p@Q@
=@zA(@\@@@\@\)?@N{@\@(?
@@   @   ?{?^R@G@G>{?z??\?ff?\?ffaG???=\)C,@ff>8Q>u?\@33?33@@)??\)>\?
?R??  ?@?G?
=?p@Q@@\@?  ??޸R?ff?˅?  A?Ǯ??=q?\)?
=?33?Ǯ?Ǯ???H??G?
??(?H?33?(???(?z?}p?(??  ?  ??(?p?\)A((??G?
=A=q??
=????   ?  ?Hz\)?h??z=Q?(?Lͽ<>B\>=q>
?=q    >B\?33?Q???=q?aGR!G?(>.{?p?s33?
=?
=??J=q?(?ff\)???}p?H?}p?s33?k?u?}p?ff?G?G?H?=q?z??=q?
=?\?z?Q?z?
?}p?c
?}p?ff?=q?\(?G?:H?=q?p?c
??333?#
?B\?W
=?W
=?E?J=q?O\)A=q?xQ?L>?GBgA?O\)?Tz?Y?TzC%?}p>{>\A33?k?n{?
=q?^R>L?B\?G?h?h?
=?=p?@  ?Q<
\)z?5
?\L=G>=q?G?h?p?E?u?33=#
?
?ff??þ  <
?&ff??^R??=q?#
?J=q?c
?(?!G>{?Tz>(?5?fff?h?B\?
=?\?Q?O\)??p?
=??
=?ff?@$z?
?k?zH?ff?p?h?G?u?p?fff?u?n{?B\?B\?5?:H?J=q?Y?O\)?#
?(?0?5=??!G?
=q?
=q\)<
@  >>ff\)>?\)>G(p<?
=z?\)?.{?@  ?=p>>׾B\L?u=G
ͽ
{>aG?
=z?=p??(?   ?O\)?(???
=q>>
>>>Ǯ>{>zὸQ<#
>#
=AH>W
=>  >>\)>>W
==Q>\)>?\)>H>aG<<<=\)=L=L=L==G
=L=
>L>z>\>\>z>k=q>???+Ǯ?E?\)=qǮQ<#
?
=q>R>L>  >>W
=>&ff>u>{>{>{>z>z>Ǯ>>33>\)=\)=Q>W
==>W
=>===G=Q=
==\)>L=ukh>>\
>\)>=?8Q???&ff@>>\>\A(Q>#
?   W
=A.R?(??\?aG?
=>?#
>#
>>>>
=?z>p?
=q?z?zἣ
??R>33>G?&ff?Tz?O\)?0?W
=?=p?B\?8Q?Tz?5=
?+?   >  >H>  >#
uͽQ녾=Lͼ#
    <
u>\)>LͿ=p>(>=q>8Q\)>L=>
>W
=>p?
=qQ    >p>>(G^R>u>???G?#
?(?   ?+=\)?.{??+>  >p?&ff>W
=
>L>(HA\AAQAA
AA=qA(A
\AA=qAA@
=@{A Q@ff@@p@33@H@@{@@@=q@@=qC"^@
=@
=@
=@\C6s3@(@R@@@:H@@fff@G@ڏ\@R@@@\@R@  @\)@z@陚@=q@(@z@\)@33@p@@H@h@@@H@  @@  @
@@@33@@<@@H@h@@G@
@@G@33@@R@
=@  @
=@
@p@{@R@@ff@@A@
=AG@ff@@
@\@@ff@R@=q@33@陚@@ff@G@(@
@H@
=@p@@=q@
@@@@陚@@H@@@{@\)@=q@ff@@z@zA(?(@
=@QG@R@Q@\@ff@@p@@p@\)@@@=q@33@Q@@=q@  @H@z@{@
=@  @Q@\@  @@G@@p@j=q@ȣ@@
=@׮@zH@{@H@ff@  @@33@H@H@R@R@33@{@{@H@@@(@=q@G@AG@G@H@{@\)@@
@ff@{@=q@H@@G@
@@G@(@z@@@\)@z@@@@@=q@=q@@
@G@p@@{@(A@@@@ff@@y@p@@y@{@޸RAAA
@\)@@@  @=q@  @
@A A33AGAA\A	A
{A	A\AA zA=q@AGAR@@G@=q@Q@\)@  AA   AA{AAHA33@\@љ@{@=qA   @33AQ@pA@GA zAA=qAAQAA zAffAA{@
=@
@@@@@\@33@@ff@@@陚@  @=q@p@p@G@z@ff@@@R@@@G@@z@  @@
@\)@@>{@!@@\)@Q@H@G
=@@@G
=@޸R@mpA
=@H@
=@H@@S
@p@G@J=q@zH@z=q@qG@A	@@Q@  @Q@%@@
=@@A Q@(@\@@ff@
=@QCW@33@H@У@(@R@@@p@@Q@z@ff@@
=@z@(@G@=q@@߮@=q@G@  @陚@R@@{@
@@H@=q@R@\)@z@@@@
=@@33E)q@@陚@  @H@z@ᙚ@ᙚ@=q@@@@H@\(@H@z@s33@jH@=q@Y@\@G@@љ@@@@z@=q@{@z@A@A=q@=q@@QAz@33@  @@@A@z@ffA{A@@C$h@@=qA A	A  A  @(@R@pA   A@@pA\)A@{@p@G@p@@@@@z@@@=q@z@H@\)@p@\)@@@{@  @Q@=q@{@ff@p@R@@z@ff@G@8Q@ff@R@@@@@A@@pA@G@B33A\)A@z@{@@G@R@\)@  @G@@aG@H@  A@=q@@Q@У@ٙ@33@@n{@=q@C
@33A@33@陚@@A(ARA A  @G@33AR@AH@@{@z@z@ff@߮@@@G@ff@(@  @ȣ@ff@z@  @@@ff@{@=q@Q@@ff@Q@
@R@p@z@
=@@z@=q@
@\@@ff@@Q@@Q@@(@@@޸RA(@@xQ@@z@@
@{@θR@@\@u@(A A
=AA A (AA\)AAA=qA
A{@\@H@
=@=q@  @G@@
@@  @
@{@ff@^R@o\)@@  @@p@G@H@u@@@  @A.=q@z@H@@z@@@H@@\@z@@@H@z@
=@@@@@@@@A>H@p@p@p@
=@@p@(@@@
@@fff@  @
@H@ff@ٙB@ff@.R@
=@33@  @u@{@ZH@
@z@\)@Ӆ@6ff@
@=q@
@.R@H@33@@&ff@
@˅@@˅@33@"\@z@H@G@@@z@p@H@@߮@H@ۅ@@H@@ۅ@Q@@33@陚F[@\)@@ff@@(@  @H@@;@@=q@
=@33@@@33@@Q@{@ᙚ@@{@=qA0z@\)@  @z@ff@@@ff@\)@@p@@Q@z@@
=@z@z@ᙚ@9@
@p@Q@
=@@Q@θR@W
=@Y@p@
@љ@^{@  @HQ@{@@33@p@6ff@E@@@@)@@*H@Q@\@p@
p@@ff@׮@33@@@@ǮA{@\@Q@(@@(@{@33@@@RBH@Q@33@
@@@33@@  @ᙚ@\@@@ff@@z@@33@@z@  @  @@=q@H@z@@AG@Q@  @@z@Q@@z@Q@(@Q@=q@{@Q@@
=@33@\)@(@(@|@@Å@@@XQ@p@@z@{@@33??@<(@z@
H??  ?G@=q@@=p@?@z@<@z@@@   @z@R@θR@[@p@H@@
=@G@R@@ff@z@@Q@=q@Q@Q@p@ff@z@33@+@
@33@
=@@@33@  @@ff@\)@@R@G@Q@=q@H@@
@@@@=q@@@
=@{@(@R@
@ff@@ff@@  @@^{@fff@
=@@w
=@=q@
@
=@@p@H@@@!G@=q@33@p?
=@\@@@R@ff?Q@R@@H@
=q@@H@)@@!G@\@@5@\)@{@  @R@@@@Q@@  @@R\@@@P@(@@
=@{@@i@R@G@@G@@ff@@(@
@(@@@Q@@@@  @H@{@R@@
=@\@@p@
=@w
=@y@@  @@ff@R@R@@z@@
@@  @(@@Q@R@@@
=@p@p@z@H@H@H?\)@G@=q@ff@ff@
@\?(@?p@@@@\)@  ?  @c
@@@{@ff@G@R@dz@33@{@33@?33@@(@\)@Mp@?=q?p@i@p@@@?R@{@ff@@k@@z@ff@@fff@@@@  @{@=qCA@w
=@{@  @1G@(@\)@@n{@=q@y@nR@s
@s33@g
=@fff@X@aG@p@l@33@mp@9@I@j=q@a@l(@mp@jH@o\)@`@W
=@`@N{@S
@jH@AG@W@=p@`  @=p@
H@:=q@Mp@2\@;@@  @B\@@@'@8@7>33@0@?\)@*=q@1@-p?aG@"\@R@333?@*H?
@.{?p?:H@)@>R@?=q@@o\)@A@Mp@Q?z@:=q@\)@8@8Q@8Q@"\@   @Q@$z@(Q@ff@!?@ff@@?@@(@ff@
p@
=?@(@J=q?Q@?Q@G?z?\@R?ff???ٙ@G@@   ??
=?@?G?
?z??p?@  ?33?p?
?G?G??=p?
=?ff?s33?\?\(?J=q?B\?^R?O\)?s33?n{?Tz??(?(?\)??  ?(??fff?s33?p?h??\)?aG>z?p@
=?H??33?޸R??R?33?ٙ@0  ?˅@:=q@-p=???33?z?z????\(?}p?p?RA9?h?z?
?????\)???33??=q?(???H?{?\)?
?ff??R??
=?G  ?Q?\)?z?  ?ff?c
?p?\)?{?G?z?????\)??ff@
=?\?u?n{?Q???fff??ff?@
=?{?=q?ff?\)@#33?Q?@G?ff@G@{?@33@\)?W
=??(?Y??p?h??h?(?R?z?
@G?  ?33??ff?#
?W
=?W
=??h?Q?s33???{?G??R?  ?k??u?p?Tz?Tz?0?8Q?333?5?=p?L?.{?8Q?L?Q?k?}p?{??xQ???33@?{?
?G?H??У?  ?{?R?  ?p?33>?33?=q?>G?Q??(??k@?\?  ?Q?(?  ?p@ff??  @\)@{?ff@??\)??H@?@!G@@33?\)@\@
=@@@@33@\)@
@
H@@@z?G??z??33???ٙ?Ǯ????\)????{??
=??R?  ?Q??p@
p@?{?(?H?Ǯ??  ?
=?z?
=?  ?
?޸R?H?@33??
=?{?
?{?Q??{?p?
=?33@   ?@   ?=q@R@*H@
=?H@
=q?zH?0@\?aG?5@
=?@@@"\@\)@=q@
@(@'@ @R@(Q?У???p@3
@qG@Vff@B@@@\)@z?@z@?@	@>R?z?z?ff?
=?Q??ff@\)??  ?
?У?=q?=q?
=?G?   ?Q@?n{?(?ff>#
???(??(????=q?=q??G?\)??{?
=?=q@*H?R?p?}p<
?
=>{>#
?33=#
??  ??E?.{?>\)?B\?fff?\)??
?Q>k>(?z>p?  ?Y?33?H@33@{?
=??z?=q??33?pE=?\?fff?W
=?xQ?  ?5?p?
?@  ?fff?p?
=@!G?n{?\)?n{
=q>ff=G>{?L?n{?33?H??p?Q@?uR?n{?=q?\(?xQ?^R?}p?zH?Q?(?E=#
?8Q?^R?L??Q?p?>?{>ff???}p??\??
=?G33?G?333?G?333?0?E?h?@  ?=p?G?@  Q@?8Q(?
W
=
  ?J=q=q>{?\?O\)>#
?Q?(?z?D
?p??33?
=?{?33?G?G??Q?z>?E?
=??H?=q?k?k?xQ?G?
?fff?#
?J=q?c
?W
=?G??W
=?@  ?=p?W
=?=p?333?!G?8Q?zH?n{?Q?33?
?=q??H?p?p??
=?z??5?˅?p?\????\???G?L???(?\?R?O\)G>ff?3335>{?\?33?z=
?R?33?H?@?p@33@p?@
?G@  @ff@L(?\?=q?p??У?J=q??=q?}p?s33?n{?R?ff?  ?{??녽Q?  =
?\??\?=q?s33?s33?J=q?zH?aG?=p?G??Q?zH?G?s33?ff?h?=q?p?u?zH?W
=>H?\)>R?\???G?H?fff?E?#
>((ÿ\>\\)?R?.{>ff>H?>녿n{}phý\)>?\>
=?#
:H0>\)>
=\?
=>8Q?s33?zH?Q??  ?G=?n{?33A	p?G?5??\)?0????R?Q>?&ff?zH?333?+?(??=p?G?@  ?+??>Q?+?  ?=p?s33?W
=?ff?xQ?@  ?
?(?J=q?\?\)?.{?fff?G?^R?W
=?O\)?B\@vff?R?(A
??\(?Q>\)?  ?p>ff??n{?33?\?(?
=?aG??O\)(?>B\?&ff??\>???5?+>G?   >\?G?
?\(?aG?#
??ff?Q?
L;G!G?J=q?:H?z?Tz<#
\?Q?&ff?B\?Tz?^R?R?s33??\??R?ff?8Q?p<D
??s33?\?C
??#
?xQ?G?u??s33?s33?uA\?L?s33?L?O\)?B\?G??n{?.{?h@=q?O\)?aG?p??Ǯ?þu?}p?z?
=?˅?
=?
=?\)=Q>\?338Q?p\)>\)??G?u??{?G>(>B\{?G?\?(?Q쾳33=q?\)?\?˅>Lͽ
??  ??{=
?
?ff?=?n{;?ff?
=@>R?p?D2?G@333?(??\?   @{?{A3\)?(?=q??H@
??R??W
=?R??z?  ?{?  ?>R?#
?{>?k??p???p>?  ?Y?Q?!G#
?k?p@7
=!G>\?zH?5?RAR?
=@nR???5?H?z?
=?.{?Tz>W
=?(??
=??H??>aG>??<
??{??
\)?+?;?\)33>  ?녾p?Y?{?\?Q?(?33?=L?\?
??xQ?h?c
?G?n{?k???n{?J=q?hÿ?
?zH>?  ??\?
aG#
?{?p>\)?  ??녾  ?R?{??=q?
?p?\?Y?E?Tz?k?u?\(?
=q?\(?@  ?^R?L?O\)?n{?p?
?=q33?
?ff??\?Y?zH?=q?n{?\(L?u?n{?=q?\)?
=?
=??ff??Q논
?s33?G?\??Q?Q>?=q?}pǮ?aG?uD?xQ?hü
?}p?p?>
?(?s33?p?zH?xQ?k#
?J=q?G?(?\(>  >8Q?h?u?^R?333?333?k?
=?\>>\)>(?\)Q?0>k?
=G!G?5?333?.{?.{>L?G?h?h?녾#
RL?p׾녾\?fffW
=?:H?aG?u?Tz>z?Ezὣ
@  G?s33.{??=u?G??u>=q?s33\)B\>#
??xQ?\>?\)???
=#
Ϳ?J=q?33?=p?ff>?k?>
?=q?ER?33?zH=q>R(?  ?׿??<>B\H  >Q?H?
=??
?G??R>p?
=?33?{??HL?\)
=?W
=A33?{?<#
??
=??z?\)?ýL;k?G>k?xQ??33?\)?+?
=+?
?@  ?>Ǯ?Tz?33?0???ff?J=q?\?ff?ff=\)?\)>G#
R?\)??G??=qW
=?Ǯ?=q?33\)?.{?33Q???Q?{?
?
?\?{?z<?0׾L?H@z?H??\?\?H??pW
=??
?=#
?\)?녿?@z?
=@@G@
p@\?@@Q?=\)>ff?0?z@,(@!@33@@=q@ff=Q?(@G?R=L@@,@(Q?!G@7@%@6ff@6ff@@/\)@2\@@1G@&ff@\@   @#33@)@%@!G@#
@B{@{@R@zᾔz@R@!@C{f@.{@+@1G@0  @5@5@8Q@Fff@8Q@   @,@,(@,@p@+@S
@0  @333@)@!G@	@,(@)<@$z>
=@"\@z?
=@%@@=q@!G@*=q@@#33@R@ff@@  @33?\@(@!G=u@p@   @R@=q@@@@@(@"\A
H@R@$z@\)@{@(?Q@G@(@	@þu@@@@
H@
p@{@33W
=@z@   @R@Q@
H@@	@
=?>Q@C
?{@{@@ff@@\@33@@\)@þ@
p?@@@ff?z?33@??p@ff@@	@{@@$z@$z@@{@@  @.{@0  @+>8Q@.R@-p?@z@9@1@"\?@<@5@2\@7
=@ff@5@%Bz@!G@%@%?p@9@.{@.{@(Q@@@.R@@0  @0@,(@,@'@@)@,(@(Q@,(@+>L@,@{@1@)@*H@(@)@*=q@(Q@   @.R@(Q@$z@2\@5@@  @9@>{@;@z?c
@\(@Y@Mp@0  @%@=q?@ffDf@!@@@{@!G@'@'
=@&ff@*=q@+@"\@$z@)@ @(@'
=@&ff@'@#33@(Q@(Q@#33?J=q@R@$z@%?8Q@%@\)@"\?\)@*H@0@2\@/\)@,@/\)@2\@ @.{@-p@+@*=q@0  @'@.{@*=q?ff@1G@%?@\@.{A
R@*=qQ@:H?fff=@5@5@;@5@B\@C
?
@K?.{@B\@Fff=@@@:H@<@;@<(@8@;@5@2\@  @8@'@7@>{?=q@*H=
@C
@E@@@<@>{@N{@9@K@Tz@S33@Tz@\@Y@P@ZH@\(?33>@@NR@Tz@Q@\@Vff@Vff??@S
@XQ@\(@U@Tz@R\@ZH@g
=@fff@Y@AG@XQ@W
=@`  @\@dz@\(@e@AG@Q@G@Dz@=p@Fff@5@=p@A?  @8Q@:=q@<(@@  @ZH@dz@Q@NR@JH@\@^{@`@Vff@9@^R@jH@k@\)A=q@ڏ\@
=@Dz@_\)@g
=@fff@p@s
@xQ@@~R@|(@@\)@@\@=q@
@@(@\@@ff@
=@z@@@=q@z@z@@=q@33@  @p@R@@  @  @@z@z@@
@{@@{@@p@
@\)@  @@@Q@ff@@H@(@
@z@p@R@@@R@R@
@H@@(@=q@Q@@@@{@p@@@z@p@33@@=q@@@p@p@@{@ff@(@
@(@p@@@H@33@p@z@G@H@z@@@@@  @{@tz@@@@
=@z@z@@
@{@ff@{@@Q@@@33@@
@H@@@@
@z@ff@@{@z@\@@H@=q@(@{@xQ@R@\@\@G@@
=@@@\@@ff@@
@33@  @z@
=@
=@@\)@Q@H@ff@@@@Q@@G@@
=@
=@H@@@ff@\)@@@
=@G@\)@
=@@@(@@  @Q@@=q@@@G@@@ff@
=@@@@  @@H@=q@@ff@@ff@
@@G@33@ʏ\@Q@  @@Q@@\)@  @@@
=@ff@ff@R@@=q@@33@@
@@@@{@\@\)@@{@\@z@R@@
=@@
=@H@@@33@\)@=q@  @H@z@\@33@@(@@\@@=q@33@@@
=@33@@  @
=@
=@(@(@@@@@@
@33@@
@\@(@@@G@H@@p@(@ff@G@H@  @@HD@@@z@33@@@{@{@z@@@G@ff@p@
@H@@@z@@33@@=q@p@ff@@@  @\@@R@(@@@@@
=@H@@
@@p@p@@=q@\@\@=q@(@@p@@{@ff@@@@
=@@p@@@@p@(@H@\@@\)@@@
=@  @G@33@G@@
@=q@@\@\@\@  @@ff@p@33@p@@33@@  @  @  @\)@33@\@@  @@{@Q@
=@@  @@\)@@33@@R@@z@R@@ff@{@\)@  @p@\)@\)@G@  @ff@z@@\@@  @@H@R@Q@@@
@Q@@@@@G@\)@
@@H@HAff@@(@zD@@=q@@=q@@33@@z@RAEp@@\)@\)@@(@=q@Q@@
=@@z@Q@@@@@\@33@H@33@@33@@\@@@ff@33@@@
=@{@@z@\)@z@@H@@=q@@=q@G@(@33@@\@
@ff@R@=q@p@
=@(@p@@@@H@(@{@H@@(@@33@R@=q@(@@@}p@\)@H@{@ff@@\)@@\)@@33@(@@
@@H@ff@{@
@@  @33@Q@@
@\@@@
@\@  @
=@\@@\)@
@G@@H@H@@(@p@=q@Q@@33@
@@G@@33@
@ff@
=@Q@
=@@@\)@@@(@@@ff@@@
=@
=@@ff@(@z@(@=q@G@@Q@Q@
@
@33@@33@R@@z@@@@Q@(@ff@{@
=@@@@{@(@@Q@@Q@p@@33@@\)@ff@{@
=@@@Q@@@ff@{@=q@@
@@@G@H@=q@@  @R@R@@@@@33@\)@s33@@\@\)@ff@z@{@@G@z?@@{@@@33@@Q@z@\@{@@ff@ff@\)@  @Q@  @@{@ff@@33@@Q@@G@@
=@@R@u@R@@  @(@\)@@
=@@=q@33@=q@H@@\@ff@\)@@
@Q@  @\)@  @@Q@@=q@(@@p@=q@@@@  @(@ff@ff@z@@@  @R@G@ff@@H@ff@Q@Q?@  @\)@\)@@@@H@@R@\)@R@  @=q@=q@@@@@z@@
@@\@@
=@(@@R@ff@
=@@33@G@{@ff@@@(@Q@@Q@R@33@(@p@{@@@33@  @Q@@@@z@
=@D@=q@@  @G@z@G@R@@@@@Q@G@
@@mp@p@@\@@@@@@H@G@Q@\)@@@@@(@aG@@(@33@@
@@@{@\)@@@\)@G@ff@@?@
=@{@@@
@{@R@p@
@@(@Q@p@{@(@@@@R@=q@Q@@@~R@33@R@=q@ff@
=@=q@\@@z@@
@\@@
=@@p@G@
@?Q@@z@(@y@X@QG?E@@(@p@R@
=@p@H@@(@{@@
=@{@\@@33@33@(@@\@z@\)@@@zH@z=q@}p@x@u@y@x@qG@|(@=q@@z@@H@  @z@@R@R@@z@(@@@G@H@@R@  @@G@@
@(@
=@p@=q@=q@
=@(@33@@
@
=@~{@@=q@r\@s33@qG@mp@{@@y@z=q@tz@tz@w
=@xQ@w
=@s33@u@mp@p?HDÑ@p@k@q@o\)@jH@jH@jH@e@l(@k@p  @b\@s33@(@z@~{@Vff@s33@u@xQ@x@u@u@q@p  @p  @o\)@p@nR@jH@k@i@i@j=q@g
=@g
=@g
=@hQ@h@l(@j=q@k@n{@nR@\@@\@p@  @\@@@@@=q@~{@ff@zH@p  @33@ff@{@H@zH@mp@o\)@mp@@\)@n{@u@{@y@=q@o\)@l(@i@e@dz@c
@ZH@^R@`  @e@b\@a@a@dz@o\)@u@l@qG@p  @p  @u@p@P@p  @o\)@l@n{@l@qG@y@vff@o\)@qG@q@hQ@l@j=q@u@w
=@u@}p@xQ@o\)@p@e@c
@g
=@x@u@s33@zH@=q@{@@e@Z=q@Tz@O\)@S33@NR@P@R\@O\)@P@Mp@I@K@C
@I@U@U@^R@\@\(@^{@ZH@U@Tz@U@U@Vff@U@X@W
=@R\@P@J=q@U@S
@XQ@U@S33@P@QG@NR@G
=@s33@b\@W
=@Q@HQ@I@J=q@O\)@L(@L@JH@H@JH@Fff@A@AG@AG@C
@C33@?\)@C
@[@Mp@Mp@K@JH@\@aG@Vff@QG@N{@JH@G
=@A@NR@NR@I@QG@Mp@P@P  @O\)@AG@<(@<@>R@:H@;@8@7@6ff@4z@333@5@.R@3
@0@.R@/\)@+@&ff@(Q@'
=@)@&ff@%@%@%@'
=@*H@'@)@/\)@/\)@,(@(@%@@
@R@@H@|(@
@@@ff@@
H@
@
@
=@Q@{@\@@G@33?R@G?Q?Q@Q@@
=q@?R@   ?(?(@33@33?R?@
@@?R@   ?H?p????H??
=???
?޸R??ff?\??{??{?Q@.R?G@  @!G@  @p@
=@(@
@z?(?@\???  ?G?\?  ?(?H?
=?  ?z????\)?=q?У?У?p?G?33@%?(?z?=q?(?33??H?{??У?Q???\)??=q??????ff??=q?(??H?\????G?
?G?ff?ff?=q?H?ff???\??k?ff?zH??ff?ff?zH?{?}p?c
?\(?\(??n{?h?c
?zH???p?{??ff?s33?Y?\(?h?^R?Y??aG?O\)?L?O\)?L?L?G?G?n{?333?(?z?0?J=q?5?5?s33?@  ?333?@  ???>H??(?
=q?0?B\?(??(?\)?#
?333?#
?   ?#
?
=?#
?(?(?
=q?#
?R?z?(??
=?   >>=q>(>
>>=q>aG====D >  >aG=G==G>u>L>p?8Q>>
?\>p>>>
>>{>G>z>
>{@  >\)>kAH>8Q>R>{>
>>?!G>>H>k>  >?R?5?
=q>\>W
=>R>p>8Q>L>>#
>aG>  =G>=L>W
=>8Q>B\>=L>8Q>z>W
=>>8Q=>B\>.{>L>=#
>R>>>H>R>>W
=
W
=R.{R  R\)  #
#
<
=L<
==\)=G>><

@P׾.{;L;kW
=uaGW
=#
u=qL;aG8QB\33ǮQ녾3333R(þ{zDR=;W
=  33
ǮǮ(׿   G(;W
=.{?.{=G>L=#
ͽQ콸Quk

RRRRzᾏ\)k=quuL;W
=  Rþþþ녾ǮǮ;=q33;þp=q  녾{
=Q쾊=q\
=ffǮGHH;33\)G녿Ϳ\      ff׾;׾녾Ǯ33Q!G׿;H\HH\)
=ff׾ff(녾녾pQ쾸QW
=þLͽu
#

\)Ǯ;Ǯ녿   \GǮQǮ(p33uu\)zW
=
u>aG{aGL;G#
  {ǮffffW
==q\)G;(3333k
=\녾zᾣ
\)L;=q.{    =GLͽ\)B\\)W
=\)
<#
=u<
=#
Lͼ
>u>>H>H>?>>\)=L=G>#
>L=u=LͽGu
k8QW
=\)u8QaG8Q켣
8QBkaG녾uL;33\\)\)(


\)þL;zᾊ=qzᾮ{ǮQ쾮{  þ  =q=q  \)k+H@\\HH(ÿz(ff\)#
z
=(ÿ!Gz\)H;>녾zᾀ  Rzk;RuþþQ
=
=;녾(\33p
Q쾽ppþ{RuE5aGG=qB\Q쾸Q쾽p{\;ffaG(Gþ=qQGW
=׾33ff(u#
#

<#
L;kkB\B\B\aG.{8Q\)aG     \G8Q    u#
>.{>>
=>
Q(þH   GG\þB\\)L;>z>aG>33>R>u>=q>>>>{>\)녾pz;=qAA
@@@@ff@G@@\)@@@\@z@@R@{@p@@G@\)@@  @{@{@@ff@Q@@@@
@
=@Q@@ff@G@z@
@\@(@
@@G@
=@G@H@@k@\)C~H@@\@\@
@33@(@@Q@ff@H@@G@Q@@
=@@@ff@p@@@
@G@Q@ff@{@R@{@Q@(@@qG@ff@Q@  @@@
=@R@{@@@@@ff@@R@R?@
=@\)@ff@@{@g
=@@@@
=@@
@Q@@@@@Q@@G@?G?{@@Q@@=q@33@(@=q@H@\@  @\)@p@(@\@6ff@p@=q@H@@ff@@G@ff@ff@=q@=q@@33@(@\@`  @@@R@{@ff@p@=q@33@=q@p@{@R@@@?33@@@=q@y@=q@H@@G@Vff@@(@G@=q@@@z@{@z@\)@
=@Q@H@@Q@\)@@\)@@(?zH@p@H@pQ@.R@z@
=@@@@@P  @  @@@
=@(@H@@33@\@@@
=@
@   @\)@@@@@
?
@(@  @]p@?(@p?Q@@(@@Q@Q@p@G@@@@H@=q@@?.{@(@\@(@\@33?{@{@\>@R@S33@[@?p@(@p@=q@z@ffBk@{@(@H@=q@H@\@@@G@Q@\)@R@{@ff@  @@R@z@p@{@33@\)@\)@R@ff@\)@
@]pDJ
@
=@~{@G
=@G@@\@@@@p@q@@@@
@@H?+@tz@l@nR@W
=@x@e@~{@z@\)@(@
@@@@\)@@ff@R@p@@@
@@
?
=@@=q@@33@=q@\@@R@\)@Q@(@@\)@@\@(@w
=@@z@
@(@@\)@@@33@@@@\@\)@G@@=q@  @@G@(@R@@  @\)@@R@@@@\)@@@@@@33@@  @\@G@\@@33@@Q@
=@@33@z@Q@  @\@
=@@=q@(@33@\@\@@33@
@(@
@(@(@z@z@@33@@@@@33@
@H@
@@H@33@\)@@{@p@(@\@H@  @
=@(@Q@@
@\)@@@@@@  @@  @
=@@@{@Q@@@{@{@  @@@H@33@@@@@Q@=q@=q@Q@R@@ff@@  @\)@Q@@@@@33@(@{@Q@@33@@ff@@H@H@
@p@
=@  @ҏ\@Ӆ@ҏ\@z@p@@@
@(@{@@
=@@p@R@@Q@\@陚@H@@Q@=q@@z@AAzARAA	A	A  AA  A
pA
A\)AAffAffA\)A(AA=qAQAzAAAHA
A\AAAA33AA A!GA!GA
A (A!GA"{A A"HA"HA$A"{A#
A"ffA%GA%A%A%A%GA(  A&RA'A%A((A&ffA(A,A+
=A+
=A*RA)A)A*\A'33A'33A'33A(  A(  A)GA)A*=qA*\A*=qA,(A,zA0A1A/A1pA3
A4QA5A6\A5GA8QA9A9pA:ffA:\A:=qA:\A:ffA:{A:HA9A:RA:HA<zA>=qA=A<A;33A:=qA:{A<zA;
A<A<(A;A9pA8QA7\)A8A8zA8  A7
A7\)A&=qA!GA"HA"{A zAA+A$  A&RA$A#33A A!A$QAaAZRAQAMANRAMpAMAMANffALAO33AK
=AK
=AFffAFHAHQAGAGAHAEAFffAF{AF=qAEAEGAEAEAEADzAC33AEACAC
=AAA@ABRA@AApA@AAA@A@zA>HA?\)A?33A?
A>=qA=A<QA<A<A=GA<A<A;
=A;
=A;A;
=A;A:{A9A7
A7A8(A7A8(A7A6ffA6{A4zA3
A3
=A1A0A.RA.RBAAA(??R@0@2\@,@*=q@(@8Q@4z@=p@E@U@C33@B\@E@E@G@L(@E@?\)@B\@Dz@C33@C33@B\@Dz@H@JH@Mp@Mp@Q@U@Vff@S
@X@[@`@b\@dz@XQ@\@ZH@Z=q@[@X@\(@QG@S33@U@U@XQ@^{@aG@]p@c33@fff@dz@c
@i@]p@^{@Y@aG@g
=@hQ@hQ@dz@g@j=q@g
=@l@s
@r\@xQ@x@r\@u@{@Q@=q@w@y@\)@G@|(@=q@~{@x@}p@
@H@@33@  @@p@@@\@@|@G@\)@@@|(@@@  @@H@\)@=q@}p@}p@}p@~R@  @\)@@Q@@\@\@H@\@=q@=q@=q@\@H@33@@\@@@@R@{@
=@@\@H@@@\)@=q@\)@\)@|@}p@|@}p@  @|(@~{@@\)@@Q@33@@Q@z@@{@\@@33@G@\)@@R@@33@@u@G@\)@@@33@@\)@z@
@@@z@z@p@=q@
@@Q@z@@H@  @H@@33@Q@@Q@@@z@(@@@R@@@
=@@\)@{@p@
@@@@@H@H@ff@
=@
@@z@
@@@@@H@=q@
=@z@33@ff@
@
@{@@@Q@Q@H@@Q@@@@=q@\)@
@@33@H@
@@z@H@@@@@@@@
=@@@z@
=@@33@\@@@G@
=@G@\@@(@  @(@\@z@{@
=@(@H@@\@H@@G@G@=q@33@H@33@=q@@
@p@R@\@@Q@=q@33@=q@R@@Q@@@(@@ff@@z@@
@R@
@33@=q@\@G@~R@~{@}p@@~R@~R@~R@G@@z@\)@(@z@@\)@Q@G@ff@
@H@33@(@z@33@\@H@G@\@(@U@Q@@z@H@@Q@R@z@33@@@p@@R@nR@G@  @@  @@
=@R@R@G@
=@@@Q@  @Q@{@  @p@@{@p@@p@G@@@
=@G@\)@{@@@@p@ff@{@ff@z@@ff@{@@{@ff@{@\)@Q@@\@@~{@{@{@~R@|@|@zH@
@zH@|(@z=q@zH@zH@|(@~{@Q@=q@  @@H@{@Q@@p@
@p@=q@=q@@@(@\@p@@33@z@{@=q@@  @@R@@@p@@\)@(@@@@@H@@Q@@R@=q@{@(@33@
=@\)@Q@H@\@@@(@33@@R@G@
=@@@  @@{@{@
@
@
@@\@G@@p@z@@(@33@=q@@@@(@H@\)@33@x@zH@~{@~{@z=q@tz@s
@tz@Q@\)@|(@z=q@  @zH@z=q@Q@|(@~R@~{@@@zH@@}p@@=q@(@33@\@}p@@=q@33@@{@z@@z@R@
=@@  @  @  @@G@Q@@@\)@@@JH@@
=@@\@@@H@=q@@@  @|@{@~{@y@w@x@u@w@vff@r\@u@33@vff@z=q@u@vff@vff@x@\@zH@u@qG@r\@w
=@x@tz@x@@x@qG@p  @l(@p  @p  @n{@nR@o\)@jH@l@n{@j=q@h@h@h@h@g
=@fff@g@c
@h@hQ@n{@qG@o\)@l@l@xQ@w@33@=q@jH@h@g@c
@aG@aG@\@^R@^R@;@^R@c
@c33@xQ@p  @@z=q@p@fff@jH@fff@j=q@jH@o\)@n{@o\)@mp@l@i@j=q@i@i@i@e@g@g@fff@hQ@hQ@g
=@e@dz@g
=@e@e@c33@c
@c
@c
@b\@e@dz@g@o\)@hQ@l(@hQ@fff@j=q@fff@c
@g
=@l(@e@i@g
=@e@e@aG@dz@c33@e@`  @a@c33@_\)@^R@\(@Y@^{@tz@^{@^{@Z=q@_\)@XQ@^R@[@[@\)@Z=q@^{@\(@]p@l@H@{@\)@  @~{@qG@h@j=q@a@dz@i@aG@g
=@k@w
=@|@w@n{@Q@vff@w
=@aG@^R@`@aG@Q@Q@Z=q@[@`  @}p@g@^R@`  @]p@X@U@Vff@R\@U@Vff@Y@U@U@U@Tz@Tz@S
@N{@Mp@NR@S33@S
@S33@U@Vff@W@[@]p@^R@^{@ZH@W
=@XQ@R\@U@JH@C33@A@B\@L@G
=@Fff@H@J=q@J=q@Fff@Dz@C
@Dz@C
@C
@A@>R@AG@A@A@B\@Dz@G@Dz@G
=@C
@C33@K@E@AG@>R@G
=@E@E@G@G
=@Fff@C
@Fff@C
@HQ@I@C33@C33@Dz@HQ@P@L(@K@I@P@U@U@QG@_\)@_\)@Z=q@a@`  @n{@\@e@^{@_\)@XQ@Z=q@P  @P  @H@Mp@JH@N{@I@K@L(@R\@J=q@Q@Q@QG@NR@JH@L(@O\)@S33@O\)@O\)@O\)@N{@N{@Y@dz@hQ@R\@O\)@S
@S
@Tz@O\)@Tz@NR@Mp@C33@@  @?\)@>{@;@>R@C
@S
@\@^{@Vff@P  @HQ@NR@R\@Tz@P  @N{@Fff@AG@E@C33@E@G@C33@Fff@Fff@E@H@J=q@J=q@I@@G@JH@J=q@G@H@E@C
@G@E@Fff@HQ@C
@I@G
=@JH@K@I@L(@QG@XQ@Vff@P  @W@`  @X@R\@U@QG@S
@S
@R\@U@XQ@Y@Vff@XQ@W
=@U@R\@R\@O\)@P  @NR@K@Mp@H@Fff@Fff@AG@C
@>{@@  @9@Y@Mp@;@<(@@@:H@8@9@;@:=q@>{@B\@>{@<(@;@8@4z@;@>{@:=q@>{@>R@@  @>{@B\@AG@7@>{@@@B\@>{@>{@G
=@L(@J=q@K@HQ@Q@Mp@E@G@Mp@E@^R@G@NR@Vff@B\@>{@@  @?\)@=p@@  @@@@  @B\@@@>{@C
@>{@<(@;@?\)@<@@  @=p@>{@>R@?\)@@  ?{@A@@@Dz@<@Dz@C33@C
@HQ@H@Dz@Dz@I@L@S33@Vff@P@L@HQ@G
=@C33@@@@  @>R@>{@@  @>R@:H@:H@:H@7@R\@>R@=p@7
=@:H@JH@<(@5@8@.R@/\)@,@'@*H@,@.{@.R@7
=@7@;@G@8@7@7
=@7@8Q@<@7
=@8Q@:=q@>R@Dz@>{@B\@<@J=q@@@XQ@P  @@@C33@<(@4z@8@:=q@?\)@E@H@@@E@C33@{@JH@L(@R\@J=q@O\)@Dz@E@@@5@:=q@E@@  @AG@@  @>{@AG@B\@@@AG@J=q@NR@QG@O\)@Fff@G
=@c33@AG@=p@5@4z@333@5@5@5@:=q@=p@>{@:=q@=p@=p@:=q@C33@>{@:=q@3
@;@?\)@@  @AG@:=q@J=q@@@AG@AG@<(@8@7@:=q@9@Tz@Mp@H@H@=p@JH@6ff@6ff@.{@6ff@/\)@333@,(@*H@0  @/\)@0  @1G@7
=@4z@3
@1G@1@,@1@0  @/\)@+@/\)@0@0  @.{@7@G
=@<@<(@7@.R@-p@'@&ff@'@%@(@(Q@&ff@*=q@*H?@+@,(@,@/\)@+@+@(Q@)@+@
H@*H@(@3
@.R@*H@*=q@*=q@&ff@)@'
=@'@(Q@(@+@)@.{@&ff@&ff@'@+@"\@!G@!@(Q@!@$z@$z@&ff@'
=@%@'
=@'@&ff@%@$z@$z@#
@$z@%@%@"\@$z@!G@!@#33@!@ @R@   @ @   @{@@\)@p@/\)@ @@{@=q@=q@H@(@R@#
#
@K@A@A@K@Q@NR@U@`@ZH@W@Vff@Tz@Vff@S33@W@\@]p@`  @]p@\(@X@Z=q@]p@Z=q@X@^{@^{@]p@]p@^R@]p@^{@^{@`  @]p@aG@`  @`@dz@c33@`@`  @^R@`  @\@[@^R@`  @[@\@]p@^R@\(@[@^R@Z=q@\(@\(@]p@]p@e@b\@k@fff@i@jH@l(@l(@i@h@g@dz@dz@a@c33@c33@a@c33@fff@g@g
=@l(@^R@e@ZH@^{@mp@o\)@g
=@dz@_\)@jH@nR@qG@n{@e@i@w
=@|(@{@qG@|(@w
=@l(@p  @tz@=q@p@q@nR@i@nR@jH@k@r\@k@w
=@l@jH@p  @j=q@g
=@i@h@g
=@fff@g
=@fff@g
=@g
=@fff@e@hQ@g
=@fff@dz@a@g@e@c
@c33@a@c33@g@e@c
@c
@c
@aG@b\@dz@`  @aG@^{@b\@aG@aG@`@]p@^R@i@i@jH@g
=@jH@j=q@i@i@e@hQ@h@jH@j=q@a@a@a@b\@dz@b\@c
@c
@nR@e@e@e@dz@g
=@e@mp@s33@w@qG@s
@k@jH@k@l@l(@j=q@s33@e@l@q@vff@p@u@l@mp@n{@l(@g@k@g
=@k@k@j=q@l@j=q@p@mp@nR@k@p  @x@q@u@s33@n{@o\)@i@h@hQ@j=q@c
@c33@c33@`  @_\)@g@e@g@j=q@w@j=q@jH@z=q@j=q@nR@w
=@tz@e@a@vff@nR@p@l@l@g
=@hQ@e@k@g@l@q@l@o\)@o\)@l@l@mp@q@q@h@g
=@hQ@k@fff@b\@ZH@hQ@l(@l@p@p  @s
@r\@mp@l(@g
=@dz@hQ@o\)@dz@c
@e@i@g@fff@g@g@i@j=q@j=q@j=q@g@e@c33@e@c
@c
@mp@g@hQ@o\)@p  @s33@s
@mp@jH@i@l@hQ@e@jH@k@n{@w@p  @h@jH@p@tz@
@33@R@@(@zH@p@@@y@}p@@@zH@s
@|@mp@~{@p  @tz@h@k@jH@e@g
=@\@\(@Y@b\@e@j=q@h@i@dz@e@h@mp@o\)@p@p  @n{@r\@u@mp@s
@s33@u@nR@jH@jH@hQ@j=q@g@jH@l@e@c33@e@e@h@c33@e@`@`@e@c
@_\)@`  @e@_\)@_\)@]p@`  @^R@l(@b\@e@a@n{@y@n{@j=q@hQ@mp@fff@l@p@vff@vff@mp@l@g
=@jH@dz@hQ@aG@^R@aG@]p@g@fff@`@dz@e@hQ@g
=@hQ@l@j=q@`@_\)@aG@c33@^{@`@e@S
@U@W@R\@X@QG@S
@S33@R\@S
@R\@Q@S33@Q@S
@\@i@e@]p@XQ@Tz@Vff@W
=@U@W@U@Vff@b\@Tz@W
=@W
=@\@S
@Tz@U@R\@QG@S33@P@Q@O\)@NR@P  @P  @Mp@L(@L(@E@Fff@E@Dz@C
@C33@?\)@AG@@@@@?\)@@@A@>{@@@AG@B\@B\@>R@@  @<@>R@:H@<@:H@8@6ff@8@4z@6ff@3
@3
@2\@4z@1G@0  @.R@,@.R@*H@.{@-p@-p@#
@%@$z@%@!@%@!@"\@#33@ @$z@$z@"\@$z@#
@!@"\@'
=@\)@p@(@=q@(@#
@H@
=@@!@@
@G@33@ff@Q@@z@G@G@  @\)@
p@@\)@@@\)@@@ff@@@@ ?R@   ?R?R?Q?
=??H?33???\??\?
?  ??\??(?
=?ٙ?(?Q???33?z??{??G?G?????????=q???=q?=q??
?
?(?p?ff?ff?H?ff?
=??=q?
?Q?R?
=??G??{??=q?
??????
??zH?=q?
?xQ?xQ?p?aG?c
?u?k?}p?G?}p?  ?  ?zH?zH?G?  ?}p?\?G?G?  ?s33?G?u?xQ??  ?h?n{?W
=?^R?J=q?^R?n{?c
?fff?xQ?}p?\?u?  ?c
?c
?s33?fff?Y?Tz?J=q?W
=?\(?J=q?Q?Y?G??p?c
?aG?L?B\?333?@  ?0?.{?G?Q?\(?W
=?:H?L?O\)?Q?J=q?O\)?aG?Q?n{??ff???z???p?
=?c
??
?O\)?J=q?J=q?8Q?J=q?L?E?O\)?Q?333?B\?:H?333?z?h>?c
?k?G?8Q?
=?z????R?\)?>H>H?>>H>H>H??   >H>>ff?\>
=>>\>>
=>>(>G>G>G>Q>p>33>>u>R>>>aG>=q>\)>{>u>z>  >u>z>>=q>aG>.{>k>.{>#
>L>L>B\>B\>B\>B\>>#
=G=Q=G>    =G=#
=L=u#
#
.{LͽGuaGLͽ#
=;.{\).{\)L;#
L;#
\)8Q#
8Q.{aGk.{u  \)\)<#
>k=Q=\)>\)=G=G==Q#
<#
=#
=Q==Lͼ

=L=<=G=\)    #
=QL>\)=
>.{>B\=LͽLͽ#
G#
L;ͽu\)\)
\)#
L<#
#
>8Q>.{=Q=L    #
=LͽL<#
=\)=    =\)

Lͼ<#
=\)>#
>L>W
=>>#
>>>W
=>#
>#
>W
=>B\>aG>W
=>#
>B\>W
=>aG>8Q>W
=>  >aG>z>u>>k>u>k>>>>aG>z>k>B\>L>#
>>#
>8Q>B\>8Q>8Q>>B\>8Q==\)>L=u=u=u>>33>=ͽL>>G>>p>(>>8Q>k?&ff?!G>>??n{?xQ?aG>Q?#
>u=u\)#
8Q>>>L==\)#
=#
\)<

<=>.{=G>u>  >aG>u>8Q>\>{>>
>Q>8Q>u>>aG>L>z>  >\)>u>k>u>k>  >B\=>L>.{=G>#
ͽͽQLͼ<
ͼ
u#
#
    u    >#
<=ͼ#
<
#
=G=u
<#
=Lͼ
==u>\)=#
=>B\>.{>.{=Q=u>>z>\)>
u#
>W
==>\)>=\)=G<=L<
#
#
#
L=G>\)=>>k>==G    >
=>>=q>p?@  >?Q?Y>???
=?(?!G?
=q>{>=q=>L==L=Q>=\)=u=>u>aG>\>>
>>
>>
>{>Q>>>R><

<
    #
=L=L=#
=#
>\)=u<=L=u<
#
=Q=u=u<
<#

#
        =#
=\)=\)=\)=Q=G>.{=\)>L=<#
u=#
    
=#
<
uLͽu<#



=Lͽ\)ͽLͼ#

<    L<
    <#
=#
>z>
>8Q>.{>8Q>\)>u>8Q>>8Q>aG>.{>8Q>u>L>G>L>L>u>k>aG>>#
>L>{>u>  >W
=>8Q>#
>\)>B\>\)>#
>=>.{        =G=u=#

    <#
=uLͽ\)Lͽ\)<

uL<#
<#
#
    =\)=L=\)=u<
<=
>L=>>#
>>L>  >8Q>\)>#
>#
=Q>>B\>\)>L>u=>W
=>aG>u?!G>p>  =Q=>>=G>\)=>8Q>#
>>#
>#
=G=
<#
==
==G==Q=G>#
>#
>u>aG>#
>L=G>>>>aG>#
>>#
>L==
=u<#
=#
#
=#
=#
#
=L=\)=u<#
=\)=
<#
<>=<
=Q==u<
=u=#
<
=u<=#
=Lͼ
=#
=\)=>>u>aG>  >k>B\>\)=u=u#
Lͼ==>B\=G>aG=\)>W
=>aG>B\>8Q>
>k>aG>B\>=q>L>
>>B\>u>\)>=q>L>B\>8Q>L>\)>8Q>8Q>L>B\>\)>B\>>.{>>\)>B\>.{>k>W
=>.{>L>8Q>#
>{>.{>=G>#
>>.{>>#
>.{>.{>#
>=>=Q=L=L=

<<#
=\)=u>#
>8Q=#
>#
>k>33>
>k>z>>\)>R?0?>  >\)>=q>aG>>=>L>k>u>\)?5<>W
=>\)>#
>{>>>\>>p>>\>\>\?   >Ǯ>Ǯ>ff>
>Q>  >\)>z>aG>B\>.{>8Q>8Q>#
>8Q>L>k>>
>\)>=q>{>
>>z>R>R>{>z>=q>R>R>>=q>R>=\)>B\>z>u>k>k>L>aG>8Q>L>W
=>B\>.{@ff>8Q>#
>=>\)>>8Q>.{>B\>L>B\>B\>k>{>>>
>=q>L>u>W
=>R>L>  >zᾀ  >u>>=q>>G>??>G>>33>
=?8Q?ff?  ?}p?(?333???\)????\?\?\???\)??\)????\k?   ??&ff=
??(?.{?z?
=qk>G?\)>?(?   ??!G>L?>Q>G>>׼
>H>׾
׾R>?>L?>(=
.{?\)?(\?\)??
=?!G?.{>k?Q?B\?R?z?!G(?333>?   ?
=q?   ?>ff>??>?\?
=q?.{?&ff?Q?=p?B\?
=??z?0?E?E?Q?J=q?8Q?:H?0?333?E?=p?:H?0?:H?=p?5?0?5?0?J=q?c
?E?h?  ?p?O\)?n{?n{?n{?u?fff?h?c
?fff?p?Tz?Y?@  ?G?=p>kff?!G33aG?:HaG?!G?8Q>zῙ?+>Gn{?&ff>Q?녿:H
(þ{?E?Q?:H>H?fff?W
=?\(?fff?
?^R?h?p?xQ?u?}p?G?  ?G?  ?zH??G?}p?zH?s33?n{?zH?zH?xQ?p?u?zH???=q?ff????33?{?=q??\??\)??ff??
=?p??\?33?R???ff????R?ff?ff@H?
=??H?ff?R?\???(??\?R???\)??Q?(?z???
=??R?R?G?p?z?\?
=?  ?R???(?p?p?33????????=q?=q?R?(?p?aG???z?{?R?
=?aG?z????p?G?\??{???\)??
=?\)???\)?p?33?ff?p?ff?{?  ?
?
=?Ǯ?ff?˅???{?=q?G?\)?p?У?
?\?ff??Ǯ?G?G?R??
=??Q?=q?Q??Ǯ?  ?H???33?33?p??޸R?\)?ff???33?{??\)??
?{?{?Q?ff?  ?  ?\??
=?R?
=??p?  ?Q??33?33?\)???ff???  ?ff?{?˅?˅?ff?Ǯ??
??R?˅??R?=q??  ??  ?ff?
?R?  ?\?R?Ǯ?R?˅?˅??Ǯ?
?Ǯ?˅?˅?{??{??\?Ǯ?=q??Q?\)?У???У?\)?=q?=q?ff?\?Ǯ?p?R?Q?=q?z?ff?=q??Ǯ?G?Ǯ?
?ff??\)??ff?\?{?
?Ǯ?
=?ff?33??Q?\)?
=?z?z?H?
=?
???@   @33@   ?
=??{?=q@
=q@@
=@Q?(@ ?
?Q?  ?޸R?=q?Ǯ???  ?z?33?У??˅?Ǯ?
=?\)?{??ff?{?z?{?\)?33??˅?˅?ff?˅??У??G?=q??p??Q??33?z??\)??  ??{?33??{?H?  ?Q?Q?z?H?p?=q?G?ff??\?Ǯ?  ?(?G?Q?Q???G?Ǯ?У?˅?p?
=??\)?
=?\)?p?z?
=?33???H>@
=@33@ʏ\@{@{@@\)@z@\@@@(@\@\@@@@  @Q@@33@
=@
=@@Q@
@\)@{@ff@ff@@@z@@@Q@@@\@Q@@=q@@@z@G@33@@
=@G@{@G@(@G@
@Q@H@@\@@=q@G@@@@Q@H@{@@Q@
=@\)@33@H@ff@@\@@
=@=q@@@Q@Q@\@\@@@33@@R@@33@{@H@
@@@@\@(@@H@@@\@@G@R@Q@  @  @@@Q@H@@@@G@\@@@z@@Q@  @33@33@@\@@Q@@@@@G@33@@\@@=q@\)@z@]p@H@G@p?@  @G?H?Ǯ@33@
H@33@l(@)@G@\@  @Q@@@@ff@G@@G@
=@\)@@\)@@@@
=@p@@p@\)@  @R@@
@p@@
=@\@(@~R@\@=q@I@H@
@@@
@(@@(@@@z@=q@@@@@{@Q@  @ff@@@ff@ff@R@z@R@@ff@{@@33@(@33@@@R@z@  @@ff@@p@@ff@@(@p@33@
@@(@@@{@z@R@33@@@p@z@  @p@ff@Q@@\)@@\)@ff@
=@@@33@H@@R@p@p@@@@@@@=q@zA{@Q@Q@{@{?
@z@@@33@{@ff@@G@@ff@\)A.{@dz?@G@Q@@vff@e@@p@@H@
@u@=q@
=@H@Q@@H@=q@(@(@@@\)@p@
=@R@p@z@@\)@R@p@Q@  @{@@z@
@@ff@p@@ff@@\)@R@p@ff@z@33@@
=@@\)A (@z@R@@@p@@\@ff@
=@@R@@  @@ff@\)@@@@  @R@@hQ@"\@@G@
=@
=@ff@(@(@(@@G@@@r\@(@{@dz@{@S
@@e@^{@c33@@
=@@\)@p@p@z@(@(@=q@33A(@Q@?zH?^R?R@^{@~R?\@e@k@ff?G>B\@  @G@xQ@w@H@z@G@(@@@|@|(@|@|(@  @  @~R@}p@  @}p@}p@}p@|(@~{@x@zH@~{@|@~{@@  @Q@@H@@
@ff@Q@|@~R@(@G@z@@@33@@  @Q@\@p  @H@@@\)@p@R@@ff@
@@33@H@\@ff@@33@ff@ff@@z@@=q@@
@=q@@@@Q@y@|(@|(@z=q@|(@u@xQ@w@z=q@G@\@=q@G@(@  @@\@H@(@@(@{@@{@  @  @@{@@@ff@
@=q@=q@@z@p@p@@@=q@RA
@@@|(A"R@|@  @S33@@33@@tz@\)@~{@@\@@@|@\)@  @G@\@\@@@
@p@=q@\)@G@~{@@G@\)@\)@@@ff@@@
@
@Q@
=@p@@{@p@@p@@@=q@@\)@@@ff@p@=q@@G@@\)@R@\)@G@(@@@\@@@@=q@@Q@  @@\@@z@H@Q@@
@H@H@@@@33@@=q@@|(@  @|@=q@  @tz@G@33@@@@
@33@\@\@\@z@{@@33@\@@33@
=@@@
=@ff@ff@{@R@ff@@{@
=@@@{@ff@(@p@\)@
=@=q@@@=q@\@@G@Q@x@@=q@~R@vff@u@y@w@xQ@w@tz@\)@@@
=@@\@z@G@  @~{@}p@
=@\)@@@}p@~{@z=q@w
=@w@u@tz@w
=@u@w
=@x@s33@qG@u@vff@q@mp@l@nR@n{@k@jH@h@@h@g
=@g
=@e@a@`  @`  @b\@^R@[@`  @Z=q@ZH@ZH@Z=q@^R@i@c33@`@`@Y@Vff@QG@L(@L(@Mp@K@HQ@Dz@B\@@9@=p@;@<@7@5@2\@2\@(@(Q@!@p@@=q@\)@@G@
H@@ff@33?H@ ?H@ ?Q??\)???  ?(?ff?????  ?ٙ??\)?33??
=?=q?H??
=??{?
?\?33?  ?G?^R?W
=?Tz?O\)?Q?5?fff?5?0?E?5?Y?Tz?B\?Y?h?c
?G??33?  ?O\)?H??u?+?(?
=q??\)??   ?>H??   ?>ff?   >>>>Ǯ>{>33>R>R>>>=>#
>aG>=
=#
8Q\)ͽ;\)    þzᾔzᾣ
kQ\Q\  8Q쾀  =qRþ

\)W
=kþp녾
=p\ǮG녾uQ(
=q\uþff녿녿녿!GzR
=qp
;G<#
.{  zᾸQ쾙{þp3333ff
=Q\(?;Ǯ
=zᾨþ;
=
=
=H׾kþ\)\Ǯ녿
=q&ff(!G.{z(.{#
#
((ÿ0׿0׿(ÿ++3330׿+8Q8Q&ff#
׿Ϳ!G(z#
Ϳ(z(ÿ\)
=&ff#
5C  z#
0׿333.{8Q.{.{+
=
=(#
(ÿ
=q#
(<
&ffR+R!GR\)(zR!G!GRz녿
=q!GR#
+R0׿Ϳ\)(ÿR+5RR=p#
\)@  8QLͿLͿR\)z(R(ÿ(ÿ(ÿ0׿=pLͿGTzGB\LͿ=p@  E0׿Q녿\(
   zaG:HE5(:H+#
#
8Q!G.{!G.{&ff!G#
+.{#
(ÿ3338Q(ÿ++5.{.{0׿
=#
+#
!G5&ff.{#
=p+!G(ÿ(ÿͿͿ\)\)Ϳ\)녿
=q녿녿!G#
#
z@zz?LͿ(ÿ(@?
=q8Q?fff?(?
=??\
=q@{ffz(ÿ.{50׿Tz\)z?\)k33׿z?((=qL>@+ÿ   \B\L;G\)?.{?O\)?p׽u녾?=
>u\)?5>>k<#
>#
?=p?녾  >L<#
?+?(?8Q
=
=#
&ff(ÿ#
GaGAQ=#
?>?!GQ>z?&ff\)<
RG>\)+R!G@H#
+333!G8Q(ÿ#
!G@R&ff0׿+&ff+?\)=#
B\B\B\
==\)G?TzǮLͿE0׿(ÿ0׽#
(@G&ff0BCp@<(@?!G@J=qL;ff>\>\>ffkaGRR>
?.{(ÿ0׿#
!G#
z=Ϳ333!G#
  z.{50׿0׾\)!G+333&ff0׿333&ffz@(ÿ
=Q녾R녿zᾅAff#
RaG&ff>HG#
!G(.{3338Q0׿0׿:HG@  J=qB\@  @  333!G#
333(ÿ3338Q:H333=p#
:H.{@  =pHͿ@  0׿5=u!G@z?;\)Ϳ?33@u@aG@ff{?p?ff?
?h?aGB@>Q>B\>
>33>?(zQW
={B~33
=qHB33\Ǯ?\(LͿ   
=?}pDyu   AǮff녾;H>aGz@z=\)@n{aG@4zᾨÿR@>{=Lͽ\)?>R\>B\=q?:HǮu>þ33?.{zff׾
=?E(
=G
=\GQ쾞R\)DK3>
>k
@
H>>Ǯ>W
=>
=>논#
>k
#
>aG>W
=  \)kRpu\ǮHffGR33Dq=#
u=q{pǮz@c
8QA(þ
?(>R?R?@XQ@l@{@l;k@p@Dz?p>u=q@>R@
@I@H?L@@  A z?>aGW
=W
=L;k?0?
==Q@S33@@ff#
\)A2\=#
=
@z?ff׾{@ ׾33p\{\)8Q\?^RaG?   {ýu?p?c
=quQ8Q??=pp    =
=>.{?(?W
=>Q>>>Ǯ>8Qu8QkþL?Q?@  @w?
@
=Cl
=A$׾#
.{kA
\?>k#
@zὣ
?W
=>u>;\).{>=q=Q>Q>\)u>>>L;.{>
=#
>Q@z?ff?z??z>W
=>8Q>@ff?z@>\)#
>8Q?Q@??
=?
?ff?Y@i?>L>?(=G?H@
=@8@,?G@@2\?(??.{?p@H?@?k@??EkC7s3D;K=>#
=Q?\>>
?
=?E?{?R?
??:H>?z>{?
=q<#
>?E?=p?z?
=?@  @-p?\)>B\>z?>?(þ8Q=?!G>>p?R?
=?@g@@  @أ?Ǯ@7
=?G?=q?@\@@  ?ٙ?z?@z@Q@ZH?
=@\)@'
=@@|@@  @C33@,@O\)?\)?J=q?G?+?0@?fffAR??
@Ap?33??ٙ@???\)?333??zH?@?Q?  @ff?@p  @33?{?@tz@?
?@6ff?n{?
@33@l@333?@?{?{>>\@g@k?
=?{?=q>W
=?s33???kA=q==Q>=Q@H@7?ff@l>?Q>W
=>8Q=
?Q=?
?  >R=G>?k@\@.{@jH@z@.{?
=>ff>33?Y?(@@B\@(Q?
=?@{?Q?R@A\?33?#
@Z=q?E?(?R?p?\???p?zH??=q@?
?G@(@AA8AdAAB+B^  Be\BB\)BxpBB=qBYffB%ffB%ffAARBzABQAQB
RBpAQAGAGAHA33AHA(AAA
AAA\)A{AwAx(AfHAW33AN=qA@A9A7A-A+
A-A(QA)pA\)A(A
{A
GA=qA
@@G@\@p@@ʏ\@\@ۅ@G@
@
=@@Ǯ@{@z@p@=q@zAAQA@ƸRA\AA  AA33AB@@A
=@
=@AAzARAAHAA @@@@ᙚ@(@G@A33@@@
@Q@z@H@\)@A	A
=AffA   @@@ffA@ٙ@\)@ۅ@z@33@޸R@ҏ\@{@߮@p@׮@ff@
@G@z@ff@G@{@Ӆ@ڏ\@ָR@\)@Q@ҏ\@=q@@
=@33@
@@
=@@@z@{@33Cff@ʏ\@
@@@
@@G@(@H@@(@@H@=q@@@H@(@p@\@
=@G@33@H@@@  @@A@R@@@HA@
@
=@@
=@Q@{@@@R@@@@@R@
@R@  @=q@z@=q@@(@p@@aG@\)@(@z@(@  @H@  @R@{@H@@ff@H@@R@
@@@@{@R@
@(@\)@33@R@@@p@@R@@{@@(@@z@@@@R@\@\@@G@H@(@@mp@p  @@\)@@  @fff@y@c33@fff@@r\@\)@  @\)@E@33@H@=q@{@R@R@  @  @p@@=qE@33@H@@{@G@R@@@@@@  @\@@\)@H@@@\)@@\@
@@@H@=q@@{@\)@33@@\@p@@ff@(@  @\)@\)@@(@
@\@@(@{@p@33@\)@
@G@Q@p  @|(@(@\)@Q@R@H@q@R@|@g@c33@g
=@U@  @o\)@\)@L(@Q@"\@y@R@
@\)@
=@\@@R@@@ff@@@  @@@=q@H@=q@
@@33@
@R@@  D@vff@G@@z@xQDd=@@33@|(@zH@x@G@~{@|(@}p@h@x@3
@'@%@|@z=q@@g
=@vff@#
@g@k@h@k@a@g@l@
@
H?
=@n{@ @s33@qG@7@r\@qG@p@Q@(@@@g@o\)@w
=@w@
@l@33@@Q@@w
=@@z=q@@G@{@p@w@|(@
=@C33@H@p@@~R@H@jH@C
@vff@tz@fff?=q?ff@p@l@p  @U@g
=@aG@Fff@j=q@<(@o\)@j=q@e@o\)@Q@;@j=q@l(@u@u@z@.R@i@k@_\)@jH@l(@i@c33@p  @dz@l@e@g@j=q@`  @@g@k@l@n{@qG@mp@g
=@hQ@g@hQ@*=q@b\@fff?33@e@QG@{@
@
=@_\)@`@^{@@U@J=q@W@o\)@mpC@W
=@Tz@a@fff@Q@_\)@fff@S
@s33@`@i@@|@33@~R@w@xQ@w@
@x@U@@\)@o\)?\@p  @l@l@<@h@l(@i@z@j=q@e@{@h@kA'\)@HQ@j=q@   @vff@Dz@\@33C|)@~R@@Q@vff@n{@\@@w@|(@\@(@@@@ff@jH@G
=@b\@b\?33@{?@>R?(@E@z@U@-p@?\)@ @>R@o\)?ff@QG@(@	@\?H@@&ff?G@p?@P@P@Q@z@W
=@XQ@fff@J=q@e@e@JH@P  @\(@Z=q@j=q@NR@XQ@E@>{@\(@W@b\@c
@`@k@k@g@l(@e?@fff@\@`  @W
=@ZH@X@Vff@Vff@XQ@R\@X@Y@Y@Y@33@Z=q@ZH@W@s33@Z=q?{A@n{@J=q@^R@e@\(@Q@R\@U@S33@ZH@N{@Q@O\)@Mp@L(@N{@HQ@Mp@L(@G
=@O\)@R?@S33@P@P@<@33@P  @N{@H@E@K@JH@C33@6ff?У@Mp@Mp?p@(@K@5@(@I@HQ@P  @a@Mp@AG@<(@5@NR@A@E@I@L(@_\)@W
=@z@o\)@\@NR@Z=q@tz@^{@NR@`@U@@@aG@r\@k@Y@_\)@dz@Tz@^R@H@QG@Mp@H@:H@*H@U@I@E?O\)@=q@aG@aG@l(@tz@K@L(@*=q@%C^@W
=@O\)@U@O\)@P@QG@W@Q@NR@Tz@7@U@XQ@S
@aG@`  @_\)@U@]p@`@[@[@`@]p@ZH@\(@W
=@^R@dz@W@Q@W
=@Q@G@   @G?@)@@@HQ@E@A@Fff@AG@A@C33@8Q@+@#
@2\@<(@?\)@@@@@@@E@E@C
@HQ@JH@C
@C33@NR@C
@7
=@:=q@8Q@4z@4z@5@7@4z@.{@5@,@.R@1@6ff@1G@5@.{@-p@0  @@  @E@7
=@'@@ff@z@
p@z@RCL@@  @(@@
p@@@z@G?R@   ?p@
=?R?
?p?{??p??=q??G?p?
=?G?(?Q?  ??  ?
?33?{?Q??GF&} ?  ?n{?n{?p?n{?c
?k?k?n{?G?
?=q?{?  ??33?z?Q???H??ff?\??{?\??33??O\)?xQ?@  ?=p?8Q?0?(?5?0?.{?=p?#
?0?!G?&ff?z?
=?(?(?R?&ff?.{?&ff?R?z?333?R?\?c
Eet?(?\?\)????J=q??>H?>>(>
=>ff>G>>p>
=>>Q>>\>Ǯ>
=?>p>Q>>?\)>>>(>\@޸R?>>R>33>\>{z>33<#
>Ǯ?\>8Q?B\?fff?ff>H??G?O\)??R>?DR>>\>\)+><#
>B\>>  >.{@z>.{>  >u>>33>>
>aG>u>33>
>zn{>{>=q@H>8Q@녿
=>Cf>u?W
=>{>R>>k>u#
<

z>\)=    >\)>u>aG>B\z>aG>  >W
=>aG>.{=L=
>.{=>þB\>===Q5=
>>R=L>  >p>R>\)>=q>aG>z>  =u>aG<
=>  >8Q>z=
>.{>W
=>kz>B\>L>B\=#
>B\=q>>Ǯ>>
?\)>aG>Q>
>k>>=Q>u>L>W
=>\).{=Q=p>{G>L>k>u>\)>  >=q>z>aG\)\=Q>B\#
!G0=#
>L>.{>8Q쾙+    >>B\>B\<==\)=#
=LͿL=L=Q=<
#
>aG>>
=>{(?B\>k>?>z᾽p>u>>B\>k>aGB\>k>B\=#
#
<
>=;aG<<
#
=u=Q=L=u=ͼ#
=
u#
=u=
=
<
\<
=u=u8Q    s33=Q=Q=\)>u33>#
A?@z=\)=>=G>>{=G?=
>\)>>#
@_\)#
>#
?
>#
>B\=q>33>W
==u>\)>\)=\)=Q==\)L;RQ>=\)>\)=
??
=q=Q>8Q?(>k=
>k>  B\=>W
==
=.{=>W
=
?c
=G=L=#
>=#
>G=#
\)#
:H=L>\)>#
==>33>
=\)>W
=>B\>\)>B\>\)>#
>\)>\)>\)>\)=
<#
>k>B\>.{>p>.{>>@?p<
=
O\)=L;\)
==\)=\)=\)=u=Q>k>8Q<#
=
>p>  >  >8Q?ff    D:?G>aG?
=q>Ǯ>  >W
=>aG>aG>#
>8Q>u?>  =#
E{B=G>z>aG=#
=
<
>u>u>
>\>(?>8Q?s33?
?B\?#
?\?   ?B\>{?\>.{C˝q?B\>>(?   ?>Ǯ>W
=>\>33?\?>Ǯ>aG>>R>G>\>(>p>33>\)C1?>R>H>\)G>>>{>{@J=q>>u>u>L>R.{??ff>
=?#
>=u>#
>Ǯ>
@
=?}p??Q>>R>
>{>R>>\>\)>GW
=>=q>{>>p?!G?\(=?E?(?:H?aG?k?
=q>33>8Q>(>33=L>\>p>>33>z>>
>aG>R>>\)>
E.	>z>>u>>>\)>z>z>Q>Q>\>G>>>Ǯ>k>\)>z>z>G>u>\)>
=?
=>R>>Q>G?   >?\>L??>p>>RQ>#
+>{(>33#
>R>{>ÿ
=q
>{    >(>\>>
=>
=>Q\)>\>\>L>>Q>Ǯ>u>\)>>=q?@  <>Q=#
>>ff>  >L>p?z?{??{??ff?Q??  ?Y>?(?8Q?G?W
=?J=q8Q??Tz?fff?&ff?5?&ffL?(?O\)?+?.{?333?333?0?B\?pEI>
C}?J=q?h?
=q?c
?}pCf?u
?h?z?W
=?+@@333?L;z?^R?\(?Y?E?k@   ?O\)?h?  ?W
=?^R?O\)?8Q>z?{?c
?Q?n{?^R>aG?L;?B\?(@5?
?\)#
?8Q?fff>z?fff?h?k>\)?@  ?^R?.{(?^R?(?&ff?aG?c
?aG?Q@G?Q??Tz>ff?0?=p?333?@  ?&ff?n{?G?aG>?s33?fff??  ?p׿+B$?\(?O\)?B\?c
?Tz?Q@#33?p?Tz?aG?>33?aG?Y?  ?n{@\)>?}p?k???p???@ff?Ǯ?\?
=@\@b\?(?
=q?  @(?p???@?xQ?(??  ?0@=qA0?\)?333?  ?z?У@?
?H?  ?>33?
=?{??
?
=q?G?\(?u??z?=q??5?  ???\?fff?\)?G?&ff@z?z?^R?O\)?O\)?TzD>f?k?  ?(????xQ?s33?33?=q?
B\??Q??
??G?
??s33??J=q?\)??  ??(?ff??
?(??33>
?p?=q?
?xQ?h?xQ?p??\??\?\)?\)??(???ff??{???
?R?  ?z?H??=q???{??
?>
=?^R?=q?c
?R?R??p?\)?J=q?h?33???Q?z?\)?\)?p?
?G?ff?z?n{?zH?z?ff?fff?ff??fff?J=qff?W
=?
??ff?  ?
?\)?=q??
=Do?zDB{??33?\?33?H?=q??H?z?z?G?z?\)?
=?G?G?Q?z?\?G?(?Q?33?p?
=?Q?zH?
??G??G?  ?33??
=?Q?
?\)?ff?z?
?=q?R??}p?
??
=>LD
)?R?Q?xQ?(??
?R?aG@{?
???  ?O\)?G?
=?ٙ@\?{>33?0>W
=?{?Tz?   ?p?  ??n{?c
DFs3=
?Q?G?D?{?
=?s33?zH?R?h???QEqR?
?ff?
?33?33?ff?\)?
u??h?s33?k?k?p?333=?c
?s33?k?kL?fff?\(?s33?p?Y?.{>p?fff?  ?xQ??=q?  ?33?=q?5?R?(@Q?  @
=?޸R?H@L(?ff??z?R?
??p?
?=q?s33??  ?u??\)?Gp?zH?G??ff?
?\?G>?
=?s33?W
=?u?xQ?G?=q?
!G>33?zH???h??  ?
?  ??  ?=qFi?aG?=q?@
?  ??˅??  ??\)??O\)?ff??\(?  ?s33?n{?n{?h?Ru?\(?k?  ?\(?zH?\?zH??\?\.{?}p?>?{?{?\)?\)??
=>aG?J=q?ff?Q?\)?aG?
=???aG?h?R@'
=?
?(??ff?
=?=q???(?33?h?ff?p?R?z???33???R??Ϳ+?
=?33??
?c
???aG???.{???hþǮ?@?\)?
=?z?HA?(@,(?˅?
=@5?z???\)?=q??{?p?G??xQ?  ?s33?\?s33?  ?xQ?
??}p??  ?  ?G?zH?u?s33?n{?xQ?p?xQ?k?u?xQ?\@e??G?
=?  ?
=?Q?
??
?
=??W
=?ff?Q?  ?ff?G???ff?ff?\??ff?\?
?G?xQ?G?G?uDV?}p>?s33?zH?hÿs33?s33?p?}p?xQ?n{??}p?zH?n{?=q?xQDn?(?z?R?z@???
=?
=q?&ff?G?(?=q?  ?{??=q?{\)?G?H??\)?\)?G?G?}p?=q?G?  ?  ?xQ?  ?}p?G?
??s33?n{?p?z?uD3?Q??fff?
?O\)?33?B\?5?R?:H?G?xQ?\)?  ??(?{@?Q@
?H?Ǯ?Q@@,(@p???=q?(?  ?  @(?@(?ff?????p?(?(?R?ff?ff?G??\?
=?\)??????}p?G??}p??33?{?Q?R?G?=q?\)??
?}p?\??=q?{???#
?\?s33?zH?u?aG?aG?h>  ?p?  >8Q?R????=q??z?z?  ?z??\)?  ?E?z???
?????
=?z??=q?{@	?(?G????У??\?R?s33?\?H?(?Q?}p?  ??z?{>?J=q?녾G??  ???{??@E?33???Q?33?{??\?(?  ?G?=q?H?  ?  \)?R?33??z??\)?
=??\)?Q?H???????\)
=q=Q쾅\)?Ϳ?333>z?zH??n{?.{?33?
=?p?33?  ?ff?ff?Ǯ?J=q?33?=q?z???Q?H?ff??h?h?>u??Qu?33?p??33??p??
>
?H?(?R??z?R??C>?G?=q?{??
=!G?????˅??R??33?{?˅??(?\?
?{?Ǯ?ff?\)?G??>?H?@
;W
=
?z?{???  ?У??^R?
=?<#
?ff?Q?\??ٙ?=q?ٙ?\??Q@{?ff?\??ff<?R?z@@@!G@{?{?33??޸R?!G?\)?p?(?\)?
=??R?
??ff?p?\)#
??(?
=?z?  ?z?H??
=q(?>#
?s33?  ?=q?H??
??\)??\)???p?(?z?z??
?G?G??У?aG<p?\?ٙ??=q=L?G??{?  R?;u8Q?\33ͼ
8Q=?u=\)??:H??8Q@9@\@@@@'
=@*=qCк@@
@-p@6ff@<(@%@(@@Vff??33@Q@ff@Q@  @33@
p@R@
?z?{Cb??\)?{?ff?ff??fff?Q?(@   ??R?@ ?(?=q>=q@8Q?У?8Q?H???Q?
=?H?(?  ?p?ٙ?p??  ??H?
??33??ff?Ǯ?33?
?=q?\)??=q?G?Ǯ??Ǯ?ff??
??(??p?H?\)?R??W
=?333?aG?Ǯ?
?=q?G?  ?У??H?Ǯ?z?ffD
(R?\??
??p?\)?G?G?=q?@
=?(??˅??Ǯ?  @Q??H?  ???  ??\?=q?У?ٙk???У?k??޸R?H?G?Ǯ?(?\)??H??HAQ?\?R?G?(?\?=q???}p??p?p?R?
=?H?p?
=?Q?G?B\?33?Q?R?.{?p?H?k?R<?Ǯ?  ?(?˅@R8Q?xQ?{B\?{?
?G???
D{?Q?Q?  ?G?Q?ٙ@@	?
?(Ef?p?Q?(?  ?z?ffz?z?
=?
=??Q?\?Q?޸R?޸R?z?ٙ?G?  
=?(?ff?0?Q?
@ @??R@ @ ?p@(@
@8Q@?ff?Q??{?@z?˅??=q?ff?˅?У??Q?G???У?ٙ?p?޸R?\?p?У?L???>8Q??@Dz@ ?(?33?H?@\?Q?޸R?=q?(@?  ?
??\?ٙ?У?>
=??z?33??\)?Ǯ?Ǯ?У?R?\??޸R?=u?ٙ?
=??ٙ?ٙ?޸R?Q?z?33@>R?p?(?
=??}p?=q?{?p?(?zDd3?
=??G??\)?H?\)?z??\)?\)?ff?(?{?z?\???ٙ?Q?У?H???
=?z?\)???\?(?
=?ٙCj=?޸R?=q?\?G>=q@G?@8Q??@\@p?=q?  ?Q@
=@
H@  ?=q?  ?fff?ٙ?
????\)@\@
?G@\@(@
@
@
=q@B\@!G@G
=@L(@L@2\@E@{@
@@  @33@@\?\@Q?G?z?@Q?p?Q?=q??ff?\@\@\@*H??\)?z?R?H?\)?=q?33??Ǯ?  ?
?\)@
@QG@33@@4z@C
@  @?p?
?@^R??\?G?
=?  ?p?H?G?
?R@[@
=???{?\)?H?k??(?޸R?˅?z?Q??(?p?  ??Ǯ???  @
=q?H???ff??\)?=q?R??H?H?
=?G?G?p????{?޸R?33@[??z?
=??=q?p?@z@?p?Q@Tz@!?=q??\?У????
=?  ?H?(??G??p?p?
=?(?(?z??Q??R????{?ff??Q??33?Q??z??33?=q?{?(?p@?  ?G?\?>
=?p?(?\??z?\)?
=?{?J=q??????{?
=?=q?ü#
?B\?^R??\?
?
?{?ff?fff??(?Ǯ??\???{?
?ff??@ ??\?
????Q?{?33@???p@?G?p???p@.R@
=@(@2\?zH?Q?fff@@#33@`@ff@u@G?s33?n{?
?G@7@R\@?z??ٙ?^R?L?Y?G?!G?  ?\(@?fff?L?aG?E?@  ?B\?B\?xQA׿@@  A@L@*=qAz@E@E@Tz@QG@O\)@R@l@u@QG@U@VffDI;@S
@S33@P@S33@L@Tz@U@U@L@A@Y@S
@U@U>ff@[@\(@p@[@@\)@x@
=@Y@ZH@A3@xQ@B\@I@S
@W@U@W@\(@_\)@W@k@@p  @e@aG@{@s
@
@JH@a@b\@b\@a@b\@`  ?(@dz@`?p@c
@b\>@
@j=q@@H@dz@Vff@e@;@,(@dzG@fff@NR@c
@`  @x@e@fff@g
=@c
@h@k?D@Q@k@mpBVR@jH@|@n{@q@y@XQ@nR@o\)@\@g@Dz@n{@@qG@Z=q@\@@nR@s
@s
@u@s
@b\@l@o\)@p  @\)@s
@q@@R@u@ZH@\(@|(@\@|(@\)@xQ@@Q@k@@ff@@G@@u@g
=@q@p@o\)@p@HQ@p  @aG@n{@dz@k@h@j=q@mp@jH@i@33@k@fff@g
=@{@mp@\@c33@b\A  @e@<@$z@e@QG?@4z@2\@A@b\@aG@(Q@g
=@e@q=#
@p  @u@\(@u@u@Q@n{@jH@j=q\@e@jH@h@g@k@jH@Ӆ@p  @i@jH@i@l(@l@@j=q@QG@?@e@l@k@@=q@Q@@=q@\@@o\)@@@Q@7
=@qG@Tz@p@{@\@q@\(@`  @[@`  @hQ@l@zH@p  @p  A@y@@\@p@e@g
=@i@p@xQ@=q@nR@o\)@{@u@j=q@p  @z=q@i@`@jH@n{@i@;@1G@L(?p@HQ?&ff@E@5@U@R@@p@~{@~{@{@|(@_\)@c33@?G@\@W
=@@
@p  @nR@n{@Y@C
@θR@h@dz@hQ@-p@W@g
=@nR@p@0A@
@ZH@Q@JH@[@u@}p@y@h@@p@\)@@u@X@
=@(@nR@@\(@X@\(@p  @Q@*H@[@Z=q@
Ax@P  @X@L@33@^R@h@]p@4z@@8Q@Q@^R@q@tz@S33@R@p@2\@  ?(@c
@\)@Tz@Tz@K@N{@AG@O\)@I@N{@?H@@/\)@Vff@S
@=p@.R@U@P  @.{@B\@<@Q@@@l(@Dz@r\@xQ@c
@y@p  @k@e@e@g
=@l(@fff@ZH@h@b\@h@l@q@k@h@l(@u@g@qG@n{@w
=@H@@G@|@@(@33@\@wA:\A  @AG@7@G@Mp@y@=q@@^{@s33@\)@R@Q@@g
=@vff@@@33@l@{@N{@ff@fff@zH@1G@ff@{@\)@p@R\@
@@`@@\@xQ@ZH@B\@E@G@X@Dz@[@,(@Q@c
@g
=@@tz@p  @y@o\)@vff@_\)@[@`@\(?H@P  @Y@Y@S33@Z=q@Tz@X@Z=q@aG@_\)@b\@L@^R@c
@aG@ZH@j=q@l@hQ@`  @e@b\@QG@`@Mp@J=q@aG@@R@@@ff@@ff@R@
=@@G@=q@z@@{@33@@@33@=q@H@b\@^{@g@j=q@Q@
=@
@P  @R\@Tz@Q@R\@U@S
@Vff@\@Y@Tz@U@Q@U@\(@i@mp@hQ@`@`@\@]p@X@hQ@K@Dz@>R@S
@XQ@W@E.{@ZH@C
@\(@ZH@E@hQ@z=q@NR@U@=p@p@g
=@G@`@4z@_\)@Y@U@R\@<@]p@\@X@5@a@dz@r\@vff@w@=p@u@@i@l@l@z@o\)@\)@A2ff@θR@n{@hQ@QA@z=q@@
=@@{@\@J=q@s33@W
=@N{@XQ@Mp@^R@HQ@HQ@J=q@J=q@G
=@E@H@E@Fff@N{@I@H@J=q@@׾Ǯ@@Z=q@Tz@U@U@U@U@U@XQ@X@X@_\)@i@J=q@x@}p@G?s33@Q@qG@
@`  @\@?O\)@z?(@jH@@  @[@z=q@Y@@h@tz@Z=q@S
@S
@7
=@R\@P@R\@Q@W@P@U@\)@Y@@R\@QG@Q@O\)@JH@Mp@Mp@J=q@G
=@H@@@
@\@?Q@@أ@n{@@Q@  @ZH@ff@l@
@\(@(@ZH@`@H@G@^R@@G@C33@ZH@z@33@@ZH@b\A@[@a@H@`@e@W
=@ȣ@e@(@G@N{@QG@P@P  @*H@'
=@L(@B\@XQ@Y@\@`@g@g@g
=@q@{@z=q@@@@\@Z=q@R\@QG@L(@K@XQ@>R@w
=@;@7
=@8Q@7@7
=@;@E@:=q@?\)@H@G
=@A@=p@8@9@2\@.{@0  @)@'
=
=@!A-p@33@.{@!GAK@<(@\)@G@k@@
=@Fff@33@
@\)@  @z@ff@(@
=q@ff@z@   @ @\?H?(????=q??\?  ?Q?
=@??z?=q??
?  ?  ?  ?G?z?z?{?(??{???Q?p?R?>.{?z??׾Ǯ?\)?G?33?\)?\)?
??  ?33????ff??  ?Q?
=qpQ??=q?=q?z?z???R?=q??\)?\?\)?=q???5?  ?  ?0??ff??H?\)?\)?Q?\?{?
=?  ?33?
=?R?33?˅?=q????
=?\)?
?}p?zH?fff?^R?O\)?G?E?G?
??{?Q??˅???z?{?\?pC澸?
=?H>G?33?޸R??
=?H?(??\?\@Y@q@Y@@(?z?ff?{??>??H?R?R@
H?Q@!G@G?p?k@?z?p?@R?#
?
=?z?0@   ?(@\@ ?Ǯ@1G@E@	@'@@0@{@33@`@33@
=q@%@@!G@=q@c33AQA@H@\@
H@@Q@/\)@
p@\?G?˅@0@
p@.{?
@%?
@jH@?@C33@.{@Q?5?k?O\)?:H?333?Tz?=p?0?=q??
=?ff?{?z?Q?\)?p?
=?@0  ??  ?
?
?(?z?z?  ?R??Q?
=??ff?ff?z?(@
=q?G@??O\)@ff?=q??=q?\?Q?33?G@p?W
=@C
??z?\)??\)?=p?@ ??#
???
=@1G?(@A
=??p?  ?O\)?G?ff?{??{?ff?У?p??H?{?}p??^R?k?=p?.{??
=q>?n{?:H??\(?aG?aG??{?ff@?{?\@p  ?{@?h?h?!G?@?H?(?p?c
?{?J=q?
@(Q@{?E?=p>\)?  ?ff?\?p@g?{?@<(@?z?H@
=?H?Q@  @ff@Q?z?ff?˅?  ?p?R?G?zAR@333@@Q@p@|(A@G@k@(@b\@@\)AG33@`  @Ǯ@@?R@Q@>{@ff@aGA!p@@H@33@
=@
=@\)@@~{@s
@qG@@z?
=@=q@  @H@Q@@G@s
@@$z?@@'@*H@0  ?У@@@.{@.R?У??33@(@!?Q@\??L??\?\)?0??z@'
=@
p?{??  ?  ?\(?n{??ff?\?@G?\@{?
@@(@Q@
H???Q?H@
H@@A@@@=q@@8Q@>{?@e?fff?R?R??
=?}p@@%@qG@U@!G@>R?ff??H???n{?5??   ?z?333?J=q?W
=?E?J=q?L?zH?p?p??ff??˅@   @:H@33@\)@
p?(@,(@0@1G@*=q?  ?\)@\)?p?p????(?z??\??ff?
=?p?z?ff?Af=q@??>>?\@   @
=q?@?ٙ@@@\)@?ff?H@8Q?33@9@5@@E@/\)@|@q@33@u@J=q?=q?  ?R?Q@&ff@zA???Q?=q?R?ff?z?R?{?ff?H?Q??ٙ?
=?У?\)?\?\)?Q?(A?\)?
=@z?\)@H@{@AG@{@J=q@\@B\@?\)@u@8Q@7
=?\)@{@4z@
=@L@@!G@+???\???^R??R???  ?{?{?G?
?
=??p?p?  ??\)?
=?G@R?=q?Q?33?R?aGA?˅??{@(?
?
=?^R?{?G?
????Tz??aG?H?\??z??Q?z?
=????=q?O\)?}p@*=q?G?zH??  ?s33?W
=?aG?8Q?L?Q?R?k@
=@@@fff??W
=@,(??
@@H@ ?\)?ff?h?\?{@'
=??{?\??
=?R???(?>?ٙ?z@ff@@?H?ff????
?\?\?\????Q?h???ff@
=?˅?=q?Q@Dz?n{?W
=?(?W
=?@  ?R?\(?B\?=p?J=q@ @ff?s33?^R?\)?O\)?@ff@33@?G?Q@AG??5?J=q?G@6ff?Y?5?:H?:H?J=q??=p?fff?B\?.{?n{@?@?L?8Q@
=>?J=q?33?ff?33?W
=?(@
=??ff?R@
p??R?H??Q?
?#
?ff?+@?\??\)?Tz??Q??ff??\@R@J=q@,@\?Ǯ?Q?Q@@H?G@H@@\=L>(?(??
=k?B\>?:H?@  ?:H?G?L?@  ?@  ?^R?333?   ?@O\)@ff@@Ӆ?>H>Q?k@
=?p?8Q?J=q?R?&ff>(>H?z?z?@  ?
=q??   >>?\>\>H?@  >>(>>??0?O\)?:H?  ?\)?G@z@^{@@:H@G@H@L(@@??(>  >8Q#
>?0>G?R?R?Tz?ff?k?z??n{?c
??33@  @C?
=?E?@  ?5?Tz?33?u@z@Fff@\@@
?E?Tz?}p?}p?\(?k?B\?W
=??\(??O\)?(?8Q>?s33?\(?Q?{>H??
=q>>
=>H?   >\>33>>>\>ff?>ff>\>33>>>z>aG>8Q>
=>>
>>  >8Q>L>z>aG>W
=?(>33?n{>Ǯ>\)??
=q>???#
?Q?(?0?
=q?
=q?=p?Tz?@  ??zH?H??=q?Ǯ?33?ff??
?
??H?33?\)?G?R?^R?c
??Tz?G?5>H?Y?{>z?333>z>B\>z>aG>=q>=q>z>\>\>Q>\>
>\)>33><>.{=>=q>  >{>z>33>(>=q>\)>G>{>z>L>  >\>L>aG>B\>\)>B\>#
?}p>aG>B\?(>  >=q>  >k?>=q?R?z?(?.{?!G?8Q?s33?@  ?u??zH>\?G?@ ?Q??ٙ?\?
?zH?\??p?\?
=?\@{?
=?33?H???33@z??R?
=?z??0??8Q?h?O\)?u?}p?  ??=q?=p??s33?  ?  ?u?  ?h?p?c
?aG?}p?H??^R?G?zH?  ?ff??=q???G?G?(?33?}p?z?n{?^R?n{?W
=?z?h?#
?Q?zH?\?E?n{?p?k?h?Tz?@  ?333?#
?
=>?!G??B\?\)?h?Q?Y??^R?^R?}p?G?=q??ff??E?
?У?k?\)?c
?
=?R?H?
=@8Q?\)????Q?n{?u?  ?u?u?
?s33?\?xQ?fff?zH@?s33?G?L?G?G?:H?O\)?Tz?Q?J=q?aG?Tz?k?W
=8Q?p?p?W
=?h?s33?}p?G??xQ?}p?E?\?Y?aG?
=?0?z??L?@  ?8Q?333?@  ?W
=??(?R?8Q?\(?L?B\?c
?@  ?(?B\?&ff?W
=?&ff?3330?G?!G?^RǮ?\???{?{??
?@   @b\?J=q?ff??Ǯ?  ?G@?zH??p?HC&f?#
?  ?ff??p?\?G??zH?}p?n{?fff?uk?zH?^R?Y?n{?YW
=?Q?\)?{?ff?Q?k?k?^R?k?c
?}p?xQ?k?s33?Y?Q?  ?c
?G?B\?Tz?\?h?B\?k?(?#
?0?0?G?B\?@??p?Y?c
?Y?\(?zH?Q?Tz?W
=?O\)?G?8QR?5?=p?5?Tz?Y?Y?W
=?k?h?  ?&ff  ??33?33?{?W
=?ý???
??ff?  ?Q???u?{?\)?(???H=Q>#
?@^{?C?
?C?33???33?
=@
H?˅??z?\)?R?{?G?p?\)?G?Q?
=??p????z?z?{?p?\)??R@
?R@\@Q@ڏ\A=ADA@QAjHA
=AtAQAXAzAHA{AQATzA]A\zAAA[
=AkAdA|(AS\)A\A(A\)A\)A
AmpAqADA2\AO
AADApA{AHAARAHA33AA
ApApAA\)BHAA
B
=B
B
=BB(BAHA(AA33ARA\)AۙA(AHAQAQA  A\)A=qA\)AGAzAzA(AQA
AzAAQA
A\A  AAAAffA\)AAwA{
As
AuAjRAl(AAxzArRA
Aw
AhzAb{AYA`zA[AN\ADARRA`zA[33A>ffAEGAG33AN\A<QA;A?\)A8(A<zA8A3A;
A?A,QA4A8A+A zA   ARAGAffA
A
ffA\)A  AAffA{A\AAffA @@A QA Q@A@@@(@  @  @ff@G@\A]@  @߮@У@ə@@@H@@@
@p@
@@\)@33@
@
=@@33@
@Q@ff@@@@
@@\@z@@@\)@  @33@{@G@\)@z=q@vff@p  @s33@mp@r\@c33@\@O\)@P@G@Vff@\@l@\@}p@Tz@N{@;@5@L@K@E@Dz@Y@@O\)@8Q@[@Tz@U@dz@\(@XQ@ @S33@U@e@J=q@AG@Tz@5@6ff@!G?@=q@@(Q@#33@@ @{@@@@@\@0  @R@@\)@   @@H@ @!G@*=q@*=q@(Q@ @*=q@#
@\)@#33@
=@z@??@\?ٙ???{?R?
?{?=q?Ǯ?R?\)???ff?
??p?{?H?\)?z?p?
=???ff??33??QCC?
=???
=?=q??(?
@#33??ff?aG?8Q?ff??:H?=q?DgN??У?У@!G?=q?(@L@<@hQ@\@B\@U@b\@q@@@@@Tz@Q@@H@ApAHA9A?Ao\)A2=qAj{A\)AA{AGAA33A33AAAffAAAGAA\AAA{
A
Ac\)AZ\A<ANRATA\A[
=A^=qA:RA.\A (A=qA,AAA{A(A	A @R@\)@G@
@ff@  @{@ff@ҏ\@=q@@
@Q@\)@@@\@@=q@R@<(@@@Q@y@o\)@o\)@qG@~{@tz@{@  @
=@
@i@  @
=@@e@u@aG@G@i@p  @C33@w@(@H@vff@`@@@0  @fff@@y@Z=q@L(@Z=q@A@<(@6ff@,(@L@:=q@]p@n{@aG@g@^R@R\@NR@Fff@NR@@@`@4z@xQ@zH@vff@hQ@W@=p@U@H@>{@0  @%@"\@.R@:=q@C
@G@G@XQ@QG@b\@g
=@p@_\)@U@$z@7
=@
=@@ff@@@ff?Q@R??@(?{@C33@,(@(?s33@Q@"\@/\)@1G@@p@R?p?p??\@z@a@
@@R@{@Vff@?\)@,(@@r\@b\@/\)@C
@C
@QG@5@%@"\@@@z@>R@!@#33@5@C
@;@.R@"\@   @\)@\?Q?ff?(@?ff?(??Q?H?Q?\?H?
=?33?Q?\)?H?R??\(?z?33???\?Q?(?
=?\)?\?
?
??.{??}p?s33?\??{??p?H?{?G?޸R??z@'@5@<@AG@:H@Fff@G@?\)@8Q@0@(Q@ @Q@ @\?p?=q?G?z?\)??
=????ff?
???H?(???z?H?
?G??(???=q??Q?H??z?zH?\)?Tz?h?s33?h?fff?p?xQ???{?G?z?  ??ff@3
@S33@  @"\@\)@>{@ff@#
@z@1?p@@@
p@p@=q?@R@@0@ff@ff@  @@
?p?=q>Ǯ?R?H@
@\??\(>H@@ff@ff@@@Q@@
p@@\@
@ff@33@@(@\)@
p?H??R@G?z?\@?޸R@@33?33?=q@ @   @?  ?\?(@G@?R??
=@
H??R???Ǯ?G?˅?
=?
?
=?p?\)?ff?R??H???(?H???
=?G?\?@33@@@Mp@(Q@-p@,(@.R@0  @!@"\?(@-p@5@(Q?z@ ?޸R??H?  ?p?ff@L(?@@\??ٙ?G??޸R?{?ff@\@@@#33@*=q@'
=@@<?R?W
=?ff???G?@@@
=@.{?Q@@ff@@@
=?ff?{?޸R?޸R?  ?
=?{?У?33?{??@33@33?
=@9@@@@\@33@G???
=?ff?R?p???H??\?˅?
?R?Q?H?(?z?ٙ?(?=q?  ?33?  ?33?p?ff?ff?Q?@@?  ?{??{>?{>\)?G?p?z?H?=q?@?\@33@33?R????
??33?R?H???  ?Ǯ??J=q??Q?R??H?z??
?У?=q???H?33?33??{???z?p?@@@@
=@@ff@	@(?R?ff?z?(?R?ff?G?޸R?(@ ?@	?(??(@HQ@'
=@@ ?=q?p?ٙ?@@R@333@\)@1@Mp@^{@;@@@
@?\?H?H??(A1?{?ff?p?33?޸R??\)??\?\)??p?=q?n{?
?У?p@ @(@!G@C
@(@>{@\)@C33@3
?ff@,@?H@
@   @z@ff@Q?R?(@z??G?ff?
?z?@G@
=@z@@ @
?H??Q@   @?p@ff@(@(@\@33@33@\??R@33@
@33????  ?(?{?{?G?p?޸R??33???ff?G@ @8@=q@.{@B\@N{@4z@3
@$z?@p@
@{@
=>33@z@ff@	@*H@+?@ ?\?=q?G@{?p?  ??ff?ff?
=?n{@@?(?z@ff@z@	@
=q@\)@ff?
@z@(Q@(Q@ @@@H?33@ @?\)?p?p?Q?
??(@G?z?@@   ?
=?@?@z@\?R?(?z?=q?G?޸R??G?{??
?
=?
?p????  ?޸R?
?
??p?ff?(????p?Y?=q?ff?{?{?=p?(?H?
=?(?(?
>>R?
@?Q?
?ff?R?z?33?aG?=q@ ??=q?33??=q?(>?޸R?p??ٙ@?H?ff@   ??z?
=?У??Ǯ?ff?Ǯ?=q?G???˅?Q?
=?Q?\)?˅?ff?=q?  ?R?ff?  ??{?{?
?{?33?{?z?
=??
=?(?˅??=q?  ?z@ ??R?  ?(?  ?ٙ?{?z?R????R??=q?У?Ǯ?(?@(@
=>33?(
???\)?R?(??\)?>?fff?aG?^R?\)?R?=p?G?zu??R?R@<(@
@7@?R@   >?p?
=?ff?
=??=q?{???У?(?\??33?33?{?z?  ??ff?z?\?{?R?\)??Q?z??\)??z??z?????
=?Q?Q???ff?ff?????Y?
?(??G?
=@\@@@z?  ?
?\@@(B?p@33@R?@??
=?H?˅?(W
=?G?
=?????{?5?Q@
=?@@G@\)@0  @@
H@#
@@'
=@1G@&ff@??\?
?\?=q?˅?{?\?ff???
=?Q??G?
??
=?H?33?(????{?ff??G??
??R?    ?
=?R?G?Ǯ?У??У?=q?  ?ٙ?
=?H?z?ff?33?(??  ??H??{@
=?H@R??A?@+@,(@'@
=@*=q@\@H?R?R?(??У??z?c
?>???Y??u?ff??G?
??33?p?????{?33?Q?
=??
=?z?
=??R?z?33?\?G?Ǯ?
=?{?{?
=?ٙ?z??p?@?z?Q?\?z??˅?
?z?Q?Q??=q???=q?\?ff?(??ٙ?z?p?
=?{?ff?{?=q???
??z?G?\)?33?GA(?p?Q????
=?n{?ff?޸R??
@
@G?(C?ff?G?Q?z?z?  ?z???
@Q@@
==\)@  @ff@^R@@??\)??(?  ?H?Q??У?33?ff?ff?Q?  ?Q?G?z???{?R?p?G?p??33?ff?p?ٙ?  ?@G???p?ٙ?޸R??ٙ??\)?=q??Q?Q?
?H?p?p@R?У?33??Ǯ@Q@33?
?G@   ?@@@<@B\@?ff@8Q??\??
=??
?Q??z?z?
?Q?33?G?ff?  ?H?p?R?
?=q@:=q?????{?G??\?(?p?
???z??{BLB$pF{?  ????\)?
?H?=q??=q??=q??#
Q쾏\)Q콣
>
??Ǯ?W
=<
z?:H>?  >L?z?G?(?ff???p?Ϳ녿@  ?H??\?=q>H?{?R??  ????Q?H??\)?
=?\??޸R????
=?  ??33??Q?p?\)?ff????H@?R@@!?R?R@
=q@@  ?p@ff@?R?33?
=?ff?  ??  ?{??G?33??p?=q?p??\?\?z?\?G??R?Ǯ?R?Q?33?p?p??Ǯ@33@#33@,(@-p@*H@
=@33@@@=q@@@\??\?R?=q?  ??
?Q?G??{?33?33#
?Q???}p?33?
=?p?  ?
=q?G???Ϳ\)???\)?Q??????33????\)?\)?\)?z??
?R?Q?????}p?  ?p?n{?
?p?xQ????{?H?ff??R?G??
=?(??33?H?\?
?
=??\?G??Q?\?p?  ?Q??{?  ?33?Q??z?p?@\???\?33???G?  >\?\?У?
=?z??ff??
=33?(?}p?zᾙ?Tz?G??Hz?
??\)??33??zH??
=?p???{??33?
?\)?
?G???{?\?H???H?Q?33?G?  ?{?z?˅?Ǯ?\)?G?G?z?
=?p???
=?H????33?
?(?Ǯ?R??˅?RA$  ?H?=q?  ???У??G?
=?G??;B\>>>?ff@33@@?R@@
p@Q?{?33?
=L?G??33?}p??  ??p??У?z?Q??У??R?H@ff?\)??
?(??޸R??  ?\)?(?  ??{?  ?=q?????  ??@*H??H?p??H?R?p?Ǯ??\)BB?Q?  ?
?\)@\)??\??z?\)?z????R??
=?33?{??
=?\)???˅?ff?p?@.{@FffBH??У?H?Q?  ?(?=q?
=?\(?D?Q?˅????R?>?  ?p?Q?{??  ?@   @@ff@ff@ff@@%@7
=@.R@-p@-p@%@'@=p@7@ff??(?
=?
=??Q?33????(?\)?Ǯ?R???(??(?Q?(???  ?\)??ff??˅?ٙ?ff??33?\)?  ?H?ff??
??
?R??
?{@?p?=q@0  @%@+?(@C33@\)@l@[?@N{@C
@=p@-p@z@!@  @(@(??У@@\)?Q@H?R??Q@\??p??R?
?(?  ?H?
=?(?(?
??33?У?33?\)?˅?=q?
?\?(?  ?R?  ?H?\?p?˅?G???z?\)?\)?33??\)?\)?33A?R??
?R??{?33?
?  ?\?Ǯ?У??Ǯ?ff??z??޸R??=q?z???\)??G=q?p?33?@#33?p?\?p?\@ ?  ??\)?(@G??@
p@@\@(?{?
=?G??z?@ @
=@@  @(Q@%@33@@(@@@ff?R?(?@z?p@Q@B=q?{?
?\)?R?\???
=?=q??=q??33??{?  ?@G@?33?(?H?ff?{?޸R?
=?33?
=?ff?33?\)??У?ٙ?ff??
?Q?33?
=?R?
?Q?p??@Q?H@z@@@
@&ff?&ff@Z=q@>R@'
=@7
=@@"\@2\@ff>B\?z?=q@G@33@   @\?@Q@@@&ff?\)?\?=q?ٙ??c
?p@ff@6ff?
?
?  ??
=??
=?G??R?Q?\)???=q?z??H@\@!G@@@R@	@\?(@33@G@u@U@=p@\@@	@?R@33@@4z@>{@AG@z@p@33@
@
=@
H@z@z@@
=q@G@@z@?\)@
@@@@G@陚ARA$zAT(A]A_33A.HAH(A~=qAR\AAvRARAAYAj\A>{A=GA>ffA*RAHAA@  @AA
=A\A\@Q@@R@@GA(A{AA(A"RA'\)A33AffA\AzA3
AGANffAYpALALAD(AKAZ{Ah  A{
AAиRA(AGA
=ApAAAzAAQALQAUAAoAhzAeAqAh(A_33AVffAB\AHA>ffA1A+A#
AA=qA33@ff@@p@(@(@@\@33@@߮@޸R@{@p@@{@@@@@@@G@@ff@@Q@z@\@(@޸R@@@޸R@Q@H@
@ff@ٙ@ٙ@ff@  @@@Q@z@@@@@ƸR@=q@\)@H@p@  @@@\)@(@@p@
@33@{@G@p@ff@Q@=q@
=@@@{@@@R@@@33@p@@\@@R@@Q@@љ@@θR@@H@33@@@@\@@@  @@
=@@@@H@ff@p@{@
=@  @z=q@~R@33@\)@@@ff@R@p@ff@
@\@H@{@
@@@ff@@@n{@w@G@s
@~R@{@\@G@zH@@x@\@u@s33@w@e@g
=@U@@6ff@G@I@:=q@E@AG@B\@6ff@;@4z@0  @>R@333@%@<(@8Q@/\)@*H@(@;@@ @*H@<(@'
=@*=q@\)@\)@\)@*H@.{@'@/\)@'@#33@!@{@G@)@,(@*H@!@)@'@0  @P  @@*H@1G@   @<(@E@6ff@1@'@&ff@,(@{@(Q@=q@,(@$z@@5@-p?=p@@R@\)@'
=?@  @*=q@+@#33@
=q@  >\)@$z@)@*H@-p@.{@:=q@Tz@AG@8Q@5@0@(@'@P  @333@*=q@0@Q@"\@$z@'
=@9@G
=@L@>R@AG@0@-p@/\)@2\@.{@*H@@)@#
@R@)@%@\)@!@   @"\@,@.{@3
@8@*=q@1@8Q@+@Q@@
H@z?p@G@??
=?@ @@@!@7@1G@;@-p@.{@   @$z@.R@)@2\@L(@0@;@3
@@  @ff@
=@b\@B\@6ff@,(@%@'
=@#
@7
=@*=q@;@AG@,@#
@@?\)@@R@
=q@@33?H???R@@
=q@2\@1G@@(@"\@   @@Q@G@
p@{@@G@z@33?@
@@\)@@
H@G?(@??@@@@  @#
@@(@
@(Q@&ff@/\)@@<(@*H@8Q@p@!G@@
@Q???{?(?Q?ff@?R@	@@@Q@
@@(@ @R@{@!@@#33@&ff@&ff@p@$z@R@@ff@@@z@   @?  ?  ???  ?Q?Q?  Eq?ٙ?(?\?\)?
??z?H@G?ff@
@H@ff@@
@
@
>u?@
p@\)@P@#33@ff@ff@	@{@?33@\???(?R@
@   @\)@  @@@@@@@{@
@Q@  @\)@   @@H@!@   @!@-p@-p@\)@@@
H@@	?
=?ٙ?H?
?@?p?=q??  @33@@\@z@G@@\@,(@z@33@(@@@ ?
=@
@
p?\)?Q?ٙ?p@@?(?D)??p?H?  ?=q?(?G?p?G??\)?ff?Q@
?Q@z@@(@=q@
p@@	@
=@ff?p??R@ @Q@@
p@
p@@R@@(@
=q@@
H@Q@33@@Q@@
=q?H???@33???Q?=q?\)@G@@\)@p@{@
=@
=@R@
@z@	@
p?(@RD/@z@\@?\(>?p@@@Q@33Dw\?=q???
?޸R?У?ٙ?\?\@?G?A?@j=q??p?p?޸R?H?У?Q?H?p?H?
?Q??c
?\????@G@   @?{@z@ @
=?(?Q????ff@G@@	@R@(@\??H@ ?Q?G@33@G@ ??  ?\?(?{?H?p?33@ᙚ@)@@!G@{@(Q@:=q@.{@1G@$z@*H@G@@\@?33?xQ@H@@{@.{@!@%@=q>R@z?H?@?33?z?\???У?
?\)?ٙ?@\)@'@-p@@{    ??Q?@?@(?R@@(@\)@$z@!@c
@i@
=@(@\)@Q@ff@
=@R@  @y@G@[@p@ʏ\@\)A@Q@=qA z@RAzff@{A2R@A@G@\)AzAQ@ffA
GA{AA1GApA%GA0A\)A%pA1A33A)AAAA33AHA  A{A@HA
=AQ@@@l@@
@@ff@{@@@@ff@G@{@@X@@
@Q@e@z@\@ۅ@p@@@=q@\)@@p@R@z@p@@H@@Ӆ@(@e@}p@
@@@\)@
@p@@@|(@tz@~R@Fff@l@]p@=p@333@aG@g@@=q@Q@z@\@\)@33@=q@@@{@
@\)@p@{@  @Q@\@H@
@@ff@\@@{@@@@@@(@{@ffB.G@Q@(@@
@\@z@z@@HQ@Y@AG@Dz@(@@
@=q@s33@@{@@ff@@@z@@G@@
=@}p@=q@33@@Q@\)@@=q@G@33@@y@p@@p@qG@c33@@  @z=q@tz@Q@g@j=q@tz@\)@s
@\@A@<@U@a@jH@mp@w@s33@nR@R\@n{@}p@x@p@s
@h@x@g
=@l(@y@q@e@hQ@g
=@a@c
@o\)@dz@g@|(@w
=@l@Vff@4z@(Q@G
=@8@U@H@P@O\)@K@9@NR@B\@AG@>R@Fff@G?h@7
=?@,(@Q@/\)@G@@?@$z@N{@:H>@p@O\)@~{@ff@AG@_\)@dz@xQ@n{@^R?C@NR@NR@W@p@fff@z=q@QD)3@@e@dz@P  @;@HQ@I@C33@>R@L@U@L(@N{@tz@jH@XQ@7
=@Fff@J=q@2\@(@&ff@NR@Q@hQ@z@8@;@8Q@6ff@<(@G
=@;@7@8@\)@Ӆ@@H@\@33@@@@@  @H@@vff@@@ff@@H@\@ff@z@x@^{@ff@Z=q@n{@L@`?33@\@dz@a@>{@p@Vff@b\@`  @HQ@=p@1G@-p@'
=?@2\@*H@@R@ff@@@   @'?z@1G@<@C
@33@C
@L@]p@U?=p@\(@Tz@HQ@1G@<(@8@Fff@H@8@C
@mp@`@Q@`@G
=@I@U@h@]p@X@\@U@K@;@9@7@@  @7@ @.R@R@@Q@H@33@H@@
@ff@@\)@p@\)@"\@&ff@$z@R@*=q@.{@333@1G@%?{@0@*=q@*=q@-p@*H@\)?@&ff@33@p@(@6ff@+@"\@(Q@G@@*H@5@   @
=q@
p@;@  ?
?(?
=q??R?>?  ????Q@@G@@@
?޸R?H?(???\)??
=?Q@\@\)@p@@#33@*H@,@@!G@,@[@k@l@i@l@l@C
@B\@!@{y @@\@  @@  @@@:H@`  @ZH@R@@=q@R@@33@B\@dz@s33@r\@{@u@r\@hQ@[@Vff@c
@e@U@K@?\)@k@dz@_\)@P@AG@J=q@0@#33@p@33?
=?ٙ???z?z?R@I@C
@p@@\)@@#
@@@-p@@???@@  @?У???33?ff?@@
H@(?G??=q?
=???(?z@@>R@jH@H@z@x@[@~{@dz@Y@(@G@@G@n{@o\)@b\@Y@e@l@^{@L(@@  @Y@C
@(@(Q@&ff@\)@E@(Q@\)@Q@/\)@   @'@ff@@=q@@{@@   @(@z@\@
p@@?@33@=q?(?R@
p@Q@@?(?@?=q@z?z??
=?(??z??H?H?Q?\)??
=??ff?  ?R?33@
=q@-p@@  @7
=@:H@+@,(@ff@G@???\?\)?G?޸R?{@ff@@{@ff@@@1G@!G@'
=@#
@4z@3
@1@%@{@5@8@Dz@0@.R@0@#
@#
@@@@9@0@5@<(@1@0  @.R@(Q@:=q@\)@@#33@@=p@1G@?\)@>R@(@@@G???R???
=?p?\)?G??H?R?@{@
=??33?  ?{?
?@*H?p?G@@\?(??z?z?H?  ??p?p???޸R??{?
=@R@
@\@	@	?(@33@\@  @33@@%@\)@@  @
@@=q@ @G@\)@%@\)@\@(@!G@.{@5@4z@/\)@%@(@%@@?\)?p@
=@@{@*H@2\@*=q@*H@@{@>{@+@@
=@
=q@@33@{@*H@7@B\@P  @j=q@S33@U@K@Fff@3
@,@.{@E@QG@W
=@2\@5@)@@#33@
?  ??L?Q?^R?}p?J=q?#
?=p?}p?
?  ?h?u??ff?(??
=@33@R@Q@@
H@@$z@
@(@$z@(@;@5@333@5@333@H@5@*=q@z@@Q@@z@\@Q@ff@   @p@@	@
@?p?33@@   @ff@ @G@ff?p@?{?H??ٙ@  @@??޸R?\)??z?\?z??  ?=q??33?
?  ??h?H???\)??G?ff@?H?
?\?fff?^R?u?\??
=??R?H?ٙ?=q??G?
?޸R?(@\?33@   @
=??ff?ff?ff??G?@
=@@/\)@"\@(@2\@5@9@B\@P  @H@w@@u@@`@nR@
@'@
@z@
=@33@@\)@33@Q??\)@\)??
?33?33@ff??p?z?
=@G?(?=q@
=@
=??z??=q??У??33?p??p??\)?H??\)?{??=q?Q??xQ??H?z?\?{?=q?  ?k??fff?=q?=q?\?Ǯ?\)?
@@@
=q@z@1G@Dz@K@hQ@O\)@\(@P@G
=@<(@/\)@@7
=@HQ@4z@7
=@!@@@#
@2\@(@jH@6ff@1G@K@2\@P@E@S33@E@8@?\)@NR@J=q@H@J=q@HQ@JH@X@:H@N{@qG@z=q@X@W@>R@C
@+@0  @>R@/\)@0@+@%@)@%@*=q@ @#
@Q??ٙ??
?z?{?˅??
=?R?ff@ff@
p@
@{?  @\?H?33???H?=q??
=?(??(??H?ff@@R@!G@/\)@U@l@G@33@R@(@(@@Q@ff@=q@@\)@
@H@Q@H@{@
@(@H@G@G@{@@\)@H@p@Q@R@{@z@@33@@
@@
=@@H@@z@G@\@
=@n{@
=@  @\)@(@R@
@~{@j=q@b\@Vff@6ff@j=q@.{@Fff@Mp@9@B\@*H@\)@
=@=q@G@/\)@#33@.{@,@L(@8Q@+@]p@n{@=p@G
=@R??  ?Q??
?ff?
=?(?\)?=q?ff?
@Q@(Q@;@N{@nR@\@~{@Q@}p@y@33@\(@@G@y@@@p@H@
=@G@p@@@tz@{@\)@=q@s
@{@H@@fff@U@=q@Q@@(@Q@P  @G@\)@C
@?H?z??@@
@+@33@@\)@  @
=@@H@r\@c
@qG@w
=@u@Q@dz@g
=@a@S33@@R\@@\)@#33@)@7@E@7
=@3
@)@@c33@Y@S33@0  @1G@fff@j=q@:=q@I@1@z@@33?@@@%@Mp@HQ@p@
@@
@p@\)@(@(@@{@@z=q@\@33@s
@=q@@\@_\)@@@{@  @
=@(@{@tz@|(@(@(@\@s33@nR@s
@fff@u@z@@}p@@33@@ff@
@@H@H@aG@QG@G@Mp@z=q@H@w@`  @a@a@c33@`@[@\@`@C33@K@C
@#33@{@z@=q@
=@
=?R?
=??Q@
@Q??
=?p?޸R?@33@@7
=@a@4z@~{@xQ@ff@(@@z@@@\)@w@p@ff@@@@\@(@{@@ff@@G@@ff@Q@R@33@H@@陚@
=A @Q@@33@R@{@(@ff@z@@@Å@p@z@\)@p@(@@@@@R@@{@ff@g
=@mp@p@(@e@h@L@HQ@C33@:=q@XQ@)@W
=@Q@XQ@Y@hQ@e@W@NR@Z=q@L(?p@???=q?G??G???H?=q?\)?33?(?=q?R?(?\)?z?33?33?
=?z??33?G?33@
@   @,(@(Q@6ff@A@N{@^R@aG@]p@jH@hQ@qG@|(@=q@
@@=q@  @ff@@
=@p@p  @33@~R@@(@@@H@tz@{@zH@u@s
@~R@
@|@vff@s
@qG@n{@p  @o\)@g@g@s33@mp@xQ@`  @g@]p@U@\(@W@L@NR@H@JH@Vff@I@A@H@1G@1G@5@:H@:H@Fff@W@)@Mp@5@$z@{@{@33@@
=q?33?
?
?ff??z@@
=@@?
?
?33?@  @=q@@   @ff@:H@JH@P  @XQ@`  @r\@@@  @H@z@H@z@@ƸR@Q@Ϯ@@ff@=q@
@R@{@(@  @@@@@\)@@=q@@ff@@@p@@
@R@Q@ff@
@R@p@@w
=@x@`  @ff@c
@dz@QG@Q@>R@W
=@W@8Q@A@aG@K@B\@<(@,(@+@@  @1G@0  @@
H@G@ff??ff?@\)?˅@z?????}p?=q?  ?
?\?ff?33?  ?{?  ?z?  @@'@H@>{@XQ@X@@p@Vff@E@C
@QG@dz@h@~R@Vff@c
@a@aG@g
=@K@0@>{@N{@=p@QG@e@}p@R@\)@H@(@g@p  @
@@Q@Y@a@Q@C
@;@A@>{@<(@.{@*=q@-p@,@+@,@5@R@(@@"\@#
@R@(Q@@\@%@@(@
=@
=??  ??  @	@ ?p?z?ff?Ǯ?\?
?33?
=?޸R?s33?s33?\(?z?33???H?z?@
=q@(@*H@&ff@0@:=q@E@?\)@>{@B\@HQ@O\)@XQ@^{@Y@a@l(@^{@g@g
=@l@Z=q@j=q@XQ@]p@P@[@Q@C33@R\@P@@@I@I@G
=@@  @`@N{@O\)@9@E@@  @8Q@/\)@5@1G@B\@B\@3
@C33@C
@1G@333@.R@5@7
=@,(@*=q@)@\@@
=@ @	@(@@
=@
?{@@G@@=q@#33@(Q@=p?@?H?ff?\?Ǯ?
=??
=?p?{?H?p?  ?
???zH?Q?\(?J=q?s33??{?
?ff?\)??\??z?H?  ?
=?(??У?  ??ff?(??
?
??
=@G@G?p?ff@z?@G@?\)?33???
???ff?{?ff??ff?  ?Ǯ?33?У???޸R??=q?G?\)??H?
=?p??Q?ff????Q?  ??s33??ff?H?G??R?33?\?G?p?  ?W
=?G?=q???xQ??}p?c
?@  ?n{?h??zH?
=?xQ?ff?(??R??{?  ?ff??ff??p?޸R?G??ٙ?  ?޸R?(@33@@@   @??{?\)?
?H?33??33?ٙ?  ?\)??  ??z?  ?G?\?H?ٙ?
=?p?(??R@@   ?@?p?(?H??H?z??H??R@
=q@ ?p?H@  @@
??@   @G?Q??z?Q?Tz?=p?L?zH?
?u?aG??c
?s33?aG?^R?Tz?Tz?aG?O\)?c
?fff??33??
=?{??Q?ff????Ǯ?z?H?{@R@(@ff@   @(@?R?\?????{??\)?У??{?{?\)?\)???ff?=q?33?\)?˅?
?33?˅??H?Q?
=?Q?z?{??R?{???ff?p?H???\??ff?\)?Q???  ?(??\??z?\)?J=q?n{??s33?u?zH????p???\)?
=??z??
?\)?G??G?p?
=?p@@z@@=q@H@#33@@ff@Q@(@'
=@R@ff@H@-p@\@p@$z@  ?{?R@@??33?
=??{?=q?=q?Q?R??33?=q?{?33?=q?33?\)?\??p???Q??33?R?H?
=?
=?Ǯ?ff??G?G??\)?(???\)??33?
?ff???33?\)?p?s33?h?h?G?Q?G?G?z?(?Tz?n{?  ?ff?z??u?33?
=??G???33??(@   @\@@  @\)?@\@R@G@@Q@@)@3
@$z@8@*=q@(Q@'
=@p@(@'@{@.R@   @!@#33@@=q@@	?Q@@@\@
=@@@@R@   @@
H@   ?
=?p?\?R?{?\?R??p?@ff@\@(@Q@	@@@$z@0  @
@4z@@z?z?=q?H??z?(?
??\)??{?xQ?h?c
?  ?u?\(?ff?
?G?\)???ff?ff?
?(?\?\)@	@
=@33@\)@(@(@\)@'@:=q@7@7
=@?\)@dz@;@5@7@Dz@*H@$z@B\@0  @;@!G@
@@33@G@\)@@Q@@@Q@(@Q@	@
H@G@Q@@z@ff@@G@
?
??@
=q@ff??(??R?
=???G?G??ٙ?\)?  ?R?\)??ff??
=??xQ?=q?
?\?  ??G?^R??Y?xQ??Q?\?H?G?p?  ?  ?{?(?У??@ ?
=@
=q?@@\@@\@ff@7
=@0@\@JH@`  @\@1G@B\@   @3
@Vff@R\@I@\@W@A@=p@Y@#
@<@'
=@
=@ @!G@&ff@6ff@'
=@0  @@  @\)@
H@
p@@{@{@Q@@@R@(@z@#
@<(@   @	@G?ff?\?p??33@
@ff@ @G@@  @R??\?  ?=q??z???H??G?(?  ?\)?33?z?{??\?Q?33?\??@ff@@z@R@@%@\)@:H@=p@c
@n{@:H@@@/\)@4z@2\@8Q@333@)@<(@L(@`@p  @l@=q@\(@~{@dz@\@p@[@ZH@e@a@jH@q@b\@@Q@s33@E@J=q@&ff@P?@^{@S33@u@P@7@(@   @(Q@Q@B\@7
=@@,@i@+@ff@9@@>{@e@=qA z@g@ff@R@H@G@@R@?QA@@@33A\@RA5GAs@b\@/\)@s33?33@@@33@HA;\)AA\)A z@AqAS33A\ARAR@=p@HAAffA(AAAlAH@RAFRAMArffA^HA9GA`@1Ap@33AAGAoAEAAi@c
@QA
=ApAG33@=qAb{A2=qAAt(A-GAg\)AIA~{A'33A]AYGA-AA(@%A
A)AV\AALA8A9p@A33@*=qAAjff@ADQASAuAaA[@\A
AqAs
AbRA(AAϙAGA\)@33BCBA  AAz@A33AJ=qAo\)B=qB(BAHBB(\B{B
?
@c
@Tz@Fff@\@Fff@1@W
=@Y@S33@aG@`@qG@G@Fff@C33@@@=p@I@A@7
=@1@R@(Q@p?R@
?  @Q@
=q??ٙ?z?Q??  @Q@
p@@@
H?Q@?H?p?@33@ @ff@@{@@R?Q@ff@
=q?33??33?33?H?H@G?{@??Q??z?R?(?O\)?=q??H??G?  ??{?(????{??33?xQ?Q??H?????
?\?{??R?
@@Q@
=@@@
@p@ @4z@(Q@$z@@@H@Q@
H@@@
H@?@
?(?z?G??(?(??\?˅??\?33?{??У??=q?˅?H?
=?ff?Ǯ?z?
=?p?R?H?p??
=?\)?{?Q???H?
?\?G?ٙ?????aG?c
?k?O\)?+?0?}p?=p?333?.{?^R?8Q?=p?(?G?zH??=q?\)?p?(?H?\)?(??H?p?˅?@@
@
=q@@@\@
=q@
@\)@Q@%@{@@
H@{?\)??
=@
=?
=@
=q???33?{?˅?\?{?ff??
?
=??z??????ff?u??
=?R?G?=q?R?p?L?zH??ff??H?p?{?\?\???
=?
=??(?R?H?R???G?G?{?H?p??\??xQ?W
=?\?zH??{?Q?u???  ???Q?R?  ?Q?
=??G?
??R?У?(?(?޸R?@33@ ??
=?
@   @@z@
=q??
?(?ff???Q?(?z?=q?H?{?????=q?p??\)?33?ٙ?  ?\?  ?ff?Q?z?(??z?G?\?G????
@
H??(??
=??
=?=q?  ?ٙ?ٙ?
=???  ?\?ff?
=?u?zH?h?zH?n{?n{?G?zH?fff?E?zH?s33?\?zH?zH??\???z@(@@(?R@@
=?
?\?
=@ @ @\@JH@2\@@1G@ @"\@6ff@"\@8Q@@p@@\?@33@R@G@@@@
=@
p@\@@@p@Q@
p@)@7@.{@AG@#33@\)@ff@H@!@!G@#
@1G@*H@.{@ @7
=@.R@!G@\)@=q@z@
=@?33@\@ @z@ff@@G?z?
?H?\?ff?\?\?H?Ǯ?\)?˅???z??G??  ?ٙ?Q@@R@ff@HQ@Q@qG@@p@33@ff@\A AA33AzA6HA{A  AzA+\)AA\ARAA(AAQAAAffAAzA33@ffAAA(A=qAARAHAA
GAAA{@R@ffA @\@33@\)@\)@\)@z@@
@{@@@G@@θR@Q@
@@Q@Q@\@33@{@@@@@G@p@@@33@ƸR@=q@ٙ@33@\)@R@@@@@@@ʏ\@˅@H@A{A*HAZ{ArHAuGAA\)AGAQAA33A=qAәAA
B
A\)AЏ\AQAˮApA=qA
=AAHAzApAAzAARAAAAAۮAAQAARAAAAAAAtAQAffA
A\)A  AA  ApA33ARAHAAzA\AApzA\ApAw
=Ac33A33AHAW
=A)AwAL  Ap  A^HAJ=qATQ@
AqpAH@˅A
=A{A33@@A>RA  AVRAC33AApApA7
AAAGA/A\)A33A
=ApAA{AHAHAA
AA(ARA33ApA[\)AZ\A  A(AApAAGAAAtzAGA33AxAlzAAtzA=qARAA\AzHA
=AiAjHAVRASAD(A5GA?33A:ffA;
A&=qAhA\AXAW\)A[AaA@zAJ\A,  A^ffA?
ADAS\)AcAUAIAL  AhzAS33AMpA7A4(AYAHA?33AhQA\(A8A{A"\A(  A"\@  A@@Å@߮@ϮAHA.RA AS
AyGA(AA\A\A\  AX  ApA^=qAh(Ao33A~{A  AffAA
=AA{A  A}AA=qAA4A
ADzAHQAnffAlAmAWA AA!AHA<(A7A\)A	A{A(A QAAKA&HAHA\)A\)AzAAG
=A8A{A\A (@=q@  @@H@@=q@@\@33@
@\)@\)@\)@
=@33@33@33@@@33@p@R@ۅ@@Q@\)@@~R@z@x@
=@ZH@@G@@\)@@@ʏ\@GAAG@@zA
=@pAGA Q@@33A=qAQ@@(@ʏ\@\@  @@Q@Q@@陚@@=q@ۅ@ڏ\@@{@@G@G@  @H@
@@S33@Q@p@33@a@  @G@@G@@z@\@p@(@|@xQ@u@|(@\@l@u@g@u@tz@fff@dz@zH@g
=@g
=@_\)@QG@P  @I@Dz@K@1@(Q@'
=@ @   @%@!G@R@(@/\)@"\@z@Q?R??p@33?(?@
=@G@@@'@\)@+@@\)@"\@$z@Tz@zH@J=q@^{@[@nR@i@s
@33@(@@@\)@z@\)@Q@33@r\@W@N{@@@'@
@
=q@
p@
?Q@@
H@{@\@@@ff@@ff@@(@Q@ ????R?p??
=???ff@@G@@z@ @@@   @
=?R?H@
@\?@	@\@@33?H@   @?
=???Q?=q?\?Q@z@G?Q?z?H?ff?H?=q?@ @
@
=q@@??R@\)@@G@ff@ff@@ ?\)?Q@@ff@(@@  @{@@\@{@@{@?p@   ?\@   ?(?p@
=@@G?(@
p@R@33@\)@{@
@z@@@p@@\)@
=@(@{@@
=@@G@@
=q?z@Q@?33@33@G@ ?@G?@???p??\?p???p?z???(?\)?{?  ?{??\?Q?˅?  ?Q?(??ff?У??(?z???{?=q?33?  ?33?H?(??
=?=q?  ?{??33?{?ff???
?\?G?{?Q?p?p?{???=q?33?z?{?
=?{??  ?R?{?\?33?p?p?ff???=q??Q??\)?
=?У?Ǯ??Ǯ?\)?=q?Ǯ?p?R??R??z?
?R?
?ff?{???xQ??
=?{?H??=q?Q??
?\?=q?\)?\)?}p?  ?p?p?G??????\?{?z?(????  ?fff?=q?H??H?
=??\)???\)?Q??p????
=?  ?p?{???Ǯ?ff?  ?
=?
=?˅?33?{?G?G?p??޸R??У?p??33??Q?G??p?H??33?
?(?Q?
??Q??˅?{?\)?
?\?33??
???=q?u??s33?ff?
?  ?  ??G??G??ff???У?H?33?=q?=q?(?\?\)?p?\?R@
@R@z@
=@Q@R@\)@
=@
=q@G@ @@G@@@,@:H@<@8Q@8@B\@>{@E@0  @1G@-p@ @-p@\)@$z@1G@AG@6ff@0  @*=q@0  @(@#33@4z@1@5@G
=@E@{@\@@@G@@@@@Q@  @\)@@H@)@#
@(Qy @(@R@'@"\@'
=@*H@@@5@@@@Q@G@@
=@.R@,(@c
@AG@>R@H@I@E@@c33@)@H@@.{@(@Q@33@
=q@@{@+@.R@1G@7
=@7
=@C
@C
@Fff@Mp@H@I@G
=@?\)@6ff@5@,@+@3
@7
=@8Q@5@6ff@-p@5@$z@2\@/\)@-p@%@.R@0  @!@0  @%@#33@"\@@   @   @(@\)@#
@(@'@R@0@#33@!@Q@\@ @%@:H@p@;@tz@Q@b\@c33@e@`@w
=@=q@`  @O\)@fff@HQ@z=q@l@nR@X@333@%@K@@@_\)@w@~R@  @@ff@@=q@G@θR@ff@\@\)@p@
@
=@\)@
@=q@G@@У@@=q@ʏ\@R@@@@33@@  @l@r\@|@Q@@Q@@y@zH@zH@q@q@|@p@vff@\@q@G@@jH@ff@~R@~R@^{@h@?\)@U@<(@?\)@A@333@!@"\@1Gy @1G@1@?\)@8@1G@=p@=p@;@Q@`  @Y@Y@`@Dz@P  @J=q@AG@W@5@,@4z@J=q@4z@*H@7
=@:H@Dz@-p@>R@U@`  @l(@JH@`@?\)@/\)@=p@0@>R@<@S
@Mp@R\@NR@Tz@@@33@@\@
@
@@33@  @y@J=q@]p@N{@"\@B\@<@@@@@E@S33@L@Vff@P  @Q@JH@S33@fff@i@QG@9@%@5@0  @1G@;@@@7
=@5@7@:=q@<(@0  @0@7
=@(Q@#
@1@#
@,@#33@@@
=@@
=@@"\@,(@;@/\)@:=q@
@
@\)@*H@7
=@{@1@'
=@p@R@\@\@G@ @,@(@:H@Dz@G@Y@`  @H@U@.{@Dz@333@6ff@E@J=q@^{@qG@G@1G@@@
H?p@'
=@E@J=q@e@U@B\@<@#
@*=q@@!G@/\)@@p@H@@Q@@	@@@@=q@=q@  @
@z@ @Q?R?
=???Q??=q???\?˅?Q??
?{?33?Q?@?R?ٙ?=q?p?z@(?R@  ?(@?(??{?{??z?\?
??ff?(?33@
???(??
?У?˅?\)??p@{@
=q@33@@
p@Q????=q?У?H?Ǯ?
=?{?@\)@Q@\@
=q@R@33@\@\)@33@ff@G@ @ @
H?@   @(Q@R@H@@ff@\)@
H@@ff@@Q@(@@Q@
?z?ff?
?H?(?z?\?H?(?\?
?  ?  ?Q?\?ff?ff?(?У?G?33?\?=q?G@?(@33???Q??H?\)??Q?  ?\)?Q?
=???
?(?G???(??(??
?ff@G@(@
=@
p@@!G@5@*=q@'@2\@<@G
=@L(@L(@HQ@P@P@O\)@P  @K@G
=@E@C
@Dz@AG@AG@<(@/\)@3
@C33@$z@,(@5@*=q@*H@5@'@)y @-p@'
=@*=q@&ff@@
@@@	@{@@??޸R?
=??  ?
@\??H?G?˅?R?z??z@\?Q?R@\?
=???\?  ?G?R??@ff?\)??Q?(?H??Ǯ???\?\@R@\)@=q@+@2\@*=q@'
=@8Q@S
@C33@L@G
=@Y@P  @j=q@o\)@c33@tz@(@|@e@G@~{@\@^R@\(@HQ@}p@i@g@Y@Tz@E@QG@A@C33@<@.{@NR@Vff@8Q@#
@1G@J=q@0  @.{@,@0  @!G@8Q@0@'
=@R@%@!@!G@{@p@33@
=@?Q??=q??33?H?z?p?
=?
?
=@*=q@
p?(?Q@	??\???Ǯ?У??H?ٙ?ff?R?=q?Q@
=??@{??  ?33??@@@Q@@@  @@\@\)@%@#33@/\)@&ff@%@5@S33@`  @H@>R@7
=@.{@L(@p  @Y@C
@1G@7
=@C33@"\@<@C
@B\@1G@z@@33?@Q@G@33?p?Q??
=@
=@ @z@
H@\)@z@333@   @@?  ?Q?޸R?
=?H?ff?H??H??
=?˅?ff?p????z??(?Q?33???zH?=q?ff??G??33?ff????\?=q??У?޸R?{?33?У??
=?Q???33@@\)@   @Q@@?{?
=?p?=q?(?z?ٙ?z??  ?G?\??У????G?Q?(?  ?p?
?G???{?p?  ??p?z?
?G?Q?\?Q?
=???{?\??
?h?Tz?s33?J=q?\(?L?fff?xQ??
=???\)?Ǯ?p?
?c
?n{?333?0?Ǯ?\??
=q?B\>??8Q?R>G??\)>?(?.{?8Q?W
=?xQ?p?R?p??Ǯ?p?\??\)?=q??  ?\)?z??p?H?{?G??H??33?\)?У??Ǯ??У?޸R?z?ff?G?У?33?z????(??p?Q??z?
=?p???G???
?=q?Q?
??33?Q???H?
=?G?G?=q?R??\)?  ?G?=q??n{?u?
?W
=?\?u??\(?Tz?^R??33?Q?{??xQ?  ?ff?У@ ?ٙ@   @\)@=q@ff@R@
H@@   ?{?H?޸R?Q?=q@!@ @Q@R@(@
p@
H@
@(@G@@@   @\??@   ?  ???{??R@ ?ff@33@z?@	@z??33?(?(?\)?=q?G?\)????33?ٙ?p?ff?z?Q@@H@R@#
??33@@??
=?z?  @\@   ?
??\)?33???ff???
=@p@3
@:=q@5@
=@/\)@\)@G@
@
@z@?33?33?˅?@@
@
=@?p@??
=?33?(?\?\)@z@33@33?33?z??H?p?R?\)@@{@"\@	@  @z@@	@  ??H@33@Q?{??Q?G?
=?R?޸R?\)?Q?p?
?ff?R?z??p?H?Ǯ?\)?z?Ǯ?(@@
H@\@@
H@\@@
@z@\)@??H??H?H?{?zH??\?h?xQ?  ?{?xQ??H?ff?  ??p?Q?\?@  @
H@33@G@
=@   @Q@{@(@33@(@@@33@@#
@4z@Tz@<@'@/\)@8@ @%@*=q@333@$z@,(@(@@H@{@{@R@@G@  @
@Q@!@{@33@@@R@ @&ff@1G@"\@H@33@@(@G?p@ff@@?
=?
=@?@@@@@E@  @
@N{@\@
=@@u@@8Q@
=???  ??G??(?Ǯ??
=??@\?ff?H??G?33@   ??\)??p@@%@*=q@;@333@;@?\)@z@.{@S
@G@^{@Y@h@fff@\(@U@^{@N{@S33@Mp@Fff@O\)@U@P  @X@Y@Tz@0@JH@G@`@QG@.R@8Q@C
@4z@5@9@.R@\)@)@
@@0@   @%@Q@.{@,(@<(@*H@7@Dz@*=q@C33@.R@Q@@33@R@%@@
=@=q@E@aG@Y@\)@z?\)?R?33?  ?
?\)??z?{?  ?˅??Q?z@@@G@@@z?p?  ?@
@
=@g@]p@l@p@R@@(@z@Q@z@\(@S33@C33@2\@\@6ff@(@<@NR@3
@5@+@.{@
@G?ff@@5@<(@S
@^{@XQ@  @=q@s
@_\)@N{@@@>{@7@0@;@ @@@3
@0  @,@$z@,(@K@9@8Q@ @6ff@>R@E@L@8@\)@=q@:H@8@AG?@p@@@R@<(@@(@.R@hQ@
=q?
?H?=q??z?G?p?{?z?  @:=q?z?\?\)@ @ff@@R@&ff@/\)@\(@w
=@fff@E@\@B\@fff@@z@u@\@R@Q@@@ָR@У@  @
=@@\)@@p@G@ƸR@{@(@@@@@Q@xQ@Q@8Q@.R@<@3
@\)@0@Vff@#33@W
=@g@Q@^{@jH@jH@L@JH@jH@`  @_\)@&ff@QG@8@<@z@@ff@R@
@Mp@G@G@NR@.{@R@R@:H@$z@H@?\)@e@$z@{@33@@@\??p???Q??\)?ff?H@{@Vff@K@_\)@\)@
@\@U@H@@33@@
@Q@\@@=q@@H@z@=qA@J=q@u@jH@\@u@\@xQ@\(@zH@{@g
=@L(@l(@JH@zH@O\)@@ZH@P  @X@\@\)@mp@
=@i@@@QG@@  @333@7
=@B\@K@B\@AG@N{@E@!G@1G@@@[@QG@HQ@dz@`@R\@HQ@I@C33@G
=@Q@S
@K@O\)@Dz@Q@U@`@5@4z@!G?33?@%@`@:=q@Y@)@,(@+@,(@E@=p@9@P  @A@=q@Q@p@(Q@]p@z@z=q@@G@ff@R@
@@AAp@p@޸R@@L@=q@jH@E@e@s
@@R@ff@(@G@33@=q@׮@@z@@@@
@@ۅ@@Ϯ@@@(@33@@@H@@@=q@ٙ@ff@@G@H@@@@@@(@@\@(@@z@@@  @ff@@\@@
=@\@@@{@@@33@p@@z=q@Aff@@ff@{@
@RA@@H@33@@Q@@G@@\@\)@ffA	@@(@@@@  @ff@=q@J=q@@Q@  @H@=q@@  @G@  @33@
@hQ@g
=@@R@A"HA=q@@\)@33@@\)@@@@G@G@ff@\)@33@
@@أ@@أ@ff@@@G@@  @@@@@@ff@
@\@s33@e@]p@dz@[@dz@u@^{@@y@Q@\)@x@hQ@@`  @@|@g@|@ff@q@@@\@H@H@@R@z@(@  @@ff@z@(@A zA@@ff@ᙚ@33@H@{@Q@Q@@H@(@@@
@{@{@33@\@Q@@R@33@p@@
=@H@G@@@u@@G@  @
=@@z@
=@R@z@H@p@hQ@U@Y@Vff@Dz@=p@=p@Fff@E@Dz@L@G
=@P@Dz@JH@:H@AG@&ff@<@0  @;@5@L(@Tz@0@R\@{@5@(Q@c
@@p  @c33@l@qG@@{@@@@z@Q@=q@˅@@G@(@љ@R@@z@R@H@˅@@@33@ff@@  @(@G@@p@{@@@  @@
@@z@@@@G@@Q@Q@H@\@@@@@\@Q@|@^R@A@H@C
@.R@B\@/\)@*H@'
=@!G@'@:=q@.R@;@5@@  @N{@qG@^{@9@B\@E@U@A@jH@E@G@2\@C
@`@(@&ff@ZH?  ??@
=?=q@p@W
=@{@G@:=q@
H@G
=@@*H?@@(@Q@@2\@g@@=qA
\@@@G@H@@A\)A0QAABH@@\@(@
=@@ZH@33@@eA!@=qA
=q@G@
=@tz@W@Q@s
@k@xQ@@h@@=p@E@@z@c
@R@33@@nR@  @\)@@(@H@\)@@z@l@H@XQ@u@@H@(@G@@R@p@  @@@@\@b\@r\@Q@
=@e@@(@@}p@ff@@(@@G@@@ᙚ@z@A@p@
@
=@{@RA
AAffA((A3A4AB{Ax  Az=qA\)AAvHA?33A  A|AA~HA>{A$  A=q@
=@z@\)@\)@@޸RAQA#\)A.{@A @  @p@(@@(@AH@=q@ə@H@(A\@
=@\@
=@\)@z@AA{AR@@pAzAHA
{A((A*=q@zA\A(@=q@
@  A
=A  @=q@G@=q@@R@p@=q@@@\)@(A
\A@@ffA
ffA@{@@\)@\@z@\)@  @Q@
=@R@ə@{@\@
=@W
=@أAzAA33A,(A7
ApzABffA<AA{AD(ALA
=AAQAR=qAzAL(AC
=A@@@H@(@AR@@\@@@
=@R@
=@  @@@W
=@@vff@[@@@qG@|(@ff@@ff@z@z@ff@@@
=@@G@vff@  @H@
@{@@G@
@@  @  @{@p@@R@H@@\)@\@@@
@hQ@|@@
p@^{@X@Fff@G@dz@E@@  ???p?33@\@E@@\@ff@
@@@{@AA@AO33@@(@<(@3
@:H@u@qG@Vff@Y@_\)@@33@e@x@p  @w@b\@;@I@>R@:=q@Dz@:=q@>R@7
=@@@_\)@`@[@B\@H@
=q@@H@Mp@Vff@\(@Fff@S
@<(@5@@
=@
=q@R@{@.R@C
@@+@P@Fff@-p@,@,@-p@1G@(Q@0@E@5@9@?\)@
=@E@\)@:=q@,(@!@2\@!@?(?=q?ٙ?У???@G@C33@U@S
@]p@_\)@[@r\@7
=@
=q@R@:H@Z=q@JH@p@أ@@\A
A
=qAApA\)A6R@G@zH@G@E@W
=@A@C33@8@@@K@e@g
=@E@HQ@Dz@QG@7@'
=@{@4z@p@@@&ff@@
=q@ff@?@
???@	@@@%??ff?H?z@Fff@&ff@Q@9@C
@ @.R@(@33?R@
=@@
=q?@   ??˅?Ǯ?R??=q??(@\?
=????R?=q?H??33??
???z?Q??  ?
?
=?33?\)?H?\??Q?Q?
?\)?z?
?@G@E@]p@i@6ff@!@R@#33@@@@  @
@@
@@=q@@@@p@G@G@@{@@Q@R@#
@+@R?@?p?@
=q@
=@33@@33@R@@33?z?\?Ǯ?H???
=?@ ?ff@ff?ff??=q?p??Ǯ?(?ü#
?H?R?33?H?ff?H??
=?p?\)??ff???ff??G??\?zH?33?Q?\)?R?{?33?z?  ?z@
@{@.{@'@
=@R@:=q@(@@\@@ ?R??Q@z@
???ٙ@{@@\)@
=@33@??R?=q??
???ٙ?=q?
?{?\?=q??=q?33?޸R?\?H?Q?{??p?
=@\??ٙ?z@?  ?{??˅?p?
=?\)???}p?xQ?
?aG?k?Y?=q?xQ??Tz?O\)?\(?Tz?Tz?zH????xQ??R?
=?33@\@ @\@>{@5@*=q@G@{@(@
=q@(@\@\@@@$z@8Q@=p@6ff@#33@*H?33@{?ٙ?=q?
=?(??G?˅??R?R?33?(??
=?H?
?(?\)?\??  ???R?
=??ٙ?H??  ?У?Q?У?Ǯ??33?z??z?z?(?
?\?=q?=q?У?\)?H?G?\)?\?G?(?  ?G?У?=q??  ?33?{?
=?33??\@
@
H@
H@@#
@@@@
@@   @!G@ @*=q@-p@+@'@=p@8@L@AG@:=q@2\@>{@)?{?=q???p??Ǯ?R???p?  ?޸R?  ?
?
??˅??p?H@z@@Q???
=?У??z?
=?Q?Ǯ?z???  ?z?\??ٙ?{??ff?G??=q?s33?p?aG?zH?L?Tz?\(?^R?k?\)?}p?h???{@@%@Mp@1@@&ff@4z?@?R?@Q?˅?H@@?R@@	@R@@G@!@AG@R@"\@  @\)?p@@@?
=?(?  ??@
=q??{?
=?\)?{?
=@
=?@
?R?33?У?\)?@@@\@@ff@  @
H@@ff@   @
=?R??G?H?z?G?\?H??@
=q?\?z??R???\)@G@(?z?Ǯ?=q?33?
=?=q??ff@@^{@6ff@ @@z@+@	@
H@\@@z@?p@@%@@@@333@NR@!G@=p@i@2\@n{@1G@33@$z@(@@=q@ff@!G@R@+@   @@%@3
@7
=@5@,@@   @@%@#33@+@@@
=q@
H?H@@@?=q@\@@@@+@Q@?p?G?\)@(@   @H@   @!G@-p@(@@?33@   @G@
@
@(@\@@?R?p?
=@{@@33@@G@
p@R@@*=q@Q@e@Fff@/\)@6ff@]p@h@s
@S33@XQ@C33@S33@{@P  @y@aG@w
=@x@`  @  @@@  @@  @vff@p@j=q@|@qG@Q@  @@z=q@e@l@c
@u@h@\(@`@]p@~{@@h@@q@vff@w@s
@Z=q@}p@@~{@qG@@  @Q@@(@E@l@{@`  @ff@X@  @L@Y@,@$z@ff?z@@ ?
?{?G??@??ff?@   ?H?޸R?@!G@\@H@4z@1@[@w@@H@H@  @@@@(@(@  @p@QA:=qAMAG@(A
GA#33A
A
=AH@H@  @УA33@ADQ@
@G@
@ڏ\@A
GAz@A
=@\A@AzA(@R@  @
@QAS33@(@(@AH@@  @  @\)@33@  @^{@H@=q@@=q@|@  @  @k@\@y@33@@@X@vff@c33@q@h@u@hQ@Vff@@N{@I@}p@;@N{@@L@z@:=q@q@N{@@@{@@
=@33@\)@ָR@Dz@Q@qG@
@p@c33@Q@R@  A@ffA\)@W
=@}p@vff@w@xQ@@  @w
=@JH@A@@*H@@'
=@@1@5@`  @+@]p@x@~R@\@u@\(@(@dz@R@1@zA+@@@@@߮@{@QA;
=@@GA	@p@\)@GA@?\)@
@~{@E@@@
@!G@8@B\@/\)@'@/\)@
=@A@@ff?@@@ @"\@G@@@@	?{@@<(@33?@
p?(?(@	@	@R@@@)@7
=@AG@P@^R@p  @p@GArHA*{A@@i@33@GAff@  A0@  @ٙ@pANH@(@@  A	G@z=q@e@5@=p@fff@=q@G@Q@ff@@@H@w@\@|A,@z@
@=q@=qA  @(@@
@@qG@G@u@
=A\)@\)@
@z=q@e@@W@L@^{@nR@p@33@r\@aG@qG@zH@`  @zH@p  @-p@@  @+@(Q@$z@'@>R@g
=@Z=q@`  @AG@"\@
=@@ff@@@>R@JH@nR@i@\)@@H@p@z@ָR@pAff@@\)@@pA
A
ff@\)@@@@\)@E@@\@A@ff@@!@x@@~{@G@-p@C33@@J=q@p@\)@o\)@e@  @@{@ff@(@lAX@=q@a@R@5@~R@s33@j=q@hQ@P  @^{@ZH@|@Q@jH@ff@xQ@HQ@o\)@^{@   @ @NR@QG@/\)@,(@#33@,@AG@P@R@\)@
@xQ@\@L@!G@(@ ?H?ff?
=?p?Q?ff?z?@   @@@  ??H@,@S33@g@@R@p@G@Y@tz@L@S
@Q@8@B\@Q@p@/\)A@,@A@#
@@\@
p@
@R@*H@R?@
?У?\??
?
=?ff?(??33?\?@@G?˅?p?޸R?ff???˅?@0  @<(@p@H@
@@\)@(@@ff?=q???z@ @\)@   @
p@@\@'
=@{@?H@\?  @{@   @ff@'@
@
=?  ?=q?R?33?{?Q?p?Ǯ??R?Ǯ??Ǯ@ @@@
H@
H@@%@z@"\@!@	?@Q@(@z?
?  ?@@G@?Q??33??\??У?@G?
=@z@\)@?p@@Q?(?p@(@
p@{@(@\@Q@ @ ?
=?R@33?=q?\?
?33?G?\?
?R?(?{?{?\??(?33?=q@@R??
=??R?Q?z?\)?aG?{??H?p??????xQ?  ?=q?\)?s33??
=?ff?У?p@@G@ff@!G@$z@#
@:=q@:H@N{@=p@<@333@>R@U@QG@Z=q@j=q@Z=q@>R@:=q@<(@:H@333@L(@0@0  @@	@@G@@@ff@	@{@@G@=q@  @{@(@?R@?@??@33@Q@@333@3
@(@   @%@(@
=@\)@@Q??
=??(?Q?@\@\@
=?\?˅?33?\????ff???ff?p???G?33?33?{@
=?@%@6ff@L@@G@#33@`  @*H@{@fff@XQ@k@Vff@E@S33@X@U@_\)@p  @b\@~{@@z@y@  @Q@q@y@@\)@tz@w
=@w
=@u@l@`  @p@hQ@>R@!G@E@8Q@>{@H@&ff@
@
H@
=@?\)?p???
=??\)?ff@ff@\@@@{@@
@ff?H??\)??
=?(?
=?\??Q??R???
=?\??H@ff??\)?{?
?G?(?  ?Q?ff?p?Ǯ?  ???@
=q?{?G@z@{@H@L@JH@fff@(@;@|(@@tz@W@JH@`@o\)@c
@}p@G@\@@w
=@xQ@p@(@@33@JH@X@QG@S33@@s33??@Q@@'@@%@#33@<@7
=@NR@333@0  @#
@@Q@H@,@!G@@.{@
=@
=@@'
=@
?
=?У?ٙ@@@@@@33@@z@	?(??R@@@ff@
H@?33?=q?˅??\?ff?=q??
?ff??G?@@z@,@.R@Dz@c33@tz@p@@@@A%@\)A=qA  A5AHA!AW
=A
Ap@33@fff@@\)@QG@\)@Q@`@W@U@w@`@?\)@9@0@!@=q@(@ @R@Tz@JH@Mp@7@\)@!@G@@R@\?(??  ?
?Q????@
@
=@
H@G@(@@"\@   @@$z@1G@$z@?
@{?=q??p?33???p?=q??Q?
=?Q?Q?=q?ٙ@G?
=@@ff?33@\)@Dz@HQ@[@s
@
=@G@@@(@Q@ҏ\@GA,  AB\A\)AA AAJ=qA=q@p?=q?p???
=??p??z?H?G?p?H?G??  ?p???33?
=?У?\)??{@
=?
=?
??Q?
?\)?ٙ??Q?z?33?=q?z?ff?
=??  ?(???ff?=q???p?ff?H????Q??\)??
=??(?@@   @@R@	@*=q@=q@Q??R@@%@
p@
=@ @(Q@\@@(@@@G@
=??  ??\)?  ?33?
?˅?  ??z?Q?(?Ǯ?p??  ?H?\)?33?\)?\)?p?
??@z@ff?Q?Q?\?R?(@?{?@ff?@ ?R????
=?zH?^R?s33???H?{?xQ?xQ??Tz?\?^R?fff?
=?
?s33?G?(??H?(?Ǯ?\?p?
=?\)@   @Q@@
@#33@0@'@(Q@,(@8Q@<@333@@  @3
@0  @333@6ff@#33@(@@)@@	@R@
=@@(@@=q@(@
=q@z@@@@(@  @
=@@@ @Q@@33?R?
=??\)?33?У?p?(?
?Q?
=?(@\@@@0@
=@C33@[@=q@Dz@??  ?p@?p?H?˅?G?H@
?\??
?(?33?\)??=q??\?(?Ǯ?z?\?z@\?
=?@z@(@@"\@*=q@<(@4z@8Q@.{@N{@G@@@@@_\)@Y@Mp@>R@E@aG@y@i@]p@h@hQ@b\@S33@`@R\@R@ff@A@+@$z?
?R@@@G@p@=q@
@
=q??@
=@@
H@Q@\)@(@   ?@:H@w
=@nR@P@G@=p@'@2\@%@8@33@(@@%@\)@{@z@
@|@@Q?(?\)?ff??ff??ff?(?????R??  ?  ?R??H?
@  @H@@ff@'@.{@AG@.R@H@S33@J=q@W
=@Mp@p  @`@|(@r\@z=q@~{@xQ@  @\@zH@g@w@Q@33@@R@@hQ@@Q@@33@  @ABR@@xQ@@  @@@@33@@  @@@z@X@@\)@zH@W@K@B\@O\)@c
@P  @XQ@.R@>R@4z@%@%@)@;@(Q@/\)@:=q@AG@>R@#33@@  @@1@1@6ff@mp@H@+@@33??z?p?\)?ff?  ?G?@G@{@{@(@5@333@@@@  @dz@s
@(@{@  @H@@H@ʏ\@R@@R@G@@ff@R@\)@@33@tz@p  @a@e@l(@P  @`@(@@p@
A@`  @<@Tz@H@(@R@%@Dz@@+@AG@@@?Q?(@z@  ?p@   @ff?@8@G@AG@Y@S
@z=q@S
@\)@7@2\@@333@$z@ff@R@?R?˅?\?z?У?@(?  ?z?=q??
=?޸R?\?@ff@H@\@333@G@
=@<(@@@Z=q@8Q@@(@ff@{@@R@A
@p@R@
A33@RA3A  A@@@B){@33@p@\)@Q@  @@\)@@  @H@Q@=q@=q@@XQ@@|(@g@R@@ff@R@\@
@33@(@{A  @33@@  AQA*=q@
=@H@pA  @QA33@\)@z@H@@  @H@ff@p@  @9@?\)@AG@:=q@@	@@@G@?(@
=q@ @@(@%@5@(Q@Q@o\)@Q@@@s33@R@p@@G@=qAHA7A*\AQAzA)AUpAB=qAW
AA2{AG33B
AQpAv\AUGAH(A4z@ffAAAA	@{@\)@@(@ᙚ@z@33@\)A&RAuA$QA1@
A{@33@=qA AGApA4AX(AAHQA
{AAHA.ffA4AB=qA.ffA  @R@R@\A@߮AQA@@p@@A@R@@@  @@
@@Q@  @ڏ\@@Q@@Q@\)@(@˅@G@@޸R@Q@Ӆ@p@׮AH@RA+A.{A((AA&=qAl(AbRAyA
AlQA\AAGARAo
=AAwARAA33AGAAffA8zALA2=qAfffAA%AZ=qA*=qAd(A	GA>ff@\)@\@33@{@G@i@p@
=@@G@G@(@@^{@(A@H@{@@\)@z@
@ffA5@{@A=@33@@\@e@@G@(@
=@ָR@  @=q@@p@ff@z@z@
@@  @H@R@@R@@H@  @=qAz@ff@33@z@@\@H@Q@G@33A@HAHAo\)AOAB\A^{A  AqAXQBSRA  AdAAMpA\)Av\A@A]AqAGAA=pAx(Ak\)A|  A4QA)A%GAQA,A%AEG@A AAzA  @\@@УAA$(@@ff@ٙA	G@zA@@@@33@@H@=q@߮@@(@Å@
=@H@Q@  @p@
=@  @
=@=q@
@  @{@H@r\@qG@@3
@2\@@5@H@@@\)@@\)@z@p@Q@zH@@(@
=@@(@\@x@}p@  @ff@jH@=q@z@
=@ȣ@A@(@\@@H@У@p@{@@z@33@R@HA33@
=@  @p@@ff@p@H@
@H@l(@|@G@(@z@AG@{@  @Q@33@@\)@Q@(@@\)@R@Q@@zH@\@H@ff@@  @\)@U@s
@QG@&ff@'
=?@8Q@
@ @33@?
=?\)?33?R??Q?z?33??  ?=q?Q?\?\@
?H?
=@   @
=@3
@@u@@H@G@@=q@@RAffAG@RA5A=A9pAA$AATQAyAlzAlA`zA;A$QA"{A$@\A
AA%@@ff@z@@A\)@(@z@@߮Ap@{A@AffA&R@HA*H@R@:=q@]p@c33@@|(@
=@@@(@@\@j=q@`  @@j=q@fff@\@JH@S
@s33@n{@`  @_\)@L@S33@S
@(Q@Dz@XQ@]p@_\)@@.R@!@7@"\@/\)@(@=q@
p@   @3
@1G@5@Fff@S33@mp@@\)@  @33@(@^RA   AffA'33A'\)A,AA\)A A@ffA!AA'ABHA/33A0  A$AV=qARA\)A\AAA33A33AAzA
A(A
\A
=AA
{A(AA(@
@
=@ff@Q@@@@׮@\)@@@p@=q@=q@@z@Q@\)@\@Q@@@p@w
=@aG@p@p@\@\)@s
@XQ@<(@\@S33@P@vff@\)@@{@{@@s
@33@n{@X@G@z@@y@c
@b\@l@p@@{@@@=q@@@p@@Aff@A A@\A%GA(A6RA<zA6{A1Ao33AUpAYAV\AffA7@@\)@  @@
@
=@@@
@ff@@G@
@=q@Q@=q@
@У@\)@H@@nR@h@^R@(@33A.=q@@H@@\)@ڏ\A@@ff@g
=@@z@p@ @C
@JH@Y@z=q@Vff@W
=@)@>{@[@{@*H@@0@
=@@@A A@=q@GAA\@A-A<  @@@k@_\)@{@z=q@33@@\@@p@=q@33@h@u@B\@fff@j=q@
=@@@\)AA=q@A (@R@A@
=@R@`  @@{@@Vff@]p@;@U@<@R@@2\@I@?\)@NR@%@.R@0  @%@=p@!@,@4z@'
=@
=q@\@!G@=p@N{@Mp@Mp@H@I@7
=@<@5@HQ@%@
=@@@@	@\@
p???z??\??ff?ff?
=?\)?p@@ff?
=@%@   @
=q@@@
=q@@@@@
H@{@!@%@:=q@hQ@)@e@o\)@x@l@z=q@z=q@{@p@G@nR@p@^R@s
@  A\)@@z@\@@
@  @Å@(@qG@u@
A
\@
@s
@W
=@ZH@w
=@k@R\@Q@P  @XQ@\(@\(@I@XQ@Tz@G
=@P  @;@K@8Q@(Q@\)@@@a@:H@.R@:H@>{@Dz@ZH@Vff@A@C33@Q@X@fff@:=q@O\)@R\@@R@
?H@@
=@z@@
=@U?33?G?@3
@?\)@;@`@w@g
=@S
@H@^R@O\)@u@Mp@p@c33@G@@\@R@o\)@QA\@@G@ٙA	G@
=@G@
AAATA,AHAB
GA/
=A5pAF=q@{@@33A\@@
@H@\)@z@A33@_\)@ȣ@@R@8@@Q@@n{@(@@@mpAX  @p@@@p@@|@dz@{@7@@@@@c
@\(@W
=@H@O\)@,(@
=@ff@	?p@?@Q@@ff@
@$z@@@
p@#33@@'
=@
=@k@\)@
@@@@@Q@H@z@G@@  @
=@@Q@33@z@\)@Q@A`AIAARRA8zA@AGA7AFRAO\)AQAA
A#
=A\A\)@33A@(@H@(@ff@Q@@p@g
=Az@]pA@G@ffA
=AC@\)@A0z@@p@p@{@˅@@x@Fff@@Q@@jH@=q@g
=@p  @@(@]p@`@s
@  @z@@  @
@
=@R@\@
=@@
@@33@i@H?{@@<@{@p@@@I@@Q@ffAz@@H@(A	A$  A\)AAffAHA\Az@\A@AF\AJRA;
A1A=qA
\@A=A+AV{A;AH(AH@@HA{@\A\@\@QA@A
@(@A%AA;33@@@{@H@qG@\)@p@\@R@A+@GAA-AR@(AA'33@QA/@  @G@\)@G@@ff@r\@G@  @G@(@@@R@33@U@@33@  @G@C
@@33@p@O\)@{@  @@G@@\@@@\@33@
=@@@@ƸR@H@@  A  @QA@ffA=q@{A(A
=A (A
ARAJHAfffAA  A6\@
=ARA@AH@޸RAff@@(@߮@
=@@\)@]p@=q@zH@@@
=@\)@33@p@ff@@A
HA*=q@GAQ@
=@ZH@\A Q@|(@Ǯ@Fff@\)@ٙ@~{@xQ@У@XQ@\@\@Q@&ff@(A(@HA@@ff@@Q@~R@(@{@ff@/\)@  @
=@u@{@H@(A	A.ffA6=qA{A
A @=q@@@(@(A
=A
=AzAS
@Y@~{@@r\@?\)@g
=@tz@@{@G@z=q@r\@ZH@Z=q@C33@jH@s
@u@
@33@A@P  @&ff@L(@AG@0@4z@QG@c
@l@ZH@p  @G@.R@?\)@|(@P  @&ff@aG@@  @#33@@w
=@@P  @
@c
@<@R@
@B\@@R@ff@q@qG@Q@`@@  @O\)@K@p@O\)@@~{A  @@g
=@ff@ff@#
@R?{?z@ff@@@W@@mp@P@*H@
=?
?\?H??H?\)?H@	?@(@jH@z@(@@|@\)@ٙ@ٙ@ᙚ@A@QA@Q@33@zA{@\@PA<zA6ff@@@@@A@A33@\@  @@w
=@\)@{@
@z@?\)@,@[@\(@fff@Q@`@Y@HQ@A@  @!@1@x@0@L(@=p@r\@@g
=@@ff@@G@@أ@ff@(@S33@dz@ZH@/\)@1G@P  @,@,(@@7@7
=@4z@7@NR@N{@5@!@@(@
=@p@@{@E@=q@
@\ARA@|(@ٙA@@Q@AAA=qA'\)AARA	AffA
=qA6=qAA33@{@]p@@@\@p@@
p@\?{??{@ @%@@!@p@hQ@K@Fff@!G@7
=@7
=@,@\)@@333@@^R@  @>R@`@J=q@ff@h@%@ff@U@H@R@U@o\)@J=q@tz@;@jH@=q@j=q@%@R@G?@
=@@(Q@=G@r\@33@=q@   @:H@L(@Mp@_\)@tz@l@:H@333@1G@O\)@dz@`  @  @ff@H@zA@  AAPA,(A(A;
AEpA  AAAaA1A=qAAAA
=A AA>ff@A^\AJRAA$QAA\@A33@@  @=q@
@@@(@AG@@@@\)@33AH@A@z@@  @@33@pA zA
=A(@ָR@p@@(@ff@\)@-p@H@mp@H@Tz@9@%@,(AЏ\??Ǯ?  ?Ǯ?
?H?H@?\)@G@P@c33@  @x@n{@s
@|@fff@
@
@z@\)@@33@
@θR@33@A&=qAIpARAx  A:HAAffAO33ApQA{33AtQA^=qAffA{AAAAHzA2\B
pAAV\A
@H@@(@(@HAAffAjffA
A,(A.\A$AyA@@p@=q@nR@(@p  @ff@ȣ@AAH@(A/
@@أ@
=@@@{@r\@  @H@Q@A#
@z@@j=q@@
=@G@@Q@L(@@A
@R@@zH@ʏ\A   A  A33A+An{ASA'\)AZRAo
A.HAAHA4A=q@Aff@A1A=ATA;\)A(AHAoAHA
AAB=qAGA=qApA
=A
AAApAQA  AGAAA  B=qAAׅARAAAAA33A  AAAiAA~RAtAL  AZHAAR\A
=ApAffAQGA]GAiAffAl(AEAk33A*HA&HA;A;
=AB{@  A^HA+\)AeAA0  A=AIA{A!p@33@A=q@AAQA=q@@{A  @@@
=@pAAAffA  @
=AG@@@@pA!@G@A
=@\@A-pAAb\AlA^RAffAQAQAGAGA\)ARA]A\)A(ArffAhzAvHAxAMpA\Ap@A  AN{A   @@@A\)@{@  A
{AQGA^{@QA8@{AAz@G@ڏ\Ag
=AA
AAA*\AO\)AVH@z@\@@S
@vff@WA)A=qAx  @\)@(@{@{@ffA33@@@
@x@^R@H@}p@  @Q@G@NR@nR@nR@A=q@z@@ۅAff@
@GA%GAE@Ϯ@@A.RA*=q@A>HAA zA33AffAAA
=AZ=qA{33AA
=AA@RAQA=qAj=qANHAbHAypA0AS\)ALzA,A
=AA%pA(A@ffAAA
A.\A,zAAA
A"HA1pAA&ffA33A+\)A,(A[AAS
ACA;\)A<zAhA9AO@\)A-GAffA<zA  A%A
ffA(ARAAX  AUAG\)AWA/\)AFRA"\A0AG
=A@  @@Q@@z@@A{A\)@A\)@
=A"RAAHQA33AeAmA	A8QA&HA:ffAA=qA{AAQAGARAAA(AAzA\AAHA
AƸRAA  AHAAAARA(A{AQA{
A:{A{A
pA
RA,(@(A=A!p@@@\@(A  @Ӆ@\@@Ǯ@=q@33@@ff@xQ@AA9GA:RA
AHA(ApAP(A(AQAbRAW33A]ALQA`  A6\ALA@G@z@~R@8@@  @j=q@K@G
=@@Q@@p@R@
@=q@z@Q@  @\)@@33@@@陚A8A*\A33AH@AQA.{A!A!AH@33@@A.\@A @AA0A(QAV{A!GA2HA'
A<QA QAj=qADAr\A@AGApAHzAaAGAIAA@A#\)ABHA~RA~HA=qA?\)A
A@A!@@A@G@˅A=q@љ@ƸR@ƸR@@
=@R@g@33A
@ٙ@{AIAHAQA=qA"=qAff@{AR@33A	A@HA@Q@  @33@RA@@@H@(@\@@ə@ff@@=q@Q@@h@(@@@׮AGA:ffA733A-AaGA`QARAhAN\AHA!A
=A8A	A4Q@QA0(@ff@@\)@G@@H@G@  @@~{@@Q@@C
@@~R@1@I@C33@<(@1@(Q@Q@\@/\)@
H@ff@b\@@@@G@@G@=q@p@U@j=q@
=@G@@@l@Vff@L@H@@33@(@(@z@\)@
@Q@ff@
=@o\)@@x@@  @=q@A33A-A QAA3@=qApA7A.R@ٙ@@G@@
@G
=A(z@=q@HA@dz@AvR@@nR@E@  @(@Q@(A@@@@=q@@i@JH@XQ@`  @U@c
@  @b\@]p@w
=@C
@r\@@jH@{@hQ@R\@Y@@Fff@Y@z@ڏ\@@]pAA{AA{33@AG
=A@\A-p@@(@A"HApAB=qA4A=qAQ@R@ZH@
=?{?{?\)@33@  @33@a@@~{@\)@)@z@!@.R@@7@7
=@(Q@"\@@@I@S33@ @33@Q@?@!@?33?R?
?޸R@(@"\@@H@H@
@?(@@@ff@
=?33@
?33?
=??p?У?У@ ??G?=q?
?޸R?R?G?\)?H?{?(?
??
@(@Q?z@@
?޸R?
=?˅@@?z?R@33@R@33??\?\?޸R?  ?{?\)?ff?H?ff??  ??33????Q???
=?
=?33?Q@%?@@Q@,@5@9@-p@QG@S
@/\)?  ?Q?s33?s33?aG@z?@'
=?@j=q@~R@@p@  @R@=q@ff@@\@l@ffA,@  @tz@
=@Q@s
@a@)@^{@@@@@@i@z@\@S
@G@?=q@@@@E@1G???=q?  ?=q@@33@@+@g@^{@@x@{@i@i@G@@h@R\@-p@%@%@7
=@33@@@!G@2\@'
=@Q@)@*=q@#
@{@!@@!@0  @9?z@:=q@ @%@I@{@j=q@W@p@  @@[@K@Fff@*H@@]p@\)@pA@H@
=A
\@Aff@ffAGA?\)@z@{@=q@@fff@e@l(@ZH@(@Mp@\@33@U@}p@w@xQ@S
@Fff@g
=@z=q@?\)@2\@^R@W@^R@tz@p@W
=@Mp@Tz@0  @C
@=p@\)@,@\)@@@#
@+@+@s33@e@n{@ZH@p@mp@^{@mp@@HQ@u@q@|(@H@  @  @fff@5@!@e@HQ@@@`@4z@@G?(@:H@o\)@]p@k@qG@i@mp@&ff@1@1G@%@c33@x@(Q@@
@
=A5G@
@pA  A$zA\(AA1G@УAEGA=qAzAYA4A(AhQAlA]Ap@zA	A#\)@QA
=qA&=q@ff@A@ffA@z@@\@{@@(@33@Q@z@@@@Q@
=@}p@G@  @A)A-GA%p@A;\)A((A=AzA#
@
=A&=q@{@ffA  A@  A\)@33A
ffAqA'@p@~{@1@R@h@k@@@(@@33@G@@z@@  Ap@A (@@ҏ\@A(AAAAmAffA\)AA=qA33A
=A\)A=qA{ApAAxQAA\)AAzAQ@A4Q@ff@Ae@GA2ff@θR@\@z@]p@p@@=qA (@@  @A/@@
@tz@
@z@~R@\)Az@uA9A$Ak
=AG@\@A?\)A;
A8  AHAK
AtA"\AQA8A   A
ff@陚A@R@ҏ\@@[@=p@
@(@z@
@Vff@)@K@(@@RAA@Ϯ@p@߮A	GAA  A/
=A\@ARAAAAA-As33A#33AAApAjHA*=qA
=AO\)A1AN{@@
=A)AfffAUAA+@(ApA
ABRAzA@zAJ=q@(@R@(@Q@(@R@@A@33A$(A QA!G@=qAAd  @GA=qA2=qAA3
AAA=AC
As
AA=qA
=@
=@
@@QA  @~RA'@A zA@z@θR@zH@Q@7
=@33?H?Q@p?Q@,(@@A@(@0@4z@3
@  @\)@ff@@33@@G@ff@G@
@=q@\A=q@p@
@@HA
pA(AR=qA_AdQA,QAxADAA\A6=qA]A\AffAuGAmA:HAEAc
=Ao\)AA_\)AFHAJ=qA8AO
ABHAW33A%A0AZHAH  AL(A(A zA$(A\)ARAo
=ARAS
AAAAC\)A2HA7AEAA  AA=q@zA7\)A<QA^\A=GAAGAA
=AA<A\AEA1A(z@{A/A\)A&\AH@ff@=q@(@{@ʏ\@=q@@=q@@
@@@z@p@@ff@\)@H@pARA
A#A:{AA=Ag\)ApAf\AAf=qAfHAZffAAaA\AK\)A*{A|zAHA,  A=A(zA3
A  A)A33A+
=A(AhA<QAr=qA^HA_AmpAFffAA=A\)A
=A4@H@@  @{@G@QA A@(A{A@
=A(AARA
\@G@=q@33@{@
=AHA=qAnRAzRA A
=ARA%pA'\)@A$@@@@H@@@@(@  @z@У@p@(@@R@
=@\@@R@(@߮@@\@@A@AHAAzA(  AQAA'
=AA.{AffA#\)A=qA(@zAzAG@\@H@Q@G@@@\@=q@33@H@@@H@@
@@|@qG@e@>R@Y@c33@33@p@R@@\@  @@@Q@A\A9A!AG
=A\)A z@@@(@}p@
@tz@H@_\)@@QG@#
@   @HQ@L(@+@c33@*=q@>R@@]p@
=@u@8@1@$z@7@C33@L(@0@,@-p@NR@
=@H@G@  @z@߮@A
@=q@AHAlA$  AAPzAmAipA  AAAH(A7A+AGAA;A3@33@\)@ffAA@{A)A
=@R@
@\@@R@\@
@o\)@s33@R@y@dz@jH@W
=@L@^R@JH@>{@Fff@g
=@p@a@j=q@g@tz@33@=q@  A  @ff@ff@zA=A+
=AuA|  A
@ff@@{@@@=q@G@@\@z@z@@33@
=@  @@\)@@@@w
=@xQ@b\@p@@Q@H@\)@@@ff@@@@H@=qApAQAAAA{\)AjRAA\(A7A
A`A3AN{AUGAlA?A  A_\)A33AA!pA
=AQA$zA  @A6H@  AG@{@H@e@@X@@\)@`  @K@@@@
=@\@əA(A#
@A'\)A)AHA.=qAAP  AH(AK
AK
A4AGA  @@H@
@ָR@A Q@`  @@L(@z@{@\@ff@z@@p@@Q@@p@{@@33@{@s33@
@@(@p@A1A{A\A
=A
=A&RAgARAAmAj=qA4(A-@/\)A}AlQApAA}A33@p@{@\ANH@
@=q@h@@=q@@Q@z=q@a@^{@U@J=q@K@QG@ZH@333@n{@G
=@<(@E@X@hQ@S33@u@@RA@ٙ@R@?@\@  A
@XQ@l@Q@S
@|@S
@@R@@@{@h@=q@y@z@/\)@r\@@^{@6ff@=q@x@@XQ@@ @vff@5@@
@ᙚ@\)@  @ʏ\@B\@\)@W@R@G@  @@@@\@R@Q@hQ@_\)@ @8Q@
@߮@\)@33@?ff@@p@R@=q@
=@{@P  @(@&ff@E@R?G@ @Vff@33@G???@
=?p?R?=q?
=?(???G?@!G@ff@G@33?z?\?\)?
?H???R?
???p?@33?z@?ff@%@%@5@7
=@Q@2\@7@Q@
@J=q@@H@G@Q@=q@ff@@H@(@ffA@ff@p@
=@@Ǯ@
=@pA  A"ffA Q@@H@@@\)@G@`  @\@i@33@=q@@zH@@Q@@@G@@@G@z@Q@33A@z@H@  @33@ff@R@A\@
=@33@@{@@@p@@\)@
=@p@@@@@Q@ff@  @ff@hQ@k@@jH@l@Vff@Z=q@S
@qG@^R@@l@p@   @_\)@\@R@G@=q@z@@H@{@@
@p@@@@\)@g
=@|@U@8Q@>{@G@>R@H@\)@:=q@ff@K@U@w@{@u@C
@Vff@
@@hQ@@u@Q@z@(@@@ff@(A?
=A1AA@QAA"RAAA#33Abff@@{@@\)@@Ap@أ@{@\)@  @  @=q@@@@p@
@{@?(@@Q@5@7@-p@C33@c33@  @c33@O\)@z@R@ff@\)@qG@L(@L@X@xQ@N{@C
@^{@H@P@??  @Q?H@R\@G?@&ff@"\?(@@z@=q@'
=@Mp@X@Fff@&ff@;@G@QG@6ff@G@s
@\(@G
=@U@g@c
@L(@`  @P  @_\)@h@{@@\)@n{@u@l@z@@@  @33@|@\@\)@\)@˅@{@@\@Q@p@p  @
@33@|(@x@z@Y@O\)@3
??=q@@'@B\@?\)@nR@q@H@b\@i@c33@z=q@  @z=q@@
=@ff@\)@@=q@33@
=@@\@@{@ff@@R@@H?J=q?Y??(?
=?(?G@'@@@{@(?z?\)?\?R?G???{?(@R@$z@.{@&ff@Vff@(@w@}p@XQ@  @33@@@ff@ff@33@p@@H@(@أ@zA@@z@@z@7@-p@#
?G@<(@
p@z@G??޸R?У??G??33?\)?=q?
??@
=@ff@
p@:=q@JH@0  @5@l@
@@G@
=@33@(@
@أ@@H@@=q@p@A@ə@Q@ff@\@s
@xQ@X@5@?޸R???  ?@
?
=@'@,(@0?H@@
@z?H@@33@G@'
=@(@'@.{@5@I@K@e@vff@tz@@@=q@=q@p@{@  @(@R@33@
=@@R@@@@@@H@@^R@H@N{@#33@??@   ??  ?33??H???Q?z?
@ ?޸R?Q?@@G?=q@@@
=@(Q@>{@Fff@jH@p  @   @?@@ff@?@?\)?ٙ@z@
H?(?@G@{?\?  ?=q?R@33@ @@(@R?p@@?@z@@*H@?\)@H@Mp@h@R@@\@?\??=q?˅??@   ??޸R????R?z??(??p?@)@"\?(@ @4z?޸R?{??\)?R?˅?33??
?G??p?(?@
=q?ff@p???\)?@33@ @@R@
H@@*=q@@+@/\)@+@3
@@Dz@G
=@>{@XA6ff@H@R@@
@ڏ\@@  @33@33@@@|@\@@33@@!G@:H?@p?@ ?޸R??H?
=?@ff?\)@,(@/\)?@I@@@@Tz@C33@JH@b\@L@tz@l(@n{@=q@a@@@@#
@33@:=q@
=q@??@ @&ff?@??=q?z?
=?ff?ٙ?У?{@
H@G@@@=p@5@@?=q@5@'@
=q@R@  @#
?  @\)@=p@>{@1G@dz@u@ff@@tz@H@z@H@G@@33@@z@y@@
@H@G@@ffAQp@ffAAr=qAHA5A2\AAQA(@A
=q@\)@AGAAzAA{A+33AA@:=q@,(@1G@>{@33@@Mp@C33@U@=q@=q@4z@4z@*H@  @@@ffA\)@\@@R@K@@(@QG@I@C33@
=q@*H@Vff@W
=@4z@Az@׮ARALQA\z@=qA @pA=A@QAAG?@ ???p?}p?s33?@!@p@{@
=@#
@L(@=p@C33@\(@U@=p@3
@Dz@X@2\@X@`@xQ@vff@33@@{@z@Q@Q@  @@@
=A33@{A4(A;A$AFHA\)A?AHAA-AAQA  @
@@@G@_\)@l(AH@(@XQ@*=q@W
=@@  @333@6ff@7
=@(@N{@B\@-p@X@>R@B\@3
?H?\@@-p@z@{@W@?\)@
=@33@@H@@@
Ap@zA
AFffA)A"HA-pAP  Amp?@C33??{?G@	@{@c33@8Q@@\@@ƸR@ff@ffA A
=qAA zA2RA9AOAffA zA[33AA;
A
A;
=ARA@ATQAD(ABHA\QA\)A$AN=qA  AAzAffAh(A;AQAH@Q@33@@jHAA@@X@x?R@
p@@   @
=@p@R@Q@{@H@G@p@?\(?G?u?\@l@@
=@s33@{@H@
@A;
AHAl  ANffAfffA  AK33AA33At(AAeAASA=qAAA|A33A\)A\QA\)ADAA'
A|QANff@@zAH@ff@R@
=@p@R\@`@z@K@H@9@3
@8Q@=p@>{@1@(@4z@L@33@
=@@p@@
=@\@R@|@@^{@X@H@NR@5@/\)@Z=q@{@S
@  @@(@P@hQ@_\)@%?˅?z?=q?n{??0?c
?333?z?!G?k?G?fff?Y?h?^R@\)??  ?(?p?  ??\)?H??H@33@
p@QG@5@n{@
p@ZH@1@@!G@@H@#
@(@K@:H@B\@<(@;@(Q@,(@@@Q@ @(@
?(@G@
=q?H@33@   @
=@#33@=q??@@?p@@?
=?R?@?\?=q?(?\?
?޸R?Q?ff?\)?{??
=?
?
??
?z?
?\?Q?  ?{?H???\?@  ?s33?p?G?@ ?z??  ?=q??(?  ?  ?=q?@C
@4z@   @3
@QG@+@5@AG@\(@X@Q@@H@=q@(@z@  @p@\@R@H@@w@{@R@@@S
@qG@@g@j=q@s33@h@S
@L(@E@JH@R\@hQ@^{@A@H@I@}p@R@@w@z@333@G@u@s33@@JH@@  @dz@L(@g
=@4z@G@[@!G@%@5@N{@R@/\)@,(@%@
=@*=q@ @?\)@'@-p@%@*=q@Mp@@  @B\@   @4z@P  @[@Z=q@=p@I@l@P@\)@@@ff@@AA
A  A%pA0A<QA3
=AAmA^\AA7
=AN=qAAA_A&=qAqAs33AFffA^=qAapA  A+\)AzApANRA5AdA@AA Ah  A\)@
@QA@AhA@QA=qA{@33A.RA*=qA)pA  A
A@
=A|A0zA4z@
@Q@{@@\)@Q@
@  @@ٙ@(@@=q@@Az@(@@@@R@\)@@  @@@@{@(@H@|(@H@A@AQA{ALzANRA%pAtA_A0QAzAG
Ah(AHAAAAzAAiAzA{AQA33A(A7
=AAA33AdAPAPzA
=@{A^HAff@AAff@AQ@@ᙚ@  @@
=@z@@\@əAz@ffA @@33AzAUGAffA8(A>\AXA[33Ac33ARAQ@ᙚ@
A33@GA@
=@@H@@=q@vff@@w
=@@@,@$z@
=@AG@@xQ@C33A%pA  AzA7
=@33@zA @QAffA\A{AzA*RA9A7\)A`A
A'
=ATA9A(AA=qA&HAA
A`  @zA@A@{@ZH@Q@p@
=@jH@{@N{@\@9A{\)@ff@AA)pA^R@zA&ff@U@R@(@|@}p@s
@@`@@@@A?
=@A@ə@qA&R@Dz@fff@C33@3
@Q@HQA(@Z=q@.R@W@@  @G@^R@q@@p@@H@\)@Ǯ@Q@AA@@mp@Q@g
=@R@@Q@
=q@`@JH@k@'@uA
{@@@=p@JH@:H@e@G@Fff@|@\@p@H@z@@ff@@@=qAP@zAv=q@\)@@AH@
@
A5@\@z@33@A0QAGA @Å@  @r\@@ff@  @j=q@_\)@HQ@jH@QG@Vff@P  @@&ff@(Q@>{@s33@l(@@p  @&ff@dz@HQ@q@@ff@@x@{@@}p@w@y@b\@fff@N{@Dz@%@%@G@{@3
@ @S33@Fff@S
@P  @W
=@,@!@z@=q?
=?@??H??  ?(@.{@(Q@333@:=q@G@U@i@]p@k@~{@(@  AH@(@{@Y@@@jH@R@@H@ǮA{@@p@xQ@\)@@{@z@@@@p@33@@@p@@@@G@@@@R@@(@A\Q@@  @H@(@_\)@@G@@  @xQ@a@QG@K@R\@c
@o\)@Z=q@\)@@W
=@@@fff@\(@hQ@X@U@{@Tz@w
=@HQ@+@%@'
=@ff@@@@  @z?\)??H@
=q@H@@2\@Mp@x@33@
@a@p@R@|@H@R@QA AN{A
=A3A>\@H@
A A<  AGA9AFffAQAQAJ=q@pA'ALAHA-@p  @A zA @Q@@
=@z@@A  @@@Q@AffAff@QA\)@θRA=qA
pA2R@AA$Q@H@pA@J=q@@{@s
@QG@[@Dz@C
@5@(@Mp@)@@ff@@=q@  @
=@@@@
=@\@@
@'
=@\@ @3
@R@%@
=@@Q@(@.R@@@g@ZH@G@@@=qA
H@
=@A%A)GAEGA@(A\A=qAc@33A	pA0  AIAh  @33A(A@zHA @p@<(@@˅@@@@H@  A  A@\)A
\@@A!ApAA[AA+AA=qA7
=A@@ff@@
=@\@i@p@Tz@@@33@  @C33@\)@@5@(@<(@L(@Dz@HQ@W@#
@\)@@@@?\)@.R@HQ@-p@ZH@XQ@J=q@9@\)@@@&ff@+@R@\)@  ?@@   @2\@  @4z@tz@mp@  @(@p@GA2=qA
AHzA1G@p@(AAff@ۅA333Aff@ApA#
=AU@\)@H@
@(@Q@@i?H@HAYG@X@@W@(@R@zH@=q@Q@aG@_\)@Q@U@e@Q@   @*H@*H@  @'@=q@{@?
=??H@@  @G?G?H?H?\???ff?z@
???@
H?޸R@#33@$z@@0@i@h@  @_\)@ZH@C
@p  @W@A@@@.{@   @'
=@$z@L(@]p@j=q@c
@R@ff@(@Q@ff@@@A(@޸RA	G@
ARR@AaA?33@  A33@A
=A?
@AAHA@A@@=q@QAA@\@@=q@=q@@w@  @\@|(@e@X@P  @'@>R@a@4z@AG@aG@aG@-p??(?H@Q@6ff@ff@G@Q@{@=q@H@@U@l(@g@l(@O\)@@@S33@33@@@
@r\@X@S
@i@Q@Q@}p@QG@\@Z=q@tz@@\@@Z=q@z@\)@fff@z@  @^{@j=q@w
=@X@Q@i@~{@z@"\@p@Adz@\AR@ffAffA?33@˅A@ApAAp  A@ҏ\AzA
=AA<A<@
=@@
@{@
@@
=@U@(@33@  @
@p@{@  @=q@G@ff@@\)@|@AG@o\)@(@u@@z@Q@H@z@H@e@J=q@#33@a@aG@[@H@33@  @L@Vff@A@Q@N{@S33@;@QG@XQ@l(@S33@\(@H@@N{@U@|@mp@e@@e@Vff@}p@w
=@@jH@ҏ\@R@ff@߮A)@(AipA
\@A:=qAeADAB(AyAHA{AApA
@AeAMAxAA
@@(AQ@{@h@θR@{@@陚@Q@p@pAAEA/
=@ÅAAA33@(@ff@@`@@أA"=q@@y@HA<(Ab=qA0(@z@G@@@@a@H@ȣ@@@
=@C
@.R@ZH@H@ff@w
=@ff@  @  @p@@JH@6ff@@>{@@\@z@ffA)A$zA1@A1A*ffAcA?A.=qAiGADQA\)AffAAAAGAzA33A  A(AGB#GA  A33A=qBQAGA  Al(A0AQAEAff@=q@
@@@Fff@
@:H@xQ@>{@
=@9@*=q@,@'
=@g
=@nR@vff@s
@,AK\)@A&=qARAgA
HA
A33AA4@\)@33A@@zA	@+@=q@@zA6\@@p@A
R@
@
AA)@ʏ\@@nR@33@H@P  @C
@K@@G@@33@=q@33A=qAGAGA@zA(zA_33Ag
=A\)AnRAo
AR{Ad  AK33AAA33AAdzAA%pA
AAGAAAd  AAzAhArRA\A  AW
=A  AAA9AAxAAGAA\)AUA  A=qA(ARAAA(AQA  AEAMAAF\@p@@33@
@@@@(@(@
=@H@:H@6ff@^{@G@A6\A$A	GANHA%GAC
=AQA!GA33AB\A?A6{A)A(A,@@  A=q@
=A'33A?
A
A @ƸR@@@{@=q@~{@zA2R@zAQAR@@=qAO@@θRAJffAN{A\A^\A%GARAjffAJffA\)A<(A2ffA{Ap@z@=q@@\)AA
=A\)A33AA'33@AQA8A@{@
=AA'\)@@@љ@
@=q@?p@=q@33@Ӆ@@H@@33@{@G@\@@@ff@\@@@i@jH@@tz@C33@p@h@H@QG@C
@	@S
@???{??˅?ff?z?
=@@,@E@6ff@aG@H@=q@h@@@@33@4z@\)@@ff@ָR@\@@ff@p@
@p@  @p@\)@@
=@
@A/@  @ÅA6RAhQAXAbffA-AA
AvffAA+
@R@R@{A
R@p@@{@@ᙚ@w
=@b\@9@JH@5@.{@S
@=p@~{@,@?\)@R@L@%@q@{@@A	G@@\@H@@ff@R@@@R@@@33@`  @7@G@c33@@Y@L@@a@@aG@@nR@@H@ff@@@@p@@
=@@@ffA3
=AuG@A.{AaAA<zAMA3AjHAhAvRA6{AffAVHAN=qAAffA(A
=A  AAA>HAeGAxA~RAiAAGATAqALA=qAyA8QAS\)A   A5A33A'An=qA\)@{@GA{A\A>{ASA=GARHA<ARA	G@  @z@@AG@əA:=qAff@  @=q@A  A8z@(A
{A @  A
=@@
@
@{@=q@33@@R@@=q@s
@dz@@=q@  @=q@@Q@R@@\)AD@ۅ@\@RA@(AGAAQAffAAd(A\)AxQAA;
ApzAG
A=qASAZ\A9A_33@\)A(QAzAQ@ϮA*RA@ᙚAffA
A!A{A
\A!pADz@
=A$(ApA{A*HA\)@GA(Ap@@Q@j=q@@
@A33@  AffA\)@=q@\)Aff@
=@=q@33A1A$@zA(@zA"=q@@@{@
@{@  @{@@ff@\@G
=@@u@L@\)@N{@x@Q@@=q@G@
=@G@
@(AffA
GAA$(A)AA;
AYpA  A\  AW
=A33A\)AAaApApQAA=qAAEAffA{AAUGAZ\A  AapAR@  A5G@@A.ff@  @2\@333@@p@@@@r\@@׮@@\)@U@L(@\@A@@@QG@!G@@@{A@  ADA=A4zAPA0  AjHARAAAGAUAH@陚@~{@R@(@o\)@Vff@l@7@NR@J=q@  @O\)@:H@(@z@޸RA@@
@pA\)@{A@A.{@
A QAA\ARff@=qA;\)A=q@ff@H@ᙚ@p@ff@G@@z@@H@p@}p@3
Ap?@P  @E@333@ZH@\)@hQ@b\@z@@mp@\)@@@o\)@Dz@g@33@R@=q@\@@\)@Q@p@@
=A"=qA.\A=AGA5AH  AJHA
A%AGAR@RA#@z@H@zA\A/@@33@\@@@(?R?(?R?޸R?@??(@ff?z@@Z=q@i@أ@(@p@@n{@/\)@p@,(@6ff@Fff@W
=@W
=@@@(?  @(@P?@7
=@E@7@g
=@zH@L@@l@xQ@{@ff@@H@  @
@G@R@{@AAff@ffAH@@H@AA	A
HA
HA%GAA:RAIAXQAdA*\A\)Ab=qA"RA{@AA
\@@ff@@  @P  @l@U@\)@W
=@p  @\@Mp@U@\)@ff@@ff@;@p@=q@K@[@g
=@E@QG@B\@.R@
=@
H@@#
@.R@U@@=q@\)@AGA@ff@@p@33@  @ff@{@Q@ᙚAff@A@@p@p@@{AA\)A
ffAG@(@(@{@RAAQ@@z@
@
=q@=q@?
=??\)?
=?
@
p@@A@X@ZH@[@`  @R\@[@u@\)@
=@@~{@p@{@33@G@(@R@@\@=q@G@
@@A	@=qA
=@H@\)@\)@{@(A
AIGAQA(  AAA;A\A	p@
@@  @p@Q@O\)@@
@\@]p@
H?@"\?R@@5@G@#
@L(@C
@@c
@H@I@u@|(@H@\)@@@@@~R@}p@hQ@c
@@R@  @H@أ@A\)A\AGA4QAC
ADAS
=AQA^=qAZRAk33A-pA
\A-A`QAw\)AA@pA @ff@33@@z@Q@  @\)@@'
=@*=q@
p@?R@	?@?(@HQ@33@\@$z@\(@x@{@x@r\@b\@l(@i@e@xQ@g
=@
=@@33@ƸR@
=@A
{AGA!A_ArRAAt(A=qAAzAffAAA=qA  AAj{A=AD@|@=q@*=q@
=?
?{@	@aG?z?p?@@(@@?\)?u??h?333?
?G?n{?W
=?\(?h?.{?Q?Q?h?@  ?Tz?E?G?Tz?G?B\?O\)?J=q?\(?k?n{?h?n{?Y?xQ?zH?zH?}p?  ?G?}p?G?\??\?\????????z??33?Q?H?33???33?p?\?Q?G?h?p?Q?^R?  ?h?zH?aG??(?h?z??\?xQ?\?ff?ff??u?xQ?Q?{?k?}p??c
?ff?xQ?  ?aG?n{?\?xQ?p?ff?G?}p?  ?ff?G??\??=q???=q?ff???G??u???}p???G?
?ff??
?
?G?\????=q?33???{?zH??}p?k?k?Q?h?p?W
=?Tz?^R?u?ff?
?L??z?zH?h?=p?zH?8Q?L?c
?B\?@  ?s33?B\?h?@  ?s33?=p?zH?5?L?G?L?Tz?\(?aG?B\?c
?L?Y?s33?Q?W
=?k?c
?s33?^R?c
?aG?W
=?Y?aG?W
=?c
?k?fff?Tz?aG?W
=?h?fff?k?h?^R?Y?^R?W
=?k?fff?u?^R?c
?k?c
?\(?c
?xQ?n{?Q?=p?L?8Q?Q?p?Q?Q?W
=?fff?\(?n{?O\)?B\?
?fff?u?^R?fff?\(?\(?fff?xQ?
?fff?p?k?ff?G?zH?k?}p?^R?fff?k?O\)?c
?aG?p?p?p?p?xQ?zH?}p?xQ?  ?u?xQ?h?s33?xQ?xQ?zH?s33?zH?p?G?Y?u?h?}p?\(??  ?xQ?fff?ff?\?u?G???\)?=q?(?=q?xQ?\?G??
??s33?xQ?ff?
?\????=q?
??
?\?\??{?ff???{?ff???=q??????{?
??\)?ff???\)????H?z?\)??\)?z?=q?33?=q?  ??z?????ff?\)??=q?H?ff?ff?\?˅?\)?\?@~R@`  @  @(@
=@H@@@@\@\@zA@ҏ\A=qAA1A7APzAtAuAzffA{33A\)AffAA(AGAHA{AA\)AzA33AA33A  AAAA=qA\AARAHAAA{33AnRAC
=A1GA7
=A.\A$A&=qAffAA33A\)ApA33AQAA@HA(A!pA%A(A<AIAdAOAgAZ{AF=qALzAHQA,A3A&HA
A+\)AzA	pA33@
=@
=A @@@
@  A z@p@Å@(@H@33@z@ƸR@z@p@
@\@@33@H@@R@@@@@Q@@AAA3AL  AS
=A_AYpAS
A`zAfHAlAsAxQA{33A\zAzAAffAA(AA  ARApzAEA@(A (@@G@z@\@  @@G@p@@(@@z@G@@@G@@@
@@H@=qAA@߮@\@Q@p@A\)@  @H@  @H@У@љ@
=@\@A=q@Q@ƸR@H@@z@@R@
=@@n{@@  @ff@h@vff@  @@
@H@Q@Q@c
@
=@  @@@ָR@Q@AQA
A*{A-GA>RAHAQA333A(AA8QA\A%@@@H@@@\)@@@@H@@H@θR@Å@ٙ@QAA @@p@@أ@@33A A33A
{AzApA@=q@H@Ϯ@ٙ@R@H@ff@
@@\)@ff@
@أ@@@{@
@  @ᙚ@ƸR@{@@pA
=@p@=q@l(@@
@@33@
@@@ff@@\@  @@@p@
=@@@z@ǮA  A  AApA'
=A=GA4  A]AAQAAA\A
=A\A  AɅA
A\ARARA
A\QA8AS33A.\AapA)AAz@33@ƸR@G@R@=q@@p@@ff@  @
=@@\)@{@HA   A=qAc
=AAQGA@ۅA$QA1A@A'\)A(A{AA Q@Ӆ@ff@@p@  @
=@Q@=q@z@
@H@Q@ə@@@@x@l@z@H@@@@W@nR@g
=@j=q@J=q@s
@33@H@R@\@AR@GAA\A%pA9AJHATAtzA
AAzAAAGA(ApApAHAAGARA{AHA{A
=A{AzA\)AGAAzA\A,(AG@ff@@33@z@QA
@z@Ϯ@\)@H@ָR@=q@  Ak@AV{A(  A-AO
Ah  A\A
=AHA  A|AqGA4A<  AbRA0(A#33A(A/
=AA@A{@{@G@Ϯ@
=@{@R@xQ@ZH@qG@U@:=q@\@=q@8Q@qG@[@@~{@@{@=q@
@@H@(@@@{@@
@{@RApAA   A3ATQAg\)Ac\)A{
=AwAxQA{A\ApAHAzAA
Ar=qAqAAA=qAzAAA
=AGAaA  A*{AGAYAXQATA,(A"{A  @ٙ@@=q@
@
AGA((A1A8A+33A.HAApA
A(@
=A=qA\)AAGA\)@
A	A A33@@{@@p@޸RA   @{@ʏ\AAAR@@33@ff@
@{@33@ff@G@G@@@{@ƸR@p@  @@@33@@@
@A   @HAAA$QAB{APAPzAhQAzA(Ax  A(A{AAApA(AAffAGAA  AA=qAApA=qA=qAiAK\)ATA/ATQARRA<zA/A,A{A  @AGAA@{@ٙ@  @@A7\)A:RA1Ap@
A\)A=qA\)@Q@(@33@xQ@\@J=q@@@G
=@5@@  @<@\@'@33@(@,@6ff@[@w@\)@\@z@=q@@@
=@H@@ff@@ff@Q@@أ@(A{AA
HA\A*ffA8A4ACAEGAG
AHzAUAj=qA(AoAd  Ad(AAAHAGAGAA{A\AAAj=qAYGAPA7A6=qA+A0QA:ffA0QA0zA>\A{A\)A
=@\)@p@@HAGAA(AAA@A\)AA
RA0@ᙚ@z@p@=q@=q@  @H@z@z@H@R@
@p@@@p@\)@
@g
=@@@@@G@K@<(@@@	?p@
H@@Q??{@Q@@`  @	@ @9@@^{@G@(@\@@p@\A
AA\A!pA&\A#\)A/
A3AG
=ALAC
=AIpAEAUAKAL(ABRA=A9A-@pA
H@@aG@|@@@z@@\@  @H@@^{@hQ@|@x@|(@G
=@X@@  @p@tz@Fff@<(@$z@5@2\@3
@?\)@
@AG@8Q@%@nR@5@@  @(@=q@\)@[@\@Z=q@33@dz@%@@?\)@z?@
@@ff@	@  @?p@33@333@.R@G
=@9@w
=@g
=@s33@@ff@A
=A33A8QA333AF\AIpAx(AA|A\AARA{33A
ADA?\)AIAzAzAffA_
A@A0ApA@@A  AA,(A?
=AF=qA/\)A<  A-A,  A  AGAAGAzAA A+33A#
A\)AAQAAffA  AA33A
pA	G@ff@QA  @A@33@\)@G@(@H@@(@Q@ָR@  @z@ff@H@@xQ@  @Q@@{@|@
=@\@u@~{@@
=@@@@@@@s33@S
@@@Q@RA\)A\A{A*{A7ANffAiA~HA\)AAAA{A
AAA=qAoAzAHA
=ASAaGAARA@Q@Ӆ@(@
@=qAUA[\)AK\)AYATAXAXAYA0QAZHAA#A!A,(A@(AMpAVffA^{AUAc\)A @@33@z@@H@ʏ\@@@z@(@33@@\)@@z@
=@33@=q@{@G@  @33@@H@  @=q@@z@@33@\)@@@@{@@˅@
A=qAA
HAGA
=AffAffAAAffAGA
H@33@ۅA,AT  ATA\)ApA<AA7AAYAbRA	@GA (@R@Q@@G@  @\@p@(A@@@
=@
@33A)A@A\)AA  @z@H@@AffAQ@ۅ@
=@@G@@@{@Ӆ@{@z@
=@@=q@\)@p@R@  @w
=@~{@@@ff@Å@{@q@9@7
=@P@S
@(Q@ @xQ@ff@c
@:=q@<(@;@Mp@>R@O\)@Y@(@tz@c33@\)@@@ʏ\@\)@A	pA  A
=A/AG33A2ffAB\A3
=A;\)AAA0(AO
=Ac\)AHAQAffAHAA\AzffARRAyGA]A6\A
=A
=@@@G@
@=q@=q@=q@G@`@33@u@y@]p@Vff@Vff@`@k@h@=q@@@@z=q@(@S
@@QG@\)@q@{@Fff@B\@u@[@\)@@G@@@zH@jH@-p@"\@%@
H?(@(@'@,(@#33@Q@'
=?Q@@(?\)?Q???=q??˅?R?p?˅??{@33@+@L(@hQ@<@G
=@_\)@e@Tz@aG@<(@j=q@zH@\@s33@_\)@L(@s33@U@;@H@7
=@>R@8@Fff@8Q@^{@W
=@Mp@E@U@P  @@@8@a@>R@R\@<@@(@'
=@(@:=q@@  @6ff@.{@8@K@G
=@Mp@;@Fff@?\)@8Q@:=q@1G@8Q@@  @=p@1G@*H@ff@z@\)@
@!@@'
=@   @\)@\)@ff@33@@ff8Q?\)??33?\)?\?}p?\??  ??\)?G???33?=q?p?z?\?Q?\)?\)?
=??z?
@@@$z@'@5@5@8Q@Dz@H@X@:H@6ff@1@\@k@@Q@@@{@@;@~{@33@H@Fff@@  @<(@   @'@(@{@33@ @@?@ ?@z?\)?\)?@z@@   @HQ@W
=@?\)@(@(Q@@z@
=@{@?@ff?ff?Q@	@ff?p?33@33??޸R?Q?(?У?H?z?ff??=q???H?
??ff???R???=q?z?G?R?33?˅??33?{?p@@@@)@/\)@<(@8Q@7@P@`@w@u@P@E@L@C33@I@K@]p@fff@^R@ZH@HQ@(??
=@\@
H@!@33@'@4z@@{@
@   ??Q@@H@(@
@)@#33@3
@,(@#
@0@$z@(Q@7
=@\?Q??p@Q?ٙ?(?@???H?
??ٙ??Ǯ?Q???=q??Q??33?p?33?{????  ?{???\)?z??Q?(?G?\)??
=@@(@%@2\@Dz@W
=@p  @33@c
@e@@ff@R@@p@p  @
@\)@XQ@\@c
@I@c33@U@QG@%@J=q@>R@@6ff@7@@(@Tz@aG@33@H@%@I@\)@*=q@B\@Y@5@.R@&ff@#33@+@   @*H@@1G@H@@(?(?=q?@\)??H@G@@ ?H??33@??p??G?=q?33??(?33??
=??
=??H?ff?(?G??=q?z??\??p?p??޸R?@.R@P  @n{@\)@p@@p@{@@R@\@@{@\)@33@
=@z@(@@p@h@HQ@U@^R@   @Q@=q@5@'
=@@@{@!@@   @ff@!G@
=@!@<@Q@W
=@;@l@fff@n{@hQ@dz@7@K@=p@>{@*H@&ff@@
p@33@ @,(@'@z@)@333@R?H@@ff@@z?R@
=@   ??У?Ǯ?G?ٙ??˅?{?Ǯ?\)?H?ff?\?޸R??ٙ@@(@{@@@.{@6ff@4z@B\@mp@{@ff@(@@@p@ƸR@ȣ@@
@@ڏ\@\@Ӆ@љ@=q@Å@(@=q@@H@\)@@R@@Q@@333@=p@?\)@+@i@33@
=@:H@s
@Q?{@ff@G@33@%@Q@R@{@A@C33@7
=@vff@E@E@P@J=q@?\)@)@2\@:=q@.R@$z@!@*=q@%@@33@z@
=@@?޸R?z?ff??{?=q?z?ff?
?
=?޸R?p?H?z?  ?޸R??(?H?@   @Q@%@8Q@S
@j=q@|(@(@@33@=q@@ٙ@\)@\AQA
pAA
=A\AQA AA
AA
ApAA  A
=AAzAAffAA QA @@G@@Q@  @@z@@=q@G@\)@  @R@ҏ\@G@@@@
@z@@@z@@\@p@s33@@aG@(@S33@i@G
=@hQ@\@ff@
@l@R@J=q@1@\)@5@-p@1G?33@z@ff@,@<@333@.R@*H@3
@AG@@@B\@tz@xQ@(@@
@@p@p@ٙA33AAA(A(Ap(AmGAGAA(AA{AQAlzA\AGAA~=qAk
AlzAJRAPQA33A	@AA33@
=@\)@\)AARAzAzA A
@ff@33@\)@@H@R@\)@R@G@@R@(@@
@@A @@@R@~R@l(@\)@33@u@l@+?=q?z???H?Ǯ?R?R?33?\?  ?p@{@@)@9@AG@H@P@y@Q@ff@zH@@
=@ff@  @A
=AzA'A'@A@G@@xQ@  @=qAA(@A?\)A1@޸R@
@@@z@=q@@Z=q@&ff@@
@0  @"\@(@@@
=A@@G@c33@'
=@7
=@7@2\@Dz@zH@c
@e@zH@-p@L(@C33@G
=@7@JH@N{@S33@U@a@c
@O\)@U@c
@j=q@hQ@a@s33@R@o\)@g
=@
=@@\)@  ?p?(?R?G?H?H??p???Q@H@@   @>{@R\@ff@p@\@=q@\)@Ǯ@@@A
=A33A(AffA#A7
A>ffAHzAQAVHATzARffAZHA{\)AS
=ANffAEAMA
A(A'A@p@@@x@R\@@ff@p@p@{@u@Fff@qG@^R@3
@@  @ @"\@{@^{@G@(@[@@O\)@ᙚ@33AQAzA{@  @ffA{A\A@
=@@ff@@\)@@  @ZH@?\)@jH@G@(Q@2\@E@Z=q@P@a@S33@hQ@U@XQ@j=q@hQ@[@JH@E@Mp@`@s
@b\@e@_\)@g@l@g
=@^{@jH@w@\)@=q@@A@z@zA
@@
A\)A;AA%GA
=A!A{AffA@(AAz@AzA6RAffA(AY@{A
A,A
=qA!A5@{@@  @@\@@(@@33@ᙚ@Q@@G@
A	GA(A A@@\)@H@  @R@@p@\@
=@p@@G@
@\)@z@33@ۅ@@Q@p@  @\@(@Q@dz@k@R\@z=q@@@@@@@ff@Q@p@pAA
GA  A"=qA-pA1A=AK\)A`A`Ak
=Az{AuGApA  AAHAA]AAGA5GA-A,A'33A@(AAGAc33AdQAA`(A_\)Ap  AYA4A(@ffAbHAUAAzAQA/\)A(AHAApAeA(A@A5A&\AMGA1p@z@QAHAXAC\)AXz@Q@ff@@@ff@
=@@y@@\A=q@p@p@@\@z=q@33@G@33@ָR@AF=q@޸R@{@GA!A
ffA:H@{@zA{A @R@{@A\)@  A{@ff@\)ARA0AXAg33A[33AlABHA7
AKAD@A(@=q@ff@@@ff@pA@p@
=@  @ff@Ϯ@
=@@A(Q@
@H@  A\@Q@@@
@H@˅@\)@A33A{AzA=qA	GAAAA%A1A/33A+\)A0zA8zAMAt@@HAmGARA6RA$A=qA*ffA	G@ff@@H@Q@z@\)@H@\)@@@33@H@@@@
@@Q@H@\@@AA-A4  ABRAEABffA?A&{@Q@@\)@R@=q@=q@(@{@z@@˅A   AA<QA8QA*HA,zA>{AS\)A:=qALQAUGALQALQA@@  @R@@  @=q@H@
@@@z@陚@H@Q@˅@G@  @@z@
@
@H@R@Q@@@@@p@@@Q@@z@Ӆ@p@z@
@z@
=@@  @@ȣ@\@@R@33@G@@g
=@xQ@R@-p@@<(@`@@Mp?p?@   @R?  ??@33@@@JH@X@c
@mp@@@(@@Ӆ@ff@
=@zAHAARA
A{AA[
A\A
p@@=q@Q@
@@(@Q@p@@@@H@\)@
@@R@33@@mp@h@Vff@I@6ff@Z=q@dz@Y@W@>R@Tz@H@C
@JH@AG@I@K@QG@H@
=@z@@@H@@@2\@J=q@E@E@:=q@Mp@G@I@P@@333@@@?@*H?  ?z?(??\)?G@@&ff@"\@%@
=@/\)@(@.{@\@Q@  @Q@@\)@0  @-p@B\@Z=q@~R@Q@
=@@z@33@
@33@Å@ə@
@33@Ǯ@陚AnR@@
@\@
@H@@p@jH@u@k@@@z@G@@x@p@@@@}p@y@Q@\@z=q@=q@=q@  @~R@~R@zH@qG@Z=q@K@N{@G@U@L(@QG@;@@@<(@<(@+@7@%@#
?Q?H?z?@33?=q@33@(@?{?ٙ?У?
=?{@(?\)??G?(?\)@??
=@   @
@ @
=q@
@
@ff@$z@#33@(@,(@7
=@Mp@ZH@`@w@@p@@
=@@@\@H@@ۅ@@ٙ@@׮@\@ۅ@
=@ָR@ff@@@@{@{@ə@@Q@\)@H@
@xQ@0@j=q@\@@@{@{@@33@@\@\)@n{@mp@1@|@P@5@G@ff@JH@H@I@^{@^R@Dz@1@3
@:H@(@   @z?Q?R?  ?p??G???\?\@(@z?p?R@ @??
?  ?R?=q?
=?\?\?ff?33?\)@	@!G@3
@p  @r\@p@@@p@p@@@У@\)@
=@@\@R@Å@׮@ȣ@Å@@H@@@
@\@@@@@b\@\@G@@@U@W
=@P  @L@b\@H@@z@@g
=@zH@~{@~{@s33@h@XQ@J=q@Dz@E@J=q@%@L@E@333@33@5@5@ @=p@=p@@  @.R@@G@HQ@G@	@??(@
H@
=q@@H@$z@#
@/\)@.R@0@2\@C
@O\)@HQ@N{@e@X@s
@G@@@=q@@@H@
AARA!pA/
=AAGA6{A:ffAjffA[
=AIGAW
AF\A)pA4AX(AQA (@=q@Q@l@G@\)@=q@θRAR@z@\)@  @\@/\)@$z@@(@Ϯ@@p@@@@p@p@=q@@@G@=q@=q@׮@\)@
@z@\)@\@@\(@X@
=@.{@
=q@(@9@+?ff@(??
=@
=@\@@G?\)?G???(?Q@8@W
=@ZH@S
@XQ@S
@JH@n{@ZH@@XQ@p  @R@@R@R@@@ff@z@33A
=A)AAAAAGA@(A@A0QA?\)AC33AMpA?\)AA@Q@(@p@@˅@=q@@ff@@@vff@C
@
@G@p  @P  @>{@<(@-p@!@%@\@
=@Q@=q@3
@Dz@`  @ZH@aG@O\)@zH@H@C
@'@ff@)@k@G@S33@|(@vff@z@@G@@Q@@q@l(@8Q@@  ?@?\)??z@@9@33@>{@
=q@,(@HQ@c
@(@@vff@@\)@z@z@{@QA   AARA
AA!@ff@(@z@Q@y@(@  @RA
G@=q@uA>=q@@
=Ap@Ϯ@  @J=q@Q@H@S33@l(@R@
@
=@p@=q@@@@@@=q@@Vff@g@N{@\)@&ff@  @7
=@333@	@
=@!G?H@@G@@
=q@@
p@
@\@@?@z?(??R??R?33??@?{@
p@?\@2\?R@AG@S
@mp@e@R@  @@Q@\)@33@@ff@\@
@@@@c33@@G@p@@@@@p@ff@ᙚ@θR@@\)A
ffA  @pA(@p@׮AHA  A
A33@@@ffA@=q@33@Ǯ@@G@@{@@˅@{@z@(@_\)@P@=q@$z@S
@|(@X@Mp@|@
=@S
@Q@\(@U@A@>{@'@.{@3
@'
=@8@!G@@
=???
=?33?H??{?\)????(?p?p??R@
p@@H@'@,(@(@(@:=q@9@G@P  @]p@W
=@7@S
@e@G@
=@=q@z@Ǯ@=q@RAA=qA.HA.HASAQADABHAWAUGAPAHzALQA2HA@(ACA7AC
A7\)A;
=A0  AA
RA=q@\)@{@R@33@@ָR@\)@33@@{@R@z@{@p@@H@(@@z@@Q@ҏ\@
=@ʏ\@޸R@@
@  @@ff@  @=q@C33@H@
@
@QG@!?R@@ff@;@<@????@ @   @hQ@I@>R@E@z=q@\)@
@p@\@@@  @G@H@  @@@@GA\)AF=qA
A#A8  AH(AAG33AAxzAtA)A3
=A4  A,  AA$  Az@z@p@@=q@@@z@33@
@(@@
@33@@  @Q@z@@(@@\)A33AGAQAA#33@
A$A33AA@أ@p@У@@tz@vff@
@ff@  @@@{@Tz@(?@/\)@?\)@  ?H?  ?=q?G??\)?@	@$z@%@Mp@R@Q@
=@\@p  @z=q@@=q@{@@=q@׮@ff@{@\)@ᙚA
=qA\)A8AJRA[\)AMGALAAFHA=pAAp@  A!@A
@@p@@ff@{@@
@Q@l(@U@L@E@C33@Mp@1@@R@#
@6ff@<(@HQ@'@'@H@@@@ @ @'@Vff@|@q@l@`  @p  @O\)@@{@{@r\@=q@R@@@=q@@(@(@{@]p@`  @@  @@@@  @@Q@'@%@2\@U@Dz@XQ@e@hQ@j=q@l@g
=@@hQ@Q@{@Tz@j=q@a@\(@{@@@
@\)AzA33A9A6\A<AZ\Av\Ak
=AwAs
=Aw33AsAWA\(AX  ASA7\)A1GA	GAQA6HAG@  @@Ϯ@\)@@H@@@ff@@@@@  @@(@\@H@{@z@@@
=AGA
AA	A(A{A33AQARA zA @@@H@p@R@@@R@@\)@@|@@p@H@G@@Q@u@Q@s33@H@nR@@@Q@@@@  @@@  @ff@(@
@H@G@@@  A	ARA%A5GA>=qAKABHAFffAhA[33A^RAdzATAC33A_\)ARA@@@  @
@@@(@  @  @@|@R@@@z@@j=q@z=q@q@ff@ڏ\@33@(@ff@  @  @Ǯ@
=@@=q@
=@θR@{@33@@
@(@\@G@R@@
=@@Q@XQ@@33@,(@
@QG@X@\)@mp@P  @ZH@NR@o\)@@
=@@@{@\@
@@33@@
=@ff@@Q@ָR@
@ff@@AAHAAH  AVHAmAAGAAAAApA{A[AHA
=AAfHAG
AcA)A@
=@ff@@@Q@ff@  @{@=q@{@@@@\)@@  @=q@Q@@R@{@33@p@p@A@@ff@ə@  @z@G@H@P  @9@#33@	@QG@@@1@  @y@  @G@@@  @o\)@U@
@~{@R@H@@@@i@\@@\@H@
@
AffAAAzA
A (A%GA*RA?A_
AeAd(AiAgAL  AHzADA?A<A:{AAGA<  A%pAAGA((ABffA6{A&\A<QA1AA{A(@ff@
@\)@=qA{A Az@{@ff@HA   @=qA@RA (@@@@{@H@@R@\)AAA	G@@ff@@{A @A
A=q@z@H@@@R@  @@@ڏ\@p@@@33@tz@`@@\)@{@@G@(@H@33@Q@@{@zA
=A
ApAHA.HAK
=AV\AN\AZ\An=qAAAQAQAqASABRAnRApA+\)A%GA  AA A
=AA=qAA!pAA
=q@@  @\)@p@G@
@@@@{A@@\)A
@z@
@z@p@
=@zA(AA(@ff@@@@{@߮@Q@@zA
HA @A{AA(A@A   @
@Å@@ۅ@\@ʏ\@{@p@@R@(@
@p@
@@{@@{@z@@z@@R@  @\)A
ffA  AAGA  A=qA>ffA?33A5pA+
A?AC
A*ffA<A&HA*=qA @{@A
@
@\)AzA  @G@G@33@{@ff@ǮA$A@ff@ffAAzA  ApA@
=A@陚@  AA=q@AA@@AAA@R@p@@
=@@@Y@R\@&ff@1G@w
=@Vff@QG@
@
=@j=q@U@@  @@3
@R@@tz@=q@\)@3
@!G@P@K@C
@@I@  @  @Q@@\)@@@ə@33@ff@  A
=A!AGAA4(AeGAnHAw
AR\ARA,QA:{A=qAA@A\)@{@H@33@  @@@H@o\)@e@{@l(@w
=@w@H@@  @ff@Q@  @@Q@@H@G@@@jH@@G@@(@@@@@(@x@jH@Q@R@=q@g
=@Z=q@U@Q@L@0@p@<@{@
H@*H@p@7
=@=p@ff@@
=@Q@@,(@^R@P@@c
@g
=@l(@\(@I@A@@@L(@nR@z@@  @{@@
AA\)A
\A33A2\AEAmAAAYAh  Ac
ASAZ\A7A2HA33ARA A#A  @@Q@
=@z@
=@  @ff@\@33@g
=@^R@;@C33@aG@c33@c
@j=q@a@c33@nR@XQ@G@Q@p@@@  @
@R@@dz@NR@%@0  @.{@-p@'
=@>R@7
=@2\@g@+@333@Mp@7
=@(@)@{@@@@JH@,@
p@
@?@%@L@[@W@`@~{@AG@N{@{@@H@{@=q@Å@=q@
A
=AAA'A@QAN=qAOAcAdAzHAAAT(AdAbffAxQAvffA<(A (A?
=A/
=@GA@w@@@A @A z@(@陚@@@
=@@A33AA\)A  A(AR@=q@@AAffA
{@A4@@@@x@33@ @(Q@-p@@33?@E@{@=q@E@7@C
@xQ@hQ@(Q@(@ff?\)?
???Q?  @\@\)@=p@@@H@G@@mp@@R@G@Q@@@33@@
A (AA,AH(AZ{A=GAtA{\)A~ffAs
AVHAMA"HA8A
@(@
=@@@@ָR@@H@^R@{@{@z@\(@N{@S
@~{@QG@\@'@+@1G@:=q@0  @3
@.{@5@$z@{@$z@"\@R@@{@
=@/\)@@\)@s
@p@Vff@G@E@}p@Mp@E@7@>R@G@@ ??\)?G???G?ٙ?H?R?=q?{??{??z@@z@@
=@R@.R@4z@XQ@y@y@33@  @@(@(@{@=q@У@\@@@pA@p@@\)@(@Q@(@u@(@H@@@@
=@=q@G@W@zH@@Dz@R\@!@&ff@s
@Q@33@H@aG@g@l@Tz@}p@@@  @8Q@@!@ @@@@
=q?\)@??ٙ@@p@z@z@(@@@@@1G@AG@8Q@,@333@ff@Q@\)@ @H@R@ ?
=@   ??z?(?G?H?\)?޸R?Ǯ?ff?  ?{?\)?{?@   ?33?  ?@@)@'
=@?\)@p@Q@nR@@@  @(@33@(@H@@@\)@@Ӆ@G@@=q@{@[@n{@Y@J=q@z@^R@O\)@;@G@P  @^{@Q@!@R??H??G??ff?@@@?@33@ff@(@@G?Q?У?Q?@,(@#33@!@ff@33@ @?p@@@@(@z@{??R?
??ٙ??p?
?  ?Q??
=?
=?=q??ff?p????  ??\??\)?\?33?ٙ?@
H@@(@'@0@NR@G
=@H@e@{@@
@(@H@=q@@R@@(@333@0@E@,(@\@qG@c33@.R@\@u@o\)@jH@^R@8@'@C33@@?{??H?
?\?z????p?33?ٙ?\)@
p@#33@"\?
=Aə@@?@   ?\)?H?
=?33???Q?z?33??H@	?}p?z?G?У?ff?@AG@HQ@8@H@@H@
p?  ??????Q@@
@ @+@?\)@Fff@\@QGA@H@=q@u@\)@33@@@G@g@_\)@Tz@NR@<(@7
=@-p@0  @B\@6ff@\)@R@33@?Q??
?
??z?  @   ?\)@
=??p?ff?  ?  ?33??У??R??H?Q??xQ?\??{?
??xQ?H?(?G?{?޸R?p??У?
=??˅?ff???{?
=?{??p?  ???\?{?p?
?(?G???  ?
@?z???p?{?@=q@-p@Fff@g
=@_\)@u@[@p@hQ@`  @W@o\)@w@u@{@z@@n{@hQ@S
@Vff@I@AQ@Q@ff@
p@?Q??z@?????\?\)??(?=q???{??ff??\)?Ǯ??z?  ??\)??H@?33?\)?\)?@XQ@
?
?ff??Q?Ǯ?  ?ff?(?У?\??\?\?\)?\?p?=q?G???33?ff??G?{??(??G?@G@z@ff@'
=@,(@J=q@p  @@=q@@  @=q@
=@ff@
=@  @\@@@33@@z@R@(@\)@e@@W
=@Z=q@fff@(Q@:=q@JH@G@\(@O\)@G@*=q@7@{@1@G
=@\(@
=@{@
@	?R@z?p@
?H?G?{@\?H@\@33@
@
@G?@?33@ff@?=q@z@Q?Q?p@R@ @6ff?  ?z?=q?@(?У?(??z@33?
=@@   @Q@@G?=q?@
=@33@\@@1@P  @XQ@y@\@@@(@p@@\@  @=q@@{@(@\@@G@\)@@
=@vff@@~R@r\@c
@\@e@U@`@S
@k@G
=@tz@l(@L@,@(Q@5@+@'@)@1G@=p@AG@QG@N{@5@@Y@zH@hQ@Fff@L(@
@???
=???H?ff?
=????  ??\??Q@@\)@@/\)@;@L@Y@]p@
=@G@{@@
=@@ff@p@\)@
A @\)A"R@H@@
=@
@
@@H@Q@H@j=q@@@33@@@
=@@
@@@(@z@G@nR@c
@^{@P  @6ff@y@hQ@X@\@]p@[@h@K@:H@E@>R@QG@L(@%@2\@0  @{@-p@\)@%@\)@
=q@{@@	@ @
=q@Q?33?(@\??ٙ@\?\)?
?H?Q?  ?Q?R?
?ff?p??G?(?
??
=@@@33@\)@z@nR@=q@Q@ȣ@HA333A
=qARAHA2=qAGAGAJ{A(Q@(A\A	G@Q@@  @~R@p@JH@nR@@(@s
@33@@&ff@@@Vff@2\@ @@@@Q@@?(@@Q@ff?@33@#
@&ff@?\)@%@P@7
=@@@Q@%@(Q@/\)@2\@E@N{@0@<@+@8Q@Fff@7@.R@R@ff@@z?R@   ?33??=q?@1G@@2\@l@w@@@@ff@Q@(@z@H@(A
pAHA\)A  @  @@z@@ڏ\A
AmG@@
=@@A
=@G@ff@\@p@@A
=@@z@߮@\@@@@z@|@@
@
@{@{@  @@ff@\)@H@@
=@{@=q@p@R@@@
@@\@z@R@Q@\@\@z@p@\@y@u@l(@s
@`@b\@e@]p@e@}p@G@\(@W
=@tz@fff@`@33@@Q@dz@C
@"\@8Q@N{@@@1G@!G@1@:=q@=p@{@7@0@4z@;@1@8Q@C33@-p@Mp@,(@*H@H@.R@.{@6ff@K@S
@A@Dz@\@Y@O\)@hQ@e@@@~R@(@ff@u@vff@Y@ZH@XQ@Tz@H@U@>{@E@4z@/\)@AG@B\@@@6ff@0  @1G@C
@333@<(@A@HQ@?\)@A@K@7@E@@C33@A@*=q@333@&ff@1G@\@
@{@Q@\?(?
=??\)@?G??
?(@
H@(Q@g@aG@@G@C33@#33@
=@G
=@@@@
=?R@Q?H@@333@K@@
@Q@R@\)@@zH@@z@{@&ff@˅@e@  @H@@33@(AQA&\@@{@@@@W
=@QG@C33@l@P  @nR@g
=@l(@s33@hQ@o\)@y@hQ@@G@
=@qG@|(@^R@L@O\)@^{@g
=@Dz@/\)@:=q@-p@?\)@<(@;@@@E@L(@P@W@^R@@@Tz@2\@!@\)@=q@W
=@c
@X@R@X@e@}p@a@`  @qG@NR@fff@+@HQ@>R@J=q@P@$z@B\@HQ@>{@QG@Mp@n{@z@N{@\)@@@(@H@
=@{@ff@@o\)@@Q@R@@
=@ٙ@33@ff@@{@Q@@r\@H@>R@>R@l@  @ff@G@R@(@@ZH@XQ@@  @{@@@޸R@ff@@(@@\)@ƸR@@R@  @s33@xQ@h@ZH@e@_\)@mp@zH@~{@ff@{@b\@XQ@X@Dz@Q@Dz@@  @JH@dz@i@{@k@mp@a@;@3
@,@8@5@*=q@-p@8Q@-p@1@1G@(Q@<(@Fff@Mp@I@U@Mp@HQ@]p@`  @u@S33@s
@mp@ff@@\)@(A @{@HAA\)A"\A6\A<AR{A(zA8(AO
ATQAG
=A<  AG33AGAQAAzA(AA@@@ff@\@
=@
=@(@Q@e@Z=q@zH@ff@(@
=@@@@@H@@Q@H@\@@Å@Q@{@@@i@{@\@{@@  @(@_\)@c
@l@i@P@N{@)@J=q@,@ff@.R@{@+@,(@8@G
=@zH@\)@Q@Q@y@~R@xQ@mp@u@p@s33@@vff@xQ@|@R@{@(@@33@G@  @(A\ARAHA A%A
=AA"{A/A+\)A1GAAzA
A6ffAA\)A&ffAA@
AA
@(@33@{@p@33@\)@(@\)@ff@@ۅ@
=@Q@  @p@@R@H@@
@@@@G@@@{@G@@33@@
=@(@  @@z@Q@@R@@n{@QG@7@<(@J=q@HQ@G
=@U@z@vff@X@S
@E@L@W
=@jH@  @s
@u@G@G@R@  @@\@@@@  @ȣ@ҏ\@
=@AffAffA=qA=qA{AHA\A1A
=@(@ff@  AAA{A*{A+AG33ABffA3A9A:=qAAA&\A!@R@@\)@
@p@Å@Q@Q@@(@@  @
@ʏ\@أ@
=@(@33@@=q@  @u@n{@NR@~R@A@w
=@X@X@NR@N{@aG@u@5@(@~{@W
=@ZH@"\@\@8@?(@
?
=@R@=q@+@<(@>R@C33@\@g
=@@@s33@w@Q@
@(@@\)@R@ff@
@@=q@p@\AQAA$A*ffAEpA\QApAAP(AipA|AQ@QAHAUA:ffA&ffA\@33A	@@G@{@
@@
=@NR@y@Tz@R\@Dz@J=q@\@JH@Dz@,@QG@A@Z=q@P@7
=@\)@>{@E@L(@@@0  @,@;@i@h@X@Y@>R@P  @}p@zH@XQ@[@qG@vff@`@w@HQ@L@s
@z@  @@Y@33@L(@J=q@\(@s33@XQ@W@~R@P  @\)@ff@zAQA@H@{@A zAffA=q@(@z@޸R@@=q@
=@@@\(@l@  @y@vff@@~{@\@(@G@@  @R@@R@@R@g@Y@A@I@G@HQ@c
@jH@W
=@Vff@P  @G
=@[@^R@l(@@p  @s33@p@j=q@S
@NR@QG@K@ZH@Tz@QG@QG@;@$z?=q@%@  @=p@0@@"\@@@Q@33@G???@Q@
@)@@333@[@?\)@z=q@c33@2\@k@+@/\)@
=@
=@??{??
=@@@
=@@(Q?ff@
@   @{@
=q@@@,(@*=q@{@	@@  @!G@Q@33@Q@
@@<(@$z@
=@@   @   ?\)@ @
H@
=@ff@#
@ff@H@@@ff???=q?
?Ǯ?Ǯ?޸R??G??G?H?(??Q?R?
=?
=@u?(?
?  ?{?33???p?Ǯ??Q@\@
=q?@@ff@@?Q?  @W@0  @5@W
=@1G@	@z@   ?G?=q?˅???33???  ?Q???G?{?Ǯ?R??H?{?\)??p?Q@G@#
@
=@\)@,@\)@(@'
=@u@9@ZH@!@,(@.R@:=q@'@(Q@E@;@:H@B\@A@.R@5@'@;@:=q@P@#
@\@H@
p@@@*=q@ff@2\@*=q@)@9@<(@$z@'@R@*H@;@5@8Q@(@(@
=q@(@{@@!G@0  @(@6ff@C33@aG@"\@   @_\)@r\@\@\)?R?R@
p@?H????(?H?p?H?=q??p?
=?(?33?(?R??
?  ?H?
?޸R@@@H@8@<(@Z=q@c33@u@@i@}p@k@@z@G@(@\@\)@@p@\)@{@H@@~R@@z@z@@x@\@\)@x@33@=q@p@@Tz@@u@N{@8Q@a@333@@@'
=@\)@(@8@8Q@9@H@E@W@333@5@C
@)@7@9@7
=@.R@#33@\)@,(@AG@.R@(@$z@#
@
=?z@G??{?G?G?@@H@R@(Q@B\@E@HQ@Q@O\)@:=q@Dz@>R@>R@\(@\(@u@\)@@@H@\@ə@@  @Q@
=@@ff@H@(@RAp@@33@
=@@z@@{@H@@ҏ\@
=@{@
=@=q@@
@@  @@ff@Q@j=q@w
=@|(@a@E@Fff@:H@:H@4z@1G@0@'@L@w@U@H@;@6ff@@ff@+@AG@E@dz@l@U@a@9@W
=@5@\)@)@   @"\@$z@G@{@?{?Q?(?G?=q????33?G?z?G?R??(??H@?(@@@  @ @:H@\@x@@\)@@\)@@33@@@(@=q@@A\)@\)@{@z@@
=@@33@z@
=@@}p@qG@c
@u@\)@_\)@]p@aG@Q@@@r\@X@;@6ff@"\@R@@$z@Q@\)@ZH@ZH@ZH@`  @XQ@e@X@:H@fff@=p@a@Tz@a@_\)@Z=q@P@a@xQ@@@:H@U@\(@\@JH@9@/\)@#33@
p@(@3
@:H@\)@!@vff@s33@e@nR@jH@l(@U@>R@NR@;@-p@B\@w
=@HQ@E@y@Vff@c33@L(@Vff@^{@n{@(@@(@=q@Cn@@ff@ҏ\@\)@33@=q@@5@
=@{@ff@S33@@HQ@jH@(@p@G@}p@2\@7@@R?p??H?G?޸R?\?\)?G?
?
?  ?H?\?p?z@2\@(Q@K@#
@R?ff@@33@R?(@\@@)@333@HQ@:H@p@
?@?=q?{@@?p???
=?G?z?H?@?{@
@ff@*H@P  @,(@4z@@  @NR@C
@=p@0  @@@A33@GAARB7@=q@(@Q@z@
AG@@@ff@Q@=q@\@\)@@H@33@@`@HQ@$z@ @@@H@@   ?\)?
?33??p?(?
?R?{??\)@G?޸R?
=??˅?H?\?Q?\?@#33@*H@,(@@
@?p@33@
?\?
?  ?
?\?
=?
??R?
?\)?R?
??G?=q??ff??H?p?z?\)?ff?\)?p????u??z?\)?  ?
?G@,(@!G@@{@(Q@'@@@@@{@@
=@@  @ @!@@?33@G@\@?H@
@@\)@(@$z@@Q@@@
=?p@
=?p@@33@?33?33@G@??p?
?Q@ ?
=??p?{???
@p?R@33?{@33@$z?33@,@H@ @\???Q?{?p??R?  ?(??
?{@???p???@
=?G?ff?@@G@
=q@{?z@
?z@8@"\@Q@[@tz@H@vff@@@G@@{@\)@c
@\)@
@@dz@[@w@w
=@hQ@S33@Y@`@e@g
=@@g@^R@jH@k@c33@@o\)@n{@e@h@_\)@XQ@p@X@R\@S33@nR@n{@{@dz@}p@@=q@O\)@1@fff@s33@u@(@@p  @U@L@;@@(@7
=@XQ@@(@Q@
@
??Ǯ??z?(???ff?
=?z?33?  ?(?33?ٙ@A?\)@@(@@'@9@NR@Z=q@Z=q@=q@z=q@G@\)@@=qA\@@@=q@@@@Q@G@y@@H@@\(@G
=@aG@qG@b\@jH@p@a@E@333@1@?\)@%@,@G@(@Mp@(?Q@HQ@Dz@4z@333@6ff@8@7@B\@fff@NR@N{@aG@j=q@S33@j=q@@n{@+@(Q@-p@!@:H@;@=p@3
@x@@@}p@-p@=q@
H@@,@@,(@	@=q@E@8@<(@1G@K@{@0@/\)@)@1G@\)@5@<@0  @NR@j=q@u@hQ@G@{@@@{@@ff@ff@
@@@{@
@@\@\)@
=@@(@\@HQ@z=q@JH@j=q@H@ @R@@  @&ff@Q@H@Q@p@H@ff@\)@{@R@ff@z@@(?Ǯ???=q?{?z?z?33?  ??p?p??\??R???ff?G?\?H???ff?У?33?z??\)?R?p?33@
@ @	@\)@@33?@33@{@
H@@,@.{?@R@)@@@&ff@3
@7@A@I@@@~R@
@@z@@\)@H@Q@@\@@H@  @@
=@H@z@
=@@l@c
@33@  @o\)@_\)@{@c
@h@fff@G@0@333@H@{@@G@y@aG@k@i@\@u@K@Fff@333@a@p@Mp@Fff@5@8@,@'@@   @Dz@0  @@(Q@
=q@33?=q?\)?
=?޸R?p?Q?{?c
?z?  ?\???
=??z?????33?ff??
@	@\)@G@\)@5@@4z@5@H@<@8@.R@:=q@9@!@vff@Vff@K@   @@{@@(@\)@z@\)@
@  @H@.R@%@@&ff@@333@p@\)@ff@  @@z=q@`  @C33@ZH@
@*=q@z?{@?\)@
=@+@:H@8@;@QG@9@\)@@{@33?(@@@/\)@@@R\@\@`  @S33@g
=@<@6ff@!@p@R?R?=q?\)??  ????p?z?=q?{?Ǯ???????
=?{@@ff@\)@;@.R@,@I@aG@k@xQ@aG@n{@h@E@U@}p@
@33@|(@@@Q@h@o\)@Q@\@s
@7
=@R@xQ@X@0@   @=q@0@*H@
=@@	?@@
p?H?H??@z@?@#33@-p@<@(@@@8Q@(@*H@'
=@.R@-p@ @@
H??Q???@%@(Q@Dz@"\@.R@7
=@>{@A@?\)@g
=@Fff@p  @C
@Q@6ff@:H@   @(@G@:H@e@q@Z=q@ff@Q@u@333@>{@E?
=?
?{?˅?(@@	@
@33@p@5@\)@33@!G@@E@!@&ff@#33?p@@33@G?@z@H@Q?R@?z@@{@$z?
?R?G?(?H??ff?p?=q?ٙ?=q?=q?ٙ?
=?
?@   ?@?ff?G?  ?{?
=??\)?
=@@ff@@G@
=@@
=q@\@j=q@`@   @#33?\@G??{?H??  ?p?(?{?ff??B\?Y???{?  ?Y?Q?}p?c
?33?s33?p?ff?33?G?H??
@.{@\(?ٙ?(@X@W
=@<@@G
=@\)@\)@nR@AG@Q@.R@'@	@ @@Q@
=@#33?H?@G@$z@C33@8Q@w@i@i@i@`@Z=q@@a@U@tz@5@E@;@{@.{@"\@\)@ @@(@
p@33@'@4z@u@1@@  @ZH@Mp@fff@%@C
@p  @dz@P  @vffA4(@@A=qA	A$A)A{AiGAA
A=qBhB=q@@\)@R@@c33@HAY@Q@A@Tz@>R@+@
@
=A:\A:ffAAA
=AzAأA#
=A_AyGA#AdA,  A33@@\@nR@I@|(@^R@Q@(@zAypA{AI@HA
A@@RAzAR\AHAA
ARA6HA@G@G@p@b\@K@p@@l(@i@z@{A\)A1@\)@pA!A=qA0AR{@AA+
=@@=q@\A(AA+33A{Ao
@  @=q@
@o\)A8zAqA$Aff@L(?  ?  @@@?=q@@
p?Q?  ???(?@H?H@@
??\?@JH@C
@qG@@z@xQ@
A{@@@?\)@JH@)@@H@  ?@z@33@@
p@G@{@ff@@U@hQ@S33@<@qGA/
@Q@|(@R@ȣ@\@
@
@@@@@
=q?G@(@R@Q@R@=q@@\)@uA@=qA\)@\)@AAAnffA zA!pA((@ÅA Q@@aG@?G?33?\?\@@RA	G@
A@(@33@@ff@S
@33@(@?G?
?{?H???p??
=@@
=@ @Q@)@%@<(@p@@dz@s33@=p@dz@Q@Z=q@\)@Vff@5@@%@ff@6ff@G@@@   @@.{@  @(@L@>R@@1@2\@*H@Dz@@  @.R@%@"\@&ff@ff@33@@ff@R@@
@!@@   @(Q@'@>R@33@R@xQ@W@8QA@@@@
=@
=@@@>R@@(@@=q@@(AG@@p@@ǮAH(A@p@@jH@Y@~R@;@+@3
@\(@-p@ff@(@
?@ @@{@X@@g@=q@g@fff@W
=@J=q@QG@Tz@C
@7@6ff@QG@6ff@6ff@0  @;@;@AG@S33@o\)@Fff@.R@A@4z@'@ @4z@@2\@8Q@@  @JH@@{@z@
@@	?H@G@\?@(?H@G@?\)@\@
??  ?33?
=?
=@
H@
H@{@=q@,(@jH@2\???{??ٙ??@u@(@+?\)@@X@JH@\@z@p@33@
@R@  @@  @R@i@@R\@fff@=q@\)@˅@R@_\)@_\)@fff@=q@@AG@5@^R@o\)@]p@Z=q@E@   @
?@@Q@
=@G@#33@l(@`@
?@tz@@X@l@W@AG@U@8Q@5@\)@
=@7
=@,(@.R@<@+@NR@fff@G
=@qG@<(@2\@*H@+@S
@%@)@R@	@&ff@!G@8Q@Vff@#
@C
@0@1G@h@u@aG@c33@G@7@k@W
=@+@H?
?{?  ??=q?xQ??  ?(?H?  @.R??{@(Q@0@
=???=q?У?(??@(@33@?H?@R@
@p@H@ff@\)@
?p@G?p?=q?ff?ٙ?p?ff??(?  ?ٙ?
=??Q??\)@@\?Ǯ??R?H?G?
=??G@@
?33?=q?\)??\)?G??Q?\)?{??\)?  ???  ?@@G@Q?=q?@ ?R?z?(?G?n{??R?G@"\?33@ @j=q@33@]p@\@\@\@Vff@dz@@33@\@,(@@JH@:H@ff@z=q@p@|@I@@@P  @4z@Mp@\(@P  @Tz@:=q@C33@.{@,@>R@?\)@C33@0  @Z=q@X@Y@@:=q@J=q@1G@z@@@\?@@	@G@Q@AG@1G@qG@P  @@=p@N{@`  @  @l(@^{@HQ@R\@qG@a@U@vff@W
=@U@S
@NR@fff@(@xQ@z@hQAL@8Q@R@߮@@
=@A@@ffAz@@@j=q@5@E@K@@Fff@#
@1@?QATz@^{@Q@W
=@>{@q@(Q@5?=q?@G@ @  ?H@\@S33@$z@1G@1G@\@5@0@
@z=q@c
@\)@{@@{@z?
@z??33?@
=?ff@   @@
H@7@QG@%?p@?p@
H@@HQ@:HAU@љ@b\@(@@@A
@@=q@1G@g@\@ZH@JH@^{@s33@@c
@Q@P@Vff@\)@c
@\)@^{@0@@ff@{@{@{@\)AQ@\)@HALA1AzAz=qAnffA  A
AeAp(A  AMA{A  B\A=qA33ẠAffA33A$z@ff@@y@8@
=@9@-p@(Q@<(@e@]p@E@E@7@HQ@W
=@a@B\???@'@
?  ?p????(?{?@
@H@'
=?p@??G??Q@?R?@G@@
@?(@ff@G@@333@5@<@(Q@8Q@l@j=q@n{@~RA{A
@33@(AH@ff@ff@>{@QA
HA
HAAZff@  @33@zAff@љA{A
G@
@Q@@hQ@
=A!@
=A@A%@Å@  @  @@
=@G@R@{@QA@w@@GAp@R@@Z=q@jH@P@K@<(@6ff@,@@@/\)@'@@@(@@@@??z??Q?(?(?z@
=q@?\)?H?
?=q???Q??
?Ǯ?33?ff?
=?G@
?z?{@(?޸R?@	@z@@&ff@
=@
=@33@ @0  @7
=@0@ZH@.R@0  @333@.{@(@"\@   ?=q?˅?(??  ?\)@?{?33??G?
=?s33?Y?k?\)?\??Q?p@8Q@z@z@
=@@@	@@  @Mp@X@_\)@E@5@c
@_\)@c33@`  @R\@Y@`  @[@S33@7@C33@U@@  @6ff@G
=@@  @;@#33@#
?@,@$z@   @@@
@@@@@\@@\@33@@@R@$z@-p?\?=q?H@\@333@>{@,(?ٙ?
=@@
=?ff?@C33@8@L(@-p@@@,(@  @z?ff?ٙ?@z
=q@R@S33@@/\)@.R@(@O\)@k@}p@@\@G@@7@  @ff@\)@\AA\)An\A(A;
ADAaAdzAyA{ApAaAJffATAeGAhQA_
=AlAfffApAg\)Ak33AdAeGAHAAABH@=q@@
AA!A"\A1A7\)A:\A,AffA
GA4A'
ABRA2{A+A5A6RA1GA=A8  A%GA  AA  A=qA
=qA
AQA33@\)Ap@\)@@  @@  @θR@@Q@33@R@33@  @@w
=@S33@O\)@~R@>{@@@o\)A-@zH@H@@@R@ۅ@\)AQAHA(A\)AAA/AEAc
=ApA=qAA(AAAəARAGAAA  AA  AGARA{A(A\AAT  @  @A\@=qAbffA?33AzAupA333ACAHAIA A;
=AlALQAipARA
AQAA\Ag
=Ag\)AR\A0(A"=qA'\)AT  A3
A(AA (A33A
RAQAffA33@\)@(@=q@@R@Q@z@(@x@y@
@vff@Q@dz@h@\(@:=q@i@Dz@r\@~R@@@p@\)@@@@G@ʏ\@θRA A\A$(A>ffAS33A[
AyA\)A\)AAzARARAA\A\)AAAQA{AAzAAffAzAA
=Ac
=Ac33ApA  @(AC33AH@  @A
H@{@\@@У@
=A1A'AEATA1GAAA5GA)pA(A%GAA  A@(@=qA@Q@(@p@Q@
@=q@@ff@p@=q@\@  @u@qG@@33@z@K@+@Mp@(@@@nR@=q@ff@(@33@W
=@9@9@^{@G
=@@@W@W@@R@@(A
A
=A\)ADzA=AH  AN=qA>ffAnRAmAEpAA(AWAAAHA
=AA=qARA}pAAAc33AK33At  AD  ABR@  @A@@k@޸R@~{@@z@@{@
=@R@@ff@@z@Q@HA@@AQAA	@@\@@
@=q@p@@(@R@@k@R@p  @{@33@@љ@ff@@@@ff@@p@dz@nR@j=q@1@b\@*=q@@nR@mp@H@\@A.ffAW33A@33A{AGA.RANffAg
=AxzA\AAA@@@(@
A (A$AHAAffAA(A@z@AQA)A4(A(z@
=@H@ff@w
=@i@H@  A=q@G@\@|(@&ff@%@@(@
@@@p@@p@@|@@@\(@[@W@?\)@K?\)?=q@(?33@\)@
H@.{@Mp@b\@zH@E@x@_\)@{@5?޸R@{@<(@c33@u@Dz@,(@;@.R@8Q@1G@33?@333@
=@	?\)?p?33@@1G@Dz@/\)@E@Mp@
=@Q@\@XQ@\)@@@{@θR@{A AzAQA"\A33A
@A@@@Q@Ϯ@\@w@vff@\@z@(@(@W@@*=q@ @@ @Dz@@(@33@>R@#
@
?ff?
?{?{@Q@z@ @ff@@ @G@
@\@R\@L(@-p@QG@XQ@=q@H@H@s
@E@^{@s33@;@O\)@/\)@S
@&ff@/\)@H@AG@H?\??\)@Q@@(@:H@p@hQ@q@Q@{@%@H@H@I@0  @E@,(@U@Q@H@b\@4z@e@p  @@@Å@  @ڏ\@G@G@@@  @@@@Q@ff@@p@vff@@P@B\@E@R@2\@@  @JH@\)@H@ @@G@L(@Q?
=@ @@(?33?@@   @{@@R@ff@
?{@G@R@
=@!G@{@\@33@@@@0@1@U@u@dz@`@ff@H@S
@G@Z=q@XQ@^{@x@9@   @\@AG@(@^R@ff@o\)@P  @1G@q@W
=@ZH?\)?p?@#33?@33@?޸R??У?@=q@/\)@@@z@'@$z@(@  @
=@33@(Q@/\)@5@7
=@Dz@G@Tz@0  @)@0@"\@@?Q@33?H@\?(@ ?Q?z??@   ??{?{?{?=q?
=?R?z@   ?@?p?z?
=@@   @	@
=q@Q@33@
=@Q@  @G?R@@#33@p@,@H@E@#
@G@
H@?Q@=q@@*H?33@\?{?\?z?(?(?p?\?\)?p????33?@z@1G@p@\)@\@G@Mp@J=q@_\)@P@Tz@]p@hQ@l@[@g@X@hQ@(@=q@
=@z@@=q@@zH@p@z=q@~{@l@aG@@  @5@9@<@8Q@9@?\)@G
=@G@7@6ff@6ff@>{@G
=@9@7
=@6ff@%@333@=p@9@%@$z@6ff@+@
=@
H@
p@
@@
=q@@{@@@p@G@@@@?R@@ff?\)?
???
?Ǯ?(@z@,@5@E@Tz@R\@
H@%@i@q@H@@@@G@@(AHA[A
R@(A&=qAA$A$A@G@G@@=q@@(@z@\)@
@R@
@R@@ff@@  ARA  AR@=q@  A\)@R@
=@
=@z@ڏ\@{A   A@QA>\@AXz@\)@\)@  @
@{@@\@@p@@  @@
@g
=@5@*H@2\@.R@XQ@z=q@`  @@\@{@$z@p@R@@=q@@@A\AYAB=B!ffBB\)ANRA@A(A\@q@@@H@ffAZ\@xQ@HAR\@@ff@
=@A QAUGAC33@33A\)@
@z@p@@  @@@z@(@\@@r\@u@q@\)@e@r\@Vff@Tz@Q@W@N{@NR@XQ@P@L(@N{@J=q@@@Fff@2\@:=q@:H@S33@U@7
=@,@'
=@'
=@   @!@%@-p@+@=q@   @Q@R@?p?(?\)?\)?@#33@@@,@9@8Q@=p@.R@3
@(Q@  @(??ٙ??(?p?{?(?\)?(@/\)@L(?p@@.R@Vff@R@=q@A.{@Q@@A
A\)A @<@3
@@^{@n{@Q@z@@R@k@c
@G
=@P@U@Q@P@P@S33@a@[@Vff@5@-p@*=q@0  @.R@,(@@  @c
@(@'@z@%@@Q@(@&ff@!G@!@  @\)@
=@@
p@ff@	@
H@
p@@@@=q?z@=q@,@<@P@J=q@;@=p@7@<@>R@AG@@%@4z@B\@p@ @'@@333?H?{@"\?G@s33@Q@~{ARAp@e@  BHRAzAAxA/AA|QA33A<Q@@@{AUAL@AF{@(@ @@@7
=@_\)@G@6ff@:=q@c
@=p@NR@Z=q@R\@1@8Q@;@6ff@QG@HQ@AG@A@@@:=q@p@.R@  @
@ff@#
@#33@"\@(@
@Q@{@ @G@z?Q?@\@
p?R??@ @\@
@   ?@ ?p@???\@   ??p@?\)@`@vff@  @NR@H@@mp@5@?H@e@=q???\)??\)?˅@"\@
=?  ?\)???{?R?@@G@\)@Z=q@dz@S
@$z@7@p@R@Q@@
p@
p@(@   @{@p@(@#
@z@@-p@)@?\)@XQ@?\)@6ff@@ @#33?H?\)@Q@   ?p?ٙ@@\@@R@??{?=q?\)@Q?R@@   @G@\?z?Q?Q??z??H?=q?=q?G?\)?p?\)?33?=q?
?Ǯ?\?@   @ @z??\?Q?\?\)??33@Q??=q?  ???Q?
=?p?z?@   @{@
=@@*=q@Q@Q?Q@@{@
=@@
=@G@ff@\)@%@!@4z@;@C33@W@U@e@XQ@c33@S
@Z=q@W
=@Mp@B\@6ff@*H@p@-p@Y@6ff@[@G@a@H@<(@Fff@7@)@'
=@#
@#33@(@#
@@+@JH@$z@.R@H@=q@ @ @R@!G@@G@{@	@@@ff@
H@
H@	@(@\@0@R@@'
=@@  @U@(@p@\)@\)@ff@{@G??(@Q@\@
=@@?@G@J=q@*=q@#33@*=q@-p@.R@Tz@\A&R@L@K@8Q@0  @?\)@J=q@>{@!G@.R@P  @  @\)@/\)@p@z@h@Q@w
=@mp@Q@L(@JH@|@~{@@@@W@;@A@NR@H@`@x@Vff@I@<@>R@(Q@(@
=@33@
H@@
=q@@?(?H@	@@\@
=q@ @
p?p?@   @Q@@@@G?R?@\@Q@33@R@%@'@(Q@C
@P  @_\)@aG@  @
@\@{@ff@Å@33A{@
=@z@A\@\)@R@@@33@z=q@ٙ@@U@U@k@qG@aG@aG@]p@a@x@~R@l(@`@L@x@Vff@L@Fff@E@C33@8Q@7@  @(@ff@;@,(@.{@8@>{@.{@(@{@R@333@,@/\)@!G@H@7
=@!@4z@333@@@Fff@&ff@0  @0@*=q@P@I@:=q@!G@@	@@
?@@
p@@@G?Q@   @Q@G@(@@!G@'
=@#33@G@(@@@@??R@@z@
=@@g
=@G@  @@\)A>RAH(A
HAzA33A(@C33@(@H@@\)@@33@z@\@  @=q@`  @
@Q@x@\@^R@=q@nR@@  @θR@Q@|@@@ff@@{@@p@z@jH@B\@;@HQ@h@c33@g@=p@X@;@&ff@@G@\@   @@
=q@Q?(?@G?@
@"\@@H@*=q@/\)@@@9@@\(@H@5@QG@AG@@@Tz@w
=@hQ@8@
p@Dz@?ٙ@G@:H@	@H@
@z@S
@)@:H@dz@G
=@E@^R@jH@@@|(@G@w@w
=@~R@r\@o\)@~R@G@@\)@QA@\)@Å@A@@\@H@@Q@\)@
=@ff@Q@AA  Ap@  @
=@a@\)@}p@U@S33@p  @4z@Q@w
=@w
=@[@S33@@H@u@K@n{@}p@@mp@@
=@@R@@H@fff@@  @G
=@Dz@E@E@3
@>{@C
@HQ@L(@7
=@AG@x@tzA33@Mp@G@dz@nR@R\@Y@}p@c
@jH@Tz@a@Q@C33@S
@o\)@w@p@mp@l(@~{@Q@\)@\)@@\@@@@@  @@
=@(@Ǯ@@޸R@{@޸R@z@@@  @@(@z@z@\@\@qG@G@(@
@@@  @\)@@\)@@\@hQ@aG@H@L(@:=q@a@e@@@@@@z@(@ff@{@{@@Q@{@{@33@R@@
=@u@zH@z=q@u@h@mp@h@Q@w
=@=q@nR@(@^R@2\@>{@(@O\)@`@A@0  @@"\@$z@'@,@'
=@333@333@E@8@y@H@@@@Ǯ@@
=@׮@У@(ApAGA
ffA(AzA
{@\A33A(A33AAAAzAHA   A\@z@
=@ff@G@@z@\)@@H@\@@@
=@ff@p@@@ff@
@p@@@@=q@
@@ff@Q@H@
=@G@@@R@@p@Q@=q@=q@33@(@Q@  @@j=q@w@S33@U@Y@\(@E@jH@l(@1G@J=q@B\@E@P@Tz@K@Y@(@\@@e@ @R@'@Y@k@j=q@s
@\)@ff@@@  @@Ϯ@z@(@A(AAffA1A(  A2{A@@
@Å@H@@@{@@@33@H@33@  @@@@{@Q@(@`  @mp@W@=q@^{@@{@@@@@@x@H@ȣ@@\@y@R@R@@@z@
=@z@=q@p@@\@@=q@@@r\@n{@|@{@G@{@r\@@
=@k@h@1@=q@|@`@I@AG@3
@%@Tz@b\@  @\)AH@@@\(@\)@\@p@{@\@@A-A*=qA
=A3
=AB=qA_
=A`  AH(A?A\AFHA!pA=qA AA\A(@@{@Q@ff@=q@{@@@@  @33@@\)@(@@G@z@G@@z@@
@\)@qG@l@g@p  @U@{@{@@p@
@{@33@Å@
=@o\)@{@r\@e@nR@N{@C
@O\)@a@dz@q@a@l(@.{@J=q@g
=@P  @Tz@P  @P  @p  @E@:H@@  @z@
@ff@@@=q@  @@pA Q@\A%A6ff@pARABffA
=A;
AG
=AdQAkAR\AqAAlAMpAiAvRA_A,QA%A*ffA\)AAAA\)@A@\@ff@p@@@=q@@@G@@
=@p@@\)@  @  @ff@p@z@
=@  @{@r\@33@
=@p@ff@ff@=q@@\@ff@H@\)@@Q@Q@@@=q@\)@
@@Q@G@@ff@R@@@@@Q@@z@@
@33@@G@
@
=@R@  @@R@33@@33@ff@p@\)@@H@p@\@
@@\@@G@H@H@33@@@R@@R@ff@R@Q@Q@{@w
=@{@vff@~{@|(@u@nR@k@p  @j=q@g@_\)@g@hQ@`  @hQ@aG@^R@a@ZH@Y@^{@\@^R@c33@c
@\(@aG@^R@_\)@W@[@^R@\@Vff@R\@Z=q@X@Vff@W@Vff@S33@S33@W@JH@J=q@N{@C33@Fff@I@C
@>R@J=q@Fff@?\)@;@<@<(@8@3
@:=q@7
=@2\@1G@>{@Q@\(@=q@33@AA@\)AH@c
@g
=@H@@R@]p@aG@a@Dz@&ff@/\)@.R@0@[@g@W
=@C33@@  @A@7@<(@333@9@.R@1G@-p@#
@.{@ @(Q@"\@   @(Q@   @'@'@!G@%@   @*=q@!G@R@ff@@Q@\@R@33@@@@
@ff?R@ @33@@	?(@\@@@
=@
H@@@G@	@G@ @@HQ@R\@ZHA`QARAA7
A8Q@xQ@r\@JH@I@@r\@{@(@@L@O\)@@pAJ\A(A#33?z?\)?
A6\@Vff??\)?=q?=q?У??R?
??  ??\?=q?Q?z?p?p??Ǯ?G?\)?z?z?H??Q?ff?p?p?G????{?
??
??  ?H??{?p?(??  ?ff?\?\?p??
=?
=???\)?H?33??G????{???p?Ǯ?G@5@6ff?@
p?H?\)?H??  ?@#
@C
@@EAGAA\AL(AAHA:H@A/
=@@}p@A@Fff@O\)@@??Ǯ??{?Q?޸R?R@@z@=q@@
=@&ff@(Q@'@5@@@
H@\)@@\@R@@{@
p@
@
=?@Q@
=@\?R@
=@
=@{@@@	@@\@@@@33@
@@z@
=q@@z@\??{?{@G@ @G@??R@!@.R@`@   @2\@E@)@QG@z@?p@G@?ff??ٙ?z@z??
=@33@@
=q@\)@\?
=?H@$z?  ?ٙ?\)?Q???R@	@\@??ff@z@@ @ff?p@
@
=?33??H?\)?У?޸R?޸R????޸R?p?ff?(?
?{?У?\)?  ?  ?\?\)??  ?
=?{?=q?˅?Ǯ?p???H??????ff?{?G?H?Ǯ??У?ff?\?
=?ff?ff?{?(??(?Q?G??ff?{?Q?33??G??G??ff?(?\???=q?@=q?=q@?Q?z?
=??G??G?H?{??33?(@{@'
=@q@\)@@R@ff@@Q@@@$z@ff@AG@9@{@c33@b\@y@p  @N{@W@E@>{@333@<@.R@$z@ @ @.R@.{@*=q@
=q@@+@8Q@1G@(@,(@,(@"\@%@@@!G?H?@G?  ??p?33?{??@
H????  ?\)?H?R?zH?p?(?ff?  ???Q?R?z?Q?  ?(?H?
?{?(?(@@+@QG@H@?\)@ZH@L(@P@dz@\@ff@@@@H@@p@`@o\)@n{@33@G@p@p@~R@H@  @@\)@33@=q@33@z@@\@@
@p@QG@S33@y@@33@Z=q@H@p@mp@w
=@H@\)@aG@*H@/\)@,(@Tz@?\)@Fff@\)@\)@'@2\@6ff@*H@@\)@
=q@N{@0@@@g@-p@  @U@\@hQ@[@ff@  @H@=q@a@G
=@   ??\)@33@ff@)@1G@fff@
=@@@33@@\@\)A@AQA(@Q@A@@{@\)A	GA@\)@{@p@QA(A!GA  AAQA @G@@ə@H@ff@Q@H@  A=q@@ۅ@{@
=@
@Q@{@
=@@@z@s33@  @p@H@\)@
=@G@@{@^{@ZH@fff@NR@/\)@333@+@7
=@3
@K@:=q@G
=@@ @.R@G
=@G@_\)@NR@!G@@@P@.R@33@33@@@   ??H@
H?(@(@
=q@0  @=q@@:H@O\)@
@
=@R@@\@Q@\@=q@w@:=q@^R@8Q@{@1G@j=q@u@@@H@Q@{@s
@~R@@|(@@
@
=@K@<(@s33@z=q@C33@/\)@  @H@|(@@
@p@(@|(@z=q@qG@\@]p@HQ@=q@ff@(Q@ff@!G@@@z@0  @H@G@@   @@1@"\@.{@(@   @#
@!G@@   @9@Z=q@dz@E@33?R@	@@@  @]p@?\)@0@\@??=q@\?ff?
=?(?  ?\?H?\?Q?33??z@@
p@=q@>{@+@:=q@E@Y@X@fff@l@qG@tz@zH@x@R@Q@|@~R@k@Q@\@_\)@W@:H@6ff@:H@,(@'@{@#
@z@ff@*=q@#
@#33@3
@,@333@4z@*H@ @%@&ff@   @@
=@33@Q@	@R@@,(@@\)@@R@
@Q@(@(Q@-p@7@(Q@G
=@H?33@
p@33@?(?H??
??˅?Ǯ?G?\)????R???(??=q??33?  ?G?\?G?G@33@#33@J=q@ZH@Z=q@Vff@Q@H@\@b\@tz@A@:H@U@Q@xQ@@G@@g
=@l@G@E@NR@ZH@O\)@9@333@1G@1G@5@L(@p@@
=@$z@@@@(@=q@@@?p@
H@@@@z@
@	@(?=q??33?
=?p?\?У?{???\)?
?@ @   @@@333@E@8Q@>{@@
=q@   @&ff?G?  @S
@0?
=@
=q?ٙ?\)@\?\)??Ǯ?У?z@??\)??z?@@C
@S
@S33@h@\)@Q@e@w
=@|@\@@H@@@@
=@R@\@\@@@@\)@33@hQ@i@E@I@H@&ff@6ff@C
@L@7
=@:=q@5@3
@\)@$z@333@<(@:=q@:H@<(@1G@<(@8Q@!G@*H@Q@	@@-p@!@@{?\@@\@
=q@z@#33@@@.{@=q@  @33@@
=q@
=@%@p@!G@@@  @?޸R?R@   ?H@\)?R?\?Q?=q?Ǯ?p??Q@ ?{@   @{@$z@=q@333@.{@L(@7
=@C
@e@I@C
@u@E@fff@QG@z@]p@6ff@  @fff@p@@p@
@{@Q@R@\)@`  @Q@i@g@tz@h@o\)@w@{@u@tz@vff@jH@W@nR@p  @aG@P@W@E@K@C
@B\@JH@G
=@G@L(@Mp@Q@I@W@P  @;@L(@J=q@7@7@3
@)@.R@<(@<@P@u@  @q@Tz@O\)@7
=@U@8@-p@'
=@33@@ @R?z?ff?\)???p??=q?ff?\)??z?{??@E@AG@JH@33@@\)@jH@qG@c
@@(@R@@@mp@S33@Tz@Fff@<@aG@`@P@J=q@G@?\)@6ff@@  @,@(Q@ff@33@@
=@@
=?\@
@Q?ff@ff@Q@	@R@@
=@@\????{??У??G?33?\?\???  @?z?33@@Q@33?H@?{?z??޸R@
p?  ?
?
=?  ?z??{?H?{?G?(?p?Q?H?H?Q?p?p?p@   @@   @@4z@2\@I@
@Y@J=q@AG@ @R\@g@U@>R@,@?{?Q@5@@#33@ @  @\?@\)@{?=q?G?z?
???
?R?=q?=q??{?{??z??
?(??У?ff?˅?У?˅??\?
?˅??H?\)?Ǯ??У???z?{?{@   @Q???33?z??@G@R@'@w
=@@dz?@G????ٙ?  ?ٙ@H@R?@(@6ff@4z@O\)@1@Q?33@\@@	@G@=q@@  @@   @H@   @33?R@H@#33@@?R?p@?@\?33??@   @ff@@@   ?R?{??\)?Q?H@33@\?@ff@G???Q?
=??ff?У?У?
=?=q?Ǯ??\)???У??{?ٙ?=q?33??˅?\?p?H?{??R?{?p?Q?ff?{?ff???\)????У?33?H?@G@
H?@?
=?p?޸R@@ ?\?@G@@33@=q@*=q@"\@!G@5@:H@Mp@HQ@.{@8@'
=@@G@
@@@33@ff??=q?=q?33?R?33?{?H?z?ٙ?{?
=?Ǯ?\?G?Q?
=@?Q??R@ @??{?=q?=q??\?(?
=?
?
?(?(?z??У?H?p?
?\?˅?ff?@z@z@H??ff?R@@{?޸R??  ?=q?k?
=?=q?{?p?Q?  ?Ǯ?h?ff?Q?ff?H?{?(?\@   @   @ @@p@%@#33@ @%@(@+@5@*H@0@5@,(@C
@=p@1G@<(@0  @z@\)@'@
=q?
?
?R?Q?@33@?
=@Q@?H@
@R?\)?@R\@a@!G@;@@(@\)?H??\??
=?(?p@(@#
@G@@@c33@<@aG@g@C
@
=q@=p@>{@tz@ᙚ@X@  @J=q@ ?\??ff?k?\?=p?  ?z?ff@   @R@{@@QAK\)ARR@zAz@y@Vff@fff@Q@Q@=p@A@6ff@=p@qG@[@dz@c33@Dz@c
@+@k@Fff@8Q@hQ@w@{@c33@S
@@o\)@b\@  A:=q@=q@\@{@G@A@\)@@Q@w
=@@g@|(@=q@ff@dz@G@@c
@k@}p@33@@a@R@pA~R@zA{Az=qA$Q@A@׮@zA7\)@R@\)@APQ@@nRAQ@
=@=q@u@_\)@<(@ᙚ@aG@[@]p@K@e@Tz@XQ@:=q@E@x@n{@~R@>{???{@4z@W
=@o\)@W@1?p?{?@R@@33@R@#
@Dz@B\@A@E@C
@JH@l@[@nR@s
@h@e@H@]p@\(@Tz@5@G@#33@>{@:H@L(@JH@G
=@C33@XQ@GA9@/\)@H@Q@p@E@{@
@@@C
@Fff@@ff@z@Q@@(@l@0@E@4z@<@@  @^R@p@qG@z@I@z@p  @8@XQ@nR@
=@@@@GA\AC
=AJ=qA=qA33A[A@
=@|(@|@r\@@G@>R@   @AG@3
@=p@   ?=q?
=?R@Å@@@*H@\@u@ff@{@|@|@z=q@nR@  @{@z@@@xQ@8Q@(@@
=q@%@Y@_\)@R\@>R@U@|@@@R@陚@(A Q@
=A&R@HA@  A\)@p@33@@ff@}p@g
=@@p@l(@`  @u@xQ@^R@\@a@5@vff@A3
=AeAC
@@{@@@ۅAzA
=AE@
=AepA_33@@33A@HA3\)@z@A*{@
=A-ArR@@GAH@{A0AA8Q@@
=@yAffA\AAV{AG33@
=@ApAHAf\A+33A%G@Q@A
=@B\?
@I@5@?\@.{@7
=@H@@)@(@R@p@@b\@w@
ApAAA@(@s33@S
@a@;@G@ff@:=q@   @\@#
@(@ ?(@
=@@k@n{@n{@3
@Tz@Dz@U@j=q@U@#
@H@@P  @`  @W@g
=@@~{@	?\?@  @\)@'@1@?@
@@@!G@7
=@>{@
=@ff??33?ff?Q??ٙ@
@\)@0  @=q@2\@fff@[@~{@6ff@@E@NR@\)@,(@ff@,@"\@%@J=q@-p@2\@E@E@-p@ @G@ ?p@@@ @Q@\(@>R@R@(@N{@qG@@'
=@H@`@"\?@@=q@Tz@aG@s
@@G@G@\)AZ\@@@(A@@33@  @  @aG@\@R@G@:=qA$  A%AY@mp@U@@ApAA?33A@AzA<Q@@Z=qAQ@p@@{A!pA8QA3A@
@|(@@1@hQA*{Az@@@q@*H@\)@??z@\)@7
=?z@@YA@S33@@  @Fff@:=q@<@&ff@\)@@
=q@Q@   ??\?ff?@???z@   @p@	?R?  ??
?Q?=q@1G@
=@.R@@  @(Q@\)@"\@  @+@@@N{@5@U@\)@@љ@w@U@L(@a@@|@p  @p@A@ffAO@H@P  AqA&{A@zAEABH@{A
=A{A]Ao\)@  A33A'A-@ff@/\)@S33@4z@H@r\@\(@vff@
=A=qAAdA@@ᙚ@ff@>R@W
=@@33@)@g@nR@Q@A#@@)@??G?У??{?޸R?\@)@QAApA\)AGARA\)AAҸRARAQA33AEGAdQAffA33@
AW33A@AyG@Q@A7A
@Å@p@@@33AAaA=qAzAA
A=qAAA(AGAA  ABB
B:ffB(A{BpAHApA+\)@A-pAffA@ƸR@@~{A6RA
G@
Aģ@p?=q??  ??=q@@ҏ\@0  @{@>{@^{@Tz@AGAz@  @g
=@zAVff@{@E@@@Q@33?\?\)?Q?{?˅?޸R?
?(?\?G?(?=q?{?
=?У?z?=q?(??\)?=q??(??Ǯ?33?@
p@|@ZH@]p?Q?p?z?  ?  ??
???\)@\@
=@33@33@ff@
=?{@33@ @)@=p@u@Y@:=q@>{@zH@=q@W@g
=@
@dz@@{A@c
@x@@@@|@mp@=q@@\(@A)AC\)A
A
A@  @@@(@@Q@@q@y@~{@u@s33@mp@zH@s
@p@w
=@s
@w
=@c
@\(@\(@^R@l@@Q@@a@ffA@ڏ\A@=q@\)@@RA Q@z@\(@
=@  @@(@@
=@mp@q@33@@n{@@~{@@hQ@l(@mp@@33@z@(@z@H@@p@\@(@  @p  @z@=q@QA	GAA(@
=AA=q@\)@AffA[A>=qAzA_\)ApAQA2HA  @R@@ffAAT  @(Af=qA^HA]A<AHA@  @   @
=@5@z=q@r\@|@N{@[@QG@i@Q@Z=q@I@}p@mp@~{@s
@jH@W@j=q@S
@H@0@%@*H@+@p@(@-p@`  @C33@r\@G@\)@  @*=q@\@/\)@+@{@6ff@Fff@;@<@@G??@$z@=p@^R@g
=@\)@@{@@\@o\)@   @(@@@G@A_
@\@=qAg\)@G@mp@dzAG
=@@Mp@
@G@@A33@R@z@@GA@QA  @@@G@HAp(A-pAPAAAz{@Q@L??G?
=?R@@!G@!G@ ?p@
p??
?
?=q?
=?{?˅?Q??  ???(?p?33??˅?H?(?\)??R?
=?(?ff??33?p?33??=q?ff?=q?Ǯ?ff?p?\??33?ff?p@
@ff?z?޸R?R?z??
=@@+@|(@ȣ@@33@@hQ@r\@U@Q@
@>{@p@jH@b\@@@E@\@N{@JH@U@qG@˅@@33@z@_\)?
=@
@   ???
=??Q@   ??z@G@(@  @@@(@ @G@@@R?ff?p?Q?
=??p?R?H@ ??p??G?G?\)?H@@!@ @(@33@4z@8@Tz@7
=@0@33@
=q@	@z@???Q?R?(?Q?ff@@33?R@@@!G@g
=@GA/33A\)AA=qA(@33@G
=@%@?\)@@??޸R?p??޸R?
?z?У?=q?H?p?H??Q?{@   @G?@@~{@(@G@b\@zH@@   @@3
@Fff@aG@\@
@Q@@@y@e@_\)@hQ@l(@j=q@l(@@=q@l(@e@U@A@J=q@2\@=p@8Q@8@Vff@.R@@  @1@Dz@W@  @P@U@;@L@Fff@J=q@1G@C33@L@G
=@333@S
@XQ@C
@tz@Vff@R\@QG@mp@c33@p@e@@ffA8@AX(@׮A\A$A@
@@Q@S
@z@@@@7
=@=q@ff@?=q?(@(@@
p@p@@R@ff@
=@e@=q@R@
AGApA?
A<zA
=AO\)A@@\)@HA  A@\@ə@=q@(@=q@z@s
@ff@{@r\@u@n{@=q@K@s33@^R@A(@@.R@J=q@@ff@b\@G
=@`@<(@1G@E@W
=@a@Q@L(@(@ @$z@@@@Fff@:=q@1G@;@"\@%@@&ff@!G@*H@B\@^{@S
@mp@j=q@@c33@@@s
@@@@
@(@Q@p@u@@0?{@8Q@&ff@>{@AG@(@S33@^{@!@@   @(Q@hQ@@p@{@@  @@@ff@ffAn\Au@H@J=q@Z=q@>{@NR@A@
@%@$z@{@Q@(Q@ @*H@8Q@\)@
=@.{@QG@P@G@{@O\)@Vff@a@`  @3
@HQ@S33@Vff@Z=q@^R@c33@S
@AG@@@1G@.{@Mp@\(@@l(@p@^{@L@.{@R@)@8Q@&ff?R@*H@33@@1G@Vff@3
@G@E@E@9@C33@1@
p@@E@p  @y@JH@@  @(@@@   @   @z@@@
=@#33@(@1@(Q@+@@  @Mp@mp@^{@z@j=q@G@L???\)@   @@{@
=q@R@??\?
@
=@R@
=?ٙ?\?˅?(?p@
=@?(@ff@?@	?@)@j=q@Q@@H@@g
=@R\@L(@[@@@NR@?\)@?\)@L(@"\@4z@)@7
=@
H?
?33??˅?=q??@??Ǯ?
??@33?  @E@R@#33@5@HQ@5@Q@w
=@^{@Z=q@S33@6ff@9@?p?{?  ??G@33@?R@R@@
=q@+@ @]p@hQ@H@w
=@@}p@ff@@
=@
=@g@Vff@G@
=@\)@tz@o\)@Z=q@]p@u@p@s
@L(@mp@^{@0@I@.R@(Q@7
=@K@aG@>R@U@@  @AG@C33@B\@#
@:H@B\@4z@/\)@,(@,@.{@2\@"\@,(@%@ @$z@@Q@@G@\)@  @@G@z@@%@G@\)@@@'@G
=@,(@p@5@5@3
@.{@a@n{@G@p@Y@i@@qG@]p@o\)@jH@@p@ҏ\@@z@@A
@(@
=@@
@\@c
@z@  @\@7
=@u@@@@|(@=q@\)@@@ff@@p@NR@dz@,@=p@XQ@Mp@>R@@8Q@?\)@Mp@G@Dz@E@S33@P@9@@@aG@NR@L(@=p@>R@.{@E@7
=@(@   @z@33@ff@R@@
=q@ff@@ff@ ?33?????Q@   ?33?R@G??33@G?Q?@
p??p?\)@@ff@@33@\@?(?@?33@@R@8Q@7
=@G
=@N{@Y@Vff@$z@:=q@>R@W
=@|@S
@@z@ff@@=q@@@@@@@
=@(@(@@q@AG@.R@*H@7
=@/\)@2\@%@0  @"\?H@G@(@(@%@z@@{@H@H@Q@Q@
@{@&ff@z@
=@?33?\)@
?@33@Q@G??H?Q?ff?33?{??
?˅?У?{?У??33@?@Fff?@'
=?33??ff??H@@@@\)@@  @@@Y@'@O\)@@Q@
=@Q@
=Az@R\@A#33@@e@U@Dz@9@5@b\@.R@HQ@S
@@vff@]p@w
=@P  @,(@C33@e@jH@NR@E@+@&ff@
H@\@	@\?@
@\)@  @\@33@@=q@@@ff@@
=@ @@{@
=q@@R@@%@!@,@%@:=q@0  @+@
=@33@z@R@.{@6ff@>{@`  @@XQ@@c
APQA33AffA=GAEpA9@(QAy@@	@=q@
=@5@2\@	?33?{?R?˅?@??@
=@Q@
@(@@+@/\)@)@{@1@  @@R@p  @<(@`@mp@H@@ff@@g@\(@L@\(@a@G@@{@U@%@XQ@k@_\)@HQ@J=q@/\)@6ff@z@7
=@dz@Mp@+@ @1G@5@<(@7
=@*=q@p@*H@0@/\)@@#
@@=q@"\@Q@z@%@Q@@@@@33@33?@Q@"\@*=q@7@NR@nR@jH@\@\)@Q@|?=q@(@R@\@)@5@  @@vff@,@33?(@G@   ARA=qAA
A	A	A
=qA(A
=A
AA@{@Ӆ@@p@@z@z@=q@p@Q@Ӆ@@{@\)@
=@
=@ff@
=@{@
=@
=@߮@߮@\)@@@@ָR@@@\)@@{@ff@{@׮@\)@ָR@{@@z@H@@ȣ@@H@\)@G@@ƸR@@@Å@
=@R@@\@Q@\@=q@33@Å@p@z@Ǯ@Q@@G@@=q@=q@@z@=q@33@  @Q@ff@ff@@33@=q@@@\@z@(@@Ǯ@=q@˅@ə@Ǯ@Å@@@@
=@p@\)@(@{@ָR@33@޸R@z@@Q@ff@p@@p@p@p@ff@׮@׮@أ@@ڏ\@
@H@Q@\)@  @ٙ@G@@=q@@(@ڏ\@ٙ@@ٙ@@G@\)@Q@\)@\)@ff@
=@׮@\)@\)@  @{@\)@\)@\)@@{@
=@
=@@z@Ӆ@ҏ\@33@@33@Ӆ@Ӆ@z@
@@@z@=q@(@Ӆ@љ@љ@Q@@p@
=@˅@
=@Ϯ@Ӆ@ҏ\@@@\)@ָR@ff@{@@p@@z@z@
@@
=@Q@@ָR@ff@ָR@@ڏ\@33@ۅ@z@z@@p@@@޸R@
=@
=@޸R@
=@
=@
=@
=@߮@@z@z@@@@
@
@@p@@@p@p@p@@@ff@p@z@(@
@=q@=q@=q@ٙ@ٙ@أ@׮@33@p@@ٙ@
=@@(@H@ٙ@=q@׮@@G@H@ۅ@(@@33@33@@׮@أ@ָR@@@H@33@p@@{@@@z@H@أ@ff@p@ff@
=@33@
@ۅ@@@(@@
@
@ᙚ@@@@p@@@@z@=q@@Q@z@\@@=q@@H@  @ᙚ@ff@\)@Q@
=@p@@{@p@@z@
@H@ٙ@@ٙ@@@=q@@G@G@أ@G@33@ڏ\@ٙ@ڏ\@ٙ@@Q@33@׮@@z@(@33@=q@G@  @ָR@@33@  @
@
=@@@@\)@@@У@ff@ff@  @  @=q@
@
@ff@Q@ٙ@
=@{@@33@@33@H@H@33@
@(@H@=q@{@
@z@@@p@ff@\@\@Q@  @@陚@\@@@=q@@G@ff@@(@@33@@@Q@Q@  @{@
=@@(@@@=q@33@\@
@@ff@ᙚ@33@33@H@@@@33@
@
@ᙚ@33@@@\)@G@H@G@@@=q@@Q@  @{@\)@
=@{@Q@ff@  @@޸R@@p@  @(@\)@\)@Q@@ff@{@
=@\)@(@@@@G@@@=q@@z@p@p@@Q@@陚@G@H@@
=@p@\)@=q@z@G@@
@@\@ᙚ@ff@߮@  @ff@ff@=q@@ٙ@޸R@Q@=q@ᙚ@ᙚ@@@@G@=q@\@=q@@
=@@33@@Q@@@@@(@
@ڏ\@z@  @ָR@ٙ@=q@G@ڏ\@33@(@@z@(@ڏ\@ڏ\@
=@Q@=q@  @z@=q@@@߮@@  @z@@
=@@z@\)@@ڏ\@H@
@H@  @  @׮@
=@Q@أ@=q@H@@@ڏ\@ڏ\@
@ff@@  @H@
@(@@
@33@G@@(@ۅ@ۅ@ۅ@ۅ@G@׮@@H@ڏ\@33@(@H@=q@@@z@H@(@33@ۅ@H@33@ٙ@ۅ@أ@Q@@=q@Q@׮@=q@G@\)@@{@\)@@G@Q@أ@@\)@
=@أ@أ@Q@ۅ@(@@ff@@ڏ\@ۅ@\)@33@(@p@@
=@Q@Q@ᙚ@Q@Q@H@޸R@@33@
@ff@z@@33@ڏ\@=q@ۅ@33@ۅ@@@ᙚ@H@@@R@
=@  @@H@=q@\@陚@陚@陚@@@R@{@(@@@H@=q@ᙚ@=q@ᙚ@ff@
=@@ٙ@33@@أ@
=@أ@ָR@׮@@ڏ\@(@=q@@@@=q@=q@p@
=@
=@
=@ff@z@=q@Q@ff@Q@
=@  @\)@\)@Q@Q@G@@@@أ@أ@@@ٙ@\)@׮@أ@p@@ָR@׮@G@ۅ@
=@
=@@G@ᙚ@33@@@
=@@{@  @ff@  @@@@@@=q@ᙚ@@R@
=@
=@\)@@\)@Q@ff@@z@R@
=@@@p@{@@{@33@(@
@p@(@=q@\@@\@ᙚ@{@\)@@ָR@{@Q@أ@G@G@H@=q@ڏ\@\)@33@  @  @Q@\)@
=@H@=q@G@
@@У@  @p@Q@޸R@׮@ָR@(@H@33@z@ۅ@@@
=@\)@߮@  @p@ff@أ@أ@@ٙ@ff@߮@G@
@\@
@
@
@33@\@Q@G@G@@
=@ff@
=@@߮@@=q@\@=q@p@33@z@R@ff@\@@(@
=@߮@p@߮@@޸R@@G@p@  @׮@=q@{@ff@أ@ۅ@
=@H@=q@
@˅@  @@(@љ@z@أ@@G@ۅ@@\@߮@޸R@p@{@
@@@33@33@ڏ\@H@ۅ@
@H@=q@H@
@@@߮@\)@
=@޸R@H@߮@@Q@@@z@@@  @@(@߮@
=@\)@=q@@\@@
@@ff@Q@R@G@33@33@R@ff@ff@ff@@  @  @ᙚ@@{@@33@H@@@
@@@{@@@p@H@G@ۅ@\)@\@ᙚ@
@\)@(@p@z@
@33@H@@\@=q@@@z@أ@@p@޸R@@{@(@@ڏ\@33@ۅ@@z@  @G@p@ʏ\@(@\)@أ@(@\)@Q@߮@\@ff@\)@
@
@{@ff@R@@Q@
=@@R@{@H@H@ᙚ@陚@p@=q@@(@@@@33@33@
@z@p@R@R@R@\)@@@@G@@@@@@@Q@z@33@@z@陚@=q@H@@Q@@\)@R@{@ff@@z@@@
@@=q@@ᙚ@@(@\@ᙚ@H@  @Q@@\@@
@
@  @ff@@
@@(@
@@(@@ᙚ@@  @  @ff@G@G@@@Ӆ@@=q@\)@33@ٙ@\)@(@(@{@p@@\@ᙚ@33@ff@陚@@=q@33@33@
@33@(@33@H@H@H@@\@=q@=q@=q@p@H@(@
@33@H@H@H@H@33@=q@@@Q@H@ff@
=@@@@ff@@@p@p@@ff@R@@@Q@  @  @@@R@@{@(@޸R@@@@
=@H@Q@@=q@أ@
@
@33@Q@׮@@\)@@G@  @\)@(@=q@@(@@
@
@33@=q@@=q@(@@ۅ@@33@@z@p@@p@p@{@ff@R@R@@Q@Q@@Q@  @\)@\)@@z@H@(@G@ff@ᙚ@=q@@߮@
=@(@@{@
=@{@@@ۅ@p@@
=@@=q@ᙚ@
=@߮@H@33@
@ۅ@߮@Q@=q@p@@=q@ڏ\@ۅ@(@ۅ@(@@(@ٙ@G@@  @ff@\)@ָR@ָR@H@љ@@
@@@
=@\)@׮@Q@=q@33@
=@@ff@ָR@ff@ҏ\@  @Q@أ@@33@@@p@ff@ff@޸R@\)@G@33@H@
@@p@p@p@@{@\)@\)@\)@
=@@  @  @@@@
@Q@\@\)@޸R@@(@33@ٙ@{@ff@@@@Q@{@=q@{@  @@
@@
@@(@(@(@z@@ᙚ@\@\@\)@\@G@\@ᙚ@=q@\@߮@{@G@G@ٙ@ٙ@أ@=q@
=@ff@
=@{@(@p@\)@
=@׮@أ@@@@=q@ۅ@أ@
=@׮@  @Q@
=@أ@  @Q@أ@z@@ff@\)@  @G@@G@ᙚ@G@@\)@߮@@@ᙚ@@@@G@G@  @G@@@@ᙚ@@\@=q@=q@=q@=q@H@@@G@ᙚ@@G@=q@@@@@G@@=q@G@G@\)@\@@G@{@\)@{@
@H@ٙ@ٙ@=q@ڏ\@@ڏ\@z@@ff@{@߮@ff@p@@
@ۅ@z@Q@{@\)@@p@{@ff@@@@z@@z@
@ۅ@z@@@\)@Q@G@ᙚ@=q@@@ᙚ@ᙚ@ᙚ@@@\@=q@\@@@=q@\@\@=q@=q@\@\@H@H@=q@@Q@\)@߮@  @  @@ᙚ@G@G@@Q@Q@Q@Q@Q@Q@Q@@Q@@Q@@\)@
=@
=@ff@ff@  @p@@@@@@@@@p@@{@{@@p@@@p@@@@
=@޸R@ff@߮@Q@ff@\)@@z@p@z@(@z@33@\@ᙚ@@ff@@
@޸R@H@@G@@=q@@@33@33@@(@@p@p@@@ff@ff@{@R@ff@ff@@  @Q@@\)@ff@z@@z@@@p@@(@(@@
@(@@@33@
@33@33@@@=q@\@=q@H@H@H@H@\@H@H@H@H@\@H@H@H@33@H@\@\@=q@=q@=q@\@\@\@޸R@  @@G@p@\)@@޸R@\)@@\)@@z@R@ff@{@
=@
=@33@
@@33@G@@\)@
=@R@R@R@
=@R@
=@\)@Q@@G@=q@@@\@H@33@=q@G@=q@Q@@  @  @@\)@R@R@
=@ff@
=@
=@R@ff@
=@@\)@@ff@R@ff@ff@@@@@@@(@(@@p@@@@{@z@@@{@ff@@z@@{@p@@
@H@
@
@
@@
@(@z@z@p@p@@\)@ᙚ@
@@=q@p@
=@=q@@@@R@H@@  @\)@ff@@Q@@@@
@@
@ff@R@G@Q@G@H@(@\@G@@
=@\)@\)@
=@
=@R@ff@ff@{@{@p@@@@@(@(@
@H@H@=q@陚@@\)@\)@R@\)@\)@\)@@\)@R@  @@Q@陚@=q@{@z@(@(@
@@@{@@\@@@@@H@z@(@@p@ff@
@\)@
@@߮@H@(@
@ff@@
=@@=q@=q@33@@  @@@@陚@=q@H@
@@p@{@@R@Q@@Q@@@@H@=q@@  @
=@
=@ff@G@Q@p@Q@Q@{@@=q@  @33@H@33@陚@陚@@ff@R@R@Q@Q@@p@=q@@@\@@@@z@p@\@{@=q@H@
=@
=@@@ff@
=@ff@@@@p@@=q@
@@z@(@\@(@p@@@@ff@\)@{@  @@陚@=q@@@H@G@=q@@(@p@\)@R@  @@@=q@33@H@H@@(@(@{@R@(@\)@@Q@@Q@@@@p@@R@@@R@\)@@  @@@\@@@@R@@@33@G@=q@\)@Q@p@ff@@33@{@{@@@{@
@(@33@H@=q@@
@G@@(@{@(@  @@陚@@@@@  @@Q@@Q@@@ff@  @G@@G@=q@  @p@(@(@Q@R@z@\)@@@  @  @ff@
=@  @@\)@@@33@(@@(@@@@@@
@@陚@  @陚@G@=q@=q@\@陚@\@G@=q@\@H@@@33@\@\@G@@33@Q@
=@\)@{@
@陚@@{@  @G@=q@  @\)@p@@{@z@ff@ff@@@@=q@\@33@\@@
=@Q@
=@{@@\@@R@Q@@@Q@@@=q@@\@\)@@@@@z@{@Q@
=@R@R@\)@
=@G@@@p@{@R@@\)@R@ff@R@ff@ff@
=@R@
=@R@G@{@@@p@@@@@p@@@@@@R@ff@{@{@
@p@\)@
=@\)@
=@
=@R@R@\)@@@@@@@@@@@Q@
=@=q@\@
@=q@H@\@@@
@
@@
=@p@@@Q@
@޸R@z@׮@ҏ\@ָR@\)@
@\)@G@@@
=@@@@33@@(@@(@H@޸R@R@Q@\)A
\@=q@\)@p@
=@@z@{@33@=q@@(@33@G@@@G@=q@
@
@@z@33@H@=q@\@@@@Q@R@@p@H@@@أ@@@z@ָR@(@أ@߮@\)@\@@
=@{@p@@G@  @ڏ\@׮@H@
=@p@33@׮@=q@Q@׮@  @p@H@ff@ff@ٙ@@=q@޸R@@
@(@@ָR@أ@z@@@@G@@(@陚@Q@=q@
=@@z@\@\@z@(@R@@@  @@{@Q@=q@@
=@G@=q@G@@G@陚@G@  @(@@{@
=@  @@@G@ᙚ@=q@@{@ff@ff@p@33@@ᙚ@@{@ff@
=@߮@  @@@@
=@p@@33@H@G@@ٙ@=q@ڏ\@p@p@@=q@@ff@@޸R@޸R@
=@@@z@߮@  @߮@
=@\)@@33@@@\@G@G@ᙚ@G@@(@33@@  @
=@  @߮@\)@@@z@߮@  @@@ᙚ@Q@(@R@ff@@{@@H@@G@@33@ff@@@
@
@@
@33@{@z@@
@@@33@H@=q@=q@=q@\@ᙚ@ᙚ@ᙚ@@G@Q@ᙚ@@@ᙚ@=q@G@@G@@ᙚ@ᙚ@Q@ᙚ@@G@Q@@
=@@@G@ff@Q@߮@Q@  @ᙚ@@Q@\)@H@
@@=q@ᙚ@33@
@\@@G@ᙚ@@@
@33@H@R@@@(@z@z@@@ff@R@
=@
=@
=@@Q@Q@Q@Q@@G@G@Q@@@@Q@  @@@陚@
@@@\)@Q@
=@
=@R@R@
=@\)@
=@Q@R@R@G@R@{@
=@R@
=@@@@R@R@{@{@@@(@z@@@p@H@(@@@@p@
=@  @@(@R@@p@
=@@33@33@\@  @ff@
@33@@\@p@33@H@@33@@\@ᙚ@\@@p@
=@Q@H@\@Q@G@  @p@ff@  @@R@@ff@ff@(@p@@@ff@33@Q@@\)@@\)@G@\)@@{@@
@@@\@(@\@\@=q@@=q@\@@\)@@@@z@@\@G@
=@@Q@Q@Q@  @@\)@{@@R@
=@@@{@ff@{@
=@  @Q@  @@\@{@{@@  @(@z@@@H@@z@z@@@{@
=@  @R@  @\)@Q@@
=@@G@=q@@33@@{@\)A zApAA=qARA=qAffA
=A33A
=AHAHAHAA A zA A QA   @
=@RA (@@@z@@@@@{@(@
@p@33@H@33@H@@@
@=q@=q@G@\)@
=@@{@p@p@\)@@@\)@R@@@@@@z@z@@@p@{@@@(@@z@\)A AA\AGA(A  A=qAA  A  AffAAHAQA
=qA\)AAzAA
pAQA
A{AARAQARA!AA"=qA (AffAA zA!A zAHAApA\)ARAQAffA
=A
A
pA\)A\A
A
AzA  A33A
HA
ffAQAQA
=A33A33AAAAAQAA
=AHA
=AffAAAApAA A @\)A   A   @@\)@
=@
=@{@\)@  @{@A{ARA  AA(AffAA
HAzA{AARAAA(AGAAA(A(A\)A\AffA{A
=A  A
AAA\)AA33AA(A=qApA
AzA
AzAA  A  AA	GAAQAAAAHAA\)AQA=qA
=AARA	A	A	A(A
=AA
=A
A\A{AA\)A(A33A  AQAA	AzA\)AARA
A=qAA
=AA
A
AQA
=A\AApAGA A=qA=qAAHA  A\)AAzApAA
{A	A
AAQA
A
AAA
A=qAzAARAA{AzA  AA\A{ARAAffAAA zARAAAHA\A
ApAApA{A\ApA
=A
HA
HA	A
@(@@ffApA{AA @@R@Ap@\)A
=AA A zA @ffA (AAp@@
=@@H@z@
=@@@@@
=@\)A A@@\)@\)@z@{@@p@z@\)@GA   A
=@@  @\)@@Q@@  @
=@  @@@ff@\)@ffA AA=qAA@
=@=qA @
=@\)@@33@  @{A   @33@@
@
@@@=q@z@z@z@z@\@(@z@\@=q@@H@@
=@
=@@  @p@
@(@@Q@p@z@@@Q@\@H@\@\@  @@R@{@{@ff@R@33@@{@R@ff@{@R@{@R@G@@@G@@@Q@
=@\)@
=@
=@ff@
=@@
=@  @@=q@\@H@33@@@p@
=@
=@  @@@  @@\)@
=@@@  @@@@  @  @z@@\@@z@@ff@@\)@@@@H@z@
@z@\)@ff@z@@@@ff@\)@
=@R@ff@@@p@p@p@@z@@(@@  @=q@@  @\@@@@@ff@@@33@p@@  @\)@z@@@@(@33@@@R@@z@\)@Q@p@33@(@\A QAAp@
=@@H@p@ff@
@\)@33A (A  A A@z@(@@@pAAAAp@@
=@@@\ARA33A\@\)A@@GA A\)@
AR@=qAAAff@p@\)@{@
@
=Aff@A
=A=qAA33A(A	GA	AQAA33AAA  AA\)A
AA
HAAzA  AA
ffA
=A
\AHA33A  AQA
\AGA   AGA (A @\)@
@@@@Q@@{@G@@G@=q@@
@{@p@p@@@@\@zA (@@@R@p@z@@H@@\@G@ff@@A (@\)@{@@@33@z@@@\)@@33@  @陚@p@Q@@G@{@@p@@p@@@33@z@@@{@@@@G@\@@p@@@
=@@H@{@z@p@\)@
@ff@{@Q@  @R@@@@\)@R@33@
=@ff@@
@@Q@(@G@33@@H@@\)@@@33@Q@
@(@@
=@޸R@{@p@\)@G@@\@{@@@\@@G@
=@=q@33@33@H@HA zA (@@@@@p@Q@ff@p@  @=q@=q@Q@R@@@@  @p@z@@
=@@ᙚ@@@(@H@z@
@@ڏ\@ᙚ@
=@@H@
@@@@@p@@
=@H@{@@Q@(@p@z@Q@陚@@@\)@=q@{@@@\)@p@=q@@@ᙚ@ᙚ@(@ff@G@p@Q@\@\)@@z@\)@ff@H@H@H@Q@@{@(@33@@{@@@p@{A   @=qA\)ApAAzAA@
=@A z@pA zA @
=AAHAAQApA{A\A
ffAAA{AffAAAGA
=A\)ApA=qAffAA A\AHA
=AA
{A	A	GA
{A	A
{A
ffA	GA  A\)A	A	pA	pA	A
\A	GAzA(A
AA\)A\)A
=AHA\A{A  AzA
AA{AA\A\)A  AAAAA(AHA{A A{AAA (A (A A AGAGAAA{A\A\AHARARAHAHARARAHARARARARARA\AffA\A\AffA\A\AffAffA\AffAA A A@\)A\AA   A\)A
=AffA\)AffAG@\@p@A AGA AffAA @ff@\)@\)@  @Q@@@\@@p@{@ff@@
=@A\A A\A\A=qAAGAGAA=qARARA(AzAAAA{A=qA\A\A\ARAAHA=qAAAAAAAApA  A(AHAffAffAA{A\A
=A\)A=qA=qA{A{AA{AAAG@RAA @p@
=A@@H@Q@@@=q@\@{@(@@R@Q@@@\@@@@@\)@p@H@@@{@p@=q@p@Q@{@{@  @
@@ff@
=@@@
@@33@@@\@@{A QA @ff@33@(@G@\)@
=@ff@\)@@Q@Q@G@H@
@z@@z@
@z@@
@=q@@\)@  @@@H@33@@@@Q@@@=q@=q@@H@33@@p@@  @@\)@@@{@{@p@@ff@
=@ff@\)@(@R@@R@
=@\)@@@@@@H@p@
@@@@@@\@陚@@(@\@z@{@H@  @@@@33@@@@G@\)@G@@@@@R@R@@ff@
=@  @@
@@  @@@R@G@\@Q@{@H@ff@(@
=@Q@@(@=q@Q@@(@@
=@33@@33@@Q@߮@Q@ᙚ@  @@ff@@
@@  @@@Q@ۅ@
=@ff@Q@@@׮@ff@ff@@ڏ\@\)@
=@{@@
@Q@p@p@޸R@ٙ@
@@@@@G@@ff@@(@
@@G@\)@=q@@\)@Q@@G@߮@G@@ᙚ@@H@z@@{@@\)@
=@\@z@=q@
@=q@H@(@\@@\)@p@ff@޸R@߮@@\@ff@\@ٙ@\)@  @\)@H@p@@ff@G@p@Ϯ@@@У@@@@@@@G@
=@@  @G@@Ϯ@ٙ@@@  @љ@@
=@{@  @33@z@=q@
@Ϯ@ҏ\@H@\)@\)@@@@@ڏ\@33@@ڏ\@@ff@\)@z@@(@@p@p@p@p@
@Ӆ@
@33@
@Ӆ@
@z@@ff@@=q@ٙ@33@ڏ\@{@=q@{@33@=q@ᙚ@p@  @
=@\)@@@ڏ\@33@33@33@H@H@ۅ@ڏ\@ڏ\@=q@
@{@@߮@@  @@
@=q@ٙ@y @@@Q@  @{@@ڏ\@ۅ@@@
=@ᙚ@@  @޸R@@=q@@׮@G@\)@@H@@@
@Ӆ@=q@ff@Q@G@ڏ\@@z@p@ڏ\@G@ڏ\@@@ڏ\@(@@
=@߮@  @@G@ᙚ@@@@G@@ᙚ@@@=q@\@\@ᙚ@H@
@@=q@@H@\@@@G@=q@p@@  @  @Q@@  @@@陚@ff@@G@H@@@\@33@33@\@@Q@@=q@p@@߮@߮@=q@@@\)@@@=q@@H@H@@H@33@Q@G@@@@޸R@޸R@\@  @G@@@@@H@
=@ff@\)@Q@p@(@
=@@@@@@z@@@@@  @\@=q@@\@H@@@=q@
@@@@p@{@
@ff@p@  @R@@R@@  @Q@p@@(@@G@@  @\)@ff@p@\)@@{@@@33@
=@ff@޸R@
=@
=@޸R@߮@@ff@
=@\)@@=q@ᙚ@\)@\)@޸R@  @޸R@@Q@=q@G@@@\)@33@޸R@(@(@@ff@{@@  @ff@߮@\)@
=@G@H@@
@33@(@@@߮@޸R@H@H@33@ۅ@@(@z@H@=q@=q@H@p@ff@ᙚ@G@ᙚ@G@@@ff@@
=@z@@߮@@G@ᙚ@@@Q@@Q@@  @Q@@@G@@@Q@@@\@@@\@=q@@@z@@\@@@@\)@@Q@@\)@@ff@(@@Q@߮@z@޸R@33@ᙚ@@ff@{@
@ff@ᙚ@ᙚ@\@p@@ڏ\@{@(@p@ff@\@ᙚ@\)@p@߮@Q@Q@޸R@ff@{@
=@Q@@Q@߮@  @߮@߮@  @  @  @@G@ᙚ@ᙚ@=q@@\@=q@z@H@\@p@ᙚ@߮@  @߮@
=@
=@\)@\)@@Q@߮@@
=@  @{@ff@@ff@33@@@
@ۅ@޸R@
=@p@Q@Q@\@G@G@  @
=@@  @@z@z@߮@z@@
=@ff@Q@
@@{@
=@{@(@@@޸R@@
=@@=q@@@H@H@@33@=q@  @@\@@@{@@p@{@߮@߮@Q@  @
=@@@G@H@ٙ@{@@33@  @@\)@G@@=q@33@G@ᙚ@@
=@@޸R@ڏ\@
=@ff@
=@p@33@z@(@\)@z@@޸R@z@ۅ@@{@z@
@H@Q@أ@  @@  @H@ڏ\@H@@G@Q@@H@(@{@ff@G@@
=@
@@33@@ff@=q@\)@G@ᙚ@\@@33@z@@
=@@\@@(@
=@\)@陚@G@@33@\)@33@
@@@߮@@@\@@
=@Q@{@
=@@H@
@  @\)@p@(@
@@{@p@@33@ᙚ@\@\@@
=@@\@@\@@
@ff@@G@Q@\)@@޸R@@(@=q@@p@ڏ\@@(@{@(@@H@H@ff@@
=@z@z@
@33@
@ۅ@33@  @Q@{@\)@(@{@@{@
=@Ϯ@  @љ@z@\)@@ۅ@  @H@z@޸R@ڏ\@H@@@ᙚ@@G@\@G@Q@{@p@@@@33@
@ff@R@@\)@\)@  @@G@=q@G@=q@H@Q@陚@陚@
@H@@@@@33@  @  @@{@
=@Q@  @@H@@\@ᙚ@Q@G@@@G@33@
=@\@@ff@@R@@R@{@
=@\@@\@\@R@p@  @@陚@  @Q@ff@
=@
@@ff@@ff@(@
=@@@33@
@G@p@{@@ff@@{@{@p@@޸R@
=@Q@ᙚ@@\@{@@@@H@@@p@@@p@p@p@p@p@z@@@G@=q@H@@ff@R@ff@ff@p@R@@@ff@p@@z@{@R@
@(@ᙚ@=q@Q@߮@@G@  @@@\@@H@33@@H@@@Q@z@Q@ᙚ@ff@\)@@@z@@@G@{@@ff@ڏ\@@\)@  @@߮@G@p@G@陚@R@  @H@
@@p@@@@
=@@@@=q@\@33@@陚@@@  @(@
@陚@@33@(@
=@\)@ff@\@G@H@@@@@Q@@\@@H@  @@Q@Q@p@\)@@=q@\)@{@@@@  @@\)@Q@
@z@p@
@z@(@@p@z@{@@@@z@=q@
@z@R@\)@@33@p@
@
@z@=q@=q@=q@=q@\@=q@@@陚@\@@
@@@\)@@@{@\@@p@H@ff@=q@Q@@  @=q@(@ff@Q@@@\@G@(@33@\@@H@@@=q@@
=@@=q@\)@\)@Q@\)@ff@{@@@@33@=q@@33@\@\@@@Q@  @ff@  A
=@{@R@
=@
=@@@H@G@
=@p@
=@Q@@
=@@G@@@@@{@R@@p@p@@@=q@\)@ff@@@@@
@ff@33@@@@@@\)@{@@\)@@z@
@(@p@R@R@
=@H@(@z@\)@@\)@H@\@Q@@  @33@=q@Q@@p@p@@p@@A   A QA A zA QAA\@\)@
=@R@R@ff@p@R@R@{@@@@=q@R@33@z@@{@@
@@ff@z@@@{@33@=q@@@@@  @G@G@AzAA @H@
@@R@Q@=q@
@\@(@@@H@@{@  @ff@{@\)A (A   A(AAAA (A @
=A=qAApAAAzA33AffAA (AGA AA\A(AA	A
=qA
HA
=A(AzA33A
ffA  A	AHA
{A
AA zA   A A\AHAAzAzAGApAAAA
=@HA@@@(@z@@@z@@A zAA @\@RA zA AGA@pA A Q@33@  @Q@  @@33@Q@\)@@@=q@\@  @@@ffA (@@ApA@33@@=q@@=qAA\A AA
RA\)A=qA33AzAffA
ffA{A{AA\AAAAzA  AAA
A\)A\)AA (A@@@A A\)AA{AffA(AA A QA zA (ApA
A  @p@
=@@A   A z@\)A @@AAG@\)@
@z@@@{@{@ff@{@@@
=@\)AffA A z@A (A @@
A   @@ff@A\A\AHA{A
=AGA A
A zAGA Q@@
=A (@@R@(AGA
AA AffA=qAff@{A
=AA AGA
=AHAAHAAAA
=AzA
=AAA\)AGApA33A	AQA
=qAA
=A  ARAARA\)A\AH@ffA33AG@z@p@A (A\)@pA (A (AAAA{A QAHA
=A@{ApAGA (A A Q@p@@ff@H@H@=q@
@=q@ff@@z@@\)@@H@
@ff@Q@  @@\)@ff@@@@@(@@@@{@@\@=q@@ffA@ff@R@=qA @@@{AA\A
=AGAAA=qA\)A z@AA A{AA\A A ApA   A @AG@\)@33@=q@\@33@@@G@@
=@
=@=q@@(@  @=q@H@@z@@H@@{@@G@ff@p@@G@@(@ff@=q@H@(@(@
@\@z@\)@ff@Q@33@  @@@@@@p@R@  @ff@@
=@@
=@R@p@@\@{@  A ApAz@
=AH@pApA Q@@
A (A{AA	AARAA{A QAQAQAzA  A{A(A ARA{A@\)AA
=AAHA A   A=qA @Q@p@
=@z@
@
=@(@@@z@@@=q@z@@
=@@  @=q@H@
@\A z@\@@@p@Q@33@@R@{@R@@  @@p@=q@=q@
@G@  @
@R@G@@H@Q@AApA @A QA
=AffAffA
AAzAA	pA	A\AA (AGA=qARA(AQAAA\A33AA	GA
{A	A	A33A
HAA(AHA
=A QA{AA Q@(@33@{A\A=qAA
=ApA\)A33AA33@ffA (@
=@zA @
A   @ffA ApARAAA33AzA\A\)AAA @zA=qA  A
@\)AAQAAA@RA@
@{@(@(A @z@@p@
A z@ffARAA
RAHA\)A  @HAQ@\@@p@Q@(@A @\)A@\)A (A@RAA
=qA
ffA\)AA
ARAA  AAAAAAQAAA	GAAA@RA   @
=AARAA A@
=AHA33AAzAA
A=qAAA
=A(AA
=ARARA=qA\)AA\@@R@
=AA=qA ARARAzAAA(@A33AAA\)A
@AGAQA{AffAA A  AAHAAAAA@
=@H@HAA
ARAA\)A  A@@RA  AAzAA  A
\A	pA	pA	GA\)A=qApAQA{A A{Ap@
=A (ApA@@RA A@{A zAA A AGApA\A{A{A QA ApAAA   AffAA	A  AA33A33A  AA  AAAARAA(A33@p@@
=@  @@(@33A   A @@H@=q@G@\@@@RA   @
=@
@\@=q@R@@zA @Q@@A (@=q@33A Q@33A
=AGAAAGAA=qA@H@H@@AApAA
=qAHAAzA
A	A
HA33A  @{@@\)@\)@@@
=@\)@@G@\)@{@@p@z@\)@  @@H@\@@
=@\@p@@@(@\@33@33@H@@@@@@@@{@@=q@  @@ff@@\)@{@@@R@@@\)@@z@ff@@@33@@{@@
@  @G@  @Q@(@G@G@\@@ff@
=@ff@@@H@@A (A(A
A\A
A
=AA=qARA33A\)AzA=q@RA   @
@p@p@H@  @(@p@\)A (@ff@@
@G@Q@@G@Q@\@z@R@
=@ff@ff@ff@ff@ff@  @@=q@33@z@=q@\)@R@@33@=q@@G@@@R@H@p@@p@
@\@@  @@Q@@\@@\@Q@@z@@A	G@@@@@\@@
@33@@@@G@H@\@@@@@Q@  @Q@  @@  @@G@@Q@\@H@\@\@@@@@Q@@{@p@@@@
@@@z@@\@@@p@33@
@
@G@@(@=q@陚@\@=q@@  @\)@@\)@@@@@(@\@@@
@\)@\)@=q@\)@@陚@p@H@33@@@{@@G@p@
@G@H@@{@@@G@ff@G@\)@p@@H@\@=q@=q@=q@\@@@{@@@G@
@@\@@@@{@@@=q@\@@p@  @
@=q@@@@  @H@@\@H@\@@
@
@@\)@(@z@@G@陚@@\)@@@\@@G@\@{@R@\)@=q@@@G@
@p@\@R@{@@@z@(@@@\)@G@@@Q@  @ff@p@@G@(@H@@@R@Q@@陚@=q@\@@@R@@@p@\@陚@@{@@\@
=@  @  @Q@{@ff@
=@z@@33@=q@H@\@@A@\@@(@@@=q@
@@ff@@=q@@@Q@
=@
=@\)@  @(@=q@@p@=q@  @@{@@(@@
=@G@Q@@׮@\)@ٙ@  @ٙ@\)@@G@@
=@@ff@ff@@G@陚@@@p@\)@33@@޸R@@@޸R@߮@@\)@
=@
@Q@@@
=@
=@޸R@  @ᙚ@Q@p@ff@@\@33@\@@
=@G@@@@@{@
@Q@߮@ٙ@{@
@ٙ@Q@
=@Q@@
@@ᙚ@Q@ᙚ@=q@@33@@@
@@
@H@@@@\)@@@Q@@@{@{@@{@p@@G@z@
@@@G@\@=q@@@33@@@@@33@H@z@\@@=q@  @@
=@@R@@ff@@H@@H@@\)@p@@\)@Q@@
@  @@(@z@z@z@@
=@ff@@R@@@
=@33@@=q@z@@@(@
@@ff@@G@
=@z@\)@33@\@(@׮@\)@H@ۅ@  @@߮@(@陚@
@z@@ff@
@{@
=@R@ff@Q@G@@
=@p@陚@
@@@\@
@  @
@@(@(@@G@@@@@@H@p@(@@R@Q@\)@@  @@=q@
=@{@z@@@33@H@33@z@@
@Q@@@{@{@A   A zA A   @A @@{@
@@@
=@@(@@Q@@@@@(@@
@@\@\@=q@=q@@\@p@@{@@{@@p@
=@ff@@(@@z@@p@{@@G@
@\@\)@33@{@@@33@@@=q@R@H@G@R@@Q@33@z@
=@\)@@@H@33@p@@(@(@=q@@=q@@@  @@H@H@@ffA   A AAA{A\)A
AAA
=AA(A33AAffAA z@A@A@ff@p@
@@{@33AA AA   @
=@\)A
@(@z@=q@
=@
=@=q@
@H@
=@  @Q@G@ff@@  @33@H@H@=q@R@@z@@
@H@@R@=q@G@=q@@H@
@@33@@@@ff@R@ff@33@
@GA(@@pA Q@ff@@ff@
=@@Q@H@zApAR@R@@HA (A A ApAGA\AAA{@\@
=@p@@ffA @@@{@
@\@G@@Q@\@G@@@  @G@{@
=@
=@
=@{@\@@R@Q@@@p@
@@@p@(@(@R@z@@ff@{@Q@33@@
=@@
@H@\@ᙚ@p@\)@ff@
=@@  @G@@陚@
=@@33@H@{@  @\@p@
@@ff@{@@(@33@@=q@@(@(@z@p@@{AG@33@(@@z@Q@  A\A(A  A A33@{A A QARA z@ffAffA A{A QA zA @ff@R@(@(@@@G@=q@H@
=@@{@@@G@
=@R@@  @33@Q@\)@33@@@z@p@Q@=q@R@ff@@
=@@@@@
=@=q@(@@@p@(@{@
=@G@
@\@@p@@G@Q@{@@z@=qA AA A=q@ff@@@\)@@z@@ff@p@@H@
=@@\)A (A A QAA QApAGA @ffA (@ff@@=q@33@@@G@@R@@\@@(@H@z@\)@@=q@Q@Q@\)@H@\)@@G@Q@  @@p@=q@H@
@
=@@R@33@33@\)@Q@
=@\@@ff@33@Q@\@@@z@H@@33@Q@@\@H@@@(@@(@\)@@H@@
@33@@@  @p@@@@Q@Q@\)@@@Q@G@@G@(@ff@@@
@z@@z@=q@\@
@R@{@@@G@@@G@H@p@(@=q@=q@33@H@(@@H@@Q@H@\@@z@=q@=q@
@{@R@@
@=q@陚@@R@G@@@G@G@H@\)@@Q@=q@H@@
@(@@33@  @{@H@{@p@p@R@  @@R@@\)@@Q@@@ff@  @Q@R@z@{@@  @33@@\)@  @p@Q@陚@=q@陚@G@=q@\@H@
@z@{@z@
=@
@@陚@陚@陚@Q@G@@H@G@@@G@陚@@G@  @\)@@Q@  @@Q@  @
=@\)@R@{@\)@\)@{@
=@@@\@(@33@@
@@
=@
=@p@@H@
@Q@=q@
@=q@@ᙚ@ᙚ@ᙚ@=q@@33@=q@\@@p@(@@@H@H@\@H@{@{@@33@\)@陚@33@=q@{@@R@Q@@G@陚@G@@@
@(@z@@@@@\)@@H@@33@=q@@
=@@p@@@\@@33@\@@
@Q@=q@33@@R@p@@33@z@(@@陚@=q@陚@Q@\@(@(@z@
@@@@(@33@陚@H@=q@H@
@
@@(@@33@
@\@@\@@\)@  @@ff@@@z@@@@G@陚@  @33@
=@(@G@Q@@@{@ff@ff@{@z@  @H@{@{@@H@
@
@z@z@\@{@G@@@  @=q@@@  @\)@  @Q@@@@@  @Q@Q@Q@\)@R@@p@@@(@@@@H@
=@\)@p@p@z@33@
@@@33@@@  @p@@@@@@\@33@33@
@@33@H@33@
@
@z@(@z@z@z@p@@R@@G@H@@@@H@=q@@@\)@ff@(@(@@p@@p@p@@p@@\)@G@\@@=q@AG@
=A(A
=AGARA\)AA  AARApA   AAp@\)@@
@@H@H@@
=@@@p@  @ff@@H@\)@ff@  @p@
=@{@R@\)@H@@@
=@
=@@
=@  @R@@\)@@@  @@  @@@R@{@R@
=@  @\)@\)@  @@@p@@{@@G@33@@G@\@@\@@=q@@@@@Q@@  @@@@H@\@@@{@A QA   AAAAffA{AAffAGAAHA\ARA z@p@p@@@@R@  @
=@\)@\)@
=@{@@\@G@z@=q@@ff@@@@@33@G@
=@ff@
=@p@z@@\@@陚@陚@=q@@(@@@@ff@
=@ff@
=@@R@=q@(@@(@@@ff@@@p@@@@@@  @=q@33@=q@@G@33@(@ff@H@@A zA AA
=AzAQAzA  A\)A(AffA\A
A
=qAAQA
=A\AAA z@@@{@{@@@@@\)@@Q@\)@\)@{@@@(@(@R@@@@@@@(@p@ᙚ@ᙚ@@@޸R@p@{@  @@@@=q@
=@ff@ff@@(@@33@H@H@@ᙚ@@  @\@\@=q@=q@33@=q@H@@@(@z@
@{@
=@\)@
=@
=@\)@
=@R@@\@p@@p@@{@R@{@@ff@@
@
@H@@@陚@@@G@@@Q@Q@@@@\)@\)@\)@@Q@@Q@  @@Q@
=@
=@@@G@p@@@{@p@33@p@z@@z@33@z@p@
=@@@R@ff@ff@  @ff@Q@Q@Q@@@\@H@\@=q@H@33@\@H@@
@z@(@z@p@ff@
=@@Q@@G@@{@\@\@G@@@@@@  @
=@ff@\)@  @@@@@@
=@  @{@Q@  @R@@
=@
@H@=q@@@(@z@
@
@@H@33@\@\@\@@=q@@=q@\@\@H@\@
@@H@G@@=q@@@@z@@z@
@(@\)@@p@
=@@  @\@G@@\)@  @G@@R@Q@G@\)@@@G@=q@\@@@@R@  @@  @G@@@@G@  @@@@@@ff@@R@@  @@\)@  @  @@Q@@ff@@  @p@@@33@@陚@@
@z@p@@z@(@@33@z@z@
@@@33@@=q@  @@p@\)@  @  @  @@Q@\)@ff@@  @G@Q@p@Q@@{@p@ff@R@{A  @@33@G@
=@@@(@@ff@\)@R@{@@@@@G@G@=q@@@@@H@G@G@G@@@@=q@@=q@G@H@
@
@(@(@@@
@
@(@(@p@p@@R@p@p@@@=q@
@\@@R@@R@@\)@@@@@@@
=@{@R@@p@p@@@{@@@@33@@@
@@ff@@@R@p@@p@
@
@@A AA\)AA (Az@H@@{@
=@ff@
=@\)@\)@\)A zA AAAApA=qA\AA
A  AA
=A\AffA{AGA@A z@p@Q@\)@\)@{@=q@=q@
=@@@  @@\)@  @@@z@=q@G@@@@ff@Q@@p@@H@Q@H@@Q@\)@{@p@@
@(@H@@G@H@H@
@33@@
@@p@@HAQ@ff@@@@@\)@@\@p@
=@@(@@=q@
=@@R@H@G@@@ffA (@@@ffA AA\A=qA\)A\)A  A\)AAAA(AAffAAA
=A(AAA
=A=qA\)AA z@\@@
@\)@H@p@ff@z@\)@RA A zA @@@
=@=q@
@(@@@  @{@33@R@@z@
=@p@ff@H@{@(A@@@@@\@p@@Q@@@  @  @@\@G@H@@\@@G@\@@H@G@@ffA (A{A\AHA
AGA
=A{AA	GA	GA	A	A
=A  AA
A
A
=AffAQAQA
A\)A33A	AA33A  A  A33A	A	AA
A	A33AA33AGAAAzAAA  A
=A
A	AzA
A	GA
A
=AAAHAQAffA{AA{AA A=qAAQAA33A A   @
=@@
=AApA   @A AA @\@@@{ApA{A\)AAARA\)AzA
HAA
AAAAA33AzAAA
=A  AA
AAzAA A"=qA!GA#A#
=A$  A#A&=qA$A#A!A A AAGA(A$  A#\)A\A=qAARA
AA(A
{A  A	GA(AAAzA\AA
=A=qA33AAAQA
=qAA
=A\@ff@@\)AA(A @RA (@AAA\A
=@@(AA z@ffAGApA @@H@R@(AHARAAAA
=qA
\A
RA(A
A=qAzAA\A  A  A=qA=qA
=qA  A
ffAARAAAzA{AAA(A
=A$zA)pA)A(A*\A%GA'
A&ffA#33A"RAA\AzA{AAQAA\)AAA
HA
RA
A
{A
A(AHA
ffA
AA=q@A
A A  ApA33AA
GAffAAA	A(ApA
=A\)A\AGAA=qA\AAA33A{ARAA\)A  AARAHAA{AGA{A @@R@G@Q@zAAQ@ffA QAA
AzA\A{A(AGA  ARA\AA=qAA (A\)AA zAAHAHA  AA
ffAA
@\)@@@H@33Ap@33@Q@ff@=qA33AffAAG@\)@R@@33ApA @p@AAA	GA
A
A
HA  @\)AA  @@p@
A=q@@@HA@@33A   @\)@H@zA z@@\)@zA   @@@@z@A@{@p@p@ff@  A33A{A zA zAG@=q@{A A @
=A Q@R@\@(@RAAA	pA
{A
HA
AzA  A
HA	A	pA
A(A
=AAGA
=AAA  AA
GAHAAAA(A33AHA
A
=AA @AGAAA   A33A\)A{A  A\)A\AApA{A(A@@z@@A @@A   @@33@H@33@@H@@{@@
@@
=@@@@(@=q@@@(@@G@
=@A @AAzAAp@
=@
A (@\)A A@AAARAA
A=qA
GAffA(AApAA=qA\ApApApAQA
\A{A\A=qA
A33A=qA  AA
ffA	pAAzA(AAARAAA(A{AA QAARA Q@
=@{@R@@@@Q@@{@ff@R@@p@@{@ff@
=@ff@@@陚@@
=@@@z@@G@Q@
@p@pA@AGA AAA{A\)A  AzAzAAA
{A
\A33A
HA
RA
{A
A(A	GA33AAA
A
pAA  A  AzA
=AA  A=qA\)A{AQA
=AHAAGAzAA33AzAHA	GA
pA  A\)A  AAG@
Az@ff@QA
=@Q@ff@R@\@p@
=A{AGA z@ff@@p@@33@H@@@
=@{@(@@\@H@  @@(@@@
@@{@  @陚@@33A	AA  A
=A33A{A A  AzAzApA
ARAQA(AffA	A
AA
=AQA
A
RA
AAzA33A\)AHARA
\A	A33A	pA	A=qAAA(A\)A33AAA{A	AA=qAARA  A{Ap@RA @
=@@Q@G@@p@\@@@@@\)@33@{A\)AA z@RA Q@\)@ff@
@(@G@@z@
@\@=q@G@Q@@@R@ff@@@(@p@@=q@=q@z@H@p@Ap@H@A\)@HA  @@(@@@@
=@A Q@R@
=@ff@R@\)@A (A AA\AffAHAA(AAAAAQAQARA  A
=A
=ARAA@\)@{@
=@@=q@@33@@p@@R@\)@{@ff@
@
=@\)@@@@  @@ff@{@
=@\)@@R@\)@{@(@R@ff@{@Q@G@@@@@\)@(@
=A @33@@@R@\@ff@@p@p@@\)@@(@z@{@@\)@@@@R@
@@z@A AAffA33A
AA
AzA
=AA
=AQAAGAGA{A33A\)A\)AzAA	AffAA	A
=A	A	A	AA
HAAAA	AAAQA ApA@ffAffA@\)AffA=qA33AQ@@R@33@\@
ApA (AAApA @
=A   @@@\)A @z@z@\@\)@R@
@
@z@Q@33@Q@Q@@\@=q@=q@H@H@\@=q@33@@A @A QA (@{@RA @zAARAA
ffAA
HA
{A(A(AAQAARAAA=qAzAA(AA
ARA(A(A  AffA
pA
pAAA
=qAAGAA  AAGAAAGA A A Q@z@@(@(@  @@{@@RA   @p@R@
=@@R@33@@@@
=@
@@@@@@@p@ff@
=@33@\)@陚@\)@Q@@H@(@@{@(@(@@@pA zA (@A@  @G@33@(@@ff@=q@ffAApA33AA{AAA
=A(ApAAA AA=qA
AAA
=AQA
A	AffA
ARA33AffA
=AAA(AAAA\)AA\AAp@A @
=@@\)@@ff@33@@H@{@@H@(@@G@A (@  @@(A   @(@G@
@
@\@\@@@R@
@\@\@@G@
@@R@@@@\)A QA (A
ApAffA  A
HA	A
{A
\AA{AA\A\A33ARAzAA{AHA\)A=qA\)AAA
A
AAAA
AGAzAA=qA\AzAA
AA33A
=A  AA{AAA33A{AA33A
=A
=AA  AH@H@
=A zAA{ApApAAGAGAGAAAAAA @@ff@@Q@=q@  @@ff@@@=q@H@Q@\@(@H@R@@
@G@\@@
@\@@A   AA QA\A   @AQAA  AA(AQAA
\A
@@A ApAAffAA	pA Q@Q@@R@@@@=q@\)@@z@
@Q@@@
@
@(@{@@A33A   @p@(@H@R@z@@G@G@p@
=@R@@ff@
@@p@Q@Q@@(@H@\@@@{@@ff@Q@@Q@@@߮@@Q@G@@@33@@@=q@R@R@@p@\)@@=q@ٙ@@
@@AGA  A@=q@(@@ff@ff@ff@
=@G@33@@@ff@z@A @ff@\@@@AAQApAAQA   A@H@Q@\)@A@z@H@  @@=q@{@ff@
=@  @@@
@H@=q@
=@
=@@ᙚ@@\@33@@@(@@H@\@G@@@
@@@G@33@R@H@p@ff@@33@z@R@@@\)@Q@
@H@(@@@@  @R@z@z@@=qA
\@@H@(@@RA (ARAffAAGAffAAHA	@\)A  AA	A	A	A
pAAA33A\)AA=qA=qA
A  @
A\@=q@@\)@
=@@
=@ff@p@\)@p@{@@@R@p@@{@@@\)@R@  @@ff@p@R@@H@
=@@H@\@
@@@H@ff@@p@p@@z@H@=q@z@Q@ff@߮@@33@z@@ff@
=@R@  A@@@@@A@H@H@p@(@  @
=@@
=@  @\@
=A ApAffAA\ApAA(AffAA=qARAHA  ARA\)AAAA
RA
=AQA(A
AAA
A@z@pA@{@33@(@H@G@  @AAH@H@@p@@RAz@RA Q@@@@@@(@@G@H@  @\)@z@=q@{@@@أ@Q@Q@׮@H@z@@@\)@أ@{@z@z@{@(@R@
@Q@
A QA zA=qARA  A\A(A
AQAzA
AA33AAQA=qAGAA
=AHA\)AGA{AffA
AA#
A!A
=AA
{A	pA
RA	GA @\)A @@@G@@(@H@RA=qAp@
=@
=A@
=A   @
@Q@=q@\)@@(@\@@@@@H@@ff@p@@  @H@R@@  @p@=q@@33@(@@@@p@@Q@=q@Q@@@{@G@@@
=AAA{AAA=qA\A  AHAQAAAGAA\AffA=qA=qA(A
=AA A(QA'33A(A(A(A,  A-A6HA7
=A=A9A9pA7
=A>=qAD  A+\)A)pA{A$A(QA0zA,A\AAHA"=qA#A\)AAA{ARAA=qAA
=A(AA
=qA	pA
\AHAA=qAHAffA{ApApA
=A33AAA
{AffA
GA
AQA
AA
AAA
ffAA33AAA\)AAA(A\A
AApA
AAGAQA33A$A zA'A,QA+A(A!A!GA%A*ffA%pA QA#A!GA%A+
=A4(AD  A1pA<(A)A2ffAF{AC\)A,QA((A>=qAAGABffA=A9A5A1A1A.{A+A*{A,(A#\)A$  AA33A33A\)AA	pA(AHAGAAffA33A#AAQA  A
A	pAQARAQApA\A
A
H@@A{A QA QA
HA\AzA
pAAAAAGA{ApAzAA\)AA   A!A!pA"RA&{A#A#AA
A  AA
=AGARAAA33A QA%A A$A"{A$A QA'\)A$zA'\)A0zA0  A.{A2\A6HA:\A<A=A=A9A8A$  A%A(zA*{A+\)A#A(  A&{A'33AGApARAAAA
AQAHA(A=qA
A33A\A
GAQA
ffAAffARAHA(AA33AHAA
{A
ffA
A	A	GA	AAApA
=A
AHA33AAzAGARA
ffAQA
RA
=A	AA
=A{A  AzA{AQAA
A
A
AzA
A
AA(A!AAA"HA
A   A A"=qA%A(QA*HA*RA*ffA*HA,QA+A(A((A&\A'33A1pA!A(  A*RA$zA*HA-A.{A-A+A*RA'
A!A (A"\AAAAA (@\)AQA
A	pA
=qARAGA=qAA	A
HA
=A
A{A33A\)A
A  AHAAzAzA
A=qA
AA
A
GA
pA
=A	GAzA	A
=A\)AApAA\A
=A33A
RA\)AAA   A zA Az@A33A{AHA(AAAAA=qAffA  A\)A\AffA\)A33A
=A\AAffAAApA{A	A33AAA33A
A\)A
=AffAQA{AAzA
=AffAAA(A33A=qA(AHAAARA{AApAQA  A
RAAAzAHA=qA@ff@@@\@(ApAARA{A
=A A33ARAA\A\)A\AHA(A(A
A\A(AAQAQAAAA$  AA!pA!A"=qA#33A!A$A*{A-A3\)A"RA,  A&HA!GAffAzA\)A\)AAHA
A A%A$(A   A
=AHAAA
=A A%A$A{A
=A\)A\A
A
HA33A	A	AQA
HA
HA
AHA(ApA@{@
@RA  A
@
@z@z@@@H@
@{@G@  @  @@G@\@z@\@p@
=@@@Q@\)@@{@@=q@@@@33@@(@G@  @
@pA	@A z@G@
=@A @@
=A33AAA{A
AA%AQAA A QAHAA
=AAzAAHAA
A"HA\)AA%AA=qAA{A(A33A
A{ApApA=qA33A=qA\)@@@@(@ffA (@H@33@@A   A Q@\Aff@33@ApA\@zA   A\AffA@AQA	AGAHAAHARAAz@
=@@@@p@=q@(@ff@{@{@@G@@\)@=q@ff@=qA\@
AA Q@@@=q@@z@A   AAAAGA A A AA @
=@@R@33@p@@\@@33@G@@  @\)@@p@@H@@ᙚ@ᙚ@߮@z@@޸R@
=@߮@  @ff@ۅ@\)@@@@@H@z@p@33@=q@33@@G@G@G@=q@ָR@\)@(@z@33@p@θR@أ@Q@z@@@=q@׮@@ٙ@أ@@أ@أ@\)@33@ָR@G@@Q@ָR@G@ָR@أ@@ڏ\@أ@@@@
@ۅ@أ@ff@G@
@G@@G@Q@33@@z@H@=q@ָR@\)@
=@@أ@
@@\@@G@G@
=@p@@\)@
=@@  @@Q@  @@z@@H@ff@\)@  @ff@ff@@p@ff@z@޸R@޸R@\)@ff@p@@Q@\@
=@@ff@ۅ@=q@H@=q@G@@Q@@(@أ@33@z@Ӆ@Q@Q@33@=q@H@ڏ\@Q@(@ҏ\@
@ff@H@@p@ָR@׮@@  @@@G@  @=q@p@߮@߮@\)@
@ff@\@Q@@@@ff@33@@  @@\@@=q@G@(@@
=@
@33@@z@@@@@@QA @@33@H@  @z@\@@=q@@@@@\@@޸R@\)@@߮@@33@=q@z@߮@p@޸R@@@(@@33@z@@
=@@G@Q@ٙ@G@=q@޸R@
=@{@޸R@\)@߮@߮@@߮@߮@@ᙚ@@=q@@H@  @Q@R@@陚@H@@@Q@R@Q@\@=q@  @@@R@{@
@p@@=q@@
=@@HA   AAHAA(AA
A	A
RA
AzA\A(AApA  A\)AA	AAA\)A\)A @@ff@@\@(@
=@p@@ff@@ff@陚@@
=@{@z@@@G@陚@@\)@
=@Q@\@{@@@@@=q@\@@33@\@@{@@
=@陚@G@z@A (@Aff@p@@@ff@
=@  A  AA
ffA
HAA
HA(A
GA  AA	A  AAAAAzA(ApAAGAA$  A+
A-A,QA(A/\)A'A(A+\)AffA#
=AHA
A
=A\A	@A
A@@\)@\@@\)@G@@@z@
=@33@p@@z@33@  @G@@p@{@@{@G@ff@p@RA zA{@33@ff@@@
@@{@@
@@
=@@\@33@
@@@Q@@@@@@{AR@ff@z@\A   A
\A  AzAQAA(AGAAAAA33AHA QA A#A%A&HA.{A4A8  A4A5GA*\A1A)A5A3A:\AHAQA=qA(A\)A$QA
=ApA\A33A
A\)A	GAAApA\)AAA z@@
=AA	pA
=AAA
GA\)A
AQA  A=qAzAA=qA(ApA{A\)A33AA
=qA
=A\A@
=A@A\)ARAA  AHAAA(A@\)@H@33@@QAff@=qAA\)ARAAA{AHA=qAffA\)ARA33A
HA
\A
ffA33A
GA\)A
AAA
A
\A(ARAA\)AA\)A!A%pA%A%pA#A#
=A A{A33AA\)AAA(A\A
AAHAARAzA(AQA
A=qA
A33A\A  AffA
pAA
A	A
A
pAHAQA	A
RAA
=A
ARAHA\)A{A
=A=q@ARA{AAA\A
=A
=A
=A	A33A	AzAA(A  A{A\)A\)A  A
AARAAA\AA33A\)AzA
A
ARAAAHAGAA
AA\)A zA$(A'
=A'
=A&{A$A#AA33ARAAA(AAAARA
=A
pA
GAAA
ffA	GA(A
=AHAAGA	A	AA
{AHA
ffAQA	A33A33AQA	GA	AA	pAzA AAApAAzA  AQA33AA Q@@  @@@@\)A33A  AAzA\AffA\AQA
GA  A=qA
ffAzAGA33ARA(A
=AGAAffAAQAA)GA\AA(A"{A (A{AA!A"RA$zA%A'\)A)A)A*=qA*\A(QA%A(QA&ffA$QAHAGA=qAAApA33AAHA\)A33AQAQA\)AA\)A(AA33A=qA
AAA  A{AA=qAAAQA\)AzA A"\ARAHA\)A{AffAAA
A	A\)A	GAA	GA\)AQA
ffA33A\A	A33AA
=AA33A\AA
AQAffAA
ARARAAAA#A\AffAA!A(AffA#33A{A
A A$QA)A(A(A'33A&HA((A)GA'A(  A*ffA&\A#A$A(A'33A	A zAGA
GAGA\)A  A
=A
\A=qA
A zAA\A{ApApA@
=@p@@G@G@=q@Q@\)@\)@Q@@@{@\)@@@  A A(AAR@(A
AA\AAff@@ffA AAA\A
A
=AAzAA{AGA  AffAA\)AA  A33AAAA{A  AApAA\AffA	GA  AA33AAAA=qAffA  AAffARA{A!A!pA QAAA(ApA
AQA(A(A
AAzA33A33AA33AzA (AHA (@@A@33@p@
@Q@@QA zAA (@AAAARA (A=qA\A@A33A  ApAR@\@@\)AA\)A33AffAHA\@(@@AA
=qAA
=qA  A
AAA33A\A
AAffAQAA=qA{AHA
ffApAAA\)AAA\)AA#
=AffA
AGAHAGA
=@RA%GA"=qAHAHA A\)A
{A
ffAA @
=@  @@ff@@p@=q@H@p@@=q@ff@@@\@@  @  @@@  @@@@@@
@{@Q@@
=@@p@
=@p@@@
@(@ff@  @33@p@@z@@  @\@  @33@@{@ff@
=@(@
@Q@z@@@ff@{@@(AAA A\)@p@ff@p@@HA AGA\AA\A A QA z@Q@  @Q@=qAzA   ARA
@@@AR@@@Q@\)@H@
=@@@ᙚ@@=q@=q@@ff@33@p@Q@z@\)@
=@ڏ\@33@G@ڏ\@@
=@Q@{@@p@@33@33@ڏ\@ڏ\@G@ٙ@@Q@׮@׮@ָR@  @ٙ@G@ٙ@أ@@ff@
=@@{@@G@H@  @(@\)@33@ff@p@  @{@@@R@HA{@G@QA@@z@QAQARAA	AHAAAA @\@p@H@@@@Q@Q@p@@\)@@
@@Q@A QA @@@R@\@@@H@@33@\)@@@ff@
@p@@@  @p@
@
@@@ff@
=@
=@@(@
@=q@@@߮@Q@\)@\)@
=@ff@
=@@ff@\@@=q@
=A
@
A
H@R@z@@@@H@G@p@@R@\@@
=@
=@@z@
@
@\@\@
=AGAApAffAA@H@p@H@ff@ff@33@
=@H@@
@pA zAAGA\)AAA  A(ARAGA33ApAAA   @=q@ffA   @@p@z@@{@@@(@@=q@@@@@{@@z@
@  @=q@ڏ\@
=@ָR@
=@p@ff@(@{@\@
=@@z@ۅ@ڏ\@p@ff@ٙ@Q@@ff@@@Q@G@H@@ff@Q@=q@z@33@G@G@33@@
@z@@@=q@  @p@@ff@zA (@@
=@G@
@@G@\)@33@H@(@R@@\@p@H@H@
@33@33@\@33@
@H@\@RA@  @@@
=@@@@@@ffAffA{AHA\@R@{AffAzAA A
=A@@@@@@@Q@=q@
A A zA A@@p@@R@R@zA   @@G@@@ȣ@ȣ@ə@H@33@θR@@H@G@33@(@
=@\)@\@@\@@{@33@z@ff@@=q@  @33@  @@{@33@=q@@\@@@\)@@@@=q@H@
@H@@{@@@@=q@Q@Q@z@Q@@p@
@@Q@Q@H@
@@  @@
=@ff@ff@ff@@@@R@
@(@=q@
@R@
=@  @=q@@p@\)@
=@@Q@  @@\@@@Q@Q@G@
=@
=@陚@33@33@@\@Q@\)@ff@R@  @=q@33@{@@(@=q@@@@p@@(@@@@\)@@@\@\@33@@p@
=A A A A ApA zA @p@@
@R@R@{@(@H@  @@\)@\@@R@33@@\)@ff@
@@
=@{@
@(@G@@Q@@@@ff@H@@ff@\)@@Q@Q@  @@@=q@H@@@@R@Q@@@H@@@(@p@@R@{@@ff@@\@H@@Q@@@@G@@@@  @\)@\)@\)@@=q@\@
@@33@@@\)@R@{@H@\)@\@@@
=@@=q@@=q@33@@@
@33@@@Q@@p@{@  @@@@p@  @陚@\@H@@
@@G@@=q@\@@@\)@@@\)@G@H@@G@Q@@(@@(@  @p@(@
@p@{@
=@{A\@R@@ffA (@
=@H@@33@@\@ff@G@z@H@=q@
=@\@=q@z@@(@{@@33@\)@H@@@Q@@@
@z@G@@G@@{@  @R@@33@(@\@@33@H@@\)@@
@@G@@G@R@@=q@  @陚@  @33@  @z@@p@R@z@@@@@H@@ff@\)@@@pA   Aff@Q@\@\)A=qA(AAffAAA
{A
=AffAARA33A
A	AA AAAA  AffA{AAA\)A{AQA
pAAHA=qA
=AAAAGApAffA
A=qAAA=qAR@@ff@@\@p@R@z@@ffA A=q@\@@A
AQA	AA(AAff@RA AAAH@  @@ff@A@ff@(AHA
=AffAGAzA33A
=A	AA=qA\AA @  @߮@z@@(@@@(@Q@
@\@
@\)@@z@R@(@@p@{@p@{@
=A QA ApAffA33AA(A
=A\)A\ApAGA (@A  A\A\A
=AA	AARA@G@=qAH@\@R@  @G@  @陚@陚@@@@\@(@{@@
=@@@33@(@@@ff@  @@{@Q@p@@Q@@(@@RAAGA  ApAAGAA33A\)AzA	A	A	GA	A33A@=q@=q@H@
@p@{@33A   @AAAQA\)AQA
\AAA=qAA\A33A
AQA\AGAA  A\AA   A$QA!GAA!GA"=qAA$A$QA&HA%A\)A QAAA
@R@33@@ff@ff@@\)@@@@{@ff@H@=q@(@@@33@
=@R@G@(AA=qAzA\A A\A=qAQAAAARAAffA33A(AGA\)A{AA
A
=qA	AA	A
RAHAA  A(A\A33AAGAG@A
=AffA(A@
=@@33@@@=q@
=@@\@  @
=@
=@{@\@@z@ᙚ@ᙚ@@=q@
@\)@33@33@@@@(@@@Q@  @  @@=q@\@=q@@33@(@@(@R@Q@ff@Q@H@@@p@@ff@
=@
=@ff@ff@
=@\)@  @ff@@z@\)@@p@ff@R@{@{@p@p@@ff@  @=q@Q@z@z@R@@Q@p@
=@@\)@\)@@@@
=@{@z@@
@
@@H@G@Q@  @  @\)@@߮@@@(@޸R@@@(@33@@@ۅ@@  @\)@
=@
=@  @@Q@
@
=@G@G@33@H@  @@@@Q@G@=q@@@@@@H@33@\)@@\)@R@@G@@\)@@@H@@@\@33@(@@p@@@\)@\@(@@Q@=q@@@@@z@z@33@(@33@H@@  @Q@  @{@
=@(@Q@\)@{@(@@  @ff@p@@ᙚ@@ᙚ@G@@@@@Q@33@z@\)@@
@=q@@Q@\)@{@@\@G@@R@G@Q@z@
=@@
=@Q@
=@ff@(@\)@(@
@\@@  @
@(@{@@@\@@  @33@\)@(@ff@ff@p@@ff@
@R@
@33A (A z@A AffA(ApAffA33AffA	A
RA\)A{AAAA
AzAAA
A{ApAAzA33A  A  A=qAHA (@Q@\@{@(A
=@H@\)@Q@33@p@Q@z@33@(@H@\)@=q@@@Q@\)@@{@@ff@p@@@G@H@@@=q@@@@  @A\ApAAAGARAA	GAAQA(AAA
=A	A
A
HAzAAAQAAAA"=qA$A%A)GA)pA"HA%A#
A&\A)GA)A'
=A!AAAAA A33A
AQAAA=qAA
A
=AzAzA
RAAA
ffA
HAzAffAffA{AA\)AA33AA @\)@@@33AARApAffA\)A	GA	pA
=AQA
HA
RA
\Ap@\)A@ffARA (@\@@@{@@Q@\)AH@A33@=q@ffAR@GA\A A@A{A\AAAA
A{A{A\AffA\AAHAffAAzAffAApAAApA=qARAA
AAzAAA{@\)@@
@@@QA @@
=@@@\@GAApA (@@@@{@=q@@R@ff@R@p@{@ff@p@\)@ff@  @
@R@
@H@G@33@@(@@R@G@R@R@\)@(@\)@
=@
=@G@\@  @(@@33@
@@G@ff@  @
=@=q@p@\)@@z@
=@R@H@H@z@ffA{A=qAG@@@R@z@p@@  @\@@\)A zA A   A A A QA (A @RA zA A Q@A   @\)@  @{@=q@(AH@{A (@
@G@@@  @R@@@=q@@=q@G@@@z@@R@@G@@\@Q@  @\)@ff@@@H@z@33@Q@@{@R@G@陚@陚@@=q@H@  @@\@@@Q@@=q@33@z@H@R@z@
@G@  @@\@陚@=q@=q@z@=q@@\@(@@
@
=@\@@A33A  AQA(AAA33AQA\)A	A
{AA
{AAA(AHARA=qAAA ApA QA Q@A   A   A A @(@\)@
@
=@@H@33@\@=q@@@Q@@@@\@
@(@H@@@@
@p@\@z@G@Q@33@@@=q@(@{@
=@\@@ff@\)A   @
=@zA Q@(@{@{@{@ff@ff@ff@z@@(@@ff@H@H@A AAA  A
A(AHA\AA33AARA  A(A=qAA
GA	AQA\)A	pA
{AzAQAA(AzAzAAA=qAAGAAA (AAQAAAA33A (A@A	pAffAA
HAA\)ApA{A  @pAffA@33@@R@
=@=q@  @\)@@@@{@
@
@@z@@A
A QA@
=@33@
@
=A A @\@ff@\)@\)A A QA@{@@z@p@\)A AA\A
A  A=qA(A
RA
pA
A\AQA{A\)A
AHAAffAQA\)A
\AAAA @
=A=qAA   @Q@33@
@@@A
ApAApA33A{AARA{AAGA33AA AffA   A Q@\@=q@Q@G@@@Q@33@@@p@@@=q@Q@ff@
@ff@{@
@@@G@H@(@@
=@ff@@@Q@
@
=@{@
=@@@
@@R@@@=q@Q@G@33@z@G@
A\)AGAARA
{AQAffA(AHA=qAzAzA
=A
=qAA	pAQAQAA
=A
=ARAAQA\)@@  @z@@ff@{@\)@@p@(@z@=q@p@{@@@@  @@@=q@@ff@@@
=@
=@@@@=q@\@33@33@@33@(@(@p@@p@ff@@33@z@
@33@G@z@R@@@\@@@
=@ff@p@
@33@33@\@=q@=q@\@
@p@ff@@@=q@33@z@p@{@R@A   @\)@\)AffA QA=qA=qAHApA AAA\)AAA Q@R@p@
A QA Q@ff@z@G@R@@
@{@@
@
=@ff@(@@ff@R@@@=q@H@@ᙚ@
@ff@ڏ\@@޸R@{@@  @\@G@R@R@R@{@{@@\)@@@  @@p@ff@@=q@@{@H@\)@AARA QA Q@@33@
=@\@@@{@陚@p@=q@AA@@@@=q@H@H@z@(@A\A
=qA
HA
HA
ffA
=qA
=qA	AAzA	A
\AzA
HAA A   @H@ff@\)@@=q@p@@
=@@A@@@@@
=@
=@\)@
=@  @p@@R@\)@33@Q@\@(@ff@
@{@p@@@
@H@H@\@@p@33@R@=q@H@G@
@@  @@ff@{@@zAA\AA
=A(AA
AAA=qA=qAAA  AffA\)A\)ApAHA33AA	pA
RA  AA
AAAA$(A%A(  A"HAARA  AQ@(AAzA{A	GARA @pA  @p@RA @R@R@@@@@z@G@{@@AG@@@@
=@R@H@33@R@@Q@H@{@G@@z@@@z@@@Q@  @H@@@33@  @A   A=qAARAA
A
AAQ@@R@pA
A
HA
GA=qAAQAAA!AA (A"{A%pA)GA+
A*\A*{A&HA,(A*HA,  A-pA,A+A*=qA(A
A!pA$AA)A A!A
GARA
=ARA@
=@H@@=q@z@@(@@
@@
@
@(@@@@@
=@{A@{@
=@zA @@\@G@Q@33@@(@@ff@@@\)@p@@@R@
@p@
@(@@33@{A\@{@HA
=@\@@ff@\@A  A	A	A(A
=A{A{A
=AAzA
AA
=A33AGAHApA\ApAAA  AAzA{AzA=qAAA\AAAA
HA(AHA
AAffA\A\)AA\A{AAffA(A=qA33A	pAAHA	GAAQAA
A
{AQA   @=qA Q@ff@33@@Q@@ff@p@A@{@G@@z@p@z@@HAQA@33@AAA	AA
pAGA
=A=qAAGA(AAAAA(A33A(AzA
A
RAz@RA(A@
@R@33A{A
AffARA\AApA  A{A
A\A	AAQA
ffA33A
RA  A
=AAAA\AGAAA\ARA\AAApA33A{A33AA
=A@HA=qAGA @33@=q@\@33@
=@@@zAG@@\@@=q@H@ff@  @@@R@R@
=@@=q@33@@H@33@
=@@\)@  @
@(@(@
@@z@
@p@  @=q@\@(@@H@H@@@p@@@z@@=q@R@
=@
=@
=@(A   @=q@@(A=qA @\)A33A (A (@{A\)@\)@R@A33AffAHA(AAA (@@z@@Q@Q@@\)@
@\@@@@p@H@\@G@޸R@@@\@@@@ڏ\@ڏ\@߮@陚@=q@陚@\@H@@(@@@Q@R@
@  @@  @  @Q@\@p@
=@33@G@=q@@A@\)A{A (AAA(A(AA
=qA
\AQAQA  A(AzAHAA(AQAGAAARAffA\A  A(A
HA	AA33A
HAA{AzA
pARAffA
=qAA	AA
=qA	pA\)AAA{A AA(A@HA
=@33AGA @@@@@p@\)AAA@Q@G@\)@@@\@{@ff@ff@@
=@p@\)@\@
=A=q@HAp@{@
Az@(A @@@\)A=q@ApAHA
AA QA\A	pA
pAA
A33AAzApAAA
=AAAAAzA\)AA%A&=qA*{A-A-A+A(A%A"\A\)AzARAA
\AzA(A\)AA
{A
HAAA(AAAA
{A	A\)A	pA
ffA  A  A	pA(AAR@A @H@A\)A\A33@\)AQA
A  AA  AAAGA33A  A33A   AAAAAGA  A{AzA33AGA(A@(AA	AA{A
RA33AQAA\)A33A{AGAAAGAA\A  ApARAA"{A#\)A%pA$QA*=qA-GA/33A1GA3
=A2\A2\A0A.\A$A (AAHA33A
AAA
RA	pAQA\)A33A=q@G@Q@
=AHA	AA
AA	pAGA A33A
=@@
=AAG@(A   @\)A=qA\A
A\)AQA(A\)A\)AApAA(AAQAQA@@H@@\@@H@\)@@zA z@\)A   AHA(A  A{AAA\A=qA\A{A  AA\)A
=AA	AffA33A
=A
=A	AAAA33A z@@R@  @@@?
@A	p@@H@\A AffAA  A33A
=A=qAffA
=A=qA\A\ApARA
A  A(AAAAA=qA
{A
=AzA=qA
A
AQAA  A	A\)A(AA  A  AHAffAAffA{@\)@
@@Q@  @@陚@\@\@@@@  @@{@@@A   A{@@@33@@\@@@@@
A=q@@@=q@陚@@@@@R@H@@\)@(@
@@\@(A zAA\AffA
=ARApA
=AARAQA\AQAA\)A
A
A  A
=A	AQAQA	A(AQA	A\)AAA
=AAQA\)AHAApAp@@@@H@
=@@@@@(@@=q@@AQA
=@A@@@@G@{@@\@@@33@{@\)A A\)AAA	GA\)A\@@R@@
=@
=@R@@@p@@(@
@@@z@z@G@Q@  @(@=q@
@ff@A z@@
@{@\)@@@R@@
=@G@H@
=@ff@@RA QA (AA{AffARAA33A
=AA  A  AzAQAQA  A(AQAQA
A
AAAAApApAGAzA
A
=A\ARA{A
=AAAA=qAR@@(@(@
=@33@=q@\)@  @@G@\)@@陚@\@  @
@@\)@@z@(@AGA (AHAffA  AQA  A
=AHAA A zA@@
=A A=qA\)AApA(A	GA	A\)AzAA
AA
A
=A=qAAApAQA
A\A A   A Q@z@ff@(@@=q@陚@Q@陚@ff@R@R@@=q@\@@33@@H@H@(@@\@\)@Q@@@{@p@@@(@@@
=@Q@  @  @@33@@33A AA\A  A	AA	A	pAGA
=qA
=qAA
=Aff@p@@@߮@@  @
@ff@z@{@@ff@@@@Q@\AHAzAA(@\@(@(@@R@H@R@@z@\@@@{@@@H@=q@\@@  @Q@}p@|(@|(@y@zH@z=q@x@x@y@z=q@y@zH@z=q@{@y@x@zH@zH@|(@|(@~{@\)@@@@@
@
@p@ff@@(@p@@z@@zH@y@xQ@u@q@nR@i@e@]p@Q@I@@@6ff@-p@*=q@%@   @p@@@@
=@Q@@@@@p@\)@\)@R@{@H@@(@@=q@=q@@Q@
=@@z@\@@@
=q@@33?(??
?Q?Ǯ???H??h?:H?>33>B\=\)=#
=u=L=\)=\)=u=u=L=\)=
=\)=u=#
>\)>>z>\)>>k>k>L>#
>>>>=>\)=G=G=Q=Q=Q=\)=\)=\)=u=u=u=u=u=L=u=L=L=L=L=L=#
=#
=#
<<<<<<<<<
<
<
<
<
<
<
<
<
<
<#
<
<
<
<
<
<
<
<
<
<
<
<
<
<#
<#
<
<
<
<
<
<<
<
<
<
<
<
<
<<<
<<<
<<<<<<<<<<<<<<<<<<<<<
<
<
<
<
<
<
<
<
<
<
<#
<
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<
<#
<#
<
<
<
<
<
<
<
<
<
<
<
<
<<<<<<<<<<<<<<<
<<
<
<
<
<
<
<
<#
<#
<
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
<#
    <#
<#
<#
<#
    <#
<#
<#
            <#
<#
<#
<#
<#
<#
                <#
<#
<#
    <#
<#
<#
<
<
<@G@@@A A
=AA
AAAA\)AA	GA
HA33AA
A
GA
A
=AAARAAAHA
AzAzAAzAAQAAAQA  A  A
A(AARA\A(A
pAA
=A@G@@\@@R@@z@A   @p@z@@@@\@=q@ff@
@H@zAff@{AA @@H@z@ff@(@@{@@\@
=@H@33@\@  @@{@p@
=@@\A A A\AAGA
ffA(AQAzA
GA(A33AffA
AHA
A(A
A
AA{A\A\AAzAQAAA\A33A\)A(A  AQA  A\)A\AAA\A\)ARAHAQAA33A33A\A\)A @@R@p@{A @@@@ff@33@@ff@33@R@{@=q@G@@
=@@\@\@@33@@33@
=@@@@@R@z@p@H@@{@R@A z@A{AAffA\AffAzARAA{AA AA	A
{AAAHA(A	AA	AHA  A\)A
=A33A
AAA
A{AHAARAA\AGAQA	ApAzA\)A
@@{@@A z@R@
=@@\)@
=@
@@A (@@AAA33AAzAA\AA @A (@A QAQ@ff@=q@G@
=@
@z@{@@@@(@@@R@@@  @Q@33@A@RApA33A=qA33AAzAffA=qAA\)A\)AA(AA{A33AA\)A\)A  AzAA
\A\)A
AA
A\)AzAGA{AGAffAHA\)A\A\A  AA33AHA
AAAAQA{AAGA A
@@ff@=q@G@@z@(@
@
@@33@@
@@p@@ff@@ff@@=qA @G@@
=@p@@{@z@@p@@@p@@z@p@@@z@@@R@\)@
=@\)@@{@=q@  @ff@G@@ff@  @
=@33@@ff@{@  @A A
=AHA
AAA	pA	A
=AA
A\AAAHAQAAA  A33AAAzAQAzAQA
ARAHAffA=qApA\)A
A
RA
ffA(Az@@  @G@
=@
=@  @Q@33@Q@@G@\@@\@
=@Q@@@p@z@ff@@RA (AffA(@@H@Q@@=q@@(@33@@Q@  @@G@@
=@@@
@@R@ᙚ@{@Q@G@\)@Q@@p@  @@AGAffA A
AffAffA z@R@ffA(AffAAzA AA\)AARA(AAQAA
A
A
AAzAzA\)A33AAAA\A=qAA\A33A=qARA@p@@=q@=q@@(@33@{@(@  @@G@@=q@@ff@@@@G@@@H@  @p@ff@\)@@@@@@G@=q@33@陚@H@(@p@R@G@@\)AffA QAG@(A
A33A
=@z@pA AA33AA	GA
ffA
{A	AAQAzA(A\)AHAApARA\A\AAA	pA	A(AAA	A
ffA	A
\A
{A
=qA  AA
AA
A33A	pA
=A\AHA  A
A
=A\AA{A (A A @\)@@\)@
@@p@\)@R@@{@@@33@@@z@(@@@@Q@Q@@(@@\)@
=@p@@@
@@@H@
@@33@=q@33@\@@33@
@
A QA (ApA A
=A\A{AAAA  A  A33A33A
=A\A(AzA	GA(AA  AA  AffAARA
A(A(ARA	A  AHAAA\)A{A
=ARAAA{@Q@@@=q@(@@@{@H@@=q@@@  @@33@@z@@(@p@@@
@33@@p@ff@=q@=q@@=q@33@(@ff@G@z@{@Q@(@\@陚@@G@@\@H@@  @@p@@@@p@{@@\@ff@Q@@@G@z@p@@R@  @
@z@(@@33@33@33@@z@@@@G@H@@@@
@
@
@@33@@\)@@(@@33@33@p@R@ff@@@Q@
=@ff@@@z@\@@ᙚ@@@޸R@\)@{@Q@@@޸R@ff@  @
=@@߮@=q@  @Q@Q@@@ᙚ@@33@
@\@H@@陚@Q@=q@
@޸R@\@z@{@\)@Q@{@R@@@@p@
=@@
=@p@@=q@ff@\@z@=q@(@@\)@RA   AGA
A33ApAA
=ARA=qA{Aff@@R@@\@G@@@H@@z@@@@@z@
=@{@\@z@=q@@p@p@@@@z@ff@Q@@
=@{@@@p@{@ff@@@33@\)@@@\)@\@@=q@33@=q@@(@
@@@
=@@@\@@@H@@=q@@33@@@zAAA\)A  AQAA  A\)AA QA   AffAAA
ffAAQA	GA	A	GA(A\A\)AGA{AApAQAffA{A  A
AAA
AAffA@@\)A@{@z@\)@  A\AAA(AffA
=AAG@ff@\)@(@  @z@{@Q@@G@H@G@@@@\@=q@@@\)@
@(@
@@@
=@G@@z@@{@@z@@(A   A (A
=A\A=qA33AA  AAAARApAAA
=AHA
=qA	pA\)A
AApA  A
HA	GAAAQAzA{AA{A
pAA
AA A QA A	pA@{@@
@Q@
=@@@@33@ff@(AG@R@@{@  A\)@\)AA A(A  AR@\)@@{@ff@@@@@p@@@
@33AAz@\A@@@Q@
=@
=@=q@
=@=q@@@@33A (@A Q@\)@\)@=q@QA
=AAAff@@
=@p@@(@RA @\)@GAAAA=qA\)A
=A33A
A  AQA	pA=qARA{A=qA=qA(AAA\AHApAApAAA33A33AA@@33@@{@@R@ff@(@33@ff@
=@\)@陚@@@{@p@@@@@@@@G@Q@
@H@
@ff@{@
=@(@@@@
=@\)@z@@@(@H@{@\)@@(@@Q@z@\)@ff@@{@z@{@
@@@Q@@@@G@Q@Q@@H@\@(@@R@R@@R@
=@
=@p@R@\@
=@  @\)@ff@@H@@
@@@@p@z@@@
@33@\@\@\@@Q@33@
=@
=@@@@p@
=@ff@@@
=@p@
=@
=@\)@@33@=q@G@\@G@R@ff@=q@@{@ff@@@(@@
@@@R@33@p@p@@ff@A@@@p@
@@G@@R@p@@
=@\@Q@@33@@@p@p@@{@{@{@ff@@\)@Q@@@G@@  @  @=q@H@@G@R@p@  @z@{@
=@
=@R@
=@(@@陚@@  @Q@{@@@p@
@(@\@(@ff@@
@@(@z@@@z@p@(@ff@\)@@{@(@z@H@@(@@@ff@\)@z@ۅ@\)@Q@
=@Q@\)@p@p@ۅ@(@=q@ᙚ@޸R@  @Q@33@
@
@@{@
=@\)@\)@@\@(@@
@z@Q@R@@G@=q@
@H@@@=q@H@H@33@@(@z@(@(@
@@=q@G@R@{@\@
@@G@33@H@R@{@33@陚@Q@
=@R@{@R@\)@@R@\)@\)@z@@R@
=@R@\)@
=@@(@z@33@z@R@R@ff@@(@33@H@ᙚ@=q@=q@ᙚ@=q@Q@Q@\)@  @߮@  @@Q@@\@33@Q@(@H@@z@z@\)@G@  @陚@@@G@@\@\@陚@陚@G@陚@@@=q@H@H@@
@@@@
=@p@z@@(@(@H@=q@@H@@ff@@33@@@G@G@@ᙚ@  @߮@@  @ᙚ@H@@Q@@G@=q@=q@@z@@ff@\@  @޸R@ڏ\@{@z@@(@߮@
=@\)@
=@p@p@@p@@@H@@@
@\)@޸R@\@޸R@ff@޸R@ff@p@޸R@  @G@33@ۅ@z@ff@߮@@ۅ@z@߮@@ᙚ@ᙚ@\@H@33@
@@@@
@(@p@@33@H@z@z@@@p@@@p@@p@@  @@H@陚@p@(@\@ᙚ@ᙚ@@
=@
=@
=@  @
=@ff@ff@
=@@\)@ff@
=@ff@߮@@\@(@@ᙚ@@@p@@H@@=q@33@\)@
@׮@\)@׮@@أ@@أ@=q@
@Q@Q@\)@
@ڏ\@(@@ۅ@ff@@33@ۅ@(@{@@
@H@(@(@{@R@R@\)@Q@@陚@=q@33@
@z@@@p@@@@R@Q@R@@@@@R@{@z@
@@  @  @R@
=@R@R@p@33@=q@@G@\)@ff@@ᙚ@@G@@
@p@p@=q@(@@
=@@@Q@G@@@H@{@Q@@  @
=@ff@R@R@=q@(@p@p@{@@@33@33@(@H@(@@p@@33@(@z@@@\)@H@@@{@@@@@Q@@@@G@@H@\@H@z@@@{@@@@=q@=q@
@@@@@@@@@G@=q@
@@@\@R@@
=@\)@R@@@@Q@
@G@Q@z@@(@G@@
@@=q@z@@33@z@{@ff@A
=@@
=@@=q@
@@@@@@33@
=@
=@p@@R@@@@33@z@33@@@R@
@{@(@33@G@{A (@
=@
@z@z@z@p@\)A A   A zAGA33AGAAHA
AAQAAGAA
ffA
pA\A
pAA{A
pA
A	GA\)A
=qA	pAzA
=A
AA@(@@  @\)@  @@\)@Q@R@\@ff@@@@z@R@@@p@\)@@ff@@  @@
=@=q@
@
=@@z@=q@@@ff@p@@@(@@@
@@R@@33@(@@\)@R@  @@@@@
=@@
=@H@@\)AAA33A\)AAA\)A	A	AQA
ffA(A\A@R@@@A(A\AGAAARAGA z@\@A (@@=q@
=@\@z@{@
@{@@@33@@\@\@ff@
@@
@G@H@=q@Q@@=q@z@H@R@
=@R@33@z@ff@@\)@
@z@
@@ۅ@Q@p@(@ff@G@ff@H@@@(@Q@  @33@@  @=q@p@(@=q@ۅ@=q@33@@@ff@=q@@A AffA\AA
=AA
=ARAffA{A\A=qA\)AQAAAAAAHApAAARA
=A zA QA (@@@@(@ff@(@G@G@陚@@\)@ff@p@R@@
@
@=q@@=q@(@@@(@\)@
@
=@@G@@H@@  @=q@\@@33@@@(@=q@H@Q@@
@Q@=q@ҏ\@љ@z@(@z@@أ@33@׮@ۅ@  @
@33@ff@@
@@@G@@33@{@@
=@@@(@@{@p@AHA   A AAffApAzAGA (A33AAAp@ff@33@H@z@@zA\A
=@\)@RA@@{A{@@{A Q@@@
=@(@@@@R@@33@=q@(@@@{@
@\@{@33@@=q@\@@@@(@@(@33@(@G@陚@=q@@@{@
=@@@@=q@{@\)@ff@R@(@RAGA\A
AGA33A
AA
RA
pAAAA\)A{AQA
=A   A!A$(A%pA%A&\A(QA(A(zA%A%pA!AA
=AA(ApA{A
ApAApA\AffAGAAAARAQA  A"\AA\)A
AA   AzAA
=AzApAA{AA
{@@
AAA{A=q@Q@{@z@@\@@G@
@@\)@{@zA A AA   AHA\AAAARA	AAAAA=qA\AAAGAffA
A\A
AQAAAA{AA(zA,  A&=qA*\AGA\)A"\A%ARA=qA\)A
A  AAA\)A
AQA	A	pA  AzAzA
=A
AQA(ARAAQA
A
ARA
=AAA
A
A
A(A
{A	AAAApAApAAApAAHA
=@
A{A
ffAzAzA	pA	pAQA33A (A Q@33A AAAGAA  A{AA A AAp@@pAGA A QAAA	pA
A  AARAAffA\)A
=qAA	A
A
pARAAApAHA33A33A(AA
AAAzA
=AAAGA(AA
GAA   @\ApA\AffA
=qA	pA
A
A
A
A
GA
=AA  A  A33AA A33A\AGAAQA33AAHARA=qAAHA
=@RAA33A{A\A @p@@@
=@
=@Q@=q@H@Q@G@@@\@@@@\)@AffA
=AR@z@p@(@@@R@p@@A (AAAAffAAA{A33A
A(A	A	A	A
HA
AAA{A
A  A\)A33A=qA{AA\AA{@@@Q@@@G@@@p@{@(@Q@@@陚@
@
@@\@\)@@@R@Q@@@
=@33@=q@33@\@@Q@\)@z@@@@@=q@ᙚ@\@@@H@@{@p@=q@R@  @\)@=q@(@p@@  @{@@Q@\@  @Q@33@
@@\@H@@{@@z@z@@A QA AffA{A
AHAA	GA
HA
\AzA{A  A
pA{A
{AA
RAA
=A=q@\)@ff@@z@@\@(A A\)@
=A@
@@A@{@A (A@A   @@\@
@z@@@z@
@
@@(@@@R@@  @@ff@߮@z@@ٙ@  @Q@@@@z@p@陚@@@(@ff@Q@H@
=@
=@@p@=q@z@G@=q@  @=q@@@\@\@\@z@@=q@  @\@ff@
=@@R@\)@Q@G@@@33@z@{@
=@
=A AA (A zA (A   @@
=@\)@(@@R@z@  @H@H@z@\)@=q@@@@ff@@@{@ff@@@@ff@@Q@@{@  @\)@z@p@@=q@H@H@@\@H@{@G@G@@=q@
=@@H@p@H@@(@@G@G@\@@\)@p@H@(@Q@ff@
@@@  @@  @@(@@@@ff@
=@@@@Q@A zAApApARAffA\A{A (@@@@@@{@@@p@{@33@@Q@
=@p@z@  @p@@z@  @@{@@
@{@H@\@@Q@@@@\)@@@Q@
=@Q@  @G@@ᙚ@ᙚ@@ᙚ@p@@@@33@(@(@@@@
=@@@@Q@  @33@@@\)@@G@H@(@@ffA (A   A zA AGA=qA
=AAA\AAzAGAA33A
=qAffA{A  A
=qA
HA
{A\AAA33A
A  A@@
=@@33@G@
=@@ff@R@@p@(@Q@\)@
@߮@z@33@@{@
=@@=q@G@R@@R@@@{@@33@@\)@陚@Q@R@33@ᙚ@޸R@  @@{@@z@H@z@H@z@p@Q@@@\@ff@R@ff@@33@p@  @@Q@
@
@z@
@
@33@@\@=q@H@
@z@
@@p@\)ARAAAAQAA  AA
A\A  AzA  A
=A
{AH@@  @@
=@\)@@G@(@@R@\)@R@@
=@
=@\)@
@@@Q@
=@޸R@\)@޸R@@ff@G@ᙚ@G@ᙚ@Q@߮@G@33@  @@@  @=q@@@\@ᙚ@z@=q@H@陚@@p@Q@  @@R@z@
=@@@@G@p@H@
@(@@ff@H@z@ff@{@H@@@@G@{@R@zA zAAA @\)@@=q@@@@=q@陚@(@33@\@QAp@@=q@\@
@  @\@{@33@H@(@33@Q@R@33@{@@(@\)@R@R@ff@z@H@
@\@@@@@  @p@ff@@ۅ@
@ۅ@ڏ\@=q@ٙ@G@أ@@@ָR@@@Q@  @Q@׮@ٙ@@p@z@{@޸R@޸R@@{@@@\)@G@@@{@  @@@@@@R@@p@@H@@ᙚ@@
@Q@\)@33@
@@
@\)@@  @Q@@\@
=@=q@z@{@z@@\)@(@
@@
@=q@@
@(@
=@
@陚@\@\)@R@p@@
=@
@
@@ff@H@ff@@@@p@@R@ᙚ@@ᙚ@@G@Q@33@@\)@޸R@{@ff@ff@
=@  @Q@@@@@@z@ff@@  @=q@z@33@G@
@@=q@@=q@
@@ff@Q@  @@
=@@Q@@@@(@
=AAA=qAAAGA=qA\)A(AA  A\)A  AQA
=A
AzAzAzAffAAAA\AG@\)@33@@
@  @@=q@@=q@\)@Q@@z@33@
@=q@@@z@
@@(@33@G@
=@Q@\@@@\)@@@(@
@{@{@33@R@ᙚ@ָR@ٙ@@@z@
@ᙚ@@@z@H@@߮@
=@@@zAA=qAHAARA=qAAA33A
A
A33AAGA=qAzA\AAA\AA
=AGAHAHAA=qAzAffAA
{A
AzAGA
=A zA{AA\)A Q@
=@\)@33@@@@@  @Q@33@@
@@@@@ff@ff@@pA
AzApA(@A (@H@H@@R@@33@p@
@@ff@\)@H@(@Q@G@@=q@\)@@@H@=qAR@@G@{@@\@p@
=@p@=q@@@p@@{@
=@
=@R@=q@z@@\)@Q@\AGA{AA\A@@
=@@ff@@(@z@
=@@(@R@p@@z@
@p@(@@H@@ᙚ@@@@ۅ@33@(@z@(@33@z@@z@33@33@33@H@H@33@@
=@\)@@ff@
=@
=@z@@@
@޸R@=q@33@(@
@(@@@@ff@G@  @G@(@@=q@=q@@Q@@(@@33@(@R@@A (@
=A Ap@@@H@=q@ffA (AAHA33AA=qA=qA33AAHAApAzAHAA  AAA
{AGAA   @@@@@
=@@陚@@
=@
=@  @@p@@z@33@(@
@
@p@=q@Q@G@
=@G@陚@z@@p@
=@p@
=@
=@=q@
@
@=q@G@
@@R@@\)@߮@  @ᙚ@Q@z@@
@@33@
@\@z@@p@@z@33@@@RA QApA33AA  AzAQA\)AAA	A
=A
pA
GAA
AAA
AA
A
A  A  A
=ARA\)A
=A\AffA
AA
@GARA QA@Q@@G@ff@z@@z@{@{@=q@H@  @\)@@\)@  @=q@陚@(@R@ff@@z@@z@  @@@\@@@{@@z@H@
=@G@@@Q@R@\)@@(@R@G@HA@G@@=q@p@zAA  AA{AAAAAApA{A\AffAA  AQAA\AA\)A(ApAHA(A	pA	A	A	A	A	AA	pAQA
=AA	pA
=qAHA  A
{A\)@@ff@  @H@  @
@H@R@@G@@@R@\@33@@33@33@@p@Q@R@@z@  @
@@{@  @{@@@@@@{@{@{@
=@  @=q@
@@G@
=A   A @@ff@R@p@ff@\)A (AAGAAp@(AA\@RAARAQAAHA
=qA  A
A
pAA=qA  A33A
{AAA(A
=qA	A	AAA  AA	AHAAApA=qAAAAAA  A\@=q@\@ff@A
=A{A (@@{@p@@@H@G@@  @G@\)@
=@@@@=q@@33@@  @  @\)@G@@@@@(@z@R@ff@@@{@Q@@\@\)@A Ap@p@\)@@A (A\)A(AffA
=AffAQAzA=qA\)AA
AffAAAAAA
=AffAA
=AA{AAAAAHAAGA(A33A(AAAffA(A
A=qA33AQA{@R@G@G@\)@ff@z@(@\)@@ff@\)@H@@{@@@HA=qA(A@@\)@@\@@G@z@H@  @\)@z@@p@\)A33A AffA{A @\A=qAzA  AffA
=A\ARA{A\AGA  AAAffA  AAA @ffApAARAAHAA
=AA
AA
pA\)AAGAHAHAA
A
A33AA(A@33A @
=@(@
=@@  @@@z@{@\)AA zAQA\)A	pA33AQA
=AAQAAA33A	AA(A
A{A
=AAA(AA@@R@  @=q@33@H@@=q@{@z@A33A33A\)AAAApAA@@z@@  @
=@@z@\)A (AQA  AAARAffA\)A(AA  A\)@ffAHAGA{AA
=ARA	AA{AHA Aff@\)@\@G@33A   @z@@@\@G@Q@@陚@@(@Q@陚@Q@p@@\@@=q@=q@@@@H@@@=q@@@z@@R@ff@@z@@  @z@
@\@  @z@\@陚@Q@@
@@陚@@p@=q@ff@@
=@@@z@G@@@@G@\)A
=@@AHAA\A=qA=qA=qA\AffAAARAAHA(AzA(A33AA	pA	A
{A
\A	pA
=qA	ApAA
=A
=A{ApA@@@z@\@Q@
=@R@@@@p@33@(@=q@@33@(@H@@Q@
=@{@{@@ff@(@@Q@@@R@R@z@ff@p@{@@p@@@p@p@@@p@@33@H@@@ff@=q@ff@
=@R@\@
@33@@@@A   A A A A   A QA A AA\A(A=qAQA(AzAHAA\)AA
=A	pA	A	A(AzAAHAAAAffAffAHA=q@A @@
=@@{@(@Q@@@(@@{@{@G@  A zA ARA  A\@ffA   AAGAA
=A  @R@
=@@
@@=q@@@=q@@\@=q@@p@G@(@@@33@\@
=@@
=@
@  @@@z@33@\)@R@\@p@z@@A (A AApA{A{AHA
AzAAzAAA(AAQA
=AHAAAA33AHA A Q@@@@@@
@p@33@H@
=@@p@\@G@@Q@  @ff@\)@@@H@R@ff@p@33@=q@@=q@\@=q@@\@ff@\)@@@@@@ff@@
=@Q@@{@R@  @ᙚ@p@@@ᙚ@@(@p@=q@@G@
=@(@G@=q@ff@H@(@ff@(@(@z@H@H@H@@
@ff@Q@H@p@p@\)A QA zA   A QA A AGAGA @p@@(@33@\A z@@@\)@=qA@\)@\@(@@@\@
@p@H@@@Q@H@G@Q@\)@
=@p@\@H@@@@z@@@33@H@@\)@\)@@׮@ff@33@
@  @@@@(@R@ff@
=@G@=q@{@@p@  @\@@R@@33@@@{@R@@  @
=@
=@@=q@=q@=q@\)@@\@@  @Q@@@\@z@@R@@  @ff@A AAApAA A A (A @R@@@@Q@\)@
=@
=@R@{@@p@@@(@@{@33@ff@33@ff@@{@HA @@@  @@  @ff@
=@ff@R@@\@\@@G@
=@
=@R@@@Q@=q@  @陚@@@
=@R@R@
=@
=@@{@ff@33@
@(@\)@R@H@@Q@@@H@\@=q@@Q@@  @Q@Q@@@@@\@H@33@
@(@z@(@(@@H@33@@z@
@
@@@@@\)A Q@@(@p@=q@H@33@{@(@
=@R@@33A   @ff@ff@33@(@
@=q@H@@{@G@\)@@
@@=q@@@@  @R@@ff@@@@  @R@
@@(@G@\)@@@z@H@@@@z@@=q@@@{@\@=q@
@p@p@ff@
@z@@z@33@z@p@@@R@\)@ff@@A A A AAAAffAA A ApAGAA(A{AA=qAHA   AzA
=AffA\)A33A
A	AHA
=A=qA
AAAGAHA
=A Q@@33@z@@R@p@@@@G@@ff@@\@@@{@p@R@
=@@A z@=q@(A  A33A	A=qAzAzAA
@(AQA(AAAHApA A (@@\@@33@(@p@ff@ffA   @@@R@\)@{@RA   A QA A A{AffA{A\ARA AAAA=qA A AAAGAp@pA@p@@H@@(@@{@H@=q@p@  A A\)AAA\)@33@=q@@@p@@33@p@R@@33A   A QA{AA{AA(ApApAA QA @@@p@{@@@@@  @@G@\)@@@@
@RAffA AApA QA AA=qAffA\)A\)AAAA  AA
AAAA{ARA\)AA
A(AAAAffAAA\)A33AA(A(AA33AHA\)@@@ff@\@(@33@{@G@@@p@
AARA
AAQA zA @@
@p@{@(@@ffA zAAAffAA\@  @G@=q@
@@p@@=q@@R@@@\)A{A=q@{@
A=q@A
A   @zA
A	AAA AAAp@33@{@z@AAAGAAHA
AQAGAAAffAffA\)A33ARAA33A	pA\AApA\)AAA=qA Q@
=A33AA\AAA{AA=qA	A\)AA A  A=q@@@33@33@@\)@R@\@@ff@=q@@\)A33@@ff@ARAA
=AAA
HA	A\)A  A
A
A
\A
AAA33AAAG@
=ApAffAA  AAA\AA
=A(AAA	A	GA
{AA
HAA	pAA	A
A33ARA=qApAA=qA{AA33AQAA
\A(A	AGAffARA{A@\@R@ApAA\AA
=AAA  ARA
A
GA	A=qA  A
\A	A@
=A	AAApARAGAAA
pA	A33AA\@\)A   @{A (ApA\@@{@R@(A@ffA A   @A   AAA	A
=AA33A=qAAA	ApAA	A  AA  AA	AQAA
=AAzA  ARAAAAffAAAQARA\)AAA(A{AHAR@A (A
=AAffApAA\A	pA  A\)A\Aff@A	A{A   A   A  AQA A AAQ@@@Q@33@R@H@\@@@33@ff@H@p@G@
@{@  @@@@
@{@H@G@@@
=@@p@\)@ff@\)@=q@ҏ\@@@(@ָR@{@HApA
HA\)A
ffA\)A
=A
=AA
{AffA  A=qA  A=qAAHA\AAzAAARAGA(A\A"=qAGA&HA(A'A$A"ffAAAQApA!A"HA$A"HA#
A#\)A"HAHA!A
=AAA{A
A33ApAffA33A
ARAAAAA{AA(A
A
GA
pA{AzA	GAHA(AA
AAAzAffA(AA=qAzA\)ApAAA@z@{A	pA	A	GA
A AA\AA(A(AQAzA(A33AA (AGAA QAAHA\)AQAHA  A
A=qA=qA
AAHAA
AA  @pA @QAz@(@33A Q@
=A@\)@
@  @@  @@@H@\@\)@@@
@\)@\)@@z@
@H@@{@
=@@@\)@陚@Ϯ@
@@p@p@p@\)@@@
@R@R@=q@޸R@
@(@z@=q@@ָR@z@@\@Ӆ@p@\@
@R@\@H@
=@@
@\@G@@33@\)@(@@@@@\)@{@=q@=q@p@(@\@G@R@Q@@@  @\@(@
=@{@@@
@(@@Q@\)@
=@\)@p@(@p@33@G@ff@R@Q@Q@@@ff@ff@Q@@@G@\)@
@  @=q@=q@
=@
@
@
=@
@@陚@H@\@\)@@G@@
=@33@@G@@@\@=q@ᙚ@H@ڏ\@33@
@љ@\@ٙ@@=q@@\@ᙚ@(@H@H@=q@Q@@33@
=@G@Q@
@=q@33@=q@
@@(@@\)@  @
=@
@ff@GAR@(@
=@
@@HA\@p@@@(@H@  @H@\)A\)@Q@R@@ff@R@ҏ\@׮@@\@ff@33@陚@
=@33@\@@陚@p@@@Q@G@Q@@@@ff@{@@(@@z@@
@p@\)@R@@=q@@G@
=@z@@Q@  @\@p@@\@{@33@@@G@G@@Q@Q@Q@H@@
@=q@@@\)@33@
@{@(@{@ff@p@{@z@ApAH@G@@
=@
=@@(@z@@@
=@@
@\@G@@@Q@\)@@@@@Q@\@G@@@陚@H@H@=q@33@@=q@陚@@R@\)@(@{@(@{@
=@
@H@p@@ᙚ@=q@@(@{@ᙚ@@(@ff@
=@  @p@@@@
@ff@@R@p@
@@@@H@(@z@R@\)@\)A (@\)A zA A   A QA   AA=qARARA\)A  AGAAA\)A\A=qAARAAA33AAA
=qAA=q@ffAAH@@\@\@  @G@Q@G@33@@@@
@H@@Q@
=@
=@{@\@@=q@(@@@@@ff@@  @ff@@@33@@@Q@@@=q@@@  @@@33@H@R@(@
@
=@
=@@@Q@@\@@@RA   A QA AGARA33AAzAApA(A{A\ARA
AzAAA(A(AAA\)A  A  A33AAA
=qA
ffA(A	A	A
{AAQAAA\)A  AA\)A(A{AffAG@@A(A{AffAAAA(AA\A @z@\@@Q@{@G@z@@33@@@=q@Q@(@=q@@@@G@
=@
=@ff@=q@@(@{@z@@Q@=q@(@G@@(@
@
=AARApA\AQAA
=A\AzAA
=qA
=A\)A33A33AA	A  A
A33A  A\)A	AffA  A
A
A\)AA\)@RAHA QA A (A QA zA z@@@  @p@33@@\)@z@p@{@z@  @  @@@HAAffAA@=q@@\)@{@@@
=@=q@
=@@G@\@@(@@@@p@{@
=@(@\)@
=@Q@@z@@=q@  @陚@Q@(@pA   @33@\)@z@H@Q@{A Q@p@R@@z@A\Ap@RA(A
HA	A @(@G@ff@z@\)@A
{A33@\@G@(@p@=q@=q@G@33@޸R@  @  @\@@@(@
=@H@  @G@H@Q@@@ٙ@أ@@@{@Q@ҏ\@@Ӆ@p@@
=@@@G@z@@=q@\)@z@{@ȣ@(@@(@p@@33@p@أ@љ@@
@ff@H@@G@
@أ@ۅ@ۅ@z@Q@H@ff@=q@{@Q@{@@H@@@=q@H@z@p@@{@@=q@
@Q@A @@{@{@@(@@@AHA @\@@\@{@@  @z@(@=q@\@=q@@(@H@Q@@@@Q@R@ff@@
=@Q@  @Q@@
@@\@
=@p@@p@@@@p@\)@
=@@  @@33@33@p@  @׮@@z@
=@33@=q@H@=q@=q@@33@ə@@33@\)@߮@ڏ\@=q@ڏ\@@ff@ᙚ@H@z@{@@(@@ff@R@33@  @33@ᙚ@H@=q@33@
@@R@ff@  @\)@R@  @  @{@p@@{@@
@p@p@@\)@(@33@@R@@(@{@@R@
@@{AA AAff@@@A  A@@ff@@
@H@\@\@z@z@H@=q@R@R@R@\)@
=@
=@(@(@@
=@  @
@@p@׮@Q@@@p@G@H@@@z@p@@=q@H@陚@@H@H@R@(Aff@@@R@@@@@@G@@G@=q@33@33@(@@(@z@
@@33@H@G@H@@@@H@33@=q@H@=q@@=q@@G@@R@@G@G@@ff@G@H@  @@@G@@R@Q@(@\@H@33@H@
@@Q@H@\@@@H@H@
=@{@
=@
@@@@@@@(@R@p@{@@{@@@@Q@\@
=AA (A (A (@{@@@G@33@@Q@@Q@@  @33@(@p@{@
=@RA zA   AA zA A A A A zA (A zA A @@
@@@z@{@@p@z@z@@
@33@@@{@33@z@(@33@H@G@G@@@=q@@Q@@@=q@{@=q@@=q@Q@p@\@=q@
=@@@p@@@@=q@@@@@\@@
@
=@@R@@@@  @ff@{@33@@(@@\)@@@H@G@G@G@=q@=q@ffAAA{AA @@ff@\)@R@R@@@@@@
@z@@p@{@@@33@\)@@
@R@
=@@
=@  A   @\@@@@H@\)@p@{A @ffA@z@ffA{@(@A @
=@H@{@GA z@=q@(@@@=q@=q@@@=q@=q@(@@@@p@33@@\)@p@@@{@@@\)@A@R@@@z@@
=A @=q@ff@@@@@\)@\)@\)A (A AffA33AAAAGAAzA
A  A  A33@
AGA A AA
=A33A\ARA
=A AHA AAA @@@(@
@ff@R@  @@@  @p@@@H@{@(@
@33@\@(@A@z@R@
=@\)A=q@  @
=@33@@R@
@ff@\@ff@@p@=q@z@@\)@ָR@{@z@(@p@@
A   @@33@  @p@@=q@\@\@@@
=A@
=@\)A (A\AA=qARAAA\)A
=A\)A
=AAHA(AAAGAAAAA\AA
=AffA A=qAff@AQAQA\A	pA(AR@{@@@p@\)@G@@H@
@{@R@RA zA zA A A @{@33@@(@p@33@@H@@@ff@Q@
@z@{A   @\)A QA A   A   A Q@\@\)@Q@\)@{@Q@Q@\@@=q@p@z@G@  @@RA (A Q@A A z@\)@@
@33@@H@@G@\@@@@\@A   ApA @
=@R@@@A@ffAARA\A Ap@R@p@H@33@
@@@Q@  @@@33@p@@z@H@H@G@=q@  @@R@{@\@G@@\@@@Q@@@
=@{@@@R@@@@G@z@
@@(@ᙚ@Q@
=@Q@(@  @@@p@p@{@\)@@z@(@
=@@@@{@H@=q@\@@R@ff@R@@G@z@ffA z@@@\)@R@p@@@@@@A A @{@\)Aff@@@ff@
@p@@ff@@H@33@@
=@@\A  A{A33A
=A33@\A@{@ApA\A=qApAff@ff@@@(@@@@
@@@@GAAA
=AAAQARAG@ff@@  @R@@Q@=q@\@@
@@p@
=@@@@@@@\@H@\@@@@p@
=@  @@Q@\)@@Q@G@G@AG@p@
@@{@@@@(@(@p@@=q@ff@ff@AApAAQA
ffA\AAAApA
=A
=AzAAR@z@@\)A zA AAGA @@
@@@
@@z@
=@33@A
RA	AffApA (@p@ff@\)@R@zA @A33Aff@
@H@R@@\)A @{@@ff@@@@z@(@@=q@@@@ff@\)@\)A AGAAA\)ApA\AffAA=qAA\AHAAApA (@@
A@@A\A(AA33AzA0(A!AA&{AAA\AA
A
=@GA   A
@@R@=q@{@@
=@\)AAQA(A
=A33AQA
AAA	pAzA{A
=AffAzA	A	A  @{A A@
=@@@HAHAGA
AffAHAff@33@@(@Q@G@@{@z@z@
@\)@@{@  @@Q@@@G@
@z@R@ff@R@@(@(@z@ff@@\)@\)@ff@
=@ff@@z@(@@@@(@@A @R@\)@
=@
=@
=@pA @=q@H@
ARA=qA A (@{@@33A Q@G@G@p@ff@R@\)@R@p@H@p@@\)@p@
=@@@@H@@G@
@Q@\)@@Q@@R@H@@G@Q@@ʏ\@=q@(@@ҏ\@ڏ\@\)@
@
=@@@\)@p@@z@R@H@z@p@R@ff@  @@@R@@=q@33@@@\@@
@\@(@@=q@(@@H@33@@33@@@
=@Q@\)@(@@p@{@@
@@@@(@p@陚@@G@=q@R@@
@H@
=@@
@@33@@@p@@ʏ\@=q@
@33@ʏ\@أ@@ڏ\@{@z@@
@(@@޸R@@
=@Ϯ@  @Q@p@G@G@=q@
@{@=q@@
=@
=@{@ff@
=@z@@p@
=@\)@  @R@@@ff@R@\)@@  @@{@H@@Q@@@ᙚ@@@(@z@33@H@@
@\@33@z@@@@@ff@@\)@ff@\@@z@{@33@\@R@@
=@G@
=@p@(@(@Q@@
=@{@{@ff@@陚@
@z@陚@Q@@\@ff@@(@
@33@@{@@
@p@H@߮@z@ff@H@
=@@=q@=q@=q@@ff@33@@@pA   @RA   A   @ff@ff@H@=q@=q@Q@=q@@R@\)@@G@ff@{@33@p@@\)@\)@Q@\)@@R@33@\@@(@  @@G@@=q@33@
@z@p@ff@@@33@@z@@@{@z@p@@@@{@{@@p@@
@(@z@H@\@H@ۅ@=q@أ@أ@z@Ӆ@H@
@@@(@@\)@H@{@@@z@z@@@@Q@@@@@\)@Q@\@\A   @R@@@\@H@@陚@@@
@@  @33@(@@33@p@\)@@@{@@R@@{@@
@@{@  @R@@=q@@
@
@p@@@\)@@R@z@@33@33@\@@\)@z@=q@ᙚ@@@\)@@@33@=q@陚@@
@ff@@p@=q@=q@=q@=q@@  @
=@{@@G@z@H@@@{@@Q@@ff@@陚@@ff@33@@{@@z@33@
=@\)@=q@ff@\)@
=@\)@33@@(@@
@H@
=A AffAG@G@
AA (AffAA33AAGA
\A@RA QA (@{@R@H@
@p@
=@G@  @p@  @@p@  @@@p@ff@@z@@
@33@@@
@@
@33@ff@ᙚ@R@@@@@@ff@33@=q@陚@G@
@@p@(@H@ָR@=q@@أ@@Q@@أ@{@
=@@ə@H@@ָR@@\)@@@ff@G@Q@Q@33@Q@ff@@R@ffA
A33A\)A@@
=@@ff@@=q@@
=@@R@
=@R@@\@@ff@@@@
=@@G@H@\)@@R@@@Q@@@{@ff@@(@@@@@z@33@33@=q@\@ᙚ@߮@߮@߮@\)@
=@{@p@@p@@@33@
@@{@  @@߮@  @޸R@
@G@У@33@{@@
=@߮@@z@ff@\@{@(@{A@@z@
=@@=q@@@@{@ff@@pAAA	AAp@z@A@33@  @@@@@p@p@@  @@z@@ff@p@=q@(@p@\@G@  @{@H@@@@@Q@\@H@{@z@@@p@  @  @@G@@
=@@\@z@@@R@(@@@  @@@\)@=q@33@{@{@
@
=@@  @H@@G@z@@{@p@RA\)AzA	A  ApA\A  AA	AzA	pA	A	GA{A=qA33A{A\A	GAA
A\AA
=AffA
=AAA@RAGAzAQAAzA(AAQ@H@33@\A=qA\A\@G@@p@@
=@@@=qA Q@pA
AAA
A{A(A(A
AHA33AA@G@33@@33@G@@@@@\@@(@@33@=q@H@߮@{@ff@@\)@ᙚ@=q@{@@
@Q@A
\@@p@{@@G@pA\AA
HA
\AQA	AAA
A\ARA(A
{A	AA  A
HA	A	pA	A
=qA	pA	pAzAzA	GAA
A
A(A  AHAAAAAffAAAAHA
=A @@@{@=q@z@ff@(@R@ff@=q@G@p@@H@@p@\)@
=@33@  @@@@@(@
@z@33@@@33@=q@
=@\)@Q@
@\)@  @@{@@z@p@G@@@\)@@@@\@
=@@{@H@H@(@=q@@G@@{@ff@  @p@@\@@=q@@\)@
=@
=@R@p@@{@R@R@@@33@z@
=@Q@z@@@@@z@Q@陚@33@@ᙚ@G@@\)@{@@A@
=@@\@=q@
@=q@A QA=q@G@@@33@陚@
@@@R@
@H@Q@@R@@=q@
@ff@(@@@33@\@\@  @@陚AR@p@p@p@@R@@@@@(@@@H@A@G@@@@@Q@\)@ff@@
@\@  @{@z@G@陚@(@ff@=q@  @(@
=@\)@@R@@ff@=q@Q@@
=@R@陚@@\@(@@ff@@{@
@陚@H@
=@@H@
@@G@H@33@\)@ff@{@{@@H@=q@(@ڏ\@Q@@(@أ@ٙ@
@{@ۅ@@33@@H@@=q@@
@\)@33@\@{@(@33@@@@
=@=qA\@  @R@@@H@33@(@zA   @A @  @
@G@33@@@@RA\@
=@ff@=q@H@ff@R@  @@p@H@  @R@A @\)A@R@\)@\@ffA{@A AAA\)A=qA
=AAffA
H@R@=q@@@(@z@
@z@@\@@G@@@@G@H@ٙ@@@@ۅ@  @@Ӆ@ҏ\@\@
=@@G@@Q@  @
@@z@@=q@\@Q@AffA@33@A	A
=@R@A
=@A
=A z@(@{@@Q@@޸R@ۅ@p@ڏ\@33@ҏ\@@أ@  @\)@ff@ff@  @@z@Q@=q@z@@\)@߮@Q@@33@p@p@z@(@@@@
@G@ڏ\@  @Ӆ@p@z@ڏ\@׮@  @@{@33@@
@
=@p@{@G@@@33@ҏ\@@{@@ȣ@(@ff@@(@p@@@@أ@أ@=q@(@@޸R@G@@@ff@  @
=@Q@@(@Q@\)@@@@Q@@@
@33@\@
=A(A
AffAQAGA @(@\)@z@p@(@@@@@R@@p@(@p@@@=q@A @@(@\)@p@@@\)@\)@=qA@(AAA
GAAzA@(A\)@@@33@@z@(@G@
@
=@
@@@\@{@(@=q@z@ٙ@  @أ@z@@H@޸R@@ᙚ@H@{@@33@H@\@ff@ff@z@@@
@p@
=@@G@  @G@33@33@@Ӆ@H@
=@أ@\)@@Q@
=@׮@ff@ָR@p@@@@ff@=q@z@@G@@ff@@@R@(@\@@
@@@@33@(@ᙚ@=q@@޸R@ڏ\@ۅ@Q@Ӆ@
=@\)@Q@ff@\)@@Q@z@Ӆ@H@G@Q@G@z@(@(@33@ڏ\@\)@p@У@Q@H@=q@Ϯ@33@ָR@@{@ҏ\@{@ff@@
@H>A z@ٙ@z@p@ff@
=@p@Q@33@ᙚ@@@\A@33@(@p@@{@
=A
=A\@\@@
=@H@@(@p@@\)@
=@@(@=q@@@G@ff@@ff@@\)@  @=q@  @@\@\@@R@R@\)@@
=@z@33@G@@z@\)@\)@Q@
=@@@{@{@@33@=q@H@@@H@@z@33@33@  @{@@  @
=@\@  @\)@H@@@33@@@
@R@z@@@G@33@@@z@@ff@A33AA\)A  AAA(A  AzA{AffA  AA
ffA  AA33A
GAAQA(A
\AA33AA\A\AAAA @
=@(@z@@A @@Ap@(@A zA (@{@{A @zAA\)A\A{AffARA(A@{@p@@p@@p@{@z@p@z@@@
@\)@\)@@=q@\)@
=@Q@߮@߮@
=@@@\@=q@
=@{@\)@G@=q@p@33A A QA (A@pAAffAAGAffAA
AA	A
A
A\AA  AffA=qAQAA
AA
=A33A\ARAARAAzAzAAffAQA
A
A	AAff@AAA QA@
@AA   AA  A{A=qA\A33AAAAAffA=qA\@@
@(@@RA@\@ᙚ@
@\)@@(@@(@@\@
@
=@@=q@z@陚@=q@H@33@(@G@=q@ָR@H@ҏ\@(@
@أ@33@@p@\)@RA A=qA\)AA	pAAAA
AAA
=A(AAAHA33A"{AA33A (A=qAHAQA!A(ApAffAAA
GAA
{AA
RA (AHAAAAHAA(AA33AGA{AA(AA(A\)AzARAApA{AAzA
=qAARAA z@(@p@@z@p@z@G@p@\)@Q@{@A@A(AAA  A\)A33@@AA
=A(@\)@A  @A AQA ARA=qAAA  A=qAQAA33AQA  A  AA\AA
AAQ@\)@A!A  AAp@@@@@@{@z@ff@\)AAAGA=qAAzA\)AA(A\)AGAffA)ApAHA\A=qA(AAA  AzA{A(A	pAHA{A\A\)AH@\)@{@\@@@  @  @@=q@@
@@
@=q@p@@ڏ\@33@ٙ@@@G@\@@ᙚ@G@@QA  AAA(A	pAAffA   A=qA (AffA   @
@@\)A A@\)A QA\A(ARA{A=qAffARA@ffA @R@p@
@@@H@z@zAA
ffAA\)A
=ApA"{A
A%A  A
=A33A(AA
A	A
A!AQ@=qAQA	G@@G@\)@
=AA\)AAAAA
Aff@33@@@@(@@z@@Q@p@@H@R@@33@R@@p@@陚@G@G@G@
@(@@@Q@G@@@R@ff@@@@\)@z@(@  @@@@R@\)@
=@@@@@@  @@@@@@@Q@G@\@(@
@@G@
A A@@@
@@@HAp@
@(A@@@ff@@
=@@G@@(@@{@Q@@\)@{@  @=q@\@@R@@ٙ@ָR@H@(@33@
=@z@@ff@p@{@
@@  @@ƸR@p@У@@@Q@ff@@
=@߮@p@\)@p@@@p@p@{@R@@  @  @陚@@=q@H@33@H@H@33@H@@@Q@@@
=@  @Q@@@@
=@(@ff@@ff@@(@@
@@@
@@@(@(@(@@@@=q@=q@
=@Q@@ᙚ@@
=@ᙚ@G@ᙚ@@G@{@@@(@@ָR@@ָR@p@H@H@љ@(@
@{@@=q@Ӆ@=q@  @У@H@=q@@@Q@
@޸R@
=@޸R@ڏ\@
=@
@33@@
@  @@@@@@
@z@@{@ff@\)@@@R@{@{@ff@
=@@{@
=@ff@p@@@(@p@@
@@@p@R@@@p@
@(@  @@@\@@
@@H@z@33@H@(@@=q@Q@R@(@=q@@ᙚ@߮@  @  @  @  @@\)@  @@G@G@@@ᙚ@ᙚ@@Q@Q@@@@@
@
@p@G@=q@\@@33@  @@p@{@z@p@
=@ffAHAHA{A  A%pA1pA2=qAAA{A
GA  AQA=qAzA  AGAA
AA
A
pA{AA	A	A	A	A @zA{A@\)@(@p@(@G@
=@@
=@
@陚@߮@  @@߮@p@ff@@ۅ@G@@߮@@33@޸R@p@z@\)@\)@33@@{@p@@p@@@@@@@@
=@\)@߮@@@  @\@@
@HA  @RA33A	@ff@@  @R@@Q@ff@z@{@Q@ApA Q@
=A zA  AHA
\AAA
ffA
=qA	GA\)AQA\A\AAA{A@ff@@@@p@R@\@G@ff@=q@H@z@(@@@z@p@(@(@z@陚@H@\@@33@@@G@H@@陚@=q@33@@@@(@{@R@@G@z@@@33@Q@߮@@(@H@@H@\@H@
@H@@@p@HA @ff@=q@G@A   @@\)AAA(A	GAAQA  A@zA
=ApAffAA QA A  @
=A zA\)AffAAH@{@@@p@H@@z@\A\)@33@@\)@\)@@@R@\)@@\@@33@@G@\)@p@@\)@=q@@Q@
@@@{@33@@  @  @p@\)@ff@@ff@@
=@@p@=q@@ٙ@=q@@@أ@33@@׮@z@p@{@Q@ᙚ@@33@ڏ\@\)@(@(@{@@
@@Q@@AA(AffA=q@\)AffA
=A33@@zA@A  AA	GAAA
\A QAA
=Aff@AffAA\)@  @=q@(AAA
=A
AAAAA=qAQA@Q@\@=q@G@@@@
@@@(@@@  @@G@H@@
@@p@H@\@H@
@33@
@@R@R@p@(@\)@@@p@@@\)@\)@@@
@  @@z@p@{@R@(@@@@R@HA33AG@@R@Q@
=@@(@
A (A@A(@H@{@H@(@@
=@@@ff@{@33@(@@H@33@@  @p@@{@@@Q@=q@  @G@R@=q@zA@@p@=q@{@=q@33@@@@@(@@@H@H@\@@G@@@@
@z@@H@@G@R@\@@@z@
=@@@@(@z@H@
@(@@ff@
=@Q@  @Q@G@33AG@@@  @A QAGA A A   A zA   @H@A\AAQAA=qA\AzA33A(A33A\AffAAA
A\A @R@{@RA@
A Q@p@33@R@@@\@
AR@\)@@RAGAA Q@A A=qA33AQA
A
AQA  A@HA ApAARAHAAA A
=A33A
=ARAApA z@ff@@@@{@@A (@33@\)@@@\@@H@p@(@@=q@z@@{@@{@@@@@
@
@@z@
@
@p@\)@@@{@{@
=@R@@\@(@\@\@R@(@@@R@{@@AHAAAzA @@@@\)@
=@\@R@@33@(ApA
=AA\)A33A=qApAzA33AAffAp@{@33@@
=@ff@\)@{@R@@R@p@@@@ff@ff@(@\@@
=@p@@33@@p@H@{@@=q@\@p@
=@߮@׮@
=@\)@@
@H@ڏ\@ָR@ٙ@
=@p@H@p@H@@߮@G@@ff@@@@
=@
=@
=@=q@@33@
=@R@  @@@@@G@z@@@ᙚ@\@ڏ\@@z@z@Q@@@H@@߮@\)@߮@@@R@
@@ff@33@@R@@Q@Q@@@@ᙚ@@@@
=@{@У@H@@
@@{@p@
@@G@ȣ@Ǯ@
=@=q@{@@@\)@=q@z@
@33@(@p@@׮@Q@A zAA{@@@@G@
@z@G@
=@R@@A @R@@@33@@ff@@\)@޸R@ff@@  @
=@33@\@
@@
@@  @@@G@33@ڏ\@H@@陚@߮@G@ᙚ@ff@(@޸R@@@@H@=q@@G@@z@@z@p@@@@z@Ǯ@@
=@z@{@@G@Q@G@@{@z@@{@@ȣ@θR@{@(@
@ҏ\@\)@
@@ٙ@Q@  @Q@=q@(@@׮@@  @  @\)@׮@أ@@@@޸R@z@z@@
@أ@ff@޸R@(@@@ff@33@@  @@p@{@(@
=@{@ff@=q@  @=q@G@=q@p@@R@p@33@G@z@@ffA
RAR@{A AG@@=q@ᙚ@33@G@{@@p@Q@Q@H@p@G@@z@@
@أ@ff@أ@@
=@ƸR@33@33@  @HA\@Q@@G@R@p@\)@@@߮@{@Q@
=@@@@G@(@@@=q@
=@
=@@
@@{@(@@z@33@@@R@@@=q@=q@=q@33@@@\)@p@@
=@@@33@@@(@@@p@G@
=@@(@z@(@\@陚@\@  @
=@\@z@=q@=q@陚@H@ff@A.HA-A{A@R@@z@
@G@zA@=q@{@@ff@z@(@(@\@\@=q@33@=q@@@@=q@G@R@ff@G@=q@Q@H@\)@
@陚@  @@H@@@=q@ff@@@z@@33@H@ff@@z@@{A zA   @\)@{@@p@G@@
=A=q@33@Q@G@G@
=@  @(@RAG@\)@@(@{@@@@33@=q@G@G@\@\)@@33@z@z@H@@@@@=q@@\@
@33@@@Q@R@Q@
=@  @\)@@@@@@@=q@@=q@@=q@@p@@(@@@@  @Q@@Q@A A (A @p@  @=q@33@@ff@=q@@RA A AA\)A(AAA=qAA\)AAA
=AAz@p@{@@
=@=q@G@R@@H@=q@Q@@\@ff@R@Q@R@H@{@z@\@{@p@ff@
@@A @{AA	A (@  @  ApAApAAAAA=qAA
=AAHAAAHAAAA  AAA{Ap@33@H@  AffA
A33AQAz@AQA	pA
AzAA=qA\A=qA{AA	pA	A33AAA	A\)AA\AAAAAHAARAQAA33A
GAzA
GA	AA\)AzAAAAAA   A	ARA33AAAGAA z@ffA   @@p@
@{@
@G@AHAAzA(A33A{AGA A zA@R@\)@
A @  @A z@@p@p@@  @=q@H@@@@\@@
=@Q@@G@{@Q@Q@@=q@@A QA ApA A A{AHAzAA(A=qAA33A zA{ARA{AA  AHAAGA\)A
A{A
RA
HA{A	A QAA(AAHA
=qA @\)AHA@@R@{@
=AGA (A{AAH@AR@@G@H@H@@{@=qAR@
=A
AAA
{A
A
A
AQA  AA
=A=qApAA
=ARAA
=AAffAHAAAHAARARApAzA=qAGA\AAAzAzAQAzAA!A$zA!GA=qA!GA(AGARA   A#A!pA"{A%GA'\)A'33A)A(A(A(A-A)A*ffA*RA)A)A+
=A'\)A)A,(A*{A(A(QA&{A&{A$A$A'33A+33A.\A((A&HA(QA*RA,QA/A,zA)A*ffA*{A(QA%A+33A.RA/\)A-A,zA(A(A)A#
=A)A)pA'
A'A'A#
A zA A"=qA(A(  A$QA
A&ffA"ffA%A&ffA$(A(A%A%A)GA(A(zA!A
=A#
A$zA%A"=qA   A\)AffA=qA
A\)AAAQAGARAHAA
=AAffA33A"{A{ApA\)A\AAAzAAffARA\AA33A=qA(AA
A33AAApAHAGAA
AzAQA
=A	GA	A\)AA	pAQAA\AARAffAzAA33AGA QA  A@ff@p@R@@ffAp@\)@pA AzAH@33A A@@@@\)@z@33@
=@z@R@陚@G@
=@@G@(@p@@@R@
=@=q@=q@@ff@\)@@p@{@R@@z@A   A33A zA AA{AH@
=@ffA{ARA	GA
=AA
A
=@@G@33@{A=q@
=@G@@@@\)@ff@@{@ff@  @@H@33@@\)@p@陚@@33@@@@\)@33@@ff@
=@(@ᙚ@߮@@߮@{@߮@
=@Q@G@(@p@p@@@@߮@p@z@  @G@=q@33@@ff@@H@
@Q@ᙚ@33@H@߮@أ@Q@\@
@
=@ٙ@Q@Q@p@У@ə@z@  @߮@ᙚ@@Q@
=@Q@@G@
@=q@@@\@@=q@33@
=@@(@@  @z@@@\)@z@AA
=A(A
AA(A
A
=qAAAzAAA=qA
A\)A AGA{A\)A=qAA @\)@@A z@ff@
=@{A A (A z@
AA{A QA (A A QA ApA Q@\)@  @
@G@z@@R@@R@@
=@
=@@R@H@@@@
=@\@(@{A (A A @z@Ap@ff@A33@AA  @\)ARA33A AffAQAffA{AffA (@
=@\@A @@\)A@p@@@@@G@G@A	A	pApA\@  @H@AAHAp@ff@  @
@H@RAA  A33A(AQA33A{@
@(@p@\@@AAG@{A   @R@@p@{A zAAAA@p@
=@
=@Q@33@@ff@pAAAApAQA\A
=AAH@@ApA
AG@\@=q@
@@\)A\A
=A zAffAA  A{A QA zA A A (@\)@\)A{A\@(@z@{@{@p@pAA\A
=@@@33@=q@@  @
@@ffA   A A{A\)AA@=q@RA zAffA @p@G@{@@
=@ffA   @{A QA @@=q@  @@z@\@@z@@z@=q@
=@R@@@z@@
=@G@(@@
@
=@R@\@G@=q@@\@@@@
@@@
@z@@z@\@z@
=@
=A Q@\)@ff@
=@
=@\)@@p@RARA\)A
A\)ApA QA   @
=@{A @@@=q@{@33@\@H@z@  @{@  @@(A=qAG@@@
@ff@\)@33@\)@@G@(@\@@\@@@33@@@@\@=q@p@
@@@Q@@@H@@z@@@\@\)@@=q@
@ff@@H@
=@=q@H@H@@(@z@@=q@Q@R@R@
=@@@@@@{A ApAA=qAffA{A=qA33A  AA
A\A@33@@z@\)@z@@ff@z@
=@
@@@{@@\)@\)@R@@@(@@p@\@p@\)A AAA=q@ff@@(@33@33@
=@\)@@G@\@G@ff@\)@H@@33@@(@@R@ff@
@ff@R@@\@=q@R@@H@@@Q@@{@G@\@(@{@  @33@p@
=@ff@p@=qA QA ApAARA\)AQAAffA@A{A zAffA(AffAAAA
\ARA=qAAA
=AAffAffA\AHAffA A@{@R@\@{@AA
=@p@33@  @ff@=q@
@ff@@
@@@G@H@@  @  @H@Q@\@@@\)@@@=q@R@陚@z@H@H@z@@\)@{@@G@
=@\)@ٙ@@33@G@@G@@@=q@@H@(@p@@
=@=q@@R@ff@{@@
=@  @\@@\)@@@@@@z@@@Q@33@@@@@@{@{@@H@@@R@@@@G@Q@\@33@@G@@@@\@=q@=q@=q@@陚@
=@p@@@@ff@H@33@
=@ff@R@ff@R@@H@
=@@ʏ\@@z@(@Q@љ@G@
@G@33@љ@ff@G@@\)@33@أ@@ۅ@أ@=q@޸R@\)@=q@\@33@33@(@@(@@z@@ff@  @  @@陚@@@
@@
@߮@߮@ff@
@@\@\@@@@@=q@=q@@ۅ@Q@=q@=q@H@@ٙ@ٙ@p@\)@@H@H@z@@z@@@@Ϯ@
=@G@@@ff@\)@\)@  @  @=q@@  @ٙ@G@أ@{@  @{@\)@G@
=@ȣ@@˅@@Q@@@33@@˅@ʏ\@(@(@@@θR@У@Ӆ@љ@G@ҏ\@p@׮@Q@ٙ@G@@@޸R@  @Q@@޸R@޸R@\)@ᙚ@z@\@R@
=@@@33@@ᙚ@@H@z@{@R@33@
@33@z@33@H@=q@33@@{@33@z@߮@ff@ٙ@\)@@@H@H@߮@޸R@p@\@@@ᙚ@@@{@
=@  @@
=@{@p@
=@{@@(@(@
@z@\@(@=q@
@33@@@  @@33@ۅ@@=q@@H@ڏ\@޸R@@p@@@z@p@p@
=@{@z@@@=q@陚@
@z@p@@  @@33@(@@\@
=@@@@@p@@R@@p@33@@@\)@@@\@@\)@
=@{@@陚@(@z@(@@33@33@=q@@33@(@@33@H@z@@H@z@@p@ff@\)@=q@@R@  @@G@@@@@\)@R@@Q@R@\)@z@@@{@޸R@p@p@@\)@
=@@G@(@\@R@@G@\@@{@(@陚@=q@R@@(@ff@R@@33@z@33@33@@@G@(@ff@
@H@\@\@H@@@@Q@  @@@H@@@@@
=@\)@@
=@Q@z@{@
@@@H@\@@H@33@\@H@=q@@\)@@@z@
@=q@陚@@@@H@@33@  @@@@\@ff@ff@\)@R@\@=q@ᙚ@@
@@ff@\)@@
=@@(@
=@ۅ@ᙚ@Q@@@p@@H@33@
@G@@Q@(@p@R@
=@@@{@{@  @@G@33@H@@p@Q@{@33@z@\@(@@(@\@@H@\@A zA\)@\@HA@HA  AGA	pA
AA=qAA\)AAzAQAAA  A=qAQAAA Q@z@@@(@R@H@\@=q@ff@@@R@{@@\)@
@H@33@
@{@=q@G@أ@H@@@33@(@
@@@\)@@@(@(@@
=@z@(@@@@H@@
=@
=@G@\)@@@G@G@33@H@@z@G@@@ff@=q@ff@ff@p@{@H@H@@@\@z@@=q@
@\@G@33@@@R@@{@(@@{@
=@޸R@  @=q@{@z@\)@\)@ff@p@H@@G@  @=q@陚@߮@  @@z@@G@G@(@
@{@
@ڏ\@ٙ@@Q@@Ӆ@G@z@p@
@\@@p@ff@p@  @z@33@H@@@ff@  @߮@@@@(@z@{@ff@@p@\)@  @\@(@
@@@(@  @=q@=q@@z@z@G@G@(@@ff@33@{@@\@@p@G@@ff@Q@ff@@  @@ff@R@H@
=@@@\@H@(@H@@  @\)@z@R@ff@ff@{@ff@@\@
@@@޸R@\)@
@޸R@  @ᙚ@ᙚ@@׮@33@ff@{@@߮@
=@\)@  @@@@  @p@\@(@{@@\)@ff@@33@@@H@33@@Q@
=A zA@ff@@@
=@  @@@R@\)@(@@
@(@
@\@H@=q@@(@=qAG@@@(@陚@@G@=q@@@(@@R@=q@{@
=@
=@Q@@z@@@R@@@p@(@33@H@@H@@\@=q@(@陚@@@@@{@
@\@@\@{@\)@=q@H@@R@@\@  @@
@@=q@
@RA33A
=AQAA{AQAAzA33A\)A=qA
{AAffAA
\AA
A
GA
pAzAA
\A33A
@R@R@@G@R@(@Q@{A
ffA
ARAAA{A\A33A QAA (A @R@AG@\)@@z@@\@{@@(@\)@R@@\)@
@@@\@@@
=@\)@@\@@@ڏ\@@
=@  @(@@G@33@@(@@@H@p@{@{@(@\)@
=@G@@(@H@33@z@@\)@G@@R@
=@@=q@@
@@@@@@p@@\@\@@AA Q@p@
=@@R@@ff@p@@A   A
=AA\A  A@AA A{A A (A   A A (A   @@@\)@@@@z@@  @@陚@  @A(@(@@=qA@@H@z@\@z@@{@@H@@R@z@p@@  @G@=q@{@@G@@H@AApAzA\A ApAAHARA\AAGA	ApAG@p@H@=q@@G@@@33@@\)@R@p@
=@z@33@(ARApA
=@@@(@Q@@\@R@@@R@\@\)@ff@@R@H@@@33@@G@R@{@ᙚ@ff@@@@@ff@{@
=@33@@33@z@@p@@\@{A(@p@\@z@R@ff@33@R@p@@@@@z@@G@@RAQ@{@G@HA zARA=qA\AA	AA  AA
pAAAA	A
RAAHAHAA(AA\AA
=A2{A+A33AA	pAffA
AGA
A@HA{AA(@@{AG@@@R@{@@@p@@@@\@(@\)@@  @@G@@  @33AApAA{AHAAHA (AA QA{ARA AGAffAG@
=@
=@@p@@@@G@Ϯ@  @@p@@@  @@33@  @@@
=AA
AA{AzAzAffA@@(@p@@ff@@@@@
=@  @ff@  @@Q@Q@@Q@=q@@\@@\A zAA(A
=AA (AH@R@=q@@=qA@\@p@
@H@G@ҏ\@pA	AQAAQAQA
HA@@R@G@
@\@@@33@\)@(A	GA
\AHA  A\)A (A(AA
ARAA\@
=@=q@@@(@G@z@=q@@
@\@@=q@@\@33@A\)A=qAARA   A*{A!A  A
GAQAHARAAAAAARA(A=q@AH@
@A A=qA{A
ApAAQA\)A
=qA	AAHA
=A@=q@@RA{A
=q@z@  A@33@Q@R@
@=q@@33@@@(A(A\A
=@{AA	A33@33@
=@\@@G@G@  @@@Q@\@H@=q@@
@Q@z@=q@
=@׮@ָR@G@(@Q@  @{@z@У@@(@ٙ@ۅ@@@(@R@\@H@=q@H@@Q@33@pAA
=AQAHAffA  A\)A
AAHA(AA=qA
=A#
A#AAffA
AAQAAA@z@p@\)@@@ARApAz@\)@@z@@@H@33@{@ff@H@
=@׮@@=q@@H@G@@H@=q@H@˅@33@33@33@@H@ə@˅@@
=@@QAQ@HA
AG@ff@=q@@
=@z@@HAQA
A33AQ@QA A=qAA33AffA QAQ@
=A@HAA33@
@
=@ff@(@@33AQA(@@\@=q@(@ffAA AA   A33A\)A\)AA
=A\A  A
A	A(A	A QA=q@  @z@@=q@@@@@z@{A33A (AAp@(@@(@@
=@A
A Q@
=@R@\)@H@
=@@33@H@=q@=q@=q@G@@z@{AAAGA\)ARA  AA
HA\A(AA\A	AA	pA
=AA	pA\A\)A  A33A{AA@\)A\)A	GA	AA	GA{AApAAAAA
RA\)AAA\A\)AA
=AA
=A  AAQAA\)A
=AA\AA   AAAAA
A
AAAA
A
=AA33AAffAQApA\A  AAQAffA=qAQA
A  AAAA=qA(ApAAA\A\)AffA
A
AA\A{A
=A{ARA
AffAffA=qA
AffA
AAA33AAAQA	pA
ffA
GA
ffA
AzA
AzA
A33A33A
GAAAzA
AA\)AA
=AzAAARA
=A{A
pA  A
A  A
=qA	GAQAA	A33A
A
AA
A
A\)A{A
=A
\AzAffA
RA
\A
A33ApAzA   A A zA\AA=qApA  A
=A
pAAQA\A=qA{A33A\)A
=A{A\A\AAQA
AAAzARAA   @@AA zA AHAp@A @A@@@H@33@@
=A{A
A33AAA
=A\)AA\AH@AGAAAAAGA\)AQA\)AffAAzAAffAA AAffA
AffA  AA  A=qA
A
A
A{AA=q@R@33@GARAA(@@(@  A   A\A Ap@\@@@@
=@
@p@@\@@@{@p@ff@
@(@@G@33@Q@=q@(@@=q@@@@Q@z@p@
@33@@@(@G@\)@
=ApARAA\)A	GAAzAA	A
AzA	AQA
AA{Ap@@@p@{@ff@@@=q@
@A AQAAQAQA	pA
RA
A(AzA  @\)AzA=qAGA{A@@
@@(@p@A (A (@ff@A QA@
@Q@  @@p@
=@@@(@33@@H@RA A
=A\AffA zA (@@@
@=q@\@\@@
=@  @@\@A Q@\)Ap@@p@H@@@
=A{AAQ@(@\@@\@=q@@@@\@\)@\)@@@AffA{AA(AARARAzAA\)A\)A
AzAAGAffAQAHA
=A
A
GA
=A\)A	A33A	@AA33ARA
pApAzAA
AARAAzApA
=@@@H@@H@@\@33@@@
=@
=@p@@H@@33@=q@@
=@@@@=q@33@G@@=q@ff@G@R@{@R@z@@=q@@
@H@  A\@Q@@
=@(@@p@33@H@@
=@@(@@@{A AA
{A  AA
ffA
A
\A
ffAAAA(AR@ff@z@Q@@=q@  @@  @R@@@
@@Q@R@=q@
@{@{@@
@H@@Q@(@ARA
=A (@{@@{@\)@G@Q@@@
@  @
@p@=q@ҏ\@\)@ff@׮@@  @@{@@
@p@@
=@(@ָR@@@@\@陚@z@陚@=q@p@
=@H@z@(@33@H@H@@G@@\@\A=q@@\)@p@  @RA   A QAAG@{A A A
=ARA @{@H@G@  @@
@@
=@@@
@@@ff@R@@R@@@
@33@H@@@
=@H@@33@H@Q@  @@@@  @@@@Q@\)@G@@
=@\@\)@ff@  @=q@@Q@z@33@\)@@ff@  @@33@p@
=@\@@\@
=@ff@@=q@33@p@(@R@R@{@G@{@GA (@  @Q@=q@@33@@(@A   AA=qAA
\A	AHAAzAA=qA=qAffA\A\)AffAA{@A33A
=A{@@@z@R@  @  @  @(@=q@
=@R@@  @=q@\)@H@@@33@@@z@@@@  @=q@@@z@{@@(@  @@p@(@=q@@R@  @p@ff@z@R@@@\@G@@H@33@R@=q@{@(@p@@
@\)@@z@G@H@@@
@@G@@=q@(@{A AGAffA
=A=qAHA z@R@33@@@@p@@
@\@\@\@
@z@(@R@@@@@z@(@@33@A  @(AG@
=@33@
@z@\)@(@@p@ffApA\A AA
=A   AffAG@pA@p@A   A   @
@@  A{@  @  @{@z@
=@\)@@p@@z@\)@
=@@\)@@
=@{@
=@(@z@@  @ff@(@@z@@p@{@
=@p@{@@{@  @Q@G@33@@z@z@@\@H@@@{@@\)@{@@A@@z@{@
@pAAA @@\)@@@p@33@=q@@@\)@
@\@p@p@
=@@z@@H@@p@p@Q@=q@@@G@@R@z@Q@R@@{@@  @  @@H@  @
@陚@陚@33@33@(@@p@H@@@  @@(@@@
=@
=@@@\)@\)@=q@z@{@@
@@33@@p@A @\)A   @@@@@R@H@@@\)@G@Q@33@@z@@ff@Q@z@p@
@@(@\@@@@  @@33@G@p@=q@@@{@@@=q@陚@Q@@{@@G@@@{@(@@z@  @Q@@  @@\)@R@R@@  @@@  @{@  @R@@\)@@@ff@@@@{@@\)@\)@
@\)@G@GAAGA=qAA
RA	A	A	A
A
=AAHAQA	GA@R@\@pA A
=A\)AA\A @(@z@AA Q@@\@@@H@R@G@
=@\)@z@G@H@H@G@(@H@=q@z@(@z@{@33@@Q@R@@@
@  @{@@ff@ָR@(@33@p@=q@ff@@Q@@=q@@H@z@޸R@@H@
=AAA@@{@H@@G@@G@R@H@@z@@p@{@@@@@G@\@@@=q@@z@Q@@@ff@@{@@
@
@(@z@(@@p@  @@
=@@@R@@R@G@@H@@\)@\@@@\)AAffA@(@\)@p@R@  @  @\)@{@
=@  @ff@=q@@Q@G@@@z@@R@(@@{@@33@@@@p@  @z@p@(@@(@@
@@  @  @=q@  @{@@z@AAGAp@@@BȀ BB
=B.BQB{BBɏ\Bɔ{BB  BBBfBBffB  B{B
BaHB\)BBB(BB\)Bŀ BBffBB)BfBƏ\BQBW
B
B
BB£BBBW
BÔ{BǮBèB)B\)y BýqBÀ BBBLBfB3B
=BkBB)BHBBBB=qB.B\)BuB  B#B\BBfB=BQBB{BǮBBB(BHB3B
=B{BB.BB33BaHB
=B=qBBBQB8RBBLBBBffBffB8RBzBǮB
B(BHB\BBBLBB
=B.BBBBLBBĊ=BèB
=B³3B®B
BaHBÙB\BBBBuBkBřBfBĮBBBkBó3B(BB
BãBǮBzB  BÔ{BÔ{BQBQBÊ=BfBBBBfB\B{BqB=qB\BB  BfBB{B{BffBB{BBBB)BBBB  B\B{B8RB3BBB.B{BBBBGBBLBBW
B{BkB8RB8RBpB
BBB)B{BB{BaHBkBBBGB\)BkBĸRBQBB(BBBƏ\BW
BHBȽqBfBGBffBzBɣBQBkB#BBBȞBHBB=qBuB)BBșB\)B.BkB8RBB(BfBBǮBƣB\)BƊ=BƮBzB\)BuBBzBBBBkBaHBW
BBŽqB
BW
B8RBBB)BGBpBuB
B.BBB{B
B\B{B\BBB\)BaHBHBBaHBpB\B.BBB=qBB)BW
B(BGBBB\)BQB#B(BřBGBW
B33BøRBzBʏ\B\)BQB  BBBBǮBffBʙBBpBɊ=BaHBpBffBaHB\BBzB.B#B{B
Bȏ\BȊ=B{Bǀ B\)BBƮBƔ{B#BŸRB
B=qBąBǮB#BB{BaHBkBaHBBpBĀ B(BąBó3BĔ{BĀ BãBB=qBuBQBkBkBpB#B=BRB BB=qB\)BaHBBBB  B.BfBB\BBB=BBB33BffBB{BBHBęBĮBǸRBffB
=B\)BLB
=B33B8RBB)B
=BǮB#BuB
=B#Bʔ{BBB\BuBQBB
=B  B33BBkB33BB(B.BaHB\BǮBB8RBBʏ\BBBBffB33BffBuBHBB=qB33BɸRBƀ BkB=qB\BpBzB33BB33BBBBƙBƊ=B#BǮB
BǊ=B8RBǔ{B\BW
BǽqBǽqBǣBHB(BHBǙBpBǣBHBȊ=BGBƨBƀ BƮBĸRBBzBW
B
BʣBB˙B˙B
BǏ\BfBBBǅB̔{BBBʀ BBǮBͳ3BBͳ3B.B#Bπ B  BBBB\B˅B.B̀ BffBkBˣBBffB\B
=BBȀ BBBƣBpBB33B33BkBB.BBȅBLB)BpB˙B{B\)Bʏ\BB
BBǣBǮBƳ3Bƀ BBŸRB
BţB¸RB{BLBÏ\BfBãB{BpBĮBĀ BÙB B\)BǮBB.BffBBBBBaHBBBBB{BffB(BB{B=qBB=qBÔ{BfBBBRBBaHB33BaHBB½qB)BBøRBBaHBÀ B
=B\BkBW
B(BkBffBǮB8RBB=qB¸RBQB
BB
=B3BzB8RBBBHBąBBÔ{BĞBŅBB.BǮBGBLBÙBkB¨B8RBqBBBBzBBB\B{BB{B#BBBQB8RBQB{B33BLB  B.BB)BB
=BGB{BÊ=B\BBB=B)BBGB#BB  BBȞBBBɊ=Bɏ\BęBW
B33BǮB\BW
BaHB8RBBkBpB)B(B(B  BBBBBB҅BQB҅B
BHBхBBpBϙBǮBB˔{BkBˣBGB˨BQB\BəBɀ BBuBǅBfBŞBW
BpB
=BB33BzB.B)B)BB\)BBB
=BkBBGBfB\)BƙB33B33BuB\)BîBkBÞBBB\B.B  BfB)BÞBó3BÞBÏ\B\B(B33B#BBBW
BB)B)BBpBzBzBBLBʮB{BBB8RB{BaHBBHB
=BpBBBBkBʣBB{BBϽqB
B)BήBpBBB  BνqB#Bˏ\B#BB˅BQB˽qB̀ B
BpBpBLB
=B̞B\)B(BffBBB\)BBBB#BãBzBW
BQBŅB8RBʣBpBGBBBffB\)B#B(BB  BfB  BzB8RBB
=BBBBBB\)BB³3BW
BĽqBQBŨB.B\BffBBB)B=qB
BLB=qB.BʞBpBuBȞBGBǮBzBW
BŅBuBƔ{BaHBW
B.B{BŨBǣBȔ{BfB8RB.BQBB
=B\)BaHBfBGBǏ\BǙBƣBǏ\BkBzBBB.BffB=B  BBqBLB{BB  BaHB BuBBffBBBBB\)B.BBGB\BBpBBBB
=B=qBLBW
B
BBBB=BBqB8RBB
=Bó3BBBB
B  B\BǅBaHBzBaHBBBɏ\B
B\)BffB  BBaHBƏ\BBuB=qB  BkBffBaHBBBó3BBGBɏ\BBBǮB.B#BBB#BBBȮB=qBB˅BʞB)BB\)BB=qBW
BʣBzBuBpBƮBBBǏ\BW
B=qBƙBų3BŅBŏ\BBaHBƅBǙBB33BBBB#BW
B BÀ BkB{BHBzB
BuBBLB
BqBB=qBpBffBLBB.B(BRBffB.BŮBBpBfBƮBǔ{BBB\)B33BȞBţBHBBfB̔{BGBfBǔ{BǣBǔ{BBǨB\BșB{BfBʸRBBBLB  B̏\BB\BB)B̀ B33BBB˳3B33Bˀ BB(BBQBHB\)BzBzBʳ3BBBBBuBB\BɊ=BBɀ Bɏ\BBǮBB\BB{BǅBB\BBBBB  BǮBȣBǮBfB=B(B
=B\)B8RBBW
B{BpBŮBuB\)B³3BBHB)B B\)B)BʮBaHBĊ=BGB\BBzBĸRBBaHB)BLBffB
=BBBGB)BBB.BBBzB\)B(B=qB.BBB̅B̞B)BΣBͅBͳ3BBB
=BB8RB.B8RBǮBγ3B)BzBͅB)BͣBBBɏ\BBQBBkBBaHB̳3B(BGB#BͅBkB͞BͣBB#BfB
=BɸRB\)BB
BBBBHBBpBBB#BBHBzB{B(B BzBBBBW
BQBfB®B
=B\)BBkB8RBGB
BBBĞBBęBfBǮBǳ3BBBBBʏ\B{BLBffBʏ\Bʔ{B=qB33BLBkBGBBBHBΨBzBBBBffBșBB˨BkBaHBBBBLBkBLB{BHBW
BƅBW
B
=BBaHBɔ{B#BkB#BBʊ=BǮBɀ Bȳ3B)BǅBHBBffBkBƙBƮBBƮBffBuBŨBHBąB£BB8RBzBuBBRB  B
BBBB
=BBBQB#BW
B8RBRB=qB33B
=B\B{B=qB
BB
B.B  B{BǮBW
BBGBkBkBffBQB̊=B\)BBBQB8RB33BuBpBkBBΔ{BBB=qBΔ{BuB˞BBzBBǮB\B33Bų3B
=BB\)BB=qBzB¨B\BaHBB
=BfB˔{BGB33BQB˳3BffBBB̨BBB  BpBW
BW
BffBQBɔ{B\B=qBuB  B=qB{B\B{BBBffB8RB8RBǮBW
B#BzB(B)BBqB#B½qBó3BW
BÀ B\BpBHBpBBÔ{BB  BfBGBȞBBB˨B8RBͽqB͞BLBB
=BBˊ=BkB
BθRBkB(B(BGBLBQB8RB=qBΞBνqB΀ BaHB#B.BBpBBBkBBΙBͽqBHB33B͞BBBaHBBLBkBBHBB.B=qB̽qB\BͅB.BBʳ3BBBkB8RB#B
=BW
BB
=BƞBHBfBfBɳ3BɅBfBaHBBB#BLBB\BǸRBfBBʅBffBBBB  BBB\Bȳ3BǙBLBșBzBʅB\B̨BB=qBzḄBB  BǮB8RBuBνqBνqB  B͙BLBǮBBHBΨBΔ{BΨBΔ{BzBBBkB)BBˮBHBBBBkBGB̏\B33B.BBB{B  B
B
BfBBLBffBBB˳3BffBaHB
=BB  BBBHBɸRBɽqBǮBɽqBɳ3BɸRBɊ=BBB33BBBBpBBBLBGB#BQB{BB8RBɣBW
BəBB
BLB̸RBB(B=qBʀ B(B{B  BƣB33B{BB͙BB.B̮BaHBpBBͳ3BBΙBϏ\BBB(BЊ=B
BBW
BϞBuBBpBB\)BǮBѣB\BѮB(Bϔ{BGBaHBQBхB=qB#BǮB=qBϏ\BpB8RBBB)B=qB̀ B̅BˮBB33B{B\)B̽qBBB=qBBB̮BǮB̨B̽qḄBBˀ BW
B˔{B33BBfB
Bʊ=BpB8RBɸRBGBBȞB(BkBǙB  B\BuB.BȔ{BGB̮BfBaHBBBuB)BQBBLBBBuBkB͞B.B
=BW
BB#BBʙB˽qBuB̞BGB(B\)BΔ{B  BД{BBaHBBB=qBuBЏ\BB{BBB\B8RBBBfBaHBW
BͣB#BHB͏\BBΔ{BϞBήBθRBB=qBW
BuBͣBB=qB33B͏\BzBHB̀ B͸RBQBBBfB˙BGB#B.BBB\)BBfB
=B)BBzBGBB˽qB#Bϊ=BaHBΔ{B˨BBBHBLB  BHB=qBuB\)BBpBʅBBȀ BǊ=BBuB#Bγ3B)BfBB
B
BaHBBؙB)BBB\BpBB
BfB{B
=B(B  BfBBѣB
=Bѳ3BѸRBѽqBzBzBpBBǮB\BЙBЙBuBzBBBϙBGBϔ{B#BϏ\B=qBQBB33B(B
BBͽqBB˙BHB
=BzB(BB8RBǮB.B\)BǊ=Bǳ3BpB{BɅB#B.B33B.BB̙ḄB
BB=qB8RB=qBBpBƮB  BȣBQBȽqBBBB̊=B̸RBLBLB.BBfBǮBuBхBB)B
BѨBpBffBѸRBLB\)BBԸRBԏ\BBB(B8RB)B=qB33BѽqBӽqBffBѣBW
BpB(BҀ B{BBaHBB{BЅBBBBОBB
BHBBGBBǮBQBҏ\B̸RB=qBB΀ B{B
B.B  BĊ=B
=BBǮB33BB\BB#BǅBȣBʳ3BȸRBBBffB)B\BW
BBLBuBB8RBpB̏\B\)BGB̙BǮB=qBffBB(BBнqBuBLBzBzBԳ3B)BBBHBffBՔ{BzB  BףBGBQB׸RBGBה{BֽqBB
BfBڙBBԳ3B
BB=qBB
=BBGB  BB(BBǮB{BԔ{BBkBBъ=BǮBzBה{B)B.BͣB͸RB#BaHB)B#B
=BGBHBBBfBɮBBB{B  B\)BB˳3ḄB̙BBpBBΨBB\)BGB8RBBBkBͨBHBϣBϮB8RB͔{B33BșBBBBBBѳ3B\BǮBW
BHBB33B\)BB#BW
BBգB
B
=BBBHB)B\BGBѮB  BfBΙBҳ3BLBffBӨBpB\BzBҽqBGB
BBffBkBffB.BǮBkBB33BBB8RB.BԸRBffBBB\)B̸RBkB33BBͅB)BB˙BGBBpB=qBɔ{BzB˽qBGBaHB̀ BkBBuB
=B˙BGBʽqBˮB(B͔{B͸RBυBϏ\BϨBBг3BBB\B  B\)B(BBffB{BpB(Bͳ3B)BBΊ=B)B
BBBLBӽqBBԽqBkBծBfB
=B֮B(B(BB=qB\BBB)BBֽqBfBBبBaHB؊=B{B\)BuBϮB(BuB͞B33BLB͞BGBϸRBB\BͽqB͸RBHB  BBBͽqBͅBϸRBB#B΀ BzBШBBB.BBBɅBB
=B.BB{Bɀ BB{B
B=qBQBfBBHB{B  BB=BfBaHBHBB)BB8RB  B̙BQBȊ=B
=B\)B
=BQB8RBpBQBȣB=qB̏\B˞BǮBBɞB̨BBBfB)BBzBffBfBҔ{BzB#B͙B\BBHBͅBkBGB#BЏ\BGBBє{BѨBǮBLBBHBffB\B  BǮBBBB¨BkBBBpBǣBɏ\BHB8RB33B.BBB BuB33BfBpB£B8RB=qBBBHB BB{BLB3BHBGB
BaHBQBQBBHBpB33BșB#Bˀ BB{B\B8RBήBͽqB  BBBpB
BBLBǮBǮB̞B̏\B
B#Bʳ3BB
BШBkB33BǮBӸRB\)BӅBӣB)BҞBǮBхBBBBB  B#BfBB{B
=BBfBaHḄB
=BBB˳3BHBBʞBʮBzBʨBBuBGBffBǳ3BBGBęBpBĨBÞBfBBB(BŞBBȮBuBBB{BBBW
BB.BBɔ{BBǮBBǮBʨBɳ3BffBǮBBzBBB{B\B8RBBGB{B\)BBBʏ\BʅB˨BHBkB8RBpB=qBBͅB̙BGBBBB8RB=qBzBBBfB8RB{BkBυBBΔ{BfB)BBBШBffB33BϨBυB(BaHB  B)BBBBΔ{BήB΅B\BLB)BB=qBGB{BυBfBzBBBB̨BpB#BW
B̨B\BkB\)B8RB\)BB33B=qBBB˔{BʨBBʨB̀ BzBB̊=BBGB.BW
BˮBɽqBBuBəB)BBʮBˮBB33B)BuB{BBffB.Bϳ3BB  BϮBLBQBЅBЏ\BШBг3BBQBQBB(BBBB  Bг3BB\B{BBW
BaHB
Bӏ\B\)BBB҅B  B33BkBҔ{BzBBBр BϮBǮBѮBθRBHB  B#BGB33BaHBBpB
=BBˀ BBBBB)BBBBBɞBʊ=BaHBuBaHBLB  BBB
B8RBȳ3B˔{Bʊ=B33BBͽqBuBaHBBˮBHBϏ\BGB˔{BɮB.B)BͣBɔ{B\BBzBӽqB#BGBffB؊=BٸRBǮBB.BzB(B޸RBܮBBB#B.BB  BBԔ{BظRBր BBӔ{B  B8RBԽqBpB
B
=BzBљBBkBpBBBLBBB\)Bя\BzBҳ3BBB  BpBaHBkBpBΣBBBffBBΞBͅB̮B̔{BBffB
=BB̀ B̀ BkB  B̽qB
=BB)BzB\)BB{BBϔ{BϞBkBffBШBǮBЀ B8RBBBGBW
B\B
BԸRBոRB{BמBBB(B{BGB.BfBݙBHBB BB8RB㞸BBfB\B B#BGB
=BB)B
=BB(B33B\)BLBkBBBkBBzBǮB\BB\)BffB  Bֳ3BBLB\)BuBGBBBGB#BB\)BǮBӞBuBԊ=BkBӸRBW
B  BBBzBB\BBBǮBѮB.BBBBBpBfB{B  B)BW
Bس3Bۊ=BLBBHB(BBBW
B(BHB(B33BB噚B=BpBB\)B(BLB8RB
=BQC &fC=CC
=CC	
C)C
C	C.CECC	fC	
CǮCcCqC=qC
C
BBBBB3BBBB3B  BBBBW
BBBW
BLBQBGBuB
=B8RB8RB8RBW
BB33B.BݨBڳ3BٮBuBBBBBBBB#BBzBBBԽqBBBBzB.B
BǮB
B{B\B㙚BffBB BuB33BfBkBBB  B=BBaHBuBBkBB  BB#BQB=qC GC+CkC CkC!HC8RC.CW
CC BBLBfBB\B  B B
=BW
B BBBBW
BBBBBBpBBpBBkBkB)B{BBB8RB۔{BBBLB.BzBW
B.BߣBLBBfB
BBBaHBuBLBԽqBճ3B\)B\)BuBBB؏\B33BffBfBBۏ\B  B)B\Bߏ\BB\)BGBLBBBHBfB  B\BBzBힸBBB
=BB  BBGC C}qB  B=qBzBRB\BfB=BC:B{C3BB)BB(BffBBqBfB#BuBffBBaHBBB\B.BݽqBQBW
B#B
BfBڽqBpBB{BpBBLB.B.BkB.BBؙBٞBBW
B\BǮBУBՔ{Bъ=B̳3BBȸRBB֞B.BzB߀ BިBޅBLBfBBգBѮBBQBaHB(BBBBBڨBBٮBW
B(B)BBǮBBB33BHBqBBBW
BffBսqBBܞB޳3BQB8RB
B8RBuBffBaHBzB.BBBW
BB)B߽qBBޮBW
B\)BuB  BB  B=qBQB8RBBӽqB\)BʣB\Bя\BBQBǮBpBBԞB֙BB֞B
B33BB(BHB
BӔ{B8RB\)BB
=BBB
=Bр Bр BЀ BBB.BBBfBB8RB8RB\BШBBBHBuBBB#BBBfBB{B  BܙBܸRBB\BBBuBޔ{BޙBffBߣB(BǮBpBߊ=B\BBBBڀ BB܀ BaHBޔ{BQB{B=qB{BڽqBB8RBڨBBBLB)Bճ3BBǮBճ3B#BBLBGBB)BBBԞB\BәBzBBBϣBнqBW
BЀ B#BўBBffB΀ BͅB#B
B(BήBkBfBǮBɨB.BΊ=BfBB̞BBBЮB̔{BGBBϞBϽqBfBγ3B.BffBǮBHBǮBBuBϙB.BνqBӽqBљBӽqBaHB)BBBBW
BB
=B(B)BBQBƳ3BBʅB̀ B.B՞B.BB  BpBBBBB
BffBBՀ B֨BخBה{BkBՔ{BԔ{BLBpB(B33B՞BB=qBuB#BBڞBبB\BB  BpBרB8RBңB֞BBBՊ=B.BuB#BuB33B؊=BBffB33BB33B(BBBBBͮB͏\BʞB#BBBGBBB̔{B(BLBBǮBBLB͙BB#B(B̨BuB̔{BpBB33BQBɊ=BffB\Bɔ{B
=B
=Bȏ\BBBB͸RB=qBʽqB)B\BBʽqBɀ B
=B̞B=qB
BzB˨B8RBƮBBBBBB\B8RB{B΅Bȏ\BȮBɮB
B.BB̨BLBЅB
=B
=BϽqBB
BBQBpB)BBGBϣB΀ BήBuB͊=BBGB=qBǽqBBB  B(BřBkBď\BQBǳ3B\BƊ=B8RBQBBzBkBBȔ{BaHBBBƙB8RBW
B(B{B
=BB B BQBaHB
=BaHBǮBB
=BǮB(BBBƳ3BB  B¸RBGBGBBОBϣBΙB˔{B8RBǮBBB
BBHBȸRB\)BǮBʙB8RBzBƣBB¨B\BBQBĳ3B.B(BĊ=B8RB\)B
B.B\B
B#BBHB=BBGBBaHB\)BBBBBBBkBBW
BBqBBB=B8RB33BRB  B(BBBBpBBW
B33B)BB
=B{BffB#BHBB=qBřB{B
=BBHB˞BɮB˸RBB̔{BˣBʽqBB8RBǣBW
BBB͊=BʅBǮBǮBkB
BBB̀ B\BffBGBBGB͔{BW
B8RBB֊=BB؅Bٳ3B(BףB=qBأBLBԮB8RBGBBfBB{B֊=BkB)BB=qBր B֣BBׅB֔{BօBր B֊=BLB
BBB
=B=qBB8RBW
BfB\)B  BB33B֊=B֞B\)B(BBգBkB\BԅBԞBՙBW
BўBӳ3BԅBB
BBBW
BԳ3BBBkBϙBΣBBB̏\BfBGB{BfBLBuBBBW
BkB33B.BBΊ=BzB33B{BBBͳ3Bͳ3BBBaHBQB.BLBHBBBBͣBB͸RB{BB#BzBӊ=B  BӽqB(BӔ{BQBBaHB
=B{B.B33BaHBGBΔ{B\BBBʨB\)BzBB8RBǀ BȞB)BḄB̏\B͏\BB8RBpBfB\)Bӊ=BpBGBBգBӮBW
B#BfBBBB
BBڔ{BGBaHB۞B(B8RBfBaHB8RBkBB
=BخBQB
=BzB.BBBBԨB#B\BҮBя\BѽqB{B=qB)BaHB  Bѳ3BBBBBHB33BѸRB\)BuBУBQBfBBBBLBήBkBGBaHB  B#B33B  BuBBfB8Ry B  BBνqBfBGB.Bˀ Bͳ3Bͳ3BBffBkB̀ BBW
BǮB.B\)Bʔ{B{BBQBԀ BzB)Bה{BBѮB)B  BffBBGBֳ3BBQBҽqB{BQBB=qBffBB33BӸRB  BԔ{B.B(BB  BԅBQB=qBҮB)BBBнqBBϞBW
B  BϨBϨB\)BB=qBB
BLBЮBУBυBB
=BBȨBɽqBBpB.B  BLB(BBΏ\B̸RB̞BuBB  BͮBkBΣBǮBBffB#BϸRB(BLB#BuB{B\Bȳ3BBB
=Bʔ{BQB
=BBQBBʙBuBBBB  B
B{B˔{B33B
BfBє{B(B
BLB=qB
=BΊ=B
B.BGBBBΣBBBBHBkBB˽qBBB.BkBǮBzBǅB\)BBĳ3B{BB.BBB(B)BBBBĔ{BffBBÅBB=qBB
=BøRB#B=qBffBB=B3BLB\B=qBB#B\BqBBkBBfBBBqBǮB  BGB BqBqB.B{BffB  BBBW
BzB\)BBLBHBBRB\B8RBBĞBB
=B
BBƞBǣBǮBɨB)BuBʽqB
=BʨBBBǅBBB#Bǳ3BB33BǮBpBBkBBBfBƮBBHBB.B BBBfBBBBB  B=BzBaHBkBffBBBB  BB{B\B(BaHBpB=B)BzBW
BRBB=BBBB{B{BfBBaHB8RB\B33BHB3BqBHBB\)BqBzB
BBBB33B33BQBB
B BfB=qBB3B8RB
BLB  B
BaHB=qBHBB{BBBBBzBȞBɮBȔ{B(BBBkBȅB#BBǣBzB
BƣBƀ BaHBƏ\BƅBƮBpBpBuBQBƔ{BpBBBkBŊ=BŸRB  BǮB)y B  BBĮBĊ=B=qBƽqBŽqB33BĀ B#B=qBHBƞB.BaHBBuBBB=qBBBų3BŞBBBB B BfB{BpBBBB
=B
=BB.BRBBBBBǮBęB
=B  BzB33BLB
=BƳ3BBBB  B(B33BzBfBzBaHBɅBW
BzB\BBBB#BpBBˏ\BB  B\)B̨BǮBͽqB\B̽qB΅BǮBϣBpBHBGBBBBQBQB{B.B)B̙Bʀ BBŮBGB
=BBLB  BQBW
BQBQB(Bǀ B8RB
=B{B8RBƙBǮBȽqB{BB.B\)BǣB8RBǞBǮBB
=B)Bɔ{BGBHBLB̨B\BɸRB#B{B˅B
=BBuBHBuBB˽qBaHBHBȨBȊ=BBB
=Bʏ\BB8RB\BaHBLBuB8RBˏ\BB̊=BLBǮB8RBHB̊=B˅BzBBBBBffBʽqB
Bɳ3B)BLBHBBLB#BƮBǮBɳ3BɸRBBHBB33BBƳ3BBŽqB(BaHBƀ Bȏ\BuBƨBuBBBĨBŸRBBBGBB{BǞBB.BĞBkBBĸRBaHBBBŏ\B(BBW
BƅBzBȽqBffB\BpBBBBȽqBƏ\B\)B\BkBǮB¨B\BfBuBB\B.B\BƸRBB
=Bʳ3BBHBBuBzBHBƙBGBQBʣB  B̔{B=qBHB
BLB{B˸RB˔{BʽqBkBB
=BW
BkB̀ B)B(B̨BffB
=B̨B̅B(B˞B(B33B̽qB͏\B33B˸RBB˅BBɊ=B{BuBBBB(BLB=qB(BffBBŅB\BBBų3Bó3BĮBĨB  B\BB)BBffBƀ BǅB#B)B\)BBŞBpB{BffB#BaHBffBʅB\)B  B̊=BLB̽qBBBW
BuB̏\B̳3B
B̸RBHBB  BBBBǮB̙B̞B=qB.B̞BB̊=B8RBB8RB\)BǮB̔{B
BGB˙B˙B
BʅB  BʸRBGB˞BkBBȅBGB{B{BQB.BʮBʀ BLBBB
B\)BLB
=BW
BLB{BLBBBHBW
BQBƽqB\BƅBaHBBBQBfBuB  BȔ{BB)BHB  B8RBBBŨB\BfBBĀ B=qBGBƅBǀ BBʏ\BBkBffBBaHBW
B¨BBBBBBȏ\BGB=qBB(Bˊ=Bˀ BLB
=BfBɅBȀ BaHB=qBBHBB{B\BƽqBBBffBǞBBzBƙB\)BQBƊ=BƨBBQB33BHB)BĊ=B
BBffBBBLBͳ3BʞBB̔{BǮBˀ Bɳ3B
BʞB
=Bʳ3BǸRBƮB
BB
=BGB\B  B.Bɳ3BLB
=BkBffBffBfBBBW
BBzBʨBBĳ3B\B8RBLB\)BffB̅BǽqBȣBGBBHBHBǏ\BBνqBBB.B#B\BaHBzBǽqBȳ3BɨBȔ{BzBȨBHBȔ{BBBʅBBˀ B33Bˊ=BuBkBBGB(BƣBBBaHBƊ=BŸRBĞBÏ\BǮBřBLBB33BB\)B
=BB\)B#Bǳ3BB8RBBQBBzB.BBuBBpBB(B=qBBBBBBLBW
BGBBfBGBB£Bó3BBGBGBŅBţBĊ=BzBfBó3B33B=qBBLBɀ BɞB
=BʨBfBBBB
=B˅B(BHB˽qB(BBB)BB)BGB(BaHBzBBaHBˏ\BǮB.BB#BB  BəBBBBəBGBɮBGBBʀ BɨB=qB˨BBBʔ{BBɨBʅBșBBBaHBB33BGB(Bˏ\BzBB\)BB  B)B.BkBB8RB BB8RB
=B\B33BƽqBaHB\BBǞBɅBBƨBuBBB
B)Bɏ\B33B)BzB\)BzBfBǙBHBB̽qBffBB\)B)BΣBΊ=BˣB(B  Bɏ\BɸRBBB{BЅBъ=BϣB33BϮB͏\BήBkBͣBBffBGB̀ BB8RB
B̅BBBfBͅBpB)BBaHBɏ\Bʏ\B
BB
B)BʅBɨBffBɽqB\BȔ{BHBBQB\)BfBǙBB)BzBęBkBaHBBģBąB
B{BQBɏ\B)BȊ=B.BȞBBffBəBɮB#B)B33BʅBB
BfB(B
=BzBBBzB#BBLB̏\Bͳ3BHBzB\)B)BBBҏ\B\)B  BBB{BԔ{BBaHBuBB#B֨BffB
BԣBԊ=B#BBBBͨBυBB  BBW
BGBaHBBGBǮBGBBB8RBkBπ BνqB  BBaHB33B\BB)BB\BkBΣBGB͔{BuB̞B̽qB̅B̽qBB(B̏\B̮B#BpB
=B\)B̀ B
BBW
B(BBkBuB8RBˮB  BB  Bɏ\BəB͔{BҨBǮBHB.Bϔ{B(BBӮB.BGB\)BָRBB؏\BGB\BB)Bڀ B؊=BHBkBBǮB{B\B\)B(BBB׳3BGB  BaHBؔ{B
=BמB=qBՙBpBBBϙBBҮB=qBBճ3BҙBѸRBҔ{B8RB\)BBW
B{B\)BQB#B{BuB8RBkB#BBffBB͏\BϽqB{B̔{BGBBBΔ{BLBuBuBBHB{BB˅BBfBǀ BuB{ḄB̀ B.B͸RBΏ\BǮBB\)BB\B(BոRB
=BzBBffBֳ3B8RBpBǮB  BBأB)BܨBܳ3BB
=B#BBߞB
BQB.B#BǮBaHBٙBBB{B
=BBBzB؞BBBBB
B)BBBӞB=qB(BΏ\BǮB
=B\BոRBfB{BBBHBGB=qBB\)BaHBъ=BpBGBfBW
BW
BHBQBLB(BuBѸRB\)B\)BBaHB#BՔ{B\BBkBըBaHBzBuB{BpBBٮBBBڳ3Bڊ=BBzBuBHBLBBޞB߸RBuBފ=BffBڅB܊=B۞BLBBHBaHBB8RBB\BBBBBzBW
BBGBីBfBzBB܅B\)BBB.B=BuB BkB8RBuBffB
=BffB)BkBkBB=qBB߀ Bߏ\BaHB{BLBߏ\B#B\)BߣBBB\B
BBBٸRBBǮBϊ=BW
BӮB
BW
BkB8RBԣBB33BݮBڏ\B33BB\B)B3B8RB٣B=qBBBٔ{BBߙB8RBHBW
BzBaHBB=qBqBǮBpB۔{BRB\)BLBuBB{B鞸BpB3BBzBBqBLBzBǮBuB޳3B  B33BQB.BpBQBGB
B#BkB֏\BǮBfBؽqBףBՙB(Bֳ3Bۊ=BzBBǮBBڮB)BkBffB33B(BBڙBffB
=Bٳ3B  Bڀ BLB
BBkBffB
=BؽqBبBBB8RBB׏\BW
BBB؊=BQBB  B\)BۅB׊=B=qB{BBBBBمBpB(B.B׸RBGBB)B۞BaHBfB
BuBܳ3BBfB8RB
BB㞸B33B33BB  BBHBB(B螸B\B8RBBBpB=qBW
B33BW
BB{B=BBqBaHB{BB\BB(B  Bޔ{BBBzBqBBBBzBW
BBB۸RBٽqBBBBzB33BרBBָRBffBգBBBǮB֊=BӅBuB=qB(B
BBBҮBkBӣB)B\)BBԸRBpBLBaHBҨBGBaHBW
BB{B\BW
BBB
BڮB33BBuB.BkB׸RBڙBQB8RBuB33B=qBQB
B\B#B3Bߔ{B8RBkB33BB{BGB(B=qB(BBBݞBBLB33B۽qBBݮBpBس3BBLBӣBǮBǮB.B{B
=BffB33BBBBBգBHB.B=qBԊ=B)B#B{B\)BQB=qBB#BuBffB)BBBҮB
=B)BQBѮBBGBkBBQBpB
=BBҀ BBLBBBʅBHBuB  BBBW
BQB.B  BB
B.BBQBuBB)B33B(B\)B8RBBB.BBpBffBHBBLBߣBB#B׮BaHBBǮBۊ=B  BBBkB{B{BBBՔ{B#BW
BظRB  BHBB=qBGBBB.BkBzBԀ BҮB
=BBޣB(BffBԊ=BQB
B׊=B
BW
BԙBfB(B=qB
BԨB.B.BpBBB{BB.BzBQB֔{B#BBBըBԀ B=BBBǮB{BuBB.BB=qB{B  BBfBW
B޽qB)B\)BffB33BffBqBfBaHBB)B{B  BLB=qB(BBB\B(BRBRBfB=qBW
B33B.BٽqB݊=BaHB.BuBޮBzB\)BB\)B\)Bъ=BBٮB
=BBЊ=BԣBBس3BBؙBBGBB#BǮB8RBGB)B
B
BffBpBBHBޞB
B
=B
BBBffB8RBB׀ B.BBٳ3BBӳ3BzBpB{BGBBfBffB
BBBLB)B(B#BB
=BuBW
BBۙBkB߀ BB3BBB癚B
B\)B(BLBBB
=B
BQBBB=BqBQBBGB33B
=Bݏ\BfBpBBaHB8RBfBffB{BGBBBBBݞBBBBݽqBGB۽qB33B\BǮBݣB޸RBfB=qBހ BBBB\)BBaHBB=qBLB؞BۙBB\)Bڊ=Bي=B٨BBۨBڽqBڞBHBHBkB۔{Bڀ B޸RBB{BBHBBB޸RBffBuBaHB(BB۔{BBףBBBݸRBGBBBpBBB33Bߊ=B)BkBǮBqB\)BBB\)B݊=B33BW
BB{BBߊ=Bߔ{BB\BB Bޏ\BBݨBpB#BGB8RB\BBfBݮB#Bܳ3B݀ B33B޳3BB۳3BBB{BڨBB۽qB{BڮBڳ3B.BLB.BfBمBُ\BبBԞBъ=B)B)BQBBBkBBBԊ=B{BuBЙBB\B{BԳ3B
=B33BB
=BB  BfBkB#B8RBٮB.BaHB\)B٨BՏ\BݮB8RB(BǮBǮB.B{B݅B֔{BzBBfBۅBaHBHB33BBHBBB3B\BBBGB(BB(BBHB=qBLBkBGBB)BBpBBظRBkBB(BبBW
B֞BW
BaHB؅B=qB
=B  B׊=BBB֣B֨B.BBkBkBGBW
B\)BBҸRBҞBЮB{BW
B\)BШBLBЏ\BϽqB  BљB=qB  BԮBkBBfB#B.BԳ3BBBרBffBpB(B=qB؊=B\BBBҸRBaHBBԞB.BԳ3BBaHBיB
B
=BfBLBBB=B  BGB
=B(BBݙBB#B޽qBkBߨB֨B
BBڞBBBڨBW
B#BՏ\BԮBuB؀ BB33BծBӽqB{BBB#BBaHBkBfB=qBffBָRBQBBγ3B  BBLBB(BLBfBkBҀ B\)BBB#BB΅B\)BHBҙBBBBuBي=BffBBW
B33BB{B{BpB.BpBGB(BkBB֊=BǮB)BBծB׳3BBBGBـ BB)BBfBBBٮBǮBي=B  BBؽqBQBLBBـ BBؽqB(Bۊ=BڞBBuB\BמBffBǮBBBffBuBuB
B\BQBfB#B֮BkBBB8RBԀ BӅBB
BW
B
Bр BuBLBўBBuB
=B(BBuB\B\B\)B8RBBѳ3B  B
=BB)B8RB.Bє{BW
B#B
=BϮB8RBBB̀ B.BBBfB)BuBҽqBҳ3BBBҙBѣBѣBя\B)BB)B33B=qB=qBҨBԳ3BLBոRBԮBգBה{BLB
BԞBB{BLBיBLBǮBpBB֊=B՞BԳ3Bԏ\BBLBӔ{BBՔ{BՅB.BҙBӊ=B\)B{BЮBkBBǮBϙBѨBҔ{BBҞBpBaHBϮB
=B
BLBͮB
=BЙBңBffBӨBHBәB
=BBϳ3BHB)B.B  B)B  B(BpBffBBBʽqBBʏ\B{BȽqBǣBaHB=qB
=BɸRBpBəBBkBB\B=qB  BˮBΨBBΔ{Bπ BBBД{BͮBB΅B(B΀ BǮBBBǮBǮBzB˔{B8RBͳ3BBBpB8RB33BBB΅BB(BBBBHBϨBpBΣBaHBLB)BBȅBɨBǽqB  BW
BpBșBfB.Bɔ{B(B.B(B˽qBʀ BB BaHBBuB
=BffBffBLB=qBGBĨBuBW
BBǙBzBŏ\B{B{BW
B33B=qBBQBLB.B{B8RBBzB{BƸRBuBBBB
=BB)BBB=qB\)BB̊=BΞB.BB
=BҙBBW
BffBQB#BBBuBBǳ3BzBɮBQBBB)BaHBʅBBuBkBBB
BBBɊ=BQBBpBB=qBΙBpBuBpB\)BЊ=BҀ Bя\BД{BBBuB̞BBBΣBBˣBB͸RBaHBQBнqBBBҨBaHBѮBBBBB33BBӮBBHB#B#BBԽqBuB  BGBBB8RB33B؞BLB=qBي=BffBuBLB؞B=qBBۙBuBBٳ3B
=Bُ\BkB؏\BׅB֮BBfBLB֊=B.BӮB
=BνqBήBW
BzB\)BBkBBuBӮB.BʣBƀ BBBǮBBąBƏ\BɣB.B\BaHBхBBўBLBBQB
B(BЙB#B̽qB(B˳3BBffBaHB\)BBBÀ B=qBBffB8RBBͣB=qBѮBӅBzB.BӀ B{BԀ BGB8RBBaHB{B  Bה{BB׀ BօBkBۅBBBܮB
=B߳3B33BffBٔ{Bـ BkB\)BBBGBBGBzBB߮Bݏ\BpBހ BǮBBB#B(BaHBǮBBaHBBۅB#BڽqBڀ BBٔ{BǮBffBBس3BՀ BٙBB۳3B=qB)BfBB.BۣBHB#BB33BuBB8RBHBB)Bٔ{BW
BBaHBBfBB׊=BӣBԅB\)B\BОBfBЊ=BBzBBBpBuBֳ3BיB׽qB\)Bٳ3BB{BǮBQBBBBـ BۙBBBzBBBBaHBB߸RBaHBRBuBkB3BB=qBqB)BB\BBBffB
B{BBffBLB=qBGBHB B=qB{BpB.B BBB  BuBRB➸BGBبBBB
B\BٸRBB{BffBۮB֔{BkBBBBBW
BB\BօBր BףB(BBBzBHB
=BaHBffBffBkB݅B8RBHBݽqBzB8RB޽qBkBW
B뙚B{B.BQB\Bݏ\BB{B{BսqB  B
=Bߏ\BBߔ{BBLB33BBBBBBBB晚BB#BkB  B=BzB\)BB=qBBߣBڳ3BB(BaHBB8RB(B8RBǮBBB)B8RB#BQB8RBkBBB(B=qB)B33B#BffB#BڞBkBܞBڅBLBڊ=BЀ Bр B\BkBӳ3BҔ{BLB\B
BB(BǊ=BB  BBaHBBϳ3BkB)BΞB)BBBӞB(B33B{BzBBW
BfB.B\Bۊ=BԨB#BB
=B\)Bҏ\BBLBҙBօBיB
B  BۮBW
BQBqB\B=qB3BBfBBuBkBHBLBBqB瞸BBB➸BBBBBzBBBLB߀ BfBBBB\)BLBB33B.B݅B33BpBBuBHBGBQB8RBuBfBLB33B#BfB݅Bڳ3BٽqBBBה{BpBє{BpBHB
BԽqBB
BBzB
=BGB8RBBfB  B\)B٣BأB8RBB=BBBHBW
BBBB#BLBڽqB8RBB(BB߸RBQBLB
BB B\)B{B  B8RBGBffBffBqB=qBB3B
=B߳3B=BǮB{B{BB߮BܣB(BBkBܨB8RBڙB8RBᙚBLBܳ3BBzBծBۨBBBBGBB֊=BBQBB׮B֞BBBpBzB٨BGBB.BW
Bي=BpBՏ\BfBzB33BӅB
=B)BB8RBBB8RBBGBۣBfB݊=BBB=B{BǮBaHBីB
B
=BGB{B33BڣB  B8RBHBW
B(B#BHBܽqBB
BHB{B
BW
BpBGB{B߳3BqBBBBۀ BzBkBkBkB۞BB8RB=qBB؏\B#B؊=BuBרBB֣BׅBGBQB
=B33BBzB8RB׊=B)BpB=qBרBW
BzBBLBӸRBBB
=BBBW
BҀ BЀ BBzBЀ BBBОB\B{B8RBffBBɔ{B(B˞BBˏ\BffB8RB
B\BBBffB{BfBB33BkB#BΔ{BuB33BўBBϏ\BBffBfB=qBϽqBffBγ3BBffB)B{BBffB  BӞBBaHB
=BսqBQBԣBӸRBBffB.BffB8RBBBԸRBW
B{BԔ{BkBӽqBԅBԊ=B=qB)B(Bъ=BHBB33BLB
B8RBBBBpBaHBBB  Bͳ3B#BffB˞BGB˳3B)BBBˣB33B\)BǮB  B\BaHBB(BB)BBBfBkBϔ{BBBB\BѸRBѨBQB  BϣBг3B8RBffBW
B͸RBkBϮB
=BzB.BBBBңBBB.BԅB
BBLB=qBaHBffBW
BBBB\)BԳ3BkBBW
BzBBԏ\B(BBԀ BBӣBӨB.B
=BӽqBBB\)B8RB\B
=BҊ=BҨBuBBҀ BҙBҙBB\)B
=Bя\BBB{BW
B)BӅBӀ BW
B#BB)BҊ=BaHB.B33BpBHB)Bϳ3BД{BaHBaHBϨBB)BpBBHBΊ=BQBǮBB8RBиRB33BBpBB8RBBB{BՀ BHBBBzBǮBaHB܀ Bܳ3BB٨B=qBzBaHBܔ{BBۏ\BBBܨB8RBLBB)BW
B׸RBB)B33B׳3BQBօB֨B  B\BW
B=qBՔ{B\)BӸRBzBѨBfBǮBӊ=BѸRBBuBBB{B
BGBўBBQB\BѣBўBBB(BЊ=BǮBBGBkB8RBGB33BУB(BBpBGBBQBBaHBОBB
=BfBԽqB=qBHBBBB33BBpBBfB{BGBBׅBBLB؞B8RBBBpB\BpBۅBۏ\BBB  BBHBB.BQB\)B
=B=qBBBGB\BpBǮB{BBBqB(B
B8RBBB#B(BޞBǮB33Bѳ3BǮBBBգB׊=BBB\B#BB֣Bր BfBBffB
BԊ=BB=qBԸRBԅBBBzB=qBzBffBW
BaHBǮB\BW
B
BffB؏\BB
=BݽqB(BzBW
BLBBB  BBffB.BHB33BfBڸRBpBǮB8RBBuB(BBBBBB33BǮBᙚB#BW
BB33BBHB
=BHB#BuB BRBB33BBB{BBW
B\BBB\BǮBLB
=BBffBkB\Bڊ=B=qBW
BBBuBQBBB׀ BոRBHBӅBרBԔ{B.BBхBBЅBЅBBaHB=qBuBBaHBBBѸRBҮB(BӸRBW
BBֳ3BمBaHBܳ3BBaHBBHB\)BGBuB܅B݀ B)B)B
B#BpBkB\BBB)BB{BǮB=qBGBBzB.B.BqBBBHBBkBkB=qBBBBkB
B{B)BzBBfBHB33BԳ3BBzBBQB{B(B{BB\BBиRBLBBaHBzB  B
=BBҮBBB.B̅BQB̞BɞBfB\)B8RBffB  BLBB
BBB8RB)BBBfBˏ\BkB#BBzBBǮB#BѮB  BӞBBB33B֣B(BמBBB(BB٣BQB
BkB#BרB33B֨BQB8RBQBبBمBٮBGB.BLBW
B=qBuBՅBaHB{B  BGB
=BBՅBaHBգBBBԏ\BBBBkBԊ=BBzB\BffBuBОBЙBBpBHBzBLBuBˮBB33B˸RBLBW
B̞BBΔ{B{BЊ=BQBBπ B\)B(B)B(BД{BϏ\BBB=qBBBpBBQB(B
BB
=BգBfBHB
=BBpBBBBzBBBؔ{B  B٨BBQBB\BW
BGBٮBBBB؅BBـ BQBpB؞BB\BBBffBW
BzB33B׏\BBBffBBBՀ BǮBBpB#BB
=BBkB(BzBҏ\B҅B8RBBиRBг3BB\)B  BД{BHBBШBQBД{BнqBBB
BB#B8RB{B  BBԸRB֞BӅBBԙB׏\BBQBָRBffBBՀ BBӅBӽqB(BԀ B{BQBpBfBaHBzBfB)BܸRBݳ3BBܣBuBܨBܣBݔ{BܸRBBBB(B33BB\)BQBBۏ\BBݔ{BBBHBB33BיBB)B\BBkBǮB
=BLBBBfBӳ3BՔ{B=qBBkBBBBBQBW
B=qBB
=BLBaHBBՅBW
B(BB{B\)BLBB
=B{B=qBBսqB.BBpB͸RBB#BB#BѣBuB#BkBB\)Bճ3BǮB8RBBֳ3BBW
BծB(BW
B33B(B8RBBBBڊ=Bڀ BڞBffBLBBǮBڮB  BGBǮBaHBڮBBfBLBBQBQB
=B(BuB\)B܊=Bݔ{BݽqBB#B\)BBB=qB=B\B
BBBHBuBܳ3B\)BB
B\)B߳3B  BBfBBQBBaHB8RBQBBB\B؀ BBBB)BB)B
=BԮB=qBBLBսqBGBٔ{BqBGB=qBBݮB\)B)B(BuBꞸBBGBߨB
BHBB݀ B  BGBaHB\)BuBLB޳3BޮBuBQBuBBLB枸B\)BBBfB(B\BaHBkBBB♚BBLBܽqBB
B\BǮBLB݅BǮBBB(B.BaHB{BBBBߨB)BpBBBB{B{BHBQB(BW
B
=BBffBLBW
BfBzB݅B8RBHBݔ{B#B؞BBبB֞BpB{B33BרBڮB۔{B
=B)B33B\B3BaHBRB
BǮB BBQBuBգBԮBB33BBߣBޙBߞB{B=BLBBB#B3BBGBBBBuBaHBffB B
B랸BHB\B(BBW
BuBfBpB
B)B(B\B螸BRBGB3B8RB㙚B\BzBB\)BzB\BW
B
=B BꞸBBB.B{BBRBffB#BܽqBW
BBB߸RBBBBܸRB33BB  B3BB  BߣBB  BB(B(B)BB3B\BqBBaHBkBԔ{B(BBBGBBBٮB؏\B׏\BHB܅B޽qBqB\BBB BffB)BHB\BB=qB3B BfB33BBBC B)BzB BB=qBBB8RBuB  BBBBLBB\BBkBBB\BB{B B B)BB.B(BpB\B{B=qBBaHB\BB=BHBHBkB.B3BꞸB33B(B3B\BBBGBB)BB  B)BB#B.BB)BB瞸BBBQB
=B܅BLBzBpB  B\BuBB(B\BB
B{B)B{BBC fC)C
=C{C
=CCCC@ C	QCcCC
CT{CCfCCCCqCC
C(C+CT{C3C\C)C0CCC	
C \CCBC:B\C#B
B8RB
BB
BfBpBB.B
=BW
BRB#B#BBB؏\B.BzBHB8RBހ B  BڅB
=BBHB
=B)BffBBB݅BݮB
BB)BfB)B8RBBB=BGB=qB\BQBBHBzB\BfB  BqB
=B\)BB{B{B{B.B.BQBzB#B=qB\BCCqC޸C
s3C8RC\)C
C)CCCC  CkCBC
LC	(C C)CC޸CǮCxRBfBBpBLBuBkBHBkB螸B{BB=qBQB\)BRBB
BBBC ޸BRBaHBǮBBuB8RBkB(B=qBRB\BRBffBfB{BBB
=BzBBBpBRB#B{BBkBBW
B.BBBffB
=B
BLB\BBBBBfBB B33BffBB  B
BpB晚B#B.B(BpBpB8RBB\BBaHB
B=qBBB=BBǮB{BǮBB.BBHB#BQBqBBGB\B=B
BB\)BBBffBHBB8RBB=qC 0BBQB33BB.BB.BB(Bؔ{BzBBuB#BǮB\)B݀ BBpB  BuBB
B\B  B\)BBBBfBǮB螸B\)BqB BBBW
BB8RBuBB
=BuB8RBBBBB{B㞸BBB3BqBaHBaHBuBBBB\B\B{B=C CffCC=qC8RC)C=qCxRC\)BC BpBBǮBuBB  BB(B
BBkB=BffB
=BB)BBzB#BpBBRBBRBqB{B)BfBB
BBQB{BBBB
=B=qBB.BfBfBBнqBӞBܽqBОB{BB{BaHB=qBОBє{BǮBHBٽqB
=BLB\)B\BLBfBBB(BBB晚BB虚B)B3B33B
=BB#BkB33B(BBzCBCCCcC C )C zBB BBB#BBBBRBaHBfBaHBBBHBfB#B#B=qB)BBBBLB8RBBᙚBfBרBӊ=BB
BיB֙B(Bݳ3BfB.B\)B)BW
BBBBߨBaHBW
B=qBͮB\BBBzBBBffBޏ\B=qBQBaHBB\BB
=BB.B\B\)B BBBGB=BBB  B
B  B\BzBBfBǮBB
=BB(BLB3BǮBBaHBǮB3BqC C .CT{CYC CCCC
CC@ C{CCRCB(BaHB\BBBffBHB8RBQBBB\B
=B\)BBGBB\BuBQB
BB\BBuBuBB33B
BuBBuB݀ BuB33BBؔ{B\)BLBaHB#BBBzB(BОBҔ{BLBGBBBW
BB.B)BkBBB{B螸BB8RBW
B8RBQB=BǮBBLB\)B\)B
=BW
BaHC )C HCGC)BǮBW
B#BBBBBqBB\B.BB{B
=BBǮB(BB33B)B BffBBBBBBB)BLBkBހ BHB\B
BLB.BBBB\B=BǮBB=B8RBBpB{B.BBRB{Bߔ{B#BB܀ Bܔ{BܣBݸRBQBBBGBQB)BB.B.BBqBQBBBӮBuBB.B׀ BڸRB)B޳3BBffBHBkBaHB#B)B#BBB.BfB(BzB8RB B{B33BB.BB
BffBBpBW
B#BBBHBuBB=qBQBB.BBffBBBB33BBuB{BBB{BB
BBB\B
=BBB
=B߀ B#B  BޙB\)B=qBB(B(B
B
=B=BBHBBqBǮBffBݏ\BkBfBݽqB٨BB(BuBB)B)B(BB֞BLBBܙB޸RBܙB8RBBpBՊ=B#BGB33BߙB)BBkB{BqBQBpBRBB(BB\BB  BB BqBW
BB  BBLBBfB)BkBaHB3B
=BuBQB)BBfB.B  BBBaHBBHBBBBBBꙚBB{BBW
BBBkBBB\)B(BB\BBB  B33BB3BB BBpBBBB\BB癚B{BRBkBBfBffBBHB=B=B)B3BBaHB#BqBBBfB3BBB
=B\BBuBǮBB=qB(BffBuBqB#C {C C C  C 0BaHC
=CCٚC.CCCT{CxRC CffC C C BB=B=qB3BfB{B=BLBpBBpBBB.BpB\B#BBB8RBBffBꙚBBLBkBRBBuB33B3B=BuB\)BB
=B{BڨBBBѸRBB  BffBBQBpB׸RBBBԊ=BǮBўBڙBϮBB\)BHB֏\B؅BB߅B
B.BB#B{BHBُ\BzBB BBfBffB\)BB.B{BffBC CC	^C

C
C CT{CEC
C
C	C	pC}qCC BB\)BaHBzB{B#B\B.B)B8RBaHBBfB)B\BB
BW
BB(BB BB\BBqBkBfB㙚BLB{BBLBQB3BBBkBLBQB)BBW
BܸRBffBpBuB8RBڊ=BuB
B{B݊=BQBHB)BHBffBǮBB)B8RBB BBBBpB\B(BC3C)CCffCCC)CECQC8RC8RC)CC	=qC)CRBzCCEC#C	C
CCQCs3CC	s3CYCCRCC)CCRCCC=C\C0BB)B(CC:CBBB=qBBBpB=qBkBQBpBaHBLB\)B
=BBBGBBǮB{BRBRBBBffB\)BW
B\B33BB{BW
BW
BBHBaHBB.BޣBHBܮBظRBBڞBQB  BB.B
=B{BB33BaHBBBBzB=qB BLBpB♚B33BBBqBǮC\BQB
B{BpBzBB  BHBBBBBQB3BB{Bޏ\BߞB B)BB)B.B33BfBHBpBB3BaHBB.BBBaHBB8RB؏\BuBBܞB\)B׊=BkBBШBW
BΨBήB˔{BLBB\BǊ=BW
B=qBճ3B\BͮBٞB  BQBpB̊=BָRBuBB.BBBڨBB
=BHB{B{B\)BϨBBHB  BHB=qBkB33BиRBB
=B{B  B.BHB\)BuB#BkBLBB  B\BBGBRBBHBBB(B=qBBB\BBBffB\B߸RB
BBBǮB.B)BݣBܸRBBٮB׽qB
B.BBBQBB
=BǮBHBffBBB  BGBuB8RBGBBͅB#BBBя\BB\)BBHB#BaHBB.BBՔ{BQBHBي=B#B=qBzB33BLB
B߮B߅BQBHBHB.B  BB)B=qBB3BGBBB=B{BBqBBBfBBpBCkCW
CW
C{CRC)BBBBfB33BꙚB=qBQB=qB#BBBBأBמB\)Bה{BBǮBGBGB(BBBB33BQBBW
BHB٣BaHBzBW
B\)BzB(BBaHBͽqBQBԊ=BҀ BkB  B.BӅBzBBffBBpBҳ3B̮B)BBB=qBB
=Bӊ=BzBffB)BBGB  BkBpBBaHBB
=BLB{B
BB\)BBB晚B)BpBBfBB
=BB33C:C
CCxRCC.C(C!HCCs3CBC HC ǮC=CC)BBCuBBBBffBBBB
B  BaHBBBzBBqBBQB=qBBBBaHBB#BǮBBGBǮB߮BݨBW
B
BBBր BLBήBaHB.BƞBpB  BƳ3B#B  Bĳ3BB33BƳ3BĸRBBBaHB=qBQBB33B垸BBB)BBB33BqB=B
BaHBBfBBHC CC  C	ffC
C
C
CCs3C+C
CCCfCO\C8RB B8RC B33BBBBBB3BBuBBBfBuBzB  B=BBkBBHB.B\)BHBBBݮBLBB)BBkB\)BffBB{B8RBQB
BLB33B\)BBHB(B
=Bڔ{BpBffBpBffBB)B{B#BkBW
BԙB޸RBLB{Bݏ\C =CBC=qCCC
Cs3C@ CqCCC\C8RC	C\C	C!HCqC
QC
޸CC=CxRCCC\)C.CC$QC$ffC*)C%T{C%HC$@ C)RC/CLCBC
  CO\CCCHC+CCCqCC
W
CRC	(CO\C^CQBqBBBBkBBBzBBHBzBGB)B\B=BRB\BBBB#CBCW
C33C =BC C
C C BqC BC T{BBC\CzCǮCxRCRC C
CCٚC
C
pCCCW
CC)CCCC CYC5C.CCs3CpChCC#C0HC pC*C{C"ǮC4C2
CT{CC/J=C2kC3s3C/C+fC(C&C%qC"^C CpC {C\)CHCCaHC	)C	CC +BGB)C
:CxRC
CHCffCRC BHBpBQC\CHC{CB
CT{CQBkB=qBW
B.BC)BC	hC.C^C\C=C	C C=CcC)C)C+CCC3C3C.C}qC!HC!HCCCC  CaHCLC(CCQCfCCC)CCC=qC#CC(CC!YC fC.C#}qC'zC*C-W
C-QC,ٚC*C)C  CYCCLC\CCCC(C@ CC C)C3C)CCCRCGCQCCs3CuCs3C QBC.CuCBaHC YCT{C\)C0CQBQB
BBBB\BLB)BBkBBB{BB{BǮB BGC 3BpBfBqB\BCEBBCBC@ CC
=C
CQCHCC(CCC=qCCEC@ C
C^C)CfCC=CC  CQC8RCCJ=CCQC}qCpC5C C^C޸CLCCnCcCYCC=qCCC
RC
CuC#CC qB8RB=BpBBffBBGB
=B8RBBB)CxRCC:C  C
CǮC	@ CCC	nC	BC
ECCCC B33BBB=CJ=B C#C3C	.CfCJ=CC(C :C O\B  BHBfB  BW
BuBpBBCLCkC8RCGCC
RCQCO\C	&fCC
cC=C{C)CC	8RCW
C C	cCuC.C
C\C:BBpC
 CRBBB\BB
=C{C	3CChCC)CC	 C33CQCCfCCC
:CCECpCC&fC=C!HB
B{BBBffB=BkBGBB\BB\B3B)BuBBB)B癚B\BBBB
=B\B{B\B{BBB.C&fCC:C C
\C
fC
CCqCuC
CT{CٚCO\ChC33C33C#{C#CCC8RCC}qC	=CYC\CcC&fCCpCCT{C	C
 C
CC:CCkCCkCxRC3C3CECCCCC +CLCٚBǮBBpB{BB螸BaHBBBRBB랸BffBBߙB BBB#BBBߔ{B\)BBǮBaHBB
BߨBBBzB(B33BBqBBǮB.BLBkB)B#B(B33BǮBܨBkBB)B(BffBB=B{B  BffC33CB3B.C  C	aHC
HC
s3C\CB(B)BB=qB
=C
{B3CCBC
C B\B33BBBffBW
B C	=C.B)BffBB\B=qB  B{BBffBGBaHB B)BqBkBBBBfB
=B)BBffBBB\BB
=BǮBBLCCBqB  BuBpB.BzBffBBBB(B8RB33BHBԸRBB8RBffBBўB֮BffB\)B
=BB)BBBzBB{BpBBBW
B  B8RBB BǮB#B BBaHBQBBBBGBffBB݊=BBۀ BڮB(BGBkBBuBBԏ\BԙBBϙBGBѳ3B
BBBД{B
=BЙBzBuBzB˳3BkBB͊=B
BzB
B̙BB˙Bʀ BBBǨBBBBfBkBRBpBHBøRBB  B(BBpBpBpBţBřBB\BǮBBzBƊ=BaHBffBBLBBǅBȅBBȅBB
=BBȊ=B  BpBBB#B(BBBӀ BW
BϽqBuBffBBBɳ3B(B(B
BBBBBHBǮB\)B
BB\BBfB#B
Bڔ{Bה{BڨB)B  B33BBB#BGB{BνqBB33B\)BѸRBaHBBfB  Bͳ3BGB
BBHBBʀ BB.BBBʨB=qBǮB(BĀ BffBLB¨BfB)BBƨB  BǣBǮBW
BBB#BGB=B8RB
=B  B8RBB\B=qB.B=qBBLBBBHBpB.BBB(BȮB)BBBڞB{BpBBB#B.B
=B\)B֔{B(BuBB
BBBB  BW
B\)BfB)B(BBB  BܸRB\Bъ=BGBҨBѳ3BBaHBaHBϳ3BBB\)BЅBkBW
BW
B̀ B
=B
BBBaHBBuB̊=BBBB)B8RB(BǸRBƣBffBW
BBǅBaHBHBʏ\BHBkBșBǀ BǮB#BǅBB.B\BHBaHBǮBGB=qBBBҸRBffBffB׏\BpB؅BBۀ B#BW
B
BBǮB  B
B\)BkBB  BمBBpB
=B33B
=BfB잸BfBpBBffBuBBffBCC=CCT{C+CC zB=qB33BǮB(BB{B33BꞸBߣB
=BǮB=qBfBGBՀ BBBۨBBҏ\B33BB(BBBGBB33B  B\)Bя\B)BB)B=qBǮBB#B8RBBBBԀ B{BB՞BЏ\B33B)BaHBB3B
=B(BمBB8RBBB{BQBqBBBBB BzBRBqB(BBB
=B\B.BǮBkC33C
hC+C&fCfCC{CYC33C&fCs3CCCpCnC+CC
  C@ CB{BBB
BHBBǮB B)B
BffBBB\B=qBBBBQBGB  B(BHBffBۏ\BGBފ=BGBffB8RBuBQBkB잸BBBǮBRBB(B\B\)B
B\B㞸BBB.BBB=BffBBB\B㙚B
BzBqB螸Bۀ BLBB(C CCC)C޸CCCQCC
CC
C(CCffCCCRC#C&C$C$CfC!CYC$ٚC#BC)C
CqC	}qC
=C(CqCaHC	fBC C.CC {B B
BBB)B.B{B BHB BffB
CT{CC BBkCfCCCuC&fCffC
CCC	nBRBB
BRBQB
BBLB{BfB{BkBB=qBkBǮB=B{B  BBuBfB癚B{BBqBB.B\B(C8RCCC:C
CBBQB=BkB(CcCC
C CC
BCC\C
8RC
CxRCC
C@ CaHCCLCǮCpCCkCC
5CC0C
=C	\)C
3CRC  C	C  C
CLCffCCC޸C\CC@ CffCC:C
BaHCCCC!HBBHB=B33BaHBkBBB33BBBW
BHB{B
=BBHBffBRBBB BBB(B BzCzCkC!HCT{CLCW
C33CCC\CnC{CaHC	 C	\C	C(C
BC
C޸CCCC
xRC5C)C33CRCCC3C@ CCffCCC	BC	C!HC	C	C33CC ǮC RC\CBpBBRBHB3BBpBB\CC B33C 
B=C &fCLC(B#BBCHBC\BRB)BBLBfBzB33BW
B#B8RBHBRBW
BW
BzB
BQBffBW
B\BBaHB  BffC C C^B{BB
=CGCCC{C	fCkC
0C{C
0C{C
C^C
qC3CHCǮCC#CC}qCfC3C)CLCCC5CC
CCC!HC=qCCQC#CC  C#CC@ CٚC
C
BCCC
CfC
C
{CnC
{CuC5CǮCfC.CٚCC	.C#CC
aHC=C)CRCٚC
CCW
CxRCCBCEBǮB#BuB\)B{B
=C 
=CCfCCaHC
CCs3CfC
C{CnC
HCC
kC+C	CYCC
=CkCCC{C\)CYCCffCCC
CٚCC#C
=C+CpCCCECCC\C޸C^CqCCC=B BB\CO\C{C	BCQCLC#B33BLB3BBBzBGBBaHB\B{B#BBBB{B  B B垸BB  B
B3B BaHB)BB{BfBBBqCBBkB BuBBB8RC B\BC+C޸CٚCO\CCǮCRC
LC\CW
C)CCC)C	CCqCC
0CpCC8RCkCC C C:C\C
=C@ C:CCCuCfC{CCC{CC{C@ CC=C
=C^CC
qCqCcC\C CCLCBC8RBQC 
BaHBBW
B)BB{BBBBW
BuBB33BBfCBffBfBBBfB{BBfBfB8RBB BBBBB8RBB  B.B33BffBB
=CLCT{CCBfB.BfBqCHCC	{CC=qBzBCCC}qCC	^C{CT{C
C\C)CCCBCCC\CkC#BǮCO\C(CǮC
CHCRC
Cs3BfBHB
B홚B晚B=BBQB=qBuB=B
=Bߔ{BۨBިBGBB)BuB8RB
=BB(BBHBB)Bۊ=BLBݳ3BBQBՀ B8RBW
B=B{Bɳ3BظRBȨBBÔ{BǮBBBHBɣBɳ3BB؊=BBBB.BBُ\BaHBޞB)BB  B=qBGBBLBHBW
BaHB#B)B8RBB\BBLBBqB=BBBBLBaHB
=BݣB8RB\BkB
BzBB
=B\B.B{BfB֔{B\BaHB؊=B\B33B33B\)BpBܨBBW
B(BʸRBΏ\BuBHBҊ=B#B#B̔{BǮBBϏ\BfBkBfB(B{B\)BɮB(B\BBB.BșBǮBfBƅB  BpBƅBǊ=BBǨBBǮB.BǮB{BBHBĊ=B
=BW
B\)B#BΨBBֽqBaHB܏\BB.BB\BfB{BffB
B\BHBǮC=CBCBBB33B BW
B(BBB{BBB  BBzBLBBB
=B=qB(BB8RBQBBBkB.BB3BBpB(BkBpBǮBBBB\BB\)BBB=qBBҊ=BfBfB(BffB)BBBkBaHBBkBBΣB#B̮B̔{BkBBkBLBЊ=B=qBɔ{B̀ BҮBpB{BۅBBkB
=BzB噚B)B瞸BfBB=BGBB#BBGBǮBB\)B=qBB8RB(B8RB\)BB=qB{B垸B BBBBBqB33BQB
=BuBRB\CLCBCaHBB  BLB  BBuB{BzBBBRBQBǮBBBRB(B33B٨BLBW
B؏\BGBBЏ\B
BpB(B\)BB\)B  Bʀ BpB33B33BkBǮBʽqB
=BHBfBͽqB\BBȊ=BHBBGB(BB
=B̞BʅBW
B  BB33BBя\BHBQBBҳ3B=qBBBǮB33B
=BuBB#B)BkBqBBꞸBB3B\BB8RBB{BB޳3BkB#B=qBkB.BܽqBBފ=BHBGBB܀ BݮB
BBpB=qBaHBݮBHBLB.BzB  B♚B߀ BffB)B(B  BW
B.BffBB
B=B=B{BzBuB\B݀ Bߊ=BQB\BB䞸B=qBHBffBfBuBB.BfB  B=qB=qB)B33BިBBQBpBǮB#BLBB=qBBBffBW
BpBuBӨBиRBЙBzBkBffB؏\BHBaHB=qBبBfBHB
BHB8RB=qB(B{BpB3BRBRB
BkB.B3B\)BzB癚B=BBB߳3B\)BGBffBޅBBBףBffB33BaHBڀ BBBҽqBճ3B׏\B؅BڙBB׏\BBzBkBיBُ\Bڳ3B33BfBaHBBݔ{B\BB{B B.BB
=B#BBBBaHBBBGBB(B=qBBBBݳ3B݅BԳ3BB֊=BՏ\B  BaHB\BԊ=BB(BB)B  BܣBۀ BB8RBffB\BfB\)BݨB#BaHBހ B\)BBBǮBB䙚BB{B3B.BRB33B#BBffBB BB
BBqB(B=qBBBGB)BB
B  BԞB33B33B33BW
B\BB䞸B3B\)BBuB\)BkB
BffBBB\)BBBBߨBB߽qB߀ Bߊ=BLBRB
B3BB
=BǮBBB۽qBBpBBW
BBٸRBHBBBףBffB=qB۳3BLBGBuBHB#B=qBܔ{BpBۏ\BzBڏ\Bٳ3B\)BǮBHBBGB33BBW
BB\BޮBLBBpBԳ3BըBQB{BzBGB)BBؙBGB
B#B{Bۀ BBB܊=BW
B=qBܸRBLB\)BҔ{B(BՏ\BB.BffBBؔ{B=qBBB۳3BǮBzBuBaHB=qB.BkB)B.BޅBBܙBBzBݽqBݸRBzBpBBBqBGBfB\BuBW
B랸BB\)BHB.B8RBpBBǮB.B B
=B#BBQB\BBBݽqBfBzBBB  B
=BzBW
B\BuB33BܮBڳ3BGBݨBBBBGB=BBBBǮB
BBBBBBQB)B)BBՔ{B#BBB\)BBس3BBۨBfB.BBW
BBGB=qBBkBB
=BB
=B33BB{BB(B=qB8RBqBQBHB=qBLB=B=qBB{BB#CCO\C#C \B.BpB(B33B\B=qCJ=BpBpBBB=qBGCC pC EBfBB(BuB B{BBBB=qB
BBqB\)B BBBϞBBBkBzBffB33BQBffBBB{BpBBW
B)BB\BW
C BfB
BBaHBB B=qB  B=BB.BB\BBCCs3CGC	CcBGBuCC5B  BHBffBB  BBݔ{BuBǮBB=qB߳3Bޏ\B8RB\)BBpB)BkBB{B
=BǮBW
BBBBBB\B8RBLBBqBB=qBB)B33B)B#B{BRBQB(B33CBBBBpB8RB鞸B
=B  BBkBBBW
B\BfBBܞBBٞB
BBQB(B=BzBǮBHBuBBBB B\)B=B33BBfB{BpBBkBW
BBQBQBqB3B.B8RBzBBkB
BBBQC #B.BpBffBfB\)BۙBǮBQBBaHB{B
BB{BLB=qBB(C
=C{CC=C#CQC
HC C
\)C@ CnC33CCcCCkC{CCuC CٚCQC)CC(BzBuB
=BBB BB.B噚Bޔ{B8RBHB
BQBǮBBBۀ BۮBB)B
BHB݅B33B(B\)BLBB랸B=qBꞸBBLBRB33B)CqC(C	pCCC J=B\BHB.BB33B{B=qBBB\BB=B B\)BQBBBBB  BfB
=B8RB8RB=qBֽqBBҀ BW
BQBҽqB
=BД{BОBBW
BLB{Bʔ{BBBGBuBffB  BB)B33BfBkB
=BѸRB{B
BѸRBffBBB(BبB
B33BٞBBԣBՏ\BոRBBW
BHBϣBнqBѳ3BBәBǮBBBB\)B.BӨBQBB۽qBBBǮBQBB\B\BaHBBҊ=B)BzB8RBpBي=B)BօBB#B\)B\B
=BԮBԅBԨBpBBQB{BB(B\B.BuB̮B33BBʔ{BB\B̊=BȅBpBBHBGB\B.BǽqBɅBBƊ=BBLBƣBƙBBBBHBǏ\BɨBBkBHB\BfBȏ\B\)BaHBɞBǮBBŔ{B̨B͞B
Bϳ3B.BBBѳ3B
=Bѳ3BpBBzBpBBQB҅BӔ{BǮBkBpB8RBHB{B(BkBGBڙB
BGB
BB؞B(BܸRBkBǮB.BBBkB޸RBBpBpBGB33BBݮB٨B\)B\BQBfB
BW
BǮBθRBΙBB̸RBLBBBzBBʮBW
BBʀ BHB33BBffB8RB)BW
B\B{B.BșBǮBuB̨B
B˙BBBB
=BHBΏ\BW
B{BҸRBB(B(BaHB(BkBBBuBHBpBݙB  B\B
=B\BB
B
=BRBBkBaHBffBB癚BaHBB{B\BGBBBRB BLB)BQB\)C )CT{CB8RBB33BqBW
B.B)BBLBLBqB)B3BBB3BpBGBBBB#BuBaHBܣBأB3BBB8RBBᙚBޏ\B)BۅBBB{B
=B  BBמBfBBfBה{B{B33B33BBڙB8RBaHB\)B#B(B\BB(BQBBRBB=qBB\BǮBLB{BqB3BqBpBHCCffC0CBC
=C޸CqCzCJ=CC޸CCQC}qCfC
CCCCC\CHCC

CCCkC C }qC}qBaHB)BBB\BW
BBBpC BLBRBBqB{BfB BǮBLBW
B(BqBBBaHBfBBBQBffBB\BuBB3B)BBۊ=B#BB  B
BqBBB\BBffBݳ3B\)BBBB B BBB.B  BBBB\)B\)CfC	:CRCC C^ChCCC!HC\C
CC	(C
CqC
C C
}qC
 C
5C&fC	CC
=C
C BBBQB垸B=BB8RB\BBBܳ3BaHBzBkBBzBaHB\BB=B#Bܔ{BW
BHBBGB33Bؔ{BzBBLBףBLBܙBLB  B33B.BمB֊=BB33BfBӔ{BҞBӅB)BLB
B
BB(BBBBѸRBרBӸRB
BBW
BkB{BB=qBB8RBuBBB\BݙB
=BuBuBB
B#B8RBBkB
B
=BBBߨBB BffBB\BB\BBBBB=BpB  B{BpB\)BHBqBB)B  BkBBBqBaHBpBuB  BBGBمBHBfBBՅBBB
BfBffBBBϨBuBBBBǮBъ=BGBЙBBHBBǮBkB)BzB\)BaHBBffBǮBQBBBԀ BBfB(BkBͽqB׊=B33BB=BaHB\B
Bހ B.B{Bۀ BW
BB=qBBHB
=BGBqB(B(B{B.B=qBBHB\CLCRCC  CC )B#C B\BB  B(BqBQBBB B{BBB
B
BQB\B.BRBuBzBffBB\)BW
B)B{B8RBB)B{BGBHB33Bݔ{BaHBܔ{B#B٨BBծB(B
BpBQB33BиRBffBBʳ3BB˸RB)BЙBǮB\BׅBB؊=BzBzBBBffBRB枸BBߏ\BaHB\BHB#B
BۨBB۳3BǮB؀ BٙBBaHB#B8RBHBGBB.B8RBffB BRBQB{BzCcC)CHCC BffBB\)BBBB8RBuB{B33B.B\B
BaHB
=BLBǮBqBB33B3B33B
B\BBB{B
=BQB(B33CzC5BC B\)BBBB.BLBBBߨBօB.BQBfBLB\B֣BuBД{BBBݔ{B׊=BϨBBBGBuB.BRBB  BBB
BHB)BBQB3B3BBfB#B\)BGBQBHB\BRB\B{BBB8RC(CCC5C\)C(CCC\)CC 0CQB33BBBBBB3B{BBBqBBǮBW
BBB\)BpBzB
=BB
=BfBQBuBGBBBqB{B
BqBB=BGBuBqBW
BBaHBHBaHBԞBB\BߣBУB33B  BpB.B=BLBB(B8RBuBqBffBW
B\)BBޔ{BzBᙚB\B垸BRBB䞸B B{BaHBBBǮBBffBGB\BkBBB
=BBpB{BC pC@ CRCkCC T{C 
=B{B\BLB\BBBBB\BBqBB=B虚BzB{BB➸B=BzBB=qBߨBLBffB=qBBzB33Bֳ3B8RBBW
BB
=Bӊ=BuBGBԮB#B8RBԙBBkBBkBQBѨBљBaHB  BQBGBԀ B
B#BW
BҞBє{B{BՔ{B
B#BݽqB\)BBBzBLBHBQBǮBpBޞBLB
=BǮB=qB33B\BBB=qBB)B33BB)BkB  BkB螸BBW
BpB=BBB.BW
B  B  BBBǮB
=BBaHBkBkBBBGB)BQBBBBW
B8RBQBᙚB{B۽qBـ BՀ BBaHBBfB˅B33B  Bͳ3B(BpB{BŅBBƣBʨBƣB#B
BBHBǮBʊ=BpBڮBW
BB(B#BؽqBW
B
=B
BBݞBBB3B=BBqB3B
=B{B(BGB)BBffB33BfBHBaHBBffBW
B.BaHB
=B
=BuBuBǮB➸B  BBBBB8RBBBaHBLBBHB\BB BRBB陚BGBffB{BuBaHB  BB33BܮBQBBۅBBHB۸RB۞B
=BBQBLBǮB(B
BBԨBBӊ=BBօB\)B\)BӅBՔ{BfB\)BpB(BLB΀ BǮBuBܸRBBBffB  BBzB=qBpBQB33BLB B
=BuBGB33B B8RBBB{B\BBQBBǮBLBǮB
=BHBBuBǮB3BQBQCǮCCC
8RCǮCW
CC3C
8RC{BC BffBzBfC RBBzB=B\B B=qBRBRB  BꙚB\)BLB{BuB)B)BzBB\)BuBBBBHBGBBHBۏ\BޮBأBaHBգBB.B
=B
=B
=Bހ BݽqB.BήBB\)BBBzBBBB\BfB)B3BB{B{BLB=qBpBBBBB)B3C J=CCuC	5C
GCC
CHCRCCGCCC)CCqCCJ=CChCC)C#C
=CCJ=CCCٚC0BpB
=B.BQBW
B瞸BHBGBffBBǮB{B٣BBzB33BըBBBBaHB  B
BuBHB BBaHBQBQB\B#BkBLBaHBBpB.Bڳ3BǮBB#B#BBB=qB\)BBۨB33B=B\)BBBޣBfBaHBBBBBB(BBBBBBBHBfC 5CCLCEC	}qCT{CfC	C
RC.C
C
)C
C
CٚC
.CpC)BC\C	C	ǮCCC{C 
B\)BHBzBC YBB
C CC \C )B=BBB\BB#BBBpB  BBBBGBBBBaHBBBRB B߮BBߙBHBǮB33BpBQBLBس3B=qBӸRB#B=qBGBW
B33BzBߔ{BBB B\B8RBpB.CYCC!HC ffBBCxRBRC
C
^CBC+BB=qB  B{B.BGBBB)BqB)BpBRCBB.B(BǮCaHC BBGBQBW
BqBqBffBB=qBqBǮB)B33B=BRB33B3B3BBBBBB3BLB
BBB
=B(BB=qB8RBB BBBHB#BB(BHBǮB=qBٸRBBzB\BuBԔ{BԽqBBB#B\BBBθRBBBB̔{B̮BW
BǮBBB؀ B#B
=BBB8RB޳3BGBߔ{BaHBzBBBߏ\BBޔ{BGBB8RBB.B܀ B.BfBkBaHBLBBBpB\)B\B B)B\BLB  BHBBBBBzB\BuB B)BBBffBQB٣BaHB܏\BBzBЮB{BGB
BBfBBʳ3B
BĽqBfBƔ{BGB  BBB\BffBBB=qBр BBBҽqB8RBW
B֔{B
=BLB=qBBBףBӞB(BBB
BBRB\BBBBLB{BzB.BffB\B
=BGBBaHBGBuBuBfBRBBBC{CCC!HCCpC&fC)C B B.B(BBHBBkBuBBRC xRB#BB3BkBBBuB(BQBBkB.BB3BBBuB#BBBLBBB
=B.BB8RBBLB  Bѳ3BͮB(BaHBԽqB#BzB\)Bڳ3B܅BpBHBzBBB\BBB=qBB\BB
=BffB䞸BBB33B{BB
=B=BLB8RB  BHBC
C C(CqCCHCRCC)CCO\CLC:C
QC@ CQCChCcCs3CHCCYC.CCRCBGBBB3BBB{BuB=qB=B
B\)B=qB3BaHBBHB
=B{BB\BqB=BqB8RBfB٣BffBHB BBBpB\BǮB(B\)BQBBqB=B{BB)B B=BBǮB랸BHB{BaHBBQBB(BqBBRB#BpBqBfCkC=CqCC{C\CT{CCCC	3CpC C
C^CC3C  C CC=qCCGC C YC 5CzC\C)CzC33C=qC
J=C
CCBBQBRB)BBpB3BBޅBkBLB.C33CB\BzB\BfBfBBBBB BBfBǮBGBQBRBC CT{BRC!HCJ=C}qC&fBBRB BB{BBaHBǮB33B.B\B۸RB)BٞBָRBBBHB8RB(BffBBB\)B(BBBW
C )B\BaHBBRB CC BBB{BB)BqBB
=B BuBB
BݨB33B'BBBLBzBffB垸B8RBBzB\)B=qB(BB(BqBBQBBB  BBaHBBB)BaHB B
BC ECRC {C C @ C kBB{BW
BBB8RB{BBzBffBBBQBхBҽqB=qB  Bճ3BffBfB33BӮBB.BBـ BffB.B8RBW
B\B)B B3BfBHBaHB(BpBHBzB3B{BBBGBpB  B#BBGBuBzBB=BBfB.BBǮB鞸BW
B
B#BBBaHBB C0BCBzC )C5C
=CfB3BBqBQBBBBqB.B.BuB\)BpB3BBBB#B잸BB8RBڳ3BffBQBBBpBzBBB{BBBBBBBBaHBB  BpB  BQB♚B)B=qBBݣBݽqB(B=BffB뙚B.B홚B
B{BB#B3BB\)BRBBfB8RB虚BǮBBpBBǮB晚B)B=B
=BBHBffBBBB=BB B{B\)BBHB
B݊=B܅B\BBޙBBBB3B
BB\BBBuBB)BBfB(B B
BBBffB8RBW
BBB\BBBB(BRBffBBBpBǮBBBkB8RBBfB
=B8RBqBB  BW
B=qBfBBBB  BBkBBBԳ3BӣBBיBkBB؀ BڅBڨBB{B虚BB=BLBqBB#BB8RBLBB{BzB B.B.B\BBkB\B=BB33BzC \C.C cCCC=C 5C B\BBzBBB
BfBB=B8RBBBB=qBuBؙBٔ{B33B֊=B.BHBBڳ3BGBffB{BfBה{BBڏ\BBBGB BRB\)B.BuB=qBBB{BHB\BB=qBzB  BGB
=BǮBzBB.BǮC 3B(BBB#BBGBkBB3BBB=qBGBpBB
BaHBkB{BϞBuB8RBHBB#BuBkB
=B)B
BBqBfBHBW
BzBnBh{BcBa{B\
BYGBW  BU\BQHBOBO{BKffBI\)BHpBDBBB@B=B=QB;B:33B9B9B9ffB8B8B7B8
=B5B4B5  B4RB5QB4HB5B6QB7GB7B8GB8GB:pB:B<pB=B=  B:\B<=qB;(B:B9{B7B9(B;(B;B:pB<B>  B>(B@pB>RB>B;
B6(B0B.B(B%  B#33B B\B{B
=BBBBGB=qBHBHBBGBB
{B\BBGB pARA=qA
=AzAAGAAՅAAGAA\AffAAA\AA
A{
=A`AFffA(AR@p@H@{?Q>?#
?!G?W
=?G?8Q?+??W
=?xQ?L?#
>ff@U@`@_\)@S33@JH@5@1G@!G@
?У?
=?\@33?z?(?{??\)?{?
?ff??xQ?Tz?c
?W
=?Y?\(?B\?Q?8Q?5?(?.{?&ff?(>H?   >ff>>\>Q>{>Q>33>>z>u>u>>k>u>aG>B\>k>aG>8Q>8Q>L>u>aG>k>B\>B\>L>aG>aG>k>8Q>L>=>L>aG>L>L>L>>\)>\)>z>>=q>>>33>{>
>33>{>R>Q>p>G>(>(>
=>(>
=>(>(>>>>Ǯ>>>Ǯ>\>Ǯ>p>{>>R>>  >k>  >u>L>W
=>L>B\>B\>.{>8Q>.{>\)>.{>>\)>=G=>>>=Q>>>B\>>>B\>  >>  >>R>{>
>
>
>
>
>\>>(>
=>
=>>>Ǯ>>Ǯ>>>>33>>33>z>z>>=q>k>W
=>B\>8Q>B\>B\>#
>\)>>=G>\)>>==>\)==
=
=>=G=
=L=Q===u<=
==Q<<#
=#
=Q===Q=
=u=#
<#
<
<=u=>=L=\)>>>k>=q>QBBaHB)BuB)B8RBB
B8RBBBBHB\BuB.BkC EC :C C+CzCCBC
=CC\CC\CǮCCC3CBCaHC BBQBC .BBaHBB8RBRBzBBkB뙚BGBW
BBHBzBaHBB
BBBB.BzBzB=qB8RBBpB
=BRBBB瞸BpBꙚB{BuBǮBBffBGB#BkBBBBBB.BLBԨB٣BuB33BuBLBBBHBfB8RBBpB)BBBBB33BB=qBRBC BCCCzCCqCqCC CRCCuCCC5CcC!HC CqC޸CzCB=BuB\BBB=B8RBBB#BzB\BB{B.BLBRB BaHBaHBBBǮBBBB#BǮB\BBGB
=BԳ3B.B՞BօB33BٞBaHB=qBފ=BǮB  BzBuB޳3BޮBkB
B=qBQBB\BW
BǮBpBaHB B BLB\B33BuB(BBfBBBzB B8RBRBqB잸BBpB33BB3B
=BQB)C W
C.CC
=CCCaHB=BqBRBBBB8RBBB)BBzB8RBޅBBܣBBBBW
B)BfBBBuB3BRB
B=qBBfBBQBqB B BGB
=B䞸BBBޞB
=B8RBzBB߽qB\B)BB.Bޔ{B#BffBB\)BB(BLB(BRBB3B)BB{B
B8RBaHB\B=qBBBBBkB{B.BkBpB
=BaHBǮB3BuBC GCJ=C(C
=CCO\C&fCCC
CCRCffC&fCC BB)BkBkB)BkBffBBuB)BkB)B=qBBQBkB#B  BBǮBB.BGB#BHB(BBـ BីB\B=qB(BaHBBB\BQB{B.B8RBޞB۔{BݨB
BffBQBaHB=qBffB
=B8RBخB8RB.BBBB#B#B֔{BaHB܏\BGBkB{BBRBBܨB{BRBǮB홚BB3BB33B33B\BC .CW
C  C&fC!HCC)C8RCCffCCǮCLCT{CC{CaHC޸CfC\C33CfCC BkB3BBBB  B.B\)B33BBffBBffBBB33BuB➸BB
=BuBBpBffBBB
B{B(BBpBQBW
B33BBBր BHB.BըB\)BkBHB(BuBBרBB\)BBzBҏ\BգBظRBB33B33BBBB33BkBBffBB8RBB BBzB\BffBGBQB
B3BQBQB3BGBBB=qC33CzCpC5C޸C BzB=qBBBuB=qBaHBffBBkBB#BBB\BQB=BRBBfBB=BaHBBB.B#BLB)B.B
=BBB޽qB\BQBW
BǮB)B)BԳ3BսqBըB)BǮBaHB
BՀ BBB
=B8RBǮBfBיBBڸRB\)BGB잸BBꙚBzBBuBBB33BBuBqBB3BkBBkB.BW
BǮB{BB#B=qBBBRB3BqB(B.B=qBaHB  C0B  C ffBC 
B.BuC C{C
BpBBaHBfBB{B#BBBBB)BW
B)B
B랸BB=qBBaHBBffBfBuB)B BaHB(B#BpBB.BfBBBQBqB
=B\BHBٸRBGBkBuBfB)B
=Bӊ=BծBB\)B=qB\BǮBҸRBӣB{BBffBǮB#B3BBB  B33B
B{BBB
BBuBGBBGBqB\)B\B8RBB
B(BW
BBB
BBuBuB(BBQBffBqB  BBBBBW
BffBfBRBBHBLBqBB{BaHBzB{BBBB\B#BB{B
=B枸BB{B(BBpB\BLBLBBfBBW
BBިB8RBBB  BffBW
BGBkBfB\B֞BffBBBBսqBBBǮBffBڣBQBzBB.BǮBuBB#BBݳ3BzBpBBffB\B=qB{BffB  B=B
=B
B)B\BHBBBBǮBRB\)B)BBuB33BLB\)BW
BB.BLBBLBGBfB=B{BBzB\)BB.B؊=B#BBBfB33BҨBB.BLBLB.B  BΊ=B͸RBΊ=BHBBB
B  B\BB̅B͙BǮBB\B{B͞BͨB33BϙBBϳ3B=qBЮB  B.BBffBBBB\BӽqB  BBǮBffBBW
BBHBЮBBҞB)BkB=qBـ BkB\)BLBBBB\B8RBkB  BBBBB)BBffBW
BBBBBߊ=B\B  BuBޙBffB)B\)BBBBW
B\)B33BBأBfB؞BfB
=B֔{BBBBuB֙B#BLBBԙBԀ B(BBǮBBBԨBuBpBzBӊ=B\BB
=BaHBӏ\B{BӨBB\BLB)B{B(B׏\BHBBGBffB{BBBߊ=B)BW
BB8RBBffBBBLBW
B=qBBBB\)BBaHB\B  BBBBB  C=qCqCqC
CHC@ C0CCnB8RCBLC {C ٚBLB{B33BaHBzB#B=qBBBܨBGB
B33B33B33BHB8RBB#B3B(BB\Bފ=BߣBqBBBߞBB=qBBӽqBW
BӽqBBBΏ\BfBaHBzBԸRBѸRBBأBffBLBսqB{B=qBݙBLBBBB=qBpB=qB BqBB\)BGBBffBQBBBBQB#B\)B
=CC5CuCB8RBB BW
BBB
B C\BfC B8RBBzBqB.BqBBpBBQB B\BqBaHBffBB=BB#BpB\BRB8RBffBB=BBB8RBBBB33BW
B8RBߙBHB܅B#BkBB8RBuBBBBpBBBB{B\)BB䙚BffBqBǮBB B.B{B\B#BW
B\B33BqB{BB#B\)BBW
BffBQB3BuB BBHB.BuBBBW
BGBuBB(BBB{BBB  BGBLBqB=BBBB33BffB8RB#BBB.B  BBBڅB
BzBaHB{B
BܸRBBڅB#BHBBՙB\)BѸRBGB
=BBǮBBυB.BԅB33BמBfBpBB{B{BzB(B\B#Bُ\BٙBBLBQBB.BBBBߨBBqB
=B➸BB8RB)BkBݨB  BLBٸRBبB33BǮBB.B#B)BBzB܀ BBޣBBB{BGBB.B\BfBGBBBzBីBBǮB߽qBߣBBB
Bߏ\BBGBߨBfBuBQBݳ3BuBBaHB܏\Bܳ3B=qBBB#BמBB
B8RBBkBڏ\BpBBW
BۣB\B׮BHBB(B#BuBԳ3B{B
B8RBBBЮB=qBkB33BBиRBGBB(B(BQBԣB֏\B\)B  BffBۊ=BB#B.BBB33BؙBHBBBBըB\)B8RBB\B׮B#BB
BpB8RBǮBۊ=B\B=qBW
BkB=qBW
B#B
B=qBݮBBGBBڣBLBB݅BݮBfB
B8RB.BخBQBBBԏ\BԊ=BՅBӽqBӨBBB)BӀ BBBД{BBЊ=B(BW
B
=BШB8RBǮBBB{BGBѮBLBр B8RB
=BΔ{BͅB\BuB
=B{BBaHBLBfB{BffBW
BʸRB
B8RBѸRBͳ3BQB33BҔ{BBBҳ3BըBBBB=qB  B  B33BkB֞B
=BfBW
B׽qBڊ=Bُ\BB\B  B\Bڔ{BBBHB33BڅBBBۀ BaHBW
BLBݸRBݏ\B=qBQBڞBBB\BۮBBHB(BGBW
BB܀ B
=BٮB33B
=Bس3BQB=qBB\)BB=qBpBBԀ BBQBӣBkBBfBBffBffBLBB\)BսqB8RBԽqBBBӳ3B.B  BBǮBΏ\B)BBuB{B
BΔ{BGBfBBѳ3BffBB\Bѳ3BQBBBB{BӮB.B\B{BBuBBBLBӔ{BBzBB8RBՔ{BB֣BBpBظRBW
B׽qB\B8RBQB#BמB׏\B׀ B(BB33BҸRBBπ BfBW
BBBzB\BBfBνqB33BBW
B  B\B33B33BB
B˳3BBuB̮BQB8RB(B\BzB\BaHBW
BzB
=BBLBɀ B
BBLBBBBBˀ BW
BuBBBBffB  BLB#B̽qBɳ3BBBˣBpBʔ{BB(BBffBBBυBОBpBBҳ3BӞBBGBaHB.BQB=qBـ BQBڏ\B\)Bڳ3B{BW
BBW
B.BBGBڸRBיBfBB\B)BB҅Bя\BѽqBBBLBͣBϞBHB͙B͏\B(B͊=B̽qB{BͨB  B
=BBЀ B.B33B(BӅB{B8RBfBḄB(BϙBB\)BBBBŞBBBǣBȳ3B8RBǸRB\B\BBBBɸRB˙B̏\BBB  BȔ{B#BɅB̸RB\)BBBЀ BиRBҔ{BpBLB(B.BB֔{BׅBzBB)BzB)BpB\BB B#B(BkB=qB\)BǮBB➸B  BHB=qBBBǮBBB  BۙBzBfBBB׮B=qBBոRBBB33BυBpBҮBB  BBuBBͣBϽqBHB)BυBGBB=qBӔ{B\)BkBfBaHB33BfBǮBHB\)B\Bѳ3BfBҨBuB{BB{BОBBfB\B֔{BzBBB33Bѳ3Bҏ\B
B8RB\)B\BBW
B)B
BڅBBkBۊ=BzBuBޮBޞB=qBBីBBBǮBfBBBB BB8RB(B
=BBBGBBBB BBRB{BBBuBLBǮBB B
=B枸BRBGBB(B=BRBBBBLBBBzB\)BBB3BBkBីBHBLB{BBߊ=B#BBQBHBBzB=qBܙBڣB
Bޔ{B33BBQB֔{BB.BڅBޔ{BzBBǮBBuB޽qBBޙB33BffBffB.BǮB  B#BBǮB枸BB=B BBQB33BuBBBǮBB33BffBBHB)C BB{CW
C 5Cs3B=qBaHBB{BǮB  B.BB\B=B\B\BHBkBzBGBBB#B䙚BQB3BQBBݏ\BBW
BaHBHBBBuB׏\BڽqB#BBܨBGBffBBpBLBݮB\)B\)BaHBffBkBBHB33BkBuB\Bݔ{BaHB)BpB
=BBBۣB
B#BBRBB33B)BB=qBQBBRBB  BGB
BHBBC ^BBfBB
BB{B#BHBffBRCqB)BB33BB=BBBB  BRBRBB枸B33BB BB.BB(BffBB8RB.B۸RB.BW
B߮BGBfBffBkBԅBBLBBƅBBB#BB̀ B
=B=qB#B
B8RBB\)BfBaHBǮBaHBѮBBkBuBBLBѽqBBB)BB
BBBffB)BHBfBzBBB(BBW
BffBBBB{BBW
BB BB
B=qBB{B{BuBBkB33BfBLB3BW
B=BQBqB߅B=qBQB(BkB33B֞B֙B{BB
=BHBB)BffBЀ BQBB͞BBǮBBkBBϸRBٮB\)Bڏ\Bڊ=BB#BBۨBۮBBBЊ=B)BB\)B\)B
BÙBuBHBHB8RB)B#BQBÏ\BzBǽqB(BŮBpB\)BBB\)BpBB33B)BBBB=qBB܅B
BB33BBBffBW
B(BBLBHBzBW
BBBB)B=BBBꙚBRBBBB{BRBB(BffBQB)B晚BB33BBB\)BuBՏ\BW
B8RBBGB=qBB܏\BfB\)BkBBfB=qBBGBBޏ\BzBzBzBB{BԨBֳ3BBkBӮBLBǮBHB33BҔ{B\)BBzBB\BBkBB\Bڳ3BBߙBBB)BB\)B\)BfBaHBaHBGBaHC 3C)C{CC
{CqCuC C0ChC=CuCLC)CEC0CC
=CǮCC
s3CGCCCfC	uC
=C
C(CCRC
3C
C	CW
CYC=C!HC.CRC:CfBfC)CHC
CC
C=CqCC
ffBB㙚B߸RCzC33BW
B=qB8RBB.BHB)BB{BۅBfB҅B
B3BffBGBuB8RB33BQBRBffBkBBC ^C
CǮC^C0B8RC8RC
ffCnCC3CBCCLC{CT{C	hC	)C3CCqC#C=qCC
CCCCC C:CC)CYCnCBC )C ^CuCCCٚCCW
CC}qBC	
=CGC
CC
C
=C\CC!HC3CHC ffC C33B\)B)BB)B.B.B8RBBB\BaHBLB.B3BC zB8RBpBB)BW
BBBBGBBB=qBB BBB
B\)B{B枸BB33BRBQBLB{BQB33BLC C3CxRCuB{B33B(BCC  BQBBB
=BBfChC
C^CC33CǮC#C&fCkC\)CC=qCC8RBfBLB)B
BfB=C C 0C C3C{C3CC BRB33B33BBB.BB\)B(BGBBzB
=BBzBkBB\)BBaHB#BBB\B8RBBB(B\B=qBBQB{BB.Bؔ{BffB.B\)B  B#BB{BfBǮBBԀ B\B
=B=qBԳ3BBڽqBB=qB.BaHBힸB=B=qBBzBW
BzBB
BqBBffC \C RCٚC\CCCBBB(B BHBB{BBW
BBRBHBB8RB{B33BB\BqBffBߣB݅BޣBمBB(BǮB(BB=qBpB#B
=B؅BBBBW
BB{B\)BB{B
=BB{BBkBfB͸RB{BϨBffBٞBLBǮB=qBؙBuBaHBݞB=qBۮBܣBBBW
B{BW
BB㙚BqBB8RB\B.B晚B B)BffBBqB33BBB33B  B33BBB#BC =C 8RCCaHCCC{BuBHCcBqBB8RB  B8RBǮBqB  BBaHB=BHBǮBW
B
=B{BaHBzBffB=BB.BBB\BBBB\)BB33BBBGB#BᙚB=qBBfBъ=Bє{BW
Bє{BυBB\B̔{BB͙B\B\BaHBB
BظRBBBBQBHBܨB8RBpB޽qBݳ3BB޽qBB{BuBGBB
BqBǮBBGBBB B㙚BBBᙚBBBRBB3BGB.B{B\)B{B(BfBB(BQBLBaHBBBB3BBߊ=B(B  BޅBBBGBaHB.BBBfBzBܸRB#BfBB)BpB
=BǮBרB׀ B{BQB
BBBLB\)BBٞBBǮBBըB8RBBӀ BGBHB(BuBpBfBܮBԨBB؞BuBٞB)B{BaHB=qBBBpBՔ{BB=qB٣B33BBףBQBW
BuBBُ\BGBBLB8RB)B\B=qBBaHBBBzB)BRBffBBBpB=qBaHBHB.BB  B\B䞸B=qBBBQBBۣB(BaHB33B{B.B=qBǮBffB33BBaHBǮB(BGB#BծBLBaHBBҏ\BaHB)BB(BиRBkBW
B\BB
BͣBЊ=BQBBҀ BBpBfBBfBB{BzBW
B(B{BpBGB33BBB\)BBBBBBzBBB)BBuBBW
B.BqB{B3B\)B
=BHBCJ=C\C ffBB8RBHBuBqBHBB=B(BqB{BGBBBBBBBRBBBQBB
=BffBخB
BB  Bހ BzBaHB
=BGB#BBHBB\BB=qBBٳ3BמBB#BGBր BӀ BfBGB=qBBLBQBB\B{BB
=BЀ BҽqBBǮB.BרBؽqB
BB.BBЮB߽qBBBBGB
BB  B\BBBB=B=qBB8RB\)B.B{B8RBB
=B8RBBBQB(BW
BHBB=qC C 8RBW
B
=B{BBkB{B{B=qBLBB)BۙBBW
BpB)B؅B)BW
BHBҏ\B
BЀ Bπ B
BBϞB#B#BpBzBfBpBffB\BuBBBӅB)BнqBBBGBQB.BҙB׏\BظRBBLBBfBօBGB8RBBBBB{BٸRBBGB܅B.BBB{B
=B  BB\)BBBBqBB\B{BQB\BqB{B)B
B\)BؙB#B׽qBݞB#BߙB{BBBBBpBBfBBQBي=B׊=BQBǮB(BڣB
=BܮBBzB۞B=qBffBBfB#BBӸRB
=BfB8RBѣBBBљBљB\)BǮBЅBffBB.B=qBʨB.BBˏ\BHB
BŅB(BBzBʽqBBBBBΏ\BBHB  B\B8RB{BkB=qBkB֏\B  BǮB٣B8RBޮBBޅBB33BBB=qBʣBB=qB=qBpBўBУBGB
=B{BǮBB{BzB
=B BuBׅB߽qBBGBkB3B3BǮBaHBaHBffBW
BLBBؽqB
=BLB֞BkB
=BffBǮBBBuBW
B#BuBGBϮBfBѸRBр BҞBӀ BШB(B{B
BkBǮBͮBkB33BuBHB̀ B8RBˀ BLBˏ\BW
B8RBͽqB33BΔ{BBўB
=BpB\)BkBB׏\B֏\BLB)BW
B݊=BBkBBB.BBkBpBW
B(B➸BkBǮBB\)B.BBffB
BzB(BBW
BBBGB B  BBpBB33BpBBfBzB  BHBzB=qBBQB\BB\BaHBQB=B3B\BqBǮBߣB߳3BHB=qB➸BB{B
BޣBpBBߏ\BޞBBW
B\)Bߏ\BޮBB
=Bה{B  B
B=qBBǮBBϮBB=qBB{BBBνqBϏ\BBffBͽqBB͞BǮBڨBGBڞB
BqB8RBBB8RBzBB8RB
=C kC=qCEC\CaHC.C^C	uCHC
C	s3C
C	CC	C	
C	hC\CQCkCRBC=CcBB=BqB
B\B33BLBB8RB{BB{BBBB.BuBRB33B=qBBBB
=BB\BaHB#B\B\)BkBB\B#BBaHBBRB.B(BLB)BݞB{B
B=BǮB)Bڏ\BpBB#BڣBأBBօBB̸RBGB8RBQBޏ\BBB3B=qB33BRBuBB➸BRB\BLBBzBHBǮBBQBB3B  BBBBBBBBB3B܀ BB
Bހ B
=BGB{BѣBBGB
Bӏ\BQBzBuB\)B
=B33BBB)BʸRB˳3BkB33B(B\B˞BzBBǮBpBɏ\BBˏ\B̞B(B33B
B8RB=qB)BfBBBBBBkB{BQBBW
BBBя\BӮBpBpBQBǮB
B(Bה{B=qBBkBRBHB  BzBpB{BGB鞸B\)B(B{B8RBB#BBB8RBB3BffBBGBBRBBǮBBBB{BBBzBB8RBBuBǮBBkBBW
BQBBBLB)BGB)BfB)BԅB33Bє{BϸRBHBѸRBW
BzBuB(BBӣB֏\BpBـ BBڸRBGBڽqBۨB\BԞBB#B.BGBҮB
BzB#BaHBGBaHBQB̞BνqBGB׸RBBՏ\BzB8RBGB.BaHBBBB)B=qBBBBBBLBBB\BBBW
B{BffCW
C)C=qCCpC+C^CCs3C@ CffCBC
C\CfCCkC^C8RBzC}qBRB
BBaHBHB\B  BBffB=BLB BBB♚BߣB߀ B#BzBLB{B(BٮBݣB\B
BB(BBܨB#BޙBBffBޮBW
B)BݙB#B\)BW
BبBה{BBffB#BܞBBBuBHB8RBuB{BBffB3BBB{B.B33BB B  BkBBGBB=qBuBB
=BffB  B=qBBBuB)BBLB\B\BRBGBBqB\B  BBaHBB33B=BzBBqBLB\)BBQBBRBpBHBB
B3Bހ BB
=B{BqB#BffBkBܮBߙBW
BuBGBaHBBuBW
BBBB)BBڊ=BB݅BkBB(BHBǮB\BBB=qB)BB3BqBB{BBkBBpBBBBBB(BBB8RBpBBBGBfBǮCCzCCs3CqCLC :BBBffB{BBHBCs3C+CBBuBBBaHBkBBaHBB BB{BB\B\)B虚B
=BBzBBBB{B8RBB۽qBڣBڸRBuBuBzB׮B8RBBB.BB  Bޔ{BBފ=Bܔ{B
BpBQB(BkB8RBuBܨBأB)B(BB
=B.BRBpB8RB3B
B{B
B(B\BBuB BkBBBRB=C=qBuC
C33CCW
C)CCCCRCC(C CqCC{BCpBfC GBB
=BW
BBBffBHB BBW
B(BBBB\BqBqB\B螸BBW
B
=BW
B33BpBkB)BpB=qBzB
=B
BB(B8RBBfB33BBQBBfBLB=qBBBӔ{B.BW
BܙB\BB\)B.B BBǮBGB.B
=B=qB.BRB=qB33BGBBRBfBBfBB\)BB.BBǮBBaHB BaHBQB\B8RBqBB
=C .CkC{C@ C ٚC B\)B\BGBGBBBǮB\B\BLB晚B  BQBkBB֞BB3BBkBffBBB\)B\)BB\B\B8RBffBzB{BQB
BBBBkC(BGBGB\)BaHBRBaHBaHBuBB鞸B#BffBRB=BffBB(B\BBLBBGB33BLBaHBaHBLBGBBRB#BBBB33BBBB=B{B{BffBfB  BBB=BB
B{BBBBuBuB BBBBBǮBB\)B#BB33BBǮBuBBkBٮB=qBՙB33BBBB  B\BGB  B֔{B֞BHB8RBӨBր B=qBBB֞B#B\)BGBٙBڨBpBB
=B֞B{B\)B
Bֳ3BڨBuBB.BBBؙB33B֙BBkBׅBuBLBB=B#BHB#BޅBpBBRBkB{B.BB{BQB33B{BkB B{BB  BkB\B=B\)B=qB8RBBzBzB3BRBuBǮBfB=qBBaHBBpBB)BLBfBB#B BBB  B#B#BBuBW
Bۏ\B33BkB33BQBuB
=BpBBӞBB#BGBԔ{Bҏ\BӞBGBBBpBaHBuB֔{BpB)BB#B)B\BkBuBۣB(B\BLBǮBpB㞸BB33B
B)BpBQB۔{B
=BuBݙBB\B虚B#BBzBBB(B33BLBB{B#BBBBHBkBBGBB{B.BB=B{BB
=BBB#BBkBBuBBB
B(BHBqBzBpBBW
B.BBBHBǮBBLBB)BBffB)BBqBW
BpBpBRB\BffBpB=qB.B(BfB뙚BHB=qB{BB BB\BBB8RB癚BBB(BB8RBaHBڔ{B
=BB
=BaHBۣBڣBBzB33BB
B.BB{B)BLB잸B홚BkBLB8RBB=qBB=B#B33BBuB(B{B B(B B\BzBkBǮB瞸BB؞BGBB  BBuBBB#B߮B BqBQBpB#B۳3B܏\B(B
BB(B)BQBBGBaHBaHBB
=BaHBBמBBǮBHBW
B
=BLB(BW
Bٳ3BkBGB\BֽqB#B33BϽqBB؞BBǮBfBGBڣB؀ BBW
BܞBuB=qB\B33B\)B۳3B=qBݮBaHBޙBBݽqBBހ B޳3B)B=BB晚BBBBQB{BBW
BB=BB=qBuBHBBB  BGBꞸBB33BB
BBQBfBuBBBB؅BؽqB
BٮBkBָRB۸RBBǮB
=BBBBHB\)BިBB)BBB֙BB)BffB.B
BęB(B\)BȊ=BɅB{BB\BףBLBᙚBB{BHBGB
=BBǮBؽqBaHBLB.B#B\)B۽qB߀ B.BBB  B)BBBBB)B➸BBBBBffBB߮BBB)B\BBzBfBHBkBW
BBBBBꞸBGBffB
B
B{BpB\)B
=B\)BBqBfBB\B
B3B=BBB=BW
BǮBfB
B BBB.BaHBHB33BuBBpBB(B۸RB8RBBBW
B(BBQB.BB֙BգBBϙB=qBpBֽqBٳ3BkB#BBHB۸RBpB33BB
=BfB#B=qBuB\)BffBuB
=B)B\BǮB=BBBzBW
BffBǮBffBfB(BBkBRBW
BBB\B(BuBW
BBBB3B#BB\B=BzBqBBGB.BRB8RB\BffB晚BBBGB(BffB#BBBqB(BfBzB  BBB#B#BpBuBHBuB)BB܀ BHBB  BaHB(BffBBBBݣBBkB\BԀ BW
BkBB.BBBBpBBBB\)B߅B.BBߙB=B
BBW
BqBfBHBpBBBBRBBBBBBB\)B8RB{BBW
BpBBQB잸BB
B{B=qB=qB#B
=BBB\)BpB  BffBB8RBBpBBW
BaHCBfBpBRB\B
BB)B  BfBaHBي=B{BB{BǮB\B=qBB8RB垸B8RB.B݀ B
B(BQB8RB׮BBBᙚBLBB㞸BB.BHBaHBzCB BRBBGB{BfBffB.B\BLBQBuBǮB  B8RB\BBB{BW
BGB{BB3BkBHBqBBRBfB8RBRBB)BRBBB  BRB\BHBǮB=BfBBBBqBzBBBǮBffB=qB)B(BBBBHB8RBpBW
BB=B=qB)BBBGBីBpB BqB
B#BBB(BBBB8RB\BqB B=BBBRBBB\Bۊ=B➸B{BBBBBߔ{B=qB
BHBffB㞸Bߊ=B#BLBǮBB
=BzBB#BB8RBB=BkB(BBQB  BBkB33B{BpBBW
B\BLBuB{BaHB(B(BaHBBB)BaHBB
BBBǮBHB#BBkB{BLBB=B
=B잸B B\)BQB
BB3BB33BaHB\B
=B(BHB)B BW
B\)BB{B\)B#BzBǮBQBpBBGBB=qB=B)B\B\)B=qBaHBǮB=BǮBHBꙚBHBW
BB.B.BLC 3BW
BBBB=qBaHBRBaHB.BB.B=BzBBQB=BBB=BBBB.BǮBBB\)BpBC =BfBRBB33B
B33B=BB\BBǮC)BBB{B=qBHBuBqB#BBRB\)B#BמBW
BBB.BHBڅBuBuB.BHBB\B(B)B{BW
B(BCEB\BC\C(CCHCJ=CqCCqCCCzC=qBLBǮBzBힸB)B33B)BaHB  BǮB  B)B=qBLBW
BBBBB B{BLBQBB)B8RBB
BzB B(BCC޸BBC&fBLB)BHBB
=BffBfB{BBBBBpBuC 
=CBQBzCC3C+CC C{C	B.BBBBQBBǮB\BpC
aHCzCkCJ=C!HCnBBB  B3B{B.B{B\B#BaHBQBBBBB)B8RBBBBQBaHBBQB B
BkB\)B\B3BBBBBGBBQCBLBBGBBB.BBBpB
=BB BB  B
=BRBpB\)B=qB\)BpBBqC\B{B.B=BBaHC CO\BǮBǮBW
BǮC s3B=qB3B
=B3B\BB)BB(B
=B)Bր BBB\)BߣB؊=BzBBpBB.B=qBaHBܽqB߸RBzB8RBBkBQB㙚B{BB\B=B)BkBB.B#B8RBB)BB)BBBBuBB\)BCB\)BGB{B\)BBHBBqB
B3BLBB#B=BBBB\BB
B8RBB
=BHBBBfBaHBBBzBLB  BW
BBBkB\BQB=BBBBBBuBkB BBBaHBRB8RBfBQBzBBB㞸BB{B܀ BB{BظRB۸RBB{BՔ{B  BB܀ BHBڨB8RB\BǮBffB
=BuB)B.B8RBҳ3BB\)BBޙBB33BBW
B)BffBڅBBڔ{Bڏ\BQBB  B\BQBBB
B33BޞBpB{BuBfB=qBpB=qBۏ\BkBzB33B(BBfBـ BQB
=BǮBڏ\B
B8RBzB\Bͳ3BBսqB33BQB\)Bֳ3BBBBBBQB)BͽqBzB͏\BBB\)B8RB33BBBuBRBBB\B
=B̽qBQB΅B#BBLB
=BpBBBBǽqBó3BĀ B{B)BBB®B\BB\BB
B\BGB؏\BQBي=B)BBzBBB\)B33BB8RBB\)BBQBׅBǮB  BkB۔{B߮B
=BQBޅBQBB܏\Bڏ\B۸RBBBBֽqBBW
BQBُ\B٨B
=BB\)BׅBB
=B8RBҀ BkBkBB
=BB֨BBոRBB=qB
B#BBB=qBW
BBuBB(BHBBʙBԮBB8RB#BߣBԣBBfBBB.B33BHBʙBffBBzBQBBBBzBˏ\BĨBHB
=B33BBBfBzBָRB{BB
B.BGB#B=qBBBLBHB
=BaHB#BߣBB{BBڏ\BaHBffBpBW
BB
=BQB  BuB8RB BffB8RBpB=qBfB=B8RBpB#BBuBBBBzB(B)BBӅBuBuB(BЏ\B\BBBBB{B͔{BfBӣBѨBՔ{BBՙB  BBffBBB˨BBaHBfBkBҀ B҅B#B)BʽqBɮBW
B̮BǮBffBzBԣBBGBHBҽqBHBӅBԨB\)BB(BpBڽqBBGBBBB#BBuB
=B(BqBHBBGBLBBB{BBW
BBB{B)BBfBzB33BB)BBǮBҨB.BuBW
BBGBuBB8RB
=BuB8RB
BBffB  BBBԮB
B(B  BѣBBzBB  BОBBBЙB(B#BLBϸRBzBBB  B
BգB֮B֏\BzBՅBHBffB.B)B
BBޅBݮBW
B{B\B{B8RBBW
BW
BBBRB=B3BQB  B
B
=BBBpB BǮBHBBB.B=BRBB왚B33B BQBBpBBBBBfBHBLB  BBRB  B(B(B{BffB=B\)BGBB)BBBB=qB
=B\BaHBfBpB݀ B\)B BQBBGBBB{Bޔ{B\)B(BB  BBB  BGBuBzB33BGBpBBިBB#B B(BaHBaHBqBB  BffB(BBB(BBBGBǮB=B#BkB\BBB)BB33C
CC3CCC\C
C
\C
HB{B3BBB#C BB8RBBB\B.BBBBBB3BqBBqBuB#B BB=B  BfBB BBRBBB  BGBB{BB\BBqB{BqBBBB)BBB8RBߨBfBBB#B
BѮBBB
B\)B3B#B晚BB\BfBB枸B
=BBB8RB=B BHB=qBW
B)B
=BBBRB
=BBBB#B8RB\)BBC .Cs3CGC +BBBǮC GCHCC&fC޸CfBHBGB
B\)BBB{BBBpBB=BHBBBB.BBzB(BpB߸RBߔ{BBQBHBBpBBBBuBQBǮBBW
B.BԨBBB{BBRBRBLBBRB׸RBؔ{BpBffBܙBW
B(Bڀ B\)BѮBٳ3BkB)BBuBBBqB)BqBB瞸BB
BBB{BLB#BQBRB=C \C0CqB\BBuBǮBqB陚B CxRBqB
BW
BQBӏ\BHBuB(B8RBͅB=qB{BQBzBkBHBW
BGB=qBGBW
BBQB=qBɣBBHB
B
=B{BLBLBąBQBŊ=BpB33BBڮB\B3BBRBBB{BƨBƨBţBŀ B=qBBBffBQBzBÏ\BfB.B{BBaHBÀ BBǣBƊ=B)B\BB\BBŔ{BˣBGBҔ{BBHBB䙚BLB33BBBB.BBpBB.BBB{BB\B33BQBW
B\B
BBGBRB{B\BǮB.Bۏ\BffBaHBzBB۔{B{B\BB\BpBW
BaHBB{BBffBfB޽qBߣBpBW
BBkBBBfBpBLB=qBQBBBfB\BHB.BuBW
BffB33BBŨBW
BBGBB8RBHB(B{BB.BB)B8RBΊ=B{B\BGBkBffBaHBB33BW
B  BҽqBԊ=B#B
BB֞BBB\)B  BaHB)BӣBՊ=BkB  BBBzBօB֏\B\)BԞBHB
BffBBԞBpBB8RB\)B.B33B噚B)BǮBәB.B.BaHBңB{B{BBBBB.BBBGB
B
Bܳ3BzBߙBpB\BuBǮB߀ BBޞBaHBBzBfB=qBBُ\BBبBffB
=B)BBBǅBBB=qBظRBճ3BָRB=qBffBGB8RB{BuB8RB\BHBBzBϮB
=B(BuBkBkBس3BW
Bٳ3BڣBڸRBǮBۀ B(BBfB)BHBpB{BW
BBݔ{B.Bۊ=Bڔ{B  B{B#BLBBݸRBkBB܏\BW
BݞBfB{BBBBBۣBܞB\BݣBߣB=qBݙBGB{BݣBLBW
B݀ B)Bس3BpBffBBBaHB  B8RBBpBW
BW
B8RBfBW
BؽqBۏ\BLBzBLB߅B.B33BBQBBRBRBqB33BffBBpBB
=B\BBBBBBBW
BkBBBkBB\B{B#BB#BpBGB癚B)BB{BaHB3BaHBRB뙚BBuB\B3BpBBzB(B8RBuBBffB
=BfB BfBW
BzB\B
BpB
=BBffB\BfBW
B)BBݙB{BݮBBBޞB)BffBݣBzBBǮBݞBB֞BuBuBB#BԊ=BBBffBBBBBBHBBzBkB33B=qBQB8RBᙚBkBzBB3BuBBǮB33BۅB܀ B{BB
B(B8RB8RB=qBB)BBB\BLBGBRB#BBBW
B)BBHB BB.B.BzBBHBBQBBHB3B㙚B.BffBǮB=qBBB B{B  BHB  BB8RB\B؞Bي=BBBW
BǮBzBBHBBBpBfB枸B\)BLBB.BߣB33BW
BkB\)BBBQBB33BBB晚BLBGBڅBBBBBB
=BǮBBBBRBpBǮB\BW
BBBB  BpBaHB
=BBffB
BzB=BqBfB33B
=B  BBaHBB\)BLBBBBW
BW
BB BBRBaHBkBBffB33BRB{B{BBHBݔ{B.B)BHB♚BBBB
=BfB=B.B
BBBBzB8RBkBފ=B(BQBQB  BԙBǮB׮BQBzB33B
B
=B޳3BB33Bފ=BHB\BǮB۽qB؊=B\)B#B33BzBBBģBBٔ{B\)BBffBpBzB(B׮B۸RBܔ{BݸRBfBBBBBuB(B{BB\)B
=BBB B3BffBBǮB\BB8RBuBBffBzBBBB.BBǮBRBaHBGBuBqBuB3B=qBB\)BQBBBBzB8RB B B\)B\BLB
=BQBB\BBHBGBfBffBBB=qBߣBpBܞBBB\B=qBffBffBRBqBffBB(B{B=B B\B#BLB
BBLBԊ=BaHB
B{BfBBBǮBBqBB{B3BB=qBBHBLBBfBGBRBBqB=BBaHB\BzB\)BǮBBB\)BzBzBBBꞸB#B.BB
BBBBǮBGBB{BBBB33BB
=BpB)BB=BHBBBBB{B{BRBHB{BkBBLBݽqBBBLB޸RB33BGB)B݊=B\)BB{BB3BRBۣBfBBBָRBӽqBfBLBBB\)BGBϞBǮB=qBꞸBBfBBڣBB)BaHBB.BQB8RBB)BBǮB33BW
BB(BHB߳3B BW
BqBBQB(BBaHBfBfBRBBBB{BzB BBQBBBffBGB3BaHB{BBBzB螸BBGBBBB33C!HB33CB=CT{BBB#BǮBBRBBB
=B잸BB)BB{BǮB=BuBGB=qBB
BB BHBBBB\BBzBBB{BܞB=qBݞBuB.B.BW
BLBBBB#BBܽqB33BBzBǮBffB  BܣBpBBuB㞸B3BLB㙚B
=BBkB(BBBBǮBߔ{BQBffBBB܏\BuBBHBGBkBBBaHBfBBHBCBC BkBB
=B  B  B#BB=qB{B8RBޏ\B虚BLB잸BLBBzBHBǮBkB{BffB
=BkBBBBqBffCJ=C&fB.B=B(BBffB.B8RB
=BǮB\BBǮBfBaHBaHBBpB3BW
B\B BB33BីBܞBQBuBBuBqBBBBkB\)BRB{BBaHB\BBBB\)BBB=B(BBBpBqB  BB)BW
BBaHCC&fCRCfCC%cCٚCfCC
CCRC@ CBffB
BC 3BQBBBGB  BܙBB\)B)BC8RCBkB\BB#BBaHBGBB{B  BW
B\)BBGB33BBHB陚BB\BQB\BB=qB=B BHB\)BBaHBۨB܀ B8RBaHBB(BpB{BǮB\BLB33B8RB8RB#BLBaHB  BGBffBB\BBkBzB#BB.B33BffBǮBB{B{BW
B虚BLBfBQBW
BB
=B3B(B=BBBB\BRBkB{BBBfBBBBzB(BB
B.BkBzBخBffBW
Bـ BB٨BBܳ3BBzBffBB
=BǮBܔ{B\BѽqBBB
=BBqB)B#BBBBB\B虚Bڔ{B
BkB{BƔ{B\BȮBBBaHBֳ3B=qBaHB=qBQB\)BϏ\BЅBљBҨBӣBLBuBؔ{B؏\BB=qB
BǮBڀ BB߳3BߞBB BBffBܳ3BuB\BBB{BBGBBHBߞB.B(BHBuB՞B(BffB.Bճ3BkBpBBր B{BBڽqBW
B8RBУB  BpBW
B(BBď\BBHBBB
BfB#B)B8RBGBGBGBpBGBfB BpB
B\BϙBҸRBB
B)BB#BGBѳ3BBBȽqB  B8RB=qBր B#BGB֏\BB\)BBkBծBǮBֽqBHBԅBԙBffB)BaHB\BkBfB
=BBΨB
=BfBB{BҊ=BaHBHB
=BBB\BQBkB(BzBB޸RB)B޸RB\)B=B(B߀ BBܮBpB׳3BQBǮB33B(BpBkBGBBBBӣBBBpBuB.BGBkB  B=qBǮB
=B\BBB)BЊ=BGBBBнqB  BfBHB
=BW
Bγ3BBBGBBW
BBس3B\BٽqBkB#BB=BHB(BBffBBQBBBfB#B33BQB#B.BuB.B#BW
BBBB\)BB{BBߨBzB{BB܅BBרBffB  B(B33BBHBGBBGBW
BBuBǮBBB\BBB֨BGBԔ{BB)B{BӞBԏ\Bԏ\BBӏ\BӅB=qBB8RBԣBӊ=BҞBѨB˨BBɏ\BBB®BkBBB  B\)BBܙBϙBBuB  BkBBBBBLB.BkB{BkBӔ{B.B8RB#BǮBBרB֣B׸RBBBGB\B)BB(B
=B BaHBB㞸BB)B{BLBBQBLB  B8RBBffBBB
BpBuB\)B(BzBمBaHBuB)BQBۮBGB(BޮBpBBGBBfB{B33BLBљBfB.BBBπ Bϳ3BBљBبBԨBzB
=BԀ BӔ{Bє{BBѣB
BϸRB\)B8RBGBͽqB.B
=B3BBĽqBBнqBָRB{BBqBffBLBHB)BpBǮBBӊ=BǮBfBQBB  BLBW
B3BޮBB߀ BޅBfBǮBzB  BB  BpBzB\BBGC =CCnC
3BRC RBkB
BB\BffB33B(BBB{BpBaHB=qBҳ3BBaHB
BBzB.B\BBǮBڞBـ BkBuBB\)B33B=qBʅB΅BGBB\BBaHBQBݸRBB8RB\)B׳3Bʏ\BB{B
=BfBƳ3BzBLBB=qBHBGBɸRBffBuB=qBpBBQB
BʣB{B΅BΞB#BpBLBިBᙚBBfB.BHB
=BB)CRBBBkBuBBB)BBBB΀ BBBHBܞBޞB(B\B(B
=B  B
=B\)BߣBBHB  BW
BLBQB\B8RBָRBuB\BҽqBǮB8RBǮBҔ{BҮBҽqBfBнqBzBGBϳ3BBHBBfBHBB\)BuB)B\BffBBBɳ3B
=BaHB)B̀ BBB͏\B.BɸRB(BHB)B=qBď\BHBBBBBBzBffBٽqBֳ3B33BuBճ3BݸRB8RBǮBBߏ\BHB{BkB
BB33B)BBLB\BBBqB\B.B\)BqB{B׳3BfB\)B٣BBBqBB=qB\)BǮBأB{B33B֊=BuBGBQBӨBpBffB
BܽqBޙBHBW
BqBBBB\)BBB=qB޳3B=qB8RBaHBuBRB(BpBzB  BffBBԙBpBљBԽqB=qBuBuBхB(BʨBLBϽqB)BaHBBBڞBᙚB=BBzBffB\)BkB  BB)BBB3B#BGBBBGBBaHB\BRBQB\)BkBqB BBQBHBBBqBBB.B=qB#B  BHBqBGB\B߸RBBBuBpB\)BبB=qB{BǮB߸RBqBzB\B{BBffBB=BBǮBzBHBW
BGBBqBHBB֊=BԙB.B=qBLBșBBHBaHBBB=qBΣBʏ\B\BʅBƨBBLBBW
BҽqBkB#BGB BBGBBB=qBB8RBB=qBpB33BpBaHC BCCC)BBB#B
C {BBzBBBBqB  BBuBBGBBB)B
=B\BǮBBB  B{BB)BuBqBǮBBBfB)B(BꙚB
=B33B=BGB\)BffBpB)BHB
=BBB BRB33BBBffBffB#B♚B=qBqBzBB{BffBQB  BaHBνqBaHB͙BǮBHBܔ{B\)BuB{B\)B{BBQBuBfBffBB  Bހ BuBGBRB=qB噚BB䞸BB㙚BBaHBBBޣB(BݸRBBB{B\BpBBffBuBB)BkB
BqB
BܸRB
=BQBBB۞BLB{BףB{BBۀ BBQBQB33BfBpBQB B\)BffBBRBB33B޽qB\)BBBBQBuB
=BLB  BLBBBGBBBBBB(B
BaHBǮB  BBGBBBݨB؅BLB\)Bۊ=BzBW
B޳3BBffBRBBBBBB#BaHBaHBQBB\)B=B  BB=B  BRB#B{BB݅B\)BڽqB֮B\BBBB#BǮB֮B֞BzB=qBBRBfBB)BkBBBBـ BBB۔{B\BݮBzB\)BGBBB8RB33BQBffBB)BB΅BfB͙B{Bӊ=B\)BɅB33BʙBffB\BBȅBȏ\BB  B(BBBaHB.B͸RBπ BΣBОBӳ3BHB
=BB\BϸRBхBB33BBpBBW
BB=qBW
BqBB
=B=BHBBBB
BB\BRBBqBBB  B)BBzBB.BݨB(BBBBQB\BuB\B(BBBaHBBkBBB33BLB  B#BBCBB{CBBǮBzB33B
BBpBڊ=B
=B  BBس3B؊=BGB8RBHBŀ B=qB.BBB(B(B#BB33B\BB8RBuBuBBǮBpB#BB\BzBGBBBfBBB\B陚BB=BB.BB\BLBfBBzB33BB#B=qBBHB˽qBLB{B.BQB{BǨB\BͮB(BϙB#B)B=qBzBW
BϞB˞BHḄBW
B  B˨BffBԔ{B.B
BBB33BkBB{Bŏ\BBffBBfBĨB\B{BfB)B\)BƮBBuBƊ=BBĊ=BB
=BBuBǮB\BBB8RBffB8RBB3B33BBpB\BQBɮBaHBǮB͸RBB8RBҞBԀ B#BBLBبB
BB݊=Bݳ3BBݳ3B{B.B8RB  B߳3BqBBLBǮB  BB)BBBޏ\BaHBGBpBffBB=BGB{B
=BRB33BaHBBBqB33BǮBuBBʏ\BB\)BQBBkB=qBBHBC^CJ=BLB\B B
B8RB݀ BffBمBBڣBB\B)B8RB׀ B)BמBҨB(BBʣBQB
BǞBLBBHBBϨB
BpB)BpBѨBB
=BkBָRBԀ Bܳ3BpB=qBǮB̏\BB=BBffB\)BzB3BǮBBBŀ B33BǮBBB
=BąBkB(BGBBBLBpBǮB#BBB.BӽqBхBγ3BuBЮBffB\)BuB
=Bр Bϔ{BGB
=BΞBϏ\BQBBɳ3BGBǽqBÏ\BaHB BzBBǮBaHBkB\BBB\)BBBW
B¨B¸RB3BęB(B8RBǮBǮBBBBpBaHBÅB{BpBB)BW
B8RBaHAMpB{BpBB
=BQB=qBˏ\BBB  BΊ=B  B(B)B҅BfB
=B8RB\BBսqBBaHB\)BuBݽqBB\)B\BaHBzBߣB{B߮B{B
=Bߔ{BRBW
Bފ=B݀ Bފ=B#BߙBڨBBBڏ\BHB׏\BBBٽqBBBBBٙBfBkB\)BؙB؞B#Bي=B
=BLBBBHBB.BaHB  BBLBBaHBBkB8RBBuBŽqBɨBB͸RBuBΊ=BԸRB33B֮BffBaHB8RBpB٣BBB3BݞB)BBGB33B8RBRBBB)BBB
=BBHB=qB(B
B
B  BBpBBB)BW
BBCCkCYBB(B{BBC RC B
=BǮB
B
BBBꙚBRB.B.B=BpBBGBRBBB.B3BqBǮB.BffBB\BBqB8RBBBBBBBBQBLB=BB  BkB33BB{BӨB=qBBffBBBB(BuBҳ3BfBؙBр BBBօB\)BW
BB\B#BB
=B
=BRBpB(B(BHBBBB\)B33B=qC \C \CC޸C3CECHCCxRCkC=qC
5C
^C	)C	C޸C

=CCcC=CC@ CfCCQBffBW
BBBuBW
B{BzBRB\B)BkBǮB33BB
BffBB{BB{BBB(BBBuBBqBHBǮB.B(B
BLBQBՀ BB#BBBpBBkBW
BB=qBQB
=BB#B B=qBBfB=qB.B  Bɳ3BBBBB
BBǮBBBHBC CC!HC
#CfCC
aHCCC
8RC CC
CpCǮCC.CC=CCC޸C
qC33B\)C  C=C O\B CEB33C	HCCCfC  C
HCGCBC
8RCs3C	C0C
{CC33C8RCCffC3C(C{C\)CBBLB  B)BuB\BBLB
B=BW
BǮBQB\)BB#BffB)BBB\B(B\BffBqBffBBqBB3BBB(B#BuBBB B3BBC 
CCC{C C.CٚC)C	&fC
C0BW
BB3BGB8RBC+BC
)BHBB\)B\BBGBaHBffBB#BqB{BBuB  BBǮC0CLC
@ CٚC	ٚCC
CC(C=qCC)CC5B.BBBC BB{B{BQBpB\B3B\)BaHBffBHBBB
BB͞B=qBzBffB(B#BLB̸RB33BkB
BBQBGBW
Bڳ3BBB  B33B\)BkB)BB\B{BGB(B\BB{B=qB陚BuB(BBzBGB#B{B3B=qBBB3BuBBRBBB=B=BHB=qB=qBBfCC33C	C\C CٚCCHCC
=CffC^BGCC 3ChCzC+BBaHC5BqB
=B
B(B\)BQBBBW
BuC)B\B{B
B=qBBBBkB BzBǮBGB{BBBpB  B\)BuBBB.BfBB  BBuBBՊ=BB(Bڔ{BB܀ BLBBB8RBqBB➸Bݔ{B޳3Bފ=BǮBBpBݮBffBBB33BuB
=BzBB
=BߨBB{BpBB=BpBffBkB)BffBǮBW
BLB=BB#BB{B8RBqBB\BQBHBBaHBHB޳3B{B݀ BݽqB(BBHB33BkB
B#BڣBBHBffBB#BǸRB\)B
BB BBBBW
BqB BHBqB3BQBaHBLBBBθRB  BΞBBBpBzBBkBzBffBծBԊ=BBBՅB֔{BBuBB٨Bُ\B\BaHB۔{BBۀ BۨB\BLBW
B׳3BQBHBBؔ{BzB\)BB\B{BԅB{BkB#B#BQBB=qB)B(BԳ3BBBHBkBԔ{BB)BBѽqB{B  B#BϞBuBQB)BǮBBfB\)BШB\B  BfBLB=qBaHBuBBǏ\BƏ\BèB#BW
BB)BBzBBBBǮBuBBBB)BGBLBԽqBB=qBBˀ BkB33BBW
B8RBBΔ{B\)BkBڣBBBffB
=BBԮB=qBՊ=BգBBԏ\B\)BԔ{BBQBBGB{BHB
=B(BǮBBҮBҊ=B
B  BԊ=BըBBBBLBѳ3BGBGB\)B
=BBBuBBBӨBҏ\B#BӣBBѨBLBՏ\BpBиRBиRB8RB8RB̸RBzBHB  BBBBB\BЏ\BW
Bϳ3BBBzB΀ B΀ BkBBЏ\B
BѸRBfBр BffB͞BpBϸRBpB)BBBBW
B(BuB#BǮBBffC0C CC#33C${C
^C  C
C&fCuC\C
hC\C
=C&fC#CC)CLCzBBǮB\B)B
BB왚BB(BW
BꞸBBkB{BGBBkBkBffBԊ=BfB̅B.B#BzB=qB{BpB=qBBɮBȅB)BB8RB  Bď\BaHBuBəBGB  BBBBɨB\)B\)BW
BȅBGB(B
B#BBQBѣBǮBӮBuBB=BBBBHBBzB=qB)BخBBըB
=B
=BLBBB{B\)B)BBC aHB.BBBBaHBffBBHBBffBBBaHBB8RB BB=BLBGBB(B\B33BB8RBB
=B׸RBpBיBffBה{B=qBBBԳ3BQBҳ3B33B=qBД{BQBQB#B8RB
=BfBԽqBW
BHBֳ3B33BҮBQB
BHBQBB˨BfB͙B
BuB  BB\)B8RBkB  BfBQBB BBuBBB8RBB=qB8RBzBBBB  BQC !HB枸BBfBB=qB=BBBB{BBW
B\)B3B BBB\BRBꞸB33B BqB#BuB.BpBQB33BBBBB3B\BB B(B  B  BݮBB8RBLBșB؀ BأBǮB
BB
=BaHBӸRB҅BpB˅BzB(BkBW
BaHBB=qBkB#B
BBuBó3BpBƨBBǮB.B)BĮBBÔ{BŸRBaHBBǣḄBfB\)BffB.BǮBǮBpBHB=qCB랸BBB33BW
B\B=BHB)BaHBBBBzBQBBuBfB\)B3BB\B螸BB3B۽qB(B#BBBLBB33B=qB.B\BpBBuBLB)BB\)BۮBaHBB.B.BffBLBffB33B)B
B#B{Bڀ B\B.BBЀ Bٔ{Bس3B=qBה{B\)BzBBۣBس3B{BBBzB֔{Bڳ3BأB\B.BpBB#BBה{BW
BBBLBW
BǮBBBϽqBҞBffBQBݮB8RB
=BBB
=BzBBBǮBB.BBأBBBڙB8RBzB
=B
B{BGB֏\B#B{BGB׸RBרB{Bފ=B  BLBܣBB\BBۨB٨BݽqB#BB{BB\)Bڏ\BٞBBLB׏\B؞Bٔ{BfBfBBؔ{BخBaHB{BBBB؏\BQB.BfB)BBB#BW
B#B{B=qB)B׏\B  B
=BffBس3BfBQBؽqBBB
=BB(B۸RBٳ3BǮB۔{BB֞BQBۮBffBBzBBݨBB.BۨBBB#B
BGB޸RB8RB޳3BBB#B
=BuB{B
=B(BW
B8RB\)B=qBۣB#B  BBBB  BظRB(BzB  BۙB33BfBB BuB#B  BQBޅBߞBzBBB#BBaHBۨB\BLB\B)B(Bݳ3B\)B܅BBBBffBǮB۞Bڳ3B  B8RBۙBBkB֮B\BأBBffB\)BffBҳ3B
=BB33BLB\)B
BB؏\BuBQBظRBڔ{BuBpBBۏ\BBB8RB
=BBBW
BLB\B؀ BBBأBfBfB.BBzB\BB{B=BB(BkB(BCB)BB
BpB.B
=BBמBǮB
=BمBBBQBBffBBBB BBBBBuBBBBۊ=BBBGBBQBGBBHB)BHB#BHBBBԨBW
Bӊ=BўBг3BЮB(Bє{BzB.BQBB)BBB33BfBBÅB{B{B3BfBBffBɳ3BB  BfBHBBpBșB(BѣBϮBBBzBҏ\BңBB(BHBkB)BHB˳3B{BW
BǮBLB΅BBaHB)BȀ Bǔ{BBQB)B{BkBHB)BzBBBB#BBBaHBB
BkB=qB̳3BBBB˅B̔{BfBuBBʔ{BƨBĞBąB
=BuBLBó3B\)BB\BąB\)B33BBBBqB\BB{BB33BfBGB BB\BpBB{B®B.BBBB\B\)B
=B{BޞBي=BBBuBaHBӽqBzB
BBB׳3BB)BǮBўBɣBB˔{BzBƣBBBGBfB.BǣBBҞBBuBW
B.BBBRB BԳ3B
BǮBzBυB\)BƙBuBŊ=BBǮB  B
=B(BBǮBB\B)BBkBBBBBB.BuB8RB(BBHB#BB\B{BB\B)BHBB\B#BLBQBBǮBBuBfBBpBBqBpBBLB.B  B
BGBGBW
BƽqBBpBLBǙBȣB  B33B=qB
BýqB(BffB
BB\BaHBGB(BaHBaHB#BBB(ḄBȞBBó3BýqBkB
BffBԮB
=Bͳ3B\)BkBkB
BqBBHBffBг3BW
BBBΏ\BBGB  BBBW
BffBɨBƅBÞB
BW
BffBBB£BzBW
B=qBfBBBBkBB.BLBB33BBHBBͅBȳ3B)BaHBB
BHBfB  B
=BffBB=BuB.B\)B\BǮBB\)B֊=BՙB
=BkBB׏\BǮBBHBܔ{BܮBݣBpB۽qBB(BfBBBΙB
=BѣBB8RBؙB\BBB߅B\BԊ=B8RBLBҏ\B\)BkBQBBLBHB=qB˸RBЮBB(BОC0CC=BQB(B)BBpBQB
=B BkBzB.BuBB  B  BLBLBӨB8RBGBLBǮB.BԣBB؞BB.BQBBހ BuBBkBkBfB՞BBBхBBBQBBـ BB)BBRB3BuBpBGBB\BBLBBǮBޞBB.BffBBݽqBBfB)Bܔ{BBHB=BB
=B
BڨBpBffB݅B(BHB؊=BffB(B֨BBQB
B)BBuBսqBLBBB33BpBB8RB
BB֞BBգBB֣Bր BBBffBڽqB  B܊=B=qB.BԽqBBՔ{BԨBBBBBB(BQBW
B.BffBǮBB#B8RB{B{BBB(BLBمBܮB)B8RBB\B  B3BHBHBBB랸BzBB\)BfB#BGB  BǮBuB(B.B#BfBaHB=BBHBB
BQBuBB33B\B{BBޣBaHBۣBBBٸRBݨBBBB=qB{BffBBkBBBBBBuB3B
=B
=BB잸B(BBaHB=qBuB
B.B.BBBuBBBzB\)BfB  BBLB3B33BޮBBBfB\BB)B\BB\)BBfBB=C{CBBǮC ffB{B.BBaHChCfB=qC=CqC5C{BBC3BB33B)B  BW
B8RB=B
=BBBB\)B8RBB3BBB\BǮBBBB
BBpBߔ{B(BBfBB
BuBGBaHB\B{B癚B)B陚BfB#B  BuBaHB؞BRBي=BBBQBQB)BLBuBaHBBzBBͅBϞB{BҮB8RBڀ BpBܞBݨB܅BpB#BB=B(BaHBB虚BW
B=qB3BB=qBBBBB#BQBffB BBBzC ffCxRB)BfBGBB=qBqB{BBB\BBBB=BBQBBBzB3BfBBuB{BLBHB{B޸RBfBׅBԅBGBޔ{B#BHBBuBfB虚BB=qB癚B3BaHB#BBB\)BB#BLBBpBHBBBBffBBǮBLBBB=B\B8RB=B
BBBBzB  B3BLBpBǮB
=B.BzBBBffBqB  BB8RBRB3B3BB\BB\BBLB=qB{B)BBBW
B8RB(BB33BBzBqBLB=qBBBRBffB{BBB
=B  BB3B\)BB)BBqBB\B=BQB33BBBkB B3BBBHB B
=BGB#BuBLBBBaHBBGB(B B.BBBBGB.BBBLBaHBB\B\)BBkBRBB)BǮBaHB
B3B{BBB3BBBB#BBBW
B33BBaHBqBꙚBBBǮB{B B\BBBB.BQBBLBBQBǮB.B׮B=qB  BB{BBLBzB=qBB{B=qBzBkBW
BW
BӸRBB.BuBBB
BΣBͣBBuBQBѽqBpBuBkBLBBBBУB=qBW
BBB(BaHBHB(BaHBBBBÙB\)BBBRB
B
BǸRB
=B  BQBBΔ{B̨BϮBW
B=qB.BBuBaHB֔{BkBԊ=BW
BBB\B\BBpBޔ{BBB=qBB=BBHBB)BBBBkBѣB33BfB{BHBΏ\BЙB8RBW
BffBʙBB˨B\BBB=qBBɣB˔{BB̳3B.BĞBŊ=BQBŸRBBaHBB=qB)BB BBRBuB)BBHB=qBó3B#BuB)B  BW
BĽqBBBBBBW
BBfB£BBBW
BB.BBBW
B
BB)BqBQBB8RBď\B\B#BHBkBGB
=BBϳ3BBͣB՞BBЀ Bϔ{BBB=qBffBB͞BƏ\B
B8RB=qB#B#BԙBծBpBQBBB\)BBGBW
B{BaHBHB՞BBBGBγ3BW
BЮBҏ\BѮBє{BHB)B˙B.BkB
=BaHBͮBϊ=B=qBpBǮB\)BД{B.B.B\B{BBѸRB#BǮBpB#B)BpBBʳ3B#Bʀ B̏\BLBLBɮB\BBȽqBuBBɀ B\B̀ BBОBpBѣBBBffBBB̀ B
B̨B֏\BGB̞BיBBB(B\BҙBB33BkB
=BBBaHBHBϏ\B=qBGBHBɔ{B
B.BGBȳ3B8RBBffBzBB)Bȳ3BB¸RB
B8RB{B)BBBBͽqBB՞BzB֣B֊=B#BQBuBQBBBBHB
BfBB̀ B
BW
BaHB.BB.B  B
=B=qB#BǮBB\)B\BLBffB\B£BӀ BfBzBuBBB8RBB҅BB8RBfBՔ{BBг3B\BaHBѮBҨB(B҅BԔ{B\)BffBBffBBaHBҨB(BW
BBҊ=BB=qBBǮBB  BkBBٙBLBօBB  BӀ B.B˽qBЊ=BBӞBԳ3B.BB(B)BLBaHBӳ3B=qBB׀ B8RBB=qB=qBGBpBBъ=BУBBpBҊ=B
BzBȔ{B\)B{BHB{B.BģB\BffBǮB\BB)BBQB  BԨBӅBffBϞB(BҞB8RBՊ=B{BֽqB׀ B=qB)BuBLBB׏\B\BzB8RB33B؊=BfB33BڙBfBBBBخBpBBףBB׮B؏\B.Bي=BBיB{BaHBuBBaHBֽqBfBHBBѮBД{BЀ BͽqBBӮB\BHB\)B؞BBB؞BBӏ\B#B
=Bʊ=B\B
=BBBљBuBBǮBB.B
B΅BBBuB(B͔{B  BBQBfBB\BQB33BaHB{B\)BW
BBffB՞BB\BBBָRB
=B=qBؙB
B\)B׽qBB
=BB֙B\BB{BܙBBkBW
BޞB޳3B=qBܞBpB=qB
BGB܀ BBpBaHB܅BǮBGBaHBBuBӔ{BLBըBBfB\)Bۊ=BB)BB(B٣B؀ BأB{BGBBBB܀ BBޣB=qB{Bܔ{B)BBBڔ{B\BQB
BaHBؔ{BB֣B.BBҊ=B.B)BB.B{B
=BθRB.B\B
B(BəB B̔{BǮB
BB.BfB{BzBՊ=BׅB#BuBBBB{B33BffBޞB)BHBzBQB
=BBkB3BBffB=B=qBffB33B{C\C)BBBB8RBB#BBzBGBBpBBW
B(B#B=qB֞BBBzBzB\B BkBB\BBffBЏ\B(Bԏ\ḄB՞B؞BڅBpB)B  B܅BǮB\B)BHBB{BѨB\)BHBffBLBД{BB.BB׽qBffB#BHBkBЮBW
B\B)B  BΙBpBB\)BB\BBfBșBȣBHB̊=BϸRBB
BϣBυBЮBя\BBֳ3BBLBBB׸RB33BأBHB.B٣BՙB.BBҳ3BGBHBGBB)B=qB͔{BɮB.BfBkB.BʅB  BBBffB{BaHBB\)B8RB͙BW
B
B̅BuBffBɞBBffB=BB33BBBW
BأBؙB=qB=qBB(B=BBBB
B{B33BBBqBaHB\)BHBQBǮBqB{B\BuBqBuBǮB=qB®BBŊ=B33B=qBBșB8RB33BQB.BʸRB\BBkBBHBW
B{B˳3BuBBBBB)B̏\B˞B\)BkB\Bɏ\BfBaHBBpBB BaHB8RBB=BŔ{BkBBB³3B\)B\)B)BkBB=qBuB
=BpB
BÊ=BĮBîBzBB  BBBBBBB
B\BfB  BB
BuBB  BB{BQBBB
BRBffBRBaHBBGBBBB\)B\BHB)B3BkB BkB{BBBHBǮB8RBǅB)BɊ=BBʳ3BpBBB\B(BBBBzBΔ{Bͳ3BpBB\)BBBBBBB
=B
=BHB\)B8RBɏ\B8RBBBBǮBBBBB8RBBBḄBLBB\)BaHBB)BHB=qBGBɨB8RBǞBW
BaHBŀ B
=BfBpBBfBď\BǸRBzBǽqBBǨBƣBBW
BB\BƨBBĨB.B{B®B#BĽqBQBuBB.BBzBŊ=B˅BB=qB8RBffB
B33BθRB8RB8RB\B#BBQB8RBB\BҸRBӔ{B=qBܨBڮBBBٮBܙB׀ BkBӀ B8RBӏ\BHB
BfBBBHBkBиRBfBB33B  BϏ\B33B
=BљBѸRBBB
=BBѨBҸRBW
B(BBӊ=BҽqBBє{B(BzBҳ3B
BB(BGB)BB  B\)BB͏\B͙B.BB͊=BB\BB
BBBGBBȨBB8RBΨB\)B33BzBLBpBpBBBBB8RB(B  BΙB.B)BBB\)BͽqBB33B
BBѳ3BBW
B33BBffBBzBkB.BW
BB#B׊=BBڅB۳3BB޳3B  B܀ BBB(B#BkBGBڊ=B(BBBؙB֮BՔ{BBB֣BǮB33B{B
BBBي=BܽqBBfBkBBB\)B
=B͙B  BQB͊=BpBfB{B
=BGBυBfBB
=BBBpBиRBHBәB
=BHBBB8RBɀ BGBB.B˔{B˞B8RBϏ\B{BѣBԽqBծBՙBҏ\BB\)B(BљBBBffBffBB
=BBBֽqBzBרB
BBBW
B8RB
BaHB؅Bڳ3BaHB\)BuBBLBרBGBqB Bފ=BLB.B
BLBRBCCCBCBRBLBfB
=B\B
BB)C޸BB.BLB{BBffBǮBHBBffB{B؊=BӅBkBBBԀ BBBpBzBBpBpBQBǸRBkB
=BBkB\)BRBkBuBʨBϙB̨BBBB{BB(BBBzBGBB BpBfBffBBBB
BׅBǮBLB\)BBB֔{B.B\BӔ{B׽qB֙BHBݙBܙB#B
=BB۳3BB\BkBzB)B  B
=B\B\B׳3Bֳ3B8RBGB33BBǮBǳ3BW
BӮB)B=qB\)B8RBϸRBBB33B\)B͸RBЀ B(BBGBʔ{BŞBȏ\B.B.B8RBzBǮBȳ3B³3B8RBHBBGB#BqBBpBBЊ=B˳3BQBǮBB׏\BkBўBBˮBΙBBB(BkBBB8RB΀ B=qBBΙB
BBBzB
B\BֽqB=qBLBBpBW
BBLBaHB#BkBBBBBӔ{BօBffB33B33BԸRB҅BBB.B.BׅB#BfBϳ3BHBУBͽqB.BϙBД{B̽qBffBaHBfBkBaHBB8RB\)BGBҊ=BfBBϏ\B͏\B33BˮBǙBHBB#BǮBB8RB=qBBBBaHBfB{BB=qBBǮBȊ=BʮBBuBQBuBW
Bг3BGBBӔ{Bۊ=B33Bє{BҮBBӞB(B{BpB)BB(BBB)BW
BBB=qBޣBB#B\BkBB)BBLBBُ\B(BBBB33BBBBԸRB
=BzBBBB֞BkBaHBBBؔ{Bڀ BLB݅BߞBݏ\BBLBffBHBuBޅBW
BBB\BٽqBHB8RB٨B
=BBBBѸRB
=BД{B\B)B=qBˀ BkBBBBB)B(BzB޳3BuBkB鞸B33BBB݅BHBuBBB.CٚC
{CCC\CGCBBBpBBBǮBuBffC BQBffBǮBfBqBffBBBuBB(B=qBRBC
BBBB)BaHBBLB8RB
BQBpB  BRB=B
BaHB{BBaHB)BBB陚BBffBpBaHBRBW
B.B{B֊=BʽqB
BBͽqBʳ3BffB\BƙBffB8RBя\B{BۮBB
B
B
=BǮB8RBͳ3BLBBBBB\)BW
BW
B\)BGBLB  B)BBzB#BۙB\BffBǮBBHB\)BBBճ3BۨBڏ\BBB)B#B#B(BGB)B
=BBBGBB=qB8RB=qBfB{BBB  B\BHBpBBHBBB)BBBBpBB=qB33B\BLB=qBBB B\)B߀ BW
BqB{C BܣB܊=BB#BBqBBڞBaHBffB
BҀ BأBǮBՀ B̊=BԽqBѣBuBңBңBuBٽqBaHBGBfBBGB.BGB)BkBRB.BBB\BuB\B8RB{B  B{BBW
BB8RBڸRB
B(BܨBfB♚B.BLBޔ{B33BuB33BHB\)B{BRBW
B
B\BBW
B߽qBaHB晚B۔{BBBؙB
=B׊=BB33BB֨Bֳ3B(BиRBBB͸RBBBBB܊=BBBffBBzBBBԸRBB  Bր BиRBҨC3B՞B.BfBր B(Bӳ3B8RB֞BBBҨB܀ BfB8RB׀ BBB\)BBǮBBB)B.BffBW
B33BBfB{C#C
@ C޸B8RB{BGC#C^CCC+C0C
CfCC%GCCC	\BC5C \C}qC5BǮB33BzBRB  BQBHBBӽqBѸRBBB{B֔{BkBGBBBє{BҮBBHB
=B)BBڀ B  B)BRBB{BBQBBBuB  BGBBBB3BBqBGBzB8RBB\B#B8RBȀ BBRBBBB˔{B#BzBQB.B՞B)BBB BpBW
BffB
BuBqB{Bߔ{BB(BaHBۀ BLB߮BHBۀ BBBBߏ\BBHBQB
BffB)B#B\)B(BB
B3BGB
BBBfBۣB\)BBB\BHBՔ{BuBϨB
=B(BQBW
B\)C	QC
C
{BfC }qB  BaHB33B)BBkBpBBǮB\)BBqB{CٚCHC nB{BCqCQCC
=BkBB B BaHB8RBB  BqBqBpBǮBQB8RBffBW
BBBGCCuC
CfCT{CC@ BCCpCT{CffCB  BqBkC BBLB3B)B#B
BpBqBB=B3BBBaHBfBǮBHCBBkB\)BkBQB\)BBuB\)BBBpB=qBQBB٨B=qBӏ\BBaHBB  BuBGB=B
BBaHBffBB
=B  BBBΊ=BգBB\)B33BѣBzBB8RBBaHBBuBpBzB#BB.BBBfBBBGB#BfBLB\)B.BGBuBQB
=B
=Bـ BuB#B{BBC
C޸CCC{C=C!HC Cs3CٚC CCC
C
CBC=CpC
&fBuBB\BfB\)B޳3B{BݽqB)B  B{B
=BBB8RBǮBkBۙB=qB33BB\)B=qB\BLBLB
B)BB
=B3B{BpBGB{BB BqB\B  BÙBuBBaHBGBkCYC=qBǮBBBBHB  BҮC )BBB8RBHBpBBHB.BfBfB\)BBBRBffB8RC
Bπ BҔ{BBB8RBpBBB.BzBW
BuBaHBBBBBBB.BC
qBuBpBCB3B\BRBB(BaHB#B
=BGBB=qBBB׀ B{Bڳ3B\)B(BBQBGB  BǮBGBHB\)BីBBB{BkB\)BLBޞB  BHB\)B֞BkBӔ{B33B\BBffB#BHBLBB)B߅BBBBW
BfBBBBBGBfB=qBBaHBuB  BpBBBBڙBzBBB=qBBuBBW
BaHB\)BzB޳3BߞBqB)B3B\BqB癚BB(BBaHBGBkBBW
BHBuBB=B.BffBqBǮBB
=BGBGBB.BBBkB{B\)BB  BBBǮBBB8RB{BBBHB33B=qBB\BfB\BfBRB
=B
BuBB㙚BBuBߙBB\)B(B#BW
BݸRBݞB33BBܳ3BLBuBBBkB
=B\B#BzB\)BܮBBffBBLB=qBkB{BpBBBǮBqBBǮB33B\BBBHB8RBBBHB=qB߅BB߅B8RBB޽qBBBB܀ BǮBBfB(BB)B8RB݀ BaHB)BBBBB33B
=B8RBQBBpB׊=BQB֣BW
BBBHBfBB=qB
BǮB.BәBGB33BffBffB.BffBLB.Bӏ\BԽqBҀ Bѳ3BB̏\BzBǮB{B=qBBpBffBУBuB)BB33BBLBϊ=BЊ=B33BأBfBǮBBؽqB)B8RBـ BBΙBpB33B3B
BW
BBB33BpBB(BB{BظRBBB܅B  BkBuBݳ3BaHBǮB
=BW
BB.BB
=B݊=BʨB\)Bя\BLBٮB
BBBǮB
BHBؽqBףBBBѸRBBǀ B)BLB)B8RB.B33BBBkBΣBuBBƨB  BƽqBBǮBkBHBų3BuBQBB  B(B
BɽqBGB.BBBҮB͸RBπ BpBaHB؅BBW
B(B{BB홚BB{B8RB#BBB陚BBW
B۔{BBB
BfB33Bͳ3B
=BB#BffBգBffB.BQB瞸B.BBBBBB\Bۀ BBBǮB(BpBLBuBBBُ\B(BBٳ3BQBǮBBخBHBBBBHB33BνqBϮB͔{B̏\BǮB\B(BuBԏ\B֏\BBBה{BBGB.BBBzBBӸRBӔ{BBB#BBBݳ3BBBBBBB(BBfBzB  B.B➸BڨB(B(BBօBBԽqBӣBBBљBѨBGBB
=BGBkC 3BfB\BQBzBaHB.BB#BBffBBBBB{B8RBW
BBkBLB
BBqBuBBBkBBHBzBfBBB
=BC\C
:C3B
=BaHB)BW
B{B#BٽqBzBGBԮBәBӀ Bҏ\BԞB҅B)B
B33BB)BpB\)BB͸RBǮB͊=B͔{BB(BB\B؀ BBGBBB
=BzBBBaHBB{BBQB\)BW
BpBBB͙B\)BQB  BaHB׽qB.B\)B\BHB=B)BGB\BBBLBpB3BBffBB߸RB  B؀ BڣBfB۞B\)Bݔ{BzB۳3BB\BB\B\)BרBҏ\BBBBBBBڀ BzBǮBkBkBLBBǮBpB{B͙B̽qBfBƳ3BW
B
BBBBBB BLBBGB33BaHBGB#B{BBkBB
BBBĸRBHBƳ3B{BB\)BpBGB  B
B.B{BGBמB
=Bր BkBQB33BٞBBLBuB=qBzB{BBB޽qB  BB=qBffB޸RB=qBۊ=B\)BB׮B8RBרBB33B׳3B8RB
BkBLB8RBGB֣BBLBuBҨBB33BB܅BޣB#BW
B\BkB#B8RBBBǮB.BzBB
=B)BfBΨB̞BBQBW
Bʊ=BBBĸRB.B(BLBkBfB΀ B  BGBaHBzBBffBLBLBνqBѨBkBǮBBЏ\BBBBӅBՙBW
BBҞB
BԅBθRBzBuBǮBBuB
BׅBٳ3B=qBي=Bڔ{BB33BBffBRB(BBꙚB뙚BBBuBaHBRBB
=B{B(B
=BǮB\BffBfBfBފ=B33BB߅BBٸRBBfBQB.BBB\BGBffBBpBQBffBBfB#BǮB8RB)B\BҽqBaHB8RBُ\BfBُ\B
=B)Bֳ3B.B#BGB
=B  B֮B\)BzBHBB#BϸRBBffB#Bڳ3BޣBٮBؽqBaHB٣B{B؏\B
=BBHBB.BaHBBٳ3B
=BBQBB
=BBpB\)B3B垸BB♚BzB޽qBݽqB{BѽqBffB8RB҅BЮBϙBυBBW
BBaHBkBBԅB\)B
BBB(BLBBڨBQBؽqB  BսqB)BB33BuBHBfBuBڏ\BQBGBB33BBڙBـ B8RBaHBLB8RBBLBuBظRB
B
=BՀ BB  BҙBBиRBaHBθRB̸RB̔{Bϔ{BυBBBͮBB{BϨBBBBBGBQBBB)BpBBBبB=qB{B)BؽqBBB\)BpBǮBBBܔ{B؞Bܔ{B܏\BܸRBzB\B)BBǮBފ=B8RB.B\BkB؅B=qBBQBBBӞBӸRBиRBBzBaHBр B#BfB̮B.BW
B)BB؀ BHB#B)BϽqBљBє{BЅBӞB֏\BW
BәBpBffBѽqB  BpBffB\BaHB=qBfBfBLB{BʞBͣB̸RB͙BBϮB33BaHB\B̙BB=qBҙBW
B=qBӸRBԏ\Bӏ\B33BHBaHBԊ=B{BBۮBBB
B\)BBB B䞸BBLBBuBuBqB\)BB  BGB\BW
B
=B
BW
BHBBB
=BBzB۞BڅBfBǮBףB
=B\BpBBB=qB#BՔ{BBظRB֮B
B33BBϞBGB#B\)BQBfBGBkBŔ{BBpBҏ\BB˽qBBʙBɳ3BBB8RBB{BɣBBB\)BBȀ BB)BBBB33B#BϙB8RBәBԮB.B8RB
BՔ{BB  BBB\BBBB8RBBuB\BChBB8RBB{B
BzBB=BuB  BqBB\B#BGB{B=BB=qBHBkBօBǮBBףBBؽqBBB
=BpB
=B(BB
BLBuBLBW
B۳3BRB{BߨBuBڅBffB˞BBB8RBuB BpB#B=qB#B=BBB)BfBBGBBB.BƏ\B)BB\B3B.B
=BffB\)BɨB)BBϏ\BBЊ=BɮBǣBǀ BǮBBBBffBBB  BHBB
=BfBѨB#BQBՏ\BBB33BBB8RBGBB\B(B(B{BGB(BBBBʨBkB)BBBffBffBLBϨB\B
=BǮBB{BҽqB
=BQBW
B\)B{B֞Bє{BϏ\B\Bъ=BЀ BBͳ3B΀ BGBθRBˮBBpBpB8RBЏ\BHBB#BBиRBW
BLBW
BzBBfB
=B{B̊=B33B\)BBͽqBBkBҏ\BBBхB
Bӊ=BfBHBLBkBkB{BfB\BܨBڀ y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y y AAHA  AzARA\AARA33A{ApA33A\)A  AA  AƣA33ApA=qAǙAǅAzAǅA
AǅA33A\)AHAffAQAřAAď\A=qA(AAŮAGAǙAQAAȸRAA
A  AəA  AA
A33A\)AǙAǮAGAA  A  AGAĸRA33AAAGAHAŅAA=qA\)A(AĸRAHAď\A=qA  AÙA  A
AĸRAĸRAQA33A\AAA
=A(AzApAA£A\AA\AAģAŮAƸRA33AɮAǅAAA33AAȸRAəAȏ\AA  AAAA=qAffA
AffAGAď\AAAAȏ\AA
=A33AA=qA(A33AAƸRAŅA=qAHAApA{AƏ\A{A
AA=qAŮA  A=qAřAAřA=qApA\)A33AŮAGAAHAA=qA\)Aď\AzAģA  AA  A\)A
A(AĸRAHAď\AĸRA
AA
A\)AGAA\AAA
=AGA  A(Aď\AffAGAAîAzAARA{A(A=qAA(AffAÙAÙAģAAƣA
=AǮAAǮAǮA{AAAA=qAAAAǙAǅA\)AƣAƣAƏ\AGA
=AAAffAffAîAA\A\)A
=A{A(AŅAAzAQA
AĸRAzAQA
A
AAQAffA\AÅAÅA
AAQAQAQAHA
=A(AzAffA=qA\A=qAAď\A{AQA
=AAA
=AA33AA  AffA\)AAAAA
AAHAĸRAAĸRA=qAA\)AA  A  A(A33AĸRAîAzAQAQAQA  AAffApAA{A
=AAA\)AAffA  A  A(ApA{A
=AA  A
=AQAAAGA{AîA33A\AHAÅA\)A
=AGApAîAAîA{A{AffA=qA=qA(AĸRAGAĸRAA
=AQAHA{AffAÅA  AîARAffA(A33AA33AA33AAzA33AGAAAA¸RAA
=A\AA(ARAAA\)A
A  A(A  A  A{A33AAHA
ApAzAAA=qA
AGA33AAA
A33AAA(ARAHAAQAffAA=qAGA\AAA\)AAAAGA\A¸RAGAQAîAď\Aď\A=qAģAQA£AzAîAHAA¸RAffAA33A(AAAAAA(AA  AA  A(A
=AAAARAffA\)A(A{A  AAGA33AA  A  A¸RAA\AAGAARA  A
AA{A\ARARAAAGAGAAAA33AGAGAHAA(A{A
AHAzA=qA(A  ARA=qAGAA=qAGA{AA\AffAA{AAAA\)A(A  A  AîA=qA
AÙApA  AAA33ApAAGAA  AHApAzAAAA
AAffA=qAQA(AQAffAGAzA\A\)AHA
=AffAzApAHAA(AAzAffApAA33ApAAzA\)AA\)AApAAffAAQAAď\A\)A33AGAÅA=qAzA33AŮAQA=qAƣAAzAƏ\A  A=qA33AA{A=qAHA  AQAď\A¸RAzAA  A¸RAAzA{AGAAQAAA  AA(A¸RAA  A
AQAHA(A\A  ApA
=AAAAffAA\AA  AAQApAApAffA
=AAAHA\)AGAARA(A(AA  ARAApAA  AffA
=AQAHAřA
AAAA(AGARA  A33A
=ApApARAA=qApAApA
AǮAGA
AǅA  AzAzAȏ\AȸRAȸRAzA
AAǙA\)A
=AƸRAƸRA33A33A{AřAģAď\AffAffAGAƣAHAHAQAGAǮAǅAǙAǮApAǅAǅAǮAAAA  AƣAƸRA{AƏ\AQA\)A=qAŮA=qA=qA{AzAAHA
A\)AffA33A33AffAffAîAÙAÙApAÅAîA\)AGAAQA=qA¸RAĸRAŅAĸRAģA  A{A  A=qA
AzAA
AzAQAffAffAffAffA\AîAřAQA
AAAǮA  AƣAƸRA33AAAAď\A33AA
=AřAŅA\AHA
AQAffA  AHAGAřAŅAHA
A33A\)AAGAAzAŮAA=qAAAAHAHAA\)AřA{AzAAAGA(A=qAîAQA
A
A  A  AApA(A=qAHAĸRA{A33ARAQA
=AA  AAAA£A
=A33AA
=A33A33AAA
=AAAGAA  A
AApA\A\A\)A
=AAGApA\)AA(A(A
AAA\)AHAA  AHARA  AA£A  A¸RApApAHAffAQAA{ApAÙA\A\AffAAAHAffAQA(A{A\)AA
=AAA\)A  AffAQAzA\AGARARAA{AAHAffAGAGAGA  A  A=qAHAHAAzA\AffAApAAAA\AA\A\ARAA  AA
AApA\)A\)A\)A\)A33AAHA
=AHA(A
A
A(AffAQA(A\)A=qAA{A(A\AARA
=A33AGApAAAAA  AAA  AARAAA\A
AAHA33A  AAGAA\AAHA\)A{AGA=qA(AAA  AHA
=AA33A=qAAAGA33A\AA=qA  AzA\A
A\AffA
=A\AGA(A=qAAHAARAAzARAAA
=AA
=A=qA33ARA
AAAA=qA\AHA\A  AA(A{A{AA\A{ApA\)AGAA33AAHAAApAAHA33AAHA
A  A=qA(AQAA=qApAAAAAA33AHAAA{AAHAAHA\AAHAAA
AzAAA(A
ApA  A{A(AAzAAHAAzAA
A  A=qAHAAAzA\)AAQA(AQA(AAAzAffA
AA  AA33A33ApA
A  AAA
=AA\)A\)AAAQARAffAAGAGAARAAHAHAAHAGAzAA\)AA
=A\)AA=qAAAA
AAHAAA  A  ApA
AA
AA
A=qAGAAQA33A
A33A(A  AHAApAffA(A
=AHAzAQAAAAGA(AAffApA(AA
=A(AA(AA
=A  A£A\AA{A{AAGA{AffA33A=qAA\AHA\)A  AffAAA
AQA£AffApA(AA{A(ApAÅA¸RAÙA£AHA{A
A¸RAzAffAA
=AAzA33AHA=qAHA\AAGAA\)AApAQA\AîA(AzAAAA¸RAGA33AGA\AAQA33A(A33AAîA{A33AA\A\AA{A
A(AAAHA{A(A  AŅAA=qA¸RARAQAAAQA33A  AAA{AQAffAAAAAffAffAQA  AApAA33A
=AAHA
=AHAffAAHAAHAA
=A\)A
A  A=qA{AA{A(A(AA(A(A  A(ApAA\)A  AAAHA\)AGA\)A
=ApA\A
A
AA  AAAAHAApAA\A
AAAAAA
AAAAAAffAAAzA33AffAAApAÅAîAĸRA\)AŮA=qAƣAƣAHAA33A\)AǅAGAǮAǮA33A33A33A
AA(AAA{A{AAAAAǅAǙAǙAǙAǙAGAApAApAAA33ApA\)AGAǙAGA
=AĸRA(AƣApAŮAA{A
A
AzAAAA=qAAffA
=ApA\)ApAÙA\)ApA¸RAzA
AGApAA33AÅAîA(AQApA
=AAzA£AîA=qAzAApAŮA
A=qAQAƸRAA=qAƏ\AffAffAAA\)A\)AAA
=A
=AGA\)ApAGA\)AǅAǮAǙAǅApA\)ApAGAAHAQA{AQAffA(A{AQAzAffAQA
AŮAŅAřAŅAřA
AŮAŅAGA33AApApAŮAŅAAA
A
A
ApA
AAAAA
AŮAŮA\)A\)A33AAA33A\)ApA\)AHAĸRAĸRAzAÙAÅAÅAîA\AAÅAGA
=A£A(A=qA(AAÅA{AHAGApAŮAAƏ\AƸRAǙAA(AzAȏ\AȣAzAzAȏ\AAȸRAzAȏ\AHAȏ\A
=AffA  AAAffAȸRA
=AzAAȏ\A33AQAǅAQAA
=AǙA
A
A\)A  A33AQAffAzAAŅAď\Aď\AÅAffAď\AzApAAA
AĸRA33AA  AîA  AÅAAffA{A=qA=qA  A  A
AGAHAffAA
=AAAA{A\)A(AA(A
A£AGA
AHAA=qAzAAAAHAHA  A£AzAHAîA
AAGAffA{A=qA\AAApAA¸RAAîAAĸRAŮAĸRA
AAŮAřA{AƏ\AǮA
=AƸRA=qA\)A
AQAAÅAÅAAHAzAzApAGA(A=qA33AARA
=A(AAAzA\AAzARA(AAAzA
A{AGA
=AzAA33AA
ARAffAAffA=qAApAffA{ApA{A\AÙA\A\ARAAA=qAAA  AA  AAîAÙAď\AAAHAAHApAȣAHA33ApAɅApAɅAAAȸRAGAȏ\A(AřAĸRAAAGA(AŅApApAģAĸRAĸRAAAAQA  AAîA
A(A(A
A{A=qA{AîA  AîAA
AQAA(A\AAffAA33AAffApAAGAHAGAĸRA{AA{A¸RAAGA  AHAAAAHAGAQA  AA\)A¸RA  A=qA
A(AĸRAÅA=qAÙAQA33A{AffA=qAQAffAHAǙAǙA
A(AffA\)AǅAGAAA  AA\)AəAɮA\)ApAA{AHAGA(AffAzAffA{A  AǮA{AAAffAffA{AQAffAffAzAȏ\Aȏ\AǅA=qApA(Aȏ\AHA(ApA
=AAǮAAGAƣA33AHA
=AGA=qA£AAAA£AAAGA\AQAď\A\ApAA(A  AA
=AGAAAAA
AGAGAAîAď\AAzA33AAǙAA  AzAQAA\)A
A{AAHA
AAQA
=AǮAA=qApAŅAAȏ\AǮAA  A=qA
=AHAGA  AǅAGA{AQAzAQAǮA(A
AA  A=qAȣAQAǙAQApAřA
=AA\)A{AAGAAQAzAQAffA\)AƣAǅAģAA{ARARA=qA{AffAA
A{AAAAGAA\A33A33ApAAAGApA¸RA{AzA33AzAAď\Aď\AAHApA  AAƸRAHAǅAGAǮApAHAHA
=AHAGAƣA=qAAǙA  AƣAA33AffAQAȏ\AzAǙA(AǮA(A=qA{A(A
AA
=AHA(AQAQAAAA
AƏ\ApAAA£AAÙA
A
=AHA=qA{AA\)A{AApAA33AAGA{AA
A=qARAAAAA  AAQApApAÅAÅA{A(AĸRApAď\AģAzAffA\)ApAď\AGAŅA{AřA\)AAŮAQAAǅAGA  AǙA  A
=AAAzA{A  A\)A\)AQAĸRA{AƣAGAAǅAGAAAǙA33AƏ\AîAA{A¸RAHA{AŅAĸRAģAA£A(A  AAAGA33AAffA(AAA  A=qAA\)A
A\)A(AGAA  AzAAQA
=AA
A\A¸RAA  A\)AGA{A(A
AHA
=AÅA=qA  A=qAAAAAA33ApAA{ApAA{AAHAAA=qApAǮA=qAď\A
=AAffAÅAĸRAzAŅAģAAA\A(AHA\)AGAARAffAAA
A£AzAHA£AA  ApAHA{AAAAQAAA  ApAQAA{AA  ApAģA
AffAffA{AA(AHApAQAAzA\)A(AQAffAA=qAAGAA\AQA
A
AA33AƸRAAffA  AA  AQAA{A\A\AzAGAAHA
A\)AffAzAɅAȸRApAˮAˮA{A
=A͙AA{A
AAQA(A
AAAAɅA(ApAQAǮAǙAAGA
=AƏ\A{AÅA\A  AA£AAzAģAQAA  AřAAď\A
=AîAHA{A\)A
AQA{A\)A  AA
=A  ARA(A  A{AAA\)AARAARA
AHAAA(AAAA\)AzAffA\)AAAHAARA{A
=A=qAAA33A
AƏ\AffAƸRAAǮAA{AzAȣA33AAAA{AȣAGAA33AȸRA  A
=AQAƣAzAAA
AAHA(AƣAƸRAAAƏ\AAAAAA
=AAAAAAAHAHAƸRAHAHA(AA33AřAAģAffA33A(A(AĸRAApAƸRA  AffAĸRAA¸RAffAffAA¸RAAAÅA=qA
A  A  AÅA\)A¸RAAAAffAzA
=AffAGAA
Aď\Aď\AAAHAAAA
=AAřAĸRAzA=qA  A{A(AQAffA
A(A
A
AîAAA{AģA  AAĸRAƸRA{A
=AƣAƏ\AzA(ApAAffA  A(A
AzAQApAQApA(A
AA£A\A
A=qA\)ApA\)AzAAAAA(AîApAAffAAGAAzA\A\AAA
A=qA  A\)AffAGAAARA  AHAA¸RA\)AzAAA33A33AARAAARAA  AĸRAApA{A
AHA
A(AɮAʸRAʣAHAGAAAAɅA{A
A33A33AzAHAƣA  AÙAAŅAA\)A=qAQAģAGA{AzApAHA33AîA33AÅAAA33AffAA=qA=qAAQAA{AGAHAHARA
A\A(A  AAA
=ARAffAA  AAA
AAA=qAA\A(A\AAffAffAAAAzA33AAAA{A\AzAA33AîA  A=qAzAģAĸRAAĸRAģAzA=qA
A  A(AffA=qA=qA(A(AÅAA£AA{AA33AHAA\A=qAA=qAA33AHA33AA=qAzAAA(A(AGAHAA\A{AAARAAAARA
A
AAAzA=qA=qAHAAAA\A\)A
A(A(AQAffA
AAGAAAA\)AGApAHAGARA
AARAA{AA\)A(A\AA
=AARA  AAAA  AAApA=qA\AA\A{A{A{AA(A(AffAAAAARAAAAAAAffAA=qAAAffA
A
AAAGAAA(AffA=qA
AA\)AA\A=qA(A  AAAffA
A\)ApA33AAQAAAQAGAAAAHA(AQA\)AARA=qAA\)AA=qAffA\)AQA\)A\AGAffA  ApAAffAAA{AAAA
=AAAGAGAA33A33AAAAAA  AzAA
AA=qAffAQAzAA{AQA
=A\A{A=qA33AGA
AHA=qAAA
ARAHAA{ARA  A=qA(A
AAA\)AGAAA=qA=qAAGAQAAAGAAAAGAA{AApAA
AzA\AAApAAGAAAzAQApAA=qA\)A(AA  A
A=qAGA\)AGA\AA
=AffAHARAA\A  AffAffAffAzAAAAQAAARAA=qAA(AAAA{A\)AQA
A=qA  A=qAA\ApARAHAAAAAAAAAHA
AA  AQA33A{AAA(A=qA(ApA{AApAA
A\AA\)AQA(A
=A
AAAApAA  ARAA  A=qAAGAA(A=qARA
A\)ApA
A
AAAHAGA
AffA\AApA  A(A  A\AffAQA\A\A(AARA=qAffA{A
AAHA
=AApAAffAGAAAAAffAAAAQAffAffA{AffAA\)ApA=qA\)AA  AAA(A  A33AQApAAA
AA\A
A(A=qAffARA\AHAAA=qA\A33AzA33A=qA{A
=A  AAAffA\AApA  AffA¸RA33AîAzAď\AGApAģAffAffAAA33A
=AAAHAHAAHAģAzAffAîAA¸RA¸RAffA¸RAGApAGA33A(A{AAAAAA
AA
A
A
AAAGARApA\AffAQAAAAAAffA
A  A
AHA  AAAzA  AA=qARA{AAAQARA{AHA\AGAA
AAQAA  A
=A(AffA\)AAAA{ARAffAA{AA{A(A
AGAffARA\)AAA{A(AHAAGAApAARA(AA33A
=AA33AzApA{AAAA\)A(A=qAHAAApAffAAffAApA
A{AzAAAAA
=AHAAA(A{AffA
=AAARA=qAAA\ApARA
=A  A{AAAGAQARA(AAApAA
A=qA\)A  AAzA  A=qAQAA33A  AAA\)AAA(AA33AAA{AApARA\)A  A=qAAHA\)AQAAAAAA  A=qA
A\)A
=AAARAGA
=A{AA{A
ApAGA{A  AQApAA=qAHA=qA\A=qAAA
=AA\AA
AAAA\AffA(AAApA(ApA\)A\)AffAHA=qA=qA33AA(ApAGARAffA(ARA\)A(AAzAAAAQAAffA
=A{A  AAApAAAAGARAzAAA  A
AA
A33AA(AHARAHApA  AApARA
A(A=qA
A(AAGA
AGARAAAA=qApAAAApA
ARAAA(AAAAA(A
=ARAHApA\)A
AzA\)A
AA33ApA{ApAA(A(AA=qAAAzA\AHARA33ApA(A(AA  AAARA(A  ARAAApAAAAffAQA\)AAA
=AHAQA  A(A\)A
=AAHA(AzA
AAGApAQAA33A  AA
=A\A\)AAGA\)A\)A=qAA  AA{AAA\AGARA
=AGA
A\AAQAApARAA\AQA\)AA
=AzAAAQA\)A  AA(A(A\)AffAAAAAAGAQA{ApA
AA
=AA\)A(AAAQAQA
AAA  AQA  A33A
ApAARAHAAAA{AA
AAAAGAAA(A{AApAARA\A\AAffAAAAAAAAAGAAGA
AA
AAzAA=qApA  A
A=qA
ApAA\AffAffAAARAA\AApA
A(AAHARA
=ApA
AzAAffAA=qA  A
A  AA  AHAAAAApAA{A{AQA\AffAQA  AAAAGA\)A(AAffA(AAGAAHA\AAAAHA
AA=qAHA  AHAAAffA(AAA=qAAAApAAAAGAAAAAQA\)A(AAA  AffAAffAAAQAffA  A  A{AAARAGAffA33AAAHA=qAQAA{AHA(AARA(AApA{AHA\)AHAffA  A{A
=ARA\A  AffAffARA
=AARAffA=qAAAffAzAQA{A{AAApA  A\A
A  A=qAHA  ARA(A\ARARAHAAAA33AAGAApAA\AA(A\)AAA33AAA33AzAAAzApAffA  AAffA  ARA=qApAAA  AA
=A{AffA
AAA
=AffAA\)AHAHAA
=AAA33AHAAGA33A
=AAA  AffAQARAA  A(A(A  AAAAA  AHA
AAffAAAApA33ARApA\)AQA{AGAGAAARA(AA
=AffAA(AA33AAAffAApAAAGAQAffA  A
AA=qAAQA  AA
=AQAGAzAQA
=AGAAHAA\AA
A(AAQAA  AAA=qA
AffA  AQA33ApAAAAGAA  AAGAA\AzAzAHAAHAAHA
=A\)AA{A\A{AffAA
A\)AA33AA(A\AQA=qAA
AHA=qA{AAAA\AzA\A33AA(A=qAAAHAffA=qAAAAAA\)A33A{ARAHAA
ApA  AAffAA(AAA
=AzAzAHARAzA
A
A\A\A=qAA\)AAHAAAAA(AA{AAAAQAAGAA{Aď\AA33AGAŅAA  AffAA  AAQAzAƣAffA{AA£A\)AÙAAA(AÅAffAĸRApAGAAAŅAGA
=AGA\)AA
AffAA
=AzAHAA
=AQAď\AQA{AÙAAAÙAA{A\AzAApAQA
=AffAA
A(A\AQA
AzA(A{A(AAAHApAA33ARAzA=qAAA\AA33AAAA  A\)A=qA33AÙAApAîAîAApApAÅAîAAÙAÅA\)AGA¸RA£AA=qAA{AQAřApAřAŮAŮAA=qA33AA=qA(AffAApAîAARA\)AzAA  AAAGA(A£ApAAzA
AAA
AAA  AA\AHAzAffAA=qAA=qAAApAAA
=AAA(A\AAAzAGA(AzA
=A(AA=qAAffA
AApAAAGA33A\)A{A{A
=AAGA(AzA\AAzA(AzAAAA(AAffAGAQAA
AffA\)AA
A
AA
=A=qA{A\AQAAA\)AAAAA\A\)AAA
A{A(A{AAAAA33AGAAHAA  AA=qA  AAAAAAffAAHAA
=AA\)A  A{AzApAAAAAAHA
AAA  A=qARA=qA33AA\AHApA(A¸RA£AA
=AGAÅAA(A(A(A(A  A  AîAApApA
=AHAÅA33AA  AzAffA
AĸRAffAzA(A(A
AîAAÅAîAGAÅA\)A\)AAAQA=qAA(AffApA\ARA
=A(AA{A\A
A(AApAzAAA\)A
A(A
A\AAAHA{ApAAAA33AApAQAAAffAAA  AzA(A(A\)AffAA
=AŅApAřAŅAŮAŅAŮAAŅAřAřAAŅApAGAAĸRAAAffAA
AAGAÙA
=A
=AŅA\)AřAŮAŮAŅAŅAA
=AHA=qAHAffAAģA
=Aď\AHAÙAÅAAģA
AÙApAHAHA
A=qA(A\AffA33ARA(A  A=qAA(AAA
=A\A  AAHAffAzAAGAGA  A{AAA\AAHA=qA=qARAA
AzAAA33A\AAzA33ApAîA{AîAÅAA¸RAGApAÅAQApA\)AHA
AÙA=qAA
AGA\AÅApA\)ApAÅAAÙAzAzA{A\AA£AA
A£AAAffA¸RAAA=qA\A¸RAAîAAAÅAApA(AGA(AAAAAAA=qAA
AGAA33AApA
A(ApA
A{AA(A
AA=qA
=AAApAAA\AA  AQAHAQAGA\)AffARAHAAQAAAAQAzARA33A
=A
=ARAQA  A  A
=AA(AAA=qAA
A{A\)AA
ARAffAQA{AHAHA\A=qAzA=qA\A{A  AzAAAGAA{A  AAARA{AHA  AAA=qAQA=qARAAAA{A=qAARAzAAzAA33AAApA{AA\)AffApAA
A{A
A
A(AA(A  A\A=qA
A  AffAffA(AHAzA=qA{ApA  A33A=qA
=AffA(A{A{A\A{AA(AQA\A\A\AARARA
A=qAAA(AAGA
=A=qAffAAzARAARAA(AzAAA  AHAGA  AA
AAAA33A=qAApAAApAQARAA
=AA\A(AAffAARAAffA\AAA
=ARApARAAzAAffAAAAAA33A
=AffAA  ARA  A{A(A(AA\)AzA¸RAA¸RA£AffA\A33A\)AA¸RAzA\)AGAGAAÙAAGAffAA
A
=AGAGAAffAApApA(A  A
=A
=A\AA
=A\)AA
A{A{AA
AAAQA(A=qA(ApAA(AHAGA\)ARA(AAAGA{AA\AGAA  A(AAHA=qA=qAA  A
=AffA  A
AA  AHA33A(AAAAAHAA  AAQA
=AA  A=qA=qAffAffA  AA
ApAzAQA
=AARAffAARAApAGAA\)AAHAAARApAA\A\A\)AAHA\)A  AQAA{AffA(A\)A\)A
A\)AA  A{A{A
=AA(A33A
=AffA{A(A(ARAARA\A
A=qAGA\)A33A
AzA
AAGAHAGA=qAAHA(A(AAQAAGAGAA{A33ApA
=AApA=qARApApAAA
=A(AGAAHA(AA
=AApAAA(ARAAGApAffAA=qAGA{AA
A\)AHAzAQAAAA  AA(A
AzAApAAA=qApAA(AAAzA(AA{A(AA
AffApA
A
AA=qAA  AzAARAGAA\AAAARAA(AffAAHAGAAA{AffAAAGAAA{AQA  A
A{A{AHAA33A{A\AA33AzA
A{ARAAAA{A=qAzAQAAA
=AAA
=AffA33AHA
=A\)ARAAA=qA  AAffAA
A\A\)AzA
AA=qA{AA33AA  A
AApA(A\)A\)A\)A\)AA  A{A=qAAHAA=qAA  ApAQAQA(AAAGA33A  A=qApAAzA{A\AHA\AffAAAAGA{AA{A
=AA(AAQAAAAffAAQAffAffAAA(AQARAAffAGA=qAQAAffAGAffAzA  A
A\)AAQAGARAA\A33AA  A\)AffAAAAA(A\AQAHAffAA  A\A{AA{A33A\)ApAGARA\AQAA(A33AAA=qA\A33AA(AAQA(A
=A
=AGA  AQApAffAAGApA\)AAffA
=AAA\)AA33A
=AAAAAARAA33AAAAzA33ApA
=AAAAAHARAAA(ApAHApAAAAAAA{AzA{AzA
=ApAAffAA
=AGA  AAHA
=AQAHA
=AQA{A
AAAHAzARAGApAAAAA
=ApAGAffA\)ApAffA\)AQA\)AffAHAffARA
=AGAAAQAzAzAA=qApAQA=qA\)AAA{AzAHAQAHAAAARAA
A  AAA{AQA
AQA\ARAHA\)AHA(AAzARAGA{A\)A(AHA33AffAQA(AAzAGAGARAAAA33AHA33AA\AzAA\AQAAA\)A33A\)A
=AzAAGAA(AGAffAA
=A
=AAzA
A  AA(A\A\AA
AA=qA
=AAzAQAzA
=AAA{A
AAA\)AAA\AA(AGA  AA=qAA{A
=ARAQAQAAAAffARARAAAzAffAGAA\AA=qAAAAA(AGA(A
=ARA33A33A(AGA\AHAA\)ARAAffA{AA
AAAA
A  AHA{AGAffARA
A  ApAAAAQAAApAAAAApAApAQAAA=qAffAAzAHAAAGApA\A(AA33A
AAA=qARA=qAAA(A{ARAQA(A(AAGAĸRAGAîAÙA=qAHA33A  AffA33A  AA
A\AAA33AzA\AA\AHA
AAAGApAAAffAARA=qA{AQA(A{AA
A\)AA
=ARAHAAA33A\)ARAQAAARA  A=qAA\)AA
A\)AApA
=AARA
A=qApAffA
AAAApAAffAHA
AA  AGAA{ApA=qAGAzA(AAAAA\A
ApA{A=qAAHA(AffA(A=qAzARARAAAzA
=AAAHAzAAA\ARAAA\)AA\AQA(AA\)AHA
AAAAffApAHAAzA
AffARAHAzAAAAAA=qA\)ARA\)A\AQARAA33AA
AAAzApAA  AA\)AAffAGA  AA\AA
=AA\)AQAAAA\)AAAAA(AA\A(ARA\AffARAAffAA
=AAAHA=qAApAffA(A(A  ARAA=qAHAAAA  AAAAHAAA
ApA\)AAA
=A\AA
=A
=A{A{A\AAA  AApAQAA  A\A  AHAAAA(A  AAAAAAA  A(AA\)A(A\AAAAGA
=AA{ApApAffAffAARA\AHAA{A{A\AffA
=AAffA=qAGAzAApAAGARAQAA(AzA  AzAA\ApAAAHA  AA
A\)A\)AAA\)ApA{A\A
=AAAAHAzA\A33ARAAffAHAAAA\AA  AAGAA
=A{AA
ApA  AA{A33A33A33AA{AA\AAAAA(AzAAAHAAHAA\AA
A=qAA=qA33AzAGAAGAARA33ApA{AHApA(AAA{A  AA
A
AAHAA
A¸RAAHAQA(AA  A
AAGAGA33ApA
A=qA\)A
ApAGAzAffA33AHAAGAQA  A  AA  AzA=qAHARAA(A33A33AA=qApARA
AHAAzAffAAAA  Aď\A
=A\)AffAA(AQAzA33AAQA33AAAHARA
A
A
A  A(AAA(A33A\)A(AAA33AƏ\AǙA{AzAA
=ApApAAGAffA  A{A\)AAQAA33A\)A  ApAffA{A
AffA=qA
A\)A33AAAÙA
=A(A
A=qAHAQAĸRAHA  A\)A  AQA
=A\)Aȏ\AȸRApA\)ApAHAzAHAAď\ApAǙAAA{AAřAzAA  AzAffAAA\)A  AȣAAAǮApAAAGAȣAzAAȣAƸRAffAǅAHAǮAzAA\)AffAȸRA  AʸRAAAGA˙AGApAAAA\)AA=qA  A{A(A
=A\)AAAzA{A33AffAɮA\)AȸRAȏ\AzAAǅAA
AǮA33AA\)A=qA=qAAǮAȏ\AzA
=AGA(AffAA
=A\)ApApA{AŮA{AAAŅApAď\AA\)AffApAģA\A
A
A33Aď\A33ApAAffAffAA{AAApA{AHAAA  ARApAA=qAGAffAHAAffAAA33AGAƸRAzApAA
A=qAAQAffA\)AHA=qA(A(A(AAAƣAƏ\A=qAGA(AA
AƏ\A¸RAAAQA  AApAAGAA\A{AîAAĸRA=qAGAzAA{AÙAĸRAGA\)A33AA¸RA
A(A
AGAA\)AAffA(AA{AAA(AA  A\)A  AGAAzA{AA\A=qA£AA  AAGAHA\AffARAA{AA33AzA{AAA33A
=AQA=qA\)A=qAAAffAAAAA=qAzAA\A\)ARAAAffA33AQA(A  A(A33ApAAď\AÅA{AA£AAffAzAQApA=qAAA(AA=qAAzAA  A  A33A\)AA33AQAGA\A{AAA33AAAzAAGAGAGA\)A(AAzA
=AzA\A(AA\)A{ApA=qAȏ\AA  AɅAɮAAAəAʣAA
AzAƏ\A33AǙA
=AAƸRA=qA33AHAQA£A33AApA
=AGA¸RA{AÅAď\AffA¸RA
A\)AA\)A33AA  AQAAA\AffAAAGAAAAA33ApAAAzAARApA\)AA
=AA\A(A  AA  AA\)AApA33A\)AA=qAAA=qA{AA
=A\A
=AARAHA(A  A33A33AQAřA{AŅAAzAARAHA
=AģA  A  AAÙAzARA33A  ApAAGAA£AA£AQAffAA
A
AA=qA33AAffAAA33AGApA\)ARAA  A\)AAA=qA=qAA£AĸRA{AQAffA{AHAAAA\)AGAAAA(ARAGA
ARA  AffAApAAQAzAA=qAGAApAAĸRAĸRA\A¸RAĸRA(AGAAA
=A
A  AzA£AAzAA\A  A£A(AÙA33ApA(AHA(AQApAď\AA=qAǮAAƏ\AAzAǅAAǮAA
AzAGA33A  AŮAƸRAAzA(AAĸRA\)AĸRAAAffAA33AAřAŅA
AGAHAApA
A33A  A(A
ApA\)AřAHA=qAŮAzAƸRA(AƸRAffA\)AÅAAAAzAGA33AAAAARAƏ\AŅAA\)Aď\AAffAƣA  AǮAAzAAzA(Ȁ\AAQApAAǅA=qAA(AAǙAzAAɅA
A(A
AA{AAA
AAffAffAAA=qA{AffAGA\)AHAHApAA(A  A{AȸRA\)AGAƣA\)ApA=qAAȏ\AApAAÅAzAAĸRAŅAA=qAƣAAffApA
A  A\)AŮA\)A33A{A\)AÅA(A
=AAGAAAď\A
AîAď\A{Aď\AA
A
A
A  AAzAQA{AA£A33A33AîA(A  A  AǮAGAĸRAîAzA  AApAď\A
=A{A=qAîAƸRApApAffAAîAA33AApA\AA{AAAzAGA  AHAQAŮAA  Aď\A
ApAĸRA\)AAA
=A\)AAŮAzAŅAřAÙA(AGAA{AAÅAÅAîAAA{A
=A  A\)A
=A{AA
=AffAAAAAAAffA(AzA
=AAARAAA=qAÅAGAGAA
AAAA{AzAȸRAffAA(A  AGAA33AAAGAAɮA(A(AHA33A(AA  AffAʣAGAȸRAɮA{AƣA
AQA
A(A  A=qA\)AAȏ\AAƏ\AGAffAȏ\AȸRA33AGA33Aȏ\A
=ApA
A{AHAǅAHA=qAAA(A(AAHAffAApAHAQAǅA33Aȏ\A
=AzAȣAAɅAGAǮA33ApAAAřAA
AɮAQAffAApApA(A
=A{A=qA33AA
=AAA˅ẠA=qA{AHA=qA
=AffȀ\AffAHA̸RAzA(AQAffA
A͙A͙A͙A(AAAǅAffAHAA(A\)AŮAGA͙AͮAGAAAGAəAȏ\A{AAȏ\AȣA(AAAffA
AA(AQAHAɅAʸRA
AəA(AəAʏ\ApApAA(AîA  A{AHA\)A{AzA\)A
AA{A=qAzAɅA(AAˮȀ\A
=AAffA  AAzAHA=qAȀ\A
A˙AɅAɮA(ApAApA(A̸RAAAˮAA
ApAA{A\)A33AHAA
=AffA{AffAffAQA  A(AAȣAGAA\)AHAA33AffAffAzA  AGAA33ApAʣA  AQAGAAffAHAGAģAGAǮA(AHA  A\)AHA(A(A£AA  AffAAffARA
AA(AGA33A
A=qA33AA\)A{Aď\AĸRAHAģA(AřA  AǙAƸRAAģAď\AAA{AŮAffAģA
=AGAAAHA33AŅAģA(A(AAA
A  ApA(AǮA  AAƏ\AHAǙA
AAǮA
AHA33AAƣA
AA{A=qA
=A(AzA¸RAGAzApA\)ARAAAA33A
=AAA\)A  A=qA(AîAQA  A\A
=A£AffA\AffARAA{AŅA=qA¸RA  AģAQAŅApAřA\)A\)AǮAzAzA33AAzAGA(AAřApA(A(AƸRAAGAA\)A\)Aȏ\A=qA
AǮAǙAǅAǙAApAA33A33AAA
=AHAƸRAQA
AřA{A=qA
AƸRA=qApA  A\)AAîA=qAÙAÙA  A
=Aď\AA
=A{A¸RAA{AGA
AAAAÅAAzAQAŮAď\A=qAģA{A  A=qAÅAA
A\)A{AA
=A=qA(AÙA¸RA  A£A{A(A¸RAAffAHAƣApA(A\A¸RA\)AHAffA\)AGAA  A
AǅAǅAAȣAAHA=qAffAHAA
=AAĸRAŮAAHAǙAA33AQAA
=A¸RAÅA33A¸RA=qAAGAAA£A(AGAA\)AGAA=qA\)AAAffA\)A33AzAA
=AAGA\AA\)AffAA  AGAzAA{AAAHA
=AHARAAffA\AApA(AAzA  AA
=A=qAA
=A=qAA
A¸RAA{A=qAHA  AîA  A=qAffAHAŅA=qAQAƣA  AAȣAAɮAA
AHA=qA{AA  A
AA33A  AApAAQA=qAHAA\)AǅAǮAA\)A
AA
ApA{AQA=qAGA(AGApAģA{AƏ\A
=AAď\A\AřAď\AGA33ApA  A\)A33AÙAď\AAAzA\AA
AA(A£A33AŮAď\A
AŮAAAAƣA=qAƏ\AƏ\AÙAQAAA
A{A(A  A=qAŅA=qAA
AQAȣAȣAAɮA
AGAffAzA
AHAAȸRAǙAA
=AAƣAAAA=qA{ApA  AA=qAA(A=qAQAffAȣAA(AQA  AGAAAHAzAA(AAA
A
AɮAAģAď\AA{AǅAŮAAAffA\)A{Aď\A(AģA{AA(A  AAQAAQA{AAAƏ\AAA  AǙAǙAƸRAAQAÙA
A(A33A(Aď\AAƏ\AGAQAHAɅA=qA{A\)AˮA
A˙A(AQA=qAAzAAAffA\)ẠAzA
AffA
AGAˮA\)A
AAApAƸRApA
=AǙA33AAƏ\AƸRAzAAzAGAƸRA\)A(ApA{AffA{AAŅAřA(AƣA\)A  AA{AîAĸRA  AQAffAď\AffA=qApA
AffA=qA  ApA33A(A¸RAAffA33AQAGAĸRAď\AzA(A{AHApA
AȣAȸRAȣAȣAȣAzAffAȸRAȏ\A(AQA
A{AAAHAǙA{A=qAȏ\AHAGA{AHAȏ\A  AAǅAAƸRAAAƏ\ApAA33AA
=AƏ\AA=qA  A(AQAƣAHAAƏ\A=qA  ApA  A
AAĸRAzA=qA\A\A{A\A  AQAAAAffAHA£AA
AffA=qA£A\AGA
A\AAzAA{AÙAAAffAAAAǮAAǅApA
=AǮA33AǅAAA{AA\)AGAA
=AAGAGA\)AA33A
=A
=A
=AHAAAHA33AA\)AƏ\AƸRAƣAƏ\AAƏ\AffAffAA=qAƏ\AƏ\A(AffAŅAAffAQA(A(ApA33A33AAffA¸RAApAAGA\AHAGAAAffA  A
A(ApAHA(A(AAA(AAÙA33AÅAAzAffAA\)AHAAAA{A
A
=A(A  ApA\AAÙAÙA
AA33A33AHAƣAffA{AQAffAA{A{AǙAQA(AQAQAAǅA\)AGA33AAA(A{AA  AřA  A
AGAģA{A33AA{A{AHA
=A=qAQA¸RA¸RA
A=qA(AAAHAA
=AA
=AzAA
=AA=qA\)AAÅA  AîAÅAAGA=qA£AGAÅA¸RAA£A£AAHA(AAA=qAA(AÙAGA  AzAģA\)A  A{AQAƏ\A
=ApA\)A
=AA33ApAǮAA{A{A
AAAǅAAffAffA
AŮAApA
=AHAAAHAA33ApAffA\)AA
=AffAȏ\AȸRAffA
=AffAƸRAŮApAGApA=qAffAAǙAA
=A33AAǮAA
=AŮA=qAffAQAAGA(A  AzA{AģA  A=qA
A{AffA=qAîAA(AƸRAAŅA33A33AƸRA
A(AǙAA33ApAAAGAĸRAŅAA=qAAGAAzAA\)ApAɮA  AffAHAʸRAA˙A
A˙AA˙A\)AGAGA˅A33AAHAHAˮA˅A˅ApA  AAAˮAA  AffAAAAəA(AəA
=AHAGA{AffA(AGAɅAAAzA
=AzAffA  AǮA33A(AAAA
=A{AHAĸRAffAÅAGAAGAƏ\A
=AǅAǙAƏ\A(A=qAHA
=AAApAA
=A
AȣA  AA˅A(ApA(A
AA
=A33A=qA{AffA=qAzAffAzA  ApA
AApApA\)AAQA  A͙A\)A33AHApȀ\ApA͙AͮA(A
A=qA{A33AAzẠȀ\AQA̸RA33AGA̸RA33AHA̸RAHAffA{A{AɮAQA{A(A
A
AAəA33AɅA\)A(AGAA  AffA  ApA  A=qAQAffAzAʏ\AʸRAAƸRA
=A
AĸRAffApAîA
AģA33A  A=qA33A
AzAA33A
=AˮA=qAGAA\)AQAQAΏ\AθRAΣAθRAυAϮApAAzA(A{AQA
=A
=AzẠAQAAʣAʏ\A  A33AA
AͅApAAA33AΏ\A\)AϙA(AAAAHA
=AAͅAQAʣAƣAA
A=qApAɅA
AAHAǅAAɮAʣAA=qA=qAApAřApAģA
AA{AA{AGAGA
AA\A
A\AQAQAA33A  A£A{A=qAA
AffAHAApAǮA  AQAHAGAəA
AffAʸRAHAAA
=AA˅AHA=qA˙A
=A
=A
=A(A
A
A=qA(AQAA˅AHA
AͮAA
A=qAA=qAzAA  ApAzApA
AzAˮA{AəAǮA̸RAHAA\)AApA
=AHAAȸRAƣAA£A(A\)AŅApAAQAGAffAAQARAA  AAA\AQA
AA{A(AHAA£AHA
AAAffAHApA(A
=A=qAȣAAAʣAʏ\AA
AA(A̸RAAͅA33A
ApA\)AHAˮAffAɅAAGAɅAQAɮA\)AGAɅAzAɅA
=AAȣAzAffAȏ\AAȸRAA
A(A\)A=qA(AffA(AzAffAApAQȀ\AɅAzAAA(AzAGAQA
=AAAƸRAQAHAGA{AʣAQApA(A=qAǙAQAHAAzA=qAQApAzA(AAǮA
ApAƸRAəAʏ\Aʏ\AQA=qA̸RAzAHAGA
A͙A{A
AA=qAQAzAzAθRAΣAΣA  AΏ\AΣA(AzAQAffA33A\)AGAHAϙAΏ\AzAΏ\AθRA
=ApAGAHAΏ\AffAΏ\AΏ\AΏ\AzAffAQAffAHAΏ\A{AͅA{A˙A  ẠA̸RAGA̸RAQA33AA=qA(AˮAAHAʏ\AɅA  AA˙A˙AA{AAHA33A˅A\)AGA˙AApAA=qAΏ\A33A͙AΏ\AθRAθRAͮA  AApAΣAѮAУAЏ\A(AЏ\AиRAѮA\)A
A
AљAљAGAиRA{A  AиRAAffA\)AӅAA\)AGA
=AAңAAхAA(A  AQAϙA(AHAzApAHAHA\)AљAAхApAGA\)AхAA\)AAGAGAHA(AͮAA\)AͮAQAAA̸RA˙AA
=A(A
=AGAɅApAApAAA͙A
AA  AQAʸRA33A
A{AHAAAΏ\ApAϮAAHA=qAzA  A
AAQAA
AAAHAGAѮA{A{A
=AЏ\A(A(A
AϮAA
A\)AGAffAAA
=AͅAHAffA=qAffA˅A
=AHA33AHAAȏ\AQAɅAʣA33AAffAA˅A  Aʏ\AHAɮA=qA
=A\)A{A
AzA˙A\)AAA  A(A
AGA˙AAHAˮAffA
Aʏ\A˙AɅAʏ\AHAƣAAA\)A(A\)AA\)A{AȸRAď\A  AîAA
AřApA=qA{AQApAʸRAȀ\A33Ȁ\A˅AAͮA
AΏ\AυA\)A
A=qAQAAAA33A
=AffAHAHAAHA
=AA
=AиRA(A{A=qAA
=AЏ\AffAиRAиRAAAУAQAQAzAЏ\AffAAHAGAиRA  AHAGAQAϮAApApAΏ\AQA̸RAzA{A  AɮA=qA  AɮȀ\AˮA
=Aʏ\A\)AAffAzA(AˮA  AHAffAˮAͮAzAHA
Ȁ\AAAHAəAẠAʸRAǮAA{AQAHA(AA{AAˮA\)AGAəAAAʏ\AffA̸RAA33A
=ApAGAffAA=qAffAAA33AA
=AffAffApAA{AAʣAffAA
=AAAAGAA  AʸRA̸RAʏ\A
AffA
AͮAAApA(AʸRA{AAHAƣAzAŮA33AzAAîAÅApAAÅA  A
=AřAAAA\)A
AƸRAAAȏ\A\)A{A33A\)ApA\)AəA(A=qA=qAAGAˮA(AzAAͅA  A=qAffAΣAΣA33A\)AϙAAQAиRAиRA  AGAGAЏ\AУAGAиRAУAЏ\A
=AffA{A
A(A{AGAΏ\AΏ\AHAAGApAϙAA=qAͅAGA{AͮAffA(A
AͮAͮA  A  AˮA(A(A͙A33A=qAffAA
AAЏ\AQA{A=qAA\)AAHA
=A  AθRAzẠApAGAΏ\A(AΏ\AA˅A  A
AͅAffAHAffApAA
=A33Ȁ\A̸RApA
AA{AzAAA  AQAAAҏ\AAGA\)AӮAA(A(A  AAәAәAAAAHAffAQA(AAљA=qAQAA(AA33AA33AGA33A
=AӅAGA33AHAAѮAzAQAzAA
=AA
AzA33AQAӮA(AҸRA  AA{AӮAӮA
=AAҏ\AHAAҸRAҸRAHA(AHApA
AҸRA33ApA
=AAAAҏ\AffAAAQA(A(AGAzA33A=qApAHAA{AљAAApAApA  A֣A
=A
=AHA33A
=AffA  AAQA֏\A֣AQA=qAQAAծA
AAծAԣAGAAԸRAәAAңAAA33A33AGAAGAGA=qA֣AׅAA
=A
=AffAңA  A
=AAHAЏ\AApAffA=qA
=A{AzAAHAAҏ\AУAAиRAGApAAΏ\A{A33AЏ\AɮAAȸRAƏ\AffAQA(AAHA
=A˙AAffAGA33A(AAϮAΣAθRAA  AA  AAGA
=ApAυAA\)AиRAzAAffAzAHAљAAңA\)AHA(ApA\)AAхA(A33AѮApA
AA(A(A(A{AzA=qAѮA
=AGA=qAиRAυAGAGAиRAzAУAGAzAЏ\AиRA
=A\)AθRAGAA=qA33AQAQAΏ\AGA(AHApA
=AAzA
=AGA\)ApAGAͅAffA  A{AffAΣAAAQAQAzA=qẠA
=AͮAA\)A  A̸RAHA  AAGA\)AAffA33A
=AҸRAәAHA
=A
AծA\)AHA(AA
A
A(A(A{AA
A
A
A
AӮAәApA\)AӅAA{A(ApA\)A
=AӅAԣAAGAAиRAA=qAffAffAGA
=A33A(A33A{AAAхAGA\)AGAHA  AљA
AиRA
A=qA\)AQA
AѮA
AffApAGA{A(A33AGA
=A̸RAAAA{ApAAΏ\AApA˅A33A  A=qAzA=qA=qAȸRA
=A  ApA̸RAGẠȀ\A̸RẠA  AzA̸RA33A33AGApAͮA͙AͅA\)AGAA
=AGAQAQApA{AͅA
AA=qApA
AA
=AGA
=AHA(AЏ\AzA=qAθRAA=qAffAυAиRA  AυA
=A
ApA
AGAͮAA
A  A˅AAGA͙AApAA˙A(A
=AAGA33A
=A
A˅AɅA{AA(A
AHAHȀ\A\)AʣA  AQAɅAHA  AGAΣA(AУAGA33AхAѮA
A  AQAHA33A\)A(AffAAңAAAHA33AңA=qAffAzAQA(AffAҏ\A(A(AAffA33AAAAA33A
AGA(AHAGA(A  A͙AA{A{A(AA=qAffAffA(AA(A{A  AɅAGAʏ\A\)Aʏ\AɅAA˅AzAA
AAA\)A  ApA
=ApAΏ\AϙAAAΏ\A(AѮApAHA{A(AAA
=AzA
AϙAffAzAHAљA  A(AңA\)ApA\)AAAA
=A33AGAGAAAAAҏ\A\)AҸRAңAQAңAzA(A(A  A
AљA
A{AAA
AљA\)AхAәAA
AҸRAA(A{A  A=qAzA(A  AљA  A\)ApA=qAffAA=qAQAffAAGAΏ\A̸RA
=AAA=qA˅AͮAffẠApAΣA33AAQA{AffA̸RA33A=qAAͮAGAͅA˅A˅A˅A(AQȀ\A͙AA{AHA33AυA
A=qAQA=qAA=qA\)A  AffA33Aҏ\AҸRAHA33A{A{AGAGA  Aҏ\A=qAffAQAffA{A
AGAA33AAЏ\ApAHA33A\)AGAGA\)AхApApAA\)AGApApAѮAхA  AѮApAA=qA{AHAAHA{AffA33A{A˙AffA
AǙA\)AffAHAɮAA˙A(AAHA\)AGẠA  AA̸RȀ\A{A˙A=qA
AffA̸RAGApA(AθRAυA(AAхAѮAA  A
=AA  AGAAGAAҸRA=qAffAңA{ApA(A33A\)AffAҏ\AHAҏ\AzAzAzAAGAӅAәA{A{AAHAAAGAҸRAGAAA\)AәA\)AAAҸRAA{AѮAQAAA
A
=ApAffAAQA{AA  A(AGA33A
A33AΏ\A=qAzAAHAGApAHAHAffAθRAA(A\)A33A\)AzAzA{AAzA̸RAʣAQAɮAA=qAffAAA=qA̸RA̸RAHAHA
=AGAGApAͅAͅAͮAQAffAffAffA
A(AQAzAHAAϙAͅA\)AθRAͮAA  AA{Ȁ\AAAHA\)A33A33AAQA  AAǮAzA\)AəA
A˙A\)A̸RA̸RA
=A
A  AA=qA(A{AA33AHA
=AA
=AGAAAzAffAAΣẠA33A
A33AGAəAʏ\AƣA(AQAǙAʣA
AGAϮAQA(AffAθRA{A
AffA(ApAAApAԸRAՅApAzAApAA  A=qAzAظRA  AڸRAzA  A(AAڏ\AffAڏ\ApA(AٮAAׅAׅAA(A
AՙAAӮAәA
A
Aҏ\AHAAzAffAHApAHAffAљAAGAӅAQAAAAӅA33AңAA{AAхAҏ\AAAzAAAAӅA
ApAәA
AӮAӮA
Aԏ\A=qAHAHAՅAՙA
AՙAGA33A(A=qAљAffAAAѮA
AQAAGAApAA\)A33AәAzA(AHAQAffA֏\AׅA֏\AָRAA  A{AzAGApAՙA\)A
A\)AӮAQAffAzA  A  AzAA(AңA{AzA
=ApAAҸRAffA  AңAAQA33A
A\)A{A(A  AAAAҏ\AzAHAAGAхAzAQAA(A33AУAиRA33AAAљA\)AхAAGAGAЏ\A=qA{AzAApAѮAљAffAхA33AA
A\)AGAA{AHA\)ApA{A  A
AApA  AffAHAA
=AAϮAzAУA(AA
=A=qAAиRAffAиRA(A  AQApAA
A
=AљA\)AѮAffA
AA(AHA
AGAffAAңAAҏ\A
=A\)AҸRAәAәAAӮAAӮAӮAA{A{AQA{AΏ\AʸRA\)AA\)AхAϮAA  A
=AzA  AHAңApAҏ\AQAffAzAҏ\AGAzA
AΣAffAљA(AҸRAffAQAӅA{AA
AָRA=qAffA  AAծA33AQAffA֏\AָRAAA\)A֏\A=qAיA֏\AQA33AAљAAGAՙA{AԣAffApAzA  A33AӅAAӅA(ApA\)ApA(A
=AAA=qA33AиRAzAAθRAAθRApAAGA33AAΏ\AΏ\A(A͙A=qA(A˙ApA˅ApA͙AGA˅A=qAApAffAхA=qAθRA  AzAAGA(AAHAGApAӅAffAAԣA
=A{AAA؏\AHAظRAAأAظRAzAHAAAGApA
AۙApAGAAڸRAzAۅApAGA33AAA
=AأAأAأAأAzAAzApAAAAA{AAzA=qA  AzAHAԏ\AQApAAЏ\A{A\)AϮAGAA=qAHAffApA=qAA
AẠAA̸RA͙AffAAzAHA  A  AAȀ\AA(A33A(A
AƏ\AA
AA\)AQA(A\)AQA{AGA{AHA˅ApA{AA̸RAθRA\)A33AAGAA
AGAAAzAУAA
=AθRAAѮAхAѮAHA\)ApA
=ApAΏ\Ȁ\AͮA33A\)AAAAffAΏ\AϮAffAΏ\AѮAхAQAљAθRA(A=qAAHA
A
=A(AAHA{A
A{AΏ\AQA\)AAA=qA{AffA{A(AυAffA(A{A=qA
AɮAȸRAǙA=qAəAAApAzA
=AA  AͮAAffAGAAA=qApAӮAzAAGA\)A
AՅAAApAA  AA
A
A{A(AծApApApAAAzAԸRA{AAAApA
=AA
=AzA=qA  A
A  A
A
AA\)AQA(AApAљA\)AAAAͅAAͮA
=AAAυAϙA33ApAffA(A͙A
AʸRA
A(A
=A\)ApAA(AGA
=AffAʸRAHA˙A{A(AGA33AHAˮA\)AʸRAʏ\A  AQAʸRA  ApApAǙA{ApA{A{AȣAzA{AQAGAHApAAΣAA
AGApAQApAHA
=Ȁ\AͮAͅAA̸RAGẠAHAffAAAAAGAGAA͙A\)AA
A(AͮApA33A
AͮA(A
A=qAƸRAQAffA
=AθRAAzAͅAzAA  A{A(AəAʣAAQAɮA(AɅAɅAɮAQAffAʣAzA
=AAA
=AA33ApAƣAA33A  AȸRA=qAA{A=qAQAA\)A=qAzA
=AAŮAGA33A
=A̸RAQAHA  A
=AGAA{AHAGA
AA˅A
AffAzAA  A{AGȀ\AApApAGAA͙A
A  A͙A
A{AAAͅAHA\)ApAAQAA˙AA
=AʸRAHAA˅AzA˙A(Aʏ\A\)A\)A33AɮAApAɅA(A33ApAQAffAA
A
AA(AHAHAGAƸRApAA=qA
AGA\)AzAʣAʏ\A
A
AˮA{AAGA33AʸRAHA33AȀ\Ȁ\AffA{Ȁ\A̸RAzA̸RAA
=AAHAAͮAA  AQAQAffAΏ\AffAffAΏ\AAHAA33A\)AυAϮA{AzAQAA
=A
=AHAA
=ApAffAθRAQA
AAA
AAffAA
A̸RA
=AQA  A  A33AȣAAǙAA  A(AɮAAGA
A  AQApA
AɮA
AAʸRAʣAAffAzA
=AzAHAθRAQA33A33A\)AˮA˙A=qAA
A=qA
=ApAGAAAϮA\)AA33AϮA
A33A  AQAAЏ\A(A  A  AAAAυAϙAGAυAυAA  A{AA  A{A  AAυAAϙApAυApAϙA33A\)A
=A(AGAθRAA=qA  A=qAA{AʣAffAͮAGAͅApA=qA  A{A=qAzAQAzAΣA  AQAΏ\A  A
=AffAHAAAθRAϙAϙAAA(A{AQAffẠAAGA\)A{A  AQAAΣAA33AυA  A=qAAAGAљA  AQAңAәA  AzAAA  AAՙAԏ\Aԏ\A33AQAffAzAծA
A=qA{AQA(AQA=qA\)AGAԸRA=qAAԏ\AԸRAQA
AAԣA\)AAӅA
ApAљAAA
=A(Aҏ\A  A\)A\)ApAGA\)AAхAѮA{A(AffAffA(Aҏ\AQAzA33A(A=qAҏ\AAGAAҸRAAApA\)AәAӅAApA=qAԏ\AԸRA
=AHA
=AA\)A  AA
=AՙAA  AՙAՅA(AffAQA
=AAffAAأAٮAٙAA=qApA33A\)A\)AA33AffAAAffA=qAAAffA
AָRAzA׮AHA{A{A֣AAzA֣A  A(AzA׮A=qA=qAApAA(AԣA
=AGA  A=qAzAԸRAGA\)Aԏ\AA\)AA
AAAAәA\)AGApApA
AԣAA\)AQAҏ\A(AυAGAՙAAՙAzA\)AA
A֏\AGAיA(AAA
AA{Aڏ\AڸRAHAڸRAffAGA؏\AׅA{A
ApAׅAׅA
=AAՙApAffAA(A
A=qA=qAA\)A(AffA=qAHA
=AхA  AffAzA  Aҏ\AA=qA  AHA(AAAHAAffAQA\)AA׮AzAzA\)AGAAAGAׅAQAAGAffA
=A֣AՅAәAAHAQA
=AA
=A33AApAzAָRAzA\)A\)A
A  A(A{AA33AԸRAՅA֣AׅA=qAظRAAظRAA(AAۅAAۮAzA(A(A=qAܣAܣAHA33AAApA
A\)A
A{A(A܏\A{AۮA\)AAAffAAGA܏\AAAAGAAQAAA{A=qAHAܣAܸRAzAܣA܏\AzApAQAHApAApA33A=qA
A
A
=AQAٙAGA
AAffAffA؏\A׮AHApAٮAA
A  AA(AffAffAzA=qAڣAAAۙA\)AQAQAGA݅AApA  A܏\A
=AA=qAܸRAܸRA\)AAGA߮AQAffAGAHA\A߮A
AQA\A=qAffAAARAffAᙚAApAAݙA߅AA
AݙApA\)A
=A܏\AGAAAݮA
ApA
A
=Aڏ\ApAأAAAQAzA
=ApA33A؏\A
A{AGAA{A(A{AڸRAzAzAAGA
=AظRA=qA(AApA(A  A  AAݙA=qA
=A\)AGAAA׮A
A\)AAHA33AA
=A33AݙA=qA=qAA{A=qA
=A{A
AA\)A{ARApApAAAQAߙAARAAAAAAᙚAA
AA
AHAffA(A
=A\AA  A߅AAA߅ApAQAzAAGAA܏\AAAA  AzA33A(A=qA\)AffAٮAܣAڣApAffA\)AٙAffAڏ\AA
AQAA݅AffAA\)AzAܸRA
=A\)A܏\A܏\A
=AAGAzAQAڣAAڣA
=Aڏ\ApAQA  A݅AޣA޸RA=qAHA߅AA{A=qAQA=qA=qA  AAffAHAQA
A33AAAAHA
=AzAAAAApA߅A
=AA{AۅAݙApAܣAAܸRAzA{AܸRAܸRAܸRA܏\A=qA(AffAffA  A(A
ApAۅAٮA(AAظRA33A
=AA  AApAأAA(A(A׮AA(AҸRA
A؏\AQAA=qAQAڸRA(AHA\)A(AQAظRA=qAA\)AAHAAأAffA\)A
A(AәA33A  AAAGA=qA
=AمAٙA{A  A=qAQAAA
=A
=A=qAڣA=qA(A  AHA{AڣA
=A\)AA\)AGA{A(ApAffA\)A=qA{AѮAGA=qAA33A33AAԏ\A
AHAΣA
AҸRA=qAAѮAA
AApA{AffAΣAffAzA{A͙A\)AHAθRA  A=qAA\)A  AAAљAљA
A(AGAffAAGA(A33A
AхA{AA=qAA˅ApAʸRAA̸RA˅A
=AAGAʏ\AAɅAAAQA
=ApAAУA\)A=qAHAAAAAAҸRA(AffAffAAхA\)AЏ\AffAхA\)AљA  AхApAffA
A(AAљAͅAApA=qAGApAA(A
=A  A(AAAϙA{AA33AA33AΏ\AGA  AA
AA
=AzAͮAθRAHA{AGA\)AzAΣA  AυAGAApA33AAzA  A{A̸RA͙AzA=qAzAA
AQAAхA=qAңA33AA  AzAAՅA
AA؏\A33AGAApAffAffAGAAGAׅApAׅAA֏\AzA
A\)A
=AGA  AAՙA\)AzApA{A{AѮA
=A=qApA33AңAљAQAҏ\A  AљA{AAAQA=qAәAQAљAQA{A(ApA  AAHAGA(A{A
A͙AAffȀ\AGA33AzAƸRAQAGAΣApAAHAҏ\AAAQA=qApA33AAҏ\AҸRAAҏ\AAzAҏ\AHAҏ\Aҏ\A\)A\)Aҏ\A=qAѮA  AңAA
=A\)AGAA  A{A  AӮAAHA  AQAA
=AApAA=qAѮAѮA  Aҏ\A(AΣAGAffA{AHA  AGAA(AffAΣApA
AAGA33ApAхA  AQAиRAЏ\AHA(AA33AGAӮAA
A=qAԏ\A(A{A{A=qA{A{A{A(AӅA\)AңAzA{A͙A{AͅAAəAHAͅAAQAzAHAA̸RA=qAͅAA(A=qAAHA
=A
=AϮAQAzAHAHAzA(AҸRA=qA  A=qA(AzAңAHA
=AGAGA\)A33A
=Aҏ\AzA(A{A(A=qA
AHAЏ\AѮAѮAGA{A33A
AQAQA=qA  AυA=qAΣAHAA=qAApA=qAQAzA\)A  AиRAУA=qAиRAAAѮAљA33AҸRAffA
=A\)AΣA\)A33A33AGA
A
A=qAAθRAHA(AθRAGAϙApAϮA
AApApA(AиRAApAхAљAAҏ\AAңAҸRAA\)A
A
A=qAffAԣAԏ\AApApApAAGAGAA{AffA\)AӮAӅAA33AңA  AѮAGAAͮA\)A{AffAGA  AѮA=qAHAffAQAffA
=AzAԸRAAGAՅApAՅAՅA33AԣAQAA33AӅAAՅAA33AՙA
=AffAAGAffAHAңAѮAA
AAA
A
=A{A  AυAυA
AzAGAGA33ApA\)AѮA33AѮAffAQA  ApApA=qAϙAAΏ\A
A33AGAΏ\AљAHA̸RAGA=qAffA
AQAGAzAѮAҸRAGA{A=qAӮA(A(AԣAGAӮAԏ\AԸRAHApAΣAffAGAAΏ\AA(A
AϙA{AQAУAHAA{AӅAffA\)A
A  A{A
AՙA
AՙAՅA\)Aԏ\A  A{AָRA33AׅA
=A
=AׅA(AAA(A  A
A׮ApA
=AָRAAAָRAָRAGAAffAՅA=qAGAHAGAAԏ\AzAGA
AԸRAffAffAzAУAAffAGAA(AϮAϙAQA
A=qA{AffApA
=AхAҏ\A  A
ApAQAQA
ApAͮA(A  Ȁ\AˮAzAA\)AHAA
=AffA33A
AAҸRAA(A\)A
=A  AAAAAHAA=qA=qA=qAәAAHAҸRAҸRAңAA\)A(AzAGAՅAAffA֏\AAGApAיA
AA33AHAGAffA֏\A
=AծAԸRAӅAAљAЏ\ApAzAυA=qAAAԸRAAHAAffA
=A  AGA\)AͮAЏ\AиRAzAA͙AAAхA=qA{A{A
=A=qAHAиRAЏ\AљA
A
AA  A=qAAAAHAAA
=A\)AA\)AӅA
AA33AzAHAffAffAffAҸRAͅA
=A=qA\)AѮAA(AΏ\AAzAθRAA{ẠAGAA{AGAΏ\AϙA
A{AЏ\A33ApA
AzAAAAҸRAҏ\Aҏ\AAҸRAҸRA33AGA\)AA
=A
=A
=AAHAҸRAAAAAAҸRAAңAAAA=qAҏ\Aҏ\A
=AA=qAzAϙAУA\)AAGAffAzAAzA͙A=qA\)AAQAA33AϮAA  A{AиRAAAхApApA33AAAA{AA33A\)A
=AGA
=AиRAУA(A
ApAϙAθRAAffA33AzȀ\ẠAHAAGApAA(AffAHA\)AυAυAЏ\A
=AAиRA
=AAиRAиRAHAA
=AA
=A
=A
=A
A(A
A=qAffAңA
=AҸRAHA
=A(A=qApAAA
=AA˙AQA(AA\)A(AϮA{AAģA  AA  AӮAңAzA{AAAGAЏ\AЏ\AΣAΣA\)AЏ\AAAυAθRAAGAffAυAѮAffAAffAAA
AΣAAУA
=A
=AQA=qA  AAəA
A˙AˮA=qAAffAffAAHA33A̸RAAΏ\A˅AͮȀ\A˙Ȁ\A̸RA\)AHAHAʣA
A=qAffAffAGA33A33AAzA˅A
=A=qAffAA
AʸRAˮAA33AGAAHA=qAA
Aҏ\AApAәAәAA  A{A(AA  ApAAGAA33AGA33AҸRAA=qAѮA
AffAHAңAҸRAңAңAA  A
A=qAA(A  A\)AAиRAA(AЏ\AffAQAGA
=AffAΣA
A\)ApA=qAGAͅA(AffAA=qA
A
=AΏ\AAΏ\AGAAQAzAffAzAQAʏ\AA(A˅AˮA˅A33AAQAGAGAA{A(AͮAAA
=AAGA  AˮA=qAA=qAΣAυAЏ\AQAGAHApA(A\)AA
=A=qA
A{AAA\)A
=A֏\AA\)AA
AӮA
=AAA  A\)AϙAAϙAϮApAϙAA
=AffAУAϙAQAϙAΣAΣAA(AυA\)AУAиRA
AυAϙA
AΣAAAApA(A̸RAGA͙AffA\)AA  ApAϙA
=A\)A(A(AzA
=A̸RA  A(AϮAυA  AAffAffA=qAA
A(A(A(A=qAHA  AхAAAԣAGAQA33A  AffAAAٙAٙAAGAA33A33AظRAAAAAHAA
A\)AظRAA(AمA
AzAffAA  AGAHAָRAAיAApAQAQAHAAGA33AAׅAׅAQAAָRAָRAAffAָRA֏\A֣AAQA=qApAAffA
A\)A  AAA͙A=qAAffAЏ\A\)AAУAAУA(AиRApAQAυApẠA(A33AAAzAffAЏ\AиRA{AиRA
AA
AԸRA  AQAՅA֣AAGA(A=qA{A
A=qAHAۙA
=AffAA  A{AٙAQAڸRAA
AHA
=A
=AA=qA
AٮAHA(AQAQAAffA33A{Aڏ\AzAzAA
A=qAۙAأAظRA\)A؏\A
=AAԸRA  AffAAӅA33AՅAA֣AAׅAAGA=qA=qAA33AʣAظRAAٮAHAHAAHA
=AffA33A=qA\)AۙAۙAHAGAQAffA33AAAApAA33A  A(AٙAQA
=AأA  AAAٙAمAAHAHAAAAQA=qA\)A
AGAA{AHA33A33A33A(AA=qA{AffAA{AGAGAGA֣AffA  AAAԏ\AA=qAиRAҏ\AGApAЏ\AљA
AAҸRAҏ\ApAA=qAθRAУAffAAΣA=qA
=AGA33AхApAzAQAffA
A
AЏ\A\)A(AЏ\AA{A33A
=AGAzA˙A(AˮA͙A  A̸RAϙAGAffAУA{AиRAҏ\AA
=AA\)AzA
AQAՅA{A  A=qA33AQApAzAApA=qAӅAәA{AHA  AGAA
AA{AԣA
ApAՙAGAHAәAAAffAиRAAхAAиRAAzAA
=AffAA{ApAAͅA  AffAAGA=qAͅAͅA
A\)A\)AͮA{AffA
AGAA  AΣAθRA33AυAA  AΣAffAУAиRAffAЏ\AHApA
AЏ\AљAAApAәA
A(AAGAAיAA{A  A\)A
AQAAۅA(AۅAۙA=qAڏ\AAQAAAڏ\A
AAA{A
ApAHA=qA=qAA֣A׮AAA  AծApAՅA(A
AQA{A
A  A  AAzAAAҏ\AхAGAAHA=qA(AAϙAzAHAͮAHApAGAQAAGAAGAɅAHA\)A
=AΏ\AAͅA  A
A\)AA  A\)Aԏ\A
AApAϙA(AAЏ\A=qA=qAAGAӅAAA(AԸRAԸRApA
AzAGA  AzAApAڣA{ApAAAܣAHAAܸRA(ApAۅA33AA=qAAffAffA  AٮAٮAGAGAGA(A
A֏\AAGApAA\)A\)A\)AمAApA(AffAzA=qAffA܏\AApA  A
=AffAHAzAHAGA{A֏\AA
A(A(A  AQAAGAAAzAGA33AӮAAԏ\AffAGA  A֣AGApA
AAQA
A33A=qA  A(A؏\AGAGAA\)A  AffAڏ\AڣAGAۮAQAzAޣAHA33AAzAQAffAffA33Aޏ\A(A{A݅AݙA\)A33AA܏\A{AzAzA{AۅAۮAڏ\AۮAffA܏\AA{AAAffA(A{A
AڣA  A\)A  AمA
=A
AHApAGA֏\ApA֣A(A33A
=AϮAѮAԣA=qAApAHAAA
=A{AAظRAՅApAzAAӮA  A֣A(AAQAA\)AAHAՙAՙA{AHA
=A33AׅAA=qAAHAA
=AۮA\)AQAAzA޸RA޸RAޏ\AA܏\AGAAڸRAffA(AA
AGAHA֏\AzApAיA֣AA=qAApA
=A
=A  AHA
=AظRA
AffA\)AGA(A33Aڏ\AڸRAA=qAՙAAA(AffAGAzAՅA
=A\)A\)A{AA(AHAAԣAHAGAGAAՅA=qAzA
=AzAA
AA(AzAԣA
=AԸRAAzA  AAGAӅAәAԸRAApAՙAAAQA  A  A{A  AzA
=AHAA33AA33A33AGAA֣AffA(ApAGAՙAApAՙAԸRAՙAAԸRAӮA
=AffAԸRA֣A֣AzAAәAAծAQAzA=qAffA{AAԸRAAAAԣAGAA
=AхAљA=qApA\)AzAΏ\A33AϙA33A=qAA{AˮAHAAffAAffAHA\)AAGAffA=qA(ApAυAиRAzAAҏ\ApA  AӅAffApAAAיA\)AA(AGAAAA
AA
=AׅApAיAGAAAָRAָRA؏\AHAA؏\AA
AיAHA=qAׅA
=AԸRA
=A  A  AՅAA֣AAA
A=qApAAԏ\Aԏ\A  AԸRAffAQAԣA{AQA
=AңA{A\)ApAHAGAzA{AθRAA
=AzA
=AAͮAΣA33A͙Aʏ\AAAApA
=A\)A͙AͅAΣAzA̸RẠA  A(ApApA  A\)A
=AA(A33AAA\)AAхAA  A
AAԣAGA  AAׅA\)AׅAApA\)A\)AA֣A֏\A֏\AָRA֣A֏\AָRAHAׅA׮AיA
=AAָRAA
=AzA{A(AzAQA֏\AָRAHAAHAffA֣A=qAQA(AffAzApAָRAAAәAҏ\AAAљA
AffA33AzAzApApAAӅAGAңAҏ\A=qAzApAA
=AӅAffA(AA
=A=qAѮA33AңAAՅA=qA(AAA  AA  A\)AzAAffA׮AׅAיA
=AGA
A(AzAHA33A
=AۮAHAHAٙAAظRAffA{A{AיAQAzA
AAٮAأA֏\A{A=qA
AA
=Aԏ\A33AQAGAzAGA\)AхAQA(AAGApA  A=qAљA=qAQAӮAAffAA
AAљA  A
=AQA
A33AҸRA{A=qA  AҸRA{A(AHA33A=qA(AA=qApA
=AәA\)A
AϮAApAAHAGAApAәAӮA{AQAԣAAԣAAA(AQA֏\A=qAAAGA33A
=AԸRA  AffApA\)A
AծAGAHAԣA{AffAffA33AљA
A  AхA\)A=qAffAҏ\A{AӅAӮAиRAGAzAGAAzAA33AAffA  A
A  A33A=qAzAӮAffA(A  AApA{A=qA
=AӅA(AAљA33AA33AͅA(ẠAAAAzAA(A33AAȀ\AA  AGA  ApAQA(A
=AA\)AAυAϮA(A{A
AQA  AA  AAQAAAAQA  A(AυApAAͅA=qAυAϙAAΏ\AGA
=AΣAHAυAυAAϙA(AA
AAAҸRAzA33ApA33Aҏ\AAиRA
AљAЏ\ApAA\)AGA
=AҸRAzA(A
=AHAHAљA=qA=qAGA
=A(ApAθRAAHA  AffAAθRA  A33A
=A
AиRA{AGA(A
ApAA  AA  A=qAA33AHAծA
AՅAHA{A33AGAәA
=AңAңAҏ\AGAУA(A
=AυAGAGA  AϮA33A{AA
AΣAGAϮAAΣA
AGAϙA
AffAAңA=qAApA\)AA33AљAУA  AGAͮAA=qAAHAA
AУAAQA{AGAυA  A{A33A  AHA͙ẠAApAGAHA
AAHAAAGAzA
A{ApẠAΣAApA(A{AˮA\)AљAϙA(A(A
AA(A
AӅAAApAAzAԏ\AzA{ApAәAәAQAQAzAffA=qAQAffAzAQA=qAҸRAffA{A
AffAffAѮA  AхAѮAAҏ\A=qA  A
A(AAAУAA33AGA(AAA33AAQA
=AHAУAљAHA=qAθRAAffA
Ȁ\AA{A
=AAHAŅAŮAAƏ\A
A̸RA̸RA\)A=qAA=qA{A=qAΣA33AffAHAͅAzA\)AϮAAˮA
AAҏ\A  AA(AЏ\A(A
AυA{ApAffAAљAffAҏ\AAՅA  AGA
=AGAָRA(AGAAָRA  AAAHAAAQA  A
AA
AGAAA{AָRA֣A֣AzAָRAAָRA֏\A֣A֣AָRAzAQA{ApAffAGApAAAΣAA=qAGAzAApA(A33AffAffAԸRA=qAAңA(AиRAУAQA{AиRAzAθRAΣA  AAAHA(AѮA  A=qAzA{Aԏ\AAAzA  AAzAָRAffA
=A33AGA
A  A=qAzAڸRAڏ\AQAڏ\AڣA
=AAۮAAۮAۙA(A܏\AffA  AܣAffAAܸRAܣAzA(AۙAۅAڸRAQA\)AأAA(A(A=qAҸRAAAHAظRA\)A(AAzAA=qA
=AffAAՅA(A
=AA=qAQA  AAAGAGAхA
A{AHAиRAffAffA(AθRA{A͙AȀ\AAA
AAffAHA
=AHAA=qA
=ApAԏ\AԣAԸRApApAffA\)AיAA(AffA=qA(AٙA\)AffA(A=qAAAApA33AGA
AffAzAQAHAQA(A  AAӅA  AHAӮAQAGA{A֣AGAGA׮A  AffAApAA\)AٙAA{A
A=qA=qAڣAHA\)AGAHAAAQAQA  A  A
AA(A=qAڏ\Aڏ\AzA=qAڣAAAzAָRAHAAHAָRAA
A=qAׅAAظRA33AffAzA=qAHA{A׮AظRA33AٙA=qAڣAڣA=qAzAA(AGA֣A33A33AGAָRApAԸRAHA
AAԏ\A
A(A  AGA  AAԣA\)AA33A
A֏\AAAApAׅA(AأAظRAHAظRAأA؏\A=qAظRAGAAAA؏\AffAffAA  A(A(A
A׮AA(A(A{A
AծA{ApA33A  AffAA33A33A
A=qAיAA\)A  A؏\AظRAAA33A\)AA{A(Aڏ\AڸRAAAHAGAA33AۅAۅAGAAA
=AڸRAڣAAAمAAA(A{AHAAAAٮAڏ\A{AffAQAمApAAzA  AffA
A
=AAGA
A
AQAڏ\A
=Aڏ\Aڏ\A33AGAAA\)A\)AۙAۙA(A=qAzAApAݙApA
AA=qA(A(A{A  A(AffAzAzAQA{AA
AݙAݮAAQA\)A=qAܸRAݙAAA=qAAAHA33A܏\A
AAܸRAAA33AHA=qA
A
AA\)AAיA{A
A(ApA
AA=qA(AיA(AA
AڸRApAApA{AܸRAۮAAAۅA  AܣAHAGAݮAݙA
A
AA
ApA
A
Aޏ\AffAA
AA
=AGApA\)AݮAHAܸRA=qAAzAܸRA܏\A\)AAۅAA33AۅA
AAHA=qA
=AٙAڏ\AAGAظRAzA=qA=qAAمAٙAمA  A
A
AAAQA
AمAAٮAڸRAۅApA
AA=qA\)A33A{AۙAۙAGA
=AzAffAQAGA  A֣AA\)AA{AQAٙA
A\)AָRAQA\)AAAAAffA\)AAAA=qA\)A(AQA
AGA
=AHA
=AGAA  A=qA
ApAׅAԏ\AљAQA˅AȸRAA
A{AQAAA\AGAA{AzAzAAAA  A
=A
A
=AffApAA=qAAAApAAA\AffA{ApA{A
=A33AAHA(AB
B
BBQB%ffB*{B,  B+zB-B/  B.B,\B+GB*B)HB%ffBpB(B(BBHB(B{B
BBB HARAA
ApA
AzA
AυA(AǙAQA
A=qAAGAARAA\AARA  AGAHA\A{AAHAQA(A{A{A{A{A(A(A(AQAffAffA=qA(A  AGA  AAÅAQA\)AϙApAA\A(ApBBRB=qBBzBBBBBBB
RB
HB\)BQBBBB
{B=qB	\)B\)BA\ARAA{A陚AAA  AڣA33AQAхA
=AAAAǅAffA\)AzAÙA\AAAzA
AAA
=A\AAA\)AAAQA(A=qA{A  AA  Aď\A
=AɮȀ\AϙAA֏\AߙA(AAAQAARBHB(B	
=BB=qBBBBHBQBBBBB\BBBBApA\A33AA
A{A
=A{AGAAظRAffA(A  A  A(AQAʸRA
=A\)AřA(A¸RA
AGAAAAzAAffA̸RAHAzAGAAApAGAHAA  A\A
=B{BB	  BBBB
=BBB33BB(B\)B(A{A\)AQAA
=AQA
ApAGA\)A33A͙A=qAǅA\)AÅA
AffA33A{A
=AA(AA  ARAAQApAHAAzAAARAAA
AffA
=AAAA
=AA
=AGAGAGA\)A{ApAAGA=qAHAAHAHAApAApAffAҸRAҏ\A\)AQA33AA  ApAHA֏\AA׮A{AAA
AHAٙAمAٮAA
AٮAGAQAzA=qA\)A
AA  A֣AGAffAGAGA
=Aԏ\A(A{Aԏ\Aԏ\A
=AffA  A(AՙA\)A  A
AAffAA=qAffAffA(AffAQA33AzA{AQAGA  AffAGAffA  ApA(A
Aҏ\AzA
=AQAAffAԣAApAA  AԣAӮA33A(AffAAAffA33AffAQAϮAHAffAθRA  A=qAAAңA  AHA
=AՙAיAGA(AׅAָRAA
=ApA  A(A=qA=qAzAظRAظRA
=A؏\AQAffA(A{AQAzA֏\AA
A(AՙA֣A֏\A=qAQApAGA{AAٙA33AظRAQA=qAA\)A33AGA׮AGAAAAHA33AzA=qA33ApAHA=qA\)AffAAׅApA{AffAAA  AأA֣A\)A33A֣AӅA\)A33AA
A33AٙAظRA{ApA{AأAAApAAffAQAzA\)A(AzA33ApA׮AGA33AAۮAܸRAAܣAܸRAA33AHA
=AHA݅AAAAA܏\AܣA
A
AAۅA
A\)AGAA33A33A\)AGAGApAGAۅA
=AA\)AۅAAAڸRAAA
A  AظRAٙAAHA׮AָRA
A(AAҏ\ApAAGAمAzA
AӅA\)AGAA
A(A
=ApAָRAՅAGA؏\ApA(AAمAAծAAAיAApAՅAԸRAԸRA
=A\)ApAՅAՅAA(AffA֣AAAAGAׅAGA
=AA
=A
=A֣AzA\)A(A{AծAAיAGA
=AA
AA=qAAzA؏\AأAظRAzA؏\AzAHAظRAظRA؏\AأA=qAQA(AәA  AzAzAӅAAGA33A33AGAָRA֣AzAA(A(AzAA{AأA=qA
=A{A=qAQA33AffAҏ\AffA(A  A(A֏\A{ApAָRA֣AA(AA{AיA\)AأAAAمAיAA
A؏\A(A{A؏\AAApApAAٮA=qA(AGAzAAQAQA\)AمApApA؏\AQA(A33A
=AׅA؏\AAAمAٮApAApAۙAQA33A܏\AApApAܣA
A  AA{A  A݅AffAA  AA
A\)AHAffA\)AGA=qAծA  AHAAffA33AA(AffA֏\A  AApAأAffA
=A\)A
=AظRA  A(AAffAGAܣAHAܸRAA
=A\)AAݙA܏\A؏\AأAיAAGAۅAffA܏\A(AA(AffAGAA(AQAޏ\Aޏ\Aޏ\AzAޏ\AffAA33AzA\)A(AzA  AHAffA
=A  AٮA  AAAffAQAzAAָRA
=A؏\A
A33AA\)ApA\)A  A
=AՙA  A  A=qA֏\A33AA
AHA=qAA
=ApApAأApAQAHAApAGAՙAծA  Aԏ\AHAԏ\AԸRAzApAAAAA
=Aԏ\A
AQAA׮AQAA33ApApA
AڣAۮAzAzAAGAHAAݙAA=qAޣAޣAHAAAzA{A(A  A  A
=A{A
A
AA
AݮA݅AzApA  AHAffA  AGA\)AAzAڣAGAڏ\AAGAمA\)A
=AffA(AffA  AָRAָRApA(AHAڸRAمAظRAffAzAzAQAأAQAHAA=qAffAzAיAA
AQAA
=A=qA=qAA  AQA=qAڏ\Aڏ\AڣA\)AAۅAAGAۙApAGA  AיAQAzAծA
AA
A  A(AAAApApAAיA  A{AAHAծA
=A=qAQA=qAԸRAA\)AԸRAA33AGAԸRAAԸRAAԸRApA33ApAA33AAAA(Aԏ\AԣAA\)A(AGA(AAA{A(AأA(AAظRA؏\AHA{AA
AGAAA(AQAA=qAԣAAAffA{A{ApAԸRAAՙAA  A\)ApA  A֣AA(A(AHAAأA  AHA33AzA
AAAAA\)A33AzAڏ\AA33AGA\)A
=A33A33A\)A33A33AA{A=qA\)AQAGAۮA
=A
=AۅAAAڣA
A(A
=AzA33A33AA
=AٙAGA؏\AffAAׅApA=qA(A33AAffAAGAׅA
AAӮA  A
=AAHApA=qA
A=qAzAԏ\AffAԸRA=qAԏ\A\)A֏\AA(AA֏\AQAffAQAzAָRAA33AGAAHA(AծAAGAAծAffAA׮AHA33A33AGAGAָRAAծApAffAffAAzAffA֣AHAA
A{AיA
A  AׅAיA\)AAAHAAָRAָRA\)AffAԸRA\)AGAҏ\A=qAA\)AHAA\)AGAHAҏ\A=qA  A{AAљAиRA
=A33A33A\)AѮA
A  A(AzAA
=AAңA=qA=qA  AѮAzAHAAAхAQA{ApAGAAAGAAУAHApA\)A33AңA=qAAAAAApA
AAAAA  AzAۅA=qAQAQA  A{AffAQAffAܣAAAAAܸRAHAܸRA33AQA܏\A
=AAA܏\AA{ApA(AAAۙA
=A=qAzAڏ\AAGA33AۮAA=qAمA
=A
AA{AGA\)AAԣAԸRApAԸRAA\)AAGAծA33ApAծA(A֏\A\)AԸRAffAA
=AAAAHAAA=qAՅAAծAծA
=AՅAGAGAGAՙAQA֏\AzA  A{A  AAA{A\)ApAA=qAffAAQA(AA؏\AA׮AGAAA
=AGAׅAׅAAAA\)AGA\)AGA\)AAffA{AأAٙA33A(AHAׅAׅAׅAԏ\AzAHA(AGAGA  AffA(ApAQA
=A33AԸRAҏ\AљAffAA
=A  A(AzAָRAGAAA  A\)AHAՙAҏ\A  A(AәAffA֏\AHA(AA\)A؏\A׮AGAQA\)A  AA33AӮAQAָRAA(A33A33AGA(A\)AظRAأAAHAظRAظRAظRAأAׅA33A33A{A{A=qA؏\A=qA
AAGAffA\)A=qAәAAՅAԸRA
A֣AיAA
=A֣A֣A֣A֏\AffAQA=qA  A{A  AAՅAՙAծA{AՙAՅAAHAхAA33AA
AAA
AHAGA
A  A\)AׅA=qA  A
A(AAffA=qA33AGAGApAA=qA
A{A{AAGAׅAGAQAAAAA=qAffAffAffAffAffA֣AAA\)A\)AGAיAיA  A=qAAظRAHAzA{AA
AAzAffAQAظRAQA׮ApApApA{A{AׅAzA\)AיAA=qAAיAՅA֏\A  ApA  AHAԸRAծAՙAՙApA{A֣AHApA֣AAHAָRA
=ApA  AA
=A
A{AיA֣AGAAffAA  A
AQAHAHA
=AׅAA=qAffAzA
=A(A
AHAA
AQA=qAAمA
=A\)AAzA\)AAGA
=ApApA\)AAffAffAA33AGAAHA  A  AHA33AAޏ\AHAޣAA݅A
AGAGAܸRAAܸRAA܏\AܸRAzAA(AA33ApAAAQAHA؏\AٮA֏\AHAA=qA(A
A
A33A֏\A{AڸRAۙAۙA؏\AA
=A׮AAAӅAٮAffA=qAٮAHAffApAمAGAQAffA33AA(AHAָRAA֣A  A33A
A׮AٮAQAA
=AffAٮAظRA\)AA
AffA  A\)AzAمAzAمAٙA(AٮA\)A33AGAAAGAQAA=qA(AAAڸRAQAAzAzApAQA  AA݅AޣAޏ\AzAffA(AޣA  A݅AAffA(AApAAA\)ApAӮAAԣA
=AAA=qAԏ\Aԏ\AAظRAA܏\AzAۮA
ApAffApAQA
A\)AA
A(AA(Aԏ\A
=AHA(ApA{A=qAָRA֣AzAQAffAԣAԸRAAA\)A  A֏\AָRAGA33A33AA33AGA\)A\)ApAׅAיApApA
A\)A؏\A(AHAA=qA
AA33A{AٙA{A\)ApAAAأAA33A
=AָRA
ApAHAхA33A  A
AӮAҏ\A\)AHA33A֣AQAAHAQAHAA(A
=A=qApAAffAхAAGAAAAA(AأAҸRAQAAиRAͅApA
=A(A{AzApA
=Aҏ\AA
A(AԣA
=AA=qAָRAA
=ApA  A(A؏\AAGApA  AHAڏ\AzAAAAA  AAAGAمAGAٙA=qAٮAAمAAمA33A\)AمApAAHAGAGAAGAA{A
=AָRA(A
ApAAAQAGA  A{AAffAظRAAظRAGAGA(A{AAGAQA\)ApApA33AQA(AA
=A
AAzA׮A֣A֏\ApA33A׮A
A(A
=A=qAՙAծA  ApA؏\A(A֏\ApAA{A(A(AأAA33ApAٙA
A  A  Aڏ\A(Aڏ\Aڏ\AۙA(A  AۅAڸRAzA=qApAۅA  A
ApApA=qAAGApAAAHAHAApApAمAمApAGAأAAׅAzA  AAGA
AHApA\)AA33AיAA׮AיA׮A
=AQAӮAՅAՙAHAAA33A  AՅAAzAA֣A
=AָRAAA\)AA  A؏\AAأA؏\AGApA33A
=AHA33AAzAAGApAA  Aڏ\A
=AGAffAffAܸRApA݅A\)AGAGAAGApAܸRAQA=qAHAzAQA(A  AAڸRApAAApAHAڣAAGAۙAۮAAA  AHA(AܸRAAAA33AGA  AzAܣA܏\AAA
=AA{AٮA
A  A
AٮAGA
AمAffAڏ\AAGAԸRAڸRAffAA(A
A
=A{AA33AٙAA=qAA  A׮AظRA֣A=qAffA֣AGA(AGAGAAٮApAٮA  AۮA
AA܏\AܣAzAffAA(AHA
=AۙA\)A
=AAڏ\AAܣA܏\A  A(A\)AA݅A
A(AffAffA  AٙAQAۙAA
=A
=A33AAA\)A݅ApAzApAzA  AffA(ApAA؏\AHAՅAGAՙAAffAҏ\A  AظRAٮA=qAzA؏\AAAAApAA
A
AA  AGA33AݙA(AA  AffAޣAޣAffAޣAzA33A(AۮAffAڣA  AA{A
AGAzA33AAڏ\A33ApAQAGAۮA  A  A\)AݙA޸RAAHApAݮAHApA  AA݅AzAޏ\A߅A߮Aޏ\AGA  AzAAޏ\AݙAAQA
=AAծA33A33Aڏ\A  A܏\A  AGAA(AۅAzAمA=qA{AGA=qAA{AA  AGA
=AAָRAHAAAGA{A=qAzAGAHAAҸRAAՅA֏\AzAQAأAHAzAAHAHAAڏ\AA
AApAA
AAGApA
A
=A
AҸRA=qAGAAA
Aҏ\AңAAzAHAAҸRAAҏ\A  Aҏ\Aҏ\A=qAAffAԏ\A{AҸRA{AՙA  A
=AظRA\)AׅAՅAԸRAA(A(A  AA{AA
AӅA\)AAzApA33Aԏ\Aԏ\AGA33Aҏ\AѮApApAѮA  A  A{A(A  AAҸRAҏ\AQAAffAӅA\)A  A{A=qAAAHA
=AHAAљAffAԣAԏ\AԣA=qAHAՙAՙAծAծA  A{A(A=qA=qAffAAAffA(AA
=AHA֏\AAffAՅAffAAծAAׅApApAԣAԣAA{A{AՙAAծAGAӅAHApAHAՅA
A33ApAffApAzAԸRAԏ\A
AծA֏\AAA
A
=AԣAA33AzA  AGAϮA
=AHAA\)AхA\)A{AAңAQAApA  AΣA=qAzAzA(A  A͙A33A  AΏ\AffAA
AθRA
=AGAzAzAHAAHA\)A  A{AHA(A֏\A\)AQA=qAAٮAٮAzAA33AۮA=qA(AHA=qA(A=qAA
A
AۮAۮAA
A\)ApAAمAمAAٮAA
A{AGAAA
ApAffAڣAڏ\AzA=qAGA؏\ApAGApApApA
=A  AA33ApAأAAծA(AָRAظRAApAٮAٙAٙA=qAָRA
=AffAAڸRAڣAffAAAظRA33A33A(A  A  AHAGAzAAԸRA  A
A{ApAAAAGA
=A؏\A\)A33AAA=qAffA݅AܸRAAA33A33AݮA݅ApA݅A\)ApApA݅ApA݅A݅A݅A݅ApApA݅AA݅ApA\)A\)A\)A\)A\)A\)A\)AA݅AݮAApAAAzAGA(A  A
AA(A
AڣAAمAAHAffAٙAA  A\)AمAمAAffAA{AHAٮA(AA
A  A
AAA=qAzAڏ\ApAظRA
AA  AAAA{AzA{AffAQAQA
AׅAظRAGAGA
AHAAA
A  AۮAAڏ\A33Aڏ\A(A  ApAAGA؏\AأAAffAA
=AۅA=qA=qAܣAA܏\AA{A  AAAAۮA  AۮAۅA{A(AA  A{A=qA  A{AAApAۮAA
ApAۅA\)AAAffA33ApApAۮA\)A33A33AAGAHAڣA  A  AAA=qA
=AApAAffAQAHAffA  AA(A(Aڏ\A\)A{AAݮAA(AffAޏ\AApA߮A  AzAA33ApAAᙚA
AA
AHA33AᙚAAAA\)AA33AA
=AᙚA
=A
=AߙAߙA޸RAޏ\AffA(A{Aޏ\AQA{AzAAAGA\)A\)A33A݅AGAAݙA33A  AA
AA
AۮAۅA{AA{A=qAffAA
AzAQAAHA(AGAܣA(A{A
=AڸRAA
AA{A  A=qAܸRAA33AAGAAAޣAzAQAzAޏ\A33AAߙA߮AA(AzAAAGAHAGAQAffAAAARA33A
=AAQAA\)A{ApA
A  AzAA=qA=qAzA\AzA=qAA(A  AQA=qA(AGAA=qA߅A(AAQAޏ\AAݮAzAA(AAGAᙚAHARA  A
=AAQAQApA{A=qAA\)A
A
A{A(AߙA\)A
=A(A
AffAA\)AޣA߮A
=AARA=qAHAA݅A\)AffAAQAٙAAڏ\AA  AAffAHAݮAAޏ\Aޏ\AޣAA
=A33AGA\)AHAޣA{AݙA݅AݮA  A݅AAAA(AۅAۙAAAڸRAAۮAAAA
A܏\A
=A33AzA33AݮAA
ApA
=A  A=qAGAAݙAAGAGA\)AA  A{AݙAzAݙA\)AApA33AHAffA=qAܸRA܏\AAAGAApAGA33AGA33AA݅A  A{AQA
=AA
A
=AۅA  AQAHA\)A(AApAA߅AA(AA\)A
AGAQA\AHAAffA{A
A  AApAA33A{AAGAffApAffA=qA=qAAA
A{AߙA33A=qAܣA
A  AzAߙAGAޣA
A  AzAA
AQA33A  A
AA؏\AAٙAAݮAܣAAAHA
A\)AׅAQAיAڸRAAٮAGAۙA{AHAܣA
A
ApA޸RAޣA(AAޏ\AGAA\)A
=AA=qAAA  AQA߅ApA߮A  A{A(ARARAApAA
A
A  AQA(AA
=AAAAzAQAA=qARAHA
=AA\A㙚A
=A
=A
ARA\)ARAGAHApARA
=AAzAߙA݅AٮApAܣAApAᙚAޏ\Aޏ\AܸRAffAAA֣AԣA(A
=A{A{AAA
AAޏ\A
AGA  ApAA{AHA(AffAA݅A  AAޣA33AGAߙAA
AQAۮAAffAܣA33ApA{A33A\)A{AQARAGA\)AA  AQAAAAffA
=A  AzA
A\)A
=ARAAA
ApApA(A  AᙚAᙚA  A  ApAᙚAAᙚA\)ApA\)A(AGAޏ\AGAffAݮAܸRAܣA  AAAQAڏ\AڸRAGAAA  AHA
AAәAHApAQAGAQAGAAٙAٙA33A\)AٙA  A؏\AQA=qAA33AAڏ\AQAڣA
=AGAۮAۅAzAA
AAܸRA{AA33A33AۮAAQAHAAAܸRAAݮA
AQAffAAA33AAߙA\)ApAGA\)AߙA{AAA  A{A  A(A߮A\A  A(A(A\)A޸RA{AݙAݙA33A=qAAQA  AGAܣAAGAٮAA  AݮAQAA  AHAGApAߙA(AQA{AܸRAzAڏ\AAۮAۅA(A33A(A݅AAڏ\A=qAHA  AQAڸRAffA{A֏\AԸRAӮAӮAԣAA{AӮAGA(A(A
A=qA=qAGAffA׮AՙAA
AAAظRAA
A  A  AA\)ApAzAAۙA=qAڸRA{AٮAAظRAzApAA֣A(A
=ApAՅApAzApAGAGA\)A
AՅAՅAAzAAAՙAAzAAӮA
AAՅAAA
A  AA33AׅAיAQAѮAzA=qAAHAA\)A{AиRAAHAAzAѮA{A{A=qAҏ\AGApAApAA(A=qAA
AAGAיAAQAA  A
=AڣAڏ\AڣAHA\)A
A(A܏\AffA{AzAAffAܸRA݅AAA(A{AAA܏\AffAܸRAܣAGAݙAffA\)AAHApA
A=qAApAۙAۙAۅAzAHAAQAAٙAHAzApAA33AQA33AծA=qAQAָRAzA֏\A\)AָRAzA
=AA  AA֣A
=AA׮AיA=qAAӮAׅAA
AGAA\)AQAAHA
AHAAffA(AAzAAٮAظRA
=A
A=qAٮA{AzAHA\)AAAzA܏\AܸRA
=AGApAGAA\)A33AܣAAHA݅A
AQA  A=qA(AffA(A
AAA=qA{AAAHAQA܏\AHA
=ApAA
=AHAܸRAܸRAܣAܣAGAAAAAAأA=qApAAܸRAzAHAܸRAܸRA  AffAAܸRA\)ApAՙAzAGAQA=qA
AA33AAffAAAޣA  AəA  AA
A=qA
=A
=AظRAApA\)AAffAڏ\Aڏ\Aڏ\AQA{A33A
AAGApAA=qAffApA  AAHAA  AzAGAمAGAAQAA֏\AיA֣AծA=qA\)A֣A=qAAՅA
A
A
=AԸRAApA  AA33AffA33AHAԏ\A(AәAӅA\)AA
=Aҏ\AzA33AAffA=qA
=AGAңA
AA
AHAAҸRAffAхA\)AHAљAѮA\)AQA
AԣA{A
AA=qA(Aԏ\AffAԸRAՙA(AzAAיAffAAAHAA
=AGAGAٮA  AQAڏ\AڣAzA=qAڣAffAAAA
A
A
AٮAzAڣAAAAzAffAffAAA׮AظRA{A{AQA
AיAA(AGA33AGA  ApApAAzAԏ\A{AAAQA
=AzA
=A33A\)AAָRA{A{Aԏ\ApA
=AԸRAAGA=qAGAAԏ\AffAGAԏ\AңA׮AGA֣AQA
=AӮA=qAԏ\AGA
A
A
A֣AGA׮A  AظRA
=AGAzAHA33AۙAۙA{A=qAzAܸRAAHAAݙApAGAHAGAHAA܏\A{A\)AHAA
=AAۅAHAܣA{A܏\AzAܣA=qA=qAA{AAۅAA33AGA=qAڸRAQA=qAffAٙAHA  AQAAGAظRAAGA׮AՙA֣AAAיAA׮AHAA\)AۙA
=A(A
AA33A֏\AԸRA(ApAzApAׅAGA
=A=qA\)A  AA=qA=qAمAٮAzA(AffAڣAzAQAQAܣAA\)AݙA
A  AAA33AHAAHAܸRA܏\AffA=qA(A{A  AA
AۮAۅA
AۮAAffAApAffAzAٮAٮAAQAAAڸRA{A=qAٮAمAٙAA
AA\)A{AمAGA
AAٙApA  AQAՅAәA  AAHA
=A  A=qA\)AٙAڣAA{A(AAffAGAGA
A׮AׅAHA\)ApA  AzAQAHAGA\)A  A=qAAHA݅A  AݮA  AQAޏ\AQA(AQAffAffAQAA=qA
A\)AAGA33A
A(AQAzAzAffApAA33AHA܏\A(A(AzAzA݅AۅAAAHAܸRAܸRAAAGA
AׅA֏\AQAGAӮA\)A=qAffA(AAGAңAA(A
=ApAAA{A
=AծAzAծA  A33AAԣAA׮AծA  AיAGAHAHAGApAA{AA֏\A  A{A(A33AA=qAA{AAٙA=qApAQAA݅A  A
=A(AAHAGA33AA{AGA
=AQApAHAA\)AQAzAA
AffA{A܏\AGA(A(A=qA=qAzA
=AܸRA݅A݅A{AAHAݮAGA
ApA  A܏\A܏\A
AAۮAAۙAڸRAAffAיA  AٙA{AHA؏\A  A׮AA
=AA
=A33AAQAѮAGAԸRAA  AԸRAQAAљAffAGAҏ\AиRAУAAA
=A(AA׮A  AzAzA=qAffAzAأAA
=AظRA{AAGAA׮A{A{AffA  AӅAffAӮAԸRAAAAApApAzA
A
=A(AffApA33A
AՙAָRAzA(A֏\AzAHAHA(A
=AՙAGA=qAՙA  AGA(A(AQA=qAՙA  AיA{A(AGAAأAzA  AA
=ApA33ApAGAffAٮAA=qA؏\A(AGAٙApA\)AA؏\A
=ApAGAHA{AzAAAڣAۅAۙAٙAQAAzApAٙAA(A\)A
AffAA\)AA؏\AQAAGA
=AHAHAQA(AffA=qA
AׅA(A\)A=qAA֏\AQAՅAAA
=AAәA(AԸRAԏ\A=qA
AffA=qAffA
AAԣA֏\AffAAHAԏ\Aԏ\AA(AHAԣAGAҏ\A(AzAԏ\Aԏ\Aԏ\AAHAԸRAԣAAApAGA\)A
AծAffA\)A=qA(AAQA(AHAظRAHA؏\AzAHAظRA  A=qAA
=AA
AffAGAݮA=qA=qA=qA(Aޏ\A=qA{A33AAܸRAGAA{A޸RA33A߮A
ARAffAzA(A  A
A
ARA33ApApAGA\ApAޣAGA
=AGAApA׮A=qAظRA33A֏\A֏\AApA=qAA֣A
AQAٙAAٙAQAٙA
Aڏ\AA\)A33A
=AHA33AHA33A\)AHAGAGAڸRAAڸRAAGA
AQA܏\AzAAܸRAݙAA  A(A
=A(A=qAA{Aڏ\AڸRAڣAHApA  AAGAAAAA\)A\)AAAA
=AA33A33AAAGA݅AݮAA  A  AAGA
A߮AHAA33A޸RAAܣA=qA=qA(AAA(AA  AAAAHAA{A  Aޏ\AA(AzA(AA\)A
=A
AApAGAߙAߙA\)AGA33AAGA{AA
AQA  AAGA(AA(A
AAGA؏\A؏\A
=AAAA{AQAHAٙAzAHAffA(AAffAڸRAڸRA=qAGA\)ApAծAՙA\)A(A֏\AQA=qAA  AָRAHAHAffAA
=AGAۙAۮAffAHAܸRA=qAٮAAGAzAٮAffA
A׮A33AffA{A׮AAffAA
AՅApAAzAQAA(AңAҏ\AffA  AУA(AУApA33AљAѮAљAAAAHAGAӅA33A  A=qA֏\AGA{AAA=qA
A  AffA
=AҸRAңA  Aԏ\AGAAAՙAAՙAՙAՙAՅAՙAA\)AGA\)AՙAծAՙAHA\)ApAAՅA(AָRA
=AAHAzAA(A  AffA=qA
A(ApA{AӮAzA  AA\)AHA  AAхAGA
=AAQApAzAҏ\AՅAffA\)AAAхAGA=qA  A33A
AՙAЏ\AͮA{A(AAzA  AϙAGAA
=A  AЏ\AхA\)AљA̸RA
=AAQAυAϮAͅAHAAffA33AAәAffAzAՅAA
AָRAA\)A
A=qAAAGA
=AAHA؏\A=qAAأAAzA֏\A֏\A33AָRAGA֏\A֣AGA(AA
A؏\AA33AمAAAمA\)AffAHAظRA֏\AיA
AffA׮A
AA֣A\)A؏\AׅAظRAԸRAՅAԏ\AQA=qAҏ\AAGA
A
=AAѮA{A(AͮA{AHAA(AA33AͅAffAffA
=AљAAҏ\A
=AQAHAԏ\AՅA
A
A
A֏\A33A
=A  AָRAA
AAAԸRA
=AAA  A֣A33AAיApAA(A=qA=qAzAzAffAأAأAffAיA
=A
=AffA
AיA(AظRAAA{A\)AۮA(AAأA33A\)AAיApAԏ\A{AԸRAڏ\AzAA׮A33A\)AԣAQA  AԣAӅAffA(AffAA33A{AffAQAٙAٮA{AGA33ApA=qAAAңAҏ\AA{AQAGA֏\AיAיAQAأA؏\A
A\)AיAA{AApA(ApAAAҏ\A\)A33A{Aԏ\AAAGA\)AՙAծA
A\)AGAA
AA  AzA\)AAAӮAծAffAGAGAAffA=qA؏\AAأAA\)AٙAAAٮA=qAڣA(AمApAمAأAA
A
AAԸRAAυAңAԸRAQApAՙAԸRA
=A(A=qA=qA
AHAA\)A=qAυA33A(AУAA{AA
AzAQAAAAffApA֏\AAA֏\A=qAA֣AQA=qApAծAAAAGAA(AHAAffA33A33AمA33AGApAٙAAA
AQA{A  A
AAHA=qA=qA(AAGAAzA(A  AA
=A\)AffA
=AHAzAffApAGA33A33AׅAיA{AzA  ApA33AAHAQA=qA(AָRA33AQAծA
A(A(AՙAGAԏ\AGAԏ\AծApA{AA(AffAAAA(A\)AAAGAAظRA{A
A
=A{A\)AffA33A=qA{AAHAffA
AGApA\)A
A(Aڏ\AۅAA{A=qA(AQAܸRAffAffAffAܣAܣAܸRAܣAܣAܣAHAAݮA݅AݙApA܏\AHA(AA݅AܸRAܸRAۮAApAۅA
A܏\AzAAHAۅAHA݅A
=AffAAAۮApAA\)A=qA܏\A܏\A܏\A܏\AܸRAAܣAffAAAAָRAAٙAffA\)AڣA
AQA
AApA
=A(AAAAHA
Aڏ\A؏\AأAAA݅AAڏ\ApAۮAGAzAޣA  AܸRAHA33AAzAAzAzAGA33AAGAA\)AAAHAGA߅A޸RA\)AGAAQAۙAAAAffAzA{A
=A
AأAffA
=AzAՙAAӮAzAzAAՅA֣ApA
AffAHApA{A
A\)AAϮAԸRAA=qAffAָRAՅAA
A=qAGApAA=qA޸RA޸RA=qA\)A\)AA\AffAݮAGA
AA{A(A(AAݮAApAAffAܣAܸRA܏\AA  AۙAۙAGA  AHAۙAڣA  ApAיA33AGAGAA\)A33A
A
=A
=AA  AGAۮAڣA
A  AיA{AzAAAHAAHA܏\AzAQA=qA  AHAAܸRA
AGAQAA֣AڸRAA33AA33A  AHAffA  A݅AۮAۅAzA{ApA=qA  A{AGA\)AHAAzAڏ\AAHAظRAzA׮AQAٮA
=AمAA
=A33AۅA\)AۅAGAۅAffA  AܸRAAܣAQAۮA
=AAݙA
AGAAffAAۮAۅA33AHAHAۅA33A
A=qA\)A(AܸRAAGAAffAGAffAAܸRA  AܣAzAHA  A
=A=qAAAأAAA  AzAA=qAAGA
=A(AHAٮA  A=qAәA
=AAffA؏\AGA  A  ApAڏ\ApAAA
A  A=qAQAGA\)ApAٙApAQAAAمAڸRA\)AGAٙAAՅAzAљAѮAA33A
=AA
AͮAA(ApA(A\)AģAA\)A33A(AzAARAAffA=qA=qAffA=qAAGA
AAAAAHARAA33AA\A\)AGAA\)A
=AQA
=AA
A(AQA\)AAAQAHAApAHAAGAA=qAA
=A  A\)A
AAAAA{AAAARA
AGAGAGAAAQAA¸RAAA{A33ARAAzAΣA
=A=qA(AApA  AffApA=qAA\)A=qAA
AffAA33AѮAAиRA
=AՅAA
=AAzA
=AAffAA  Aҏ\AՙAApA=qAAffAffAӅAzAхAzAҸRAͅAffA
=AAϙA  ApAӅAAҸRA33AQAҏ\AA  AәAffA  AQAљAхAApA33AzA˙AͅA̸RA\)AzA(ApAA  AA=qAԣAAѮA33AAхAAffAAAzA{AzAQA=qA
=ApAA(AHAAۙAA{A
Aڏ\AۅAA{AAٙAQAffAڸRA33A(Aڏ\AHAHAיAڸRAAQAGAҏ\AffAAA=qA
=A  A
A=qAQAAأAA=qA\)AHAٙApAԣApA
AAңA(A  AA33AϮA  AAAAAA\)AمAffAծAԏ\A=qA
=A  A  A33AAׅAAQA(AHAѮApApAЏ\A=qAA33AHAAӮAӅA
=A\)A(AӅAAAѮAzA
AծAHAظRAׅApAיAA
A\)AָRAGA؏\AQA
=AGAA
=A
A֣AٮAҸRA=qA33AA(Aԏ\AGA{A=qAAՅAGAQAAffA
AظRA(AzA(AAffA
=Aԏ\AffAA\)AӮApAиRAGAθRAAхA
A33A
AGAAffApAzAУAљAAA\)AffApA
AҸRA\)A\)AffApA=qAљAA(ApA{AAApAHA{AңAӅAԸRApA֣A{AHA{AڸRAAܣAܸRApAݙAݙApA33AA(AܸRA  AۮAۅAGA
=AHA33AڸRAۮA
A
AڸRA\)ApAHAApA  AٮA  A
=ApAٙA  A\)AՙAAԣAzA֏\AffAAA=qA؏\ApAA=qA
A{AApAՙA33A(AՅAׅAHApA
A=qAָRA֣AA
A  AAӅAAAAffAzA  A33AHAA
=AڸRAA؏\ApApAGAAA
AAڸRAQAzAGAA\)A33AGAAffAܸRA33A݅AA{Aޏ\AޣAޣAffAffA{ApAGAHA܏\A33AۅAڣAAGAܸRAHAA  A{AGAQA{AݮA=qA=qA  A\)AܣA33ApAzAAܸRA
=A=qA
=AQAAQAHAQA=qAHAAQAHAA(AAAA=qA=qA  A=qA
=A(A\)AУAffAA=qApApAAQA{AGAAA{A
=AA{A(ApAA=qAzAA\)AۮA
A  AQAAzAAHA
=ApA
A{A=qAzAޣAHAޣAzAQAޣA޸RAAݙAݙA(A
AA33AۙA33AڣAڸRA(AڸRAA
=AA33A
A  A=qAQApAA=qA(AQA܏\AzAٮA
AHA(ApAٮAAڏ\AffA
AffAzAffA  A=qAۅAffA܏\A܏\AQA{A
=A\)AׅAffA
A֣AHAӅA  AffAAGApAAHApAڸRAA؏\AأA(A(AA(A(A{AzApA\)A=qAA
=AۅApAA܏\AAGA\)AAA=qA=qA=qA=qA(A{AQAHAޏ\AAAߙA=qA=qAߙA  AGAzA\AA33AApA\A=qA
AAA
=AffAA݅AA  ApAݮAܸRAAffA\)AAܣAzA  AAA33AՅA֣AHAAQAܸRA=qA\)A33A\)AAHAQAGAzAAApA(AAׅA\)AۮAڏ\A=qAݙA݅AA  A
A
=A
AHAApAApAGAHA
AA(AߙAA{A  AffA=qAffAAHAA\A޸RA
A
Aڏ\AHA{A  A
A=qAGAׅA\)A֣AָRAיAA  A  AGA\)AיA֏\AHAA{A
A֣ApAGA
AQA{AAָRAA׮AA  AٮAAAA(AHA{AڣAQA33AzAٙAzA33A33AٙAHApA(AffA
AԸRA  Aԏ\AӅAGAңAAAңAA33A{Aҏ\AzAAzAأA  A
AHA=qA=qAޣAA
AffAQARA=qAHAAzA33AAAܣAAۅAڸRAQA{AٮApA
=AA
=A{AHA؏\A33AHAأAٮAٙA{A
AۮAۮAAHA(A
AٙAGApAHAQAA׮AA=qA33AzA(AGA  AAA=qA֏\A֣AffAA=qA  A33A=qAՙA\)AA(AәAӅAAzApAHA33AиRAAхAAGAAzAzAAУAυAѮAA  AGAԏ\AՅA(A֏\A֣AA=qAׅA=qAA=qApA  A  AzAGA
=AA؏\AأAzA\)A{A  A{A(A(A{A
A
AGAׅAAׅAׅAffA
AA֣A֣AיAA֣AffAٙAظRA
=A
=AAHAzApAA֣AzAGA{AAffAAӅA
=AAAәAҸRA  Aҏ\AQA=qA  A
=AffA33Aҏ\A\)A
A=qA
AGA\)ApAGA=qAzAӅA  AA=qApAA(AϮA(AAGAхAA
=AA
=A\)AAԏ\AA
=AGAՅAՙA(A{A(A=qAffAA֣A֏\AA33AHA
AffA
=AׅAיAA\)AׅA33AGAAHAׅAGAHAzAAׅAAGAffAQApA  A؏\AAׅAGAGA
=AיA֣AָRA=qA
A
AՙApAԸRAҸRA
A
AθRAAAApApAzAA
A֣A=qA
Aԏ\AӅAԸRAԏ\AGAAծAQAGAיApA33AAGAAGA=qA33AGAffAA
AٙA(ApAAAAzAأAظRA=qA{ApA
ApAAׅA׮AׅA\)AGA\)A33ApAׅAA(A
A
A׮A33AQAׅA\)AָRA֣AffA(AHApA  AA{AHAA33A(AՅAՙAAՅAGAAA=qAԏ\AԣAծAA{A(A\)AӅAAҸRA=qAAzApA
A(A
=ApA{A33A
A
Aԏ\AәA\)ApAA(AA  AAԏ\AQA(ApA  AffAQAәAzAAA{A(A֏\AHA
=A
A=qAQA֣AApA\)AAAHAQA(A(AծAA  AAffAׅA֏\ApAׅA
A  AAzAzAAAAGAApA33A(AA(ApAAffAԣAׅAHAHA33A  AAԏ\AAHA  A=qA=qAQAffAGA\)AA33AAѮA  AAGA  AA  AיAָRAA
=A\)AGA֏\AGAHA\)A
AיAAׅA
=AיAAffAAՅAՙApA{A{AЏ\AGA  A\)A{Aҏ\AҸRAffAHAzAffAQA
AӮAA(A{A{A{A  A
AԸRAffAHAAAffAApAGA  AApA\)AA֣A(AAQA  A
AAՙAծAA
A33AHAHAffApAA=qAAGAAAхA  A{AA
A33AљA33AAGAffAA
=ApAHAӮAzAAՙAzAGAָRA
A\)A(A֣A
AԸRA
A
=AAQA  A  A  AԸRAՙA
ApA
AՙAծAA=qAffApAԸRAAA\)AՙAծAA\)A  A{AծA(AծA=qA
AQAzA֏\AzAA֣A׮A33A֏\AzAGAGAGAיAAAAAzAHAQA\)A{AA
=AffAңAӮAAӅAAѮA  A(A  A\)AҸRA{AљA{AΣA  AA\)A\)A33A33A\)AHAϙAHApA  AϮA{AϙAffAЏ\A33AʸRApAA
AA{A  AA33A{AA(A33A  AffAڣA
=A
=AAAٮAAٮAGAمA  AQAzAzA(A
AApApAA؏\AGAGAGA33AAHA
=Aڏ\AGAA
=ApAA33A(A
ApA֏\AzAA(AՙA
A
=AzAAԏ\A
=A\)A(AAAׅAA֣AՙAAA  AQA
=A
=AffAՙA
A
AԣAAA\)AGAQAA33AAAHAA{A33ApAAGAָRA֣AԣAHA  A\)AAָRA֣A=qA=qA
AՙApAzA33ApA
AQAAٙAQAA=qA  AAA  AAٙAA{A  A  AHA(A{A
AA{A
AA=qAٮAAٮAHA
=AGApAٙAٙAمAمAffAQAڣA  AAAQAHA  ApA
AGAQAAظRAA
A
Aڏ\A{A\)AGA=qAGA33AAAA
=AA33AAظRA(AٮAظRAQAQAأApAծA  A  A
A(AAzA
=AיAA
=AA֣AHAffA֣AָRAָRAA
=ApAQA=qAظRAHAA
AٮAA
ApAمA
A
AمAA
=ApAٮA  A(A  A  AمAGAQAיAA
AAAمAffA  ApAׅA׮A֣A֏\AApAAA
AAԣAՙAAAAAAzApAӮA
=AzA{AՅAGA{AA
AA{ApAA(A=qAAzAzAׅAffAA֏\A׮A֣AHAظRAApAGAՅA
=AHA
=AffAңAA{ApAQAԏ\AGAՙAA  AffAAGAA֣A
=AAGApA\)AHA
=AAָRA
=A
A=qAffAAGAAGAGA\)AQAAzA  AمAGAffAAA33AHAծAA
=A{Aҏ\AffAәAӅA{AA  AHAՙAָRAՅAHAGA33AՅA33AA  AӅAAҸRAA33AAzA(AљA(AAѮA(A  AffA=qAҸRA{AAffAQAHAQAHAHA{A33AAѮAzAzAffAA(A  AffA  AzAHApA׮A  AffAA׮AffAffA(AA(A
A
AA׮A
=AָRA{A\)A=qApAHA=qA(A
AAׅAHAQAՙAՙAAָRAӅAӅApAQAffA  ApAAA֣ApA  AAAљAGAQAQAAͮA33A
AA=qAυẠA  A33AυA=qApAGAAffAAA(ApAAׅA(AظRA
AׅAיAAAGAAGA(AffA
=A
A  AAׅA=qA\)A\)AָRAAA؏\AApAمA؏\AA33A\)AHAQA\)A
AAAzA{AәAӅA\)AzAQAzA\)A׮A33AA33A
=AأA{A(A(A
A
A=qAzAzAHAظRA
=AأAAGAA(AHAffAA\)ApA(AѮAҏ\AGA
=AУA  A
=A
=AffAHA(A\)A(A
AQAzAָRAAAׅAQAffAAׅAA
AHA؏\A(AAA  A33A؏\AمAzAڸRAڸRAڣAQA  AA
A=qAڣA
=A\)AۙAۅApA
AffAzA(A
A{A33A33A
AڸRAڏ\AAۮAAۮAۅA\)AAAA
AٙAGAAA
=AAظRA؏\AffAffAQA=qAQA=qA=qAffAffA=qAffAׅA֏\A  A(AAA{A
AՙA{A(A(A(Aԏ\A
=A  AҸRA33AӅA  A=qAԏ\Aԏ\AzAAԸRAA  AԸRAԏ\AAA{AffA֣A֣AָRA֣AHAGAAGApA{AzAظRA
=ApAGA\)AGAGAHAA=qAQAzAHAظRA׮AzAQA
=ApA
=AAָRA  ApA
=AԣA(A  A33AzA\)AHAׅAׅA׮AQA
A=qAQA=qA{A\)AծAAԸRA
AAӅAQAӮAGAӅA
=AA  AHA33AA  A33AՅAԸRA33A{A\)AԸRAffAffAffAAA33AGApA=qAAՙAԏ\A{AA  AԸRAzA(AzAAՅA\)AGAՙAQAA(AأA=qA  A{AAHAHAظRAffAzA؏\AzA؏\A؏\AׅAׅA׮AGAָRA֣AAA33AffA֣AQA{AׅA33AA33A33AA׮A(A
A֣AAzA(A  A֣AAGAGA\)AAָRAAGAA\)AԣAQA=qA{AffAәA  AӮA=qAHAAQA  A(AA{A
=A
AAHAӅAQAffAԣApApAAA{AңAHA
=AҸRA  AәAԸRA
=AA\)AA  AffAՅAzAAHA׮A33ApAָRA\)A33AљA33AиRAApAυAϙApApAzAAϙAffAQAAzAHAGA
=A33AΏ\AHAϮAHAυA\)AHAиRAУA  AHAA(AGAAУAЏ\AHA(A
=A  A  AӅA{AGApAQAAffAљA(A  AAQAңAԸRA\)Aԏ\AԣA
=AAHAHAA
AѮAzAAApAԸRA
=Aԏ\A=qA{AԸRAApA  A=qAָRApAָRA
Aԏ\AzAzA{AAAծA=qA֣AHA
=A33AGApAיAffAQAظRAffA=qA{A=qA{AQAׅAָRAffAQAQA(A33A
=AԣAՅA
=A(A֏\AAQA  A=qAHAAAGAҏ\A33ApA\)Aҏ\A(A(A{A\)AHAҏ\A=qAAхA\)AHAzAzA(AA  AzAиRA
=AЏ\AA
=AAAHAQAzA=qA(AAAУA  AzAAхA=qAAffA  A33AәAҸRA=qAHA
=AzA
=AәAQAGA\)A=qA
AծA\)AGA  AzA{A(A{A{A  AԸRAffAԏ\AzAAzA(AԸRAHA33A
AGAffAәAzAԣAAHA{A(A=qAӮAAҸRA=qA=qAԣA=qAzAѮAхAQAAңAҏ\A
=AңAAQA=qAҏ\AAҸRAffAҏ\AAHAffAҸRA
=AљApAУAУAAAϮAAHA͙AGA(AϙAљAAzAzAQAϙAHAA
=A(A(AУA
AQA=qA=qAGAϮA\)AѮAхA(A(Aҏ\AӅA33AәA(A=qA  ApAAAAҸRAAAңAffAҸRAҏ\AӮAAҏ\ApAAGAAA\)AA  AffA  AәAffAQAхAхApAиRAУAиRAAхAиRAGApAGA{AҸRA{AAQAQA=qAAzA
=AυAffA{A͙A=qAzAQAAQAȀ\AA˙A\)A\)A33ẠAͅAGA
A
AУAAQAQAѮAA
=AAzAӅA=qAәA33AGAApA\)A
A
=A  AzAQAָRAAA33AGAGA\)AGAA  AծAA(AA  A  AՙAAәAԸRA\)A\)AA֣A֏\A(A{AffAA(A=qA֏\A֏\A֣A\)A  A  A
A=qAzAA{A{A
AծAA
AA  A
AՅAՅA
=AGA33AGAAAHApAԏ\AAQA33AӅAQA
A(AңA{AAҏ\AӅA  A(AӮAffAQAAAԸRAҸRA33A
A
AәA
A(A=qAA{A  A=qA
A
=A؏\AffAAAAffAApAA
=AHAHAָRA֏\A֣AAzAffA֏\AAAAָRAAHAA֣A֣A֏\A֣AHAHA֣AAHAָRAָRAA֣AAAAAA33AA
=AУA  AAAHAAA֣A=qAԸRA33AA
=AAffAәAӮA
=AAHA  A(AAӅA  ApAԣA  AQAԸRAԣAHAGAծA
AAAՅA=qAQAzAffA֏\A֣AQAAAA
=A\)AՙAAAAԣAԣAGA
=AffAAAәAAӅAAAԣAծA
AծAAA33AՙA
ApAApAGA33A33AAAHAffAQA
=AAAffAԏ\AԣAԸRAԸRAAAӮAAԏ\AԣAԏ\AHAGAQApAAԸRAzAԸRAҏ\A(A33AңAӮAA=qAzAffApA=qA  AљA  AA
AҸRA33A
=A  AffA\)A  AHA33AיAAQAظRAAGApAٙAA(AffA{AA33A\)A\)AAAڸRAAHAAGA؏\AffA׮A
=AzA(AٮAGAGAمA\)AأAQAأAQA
=A33AzA
A
AיAApA֏\A֏\A
=A\)A
=A33AQAAA(A
AQAAQA  AffAAHAՙAAԸRA
=A{AffAAzAѮAυAGAffA(AљAA=qApA
AңApAQAQAQA  AGAәA(A(A
ApAAՙAGAzAHA33Aԏ\A=qAAffA=qA
AәApA33AәA{A{A\)A\)AApAAGAәA
=A\)AӮA\)AffAHA
AA(AQAzAGA=qAϮAzA=qApAAӮAHAиRApAͅAϮAϮAQAϙAAAAϙA{A(AA  A(AAffAffAʏ\AͮȀ\A=qA=qA{AʣA  AΏ\AȀ\A{A̸RA
AΏ\AΣAΣApA=qA{A{AAЏ\AЏ\AQA
=AЏ\AA33AQAzAA
A33AAљA
A  A33AәAҸRAAA33AAѮA
AңAAGAӅAGAAиRAzAҸRAHAHAAңAAAAAAAHA(AљAQAAHA  AHA\)AzA
AӅAzAzAAAиRA
=AQAљAAHAҸRA
AAAљA33AQAQA(AA
AӮA\)Aҏ\A33AҸRAхA(AzApAҏ\A=qAGA  AffAAzAԸRAӮAA=qA\)AAAffA{A{A
AAGAӅAAѮA
=AA{AQAffAҏ\AAҸRAAHA
=AA33AGA(AӮAGA33AGAӮA
AGAApAծAffA=qApAGAAQAӅApA{AAGAHAHAGAQAffAffAGAՅApAAAAՙAՅAՅAՅAՅAՅApA
=A(A=qApAAGA(AԣA{AAffAңA
AQA
A
AHAӅAA
A=qAffAApA\)ApAAڣAAGA\)AAGA33AHAAԣA=qAAQAzAHAffA
AϮAAΣAA
=A33A33AGApApApAυAϮA=qApAхAAA33A\)AA33AљA
AљAA\)AҸRAzAңA\)A  A=qA\)A33AAHAHAHA\)AAffApA
AAzAQAzAzAAҸRAҏ\AAәAA\)AӅAGAҸRA33AԣAzA(AA\)AՙAӅAHAffAA  A\)AAA
AffAԸRApAՅAAA
=A
=A
A{A=qA=qAffA{AA=qAՙA(A  A33AzAffA{A{A=qA=qA=qA=qAzAԣAԏ\AzAԏ\AԸRAAԸRA33A33A{A(AԣA=qAA
A  AAAGA33AApAՙAzA
=AծAծAAԏ\A(A
=AԸRAӮApAӅAәAӮA=qA
AQAӮA{AԣAA33AՅAApAQA֣A=qA=qAQAAՙA  A=qA{A{A  AAծAծA
A
A{ApAՅA{AQAffA֏\AA
=AHAHAGA׮AׅAQApAA֣AQAָRA
=AGAָRAAAAAA(AأA؏\AA
AApApA
AAمAٙApAA\)AAمA\)AA؏\A
AffApApA33AHAۅAAAAۙAۙA{AۮAۮAۙAHAمAzAffAGAGAAA{AA=qA33AڸRAڸRAffAٙAڏ\AzA
A(AAمAA{A{AA{AA  A  AAٮApApAمAHAGAծAHA(A\)A{A֣ApA(A(AأA
A؏\AأA؏\A33AHA=qAأAzA(AظRAffAffAأAA33A{A{AAڣAAzAAڸRAAA
=AzAڸRAAAA\)A\)A\)AGAGAGA܏\A
A33AGAۅAAA
A  AA
A
AGAAzAۅAGAۅAHA\)A(A(AظRA
=AיAأA{AAA؏\A(AA\)AA
=A\)AAٙA
=AAzAծA  A33A  AAA׮AظRA\)ApAAHAׅAظRApAQAڏ\AڸRAQA  AڣAAׅAָRAAGAAԣA  AәA{AԣAHA33AA
A(AzAAۮA=qA33A  A33AA33A33A\)Aڏ\AڣApA
AffAA
A{A=qAQA(A33A=qAAۅA\)A(AٙAأAׅA؏\AיA
AAHAQAA(AAAffAأA{AApA33AٮAffAAAA
=A
=AA33A=qA
AظRAAٙA(A33AAHAׅAffA\)A
=AAHA\)AٙA33A؏\AHA׮A\)A(AAHAAأAAمAڏ\AAA=qA(AzAڣAAGAGAAڣAڸRAzAڸRAzA(AڸRAAAڏ\AAۅApAAAHA33AAAAA
=AA33AڸRAAGAڣA{Aڏ\AHApAGA33AڣAڸRAApA\)ApAۅA{AQApAڸRAڣAڣAڏ\A
=AAAAAAzA
AAAڸRAffAڣAAQA\)AGA33AAمAA(AۅAAffAAAۮAۅAHAۮAAAHAA{A  AzAAAzAHA33A\)ApApAۮAAۅAA\)AAڣAڏ\AAڏ\AffAAHAAۅA33A=qAffAQAڏ\A=qAڸRAAAAA
=AAڸRAڸRAڸRAڸRAڸRAzAڏ\Aڏ\Aڏ\AAffAAڣA=qA
=AۮAQAAHAzAA(AA
AׅA\)A=qA=qAffAAծAGA\)AՙA  A{AGA  AzAAAHAمAzA
AA\)A  Aڏ\Aڏ\A33AٮA  AAظRAAffAأAAٙA  AffA  AQAAA(A=qAA  AٮA
=A(ApA  A؏\AA\)AمA(A  A  AffA  AApAA33A(A
A׮AיApAAApA֏\AָRAA
=A=qAՅAApA\)AzAHA
=A33AԣAA\)AAGAՅA(AHAԏ\AAffAffAԸRAAAGAffAӅA{AԸRApAAיAA  AA  AffAظRAGAA\)AظRA{AיAA  ApAQA  AA=qA{AӮA{A=qAԸRAQAՅAA׮ApAGA\)AAAA׮AA׮A׮A
=A
A=qAAAՅAA33A\)AծAՙAծAAAAծAՙAծAQAA
AAՙAAAծAծAA
AծAAՅAAՅAՅAԏ\A33A=qA  AңAGAУAиRA{AHAAApA{AzAffAAAzAӅApAAA
A  AҸRAѮAzAQA  AѮAУAA{AAѮA
=AApAQAHAљAAAҏ\AA=qAљAA33AӅAzAԏ\AԸRAAәAA
AA=qA{A\)AAzAҏ\AffAAѮAAffAffA  AҸRAҸRA
=AAңAHApApAAQA=qA
A  AиRAAGAAA
=AA  AϮApA(A͙AAθRAQAУAQAHAAϮApA=qAЏ\AЏ\AиRAиRAffAzAffA(AυAϮAυA\)AAGAϙApAAA33AffAffAHAиRApA  AϮAУAHA
AA
=AAGAA
=AQA33AHAԏ\AA33A
A{A33AՅAԣAffA\)AԸRA
Aԏ\A  AzA\)AGA33AffAA=qAԏ\AӮA=qA
AA{AәAҸRA=qA(A
A
AхAAхAGAљAffAAAЏ\AQAHA(AGAʏ\AͮA
A(AA
=Ȁ\ApȀ\AAиRAAA(ApAϙAA  ApAA
AffA{AQAA  AAffAԣA(A=qAAGA
=A\)A  A  AA  AԣA(AQApAљA(A\)AHA
=AAAӅAхAϙAиRAҏ\AиRA{A{AAffAffAAAA(A{Aҏ\AzAAAAAHAӅAӮAQAәAGA\)A33AAAԸRA(Aҏ\AхAҏ\A
=A֏\A=qA\)AGAGA  AңAAAA\)AA
=AA\)Aҏ\AϙAϙAAθRAAϙAQA  ApAA=qAͅA33A(AA
=A\)AυA\)A
AAΏ\A{AA
AzAGAϙAAѮA\)A
A=qA(AУA=qAffAЏ\AЏ\AЏ\AHAхAAffAffAҸRA=qAυAυAͮAυA33A33ApAAѮA=qAQA  AGAхA  A33AA
=Aҏ\Aҏ\AffA=qA
=AҸRAϙAˮA
ApA  AAApApA=qA{AffA\)AʸRA=qA{AGA{AəA(A=qA\)AA\)AHA(AAzA˅AA(AA=qAəA˙AApA=qA(AA͙AAʏ\A\)ApA  A(A=qAɮAA
=AƏ\AƣApAQAȣAzAA
=A̸RA=qApAͅAͮA=qAθRAθRA
AQAffA
=ApA33ApAHAУA\)A͙A˙AAA\)AffA{AffA
A
AApApAzAAAGA33ApA=qApAҏ\AϮAAЏ\AAʏ\AAffA
AGAǮA
AAffAA
AffAƸRAHA33AAQAŅAGAHAAǅA33AzAffA(A=qAAȣAQAA\)AʣA
Ȁ\A
AGAA\)AʸRA(A  A{ApAȸRA\)AɮA
A=qAɅAȣAȣA(AəApAA
AͅAAffAĸRA(AA{A  AA=qAAŮAǅApA=qAzA{AƏ\A33AQAA
AQA
AA{AHAAͮA(AQAAQA̸RAA
=AGAA33AəA
AƸRA  AAŅA  A
AřA  A{AAǙApAĸRAģAAAřA£A=qAzA£AÅApA  AQA\)A
=A͙AˮAʏ\A
=AAffApA  A  A{AȸRA  A33A  A(A
ApA=qAˮAA(AA\)A˙A
AAʸRA
=A˙AffAQApAHAA  A  AυAAϮAA(AA  A
A{AAAѮA
=AυA
AΏ\AAA33A33AхApA
=A  AAȸRAẠȀ\AϮAAHAΣAA\)AA=qA˅A
A\)A
A33AGAʸRAzAQA33AʣA=qA
AzAffA
=AAHAffA
A
=AAɅAAffA  Aȏ\AffAQA\)AGA(AffAˮAzA(A33AAGAzAQAQAЏ\A{A  AHAffAzApA{AffA
AAQA(A{A\)A=qA
A33AəAAȸRAA
AA
ApA
AzAGA(ApAʣAA˙Ȁ\AȸRAGAAA{AȣAHA˙AɮA
AȸRAʏ\AA(AQAAffA33AQA
AƸRAQA
A
AŮAřAA
AǅA\)AGAAA\)A˙A{AΏ\AAGAѮA  AəAA
A33A̸RAzA  AGA
=ApAәAA  A  AffA{AQAθRA33ApAAffA{A33A
=AffAzA=qA=qA˅AGA=qA\)AGAffAƏ\A  AGA=qAAȣAQA33AϮAGA
AA
A{AHAffAΏ\A33A{A  A
=AAθRA{AȀ\AGA  AQAυAϮAAθRAͅAHA̸RA
=A33AzAAGAHAGA33AAϮA  AzAAυAͮA33AɅȀ\AQAzAGA{A
AA\)A  AхA  A=qA
=A33A=qAAGAAzAGA
AHAƏ\AAGA{A(AGAA
A
AHA
=A(AAȣA
AʸRA
=AQA(AAGA͙A(A˅A\)AAzA=qAAzAAGAȀ\A
A(AAffAGApAAǅA33A{AəAA=qAʏ\A  A̸RA(ApAHA{AzAθRAA(A
A
A\)AʸRAHAHAȣA{AǮAAffAAA{AAƏ\AA  AA{AA
A\)A
=AẠAϙApA
A̸RAffAHA(AA
=AzAυA˅AzAzAHA  A{A33AzAHA\)A  AzA͙A{AA
A\)A{AAΏ\AΣAffA
A33AHA(AA33AA  AУAffAzAffAУAиRAϙApAʣA=qAθRA(A33AA{AΏ\AθRAGA
AAA(Ȁ\A  A
AQAA˅A
=AA33Ȁ\A\)A=qApA˙ẠA
AA
AA=qAиRAУAffAzAAGAzAȸRA33ẠAQA(A(A˙ApAA
AzA33AHAθRAУAQAffA
=ApAffA
=A=qAAΏ\AA=qAA{A{A͙AθRA33Ȁ\Ȁ\A=qẠAHAGAGA
AAͅAGAͮA
A͙AA{A{A  AffAQA
A͙AͮAͮA
=AzAAzAA(AA(ApA=qA=qA  Aȏ\AAǙAǙAHA\)A33A
=AƸRAAzA=qAA33AQA33A(AGAHAA
=AˮA
A
AA=qA(AQȀ\AzẠẠA̸RAͅA  A(AɅA\)A=qAəA\)AApAHA=qAAHA̸RAHA=qA{AffA\)A(AffA
A=qA\)AzAGA
=AAϮAGAA(A  A  AAAAHAA
AУAffAхAѮA(AA=qA{A  AљA{AGA33A\)AGAљAGAϮAA=qApA\)A  AиRAzA33AA=qAAAA  AApAffA(A
A=qAQAQAffAGA33AA͙AAAzAAϮAHAAхAљAGAGAљA  AQAAУAffAGAAHAхAffAҏ\A=qAAffAA\)A=qA
A=qAAԣA\)A
A\)AAHA  AQA  A(AծAApApApAיApA{A33AHAHAָRA  A
=A\)AӮAңAљApAљA=qA
=A
AծA
AA(Aԏ\AzAQAԸRAGAApA{AA\)AQAҏ\AAAA33AAAA
A\)AϙAzA
=AхAGAA
=A  ApA  AΏ\A  A
AQA{AGAA
=AHAϙAЏ\AϙA\)AͅAΣA=qA33AʸRAAzA\)A\)AAHAAHAΏ\AAϙAϮAApAυAAңAAУAәA=qA(A  AzAңA
AУAffA=qAzA  A{A  AGAљA
A  AA
=A
=AA33AffAA
AHAGAͮAͮAϙApAAHAHAffAЏ\AA(AθRAAəAHAAQAƣAARAA(AQAA{ARA=qAA\AA33AAA\AARA=qAAA33A
A\AA
=A
=AAAA
=A
=AA  AARAA{AAzA(AAGApA
=A\A33AA
AffA
A
A\A
=AA{AAGA33A
AA
AAAAAA  AA=qA
ARAAGAzApAQAAA(ApA\A
AA  AffA(A\)AApA
A\)AQAQAAQA=qA\AAAAAAzAAA(AAAQAzA33AQAQAA33A\AAAA\)AAAGAzA\AA  AAHAGAA(AA  AHA33AAARAAApAQA\AffAA=qAAQA\A\)AA33AAA\AAAA\)A\A  AAA  A{AAAA=qAAA\)A(AzA
AAA  AA(AAAzARA
AA=qApA  A  A{AAffAzAAGA{A\A
=A=qA(ARAzA
=AAAAA\AA\)AAA\AffAzAARAARAzAzAffAffAQA¸RA=qApA33AƸRA33AƸRA33AŮAHAHA
=AGAA{AzARAAAƣA(ARAAřAȣAAʣA  AȸRAGAəA\)AAA33AA33A=qA33A
AƣAGAAǮA{Aȏ\AffAǮAA
=AffA
A  AȣAAŮA
A  AzA  AzA=qAəAȸRAQAAǙAGAǙAGA
=A
A\)ApA
=A{AŮA(AîAHAAA33A\AGA£A
AřA=qA\)A{AAHAAǙAGA(A  A(AǮAA33Aʏ\A
Ȁ\Ȁ\AˮA(A  A
AƣAzA{A\)AAA  AzA33AQA
AAA  A  A33AA(AQAGAzAřAffAA
AAA  A(A{A  A=qA(A
AA
=AAA{A{AQA=qAffAQA
=AGAAAAAA
AAA33A\)A
=ApA(AA(A=qA=qA
=AAAA=qAAffAA\)AQAA=qAA\)ApA\)AAAAQAffAffA{AAAAAA\)AzAGARA(AA  AzA(AA
=A\AQAzA{AAARA  AQApAÅApAA33AHA  A\)A33AAA
ApA33AQAA\A{ARAAGAA(AzA=qAffA\)AAQAAAGA  AApAAA
AGAAHAAAGAA
ApA
=A{AffAA
A(A33A\ARAAAA\)AAAAzA=qAAAGA  AA=qApA\)A33AAffA\)ApAAffAƏ\A
=A  A(AAŮA¸RA33ApA=qA33AÙAAA  A
A  AAAAQA=qA(AAA=qAGAAģA
=A33AîA
=A=qAA\)A33AffAApAGAAffA  A=qA{AHA  ApA
=A  AA
A
=A{AHAAA=qAQA\)AffAAHA\AAHA(AHAffA
=AA
AAAzAAA=qA=qA
A
=A  AGAHA(AAffAʸRA33A
=A
AˮA
A{Ȁ\ẠAQA̸RAffAzA˙A
AAAʸRA  AʸRAʣAȸRA{AA\)AffA(AffAzAQAAŮAʸRA=qAA˅ApAəA(AƸRAGA\)A(A£AffAHAzAGA  Aȏ\A
AA33AɅA(A  A33A
=A\)AHAQAȏ\Aȏ\AA  AřAzAzA
=AŮAģA  ApAA  A
=ApAzA
A33AAGAHA33AGAffAGAzAQA
AƸRApAǙA=qAzAHAəA
=A\)A\)ApAˮAA=qAzA
=AffA{AAQAA\)A=qApA{AAAAģAȀ\A{AzAʸRA
=AA=qA33AGAAAЏ\AΏ\A(AGAЏ\AϙAffA=qAͅAɅA  AQAřAGAGA  AƸRAQA(Aȏ\AA  AffA˅AA(Ȁ\AAHA
AA{ApApA{AǙApAAApAAŅAƣA(A=qAǮAĸRAAQAƣAǮA33A=qAA33A
A=qAApApAəA
AffAGA=qȀ\AffA(A{ẠA33AɅA33AGAHAϮAffAA{AAAA
AHAzA  AAAAΣAAGApAȣAʏ\AƸRAřAAGAA33AHAAϙA
AA  A\)A=qApA33A
=AffAAȣAǅAAȣA(A{AɮA  A˅A
=Ȁ\AʣAzAffA33A̸RAAAA(ApAA  AÙA  A{A
AƏ\ApA
=AˮA(AA  AAAA
ApAApAAAffA
ApApAAffAHAA
ApAˮA{A{A=qAQA=qẠA̸RȀ\A˙AA
=AɮAɅApAzA
AffAQAAAffA\)A  AAȏ\AǙA
AHAAʏ\AɅA(AʸRA
A\)AȸRA(ApAǮA{AQAȸRA
=Aȏ\AGA\)A̸RAͮA=qA33AAA͙A33A
AA
A˙AzAAAÙA  AAAHAȏ\AzA(A=qAA(AHA33AHAAģAĸRAA\)AQAHAAGA
AAzA  A\)A
=A
A
=AͮAzApAGA
=A
AΣA(A\)A  AGAQAAA(AQA͙AffAHApA{A  AʸRA{AAˮA˅AApAA33AzAυAљAȀ\AHAffA̸RAA
AzA\)A  AAHAʸRAAAffA{A  AŮA  AffA\)AƣAAəAGAHApA33A(A˙A  AAGAffȀ\A\)A  A
=AϙA\)AHAиRAϮA\)AЏ\AHAQA{A(A=qA=qApA  A
AиRAAzAAυA
A=qAffAУAzA33A=qAQAϙAQAHAAAAљAA{AzAffAиRAA{A  A
ApA  AHAffAzAQAЏ\AAθRAGAA  A=qA33ApAA
AQA(A(AGAGA
=AΣA=qA͙AzA
=AˮAA͙A˅AAƣẠApAəA33A=qA33A
AΣA
=AGA{A˅AA(A̸RẠA33A͙AΣA͙AAApA
AͮAzApȀ\AffA(ApA=qAzAffAA
=A
AffA  ApAѮA  AңAffA
=AQA
AҸRAAҸRA  A
=AθRAA{ApA(A
A\)AAHAυA  AЏ\A(A\)AͅA  A  AAͅAA{AAͅAGA\)AͅA͙AΣA\)AAAA=qAQA(A
A33A
AzAͮAAffAƸRAffApA˅AˮA
A33A(AAɮA
AAQAQA\)A  A(A33AA˙AAA33AzAGAQA(A=qA̸RAʸRẠȀ\A(A̸RAAAυA(AУAиRAиRAиRAffA  AA(A\)A\)A{AzA(AУA33AљAљAAӅAAәAHA{A=qAҸRAңAҏ\A
AәAAA{AQAѮAAzAHA
=A\)A(AAA
A
AffAA=qAAУAυAAΣAzAͮApA
=AͅAͮA
AQAAffA33A
A{AGAͮApAQA
AϙA{AљAA\)Aԏ\AԸRAӮAGAHA\)A
AGAzAϙAΣApA  ApAυA(A  AffAAAGAӮAQAԏ\A
=AՅA  A\)A=qA=qAAәAҸRAљAffA33AәAӮAӮAԏ\AՅAծAGAәAffA{AӅA
AәA
A\)AӅAffA
AAA33A  AAӅAӮAAzAHAHAAѮA=qAѮAәA33A33AzAzAGAzA\)A33AϮAAAΣAQAAΏ\AffAA  ApAϮAϙAffA  AϮA=qAGA(AA  A=qAQAAzAAQA
=AυAHAͮApApAAzA
=A̸RAAA̸RAGȀ\A
=A͙ẠAAzA{AffAffAˮȀ\A
A
A
A=qAͮA(AͅAAGAQA͙A(ApA{A͙A
=A(A33AffAҸRAΏ\A33AffAͮAffAGA̸RA
AˮAˮA  AGA\)A
AApAGA̸RA
A33A
AGAǙAȸRAƏ\A(AQApAAAǙAǙAA(A
=AŅAȣA33AzA
A˅AAɅA=qA33AͅApAAAәAA  A(AHAңA=qAGAхAѮAAУA(AиRAAΏ\AApA̸RA˅AHẠAGA33A33A(AA(A(A\)AGAGAGAA(AHAͮAAzȀ\AA=qAffAzAˮȀ\AQȀ\AA33AzAHAffA
=Ȁ\A̸RA͙AAͅȀ\A̸RA˙ApẠA
A33A  AHAA\)A=qAAͮAA(AAffA\)AA=qAGAȀ\AQAffAA=qA  AA=qAǮAəAHAɅA
A  AʸRAǮAGAŮAřAA  A=qAQA=qA
=A(A
=A͙AΏ\AAHAθRAΣAAzA(A{A{A{A(A  A33AffAAϮAAAͅAGAHAAA=qAQAAAθRAAAΏ\AθRAϙA{AAffA  ApAffAQAϙAQAA{A͙AGAAHAA̸RAAHȀ\A
AAffAHAHAʏ\AAffA  Aʏ\A
=A{AAA  A
AQA{AHAffA(AθRA{ApA(A{AҸRAHAAGA=qAApA\)AϮA{A
=AΏ\AAGA33AQẠAffAAffA33A(AHAHAAAϙAGAϙAϙApA
AȀ\A
=A  A33A
=A33AAA  AA=qAиRAzAHAϙApA(AzAAGA\)AθRApAA
AΣA{AθRAΏ\AA
AGAAAЏ\AиRA(AAA\)A̸RA\)AA˅AA=qAffA33ApAQA  A33AA33AͅA(Ȁ\AəAȏ\AȣAŮApAQA  A33A
=A(AHAQA=qAŅAƣAAƸRA
A(AAGA˙A(AA
A=qA  AffAApA˙A=qAffAzAQAffAA  AA(AGAAʸRAAffAẠA̸RA͙AA(AzAHAA
ApAʣAA{AQAAffAˮA͙AffAͮAAA  AAͅA\)A
AffAϮAAHAʏ\AΏ\A˅AAzA
=A(AɮAȣA33A  A{ApAɮA  A(Aʏ\A˅AHAzAA  A=qAzAffAQA
=A  AGA(AHAʸRAA˙AzAA  AAGAzAəAzAzAHAffAȸRAȏ\AȸRAGA(Ȁ\A33AAAQAAAHAQAA{AQAAAAffAzAΏ\AθRAzA33A\)AffAAA\)A{AAϙA(A
A
=AυAQA\)AϮAQAAzAHAffAʣAApAAffAHAQAəAGA(A
AəA
AAzA=qA
=ApApAAͮA\)A
A33AGA(AA=qA\)A33AAQA33A(A͙AͅAAθRAzAЏ\AffAAffAУAAAЏ\A
=AѮAzA
=A  AхA=qA{AQAA(AffA(AAA=qA=qAУApAA
=A33Ȁ\A=qA33AA{A(AAA̸RA(ẠA33A(A33AQAffAAGAͮAͮA
AzAGAHAA=qAAHAиRAffAHA=qAϮAхAffAϮAA
=A
A(A  AAAΣA
A{AAθRA\)A=qAAAəAAʸRAHAAQAHAGA  A  A
A{AffAƣAAA
=AƸRAA{A
=AȀ\A  AQAΣAQApAAQAиRAϮAϮAAffAzA=qA(AͮAHAAУAAУA
=A\)A=qA  AΣA(A
AGAϮAAGAzA=qAAAҸRAҸRAҏ\AAAиRAθRA(AAHA
A{AApApAAхAGAApAHAЏ\A
=AѮAQAAAңAЏ\A{A=qA\)AQA{AQA  AϙA(A
AQAʏ\AA(A  AΣAHAHAAAυAΏ\A͙A
A(AQA\)AϙA\)AAəA  AQA33A{AɅA33A{AɅAHAQA̸RȀ\Ȁ\A\)AzA  A̸RA=qA{AffAGA̸RA=qAQAAAzAQApAθRAHAΣAΏ\A͙AffA
=A
AAzAA\)AApAϮAHAHAGA  AΏ\AͅAHẠA
A{AA{AA=qAɮA=qA\)A\)AAAɅA
AAQAAA33A
AəA(ApA(AGAɮA˙AffAffA{A(Ȁ\A
=A(A̸RA(AȸRȀ\AA\)A˙AAAʏ\AHAʸRApA=qA\)A{Ȁ\AzA
=AAΏ\A=qAHAA̸RA(AˮAAʏ\AAʣAʸRAʸRA{AʣAA(AAAAHA33AAɅAɅA{A˅AGAQAʸRAzAəA(A(AHApAʸRAQAzAAzAA
=A
AɮA
AAA\)AʣA(A\)A(A
ApAAˮAAˮAŮAʣA\)AAΣA=qAffAQAAǮAAGAQAȣAȏ\A
=Aȏ\AȸRA=qAȏ\AʣA33ApAGA\)A=qA  AɮA=qAȏ\AzAAHA\)A\)AApAɮAA˅Ȁ\AAʏ\AȀ\AAQA˙AQAĸRAẠẠAA\)A\)ẠAA\)AˮA  AȀ\AA
A(AzAʸRAʸRAʸRA=qAGA33ApA
=AAʣA  AAǅA(ApAzA\)AAzAffAA  AAA\AARA
A\AffAAQAAAffA(AAHA
AA
=A(AzA
=A  AApAAA{AAGAffAGA=qAARAARApAGA(ARA{AQARA\AAzA=qA=qAQAAzA\A  A(A{A\AQA
=A{ARA=qA{AAAA{AARAGAAAzARA{ARA=qAAARApAGAA\)A=qA=qAA\)AA\A\)A
=AA33A{AAApAAAQAAA
A\)AGAAA  AA
=A=qAAAAAAAAGAA
AAA
=A\)A33ApAAzA\)AAffA
=AGA{A
=A\)AAffAQA(ARAARA\AARA33AQAAAA
A\)A
AAffAHAHAAffAGAAA=qA\AA\)AGA
=AA{AAA=qA  ARARAAHA
=A
=A  AA=qA{A\)A
=AffA\AAApAAAA33AA(AAA=qA\AAAHAAffAA
=AGA  ApAA{AffAAQAAGAA  AAA=qAHAApAQA(AAAA
=AAA\)AffAAffA
ARAAHA
AA
=AA
=A=qA(AAffAA
A(A
AARA{A
=AA\)A
=A\)A{AA\A33AGAARAzARA=qA\AAAA  AA{AQAAHAAAzA{AAzAGA\AHApA=qA  ApAHA{AAÅA(A=qA\AApA
AffAHA
=A  AA\AAAApA=qARAAA
AHA=qA  AffAzApAAffAQA=qAzA
=A33AzAHAGA\AAffA¸RAAA33AffA{AĸRAzAHAGA33A
=AŅAHAA£A\)A¸RAAzAzAģAAA  AAGAA\)A
A=qA
A
AHA33AA
AA
AAAAQAApA£A{A(AA  AzA  AŮAŮAHAAŮAƸRAffAHAAď\A33AƣAƏ\AHAřA=qAƣA(AQAQA(A{AŅAŅA33A
=A33AÅA=qA33AƸRAȣA{A33A  AHAď\AA
=AzAAAȣAȣAAGA  AǙA  A\)AA(ApAGẠAzA
A˙A\)AQA{AəȀ\AQAAAffA
ApA\)A
AA
A{AAǅAȸRA
AģA33AAÙAA\)Aď\AGAQAÙAřAGAŅApAApAHA(AƣA  A=qApA33A33A  AƣAƏ\AAA33Aď\A=qA¸RA\AAŮA(A
=AƏ\AǅA=qAȣAHAȣAGAA(A(AzA\)AA\)AͅAHA
AͅAApAA(A{AAŅAAzA{A
AAffA{AAʏ\Aʏ\A
=A33A͙A͙AΏ\AϙA33AAȀ\A͙Ȁ\A=qA(AʣA  AȸRA\)AffA  AGA
=AzA  A{ApA
=A  A{A=qAřA£AAAƏ\AHAGAƏ\AAɮAHAƏ\A
A  A  AA=qAffAQAffA  AzA\)AAHA  AȸRAAƏ\AzApA  A
AȣA
Aȏ\AHA=qAQA=qAQA=qAǮA{AHA  AŅAA
=A33AƸRAȸRAzA33A=qA(AʸRA
AɅAAǙAAǅAA33Aȏ\AQAȏ\AA
AȣAȸRA  AǅA
A33AA
=AAffAffAřA(A33ApA(AģAƏ\A
AffA=qA
=AǮA=qAzAAA\)AƸRAřAAƏ\AA
=A\)AHAAAffAAAŅAAAAģA(AQA=qAď\A(AAȏ\AGAAAřAAŅAA{AffAƏ\AAffAřAGApAAHA  A=qAΣApA
AQAffA
=AA  AApA33AȸRA(AǮA{AAAzAͅAHA͙AAAȸRA
=A  A33AffAɅAQAȣA  AǮA33AGAGAQAŮAAQAŅApA(AŮAAA=qAAŮAAAAzA
=A  A
A
=AQA(A\)Aȏ\AApAGA{AQAAɅAȣAAA33A
AzAŅA
AƸRAGA
=A  AAAffAzA33AǅAffAƣAƣA  AǮA=qAzAȏ\AA{A=qA{A
A\)A\)AĸRA  A£A\A\AGAAHAA
AQAzAAzAÙAA
=A33A
=A{AffA\A
=AAffAA  AA\AHA{ARA\AAAAAffAGAA\)A
ApAA
=A  A
AffAA
A=qAQAģA33AffA(A(A
AîAA(AGAĸRAģAď\AîA{A
A\AAAƸRA  AHA\)AǮAAffA
=AA
AzA(AɮAA
ApA33ApAAAffAAɅAəApAAǮAzAəAGA{A(A{AAzAGAƣAffAHAGAGA  AzAzAHAzA(AQAAAA  A33AHA{A
AAA=qAzAǅAƸRAAǅAAA  AAĸRAA
=AzA
AA{Aď\AĸRAffA\)A
AAffA\)AAŅA  A{AŮAŮApA  AAǅA˙A˙AGA{ApA̸RAAHAApAϙA33A
A(ApApA\)A̸RAHA=qA\)AHAA
=A\)AGAA̸RAA{AȀ\A33A=qA˙AAA
=AHAHA  AA{A˅AffApA=qAAffA\)AA  A33AzAGAA
=A
=AA=qA
A\)Aď\AAffA£A{AƏ\AffAAAA=qAA{A
=A{AffARAAffA{AAA\AAGA£AQAɮAA33AǅAǙAAGAǙAAȣAA{AAAGAQA
A  A=qAHAHA\)A
A  A  A=qAffAHAQAGAAɮA  AAGA=qA(AǙA  A(A(A{ApAȏ\A=qAƸRAA\)AzA
AȸRAȸRAQA
AɮA33A(A{AGApA
ApAɮAAʸRA(A{AQA33AAzA  AHAəAȣA
=AAAƣAAffAzA
=AAA(AzAÅAHAď\AffA
=A
AřA
A\)AffAƸRA
=A=qAȸRAzAǙAAAAA{AA33AAƸRAƸRA33A=qAǅA(A\)AřAƣAȣAHAɮA{ApApAHApAHAȏ\AGAzA33A  AəAHAɮAApAQA  AffAA
=AGAQAHAzAA(A(A(A\)A{AřAGAřA{AHA£A¸RA¸RAA  AHAQA£AAAƸRAAzA(AffAffAîA¸RAA¸RAŮAQAffAGAÙA(AAAzAGAQAģAAƏ\ApA=qAȸRAƏ\A\)A=qAGAƸRA  AA                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                                              